﻿USE sofia;
DROP TABLE IF EXISTS sofia.kvg_vpl;
CREATE TABLE kvg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kvg_vpl WRITE;
INSERT INTO kvg_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Qàgoám. Ta khøuwa-te ndøgo, manqa ovøyam megetapak Izlael manqei gimbo-kewagam, vikia sekeqape ndømát. Yaq Betliem vemiav-te ndøgo, Zuda manqei-te, ezoqa kopo mø̀ndøyagám. Yaq ngenek ezoqam Moab manqei-té genøyág, zas neka nakhei angana menas namba. Zapa ndǿgo, Zuda manqei-te ndøgo, lou mbaín. Vikia sekeqape ndømát. ");
INSERT INTO kvg_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Ngenek ezoqam, teqa iz Elimelék. Neka zas-qa iz Naomí. Neka nakhei angana-qa iziz nqánek, Malon neka Kilion. Elimelek, ndego Eflat khagua bawan-ák. Betliem vemiav-té geyagám, ndøgo Zuda manqei-te. Yaq geyag, ndǿgo temøqóm, Moab manqei-te. ");
INSERT INTO kvg_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Yaq Moab manqei-te giyagam, Elimelek gènaním. Yaq Naomi neka nakhei angana menas sègezuváz. ");
INSERT INTO kvg_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Nginik nakhei angana menas Moab sakheis ndøzøkɨ́m. Sakhei gizøkɨm, tiqa iziz nqazǿgo, Opa neka Lut. ");
INSERT INTO kvg_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Naomi nakheis namba, Moab manqei-te guyagam, viav ande āv tén ndægó. Yaq vaev até ndigú-a, nakhei menas, Malon neka Kilion, vø̄pakhaez. Yaq Naomi yakhapús segeyagám. Zivis mbaín-a, nakheis mbain. ");
INSERT INTO kvg_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Yaq Naomi Moab manqei-te guqotam, manqat āv guni-ewág nqǽgo, *Yawe ekeza ezoqam nqawa mø̀ndøzø-tøké, lou-qa yaq-te. Yaq ndugu matavap āv gunivé nqǽgo. Ekeza manqei-té gunǿqaván. Yaq ziupim-pakha-za namba gigiap vø̄khakheinam, ");
INSERT INTO kvg_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","manqei ndøgo sasa ndø-ivøvem, ma gi꞉yagam. Yaq ndigu tinø-qavanát ndǿgo, Zuda manqei-te, ziupim-pakha-za namba. ");
INSERT INTO kvg_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Geté ate av-té gi꞉-apat, yaq Naomi nginik ziupim-pakha-za guzø-ein, “Zøkeza zøvøndipakha-té qazonǿ-qavøním. Zo matev mbomømbomá qazogoam no-te neka zogi zøivis-pakha-te, ndigu gipakhaez. ");
INSERT INTO kvg_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Yaq Yawe matev mbomambaqape ndø̀matanám zo-te, neka yage eqeieqei vøzǿ-etoām, angana ndakinak namba.” Yaq Naomi ziupim-pakha-za menas sègegavém, sasa ndø-eivam. Eiv gèzømbo-eqavát. ");
INSERT INTO kvg_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Yaq ziupim-pakha-za gindu-einim, “Tiá. Ni qo namba, qogí ezoqam-té qazinǿ-niáv.” ");
INSERT INTO kvg_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Geté Naomi guzø-ein, “Nogí sæ-pakha-za. Zøvøndipakha-té qazonǿ-qavøním. Gekha zapâ, no namba tiziniav? Ge zô ndozo-matavap? No nakhei angana nøme ndønǿfakhaz, zo vǿezøkɨ̄m? Mbaín. ");
INSERT INTO kvg_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Yaq nakémbá. Zo vø̀qavøním, zøkeza zøvøndipakha-te. No khàpe-nøte-ngæpuka-én, anganeam nøme vøténdāf. Até ndøgó-a, no nqægo lova anganeam ndakinak tændaf, yaq nakheis tinøfakhaz, ");
INSERT INTO kvg_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","yaq ge zô, viav kopoav ndozotó-kewagat atema nginik nakheis vumúfīs? Ge zô, ngængæm até ndozóyagat, atema nogi nakheis zo vǿzøkɨ̄m? Nogí sæ-pakha-za. Āv taoká. Noqa yage mø̀ndøsoqá. Yawe gènøngiú. Geté zo kopømbaqapé, yage ndakinak nqawa tozomø-ndapem. Yaq nakémbá, zøkeza ezoqam-te vø̀qavøním.” ");
INSERT INTO kvg_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Naomi nqanek manqat gu-ein, yaq ndigu nangó ginø-eivám. Yaq Opa até gundigu, zakhapuka-pakha sège-møvøiú, ouo manqat vømbō-ein, sasa ndøwav. Geté Lut sègeqóm, Naomi namba. ");
INSERT INTO kvg_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Yaq Naomi gundu-ein, “Nqáe! Qoge qakhapikia-pakha-gu zas, ekeza ezoqam-té neka mbumbuk-té gunøqaván. Até qó-a, qakeza ezoqam-te vø̀qaváq.” ");
INSERT INTO kvg_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Geté Lut gundu-ein, “No qavønim-qa yaq-te nøpòuwe᷄t. No qó namba nøténáv. Qo ande āv khoqotéqāv, no ndǿgo tøtǿnáv. Qo ande āv khoqoté-yagāt, no ndǿgo tǽyagát. Qogi ezoqam, ndigu nogí ezoqam ndǿgoát. Neka qoge Mbumbukiam, ndego nogé Mbumbukiam ndǿgoát. ");
INSERT INTO kvg_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Qo ande āv khoqomé-naqanīm, até nó-a, no ndǿgo tæmǿnaním. Neka no ndǿgo tǽ-otambát. Ni løvøte mbá mé꞉qatanó. No manqat av nqate-manqate, matanapøteav tøgoat, yaq Yawe kopømbaqapé. Bèngiænó.” ");
INSERT INTO kvg_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Yaq Naomi guqeiv av nqægo, Lut matavap mø̀ndøgō, tu namba tu-iwav, yaq ndugu manqat nøme einiáv. ");
INSERT INTO kvg_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Yaq nginik sakhei menas sègezáv, atema Betliem vemiav-te vømø̄fakhaz. Yaq Betliem vemiav-te gimøfakhaz, ezoqa ate gi꞉goam nqova zøndáf. Ti-mbá tiwabám. Yaq sakheis vemiav-te gigoam ndøgo, āv gini-akhaém nqǽgo, “Gê, ngunuk unimanqatîn, Naomì?” ");
INSERT INTO kvg_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Geté Naomi guzø-qavøiu, “No Naomi nø-akhàya᷄m. Taqa manqa mokho, ‘Yage qanimāv’. Geté Mala zonǿ-akhaemát. Taqa manqa mokho, ‘Yage soqaín’. Zapa ndǿgo, ndego Mbumbukiam Bazaføgakh-Qape noqa yage gènøngiú. ");
INSERT INTO kvg_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","No bugukhokhof nqanek manqei ande qate-ivav, no anganeam-ús neka nakhei angana-ús. Geté Yawe ndakin no nqawa gendo-itumb, nqanek manqei-te, no anganeam mbaín, neka nakheis mbain. Gê, gekha zapâ no Naomi tozonø-akhaemat? Yawe noqa yage mø̀ndønø-ngiú.” ");
INSERT INTO kvg_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Naomi tugu ziwap-pakha Lut, ndugu Moab ezoqam, tu namba Moab manqei gindi-ivøvem, atema Betliem vemiav-te vømø̄fakhaz, ta khøuwa-te ndøgo, bali vingisam viav ndø-ogitát. (Bali ndigu loge gigiáp. Tiqa bugug andé eketóp.) ");
INSERT INTO kvg_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Naomi ekesu mø̀ndømbo-goám. Teqa iz Boáz. Ngenek tugi zivis-pakha Elimelek, tegé ekeza ezoqám. Ngenek ezoqam gigiap kopoav ezoqám, neka ndego iz-akhaé. ");
INSERT INTO kvg_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Yaq khøuwa nøme, Lut, ndugu Moab sævam, Naomi gumbo-ein, “No ambá khae-té qatønavɨ́n. Yaq bali khakhayakh ndigu, ezoqa tizuvatet, tæmǿpisám. Ezoqa nøme tanakh ndø̀nøgó, vønǿ-eīn.” Yaq Naomi gundu-ein, “Sǽ-pakha. Qanimáv. Vø̀qáv.” ");
INSERT INTO kvg_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Yaq Lut tunøwáv ndǿgo, khae-te, bali khakhayakh vømø̄pisam, ndigu sasae ezoqam gi꞉qogavat, gi꞉zuvatat. Geté ndugu mè꞉-otevák av nqægo, nqanek khae Boaz-qā, ndego Elimelek-ge ekeza ezoqam. ");
INSERT INTO kvg_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Ndugu ate av-té bali khakhayakh guipisumat, yaq Boaz tendowáv ndǿgo, Betliem vemiav-te, tegi sasae ezoqam khanakhanakh manqat vøzø̄-ein, “Yawe ndø̀goát zo namba.” Yaq ndigu sasae ezoqam gindu-einim, “Yawe zenda ndò꞉vé qo-te.” ");
INSERT INTO kvg_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Yaq Boaz Lut gu-omet, yaq ndego ezoqam, sasae ezoqa gezø-kewagat, āv gembøebeváp nqǽgo, “Ndugu gekha mbasønakâm ndunduya?” ");
INSERT INTO kvg_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Yaq ndego gendo-ein, “Ndugu Moab manqei-ak mbasønakám. Naomí namba me꞉geavún. ");
INSERT INTO kvg_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Ngunuk no āv gunømbe-eín nqǽgo, ‘No ambá bali khakhayakh nopisamɨ́n, qogi sasae ezoqam ndi꞉zuvatet.’ Ngunuk qanaqanus-qape sasae gungaz atema ndakin, pusa-qase agé taeveáv. Khoev-qase-te ndøgo, khapémbá gumøqomɨn, nango é-vø̄sasaeɨn.” ");
INSERT INTO kvg_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Yaq Boaz nqanek manqat ge-ewag, ndego Lut āv gembøe-eín nqǽgo, “Sǽ-pakha. Qotøndé-ewāg. Noqa manqat nqánek. Qo ezoqa nøme-qa khae-te ndø̀qa᷄v, bali khakhayakh voqomǿ-pisām. Geté sa nqánek, qoqógót, nogi sasae mbasønakheis namba. ");
INSERT INTO kvg_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Gèzømeté, nogi sasae ezoqam. Bali av kini-qogavet, mbasønakheis até vøzøpáev, ndigu ndiløvønøvemet. No angana manqa mø̀ezø-løvuá. Qo matev-qase geqá-gonemák. Yaq qo ibøkha naq taqapap, ibøkha vø̀mø-íz ndøgo, angana giziøvemem.” ");
INSERT INTO kvg_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Yaq Lut Boaz-qa manqat mbomambaqape gu-ewag, ndugu até gundigu, katuk gumø̀kuī, teqa megemege-te, sasa ndøkhafutav, kawa até manqei vømbō-khanaz. Yaq gumbo-ein, “No manqei vini-ák. Geté qo tanakh kandambá qoqonøgo.” ");
INSERT INTO kvg_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Yaq Boaz gendo-ein, “No manqat ate ndægo mø̀e-ewág, ndøgo qogu qakhapuka-pakha-te matev mbomømboma ndoqombogo, yaq qævis vøndēnanim-a, atema ndakin. Qavøndipakha neka qakeza ezoqam-qa manqei mòqotøndo-iváv. Yaq qo ndakin nqánek qoqoyagé. Geté bugukhokhof niqa bawan qateqateáv. ");
INSERT INTO kvg_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Qo Yawe yaq-fia ndø̀qagó, av qo matev eqeieqei qoqotego. Yaq-fia kandambá teqago, ndego Izlael ezoqam-ge Mbumbukiam, qo tøke-qa qoqotøndoqav te-te.” ");
INSERT INTO kvg_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Yaq Lut gundu-ein, “Khanánqa. No ezoqam khapúmbá. Qogi sasae mbasønakheis mø̀ndømø-løvumbumím. Geté qo tøke kandambá nqoqonøgot. No khanakhanakh kandambá, qo nqanek manqat qoqonø-ein.” ");
INSERT INTO kvg_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Yaq khøuwa muin, lou loge khøuwa qandap ndøgo, Boaz Lut tùmbøe-akhá, “Qotøndéqāv. Lou qólóg, neka lou yaf-te voqotú-afanām.” Yaq Lut Boaz-gi sasae ezoqam namba gi꞉qonav, Boaz bali lonqotøvap mbo-etoám. Gulouz, qambo-ewez, nøme sègeziváz. ");
INSERT INTO kvg_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Yaq Lut lou gumulog, gu-itan neka sasae manqei-te nqawa guwav, Boaz ekeza sasae ezoqam manqa āv gezømbe-løvuá nqǽgo, “Ndugu mbasønakam mbøe-khafène᷄m. Até ndøgó-a, bali løvøtap ndi-abap, ndugu kopømbaqapé bali khakhayakh tupisumit. ");
INSERT INTO kvg_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Geté bali løvøtap ndi-abap ndigu, nøme zó-ovobém, neka manqei-té qazonǿ-abømém. Yaq ndugu kopømbaqapé tupisam. Manqat mbo-eìni᷄m ta zapaya.” ");
INSERT INTO kvg_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Yaq Lut bali khakhayakh gupisumat, até vømø̄khagus. Yaq bali nanga tag gukoqogimat ndøgo, andé kandambá gunqeitaz, ava-te. Ande āv 10 kilogrém ndægó. ");
INSERT INTO kvg_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Yaq bali nanga gumokhopez, vemiav-te guqavan, zakhapuka-pakha gèmbozømét, gimbogoam. Yaq Lut bali lonqotøvap ndigu, khøuwa muin guizivaz, qambo-ewez, zakhapuka-pakha vømbō-etoam. ");
INSERT INTO kvg_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Yaq Naomi gèmbøe-ogofám, bali nanga khape-gimbøe-khouwez, gumbobevap, “Nginik bali nanga gekha ezoqam-qâ khae-tē qoqó-pisumam? Yawe zenda ndò꞉vé, te-te ndego qo geqatøke.” Yaq Lut zakhapuka-pakha gumbo-ein, “No bali nanga qæpisumam, khae eve iz nqambógo, Boáz.” ");
INSERT INTO kvg_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Yaq Naomi gundu-ein, “Yáiyé! Qanimav tantáv. Yawe zenda ndò꞉vé, Boaz-te. Manqa mbusa ndøgo, Yawe khandi ezoqam-te neka løvøte ezoqam-te geve, ni tini-kewagat, ndego oskia mbomataváp. Nande Boaz, nigi angana, ndigu gipakhaez, tigí ekeza ezoqám. Ezoqam av nde꞉go, Mozes-qa guguna manqat āv qane-eín nqǽgo: Sævam ndugu anganeam tembonanim, yaq anganeam-gi ekeza ezoqam yàbembo-tøkeé.” ");
INSERT INTO kvg_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Yaq Lut gundu-ein, ndugu Moab-ak, “No ndego manqat nøme mba nømbo-eín av nqægo, ‘Até vøgó, nqanek nogi sasae ezoqam namba, atema bali nanga viav bemø̄-navøem.’” ");
INSERT INTO kvg_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Yaq Naomi ziwap-pakha gumbo-ein, “Nanda mbomá, qo tegi sasae mbasønakheis toqozø-pavat. Tiqa zita-te bali khakhayakh toqotøndó-pisumát. Geté qo khae vini-te toqomø-pisam, ezoqam andé matev vinivinimba vøqambé-matønømēm.” ");
INSERT INTO kvg_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Yaq Lut ndǿgo tusasaetám, Boaz-gi sasae mbasønakheis-qa avønin-te, atema bali nanga neka wit nanga viav vømø̄-navøem. Yaq ndugu zakhapuka-pakhá namba me꞉yagám. ");
INSERT INTO kvg_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Khøuwa nøme, Naomi Lut gumbo-ein, “Sǽ-pakha. No anganeam é-bataqa-omét. Yaq qo mbomambá tøneyagé. ");
INSERT INTO kvg_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Qo mòqote-qatéq. Boaz, tegi sasae mbasønakheis namba qoqote-sasaetat, ndego nigí angana-gé ezoqám. Nqáe! Nqægo lova ndego bali nanga ndø̀-evemét, bali nanga tøkuza manqei-te. ");
INSERT INTO kvg_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ndakin āv qoqotégó nqǽgo: Vø̀khæ-khakuám. Tae et sisip mbomambaqape qógé, neka ndabua eqeieqei voqó-uzām. Yaq teqa bali nanga tøkuza manqei-té qonǿqáv. Geté Boaz beqàme᷄kh. Ndego lou loge ùni bembøe-navøém. ");
INSERT INTO kvg_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Yaq ndego temøbuv, qo ùnime꞉-omét, ma te꞉buv ndøgo. Yaq venanqei tebuvit ndøgo, qo toqonǿqáv ndøgo, teqa ndabua khafuvam nonqo voqombó-onqā, teqa zenda tokhotapak-te, sasa qóbūv. Yaq manqat ndǿgo, tenøqá-eín, qo ande gekha matev me qógō.” ");
INSERT INTO kvg_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Yaq Lut nqanek manqat gu-ewag, gundu-ein, “Qanimáv. No matev ndæ̀matanám, av qonømbe-manqatat ndægo.” ");
INSERT INTO kvg_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Yaq ta lova ndøgo, ndugu tunøwáv ndǿgo, bali nanga tøkuza manqei-te, yaq manqat ate ndægo vømbōpaev, av zakhapuka-pakha gumøndæ-ein. ");
INSERT INTO kvg_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Yaq Boaz lou gumulog ndøgo, khanakhanakh gendap, yaq bali nanga møvøza avønin-té segebúv. Yaq venanqei gebuvat ndøgo, Lut até gundigu, aiyav-tē gunøwāv, Boaz-qa ndabua khafuvam nonqo vø̄-onqa, sa zenda tokhotapak-te ndøgo, sasa ndøbuv, teqa zenda tokhotapak qame-vavøem. ");
INSERT INTO kvg_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Ande āv lova u mbá ndægó, Boaz tènesuzám. Yaq ma ge꞉qambun, nqova mbondáf. Áe, teqa zenda tokhotapak vavap-te sævam gubuvam. ");
INSERT INTO kvg_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Yaq gumbobevap, “Qo gekha ezoqâm?” Yaq gundu-ein, “No Lút. No ezoqam khapúmbá. No andé qogú sasae mbasønakám. Qoqa ndabua khafuvam nonqo, ov-qase nandav, no qonǿkhafuí. Yaq no tàbate-nøtén, av nqægo, qonǿ-kewagát. Zapa ndǿgo, qo nogé anganeam-pakha-gé ekeza ezoqám. No ambá qonøkeɨ́n.” ");
INSERT INTO kvg_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Yaq Boaz gumbo-ein, “Sǽ-pakha. Yawe ndø̀goát qo namba. Qo qakhapuka-pakha matev qaniqanimáv qoqombo-goam. Geté matev ndakin ndoqo-matønumit, qo no-te tøke-qa qoqotøndoqav, ndøgo mø̀ndøløvú qoqa matev mbomømboma ate ndægo, qoqo-matønumam. Angana ndakinak kopoáv ngiyage. Nøme gigiap kopoav ezoqám neka nøme gigiap-av ezoqám. Geté qo matavapøteáv av nqægo, ‘No anganeam ndakinak sǣndāf.’ ");
INSERT INTO kvg_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Sǽ-pakha. Qo møe ndø̀go᷄. Gekha manqāt ndøgo, qo toqonø-ein, sǽmatanám. Ezoqa ate ngi꞉gu, nqanek vemiav-te ngiyage, mø̀ndæzøtéz, qo sævam matev mbomambaqapú. ");
INSERT INTO kvg_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Unimanqatín. No qogé anganeam-pakha-gé ekeza ezoqám. No yàbataqa-keogé. Geté ezoqa nøme ndêgó, ndego uni qoge qøivis-pakha-ge ekeza ezoqam. Ndego bàmbokho-beváp. ");
INSERT INTO kvg_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Até vøkhægót nqanek, nqægo lova. Yaq qanaqanus sizíqeivím, andé gekha matev me petéfakhān, penømakhaya. Ndego tømbopoe teqakɨ, ság, beqakɨ́. Geté ndego tømbøeqasi, kopømbá. No Yawe-qá bugug-té qataqambø-manqaté, no ndæ̀qakɨ́, ndego poeveav tøgoat. Até vøkhæbuvít nqanek, atema qanaqanus.” ");
INSERT INTO kvg_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Yaq Lut Boaz-qá zenda tokhotapak-té gubuvát, atema vøndōnqoe. Geté agé paveateáv. Até gupøistám. Yaq é-møndosuzám. Ezoqa bøi vizu møe ndøgó. Zapa ndǿgo, Boaz āv gumbøe-eín nqǽgo, “Ezoqa nøme betezø̀te᷄z av nqægo, sævam mø̀ndøgoām, no namba, nqanek bali nanga tøkuza manqei-te.” ");
INSERT INTO kvg_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Yaq Boaz Lut manqat nøme gumbo-ein, “Qakeza ndabua nøme nandav, nqanqa-te nandaqambovi꞉, vøkhofá. Qóvøndáz.” Yaq Lut ndabua vø̄vøndaz. Yaq Boaz até gendego, bali nanga vømbø̄e-qoutaz. Kopoáv gumbøeqoutaz, ndabua até vømømbō-qoqovøem. Taqa viniv andé áv 20 kilogrém ndægó. Yaq Boaz Lut bali nanga kawa-té gumbøezáv, Lut vø̄wav, yaq ndego ekeza vemiav-te sasa ndøqavan. ");
INSERT INTO kvg_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Yaq Lut zakhapuka-pakha-te guqavan, zakhapuka-pakha āv gumbøebeváp nqǽgo, “Sǽ-pakha. Matev áv khaqambé-fakhan?” Yaq Lut emanqat ate ndægo vømbø̄e-votot, av Boaz matev qaniqanimav gumbøe-matanam. ");
INSERT INTO kvg_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Yaq manqat nøme gundu-ein, “Nginik bali nanga-qape Boaz nø-etoám. Ndego āv genømbe-eín nqǽgo, ‘Qo qakhapuka-pakha-te zenda-zenda mba ndøqàva᷄q.’” ");
INSERT INTO kvg_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Yaq Naomi gundu-ein, “Sǽ-pakha. Sizió-kewagét, andé gekha matev me ndǿfakhān. Ndego Boaz pusa naqanøká gétayák. Matev unimé꞉gó, nqægo khøuwa.” ");
INSERT INTO kvg_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Yaq Boaz até gendego, vemiav mboqog tambav-té genøwáv, angana ma manqat gi꞉vøovumam, vømø̄qom. Yaq Elimelek-ge ekeza ezoqam ge-omet ndøgo, teqa yaq-te Boaz Lut manqat gembøe-ein, yaq sègembo-akhá, “Khanánqa. Qotøndéqā. Qànøqóm nqanek.” Yaq ndego ezoqam gendowav, vø̄qom. ");
INSERT INTO kvg_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Yaq Boaz vemiav megetapak ten sasa zø-akha, gezø-ein, “Qànøqonáv nqanek,” yaq ndigu vø̄qonav. ");
INSERT INTO kvg_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Yaq Boaz ndego ezoqam gembo-ein, “Qo mòqote-qatéq. Naomi, ndugu sævam, Moab manqei-te gunduqavan, tugi anganeam-pakha Elimelek, ndego nigé ezoqám. Yaq ndakin ndugu Naomi, teqa manqei wi-qa ndøgó, tege ekeza ezoqa nøme-te. ");
INSERT INTO kvg_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","No āv qate-matøvém nqǽgo, qo bàtaqa-eín, taqa yaq-te. Qo nqanek manqei taqa-pøovat, kopømbá. Nginik vemiav megetapak neka ezoqa ewaqape-qa bøi-te, ngiqonøve, soqó-eín. Geté qo wii poeveav tøgoat, taqambo-qasi, sègenø-eín. Zapa ndǿgo, qoqa zita-te ezoqa nøme mbaín, nqanek manqei tewi. No mba nogó.” Yaq ndego Elimelek-ge ekeza ezoqam gendo-ein, “Qanimáv. Manqei ndæ̀wí.” ");
INSERT INTO kvg_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Yaq Boaz manqat nøme gembo-ein, “Geté nqanek manqei Naomi-te toqondap, até Lut voqó-okɨ̄, ndugu Moab sævam, Elimelek-ge yo-pakha-gu zas. Yaq av ndægo, ta manqei ndøgo løvøte ezoqam-qa iz-te sekembá segégoát.” ");
INSERT INTO kvg_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Yaq ndego ezoqam gendo-ein, “Av tægoat ndægo, yaq no kopømba mbaín manqei tæwi. Soqaín ndøgo, nogi nakheis sa timøløvuz, noqa løvøte khøuwa-te manqei tiqaqaem. Qo taqa-pøovat, qakeza ndøndáp. No kopømba mbaín tændap.” ");
INSERT INTO kvg_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Ta khøuwa-te ndøgo, Izlael manqei-te, matev āv qazømbe-goám nqǽgo. Ezoqa manqei o gigiap ezoqa nøme-qa zenda-te ge-ivavɨn, ndego tamak kopo ndøkhofaɨ́n, ndego ezoqa nøme vømbō-etoamɨn. Yaq ezoqa ewaqape tìabiti-zøtéz, av nqægo, ta gigiap ndøgo, ndakin ezoqa vini-qá. Nqanek Izlael ezoqam-qá matév. ");
INSERT INTO kvg_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Yaq ndego Elimelek-ge ekeza ezoqam Boaz gembo-ein, “Qo qakeza ndøwí.” Yaq ndego até gendego, tamak kopo gèkhofá, Boaz sasa mbo-etoam. ");
INSERT INTO kvg_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Ndego nqanek matev gego, yaq Boaz vemiav megetapak neka ezoqa ewaqape giqonavam, āv gezømbe-eín nqǽgo, “Nqægo khøuwa, zo ezoqa ewaqape ate nqazøte-qonøve, zo mòzoqeivím. Manqei ndøgo, Elimelek neka tegi nakheis, Kilion neka Malon, tiqa manqei qagoam, no nowí, Naomi-te. ");
INSERT INTO kvg_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Yaq ngunuk ngæmam, Lut, Moab sævam, Malon gu-okɨam, ndugu ndakin nogú sævám. Neka yaq nakhasam anganeam tumumbu-fakhan, ngenek løvøte ezoqam-qá íz neka manqei teabete-ndapét. Yaq av nqægo, Malon-qa iz sa gemǿ-navøemák teqa bawan-te neka nqanek vemiav-te. Nqægo khøuwa zo ezoqa ewaqape ate nqazøte-qonøve, matev mòzoqeivím.” ");
INSERT INTO kvg_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Yaq ndigu megetapak neka ezoqa nøme, mboqog-te ndøgo giqonavam, gindu-einim, “Qanimáv. Ni mø̀iqeivím. Yawe zenda ndò꞉vé, ngunuk sævam-te, qo toqo-okɨ, qoqa khoev-te tunduwav. Yaq ngunuk sævam nakheis kopoav tìabembøe-fakház, av nginik sakhei menas ngi꞉gu, Laisol neka Lia nakheis gizømbe-fakhaz, ni Izlael bawan ate nqazi꞉gu qazindu-manazømem. Yaq Eflat khagua bawan mokho-te neka Betliem vemiav-te nqanek, qoqa iz kandambaqape tàbetaqambegó neka gigiap kopoav ezoqam voqógoāt. ");
INSERT INTO kvg_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Yaq nakheis ndigu Yawe teqa-etoam, ngunuk sævam-te, tigi zi kopoav-qape tìabitigú, av Pelez-gi zi ndi꞉gu, ndego Tama neka Zuda, tige yo.” ");
INSERT INTO kvg_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Yaq Boaz até gendego, Lut vø̄-okɨ, venanqei nonqo vø̄tøkuanem. Yaq Yawe gèmbotøké, kha viniv vø̄ndap. Yaq nakhasam anganeám gundaf, gui-ova. ");
INSERT INTO kvg_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Yaq Lut gui-ova, sakheis vemiav-te ndøgo, Naomi āv gimbøe-einím nqǽgo, “Khanakhanákh Yawe-te, ndego qo qazeo geqa-etoam. Ngenek ezoqam iz akhae ndǿgoát, Izlael manqei-te. ");
INSERT INTO kvg_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Ngenek qazeo, qo khanakhanakh ndø̀qa-etoám, qoqa yage-te. Yaq qo toqotumu-ngæpuka-eq, ndego qo qákewagát. Neka qo khanakhanákh. Qogu qæwap-pakha, ngenek nakhasam gui-ova, ndugu poev kandambá qo-te. Qo amba nakhei angana seven tiqagonɨn, ndigu ambá kopømba mbaín tiqa-tøkeemɨn, av Lut nguigu, matev guimatanam qo-te.” ");
INSERT INTO kvg_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Yaq Naomi nakhasam sègendáf, vø̄ngenøtam. Yaq ndugu Lut noundape mbotøkeám. ");
INSERT INTO kvg_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Yaq ndigu sakheis, ta vemiav-te ndøgo giyagam, gi-einim, “Yáiyé! Ndakin Lut nakhasam anganeam mø̀ndømboqán. Ndego andé Naomi-gé nakhasám.” Yaq ndigu iz Obed mbo-akhaém. Yaq ndego Obed gumu-khouwev, nakhasam gembo-fakhan, Zesí. Neka ndego Zesi gumu-khouwev, nakhasam gembo-fakhan, Deivíd, ndego iz akhae kandambaqape gegoam, Izlael manqei-te ndøgo. ");
INSERT INTO kvg_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Deivid-qa zapa av nqǽgo qande-itán: Tege atanakha-zapa Peléz. Pelez gemanaz, Ezlon ndøqán. ");
INSERT INTO kvg_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Yaq Ezlon gemanaz, Lam vø̄qan. Yaq Lam gemanaz, Aminadab vø̄qan. ");
INSERT INTO kvg_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Yaq Aminadab gemanaz, Nason vø̄qan. Yaq Nason gemanaz, Salmon vø̄qan. ");
INSERT INTO kvg_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Yaq Salmon gemanaz, Boaz vø̄qan. Yaq Boaz gemanaz, Obed vø̄qan. ");
INSERT INTO kvg_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Yaq Obed gemanaz, Zesi vø̄qan. Yaq Zesi gemanaz, Deivid vø̄qan. ");
INSERT INTO kvg_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Qàgoám. Khøuwa nøme, Evezøza, ndego Mbumbukiam, até gendego, Ziona, Amitai-ge yo, vømbō-ein, ");
INSERT INTO kvg_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Niniva taon kandambaqape-té qonǿqáv. Qomézømás, av nqægo, Mbumbukiam géngiæzó. Zapa ndǿgo, no mø̀ezømét, nandiv. Ndigu soqa matev khàpe-zømbe-khouwév.” ");
INSERT INTO kvg_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Geté Ziona, Evezøza-qa manqat gè-ogí. Yaq viní genøwáv. Tasis taon-te okho-qa ndøgoám. Yaq gevis ndøgo, Ziopa taon-te gemøfakhan, palai khagua ndøqeív, qabøetam. Ndøgo Tasis taon-te teiti-qa ndøgoám. Yaq Ziona até gendego, fia vø̄go, vø̄uketao, sasa ndøteit. Evezøza-qá møe ndøkhokhonát. ");
INSERT INTO kvg_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Yaq ndigu anana-mba mø̀ndu꞉bǿen, Evezøza khamøe-qape tēāndō-khōfōtāv, palai khagua ambá vø̄tøkuiamin. ");
INSERT INTO kvg_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Yaq ndigu ezoqam, khagua-te gu꞉sasaetam, qambuat møe ndøgoném. Yaq ezoqa ewaqape, ekeza mbumbuk-te tøke-qa ndø-akhayám. Yaq gigiap ndøgo qøugeipam, gènqagemém. Palai khagua takh-qa mbogoám. Geté Ziona otevateáv. Ndego gù꞉buvát, ndøgo palai khagua mokho-te. Nqova mokho-té gembøi-teitát. ");
INSERT INTO kvg_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Yaq ndego palai khagua gembo-kewagam, até gendego, Ziona vømø̄tiu. Gembo-ein, “Gekha zapâ, venanqei mba ndoqobuvit? Mòqosuzám. Qakeza Mbumbukiam-té qonǿ-akhá. Éisa, ndego ni tanakh ndø̀nigú. Yaq ni zípakhaenák.” ");
INSERT INTO kvg_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Yaq ndigu ezoqam, palai khagua-te gu꞉sasaetam, āv gini-einím nqǽgo, “Iziz zípeawám, pepa-qasis-te. Yaq ava-té qazinǿ-nqeitøvém. Yaq zíqeivím. Ezoqam teqá manqa-zapa ndégo tǿgoát, teqa iz tizilivim.” Yaq av gi꞉gonem ndægo, Ziona-qá iz ndølivím. ");
INSERT INTO kvg_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Yaq gèmbo-bevøpém, “Qonimbí-eīn. Nqanek matev qafakhan, gekha ezoqam-qâ manqa-zapà? Qo gekhā sasae qógo? Neka qo gekha manqei-âk? Neka gekha bawan-âk?” ");
INSERT INTO kvg_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Yaq Ziona gezø-qavøiu, “No Iblu ezoqám. No Evezøza nombovizáp, ndego Mbumbukiam, yan-te ngo꞉yage neka ndego ndaola neka manqei-qape gekhakheinam. ");
INSERT INTO kvg_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Yaq no Evezøza-qa manqat, nò-ogí. Nòkhokhonét.” Yaq ndigu ezoqam, nqanek manqat giyogem, ndigu møe kandambá gigonem. Yaq Ziona gimbo-einim, “Manqa-zapá nandav. Gekha zapâ, matev av qoqotego nqægo?” ");
INSERT INTO kvg_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Yaq khamøe, sà tønø-fitumát. Yaq Ziona āv gimbøe-bevøpém nqǽgo, “Gê, gekhā nitaqá-gonēm, nqanek khamǿe vønimbí-vøitáv?” ");
INSERT INTO kvg_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Yaq Ziona gezø-qavøiu, “No ibøkha-té qazonǿ-ogenønám. Yaq nqanek khamøe segévøitáv. No mø̀tenøtén, nqanek khamøe-qape qandowav, ndøgo noqá manqa-zapá.” ");
INSERT INTO kvg_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Geté ndigu ezoqam, palai khagua-te gu꞉sasaetam, ndigu bazaføgakh-us amba me꞉tiæemém, manqei khanøzu-qa. Geté kopømba mbaín. Khamøe-qape sà tønø-fitumát. ");
INSERT INTO kvg_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Yaq ndigu Evezøza-té ginø-akhaém, gi-einim, “Evézøza, ni ngenek ezoqam, teqa yage teingi꞉nam, ni løvøte ni-etòa᷄m neka manqa ovøyam-te ndò-a᷄mb, av qo pepen ezoqam qoqote-abumatun, ndigu manqa-zapa mbain ezoqam gizitagatun. Zapa ndǿgo, Evezøza, nqanek khamøe-qape qandowav, ndøgo qoqá poév.” ");
INSERT INTO kvg_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Yaq até gindigonem, Ziona gèndafém, ibøkha-te sasa ndø-oginam. Yaq ndaføyambá, khamøe sègevøitáv. ");
INSERT INTO kvg_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Yaq ndigu sasae ezoqam, palai khagua-te gu꞉guvam, nqanek Evezøza-qa bazaføgakh giqeivim, ndigu møe kandambá gigonem. Yaq até gindigonem, søvakha gigiap ndølaém, Evezøza-te sasa ndøtaem, neka manqa mbusa vø̄veem, av nqægo, Evezøza zimbōpavāt. ");
INSERT INTO kvg_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Yaq Evezøza zongøyam-qape ndokhofotáv, Ziona vø̄-khoutav. Yaq Ziona zongøyam-qá emu mokho-té gunu꞉goám. Khøuwa misiká neka lova misika. ");
INSERT INTO kvg_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Yaq Ziona ate av-té zongøyam-qa emu mokho-te gu꞉goam, ndego Evezøza-té genø-akhá, tege Mbumbukiam. ");
INSERT INTO kvg_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Geguligulim, “Evezøza, no soqaqape-te qægoam, qo-té qatøndo-akhá. Yaq qo mòqonø-tøké. No løvøte avønin-te qæmø-itan, qo-té qatøndo-akhá, tøke-qa. Yaq qo noqa akhayam mòqo-ewág. ");
INSERT INTO kvg_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Qo no ibøkha-té qonø-ogenó, anana-mba-qape ndøugu, igian-te. Ibøkha ùnime꞉-gutambát. Yaq qoqa khamøe makhamakha, noqá mumát qanø-okhoát. ");
INSERT INTO kvg_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","No qæmatavupam, qo gèqambo-qasí, no qoqa bøi-te totogoat. Geté no qoqa khoev mbomambaqape, nango ndø̀møqeív. ");
INSERT INTO kvg_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Khamøe-qape qandowav, no vø̄khølutan, ibøkha-qape ùnime꞉-gutambát, neka kik noqa kawa vø̄løvønam. ");
INSERT INTO kvg_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Yaq no até nogeonát, atema manqei popotap-qa zapazapa-te, ibøkha mokho-te ndøugu. Yaq no ùnime꞉-tokán. Geté qo, Evezøza, noge Mbumbukiam, qo no mòqoliván, neka khandi voqonø̄-etoam. ");
INSERT INTO kvg_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Noqa khandi qænavøemtat, yaq noqa matavap qo-té qandoveséz, Evezøza. Yaq no nø̀taqa-viám. Yaq qo noqa viam manqat toqomø-ewág ndǿgo, qakeza khoev-te. ");
INSERT INTO kvg_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Ezoqa ndigu khokho mbumbuk ndizøvizap, ndigu qo zita gi꞉wuaqabem, ndigu qoqa kuku matev géqeivimák. ");
INSERT INTO kvg_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Geté no khanakhanakh ouv nøtaqá-qaqayám, neka etoam matev vøtaqágō, av bugukhokhof manqa mbusa qateve. Zapa ndǿgo, khandi etoam matev, qo-té qando-okhó, Evezøza.” ");
INSERT INTO kvg_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Yaq zongøyam-qape ndego, Ziona gekhoutav, Evezøza ndøgeg-té genø-khofotáv, Ziona vømø̄-qozao. ");
INSERT INTO kvg_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Yaq Evezøza Ziona manqat nqawá genømbo-eín, ");
INSERT INTO kvg_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Niniva taon kandambaqape-té qonǿqáv. Yaq manqat qomézømás, av tøtaqambe-ein ndægo.” ");
INSERT INTO kvg_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Yaq Ziona Evezøza-qa manqat, o-mba mo꞉ndáp, Niniva taon-te sasa ndøwav. Niniva taon ndøgo, kandambá tantáv. Taon toqokepaz, khøuwa misiká toqotuma, atema yaq voqomǿ-fakhāq. ");
INSERT INTO kvg_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Ziona Niniva taon-te gemøfakhan, yaq sègemát. Khøuwa kopó. Yaq manqa manqate ndøngáz. Gezø-ein, “Khøuwa foti mbá ngu꞉yoza. Nqanek Niniva taon, Mbumbukiam géngiú.” ");
INSERT INTO kvg_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Yaq ndigu Niniva taon-ak, nqanek Mbumbukiam-qa manqat giyogem, gè-unimanqatiním. Yaq ndigu manqa ndøvøovømém, gi-einim, “Ndakin ni ate nqazi꞉gu, lou logemav matev zígoném.” Yaq ezoqa ewaqape, av tinigoném ndǽgo, ezoqa kandakanda neka꞉ ezoqa khasøkhasis, yaq ndigu ndabua soqøsoqa vø̄-uzam-a, mutøkhop vø̄wanim, tiqa manqa-zapazapa zapaya. ");
INSERT INTO kvg_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Yaq ndego Niniva taon-ak-ge kawa, nqanek manqat ge-ewag, ndego até gendego, ekeza qonam nonqo-te geqonumam, gèvís. Ndabua mbomømboma ge-uzupam, gekhòfoē, yaq ndabua soqøsoqa vø̄-uzam, pakhakh-te sasa ndøqom. ");
INSERT INTO kvg_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Yaq ndego manqa ndøkhofotám, Niniva taon-qape ate qægoam. Manqat gekhofotam nqánek, “Nqanek niqá manqát, no Niniva kawa neka nogi vesøtapak. Zo ezoqa ewaqape, nqanek Niniva taon-te nqazoyage, lou neka ibøkha ndølòge᷄. Até zogí søvakha gigiáp-a, lou neka ibøkha belòge᷄. ");
INSERT INTO kvg_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Yaq zo ezoqa ewaqape ndabua soqøsoqa zó-uzám. Até zogí søvakha gigiáp-a, ndabua soqøsoqa vozozømbó-khafuzām. Neka viam bazaføgakh-us zógoném Mbumbukiam-te. Zóqambúz te-te, neka matev soqøsoqa neka gekha manqa-zapazapa nøme ndøgot, vø̀-ivøvém. ");
INSERT INTO kvg_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Éisa, Mbumbukiam teqa matavap peté-enēnd penømakhaya, neka ndego qaqa pømbøé-navøēm penømakhaya. Yaq ni zīpakhaenāk.” ");
INSERT INTO kvg_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Yaq Mbumbukiam geqeiv av nqægo, matev gi-enend neka manqa-zapazapa vø̄-ivøvem, yaq ndego tanakh zøgó ti-te. Yaq ndego Niniva taon ngi꞉wateáv, av bugukhokhof manqat ge꞉-ein. ");
INSERT INTO kvg_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Geté Ziona geqeiv av nqægo, Evezøza Niniva taon ngi꞉wateav qagoam, yaq ndego khanakhanakh mbaín, neka mbøni mbonqosøgím. ");
INSERT INTO kvg_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Yaq āv gene-guligulím nqǽgo, “Evézøza. No nøkeza manqei-te qægoam, no mø̀e-eín, matev av nqægo, ndø̀fakhán. Yaq nakémbá, no amba Tasis manqei-te tækhokhonɨn. No é-møtenøtén, qo kuku matev-us Mbumbukiám. Neka qo ezoqam tanakh qozøgoatún. Qo qaqa nakha-nakhamas-te gonemáv. Geté qo poev kandambá, ezoqam-te. No mø̀tenøtén, qo matavap sòqo-enendɨ́n, yaq ezoqam-qa yage ngi꞉watáv. ");
INSERT INTO kvg_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Yaq nakémbá, Evezøza, qo noqa khandi vø̀ndáp. É-batenaním. No poeveáv sekemba tæyagat.” ");
INSERT INTO kvg_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Yaq Evezøza gendo-ein, “Zíona. Ge qô ndoqo-matavap. Nandav matev eqeieqeî, qo qaqa ndoqogot?” ");
INSERT INTO kvg_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Yaq Ziona Niniva taon gè-iváv. Khøuwa fakhanám genøwáv. Agé okhoeáv, khoev-qase tēmø̄wēv, taqa guzuguzu-te sasa ndøqom. Yaq taon-qape, bøi mba mbøevé, ande gekha matev me mbøéfakhān. ");
INSERT INTO kvg_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Yaq Evezøza, ndego Mbumbukiam, gumbag ndøkhofotáv, Ziona-te. Yaq tønøqavíg ndǿgo, Ziona-qa khoev-qase qawevam, guzuguzu nøme vømbō-etoam, teqa mbøni nqosøgeap navap nonqo. Yaq Ziona khanakhanakh kandambá gendap, nqanek gumbag guzuguzu qambo-etoam. ");
INSERT INTO kvg_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Geté khøuwa nøme qandopave, qanaqanus lovalova-us, Mbumbukiam oiyam ndokhofotáv, gumbag ngum vø̄louz, gumbag vø̄pakha. ");
INSERT INTO kvg_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Yaq khøuwa gendo-eqan, muin ge-itan, Mbumbukiam khamøe tatas-qape tènde-khofotáv. Yaq Ziona khøuwa tatas-te ge꞉qotat ndøgo, kha mø̀ndømømbo-khatá, ambá bøi vømbō-guain. Yaq ekeza manqat ge-ein, “Ság. Bànønaním. No poeveáv sekemba tæyagat.” ");
INSERT INTO kvg_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Geté Mbumbukiam Ziona gembo-ein, “Ge qô ndoqo-matavap, Nandav eqeieqeî, qo qaqa ndoqogot, gumbag-qa yaq-te?” Yaq Ziona gendo-ein, “No kopømbá qaqa nqægot, gumbag-qa yaq-te. No é-batenaním.” ");
INSERT INTO kvg_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Yaq Evezøza gendo-ein, “Gekha zapâ, gumbag-qa yaq-te mbøni ndøqa-nqosøgeapet? Qo ambá av nqǣgo, qakeza qo-ogeākh. Neka qo sasae-qase goneáv, taqa yaq-te. Lova qoqobuvat, ekeza mbá segefakhán. Yaq ekeza mbá segepakhá, nqægo lova. ");
INSERT INTO kvg_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Ge qô ndoqo-matavap, qo gumbag tanakh ndoqombogot, yaq gê, no tanakh mbaîn, Niniva ezoqam-te? Tiqa bawan-qape, kandambá tantáv. Ndigu wan andled tuenti taosen ezoqam mø̀ndømø-løvú, ndigu zøtezateav ndigu, gekha nakhōa eqeieqei neka gekha nakhōa soqain. Neka søvakha gigiap nanak kopoáv ndiyage.” ");
INSERT INTO kvg_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Keliso-gi atanakha-zapazapa-za gindu-manazømem, tiqa iziz nqánek. Ngenek Yesu, Deivid-gé zeó neka Eibleem-gé zeó. ");
INSERT INTO kvg_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eibleem gendomanaz, Aezek vø̄qan. Aezek gendomanaz, Zekop vø̄qan. Zekop gendomanaz, Zuda, tegi zaim neka emekheis namba, vø̄qaz. ");
INSERT INTO kvg_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Zuda gendomanaz, Pelez neka Zela vø̄qaz. Tigu evo, Tamá. Pelez gendomanaz, Ezlon vø̄qan. Ezlon gendomanaz, Lam vø̄qan. ");
INSERT INTO kvg_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lam gendomanaz, Aminadab vø̄qan. Aminadab gendomanaz, Nason vø̄qan. Nason gendomanaz, Salmon vø̄qan. ");
INSERT INTO kvg_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon gendomanaz, Boaz vø̄qan. Tegu evo, Leiáb. Boaz gendomanaz, Obed vø̄qan. Tegu evo, Lút. Obed gendomanaz, Zesi vø̄qan. ");
INSERT INTO kvg_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Zesi gendomanaz, Deivid vø̄qan. Ngenek Deivid, Izlael ezoqam kawa zøgoám. Deivid gendomanaz, Solomon vø̄qan. Tegu evo, ibugukhokhof Ulia-gú zas ndøgoám. ");
INSERT INTO kvg_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon gendomanaz, Leoboam vø̄qan. Leoboam gendomanaz, Abaeza vø̄qan. Abaeza gendomanaz, Asa vø̄qan. ");
INSERT INTO kvg_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa gendomanaz, Zeosafat vø̄qan. Zeosafat gendomanaz, Zeolam vø̄qan. Zeolam gendomanaz, Uzia vø̄qan. ");
INSERT INTO kvg_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia gendomanaz, Zotam vø̄qan. Zotam gendomanaz, Eiaz vø̄qan. Eiaz gendomanaz, Ezekaya vø̄qan. ");
INSERT INTO kvg_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekaya gendomanaz, Manase vø̄qan. Manase gendomanaz, Amon vø̄qan. Amon gendomanaz, Zosaya vø̄qan. ");
INSERT INTO kvg_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zosaya gendomanaz, Zeoyakin, emekheis namba, vø̄qaz. Ta khøuwa-te ndøgo, Bebilon manqei-ak, Izlael ezoqam, Bebilon manqei-té ginø-upøzó. Pingim-ák. ");
INSERT INTO kvg_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Izlael ezoqam Bebilon manqei-te gi-upøzo, nakhag-te gizøgeagim, taqa zita-te, ezoqa nøme gifakhaz, ngínik: Zeoyakin gendomanaz, Sealtiel vø̄qan. Sealtiel gendomanaz, Zelubabel vø̄qan. ");
INSERT INTO kvg_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zelubabel gendomanaz, Abiud vø̄qan. Abiud gendomanaz, Eliakim vø̄qan. Eliakim gendomanaz, Azo vø̄qan. ");
INSERT INTO kvg_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azo gendomanaz, Zadok vø̄qan. Zadok gendomanaz, Akim vø̄qan. Akim gendomanaz, Eliud vø̄qan. ");
INSERT INTO kvg_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud gendomanaz, Eleaza vø̄qan. Eleaza gendomanaz, Matan vø̄qan. Matan gendomanaz, Zekop vø̄qan. ");
INSERT INTO kvg_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Zekop gendomanaz, Zosef vø̄qan. Ngenek Zosef, Meli-gé zivís. Neka Meli ngunuk, Yesu-gú evó. Yesu, ngének, Keliso nqazimbo-akhayam. ");
INSERT INTO kvg_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Eibleem gendo-manazam, atema Deivid vømø̄fakhan, atanakha-zapazapa-za ate gi꞉goam 14́. Yaq Deivid gendo-manazam, atema Bebilon manqei-ak, Izlael ezoqam Bebilon manqei-te gi-upøzo, nakhag-te gizøgeagim, até ndøgó-a, atanakha-zapazapa-za ate gi꞉goam 14́. Neka ta khøuwa-te ndøgo, Izlael ezoqam Bebilon manqei-te gi-upøzo, nakhag-te gizøgeagim, atema Keliso vømø̄fakhan, até ndøgó-a, atanakha-zapazapa-za ate gi꞉goam 14́. ");
INSERT INTO kvg_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Keliso āv geneqán nqǽgo: Tegu evo, Meli, søvøta mba mbogoám, Zosef-te. Geté ndigu uni nøkepøteáv neka venanqei nonqo tøkuateáv. Geté Meli emu é-møndæ-itán. Nqanek matev qambo-fakhan, Nqova Mbomambaqape mbøisasáe. ");
INSERT INTO kvg_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Meli-ge zivis, Zosef, teqa matev mbomambaqapé, yaq ndego poeveáv, ndugu ezoqam-qa bøi-te to꞉-ivav, mivi vømbó-etoām. Yaq ndego khonoam-te ivøve-qa ndøgoám. ");
INSERT INTO kvg_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Zosef ate av-té gembøe-matavupat, yaq Evezøza-gé enzol ezoqam mbofakhán. Venanqei-tam-té genømbo-fakhán, gembo-ein, “Zósef, Deivid-ge zeo, qo ndøfofògea᷄p, Meli toqo-okɨ, qogu sævam tugoat. Zapa ndǿgo, ndugu emu nduiyæt, ndøgo Nqova Mbomambaqape ndømatanám. ");
INSERT INTO kvg_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nanduv tui-ova, nakhasam anganeam mbóqán. Yaq iz Yesu qombó-akhá. Zapa ndǿgo, ngenek ekeza ezoqam, gékhandí꞉z, ndigu manqa-zapazapa-us ndiyage.” ");
INSERT INTO kvg_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nqanek matev ate nqægo, tøne-fakhanám ndǿgo: Manqat ndøgo, Mbumbukiam ekeza manqa vevezam ezoqam mokho-te ge-ein, ta manqat ndøgo, tàbete-unimanqatín, qa-ein av nqægo, ");
INSERT INTO kvg_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mbasønakam zivis namba venanqei nonqo, naqanøká gétøkuanemák. Geté ndugu emu é-ndæ-itán. Yaq ndugu nakhasam anganeam mbóqán. Neka teqa iz ‘Emanuel’ mbó-akhá.” Emanuel, taqa manqa mokho nqánek, “Mbumbukiam ngêgó, ni namba.” ");
INSERT INTO kvg_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Zosef gendosuzam, yaq ndego matev āv tenegó, av enzol ezoqam gembøe-ein, neka Meli vø̄-okɨ. ");
INSERT INTO kvg_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Geté ndigu venanqei nonqo tøkuateáv, atema Meli vø̄e-ova, nakhasam anganeam vø̄ndaf. Yaq nakhasam geqan, Zosef, iz Yesu mbo-akhá. ");
INSERT INTO kvg_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu Betliem vemiav-té geqán. Ta khøuwa-te ndøgo, Zudia plovins-te, kawa, Elod ndøgoám. Yaq Yesu geqan, nqáe! Zelusalem taon-te ndøgo, nduku gevezoat ezoqam ndøfakház. Sa khøuwa fakhanám ginduzáv. ");
INSERT INTO kvg_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Yaq āv gini-bevupát nqǽgo, “Ngenek nakhasam, ndaki geqan, ndego Zu ezoqam kawa tezøgoat, kenáqape? Ni tegú ndukuam ni-ometám, khøuwa fakhanam ndøgo. Yaq vizam-qa nimøndæ-niáv.” ");
INSERT INTO kvg_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Elod ndego, Zudia ezoqam-ge kawa, nqanek manqat ge-ewag, ndego gò꞉khouwá. Até ezoqa ewaqapé-a, ndigu Zelusalem taon-te giyagam, vō꞉khouwønem. ");
INSERT INTO kvg_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Yaq Elod até gendego, Mbumbukiam-gi iziz ezoqa kandakanda neka Mozes-qa guguna manqat nømendim ezoqam vø̄møvab, sasa zøbevap, gezø-ein, “Ngenek Mesaya, Mbumbukiam ge꞉-ein, av nqægo, manqei-qape-te tendo-khofotav, gekha vemiav-tē gemǿqān?” ");
INSERT INTO kvg_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Yaq gimbo-einim, “Betliem vemiav-té gemǿqán, Zudia plovins-te ndøgo. Zapa ndǿgo, Mbumbukiam-ge manqa vevezam ezoqam, āv gene-peawám nqǽgo, ");
INSERT INTO kvg_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Qo Betliem vemiav, Zuda manqei mokho-te ndoqotu꞉gu, qo ambá av nqǣgo, iz mbaīn, Zuda khagua bawan mokho-te. Āv taoká. Zapa ndǿgo, qo mokho-te, megeat ezoqam kopo ndǿqán. Ndego nogi bawan ezoqam zǿkewagát, Izlael ezoqam.’” ");
INSERT INTO kvg_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Elod nqanek manqat ge-ewag, yaq ndego nduku gevezoat ezoqam ndømøváb. Khonoam-té genømøváb, neka ndukuam-qa yaq-te vøzømbē-bevap, gekha khøuwa-tê, ande gi꞉-ometam. ");
INSERT INTO kvg_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Yaq gi꞉-ometem ndøgo, ndego Betliem vemiav-té genø-khofotáz, vøzø̄-ein, “Nakhasam nandev, ùni mbøevawém. Yaq tozo-ometam, vø̀ndozáv, no vø̄e-nømøndem. Yaq até nó-a, tàbatenáv, bamømbō-vizam.” ");
INSERT INTO kvg_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nginik nduku gevezoat ezoqam, kawa ezoqam-qa manqat gumuyogem, tìnizáv. Yaq gi꞉-apat ndøgo, nqáe! Ndukuam ndugu, khøuwa fakhanam gi-ometam, gèzømbo-megetát. Yaq ndǿgo, tumø-itán, ma nakhasam ge꞉goam. ");
INSERT INTO kvg_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ndukuam gi-ometam, yaq ndigu khanakhanakh kandambá gindapem. ");
INSERT INTO kvg_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Khoev-te gimøfakhaz, nakhasam gi-ometam, evo namba, Meli, yaq até gindigonem, katuk ndømøkuí, sasa mbovizumem. Yaq moqos ndømboqogím, gol neka gigiap sisip mbomømboma, mboqotam nonqo, neka mel tae et, vømbō-etøomem. Ta gigiap-qa fia kandakandá. ");
INSERT INTO kvg_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Yaq ekeza manqei-te giqavaz, nakhoa vini ndøgeveém. Zapa ndǿgo, Mbumbukiam venanqei-tam-te, āv genezømás nqǽgo, “Elod-te nqawa ndøqàva᷄z.” ");
INSERT INTO kvg_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nduku gevezoat ezoqam gi-ivøvem, yaq nqáe! Zosef, Evezøza-gé enzol ezoqam mbofakhán, venanqei-tam-té, vømbō-ein, “Mòqosuzám. Nakhasam neka evo, Izip manqei-té qoté-khokhóq. Zapa ndǿgo, Elod ngenek nakhasam gemøndǽ-váo. Løvøwe-qa mbogó. Yaq Izip manqei-te ndøgo, até vøndoyagé, atema nqawa vøtaqandó-akhā.” ");
INSERT INTO kvg_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yaq Zosef até gendego, gè-itán, lová, nakhasam neka evo vø̄-upøzo, Izip manqei-te sasa ndøkhokhoz. ");
INSERT INTO kvg_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Yaq ndǿgo tiyagám, atema Elod vø̄nanim. Nqanek matev tønefakhán ndǿgo, Evezøza-qa manqat gè-unimanqatín, ndøgo ibugukhokhof tege manqa vevezam ezoqam mokho-te ge-ein, av nqægo, “Noge Yo, Izip manqei-té gegoám. Yaq nòmbo-akhá, vøndōwav.” ");
INSERT INTO kvg_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Elod ge꞉-otev, av nqægo, nduku gevezoat ezoqam gìmbøe-khavozømēm, yaq qaqa kandambá gego. Yaq até gendego, nakhei zitøge manqat ndøkhofotám. Betliem vemiav-te neka vemiav avøavun vø̄goat, gekha nakhei anganā ndigu, ndakinak qaniap, atema viav menas qazøndap, bèpakhaéz. Yaq tegi nakhag ezoqam ndigu nakheis vø̄zitag. Nduku gevezoat ezoqam Elod gi꞉-ometem, gekha khøuwa-te ndukuam ande guifakhan, yaq ndego sège-matøvém, nakhasam-qa viav, ndego løvøwe-qa gegoam, áv atægó. ");
INSERT INTO kvg_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nqanek matev qafakhan, yaq Mbumbukiam-qa Manqat, tege manqa vevezam ezoqam Zelemaya mokho-te ge-ein, gè-unimanqatín, ge-ein av nqægo, ");
INSERT INTO kvg_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Eiv ndøyogém, Lama manqei-te. Einu neka osombo kandambaqapé ndiwani. Ndigu sakheis, Laisol-gi zi, ekeza nakheis-qa ndø-eivumít, neka ezoqa kopømba mbaín, tiqa mokho-te tizø-khakheinam. Zapa ndǿgo, tigi nakheis gèpakhaéz. Mbaín.” ");
INSERT INTO kvg_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Elod ge꞉nanim, yaq nqáe! Izip manqei-te ndøgo, Zosef, Evezøza-ge enzol ezoqam mbofakhán, venanqei-tam-té, ");
INSERT INTO kvg_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","gembo-ein, “Mòqosuzám. Nakhasam neka evo, Izlael manqei-te nqawá qotéveséz. Zapa ndǿgo, ezoqam ndigu nandev nakhasam ambā tilaemɨn, ndigu mø̀ndø-pakhaéz.” ");
INSERT INTO kvg_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yaq Zosef gesuzam, nakhasam neka evo vø̄-upøzo, Izlael manqei-te sasa ndøqavaz. ");
INSERT INTO kvg_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Geté Izlael manqei-te gimøfakhaz ndøgo, Zosef āv gene-ewág nqǽgo: Kawa, Elod-gé yo Akileus ndø-itán, Zudia plovins-te ndøgo. Yaq ndego møe ndøgó, vǿewāv. Yaq venanqei-tam-te, Mbumbukiam manqat nøme mbo-eín. Yaq ndego até gegegevát, Gelili plovins-te vømø̄fakhaz. ");
INSERT INTO kvg_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Yaq Nazalet vemiav-té gimøqóm. Mbumbukiam tege manqa vevezam ezoqam mokho-te, Yesu-qa yaq-te, é-møndæ-eín, av nqægo, “Ndego Nazalet-ak mbó-akhaemát.” Yaq ndakin nqanek manqat gè-unimanqatín. ");
INSERT INTO kvg_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ta khøuwa-te ndøgo, Zion ndøfakhán, ndego ibøkha iz etoam ezoqam. Yaq ndego ezoqa zømesim ndøngáz. Leg-av manqei-té gene-zømesimám, Zudia plovins-te ndøgo. ");
INSERT INTO kvg_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Āv gezømbe-manqatám nqǽgo, “Mòzoqambúz. Zapa ndǿgo, Mbumbukiam-qa Megeat Matev avønín.” ");
INSERT INTO kvg_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Mbumbukiam tege manqa vevezam ezoqam Aezaya mokho-te, é-møndæ-eín, Zion-qa yaq-te. Āv gene-eín nqǽgo, “Leg-av manqei-te ndøgo, ezoqam-qa manqa wag ndǿ-akhayam. Āv qane-akhayám nqǽgo, ‘Evezøza-qa nakhoa é-mozoto-khakheinømém. Nakhoa ndaføyamba-qape zombøé-viæém, ndego te꞉geav.’” ");
INSERT INTO kvg_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Zion, ndabua ge-uzupam, kemol-qá su gini-geveaném, neka ndabua segim nonqo, søvakha gigiap-gí ngusúm gini-khakheinøvemém. Neka lou gelogam, bamøkhokeakh neká ndokhos, ti-mba ndígu telouzám. ");
INSERT INTO kvg_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ezoqa kopoáv gindupindam te-te. Nøme Zelusalem taon-té gindu-okhoám, neka até ndøgó-a, Zudia manqei-te ate qægoam, neka ta manqei ate qægoam ndøgo, Zoden kea avøavun qagoat, vøndō-okhoam. ");
INSERT INTO kvg_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yaq manqa-zapazapa ndøgo, gimatønumam, gèvøndæmám, neka Zoden kea-te ndøgo, ibøkha iz vø̄-upøgimam. ");
INSERT INTO kvg_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ezoqa ndigu, ibøkha iz upøgim-qa ginduzav, nøme Felisi ezoqám neka nøme Sadusi ezoqám. Andé kandambá ginduzav. Yaq Zion gezømet, āv gezømbe-eín nqǽgo, “Zo waza soqøsoqa. Ge zô, ndozo-matavap? Zo é-ndozó-khokhoz, Mbumbukiam-qa qaqa tøfakhan? ");
INSERT INTO kvg_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Matev eqeieqei vø̀khæ-matønømém. Yaq mokho tøfakhan ndøgo, tǿ-unimanqatín ndǿgo, zo unimanqatin zoqambúz, Mbumbukiam-te. ");
INSERT INTO kvg_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Neka zøkeza mokho-mba ndømanqàte᷄, av nqægo, ni Mbumbukiam gēngiænoāk, zapa ndø̄go, ni Eibleem-gī zī. No nqazǿ-manqate: Mbumbukiam kopømbaqapé, nginik nandi manqat mba zǿ-eín. Yaq segé-Eibleem-gí-zi-íz. ");
INSERT INTO kvg_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ila khakheinøváp. Tae ndǿbóu. Zapa-té qanømú-løvuvøemét. Gekha tāe ndøgo, nanga eqeieqei vi꞉mav ndøgo, gébouím, gøinam-te vǿnqagimēm. ");
INSERT INTO kvg_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","No zo ibøkha iz, ibøkhá qazømbe-etoumít, gekha ezoqām ndigu, manqa-zapazapa-te gigoam, ginduqambuz. Geté ndego ezoqam, noqa zita-te ngegeav, ndego no ùnime꞉-løvumbám. No ezoqa khàpe nøte-khapelavøqase-én. Até nqanek sasae khapelavøqasé-a, no teqa tamak khofoe-te tæmbotøke, no kopømba mbaín. Ndego zo ibøkha iz, Nqova Mbomambaqapé neka gøina wageáp gezømbé-etoumát. ");
INSERT INTO kvg_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ndego andé wit nanga evem ezoqam me mé꞉geáv. Wit evem nonqo ndǿ-ndapaváv. Yaq wit nanga ndǿ-evém, neka louzi nonqo ndigu, lou nqeitam nonqo khoev-té genǿ-nqeisám. Geté tag ndøgo, gøinam-té genǿløvutám. Ta gøinam ndøgo, miavmiav ndøwageáp. Khouvøemáv.” ");
INSERT INTO kvg_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ta khøuwa-te ndøgo, Yesu Gelili manqei-té gegoám. Yaq até ndegó-a, Zion-te vø̄mat, Zoden kea-te ndøgo. Ibøkha iz ndape-qa ndømát, te-te. ");
INSERT INTO kvg_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Geté Zion Yesu-qa matavap ambá ge-enendɨ́n, gembo-ein, “Ambá qo qonø-etoamɨ́n, ibøkha iz. Nō begó. Taoká ndøgo, qo no-te qoqotøndoqav, ibøkha iz tøtaqa-etoam.” ");
INSERT INTO kvg_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Geté yaq Yesu gembo-qavøiu, “Ság. Ibøkha iz sègenø-etoám. Matev eqeieqei ate ndægo, sà bizimu-matanám, av Mbumbukiam ndømbøe-poev.” Yaq Zion sègembopóe, ibøkha iz vømbō-etoam. ");
INSERT INTO kvg_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu ibøkha-te gende-fakhan, yaq nqáe! Yan tø̀ne-mboqoé. Yaq āv geneqeív nqǽgo: Yan-te ndo꞉go, Mbumbukiam-gé Nqova ndovís. Andé kuvøkuvuam me me꞉løvuvavún, te-te vō꞉qom. ");
INSERT INTO kvg_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Yaq yan-te ndo꞉go, manqa wag ndofakhán. Āv qande-eín nqǽgo, “Ngenek nogé yó. No poev kandambá te-te, neka no nø̀mbøe-khafuát.” ");
INSERT INTO kvg_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yaq Nqova Mbomambaqape, Yesu leg-av manqei-té genø-itú. Yaq nqova soqaqape tèabeme-khamás. ");
INSERT INTO kvg_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Leg-av manqei-te ndøgo, Yesu khøuwa kopoáv, ate gi꞉goam, khøuwa fotí, lovølova neká pavpave, lou logemav matev ndøgoám. Yaq ifin mbovín. ");
INSERT INTO kvg_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Yaq nqova soqaqape, ndego ezoqa khamasim matev-te nde-abam, tendowáv ndǿgo, vømbō-ein, “Qo Mbumbukiam-ge Yo toqogoat, yaq nginik nandi, manqat mba qozǿ-eín. Yaq segé-lou-éz.” ");
INSERT INTO kvg_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Geté yaq Yesu manqat gembo-qavøiu, “Āv taoká. Mbumbukiam-qa Manqat, āv qane-peawáp nqǽgo, ‘Ezoqa kopømba mbaín lou mba ti꞉yagat. Geté Mbumbukiam-qa manqat ate ndægo, teqa tou-te ndøndo-fakhate, ndǿgo tiníyagát.’” ");
INSERT INTO kvg_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Yaq nqova soqaqape, Zelusalem taon-té genø-itú, Mbumbukiam-qa khoev uni ova-in ndo꞉go vømø̄ve, sasa mbo-ein, ");
INSERT INTO kvg_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Qo Mbumbukiam-ge Yo toqogoat, soqóvuáq nqánek, atema manqei-te. Zapa ndǿgo, Mbumbukiam-qa Manqat, āv qane-peawáp nqǽgo, ‘Mbumbukiam ekeza enzol ezoqam, manqat ndø̀zø-eín, qo zapaya. Yaq ndigu sogó-ndøpøqém. Yaq qoqa zenda tokhotapak, nandi-te kha geqá-khanøyák.’” ");
INSERT INTO kvg_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Geté Yesu gembo-qavøiu, “Mbumbukiam-qa Manqat nøme, āv qane-peawáp nqǽgo, ‘Qo Evezøza, qoge Mbumbukiam, khamasim-te ndø-àwa᷄m.’” ");
INSERT INTO kvg_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Yaq vaev-te, ndego nqova soqaqape, Yesu olol ová genø-itú, taqa eqæv kandambá tantáv, neka manqei-manqei ate ndægo, manqei-qape-te nqago, neka gigiap mbomømboma ate ndægo, ta manqei-manqei-te ndøugu, vø̄e-omat, ");
INSERT INTO kvg_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","sasa mbo-ein, “Noqa megemege-te nqanek, qakeza kha, manqei toqote-lavao, neka voqonǿ-vizām, yaq nqanek gigiap ate nqægo, nøtaqá-etoám.” ");
INSERT INTO kvg_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yaq Yesu gendo-qavøiu, “Mòqoqáv qo, Saitan. Mbumbukiam-qa Manqat, āv qane-peawáp nqǽgo, ‘Evezøza-qá iz qó-eqatát, ndego qoge Mbumbukiam. Neka te-mba ndégo, toqombó-vizupát.’” ");
INSERT INTO kvg_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yaq nqova soqaqape, Yesu sège-iváv, vø̄wav. Yaq enzol ezoqam ndozáv, vømømbō-tøkeem. ");
INSERT INTO kvg_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu ge-ewag av nqægo, Zion ndego ibøkha iz etoam ezoqam, ndimbula-tē ginø-utøvēm, yaq ndego Gelili plovins-té genøveséz. ");
INSERT INTO kvg_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Geté ndego ambá av nqǣgo, ekeza vemiav-tē gemøqōm, Nazalet, geté Kapenaum taon-té genøyág. Ta taon ndøgo, Gelili kewan avønin-té qagó. Zebulon neka Naftali, tiqá khagua bawan-qá manqeí. ");
INSERT INTO kvg_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yesu av ge꞉matanam ndægo, yaq manqat ndøgo, Mbumbukiam tege manqa vevezam ezoqam Aezaya mokho-te ge-ein, gè-unimanqatín, av qæ-ein nqægo, ");
INSERT INTO kvg_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ndigu ezoqam, Zebulon neka Naftali manqei-te ndiyage, ta nakhoa-te ndøgo, ndaola-te ndø-ovøev, ndøgo Zoden kea yaq-keoqa, ndøgo Gelili manqei ndimbo-akhayam, bawan vini-ak-qa manqei, ");
INSERT INTO kvg_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ndigu ezoqam, bøivun-te ndiyage, ndigu waev ndøqeivím. Waev kandambaqapé. Tiqa manqei andé løvøte manqeí. Bøivunín. Geté ti mokho-te, waev ndøfakhán.” ");
INSERT INTO kvg_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yesu, sasae, ta khøuwa-té ndǿgo tenøngáz. Ezoqa āv gene-zømesimám nqǽgo, “Mòzoqambúz. Zapa ndǿgo, Mbumbukiam-qa Megeat Matev avønín.” ");
INSERT INTO kvg_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu Gelili kewan ndøgeg-te ge-ewat, yaq evenap menas tezømét ndǿgo. Nøme Saemón. Iz nøme gimbo-akhaemam, Pitá. Neka nøme, Endlú. Voe ndø-ogiát. Zapa ndǿgo, nginik ezoqa menas, voe nqagim ezoqám. Ndøgo tiqá sasáe. ");
INSERT INTO kvg_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yaq Yesu gezø-ein, “Vø̀ndozáv. No zonøndó-paevém. Yaq zo ezoqa takhaset matev nøté-zømesím.” ");
INSERT INTO kvg_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yaq até gindigonem, voe sège-ivøvém, sasa mbopaevem. ");
INSERT INTO kvg_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yaq até ge-ewát, ndøgeg-te ndøgo, evenap menas nøme vø̄zømet, Zēms neka Zion. Ndigu Zebedi-gí nakheís. Khagua-té gunuguvám, eve namba. Voe ndøkhakheinumát. Yaq Yesu gèzø-akhá. ");
INSERT INTO kvg_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Yaq ndigu evenap menas, ndaføyambá, sègeqá. Eve sège-ivøvém, khagua-te, Yesu vømbō-paevem. ");
INSERT INTO kvg_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu Gelili plovins ate ndǽgo sugumu-vatát, ezoqa tiqa guliguli khoev-te vø̄e-zømesimat. Manqat Mbomambaqape, Mbumbukiam-qa Megeat Matev-qá yaq-té zømbe-manqatát, neka ezoqa enqoni bugug vinivinimba vø̄khakheinøvemat. ");
INSERT INTO kvg_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Teqa manqat, sège-panqavøém. Qámbá. Ambá ta-mba ndø̄go, Gelili plovins-te mbā, geté até Silia plovins-té-a, ate ndægo, sège-panqavøém. Yaq ezoqa ate gi꞉goam, enqoni qazøgoam, te-te ndégo tinø-upøgimám. Enqoni bugug vinivinimbá. Nøme nqosøgeap kandakanda zøgoám neka nøme nqova soqøsoqa vøzømbū-goam. Nøme ndigu gèzø-qanøvøemám, neka nøme kha vøzø̄-wauwauwam. Yaq Yesu gèkhakheinøvemám. ");
INSERT INTO kvg_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ezoqa kandambá gimbopavam. Nøme, Gelili plovins-ák, neka nøme vemiav-ten-manqei-ák neka nøme Zelusalem taon-ák, neka nøme Zudia plovins-ák. Neka nøme Zoden kea yaq-keoqá gindu-okhoám. ");
INSERT INTO kvg_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu ezoqa kopoav-qape gezømet, te-te gindupindam, yaq manqei poyat-té genøqavíg, vømø̄qom, neka tegi paev ezoqam vømbō-qonav. ");
INSERT INTO kvg_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yaq Yesu nømendim manqat ndøngáz, gezø-ein, ");
INSERT INTO kvg_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ezoqa ndigu, Mbumbukiam-qa megemege-te, ande khakha-mba ndigu, khanakhanakh mbá giabitigú. Zapa ndǿgo, Mbumbukiam-qa Megeat Matev, tiqa ndígu. ");
INSERT INTO kvg_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ezoqa mutøkhop ndiwaniap, ndigu khanakhanakh mbá giabitigú. Zapa ndǿgo, Mbumbukiam tiqa mokho-te ndø̀khakheinám. ");
INSERT INTO kvg_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ezoqa ekeza iz eqawatav ndigu, ndigu khanakhanakh mbá giabitigú. Zapa ndǿgo, manqei-qape tiqa ndígu tǿgoát. ");
INSERT INTO kvg_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ezoqa matev eqeieqei-te, ande ifin me ndøzømbe-viti neka ande ibøkha naq me ndøzømbe-papat, ndigu khanakhanakh mbá giabitigú. Zapa ndǿgo, Mbumbukiam ndø̀zø-etoám, ate vøzǿ-ewēz. ");
INSERT INTO kvg_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ezoqa tanakh matev ndøzøgo, ndigu khanakhanakh mbá giabitigú. Zapa ndǿgo, Mbumbukiam tanakh matev ndø̀mbogoát ti-te. ");
INSERT INTO kvg_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ezoqa tiqa mbøni mokho-te, eqeieqei ndigu, ndigu khanakhanakh mbá giabitigú. Zapa ndǿgo, ndigu Mbumbukiam ndǿ-ometám. ");
INSERT INTO kvg_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ezoqa sambi matev ndikhakheinam, ndigu khanakhanakh mbá giabitigú. Zapa ndǿgo, Mbumbukiam ndigu ekeza nakhei mé꞉zǽb. ");
INSERT INTO kvg_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ezoqa ndigu matev eqeieqei zapaya, ngiæzoat matev-te ndiyage, ndigu khanakhanakh mbá giabitigú. Zapa ndǿgo, Mbumbukiam-qa Megeat Matev, tiqa ndígu. ");
INSERT INTO kvg_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Unimanqatín. Zo khanakhanakh mbá qanegó, zo ezoqa no zapaya tingenøzotat neka yage tizøngi꞉tat neka khavozam manqat vinivinimba timanqatat, zoqa yaq-te. ");
INSERT INTO kvg_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Até Mbumbukiam-gí manqa vevezam ezoqám-a, ibugukhokhof giyageapam, āv tini-ngiæzotám. Yaq nakémbá, zo gèkhóum neka khanakhanakh mba bezø-asøtøvé. Zapa ndǿgo, yan-te nqo꞉go, zo yaq-fia kandambaqape ndøzømbó-keoge.” ");
INSERT INTO kvg_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Zo manqei-qape ezoqam-qa mokho-te, andé ngalám. Geté ngalam mokhov tømømbo-navøem, yaq nqawa áv kiní-ngalam-mokho-mba-ēz? Nakhoa mbaín. Soqóqousám. Yaq ezoqa segé-tokhonøvemát. ");
INSERT INTO kvg_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Neka zo nqanek manqei-qape-te, andé wáev. Gèmbo-mataváp. Taon manqei poyat-te to꞉goat, kopømba mbaín tøkhonawat. ");
INSERT INTO kvg_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Neka ezoqa lampa gimagemɨn, yaq ndigu ambá av nqǣgo, ndis mo꞉khafuzimīn. Geté lampa asøzam nonqo-té ginø-wuøemín. Yaq ezoqa ewaqape, khoev mokho-te tu꞉goat, waev sugumú-ndapét. ");
INSERT INTO kvg_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yaq zo até kopó. Zoqa matev andé waev me betekháev, ezoqam-qa megemege-te. Yaq ndigu zoqa matev eqeieqei tiqeivat, ndigu Mbumbukiam-qá iz ndǿ-eqatát, ndego zoge Zøve, yan-te ngo꞉yage.” ");
INSERT INTO kvg_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Zo ndømatàva᷄p av nqægo, no Mozes-qa guguna manqat neka Mbumbukiam-gi manqa vevezam ezoqam-qa manqat nqagim-qa nøgeavūn. Āv taoká. No ambá av nqǣgo, tiqa manqat nqagim-qa nøgeavūn. Geté no nqánek qategeavún: Tiqa manqat tàbete-unimanqatín. ");
INSERT INTO kvg_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","No unimanqatín nqazø-manqate. Yan neka manqei-qape bugukhokhof mó꞉navøém. Geté Mbumbukiam-qa guguna manqat mokho-te, peawap-qase o iz-zapa-qase naqanøká gemǿ-navøemák. Ndøgo até gégoát, atema matev ate ndægo vømú-fakhanām, av bugukhokhof ge꞉-ein. ");
INSERT INTO kvg_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yaq nakémbá. Gekha ezoqām ndego, Mbumbukiam-qa guguna manqat-qase tenqawa, até ndøgó-a, manqat khapelavøqase mba tøgoat, neka ezoqa nøme matev av nqægo vǿe-zømesimāt, ndego Mbumbukiam-qa Megeat Matev mokho-te, iz mbain ezoqam mé꞉vewát. Geté gekha ezoqām ndego, Mbumbukiam-qa guguna manqat tembopavat, neka ezoqa nøme matev av nqægo vǿe-zømesimāt, ndego Mbumbukiam-qa Megeat Matev mokho-te, iz kandambaqape mbógoát. ");
INSERT INTO kvg_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","No nqazǿ-manqate: Zoqa matev eqeieqei, ndigu Felisi neka Mozes-qa guguna manqat nømendim ezoqam-qa matev eqeieqei løvupøteav tøgoat, yaq zo Mbumbukiam-qa Megeat Matev mokho-te zomǿ-ozák.” ");
INSERT INTO kvg_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Zo mø̀zøte-zøtéz, Mozes-qa guguna manqat, nigi atanakha-zapazapa-za qazøfakhan, āv qane-eín nqǽgo, ‘Ezoqa pakhapakha zøkhanèa᷄m. Gekha ezoqām ndego, ezoqa pakhapakha tekhana, ndego manqa ovøyam-té geabenø-itán.’ ");
INSERT INTO kvg_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Geté no nqazǿ-manqate: Ti-mbá tiuká ndigu, manqa ovøyam-te timøwanim, ndigu pakhapakha sa ndikhanæ. Geté até ndegó-a, gekha ezoqām ndego, ezoqa nøme-te qaqa ndømbogo, manqa ovøyam-té gemǿ-itán. Neka gekha ezoqām ndego, ezoqa nøme-te naqei telouzat, ndego manqa ovøyam kandambaqape-té gemǿ-itán. Neka gekha ezoqām ndego, ezoqa nøme bianav nde꞉vewe, ndego yà beto-feaiwát. Soqaín ndøgo, Mbumbukiam gøinam-te temø-ogiu. ");
INSERT INTO kvg_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Yaq nakémbá. Qo Mbumbukiam-te, etoam matev gone nonqo lou-qase-te, etoam matev-qa toqogoat, yaq qo qombō-matøvēm, av nqægo, ezoqa nøme qaqa ndømbôgō qo-te, ");
INSERT INTO kvg_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","yaq qo gigiap sègekhæ-iváv ndøgo. Yaq soqotøkhǽ-qaváq, ndego ezoqam namba manqat vozomǿ-khakheinømēm. Yaq tozotumu-khakheinømem, Mbumbukiam-qa khoev-te, até khæ qóveséz, etoam matev voqomǿgō. ");
INSERT INTO kvg_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Gèmbo-mataváp. Qo ezoqa nøme-te moni ndiqambo-løfoke, yaq ndego qo manqa ovøyam-te ndapaqat-qa tegoat, qo manqat vø̀kho-khakheinám, te namba, ate av-té nakhoa-te tøzøte-apet. Soqaín ndøgo, ngenek ezoqam qo manqa ovøyam megeat-qa zenda-te teve, yaq ndego qo polis ezoqam-qa zenda-te vǿvē, ndimbula-te sasa ndǿ-utøqēm. ");
INSERT INTO kvg_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","No unimanqatín nqataqa-manqate. Qo ndøgo naqanøká qotøndøkhǽ-fakhaqák, atema fia ate ndægo voqotumúgū.” ");
INSERT INTO kvg_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Zo mø̀zøte-zøtéz, Mozes-qa guguna manqat, āv qane-eín nqǽgo, ‘Qo nøkenøkem matev ndøngì꞉wa᷄t.’ ");
INSERT INTO kvg_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Geté no nqazǿ-manqate: Ta-mbá taoká ndøgo. Geté gekha ezoqām ndego, sævam sa tewawam, neka poev vømbówāv, ndego nqova-te, mambe mø̀ndømbogó, nøkenøkem matev vø̄ngiu. ");
INSERT INTO kvg_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Yaq nakémbá, qoqa nakeamo bøi, manqa-zapa-te tø-ituq, gèkhofá. Yaq qó-ogí. Kha kopo sa tøqa-navøem, ndøgo kopømbá. Geté soqain ndǿgo, Mbumbukiam qoqa kha ate ndægo gøinam-te sa tumu-ogi. ");
INSERT INTO kvg_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Yaq qoqa nakeamo zenda, manqa-zapa-te tø-ituq, gèkepáz. Yaq qó-ogí. Kha kopo sa tøqa-navøem, ndøgo kopømbá. Geté soqain ndǿgo, qoqa kha ate ndægo gøinam-te sa tømuwav.” ");
INSERT INTO kvg_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Mozes-qa guguna manqat mokho-te, manqat nøme āv qane-eín nqǽgo, ‘Gekha ezoqām ndego, zas ivøve-qa tegoat, ndego sakhei zøuvis pepa bepeawám, bembō-etoam.’ ");
INSERT INTO kvg_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Geté no nqazǿ-manqate: Gekha ezoqām ndego, sævam te-ivav, getē ndugu mambe okhoeāv, ndego nøkenøkem ngi꞉wat matev neka mambe matev-té gunǿvé, ndugu. Neka gekha ezoqām ndego, sævam av nguigu tu-okɨ, ndego mambe mé꞉wáv, tu namba, neka nøkenøkem matev vǿngiū.” ");
INSERT INTO kvg_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Até nqanék-a, zo mø̀zøte-zøtéz. Mozes-qa guguna manqat, nigi atanakha-zapazapa-za qazøfakhan, āv qane-eín nqǽgo, ‘Manqa mbusa ndøgo, Mbumbukiam-qa bøi-te qoqove, betaqambèpa᷄. Geté vø̀matanám, av Evezøza qoqombøe-ein.’ ");
INSERT INTO kvg_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Geté no nqazǿ-manqate: Ta-mbá taoká ndøgo. Geté zoqa manqat, unimanqatin mba begó. Zo Mbumbukiam-te zenda ndø-eqàgi᷄m neka yan-qa iz ndøvèwa᷄m, zoqa manqat bazaføgakh etoam nonqo. Zapa ndǿgo, yan Mbumbukiam-qá qonam nonqó. Ndego ndǿgo teno꞉qomát, manqei-qape ndo꞉kawaevat. ");
INSERT INTO kvg_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Neka zo manqei-qape-qa iz ndøvèwa᷄m, zoqa manqat bazaføgakh etoam nonqo. Zapa ndǿgo, manqei-qape, Mbumbukiam-qá zenda tokhotapak awam nonqó. Neka zo Zelusalem taon-qa iz ndøvèwa᷄m, zoqa manqat bazaføgakh etoam nonqo. Zapa ndǿgo, Zelusalem, Mbumbukiam-qá taón, ndego Kawa Ezoqam Kandambaqape. ");
INSERT INTO kvg_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Neka ndømanqàte᷄, av nqægo, noqa kawa yà besoqá, noqa manqat unimanqatinteav tøgoat. Zapa ndǿgo, até nqanek matev-qasé-a, qo kopømba mbaín toqogo, qoqa kawa-te izum kopo toqo-enend, tiqapaqez o vøqákisēz. ");
INSERT INTO kvg_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","‘Ya’ tozo-manqatat, yaq ‘ya’ begó. ‘Mbain’ tozo-manqatat, yaq ‘mbain’ begó. Matev nøme tozogoat, zøkeza manqat bazaføgakh etoam nonqo, ndøgo nqova soqaqape-té qando-okhó.” ");
INSERT INTO kvg_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Zo mø̀zøte-zøtéz, Mozes-qa guguna manqat, āv qane-eín nqǽgo, ‘Gekha ezoqām ndego, ezoqa nøme-qa bøi tepusua, até ndegó-a, yaq teqa bøi bèmbo-pusuaném. Neka gekha ezoqām ndego, ezoqam-gi khayam tekhaozo, até ndegó-a, yaq khayam bèmbo-khaozonám.’ ");
INSERT INTO kvg_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Geté no nqazǿ-manqate: Ezoqa manqa-zapa tego qo-te, qo yaq-fia ndø̀ta᷄. Gekha ezoqām ndego, nakeamo tømøi teqatøkub, yaq até yogea tømǿi-a betaqā-tøkub. ");
INSERT INTO kvg_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Neka ezoqa nøme, qo manqa ovøyam-te teve, neka qoqa ndabua-qase ndape-qa vǿgoāt, yaq qo ndego até qoqá ndabua sekeqapé-a, soqombó-etoám. ");
INSERT INTO kvg_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Neka ezoqa tetøpøtaq, teqa gigiap ande av 1 kilomita ndægo toqombo-eqa, yaq qo 2 kilomita qombó-eqá. ");
INSERT INTO kvg_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ezoqa gigiap-qa teqaviam, o av teqambe-ein nqægo, ‘Gigiap sætøkhǣndāp. Nango ndø̀taqa-etoām.’ Yaq qo sègembo-etoám.” ");
INSERT INTO kvg_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Zo mø̀zøte-zøtéz, ezoqa āv gini-manqaté nqǽgo, ‘Qogi ezoqam-te, kuku betaqagó. Neka qogi qaqa ezoqam, qozǿ-sanqawupát.’ ");
INSERT INTO kvg_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Geté no nqazǿ-manqate: Zo kuku bezøgó, zogi qaqa ezoqam-te. Neka gèzø-guligulím, ndigu zo yage føgakh-qape ndizø-etoam. ");
INSERT INTO kvg_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Av tøzøtegoat ndægo, yaq zo unimanqatin Mbumbukiam-gí nakheís. Zapa ndǿgo, até zogé Zøvé-a, ndego yan-te ngo꞉yage, teqa matev kopó. Ndego khøuwa waev, ezoqa eqeieqei neka soqøsoqa, sùguzumbu-etoám, neka ndego qæ ndēzø̄-ētōām, ndigu matev eqeieqei ndigu neka ndigu matev soqøsoqa ndigu. ");
INSERT INTO kvg_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Zo kuku ti-te mba tøzøgoat, ndigu zo-te kuku ndøzøgo, yaq zo Mbumbukiam-te gekha yaq-fia zomǿqeivīm? Yaq-fia zomǿ-qeivimák. Gèmbo-mataváp. Até teks moni upøgim ezoqám-a, ndigu Mbumbukiam-qa manqat paeveav ndigu, ndigu kuku ndøzø̂gó, gekha ezoqa nøme-te, ti-te kuku ndøzøgo. ");
INSERT INTO kvg_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Neka gê, zogi zøfuap mba ndozozø-khanakhanakhat, yaq zo matev vini tozógo? Āv taoká. Até bavokho-ák-a, ndigu Mbumbukiam zøtezateav ndigu, ndigu matev kopo ndøgó. ");
INSERT INTO kvg_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Geté zoge Zøve, ndego yan-te ngo꞉yage, ndaføyamba-qapé. Yaq até zó-a, ndaføyamba-qape āv tøne꞉gó.” ");
INSERT INTO kvg_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Aiyá qagó. Matev eqeieqei tozo-matønumat, kopømba mbaín, ezoqa ewaqape-qa bøi-te tozogoat, yaq ndigu zoqa matev tinīqeivāt. Av tøzøtegoat ndægo, yaq zo yaq-fia zomǿ-ndapemák, zoge Zøve-te, ndego yan-te ngo꞉yage. ");
INSERT INTO kvg_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Zo gigiap-av ezoqam tozozø-tøkeat, yaq zo ezoqa ewaqape-te me꞉khambùva᷄p, taqa yaq-te, av khavozam ezoqam guliguli khoev-te o nakhoa-te gi꞉goatun, yaq ezoqa tiqa iz vøzømbé-eqatāt. No unimanqatín nqazø-manqate: Ndigu yaq-fia mø̀ndømu-ndapém. Nøme gemǿ-ndapemák. ");
INSERT INTO kvg_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Geté gigiap-av ezoqam toqombo-tøkeat, yaq qoqa yogea zenda bete-otèva᷄t, matev ndøgo, qoqa nakeamo zenda ndoqote-matanam. ");
INSERT INTO kvg_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Gigiap khonoam-té qanø-etoám. Yaq qoge Qave, ndego ezoqam-qa matev ndeqeivi, khonoam-te ndimatanam, ndego yaq-fia ndø̀qa-etoám.” ");
INSERT INTO kvg_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Tozo-guligulimat, zo matev ndø̀go᷄, av khavozam ezoqam ndi꞉matanam. Ndigu tøzømbe-khaneát ndǿgo: Guliguli khoev-tē neka nakhoa-té ginǿ-wanimát, neka ezoqa ewaqape-qa bøi-te sasa ndǿguligulimāt, yaq ezoqa tiqa matev vǿe-qeivāt. No unimanqatín nqazø-manqate: Ndigu yaq-fia mø̀ndømu-ndapém. Nøme gemǿ-ndapemák. ");
INSERT INTO kvg_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Geté qo Mbumbukiam-te toqo-guligulimat, qo khoev mokho-té qanø-oqát, mboqog voqotó-tokazāt, Tat-te sasa qóguligulimāt, ndego ezoqam ometupav. Yaq qoge Qave, ndego ezoqam-qa matev ndeqeivi, khonoam-te ndimatanam, ndego yaq-fia ndø̀qa-etoám. ");
INSERT INTO kvg_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Zo tozo-guligulimat, yaq khokho manqat khapé bezømbe-khouwèva᷄t, av bavokho ezoqam ndi꞉matanam, ndigu Mbumbukiam zøtezateav ndigu. Ndigu ndimatavap, manqat seke-mba ndimanqate, yaq tigi mbumbuk tìabezømbe-ewág. ");
INSERT INTO kvg_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Geté zo tiqa ndigu me꞉qeìvi᷄. Zapa ndǿgo, zoge Zøve é-møndæ-otevɨ́n, av zo-te mbain ndægo. Zo okhokho-té qazonømbo-viømemɨ́n, taqa yaq-te. ");
INSERT INTO kvg_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yaq nakémbá, zo āv qane-guligulím, av nqægo: ‘Nigi Tat, qo yan-te nqoqoto꞉go. Qoqa iz, yà beto-eqawát. ");
INSERT INTO kvg_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Qoqa Megeat Matev bètøndowáv ni-te. Qoqá poev matev mba bambupáev, nqanek manqei-qape-te, ate av-té, yan-te ndimbøe-paev. ");
INSERT INTO kvg_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Qo nqægo khaiya lou vø̀ni-etoám, av ni lou mbain nqati꞉gu. ");
INSERT INTO kvg_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Niqa manqa-zapazapa, sà betaqambo-naváp, ate av-té, ni ezoqa nøme-qa manqa-zapazapa sa qanimbo-navupatun, ni-te gimatønumatun. ");
INSERT INTO kvg_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Qo ni khamasim-te ndø-àmba᷄m. Geté gìnitøkeé, ezoqa soqaqape andé vǿe-ngiænō.’” ");
INSERT INTO kvg_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Yesu nqanek guliguli manqat gumu-zømesim, yaq nøme āv gezømbe-eín nqǽgo, “Unimanqatín. Zo ezoqa nøme-qa manqa-zapazapa sa tøzømbo-navupat, yaq zoge Zøve, ndego yan-te ngo꞉yage, até zó-a, zoqa manqa-zapazapa segembøé-navøemát. ");
INSERT INTO kvg_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Geté zo ezoqa nøme-qa manqa-zapazapa sa navøepøteav tøgoat, yaq zoge Zøve, matev até kopó, zoqa manqa-zapazapa, sa gembøé-navøemák.” ");
INSERT INTO kvg_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Zo lou logemav matev tozo-gonemat, yaq zo khavozam ezoqam-qa me꞉qeìvi᷄. Ndigu tiqa bugug, khanakhanakh mbaín sege-kewagatún, ezoqa nøme vǿezøtezīn, ndigu lou logemav matev ndøgōt. No unimanqatín nqazø-manqate. Ndigu yaq-fia mø̀ndømu-ndapém. Nøme gemǿ-ndapemák. ");
INSERT INTO kvg_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Geté qo lou logemav matev toqogoat, bugug qósunguzát neka eqeieqei voqó-kewagāt, av qo oskia ndoqote-keoge. ");
INSERT INTO kvg_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Yaq ezoqa gézøtezák, av nqægo, qo lou logemav matev qōgōt. Qave mba mé꞉-otév, ndego ezoqam ometupav. Yaq qoge Qave, ndego ezoqam-qa matev ndeqeivi, khonoam-te ndimatanam, ndego yaq-fia ndø̀qa-etoám.” ");
INSERT INTO kvg_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Zo gigiap qaniqanim khapé bezømbe-møvø̀ya᷄m, nqanek manqei-qape-te, khotet mba ngiloge, neka nagi mba nqavøtøyam, neka aqonam ezoqam ngī-āqōnām. ");
INSERT INTO kvg_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Geté zo gigiap qaniqanim, yan manqei-té qanø-møvøemét. Yan manqei-te ndo꞉go, khotet gemǿ-logemák neka nagi gemǿ-vøtøeamák neka aqonam ezoqam gemǿ-aqonamák. ");
INSERT INTO kvg_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Matev āv tøzøté-goném. Zapa ndǿgo, ma qoqa gigiap qaniqanim ndægo, até qoqa mataváp-a, sa ndǿgo tǿgoát.” ");
INSERT INTO kvg_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Qoqa kha, waev bøi mbo-etoám. Bøi eqeieqei tøgoat, yaq kha ate ndægo, waev-té qágoát. ");
INSERT INTO kvg_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Geté qoqa bøi soqain tøgoat, yaq qoqa kha ate ndægo bøivun-té qanú꞉goát. Yaq ta waev ndøgo, qoqa mokho-te ndøugu, ande bøivun me tægoat, yaq bøivun ndøgo, kandambá tantáv.” ");
INSERT INTO kvg_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Ezoqa kopømba mbaín, kawa ezoqa menas timbogoat, tezø-sasaetat. Kawa ezoqa menas timbogoat, yaq nøme ndego, gembó-pøovát. Geté nøme ndego, gembøé-qasi꞉vát. Nøme ndego, teqa manqat o-mba mbøéndapát. Geté nøme ndego, teqa manqat gembó-sanqawát. Yaq até zó-a. Zo kopømba mbaín, Mbumbukiam-qa mokho-te neka moni-qa mokho-te sa tozotumu-goat.” ");
INSERT INTO kvg_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Yaq nakémbá, no nqazǿ-manqate: Zo yage-qa yaq-te ndøfofògea᷄p, av nqægo, gekha lou o gekha ibøkha zólogāt. Neka kha-qa yaq-te ndøfofògea᷄p, av nqægo, gekha ndabua zó-uzumāt. Yage-qa mokho, taoká ndøgo, lou mba toqologat. Neka kha-qa mokho, taoká ndøgo, ndabua mba toqo-uzumat. ");
INSERT INTO kvg_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pipisi zøtézømēt. Ndigu avøe gigiap ogekhæmáv, neka gendó-peanemák, lou khoev-te vǿnqeitøvēm. Geté zogé Zøve ndøzøkefé, ndego yan-te ngo꞉yage. Gèmbo-mataváp. Zo teqa bøi-te, pipisi ùni zøte-løvubám. ");
INSERT INTO kvg_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ge zô ndozo-matavap, ezoqa kopo zo mokho-te tefofogeapat, ndego yage elavøqase ndømbó-seketet? Mbaín! ");
INSERT INTO kvg_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Neka gekha zapâ, ndabua-qa ndozo-fofogeap? Flawas zøtézømēt, gagayag-te ndi-umizan. Ndigu sasae gonemáv neka ndabua potofumáv. ");
INSERT INTO kvg_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Geté no nqazǿ-manqate: Até Solomón-a, ndego kawa ezoqam kandambaqape, gigiap mbomømboma kopoav-qape qambogoam, teqa ndabua bugug keoge mbaín, av flawas ndi꞉gu, tiqa bugug ndækeoge. ");
INSERT INTO kvg_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nginik flawas, ndakin gagayag-te ndi-umianet, nakhamas-te ambá giní-pakhaéz. Yaq gøinam-té ginǿ-nqagivemém. Geté Mbumbukiam ndabua bugug keoge eqeieqei zø-etoám. Yaq ge zô ndozo-matavap, Mbumbukiam zo ndabua gezǿ-uzamāk? Āv taoká. Zoqa unimanqatin khapémbá, Mbumbukiam-te. ");
INSERT INTO kvg_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yaq nakémbá, zo ndøfofògea᷄p, av nqægo, ‘Gekha lou zílogāt?’ neka ‘Gekha ibøkha zí-izumāt?’ o ‘Gekha ndabua zí-uzumāt?’ ");
INSERT INTO kvg_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Gigiap av nqægo upøgim-qa yaq-te, miavmiav bavokho-ak mba ndømataváp, ndigu Mbumbukiam zøtezateav ndigu. Geté zoge Zøve, ndego yan-te ngo꞉yage, ndego mø̀ndæ-otév, zo gigiap av nqægo bèzøgó. ");
INSERT INTO kvg_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Zo bugukhokhof Mbumbukiam-qa Megeat Matev neka teqa matev eqeieqei zombó-vawemát. Yaq ndego zo nqanek gigiap nøme ate ndægo ndø̀zø-etoám. ");
INSERT INTO kvg_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yaq nakémbá, zo ndøfofògea᷄p, qasun-qa yaq-te, andé gekha matev me ndǿfakhān. Qasun-qa viniv qasun mba qó-eqatét. Ság, nqægo khaiya, nqægo khaiya-qa viniv mba toqo-eqatet.” ");
INSERT INTO kvg_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Zo ezoqa nøme ndøvøozòa᷄t. Soqaín ndøgo, Mbumbukiam zo tevøozo. ");
INSERT INTO kvg_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Av zo ezoqa nøme-qa matev ndøzøte-gevewat, Mbumbukiam zoqa matev āv tené-geveá. Neka av zo gigiap o matev ndøzøte-geveam, Mbumbukiam zo āv tezømbé-geveám. ");
INSERT INTO kvg_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Gekha zapâ, qafu-qa bøi-te kupuk-qase ndoqoqeivi, getē tae-qape ndøgo, qakeza bøi-te nandaqa-genøe, qo qeivupāv? ");
INSERT INTO kvg_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Gekha zapâ, qafu av ndoqombøe-manqate, ‘No kupuk-qase, bøi-te nandaqa-genøe, nøtaqālīv,’ getē qakeza bøi-te, tae-qape nandaqa-genøe? ");
INSERT INTO kvg_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Qo khavozam ezoqám. Bugukhokhof nándav, toqólív, tae-qape, qakeza bøi-te nandaqa-genøe, eqeieqei voqókewāg. Yaq váev, qafu-qa bøi-te, kupuk-qase ndøugu, toqoliv.” ");
INSERT INTO kvg_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Mbumbukiam-qa gigiap mbomømboma gaqo zø-ètoa᷄m. Ndigu segendó-qambúz, zo vǿfoqobām. Neka gigiap fia kandakanda bøsik-te ndønqàgi᷄m. Ndigu segé-tokhonumát.” ");
INSERT INTO kvg_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Gèviám. Yaq Mbumbukiam ndø̀zø-etoám. Gèváo. Yaq zo ndòzo-qeivím. Gèkhaneám. Yaq Mbumbukiam zo mboqog ndø̀zø-mboqozó. ");
INSERT INTO kvg_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Unimanqatín. Gekha ezoqām ndego, ndeviam, ndego ndø̀ndáp. Neka gekha ezoqām ndego, ndevao, ndego ndø̀qeív. Neka gekha ezoqām ndego, mboqog-te ndekhaneam, ndego mboqog ndø̀mbo-mboqóz. ");
INSERT INTO kvg_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Gê, zo mokho-te, ezoqa nøme, ekeza nakhasam lou-qa temboviam, ndego nandi mbó-etoām? ");
INSERT INTO kvg_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O gê, ndego wazeam mbó-etoām, zongøyam-qa temboviam? Āv taoká. ");
INSERT INTO kvg_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Zo manqa-zapazapa-us ambá qazøtegó. Geté zo zøkeza nakheis, gigiap eqeieqei etoam mø̀zøte-zøtéz. Yaq av tægoat ndægo, zoge Zøve, yan-te ngo꞉yage, gigiap eqeieqei nøme mba zømbó-etoám, gekha ezoqām ndigu, timbo-viømemat.” ");
INSERT INTO kvg_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Gekha matēv ndøgo, zo ndøzøpoev, ezoqa tizø-matønumat, zo matev āv tozozømbé-matønumát. Manqat ndøgo, Mozes neka Mbumbukiam-gi manqa vevezam ezoqam gipeaomem, taqa mokho nqánek.” ");
INSERT INTO kvg_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Mboqog khapelavøqasi-té qanø-óz. Zapa ndǿgo, mboqog kandambaqapi neka nakhoa vøndæv, soqaqape-té qanømá. Ta nakhoa vøndæv-te ndøgo, ezoqa kopoáv ndi-okho. ");
INSERT INTO kvg_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Geté mboqog ndigu, khandi-te ndimboqozoat, khapímbá, neka nakhoa ndøgo ndøløwe, føgákh. Neka ezoqa khapímbá, ta nakhoa ndøgo ndiqeivi.” ");
INSERT INTO kvg_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Khavozam ezoqam-te, ndigu ekeza kha Mbumbukiam-gi manqa vevezam ezoqam ndivewe, zo gò꞉feazoát. Ndigu andé sip nanak me nde-okhó, zo-te. Geté tiqa mokho-te ndøugu, ndigu andé gaqo khobokhobós. ");
INSERT INTO kvg_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Zo matev mba zozǿqeivát. Yaq søzøté-zøtezát, ndigu unimanqatin Mbumbukiam-gi manqa vevezam ezoqam tipøtigú-a. Gê, bøning fakiafakia-us-te, kopømbâ, nanga mbomømboma, kopømba ande av gleips ndi꞉gu, toqo-løvus? O kopømbâ, khouwe-khouwe-te ndøgo, fig nanga toqo-vingisam? Kopømba mbaín. ");
INSERT INTO kvg_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tae eqeieqei, nanga eqeieqei ndǿviám. Geté tae soqain, nanga soqøsoqa ndǿviám. ");
INSERT INTO kvg_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tae eqeieqei, kopømba mbaín, nanga soqøsoqa tøviam. Neka tae soqain, kopømba mbaín, nanga eqeieqei tøviam. ");
INSERT INTO kvg_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Gekha tāe ndøgo, nanga eqeieqei vi꞉pøteav ndøgo, gébouím. Yaq gøinam-té ginǿ-nqagimém. ");
INSERT INTO kvg_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yaq matev até kopó. Zo ndigu ezoqam-qa mokho tozo-qeivimat, yaq zo søzøté-zøtéz, ndigu unimanqatin Mbumbukiam-gī manqa vevezam ezoqām, ó, khavozam ezoqām.” ");
INSERT INTO kvg_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Zo ndømatàva᷄p, av nqægo, ezoqa ewaqape ndigu no Evezøza Evezøza-qa ndinø-akhayam, Mbumbukiam-qa Megeat Matev mokho-te sugumū-ōz. Āv taoká. Ti-mba ndígu timǿ-óz, ndigu noge Tat-qa poev ndimbopaev, ndego yan-te ngo꞉yage. ");
INSERT INTO kvg_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Manqa ovøyam khøuwa kandambaqape timø-khantaz, ezoqa kopoáv, āv ginømbé-manqatát nqǽgo, ‘Evézøza. Evézøza. Qoqa iz-te, ni Mbumbukiam-qá Manqat nivevezumám, neka nqova soqøsoqa vø̄i-ngeasumam, neka umingiap matev kopoáv qeimatønumam.’ ");
INSERT INTO kvg_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Geté yaq no ndigu āv qazømbé-qavøitát nqǽgo, ‘No zo nø̀tenøtenák. Mòzozáv, zo manqa-zapazapa-us ezoqam.’” ");
INSERT INTO kvg_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Gekha ezoqām ndego, noqa manqat te-ewag neka vømbópavāt, ndego matavap loloakh ezoqám. Ndego andé khoev manqei føgakh-té genøwév. ");
INSERT INTO kvg_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Yaq qæ neka khamøe-qape qandowav, neka vøndō-khouwa, sògoqatá. Geté ta khoev ndøgo nqoeveáv. Zapa ndǿgo, manqei føgakh-té qawevám. ");
INSERT INTO kvg_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Geté gekha ezoqām ndego, noqa manqat te-ewag, yaq paeveāv, ndego matavap loloakh mbaín. Ndego andé khoev ndivind-té genøwév. ");
INSERT INTO kvg_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Yaq qæ neka khamøe-qape qandowav, neka vøndō-khouwa, sògoqatá. Yaq ta khoev ndøgo gèkhawá, vø̄-evøvøem.” ");
INSERT INTO kvg_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu nqanek nømendim manqat ate ndægo qamømbøe-navøem, yaq ezoqa ewaqape nqova ndafe kandambá. Mbøni zølév. ");
INSERT INTO kvg_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Zapa ndǿgo, ndego Mbumbukiam-qá iz-té neka bazaføgakh-té gene-zømesimám. Ambá av nqǣgo, av tigi guguna manqat nømendim ezoqam gi꞉zømesimam. ");
INSERT INTO kvg_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu manqei pøyat-te gendovis, yaq ezoqa gèmbopavát. Ezoqa kandambá. ");
INSERT INTO kvg_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Yaq nqáe! Kha sisi-us ezoqam tendowáv ndǿgo, ekeza kha, Yesu-qa megemege-te, manqei vø̄elavao, sasa mbo-ein, “Evézøza. Ambá qokhakheinømbemín. Poev taqagoat, qo kopømbaqapé, toqo-khakheinømbem.” ");
INSERT INTO kvg_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yaq Yesu zenda mbøevé, vømbō-ein, “Nqanø̂poév. Qo vø̀-eqeieqei-éq.” Yaq nqova mbaín, ndego ezoqam, kha sisi sègembo-navøém. ");
INSERT INTO kvg_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yaq Yesu āv gembøe-eín nqǽgo, “Nqáe! Qotøndé-ewāg. Ezoqa nøme zø̀-ei᷄n, av matev qaqambe-fakhan. Geté Mbumbukiam-gé iziz ezoqam-té qonǿqáv, bemø̄qamekh, neka Mbumbukiam-te etoam matev vø̄go, av Mozes gezømbe-ein. Yaq ezoqa tìabiti-zøtéz, av nqægo, qo mòqo-eqeieqei-éq.” ");
INSERT INTO kvg_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu Kapenaum taon-te geme-on, yaq Lom nakhag kawa ezoqam ndowáv, vømbōviam, ");
INSERT INTO kvg_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Evézøza, noge sasae ezoqam enqoní. Khoev-té gegó. Sègebuvít. Ndego kha khokhokemáv, neka nqosøgeap khàpe mbøe-khouwév.” ");
INSERT INTO kvg_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yaq Yesu gembo-qavøiu, “Notøndónáv, ndego vǿe-khakhǣv.” ");
INSERT INTO kvg_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Geté ndego nakhag kawa ezoqam gendo-ein, “Evézøza. Āv taoká. No ezoqa eqeieqeí mbá, noqa khoev-te toqotøndo-oq. Geté manqat mba qó-eín, yaq noge sasae ezoqam segé-khakhǽv. ");
INSERT INTO kvg_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Até nó-a, no ezoqam-qá mokho-té qatu꞉gú. Neka no mokho-te, nakhag ezoqam mu꞉gú. Ndigu ezoqa kopo tæmbo-ein, ‘Vø̀qāv’, yaq ndego segéwáv. Neka ezoqa nøme tæmbo-ein, ‘Mòqotøndoqāv’, yaq ndego segendówáv. Neka noge sasae ezoqam tæmbo-ein, ‘Mòqo-matanām, nqanek’, yaq ndego segé-matanám.” ");
INSERT INTO kvg_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu nqanek manqat ge-ewag, ndego nqova ndafe kandambá, neka ezoqam ndigu gimbopavam, gezø-ein, “No unimanqatín nqazø-manqate. No nqanek Izlael bawan mokho-te, unimanqatin matev qeiviáv, av ngenek bawan vini-ak nge꞉-unimanqatinat. ");
INSERT INTO kvg_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","No nqazǿ-manqate: Vaev khøuwa-te, ezoqa khøuwa fakhanam neka khøuwa sininím gindúzáv. Ezoqa kopoáv. Ndigu Eibleem neka Aezek neka Zekop namba mé꞉qonáv, Mbumbukiam-qa Megeat Matev mokho-te, lou loge kandambaqape vǿgonēm. ");
INSERT INTO kvg_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Geté ndigu ezoqam, Mbumbukiam ibugukhokhof gevevesam, ambā teqa Megeat Matev mokho-te ti-ozɨn, ndigu bavokhó ginǿ-nqagevém. Bøivun-té. Yaq tí-eivumát ndǿgo, neka khaya vǿvivisumāt.” ");
INSERT INTO kvg_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yaq Yesu ndego nakhag kawa ezoqam gembo-ein, “Soqóqaváq. Matev āv tønéfakhán, av qo qoqote-unimanqatin.” Yaq até ta khøuwa iz-te ndøgo, tege sasae ezoqam enqoni tø̀mbøe-navøém. ");
INSERT INTO kvg_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu Pita-qá khoev-té genøwáv. Yaq ge-on, tu-omét ndǿgo, Pita-gu zimpuka, ngusu tatas enqoni mbovitát. Venanqei nonqo-té gubuvám. ");
INSERT INTO kvg_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yaq Yesu pingim mbogeá. Yaq enqoni sègembo-navøém. Yaq ndugu até gundigu, gè-itán, lou vømbōta. ");
INSERT INTO kvg_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Yaq qakhagus ndøgo, nqova soqøsoqa-us ezoqam kopoáv, Yesu-té gindu-upøgím. Yaq nqova soqøsoqa gèngeasám, ezoqam-qa mokho-te gu꞉goam. Manqat mba ndømanqatám, gengeasam. Neka ezoqa ate gi꞉goam, enqoni qazøgoam, vø̄khakheinøvem. ");
INSERT INTO kvg_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yesu av ge꞉matanam ndægo, yaq manqat ndøgo, Mbumbukiam-ge manqa vevezam ezoqam Aezaya ibugukhokhof ge-ein, mø̀ndø-unimanqatín. Āv gene-eín nqǽgo, “Ndego niqa nqosøgeap mø̀ndøndáp neka enqoni vønī-evøzam.” ");
INSERT INTO kvg_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Khøuwa nøme, Yesu ezoqa kopoav gezømet, gimbo-waniapam, ndego ekeza paev ezoqam āv gezømbe-eín nqǽgo, “Kewan yaq-keoqá qazinǿ-qantáv.” ");
INSERT INTO kvg_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Yaq Mozes-qá guguna manqat nømendim ezoqam ndowáv, vømbō-ein, “Nøméndim ezoqam. Qo ande āv khoqoté-okhoāt, no até nøtaqá-pavát.” ");
INSERT INTO kvg_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yaq Yesu gembo-qavøiu, “Qanimáv. Geté gèmbo-mataváp. Gaqo lozokhak, sømbiam nonqo, manqei nqa ndøzø̂gó neka pipisi viviap ndø̄zø̄gō. Geté Ezoqam-ge Yo khoev mbaín, te꞉sømbimat, pusa vǿe-tayāt.” ");
INSERT INTO kvg_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Neka ezoqa nøme, Yesu gimbopavam, gendo-ein, “Evézøza. Até vøkhæ-keogé. Tat bàtøkhæ-otáv.” ");
INSERT INTO kvg_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Geté yaq Yesu gembo-qavøiu, “Āv taoká. Ekeza pakhaezat-ak tiabe-osám ndigu, gipakhaez. Geté qo, no qonøndó-páev.” ");
INSERT INTO kvg_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu khagua-té genøketáo. Yaq tegi paev ezoqam gèmbo-paevém, vø̄guv, kewan yaq-keoqa sasa ndøqantav. ");
INSERT INTO kvg_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Giqantavat, anana-mba mø̀ndu꞉bǿen, mbe-qape tāndōfeā. Kandamba tantáv, khagua sasa ndøngetøyam, ambá vø̄-qambuanemɨn. Geté Yesu até gebuvám. ");
INSERT INTO kvg_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Yaq tegi paev ezoqam, gèti꞉nám, vø̄suzam. Yaq gimbo-einim, “Evézøza. Qonítøké. Ni avønín zígeón.” ");
INSERT INTO kvg_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Geté Yesu gezø-qavøiu, “Gekha zapâ, zo møe ndozogo? Zoqa unimanqatin Mbumbukiam-te khapémbá.” Yaq Yesu gè-itán. Yaq até gendego, khamøe ndøgo, vø̄fegimam-a, vø̄vumøyat, manqat sasanqa-us mbo-eín. Yaq ndøgo sègevøitáv. Manqeí sege꞉veát. ");
INSERT INTO kvg_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Yesu av ge꞉matanam ndægo, yaq tegi paev ezoqam nqova ndafe kandambá, neka ekeza mokho-mba gibond, “Ngenek gekha ezoqâm? É, até khamøe fegim neka khamøe vumøe, manqat o-mba mbøendapé.” ");
INSERT INTO kvg_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu paev ezoqam namba, kewan yaq-keoqa gimøqa, yaq Gadala manqei-te ndøgo, ezoqa nqova soqøsoqa-us ndozáv. Menás. Nandi nqa-té gindu-fakház. Ta nandi nqa-te ndøgo, løvøte ezoqam ndø-osupám. Nginik ezoqa menas, bazaføgakh kandambá neka møe-ús. Ezoqa nøme ta nakhoa-te ndøgo okhomáv. ");
INSERT INTO kvg_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yaq Yesu gi-ometam, āv gini-akhaemám nqǽgo, “Mbúmbukiam-ge Yo! Qo ni gekha gone-qa qonígu? Qo ndakin ni nqosøgeap etoam-qa qotøndóqav? Ta khøuwa ndøgo khantøzateáv. Zuá!” ");
INSERT INTO kvg_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ta manqei avønin-te ndøgo, bøsi nen mø̀ndø-vagimám. Kopoav-qapé. ");
INSERT INTO kvg_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Yaq nqova soqøsoqa, Yesu gimbo-viømem, “Ni ngeandam-qa toqogoat, yaq bøsik-qá mokho-té qanø-khofotán.” ");
INSERT INTO kvg_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu gezø-ein, “Mòzozáv.” Yaq nqova soqøsoqa, sègefakház, ezoqa menas-qa mokho-te gu꞉goam, bøsik-te vømø̄-oz. Yaq bøsik manqei khavoe-té ginøbøín, ibøkha-te vømø̄-geonim. ");
INSERT INTO kvg_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Yaq ezoqam ndigu, bøsik gizø-kewagam, møe ndøbøín. Vemiav-té ginøbøín. Yaq ezoqa emanqat zømbe-votót, matev ate ndægo, qafakhan. Até ndøgó-a, vøzømbē-votot, matev av ezoqa menas qazømbe-fakhan, ndigu nqova soqøsoqa gizømbu-goam. ");
INSERT INTO kvg_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yaq ezoqa ewaqape, vemiav-te gigoam, Yesu omete-qa ndøgoám, vøndōzav. Matev giqeivim, qafakhan, yaq āv gimbøe-viømém nqǽgo, “Niqa manqei ambá qo-ivavɨ́n.” ");
INSERT INTO kvg_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yaq Yesu khagua-té genøketáo, vø̄søkuzim, Gelili kewan yaq-keoqa sasa ndøqantav, ekeza vemiav-te vømø̄qa. ");
INSERT INTO kvg_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ezoqa Yesu gi-ometam, yaq kagi ezoqam ndondafém. Kumøkuma-té gindu-ndafém. Yesu tiqa unimanqatin geqeiv, yaq ngenek kagi ezoqam, āv gembøe-eín nqǽgo, “Áti. Ndøfofògea᷄p. Qoqa manqa-zapazapa mø̀ndøqa-navøém.” ");
INSERT INTO kvg_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yaq Mozes-qa guguna manqat nømendim ezoqam, teqa manqat giyogem, ekeza mokho-mba āv ginibondát nqǽgo, “Ngenek ezoqam, Mbumbukiam-qá iz ndøngi꞉tít. Ezoqam-qa manqa-zapazapa, Mbumbukiam yakhapús, ndezø-evøzam.” ");
INSERT INTO kvg_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Geté Yesu é-møndæ-otév, av ndigu gi꞉matavupat. Yaq gezø-ein, “Gekha zapâ, zoqa mbøni-te matavap soqøsoqa nandozombo-matavupit? ");
INSERT INTO kvg_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Gê, gekha manqât ndøgo, føgakh mbain? Ndǿgò, no ngenek ezoqam tæmbo-ein, ‘Qoqa manqa-zapazapa mø̀ndøqa-navøēm,’ o ndǿgò, tæmbo-ein, ‘Mòqo-itán, neka okho vø̄ngaz’? ");
INSERT INTO kvg_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Geté no ndakin nøtézømás, Ezoqam-ge Yo, bazaføgakh nqambôgó, ezoqam-qa manqa-zapazapa tezø-evøzam, nqanek manqei-qape-te.” Yaq Yesu até gendego, ngenek kagi ezoqam, āv gembøe-eín nqǽgo, “Mòqo-itán, neka kita vø̄khazo, khoev-te sasa ndøqav.” ");
INSERT INTO kvg_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Yaq ngenek ezoqam, gè-itán, kita vø̄khazo, khoev-te sasa ndøwav. ");
INSERT INTO kvg_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Yaq ezoqa nqanek matev giqeivim, ndigu møe ndøgoném neka Mbumbukiam-qa iz vø̄-eqanem. Ndigu mø̀ndø-matøvemém, ezoqa bazaføgakh Mbumbukiam zø-etoám, matev av nqægo timatønumat. ");
INSERT INTO kvg_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu ta manqei ndøgo ge-ivav, nakhoa gegeveat, teks moni upøgim ezoqam ndø-omét. Teqa iz Metiú. Teks upøgim khoev-qase mokho-té gunu꞉qotám. Yaq Yesu āv gembøe-eín nqǽgo, “No qonøndó-páev.” Yaq Metiu até gendego, gè-itán, neka vømbōpaev. ");
INSERT INTO kvg_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Taqa zita-te, Yesu Metiu-qa khoev-te, lou mølóg. Ta lou loge-te ndøgo, teks moni upøgim ezoqa nøme neka ezoqa nøme, ndigu manqa-zapazapa-us ndizæza, mø̀ndøgoám. Kopoáv. Yaq ndigu Yesu neka paev ezoqam, namba me꞉qonavát. ");
INSERT INTO kvg_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Felisi ezoqam nqanek matev giqeivim, yaq ndigu Yesu-gi paev ezoqam, āv gizømbe-beváp nqǽgo, “Gekha zapâ, zoge nømendim ezoqam, teks moni upøgim neka manqa-zapazapa-us ezoqam namba, lou ngiloget?” ");
INSERT INTO kvg_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yaq Yesu nqanek manqat ge-ewag, gezø-ein, “Ezoqam ndigu enqoni mbain ndigu, ndigu mulømula etoam ezoqam mbain tøgoat, kopømbá. Geté enqoni-us ezoqam bezøgó, mulømula etoam ezoqam. ");
INSERT INTO kvg_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Zo manqat nøme-qa mokho vø̀mezøtéz, Mbumbukiam-qa Manqat-te ndøpeawap. Manqat nqánek, ‘Mbumbukiam ge-ein: Noqa poev kandambaqape nqánek, tanakh matev. Ambá ndøgo, ezoqa søvakha gigiap tindu-løvusumat no-te.’” Yaq Yesu sasa zø-ein, “No ambá av nqǣgo, ezoqa eqeieqei akhayam-qa nøgeavūn. Geté no manqa-zapazapa-us ezoqam akhayam-qa nøgeavún.” ");
INSERT INTO kvg_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Khøuwa nøme, Zion, ndego ibøkha iz etoam ezoqam, tegi paev ezoqam, Yesu-té ginduzáv, vømbō-einim, “Gekha zapâ, ni neka Felisi ezoqam lou logemav matev qeigoatun, getē qogi paev ezoqam gonemāv?” ");
INSERT INTO kvg_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yaq Yesu yaya zø-etá, taqa yaq-te, gezø-ein, “Ge zô ndozo-matavap, ezoqa sæva te-okɨ, yaq zifuap lou loge-te tekhatob, ndigu zifuap kopømbâ, mutøkhop ndø̄wanim, ndego ti namba te꞉goat? Āv taoká. Kopømba mbaín. Ndigu khanakhanakh zǿ-asøtáv. Geté khøuwa ndø̀fakház. Yaq ndego ezoqam, sævam ge-okɨ, ndø̀ndafém, ti namba nde꞉go. Yaq tegi zifuap lou logemav matev, ndǿgo tinígoát. ");
INSERT INTO kvg_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ezoqa kopømba mbaín, ndabua mbewat ndakinak, awenege ndabua-te to꞉tøke. Matev av nqægo, mokho mbaín. Zapa ndǿgo, ndabua toqosunguz, yaq ndabua ndakinak segé-khapelavøqasé. Yaq ndabua keqæv sa tømǿ-khouwév. ");
INSERT INTO kvg_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Neka ezoqa kopømba mbaín, waen ndakinak, awenege søvakha ngusum-te te-ewa. Zapa ndǿgo, awenege søvakha ngusum-te toqo-ewa, yaq waen tøpopon, ndigu gékeqáz. Yaq waen vǿqouvøēm, neka søvakha ngusum vǿsoqoēz. Geté waen ndakinak ndøgo, søvakha ngusum ndakinak-té qotúqóuz. Yaq waen neká ngusum, qanimáv, segégoát.” ");
INSERT INTO kvg_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu Zion-gi paev ezoqam namba, ate av-té manqat gi꞉manqatam. Yaq Zu kawa ezoqam tendowáv ndǿgo, teqa megemege-te katuk vø̄møkui, gembo-ein, “Nogu yu ndakin ndønaním. Geté vø̀ndoqáv, zenda vømbø̄eve. Yaq kopømbá tukhandi꞉v.” ");
INSERT INTO kvg_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yaq Yesu gè-itán, ekeza paev ezoqam namba, vømbō-paevem. ");
INSERT INTO kvg_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Yaq ate av-té nakhoa gi꞉geveat, sævam tunduwáv ndǿgo. Ndugu kouk mbowavám. Nupøkhán mbá. Viav ate qægoam tuélv, kouk qambowavam. Yaq Yesu-qá zita-té gunduwáv, neka ndabua ov-qase vømbō-khanaz. ");
INSERT INTO kvg_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ndugu ekeza mokho-mba āv guni-matøvém nqǽgo, “No ngenek ndabua mba tæmbokhanaz, yaq no sǽ-eqeieqei-én.” ");
INSERT INTO kvg_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu gendoqambun, ndugu vø̄-omet, gumbo-ein, “Ngólam. Qo ndøfofògea᷄p. Qoqa unimanqatin nandav, tø̀khakheinøqavém.” Yaq ndaføyambá, ngunuk sævam, sège-eqeieqei-év. ");
INSERT INTO kvg_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yaq Yesu Zu kawa ezoqam-qa khoev-te gemøfakhan, vømø̄-on, pøinda khambøyam ezoqam ndøzømét. Neka ezoqa kandambá giwambupam. Tiqa manqa feazu gèzømbo-eqavát. ");
INSERT INTO kvg_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yaq Yesu gezø-ein, “Zo mòzofakház. Ngunuk mbasønakam nanimateáv. Gèbuvít.” Geté ndigu gèvøngi꞉nám. ");
INSERT INTO kvg_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Yaq ezoqa ate gi꞉goam gumu-nataz, Yesu tène-ón, ma mbasønakam gui-veam ndøgo, zenda vømbōgea. Yaq mbasønakam, sègendo-suzám, vø̄-itan. ");
INSERT INTO kvg_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Yaq manqat ndøgo, Yesu av matev ge꞉matanam ndægo, sège-panqavøemát, ta manqei-te ate qægoam. ");
INSERT INTO kvg_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu ta manqei nqanek ge-ivav, yaq nakhoa ge꞉geveat, bøi waev mbain ezoqa menas, sègembo-pavát, gimbo-akhaem, “Déivid-ge Zeo. Ni tanakh gìnigú.” ");
INSERT INTO kvg_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yaq Yesu khoev-te gemøfakhan, gemø-on, ndigu ezoqa menas até gembopavát. Yaq gezø-ein, “Zo mozó-unimanqatinim, av nqægo, no bazaføgakh nqanø̂gō, zoqa bøi tækhakheinam?” Yaq gindu-qavøinam, “Evézøza. Ni mø̀i-unimanqatiním.” ");
INSERT INTO kvg_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yaq Yesu até gendego, bøi vøzø̄-khanøzam, gezø-ein, “Matev sà bezøfakhán, av zo qazøte-unimanqatinim.” ");
INSERT INTO kvg_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yaq bøi sègezø-eqeieqei-ám. Geté Yesu ndigu gègugúb, gezø-ein, “Zo ezoqa nøme me꞉zø̀ma᷄s!” ");
INSERT INTO kvg_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Geté ndigu ezoqa menas Yesu gi-ivøvem, teqa emanqat sège-vøndazát, ta manqei-te ndøgo, ate qægoam. ");
INSERT INTO kvg_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ndigu ezoqa menas gi꞉qavaz, yaq ezoqa nøme, manqa-khou ezoqam ndondafém, Yesu-te. Ndego manqa-khou gegoam, zapa ndǿgo: Ndego nqova soqa mbøigoám. ");
INSERT INTO kvg_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Geté Yesu ndego nqova soqa é-vøngeatám-ae, ndego ezoqam, manqa manqate é-vø̄ngaz. Yaq ezoqa ewaqape, matev ndøgo giqeivim, ndigu nqova ndafe kandambá. Gi-einim, “Ni matev av nqægo ibugukhokhof qeiviáv, nqanek Izlael manqei-te.” ");
INSERT INTO kvg_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Geté Felisi ezoqam āv gini-einím nqǽgo, “Ngenek nqova soqøsoqa ngengeasam, nqova soqøsoqa-gé kawa-qá bazaføgákh gene-ngeasumatún.” ");
INSERT INTO kvg_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu taon neka vemiav ate ndægo sùgumu-vatát, tiqa guliguli khoev-te, Manqat Mbomambaqape vømē-zømesim. Mbumbukiam-qa Megeat Matev-qá yaq-té gene-zømesimát. Neka ezoqa ewaqape, gekha enqoni bugug vinivinimba qazøgoat, vø̄khakheinøvemat. ");
INSERT INTO kvg_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesu ndigu ezoqa kopoav gezømetat, yaq ndego tanakh zøgoát. Zapa ndǿgo, ndigu fofogeap-ús neka ezoqa tøke nonqo mbaín. Ndigu andé síp, keoge ezoqam mbain ndigu. ");
INSERT INTO kvg_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yaq Yesu ekeza paev ezoqam manqat nøme āv gezømbe-eín nqǽgo, “Khae-te avøe gigiap kandambá qakhatøkhatoam. Geté sasae ezoqam khapímbá, vøndé-peanēm. ");
INSERT INTO kvg_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yaq nakémbá. Khae eve, zombó-vi꞉mát, Mbumbukiam. Yaq sasae ezoqam tèabetønde-khofotáz, teqa avøe gigiap qakhatøkhatoam ndøgo, betøndō-peanem.” ");
INSERT INTO kvg_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu ekeza paev ezoqam tuelv gèmøváb, neka bazaføgakh vøzø̄-etoam. Bazaføgakh tezømbe-etoám ndǿgo, ezoqa nqova soqøsoqa zǿngeasumát, neka enqoni soqøsoqa-us vinivinimba vǿe-khakheinøvemāt. ");
INSERT INTO kvg_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nginik Yesu-gi u-anim tuelv, tiqa iziz nqánek: Bugukhokhof, Saemón. Iz nøme gimbo-akhaem, Pitá. Neka nøme Endlú. Pita neka Endlu, ndigu evenáp. Neka nøme Zéms, neka nøme Zión. Até ndigu ezoqa menás-a, evenáp. Zebedi-gí nakheís. ");
INSERT INTO kvg_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Nøme Filíp. Nøme Batolomeú. Nøme Tomás. Neka nøme Metiú. Metiu, ndego teks moni upøgim ezoqam ndøgoám. Neka nøme Zéms. Zems, ndego Alfius-gé yó. Neka nøme Tadiés. ");
INSERT INTO kvg_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Neka nøme Saemón nømé. Ngenek Saemon, Zelot ezoqam ndøgoám. Neka nøme Zudas Iskaliót, ndego vaev-te Yesu sa gemboqambun, tegi qaqa ezoqam-qa zenda-te geve. ");
INSERT INTO kvg_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yaq Yesu nginik ezoqa tuelv gèkhofosám. Manqa mø̀ndøzømbøkhæ-løvuá, gezø-ein, “Zo manqei vini ezoqam-te o Samalia bawan-ak-qa vemivemiav-te ndø̀za᷄v. ");
INSERT INTO kvg_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Geté Izlael manqei-ak-té qazonǿ-okhoát, ndigu kopømba ande av sip ndi꞉gu ndiyoniapet. ");
INSERT INTO kvg_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ti-te ndigu tozo-okhoat, manqat nqánek qazozǿ-manqatát, ‘Mbumbukiam-qa Megeat Matev avønín.’ ");
INSERT INTO kvg_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Zo enqoni-us ezoqam vø̀khakhætét, neka løvøte ezoqam vø̄khandi꞉tet. Kha sisi-us ezoqam gèkhakheinøvemét, neka nqova soqøsoqa-us ezoqam, nqova soqøsoqa vøzø̄-ngeasumit. No nqanek bazaføgakh yaq-mbá sæzø-etoám. Yaq até zó-a, zo ezoqa yaq-mbá sozozǿ-tøkeét. ");
INSERT INTO kvg_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Zo tozo-okhoat, moni ndø-upø̀gi᷄m. Gol moni mbaīn, neka silva moni mbaīn, neka kopa moni mbaīn. ");
INSERT INTO kvg_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Neka zo moqos namba me꞉-òkho᷄. Neka ndabua nøme o tamak nøme o tatuag ndø-upø̀gi᷄m. Zapa ndǿgo, gekha ezoqām ndego, ndesasaeat, ndego teqa yage nonqo gigiap, yà bembo-etoám. ");
INSERT INTO kvg_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Zo taon-te o vemiav-te tozomø-fakhazat, matev eqeieqei ezoqam-qa vø̀møkho-vawemát, ndego zo khoev tezø-einat. Yaq nambá tøzøté-sokhoát ndégo, atema ta manqei nqawa vozó-ivøvemāt. ");
INSERT INTO kvg_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Khoev-te tozomø-ozat, ezoqa manqat nqánek qazozǿ-einát, ‘Sambí, zo-te.’ ");
INSERT INTO kvg_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Yaq ndigu zo tikhatobat, zoqa sambi manqat até begó ti-te. Geté mbain tøgoat, zoqa sambi manqat nqawa zo-té qabenø-vesezát. ");
INSERT INTO kvg_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ezoqa zo khatobeav tøgoat neka zoqa manqat yogeav vǿgoāt, yaq ta khoev o vemiav ndøgo sège-ivøvemát. Yaq pakhakh ndøgo, zoqa zenda tokhotapak-te tøgoat, sozó-pomoememát. ");
INSERT INTO kvg_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","No unimanqatín nqazø-manqate. Manqa ovøyam khøuwa kandambaqape timø-khantaz, ndigu vemiav-ak-te unimé꞉-soqá. Yaq-fia nqosøgeap ndøgo, ndigu tindapem, ndø̀mø-løvuám, av Sodom neka Gomola taon-ak timindapem.” ");
INSERT INTO kvg_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Nqáe! Zo andé síp. Geté zo gaqo khobokhobos-té qatø-khofosumít. Yaq nakémbá. Zo andé waza me me꞉gó. Matavap loloakh-ús. Neka zo andé kuvøkuvu me me꞉gó. Manqa-zapazapa mbaín. ");
INSERT INTO kvg_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Geté gò꞉feazoát. Ezoqa zo manqa ovøyam-té ginǿ-abumát neka Zu ezoqam-qa guliguli khoev mokho-te vǿfebumāt. ");
INSERT INTO kvg_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Neka no zapaya, zo megetapak neka kawakawa-za-qá megemege-té ginǿ-abumát. Yaq zo kopømbaqapé, até ndigú-a neka bawan vini-ak, Manqat Mbomambaqape vøzøté-zømesimāt. ");
INSERT INTO kvg_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Zo manqa ovøyam-te ti-upøgimat, zo ndøfofògea᷄p, av nqægo, andē gekha manqat me zomǿ-einimāt, o ande āv khazøté-einimāt. Zapa ndǿgo, matev tøfakhanumat, yaq matavap Mbumbukiam zǿ-etoumát, zo andé gekha manqat me zøté-manqatāt. ");
INSERT INTO kvg_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Yaq manqat ndøgo, zo tozo-manqatat, ndøgo ambā zoqa manqat, geté zogé Zøve-gé Nqova Mbomambaqape ndǿmanqatát, zoqa mokho-te. ");
INSERT INTO kvg_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ezoqa nøme, ekeza namba-qaniap løvøte-té ginǿ-abumát neka evøndipakha nøme, ekeza nakheis løvøte-te vǿ-abumāt. Neka nakheis nøme, ekeza evøndipakha segezǿ-qambuzát, løvøte-te vǿ-abumāt. ");
INSERT INTO kvg_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ezoqa ewaqape zo gésanqabát neka qaqa vøzǿgoāt, no zapaya. Geté gekha ezoqām ndego, bazaføgakh-us teyat, atema vaev-te, ndego ndø̀mø-khandí꞉v. ");
INSERT INTO kvg_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Zo vemiav nøme-te tingiæzotat, yaq vemiāv nøme-té qazonǿ-khokhozát. No unimanqatín nqazø-manqate. Zo nqanek Izlael manqei-te, vemivemiav nqagot, sasae zókhouimák, atema Ezoqam-ge Yo vøndóqavān. ");
INSERT INTO kvg_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Paev ezoqam kopømba mbaín, tege nømendim ezoqam teløvuam, neka sasae ezoqam kopømba mbaín, tege megeat ezoqam teløvuam. ");
INSERT INTO kvg_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Paev ezoqam tege nømendim ezoqam namba ti꞉viit, ság. Neka sasae ezoqam tege megeat ezoqam namba ti꞉viit, ság. Ndigu no Saitan-qa iz Belzebul ginø-akhaemam, no ande khoev eve me nqate꞉go, yaq ndigu nogi ezoqam, iziz soqøsoqa nøme mba zømbó-akhayám.” ");
INSERT INTO kvg_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Zo ezoqam-qa møe ndø̀go᷄. Zapa ndǿgo, gekha matēv ndøgo, ndøgutøve, bavokhó qandó-fakhanám. Neka gekha manqāt ndøgo, ndøkhonøwe, ndø̀ndo-veveám. ");
INSERT INTO kvg_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Manqat ndøgo, no lova nqazø-manqate, paveat zómanqatát. Neka manqat ndøgo, no gea-te nqazø-manqate, zo khoev ová qazøtøndó-manqatát, ezoqa ewaqape betēyogem. ");
INSERT INTO kvg_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Zo ndigu møe zø̀go᷄, ndigu ezoqa pakhapakha sa ndikhanæ. Zapa ndǿgo, ndigu kha mba zǿngiú. Geté zoqa khandi kopømba mbaín, tizøngiu. Geté zo møe ndégo tozombó-goát, Mbumbukiam. Zapa ndǿgo, ndego kopømbaqapé, khā neka khandi, gøinam-te sugumú-ngiú. ");
INSERT INTO kvg_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Zo mø̀zøte-zøtéz. Pipisi nakheis-qa fia khapekhapémbá. Moni mokho kopo, menas soqotéwí. Pipisi, fia khasøkhasis ambá ginigú. Geté zoge Zøve ndezø-keôgé, ndigu. Pipisiam kopo, kopømba mbaín, manqei-te sa tubøiav, ndego poeveav tøgoat. ");
INSERT INTO kvg_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Geté gèmbo-mataváp. Zo-te até zogí izúm-a, zoqa kawa-te ate nandigu, Mbumbukiam mø̀ndø-gevebám. ");
INSERT INTO kvg_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yaq nakémbá. Zo møe ndø̀go᷄. Zo Mbumbukiam-qa bøi-te, pipisi kopoav-qape ùni zøte-løvubám.” ");
INSERT INTO kvg_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Gekha ezoqām ndego, ezoqam-qa bøi-te te-unimanqatintat, av nqægo, ‘No Yesu-gē ezoqām,’ teqa yaq-te, até nó-a, Tat-qa megemege-te, ndego yan-te ngo꞉yage, āv qaté-unimanqatín nqǽgo, ‘Ngenek nogē ezoqām.’ ");
INSERT INTO kvg_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Geté gekha ezoqām ndego, ezoqam-qa bøi-te noqa yaq-te to꞉nawam, teqa yaq-te, até nó-a, ndæ̀tonawám, Tat-qa bøi-te, ndego yan-te ngo꞉yage.” ");
INSERT INTO kvg_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Zo ndømatàva᷄p, av nqægo, no nqanek manqei-qape-te, ezoqa sambi etoam nonqo nøgeavūn. Āv taoká. No ambá av nqǣgo, sambi etoam-qa nøgeavūn. Geté no nakhag kaiya nøndøpavavún. ");
INSERT INTO kvg_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","No ezoqa qaqaza-qa nøgeavún. Yo eve namba segé-qatøném, neka yu evo namba vǿ-qatønēm, neka ziwap zakhapuka namba sasa ndǿqatønēm. ");
INSERT INTO kvg_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ezoqam-gi qaqa ezoqam ndígu timbógoát, te namba khoev kopo-te ndiyage. ");
INSERT INTO kvg_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Gekha ezoqām ndego, teqa kuku matev evøndipakha-te, kandambaqape ndømbogo, getē no-te andē khapēmbā, ndego kopømba mbaín, noge paev ezoqam tegoat. Neka gekha ezoqām ndego, teqa kuku matev nakhei angana-te o nakhei sakheis-te, kandambaqape ndømbogo, getē no-te andē khapēmbā, ndego kopømba mbaín, noge paev ezoqam tegoat. ");
INSERT INTO kvg_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Neka gekha ezoqām ndego, ekeza tae mutui eqawateav tegoat neka no paeveav vǿgoāt, ndego kopømba mbaín, noge paev ezoqam tegoat. ");
INSERT INTO kvg_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Gekha ezoqām ndego, yage ekeza mokho-mba tendapet, ndego ndæ̀khambuá. Geté gekha ezoqām ndego, ekeza yage te꞉khambua, no zapaya, ndego ndø̀møqeív.” ");
INSERT INTO kvg_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Gekha ezoqām ndego, zo tekhatob, ndego até nó-a, ndø̀khatómb. Neka gekha ezoqām ndego, no tekhatomb, ndego até Mbumbukiám-a, vǿkhatō, ndego no gendo-khofotan. ");
INSERT INTO kvg_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Gekha ezoqām ndego, Mbumbukiam-ge manqa vevezam ezoqam tekhato, zapa ndøgō, ndego Mbumbukiam-gē manqa vevezam ezoqām, ngenek ezoqam yaq-fia āv teméndáp, av ndego Mbumbukiam-ge manqa vevezam ezoqam ekezan temendap. Neka gekha ezoqām ndego, matev eqeieqei ezoqam tekhato, zapa ndøgō, ndego matev eqeieqei ezoqām, ngenek ezoqam yaq-fia āv teméndáp, av ndego matev eqeieqei ezoqam ekezan temendap. ");
INSERT INTO kvg_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","No unimanqatín nqazø-manqate: Gekha ezoqām ndego, noge paev ezoqa nøme tembotøke, oskiá ndøgo, ndego iz mbain ndego, neka gigiap-qase kopømba ande av ibøkha vatap ndægo tembo-etoam, ngenek ezoqam yaq-fia eqeieqei ndø̀møndáp.” ");
INSERT INTO kvg_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu tegi paev ezoqam tuelv manqa løvuat qamømbøe-navøem, yaq ta vemiav ndøgo gè-iváv. Yaq vemivemiav nøme-té genøwáv, Gelili manqei-te ndøgo, ezoqa vømē-zømesim. ");
INSERT INTO kvg_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ta khøuwa-te ndøgo, Zion, ndego ibøkha iz etoam ezoqam, ndimbula-té ge-utavám. Yaq manqat ge-ewag, av Keliso matev ge꞉matønumam, ndego ekeza paev ezoqa nøme ndokhofotáz, te-te. ");
INSERT INTO kvg_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Yaq Yesu āv gimbøe-bevøpém nqǽgo, “Qonimbí-eīn. Ezoqam qô, Mbumbukiam ge꞉manqatam, tendo-khofotav? Ó, ezoqa vini-qa nitó-kewagāt?” ");
INSERT INTO kvg_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yaq Yesu gezø-qavøiu, “Zion-te nqawa tozovesez, yaq āv qazømømbøé-einím, av zo manqat nqazøte-yoge neka matev nqazøte-qeivi. ");
INSERT INTO kvg_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ezoqam ndigu bøi waev mbain qagoam, ndakin gèkeogé. Neka ezoqam ndigu kagi gigoam, ndakin gè-okhó. Neka ezoqa ndigu kha sisi-us gigoam, kha sisi mø̀ndøzø-navøém. Neka ezoqa ndigu gea kandøgeap gigoam, ndakin gèyogé. Neka ezoqa ndigu gipakhaetat, nango mø̀ndø-khandí꞉z. Neka gigiap-av ezoqam, Mbumbukiam-qá Manqat Mbomambaqape ndøyogé. ");
INSERT INTO kvg_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Neka gekha ezoqām ndigu, no-te nakeapav ndigu, ndigu khanakhanakh mbá giabitigú.” ");
INSERT INTO kvg_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Zion-gi paev ezoqam gi꞉qavaz, yaq Yesu Zion-qa yaq-te manqa manqate ndøngáz, ezoqa ewaqape-te, gezø-ein, “Gê, zo Zion-te qazo-apat, leg-av manqei-te ndøgo, zo gekha qeivi-qa zó-apat? Gê, zo ezoqa omete-qa zó-apat, ndego kopømba ande av gagayag ndægo, sa tøpovøemet, yaq vǿepovēt, yaq vǿepovēt, khamøe sa tøqambuvøemet? ");
INSERT INTO kvg_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","O gê, qazo-apat, zo ezoqa ndabua eqeieqei uzap omete-qa zó-apat? Nqáe! Ezoqa ndabua eqeieqei ndi-uzap, ndigu kawa ezoqam-qá khoev-té giyageáp. ");
INSERT INTO kvg_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Geté zonømbé-einīm. Zo gekha qeivi-qa zó-apat? Mbumbukiam-gê manqa vevezam ezoqam omete-qa zó-apat? Unimanqatín. Ndego Mbumbukiam-gé manqa vevezam ezoqám. Geté no nqazǿ-manqate. Ndego Mbumbukiam-gi manqa vevezam ezoqam ate ndi꞉gu, mø̀ndø-løvubám. ");
INSERT INTO kvg_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Zapa ndǿgo, ezoqam ngének, teqa yaq-te Mbumbukiam-qa Manqat av nqæpeawap nqægo, ‘Nqáe! Noge u-anem notó-khofotáv, qoqa megemege-te. Ndego nakhoa møqá-khakheinám.’ ");
INSERT INTO kvg_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","No unimanqatín nqazø-manqate. Zion, ndego ibøkha iz etoam ezoqam, ndego kandambaqapé. Ndego ezoqa ewaqape, nqanek manqei-qape-te gifakhatat, mø̀ndø-løvubám. Geté até ezoqa khasøkhasís-a, Mbumbukiam-qa Megeat Matev mokho-te, ndigu Zion mø̀ndø-løvu꞉mém. ");
INSERT INTO kvg_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ta khøuwa-te ndøgo, Zion manqa manqate ge꞉ngaz, atema ndakin, Mbumbukiam-qa Megeat Matev, bazaføgakh-us ndøkhouwevtét. Geté ezoqa keføkefak ngi꞉wat-qa mbógo. ");
INSERT INTO kvg_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Qageavun, atema꞉ Zion vø̄fakhan, Mbumbukiam-gi manqa vevezam ezoqam ate gi꞉goam neka Mozes-qa guguna manqat, ndǿgo tini-manqatám, matev zo ndakin nqazo-qeivi. ");
INSERT INTO kvg_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Oskiá ndøgo, zo tozo-unimanqatinim o unimanqatinteav tøgoat: Ndigu manqat gi-einim, av nqægo, Mbumbukiam Ilaiza ndōkhofotāv, ndigu Zion me꞉manqatám. ");
INSERT INTO kvg_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Gekha ezoqām ndego, gea tømbogoat, yà beyogé. ");
INSERT INTO kvg_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Nginik ezoqam, ndakin ngiyage, andé gekha me nøtékhamās? No nakheis nøtékhamás, maket manqei-te ndi-otam. Ndigu yaqyaq-a, āv gini-akhayám nqǽgo, ");
INSERT INTO kvg_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ni zo pøinda nizø-khambøemám. Khanakhanakh-ús. Geté zo ogipøteáv. Neka ni osombo ouv nizø-qaqaemám. Geté zo eivøpøteáv.’ ");
INSERT INTO kvg_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Zó-a, até kopó. Gekha matēv ndøgo, zo ndozoqeivi, zo khanakhanakh mbaín. Zion gefakhan, lou logemav matev gegoam, neka waen izumav vø̄goam, yaq ezoqa ewaqape āv gimbøe-manqatám nqǽgo, ‘Ngenek nqova soqa mbøigú!’ ");
INSERT INTO kvg_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Geté ndakin Ezoqam-ge Yo gefakhan, ngenek lou mø̀ndø-logatún, neka waen vø̄-izumatun. Yaq ezoqam āv gimbøe-manqaté nqǽgo, ‘Ngenek ezoqam zøté-ometām. Lou loge møqǽ, neka waen izam møqǽ. Neka ngenek teks moni upøgim ezoqam neka manqa-zapazapa-us ezoqam-gí zifú.’ Ezoqa av nqægo ambá gini-manqaté. Geté Mbumbukiam-qa matev, ni āv qaninømánd nqǽgo, teqa matavap loloakh, unimanqatín.” ");
INSERT INTO kvg_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Vemivemiav nøme-te, Yesu umingiap matev kopoáv gematønumam. Geté ndigu vemiav-ak, Mbumbukiam-te qambuzaneáv. Yaq Yesu gèzøponqóm, vøzø̄-ein, ");
INSERT INTO kvg_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Zo Kolazin-ak neka Betsaida-yak, zo mòzo-soqoéz. Zapa ndǿgo, no umingiap matev, zo mokho-te qæmatønumam, ambā Taya neka Saedon taon mokho-te tæmatanamɨn, ndigu ambá nupøkhán mbá, Mbumbukiam-te é-ndo꞉qambuzɨ́n, neka tiqa manqa-zapazapa zapaya, ndabua soqøsoqa vø̄-uzamɨn neka pakhakh vø̄geɨn. ");
INSERT INTO kvg_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","No nqazǿ-manqate: Manqa ovøyam khøuwa kandambaqape timø-khantaz, zo-te unimé꞉-soqá. Yaq-fia nqosøgeap ndøgo, zo tozomø-ndapem, ndø̀mø-løvuám, av Taya neka Saedon taon-ak timindapem. ");
INSERT INTO kvg_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Neka ge zô, Kapenaum taon-ak? Zo, yan-té ginǿ-eqazō, av zo ndøzøte-matavap? Āv taoká. Zo gøinam-té ginǿ-nqagevém. No umingiap matev, zo mokho-te qæmatønumam, ambā Sodom taon-te tæmatanamɨn, yaq ndigu ambá Mbumbukiam-té ginø-qambuzín. Yaq ta taon ndøgo, gøinam-te ambá gélonqotamák. Geté ambá oskia ndøgonɨ́n. ");
INSERT INTO kvg_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","No nqazǿ-manqate: Manqa ovøyam khøuwa kandambaqape-te, yaq-fia ndøgo, zo tozomø-ndapem, ndø̀mø-løvuám, yaq-fia, av Sodom taon-ak timindapem.” ");
INSERT INTO kvg_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ta khøuwa-te ndøgo, Yesu āv gene-guligulím nqǽgo, “Tat, qo yan neka manqei-qape-ge Evezøza ndoqogo. No ike kandambá qo-te. Zapa ndǿgo, qoqa matavap qòkhonáo, ti-te ndigu, ekeza kha zøtezat neka matavap loloakh-us ezoqam ndizæza. Geté qo ti-te ndígu toqonø-vevezám, ezoqam ndigu ande av nakhei nqonqon ndi꞉gu. ");
INSERT INTO kvg_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Unimanqatín. Tat. Qoqā poev, āv tønegoám.” ");
INSERT INTO kvg_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yaq Yesu manqat nøme ge-ein, “Gigiap neka matev ate ndægo, Tat noqá zenda-té genøvé. Ndego yakhapús, Yo ge꞉-otev. Ezoqa nøme, ndigu Yo mè꞉zøtezák. Neka ezoqa Eve mè꞉zøtezák. Yo mba me꞉-otév, neka ndigu vǿezøtēz, Yo Eve-qa yaq-te vevezam-qa ndezøgo.” ");
INSERT INTO kvg_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“No-té qandozáv, zo ezoqa ewaqape, qazø-ewez neka viniv-qape ndozo-eqatet. No pusup nøzǿ-etoám. ");
INSERT INTO kvg_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kopømba ande av kao nduigu, tae monqo-te toqombøe-ve, yaq gigiap gēlīv, zo noqá viniv zóndapém, neka zøtezat vozóndapēm, no-te. Yaq zoqa yage-te, zo pusa zótá. Zapa ndǿgo, no matev aiyav-té qatø-matanám. Neka no nøkeza iz eqawatáv. ");
INSERT INTO kvg_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Viniv ndøgo, no ezoqam-te totove, tákh. Taqa viniv khapémbá.” ");
INSERT INTO kvg_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Khøuwa nøme, Sabat khøuwá, Yesu ekeza paev ezoqam namba, wit khae livin-mbá gunu꞉-apát. Yaq tegi paev ezoqam, ifi zøvín. Yaq wit nanga ndøvingisømém, sasa ndølouz. ");
INSERT INTO kvg_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Yaq Felisi ezoqam tiqa matev giqeivim, Yesu āv gimbøe-einím nqǽgo, “Nqáe! Khafeáp nandav, qogi paev ezoqam Sabat khøuwa-te wit nanga nandi-vingisumit. Kopømba mbaín, Sabat khøuwa-te, sasae toqogo.” ");
INSERT INTO kvg_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yaq Yesu gezø-qavøiu, “Ge zô, emanqat mozó-geveømem, av Deivid ge꞉matanam, tegi ezoqam namba ifi qazøvin? ");
INSERT INTO kvg_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Mbumbukiam-qá khoev-té genø-ón, flawa vømøndō-upøzo, ndigu lou-qase-te go꞉-abam, Mbumbukiam-gi, yaq tegi ezoqam namba sasa ndølouz. Matev av nqægo khafeáp ti-te. Mbumbukiam-gí iziz ezoqam mba zø-mboqoatám, nginik flawa tilouzat. ");
INSERT INTO kvg_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Neka ge zô, Mozes-qa guguna manqat mozó-geveømem? Mbumbukiam-gi iziz ezoqam, Sabat khøuwa-te, sasae ndøgoatún, Mbumbukiam-qa khoev-te. Yaq av nqægo ndigu khafeap ndømøkuimatún. Geté ndigu manqa-zapazapa gonemáv. ");
INSERT INTO kvg_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","No nqazǿ-manqate: Ezoqa ngêgó nqanek. Ngenek Mbumbukiam-qa khoev ùnime꞉-løvuám. ");
INSERT INTO kvg_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mbumbukiam-qa Manqat āv qane-eín nqǽgo, ‘Noqa poev kandambaqape nqánek: Zo tanakh matev zǿgoát, ezoqa nøme-te. Ambá ndǿgo, zo søvakha gigiap tozotøndo-løvusumat no-te.’ Zo nqanek manqat ambā mokho tozombo-ndapemɨn, yaq zo nginik manqa-zapazapa-yav ezoqam, soqøsoqa ambá zøtézæbák. ");
INSERT INTO kvg_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ezoqam-ge Yo, ndego kawá. Sabat khøuwa, ndégo teno-kawaevát.” ");
INSERT INTO kvg_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu ta manqei ndøgo ge-ivav, yaq Zu ezoqam-qá guliguli khoev-té genøwáv. ");
INSERT INTO kvg_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ta guliguli khoev-te ndøgo, ezoqam mø̀ndøgoám. Ndego pingim gèmbowaú. Yaq ezoqa Yesu gimbo-bevøpem, “Gê, ezoqa kopømbâ, Sabat khøuwa-te, ezoqa nøme tekhakheinøvem, ó, khafeâp?” Av gimbøe-bevøpem nqægo, zapa ndǿgo: Ndigu Yesu manqa ovøyam-te vee-qa mbogoám. ");
INSERT INTO kvg_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yaq Yesu gezø-qavøiu, “Zonømbé-einīm. Ezoqa sip timbowanat, yaq Sabat khøuwa-te, kopo ndugu manqei ozu-tē gunūbøiāv, yaq ndego ngunuk sip segé-ivāv? Āv taoká. Ndø̀liváv. ");
INSERT INTO kvg_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Geté ezoqam sip ùnime꞉-løvuám. Yaq nakémbá, khafeap mbaín, ezoqam toqombo-tøke, Sabat khøuwa-te.” ");
INSERT INTO kvg_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yaq até gendego, ndego ezoqam āv gembøe-eín nqǽgo, “Pingim qoté-ovøyām.” Yaq ndego ezoqam, pingim sège-ovøyám, vømbō-eqeieqei, kopømba ande av pingim nøme qambøegoam. ");
INSERT INTO kvg_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Yaq Felisi ezoqam Yesu-qa matev giqeivim, ndigu sège-ivøvém. Yaq āv gini-pøoném nqǽgo: Pakhapakha zimbó-khanøém. ");
INSERT INTO kvg_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yaq Yesu ge꞉-otev, av nqægo, Felisi ezoqam gèmbo-voqoēm, yaq ndego manqei nøme-té genøwáv. Ezoqa kopoáv gimbopavat, yaq ndego enqoni-us ezoqam ate gi꞉goam, vø̄khakheinøvemat. ");
INSERT INTO kvg_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Geté Yesu āv gene-gugubát nqǽgo: Ndigu teqa yaq-te, ezoqa nøme bete-zømèsi᷄m. ");
INSERT INTO kvg_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yesu av ge꞉matanam nqægo, yaq manqat ndøgo, Mbumbukiam tege manqa vevezam ezoqam Aezaya mokho-te ge-ein, gè-unimanqatín. Manqat nqánek, ");
INSERT INTO kvg_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nqáe! Ngenek nogé sasae ezoqám. Nō nøveatáv. No poev kandambá te-te, neka no nø̀mbøe-khafuát. Nøkeza Nqova nombó-etoám. Ndego manqei-manqei ate ndægo, ezoqa matev eqeieqei-qá yaq-té mé꞉zømesimát. ");
INSERT INTO kvg_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ndego qaqa manqat gémanqateák. Neka ndego manqa sas gémanqateák. Ezoqa teqa manqat gé-ewagák, nakhoa-te. ");
INSERT INTO kvg_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Pefa køfi꞉v, ndego ma génqawayák. Neka lampa ndøgo, tøkhouvøemat, ma gékhoutavák. Ndego sasae gé-ivavák. Sasae até gégót, atema matev soqøsoqa ate ndægo vumú-nqagīm, yaq matev eqeieqei vøndó-oē. ");
INSERT INTO kvg_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Manqei-qape ate nqægo, ezoqa te-te ndégo tinǿtabát.” ");
INSERT INTO kvg_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Khøuwa nøme, manqa-khou neka bøi waev mbain ezoqam ndondafém, Yesu-te. Ndego manqa-khou neka bøi waev mbain gegoam, zapa ndǿgo: Ndego nqova soqa mbøigoám. Yaq Yesu gèkhakheinøvém. Yaq ndego ezoqam kopømbá, manqat vø̄-ein-a, bøi vømbō-eqeieqei. ");
INSERT INTO kvg_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yesu nqanek matev gematanam, yaq ezoqa ewaqape nqova ndafe kandambá. Yaq ekeza mokho-mba gibond, “Gê, ngenek Deivid-gê Zeò penømakhaya, Mbumbukiam ge꞉manqatam, tendo-khofotav?” ");
INSERT INTO kvg_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Geté Felisi ezoqam nqanek manqat giyogem, ndigu āv gini-einím nqǽgo, “Āv taoká. Ngenek nqova soqøsoqa, Belzebul-qá bazaføgákh gene-ngeasám, ndego nqova soqøsoqa-ge kawa.” ");
INSERT INTO kvg_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu tiqa matavap é-møndæ-otév, yaq gezø-ein, “Zoqa manqat mokho mbaín. Zapa ndǿgo, gekha bawān ndigu, giqatønem, yaq ndigu izuizu ndǿnøfeapāt, nginik gékhoumbám, até vømú-nasinīm. Neka vemiav o evenap tiqatønem, yaq ndigu izuizu ndǿnøfeapāt, ta vemiav ndøgo o ndigu evenap, kopømba mbaín, oskia tiyagat. ");
INSERT INTO kvg_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Saitan-qa bawan-qa yaq-te, matev até kopó. Ndego amba ekeza ezoqa tengeasamɨn, yaq teqa bawan géqatá. Yaq segé-navøém. ");
INSERT INTO kvg_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","No nqova soqøsoqa amba Belzebul-qa bazaføgakh-te tøte-ngeasamɨn, av zo ndøzøte-manqate, yaq gê, zogī ezoqam, nqova soqøsoqa gekha ezoqam-qâ bazaføgakh-tē ginǿ-ngeasumatun? Gê, Saitan-qâ bazaføgakh-tē ginǿ-ngeasumatun? Āv taoká. Yaq nakémbá. Tiqa matev mø̀ndø-unimanqatín, av nqægo, zoqa manqat mokho mbaín. ");
INSERT INTO kvg_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","No nqova soqøsoqa, Mbumbukiam-gé Nqová qate-ngeasumatún. Ndøgo zo āv qanezømás nqǽgo: Mbumbukiam-qa Megeat Matev, mø̀ndø-fakhán zo-te. ");
INSERT INTO kvg_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Neka nøme nqánek: Gê, ezoqa bazaføgakh-qape, kopømba ande av Saitan nde꞉go, teqa gigiap aqonam-qa toqogoat, yaq qo khoev-tē soqombó-ōq, gigiap voqombó-aqonām? Āv taoká. Geté vø̀kho-løvønøvém. Váev, gigiap toqombo-aqonam, teqa khoev-te. ");
INSERT INTO kvg_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Gekha ezoqām ndigu, no-te nøzøzaneav ndigu, ndigu nogí qaqa ezoqám. Neka gekha ezoqām ndigu, no ezoqa møvøbam-qa yaq-te tøkemav ndigu, ndigu ezoqa gèpanqasumít. ");
INSERT INTO kvg_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yaq nakémbá, no nqazǿ-manqate: Gekha manqa-zapazapā ndøgo, ezoqa ndimatanam, até ndøgó-a, Mbumbukiam-qa iz ndingi꞉wat, ta manqa-zapazapa ndøgo, Mbumbukiam kopømbá, segembøé-navøém. Geté ezoqa Nqova Mbomambaqape-qa iz tengiu, Mbumbukiam ta manqa-zapa ndøgo gembøé-navøemák. ");
INSERT INTO kvg_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ezoqam ndego, Ezoqam-ge Yo-qa yaq-te, manqa soqøsoqa ndemanqate, Mbumbukiam teqa manqa-zapa ndø̀mbøe-navøém. Geté ezoqa Nqova Mbomambaqape-qa yaq-te, manqa soqa te-ein, Mbumbukiam teqa manqa-zapa gembøé-navøemák, ndaki yage-te neka yage nøme, megemege-te ndo꞉go.” ");
INSERT INTO kvg_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Tae eqeieqei tøgoat, yaq até nangá-ya, eqeieqeí. Geté tae soqain tøgoat, yaq até nangá-ya, soqaín. Tae nanga eqeieqei o soqain toqoqeivat, yaq soqoté-qateqát, av nqægo, tae ndøgo eqeieqeī o soqaīn. ");
INSERT INTO kvg_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Zo waza soqøsoqa. Gê, manqat eqeieqei áv khazøté-manqatāt, zo manqa-zapazapa-us ndozogo? Nakhoa mbaín. Ezoqa ndǿgo témanqatát, gekha matavāp ndøgo, teqa mokho-te qamømbo-tøva. ");
INSERT INTO kvg_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ezoqa eqeieqei, matev eqeieqei ndøgoatún. Zapa ndǿgo, teqa mokho-te, matavap eqeieqei mbøigú. Geté ezoqa soqaqape, matev soqøsoqa ndøgoatún. Zapa ndǿgo, teqa mokho-te, matavap soqøsoqa mbøigú. ");
INSERT INTO kvg_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","No nqazǿ-manqate: Gekha manqāt ndøgo, ezoqa khokho sa ndimanqate, Manqa ovøyam khøuwa kandambaqape-te, Mbumbukiam-te manqa ndø̀-ovøemém. ");
INSERT INTO kvg_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Gekha manqāt ndøgo, qo ndoqo-manqate, Mbumbukiam qo eqeieqei o soqain ndǿgo tenéqǽq.” ");
INSERT INTO kvg_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yaq Mozes-qa guguna manqat nømendim ezoqam neka Felisi ezoqa nøme, Yesu gimbo-einim, “Nøméndim ezoqam. Umingiap matev qómatanám. Yaq ni tàbati-nøtén, qo Mbumbukiam ndokhofotāq.” ");
INSERT INTO kvg_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Geté Yesu gezø-qavøiu, “Zo ezoqa ndakin nqazoyage, zo ezoqa soqøsoqá neka zo Mbumbukiam-te tøkebeáv. Yaq ndakin, zo umingiap matev qeivi-qa mba zøgó. Geté zo matev nøme zóqeivimák. Sa ndǿgo tozóqeivím, av Ziona qambøe-fakhan, ndego Mbumbukiam-ge manqa vevezam ezoqam. ");
INSERT INTO kvg_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kopømba ande av Ziona khøuwa misika neka lova misika zongøyam-qa mokho-te gu꞉goam, yaq até Ezoqam-gé Yó-a, manqei mokho-te āv tenégoát, khøuwa misikā neka lova misika. ");
INSERT INTO kvg_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mbumbukiam-qa Manqa Ovøyam Khøuwa Kandambaqape-te, ndigu Niniva vemiav-ak, segéwán. Yaq ndigu zo ezoqa soqøsoqa mé꞉zǽb, zo ndakin nqazoyage. Zapa ndǿgo, ndigu manqa-zapazapa-te gigoam, màndo-qambúz, Ziona-qa manqat gi꞉yogem. Geté, nqáe! Ngenek ezoqam zo namba nge꞉go, ngenek Ziona ùnime꞉-løvuám. Geté zo qambuzaneáv, teqa manqat qazoyogem. ");
INSERT INTO kvg_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Neka Mbumbukiam-qa Manqa Ovøyam Khøuwa Kandambaqape-te, até ndugú-a, Siba manqei kawa sævam kandambaqapu, segé-itán. Yaq ndugu zo ezoqa soqøsoqa mé꞉zǽb, zo ndakin nqazoyage. Zapa ndǿgo, ndugu qámbá gunduwav, Solomon-qa matavap loloakh manqat vømømbō-ewag, ndego kawa ezoqam kandambaqape. Geté, nqáe! Ngenek ezoqam zo namba nge꞉go, ngenek Solomon ùnime꞉-løvuám. Geté zo teqa nømendim manqat ndapeáv.” ");
INSERT INTO kvg_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Nqova soqa ezoqam-te tefakhan, yaq ndego mbenga qaqaniap manqei-té gé-okhoát. Manqei eqeieqei-qa ndǿvawét, te꞉yagat. Geté qeiviav tøgoat, ");
INSERT INTO kvg_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ekeza manqat āv gené-eín nqǽgo, ‘Ság. Nøkeza khoev-té qatǿveséz, ma qatønde-fakhan ndøgo.’ Yaq ndego nango tevesez, ta khoev-te ndøgo, ezoqam mbaín, tembøe-khaz, viayáp neka gapuk mbaín. ");
INSERT INTO kvg_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Yaq nangó genǿwáv, nqova soqøsoqa seven nøme vømøndó-khatōb, ndigu uni gi꞉soqøsoqoezam. Āv teoká, av ndego ekezan nde꞉go. Yaq ndigu tindúzáv ndǿgo, namba vøméqōm. Yaq vaev-te ndøgo, ndego ezoqam, teqa yage unimé꞉-soqá. Āv taoká, av bugukhokhof ge꞉yagam. Matev āv tøzømbé-fakhán, nginik manqa-zapazapa-us ezoqam, ndakin khøuwa-te ngiyage.” ");
INSERT INTO kvg_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu ezoqa ewaqape namba, manqa mo꞉manqatám, yaq nqáe! Evo neka tegi emekheis tīnø̄fākhāz. Bavokhó sogowán. Te namba manqa manqate-qa ndøgoám. ");
INSERT INTO kvg_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yaq ezoqa nøme āv gimbøe-einím nqǽgo, “Nqáe! Qavo neka qamekheis, ngówani, bavokho. Ndigu manqa manqate-qa ndøgó, qo namba.” ");
INSERT INTO kvg_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Geté yaq Yesu āv gende-qavøiú nqǽgo, “Nogu evo neka nogi nqamekheis kinǿgoam?” ");
INSERT INTO kvg_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yaq Yesu zenda ekeza paev ezoqam-té genøqantáv, ge-ein, “Nqáe! Nogu evo neka nogi nqamekheis, ngínik, ngiwaniap. ");
INSERT INTO kvg_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Zapa ndǿgo, gekha ezoqām ndigu, noge Tat-qa poev ndimbopaev, ndego yan-te ngo꞉yage, nogu evo neka nogi nqamekheis ndígu.” ");
INSERT INTO kvg_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ta khøuwa kopo-te ndøgo, Yesu khoev gè-iváv. Yaq ndøgeg-té genø-ová, vømø̄qom. ");
INSERT INTO kvg_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Geté ezoqa khàpumu-khouwéz, gindupindam te-te. Yaq Yesu khagua-té genøketáo, vø̄uqom. Ezoqa ndøgeg-té giwaniapám. ");
INSERT INTO kvg_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yaq ndego yaya etæ manqat me꞉zømás. Kopoáv. Āv genengáz nqǽgo, “Nqáe! Ezoqam mø̀ndøgoám. Khae-té genøwáv, wit nanga vømø̄-zøgeakh. ");
INSERT INTO kvg_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Yaq wit nanga ge꞉panqabumat, nøme nakhoa-té ginø-o꞉atát. Yaq pipisi tindu-løvuvám ndǿgo, vø̄louz. ");
INSERT INTO kvg_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Geté nøme ndigu, nandi-té ginø-o꞉atát. Nandi-te ndøgo, manqei khapekhapémbá qatøke꞉pat. Yaq mbusa nakhamas-té ginø-fakhanøvém. Zapa ndǿgo, manqei andé mbaín. ");
INSERT INTO kvg_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Geté yaq, khøuwa gendosasev, mbusa ndigu gifakhatat, khøuwa tatas ndølouwáz. Yaq gèkusíz. Zapa ndǿgo, ndigu ngum uni mbunipøteáv. ");
INSERT INTO kvg_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Wit nanga nøme, gapuk-té ginø-o꞉atát. Yaq gapuk ndøgo qa-eqa, ndigu gèvøtøgeám. ");
INSERT INTO kvg_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Geté wit nanga nøme, manqei eqeieqei-té ginø-o꞉atát. Yaq kopømbá gi-eqanat, nanga vø̄qataz. Wit nanga nøme ndigu, 100́, louzi nonqo gitøkebupat. Nøme ndigu 60́, neka nøme ndigu 30́.” ");
INSERT INTO kvg_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yaq Yesu gezø-ein, “Gekha ezoqām ndego, gea tømbogoat, yà beyogé.” ");
INSERT INTO kvg_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yaq Yesu-gi paev ezoqam tinduzáv ndǿgo, vømbō-bevøpem, “Qo gekha zapâ, yaya mba ndoqo-etæ, ezoqa ndoqote-zømesim?” ");
INSERT INTO kvg_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yaq Yesu gezø-qavøiu, “Mbumbukiam zo mba zøtáke, zo nogi paev ezoqam, mokho manqat tøzøte-zøtez, teqa Megeat Matev-qa yaq-te. Geté ezoqa nøme-te, ndego takeáv. ");
INSERT INTO kvg_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Gekha ezoqām ndego, mokho gendap, Mbumbukiam otevat nøme mba mbøé-etoám. Yaq ndego otevat kandambá tømbogoat. Geté gekha ezoqām ndego, mokho ndapeav ndøgo, yaq Mbumbukiam até otevat-qasé-a, ndømbogo, segéviwám. ");
INSERT INTO kvg_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","No ndigu yaya mba tæzømbe-etǽ ndǿgo: Ndigu ndikeôgé. Geté géqeivimák. Neka ndigu ndiyôgé. Geté mokho géndapemák. ");
INSERT INTO kvg_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Yaq av nqægo, manqat ndøgo, Mbumbukiam-ge manqa vevezam ezoqam Aezaya gepeawam, gè-unimanqatín, ndøgo qa-ein, ‘Zo ndòzo-ewagát. Geté manqa mokho zombó-ndapemák. Zo ndòzo-kewagát. Geté zóqeivimák. ");
INSERT INTO kvg_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nginik ezoqam, mbøni gèzø-føgøføgakhám. Neka gea gèzø-tokeáp, neka bǿi ndīkōpø̄ītāp. Zapa ndǿgo, ndigu poeveáv, bøi ti꞉qeivat neka gea ti꞉-ewagat, neka mokho tindapem, yaq no-te vøndé-qambūz, no vøté-khakheinøvēm.’ ");
INSERT INTO kvg_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Geté zo khanakhanakh mbá qanegó. Zapa ndǿgo, zo bøi ndøzøte-qêiví neka gea ndø̄zø̄tē-yōgē. ");
INSERT INTO kvg_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","No unimanqatín nqazø-manqate. Mbumbukiam-gi manqa vevezam ezoqam neka matev eqeieqei ezoqa kopoáv, matev qeivi-qa ndøgoám, zo ndakin nqazo-qeivi. Geté ndigu qeiviáv. Neka ndigu manqat yoge-qa vø̄goam, zo ndakin nqazoyoge. Geté ndigu yogeáv.” ");
INSERT INTO kvg_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yaq Yesu tegi paev ezoqam gezø-ein, “Gèndoyogé, yaya manqat ndøgo, wit nanga zøgekhæm-qa yaq-te qazø-eta, taqa manqa mokho. ");
INSERT INTO kvg_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wit nanga ndigu, nakhoa-te gi-o꞉atat, taqa manqa mokho nqánek: Ezoqa nøme, ndigu Mbumbukiam-qa Megeat Matev-qa yaq-te, manqat giyogemɨn, mokho upøgimáv. Yaq nqova soqaqape, até gendewavɨn, manqat vø̄e-vibamɨn, tiqa mbøni mokho-te tøu-ogeakhat. ");
INSERT INTO kvg_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Neka wit nanga ndigu, nandi-te gi-o꞉atat, taqa manqa mokho nqánek: Ezoqa nøme, Mbumbukiam-qa Manqat nakhamas-té ginø-ndapemɨ́n. Khanakhanakh-ús. ");
INSERT INTO kvg_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Geté ta manqat ndøgo, uni mbuvøemáv, tiqa mokho-te. Yaq ndigu føgøføgakh wanimáv. Mbumbukiam-qa Manqat zapaya, yage føgakh-qape o ngenøgim matev qazø-fakhanɨn, ndigu nakhamas-té ginø-o꞉azɨ́n. ");
INSERT INTO kvg_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Neka wit nanga nøme ndigu, gapuk-te gi-o꞉atat, taqa manqa mokho nqánek: Ezoqa nøme, Mbumbukiam-qa Manqat ambá giniyogé. Geté ndigu fofogeap khàpe zømbe-khouwevɨ́n, tiqa yage zapaya, neka tiqa poev matev, gigiap kopoav-qa yaq-te, vø̄tubamɨn. Yaq Mbumbukiam-qa Manqat, tiqa mokho-te ndøugu, gèvøtagɨ́n. Yaq kopømba mbaín, mokho tømbo-fakhan. ");
INSERT INTO kvg_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Neka wit nanga ndigu, manqei eqeieqei-te gi-o꞉atat, taqa manqa mokho nqánek: Ezoqa nøme, Mbumbukiam-qa Manqat gèyogemɨ́n neka mokho vømbō-ndapemɨn. Yaq Mbumbukiam-qa Manqat, mokho mbófakhán. Kandambá. Ezoqa nøme-te 100́, neka ezoqa nøme-te 60́, neka ezoqa nøme-te 30́.” ");
INSERT INTO kvg_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yaya etæ manqat nøme, Yesu ge꞉zømas, nqánek. Gezø-ein, “Mbumbukiam-qa Megeat Matev, kopømba ande av nqǽgo: Ezoqa mø̀ndøgoám. Khae-té genøwáv, wit nanga mbomømboma vømø̄-zøgeakh. ");
INSERT INTO kvg_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Geté ezoqa ewaqape ate av-té gi꞉sømbiapat, tege qaqa ezoqam tendowáv ndǿgo, avøeavøe nanga vø̄pomogim, ndøgo wit ma gi꞉zøgeakham, sasa ndøwav. ");
INSERT INTO kvg_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Yaq wit nanga mbusa gifakhaz, gi-umianat, mokho vø̄tøkebam, yaq até avøeavøé-a, namba me꞉-umiavát. ");
INSERT INTO kvg_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Yaq khae eve-gi sasae ezoqam, nqanek matev giqeivim, tinøzáv ndǿgo, vømømbō-einim, ‘Khanánqa. Qo wit nanga eqeieqeí aboqo-zøgeákh. Geté ndakin avøeavøe áv khané-fakhanam?’ ");
INSERT INTO kvg_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yaq gendo-ein, ‘Qaqa ezoqám abe-matanám.’ Yaq sasae ezoqam gimbo-einim, ‘Gê, batíniav? Avøeavøe ambá nimø-khofoemɨ́n.’ ");
INSERT INTO kvg_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Geté ndego āv gezømbe-qavøiú nqǽgo, ‘Mbaín. Avøeavøe naqanøkā ndøkhofòe᷄m. Soqaín ndøgo, wit namba tøzøte-khofobem. ");
INSERT INTO kvg_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Wit avøeavøé namba sa bete-umianét, atema vingisam khøuwa vizimǿ-khantøzēm. Yaq no sasae ezoqam āv qazømbé-eín nqǽgo, “Avøeavøe vø̀khæ-khofoém, vø̄-møvøemem, yaq sasa zósønqotøvēm. Yaq wit zóvingisumém, noqa lou møvøyam khoev-te vozó-nqeitøzēm.” ’” ");
INSERT INTO kvg_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yaya etæ manqat nøme, Yesu ge꞉zømas, nqánek. Gezø-ein, “Mbumbukiam-qa Megeat Matev, ndøgo andé masted tae nangá, ezoqa khae-te gezøgeakhɨn. ");
INSERT INTO kvg_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nginik tae nanga khapímbá. Geté mbusa qafakhanɨn, qakhouwevɨn, tae kandambá. Avøe gigiap nøme mø̀ndø-løvuamɨ́n. Yaq tae ndøgo tøyat, pipisi até gindi-løvuvamɨn, taqa tang-te vō꞉viviamɨn.” ");
INSERT INTO kvg_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu yaya nøme gezø-eta, nqánek, “Mbumbukiam-qa Megeat Matev, andé flawa poponøvem nonqó. Sakheis khasøkhasis ndø-upøgimatún, khapémbá, flawa-te vø̄u-pomogimimin. Flawa poponøvem nonqo, khapelavøqase ambá qanegó, neka flawa kandambā. Geté flawa ate ndi꞉gu, sègemø-popoezɨ́n.” ");
INSERT INTO kvg_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu nqanek manqat ate ndægo, ezoqa ewaqape gezø-manqatam, ndego yaya mba zø-etæám. Ndego manqat bavokho manqatemáv. Geté yaya mba zø-etæám. ");
INSERT INTO kvg_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yesu av ge꞉matønumam ndægo, yaq manqat ndøgo, Mbumbukiam-ge manqa vevezam ezoqam ge꞉-ein, gè-unimanqatín. Ta manqat nqánek, “No ezoqa manqat tæzø-manqatat, yaya mba nøzǿ-etæát. Manqat ndøgo, no ezoqa tøte-zømesimat, khonoam-té qagoám. Nupøkhán mbá, Mbumbukiam manqei-qape gekhakheinam, atema ndakin.” ");
INSERT INTO kvg_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu ezoqa ewaqape gezivaz, khoev mokho-te vømø̄-on, yaq tegi paev ezoqam tinduzáv ndǿgo, vømbō-einim, “Yaya etæ ndøgo, ezoqa avøeavøe nanga khae-te gepomogim, taqa manqa mokho gekhâm? Kopømbâ toqoti-nømand?” ");
INSERT INTO kvg_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yaq Yesu gezø-qavøiu, “Ezoqam ndego wit nanga eqeieqei gezøgeakh, khae-te, ndego Ezoqam-gé Yó. ");
INSERT INTO kvg_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Khae ndøgo, manqei-qapé, neka wit eqeieqei ndigu, Mbumbukiam-gí ezoqám, teqa Megeat Matev-te ndu꞉gu. Geté avøeavøe ndøgo, ndigu nqova soqaqape-gí ezoqám. ");
INSERT INTO kvg_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Qaqa ezoqam, ndego avøeavøe nanga soqøsoqa gepomogim, ndego nqova soqaqapé. Neka wit vingisam khøuwa ndøgo, manqei-qape-qá vaév. Neka sasae ezoqam ndigu, enzol ezoqám. ");
INSERT INTO kvg_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kopømba ande av ezoqam avøeavøe gikhofoem neka vø̄sonqotøvem, yaq manqei-qape-qa vaev-te, matev āv tønéfakhán. ");
INSERT INTO kvg_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ezoqam-ge Yo, ekeza enzol ezoqam ndókhofotáz, yaq gekha ezoqām ndigu, teqa Megeat Matev mokho-te, manqa-zapazapa ndigu neka ezoqa nøme manqa-zapa-te ndi-ituza, vǿmøvāb. ");
INSERT INTO kvg_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Yaq ndigu gøinam wageap-té ginǿ-nqagivém. Yaq tí-eivumát ndǿgo, neka khaya vǿvivisumāt. ");
INSERT INTO kvg_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Geté ezoqa eqeieqei ndigu, andé khøuwa me mé꞉sanqatavát, Tat-qa Megeat Matev-te. Gekha ezoqām ndego, gea tømbogoat, yà beyogé.” ");
INSERT INTO kvg_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yaq Yesu yaya nøme zø-etá, gezø-ein, “Mbumbukiam-qa Megeat Matev, kopømba ande av nqǽgo: Ezoqa khae nøme-te, yakhaseke ndøqeív. Moni-ús. Manqei mokho-té qakhonawám. Ta yakhaseke mokho-te ndøugu, moni kandambá gu꞉nqeitavam. Yaq ndego ezoqam, nqanek yakhaseke nqawá genø-khonáo, sasa ndøqavan. Khanakhanakh khàpe mbøe-khouwév. Yaq até gendego, ekeza gigiap ate qambøegoam, gèwí. Yaq moni geqas ndigu, khae ndǿgo tewí, ma moni yakhaseke-us ge꞉qeiv.” ");
INSERT INTO kvg_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesu yaya etæ manqat nøme ge꞉zømas, nqánek. Gezø-ein, “Neka Mbumbukiam-qa Megeat Matev, kopømba ande av nqǽgo: Stoa eve mø̀ndøgoám. Ndego agiwa-qasis qaniqanimav-qa ndøvawám. ");
INSERT INTO kvg_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Yaq khøuwa nøme, agiwa qanimav-qapi ndøzømét. Tiqa fia kandambá. Yaq ndego até gendego, gigiap ate qambøegoam, gèwí. Yaq moni geqas ndigu, agiwa-qasi me꞉wí.” ");
INSERT INTO kvg_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesu yaya etæ manqat nøme ge꞉zømas, nqánek. Gezø-ein, “Neka Mbumbukiam-qa Megeat Matev, kopømba ande av nqǽgo: Ezoqa voe gi-ogimin, zonga bugug vinivinimbá gindapɨn. ");
INSERT INTO kvg_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Zonga voe gumu-khazemɨn, yaq ndøgeg-té ginø-itimín, vø̄qonavɨn, zonga sasa ndøgevezonamɨn. Zonga eqeieqei ndigu, lagu-té ginø-qonøzemɨ́n. Geté zonga soqøsoqa, gènqagevemɨ́n. ");
INSERT INTO kvg_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Manqei-qape-qa vaev-te, matev kopo āv tønéfakhán. Enzol ezoqam tindúzáv ndǿgo, ezoqa vǿ-qatøzō, eqeieqei vini neka manqa-zapazapa-us vini. ");
INSERT INTO kvg_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Yaq manqa-zapazapa-us ezoqam, gøinam wageap-té ginǿ-nqagivém. Yaq tí-eivumát ndǿgo, neka khaya vǿvivisumāt.” ");
INSERT INTO kvg_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yaq Yesu ekeza paev ezoqam gezøbevap, “Ge zô, nqanek manqat ate nqægo, taqa manqa mokho mozóndapem?” Yaq gimbo-qavøinam, “Ni mø̀indapém.” ");
INSERT INTO kvg_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yaq Yesu gezø-ein, “Gekha ezoqām ndego, Mozes-qa guguna manqat ge꞉-otev, yaq ndego Mbumbukiam-qa Megeat Matev mokho-te, ge-noge-paev-ezoqam-ev, ndego andé khoev evé. Ndego teqa khoev kouwat mokho-te, gigiap ndemøvøyam, gigiap qaniqanim vinivinimbá ndømbogo, nøme ndakinák neka nøme awenegé, yaq ta gigiap ndøgo, nøme vøndō-ovøe.” ");
INSERT INTO kvg_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu nqanek yaya etæ manqat zømesim qamømbøe-navøem, yaq ta manqei ndøgo ge-ivav, ");
INSERT INTO kvg_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ekeza vemiav-té genøwáv, Nazalet, neka Zu ezoqam-qa guliguli khoev-te, ezoqa vøme-zø̄mesim. Yaq ndigu manqat gimboyogem, nqova ndafe kandambá neka ekeza mokho-mba gibond, “Ngenek ezoqam, matavap loloakh neka bazaføgakh, umingiap matev gone nonqo, gekham-tê gendap? ");
INSERT INTO kvg_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Gê, ngenek khoev puanam ezoqam-gê yò? Neka tegu evo, Melî? Neka tegi emekheis Zêms, neka Zosêf, neka Saemôn, neka Zudâs? ");
INSERT INTO kvg_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Neka até tegi sænakheis ate ndi꞉gú-a, ni namba zí꞉yage? Gê, ngenek ezoqam, teqa matev ate ndægo gekham-tê gendap?” ");
INSERT INTO kvg_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yaq ndigu vemiav-ak, Yesu gèsanqawém. Geté yaq Yesu gezø-ein, “Manqei nøme-te, Mbumbukiam-ge manqa vevezam ezoqam, gèmbovizáp. Geté ekeza manqei-te neka ekeza khoev-te, ezoqa vizupáv.” ");
INSERT INTO kvg_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ta vemiav-te ndøgo, Yesu umingiap matev, agé matanapøteáv. Zapa ndǿgo, ndigu unimanqatinteáv. ");
INSERT INTO kvg_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ta khøuwa-te ndøgo, Elod ndego, Gelili plovins-ge kawa ezoqam gegoam, Yesu-qa yaq-te, manqat ndø-ewág. ");
INSERT INTO kvg_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Yaq ekeza sasae ezoqam gezø-ein, “Ngenek Zión ategó, ndego ezoqa ibøkha iz gezø-etoumam. Løvøte-te nangó abetøndo-khandí꞉v. Yaq nakémbá, bazaføgakh teqa mokho-te ndøu-sasaeat, umingiap matev ndematanam.” ");
INSERT INTO kvg_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Elod nqanek manqat ge-ein, zapa ndǿgo. Ibugukhokhof Elod Zion gèmøvøiú, ndimbula-te vø̄-utav. Elodias zapayá gene-matanám. Ndugu Elodias, ibugukhokhof tege namba qawan Filip-gú zas ndøgoám. Geté Elod sègeviwám. ");
INSERT INTO kvg_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yaq Zion Elod āv gembøe-manqatám nqǽgo, “Khafeáp nandav, namba qawan-gu sævam qoqo-okɨ.” ");
INSERT INTO kvg_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Yaq Elod Zion ambá gelavawɨ́n, ta zapaya. Geté ndego ezoqam-qá møe ndøgoám. Zapa ndǿgo, ndigu Zion Mbumbukiam-gé manqa vevezam ezoqam me꞉vewám. ");
INSERT INTO kvg_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Yaq Elod ge꞉qan, ta khøuwa iz gemø-khantaz, zifuap namba lou gilog, Elodias-gu yu tiqa megemege-te, gè-ogiám. Yaq Elod poev kandambá qambowav, tuqa ogiam-te. ");
INSERT INTO kvg_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Yaq Elod até gendego, vømbō-ein, “No unimanqatín nqataqa-manqate. Nøtaqambé-khavozák. Gekha gigiāp ndøgo, qo poev taqagoat, soqonǿ-eín, yaq søtaqá-etoám.” ");
INSERT INTO kvg_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Yaq ndugu evo mbobeváp, taqa yaq-te. Yaq ndugu Elod manqat āv tumbøe-qavøiú, av evo-qa poev qægoam, gumbo-ein, “Noqa poev nqánek. Zion, ndego ibøkha iz etoam ezoqam, teqa kawa melek-té qazøtøndó-qonøvém, no-te sasa zotøndó-ndapēm.” ");
INSERT INTO kvg_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Yaq Elod nqanek manqat ge-ewag, ndego khanakhanakh mbaín. Mbøni mbová. Geté ndego nakhag ezoqam āv tezømbe-eín, av tuqa poev qægoam. Zapa ndǿgo, ndego manqat ezoqa ewaqape-qá bøi-té genø-eín. ");
INSERT INTO kvg_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yaq ndigu até gindigonem, ndimbula khoev-té ginøzáv, Zion monqo vømømbō-kepøzem. ");
INSERT INTO kvg_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Yaq Zion-qa kawa, melek-té ginø-qonøvém, mbasønakam vømømbó-etøomem. Yaq ndugu evo-té gunøndáp, vømømbó-etoam. ");
INSERT INTO kvg_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yaq Zion-gi paev ezoqam manqat giyogem, tinduzáv ndǿgo, Zion-qa kha vø̄ndapem, sasa mø-ozem. Yaq Yesu-té ginøzáv, vømømbō-einim. ");
INSERT INTO kvg_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu Zion-qa yaq-te manqat ge-ewag, gilaem, ndego khagua-té genøketáo, yaq-keoqa sasa ndøqantav. Ndego ambá ezoqam-av manqei-té genøtinín, neka vømē-yakhapusivin. Geté ezoqam giyogem, av nqægo, mø̀ndø-qantāv, ndigu tiqa vemivemiav sège-yovitát, Yesu gimbopavat. Zapá ginøzáv. ");
INSERT INTO kvg_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu gemø-asa, ezoqa bawan-qape mba mo꞉qeív. Yaq ndego tanakh zøgó, neka enqoni-us ezoqam vø̄khakheinøvem. ");
INSERT INTO kvg_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Yaq qakhagus ndøgo, ekeza paev ezoqam tinduzáv ndǿgo, vømbō-einim, “Gèkhagustét, neka vemiav mbaín, nqanek. Ezoqa bawan-qape é-moqo-khofosám. Yaq vemivemiav-té giabenøzáv, ekeza lou bemø̄wi.” ");
INSERT INTO kvg_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Geté Yesu gezø-ein, “Mbaín. Ndigu qavønipøteav tøgoat, kopømbá. Lou zo zozǿ-etoám, tilog.” ");
INSERT INTO kvg_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Yaq gimbo-einim, “Gê, áv khatígonēm? Ni flawa faev neka zonga menas mba nigú.” ");
INSERT INTO kvg_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yaq Yesu gezø-qavøiu, “Zøtøndé-upøzonām.” ");
INSERT INTO kvg_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yaq ndego ezoqa bawan-qape, gagayag-te qonam manqat zø-eín. Yaq até gendego, nginik flawa faev neka zonga menas, gè-upøzó, yan-te sasa ndøqan, Mbumbukiam ike manqat vømbō-ein. Yaq flawa gèmbegím, ekeza paev ezoqam vøzø̄-etoam, yaq ndigu ezoqa ewaqape sasa zø-etoam. ");
INSERT INTO kvg_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Yaq ezoqa ewaqape lou tilóg ndǿgo, até vøzø̄-ewez. Yaq lou mbegeap ndøgo, ezoqa gi-ivøvem, gèpizumém. Yakhav tuélv ginqeitømem, qamøvea. ");
INSERT INTO kvg_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ezoqa kopoav-qapé, nqanek lou gilog. Angana ate gi꞉goam, ande āv faev taosén ndi꞉gú. Geté sakheis neka nakheis, lou gilog, ndigu gevebøpøteáv. ");
INSERT INTO kvg_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesu nginik ezoqa kopoav-qape, lou guzumbu-etoam, yaq até gendego, tegi paev ezoqam vøzø̄-ein, “Zo khagua-té qanøketáb, yaq-keoqa vō꞉qantav. No nginik ezoqa ndø̀tokho-khofosám.” Yaq ndigu vø̄søkuzim, sasa ndøtinim. ");
INSERT INTO kvg_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yesu ezoqa gumu-khofosam, yaq manqei poyat-té genøqavíg, yakhapus-mba vømø̄-guligulim. Yaq qapøistat, yakhapus mbá segegoát. ");
INSERT INTO kvg_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ndakin tegi paev ezoqam-qa khagua, anana-mbá qanuteitát. Qámbá. Khamøe sògo-qaqavøemám neka vø̄sintavam. ");
INSERT INTO kvg_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Yaq lova ande av 3 o 4 oklok ndægo, Yesu ekeza paev ezoqam-té genøwáv. Ibøkha mumát gono꞉mát. ");
INSERT INTO kvg_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Geté ibøkha mumat go꞉geavun, gi-ometam, ndigu møe kandambá gigonem. Até vøe-einim, ndego gevøgév. Yaq gèzøgeá. ");
INSERT INTO kvg_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Geté Yesu até gendego, gèzøndo-akhá, “Zo møe ndøgòne᷄m. Nó!” ");
INSERT INTO kvg_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Yaq Pita gembo-ein, “Evézøza. Unimanqatin qo toqogoat, qonǿ-eín. Yaq ibøkha mumát qatøndónáv qo-te.” ");
INSERT INTO kvg_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yaq gembo-qavøiu, “Qanimáv. Mòqotøndoqáv.” Yaq Pita até gendego, khagua gè-iváv, ibøkha-te vø̄vuao, Yesu-te sasa ndøwav, ibøkha mumat. ");
INSERT INTO kvg_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Geté khamøe-qape geqeiv, ndego møe ndøgó. Yaq gègeonát. Gendo-akha, “Evézøza. Gènøtøké.” ");
INSERT INTO kvg_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yaq Yesu nakhamas-té genøvisí, vømbōgea. Gembo-ein, “Qoqa unimanqatin khapémbá, Mbumbukiam-te. Gekha zapâ ndoqoto-nake?” ");
INSERT INTO kvg_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yaq ndigu ezoqa menas khagua-te gi꞉ketab, khamøe-qape sègevøitáv. ");
INSERT INTO kvg_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Yaq ezoqam ndigu, khagua-te gu꞉guvam, Yesu gèmbo-vizumém. Gimbo-einim, “Unimanqatín. Qo uni Mbumbukiam-gé-Yo-ín.” ");
INSERT INTO kvg_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yesu tegi paev ezoqam namba giqantavat, yaq Genesalet manqei-té gimøqá. ");
INSERT INTO kvg_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ta manqei-te ndøgo, ezoqa Yesu gimatøvemem, yaq vemivemiav ndøgo, avøavun qagoat, manqa ndøkhofotømém, yaq ndigu enqoni-us ezoqa ate gi꞉goam, te-te sasa ndo-upøgim. ");
INSERT INTO kvg_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yaq ezoqa āv gimbøe-viømém nqǽgo, “Kopømbâ, nginik enqoni-us ezoqam, ndabua ov-qase mba tiqa-khanøzumat. Yaq enqoni segezǿ-navøemát.” Yaq gekha ezoqām ndigu, teqa ndabua gimbo-khanazumat, enqoni sègezø-navøemtát. ");
INSERT INTO kvg_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Khøuwa nøme, Felisi ezoqam neka Mozes-qa guguna manqat nømendim ezoqam ndozáv, Yesu-te. Zelusalem taon-té ginduzáv. Gimbo-einim, ");
INSERT INTO kvg_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Gekha zapâ, qogi paev ezoqam, nigi atanakha-zapazapa-za-qa nømendim matev ndimøkuiam? Ndigu bugukhokhof zenda uni sunguzumáv, lou gilogɨn.” ");
INSERT INTO kvg_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yaq Yesu gezø-qavøiu, “Geté ge zô, gekha zapâ, zøkeza nømendim matev zapaya, Mbumbukiam-qa guguna manqat ndozo-møkuiam? ");
INSERT INTO kvg_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mbumbukiam āv gene-eín nqǽgo, ‘Qave neká qavo, gèzøvizáp. Gekha ezoqām ndego, eve o evo soqa manqat tembo-ein, ndego ezoqa yà belaém.’ ");
INSERT INTO kvg_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Geté zo ndozo-manqate, ezoqa kopømbaqapé, eve o evo sa tembo-ein, av nqægo, gekha gigiāp ndøgo, no amba qo tøtaqa-etoamɨn, ndøgo Mbumbukiam-qā. ");
INSERT INTO kvg_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Geté gekha ezoqām ndego, manqat av nqægo nde꞉manqate, ndego vizap mbaín, eve-te neka evo-te. Yaq av nqægo, zo zøkeza nømendim matev mokho-te, Mbumbukiam-qá Manqat zomøkuiám. ");
INSERT INTO kvg_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Zo khavozam ezoqám. Mbumbukiam-ge manqa vevezam ezoqam Aezaya, zo me꞉-eín, av ge꞉-ein nqægo, ");
INSERT INTO kvg_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Nginik no tou mbá ginømbe-vizáp. Geté tiqa mbøni qámbá no-te. ");
INSERT INTO kvg_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ndigu noqa iz, khokhó sege-eqawát. Zapa ndǿgo, ndigu ezoqam-qá nømendim matev mba me꞉zømesimít. Ambá ndøgo, noqā nømendim matev.’” ");
INSERT INTO kvg_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yaq Yesu ezoqa ewaqape ndømøváb, gezø-ein, “Ùnime꞉-yogé, neka mokho vømbō-ndapem! ");
INSERT INTO kvg_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ezoqam ambá ndø̄go, tenē-manqa-zapa-us-ēv, Mbumbukiam-qa bøi-te, lou ndøgo, teqa manqa-nqa-te ndø-oev. Geté tene-manqa-zapa-us-evɨ́n ndǿgo, manqat ndøgo, teqa manqa-nqa-te ndøndo-fakhate.” ");
INSERT INTO kvg_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yesu nqanek manqat ge-ein, yaq taqa zita-te, tegi paev ezoqam tinduzáv ndǿgo, gimbo-einim, “Ge qô, moqoté-qateq? Felisi ezoqam mbøni nqosøgeap mboyogém, qo nqanek manqat qoqo-ein.” ");
INSERT INTO kvg_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yaq Yesu gezø-qavøiu, “Gekha gigiāp ndøgo, noge Tat, ndego yan-te ngo꞉yage, ogekhæav ndøgo, ndø̀khofoé. ");
INSERT INTO kvg_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ság! Sègezø-iváv. Ndigu bøi waev mbain ezoqam ituza-qa ndøgó. Geté até ndigú-a, bøi waev mbaín. Bøi waev mbain ezoqam, bøi waev mbain ezoqa nøme te-itu, yaq ndigu ezoqa menas, manqei ozu-te, até sugumú-o꞉áz.” ");
INSERT INTO kvg_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Yaq Pita gendo-ein, “Kopømbâ, yaya ndøgo, ezoqa qoqozø-eta, mokho toqoti-nømand?” ");
INSERT INTO kvg_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yaq Yesu gezø-qavøiu, “Gê, até zó-a, manqa mokho upøgimâv? ");
INSERT INTO kvg_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ge zô, møzøté-zøtez? Gekha lōu ndøgo, manqa-nqa-te ndø-oev, gus-té qanø-okhó. Yaq vaev-te nqawa mø̀ndø-fakhanɨ́n. ");
INSERT INTO kvg_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Geté manqat soqøsoqa ndøgo, manqa-nqa-te ndøndo-fakhate, ndøgo mbøni-té qando-fakhanɨ́n. Matev nqánek, ezoqam Mbumbukiam-qa bøi-te ge꞉-manqa-zapa-us-evɨn. ");
INSERT INTO kvg_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Zapa ndǿgo, matavap soqøsoqa, kopømba ande av ezoqam pakhapakha khaneam matev neka nøkenøkem ngi꞉wat matev neka mambe matev neka aqonam matev neka meakha manqat manqate matev neka manqat ponqom matev, ndøgo mbøni-té qando-fakhaté. ");
INSERT INTO kvg_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ezoqam nqánek gene-manqa-zapa-us-ev-ɨ́n, Mbumbukiam-qa bøi-te. Geté ezoqam bugukhokhof zenda uni sunguziav tegoat, lou telog, ndøgo gé꞉-manqa-zapa-us-ev-ák.” ");
INSERT INTO kvg_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu nqanek manqei ge-ivav, yaq Taya neka Saedon taon avønin-té genøwáv. ");
INSERT INTO kvg_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Yaq nqáe! Keinan bawan sævam ndøwáv, ta manqei-te ndøgo guyagam, gundu-akha, “Evézøza. Deivid-ge Zeo. No tanakh gènøgó. Nogu yu, nqova soqa mbøigú. Gèngiitét.” ");
INSERT INTO kvg_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Geté Yesu yaq manqat-qase qavøiwateáv, tu-te. Yaq tegi paev ezoqam tinduzáv ndǿgo, vømbō-einim, “Vø̀khofotáv, ngunuk, niqa zita-te ngundu-akhayam.” ");
INSERT INTO kvg_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yaq Yesu gendo-ein, “No Mbumbukiam Izlael ezoqam-te mbá gendo-khofotán, ndigu kopømba ande av sip ndi꞉gu, gi-ewaz.” ");
INSERT INTO kvg_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Geté ndugu tunduwáv ndǿgo, katuk vø̄møkui, gundu-ein, “Evézøza. Vø̀nøtøké.” ");
INSERT INTO kvg_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yaq Yesu gumbo-qavøiu, “Matev eqeieqeí mbá, nakheis-qa lou toqondap, yaq gaqo sasa qozǿnqagīm.” ");
INSERT INTO kvg_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yaq ndugu gundu-qavøiu, “Evézøza. Nandav unimanqatín. Geté gaqo, lou khakhayakh ndølogatún, ndøgo eve-qa lou-qase-te qando-pomovatun.” ");
INSERT INTO kvg_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yaq Yesu gumbo-qavøiu, “Ngólam. Qoqa unimanqatin kandambá tantáv. Matev āv tønéfakhán, av qo ndaqambe-poev.” Yaq ndaføyambá, tugu yu sège-eqeieqei-év. ");
INSERT INTO kvg_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu ta manqei ndøgo ge-ivav, yaq Gelili kewan ndøgeg-té genø-ewát. Yaq manqei poyat-té gemøqavíg, vømø̄qom. ");
INSERT INTO kvg_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Yaq ezoqa bawan kandambá gindupindam te-te, ezoqa nøme vøndó-upøgim, kagi ezoqam neka bøi waev mbain ezoqam neka bov o pingim kumbøgeap ezoqam neka manqa-khou ezoqam neka ezoqa nøme, gekha enqoni nøme ndøgo, qazøgoat. Yesu-qá megemege-té ginø-abám, vø̄khakheinøvem. ");
INSERT INTO kvg_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ezoqa ewaqape nqova ndafe kandambá, matev ndøgo, bøi gi꞉qeivim, manqa-khou ezoqam manqat gimanqatam, neka bov o pingim kumbøgeap ezoqam vø̄-eqeieqei-ez, neka kagi ezoqam okho vø̄ngazem, neka bøi waev mbain ezoqam, bøi vø̄kewag. Yaq ndigu Mbumbukiam-qá iz ndø-eqánem, ndego Izlael ezoqam-ge Mbumbukiam. ");
INSERT INTO kvg_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu ekeza paev ezoqam tenø-møváb ndǿgo, gezø-ein, “No nginik ezoqam tanakh nøzøgó. Zapa ndǿgo, nginik no namba ngigu, khøuwa misiká. Yaq ndakin ndigu lou mbaín. No poeveáv, ndigu ififin-us sa tækhofosam. Soqaín ndøgo, nakhoa-te bøi tømøzø-gugim, ti꞉qavoniapet.” ");
INSERT INTO kvg_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yaq paev ezoqam gimbo-einim, “Gê, lou gekham-tē qazíqeivīm, nqanek ezoqam-av manqei-te, nginik ezoqa bawan-qape vizí꞉zøkēf.” ");
INSERT INTO kvg_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yaq Yesu gendo-ein, “Flawa gekhâm nandizøgo?” Yaq gindu-qavøinam, “Flawa ate gi꞉goam sevén neka zonga khasøkhasis khapímbá.” ");
INSERT INTO kvg_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yaq Yesu ndigu ezoqa bawan-qape, manqei-te qonam manqat zø-eín. ");
INSERT INTO kvg_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Yaq até gendego, nginik flawa seven neka zonga, gè-upøzó, Mbumbukiam ike manqat vømbō-ein, sasa ndømbegim, ekeza paev ezoqam vøzø̄-etoam, yaq ndigu ezoqa ewaqape sasa zø-etoam. ");
INSERT INTO kvg_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yaq ezoqa ewaqape lou tilóg ndǿgo, até vøzø̄-ewez. Yaq lou mbegeap ndøgo, ezoqa gi-ivøvem, gèpizumém. Yakhav kandakanda sevén, ginqeitømem, qamøvea. ");
INSERT INTO kvg_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ezoqa kopoav-qapé, nqanek lou gilog. Angana ate gi꞉goam, fo taosén. Geté sakheis neka nakheis, lou gilog, gevebøpøteáv. ");
INSERT INTO kvg_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu ezoqa ewaqape gumu-khofosam, yaq ekeza paev ezoqam namba, khagua-té ginøketáb, Magadan manqei-te sasa ndøqantav. ");
INSERT INTO kvg_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Yaq Felisi ezoqam neka Sadusi ezoqam ndozáv, Yesu-te. Matemateam-qa mbogoám. Gimbo-einim, “Umingiap matev qómatanám. Yaq tàbati-nøtén av nqægo, qo Mbumbukiam ndokhofotāq.” ");
INSERT INTO kvg_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Geté Yesu gezø-qavøiu, “Khaiya køkouk tøgoat, khøuwa gemøsinanɨn, yaq zo mø̀zøte-zøtezɨ́n, khaiya eqeieqeí segení-goát. ");
INSERT INTO kvg_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Yaq khaiya kikis neka bøivun tøgoat, qanaqanus qando-paveɨn, zo mø̀zøte-zøtezɨ́n, qæ ndǿlanqá. Zo khaiya qazo-qeivimin, zo mø̀zøte-zøtezɨ́n, khaiya ande āv khanégoāt. Geté zo matev nqazo-qeivi, av ndakin nqæfakhanumit, yaq zo taqa mokho upøgimáv. ");
INSERT INTO kvg_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Zo ezoqa ndakin nqazoyage, zo ezoqa soqøsoqá neka zo Mbumbukiam-te tøkebeáv. Yaq ndakin, zo umingiap matev qeivi-qa mba zøgó. Geté zo matev nøme zóqeivimák. Sa ndǿgo tozóqeivím, av Ziona qambøe-fakhan.” Yaq Yesu sègeziváz, vø̄wav. ");
INSERT INTO kvg_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesu-gi paev ezoqam, kewan yaq-keoqa gimøqa, flawa upøzoateáv. Manqa mate zømbo-navøém. ");
INSERT INTO kvg_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yaq Yesu gezø-ein, “Aiyá qagó. Felisi neka Sadusi ezoqam, tiqa flawa poponøvem nonqo, gèmbøe-feazoát.” ");
INSERT INTO kvg_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yaq ndigu paev ezoqam, ekeza mokho-mba gibond, “Yesu nqanek manqat ekeqa ndǿgo tene-eín, ni flawa upøzoateav qazigoam.” ");
INSERT INTO kvg_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu é-møndæ-otév, ndigu gekha manqat mē꞉bondat. Yaq gezø-ein, “Zo gekha zapâ, flawa-qa yaq-te nqazøte-fofogeap? Zoqa unimanqatin Mbumbukiam-te khapémbá. ");
INSERT INTO kvg_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Gê, zo mokho ndapeâv? Zo tozombó-matavap, no flawa faev, ndigu faev taosen ezoqam qatezøkef? Yaq yakhav andē gekhâm qazo-nqeitømem, lou ndøgo qamøvea? ");
INSERT INTO kvg_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Neka gê, zo tozombó-matavap, no flawa seven, fo taosen ezoqam qatezøkef? Neka yakhav andē gekhâm qazo-nqeitømem, lou ndøgo qamøvea? ");
INSERT INTO kvg_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Zo gekha zapâ, noqa manqa mokho qeiviav ndozogo? No ambá av nqǣgo, lou-qā yaq-tē qazømbe-eīn. Geté no Felisi neka Sadusi ezoqam-qa flawa poponøvem nonqo nøte-eín. Zo ndǿgo tozombøé-feazotát.” ");
INSERT INTO kvg_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yaq ndakin, Yesu-gi paev ezoqam, manqa mokho tinømbo-ndapém ndǿgo, ndego ambá flawa poponøvem nonqo me꞉-eīn, ndøgo flawa-te toqotu-nqagim. Geté ndego Felisi neka Sadusi ezoqam, tiqa nømendim matev-qa yaq-té gene-eín. ");
INSERT INTO kvg_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yaq Yesu, Sæzalia-Filipai taon avønin-té genøwáv. Yaq ekeza paev ezoqam gezøbevap, “Gê, Ezoqam-ge Yo, ezoqam gekha mé꞉vewe?” ");
INSERT INTO kvg_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Yaq gimbo-qavøinam, “Ezoqa nøme ndimanqate, qo Zión, ndego ibøkha iz etoam ezoqam. Neka nøme ndimanqate, qo Ilaizá. Neka nøme ndimanqate, qo Zelemayá, o Mbumbukiam-gé manqa vevezam ezoqá nømé, ndigu ibugukhokhof giyageapam.” ");
INSERT INTO kvg_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yaq Yesu gezøbevap, “Gemâ zo? No gekha ezoqām zøténæna?” ");
INSERT INTO kvg_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Yaq Saemon Pita gembo-qavøiu, “Qo Mesayá. Khandi Mbumbukiam-gé Yó.” ");
INSERT INTO kvg_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yaq Yesu gendo-qavøiu, “Saemon, Ziona-ge yo, qo khanakhanakh mbá qanegó. Zapa ndǿgo, nqanek matavap, qo ambá av nqǣgo, manqei-qape ezoqam qaveāz. Geté nogé Tat qaveáz, ndego yan-te ngo꞉yage. ");
INSERT INTO kvg_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Neka no nqataqá-manqate. Qo Pitá. Taqa manqa mokho, ‘Nandí.’ Yaq ta nandi-qape-te nginik, no ndigu ezoqam, no ndi-unimanqatinat, tiqa bawan andé khoev me notó꞉wév. Nqova soqaqape-qa bazaføgakh kopømba mbaín, nqanek bawan tøtømbua. ");
INSERT INTO kvg_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","No Mbumbukiam-qa Megeat Matev mboqogim nonqo nøtaqá-etoám. Gekha matēv ndøgo, qo nqanek manqei-qape-te toqotø-tokimat, até yan-té-a, āv tønétokát. Neka gekha matēv ndøgo, nqanek manqei-qape-te toqo-mboqogimat, até yan-té-a, āv tøné-mboqovát.” ");
INSERT INTO kvg_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yaq Yesu ekeza paev ezoqam manqa āv gezømbe-løvuá nqǽgo, “Zo ezoqa nøme zø̀-ei᷄n, av nqægo, no Mesayā.” ");
INSERT INTO kvg_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ta khøuwa-te ndøgo, Yesu ekeza paev ezoqam, teqa løvøte-qa yaq-te zømesim ndøngáz. Gezø-ein, “No Zelusalem taon-té qabatønáv, nqosøgeap kandambaqape bamø̄ndap, ti-te ndigu, megetapak neka Mbumbukiam-gi iziz ezoqa kandakanda neka Mozes-qa guguna manqat nømendim ezoqam, neka bemø̄lambem. Geté khøuwa timønø-misika-ez ndøgo, Mbumbukiam no nqawa ndø̀khandí꞉n.” ");
INSERT INTO kvg_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yesu nqanek manqat ge-ein, yaq Pita até gendego, sègekható, vø̄gugu, gembo-ein, “Evézøza. Āv taoká! Matev av nqægo, betaqa-fàkha᷄n.” ");
INSERT INTO kvg_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Geté Yesu, gèndoqambún, Pita vømbō-ein, “Mòqoqáv qo, Saitan! Qo qònømbø-khazét. Qoqa matavap nandav, ambá av nqǣgo, Mbumbukiam-tē qandowāv. Geté manqei-qape ezoqam-té qandowáv.” ");
INSERT INTO kvg_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yaq Yesu ekeza paev ezoqam gezø-ein, “Gekha ezoqām ndego, no-te paev-qa ndego, ndego ekeza poev matev zitá geabetewuá, neka ekeza tae mutui bē-eqa, neka no sasa benøndopaev. ");
INSERT INTO kvg_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Unimanqatín. Gekha ezoqām ndego, ekeza yage tendapet, ndego ndæ̀khambuá. Geté gekha ezoqām ndego, no zapaya ekeza yage te꞉khambua, ndego ndø̀møqeív. ");
INSERT INTO kvg_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Gèmbo-mataváp. Ezoqa manqei-qape gigiap ate nqægo tømbogawam, yaq ekeza yage gēkhambuā, ta gigiap ate ndægo áv khambøé-tøkē? Neka gê, ngenek ezoqam, gekha fia ndǿgō, yage nango temendap? ");
INSERT INTO kvg_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ezoqam-ge Yo tendoqavan, enzol ezoqám namba mé꞉geáv. Eve-qa waev neka bazaføgakh namba mé꞉geáv, neka ezoqa ewaqape yaq-fia vøzǿ-etoām, av ndigu matev ndi꞉matanam. ");
INSERT INTO kvg_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","No unimanqatín nqazø-manqate. Zo ezoqa nøme nqazo-waniap, naqanøká zópakhaezák. Geté Ezoqam-ge Yo ndòzotøkhæ-ometám, teqa Megeat Matev namba te꞉geav.” ");
INSERT INTO kvg_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yaq khøuwa siks-qa zita-te, Yesu, Pita neka Zems neka tege namba qawan Zion, manqei poyat-qape-té genø-itúb, vømø̄-yakhapus-mokho-mba-ez. ");
INSERT INTO kvg_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yaq Yesu-te gi꞉kewagam, ndego bugug sògo-enendtát, tiqa bøi-te. Teqa bugug andé khøuwa waev me me꞉sanqatavavún, neka teqa ndabua ùnime꞉-papaqá. Andé wáev. ");
INSERT INTO kvg_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yaq nqáe! Mozes neká Ilaiza, sègezø-fakház. Yesu namba, manqat ndømanqatám. ");
INSERT INTO kvg_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Yaq Pita Yesu gembo-ein, “Evézøza. Qanimáv, ni nqeigu. Qo taqa-pøovat, no khoev-qasis misika nøzǿpuán, qoqa kopo neka Mozes-qa kopo neka Ilaiza-qa kopo.” ");
INSERT INTO kvg_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita ate av-té manqat ge꞉manqatam, yaq ozoz ndøgutáz. Waev-ús. Yaq nqáe! Ozoz-te ndøgo, manqat ndofakhán. Āv qande-eín nqǽgo, “Ngenek nogé Yó. No poev kandambá te-te, neka no nø̀mbøe-khafuát. Zo teqa manqat gèyogé.” ");
INSERT INTO kvg_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yaq ndigu paev ezoqam, nqanek manqat giyogem, møe kandambá gigonem. Yaq sège-o꞉áz. Bugug até manqei-té. ");
INSERT INTO kvg_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Geté Yesu tendowáv ndǿgo, kha vøzø̄-khanøzam. Gezø-ein, “Mòzowán. Møe ndøgòne᷄m!” ");
INSERT INTO kvg_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Yaq kawa gi-eqagim, gikewag, Yesu mba ndø-ometám. Ezoqa nøme mbaín. ");
INSERT INTO kvg_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Manqei poyat-te nango gi꞉visat, Yesu manqa zøløvuá. Gezø-ein, “Matev nqanek, zo qazoqeivim, ezoqa nøme naqanøká me꞉zø̀ma᷄s. Geté Ezoqam-ge Yo, løvøte-te bètøndokhæ-khandí꞉v.” ");
INSERT INTO kvg_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yaq tegi paev ezoqam gimbo-bevøpem, “Gekha zapâ Mozes-qa guguna manqat nømendim ezoqam ndimanqate, av nqægo, ‘Ilaiza betøkhæ-fakhān.’?” ");
INSERT INTO kvg_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yaq Yesu gezø-qavøiu, “Unimanqatín, Ilaiza bugukhokhof ndø̀khæ-fakhán, gigiap ate ndægo vǿkhakheinām. ");
INSERT INTO kvg_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Geté no nqazǿ-manqate: Ilaiza mø̀ndø-fakhán. Geté ezoqa ndego matavapøteáv. Yaq matev āv timbi-matønømém, av ekezan qazømbe-pøovat. Yaq até Ezoqam-gé Yó-a, nqosøgeap ndǿndáp, tiqa zenda-te.” ");
INSERT INTO kvg_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yaq paev ezoqam, manqa mokho tinømbo-ndapém ndǿgo, Yesu Ilaiza ge꞉manqatam, ndego Zion me꞉manqatám, ndego ibøkha iz etoam ezoqam. ");
INSERT INTO kvg_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesu paev ezoqa misika namba, manqei pøyat-te ginduvis, ezoqa bawan-qape mø̀ndøgoám. Yaq ezoqam tendowáv ndǿgo, teqa megemege-te katuk vø̄møkui. ");
INSERT INTO kvg_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Gembo-ein, “Evézøza. Noge yo tanakh gèmbogó! Gèmbo-qanavøém. Ùnime꞉-soqoevɨ́n. Nøme gøinam-té genø-bøiavɨ́n neka nøme ibøkha-te vø̄bafɨn. ");
INSERT INTO kvg_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","No qogi paev ezoqam-te qændafat, ndigu amba me꞉khamasém. Geté ndego eqeieqeivateáv.” ");
INSERT INTO kvg_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yaq Yesu gendo-qavøiu, “Zo matev køfigiap neka unimanqatin mbain ezoqam, zo ndakin nqazoyage, gê, no khøuwa andé gekhâm, zo namba tizi꞉yagat neka zoqa viniv vǿe-eqatāt? Geté ság! Opønakam vø̀ndo-ndafém.” ");
INSERT INTO kvg_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yaq gindu-ndafem, Yesu nqova soqa gèmbøe-khafén, ndego opønakam-qa mokho-te gu꞉goam, yaq ndego vømbō-fakhan. Yaq opønakam, sège-eqeieqei-év. ");
INSERT INTO kvg_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Taqa zita-te, tegi paev ezoqam, Yesu namba gimi-yakhapus-mokho-mba-ez, gèmbo-bevøpém, “Ni gekha zapâ, nqova soqa amba qambøi-ngeatømem?” ");
INSERT INTO kvg_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yaq gezø-ein, “Zapa ndǿgo, zoqa unimanqatin khapémbá. No unimanqatín nqazø-manqate: Zoqa unimanqatin Mbumbukiam-te, kopømba ande av masted tae nanga-qasis ndægo tøgonɨn, yaq zo ambá kopømbá, manqei poyat nqanek ambá āv qazømbøe-einimín nqǽgo, ‘Manqei nøme-té qonǿqáv.’ Yaq ndøgo ambá segewavɨ́n. Matev ate ndægo, zo ambá kopømbá tozo-matønømemɨn.” ");
INSERT INTO kvg_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Khøuwa nøme, Yesu tegi paev ezoqam namba, Gelili plovins-te gipindam, Yesu āv gezømbe-eín nqǽgo, “Ezoqam-ge Yo, avønín, ezoqam-qá zenda-té ginǿveém, ");
INSERT INTO kvg_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","neka vǿlaēm. Geté khøuwa timømbo-misika-ez ndøgo, ndego Mbumbukiam nango ndø̀khandí꞉v.” Ndigu paev ezoqam, nqanek manqat giyogem, yaq mbøni zøvá. Mbøni vaev kandambá. ");
INSERT INTO kvg_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu tegi paev ezoqam namba, Kapenaum taon-te gimøfakhaz, yaq teks moni upøgim ezoqam ndozáv, ndigu Mbumbukiam-qa khoev teks moni gi-upøgimatun. Pita-té ginduzáv, gimbo-einim, “Gê, zoge nømendim ezoqam, teks moni møndǿ-abumatun, Mbumbukiam-qa khoev nonqo?” ");
INSERT INTO kvg_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Yaq Pita gendo-qavøiu, “Mø̀ndø-abumatún.” Yaq Pita khoev-te gendoqavan, ambá Yesu mbo-einín, taqa yaq-te. Geté Yesu ekezan, é-mando-eín, “Sáemon. Qoqa matavap áv khané꞉go? Manqei-qape-gi kawakawa-za, teks moni gekha ezoqam-tē gindú-upøgimatun? Ekeza ezoqam-tê, ó, ezoqa vini-tè?” ");
INSERT INTO kvg_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Yaq Pita gendo-ein, “Ezoqa vini-té gindu-upøgimatún.” Yaq Yesu gendo-qavøiu, “Unimanqatín. Kawakawa-za-gi ezoqam, teks moni gé-abamák ti-te. ");
INSERT INTO kvg_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Geté, ság, soqaín ndǿgo, nginik teks moni upøgim ezoqam, qaqa tizizø-løwaz. Yaq nakémbá. Kewan-té qanø-ová, vømø̄-faleam. Yaq zongøyam ndego, bugukhokhof toqo-tøkhatav, manqa-nqa qombó-mboqoá. Yaq moni mokho toqózømét ndǿgo. Yaq ndigu moni mokho, teks moni upøgim ezoqam-té qonǿ-ndapáz. Yaq qo neka no, nigi teks moni nándiv.” ");
INSERT INTO kvg_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ta khøuwa-te ndøgo, Yesu-gi paev ezoqam tinduzáv ndǿgo, vømbō-bevøpem, “Gê, Mbumbukiam-qa Megeat Matev mokho-te, iz akhae kandambaqape, gekha ezoqām ndǿgoāt?” ");
INSERT INTO kvg_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yaq Yesu nakhasam mbo-akhá, tiqa mokho-te livin-mba ndøugu, vø̄ve. ");
INSERT INTO kvg_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Gezø-ein, “No unimanqatín nqazø-manqate. Zo enendateav tøgoat, neka kopømba ande av nakhei nqonqon ndi꞉gu vozomǿgō, yaq zo Mbumbukiam-qa Megeat Matev mokho-te, zomǿ-ozák. ");
INSERT INTO kvg_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Gekha ezoqām ndego, ekeza kha tevoa, kopømba ande av nakhasam nge꞉go, kandambaqape ndégo tégoát, Mbumbukiam-qa Megeat Matev mokho-te. ");
INSERT INTO kvg_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Neka gekha ezoqām ndego, noqa iz-te, nakhasam av nge꞉go tekhato, ndego no ndǿkhatómb.” ");
INSERT INTO kvg_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Gekha ezoqām ndego, nakhei nqonqon av ngi꞉gu, ndigu no ndi-unimanqatinat, manqa-zapa-te te-itub, teqa manqa-zapa kandamba tantáv. Ndego amba nandi-qape monqo-te timbo-møpøtøzemɨn, yaq anana-mba sasa mø-oginamɨn, vømø̄-geonɨn, yaq ta yaq-fia te-te ndego, ambá andé khapémbá. Geté yaq-fia kandambaqape ndǿgo, Mbumbukiam-te temøndap. ");
INSERT INTO kvg_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Manqei-qape ezoqam mø̀ndø-soqoéz, ndigu ezoqa nøme, manqa-zapa-te ndi-ituza. Unimanqatín. Khamasim matev, ndø̀fakhanám, ndøgo ezoqa manqa-zapa-te tø-itubat. Geté ndigu ezoqam ndø̀soqoéz, ndigu ezoqa nøme manqa-zapa-te ti-itubat. ");
INSERT INTO kvg_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Qoqa pingim o bov manqa-zapa-te tø-ituqabat, gèkepáz, vø̄-ogi. Pingim o bov kopo mba taqagoat, khandi miavmiav-te toqomø-oq, ndøgo kopømbá. Geté soqain ndǿgo, qoqa bov menas neka pingim menas namba, gøinam-te timø-ogeqænam, ndøgo miavmiav ndøwageap. ");
INSERT INTO kvg_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Neka qoqa bøi manqa-zapa-te tø-ituqabat, gèkhofá, vø̄-ogi. Bøi kopo mba taqagoat, qo khandi miavmiav-te toqomø-oq, ndøgo kopømbá. Geté soqain ndǿgo, qo bøi menas taqagoat, yaq gøinam-tē gimǿ-ogeqænām.” ");
INSERT INTO kvg_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Zo aiyá qagó. Zo ezoqa khasøkhasis, av nginik nakheis ngi꞉gu, khokho ezoqam me꞉zæ̀za᷄. No nqazǿ-manqate: Enzol ezoqam ndigu, nginik ezoqam ndizø-keoge, noge Tat-qá bugug-té giwaniáp, ndego yan-te ngo꞉yage. ");
INSERT INTO kvg_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ge zô ndozo-matavap? Ezoqa sip wan andled timbogoat, yaq kopo gembō-ewān, yaq gê, ndego gekhā ndǿgō? Ndego ndigu nainti-nain nøme, segéziváz, ta manqei poyat-te ndøgo, gagayag gilogatun, nøme-qa vømǿvaō, ndugu gumbo-ewan. ");
INSERT INTO kvg_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","No unimanqatín nqazø-manqate. Ndugu sip kopo tu-omet, ndego khanakhanakh kandambá tendap. Teqa khanakhanakh tu-ti ndugu, ndø̀mø-løvuám, av khanakhanakh, sip nainti-nain-te ndømbøego, ndigu yozaneav ndigu. ");
INSERT INTO kvg_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Yaq matev até kopó. Zoge Tat yan-te ngo꞉yage, ndego poeveáv, nginik ezoqa khasøkhasis, kopo te-ewan.” ");
INSERT INTO kvg_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Klisten qafu manqa-zapa tego qo-te, yaq vø̀mboqáv, teqa manqa-zapa vø̄e-omat, zo ezoqa menas zøkhapus-mba vø̄khakheinømem. Ndego qoqa manqat te-ewag, yaq nango mø̀ndøqa-Klisten-qafu-év. ");
INSERT INTO kvg_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Geté ndego qoqa manqat yogeav tøgoat, yaq qo ezoqa kopo o menas namba zøtézáv, te-te. Zapa ndǿgo, Mbumbukiam-qa Manqat āv qane-manqaté nqǽgo, ‘Manqa ovøyam tøgoat, yaq bøi vizu ezoqam menas o misika begó.’ ");
INSERT INTO kvg_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Geté ndego tiqa manqat te-ogi, yaq Klisten bawan ezoqam-té qanø-ndafém. Yaq ndego até tiqá manqát-a te-ogi, qo ndego bavokho-ak o teks moni upøgim ezoqam qotéveó. ");
INSERT INTO kvg_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","No unimanqatín nqazø-manqate. Gekha matēv ndøgo, zo nqanek manqei-qape-te tozoto-tokimat, até yan-té-a, āv tønétokát. Neka gekha matēv ndøgo, nqanek manqei-qape-te tozo-mboqogimat, até yan-té-a, āv tøné-mboqovát. ");
INSERT INTO kvg_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Neka nøme nqazǿ-manqate: Nqanek manqei-qape-te, zo mokho-te, ezoqa menas manqat tikoponemat, yaq Mbumbukiam sasa mbóviømemāt, noge Tat, yan-te ngo꞉yage, matev ndø̀matanám ti-te. ");
INSERT INTO kvg_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Zapa ndǿgo, ezoqa menas o misika noqa iz-te timøvab, no ndæ̀goát, ti namba.” ");
INSERT INTO kvg_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yaq Pita tendowáv ndǿgo, Yesu vømbō-ein, “Evézøza. Noge Klisten nøfu, no-te manqa-zapazapa sekemba tegoat, yaq gê, no andé gekhâm tæmbo-geveam, sa tønømbo-navøem? Até tægoat sevên?” ");
INSERT INTO kvg_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yaq Yesu gembo-qavøiu, “Ambá av nqægo, seven mbā. Ndøgo khapémbá. Geté sà betaqambo-navøemát. Seven até tægoat seventí, sa tøqambo-navøemat. ");
INSERT INTO kvg_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Zapa ndǿgo, Mbumbukiam-qa Megeat Matev, kopømba ande av nqǽgo: Kawa ezoqam mø̀ndøgoám. Ndego moni upøgim-qa ndøgoám, tegi sasae ezoqam te-te qazømbo-løfokam. ");
INSERT INTO kvg_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Yaq ndego moni tonqogim gengaz, sasae ezoqa nøme tindu-ndafém ndǿgo. Ndego moni milión, qambøe-løfokam. ");
INSERT INTO kvg_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Geté ndego moni mbaín, tege kawa ezoqam vømbøé-etoām. Yaq kawa ezoqam, manqat āv gembøe-eín nqǽgo, ‘Av tægoat ndægo. Gigiap ate ndaqambe꞉go, qówí. Até qogu sævam neka nakheís-a, voqówī. Yaq fia qotégó, no-te.’ ");
INSERT INTO kvg_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Yaq ndego sasae ezoqam, kawa ezoqam-qa megemege-te, ekeza kha, manqei me꞉laváo, vømbō-ein, ‘Káwa ezoqam. Tanakh gènøgó. Até vøkhæ-keogé. Fia ate ndægo, nqanømbo-løfoke, ndø̀taqa-etoám.’ ");
INSERT INTO kvg_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Yaq ndego kawa ezoqam, tanakh mbogó, gembo-ein, ‘Ság! Fia nø-ètoa᷄m.’ Yaq sègemboták, vø̄wav. ");
INSERT INTO kvg_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Geté ndego sasae ezoqam gendo-fakhan, sasae kopømba ezoqam mba mo꞉qát. Ndego moni mbøe-løfokám, te-te. Khapímbá. Geté yaq até gendego, sège-khoteiú. Monqo mba mbøegeá, gembo-ein, ‘Fia qonǿ-etoám, no-te ndaqambo-løfoke.’ ");
INSERT INTO kvg_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Yaq ndego sasae ezoqa nøme, katuk ndømøkuí, teqa megemege-te, gembo-ein, ‘Tanakh gènøgó. Até vøkhæ-keogé. Yaq fia ndæ̀gó.’ ");
INSERT INTO kvg_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Geté ndego gèmbøeqasí. Yaq até gendego, ndimbula-te vø̄-utav. Yaq ndego até gú꞉goát ndøgo, atema yaq-fia vǿgō. ");
INSERT INTO kvg_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Yaq sasae ezoqa nøme, nqanek matev giqeivim, ndigu mbøni zønqosøgím. Yaq kawa ezoqam-té ginøzáv, emanqat ate ndægo vømømbō-vototem. ");
INSERT INTO kvg_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Yaq ndego kawa ezoqam, ngenek sasae ezoqam, gèmbo-akhá. Gembo-ein, ‘Qo ezoqa soqaqapé. Moni kandambaqapi ate ndi꞉gu, no-te qaqambo-løfokam, no sø̀taqaták, qo qoqonø-viam. ");
INSERT INTO kvg_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Geté gekha zapâ, qo sasae kopømba ezoqam-te tanakh goneav qagoam, av no tanakh qataqambego?’ ");
INSERT INTO kvg_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Yaq ndego kawa ezoqam, qaqa kandambá gego. Yaq até gendego, ngenek sasae ezoqam ndimbula-te vø̄-utav. Yaq ndego até gú꞉goát ndøgo. Neka yaq-fia nqosøgeap ndǿ-upøgimát, atema fia ate ndægo vømúgū.” ");
INSERT INTO kvg_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu nqanek yaya etæ manqat qamømbøe-navøem, nøme āv gene-eín nqǽgo, “Noge Tat, ndego yan-te ngo꞉yage, zo-te matev até kopó, āv tenégó, zo ezoqa nøme-te, tiqa manqa-zapazapa, sa navøepøteav tøgoat.” ");
INSERT INTO kvg_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu nqanek manqa manqate qamømbøe-navøem, Gelili plovins tène-iváv. Yaq Zudia plovins-té genøwáv, ndøgo Zoden kea yaq-keoqa. ");
INSERT INTO kvg_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ezoqa mø̀ndømbo-pavát, bawan-qape kandambá, neka ndego enqoni-us ezoqam vø̄khakheinøvemat. ");
INSERT INTO kvg_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Yaq Felisi ezoqam ndozáv, Yesu-te. Ambá gembo-matemateømemín, gimbo-einim, “Gê, Mozes-qa guguna manqat, áv khané-ein? Ezoqa kopømbâ, sævam sa te-ivav, ndego poev tømbogoat, ó, kopømba mbaîn?” ");
INSERT INTO kvg_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yaq Yesu gezø-qavøiu, “Ge zô, Mbumbukiam-qa Manqat mozó-geveømem, av qæ-ein nqægo? ‘Mbumbukiam ezoqa ande ge꞉khakheinøvem, anganeam neká sævam, tèkhakheinøvém.’ ");
INSERT INTO kvg_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yaq Mbumbukiam āv gene-eín nqǽgo, ‘Yaq nakémbá, anganeam eve neka evo géziváz. Yaq zās namba mé꞉tøkuaném, yaq ndigu ezoqa menas, vømǿ-kha-kopo-ēz.’ ");
INSERT INTO kvg_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yaq ndakin ndigu ambá av nqǣgo, kha menās, av bugukhokhof gi꞉goam. Geté kha kopó. Ndigu Mbumbukiam ndøtøkuzú. Yaq ezoqa beqatø̀zo᷄.” ");
INSERT INTO kvg_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Yaq Felisi ezoqam gimbo-einim, “Av tægoat ndægo, yaq gekha zapâ, Mozes-qa guguna manqat av qæ-ein av nqægo? Anganeam sævam ivøve-qa tegoat, ndego sakhei zøuvis pepa bepeawám, bembō-etoam, sasa bekhofotav.” ");
INSERT INTO kvg_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yaq Yesu gezø-qavøiu, “Mozes sakhei zøuvis matev sa gezøtak, zapa ndǿgo: Zo khàpe zøtesapí꞉z. Geté Mbumbukiam ezoqa ande ge꞉khakheinøvem, av me꞉matøvemák, av ndægo. ");
INSERT INTO kvg_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","No nqazǿ-manqate: Gekha ezoqām ndego, sævam te-ivav, getē ndugu mambe okhoeāv, yaq sævam vini vǿ-okɨ̄, ndego nøkenøkem matev ndǿngiú neka mambe mé꞉wáv.” ");
INSERT INTO kvg_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yaq Yesu-gi paev ezoqam gimbo-einim, “Av tægoat ndægo, anganeam kopømba mbain tøgoat, sævam sa te-ivav, yaq qanimav ndǿgo, nøkenøkem tiá, sà biziyagé.” ");
INSERT INTO kvg_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yaq Yesu gezø-qavøiu, “Nandav manqat, nøkenøkem mbain-qa yaq-te, ezoqa ewaqape-qá mbá. Geté tiqa mba ndígu, Mbumbukiam matev tezø-etoam. ");
INSERT INTO kvg_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ezoqa sakhei zøkemav ndigu, zapazapa vinivinimbá. Nøme ndigu āv tiniqáz. Neka ezoqa nøme, zapa ndǿgo: Ezoqa āv tizømbe-matanám. Geté ezoqa nøme, sakhei zøkemav ndigu, Mbumbukiam-qá Megeat Matev zapayá. Gekha ezoqām ndego, kopømba tegoat, nqanek nømendim matev tendap, sà bendáp.” ");
INSERT INTO kvg_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yaq ezoqa nøme, Yesu-te, nakheis ndo-upøgím. Ndigu mø̀ndøzøpoé, Yesu ambá zenda zømbø-awamɨ́n neka vøzø̄-guligulimɨn. Geté tegi paev ezoqam gèzømbe-khafén, ndigu ezoqam. ");
INSERT INTO kvg_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Geté Yesu gendo-ein, “Nakheis bègeáv, no-te. Zømbo-khakhàza᷄m. Zapa ndǿgo, Mbumbukiam-qa Megeat Matev, tiqa ndígu, av nakheis ngi꞉gu.” ");
INSERT INTO kvg_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yaq Yesu até gendego, nakheis zenda vøzømbø̄-awam neka vøzø̄-guligulim. Yaq qamømbøe-navøem, tènewáv. ");
INSERT INTO kvg_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Khøuwa nøme, ezoqa tendowáv ndǿgo, Yesu-te, vømbō-ein, “Nøméndim ezoqam. Gekha matev eqeieqei nómatønumāt, khandi miavmiav vøténdāp?” ");
INSERT INTO kvg_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yaq Yesu gembo-qavøiu, “Gekha zapâ, no matev eqeieqei-qa yaq-te, ndoqonømbe-bevap? Eqeieqei Mbumbukiam mba me꞉gó. Geté qo khandi miavmiav ndape-qa ndoqombogo, qo Mbumbukiam-qá guguna manqat qombópavát.” ");
INSERT INTO kvg_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yaq ndego gendo-ein, “Gekha guguna manqat nombópavāt?” Yaq Yesu gendo-qavøiu, “Guguna manqat nqánek qoqombó-pavát: Qo ezoqa pakhapakha zøkhanèa᷄m. Neka nøkenøkem matev ndøngì꞉wa᷄t. Neka ndø-aqòna᷄m. Neka meakha manqat ndømanqàte᷄. ");
INSERT INTO kvg_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Qave neká qavo, gèzøvizáp. Ezoqa nøme-te, kuku āv tabetaqambe꞉gó, av qakeza kha-te kuku ndaqambe꞉go.” ");
INSERT INTO kvg_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Yaq ngenek ezoqa ndakinak gendo-ein, “Nqanek guguna manqat ate ndægo nqæmbôpáev. Yaq gekha matev nøme ndǿgò, no matønumav ndøgo?” ");
INSERT INTO kvg_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yaq Yesu gembo-ein, “Qo ndaføyamba-qape gone-qa toqogoat, vø̀khæqáv, qoqa gigiap ate ndægo, vømø̄wi. Yaq moni ndigu toqoqas, gigiap-av ezoqam qozǿ-etoám. Av toqotego ndægo, yaq qo gigiap qaniqanim yan manqei-té qoqonǿ-møvøemét. Yaq vø̀ndoqáv. No qonøndó-páev.” ");
INSERT INTO kvg_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yaq ndego ezoqa ndakinak, nqanek manqat ge-ewag, sègewáv. Avus-mba mbovoé. Zapa ndǿgo, ndego gigiap kopoáv qambogoam. ");
INSERT INTO kvg_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yaq Yesu ekeza paev ezoqam gezø-ein, “No unimanqatín nqazø-manqate. Ezoqam ndego gigiap kopoav tømbogoat, te-te ndego unimé꞉-føgákh, Mbumbukiam-qa Megeat Matev-te te-on. ");
INSERT INTO kvg_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Unimanqatín. Kemol ndugu, søvakha gigiap kandambaqapu, mil nqa-te one-qa tugoat, tu-te ndugu, føgakh andé mbaín, av gigiap kopoav ezoqam-te føgakh ndægo, ndego Mbumbukiam-qa Megeat Matev mokho-te one-qa tegoat.” ");
INSERT INTO kvg_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yaq paev ezoqam nqanek manqat giyogem, ndigu nqova ndafe kandambá, yaq gimbo-bevøpem, “Av tægoat ndægo, yaq gekha ezoqām ndǿkhandī꞉v?” ");
INSERT INTO kvg_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yaq Yesu ti-te gekewag, gezø-ein, “Matev av nqægo, ezoqa kopømba mbaín. Geté Mbumbukiam kopømbaqapé. Gekha matēv ndøgo, ndego gone-qa ndembogo, kopømbá, segégó.” ");
INSERT INTO kvg_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yaq Pita gembo-qavøiu, “Nqáe! Ni gigiap ate qanimbi-goam, zitá qati-wuøém, qo nqeitaqambe-paev.” ");
INSERT INTO kvg_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yaq Yesu gezø-ein, “No unimanqatín nqazø-manqate. Gigiap neka matev ate ndægo tøndakinak, yaq Ezoqam-ge Yo iz kandambaqape tendap, neka kawa ezoqam-qa qonam nonqo qanimav-qape-te vó꞉qotāt, yaq até zó-a, zo ezoqa tuelv, no nqazonøndo-paev, zøkeza kawa ezoqam-qá qonam nonqo-té qazotó-qonavát, neka Izlael khagua bawan tuelv vozozømbó-kawaeztāt. ");
INSERT INTO kvg_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Gekha ezoqām ndego, khoev te-ivav, o namba-qaniap o eve o evo o nakheis tezivaz, o khae te-ivav, no zapaya; ndego Mbumbukiam nøme mba mbøé-etoám, kopoav-qapé, wan andléd ate tægoat, yaq ndego khandi miavmiav vømǿndāp. ");
INSERT INTO kvg_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Geté ezoqa kopoáv, ndigu ndakin nduo-megetap, gendópavát. Neka ezoqa kopoav, ndigu ndakin ndindopaev, gó꞉megetát.” ");
INSERT INTO kvg_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yaq Yesu yaya zø-etá, gezø-ein, “Mbumbukiam-qa Megeat Matev, kopømba ande av nqǽgo: Ezoqam mø̀ndøgoám. Waen khae evé. Yaq qanaqanus lovølova-ús. Ndego tenøwáv ndǿgo, teqa khae-te sasae gone nonqo ezoqam vømø̄-upøzo. ");
INSERT INTO kvg_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tiqa yaq-fia, manqat āv gini-kopo꞉ném, av sasae ezoqam khøuwa kopo-te, oskia gi-upøgimatun. Yaq khae-té genø-khofotáz. ");
INSERT INTO kvg_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Yaq ande av 9 oklok ndægo, ndego maket manqei-te gewav, ezoqá nøme ndøzømét. Ndigu khokhó sege-waniapám. ");
INSERT INTO kvg_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Yaq gezø-ein, ‘Até zó-a, noqá khae-té qazonǿzáv, vozomǿ-sasaē. No yaq-fia eqeieqei nøzǿ-etoám.’ ");
INSERT INTO kvg_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Yaq ndigu sègezáv, sasae vømømbō-gonem. Yaq khøuwa muin neka 3 oklok qandap, ndego matev até kopó, āv tenegó, av bugukhokhof ge꞉go. ");
INSERT INTO kvg_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Yaq até 5 oklók-a, ndego maket manqei-te, nangó genøwáv, ezoqa nøme vø̄zømet, ndigu khokho giwaniapam. Yaq gezø-ein, ‘Gekha zapâ, zo khokho nqazo-waniapet, khøuwa mba nqazotø-ngiaomit?’ ");
INSERT INTO kvg_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Yaq gindu-qavøinam, ‘Zapa ndǿgo, ezoqa ni upøngipøteáv, sasae teizøgo.’ Yaq ndego gezø-ein, ‘Ság! Até zó-a. Noqá khae-té qazomǿ-sasaeném.’ ");
INSERT INTO kvg_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Yaq khøuwa gemøsinan, ndego khae eve, tege sasae keoge ezoqam, āv gembøe-eín nqǽgo, ‘Sasae ezoqam mòqozø-akhayám, fia vøzø̄-etoam. Fia etoam toqotøndó-ngáz ndǿgo, ezoqam ndakin gindu-oz, sasae-te. Yaq ndigu, no bugukhokhof qato-upøzo, fia vaev-té qonøzǿ-etoám.’ ");
INSERT INTO kvg_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Yaq ezoqam ndigu 5 oklok sasae gingazem, khøuwa ate ndægo-qá fia ndøndapém. ");
INSERT INTO kvg_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yaq ezoqam ndigu bugukhokhof sasae go꞉ngazem, fia ndape-qa ginduzav, ndigu āv gini-matavupám nqǽgo: Fia andé kandambá tizindapem. Geté fia ndøgo gindapem, até kopó, av ezoqa nøme gi꞉ndapem. Khøuwa kopo-qá fiá. ");
INSERT INTO kvg_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ndigu moni gumu-tonqogim, yaq khae eve, manqat mboponqomém, ");
INSERT INTO kvg_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","gi-einim, ‘Ezoqam nginik, sasae vaev-te gingazem, khapémbá gisasaenem. Yaq gê, áv khanégo, ndigu yaq-fia kopo gindapem, av ni qazi꞉ndapem, ni khøuwa ate ndægo, khøuwa tatas-te qazi-sasaetat?’ ");
INSERT INTO kvg_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yaq ndego khae eve, ezoqa nøme-te, ma manqat geponqomat, āv gembøe-qavøiú nqǽgo, ‘Nǿfu! Qoté-ewāg. No ambá av nqǣgo, nøtaqambe-khavōz, av qo ndoqote-matavap. Āv taoká. Fia ndøgo, qo qoqondap, eqeieqeí. Fia ndǿgo, av ni manqat qazi꞉-kopo꞉nem. ");
INSERT INTO kvg_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ndakin vø̀qáv, qoqa fia namba. No āv qanømbe-pøovám nqǽgo: No ndego ezoqam, vaev-te tendowav, fia até kopó, āv tæmbøé-etoám, av qo tøtaqambe-etoam. ");
INSERT INTO kvg_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ge qô ndoqo-matavap? Ndøgo eqeieqeî mbà, nøkeza moni matev tøtego, av no nqanømbe-poev? O ge qô, qónønguvim, no ndigu matev eqeieqei qazø-matanam, ndigu sasae-te vaev gindu-oz?’” ");
INSERT INTO kvg_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu nqanek yaya gumu-eta, yaq manqat nøme āv gene-eín nqǽgo, “Matev até kopó, āv tønégoát. Ezoqam ndigu, ndakin ndindopaev, ndigu gó꞉megetát. Neka ndigu ndakin nduo-megetap, ndigu gendópavát.” ");
INSERT INTO kvg_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu ekeza paev ezoqam tuelv namba, Zelusalem taon-te gi꞉qavigat, yaq sègekhatób, vømø̄-yakhapus-mokho-mba-ez, gezø-ein, ");
INSERT INTO kvg_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Nqáe! Ni Zelusalem taon-té qazinø-qavigít. Yaq Zelusalem taon-te ndøgo, Ezoqam-ge Yo, Mbumbukiam-gi iziz ezoqa kandakanda neka Mozes-qa guguna manqat nømendim ezoqam-qá zenda-té ginǿveém. Yaq ndigu manqa ovøyam-te sasa ndǿveēm, manqat vǿkopo꞉nēm, av nqægo, yà benanīm, ");
INSERT INTO kvg_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","neka manqei vini-ak-qa zenda-te vǿveēm, ndigu Mbumbukiam zøtezateav ndigu. Yaq ndigu otøotam mé꞉vewém, vǿzuīm, tae mutui-te sasa ndǿtøkewēm, vǿnanīm. Geté khøuwa timømbo-misika-ez ndøgo, ndego Mbumbukiam nango ndø̀khandí꞉v.” ");
INSERT INTO kvg_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedi-gi nakheis-gu evo, Yesu-té gunduwáv. Até nakhei menás-a, Zems neka Zion, vøndōzav. Yaq ndugu katuk ndømøkuí, teqa megemege-te, vømbō-ein, “Nø̀taqa-viám. Kopømbâ, noqa poev matev toqogo?” ");
INSERT INTO kvg_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yaq Yesu gumbo-ein, “Gekhā qápoev?” Yaq gundu-qavøiu, “Noqa poev nqánek. Qo kawa iz toqomøndap, nginik nogi nakhei menas, nøme ngenek, qoqa nakeamo zenda-té gemǿqóm, neka nøme ngenek, qoqa yogea zenda-te vømǿqōm.” ");
INSERT INTO kvg_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Geté Yesu gendo-qavøiu, “Zo zø̀tezøtezák, gekha matev-qa zonø̄-einim. Gê, zo ezoqa menas, kopømbâ, ibøkha khaqain-qape tozo-izam, av no tøte-iz?” Yaq gimbo-einim, “Ni kopømbaqapé.” ");
INSERT INTO kvg_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yaq Yesu gezø-ein, “Unimanqatín. Zo ibøkha khaqain-qape ndòzomø-izám, av no tøte-iz. Geté gekha ezoqām, noqa nakeamo zenda neka yogea zenda-te timøqonav, ambá av nqǣgo, no nǿvevesām. Geté ta qonam nonqo tiqa ndígu tǿgoát, noge Tat gevevesam.” ");
INSERT INTO kvg_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yesu-gi paev ezoqa ten nøme, nqanek manqat giyogem, yaq qaqa ndøgoném, ndigu ezoqa menas-te. ");
INSERT INTO kvg_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yaq Yesu tegi paev ezoqam ate gi꞉goam, tenø-møváb ndǿgo, gezø-ein, “Zo mø̀zøte-zøtéz. Bawabawan-gi kawakawa-za, ezoqa gètokhonøzát. Neka tigi megetapak gò꞉kawaezát, av ekeza poev ndøzømbe꞉go. ");
INSERT INTO kvg_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Geté zo mokho-te, matev av nqægo bègo᷄. Gekha ezoqām ndego, zo mokho-te iz kandambaqape ndape-qa tegoat, ndego yà be-zoge-tøke-ezoqam-év. ");
INSERT INTO kvg_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Neka gekha ezoqām ndego, zo mokho-te megeat-qa tegoat, ndego andé zogé yaq-fia mbain sasae ezoqam bezømbegó. ");
INSERT INTO kvg_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Até Ezoqam-gé Yó-a, ndego matev até kopó. Ndego ambá ndø̄go tenegeavūn, ezoqa sasae timbogoat neka vømbó-tøkeāt. Geté ndego ezoqa tøke-qa neka teqa kha løvøte-te vee-qa ndøgeavún. Yaq ezoqa kopoav, tèabete-nqovotáz.” ");
INSERT INTO kvg_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu tegi paev ezoqam namba, Zeliko taon gi꞉-ivøvem, ezoqa bawan-qape kandambá gimbopavat. ");
INSERT INTO kvg_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Yaq nakhoa keoqa-te ndøgo, bøi waev mbain ezoqa menas mø̀ndø-qonavám. Giyogem, Yesu geløvubat, yaq até gindigonem, vømbō-akhaem, “Evézøza! Déivid-ge Zeo! Ni tanakh gìnigú!” ");
INSERT INTO kvg_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Yaq ezoqa ewaqape, gègugúb, “Zo manqat tiá.” Geté ndigu kandakanda nøme mba mo꞉-akhaemém, “Evézøza. Déivid-ge Zeo. Ni tanakh gìnigú.” ");
INSERT INTO kvg_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yaq Yesu sège-itán, vøzø̄-akha, “Zo gekhā zǿpoev, no tæzø-matanam?” ");
INSERT INTO kvg_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Yaq ndigu gindu-qavøinam, “Evézøza. Ni ambá bøi waev qoni-etoamɨ́n.” ");
INSERT INTO kvg_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yaq Yesu tanakh zøgó. Yaq até gendego, bøi vøzø̄-khanøzam. Yaq ndigu ndaføyambá, bøi sègezø-eqeieqei-ám, neka Yesu vømbō-paevem. ");
INSERT INTO kvg_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu ekeza paev ezoqam namba, Zelusalem taon gi꞉khatoat, yaq Betfage vemiav avønin-te, Oliv manqei pøyat-te ndøgo, ndego paev ezoqa menas tène-khofotáz, ");
INSERT INTO kvg_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","gezø-ein, “Tozonǿzáv ndǿgo, vemiav zoqa megemege-te ndo꞉go. Yaq zo ndaføyambá, donki evo zomǿ-ometám, nakhasam namba. Gémoposupát. Yaq zónqovosám, no-te sasa zotøndó-itūb. ");
INSERT INTO kvg_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ezoqa manqat tezø-ein, yaq zo āv qazømbøé-einím nqǽgo, ‘Evezøza mbopóe, nginik.’ Yaq ndego zo segezǿták.” ");
INSERT INTO kvg_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nqanek matev qafakhan, zapa ndǿgo. Manqat ndøgo, Mbumbukiam tege manqa vevezam ezoqam mokho-te ge-ein, tàbete-unimanqatín. Manqat nqánek, ");
INSERT INTO kvg_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Zayon ezoqam, ndigu Zelusalem taon-ak, gèzø-eín, “Nqáe! Zoge kawa ngégeav. Ndego khambuvap matev mbaín. Donki-qá zita-té gonoqotáv, donki ndugu ndakinak-qapu.” ");
INSERT INTO kvg_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yaq ndigu paev ezoqa menas gizav, matev āv tini-matønømém, av Yesu gezømbe-ein. ");
INSERT INTO kvg_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Yaq donki nakhasam, evo namba, Yesu-té ginø-itúb, ndabua vøzømbō-khafuzam, yaq Yesu sasa mo꞉qom. ");
INSERT INTO kvg_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Yaq ezoqa kopoav-qapé, Yesu-qa megemege-te, ekeza ndabua mo꞉møtagát, nakhoa-te, neka ezoqa nøme vuv vøndōqogaz, sasa mo꞉møtag. ");
INSERT INTO kvg_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yaq ezoqa bawan-qape, Yesu-qa megemege-te vō꞉megetam-a, nøme vøndōpavam, ndigu āv gini-akhaemát nqǽgo, “Hosána! Iké꞉ te-te, Deivid-ge Zeo! Mbumbukiam ngenek ezoqam bèkhakheinøvém, Evezøza-qa iz-te ngegeav! Hosána! Iké꞉ te-te, ndego uni ova-in ngo꞉yage!” ");
INSERT INTO kvg_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yaq Yesu Zelusalem taon-te gemø-on, ezoqa ewaqape nqova zøndáf, gibevøpem, “Gekha ezoqâm, ngenek?” ");
INSERT INTO kvg_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Yaq ndigu ezoqa kopoav-qape, Yesu namba gi꞉geavun, gindu-qavøinam, “Ngenek Yesú. Nazalet vemiav-ák. Gelili plovins-té gendowáv. Ngenek Mbumbukiam-gé manqa vevezam ezoqám.” ");
INSERT INTO kvg_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu Mbumbukiam-qa khoev uta-te ge-on, yaq até gendego, ezoqam ndigu gigiap gu꞉wiat, gèngeasám, neka lou-qasis vøzø̄-nqagim, ndigu møni gi꞉-enendtat neka ndigu kuvøkuvu, Mbumbukiam-te løvusam nonqo, vø̄wiat. ");
INSERT INTO kvg_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yaq gezø-ein, “Mbumbukiam-qa Manqat, āv qane-peawáp nqǽgo, ‘Noqa khoev, guliguli khoev ndǿgoát.’ Geté zo Mbumbukiam-qa khoev zò-enendtēt, vømǿ-aqonam-ezoqam-qa-pebam-khōev.” ");
INSERT INTO kvg_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yaq bøi waev mbain neka kagi ezoqam ndozáv, Yesu-te, ndøgo Mbumbukiam-qa khoev uta mokho-te. Yaq gèkhakheinøvém. ");
INSERT INTO kvg_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Geté Mbumbukiam-gi iziz ezoqa kandakanda neka Mozes-qa guguna manqat nømendim ezoqam, umingiap matev giqeivim, Yesu gematønumat neka vø̄yogem, av nakheis Mbumbukiam-qa khoev uta mokho-te gi-akhaemam, av nqægo, “Hosána! Iké꞉ te-te, Deivid-ge Zeo,” yaq ndigu qaqa ndøgoném. ");
INSERT INTO kvg_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yaq Yesu gimbo-einim, “Ge qô, toqóyoge, av nginik nakhei ndindi-akhayam?” Yaq Yesu gendo-ein, “No nqazøyôgé. Gê, zo Mbumbukiam-qa Manqat mozó-geveømem, av qæ-ein nqægo? ‘Qoqa iz, nakheis neka nakhei nqonqon ndø-eqatét.’” ");
INSERT INTO kvg_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yaq Yesu sègeziváz, neka Zelusalem taon vø̄-ivav. Yaq Betani vemiav-té genøwáv, ta lova ndøgo, vømø̄buv. ");
INSERT INTO kvg_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Khøuwa nøme qandopave, lovølova-ús, Yesu Zelusalem taon-te nqawa ge꞉vesezat, ndego ifi mbovín. ");
INSERT INTO kvg_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Yaq nakhoa keoqa-te ndøgo, ndego fig tae ndøqeív. Geté avønin-te gewav, nanga-qa gemøkewag, esokho mba ndøqeív. Tae nanga mbaín. Yaq Yesu até gendego, fig tae manqat vømbō-ein, “Qo tae nanga nqawa qóviamák.” Yaq ndaføyambá, ndøgo fig tae sègekusí. ");
INSERT INTO kvg_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yaq tegi paev ezoqam, nqanek matev giqeivim, ndigu nqova ndafe kandambá. Yaq gimbo-bevøpem, “Áv khanégo, nqanek fig tae nakhamas-te qakusi?” ");
INSERT INTO kvg_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yaq Yesu gezø-qavøiu, “No unimanqatín nqazø-manqate. Zo tozo-unimanqatintat neka nakeap mbain vozógoāt, zo kopømbaqapé, matev āv tøzøté-matønumát, av no fig tae qambøe-matanam. Geté ta-mbá taoká. Zo nqanek manqei pøyat tozombo-einim, av nqægo, ‘Mòqo-itān. Yaq ibøkha-tē qanøbāf,’ yaq matev segéfakhán. ");
INSERT INTO kvg_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Gekha matēv ndøgo, Mbumbukiam tozombo-viømemat, zo tozo-unimanqatintat, tozo-guligulimemat, yaq zo ndòzo-upøgimemát.” ");
INSERT INTO kvg_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu Mbumbukiam-qa khoev uta mokho-te nqawa ge-on, ezoqa vømē-zømesim, yaq Mbumbukiam-gi iziz ezoqa kandakanda neka Zu megetapak ndozáv, te-te, gimbo-einim, “Qo gekha ezoqam-qâ iz-tē qonǿgot, nandav matev nandoqo-matønumit? Iz gekha ezoqām qá-etoam?” ");
INSERT INTO kvg_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yaq Yesu gezø-qavøiu, “Até nó-a, bevap kopo nqanø̂gó, zo-te. Zo yaq tozonø-qavøinam, yaq até nó-a, ndæ̀zø-eín, av nqægo, no matev gekha ezoqam-qâ iz-tē qatø̄-matønumit. ");
INSERT INTO kvg_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Noqa bevap manqat nqánek: Gê, Zion, ndego ezoqam ibøkha iz gezø-etoumam, ndego iz gekha ezoqam-tē géndap? Mbumbukiam-tê, ó, manqei-qape ezoqam-tè?” Yaq ndigu ekeza mokho-mba gibond, “Áv khazí꞉-einīm? Tizimbo-einim av nqægo, ‘Ndego iz Mbumbukiam-tē gendāp,’ yaq ndego ni āv ginimbí-eín nqǽgo, ‘Av tægoat ndægo, yaq gekha zapâ, zo Zion unimanqatinteav qazogoam?’ ");
INSERT INTO kvg_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Geté tizimbo-einim av nqægo, ‘Zion, iz, manqei-qape ezoqam-tē gendāp,’ yaq nginik ezoqa bawan-qape, qaqa nígú. Zapa ndǿgo, ezoqa ewaqape āv gini-unimanqatinát nqǽgo: Zion, ndego Mbumbukiam-gé manqa vevezam ezoqám.” ");
INSERT INTO kvg_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yaq Yesu āv gimbøe-qavøinám nqǽgo, “Ni nìtinøtenák.” Yaq Yesu gezø-ein, “Av tægoat ndægo, yaq até nó-a, nøzǿ-einák, no gekha ezoqam-qā iz-tē qatø̄got, nqanek matev.” ");
INSERT INTO kvg_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Ge zô, nqanek emanqat-qa yaq-te, no ndakin tæzømbe-votot, áv khazømbøé-matøvemēm? Qàgoám. Ezoqam mø̀ndøgoám. Nakhei angana menás gimbogoam. Khøuwa nøme, eve, yo-khøuwa, āv gembøe-eín nqǽgo, ‘Ndáe. Nqægo khøuwa, khae-té qomǿsasáe.’ ");
INSERT INTO kvg_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Yaq gembo-qavøiu, ‘Tía. No gènømbo-qasí.’ Geté vaev-te, ndego matavap gè-enénd, sasa ndøwav, vømø̄sasae. ");
INSERT INTO kvg_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Yaq eve, até eveqase-té-a, vø̄wav, manqat kopo vømømbō-ein. Yaq ndego gendo-qavøiu. ‘Tát! Qanimáv. Ndæ̀náv.’ Geté ndego okhoeáv.” ");
INSERT INTO kvg_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yesu nqanek emanqat gumuvotot, yaq āv gezømbe-beváp nqǽgo, “Ge zô, ndozo-matavap? Nakhei menas ndigu, eve-qa manqat gekha ezoqām ndǿndap?” Gindu-qavøinam, “Ndégo, yo-khøuwa.” Yaq Yesu gezø-ein, “No unimanqatín nqazø-manqate. Matev soqøsoqa-us ezoqam, av teks moni upøgim ezoqam neka sakheis, ekeza kha giwiatun, ndigu zo ndø̀løvubám, neka Mbumbukiam-qa Megeat Matev-te vømó꞉-ōz. ");
INSERT INTO kvg_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Zapa ndǿgo, Zion gegeavun, neka zo ge꞉zømas, eqeieqei ande āv khazøté-yagāt, zo ndego unimanqatinteáv. Geté teks moni upøgim ezoqam neka sakheis ekeza kha giwiatun, ndigu mø̀ndø-unimanqatiním. Zo tiqa matev ambá qazøte-qeivím. Geté até ndøgó-a, zo qambuzaneáv neka Zion unimanqatinteáv.” ");
INSERT INTO kvg_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Nqanek yaya etæ manqat nøme, zøtéyogēm: Qàgoám. Ezoqam mø̀ndøgoám. Khae evé. Ndego waen khae ndøkhá, uta vø̄-ogi, neka waen nanga pesegim nonqo, manqei vø̄-oz, neka khae qeivi nonqo, khoev eqawat-qape vø̄wev. Yaq khae ndøgo, ezoqā nøme-qá zenda-té genøvé, timbøe-kewagat, ekezan manqei nøme-te vø̄wav. ");
INSERT INTO kvg_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Yaq waen nanga khata viav qamøkhanaz, ndego khae eve, sasae ezoqam ndøkhofotáz, ti-te ndigu, ma khae gimbøe-kewagam. Ekeza waen nanga upøgim-qa ndøgoám. ");
INSERT INTO kvg_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Geté ndigu khae keoge ezoqam, gègavém. Ezoqa nøme gèzuím, neka nøme vø̄laem; neka nøme nandí gini-pouwím, vø̄nanim. ");
INSERT INTO kvg_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Yaq ndego khae eve, sasae ezoqa nøme mba mo꞉khofotáz. Geté ndigu khae keoge ezoqam, matev āv tizømbe-matanám, av ezoqa nøme gizømbe-matanam. ");
INSERT INTO kvg_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Yaq vaev-te, ndego khae eve, ekeza yo ndøkhofotáv, ge-ein, ‘Ngenek nogé yó. Ndego ndø̀mbo-vizumém.’ ");
INSERT INTO kvg_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Geté ndigu khae keoge ezoqam, khae eve-ge yo gi-ometam, ekeza mokho-mba, āv gini-einím nqǽgo, ‘Ngenek khae eve-gé yó. Waen khae ngének genó-kawa-év. Zílaém. Yaq khae nqanek, ni zíndapém.’ ");
INSERT INTO kvg_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Yaq até gindigonem, gèmøvøinám, khae bavokho sasa ndø-ituim, pakhapakha vømømbō-khanøem.” ");
INSERT INTO kvg_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu nqanek yaya etæ manqat qamømbøe-navøem, yaq gezø-ein, “Ge zô, ndozo-matavap? Ndego khae eve tendowav, gekha matev zǿmatanām, ndigu khae gimbo-kewagam?” ");
INSERT INTO kvg_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yaq gindu-qavøinam, “Ndego, ndigu ezoqa soqøsoqa ndø̀zitág, vø̄pakhaez. Yaq khae ndøgo, keoge ezoqa vini-qá zenda-té genǿvé. Tiqá zenda-té tenǿvé ndígu, khata viav-te, tegi waen nanga timbo-etoumat.” ");
INSERT INTO kvg_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yaq Yesu gezø-ein, “Ge zô, Mbumbukiam-qa Manqat mozó-geveømem, av qæ-ein nqægo? ‘Nandi-qapi ndigu, khoev puanam ezoqam gisanqabem, ndigu mø̀ndømø-gigiap-qape-éz, khoev puanam nonqo. Nqanek matev, Evezøza ndømatanám. Ndøgo qanimav tantáv, niqa bøi-te.’ ");
INSERT INTO kvg_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yaq nakémbá, no nqazǿ-manqate: Mbumbukiam teqa Megeat Matev, zo-te nandøgo, gévibám. Yaq ezoqa ta bawan ndígu tezǿ-etoám, ti-te mokho eqeieqei ndøfakhate.” ");
INSERT INTO kvg_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Mbumbukiam-gi iziz ezoqa kandakanda neka Felisi ezoqam, nqanek yaya etæ manqat giyogem, ndigu sògo-matøvemém, ngenek ni me꞉manqatē. ");
INSERT INTO kvg_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Yaq ndigu ambá gimøvøinamɨ́n, ndimbula-te vø̄-utøvemɨn. Geté ndigu ezoqa bawan-qape-qá møe ndøgoném. Zapa ndǿgo, ezoqa ewaqape, Yesu Mbumbukiam-gé manqa vevezam ezoqam me꞉vewám. ");
INSERT INTO kvg_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu yaya gezø-etæam, nøme kopo nqánek. Gezø-ein, ");
INSERT INTO kvg_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Mbumbukiam-qa Megeat Matev kopømba ande av nqǽgo: Kawa ezoqam mø̀ndøgoám. Tege yo, sæva okɨ-qa ndøgoám. Yaq ndego kawa, lou kandambaqape ndøkhakheinám, ");
INSERT INTO kvg_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","neka tegi sasae ezoqam vø̄khofosam, ti-te ndigu, ibugukhokhof manqa gezø-khofotam, taqa yaq-te. Geté ndakin sasae ezoqam gizø-ein, av nqægo, yà betøndozāv, ndigu gèzømbo-qasí, tinduzav. ");
INSERT INTO kvg_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Yaq ndego kawa ezoqam, sasae ezoqā nøme ndøkhofosám, ti-te ndigu, ibugukhokhof manqa gezø-khofotam, gezø-ein, ‘Nandiv ezoqam gèmøzø-eín. Lou khakheitáp. No kao angana mbomømboma neka søvakha gigiap enaq-us mø̀ezitág, lou loge nonqo. Gigiap ate ndægo khakheitáp. Sà betøndozáv, nøkenøkem lou loge-te.’ ");
INSERT INTO kvg_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Geté ndigu ezoqam, ma gezømbe-akha, kawa ezoqam-qa manqat, gèsanqawém. Yaq ekeza poev matev møgoném. Ezoqa nøme, ekeza khae-té gemøsasáe, neka ezoqa nøme stoa-te vømø̄sasae. ");
INSERT INTO kvg_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Neka ezoqa nøme até gindigonem, ndigu kawa-gi sasae ezoqam sègegavém, vø̄zitag, pakhapakha sasa zøkhaneam. ");
INSERT INTO kvg_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yaq ndego kawa ezoqam, qaqa kandambá gego. Yaq até gendego, nakhag ezoqam ndøkhofotáz, ndigu ezoqam vømø̄zitag, pakhapakhá, ndigu tegi sasae ezoqam gizitag, neka tiqa vemiav vø̄sonqotøvem. ");
INSERT INTO kvg_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Yaq ndego kawa ezoqam, ekeza sasae ezoqam gezø-ein, ‘Noqa nøkenøkem lou khakheitáp. Geté ndigu, no qazø-akha, lou namba tizilog, ndigu ezoqa soqøsoqá. ");
INSERT INTO kvg_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Geté ndakin nakhoa-té søzøtú-okhoát. Yaq gekha ezoqām ndigu, tozo-zømetet, sègendo-khatobát, ndigu noqa nøkenøkem lou loge-te betøndōzav.’ ");
INSERT INTO kvg_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Yaq ndigu sasae ezoqam sège-panqaním. Yaq gekha ezoqām ndigu, nakhoa-te gizømetɨn, sègendo-khatobɨ́n. Ezoqa nøme ndigu, eqeieqeí, neka nøme ndigu, soqøsoqá. Yaq nøkenøkem khoev ndøgo, ùnime꞉-khazém. ");
INSERT INTO kvg_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Geté kawa ezoqam khoev-te ge-on, ezoqa gegevezo, ezoqa kopo mø̀ndu꞉goám ndøugu. Ndego nøkenøkem ndabua eqeieqei uzøpøteáv. ");
INSERT INTO kvg_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Yaq kawa ezoqam gembo-ein, ‘Nǿfu. Qo áv khoqotøndé-oq nqanek, nøkenøkem ndabua mbomømboma uzøpøteav ndoqogo.’ Geté ndego otevateáv, gekha manqat mbøé-eīn. ");
INSERT INTO kvg_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Yaq ndego kawa ezoqam até gendego, ekeza sasae ezoqam, āv gezømbe-eín nqǽgo, ‘Bov neka pingim zombó-løvønømém, neka bavokhó qazomǿ-oginám. Bøivun-té. Yaq té-eivumát ndǿgo, neka khaya vǿvivisumāt.’” ");
INSERT INTO kvg_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yaq Yesu nqanek yaya etæ manqat qamømbøe-navøem, gezø-ein, “Mbumbukiam ezoqa kopoáv gezø-akhayam. Geté ezoqa khapímbá gevevesam.” ");
INSERT INTO kvg_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yaq Felisi ezoqam gèpindám, matavap vømø̄gonem, av nqægo, Yesu beváp qazimbøé-matemateømém. ");
INSERT INTO kvg_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yaq Felisi ezoqam, ekeza paev ezoqam ndøkhofotáz, Yesu-te, ezoqa nøme namba, ndigu Elod-te ginøzaz. Yaq ndigu gimbo-einim, “Nøméndim ezoqam. Ni mø̀tinøtén, qo unimanqatin ezoqám. Qo ezoqam Mbumbukiam-qa poev-qa yaq-te ndoqote-zømesim, unimanqatin manqat mba qomanqaté. Qo møe mbaín, ezoqam-te. Geté qo manqat sòqo-manqaté, oskiá ndøgo, ezoqa kandakanda o ezoqa khasøkhasis. ");
INSERT INTO kvg_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Qonimbí-eīn. Qoqa matavap, áv khanégo? Kopømbâ, Siza-te teks moni tizi-abumat, ndego Lom kawa kandambaqape, ó, khafeâp?” ");
INSERT INTO kvg_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Geté Yesu tiqa matavap soqøsoqa é-møndøqeív, gezø-ein, “Zo khavozam ezoqam, gekha zapâ, no matemateam-qa ndozogo? ");
INSERT INTO kvg_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Moni mokho zøté-nømøndēm, ezoqam teks-te ndi-abam.” Yaq ndigu moni mokho gindu-ndøpøzem, vø̄e-ometem. ");
INSERT INTO kvg_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yaq Yesu gezø-ein, “Gê, gekha ezoqam-qâ bugug neka iz mó꞉go, nginik moni mokho-te?” ");
INSERT INTO kvg_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Yaq gindu-qavøinam, “Siza-qá bugúg, neka teqá íz mo꞉gó.” Yaq gezø-ein, “Av tægoat ndægo, Siza-qa gigiap, Siza zombó-etoumemát. Geté gigiāp ndøgo, Mbumbukiam-qa, Mbumbukiam zombó-etoumemát.” ");
INSERT INTO kvg_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ndigu teqa manqa qavøiwat giyogem, yaq ndigu nqova ndafe kandambá. Yaq sège-ivøvém, vø̄zav. ");
INSERT INTO kvg_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ta khøuwa kopo-te ndøgo, Sadusi ezoqam ndozáv, Yesu-te. Nginik Sadusi ezoqam, āv gini-unimanqatinát nqǽgo: Ezoqa tipakhaetat, ndigu nango gemǿ-khandi꞉zák, løvøte-te. Yaq ndigu Yesu bevap mbogoném, ");
INSERT INTO kvg_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","gimbo-einim, “Nøméndim ezoqam. Mozes āv gene-eín nqǽgo: Ezoqa tenanimat, yaq ndego nakheis mbaīn, yaq ngæmam ndugu te-ivavat, namba qawan ndǿ-okɨát, neka tege namba qawan, ndego genanim, patu bembøē-qatayat. ");
INSERT INTO kvg_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Qotøndé-ewāg, nqanek emanqat. Ni mokho-te, angana mø̀ndøgoám. Evenáp. Ate gi꞉goam sevén. Yaq khøuwa ndego, sævam ndø-okɨ́. Yaq gènaním. Zas sège-iváv. Nakheis mbaín. Yaq eveqase ndø-okɨ́, ngunuk ngæmam. ");
INSERT INTO kvg_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Yaq matev até kopó. Até ndegó-a, vø̄nanim. Nakheis mbaín. Yaq vaev até ndigú-a, emekheis, ndugu ngæmam kopo sège-kawawát, atema evenap seven ate gi꞉goam vømū-pakhaez. ");
INSERT INTO kvg_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Yaq vaev até sævám-a, vø̄nanim. ");
INSERT INTO kvg_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Gê, ezoqa unimanqatin løvøte-te tikhandi꞉z, yaq ta khøuwa-te ndøgo, timø-khandi꞉z, ngunuk sævam, gekha ezoqam-gû zas ndǿgoāt? Zapa ndǿgo, ndigu evenap ate gi꞉goam, ngunuk sævam kopo ndøkawawát.” ");
INSERT INTO kvg_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yaq Yesu gezø-qavøiu, “Zoqa matavap soqaín, zo ndozo-matavap av nqægo, ezoqa tipakhaetat, ndigu løvøte-te nango gemø̄-khandi꞉zāk. Zo Mbumbukiam-qa Manqat neká teqa bazaføgakh, zøtezateáv. ");
INSERT INTO kvg_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ezoqa løvøte-te nango timø-khandi꞉z, ndigu andé enzol ezoqam me mé꞉goát, ndigu yan-te ngo꞉yage. Nøkenøkem matev mbaín. ");
INSERT INTO kvg_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Geté løvøte-te toqo-khandi꞉q, taqa yaq-te, gê, zo mozó-geveømem, manqat ndøgo Mbumbukiam ge-ein? ");
INSERT INTO kvg_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ndego āv gene-eín nqǽgo, ‘No Eibleem-gé Mbumbukiám, neka Aezek-gé Mbumbukiám, neka Zekop-gé Mbumbukiám.’ Nqanek manqat ni āv qaninømánd nqǽgo: Ndigu ezoqam zua ndøkhandi꞉zát, Mbumbukiam namba. Zapa ndǿgo, Mbumbukiam ndego ambá av nqǣgo, løvøte ezoqam-gē Mbumbukiām, geté ndego khandi ezoqam-gé Mbumbukiám.” ");
INSERT INTO kvg_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yaq ezoqa ewaqape nqanek manqat giyogem, ndigu nqova ndafe kandambá, Yesu-qa nømendim matev-qa yaq-te. ");
INSERT INTO kvg_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Felisi ezoqam giyogem av nqægo, Yesu ndigu Sadusi ezoqam ùnime꞉-tokāz, yaq ndigu gèpindám, manqat vø̄-einim. ");
INSERT INTO kvg_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yaq tigi ezoqa kopo, ndego Mozes-qa guguna manqat otevat ezoqam gegoam, Yesu matemateam-qa mbogoám, gembobevap, ");
INSERT INTO kvg_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Nøméndim ezoqam. Mozes-qa guguna manqat mokho-te, matev uni kandambaqape-in ākhanégo?” ");
INSERT INTO kvg_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yaq Yesu gendo-qavøiu, “Matev kandambaqape nqánek: ‘Kuku yà betaqagó, Evezøza-te, ndego qoge Mbumbukiam, uni qoqa mbøni-te neka uni qoge nqova-te neka uni qoqa matavap-te.’ ");
INSERT INTO kvg_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Matev uni kandambaqape-in nqánek. Nqanek gò꞉megeát. ");
INSERT INTO kvg_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Geté até nqanék-a, kandambaqapé. ‘Ezoqa nøme-te, kuku āv tabetaqambe꞉gó, av qakeza kha-te kuku ndaqambe꞉go.’ ");
INSERT INTO kvg_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mozes-qa guguna manqat ate ndægo neka nømendim manqat ndøgo, Mbumbukiam-gi manqa vevezam ezoqam gipeaomem, nqanek matev menas-té qanø-vøgií.” ");
INSERT INTO kvg_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ndigu Felisi ezoqam, ate av-té giwaniapam, yaq Yesu tenøzø-beváp ndǿgo, gezø-ein, ");
INSERT INTO kvg_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Gê, zo ndozo-matavap? Mesaya ndego, Mbumbukiam tendo-khofotav, ndego gekha ezoqam-gê zeò?” Yaq gimbo-qavøinam, “Ndego Deivid-gé Zeó.” ");
INSERT INTO kvg_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yaq Yesu gezø-ein, “Av tægoat ndægo, yaq gekha zapâ, Deivid ndego Nqova Mbomambaqape-qa mokho-te, Evezøza gembo-akha? Manqat ndøgo, Deivid ge-ein, nqánek: ");
INSERT INTO kvg_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Evezøza Mbumbukiam, noge Evezøza, āv gembøe-eín nqǽgo, ‘Noqá nakeamo zenda-té qanøqóm. Até qóqotát, atema no qogi qaqa ezoqam, qoqa zenda tokhotapak mokho-te vøtaqambú-āb.’ ");
INSERT INTO kvg_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Gê, Deivid ndego Mesaya, Evezøza ndembo-akhayam, yaq ngenek Mesaya, áv kené-Deivid-ge-zeo-ev?” ");
INSERT INTO kvg_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yesu nqanek bevap manqat gezø-ein, ndigu Felisi ezoqam kopømba mbaín, gembó-qavøinām. Yaq ta khøuwa-qa zita-te, ezoqa møe ndøgoném, Yesu bevap nøme vømbøé-gonēm. ");
INSERT INTO kvg_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesu ekeza paev ezoqam neka ezoqa ewaqape gezø-ein, ");
INSERT INTO kvg_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Mozes-qa guguna manqat nømendim ezoqam neka Felisi ezoqam, Mozes-qá iziz ndøndapém, zo ndi꞉zømesim. ");
INSERT INTO kvg_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yaq nakémbá, zo tiqa manqat, o-mba zømbo-ndapé, neka matev ate ndægo vø̀gó, av ndizømbe-manqate! Geté tiqa matev mbòpa᷄ev. Zapa ndǿgo, matev ndøgo, ezoqa nøme ndi꞉zømesim, ndigu ekezan matønumáv. ");
INSERT INTO kvg_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ndigu ezoqam-qa nqanqa-te, viniv-qape mo꞉-aumatún. Yaq ezoqa amba-amba me꞉-eqagimatún. Geté ndigu zenda-qase aumáv, ezoqa vøzømbé-tøkeāt, ndigu nqanek viniv ndi-eqawat. ");
INSERT INTO kvg_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ndigu matev ate ndægo, ezoqa qeivi nonqo mba ndøgoatún. Mboges-qase ndøgo, Mbumbukiam-qa Manqat-qase ndøu-peawap, tiqa kawa-pap-te neka pingim-te giløvønumatun, kandakandá sege-khakheinumatún, neka ndabua gi-uzamɨn, gi loloákh segezǿ-følæpát. Yaq ezoqa iz tìabezømbe-eqawát. ");
INSERT INTO kvg_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ndigu tøzømbe-khaneát ndǿgo, lou loge kandakanda-te neka guliguli khoev-te, iz akhayapak-qá qonam nonqo-té gíqonumát, ");
INSERT INTO kvg_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","neka ezoqa ewaqape, maket manqei-te, ndigu khaiya mboma manqat vizap-us bezø̄-manqate, neka ‘nømendim ezoqam’ sasa bezø-akhayam. ");
INSERT INTO kvg_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Geté zo, ‘nømendim ezoqam’ bezø-akhàya᷄m. Zapa ndǿgo, zo nømendim ezoqa kopo zømbegó. Geté zo evenáp. Vinivinimba mbaín. ");
INSERT INTO kvg_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Neka zo ezoqa ‘Tat’ mbo-akhàya᷄m, nqanek manqei-qape-te. Zapa ndǿgo, zo tat kopo zømbegó. Ndégo, yan-te ngo꞉yage. ");
INSERT INTO kvg_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Neka zo ‘megeat ezoqam’ bezø-akhàya᷄m. Zapa ndǿgo, zo megeat ezoqam kopo zømbegó. Kelisó. ");
INSERT INTO kvg_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Gekha ezoqām kandambaqape ndego, zo mokho-te, ndego zogé sasae ezoqam begó. ");
INSERT INTO kvg_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Zapa ndǿgo, gekha ezoqām ndego, ekeza iz te-eqatat, teqa iz gévoatát. Neka gekha ezoqām ndego, ekeza iz tevoatat, teqa iz gó꞉-eqatát.” ");
INSERT INTO kvg_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Zo mòzo-soqoéz, zo Mozes-qa guguna manqat nømendim ezoqam neka zo Felisi ezoqam. Zo khavozam ezoqám. Zo mboqog, zòto-tokøvém, Mbumbukiam-qa Megeat Matev-te, ezoqa vǿe-ōz. Zo zøkezan onimáv. Neka ezoqam ndigu, onim-qa ndigu, zo zòzømbe-khafeáp. ");
INSERT INTO kvg_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Zo mòzo-soqoéz, Mozes-qa guguna manqat nømendim ezoqam, neka zo Felisi ezoqam. Zo khavozam ezoqám. Zo qamba-qambá ndozo-okho neka ndozo-ane, ezoqa kopo-qa ndozovawe, zo tezøpaev. Yaq ndego zo tezøpaev, zo manqa-zapa-te nøme mba zotóveém, āv taoká, av zo zøkezan ndøzøte꞉go. Yaq até ndegó-a, gøinam-té gemǿwáv, zo namba. ");
INSERT INTO kvg_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Zo mòzo-soqoéz. Zo bøi waev mbain ezoqam, ituza-qa zogó. Geté até zó-a, bøi waev mbaín. Zo āv qazøte-manqaté nqǽgo, ‘Ezoqa Mbumbukiam-qa khoev-qa iz-te, manqa mbusa teve, gete manqa mbusa geawateav tøgoat, ndøgo kopømbá. Mbumbukiam te-te ndego yaq-fia gétayák. Geté ezoqa gol-qa iz-te, ndøgo Mbumbukiam-qa khoev-te ndøuve, manqa mbusa teve, yaq ndego manqa mbusa até begeawát.’ ");
INSERT INTO kvg_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ge zô, matavap neka bøi waev mbain ezoqam, gigiap kandambaqape ākhanégo? Gôl, ó, Mbumbukiam-qâ khòev? Gol, ndøgo khokhó. Geté Mbumbukiam-qa khoev-te qamø-oeɨn, ndǿgo tøme-gigiap-qape-ɨ́n, vømø̄-Mbumbukiam-qa-gigiap-ɨn. ");
INSERT INTO kvg_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Neka zo nøme, āv qazøte-manqaté nqǽgo, ‘Ezoqa lou-qase-qa iz-te, manqa mbusa teve, ndøgo Mbumbukiam-te søvakha gigiap ndiløvutam, gete manqa mbusa geawateav tøgoat, ndøgo kopømbá. Mbumbukiam te-te ndego yaq-fia gétayák. Geté ezoqa søvakha gigiap-qa iz-te, manqa mbusa teve, ndøgo lou-qase-te to꞉ve, yaq ndego manqa mbusa até begeawát.’ ");
INSERT INTO kvg_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Zo bøi waev mbain ezoqam, gê, gigiap kandambaqape ākhanégo? Ndǿgò, søvakha gigiâp, o ndǿgò, søvakha løvutam nonqo, Mbumbukiam-qa khoev-te ndøugu? Søvakha gigiap ndøgo, khokhó. Geté sa ndǿgo, tøme-gigiap-qape-ɨ́n, søvakha løvutam nonqo toqomo꞉ve, vømø̄-Mbumbukiam-qa-gigiap-ɨn. ");
INSERT INTO kvg_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yaq nakémbá. Gekha ezoqām ndego, søvakha gigiap løvutam nonqo-qa iz-te, manqa mbusa teve, ndego manqa mbusa, gigiap menas-qá iz-té genǿvé, søvakha løvutam nonqo neka gigiap ate ndægo, ndøgo ndo꞉ve. ");
INSERT INTO kvg_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Neka gekha ezoqām ndego, Mbumbukiam-qa khoev-qa iz-te, manqa mbusa teve, ndego até Mbumbukiam-qá iz-té-a, vǿvē. Zapa ndǿgo, Mbumbukiam ndǿgo teyagé. ");
INSERT INTO kvg_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Neka gekha ezoqām ndego, yan-qa iz-te, manqa mbusa teve, ndego Mbumbukiam-qá qonam nonqo-qá iz-té genǿvé. Zapa ndǿgo, yan ndøgo, Mbumbukiam-qá qonam nonqó. Neka ndego, manqa mbusa, até Mbumbukiam-qá iz-té-a, vǿvē. ");
INSERT INTO kvg_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Zo mòzo-soqoéz, Mozes-qa guguna manqat nømendim ezoqam neka Felisi ezoqam. Zo khavozam ezoqám. Zo até avøe gigiap uni khasøkhasis-ín-a, qazøtøndo-pe꞉tatun, zòqaqaemɨ́n, qaqageap vømø̄-ten-ɨn, yaq qatoat kopo, Mbumbukiam vozombō-etøomemɨn. Matev khasøkhasis av nqægo, zo mòzogoatún. Geté matev kandakanda, Mbumbukiam-qa guguna manqat-te nqapeawap, zòsanqawatún, kopømba ande av ezoqa nøme-te, matev eqeieqei matanam matev, neka tanakh matev, neka unimanqatin matev. Matev eqeieqei khasøkhasis tozogoat, ndøgo kopømbá. Geté gigiap-qape ndǿgo, matev eqeieqei kandakanda tozogoat. ");
INSERT INTO kvg_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Zo bøi waev mbain ezoqam, ituza-qa zøgó. Geté até zó-a, bøi waev mbaín. Zo yaf-te, piopam zoqombinamɨ́n. Geté kemol-qapu ndu꞉vøete, zo sòzo-khoutøve꞉mɨ́n. ");
INSERT INTO kvg_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Zo mòzo-soqoéz, Mozes-qa guguna manqat nømendim ezoqam neka Felisi ezoqam. Zo khavozam ezoqám. Zo kap neka melek, mumat mba zoto-sunguzumatún. Geté mokho-te ndøugu, khavim-ús. Ta kap neka melek ndøgo, zó. Zoqa mokho-te, gigiap qovet møqæ neka zøkeza kha mba qeivi matev zømbu꞉gú. ");
INSERT INTO kvg_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Zo Felisi ezoqam, zo bøi waev mbaín. Bugukhokhof, mokho-té qazonǿ-sunguzám. Yaq até bavokhó-a, segébæbǽs. ");
INSERT INTO kvg_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Zo mòzo-soqoéz, Mozes-qa guguna manqat nømendim ezoqam neka Felisi ezoqam. Zo khavozam ezoqám. Zo andé manqei-pakha ozáp. Bavokho ndo꞉go, khakheitáp neka busøgeáp neka voqoát. Geté mokho-te ndøugu, bazag neka peakha vøvanq mba mu꞉gú. ");
INSERT INTO kvg_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Zo até kopó. Bavokho nandozo-keoge, bugug eqeieqeí. Geté zoqa mokho-te nandøugu, khavozam neka manqa-zapazapá qazømbe-tøtøvøyám. ");
INSERT INTO kvg_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Zo mòzo-soqoéz, Mozes-qa guguna manqat nømendim ezoqam neka Felisi ezoqam. Zo khavozam ezoqám. Zo Mbumbukiam-gi manqa vevezam ezoqam neka gekha ezoqa eqeieqei nøme, ibugukhokhof giyageapam, khoev qaniqanimav zozø-puanumatún, tiqa manqei-pakha-te, neka vozozø̄-fegatun. ");
INSERT INTO kvg_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Neka zo āv qazøte-manqatatún nqǽgo, ‘Ni amba nigi atanakha-zapazapa-za-qa khøuwa-te tizi-yageɨn, ni ndigu ambá nizǿ-tøkeák, ndigu Mbumbukiam-gi manqa vevezam ezoqam gizitagat.’ ");
INSERT INTO kvg_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Zo av ndøzøte-manqate, yaq zo āv qazøte-vøndæmét nqǽgo, zo tigí zí, ndigu Mbumbukiam-gi manqa vevezam ezoqam gizitagat. ");
INSERT INTO kvg_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ság. Vø̀-apét. Nandav matev, ùnime꞉-khouím, av zogi atanakha-zapazapa-za gi꞉matønumam. ");
INSERT INTO kvg_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Zo waza soqøsoqa. Ge zô ndozo-matavap, gøina wageap-qa møe, áv khazømbøé-khokhōz? ");
INSERT INTO kvg_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nqáe! No Mbumbukiam-gi manqa vevezam ezoqam neka matavap loloakh ezoqam neka nømendim ezoqam notøndó-khofosumát, zo-te. Geté zo ndigu ezoqa nøme, pakhapakha zozǿ-khanæmát, neka nøme tae mutui-te vozó-tøkebumāt, neka nøme Zu ezoqam-qa guliguli khoev-te vozó-febumāt, neka vemiav nøme-te atema vemiav nøme-te vozó-ngeasumāt. ");
INSERT INTO kvg_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yaq nakémbá, ezoqa eqeieqei ate ndi꞉gu, pakhapakha gizø-khanæmam, Eibol gilaem, qamat, atema zo Zekalaya, Belekia-ge yo, pakhapakha qazombo-khanøem, yaq Mbumbukiam-qa khoev-a, yaq søvakha gigiap løvusam nonqo lou-qase-te, taqa yaq-fia nqosøgeap zo-té qanǿ-nqeivøém. ");
INSERT INTO kvg_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","No unimanqatín nqazø-manqate: Nqanek yaq-fia nqosøgeap ate nqægo, zo-té qanǿ-nqeivøém, zo ndakin nqazoyage.” ");
INSERT INTO kvg_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yaq Yesu manqat nøme ge-ein, “Zelusalem, Zelusalem, zo Mbumbukiam-gi manqa vevezam ezoqam, pakhapakha ndozozø-khaneam, neka nandī ndø̄zø̄tē-zītø̄gē, ndigu Mbumbukiam zo-te ndendo-khofosam, no khøuwa kopoáv, baqa amba nøte-eqagimám zo-te, kopømba ande av kokolok evo nduigu, nakheis gukhatobɨn, ekeza taf mokho-te vø̄-ozɨn. Geté zo gèzømbo-qasi꞉vám. ");
INSERT INTO kvg_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nqáe! Zoqa khoev nqanek, gésoqá. Ezoqam mbaín, segégoát. ");
INSERT INTO kvg_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","No nqazǿ-manqate: Zo no nango naqanøká zónømendamák. Geté ta khøuwa-te ndǿgo, sa tøzøté-nømendám, zo tozo-einim, av nqægo, ‘Mbumbukiam ngenek ezoqam bèkhakheinøvém, Evezøza-qa iz-te ngegeav!’” ");
INSERT INTO kvg_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu Mbumbukiam-qa khoev ge-ivav, nakhoa gegeveat, yaq ekeza paev ezoqam tinduzáv ndǿgo, gimbo-einim, “Qotéqeīv. Khoev mbomømbomá ndøpuate, Mbumbukiam-qa khoev uta mokho-te.” ");
INSERT INTO kvg_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yaq Yesu gezø-ein, “No unimanqatín nqazø-manqate. Khoev ate ndægo, ndozoqeivi, manqei-té qamǿ-khakhandám. Nandi kopo nøme, nandi nøme-te, gó꞉zaveák.” ");
INSERT INTO kvg_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Taqa zita-te, Yesu Oliv manqei poyat-té genøwáv, vømø̄qom. Tegi paev ezoqam mba ndøgoám, te namba. Yaq āv gimbøe-bevøpém nqǽgo, “Qonimbí-eīn. Matev nandav qoqote-manqatam, gekha khøuwā qanéfakhān? Neka andé gekha matev me nitíqeivīm, ni tøtinøten, av nqægo, qo qotøndō-qavāq neka nqanek manqei-qape gemø̄-navøēm?” ");
INSERT INTO kvg_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yaq Yesu gezø-qavøiu, “Aiyá qagó. Zo ezoqa betùba᷄m. ");
INSERT INTO kvg_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ezoqa kopoáv, noqá iz-té gindú-okhoát. Ndigu ezoqa āv gizømbé-manqatát nqǽgo, ‘No Kelisó’, neka ezoqa kandambá titubumat. ");
INSERT INTO kvg_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Zo nakhag-qa yaq-te tozo-ewagat neka nakhag u vozó-ewagāt, zo møe ndø̀go᷄. Matev av nqægo, ndø̀khæ-fakhanám. Geté manqei-qape-qa vaev zuá. ");
INSERT INTO kvg_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Manqei nøme, manqei nøme namba, nakhag ndǿgoát, neka kawa ezoqa nøme-qa bawan, kawa ezoqa nøme-qa bawan namba, vǿnøfeapāt. Manqei nøme-te, lou mbaimbai zǿwagát, neka manqei nøme-te, manqei vǿkukuvøemāt. Manqei vinivinimbá. Kopoáv. ");
INSERT INTO kvg_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Geté nqanek matev ate ndægo, ngazu mbá. Ndøgo kopømba ande av-té, sævam tui-ova, nqosøgeap ande tuikhantav. ");
INSERT INTO kvg_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Zo ndø̀gavemát neka vǿngiæzotāt, løvøte-te sasa ndǿ-abumāt. Manqei-manqei ate ndægo, zo gezǿ-sanqawupát, no zapaya. ");
INSERT INTO kvg_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ta khøuwa-te ndøgo ezoqa kopoáv, tiqa unimanqatin no-te segemǿ-ivøvemát. Ndigu yaqyaq-a gésanqambupát neka qaqa ezoqam-qa zenda-te izuizu vǿ-ambumāt. ");
INSERT INTO kvg_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Yaq khavozam manqa vevezam ezoqam ndǿfakhanám, kopoáv, ezoqa kopoav vǿtubām. ");
INSERT INTO kvg_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Yaq matev soqøsoqa sa tønǿ-khouwevtét. Yaq ta zapaya ndøgo, ezoqa kopoáv, tiqa kuku matev segezǿ-navøém. ");
INSERT INTO kvg_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Geté gekha ezoqām ndego, bazaføgakh-us teyat, atema vaev-te, ndego ndø̀mø-khandí꞉v. ");
INSERT INTO kvg_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Manqat Mbomambaqape, Mbumbukiam-qa Megeat Matev-qa yaq-te, ezoqa sugumú-zømesimít, manqei-qape ate nqægo. Bawan vinivinimba ate ndægo, sugumú-ewagét. Manqei-qape-qa vaev, khæ ndǿfakhán.” ");
INSERT INTO kvg_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Zo gigiap soqaqape zóqeivím, ndøgo Deniel, ndego Mbumbukiam-ge manqa vevezam ezoqam, ge꞉manqatam. Mbumbukiam-qá khoev-té qanú-wuøyát. Geté khafeap kandambá, gigiap av nqægo tøu-wuøyat ndøugu. (Gekha ezoqām ndego, nqanek manqat tegeveam, mokho bèmboqeív.) ");
INSERT INTO kvg_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Zo nqanek gigiap tozoqeivim, yaq gekha ezoqām ndigu, Zudia plovins-te tiyagat, manqei popotap-té giabenø-khokhóz. ");
INSERT INTO kvg_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Gekha ezoqām ndego, khoev ova to꞉yat, ndego khoev mokho-te bè-o᷄n, gigiap vømøndó-upøgīm. ");
INSERT INTO kvg_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Neka gekha ezoqām ndigu, khae-te tisasaetet, ndigu ndabua upøgim-qa bevèse᷄z. ");
INSERT INTO kvg_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ta khøuwa-te ndøgo, ti-te ndigu unimé꞉-soqá, sakheis emu-us ndigu neka nakhei tete ndizøloge. ");
INSERT INTO kvg_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mbumbukiam zombó-vi꞉mát. Nqanek matev, qozaq viav-te o Sabat khøuwa-te, befàkha᷄n. ");
INSERT INTO kvg_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Viniv ndøgo, ta khøuwa-te tøfakhan, føgakh-mbá tantáv. Mbumbukiam manqei-qape ande ge꞉khakheinam, atema ndakin, matev føgakh-qape fakhaneáv, av ta khøuwa-te ndøgo tæfakhan. Yaq até taqa zita-té-a, matev føgakh-qape av nqægo, nango gemǿ-fakhanák. ");
INSERT INTO kvg_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Geté Mbumbukiam matavap é-møndo꞉vé, av nqægo, khøuwa ndø̀-tokhopogeaqasí꞉z. Mbain tøgonɨn, yaq ezoqa kopo ambá gemǿ-khandi꞉vák. Mbumbukiam, khøuwa, ti zapaya ndígu tené-tokhopogeaqasí꞉z, ndigu ekezan gevevesam. ");
INSERT INTO kvg_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ta khøuwa-te ndøgo, ezoqa tezø-ein, av nqægo, ‘Ngé! Keliso ngének,’ ó, ‘Ndé. Keliso ndégo,’ yaq zo ndø-unimanqatìni᷄m. ");
INSERT INTO kvg_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Zapa ndǿgo, khokho Keliso neka khokho Mbumbukiam-gi manqa vevezam ezoqam ndø̀fakhanám. Ndigu matev kandakanda neka umingiap matev ndǿmatønumát. Yaq kopømba tøgønɨn, até ndigú-a, Mbumbukiam ekezan gevevesam, ambá ndætubám. ");
INSERT INTO kvg_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ndakin zo mø̀zøte-zøtéz. Mø̀ezø-eín, matev av nqægo, ndø̀mø-fakhanám. ");
INSERT INTO kvg_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Yaq nakémbá, ezoqa zo tizø-manqatat, av nqægo, ‘Ndǽ! Ndego ndendóya, leg-av manqei-te,’ yaq zo ndøgo ndø̀za᷄v. O tizø-manqatat, av nqægo, ‘Ndǽ! Ndego ndendópewe,’ zo ndøgo ndø-unimanqatìni᷄m. ");
INSERT INTO kvg_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Zapa ndǿgo, Ezoqam-ge Yo tegeav, nakhamas-té gendó-fakhán. Andé ndand mé꞉vøiyám, ndøgo khaiya ate ndægo sa tumukhazet, khøuwa vøndē-fakhanɨn-a, vømē-sinanɨn. ");
INSERT INTO kvg_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Søvakha pikia ande āv kenéveāt, koe ndǿgo tinø-piaɨ́n.” ");
INSERT INTO kvg_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Matev føgøføgakh khøuwa timi-nasinim, yaq nqova mbaín, khøuwa waev segembó-navøém, neka løvøyak beawap mbaín, neka nduku yan-te ngo꞉go vøndó-o꞉āz, neka gigiap føgøføgakh, yan-te nqo꞉go, vǿkukuvøēm. ");
INSERT INTO kvg_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Yaq yan-te nqo꞉go, Ezoqam-gé Yo-qá khakhatap ndó꞉fakhán. Yaq bawabawan ate nqægo, manqei-qape-te nqago, mbøni zømbǿvá neka vǿ-eivām. Yaq Ezoqam-gé Yo ndǿ-ometám. Khaiya ozoz-té genǿgeáv. Bazaføgakh-ús neka waev-qape-ús. ");
INSERT INTO kvg_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Yaq kipi ndǿwáv. Wag gembøé-eqavét. Yaq ndego ekeza enzol ezoqam ndókhofosám, manqei-qape ate nqægo, khøuwa vøndē-fakhanɨn-a, vømē-sinanɨn, neka sanqa-sanqa vømbō-anam. Yaq gekha ezoqām ndigu, Mbumbukiam gevevesam, manqei-qape ande āv khandēvavet, enzol ezoqam gémøváb.” ");
INSERT INTO kvg_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Zo fig tae-té qazøté-zøtéz. Tang-te mbusa tøfakhanam, esokho vǿqabām, yaq zo mø̀zøte-zøtezɨ́n, wavam khøuwa avønín. ");
INSERT INTO kvg_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Yaq matev até kopó. Zo nqanek matev ate ndægo tozo-qeivimat, no qate-manqatavun, yaq zo søzøté-zøtéz, Ezoqam-ge Yo, avønín gendóqaván. ");
INSERT INTO kvg_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","No unimanqatín nqazø-manqate. Ezoqa nøme, ndakin ngiyage naqanøká gépakhaezák. Até géyagát, atema ta khøuwa-te ndøgo, nqanek matev ate ndægo vømú-fakhanām. ");
INSERT INTO kvg_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yan neka manqei-qape ndø̀mø-navøém. Geté noqa manqat gemǿ-navøemák.” ");
INSERT INTO kvg_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Ezoqa mè꞉zøtezák, nqanek matev gekha khøuwa-tē neka khøuwa iz-tē qanéfakhān. Até enzol ezoqám-a, yan-te ngo꞉yage, neka até Yó-a, zøtezateáv. Geté Eve yakhapús sege꞉-otév. ");
INSERT INTO kvg_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ezoqam-ge Yo-qa qavøne khøuwa āv tønégoát, av Noa-qa khøuwa-te qægoam. ");
INSERT INTO kvg_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ta khøuwa-te ndøgo, khøuwat-qape fakhaneav qagoam, ezoqa lou loge zøgoupám, neka izam vøzø̄-goupam, neka sakhei vø̄zøkɨmam-a, vø̄-etoumam, até gemát, atema Noa khagua-qape-te vø̄u-on. ");
INSERT INTO kvg_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ndigu mè꞉zøtezák, ande gekha matev me ndǿfakhān ti-te, atema vøndō-khouwa, vø̄ngiæzo. Yaq Ezoqam-ge Yo tendoqavan, matev até kopó, āv tønéfakhán. ");
INSERT INTO kvg_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ta khøuwa-te ndøgo, ezoqa menas khae-te tisasaetet, nøme ndego, Mbumbukiam ndø̀ndáf. Geté nøme ndego, segé-iváv. ");
INSERT INTO kvg_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Neka sakhei menas, flawa timivisumit, nømu ndugu, Mbumbukiam ndø̀ndáf. Geté nømu ndugu, segé-iváv. ");
INSERT INTO kvg_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Yaq nakémbá. Gò꞉feazoát. Zapa ndǿgo, zo khøuwa neka khøuwa iz zø̀tezøtezák, zoge Evezøza te꞉fakhan. ");
INSERT INTO kvg_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Gèmbo-mataváp: Khoev eve amba te꞉-otevɨn, av nqægo, ande gekha khøuwa iz-te, aqonam ezoqam tendowav, yaq ndego ambá gé꞉buvák. Geté ambá sege-tiawatɨ́n. Yaq ndego aqonam ezoqam ambá gembótakák, khoev sa tembo-nqawaɨn. ");
INSERT INTO kvg_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yaq nakémbá. Até zó-a, zo vò꞉khakheinám. Zapa ndǿgo, Ezoqam-ge Yo, ta khøuwa-te ndǿgo tendéqaván, zo matavapøteav tøgoat, ndego tendoqavan.” ");
INSERT INTO kvg_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Gekha sasae ezoqâm, ndego eqeieqei neka matavap loloakh-us? Sasae ezoqam eqeieqei neka matavap loloakh-us av ngé꞉go. Tege kawa ezoqam, manqei nøme-te tewav, yaq ndego sasae ezoqam, keoge ezoqam teve, teqa khoev teqeivat neka tegi sasae ezoqa nøme, khøuwa eqeieqei-te lou vøzǿ-etoumāt, ");
INSERT INTO kvg_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","yaq vaev-te nqawa tendoqavan, teqeiv av nqægo, ndego sasae eqeieqei ndøgōt, ndego sasae ezoqam kopømbá, khanakhanákh. ");
INSERT INTO kvg_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","No unimanqatín nqazø-manqate. Ndego kawa ezoqam gigiap ate ndømbøego, keoge ezoqam ndégo tévé, ngenek sasae ezoqam. ");
INSERT INTO kvg_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Geté ndego sasae ezoqam, soqaqape tegoat neka av te꞉matavupat nqægo, noge kawa ezoqam nakhamas-te gendō-qavanāk, ");
INSERT INTO kvg_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","yaq ndego tegi sasae kopømba ezoqam kha zǿkhanæmāt, neka lou vǿlogāt neka ibøkha soqa vǿ-izumāt, ezoqa nøme namba, ndigu oskia gi-izumatun, ");
INSERT INTO kvg_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","yaq tege kawa ezoqam ta khøuwa-te ndǿgo tendéqaván, ndego sasae ezoqam khakheinøpøteav tøgoat neka otevateav vǿgoāt, ndego tefakhan. ");
INSERT INTO kvg_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Yaq kawa ezoqam, ndego sasae ezoqam, yaq-fia nqosøgeap mbó-etoám. Yaq-fia kandambá teta, te-te ndego. Yaq ndǿgo tenǿ-khofotáv, ma khavozam ezoqa nøme ndi꞉gu. Yaq té-eivumát ndǿgo, neka khaya vǿvivisumāt.” ");
INSERT INTO kvg_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Ta khøuwa-te ndøgo, Mbumbukiam-qa Megeat Matev, ande āv qanégoát nqǽgo: Mbasønakheis mø̀ndøgoám. Tén ate gi꞉goam. Ezoqam, sævam te-okɨ, qatøzu-qa ndøgoám. Lampá namba me꞉záv. ");
INSERT INTO kvg_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Faev nøme ndigu, matavap loloakh-ús. Geté faev nøme ndigu, matavap loloakh mbaín. ");
INSERT INTO kvg_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ndigu matavap loloakh mbain mbasønakheis, oil nøme upøgipøteáv, lampa-te qouzam nonqo. ");
INSERT INTO kvg_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Geté ndigu matavap loloakh-us, oil nøme mø̀ndø-upøgím. ");
INSERT INTO kvg_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Yaq ndego ezoqam, sævam te-okɨ, yakha mø̀ndævá. Yaq ndigu mbasønakheis, venanqei zøvín, vø̄føyam, venanqei sasa ndøsømbiam. ");
INSERT INTO kvg_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Yaq qamø-umba ndøgo, ezoqa tìndi-akhaém, ‘Ezoqam sævam te-okɨ, ngégeav! Mòzotøndozáv. Zimbøé-qatøzém.’ ");
INSERT INTO kvg_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Yaq ndigu mbasønakheis ten ate gi꞉goam, sùgumusúz, tiqa lampa waev vø̄-khouwe-khouwevam. ");
INSERT INTO kvg_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Yaq ndigu matavap loloakh mbain mbasønakheis, matavap loloakh mbasønakheis gizø-ein, ‘Ni oil zoní-etoám, zoqa nanda. Niqa lampa avønín gékhouvøém.’ ");
INSERT INTO kvg_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Yaq matavap loloakh mbasønakheis gindu-qavøinam, ‘Nakhoa mbaín. Oil nqanek nqanigu, kopømba mbaín, zo vøizǿ-etoām neka ni nikeza nonqo. Geté oil wi ezoqam-té qanøzáv, nøme vømø̄wi.’ ");
INSERT INTO kvg_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Yaq ndigu vø̄zav. Geté gi-ivøvem, ndego ezoqam sævam te-okɨ, tènefakhán. Yaq mbasønakheis faev ndigu, go꞉khakheinam, namba me꞉záv ndego, neka nøkenøkem lou loge-te vømø̄-oz. Yaq mboqog keoge ezoqam, até gindigonem, mboqog vø̄tokøzem. ");
INSERT INTO kvg_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Yaq vaev até ndigú-a, matavap loloakh mbain mbasønakheis, vø̄fakhaz. Gi-akhaem, ‘Khanánqa. Khanánqa. Mboqog qoní-mboqozó!’ ");
INSERT INTO kvg_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Geté yaq ndego sævam te-okɨ, gezø-qavøiu, ‘Āv taoká. No nø̀tenøtenák zo.’” ");
INSERT INTO kvg_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yaq Yesu nqanek yaya etæ manqat qamømbøe-navøem, gezø-ein, “Yaq nakémbá. Gò꞉feazoát. Zapa ndǿgo, zo khøuwa neka khøuwa iz zø̀tezøtezák, Ezoqam-ge Yo te꞉fakhan.” ");
INSERT INTO kvg_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yaq Yesu yaya etæ manqat nøme ge꞉zømas, gezø-ein, “Mbumbukiam-qa Megeat Matev, ande āv qanégoát nqǽgo: Ezoqam mø̀ndøgoám. Manqei nøme-te okho-qa ndøgoám. Yaq ndego ekeza gigiap, sasae ezoqam-qá zenda-té genø-awám, timbøe-qeivat. ");
INSERT INTO kvg_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Sasae ezoqa nøme, moni pus fáev gembo-etoam. Nøme ndego, menás. Neka nøme ndego, kopó. Moni ndego gezø-etoumat, ndǿgo tø-einín, tiqa matev eqeieqei neka zøtezat, ande āv khazømbēgo. Yaq ndego até gendego, vø̄wav. ");
INSERT INTO kvg_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yaq ndego ezoqam, moni pus faev ge-upøzo, gème-sasáe, moni pus faev nøme vø̄qas. ");
INSERT INTO kvg_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Yaq até ndegó-a, moni pus menas ge-upøzo, nøme menas vø̄qas. ");
INSERT INTO kvg_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Geté ndego ezoqa nøme, moni pus kopo gendapaz, manqei mba ndø-óz, tege kawa ezoqam-gi moni vø̄khonab. ");
INSERT INTO kvg_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Yaq møi-mbá sege-awám, tige kawa ezoqam nqawa tēāndō-qāvān. Yaq gezøbevap, ‘Nginik nogi moni, áv khazømbøé-matønumam?’ ");
INSERT INTO kvg_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yaq ndego sasae ezoqam, moni pus faev ge-upøzo, faev nømé namba sùgumu-upøzotavún, neka moni ate gi꞉goam, kawa ezoqam vømbō-etoam, gembo-ein, ‘Káwa ezoqam. Qotézømēt. Moni pus faev ndigu, noqa zenda-te qoqo-ab, no moni pus faev nøme nøteqás. Moni ate ndi꞉gu, ngínik.’ ");
INSERT INTO kvg_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Yaq ndego kawa ezoqam gendo-ein, ‘Mbomambaqapé. No khanakhanákh. Qo sasae ezoqam qanimáv. Gigiap-qase ndøgo, qoqa zenda-te qæve, qo eqeieqei qombo-kewagám. No gigiap nøme mba nøtaqambó-etoám, toqombo-kewagat. Vø̀ndo-óq. Khanakhanakh zígoném, no namba.’ ");
INSERT INTO kvg_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Yaq até kopó, ndegó-a, sasae ezoqam, moni pus menas ge-upøzo. Kawa ezoqam-te gewav, āv gembøe-eín nqǽgo, ‘Káwa ezoqam. Qotézømēt. Moni pus menas ndigu, noqa zenda-te qoqo-ab, no moni pus menas nøme nøteqás. Moni ate ndi꞉gu, ngínik.’ ");
INSERT INTO kvg_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Yaq ndego kawa ezoqam gembo-ein, ‘Mbomambaqapé. No khanakhanákh. Qo sasae ezoqam qanimáv. Gigiap-qase ndøgo, qoqa zenda-te qæve, qo eqeieqei qombo-kewagám. No gigiap nøme mba nøtaqambó-etoám, toqombo-kewagat. Vø̀ndo-óq. Khanakhanakh zígoném, no namba.’ ");
INSERT INTO kvg_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Yaq até ndegó-a, ndego moni pus kopo gendapaz, vøndō-on. Yaq ndego kawa ezoqam āv gembøe-eín nqǽgo, ‘Káwa ezoqam. No mø̀tenøtén, qo matev føgakh-qape ezoqám. Qo gigiap sòqo-peaɨ́n. Geté khae sasae kandakanda, ezoqá nøme qagoatún. Qo toqopewát ndǿgo, qo qakezan ogekhæmav ndoqogo. ");
INSERT INTO kvg_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yaq nakémbá. No møe nogoám. Yaq no qogi moni nòkhonáb. Manqei-té qæmø-otáz. Yaq ndakin qogi moni ngínik.’ ");
INSERT INTO kvg_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Yaq ndego kawa ezoqam gendo-ein, ‘Qo sasae ezoqam soqaín neka wau-qapé. Qo ndoqo-matavap, no ezoqa matev føgakh-qape, no avøe gigiap qæpe꞉tatun, no nøkeza ogekhæmav ndøgo, ");
INSERT INTO kvg_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","yaq qo moni, ambá moni nqeisam nonqo-té qomø-utazɨ́n. Yaq no ndakin qatøndo-qavan, ndigu moni elavøqase, bèkhouwezɨ́n, tæ-upøzoɨn.’ ");
INSERT INTO kvg_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Yaq ndego kawa ezoqam ge-ein, ‘Moni pus kopo, vø̀e-viomém. Yaq ndégo tozombó-etøomém, ndego moni pus ten ndimbogo. ");
INSERT INTO kvg_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Zapa ndǿgo, gekha ezoqām ndego, gigiap ndømbogo neka eqeieqei vømbó-kewagāt, no nøme mba nømbøé-etoám. Geté ndego, gigiap eqeieqei keogeav tøgoat, até ndøgó-a, gigiap-qase ndømbogo, nøtéviwám. ");
INSERT INTO kvg_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ngenek wau ezoqam, bavokhó qazonǿ-oginám. Bøivun-té. Yaq té-eivumát ndǿgo, neka khaya vǿvivisumāt.’” ");
INSERT INTO kvg_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Ezoqam-ge Yo tegeav, ndego kawa ezoqam ndǿgeáv. Bazaføgakh-ús neka waev-ús. Ndego ekeza enzol ezoqam ate ti꞉goat namba mé꞉geáv. Yaq ekeza kawa qonam nonqo qanimav-qape-té gonóqotáv. ");
INSERT INTO kvg_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Yaq bawabawan ate ndi꞉gu, teqá megemege-té ginǿmøváb. Yaq ndego ezoqa ewaqape, géqatøzó. Āv gené-qatøzó, av sip keoge ezoqam gi꞉goatun, sip mba vinī, neka naningus mba vini. ");
INSERT INTO kvg_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ezoqa eqeieqei, ekeza nakeamo zenda-té genǿ-áb, neka ezoqa soqøsoqa, ekeza yogea zenda-te vǿ-āb. ");
INSERT INTO kvg_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Yaq ndego kawa ezoqam, ndigu ekeza nakeamo zenda-te tiwanat, āv gezømbé-eín nqǽgo, ‘Vø̀ndozáv, zo ezoqam. Noge Tat, zo mø̀ndø-khakheinøvém. Mbumbukiam-qa Megeat Matev, ndego ibugukhokhof zo gezønøza, manqei-qape ande ge꞉khakheinam, zoqá. ");
INSERT INTO kvg_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Zapa ndǿgo, no ifi qanø-vinumam, zo lou zonø-etøumám. Neka ibøkha naq qanø-papumam, zo ibøkha zonø-etøumám. Neka no manqei vini-ak qægoam, zo khoev zonø-manqatám. ");
INSERT INTO kvg_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Neka no ndabua mbain qægoam, zo ndabua zonø-etøumám. Neka no enqoni qanøgoam, zo zònø-kewagám. Neka no ndimbula-te qægoam, zo okha zonøndo-okhoám.’ ");
INSERT INTO kvg_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Yaq ndigu ezoqa eqeieqei timbo-qavøinam, ‘Evézøza. Gê, ni gekha khøuwa-tē qatí-qamekham, qo ifi qaqa-vinumam, yaq lou vøitaqā-etøumam, neka ibøkha naq vøqā-papumam, yaq ibøkha vøitaqā-etøumam? ");
INSERT INTO kvg_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Neka ni gekha khøuwa-tē qatí-qamekham, qo manqei vini-ak qoqogoam, yaq ni khoev vøitaqā-manqatam, neka qo ndabua mbain qoqogoam, yaq ni ndabua vøitaqā-etøumam? ");
INSERT INTO kvg_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Neka ni gekha khøuwa-tē qatí-qamekham, qo enqoni qaqagoam, o ndimbula-te qoqogoam, yaq ni okha vøitaqandō-okhoam?’ ");
INSERT INTO kvg_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Yaq ndego kawa ezoqam tezø-ein, ‘No unimanqatín nqazø-manqate. Gekha matēv ndøgo, zo ndigu qazozø-matønumam, ndigu no ndinøpaev, oskiá ndǿgo, ndigu iz mbain ndigu, yaq ndøgo zo no-té qazonø-matønumám.’ ");
INSERT INTO kvg_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Geté yaq ndego kawa ezoqam, manqat ndígu tezǿ-eín, ndigu ekeza yogea zenda-te tiwanat. Āv gezømbé-eín nqǽgo, ‘Mòzozáv. Zo mòzo-soqoéz. Gøinam-té qazonǿzáv, ndøgo miavmiav ndøwageap, ndøgo Mbumbukiam nqova soqaqape neka tegi enzol ezoqam nonqo gekhakheinam. ");
INSERT INTO kvg_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Zapa ndǿgo, no ifi qanø-vinumam, zo no lou etoumáv. Neka no ibøkha naq qanø-papumam, zo no ibøkha etoumáv. ");
INSERT INTO kvg_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Neka no manqei vini-ak qægoam, zo no khoev manqatemáv. Neka no ndabua mbain qægoam, zo no ndabua etoumáv. Neka no enqoni qanøgoam neka ndimbula-te qægoam, zo no-te okha okhomáv.’ ");
INSERT INTO kvg_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yaq ndigu timbo-qavøinam, ‘Evézøza. Ni qo gekha khøuwa-tē qatí-qamekham, qo ifi qaqa-vinumam, o ibøkha naq qaqa-papumam, o qo manqei vini-ak qoqogoam, o ndabua mbain qoqogoam, o enqoni qaqagoam, o ndimbula-te qoqogoam, yaq ni qo tøkemâv?’ ");
INSERT INTO kvg_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Yaq ndego kawa ezoqam tezø-ein, ‘No unimanqatín nqazø-manqate. Gekha matēv ndøgo, zo qazømbo-qasi꞉vupam, ezoqa vozozømbé-goāt, ndigu no ndinøpaev, oskiá ndǿgo, ndigu iz mbain ndigu, zo no zømbo-qasi꞉vupám.’ ");
INSERT INTO kvg_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nginik ezoqam, yaq-fia nqosøgeap miavmiav-us-qape ndǿndapém. Geté ezoqa eqeieqei ndigu, khandi miavmiav mǿndapém.” ");
INSERT INTO kvg_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu nqanek manqa manqate ate qægoam qamømbøe-navøem, yaq ekeza paev ezoqam gezø-ein, ");
INSERT INTO kvg_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Zo mø̀zøte-zøtéz, khøuwa menas mba mui-ozá, niqa Pasova khøuwa kandambaqape tizi-khantøzem. Yaq Ezoqam-ge Yo gémøvøinám, tae mutui-te vǿtøkewēm.” ");
INSERT INTO kvg_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ta khøuwa-te ndøgo, Mbumbukiam-gi iziz ezoqa kandakanda neka Zu megetapak, gèmøváb. Kayafas-qá khoev-té ginømøváb, ndego Mbumbukiam-ge iziz ezoqam kandambaqape. ");
INSERT INTO kvg_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yaq matavap āv giniveém nqǽgo: Yesu gémøvøinám, khonoam-té, vǿlaēm. ");
INSERT INTO kvg_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Geté āv gini-einím nqǽgo, “Ni khøuwa kandambaqape-te, bizi-matønø̀me᷄m. Soqaín ndøgo, ezoqa qaqa tigonem ni-te, yaq nøfe kandambaqape ndǿfakhān, ti mokho-te.” ");
INSERT INTO kvg_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu Betani vemiav-te gegoam, Saemon-qá khoev-té geqotám. Ngenek Saemon, bugukhokhof kha sisi-us ndøgoám. ");
INSERT INTO kvg_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yaq Yesu ate av-té lou ge꞉logat, sævam kopo tunduwáv ndǿgo, botol-qase vøndōndap. Tae et sisip qanimav-qape mu꞉nqeitavám. Taqa fia kandamba tantáv. Yaq ndugu até gundigu, Yesu, kawa-té gumbøe-qóuz. ");
INSERT INTO kvg_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tegi paev ezoqam, nqanek matev giqeivim, ndigu khanakhanakh mbaín, gi-einim, “Gekha zapâ, ngunuk nqanek tae et fia kandambaqape, sa ngungiitit? ");
INSERT INTO kvg_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ngunuk ambá gewiín, fia kandambaqape vø̄qasɨn, yaq ni moni gigiap-av ezoqam vizizø̄-etoamɨn.” ");
INSERT INTO kvg_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu é-møndæ-otév, av manqat gi꞉manqatam, yaq gezø-ein, “Gekha zapâ, zo ngunuk sævam viniv nqazombøe-veet? Ngunuk matev mbomambaqapé gunø-matanam. ");
INSERT INTO kvg_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Zo gigiap-av ezoqam namba oskia zøté-yageapát. Geté no namba, oskia zí꞉yageák. ");
INSERT INTO kvg_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ngunuk nqanek tae et sisip mbomambaqape, noqa kha-te guoqouz, ndugu no otønat nonqo me꞉khakheinømbém. ");
INSERT INTO kvg_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","No unimanqatín nqazø-manqate. Gekha manqei-tē ndøgo, ezoqa nqanek Manqat Mbomambaqape ti꞉zømesimat, manqei-qape-te ate nqægo, ezoqa ngunuk sævam-qa yaq-te mé꞉manqatát, matev mbomambaqape av guimatanam, neka ngunuk vømbøé-matavupāt.” ");
INSERT INTO kvg_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Taqa zita-te ndøgo, ndigu Yesu-gi paev ezoqa tuelv, ezoqa kopo, iz nqambogo, Zudas Iskaliot, Mbumbukiam-gi iziz ezoqa kandakanda-té genøwáv, ");
INSERT INTO kvg_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","vøzø̄-ein, “Yaq-fia gekha zønǿ-etøomēm, ndego Yesu zoqa zenda-te tæve?” Yaq ndigu até gindigonem, moni mokho 30 vø̄gevebømem, sasa mbo-etøomem. ");
INSERT INTO kvg_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Yaq Zudas ndakin nakhoa-qa ndøváo, Yesu tiqa zenda-te ande āv kenévē. ");
INSERT INTO kvg_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Zu ezoqam-qa khøuwa kandakanda qangaz, ndøgo flawa poponøvemav gilouzatun, ta bugukhokhof khøuwa-te ndøgo, Yesu-gi paev ezoqam tinduzáv ndǿgo, vømbō-bevøpem, “Gê, qoqa poev gekhâm? Ni Pasova lou gekham-tē qeimøqá-khakheinømēm?” ");
INSERT INTO kvg_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yaq Yesu manqa gezø-qavøiu, ezoqam-qá iz zø-etoám, gezø-ein, “Zelusalem taon mokho-té qazonǿzáv, ngenek ezoqam manqat vømømbó-einīm. Āv qazømbøé-einím nqǽgo, ‘Nømendim ezoqam, āv gene-eín: Noqa khøuwa iz mø̀ndøndáp. No paev ezoqam namba, Pasova lou, qoqá khoev-té qeitǿlóg.’” ");
INSERT INTO kvg_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yaq paev ezoqam āv tini-matønømém, av Yesu gezømbe-ein, Pasova lou vømø̄-khakheinømem. ");
INSERT INTO kvg_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Yaq qakhagus ndøgo, Yesu tegi paev ezoqam tuelv namba tinøpindám ndǿgo, lou loge-te vø̄qonav. ");
INSERT INTO kvg_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Yaq ate av-té lou gi꞉logat, Yesu āv gezømbe-eín nqǽgo, “No unimanqatín nqazø-manqate: Zo ezoqa kopo segenǿ-qambún, neka no qaqa ezoqam-qa zenda-te vǿvē.” ");
INSERT INTO kvg_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yaq ndigu mbøni zøvá, nqanek manqat giyogem. Mbøni vaev kandambá. Yaq ezoqa kopokopo ate gi꞉goam āv gimbøe-bevupát nqǽgo, “Evézøza. Éisa. Qo ekeqá no qote-manqaté.” ");
INSERT INTO kvg_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yaq gezø-qavøiu, “Ezoqam ndégo tégoát, ndego no namba lou yaf-te sa qeitumu-afønam. ");
INSERT INTO kvg_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ezoqam-ge Yo ndø̀naním, av Mbumbukiam-qa Manqat qæ-ein. Geté te-te ndego, unimé꞉-soqá, ndego Ezoqam-ge Yo sa temboqambun, neka qaqa ezoqam-qa zenda-te vǿvē. Ngenek ezoqam qaneav tøgonin, ambá qanimáv te-te.” ");
INSERT INTO kvg_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yaq Zudas, ndego Yesu sa gemboqambun, āv gembøe-eín nqǽgo, “Nøméndim ezoqam. Éisa. Qo ekeqá no qote-manqaté?” Yaq Yesu gembo-qavøiu, “Nándav, av qo ndoqote-manqate.” ");
INSERT INTO kvg_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ndigu ate av-té lou gi꞉logat, yaq Yesu flawa ndøndapáz, Mbumbukiam-te ike manqat vø̄-ein, sasa ndømbegim, ekeza paev ezoqam vøzø̄-etoam, gezø-ein, “Mòzo-upøgím, neka vø̄louz. Nqanek noqá khá.” ");
INSERT INTO kvg_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Yaq izam nonqo ndøndáp, waen-ús, Mbumbukiam ike manqat vømbō-ein, ekeza paev ezoqam vøzø̄-etoam, gezø-ein, “Mòzo-izám, zo ate ndøzøte꞉go. ");
INSERT INTO kvg_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nqanek noqá kóuk. Mbumbukiam poev mé꞉-unimanqatín, tegi ezoqam namba. Noqa kouk, ezoqam kopoav zapayá qanéwá. Manqa-zapazapa zømbé-sunguzát. ");
INSERT INTO kvg_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","No nqazǿ-manqate: No waen tae nanga-qa et, nqawa naqanøká nǿ-izák. No sa ndǿgo tømé-íz, ta khøuwa-te ndøgo, zo namba Tat-qa Megeat Matev-te, waen ndakinak tizimø-izømem.” ");
INSERT INTO kvg_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Lou gumulog, Mbumbukiam-te ouv sasa ndøqaem, yaq Oliv manqei pøyat-té ginøzáv. ");
INSERT INTO kvg_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yaq Yesu ekeza paev ezoqam gezø-ein, “Nqægo lova, zo ate nqazøte꞉go, møe zóbøín. No sozó-nøuvøném. Mbumbukiam-qa Manqat, āv qane-peawáp nqǽgo, ‘No sip keoge ezoqam nólaváo. Yaq sip segemǿ-panqaním.’ Yaq ndakin matev āv tønéfakhán, av ndǽgo. ");
INSERT INTO kvg_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Geté no løvøte-te tøtøndo-khandi꞉n, yaq Gelili plovins-té qatǿnáv. No é-ndøto꞉má ndøgo, zoqa megemege-te.” ");
INSERT INTO kvg_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Yaq Pita gendo-ein, “Ezoqa ewaqape, qo ambá giní-qouvøqém. Geté no, nóqouvaqák.” ");
INSERT INTO kvg_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yaq Yesu gembo-qavøiu, “No unimanqatín nqataqa-manqate: Nqægo lova kokolok naqanøká gé-ogeayák. Qo noqa yaq-te ndòqotøkhæ-nawám. Misiká toqoto-nawam.” ");
INSERT INTO kvg_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Geté Pita gembo-qavøiu, “Āv taoká. Oskiá ndøgo, qo namba tøtenanim. No notó-nawamák, qoqa yaq-te.” Yaq até tegi paev ezoqa nømé-a, manqat kopó, āv tini-manqatám. ");
INSERT INTO kvg_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yaq Yesu ekeza paev ezoqam namba, khae manqei-té ginøzáv. Taqa iz, Getsemaní. Yaq gimøfakhaz ndøgo, tegi paev ezoqam, āv gezømbe-eín nqǽgo, “Até vo꞉qonøvé nqanek. No elavøqase nøme nǿnáv. Nomǿ-guligulím.” ");
INSERT INTO kvg_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yaq ndego ti-mba ngínik gekhatób, namba gi꞉zav, Pita neka Zebedi-gi nakhei menas. Yaq Yesu mbøni vaev matev mbongáz. Viniv kandambá gembo-ewag. ");
INSERT INTO kvg_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yaq gezø-ein, “Noqa mbøni kandambá qanevá. No avønín, nǿnaním. Até vøgó nqanek, neka até vo꞉tiawét, no namba.” ");
INSERT INTO kvg_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yaq Yesu elavøqase nøme vø̄wav. Khapémbá. Yaq ekeza kha, manqei me꞉laváo, bugug até manqei-té, Mbumbukiam-te sasa ndøviam. Āv gene-guligulím nqǽgo, “Tát! Kopømba tøgoat, nqanek nqosøgeap kandambaqape, ndøgo ande ibøkha khaqain-qape me tønømbe-fakhan, ambá qøndapɨ́n. Geté matev āv tabete-fakhán, av qoqa poev ndægo. Ambá ndø̄go, av no nqanømbe-poev.” ");
INSERT INTO kvg_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yaq ndego tegi paev ezoqa misika-te gevesez, tezømét ndǿgo. Gèsømbiám. Yaq Yesu Pita gembo-ein, “Ge zô, kopømba mbaîn, no namba elavøqase tøzøte-tiawet? ");
INSERT INTO kvg_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Até vo꞉tiawét, neka gèguligulimít. Soqaín ndøgo, khamasim matev tøndowav zo-te, yaq zo zō-o꞉āz. Unimanqatín. Nqova poev ndømbôgó. Geté kha, bazaføgakh mbaín.” ");
INSERT INTO kvg_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yaq Yesu nangó genøwáv, vømø̄-guligulim, ge-ein, “Tát! Nakhoa nøme mbain tøgoat. Qo taqa-pøovat, no nqanek ibøkha khaqain-qape sa tæ-iz, ság. Qoqa poev matev sà befakhán.” ");
INSERT INTO kvg_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yaq tegi paev ezoqa misika-te nango gendovesez, gezømet, ndigu nqawá ginø-sømbiám. Kopømba mbaín, to꞉tiawet. ");
INSERT INTO kvg_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yaq Yesu sègezø-iváv, nango vø̄wav. Yaq gèmømbo-misiká, geguligulimat. Manqat ge-ein, até kopó, av bugukhokhof ge꞉manqatam. ");
INSERT INTO kvg_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yaq tegi paev ezoqam-te nango gendovesez, gezø-ein, “Zo sekembā sozó-sømbiapet neka pusa zótavet? Nqáe! Khøuwa iz mìzi-khanøzém. Ezoqam-ge Yo, manqa-zapazapa-us ezoqam-qá zenda-té ginǿveém. ");
INSERT INTO kvg_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mòzosúz. Bìziniáv. Ngé! Ezoqam ngének, no ezoqam-qa zenda-te teve!” ");
INSERT INTO kvg_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu ate av-té manqat ge꞉manqatam, Zudas tènefakhán. Tegi paev ezoqa tuelv, ezoqa nøme ndégo tegoám. Ezoqa kopoáv, namba me꞉geavún, ndigu kaiya neka ndawa vøndō-upøgim. Nginik Mbumbukiam-gi iziz ezoqa kandakanda neka Zu megetapak ndokhofotáz. ");
INSERT INTO kvg_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Zudas, manqa é-møndøzø-eín, av nqægo, “Ezoqam ndégo, no tængenøtam. Ndégo tozó-møvøinám.” ");
INSERT INTO kvg_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yaq Zudas até gendego, Yesu-té genøwáv, gembo-ein, “Nøméndim ezoqam. Lova mbomá.” Neka sasa ndøngenøtam. ");
INSERT INTO kvg_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yaq Yesu gembo-qavøiu, “Nǿfu. Matev vø̀matanám, ma qoqombøe-geavun.” Yaq ndigu ezoqa nøme tinduzáv ndǿgo, Yesu vø̄-møvøinam. ");
INSERT INTO kvg_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yaq nqáe! Ezoqa kopo, Yesu namba ge꞉goam, até gendego, kaiya mba ndøliváz, Mbumbukiam-ge iziz ezoqam kandambaqape, tege sasae ezoqam, gea vømbōkawa. ");
INSERT INTO kvg_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Geté Yesu gembo-ein, “Kaiya nandiv, nango vø̀-utáz, ma qoqotønde-livaz. Ezoqam ndigu kaiya ti꞉khanæmat, kaiyá gimí-pakhaéz. ");
INSERT INTO kvg_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ge qô, qateqateâv, av nqægo? No amba tønø-poevɨn, yaq no ambá kopømbá. Ambá Tat nombo-akhaɨ́n, tøke-qa. Yaq ndego até tendegonɨn, enzol ezoqam vøndō-khofotazɨn, no vønø̄-tøkeemɨn. Ndego enzol ezoqam kopoav-qapé tendo-khofotazɨn. Tiqa bawan ate tægonɨn, tuelv ndø̀mø-løvuín. ");
INSERT INTO kvg_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Geté Mbumbukiam tegi enzol ezoqam amba tendo-khofotazɨn, yaq gê, Mbumbukiam-qa Manqat áv khané-unimanqatīn, ndøgo qa-ein, av nqægo, matev yà befakhān, av ndakin tæfakhan ndægo?” ");
INSERT INTO kvg_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yaq Yesu ezoqa ewaqape gezø-ein, “Ge zô, no pepen ezoqam zøténæmbem, nakhag kaiya neka ndawa-us qazogeavun, no vozó-møvønonām? No khøuwa ate qæpavpavemam, Mbumbukiam-qá khoev-té qæqoám, ezoqa vøtē-zømesimam. Geté ndøgo, zo no møvønoateáv. ");
INSERT INTO kvg_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Geté nqanek matev ate ndægo, tønefakhán ndǿgo, Mbumbukiam-qa Manqat tàbete-unimanqatín, av tegi manqa vevezam ezoqam gi꞉peaumam.” Yaq Yesu nqanek manqat qamømbøe-navøem, tegi paev ezoqam sège-ivøvém. Møe ndøbøín. ");
INSERT INTO kvg_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ezoqam ndigu, Yesu gimøvøinam, yaq Kayafas-qá khoev-té ginøndafém, ndego Mbumbukiam-ge iziz ezoqam kandambaqape. Mozes-qa guguna manqat nømendim ezoqam neka Zu megetapak nøme, é-møndømøváb ndøgo. ");
INSERT INTO kvg_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita Yesu até gembopavát. Andé qámbá gendopavam. Yaq Mbumbukiam-ge iziz ezoqam kandambaqape-qa khoev-te gemøfakhan, até ndegó-a, uta mokho-te vø̄-on, vos keoge ezoqam namba vømēqonav. Ndego matev qeivi-qa ndøgoám, Yesu andé gekha matev me mbøégonēm. ");
INSERT INTO kvg_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mbumbukiam-gi iziz ezoqa kandakanda neka Zu ezoqam-gi manqa ovøyam megetapak ate gi꞉goam, Yesu, manqa-zapazapa-qa mbovawát. Yaq ezoqa amba khokho manqat ti-einimin, teqa yaq-te, ndigu ambá gelaemɨ́n. ");
INSERT INTO kvg_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ezoqa kopoáv gindu-okhoat, khokho manqat gimanqatat, teqa yaq-te. Geté ndigu megetapak nakhoa qeiviáv, vǿelaēm. Yaq vaev, ezoqa menas tinduzáv ndǿgo, gindu-einim, ");
INSERT INTO kvg_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Ngenek ezoqam āv gene-eín nqǽgo, ‘No kopømbá. Mbumbukiam-qa khoev nó-evøzám. Yaq khøuwa misika mokho-te, nangó qatǿwév.’” ");
INSERT INTO kvg_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Yaq Mbumbukiam-gé iziz ezoqam kandambaqape ndø-itán, Yesu vømbō-ein, “Ge qô, yaq manqa qavøiwat taqágo, nginik qo-te manqat ngi-møvøet?” ");
INSERT INTO kvg_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Geté Yesu manqat einiáv. Yaq Mbumbukiam-ge iziz ezoqam kandambaqape gembo-ein, “Khandi Miav-ak Mbumbukiam-qa iz-te, soqoní-eín. Gê, qo Mesayâ? Mbumbukiam-gê Yò?” ");
INSERT INTO kvg_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yaq Yesu gembo-qavøiu, “No nándev, av qo ndoqote-manqate. Geté no nqazǿ-manqate. Zuá. Zo Ezoqam-ge Yo zomǿ-ometám. Mbumbukiam Bazaføgakh-qape-qá nakeamo zenda-té géqotát. Yaq ndego khaiya ozoz-té genǿgeáv.” ");
INSERT INTO kvg_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yaq ndego Mbumbukiam-ge iziz ezoqam kandambaqape, mbøni mbonqosøgím, nqanek manqat ge-ewag. Yaq até gendego, ekeza ndabua vø̄keqa, gendo-ein, “Ngenek Mbumbukiam-qá iz ndøngiú. Ság! Bøi vizu ezoqa nøme-qa bizivàwe᷄m. Nqáe! Zo mòzombo-yogém, Mbumbukiam-qa iz gengiu. ");
INSERT INTO kvg_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ge zô, áv khazømbøé-matavap?” Yaq ndigu ezoqa ewaqape gindu-qavøinam, “Unimanqatín. Ngenek manqa-zapa ndøgó. Yà benaním.” ");
INSERT INTO kvg_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Yaq ndigu até gindigonem, køse vømbø̄e-pisibømem, teqa bugug-te, neka vø̄zuim. Ezoqa nøme, tømøi mbotøkubím, ");
INSERT INTO kvg_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","yaq āv gimbøe-einím nqǽgo, “Qo Mesaya toqogoat, ndego Mbumbukiam tendo-khofotav, yaq qotínømánd, av nqægo, qo gekha ezoqām ndǿlavaq?” ");
INSERT INTO kvg_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita khoev uta mokho-te gu꞉qotam, yaq sasae mbasønakam ndowáv, gumbo-ein, “Até qó-a, Yesú namba qotegoám, ndego Gelili plovins-ak.” ");
INSERT INTO kvg_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Geté ndego gò꞉nawám. Yaq ezoqa ewaqape-qa bugug-te, āv gene-eín nqǽgo, “No nø̀tenøtenák, qo gekhā qotē-manqate.” ");
INSERT INTO kvg_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Yaq ndego uta mboqog-te gendo-fakhan, sasae mbasønakam nømu tùni-omét. Yaq ndugu ezoqa nøme, giwaniapam ndøgo, āv guzømbe-eín nqǽgo, “Ngenek Yesú namba me꞉goám, ndego Nazalet vemiav-ak.” ");
INSERT INTO kvg_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Yaq até nangó, Pita gò꞉nawám, gendo-qavøiu, “No unimanqatín nqataqa-manqate. Mbumbukiam-qa iz-te, no ngenek ezoqam nø̀tenøtenák.” ");
INSERT INTO kvg_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Yaq khapélæ qa-auwam. Yaq até ezoqa nømé-a, giwaniapam, Pita-te vø̄ndozáv, gimbo-einim, “Unimanqatín. Ezoqa nøme qó, te namba qazøtegoam. Ni tøtinøtén ndǿgo, qoqa manqat elavøqase viní. Gelili ezoqam-qá manqát.” ");
INSERT INTO kvg_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yaq Pita gezø-qavøiu, “No unimanqatín nqazø-manqate. No nandev ezoqam nø̀tenøtenák. No tøte-khavozumit, yaq Mbumbukiam kopømbaqapé, bèlavámb.” Pita nqanek manqat ge-ein, yaq ndaføyambá, kokolok tūndū-ōgeā. ");
INSERT INTO kvg_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yaq Pita manqat gèmbo-matøvém, av Yesu gembøe-ein nqægo, “Kokolok naqanøká gé-ogeayák. Qo noqa yaq-te ndòqotøkhæ-nawám. Misiká toqoto-nawam.” Yaq Pita bavokhó genøfakhán, vømø̄vin. Eiv baza ùni mbøepós, ge-eivat. ");
INSERT INTO kvg_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Yaq qanaqanus, lovølova-ús. Mbumbukiam-gi iziz ezoqa kandakanda neka Zu megetapak, manqat ndøkopo꞉ném, gi-einim, “Yesu zílaém.” ");
INSERT INTO kvg_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Yaq gèløvønøvemém, Lom gaman ezoqam-qa zenda-te vømø̄veem. Teqa iz Pailǿt. ");
INSERT INTO kvg_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Zudas, ndego Yesu sa gemboqambun, ge꞉-otev, ndigu matavap giveem, av nqægo, Yesu zīlaēm, yaq ndego mutøkhop ndø-itán, av matev ge꞉matanam ndægo. Yaq até gendego, moni mokho 30 gimbo-etøomem, nangó genø-upøzó, ti-te ndigu, Mbumbukiam-gi iziz ezoqa kandakanda neka megetapak. ");
INSERT INTO kvg_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Yaq Zudas āv gezømbe-eín nqǽgo, “No manqa-zapa nøgó, ndego manqa-zapa mbain ezoqam, zoqa zenda-te qæve, tozolaem.” Geté ndigu gindu-qavøinam, “Nandav niqá vinív mbá. Qakeza manqa-zapá.” ");
INSERT INTO kvg_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yaq Zudas até gendego, moni mokho Mbumbukiam-qá khoev mokho-té genø-nqagevém, sasa ndøwav. Yaq gewav ndøgo, ekeza monqo møfók, vø̄nanim. ");
INSERT INTO kvg_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Yaq Mbumbukiam-gi iziz ezoqa kandakanda, moni mokho gèpisumém, Zudas Mbumbukiam-qa khoev-te genqagevem. Geté gi-einim, “Khafeáp, nginik moni, Mbumbukiam-qa khoev moni namba tizi꞉-tøkuzunam. Zapa ndǿgo, nginik moni mokho, ezoqam me꞉laém.” ");
INSERT INTO kvg_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Yaq ndigu manqat āv gini-kopo꞉ném nqǽgo: Ndigu moni, ganda pot khakheinam ezoqam-qá khae mé꞉wiím. Manqei vini-ak-qá ezoqa osam nonqó, Zelusalem taon-te løvøte tiqeivimat. ");
INSERT INTO kvg_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yaq nakémbá, ndøgo khae, ndakin iz “khae kouk-us” mbo-akhayám. ");
INSERT INTO kvg_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nqanek matev qafakhan, yaq manqat ndøgo, Mbumbukiam-ge manqa vevezam ezoqam Zelemaya gepeawam, gèmø-unimanqatín, av qæ-ein nqægo, “Ndigu moni mokho 30 gi-upøzonam, ta fia ndøgo, Izlael ezoqam manqat gikopo꞉nem, ndego ti꞉wiim, ");
INSERT INTO kvg_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","yaq nginik moni, pot khakheinam ezoqam-qá khae me꞉wiím. Ate av-té, av Evezøza manqat genømbe-ein.” ");
INSERT INTO kvg_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yaq Yesu Lom gaman ezoqam-qá megemege-té genø-itán. Yaq ndego gembobevap, “Gê, qo Zu ezoqam-gê kawà?” Yaq Yesu gembo-qavøiu, “Nándav, av qo ndoqote-manqate.” ");
INSERT INTO kvg_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Geté ndigu Mbumbukiam-gi iziz ezoqa kandakanda neka megetapak manqat te-te gimøvøyat, ndego manqat einiáv. ");
INSERT INTO kvg_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Yaq Pailøt gembo-ein, “Gê, qo tiqa manqat toqóyoge, ndigu qo-te mba ndimøvøet?” ");
INSERT INTO kvg_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Geté Yesu yaq manqa qavøiwateáv. Yaq ndego Lom gaman ezoqam, nqova ndafe kandambá. ");
INSERT INTO kvg_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Zu ezoqam-qa Pasova khøuwa kandambaqape-te, ndego Lom gaman ezoqam, ndimbula ezoqa kopo sège-nqonqotavɨ́n, ezoqam-te, vø̄fakhanɨn, av ndigu qazømbe-poeɨn. ");
INSERT INTO kvg_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ta khøuwa-te ndøgo, ndimbula ezoqa kopo mø̀ndøgoám. Teqa iz Balabás. Ezoqa ewaqape mø̀ndæzøtéz, ndego pepen ezoqam soqaqapé. ");
INSERT INTO kvg_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Yaq ezoqa ewaqape, Pailøt-te gimøvab, ndego āv gezømbe-beváp nqǽgo, “Gekha ezoqā nøzǿ-mboqoiū, ndimbula-te tefakhan? Balabâs, ó, Yesû, ndego Mesaya ndimbo-akhayam?” ");
INSERT INTO kvg_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ndego mø̀ndæ-otév, Zu megetapak, Yesu teqa zenda-te, ta zapaya ndǿgo tiniveém. Ndigu ova ndø-einím. ");
INSERT INTO kvg_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailøt manqa ovøyam khoev-te ge꞉qotam, yaq tegu zas manqat ndokhofotáv. Manqat av nqǽgo, “Nandev ezoqam, matev-qase mbomatàna᷄m. Ndego manqa-zapa mbaín. No lova venanqei notamát, te zapaya. Venanqei-tam soqaqapé.” ");
INSERT INTO kvg_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Geté Mbumbukiam-gi iziz ezoqa kandakanda neka Zu megetapak, ezoqa ewaqape āv gizømbe-pouweát nqǽgo, “Pailot āv qazømbøé-einím nqǽgo: Balabas benqonqotáv, bavokho. Geté Yesu løvøte-té geabenøvé.” ");
INSERT INTO kvg_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Yaq Pailøt ezoqa ewaqape gezøbevap, “Nginik ezoqa menas, gekha ezoqām nøzǿ-nqonqotāv?” Yaq ezoqa ewaqape gimbo-qavøinam, “Nándev, Balabas, toqoní-nqonqotáv!” ");
INSERT INTO kvg_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Yaq Pailøt gezø-ein, “Av tægoat ndægo, yaq ngenek Yesu, Mesaya ndimbo-akhayam, gekha nombógō?” Yaq ezoqa ewaqape gimbo-qavøinam, “Tae mutui-té geabe-tøkewé.” ");
INSERT INTO kvg_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Yaq Pailøt gezøbevap, “Gekha zapâ? Ngenek gekha manqa-zapā ndǿgo?” Geté ndigu kandakanda nøme mba mo꞉-akhaemém, “Tae mutui-té geabe-tøkewé.” ");
INSERT INTO kvg_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Yaq Pailøt geqeiv, av nqægo, ndigu teqa manqat gēyogemāk neka avønīn nøfe ndø̄ngazēm, yaq ndego ibøkha ndøndáp, ezoqa ewaqape-qa bøi-te, zenda vø̄sunguz, gezø-ein, “Nqanek noqá manqa-zapá mbá, zo ngenek ezoqam tozolaem. Zoqá manqa-zapá.” ");
INSERT INTO kvg_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Yaq ezoqa ewaqape gindu-qavøinam, “Yaq-fia nqosøgeap, teqa kouk waev-qa yaq-te, ni-té qabenø-nqeivøém, nigi nakheis namba.” ");
INSERT INTO kvg_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yaq Pailøt até gendego, Balabas vøzø̄-nqonqotav. Geté Yesu nakhag ezoqam-qá zenda-té genøvé, bemø̄feomem, tae mutui-te sasa bemø-tøkewem. ");
INSERT INTO kvg_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Yaq Pailøt-gi nakhag ezoqam, Yesu gaman-qá khoev-té gimøndafém, yaq nakhag ezoqa ewaqape vøzø̄-akha, te-te vøndō-pindam. ");
INSERT INTO kvg_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Yaq até gindigonem, ekeza ndabua sègembo-khofoném, neka ndabua køkouk, kopømba ande av kawa ezoqam-qa ndabua ndægo, vømbō-uzim. ");
INSERT INTO kvg_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Yaq gumbag fakiafakia-us ndø-ogeaném. Yaq kawa-té gimbøe-uzím. Andé kawa ezoqam-qá wawáq. Yaq teqa nakeamo zenda-te, tatuag, kopømba ande av kawa ezoqam-qa tatuag ndægo, vømbō-etøomem. Yaq otøotam me꞉vewém. Katuk ndømøkuí, teqa megemege-te, gimbo-einim, “Zu ezoqam-ge kawa. Iké꞉ qo-te.” ");
INSERT INTO kvg_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Yaq køse mbøe-pisibømém, teqa kha-te, tatuag nqawa vø̄e-viomem, kawa sasa mbøe-khanæmem. ");
INSERT INTO kvg_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Otøotam gumuvewem, yaq ndabua køkouk, nqawá ginømbo-khofoném, neka ekeza ndabua vømbō-uzim. Yaq tinøndafém ndǿgo, tae mutui-te vømǿ-tøkewēm. ");
INSERT INTO kvg_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nakhag ezoqam, Yesu taon bavokho gi꞉-ituat, ezoqa ndø-ometám. Sailini taon-ák. Teqa iz Saemón. Yaq ndigu até gindigonem, ndego Yesu-qa tae mutui eqawat-qa yaq-te vø̄tøpøtøvem. ");
INSERT INTO kvg_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Yaq gi꞉-apat, manqei ndǿgo timøfakház, Golgota ndimbo-akhayam. Taqa manqa mokho, “Kawa-pakha manqeí.” ");
INSERT INTO kvg_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Yaq Yesu ambá waen mbo-etøomemɨ́n. Gigiap khaqain-qapé namba me꞉tøkuaném. Geté ndego ge꞉khamas, yaq gèmbøeqasí, vǿe-īz. ");
INSERT INTO kvg_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Yaq Yesu tae mutui-té ginø-tøkewém. Gumu-tøkewem, yaq teqa ndabua, kas me꞉-otám. ");
INSERT INTO kvg_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Yaq qame-navøem, ndigu sègeqonáv ndøgo, Yesu vømbō-gazinem. ");
INSERT INTO kvg_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Teqa kawa-te, ova ndo꞉go, manqat ndøtøkeém, ndego andé gekha manqa-zapa zapayā ginīlaem. Āv qane-peaupám nqǽgo, “Ngenek Yesú. Zu ezoqam-gé kawá.” ");
INSERT INTO kvg_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Yesu gitøkewem, pepen ezoqam menás namba me꞉tøkebám. Nøme ndego, teqa nakeamo zenda-té ginø-tøkewém, neka nøme ndego, yogea zenda-te vø̄tøkewem. ");
INSERT INTO kvg_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ezoqa gi-okhoat ndøgo, Yesu sège-ngenøitát. Kawa mba ndøngetæát, ");
INSERT INTO kvg_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","manqat vombō-manqatat, av nqægo, “Qo Mbumbukiam-qa khoev ngi꞉wat-qa neka khøuwa misika mokho-te nango weve-qa qoqogoam, qo qakeza mokho-mba vø̀khandí꞉q. Soqotøndó-vís, nandav tae mutui-te, qo unimanqatin Mbumbukiam-ge Yo toqogoat.” ");
INSERT INTO kvg_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Yaq até Mbumbukiam-gí iziz ezoqa kandakandá-ya, Mozes-qa guguna manqat nømendim ezoqam neka megetapak nøme namba, otøotam me꞉vewém. ");
INSERT INTO kvg_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Gi-einim, “Ezoqa nøme gèkhandi꞉ztám. Geté ekeza kha, kopømba mbaín tekhandi. Ngenek unimanqatin Izlael ezoqam-ge kawa tegoat, yaq ndakin yà betøndovís, nqanek tae mutui-te. Yaq ni tàbizi-unimanqatiním. ");
INSERT INTO kvg_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ndego Mbumbukiam-te mbá genøtawé. Yaq Mbumbukiam yà bekhandí꞉v, unimanqatin poev tømbogoat te-te. Ngenek ekezan āv gene-eín nqǽgo, ‘No Mbumbukiam-gé Yó.’” ");
INSERT INTO kvg_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Yaq até pepen ezoqám-a, Yesu namba tae mutui-te gitøkebupam, vø̄ngenøinam. ");
INSERT INTO kvg_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yaq khøuwa muin qandap, qamat atema khagus 3 oklok vø̄ndap, manqei ate qægoam, bøivun ndønqeivøém. ");
INSERT INTO kvg_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Yaq ande av 3 oklok ndægo, Yesu kandambaqape tène-ogeá. Ekeza manqat-te āv gene-akhá nqǽgo, “Eli, Eli, lømá sabaxtáni?” Taqa manqa mokho nqánek: “Mbumbukiam, Mbumbukiam. Gekha zapâ, no qoqo-nøuvan?” ");
INSERT INTO kvg_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Geté ezoqa nøme, avønin giwaniapam ndøgo, teqa akhayam giyogem, ndigu manqa mokho ndapeáv. Yaq āv gini-einím nqǽgo, “Ngenek Ilaiza mbo-akhayám.” ");
INSERT INTO kvg_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Yaq ezoqa nøme até gendego, ndabua-qa ndøteít, waen khaqain-qape-te vø̄uqoqom, tae-te sasa ndøløvønam, Yesu vømbō-qantav. Izam-qa mbogoám. ");
INSERT INTO kvg_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Geté ezoqa nøme gindu-einim, “Qombó-iváv. Yaq zíqeivím, Ilaiza petøndéwāv, penømakhaya, ngenek vǿkhandī꞉v.” ");
INSERT INTO kvg_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yaq Yesu kandambaqape, nangó genø-akhá, vø̄nanim. ");
INSERT INTO kvg_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yaq nqáe! Mbumbukiam-qa khoev-te, ndabua ndøgo, khafeap kouwat mboqog-te qafaleam, livin-mbá qanømu-qatavát. Sa ová qandoqatá, atema manqei-te. Neka manqei vø̄kukuvøem, neka nandi kandakanda vø̄-qaqanimat. ");
INSERT INTO kvg_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Yaq Mbumbukiam-gi ezoqa kopoáv, ndigu ibugukhokhof gipakhaetat, tiqa manqei-pakha sège-mboqovøemát, ma gi-osupat ndøgo, neka løvøte-te vøndōsuz, ");
INSERT INTO kvg_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","neka tiqa manqei-pakha vø̄-ivøvem. Yaq Yesu løvøte-te gendo-khandi꞉v, taqa zita-te, ndigu Zelusalém ginø-óz, Mbumbukiam-qa taon-te. Ezoqa kopoáv gizømet, ndigu løvøte ezoqam. ");
INSERT INTO kvg_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yaq ndego nakhag kawa ezoqam neka ndigu nakhag ezoqa nøme, Yesu gimbo-kewagat, manqei kukuvøem neka matev ate ndægo giqeivim, qafakhanumat, ndigu møe ndøgoném. Møe kandambá. Yaq āv gini-einím nqǽgo, “Ngenek unimanqatín Mbumbukiam-gé Yó.” ");
INSERT INTO kvg_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ta manqei-te ndøgo, até sakheís-a, vø̄goam. Sakheis kandambá. Andé qambaqapé gindu-waniapát, matev giqeivat. Nginik sakheis Yesú namba me꞉geavún, Gelili plovins-te ginduzav, neka vømbō-tøkeam. ");
INSERT INTO kvg_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Sakhei nøme, namba gi꞉waniapam, nømu Melí. Magdala vemiav-ák. Neka Meli nømu, ndugu Zems neka Zosef, tigú evó. Neka nømu ndugu, Zebedi-gú zás. Zems neka Zion, tigú evó. ");
INSERT INTO kvg_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ezoqa kopo mø̀ndøgoám. Teqa iz Zoséf. Alimatea vemiav-ák. Gigiap kopoav ezoqám. Ndego Yesu-gé paev ezoqam nøme ndøgoám. Yaq Yesu gitøkewem, qakhagus ndøgo, ");
INSERT INTO kvg_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ndego Pailøt-té genøwáv, Yesu-qa kha-qa yaq-te vømømbō-viam. Yaq Pailøt ekeza nakhag ezoqam gezø-ein, “Ság. Ngenek teqa kha, sà bendáp.” ");
INSERT INTO kvg_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yaq Zosef até gendego, teqa kha vø̄ndap, ndabua ndakinak sasa me꞉løvønøvem. ");
INSERT INTO kvg_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Yaq ekeza manqei ozu-té gemø-eoeiú, ndøgo nandi-te ge-oz. Yaq nandi-qape ndøqambesám, manqei-pakha mboqog vø̄tok, sasa ndøwav. ");
INSERT INTO kvg_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Yaq Meli Magdala vemiav-ak neka Meli nømu, manqei-pakha avønin-té giqonavát, gimbo-kewagat. ");
INSERT INTO kvg_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Yaq khøuwa nøme qandopave, khøuwa kandakanda-qa lou khakheinam khøuwa qame-navøem, Mbumbukiam-gi iziz ezoqa kandakanda neka Felisi ezoqam, Pailøt-té ginøzáv. ");
INSERT INTO kvg_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Gimbo-einim, “Khanánqa. Ni matavap āv qanimbi-veséz nqǽgo: Ndego khavozam ezoqam gekhandi꞉vtam, ndego āv gene-eín, ‘No løvøte-te nango ndæ̀khandí꞉n, khøuwa misika-qa zita-te.’ ");
INSERT INTO kvg_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yaq nakémbá. Nakhag ezoqam qókhofotáz, ndøgo manqei-pakha-te. Yaq ùni bembøe-keogé, atema khøuwa misika bemø̄-nasinim. Soqaín ndøgo, tegi paev ezoqam teqa kha ti-aqonømem, yaq ezoqa vøzømbé-khavozām, av nqægo, ‘Ndego løvøte-tē gendo-khandī꞉v.’ Khavozam manqat av nqægo, amba tøfakhanɨn, yaq ndøgo, teqa khavozam manqat ate ndægo, ibugukhokhof gemanqatam, ambá unime꞉-løvuamɨ́n.” ");
INSERT INTO kvg_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Yaq Pailøt gezø-ein, “Qanimáv. Nakhag ezoqam zó-upøzó. Neka ùni mbøe-keogé, nandav manqei-pakha.” ");
INSERT INTO kvg_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Yaq ndigu manqei-pakha-te vø̄zav. Yaq nandi-qape-te ndøgo, ndigu mboqog-te go꞉zavam, khakhatap mo꞉goném. Soqaín ndøgo, ezoqa sa ti-oz. Yaq nakhag ezoqam, sègeziváz ndøgo, manqei-pakha gimbo-kewagat. ");
INSERT INTO kvg_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat khøuwa qame-navøem, yaq Sande qanaqanus qandopave, Meli, ndugu Magdala vemiav-ak, neka Meli nømu, manqei pakha-té ginøzáv. Ambá gèmø-qeivimín. ");
INSERT INTO kvg_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yaq nqova mbaín, manqei qando-kukuvøem. Manqei kukuvøem kandambá. Zapa ndǿgo, Evezøza-gé enzol ezoqam ndovís, yan-te, nandi-qape vø̄-qambesam, manqei-pakha mboqog tambav-te go꞉zavam, nandi mumat sasa mo꞉qom. ");
INSERT INTO kvg_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Teqa kha waev kandambá, vøiyam-ús, neka teqa ndabua ùnime꞉-papaqá. ");
INSERT INTO kvg_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Yaq nakhag ezoqam gi-ometam, ndigu møe kandambá. Kha sègezømbu-wageapát, vø̄-o꞉az. Andé løvøte ezoqam me me꞉singitavát. ");
INSERT INTO kvg_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Geté ndigu sakheis, enzol ezoqam āv gezømbe-eín nqǽgo, “Zo møe ndøgòne᷄m. No mø̀tenøtén. Zo Yesu-qa zovawét, ndego tae mutui-te gitøkewem. ");
INSERT INTO kvg_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ndego nqanek mbaín. Mbumbukiam mø̀ndø-khandí꞉v, løvøte-te. Ate av-té, ekezan manqat ge꞉manqatam. Zøtøndézāv. Manqei ndøgo, ma kha qæveam, nqánek. ");
INSERT INTO kvg_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ndakin nakhama ndøzáv, tegi paev ezoqam manqat vømøzø̄-ein. Āv qazozømbé-eín nqǽgo, ‘Ndego mø̀ndø-khandí꞉v, løvøte-te. Yaq ndakin Gelili plovins-té genømá. Ndego é-ndo꞉má ndøgo, zoqa megemege-te. Yaq ndǿgo, tozomǿ-ometám.’ Nqáe! No ndakin mø̀ezø-eín.” ");
INSERT INTO kvg_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Yaq ndigu sakhei menas, manqei-pakha sège-ivøvém. Nakhamas-té. Møe-ús. Geté até khanakhanakh kandambá. Yaq tegi paev ezoqam-té ginøbøín. Ambá manqat møzø-einín. ");
INSERT INTO kvg_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Geté nakhoa livin ndøugu, nqáe! Yesu zøfakhán, vøzø̄-ein, “Qanaqanus mbomá, zo-te!” Yaq ndigu tinøzáv ndǿgo, katuk vømbō-møkuim, zenda tokhotapak sasa mbogeagimem, vømbō-vizumem. ");
INSERT INTO kvg_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yaq Yesu gezø-ein, “Zo møe ndøgòne᷄m. Nogi paev ezoqam-té qanøzáv, manqat vømøzø̄-ein. Gelili plovins-té giabenøzáv. Yaq no ndǿgo timǿ-nømendám.” ");
INSERT INTO kvg_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ndigu sakheis nakhoa-te gi꞉-apat, yaq nakhag ezoqa nøme ndigu, manqei-pakha gimbo-kewagat, taon-té ginøveséz, Mbumbukiam-gi iziz ezoqa kandakanda, matev ate ndægo, ande āv khanē-fakhanumat, vømēzømas. ");
INSERT INTO kvg_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Yaq ndigu Mbumbukiam-gi iziz ezoqa kandakanda, megetapak nømé namba me꞉qonáv, manqat vø̄kakambam. Manqat gumu-kopo꞉nem, yaq até gindigonem, nakhag ezoqam moni vøzø̄-etoam. Moni andé kandambá. ");
INSERT INTO kvg_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Gizø-ein, “Zo ezoqa āv qazozømbé-manqatét, ‘Ni nìsømbiát, lova. Yaq tegi paev ezoqam tinduzáv ndǿgo, teqa kha vø̄-aqonømem.’ ");
INSERT INTO kvg_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Geté ndego Lom gaman ezoqam, taqa yaq-te te-ewag, yaq ni āv qeimbøé-einím nqǽgo: Ndøgo zoqá manqa-zapá mbá. Zo mbofofògea᷄p.” ");
INSERT INTO kvg_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Yaq ndigu nakhag ezoqam, moni gindøpøzem, āv tini-matønumám, av gizømbe-ein. Yaq nqanek khokho emanqat, sège-panqavøemát, Zu ezoqam-qa bawan mokho-te. Até ndaki khøuwa-té-a, sège-panqavøemét. ");
INSERT INTO kvg_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yaq Yesu-gi paev ezoqam ileven, Gelili plovins-té ginøzáv, manqei pøyat-te vømø̄qavig. Ate av-té, av Yesu gezømbe-manqatam. ");
INSERT INTO kvg_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Yaq gi-ometam ndøgo, katuk ndømøkuím, vømbō-vizumem. Geté nøme ndigu, gò꞉nakém. ");
INSERT INTO kvg_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yaq Yesu sègezø-khanøgím, gezø-ein, “Gigiap ate ndægo, yan-te neka manqei-qape-te nqago, Mbumbukiam noqá zenda-té genøvé. No notó-kawaentát. ");
INSERT INTO kvg_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yaq nakémbá. Bawabawan-te ate ndækhazet, sozó-okhoát, ezoqa noqa manqat vømē-zømesim, yaq ndigu bemø̄-nogi-paev-ezoqam-ez. Yaq ibøkha iz zozǿ-etoumát, Tat-qā iz-tē, neka Yo-qā iz-tē, neka Nqova Mbomambaqape-qā iz-tè. ");
INSERT INTO kvg_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Neka vø̀e-zømesimít. Manqat ate ndægo, av no qazømbe-manqatam, bemø̄ndapem. Nqáe! No ndæ̀goát zo namba, khøuwa ate ndægo, atema manqei-qape vaev-te.” ");
INSERT INTO kvg_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Emanqat Mbomambaqape, Yesu Keliso-qa yaq-te, ndego Mbumbukiam-ge Yo, nqánek. ");
INSERT INTO kvg_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Matev āv qanengáz, av Mbumbukiam-ge manqa vevezam ezoqam Aezaya ge꞉peawam. Ndego āv gene-peawám nqǽgo, “Mbumbukiam ge-ein: Nqáe! Noge u-anem notó-khofotáv, qoqa megemege-te. Ndego nakhoa møqá-khakheinám. ");
INSERT INTO kvg_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Leg-av manqei-te ndøgo, ezoqam-qa manqa wag ndǿ-akhayam. Āv qane-akhayám nqǽgo, ‘Evezøza-qa nakhoa é-mozoto-khakheinømém. Nakhoa ndaføyamba-qape zombøé-viæém, ndego te꞉geav.’” ");
INSERT INTO kvg_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yaq Zion ndøfakhán, leg-av manqei-te ndøgo, ezoqam ibøkha iz vøzø̄-etoumam neka Mbumbukiam-qa Manqat vø̄e-zømesimam. Āv gezømbe-manqatám nqǽgo, “É-mozoqambúz, neka ibøkha iz vø̄-upøgim. Yaq Mbumbukiam zoqa manqa-zapazapa, ndø̀mbøe-navøém.” ");
INSERT INTO kvg_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ezoqa kopoáv, gindupindam te-te. Zudia plovins-té gindu-okhoám, plovins ate ndægo, neka Zelusalem taon-ak vøndō-pindam. Yaq manqa-zapazapa ndøgo, gimatønumam, gèvøndæmém, neka Zoden kea-te ndøgo, ibøkha iz vø̄-upøgim. ");
INSERT INTO kvg_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Zion ndabua eqeieqei uzøpøteáv. Geté ndabua ge-uzupam, kemol-qá su gini-geveaném, neka ndabua segim nonqo, søvakha gigiap-gí ngusúm gini-khakheinøvemém. Neka lou gelogam, bamøkhokeakh neká ndokhos, ti-mba ndígu telouzám. ");
INSERT INTO kvg_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Zion ezoqa manqat āv gezømbe-manqatám nqǽgo, “Noqa zita-te, ezoqa kopo ndø̀geáv. Ndego no ùnime꞉-løvumbám. No ezoqa khàpe nøte-khapelavøqase-én. Até nqanek sasae khapelavøqasé-a, no katuk tæmøkui, teqa tamak khofoe-te tæmbotøke, no kopømba mbaín. ");
INSERT INTO kvg_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","No zo ibøkha iz, ibøkhá qazømbe-etoumít. Geté ndego ibøkha iz, Nqova Mbomambaqapé gezømbé-etoumát.” ");
INSERT INTO kvg_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ta khøuwa-te ndøgo, até Yesú-a, Zion-te vø̄mat. Nazalet vemiav-té gendowáv, Gelili plovins-te ndøgo. Yaq até ndegó-a, Zion-te ibøkha iz vø̄ndap, Zoden kea-te ndøgo. ");
INSERT INTO kvg_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu ibøkha-te é-vøndo-fakhán-ae, yaq āv geneqeív nqǽgo: Yan gèmboqoé. Yaq Nqova Mbomambaqape ndovís. Andé kuvøkuvuam me me꞉løvuvavún, te-te. ");
INSERT INTO kvg_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Yaq yan-te ndo꞉go, manqa wag ndofakhán. Āv qande-eín nqǽgo, “Qo nogé Yó. No poev kandambá qo-te. No nø̀taqambo-khafuát.” ");
INSERT INTO kvg_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Taqa zita-te, Nqova Mbomambaqape, Yesu leg-av manqei-té genø-itú. ");
INSERT INTO kvg_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Khøuwa fotí, leg-av manqei-te geyagam. Yaq Saitan Yesu teme-khamasím ndǿgo. Yesu søvakha gigiap lozokhák namba me꞉yagám. Yaq enzol ezoqam tinduzavɨ́n ndǿgo, Yesu vømbō-tøkeemɨn. ");
INSERT INTO kvg_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Zion ndimbula-te gi꞉-utøvem, yaq Yesu Gelili plovins-té genøwáv, ezoqa Mbumbukiam-qa Manqat Mbomambaqape vømē-zømesim. ");
INSERT INTO kvg_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Āv gene-zømesimát nqǽgo, “Khøuwa mìzi-khantøzém. Mbumbukiam-qa Megeat Matev, avønín. É-mozoqambúz neka Mbumbukiam-qa Manqat Mbomambaqape vø̄-unimanqatinim!” ");
INSERT INTO kvg_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu Gelili kewan ndøgeg-te ge-ewat, yaq evenap menas tezømét ndǿgo, Saemon neka Endlu. Voe ndø-ogiát. Zapa ndǿgo, ndigu ezoqa menas, voe nqagim ezoqám. Ndøgo tiqá sasáe. ");
INSERT INTO kvg_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yaq Yesu gezø-ein, “Vø̀ndozáv. No zonøndó-paevém. Yaq zo ezoqa takhaset matev nøté-zømesím.” ");
INSERT INTO kvg_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yaq até gindigonem, voe sège-ivøvém, sasa mbopaevem. ");
INSERT INTO kvg_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu agé okhoeáv, evenap menas nøme tenøzømēt, Zems neka Zion. Ndigu Zebedi-gí nakheís. Khagua-té gunuguvám. Voe ndøpotofumát. ");
INSERT INTO kvg_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yaq ate ndigú-a, Yesu vøzø̄-akha. Yaq ndigu gèqá. Eve sège-ivøvém, tegi sasae ezoqam namba, Yesu vømbō-paevem. ");
INSERT INTO kvg_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu ekeza paev ezoqam namba, Kapenaum taon-té ginøzáv. Yaq Sabat khøuwa-te ndøgo, Zu ezoqam-qá guliguli khoev-té gemø-ón, ezoqa vømē-zømesim. ");
INSERT INTO kvg_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ezoqam ndigu, teqa nømendim manqat giyogem, mbøni zølév. Zapa ndǿgo, ndego Mbumbukiam-qá iz-té neka bazaføgakh-té gene-zømesím. Ambá av nqǣgo, av Mozes-qa guguna manqat nømendim ezoqam gi꞉zømesimam. ");
INSERT INTO kvg_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ta guliguli khoev-te ndøgo, ezoqa kopo mø̀ndu꞉goám. Ndego nqova soqa mbøigoám. Yaq ndego kandambaqapé sege-akhá, ");
INSERT INTO kvg_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yésu, Názalet-ak! Gê, qo ni gekha qonígū? Ni ngiænoat-qā qotøndóqav? No mø̀tenøtén, qo gekha ezoqām. Qo Mbumbukiam-gé Ezoqa Ndaføyamba-qapé.” ");
INSERT INTO kvg_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yaq Yesu ndego nqova soqa, gèmbøe-khafén, gembo-ein, “Qo manqat tía! Mòqotøndo-fakháq, qo nandav ezoqam-qa mokho-te ndoqotu꞉gu.” ");
INSERT INTO kvg_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Yaq ndego nqova soqa, até gendego, ndego ezoqam mø̀ndøkhæ-qantám, sùgumu-waguvupát, sasa ndøfakhan. Akhayam-ús, gendo-fakhan. ");
INSERT INTO kvg_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Yaq ezoqa ewaqape, nqova ndafe kandambá, neka yaqyaq-a gibond, “Nqanek gekha matêv? Teqa nømendim matev viní. Ndakinák, neka bazaføgakh-ús. Ngenek nqova soqøsoqa sègezømbe-khafenɨ́n, yaq ndigu teqa manqat o-mba vømbø̄e-ndapemɨn.” ");
INSERT INTO kvg_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yesu nqanek matev gego, yaq ndaføyambá, teqa emanqat sùgumu-panqavøemát, Gelili plovins-te ate qægoam. ");
INSERT INTO kvg_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu Zu ezoqam-qa guliguli khoev gendo-ivav, yaq Saemon neka Endlu, tiqá khoev-té genøwáv. Até Zems neka Zion, namba me꞉-apát. ");
INSERT INTO kvg_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Yaq khoev-te gimøfakhaz, Saemon-gu zimpuka, ngusu tatas enqoni mbovitát. Venanqei nonqo-té gubuvám. Yaq Yesu tøke-qa mboviømém, tuqa yaq-te. ");
INSERT INTO kvg_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yaq Yesu tenøwáv ndǿgo, zenda vømbōgea, neka vø̄-eqeiu. Yaq ngusu tatas enqoni, sègembo-navøém. Yaq ndugu até gundigu, lou vøzø̄ta. ");
INSERT INTO kvg_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Yaq khøuwa gumusinan ndøgo, ezoqa ewaqape, enqoni qazøgoam o nqova soqøsoqa gizømbu-goam, Yesu-té gindu-upøgím. ");
INSERT INTO kvg_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Vemiav-ak ezoqa ewaqape ndozáv. Khoev vimá ginømøváb. ");
INSERT INTO kvg_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yaq gekha enqonī, bugug vinivinimba qazøgoam, Yesu gèkhakhǽz. Ezoqa kopoáv. Neka nqova soqøsoqa kopoav, ezoqam-qa mokho-te gizømbu-goam, vøzø̄-ngeasam. Ndego nqova soqøsoqa takeáv, manqat timanqatat. Zapa ndǿgo, ndigu mø̀ndæzøtéz, ndego gekha ezoqām. ");
INSERT INTO kvg_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Khøuwa nøme qandopave, lovølova-ús, até gupøistám, Yesu gesùzām, khoev vø̄-ivav, ezoqam-av manqei-te sasa ndøwav, vømø̄-guligulim. ");
INSERT INTO kvg_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Yaq Saemon-za, gèmbovawát. ");
INSERT INTO kvg_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Yaq gi-ometam ndøgo, gimbo-einim, “Ezoqa ewaqape qoqa ndøvawét.” ");
INSERT INTO kvg_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Geté Yesu manqat gezø-qavøiu, “Ni até vemivemiav nøme-té-a, avønin nqagot, bìziniáv, Mbumbukiam-qa Manqat bamē-zømesim. Zapa ndǿgo, no ta zapaya nqánek qatøndenáv.” ");
INSERT INTO kvg_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yaq Yesu Gelili plovins ate ndǽgo sugumu-vatát, ezoqa tiqa guliguli khoev-te vø̄e-zømesimat, neka nqova soqøsoqa vøzø̄-ngeasumat, ezoqam-qa mokho-te gu꞉goat. ");
INSERT INTO kvg_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Khøuwa nøme, kha sisi-us ezoqam ndowáv. Yaq Yesu-qa megemege-te, katuk ndømøkuí, vømbōviam, “Ambá qokhakheinømbemín. Poev taqagoat, qo kopømbaqapé, toqo-khakheinømbem.” ");
INSERT INTO kvg_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yaq Yesu ngenek ezoqam tanakh mbogó, zenda vømbø̄eve, gembo-ein, “Nqanø̂poév. Qo vø̀khakhǽq.” ");
INSERT INTO kvg_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Yaq nqova mbaín, ndego ezoqam, kha sisi sègembo-navøém. ");
INSERT INTO kvg_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yaq Yesu ngenek ezoqam gèkhofotáv. Geté āv genegugú nqǽgo, ");
INSERT INTO kvg_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Qo ezoqa nøme zø̀-ei᷄n, av matev qaqambe-fakhan. Geté Mbumbukiam-gé iziz ezoqam-té qonǿqáv, bemø̄qamekh, neka Mbumbukiam-te etoam matev voqógō, av Mozes gezømbe-ein, kha sisi tøqa-navøem. Yaq ezoqa tìabiti-zøtéz, qo mòqo-eqeieqei-éq.” ");
INSERT INTO kvg_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Geté ngenek ezoqam gewav, ndego Yesu-qa manqat sège-vøndazát. Ezoqa ewaqape zømanqatát. Yaq ta zapaya ndøgo, Yesu kopømba mbaín, ezoqa ewaqape-qa bøi-te, vemivemiav-te vǿe-onimīt. Geté vemiav bavokho ndøgo, ezoqam-av manqei-té genø-qonumát. Geté ezoqa ta manqei vinivinimba-te giyagam, sègendo-okhoám, te-te. ");
INSERT INTO kvg_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Khapé outøpøteáv. Yaq Yesu Kapenaum taon-té genøveséz. Yaq ezoqa mø̀ndøyogém, av nqægo, ndego khoev-tē gegō. ");
INSERT INTO kvg_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Yaq gèndopindám te-te. Ezoqa kopoáv. Khoev ùnime꞉-khazém. Até bavokhó-a, mboqog-te ndo꞉go, løvøzupøteáv. Yaq Yesu Mbumbukiam-qá Manqat me꞉zømesimát. ");
INSERT INTO kvg_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ge꞉zømesimat, yaq ezoqa foa tìndizáv. Kagi ezoqam ndø-eqeitavún. ");
INSERT INTO kvg_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ambá Yesu-té ginø-eqeinamɨ́n. Geté ezoqa khàpumu-khouwéz, vǿe-ōz. Yaq até gindigonem, khoev ová ginøqavíg, yaq ova ndo꞉go, ma Yesu ge꞉qotam, nqa vømø̄-løozem, neka ndego enqoni-us ezoqam, kita-te geqeiam, sasa ndøføløtøvem. ");
INSERT INTO kvg_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu tiqa unimanqatin geqeiv, yaq ngenek kagi ezoqam, āv gembøe-eín nqǽgo, “Áti. Qoqa manqa-zapazapa mø̀ndøqa-navøém.” ");
INSERT INTO kvg_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Yaq Mozes-qa guguna manqat nømendim ezoqam, wambap-te giqonavam, ekeza mokho-mba āv gini-matavupát nqǽgo, ");
INSERT INTO kvg_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Gekha zapâ, ngenek av nge꞉manqate? Mbumbukiam-qá iz ndøngi꞉tít. Ezoqam-qa manqa-zapazapa, Mbumbukiam yakhapús, ndezø-evøzam.” ");
INSERT INTO kvg_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu é-møndæ-otév, av gi꞉matavupat. Yaq gezø-ein, “Zo gekha zapâ, zoqa mbøni-te av ndøzøte-matavupit? ");
INSERT INTO kvg_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Gê, gekha manqât ndøgo, føgakh mbain? Ndǿgò, no ngenek kagi ezoqam tæmbo-ein, ‘Qoqa manqa-zapazapa mø̀ndøqa-navøēm,’ o ndǿgò, tæmbo-ein, ‘Mòqo-itán, kita vø̄khazo, okho sasa ndøngaz?’ ");
INSERT INTO kvg_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Geté no ndakin nøtézømás, Ezoqam-ge Yo, bazaføgakh nqambôgó, ezoqam-qa manqa-zapazapa tezø-evøzam, nqanek manqei-qape-te.” ");
INSERT INTO kvg_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Yaq Yesu até gendego, ngenek kagi ezoqam āv gembøe-eín nqǽgo, “No nqataqá-manqate. Mòqo-itán, neka kita vø̄khazo, khoev-te sasa ndøqav.” ");
INSERT INTO kvg_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Yaq ndaføyambá, ngenek ezoqam sège-itán, kita vø̄khazo, bavokho sasa ndøwav. Ezoqa ewaqape até gembo-kewagát, gemat. Ndigu nqova ndafe kandambá, neka Mbumbukiam-qa iz vø̄-eqanem. Gi-einim, “Ni bugukhokhof matev av nqægo qeiviáv.” ");
INSERT INTO kvg_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Taqa zita-te, Yesu Gelili kewan-té genøveséz. Yaq ezoqa kandambá, gindupindam te-te. Yaq Yesu Mbumbukiam-qa Manqat vø̄e-zømesim. ");
INSERT INTO kvg_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yesu ta manqei ndøgo ge-ivav, nakhoa gegeveat, ezoqam ndø-omét. Teqa iz Livái. Alfius-gé yó. Teks upøgim khoev-qase mokho-té gunu꞉qotám. Yaq Yesu āv gembøe-eín nqǽgo, “No qonøndó-páev.” Yaq Livai até gendego, gè-itán, vømbōpaev. ");
INSERT INTO kvg_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Taqa zita-te, Yesu Livai-qa khoev-te, lou mølóg. Ta lou loge-te ndøgo, teks moni upøgim ezoqa nøme neka ezoqa nøme, ndigu manqa-zapazapa-us ndizæza, mø̀ndøgoám. Kopoáv. Yaq ndigu Yesu neka paev ezoqam, namba me꞉qonavát. Ezoqam av ngi꞉gu, kopoáv, Yesu gimbopavam. ");
INSERT INTO kvg_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Yaq Mozes-qa guguna manqat nømendim ezoqam, ndigu Felisi gizø-akhaemam, Yesu gi-ometam, ezoqam av ngi꞉gu, lou namba gi꞉logat, yaq ndigu tegi paev ezoqam, āv gezømbe-eín nqǽgo, “Gekha zapâ, ngenek teks moni upøgim ezoqam neka manqa-zapazapa-us ezoqam namba lou ndiloget?” ");
INSERT INTO kvg_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu tiqa manqat ge-ewag, yaq āv gezømbe-eín nqǽgo, “Ezoqam ndigu enqoni mbain ndigu, ndigu mulømula etoam ezoqam mbain tøgoat, kopømbá. Geté enqoni-us ezoqam bezøgó, mulømula etoam ezoqam. No ambá av nqǣgo, ezoqa eqeieqei akhayam-qa nøgeavūn. Geté no manqa-zapazapa-us ezoqam akhayam-qa nøgeavún.” ");
INSERT INTO kvg_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Khøuwa nøme, Zion-gi paev ezoqam neka Felisi ezoqam, lou logemav matev ndøgoát. Yaq ezoqa nøme tinduzáv ndǿgo, Yesu vømbō-bevøpem, “Gekha zapâ, Zion-gi paev ezoqam neka Felisi ezoqam, lou logemav matev gigoatun, getē qogi paev ezoqam gonemāv?” ");
INSERT INTO kvg_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yaq Yesu yaya zø-etá, taqa yaq-te, gezø-ein, “Ge zô ndozo-matavap, ezoqa sæva te-okɨ, yaq zifuap lou loge-te tekhatob, ndigu zifuap kopømbâ, lou logemav matev ndø̄gonem, ndego ti namba te꞉goat? Āv taoká. Ndego anganeam, zifuap namba zua tiqoqongeapet, ndigu kopømba mbaín, lou logemav matev tigoat. ");
INSERT INTO kvg_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Geté khøuwa ndø̀fakház. Yaq ndego ezoqam, ndego sævam ge-okɨ, ndø̀ndafém, ti namba nde꞉go. Yaq tegi zifuap lou logemav matev, ta khøuwa-te ndǿgo tinígoát. ");
INSERT INTO kvg_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ezoqa kopømba mbaín, ndabua mbewat ndakinak, awenege ndabua-te to꞉tøke. Av toqotego ndægo, yaq ndabua toqosunguz, ndabua ndakinak ndøgo, segé-khapelavøqasé. Yaq ndabua keqæv sa tømǿ-khouwév. ");
INSERT INTO kvg_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Neka ezoqa kopømba mbaín, waen ndakinak, awenege søvakha ngusum-te te-ewa. Zapa ndǿgo, awenege søvakha ngusum-te toqo-ewa, yaq waen tøpopon, ndigu gékeqáz. Yaq waen vǿqouvøēm, neka søvakha ngusum vǿsoqoēz. Geté waen ndakinak ndøgo, søvakha ngusum ndakinak-té qotúqóuz.” ");
INSERT INTO kvg_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Khøuwa nøme, Sabat khøuwá, Yesu ekeza paev ezoqam namba, wit khae livin-mbá gunu꞉-apát. Yaq tegi paev ezoqam, wit nanga ndøvingisømém, sasa ndølouz. ");
INSERT INTO kvg_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Yaq Felisi ezoqam tiqa matev giqeivim, Yesu āv gimbøe-einím nqǽgo, “Nqáe! Gekha zapâ, qogi paev ezoqam nqanek Sabat khøuwa-te sasae ngigut. Khafeáp nandav?” ");
INSERT INTO kvg_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yaq Yesu gezø-qavøiu, “Ge zô, emanqat mozó-geveømem, av Deivid ge꞉matanam, tegi ezoqam namba ifin qazøvin? ");
INSERT INTO kvg_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ta khøuwa-te ndøgo, Abiata Mbumbukiam-ge iziz ezoqam kandambaqape gegoam, Deivid Mbumbukiam-qá khoev-té genø-ón, flawa vømø̄louz, ndigu lou-qase-te go꞉-abam, Mbumbukiam-gi. Matev av nqægo khafeáp. Mbumbukiam-gí iziz ezoqam mba zø-mboqoatám, nginik flawa tilouzat. Geté Deivid sègelóuz, neka até ndigú-a, vøzø̄-etoam, te namba gi꞉goam.” ");
INSERT INTO kvg_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yaq Yesu nøme gezø-ein, “Mbumbukiam ambá av nqǣgo, ezoqa Sabat khøuwa nonqo ndøkhakheinøvēm. Geté ndego Sabat khøuwa, ezoqam nonqo ndøkhakheinám. ");
INSERT INTO kvg_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ezoqam-ge Yo, ndego kawá. Até Sabat khøuwá-ya, ndégo teno-kawaevát.” ");
INSERT INTO kvg_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Khøuwa nøme, Yesu Zu ezoqam-qa guliguli khoev-te gemat, ezoqa kopo mø̀ndu꞉goám ndøgo. Ndego pingim gèmbowáu. ");
INSERT INTO kvg_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Yaq ezoqa Yesu-te bøi mba mo꞉veém, ndego ngenek ezoqam peté-khakheinøvēm, penømakhaya, Sabat khøuwa-te. Zapa ndǿgo, ndigu Yesu manqa ovøyam-te vee-qa mbogoám. ");
INSERT INTO kvg_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yaq Yesu ngenek ezoqam pingim qambowau gembo-ein, “Qoté-itān, livin-mba nqøugu.” ");
INSERT INTO kvg_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yaq Yesu ezoqa ewaqape gezøbevap, “Gekha matêv ndøgo, Sabat khøuwa-te toqogo, kopømba? Ndǿgò, matev eqeieqei toqogo, o ndǿgò, matev soqain toqogo? Ndǿgò, ezoqa toqo-khandi꞉v, o ndǿgò, ezoqa pakhapakha toqokhana?” Geté ndigu yaq manqat qavøiwateáv. ");
INSERT INTO kvg_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu geqambunim, ezoqa vø̄zømet, ndego qaqa ndøgó, neka mbøni mbonqosøgím. Zapa ndǿgo, ndigu mokho qeiviáv. Yaq até gendego, ndego ezoqam gembo-ein, “Pingim qoté-ovøyām.” Yaq ndego ezoqam, pingim vø̄-ovøyam. Sègembo-eqeieqeí. ");
INSERT INTO kvg_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Yaq Felisi ezoqam, Yesu-qa matev giqeivim, ndigu sège-ivøvém, vø̄zav, yaq gaman ezoqam Elod, tegi ezoqam namba, vømø̄-møvab, manqat vø̄-einim, Yesu ande āv kinílaēm. ");
INSERT INTO kvg_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yaq Yesu ekeza paev ezoqam namba, Gelili kewan-té ginøzáv. Geté Gelili plovins-ak kopoáv, até gezøpavát. Até Zudia plovins-ák-a, ");
INSERT INTO kvg_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","neka Zelusalem taon-ak, neka Idumea manqei-ak, neka Zoden kea yaq-keoqa manqei-ak, neka Taya-yak neka Saedon manqei-ak, vøndō-okhoam. Ndigu tindi-okhoám ndǿgo, Yesu matev vinivinimba ge꞉matønumam, manqat giyogem. ");
INSERT INTO kvg_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yaq Yesu ekeza paev ezoqam, khagua khakheinam manqat zø-eín. Yaq tèabete-ketáo, ezoqa andé vǿe-nqonøtøvēm. ");
INSERT INTO kvg_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Zapa ndǿgo, ta khøuwa-te ndøgo, Yesu ezoqa kopoáv, gekhakheinøvem. Yaq enqoni-us ezoqa nøme, ezoqam gèqaqagimám, atema Yesu-te, kha vømbō-khanøzemɨn. ");
INSERT INTO kvg_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Yaq ezoqam ndigu, nqova soqøsoqa gizømbu-goam, Yesu gi-ometamɨn, ndigu Yesu-qa megemege-te, ekeza kha, manqei me꞉lavawɨ́n, vø̄-akhæmemɨn, “Qo Mbumbukiam-gé yó.” ");
INSERT INTO kvg_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Geté Yesu ndigu gèzømbe-khafén. Ezoqa bezø-manqàte᷄ av nqægo, ndego gekha ezoqām. ");
INSERT INTO kvg_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu manqei poyat-té genøqavíg, ezoqa vø̄møvab, ndigu ekeza ma qambøe-pøovam. Yaq ndigu te-te sasa ndøzav. ");
INSERT INTO kvg_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Yaq Yesu até gendego, ezoqa tuelv vø̄vevesam. Ndigu ezoqa tuelv, u-anim zø-akhá. Ndigu namba mé꞉goát. Yaq gékhofosám, ezoqam Mbumbukiam-qa Manqat vømé-zømesīm, ");
INSERT INTO kvg_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","neka bazaføgakh vøzǿ-etoām, yaq ndigu nqova soqøsoqa vǿngeasumāt, ezoqam-qa mokho-te tu꞉goat. ");
INSERT INTO kvg_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ezoqa tuelv gi-upøzo, ngínik: Saemón. Yaq Yesu iz nøme gembo-akha, Pitá. ");
INSERT INTO kvg_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Nøme Zéms neka Zión. Ndigu Zebedi-gí nakhéis. Yesu iz nøme gezø-akha, Boanezéz. Taqa manqa mokho, “Ndand nakhéis.” ");
INSERT INTO kvg_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Nøme gi-upøzo, Endlú neka Filíp, neka Batolomeú, neka Metiú, neka Tomás, neka Zéms. Ngenek Zems, Alfius-gé yó. Neka nøme Tadiés neka Saemón. Ngenek Saemon, Zelot ezoqam ndøgoám. ");
INSERT INTO kvg_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Neka nøme Zudas Iskaliót. Ezoqam ngének, vaev-te Yesu tegi qaqa ezoqam-qa zenda-te geve. ");
INSERT INTO kvg_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu khoev-te gevesez, yaq ezoqa kopoáv, nqawa gindupindam. Yaq Yesu tegi paev ezoqam namba, ambá lou ndølogɨ́n. Geté ezoqam khàpumu-khouwéz. ");
INSERT INTO kvg_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yesu-gi ekeza ezoqam, nqanek manqat giyogem, yaq tinduzáv ndǿgo. Ambá gekhatowemɨ́n. Zapa ndǿgo, ndigu até vø̄e-einim, gèkawakawaév. ");
INSERT INTO kvg_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Neka Mozes-qa guguna manqat nømendim ezoqam, Zelusalem taon-te ginduzav, āv gini-einím nqǽgo, “Ngenek Belzebul mbøigú, ndego nqova soqøsoqa-ge kawa. Teqá bazaføgakh-té genø-ngeasumatún, nqova soqøsoqa.” ");
INSERT INTO kvg_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yaq Yesu ndigu ezoqam gèmøváb, gezø-ein, “Manqat nandav, mokho mbaín. Gê, Saitan ekeza kha áv kené-ngeatām, ezoqam-qa mokho-te tu꞉goat?” Yaq Yesu yaya zø-etá, taqa yaq-te, gezø-ein, ");
INSERT INTO kvg_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","“Bawan kopo tigoat, yaq livin-mbā gunumú-qatønēm, izuizu nakhag vǿgonēm, ndigu sugumú-nasiním. ");
INSERT INTO kvg_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Neka evenap tigoat, yaq livin-mbā gunumú-qatønēm, izuizu vǿnøfē, yaq ndigu sugumú-nasiním. ");
INSERT INTO kvg_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Neka matev até kopó. Saitan ekeza kha livin-mba tumuqata, yaq ekeza kha namba vǿenøfē, ndego até segemǿ-navøém. ");
INSERT INTO kvg_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Neka nøme nqánek: Ezoqa kopømba mbaín, bazaføgakh ezoqam-qa khoev-te sa te-on, gigiap vømbó-aqonām. Geté ndego bazaføgakh ezoqam bètøkho-løvønøvém. Váev gigiap tembo-aqonam, teqa khoev-te. ");
INSERT INTO kvg_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","No unimanqatín nqazø-manqate. Gekha manqa-zapazapā ndøgo, ezoqa ndimatanam, até ndøgó-a, Mbumbukiam-qa iz ndingi꞉wat, ta manqa-zapazapa ndøgo, Mbumbukiam kopømbá, segembøé-navøém. ");
INSERT INTO kvg_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Geté ezoqa Nqova Mbomambaqape-qa iz tengiu, Mbumbukiam ta manqa-zapa ndøgo, gembøé-navøemák. Ndøgo miavmiáv, até gégoát.” ");
INSERT INTO kvg_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu nqanek manqat ge-ein, zapa ndǿgo: Mozes-qa guguna manqat nømendim ezoqam āv gini-einím nqǽgo, “Nandev nqova soqa mbøigú, teqa mokho-te.” ");
INSERT INTO kvg_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ta khøuwa-te ndøgo, Yesu-gu evo neka emekheis ndøfakház. Khoev vimá sogowán. Yaq manqat mba ndøkhofotøvém, av nqægo, Yesu yà betøndowáv. ");
INSERT INTO kvg_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ezoqa kopoáv, Yesu-qa avønin-te giqonavat. Ùnime꞉-khøogøvém. Yaq ezoqa gimbo-einim, “Nqáe! Qogu qavo neka qamekheis ngó꞉wani, bavokho. Qoqa mo꞉keogé.” ");
INSERT INTO kvg_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yaq Yesu gezø-ein, “Nogu evo neka nogi nqamekheis kinǿgoam?” ");
INSERT INTO kvg_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Yaq gèqambuním, ezoqa vø̄zømet, uni gi꞉khøogøvem, giqonavam, gezø-ein, “Nqáe! Nogu evo neka nogi nqamekheis ngínik! ");
INSERT INTO kvg_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Zapa ndǿgo, gekha ezoqām ndigu, Mbumbukiam-qa poev ndimbopaev, nogi nqamekheis neka evo ndígu.” ");
INSERT INTO kvg_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Khøuwa nøme, Yesu Gelili kewan-te ndøgo, zømesim manqat nqawa gengaz, ezoqa kopoáv gindupindam. Yesu ùnime꞉-khøogøvém. Yaq ndego khagua-té genøketáo, khagua elavøqase vø̄søkuz, sasa mo꞉qom. Ezoqa ewaqape, ndøgeg-té gigoám. ");
INSERT INTO kvg_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yaq ndego yaya etæ manqat zømanqatát. Kopoáv. Nøme gezø-eta, nqánek, ");
INSERT INTO kvg_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nqáe! Ezoqam mø̀ndøgoám. Khae-té genøwáv, wit nanga vømø̄-zøgeakh. ");
INSERT INTO kvg_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yaq wit nanga ge꞉panqabumat, nøme nakhoa-té ginø-o꞉atát. Yaq pipisi tindu-løvuvám ndǿgo, vø̄louz. ");
INSERT INTO kvg_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Geté nøme ndigu, nandi-té ginø-o꞉atát. Nandi-te ndøgo, manqei khapekhapémbá qatøke꞉pat. Yaq mbusa nakhamas-té ginø-fakhanøvém. Zapa ndǿgo, manqei andé mbaín. ");
INSERT INTO kvg_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Geté yaq, khøuwa gendosasev, mbusa ndigu gifakhatat, khøuwa tatas ndølouwáz. Yaq gèkusíz. Zapa ndǿgo, ndigu ngum uni mbunipøteáv. ");
INSERT INTO kvg_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wit nanga nøme, gapuk-té ginø-o꞉atát. Yaq gapuk ndøgo qa-eqa, ndigu gèvøtøgeám. Yaq louzi nonqo fakhazaneáv. Mbaín. ");
INSERT INTO kvg_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Geté wit nanga nøme ndigu, manqei eqeieqei-té ginø-o꞉atát. Yaq kopømbá gi-eqanat, nanga vø̄qataz. Wit nanga nøme ndigu, 30́, louzi nonqo gitøkebupat. Nøme ndigu 60́, neka nøme ndigu 100́.” ");
INSERT INTO kvg_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu nqanek yaya etæ manqat qamømbøe-navøem, yaq āv gezømbe-eín nqǽgo, “Gekha ezoqām ndego, gea tømbogoat neka yoge kopømba vømbógoāt, yà beyogé!” ");
INSERT INTO kvg_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ezoqa bawan-qape gi꞉zav, yaq Yesu-gi paev ezoqam tuelv neka ezoqa nøme gimbopavam, yaya etæ-qá manqa mokho mbobevøpém. ");
INSERT INTO kvg_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yaq gezø-ein, “Mbumbukiam zo mba zøtáke, mokho manqat tøzøte-zøtez, teqa Megeat Matev-qa yaq-te. Geté ezoqa nøme, no yaya mba nøzø-etǽ. ");
INSERT INTO kvg_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","No ndigu yaya mba tæzømbe-etǽ ndǿgo: Ndigu ndikeôgé. Geté géqeivimák. Neka ndigu ndiyôgé. Geté mokho géndapemák. Amba tiqeivimin neka mokho vø̄ndapemɨn, yaq ndigu ambá Mbumbukiam-té ginø-qambuzín, yaq ndego tiqa manqa-zapazapa vøzø̄-evøzamɨn.” ");
INSERT INTO kvg_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yaq Yesu ekeza paev ezoqam gezø-ein, “Gê, zo nqanek yaya etæ-qa manqa mokho ndapeâv? Yaq av tægoat ndægo, zo yaya etæ nøme-qa mokho áv khazøté-upøgīm? ");
INSERT INTO kvg_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Noqa yaya etæ-qa manqa mokho nqánek: Ezoqam ndego wit nanga gezøgeakhat, ndego Mbumbukiam-qá Manqat me꞉zømesimát. ");
INSERT INTO kvg_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wit nanga ndigu, nakhoa-te gi-o꞉atat, taqa manqa mokho nqánek: Ezoqa nøme, ndigu Mbumbukiam-qa Manqat giyogemɨn, Saitan até gendewavɨn, manqat vø̄e-vibamɨn, tiqa mokho-te tøu-ogeakhat. ");
INSERT INTO kvg_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Neka wit nanga ndigu, nandi-te gi-o꞉atat, taqa manqa mokho nqánek: Ezoqa nøme, Mbumbukiam-qa Manqat nakhamas-té ginø-ndapemɨ́n. Khanakhanakh-ús. ");
INSERT INTO kvg_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Geté ta manqat ndøgo, uni mbuvøemáv, tiqa mokho-te. Yaq ndigu føgøføgakh wanimáv. Mbumbukiam-qa Manqat zapaya, yage føgakh-qape o ngenøgim matev qazø-fakhanɨn, ndigu nakhamas-té ginø-o꞉azɨ́n. ");
INSERT INTO kvg_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Neka wit nanga nøme ndigu, gapuk-te gi-o꞉atat, taqa manqa mokho nqánek: Ezoqa nøme, Mbumbukiam-qa Manqat ambá giniyogé. ");
INSERT INTO kvg_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Geté ndigu fofogeap khàpe zømbe-khouwevɨ́n, tiqa yage zapaya, neka tiqa poev matev, gigiap kopoav neka matev vinivinimba-qa yaq-te, vø̄tubamɨn. Yaq Mbumbukiam-qa Manqat, tiqa mokho-te ndøugu, gèvøtagɨ́n. Yaq kopømba mbaín, mokho tømbo-fakhan. ");
INSERT INTO kvg_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Neka wit nanga ndigu, manqei eqeieqei-te gi-o꞉atat, taqa manqa mokho nqánek: Ezoqa nøme, Mbumbukiam-qa Manqat, ùnime꞉-yogemɨ́n neka manqa o-mba vømbø̄e-ndapemɨn. Yaq Mbumbukiam-qa Manqat, mokho mbófakhán. Kandambá. Ezoqa nøme-te 30́, neka ezoqa nøme-te 60́, neka ezoqa nøme-te 100́.” ");
INSERT INTO kvg_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yaq Yesu manqat nøme gezø-ein, “Gê, ezoqa lampa tøzøgoat, ndigu ndis o lou-qase mokho-té gunú꞉-wuøēm? Āv taoká! Geté lampa asøzam nonqo-té ginǿ-wuøém. ");
INSERT INTO kvg_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yaq até kopó. Gekha matēv ndøgo, ndøkhonøwe, bavokhó qandó-fakhanám. Neka gekha mokho manqāt ndøgo, ndøkhonøwe, segendó-veveám. ");
INSERT INTO kvg_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Gekha ezoqām ndego, gea tømbogoat neka yoge kopømba vømbógoāt, yà beyogé!” ");
INSERT INTO kvg_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yaq Yesu nøme gezø-ein, “Ùnime꞉-yogé, manqat nqæmanqate. Av zo gigiap o matev ndøzøte-geveam, Mbumbukiam zo āv tezømbé-geveám. Yaq Mbumbukiam-qa matev ndø̀mø-løvuám, av zo matev ndøzøte-matanam. ");
INSERT INTO kvg_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Gekha ezoqām ndego, mokho gendap, Mbumbukiam otevat nøme mba mbøé-etoám. Geté gekha ezoqām ndego, mokho ndapeav ndøgo, yaq Mbumbukiam até otevat-qasé-a, ndømbogo, segéviwám.” ");
INSERT INTO kvg_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu yaya nøme gezø-eta, nqánek. Gezø-ein, “Mbumbukiam-qa Megeat Matev, kopømba ande av nqǽgo: Ezoqa khae-te wit nanga tezøgeakh, ");
INSERT INTO kvg_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","yaq tebuvat, neka vǿsuzamāt, ndigu wit nanga yakhapus mokho-mbá segé-qatazát neka vǿfisamāt. Geté ndego gé꞉-otevák, ande āv kinífakhāz. ");
INSERT INTO kvg_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Manqei yakhapús, ewa qambo-etoamin, gifisamin. Bugukhokhof wit gagayag ndøfitamɨ́n, yaq wit nanga sasa ndøqatazɨn, yaq louzi nonqo vø̄gonɨn. ");
INSERT INTO kvg_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Yaq louzi nonqo gumu-fisamɨn, yaq ngenek avøe ogekhæm ezoqam tewavɨ́n ndǿgo, vømø̄-qogazɨn.” ");
INSERT INTO kvg_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yaq Yesu nøme gezø-ein, “Gê, Mbumbukiam-qa Megeat Matev, áv khazí꞉-khamasēm? Gekha yaya zí-etæēm, taqa yaq-te? ");
INSERT INTO kvg_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Masted tae nanga zí꞉khamasém. Manqei-te toqo-zøgeakh, yaq ndigu khapímbá. Āv tiuká, av tae nanga nøme ndi꞉gu. ");
INSERT INTO kvg_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Geté yaq giqatazin, mbusa vø̄fakhanɨn, yaq tae kandambá tøyat. Khae gigiap nøme mø̀ndø-løvuamɨ́n, neka tangtang kandakandá. Yaq ta tae tangtang guzuguzu-te ndøgo, kopømbaqapé, pipisi go꞉viviamɨn.” ");
INSERT INTO kvg_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu ezoqa Mbumbukiam-qa Manqat ge꞉zømesimam, yaya av nqægo kopoáv gezø-etæam. Yaq ndǿgo, ndigu mokho tìabembøe-ndapém. ");
INSERT INTO kvg_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ezoqa ewaqape, ndego yaya mba zø-etæám. Geté ekeza paev ezoqam namba, gimi-yakhapus-mba-ezɨn, ndego manqa mokho ate ndægo mø̀ndøzø-ovøyamɨ́n. ");
INSERT INTO kvg_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ta khagus ndøgo, Yesu ekeza paev ezoqam gezø-ein, “Kewan yaq-keoqá qazinǿ-qantáv.” ");
INSERT INTO kvg_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yaq ezoqam ndigu, namba gi꞉goam, ekeza vemivemiav-té ginø-khofosám. Yesu khagua-te é-møndøketáo, yaq até tegi paev ezoqám-a, vø̄ketab, yaq sasa ndøsøkuzim. Até khagua nømé-a, namba me꞉-áz. ");
INSERT INTO kvg_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yaq giqantavat, anana-mba mø̀ndu꞉bǿen, mbe-qape tāndōfeā, khamøe khagua sasa ndøngetøyam, ibøkha vø̄u-yovøem. Lokh bøi-té qanø-tøvøyát. ");
INSERT INTO kvg_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Geté Yesu khagua okho-te ndøgo, gèbuvám. Kawa kaoqa-té qamboveám. Yaq ekeza paev ezoqam gèti꞉nám, gimbo-einim, “Nøméndim ezoqam! Qo ni-te toqó-matavap? Ni avønín zígeón!” ");
INSERT INTO kvg_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yaq Yesu gendosuzam, vø̄-itan. Yaq até gendego, khamøe ndøgo, vø̄fegimam-a, vø̄vumøyat, manqat sasanqa-us mbo-eín. Yaq khamøe sègevøitáv. Qavøitav mbómā. Manqeí sege꞉veát. ");
INSERT INTO kvg_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yaq Yesu ekeza paev ezoqam gezø-ein, “Zo, gekha mbøni zǿva? Ge zô, Mbumbukiam unimanqatinteav sekembā sozógo?” ");
INSERT INTO kvg_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yesu matev av nqægo gematanam, yaq tegi paev ezoqam, møe kandambá gigonem, neka yaqyaq-a gibond, “Ngenek gekha ezoqâm? É, até khamøe fegim neka khamøe vumøe, manqat o-mba mbøendapé.” ");
INSERT INTO kvg_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu ekeza paev ezoqam namba, kewan yaq-keoqá ginøqantáv, Gelasa ezoqam-qa manqei-te vømø̄fakhaz. ");
INSERT INTO kvg_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu khagua-te é-vøndovuáo-ae, ezoqa nqova soqøsoqa-us é-vøndōwav. Nandi nqa-té gendo-fakhán. ");
INSERT INTO kvg_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ta nandi nqa-te ndøgo, løvøte ezoqam ndø-osupám. Ngenek ndǿgo teyagám. Ndego bazaføgakh kandambá. Até auli sén-a, kopømba mbaín, toqote-løvønøvem. ");
INSERT INTO kvg_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Khøuwa kopoáv, ezoqa ambá gini-løvønøvemám, bov-té neka pingim-te. Geté sen sègezø-løvusám. Ezoqa bazaføgakh-qape mbaín, vømbøé-khāz. ");
INSERT INTO kvg_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pavpave neká lovølova, ndego manqei-pakha-te neka manqei popotap-té genø-okhoám. Sugú-akhaemét neka ekeza kha nandí gene-qaqagumám. ");
INSERT INTO kvg_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yesu qámbá gegoam. Yaq ndego ezoqam Yesu ge-omet, gèndovuáo, Yesu-qa megemege-te, ekeza kha, manqei vø̄elavao. ");
INSERT INTO kvg_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Yaq ndego ezoqam, kandambaqapé møndæ-akhá, ge-ein, “Yésu, Mbumbukiam-ge Yo, ndego Eqeiwat-Qape, qo no gekha qonǿgō? Mbumbukiam-qa iz-te, nø̀taqa-viám, no nqosøgeap nø-etòa᷄m!” ");
INSERT INTO kvg_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ndego nqanek manqat ge-ein, zapa ndǿgo: Yesu āv gene-eín nqǽgo, “Qo nqova soqa, nandev ezoqam-qa mokho-te ndoqotu꞉gu, mòqotøndo-fakháq.” ");
INSERT INTO kvg_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yaq Yesu gembobevap, “Qo gekha îz?” Yaq gembo-qavøiu, “Noqa iz Bawan-qapé. Zapa ndǿgo, ni nqova soqøsoqa kopoáv.” ");
INSERT INTO kvg_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Yaq ngenek nqova soqa, Yesu āv gembøeviám nqǽgo, “Ni nqanek manqei-te nqeigu, ndøkhofòta᷄n.” Viam kandambá gego. ");
INSERT INTO kvg_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ta manqei avønin-te ndøgo, bøsi nen mø̀ndøwanám. Kopoav-qapé. Manqei poyat-té givagimám. ");
INSERT INTO kvg_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Yaq nqova soqøsoqa Yesu gimbo-viømem, “Ni bøsik-qá mokho-té qanø-khofotán.” ");
INSERT INTO kvg_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yaq Yesu sègezøták. Yaq ndigu nqova soqøsoqa até gindigonem, vø̄fakhaz, ndego ezoqam-qa mokho-te gu꞉goam, bøsik-te sasa mø-oz. Yaq bøsik manqei khavoe-té ginøbøín, ibøkha-te vømø̄-geonim. Bøsik kopoav-qapé, ande āv tu taosén ndægó, gigeonim. ");
INSERT INTO kvg_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Yaq ezoqam ndigu, bøsik gizø-kewagam, møe ndøbøín, yaq taon-te neka vemivemiav-te, ezoqa emanqat vømøzømbē-vototap. Yaq ezoqa tinduzáv ndǿgo, matev ndǿqeivím, ma qæfakhan. ");
INSERT INTO kvg_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yaq Yesu-te gifakhaz, matev āv giniqeivím nqǽgo: Ezoqam ndego nqova soqøsoqa gimbøigoam, geqotam, ndabua ndø-uzupám neka matavap kopømbá qambogoam. Yaq ndigu møe ndøgoném. ");
INSERT INTO kvg_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yaq ezoqam ndigu, matev bøi gi꞉qeivim, emanqat zømbe-vototáp, teqa yaq-te ndego, nqova soqøsoqa gimbøigoam, neka bøsik, matev ande āv khazømbē-fakhan. ");
INSERT INTO kvg_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Yaq ezoqa Yesu āv gimbøe-viømém nqǽgo, “Niqa manqei ambá qo-ivavɨ́n.” ");
INSERT INTO kvg_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu khagua-te ge꞉ketawat, yaq ezoqam ndego, nqova soqøsoqa gembo-ngeasam, te namba okho-qa mboviám. ");
INSERT INTO kvg_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Geté Yesu ndego takeáv, gembo-ein, “Qakeza khoev-té neka ezoqam-té qonǿqáv. Neka matev kandambaqape qaqafakhan, emanqat qozømbé-vototupát, av Mbumbukiam Evezøza geqambe-matanam neka tanakh āv keqambēgo.” ");
INSERT INTO kvg_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Yaq ndego ezoqam tènewáv. Ta vemiav ten ate qægoam, ekeza manqei-te, ezoqa sùguzumbu-manqatát, Yesu ande āv kembøē-matanam. Yaq ezoqa nqova ndafe kandambá, giyogem. ");
INSERT INTO kvg_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu kewan yaq-keoqa nqawa giqantavat, gimøqa, yaq ezoqa kopoáv gindupindam te-te. Ndego ndøgeg-te até gegoám, ");
INSERT INTO kvg_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","yaq Zu ezoqam-qa guliguli khoev megeat ezoqam ndowáv. Teqa iz Zailés. Yaq Yesu ge-omet, ndego teqa zenda tokhotapak-qa megemege-te, ekeza kha, manqei me꞉laváo, ");
INSERT INTO kvg_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","vømbōviam, gembo-ein, “Nogu yu avønín génaním. Ambá qotondo-qavɨ́n. Zenda qombøévé. Yaq ndugu enqoni tàbembøe-navøém neka tùabete-khandí꞉v.” ");
INSERT INTO kvg_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yaq Yesu ndego ezoqam, namba me꞉wáv. Yaq ezoqa kopoáv, segembo-paevém, neka sège-nqonondumát, teqa avønin-te. ");
INSERT INTO kvg_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ezoqam gi-apat ndøgo, sævam kopo mø̀ndu꞉goám. Ngunuk kouk mbowavám. Nupøkhán mbá. Viav ate qægoam, tuélv qambowavam. ");
INSERT INTO kvg_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ngunuk sævam, mulømula etoam ezoqam-te vinivinimba, ambá guni-okhoám, neka tugi moni ate gi꞉goam vō꞉ngiæzotam. Geté ndigu nqosøgeap mba mbo-etoumám. Tuqa enqoni navøepøteáv. Sà tønø-khouwevtát. ");
INSERT INTO kvg_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ngunuk Yesu-qa manqat mø̀ndø-ewág. Yaq ezoqa bawan-qape-qa mokho-te gu꞉goam, ndugu Yesu-qá zita-té gunduwáv, neka ndabua vømbō-khanaz. ");
INSERT INTO kvg_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Āv guni-matøvém nqǽgo, “No ngenek ndabua mba tæmbokhanaz, yaq no sǽ-eqeieqei-én.” ");
INSERT INTO kvg_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ndugu ndabua até é-vømbokhanáz-ae, yaq kouk waev sègembo-navøém. Yaq ndugu sège꞉-otév, ekeza kha-te, “Nqanek enqoni mø̀ndønø-navøém.” ");
INSERT INTO kvg_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu tene-otév ndǿgo, teqa bazaføgakh nøme, ezoqam-té qanøwáv, vø̄khakheinøvem. Yaq gèndoqambún, ezoqa ewaqape-qa mokho-te, gezø-ein, “No ndabua gekha ezoqām nǿkhanaz?” ");
INSERT INTO kvg_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yaq ekeza paev ezoqam gimbo-einim, “Ezoqam toqó-zømete, nginik qoqa avønin-te khape gindikhas? Yaq gekha zapâ, qo av qoqote-ein nqægo, ‘No kha gekha ezoqām nǿkhanaz?’” ");
INSERT INTO kvg_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Geté Yesu sekembá segevawám, av nqægo, kha uni gekha ezoqām mbókhanaz? ");
INSERT INTO kvg_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Yaq ngunuk sævam sègendowáv. Møe-ús. Kha sègembøi-wageapát. Zapa ndǿgo, ndugu mø̀ndæ-otév, ezoqa nó, matev qanøfakhan. Yaq ndugu Yesu-qa megemege-te, ekeza kha, manqei me꞉laváo, neka tuqa emanqat ate qægoam, vømbō-vøndaz. ");
INSERT INTO kvg_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yaq Yesu gumbo-ein, “Ngólam. Qoqa unimanqatin nandav, tø̀khakheinøqavém. Mòqoqáv. Qo mbøni betaqàva᷄ev. Enqoni mø̀ndøqa-navøém.” ");
INSERT INTO kvg_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu ate av-té manqat ge꞉manqatam, yaq Zailes-qa khoev-te, ndego Zu ezoqam-qa guliguli khoev gezømbo-megetam, ezoqam tinduzáv ndǿgo, vømbō-einim, “Qogu yu mø̀ndønaním. Nandev nømendim ezoqam, sekemba mbopòuwe᷄꞉t, tendowav.” ");
INSERT INTO kvg_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu tiqa manqat mø̀ndø-ewág. Geté guliguli khoev megeat ezoqam, āv gembøe-eín nqǽgo, “Qo ndøfofògea᷄p! Soqó-unimanqatín.” ");
INSERT INTO kvg_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu ezoqa nøme gèzømbe-khafén, te namba ti꞉zav. Geté ti-mba ndígu tekhatób, Pita neka Zems neka Zion, Zems-ge yakhasek. ");
INSERT INTO kvg_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Yaq guliguli megeat ezoqam-qa khoev-te gimøfakhaz, eiv neka osombo kandambá geqeiv. Manqa feazu khàpumu-khouwév. ");
INSERT INTO kvg_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yaq Yesu khoev-te ge-on, ezoqa āv gezømbe-eín nqǽgo, “Zo gekhā zǿ-eivumit? Neka gekha osombo zówanet? Ngunuk nakhasam nanimateáv. Geté gèbuvít.” ");
INSERT INTO kvg_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Geté ndigu Yesu gèvøngi꞉nám. Yaq Yesu ezoqa ewaqape gènatáz. Evøndipakha neka tegi paev ezoqam misika mba ndøkhatób, neka kouwat mokho-te vø̄-oz, ma nakhasam guigoam. ");
INSERT INTO kvg_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yaq Yesu até gendego, zenda vømbōgea neka ekeza manqat-te sasa mbo-ein, “Talita, kóum!” Taqa manqa mokho nqánek, “Khapúlav. Nqataqá-manqate. Mòqo-itán!” ");
INSERT INTO kvg_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Yaq ndaføyambá, ngunuk mbasønakam sège-itán, okho vø̄ngaz. (Ngunuk mbasønakam, tuqa viav tuélv.) Nqanek matev qafakhan, yaq ezoqa nqova ndafe kandambá. ");
INSERT INTO kvg_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Geté Yesu gèzømbe-khafén. Ezoqa nøme bezø̀-ei᷄n, av matev qæfakhan ndægo. Yaq ndego mbasønakam lou etoam manqat zø-eín. ");
INSERT INTO kvg_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu nqanek manqei ge-ivav, yaq ekeza vemiav-té genøwáv. Até ekeza paev ezoqám-a, namba me꞉-apát. ");
INSERT INTO kvg_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Yaq Sabat khøuwa qandap, ndego nømendim manqat ndøngáz, tiqa guliguli khoev-te ndøgo. Ezoqa kopoáv, teqa manqat giyogem. Neka ndigu nqova ndafe kandambá, gi-einim, “Ngenek ezoqam, otevat neka matavap loloakh gekham-tê gendap? Neka bazaføgakh gekham-tê gendap, umingiap matev vinivinimba ndematanam? ");
INSERT INTO kvg_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Gê, ngenek ndégò, khoev puanam ezoqam? Meli-gê yò? Zems neka Zosef neka Zudas neka Saemon, tigî zapikià? Neka até tegí sænakheís-a, ni namba zí꞉yage?” Yaq ndigu vemiav-ak, Yesu gèsanqawém. ");
INSERT INTO kvg_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Geté yaq Yesu gezø-ein, “Manqei nøme-te, Mbumbukiam-ge manqa vevezam ezoqam, gèmbovizáp. Geté ekeza manqei-te neka ekeza ezoqam-te, ndego vizupáv.” ");
INSERT INTO kvg_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ta manqei-te ndøgo, Yesu kopømba mbaín, umingiap matev tematanam. Geté zenda enqoni-us ezoqa kopokopo mba zømbø-awám, yaq ndigu vø̄khakhæz. ");
INSERT INTO kvg_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesu nqova ndafe kandambá, tiqa unimanqatin mbain matev-qa yaq-te. Yaq Yesu vemivemiav nøme-té genø-okhoám, ta manqei ndøgo, ezoqa vømē-zømesim. ");
INSERT INTO kvg_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yaq ekeza paev ezoqa tuelv gèmøváb, vøndōzav, yaq ndigu menømenas sasa ndøkhofosam, neka nqova soqøsoqa ngeasam nonqo bazaføgakh vøzø̄-etoam. ");
INSERT INTO kvg_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Āv gezømbe-eín nqǽgo, “Gigiap mbaín, sozó-panqaním. Tatuag mba zótonqogím, okho nonqo. Geté lou neka moqos neka moni ndøtonqògi᷄m. ");
INSERT INTO kvg_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Zo kopømbaqapé, tamak tozo-uzam. Geté ndabua nøme ndøtonqògi᷄m, sa nándav, nandozo-uzap.” ");
INSERT INTO kvg_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Neka nøme gezø-ein, “Zo ezoqa khoev tizø-einat, ta khoev-te ndøgo, até vøsokhoé. Yaq ta-mbá tøzøté-ivøvemát ndǿgo, vemiav nøme-te tozozavat. ");
INSERT INTO kvg_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Geté manqei nøme-te tozomø-fakhazat, yaq ndigu ezoqam zo khatobeav tøgoat neka zoqa manqat yogeav vǿgoāt, ta manqei ndøgo sège-ivøvemát. Yaq pakhakh ndøgo, zoqa zenda tokhotapak-te tøgoat, sozó-pomoememát. Yaq ndigu tìabiti-zøtezát, ni manqa-zapa zigonēm.” ");
INSERT INTO kvg_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yaq Yesu-gi paev ezoqam gèpanqaním, neka ezoqa Mbumbukiam-te qambuzan manqat vøzø̄-manqatat. ");
INSERT INTO kvg_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Yaq nqova soqøsoqa kopoáv, ezoqam-qa mokho-te gu꞉goat, gèzø-ngeasumám. Neka enqoni-us ezoqam, oil vøzømbō-qouzumam. Yaq ndigu sège-khakhæzɨ́n. Ezoqa kopoáv. ");
INSERT INTO kvg_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesu-qa manqat sège-panqavøemát. Até Elód-a, ndego Gelili plovins-ge kawa ezoqam gegoam, vø̄-ewag. Ezoqa nøme āv gini-manqatám nqǽgo, “Yesu, ndego Zión ategó, ndego ezoqam ibøkha iz gezø-etoumam. Ekeqa nangó gendo-khandí꞉v. Yaq nakémbá, ndego umingiap matev vinivinimba ndematanam.” ");
INSERT INTO kvg_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Geté ezoqa nøme gimanqatam, “Ilaizá ategó.” Neka ezoqa nøme gimanqatam, “Yesu ndego Mbumbukiam-gé manqa vevezam ezoqám, av ibugukhokhof gi꞉yagam.” ");
INSERT INTO kvg_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Yaq Elod nqanek manqat ge-ewag, ndego āv gene-eín nqǽgo, “Ngenek Zión ategó, no teqa monqo kepøzu manqat qævøovam. Nqawá gendo-khandí꞉v.” ");
INSERT INTO kvg_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Ta matev ndøgo, āv qanefakhán nqǽgo: Elod-gu zas Elodias, ndugu ibugukhokhof tege namba qawan Filip-gú zas ndøgoám. Yaq Zion Elod āv gembøe-manqatám nqǽgo, “Manqa-zapá nandav, qoge namba qawan-gu sævam qoqondaf.” Yaq Elod-qa qavøiwat, nakhag ezoqam ndøkhofotáz, Zion vø̄-møvøinam neka ndimbula-te vø̄-utøvem. ");
INSERT INTO kvg_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Elodias ndugu, qaqa mbogoám, Zion-te, teqa manqat zapaya. Yaq ndugu Zion løvøwe-qa mbogoám. Geté ndugu nakhoa qeiviáv, ande āv kumbøé-matanām. ");
INSERT INTO kvg_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Zapa ndǿgo, Elod møe ndøgoám, Zion-te. Ndego mø̀ndæ-otév, Zion ezoqam eqeieqeí neka ndaføyamba-qapé. Yaq Elod gèmbøe-vigimám. Elod, Zion-qa manqat, viniv ambá qambøe-etoumám. Geté ndego gèmbøe-khaneatám, teqa manqat ge-ewagam. ");
INSERT INTO kvg_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Geté vaev, Elodias khøuwa mbomambaqape tumø-khantáz ndǿgo, Zion-qa løvøte-qa yaq-te. Elod ge꞉qan, ta khøuwa iz gemø-khantaz, ndego lou kandambaqape ndølóg, gaman ezoqam kandakanda neka nakhag megetapak neka Gelili plovins-ak kandakanda namba. ");
INSERT INTO kvg_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Yaq ate av-té lou gi꞉logat, Elodias-gú yu ndo-ón, ogiam-ús. Yaq Elod neka ezoqa ewaqape, namba gi꞉logat, poev kandambá qazøwav, tuqa ogiam-te. Yaq Elod, ndego Zudia ezoqam-ge kawa, até gendego, mbasønakam vømbō-ein, “No unimanqatín nqataqa-manqate. Nøtaqambé-khavozák. Gekha gigiāp ndøgo, qo toqonø-viam, soqonǿ-eín. Yaq søtaqá-etoám.” ");
INSERT INTO kvg_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Yaq manqa mbusa āv genevé nqǽgo, “Unimanqatín. Gekha gigiāp ndøgo, qo taqapoe. Søtaqá-etoám. Qo toqonø-ein, av nqægo, no gigiap neka manqei ate ndægo, nqæmbo-keoge, livin-mba sa tøtumu-qata, neka nøme qo vøtaqá-etoām, ság. Yaq sǽgó.” ");
INSERT INTO kvg_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Yaq mbasønakam evo-té gunøwáv, vømbōbevap, “No gekha gigiap-qa manqat nombó-eīn?” Yaq evo gundu-ein, “Gigiap nqánek: Zion, ndego ibøkha iz etoam ezoqam, teqá kawa-qá manqat qombøé-eín.” ");
INSERT INTO kvg_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Yaq ndaføyambá, mbasønakam kawa ezoqam-té gunøveséz, vømbō-ein, “Noqa poev nqánek. Zion, ndego ibøkha iz etoam ezoqam, teqa kawa melek-té qotøndó-qonáv, ndakin.” ");
INSERT INTO kvg_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Elod nqanek manqat ge-ewag, yaq ndego khanakhanakh mbaín. Mbøni mbová. Geté ndego poeveáv, tuqa manqat tesanqao. Zapa ndǿgo, ndego manqa mbusa é-møndo꞉vé, taqa yaq-te, neka ezoqa ewaqape lou namba gi꞉logat, mø̀ndøyogém. ");
INSERT INTO kvg_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Yaq ndaføyambá, nakhag ezoqam ndøkhofotáv, ndimbula khoev-te, Zion-qa kawa vømøndó-ndāp. Yaq ndego nakhag ezoqam gèwáv, Zion-qa monqo vømø̄kepaz. ");
INSERT INTO kvg_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Yaq nqawa gendoqavan, kawa melek-té gendové, mbasønakam vømbō-etoam. Yaq mbasønakam evo sasa mbo-etoam. ");
INSERT INTO kvg_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Zion-gi paev ezoqam manqat giyogem, yaq ndigu tinduzáv ndǿgo, teqa kha vø̄ndapem, sasa mø-ozem. ");
INSERT INTO kvg_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu-gi u-anim, gekhofosam, nqawa gindu-vesezam, yaq te-te gindupindam, emanqat mbøe-vototém, matev ate ndægo gi꞉matønumam neka ezoqa vø̄e-zømesimam. ");
INSERT INTO kvg_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yaq Yesu āv gezømbe-eín nqǽgo, “Zo neka no, ezoqam-av manqei-té qazinǿ-niáv, vizimǿ-nikhapus-mokho-mba-ēn, neka pusa sasa zomǿtā.” Yesu nqanek manqat ge-ein, zapa ndǿgo. Ezoqa kopoáv, sege-vesendám, yaq vøndē-okhoam-a, yaq vø̄-okhoam. Yaq Yesu tegi paev ezoqam namba, kopømba mbaín, lou tilog. ");
INSERT INTO kvg_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Yaq ndigu khagua-té ginøketáb, ezoqam-av manqei-te sasa ndøtinim. Ambá gimi-yakhapus-mokho-mba-ezín. ");
INSERT INTO kvg_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Geté ezoqa kopoáv, é-møndøzømét, gisøkuzim. Yaq mø̀ndø-matøvemém, ande āv kinítinīm. Yaq vemiav vinivinimba ate qægoat, ezoqa gèndobøín. Zapá ginøzáv. Yaq é-vømø̄fakhaz, ma Yesu neka tegi paev ezoqam gimbøe-pøotat. ");
INSERT INTO kvg_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yaq Yesu gemø-asa, ezoqa bawan-qape mba mo꞉qeív. Yaq ndego tanakh zøgó. Zapa ndǿgo, ndigu ezoqam, andé síp, keoge ezoqam mbain tigøat. Yaq ndego nømendim manqat vinivinimba zøngáz. ");
INSERT INTO kvg_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Yaq qakhagus ndøgo, ekeza paev ezoqam tinduzáv ndǿgo, vømbō-einim, “Gèkhagustét, neka vemiav mbaín, nqanek. ");
INSERT INTO kvg_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ezoqam é-moqo-khofosám. Yaq vemivemiav neka khoev avøavun nqagot, ekeza lou bemø̄wi.” ");
INSERT INTO kvg_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Geté yaq Yesu manqa qavøiwat gezø-ein, “Lou zo zozǿ-etoám, tilog.” Yaq gimbo-einim, “Nakhoa mbaín. Taqa fia khàpumu-khouwév. Geté ni amba-té, 200 moni mokho tinigunin, amba lou teimø-wiin, nginik ezoqa zøkefe nonqo.” ");
INSERT INTO kvg_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yaq Yesu gezøbevap, “Gê, zo flawa gekhâ nandizøgo? Zøtézāv, neka zøtévawēm.” Yaq giqasem, gi-einim, “Flawa faév, neka zonga menas.” ");
INSERT INTO kvg_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yaq Yesu ekeza paev ezoqam gezø-ein, “Ezoqa ate nandi꞉gu, gagayag-té giabe-qoqongeapét.” ");
INSERT INTO kvg_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Yaq ndigu vø̄qoqongim. Bawabawan nøme-te, ezoqa 50́ giqonavat, nøme-te 100́. ");
INSERT INTO kvg_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yaq Yesu até gendego, nginik flawa faev neka zonga menas gè-upøzó, yan-te sasa ndøqan, Mbumbukiam ike manqat vømbō-ein. Yaq flawa gèmbegím, tegi paev ezoqam vøzø̄-etoam, ezoqa ewaqape-te etoam nonqo. Até zongá-ya, paev ezoqam vøzø̄-etoam, yaq ndigu ezoqa ewaqape sasa zø-etoam. ");
INSERT INTO kvg_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Yaq ezoqa ewaqape, lou tilóg ndǿgo, até vøzø̄-ewez. ");
INSERT INTO kvg_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Yaq flawa neka zonga mbegeap ndøgo, ezoqa gi-ivøvem, gèpizumém. Yakhav tuélv ginqeitømem, qamøvea. ");
INSERT INTO kvg_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ezoqa kopoav-qapé, nqanek lou gilog. Angana ate gi꞉goam, faev taosén. ");
INSERT INTO kvg_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yesu nginik ezoqa kopoav-qape, lou guzumbu-etoam, yaq até gendego, tegi paev ezoqam vøzø̄-ein, “Zo khagua-té qanøketáb, yaq-keoqa, Betsaida vemiav-te, vō꞉qantav. No nginik ezoqam ndø̀tokho-khofosám.” Yaq ndigu vø̄søkuzim, sasa ndøtinim. ");
INSERT INTO kvg_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yaq Yesu ezoqa gumu-khofosam, manqei poyat-té genøqavíg, vømø̄-guligulim. ");
INSERT INTO kvg_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Yaq qamupøis ndøgo, Yesu sekembá segegoám, manqei-te. Yakhapús. Geté tegi paev ezoqam, kewan livin-mbá gunu-tiamát. ");
INSERT INTO kvg_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yaq Yesu āv genezømét nqǽgo: Khamøe ndøsintavám. Yaq kave kandakandá sege-itimát. Yaq lova ande av 3 o 4 oklok ndægo, Yesu ekeza paev ezoqam-té genøwáv. Ibøkha mumát gono꞉mát. Yaq ndego tiqa khagua løvui-qa ndøgoám. ");
INSERT INTO kvg_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Geté ndigu Yesu gi-ometam, ibøkha mumat go꞉geavun, ndigu até vø̄e-einim, ndego gevøgēv. Yaq ndigu møe ndøzøgeá. ");
INSERT INTO kvg_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ndigu ate gi꞉goam, gi-ometam, møe kandambá gigonem. Geté Yesu nakhamas-té genøzø-akhá, gezø-ein, “Zo møe ndøgòne᷄m. Nó!” ");
INSERT INTO kvg_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yaq khagua-té gezømbu-ketáo. Yaq khamøe sègevøitáv. Yaq ndigu nqova ndafe kandambá. ");
INSERT INTO kvg_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ndigu mø̀ndæzøtéz, av nqægo, Yesu ezoqa kopoav-qape lou gezø-etoam. Geté ndigu mokho ndapeáv, teqa yaq-te. Matavap zua zøtokeapám. ");
INSERT INTO kvg_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yesu tegi paev ezoqam namba giqantav, yaq Genesalet manqei-té gimøfakház, vømø̄-asa. ");
INSERT INTO kvg_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Manqei-te givøvuam ndøgo, yaq ndaføyambá, ezoqa Yesu gèmatøvømém. ");
INSERT INTO kvg_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Yaq ndigu sège-panqaním, nakhamas-té, neka enqoni-us ezoqam vømøndō-upøgim. Gekha manqei-tē ndøgo, ezoqa Yesu-qa yaq-te giyogemɨn, ndigu enqoni-us ezoqam kita-té ginø-abamín, Yesu-te sasa ndø-upøgimin, ma ndego te꞉goat. ");
INSERT INTO kvg_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Neka gekha manqei vinivinimba-tē ndøgo, ge-okhoam, vemiav khasøkhasis-te neka vemiav kandakanda-te, ezoqa enqoni-us ezoqam, maket manqei-té ginø-upøgimín. Yaq Yesu āv gimbøe-viømemɨ́n nqǽgo, “Kopømbâ, nginik enqoni-us ezoqam, ndabua ov-qase mba tiqa-khanøzumat.” Yaq gekha ezoqām ndigu, ndabua gimbo-khanøzemin, ndigu sège-khakhæzɨ́n. ");
INSERT INTO kvg_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Khøuwa nøme, Felisi ezoqam neka Mozes-qa guguna manqat nømendim ezoqam ndozáv, Yesu-te. Zelusalem taon-té ginduzáv. ");
INSERT INTO kvg_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yaq āv giniqeivím nqǽgo: Yesu-gi paev ezoqa nøme, lou gilog, ndigu zenda uni sunguziáv, av Felisi ezoqam, ezoqa gi꞉zømesimam. ");
INSERT INTO kvg_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Nginik Felisi ezoqam neka Zu ezoqam ate gi꞉goam, lou logemáv, zenda uni sunguzumav tøgoat. Geté atanakha-zapazapa-za-qá matev mbopaevemɨ́n, taqa yaq-te. ");
INSERT INTO kvg_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Yaq ezoqam maket manqei-te gindu-qavazɨn, ndigu mø̀ndøkhæ-khakuamɨ́n, váev lou gilogɨn. Ndigu matev nøme kopoáv ndimbopaev, tigi atanakha-zapazapa-za-te gindu-upøgimam, kopømba ande av kap neka pot neka melek neka venanqei nonqo sunguzam matev.) ");
INSERT INTO kvg_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yaq ndigu Felisi ezoqam neka Mozes-qa guguna manqat nømendim ezoqam, Yesu gimbo-bevøpem, “Gekha zapâ ndøgo, qogi paev ezoqam nigi atanakha-zapazapa-za-qa matev pøpøvumav ndøgo? Ndigu bugukhokhof zenda uni sunguzumáv, lou gilogɨn.” ");
INSERT INTO kvg_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yaq Yesu gezø-qavøiu, “Mbumbukiam-ge manqa vevezam ezoqam Aezaya, unimanqatin manqat ndø-eín, zo khavozam ezoqam-qa yaq-te. Ndego āv gene-peawám nqǽgo, ‘Mbumbukiam ge-ein: Nginik no tou mbá ginømbe-vizáp. Geté tiqa mbøni qámbá no-te. ");
INSERT INTO kvg_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ndigu noqa iz, khokhó sege-eqawát. Zapa ndǿgo, ndigu ezoqam-qá nømendim matev mba me꞉zømesimít. Ambá noqā nømendim matev.’ ");
INSERT INTO kvg_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mbumbukiam-qa nømendim matev, zo mòzo-ivøvém. Geté ezoqam-qá nømendim matev zombopavét.” ");
INSERT INTO kvg_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yaq Yesu gezø-ein, “Mbumbukiam-qa nømendim manqat sanqawe neka zøkeza matev paev-qa yaq-te, zo ùni zøtezøtéz. ");
INSERT INTO kvg_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mozes āv gene-eín nqǽgo, ‘Qave neká qavo, gèzøvizáp. Gekha ezoqām ndego, eve o evo soqa manqat tembo-ein, ndego ezoqa, yà belaém.’ ");
INSERT INTO kvg_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Geté zo ndozo-manqate, ezoqa kopømbaqapé, eve o evo sa tembo-ein, av nqægo, gekha gigiāp ndøgo, no amba qo tøtaqa-etoamɨn, ndøgo Kobán. (Taqa manqa mokho, ‘Mbumbukiam-qá.’) ");
INSERT INTO kvg_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Zo av ndøzøte-manqate, yaq zo ezoqa evøndipakha tøkeam-qa yaq-te, zòzømbø-khazú. ");
INSERT INTO kvg_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yaq zo zøkeza nømendim matev mokho-te, atanakha-zapazapa-za-te qazo-upøgim, Mbumbukiam-qá Manqat zosanqawé. Neka zo matev av nqægo, kopoáv nandozogot.” ");
INSERT INTO kvg_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yaq Yesu ezoqa ewaqape nqawá genømøváb, gezø-ein, “Noqa manqat ùnime꞉-yogé, zo ate nqazøte꞉go, neka mokho vømbō-ndapem! ");
INSERT INTO kvg_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Gigiap ndøgo, ezoqam-te ndø-oev, kopømba mbaín, te꞉-manqa-zapa-us-ev, Mbumbukiam-qa bøi-te. Geté ndǿgo tené-manqa-zapa-us-év, matev neka manqat ndøgo, te-te ndøndo-fakhate.” ");
INSERT INTO kvg_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu nginik ezoqam gezivaz, neka khoev mokho-te vømø̄-on, yaq ekeza paev ezoqam, nqanek manqat mokho-qa yaq-te mbobevøpém. ");
INSERT INTO kvg_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yaq Yesu gezø-qavøiu, “Gê, até zó-a, manqa mokho upøgimâv? Ge zô, møzøté-zøtez? Gekha gigiāp ndøgo, ezoqam-te ndø-oev, ndøgo kopømba mbaín, te꞉-manqa-zapa-us-ev, Mbumbukiam-qa bøi-te. ");
INSERT INTO kvg_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Zapa ndǿgo, ta gigiap ndøgo, ambá av nqǣgo, mbøni-tē qanø-oeɨ́n, geté emu-té qanø-oeɨ́n, neka nqawa vømø̄-fakhanɨn.” (Nqanek manqat mokho-te, Yesu āv gene-eín nqǽgo: Mbumbukiam-qa bøi-te, lou ate ndægo eqeieqeí. Qoté-manqa-zapa-us-eq-ák.) ");
INSERT INTO kvg_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yaq Yesu gezø-ein, “Ezoqam ndǿgo tené-manqa-zapa-us-év, matev neka manqat ndøgo, te-te ndøndo-fakhate. ");
INSERT INTO kvg_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Zapa ndǿgo, ezoqam-qa matavap soqøsoqa, ndøgo matev soqøsoqa-te nakhoa ndøløwe, teqa mbøni-té qando-fakhaté. Ta matev soqøsoqa nqánek: Mambe matev, neka aqonam matev, neka ezoqa pakhapakha khaneam matev, ");
INSERT INTO kvg_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","neka nøkenøkem ngi꞉wat matev, neka gigiap qovetam matev, neka sanqambap matev, neka khavozam matev, neka sapi matev, neka ova matev, neka manqa ponqom matev, neka qakeza iz eqawat matev, neka kawakawa matev. ");
INSERT INTO kvg_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Matev nqanek ate ndægo, ezoqam-qá mokho-té qando-fakhaté. Yaq ezoqa ndǿgo tene-manqa-zapa-us-evɨ́n.” ");
INSERT INTO kvg_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu ta manqei ndøgo ge-ivav, yaq Taya taon avønin-té genøwáv. Yaq khoev-te gemø-on, ndego poeveáv ezoqa nøme ti꞉zøtez av nqægo, ndego ngêgō. Geté ndego kopømba mbaín tekhonawat. ");
INSERT INTO kvg_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ta manqei-te ndøgo, sævam mø̀ndøgoám. Tugu mbasønakam-yu, nqova soqa mbøigoám. Ngunuk sævam, Yesu-qa yaq-te até é-vøe-ewág-ae, vøndōwav, teqa zenda tokhotapak-qa megemege-te, ekeza kha, manqei vø̄elavao. ");
INSERT INTO kvg_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ngunuk sævam, bawan vini-ák. Glik sævám. Finisia taon-té guqán, Silia plovins-te ndøgo. Yaq ndugu Yesu āv gumbøe-viám nqǽgo, “Nogu yu, ambá nqova soqa qombo-ngeatamín?” ");
INSERT INTO kvg_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yaq Yesu gumbo-qavøiu, “Matev eqeieqeí mbá, nakheis-qa lou toqondap, yaq gaqo sasa qozǿnqagīm. Geté lou bugukhokhof nakheis betølóg, bezø̄-ewez.” ");
INSERT INTO kvg_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Geté yaq ndugu gundu-ein, “Evézøza. Nandav unimanqatín. Geté gaqo ndigu, lou-qase mokho-te ngu꞉sømbiap, lou khakhayakh ndølogatún, nakheis gi-ivøvemin.” ");
INSERT INTO kvg_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yaq Yesu gumbo-ein, “Qoqa manqat, mokho kandambá. Khoev-té qonǿqáv. Nqova soqa ndego, qogu yu-qa mokho-te gu꞉goam, mø̀ndømbo-fakhán.” ");
INSERT INTO kvg_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Yaq ndugu khoev-te guqavan, tukewág ndǿgo, mbasønakam-yu, venanqei nonqo-té gumbobuvám. Neka nqova soqa mø̀ndø-fakhán, tu mokho-te gu꞉goam. ");
INSERT INTO kvg_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu nqanek manqei Taya taon avønin-te ndøgo, nqawá genø-iváv. Yaq Saedon taon-té genøwáv, vømø̄løvu, Gelili kewan-te vømø̄-ova, neka vemiav ten manqei-te sasa ndøwav. ");
INSERT INTO kvg_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Yesu gefakhan ndøgo, yaq gea kandøgeap neka manqa-khou ezoqam ndøndafém, te-te. Yaq zenda awam-qa mboviømém. ");
INSERT INTO kvg_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yaq Yesu ndego ezoqam, ezoqa ewaqape-qa mokho-te gu꞉goam, manqei vini-té genøndáf, vømø̄-yakhapus-mokho-mba-ez. Yaq até gendego, kokosov gea nqa-te vømbōwasam, neka kokosov-te køse sasa ndøpisib, yaq nasam vømbō-khantav. ");
INSERT INTO kvg_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yaq Yesu yan-té genøqán, mbøni sekeqape vø̄fok, ekeza manqat-te ge-ein, “Efatá!” Taqa manqa mokho nqánek, “Sà bemboqoé!” ");
INSERT INTO kvg_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yesu nqanek manqat até é-vø-eín-ae, yaq ngenek ezoqam-qa gea gèmbo-mboqovøém, neka nasam kopømbá gembo-sasaetam, yaq ndego manqa manqate eqeieqei vø̄ngaz. ");
INSERT INTO kvg_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yaq Yesu ndigu ezoqam āv genegugúb nqǽgo, “Ezoqa nøme zø̀-ei᷄n, taqa yaq-te.” Ndego manqat kopømbá gegugubam. Geté ndigu teqa emanqat, nøme mba mo꞉vøndazát. ");
INSERT INTO kvg_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ndigu nqova ndafe kandambá, yaq gimanqatam, “Matev ate ndægo ndematanam, qanimav tantáv. Ezoqa gea qazø-kandøgeapam neka manqa-khou vø̄goam, ndigu ndakin kopømbá ndiyoge neka manqat ndimanqate.” ");
INSERT INTO kvg_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Khøuwa nøme, até nqawá, ezoqa kopoáv, Yesu-te gindupindam. Yaq ndigu lou mbaín, vǿelōg. Yaq Yesu ekeza paev ezoqam ndømøváb, gezø-ein, ");
INSERT INTO kvg_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“No tanakh nøzøgó, nginik ezoqam. Zapa ndǿgo, nginik no namba ngigu, khøuwa misiká. Yaq ndakin, ndigu lou mbaín. ");
INSERT INTO kvg_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","No ndigu ififin-us sa tækhofosam, ekeza vemivemiav-te, yaq bøi møzǿgugím, livin-qase. Ezoqa nøme, andé qámbá gindu-okhoam.” ");
INSERT INTO kvg_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yaq Yesu-gi paev ezoqam gimbo-qavøinam, “Gê, lou gekham-tē qazíqeivīm, nqanek ezoqam-av manqei-te, nginik ezoqam vizí꞉zøkēf.” ");
INSERT INTO kvg_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yaq Yesu gezøbevap, “Flawa gekhâm nandizøgo?” Ndigu gindu-qavøinam, “Flawa ate gi꞉goam sevén.” ");
INSERT INTO kvg_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yaq Yesu ndigu ezoqa bawan-qape, manqei-te qonam manqat zø-eín. Yaq até gendego, nginik flawa seven gè-upøzó, Mbumbukiam ike manqat vømbō-ein, sasa ndømbegim, ekeza paev ezoqam, ezoqa ewaqape etoam nonqo, vøzø̄-etoam, yaq ndigu sasa zø-etoam. ");
INSERT INTO kvg_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Até zonga khasøkhasís-a, vøzø̄goam. Khapémbá. Yaq Yesu Mbumbukiam-te ike manqat qambøeva, até nginik zongá-ya, ekeza paev ezoqam, ezoqa ewaqape etoam nonqo, vøzø̄-etoam. ");
INSERT INTO kvg_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Yaq ezoqa ewaqape lou tilóg ndǿgo, até vøzø̄-ewez. Yaq lou mbegeap ndøgo, ezoqa gi-ivøvem, gèpizumém. Kandambá qamøvea. Yakhav kandakanda sevén, ginqeitømem. ");
INSERT INTO kvg_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ezoqa kopoav-qapé, nqanek lou gilog. Angana ate gi꞉goam, ande āv fo taosén ndi꞉gú. Yaq Yesu ndigu ezoqam, ekeza vemivemiav-té genø-khofosám. ");
INSERT INTO kvg_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Yaq ndego até gendego, ekeza paev ezoqam namba, khagua-té ginøketáb, Dalmanuta manqei-te sasa ndøtinim. ");
INSERT INTO kvg_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Yaq Felisi ezoqam ndozáv, Yesu-te, neka te namba manqa itumbam vø̄ngazem. Ndigu matemateam-qa mbogoám. Neka ambá umingiap matev mboqeivimín, ndego uni Mbumbukiam-qa bazaføgakh tøpømbøégo-a. ");
INSERT INTO kvg_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Geté Yesu mbøni sekeqape ndøfók, gezø-ein, “Zo ezoqa ndakin nqazoyage, gekha zapâ, zo umingiap matev qeivi-qa ndøzøgo? No unimanqatín nqazø-manqate, zo umingiap matev zóqeivimák.” ");
INSERT INTO kvg_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yaq Yesu Felisi ezoqam tenøziváz ndǿgo, khagua-te vø̄ketao, yaq-keoqa sasa ndøqantav. ");
INSERT INTO kvg_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesu tegi paev ezoqam namba gi꞉qantavat, flawa kopo zømbu-khokhonavám, khagua-te. Nøme tonqozoateáv. Manqa matev zømbo-navøém. ");
INSERT INTO kvg_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yaq Yesu gezø-ein, “Aiyá qagó. Felisi ezoqam neka Elod, tiqa flawa poponøvem nonqo, gèmbøe-feazoát.” ");
INSERT INTO kvg_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yaq tegi paev ezoqam, āv ginibondát nqǽgo, “Ngenek nqanek manqat ekeqá tene-eín ndǿgo, ni flawa mbain nqazigu.” ");
INSERT INTO kvg_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu é-møndæ-otév, ndigu gekha manqat mē꞉bondat. Yaq gezø-ein, “Zo gekha zapâ, flawa-qa yaq-te nqazøte-fofogeap? Gê, zo sekemba sozó-bevupit, neka mokho ndapeâv? Gê, zoqa matavap gétokeap? ");
INSERT INTO kvg_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Zo bøi ndøzø̂gó. Geté zo qeivupáv. Neka zo gea ndøzø̂gó. Geté zo yogeapáv. Gèmbo-mataváp, ");
INSERT INTO kvg_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ta khøuwa-te ndøgo, no flawa faev qæmbegim, neka yaq ezoqa faev taosen vøtēzøkef. Zo yakhav ate qægoam gekhâm, lou mbegeap qazo-nqeitømem, ndøgo qamøvea?” Yaq gimbo-einim, “Yakhav ate qægoam tuélv, qeinqeitumem.” ");
INSERT INTO kvg_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yaq Yesu nøme gezø-ein, “Neka flawa seven qæmbegim, ezoqa fo taosen nonqo. Zo yakhav ate qægoam gekhâm, lou mbegeap qazo-nqeitømem, ndøgo qamøvea?” Yaq gimbo-einim, “Yakhav ate qægoam, sevén qeinqeitumem.” ");
INSERT INTO kvg_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yaq Yesu gezø-ein, “Yaq ge zô, gekha zapâ, noqa manqat-qa mokho sekemba qeivupav ndozogo?” ");
INSERT INTO kvg_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu ekeza paev ezoqam namba, Betsaida vemiav-te gimøfakhaz, yaq bøi waev mbain ezoqam ndondafém, neka Yesu te-te zenda awam-qa vømbō-viømem. ");
INSERT INTO kvg_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yaq Yesu ndego bøi waev mbain ezoqam pingi mbogeá, vemiav bavokho vø̄-itu. Yaq até gendego, teqa bøi-te, køse mbøe-pisíb, neka zenda sasa mbøeve, gembobevap, “Toqóqeivi?” ");
INSERT INTO kvg_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yaq ngenek ezoqam bøi ge-eqa, gembo-ein, “Ezoqam nqæzømêté. Geté nginik ngi-okhoet, andé tae nøteqeiví.” ");
INSERT INTO kvg_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yaq Yesu teqa bøi-te, zenda nqawá genøvé. Yaq ngenek ezoqam bøi gemboqoa, sègembo-eqeieqeí. Gigiap ate qægoam ùnime꞉-qeiváp. Bavokho-qapé. ");
INSERT INTO kvg_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yaq Yesu gembo-ein, “Qakeza khoev-té qanøqáv. Geté vemiav mokho-te ndø̀qa᷄v.” ");
INSERT INTO kvg_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu ekeza paev ezoqam namba, Sæzalia-Filipai taon avønin-té ginø-apát, vemiav vinivinimba qagoat. Ate av-té gi꞉-apat, yaq Yesu gezøbevap, “Gê, ezoqa no gekha ezoqām mé꞉næna?” ");
INSERT INTO kvg_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Yaq gimbo-einim, “Ezoqa nøme ndimanqate, qo Zión, ndego ibøkha iz etoam ezoqam. Neka nøme ndimanqate, qo Ilaizá, o Mbumbukiam-gé manqa vevezam ezoqá nømé, ndigu ibugukhokhof giyageapam.” ");
INSERT INTO kvg_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yaq Yesu gezøbevap, “Gemâ zo? No gekha ezoqām zøténæna?” Yaq Pita gembo-qavøiu, “Qo Mesayá.” ");
INSERT INTO kvg_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yaq Yesu ekeza paev ezoqam manqa āv gezømbe-løvuá nqǽgo, “Zo ezoqa nøme zø̀-ei᷄n, no gekha ezoqām.” ");
INSERT INTO kvg_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu tegi paev ezoqam, ekeza løvøte-qa yaq-te zømesim ndøngáz. Gezø-ein, “Ezoqam-ge Yo, nqosøgeap kandambaqape bendáp. Neka Zu megetapak neka Mbumbukiam-gi iziz ezoqa kandakanda neka Mozes-qa guguna manqat nømendim ezoqam bèsanqawém, sasa belaem. Geté khøuwa misika-qa zita-te, nqawa ndø̀khandí꞉v.” ");
INSERT INTO kvg_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu manqat bavokho-qapé gezø-ein, taqa yaq-te. Yaq Pita até gendego, Yesu sègekható, guguna manqat manqate vømbōngaz. ");
INSERT INTO kvg_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Geté Yesu, gèndoqambún, ekeza paev ezoqam vø̄zømet, Pita sasa mboponqom, gembo-ein, “Mòqoqáv qo, Saitan! Zapa ndǿgo, qoqa matavap nandav, ambá av nqǣgo, Mbumbukiam-tē qandowāv. Geté manqei-qape ezoqam-té qandowāv.” ");
INSERT INTO kvg_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yaq Yesu ezoqa bawan-qape ndømøváb, ekeza paev ezoqam namba, gezø-ein, “Gekha ezoqām ndego, no-te paev-qa ndego, ndego ekeza poev matev, zitá geabetewuá, neka ekeza tae mutui bē-eqa, neka no sasa benøndopaev. ");
INSERT INTO kvg_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Gekha ezoqām ndego, ekeza yage geawat-qa tegoat, ndego ndæ̀khambuá. Geté gekha ezoqām ndego, no neka Manqat Mbomambaqape zapaya, ekeza yage te꞉khambua, ndego ndø̀møqeív. ");
INSERT INTO kvg_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Gèmbo-mataváp. Ezoqa manqei-qape gigiap ate nqægo tømbogawam, yaq ekeza yage gēkhambuā, ta gigiap ate ndægo, áv khambøé-tøkē? ");
INSERT INTO kvg_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Neka gê, ngenek ezoqam, gekha fia ndǿgō, yage nango temendap? ");
INSERT INTO kvg_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Gekha ezoqām ndego, noqa yaq-te neka noqa manqat-qa yaq-te, mivi tegoat, nginik manqa-zapazapa-us ezoqam mokho-te, ndakin ngiyage, ndigu Mbumbukiam-te tøkebeav ndigu, yaq até Ezoqam-gé Yó-a, ndego mivi ndø̀gó te-te, Eve-qa waev neka bazaføgakh-te tegeav, Mbumbukiam-gi enzol ezoqam namba.” ");
INSERT INTO kvg_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yaq Yesu manqat nøme gezø-ein, “No unimanqatín nqazø-manqate. Zo ezoqa nøme, nqazo-waniap, naqanøká zópakhaezák. Geté Mbumbukiam-qa Megeat Matev ndòzotøkhæ-qeivím. Bazaføgakh-us ndǿgeáv.” ");
INSERT INTO kvg_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yaq khøuwa siks-qa zita-te, Yesu, Pita neka Zems neka Zion, manqei poyat-qape-té genø-itúb, vømø̄-yakhapus-mba-ez. Yaq Yesu-te gi꞉kewagam, ndego bugug sògo-enendtát, tiqa bøi-te, ");
INSERT INTO kvg_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","neka teqa ndabua vømømbō-papaqa-qape. Bøi sanqatøve-ús. Manqei-qape-te ate nqægo, ezoqa kopømba mbaín, ndabua tezunguz, vǿpapaqā, kopømba ande av teqa ndabua qægoam. ");
INSERT INTO kvg_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Yaq Ilaizā neka Mozes, sègezø-fakház. Yesu namba, manqat ndømanqatám. ");
INSERT INTO kvg_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Yaq Pita Yesu gembo-ein, “Nøméndim ezoqam. Qanimáv, ni nqeigu. Ni khoev-qasis misika nizǿpuán, qoqa kopo neka Mozes-qa kopo neka Ilaiza-qa kopo.” ");
INSERT INTO kvg_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita nqanek manqat khokhó sege-eín. Ndego otevateáv gekha manqat ndǿ-eīn. Zapa ndǿgo, ndigu møe ndøgoném. ");
INSERT INTO kvg_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Yaq ozoz ndokawá, vø̄gutaz. Yaq ta ozoz-te ndøgo, manqat ndofakhán. Āv qande-eín nqǽgo, “Ngenek nogé Yó. No poev kandambá te-te. Zo teqa manqat gèyogé.” ");
INSERT INTO kvg_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Yaq ndigu amba me꞉qambuním. Geté ezoqa nøme zømeteáv. Yesu mba ndø-ometám, ti namba ge꞉goam. ");
INSERT INTO kvg_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Yaq manqei poyat-te gi꞉visat, Yesu manqa āv gezømbe-løvuá nqǽgo, “Matev nqanek, zo qazoqeivim, ezoqa nøme naqanøká me꞉zø̀ma᷄s. Geté Ezoqam-ge Yo, løvøte-te bètøndokhæ-khandí꞉v.” ");
INSERT INTO kvg_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yaq ndigu teqa manqat gèkhatiwím. Geté yakhapus mokho-mba, āv ginibondát nqǽgo, “Ngenek løvøte-te khandi꞉vat-qa yaq-te, manqat ge-ein, taqa manqa mokho áv khanégo?” ");
INSERT INTO kvg_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Yaq Yesu gèmbo-bevøpém, “Gekha zapâ ndøgo, Mozes-qa guguna manqat nømendim ezoqam ndimanqate, av nqægo, ‘Ilaiza betøkho-fakhān.’?” ");
INSERT INTO kvg_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yaq Yesu gezø-qavøiu, “Unimanqatín, Ilaiza bugukhokhof ndø̀kho-fakhán, gigiap ate ndægo vǿkhakheinām. Geté Ezoqam-ge Yo-qa yaq-te, Mbumbukiam-qa Manqat nøme mozó-geveømem? Ndøgo āv qane-eín nqǽgo, ‘Ndego nqosøgeap kandambaqape ndǿqeív neka ezoqa gésanqawém.’ ");
INSERT INTO kvg_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Geté Ilaiza-qa yaq-te, no nqazǿ-manqate: Ndego mø̀ndø-fakhán. Yaq ezoqam ndego, āv timbøe-matønumát, av ndigu ekeza qazømbe-pøovam. Nqanek matev āv tønefakhán, av Mbumbukiam-qa Manqat teqa yaq-te qæ-ein.” ");
INSERT INTO kvg_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yaq Yesu, Pita neka Zems neka Zion namba, tegi paev ezoqa nøme-te nango ginduqavaz, givisavun, yaq tizømét ndǿgo, ezoqa kopoáv giwaniapam ti-te. Neka ndigu Mozes-qa guguna manqat nømendim ezoqam namba, manqa ndø-itumbumát. ");
INSERT INTO kvg_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Yaq ezoqa ewaqape, Yesu gi-ometam, ndigu nqova zøndáf. Yaq tinøbǿin ndǿgo, khaiya mboma manqat vømbō-einim. ");
INSERT INTO kvg_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yaq Yesu gezø-ein, “Gekha zapayā zøté-ponqombupit?” ");
INSERT INTO kvg_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yaq ezoqa tendowáv ndǿgo, manqat vømbō-ein, “Nøméndim ezoqam. No nøkeza yo notøndo-ndáf qo-te. Ndego nqova soqa mbøigú, neka manqa khóu. ");
INSERT INTO kvg_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nqova soqa gè-uvutumatún. Yaq manqei me꞉lavawɨ́n. Yaq køse møndæqouzín, teqa manqa-nqa-te, neka khaya vø̄vivisamɨn, neka kha vømbō-føgakhɨn. No qogi paev ezoqam, mø̀ezø-eín. Nqova soqa ambá gengeatømemɨ́n. Geté ndigu amba me꞉goném. Kopømba mbaín.” ");
INSERT INTO kvg_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yaq Yesu gendo-qavøiu, “Zo unimanqatin mbain ezoqam, zo ndakin nqazoyage, gê, no khøuwa andé gekhâm, zo namba tizi꞉yagat neka zoqa viniv vǿe-eqatāt? Geté ság! Opønakam vø̀ndo-ndafém.” ");
INSERT INTO kvg_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Yaq opønakam vøndō-ndafem. Yaq nqova soqa Yesu ge-omet, ndego até gendego, nakhasam vø̄-uvutam. Kha sègembøi-wageapát. Yaq nakhasam manqei-té genø-ogiú. Sège-qambinimát, neka manqa-nqa-te køse vømbō-qounat. ");
INSERT INTO kvg_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yaq Yesu eve gèmbobeváp, “Gekha khøuwā qambǿengaz?” Yaq ndego gendo-ein, “Ndǿgo, khapelavøqase ge꞉goam, tø̀mbøe-ngáz. ");
INSERT INTO kvg_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Khøuwa nøme, nqova soqa, gøinam-té neka ibøkha-té genø-nqagevemám. Laelae-qa mbogoám. Geté qo kopømba toqogoat, ambá tanakh qoniguɨ́n neka voqonī-tøkein.” ");
INSERT INTO kvg_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yaq Yesu gembo-ein, “Gekha zapâ, av nqoqote-manqate nqægo, ‘Qo kopømba toqogoat?’ Matev ate ndægo kopømbá, te-te ndego, nde-unimanqatinat.” ");
INSERT INTO kvg_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yaq nakhamas-té, ndego nakhasam-ge eve, āv gene-akhá nqǽgo, “No mø̀e-unimanqatín. Gènøtøké. Yaq no kopømbaqapé, tæ-unimanqatin.” ");
INSERT INTO kvg_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yaq Yesu geqeiv, av nqægo, ezoqa bawan-qape gèpindumīt, yaq ndego nqova soqa gèmboponqóm, gembo-ein, “Qo nqova soqa, manqa-khou neka gea kandøgeap, no nqataqá-manqate. Ngenek nakhasam mòqo-iváv, neka nango ndø̀-o᷄q, teqa mokho-te.” ");
INSERT INTO kvg_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yaq ngenek nqova soqa, gè-ogeá, neka nakhasam vø̄-uvutam. Kandambá ge-uvutam, sasa ndøfakhan. Yaq ndego nakhasam, andé løvøte bugug me me꞉kewagám. Yaq ezoqa nøme āv gini-einím nqǽgo, “Ndego mø̀ndønaním.” ");
INSERT INTO kvg_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Geté Yesu zenda mbogeá, sasa ndø-eqeiu, vø̄-itan. ");
INSERT INTO kvg_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yaq vaev-te, Yesu khoev-te ge-on, ekeza paev ezoqam namba gimi-yakhapus-mba-ez, ndigu gèmbo-bevøpém, “Ni gekha zapâ ndøgo, nqova soqa amba qati-ngeatømem?” ");
INSERT INTO kvg_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yaq Yesu gezø-qavøiu, “Nqova soqa av nge꞉go, guligulim mbá qoté-ngeatám.” ");
INSERT INTO kvg_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu ekeza paev ezoqam namba, nqanek manqei gi-ivøvem, yaq Gelili plovins mokho-té sugu-apát. Yaq ndego poeveáv, ezoqam ti꞉zøtez av nqægo, ndego gekham-tē gego. ");
INSERT INTO kvg_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Zapa ndǿgo, ndego ekeza paev ezoqam me꞉zømesimát. Gezø-ein, “Ezoqam-ge Yo, ezoqam-qá zenda-té ginǿveém, neka pakhapakha vømbó-khanøēm. Geté tenanim, yaq khøuwa misika-qa zita-te, nqawa ndø̀khandí꞉v.” ");
INSERT INTO kvg_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tegi paev ezoqam, nqanek manqat giyogem, ndigu manqa mokho ndapeáv. Geté møe ndøgoném, vømbøé-bevøpēm. ");
INSERT INTO kvg_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yaq Yesu, ekeza paev ezoqam namba, Kapenaum taon-té ginøzáv. Khoev-te gimø-oz ndøgo, yaq āv gezømbe-eín nqǽgo, “Zo nakhoa-te ndøgo, gekha zapayá qazøté-ponqombem?” ");
INSERT INTO kvg_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Geté ndigu yaq manqat qavøiwateáv. Zapa ndǿgo, nakhoa-te ndøgo, taqa yaq-te ndǿgo tini-ponqombém, ti mokho-te, iz akhae kandambaqape, gekha ezoqām ndǿgo. ");
INSERT INTO kvg_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yaq Yesu segeqóm ndǿgo, ekeza paev ezoqam tuelv, sasa ndømøvab, gezø-ein, “Gekha ezoqām ndego, megeat iz ndape-qa tegoat, ndego yà betøndo-páev, neka ndego ezoqa ewaqape-gé sasae ezoqam begó.” ");
INSERT INTO kvg_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yaq Yesu nakhasam ndo-itú, tiqa mokho-te livin-mba ndøugu vø̄ve, sasa ndøngenøtam, gezø-ein, ");
INSERT INTO kvg_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Gekha ezoqām ndego, noqa iz-te, nakhasam av nge꞉go tekhato, ndego no ndǿkhatómb. Neka gekha ezoqām ndego, no tekhatomb, ndego no mba gékhatombák, geté até ndegó-a, Mbumbukiam, no gendo-khofotan.” ");
INSERT INTO kvg_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Zion Yesu gembo-ein, “Nøméndim ezoqam. Ni ezoqam mø̀i-ometám. Ndego nqova soqøsoqa ndøngeasumatún. Qoqá iz-té genøgoatún. Yaq ni ndego nìmbøe-khafeném. Zapa ndǿgo, ndego ni namba okhomáv.” ");
INSERT INTO kvg_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Geté yaq Yesu gezø-qavøiu, “Mbøe-khafèa᷄p, ndego. Zapa ndǿgo, gekha ezoqām ndego, noqa iz-te umingiap matev ndematanam, ndego noqa iz nakhamas-te géngiuák. ");
INSERT INTO kvg_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Gekha ezoqām ndego, ni-te sanqaupav ndego, ndego nigí. ");
INSERT INTO kvg_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","No unimanqatín nqazø-manqate. Gekha ezoqām ndego, zo noqa iz-te, ibøkha-qase tezø-etoam, zapa ndø̄go, zo Keliso-gē ezoqām, ngenek ezoqam yaq-fia eqeieqei ndø̀møndáp.” ");
INSERT INTO kvg_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yaq Yesu manqat nøme gezø-ein, “Gekha ezoqām ndego, nakhei nqonqon av ngi꞉gu, ndigu no ndi-unimanqatinat, manqa-zapa-te te-itub, teqa manqa-zapa kandamba tantáv. Ndego amba nandi-qape monqo-te timbo-møpøtøzemɨn, kewan-te sasa mø-oginamɨn, yaq ta yaq-fia te-te ndego, ambá andé khapémbá. Geté yaq-fia kandambaqape ndǿgo, Mbumbukiam-te temøndap. ");
INSERT INTO kvg_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Qoqa zenda kopo, manqa-zapa-te tø-ituqabat, sègekepáz. Zenda kopo mba taqagoat, khandi miavmiav-te toqomø-oq, ndøgo kopømbá. Geté soqain ndǿgo, qo zenda menas taqagoat, yaq gøinam-tē qonǿqāv, ta gøinam ndøgo, khouvøemav ndøgo. ");
INSERT INTO kvg_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Neka qoqa zenda tokhotapak kopo, manqa-zapa-te tø-ituqabat, sègekepáz. Zenda tokhotapak kopo mba taqagoat, khandi miavmiav-te toqomø-oq, ndøgo kopømbá. Geté soqain ndǿgo, qo zenda tokhotapak menas taqagoat, yaq gøinam-tē gimǿ-ogeqænām. ");
INSERT INTO kvg_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Neka qoqa bøi kopo, manqa-zapa-te tø-ituqabat, sègekhofá. Qo bøi kopo mba taqagoat, Mbumbukiam-qa Megeat Matev mokho-te toqomø-oq, ndøgo kopømbá. Geté soqain ndǿgo, qo bøi menas taqagoat, yaq gøinam-tē gimǿ-ogeqænām. ");
INSERT INTO kvg_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ta gøinam-te ndøgo, nonqou ndigu, ezoqam-qa kha ndiloge, nasiniapáv, neka gøinam khouvøemáv. ");
INSERT INTO kvg_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Mbumbukiam-gi iziz ezoqam, te-te søvakha gigiap giløvusamɨn, gøinam-te, ndigu ngalam mo꞉geemɨ́n. Yaq ndǿgo, søvakha gigiap sège-eqeieqei-ín, Mbumbukiam-qa bøi-te. Yaq matev até kopó, matev føgøføgakh yà betøndo-fakhaté, ezoqa ewaqape-te, ndigu bemø̄-eqeieqei-ez, Mbumbukiam-qa bøi-te. ");
INSERT INTO kvg_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ngalam gigiap qanimáv. Geté mokhov tømømbo-navøem, yaq áv khoqotégō, nqawa ti-mokhov-us-ez? Zo ngalam bezømbu꞉gú, zo mokho-te. Neka sambi matev-té qanøyagé, yaqyaq-a.” ");
INSERT INTO kvg_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu ta manqei ndøgo ge-ivav, yaq Zudia plovins-te neka Zoden kea yaq-keoqá genøwáv. Yaq até nqawá, ezoqa kopoáv gindupindam, yaq ndego vø̄e-zømesim, av oskia ge꞉goam. ");
INSERT INTO kvg_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Yaq Felisi ezoqam ndozáv, Yesu-te. Ambá gembo-matemateømemín, gimbo-bevøpem, “Gê, Mozes-qa guguna manqat, áv khané-ein? Ezoqa kopømbâ, sævam sa te-ivav, ó, kopømba mbaîn?” ");
INSERT INTO kvg_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yaq Yesu gèzøbeváp, “Gê, zo Mozes gekha manqat zǿ-ein, taqa yaq-te?” ");
INSERT INTO kvg_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yaq gimbo-qavøinam, “Mozes āv gene-eín nqǽgo: Anganeam sævam ivøve-qa tegoat, ndøgo kopømbá. Sakhei zøuvis pepa bepeawám, bembō-etoam, ndugu sasa bekhofotav.” ");
INSERT INTO kvg_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yaq Yesu gezø-ein, “Mozes nandav manqat gepeawam, zapa ndǿgo: Zo khàpe zøtesapí꞉z. ");
INSERT INTO kvg_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Geté Mbumbukiam manqei-qape ande ge꞉khakheinam, ndego ezoqam, anganeam neká sævam, tèkhakheinøvém. ");
INSERT INTO kvg_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Yaq nakémbá, anganeam eve neka evo géziváz. Yaq zās namba mé꞉tøkuaném, ");
INSERT INTO kvg_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","yaq ndigu ezoqa menas, vømǿ-kha-kopo-ēz. Yaq ndakin ndigu ambá av nqǣgo, kha menās, av bugukhokhof gi꞉goam. Geté kha kopó. ");
INSERT INTO kvg_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ndigu Mbumbukiam ndøtøkuzú. Yaq ezoqa beqatø̀zo᷄.” ");
INSERT INTO kvg_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yaq Yesu tegi paev ezoqam namba, khoev-te givesez, ndigu gèmbo-bevøpém, taqa yaq-te. ");
INSERT INTO kvg_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yaq gezø-ein, “Gekha ezoqām ndego, sævam te-ivav neka sævam vini vǿ-okɨ̄, ndego manqa-zapa ndǿgó, zas-te. Ndego nøkenøkem matev ndǿngiú neka mambe mé꞉wáv. ");
INSERT INTO kvg_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Yaq até kopó. Sævam ndugu, zivis tu-ivav, anganeam vini vǿndāf, até ndugú-a, nøkenøkem matev ndǿngiú neka mambe mé꞉wáv.” ");
INSERT INTO kvg_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ezoqa nøme, Yesu-te, nakheis ndo-upøgím. Ndigu mø̀ndøzøpoé, Yesu ambá zenda zømbø-awamɨ́n. Geté tegi paev ezoqam gèzømbe-khafén, ndigu ezoqam. ");
INSERT INTO kvg_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu nqanek matev geqeiv, ndego khanakhanakh mbaín, ekeza paev ezoqam-te, gezø-ein, “Nakheis bègeáv no-te. Zømbo-khakhàza᷄m. Zapa ndǿgo, Mbumbukiam-qa Megeat Matev, tiqa ndígu, av nakheis ngi꞉gu. ");
INSERT INTO kvg_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","No unimanqatín nqazø-manqate. Gekha ezoqām ndego, Mbumbukiam-qa Megeat Matev khatiwiav tøgoat, av nakhei nqonqon ngi꞉gu, ndego teqa Megeat Matev mokho-te gemǿ-onák.” ");
INSERT INTO kvg_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yaq Yesu nginik nakheis, gè-upøgimám, zenda vøzømbø̄-awam, sasa zøguligulim. ");
INSERT INTO kvg_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu manqei ndøgo ge꞉-ivavtat, yaq ezoqa kopo tendotéit ndǿgo, Yesu-qa megemege-te, katuk vø̄møkui, gembo-ein, “Nøméndim ezoqam mbomambaqape. No gekha matev nómatønumāt, khandi miavmiav vøténdāp?” ");
INSERT INTO kvg_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yaq Yesu gembo-qavøiu, “Gekha zapâ no mbomambaqape ndoqote-næna? Ezoqa mbaín, mbomambaqape. Mbumbukiam mba me꞉gó. ");
INSERT INTO kvg_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Qo Mbumbukiam-qa guguna manqat mòqote-qatéq, av qæ-ein nqægo, ‘Qo ezoqa pakhapakha zøkhanèa᷄m. Neka nøkenøkem matev ndøngì꞉wa᷄t. Neka ndø-aqòna᷄m. Neka meakha manqat ndømanqàte᷄. Neka khavozam matev ndø̀go᷄. Qavē neka qavo, gèzøvizáp.’” ");
INSERT INTO kvg_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Yaq ngenek ezoqam gendo-ein, “Nøméndim ezoqam. Nqanek guguna manqat ate ndægo nqæmbôpáev, no khapelavøqase qategoam, atema ndakin.” ");
INSERT INTO kvg_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yaq Yesu ngenek ezoqam, gèwawám, kuku matev-ús, gembo-ein, “Qanimáv. Geté matev kopo nøme nqánek qoqógó. Vø̀khæqáv. Yaq gigiap ate nandaqambe꞉go, qomǿwí. Yaq moni ndigu toqoqas, gigiap-av ezoqam qozǿ-etoám. Av toqotego ndægo, yaq qo gigiap qaniqanim, yan manqei-té qoqonǿ-møvøemét. Yaq vø̀ndoqáv. No qonøndó-páev.” ");
INSERT INTO kvg_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yaq ndego nqanek manqat ge-ewag, ndego avus-mba mbovoé. Yaq sègewáv. Mbøni vaev-ús. Zapa ndǿgo, ndego gigiap kopoáv qambogoam. ");
INSERT INTO kvg_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yaq Yesu geqambunim, ekeza paev ezoqam sasa ndøwabam, gezø-ein, “Gigiap kopoav ezoqam, ti-te ndigu unimé꞉-føgákh, Mbumbukiam-qa Megeat Matev mokho-te tu꞉-oz.” ");
INSERT INTO kvg_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yaq tegi paev ezoqam nqanek manqat giyogem, ndigu nqova ndafe kandambá. Geté Yesu manqat, nqawá genøzø-eín, “Nogi nakheis. Nakhoa føgakh-qapé, Mbumbukiam-qa Megeat Matev mokho-te toqotu-oq! ");
INSERT INTO kvg_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kemol ndugu, søvakha gigiap kandambaqapu, mil nqa-te one-qa tugoat, tu-te ndugu føgakh andé mbaín, av gigiap kopoav ezoqam-te føgakh ndægo, ndego Mbumbukiam-qa Megeat Matev mokho-te one-qa tegoat.” ");
INSERT INTO kvg_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yaq Yesu-gi paev ezoqam, nqova nøme mba zømbondáf, neka yaqyaq-a gibond, “Av tægoat ndægo, yaq gekha ezoqām ndǿkhandī꞉v?” ");
INSERT INTO kvg_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yaq Yesu ti-te gekewag, gezø-ein, “Matev av nqægo, ezoqa kopømba mbaín. Geté Mbumbukiam, ndego viní. Matev ate ndægo, ndego kopømbaqapé tego.” ");
INSERT INTO kvg_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Yaq Pita Yesu gembo-ein, “Nqáe! Ni gigiap ate qægoam, zitá qati-wuøém, qo nqeitaqambe-paev.” ");
INSERT INTO kvg_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yaq Yesu gezø-ein, “No unimanqatín nqazø-manqate. Gekha ezoqām ndego, khoev te-ivav, o namba-qaniap o evo o eve o nakheis tezivaz, o khae te-ivav, no zapaya neka Mbumbukiam-qa Manqat Mbomambaqape zapaya, ");
INSERT INTO kvg_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ndego Mbumbukiam ndakin yage-te nøme mba mbøé-etoám, kopoav-qapé, wan andléd ate tægoat, khoev, neka namba-qaniap, neka evøndipakha-sæv neka khae. Geté ndego até ngenøgim matév-a vǿndāp, no zapaya. Yaq megemege-te ndo꞉go, ndego khandi miavmiav ndǿndáp. ");
INSERT INTO kvg_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Geté ezoqa kopoáv, ndigu ndakin nduo-megetap, gendópavát. Neka ezoqa kopoav, ndigu ndakin ndindopaev, gó꞉megetát.” ");
INSERT INTO kvg_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu ekeza paev ezoqam namba nakhoa gigeveat, Zelusalem taon-te giqavigat, ndego gèzømbo-megetát. Yaq tegi paev ezoqam, nqova zøndáf neka mbøni zøvá, taqa yaq-te. Até ezoqa nømé-a, namba gi꞉-apat, møe ndøgoném. Yaq Yesu ekeza paev ezoqam tuelv, nqawá genøkhatób, vømø̄-yakhapus-mba-ez, neka matev-qa yaq-te, ndøgo Zelusalem taon-te tømømbo-fakhan, sasa me꞉zømas, ");
INSERT INTO kvg_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","gezø-ein, “Nqáe! Ni Zelusalem taon-té qazinø-qavigít. Yaq Zelusalem taon-te ndøgo, Ezoqam-ge Yo, Mbumbukiam-gi iziz ezoqa kandakanda neka Mozes-qa guguna manqat nømendim ezoqam-qá zenda-té gimǿveém. Yaq ndigu manqa ovøyam-te sasa ndǿveēm, manqat vǿkopo꞉nēm, av nqægo, yà benanīm, neka manqei vini-ak-qa zenda-te vǿveēm, ndigu Mbumbukiam zøtezateav ndigu. ");
INSERT INTO kvg_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Yaq ndigu otøotam mé꞉vewém neka køse vømbøé-pisibømēm, teqa kha-te, neka vǿzuīm, pakhapakha sasa mbókhanøēm. Geté khøuwa misika-qa zita-te, ndego nqawa ndø̀khandí꞉v.” ");
INSERT INTO kvg_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zems neka Zion, ndigu Zebedi-gi nakheis, tinduzáv ndǿgo, Yesu manqat vømbō-einim, “Nømendim ezoqam. Nitaqá-viømém. Kopømbâ, niqa poev matev toqogo.” ");
INSERT INTO kvg_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yaq Yesu gezø-ein, “Zo gekhā zǿpoev, no tæzøgo?” ");
INSERT INTO kvg_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Yaq gimbo-einim, “Niqa poev nqánek. Qo megeat iz kandambaqape toqomøndap, yaq ni ambá qo namba zimi-qonavɨ́n, ezoqa nøme, qoqa nakeamo zenda-te vǿqōm, neka ezoqa nøme, qoqa yogea zenda-te vǿqōm.” ");
INSERT INTO kvg_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Geté Yesu gendo-qavøiu, “Zo zø̀tezøtezák, gekha matev-qa zonø̄-einim. Gê, zo kopømbâ, ibøkha khaqain-qape tozo-izam, av no tøte-iz? Neka ibøkha iz ndøgo, no tændap, kopømbâ tozo-upøgim?” ");
INSERT INTO kvg_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yaq gimbo-einim, “Ni kopømbaqapé.” Yaq Yesu gezø-ein, “Zo ibøkha khaqain-qape ndòzomø-izám, av no tøte-iz. Neka zo ibøkha iz ndòzomø-upøgím, av no tøtendap. ");
INSERT INTO kvg_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Geté gekha ezoqām, noqa nakeamo zenda neka yogea zenda-te timøqonav, ambá av nqǣgo, nō nǿvevesām. Geté ta qonam nonqo, tiqa ndígu tǿgoát, Mbumbukiam gevevesam.” ");
INSERT INTO kvg_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yesu-gi paev ezoqa ten nøme, nqanek manqat giyogem, yaq qaqa ndøgoném, Zems neka Zion-te. ");
INSERT INTO kvg_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yaq Yesu ekeza paev ezoqam tenø-møváb ndǿgo, gezø-ein, “Zo mø̀zøte-zøtéz. Ezoqa ndigu, bawan vinivinimba, kawakawa-za ndizæza, ndigu ezoqa gètokhonøzát. Neka tigi megetapak, gò꞉kawaezát, av ekeza poev ndøzømbe꞉go. ");
INSERT INTO kvg_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Geté zo mokho-te, matev av nqægo bègo᷄. Gekha ezoqām ndego, zo mokho-te iz kandambaqape ndape-qa tegoat, ndego yà be-zoge-tøke-ezoqam-év. ");
INSERT INTO kvg_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Neka gekha ezoqām ndego, zo mokho-te megeat-qa tegoat, ndego andé ezoqa ewaqape-ge yaq-fia mbain sasae ezoqam bezømbegó. ");
INSERT INTO kvg_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Até Ezoqam-gé Yó-a, ndego matev até kopó. Ndego ambá ndø̄go tenegeavūn, ezoqa sasae timbogoat neka vømbó-tøkeāt. Geté ndego ezoqa tøke-qa neka teqa kha løvøte-te vee-qa ndøgeavún. Yaq ezoqa kopoav, tèabete-nqovotáz.” ");
INSERT INTO kvg_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu tegi paev ezoqam namba, Zeliko taon-te gimøfakhaz, yaq nqawa gi-ivøvem, ezoqa kopoáv, namba gi꞉zav. Yaq ate av-té nakhoa gi꞉geveat, keoqa-te ndøgo, bøi waev mbain ezoqam mø̀ndøqotám. Teqa iz Batimeús. Timeus-gé yó. Ndego ezoqa gigiap-qa zøvi꞉mám. ");
INSERT INTO kvg_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yaq ge-ewag av nqægo, Yesu, ndego Nazalet-ak ngēma, yaq ndego sège-akhá, “Yésu. Déivid-ge Zeo. No tanakh gènøgó.” ");
INSERT INTO kvg_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Yaq ezoqa kopoáv, gèguguím, “Qo manqat tía.” Geté ndego kandakanda nøme mba mo꞉-akhayám, “Déivid-ge Zeo. No tanakh gènøgó.” ");
INSERT INTO kvg_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yaq Yesu sège-itán, manqat vø̄-ein, “Ezoqam nandev, yà betøndowáv, no-te.” Yaq ezoqa ndego bøi waev mbain ezoqam gèmbo-akhaém, gimbo-einim, “Qo khanakhanakh mbá qanegó. Qó-itán. Yesu ndeqandó-akhayam.” ");
INSERT INTO kvg_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yaq ndego até gendego, ekeza ndabua sekeqape, manqei-té genø-ogí. Yaq sasanqá sege-itán, Yesu-te vø̄wav. ");
INSERT INTO kvg_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yaq Yesu gembo-ein, “Qo gekhā qápoe, no tøtaqa-matanam?” Yaq ndego bøi waev mbain ezoqam gendo-ein, “Nøméndim ezoqam. No bøi keoge-qa nøgó.” ");
INSERT INTO kvg_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yaq Yesu gembo-ein, “Qanimáv. Mòqoqáv. Qoqa unimanqatin nandav, tø̀khakheinøqavém.” Yaq ndaføyambá, ngenek ezoqam gèkewág, neka Yesu vømbōpaev, nakhoa-te gi-apat. ");
INSERT INTO kvg_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu ekeza paev ezoqam namba, Zelusalem taon gi꞉khatoat, yaq Betfage neka Betani vemiav-te gimøfakhaz, Oliv manqei pøyat-te ndøgo, ndego paev ezoqa menas tène-khofotáz, ");
INSERT INTO kvg_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","gezø-ein, “Tozonǿzáv ndǿgo, vemiav zoqa megemege-te ndo꞉go. Tozomø-oz, yaq ndaføyambá, zo donki nakhasam zomǿ-ometám. Gémopotavát. Ta donki nakhasam-qa zita-te ndo꞉go, ezoqam bugukhokhof qomateáv. Yaq sozó-nqovotøvém, sasa zotøndó-ituīm. ");
INSERT INTO kvg_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Geté ezoqa tezøbevap av nqægo, ‘Gekha zapâ, ngunuk donki nqazo-nqovotavet?’ Yaq zo āv qazømbøé-einím nqǽgo, ‘Evezøza mbopóe, ngunuk. Yaq ndego nakhamás, nango ndø̀zøndo-khofotáv.’” ");
INSERT INTO kvg_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yaq nginik paev ezoqam gizav, donki nakhasam mø̀ndø-ometám. Khoev mboqog tambav-té gumopotavám. ");
INSERT INTO kvg_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Yaq ezoqa nøme, giwaniapam ndøgo, gèzøbeváp, “Zo gekhā zógot? Gekha zapâ, nanduv nandozo-nqovotavet?” ");
INSERT INTO kvg_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yaq paev ezoqam, manqat āv tizimbi-eín, av Yesu gezømbe-ein. Yaq ndigu sègezøták. ");
INSERT INTO kvg_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Yaq donki ndugu, Yesu-té gindu-ituím. Yaq até gindigonem, ekeza ndabua donki-qá zita-té gimbøe-khafuzím, Yesu vō꞉qom. ");
INSERT INTO kvg_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yaq ezoqa kopoáv, Yesu-qa megemege-te, ekeza ndabua mo꞉møtagát, nakhoa-te, neka ezoqa nøme vuv vøndōqogaz, sasa mo꞉møtag. ");
INSERT INTO kvg_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yaq ezoqa nøme Yesu-qa megemege-te vō꞉megetam-a, nøme vøndōpavam, ndigu āv gini-akhaemát nqǽgo, “Hosána! Iké꞉ Mbumbukiam-te! Ndego ngenek ezoqam bèkhakheinøvém, Evezøza-qa iz-te ngegeav. ");
INSERT INTO kvg_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mbumbukiam teqa Megeat Matev bèkhakheinám, ndego ni tenimbo-kawaevtat, av bugukhokhof nigi atanakha Deivid ginimbo-kawaevtam. Hosána! Iké꞉ te-te, ndego uni ova-in ngo꞉yage!” ");
INSERT INTO kvg_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yaq Yesu Zelusalem taon-te gemø-on, ndego Mbumbukiam-qá khoev-té genøwáv, gigiap ate qægoam vømø̄qeiv. Yaq taqa zita-te, Betani vemiav-té genøveséz, tegi paev ezoqam tuelv namba. Zapa ndǿgo, khøuwa gèsinanát. ");
INSERT INTO kvg_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Yaq khøuwa nøme qandopave, Yesu Betani vemiav nqawa ge-ivav, yaq nakhoa livin ndøugu, ifi mbovín. ");
INSERT INTO kvg_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Yaq Yesu bøi ge-ogi, fig tae mba mo꞉qeív, qandoyam. Esokho mø̀ndømbo-goám. Geté avønin-te ndøgo gewav, nanga-qa gemøkewag, esokho mba ndøqeív. Tae nanga mbaín. Zapa ndǿgo, taqá viáv mbá. ");
INSERT INTO kvg_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yaq Yesu até gendego, ta fig tae ndøgo manqat vømbō-ein. Gembo-ein, “Qo tae nanga nqawa qóviamák. Ezoqa nango gélogemák qo-te.” Yaq Yesu-gi paev ezoqam, nqanek manqat mø̀ndøyogém, ge-ein. ");
INSERT INTO kvg_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesu Zelusalem taon-te gevesez, Mbumbukiam-qa khoev uta-te nqawa ge-on, yaq até gendego, ezoqam ndigu gigiap gu꞉wiat, gèngeasám, neka lou-qasis vøzø̄-nqagim, ndigu møni gi꞉-enendtat neka ndigu kuvøkuvu, Mbumbukiam-te løvusam nonqo, vø̄wiat. ");
INSERT INTO kvg_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yaq ndego ezoqa takeáv, gigiap Mbumbukiam-qa khoev uta yaq-keoqa gisinatam. ");
INSERT INTO kvg_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yaq Yesu gè꞉zømesím, gezø-ein, “Mbumbukiam-qa Manqat, āv qane-peawáp nqǽgo, ‘Noqa khoev, bawabawan ate ndi꞉gu-qá guliguli khoev ndǿgoát.’ Geté zo Mbumbukiam-qa khoev zò-enendém, vømø̄-aqonam-ezoqam-qa-pebam-khoev.” ");
INSERT INTO kvg_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yaq Mbumbukiam-gi iziz ezoqa kandakanda neka Mozes-qa guguna manqat nømendim ezoqam, nqanek manqat giyogem, ndigu Yesu laelae-qá nakhoa mbovawém. Ndigu møe mbogoám. Zapa ndǿgo, ezoqa ewaqape, teqa nømendim manqat, mbøni zølév. ");
INSERT INTO kvg_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yaq qakhagus ndøgo, Yesu neka tegi paev ezoqam, Zelusalem taon nqawa tìni-ivøvém. ");
INSERT INTO kvg_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Khøuwa nøme qandopave, Yesu ekeza paev ezoqam namba nakhoa gigeveat, sège-keogém ndǿgo, ta fig tae ndøgo, manqat gembo-ein, gèpakhá. Até lu-té. ");
INSERT INTO kvg_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita até gembo-matavupám, Yesu tae manqat gembo-ein. Yaq ndego Yesu āv gembøe-eín nqǽgo, “Nøméndim ezoqam. Qotékewāg. Ta tae ndøgo, nømøkhaiya soqain-te qoqove, mø̀ndø-pakhá!” ");
INSERT INTO kvg_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yaq Yesu gezø-ein, “Zo Mbumbukiam vø̀-unimanqatiním. ");
INSERT INTO kvg_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","No unimanqatín nqazø-manqate. Gekha ezoqām ndego, nqanek manqei pøyat tembo-ein av nqægo, ‘Soqōqavīg, neka ndaola-tē qomø̄bøiāq,’ yaq ndego nakeap mbain tøgoat, teqa mbøni-te, getē gē-unimanqatīn av nqægo, matev segēfakhān, av manqat ge꞉-ein, yaq matev segembó-fakhán. ");
INSERT INTO kvg_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","No nqazǿ-manqate. Gekha matēv ndøgo, zo tozombøe-guligulimat neka Mbumbukiam vøzømbøé-viømemāt, zo vø̀-unimanqatiním, av nqægo, matev mø̀ndø-fakhān. Yaq zo zóndapém. ");
INSERT INTO kvg_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Geté zo tozo-guligulimat, yaq zo ezoqa nøme-te qaqa tøzøgoat, ndigu zo manqa-zapazapa gizøgo, yaq zo sà bezømbo-navøém. Yaq zoge Zøve ndego, yan-te ngo꞉yage, até zoqá manqa-zapazapá-ya, segembøé-navøém.” ");
INSERT INTO kvg_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu tegi paev ezoqam namba, Zelusalem taon-te, nangó ginøveséz. Yaq Yesu Mbumbukiam-qa khoev uta mokho-te gu꞉-okhoam, Mbumbukiam-gi iziz ezoqa kandakanda neka Mozes-qa guguna manqat nømendim ezoqam neka Zu megetapak nøme, tinduzáv ndǿgo, ");
INSERT INTO kvg_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","gimbo-einim, “Qo gekha ezoqam-qâ iz-tē qonǿgot, nandav matev nandoqo-matønumit? Iz gekha ezoqām qá-etoam, matev av nqægo ndoqogot?” ");
INSERT INTO kvg_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yaq Yesu gezø-qavøiu, “Até nó-a, bevap kopo nqanø̂gó, zo-te. Zo yaq tozonø-qavøinam, yaq no ndæ̀zø-eín, av nqægo, no matev gekha ezoqam-qā iz-tē qatø̄-matønumit. ");
INSERT INTO kvg_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Zønømbé-einīm. Gê, Zion, ndego ezoqam ibøkha iz gezø-etoumam, ndego iz Mbumbukiam-tê, ó, manqei-qape ezoqam-tê gendap?” ");
INSERT INTO kvg_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yaq ndigu ekeza mokho-mba gibond, “Áv khazí꞉-einīm? Tizimbo-einim av nqægo, ‘Ndego iz Mbumbukiam-tē gendāp,’ yaq ndego ni āv ginimbí-eín nqǽgo, ‘Av tægoat ndægo, yaq gekha zapâ, zo Zion unimanqatinteav qazogoam?’ ");
INSERT INTO kvg_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Geté tizimbo-einim av nqægo, ‘Zion, iz, manqei-qape ezoqam-tē gendāp,’ yaq nginik ezoqa bawan-qape, ndø̀ndo-qambúz ni-te, qaqa vønígū.” Ndigu megetapak, møe ndøgoám, ezoqam-te. Zapa ndǿgo, ezoqa ewaqape, āv gini-unimanqatintám nqǽgo: Zion, ndego Mbumbukiam-gé manqa vevezam ezoqám. ");
INSERT INTO kvg_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yaq Yesu āv gimbøe-qavøinám nqǽgo, “Ni nìtinøtenák.” Yaq Yesu gezø-ein, “Av tægoat ndægo, yaq até nó-a, nøzǿ-einák, no gekha ezoqam-qā iz-tē qatø̄got, nqanek matev.” ");
INSERT INTO kvg_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yaq Yesu yaya etæ ndøngáz, gezø-ein, “Ezoqa mø̀ndøgoám. Ndego waen khae ndøkhá, uta vø̄-ogi, neka waen nanga pesegim nonqo, manqei vø̄-oz, neka khae qeivi nonqo, khoev eqawat-qape vø̄wev. Yaq khae ndøgo, ezoqā nøme-qá zenda-té genøvé, timbøe-kewagat, ekezan manqei nøme-te vø̄wav. ");
INSERT INTO kvg_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Yaq waen nanga qakhata ndøgo, ndego khae eve, sasae ezoqam ndøkhofotáv, ti-te ndigu, ma khae gimbøe-kewagam. Ekeza waen nanga upøgim-qa ndøgoám. ");
INSERT INTO kvg_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Geté ndigu khae keoge ezoqam, até gindigonem, ngenek sasae ezoqam gèmøvøinám, vø̄zuim, yaq khakha-mba nango sasa ndøkhofotøvem. ");
INSERT INTO kvg_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Yaq ndego khae eve, sasae ezoqa nøme ndøkhofotáv. Geté ndego kawa-té ginømbo-khanæmém, mivi matev vømbō-etøomem. ");
INSERT INTO kvg_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Neka sasae ezoqam nøme gekhofotav, yaq ndigu pakhapakha mbokhanøém. Ngenek waen khae eve, sasae ezoqa nøme kopoáv gekhofosumam. Nøme ndigu gèzitagám, neka nøme pakhapakha vøzø̄-khanæmam. ");
INSERT INTO kvg_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Yaq ngenek waen khae eve, ekeza yo mba mbogoám, ndego gembøe-khafuatam. Yaq vaev ndégo tekhofotáv, ekeza manqa ge-ein, ‘Ngenek nogé yó. Ndego ndø̀mbo-vizumém.’ ");
INSERT INTO kvg_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Geté ndigu khae keoge ezoqam gi-ometam, ekeza mokho-mba, āv gini-einím nqǽgo, ‘Ngenek khae eve-gé yó. Waen khae ngének genó-kawa-év. Zílaém. Yaq khae nqanek, gemǿniqá.’ ");
INSERT INTO kvg_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Yaq até gindigonem, gèmøvøinám, pakhapakha vømbō-khanøem, khae bavokho sasa ndø-ogi꞉nam.” ");
INSERT INTO kvg_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu nqanek yaya etæ manqat qamømbøe-navøem, yaq gezø-ein, “Ge zô, ndozo-matavap? Ngenek waen khae eve, gekha matev ndǿgō? Ndego āv genégó nqǽgo: Ndego ndø̀ndowáv, ndigu khae keoge ezoqam pakhapakha vømøzǿ-khaneām, neka waen khae, ezoqa vini sasa zǿ-etoām. ");
INSERT INTO kvg_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ge zô, Mbumbukiam-qa Manqat mozó-geveømem, av qæ-ein nqægo? ‘Nandi-qapi ndigu, khoev puanam ezoqam gisanqabem, ndigu mø̀ndømø-gigiap-qape-éz, khoev puanam nonqo. ");
INSERT INTO kvg_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nqanek matev, Evezøza ndømatanám. Ndøgo qanimav tantáv, niqa bøi-te.’” ");
INSERT INTO kvg_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesu nqanek manqat gezø-ein, yaq Zu megetapak, møvøiwat-qá nakhoa mbovawém. Geté ndigu ezoqa bawan-qape-qá møe ndøgoám. Yaq ndigu Yesu sège-ivøvém, vø̄zav. ");
INSERT INTO kvg_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Khøuwa nøme, Zu megetapak, Felisi ezoqam neka Elod-gi zifuap ndøkhofotáz, Yesu-te. Ndigu ambá gembo-matemateømemín. Yaq Yesu manqat soqain te-einin, yaq ndigu ambá gemøvøinamɨ́n. ");
INSERT INTO kvg_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yaq ndigu tinduzáv ndǿgo, vømbō-einim, “Nøméndim ezoqam. Ni mø̀tinøtén. Qo unimanqatin ezoqám. Qo møe mbaín, ezoqam-te. Geté qo manqat sòqo-manqaté, oskiá ndøgo, ezoqa kandakanda o ezoqa khasøkhasis. Neka qo ezoqa Mbumbukiam-qa poev-qa yaq-te ndoqote-zømesim, qo unimanqatin manqat mba qomanqaté. Qonimbí-eīn. Kopømbâ, Siza-te teks moni tizi-abumat, ndego Lom kawa kandambaqape, ó, khafeâp? Moni ndizí-abumat, ó, mbaîn?” ");
INSERT INTO kvg_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ndigu nqanek manqat gi-einim, yaq Yesu mø̀ndø-matøvém, ndigu matemateam-qa mbogoám, yaq gezø-ein, “Zo gekha zapâ, no matemateam-qa ndozonøgo? Moni mokho zøtøndé-ndøpøzēm, batézømet.” ");
INSERT INTO kvg_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Yaq ndigu moni mokho gindu-ndøpøzem, vø̄e-ometem. Yaq gezøbevap, “Gê, gekha ezoqam-qâ bugug neka iz mó꞉go, nginik moni mokho-te?” Yaq gimbo-einim, “Siza-qá bugúg, neka teqá iz mo꞉gó.” ");
INSERT INTO kvg_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yaq Yesu gezø-ein, “Av tægoat ndægo, Siza-qa gigiap, Siza zombó-etoumemát. Geté gigiāp ndøgo, Mbumbukiam-qa, Mbumbukiam zombó-etoumemát.” Yesu nqanek manqa qavøiwat gezø-ein, yaq ndigu nqova ndafe kandambá. ");
INSERT INTO kvg_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Yaq Sadusi ezoqam ndozáv, Yesu-te. Nginik Sadusi ezoqam, āv gini-unimanqatinát nqǽgo: Ezoqa tipakhaetat, ndigu nango gemǿ-khandi꞉zák, løvøte-te. Yaq ndigu Yesu bevap mbogoném, ");
INSERT INTO kvg_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","gimbo-einim, “Nøméndim ezoqam. Mozes ni āv ginimbi-peawám nqǽgo: Ezoqa tenanimat, sæva te-ivavat, patu qataeveav vǿgoāt, yaq ngunuk ngæmam, namba qawan be-okɨát, tege namba qawan, ndego genanim, patu bembō-qatayat. ");
INSERT INTO kvg_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Qotøndé-ewāg, nqanek emanqat. Angana mø̀ndøgoám. Evenáp. Até gi꞉goam sevén. Yaq khøuwa ndego, sævam ndø-okɨ́, vø̄nanim. Patu qataeveáv. ");
INSERT INTO kvg_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Yaq eveqase ndø-okɨ́, ngunuk ngæmam, ndego teqa zita-te geqan. Geté ndego matev até kopó, patu qataeveáv genanim. Yaq até ndegó-a, teqa zita-te geqan, matev até kopó. ");
INSERT INTO kvg_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Yaq matev até gemát, atema ndigu evenap seven ate gi꞉goam vømū-pakhaez. Ndigu patu qataeveáv. Yaq vaev até sævám-a, vø̄nanim. ");
INSERT INTO kvg_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Gê, ezoqa unimanqatin løvøte-te tikhandi꞉z, yaq ta khøuwa-te ndøgo, timø-khandi꞉z, ngunuk sævam, gekha ezoqam-gû zas ndǿgoāt? Zapa ndǿgo, ndigu evenap ate gi꞉goam, ngunuk sævam kopo ndøkawawát.” ");
INSERT INTO kvg_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yaq Yesu gezø-qavøiu, “Zoqa matavap soqaín, zo ndozo-matavap av nqægo, ezoqa tipakhaetat, ndigu løvøte-te nango gemø̄-khandi꞉zāk. Zo Mbumbukiam-qa Manqat neka teqa bazaføgakh zøtezateáv. ");
INSERT INTO kvg_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ezoqa løvøte-te nango timø-khandi꞉z, ndigu andé enzol ezoqam me mé꞉goát, ndigu yan-te ngo꞉yage. Nøkenøkem matev mbaín. ");
INSERT INTO kvg_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Geté løvøte-te toqo-khandi꞉q, taqa yaq-te, gê, zo Mozes-qa mbuk-te, emanqat mozó-geveømem, tae-qase-qa yaq-te, qawageapam? Ta emanqat-te ndøgo, Mbumbukiam Mozes āv gembøe-eín nqǽgo, ‘No Eibleem-gé Mbumbukiám, neka Aezek-gé Mbumbukiám, neka Zekop-gē Mbumbukiām.’ ");
INSERT INTO kvg_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nqanek manqat ni āv qaninømánd nqǽgo: Ndigu ezoqam zua ndøkhandi꞉zát, Mbumbukiam namba. Zapa ndǿgo, Mbumbukiam ndego ambá av nqǣgo, løvøte ezoqam-gē Mbumbukiām, geté ndego khandi ezoqam-gé Mbumbukiám. Yaq nakémbá, zo Sadusi ezoqam, zoqa matavap soqaín, zo ndozo-matavap, av nqægo, ezoqa tipakhaetat, ndigu nqawa gēkhandi꞉zatāk.” ");
INSERT INTO kvg_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yesu Sadusi ezoqa namba manqa gi-itumbumam, yaq Mozes-qa guguna manqat nømendim ezoqa kopo mø̀ndøgoám, tiqa manqat vø̄-ewag. Yaq geqeiv av nqægo, Yesu qavøiwat mbomambaqapē gezø-ein, yaq ndego tendowáv ndǿgo, bevap nøme vømbōgo, gembo-ein, “Gê, Mozes-qa guguna manqat mokho-te, gekha matēv mó꞉megeat?” ");
INSERT INTO kvg_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yaq Yesu gembo-qavøiu, “Matev nqo꞉megeat nqánek, ‘Gèndoyogé, Izlael ezoqam! Evezøza, nigi Mbumbukiam, Evezøza sa ndégo. Mbumbukiam nøme mbaín. ");
INSERT INTO kvg_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kuku yà betaqagó, Evezøza-te, ndego qoge Mbumbukiam, uni qoqa mbøni-te neka uni qoge nqova-te neka uni qoqa matavap-te neka uni qoqa bazaføgakh-te.’ ");
INSERT INTO kvg_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Neka matev kandambaqape nøme nqánek, ‘Ezoqa nøme-te, kuku āv tabetaqambe꞉gó, av qakeza kha-te kuku ndaqambe꞉go.’ Matev kandakanda nøme mbaín, nqanek matev menas qaløvuam.” ");
INSERT INTO kvg_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yaq ngenek Mozes-qa guguna manqat nømendim ezoqam, Yesu gembo-ein, “Nøméndim ezoqam. Qanimáv. Qoqa manqat unimanqatín. Evezøza yakhapús, Mbumbukiam. Mbumbukiam nøme mbaín. ");
INSERT INTO kvg_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Neka unimanqatín. Kuku yà betaqagó, Evezøza-te, ndego qoge Mbumbukiam, uni qoqa mbøni-te neka uni qoqa matavap-te neka uni qoqa bazaføgakh-te. Neka ezoqa nøme-te, kuku āv tabetaqambe꞉gó, av qakeza kha-te kuku ndaqambe꞉go. Matev kandakanda sa nqánek. Taoká ndøgo, Mbumbukiam-te søvakha gigiap nqazi-løvusam, o gekha etoam matev nøme nqazimbogo.” ");
INSERT INTO kvg_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu geqeiv av nqægo, ngenek ezoqam-qa qavøiwat mokho kandambā, yaq āv gembøe-eín nqǽgo, “Qo qambaqapé mbá, Mbumbukiam-qa Megeat Matev-te.” Yaq taqa zita-te, ezoqa møe ndøgoném, Yesu bevap nøme vømbøé-gonēm. ");
INSERT INTO kvg_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu Mbumbukiam-qa khoev-te gegoam, ezoqa ge꞉zømesimat, yaq āv gezømbe-beváp nqǽgo, “Gê, zo ndozo-matavap? Gekha zapâ, Mozes-qa guguna manqat nømendim ezoqam ndimanqate, av nqægo, Mesaya ndego, Deivid-gē zeō? ");
INSERT INTO kvg_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Deivid ekezán, Nqova Mbomambaqape mokho-te, Mesaya-qa yaq-te ge꞉-ein: Evezøza Mbumbukiam, noge Evezøza, āv gembøe-eín nqǽgo, ‘Noqá nakeamo zenda-té qanøqóm. Até qóqotát, atema no qogi qaqa ezoqam qoqa zenda tokhotapak mokho-te vøtaqambú-āb.’ ");
INSERT INTO kvg_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deivid ekezan, ndego Mesaya, Evezøza mbo-akhayám. Yaq gê, ngenek Mesaya, áv kené-Deivid-ge-zeo-ev?” Ezoqa kopoáv, Yesu namba giwaniapam, teqa manqat giyogem. Yaq ndigu teqa manqat gèzømbe-khaneatám. ");
INSERT INTO kvg_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu ezoqa ge꞉zømesimat, nøme āv gezømbe-eín nqǽgo, “Gò꞉feazoát, Mozes-qa guguna manqat nømendim ezoqam-qa yaq-te. Ndigu tøzømbe-khaneát ndǿgo, ti-okhoat, ndabua loloakh mbomømboma ndǿ-uzupát, neka ezoqa ewaqape, maket manqei-te, ndigu khaiya mboma manqat vizap-us bezø̄-manqate, ");
INSERT INTO kvg_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","neka guliguli khoev-te neka lou loge kandakanda-te ndøgo, iz akhayapak-qa qonam nonqo-te vǿqonumāt. ");
INSERT INTO kvg_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ndigu ngængæm zømbe-khavozumatún, tiqa khoev neka gigiap vøzø̄-aqonumatun. Neka ezoqa ewaqape-qa bøi-te, guliguli loloakh ndøgoatún. Yaq nakémbá ndigu yaq-fia nqosøgeap, nøme mba mó꞉ndapém.” ");
INSERT INTO kvg_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu Mbumbukiam-qa khoev-te, moni nqeisam nonqo avønin-té geqotám. Ndego ezoqa ndøzømetát, moni ginqeisumat. Gigiap kopoav ezoqam kopoáv, moni kandakandá ginqeisumat. ");
INSERT INTO kvg_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Yaq até sævám-a vøndōwav. Ndugu ngæmám. Gigiap-av ezoqám. Zivis mø̀ndømbo-naním. Gunduwav, moni mokho khasøkhasis menas vø̄nqeitaz. Nginik moni, tiqa fia khapímbá. Ande āv penpakha kopó ndi꞉gú. ");
INSERT INTO kvg_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yaq Yesu ekeza paev ezoqam ndømøváb, gezø-ein, “No unimanqatín nqazø-manqate. Ngunuk gigiap-av sævam, moni kandambá gu꞉nqeitaz, āv tiuká, av ezoqa ewaqape nøme, moni gi꞉nqeisumat. ");
INSERT INTO kvg_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Zapa ndǿgo, ndigu ezoqa nøme, moni kandakanda ambá gini-nqeisumám. Geté ndigu moni nøme kopoav-qapí ndizøgo. Geté ngunuk ngæmam, viní. Ndugu moni ate gimbøegoam, sùgumu-áb. Nøme mbaín, tuqa yage nonqo.” ");
INSERT INTO kvg_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu Mbumbukiam-qa khoev ge꞉-ivavtat, yaq tege paev ezoqa kopo nøme, āv gembøe-eín nqǽgo, “Nøméndim ezoqam. Qotéqēiv! Mbumbukiam-qa khoev-te ndøgo, khoev qaniqanimáv tantáv. Nandi kandakanda mbá ginipuán.” ");
INSERT INTO kvg_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Geté Yesu gembo-qavøiu, “Khoev kandakanda ate ndægo, ndoqoqeivi, manqei-té qamǿ-khakhandám. Nandi kopo nøme, nandi nøme-te, gó꞉zaveák.” ");
INSERT INTO kvg_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Taqa zita-te, Yesu Oliv manqei poyat-té genøwáv, vømø̄qom. Ta manqei poyat ndøgo, Mbumbukiam-qa khoev yaq-keoqá qagó. Pita neka Zems neka Zion neka Endlu, ti-mba ndígu tigoám, te namba. Yaq āv gimbøe-bevøpém nqǽgo, ");
INSERT INTO kvg_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Qonimbí-eīn. Matev nandav, qoqote-manqatam, gekha khøuwā qanéfakhān? Neka andé gekha matev me nitíqeivīm, ni tøtinøten, av nqægo, nqanek matev ate ndægo avønīn gēfakhanām?” ");
INSERT INTO kvg_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yaq Yesu gezø-ein, “Aiyá qagó. Zo ezoqa betùba᷄m. ");
INSERT INTO kvg_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ezoqa kopoáv, noqá iz-té gindú-okhoát. Ndigu ezoqa āv gizømbé-manqatát nqǽgo, ‘Ezoqa, nó’, neka ezoqa kandambá titubumat. ");
INSERT INTO kvg_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Zo nakhag-qa yaq-te tozo-ewagat neka nakhag u vozó-ewagāt, zo møe ndø̀go᷄. Matev av nqægo, ndø̀khæ-fakhanám. Geté manqei-qape-qa vaev zuá. ");
INSERT INTO kvg_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Manqei nøme, manqei nøme namba, nakhag ndǿgoát, neka kawa ezoqa nøme-qa bawan, kawa ezoqa nøme-qa bawan namba, vǿnøfeapāt, neka manqei nøme-te, manqei vǿkukuvøemāt. Manqei vinivinimbá. Kopoáv. Manqei nøme-te, lou mbaimbai zǿwagát. Geté nqanek matev ate ndægo, ngazu mbá. Ndøgo kopømba ande av-té, sævam tui-ova, nqosøgeap ande tuikhantav. ");
INSERT INTO kvg_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Zo aiyá qazógoát. Ezoqa zo manqa ovøyam-té ginǿ-abumát neka Zu ezoqam-qa guliguli khoev mokho-te vǿfebumāt. Neka no zapaya, zo megetapak neka kawakawa-za-qá megemege-té ginǿ-abumát, yaq zo ndigu noqa yaq-te vøzøté-zømasāt. ");
INSERT INTO kvg_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Geté ezoqa bawabawan ate ndi꞉gu, Mbumbukiam-qa Manqat Mbomambaqape bètøkhæ-yogém, yaq váev manqei-qape tømø-navøem. ");
INSERT INTO kvg_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Zo tigavemat neka manqa ovøyam-te vǿ-abumāt, zo naqanøká ndøfofogème᷄m, av nqægo, andē gekha manqat me zomǿ-einimāt. Zapa ndǿgo, matev tøfakhanumat, yaq matavap Mbumbukiam zǿ-etoumát, zo andé gekha manqat me zøté-manqatāt. Yaq zo ambá av nqǣgo, zøkezan zómanqatāt. Geté Nqova Mbomambaqape ndǿmanqatát. ");
INSERT INTO kvg_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ezoqa nøme, ekeza namba-qaniap løvøte-té ginǿ-abumát neka evøndipakha nøme, ekeza nakheis løvøte-te vǿ-abumāt. Neka nakheis nøme, ekeza evøndipakha segezǿ-qambuzát, løvøte-te vǿ-abumāt. ");
INSERT INTO kvg_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ezoqa ewaqape zo gésanqabát neka qaqa vøzǿgoāt, no zapaya. Geté gekha ezoqām ndego, bazaføgakh-us teyat, atema vaev-te, ndego ndø̀mø-khandí꞉v.” ");
INSERT INTO kvg_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Zo Mbumbukiam-qa khoev mokho-te, gigiap soqaqape zóqeivím. Geté khafeap kandambá, gigiap av nqægo tøu-wuøyat ndøugu. (Gekha ezoqām ndego, nqanek manqat tegeveam, mokho bèmboqeív.) Zo nqanek gigiap tozoqeivim, yaq gekha ezoqām ndigu, Zudia plovins-te tiyagat, manqei popotap-té giabenø-khokhóz. ");
INSERT INTO kvg_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Gekha ezoqām ndego, khoev ova to꞉yat, ndego khoev mokho-te bè-o᷄n, gigiap vømøndó-upøgīm. ");
INSERT INTO kvg_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Neka gekha ezoqām ndigu, khae-te tisasaetet, ndigu ndabua upøgim-qa bevèse᷄z. ");
INSERT INTO kvg_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ta khøuwa-te ndøgo, ti-te ndigu unimé꞉-soqá, sakheis emu-us ndigu neka nakhei tete ndizøloge. ");
INSERT INTO kvg_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mbumbukiam zombó-vi꞉mát. Nqanek matev, qozaq viav-te befàkha᷄n. ");
INSERT INTO kvg_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Viniv ndøgo, ta khøuwa-te tøfakhan, føgakh-mbá tantáv. Mbumbukiam manqei-qape ande ge꞉khakheinam, atema ndakin, matev føgakh-qape fakhaneáv, av ta khøuwa-te ndøgo tæfakhan. Yaq até taqa zita-té-a, matev føgakh-qape av nqægo, nango gemǿ-fakhanák. ");
INSERT INTO kvg_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Geté Mbumbukiam matavap é-møndo꞉vé, av nqægo, khøuwa ndø̀-tokhopogeaqasí꞉z. Mbain tøgonɨn, yaq ezoqa kopo ambá gemǿ-khandi꞉vák. Mbumbukiam, khøuwa, ti zapaya ndígu tené-tokhopogeaqasí꞉z, ndigu ekezan gevevesam. ");
INSERT INTO kvg_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ta khøuwa-te ndøgo, ezoqa tezø-ein, av nqægo, ‘Ngé! Mesaya ngének,’ ó, ‘Ndé. Mesaya ndégo,’ yaq zo ndø-unimanqatìni᷄m. ");
INSERT INTO kvg_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Zapa ndǿgo, khokho Mesaya neka khokho Mbumbukiam-gi manqa vevezam ezoqam ndø̀fakhanám. Ndigu matev kandakanda neka umingiap matev ndǿmatønumát. Yaq kopømba tøgønɨn, até ndigú-a, Mbumbukiam ekezan gevevesam, ambá ndætubám. ");
INSERT INTO kvg_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Geté zo aiyá qazógoát. No ndakin matev ate ndægo, tømø-fakhanam, mø̀ezømbe-eín.” ");
INSERT INTO kvg_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yaq Yesu manqat nøme gezø-ein, “Ta khøuwa-te ndøgo, nqanek viniv kandambaqape tøme-navøem, yaq khøuwa waev segembó-navøém, neka løvøyak beawap mbaín, ");
INSERT INTO kvg_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","neka nduku yan-te ngo꞉go vøndó-o꞉āz, neka gigiap føgøføgakh yan-te nqo꞉go, vǿkukuvøēm. ");
INSERT INTO kvg_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Yaq ezoqa Ezoqam-gé Yo ndǿ-ometám. Khaiya ozoz-té genǿgeáv. Bazaføgakh-ús neka waev-qape-ús. ");
INSERT INTO kvg_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Yaq ndego enzol ezoqam ndókhofosám, manqei-qape ate nqægo, khøuwa vøndē-fakhanɨn-a, vømē-sinanɨn, neka sanqa-sanqa vømbō-anam. Yaq gekha ezoqām ndigu, Mbumbukiam gevevesam, manqei-qape ande āv khandēvavet, enzol ezoqam gémøváb.” ");
INSERT INTO kvg_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yaq Yesu manqat nøme gezø-ein, “Zo fig tae-té qazøté-zøtéz. Tang-te mbusa tøfakhanam, esokho vǿqabām, yaq zo mø̀zøte-zøtezɨ́n, wavam khøuwa avønín. ");
INSERT INTO kvg_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Yaq matev até kopó. Zo nqanek matev tozo-qeivimat, tøfakhanumat, yaq zo søzøté-zøtéz, Ezoqam-ge Yo, avønín gendóqaván. ");
INSERT INTO kvg_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","No unimanqatín nqazø-manqate. Ezoqa nøme, ndakin ngiyage, naqanøká gépakhaezák. Até géyagát, atema ta khøuwa-te ndøgo, nqanek matev ate ndægo vømú-fakhanām. ");
INSERT INTO kvg_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yan neka manqei-qape ndø̀mø-navøém. Geté noqa manqat gemǿ-navøemák.” ");
INSERT INTO kvg_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Ezoqa mè꞉zøtezák, nqanek matev gekha khøuwa-tē neka gekha khøuwa iz-tē qanéfakhān. Até enzol ezoqám-a, yan-te ngo꞉yage, neka até Yó-a, zøtezateáv. Geté Eve yakhapús sege꞉-otév. ");
INSERT INTO kvg_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yaq nakémbá. Aiyá qazógoát. Gò꞉feazoát. Zapa ndǿgo, zo khøuwa iz zø̀tezøtezák, ta matev ndøgo tøfakhan. ");
INSERT INTO kvg_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ndøgo kopømba ande av ndǽgo, ezoqam manqei nøme-te tewav. Khoev te-ivav, yaq ekeza gigiap, tegi sasae ezoqam-qá zenda-té genǿ-awám, timbøe-qeivat. Ezoqa vinivinimba, sasae vinivinimbá tezø-etoam. Yaq ndego ezoqam mboqog tembo-kewagat, āv gembøé-eín nqǽgo, ‘Qo oskia mo꞉feaqoát.’ ");
INSERT INTO kvg_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Até zó-a, gò꞉feazoát. Zapa ndǿgo, zo zøtezateáv, gekha khøuwâ, ndego khoev eve tendoqavan, khagūs o lova u-mbā, o kokolok tui-ogea o qanaqanus tænqovet. ");
INSERT INTO kvg_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","É-mozoto-khakheinám. Soqaín ndøgo, ndego nqova tezøndaf, yaq zo venanqei sømbiam-tē gēzømēt. ");
INSERT INTO kvg_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nqanek manqat zo nqazø-manqate, no ezoqa ewaqape nøte-zømastét. Manqat nqánek: Oskia mo꞉feazoát!” ");
INSERT INTO kvg_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Khøuwa menas mba mu꞉-ewabám, atema Zu ezoqam-qa Pasova khøuwa kandambaqape-te neka ta khøuwa kandakanda nøme ndigu, flawa poponøvemav gilouzatun. Yaq Mbumbukiam-gi iziz ezoqa kandakanda neka Mozes-qa guguna manqat nømendim ezoqam nakhoa-qa ndøvawát, Yesu ande āv kimbøé-matemateømēm, neka vǿ-møvøinām, sasa ndǿlaēm. ");
INSERT INTO kvg_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Geté ndigu āv gini-einím nqǽgo, “Ni khøuwa kandambaqape-te, bizi-matønø̀me᷄m. Soqaín ndøgo, ezoqa qaqa tigonem ni-te, yaq nøfe kandambaqape ndǿfakhān, ti mokho-te.” ");
INSERT INTO kvg_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu Betani vemiav-te gegoam, Saemon-qá khoev-té geqotám. Ngenek Saemon, bugukhokhof kha sisi-us ndøgoám. Yaq Yesu ate av-té lou ge꞉logat, sævam kopo tunduwáv ndǿgo, botol-qase vøndōndap. Tae et sisip qanimav-qape mu꞉nqeitavám. Taqa fia kandambá tantáv. Yaq ndugu até gundigu, botol gumboqòā, tae et sisip mbomambaqape, Yesu-qa kawa-te sasa mo꞉qouz. ");
INSERT INTO kvg_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ezoqa nøme, nqanek matev giqeivim, ndigu khanakhanakh mbaín, neka yaqyaq-a gibond, “Gekha zapâ, ngunuk nqanek tae et fia kandambaqape, sa gungiu? ");
INSERT INTO kvg_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nqanek gigiap fia kandambá tantáv. Moni mokho tri andled mø̀ndø-løvuám. Ngunuk ambá gewiín, fia kandambaqape vø̄qasɨn, yaq ni moni gigiap-av ezoqam vizizø̄-etoamɨn.” Yaq ndigu ngunuk sævam gèmbo-ponqomém. ");
INSERT INTO kvg_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Geté yaq Yesu gezø-ein, “Sègembo-ivøvém. Gekha zapâ, zo ngunuk sævam viniv nqazombøe-veet? Ngunuk matev mbomambaqapé gunø-matanam. ");
INSERT INTO kvg_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Zo gigiap-av ezoqam namba, oskia zøté-yageapát. Yaq gekha khøuwā ndøgo, zo tøzø-pøovat, kopømbaqapé tozozø-tøkeat. Geté no namba, oskia zí꞉yageák. ");
INSERT INTO kvg_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Matev eqeieqei ndøgo, ndugu kopømbaqape qagoam, tumatanam, mø̀ndø-matanám. Ngunuk nqanek tae et sisip mbomambaqape, noqa kha-te guoqouz, ndugu no otønat nonqo me꞉khakheinømbém. ");
INSERT INTO kvg_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","No unimanqatín nqazø-manqate. Gekha manqei-tē ndøgo, ezoqa Manqat Mbomambaqape ti꞉zømesimat, manqei-qape-te ate nqægo, ezoqa ngunuk sævam-qa yaq-te mé꞉manqatát, matev mbomambaqape av guimatanam, neka ngunuk vømbøé-matavupāt.” ");
INSERT INTO kvg_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yaq Zudas Iskaliot, ndego Yesu-gi paev ezoqa tuelv gegoam, ndego Mbumbukiam-gi iziz ezoqa kandakanda-té genøwáv, manqat vømø̄-kopo꞉nem, av nqægo, Yesu tiqā zenda-tē genø̄vē. ");
INSERT INTO kvg_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yaq ndigu khanakhanakh kandambá gindapem, teqa manqat giyogem, neka yaq-moni etoam manqat vømbō-einim. Yaq Zudas nakhoa-qa ndøváo, Yesu tiqa zenda-te, ande āv kenévē. ");
INSERT INTO kvg_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Zu ezoqam-qa khøuwa kandakanda qangaz, ndøgo flawa poponøvemav gilouzatun, ta bugukhokhof khøuwa-te ndøgo, ndigu Pasova lou loge nonqo, sip nakheis gizitagatun, Yesu-gi paev ezoqam tinduzáv ndǿgo, vømbō-bevøpem, “Gê, qoqa poev gekhâm? Ni gekham-tē qatíniāv, Pasova lou vøimøqá-khakheinømēm?” ");
INSERT INTO kvg_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yaq Yesu ekeza paev ezoqa menas ndøkhofotáz, gezø-ein, “Zelusalem taon mokho-té qazonǿzáv. Yaq ezoqam zomǿ-ometám. Ibøkha ndǿ-eqatét. Yaq zombó-paevém. ");
INSERT INTO kvg_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Khoev mokho-te te-on, yaq ta khoev ndøgo, khoev eve āv qazømbøé-einím nqǽgo, ‘Nømendim ezoqam āv geqande-beváp nqǽgo: Noqa khoev kouwat gekham-tē qágo, ma nogi paev ezoqam namba Pasova lou teimilog?’ ");
INSERT INTO kvg_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Yaq ndego zo khoev kouwat kandambaqape mé꞉zømás, khoev ova ndo꞉go. Qonam nonqo neka lou-qase khakheitáp. Yaq niqa lou ndǿgo tozomǿ-khakheinømém.” ");
INSERT INTO kvg_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yaq nginik Yesu-gi paev ezoqam, taon-qape-te gizav, ndigu matev āv timiqeivím, av Yesu gezømbe-ein ndægo. Yaq ndigu Pasova lou vømø̄-khakheinømem. ");
INSERT INTO kvg_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Yaq qakhagus ndøgo, Yesu tegi paev ezoqam tuelv namba tinøpindám ndǿgo, lou loge-te vø̄qonav. ");
INSERT INTO kvg_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yaq ate av-té lou gi꞉logat, Yesu āv gezømbe-eín nqǽgo, “No unimanqatín nqazø-manqate. Zo ezoqa kopo, ndakin lou nqazologet, segenǿ-qambún, neka no qaqa ezoqam-qa zenda-te vǿvē.” ");
INSERT INTO kvg_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yaq tegi paev ezoqam, nqanek manqat giyogem, ndigu mbøni zøvá. Yaq ezoqa kopokopo ate gi꞉goam, āv gimbøe-bevupát nqǽgo, “Éisa. Qo ekeqá no qote-manqaté.” ");
INSERT INTO kvg_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yaq Yesu gezø-ein, “Zo ezoqa tuelv nqazo-qonøve, no namba lou yaf-te nqazi-afønumit, ezoqa kopo ngû꞉gú. ");
INSERT INTO kvg_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ezoqam-ge Yo ndø̀naním, av Mbumbukiam-qa Manqat qæ-ein. Geté te-te ndego, unimé꞉-soqá, ndego Ezoqam-ge Yo sa temboqambun, neka qaqa ezoqam-qa zenda-te vǿvē. Ngenek ezoqam qaneav tøgonin, ambá qanimáv te-te.” ");
INSERT INTO kvg_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ndigu ate av-té lou gi꞉logat, yaq Yesu flawa ndøndapáz, Mbumbukiam-te ike manqat vø̄-ein, sasa ndømbegim, ekeza paev ezoqam vøzø̄-etoam, gezø-ein, “Mòzo-upøgím. Nqanek noqá khá.” ");
INSERT INTO kvg_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Yaq izam nonqo ndøndáp, waen-ús, Mbumbukiam-te ike manqat vø̄-ein, ekeza paev ezoqam sasa zø-etoam. Yaq ndigu ate gi꞉goam sùgumu-izumát, ta izam nonqo kopo-te. ");
INSERT INTO kvg_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yaq Yesu āv gezømbe-eín nqǽgo, “Nqanek noqá kóuk. Mbumbukiam poev mé꞉-unimanqatín, tegi ezoqam namba. Noqa kouk, ezoqam kopoav zapayá qanéwá. ");
INSERT INTO kvg_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","No unimanqatín nqazø-manqate. No waen tae nanga-qa et, nqawa naqanøká nǿ-izák. No sa ndǿgo tømé-íz, ta khøuwa-te ndøgo, no Mbumbukiam-qa Megeat Matev-te, waen ndakinak tæmø-iz.” ");
INSERT INTO kvg_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Lou gumulog, Mbumbukiam-te ouv sasa ndøqaem, yaq Oliv manqei pøyat-té ginøzáv. ");
INSERT INTO kvg_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yaq Yesu ekeza paev ezoqam gezø-ein, “Zo ate nqazøte꞉go, møe zóbøín. No sozó-nøuvøném. Mbumbukiam-qa Manqat, āv qane-peawáp nqǽgo, ‘No sip keoge ezoqam nólaváo. Yaq sip segemǿ-panqaním.’ ");
INSERT INTO kvg_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Geté no løvøte-te tøtøndo-khandi꞉n, yaq Gelili plovins-té qatǿnáv. No é-ndøto꞉má ndøgo, zoqa megemege-te.” ");
INSERT INTO kvg_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Geté Pita gendo-ein, “Ezoqa ewaqape, qo ambá giní-qouvøqém. Geté no, nóqouvaqák.” ");
INSERT INTO kvg_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yaq Yesu gembo-ein, “No unimanqatín nqataqa-manqate. Nqægo lova, kokolok menas naqanøká gé-ogeayák. Qo noqa yaq-te ndòqotøkhæ-nawám. Misiká toqoto-nawam.” ");
INSERT INTO kvg_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Geté yaq Pita manqa qavøiwat gego, manqat bazaføgakh-ús ge-ein, “Āv taoká. Oskiá ndøgo, no totonanim, qo zapaya, no notó-nawamák, qoqa yaq-te.” Yaq até tegi paev ezoqa nømé-a, manqat kopó, āv tini-manqatám. ");
INSERT INTO kvg_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yaq Yesu ekeza paev ezoqam namba, khae manqei-té ginøzáv. Taqa iz, Getsemaní. Yaq gimøfakhaz ndøgo, tegi paev ezoqam, āv gezømbe-eín nqǽgo, “Até vo꞉qonøvé nqanek. No nomǿ-guligulím.” ");
INSERT INTO kvg_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yaq ndego ti-mba ngínik gekhatób, namba gi꞉zav, Pita neka Zems neka Zion. Yaq Yesu mbøni vaev matev mbongáz. Viniv kandambá gembo-ewag. ");
INSERT INTO kvg_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yaq gezø-ein, “Noqa mbøni kandambá qanevá. No avønín, nǿnaním. Até vøgó nqanek, neka até vo꞉tiawét.” ");
INSERT INTO kvg_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yaq Yesu elavøqase nøme vø̄wav. Khapémbá. Yaq katuk ndømøkuí. Bugug manqei-té, vø̄guligulim, av nqægo, “Kopømba tøgoat, ta matev ndøgo, tønøfakhan, ambá sege-løvumbín.” ");
INSERT INTO kvg_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Neka nøme āv gene-eín nqǽgo, “Ába! Tát! Qo kopømbaqapé, matev ate ndægo toqogo. Nqanek nqosøgeap kandambaqape, ndøgo ande ibøkha khaqain-qape me tønømbe-fakhan, ambá qøndapɨ́n. Geté matev āv tabete-fakhán, av qoqa poev ndægo. Ambá ndø̄go, av no nqanømbe-poev.” ");
INSERT INTO kvg_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yaq ndego tegi paev ezoqa misika-te gevesez, tezømét ndǿgo. Gèsømbiám. Yaq Yesu Pita gembo-ein, “Sáemon! Qo qóbuvit? Ge qô, kopømba mbaîn, no namba elavøqase toqote-tiawet? ");
INSERT INTO kvg_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Zo até vo꞉tiawét, neka gèguligulimít. Soqaín ndøgo, khamasim matev tøndowav zo-te, yaq zo zō-o꞉āz. Unimanqatín. Nqova poev ndømbôgó. Geté kha, bazaføgakh mbaín.” ");
INSERT INTO kvg_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yaq Yesu nangó genøwáv, vømø̄-guligulim. Guliguli manqat até kopó, av bugukhokhof ge꞉guligulim. ");
INSERT INTO kvg_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Yaq tegi paev ezoqa misika-te nango gendovesez, gezømet, ndigu nqawá ginø-sømbiám. Venanqei baza khàpe zømbepós. Yaq gisuz ndøgo, ndigu mè꞉zøtezák, gekha manqat mbó-einīm. ");
INSERT INTO kvg_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yaq Yesu nqawá genøwáv, vømø̄-guligulim. Yaq qambo-misika, tegi paev ezoqam-te nango gendovesez, gezø-ein, “Zo sekembā sozó-sømbiapet neka pusa zótavet? Sag! Khøuwa iz mø̀ndøndáp. Ezoqam-ge Yo, manqa-zapazapa-us ezoqam-qá zenda-té ginǿveém. ");
INSERT INTO kvg_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mòzosúz. Bìziniáv. Ngé! Ezoqam ngének, no ezoqam-qa zenda-te teve!” ");
INSERT INTO kvg_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu ate av-té manqat ge꞉manqatam, Zudas tènefakhán. Tegi paev ezoqa tuelv, ezoqa nøme ndégo tegoám. Ezoqa kopoáv namba me꞉geavún, ndigu kaiya neka ndawa vøndō-upøgim. Nginik Mbumbukiam-gi iziz ezoqa kandakanda neka Mozes-qa guguna manqat nømendim ezoqam neka Zu megetapak kandakanda ndokhofotáz. ");
INSERT INTO kvg_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Zudas, manqat é-møndøzø-eín, av nqægo, “Ezoqam ndégo, no tængenøtam. Ndégo tozó-møvøinám, neka gèmbo-kewagét, tozoqavaz.” ");
INSERT INTO kvg_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yaq Zudas até gendego, Yesu-té genøwáv, gembo-ein, “Nøméndim ezoqam.” Neka sasa ndøngenøtam. ");
INSERT INTO kvg_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Yaq ezoqam tinduzáv ndǿgo, vø̄-møvøinam. ");
INSERT INTO kvg_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yaq paev ezoqa kopo, avønin gembogoam, kaiya mba ndøliváz, Mbumbukiam-ge iziz ezoqam kandambaqape, tege sasae ezoqam, gea vømbōkawa. ");
INSERT INTO kvg_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yaq Yesu gezø-ein, “Ge zô, no pepen ezoqam zøténæmbem, nakhag kaiya neka ndawa-us qazogeavun, no vozó-møvønonām? ");
INSERT INTO kvg_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","No khøuwa ate qæpavpavemam, Mbumbukiam-qá khoev-té qæqoám, zo namba, ezoqa vøtē-zømesimam. Geté ndøgo, zo no møvønoateáv. Geté nqanek matev ate ndægo, tønefakhán ndǿgo, Mbumbukiam-qa Manqat tàbete-unimanqatín, av bugukhokhof ge꞉-ein.” ");
INSERT INTO kvg_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yaq Yesu nqanek manqa manqate qamømbøe-navøem, tegi paev ezoqam sège-ivøvém. Møe ndøbøín. ");
INSERT INTO kvg_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Geté ezoqa ndakinak kopo, Yesu até gembopavát. Ndabua papaqa-mba ndøløvøetám. Yaq ndigu ambá ndabua mbogeanemɨn. ");
INSERT INTO kvg_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Geté ndego ndabua geløvøetam, sège-iváv, vø̄teit. Naqei-áv. ");
INSERT INTO kvg_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ezoqam ndigu, Yesu gimøvøinam, Mbumbukiam-ge iziz ezoqam kandambaqape-qá khoev-té ginøndafém. Yaq Mbumbukiam-gi iziz ezoqa kandakanda neka Zu megetapak kandakanda neka Mozes-qa guguna manqat nømendim ezoqam, tinømøváb ndǿgo. ");
INSERT INTO kvg_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita Yesu até gembopavát. Andé qámbá gendopavam. Yaq Mbumbukiam-ge iziz ezoqam kandambaqape-qa khoev-te gemøfakhan, até ndegó-a, uta mokho-te vø̄-on. Yaq ndego vos keoge ezoqám namba me꞉qonáv, gøinam avønin-te, kha vø̄qoqoutam. ");
INSERT INTO kvg_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mbumbukiam-gi iziz ezoqa kandakanda neka Zu ezoqam-gi manqa ovøyam megetapak ate gi꞉goam, Yesu, manqa-zapazapa-qa mbovawát. Yaq ezoqa amba gekha manqat ti-einimin, teqa yaq-te, ndigu ambá gelaemɨ́n. Geté ndigu teqa manqa-zapa qeiviáv. ");
INSERT INTO kvg_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Zapa ndǿgo, ezoqa kopoáv, khokho manqat ambá gini-manqatát, Yesu-qa yaq-te. Geté tiqa manqat vinivinimbá. ");
INSERT INTO kvg_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Yaq ezoqa nøme até gindigonem, vø̄wan, Yesu-qa yaq-te meakha manqat vø̄manqatat, gi-einim, ");
INSERT INTO kvg_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ni ngenek mø̀imbo-yogém. Āv gene-eín nqǽgo, ‘No Mbumbukiam-qa khoev, ezoqa giwevem, nó-evøzám. Yaq khøuwa misika mokho-te, nøme nówév. Geté ta khoev ndøgo, ambá av nqǣgo, ezoqam ndøwevēm.’” ");
INSERT INTO kvg_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Geté ndigu ezoqam, nqanek manqat gimanqatat, ate ndígu-a, meakha manqat vinivinimbá gimanqatat. ");
INSERT INTO kvg_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Yaq Mbumbukiam-gé iziz ezoqam kandambaqape ndø-itán, tiqa megemege-te ndo꞉go, Yesu vømbōbevap, “Ge qô, yaq manqa qavøiwat taqágo, nginik qo-te manqat ngi-møvøet?” ");
INSERT INTO kvg_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Geté Yesu manqat einiáv neka yaq qavøiwateáv. Yaq ndego Mbumbukiam-ge iziz ezoqam kandambaqape, até gendego, Yesu vømbōbevap, “Gê, qo Mesayâ? Mbumbukiam, ndego Iz Eqawat-Qape, tegê Yò?” ");
INSERT INTO kvg_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yaq Yesu gembo-ein, “No nándev! Zo Ezoqam-ge Yo zomǿ-ometám. Mbumbukiam Bazaføgakh-qape-qá nakeamo zenda-té géqotát. Yaq ndego khaiya ozoz-té genǿgeáv.” ");
INSERT INTO kvg_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Yaq ndego Mbumbukiam-ge iziz ezoqam kandambaqape, mbøni mbonqosøgím, nqanek manqat ge-ewag. Yaq até gendego, ekeza ndabua vø̄keqa, gendo-ein, “Ság! Bøi vizu ezoqa nøme-qa bizivàwe᷄m. ");
INSERT INTO kvg_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Zo mòzombo-yogém, Mbumbukiam-qa iz gengiu. Zo gekha zombó-matavap?” Yaq ezoqa ewaqape āv gindi-einím nqǽgo, “Ngenek manqa-zapa ndøgó. Yà benaním!” ");
INSERT INTO kvg_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Yaq ezoqa nøme até gindigonem, køse vømbø̄e-pisibømem, teqa kha-te. Bøi ndabuá gimbøe-gutøvém, zenda sasa me꞉zuim, gimbo-einim, “Qo Mbumbukiam-ge manqa vevezam ezoqam toqogoat, qotínømánd, av nqægo, qo gekha ezoqām ndǿlavaq.” Yaq vos keoge ezoqam ndozáv, Yesu vø̄-ituim neka vø̄zuim. ");
INSERT INTO kvg_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita khoev uta mokho-te gu꞉qotam, yaq Mbumbukiam-ge iziz ezoqam kandambaqape, tegu sasae mbasønakam nømu ndowáv. ");
INSERT INTO kvg_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Yaq Pita gu-omet, gøinam-te kha geqoqoutumat, ndugu āv gumbøe-eín nqǽgo, “Até qó-a, Yesú namba qotegoám, ndego Nazalet-ak!” ");
INSERT INTO kvg_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Geté Pita gò꞉nawám, ge-ein, “No nø̀tenøtenák, qo gekhā qotē-manqate. Áv khoqoté-manqate?” Yaq Pita gewav, uta mboqog avønin-te gemø-itan, kokolok tùni-ogeá. ");
INSERT INTO kvg_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Yaq ngunuk mbasønakam, Pita nqawá gunø-omét. Yaq ezoqa nøme, avønin giwaniapam, ndugu āv guzømbe-eín nqǽgo, “Ezoqa nøme, Yesu namba ge꞉goam, ngének.” ");
INSERT INTO kvg_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Geté Pita gò꞉nawám. Agé outøpøteáv, ezoqa nøme, Pita-qa avønin-te giwaniapam, gimbo-einim, “Unimanqatín! Ezoqa nøme qó, te namba qazøtegoam. Zapa ndǿgo, até qó-a, Gelili plovins-ák.” ");
INSERT INTO kvg_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Yaq Pita gezø-qavøiu, “No unimanqatín nqazø-manqate. No nandev ezoqam nø̀tenøtenák, zo ndøzøte-manqate. No tøte-khavozumit, yaq Mbumbukiam kopømbaqapé, bèlavámb.” ");
INSERT INTO kvg_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pita nqanek manqat ge-ein, yaq ndaføyambá, kokolok nango tùndi-ogeá. Yaq Pita manqat gèmbo-matøvém, av Yesu gembøe-ein nqægo, “Kokolok menas naqanøká gé-ogeayák. Qo noqa yaq-te, ndòqotøkhæ-nawám. Misiká toqoto-nawam.” Yaq Pita mbøni mbová. Mbøni vaev kandambá, vø̄vin. ");
INSERT INTO kvg_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Yaq qanaqanus, lovølova-ús. Mbumbukiam-gi iziz ezoqa kandakanda neka Zu megetapak neka Mozes-qa guguna manqat nømendim ezoqam neka Zu ezoqam-gi manqa ovøyam megetapak ate gi꞉goam, matavap é-møndø-kopo꞉ném, Yesu ande gekha matev me mbógonēm. Yaq ndigu até gindigonem, gèløvønøvemém, Pailøt-qa zenda-te vømø̄veem. ");
INSERT INTO kvg_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Yaq Pailøt gembobevap, “Gê, qo Zu ezoqam-gê kawà?” Yaq Yesu gembo-qavøiu, “Nándav, av qo ndoqote-manqate.” ");
INSERT INTO kvg_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Yaq Mbumbukiam-gi iziz ezoqa kandakanda, manqa ndømøvøém te-te. Manqat kandambá gimøvøem. ");
INSERT INTO kvg_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Yaq Pailøt Yesu nqawá genømbo-beváp, gembo-ein, “Nqáe! Nginik manqa-zapazapa kandambá ngi-møvøet qo-te. Yaq ge qô, yaq manqa qavøiwat taqágo?” ");
INSERT INTO kvg_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Geté até nqawá, Yesu yaq manqa qavøiwateáv. Yaq Pailøt nqova ndafe kandambá. ");
INSERT INTO kvg_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Zu ezoqam-qa Pasova khøuwa kandambaqape-te, Pailøt, ndimbula ezoqa kopo sège-nqonqotavɨ́n, ezoqam-te, vø̄fakhanɨn, av ndigu qazømbe-poeɨn. ");
INSERT INTO kvg_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ta khøuwa-te ndøgo, ezoqa kopo ndimbula-te mø̀ndøgoám, ezoqa nøme namba. Teqa iz Balabás. Ndigu Lom gaman ngeasam-qa ndøgoám neka ezoqa vø̄laem. ");
INSERT INTO kvg_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Yaq ezoqa kopoáv, Pailøt-té ginduzáv, vømbō-einim, “Qo ambá ezoqa kopo qonqonqotavɨ́n, géfakhán, av oskia qoqote-goatun ndægo.” ");
INSERT INTO kvg_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Yaq Pailøt gezø-ein, “Zo gekhā zǿpoev? No ndégo tǽnqonqotāv, tefakhan, ndego Zu ezoqam-ge kawa ndimbo-akhayam?” ");
INSERT INTO kvg_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailøt mø̀ndæ-otév, Mbumbukiam-gi iziz ezoqa kandakanda, Yesu teqa zenda-te, ta zapaya ndǿgo tiniveém. Ndigu ova ndø-einím. ");
INSERT INTO kvg_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Geté Mbumbukiam-gi iziz ezoqa kandakanda, ezoqa ewaqape āv gizømbe-pouweát nqǽgo, “Pailøt Balabas betøndo-nqonqotáv, bavokho. Teoká ndego, Yesu.” ");
INSERT INTO kvg_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Yaq Pailøt ezoqa gezøbevap, “Av tægoat ndægo, yaq ngenek ezoqam, zo Zu ezoqam-ge kawa nqazombo-akhayam, gekha nombógō?” ");
INSERT INTO kvg_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yaq āv gini-akhaém nqǽgo, “Tae mutui-té qanø-tøkeó!” ");
INSERT INTO kvg_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Yaq Pailøt gezøbevap, “Gekha zapâ? Gê, ngenek gekha manqa-zapā ndǿgo?” Geté ndigu kandakanda nøme mba mo꞉-akhaemém, “Tae mutui-té qanø-tøkeó!” ");
INSERT INTO kvg_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Yaq Pailøt ezoqa khanakhanakh-qa ndøgoám. Yaq Balabas zønqonqotáv. Geté Yesu nakhag ezoqam-qá zenda-té genøvé, bemø̄feomem, tae mutui-te sasa bemø-tøkewem. ");
INSERT INTO kvg_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Yaq ndigu nakhag ezoqam, Yesu gaman-qá khoev-té ginøndafém, ta uta mokho-te vømø̄-on, neka nakhag ezoqa ewaqape vøzø̄-akha, te-te vøndō-pindam. ");
INSERT INTO kvg_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Yaq até gindigonem, ndabua køkouk, kopømba ande av kawa ezoqam-qa ndabua ndægo, vømbō-uzim. Yaq gumbag fakiafakia-us ndø-ogeaném. Yaq kawa-té gimbøe-uzím. Andé kawa ezoqam-qá wawáq. ");
INSERT INTO kvg_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Yaq ndigu khokho khanakhanakh manqat mbomanqatát te-te, gimbo-einim, “Zu ezoqam-ge kawa, iké꞉ qo-te.” ");
INSERT INTO kvg_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Yaq ndigu kawa-te, táe gimbøe-khanæmát, teqa kha-te, køse vømbø̄e-pisibømem. Yaq teqa megemege-te, katuk ndømøkuí, iz khokho vømbō-eqanem. ");
INSERT INTO kvg_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Otøotam gumuvewem, yaq ndabua køkouk, nqawá ginømbo-khofoném, neka ekeza ndabua vømbō-uzim. Yaq taon bavokhó ginø-ituím, tae mutui-te vømǿ-tøkewēm. ");
INSERT INTO kvg_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nakhag ezoqam, Yesu taon bavokho gi꞉-ituat, ezoqa ndø-ometám. Sailini taon-ák. Teqa iz Saemón. Aleksanda neka Lufus, tigé evé. Ndego ambá Zelusalem taon-té genømatín. Yaq nakhag ezoqam até gindigonem, ndego Yesu-qa tae mutui eqawat-qa yaq-te vø̄tøpøtøvem. ");
INSERT INTO kvg_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yaq Yesu ndǿgo tinøndafém, manqei iz nqambogo, Golgota. Taqa manqa mokho, “Kawa-pakha manqeí.” ");
INSERT INTO kvg_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Yaq Yesu ambá waen mbo-etøomemɨ́n. Mulømula-ús. Mel tae et namba me꞉tøkuaném. Nqosøgeap navap nonqó. Geté Yesu gèmbøeqasí. ");
INSERT INTO kvg_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Yaq Yesu tae mutui-té ginø-tøkewém. Gumu-tøkewem, yaq kas me꞉-otám, av nqægo, teqa ndabua vinivinimba-te ndøgo, gekha ezoqām, gekha ndabua ndǿ-upā. ");
INSERT INTO kvg_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ndøgo khøuwa iz 9 oklok qanaqanús, Yesu tae mutui-te gitøkewem. ");
INSERT INTO kvg_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tae mutui-te ova ndo꞉go, manqat ndøtøkeém, ndego andé gekha manqa-zapa zapayā ginīlaem. Āv qane-peaupám nqǽgo, “Ngenek Zu ezoqam-gé kawá.” ");
INSERT INTO kvg_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Yesu gitøkewem, pepen ezoqam menás namba me꞉tøkebám. Nøme ndego, teqa nakeamo zenda-té ginø-tøkewém, neka nøme ndego, yogea zenda-te vø̄tøkewem. ");
INSERT INTO kvg_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ezoqa gi-okhoat ndøgo, Yesu sège-ngenøitát. Kawa mba ndøngetæát, manqat vømbō-manqatat, av nqægo, “Qo Mbumbukiam-qa khoev ngi꞉wat-qa neka khøuwa misika mokho-te nango weve-qa qoqogoam, ");
INSERT INTO kvg_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","qo qakeza mokho-mba vø̀khandí꞉q. Soqotøndó-vís, nandav tae mutui-te.” ");
INSERT INTO kvg_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Yaq até Mbumbukiam-gí iziz ezoqa kandakandá-ya, Mozes-qa guguna manqat nømendim ezoqam neka megetapak nøme namba, otøotam me꞉vewém. Yaqyaq-a, āv gini-manqatám nqǽgo, “Ezoqa nøme gèkhandi꞉ztám. Geté ekeza kha, kopømba mbaín tekhandi. ");
INSERT INTO kvg_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ngenek unimanqatin Mesaya neka Izlael ezoqam-ge kawa tegoat, yaq ndakin yà betøndovís, nqanek tae mutui-te. Yaq ni tàbizi-unimanqatiním.” Até ndígu-a, Yesu namba gi꞉tøkebupam, Yesu otøotam me꞉vewém. ");
INSERT INTO kvg_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Yaq khøuwa muin qandap, qamat atema khagus 3 oklok vø̄ndap, manqei ate qægoam, bøivun ndønqeivøém. ");
INSERT INTO kvg_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Yaq 3 oklok qandap, Yesu kandambaqape tène-ogeá. Ekeza manqat-te āv gene-akhá nqǽgo, “Eloi, Eloi, lømá sabaxtáni?” Taqa manqa mokho nqánek, “Mbumbukiam, Mbumbukiam. Gekha zapâ, no qoqo-nøuvan?” ");
INSERT INTO kvg_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Geté ezoqa nøme, avønin giwaniapam ndøgo, teqa akhayam giyogem, ndigu manqa mokho ndapeáv. Yaq āv gini-einím nqǽgo, “Nqáe! Ngenek Ilaiza mbo-akhayám!” ");
INSERT INTO kvg_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Yaq ezoqa nøme até gendego, ndabua-qa ndøteít, waen khaqain-qape-te vø̄uqoqom, tae-te sasa ndøløvønam, Yesu vømbō-qantav. Izam-qa mbogoám. Yaq ge-ein, “Zíqeivím, Ilaiza petøndéwāv penømakhaya, vømbótøkē, tae mutui-te vǿkoqoiū.” ");
INSERT INTO kvg_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yaq Yesu kandambaqapé sege-ogeá, sasa ndønanim. ");
INSERT INTO kvg_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Yaq Mbumbukiam-qa khoev-te, ndabua ndøgo, khafeap kouwat mboqog-te qafaleam, livin-mbá qanømu-qatavát. Sa ová qandoqatá, atema manqei-te. ");
INSERT INTO kvg_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Yaq ndego nakhag kawa ezoqam, tae mutui-qa megemege-te go꞉yam, matev ge꞉qeiv, av Yesu ge꞉nanim, ndego āv gene-eín nqǽgo, “Ngenek unimanqatín Mbumbukiam-gé Yó.” ");
INSERT INTO kvg_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ta manqei-te ndøgo, até sakheís-a, vø̄goam. Andé qambaqapé gindu-waniapát, matev giqeivat. Ndigu sakheis, nømu Meli Magdala vemiav-ák, neka nømu Salomé, neka nømu Melí. Ngunuk Zems neka Zoses, tigú evó. (Ngenek Zems ezoqa ndakinák. Geté ezoqa nøme mø̀ndøgoám, iz kopo qambøegoam.) ");
INSERT INTO kvg_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yesu Gelili plovins-te ge-okhoam, nginik sakheis mø̀ndømbo-pavám, neka vømbō-tøkeam. Neka sakheis nøme kopoáv, Yesu namba gi꞉geavun, atema Zelusalem taon-te ndøgo. ");
INSERT INTO kvg_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ezoqa kopo mø̀ndøgoám. Teqa iz Zoséf. Alimatea vemiav-ák. Ndego manqa ovøyam ezoqam kandambaqape ndøgoám. Neka ndego Mbumbukiam-qá Megeat Matev-qa mo꞉kewagám. Yaq qakhagus ndøgo, Sabat khøuwa khakheinam khøuwa-te, ngenek Zosef, møe goneáv, geté Pailøt-té genøwáv, Yesu-qa kha-qa yaq-te vømømbō-viam. ");
INSERT INTO kvg_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Yaq Pailøt Yesu-qa løvøte manqat ge-ewag, nakhamas mba genanim, ndego nqova mbondáf. Yaq nakhag kawa mbo-akhá, vømbōbevap, “Yesu até unimanqatin ndǿnanim?” ");
INSERT INTO kvg_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Yaq ndego nakhag kawa gembo-unimanqatin, av nqægo, Yesu mø̀ndønanīm, Pailøt Zosef sègemboták, Yesu-qa kha tendap. ");
INSERT INTO kvg_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yaq Zosef ndabua papaqa møwí, Yesu-qa kha, tae mutui-te qatøkeam, vømøndō-koqa. Yaq teqa kha ndabuá geneløvønám, manqei ozu-te vø̄ndap. Ta manqei ozu ndøgo, nandi nqá. Yaq Zosef Yesu temø-utáv ndǿgo, nandi-qape vø̄-qambesam, manqei-pakha mboqog vø̄tok. ");
INSERT INTO kvg_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meli Magdala vemiav-ak, neka Meli ndugu, Zoses-gu evo, ndigu até gendo-kewagám, Zosef Yesu nandi nqa-te ge-utavat. ");
INSERT INTO kvg_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat khøuwa qame-navøem, yaq Meli, ndugu Magdala vemiav-ak, neka Meli, Zems-gu evo neka Salome, Yesu-qa kha-te gɨam nonqo, mulømula sisip mbomambaqape mø-wiím. ");
INSERT INTO kvg_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Yaq Sande qanaqanus, lovølova-us, khøuwa ge꞉fakhatavun, ndigu sakheis manqei pakha-té ginøzáv. ");
INSERT INTO kvg_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ndigu yaqyaq-a gibond, “Gekha ezoqām níqambesām, ndigu nandi-qapi, manqei-pakha mboqog ndætoke?” ");
INSERT INTO kvg_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Geté manqei-pakha-te gifakhaz, tiqeivím ndǿgo, mboqog gèmboqoatám. Nandi-qapi é-møndø-qambiním. Nginik nandi, kandamba tintív. ");
INSERT INTO kvg_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Yaq nandi nqa-te gi-oz, ezoqa ndakinak ndø-ometám. Nakeamo zenda-té geqotám. Ndabua papaqa ndø-uzám. Yaq ndigu møe kandambá gigonem. ");
INSERT INTO kvg_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Geté yaq ndego ezoqam gezø-ein, “Zo møe ndøgòne᷄m. No mø̀tenøtén. Zo Yesu-qa zovawét, ndego Nazalet-ak, ndego tae mutui-te gitøkewem. Ndego nqanek mbaín. Mbumbukiam mø̀ndø-khandí꞉v, løvøte-te. Nqáe! Manqei nqánek, gi꞉veem. ");
INSERT INTO kvg_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ndakin mòzozáv, Pita neka Yesu-gi paev ezoqa nøme, manqat vømøzø̄-ein. Āv qazozømbé-eín nqǽgo, ‘Gelili plovins-té genømá. Ndego é-ndo꞉má ndøgo, zoqa megemege-te. Yaq ndǿgo, tozomǿ-ometám, av bugukhokhof gezømbe-ein ndægo.’” ");
INSERT INTO kvg_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Yaq ndigu sakheis møe kandambá gigonem. Kha sègezømbu-wageapát. Yaq nandi nqa-te gindu-fakhaz, ndigu møe ndøbøín. Yaq ndigu ezoqa nøme-te einiáv, matev ndøgo giqeivim. Zapa ndǿgo, ndigu møe ndøgoném. ");
INSERT INTO kvg_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu Sande qanaqanus lovølova-us, løvøte-te gende-khandi꞉v, ndego bugukhokhof Meli Magdala vemiav-ak mbofakhán. Ngunuk sævam ndúgu, ibugukhokhof nqova soqøsoqa seven gimbøigoam, Yesu gumbo-ngeasam. ");
INSERT INTO kvg_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Meli Yesu gu-omet, yaq tegi paev ezoqam-té gunøwáv. Ndigu mutøkhop ndøwaniapát neka vø̄-eivumat. Yaq Meli manqat vømøzø̄-ein. ");
INSERT INTO kvg_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Geté manqat gimboyogem, av nqægo, “Yesu mø̀ndø-khandī꞉v. No mø̀e-omēt,” ndigu tuqa manqat gèqavotøvém. ");
INSERT INTO kvg_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Taqa zita-te, Yesu-gi paev ezoqa menas, Zelusalem taon gi꞉-ivavtat, Yesu sègezø-fakhán, nakhoa-te ndøgo. Geté ndego bugug viní. ");
INSERT INTO kvg_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Yaq nginik ezoqa menas, nqawá ginøveséz, tegi paev ezoqa nøme vømøzø̄-ein. Geté ndigu unimanqatinteáv, tiqa manqat. ");
INSERT INTO kvg_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yaq vaev Yesu ekeza paev ezoqa ileven-té genøfakhán, ate av-té lou gi꞉logat. Yaq ndego gèzøponqóm. Zapa ndǿgo, ndigu tiqa manqat unimanqatinteáv, ndigu Yesu gi-ometam, løvøte-te gendo-khandi꞉v. Mbøni gèzø-tokeapám. ");
INSERT INTO kvg_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yaq Yesu āv gezømbe-eín nqǽgo, “Manqei-qape ate nqægo, sozó-okhoát, ezoqa ewaqape, Manqat Mbomambaqape vømē-zømesim. ");
INSERT INTO kvg_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Gekha ezoqām ndego, te-unimanqatin neka ibøkha iz vǿndāp, ndego ndø̀mø-khandí꞉v. Geté gekha ezoqām ndego, unimanqatinteav tegoat, ndego yaq-fia nqosøgeap ndø̀qeív. ");
INSERT INTO kvg_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ezoqam ndigu ti-unimanqatintat, umingiap matev av nqǽgo giní-matønumát. Ndigu noqa iz-te, nqova soqøsoqa segé-ngeasumát, ezoqam-qa mokho-te tu꞉goat, neka manqat ndakinak vinivinimba vǿe-manqatāt. ");
INSERT INTO kvg_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Waza ti-upøgimat, o ibøkha mulømula-us ti-izumat, ndøgo ezoqa løvøte ndøzø-etoam, ndøgo géngiæzoák. Neka ndigu enqoni-us ezoqam-te, zenda tizømbø-aumat, yaq ndigu segé-khakhæzát.” ");
INSERT INTO kvg_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Evezøza Yesu, ti-te manqa manqate qamømbøe-navøem, yaq Mbumbukiam yan-té genøndáf, yaq ndego Mbumbukiam-qa nakeamo zenda-te vømø̄qom. ");
INSERT INTO kvg_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yaq tegi paev ezoqam sège-panqaním, neka Mbumbukiam-qa Manqat, manqei-manqei ate qægoam vømē-zømesim. Yaq Evezøza mø̀ndøzø-tøkeát, neka tiqa manqat, umingiap matev vinivinimba vøzømbē-unimanqatintat. ");
INSERT INTO kvg_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ezoqa kopoáv, emanqat amba-amba me꞉peaumám, ta matev vinivinimba-qa yaq-te, ni mokho-te qafakhanumam, av Mbumbukiam ge꞉manqatam, tøfakhanam. ");
INSERT INTO kvg_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ndigu manqat ndǿgo tipeaumám, av ezoqa nøme gi꞉zømesimam, ndigu matev ekeza bøi gi꞉qeivam, ande qandengaz atema vaev-te, neka ndigu ezoqa ewaqape vø̄e-zømesimam. ");
INSERT INTO kvg_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Até nó-a, no matev ate qægoam, mokho mø̀embo-vawát, vøemø̄qeiv, matev ande qandengaz, atema vaev-te. Yaq nakémbá, Tiofilus, nigi kandambaqape, no nqæmatavap, emanqat eqeieqei bataqa-peawám, matev ate ndægo, av qæfakhanumat. ");
INSERT INTO kvg_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","No tøtaqambé-peawám ndǿgo, qo tøneqatéq, manqat ndøgo, qo gi꞉qamekhæmam, ndøgo unimanqatín. ");
INSERT INTO kvg_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ta khøuwa-te ndøgo, Elod Zudia plovins-te kawa gegoam, Mbumbukiam-ge iziz ezoqam mø̀ndøgoám. Teqa iz Zekalayá. Mbumbukiam-gi iziz ezoqam-qa bawan-te, Abaeza gimbo-akhaemam, ndǿgo tunu꞉-sasaetám. Até tegú zás-a, Elon-gú ziú. Tuqa iz, Elizabét. ");
INSERT INTO kvg_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nginik ezoqa menas, tiqa yage eqeieqeí, Mbumbukiam-qa bøi-te. Manqa-zapazapa mbaín. Evezøza-qa guguna manqat neka khafeap ate ndægo ùni mbøepavám. ");
INSERT INTO kvg_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Geté ndigu nakheis mbaín. Zapa ndǿgo, Elizabet ndugu, sóg. Yaq ndakin ndigu ezoqa menas, khap mø̀ndøzøgó. ");
INSERT INTO kvg_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Khøuwa nøme, Zekalaya ekeza bawan namba, Mbumbukiam-ge iziz ezoqam-qa sasae gego, Mbumbukiam-qa megemege-te, ");
INSERT INTO kvg_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ndigu nandi-qasis ndønqagevemém, iz-ús, av Mbumbukiam-gi iziz ezoqam-qa matev qazømbe-goam. Yaq Zekalaya-qá iz ndøfakhán, Mbumbukiam-qa khoev mokho-te te-on, Mbumbukiam-te tae et sisip mbomambaqape temø-mboqotav. ");
INSERT INTO kvg_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Yaq Zekalaya Mbumbukiam-qa khoev-te, tae et gemø-mboqotav, ezoqa ewaqape, bavokhó gono-waniapám. Gò꞉guligulimát. ");
INSERT INTO kvg_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zekalaya Mbumbukiam-qa khoev-te gu꞉goam, yaq nqáe! Evezøza-gé enzol ezoqam mbofakhán, lou-qase-qa nakeamo-te vø̄-itan, ma Mbumbukiam-te, tae et sisip mbomambaqape qæmboqotavat. ");
INSERT INTO kvg_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Yaq Zekalaya ngenek enzol ezoqam ge-omet, ndego nqova mbondáf. Møe kandambá gego. ");
INSERT INTO kvg_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Geté ndego enzol ezoqam, āv gembøe-eín nqǽgo, “Zékalaya. Qo møe ndø̀go᷄. Mbumbukiam qoqa akhayam, mø̀ndøqa-ewág. Qogu sævam, Elizabet, nakhasam anganeam mbóqán. Yaq teqa iz Zion qombó-akhá. ");
INSERT INTO kvg_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ndego khanakhanakh qá-etoám, voqókhōum. Neka até ezoqá nømé-a, khanakhanakh ndø̀goném, teqa qane-qa yaq-te. Ezoqa kopoáv. ");
INSERT INTO kvg_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ndego ezoqam kandambaqape ndǿgoát, Evezøza-qa bøi-te. Ndego waen neka ibøkha føgøføgakh nøme be-ìza᷄m. Até ndøgó-a, evo-qa emu mokho-te tu꞉goat, teqa kha Nqova Mbomambaqape, é-ndømømbo-tønøyám. ");
INSERT INTO kvg_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ndego Izlael ezoqa kandambá, Evezøza-té gendó-qambuzú, tigi Mbumbukiam. ");
INSERT INTO kvg_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ndego Evezøza-qá megemege-té genǿmá. Ilaiza-qá bazaføgakh-té neka Nqova Mbomambaqape-ús. Yaq ndego evøndipakha-qa mbøni, nakheis-té genǿqambuá neka ezoqam ndigu, Mbumbukiam-qa manqa o-mba ndapeav ndigu, ndigu vǿ-enēnd neka ezoqa nøme-qa matev vømbó-paevēm, ma teqa manqa o-mba ndimbøe-ndape. Ndego Evezøza-gi ezoqam é-ndo꞉khakheinøvém, te nonqo.” ");
INSERT INTO kvg_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Yaq Zekalaya gembobevap, “Gê, no áv khaténøtēn, av nqægo, matev ndø̀fakhān, av qo qoqote-ein ndægo? No lawaqapé. Neka até nogú sævám-a, ndugu ngæpuká.” ");
INSERT INTO kvg_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Yaq enzol ezoqam gembo-qavøiu, “No Gebliél. No Mbumbukiam-qá megemege-té qatoyá. No ndégo tendo-khofotán, qo namba manqat vizí-einīm neka nqanek manqat mbomambaqape batēqamakh. ");
INSERT INTO kvg_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nqáe! Qo manqa-khou qógoát. Manqat qómanqateák, atema ta khøuwa-te ndøgo, nqanek matev vømǿfakhān. Zapa ndǿgo, qo noqa manqat unimanqatinteáv. Geté nqanek matev ndø̀mø-fakhán, ekeza khøuwa eqeieqei-te.” ");
INSERT INTO kvg_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Zekalaya nqanek matev qambøe-fakhan, yaq ezoqa ewaqape bavokho go꞉waniapam, gèmbøe-kewagát. Yaq ndigu gò꞉bevøpém, gekha zapâ Mbumbukiam-qa khoev-te khøuwa mba ngu꞉ngeaomit? ");
INSERT INTO kvg_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Yaq vaev-te gendo-fakhan, ndego kopømba mbaín, manqat te-ein. Yaq ndigu sògo-matøvemém, ngenek umingiap ndøqeív, Mbumbukiam-qa khoev mokho-te. Yaq ndego zendá gezømbe-khamasím. Manqat até gekhoutáv. ");
INSERT INTO kvg_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Yaq Zekalaya tege sasae khøuwa gumukhoub, Mbumbukiam-qa khoev-te ndøgo, ndego ekeza vemiav-té genøqaván. ");
INSERT INTO kvg_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Yaq khapé outøpøteáv, tegu zas Elizabet, emu tūnī-ītān. Yaq ndugu ekeza khoev mokho-te mbá gunu꞉goám. Løvøyak faév. ");
INSERT INTO kvg_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Yaq ndugu manqat āv guni-eín nqǽgo, “Evezøza matev kandambá gego, no-te. Ezoqa no gèsanqambám. Geté teqa kuku matev kandambá. Yaq ndego ndakin noqa mivi matev, mø̀ndønø-nqagím.” ");
INSERT INTO kvg_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabet løvøyak gimømbo-siks-ez, kha viniv-us guigoam, Mbumbukiam tege enzol ezoqam Gebliel, Nazalet vemiav-té genø-khofotáv, Gelili plovins-te ndøgo. ");
INSERT INTO kvg_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Mbasønakam-té genø-khofotáv. Tuqa iz, Melí. Ngunuk søvøta mba mbogoám. Anganeam-qa iz Zoséf. Ngenek Zosef, Deivid-gé zeó, ndego Izlael ezoqam-ge kawa kandambaqape gegoam. ");
INSERT INTO kvg_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Yaq Gebliel Meli-te gemøfakhan, ndego āv gumbøe-eín nqǽgo, “Khaiya mbomá. Mbumbukiam poev kandambá qo-te. Evezøza nandêgó, qo namba.” ");
INSERT INTO kvg_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Meli nqanek manqat gu-ewag, ndugu nqova ndafe kandambá. Yaq gò꞉beváp, nqanek manqat-qa mokho gekhām? ");
INSERT INTO kvg_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Yaq ndego enzol ezoqam gumbo-ein, “Méli. Qo møe ndø̀go᷄. Mbumbukiam kukú qo-te. Ndego qo ndøveatáq. ");
INSERT INTO kvg_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nqáe! Qo emu qoté-itán, voqoté-ovā. Nakhasam anganeám teqaqan. Yaq teqa iz Yesu qombó-akhá. ");
INSERT INTO kvg_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ndego kandambaqape ndǿgoát. Yaq ndego Mbumbukiam Eqeiwat-Qape-ge Yo mbó-akhaemát. Neka Evezøza Mbumbukiam, ndego kawa mó꞉vé, av tege atazøkha Deivid ge꞉goam. ");
INSERT INTO kvg_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ndego zo Izlael ezoqam, Zekop-gi zi, kawa zømbógoát, miavmiav. Teqa Megeat Matev gemǿ-navøemák.” ");
INSERT INTO kvg_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Yaq Meli ndego enzol ezoqam gumbobevap, “Gê, nqanek matev áv khanømbé-fakhān? No anganeam mbaín.” ");
INSERT INTO kvg_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Yaq ndego enzol ezoqam gumbo-qavøiu, “Nqova Mbomambaqape ndóvís qo-te, neka Mbumbukiam-qa bazaføgakh vǿgutāq, ndego Eqeiwat-Qape. Yaq nakémbá, ndego nakhasam-yo teqaqan, ndego ezoqam eqeieqei-qape ndǿgoát, yaq ndego iz Mbumbukiam-ge Yo mbó-akhaemát. ");
INSERT INTO kvg_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nqáe! Até Elizabét-a, qogu ezoqam, emu me꞉yǽt. Løvøyak síks. Ndugu ngæpuká. Ezoqa āv gimbøe-manqatám nqǽgo, ngunuk sóg. Geté ndugu ndakin nakhasam anganeam ndǿndáf. ");
INSERT INTO kvg_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Zapa ndǿgo, matev ate ndægo, Mbumbukiam kopømbaqapé, segé-matanám.” ");
INSERT INTO kvg_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Yaq Meli gundu-qavøiu, “Qanimáv. No Mbumbukiam-gú sasae ezoqám. Matev sà befakhán, av qo ndoqote-manqate.” Yaq ndego enzol ezoqam, tenø-iváv ndǿgo, vø̄wav. ");
INSERT INTO kvg_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Yaq khapé outøpøteáv, Meli gigiap tūnø̄-khākhēinām, manqei popotap-te vø̄wav, Zudia plovins-te ndøgo. Nakhamas-té gunømát. Yaq vemiav-te gumøfakhan, ");
INSERT INTO kvg_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ma Zekalaya geyagam, ndugu khoev-té gumø-ón, Elizabet khaiya mboma manqat vømbō-ein. ");
INSERT INTO kvg_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabet Meli-qa manqat gu-ewag, yaq nakhasam kha ndøkhokhók, tuqa emu mokho-te. Yaq Elizabet, kha Nqova Mbomambaqapé qambøe-tønøyám. ");
INSERT INTO kvg_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Yaq ndugu kandambaqapé sege-akhá. Āv guni-akhá nqǽgo, “Ni sakheis ate nqazi꞉gu-qa mokho-te, qo Mbumbukiam mø̀ndø-khakheinøqavém. Neka até nakhasám-a, qoqa emu mokho-te nandu꞉gu, ndego mø̀ndø-khakheinøvém. ");
INSERT INTO kvg_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Geté no gekha ezoqâm, noge Evezøza-gu evo, no-te gugeavun? ");
INSERT INTO kvg_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nqáe! No qoqa khaiya mboma manqat até vøe-ewág-ae, yaq nakhasam noqa mokho-te ngu꞉gu, khanakhanakh ndøgó. Kha ndøkhokhók. ");
INSERT INTO kvg_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Qo khanakhanakh mbá qanegó. Zapa ndǿgo, qo Evezøza-qa manqat mòqo-unimanqatín. Yaq matev ndøgo ndø̀fakhán, av geqambe-ein ndægo.” ");
INSERT INTO kvg_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Yaq Meli manqat āv guni-eín nqǽgo, “Noqa mbøni mokho-te, no Evezøza-qa iz ùni nøte-eqatét. ");
INSERT INTO kvg_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Neka no khóum, Mbumbukiam-te, ndego noge khandi etoam ezoqam. ");
INSERT INTO kvg_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","No tegú sasae mbasønakám. Ezoqa kandambaqapú mbá. Geté ndego mø̀ndønøménd. Yaq ndakin-a, atema tøma, ezoqa ate ti꞉mønøzumit, noqa yaq-te āv ginømbé-manqatát nqǽgo, ‘Ndugu kopømbá, khanakhanákh.’ ");
INSERT INTO kvg_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Zapa ndǿgo, ndego Mbumbukiam Eqeiwat-Qape, matev kandambaqapé genø-matanam. Ndego ndaføyamba-qapé. ");
INSERT INTO kvg_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Teqa tanakh matev até gémá, ezoqa ate ti꞉mønøzumit, ti-te ndigu, ndego timbo-vizupat. ");
INSERT INTO kvg_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Teqa zenda bazaføgakh-us, ndego matev kandakandá ge꞉matanam. Ezoqa ndigu gikhambuvupam, ndigu ekeza kha gi-eqatam, ndego gèpanqasám. ");
INSERT INTO kvg_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kawa ezoqa kandakanda, ndego sège-nqagevém, tiqa qonam nonqo-te gigoam, vø̄-khokho-ezoqam-ez. Geté ezoqa ndigu, ekeza kha eqawatav ndigu, ndego gè-eqazó. ");
INSERT INTO kvg_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ezoqa ndigu, ifi qazøvitam, loge gigiap mbomømboma me꞉zøkéf. Geté gigiap kopoav ezoqam, khakha-mbá sege-khofosám. ");
INSERT INTO kvg_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ndego ni Izlael bawan-ak, tegi sasae ezoqam, mø̀ndøni-tøké, neka ndego manqa mate navøepøteáv, teqa tanakh matev-qa yaq-te, ");
INSERT INTO kvg_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","av bugukhokhof nigi atanakha-zapazapa-za manqa mbusa gezømbeve, Eibleem neka tegi zi, av nqægo, teqa tanakh matev segēmā ni-te, miavmiāv.” ");
INSERT INTO kvg_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meli løvøyak ande āv misiká ndi꞉gú, Elizabet namba gi꞉søkhoam, yaq taqa zita-te, ekeza vemiav-te nqawa sasa ndøqavan. ");
INSERT INTO kvg_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ta khøuwa-te ndøgo, Elizabet qakhantav, gui-ova, nakhasam anganeám gemboqan. ");
INSERT INTO kvg_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Yaq ezoqam ndigu, avønin gimbo-puatat neka ekeza ezoqam, giyogem av nqægo, Evezøza tanakh-qapē gumbogo, nakhasam gumboqan, yaq ndigu khanakhanakh kandambá gindapem, tu namba. ");
INSERT INTO kvg_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Yaq opønakam-yo khøuwa eit qamømbo-ndap, ezoqam ndigu tegi ngusum qogøzat matev-qa yaq-te gimøvab, ndigu ambá eve-qá iz mbo-akhaemɨ́n, Zekalaya. ");
INSERT INTO kvg_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Geté tegu evo, āv guni-eín nqǽgo, “Āv taoká. Teqa iz Zion ndǿgoát.” ");
INSERT INTO kvg_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Yaq ndigu gimbo-qavøinam, “Geté zogi zøkeza ezoqam, iz mbaín, av nandægo.” ");
INSERT INTO kvg_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Yaq ndigu eve gèmbøe-khamasimím, av nqægo, teqa poev gekhâm, ndego ande gekha iz me mbó-akhā, nakhasam. ");
INSERT INTO kvg_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Yaq ndego peawam nonqo gigiap-qa ndøgoám, vømbō-etøomem. Yaq ndego āv gene-peawám nqǽgo, “Teqa iz Zión.” Yaq ezoqa ewaqape, nqova ndafe kandambá. ");
INSERT INTO kvg_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Yaq nqova mbaín, Zekalaya, kumam nqawa gembosasae, manqa manqate vø̄ngaz, Mbumbukiam-qa iz sasa ndø-eqa. ");
INSERT INTO kvg_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Yaq ezoqa ewaqape, avønin gizø-puatat, ndigu nqova ndafe kandambá, neka møe ndøgoném. Yaq nqanek manqat, Zudia plovins manqei popotap-te ate qægoam, sùgumu-panqavøemát. ");
INSERT INTO kvg_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yaq ezoqa ewaqape, nqanek manqat giyogem, ndigu matavap kandambá gigonem. Āv gini-einím nqǽgo, “Gê. Ngenek nakhasam-yo, andé gekha ezoqam me mé꞉goāt?” Ndigu āv gini-matøvemém nqǽgo, Mbumbukiam-qa bazaføgakh ndø̂gó, te namba. ");
INSERT INTO kvg_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yaq Zekalaya, nakhasam-yo-ge eve, kha Nqova Mbomambaqapé qambøe-tønøyám. Yaq ndego Mbumbukiam-qá manqat ndøvevezám. Manqat āv gene-eín nqǽgo, ");
INSERT INTO kvg_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Evezøza-qa iz, yà beto-eqawát, ndego Izlael ezoqam-ge Mbumbukiam. Ndego ni tøke-qa ndowáv, ni tegi ezoqam. Yaq génqovotán. ");
INSERT INTO kvg_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ndego khandi etoam ezoqam bazaføgakh-qape nindo-khofotáv. Ngenek tege sasae ezoqam Deivid, tegé zeó. ");
INSERT INTO kvg_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nupøkhán mbá, ndego tegi manqa vevezam ezoqam mokho-te, ndigu gevevesam, āv gene-eín nqǽgo: ");
INSERT INTO kvg_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ndego ni ndø̀khandí꞉n, nigi qaqa ezoqam-qa zenda-te nqazu꞉gu neka ezoqa ewaqape-qa zenda-te, ndigu ni ndisanqana. ");
INSERT INTO kvg_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ndego ni tanakh nigú, av nigi atanakha-zapazapa-za gezømbe-ein. Poev matev ndøgo, ti namba ge꞉-unimanqatin, ndego manqa mate navøepøteáv. ");
INSERT INTO kvg_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Mbumbukiam nigi atanakha-zapa Eibleem, manqa mbusa āv gembøevé nqǽgo, ");
INSERT INTO kvg_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ndego ni ndø̀khandí꞉n, nigi qaqa ezoqam-qa zenda-te nqazu꞉gu. Yaq ni kopømbaqapé. Møe zígoák, teqa iz tizi-eqatat, ");
INSERT INTO kvg_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","neka niqa yage-te, khøuwa ate tægoat, ndaføyamba vizíyagāt neka niqa matev eqeieqei vǿgoāt, teqa bøi-te. ");
INSERT INTO kvg_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Yaq qo, noge yo, qo Mbumbukiam-gé manqa vevezam ezoqam qá-akhaemát, ndego Eqeiwat-Qape. Zapa ndǿgo, qo Evezøza-qá megemege-té qoqotǿmá. Teqá nakhoa qotǿ-khakheinumít. ");
INSERT INTO kvg_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Qo tegi ezoqam, āv qoqoté-zømesimít nqǽgo: Mbumbukiam tiqa manqa-zapazapa ndø̀-evøzám neka vǿkhandī꞉z. ");
INSERT INTO kvg_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Zapa ndǿgo, nigi Mbumbukiam-qa kuku matev neka tanakh matev kandambaqapé. Khandi etoam matev andé khøuwa me mé꞉fakhatáv. ");
INSERT INTO kvg_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Yaq ezoqa waev zǿ-etoám, ndigu bøivun-te neka løvøte-te ndiyage. Yaq ndigu sambi yage-té genǿ-itúb.” ");
INSERT INTO kvg_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yaq Zion gèkhouwév, neka nqova-te bazaføgakh vømbōgo. Yaq ndego leg-av manqei-té geyagám, atema ta khøuwa-te ndøgo, ezoqa ewaqape-qa megemege-te vō꞉-itan, ndigu Izlael manqei-ak. ");
INSERT INTO kvg_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ta khøuwa-te ndøgo, Siza Ogastes, ndego Lom kawa ezoqam kandambaqape, manqat āv gene-vøovám nqǽgo: Ezoqa ewaqape, manqei-manqei ate qægoam, Lom gaman gimbo-kewagam, tiqa iziz gaman-qá mbuk-té qabe-peawáp. ");
INSERT INTO kvg_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ezoqa gevebam matev av nqægo, khokhofá qafakhan, Lom gaman-qa mokho-te. Ta khøuwa-te ndøgo, Silia plovins-te, Kuilinius kawa ndøgoám. ");
INSERT INTO kvg_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Yaq ezoqa ewaqape, ekeza vemiav-té ginø-qavøním, tigi atanakha-zapazapa-za ma gindizav ndøgo, iziz vømø̄-awam. ");
INSERT INTO kvg_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yaq até Zoséf-a, Nazalet vemiav, Gelili plovins-te ndøgo, gè-iváv. Yaq Deivid-qá vemiav-té genøqavíg, Zudia plovins-te ndøgo. Zapa ndǿgo, ndego Deivid-gé zeó. Ta vemiav-qa iz Betliém. ");
INSERT INTO kvg_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yaq iz vee-qa gewav, Melí namba me꞉-apát. Ndigu søvøta mba zøgoám. Geté Meli ndugu, emu-ús. ");
INSERT INTO kvg_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Yaq Betliem vemiav-te gi꞉sokhoam, Meli tùni-ová. ");
INSERT INTO kvg_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nakhasam gemboqan, anganeám. Meli-gé nakhasa khøuwá. Yaq ndabuá guni-løvønøvém, kao lou loge nonqo-te sasa ndøve. Zapa ndǿgo, khoev kouwat ndøgo, ma okha ezoqam gisømbi꞉matun, løvøzupøteáv. Gùmukhazém. ");
INSERT INTO kvg_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ta lova ndøgo, Betliem vemiav bavokho, sip keoge ezoqam mø̀ndøgoám. Sip zøkewagát. ");
INSERT INTO kvg_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Yaq nqova mbaín, Evezøza-gé enzol ezoqam zøfakhán. Yaq Evezøza-qa waev-qape, sùgumu-gutavát, ndigu sip keoge ezoqam. Yaq ndigu møe kandambá gigonem. ");
INSERT INTO kvg_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Geté ndego enzol ezoqam gezø-ein, “Zo møe ndøgòne᷄m. Nqáe! No manqat mbomambaqape nondapavún zo-te. Ndøgo ezoqa ewaqape khanakhanakh zǿ-etoám. ");
INSERT INTO kvg_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nqægo lova, Deivid-qa vemiav-te, Betliem, khandi etoam ezoqam ndøqán, zo-te. Ndego Kelisó. Evezøzá. ");
INSERT INTO kvg_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Zo ngenek nakhasam, āv qazøté-ometám nqǽgo: Ndego ndabua løvønøváp, neka kao lou loge nonqo mokho-té gunu꞉-utøvé.” ");
INSERT INTO kvg_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Yaq nqova mbaín, enzol ezoqa nøme kopoav-qape ndøfakház. Mbumbukiam-qá iz ndø-eqatát. Āv gini-manqatám nqǽgo, ");
INSERT INTO kvg_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Mbumbukiam-qa iz yà beto-eqawát, ndego uni ova-in ngo꞉yage. Manqei-qape-te nqanek, sambi matev ndǿfakhán, ndigu ezoqam-te, Mbumbukiam ndømbopoev.” ");
INSERT INTO kvg_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Yaq enzol ezoqam, yan-te nango giqavaz, ndigu sip keoge ezoqam āv gini-einím nqǽgo, “Bìziniáv, Betliem vemiav-te ndøgo, matev bizimø̄-qeivim, av Evezøza manqat ginindi-khofotav ndægo.” ");
INSERT INTO kvg_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yaq nakhamas-té ginøzáv, Meli neka Zosef neka nakhasam vømø̄zømet, ndego kao lou loge nonqo-te gu꞉qeiam. ");
INSERT INTO kvg_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nakhasam gi-ometam ndøgo, yaq ndigu emanqat me꞉vototém, av enzol ezoqam, nakhasam-qa yaq-te gezømbe-ein. ");
INSERT INTO kvg_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Yaq ezoqa ewaqape, sip keoge ezoqam-qa manqat giyogem, ndigu nqova ndafe kandambá. ");
INSERT INTO kvg_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Geté Meli ndugu, matavap mba ndø-aumát, matev ate ndægo qambo-fakhanumat. Ndugu oskia mbomatavupám. ");
INSERT INTO kvg_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Yaq sip keoge ezoqam giqavanat, ndigu Mbumbukiam-qa iz até go꞉-eqatát neka ike manqat vømbō-manqatat, matev ate qægoam-qa yaq-te, giyogem neka vø̄qeivim. Matev āv tønefakhán, av enzol ezoqam gezømbe-ein. ");
INSERT INTO kvg_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yaq nakhasam-yo khøuwa eit qamømbo-ndap, tegi ngusum gi꞉kepøtøzem, iz Yesu mbo-akhaém, ate av-té, av enzol ezoqam Meli gumbøe-ein, ndugu emu itøneav qagoam. ");
INSERT INTO kvg_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Yesu ge꞉qan, yaq khøuwa foti-qa zita-te, Meli kha sunguzam matev qamømbøe-navøem, av Mozes-qa guguna manqat qæ-ein, nakhasam ge꞉qanɨn, yaq Zosef neka Meli, Mbumbukiam-qá khoev-té ginøzáv, Zelusalem taon-te ndøgo, Yesu Evezøza-qa zenda-te vømǿveēm. ");
INSERT INTO kvg_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Taqa yaq-te, Evezøza-qa guguna manqat, āv qane-eín nqǽgo, “Nakhei angana ate ti꞉goat, bugukhokhof tiqanet, ndigu Evezøza-gi ndǿgoát.” ");
INSERT INTO kvg_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Yaq ndigu etoam matev møgoném, Mbumbukiam-te, av Evezøza-qa guguna manqat qæ-ein. Ndøgo āv qane-eín nqǽgo: Kuvøkuvu o mumuk nakhei menas qó-áb. ");
INSERT INTO kvg_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Zelusalem taon-te ndøgo, ezoqa mø̀ndøgoám. Teqa iz Simeón. Ndego ezoqam ndaføyamba-qapé neka Mbumbukiam mbovizupám. Ndego teqá tenø-kewagám ndégo, Izlael ezoqam tekhandi꞉z. Mbumbukiam-gé Nqova Mbomambaqape mo꞉goám, te-te. ");
INSERT INTO kvg_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nqova Mbomambaqape, ndego āv gene-omát nqǽgo: Ndego naqanøká génanimák. Geté Mesaya ndø̀khæ-omét, ndego Evezøza tendo-khofotav. ");
INSERT INTO kvg_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ta khøuwa-te ndøgo, Nqova Mbomambaqape, Simeon Mbumbukiam-qá khoev-té genø-itú. Yaq Meli neka Zosef, Yesu gindu-ndafem, gindu-oz, matev tigonem, av Mozes-qa guguna manqat qæ-ein, ");
INSERT INTO kvg_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","yaq Simeon até gendego, nakhasam gèndāf, Mbumbukiam ike manqat vømbō-ein. Āv gene-eín nqǽgo, ");
INSERT INTO kvg_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Evézøza Eqeiwat-Qape. Manqa mbusa ndøgo, no-te qoqove, mø̀ndø-unimanqatín. Yaq no, qoge sasae ezoqam, ndakin kopømbá, mbomambá sǽnaním. ");
INSERT INTO kvg_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","No ndakin qoqa ezoqa khandi꞉zat matev, nøkeza bøí qateqeív, ");
INSERT INTO kvg_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ndøgo qo bawabawan ate ndægo nonqo qoqo-khakheinam. ");
INSERT INTO kvg_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ngenek bawan vini-ak-qá waev ndǿgoát, neka Mbumbukiam-qa yaq-te vøzømbé-vevezumāt, neka ni Izlael-ak, qogi bawan ezoqam, iz kandambaqape vønígoāt.” ");
INSERT INTO kvg_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeon nqanek manqat ge-ein, yaq ndigu evøndipakha, nqova ndafe kandambá. ");
INSERT INTO kvg_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Yaq Simeon zenda mo꞉vé ti-te, vøzø̄-guligulim. Yaq ndego Meli gumbo-ein, “Nqáe! Mbumbukiam ngenek nakhasam tene-veatáv ndǿgo: Ezoqa kopoáv gé-o꞉atát, ndego tisanqawat, neka ezoqa kopoav vǿwaniapāt, ndego ti-unimanqatintat, nqanek Izlael manqei-te. Ndego Mbumbukiam-qá khakhatap ndǿgoát. Geté ezoqa kopoav gembó-sanqaupát. ");
INSERT INTO kvg_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Yaq, qo Meli, qoqa mbøni andé nakhag kaiya me qambé-keqáz. Timbo-sanqaupat, yaq ezoqam-qa matavap, khonoam-te ndøgo, segendó-veveám.” ");
INSERT INTO kvg_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ezoqa nøme mø̀ndøgoám, Mbumbukiam-qa khoev-te ndøgo. Sævám. Tuqa iz, Ená. Ndugu Mbumbukiam-gú manqa vevezam ezoqám. Fanuel-gú yú. Asa khagua bawan-ák. Ndugu ngæpuká. Anganeam namba gi꞉yagam, viav seven mbá, yaq tēnø̄-nānīm. ");
INSERT INTO kvg_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Yaq ndugu tuni-ngæmam-év ndǿgo, atema ndakin, viav 84 vømbōndap. Ndugu Mbumbukiam-qa khoev løvøinøvemáv. Pavpave neká lovølova, Mbumbukiam-qá iz mba ndø-eqatám, lou logemav matev vø̄goam-a, vø̄guligulimam. ");
INSERT INTO kvg_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeon ate av-té Meli neka Zosef namba manqat gi꞉manqatam, yaq ndugu tùndiwáv, Mbumbukiam-qa iz vø̄-eqa neka ezoqa ewaqape nakhasam-yo-qa yaq-te vø̄ezømas, ndigu khandi etoam ezoqam gimbøe-kewagam, ndego Zelusalem ezoqam tenqovotaz. ");
INSERT INTO kvg_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Zosef neka Meli, matev ate ndægo gumugonem, av Evezøza-qa guguna manqat ndæmanqate, ndigu ekeza vemiav-té ginøqaváz, Nazalet, ndøgo Gelili plovins-te. ");
INSERT INTO kvg_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yaq ndego nakhasam gekhouwevtat, bazaføgakh-ús neka matavap loloakh-ús. Neka Mbumbukiam-qá kuku matev mo꞉goám te-te. ");
INSERT INTO kvg_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Viav-viav ate qægoam, Yesu-gi evøndipakha, Zelusalem taon-té ginø-okhoám, Pasova khøuwa kandakanda matev vømø̄-gonemɨn. ");
INSERT INTO kvg_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yaq Yesu viav tuelv qamømbøe-ndap, até ndegó-a, ti namba møvømbam khøuwa kandakanda-te vø̄wav, av tiqa matev qazømbe-goam. ");
INSERT INTO kvg_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Yaq pindap qamezømbe-navøem, tegi evøndipakha gi꞉qavanat, Yesu Zelusalem taon-té segeqóm. Geté tegi evøndipakha zøtezateáv. ");
INSERT INTO kvg_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ndigu gimatavupam, ezoqá nømé namba me꞉qavanét. Geté khøuwa seke gingiaumat, gi꞉-apat, ndigu tigi ekeza ezoqam neka zifuap-te amba mbøevawém. ");
INSERT INTO kvg_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Geté ndigu ometeáv. Yaq Zelusalem taon-té ginøveséz, vømømbō-vawem. ");
INSERT INTO kvg_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yaq khøuwa misika-qa zita-te, Mbumbukiam-qá khoev-té gi-ometám. Mbumbukiam-qá Manqat nømendim ezoqám namba me꞉qonavám. Tiqá manqat ndø-ewagát, neka vøzø̄-sinøzumat. ");
INSERT INTO kvg_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ezoqa ewaqape, teqa manqat giyogem, ndigu teqa otevat neka manqa qavøiwat-qa yaq-te, nqova zøndáf. ");
INSERT INTO kvg_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Yaq tegi evøndipakha gi-ometam, ndigu nqova ndafe kandambá. Yaq evo gumbo-ein, “Áti. Gekha zapâ, qo matev av nqægo qoqoni-matanam? Nqáe! No qave namba, fofogeap kandambá qeitaqa-goat, amba qeitaqambe-vawat.” ");
INSERT INTO kvg_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yaq Yesu gezø-qavøiu, “Gekha zapâ, no qazonø-vawat? Gê, zo zøtezateâv, av nqægo, no Tat-qā khoev-tē qabatu꞉gū?” ");
INSERT INTO kvg_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Geté ndigu manqa mokho ndapeáv, gekhā mé꞉manqatam. ");
INSERT INTO kvg_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yaq Yesu evøndipakha namba, ekeza vemiav-té ginøqaváz, Nazalet. Yaq ndego tiqa manqat o-mba zømbo-ndapám. Geté Meli ndugu, matavap mba ndø-aumát, matev ate ndægo, qambo-fakhanumat. ");
INSERT INTO kvg_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yaq Yesu gekhouwevtat, até matavap loloákh namba sege-khouwevtát, Mbumbukiam neka ezoqam, kuku vøzø̄goam te-te. ");
INSERT INTO kvg_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ta viav-te ndøgo, Siza Taibilies viav 15 Lom kawa ezoqam kandambaqape gegoam, neka Pontius Pailøt, Zudia plovins-te, Lom gaman ezoqam vø̄goam, neka Elod Gelili plovins vømbō-kewagam, neka tege eveqase Filip, Itulia neka Tlakonitis manqei vømbō-kewagam, neka ndego Lisanias, Ebilin manqei vømbō-kewagam, ");
INSERT INTO kvg_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","neka Anas neka Kayafas Mbumbukiam-gi iziz ezoqa kandakanda vø̄goam, yaq Zion-te, ndego Zekalaya-ge yo, Mbumbukiam-qá manqat ndøfakhán. Ta khøuwa-te ndøgo, Zion leg-av manqei-té gegoám. ");
INSERT INTO kvg_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yaq ndego até gendego, Zoden kea avønin-te, manqei-manqei ate qægoam sège-okhoám, ezoqa vø̄e-zømesimam, av nqægo, “É-mozoqambúz, neka ibøkha iz vø̄-upøgim. Yaq Mbumbukiam zoqa manqa-zapazapa, ndø̀mbøe-navøém.” ");
INSERT INTO kvg_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Matev āv tønefakhán, av Mbumbukiam-ge manqa vevezam ezoqam Aezaya, mbuk-te ge꞉peawam. Ndego āv gene-peawám nqǽgo, “Leg-av manqei-te ndøgo, ezoqam-qa manqa wag ndǿ-akhayam. Āv qane-akhayám nqǽgo, ‘Evezøza-qa nakhoa é-mozoto-khakheinømém. Nakhoa ndaføyamba-qape zombøé-viæém, ndego te꞉geav. ");
INSERT INTO kvg_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Manqei tømbuvap ate ndægo, manqei nøme bètø-awáp, neka manqei popotap ate ndægo, bèmøkuiáp. Nakhoa ndøkhafigeapet, bèndaføyá, neka nakhoa ndø-asøtavet bēgevøem. ");
INSERT INTO kvg_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Yaq ezoqa ewaqape, Mbumbukiam-qa khandi etoam matev ndǿqeivím.’” ");
INSERT INTO kvg_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ezoqa kopoáv, ibøkha iz ndape-qa ginduzav, Zion-te. Geté ti-te ndigu, khokho sa ginduzav, ndego āv gezømbe-manqatám nqǽgo, “Zo waza soqøsoqa. Ge zô, ndozo-matavap? Zo é-ndozó-khokhoz, Mbumbukiam-qa qaqa tøfakhan?” ");
INSERT INTO kvg_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Matev eqeieqei vø̀khæ-matønømém. Yaq mokho tøfakhan ndøgo, tǿ-unimanqatín ndǿgo, zo unimanqatin zoqambúz, Mbumbukiam-te. Neka zøkeza mokho-mba ndømanqàte᷄, av nqægo, ni Mbumbukiam gēngiænoāk, zapa ndø̄go, ni Eibleem-gī zī. No nqazǿ-manqate: Mbumbukiam kopømbaqapé, nginik nandi manqat mba zǿ-eín. Yaq segé-Eibleem-gí-zi-íz. ");
INSERT INTO kvg_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ila khakheinøváp. Tae ndǿbóu. Zapa-té qanømú-løvuvøemét. Gekha tāe ndøgo, nanga eqeieqei vi꞉mav ndøgo, gébouím, gøinam-te vǿnqagimēm. ");
INSERT INTO kvg_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yaq ezoqa ewaqape, manqat gimboyogem, āv gimbøe-bevøpém nqǽgo, “Av tægoat ndægo, yaq ni gekha nígonēm?” ");
INSERT INTO kvg_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yaq Zion gezø-qavøiu, “Gekha ezoqām ndego, ndabua menas tømbogoat, nøme tèabembo-etoám ndego, ndabua mbain ndego. Neka gekha ezoqām ndego, lou tømbogoat, yà bembo-etoám ndego, lou mbain ndego.” ");
INSERT INTO kvg_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Até teks moni upøgim ezoqám-a, ibøkha iz ndape-qa vøndōzav. Yaq Zion gimbo-bevøpem, “Nøméndim ezoqam. Gebâ ni? Gekhā nígonēm?” ");
INSERT INTO kvg_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yaq gezø-qavøiu, “Zo ezoqam-te, teks moni ndozo-upøgim, zo nøme khokho ndø-upø̀gi᷄m. Sà tø-upøgím ndigu, av gaman iziz ge꞉ve.” ");
INSERT INTO kvg_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Até nakhag ezoqám-a, Zion gimbo-bevøpem, “Gebâ ni? Gekhā nígonēm?” Yaq gezø-qavøiu, “Ezoqa moni etoam-qa yaq-te ndøtøpøtø̀za᷄t. Neka meakha manqat ndømanqàte᷄, ezoqam-qa yaq-te, ti-te moni upøgim nonqo. Ság, moni ndigu, gaman-te ndozo-upøgim.” ");
INSERT INTO kvg_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ezoqa ewaqape, khandi etoam ezoqam-qa mo꞉kewagám. Yaq ndigu Zion-qa matev giqeivim, gò꞉bevøpém, “Éisa. Ngenek Mesayá agegó, ndego ezoqam, Mbumbukiam tendo-khofotav, ni tekhandi꞉n.” ");
INSERT INTO kvg_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Geté Zion gèzø-ovøyám, gezø-ein, “No Mesayá mbá. No zo ibøkha iz, ibøkhá qazømbe-etoumít. Geté ndego, noqa zita-te ngegeav, ndego no ùnime꞉-løvumbám. No ezoqa khàpe nøte-khapelavøqase-én. Até nqanek sasae khapelavøqasé-a, no teqa tamak khofoe-te tæmbotøke, no kopømba mbaín. Ndego zo ibøkha iz, Nqova Mbomambaqapé neka gøina wageáp gezømbé-etoumát. ");
INSERT INTO kvg_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ndego andé wit nanga evem ezoqam me mé꞉geáv. Wit evem nonqo ndǿ-ndapaváv. Yaq wit nanga ndǿ-evém, neka louzi nonqo ndigu, lou nqeitam nonqo khoev-té genǿ-nqeisám. Geté tag ndøgo, gøinam-té genǿløvutám. Ta gøinam ndøgo, miavmiav ndøwageáp. Khouvøemáv.” ");
INSERT INTO kvg_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Zion ezoqa guguna manqat vinivinimbá gezø-manqatam, kopoáv, neka Mbumbukiam-qa Manqat Mbomambaqape vø̄e-zømesimam. ");
INSERT INTO kvg_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Elod-qa yaq-te, ndego kawa ezoqam, Zion āv gene-eín nqǽgo, “Ngenek manqa-zapa ndøgó, namba qawan-gu zas, Elodias, sa geviwam, vø̄-okɨ neka matev soqøsoqa nøme kopoav vø̄matanam.” ");
INSERT INTO kvg_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Yaq vaev-te, Elod matev soqa nøme mba mo꞉matanám, ndøgo Zion ndimbula-te ge-utav. ");
INSERT INTO kvg_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Zion ezoqa ewaqape ibøkha iz gezø-etoumat, yaq até Yesú-a, ibøkha iz vø̄ndap. Yaq Yesu ate av-té ge꞉guligulimat, yan tø̀ne-mboqoé. ");
INSERT INTO kvg_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Yaq Nqova Mbomambaqape ndovís, te-te vō꞉qom. Bugug andé kuvøkuvuám. Yaq yan-te ndo꞉go, manqa wag ndofakhán. Āv qande-eín nqǽgo, “Qo nogé Yó. No poev kandambá qo-te. No nø̀taqambo-khafuát.” ");
INSERT INTO kvg_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu Mbumbukiam-qa sasae ge꞉ngaz, ndego viav ande āv 30́ ndægó. Ezoqa āv gini-matavupám nqǽgo: Ndego Zosef-gē yō. Zosef, ndego Eli-gé yó. ");
INSERT INTO kvg_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli, ndego Matat-gé yó. Matat, ndego Livai-gé yo. Livai, ndego Melki-gé yó. Melki, ndego Zenai-gé yó. Zenai, ndego Zosef-gé yó. ");
INSERT INTO kvg_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Zosef, ndego Matataias-gé yó. Matataias, ndego Amos-gé yó. Amos, ndego Naum-gé yó. Naum, ndego Esli-gé yó. Esli, ndego Nagai-gé yó. ");
INSERT INTO kvg_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai, ndego Mat-gé yó. Mat, ndego Matataias-gé yó. Matataias, ndego Semein-gé yó. Semein, ndego Zosek-gé yó. Zosek, ndego Zoda-gé yó. ");
INSERT INTO kvg_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Zoda, ndego Zoanan-gé yó. Zoanan, ndego Lesa-gé yó. Lesa, ndego Zelubabel-gé yó. Zelubabel, ndego Sealtiel-gé yó. Sealtiel, ndego Neli-gé yó. ");
INSERT INTO kvg_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli, ndego Melki-gé yó. Melki, ndego Adi-gé yó. Adi, ndego Kosam-gé yó. Kosam, ndego Elmadam-gé yó. Elmadam, ndego E-gé yó. ");
INSERT INTO kvg_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","E, ndego Zosua-gé yó. Zosua, ndego Elieza-gé yó. Elieza, ndego Zolim-gé yó. Zolim, ndego Matat-gé yó. Matat, ndego Livai-gé yó. ");
INSERT INTO kvg_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai, ndego Simeon-gé yó. Simeon, ndego Zuda-gé yó. Zuda, ndego Zosef-gé yó. Zosef, ndego Zonam-gé yó. Zonam, ndego Eliakim-gé yó. ");
INSERT INTO kvg_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim, ndego Melea-gé yó. Melea, ndego Mena-gé yó. Mena, ndego Matata-gé yó. Matata, ndego Neitan-gé yó. Neitan, ndego Deivid-gé yó. ");
INSERT INTO kvg_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Deivid, ndego Zesi-gé yó. Zesi, ndego Obed-gé yó. Obed, ndego Boaz-gé yó. Boaz, ndego Salmon-gé yó. Salmon, ndego Nason-gé yó. ");
INSERT INTO kvg_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason, ndego Aminadab-gé yó. Aminadab, ndego Admin-gé yó. Admin, ndego Ani-gé yó. Ani, ndego Ezlon-gé yó. Ezlon, ndego Pelez-gé yó. Pelez, ndego Zuda-gé yó. ");
INSERT INTO kvg_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Zuda, ndego Zekop-gé yó. Zekop, ndego Aezek-gé yó. Aezek, ndego Eibleem-gé yó. Eibleem, ndego Tela-gé yó. Tela, ndego Nao-gé yó. ");
INSERT INTO kvg_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nao, ndego Selug-gé yó. Selug, ndego Leu-gé yó. Leu, ndego Peleg-gé yó. Peleg, ndego Eba-gé yó. Eba, ndego Sela-gé yó. ");
INSERT INTO kvg_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela, ndego Kenan-gé yó. Kenan, ndego Afaksad-gé yo. Afaksad, ndego Sem-gé yó. Sem, ndego Noa-gé yó. Noa, ndego Lamek-gé yó. ");
INSERT INTO kvg_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek, ndego Metusela-gé yó. Metusela, ndego Inok-gé yó. Inok, ndego Zaled-gé yó. Zaled, ndego Malalel-gé yó. Malalel, ndego Kenan-gé yó. ");
INSERT INTO kvg_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan, ndego Enos-gé yó. Enos, ndego Set-gé yó. Set, ndego Adam-gé yó. Neka Adam, ndego Mbumbukiam ndøkhakheinøvém. ");
INSERT INTO kvg_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu Zoden kea-te gegoam, kha Nqova Mbomambaqapé qambøe-tønøyám. Yaq gendovesez, ndego Nqova Mbomambaqape, leg-av manqei-té genø-itú. ");
INSERT INTO kvg_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yaq nqova soqaqape, teme-khamasím ndǿgo. Ge꞉khamasimam, khøuwa ate gi꞉goam, fotí. Ta khøuwa foti mokho-te ndøgo, Yesu lou logemáv. Sègegoám. Yaq vaev-te, ndego ifi mbovín. ");
INSERT INTO kvg_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Yaq ndego nqova soqaqape, Yesu gembo-ein, “Qo Mbumbukiam-ge Yo toqogoat, yaq nginik nandi, manqat mba qombó-eín. Yaq segé-lou-éz.” ");
INSERT INTO kvg_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Geté yaq Yesu gembo-qavøiu, “Mbumbukiam-qa Manqat āv qane-peawáp nqǽgo, ‘Ezoqa kopømba mbaín, lou mba te꞉yagat.’” ");
INSERT INTO kvg_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Yaq ndego nqova soqaqape, Yesu olol ová genø-itú. Yaq ndego até gendegó, manqei-manqei ate ndægo vø̄e-omat, nqanek manqei-qape-te nqago, ");
INSERT INTO kvg_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","gembo-ein, “Nqanek bawabawan ate nqægo, qoqá zenda-té qatǿvé. Yaq qō qotó-kawaeqtát, iz kandambaqape vøqágoāt. Nqanek gigiap ate nqægo, noqá. Yaq gekha ezoqām ndego, no tønø-pøovat, tæmbo-etoam, no kopømbaqapé, sæmbó-etoám. ");
INSERT INTO kvg_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Yaq nakémbá, katuk qotøndó-møkuí no-te, neka voqonǿ-vizām, yaq nqanek gigiap ate nqægo, qoqa ndǿgoát.” ");
INSERT INTO kvg_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Geté yaq Yesu gembo-qavøiu, “Āv taoká. Mbumbukiam-qa Manqat āv qane-peawáp nqǽgo: Evezøza-qá iz qó-eqatát, ndego qoge Mbumbukiam. Neka te-mba ndégo, toqombó-vizupát.” ");
INSERT INTO kvg_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Yaq nqova soqaqape, Yesu Zelusalem taon-té genø-itú, Mbumbukiam-qa khoev uni ova-in ndo꞉go vømø̄ve, sasa mbo-ein, “Qo Mbumbukiam-ge Yo toqogoat, soqóvuáq nqánek, atema manqei-te. ");
INSERT INTO kvg_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Zapa ndǿgo, Mbumbukiam-qa Manqat āv qane-peawáp nqǽgo, ‘Mbumbukiam tegi enzol ezoqam ndø̀zø-eín. Ndigu ndø̀qa-tøkeém. ");
INSERT INTO kvg_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Yaq ndigu sogó-ndøpøqém. Yaq qoqa zenda tokhotapak, nandi-te kha geqá-khanøyák.’” ");
INSERT INTO kvg_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Geté Yesu gembo-qavøiu, “Mbumbukiam-qa Manqat nøme, āv qane-eín nqǽgo, ‘Qo Evezøza, qoge Mbumbukiam, khamasim-te ndø-àwa᷄m.’” ");
INSERT INTO kvg_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nqova soqaqape, teqa khamasim matev ate qægoam qamømbøe-navøem, yaq ndego Yesu sège-iváv, vø̄wav. Yaq khøuwa nøme eqeieqei temøzømet, nqawa ndǿgo temékhamás. ");
INSERT INTO kvg_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yaq Yesu Gelili plovins-té genøveséz. Nqova Mbomambaqape-qa bazaføgakh, mø̀ndu꞉goám te-te. Yaq teqa manqat sùgumu-panqavøemát, ta manqei-te ndøgo, ate qægoam. ");
INSERT INTO kvg_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ndego, ezoqam, Zu ezoqam-qá guliguli khoev-té gene-zømesimám. Ezoqa ewaqape, teqa manqat gi-ewagam, ndigu gèmbo-vizupám. ");
INSERT INTO kvg_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu Nazalet vemiav-te gemat, ma ge꞉khouwev ndøgo, yaq Sabat khøuwa qandap, ndego guliguli khoev-té genø-ón, av ekeza matev qambøegoam. Yaq sège-itán. Mbumbukiam-qá Manqat geveam-qa ndøgoám. ");
INSERT INTO kvg_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Yaq Aezaya-qá mbuk mbo-etøomém, vø̄-mboqoa, manqat nøme vø̄qeiv. Yaq āv gene-geveám nqǽgo, ");
INSERT INTO kvg_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Evezøza-gé Nqova mo꞉gó, no-te. Ndego oil nømboqóuz, vø̄veatan. Tene-veatán ndǿgo, ezoqa ndigu khakha-mba ndiyage, Manqat Mbomambaqape nøté-zømesimát. Neka ndego no nqánek gende-khofotán. No ndimbula ezoqam nøtézømás, av nqægo, ndigu kopømbaqapé, segéfakház, neka bøi waev mbain ezoqam vøtézømās, av nqægo, ndigu bøi nango segé꞉kewág. Ezoqam ndigu, ezoqam-qa mokho-te ndu꞉gu, ndigu ndingenezoat neka matev soqøsoqa ndizø-matanam, ndigu ndø̀khandí꞉z. ");
INSERT INTO kvg_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","No ndigu āv qazømbé-akhá nqǽgo, ‘Khøuwa mø̀ndøndáp. Evezøza tegi ezoqam-te, matev mbomambaqape ndǿmatanám.’” ");
INSERT INTO kvg_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu nqanek manqat gumu-geveam, mbuk sasa ndøtok, mbuk keoge ezoqam nqawa vømbō-etoam, vø̄qom, yaq ezoqa ewaqape, Zu ezoqam-qa guliguli khoev-te gu꞉qonavam, bøi te-te mbá. ");
INSERT INTO kvg_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yaq Yesu nømendim manqat ndøngáz, gezø-ein, “Mbumbukiam-qa Manqat nqanek, zo qazoyogem, qægeveam, gè-unimanqatín, nqægo khaiya.” ");
INSERT INTO kvg_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Yaq ezoqa ewaqape, teqa manqat giyogem, sègembøe-gøomém neka nqova zøndáf, teqa manqat mbomambaqape-qa yaq-te. Yaq ndigu gò꞉bevøpém, teqa yaq-te, gi-einim, “Gê, ngenek Zosef-gê yò?” ");
INSERT INTO kvg_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yaq Yesu gezø-ein, “No mø̀tenøtén. Manqat ndøgo, ezoqa ndimanqate, no zonǿ-einím. Āv qazonømbé-einím nqǽgo, ‘Mulømula etoam ezoqam, qakeza kha vø̀khæ-khakheinám. Matev kandakanda ndøgo, ni qeiyogem, Kapenaum taon-te qoqo-matønumam, até nqanék-a, qakeza vemiav-te, vø̀matanám.’” ");
INSERT INTO kvg_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yaq Yesu nøme gezø-ein, “No unimanqatín nqazø-manqate. Mbumbukiam-ge manqa vevezam ezoqam, ekeza vemiav-te, ezoqa teqa manqat géyogemák. ");
INSERT INTO kvg_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","No nqazǿ-manqate: Ilaiza geyagam, ndego Mbumbukiam-ge manqa vevezam ezoqam, yaq viav misika neka løvøyak siks vikia seke qamat, ta khøuwa-te ndøgo, ngængæm kopoáv gigoam, Izlael manqei-te. ");
INSERT INTO kvg_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Geté Mbumbukiam Ilaiza ambá av nqǣgo, Izlael ngængæm-tē genø-khofotāv, vømøzǿ-tøkē. Geté ngæmam kopo-te mbá genø-khofotáv, Zalefat taon-te guyagam, Saedon manqei-te, vømømbō-tøke. ");
INSERT INTO kvg_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Neka ta khøuwa-te ndøgo, Ilaiza Mbumbukiam-ge manqa vevezam ezoqam gegoam, kha sisi-us ezoqa kopoáv giyagam, Izlael manqei-te. Geté ezoqa kopo khakhævateáv. Sa ndégo tekhakhǽv, Naeman, ndego Silia manqei-ak.” ");
INSERT INTO kvg_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ezoqa ndigu, Zu ezoqam-qa guliguli khoev-te giqonavam, nqanek Yesu-qa manqat giyogem, ndigu mbøni zønqosøgím. ");
INSERT INTO kvg_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Yaq até gindigonem, vemiav bavokhó ginø-ngeatømém. Yaq manqei khavoe-té ginø-ituím. Tiqa vemiav, manqei poyat-té qagoám. Yaq ndigu ambá timø-oginamɨ́n ndǿgo. ");
INSERT INTO kvg_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Geté Yesu ezoqa ewaqape, sège-keqazotát. Livin-mbá sugumát, vømø̄fakhan. ");
INSERT INTO kvg_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yaq Yesu Kapenaum taon-té genøwáv, Gelili plovins ndøgo, neka Sabat khøuwa-te, ezoqa vømē-zømesim. ");
INSERT INTO kvg_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yaq ezoqam ndigu, teqa manqat giyogem, mbøni zølév. Zapa ndǿgo, ndego Mbumbukiam-qá iz-té neka bazaføgakh-té gene-zømesimát. ");
INSERT INTO kvg_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ta guliguli khoev-te ndøgo, ezoqa kopo mø̀ndu꞉goám. Ndego nqova soqa mbøigoám. Yaq ndego kandambaqapé sege-akhá, ");
INSERT INTO kvg_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Â? Yésu, Názalet-ak! Gê, qo ni gekha qonígū? Ni ngiænoat-qā qotøndóqav? No mø̀tenøtén, qo gekha ezoqām. Qo Mbumbukiam-gé Ezoqa Ndaføyamba-qapé.” ");
INSERT INTO kvg_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yaq Yesu ndego nqova soqa, gèmbøe-khafén, gembo-ein, “Qo manqat tía! Mòqotøndo-fakháq, qo nanda ezoqam-qa mokho-te ndoqotu꞉gu.” Yaq ndego nqova soqa, até gendego, ndego ezoqam, manqei-té genø-ogiú, sasa ndøfakhan. Yaq ge꞉fakhan, ndego teqa kha ngi꞉wateáv. ");
INSERT INTO kvg_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Yaq ezoqa ewaqape nqova ndafe kandambá. Āv gini-einím nqǽgo, “Ngenek ezoqam. Teqa manqat viní. Andé iz akhae ezoqam-qá manqa manqaté. Taqa bazaføgakh kandambá. Ndego nqova soqøsoqa, manqat mba zømanqaté. Yaq ndigu sègendo-fakhazɨ́n.” ");
INSERT INTO kvg_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yesu nqanek matev gego, yaq teqa emanqat sùgumu-panqavøemát, vemivemiav ate qægoam, ta manqei-te ndøgo. ");
INSERT INTO kvg_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu Zu ezoqam-qa guliguli khoev gendo-ivav, yaq Saemon-qá khoev-té genøwáv. Khoev-te ndøgo, Saemon-gu zimpuka, ngusu tatas enqoni mbogoám. Tatas kandambá. Yaq Yesu tøke-qa mboviømém, tuqa yaq-te. ");
INSERT INTO kvg_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yaq ndego tuqá avønin-té genø-itán, sasa mo꞉foe, enqoni ndøgo, ivøve manqat vømbō-ein. Yaq enqoni sègembo-navøém. Yaq ndugu até gundigu, gè-itán, ndigu lou vøzø̄ta. ");
INSERT INTO kvg_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Yaq khøuwa gesinanat, ezoqa ewaqape, ekeza ezoqam, ndigu enqoni vinivinimba qazøgoam, Yesu-té gindu-itúb. Yaq zenda zømbø-awám, vø̄khakheinøvem. ");
INSERT INTO kvg_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ezoqa nøme kopoáv, nqova soqøsoqa zøfakhatát. Akhayam-ús. Āv gini-akhaemám nqǽgo, “Qo Mbumbukiam-gé Yó!” Geté Yesu gèzømbe-khafén neka takeáv, manqat nøme ti-einim. Zapa ndǿgo, ndigu nqova soqøsoqa mø̀ndæzøtéz, Yesu, ndego Mesayā. ");
INSERT INTO kvg_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Khøuwa nøme, qænqøovat, Yesu taon tène-iváv. Yaq ezoqam-av manqei-té genøwáv, vømø̄-yakhapus-mokho-mba-ev. Geté ezoqa gèmbovawát. Yaq gi-ometam ndøgo, ndigu keseiwat-qa mbogoám. Manqei nøme-te, ambá géwavák. ");
INSERT INTO kvg_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Geté Yesu gezø-ein, “No Manqat Mbomambaqape, Mbumbukiam-qa Megeat Matev-qa yaq-te, até vemivemiav nøme-té-a, bàme-zømesím. Mbumbukiam ta zapaya nqánek gende-khofotán.” ");
INSERT INTO kvg_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yaq Yesu até Zu ezoqam-qa guliguli khoev nøme-té-a, vemiav vinivinimba-te qapuatat, Zudia plovins-te ndøgo, Mbumbukiam-qa Manqat vømē-zømesim. ");
INSERT INTO kvg_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Khøuwa nøme, Yesu Genesalet kewan ndøgeg-té geyám. Ezoqa me꞉zømesimát. Ezoqa kopoáv gindupindam. Mbumbukiam-qá Manqat ndø-ewagát. ");
INSERT INTO kvg_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yaq pu-te ndøgo, Yesu khagua menas ndøqeív. Voe nqagim ezoqam ndø-asæmém. Ndigu voe ndøsunguzát. ");
INSERT INTO kvg_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yaq khagua nøme qa-asæam, Yesu tunuketáo ndǿgo. Ndøgo Saemon-qá khaguá. Yaq gembo-ein, “Elavøqase vø̀ndosøkúz.” Yaq Yesu khagua-té gunu꞉qóm, ezoqa ewaqape Mbumbukiam-qa Manqat sasa me꞉zømesim. ");
INSERT INTO kvg_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yesu manqa manqate qamømbøe-navøem, yaq ndego Saemon āv gembøe-eín nqǽgo, “Ananá qazonǿ-tiním, voe vømø̄-nqagem.” ");
INSERT INTO kvg_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Yaq Saemon gembo-qavøiu, “Kándambaqape. Lova seke qapøistat, ni sasae kandá qeigoat. Voe amba niti-nqagimát. Zongøyam kopo ndafeáv. Geté ság, av qo qoqote-ein ndægo, voe ndæ̀nqág.” ");
INSERT INTO kvg_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Yaq av gi꞉gonem ndægo, zonga kopoav-qapé gizømbe-ndap. Voe ambá vø̄keqavøemɨn. ");
INSERT INTO kvg_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Khagua nøme-te, voe nqagim ezoqa nøme mø̀ndøbøetám. Yaq ndigu tøke-qa zø-akhá. Yaq gindutinim, zonga khagua menas-té ginø-geabám, até vømøzø̄-tøtøvøbam. Khagua ambá vøzø̄-geovøemɨn. ");
INSERT INTO kvg_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Yaq Saemon Pita, nqanek matev geqeiv, ndego katuk ndømøkuí, Yesu-qa megemege-te, vømbō-ein, “Evézøza. Noqa avønin-te ndø̀ya᷄. Zapa ndǿgo, no manqa-zapa-us ezoqám.” ");
INSERT INTO kvg_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ndego nqanek manqat ge-ein, zapa ndǿgo: Ndego neka ezoqa nøme, te namba gi꞉goam, ndigu nqova ndafe kandambá, zonga kopoav-qape gizømbe-ndap. ");
INSERT INTO kvg_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Até Zems neka Zión-a, ndigu Zebedi-gi nakheis, Saemon namba gi꞉sasaetam, nqova vøzø̄ndaf. Yaq Yesu Saemon āv gembøe-eín nqǽgo, “Qo møe ndø̀go᷄. Qo ndakin ambá av nqǣgo, zonga qótakhasāt, geté ezoqa qótakhasát.” ");
INSERT INTO kvg_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Yaq ndigu até gindigonem, khagua neka gigiap ate qægoam, sège-iváv, Yesu sasa mbopaevem. ");
INSERT INTO kvg_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu vemiav nøme-te gegoam, yaq ezoqa mø̀ndøgoám. Teqa kha ate qægoam, kha sisi-ús. Yaq Yesu ge-omet, ndego teqa megemege-te, ekeza kha, manqei me꞉laváo, bugug até manqei-té, vømbōviam, “Evézøza. Ambá qokhakheinømbemín. Poev taqagoat, qo kopømbaqapé, toqo-khakheinømbem.” ");
INSERT INTO kvg_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yaq Yesu zenda mbøevé, vømbō-ein, “Nqanø̂poév. Qo vø̀-eqeieqei-éq.” Yaq nqova mbaín, ndego ezoqam, kha sisi sègembo-navøém. ");
INSERT INTO kvg_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yaq Yesu manqa āv gembøe-løvuá nqǽgo, “Ezoqa nøme zø̀-ei᷄n. Geté Mbumbukiam-gé iziz ezoqam-té qonǿqáv, bemø̄qamekh, neka Mbumbukiam-te etoam matev vømø̄go, av Mozes gezømbe-ein ndægo. Yaq ezoqa tìabiti-zøtéz, av nqægo, qo mòqo-eqeieqei-éq.” ");
INSERT INTO kvg_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yesu ndego ezoqam mø̀ndøgugú, geté teqa emanqat sège-panqavøemát. Yaq ezoqa kopoáv gindu-okhoam te-te. Ndigu teqa manqat yoge-qa ndøgoám, neka khakhæzat-qa vø̄goam, ndigu enqoni qazøgoam. ");
INSERT INTO kvg_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Geté Yesu ezoqam-av manqei-té genøwavɨ́n, vømø̄-guligulimin. ");
INSERT INTO kvg_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Khøuwa nøme, Yesu ezoqa Mbumbukiam-qa Manqat ge꞉zømesimat, Felisi ezoqam neka Mozes-qa guguna manqat nømendim ezoqam, mø̀ndø-qonavám. Nøme Gelili plovins-té ginduzáv, vemivemiav ate qægoam, neka nøme até Zudia plovins-té-a neka Zelusalem taon-te vøndō-okhoam. Yaq Evezøza Mbumbukiam-qa bazaføgakh, enqoni-us ezoqam khakheinøvem nonqo, mø̀ndøgoám, Yesu-te. ");
INSERT INTO kvg_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Yesu ezoqa ge꞉zømesimat, yaq ezoqa nøme tinduzáv ndǿgo. Kagi ezoqam ndø-eqeitavún. Ambá khoev mokho-té ginø-ndafemɨ́n, Yesu-qa megemege-te vō꞉veemɨn. ");
INSERT INTO kvg_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Geté ndigu nakhoa qeiviáv, vǿe-ōz. Zapa ndǿgo, ezoqa khàpumu-khouwéz. Yaq até gindigonem, khoev ová ginøqavíg, yaq ova ndo꞉go, ma Yesu ge꞉qotam, nqa vømø̄-løozem. Yaq ndego ezoqam sège-føløtøvém, kita-ús, ezoqa ewaqape-qa livin-te, Yesu-qa megemege-te. ");
INSERT INTO kvg_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu tiqa unimanqatin geqeiv, yaq ndego ezoqam āv gembøe-eín nqǽgo, “Nǿfu! Qoqa manqa-zapazapa, mø̀ndøqa-navøém.” ");
INSERT INTO kvg_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yaq Mozes-qa guguna manqat nømendim ezoqam neka Felisi ezoqam, nqanek manqat giyogem, ndigu āv ginibónd nqǽgo, “Gekha ezoqâm ngenek, Mbumbukiam-qa iz ngengenøitit? Ezoqam-qa manqa-zapazapa, Mbumbukiam yakhapús, ndezø-evøzam.” ");
INSERT INTO kvg_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu é-møndæ-otév, av ndigu gi꞉matavupat. Yaq gezø-ein, “Zo gekha zapâ, zoqa mbøni-te av ndøzøte-matavupit? ");
INSERT INTO kvg_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Gê, gekha manqât ndøgo, føgakh mbain? Ndǿgò, no ngenek ezoqam tæmbo-ein, ‘Qoqa manqa-zapazapa mø̀ndøqa-navøēm,’ o ndǿgò, tæmbo-ein, ‘Mòqo-itán, neka okho vø̄ngaz’? ");
INSERT INTO kvg_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Geté no ndakin nøtézømás, Ezoqam-ge Yo, bazaføgakh nqambôgó, ezoqa manqa-zapazapa tezø-evøzam, nqanek manqei-qape-te.” Yaq Yesu ngenek kagi ezoqam, āv gembøe-eín nqǽgo, “No nqataqá-manqate. Mòqo-itán, kita vø̄khazo, khoev-te sasa ndøqav.” ");
INSERT INTO kvg_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yaq nqova mbaín. Ndego ezoqa ewaqape-qa bøi-te, sège-itán, kita vø̄khazo, khoev-te sasa ndøwav. Mbumbukiam-qa iz até go꞉-eqatát, gemat. ");
INSERT INTO kvg_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Yaq ezoqa ewaqape, nqova ndafe kandambá. Mbumbukiam-qá iz ndø-eqaném. Yaq āv gini-manqatát nqǽgo, “Ni nqægo khaiya, matev viní qaziqeivim.” ");
INSERT INTO kvg_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Taqa zita-te, Yesu vemiav ge꞉-ivavtat, ndego teks moni upøgim ezoqam ndø-omét. Teks upøgim khoev-qase mokho-té gunu꞉qotám. Teqa iz Livái. Yaq Yesu āv gembøe-eín nqǽgo, “No qonøndó-páev.” ");
INSERT INTO kvg_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Yaq Livai até gendego, vømbōpaev. Gigiap ate qægoam, sège-iváv. ");
INSERT INTO kvg_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Yaq Livai lou kandambaqape ndølóg, ekeza khoev-te. Yesu mbokhanakhanákh. Teks moni upøgim ezoqam neka ezoqa nøme kopoáv, teqa lou loge-te gindupindam. ");
INSERT INTO kvg_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Yaq Felisi ezoqam neka Mozes-qa guguna manqat nømendim ezoqam, ndigu Felisi ezoqam-te ginøzaz, qaqa ndøgoném, Yesu-gi paev ezoqam-te, gizø-ein, “Gekha zapâ, zo teks moni upøgim ezoqam neka manqa-zapazapa-us ezoqam namba, ibøkha nqazøte-izit neka lou namba nqazøte-loget?” ");
INSERT INTO kvg_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yaq Yesu gezø-qavøiu, “Ezoqam ndigu enqoni mbain ndigu, ndigu mulømula etoam ezoqam mbain tøgoat, kopømbá. Geté enqoni-us ezoqam bezøgó, mulømula etoam ezoqam. ");
INSERT INTO kvg_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","No ambá av nqǣgo, ezoqa eqeieqei akhayam-qa nøgeavūn, tiqambuz. Geté no manqa-zapazapa-us ezoqam akhayam-qa nøgeavún, vøndó-qambūz.” ");
INSERT INTO kvg_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ezoqa nøme, Yesu āv gimbøe-einím nqǽgo, “Zion-gi paev ezoqam, lou logemav matev ndøgoatún, vø̄guligulimatun. Até Felisi ezoqam-gi paev ezoqám-a, vø̄goatun. Geté qogi paev ezoqam, matev av nqægo gonemáv. Ndigu lou sège-logatún, neka ibøkha vø̄-izumatun.” ");
INSERT INTO kvg_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yaq Yesu yaya zø-etá, taqa yaq-te, gezø-ein, “Ge zô ndozo-matavap, ezoqa sæva te-okɨ, yaq zifuap lou loge-te tekhatob, ndigu zifuap kopømbâ, lou logemav matev ndø̄gonem, ndego ti namba ti꞉goat? Āv taoká. Ndigu lou logemav matev gégonemák. ");
INSERT INTO kvg_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Geté khøuwa ndø̀fakház. Yaq ndego ezoqam, sævam ge-okɨ, ndø̀ndafém, ti namba nde꞉go. Yaq tegi zifuap lou logemav matev, ta khøuwa-te ndǿgo tinígoát.” ");
INSERT INTO kvg_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yaq Yesu yaya nøme zø-etá, gezø-ein, “Ezoqa kopømba mbaín, ndabua ndakinak tekeqa, yaq ta mbewat ndøgo, nqawønege ndabua-tē gemǿtøkē. Zapa ndǿgo, av toqotego nqægo, yaq ndabua ndakinak segemǿ-soqá, neka ndabua mbewat ndakinak gemǿ-kopømbayák, nqawønege ndabua namba. ");
INSERT INTO kvg_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Neka ezoqa kopømba mbaín, waen ndakinak, awenege søvakha ngusum-te te-ewa. Zapa ndǿgo, awenege søvakha ngusum-te toqo-ewa, yaq waen tøpopon, ndigu gékeqáz. Yaq waen vǿqouvøēm, neka søvakha ngusum vǿsoqoēz. ");
INSERT INTO kvg_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Geté waen ndakinak, søvakha ngusum ndakinak-té qotúqóuz. ");
INSERT INTO kvg_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Geté unimanqatín, gekha ezoqām ndigu, waen awenege gi-izumatun, ndigu waen ndakinak gèzømbo-qasiín. Ndigu āv gini-einimín nqǽgo, ‘Qanimav ndǿgo, awenege.’” ");
INSERT INTO kvg_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabat khøuwa nøme, Yesu ekeza paev ezoqa namba, khae mokho-té gunu꞉-apát. Yaq tegi paev ezoqam, wit nanga ndøvingisømém, sasa ndøtitisam, tag vø̄khofovøem, mokho sasa ndølouz. ");
INSERT INTO kvg_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Yaq Felisi ezoqa nøme, tiqa matev giqeivim, ndigu āv gizømbe-eín nqǽgo, “Gekha zapâ, zo wit nanga ndozo-vingisumit? Khafeáp nanda, Sabat khøuwa-te sasae av nqægo toqogot.” ");
INSERT INTO kvg_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yaq Yesu gezø-qavøiu, “Ge zô, emanqat mozó-geveømem, av Deivid ge꞉matanam, tegi ezoqam namba, ifi qazøvin? ");
INSERT INTO kvg_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Mbumbukiam-qá khoev-té genø-ón, flawa vømøndō-upøzo, ndigu lou-qase-te go꞉-abam, Mbumbukiam-gi, yaq sasa ndølouz, neka ndigu ezoqam, te namba gi꞉goam, vøzø̄-etoam. Matev av nqægo khafeáp. Mbumbukiam-gí iziz ezoqam mba zø-mboqoatám, nginik flawa tilouzat.” ");
INSERT INTO kvg_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yaq Yesu gezø-ein, “Ezoqam-ge Yo, ndego kawá. Sabat khøuwa, ndégo teno-kawaevát.” ");
INSERT INTO kvg_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabat khøuwa nøme, Yesu Zu ezoqam-qa guliguli khoev-te gemat, ezoqa ge꞉zømesimat, ezoqam mø̀ndøgoám. Teqa nakeamo pingim, gèmbowaú. ");
INSERT INTO kvg_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Yaq Felisi ezoqam neka Mozes-qa guguna manqat nømendim ezoqam, Yesu bøi mba mbøeveém, ndego ezoqa peté-khakheinøvēm penømakhaya, Sabat khøuwa-te. Zapa ndǿgo, ndigu Yesu manqa ovøyam-te vee-qa mbogoám. ");
INSERT INTO kvg_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesu é-møndæ-otév, ndigu ande gekha me mbómatavupam. Yaq ndego ezoqam, pingim qambowau, āv gembøe-eín nqǽgo, “Qoté-itān. Yaq ezoqa ewaqape-qá megemege-té qoqonǿ-itán.” Yaq ndego ge-ìtān, sasa ndøwav, ezoqa ewaqape-qa megemege-te vømø̄-itan. ");
INSERT INTO kvg_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yaq Yesu ndigu Felisi ezoqam neka Mozes-qa guguna manqat nømendim ezoqam gezøbevap, “Ge zô, ndozo-matavap. Gekha matêv ndøgo, Sabat khøuwa-te toqogo, kopømba? Ndǿgò, matev eqeieqei toqogo, o ndǿgò, manqa-zapa toqogo? Ndǿgò, ezoqa toqo-khandi꞉v, o ndǿgò, teqa yage toqongiu?” ");
INSERT INTO kvg_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yaq Yesu sège-qambuním, ezoqa ewaqape vø̄zømet, yaq pingim wau ezoqam gembo-ein, “Pingim qoté-ovøyām.” Yaq ndego ezoqam, pingim gè-ovøyám. Sègembo-eqeieqeí. ");
INSERT INTO kvg_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yesu matev av ge꞉matanam, yaq Zu megetapak, qaqa kandambá gigonem, neka yakhapus mokho-mba gibond, “Ni ngenek gekhā zimbógonēm?” ");
INSERT INTO kvg_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ta khøuwa-te ndøgo, khøuwa nøme, Yesu manqei poyat-té genøqavíg, vømø̄-guligulim. Yaq lova seke qamat, Mbumbukiam-té genø-akhaemát. ");
INSERT INTO kvg_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Yaq qanaqanus qandopave, ndego ekeza paev ezoqam ndømøváb, ezoqa tuelv vø̄vevesam. Ndigu ezoqa tuelv, u-anim zø-akhá. ");
INSERT INTO kvg_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ezoqam gevevesam ngínik: Saemón. Iz nøme gembo-akha, Pitá. Neka tege eveqase Endlú. Neka nøme Zéms, neka Zión, neka Filíp, neka Batolomeú, ");
INSERT INTO kvg_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","neka Metiú, neka Tomás, neka Zems nømē. Ngenek Zems, Alfius-gé yó. Neka Saemōn nømē. Ngenek Saemon, Zelot ezoqam ndøgoám. ");
INSERT INTO kvg_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Nøme Zudás. Ngenek Zems-gé yó. Neka nøme Zudas Iskaliót. Ezoqam ndégo, vaev-te Yesu tegi qaqa ezoqam-qa zenda-te geve. ");
INSERT INTO kvg_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu tegi u-anim namba, manqei poyat-te ginduvis, yaq manqei gev-te gimøwan, tegi paev ezoqa nøme kandambá gindupindam. Neka ezoqa nøme kopoáv, Zudia plovins-té ginduzáv, vemivemiav ate qægoam, neka Zelusalem taon-te vøndōzav. Até ndøgó-a, Taya neka Saedon taon avønin, ndaola-te ndøgo, vøndōzav. ");
INSERT INTO kvg_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ndigu tindi-okhoám ndǿgo, Yesu-qa manqat ndǿyogém neka vǿkhakhǣz, ndigu enqoni qazøgoam. Yaq ezoqam ndigu nqova soqøsoqa gizømbu-goam, Yesu vø̄khakheinøvem. ");
INSERT INTO kvg_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ezoqa ewaqape, Yesu kha khanøzam-qa mbogoám. Zapa ndǿgo, bazaføgakh ndofakhatám te-te, ezoqa ewaqape vø̄khakhæz. ");
INSERT INTO kvg_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yaq Yesu ekeza paev ezoqam ndøwabám, gezø-ein, “Zo khanakhanakh mbá qanegó, zo gigiap-av ezoqam. Zapa ndǿgo, Mbumbukiam-qa Megeat Matev, zoqá. ");
INSERT INTO kvg_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Zo khanakhanakh mbá qanegó, zo ndakin ifi ndøzøvinam. Zapa ndǿgo, zo ndø̀zø-ewéz. Zo khanakhanakh mbá qanegó, zo ndakin ndozo-eivam. Zapa ndǿgo, zo khanakhanakh møzǿ-asøtáv. ");
INSERT INTO kvg_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Unimanqatín, zo khanakhanakh mbá qanegó, zo Ezoqam-ge Yo zapaya ndisanqaza neka ndøzømbo-qasi꞉v neka zoqa manqat ndiponqom neka zoqa iz ndingenøiwat. ");
INSERT INTO kvg_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Matev av nqægo tøfakhan, yaq sègekhóum, neka gè-ogiám. Zapa ndǿgo, Mbumbukiam yaq-fia mø̀ndøzømbø-nøzá, yan-te nqo꞉go. Matev ndøgo, zo-te ndimatanam, até kopó, av tigi atanakha-zapazapa-za, Mbumbukiam-gi manqa vevezam ezoqam-te gi꞉matønumam. ");
INSERT INTO kvg_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Geté zo, mòzo-soqoéz, gigiap kopoav ezoqam. Zapa ndǿgo, zo yage eqeieqei mòzotumu-ndapém. Nøme mbaín. ");
INSERT INTO kvg_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Neka zo, mòzo-soqoéz, zo ndakin lou ndøzø-ewezat. Zapa ndǿgo, zo ifi møzǿvinám. Neka zo, mòzo-soqoéz, zo ndakin khanakhanakh mba ndøzø-asøtøve. Zapa ndǿgo, zo mbøni vaev-té qazó-waniapát neka zó-eivumát. ");
INSERT INTO kvg_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Neka zo, mòzo-soqoéz, ezoqa ewaqape zoqa iz ndi-eqawat. Matev ndøgo, zo-te ndimatanam, ndøgo até kopó, av tigi atanakha-zapazapa-za, khokho Mbumbukiam-gi manqa vevezam ezoqam-te gi꞉matønumam.” ");
INSERT INTO kvg_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yaq Yesu manqat nøme gezø-ein, “Geté zo ezoqam, zo noqa manqat nqazoyoge, no nqazǿ-manqate: Zo kuku bezøgó, zogi qaqa ezoqam-te. Neka matev eqeieqei zømatanám, ti-te ndigu, zo ndisanqaza. ");
INSERT INTO kvg_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ezoqa tiqa manqa manqat-te, zo soqain-te ti-abumat, yaq zo āv qane-guligulím: Mbumbukiam matev eqeieqei bezø-matanám. Neka gèzø-guligulím, ndigu zo yage føgøføgakh ndizø-etoam. ");
INSERT INTO kvg_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ezoqa tømøi teqatøkub, yaq sège-qambúq, yaq betaqā-tøkub. Neka ezoqa qoqa ndabua tendap. Ság! Até ndabua nømé-a, bèndáp. ");
INSERT INTO kvg_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Gekha ezoqām ndego, gigiap-qa teqaviam, sègembo-etoám. Neka gekha ezoqām ndego, qoqa gigiap sa tendap, nqawa ndape-qa ndø̀go᷄. ");
INSERT INTO kvg_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Gekha matēv ndøgo, zo ndøzøpoev, ezoqa zo-te timatønumat, zo matev āv tozozømbé-matønumát. ");
INSERT INTO kvg_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Zo kuku ti-te mba tøzøgoat, ndigu zo-te kuku ndøzøgo, yaq ge zô ndozo-matavap, zoqa matev vinî? Eqeieqei-qapê? Āv taoká. Até manqa-zapa-us ezoqám-a, kuku ndøzø̂gó, ti-te ndigu, kuku ndøzøgo. ");
INSERT INTO kvg_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Neka ge zô ndozo-matavap, zo matev eqeieqei ti-mba ndigu tozozø-goat, ndigu matev eqeieqei ndimatanam zo-te, yaq zoqa matev vinî? Eqeieqei-qapê? Āv taoká. Até manqa-zapa-us ezoqám-a, matev āv tinigoatún. ");
INSERT INTO kvg_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Neka ge zô ndozo-matavap, zo gigiap ti-mba ndigu tozozø-etoumat, zo ndøzøte-zøtezat, ndigu nqawa ndø̀zø-qavøiū, yaq zoqa matev vinî? Eqeieqei-qapê? Āv taoká. Até manqa-zapa-us ezoqám-a, gigiap mø̀ndø-etoumatún, yaqyaq-a. Yaq ndigu gigiap ate ndægo, nqawa tonqogim-qa ndøgonemɨ́n. ");
INSERT INTO kvg_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Geté, zo kuku bezøgó, zogi qaqa ezoqam-te. Neka matev eqeieqei zømatanám. Gigiap yaq-mbá segezø-etoám. Neka nqawa qavøiwat-qa ndø̀go᷄. Zo av tøzøte-matønumat ndægo, zo yaq-fia kandambaqape ndòzomø-ndapém. Yaq Mbumbukiam, ndego Eqeiwat-Qape, zo ekeza nakheis mé꞉zǽb. Zapa ndǿgo, até ndegó-a, matev eqeieqei zømatønumatún, ndigu ike manqat manqatemav ndigu neka ndigu ezoqa soqøsoqa. ");
INSERT INTO kvg_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ezoqa nøme-te, tanakh bezøgó, av zoge Zøve yan-te ngo꞉go, tanakh ndømbøego.” ");
INSERT INTO kvg_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yaq Yesu manqat nøme gezø-ein, “Zo ezoqa nøme ndøvøozòa᷄t. Yaq Mbumbukiam até zó-a gévøozoák. Neka ndømanqàte᷄, av nqægo, ezoqa nøme ndigu ùnime꞉-soqøsoqoezām. Yaq Mbumbukiam até zoqá yaq-té-a, av nqægo gé-einák. Ezoqam-qa manqa-zapazapa, sà bezømbo-naváp. Yaq Mbumbukiam até zoqá manqa-zapazapá-ya, segembøé-navøém. ");
INSERT INTO kvg_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Gè-etoám, ezoqa nøme-te. Yaq Mbumbukiam zo ndø̀zø-etoám. Kandambá gezømbé-etoám. Kopømba ande av lou ndægo, ezoqa ava-te tenqeitavet, gétøvøgimít, vømǿtøvā, neka vømǿ-qoqovøēm. Av ezoqa tozozømbe-etoumat, zo Mbumbukiam āv tezømbé-etoám.” ");
INSERT INTO kvg_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yaq Yesu yaya zø-etá, gezø-ein, “Bøi waev mbain ezoqam, kopømba mbaín, bøi waev mbain ezoqa nøme te-itu. Av tægoat ndægo, yaq ndigu ezoqa menas, manqei ozu-te até sugumú-o꞉áz. ");
INSERT INTO kvg_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Paev ezoqam kopømba mbaín, tege nømendim ezoqam teløvuam. Geté gekha ezoqām ndego, nømendim matev ate ndægo tumundap, ndego āv tenégoát, av tege nømendim ezoqam nde꞉go. ");
INSERT INTO kvg_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Gekha zapâ, qafu-qa bøi-te, kupuk-qase ndoqoqeivi, getē tae-qape ndøgo, qakeza bøi-te nandaqa-genøe, qo qeivupāv? ");
INSERT INTO kvg_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Gekha zapâ, qafu av ndoqombøe-manqate, ‘Nǿfu, kupuk-qase bøi-te nandaqa-genøe, nøtaqālīv,’ getē qakeza bøi-te nandav, qo tae-qape qeiviâv, nandaqa-genøe? Qo khavozam ezoqám. Bugukhokhof nándav, toqólív, tae-qape, qakeza bøi-te nandaqa-genøe, eqeieqei voqókewāg. Yaq váev qafu-qa bøi-te, kupuk-qase ndøugu, toqoliv.” ");
INSERT INTO kvg_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Tae eqeieqei, nanga soqøsoqa géviamák. Neka tae soqain, nanga eqeieqei géviamák. ");
INSERT INTO kvg_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tae nanga toqoqeiv, yaq soqoté-qatéq, tae ndøgo eqeieqeī o soqain. Bøning fakiafakia-us-te, kopømba mbaín, nanga mbomømboma, kopømba ande av fig ndi꞉gu, toqo-vingisam. Neka khouwe-khouwe-te ndøgo, kopømba mbaín, gleips toqo-løvus. ");
INSERT INTO kvg_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Yaq matev até kopó. Ezoqa eqeieqei, matev eqeieqei ndøgoatún. Zapa ndǿgo, teqa mokho-te, matavap eqeieqei mbøigú. Geté ezoqa soqaqape, matev soqøsoqa ndøgoatún. Zapa ndǿgo, teqa mokho-te, matavap soqøsoqa mbøigú. Unimanqatín. Gekha matavāp ndøgo, ezoqam-qa mokho-te qamømbo-tøva, ndego ndǿgo témanqatát.” ");
INSERT INTO kvg_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Gekha zapâ, no Evezøza ndozonø-akhayam, getē matev gonemāv, av no nqazømbe-manqate? ");
INSERT INTO kvg_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Gekha ezoqām ndego, no-te tendowav, noqa manqat vǿ-ewāg, neka o-mba vó꞉ndāp, no nøtézømás, ndego andē gekha ezoqām. ");
INSERT INTO kvg_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ndego ezoqam, kopømba ande av ndé꞉go, khoev manqei føgakh-te gewev. Uk ge-asøzam, até pakoa-té. Yaq khøuwat qandowav, khamøe qando-okhoam, ndøgo kopømba mbaín, tønqonaz. Zapa ndǿgo, khoev føgakh-qapé qawevam. ");
INSERT INTO kvg_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Geté gekha ezoqām ndego, noqa manqat sa te-ewagat, gete o-mba ndapeav vǿgoāt, ndego kopømba ande av ndé꞉go, khoev qoq-te gewev, uk sa go꞉føløzam. Yaq khøuwat qandowav neka khamøe qando-okhoam, sègemø-khawá. Khoev ùnime꞉-ngiú.” ");
INSERT INTO kvg_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu teqa nømendim manqat qamømbøe-navøem, ezoqam-te, yaq Kapenaum taon-té genøwáv. ");
INSERT INTO kvg_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ta vemiav-te ndøgo, Lom nakhag kawa ezoqam mø̀ndøgoám, neka ndego sasae ezoqam vømbōgoam. Te-te ndego khafuat kandambá. Ndego sasae ezoqam, enqoni mbogoám, ambá vø̄nanimin. ");
INSERT INTO kvg_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yaq ndego nakhag kawa ezoqam, Yesu-qa yaq-te manqat ge-ewag, ndego Zu megetapak ndøkhofotáz, te-te. Yesu āv gimbøé-einím nqǽgo: Bètøndowáv, tege sasae ezoqam vǿkhakheinøvēm. ");
INSERT INTO kvg_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Yaq ndigu Yesu-te gi-apat, gimøfakhaz, gèmømbo-viømém. Viam kandambá gigonem, vømbō-einim, “Qombótøké, ngenek nakhag kawa. Ndego ezoqa mbomambaqapé, ");
INSERT INTO kvg_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","neka ndego poev kandambá, ni Zu ezoqam-te. Niqa guliguli khoev giwevem, moni ndégo te-áb.” ");
INSERT INTO kvg_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yaq Yesu namba me꞉záv. Khoev gi꞉khatoat, ndego nakhag kawa ezoqam, zifuap ndokhofotáz, teqa manqat vømømbō-einim, av nqægo, “Khanánqa. Ság. Noqa khoev-te ndòqa᷄v. No ezoqa eqeieqeí mbá, noqa khoev-te toqotøndo-oq. ");
INSERT INTO kvg_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yaq nakémbá, no nøkezan okhoeáv qo-te. Geté manqat mba qó-eín. Yaq noge sasae ezoqam segé-khakhǽv. ");
INSERT INTO kvg_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Até nó-a, no ezoqam-qá mokho-té qatu꞉gú. Neka no mokho-te, nakhag ezoqam mu꞉gú. Ndigu ezoqa kopo tæmbo-ein, ‘Vø̀qāv’, yaq ndego segéwáv. Neka ezoqa nøme tæmbo-ein, ‘Mòqotøndoqāv’, yaq ndego segendówáv. Neka noge sasae ezoqam tæmbo-ein, ‘Mòqo-matanām, nqanek’, yaq ndego segé-matanám.” ");
INSERT INTO kvg_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu nqanek manqat ge-ewag, yaq nqova mbondáf. Yaq gèndoqambún, ndigu ezoqa bawan-qape gimbopavam, vøzø̄-ein, “No nqazǿ-manqate. No nqanek Izlael bawan mokho-te, unimanqatin matev qeiviáv, av ngenek bawan vini-ak nge꞉-unimanqatinat.” ");
INSERT INTO kvg_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Yaq ndigu u-anim, nakhag kawa-qa khoev-te giqavaz, ti-ometám ndǿgo, ndego sasae ezoqam, mø̀ndø-khakhǽv. ");
INSERT INTO kvg_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Khøuwa nøme, Yesu taon nøme-té genømát. Ta taon-qa iz, Naín. Ekeza paev ezoqam neka ezoqa nøme bawan-qapé namba me꞉-apát. ");
INSERT INTO kvg_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yaq nqáe! Taon uta mboqog ge꞉khatobat, ezoqa løvøte ezoqam ndø-eqeitavún. Taon-té gindu-fakház. Ndego ezoqa ndakinák. Tegu evo ngæmám. Zivis gèmbonaním, neka ndugu nakheis nøme mbaín. Taon-ak kopoáv, ngæmam namba gi꞉geavun. ");
INSERT INTO kvg_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yaq Evezøza ngunuk sævam gu-omet, ndego tanakh mbogó, gumbo-ein, “Qo ndø̀-ei᷄v.” ");
INSERT INTO kvg_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yaq Yesu tenøwáv ndǿgo, løvøte ezoqam-qa kumøkuma vømø̄khanaz. Yaq ezoqam ndigu, gi-eqeitam, sègewán. Yaq Yesu até gendego, ndego løvøte ezoqam, āv gembøe-eín nqǽgo, “Ndáe! No nqataqá-manqate. Mòqo-khandí꞉q.” ");
INSERT INTO kvg_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yaq ndego sègeqóm, manqa manqate vø̄ngaz, yaq Yesu ndego ezoqam, evo nqawa sasa mbo-etoam. ");
INSERT INTO kvg_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Yaq ezoqa ewaqape, nqanek matev giqeivim, ndigu møe ndøgoném, neka Mbumbukiam-qa iz vø̄-eqanem. Āv gini-einím nqǽgo, “Mbumbukiam-gé manqa vevezam ezoqam kandambaqape ndøfakhán, ni mokho-te. Mbumbukiam ni-te tøke-qa ndowáv, ni tegi ezoqam.” ");
INSERT INTO kvg_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yaq nqanek manqat, Yesu-qa yaq-te, Zudia plovins-te ndøgo neka manqei-manqei ate qægoam, avøavun qagoat, sùgumu-panqavøemát. ");
INSERT INTO kvg_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Zion, ndego ibøkha iz etoam ezoqam, tegi paev ezoqam, matev ate ndægo gi꞉-ometem ndøgo, Yesu gematønumat, yaq ndego ekeza paev ezoqa menas zø-akhá. ");
INSERT INTO kvg_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Yaq Yesu-té genø-khofotáz. Āv gimømbøé-bevøpém nqǽgo, “Gê, ezoqam qô, Mbumbukiam ge꞉manqatam, tendo-khofotav? Ó, ezoqa vini-qa nitó-kewagāt?” ");
INSERT INTO kvg_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Yaq Yesu-te gimøfakhaz, gimbo-einim, “Ni Zion, ndego ibøkha iz etoam ezoqam, ndokhofotán. Qo nitaqá-bevøpém: Gê, ezoqam qô, Mbumbukiam ge꞉manqatam, tendo-khofotav? Ó, ezoqa vini-qa nitó-kewagāt?” ");
INSERT INTO kvg_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ta khøuwa-te ndøgo, ndigu ezoqa menas gigeavun, Yesu ezoqa kopoáv gekhakheinøvem. Ndigu enqoni bugug vinivinimba zøgoám neka nøme ndigu, nqova soqøsoqa vøzømbū-goam. Neka bøi waev mbain ezoqa kopoáv, bøi waev vøzø̄-etoam. ");
INSERT INTO kvg_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yaq Yesu ndigu Zion-gi paev ezoqam gezø-qavøiu, “Zion-te nqawa tozovesez, yaq āv qazømømbøé-einím, av zo manqat nqazøte-yoge neka matev nqazøte-qeivi. Ezoqam ndigu, bøi waev mbain qagoam, ndakin gèkeogé. Neka ezoqam ndigu, kagi gigoam, ndakin gè-okhó. Neka ezoqa ndigu, kha sisi-us gigoam, kha sisi mø̀ndøzø-navøém. Neka ezoqa ndigu, gea kandøgeap gigoam, ndakin gèyogé. Neka ezoqa ndigu, gipakhaetat, nango mø̀ndø-khandí꞉z. Neka gigiap-av ezoqam, Mbumbukiam-qá Manqat Mbomambaqape ndøyogé. ");
INSERT INTO kvg_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Neka gekha ezoqām ndigu, no-te nakeapav ndigu, ndigu khanakhanakh mbá giabitigú.” ");
INSERT INTO kvg_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Zion-gi manqa upøgim ezoqam gi꞉qavaz, yaq Yesu Zion-qa yaq-te manqa manqate ndøngáz, ezoqa ewaqape-te, gezø-ein, “Gê, zo Zion-te qazo-apat, leg-av manqei-te ndøgo, zo gekha qeivi-qa zó-apat? Gê, zo ezoqa omete-qa zó-apat, ndego kopømba ande av gagayag ndægo, sa tøpovøemet, yaq vǿepovēt, yaq vǿepovēt, khamøe sa tøqambuvøemet? ");
INSERT INTO kvg_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","O gê, qazo-apat, zo ezoqa ndabua eqeieqei uzap omete-qa zó-apat? Nqáe! Ezoqa ndabua eqeieqei ndi-uzap neka gigiap kopoav si ndøzøwag, ndigu kawa ezoqam-qá khoev-té giyageáp. ");
INSERT INTO kvg_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Geté zonømbé-einīm. Zo gekha qeivi-qa zó-apat? Mbumbukiam-gê manqa vevezam ezoqam omete-qa zó-apat? Unimanqatín. Ndego Mbumbukiam-gé manqa vevezam ezoqám. Geté no nqazǿ-manqate. Ndego Mbumbukiam-gi manqa vevezam ezoqam ate ndi꞉gu, mø̀ndø-løvubám. ");
INSERT INTO kvg_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Zapa ndǿgo, ezoqam ngének, teqa yaq-te Mbumbukiam-qa Manqat av nqæpeawap nqægo, ‘Nqáe! Noge u-anem notó-khofotáv, qoqa megemege-te. Ndego nakhoa møqá-khakheinám.’ ");
INSERT INTO kvg_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","No nqazǿ-manqate. Zion, ndego ibøkha iz etoam ezoqam, ndego kandambaqapé. Ndego ezoqa ewaqape, nqanek manqei-qape-te gifakhatat, mø̀ndø-løvubám. Geté até ezoqa khasøkhasís-a, Mbumbukiam-qa Megeat Matev mokho-te, ndigu Zion mø̀ndø-løvu꞉mém.” ");
INSERT INTO kvg_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ezoqa ewaqape, nqanek manqat giyogem, mø̀ndø-unimanqatiním, av nqægo, Mbumbukiam-qa matev eqeieqeí. Até ndigú-a, teks moni upøgim ezoqam. Ibøkha iz sùgumu-upøgimát, Zion gezø-etoam. ");
INSERT INTO kvg_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Geté Felisi ezoqam neka Mozes-qa guguna manqat zøtezat ezoqam, ndigu Mbumbukiam-qa matavap gè-ogiím, tiqa yaq-te ge꞉pøoa, te-te tiqambuz. Neka ndigu gèzømbo-qasí, Zion ibøkha iz tezø-etoam. ");
INSERT INTO kvg_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yaq Yesu gezøbevap, “Gê, nginik ezoqam, ndakin ngiyage, andé gekha me nøtékhamās? Nginik ande gekhâm? ");
INSERT INTO kvg_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","No nakheis nøtékhamás, maket manqei-te ndi-otam. Ndigu yaqyaq-a, āv gini-akhayám nqǽgo, ‘Ni zo pøinda nizø-khambøemám. Khanakhanakh-ús. Geté zo ogipøteáv. Neka ni osombo ouv nizø-qaqaemám. Geté zo eivøpøteáv.’ ");
INSERT INTO kvg_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Zó-a, até kopó. Gekha matēv ndøgo, zo ndozoqeivi, zo khanakhanakh mbaín. Zion ndego ibøkha iz etoam ezoqam gefakhan, lou logemav matev gegoam, neka waen izumav vø̄goam, yaq zo āv qazøte-manqatám nqǽgo, ‘Ngenek nqova soqa mbøigú.’ ");
INSERT INTO kvg_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Geté ndakin Ezoqam-ge Yo gefakhan, ngenek lou mø̀ndø-logatún, neka waen vø̄-izumatun. Yaq zo āv qazøte-manqaté nqǽgo, ‘Ngenek ezoqam zøté-ometām! Lou loge møqǽ, neka waen izam møqǽ. Neka ngenek teks moni upøgim ezoqam neka manqa-zapazapa-us ezoqam-gí zifú.’ ");
INSERT INTO kvg_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Zo av nqægo ambá qazøte-manqaté. Geté ezoqam-qa matev toqoqeiv, ndøgo Mbumbukiam-qa matavap loloakh-te ndøndo-fakhate, yaq soqoté-qatéq, av nqægo, Mbumbukiam-qa matavap loloakh, unimanqatín.” ");
INSERT INTO kvg_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Khøuwa nøme, Felisi ezoqam, Yesu lou loge manqat mbo-eín, teqa khoev-te. Yaq Yesu tenøwáv ndǿgo, lou vømø̄log. ");
INSERT INTO kvg_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ta vemiav-te ndøgo, sævam mø̀ndøgoám. Ndugu manqa-zapa-ús. Yaq manqat gu-ewag av nqægo, Yesu Felisi ezoqam-qa khoev-te lou gelogat, ndugu tunduwáv ndǿgo, botol-qase vøndōndap. Tae et sisip qanimav-qape mu꞉nqeitavám. Taqa fia kandambá tantáv. ");
INSERT INTO kvg_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yesu-qá zita-té gunduwáv, teqa zenda tokhotapak avønin-te vø̄-itan. Ndugu gèvín. Yaq bøi einu ndigu, Yesu-qá zenda tokhotapak-té ginø-lanqanimám. Yaq ndugu até gundigu, susu ndøgo, Yesu-qa zenda tokhotapak-te qagoam, ekeza izúm guni-vuogím, neka zenda tokhotapak vømbō-ngenøtam, yaq tae et sisip mbomambaqape, teqa zenda tokhotapak-te sasa mbøeqouz. ");
INSERT INTO kvg_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Yaq ndego Felisi ezoqam, ma Yesu gendekhato, nqanek matev geqeiv, ndego ekeza mokho-mba, āv gene-matavupát nqǽgo, “Ngenek amba unimanqatin manqa vevezam ezoqam tegonɨn, yaq ndego bète-otevɨ́n, ngunuk sævam, kha ndumbo-khanøzam. Ndego bète-otevɨ́n, av nqægo, ndugu manqa-zapa-ús.” ");
INSERT INTO kvg_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu teqa matavap é-møndæ-otév, yaq gembo-ein, “Sáemon. No manqat nqanø̂gó, qo-te.” Yaq Saemon gembo-ein, “Nøméndim ezoqam, qonømbé-eīn.” ");
INSERT INTO kvg_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yaq Yesu yaya mbo-etá, gembo-qavøiu, “Ezoqa menas mø̀ndøgoám. Ndigu moni etoam ezoqam-te, moni zømbo-løfokám. Moni kandambá. Nøme moni mokho 500́ qambøe-løfokam, neka nøme moni mokho 50́. ");
INSERT INTO kvg_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Geté ndigu ezoqa menas, moni mbaín, ndego nango vømbøé-qavøinām. Yaq ndego ezoqam, te-te moni qazømbo-løfokam, āv gezømbe-eín nqǽgo, ‘Ság, moni nango nøqavø̀ina᷄m.’” Yaq Yesu Saemon gembobevap, “Ge qô ndoqo-matavap? Nginik ezoqa menas, ndego ezoqam-te moni qazømbo-løfokam, kuku kandambaqape gekha ezoqām mbógoāt, te-te?” ");
INSERT INTO kvg_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Yaq Saemon gendo-qavøiu, “No nqæmatavap: Ezoqam ndégo, ndego moni kandambaqape qambøe-løfokam, sa gembotak.” Yaq Yesu gembo-ein, “Nándav. Qo unimanqatín ndoqo-manqate.” ");
INSERT INTO kvg_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yaq Yesu sævam-té genøqambún, Saemon sasa mbo-ein, “Ngunuk sævam qoté-omēt. No qoqa khoev-te qatøndo-on, qo no ibøkha etopøteáv, noqa zenda tokhotapak sunguzu nonqo. Geté ngunuk noqa zenda tokhotapak, ekeza bøi einú gunisungúz. Yaq ekeza izúm guni-vuogím. ");
INSERT INTO kvg_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Qo no ngenøndøpøteáv, no qatøndo-on, av niqa matev ndægo. Geté ngunuk sævam, noqa zenda tokhotapak, oskia ndøngenøtumít, ande qatønde-on, atema ndakin. ");
INSERT INTO kvg_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Neka qo noqa kawa-te, oil qouziáv, qatøndo-on, av niqa matev ndægo. Geté ngunuk sævam, noqa zenda tokhotapak-te, tae et sisip mbomambaqape mo꞉qóuz. ");
INSERT INTO kvg_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","No nøtaqá-eín, gekha zapā ngunuk kuku khape qambe-khouwev no-te. Ngunuk kuku khape tømbøe-khouwév ndǿgo, tuqa manqa-zapazapa kopoav-qape, mø̀ndømbo-navøém. Geté gekha ezoqām ndego, manqa-zapazapa khapelavøqase mba sa qambøe-navøem, teqa kuku khapémbá.” ");
INSERT INTO kvg_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yaq Yesu ndugu sævam āv gumbøe-eín nqǽgo, “Qoqa manqa-zapazapa, mø̀ndøqa-navøém.” ");
INSERT INTO kvg_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Yaq ezoqa nøme, lou loge-te namba gi꞉qonavam, ekeza mokho-mba gibond, “Ngenek kenǿgoam, ezoqa manqa-zapazapa ndezø-evøzam?” ");
INSERT INTO kvg_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yaq Yesu ndugu sævam gumbo-ein, “Qoqa unimanqatin nandav, tø̀khandí꞉q. Mòqoqáv. Qo mbøni betaqàva᷄ev.” ");
INSERT INTO kvg_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Taqa zita-te, yaq Yesu taon neka vemivemiav ate qægoam sège-okhoám. Ezoqa Manqat Mbomambaqape, Mbumbukiam-qa Megeat Matev-qa yaq-te me꞉zømesimám. Ekeza paev ezoqam tuelv namba me꞉-okhoám, ");
INSERT INTO kvg_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","neka sakheis vø̄goam. Nginik sakheis, Yesu gèkhakhǽz. Nøme ndigu, enqoni vøzø̄goam-a, nøme ndigu, nqova soqøsoqa vøzømbū-goam. Sævam kopo nømu, Meli Magdala vemiav-ák. Yesu nqova soqøsoqa sevén, gumbo-ngeasam. ");
INSERT INTO kvg_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Neka sævam nømu, iz Zoaná. Ndugu Kuza-gú zás. Ngenek ezoqam, ndigu Elod-qa khoev-te gisasaetam, kawa zømbogoám. Neka sævam nømu, ndugu iz Susaná. Neka sakheis nøme kopoáv gigoam. Ndigu sakheis, ekeza gigiáp gizømbe-tøkeám, ndigu gi-okhoam. ");
INSERT INTO kvg_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Khøuwa nøme, ezoqa kopoáv gimøvab. Vemivemiav ate ndǽgo, Yesu-te gindu-okhoam. Yaq ndego yaya zø-etá, gezø-ein, ");
INSERT INTO kvg_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ezoqa mø̀ndøgoám. Khae-té genøwáv, wit nanga vømø̄-zøgeakh. Yaq wit nanga ge꞉panqabumat, nøme nakhoa-té ginø-o꞉atát. Yaq ezoqa tetøkhonøvemém ndǿgo, pipisi vø̄louz. ");
INSERT INTO kvg_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Geté nøme ndigu, nandi-té ginø-o꞉atát. Nandi-te ndøgo, manqei khapekhapémbá qatøke꞉pat. Yaq mbusa qafakhan, gèkusíz. Zapa ndǿgo, ibøkha mbaín. ");
INSERT INTO kvg_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wit nanga nøme, gapuk-té ginø-o꞉atát. Yaq gapuk ndøgo, wit namba qæ-eqa, ndigu gèvøtøgeám. ");
INSERT INTO kvg_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Geté wit nanga nøme ndigu, manqei eqeieqei-té ginø-o꞉atát. Yaq kopømbá gi-eqanat, nanga vø̄qataz. Wit nanga kopokopo-te, louzi nonqo andled-andléd gitøkebupat.” Yesu nqanek yaya etæ manqat qamømbøe-navøem, yaq āv gene-akhá nqǽgo, “Gekha ezoqām ndego, gea tømbogoat neka yoge kopømba vømbógoāt, yà beyogé!” ");
INSERT INTO kvg_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesu nqanek yaya ge-eta, yaq tegi paev ezoqam, manqa mokho-qa mbøebevøpém. ");
INSERT INTO kvg_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yaq gezø-qavøiu, “Mbumbukiam zo mba zøtáke, zo nogi paev ezoqam, mokho manqat tøzøte-zøtez, teqa Megeat Matev-qa yaq-te. Geté ndigu ezoqa nøme, no yaya mba nøzø-etǽ. No yaya tæzømbe-etǽ ndǿgo: Ndigu ndø̀qeivát. Geté mokho gembó-ndapemák. Neka ndigu ndø̀-ewagát. Geté manqa mokho gembó-ndapemák.” ");
INSERT INTO kvg_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yaq Yesu tegi paev ezoqam gezø-ein, “Yaya etæ-qa manqa mokho nqánek: Wit nanga ndigu, Mbumbukiam-qá Manqát. ");
INSERT INTO kvg_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nøme ndigu, nakhoa-te gi-o꞉atat, taqa manqa mokho nqánek: Ezoqa nøme, ndigu Mbumbukiam-qa Manqat giyogemɨn, yaq nqova soqaqape até gendewavɨn, Mbumbukiam-qa Manqat vø̄e-vibamɨn, tiqa mbøni mokho-te ndøugu. Ndego tenegoatún ndǿgo, soqaín ndǿgo, ndigu ti-unimanqatinim, yaq Mbumbukiam khandi vøzǿ-etoām. ");
INSERT INTO kvg_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Neka wit nanga ndigu, nandi-te gi-o꞉atat, taqa manqa mokho nqánek: Ezoqa nøme, Mbumbukiam-qa Manqat khanakhanakh-us ndø-ndapemɨ́n. Geté ta manqat ndøgo, uni mbuvøemáv, tiqa mokho-te. Yaq tiqa unimanqatin matev Mbumbukiam-te, khapekhapé outupáv. Khamasim matev qazø-fakhanɨn, ndigu nakhamas-té ginø-o꞉azɨ́n. ");
INSERT INTO kvg_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Neka wit nanga nøme ndigu, gapuk-te gi-o꞉atat, taqa manqa mokho nqánek: Ezoqa nøme, Mbumbukiam-qa Manqat ambá giniyogé. Geté tiyagat, ndigu tiqa yage-qa yaq-te fofogeap khàpe zømbe-khouwevɨ́n, neka gigiap kopoav neka manqei-qape-qa khanakhanakh matev-qa yaq-te, poev khape vøzømbē-khouwevɨn. Yaq tiqa unimanqatin gèvøtagɨ́n. Kopømba mbaín, mokho tøfakhan. ");
INSERT INTO kvg_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Neka wit nanga ndigu, manqei eqeieqei-te gi-o꞉atat, taqa manqa mokho nqánek: Ezoqa nøme, tiqa mbøni eqeieqeí neka unimanqatín. Ndigu Mbumbukiam-qa Manqat ùnime꞉-yogemɨ́n. Ndigu føgøføgakh até gembó-geageapát neka yovitáv. Yaq Mbumbukiam-qa Manqat, tiqa mokho-te ndøugu, mokho ndøfakhanɨ́n.” ");
INSERT INTO kvg_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yaq Yesu manqat nøme gezø-ein, “Lampa toqomag, yaq kopømba mbaín, baket mokho-te o lou-qase mokho-te toqo-khonao. Geté lampa asøzam nonqo-té qonǿwuá. Yaq gekha ezoqām ndigu, khoev-te ti-ozat, waev géqeivát. ");
INSERT INTO kvg_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Gekha matēv ndøgo, ndøkhonøwe, bavokhó qandó-fakhán. Neka gekha mokho manqāt ndøgo, ndøkhonøwe, gendó-veveám. Yaq ezoqa ewaqape, gé꞉zøtéz. ");
INSERT INTO kvg_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yaq nakémbá, aiyá qagó. Noqa manqat ùnime꞉-yogé, manqat nqæmanqate. Gekha ezoqām ndego, mokho gendap, Mbumbukiam otevat nøme mba mbøé-etoám. Geté gekha ezoqām ndego, mokho ndapeav ndøgo, yaq até otevat-qasé-a, ndego ezoqam ndematavap ndømbogo, Mbumbukiam segéviwám.” ");
INSERT INTO kvg_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Khøuwa nøme, Yesu-gu evo neka emekheis ndøfakház. Geté ndigu kopømba mbaín, Yesu-te vǿe-ōz. Zapa ndǿgo, ezoqa khàpumu-khouwéz. ");
INSERT INTO kvg_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Yaq ezoqa nøme, āv gimbøe-einím nqǽgo, “Qogu qavo neka qamekheis ngó꞉wani, bavokho. Qo ndǿqamekhám.” ");
INSERT INTO kvg_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yaq Yesu gendo-qavøiu, “Nogu evo neka nqamekheis ndígu, Mbumbukiam-qa Manqat ndiyoge neka ndimbopaev.” ");
INSERT INTO kvg_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Khøuwa nøme, Yesu ekeza paev ezoqam namba, khagua-té ginøketáb, gezø-ein, “Yaq-keoqá qazinǿ-qantáv.” Yaq sasa ndøsøkuzim. ");
INSERT INTO kvg_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Giqantavat, Yesu venanqei mbovín. Yaq gèbúv. Yaq anana-mba mø̀ndu꞉bǿen, mbe-qape tāndōfeā. Khamøe qando-okhoam, lokh bøi-té qanø-tøvøyát, ambá vø̄-qambuanemɨn. ");
INSERT INTO kvg_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yaq até gindigonem, Yesu gèti꞉nám, gimbo-einim, “Evézøza, Evézøza. Ni avønín zígeón.” Yaq Yesu gendosuzam, vø̄-itan. Yaq khamøe ndøgo, vø̄fegimam-a, vø̄vumøyat, manqat sasanqa-us mbo-eín. Yaq ndøgo sègevøitáv. Qavøitav mbómā. ");
INSERT INTO kvg_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yaq Yesu ekeza paev ezoqam gezø-ein, “Zo unimanqatin mbaîn, Mbumbukiam-te?” Yesu matev av ge꞉matanam ndægo, yaq tegi paev ezoqam, nqova ndafe kandambá neka møe vø̄gonem. Yaq, yaqyaq-a gibond, “Ngenek gekha ezoqâm? É, até khamøe fegim neka khamøe vumøe, manqat mba mbomanqaté. Yaq ndøgo manqa o-mba mbøendapé.” ");
INSERT INTO kvg_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu ekeza paev ezoqam namba, Gelasa ezoqam-qá manqei-té ginøqantáv. Ta manqei ndøgo, Gelili manqei yaq-keoqá qagó. ");
INSERT INTO kvg_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu khagua-te gendovuao, yaq vemiav-ak kopo ndowáv. Ndego nqova soqøsoqa mbøigoám. Viav kopoáv, ndego ndabua uzumáv neka ve-te sømbimáv. Geté nandi nqa-té geyagám. Ta nandi nqa-te ndøgo, løvøte ezoqam ndø-osupám. ");
INSERT INTO kvg_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Yaq ngenek ezoqam Yesu ge-omet, kandambaqapé sege-ogeá, ekeza kha, teqa megemege-te, manqei vø̄elavao. Yaq āv gene-akhá nqǽgo, “Yésu, Mbumbukiam-ge Yo, ndego Eqeiwat-Qape, qo no gekha qonǿgō? Mbumbukiam-qa iz-te, nqataqá-viam, no nqosøgeap nø-etòa᷄m.” ");
INSERT INTO kvg_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ndego nqanek manqat ge-ein, zapa ndǿgo. Yesu nqova soqa fakhane manqat mbo-eín. Ndego nqova soqa oskia ndøqanøtumám. Khøuwa kopoáv. Bov neka pingim, auli sen ambá gimbøe-løvønøvememɨ́n. Geté ndego sège-løvuzuín. Yaq nqova soqa, ndego ezoqam-av manqei-té genø-ituín. ");
INSERT INTO kvg_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yaq Yesu gembobevap, “Qo gekha îz?” Yaq ndego gendo-qavøiu, “Noqa iz Bawan-qapé.” Nqanek tene-eín ndǿgo. Zapa ndǿgo, nqova soqøsoqa kopoáv, teqa mokho-te gimbøigoam. ");
INSERT INTO kvg_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Yaq ndigu nqova soqøsoqa, Yesu āv gimbøe-viømém nqǽgo, “Ni manqei ozu-te, nqa vaev mbain ndøgo, ndøkhofòta᷄n.” ");
INSERT INTO kvg_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ta manqei avønin-te ndøgo, bøsi nen mø̀ndøwanám. Kopoav-qapé. Manqei poyat-té givagimám. Yaq nqova soqøsoqa, Yesu gimbo-viømem, “Ni ambá bøsik mokho-té qonø-khofotanɨ́n?” Yaq Yesu sègezøták. ");
INSERT INTO kvg_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Yaq ndigu nqova soqøsoqa, gèfakház, ndego ezoqam-qa mokho-te gu꞉goam, bøsik-te vømø̄-oz. Yaq bøsik manqei khavoe-té ginøbøín, ibøkha-te vømø̄-geonim. ");
INSERT INTO kvg_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Yaq ezoqam ndigu, bøsik gizø-kewagam, nqanek matev giqeivim, ndigu møe ndøbøín, yaq taon-te neka vemivemiav-te, ezoqa emanqat vømøzømbē-vototap. ");
INSERT INTO kvg_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Yaq ezoqa tinduzáv ndǿgo. Matev qeivi-qa ndøgoám, ma qæfakhan ndøgo. Yaq Yesu-te gimøfakhaz, ti-ometám ndǿgo, ndego ezoqam, nqova soqøsoqa gimbo-fakhaz, ndabua ndø-uzupám neka matavap kopømba vømbōgoam. Yesu-qá zenda tokhotapak megemege-té gonoqotám. Yaq ndigu møe ndøgoném. ");
INSERT INTO kvg_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yaq ezoqam ndigu, matev bøi gi꞉qeivim, emanqat zømbe-votót, ndego nqova soqøsoqa gimbogoam, ande āv kenē-khakhæv. ");
INSERT INTO kvg_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Yaq ezoqa ewaqape, Gelasa manqei-te giyagam, Yesu āv gimbøe-viømém nqǽgo. Tiqa manqei, yà be-iváv. Zapa ndǿgo, ndigu møe kandambá gigonem. Yaq Yesu gèketáo, sasa ndøsøkuzim. ");
INSERT INTO kvg_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Yaq ndego ezoqam, nqova soqøsoqa gimbo-fakhaz, Yesu namba okho-qa mboviám. Geté Yesu ndego takeáv, gembo-ein, ");
INSERT INTO kvg_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Qakeza vemiav-té qonǿqaváq, ezoqa voqomé-zømās, Mbumbukiam ande āv keqambē-matanam.” Yaq ndego ekeza vemiav-té genøwáv. Manqat sège-manqatát, vemiav-te ate qægoam, Yesu ande āv kembøē-matanam. ");
INSERT INTO kvg_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu kewan yaq-keoqa nqawa geqantavat, gemøqa, yaq ezoqa kopoáv, khanakhanakh mbogoném, ge꞉fakhan. Zapa ndǿgo, ndigu gèmbøe-kewagám. ");
INSERT INTO kvg_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Yaq nqáe! Ezoqam tendowáv ndǿgo. Teqa iz Zailés. Ndego Zu ezoqam-qá guliguli khoev megeat ezoqám. Yaq ndego até gendego, Yesu-qa zenda tokhotapak-qa megemege-te, ekeza kha, manqei me꞉laváo, ekeza khoev-te okho-qa yaq-te vømbōviam. ");
INSERT INTO kvg_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Zapa ndǿgo, tegu yu, ndugu viav ande av tuelv ndægo qambøegoam, gènanimtát. Neka ndego nakheis nøme mbaín. Yaq Yesu gemat, ezoqa bawan-qape gèqanabát, ambá vø̄tøgutømemɨn. ");
INSERT INTO kvg_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ta bawan mokho-te ndøgo, sævam kopo mø̀ndu꞉goám. Ndugu kouk mbowavám. Nupøkhán mbá. Viav ate qægoam, tuélv, qambowavam. Ndugu tugi moni ate gi꞉goam ambá guni-ngiæzotám, mulømula etoam ezoqam-te. Geté ezoqa kopo, kopømba mbaín vǿe-khakheinøvēm. ");
INSERT INTO kvg_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yaq ndakin ngunuk sævam, Yesu-qá zita-té gunduwáv, teqa ndabua ov-qase vømbō-khanaz. Yaq nqova mbaín. Tuqa kouk waev, sègembo-navøém. ");
INSERT INTO kvg_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yaq Yesu gebevap, “No gekha ezoqām ndǿkhantan?” Geté ezoqa ewaqape gò꞉naomém. Yaq Pita gembo-qavøiu, “Evézøza. Ezoqa bawan-qape khàpumu-khouwév, qoqa kha ngikhanazumit.” ");
INSERT INTO kvg_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Geté Yesu gendo-ein, “Ezoqa mø̀ndø-khantán. No tøtenøtén ndǿgo. Zapa ndǿgo, noqa bazaføgakh nøme, ezoqam-té qanøwáv.” ");
INSERT INTO kvg_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yaq ngunuk sævam gui-otev av nqægo, Yesu mø̀ndøqānd, yaq sègendowáv. Kha wageap-ús. Yaq Yesu-qa megemege-te, ekeza kha, manqei me꞉laváo, ezoqa ewaqape-qa bøi-te vø̄vøndøyam, gekha zapayā gunī-khantav, yaq ndaføyambā sege-eqeieqei-ēv. ");
INSERT INTO kvg_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yaq Yesu gumbo-ein, “Ngólam. Qoqa unimanqatin nandav, tø̀khakheinøqavém. Mòqoqáv. Qo mbøni betaqàva᷄ev.” ");
INSERT INTO kvg_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu ate av-té manqat ge꞉manqatam, yaq Zailes-qa khoev-te, ndego Zu ezoqam-qa guliguli khoev gezømbo-megetam, ezoqam tendowáv ndǿgo, vømbō-ein, “Qogu yu mø̀ndønaním. Nandev nømendim ezoqam, sekemba mbopòuwe᷄꞉t, tendowav.” ");
INSERT INTO kvg_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Geté Yesu nqanek manqat ge-ewag, yaq ndego Zailes āv gembøe-eín nqǽgo, “Qo ndøfofògea᷄p. Soqó-unimanqatín. Ndugu segé-khandí꞉v.” ");
INSERT INTO kvg_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu Zailes-qa khoev-te gemøfakhan, yaq ezoqa nøme gèzømbe-khafén, te namba ti꞉-oz. Geté ti-mba ndígu tekhatób, Pita neka Zion neka Zems, neka nakhasam-gi evøndipakha. ");
INSERT INTO kvg_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ezoqa ewaqape, eiv neka osombo ndøgoném, nakhasam-te. Geté Yesu gezø-ein, “Eiv ság! Ngunuk nakhasam nanimateáv. Geté venanqei ndøbuvít.” ");
INSERT INTO kvg_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Yaq ndigu Yesu gèvøngi꞉nám. Zapa ndǿgo, ndigu mø̀ndæzøtéz, ndugu mø̀ndønanīm. ");
INSERT INTO kvg_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Geté Yesu até gendego, mbasønakam zenda vømbōgea, sasa ndø-akha, “Khapúlav. Mòqo-itán!” ");
INSERT INTO kvg_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yaq tugu nqova, nqawá gumøndæ-veséz. Yaq ndaføyambá, ndugu sègendo-suzám, vø̄-itan. Yaq Yesu mbasønakam-te, lou etoam manqat ndø-eín. ");
INSERT INTO kvg_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nakhasam-gi evøndipakha, ndigu nqova ndafe kandambá. Geté Yesu gèzømbe-khafén. Ezoqa nøme bezø̀-ei᷄n, av matev qæfakhan ndægo. ");
INSERT INTO kvg_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Khøuwa nøme, Yesu ekeza paev ezoqam tuelv, gèmøváb. Yaq ndego iz neka bazaføgakh zø-etoám. Ndigu ezoqa nqova soqøsoqa vinivinimba zǿngeasumát neka enqoni-us ezoqam vǿkhakheinøvemāt. ");
INSERT INTO kvg_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Yaq tene-khofosám ndǿgo, ezoqa Mbumbukiam-qa Megeat Matev-qa yaq-té giní-zømesimát neka enqoni-us ezoqam vǿkhakheinøvemāt. ");
INSERT INTO kvg_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Āv gezømbe-eín nqǽgo, “Tozo-okhoat, gigiap ndø-upø̀gi᷄m, av nqægo, tatuag neka moqos neka lou neka moni neka ndabua enend nonqo. ");
INSERT INTO kvg_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Zo ezoqa khoev tizø-einat, ta khoev-te ndøgo, até vøsokhoé. Yaq ta-mbá tøzøté-ivøvemát ndǿgo, vemiav nøme-te tozozavat. ");
INSERT INTO kvg_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Geté zo vemiav nøme-te tozomø-fakhazat, yaq ndigu zo khatobeav tøgoat, ta vemiav ndøgo, sège-ivøvemát. Yaq pakhakh ndøgo, zoqa zenda tokhotapak-te tøgoat, sozó-pomoememát. Yaq ndigu tìabiti-zøtezát, ni manqa-zapa zigonēm.” ");
INSERT INTO kvg_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yaq ndigu gèpanqaním, vemivemiav vinivinimba-te, Mbumbukiam-qa Manqat Mbomambaqape vømē-zømesim-a, enqoni-us ezoqam vømø̄-khakheinøvem, manqei-manqei ate qægoam. ");
INSERT INTO kvg_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Yaq Elod, ndego Gelili plovins-ge kawa ezoqam, manqat ge-ewag, matev vinivinimba qafakhanumat, ndego gò꞉beváp. Zapa ndǿgo, ezoqa nøme āv gini-manqatám nqǽgo, “Zion, ndego ibøkha iz etoam ezoqam, nangó gendo-khandí꞉v, løvøte-te.” ");
INSERT INTO kvg_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Geté ezoqa nøme gimanqatam, “Ilaiza ndøfakhán.” Neka ezoqa nøme, āv gini-manqatám nqǽgo, “Mbumbukiam-gi manqa vevezam ezoqam, ibugukhokhof giyageapam, nøme nangó gendo-khandí꞉v.” ");
INSERT INTO kvg_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Yaq Elod āv gene-eín nqǽgo, “Zion, noqa manqa vøovam-te, monqo mbokepøzém. Geté ngenek gekha ezoqâm, emanqat nqæmbo-yoge?” Yaq ndego Yesu omete-qa ndøgoám. ");
INSERT INTO kvg_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesu-gi u-anim nango ginduvesez, vø̄e-ometem, av nqægo, matev ande āv kinī-matønumam, yaq ndego vemiav nøme-té genø-itúb. Ta vemiav-qa iz, Betsaidá. Ndego ambá gemø-yakhapus-mokho-mba-ezín, ti namba. ");
INSERT INTO kvg_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Geté ezoqa ewaqape gi꞉zøtez, av nqægo, Yesu ande āv kenēma, yaq ndigu sègembo-paevém. Yaq Yesu sègekhatób, neka Mbumbukiam-qa Megeat Matev-qa yaq-te vø̄e-zømesim neka enqoni-us ezoqam vø̄khakheinøvem. ");
INSERT INTO kvg_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Yaq qakhagus ndøgo, khøuwa ambá vømø̄-sinanɨn. Tegi paev ezoqam tuelv tinìzāv, Yesu vømbō-einim, “Ezoqa bawan-qape é-moqo-khofosám. Yaq vemivemiav neka khoev avøavun nqagot, lou neka venanqei nonqo, tìabimi-váo. Zapa ndǿgo, ni ezoqam-av manqei-té qazigú, nqanek.” ");
INSERT INTO kvg_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Geté yaq Yesu gezø-ein, “Lou zo zozǿ-etoám, tilog.” Yaq gindu-qavøinam, “Ni flawa faev neka zonga menas mba nigú. Gê, nginik ezoqa bawan-qape, lou ni nimøzǿwī?” ");
INSERT INTO kvg_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ndigu nqanek manqat gi-einim, zapa ndǿgo. Ezoqa kandambá gigoam. Angana ate gi꞉goam, ande āv faev taosén ndi꞉gú. Yaq Yesu ekeza paev ezoqam gezø-ein, “Ezoqa yà beqonáv. 50 50-té giabenø-qoqongeapét.” ");
INSERT INTO kvg_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yaq Yesu-gi paev ezoqam, āv tini-matønømém, yaq ezoqa ewaqape vø̄qonam. ");
INSERT INTO kvg_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yaq Yesu até gendego, nginik flawa faev neka zonga menas ge-upø̀zō, yan-te sasa ndøqan, Mbumbukiam ike manqat vømbō-ein. Yaq gèmbegím, tegi paev ezoqam vøzø̄-etoam, yaq ndigu ezoqa ewaqape sasa zø-etoam. ");
INSERT INTO kvg_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Yaq ezoqa ewaqape, lou tilóg ndǿgo, até vøzø̄-ewez. Yaq lou mbegeap ndøgo, ezoqa gi-ivøvem, gèpizumém. Yakhav tuélv ginqeitømem, qamøvea. ");
INSERT INTO kvg_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Khøuwa nøme, Yesu geguligulimat, tegi paev ezoqam mba ndøgoám, te namba. Yaq ndego āv gezømbe-beváp nqǽgo, “Gê, ezoqa no gekha ezoqām mé꞉næna?” ");
INSERT INTO kvg_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yaq ndigu gindu-qavøinam, “Ezoqa nøme ndimanqate, qo Zión, ndego ibøkha iz etoam ezoqam. Neka nøme ndimanqate, qo Ilaizá. Neka nøme ndimanqate, Mbumbukiam-ge manqa vevezam ezoqa nøme, ndigu ibugukhokhof giyageapam, ezoqa kopo nqawá gendo-khandí꞉v.” ");
INSERT INTO kvg_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yaq Yesu gezøbevap, “Gemâ zo? No gekha ezoqām zøténæna?” Yaq Pita gendo-qavøiu, “Qo Mesayá, ndego Mbumbukiam ge꞉manqatam, tendo-khofotav.” ");
INSERT INTO kvg_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yaq Yesu ekeza paev ezoqam gègugúb, vøzømbē-khafen, gezø-ein, “Zo ezoqa nøme me꞉zø̀ma᷄s, av nqægo, no gekha ezoqām.” ");
INSERT INTO kvg_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yaq Yesu manqat nøme, āv gezømbe-eín nqǽgo, “Ezoqam-ge Yo, nqosøgeap kandambaqape bendáp. Neka Zu megetapak neka Mbumbukiam-gi iziz ezoqa kandakanda neka Mozes-qa guguna manqat nømendim ezoqam bèsanqawém, sasa belaem. Geté khøuwa timømbo-misika-ez ndøgo, ndego Mbumbukiam nango ndø̀khandí꞉v.” ");
INSERT INTO kvg_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yaq Yesu ezoqa ewaqape gezø-ein, “Gekha ezoqām ndego, no-te paev-qa ndego, ndego ekeza poev matev, zitá geabetewuá, neka ekeza tae mutui bē-eqa, khøuwa ate tæpavpavemat, neka no sasa benøndopaev. ");
INSERT INTO kvg_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Gekha ezoqām ndego, ekeza yage geawat-qa tegoat, ndego ndæ̀khambuá. Geté gekha ezoqām ndego, ekeza yage te꞉khambua, no zapaya, ndego ndø̀møqeív. ");
INSERT INTO kvg_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Gèmbo-mataváp. Ezoqa manqei-qape gigiap ate nqægo tømbogawam, getē ekezan gēsoqoēv, vømǿ-navøēm, yaq ta gigiap ate ndægo, áv khambøé-tøkē? ");
INSERT INTO kvg_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Gekha ezoqām ndego, noqa yaq-te neka noqa manqat-qa yaq-te, mivi tegoat, yaq até Ezoqam-gé Yó-a, ndego mivi ndø̀gó te-te, ndego ekeza waev bazaføgakh-us neka Eve-qa waev bazaføgakh-us neka Mbumbukiam-gi enzol ezoqam-qa waev bazaføgakh-us namba te꞉geav. ");
INSERT INTO kvg_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","No unimanqatín nqazø-manqate. Zo ezoqa nøme nqazo-waniap, naqanøká zópakhaezák. Geté Mbumbukiam-qa Megeat Matev, ndòzotøkhæ-qeivím.” ");
INSERT INTO kvg_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu nqanek manqat ge-ein, yaq ande av khøuwa eit-qa zita-te, ndego Pita neka Zion neka Zems tène-upøzó. Yaq manqei pøyat-té gimøqavíg. Guligulim-qa ndøqavigát. ");
INSERT INTO kvg_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ndego ate av-té ge꞉guligulimat, yaq teqa bugug sège-enénd, neka ndabua vømbō-enend. Ùnime꞉-papaqá. Andé ndand vøiyám. ");
INSERT INTO kvg_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Yaq nqáe! Ezoqa menas sègefakház. Ezoqa ngínik, Mozes neka Ilaiza. Manqat ndømanqatám, Yesu namba. ");
INSERT INTO kvg_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ndigu ezoqa menas, Mbumbukiam-qá waev-ús. Yesu-qá løvøte-qa yaq-té gini-manqatám, neka ndego Mbumbukiam-qa manqa mbusa ande āv kemé-unimanqatīn, Zelusalem taon-te ndøgo. ");
INSERT INTO kvg_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita neka tegi zifuap menas, venanqei zøvín. Yaq sègesømbí. Yaq nango gindusuz, ndigu Yesu Mbumbukiam-qá waev-ús ndø-ometám, neka ndigu ezoqa menas vø̄zømet, te namba giwanam. ");
INSERT INTO kvg_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Yaq ndigu ezoqa menas, qavøne-qa gigoam, Pita Yesu āv gembøe-eín nqǽgo, “Evézøza. Qanimáv, ni nqeigu. Ni khoev-qasis misika nizǿpuán, qoqa kopo neka Mozes-qa kopo neka Ilaiza-qa kopo.” Pita nqanek manqat khokhó sege-eín. Ndego otevateáv, gekha manqat ge-ein. ");
INSERT INTO kvg_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita ate av-té manqat ge꞉manqatam, yaq ozoz ndokawá, vø̄gutaz. Yaq ndigu paev ezoqam, møe kandambá gigonem, ozoz qagutaz. ");
INSERT INTO kvg_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Yaq ozoz-te ndøgo, manqat ndofakhán. Āv qande-eín nqǽgo, “Ngenek nogé Yó. No nø̀veatáv. Zo teqa manqat gèyogé.” ");
INSERT INTO kvg_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Manqat ndøgo qame-navøem, yaq Yesu mba ndø-ometám. Yakhapús segeyám. Ndigu paev ezoqam, nqanek matev giqeivim, gèkhonoumám. Ta khøuwa-te ndøgo, ndigu ezoqa nøme-te manqatemáv, taqa yaq-te. ");
INSERT INTO kvg_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Yaq khøuwa nøme qandopave, Yesu tegi paev ezoqa misika namba, manqei poyat-te ginduvis, yaq ezoqa bawan-qape møqás. ");
INSERT INTO kvg_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Yaq nqáe! Ta bawan mokho-te ndøgo, ezoqa kopo āv gene-akhá nqǽgo, “Nøméndim ezoqam, no nø̀taqa-viám. Ambá noge yo qombo-tøkeɨ́n. No nakheis nøme mbaín. Sa kopo ngének. ");
INSERT INTO kvg_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nqova soqa ndøqanøtumatún. Yaq gè-ogeaɨ́n. Kha segembøɨ́-wageapét neka køse vømbó-qounīt. Faf-faf-ús. Ndego nqova soqa yovitáv neka ùnime꞉-ngiuín. ");
INSERT INTO kvg_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","No qogi paev ezoqam mø̀ezøviám, ngenek nqova soqa tingeatømem. Geté ndigu amba me꞉goném. Kopømba mbaín.” ");
INSERT INTO kvg_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yaq Yesu gendo-qavøiu, “Zo matev køfigiap neka unimanqatin mbain ezoqam, zo ndakin nqazoyage, gê, no khøuwa andé gekhâm, zo namba tizi꞉yagat neka zoqa viniv vǿe-eqatāt? Geté ság! Qoge yo vø̀ndondáf.” ");
INSERT INTO kvg_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Yaq ndego opønakam, ate av-té ge꞉geavun, nqova soqa manqei-té genø-ogiú, vø̄-uvutam. Kha sègembøi-wageapát. Yaq Yesu ndego nqova soqa gèmbøe-khafén, vø̄fakhan, neka opønakam vø̄khakheinøvem, yaq eve nqawa sasa mbo-etoam. ");
INSERT INTO kvg_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ezoqa ewaqape, nqanek Mbumbukiam-qa bazaføgakh-qape giqeivim, ndigu nqova ndafe kandambá. Ezoqa ewaqape, Yesu-qa matev ate ndægo-qa yaq-te, até gimbøe-matavupát, yaq ndego ekeza paev ezoqam gezø-ein, ");
INSERT INTO kvg_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Noqa manqat ùnime꞉-yogém, no ndakin tæzø-ein. Ezoqam-ge Yo, ezoqam-qá zenda-té ginǿveém.” ");
INSERT INTO kvg_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Geté Yesu nqanek manqat ge-ein, tegi paev ezoqam, manqa mokho ndapeáv. Gèkhonawám ti-te. Yaq ndigu kopømba mbaín, manqa mokho vǿe-qeivīm. Geté ndigu møe ndøgoném, Yesu manqa mokho-qa yaq-te vømbøé-bevøpēm. ");
INSERT INTO kvg_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Khøuwa nøme, Yesu-gi paev ezoqam, ekeza mokho-mba, gèponqombupát. Tini-ponqombupát ndǿgo, ti mokho-te, iz akhae kandambaqape, gekha ezoqā ndø̄go. ");
INSERT INTO kvg_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Geté Yesu é-møndæ-otév, ndigu gekhā mbómatavupam. Yaq ndego nakhasam ndo-itú, teqa avønin-te vø̄ve, ");
INSERT INTO kvg_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","gezø-ein, “Gekha ezoqām ndego, noqa iz-te, ngenek nakhasam tekhato, ndego no ndǿkhatómb. Neka gekha ezoqām ndego, no tekhatomb, ndego até ndegó-a, vǿkhatō, ndego no gendo-khofotan. Zo mokho-te, ezoqa kandambaqape ndégo tegó, ndego iz mbain ndøgo.” ");
INSERT INTO kvg_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Zion Yesu gembo-ein, “Evézøza. Ni ezoqam mø̀i-ometám. Ndego nqova soqøsoqa ndøngeasumatún. Qoqá iz-té genøgoatún. Yaq ni nìmbøe-khafeném. Zapa ndøgo, ndego ni namba, qo-te pøpøvumáv.” ");
INSERT INTO kvg_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Geté yaq Yesu gezø-qavøiu, “Mbøe-khafèa᷄p, ndego. Zapa ndǿgo, gekha ezoqām ndego, zo-te sanqaupav ndego, ndego zogé.” ");
INSERT INTO kvg_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Khøuwa ge꞉khatobat, Yesu yan-te te꞉qavig, ndego matavap āv genegó nqǽgo: Zelusalem taon-té genǿwáv. Yaq kopømba mbaín, teqa matavap toqo-enend taqa yaq-te. ");
INSERT INTO kvg_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yaq ndego u-anim ndøkhofotáz, teqa megemege-te. Yaq ndigu vemiav nøme-te gimøfakhaz, Samalia manqei-te ndøgo, ambá nakhoa mømbo-khakheinømemɨ́n, vømébūv. ");
INSERT INTO kvg_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Geté ndigu vemiav-ak, giyogem av nqægo, Yesu Zelusalem taon-tē genømā, yaq ndigu khatoweáv. ");
INSERT INTO kvg_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yaq tegi paev ezoqa menas, Zems neka Zion, tiqa matev giqeivim, ndigu Yesu āv gimbøe-einím nqǽgo, “Evézøza. Qoqa poev gekhâm? Ndizí-akhaem, gøinam betøndōvis yan-te, nginik ezoqam vǿngiæzō?” ");
INSERT INTO kvg_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Geté Yesu gèndoqambún, nginik ezoqa menas vø̄gugub. ");
INSERT INTO kvg_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yaq Yesu ekeza paev ezoqam namba, vemiav nøme-té gimøzáv. ");
INSERT INTO kvg_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yaq ndigu ate av-té nakhoa gi꞉geveat, ezoqa tendowáv ndǿgo, Yesu vømbō-ein, “Qo ande āv khoqoté-okhoāt, no até nøtaqá-pavát.” ");
INSERT INTO kvg_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yaq Yesu gembo-qavøiu, “Qanimáv. Geté gèmbo-mataváp. Gaqo lozokhak, sømbiam nonqo, manqei nqa ndøzø̂gó neka pipisi viviap ndø̄zø̄gō. Geté Ezoqam-ge Yo, khoev mbaín, te꞉sømbimat, pusa vǿe-tayāt.” ");
INSERT INTO kvg_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yaq ezoqa nøme-te, Yesu āv gene-eín nqǽgo, “Qonøndó-páev.” Geté yaq ndego ezoqam gendo-ein, “Evézøza. Até vøkhæ-keogé. Tat bàtøkhæ-otáv.” ");
INSERT INTO kvg_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Geté yaq Yesu gembo-qavøiu, “Āv taoká. Ekeza pakhaezat-ak tiabe-osám ndigu, gipakhaez. Geté qo, ezoqa Mbumbukiam-qá Megeat Matev qomé-zømesím.” ");
INSERT INTO kvg_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ezoqa nøme Yesu gembo-ein, “Evézøza. No ndø̀taqando-páev. Geté bàtøkhonáv, nogi ezoqam, ouo manqat bamøzø̄-ein.” ");
INSERT INTO kvg_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yaq Yesu gembo-qavøiu, “Gekha ezoqām ndego, manqei tekhaemet, yaq ndego zita-te sekembā segē-qambunimāt, ndego kopømba mbaín, Mbumbukiam-qa Megeat Matev-te sasae tego.” ");
INSERT INTO kvg_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Taqa zita-te, Evezøza paev ezoqa seventi-tu nøme ndøvevesám. Yaq teqá megemege-té genø-khofosám. Ezoqa menømenas ndøkhofosumát, ndøgo taon neka vemivemiav ate qægoam, ma ekeza okho-qa gembøegoam. ");
INSERT INTO kvg_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yaq ndego manqa zøløvuá, gezø-ein, “Khae-te avøe gigiap kandambá qakhatøkhatoam. Geté sasae ezoqam khapímbá, vøndé-peanēm. Yaq nakémbá. Khae eve, zombó-vi꞉mát, Mbumbukiam. Yaq sasae ezoqam, tèabetønde-khofotáz, teqa avøe gigiap qakhatøkhatoam ndøgo, betøndō-peanem. ");
INSERT INTO kvg_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mòzozáv. Nqáe! Zo andé sip nakheís. Geté zo gaqo khobokhobos-té qatø-khofosumít. ");
INSERT INTO kvg_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Moni neka moqos neka tamak ndø-upø̀gi᷄m. Ezoqa tozomø-qasat nakhoa-te, yaq ti namba manqa manqate-te, khøuwa iziz khapekhapé me꞉khòuba᷄m. ");
INSERT INTO kvg_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Khoev-te tozomø-ozat, zo bugukhokhof manqat nqánek qazozǿ-einát, ‘Sambí zo-te, zo nqanek khoev-te nqazoyage.’ ");
INSERT INTO kvg_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ndigu ezoqam, sambi-anim tigoat, zo vǿkhatobāt, yaq zoqa sambi manqat, até gégoát ti-te. Geté ndigu zo khatobeav tøgoat, zoqa sambi nango ndø̀zø-vesezát. ");
INSERT INTO kvg_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Zo ezoqa khoev tizø-einat, ta khoev-te ndøgo, até vøsøkhoé. Lou neka ibøkha vø̀logé, ndigu tizø-etoumat. Zapa ndǿgo, gekha ezoqām ndego, ndesasaeat, ndego teqa yage nonqo gigiap yà bembo-etoám. Sa ndøyàgea᷄p, khoev nøme-te, khoev nøme-te. ");
INSERT INTO kvg_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Gekha vemiav-tē ndøgo, tozomø-fakhazat, ndigu zo tikhatobat, yaq lou sège-logemát, zoqa megemege-te timøvøemat. ");
INSERT INTO kvg_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Enqoni-us ezoqam zókhakheinøvemát, neka ezoqa āv qazozømbé-manqatát nqǽgo, ‘Mbumbukiam-qa Megeat Matev, mø̀ndø-fakhán zo-te.’ ");
INSERT INTO kvg_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Geté zo vemiav nøme-te tozomø-fakhazat, yaq ezoqa zo khatobeav tøgoat, yaq nakhoa-té qazonǿ-wanát, ta vemiav-te ndøgo. Yaq āv qazozømbé-manqatát nqǽgo, ");
INSERT INTO kvg_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Até pakhákh-a, niqa zenda tokhotapak-te nqatøkeap, zoqa vemiav-te qei-okhoam, ni nìpomoemét. Yaq zo tøzøté-zøtéz ndǿgo, zo manqa-zapa zogoném. Geté zo vø̀ezøtéz, Mbumbukiam-qa Megeat Matev, mø̀ndø-fakhán.’” ");
INSERT INTO kvg_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yaq Yesu tegi paev ezoqam gezø-ein, “No nqazǿ-manqate. Manqa Ovøyam Khøuwa Kandambaqape timø-khantaz, ndigu vemiav-ak-te unimé꞉-soqá. Yaq-fia nqosøgeap ndøgo, ndigu tindapem, ndø̀mø-løvuám, av Sodom taon-ak timindapem.” ");
INSERT INTO kvg_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yaq Yesu manqat nøme gezø-ein, “Zo mòzo-soqoéz, zo Kolazin-ak neka Betsaida-yak. Zapa ndǿgo, no umingiap matev, zo mokho-te qæmatønumam, ambā Taya neka Saedon taon mokho-te tæmatanamɨn, ndigu ambá nupøkhán mbá, Mbumbukiam-te é-ndo꞉qambuzɨ́n, neka tiqa manqa-zapazapa zapaya, ndabua soqøsoqa vø̄-uzamɨn neka pakhakh-te vø̄qonavɨn. Geté zo qambuzaneáv. ");
INSERT INTO kvg_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Manqa ovøyam khøuwa timø-khantaz, zo-te unimé꞉-soqá. Yaq-fia nqosøgeap ndøgo, zo tozomø-ndapem, ndø̀mø-løvuám, av Taya neka Saedon taon-ak timindapem. ");
INSERT INTO kvg_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Neka ge zô, Kapenaum taon-ak? Zo, yan-té ginǿ-eqazō, av zo ndøzøte-matavap? Āv taoká. Zo gøinam-té ginǿ-nqagevém.” ");
INSERT INTO kvg_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yaq Yesu ekeza paev ezoqam gezø-ein, “Gekha ezoqām ndego, zoqa manqat tendap, ndego noqá manqat ndǿndáp. Neka gekha ezoqām ndego, zo tesanqab, ndego no ndǿsanqámb. Neka gekha ezoqām ndego, no tesanqamb, ndego até ndegó-a, ma no gende-khofotan, vǿsanqaō.” ");
INSERT INTO kvg_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yesu-gi paev ezoqam seventi-tu, nango ginduqavaz, ndigu khanakhanakh kandambá. Yaq gimbo-einim, “Evézøza. Até nqova soqøsoqá-ya, niqa manqat o-mba mo꞉ndapám, ni qoqa iz-te, manqat qeizø-manqatam.” ");
INSERT INTO kvg_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yaq Yesu gezø-qavøiu, “No Saitan mø̀e-omét. Yan-té gendobøiáv. Andé vøiyam me me꞉bøí. ");
INSERT INTO kvg_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nqáe! No zo bazaføgakh mø̀ezø-etoám. Zo waza soqøsoqa neka lakalaka sozó-tokhonevemát, neka zoge qaqa ezoqam, Saitan, teqa bazaføgakh ate ndægo vozó-tokhonēm. Yaq zo-te matev-qase gemǿ-fakhanák. ");
INSERT INTO kvg_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Geté zo ambá ta zapaya ndø̄go, khanakhanakh ndøgō, nqova soqøsoqa zoqa manqat o-mba nduondape, geté zo khanakhanakh ndǿgo tabezøgó, zoqa iziz yan-te ndo꞉peawap.” ");
INSERT INTO kvg_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ta khøuwa-te ndøgo, Yesu Nqova Mbomambaqape mokho-te, khanakhanakh kandambá gendap. Yaq āv gene-guligulím nqǽgo, “Tat, qo yan neka manqei-qape-ge Evezøza ndoqoqo. No ike kandambá qo-te. Zapa ndǿgo, qoqa matavap qòkhonáo, ti-te ndigu, ekeza kha zøtezat neka matavap loloakh-us ezoqam ndivewe. Geté qo ti-te ndígu toqonø-vevezám, ezoqam ndigu ande av nakhei nqonqon me ndi꞉gu. Unimanqatín. Tát! Qoqa poev, āv tønegoám.” ");
INSERT INTO kvg_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yaq Yesu manqat nøme ge-ein, “Gigiap neka matev ate nqægo, Tat noqá zenda-té genøvé. Ezoqa mè꞉zøtezák, ndego Yo gekha ezoqâm. Eve mba me꞉-otév. Neka ezoqa mè꞉zøtezák, ndego Eve gekha ezoqâm. Yo mba me꞉-otév, neka ndigu vǿezøtēz, Yo Eve-qa yaq-te vevezam-qa ndezøgo.” ");
INSERT INTO kvg_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yaq Yesu ekeza paev ezoqam-té genøqambún. Yaq ti-mba ndígu tezø-eín, “Zo khanakhanakh mbá qanegó, zo matev bøi nqazøte-qeivi, ndakin nqafakhanam. ");
INSERT INTO kvg_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","No nqazǿ-manqate: Mbumbukiam-gi manqa vevezam ezoqam neka kawakawa-za kopoáv, matev qeivi-qa ndøgoám, zo ndakin nqazo-qeivi. Geté ndigu qeiviáv. Neka ndigu manqat yoge-qa vø̄goam, zo ndakin nqazoyoge. Geté ndigu yogeáv.” ");
INSERT INTO kvg_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Khøuwa nøme, Mozes-qá guguna manqat nømendim ezoqam ndowáv. Ndego Yesu ambá gembo-matemateamɨ́n, gembo-ein, “Nøméndim ezoqam. No gekha matēv nómatønumāt, khandi miavmiáv vøténdáp?” ");
INSERT INTO kvg_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yaq Yesu gembo-qavøiu, “Gê, Mozes-qa guguna manqat áv khané-ein? Qo qoqo-geveam, gekha mokho qombóndap?” ");
INSERT INTO kvg_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yaq ndego gendo-qavøiu, “Mozes-qa guguna manqat, āv qane-eín nqǽgo, ‘Kuku betaqagó, Evezøza-te, ndego qoge Mbumbukiam, uni qoqa mbøni-te neka uni qoge nqova-te neka uni qoqa bazaføgakh-te neka uni qoqa matavap-te. Neka ezoqa nøme-te, kuku āv tabetaqambe꞉gó, av qakeza kha-te, kuku ndaqambe꞉go.’” ");
INSERT INTO kvg_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yaq Yesu gembo-qavøiu, “Qo unimanqatín ndoqo-manqate. Qo matev āv tønegó. Yaq qo khandi ndòqondáp.” ");
INSERT INTO kvg_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Geté ndego ezoqam, ekeza iz khakheinam-qa ndøgoám, yaq gendo-ein, “Gê, ezoqa nøme, gekha ezoqâm?” ");
INSERT INTO kvg_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yaq Yesu gembo-qavøiu, emanqat me꞉votót, gembo-ein, “Ezoqa mø̀ndøgoám. Zelusalem taon-té gendowáv. Ambá Zeliko taon-té genø-visatɨ́n. Yaq nakhoa livin-qase ndøugu, pepen ezoqam ndøqás, vø̄-møvøinam, ndabua sasa mbokhofoem, vø̄zuim. Yaq sège-ivøvém. Ndego ambá vø̄nanimin. ");
INSERT INTO kvg_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Yaq ta khøuwa iz kopo-te ndøgo, nakhoa-te ge꞉veam, Mbumbukiam-gé iziz ezoqam ndøgeavún. Yaq ndego ngenek ezoqam ge-omet, geveam, ndego nakhoa yaq-keoqá genøqantáv, vø̄løvu. ");
INSERT INTO kvg_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Yaq matev até kopó, ta nakhoa-te ndøgo, Livai bawan-ak ndøgeavún. Yaq até ndegó-a, ngenek ezoqam ge-omet, geveam, ndego nakhoa yaq-keoqá genøqantáv, vø̄løvu. ");
INSERT INTO kvg_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Yaq vaev, Samalia bawan-ak ndowáv, ta nakhoa-te ndøgo, ngenek ezoqam vø̄-omet. Yaq ndego tanakh mbogó, ");
INSERT INTO kvg_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","te-te vø̄wav, nqamav-te oil neka waen ande mulømula me vømbø̄e-qouzam, sasa mboløvønam, ekeza donki-qa zita-te vō꞉ve. Yaq okha ezoqam-qá venanqei nonqo khoev-té genøndáf, vømbō-kewagam. ");
INSERT INTO kvg_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Yaq khøuwa nøme qandopave, ndego silva moni mokho menas ndø-upøzó, ndego okha ezoqam-qa khoev keoge ezoqam vømbō-etoam. Yaq āv gembøe-eín nqǽgo, ‘Gèmbo-keogé, ngenek ezoqam. Yaq nango tøtøndo-qavan, qo fia nøme ande āv khoqoté-nqagivemēt, teqa kha-te, no fia ndæ̀gó.’” ");
INSERT INTO kvg_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu nqanek emanqat gumuvotot, yaq ndego Mozes-qa guguna manqat nømendim ezoqam, āv gembøebeváp nqǽgo, “Ge qô ndoqo-matavap? Ezoqa misika mokho-te nginik, matev eqeieqei, gekha ezoqām ndǿmatanam, te-te ndego, pepen ezoqam gizuim?” ");
INSERT INTO kvg_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yaq ndego Mozes-qa guguna manqat nømendim ezoqam gendo-ein, “Ezoqam ndégo, tanakh gembogo, vømbōtøke.” Yaq Yesu gembo-ein, “Nándav. Yaq até qó-a, matev āv toqotégoát.” ");
INSERT INTO kvg_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Khøuwa nøme, Yesu ekeza paev ezoqam namba, nakhoa gigeveat, yaq vemiav nøme-té gimøfakház. Ta vemiav-te ndøgo, sævam mø̀ndøgoám. Tuqa iz Matá. Yaq ndugu Yesu khoev-té gunukható. ");
INSERT INTO kvg_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ndugu yakhasuk mø̀ndømbo-goám. Tuqa iz Melí. Yaq ndugu Evezøza-qá zenda tokhotapak avønin-té gunøqóm. Nømendim manqat mbøe-ewagát. ");
INSERT INTO kvg_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Geté Mata ndugu, khanakhanakh mbaín, lou yakhapus gu-ifutat. Sasae khàpe mbøe-khouwév. Yaq ndugu tunøwáv ndǿgo, Yesu vømbō-ein, “Evézøza. Ge qô ndoqo-matavap, nqanek matev eqeieqeî, no nakhapus nqæsasaetet, yaq nogu nam, no tøkeeav ndøgo? Gèmbo-eín, nanduv, no yà benøtøké.” ");
INSERT INTO kvg_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yaq Yesu gumbo-qavøiu, “Máta, Máta! Qo matev vinivinimba-qa yaq-te, khàpe qote-fofogeáp neka matavap khàpe qambe-khouwevát. ");
INSERT INTO kvg_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Geté matev kopo mba betaqambegó. Ngunuk Meli, matev mbomambaqape ndøndáp, noqa manqat ngu-ewaget. Yaq ezoqa kopømba mbaín, tuiviwam.” ");
INSERT INTO kvg_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Khøuwa nøme, Yesu manqei nøme-te geguligulimat, yaq qamømbøe-navøem, ekeza paev ezoqa kopo nøme, āv gembøe-eín nqǽgo, “Evézøza. Ni guligulim-qa yaq-te qotínømánd, av Zion, ndego ezoqa ibøkha iz etoam ezoqam, ekeza paev ezoqam ge꞉zømas.” ");
INSERT INTO kvg_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yaq Yesu gezø-ein, “Zo tozo-guligulimat, āv qazøté-manqatát nqǽgo, ‘Tát! Qoqa iz yà beto-eqawát. Qoqa Megeat Matev, bètøndowáv ni-te. ");
INSERT INTO kvg_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Khøuwa ate tæpavpavemat, ni lou gìni-etoám, av ni lou mbain nqati꞉gu. ");
INSERT INTO kvg_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Niqa manqa-zapazapa, sà betaqambo-navøemát. Até ní-a, ezoqa nøme-qa manqa-zapazapa, mø̀ndønimbo-navupatún, ni-te gimatønumatun. Neka ni khamasim-te ndø-àmba᷄m.’” ");
INSERT INTO kvg_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yaq Yesu ekeza paev ezoqam gezø-ein, “Ge zô, ezoqa kopo, lova u-mba-qape zifu-qa khoev-te tema, vømømbó-eīn av nqægo, ‘Nǿfu. Flawa misika mba qonø̄-etoām. ");
INSERT INTO kvg_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Zapa ndø̄go, noge nøfu nøme, manqei nøme-tē genømā. Yaq ndakin noqā khoev-tē genøfakhān. Geté no lou mbaīn vømbǿe-etoām.’ ");
INSERT INTO kvg_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Yaq qafu khoev mokho-te āv gendē-qavøiū nqǣgo, ‘Mòqo-nøuvān! Khoev mboqog mø̀tøtokāz. Ni nìsømbiīt, nakheis namba. Yaq kopømba mbaīn tæsuzam, lou vøtaqá-etoām.’ ");
INSERT INTO kvg_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","No nqazǿ-manqate: Ndego tesuzam, lou vømbó-etoām, ndøgo ambá ta zapaya ndø̄go tenégō, ndego zifu ndembogo. Geté ta zapaya ndǿgo tenésuzám, ndego ge꞉pouweam, yaq gigiap ate ndægo, ndego mbain ndøgo, vømbó-etoām. ");
INSERT INTO kvg_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Yaq nakémbá. No nqazǿ-manqate: Gèviám. Yaq Mbumbukiam ndø̀zø-etoám. Gèváo. Yaq zo ndòzo-qeivím. Gèkhaneám. Yaq Mbumbukiam zo mboqog ndø̀zø-mboqozó. ");
INSERT INTO kvg_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Unimanqatín. Gekha ezoqām ndego, ndeviam, ndego ndø̀ndáp. Neka gekha ezoqām ndego, ndevao, ndego ndø̀qeív. Neka gekha ezoqām ndego, mboqog-te ndekhaneam, ndego mboqog ndø̀mbo-mboqóz. ");
INSERT INTO kvg_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Gê, zo mokho-te, matev áv khanégo? Nakhasam eve zongøyam-qa temboviam, ndego wazeam mbó-etoām? ");
INSERT INTO kvg_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O gava-qa temboviam, ndego lakalakoam mbó-etoām? Āv taoká. ");
INSERT INTO kvg_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Zo manqa-zapazapa-us, ambá qazøtegó. Geté zo zøkeza nakheis, gigiap eqeieqei etoam mø̀zøte-zøtéz. Yaq av tægoat ndægo, zoge Zøve, yan-te ngo꞉yage, ndego Nqova Mbomambaqape nøme mba zømbó-etoám, gekha ezoqām ndigu, timbøe-viømemat.” ");
INSERT INTO kvg_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Khøuwa nøme, Yesu manqa-khou ezoqam, nqova soqa mbongeatám. Yaq nqova soqa gembo-fakhan, ndego manqa manqate ndøngáz. Yaq ezoqa ewaqape, nqova ndafe kandambá. ");
INSERT INTO kvg_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Geté ezoqa nøme, āv gini-einím nqǽgo, “Ngenek nqova soqøsoqa, Belzebul-qá bazaføgákh gene-ngeasám, ndego nqova soqøsoqa-ge kawa.” ");
INSERT INTO kvg_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Neka ezoqa nøme ndigu, matemateam-qa mbogoám, neka teqa umingiap matev qeivi-qa vømbōgoam. ");
INSERT INTO kvg_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Geté Yesu é-møndæ-otév, av ndigu gi꞉matavupam, teqa bazaføgakh ande āv khanēfakhan. Yaq ndego yaya zø-etá, taqa yaq-te, gezø-ein, “Bawan kopo tigoat, yaq ndigu livin-mbā gunumú-qatønēm, izuizu nakhag vǿgonēm, nginik gékhoumbám, até vømú-nasinīm. Neka até evenáp-a, tiqatønem, yaq izuizu ndǿnøfeapāt, ndigu gemǿ-navøém. ");
INSERT INTO kvg_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Yaq Saitan-qa yaq-te, matev até kopó. Ndego ekeza kha livin-mba tumuqata, yaq ekeza kha namba vǿenøfē, teqa bawan áv khanégoāt? Yaq nakémbá, zoqa manqat mokho mbaín, nandozo-manqate av nqægo, no nqova soqøsoqa, Belzebul-qā bazaføgakh-tē qatø-ngeasām. ");
INSERT INTO kvg_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","No nqova soqøsoqa, amba Belzebul-qa bazaføgakh-te tøte-ngeasamɨn, av zo ndøzøte-manqate, yaq gê, zogī ezoqam, nqova soqøsoqa gekha ezoqam-qā bazaføgakh-tē ginǿ-ngeasumatun? Gê, Saitan-qā bazaføgakh-tē ginǿ-ngeasumatun. Āv taoká. Yaq nakémbá. Tiqa matev mø̀ndø-unimanqatín, av nqægo, zoqa manqat mokho mbaín. ");
INSERT INTO kvg_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","No nqova soqøsoqa, Mbumbukiam-qá bazaføgakh-té qatø-ngeasumatún. Ndøgo zo āv qanezømás nqǽgo: Mbumbukiam-qa Megeat Matev, mø̀ndø-fakhán zo-te. ");
INSERT INTO kvg_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Neka nøme nqánek: Ezoqa bazaføgakh-qape, ekeza khoev-te bøibøi to꞉yøet neka sanqava kopoav vømbógoāt, yaq teqa gigiap kopømbá. Ezoqa gembó-aqonamák. ");
INSERT INTO kvg_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Geté ezoqa uni bazaføgakh-us-qape-in tendowav, namba vǿenøfē, yaq-mba vǿzū, yaq ndego sanqava géviwám, ndego go꞉tawam, neka teqa gigiap vømbó-upøgīm, vømǿ-etøomēm, ezoqa nøme namba. ");
INSERT INTO kvg_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Gekha ezoqām ndigu, no-te nøzøzaneav ndigu, ndigu nogí qaqa ezoqám. Neka gekha ezoqām ndigu, no ezoqa møvøbam-qa yaq-te tøkemav ndigu, ndigu ezoqa gèpanqasumít.” ");
INSERT INTO kvg_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Nqova soqa ezoqam-te tefakhan, yaq ndego mbenga qaqaniap manqei-té gé-okhoát. Manqei eqeieqei-qa ndǿvawét, te꞉yagat. Geté qeiviav tøgoat, ekeza manqat āv gené-eín nqǽgo, ‘Ság. Nøkeza khoev-té qatǿveséz, ma qatønde-fakhan ndøgo.’ ");
INSERT INTO kvg_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yaq ndego nango tevesez, ta khoev ndøgo viayáp neka gapuk mbaín. ");
INSERT INTO kvg_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Yaq nangó genǿwáv, nqova soqøsoqa seven nøme vømøndó-khatōb, ndigu uni gi꞉soqøsoqoezam. Āv teoká, av ndego ekezan nde꞉go. Yaq ndigu tindúzáv ndǿgo, namba vøméqōm. Yaq vaev-te ndøgo, ndego ezoqam, teqa yage unimé꞉-soqá. Āv taoká, av bugukhokhof ge꞉yagam.” ");
INSERT INTO kvg_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu nqanek manqat ge-ein, yaq ezoqa ewaqape-qa mokho-te, sæva kopo āv guni-akhá nqǽgo, “Sævam ndugu khanakhanakh mbá guabitigú, qo gui-ova neka tete vøqā-etoumam.” ");
INSERT INTO kvg_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yaq Yesu gendo-qavøiu, “Unimanqatín, nandav. Geté uni khanakhanakh-in ndígu tøzǿgoát, ezoqam ndigu, Mbumbukiam-qa Manqat ndīyōgē neka manqa o-mba ndīmbø̄ē-ndāpē.” ");
INSERT INTO kvg_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ezoqam-qa bawan qakhouwevtat, Yesu-qa manqat gi-ewagat, yaq ndego āv gezømbe-eín nqǽgo, “Zo ezoqa ndakin nqazoyage, zo ezoqa soqøsoqá. Zo umingiap matev qeivi-qa mba zøgó. Geté zo matev nøme zóqeivimák. Sa ndǿgo tozóqeivím, av Ziona qambøe-fakhan. ");
INSERT INTO kvg_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Matev ndøgo, Ziona qambo-fakhan, Niniva ezoqam āv qanezømás nqǽgo: Mbumbukiam ndokhofotáv. Yaq até ta matev ndøgó-a, Ezoqam-ge Yo tømbo-fakhan, zo mé꞉zømás, zo ndakin nqazoyage, av nqægo, no Mbumbukiam ndokhofotān. ");
INSERT INTO kvg_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Mbumbukiam-qa Manqa Ovøyam Khøuwa Kandambaqape-te, ndugu Siba manqei kawa sævam kandambaqapu, segé-itán. Yaq ndugu zo ezoqa soqøsoqa mé꞉zǽb, zo ndakin nqazoyage. Zapa ndǿgo, ndugu qámbá gunduwav, Solomon-qa matavap loloakh manqat vømømbō-ewag, ndego Izlael kawa ezoqam kandambaqape. Geté, nqáe! Ngenek ezoqam zo namba nge꞉go, ngenek Solomon ùnime꞉-løvuám. Geté zo teqa nømendim manqat ndapeáv. ");
INSERT INTO kvg_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ta Manqa Ovøyam Khøuwa Kandambaqape-te, até Niniva ezoqám-a, vǿwān. Yaq ndigu zo ezoqa soqøsoqa mé꞉zǽb, zo ndakin nqazoyage. Zapa ndǿgo, ndigu manqa-zapazapa-te gigoam, màndo-qambúz, Ziona-qa manqat giyogem. Geté, nqáe! Ngenek ezoqam, zo namba nge꞉go, ngenek Ziona ùnime꞉-løvuám. Geté zo qambuzaneáv, teqa manqat qazoyogem.” ");
INSERT INTO kvg_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Lampa toqomag, yaq kopømba mbaín toqo-khonao o yakhav mokho-te voqotú-utāv. Geté lampa asøzam nonqo-té qonǿwuá. Yaq gekha ezoqām ndigu, khoev-te ti-ozat, waev ndǿqeivát. ");
INSERT INTO kvg_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Qoqa kha, waev bøi mbo-etoám. Bøi eqeieqei tøgoat, yaq kha ate ndægo, waev-té qágoát. Geté bøi soqain tøgoat, yaq qoqa kha ate ndægo, bøivun-té qágoát. ");
INSERT INTO kvg_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yaq nakémbá. Aiyá qagó. Soqaín ndøgo, ta waev ndøgo, qoqa mokho-te nandaqambu꞉gu, tøbøivun. ");
INSERT INTO kvg_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yaq nakémbá, qoqa kha ate ndægo, waev mokho-te mba tøugoat neka bøivun-qase mbain vǿgoāt, yaq kha ate ndægo waev-ús, kopømba av-té, lampa-qa waev qo-te ndækhaev.” ");
INSERT INTO kvg_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu manqa manqate qamømbøe-navøem, yaq Felisi ezoqa kopo, Yesu lou loge manqat mbo-eín. Yaq khoev-té gemømbo-ón, lou loge-te vø̄qom. ");
INSERT INTO kvg_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Geté Yesu bugukhokhof zenda sunguziav, av tiqa matev qægoam, lou gilogɨn. Yaq ndego Felisi ezoqam, nqova mbondáf. ");
INSERT INTO kvg_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yaq Evezøza, ndego āv gembøe-eín nqǽgo, “Zo Felisi ezoqam, zo kap neka melek, mumat mba zoto-sunguzumatún. Neka zo zøkezan, até kopó. Mumat-te ndo꞉go, eqeieqeí. Geté zoqa mokho-te, gigiap qovetu matev neka manqa-zapazapa, mø̀ndømø-tøtøvøyám. ");
INSERT INTO kvg_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Zo matavap mbain ezoqam, ge zô ndozo-matavap, Mbumbukiam ndego ezoqam gekhakheinøvem, mumat mba mbøé-khakheinam, getē mokho-te khakheinøpøteâv neka ndego otevateâv, ndøgo mokho-te ndøugu? Āv taoká. ");
INSERT INTO kvg_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yaq nakémbá, gigiap nandav, zoqa melek neka kap nandu-nqeitøve, zo gigiap-av ezoqam zozǿ-etoám. Yaq nqáe! Gigiap ate ndægo, ndǿgo tøzømbé-eqeieqeí. ");
INSERT INTO kvg_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Zo mòzo-soqoéz, Felisi ezoqam. Zo até avøe gigiap uni khasøkhasis-ín-a, qazøtøndo-pe꞉tatun, zòqaqaemɨ́n, qaqageap vømø̄-ten-ɨn, yaq qatoat kopo Mbumbukiam vozombō-etøomemɨn. Matev khasøkhasis av nqægo, zo mòzogoatún. Geté matev kandakanda, kopømba ande av ezoqa nøme-te, matev eqeieqei matanam matev, neka kuku matev Mbumbukiam-te, zo gèzømbo-qasí꞉v. Matev eqeieqei khasøkhasis tozogoat, ndøgo kopømbá. Geté gigiap-qape ndǿgo, matev eqeieqei kandakanda tozogoat. ");
INSERT INTO kvg_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Zo mòzo-soqoéz, Felisi ezoqam. Zo tøzømbe-khaneát ndǿgo, guliguli khoev-te, iz akhayapak-qá qonam nonqo-té qazó-qonumát, neka ezoqa ewaqape, maket manqei-te, zo khaiya mboma manqat vizap-us bezø̄-manqate. ");
INSERT INTO kvg_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Zo mòzo-soqoéz. Zo andé manqei-pakha ozap nøme me zøte꞉gó. Mumat-te ndøgo, bugug eqeieqeí. Geté mokho-te ndøugu, kha mø̀ndølanqá. Yaq ezoqa sogó-okhoát, mumat. Zapa ndǿgo, ndigu zøtezateáv, av nqægo, nqanek ezoqa-pikia nge-otø̂vē.” ");
INSERT INTO kvg_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yesu nqanek manqat ge-ein, yaq Mozes-qa guguna manqat nømendim ezoqa kopo, āv gembøe-eín nqǽgo, “Nøméndim ezoqam. Qo nqanek manqat nandoqo-manqate, qo até ní-a, iz sòqonimbu-ngi꞉wát.” ");
INSERT INTO kvg_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yaq Yesu gembo-qavøiu, “Unimanqatín. Até zó-a, Mozes-qa guguna manqat nømendim ezoqam, zo mòzo-soqoéz. Zo ezoqa viniv-qape zozømbø-awám. Yaq ezoqa amba-amba me꞉-eqagím. Geté zo zenda-qase aumáv, ezoqa vozozømbé-tøkeāt, ndigu nqanek viniv ndi-eqawat. ");
INSERT INTO kvg_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Zo mòzo-soqoéz. Zapa ndǿgo, zo Mbumbukiam-gi manqa vevezam ezoqam-qa manqei ozap-te, khoev qaniqanimav zozø-puanumatún, zoqa matavap vesezu nonqo. Geté ndigu zøkeza zøzøkha-zapazapa-za ndøzitagát. ");
INSERT INTO kvg_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Zo matev av nqægo ndozogo, yaq zo zò-unimanqatintét, av nqægo, matev ndøgo, zogi zøzøkha-zapazapa-za gigonem, eqeieqeí. Ndigu gèzitagám, ndigu Mbumbukiam-gi manqa vevezam ezoqam, yaq zo tiqa manqei ozap mumat, khoev qaniqanimav zozø-puanumatún. ");
INSERT INTO kvg_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Mbumbukiam ekeza matavap loloakh-te, taqa yaq-te āv gene-eín nqǽgo, ‘No manqa vevezam ezoqam neka u-anim notøndó-khofosumát, ti-te. Geté nøme ndigu, pakhapakha zǿkhanæmát neka matev soqøsoqa vøzǿgoāt.’ ");
INSERT INTO kvg_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Yaq nakémbá, Mbumbukiam-gi manqa vevezam ezoqam ate gi꞉goam gizitagat, Mbumbukiam manqei-qape ande ge꞉khakheinam, atema ndakin, taqa yaq-fia nqosøgeap, zo-té qanǿbøí, zo ndakin nqazoyage, ");
INSERT INTO kvg_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ta zitøge matev ndøgo, qangaz, Eibol gilaem, qamat, atema Zekalaya vømø̄laem, yaq lou-qase-te ndøgo, ma Mbumbukiam-te søvakha gigiap giløvusumatun, yaq ndøgo, Mbumbukiam-qa khoev ndøwev, livin-qase ndøugu. No unimanqatín nqazø-manqate. Nqanek yaq-fia nqosøgeap, zo zóndapém, zo ndakin nqazoyage. ");
INSERT INTO kvg_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Zo mòzo-soqoéz, Mozes-qa guguna manqat nømendim ezoqam. Zo mboqog mboqogim nonqo, mòzo-khonøbém, Mbumbukiam-qa yaq-te zøtezat nonqo. Zo zøkezan onimáv, neka zo ezoqa nøme zòzømbø-kház, ndigu onim-qa ndigu.” ");
INSERT INTO kvg_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu nqanek khoev ge-ivav, yaq Mozes-qa guguna manqat nømendim ezoqam neka Felisi ezoqam, qaqa matev ndøngazém, te-te. Yaq ndigu bevap vinivinimbá gimbogoam. ");
INSERT INTO kvg_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ambá gembo-matemateømemín. Yaq ndego manqat soqain te-einin, yaq ambá manqa ovøyam-té ginø-veemɨ́n. ");
INSERT INTO kvg_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ndakin ezoqa kopoav-qapé gindupindam, Yesu-te. Taosen mø̀ndømø-løvú. Izuizum sège-tokhonømbemám. Geté Yesu bugukhokhof ekeza paev ezoqam, āv gezømbe-eín nqǽgo, “Gò꞉feazoát. Felisi ezoqam ndigu, khavozam ezoqám. Tiqa matev, bugug eqeieqei ndøkeogé. Geté soqaín. Neka tiqa khavozam matev, andé flawa poponøvem nonqo me me꞉panqavøemɨ́n, ezoqa nøme-te. ");
INSERT INTO kvg_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Geté gekha matēv ndøgo, ndøgutøve, bavokhó qandó-fakhanám. Neka gekha manqāt ndøgo, ndøkhonøwe, ndø̀ndo-veveám. ");
INSERT INTO kvg_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Manqat ndøgo, zo lovølova ndozo-manqate, yaq tøndo-paveat, ezoqa ewaqape sugumú-ewagét. Neka manqat ndøgo, zo khoev mokho-te, ezoqa nøme-qa gea-te sa ndozoto-potozu, bavokhó sugumú-vøndavét.” ");
INSERT INTO kvg_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yaq Yesu manqat nøme gezø-ein, “Nǿfuap! No nqazǿ-manqate: Zo ndigu møe zø̀go᷄, ndigu ezoqa pakhapakha sa ndikhanæ. Zapa ndǿgo, ndigu kha mba zǿngiú. Geté taqa zita-te, ndigu matev nøme kopømba mbaín tizøgo. ");
INSERT INTO kvg_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Geté no ndakin nøtézømás av nqægo, zo møe gekha ezoqām zombógoāt. Zo møe ndégo tozombó-goát, Mbumbukiam. Ndego bazaføgakh ambá ta-mba nqānek, qambøegō, ezoqa tezitag. Geté taqa zita-te, ndego kopømbaqapé, ezoqa gøinam-té gemǿ-nqagivém. Unimanqatín. Møe te-mbá tømbogó ndego. ");
INSERT INTO kvg_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Zo mø̀zøte-zøtéz. Pipisi nakheis-qa fia khapekhapémbá. Moni mokho-qasis menas, faev soqotéwí. Pipisi, fia khasøkhasis ambá ginigú. Geté Mbumbukiam ndezø-keôgé, ndigu. Ndego pipisiam kopo, manqa mate gembøé-navøemák. ");
INSERT INTO kvg_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Geté gèmbo-mataváp. Zo-te até zogí izúm-a, zoqa kawa-te ate nandigu, Mbumbukiam mø̀ndø-gevebám. Yaq nakémbá. Zo møe ndø̀go᷄. Zo Mbumbukiam-qa bøi-te, pipisi kopoav-qape ùni zøte-løvubám.” ");
INSERT INTO kvg_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “No nqazǿ-manqate: Gekha ezoqām ndego, ezoqam-qa bøi-te te-unimanqatintat, av nqægo, ‘No Yesu-gē ezoqām,’ teqa yaq-te, até Ezoqam-gé Yó-a, Mbumbukiam-gi enzol ezoqam-qa bugug-te, āv gené-unimanqatín nqǽgo, ‘Ngenek nogē ezoqām.’ ");
INSERT INTO kvg_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Geté gekha ezoqām ndego, ezoqam-qa bøi-te noqa yaq-te to꞉nawam, teqa yaq-te, até nó-a, ndæ̀tonawám, Mbumbukiam-gi enzol ezoqam-qa bugug-te. ");
INSERT INTO kvg_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Gekha ezoqām ndego, Ezoqam-ge Yo-qa yaq-te, manqa soqøsoqa ndemanqate, ta manqa-zapa ndøgo, Mbumbukiam kopømbá, segembøé-navøém. Geté ezoqa Nqova Mbomambaqape-qa iz tengiu, Mbumbukiam teqa manqa-zapa gembøé-navøemák. ");
INSERT INTO kvg_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Zo ezoqa Zu ezoqam-qa guliguli khoev-te o megetapak-qa megemege-te o gekha kawakawa-za-qa megemege-te ti-itub, yaq zo ndøfofògea᷄p av nqægo, ande gekha manqat me zozømbé-qavøiū o gekha manqat zó-einīm. ");
INSERT INTO kvg_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Zapa ndǿgo, ta khøuwa-te ndøgo, Nqova Mbomambaqape zǿ-ovøyám, zo ande gekha manqat me zøté-einīm.” ");
INSERT INTO kvg_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yesu ezoqa bawan-qape manqat gezø-manqatat, yaq livin-te ndøugu, ezoqa kopo āv gembøe-eín nqǽgo, “Nøméndim ezoqam, noge ata gèmbo-eín, tat-qa gigiap, yà bani-etøomém, ndøgo gini-ivav, genanim.” ");
INSERT INTO kvg_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Geté Yesu gembo-qavøiu, “Gê, no gekha ezoqām ndǿve, qo neka qazøpikia tæzø-ein, av nqægo, ‘Zøve-qa gigiap āv qazøtē-etøomēm nqǣgo’?” ");
INSERT INTO kvg_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yaq Yesu ezoqa ewaqape, āv gezømbe-eín nqǽgo, “Aiyá qagó neka zøkeza kha, gèmbo-keogé. Zo gigiap me꞉qovètu᷄. Ezoqam-qa yage, ambá av nqǣgo, gigiap kopoav-qape-tē qanotawē.” ");
INSERT INTO kvg_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yaq Yesu yaya zø-etá, gezø-ein, “Ezoqa kopo mø̀ndøgoám. Gigiap kopoav ezoqám. Ndego khae vømbōgoam. Yaq viav nøme-te, ndego avøe gigiap kopoav-qapé qambo-fakhan. ");
INSERT INTO kvg_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Yaq ndego ezoqam gematøvem, ‘Áv khatégō? Noqa khoev ate nqæpuate løvøzupøteáv, avøe gigiap vøté-nqeitām.’ ");
INSERT INTO kvg_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Yaq ndego āv gene-eín nqǽgo, ‘No nqánek qǽgó. Lou nqeitam khoev awenege nó-evøzám. Yaq kandakanda ndakinak nópuán. Yaq lou tøtú꞉-nqeitám ndǿgo, noqa gigiap nøme namba. ");
INSERT INTO kvg_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Yaq taqa zita-te, no nøkeza mokho-mba āv qaté-eín nqǽgo, “No ndakin gigiap kopømbá. Viav kopoáv, no gigiap-qa nófofogeapák. No ndakin pusa mba nótavát, lou vǿelogāt neka ibøkha vǿe-izumāt. Yaq no khanakhanakh mbá qatéyagát.” ’ ");
INSERT INTO kvg_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Geté Mbumbukiam gembo-ein, ‘Qo matavupav ezoqam, qo nqægo lova qónaqaním. Yaq gê, qoqa gigiap ate nandaqambe꞉go, gekha ezoqām ndǿ-upøgīm, ndoqo-khatiwi? Qó mbá!’” ");
INSERT INTO kvg_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu nqanek yaya guzumbu-eta, yaq nøme āv gezømbe-eín nqǽgo, “Ndigu matev āv tøzømbé-fakhán, ndigu gigiap sa timøndatet, ekezan nonqo, getē Mbumbukiam-qa bøi-te, gigiap ande mbain me ndi꞉gu.” ");
INSERT INTO kvg_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yaq Yesu ekeza paev ezoqam gezø-ein, “Yaq nakémbá, no nqazǿ-manqate: Zo yage-qa yaq-te ndøfofògea᷄p, av nqægo, gekha lou zólogāt. Neka kha-qa yaq-te ndøfofògea᷄p, av nqægo, gekha ndabua zó-uzumāt. ");
INSERT INTO kvg_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yage-qa mokho, taoká ndøgo, lou mba toqologat. Neka kha-qa mokho, taoká ndøgo, ndabua mba toqo-uzumat. ");
INSERT INTO kvg_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pipisi zøtézømēt! Ndigu avøe gigiap ogekhæmáv, neka gendó-peanemák. Neka ndigu lou nqeitam nonqo khoev mbaín. Geté Mbumbukiam ndøzøkefé. Gèmbo-mataváp. Zo teqa bøi-te, pipisi ùni zøte-løvubám. ");
INSERT INTO kvg_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ge zô ndozo-matavap, ezoqa kopo zo mokho-te tefofogeapat, ndego yage elavøqase ndømbó-seketet? Mbaín! ");
INSERT INTO kvg_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Até nqanek matev-qasé-a, zo kopømba mbaín, tozo-matønømem. Av tægoat ndægo, yaq zo gekha zapâ, matev nøme-qa yaq-te ndozo-fofogeap? ");
INSERT INTO kvg_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Neka flawas zøtézømēt, ndi-umizan. Ndigu sasae gonemáv neka ndabua potofumáv. Geté no nqazǿ-manqate: Até Solomón-a, ndego kawa ezoqam kandambaqape, gigiap mbomømboma kopoav-qape qambogoam, teqa ndabua bugug keoge mbaín, av flawas ndi꞉gu, tiqa bugug ndækeoge. ");
INSERT INTO kvg_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nginik flawas, ndakin gagayag-te ndi-umianet, nakhamas-te ambá giní-pakhaéz, yaq gøinam-té ginǿ-nqagivemém. Geté Mbumbukiam ndabua bugug keoge eqeieqei zø-etoám. Mbumbukiam flawas ndabua eqeieqei ndezø-etoam, ndego zo nøme mba zømbó-uzám. Zoqa unimanqatin khapémbá, Mbumbukiam-te. ");
INSERT INTO kvg_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Zo lou-qa yaq-te neka izam-qa yaq-te, matavap khapé bezømbe-khouwèva᷄t neka mbofofògea᷄p. ");
INSERT INTO kvg_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Gigiap av nqægo upøgim-qa yaq-te, miavmiav bavokho-ak mba ndømataváp, ndigu Mbumbukiam zøtezateav ndigu, nqanek manqei-qape-te. Geté zoge Zøve, ndego mø̀ndæ-otév, gigiap av nqægo, zo bèzøgó. ");
INSERT INTO kvg_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Zo bugukhokhof Mbumbukiam-qá Megeat Matev mba zombóvawát. Yaq ndego zo nqanek gigiap nøme, ndø̀zø-etoám.” ");
INSERT INTO kvg_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Zo møe ndø̀go᷄, zo ande sip nakhei misika mba ndøzøte꞉go. Zapa ndǿgo, zoge Zøve-qa poev nqánek: Ndego teqa Megeat Matev zo zǿ-etoám. ");
INSERT INTO kvg_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Gigiap nandøzøgo, gèwí. Yaq moni ndigu, tozoqasem, gigiap-av ezoqam zozǿ-etoám. Av tøzøte-gonem ndægo, yaq zogi moni, yan manqei-té qazonǿ-møvøbumít. Ta manqei-te ndøgo, moni nqeisam nonqo ndigu, gékeqanimák. Neka moni ndigu, génasinimák. Neka aqona ezoqam, kopømba mbaín, tizømetam, neka khotet kopømba mbaín, tilouzim. ");
INSERT INTO kvg_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Matev āv tøzøté-goném. Zapa ndǿgo, ma zoqa gigiap qaniqanim ndægo, até zoqá mataváp-a, sa ndǿgo tǿgoát.” ");
INSERT INTO kvg_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Zo é-mozoto-khakheinám. Neka zoqa lampa até betøkháev. ");
INSERT INTO kvg_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Zo andé nginik sasae ezoqam me me꞉gó. Khakheitáp. Ndigu ekeza kawa-qa tiokewaget, ndego sakhei etoam matev-te gewav, yaq khøuwa nøme nqawa tendoqavan, mboqog-te vǿkhaneām, yaq ndigu mboqog nakhamas-té ginømbó-mboqozønám. ");
INSERT INTO kvg_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Yaq ndigu sasae ezoqam khanakhanakh mbá ginígoát, kawa ezoqam tendoqavan, ndigu vǿzømēt, timbøe-tiawet. No unimanqatín nqazø-manqate. Ndego kawa ezoqam, tegi sasae ezoqam av te꞉zømet ndægo, yaq ndego sasae nonqo ndabua ndǿ-úz, lou loge-te qonam manqat vøzǿ-eīn-a, lou vøzǿ-qoqōng. ");
INSERT INTO kvg_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Sasae ezoqam av ngi꞉gu, khanakhanakh mbá ginígoát, até ndøgó-a, tigi kawa ezoqam lova u-mba o nqoev-te tendoqavan, yaq ndigu tezømet, av nqægo, ndigu mø̀ndo꞉-khakheinām. ");
INSERT INTO kvg_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Gèmbo-mataváp: Khoev eve amba te꞉-otevɨn, av nqægo, ande gekha khøuwa iz-te, aqonam ezoqam tendowav, yaq ndego ambá gembótakák, khoev sa tembo-nqawaɨn. ");
INSERT INTO kvg_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yaq até zó-a, zo vò꞉khakheinám. Zapa ndǿgo, Ezoqam-ge Yo, ta khøuwa-te ndǿgo tendéqaván, zo matavapøteav tøgoat, ndego tendoqavan.” ");
INSERT INTO kvg_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yaq Pita Yesu gèmbobeváp, “Evézøza. Gê, yaya nqanek qoqo-eta, ni qoté-manqate, ó, ezoqa ewaqape qotē-manqate?” ");
INSERT INTO kvg_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yaq Evezøza gembo-qavøiu, “Ge qô ndoqo-matavap? Gekha sasae ezoqâm, ndego unimanqatin neka matavap loloakh-us? Sasae ezoqam unimanqatin neka matavap loloakh-us, av ngé꞉go. Tege kawa ezoqam, manqei nøme-te tewav, yaq ndego sasae ezoqam, keoge ezoqam teve, teqa khoev teqeivat neka tegi sasae ezoqa nøme, khøuwa eqeieqei-te lou vøzǿ-etoumāt, ");
INSERT INTO kvg_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","yaq vaev-te nqawa tendoqavan, teqeiv av nqægo, ndego sasae eqeieqei ndøgōt, yaq ndego sasae ezoqam kopømbá, khanakhanákh. ");
INSERT INTO kvg_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","No unimanqatín nqazø-manqate. Ndego kawa ezoqam, gigiap ate ndømbøego, keoge ezoqam ndégo tévé, ngenek sasae ezoqam. ");
INSERT INTO kvg_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Geté ndego sasae ezoqam, av te꞉matavupat nqægo, noge kawa ezoqam nakhamas-te gendō-qavanāk, yaq ndego sasae ezoqa nøme kha zǿkhanæmāt, angana neka sakheis, neka lou loge møqæ vømbóyāt neka ibøkha soqa izam møqæ vǿgoāt, yaq kawa mbó-okɨvāt, ");
INSERT INTO kvg_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","yaq tege kawa ezoqam, ta khøuwa-te ndǿgo tendéqaván, ndego sasae ezoqam khakheinøpøteav tøgoat neka otevateav vǿgoāt, ndego tefakhan. Yaq kawa ezoqam, ndego sasae ezoqam, yaq-fia nqosøgeap mbó-etoám. Yaq-fia kandambá teta, te-te ndego. Yaq ndǿgo tenǿ-khofotáv, ma unimanqatinteav ezoqa nøme ndi꞉gu. ");
INSERT INTO kvg_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Gekha sasae ezoqām ndego, tege kawa ezoqam-qa poev te-otev, gete khakheinøpøteav tøgoat neka teqa poev paeveav vǿgoāt, ndego yaq-fia nqosøgeap kandambá tendap. ");
INSERT INTO kvg_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Geté gekha sasae ezoqām ndego, tege kawa ezoqam-qa poev otevateav tøgoat, neka matev soqain vǿgoāt, ndego yaq-fia nqosøgeap andé khapémbá tendap. Gekha ezoqām ndego, Mbumbukiam otevat kandambaqape gembo-etoam, yaq ndego nqawa kandambaqapé sa bembo-qavøiú. Neka gekha ezoqām ndego, Mbumbukiam gigiap o matev kopoav teqa zenda-te go꞉ve, yaq ndego nqawa kandambá sa bembo-etoám.” ");
INSERT INTO kvg_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yaq Yesu manqat nøme gezø-ein, “No nqanek manqei-qape-te, gøinam mboqotøve-qa nøgeavún. Neka noqa poev kandambaqape nqánek: Ambá gewagimín. ");
INSERT INTO kvg_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Geté no ibøkha iz vini bàtøkhæ-ndáp. Yaq no mbøni vaev kandambá, taqa yaq-te, atema matev ate ndægo, vømǿ-navøēm. ");
INSERT INTO kvg_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ge zô ndozo-matavap, no nqanek manqei-qape-te, ezoqa sambi etoam-qa nø̄geavun? Āv taoká. No ezoqa qaqaza-qa nøgeavún. ");
INSERT INTO kvg_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ndakin matev āv qanéfakhán nqǽgo: Khoev kopo-te ezoqam faev tiyagat, ndigu ndø̀qatøném. Ezoqa misika, ezoqa menas gésanqáb, neka ezoqa menas, ezoqa misika vǿsanqāb. ");
INSERT INTO kvg_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Eve yo ndø̀sanqáo, neka yo eve vǿsanqāo. Evo yu ndø̀sanqáo, neka yu evo vǿsanqāo. Zakhapuka ziwap ndø̀sanqáo, neka ziwap zakhapuka vǿsanqāo.” ");
INSERT INTO kvg_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu ezoqa bawan-qape manqat nøme gezø-ein, “Zo ozoz qazo-qeivimin, khøuwa sininim tøwuøyav, yaq zo nakhamas-te āv qazøte-einimín nqǽgo: Qæ ndø̄lanqā. Yaq unimanqatín. Qæ sège-lanqaɨ́n. ");
INSERT INTO kvg_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Neka yaq sanqa khamøe qando-feaɨn, yaq zo āv qazøte-einimín nqǽgo: Khøuwa tatas-qape ndø̄yøēt. Yaq unimanqatín. Khøuwa tatas-qape sège-itanɨ́n. ");
INSERT INTO kvg_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Zo khavozam ezoqám, zo ndozo-manqate av nqægo, ‘Ni Mbumbukiam mø̀tinøtēn.’ Zo manqei neka khaiya qazo-qeivimin, yaq zo mø̀zøte-zøtezɨ́n, av nqægo, khaiya ande āv khanégoāt. Geté zo matev nqazo-qeivi, av ndakin nqæfakhate, zo gekha zapâ, taqa mokho ndapeav ndozogo?” ");
INSERT INTO kvg_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Yaq Yesu manqat nøme gezø-ein, “Zo gekha zapâ, zøkhapus mokho-mba matavapøteav ndøgo, gekha matēv ndøgo, eqeieqei ndøgo? ");
INSERT INTO kvg_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Gèmbo-mataváp. Qo ezoqa nøme-te moni ndiqambo-løfoke, yaq ndego qo manqa ovøyam-te ndapaqat-qa tegoat, qo manqat vø̀kho-khakheinám, te namba, ate av-té nakhoa-te tøzøte-apet. Soqaín ndøgo, ndego qo manqa ovøyam megeat ezoqam-qa zenda-te teve, yaq ndego qo polis ezoqam-qa zenda-te vǿvē, yaq ndego qo ndimbula-te sasa ndǿ-utāq. ");
INSERT INTO kvg_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","No nqataqá-manqate. Qo ndøgo naqanøká qotøndó-fakhaqák, atema fia ate ndægo voqotumúgū.” ");
INSERT INTO kvg_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ta khøuwa-te ndøgo, ezoqa nøme Yesu namba gi꞉goam, emanqat āv gimbøe-vototém nqǽgo: Gelili ezoqa nøme, Mbumbukiam-te søvakha gigiap ndøløvusumát. Yaq ate av-té, etoam matev gi꞉goat, Pailøt-gi nakhag ezoqam, gèzitág. Yaq av nqægo, tiqa kouk, søvakha gigiap-té qanø-o꞉á, ndigu Mbumbukiam-te etoam nonqo lou-qase-te go꞉-aomem, neka tiqa kouk namba vømø̄-tøkua. ");
INSERT INTO kvg_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu nqanek emanqat ge-ewag, yaq āv gezømbe-eín nqǽgo, “Ge zô ndozo-matavap, ndigu ezoqam, nqanek matev qazøfakhan, tiqa manqa-zapazapa kandambâ, áv táoka, ndigu Gelili ezoqa nøme-qa manqa-zapazapa? Yaq nakêmbà, nqanek matev qazøfakhan ti-te? ");
INSERT INTO kvg_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mbaín! Geté no nqazǿ-manqate: Zo Mbumbukiam-te qambuzaneav tøgoat, yaq até zó-a, zo ate ndøzøte꞉go, āv tøzømé-nasiním. ");
INSERT INTO kvg_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Neka ge zô ndozo-matavap, ndigu ezoqa 18 gipakhaez, Siloam kewan-qasi avønin-te ndøgo, khoev eqawat-qape qandonqoe, tiqa manqa-zapazapa kandambâ, áv táoka, ndigu ezoqa nøme-qa manqa-zapazapa, Zelusalem taon-te ndiyage? ");
INSERT INTO kvg_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mbaín! Geté no nqazǿ-manqate: Zo Mbumbukiam-te qambuzaneav tøgoat, yaq até zó-a, zo ate ndøzøte꞉go, āv tøzømé-nasiním.” ");
INSERT INTO kvg_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yaq Yesu yaya zø-etá, gezø-ein, “Ezoqa mø̀ndøgoám, ekeza waen khae-te, fig tae vømbōyam. Yaq tae nanga-qa gemøkewag, vi꞉pøteáv. ");
INSERT INTO kvg_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Yaq ndego tege sasae ezoqam, khae gembøe-kewagam, āv gembøe-eín nqǽgo, ‘Nqáe! No nqanek tae-te, nanga viam-qa nømbøe-kewagám. Viav misiká. Geté vi꞉máv. Ság! Qókhavoé. Manqei mo꞉khazú.’ ");
INSERT INTO kvg_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Geté yaq ndego sasae ezoqam gendo-qavøiu, ‘Khanánqa. Tae nqanek até betøkhæyá. Viav kopo nøme bètøkho-ngeatám. Tae zapa-te nqanek, manqei mumat bàtøkho-nqagím. Yaq pakhakh notóqouzám. ");
INSERT INTO kvg_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Éisa, viáv nøme qanéviám. Geté mbain tøgoat, kopømbá. Soqó-khavoé.’” ");
INSERT INTO kvg_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabat khøuwa nøme, Yesu Zu ezoqam-qa guliguli khoev nøme-te, Mbumbukiam-qa Manqat ge꞉zømesimat, ");
INSERT INTO kvg_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","yaq nqáe! Sævam kopo mø̀ndøgoám. Ndugu nqova soqa mbøigoám, ndego enqoni vømbō-etoam. Viav kandambá gumbøigoam. Viav ate qægoam 18́. Yaq ndugu zita køfí꞉v. Kopømba mbaín, ndaføyamba vǿe-itān. ");
INSERT INTO kvg_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu ndugu sævam gu-omet, yaq sègembo-akhá, vøndōwav, yaq gumbo-ein, “Ngólam, qo mòqo-eqeieqei-éq. Qoqa enqoni nandav, mø̀ndøqa-navøém.” ");
INSERT INTO kvg_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yaq ndego zenda mbøevé. Yaq nqova mbaín, ndugu sège-eqeieqei-év, ndaføyamba vø̄-itan, Mbumbukiam-qa iz sasa ndø-eqa. ");
INSERT INTO kvg_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Geté ndego Zu ezoqam-qa guliguli khoev megeat ezoqam, khanakhanakh mbaín, Yesu ngunuk sævam, Sabat khøuwa-te guikhakheinøvem. Yaq ndego ezoqa āv gezømbe-eín nqǽgo, “Sasae khøuwa ate ndi꞉gu, síks. Ta khøuwa-te ndǿgo tøzøtøndé-okhoát, eqeieqeizat-qa tozogoat. Ambá ndøgo, Sabat khøuwa-te.” ");
INSERT INTO kvg_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yaq Evezøza gembo-qavøiu, “Zo khavozam ezoqám. Até zó-a, zo sasae sòzogoatún, Sabat khøuwa-te. O gê, zo Sabat khøuwa-te, kao o donki nqovotumâv, neka ibøkha-te ituimâv. Āv taoká. Zo mòzogoatún. ");
INSERT INTO kvg_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Até ngunuk sævám-a, Eibleem-gú ziú. Geté Saitan viav kopoav-qapé gumøvøitam. Ate qægoam 18́. Yaq ge zô ndozo-matavap? Ngunuk kopømba mbaîn, Sabat khøuwa-te tu-eqeieqei-ev. Āv taoká. Kopømbaqapé!” ");
INSERT INTO kvg_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu nqanek manqat ge-ein, yaq tegi qaqa ezoqam ate gi꞉goam, mivi ndøndapém. Geté ndigu ezoqa nøme, khanakhanákh, Yesu matev kandakanda ate qægoam, gematønumam. ");
INSERT INTO kvg_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yaq Yesu gezø-ein, “Gê, Mbumbukiam-qa Megeat Matev ande gekhâm? Gekhā nøtékhamās? ");
INSERT INTO kvg_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Masted tae nanga nøtékhamás. Ndigu khapikhapímbá. Geté ezoqa, nanga kopo khae-te tezøgeakh, yaq ndigu gèkhouwezɨ́n, vømø̄-tae-ɨn, neka pipisi tang-te sasa mo꞉viviamɨn.” ");
INSERT INTO kvg_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yaq Yesu manqat nøme gezø-ein, “Gê, Mbumbukiam-qa Megeat Matev gekhā nøtékhamās? ");
INSERT INTO kvg_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Flawa poponøvem nonqo nøtékhamás. Sakheis khasøkhasis ndø-upøgimatún, khapémbá, flawa-te vø̄u-pomogimimin. Flawa poponøvem nonqo, khapelavøqase ambá qanegó, neka flawa kandambā. Geté flawa ate ndi꞉gu, sègemø-popoezɨ́n.” ");
INSERT INTO kvg_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu nakhoa gegeveat, Zelusalem taon-te gemat, ta taon neka vemivemiav-te ndøgo, nakhoa-te qo꞉goat, Mbumbukiam-qá manqat me꞉zømesimát. ");
INSERT INTO kvg_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Yaq ezoqa nøme, Yesu āv gembøebeváp nqǽgo, “Evézøza. Gê, ezoqa khapîmbà, tikhandī꞉z?” Yaq Yesu ndigu gezø-qavøiu, ");
INSERT INTO kvg_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Bazaføgakh ndø-asáz. Mboqog khapelavøqasi-té qazomǿ-óz. No nqazǿ-manqate. Ezoqa kopoáv, onim-qa tigoat. Geté kopømba mbaín. ");
INSERT INTO kvg_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Khoev eve mboqog to꞉tokaz, yaq zo bavokhó sozotówán, vozó-khanæmēm. Yaq zombó-viømém, ‘Evézøza. Mboqog qoní-mboqozó!’ Geté yaq ndego tendo-qavøiu, ‘No zo nø̀tenøtenák. Zo gekha manqei-âk?’ ");
INSERT INTO kvg_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Yaq zo tozombo-qavøinam, ‘Ni lou zilogám neka ibøkha zi-izumám, qo namba, neka qo niqa vemiav-te, mòqoti-nømendimám.’ ");
INSERT INTO kvg_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Geté ndego nangó genøzǿ-qavøiú, tezø-ein, ‘No zo nø̀tenøtenák. Zo khazonǿ-goam? Mòzozáv, zo manqa-zapazapa-us ezoqam ate ndøzøte꞉go.’ ");
INSERT INTO kvg_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Zo zó-eivumát, neka khaya vozó-vivisumāt, Eibleem neka Aezek neka Zekop neka Mbumbukiam-gi manqa vevezam ezoqam ate ndi꞉gu tozo-zømet, Mbumbukiam-qa Megeat Matev mokho-te tigoat, getē zo bavokhō ginø̄-nqagevēm. ");
INSERT INTO kvg_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ezoqa khøuwa fakhanam neka khøuwa sininim neka sanqa-sanqa-té gindúzáv. Yaq ndigu Mbumbukiam-qa Megeat Matev mokho-te, lou loge kandambaqape-té genǿqonáv. ");
INSERT INTO kvg_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nqáe! Ezoqa nøme, ndakin ndindopaev, ndigu gó꞉megetát. Neka nøme ndigu, nduo-megetap, ndigu gendópavát.” ");
INSERT INTO kvg_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ta khøuwa-te ndøgo, Felisi ezoqam ndozáv, Yesu vømømbō-einim, “Nqanek manqei mòqo-iváv. Viní qonǿqáv. Zapa ndǿgo, Elod qo løvøqa-qa qagó.” ");
INSERT INTO kvg_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Geté Yesu gezø-ein, “Ngenek khavozam ezoqam, Elod, āv qazømømbøé-einím nqǽgo, ‘Nqáe! No nqægo neka qasun, nqova soqøsoqa sǽngiasumít, ezoqam-qa mokho-te ndu꞉gut, neka ezoqa vǿe-khakheinøvemēt. Yaq khøuwa timønø-misika-ez, no sasae nutumúkhóu. ");
INSERT INTO kvg_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","No nakhoa até banø-geveét. Sǽmá, nqægo neka qasun neka qapunum, atema Zelusalem taon-te vøemǿ-fakhān. Zapa ndǿgo, Mbumbukiam-ge manqa vevezam ezoqam, kopømba mbaín, manqei vini-te tilaem. Zelusalem taon-te mbá giabemø-laém.’ ");
INSERT INTO kvg_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Zelusalem, Zelusalem, qo Mbumbukiam-gi manqa vevezam ezoqam pakhapakha ndoqozø-khaneam, neka nandí ndōqōtē-zītø̄gē, ndigu Mbumbukiam qo-te ndendo-khofosam, no khøuwa kopoáv, qogi ezoqam baqa amba nøzømbe-eqatám, kopømba ande av kokolok evo nduigu, nakheis gukhatobɨn, ekeza taf mokho-te vø̄-ozɨn. Geté qo gèqambo-qasi꞉vám. ");
INSERT INTO kvg_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nqáe! Zoqa khoev nqanek, ezoqam mbaín, segégoát. No nqazǿ-manqate: Zo no nango naqanøká zónømendamák. Geté ta khøuwa-te ndǿgo, sa tøzøté-nømendám, zo tozo-einim, av nqægo, ‘Mbumbukiam ngenek ezoqam bèkhakheinøvém, Evezøza-qa iz-te ngegeav!’” ");
INSERT INTO kvg_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabat khøuwa nøme, Yesu lou Felisi iz akhae ezoqam-qá khoev-té gemølóg. Yaq ndigu bøi mba mbotakém, ande gekha matev me ndǿmatanām. ");
INSERT INTO kvg_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yaq nqáe! Ezoqa tendowáv ndǿgo, Yesu-qa megemege-te vō꞉-itan. Ndego bov neka pingim gèmbo-boqotám. ");
INSERT INTO kvg_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yaq Yesu ndigu Mozes-qa guguna manqat nømendim ezoqam neka Felisi ezoqam, āv gezømbe-beváp nqǽgo, “Gê, kopømbâ, Sabat khøuwa-te ezoqa toqo-khakheinøvem, ó, khafeâp?” ");
INSERT INTO kvg_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Geté ndigu yaq qavøiwateáv. Yaq Yesu ngenek ezoqam, zenda mbøevé, vø̄khakheinøvem, sasa ndøkhofotav. ");
INSERT INTO kvg_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yaq Yesu gezø-ein, “Zonømbé-einīm. Zo nqazo-qonøve, ezoqa kopo, Sabat khøuwa-te, yo o kao ibøkha ozu-te tumbøe-van, yaq gê, ndego sa ndǿ-ivav? Āv taoká. Geté nakhamas-té genǿliváv. Até ndøgó-a, Sabat khøuwa-te tøgoat.” ");
INSERT INTO kvg_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yesu nqanek manqat ge-ein, yaq ndigu kopømba mbaín, manqat vømbøé-qavøinām. ");
INSERT INTO kvg_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu nqanek lou loge-te gegoam, yaq ezoqa tezømét ndǿgo, ndigu ezoqa kandakanda-qá qonam nonqo-té gimøqonám. Yaq Yesu yaya zø-etá, taqa yaq-te, gezø-ein, ");
INSERT INTO kvg_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Qo ezoqa sakhei etoam lou loge-te tekhatoq, yaq ezoqa kandakanda-qa qonam nonqo-te ndòqo᷄m. Soqaín ndøgo, ezoqa iz-akhae-qape tendowav, ");
INSERT INTO kvg_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","yaq ndego ezoqam, ma qo ge꞉khatoq, teqa-ein, ‘Qoqa qonam nonqo, ngēnek qombō-etoām,’ yaq qo mivi voqóndāp, khokho ezoqam-qa qonam nonqo-te sasa qomǿqōm. ");
INSERT INTO kvg_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Geté ezoqa lou loge-te tekhatoq, yaq khokho ezoqam-qá qonam nonqo-té qamøqóm. Yaq ndego ezoqam, qo ma ge꞉khatoq, tendówáv ndǿgo, qo vøqá-eīn, ‘Nǿfu. Nqánek qoqonǿ-qóm, ezoqa kandakanda-qa qonam nonqo-te.’ Yaq av nqægo, qoqa iz gó꞉-eqatát, ezoqa ewaqape-qa bøi-te, ndigu qo namba lou-qase-te tiqonavat.” ");
INSERT INTO kvg_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yaq Yesu manqat nøme gezø-ein, “Unimanqatín. Gekha ezoqām ndego, ekeza iz te-eqatat, teqa iz gévoatát. Neka gekha ezoqām ndego, ekeza iz tevoatat, teqa iz gó꞉-eqatát.” ");
INSERT INTO kvg_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yaq Yesu ndego ezoqam, ma lou loge-te ge꞉khato, āv gembøe-eín nqǽgo, “Qo lou loge kandambaqape toqo-khakheinam, khøuwa muin o khagus, qo ambá av nqǣgo, qogi qafuap o namba-qaniap o qakeza ezoqa nøme o gigiap eve ezoqam, ndigu khoev avønin ndiqapuate, ti-mba ndígu toqókhatōb. Av toqotegoat ndægo, yaq ndigu qo até tiqá lou loge-té-a, segé-khatoqabém. Yaq qoqa yaq-fia sa ndǿgo tøqágoát. Yaq-fia nøme mbaín. ");
INSERT INTO kvg_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Geté lou loge toqo-khakheinam, yaq gigiap-av ezoqam neka bov o pingim soqøsoqa ezoqam neka kagi ezoqam neka bøi waev mbain ezoqam qókhatób. ");
INSERT INTO kvg_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Av toqotegoat ndægo, qo kopømbá, khanakhanákh. Zapa ndǿgo, ndigu kopømba mbaín vøqambé-qavøinām. Geté yaq-fia ndǿgo toqomǿndáp, ezoqa eqeieqei løvøte-te tindusuz.” ");
INSERT INTO kvg_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ezoqa nøme, ndego lou namba gi꞉logat, nqanek manqat ge-ewag, yaq ndego Yesu āv gembøe-eín nqǽgo, “Ezoqa khanakhanakh mbá giabitigú, ndigu Mbumbukiam-qa Megeat Matev mokho-te, lou loge kandambaqape-te ndøgo, lou timølog.” ");
INSERT INTO kvg_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Geté yaq Yesu gembo-qavøiu, “Unimanqatín. Geté qoté-ewāg, nqanek emanqat: Ezoqa mø̀ndøgoám. Ndego lou loge kandambaqape ndøkhakheinám. Yaq ndego ezoqa kopoáv gezø-akhayam, teqa lou loge-te tinduzav. ");
INSERT INTO kvg_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Yaq lou loge khøuwa qamø-khantaz, ndego tege sasae ezoqam ndøkhofotáv, ti-te ndigu, vømøzø̄-ein, ‘Mòzotøndozáv. Lou mø̀ndømu-khakheinám.’ ");
INSERT INTO kvg_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Geté ndigu ezoqa ewaqape, tanakh manqat mbo-einím. Kopømba mbaín vøndézāv. Nøme ndego gendo-ein, ‘No manqei nowí. Yaq bàmønáv, bamø̄qeiv. Tanakhambá. Kopømba mbaín, vøtøndénāv.’ ");
INSERT INTO kvg_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ezoqa nøme ndego gendo-ein, ‘No kao nowí. Ate gi꞉goam tén. Avøe manqei khayam nonqó. Yaq ndakin nømé-khamasím. Tanakhambá. Kopømba mbaín, vøtøndénāv.’ ");
INSERT INTO kvg_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ezoqa nøme gendo-ein, ‘No sævam no-okɨ́. Yaq kopømba mbaín, vøtøndénāv.’ ");
INSERT INTO kvg_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Yaq ndego sasae ezoqam gèndoveséz, ekeza kawa ezoqam, manqat vømømbō-ein. Ngenek nqanek manqat ge-ewag, yaq qaqa ndøgó, ekeza sasae ezoqam vømbō-ein, ‘Ság. Nakhoa kandakanda neka khasøkhasis-té soqóqáv, taon-te ndøgo. Nakhamas-té. Yaq gigiap-av ezoqam neka bov o pingim soqøsoqa ezoqam neka bøi waev mbain ezoqam neka kagi ezoqam qotøndó-khatób, voqotøndó-itūb.’ ");
INSERT INTO kvg_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Yaq ndego sasae ezoqam matev gumugu, av kawa ezoqam gembøe-ein, nango vøndōqavan, yaq āv gembøe-eín nqǽgo, ‘Káwa ezoqam. No ezoqa mø̀tøndo-khatób, av manqat qoqonømbe-ein ndægo. Geté qonam nonqo nøme, ndøløvûzáp.’ ");
INSERT INTO kvg_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Yaq kawa ezoqam gembo-qavøiu, ‘Taon bavokhó qonǿqáv, ta nakhoa vinivinimba-te ndo꞉go. Yaq ezoqa qomøzǿ-pouwá. Bètøndozáv. Noqa khoev-te, ùni betetøváb. ");
INSERT INTO kvg_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","No nqazǿ-manqate: Ndigu ezoqam, no bugukhokhof qazø-akha, qazømbo-qasi, ndigu ezoqa kopo, noqa lou loge kandambaqape-te, gemǿ-onák.’” ");
INSERT INTO kvg_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Khøuwa nøme, ezoqa bawan-qape kandambá, Yesu namba nakhoa-te gi-apat. Yaq ndego tènøqambún ndǿgo, ndigu gimbopavam, vøzø̄-ein, ");
INSERT INTO kvg_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Gekha ezoqām ndego, no-te tendowav, gete ndego ekeza eve neka evo neka zas neka nakheis neka namba-qaniap sanqabeav tøgoat neka atē ekeza yagé-a, sanqaweav vǿgoāt, ndego kopømba mbaín, noge paev ezoqam tegoat. ");
INSERT INTO kvg_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Neka gekha ezoqām ndego, ekeza tae mutui eqawateav tøgoat, no vønøndó-paēv, ndego kopømba mbaín, noge paev ezoqam tegoat. ");
INSERT INTO kvg_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Gèmbo-mataváp. Zo ezoqa kopo, khoev eqawat-qape weve-qa tegoat, ndego bugukhokhof bètøkho-matøvém, av nqægo, taqa fia gekhâm, até vømúkhōu. ");
INSERT INTO kvg_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Soqaín ndøgo, ndego sement mba tezav o uk mba te-asaz, yaq ndego kopømba mbain tøgoat, khoev sasae ate ndægo temøkhou, zapa ndø̄go, moni mbaīn. Av tægoat ndægo, yaq ezoqa ewaqape, khoev timbo-qeivimat, gévøngi꞉namát, ");
INSERT INTO kvg_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","sasa ndǿ-einimāt, av nqægo, ‘Ngenek ezoqam khoev sasae amba me꞉ngáz. Geté kopømba mbaín, vǿekhōu.’ ");
INSERT INTO kvg_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Neka nøme nqánek: Kawa ezoqam tegoat, yaq ndego tegi nakhag ezoqam ten taosen namba, nakhag gone-qa tegoat, kawa ezoqa nøme namba, ndego nakhag ezoqam tuenti taosen ndimbugu, yaq ndego bètøkhæqóm, vǿmatøvēm, av nqægo, teqa khagua pemé-eqā, penømakhaya. ");
INSERT INTO kvg_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Geté teqeiv av nqægo, kopømba mbaīn, yaq ndego u-anim bekhofotáz, kawa ezoqa nøme-te, ndego ate av-té qambaqape te꞉goat. Yaq ndigu sambi manqat manqate-qa bemømbo-viømém.” ");
INSERT INTO kvg_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yesu nqanek yaya etæ manqat qamømbøe-navøem, yaq āv gezømbe-eín nqǽgo, “Zó-a, kopó. Gekha ezoqām ndego, ekeza gigiap ate ndægo, zita wuøeav tegoat, ndego kopømba mbaín, noge paev ezoqam tegoat.” ");
INSERT INTO kvg_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yaq Yesu manqat nøme gezø-ein, “Ngalam gigiap qanimáv. Geté mokhov tømømbo-navøem, yaq nqawa áv kiní-ngalam-mokho-mba-ēz? ");
INSERT INTO kvg_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ngalam av ngi꞉gu, mokho mbaín. Até ndøgó-a, manqei namba toqote-qambua, avøe ewa etoam nonqo, kopømba mbaín. Soqó-ogizó. Gekha ezoqām ndego, gea tømbogoat neka yoge kopømba vømbógoāt, yà beyogé!” ");
INSERT INTO kvg_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Khøuwa nøme, teks moni upøgim ezoqam neka manqa-zapa-us ezoqam kopoáv, Yesu-te gindupindam. Manqat yoge-qa mbozáv. ");
INSERT INTO kvg_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Yaq Felisi ezoqam neka Mozes-qa guguna manqat nømendim ezoqam, Yesu manqa mbogeveém, gi-einim, “Ngenek gekha zapâ, manqa-zapa-us ezoqam namba ndi꞉tøkuat neka lou namba ndi꞉loge?” ");
INSERT INTO kvg_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yaq Yesu yaya zø-etá, taqa yaq-te, gezø-ein, ");
INSERT INTO kvg_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Zo ezoqa kopo, sip wan andled timbogoat, yaq kopo gembō-ewān, yaq gê, ndego gekhā ndǿgō? Ndego ndigu nainti-nain nøme, segéziváz, ta manqei-te ndøgo, gagayag gilogatun, nøme-qa vømǿvaō, ndugu gumbo-ewan. Yaq até gembóvawét, atema vømǿ-omēt. ");
INSERT INTO kvg_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Yaq tu-omet, ndego khanakhanákh. Yaq nqanqa-té gunǿvé, ");
INSERT INTO kvg_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","sasa ndǿqanāo, vǿqavān. Yaq ndego zifuap neka ezoqa nøme, avønin timbo-puatat, tenøzǿ-akhá ndǿgo, vøzǿ-eīn, ‘Vø̀ndozáv. Khanakhanakh zígoném, no namba. Zapa ndǿgo, sip kopo qanømbo-navupam, mø̀e-omét.’ ");
INSERT INTO kvg_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","No nqazǿ-manqate: Yan-te nqo꞉go, matev até kopó. Khanakhanakh ndøgo, tindapem, manqa-zapa-us ezoqa kopo, Mbumbukiam-te teqambun, ndøgo gemǿ-løvuám, av khanakhanakh ndøgo, ezoqa eqeieqei nainti-nain-qa yaq-te tøzømbe-goat, ndigu ndimatavap, ni kopømbaqapē Mbumbukiam-te qambuniav tøgoat.” ");
INSERT INTO kvg_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yaq Yesu yaya nøme gezø-eta, gezø-ein, “Sæva moni mokho ten timbogoat, yaq kopo gembō-nasinīm, yaq gekhā ndǿgō? Ndugu lampa ndǿmág, khoev vǿviayām. Yaq unimé꞉-vawét, atema vømǿzømēt. ");
INSERT INTO kvg_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Yaq moni mokho tuzømet, zifuap neka ezoqa nøme, avønin timbo-puatat, tunøzǿ-akhá ndǿgo, vøzǿ-eīn, ‘Vø̀ndozáv. Khanakhanakh zígoném, no namba. Zapa ndǿgo, moni mokho ndigu, ginø-nasiniapam, nango mø̀ezømét.’ ");
INSERT INTO kvg_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","No nqazǿ-manqate: Manqa-zapa-us ezoqa kopo, Mbumbukiam-te geqambunin, yaq Mbumbukiam-gi enzol ezoqam, até kopó, khanakhanakh āv tini-gonemɨ́n.” ");
INSERT INTO kvg_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yaq Yesu yaya nøme zø-etá, gezø-ein, “Ezoqa kopo mø̀ndøgoám. Nakhei angana menás gimbogoam. ");
INSERT INTO kvg_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yaq khøuwa nøme, yo okho-qase até gendego, eve vømbō-ein, ‘Tát! Gigiap ndøgo, no ata namba toqoni-etoam, qo toqo-lawaqape-eq, no é-moqonømbe-etoám ndakin.’ Yaq eve até gendego, ekeza gigiap ate ndægo, livin-mbá gunumu-qatatát, nakhei menas vøzø̄-etoam. ");
INSERT INTO kvg_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Khapé outøpøteáv, yaq okho-qase ekeza gigiap gèwí. Yaq manqei nøme-té genøwáv. Qámbá. Yaq tegi moni, khokho matev-té genø-nqagivemát. ");
INSERT INTO kvg_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Yaq moni até gi꞉goam gumukhoub, vikia seke ndøfakhán, ta manqei-te ndøgo, yaq ndego lou mbaimbai vømbōpa. ");
INSERT INTO kvg_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yaq ndego mo-manqei-anim ezoqam tøke-qa gemboviam, ndego bøsi nen-té genø-khofotumám, lou vømøzø̄-etoamɨn. ");
INSERT INTO kvg_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Yaq ndego ifi kandambá qambo-vinumam. Geté ezoqa lou etoumáv. Yaq ndego bøsik-qá lou soqaqape loge-qa mbogoám. ");
INSERT INTO kvg_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Yaq matavap eqeieqei qamøndæ-vesez, ndego ekeza manqat āv gene-eín nqǽgo, ‘Tat-gi sasae ezoqam ate ndi꞉gu, ndigu lou kopoáv ndiloge. Geté no, nòpotonám. No avønín nǿnaním. ");
INSERT INTO kvg_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ság! Manqei nqanek, nǿ-iváv. Yaq tat-té qatǿqaván. No āv qamømbó-eín nqǽgo, “Tát! No manqa-zapa nogó, Mbumbukiam-te neka qo-te. ");
INSERT INTO kvg_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","No ezoqa eqeieqeí mbá, qoge yo sekemba tægoat. Ság. No qoge sasae ezoqam mba nógoát.” ’ ");
INSERT INTO kvg_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yaq ndego até gendego, ta manqei ndøgo gè-iváv, eve-te sasa ndøwav. Ndego qambaqape, ambá genegeavún. Yaq eve sège-omét. Yaq tanakh mbogó. Yaq até gendego, tenøvuáo ndǿgo, yo vømø̄-møvøiu, sasa ndøngenøtam. ");
INSERT INTO kvg_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Yaq yo gembo-ein, ‘Tát! No manqa-zapa nogó, Mbumbukiam-te neka qo-te. No ezoqa eqeieqeí mbá, qoge yo sekemba tægoat.’ ");
INSERT INTO kvg_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Geté eve ekeza sasae ezoqam zø-akhá, gezø-ein, ‘Nakhama ndøgó! Ndabua eqeieqei zotøndó-upøném, vozombó-uzømēm, neka kokosov-te mbimak khapelavøqasi vozombó-utøzēm neka tamak vozombó-uzømēm. ");
INSERT INTO kvg_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kao-yu enaq-us vø̀ndolaém. Yaq lou zílóg. Khanakhanakh-qape zígoném. ");
INSERT INTO kvg_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Zapa ndǿgo, noge yo, andé genaním. Geté ndakin, mø̀ndø-khandí꞉v. Ndego gò꞉navupám. Geté ndakin, mø̀ndø-fakhán.’ Yaq lou loge ndøngazém. Khanakhanakh kandambá gigonem. ");
INSERT INTO kvg_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ta khøuwa-te ndøgo, yo-khøuwa, khae-té gegoám. Yaq nango gendoqavan, khoev ge꞉khatoat, ndego ouv qaqayam ndø-ewág, ezoqa gi-ogimat. ");
INSERT INTO kvg_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Yaq ndego sasae ezoqam mbo-akhá, gembobevap, ‘Gekhā ndǿgo, manqa khape qæfeaz?’ ");
INSERT INTO kvg_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yaq ndego sasae ezoqam gembo-qavøiu, ‘Qaveqase ndoqaván. Yaq qave, kao-yu enaq-us ndølaváo. Zapa ndǿgo, ndego khanakhanakh kandambá, ge-omet av nqægo, te-te matev-qase nøme fakhaneav qagoam, gefakhan.’ ");
INSERT INTO kvg_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Geté ndego zapikia, nqanek manqat ge-ewag, ndego qaqa ndøgó. Yaq poeveáv, lou loge-te te-on. Yaq eve ndøfakhán, onim-qa yaq-te vømømbō-pouwa. ");
INSERT INTO kvg_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Geté ndego yo-khøuwa, eve gembo-qavøiu, ‘Nqáe! No viav kopoáv, sasae nqataqago. Neka no qoqa manqat nqagimáv. Geté qo até naningus-yu kopó-a, etopøteáv no-te, yaq nogi nøfuand namba khanakhanakh vøtígonēm. ");
INSERT INTO kvg_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Geté nandev qoge yo gendoqavan, ndego qogi moni ate ndi꞉gu mambe sakheis-te go꞉ngiæzo, yaq qo até qoqotøndego, kao-yu enaq-us voqombō-lavao.’ ");
INSERT INTO kvg_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Yaq eve gendo-ein, ‘Áti. Qo no namba oskia qogó. Neka gigiap ate nqanømbe꞉go, ndøgo qoqá. ");
INSERT INTO kvg_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Geté ni lou ùni bizilóg neka khanakhanakh binī-asøtav. Zapa ndǿgo, qoge qaveqase, andé genaním. Geté nango mø̀ndø-khandí꞉v. Ndego gò꞉navupám. Geté ndakin, mø̀ndø-fakhán.’” ");
INSERT INTO kvg_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yaq Yesu ekeza paev ezoqam, emanqát nøme zøvotót, gezø-ein, “Qàgoám. Ezoqa mø̀ndøgoám. Gigiap kopoav ezoqám. Neka ndego sasae ezoqam vømbōgoam. Gigiap ate qægoam, ndégo tembøe-kawaevtám. Geté khøuwa nøme, ndego gigiap eve ezoqam, āv gene-ewág nqǽgo: Tege sasae ezoqam, moni mbongiæzøtét. ");
INSERT INTO kvg_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Yaq gigiap eve ezoqam, até gendego, ndego gigiap keoge ezoqam vømbō-akha, gembo-ein, ‘Gê, gekhâ ndøgo, qoqa moni ngiæzoat matev-qa yaq-te, manqat nqæyoge? Ság! Emanqat qópeawám, nogi moni ande āv khoqombøē-kewagam. Zapa ndǿgo, qo kopømba mbaín, noge gigiap keoge ezoqam, sekemba toqogoat.’ ");
INSERT INTO kvg_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yaq ndego gigiap keoge ezoqam, ekeza manqat ge-ein. ‘Áv khatégō? Noge kawa gékhofonó, sasae-te. No bazaføgakh mbaín, manqei ozam sasae tægo. Neka no miví, ezoqa gigiap-qa vøzømbé-vi꞉māt. ");
INSERT INTO kvg_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ság. No ndakin mø̀tenøtén, ande gekha matev me nøtégō. Yaq sasae-te tækhofon, no ezoqa ekeza khoev-té ginǿ-khatombém.’ ");
INSERT INTO kvg_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Yaq ndego até gendego, ezoqa ewaqape, ndigu tege kawa-te gigiap qazømbo-løfokam, vøzø̄-akhayam. Yaq ndego ezoqam, bugukhokhof gendowav, āv gembøe-eín nqǽgo, ‘Qo noge kawa-te, gigiap ate qægoam gekhâm nandaqambo-løfoke?’ ");
INSERT INTO kvg_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yaq ndego ezoqam gendo-qavøiu, ‘No te-te oil yakhav wan andléd, nqanømbo-løfoke.’ Yaq ndego gigiap keoge ezoqam gendo-ein, ‘Ság. Pepa taqa yaq-te gipeaomem, nqánek. Gèqóm. Yaq yakhav fifti mba qotó-peawám. Nakhamas-té.’ ");
INSERT INTO kvg_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Yaq ndego gigiap keoge ezoqam, ezoqa nøme gembobevap, ‘Gebâ qo. Qo noge kawa-te, gigiap ate qægoam gekhâm nandaqambo-løfoke?’ Yaq ndego ezoqam gembo-qavøiu, ‘No te-te flawa pus wan taosén, nqanømbo-løfoke.’ Yaq ndego gigiap keoge ezoqam gembo-ein, ‘Pepa taqa yaq-te gipeaomem, nqánek. Ság! Eit andled mba qotó-peawám.’ ");
INSERT INTO kvg_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Yaq vaev-te, ndego gigiap kopoav ezoqam, tege keoge ezoqam-qa manqat ge-ewag, av khavozam matev ge꞉matanam, yaq ndego teqa iz gè-eqá. Zapa ndǿgo, teqa matavap loloákh.” Yaq Yesu taqa yaq-te, āv gezømbe-eín nqǽgo, “Unimanqatín. Manqei-qape ezoqa soqøsoqa, yaqyaq-a matev gimatønumatun, tiqa matavap loloakh mø̀ndøløvú, ndigu ezoqa nøme-qa matavap, ndigu waev-te ndiyage. ");
INSERT INTO kvg_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Geté no nqazǿ-manqate. Manqei-qape ezoqam, moni manqa-zapazapa nonqo ndø-abumatún. Geté zo ezoqá nøme zozømbé-tøké. Yaq ndigu zogi zøfuap ndǿgoát. Yaq vaev ndøgo, moni khatibam matev tømø-navøem, Mbumbukiam zo ekeza khoev miavmiav-té genǿ-upøzó.” ");
INSERT INTO kvg_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Yaq Yesu manqat nøme ge꞉zømas, gezø-ein, “Gekha ezoqām ndego, ezoqam-qa gigiap khapelavøqase, eqeieqei tembo-kewagat, ndego até gigiap kandambaqapé-a, eqeieqei mbókewagát. Geté gekha ezoqām ndego, ezoqam-qa gigiap khapelavøqase, keoge eqeieqei mbain tøgoat, ndego até gigiap kandambaqapé-a, keoge eqeieqei gembógoák. ");
INSERT INTO kvg_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yaq nakémbá, zo manqei-qape moni keoge eqeieqei gonemav tøgoat, ge zô ndozo-matavap, zo Mbumbukiam unimanqatin gigiap ndøzǿ-etoam, tozombo-kewagat? Āv taoká. ");
INSERT INTO kvg_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Neka gê, zo ezoqa nøme-qa gigiap keoge eqeieqei gonemav tøgoat, zo Mbumbukiam zøkeza gigiap ndøzǿ-etoam? Mbaín.” ");
INSERT INTO kvg_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Sasae ezoqa kopømba mbaín, kawa ezoqa menas timbogoat, tezø-sasaetat. Kawa ezoqa menas timbogoat, yaq nøme ndego, gembó-pøovát. Geté nøme ndego, gembøé-qasi꞉vát. Nøme ndego, teqa manqat o-mba mbøéndapát. Geté nøme ndego, teqa manqat gembó-sanqawát. Yaq até zó-a. Zo kopømba mbaín, Mbumbukiam-qa mokho-te neka moni-qa mokho-te sa tozotumu-goat.” ");
INSERT INTO kvg_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yaq Felisi ezoqam, nqanek manqat giyogem, moni-qa yaq-te, ndigu Yesu gèvøngi꞉nám. Zapa ndǿgo, ndigu moni-te poev zøgoám. ");
INSERT INTO kvg_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yaq Yesu gezø-ein, “Zo ezoqam-qa bøi-te, zoqa matev bugug eqeieqei keoge-qa zøgó. Geté Mbumbukiam, zoqa mbøni mø̀ndæ-otév. Matev nøme ndøgo, ezoqa eqeieqei ndivewe, ndøgo Mbumbukiam-qa bøi-te soqaqapé.” ");
INSERT INTO kvg_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yaq Yesu manqat nøme gezø-ein, “Zion gefakhan, ndego ibøkha iz etoam ezoqam, yaq ndakin Mozes-qa guguna manqat-gi khøuwa neka Mbumbukiam-gi manqa vevezam ezoqam-gi khøuwa, mø̀ndømø-nasiním. Ndakin Manqat Mbomambaqape, Mbumbukiam-qa Megeat Matev-qa yaq-te ndøfakhán. Neka ezoqa ewaqape, onim-qa ndøgót. Bazaføgakh-ús. ");
INSERT INTO kvg_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Geté unimanqatín. Yan neka manqei-qape, kopømbá, tømø-navøem. Geté Mbumbukiam-qa guguna manqat mokho-te, peawap-qase gemǿ-navøemák. ");
INSERT INTO kvg_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Khamasim, nqánek: Gekha ezoqām ndego, sævam te-ivav, yaq sævam vini vǿ-okɨ̄, ndego nøkenøkem matev ndǿngiú neka mambe mé꞉wáv. Neka gekha ezoqām ndego, sævam tu-okɨ, ezoqa nøme ge-ivav, até ndegó-a, mambe mé꞉wáv tu namba neka nøkenøkem matev vǿngiū.” ");
INSERT INTO kvg_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yaq Yesu emanqát nøme zøvotót, gezø-ein, “Qàgoám. Ezoqa mø̀ndøgoám. Gigiap kopoav ezoqám. Ndabua eqeieqei fia kandakanda ndø-uzumám neka yage eqeieqei-te vø̄yagam. ");
INSERT INTO kvg_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tegi mboqog bavokho ndøgo, gigiap-av ezoqam ndøveém. Teqa kha ate qægoam, saté nqama-nqamav. Iz nqambógo, Lazalés. ");
INSERT INTO kvg_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ndego lou khakhayakh loge-qa mbogoám, ndøgo gigiap eve-qa lou-qase-te qando-pomovam. Yaq gaqo ndozavɨ́n, nqamav vømbō-venegomemɨn. ");
INSERT INTO kvg_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Yaq Lazales gènaním. Yaq enzol ezoqam, Eibleem-té ginø-eqeinám, teqa avønin-te vømø̄qom. Yaq vaev até ndegó-a, gigiap eve ezoqam, vø̄nanim, neka ezoqa vømø̄-otøvem. ");
INSERT INTO kvg_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Yaq ndego løvøte ezoqam-qa manqei-te gemøfakhan ndøgo, bøi ge-eqa, nqosøgeap kandambaqape gembo-ewagam, Eibleem mba mo꞉-omét. Lazales namba me꞉qonavám. Qámbá. ");
INSERT INTO kvg_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Yaq sège-akhá, ‘Atákha. Éibleem. No tanakh gènøgó. Lazales qotøndó-khofotáv. Kokosov kopo ibøkha-té genǿ-qoqomáz, noge sas vǿkhantāv, vǿvamēv. Zapa ndǿgo, no nqanek gøina wageap-te nqægo, nqosøgeap khàpe nømbe-khouwév.’ ");
INSERT INTO kvg_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Geté Eibleem āv gembøe-eín nqǽgo, ‘Nǿzeø. Gèmbo-mataváp. Qo qoqoyagam, qo gigiap qaniqanimáv qaqagoam. Geté Lazales gigiap soqøsoqá geneyagám. Geté ndakin ngenek yage qanimav-qape ndøndapét. Geté qo nqosøgeap-qape qondapét. ");
INSERT INTO kvg_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Neka nøme nqánek: Yaq qo-a, yaq ni, manqei ozu khavoe-qape nqǿugu. Neka gekha ezoqām ndigu, nqanek ngiyage, qo-te okho-qa ndigu, kopømba mbaín. Neka gekha ezoqām ndigu, nandav nandiyage, kopømba mbaín, ni-te tinduzav.’ ");
INSERT INTO kvg_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Yaq ndego gigiap kopoav ezoqam gendo-ein, ‘Atákha. Av tægoat ndægo. Nøtaqá-viám. Lazales nogé tat-qá khoev-té qonǿ-khofotáv. ");
INSERT INTO kvg_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","No namba qatifakhan, fáev ate gi꞉goam. Yaq Lazales bèwáv, bemøzø̄-ein, tiqa matev bè-enénd. Soqaín ndøgo, até ndigú-a, nqanek nqosøgeap manqei-te tinduzav.’ ");
INSERT INTO kvg_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Geté yaq Eibleem gembo-qavøiu, ‘Qogi namba-qaniap, nømendim manqat ndøzø̂gó, Mozes neka Mbumbukiam-gi manqa vevezam ezoqam gipeaomem. Yaq tìabembo-pavét ndøgo, av ndigu gi꞉peaomem.’ ");
INSERT INTO kvg_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Yaq ndego gigiap kopoav ezoqam gendo-ein, ‘Atákha. Éibleem. Āv taoká. Geté ezoqa kopo løvøte-te tendosuzam, manqat vøzǿ-eīn, ndigu ndø̀qambúz.’ ");
INSERT INTO kvg_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Geté yaq Eibleem gembo-qavøiu, ‘Ndigu Mozes neka Mbumbukiam-gi manqa vevezam ezoqam-qa manqat yogeav tøgoat, yaq até ndøgó-a, ezoqa løvøte-te tendosuzam, ndigu teqa manqat yogeav āv tinígoát.’” ");
INSERT INTO kvg_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yaq Yesu ekeza paev ezoqam gezø-ein, “Matev vinivinimba ndø̀fakhanám, ndøgo ezoqa manqa-zapazapa-te tø-itubat. Geté ndego ezoqam, mø̀ndø-soqoév, ndego matev av nqægo tematønumat, ndøgo ezoqa nøme manqa-zapazapa-te tø-itub. ");
INSERT INTO kvg_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ezoqa av nge꞉go, amba nandi-qape monqo-te timbo-møpøtøzemɨn, kewan-te sasa mø-oginamɨn, vømø̄-geonɨn, ndøgo ambá qanimáv. Geté soqain ndǿgo, ndego nginik ezoqa khasøkhasis manqa-zapa-te te-itub. ");
INSERT INTO kvg_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yaq nakémbá. Aiyá qagó.” Yaq Yesu manqat nøme gezø-ein, “Klisten ezoqa nøme, manqa-zapa tematanam, yaq qógugú. Yaq ndego tematøvem, av nqægo, ‘Unimanqatīn. No manqa-zapa nogō.’ Yaq qo teqa manqa-zapa, sà betaqambo-navøém. ");
INSERT INTO kvg_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Até ndøgó-a, ezoqa khøuwa kopo-te, matev soqøsoqa seven tematønumit qo-te, neka tanakh manqat seven vøqá-manqatēt, yaq qo teqa manqa-zapazapa, até sa betaqambo-navøemát.” ");
INSERT INTO kvg_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yaq Evezøza-gi u-anim gimbo-einim, “Niqa unimanqatin vø̀nifitám.” ");
INSERT INTO kvg_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yaq Yesu gezø-qavøiu, “Unimanqatín. Até ndøgó-a, zoqa unimanqatin khapelavøqase mba tøgoat, kopømba ande av masted tae nanga-qasi ndi꞉gu, zo kopømbá, nqanek tae-qape sozombó-einím, ‘Vø̀khofóq. Yaq ndaola-té qoqomǿ-itán.’ Yaq tae nqanek, zoqa manqat o-mba zømbóndáp.” ");
INSERT INTO kvg_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yaq Yesu yaya zø-etá, gezø-ein, “Zo ezoqa nøme, sasae ezoqa teqagoat, ndego khae-te teqa-sasaetat o sip tezø-kewagat, yaq ndego sasae manqei-te gendo-qavanɨn, gê, qo moqombó-einin, av nqægo, ‘Mòqotøndo-óq. Gèqóm. No namba lou zílóg’? ");
INSERT INTO kvg_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Āv taoká. Geté qo ndego āv qoqombøe-einín nqǽgo, ‘Noqa lou vø̀khætá, vø̄khakheinam, voqó-yogīm. Yaq no lou loge neka ibøkha izam tønømbu-navøem, qo qakeza lou ndǿgo toqonǿlóg.’ ");
INSERT INTO kvg_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yaq ndego sasae ezoqam, nqanek sasae qamømbøe-navøemɨn, yaq gê, qo ike manqat qombó-einin, ndego qoqa manqat o-mba geqambo-ndap? Āv taoká.” ");
INSERT INTO kvg_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Yaq Yesu taqa yaq-te gezø-ein, “Zo até kopó. Zo matev ate ndægo tozotumu-gonem, av Mbumbukiam gezømbe-ein, yaq zo sa nqánek qazó-einím, ‘Ni khokho sasae ezoqam mbá. Ni satø ndǿgo teigoném, av Mbumbukiam manqat ginimbi-ein.’” ");
INSERT INTO kvg_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu Zelusalem taon-te gemat, yaq æ tunumát, e Samalia manqei-a, e Gelili plovins. ");
INSERT INTO kvg_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Yesu vemiav nøme-te ge-onat, yaq kha sisi-us ezoqam ndozáv. Tén ate gi꞉goam. Yaq ndigu qambaqapé segendowán. ");
INSERT INTO kvg_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Yaq ndigu kandambaqape segendo-akhaém, “Yésu. Káwa ezoqam. Ni tanakh gìnigú.” ");
INSERT INTO kvg_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu ndigu ezoqam gezømet, yaq āv gezømbe-eín nqǽgo, “Mbumbukiam-gí iziz ezoqam-té qazonǿzáv, bemø̄zømet.” Yaq ndigu ezoqam ten ate av-té gi꞉-apat, kha sisi sègezømbo-navøemtát. ");
INSERT INTO kvg_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yaq ndigu ezoqa kopo ge꞉-otev av nqægo, kha sisi mø̀ndønø-navøēm, ndego nangó genøveséz, Yesu-te. Mbumbukiam-qa iz, até go꞉-eqatát. Kandakandá møndæ-akhayám. ");
INSERT INTO kvg_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yaq ndego Yesu-qa zenda tokhotapak-qa megemege-te, katuk ndømøkuí, ike manqat vømbō-ein. Ndego ezoqam, bawan vini-ák. Samalia ezoqám. ");
INSERT INTO kvg_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu ngenek ezoqam ge-omet, yaq āv gene-eín nqǽgo, “Ezoqa ate gi꞉goam tén, kha sisi-us gigoam, gi-eqeieqei-ez. Gemâ ndigu ezoqa nain nøme, kinǿqapi? ");
INSERT INTO kvg_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Gê, ezoqa nøme, ambá gēmatøvemem, av nqægo, ni bànivesēz, Mbumbukiam-qa iz bamū-eqanem? Gê, ezoqa sa ngénèk, manqei vini-ak?” ");
INSERT INTO kvg_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yaq Yesu ndego ezoqam gembo-ein, “Qoté-itān. Mòqoqáv. Qoqa unimanqatin nandav, tø̀khakheinøqavém.” ");
INSERT INTO kvg_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Khøuwa nøme, Felisi ezoqam Yesu gimbo-bevøpem, Mbumbukiam-qa Megeat Matev gekha khøuwā qanéfakhān, yaq ndego āv gezømbe-qavøiú nqǽgo, “Mbumbukiam-qa Megeat Matev tøfakhan, yaq kopømba mbaín, toqoqeiv, av gigiap o matev nøme ndoqote-qeivi. ");
INSERT INTO kvg_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ezoqa kopømba mbaín, ti-einim av nqægo, ‘Nqáe! Mbumbukiam-qa Megeat Matev nqánek,’ ó, ‘Ndǽ! Mbumbukiam-qa Megeat Matev ndǿgo.’ Zapa ndǿgo, Mbumbukiam-qa Megeat Matev, zo mokho-té qanu꞉gú.” ");
INSERT INTO kvg_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yaq Yesu ekeza paev ezoqam gezø-ein, “Khøuwa ndø̀mø-fakház. Yaq zo Ezoqam-gé Yo-gi khøuwa kopo zømete-qa zógoát. Geté zo zózømetamák. ");
INSERT INTO kvg_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ezoqa zo āv gizømbé-manqatát nqǽgo, ‘Ndǽ! Keliso ndégo, yaq manqei,’ ó, ‘Nqáe! Keliso ngégo.’ Geté zo ndø̀za᷄v, neka ndigu zø̀pa᷄ev, tizav. ");
INSERT INTO kvg_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Zapa ndǿgo, ta khøuwa-te ndøgo, Ezoqam-ge Yo tegeav, ndego nakhamas-té gendó-fakhán. Andé ndand mé꞉vøiyám, ndøgo yan-qape sa tumukhazet. ");
INSERT INTO kvg_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Geté bugukhokhof, ndego nqosøgeap kandambaqape bètøkho-ndáp neka ezoqa ndakin ngiyage, bēsanqawem. ");
INSERT INTO kvg_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ezoqam-ge Yo nango tegeav, matev āv tønégoát, av Noa-qa khøuwa qægoam. ");
INSERT INTO kvg_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ta khøuwa-te ndøgo, ezoqa lou loge zøgoupám, ibøkha izam vøzø̄-goupam, neka sakhei vø̄zøkɨmam-a, vø̄-etoumam. Yaq matev até gemát, atema Noa khagua-qape-te vø̄u-on, khøuwat-qape vøndōwav, ezoqa ewaqape vø̄ngiæzo. ");
INSERT INTO kvg_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Yaq até Lot-qá khøuwa-té-a, matev até kopó, āv tønegoám. Ezoqa lou loge zøgoupám, ibøkha izam vø̄zø-goupam, gigiap vø̄wiam, neka avøe gigiap vø̄-ogeakham, neka khoev vø̄puanemam. ");
INSERT INTO kvg_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Geté ta khøuwa-te ndøgo, Lot Sodom taon ge꞉-ivav, gewav, gøinam neka nandi wagøvap-us ndø-o꞉áz. Andé qæ me me꞉lanqá, ezoqa ewaqape vø̄ngiæzo. ");
INSERT INTO kvg_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Yaq matev kopo, āv tønéfakhán, Ezoqam-ge Yo tendoveao, tendoqavan. ");
INSERT INTO kvg_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ta khøuwa-te ndøgo, gekha ezoqām ndego, khoev ova to꞉yat, ndego khoev mokho-te bè-o᷄n, gigiap vømøndó-upā. Neka gekha ezoqām ndego, khae-te tesasaetet, ndego khoev-te nango bevèse᷄z. ");
INSERT INTO kvg_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot-gu zas gèmbo-mataváp, ndugu andē gekha matev me mbø̄efakhan. ");
INSERT INTO kvg_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Gekha ezoqām ndego, ekeza yage geawat-qa tegoat, ndego ndæ̀khambuá. Geté gekha ezoqām ndego, ekeza yage te꞉khambua, ndego ndø̀møqeív. ");
INSERT INTO kvg_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","No nqazǿ-manqate: Ta lova ndøgo, ezoqa menas venanqei nonqo kopo-te tisømbiit, yaq Mbumbukiam kopo ndø̀ndáf. Geté nøme, segé-iváv. ");
INSERT INTO kvg_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Neka sakhei menas, flawa timivisumit, nømu ndugu, Mbumbukiam ndø̀ndáf. Geté nømu ndugu, segé-iváv.” ");
INSERT INTO kvg_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yesu-gi paev ezoqam, nqanek manqat giyogem, yaq āv gimbøe-bevøpém nqǽgo, “Evézøza. Nqanek matev, gekha manqei-té qamǿfakhān?” Yaq Yesu gezø-qavøiu, “Søvakha pikia ande āv kenéveāt, koe ndǿgo tinø-piaɨ́n.” ");
INSERT INTO kvg_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu ekeza paev ezoqam, yaya nøme zø-etá. Tezømbe-etá ndǿgo, ndigu bètezøtéz, Mbumbukiam-te miavmiav be-akhayám neka be-ivø̀ve᷄m. ");
INSERT INTO kvg_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yaya gezø-eta nqánek, “Vemiav nøme-te, manqa ovøyam megeat ezoqam mø̀ndøgoám. Ngenek Mbumbukiam-te møe mbaín neka ezoqam-qa yaq-te matavupáv. ");
INSERT INTO kvg_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Neka ta vemiav kopo-te ndøgo, ngæmam vø̄goam. Zivis mø̀ndømbo-naním. Ndugu ngenek manqa ovøyam ezoqam-té gunø-okhoám, manqat vømømbō-einin, av nqægo, ‘No ùni nømbetøké. Noge qaqa ezoqam, no ngiænoat-qa ndøgó.’ ");
INSERT INTO kvg_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Geté ndego manqa ovøyam megeat ezoqam, khøuwa kopoav, gèmbøe-qasi꞉vám. Geté vaev-te, ndego ekeza manqat āv gene-eín nqǽgo, ‘Ság! No Mbumbukiam-te møe mbaín neka ezoqam-qa yaq-te matavupáv. ");
INSERT INTO kvg_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Geté no gènømbo-qasí꞉v, ngunuk ngæmam sekemba ngundu-okho, khøuwa ngunø-ngiæzoat. Ság! Sæmbótøké. Soqaín ndøgo, nqanek matev sa tøma, no kha vømønǿ-føløvøēm.’” ");
INSERT INTO kvg_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yaq Evezøza nqanek emanqat gumuvotot, gezø-ein, “Ngenek manqa ovøyam megeat ezoqam, soqaqapé. Geté teqa manqat mozóyogem? ");
INSERT INTO kvg_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Yaq ge zô, ndozo-matavap, ndego ngunuk ngæmam gumbotøke, yaq Mbumbukiam, tegi ezoqam gevevesam, gezǿ-tøkeāk, neka ndigu manqa ovøyam-te, matev eqeieqei géndapemāk, ndigu te-te oskia ndi-akhayam, pavpave neka lovølova? Neka Mbumbukiam yakha ndømbóva, tezøtøke? Mbaín. ");
INSERT INTO kvg_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","No nqazǿ-manqate: Ndego ekeza ezoqam, nakhamas-té genøzǿ-tøké. Geté Ezoqam-ge Yo nango tendoqavan, gê, ndego unimanqatin ndǿqeiv?” ");
INSERT INTO kvg_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ezoqam-qa mokho-te, ndigu Yesu-qa manqat gi-ewagat, nøme ekeza kha, eqeieqei me꞉vewám. Yaq ndigu ezoqa nøme, gèsanqabám. Yaq Yesu ndigu yaya zø-etá, gezø-ein, ");
INSERT INTO kvg_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ezoqa menas mø̀ndøgoám. Nøme ndego, Felisi ezoqám. Neka nøme ndego, teks moni upøgim ezoqám. Yaq khøuwa nøme, ndigu ezoqa menas, Mbumbukiam-qá khoev-té ginø-apát. Guligulim-qa ndø-apát. ");
INSERT INTO kvg_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Yaq ndego Felisi ezoqam, sège-itán. Anøzí. Yaq āv gene-guligulím nqǽgo, ‘Ike kandambá, Mbumbukiam. Zapa ndǿgo, no āv tiuká, av ezoqa nøme soqøsoqa ndi꞉gu, ndi-aqonam neka ndi꞉khavozam neka mambe ndi꞉-okho. Neka no āv teoká, av ngenek teks moni upøgim ezoqam nge꞉go. ");
INSERT INTO kvg_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","No pula kopo-te, khøuwa menas, lou logemav matev nogoatún. Neka gigiap ate ndægo, qæ-upøgimatun, no nòqaqaɨ́n, qaqageap vømø̄-ten-ɨn, neka qatoat kopo qo vøtaqā-etoamɨn.’ ");
INSERT INTO kvg_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Geté ndego teks moni upøgim ezoqam, qambaqapé segendo-itán. Yaq geguligulim, ndego kawa eqawateáv, yan-te. Zapa ndǿgo, ndego miví. Geté ndego ekeza savim ndøtøkubám, mutøkhop vø̄-itan, sasa ndø-ein, ‘Mbumbúkiam! No tanakh gènøgó. No manqa-zapa-us ezoqám.’” ");
INSERT INTO kvg_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu nqanek yaya etæ manqat qamømbøe-navøem, yaq āv gezømbe-eín nqǽgo, “No nqazǿ-manqate: Nginik ezoqa menas khoev-te giqavaz, ezoqam ngének ge-eqeieqei-év, Mbumbukiam-qa bøi-te, vaev-te geguligulim. Ambá ndego, Felisi ezoqam. Zapa ndǿgo, gekha ezoqām ndego, ekeza iz te-eqatat, teqa iz gévoatát. Neka gekha ezoqām ndego, ekeza iz tevoatat, teqa iz gó꞉-eqatát.” ");
INSERT INTO kvg_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ezoqa nøme, Yesu-te, nakhei nqonqon ndo-itub. Ndigu mø̀ndøzøpoé, Yesu ambá zenda zømbø-awamɨ́n. Geté tegi paev ezoqam nqanek matev giqeivim, gèzømbe-khafén, ndigu ezoqam. ");
INSERT INTO kvg_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Geté Yesu ndigu nakheis, sègezø-akhá. Yaq āv gene-eín nqǽgo, “Nakheis bègeáv, no-te. Zømbo-khakhàza᷄m. Zapa ndǿgo, Mbumbukiam-qa Megeat Matev, tiqa ndígu, av nakheis ngi꞉gu. ");
INSERT INTO kvg_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","No unimanqatín nqazø-manqate. Gekha ezoqām ndego, Mbumbukiam-qa Megeat Matev khatiwiav tøgoat, av nakhei nqonqon ngi꞉gu, ndego teqa Megeat Matev mokho-te gemǿ-onák.” ");
INSERT INTO kvg_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Khøuwa nøme, megeat ezoqa nøme, Yesu āv gembøebeváp nqǽgo, “Nøméndim ezoqam mbomambaqape. No gekha matev nómatønumāt, khandi miavmiav vøténdāp?” ");
INSERT INTO kvg_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yaq Yesu gembo-qavøiu, “Gekha zapâ, no mbomambaqape ndoqote-næna? Ezoqa mbaín, mbomambaqape. Mbumbukiam mba me꞉gó. ");
INSERT INTO kvg_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Qo Mbumbukiam-qa guguna manqat mòqote-qatéq, av qæ-ein nqægo: Qo nøkenøkem matev ndøngì꞉wa᷄t. Neka ezoqa pakhapakha zøkhanèa᷄m. Neka ndø-aqòna᷄m. Neka meakha manqat ndømanqàte᷄. Qavē neka qavo, gèzøvizáp.” ");
INSERT INTO kvg_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yaq ndego ezoqam gendo-qavøiu, “Nqanek guguna manqat ate ndægo, nqæmbôpáev, no khapelavøqase qategoam, atema ndakin.” ");
INSERT INTO kvg_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu nqanek manqat ge-ewag, yaq gembo-qavøiu, “Qanimáv. Geté matev kopo nøme nqánek qoqógó. Gigiap ate nandaqambe꞉go, qówí. Yaq moni ndigu toqoqas, gigiap-av ezoqam qozǿ-etoám. Av toqotego ndægo, yaq qo gigiap qaniqanim, yan manqei-té qoqonǿ-møvøemét. Yaq vø̀ndoqáv. No qonøndó-páev.” ");
INSERT INTO kvg_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Geté ngenek ezoqam, nqanek manqat ge-ewag, ndego khanakhanakh mbaín. Avus-mba mbovoé. Zapa ndǿgo, ndego gigiap kopoáv qambogoam. ");
INSERT INTO kvg_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu ngenek ezoqam ge-omet, avus-mba qambovoe, yaq āv gene-eín nqǽgo, “Gigiap kopoav ezoqam, ti-te ndigu unimé꞉-føgákh, Mbumbukiam-qa Megeat Matev mokho-te tu꞉-oz. ");
INSERT INTO kvg_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kemol ndugu, søvakha gigiap kandambaqapu, mil nqa-te one-qa tugoat, tu-te ndugu føgakh andé mbaín, av gigiap kopoav ezoqam-te føgakh ndægo, ndego Mbumbukiam-qa Megeat Matev mokho-te one-qa tegoat.” ");
INSERT INTO kvg_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Yaq ezoqam ndigu, nqanek manqat giyogem, āv gini-bevøpém nqǽgo, “Av tægoat ndægo, yaq gekha ezoqām ndǿkhandī꞉v?” ");
INSERT INTO kvg_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yaq Yesu gezø-qavøiu, “Gekha matēv ndøgo, ezoqam-te kopømba mbain ndøgo, Mbumbukiam kopømbaqapé, segé-matanám.” ");
INSERT INTO kvg_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Yaq Pita Yesu gembo-ein, “Nqáe! Ni nikeza gigiap ate qægoam, zitá qati-wuøém, qo nqeitaqambe-paev.” ");
INSERT INTO kvg_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yaq Yesu gezø-qavøiu, “No unimanqatín nqazø-manqate. Gekha ezoqām ndego, khoev te-ivav o zas o namba-qaniap o evøndipakha o nakheis tezivaz, Mbumbukiam-qa Megeat Matev zapaya, ");
INSERT INTO kvg_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ndego Mbumbukiam, ndakin yage-te nqanek, nøme mba mbøé-etoám, kopoav-qapé, yaq megemege-te ndo꞉go, ndego khandi miavmiav vømǿndāp.” ");
INSERT INTO kvg_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu ekeza paev ezoqam tuelv, tène-itúb, vømø̄-yakhapus-mokho-mba-ez, yaq gezø-ein, “Nqáe! Ni ndakin Zelusalem taon-té qazinø-qavigít. Yaq matev ate ndægo, Mbumbukiam-gi manqa vevezam ezoqam, Ezoqam-ge Yo-qa yaq-te gi꞉peaomem, gemǿ-fakhanám. ");
INSERT INTO kvg_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ndego manqei vini-ak-qá zenda-té ginǿveém, ndigu Mbumbukiam zøtezateav ndigu. Yaq ndigu otøotam mé꞉vewém neka vǿngenøinām neka køse vømbøé-pisibømēm teqa kha-te, sasa ndǿfeomēm, vǿlaēm. ");
INSERT INTO kvg_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Geté khøuwa timømbo-misika-ez ndøgo, ndego nqawa ndø̀khandí꞉v.” ");
INSERT INTO kvg_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yesu-gi paev ezoqam, nqanek manqat giyogem, ndigu manqa mokho-qase ndapeáv. Ti-te ndigu, teqa manqat mokho mbaín. Ndigu zøtezateáv, av nqægo, Yesu gekhā mé꞉manqatam. ");
INSERT INTO kvg_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu Zeliko taon ge꞉khatoat, yaq bøi waev mbain ezoqam mø̀ndøgoám. Nakhoa keoqa-té geqotám. Ezoqa gigiap-qa zøvi꞉mát. ");
INSERT INTO kvg_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Yaq ndego ezoqa bawan-qape gezø-ewag, manqa qazøfeazat, giløvuat, yaq gèbeváp, ge-ein, “Gekhā ndǿgo?” ");
INSERT INTO kvg_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Yaq ezoqa gimbo-einim, “Yesu ndømá, ndego Nazalet vemiav-ak.” ");
INSERT INTO kvg_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ngenek bøi waev mbain ezoqam, nqanek manqat ge-ewag, yaq até gendego, sège-akhá, “Yésu. Déivid-ge Zeo. No tanakh gènøgó.” ");
INSERT INTO kvg_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Yaq ndigu ezoqam, Yesu-qa megemege-te go꞉-apat, gèguguím, gimbo-einim, “Qo manqat tía.” Geté ndego kandakanda nøme mba mo꞉-akhayám, “Déivid-ge zeo. No tanakh gènøgó!” ");
INSERT INTO kvg_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yaq Yesu sège-itán, ezoqa vøzø̄-ein, “Nandev ezoqam, vø̀ndo-ituím, no-te.” Yaq ndego ezoqam gendowav, Yesu ndego āv gembøebeváp nqǽgo, ");
INSERT INTO kvg_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Qo gekhā qápoev, no tøtaqa-matanam?” Yaq ndego gendo-qavøiu, “Evézøza. No bøi keoge-qa nøgó.” ");
INSERT INTO kvg_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yaq Yesu gembo-qavøiu, “Qanimáv. Mòqokewág. Qoqa unimanqatin nandav, tø̀khakheinøqavém.” ");
INSERT INTO kvg_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yaq nqova mbaín. Ngenek ezoqam gèkewág, Yesu vømbōpaev. Mbumbukiam-qa iz até go꞉-eqatát, gemat. Yaq até ndigú-a, ezoqa bawan-qape, nqanek matev giqeivim, Mbumbukiam-qa iz vø̄-eqanem. ");
INSERT INTO kvg_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu Zeliko taon-te ge-on, yaq livin-mbá gunu꞉mát. ");
INSERT INTO kvg_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ta taon-te ndøgo, ezoqam mø̀ndøgoám. Teks moni upøgim kawa ezoqám. Teqa iz Zakiés. Ndego gigiap eve ezoqám. ");
INSERT INTO kvg_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yaq ndego Yesu omete-qa ndøgoám, ndego andē gekha ezoqām. Geté kopømba mbaín. Zapa ndǿgo, ezoqa khàpeme꞉-khouwéz, neka ndego khàpeme꞉-tokhopogeaqase-év, vǿe-omēt. ");
INSERT INTO kvg_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yaq ndego megemege-té genøvuáo, Yesu omete-qa gego, tae-te vømø̄qavig. Zapa ndǿgo, Yesu ndǿgo tenǿmá. ");
INSERT INTO kvg_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu tae gumukhato, yaq bøi ndø-eqá. Yaq ndego Zakies āv gembøe-eín nqǽgo, “Zákies. Nakhama ndovís. No nqægo, qoqá khoev-té qǽgoát.” ");
INSERT INTO kvg_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Yaq Zakies até gendego, gèndovís, Yesu khoev-te vø̄khato. Khanakhanakh-ús. ");
INSERT INTO kvg_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ezoqa ewaqape, nqanek matev giqeivim, yaq ndigu Yesu, manqa mbogeveém, gi-einim, “Ngenek gekha zapâ, manqa-zapazapa-us ezoqa namba, lou timølog.” ");
INSERT INTO kvg_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Yaq khoev-te gimøqonav, Zakies até gendego, sège-itán, Evezøza vømbō-ein, “Evézøza. Nqáe! Noqa gigiap livin-mbá qatumú-qatá. Yaq nøme, gigiap-av ezoqam nøzǿ-etoám. Neka gekha monī ndigu, no ezoqa qazø-aqonøvemam, no nqawá qanøzǿ-etoám. No moni nøme foa-foá, indap, tæzømbø-abam.” ");
INSERT INTO kvg_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yaq Yesu gendo-ein, “Nqægo khaiya, nqanek khoev-te, khandi mø̀ndø-fakhán. Zapa ndǿgo, até ngenek ezoqám-a, Eibleem-gé zeó. ");
INSERT INTO kvg_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ezoqam-ge Yo, ndǿgo tenegeavún. Ezoqa gezǿváo, ndigu gi-ewaz, neka vǿkhandī꞉z.” ");
INSERT INTO kvg_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ezoqa ewaqape ate av-té manqat gimbøe-ewagat, yaq Yesu manqat nøme mba mo꞉manáz. Zapa ndǿgo, ndego Zelusalem taon ge꞉khatoat, ezoqa até vø̄e-einim, Mbumbukiam-qa Megeat Matev ndakin ndø̄fakhān, yaq Yesu kawa ndø̄goāt. Yaq Yesu yaya zø-etá, taqa yaq-te, gezø-ein, ");
INSERT INTO kvg_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Qàgoám. Ezoqam mø̀ndøgoám. Iz akhae ezoqám. Yaq ndego manqei qambaqape okho-qa ndøgoám. Ndøgo kawa iz mǿndáp, yaq vaev ekeza manqei-te nango vǿvesēz. ");
INSERT INTO kvg_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Yaq gewav, tegi sasae ezoqam ten mø̀ndøzømbøkhæ-akhá, ezoqa kopokopo moni mokho kopokopo vøzø̄-etoam. Yaq gezø-ein, ‘Zøté-sasaeném, no tøte-ewambat,’ yaq ndego sasa ndøwav. ");
INSERT INTO kvg_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Geté ekeza manqei-te ndøgo, ezoqa gèmbo-sanqaupám. Yaq ndigu u-anim ndøkhofotáz, teqa zita-te. Ndigu ta manqei qambaqape ezoqam, āv tiabezømbe-eín, ‘Ni poeveáv, ngenek ezoqam, nigi kawa tegoat.’ ");
INSERT INTO kvg_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Geté ndego ezoqam, kawa iz mø̀ndømbo-akhaém, ekeza manqei-te vø̄qavan. Yaq gemøfakhan ndøgo, ndego manqat mba ndøkhofotám. Tegi sasae ezoqam bètøndopiá, betē-otev, ndigu moni ande gekha-gekhâm giqaqasam, ndego ge-ewawam. ");
INSERT INTO kvg_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yaq ndego sasae ezoqam, bugukhokhof gendowav, ndego kawa ezoqam āv gembøe-eín nqǽgo, ‘Káwa ezoqam. Qogi moni mokho kopo, noqa zenda-te qoqozav, ndakin mø̀ndømø-ten-éz.’ ");
INSERT INTO kvg_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Yaq kawa ezoqam gembo-ein, ‘Qanimáv. Qo sasae ezoqam mbomambaqapé. Ndakin qo kawa ezoqam nøveét. Taon ate tægoat tén, toqoto-kawaeqtat. Zapa ndǿgo, gigiap khapelavøqase ndøgo, qoqa zenda-te qæve, qo qanimáv qoqombo-kewagam.’ ");
INSERT INTO kvg_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Yaq sasae ezoqa nøme gendowav, kawa vømbō-ein, ‘Káwa ezoqam. Qogi moni mokho kopo, noqa zenda-te qoqozav, ndakin mø̀ndømø-faev-éz.’ ");
INSERT INTO kvg_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Yaq kawa ezoqam gembo-ein, ‘Qanimáv. Qo taon fáev, toqoto-kawaeqtat.’ ");
INSERT INTO kvg_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Yaq sasae ezoqa nøme gendowav, kawa ezoqam vømbō-ein, ‘Káwa ezoqam. Qogi moni mokho kopo, noqa zenda-te qoqozav, ngínik. Ndabua mbewát qate-løvønøvém, sasa nokhonab. ");
INSERT INTO kvg_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","No møe nøtaqa-goám. Zapa ndǿgo, qo ezoqa kefak-qapé. Qo moni soqo-upøgimín ndøgo, qakezan sasae gonemav ndoqogo, neka qo avøe gigiap voqō-peaɨn, ndøgo qakezan ogekhæmav ndoqogo.’ ");
INSERT INTO kvg_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Yaq kawa ezoqam gembo-qavøiu, ‘Qo sasae ezoqa soqaqapé. Qo yaq-fia āv tøtaqambé-matanám, av manqat qoqote-ein. Qo āv qoqote-eín nqǽgo: Qo mòqote-qatéq. No ezoqa kefak-qapé, neka no moni sæ̀-upøgimatún, ndøgo no sasae gonemav qægoatun neka avøe gigiap sa vø̄e-peaɨn, ndøgo no ogekhæmav ndøgo. ");
INSERT INTO kvg_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Av tægoat ndægo, yaq qo gekha zapâ, nogi moni, moni nqeisam nonqo khoev-te zaveav qagoam? Yaq ndakin no qatøndo-qavan, ndigu ambá elavøqase ndøkhouwezɨ́n, no nqawa qændapaz.’ ");
INSERT INTO kvg_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Yaq ndego kawa ezoqam, até gendego, ndigu sasae ezoqa nøme, teqa avønin-te giwaniapam, vøzø̄-ein, ‘Moni mokho kopo vø̀e-viomém. Yaq ndégo tozombó-etøomém, ndego moni mokho ten ndimbogo.’ ");
INSERT INTO kvg_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Geté ndigu sasae ezoqam gindu-einim, ‘Káwa ezoqam. Ndego sasae ezoqa nøme, moni mokho ten ndimbôgó.’ ");
INSERT INTO kvg_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Yaq ndego kawa ezoqam gendo-qavøiu, ‘No nqazǿ-manqate: Gekha ezoqām ndego, kopoav ndømbogo, ndego nøme mba mbøé-etøomém. Geté gekha ezoqām ndego, khakha-mba ndego, khapelavøqase nøme ndømbogo, gé꞉viomém. ");
INSERT INTO kvg_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Geté nogi qaqa ezoqam-qa yaq-te, ndigu poeveav qagoam, no kawa tæzømbo-goat, ndigu vø̀ndo-upøzó, noqa bugug-te sasa zǿzitāg, vǿpakhāez.’” ");
INSERT INTO kvg_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu nqanek manqa manqate qamømbøe-navøem, yaq nakhoa até gegeveát, atema Zelusalem taon-te. ");
INSERT INTO kvg_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yaq Betfage neka Betani vemiav ge꞉khatoat, Oliv manqei poyat avønin-te ndøgo, yaq ekeza paev ezoqa menas tène-khofotáz, ");
INSERT INTO kvg_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","gezø-ein, “Tozonǿzáv ndǿgo, vemiav zoqa megemege-te ndo꞉go. Tozomø-oz, yaq zo donki nakhasam zomǿ-ometám. Gémopotavát. Ta donki nakhasam-qa mumat-te ndøgo, ezoqam bugukhokhof qomateáv. Yaq sozó-nqovotøvém, sasa zotøndó-ituīm. ");
INSERT INTO kvg_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Geté ezoqa tezøbevap av nqægo, ‘Gekha zapâ, ngunuk donki nqazo-nqovotavet?’ Yaq zo āv qazømbøé-einím nqǽgo, ‘Evezøza mbopóe, ngunuk.’” ");
INSERT INTO kvg_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yaq ndigu ezoqa menas gizav, Yesu gekhofotaz, ndigu matev āv timiqeivím, av gezømbe-ein ndægo. ");
INSERT INTO kvg_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Yaq donki gi꞉nqovotavat, tugi evøndipakha, āv gizømbe-eín nqǽgo, “Gekha zapâ, ngunuk donki nqazo-nqovotavet?” ");
INSERT INTO kvg_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Yaq gizø-ein, “Evezøza mbopóe, ngunuk.” ");
INSERT INTO kvg_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Yaq ndigu Yesu-té gindu-ituím, ekeza ndabua vømbø̄e-khafuzim, Yesu sasa mbotøkeem, tuqa zita-te vō꞉qom. ");
INSERT INTO kvg_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yaq Yesu donki-te go꞉qotat, nakhoa gegeveat, ezoqa teqa megemege-te, ekeza ndabua mo꞉møtagát, nakhoa-te. ");
INSERT INTO kvg_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yaq Zelusalem taon gi꞉khatoat, Oliv manqei poyat gindi-isøtaz, yaq Yesu-gi paev ezoqa bawan-qape, khanakhanakh zømbø-asøtáv, neka teqa iz vø̄-eqanem. Manqa gèzømbo-eqavát. Teqa iz ndǿgo tini-eqaném, umingiap matev vinivinimba giqeivam, Yesu gematønumam. ");
INSERT INTO kvg_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Āv gini-akhaemavún nqǽgo, “Mbumbukiam ngenek kawa ezoqam, bèkhakheinøvém, Evezøza-qa iz-te ngegeav. Mbumbukiam ndego yan-te ngo꞉go, sambi ndøgót ni-te. Teqa iz bèto-eqawát, ndego uni ova-in ngo꞉yage.” ");
INSERT INTO kvg_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Yaq Felisi ezoqa nøme, ndigu ezoqa bawan-qape mokho-te gu꞉goam, Yesu āv gimbøe-einím nqǽgo, “Nøméndim ezoqam, qogi paev ezoqam gèzømbe-khafén. Manqat av nqægo bemanqàte᷄!” ");
INSERT INTO kvg_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Geté Yesu gezø-qavøiu, “No nqazǿ-manqate: Ndigu manqat tikhoutav, yaq nandi ndó-akhaemém.” ");
INSERT INTO kvg_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu Zelusalem gumukhato, taon geqeiv, yaq gèvín. ");
INSERT INTO kvg_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ge-ein, “Zelusalem taon, qo nqægo khøuwa, amba toqo-matøvemɨn, av nqægo, ‘Sambi āv khaténdāp,’ yaq qo ambá qoqeivín. Geté ndøgo gèkhonøwé, qoqa bøi-te. ");
INSERT INTO kvg_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Khøuwa ndø̀fakház. Yaq qogi qaqa ezoqam, qoqa taon uta-te ndøgo, manqei ndǿmøvøemém. Taon unimé꞉-khawagét, qo vǿtokāq. ");
INSERT INTO kvg_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Yaq ndigu qo unimé꞉-ngiæqonám, qogi ezoqam pakhapakha vøzǿ-khaneām. Ndigu qo mokho-te, nandi kopo nøme, nandi nøme-qa mumat-te, gézivazemák. Nqanek matev tenéfakhán ndǿgo. Zapa ndǿgo, qo matavapøteáv, av nqægo, Mbumbukiam qo tøke-qa ndøgeavūn.” ");
INSERT INTO kvg_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yaq Yesu Mbumbukiam-qa khoev uta-te gemø-on, ndego até gendego, ezoqam ndigu gigiap gu꞉wiat, vø̄ngeasam. ");
INSERT INTO kvg_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Gezø-ein, “Mbumbukiam-qa Manqat, āv qane-peawáp nqǽgo, ‘Noqa khoev, guliguli khoev ndǿgoát.’ Geté zo Mbumbukiam-qa khoev, zò-enendém, vømø̄-aqonam-ezoqam-qa-pebam-khoev.” ");
INSERT INTO kvg_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ta pula-te ndøgo, khøuwa ate qæpavpavemam, Yesu ezoqa Mbumbukiam-qá khoev-té gene-zømesimám. Geté Mbumbukiam-gi iziz ezoqa kandakanda neka Mozes-qa guguna manqat nømendim ezoqam neka megetapak nøme, ndigu Yesu laelae-qá nakhoa mbovawám. ");
INSERT INTO kvg_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Geté ndigu nakhoa qeiviáv, Yesu ande āv kimbøé-gonēm. Zapa ndǿgo, ezoqa ewaqape Yesu løvøinøvemáv. Soqaín ndøgo, teqa manqat kopo ti꞉løvuim. ");
INSERT INTO kvg_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Khøuwa nøme, Yesu Mbumbukiam-qa khoev-te, ezoqa ge꞉zømesimat neka Manqat Mbomambaqape vøzø̄-manqatat, yaq Mbumbukiam-gi iziz ezoqa kandakanda neka Mozes-qa guguna manqat nømendim ezoqam neka Zu megetapak nøme ndozáv, ");
INSERT INTO kvg_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","vømbō-bevøpem, “Qonimbí-eīn. Qo gekha ezoqam-qā iz-tē qonǿgot, nandav matev nandoqo-matønumit? Iz gekha ezoqām qá-etoam?” ");
INSERT INTO kvg_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yaq Yesu gezø-qavøiu, “Até nó-a, bevap kopo nqanø̂gó, zo-te. Zonømbé-einīm. ");
INSERT INTO kvg_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Gê, Zion, ndego ezoqa ibøkha iz gezø-etoumam, ndego iz Mbumbukiam-tê gendap, ó, manqei-qape ezoqam-tè?” ");
INSERT INTO kvg_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yaq ndigu ekeza mokho-mba gibond, “Áv khazí꞉-einīm? Tizimbo-einim av nqægo, ‘Ndego iz Mbumbukiam-tē gendāp,’ yaq ndego ni āv ginimbí-eín nqǽgo, ‘Av tægoat ndægo, yaq gekha zapâ, zo Zion unimanqatinteav qazogoam?’ ");
INSERT INTO kvg_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Geté tizi-einim av nqægo, ‘Zion, iz, manqei-qape ezoqam-tē gendāp,’ yaq nginik ezoqa bawan-qape, nandí ginízitáng. Zapa ndǿgo, nginik āv gini-unimanqatinát nqǽgo: Zion ndego Mbumbukiam-gé manqa vevezam ezoqam ndøgoám.” ");
INSERT INTO kvg_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yaq ndigu gimbo-qavøinam, “Ni nìtinøtenák, teqa matev gekham-tē qandō-fakhan.” ");
INSERT INTO kvg_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yaq Yesu gezø-ein, “Av tægoat ndægo, yaq até nó-a, nøzǿ-einák, no gekha ezoqam-qā iz-tē qatø̄got, nqanek matev.” ");
INSERT INTO kvg_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yaq taqa zita-te, Yesu ezoqa ewaqape yaya zø-etá, gezø-ein, “Ezoqa mø̀ndøgoám. Ndego waen khae ndøkhá. Yaq khae ndøgo, ezoqa nøme-qá zenda-té genøvé, timbøe-kewagat, ekezan manqei nøme-te vø̄wav. Møp-mbá gene-ewawám. ");
INSERT INTO kvg_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Yaq waen nanga qakhata ndøgo, ndego khae eve, sasae ezoqam ndøkhofotáv, ti-te ndigu, ma khae gimbøe-kewagam. Ekeza waen nanga upøgim-qa ndøgoám. Geté ndigu khae keoge ezoqam, ngenek sasae ezoqam gèzuím. Yaq nango khakha-mbá sege-khofotøvém. ");
INSERT INTO kvg_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yaq ndego khae eve, sasae ezoqa nøme ndøkhofotáv. Geté até ndegó-a, vø̄zuim-a, vø̄ngenøinam, khakha-mba nango sasa ndøkhofotøvem. ");
INSERT INTO kvg_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yaq ndego khae eve, sasae ezoqa nøme ndøkhofotáv. Ndakin gèmbo-misika-éz, sasae ezoqam gekhofosumam. Geté até ndegó-a, vø̄zuim-a, kouk vømbō-etøomem, khae bavokho sasa ndøngeatømem. ");
INSERT INTO kvg_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Yaq ndego khae eve, ekeza manqa ge-ein, ‘Ndakin gekhā nógō? Ság! Nøkeza yo nókhofotáv, ndego nqæmbøe-khafuat. Ngenek tìabembøe-vizumém.’ ");
INSERT INTO kvg_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Geté ndigu khae keoge ezoqam, khae eve-ge yo gi-ometam, yaq ndigu ekeza mokho-mba āv ginibónd nqǽgo, ‘Ngenek khae eve-gé yó. Waen khae ngének genó-kawa-év. Zílaém. Yaq khae nqanek, gemǿniqá.’ ");
INSERT INTO kvg_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Yaq ndigu até gindigonem, khae bavokhó ginø-ituím, pakhapakha vømømbó-khanøem.” Yesu nqanek yaya etæ manqat qamømbøe-navøem, yaq ezoqa āv gezømbe-eín nqǽgo, “Ge zô, ndozo-matavap? Ndego khae eve, gekha matev zǿmatanām, ndigu khae gimbo-kewagam? ");
INSERT INTO kvg_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ndego āv genégó nqǽgo: Ndego ndø̀ndowáv, ndigu khae keoge ezoqam pakhapakha vømøzǿ-khaneām, neka waen khae, ezoqa vini sasa zǿ-etoām.” Yaq ezoqam ndigu, nqanek Yesu-qa manqat giyogem, āv gini-einím nqǽgo, “Matev av nqægo befàkha᷄n!” ");
INSERT INTO kvg_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yaq Yesu ndigu gèwabám, gezø-ein, “Zo ndozo-matavap, matev av nqægo kopømba mbaīn, tøfakhan, yaq gê, gekha zapâ, Mbumbukiam-qa Manqat av nqæpeawap nqægo: ‘Nandi-qapi ndigu, khoev puanam ezoqam gisanqabem, ndigu mø̀ndømø-gigiap-qape-éz, khoev puanam nonqo.’? ");
INSERT INTO kvg_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Gekha ezoqām ndego, nginik nandi-te to꞉bøiav, ndego keqaniáp. Neka nandi ndigu, teqa kha-te to꞉bøiaz, ndego peseinøváp.” ");
INSERT INTO kvg_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yesu nqanek manqat gezø-ein, yaq Mozes-qa guguna manqat nømendim ezoqam neka Mbumbukiam-gi iziz ezoqa kandakanda, ambá ndaføyamba ndømøvøinamɨ́n. Zapa ndǿgo, ndigu āv gini-matøvemém nqǽgo: Yesu nqanek yaya ge-eta, ndígu tene-manqatám. Geté ndigu matev-qase goneáv. Zapa ndǿgo, ndigu ezoqam-qá møe ndøgoném. ");
INSERT INTO kvg_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mozes-qa guguna manqat nømendim ezoqam neka Mbumbukiam-gi iziz ezoqa kandakanda, bøi mba mo꞉veém, Yesu-te. Yaq ndigu bøibøi ezoqam ndøkhofotáz, Yesu bemømbøē-khavozømem, av nqægo, ndigu yoge eqeieqei mbōgonēm. Geté ndigu ambá gembo-matemateømemín. Yaq Yesu ambá Lom gaman ezoqam-qá zenda-té ginø-veemɨ́n, gaman-qa yaq-te amba manqat soqain te-einin. ");
INSERT INTO kvg_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Yaq nginik ezoqam, Yesu āv gimbøe-einím nqǽgo, “Nøméndim ezoqam, ni mø̀tinøtén, manqat ndøgo, qo ndoqo-manqate neka ezoqa ndoqote-zømesim, eqeieqeí. Neka qo ezoqam-te møe mbaín, oskiá ndøgo, ndigu ezoqa kandakanda o ezoqa khasøkhasis. Geté qo ezoqa Mbumbukiam-qa poev-qa yaq-te ndoqote-zømesim, qo unimanqatin manqat mba qomanqaté. ");
INSERT INTO kvg_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Qonimbí-eīn. Kopømbâ, Siza-te teks moni tizi-abumat, ndego Lom kawa kandambaqape, ó, khafeâp?” ");
INSERT INTO kvg_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Geté Yesu tiqa matemateam matev, é-møndæ-otév, yaq gezø-ein, ");
INSERT INTO kvg_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Moni mokho zøté-nømøndēm. Gê, gekha ezoqam-qâ bugug neka iz mó꞉go?” Yaq gindu-einim, “Siza-qá bugúg, neka teqá iz mo꞉gó.” ");
INSERT INTO kvg_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yaq Yesu gezø-qavøiu, “Av tægoat ndægo, Siza-qa gigiap, Siza zombó-etoumemát. Geté gigiap ndøgo, Mbumbukiam-qa, Mbumbukiam zombó-etoumemát.” ");
INSERT INTO kvg_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yesu-qa manqa qavøiwat qanimav-qape giyogem, yaq ndigu nqova ndafe kandambá. Kopømba mbaín, timbo-matemateømem, ezoqa ewaqape-qa bøi-te. Yaq ndigu manqat nøme einiáv. Sège-ivøvém. ");
INSERT INTO kvg_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Yaq Sadusi ezoqam ndozáv, Yesu-te. Nginik Sadusi ezoqam, āv gini-unimanqatinát nqǽgo: Ezoqa tipakhaetat, ndigu nango gemǿ-khandi꞉zák, løvøte-te. Yaq ndigu Yesu āv gimbøe-einím nqǽgo, ");
INSERT INTO kvg_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Nøméndim ezoqam, Mozes ni āv ginimbi-peawám nqǽgo: Ezoqa tenanimat, sæva te-ivavat, patu qataeveav vǿgoāt, yaq ngunuk ngæmam, namba qawan be-okɨát, tege namba qawan, ndego genanim, patu bembō-qatayat. ");
INSERT INTO kvg_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Qotøndé-ewāg, nqanek emanqat. Angana mø̀ndøgoám. Evenáp. Até gi꞉goam sevén. Yaq khøuwa ndego, sævam ndø-okɨ́, vø̄nanim. Patu qataeveáv. ");
INSERT INTO kvg_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Yaq eveqase ndø-okɨ́, ngunuk ngæmam, ndego teqa zita-te geqan. Yaq até ndegó-a, vø̄nanim. Nakheis qazaneáv. ");
INSERT INTO kvg_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Yaq ndakin ngæmam ndégo te-okɨ́, teqa zita-te go꞉qavigavun. Yaq até ndegó-a, vø̄nanim. Nakheis mbaín. Yaq matev até gemát, atema ndigu evenap seven ate gi꞉goam vømū-pakhaez. Ndigu patu qataeveáv. ");
INSERT INTO kvg_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Yaq vaev até sævám-a, vø̄nanim. ");
INSERT INTO kvg_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Gê, ngunuk sævam-qa yaq-te, matev áv khanégo? Ezoqa unimanqatin løvøte-te tikhandi꞉z, yaq ta khøuwa-te ndøgo, timø-khandi꞉z, ngunuk sævam, gekha ezoqam-gû zas ndǿgoāt? Zapa ndǿgo, ndigu evenap ate gi꞉goam, ngunuk sævam kopo ndøkawawát.” ");
INSERT INTO kvg_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yaq Yesu gezø-qavøiu, “Nøkenøkem matev sa nqánek qagó, ndakin nqaziyage, manqei-qape-te. ");
INSERT INTO kvg_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Geté ezoqa ndigu, Mbumbukiam eqeieqei tezæb, løvøte-te nango tisuz, neka megemege-te vømǿyāg, ndigu nøkenøkem matev gezǿgoák. ");
INSERT INTO kvg_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ndigu andé enzol ezoqam me mé꞉goát, neka løvøte nøme gemǿ-qeivimák. Ndigu Mbumbukiam-gí nakheís ndǿgoát. Zapa ndǿgo, ndigu løvøte-te mø̀ndø-khandí꞉z. ");
INSERT INTO kvg_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Geté løvøte-te khandi꞉nat-qa yaq-te, Mozes ekezan mø̀ndænømánd, av nqægo, ndøgo unimanqatín. Zapa ndǿgo, Evezøza Mozes gembo-fakhan, tae-qase-te ndøgo, qawageapam, yaq Mozes ndego āv gembøe-akhá nqǽgo: Eibleem-gé Mbumbukiám neka Aezek-gé Mbumbukiám neka Zekop-gé Mbumbukiám. ");
INSERT INTO kvg_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mbumbukiam ndego ambá av nqǣgo, løvøte ezoqam-gē Mbumbukiām, geté ndego khandi ezoqam-gé Mbumbukiám. Te-te ndego, ezoqa ewaqape, gipakhaetat, zua ndøkhandi꞉zát.” ");
INSERT INTO kvg_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yaq Mozes-qa guguna manqat nømendim ezoqa nøme, Yesu-qa manqat giyogem, āv gini-einím nqǽgo, “Nøméndim ezoqam. Qoqa qavøiwat manqat, qanimáv tantáv.” ");
INSERT INTO kvg_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yaq taqa zita-te, ezoqa nøme bevap goneáv, te-te. Møe ndøgoném. ");
INSERT INTO kvg_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yaq Yesu ezoqa gezøbevap, “Ge zô, ndozo-matavap? Gekha zapâ, ezoqa av ndi꞉manqate, av nqægo, Mesaya ndego, Deivid-gē Zeō? ");
INSERT INTO kvg_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Sams mbuk mokho-te, Deivid ekezan āv gene-peawám nqǽgo: Evezøza Mbumbukiam, noge Evezøza, āv gembøe-eín nqǽgo, ‘Noqá nakeamo zenda-té qanøqóm. ");
INSERT INTO kvg_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Até qóqotát, atema no qogi qaqa ezoqam, kopømba ande av zenda tokhotapak awam nonqo, qoqa zenda tokhotapak mokho-te vøtaqambú-āb.’ ");
INSERT INTO kvg_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Deivid, ndego Mesaya, Evezøza mbo-akhayám. Yaq gê, ngenek Mesaya, áv kené-Deivid-ge-zeo-ev?” ");
INSERT INTO kvg_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ezoqa ate av-té teqa manqat gi꞉-ewagat, yaq Yesu ekeza paev ezoqam āv gezømbe-eín nqǽgo, ");
INSERT INTO kvg_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Gò꞉feazoát, Mozes-qa guguna manqat nømendim ezoqam-qa yaq-te. Ndigu tøzømbe-khaneát ndǿgo, ti-okhoat, ndabua loloakh mbomømboma ndǿ-uzupát, neka ezoqa ewaqape, maket manqei-te, ndigu khaiya mboma manqat vizap-us bezø̄-manqate, neka guliguli khoev-te neka lou loge kandakanda-te ndøgo, iz akhayapak-qa qonam nonqo-te vǿqonumāt. ");
INSERT INTO kvg_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ndigu ngængæm zømbe-khavozumatún, tiqa khoev neka gigiap vøzø̄-aqonumatun. Neka ezoqa ewaqape-qa bøi-te, guliguli loloakh ndøgoatún. Yaq nakémbá ndigu yaq-fia nqosøgeap, nøme mba mó꞉ndapém.” ");
INSERT INTO kvg_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu Mbumbukiam-qa khoev-te gegoam, yaq gigiap kopoav ezoqam ndøzømét. Ndigu moni ndø-abumát, moni nqeisam nonqo-te ndøgo. ");
INSERT INTO kvg_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Yaq até sævám-a, vø̄-omet. Ngunuk ngæmám. Gigiap-av ezoqám. Zivis mø̀ndømbo-naním. Ngunuk moni mokho khasøkhasis menas mba mu꞉nqeitáz. ");
INSERT INTO kvg_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesu ngunuk sævam gu-omet, yaq āv gene-eín nqǽgo, “No unimanqatín nqazø-manqate. Ngunuk gigiap-av sævam, moni kandambá gu꞉nqeitaz, āv tiuká, av ezoqa ewaqape nøme, moni gi꞉nqeisumat. ");
INSERT INTO kvg_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Unimanqatín. Ndigu ezoqa nøme, moni kandakandá ginqeisumat. Geté ndigu moni nøme kopoav-qapi ndizø̂gó. Geté ngunuk ngæmam, viní. Ndugu moni ate gimbøegoam, sùgumu-áb. Nøme mbaín, tuqa yage nonqo.” ");
INSERT INTO kvg_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ezoqa nøme, Mbumbukiam-qa khoev-qa yaq-te, āv gini-manqatám nqǽgo, “Mbumbukiam-qa khoev mbomambá tantáv. Nandi kandakanda qaniqaním giniwevém. Neka gigiap qaniqaním gimbøe-fegém, gigiap ndøgo, ezoqa Mbumbukiam-te etoam matev gi꞉goam.” Geté yaq Yesu gezø-qavøiu, ");
INSERT INTO kvg_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Khøuwa ndø̀mø-fakház. Yaq nqanek khoev ate ndægo, ndozoqeivi, manqei-té qamǿ-khakhandám. Nandi kopo nøme, nandi nøme-te, gó꞉zaveák.” ");
INSERT INTO kvg_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yaq ndigu Yesu gimbo-bevøpem, “Nøméndim ezoqam. Matev nandav, qoqote-manqatam, gekha khøuwā qanéfakhān? Neka andé gekha matev me nitíqeivīm, ni tøtinøten, av nqægo, nqanek matev avønīn gēfakhān?” ");
INSERT INTO kvg_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yaq Yesu gezø-qavøiu, “Gò꞉feazoát. Soqaín ndøgo, zo ezoqa titubam. Ezoqa kopoáv, noqá iz-té gindú-okhoát. Ndigu ezoqa āv gizømbé-manqatát nqǽgo, ‘Ezoqa, nó’, ó, ‘Khøuwa mø̀ndø-fakház.’ Geté zo ndigu zø̀pae᷄v. ");
INSERT INTO kvg_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nakhag neka nøfeap kandakanda-qa yaq-te tozo-ewagat, yaq zo møe ndøgonèma᷄t. Matev av nqægo, bugukhokhof ndø̀kho-fakhanám. Geté manqei-qape-qa vaev, zuá.” ");
INSERT INTO kvg_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yaq Yesu manqat nøme gezø-ein, “Manqei nøme, manqei nøme namba, nakhag ndǿgoát, neka kawa ezoqa nøme-qa bawan, kawa ezoqa nøme-qa bawan namba, vǿnøfeapāt, ");
INSERT INTO kvg_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","neka manqei nøme-te, manqei vǿkukuvøemāt. Manqei kukuvøem kandakandá. Neka manqei vinivinimba-te, ifin matev neka enqoni soqøsoqa ndǿfakhanám, neka matev kandakanda møe-us neka yan-te khakhatap kandakanda vǿfakhanām. ");
INSERT INTO kvg_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Geté nqanek matev ate ndægo, okhokho-té qanǿ-fakhanám. Zo ezoqa ndø̀khæ-gavemat neka matev soqøsoqa vøzǿ-matønumāt. Ndigu zo manqa ovøyam-té ginǿ-abumát, Zu ezoqam-qa guliguli khoev-te ndøgo, neka zo ndimbula-te vǿnqeisumāt. Neka no zapaya, zo megetapak neka kawakawa-za-qá megemege-té ginǿ-abumát. ");
INSERT INTO kvg_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Matev av nqægo tøfakhanam, yaq zo kopømbaqapé, ndigu ezoqam Manqat Mbomambaqape zøté-zømesimát. ");
INSERT INTO kvg_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Geté zo naqanøká ndøfofogème᷄m, av nqægo, zo andé gekha manqat me zozǿ-qavøitāt. ");
INSERT INTO kvg_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Zapa ndǿgo, manqat eqeieqei neka matavap loloakh, nō nøzǿ-etoumát. Yaq zogi qaqa ezoqam, kopømba mbaín, zoqa manqat tiqavøitat neka vøzǿ-nqagimāt. ");
INSERT INTO kvg_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Até zogí zøvøndipakhá-ya neka namba-qaniap neka zøkeza ezoqam neka zøfuap, segezǿ-qambúz, neka zo ezoqa nøme vǿzitāg. ");
INSERT INTO kvg_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ezoqa ewaqape zo gésanqabát, no zapaya. ");
INSERT INTO kvg_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Geté zoqa kawa-te, izum ate nandizømbi꞉gu, kopo gezǿ-nasinimák. ");
INSERT INTO kvg_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Zo føgøføgakh ndøwaniáp. Yaq zo khandi zomǿndapém.” ");
INSERT INTO kvg_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yaq Yesu manqat nøme gezø-ein, “Zo nakhag ezoqa tozo-zømet, ndigu Zelusalem taon uni ti꞉khawaget, yaq zo søzøté-zøtéz, av nqægo, ndøgo avønín gésoqá. ");
INSERT INTO kvg_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ta khøuwa-te ndøgo, ezoqa ndigu Zudia plovins-te tiyagat, manqei popotap-té giabenø-khokhóz. Neka ndigu Zelusalem taon-te tiyagat, taon yà be-ivøvém. Neka ezoqa ndigu bavokho to꞉yagat, taon-te betøndò-o᷄z. ");
INSERT INTO kvg_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nginik khøuwa, Mbumbukiam-qá yaq qavøiwat khøuwá, ezoqa manqa-zapazapa gi꞉goam. Yaq Mbumbukiam-qa Manqat ate ndægo, gemǿ-unimanqatín, taqa yaq-te ndøpeawap. ");
INSERT INTO kvg_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ta khøuwa-te ndøgo, ti-te ndigu unimé꞉-soqá, sakheis emu-us ndigu neka nakhei tete ndizøloge. Yage føgakh-qape ndǿfakhán, nqanek manqei-te. Nginik bawan ezoqam, Mbumbukiam-qá qaqa ndǿqeivím. ");
INSERT INTO kvg_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Zu ezoqa nøme, nakhag kaiya-té ginǿ-pakhaetát, neka nøme vøzǿ-geagimāt, manqei vinivinimba-te sasa ndǿ-itubāt, manqei-qape-te ate nqægo. Yaq Zelusalem taon, bawan vini-ak ndǿtokhonumát, atema bawan vini-ak-gi khøuwa vømǿ-nasinīm.” ");
INSERT INTO kvg_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yaq Yesu manqat nøme gezø-ein, “Khøuwa neka løvøyak neka nduku, matev vinivinimba zǿfakhanám. Neka manqei-qape-te nqanek, bawabawan vinivinimba gó꞉bevøpém neka møe vǿgonēm. Zapa ndǿgo, ndaola-te ndøgo, khamøe kandakanda ndǿvumøemát. U-ús. ");
INSERT INTO kvg_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ezoqa møe khape tøzømbe-khouwevat, matev kandakanda nøme-qa timbøe-kewagat, manqei-qape-te tøfakhanam, yaq bøi zǿgugimát. Até ndøgó-a, gigiap yan-te nqo꞉go, vǿkukuvøēm. ");
INSERT INTO kvg_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Yaq ezoqa, Ezoqam-gé Yo ndǿ-ometám. Khaiya ozoz-té genǿgeáv. Bazaføgakh-ús neka waev-qape-ús. ");
INSERT INTO kvg_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Matev av nqægo tøngazøngazam, zo sège-føgøføgakhæzám. Kawa mba zotó-eqá. Zapa ndǿgo, zo Mbumbukiam avønín génqovotáz.” ");
INSERT INTO kvg_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yaq Yesu yaya zø-etá, gezø-ein, “Zo fig tae o gekha tae nøme zóqeivát. ");
INSERT INTO kvg_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Zo qazo-qeivimin, esokho qaqabamɨn, yaq zo mø̀zøte-zøtezɨ́n, wavam khøuwa avønín. ");
INSERT INTO kvg_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Yaq matev até kopó. Zo nqanek matev tozo-qeivimat, tøfakhanumat, av no qazømbe-manqatam, yaq zo søzøté-zøtéz, Mbumbukiam-qa Megeat Matev avønín géfakhán. ");
INSERT INTO kvg_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","No unimanqatín nqazø-manqate. Ezoqa nøme, ndakin ngiyage, naqanøká gépakhaezák. Até géyagát, atema ta khøuwa-te ndøgo, nqanek matev ate ndægo vømú-fakhanām. ");
INSERT INTO kvg_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yan neka manqei-qape ndø̀mø-navøém. Geté noqa manqat, gemǿ-navøemák.” ");
INSERT INTO kvg_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yaq Yesu manqat nøme gezø-ein, “Aiyá qagó. Zo manqei-qape matev-te, kawa ndøvòa᷄, kopømba ande av ibøkha soqa izam matev neka qakeza yage-qa yaq-te khape toqote-fofogeapat. Soqaín ndøgo, ta khøuwa ndøgo, zo ande ka me tøzøte-ndap. ");
INSERT INTO kvg_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nqanek khøuwa, ezoqa ewaqape-té qanǿfakhán, nqanek manqei-qape-te ngiyage. Nakhamas-té. ");
INSERT INTO kvg_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Zo oskia mo꞉feazoát. Gèguligulím, av nqægo, nqanek matev ate ndægo tøfakhanam, zo bazaføgakh-us tøzøté-waním, yaq vaev Ezoqam-ge Yo-qa megemege-te vozotó-wān.” ");
INSERT INTO kvg_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ta pula-te ndøgo, khøuwa ate qæpavpavemam, Yesu ezoqa Mbumbukiam-qá khoev-té gene-zømesimám. Yaq qakhagusin ndøgo, ndego Zelusalem taon, gè-ivavɨ́n. Yaq lovølova, Oliv manqei poyat-té gemøbuvɨ́n. ");
INSERT INTO kvg_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Yaq qanaqanus qando-paveɨn, ezoqa ewaqape, Mbumbukiam-qá khoev-té ginøzavɨ́n, lovølova-ús, Yesu-qa manqat vømǿ-yogemɨn. ");
INSERT INTO kvg_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Zu ezoqam-qa khøuwa kandambaqape, Pasova ndimbo-akhayam, ndøgo flawa poponøvemav gilouzatun, avønín qagoám. ");
INSERT INTO kvg_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Mbumbukiam-gi iziz ezoqa kandakanda neka Mozes-qa guguna manqat nømendim ezoqam, Yesu laelae-qá nakhoa mbovawém. Geté ndigu poeveáv, ezoqa ewaqape-qa bøi-te timøvøinam. Zapa ndǿgo, ndigu ezoqam-qá møe ndøgoám. ");
INSERT INTO kvg_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Yaq Zudas, iz nøme Iskaliot gimbo-akhaemam, ndego Yesu-gi paev ezoqa tuelv gegoam, Saitan mbøi-ón. ");
INSERT INTO kvg_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yaq Zudas até gendego, Mbumbukiam-gi iziz ezoqa kandakanda neka Mbumbukiam-qa khoev vos keoge ezoqam-gi megetapak-té genøwáv, ti namba manqa vømø̄-khakheinømem, Yesu tiqa zenda-te ande āv kenévē. ");
INSERT INTO kvg_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ndigu teqa manqat giyogem, yaq ndigu khanakhanákh, neka te-te moni etoam manqat vø̄khakheinømem. ");
INSERT INTO kvg_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yaq Zudas tiqa manqat gè-unimanqatín. Yaq khøuwa eqeieqei-qa mo꞉kewagám. Yesu ezoqa ewaqape-te ande āv khambøé-løvūz, yaq tiqa zenda-te ndǿgo tenévé. ");
INSERT INTO kvg_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Zu ezoqam-qa khøuwa kandambaqape gimø-khantøzem, ndøgo flawa poponøvemav gilouzatun, neka Pasova lou loge nonqo sip nakheis vø̄zitagatun, ");
INSERT INTO kvg_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","yaq Yesu Pita neká Zion, tèkhofotáz, gezø-ein, “Pasova lou zomǿ-khakheinømém, ni tizimølog.” ");
INSERT INTO kvg_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Yaq gimbo-einim, “Gê, qoqa poev gekhâm? Ni gekham-tē qeimǿ-khakheinømēm?” ");
INSERT INTO kvg_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yaq gezø-qavøiu, “Zelusalem taon-te tozomø-oz, zo ezoqa zó-ometám. Ibøkha ndǿ-eqatét. Yaq zombó-paevém, atema khoev-te vømǿ-ōn. ");
INSERT INTO kvg_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Yaq ta khoev ndøgo, khoev eve āv qazømbøé-einím nqǽgo, ‘Nømendim ezoqam, āv geqande-beváp nqǽgo: Khoev kouwat gekham-tē qágo, ma nogi paev ezoqam namba, Pasova lou teimølog?’ ");
INSERT INTO kvg_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Yaq ndego zo khoev kouwat kandambaqape mé꞉zømás, khoev ova ndo꞉go. Qonam nonqo neka lou-qase khakheitáp. Yaq zo lou ndǿgo tozomǿ-khakheinømém.” ");
INSERT INTO kvg_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yaq ndigu gizav, matev āv timiqeivím, av Yesu gezømbe-ein ndægo. Yaq ndigu Pasova lou vømø̄-khakheinømem. ");
INSERT INTO kvg_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Yaq qakhagus ndøgo, lou loge khøuwa iz gimø-khantaz, Yesu tegi u-anim namba, tinøpindám ndǿgo, lou loge-te vø̄qonav. ");
INSERT INTO kvg_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ndego āv gezømbe-eín nqǽgo, “No nqosøgeap banøndáp. Geté noqa poev kandambaqape, nqánek qagoám. Nqanek Pasova lou bìzikhælóg, zo namba. ");
INSERT INTO kvg_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","No nqazǿ-manqate: No Pasova lou nøme, naqanøká nomǿlogák, atema Mbumbukiam-qa Megeat Matev mokho-te, matev ate ndægo vømǿ-unimanqatīn, ndøgo Pasova lou loge matev kha-mba ndømbo-ove.” ");
INSERT INTO kvg_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yaq Yesu izam nonqo ndøndáp, waen-ús, Mbumbukiam-te ike manqat vø̄-ein, yaq gezø-ein, “Mòzondapém. Yaq søzøtumú-izumít, zo ate ndøzøte꞉go. ");
INSERT INTO kvg_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","No nqazǿ-manqate: No waen tae nanga-qa et, nqawa naqanøká nǿ-izák, atema Mbumbukiam-qa Megeat Matev vømǿfakhān.” ");
INSERT INTO kvg_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yaq taqa zita-te, Yesu flawa ndøndapáz, Mbumbukiam-te ike manqat vø̄-ein, sasa ndømbegim, ekeza paev ezoqam vøzø̄-etoam, gezø-ein, “Nqanek noqá khá, zo nqazø-etoumit. Matev av nqægo até vøgó. Yaq no zonømbé-matavupát.” ");
INSERT INTO kvg_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Yaq matev até kopó, lou loge qamezømbe-navøem, Yesu izam nonqo ndøndáp, waen-ús, gezø-ein, “Nqanek waen, Mbumbukiam poev ndakinak mé꞉-unimanqatín. Noqá kóuk gené-unimanqatín, ndøgo zo zapaya tøwa. ");
INSERT INTO kvg_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Geté. Nqáe! Ezoqam ndego, ma nogi qaqa ezoqam-qa zenda-te teve, ngégo, nqanek lou loge-te nqazi-qonøve. ");
INSERT INTO kvg_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ezoqam-ge Yo ndø̀naním, av Mbumbukiam-qa poev ndægo. Geté ndego mø̀ndø-soqoév, ndego ezoqam, ma nogi qaqa ezoqam-qa zenda-te teve.” ");
INSERT INTO kvg_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yesu nqanek manqat ge-ein, yaq ekeza paev ezoqam ekeza mokho-mba, āv ginibónd nqǽgo, “Éisa, ni mokho-te matev av nqægo, gekha ezoqām ndǿmatanām?” ");
INSERT INTO kvg_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yaq Yesu-gi paev ezoqam-qa mokho-te, ponqombap matev ndøfakhán. Tini-ponqombupát ndǿgo, ti mokho-te, iz akhae kandambaqape, gekha ezoqā ndǿgo? ");
INSERT INTO kvg_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yaq Yesu gezø-ein, “Bawabawan-gi kawakawa-za, ezoqa gètokhonøzát. Yaq nginik megetapak, ekeza kha, keoge ezoqa eqeieqei me꞉vewé. ");
INSERT INTO kvg_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Geté zo mokho-te, matev av nqægo bègo᷄. Gekha ezoqām ndego, zo mokho-te iz kandambaqape tegoat, ndego yà be-khapelavøqase-év. Neka gekha ezoqām ndego, megeat ezoqam tegoat, ndego yà be-zoge-tøke-ezoqam-év. ");
INSERT INTO kvg_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Gê, ezoqa kandambaqape ákenego? Ndégò, lou-qase-te ndemia, ó, ndégò, lou ndeyogimit? Zo mø̀zøte-zøtéz, ezoqa kandambaqape ndégo, lou-qase-te teqotat. Geté no zo mokho-te, zogé sasae ezoqám. ");
INSERT INTO kvg_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Zo nó namba zi꞉goám. Neka zo no nøuvønateáv, matev føgøføgakh qanø-fakhanumam. ");
INSERT INTO kvg_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yaq nakémbá. No zo Megeat Matev nøzǿ-etoám, kopømba av-té, Tat no Megeat Matev genømbe-etoam. ");
INSERT INTO kvg_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","No kawa iz tæmøndap, zo noqa lou-qase-te, lou zólogát neka ibøkha vozó-izumāt, no namba, neka zøkeza kawa ezoqam-qa qonam nonqo-te vozotó-qonavāt, neka Izlael khagua bawan tuelv vozozømbó-kawaeztāt.” ");
INSERT INTO kvg_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu Pita āv gembøe-eín nqǽgo, “Sáemon, Sáemon. Nqáe! Saitan Mbumbukiam zo khamasim-qá yaq-té gembøeviám. Ndego zo andé wit me mé꞉-evém, tag vǿkhofovøēm. ");
INSERT INTO kvg_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Geté no, nòguligulím, qo zapaya, Saemon. Qoqa unimanqatin, betaqa-nàvøe᷄m. Yaq nqawa toqotøndo-qambuq, qafuap vø̀zøtøké. Yaq tiqa unimanqatin bezømbē-føgakh.” ");
INSERT INTO kvg_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Geté Pita gembo-qavøiu, “Evézøza. No kopømbá. Ndimbula-te sǽnáv, qo namba, neka sizimú-pakhaén.” ");
INSERT INTO kvg_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yaq Yesu gembo-ein, “Píta! No nqataqá-manqate. Nqægo lova, kokolok naqanøká gé-ogeayák. Qo noqa yaq-te, ndòqotøkhæ-nawám. Misiká toqoto-nawam. Āv qoqoté-manqatát nqǽgo, ‘No ngenek ezoqam nø̀tenøtenāk.’” ");
INSERT INTO kvg_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yaq Yesu ekeza paev ezoqam gezøbevap, “Ta khøuwa-te ndøgo, zo qækhofosam, yaq no av qazømbe-ein nqægo, moni neka moqos neka tamak ndø-upø̀gi᷄m, yaq ge zô, gigiap mbaīn mozógoam?” Yaq gindu-qavøinam, “Mbaín. Ni kopømbá qeigoam.” ");
INSERT INTO kvg_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yaq Yesu gezø-ein, “Qanimáv. Geté ndakin viní. Gekha ezoqām ndego, moni nqeisam nonqo timbogoat neka moqos vømbógoāt, bètonqoatét. Neka gekha ezoqām ndego, nakhag kaiya mbain tøgoat, ndego ekeza ndabua nøme, yà bewi. Yaq moni ndigu teqas, nakhag kaiya mé꞉wí. ");
INSERT INTO kvg_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mbumbukiam-qa Manqat āv qane-peawáp nqǽgo: ‘Ndego pepen ezoqam me꞉vewém.’ No nqazǿ-manqate. Nqanek manqat bè-unimanqatín, no mokho-te. Unimanqatín. Gekha manqāt ndøgo, noqa yaq-te ndøpeawap, avønín géfakhán.” ");
INSERT INTO kvg_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yaq Yesu-gi paev ezoqam gindu-einim, “Evézøza. Nqáe! Nakhag kaiya menas ngínik.” Geté ndego gendo-ein, “Ság. Tiá.” ");
INSERT INTO kvg_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Taqa zita-te, Yesu Zelusalem taon, gè-iváv. Yaq Oliv manqei poyat-té genøwáv, av oskia ge꞉goam, neka tegi paev ezoqam vømbō-paevem. ");
INSERT INTO kvg_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Yaq gimøfakhaz ndøgo, ekeza paev ezoqam āv gezømbe-eín nqǽgo, “Zo bazaføgakh-qa, gèguligulím. Soqaín ndøgo, khamasim matev tøndowav zo-te, yaq zo zō-o꞉āz.” ");
INSERT INTO kvg_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Yaq ndego sègeziváz, elavøqase nøme vø̄wav. Atap ande av ndǽgo, nandi toqo-ogizo, timø-bøiaz. Yaq ndego katuk ndømøkuí, vø̄guligulim. ");
INSERT INTO kvg_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Āv gene-guligulím nqǽgo, “Tát! Qo taqa-pøovat. Nqanek nqosøgeap kandambaqape, ndøgo ande ibøkha khaqain-qape me tønømbe-fakhan, ambá qøndapɨ́n. Geté matev āv tabete-fakhán, av qoqa poev ndægo. Ambá ndø̄go, av no nqanømbe-poev.” ");
INSERT INTO kvg_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Yaq yan-te ndo꞉go, enzol ezoqam ndovís, bazaføgakh vømbō-etoam. ");
INSERT INTO kvg_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu mbøni vaev kandambaqape ndøndáp. Yaq ndego bazaføgakh-us nøme mba mo꞉guligulím. Tata andé kóuk. Sège-lanqavám, manqei-te. ");
INSERT INTO kvg_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yesu guligulim qamømbøeva, ge-itan, tegi paev ezoqam-te gevesez, yaq āv genezømét nqǽgo: Gèsømbiám. Bazaføgakh gèzø-navøém. Zapa ndǿgo, ndigu mbøni vaev matev khàpe zømbe-khouwév. ");
INSERT INTO kvg_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yaq Yesu gezø-ein, “Zo gekha zapâ, venanqei mba ndozo-sømbiit? Mòzosúz. Neka gèguligulím. Soqaín ndøgo, khamasim matev tøndowav zo-te, yaq zo zō-o꞉āz.” ");
INSERT INTO kvg_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu ate av-té manqat ge꞉manqatam, yaq nqáe! Ezoqa bawan-qape tīnø̄fākhāz. Ndigu Zudas ndø-itubavún, ndego Yesu-gi paev ezoqa tuelv nøme gegoam. Yaq ndego até gendego, Yesu-té genøwáv, vø̄ngenøtam. ");
INSERT INTO kvg_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yaq Yesu gembo-ein, “Zúdas. Gê, qo Ezoqam-ge Yo ngenøtam-ûs, qaqa ezoqam-qa zenda-te nqoqoveet?” ");
INSERT INTO kvg_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yaq ndigu ezoqam, Yesu namba gi꞉goam, go꞉matøvemem, ande gekha matev me ndǿfakhān, yaq āv gimbøe-einím nqǽgo, “Evézøza, nakhag kaiyā ndøtízitag?” ");
INSERT INTO kvg_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yaq paev ezoqa nøme, até gendego, Mbumbukiam-ge iziz ezoqam kandambaqape, tege sasae ezoqam, nakeamo gea vømbōkawa. ");
INSERT INTO kvg_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Geté yaq Yesu gezø-ein, “Ság. Matev av nqægo tønév.” Yaq Yesu teqa gea gèmbokhanáz, nango vømbō-eqeieqei. ");
INSERT INTO kvg_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yaq Yesu Mbumbukiam-gi iziz ezoqa kandakanda neka Mbumbukiam-qa khoev vos keoge ezoqam neka Zu megetapak nøme, ndigu møvøiwat-qa gigeavun, āv gezømbe-eín nqǽgo, “Ge zô, no pepen ezoqam zøténæmbem, nakhag kaiya neka ndawa-us qazogeavun? ");
INSERT INTO kvg_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","No khøuwa ate qæpavpavemam, Mbumbukiam-qá khoev-té qæqoám, zo namba. Geté ndøgo, zo no kha khanøzeáv. Geté ndakin, zoqa khøuwa qanimav-qape mø̀ndø-fakház. Kawa matev, bøivun-qá bazaføgakh ndøndáp.” ");
INSERT INTO kvg_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yaq ezoqam ndigu gigeavun, até gindigonem, Yesu vø̄-møvøinam, Mbumbukiam-ge iziz ezoqam kandambaqape-qa khoev-te sasa ndø-ituim. Pita até gezøpavát. Andé qámbá gendopavam. ");
INSERT INTO kvg_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Khoev-te gimøfakhaz, yaq uta mokho-te ndøugu, gøinam mø̀ndø-løvutám. Yaq Pita tenøqóm ndǿgo, ti namba, ndigu gøinam-te giqonavam. ");
INSERT INTO kvg_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sasae mbasønakam Pita gu-omet, gøinam waev-te geqotam, yaq ndugu gèwawám, gundu-ein, “Até ngenék-a, Yesú namba me꞉goám!” ");
INSERT INTO kvg_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Geté Pita gò꞉nawám, gendo-ein, “Ngolam, no nandev ezoqam, nø̀tenøtenák.” ");
INSERT INTO kvg_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Yaq khapé outøpøteáv, ezoqa nøme Pita tēnø̄-ōmēt, gembo-ein, “Unimanqatín. Até qó-a, qo tigí ezoqám.” Geté yaq Pita gendo-qavøiu, “Khanánqa. Āv taoká. Nó mbá.” ");
INSERT INTO kvg_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Andé møi-mbá sege-auwám. Ande av wan awá ndægó, ezoqa nøme tēāndōwāv, gendo-ein, “Unimanqatín. Mø̀tenøtén. Ezoqa nøme ngének, Yesu namba ge꞉goam. Zapa ndǿgo, até ngenék-a, Gelili plovins-ák.” ");
INSERT INTO kvg_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Yaq Pita gendo-qavøiu, “Khanánqa. No nø̀tenøtenák, qo gekhā qotē-manqate.” Yaq Pita ate av-té manqat ge꞉manqatam, kokolok tùndi-ogeá. ");
INSERT INTO kvg_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yaq Evezøza gèndoqambún, Pita vø̄wawam. Yaq Pita tembo-matøvém ndǿgo, Evezøza av gembøe-ein nqægo, “Nqægo lova, kokolok naqanøká gé-ogeayák. Qo noqa yaq-te ndòqotøkhæ-nawám. Misiká toqoto-nawam.” ");
INSERT INTO kvg_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Yaq Pita bavokhó genøfakhán, vømø̄vin. Eiv baza ùni mbøepós, ge-eivat. ");
INSERT INTO kvg_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yaq ndigu vos keoge ezoqam, Yesu gimbo-kewagat, otøotam me꞉vewát neka vø̄zuat. ");
INSERT INTO kvg_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bøi ndabuá gimbøe-gutøvém, vømbō-einim, “Qo Mbumbukiam-ge manqa vevezam ezoqam toqogoat, qotínømánd, av nqægo, qo gekha ezoqām ndǿlavaq?” ");
INSERT INTO kvg_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Yaq ndigu ngenøgim manqat nøme kopoáv gimbo-manqatat. ");
INSERT INTO kvg_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Yaq qanaqanus qænqovat, Mbumbukiam-gi iziz ezoqa kandakanda neka Mozes-qa guguna manqat nømendim ezoqam neka Zu megetapak nøme tìnimøváb. Yaq Yesu tiqá megemege-té ginø-ituím. ");
INSERT INTO kvg_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Yaq gimbo-bevøpem, “Qonimbí-eīn. Gê, qo Mesayâ?” Yaq Yesu gezø-qavøiu, “No tæzø-ein, zo no ma zó-unimanqatinimák. ");
INSERT INTO kvg_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Neka no zo bevap tæzøgo, zo ma zonǿ-qavøinamák. ");
INSERT INTO kvg_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Geté avønín, Ezoqam-ge Yo Mbumbukiam-qá nakeamo zenda-té gemǿqóm, ndego Bazaføgakh-Qape.” ");
INSERT INTO kvg_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Yaq ndigu ate gi꞉goam gimbo-bevøpem, “Av tægoat ndægo, yaq gê, qo Mbumbukiam-gê Yò?” Yaq gezø-qavøiu, “Manqat nándav, av zo ndøzøte-manqate. No tèntév.” ");
INSERT INTO kvg_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yaq ndigu gi-einim, “Ság! Bøi vizu ezoqa nøme-qa bizivàwe᷄m. Ni manqat ekeza tou-té qazinømbo-yogém.” ");
INSERT INTO kvg_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Yaq ndigu megetapak ate gi꞉goam, até gindigonem, Yesu Pailøt-té ginø-ituím. ");
INSERT INTO kvg_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Yaq ndigu manqa ndøsøkuzømém, Yesu-qa yaq-te, gimbo-einim, “Ni ngenek ezoqam āv qati-ometám nqǽgo. Nigi bawan ezoqam-qá matavap ndø-enegimatún. Neka ngenek, ezoqa āv gezømbe-manqatatún nqǽgo: Siza-te, ndego Lom kawa ezoqam kandambaqape, teks moni be-àba᷄m. Neka ngenek ekeza kha, Mesaya neka kawa ezoqam me꞉vewé.” ");
INSERT INTO kvg_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Yaq Pailøt Yesu gembobevap, “Gê, qo Zu ezoqam-gê kawà?” Yaq Yesu gembo-qavøiu, “Nándav, av qo ndoqote-manqate.” ");
INSERT INTO kvg_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Yaq Pailøt Mbumbukiam-gi iziz ezoqa kandakanda neka ezoqa ewaqape gezø-ein, “No ngenek ezoqam, teqa manqa-zapa qeiviáv.” ");
INSERT INTO kvg_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Geté ndigu sekembá segembo-pouweám, av nqægo, “Ngenek ezoqa ge꞉zømesimatun, matavap ùni zømbe-ngi꞉tatún, ni Zu ezoqam-qa manqei-te ate nqægo. Gelili plovins-té gendongáz. Yaq ndakin nqanek Zelusalem taon-té gegó.” ");
INSERT INTO kvg_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Yaq Pailøt nqanek manqat ge-ewag, ezoqa gezøbevap, “Gê, ngenek ezoqam, Gelili plovins-âk?” ");
INSERT INTO kvg_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yaq Pailøt ge꞉-otev av nqægo, Yesu ta plovins-te ndø̄go tendowāv, ma Elod gembo-kewagam, yaq ndego Elod-té genø-khofotáv. Zapa ndǿgo, ta khøuwa-te ndøgo, ngenek Zelusalem taon-té gegoám. ");
INSERT INTO kvg_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Yaq Elod Yesu ge-omet, ndego khanakhanakh kandambá. Zapa ndǿgo, ndego omete-qa ndøgoám. Nupøkhán mbá. Ndego mø̀ndø-ewág, Yesu-qa yaq-te. Yaq ndakin, ndego umingiap matev qeivi-qa mbogoám, av Yesu ge꞉matønumam. ");
INSERT INTO kvg_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Yaq Elod Yesu bevap kandambá gembogoat. Geté ndego yaq manqat qavøiwateáv. ");
INSERT INTO kvg_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mbumbukiam-gi iziz ezoqa kandakanda neka Mozes-qa guguna manqat nømendim ezoqam, até gegoám, Yesu-qa manqa vø̄søkuzømem. Manqat kandambá gimbøe-møvøemem. ");
INSERT INTO kvg_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Yaq Elod ekeza nakhag ezoqam namba, Yesu otøotam me꞉vewém neka vø̄ngenøinam. Ndigu kawa ezoqam-qá ndabua mbo-uzím, Pailøt-te nango sasa ndøkhofotøvem. ");
INSERT INTO kvg_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ta khøuwa-te ndøgo, Elod neka Pailøt, zifu matev ndøngazém. Geté bugukhokhof, ndigu qaqa zømbugoám. ");
INSERT INTO kvg_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yesu Pailøt-te nango gindu-ituim, yaq ngenek Mbumbukiam-gi iziz ezoqa kandakanda neka megetapak nøme neka ezoqa ewaqape ndømøváb, ");
INSERT INTO kvg_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","gezø-ein, “Zo ngenek ezoqam no-te qazøtøndo-ndafem, neka zo av ndøzøte-manqate av nqægo, ngenek ezoqam-qā matavap ndø-enegīm, nqáe! No amba nømbøe-beváp, zoqa bøi-te. Geté no teqa manqa-zapa-qase qeiviáv, av zo manqa ndøzømbøe-møvøemet. ");
INSERT INTO kvg_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Até Elód-a, teqa manqa-zapa-qase qeiviáv. Yaq nakémbá, ndego ni-te nango gendo-khofotav. Ngenek ezoqam matev-qase goneáv, ta zapaya tizi꞉laem. ");
INSERT INTO kvg_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Geté nakhag ezoqam bètøkho-feomém. Yaq sǽnqonqotáv.” ");
INSERT INTO kvg_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Geté ndigu ezoqa ewaqape sùgumu-tøkúz, gindu-akhaemem, “Gèlaém nandev. Geté Balabas qonindó-nqonqotáv.” ");
INSERT INTO kvg_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balabas ndimbula-té gunu-utavám. Zapa ndǿgo, ndego Lom gaman ngeasam-qa mbogoám, ndøgo Zelusalem taon-te, neka ezoqa vø̄lavao. ");
INSERT INTO kvg_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailøt Yesu nqonqotøve-qa mbogoám. Yaq ndego ezoqa ewaqape, manqat amba zømbe-eín, nango. ");
INSERT INTO kvg_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Geté ndigu sekembá sege-akhaemám, “Gèlaváo. Tae mutui-té qanø-tøkeó!” ");
INSERT INTO kvg_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Yaq ndakin Pailøt gèmbo-misiká, gezø-ein, “Gekha zapâ? Ngenek gekha manqa-zapā ndǿgo? No teqa manqa-zapa qeiviáv, ta zapaya tizi꞉laem. Geté nakhag ezoqam bètøkho-feomém. Yaq sǽnqonqotáv.” ");
INSERT INTO kvg_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Geté ndigu ivøveáv. Sekembá sege-akhaemát, av nqægo, Yesu tae mutui-té geabe-tøkewé. Tiqa akhayam, Pailøt-qa manqat ùnime꞉-tømbuá. ");
INSERT INTO kvg_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Yaq vaev-te, ndego manqa āv tene-vøovám, av ndigu qazømbe-pøovam. ");
INSERT INTO kvg_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ndego ezoqam, ndigu qazø-pøovam, tefakhan, ndego sègezø-nqonqotáv, ndego Lom gaman ngeasam-qa gembogoam neka ezoqa vø̄lavao, yaq ta zapaya ndimbula-te gi-utavam. Geté Yesu nakhag ezoqam-qá zenda-té genøvé, yaq ndigu matev bemømbō-matønømem, av ezoqa ewaqape poev qazømbe-goam. ");
INSERT INTO kvg_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nakhag ezoqam, Yesu taon bavokho gi-ituat, ezoqa ndø-ometám. Sailini taon-ák. Teqa iz Saemón. Ndego ambá Zelusalem taon-té genømatín. Yaq ndigu até gindigonem, vø̄-møvøinam, Yesu-qa tae mutui vømbø̄e-veem, sasa ndøtøpøtøvem, teqa zita-te te-eqatet. ");
INSERT INTO kvg_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ezoqa bawan-qape kandambá, gimbopavat. Neka sakheis kopoáv, Yesu gèmbo-eivumát, neka ekeza savi vø̄-qambubumat. ");
INSERT INTO kvg_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yaq Yesu gèndoqambún, gezø-ein, “Zelusalem taon-ak, sakheis, zo noqā ndø-eivùmi᷄t. Geté zo zøkezan-qa ndø-eivám neka zogi nakheis-qa vozó-eivām. ");
INSERT INTO kvg_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nqáe! Khøuwa ndø̀mø-fakház. Yaq ezoqa āv giní-einím nqǽgo, ‘Sakheis ndigu, khanakhanakh mbá giabitigú, ndigu sog ndigu neka nakheis mbain ndigu neka nakheis tiqa tete logemav ndigu.’ ");
INSERT INTO kvg_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ta khøuwa-te ndøgo, ezoqa olol vinivinimba, āv gimbøé-manqatát nqǽgo, ‘Niqá mumát qando-muvuvøém’ neka manqei popotap vømbó-einīm, ‘Ni vø̀khonámb.’ ");
INSERT INTO kvg_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nginik matev av nqægo ngimatønumit no-te, no kopømba ande av tae khandin me nqate꞉go, yaq ge zô ndozo-matavap, zo gekha matēv zǿfakhān, zo kopømba ande av tae pakhapakha me ndøzøte꞉go? Matev unimé꞉-soqá tøzøfakhan.” ");
INSERT INTO kvg_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Yesu gi-ituat, yaq até ezoqa menas nømé-a, vø̄-itubat, timøzitag. Ndigu pepen ezoqám. ");
INSERT INTO kvg_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Yaq ta manqei-te ndøgo gimøfakhaz, kawa-pakha manqei ndimbo-akhayam, ndigu Yesu tae mutui-té ginø-tøkewém, neka pepen ezoqa menas, vø̄tøkebam. Nøme ndego, Yesu-qa nakeamo zenda-té ginø-tøkewém, neka nøme ndego yogea zenda-te vø̄tøkewem. ");
INSERT INTO kvg_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu gi꞉pototumat, yaq āv gene-eín nqǽgo, “Tát. Tiqa manqa-zapa, qo sà betaqambo-navøém. Zapa ndǿgo, nginik zøtezateáv, andē gekha matev me ndø̄matunumit.” Gumu-tøkewem ndøgo, yaq nakhag ezoqam, teqa ndabua, kas me꞉-otám. ");
INSERT INTO kvg_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ezoqa tiwaniapát ndǿgo. Matev ndøqeivát. Geté Zu megetapak, Yesu otøotam me꞉vewém, gi-einim, “Ezoqa nøme gekhandi꞉ztam, yaq ndakin ekeza kha bekhandí, ngenek uni Mesaya-in tegoat, ndego Mbumbukiam geveatav.” ");
INSERT INTO kvg_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Até nakhag ezoqám-a, otøotam me꞉vewém, waen khaqain-qape etoam-qa vømbōgonem. ");
INSERT INTO kvg_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Yaq āv gimbøe-einím nqǽgo, “Qo Zu ezoqam-ge kawa toqogoat, qakeza kha qókhandí.” ");
INSERT INTO kvg_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Teqa kawa-te, ova ndo꞉go, manqat ndøtøkeém. Āv qane-peaupám nqǽgo, “Ngenek Zu ezoqam-gé kawá.” ");
INSERT INTO kvg_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Pepen ezoqa nøme, ndego namba gi꞉tøkebupam, Yesu otøotam me꞉veó, gembo-ein, “Gê, qo Mesayâ? Av tægoat ndægo, qo qakeza kha qókhandí neka ni voqó-khandī꞉n.” ");
INSERT INTO kvg_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Geté ndego pepen ezoqa nøme, namba gi꞉tøkebupam, gègugú, gembo-ein, “Gê, qo ndakin yaq-fia nqosøgeap kopo ndoqote-ndapet, av ngenek nge꞉ndapet, qo Mbumbukiam-te møe mbaîn? ");
INSERT INTO kvg_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ni nqanek yaq-fia nqosøgeap, nikeza manqa-zapa zapayá qazindapét. Geté ngenek ezoqam, manqa-zapa-qase goneáv.” ");
INSERT INTO kvg_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Yaq ngenek pepen ezoqam, Yesu gembo-ein, “Yésu. No gènøndo-matøvém, qo kawa iz toqomøndap.” ");
INSERT INTO kvg_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yaq Yesu gembo-ein, “No unimanqatín nqataqa-manqate. Nqægo khøuwa, qo no namba, Paladais manqei-té qazígoát.” ");
INSERT INTO kvg_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Yaq khøuwa ande av muin qandap, qamat atema khagus 3 oklok vø̄ndap, manqei ate qægoam, bøivun ndønqeivøém. ");
INSERT INTO kvg_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Khøuwa waev sègembo-navøém. Neka ndabua ndøgo, Mbumbukiam-qa khoev mokho-te qafaleam, sège-keqavát. Livin-mbá qanumu-qatavát. ");
INSERT INTO kvg_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yaq Yesu kandambaqapé sege-akhá, “Tát! Noge nqova, qoqá zenda-té qatøveét.” Ndego nqanek manqat gumu-ein, yaq gènaním. ");
INSERT INTO kvg_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yaq ndego nakhag kawa ezoqam, nqanek matev geqeiv, ndego Mbumbukiam-qá iz ndø-eqá, ge-ein, “Unimanqatín. Ngenek ezoqam ndaføyamba-qapé.” ");
INSERT INTO kvg_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Yaq ezoqa ewaqape, matev qeivi-qa gindupindam, matev ndøgo giqeivim, qafakhanumat, ndigu savi mba ndøqambubám, sasa ndøzav. ");
INSERT INTO kvg_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ezoqa ewaqape, ndigu Yesu gi꞉zøtez, ande qámbá gindu-waniapam. Até ndigú-a, sakheis, ndigu Yesu gimbo-pavavun, Gelili plovins-te ginduzav, matev vø̄qeivim. ");
INSERT INTO kvg_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Yaq nqáe! Ezoqa kopo mø̀ndøgoám. Teqa iz Zoséf. Alimatea vemiav-ák. Ndego Zu ezoqam-qá manqa ovøyam megeat ezoqá nømé. Ndego ezoqa mbomambaqapé neka ndaføyamba-qapé. ");
INSERT INTO kvg_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Mbumbukiam-qá Megeat Matev-qa mo꞉kewagám. Ta khøuwa-te ndøgo, Zu megetapak nøme, manqat gikopo꞉nem, Yesu tilaem, ndego tiqa manqat unimanqatinteáv. ");
INSERT INTO kvg_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yaq ndego Pailøt-té genøwáv, Yesu-qa kha-qa yaq-te vømømbō-viam. ");
INSERT INTO kvg_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Yaq gembotak, Zosef até gendego, Yesu vø̄koqoiu, tae mutui-te getøkewam, ndabua sasa me꞉løvønøvem, nandi nqa manqei-pakha-te vømø̄-utav. Ta manqei-pakha ndøgo, nandi giløotøzem, bugukhokhof løvøte ezoqa utøveáv. ");
INSERT INTO kvg_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ta khøuwa ndøgo, Sabat gigiap khakheinam khøuwá. Yaq Sabat khøuwa avønín qagoám, tøngaz. ");
INSERT INTO kvg_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Sakheis ndigu, Yesu gimbo-pavavun, Gelili plovins-te ginduzav, ndigu Zosef gèmbo-paevém, nandi nqa manqei-pakha vø̄qeivim, neka Yesu-qa kha āv kimī-utøvem. ");
INSERT INTO kvg_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Yaq khoev-te givesez, tae nanga etet sisip mbomømboma møkhakheinømém. Yesu-qá kha-te gɨam nonqó. Geté Sabat khøuwa é-møndøngáz. Yaq ndigu gèqovezát, av Mozes-qa guguna manqat qæ-ein. ");
INSERT INTO kvg_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Yaq Sande qanaqanus, lovølova-ús. Ndigu sakheis manqei pakha-té ginøzáv, tae etet sisip mbomømboma vø̄-upøgim, Yesu-qa kha-te gɨam nonqo gikhakheinumat. ");
INSERT INTO kvg_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Yaq manqei-pakha-te gimøfakhaz, āv giniqeivím nqǽgo: Nandi ndigu nqa qætokam, gèqambiním. ");
INSERT INTO kvg_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Geté ndigu gi-oz, Yesu-qa kha qeiviáv, ndego Evezøza. ");
INSERT INTO kvg_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ndigu ate av-té matavap gimbøe-aumat, yaq nqáe! Tiqa avønin-te, ezoqa menas sègefakház. Tiqa ndabua bøi sanqatøve-ús. ");
INSERT INTO kvg_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Yaq ndigu sakheis, møe kandambá gigonem. Bøi manqei-té ginøvøogím. Geté ndigu ezoqa menas gindu-einim, “Gekha zapâ, nqanek løvøte ezoqam-qa manqei-te, khandi ezoqam-qa ndozovawet? ");
INSERT INTO kvg_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ngenek mbaín, nqanek. Mø̀ndø-khandí꞉v. Tozombó-matavap, manqat ndøgo gezø-ein, zo namba Gelili plovins-te gegoam? ");
INSERT INTO kvg_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ndego āv gene-eín nqǽgo, ‘Ezoqam-ge Yo, manqa-zapazapa-us ezoqam-qá zenda-té giabenø-veém, neka tae mutui-te bētøkewem. Geté khøuwa timømbo-misika-ez ndøgo, ndego nqawa ndø̀khandí꞉v.’” ");
INSERT INTO kvg_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yaq ndigu sakheis, nqawa tinø-matøvemém ndǿgo, av Yesu manqat gezømbe-manqatam. ");
INSERT INTO kvg_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Yaq taon-té ginøqaváz, Yesu-gi paev ezoqa ileven neka paev ezoqa nøme, manqat vømøzø̄-ein. ");
INSERT INTO kvg_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Sakheis ndigu, Yesu-gi u-anim manqat gizø-ein, ngínik: Meli, ndugu Magdala vemiav-ák, neka Zoanā, neka Meli nømu, ndugu Zems-gu evo, neka sakheis nøme vø̄goam, ti namba. ");
INSERT INTO kvg_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Geté ndigu paev ezoqam, sakheis-qa manqat gèqavotøvém. Ti-te ndigu, tiqa manqat, mokho mbaín. ");
INSERT INTO kvg_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Geté Pita até gendego, manqei ozu-té genøteít. Yaq nandi nqa mokho-te gemø-fakhanam, ndego ndabua mba ndøqeív. Ezoqam mbaín. Yaq nangó genøqaván. Matavap mba ndø-aumát, ande gekha matev me ndø̄fakhan. ");
INSERT INTO kvg_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yaq nqáe! Ta khøuwa kopo-te ndøgo, Yesu-gi paev ezoqa menas nøme, Emaus vemiav-té ginø-apát. Yaq Zelusalem taon-a, yaq Emaus vemiav, taqa atap ande āv ileven kilomitá ndægó. ");
INSERT INTO kvg_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nakhoa-te gi꞉-apat, manqat ndǿgo tini-manqatát, matev ate ndægo, ande āv khanēfakhan. ");
INSERT INTO kvg_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ndigu ate av-té, nakhoa gi꞉geveat, manqat vø̄manqatat-a, matavap vø̄-aumat, yaq Yesu ndowáv, namba sasa me꞉zav. ");
INSERT INTO kvg_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Geté ndigu matavapøteáv, ndego. ");
INSERT INTO kvg_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yaq Yesu gèzøbeváp, “Zo gekha manqat zøté-manqatet, nqanek nakhoa nqazo-geveet?” Yaq ndigu sègewán. Avus-mba zøvøovøém. ");
INSERT INTO kvg_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yaq ezoqa kopo, iz nqambogo Kleopas, āv gembøe-eín nqǽgo, “Ezoqa ewaqape mokho-te, Zelusalem taon-te gipindam, qo mbá atoqogó, emanqat yogeav ndoqogo, matev ndøgo qafakhan, ndakin khøuwa-te.” ");
INSERT INTO kvg_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yaq Yesu gezøbevap, “Gekha matēv ndǿfakhan?” Yaq gindu-qavøinam, “Yesu-qá manqat niti-manqatét, ndego Nazalet vemiav-ak. Ndego Mbumbukiam-gé manqa vevezam ezoqam ndøgoám. Teqa manqat neka matev bazaføgakh kandambá. Ezoqam nekā-e, Mbumbukiam, ndego eqeieqei me꞉vewám. ");
INSERT INTO kvg_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Geté Mbumbukiam-gi iziz ezoqa kandakanda neka nigi kawakawa-za nøme, Lom gaman ezoqam-qá zenda-té ginøveém. Yaq tìabiti-laém. Yaq ndigu tae mutui-té ginø-tøkewém. ");
INSERT INTO kvg_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Geté ni āv qati-matavupám nqǽgo: Ezoqam ategó ndego, ni Izlael ezoqam tenqovotan. Geté matev viní qafakhan. Ndakin khøuwa mø̀ndømø-misika-éz, nqanek matev qafakhan. ");
INSERT INTO kvg_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Neka nøme nqánek: Nigi sakheis nøme, nqova nindáf. Nqægo qanaqanus, manqei-pakha-te gi-apat, ");
INSERT INTO kvg_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ndigu teqa kha qeiviáv. Yaq ndigu ginduqavaz, āv ginimbi-eín nqǽgo, ‘Ni umingiap niqeivím. Enzol ezoqam nizømét. Neka ndigu enzol ezoqam, āv ginimbi-eín nqǽgo, ndego mø̀ndø-khandí꞉v.’ ");
INSERT INTO kvg_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Yaq nigi ezoqa nøme ndøzáv, manqei-pakha-te ndøgo. Yaq matev āv timiqeivím, av sakheis gi꞉manqatam. Geté ndigu ometeáv, ndego.” ");
INSERT INTO kvg_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yaq Yesu ndigu ezoqa menas gezø-ein, “Ge zô, mokho ndapeâv? Zo zuā zøté-bevupit, manqat ate ndægo, Mbumbukiam-gi manqa vevezam ezoqam gi꞉manqatam? ");
INSERT INTO kvg_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Neka gê, zo mokho ndapeâv, av nqægo, Mesaya ndego, nqosøgeap betøkhæ-ndáp, yaq váev iz kandambaqape temøndap.” ");
INSERT INTO kvg_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yaq Yesu Mbumbukiam-qá Manqat zø-ovøyám, manqat ate ndægo, ekezan-qa yaq-te ndøpeawap. Mozes-té genøngáz, qamat, atema manqat ate ndægo, Mbumbukiam-gi manqa vevezam ezoqam gimbøe-manqatam. ");
INSERT INTO kvg_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yaq ndigu Emaus vemiav gi꞉khatoat, yaq Yesu bugug āv gene-kewagám nqǽgo: Segē-gegevēt. ");
INSERT INTO kvg_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Geté ndigu āv gimbøe-viømém nqǽgo, “Qo ní namba bizi꞉gú. Gèkhagustét. Avønín gépøís.” Yaq Yesu namba me꞉záv, tiqa khoev-te vømø̄qonav. ");
INSERT INTO kvg_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yaq ti namba lou loge-te giqonavam, Yesu flawa ndøndapáz, Mbumbukiam ike manqat vømbō-ein, sasa ndømbegim, vø̄zø-etoam. ");
INSERT INTO kvg_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Yaq ndigu bøi fea mba ndøkewág. Yesu khæ gèmatøvemém. Geté nqova mbaín, ndego tiqa bøi-te, sègezømbo-navøém. ");
INSERT INTO kvg_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Yaq ndigu ekeza mokho-mba gi-einim, “Unimanqatín. Niqa mokho-te, andé gøinam me me꞉wageapám, Yesu nakhoa-te manqat gini-manqatam, neka Mbumbukiam-qa Manqat-qa mokho vø̄enømand.” ");
INSERT INTO kvg_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Yaq ndigu paev ezoqa menas, até gindigonem, Zelusalem taon-té ginøveséz, Yesu-gi u-anim ileven neka paev ezoqa nøme vø̄zømet, giwambupam. ");
INSERT INTO kvg_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Yaq ndigu, ndigu ezoqa menas āv gizømbe-eín nqǽgo, “Unimanqatín. Yesu mø̀ndø-khandí꞉v, løvøte-te. Saemon-té gemøfakhán.” ");
INSERT INTO kvg_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Yaq ate ndigu paev ezoqa menás-a, emanqat vøzømbē-votot, matev ande āv khazømbē-fakhan, ndøgo nakhoa-te, neka yaq ndigu Yesu ande āv kinī-matøvemem, flawa gembegim, gezø-etoam. ");
INSERT INTO kvg_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ndigu ezoqa menas, ate av-té manqat gi꞉manqatam, yaq nqova mbaín, Yesu sègefakhán, ti mokho-te, gezø-ein, “Sambí, zo-te.” ");
INSERT INTO kvg_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Geté ndigu nqova zøndáf neka møe kandambá. Āv gini-matavupám nqǽgo: Ngenek nqovā. ");
INSERT INTO kvg_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Geté Yesu gezø-ein, “Gekha zapâ, zo nqova qazøndaf? Neka gekha zapâ, zo ndozoto-nakeapet? ");
INSERT INTO kvg_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Zenda tokhotapak neka geagim nonqo zonømbé-qeivīm. Ezoqa nó. Kha zonǿ-khanøzømém. Yaq zo ndø̀zøte-zøtéz, av nqægo, no uni ezoqam-anim-ín. Nqova ndigu, bazag neka kha mbaín, av zo no ndakin nqazøte-nømende.” ");
INSERT INTO kvg_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yesu nqanek manqat gumu-ein, yaq ndego teqa zenda tokhotapak neka geagim nonqo me꞉zømás. ");
INSERT INTO kvg_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ndigu khanakhanakh kandambá neka óu gimbo-matavupat. Geté ndigu zua me꞉nakát. Yaq Yesu gezø-ein, “Zo lou loge nonqo tøzǿgo, tælog?” ");
INSERT INTO kvg_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Yaq ndigu até gindigonem, zonga-kha vesu vømbó-etøomem. ");
INSERT INTO kvg_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yaq Yesu gèndáp, tiqa bøi-te ndøgo, vø̄log. ");
INSERT INTO kvg_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yaq Yesu gezø-ein, “No zo namba qazi꞉goam, mø̀ezø-manqatám, av nqægo: Matev ate ndægo, noqa yaq-te, Mozes-qa guguna manqat-te neka Mbumbukiam-gi manqa vevezam ezoqam-qa peawap-te neka Sams mokho-te ndøpeawap, sà befakhanám.” ");
INSERT INTO kvg_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Yaq Yesu gè꞉zømesím, ndigu Mbumbukiam-qa Manqat mokho bembøē-ndapem, ");
INSERT INTO kvg_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","gezø-ein, “Manqat āv qane-peawáp nqǽgo: Mesaya nqosøgeap kandambaqape bendáp, vǿnanīm. Geté khøuwa timømbo-misika-ez ndøgo, ndego nqawa ndø̀khandí꞉v, løvøte-te. ");
INSERT INTO kvg_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Yaq teqa iz-te, bawabawan ate ndægo, manqat āv tiabiti-zømesím. Ndigu Mbumbukiam-té giabenø-qambúz neka yaq ndego tiqa manqa-zapazapa vøzǿ-evøzām. Zelusalem taon-té giabenø-ngazém, nqanek. ");
INSERT INTO kvg_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Zo matev ate ndægo, zøkeza bøí qazøte-qeivám. Yaq zo ezoqa zømé-zømesím. ");
INSERT INTO kvg_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nqáe! No zo Mbumbukiam-qá bazaføgakh nozøndó-khofotáv, av noge Tat, manqa mbusa ge꞉ve. Zo nqanek Zelusalem taon-te, até vøgó, atema nqanek bazaføgakh vozóndapēm, ndøgo yan-te tøndovis.” ");
INSERT INTO kvg_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yaq khøuwa nøme, Yesu ekeza paev ezoqam, Zelusalem taon bavokhó genø-itúb, Betani vemiav avønin-te vømø̄fakhaz. Yaq ndego zenda ndø-eqá, vøzø̄-guligulim. ");
INSERT INTO kvg_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Yaq ate av-té gezømbe-guligulimat, ndego sògo-zivatát. Mbumbukiam yan-té genø-eqeitát. ");
INSERT INTO kvg_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Yaq ndigu katuk ndømøkuí, vømbō-vizumem, Zelusalem taon-te sasa ndøqavaz. Ndigu khanakhanakh kandambá. ");
INSERT INTO kvg_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Yaq ndigu khøuwa ate qæpavpavemam, Mbumbukiam-qá khoev-té gigoám, Mbumbukiam-qa iz vø̄-eqatam. ");
INSERT INTO kvg_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ibugukhokhof, manqei-qape khakheinøpøteav qagoam, Manqat ndøgo, oskia ndøgoám. Nqanek Manqat Mbumbukiám namba me꞉goám, neka ndøgo Mbumbukiám. ");
INSERT INTO kvg_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ngenek ezoqam, ngenek Manqat nqago, ndego Mbumbukiam namba oskia ndøgoám, ibugukhokhof, atema ndakin. ");
INSERT INTO kvg_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Mbumbukiam gigiap ate nqægo, te mokho-té genø-khakheinumát. Gigiap kopo mbaín, ndego te mokho-te khakheinøpøteav qagoam. ");
INSERT INTO kvg_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Te mokho-te, khandi ndøgoám. Neka nqanek khandi, ezoqam-qá wáev. ");
INSERT INTO kvg_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nqanek waev bøivun-té qanuwaév. Yaq bøivun, kopømba mbaín, nqanek waev vǿe-khoutāv. ");
INSERT INTO kvg_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Yaq ezoqa ndowáv. Mbumbukiam ndokhofotáv. Teqa iz Zión. ");
INSERT INTO kvg_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ndego ezoqa zømesim-qa ndøgeavún. Waev-qá yaq-té gené-zømesím. Yaq te mokho-te ndego, ezoqa ewaqape, tìabiti-unimanqatiním. ");
INSERT INTO kvg_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Zion ndego ekezan, wáev mbá. Ndego ezoqa waev-qa yaq-te zømesim-qa mba ndøgeavún. ");
INSERT INTO kvg_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ta waev ndøgo, unimanqatin wáev. Ezoqa ewaqape-té qanøwá. Nqanek waev, manqei-qape-té qanøfakhán. ");
INSERT INTO kvg_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ngenek ezoqam, ndego Manqat ndøgo, ndego manqei-qape-té gegoám. Ta manqei-qape, te mokho-té qando-fakhán. Geté manqei-qape ezoqam, gèbi꞉nám. ");
INSERT INTO kvg_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ndego ekeza ezoqam-té genøgeavún. Geté ndigu khatoweáv. ");
INSERT INTO kvg_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Geté gekha ezoqām ndigu, gikhatowem neka ndego vø̄-unimanqatinim, ndego iz zø-etoám. Ndigu kopømbá, gemø-Mbumbukiam-gí-nakheis-éz. ");
INSERT INTO kvg_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nginik ambá av nqǣgo, evøndipakha-qā kouk-tē o kha-qā poev-tē o zivis-qā poev-tē ginøqāz. Geté Mbumbukiam mokho-té ginøqáz. ");
INSERT INTO kvg_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nqanek Manqat gèmø-ezoqam-év, ni namba vizimīyag. Ni teqa bazaføgakh neka waev mø̀iqeivím. Ndøgo Yo kopo-qá bazaføgákh neka wáev. Eve-té qandowáv. Te mokho-te, kuku matev neka unimanqatin manqat, mø̀ndømø-tøvá. ");
INSERT INTO kvg_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Zion ndégo tene-manqatám. Teqa yaq-te, ndego āv gene-akhá nqǽgo, “Ezoqam ngének, no qate-manqatam av nqægo: Ndego ezoqam, noqa zita-te tegeav, ndego no ùnime꞉-løvumbám. Zapa ndǿgo, no qaneav qagoam, ndego até gegoám.” ");
INSERT INTO kvg_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Teqa kuku matev-te, te mokho-te qamu-tøva, ni ezoqa ate nqazi꞉gu, kuku matev oskia zi-upøgimatún, miavmiav. ");
INSERT INTO kvg_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mozes mokho-te, Mbumbukiam guguna manqat ni-etoám. Geté Yesu Keliso mokho-te, kuku matev neka unimanqatin manqat ndofakhán, ni-te. ");
INSERT INTO kvg_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ezoqa kopo Mbumbukiam ometeáv. Geté tege Yo kopo, ndego ekezán, Mbumbukiám. Neka ndego Evé namba me꞉yagé. Ngének, gini-ovøyám, teqa yaq-te. ");
INSERT INTO kvg_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Zu megetapak, Zelusalem taon-te ndøgo, Mbumbukiam-gi iziz ezoqam neka Livai ezoqam ndøkhofotáz, Zion-te, vømømbō-bevøpem, av nqægo, “Gê, qo gekha ezoqâm?” ");
INSERT INTO kvg_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yaq Zion, ndego naopøteáv. Sègezø-eín, “No Mesayá mbá.” ");
INSERT INTO kvg_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Yaq ndigu gimbo-qavøinam, “Av tægoat ndægo, qo gekha ezoqâm? Ilaizâ?” Yaq Zion gezø-qavøiu, “Mbaín. No Ilaizá mbá.” Yaq gimbo-bevøpem, “Gê, qo Mbumbukiam-gê manqa vevezam ezoqàm, ni nqazimbøe-keoge?” Yaq ndego gendo-qavøiu, “Mbaín. No teoká ndego.” ");
INSERT INTO kvg_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Yaq ndigu gimbo-einim, “Av tægoat ndægo, yaq qo gekha ezoqâm? Ni qavøiwat manqat batikhæ-ndapém, ni tømizømas, ndigu, ni ma gindi-khofotan. Gê, qo qakezan-qa yaq-te gekhā qoté-manqate?” ");
INSERT INTO kvg_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yaq Zion gezø-ein, “No ndégo, ezoqam-qá manqa wág, leg-av manqei-te ndø-akhayam, av nqægo, ‘Evezøza-qa nakhoa é-mozoto-khakheinám.’ Av Aezaya, ndego Mbumbukiam-ge manqa vevezam ezoqam, ge꞉peawam.” ");
INSERT INTO kvg_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ti mokho-te ndigu, Zu megetapak gindu-khofotaz, nøme Felisi ezoqám. ");
INSERT INTO kvg_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Yaq ndigu Zion gimbo-bevøpem, “Qo Mesaya neka Ilaiza neka Mbumbukiam-ge manqa vevezam ezoqam goneav ndoqogo, yaq qo gekha zapâ, ezoqa ibøkha iz ndoqozø-etoam?” ");
INSERT INTO kvg_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yaq Zion gendo-qavøiu, “No ezoqa ibøkha iz, ibøkhá qazømbe-etoám. Geté zo mokho-te, ezoqam ngêgó. Zo ndego zø̀tezøtezák. ");
INSERT INTO kvg_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ezoqam ndégo, noqa zita-te ngegeav. Ndego no ùnime꞉-løvumbám. No ezoqa khàpe nøte-khapelavøqase-én. Até nqanek sasae khapelavøqasé-a, no teqa tamak khofoe-te tæmbotøke, no kopømba mbaín.” ");
INSERT INTO kvg_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nqanek matev, Betani vemiav-té qafakhán. Zoden kea yaq-keoqá, ta manqei ndøgo, Zion ezoqa ibøkha iz gezø-etoumam. ");
INSERT INTO kvg_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Yaq khøuwa nøme qandopave, Zion Yesu ndø-omét. Te-té genømát. Yaq Zion ezoqa āv gezømbe-eín nqǽgo, “Ndé! Mbumbukiam-gé Sip Nakhasám. Ngenek manqei-qape ezoqam-qá manqa-zapazapa ndǿndáp. ");
INSERT INTO kvg_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ezoqam ngének, no qate-manqatam av nqægo, ‘Noqa zita-te, ezoqa ndø̀geáv. Ndego no ùnime꞉-løvumbám. Zapa ndǿgo, no qaneav qagoam, ndego até gegoám.’ ");
INSERT INTO kvg_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","No bugukhokhof ngenek nøtenateáv. Geté no qægeavun, ezoqam ibøkha iz nqazø-etoam, no nqánek qatøndenáv, Izlael ezoqam gí꞉zøtéz, ezoqam ngének.” ");
INSERT INTO kvg_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yaq nqanek matev-qa yaq-te, taqa zita-te qafakhan, Zion ezoqa āv gezømbe-manqatám nqǽgo, “No āv qateqeív nqǽgo: Yan-te nqo꞉go, Nqova Mbomambaqape ndovís. Andé kuvøkuvuam me me꞉løvuvavún, te-te vō꞉qom. ");
INSERT INTO kvg_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","No bugukhokhof nøtenateáv, ndego gekha ezoqām. Geté Mbumbukiam, ndego no gendo-khofotan, ezoqa ibøkha iz tæzø-etoumat, āv genenømánd nqǽgo, ‘Qo ezoqam toqo-omet, Nqova Mbomambaqape te-te ndego tendovis, yaq te-te vó꞉qōm, ezoqam nándev. Ndego ezoqa ibøkha iz, Nqova Mbomambaqape-té genøzǿ-etoumát.’ ");
INSERT INTO kvg_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","No mø̀eqeív, nqanek matev. Yaq no nò-unimanqatintét, av nqægo, ndego Mbumbukiam-gé Yó.” ");
INSERT INTO kvg_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Yaq khøuwa nøme qandopave, Zion manqei kopo-te ndøgo, nqawá genø-itán. Ekeza paev ezoqa menás namba me꞉goám. ");
INSERT INTO kvg_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yaq Zion Yesu ge-omet, gegeavun, ndego āv gene-eín nqǽgo, “Ndé! Mbumbukiam-gé Sip Nakhasám.” ");
INSERT INTO kvg_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yaq ndigu Zion-gi paev ezoqa menas, nqanek manqat giyogem, até gindigonem, Yesu vømbō-paevem. ");
INSERT INTO kvg_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yaq Yesu gendoqambun, gezømet, gimbopavam, ndego āv gezømbe-beváp nqǽgo, “Zo gekham-qā zóvawet?” Yaq gindu-qavøinam, “Lábai, qo gekham-tē qoqó-qomat?” (Labai, taqa manqa mokho, “Nømendim ezoqám.”) ");
INSERT INTO kvg_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yaq gendo-qavøiu, “Zøtøndézāv. Zomǿqeivím.” Yaq ndigu namba me꞉záv, vø̄qeivim, ma ge꞉qotam ndøgo. Ndøgo khagús. Khøuwa iz ande āv 4 oklók ndægó. Yaq ndigu Yesú namba me꞉goát, ate khøuwa vømø̄sinan. ");
INSERT INTO kvg_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ndigu ezoqa menas, Zion-qa manqat giyogem, yaq Yesu gimbo-paevem, ezoqa nøme Endlú. Saemon Pita-gé namba qawán. ");
INSERT INTO kvg_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Endlu Yesu ge-ivav, yaq até gendego, ekeza namba qawan-qa møváo, Saemon, vø̄-omet, gembo-ein, “Ni Mesaya ni-ometám, ndego Mbumbukiam manqa mbusa geve, tendo-khofotav.” (Nqanek manqat, Mesaya, Glik manqat-te, Keliso mbo-akhayám.) ");
INSERT INTO kvg_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Yaq ndego Yesu-té genø-itú. Yesu Saemon ge-omet, yaq āv gembøe-eín nqǽgo, “Qo Saemon, Zion-ge yo, iz Sifas qá-akhaemát.” (Sifas neka Pita, ndøgo mokho kopó, nandí.) ");
INSERT INTO kvg_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Yaq khøuwa nøme qandopave, Yesu matavap āv genegó nqǽgo: Gelili plovins-té qatǿnáv. Ate av-té ge꞉mat, yaq ezoqam ndø-omét. Teqa iz Filíp. Yaq āv gembøe-eín nqǽgo, “No qonøndó-páev.” ");
INSERT INTO kvg_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip, ndego Betsaida vemiav-ák. Até Endlu neka Pitá-ya, vemiav kopó. ");
INSERT INTO kvg_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Yaq Filip Natanael ndø-omét. Gembo-ein, “Ni ndégo tei-ometám, Mozes neka Mbumbukiam-gi manqa vevezam ezoqam gi꞉peaomem, teqa yaq-te. Ndego iz nqambógo, Yesú. Zosef-gé yó. Nazalet vemiav-ák.” ");
INSERT INTO kvg_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Geté Natanael gendo-ein, “Gê, Nazalet vemiav-te, matev qanimav kopo ndǿfakhan? Géfakhanák.” Yaq Filip gendo-qavøiu, “Qotøndéqāv. Qakeza qó-omét.” ");
INSERT INTO kvg_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu Natanael ge-omet, gegeavun, yaq teqa yaq-te āv gene-eín nqǽgo, “Ngé! Ngenek unimanqatin Izlael ezoqám. Te mokho-te, khavozam mbaín.” ");
INSERT INTO kvg_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Yaq Natanael Yesu gembobevap, “Ge qô, no áv khoqotéqateq?” Yaq Yesu gendo-qavøiu, “Filip qo okhokho-té genøqa-eín. No é-møeqamékh, fig tae guzuguzu-te qoqoqotam.” ");
INSERT INTO kvg_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Yaq Natanael gembo-qavøiu, “Nøméndim ezoqam. Qo unimanqatín Mbumbukiam-gé yó. Qo ni Izlael ezoqam-gé kawá.” ");
INSERT INTO kvg_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yaq Yesu gendo-qavøiu, “Qo ndǿgo toqote-unimanqatín, no av qataqambe-ein nqægo, ‘No ē-møeqamēkh, fig tae guzuguzu-te qoqoqotam.’ Geté qo matev uni kandakanda-in nøme ndòqoqeivít.” ");
INSERT INTO kvg_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yaq Yesu manqat nøme gembo-ein, “No unimanqatín nqazø-manqate. Zo yan mboqoat zóqeivím. Yaq Mbumbukiam-gi enzol ezoqam segé-vesendát, Ezoqam-ge Yo-te vǿevisīt neka vǿe-qavigīt.” ");
INSERT INTO kvg_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yesu Filip neka Natanael gezø-akha, timbopavat, yaq khøuwa menas-qa zita-te, ezoqa kopo sævam ndø-okɨ́. Keina vemiav-té, ndøgo Gelili plovins-te. Yesu-gu evo mø̀ndøgoám, ndøgo lou loge-te. ");
INSERT INTO kvg_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Neka ate Yesú-a, tegi paev ezoqa namba, vøzø̄-akha, lou loge-te ndøgo. ");
INSERT INTO kvg_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Yaq waen gùmu-navøém, ta lou loge-te ndøgo. Yesu-gu evo ndøgo matev guqeiv, yaq tunøwáv ndǿgo, Yesu vømømbō-ein, “Ezoqa waen nøme mbaín. Mø̀ndømu-navøém.” ");
INSERT INTO kvg_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yaq Yesu gendo-qavøiu, “Évo. Qo gekha zapâ, nqanek manqat ndoqonø-manqate? Nogi khøuwa khantøzateáv. Zuá.” ");
INSERT INTO kvg_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Geté Yesu-gu evo, ndigu lou loge tøke ezoqam, āv guzømbe-eín nqǽgo, “Gekha manqāt ndøgo, tezø-ein, sègembo-paevém.” ");
INSERT INTO kvg_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ta khoev-te ndøgo, ibøkha ziøvem nonqo kandakanda mø̀ndø-asazám. Ate qægoam síks. Mbaqambaqá gini-khakheinømém. Ndøgo Zu ezoqam-qá kha sunguzam matev nonqó. Kha ti꞉sunguzat, yaq Mbumbukiam-qa bøi-te gé꞉-ndaføyamba-éz. Ibøkha ziøvem nonqo kopokopo-te, kopømba ande āv 100 litás ndægó. ");
INSERT INTO kvg_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yaq Yesu ndigu lou loge tøke ezoqam gezø-ein, “Nqanek ibøkha ziøvem nonqo ate nqægo, ibøkhá qazøté-tøtøvøemém.” Yaq ndigu ibøkha mu꞉qouzømém, até vømø̄-tøtøvøyam. ");
INSERT INTO kvg_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yaq Yesu nøme gezø-ein, “Ibøkha-qase vø̀takhaém. Yaq tozombó-etøomém ndégo, ma lou loge-te nde꞉megeat.” Yaq ndigu até gindigonem, ibøkha-qase vømømbō-etøomem, ");
INSERT INTO kvg_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","yaq ndego lou loge megeat ezoqam vø̄ekhamas. Geté ta ibøkha ndøgo, ibøkha ziøvem nonqo-te qøugoam, mø̀ndø-qambúi, vømø̄-waen. Ndego otevateáv, nqanek waen gekham-tē qanø̄geavun. Geté ndigu tøke ezoqam, ibøkha ma gindi-takhaemem, mø̀ndæzøtéz. Yaq ndego lou loge megeat ezoqam, ndégo tembo-akhá, sævam ndakin ge-okɨ, ");
INSERT INTO kvg_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","vømbō-ein, “Ezoqa waen giyogimatun, bugukhokhof waen eqeieqei-qape, fia kandakanda ndøyogememɨ́n. Yaq ezoqa kawa qazø-okɨin, waen fia khapelavøqase zøyogemɨ́n. Geté qo waen eqeieqei-qape, sòqo-mendewát, atema ndakin.” ");
INSERT INTO kvg_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu teqa umingiap matanam matev, nqánek genøngáz, Keina vemiav-te, Gelili plovins-te. Ta mokho-te ndøgo, ndego ezoqa āv genezømás nqǽgo: Teqa bazaføgakh kandambá neka teqa iz, tò꞉-eqavét. Yaq tegi paev ezoqam matev giqeivim, ndigu gè-unimanqatiním ndego. ");
INSERT INTO kvg_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Taqa zita-te, Yesu, evo neka namba-qaniap neka tegi paev ezoqa namba, Kapenaum taon-té ginøzáv. Yaq khøuwa elavøqasi timø-khoubím ndǿgo. ");
INSERT INTO kvg_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Zu ezoqam-qa khøuwa kandambaqape, Pasova, avønín qagoám. Yaq Yesu Zelusalem taon-té genøqavíg. ");
INSERT INTO kvg_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yaq Mbumbukiam-qa khoev uta-te gemø-on, ndego ezoqa tezømét ndǿgo. Ndigu kao neka sip neka kuvøkuvu ndøwiát, neka ezoqa nøme, lou-qasis-té giqonavát. Moni ndø-enendtát. ");
INSERT INTO kvg_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yaq Yesu até gendego, ezoqa febam nonqo ndøløvønáz, yaq ndigu ezoqam vø̄ngeasam, bavokho, tigi kao neka sip namba, neka moni enend ezoqam, moni mokho vøzø̄-nqagivem, lou-qasis sasa zøqambugim. ");
INSERT INTO kvg_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Yaq ezoqam ndigu, kuvøkuvu giwiat, ndego āv gezømbe-eín nqǽgo, “Gigiap mòzo-upøgím! Mòzofakház! Noge Tat-qa khoev, kopømba mbaín tozo-enendem, vømǿ-gigiap-wi-nonqo-khōev.” ");
INSERT INTO kvg_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yesu nqanek matev gematanam, yaq tegi paev ezoqam timbo-matøvømém ndǿgo. Mbumbukiam-qa Manqat, āv qane-peawáp nqǽgo, “No poev khàpe nømbe-khouwév, qoqa khoev-te. Ndøgo no mbøni nølóg.” ");
INSERT INTO kvg_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yaq Zu megetapak, Yesu āv gimbøe-bevøpém nqǽgo, “Ge qô, gekha umingiap matev qómatanām, ni vøtínøtēn av nqægo, qo iz akhaē, nqanek matev ndoqo-matønumit?” ");
INSERT INTO kvg_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yaq Yesu gendo-qavøiu, “Mbumbukiam-qa khoev nqanek, vø̀-evøzømém. Yaq khøuwa misika mokho-te, no nqawa ndæ̀wév.” ");
INSERT INTO kvg_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Geté ndigu gindu-qavøinam, “Nqanek khoev giwevat, viav foti-síks giniwevát. Yaq gê, qo khøuwa misika mokho-te, áv khoqotéwēv? Nakhoa mbaín!” ");
INSERT INTO kvg_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Geté Yesu Mbumbukiam-qa khoev ge꞉-ein, ndego ekeza kha me꞉-eín. ");
INSERT INTO kvg_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Vaev-te, Mbumbukiam Yesu løvøte-te nango ge꞉khandi꞉v, tegi paev ezoqam, teqa manqat gèmbo-matøvemém. Yaq ndigu Mbumbukiam-qa Manqat vø̄-unimanqatinim-a, Yesu-qa manqat vø̄-unimanqatinim. ");
INSERT INTO kvg_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu Zelusalem taon-te gegoam, ndøgo Pasova khøuwa kandambaqape qamat, yaq ezoqa kopoáv gè-unimanqatiním, umingiap matev giqeivam, gematønumam. ");
INSERT INTO kvg_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Geté Yesu ekezan, unimanqatinteáv, ndigu ezoqam. Zapa ndǿgo, ndego ezoqa ewaqape mø̀ndæ-otév. ");
INSERT INTO kvg_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ezoqa te-te manqat einiav tøgoat, ezoqa nøme-qa yaq-te, ndøgo kopømbá. Zapa ndǿgo, ndego ezoqam-qa matavap, é-møndæ-otevɨ́n. ");
INSERT INTO kvg_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Zu megeat ezoqam mø̀ndøgoám. Iz nqambógo. Nikodemús. Ndego Felisi ezoqám. ");
INSERT INTO kvg_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Yaq khøuwa nøme, lová, Yesu-té genøwáv, vømømbō-ein, “Nøméndim ezoqam. Ni mø̀tinøtén. Qo Mbumbukiam ndokhofotáq, ni toqote-nømendimat. Ezoqa kopømba mbaín, umingiap matev tematanam, av qo ndoqote-matanam, getē Mbumbukiam te namba te꞉goat.” ");
INSERT INTO kvg_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yaq Yesu gembo-qavøiu, “No unimanqatín nqataqa-manqate: Ezoqa kopømba mbaín, Mbumbukiam-qa Megeat Matev temøqeiv, getē ndego nqawa teqan.” ");
INSERT INTO kvg_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Yaq Nikodemus gendo-ein, “Gê, ezoqa temu-khouwev, nqawa áv kenéqān? Kopømba mbaín, evo-qa emu-te nqawa te-on, yaq nqawa sasa ndǿqān.” ");
INSERT INTO kvg_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yaq Yesu gembo-qavøiu, “No unimanqatín nqataqa-manqate: Ezoqa kopømba mbaín, Mbumbukiam-qa Megeat Matev-te te-on, getē ndego ibøkha-te neka nqova-te teqan. ");
INSERT INTO kvg_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ezoqa geqanɨn, ndego ezoqam-té gendo-fakhanɨ́n. Geté yage ndakinak nqova-te, Nqova Mbomambaqape-té qandowavɨ́n. ");
INSERT INTO kvg_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Qo nqova betaqànda᷄f, qataqa-ein av nqægo, qo nango vø̀qāq. ");
INSERT INTO kvg_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Khamøe ndǿgo tønø-feaɨ́n, av ekezan tømbøe-pøovet. Qo, a, ndòqombo-ewagát. Geté qo qotéqateqák, āv khandē-feaɨn o āv khanēfetet. Yaq ezoqam-qa yaq-te, ndigu Nqova Mbomambaqape-te, yage ndakinak gindapem, matev até kopó.” ");
INSERT INTO kvg_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Yaq Nikodemus gendobevap, “Gê, matev av nqægo, áv khanégo?” ");
INSERT INTO kvg_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yaq Yesu gendo-qavøiu, “Gê, qo Izlael ezoqam-ge nømendim ezoqam ndoqogo, qo qateqateâv, taqa yaq-te? ");
INSERT INTO kvg_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","No unimanqatín nqataqa-manqate. Matev ndøgo, ni ezoqa nqeizømbe-manqate, ni mø̀tinøtén. Neka ni nqati-zømesim ndøgo, ni mø̀iqeivím. Geté zo niqa manqat upøgimáv. ");
INSERT INTO kvg_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Zo noqa manqat unimanqatinteav qagoam, no manqei-qape matev-qa yaq-te qazømbe-manqatam, gê, zo noqa manqat áv khazøté-unimanqatinīm, no yan-qa matev-qa yaq-te, manqat tæzømbe-manqatat? ");
INSERT INTO kvg_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ezoqa kopo yan-te qavigiáv. Yan-te nqo꞉go, sa ndégo tegoám, ndego yan-te gendovis. Ezoqam-gé Yó. ");
INSERT INTO kvg_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mozes leg-av manqei-te, auli wazeam ge-eqeiu, tae-te vø̄tøkeo, yaq Ezoqam-ge Yo āv tiabiti-eqeinám. ");
INSERT INTO kvg_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Yaq ta matev mokho-te, gekha ezoqām ndego, Ezoqam-ge Yo te-unimanqatin, khandi miavmiav ndǿndáp. ");
INSERT INTO kvg_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Mbumbukiam ni manqei-qape ezoqam, teqa kuku matev kandambaqape, āv gininømánd nqǽgo: Ndego ekeza Yo kopo ni-etoám. Yaq gekha ezoqām ndego, te-unimanqatin, ndego soqaqape géqeivák, geté khandi miavmiav ndǿndáp. ");
INSERT INTO kvg_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Mbumbukiam ekeza Yo, nqanek manqei-qape-te, ambá ta zapaya ndø̄go tendē-khofotav, manqei-qape ezoqam, manqa ovøyam-tē genǿ-āb. Geté ndǿgo tende-khofotáv, manqei-qape ezoqam, te mokho-te gékhandí꞉z. ");
INSERT INTO kvg_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ezoqam ndego, Yo nde-unimanqatinat, ndego yaq-fia nqosøgeap géqeivák. Geté ezoqam ndego, unimanqatinteav ndego, teqa yaq-te Mbumbukiam mø̀ndø-eín, ndego soqaqape ndǿqeív. Zapa ndǿgo, ndego Mbumbukiam-ge Yo kopo unimanqatinteáv. ");
INSERT INTO kvg_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mbumbukiam ezoqa yaq-fia nqosøgeap ta zapaya nqánek gezømbé-etoám: Waev mø̀ndø-geavún, nqanek manqei-qape-te. Geté ezoqa poev bøivun-té qazøgoám, ambá ndøgo, waev-te. Zapa ndǿgo, tiqa matev matanam soqaín. ");
INSERT INTO kvg_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Unimanqatín. Gekha ezoqām ndego, matev soqøsoqa ndematanam, ndego waev gèmbøeqasí꞉v. Ndego waev-te fakhanumáv. Zapa ndǿgo, ndego poeveáv, teqa matev soqøsoqa tevøndaz. ");
INSERT INTO kvg_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Geté ezoqam ndego, matev eqeieqei ndematanam, ndego waev-té gendo-fakhanɨ́n. Yaq ezoqa āv giníqeivát nqǽgo: Ndego matev, Mbumbukiam-qá mokho-té genø-matanám.” ");
INSERT INTO kvg_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Taqa zita-te, Yesu ekeza paev ezoqa namba Zudia plovins-té ginøzáv. Yaq ti namba khøuwa elavøqasi timø-khoubím ndǿgo, neka ezoqa ibøkha iz vømøzø̄-etoam. ");
INSERT INTO kvg_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Até Zión-a, ezoqa ibøkha iz vøzø̄-etoumam. Aenon manqei-té gezø-etoumám, Salim vemiav avønin-te. Zapa ndǿgo, ibøkha kandambá qaqonavam, ta manqei-te ndøgo. Yaq ezoqa kopoáv tinø-okhoám ndǿgo, ibøkha iz vø̄ndapemɨn. ");
INSERT INTO kvg_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Ta khøuwa-te ndøgo, Zion ndimbula-te utøveav ndøgoám. Zuá.) ");
INSERT INTO kvg_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yaq manqa itumbam ndøfakhán, Zion-gi paev ezoqa nøme neka Zu ezoqa kopo. Kha sunguzam matev-qá yaq-té gini-itumbám, toqote-ndaføyamba-eq Mbumbukiam-qa bøi-te. ");
INSERT INTO kvg_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Yaq ndigu Zion-té ginøzáv, vømømbō-einim, “Nøméndim ezoqam. Ndego ezoqam, qo namba Zoden kea yaq-keoqa qazøtegoam, teqa yaq-te manqat qoqote-manqatam, nqáe! Ndego ndakin ezoqa ibøkha iz zø-etoumít neka ezoqa ewaqape te-té tinø-apét.” ");
INSERT INTO kvg_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yaq Zion gezø-qavøiu, “Qanimáv. Ezoqa kopømba mbaín, matev tendap, vǿgō, Mbumbukiam ndego etopøteav tøgoat. ");
INSERT INTO kvg_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Zo zøkezan mòzoyogém, ndøgo manqat, no av qate-ein nqægo, ‘No Mesayā mbā. Getē Mbumbukiam no bugukhokhof ndokhofotān. No nakhoa nombo-khakheinumīt’. ");
INSERT INTO kvg_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ezoqa sævam te-okɨ, ndugu tegú sævám. Tege zifu segembóyát. Yaq ndego teqa manqat te-ewag, ndego khanakhanakh mbá genégoát. No ndakin até kopó, noqa khanakhanakh mø̀ndømø-tøvá. ");
INSERT INTO kvg_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yesu ndego yà bekhouwév. Geté no yà banø-khapelavøqase-én. ");
INSERT INTO kvg_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ezoqam ndego ova gendovis, ndego ùnime꞉-løvubám, ezoqa nøme ate ndi꞉gu. Geté ezoqam ndego, manqei-qape-te gendowav, av no nqate꞉go, ndego manqei-qape ezoqám neka ndego manqei-qape-qá manqat mba me꞉manqatatún. Geté ndego yan-te gendovis, ndego ezoqa ewaqape mø̀ndø-løvubám. ");
INSERT INTO kvg_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ndego manqat ndǿgo tene-manqaté, ndego bøi vø̄e-qeivam-a, gea vø̄e-ewagam. Geté ezoqa teqa manqat upøgimáv. ");
INSERT INTO kvg_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Geté gekha ezoqām ndego, teqa manqat gendap, ndego āv gene-unimanqatinát nqǽgo: Mbumbukiam-qa manqat unimanqatín. ");
INSERT INTO kvg_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ndego ezoqam, Mbumbukiam gendo-khofotav, ndego Mbumbukiam-qá manqat ndømanqaté. Mbumbukiam ekeza Nqova mbo-etoám. Kandambá gembo-etoam. Khapelavøqasé mbá. ");
INSERT INTO kvg_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Eve kukú Yo-te. Ndego gigiap neka matev ate ndægo, teqá zenda-té genø-áo. ");
INSERT INTO kvg_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ezoqam ndego, Yo nde-unimanqatinat, ndego khandi miavmiav ndømbôgó. Geté ezoqam ndego, Yo-qa manqat o-mba ndapeav ndøgo, ndego khandi géqeivák. Mbumbukiam-qa qaqa, oskia ndǿgoát te-te.” ");
INSERT INTO kvg_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Felisi ezoqam āv giniyogém nqǽgo: Ezoqa kandambá, Yesu-té ginønøzáz, ibøkha iz vøzø̄-etoam. Ndigu ezoqa mø̀ndø-løvubám, ndigu ezoqam, Zion ibøkha iz gezø-etoumam. ");
INSERT INTO kvg_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Geté unimanqatín, Yesu ekezan, ezoqa ibøkha iz etopøteáv. Ekeza paev ezoqam mba zø-etoumám, ibøkha iz.) ");
INSERT INTO kvg_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu nqanek manqat ge-ewag, gimanqatam, ndego Zudia plovins gè-iváv. Yaq ekeza paev ezoqa namba, Gelili plovins-té ginøveséz. ");
INSERT INTO kvg_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yaq nakhoa ndøgo gegeveat, Samalia manqei mokho-té sugu꞉-apát, ");
INSERT INTO kvg_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","yaq Samalia manqei-te ndøgo, vemiav nøme-te vømø̄fakhaz. Taqa vemiav iz Siká. Manqei ndøgo, ibugukhokhof Zekop tege yo Zosef gembo-etoam, avønín qagoám. ");
INSERT INTO kvg_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ndøgo Zekop-qá ibøkha ozu ndø-ozám. Yaq ande av khøuwa muin ndægo, Yesu gèmbo-ewéz, ge꞉geavun. Yaq ibøkha ozu-té genøwáv, vømø̄qom. ");
INSERT INTO kvg_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Yaq geqotam ndøgo, Samalia sævam ibøkha takhae-qa ndowáv. Yaq Yesu ndugu sævam gumbo-ein, “Ambá ibøkha qonø-etoamɨ́n. Nǿ-íz.” ");
INSERT INTO kvg_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Tegi paev ezoqam, vemiav-té ginø-apát. Lou loge nonqo wi-qa ndøzáv.) ");
INSERT INTO kvg_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yaq ndugu Samalia sævam gundu-qavøiu, “Qo Zu ezoqám. Geté no Samalia sævám. Gekha zapâ, no ibøkha manqat nqoqonø-manqate?” Ndugu nqanek manqat gu-ein, zapa ndǿgo: Zu ezoqam neka Samalia ezoqam, tøkuatáv. ");
INSERT INTO kvg_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yaq Yesu gumbo-qavøiu, “Qo amba Mbumbukiam-qa etoam matev toqote-qateqɨn, neka voqotē-qateqɨn, ngenek gekha ezoqām, qo ibøkha manqat ngeqa-manqate, yaq qo ambá qombo-viamɨ́n, yaq ngenek ambá khandi ibøkha qa-etoamɨ́n.” ");
INSERT INTO kvg_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Yaq ndugu sævam gumbo-qavøiu, “Khanánqa. Qo ibøkha takhayam nonqo mbaín neka ibøkha nqanek mø̀ndøsiná. Qámbá ndøndovaev. Gê, qo gekham-tē qoqótakhā, nandav khandi ibøkha? ");
INSERT INTO kvg_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nqanek ibøkha ozu, nigi atanakha-zapa Zekop ni-etoám. Ndego nqanek ibøkha ekezan ndølogám, tegi nakheis neka tegi søvakha gigiap nanak namba. Yaq gê, qo ndego Zekop qóløvu?” ");
INSERT INTO kvg_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yaq Yesu gumbo-qavøiu, “Gekha ezoqām ndego, nqanek ibøkha te-izumat, ndego ibøkha naq nango ndø̀mbopáp. ");
INSERT INTO kvg_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Geté gekha ezoqām ndego, nqanek ibøkha te-iz, no tæmbo-etoam, ndego ibøkha naq nango gembópapák. Geté nqanek ibøkha, no tæmbo-etoam, te mokho-te andé kea kumbutøve me mé꞉goát. Yaq ndøgo oskia ndómbatát, neka khandi miavmiav vømbó-etoām.” ");
INSERT INTO kvg_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Yaq ndugu sævam gundu-qavøiu, “Khanánqa. Nandav ibøkha nandoqote-manqate, gènø-etoám. Yaq no ibøkha naq nango genǿpapák, neka no ibøkha takhaemav tàbategó, nqanek ibøkha ozu-te.” ");
INSERT INTO kvg_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yaq Yesu gumbo-ein, “Qanimáv. Vø̀khæqáv, qeivis vømøndō-khato.” ");
INSERT INTO kvg_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Yaq ndugu gundu-qavøiu, “No anganeam mbaín.” Yaq Yesu gumbo-ein, “Qo unimanqatín ndoqo-manqate, av nqægo, ‘No anganeam mbaīn.’ ");
INSERT INTO kvg_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Qo angana fáev, qoqozø-qonumat. Yaq ndego anganeam, qo ndakin namba nandoqote-yage, ndego uni qeivis-ín mbá. Manqat ndøgo, qoqo-ein, unimanqatín.” ");
INSERT INTO kvg_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Yaq sævam gundu-ein, “Khanánqa. No ndakin mø̀tenøtén, qo Mbumbukiam-gé manqa vevezam ezoqám. ");
INSERT INTO kvg_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nigi Samalia atanakha-zapazapa-za, Mbumbukiam-qa iz, ta olol-te nqánek gimbo-eqatám. Geté zo Zu ezoqam, āv qazøte-manqaté nqǽgo, ‘Ezoqa Mbumbukiam-qa iz, Zelusalem taon-te mbá giabe-eqawát.’” ");
INSERT INTO kvg_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yaq Yesu gumbo-ein, “Ngólam! Noqa manqat vø̀-unimanqatín. Khøuwa nqâgeáv. Yaq ta khøuwa-te ndøgo, zo nqanek olol-te o Zelusalem taon-te zóqavigák, Tat-qa iz vozomǿ-eqanēm. ");
INSERT INTO kvg_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Zo Samalia ezoqam zøtezateáv, zo gekha ezoqam-qā iz zō-eqawat. Geté ni Zu ezoqam mø̀tinøtén, gekha ezoqam-qā iz nī-eqawat. Zapa ndǿgo, Mbumbukiam-qa ezoqa khandi꞉zat matev, Zu ezoqam-té qando-okhó. ");
INSERT INTO kvg_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Geté khøuwa nqágeav. Unimanqatín. Khøuwa mø̀ndø-fakház. Yaq gekha ezoqām ndigu, Tat-qa iz uni ti꞉-eqatat, ndigu Nqova Mbomambaqape mokho-té neka unimanqatin-té ginǿ-eqatát. Mbumbukiam-qa iz eqawat ezoqam eqeieqei av ngí꞉gu. Tat ezoqam av ngí꞉gu gezøvawét. ");
INSERT INTO kvg_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mbumbukiam ndego Nqová. Gekha ezoqām ndigu, Mbumbukiam-qa iz ti-eqatat, ndigu Nqova Mbomambaqape mokho-té neka unimanqatin-té giabenø-eqawát.” ");
INSERT INTO kvg_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yaq ndugu sævam gundu-ein, “No mø̀tenøtén, Mesaya ndø̀fakhán, ndego Keliso ndimbo-akhayam. Yaq tefakhan, ndego ni matev ate nqægo génømendimát.” ");
INSERT INTO kvg_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yaq Yesu gendo-qavøiu, “No nándev, ndakin manqat ngeqa-manqate.” ");
INSERT INTO kvg_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yesu ndugu Samalia sævam namba, ate av-té manqat gi꞉manqatam, yaq ekeza paev ezoqam tīnø̄fākhāz. Yaq ndigu nqova zøndáf, gi-ometam, ngunuk sævam namba manqat gimanqatam. Geté ndigu ezoqa kopo, manqat einiáv te-te, av nqægo, “Gekhā qápoev, tu-te?” ó “Gekha zapâ, nandu manqat namba ndoqotē-manqatet?” Mbaín. ");
INSERT INTO kvg_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Yaq ndugu sævam, tuqa ibøkha takhayam nonqo sège-iváv. Yaq taon-té gunøwáv, ezoqa vømøzø̄-ein, ");
INSERT INTO kvg_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Zøtøndézāv. Ezoqa zó-ometám. Ndego no matev ate qægoam, qæmatønumam, sègenø-vøndazát. Éisa, ndego Mesayâ, penømakhaya?” ");
INSERT INTO kvg_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Yaq ndigu até gindigonem, taon vø̄-ivøvem, Yesu-te sasa ndøzav. ");
INSERT INTO kvg_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ndugu sævam gui-ewawam, Yesu-gi paev ezoqam āv gimbøe-pouwém nqǽgo, “Nøméndim ezoqam. Lou mòqológ.” ");
INSERT INTO kvg_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Geté Yesu gezø-qavøiu, “No lou nqanø̂gó, tælog. Geté ta lou ndøgo, zo zøtezateáv.” ");
INSERT INTO kvg_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Yaq tegi paev ezoqam, ekeza mokho-mba gibond, “Éisa? Ezoqa lou pømbøé-ndapavun-a?” ");
INSERT INTO kvg_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yaq Yesu gezø-ein, “Noqa lou nqánek: No teqá poev matev nógó, ndego ma gende-khofotan, neka teqa sasae vǿekhōu, ma genømbe-etoam. ");
INSERT INTO kvg_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Zo āv qazøte-manqatatún nqǽgo, ‘Løvøyak foa mba mu꞉yozá. Yaq avøe zindúpeá.’ Geté no nqazǿ-manqate: Gèqeiví. Avøe gigiap mø̀ndømu-umiá. Kopømbá. Zotøndó-peá. ");
INSERT INTO kvg_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Unimanqatín. Até ndakín-a, sasae ezoqam avøe gigiap ndøpe꞉tét, neka yaq-fia ndīndāpēt. Ta avøe gigiap ndøgo, ndipewat, ndøgo ezoqám. Yaq ndigu khandi miavmiav mǿndapém. Yaq ezoqa ndigu vǿ-ogeakhāt-a, vøndó-peanēm, ndigu khanakhanakh sugumú-ndapém. ");
INSERT INTO kvg_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Taqa yaq-te, nqanek manqat unimanqatín, ezoqa av gi꞉manqatatun nqægo: Ezoqa nøme gè-ogeakhɨ́n, neka ezoqa nøme vøndō-peaɨn. ");
INSERT INTO kvg_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","No zo avøe gigiap pewat nonqo nokhofotáz. Ta avøe ndøgo, zo zøkezan ogekhæáv. Ezoqa vini ndø-ogeákh. Zo nango nangó sozotø-peaɨ́n.” ");
INSERT INTO kvg_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ta taon-te ndøgo, Samalia ezoqa kopoáv, Yesu gè-unimanqatiním. Ndigu tini-unimanqatiním ndǿgo, sævam av guzømbe-ein nqægo, “Ndego no matev ate qægoam, qæmatønumam, sègenø-vøndazát.” ");
INSERT INTO kvg_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yaq ndigu Samalia ezoqam, te-te gifakhaz, āv gimbøe-viømém nqǽgo, “Elavøqase vø̀khæqóm nqanek, ni-te.” Yaq Yesu namba me꞉sokhoám. Khøuwa menás. ");
INSERT INTO kvg_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Yaq Yesu ge꞉zømesimam, ezoqa kopoav nøme mba mo꞉-unimanqatiním. ");
INSERT INTO kvg_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Yaq ndigu, ndugu sævam āv gimbøe-einím nqǽgo, “Ni ndakin ambá ta-mba ndø̄go tøti-unimanqatinīm, manqat ndøgo, qo qoqonimbi-ein. Geté ni manqat nikezan nimboyogém neka ni mø̀tinøtén, ngenek unimanqatín manqei-qape ezoqam-gé khandi etoam ezoqám.” ");
INSERT INTO kvg_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu khøuwa menas gumukhoub, Samalia manqei-te geqotam, gewav, yaq nakhoa até gegeveát, atema Gelili plovins-te. ");
INSERT INTO kvg_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Yesu bugukhokhof ekezan, manqat āv gene-eín nqǽgo, “Ekeza manqei-te, ezoqa Mbumbukiam-ge manqa vevezam ezoqam vizupáv.”) ");
INSERT INTO kvg_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Geté Yesu ndakin Gelili plovins-te gemøfakhan, ndigu khanakhanakh mbogoném. Zapa ndǿgo, Yesu Pasova khøuwa kandambaqape-te, Zelusalem taon-te gegoam, até ndigú-a, mø̀ndøgoám ndøgo, neka teqa matev ate qægoam vø̄qeivim, ndøgo gematønumam. ");
INSERT INTO kvg_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yaq Gelili plovins-te ndøgo, ndego nqawa Keina vemiav-té gemøwáv. Ta vemiav ndǿgo, ibugukhokhof ibøkha ge-enend, vømø̄-waen. Ta khøuwa-te ndøgo, Kapenaum taon-te, gaman ezoqam mø̀ndøqotám. Tege yo, enqoni kandambaqape ndøqeív. ");
INSERT INTO kvg_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Yaq ndego eve, ge-ewag av nqægo, Yesu Zudia plovins mø̀ndø-ivāv, yaq Gelili plovins-tē gegō, ndego tenøwáv ndǿgo, vømømbō-ein, “Ambá Kapenaum taon-tē qotøndo-qavɨ̄n. Noge yo qomǿ-khakheinøvém. Ndego avønín é-ndønaním.” ");
INSERT INTO kvg_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yaq Yesu gembo-ein, “Zo umingiap matev qeivi-qa mba zogó. Geté zo qeiviav tøgoat, zo no zó-unimanqatinimák.” ");
INSERT INTO kvg_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Geté ndego gaman ezoqam gendo-qavøiu, “Khanánqa. Vø̀ndoqáv! Soqaín ndøgo, noge yo é-ndo꞉naním.” ");
INSERT INTO kvg_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yaq Yesu gembo-ein, “Qanimáv. Qo vø̀qáv. Qoge yo géyagét.” Yaq ndego ezoqam, Yesu-qa manqat gè-unimanqatín, sasa ndøwav. ");
INSERT INTO kvg_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ndego ate av-té ge꞉mat, yaq nakhoa livin-te ndøugu, tegi sasae ezoqam ndozáv, vømbō-einim, “Qoge yo, enqoni mø̀ndømbo-navøém. Gèyagét.” ");
INSERT INTO kvg_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Yaq ndego gezøbevap, “Gê, enqoni gekha khøuwa iz-tē qanømbó-navøem?” Yaq āv gindi-qavøinám nqǽgo, “Ngusu tatas enqoni, nømøkhaiya, khaiya wan oklók qanømbo-navøém.” ");
INSERT INTO kvg_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Yaq ndego eve tenø-matøvém ndǿgo. Tege yo gekhandi꞉v, até ta khøuwa iz-té ndǿgo, Yesu manqat gembo-ein, av nqægo, “Qoge yo gēyagēt.” Yaq ndego, ekeza ezoqa namba ate gi꞉goam, khoev-te gimboyagam, tini-unimanqatiním ndǿgo. ");
INSERT INTO kvg_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesu Zudia plovins gende-ivav, Gelili plovins-te ge-okhoam, yaq umingiap matev gematanam, ta manqei-te ndøgo, ndakin gèmbo-menás. ");
INSERT INTO kvg_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Taqa zita-te, Zu ezoqam-qá pindap khøuwa kandambaqape ndøgoám. Yaq até Yesú-a, Zelusalem taon-te vø̄qavig. ");
INSERT INTO kvg_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Zelusalem taon-te ndøgo, kewan-qasi ndîgú. Taon mboqog ndigu, Sip mboqog ndimbo-akhayam, avønin-té gigú. Iblu manqat-te, nginik kewan-qasi-qa iz, Betesda mbo-akhayám. Yaq nginik kewan-qasi-te, lou-qasis ndøløvøtupám. Fáev qaløvøtupam. Kewan-qasi mba ndøkhøogavát. ");
INSERT INTO kvg_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ta lou-qasis-te ndøgo, enqoni-us ezoqa mo꞉sømbiapát. Kopoav-qapí. Nøme ndigu, bøi waev mbain ezoqám, neka nøme ndigu, kagi ezoqám, neka nøme ndigu, kha zøwauwauám. ");
INSERT INTO kvg_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Yaq enqoni-us ezoqa nøme mø̀ndøgoám. Ndego enqoni nupøkhán mbá qambogo. Viav 38́. ");
INSERT INTO kvg_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu ngenek ezoqam ge-omet, geqeiam, ndego mø̀ndæ-otév, ngenek enqoni nupøkhán mbá qambogo. Yaq Yesu āv gembøebeváp nqǽgo, “Gê, qo eqeieqeiqat-qa qógo?” ");
INSERT INTO kvg_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yaq ndego enqoni-us ezoqam gendo-qavøiu, “Khanánqa. No eqeieqeinat-qa nqæ̂gó. Geté no ezoqam mbaín, ibøkha-te vǿendapān, ibøkha wa tøqavat. No bafe-qa tøtegoat, ezoqa nøme é-møndøbafɨ́n.” ");
INSERT INTO kvg_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yaq Yesu gembo-ein, “Ság. Mòqo-itán, kita vø̄khazo, okho sasa ndøngaz!” ");
INSERT INTO kvg_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Yaq nqova mbaín. Ndego ezoqam, sège-eqeieqei-év, kita vø̄khazo, okho sasa ndøngaz. Ta khøuwa-te ndøgo, matev qafakhan, Sabat khøuwá. ");
INSERT INTO kvg_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yaq Zu megetapak, ndego ezoqam gekhakhæv, āv gimbøe-einím nqǽgo, “Nqægo khaiya, Sabat khøuwá. Khafeáp nandav, Sabat khøuwa-te, kita nandoqo-ndapavet.” ");
INSERT INTO kvg_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Geté ndego gezø-qavøiu, “Ndego ezoqam, no gekhakheinømbem, āv genømbe-eín nqǽgo, ‘Kita vø̀khazó, okho sasa ndøngaz!’” ");
INSERT INTO kvg_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Yaq gimbo-bevøpem, “Ndego gekha ezoqâm, geqa-ein av nqægo, ‘Kita vø̀khazō, okho sasa ndøngaz!’?” ");
INSERT INTO kvg_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Geté ndego ezoqam, ge-eqeieqei-ev, otevateáv. Zapa ndǿgo, Yesu é-møndøwáv. Yaq gèmbøe-navøém. Ezoqa khàpumu-khouwéz, ta manqei-te ndøgo. ");
INSERT INTO kvg_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Vaev-te, Yesu ndego ezoqam, enqoni qambogoam, Mbumbukiam-qá khoev-té ge-omét, gembo-ein, “Nqáe! Qo ndakin mòqo-eqeieqei-éq. Geté manqa-zapa matanam qó-iváv. Soqaín ndøgo, matev soqaqape nøme mba tømøqa-fakhan.” ");
INSERT INTO kvg_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Taqa zita-te, ndego ezoqam, Zu megetapak-té genøwáv. Yaq āv gemezømás nqǽgo, “Ezoqam ndego, no gekhakheinømbem, Yesú.” ");
INSERT INTO kvg_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yesu Sabat khøuwa-te, matev av nqægo gego, yaq Zu megetapak, ngi꞉wat matev ndøngazém, te-te. ");
INSERT INTO kvg_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Geté Yesu āv gezømbe-eín nqǽgo, “Noge Tat oskia ndøsasaeát. Até ndakín-a. Yaq até nó-a, no oskia nosasaeát.” ");
INSERT INTO kvg_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesu nqanek manqat ge-ein, yaq ndigu Zu megetapak, qaqa nøme mba zømboløwáz. Yaq ambá gelaemɨ́n. Zapa ndǿgo, ndego ambá av nqǣgo, Sabat khøuwa khafeap mba ndønqawá. Geté ndego Mbumbukiam ekeza eve me꞉veó. Yaq av nqægo, ndego ekezan, Mbumbukiám namba sugumu-víam. ");
INSERT INTO kvg_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Taqa yaq-te, Yesu āv gezømbe-eín nqǽgo, “No unimanqatín nqazø-manqate. Yo kopømba mbaín, ekeza mokho-mba, matev tematanam. Ndego sa ndǿgo tématønumát, av Eve nde-omete, ndematanam. Eve ande āv kené-matanām, Yo āv tené-matanám. ");
INSERT INTO kvg_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Eve kukú Yo-te. Ndego matev ate ndægo mø̀ndæ-ometimatún, av ekezan nde꞉matanam. Yaq ndego matev kandakanda nøme mba mó꞉-ometimít. Ndøgo ndø̀mø-løvuám, av ndakin qazøte-qeivim. Yaq zo nqova zǿndafát, matev tozo-qeivimat. ");
INSERT INTO kvg_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kopømba ande av eve, løvøte ezoqam ndetiæzoat neka khandi ndēzø̄-ētōām, até Yó-a, ezoqa khandi zǿ-etoumát, av ekezan ndømbøe-poev. ");
INSERT INTO kvg_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Neka nøme nqánek: Eve ndego, ezoqam-qa manqa ovøyam yogeapáv. Geté manqa ovøyam matev ate ndægo, Yo-qá zenda-té genøvé. ");
INSERT INTO kvg_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Mbumbukiam tenegó ndǿgo: Ezoqa Yo āv tiabembøe-vizáp, av Eve ndimbøe-vizap. Gekha ezoqām ndego, Yo vizøpøteav tøgoat, ndego até Evé-a, gembó-vizapák, ndego Yo gendo-khofotav. ");
INSERT INTO kvg_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","No unimanqatín nqazø-manqate. Gekha ezoqām ndego, noqa manqat te-ewagat neka ndego vǿ-unimanqatintāt, ndego no gendo-khofotan, ndego khandi miavmiav mø̀ndøndáp. Ndego yaq-fia nqosøgeap gemǿndapák. Geté ndego løvøte mø̀ndø-iváv, khandi vø̄ndap. ");
INSERT INTO kvg_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","No unimanqatín nqazø-manqate. Khøuwa nqágeav. Yaq ta khøuwa-te ndøgo, løvøte ezoqam, Mbumbukiam-gé Yo-qá manqat ndǿyogém. Yaq gekha ezoqām ndigu, tiyogimat, khandi ndǿndapemát. Nginik khøuwa mø̀ndø-fakház. ");
INSERT INTO kvg_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Av Eve ekeza mokho-te khandi ndømbøego, ndego até Yó-a, khandi mø̀ndømbo-etoám. Yaq até Yó mokho-té-a, khandi ndø̂ugú. ");
INSERT INTO kvg_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Eve até manqa ovøyam matév-a, Yo-qá zenda-té genøvé. Zapa ndǿgo, ndego Ezoqam-gé Yó. ");
INSERT INTO kvg_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Zo nqova bezø̀nda᷄f, taqa yaq-te. Khøuwa nqâgeáv. Yaq løvøte ezoqam ate ndi꞉gu, tiqa manqei ozap-te, teqá manqat ndǿyogém, ");
INSERT INTO kvg_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","neka vøndó-fakhāz. Gekha ezoqām ndigu, matev eqeieqei gimatønumam, ndigu tisuz, yaq khandi ndǿndapém. Geté gekha ezoqām ndigu, matev soqøsoqa gimatønumam, ndigu tisuz, ndigu manqa ovøyam-té genǿwán, yaq-fia nqosøgeap vǿndapēm. ");
INSERT INTO kvg_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","No nakhapus-mba, kopømba mbaín, matev kopo tæmatanam. No manqa ovøyam sa ndǿgo tæyogé, av Tat ndenømbe-manqate. Noqa manqa ovøyam matev, eqeieqeí. Zapa ndǿgo, no ambá av nqǣgo, nøkeza poev mba nombopaēv. Geté no teqá poev mba nombopavét, ndego ma gende-khofotan.” ");
INSERT INTO kvg_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yaq Yesu manqat nøme āv gezømbe-eín nqǽgo, “No nøkezan-qa yaq-te manqat tøte-manqatat, yaq ezoqa kopømba mbaín, ti꞉zøtez av nqægo, noqa manqat unimanqatín tøpøtégo-a. ");
INSERT INTO kvg_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Geté ezoqa nøme ndêgó, ndego noqa yaq-te manqat nde꞉manqate. Yaq no mø̀tenøtén, manqat ndøgo, ndego noqa yaq-te nde꞉manqate, unimanqatín. ");
INSERT INTO kvg_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Zo Zion-te, u-anim zokhofotáz. Yaq ndego zo noqa yaq-te, unimanqatin manqat me꞉zømás. ");
INSERT INTO kvg_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Geté no ambá av nqǣgo, manqei-qape ezoqam benøgō, ndego noqa yaq-te, ezoqa te꞉zømesimat. No nqanek manqat sa ndǿgo tæzømbe-eín, zo tø̀ne-khandí꞉z. ");
INSERT INTO kvg_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Zion andé lampa me me꞉goám, ezoqa waev vøzø̄-etoam. Zo elavøqase mø̀ndøzø-gawám, nqanek waev. Khøuwa khapémbá. ");
INSERT INTO kvg_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Geté matev nøme ndø̂gó, noqa yaq-te ndæmanqate. Ta matev ndøgo mø̀ndøløvú, Zion-qa manqat. Matev nqánek, sasae, no Tat genø-etoam, tægo. Matev vinivinimba, no nqæmatanam, ndǿgo tøne-zømesím, av nqægo, no Tat ndokhofotān. ");
INSERT INTO kvg_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Até Tát-a, ndego no ma gende-khofotan, noqa yaq-te, manqat ndemanqâté. Zo teqa manqa wag yogeáv neka bugug qeiviáv. ");
INSERT INTO kvg_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Zoqa mokho-te, teqa manqat mbaín. Zapa ndǿgo, zo ndego unimanqatinteáv, ndego Mbumbukiam gendo-khofotav. ");
INSERT INTO kvg_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Zo Mbumbukiam-qa Manqat mòzo-geve꞉matún. Zapa ndǿgo, zo āv qazøte-matavupatún nqǽgo: Ndøgo zo khandi miavmiav zøtéqeivím. Ta manqat ndøgo, noqá yaq-té qane-manqaté. ");
INSERT INTO kvg_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Geté zo gèzømbo-qasí꞉v, no-te tozotøndozav, khandi miavmiav vozóndapēm. ");
INSERT INTO kvg_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","No ambá av nqǣgo, ezoqam-qa nogō, ndigu noqa iz ti-eqatāt. ");
INSERT INTO kvg_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Geté zo viní. No mø̀tenøtén, zo andē gekha ezoqām. Neka no mø̀tenøtén, zoqa mbøni mokho-te, zo Mbumbukiam-te poev mbaín. ");
INSERT INTO kvg_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","No Tat-qá iz-té qatøgeavún. Yaq zo no zosanqambém. Geté ezoqa nøme, ekeza iz-te tendowav, zo ndòzo-khatowém. ");
INSERT INTO kvg_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Zo no unimanqatinteav ndǿgo tøzøtegó, zoqa poev nqánek. Zoqa iz, ezoqa ndǿ-eqatát. Geté Mbumbukiam zoqa iz te-eqatat, ndøgo zo gèzømbo-qasí꞉v. ");
INSERT INTO kvg_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Geté zo ndømatàva᷄p, av nqægo, ezoqam nō, Tat-qa megemege-te, zoqa manqa tæsøkus. Āv taoká. Geté zoqa manqa, Mozes ndøsøkús, ndego zo ndozoto-vintøzat. ");
INSERT INTO kvg_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Zo Mozes amba uni tøzøte-unimanqatinimin, yaq zo no ndòzo-unimanqatinimín. Zapa ndǿgo, ndego mø̀ndø-peawám, noqa yaq-te. ");
INSERT INTO kvg_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Geté zo teqa manqat unimanqatinteáv. Yaq nakémbá, zo até noqá manqát-a, unimanqatinimáv.” ");
INSERT INTO kvg_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Khøuwa nøme, taqa zita-te, Yesu ekeza paev ezoqa namba, Gelili kewan yaq-keoqá ginøqantáv. Nginik kewan, iz nøme ndimbo-akhayam, Taibelias Kewán. ");
INSERT INTO kvg_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ezoqa bawan-qape até gembopavát. Zapa ndǿgo, ndigu teqa umingiap matev ndøqeivím, enqoni-us ezoqam-te gematønumam. ");
INSERT INTO kvg_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yaq Yesu manqei poyat-té genøqavíg, ekeza paev ezoqam namba, vømø̄qonav. ");
INSERT INTO kvg_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ta khøuwa-te ndøgo, Zu ezoqam-qa Pasova khøuwa kandambaqape, avønín qagoám. ");
INSERT INTO kvg_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yaq Yesu bøi ge-eqa, ezoqa bawan-qape mba mo꞉zømét, gipitavun. Yaq ndego Filip āv gembøe-eín nqǽgo, “Gê, lou gekham-tē qazíwiīm, ezoqa bawan-qape tizi꞉zøkef?” ");
INSERT INTO kvg_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ndego nqanek manqat ge-ein, Filip gè꞉khamás. Geté Yesu é-møndæ-otév, ndego ande āv kenégō. ");
INSERT INTO kvg_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Yaq Filip gendo-qavøiu, “Nakhoa mbaín, lou tizizøwi. Taqa fia khàpumu-khouwév. Ni amba 200 moni mokho tinigunin, kopømba ande av løvøyak eit-qa sasae yaq-fia, yaq até ndøgó-a, kopømba ambá mbaín, lou tiziwi꞉min, nginik ezoqa bawan-qape vizī꞉-zøkefɨn.” ");
INSERT INTO kvg_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yaq tege paev ezoqa nøme, iz nqambogo Endlu, Saemon Pita-ge namba qawan, gendo-ein, ");
INSERT INTO kvg_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Opønakam ngêgó, nqanek. Ndego bali flawa faev neka zonga menas ndimbôgó. Geté ndøgo gigiap khapémbá, ezoqa ewaqape zøkefe nonqo.” ");
INSERT INTO kvg_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yaq Yesu ekeza paev ezoqam gezø-ein, “Ezoqa gèzø-eín, yà beqonáv.” Ta manqei ndøgo, gagayag kopoáv. Yaq ezoqa tinøqonáv ndǿgo. Angana ate gi꞉goam, ande āv faev taosén ndi꞉gú. ");
INSERT INTO kvg_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yaq Yesu até gendego, flawā ge-upø̀zō, Mbumbukiam-te ike manqat vø̄-ein, ezoqa sasa zø-etoam, ndøgo giqonavam. Yaq até zonga-té-a, matev āv tene-matanám. Yaq ezoqa ewaqape lou kandambaqape, āv tinilóg, av ekeza qazømbe-pøovat. ");
INSERT INTO kvg_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Yaq lou gumulog, qazø-ewez, Yesu ekeza paev ezoqam, āv gezømbe-eín nqǽgo, “Lou mbegeap, ezoqa gi-ivøvem, vø̀pizømém. Gigiap-qase bizingiìna᷄m.” ");
INSERT INTO kvg_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Yaq lou mbegeap ndøgo, ezoqa gi-ivøvem, ndigu ta bali flawa løvusap faev-te gilouzim, gèpizumém. Yakhav tuélv ginqeitømem, qamøvea. ");
INSERT INTO kvg_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ezoqa nqanek matev bøi gi꞉qeivim, Yesu gematanam, ndigu āv gini-einím nqǽgo, “Ngenek unimanqatín Mbumbukiam-gé manqa vevezam ezoqám, ndego ni nqazimbøe-keoge.” ");
INSERT INTO kvg_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu gematøvem, av nqægo, ndigu avønīn gendōzāv, ndego vǿndafēm, yaq kawa iz mbō-akhaēm, yaq ndego nango manqei poyat-té genøwáv, vømø̄-yakhapus-mba-ev. ");
INSERT INTO kvg_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Yaq qakhagus ndøgo, Yesu-gi paev ezoqam, pu-té ginø-ová. ");
INSERT INTO kvg_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Yaq khagua-té ginøketáb, vø̄søkuzim. Kewan yaq-keoqá ginø-qantavát. Kapenaum taon-qa mbo-izumát. Ndakin mø̀ndøpǿis. Geté gisøkuzim, Yesu mbaín. ");
INSERT INTO kvg_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Yaq khamøe ndovumá. Khamøe kandakandá qa-okhoam. ");
INSERT INTO kvg_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Yesu-gi paev ezoqam, ande av faev o siks kilomita ndægo gitiamat, yaq Yesu ndø-ometám. Ibøkha mumát genøgeavún. Khagua kha-mba mbo-ovát. Yaq ndigu møe ndøgoném. ");
INSERT INTO kvg_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Geté Yesu gezø-ein, “Nó! Zo møe ndøgòne᷄m.” ");
INSERT INTO kvg_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Yaq ndigu gèmbo-tøkeém, khagua-te vøzømbū-ketao. Yaq nqova mbaín, tiqa khagua, ta manqei-te ndǿgo tømøfakhán, ma gimbøe-pøotat ndøgo. ");
INSERT INTO kvg_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Yaq khøuwa nøme qandopave, ndigu ezoqa ewaqape, kewan yaq-keoqa sa gizuvaz, Yesu-qa ndøvawém. Zapa ndǿgo, ndigu mø̀ndæzøtéz, Yesu tegi paev ezoqam namba gi꞉tiamavun, khagua kopó gini-tiamavún. Yaq tegi paev ezoqam, nqawa giqavaz, Yesu ketøweáv ti-te. ");
INSERT INTO kvg_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ndakin khagua nøme, Taibelias manqei-té qandobøín, ta manqei avønin-te vø̄-aseam, ma Yesu Mbumbukiam ike manqat gembo-ein, yaq ezoqa ewaqape lou vø̄log. ");
INSERT INTO kvg_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Yaq ndigu ezoqa bawan-qape gi꞉zøtez av nqægo, Yesu mbaīn ndøgo, neka atē tegī paev ezoqām-a, mbaīn, yaq ndigu ta khagua-te ndǿgo tinøguvím, Kapenaum taon-te sasa ndøqantam, Yesu vømømbō-vawem. ");
INSERT INTO kvg_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ndigu ezoqam, Yesu gimbovawat, yaq-keoqa gimø-ometam, āv gimbøe-bevøpém nqǽgo, “Nøméndim ezoqam. Qo nqanek gekha khøuwa iz-tē qotégeavun?” ");
INSERT INTO kvg_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yaq Yesu gezø-qavøiu, “No unimanqatín nqazø-manqate. Zo no ta zapaya mba ndǿgo tøzønømbe-vawét, zo lou kandambaqape qazøtelog, até vøzø̄-ewez. Geté ta matev ndøgo, Mbumbukiam zo noqa umingiap matev mokho-te zømesim-qa ndego, zo poev mbaín, taqa mokho tozondapem. ");
INSERT INTO kvg_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Zo lou-qa mbosasàea᷄t ndøgo, sa tølanqayat. Geté ta lou-qa ndǿgo tømbo-sasaeát, lanqalanqaumav ndøgo, neka khandi miavmiav vøzǿ-etoām. Nqanek lou, zo Ezoqam-ge Yo zǿ-etoám. Mbumbukiam, nigi Tat, mbusa ndømøpá te-te, av nqægo, ndego kopømbaqapé, matev tematanam.” ");
INSERT INTO kvg_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Yaq ndigu gimbo-bevøpem, “Gê, Mbumbukiam-qa poev gekhâm? Ni gekha matev nígonēm?” ");
INSERT INTO kvg_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yaq Yesu gezø-qavøiu, “Mbumbukiam-qa poev nqánek: Zo ndégo tozó-unimanqatiním, ndego Mbumbukiam gendo-khofotav.” ");
INSERT INTO kvg_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Yaq ndigu gindu-einim, “Ge qô, gekha umingiap matev qómatanām, ni vǿiqeivīm neka qo vøtí-unimanqatinīm? Gekha qógō? ");
INSERT INTO kvg_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nigi atanakha-zapazapa-za leg-av manqei-te gigoam, mana ndølogám. Taqa yaq-te, Mbumbukiam-qa manqat āv qane-peawáp nqǽgo, ‘Ndego lou zø-etoumám, tiqa loge nonqo. Ta lou ndøgo, yan-té qando-visigimám.’” ");
INSERT INTO kvg_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yaq Yesu gezø-ein, “No unimanqatín nqazø-manqate. Matev ambá av nqǣgo, lou Mozes zø-etoumām, yan-te qando-visigimam. Geté unimanqatin lou, yan-te ndøndo-okho, zo noge Tat zø-etoám. ");
INSERT INTO kvg_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Lou ndøgo, Mbumbukiam ezoqa ndezø-etoam ngének, ndego yan-te gendovis neka manqei-qape ezoqam khandi ndēzø̄-ētōām.” ");
INSERT INTO kvg_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Yaq ndigu gimbo-einim, “Evézøza. Lou av nandægo, ni oskia ni-etoám.” ");
INSERT INTO kvg_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yaq Yesu gezø-qavøiu, “Lou ndøgo, ezoqa khandi ndøzø-etoam, nó. Gekha ezoqām ndego, no-te tendowav, ndego ifi nqawa gembóvinák. Neka gekha ezoqām ndego, no te-unimanqatin, ndego ibøkha naq nqawa gembópapák. ");
INSERT INTO kvg_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Geté no mø̀ezø-eín, av nqægo. Zo no mòzo-nømendám, matev vinivinimba qæmatønumam. Geté zo no unimanqatinteáv. ");
INSERT INTO kvg_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ezoqa ewaqape, noge Tat tenø-etoam, ndigu no-té gindúzáv. Yaq gekha ezoqām ndego, no-te tendowav, no nósanqawák. ");
INSERT INTO kvg_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Zapa ndǿgo, no yan-te ambá ndø̄go tøtøndēvis, nøkeza poev tæmbopavat. Geté no nqánek qatøndevís, no teqá poev nombópavát, ndego ma gende-khofotan. ");
INSERT INTO kvg_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ndego no ma gende-khofotan, teqa poev nqánek: No ezoqa kopo bate-khambùiu᷄, ndigu no genø-etoam. Geté no løvøte-té qabatø-khandí꞉z, vaev khøuwa-te. ");
INSERT INTO kvg_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Noge Tat-qa poev nqánek: Gekha ezoqām ndego, tege Yo-te tekewagat neka ndego vǿ-unimanqatintāt, ndego khandi miavmiav tèabetendáp. Yaq no ndego vaev khøuwa-te nǿkhandí꞉v.” ");
INSERT INTO kvg_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Zu megetapak nqanek manqat giyogem, yaq ndigu manqa ndøgeveømém, teqa yaq-te. Zapa ndǿgo, Yesu āv gene-eín nqǽgo, “Lou ndøgo, yan-te qandovis, nó.” ");
INSERT INTO kvg_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Yaq ndigu gi-einim, “Ngenek Yesu, ndego Zosef-gé yó. Ni mìzi꞉nøtén, tege eve neka evo. Yaq gekha zapâ, av nde꞉manqate, av nqægo, no yan-tē qatøndovīs?” ");
INSERT INTO kvg_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yaq Yesu gezø-qavøiu, “Zo manqa ndøgevèe᷄t. ");
INSERT INTO kvg_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ezoqa kopo kopømba mbaín, no-te tendowav, Tat no-te ituiav tøgoat, ndego no gendo-khofotan. Yaq no ndego ezoqam, vaev khøuwa-te nǿkhandí꞉v. ");
INSERT INTO kvg_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mbumbukiam-gi manqa vevezam ezoqam, āv gini-peaomém nqǽgo, ‘Ezoqa ewaqape, Mbumbukiam ekezan mé꞉zømesím.’ Unimanqatín. Gekha ezoqām ndego, Tat-qa manqat te-ewag neka manqa mokho vǿndāp, ndego no-té gendówáv. ");
INSERT INTO kvg_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Geté unimanqatín. Ezoqa kopo, Tat ometeáv. Ezoqa sa ndégo te-omét, ndego Mbumbukiam-te gendowav. ");
INSERT INTO kvg_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","No unimanqatín nqazø-manqate. Gekha ezoqām ndego, nde-unimanqatinat, ndego khandi miavmiav mø̀ndøndáp. ");
INSERT INTO kvg_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Lou ndøgo, ezoqa khandi ndøzø-etoam, nó. ");
INSERT INTO kvg_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Zogi atanakha-zapazapa-za, leg-av manqei-te ndøgo, mana ndølogám. Geté vaev-te, ndigu gèpakhaetát. ");
INSERT INTO kvg_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Geté lou nqanek, yan-te qandovis, viní. Gekha ezoqām ndego, nqanek lou telog, ndego génanimák. ");
INSERT INTO kvg_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nqanek khandi lou nó, yan-te qandovis. Gekha ezoqām ndego, nqanek lou telog, ndego miavmiav ndǿyagát. Nqanek lou, ezoqa tæzø-etoam, ndøgo noqá khá. Yaq manqei-qape ezoqam, khandi mé꞉ndapém.” ");
INSERT INTO kvg_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yesu nqanek manqat ge-ein, yaq ndigu Zu ezoqam, gèponqombém, gi-einim, “Ngenek ezoqam ekeza kha áv kinimbí-etoām, tizilogem?” ");
INSERT INTO kvg_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yaq Yesu gezø-ein, “No unimanqatín nqazø-manqate. Zo Ezoqam-ge Yo-qa kha logeav tøgoat neka teqa kouk izøpøteav vǿgoāt, zo khandi gezǿgoák, zoqa mokho-te. ");
INSERT INTO kvg_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Gekha ezoqām ndego, noqa kha telog neka noqa kouk vǿ-īz, ndego khandi miavmiav ndǿndáp. Yaq no vaev khøuwa-te ndæ̀khandí꞉v. ");
INSERT INTO kvg_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Zapa ndǿgo, noqa kha unimanqatin lóu, neka noqa kouk unimanqatin ibøkhá. ");
INSERT INTO kvg_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Gekha ezoqām ndego, noqa kha telog neka noqa kouk vǿ-īz, ndego noqá mokho-té gunu꞉gú neka no teqá mokho-té qatu꞉gú. ");
INSERT INTO kvg_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Av no khandi Tat gende-khofotan, neka no te mokho-te nqæyage, yaq matev até kopó. Gekha ezoqām ndego, no teloutan, ndego géyagét, no mokho-te. ");
INSERT INTO kvg_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Lou yan-te qandovis, nqánek. Nqanek lou viní. Āv taoká, av lou ndægo, ndigu atanakha-zapazapa-za gilogam. Vaev-te, ndigu gèpakhaetám. Geté gekha ezoqām ndego, nqanek lou telog, ndego miavmiav ndǿyagát.” ");
INSERT INTO kvg_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu nqanek manqat ndǿgo te-eín, ezoqa Kapenaum taon-te, Zu ezoqam-qa guliguli khoev-te ge꞉zømesimam. ");
INSERT INTO kvg_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ezoqa nøme, Yesu gimbopavam, nqanek manqat giyogem, teqa kha loge-qa yaq-te, yaq ndigu kopoáv, āv gini-einím nqǽgo, “Nqanek manqat mokho mbaín. Áv khazí꞉-ndapēm, teqa manqat?” ");
INSERT INTO kvg_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu é-møndæ-otév, ndigu tegi paev ezoqam, manqa ndøgeveát, teqa manqat-qa yaq-te. Yaq gezø-ein, “Ge zô, nqanek manqat wema zǿmiviz? ");
INSERT INTO kvg_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Av tægoat ndægo. Yaq gê, zo áv khazøté-zæyāz, Ezoqam-ge Yo tozo-ometam, nango teqavig, ma bugukhokhof ge꞉goam? ");
INSERT INTO kvg_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ezoqa khandi, Mbumbukiam-gé Nqova zø-etoám. Kha yakhapus-mba, kopømba mbaín tøkhandi꞉v. Manqat ndøgo, zo qazø-manqatam, ndøgo Mbumbukiam-gé Nqova-ús neka khandi-ús. ");
INSERT INTO kvg_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Geté zo mokho-te, ezoqa nøme no unimanqatinteáv.” Yesu nqanek manqat ge-ein, zapa ndǿgo. Ndego sasae ande ge꞉ngaz, ndego é-møndæ-otév, gekha ezoqām ndigu, te-te unimanqatinteav tigoat neka gekha ezoqām ndego, qaqa ezoqam-qa zenda-te vǿvē. ");
INSERT INTO kvg_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yaq Yesu manqat nøme āv gene-eín nqǽgo, “No nakémbá qazø-ein, av nqægo, ezoqa kopømba mbaīn no-te tinduzav, ndigu noge Tat ituzaeav tøgoat.” ");
INSERT INTO kvg_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ta khøuwa-te ndøgo, Yesu-gi paev ezoqa kandambá, zitá gini-wuowém. Yaq ndigu ndego sekemba paeveáv. ");
INSERT INTO kvg_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yaq Yesu ekeza paev ezoqa tuelv gezøbevap, “Gebâ zo? Até zó-a, ndozó-nøuvønem?” ");
INSERT INTO kvg_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Yaq Saemon Pita gembo-qavøiu, “Evézøza. Gê, ni qo teiqouvøqem, yaq gekha ezoqam-tē qeitǿniāv? Qoqa manqat, ezoqa khandi miavmiav zø-etoám. ");
INSERT INTO kvg_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ni mø̀i-unimanqatiním neka mø̀tinøtén, av nqægo, Ezoqa Ndaføyamba-qape qó, ndego Mbumbukiam gendo-khofotav.” ");
INSERT INTO kvg_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yaq Yesu gezø-qavøiu, “Zo ezoqa tuelv, no nøkezan nøvevesám. Geté zo mokho-te, ezoqa kopo, ndego ezoqa soqaqapé.” ");
INSERT INTO kvg_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesu nqanek manqat, Zudas me꞉-eín. Saemon Iskaliot-gé yó. Yesu-gi paev ezoqa tuelv, nøme ndégo tegoám. Geté vaev-te, ndego sègembo-qambún, qaqa ezoqam-qa zenda-te vø̄ve. ");
INSERT INTO kvg_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Taqa zita-te, Yesu Gelili plovins-té ge-okhoám. Ndego poeveáv, Zudia plovins-te tewav. Zapa ndǿgo, ta manqei-te ndøgo, Zu megetapak, laelae-qa mbogoám. ");
INSERT INTO kvg_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ta khøuwa-te ndøgo, Zu ezoqam-qa khøuwa kandakanda, ndøgo khoev-qasis gipuanumatun, avønín qagoám. ");
INSERT INTO kvg_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yaq Yesu-gi namba-qaniap, āv gimbøe-einím nqǽgo, “Nqanek manqei vø̀-iváv. Zudia plovins-té qonǿqáv. Yaq qogi paev ezoqam, umingiap matev ndǿqeivím, qoqo-matønumatun. ");
INSERT INTO kvg_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ezoqa tømbo-pøovat, ezoqa ewaqape teqa yaq-te ti꞉zøtez, yaq kopømba mbaín, tekhonao. Qo unimanqatin, matev kandakanda ndoqo-matanam, yaq ezoqa ewaqape bèqamekhám.” ");
INSERT INTO kvg_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yesu-gi namba-qaniap, nqanek manqat gi-einim, zapa ndǿgo. Até ndigú-a, ndego unimanqatinteáv. ");
INSERT INTO kvg_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yaq Yesu gezø-ein, “Nogi khøuwa eqeieqei fakhazaneáv. Zuá. Geté zo-te, khøuwa ate ndi꞉gu, eqeieqeí. ");
INSERT INTO kvg_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Manqei-qape ezoqam, kopømba mbaín, zo tisanqabat. Geté ndigu no, gèsanqaná. Zapa ndǿgo, no ndigu āv qazømbe-manqaté nqǽgo: Tiqa matev soqaín. ");
INSERT INTO kvg_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Zo vø̀záv ndøgo, møvøna kandambaqape-te. No naqanøká nónavák. Zapa ndǿgo, nogi khøuwa eqeieqei fakhazaneáv. Zuá.” ");
INSERT INTO kvg_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesu nqanek manqat ge-ein, yaq ndego Gelili plovins-té segeqóm. ");
INSERT INTO kvg_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesu-gi namba-qaniap, møvøna kandambaqape-te gi꞉zav, yaq vaev até Yesú-a, vø̄wav. Geté ndego ambá ezoqa ewaqape-qā bøi-tē genø-okhoām, geté khonoam-té genø-okhoám. ");
INSERT INTO kvg_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yaq møvøna manqei-te ndøgo, Zu megetapak gèmbovawém. Gibevøpem, “Ngenek gekham-tē gégo?” ");
INSERT INTO kvg_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ezoqa kopoáv, teqa manqat mokho-mbá gunu-manqatám. Ezoqa nøme āv gini-manqatám nqǽgo, “Ngenek ezoqa qanimáv.” Geté ezoqa nøme gi-einim, “Mbaín. Ngenek ezoqa ewaqape gètubumít.” ");
INSERT INTO kvg_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Geté ezoqa kopo, teqa yaq-te manqat bavokho einiáv. Zapa ndǿgo, ndigu Zu megetapak-qá møe ndøgoám. ");
INSERT INTO kvg_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Møvøna khøuwa livin-mba mø̀ndømuwán. Yaq Yesu Mbumbukiam-qá khoev-té genøwáv, ezoqa vømē-zømesim. ");
INSERT INTO kvg_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yaq Zu megetapak teqa manqat giyogem, ndigu nqova ndafe kandambá. Gi-einim, “Ngenek otevat gekham-tē géndap? Ndego skul kandambaqape-te okhoeáv.” ");
INSERT INTO kvg_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yaq Yesu gezø-qavøiu, “Manqat ndøgo, no nqate-zømesim, ambá av nqǣgo, nøkeza nømendim manqāt. Geté teqa ndégo, no ma gende-khofotan. ");
INSERT INTO kvg_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Gekha ezoqām ndego, Mbumbukiam-qa poev matev paev-qa tego, ndego segé꞉-otév, av nqægo, manqat ndøgo, no nqate-zømesim, Mbumbukiam-tē qando-okhō, ō, no nøkeza matavap-tē qate-zømesīm. ");
INSERT INTO kvg_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Gekha ezoqām ndego, ekeza manqat mba ndemanqate, ndego ekeza iz eqawat-qa mba ndǿgo. Geté ndego ezoqam, ndego teqa iz eqawat-qa ndego, ma gende-khofotav, ndego unimanqatin manqat ndømanqaté. Neka te mokho-te, manqa-zapa mbaín. ");
INSERT INTO kvg_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Zo Mozes, guguna manqat zø-etoám. Geté zo ezoqa kopo, teqa guguna manqat pøpøvumáv. Zo gekha zapâ, no lambe-qa ndozogo?” ");
INSERT INTO kvg_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Yaq ezoqa ewaqape gindu-qavøinam, “Nandav manqat, mokho mbaín. Gekha ezoqâm, qo løvøqa-qa ndego? Qo nqova soqa qambu꞉gú, manqat av nandoqote-manqate.” ");
INSERT INTO kvg_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yaq Yesu gendo-qavøiu, “No Sabat khøuwa-te, ezoqa kopo qækhakheinøvem, yaq zo ate ndøzøte꞉go, nqova nøzøndáf. ");
INSERT INTO kvg_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Geté até zó-a, zo sasae sozogoatún, Sabat khøuwa-te. Zapa ndǿgo, até Sabat khøuwa-té-a, zogi nakhei angana ngusu zozø-qogavatún, av Mozes zo guguna manqat gezømbe-etoam. (Geté unimanqatín. Mozés mbá, nqanek matev gengaz. Atanakha-zapazapa-za ndøngazém. Mozes okhokho-té genøfakhán.) ");
INSERT INTO kvg_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Zo até Sabat khøuwa-té-a, nakhei angana ngusu zozø-qogøzát. Zapa ndǿgo, Mozes zo guguna manqat, āv tezømbe-etoám. Neka zo poeveáv, tozo-nqaonem. Av tægoat ndægo, yaq zo gekha zapâ, qaqa ndozogo no-te, no Sabat khøuwa-te, ezoqam-qa kha ate ndægo qækhakheinam. ");
INSERT INTO kvg_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Zo matev mumat-te mba mo꞉gevèwa᷄t. Geté ùnime꞉-gevewát, gekha matēv ndøgo, eqeieqei o soqain.” ");
INSERT INTO kvg_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Zelusalem taon-ak nøme, āv gini-einím nqǽgo, “Gê, ezoqam ngénèk, laelae-qa ndimbogo?” ");
INSERT INTO kvg_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nqáe! Ndego manqat ezoqa ewaqape-qá bøi-té genø-manqaté. Geté ezoqa kopo, manqat-qase einiáv, taqa yaq-te. Gê, ndigu megetapak, peté-matøvemem-a, av nqægo, ndego unimanqatīn Mesayā? ");
INSERT INTO kvg_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Geté ngenek ezoqam-qa yaq-te, ni mìzi꞉nøtén, gekham-tē gendówav. Geté Mesaya tendowav, ezoqa gézøtezák, ndego ākendēwav. ");
INSERT INTO kvg_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yaq Yesu ezoqa Mbumbukiam-qa khoev-te ge꞉zømesimat, āv gene-akhá nqǽgo, “Ge zô, no unimanqatīn møzøté-zøtez? Neka zo møzøté-zøtez, no gekham-tē qatøndónav? No ambá av nqǣgo, nøkeza matavap-tē qatøgeavūn. Ndego, no ma gende-khofotan, ndego unimanqatin-qapé. Geté zo zøtezateáv ndego. ");
INSERT INTO kvg_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","No mø̀tenøtén ndego. Zapa ndǿgo, no te-té tøtøndonáv neka ndégo tendo-khofotán.” ");
INSERT INTO kvg_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Zu megetapak, nqanek manqat giyogem, yaq ambá gemøvøinamɨ́n. Geté ezoqa kopo zenda veeáv te-te. Zapa ndǿgo, teqa khøuwa khantøzateáv. ");
INSERT INTO kvg_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Geté ezoqa kopoáv, ezoqa bawan-qape mokho-te ndøugu, mø̀ndø-unimanqatiním. Gi-einim, “Ngenek amba Mesaya goneav tøgonɨn. Yaq gê, unimanqatin Mesaya tendowavɨn, ndego amba umingiap matev nøme mba mó꞉matanamɨn, av ngenek nge꞉matanam? Āv taoká. Yaq nakémbá, ngenek Mesayá agegó.” ");
INSERT INTO kvg_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Yaq Felisi ezoqam nqanek manqat giyogem, ezoqa ewaqape khonoam-te Yesu-qa yaq-te gi꞉manqatat, yaq ndigu Mbumbukiam-gi iziz ezoqa kandakanda namba, Mbumbukiam-qa khoev vos keoge ezoqam ndøkhofotáz. Yesu ambá gemøvøinamɨ́n. ");
INSERT INTO kvg_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yaq Yesu ezoqa gezø-ein, “No khapé nøtégoák, zo namba. Yaq no te-te ndégo tøtǿqaván, no ma gende-khofotan. ");
INSERT INTO kvg_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Zo no zonǿvawát. Geté zónømendamák. Ma tøtegoat ndøgo, zo kopømba mbaín, tozotøndozav.” ");
INSERT INTO kvg_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yaq Zu megetapak, ekeza mokho-mba gibond, “Gê, ngenek gekha manqeī genǿwāv, yaq ni amba tizimbøe-vawēm, getē zī-ometamāk? Gê, ngenek Glik manqei-te okho-qa mbógo, ndøgo nigi ezoqa nøme ndindu-yageapet, neka Glik ezoqa vømé-zømesīm? ");
INSERT INTO kvg_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Neka gê, ngenek gekhā mé꞉manqate, av ge-ein nqægo, ‘Zo no zonø̄vawāt, getē zōnømendamāk,’ neka, ‘Ma tøtegoat ndøgo, zo kopømba mbaīn, tozotøndozav.’?” ");
INSERT INTO kvg_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Møvøna-qa vaev khøuwa gimø-khantøzem, ndøgo khøuwa uni kandambaqape, yaq Yesu ezoqa ewaqape-qa megemege-té genø-itán. Yaq āv gene-akhá nqǽgo, “Gekha ezoqām ndego, ibøkha naq ndømbopapat, ndego no-té geabetøndo-wáv, bē-iz. ");
INSERT INTO kvg_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mbumbukiam-qa Manqat, āv qane-manqaté nqǽgo, ‘Gekha ezoqām ndego, no te-unimanqatin, te-te ndego, khandi ibøkha ndóqouvát.’” ");
INSERT INTO kvg_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu nqanek manqat, Nqova Mbomambaqape me꞉-eín, ezoqa tindafemat, ndigu ndego ti-unimanqatinim. Ta khøuwa-te ndøgo, Mbumbukiam ezoqam-te, tege Nqova naqanaqá etopøteáv. Zuá. Zapa ndǿgo, Yesu iz kandambaqape ndapeav zua ndøgoám. ");
INSERT INTO kvg_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ezoqa nøme, ezoqa bawan-qape mokho-te gu꞉goam, nqanek Yesu-qa manqat gimboyogem, yaq ndigu āv gini-einím nqǽgo, “Ngenek unimanqatín Mbumbukiam-gé manqa vevezam ezoqám, ndego tendo-khofotav!” ");
INSERT INTO kvg_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Neka ezoqa nøme, āv gini-einím nqǽgo, “Ngenek ezoqam, Mesayá!” Geté ezoqa nøme gi-einim, “Āv taoká. Mesaya Gelili plovins-te gendówavák. ");
INSERT INTO kvg_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Zapa ndǿgo, Mbumbukiam-qa manqat āv qane-eín nqǽgo, ‘Mesaya ndego Deivid-gé Zeo ndǿgoát, ndego nigi kawa ezoqam kandambaqape. Neka ndego Betliem vemiav-té géqán, ta vemiav ndøgo, ma Deivid ge꞉yagam.’” ");
INSERT INTO kvg_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Yaq ezoqa gèqatøném, Yesu zapaya. ");
INSERT INTO kvg_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ezoqa nøme, ndego møvøiwat-qa mbogoám. Geté ezoqa kopo, zenda veeáv te-te. ");
INSERT INTO kvg_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Yaq ndigu vos keoge ezoqam, Mbumbukiam-gi iziz ezoqa kandakanda neka Felisi ezoqam-te giqavaz, yaq ndigu āv gizømbe-beváp nqǽgo, “Gekha zapâ, zo ndego ni-te ndafeav ndozogo?” ");
INSERT INTO kvg_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Geté ndigu gindu-qavøinam, “Ezoqa kopo nøme, manqat manqatemáv, av ndego manqat nde꞉manqate.” ");
INSERT INTO kvg_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Yaq Felisi ezoqam gezø-qavøiu, “Gê, ndego até zó-a, gétubam? ");
INSERT INTO kvg_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ni megetapak o Felisi ezoqam-qa mokho-te, ezoqa kopo mbaín, ndego Yesu nde-unimanqatinat. ");
INSERT INTO kvg_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nginik ezoqa ewaqape, ndego ndi-unimanqatinat, ndigu Mozes-qa guguna manqat zøtezateáv. Mbumbukiam ndigu ndø̀ngiæzó.” ");
INSERT INTO kvg_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Yaq ndego Felisi ezoqa nøme, Nikodemus, ndego bugukhokhof Yesu-te gemat, ndigu āv gezømbe-eín nqǽgo, ");
INSERT INTO kvg_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Gê, niqa guguna manqat gekhā ndǿ-ein? Kopømbâ, ezoqa løvøte-te tiziveem, ni teqa manqa yogeav tøgoat neka teqa manqa-zapa qeiviav vǿgoāt? Kopømba mbaín.” ");
INSERT INTO kvg_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Yaq ndigu gindu-qavøinam, “Gê, até qó-a, Gelili plovins-âk? Mbumbukiam-qa Manqat ùnime꞉-geveám. Yaq soqóqeív ndøgo, Mbumbukiam-ge manqa vevezam ezoqa kopo gendówavák, Gelili plovins-te.” ");
INSERT INTO kvg_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Taqa zita-te, ezoqa ewaqape sège-qavøním. ");
INSERT INTO kvg_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ezoqa ewaqape giqavønim, yaq Yesu Oliv manqei pøyat-té genøwáv. ");
INSERT INTO kvg_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Yaq khøuwa nøme qandopave. Qanaqanus lovølova-ús. Ndego Mbumbukiam-qá khoev-té genøveséz. Yaq ezoqa kopoáv, gindupia, te-te. Yaq ndego tenøqóm ndǿgo, ndigu vø̄e-zømesim. ");
INSERT INTO kvg_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Yaq Mozes-qa guguna manqat nømendim ezoqam neka Felisi ezoqam, sævam ndo-ituím. Ngunuk āv giniqatém nqǽgo, nøkenøkem matev ndøngiú. Mambe me꞉wáv. Yaq ndugu ezoqa ewaqape-qá megemege-té ginøveém. ");
INSERT INTO kvg_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Yaq ndigu Yesu gimbo-einim, “Nøméndim ezoqam. Ngunuk sævam āv qatiqatém nqǽgo, nøkenøkem matev ndøngiú. ");
INSERT INTO kvg_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Niqa guguna manqat-te, Mozes manqa āv ginimbi-løvuá nqǽgo, ‘Sævam av nguigu, mbaqambaqá qotépóu, bēnanim.’ Yaq ndakin qo gekha manqat qó-eīn, tuqa yaq-te?” ");
INSERT INTO kvg_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nqanek manqat timbøe-einím ndǿgo, Yesu matemateam-qa mbogoám. Ndego amba manqat soqain te-einin, ndigu ambá manqa ovøyam-té ginø-veemɨ́n. Geté ndego sègefoé. Yaq manqei-te kokosóv gene-peawám. ");
INSERT INTO kvg_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Yaq ndigu sekembá segembo-sinøzumát. Yaq Yesu kawa nango gendo-eqa, gezø-ein, “Zo nqazowani, gekha ezoqām ndego, manqa-zapa mbain ndego, bugukhokhof mbaqambaqa tèabe-ogezó ndego, tu-te.” ");
INSERT INTO kvg_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yaq ndego nangó genøfoé, manqei-te vø̄peawam. ");
INSERT INTO kvg_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Yaq ndigu nqanek manqat giyogem, ezoqa ewaqape sège-panqaním. Ezoqa kopokopo ndøkhofatám. Ibugukhokhof, laombøkik ndø-ivøvém. Yaq vaev-te, Yesu yakhapus mbá sege-ivøvém, ndugu sævam vømbōyam. ");
INSERT INTO kvg_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yaq Yesu kawa nangó gendo-eqá, ndugu sævam vø̄mbo-ein, “Nginik ezoqam kinǿqapi? Gê, ezoqa nøme mbaîn, qoqa yaq-te ndimanqate, av nqægo, qo vø̀naqanīm, qakeza manqa-zapa zapaya?” ");
INSERT INTO kvg_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Yaq ngunuk sævam gundu-qavøiu, “Khanánqa. Ezoqam nøme mbaín.” Yaq Yesu gumbo-ein, “Até nó-a, no nǿ-einák, av nqægo, qo vø̀naqanīm. Mòqoqáv. Geté manqa-zapa nango mø̀go᷄.” ");
INSERT INTO kvg_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Khøuwa nøme, Yesu ezoqa manqat nøme āv gezømbe-eín nqǽgo, “No manqei-qape-qá wáev. Gekha ezoqām ndego, no tenøndo-paev, ndego bøivun-te sekemba gé-okhoák. Geté ndego waev mbógoát, ta waev ndøgo, ezoqa khandi ndøzø-etoam.” ");
INSERT INTO kvg_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Yaq Felisi ezoqam, āv gimbøe-einím nqǽgo, “Nandav manqat, qo qakeza qote-manqaté, qoqa yaq-te. Yaq kopømba mbaín, tei-unimanqatinim.” ");
INSERT INTO kvg_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yaq Yesu gezø-qavøiu, “Unimanqatín. No nøkeza nøte-manqaté, nqanek manqat. Geté, noqa manqat unimanqatín. Zapa ndǿgo, no mø̀tenøtén, no gekham-tē qatøndōnav neka no gekham-tē qatø̄ma. Geté zo zøtezateáv, no ma qatøndenav neka no ma nqatēma. ");
INSERT INTO kvg_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Zo ezoqa nøme, manqei-qape ezoqam-qá matavap-té qazonø-gevezoát. No ezoqa gevezoatáv. ");
INSERT INTO kvg_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Geté no tægevezo, yaq noqa gevezoat matev unimanqatín. Zapa ndǿgo, no ezoqa ambá nakhapus mbā sǣgevezoat. Geté no Tát namba niti-gevezoát, ndego ma gende-khofotan. ");
INSERT INTO kvg_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Zoqa guguna manqat-te, āv qane-peawáp nqǽgo: Ezoqa menas matev bøi ti꞉qeivim, yaq ndigu manqa ovøyam-te manqat kopo ti-einim taqa yaq-te, yaq ta manqat ndøgo, unimanqatín. ");
INSERT INTO kvg_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Até noqa yaq-té-a, matev kopó. Ezoqa nøme, noqa yaq-te tezø-ovøyam, nó, neka ezoqa nøme, noqa yaq-te tezø-ovøyam, nogé Tát.” ");
INSERT INTO kvg_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Yaq ndigu gimbo-bevøpem, “Ge qô, qave kenøqáqape?” Yaq Yesu gezø-qavøiu, “Zo no zøtezateáv, neka zo até nogé Tát-a, zøtezateáv. Zo no amba tøzøte-zøtezɨn, yaq zo até nogé Tát-a, ndøzøte-zøtezɨ́n.” ");
INSERT INTO kvg_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu ezoqa Mbumbukiam-qa khoev-te ge꞉zømezimat, nqanek manqat ate nqægo ta kouwat-te ndǿgo temanqatám, ma ezoqa Mbumbukiam-te moni gi꞉-abumam. Geté ezoqa ndego møvøiwateáv. Zapa ndǿgo, tege khøuwa fakhazaneáv, ndigu ti꞉møvøinam. Zuá. ");
INSERT INTO kvg_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yaq Yesu ezoqa manqat nøme āv gezømbe-eín nqǽgo, “No ndæ̀náv. Yaq zo no ambá ndøzønømbe-vawát. Yaq zo zøkeza manqa-zapazapá nambá søzøté-pakhaetát. Zo kopømba mbaín, tozotøndozav, no ma nqatema.” ");
INSERT INTO kvg_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yaq Zu megetapak, ekeza mokho-mba gibond, “Gê, ndego ekeza kha ndǿngiū, yaq nakêmbà, ge꞉-ein av nqægo, ‘Zo kopømba mbaīn, tozotøndozav, no ma nqatema.’?” ");
INSERT INTO kvg_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yaq Yesu gendo-qavøiu, “Zo manqei-qape-ák. Geté no ova-yák. Zo manqei-qape ezoqám. Geté no manqei-qape ezoqám mbá. ");
INSERT INTO kvg_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yaq nakémbá, no zo qazø-ein av nqægo, zo zøkeza manqa-zapazapā nambā søzøtē-pakhaetāt. Zo unimanqatinteav tøgoat, av nqægo, no ndēgo, yaq zo zøkeza manqa-zapazapá nambá søzøté-pakhaetát.” ");
INSERT INTO kvg_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Yaq ndigu gimbo-bevøpem, “Gê, qo gekha ezoqâm?” Yaq Yesu gendo-qavøiu, “No zo oskia nøzø-manqatám, no gekha ezoqām. ");
INSERT INTO kvg_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","No manqat kandambá nqanøgo, no amba zoqa yaq-te tøte-manqatatɨn neka vø̄e-gevezoatɨn. Geté no manqei-qape ezoqam sa ndǿgo tæzømbe-manqaté, no te-te qæ-ewagam, ndego no gendo-khofotan. Ngenek ezoqam, teqa manqat unimanqatín.” ");
INSERT INTO kvg_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yesu nqanek manqat gezø-ein, ndigu mokho ndapeáv, av nqægo, Eve-qā yaq-tē gezømbe-manqatām. ");
INSERT INTO kvg_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yaq Yesu āv gezømbe-eín nqǽgo, “Zo Ezoqam-ge Yo tozotumu-eqeinam, yaq zo zøtézøtéz, no ndégo, neka no ambá av nqǣgo, matev nøkeza matavap-te mbā qatø-matanām. Geté no sa nqánek qæmanqaté, av Tat ge꞉nømand. ");
INSERT INTO kvg_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ndego ezoqam, no gendo-khofotan, ngêgó no namba. Ndego no nøuvønateáv. Zapa ndǿgo, no oskia ndǿgo tægoatún, av ndego poev ndømbøego.” ");
INSERT INTO kvg_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesu nqanek manqat ge-ein, yaq ezoqa kopoáv gè-unimanqatiním. ");
INSERT INTO kvg_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ndigu Zu ezoqam, Yesu gi-unimanqatinim, ndego āv gezømbe-eín nqǽgo, “Zo noqa manqat mokho-te tozotu-yagat, yaq zo uni nogí paev ezoqam-in zógoát. ");
INSERT INTO kvg_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Yaq zo unimanqatin manqat zøtézøtéz. Yaq nqanek unimanqatin manqat, zo génqovotáz. Yaq zo bavokhó qazonǿ-fakház.” ");
INSERT INTO kvg_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yaq ndigu gindu-qavøinam, “Ni Eibleem-gí zí. Ni ambá av nqǣgo, ezoqam-gī yaq-fia mbain sasae ezoqām, neka ndigu ni gètokønāt. Gekha zapâ, nqoqo-manqate av nqægo, ni bavokho seīfakhān?” ");
INSERT INTO kvg_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yaq Yesu gezø-ein, “No unimanqatín nqazø-manqate. Gekha ezoqām ndigu, manqa-zapazapa ndimatanam, ndigu manqa-zapazapa-gí yaq-fia mbain sasae ezoqám. Ndøgo gètokøzát. ");
INSERT INTO kvg_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Geté unimanqatín, yaq-fia mbain sasae ezoqam, ezoqam-qa khoev-te ate nonqo gú꞉goák. Geté khoev eve-ge nakhasam, oskia mú꞉goát. ");
INSERT INTO kvg_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Zo Mbumbukiam-ge Yo mboqog tezø-mboqozo, zo vozófakhāz, yaq zo ùni ndøzøte-fakház. Zo manqa-zapazapa-gi yaq-fia mbain sasae ezoqam, sekemba zógoák. ");
INSERT INTO kvg_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","No mø̀tenøtén, zo Eibleem-gí zí. Geté zo no pakhapakha khaneam-qa zonøgó. Zapa ndǿgo, noqa manqat, zo mokho-te mbaín. ");
INSERT INTO kvg_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","No ndǿgo tæmanqaté, no Tat ge꞉nømand. Geté zo ndǿgo tozo-matanám, av zoge zøve ge꞉zømas.” ");
INSERT INTO kvg_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yaq ndigu gimbo-qavøinam, “Nigi tat Eibleém.” Yaq Yesu gezø-ein, “Zo amba Eibleem-gi zi tozogonɨn, zo matev amba āv tøzøte-matanamɨ́n, av ndego ge꞉matønumam. ");
INSERT INTO kvg_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","No zo unimanqatin manqat mba nøzø-manqatám, ndøgo no Mbumbukiam-te qæ-ewagam. Geté zo no pakhapakha khaneam-qa zonøgó. Eibleem matev av nqægo matanapøteáv. ");
INSERT INTO kvg_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Zo āv tøzøte-matanám, av zoge zøve nde꞉matanam.” Yaq ndigu gimbo-qavøinam, “Āv taoká. Ni mambe nakheís mbá. Nigi Tat, Mbumbukiam yakhapús.” ");
INSERT INTO kvg_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yaq Yesu gezø-ein, “Mbumbukiam amba zoge zøve tegonɨn, zo ambá kuku zogonɨ́n no-te. Zapa ndǿgo, no Mbumbukiam-té qatøndonáv, atema zo-te. No ambá av nqǣgo, nøkeza matavap-tē qatøgeavūn. Geté no ndégo tendo-khofotán. ");
INSERT INTO kvg_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Zo gekha zapâ, mokho ndapeav ndozogo, no manqat nqazø-manqate? Zo ndapeav tøzøtegó ndǿgo, zo kopømba mbaín, noqa manqat tozondapem. ");
INSERT INTO kvg_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Zapa ndǿgo, zo nqova soqaqape-gí nakheís. Zoge zøve ndégo. Gekha matēv ndøgo, ndego ndømbøe-khaneat, zo matanam-qa zogó. Ibugukhokhof, atema ndakin, ndego pakhapakha khaneam ezoqam oskia ndøgó, neka ndego elavøqase nøzøneáv unimanqatin-te. Zapa ndǿgo, te mokho-te unimanqatin mbaín. Ndego gekhavozamɨn, ndego ekeza matev mba mbopaevɨ́n. Zapa ndǿgo, ndego khavozam ezoqám neka khavozam manqat ate ndægo, ndego evé. ");
INSERT INTO kvg_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Geté no unimanqatin manqat nomanqaté. Yaq nakémbá, zo no unimanqatinteáv. ");
INSERT INTO kvg_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Gê, zo mokho-te, ezoqa kopo kopømbâ, noqa yaq-te te-ein, av nqægo, ngenek manqa-zapa ndøgō. Kopømba mbaín. Av tægoat ndægo, no unimanqatin manqat nqæmanqate, yaq gekha zapâ, zo no unimanqatinteav ndozogo? ");
INSERT INTO kvg_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Gekha ezoqām ndego, Mbumbukiam-gē, ndego Mbumbukiam-qa manqat gèyogé. Geté zo Mbumbukiam-gé mbá. Yaq nakémbá, zo manqat yogeapáv.” ");
INSERT INTO kvg_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yaq Zu megetapak, Yesu gimbo-einim, “Ni mø̀i-einím. Qo Samalia ezoqám. Neka qo nqova soqa qambugú.” ");
INSERT INTO kvg_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yaq Yesu gezø-qavøiu, “No ambá av nqǣgo, nqova soqa nømbugū. Āv taoká. No Tat nombovizáp. Geté zo noqa iz, zòvoát. ");
INSERT INTO kvg_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","No ambá av nqǣgo, nøkeza iz eqawat-qa nogó. Geté ezoqa ndêgó, noqa iz eqawat-qa ndego. Ndego no eqeieqei me꞉næná. ");
INSERT INTO kvg_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","No unimanqatín nqazø-manqate. Gekha ezoqām ndego, noqa nømendim manqat tembopavat, ndego miavmiav løvøte géqeivák.” ");
INSERT INTO kvg_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yaq ndigu Zu ezoqam gimbo-einim, “Ndakin ni mø̀tinøtén, av nqægo, qo nqova soqa nandeqambû꞉gú! Qoqa manqat, mokho mbaín. Eibleem mø̀ndønaním neka até Mbumbukiam-gi manqa vevezam ezoqám-a, vø̄pakhaez. Geté qo āv qoqote-manqaté nqǽgo: Gekha ezoqām ndego, qoqa nømendim manqat tembopavat, ndego miavmiav løvøte géqeivák. ");
INSERT INTO kvg_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Gê, qo nigi atanakha-zapa Eibleem neka Mbumbukiam-gi manqa vevezam ezoqam, moqóløvub, ndigu gipakhaez? Qo qakeza kha gekha qotévewe?” ");
INSERT INTO kvg_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yaq Yesu gezø-qavøiu, “No amba nøkeza iz tæ-eqawatɨn, ta iz eqawat mokho ambá mbaín. Geté noqa iz, noge Tat ndø-eqawát. Ezoqa ndégo, zo ndøzøte-manqate, av nqægo, ndego nigī Mbumbukiām. ");
INSERT INTO kvg_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Zo ndego zøtezateáv. Geté no ndego mø̀tenøtén. No amba av tøte-manqateɨn nqægo, no ndego nø̀tenøtenāk, yaq no ambá khavozam ezoqam nogonɨ́n, av zo ndøzøte꞉go. Geté no ndego mø̀tenøtén, neka no teqa manqat o-mba notondapé. ");
INSERT INTO kvg_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Zoge atanakha-zapa Eibleem, ndego noqa fakhane khøuwa-qa khanakhanakh-us mo꞉kewagám. Yaq ndego mø̀ndøqeív. Yaq khanakhanakh kandambá gendap.” ");
INSERT INTO kvg_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yaq ndigu gimbo-einim, “Qoqa manqat nandav, mokho mbaín. Qo viav fifti ndapeáv. Zuá. Yaq gê, qo Eibleem áv khoqoté-omet?” ");
INSERT INTO kvg_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yaq Yesu gendo-qavøiu, “No unimanqatín nqazø-manqate. Eibleem qaneav gegoam, no nògoám.” ");
INSERT INTO kvg_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yesu nqanek manqat ge-ein, yaq ndigu mbaqambaqa mba ndøpitáz. Ambá gepouimín. Geté Yesu é-møndøpeó, Mbumbukiam-qa khoev vø̄-ivav. ");
INSERT INTO kvg_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu gewav, yaq bøi waev mbain ezoqam ndø-omét. Ndego āv teneqán. Bøi waev mbaín. ");
INSERT INTO kvg_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yaq ekeza paev ezoqam gimbo-bevøpem, “Nøméndim ezoqam. Gê, ndego bøi waev mbain geqan, ndøgo gekha ezoqam-qâ manqa-zapà? Ndøgo ekezâ manqa-zapà, ó, evøndipakha-qâ manqa-zapà?” ");
INSERT INTO kvg_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yaq Yesu gendo-qavøiu, “Ndego bøi waev mbain geqan, ndøgo ambá av nqǣgo, ekeza manqa-zapa zapayā, o evøndipakha-qā manqa-zapa zapayā. Geté te mokho-te, Mbumbukiam-qá bazaføgakh tabete-qeiví. ");
INSERT INTO kvg_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ate av-te paveat ndægo, ni teqa sasae, ndego no gendo-khofotan, é-bizigoném. Geté bøivun nqâgeáv. Yaq ta khøuwa-te ndøgo, ezoqa kopo kopømba mbaín, sasae tego. ");
INSERT INTO kvg_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","No manqei-qape-te nqægo, no manqei-qape-qá wáev.” ");
INSERT INTO kvg_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu nqanek manqat gumu-ein, yaq manqei-te, køse ndøpisíb. Yaq gèqøozó, vø̄-menegim. Yaq até gendego, ta qoq ndøgo, bøi waev mbain ezoqam-qá bøi-té genøgɨ́, ");
INSERT INTO kvg_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","vømbō-ein, “Mòqoqá. Bugug Siloam kewan-qasi-té qomǿsungúz.” (Siloam, taqa manqa mokho nqánek, “Ezoqam gikhofotøvem.”) Yaq ndego bøi waev mbain ezoqam, sègewáv, bugug vømø̄sunguz. Yaq gendoqavan, teqa bøi sège-eqeieqeí. ");
INSERT INTO kvg_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Taqa zita-te, ndigu ezoqam, khoev avønin qazø-puatam neka ezoqa nøme ndigu bugukhokhof gi-ometupam, ezoqa gigiap-qa gezøvi꞉mam, gèbevøpém, “Gê, ezoqam ngénèk, nakhoa-te geqonumam, ezoqa gigiap-qa gezøvi꞉mam?” ");
INSERT INTO kvg_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ezoqa nøme gindu-einim, “Ezoqam ngének.” Geté ezoqa nøme gindu-einim, “Mbaín. Teoká ndego. Ngenek andé teqa bugug me꞉keogé.” Geté ndego ezoqam, bøi waev mbain gegoam, ekezan āv gene-eín nqǽgo, “Ezoqam nó.” ");
INSERT INTO kvg_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Yaq ndigu gimbo-bevøpem, “Gê, áv khanégo, qo ndakin ndoqo-keoge?” ");
INSERT INTO kvg_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yaq ndego gendo-qavøiu, “Ndego ezoqam, iz nqambogo Yesu, ndego qoq ndøqoá, noqa bøi-te vō꞉ge. Yaq āv genømbe-eín nqǽgo, ‘Siloam kewan-qasi-té qonǿqáv, bugug voqomǿ-sungūz.’ Yaq no sæ̀náv, bugug vøemø̄-sunguz. Qatumu-sunguz ndøgo, yaq no kopømbá qækewag.” ");
INSERT INTO kvg_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Yaq ndigu gimbo-bevøpem, “Gê, ndego ndakin kenáqape?” Yaq ndego gendo-qavøiu, “No nø̀tenøtenák.” ");
INSERT INTO kvg_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Taqa zita-te, ndego ezoqam, bøi waev mbain gegoam, Felisi ezoqam-té ginøndafém. ");
INSERT INTO kvg_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ta khøuwa-te ndøgo, Yesu qoq geqoa, yaq ndego bøi waev mbain ezoqam vø̄khakheinøvem, ta khøuwa ndøgo, Sabat khøuwá. ");
INSERT INTO kvg_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Yaq ndakin até ndigu Felisi ezoqám-a, vømbō-bevøpem, av nqægo, ndego bøi waev ande āv kenēndap? Yaq ndego gezø-ein, “Ndego noqa bøi-te, qoq mo꞉gé, yaq no bugug vøemø̄-sunguz. Yaq ndakin no kopømbá nqækeoge.” ");
INSERT INTO kvg_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Yaq Felisi ezoqa nøme gi-einim, “Ndego ezoqam, ambá av nqǣgo, Mbumbukiam ndokhofotāv. Zapa ndǿgo, ndego Mozes-qa guguna manqat pøpøvumáv, Sabat khøuwa-qa yaq-te.” Geté ezoqa nøme gi-einim, “Gê, ezoqa manqa-zapa-us tegoat, áv khané꞉go, umingiap matev av nqægo tematønumat?” Yaq ti mokho-te, qaqae matev ndøgoám. ");
INSERT INTO kvg_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Yaq ndigu Felisi ezoqam, nqawá ginømbo-sinøzømém, ndego ezoqam, bugukhokhof bøi waev mbain gegoam. Gimbo-einim, “Ge qô, áv khoqoté-matavap, teqa yaq-te, ndego bøi geqa-khakheinam?” Yaq ndego ezoqam gendo-qavøiu, “Ndego Mbumbukiam-gé manqa vevezam ezoqám.” ");
INSERT INTO kvg_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Geté ndigu Zu megetapak unimanqatinteáv, av nqægo, ndego ezoqam bøi waev mbain ndøgoām, yaq ndakin ndego kopømbā ndekeoge. Yaq ndigu evøndipakha ndømøváb. ");
INSERT INTO kvg_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Yaq āv gezømbe-beváp nqǽgo, “Gê, ngenek zogé yō, zo teqa yaq-te ndøzøte-manqate, av nqægo, ngenek bøi waev mbaín geqan? Av tægoat ndægo, gê, áv khané꞉go, ndakin ndekeoge?” ");
INSERT INTO kvg_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Yaq tegi evøndipakha gindu-qavøinam, “Ni mø̀tinøtén, ngenek nigí yó, neka ngenek bøi waev mbaín geqan. ");
INSERT INTO kvg_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Geté ni nøtenateáv, ndego ndakin ande āv kenē-keoge o bøi gekha ezoqām mbōkhakheinam. Ekezan mbobevøpém! Ndego mø̀ndømu-khouwév. Kopømbá, ekeza tezø-qavøiu.” ");
INSERT INTO kvg_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ndigu evøndipakha, nqanek manqat tini-einím ndǿgo, ndigu Zu megetapak-qá møe ndøgoném. Zapa ndǿgo, ndigu Zu megetapak, manqat é-møndø-kopo꞉ném, av nqægo, gekha ezoqām ndego, te-unimanqatin, av nqægo, Yesu ndego Mesayā, yaq ndego ezoqam gembøé-khafeném. Zu ezoqam-qa guliguli khoev-te, sekemba gé-okhoák. ");
INSERT INTO kvg_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yaq nakémbá, tegi evøndipakha gi-einim av nqægo, “Ngenek mø̀ndømu-khouwēv. Ekeza mbobevøpēm.” ");
INSERT INTO kvg_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Yaq ndigu Zu megetapak, ndego ezoqam, bøi waev mbain gegoam, nqawá ginømbo-akhaém, vømbō-einim, “Mbumbukiam-qa iz-te, qo unimanqatin manqat qó-eín. Ni mø̀tinøtén, nandev ezoqam qo ndoqote-manqate, ndego manqa-zapa-us ezoqám.” ");
INSERT INTO kvg_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yaq ngenek ezoqam gendo-qavøiu, “No nøtenateáv, ndego manqa-zapa-us ezoqām penømakhaya. No sa nqánek qatenøtén. No bøi waev mbain nogoám. Yaq ndakin no kopømbá nqækeoge.” ");
INSERT INTO kvg_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Yaq ndigu gimbo-bevøpem, “Gê, ndego gekha matev qámatanam? Ndego qoqa bøi áv kené-khakheinam?” ");
INSERT INTO kvg_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Yaq ndego gendo-qavøiu, “No mø̀ezø-eín. Geté zo yogeáv. Gekha zapâ, zo nqawa yoge-qa ndozogo? Gê, ate zó-a, zo tegi paev ezoqam gone-qa zógo?” ");
INSERT INTO kvg_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Yaq ndigu mbøni nqosøgeap mboyogém, vømbō-einim, “Tege paev ezoqam, qó. Ni Mozes-gí paev ezoqám. ");
INSERT INTO kvg_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ni mø̀tinøtén, Mbumbukiam manqat Mozes mbomanqatám. Geté nandev, ni ùnimi꞉-nøtenateáv. Até ndøgó-a, ma gendewav, ni nøtenateáv.” ");
INSERT INTO kvg_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Yaq ndego gendo-qavøiu, “Nandav nqova ndafe-ús, zo zøtezateav ndozogo, ndego ma gendewav, yaq ndego no bøi vønø̄-khakheinam. ");
INSERT INTO kvg_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ni mìzi꞉nøtén, Mbumbukiam manqa-zapa-us ezoqam-qa manqat yogeapáv. Geté gekha ezoqām ndigu, ndimbovizap neka matev ndimatanam, av ndego poev ndømbøego, ndígu tezøyogé. ");
INSERT INTO kvg_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Manqei-qape ande qæfakhan, atema ndakin, ezoqa yogeáv av nqægo, ezoqa bøi waev mbain ezoqam ndøkhakheinøvēm, ndego bøi waev mbain geqan, vǿkewāg. ");
INSERT INTO kvg_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ndego ezoqam, amba Mbumbukiam khofotøveav tegonɨn, ndego matev-qase ambá gé꞉matanamák.” ");
INSERT INTO kvg_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Yaq ndigu gindu-qavøinam, “Qo manqa-zapa mokho-té qonøqáq. Yaq ge qô, ni nømendim-qa qógo?” Yaq ndigu gèmbøe-khafeném, tiqa guliguli khoev-te nqawa gé-onák. ");
INSERT INTO kvg_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu ge-ewag, av nqægo, Felisi ezoqam ndego ezoqam gèmbøe-khafenēm, ndego bøi waev mbain gegoam, tiqa guliguli khoev-te nqawa gē-onāk, yaq ge-omet, ndego āv gembøebeváp nqǽgo, “Gê, qo Ezoqam-ge Yo moqó-unimanqatin?” ");
INSERT INTO kvg_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Yaq ndego gendo-qavøiu, “Khanánqa. Qonømbé-eīn, ndego gekha ezoqâm? Yaq no ndego nó-unimanqatín!” ");
INSERT INTO kvg_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yaq Yesu gembo-qavøiu, “Qo mòqo-omét ndego. Ezoqam ngének, ndego ndakin manqat ngeqa-manqate.” ");
INSERT INTO kvg_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Yaq ndego ezoqam gendo-ein, “Evézøza. No mø̀e-unimanqatín!” Yaq até gendego, Yesu-qa megemege-te, katuk ndømøkuí, vømbōvizam. ");
INSERT INTO kvg_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yaq Yesu gembo-ein, “No nqanek manqei-qape-te, ezoqam-qa matev gevewat-qa nøgeavún. Yaq bøi waev mbain ezoqam, bøi tìabiti-kewág, neka bøi eqeieqei ezoqam, bemø̄-bøi-waev-mbain-ezoqam-ez.” ");
INSERT INTO kvg_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Yaq Felisi ezoqa nøme, ndigu avønin giwaniapam, nqanek manqat gimboyogem, ndigu āv gimbøe-einím nqǽgo, “Ge qô, até ní-a, bøi waev mbain ezoqam qotínæna?” ");
INSERT INTO kvg_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yaq Yesu gezø-qavøiu, “Zo amba ande bøi waev mbain ezoqam me tozogonɨn, zo ambá manqa-zapazapa-yav sozogonɨ́n. Geté zo āv qazøte-manqaté nqǽgo, ‘Ni nìkeogé.’ Yaq nakémbá, zo manqa-zapazapa zua zøgó.” ");
INSERT INTO kvg_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu manqat nøme, āv gene-eín nqǽgo, “No unimanqatín nqazø-manqate. Gekha ezoqām ndego, sip-qa khoev-te, mboqog-anim-te oneav tøgoat, getē khoev-te nakhoa vini-tē genø̄qavīg, ndego aqona ezoqám neka pepen ezoqám. ");
INSERT INTO kvg_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Geté sip keoge ezoqam eqeieqei, mboqog-anim-té genø-onɨ́n. ");
INSERT INTO kvg_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mboqog keoge ezoqam, mboqog mbo-mboqozoɨ́n. Tegi sip, teqa manqa wag mø̀ndæzøtéz, neka vø̄yogemɨn. Ndego sip iziz zø-akhayamɨ́n, bavokho sasa ndø-itubin. ");
INSERT INTO kvg_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yaq tegi sip bavokho ge-itubin, gèzømbo-megeɨ́n, ndigu vømbō-paevemɨn. Zapa ndǿgo, ndigu teqa manqa wag, mø̀ndæzøtéz. ");
INSERT INTO kvg_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ndigu ezoqa vini gembó-paevemák. Geté møe mbóbøín. Zapa ndǿgo, ndigu teqa manqa wag zøtezateáv.” ");
INSERT INTO kvg_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu nqanek yaya manqat gezø-eta, ndigu manqa mokho ndapeáv, gekha mé꞉manqate. ");
INSERT INTO kvg_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ndigu nqanek yaya etæ-qa mokho ndapeav qagoam, yaq Yesu manqat nøme āv gezømbe-eín nqǽgo, “No unimanqatín nqazø-manqate. No sip-gí mboqóg. ");
INSERT INTO kvg_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ezoqa ewaqape ibugukhokhof go꞉geavun, ndigu aqona ezoqám neka pepen ezoqám. Geté sip tiqa manqat yogeapáv. ");
INSERT INTO kvg_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","No mboqóg. Gekha ezoqām ndego, no-te tendo-on, ndego khandi ndǿndáp. Yaq ndego, kopømba ande av sip me nduigu, gé-onimát neka nango vǿfakhanāt, gagayag eqeieqei loge nonqo vømǿqeivāt. ");
INSERT INTO kvg_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Aqona ezoqam, sip aqonøvem neka zitøge neka ngiæzoat-qa mba ndo-okhoatún. Geté no ezoqa khandi etoam-qa nogeavún. Yaq ta khandi ndøgo, tàbete-tøvá, ti mokho-te.” ");
INSERT INTO kvg_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yaq Yesu manqat nøme ge꞉zømas, “No sip keoge ezoqam mbomambaqapé. Sip keoge ezoqam mbomambaqape, ekeza khandi gésanqáo, sip zapaya. ");
INSERT INTO kvg_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Geté ezoqa nøme, ndego sip keoge sasae, moni qaqasam nonqo mba ndego, ndego segéteít, gaqo khobos te-omet. Ndego sip segézuváz. Zapa ndǿgo, ndego sip keoge ezoqam eqeieqeí mbá neka ndigu sip ekezán mbá. Yaq gaqo khobokhobos, sip segé-ngeasám, vǿpanqanīm. ");
INSERT INTO kvg_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ezoqam av ngenek nge꞉go, ndego sasae, moni qaqasam nonqo mba ndøgoatún, neka ndego sip gezømbé-køfiayák. ");
INSERT INTO kvg_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Sip keoge ezoqam mbomambaqape, nó. No nøkeza sip mø̀tenøtén, neka ndigu no vø̄ezøtez, ");
INSERT INTO kvg_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ate av-té, Tat no ge꞉-otev neka no ndego vøtēnøten. Yaq no nøkeza khandi nósanqáo, sip zapaya. ");
INSERT INTO kvg_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","No sip nøme ndinø̂gó. Ndigu nqanek sip uta mokho-té mbá. Até ndigú-a, batøndo-khatób. Ndigu noqa manqa wag ndǿyogém. Yaq sip bawan kopo mé꞉goát, neka sip keoge ezoqa kopo vøzǿgoāt. ");
INSERT INTO kvg_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tat kukú no-te. Zapa ndǿgo, no nøkeza khandi nósanqáo, ezoqa zapaya. Yaq no nango tàbate-khandí꞉n. ");
INSERT INTO kvg_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ezoqa ambá av nqǣgo, no khandi ndæ̀vimbām. Geté no nøkeza poev-té qatǿsanqáo. No bazaføgakh nqanø̂gó, nøkeza khandi tæsanqao neka nqawa vǿendāp. No Tat nø-eín, matev av nqægo tægo.” ");
INSERT INTO kvg_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesu nqanek manqat ge-ein, yaq Zu megetapak nangó ginø-qatøném. ");
INSERT INTO kvg_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ndigu ezoqa kopoáv, āv gini-einím nqǽgo, “Nandev ezoqam, nqova soqa mbøigú! Matavap kumbøgeáp, nandev. Gekha zapâ, zo teqa manqat ndozoyoge?” ");
INSERT INTO kvg_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Geté ezoqa nøme, āv gini-einím nqǽgo, “Manqat av nqægo, kopømba mbaín, nqova soqa-us ezoqam-te tøndo-fakhatat. Neka gê, nqova soqa, bøi waev mbain ezoqam áv kené-khakheinøvēm?” ");
INSERT INTO kvg_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Zelusalem taon-te ndøgo, pindap khøuwa kandambaqape ndøfakhán. Zu ezoqam, Mbumbukiam-qá khoev mboqoat khøuwa mbomatavupatún, ma ibugukhokhof ndøgo, Mbumbukiam-qa khoev nqawa teqa zenda-te giveem. Ta khøuwa-te ndøgo, qozaq viav ndø-ogitát. ");
INSERT INTO kvg_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu Mbumbukiam-qa khoev uta mokho-te, Solomon-qá lou-qase-té ge-okhoám. ");
INSERT INTO kvg_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yaq Zu megetapak ndøpindám, te-te, vømbō-bevøpem, “Gê, ni manqat ndaføyamba gekha khøuwā qonimbí-eīn? É-moqoni-eín: Gê, qo Mesayâ?” ");
INSERT INTO kvg_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yaq Yesu gezø-qavøiu, “No mø̀ezø-eín. Geté zo no unimanqatinteáv. Matev ndøgo, no Tat-qa iz-te nqæmatanam, zo ndǿgo tøne-zømesimít, av nqægo, no gekha ezoqām. ");
INSERT INTO kvg_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Geté zo no unimanqatinteáv. Zapa ndǿgo, zo nogí síp mbá. ");
INSERT INTO kvg_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nogi sip, manqa wag nø-ewagatún. No mø̀tenøtén ndigu, neka no ndigu gènøpáev. ");
INSERT INTO kvg_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","No ndigu khandi miavmiav nøzø-etoám. Ndigu sa gemǿ-nasinimák. Ezoqa kopo, ndigu noqa zenda-te gévimbamák. ");
INSERT INTO kvg_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Noge Tat, ndego no ndigu genø-etoam, ndego ezoqa ewaqape ùnime꞉-løvubám. Ezoqa kopømba mbaín, ndigu Tat-qa zenda-te te꞉viwam. ");
INSERT INTO kvg_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","No neka Tat, ni kopó.” ");
INSERT INTO kvg_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yesu nqanek manqat ge-ein, yaq ndigu Zu megetapak, nqawa mbaqambaqa mba ndøpitáz. Ambá gepouimín, vø̄laemɨn. ");
INSERT INTO kvg_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yaq Yesu gezø-ein, “No matev eqeieqei kopoav nomatønumám, zoqa bøi-te, ndøgo Tat-te qando-fakhanam. Yaq gê, nqanek matev eqeieqei ate ndægo, kopo ākhanégo, ta zapaya ndøgo, no lambe-qa nqazonøgo?” ");
INSERT INTO kvg_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yaq ndigu gimbo-qavøinam, “Ni ambá av nqǣgo, qoqa matev eqeieqei zapayā qatī-pouqobēm, vǿi-laqabēm. Geté ni ndǿgo tøtí-laqabém. Qo Mbumbukiam-qá iz qongi꞉wát. Qo ezoqam mbá, qo. Geté qo Mbumbukiam-qá qote-khamasiáp.” ");
INSERT INTO kvg_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yaq Yesu gezø-qavøiu, “Zoqa guguna manqat-te, Mbumbukiam āv gene-eín nqǽgo, ‘No mø̀ezø-eín: Zo mbumbúk.’ ");
INSERT INTO kvg_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ni mìzi꞉nøtén, manqat ndøgo, ta mbuk-te ndøpeawap, unimanqatín. Mbumbukiam-qa Manqat gé-enendák. Mbumbukiam ndigu mbumbuk me꞉zǽb, ti-te ndigu teqa manqat qafakhan. ");
INSERT INTO kvg_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Av tægoat ndægo, yaq gekha zapâ, zo no ndozonø-manqate, ‘qo Mbumbukiam-qā iz qongi꞉wāt’, no qæ-ein, av nqægo, no Mbumbukiam-gē Yō. No Tat ndøveatán neka nqanek manqei-qape-te vøndō-khofotan. ");
INSERT INTO kvg_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","No amba matev matønumav tægonɨn, av noge Tat ndømbøe-poev, yaq ság, zo no ndø-unimanqatìni᷄m. ");
INSERT INTO kvg_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Geté no mø̀ematønumatún. Yaq nakémbá. Zo noqa manqat unimanqatin poeveav tozogoat, zo noqa matev matanam zó-unimanqatiním. Yaq zo tøzøté-zøtéz ndǿgo, neka mokho vozóndapēm, av nqægo, Tat no mokho-té gunu꞉gú neka no Tat mokho-té qatu꞉gú.” ");
INSERT INTO kvg_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yesu nqanek manqat ge-ein, yaq ndigu ambá nqawá ginø-møvøinamɨ́n. Geté ndego sègezømbo-navøém. ");
INSERT INTO kvg_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Taqa zita-te, Yesu nqawa Zoden kea yaq-keoqá genøveséz, ta manqei ndøgo, ma bugukhokhof Zion ezoqa ibøkha iz gezømbe-etoumam. Yaq ndǿgo temøqóm. ");
INSERT INTO kvg_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Yaq ezoqa kopoáv gimøndæ-pindam. Ndigu āv gini-manqatám nqǽgo, “Zion umingiap matev goneáv. Geté manqat ate ndægo, ngenek ezoqam-qa yaq-te ge꞉manqatam, unimanqatín.” ");
INSERT INTO kvg_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Yaq ndøgo, ezoqa kopoáv, gè-unimanqatiním ndego. ");
INSERT INTO kvg_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ezoqa mø̀ndøgoám. Iz Lazalés. Ndego enqoni mbogoám. Ndego tegi sænakheis namba, Meli neka Mata, Betani vemiav-té giyagám. ");
INSERT INTO kvg_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ngunuk Meli, tuge anganøm-yo Lazales enqoni qambogoam, ndúgu, tae etet sisip mbomambaqape, Evezøza-qa zenda tokhotapak-te guoqouz neka yaq susu ekeza izum vømbø̄e-vuogim. ");
INSERT INTO kvg_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Yaq ndigu Lazales-gi sænakheis manqat ndøkhofotøvém, Yesu-te, “Evézøza, qoge qafu mbomambaqape, enqoni mbogó.” ");
INSERT INTO kvg_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Geté Yesu nqanek manqat ge-ewag, ndego āv gene-eín nqǽgo, “Nqanek enqoni, løvøte-te gé-ituák. Geté tønefakhán ndǿgo, Mbumbukiam-qá iz mé꞉-eqá, neka Mbumbukiam-ge Yo, iz kandambaqape vø̄endāp.” ");
INSERT INTO kvg_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu poev kandambá, Mata-te neka tugu namba qawan-te neka Lazales-te. ");
INSERT INTO kvg_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Geté Lazales-qa enqoni-qa yaq-te manqat ge-ewag, ndego nakhamas-te okhoeáv ti-te. Geté ta manqei-te ndøgo, ma ge꞉goam, khøuwa menas nøme, mø̀ndø-qovezám. ");
INSERT INTO kvg_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Taqa zita-te, ndego ekeza paev ezoqam, āv gezømbe-eín nqǽgo, “Nqawa Zudia plovins-té qazinǿ-qaván, Lazales bizimø̄-ometam.” ");
INSERT INTO kvg_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Geté tegi paev ezoqam gimbo-qavøinam, “Nøméndim ezoqam. Nømønqei qagoam, ezoqa qo ambá nandí gini-pouqabemɨ́n ndøgo, vø̄laqabemɨn. Gê, qo unimanqatîn, veseze-qa qógo?” ");
INSERT INTO kvg_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yaq Yesu gezø-ein, “Paveat kopo-te, khøuwa iziz tuélv nqambøigu. Gekha ezoqām ndego, paveat-te te-okhoat, ndego kopømba mbaín tekhaotav, vǿbøiāv. Zapa ndǿgo, paveat-qá waev-té genǿ-okhoát. ");
INSERT INTO kvg_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Geté gekha ezoqām ndego, bøivun-te te-okhoat, ndego ndø̀khaotáv, vǿboiāv. Zapa ndǿgo, ndego waev mbaín.” ");
INSERT INTO kvg_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Taqa zita-te, Yesu manqat nøme, āv gezømbe-eín nqǽgo, “Nigi nøfu Lazales, venanqei ndøbuvít. Geté no nangó qamǿtiú.” ");
INSERT INTO kvg_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yaq tegi paev ezoqam gindu-qavøinam, “Evézøza. Qanimáv. Ndego ndebuvit, yaq ndø̀-eqeieqei-év.” ");
INSERT INTO kvg_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ndigu até vø̄e-einim, Yesu Lazales-qa venanqei sømbiam-qa yaq-te mba me꞉manqaté. Geté ndego teqa løvøte-qa yaq-té gene-eín. ");
INSERT INTO kvg_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yaq Yesu manqat ndaføyamba zø-eín, “Lazales mø̀ndønaním. ");
INSERT INTO kvg_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Geté zo zapaya, no khanakhanákh, no te namba goneav qagoam. Yaq zo kopømbá, no tøne-unimanqatiním. Geté, ság. Ndakin zíniáv te-te.” ");
INSERT INTO kvg_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yaq Tomas, iz nøme gimbo-akhaemam, qaqangeāp, paev ezoqa nøme āv gezømbe-eín nqǽgo, “Sà bizimuniáv. Yaq sizimú-pakhaén te namba.” ");
INSERT INTO kvg_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu Betani vemiav-te gemøfakhan, yaq āv gene-ewág nqǽgo: Lazales manqei-pakha-te mø̀ndø-utøvém. Ndakin khøuwa foa mø̀ndømø-navøém. ");
INSERT INTO kvg_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Yaq Betani vemiav-a, yaq Zelusalem taon, taqa atap khapémbá. Tri kilomita mbá. ");
INSERT INTO kvg_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Zudia ezoqam kopoáv ginduzav, Mata neka Meli eiv vømøzǿ-tøkē, tigi anganøm-yo gezømbe-nanim. ");
INSERT INTO kvg_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mata gu-ewag, av nqægo, Yesu ngêgeāv, yaq nakhoa-té gunøwáv. Yesu mbøeqatáz. Geté Meli khoev-té gunoqotám. ");
INSERT INTO kvg_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Yaq Mata Yesu gumbo-ein, “Evézøza. Qo amba nqanek toqogonɨn, yaq noge anganøm-yo, ambá gé꞉nanimák. ");
INSERT INTO kvg_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Geté no mø̀tenøtén, até ndakín-a, qo Mbumbukiam andē gekha mē toqombo-viam, ndego ndø̀qa-etoám.” ");
INSERT INTO kvg_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yaq Yesu gumbo-qavøiu, “Qoge anganøm-yo nango ndø̀khandí꞉v.” ");
INSERT INTO kvg_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Yaq Mata gundu-ein, “No mø̀tenøtén. Vaev khøuwa-te, løvøte ezoqam tikhandi꞉z, até ndegó-a, tékhandí꞉v.” ");
INSERT INTO kvg_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yaq Yesu gumbo-ein, “Ezoqam nó, ezoqa løvøte-te nqækhandi꞉zat neka khandi nqāzø̄-ētōām. Gekha ezoqām ndego, no nde-unimanqatinat, ndego géyagét, oskia ndego tenanim. ");
INSERT INTO kvg_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Neka gekha ezoqām ndego, ndeyage neka no ndē-ūnīmānqātīnāt, ndego génanimák. Gê, qo nqanek moqó-unimanqatin?” ");
INSERT INTO kvg_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Yaq ndugu gundu-qavøiu, “Evézøza. No mø̀e-unimanqatín, av nqægo, qo Mesayá. Mbumbukiam-gé Yó. Qo ndégo, Mbumbukiam manqat ge-ein, av nqægo, nqanek manqei-qape-te tendo-khofotav.” ");
INSERT INTO kvg_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata nqanek manqat gumu-ein, yaq tugu namba qawan-té gunøqaván, Meli, manqat vømømbō-ein. Sègembo-voá, gumbo-ein, “Nømendim ezoqam mø̀ndø-geavún. Ngêgó nqanek. Qoqa ndøbeváp.” ");
INSERT INTO kvg_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Meli nqanek manqat gu-ewag, yaq ndugu até gundigu, gè-itán, te-te vø̄wav. ");
INSERT INTO kvg_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu vemiav mokho-te fakhaneav ndøgoám. Ndego zua ndo꞉goám, ma Mata gumiqat. ");
INSERT INTO kvg_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ndigu Zu ezoqa nøme, Meli namba khoev-te gigoam, eiv gimbo-tøkeam, gi-ometam, av nqægo, ndugu nakhamas-te gu-itan, vø̄fakhan, yaq ndigu gèmbo-paevém. Ndigu até vø̄e-einim, manqei pakha-tē gunø̄mā. Gemø̄vīn. ");
INSERT INTO kvg_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Meli Yesu-te gumufakhan, gu-omet, yaq teqa zenda tokhotapak-te, ekeza kha, manqei me꞉laváo, vømbō-ein, “Evézøza. Qo amba nqanek toqogonɨn, yaq noge anganøm-yo ambá gé꞉nanimák.” ");
INSERT INTO kvg_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu Meli gu-omet, gu-eivam, neka ndigu Zu ezoqa nøme, namba gi꞉geavun, vø̄-eivumam, ndego mbøni mbonqosøgím, tanakh vøzø̄go. ");
INSERT INTO kvg_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yaq gezøbevap, “Zo ndego gekham-tē qazomǿ-otøvem?” Yaq ndigu gindu-qavøinam, “Evézøza. Bìziniáv, vømø̄qeiv.” ");
INSERT INTO kvg_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yaq Yesu gèvín. ");
INSERT INTO kvg_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yaq ndigu Zu ezoqam, āv gini-einím nqǽgo, “Ndǽ! Ndego kuku kandambá qambogoam te-te.” ");
INSERT INTO kvg_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Geté ezoqa nøme āv gini-einím nqǽgo, “Ngenek, ndego bøi waev mbain ezoqam ndøkhakheinøvém. Yaq gê, kopømba mbaîn, Lazales amba tekhakheinøvemɨn? Yaq ndego ambá génanimák.” ");
INSERT INTO kvg_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu manqei-pakha-te gemefakhan, mbøni kandambaqape, nangó qanømbo-nqosøgím. Ta manqei-pakha ndøgo, køi nqá. Mboqog mbaqambaqa-qapé gini-tokavám. ");
INSERT INTO kvg_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yaq Yesu gezø-ein, “Mbaqambaqa-qape vø̀-qambesømém.” Geté Mata, ndugu løvøte ezoqam-gu sævømiu, gundu-ein, “Evézøza. Vøvanq unimé꞉-soqá. Ndego khøuwa mø̀ndømbo-foa-éz, manqei-pakha-te ngu꞉gu.” ");
INSERT INTO kvg_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yaq Yesu gumbo-ein, “No mø̀taqa-eín. Toqo-unimanqatin, yaq Mbumbukiam-qa bazaføgakh-qape qóqeív.” ");
INSERT INTO kvg_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Yaq ndigu ezoqam até gindigonem, mbaqambaqa-qape vø̄-qambesømem. Yaq Yesu ová genøqán. Yaq āv gene-eín nqǽgo, “Tát! No ike kandambá qo-te. Qo noqa manqat, mòqo-ewág. ");
INSERT INTO kvg_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","No mø̀tenøtén, qo noqa manqat oskia qòyogé. Geté no nqanek manqat ti zapaya ngínik qate-manqaté, ezoqa ewaqape ngiwaniap. Nginik tìabiti-unimanqatiním, av nqægo, no qo qotøndo-khofotán.” ");
INSERT INTO kvg_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesu nqanek manqa manqate qamømbøe-navøem, yaq kandambaqapé møndæ-akhá, “Lázales. Mòqotøndo-fakháq!” ");
INSERT INTO kvg_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Yaq ngenek ezoqam, genanim, sègendo-fakhán. Teqa zenda lou geagim nonqo neka zenda tokhotapak-te, ndabua até gembøe-løvøtupám, neka kawa-te vømbō-løvøtupam. Yaq Yesu ezoqa āv gezømbe-eín nqǽgo, “Ndabua nandav, vø̀mbo-nqovozømém, bēwav.” ");
INSERT INTO kvg_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ndigu Zu ezoqam, Meli-te gindupia, yaq matev giqeivim, Yesu gematanam, ndigu ezoqa kopoáv, gè-unimanqatiním. ");
INSERT INTO kvg_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Geté ezoqa nøme, Felisi ezoqam-té ginøzáv, Yesu-qa matev-qa yaq-te, emanqat vømøzø̄-votot. ");
INSERT INTO kvg_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Yaq Felisi ezoqam neka Mbumbukiam-gi iziz ezoqa kandakanda, Zu megetapak nøme ndøpisám. Manqa ndǿ-ovøemém. Yaq āv ginibondát nqǽgo, “Gekhā zígonēm? Ngenek ezoqam, umingiap matev khàpumu-khouwév, ngematanam. ");
INSERT INTO kvg_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Sa tizimbo-taket, matev av nqægo sa tegot, yaq ezoqa ewaqape gé-unimanqatiním ndego. Yaq Lom megetapak, Mbumbukiam-qa khoev géngi꞉nám neka manqei vønimbí-vinīm.” ");
INSERT INTO kvg_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Yaq ti mokho-te ndigu, ezoqa kopo, iz nqambogo Kayafas, ndego ta viav-te ndøgo Mbumbukiam-ge iziz ezoqam kandambaqape gegoam, ndego āv gene-eín nqǽgo, “Ge zô, matavap mbaîn? ");
INSERT INTO kvg_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mozombó-matøvemem? Qanimav ndǿgo, ezoqa kopo tenanim, ezoqa ewaqape zapaya, ambá ndøgo, ni ezoqam ate nqazi꞉gu, sa tizimu-nasinim.” ");
INSERT INTO kvg_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayafas nqanek manqat ge-ein, ndego ambá av nqǣgo, yakhapus mbā sege-matøvēm. Geté ndego Mbumbukiam-qá manqat ndøveáz. Zapa ndǿgo, ta viav-te ndøgo, ndego Mbumbukiam-gé iziz ezoqam kandambaqapé. Yaq nakémbá, ndego av ge꞉-ein nqægo, Yesu Zu bawan-ak zapaya mē꞉nanīm. ");
INSERT INTO kvg_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Geté unimanqatín, Zu ezoqam zapaya mbá mbá. Geté até ti zapaya ndigú-a, Mbumbukiam-gi nakheis ate ndi꞉gu, manqei-manqei vinivinimba ndindu-yageapet. Yaq até ndigú-a, tìabiti-tøkuaném, vømǿ-kopoēz. ");
INSERT INTO kvg_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ta khøuwa-te ndøgo, Zu megetapak voqoe ndøngazém, av nqægo, Yesu gēlaēm. ");
INSERT INTO kvg_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yaq nakémbá, Yesu Zudia plovins-te, kha sekemba vøndæveáv. Geté Eflaim vemiav-té genøwáv, ndøgo leg-av manqei avønin-te ndøgo. Yaq ekeza paev ezoqam namba, ndǿgo tiyagám. ");
INSERT INTO kvg_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ta khøuwa-te ndøgo, Zu ezoqam-qa Pasova khøuwa kandambaqape, avønín qagoám. Yaq ezoqa ewaqape, Zelusalem taon-té ginøqavát, Mbumbukiam-qa bøi-te, é-betō-ndaføyamba-ez, tiqa khøuwa kandambaqape nonqo, av Mozes-qa guguna manqat qæ-ein. ");
INSERT INTO kvg_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Yaq ndigu Yesu-qa ndøvawát. Mbumbukiam-qa khoev uta mokho-te gimøvabat, ndigu āv ginibondát nqǽgo, “Áv khazøté-matavap? Ndego petøndéwāv penømakhaya, nqanek møvøna kandambaqape-te?” ");
INSERT INTO kvg_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Geté Mbumbukiam-gi iziz ezoqa kandakanda neka Felisi ezoqam, ezoqa manqa é-møndøzømbo-løvuá, av nqægo, gekha ezoqām ndego, te-otev, Yesu ākenégo, bèzø-eín. Zapa ndǿgo, ndigu Yesu møvøiwat-qa mbogoám. ");
INSERT INTO kvg_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Khøuwa siks mba mu꞉-ewabám, Pasova khøuwa kandambaqape. Yaq Yesu Betani vemiav-té genøwáv. Betani vemiav ndǿgo, ma Lazales geqotam, ndego løvøte-te gekhandi꞉v. ");
INSERT INTO kvg_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yaq qakhagus ndøgo, Yesu zapaya, lou ndøkhakheinømém. Mata ndøyogím, lou. Ezoqa nøme, Yesu namba lou loge-te giqonavam, Lazalés. ");
INSERT INTO kvg_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Yaq Meli até gundigu, Yesu-té gunøwáv, botol-qase tae et sisip mbomambaqape, fia kandambaqape, vøndōndap, yaq Yesu-qa zenda tokhotapak-te sasa mo꞉qouz. Yaq ekeza izúm gumbøe-vuogím. Taqa sisip gò꞉yát. Khoev-qape ùnime꞉-gutáv. ");
INSERT INTO kvg_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yaq Yesu-ge paev ezoqa kopo nøme, Zudas Iskaliot, ndego vaev sa gemboqambun, āv gene-eín nqǽgo, ");
INSERT INTO kvg_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nqanek tae et fia kandambaqape, ambá ziwi꞉mín, moni mokho tri andled vizī-qasemɨn. Yaq moni ndigu, ambá gigiap-av ezoqam zizø-etoamɨ́n.” ");
INSERT INTO kvg_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ngenek nqanek manqat ge-ein, ambá av nqǣgo, gigiap-av ezoqam me꞉goām. Geté zapa ndǿgo: Ndego aqona ezoqám. Yesu neka tegi paev ezoqam-gi moni, ndégo tembo-kewagám neka nøme sège-nøzøzoɨ́n, ekezan nonqo. ");
INSERT INTO kvg_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Geté Yesu gembo-ein, “Sègembo-iváv, ngunuk. Ei mbá guni-matanám. Nqanek tae et sisip mbomambaqape gugeatam neka noqa kha-te vō꞉qouz, ngunuk no otønat nonqo me꞉khakheinømbém. ");
INSERT INTO kvg_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Zo gigiap-av ezoqam namba oskia zøté-yageapát. Geté no namba, oskia zí꞉yageák.” ");
INSERT INTO kvg_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Zu ezoqa bawan-qape giyogem av nqægo, Yesu Betani vemiav-tē gegō, yaq ndigu tinøzáv ndǿgo. Ndigu ambá av nqǣgo, Yesu zapaya mbā gini-apāt, geté ndigu até Lazales omete-qa ndøgoám, ndego Yesu løvøte-te gekhandi꞉v. ");
INSERT INTO kvg_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Yaq Mbumbukiam-gi iziz ezoqa kandakanda, nqanek matev giqeivim, ndigu āv gini-voqoém nqǽgo, “Até Lazalés-a, bìzilaém.” ");
INSERT INTO kvg_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Zapa ndǿgo, Lazales zapaya, Zu ezoqa kopoáv, Yesu-té ginønøzáz, ndego vø̄-unimanqatinim. ");
INSERT INTO kvg_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Yaq khøuwa nøme qandopave, ezoqa bawan-qape Pasova khøuwa kandambaqape-te gindupindam, āv giniyogém nqǽgo: Yesu Zelusalem taon-té gendówáv. Avønín géfakhán. ");
INSERT INTO kvg_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Yaq ndigu epek ndø-upøgím, vømbø̄e-qatøzem. Yaq āv gini-akhaemát nqǽgo, “Hosána! Iké꞉ Mbumbukiam-te. Ndego ngenek ezoqam bèkhakheinøvém, Evezøza-qa iz-te ngegeav, ngenek Izlael ezoqam-ge kawa.” ");
INSERT INTO kvg_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yaq Yesu donki ndakinak ndø-omét. Yaq zita-té gembøeqóm, sasa ndøwav. Taqa yaq-te, Mbumbukiam-qa manqat, é-møndo꞉-eín, av nqægo, ");
INSERT INTO kvg_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Zayon ezoqam. Zo møe ndø̀go᷄, zo ezoqam, Zelusalem taon-te ndozoyage. Ngé! Zoge kawa ngégeav. Donki ndakinak-qá zita-té gonoqotáv.” ");
INSERT INTO kvg_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ta khøuwa-te ndøgo, Yesu donki-qa zita-te, Zelusalem taon-te gewav, tegi paev ezoqam nqanek manqat-qa mokho zøtezateáv. Geté vaev-te, Yesu iz kandambaqape gendap, yaq tinizøtéz ndǿgo, nqanek manqat, Yesu-qá yaq-té qane-peaupám. Yaq ezoqa Yesu āv timbøe-matønømém, av Mbumbukiam-qa Manqat bugukhokhof qæ-ein. ");
INSERT INTO kvg_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ndigu ezoqa kopoav, Yesu gi-ometam, Lazales gembo-akha, ndego manqei-pakha-te gegoam, neka løvøte-te vø̄khandi꞉v, ndigu nqanek emanqat sège-vøndazát. ");
INSERT INTO kvg_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Yaq nakémbá, ezoqa kopoav-qape nakhoa-te gizav, Yesu vømbø̄e-qatøzem. Zapa ndǿgo, ndigu nqanek umingiap matev-qa yaq-te, mø̀ndøyogém, Yesu gematanam. ");
INSERT INTO kvg_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Yaq Felisi ezoqam ekeza mokho-mba, āv ginibónd nqǽgo, “Ndǽ, zøtéqeivīm? Ni ezoqa Yesu-qa yaq-te qazizømbi-khafen, kopømba mbaín. Ezoqa ewaqape sègembo-pavét.” ");
INSERT INTO kvg_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ndigu ezoqam-qa mokho-te, Zelusalem taon-te gi-apat, Pasova khøuwa-te Mbumbukiam-qa iz timø-eqanem, Glik ezoqam mø̀ndøgoám. ");
INSERT INTO kvg_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Yaq ndigu Filip-té ginøzáv, ndego Betsaida vemiav-ak, ndøgo Gelili plovins-te, vømbō-einim, “Khanánqa. Ni ambá manqat nimbo-einimɨ́n, Yesu.” ");
INSERT INTO kvg_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Yaq Filip Endlu-té genøwáv, vømømbō-ein. Yaq ndigu ezoqa menas, sasa ndøzav, Yesu vømømbō-einim. ");
INSERT INTO kvg_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yaq Yesu gezø-qavøiu, “Qanimáv. Khøuwa iz mø̀ndøndáp. Mbumbukiam avønín, iz kandambaqape mbó-etoám, Ezoqam-ge Yo. ");
INSERT INTO kvg_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","No unimanqatín nqazø-manqate. Wit nanga, manqei-te bøiazaneav tøgoat neka pakhaezateav vǿgoāt, yaq yakhapus mbá segégoát. Geté tipakhaez, yaq nanga ndǿviám. Kopoáv. ");
INSERT INTO kvg_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Gekha ezoqām ndego, yage-te møqæ tømboyat, ndego ndæ̀khambuá. Geté gekha ezoqām ndego, nqanek manqei-qape-te, ekeza yage zita te꞉wua, ndego miavmiav ndǿgeatát. ");
INSERT INTO kvg_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Gekha ezoqām ndego, noqa sasae gone-qa ndego, ndego no bènøpáev. Yaq ma no tøtegoat, até ndegó-a, gégoát. Gekha ezoqām ndego, noge sasae ezoqam tegoat, ndego noge Tat, iz kandambaqape mbó-etoám.” ");
INSERT INTO kvg_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yaq Yesu manqat nøme gezø-ein, “No nòfofogeapét. Matavap gènømbu-kiambøpét. Gê, no gekha manqat nó-eīn? Ndǿgò? ‘Tát! No vø̀khandī꞉n. Nqanek viniv-qape benøfàkha᷄n.’ Geté āv taoká! No nqánek qategeavún. Khøuwa eqeieqei mø̀ndøndáp. ");
INSERT INTO kvg_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tát! Qakeza iz vø̀-eqá!” Yaq yan-te nqo꞉go, manqat ndofakhán. Āv qane-eín nqǽgo, “No nøkeza iz, mø̀e-eqá. Yaq no nangó qatǿ-eqá.” ");
INSERT INTO kvg_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ezoqa ewaqape, ta manqei-te ndøgo giwaniapam neka nqanek manqat vø̄yogem, nøme āv gini-einím nqǽgo, “Ndand ndønqøōz.” Geté nøme gi-einim, “Enzol ezoqam, manqat mbo-eín.” ");
INSERT INTO kvg_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yaq Yesu gendo-ein, “Manqat nqanek, yan-te qandovis, ambá av nqǣgo, no zapayā qane-manqatām. Geté zo zapayá qane-manqatám. ");
INSERT INTO kvg_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ndakin Mbumbukiam manqei-qape ezoqam gégevezó, neka ndego manqei-qape kawa ezoqam, Saitan, vǿ-ogiū. ");
INSERT INTO kvg_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","No manqei-qape-te nqægo, ti-eqanonam, yaq no ezoqa ewaqape nókhatób, no-te.” ");
INSERT INTO kvg_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu nqanek manqat ge-ein, tenezømás ndǿgo, ndego ande āv kenénanīm. ");
INSERT INTO kvg_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Yaq ezoqa ewaqape gindu-einim, “Mozes-qa guguna manqat, ni qeiyogem, āv qaninømánd nqǽgo, Mesaya ndego miavmiav ndǿyagát. Yaq ge qô, gekha zapâ, qo av ndoqote-manqate nqægo, Ezoqam-ge Yo gēnanīm? Neka gê, ndego Ezoqam-ge Yo, gekha ezoqâm?” ");
INSERT INTO kvg_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yaq Yesu gezø-qavøiu, “Waev, zo mokho-te khøuwa nøme khapémbá tøgoat. Zo ndakin waev zua nandazømbego, yaq waev-té qanø-okhó. Soqaín ndøgo, zo bøivun tøgutaz. Zapa ndǿgo, gekha ezoqām ndego, bøivun-te tema, ndego gé꞉-otevák, ande āv kenéma. ");
INSERT INTO kvg_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ndakin waev zua ndøgó, zo namba. Yaq nakémbá, vø̀-unimanqatiním, nqanek waev, yaq até zó-a, vozó-waev-ezoqam-ēz.” Yesu nqanek manqa manqate qamømbøe-navøem, yaq gèwáv. Gèpeó, ezoqam-te. ");
INSERT INTO kvg_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu ezoqa ewaqape-qa bøi-te, umingiap matev vinivinimba kopoáv gematønumam. Geté até ndøgó-a, ndigu unimanqatinteáv ndego. ");
INSERT INTO kvg_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nqanek matev tønefakhán ndǿgo, Mbumbukiam-qa Manqat tàbete-unimanqatín, tege manqa vevezam ezoqam Aezaya gepeawam. Ndøgo āv qane-manqaté nqǽgo, “Evézøza. Manqat ndøgo, ni qati-zømesimam, gekha ezoqā ndǿ-unimanqatin? Neka gekha ezoqā ndǿmatøvem, av nqægo, nqanek matev kandakanda, Mbumbukiam ndømatanām?” ");
INSERT INTO kvg_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ezoqa kopømba mbaín, Yesu gé-unimanqatinīm. Taqa yaq-te, Aezaya manqat nøme āv gene-eín nqǽgo, ");
INSERT INTO kvg_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Mbumbukiam bøi mø̀ndøzø-gutám, neka mbøni vøzø̄tok. Yaq nakémbá, ndigu kopømba mbaín, bøi ti꞉qeivat neka tiqa mbøni-te, kopømba mbaín, mokho timbo-ndapemat, neka ndigu kopømba mbaín, no-te tinduzav, neka no ndigu vǿe-khakheinøvēm.” ");
INSERT INTO kvg_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aezaya nqanek manqat, Yesu me꞉-eín. Ndego é-møndo꞉qeív, av nqægo, Yesu iz kandambaqape ndǿndáp. ");
INSERT INTO kvg_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ezoqa kopoáv, ndigu Yesu unimanqatinteáv. Geté até Zu megetapak mokho-té-a, nøme mø̀ndø-unimanqatiním. Kopoáv. Geté ndigu gèkhonoumám. Ndigu manqat bavokho einiáv, av nqægo, Yesu-tē ginønøzāz. Zapa ndǿgo, ndigu Felisi ezoqam-te møe ndøgoám. Soqaín ndǿgo, ndigu tiqa guligulim-te tizømbe-khafen. ");
INSERT INTO kvg_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ndigu iz kandakanda, ezoqam-te ndape-qa ndøgoám, ambá ndø̄go, Mbumbukiam-te. ");
INSERT INTO kvg_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yaq Yesu sa manqa ndøyám. Āv gene-eín nqǽgo, “Gekha ezoqām ndego, no nde-unimanqatinat, ndego ambá av nqǣgo, no mba ndø-unimanqatināt. Geté ndego até ndegó-a, no gendo-khofotan, nde-unimanqatînát. ");
INSERT INTO kvg_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Neka gekha ezoqām ndego, no ndenømende, ndego até ndegó-a, no gendo-khofotan, nde-omêté. ");
INSERT INTO kvg_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","No waev nogeavún, nqanek manqei-qape-te. Yaq gekha ezoqām ndego, no nde-unimanqatinat, ndego bøivun-te sekemba géyageák. ");
INSERT INTO kvg_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Gekha ezoqām ndego, noqa manqat ndeyoge, gete o-mba ndapeav ndøgo, no ndego manqa ovøyam-te nǿveák. Zapa ndǿgo, no ambá ta zapaya ndǿgo, tøtegeavún, manqei-qape ezoqam manqa ovøyam-te tæ-ab. Geté no ndigu khandi꞉zat-qa nogeavún. ");
INSERT INTO kvg_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Gekha ezoqām ndego, no ndesanqana neka noqa manqat o-mba ndapeav ndego, matev ndø̂gó, ndego manqa ovøyam-te tøve. Ndego vaev khøuwa-te, manqa ovøyam-te, nqánek qávé, manqat no nqæmanqate. ");
INSERT INTO kvg_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Zapa ndǿgo, manqat ndøgo, no qate-zømesimam, ndøgo ambá av nqǣgo, noqa matavap-tē qando-fakhatē. Geté manqat, Tat nøløvuát, ndego no gendo-khofotan, no gekha manqat banø̄-ein neka ezoqa batē-zømesim. ");
INSERT INTO kvg_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Neka no mø̀tenøtén, manqat ndøgo, no manqa genø-løvua, tøte-zømesim, zo khandi miavmiav zǿ-etoám. Yaq nakémbá, gekha manqāt ndøgo, no nqate-manqate, no āv qate-manqaté, av Tat genømbe-ein.” ");
INSERT INTO kvg_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasova khøuwa kandambaqape, avønín qagoám. Yesu é-møndæ-otév, teqa khøuwa mø̀ndø-fakhān. Ndego nqanek manqei-qape, avønín gé-iváv, Eve-te vǿwāv. Ndego kuku mbogoám, ekeza ezoqam-te, nqanek manqei-qape-te. Yaq ndakin ndego āv genezømás nqǽgo: Teqa kuku kandamba tantáv. ");
INSERT INTO kvg_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Khagus, Yesu ekeza paev ezoqam namba, lou gilog, Zudas, Saemon Iskaliot-ge yo, nqova soqaqape matavap é-møndømbo-etoám, av nqægo, Yesu segembō-qambūn. ");
INSERT INTO kvg_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu mø̀ndæ-otév, Eve matev ate ndægo, teqá zenda-té genøvé. Neka ndego mø̀ndæ-otév, Mbumbukiam-té gendowáv, neka yaq nango Mbumbukiam-te vǿvesēz. ");
INSERT INTO kvg_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yaq Yesu até gendego, lou loge-te geqotam, gè-itán, ndabua mumat go꞉-uzam, gèkhofá, neka ndabua susu vuogim nonqo, bøndim-te vø̄løvøen. ");
INSERT INTO kvg_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Qamømbøeva ndøgo, ndego ndis-te ibøkha ndøqóuz, tegi paev ezoqam-qa zenda tokhotapak sunguzam vø̄ngaz, neka ndabua bøndim-te qambo-løvøetam, susu sasa zømbe-vuogim. ");
INSERT INTO kvg_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yaq Saemon Pita-te gendowav, ngenek Yesu āv gembøe-eín nqǽgo, “Evézøza. Qo ezoqa kandambaqapé. Kopømba mbaín, noqa zenda tokhotapak toqosunguz.” ");
INSERT INTO kvg_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yaq Yesu gembo-qavøiu, “Qo ndakin mokho ndapeáv, matev no nqæmatønumit. Geté vaev-te ndòqome-qatéq.” ");
INSERT INTO kvg_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Yaq Pita gendo-ein, “Kopømba ùnime꞉-mbaín, zenda tokhotapak toqonø-sunguz.” Yaq Yesu gembo-qavøiu, “No qoqa zenda tokhotapak sunguziav tøgoat, yaq qo kopømba mbaín, noge ezoqam toqogoat.” ");
INSERT INTO kvg_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Yaq Saemon Pita gendo-qavøiu, “Evézøza! Av tægoat ndægo, yaq qo zenda tokhotapak mba qonǿ-sunguzák, geté até lou geagim nonqó-a neka kawa voqonǿ-sungūz.” ");
INSERT INTO kvg_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yaq Yesu gendo-qavøiu, “Gekha ezoqām ndego, tekhakuam, teqa kha ate ndægo bæbǽs. Ndego kha nango gésunguzák. Geté zenda tokhotapak mba ndǿsungúz. Até zó-a, bæbǽs. Geté ezoqa ewaqapé mbá.” ");
INSERT INTO kvg_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu é-møndæ-otév, gekha ezoqām ndego, sa temboqambun. Yaq nakémbá, av ge꞉-ein nqægo, “Ezoqa ewaqapē mbā, bæbæs.” ");
INSERT INTO kvg_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu tiqa zenda tokhotapak gumusunguz, yaq ndabua mumat go꞉-uzam, gekhofa, nqawa tène-úz, vø̄qom, ma geqotam ndøgo. Yaq gezøbevap, “Zo mokho mozombó-ndapem, no ndakin matev qazø-matønumat? ");
INSERT INTO kvg_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Zo no ‘Nømendim ezoqam’ neka ‘Evezøza’ zonø-akhayám. Yaq ndøgo qanimáv. Zapa ndǿgo, no unimanqatín, zoge nømendim ezoqám neka zoge Evezøzá. ");
INSERT INTO kvg_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","No zoge Evezøza neka zoge nømendim ezoqam nqægo, zenda tokhotapak qazø-sunguzat, yaq até zó-a, zo yaqyaq-a zenda tokhotapak zósunguzumát. ");
INSERT INTO kvg_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","No matev mø̀tezømás. Yaq até zó-a, matev kopo zómatønumát, av no qazømbe-matanam. ");
INSERT INTO kvg_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","No unimanqatín nqazø-manqate. Sasae ezoqam, ekeza kawa ezoqam géløvuák. Neka u-anim, ma géløvuák, ndego ezoqam, ma gende-khofotav. ");
INSERT INTO kvg_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ndakin zo mø̀zøte-zøtéz, taqa yaq-te. Zo āv tøne-matanám. Yaq zo khanakhanakh-us zógoát. ");
INSERT INTO kvg_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","No ambá av nqǣgo, zo ezoqa ewaqape nøte-manqatē. No mø̀tenøtén, ndigu ezoqam, no qævevesam. Geté manqat ndøgo, Mbumbukiam-qa manqat-te nqapeawap, tàbete-unimanqatín, av qæ-ein nqægo, ‘Ndego ezoqam, lou namba qatilogat, sègenø-qambún.’ ");
INSERT INTO kvg_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ndakin, nqanek matev fakhaneav ndøgo, no é-ndøtezømastét, taqa yaq-te. Yaq matev tøfakhan, zo tø̀ne-unimanqatiním, av nqægo, no ndégo. ");
INSERT INTO kvg_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","No unimanqatín nqazø-manqate. Gekha ezoqām ndego, ezoqa nøme tekhato, ndego no qatøndo-khofotav, ndego no ndǿkhatómb. Neka gekha ezoqām ndego, no tekhatomb, ndego ndégo tékható, ma no gende-khofotan.” ");
INSERT INTO kvg_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu nqanek manqat gumu-ein, yaq ndego mbøni mbová. Yaq ndego manqat ndaføyamba zø-eín, av nqægo, “No unimanqatín nqazø-manqate, zo ezoqa kopo segenǿ-qambún, neka no qaqa ezoqam-qa zenda-te vǿvē.” ");
INSERT INTO kvg_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yesu-gi paev ezoqam, nqanek manqat giyogem, yaq sègewambám. Gò꞉bevøpém, ndego gekha ezoqām mé꞉manqate. ");
INSERT INTO kvg_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ndego paev ezoqa nøme, Yesu kuku qambogoam te-te, ndego Yesu avønin-té geqotám. ");
INSERT INTO kvg_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Yaq Saemon Pita, bøi mba mbokhouwá, av nqægo, “Qombøébevāp, nandev. Gekha ezoqā mé꞉manqate?” ");
INSERT INTO kvg_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Yaq ndego paev ezoqam, Yesu-té genøsiná, vømbōbevap, “Evézøza. Gekha ezoqām qoté-manqate?” ");
INSERT INTO kvg_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yaq Yesu gendo-qavøiu, “No lou mbewat, yaf-té qatúqoqóm. Yaq gekha ezoqām ndego, tæmbo-etoam, ezoqam ndégo.” Yaq Yesu até gendego, yaf-te lou mbewat vø̄uqoqom, Zudas, ndego Saemon Iskaliot-ge yo, sasa mbo-etoam. ");
INSERT INTO kvg_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Zudas nqanek lou mbewat gendap, yaq Saitan mu꞉-ón, teqa mokho-te. Yaq Yesu āv gembøe-eín nqǽgo, “Matev ndøgo, qo matanam-qa ndoqogo, nakhamas-té qanøgó.” ");
INSERT INTO kvg_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ndigu ezoqa nøme, lou loge-te giqonavam, ndigu mokho ndapeáv, gekha zapā Yesu nqanek manqat gembo-ein. ");
INSERT INTO kvg_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ezoqa nøme āv gini-matavupám nqǽgo: Yesu Zudas loge gigiap wi-qa yaq-te abembøe-eín, tiqa khøuwa kandambaqape nonqo, o gigiap-av ezoqam moni etoam-qa yaq-te abembøe-eín. Zapa ndǿgo, moni ndégo tembo-kewagám. ");
INSERT INTO kvg_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Zudas nqanek lou mbewat ge꞉ndap, yaq até gendego, bavokho vø̄fakhan. Ta khøuwa-te ndøgo, lová. ");
INSERT INTO kvg_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Zudas ge-ivav, gewav, yaq Yesu āv gene-eín nqǽgo, “Ndakin Ezoqam-ge Yo, iz kandambaqape ndǿndáp. Neka te mokho-te, Mbumbukiam iz kandambaqape vǿndāp. ");
INSERT INTO kvg_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Mbumbukiam Ezoqam-ge Yo-qa mokho-te, iz kandambaqape tendap, yaq ndego até Ezoqam-gé Yó-a, iz kandambaqape mbó-etoám. Unimanqatín, ndego iz kandambaqape, avønín é-ndømbo-etoám. ");
INSERT INTO kvg_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nogi nakheis. No ndakin khøuwa khapímbá, zo namba tøtegoat. Zo no ambá ndøzønømbe-vawém. Geté, av Zu megetapak qazømbe-ein, no zo manqat kopó, āv tæzømbé-eín, ‘Zo kopømba mbaín tozotøndozav, ma no nqatema.’ ");
INSERT INTO kvg_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","No zo ndakin guguna manqat ndakinak nøzǿ-løvuá. Manqat nqánek: Zo kuku yà bezøgó, yaqyaq-a. Av no kuku qanømbe-goam zo-te, yaq até zó-a, zo kuku āv tabezømbe꞉gó, yaqyaq-a. ");
INSERT INTO kvg_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Zo kuku tøzøgoat, yaqyaq-a, yaq ezoqa ewaqape segézøtéz, av nqægo, zo nogí paev ezoqám.” ");
INSERT INTO kvg_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saemon Pita Yesu gembobevap, “Evézøza. Gê, qo ākhoqotéma?” Yaq Yesu gembo-qavøiu, “No ma nqatema, qo ndakin kopømba mbaín, toqonøndo-paev. Geté vaev-te, qo qonøndó-páev.” ");
INSERT INTO kvg_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Yaq Pita gembobevap, “Evézøza, gekha zapâ, no kopømba mbaīn ndøgo, qo ndakin tøtaqando-paev? No notónaním, qo zapaya.” ");
INSERT INTO kvg_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yaq Yesu gendo-qavøiu, “Gê, qo unimanqatīn qotó-naqanīm no zapaya? Āv taoká. No unimanqatín nqataqa-manqate, kokolok naqanøká gé-ogeayák. Qo noqa yaq-te, ndòqotøkhæ-nawám. Misiká toqoto-nawam.” ");
INSERT INTO kvg_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yaq Yesu manqat nøme gezø-ein, “Zo mbøni bezø̀va᷄. Geté zo Mbumbukiam zó-unimanqatiním. Neka até no-á, vø̄-unimanqatinim. ");
INSERT INTO kvg_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Noge Tat-qa khoev-te, kougiap kopoáv. Amba mbain tøgonɨn, no av nqægo ambá nøzømbé-einák. Yaq no tøtemá ndǿgo, zo khoev nomøzǿ-khakheinám. ");
INSERT INTO kvg_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","No tænav ndøgo, khoev vømøzǿ-khakheinām, yaq nango ndø̀tøndo-veséz, zo vǿekhatōb, nøkezan-te. Yaq até zó-a, tø̀negó, ma no tøtegoat. ");
INSERT INTO kvg_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Zo nakhoa mø̀zøte-zøtéz, ndøgo ndølowe, ma no tøtema.” ");
INSERT INTO kvg_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Yaq Tomas gembobevap, “Evézøza, ni nøtenateáv, ma qo toqotema. Gê, ni nakhoa áv khatínøtēn?” ");
INSERT INTO kvg_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yaq Yesu gembo-qavøiu, “Nakhoa, nó. Neka unimanqatin, nó. Neka khandi, nó. Ezoqa no mokho-te mbá, gindúzáv, atema Tat-te. Nakhoa nøme mbaín. ");
INSERT INTO kvg_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Zo no qazøte-zøtez, yaq zo até nogé Tát-a, ndø̀zøte-zøtéz. Até ndakín-a, zo mø̀zøte-zøtéz ndego. Neka zo ndego mòzo-ometám.” ");
INSERT INTO kvg_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Yaq Filip gembo-ein, “Evézøza. Ni ambá Qave qoti-nømandɨ́n. Ság, nqanek.” ");
INSERT INTO kvg_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yaq Yesu gendo-qavøiu, “Fílip. No nupøkhán mbá, zo namba nqaziyage. Yaq gê, qo no qateqateâv? Gekha ezoqām ndego, no genømend, ndego Tat ndø-omét. Gekha zapâ, qo no ndoqonø-manqate, av nqægo, ‘Ni ambā Qave qoti-nømandɨ̄n?’ ");
INSERT INTO kvg_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Gê, qo unimanqatinteâv, av nqægo, no Tat-qā mokho-tē qatu꞉gū neka ndego Tat, no mokho-tē gunu꞉gū? Manqat ndøgo, no nqazø-manqate, no ambá av nqǣgo, nøkeza matavap-tē qatø-manqatē. Geté Tat mu꞉sasaeát, ndego noqa mokho-te ngu꞉gu. ");
INSERT INTO kvg_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Zo no vø̀-unimanqatiním, no zo av nqazømbe-manqate nqægo, no Tat mokho-tē qatu꞉gū, neka ndego Tat, no mokho-tē gunu꞉gū. Geté zo nqanek manqat unimanqatinteav tøgoat, zo tøzøté-unimanqatiním ndǿgo, no matev nqæmatanam. ");
INSERT INTO kvg_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","No unimanqatín nqazø-manqate. Gekha ezoqām ndego, no nde-unimanqatinat, ndego matev āv gené-matønumát, av no nqate-matanam. Unimanqatín. Matev ndøgo, tematønumat, ndø̀mø-løvuám, av matev no nqate-matanam. Zapa ndǿgo, no Tat-té qatømá. ");
INSERT INTO kvg_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Yaq gekha matēv ndøgo, zo noqa iz-te tozo-viømemat, no ndæ̀matønumát. Yaq ndǿgo, Yo mokho-te, Tat-qa iz tàbete-eqawát. ");
INSERT INTO kvg_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Unimanqatín. Gekha matēv ndøgo, zo noqa iz-te tozotøndo-viømemat, no ndæ̀matønumát.” ");
INSERT INTO kvg_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yaq Yesu manqat nøme gezø-ein, “Zo kuku tøzøgoat no-te, yaq zo noqa manqa løvuat manqat ndòzombo-pavát. ");
INSERT INTO kvg_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","No Tat ndæ̀mboviám. Yaq ndego zo tøke ezoqam nøme zǿ-etoám. Yaq ngenek zo namba mé꞉yagát, miavmiav. ");
INSERT INTO kvg_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ngenek tøke ezoqam, Nqova Mbomambaqapé. Ndego unimanqatin manqat mba ndømanqaté. Manqei-qape ezoqam, kopømba mbaín, tindafem. Zapa ndǿgo, ndigu ndego ometupáv neka ndego zøtezateáv. Geté zo ndego mø̀zøte-zøtéz. Zapa ndǿgo, ndego zo namba me꞉gó neka zo mokho-te até gú꞉goát. ");
INSERT INTO kvg_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","No tænav, no ambá av nqǣgo, zo andē loundik me nøtézuvāz. Geté no nango ndø̀tøndoqaván, zo-te. ");
INSERT INTO kvg_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Khapé gé꞉-auwamák. Yaq manqei-qape ezoqam no nango génømendamák. Geté zo no ndòzo-nømendát. Zapa ndǿgo, no tæyagat, yaq até zó-a, zo ndòzoyagát. ");
INSERT INTO kvg_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ta khøuwa-te ndøgo, zo tøzøté-zøtéz ndǿgo, no Tat-qā mokho-tē qatu꞉gū neka zo no mokho-tē qazotu꞉gū neka no zo mokho-tē qatu꞉gū. ");
INSERT INTO kvg_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Gekha ezoqām ndego, noqa guguna manqat te-ewagat neka vømbópavāt, ezoqam ndégo, kuku ndømbogo no-te. Neka gekha ezoqām ndego, no-te kuku ndømbogo, noge Tat kukú te-te. Neka até nó-a, kukú te-te. Neka no ndego, nøkezan-qa yaq-te, nombó-vøndøyám.” ");
INSERT INTO kvg_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yaq Zudas gembo-ein, (ngenek Zudas teoká ndego, Zudas Iskaliot), “Evézøza, gekha zapâ, qo ni qakezan-qa yaq-te toqoni-vøndøyam, getē manqei-qape ezoqam qozø̄-vøndøyamāk?” ");
INSERT INTO kvg_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yaq Yesu gembo-qavøiu, “Gekha ezoqām ndego, no-te kuku tømbogoat, ndego noqa manqat o-mba mbøéndapát. Yaq noge Tat kuku mbógoát te-te. Yaq ni nitøndú-niáv, te namba vøtíqōm. ");
INSERT INTO kvg_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Geté gekha ezoqām ndego, kuku mbain tøgoat no-te, ndego noqa nømendim manqat, o-mba gó꞉ndapeák. Nqanek manqat zo nqazoyoge, ndøgo ambá av nqǣgo, nøkeza manqāt, geté ndøgo Tat-qá manqát, ndego no gendo-khofotan. ");
INSERT INTO kvg_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","No nqanek manqat, tæzømbe-eín ndǿgo, ate av-té, no zo namba nqate꞉go. ");
INSERT INTO kvg_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ndego tøke ezoqam, Nqova Mbomambaqape, ndego Tat noqa iz-te tendo-khofotav zo-te, ndego zo matev ate ndægo gé꞉zømesimát neka matavap vøzǿ-mboqoayāt, manqat ate ndægo, no qazø-manqatam. ");
INSERT INTO kvg_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","No mbøni bøiv matev nøzǿ-iváv zo-te. Noqá mbøni bøiv matév. Mbøni bøiv matev ndøgo, tæzø-etoam, viní. Āv taoká, av manqei-qape ezoqam ndizømbe-etoam. ");
INSERT INTO kvg_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Zo manqat mòzonø-yogém, no qazø-ein, av nqægo, ‘No nø̀má. Geté no nango ndø̀tøndo-veséz zo-te.’ Zo amba kuku tøzøgonɨn, no-te, yaq zo ambá khanakhanákh, no Tat-te nqæma. Zapa ndǿgo, ndego no mø̀ndø-løvumbám. ");
INSERT INTO kvg_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Matev okhokho-té qanǿfakhán. Geté no ndakin é-bazømbe-eín. Yaq matev tøfakhan ndøgo, zo tø̀ne-unimanqatiním. ");
INSERT INTO kvg_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","No zo namba, manqat kandakanda nøme nómanqateák. Zapa ndǿgo, nqanek manqei-qape-ge megeat ezoqam, Saitan, ngégeav. Ndego kopømba mbaín, no tetømbuno. ");
INSERT INTO kvg_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Geté manqei-qape ezoqam, tìabiti-zøtéz, av nqægo, no kukú Tat-te. Yaq nakémbá, no matev ate nqægo, āv tøtégót, av ndego no manqa genømbe-løvua. Mā. Bìziniáv. Nqane manqei bìzi-ivøvém.” ");
INSERT INTO kvg_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu tegi paev ezoqam, manqat nøme, āv gezømbe-eín nqǽgo, “No unimanqatin waen táe, neka noge Tat, waen khae keoge ezoqám. ");
INSERT INTO kvg_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Gekha tāng ndøgo, no-te nqago, nanga vi꞉mav ndøgo, ndego géqóg. Geté tang ndøgo, nanga qavi꞉matun, tang-qasis qapakhapakhawamɨn, gèmøkuiamɨ́n. Ndego tenegoatún ndǿgo, yaq tang ndøgo, tàbete-eqeieqeí neka nanga kopoav betēviam. ");
INSERT INTO kvg_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Zo mòzo-eqeieqei-éz. Noqa nømendim manqat mokho-té, zo qate-zømesimam, tøzøte-eqeieqei-éz. ");
INSERT INTO kvg_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Zo no mokho-te até vøugú, yaq no zo mokho-te oskia nøtúgoát. Tang kopømba mbaín, ekezan mba nanga tøviam, geté tae-te tøbunøzupit. Zo até kopó. No mokho-te goneav tozogoat, zo kopømba mbaín, mokho tøzøfakhan. ");
INSERT INTO kvg_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","No waen taé, neka zo tangtáng. Gekha ezoqām ndego, no mokho-te tu꞉goat neka no te mokho-te vøtúgoāt, ndego mokho kandambá tømbo-fakhan. Zo no namba bunøzeav tøgoat, zo matev-qase kopømba mbaín, tozo-matønumat. ");
INSERT INTO kvg_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Gekha ezoqām ndego, no mokho-te goneav tøgoat, ndego ande tang soqaqape me mé꞉-ogím, vǿkakavøēm. Tangtang av nqægo gémøvøyám, gøinam-te sasa mǿnqagīm, vǿlønqotām. ");
INSERT INTO kvg_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Zo no mokho-te ate tozotugoat neka noqa manqat zo mokho-te ate vǿugoāt, yaq gekha matēv ndøgo, zo poev tøzøgoat, vø̀viømemát, yaq zo ndòzo-upøgimát. ");
INSERT INTO kvg_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Zo mokho kandamba tøzø-fakhanam neka ta mokho-te tøzøte-zømas, av nqægo, zo nogī paev ezoqām, noge Tat iz kandambaqape ndǿgo tenéndáp. ");
INSERT INTO kvg_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","No kuku zo-te, āv qanømbegó, av Tat kuku ndømbøego no-te. Zo até vøugú, noqa kuku matev mokho-te. ");
INSERT INTO kvg_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Zo noqa manqa løvuat manqat, o-mba tozoto-ndapat, yaq zo noqa kuku matev mokho-te oskia ndòzotu꞉-goát, ate av-té, no Tat-qa manqa løvuat, o-mba nqato-ndape, neka no teqa kuku matev-te oskia nqatu꞉gu. ");
INSERT INTO kvg_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","No zo nqanek manqat, tæzømbe-manqaté ndǿgo: Noqa khanakhanakh zo mokho-te tàbetegó neka zoqa khanakhanakh tàbezømbe-tøtøvøyám. ");
INSERT INTO kvg_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Noqa manqa løvuat nqánek: Zo yaqyaq-a kuku āv tabezømbe꞉gó, av no kuku nqanømbe꞉go zo-te. ");
INSERT INTO kvg_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ezoqa zifuap-te kuku kandambaqape tømbogoat, yaq ekeza yage sa tenqonqotav, ti zapaya, teqa kuku matev, ùnime꞉-løvuám, kuku matev ate ndægo. ");
INSERT INTO kvg_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Zo nogí nøfuáp, zo manqat tozombo-pavat, no nqazø-løvuat. ");
INSERT INTO kvg_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","No zo ndakin sasae ezoqam, sekemba nøzǿ-akhayamák. Zapa ndǿgo, sasae ezoqam mè꞉zøtezák, ekeza kawa ezoqam, ande gekha matev me mé꞉gō. Geté no zo nøfuap nøzø-akhayám. Zapa ndǿgo, manqat ate qægoam, Tat-te qæ-ewagam, no zo mø̀te-zømesimám. ");
INSERT INTO kvg_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Zo ambá av nqǣgo, no zo zoveatønēm. Geté zo no nøvevesám. Neka no zo tøte-abám ndǿgo, zo mokho kandambaqape tàbezømbe-fakhán. Yaq ta mokho ndøgo, ate nonqo tàbetegót. Yaq gekha matēv ndøgo, zo Tat noqa iz-te tozombo-viømemat, ndego segezǿ-etoumát. ");
INSERT INTO kvg_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Noqa manqa løvuat manqat zo-te nqánek: Zo kuku yà bezøgó, yaqyaq-a.” ");
INSERT INTO kvg_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yaq Yesu manqat nøme gezø-ein, “Zo manqei-qape ezoqam tisanqabat, yaq zo manqa matev nqawá qanø-eimimát, av nqægo, ndigu bugukhokhof no mo꞉sanqambám. ");
INSERT INTO kvg_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Zo amba manqei-qape-gi tozogonɨn, yaq manqei-qape ezoqam, ambá kuku zøgonɨ́n zo-te, ate av-té, ekeza ezoqa nøme-te, kuku ndøzømbe꞉go. Geté zo manqei-qape-gí mbá. No nø̀vevesám zo, nqanek manqei-qape-te. Yaq nakémbá, ndigu manqei-qape ezoqam, zo gèsanqazá. ");
INSERT INTO kvg_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Gèmbo-mataváp. No āv qazømbe-eín nqǽgo, ‘Sasae ezoqam, ekeza kawa ezoqam géløvuák.’ Ezoqa no ngenøgim ginøgoam, yaq ndigu até zó-a, ngenøgim zǿgoát. Neka ezoqa, noqa nømendim manqat gi-upøgimam, yaq até zoqá nømendim manqát-a, ndø̀-upøgimát. ");
INSERT INTO kvg_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ndigu zo nqanek matev ate ndægo, no zapayá gizømbé-matønumát. Zapa ndǿgo, ndego ezoqam, no gendo-khofotan, ndigu zøtezateáv. ");
INSERT INTO kvg_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","No okhoeav tøgonɨn neka no ndigu manqat einiav vø̄gonɨn, ndigu manqa-zapazapa ambá mbaín sègegonɨ́n. Geté no mø̀egeavún neka no ndigu manqat vøzø̄-ein. Yaq nakémbá, ndigu kopømba mbaín ti-einim, av nqægo, ‘Ni manqa-zapa-ūs mbā, zapa ndø̄go, ni nøtenateāv.’ ");
INSERT INTO kvg_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Gekha ezoqām ndigu, no ndisanqana, ndigu até nogé Tát-a, ndisanqâwé. ");
INSERT INTO kvg_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","No ti mokho-te amba matev goneav tøgonɨn, av bugukhokhof ezoqa goneav qagoam, ndigu manqa-zapazapa ambá mbaín sègegonɨ́n. Geté ndigu noqa matev mø̀ndø-qeivám. Geté até ndøgó-a, ndigu no sège-sanqambám, Tat namba. ");
INSERT INTO kvg_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Geté nqanek matev tønefakhán ndǿgo, Mbumbukiam-qa Manqat tàbete-unimanqatín, tiqa guguna manqat-te ndøpeawap, av nqægo, ‘Ndigu no khokhó sege-sanqambám. Mokho mbaín.’ ");
INSERT INTO kvg_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ndego tøke ezoqam tendowav, no zo-te tøtøndo-khofotav, no Tat-te tægoat, ndego zo mé꞉zømesimát, noqa yaq-te. Ndego tøke ezoqam, Nqova Mbomambaqapé. Ndego Tat-té gendowavɨ́n neka unimanqatin manqat mba ndømanqaté. ");
INSERT INTO kvg_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Neka ate zó-a, zo ezoqa noqa yaq-te vøzøté-zømesimāt. Zapa ndǿgo, zo oskia zogoám no namba, no sasae ande qatengaz, atema ndakin.” ");
INSERT INTO kvg_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“No zo nqanek manqat ndǿgo tæzømbe-manqaté, zoqa unimanqatin navøepøteav tàbezømbegó. ");
INSERT INTO kvg_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Zo Zu ezoqam-qa guliguli khoev-te, gizømbé-khafeapát. Unimanqatín. Khøuwa ndø̀mø-fakház. Yaq ezoqa zo løvøte-te ti-abumat, ndigu āv giní-matavupát nqǽgo: Ndigu Mbumbukiam-qā sasae ndøgōt. ");
INSERT INTO kvg_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ezoqa matev av nqægo, zapa ndǿgo tinígoném, ndigu no mè꞉zøtezák, neka até noge Tát-a, mè꞉zøtezák. ");
INSERT INTO kvg_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Geté no zo nqanek manqat tæzømbe-manqatám ndǿgo, ta khøuwa ndøgo timøfakhaz, yaq zo matavap nango tàbezømbe-vesezú, no ande gekha manqat me nøzømbē-manqatam. No zo bugukhokhof manqat einiáv, taqa yaq-te. Zapa ndǿgo, ta khøuwa-te ndøgo, no mø̀egoám, zo namba.” ");
INSERT INTO kvg_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yaq Yesu tegi paev ezoqam, manqat nøme gezø-ein, “No ndakin nø̀má. Te-te ndégo tøtømá, no ma gende-khofotan. Geté zo ezoqa kopo no-te bevøpøteáv av nqægo, ‘Gê, qo ākhoqotéma?’ ");
INSERT INTO kvg_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Zapa ndǿgo, zo mbøni zøvá, ta zapaya ndøgo, no qazø-ein. ");
INSERT INTO kvg_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Geté no unimanqatín nqazø-manqate. Ndøgo qanimáv zo-te, no tænav. Zapa ndǿgo, no okhoeav tøgoat, yaq ndego tøke ezoqam gendówavák zo-te. Geté no tænav, yaq no ndego notøndó-khofotáv zo-te. ");
INSERT INTO kvg_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ndego tendowav, ndego manqei-qape ezoqam āv genézømás nqǽgo: Tiqa matavap soqaín, manqa-zapa neka matev eqeieqei neka Mbumbukiam-qa manqa ovøyam-qa yaq-te. ");
INSERT INTO kvg_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Manqa-zapa-qa yaq-te, ndego te꞉zømas: Manqa-zapa nqánek, ndigu no unimanqatinteav ndøgo. ");
INSERT INTO kvg_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Neka matev eqeieqei-qa yaq-te, ndego te꞉zømas: Ezoqa Mbumbukiam-qa bøi-te, ta mokho-te ndǿgo tiní-eqeieqei-éz, no Tat-te tænav. Yaq zo nango zónømendamák. ");
INSERT INTO kvg_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Neka manqa ovøyam-qa yaq-te, ndego te꞉zømas: Mbumbukiam ndego manqei-qape-ge megeat ezoqam, Saitan, manqa ovøyam-te mø̀ndøvé. Ndego yaq-fia nqosøgeap, ndø̀møqeív. ");
INSERT INTO kvg_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","No zo-te manqat kandambá, manqa manqate-qa nqægo. Geté zo ndakin kopømba mbaín, mokho tozombo-ndapem. ");
INSERT INTO kvg_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Geté Nqova Mbomambaqape tendowav, ndego unimanqatin manqat mba ndemanqate, yaq ndego zo unimanqatin manqat-té genǿ-itúb, ate ndægo. Ndego ambá av nqǣgo, ekeza matavap-tē genǿ-manqatāt. Geté ndǿgo témanqatát, manqat ndøgo te-ewagat. Neka ndego gé꞉zømesimát, megemege-te ndo꞉go, ande gekha matev me mó꞉fakhanām. ");
INSERT INTO kvg_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ndego noqa iz ndǿ-eqatát. Zapa ndǿgo, manqat ndøgo, zo te꞉zømesimat, no-té gé-upøgimát. ");
INSERT INTO kvg_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Matev neka bazaføgakh ate ndægo, noge Tat ndømbogo, ndøgo noqá. Yaq nakémbá no qæ-ein av nqægo, manqat ndøgo, ndego Nqova Mbomambaqape zo te꞉zømesimat, ndøgo no-tē gē-upøgimāt.” ");
INSERT INTO kvg_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yaq Yesu tegi paev ezoqam manqat nøme, āv gezømbe-eín nqǽgo, “Khøuwa khapémbá ngu꞉yoza, yaq zo no sekemba zónømendeák. Yaq taqa zita-te, khøuwa khapémbá tu-ewabat, yaq zo no nqawa ndòzo-nømendám.” ");
INSERT INTO kvg_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yaq ndigu ekeza paev ezoqa nøme gibond, “Nqanek gekha mokhô, ngenek av ginimbi-ein nqægo, ‘Khøuwa khapēmbā ngu꞉yoza, yaq zo no sekemba zōnømendeāk. Yaq taqa zita-te, khøuwa khapēmbā tu-ewabat, yaq zo no nqawa ndòzo-nømendām.’? Neka ndøgo gekha mokhô, ge-ein av nqægo, ‘Zapa ndø̄go, no Tat-tē qatømā.’?” ");
INSERT INTO kvg_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Yaq ndigu nøme āv ginibondát nqǽgo, “Nqanek manqat, ‘Khøuwa khapēmbā,’ ndøgo gekha mokhô? Ni zì꞉nøtenák, ngenek gekha mē꞉manqate.” ");
INSERT INTO kvg_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu mø̀ndæ-otév, ndigu ambá gembo-bevøpemɨ́n. Yaq ndego āv gezømbe-eín nqǽgo, “Gê, zo ndǿgo tøzøté-bondet, no av qazømbe-ein nqægo, ‘Khøuwa khapēmbā ngu꞉yoza, yaq zo no sekemba zōnømendeāk. Yaq taqa zita-te, khøuwa khapēmbā tu-ewabat, yaq zo no nqawa ndòzo-nømendām.’? ");
INSERT INTO kvg_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","No unimanqatín nqazø-manqate: Zo ndòzo-eivám neka mbøni vøzǿvā. Geté manqei-qape ezoqam, khanakhanakh zǿ-asøtáv. Zo mbøni ndø̀zøvá. Geté zoqa mbøni vaev, segemǿ-qambuí. Yaq zo khanakhanakh møzǿ-asøtáv. ");
INSERT INTO kvg_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Sævam gui-ovaɨn, qakhantavɨn, ndugu mbøni mbovaɨ́n. Zapa ndǿgo, tuqa nqosøgeap khøuwa mø̀ndøndáp. Geté nakhasam geqomɨn, yaq ndugu nqosøgeap sekemba gembó-matavapák. Zapa ndǿgo, ndugu khanakhanákh. Nakhasam ndakinak ndøfakhán, manqei-qape-te. ");
INSERT INTO kvg_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Até zó-a, zo ndakin mbøni zøvavét. Geté zo nqawa ndæ̀zømét. Yaq zo khanakhanakh møzǿ-asøtáv. Yaq ta khanakhanakh ndøgo, ezoqa kopømba mbaín, zo ti꞉vibam. ");
INSERT INTO kvg_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ta khøuwa-te ndøgo, zo no sekemba zonǿ-bevapák. No unimanqatín nqazø-manqate. Gekha matēv ndøgo, zo Tat noqa iz-te tozombo-viømemat, ndego segezǿ-etoumát. ");
INSERT INTO kvg_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Atema ndakin, zo Mbumbukiam-te noqa iz-te viimáv. Geté zo gèviám, yaq zo ndòzo-upøgimát. Yaq zoqa khanakhanakh, nøme mba tàbete-tøtøvøyám.” ");
INSERT INTO kvg_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yaq Yesu tegi paev ezoqam, manqat nøme āv gezømbe-eín nqǽgo, “No zo manqat qazø-manqatam, yaya nøzø-etæám. Geté khøuwa ndø̀mø-fakház, yaq no zo yaya sekemba nøzǿ-etæák. Geté zo Tat-qa yaq-te, manqat bavokhó sæzømbó-manqatát. ");
INSERT INTO kvg_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ta khøuwa-te ndøgo, zo Tat noqá iz-té qazonømbó-vi꞉mát. No einiáv av nqǣgo, Tat nō nombóvi꞉māt zoqa yaq-te. ");
INSERT INTO kvg_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Zapa ndǿgo, ndego Tat ekezan, kukú zo-te. Ndego kuku zo-te tømbøegó ndǿgo, zo no-te kuku ndøzømbego neka vozō-unimanqatinim, av nqægo, no Tat-tē qatøndonāv. ");
INSERT INTO kvg_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Unimanqatín. No Tat-té qatøndonáv, manqei-qape-te vø̄efakhan. Yaq ndakin no manqei-qape nqawá qatǿ-iváv. Yaq Tat-té qatǿqaván.” ");
INSERT INTO kvg_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yesu nqanek manqat gezø-ein, yaq ekeza paev ezoqam āv gimbøe-einím nqǽgo, “Nqáe! Qo ndakin manqat bavokhó qotø-manqaté. Qo ambá av nqǣgo, yaya sekembā soqoni-etǣ. ");
INSERT INTO kvg_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ni ndakin mø̀tinøtén, qo matev ate ndægo mòqote-qatéq. Até ezoqam-qá beváp-a, qo é-moqote-qateqɨ́n. Yaq ni nqánek qati-unimanqatinát, av nqægo, qo Mbumbukiam-té qoqotøndoqáv.” ");
INSERT INTO kvg_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yaq Yesu gezø-qavøiu, “Ge zô, ndakin tozó-unimanqatinat? ");
INSERT INTO kvg_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nqáe! Khøuwa nqágeav. Unimanqatín. Ndøgo mø̀ndø-fakhán. Yaq zo khokhó sozó-panqanimít. Zøkeza kha mba zøtéqeivít, yaq no sozó-nøuvøném. Geté no ambá av nqǣgo, nakhapūs sægō. Zapa ndǿgo, Tat ngêgó, no namba. ");
INSERT INTO kvg_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","No zo nqanek tæzømbe-eín ndǿgo: Zo mbøni bøiv tø̀negó, no mokho-te. Zo nqanek manqei-qape-te, viniv zo-eqawát. Geté zo anøzi ndøgó! Zapa ndǿgo, no manqei-qape-qa bazaføgakh, mø̀etømbuá.” ");
INSERT INTO kvg_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu nqanek manqa manqate qamømbøe-navøem, yaq yan-té genøqán, manqat sasa ndø-ein, “Tát! Khøuwa iz mø̀ndøndáp. Qoge yo-qa iz vø̀-eqá, yaq yo qoqa iz betē-eqa. ");
INSERT INTO kvg_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Qo ezoqa ewaqape, teqá zenda-té qonø-áb. Yaq ndego khandi miavmiav bezømbē-etoam, ezoqam ate ngi꞉gu, ndego qoqombo-etoam. ");
INSERT INTO kvg_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Khandi miavmiav nqánek: Ezoqa qo gé꞉zøtéz. Unimanqatin Mbumbukiam qo qakhapús. Neka ndigu Yesu Keliso vǿezøtēz, ndego qo qoqotøndo-khofotav. ");
INSERT INTO kvg_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","No qoqa iz mø̀e-eqá, nqanek manqei-qape-te. Sasae ndøgo, qoqonø-etoam tægo, mùtumukhóu. ");
INSERT INTO kvg_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Yaq ndakin, Tat, no nqawa qo namba tøtegoat, no iz kandambaqape nqawa vø̀nø-etoám, av no oskia qategoam, qo namba, até ndøgó-a, manqei-qape khakheinøpøteav qagoam. ");
INSERT INTO kvg_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","No nginik ezoqam mø̀tezømás, qoqa yaq-te, ndigu qo manqei-qape ezoqam-qa mokho-te qoqo-vevesam neka no voqonø̄-etoam. Ndigu qogí ezoqám. Yaq qo mòqonø-etoám ndigu. Yaq ndigu manqat o-mba qambo-ndapém. ");
INSERT INTO kvg_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ndigu ndakin mø̀ndæzøtéz, matev ate ndægo, no qoqonø-etoam, qo-té qandowáv. ");
INSERT INTO kvg_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Manqat ndøgo, qoqonø-etoam, mø̀tezømás, neka ndigu vø̄ndapem. Ndigu mø̀ndæzøtéz, no unimanqatín qo-té qatøndonáv. Neka ndigu mø̀ndø-unimanqatiním, av nqægo, no qo qotøndo-khofotán. ");
INSERT INTO kvg_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","No tiqa ndígu tøtaqambe-vi꞉mít. No ambá av nqǣgo, manqei-qape ezoqam-qá qataqambe-vi꞉mīt, geté tiqa ndígu, no qoqonø-etoam. Zapa ndǿgo, ndigu qogí ezoqám. ");
INSERT INTO kvg_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ezoqa ate nginømbi꞉gu, qogí. Neka ezoqa ate ngiqambi꞉gu, nogí. Yaq ti mokho-te, noqá iz me꞉-eqawát. ");
INSERT INTO kvg_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","No ndakin qo-té qatøgeáv. No manqei-qape-te sekemba nógoák. Geté ndigu, nqanek manqei-qape-te até gégoát. Tát! Qo mbomambaqapé, neka ezoqa nøme mbaín, av qo ndoqote꞉go. No āv qataqambe-viám nqǽgo: Qoqa iz bazaføgakh-us mokho-te ndøgo, qoqonø-etoam, gèzø-keogé, ndigu ezoqam. Yaq ndigu kopo mé꞉goát, ate av-té, qo neka no kopo nqazi꞉gu. ");
INSERT INTO kvg_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","No ti namba qatigoam, no qoqa iz bazaføgakh-us mokho-te ndøgo, qoqonø-etoam, mø̀ezø-kewagám. No eqeieqeí qazø-kewagam. Ezoqa kopo khambuiwateáv. Sate ndégo tøte-khambuiú, av Mbumbukiam-qa Manqat qæ-ein, ndego te-ewan. Nqanek manqat tàbete-unimanqatín. ");
INSERT INTO kvg_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","No ndakin qo-té qatøgeáv. Geté nqanek manqat, no ndakin nqæmanqate, no manqei-qape-te zua nqægo, no ndǿgo tøte-manqaté, noqa khanakhanakh tàbete-tøvá, ti mokho-te. ");
INSERT INTO kvg_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","No qoqa manqat mø̀te-zømesimám. Geté manqei-qape ezoqam, gèsanqazá ndigu. Zapa ndǿgo, ndigu manqei-qape-gí mbá, ate av-té, no nqate꞉go, manqei-qape-gē mbā. ");
INSERT INTO kvg_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","No nøtaqá-viamák, av nqægo, vø̀ndo-upøzō, ndigu manqei-qape-te ngiyage. Geté no āv qataqambe-viám nqǽgo: Gèzø-keogé. Andé nqova soqaqape vǿe-ngiæzō. ");
INSERT INTO kvg_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ndigu manqei-qape-gí mbá, ate av-té, no nqate꞉go, no manqei-qape-gē mbā. ");
INSERT INTO kvg_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Qo vø̀ndo-nøzøzó, qakezan-te, ndigu ezoqam. Yaq ndigu bemø̄-uni-Mbumbukiam-gi-nakheis-ez. Unimanqatin manqát qande-nøzøzó. Unimanqatin manqat ndǿgo, qoqa manqat. ");
INSERT INTO kvg_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","No ndigu manqei-qape-te, āv tøte-khofotáz, av qo no nqanek manqei-qape-te qoqotønde-khofotan. ");
INSERT INTO kvg_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","No ti zapaya, nøkeza kha, qoqá zenda-té qatǿvé. No tøtégoát ndǿgo, yaq até ndigú-a, ekeza kha qoqa zenda-te tìabiti-veém, neka unimanqatin qogi ezoqam bēgo. ");
INSERT INTO kvg_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","No ambá av nqǣgo, tiqa yaq-te mbā qataqambe-vi꞉mīt, ndigu ndakin no namba ngi꞉gu, geté até tiqá yaq-té-a, ndigu tiqa manqat zapaya, no ti-unimanqatinim. ");
INSERT INTO kvg_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tát! No āv qataqambe-viám nqǽgo: Ndigu kopo betegó. Av qo no mokho-te nqoqote꞉go neka no qo mokho-te nqatu꞉gu, yaq até ndigú-a, ni mokho-té giabetu꞉gú. Yaq manqei-qape ezoqam, tìabiti-unimanqatiním, av nqægo, no qo qotøndo-khofotān. ");
INSERT INTO kvg_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","No iz kandambaqape nøzø-etoám, ate av-té, qo iz kandambaqape qoqonømbe-etoam. Yaq ndigu kopo tìabitigú, ate av-té, qo neka no kopo nqazi꞉gu. ");
INSERT INTO kvg_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","No ti mokho-té qatu꞉gú neka qo no mokho-té qoqotu꞉gú. Yaq até ndigú-a, kopo betegó. Yaq manqei-qape ezoqam, tìabiti-unimanqatiním, av nqægo, no qo qotøndo-khofotān neka qoqa kuku ti-te, āv tøqambegó, av qo no-te kuku ndaqambe꞉go. ");
INSERT INTO kvg_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tát! No āv qanømbe-poév nqǽgo: Ndigu ezoqam, no qonø-etoam, no namba nitígoát, no ande āv khatégoāt. Yaq ndigu tìabiti-qeivím, av nqægo, qo no iz kandambaqape qonø-etoám. Zapa ndǿgo, qo kuku é-møndøqambe-goám no-te, nqanek manqei-qape khakheinøpøteav qagoam. ");
INSERT INTO kvg_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tat ndaføyamba-qape! Manqei-qape ezoqam, qo mè꞉zøtezák. Geté no qo mø̀tenøtén. Neka nginik paev ezoqam, mø̀ndæzøtéz, av nqægo, no qo qotøndo-khofotān. ");
INSERT INTO kvg_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","No ndigu mø̀ezø-ovøyám, qoqa yaq-te. Yaq no até nøzǿ-ovøemát. Yaq kuku matev ndøgo, qo no-te nqaqago, ti mokho-té qabezøgó. Neka até nó-a, ti mokho-té qabatu꞉gú.” ");
INSERT INTO kvg_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu nqanek manqat ate ndægo qamømbøe-navøem, yaq ekeza paev ezoqam namba, Zelusalem taon sège-iváv, Kidlon kea vømø̄tanqa. Yaq-keoqa ndøgo, khae ndøgoám. Oliv tae kháe. Yaq Yesu ekeza paev ezoqam namba, timø-óz ndǿgo. ");
INSERT INTO kvg_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Zudas, ndego Yesu sa gemboqambun, mø̀ndæ-otév, nqanek khae. Zapa ndǿgo, Yesu ekeza paev ezoqam namba, tinø-wambamɨ́n ndǿgo. ");
INSERT INTO kvg_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yaq ndakin Zudas tendowáv ndǿgo, nakhag ezoqam neka Mbumbukiam-qa khoev vos keoge ezoqam vø̄-itub. Nginik, Mbumbukiam-gi iziz ezoqa kandakanda neka Felisi ezoqam ndokhofotáz. Yaq ndigu nakhag gigiap neka mogenda neka lampa vøndō-upøgim, gigeavun. ");
INSERT INTO kvg_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu é-møndæ-otév, matev ate ndægo, te-te tøfakhanam. Yaq ndego sègendo-veáo, vøzø̄-ein, “Zo gekha ezoqā zombóvawet?” ");
INSERT INTO kvg_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Yaq ndigu gindu-qavøinam, “Ni Yesu nimbovawét, ndego Nazalet vemiav-ak.” Yaq Yesu gendo-qavøiu, “Ezoqa nó.” Zudas, ndego Yesu sa gemboqambun, mø̀ndøgoám, ti namba. ");
INSERT INTO kvg_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu nqanek manqat ge-ein, “Ezoqa nō,” yaq ndigu sègesináz, manqei-te vø̄-o꞉az. ");
INSERT INTO kvg_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yaq Yesu nangó genøzø-beváp, “Zo gekha ezoqā zombóvawet?” Yaq ndigu nqawa gindu-qavøinam, “Ni Yesu nimbovawét, ndego Nazalet-ak.” ");
INSERT INTO kvg_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yaq Yesu gezø-qavøiu, “No mø̀ezø-eín. Ezoqa nó. Av tægoat ndægo, no ndozonø-vawet, yaq nginik ezoqa nøme, vø̀zøták. Bèzáv.” ");
INSERT INTO kvg_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yesu nqanek manqat tene-eín ndǿgo, manqat tàbete-unimanqatín, ndego bugukhokhof ge-ein, av nqægo, “Tát! No ezoqa kopo khambuiwateáv, ndigu no qoqonø-etoam.” ");
INSERT INTO kvg_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saemon Pita, nakhag kaiya mø̀ndømbo-goám. Yaq ndego até gendego, segelìvāz, Mbumbukiam-ge iziz ezoqam kandambaqape-ge sasae ezoqam, nakeamo gea vømbōkawa. Ndego sasae ezoqam, teqa iz Malkús. ");
INSERT INTO kvg_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Geté Yesu Pita āv gembøe-eín nqǽgo, “Kaiya nandiv, nango vø̀-utáz, ma qoqotønde-livaz. Ge qô, ndoqo-matavap, no nqanek ibøkha khaqain-qape, no Tat genø-etoam, tæ-iz, nó-izāk? Āv taoká. Bànø-íz.” ");
INSERT INTO kvg_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Yaq nakhag ezoqam neka tigi kawa ezoqam neka Mbumbukiam-qa khoev vos keoge ezoqam, até gindigonem, Yesu vø̄-møvøinam, sasa mboløvønem. ");
INSERT INTO kvg_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Yaq bugukhokhof Anas-té ginø-ituím. Ta viav-te ndøgo, Mbumbukiam-ge iziz ezoqam kandambaqape, Kayafas ndøgoám. Yaq ndego Anas, Kayafas-gé zimuí. ");
INSERT INTO kvg_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafas ndégo, bugukhokhof Zu megetapak gezø-ein, av nqægo, “Qanimav ndǿgo, ezoqa kopo tenanim, ezoqa ewaqape zapaya. Ambá ndø̄go, ezoqa ewaqape tipakhaez.” ");
INSERT INTO kvg_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saemon Pita neka paev ezoqa kopo nøme, Yesu até gembopavát. Mbumbukiam-ge iziz ezoqam kandambaqape, ndego paev ezoqa nøme, mø̀ndæ-otév. Yaq Yesu Mbumbukiam-ge iziz ezoqam kandambaqape-qa khoev uta mokho-te gi-ituim, ndego namba me꞉-óz. ");
INSERT INTO kvg_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Geté Pita uta mboqog-té sogo-itán. Yaq ndego paev ezoqa nøme, nangó gendoveséz, mbasønakam manqat vømbō-ein, ndugu uta mboqog gumbo-kewagam, yaq ndugu Pita vømbōtak, vø̄-on. ");
INSERT INTO kvg_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Yaq mbasønakam ndugu, mboqog-te guoyam, Pita āv gumbøe-eín nqǽgo, “Qo ngenek ezoqam-gé paev ezoqa nømé atoqogó?” Geté Pita gembo-qavøiu, “Āv taoká. No tegé paev ezoqám mbá.” ");
INSERT INTO kvg_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ta lova ndøgo, sasae ezoqam neka vos keoge ezoqam, gøinam ndøløvutím. Zapa ndǿgo, qozaq ndønqeivøém. Yaq gøinam gè-ogitøvém, kha vø̄qoqoutam. Yaq até Pitá-ya, ti namba vø̄ewan, kha sasa ndøqoqoutam. ");
INSERT INTO kvg_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Yaq Mbumbukiam-ge iziz ezoqam kandambaqape, Yesu gèmbo-sinøzám. Tegi paev ezoqam neka teqa nømendim matev-qá yaq-té gembøebeváp. ");
INSERT INTO kvg_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yaq Yesu gendo-qavøiu, “No manqat ezoqa ewaqape-qá bøi-té qatø-manqatám. No oskia guliguli khoev vinivinimba-té neka Mbumbukiam-qa khoev-té qate-zømesimám, ma Zu ezoqam ate ndi꞉gu gi꞉pindumatun. No ezoqa khonoam-te zømesimáv. ");
INSERT INTO kvg_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Qo gekha zapâ, no nqoqonø-sinøzam? Toqozǿ-beváp ndígu, noqa nømendim manqat gi-ewagam. Nqáe! Ndigu mø̀ndæzøtéz, av no qate-zømesimam.” ");
INSERT INTO kvg_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu nqanek manqat ge-ein, yaq vos keoge ezoqa nøme, ndego avønin geyam, até gendego, Yesu loko vømbōtøkub, gembo-ein, “Qo Mbumbukiam-ge iziz ezoqam kandambaqape, manqat av nandægo mboqavø̀iwa᷄t!” ");
INSERT INTO kvg_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yaq Yesu gendo-ein, “Manqat ndøgo, qæ-ein, soqain tøgoat, yaq vòkhæ-nømánd, taqa soqain-qa yaq-te. Geté manqat ndøgo, qæ-ein, unimanqatin tøgoat, yaq gekha zapâ, no loko qoqonø-tøkub?” ");
INSERT INTO kvg_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yaq Anas Yesu Kayafas-té genø-khofotáv, ndego Mbumbukiam-ge iziz ezoqam kandambaqape. Yesu até gembo-løvøetám. ");
INSERT INTO kvg_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pita ate av-té gøinam-te ge꞉yam, kha geqoqoutumat, yaq ezoqa nøme āv gimbøe-einím nqǽgo, “Gebâ qo? Qo ngenek ezoqam-gé paev ezoqa nømé atoqogó.” Geté Pita gò꞉nawám, gendo-ein, “Mbaín. No tegé paev ezoqám mbá.” ");
INSERT INTO kvg_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Yaq Mbumbukiam-ge iziz ezoqam kandambaqape-ge sasae ezoqam kopo, ndego Pita gea gembokawa, tege ekeza ezoqam, gembo-ein, “Qo no andé møteqamékh, ndøgo khae-te.” ");
INSERT INTO kvg_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Geté Pita nqawá genønawám. Yaq ate av-té, manqat ge꞉manqatam, kokolok tùndi-ogeá. ");
INSERT INTO kvg_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Yesu Kayafas-qa khoev-te gegoam, yaq qanaqanus lovølova-us, ndego Lom gaman ezoqam-qá khoev-té ginø-ituím. Geté ndigu Zu megetapak ozaneáv, khoev-te ndøgo. Zapa ndǿgo. Soqaín ndøgo, ndigu Mbumbukiam-qa bøi-te ande khavim-us me ti꞉goat, ndigu bawan vini-ak-qa khoev-te timø-oz, yaq kopømba mbaīn vǿgoāt, Pasova khøuwa kandambaqape-qa lou tilog. ");
INSERT INTO kvg_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yaq ta zapaya ndøgo, Pailøt bavokhó gendo-fakhán, vøzø̄bevap, “Ngenek gekha manqa-zapā zombó-qeivim?” ");
INSERT INTO kvg_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Yaq gindu-qavøinam, “Nandev amba manqa-zapa goneav tøgonɨn, yaq ni ambá nitøndí-ndafemák qo-te.” ");
INSERT INTO kvg_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Yaq Pailøt gezø-ein, “Av tægoat ndægo, zo zøkeza ndøndafém, neka matev vømømbō-gonem, av zøkeza guguna manqat qæ-ein ndægo.” Geté ndigu gimbo-qavøinam, “Nakhoa mbaín. Lom-qa khafeap ni takeáv, ni ezoqam løvøte-te tei-abumat.” ");
INSERT INTO kvg_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nqanek matev tønefakhán ndǿgo, Yesu-qa manqat tàbete-unimanqatín, ndøgo bugukhokhof ge-ein, ndego ande āv kenénanīm. ");
INSERT INTO kvg_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Yaq Pailøt nangó genø-ón, khoev mokho-te, Yesu vømbō-akha, vø̄-on. Yaq āv gembøebeváp nqǽgo, “Gê, qo Zu ezoqam-gê kawà?” ");
INSERT INTO kvg_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yaq Yesu gendo-qavøiu, “Gê, nandav bevap qoqâ matavap-tē qandó-fakhate, ó, ezoqā nøme qá-ein, noqa yaq-te?” ");
INSERT INTO kvg_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Yaq Pailøt gendo-qavøiu, “No Zu ezoqám mbá. Qo noqa zenda-te, qogi qakeza ezoqam neka Mbumbukiam-gi iziz ezoqa kandakanda ndøveém. Ge qô, gekha manqa-zapa qómatanam?” ");
INSERT INTO kvg_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yaq Yesu gendo-ein, “Noqa Megeat Matev, ambá nqanek manqei-qape-tē qando-fakhatē. Amba nqanek manqei-qape-te tøndo-fakhanɨn, yaq nogi sasae ezoqam, ambá nøfe-qape ndøngazemɨ́n, no zapaya, yaq ezoqa ambá kopømba mbaín, no Zu ezoqam-qa zenda-te tiveemɨn. Unimanqatín. Noqa Megeat Matev, ambá nqānek qando-fakhatē.” ");
INSERT INTO kvg_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Yaq Pailøt gembobevap, “Av tægoat ndægo, yaq ge qô, kawa ezoqâm?” Yaq Yesu gendo-qavøiu, “Nándav, av qo ndoqote-manqate. No kawá. No nqánek qateqán neka no nqanek manqei-qape-te nqánek qatefakhán, ezoqam unimanqatin manqat nøtézømás. Gekha ezoqām ndego, unimanqatin manqat-te tenøzan, ndego noqa manqat gé-ewagát.” ");
INSERT INTO kvg_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Yaq Pailøt gembo-ein, “Gê, unimanqatin manqat ākhanégo?” Pailøt nqanek manqat ge-ein, yaq nqawa bavokhó genøfakhán, Zu ezoqam-te, vøzø̄-ein, “No teqa manqa-zapa qeiviáv. ");
INSERT INTO kvg_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Zo mø̀zøte-zøtéz. No zoqa Pasova khøuwa kandambaqape-te, ndimbula ezoqa kopo nøzø-nqonqotavɨ́n, av zoqa poev ndægo. Yaq ndakin zo gekhā zǿpoev? No ngének qazǿ-nqonqotāv, ngenek Zu ezoqam-ge kawa?” ");
INSERT INTO kvg_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Geté ezoqa ewaqape sùgumu-tøkúz, gindu-akhaemem, “Mbaín. Teoká nandev. Geté Balabas qónqonqotáv.” (Balabas, ndego pepen ezoqam ndøgoám.) ");
INSERT INTO kvg_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Yaq Pailøt nakhag ezoqam, Yesu zui manqat zø-eín, yaq ndigu sasa ndøndafem, vømø̄zuim. ");
INSERT INTO kvg_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Yaq ndigu nakhag ezoqam, gumbag fakiafakia-us ndø-ogeaném. Yaq kawa-té gimbøe-uzím. Andé kawa ezoqam-qá wawáq. Neka ndabua køkouk, kopømba ande av kawa ezoqam-qa ndabua ndægo, vømbō-uzim. ");
INSERT INTO kvg_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Yaq ndigu otøotam me꞉vewém. Gèzavɨ́n, manqat vømbō-einimin av nqægo, “Zu ezoqam-ge kawa, iké꞉ qo-te,” neka loko vømbō-tøkubømemɨn. ");
INSERT INTO kvg_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Yaq Pailøt nangó genøfakhán, bavokho, ezoqa ewaqape vøzø̄-ein, “Nqáe! Yesu notøndó-itú, zo-te, zo vøzøté-zøtēz, av nqægo, no teqa manqa-zapa qeiviáv.” ");
INSERT INTO kvg_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yaq Yesu gendo-fakhan, gumbag fakiafakia-us neka ndabua køkouk até gembøe-uzupám. Yaq Pailøt gezø-ein, “Ngé! Ezoqam ngének.” ");
INSERT INTO kvg_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Yaq Mbumbukiam-gi iziz ezoqa kandakanda neka Mbumbukiam-qa khoev vos keoge ezoqam gi-ometam, ndigu āv gini-akhaemém nqǽgo, “Gèlaváo. Tae mutui-té qanø-tøkeó!” Yaq Pailøt gezø-ein, “Zo ndøndafém, neka tae mutui-te vømø̄-tøkewem. Geté no, teqa manqa-zapa qeiviáv.” ");
INSERT INTO kvg_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yaq Zu ezoqam nango gindu-qavøinam, “Ni guguna manqat nqanîgú. Yaq ndøgo āv qane-eín nqǽgo: Nandev yà benaním. Zapa ndǿgo, ndego ekeza kha, Mbumbukiam-gé yo me꞉vewám.” ");
INSERT INTO kvg_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Yaq Pailøt nqanek manqat ge-ewag, ndego møe nøme mba mbøe-khouwév. ");
INSERT INTO kvg_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Yaq nangó genø-ón, khoev mokho-te, Yesu vømømbō-bevap, “Qo gekha manqei-âk?” Geté Yesu manqa qavøiwateáv. ");
INSERT INTO kvg_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Yaq Pailøt Yesu gembo-ein, “Gê, qo no-te manqa manqate geqambó-qasi? Qo àboqote-qatéq? No iz nqanø̂gó. Tønø-pøovat, yaq sǽnqonqotáq. Ó, tønø-pøovat, no qo tae mutui-té qatǿ-tøkéq.” ");
INSERT INTO kvg_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yaq Yesu gendo-qavøiu, “Qo no-te matev-qase ambá qómatanamák, Mbumbukiam qo-te amba iz etopøteav tøgonɨn. Yaq nakémbá, ndego ezoqam, no qoqa zenda-te geve, teqa manqa-zapa mø̀ndø-løvuám, qoqa manqa-zapa.” ");
INSERT INTO kvg_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailøt nqanek manqat ge-ewag, yaq ndego nakhoa-qa ndøváo, Yesu ande āv kené-nqonqotāv. Geté Zu ezoqam, āv gindi-akhaemém nqǽgo, “Qo nandev sa toqo-nqonqotav, yaq qo Siza-gé zifú mbá, ndego Lom kawa ezoqam kandambaqape. Zapa ndǿgo, ezoqa av nde꞉manqate nqægo, no kawā, ndego Siza-gé qaqa ezoqám.” ");
INSERT INTO kvg_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Yaq Pailøt tiqa manqat ge-ewag, ndego Yesu bavokhó genø-itú, yaq Pailøt manqa ovøyam qonam nonqo-te vø̄qom. Ta manqei ndøgo, Nandi Manqei mbo-akhayám. Iblu manqat-te, taqa iz Gabatá. ");
INSERT INTO kvg_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ta khøuwa-te ndøgo, Pasova gigiap khakheinam khøuwá. Yaq ndakin, ande āv khøuwa muín ndægó. Yaq Pailøt Zu ezoqam gezø-ein, “Ngé! Zoge kawa ezoqam ngének.” ");
INSERT INTO kvg_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Geté ndigu gindu-akhaemem, “Yà belaé. Yà belaé. Tae mutui-té qanø-tøkeó.” Yaq Pailøt gezøbevap, “Gê, no zoge kawa ezoqam, unimanqatín tae mutui-té qatǿ-tøkeō?” Geté ndigu Mbumbukiam-gi iziz ezoqa kandakanda gindu-qavøinam, “Ni kawa ezoqam kopo mba nigú. Sizá. Ezoqa nøme mbaín.” ");
INSERT INTO kvg_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Taqa zita-te, Pailøt Yesu nakhag ezoqam-qá zenda-té genøvé, tae mutui-te bemø̄-tøkewem. Yaq nakhag ezoqam, Yesu gèndafém. ");
INSERT INTO kvg_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesu tae mutui, ekezan mo꞉-eqatát, gemat. Taon ge-ivav, yaq ta manqei ndǿgo temøfakhán, kawa-pakha manqei ndimbo-akhayam. (Iblu manqat-te, ta manqei-qa iz, Golgotá.) ");
INSERT INTO kvg_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Yaq ndøgo, Yesu tae mutui-té ginø-tøkewém. Até ezoqa menas nømé-a, vø̄tøkebam. Nøme yáq ginø-tøkewém, neka nøme yaq vø̄tøkewem. Yesu livin-mbá gunu꞉-tøkewám. ");
INSERT INTO kvg_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailøt manqat ndøpeawám. Yaq tae mutui-té ginø-tøkeém, Yesu-qa kawa qameva. Āv qane-peaupám nqǽgo, “Ngenek Yesú. Nazalet vemiav-ák. Zu ezoqam-gé kawá.” ");
INSERT INTO kvg_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Manqat ndøgo, Iblu manqat-té neka Latin manqat-té neka Glik manqat-té qanø-peaupám. Zu ezoqa kopoáv, nqanek manqat gigeve꞉mam. Zapa ndǿgo, Yesu ma ge꞉tøkewam, qambaqapé mbá, taon-te. ");
INSERT INTO kvg_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Mbumbukiam-gi iziz ezoqa kandakanda, nqanek manqat gigeveømem, yaq Pailøt āv gimbøe-einím nqǽgo, “Qo manqat soqaín soqo-peawám, qoqo-peawam, av nqægo, ‘Zu ezoqam-gē kawā.’ Qo āv qoté-peawám nqǽgo, ‘Ngenek ekezan ndø-eín, av nqægo, no Zu ezoqam-gē kawā.’” ");
INSERT INTO kvg_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Geté Pailøt gezø-qavøiu, “Manqat ndøgo, qæpeawam, até bepeawáp.” ");
INSERT INTO kvg_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ndigu nakhag ezoqam, Yesu tae mutui-te gumu-tøkewem, yaq teqa ndabua gèmøvøemém. Møvøyap foá. Yaq ndigu nakhag ezoqa foa, ezoqa kopokopo, møvøyap kopokopo ndø-upøgimát. Geté ndabua nøme ndøgo, gindapem, viní. Ta ndabua ndøgo, gevewat kopó. Sekeqapé. Potoføpøteáv. ");
INSERT INTO kvg_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Yaq nakhag ezoqam yaqyaq-a gibond, “Nqanek ndabua sekeqape, bizi-keqagìme᷄m. Geté zí꞉-otám. Nandi-qasis zínqagevemát. Yaq zíqeivím, ande gekha ezoqam me ndǿndāp, nqanek ndabua.” Nqanek matev tønefakhán ndǿgo, manqat ndøgo, Mbumbukiam-qa Manqat-te ndøpeawap, tàbete-unimanqatín, av qæ-ein nqægo, “Noqa ndabua nøme gè-etøomém neka ndabua sekeqape vø̄e-otømem.” Yaq nginik nakhag ezoqam, āv tinigoném. ");
INSERT INTO kvg_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesu-qa tae mutui avønin-te ndøgo, tegu evo mø̀ndøyám. Até tugú namba qawán-a, neka Meli nømu, ndugu Klopas-gu zas, neka Meli nømu, Magdala vemiav-ak, vø̄wanam. ");
INSERT INTO kvg_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu evo gu-omet, tege paev ezoqam namba guiyam, te-te kuku qambogoam, yaq ndego evo āv gumbøe-eín nqǽgo, “Évo, nandev ndakin qogé yó.” ");
INSERT INTO kvg_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Yaq ndego paev ezoqam, āv gembøe-eín nqǽgo, “Nanduv ndakin qogú qavó.” Ta khøuwa-te ndøgo, ndego paev ezoqam, ndugu ekeza khoev-té genøkható. ");
INSERT INTO kvg_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu mø̀ndæ-otév, matev ate ndægo mø̀ndømukhóu, Mbumbukiam ma gende-khofotav, manqei-qape-te. Yaq ndego āv gene-eín nqǽgo, “No ibøkha naq nøpáp.” Nqanek manqat tene-eín ndǿgo, Mbumbukiam-qa Manqat tàbete-unimanqatín, taqa yaq-te manqat qa-ein. ");
INSERT INTO kvg_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Avønin-te ndøgo, waen khaqain-qape mø̀ndø-wuøyám. Yaq nakhag ezoqam, ndabua ndøndapém. Yaq waen-té gunu-qoqoném, Isop tae-te sasa ndøløvønemem, Yesu-qa tou-te vømbō-qantøvem. ");
INSERT INTO kvg_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu elavøqase ge-iz, yaq āv gene-eín nqǽgo, “Ndakin mùtumukhóu.” Yaq kawa sègevoá, vø̄nanim. ");
INSERT INTO kvg_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ta khøuwa-te ndøgo, Sabat gigiap khakheinam khøuwá. Yaq Zu megetapak poeveáv, ndigu ezoqam, tae mutui-te gitøkebupam, sekemba titøkebupat. Geté nakhamas-té giabenø-pakhaéz. Zapa ndǿgo, nøme tøndopave, Sabat khøuwa kandambaqapé. Yaq ndigu Pailøt āv gimbøe-einím nqǽgo, “Nginik ezoqam, tae mutui-te ngitøkebap, nakhag ezoqam bov bezømøkuí. Yaq ndigu nakhamas-té giabenø-pakhaéz, tae mutui-te é-bē-upøgim.” ");
INSERT INTO kvg_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Yaq nakhag ezoqam tizáv ndǿgo, ndigu ezoqa menas, Yesu namba gi꞉tøkebupam, bov vømøzø̄-møkui. Bugukhokhof ndégo, yaq getøkewam, tìmbo-møkuimém, yaq ndego nøme, getøkewam, vømbō-møkuimem. ");
INSERT INTO kvg_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Geté Yesu-te ginduzav, tikeogém ndǿgo, ndego é-møndønaním. Yaq ndigu teqa bov møkuipøteáv. ");
INSERT INTO kvg_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Geté nakhag ezoqa nøme, até gendego, Yesu-qa totokha-te, sumbianq vø̄e-keqatav. Yaq kouk neka ibøkha tøndo-qouvøém ndǿgo. ");
INSERT INTO kvg_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ndego ezoqam, nqanek matev bøi ge꞉qeiv, emanqat ndøvotót. Emanqat ndøgo, gevotot, unimanqatín. Ndego mø̀ndæ-otév, ndego unimanqatin manqat mba ndømanqaté. Yaq ndego tene-eín ndǿgo, zo tø̀ne-unimanqatiním. ");
INSERT INTO kvg_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nqanek matev tønefakhán ndǿgo, Mbumbukiam-qa Manqat tàbete-unimanqatín, av qæ-ein nqægo, “Bazag kopo gembónqoeák.” ");
INSERT INTO kvg_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Neka manqat nøme āv qane-eín nqǽgo, “Ezoqa te-te ndégo tinǿ-kewagát, gikeqatøvem.” ");
INSERT INTO kvg_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Taqa zita-te, ezoqa kopo Pailøt-té genøwáv, Yesu-qa kha-qa yaq-te vømømbō-viam. Teqa iz Zoséf. Alimatea vemiav-ák. Ndego Yesu-gé paev ezoqá nømé. Geté khonoam-té genømbo-pavám. Zapa ndǿgo, ndego Zu megetapak-qá møe ndøgoám. Yaq Pailøt sègemboták. Yaq Zosef tenøwáv ndǿgo, Yesu-qa kha tae mutui-te vømøndō-ndap. ");
INSERT INTO kvg_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Até Nikodemús-a, ndego lova kopo, Yesu-te gemat, vøndōwav. Ndego tae etet sisip mbomømboma ndø-upatavún. Tae etet menas tøkuát, mel neka aloe. Tae etet kandambá. Ande āv 30 kilogrém ndǽgo. ");
INSERT INTO kvg_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ndigu ezoqa menas, Yesu-qa kha gèndapém, tae etet sisip mbomømboma namba, ndabua papaqa vø̄e-gutøvem, av Zu ezoqam-qa matev qazømbe-goam, ezoqa manqei-pakha-te gi-eoeinamɨn. ");
INSERT INTO kvg_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ta manqei-te ndøgo, ma Yesu gi꞉laem, khae mø̀ndøgoám. Yaq ta khae-te ndøgo, manqei-pakha mø̀ndø-ozám. Ndakinák. Ta manqei-pakha ndøgo, nandi giløotøzem, bugukhokhof løvøte ezoqa utøveáv. ");
INSERT INTO kvg_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yaq ndigu Yesu-qa kha timø-utøvém ndǿgo. Zapa ndǿgo, ta khøuwa ndøgo, Zu ezoqam-qá Sabat gigiap khakheinam khøuwá. Yaq khøuwa nøme tøndopave, Sabat khøuwá, neka ta manqei-pakha ndøgo, avønín qagoám. ");
INSERT INTO kvg_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Yaq Sabat khøuwa qame-navøem, Sande qanaqanus qænqøovat, até gupøistám, Meli Magdala vemiav-ak, manqei pakha-té gunøwáv. Yaq tuqeív ndǿgo, nandi-qape mboqog-te go꞉tokavam, mbaín. Viní gizavám. ");
INSERT INTO kvg_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Yaq matev guqeiv ndøgo, gètéit, Saemon Pita neka ndego paev ezoqa nøme, te-te Yesu kuku qambogoam, vømøzø̄-ein. Āv guzømbe-eín nqǽgo, “Evezøza, manqei-pakha-te gu꞉goam, ezoqa mø̀ndøndafém. Neka ni nøtenateáv, ndego gekham-tē gimø̄veem.” ");
INSERT INTO kvg_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Yaq Pita neka ndego paev ezoqa nøme, até gindigonem, manqei-pakha-te vø̄zav. ");
INSERT INTO kvg_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ndigu ezoqa menas, sùgumu-bøitát. Geté ndego paev ezoqa nøme, nakhamas-té genøteít, Pita vø̄løvu, manqei-pakha-te ndøgo, é-vømø̄fakhan. ");
INSERT INTO kvg_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Yaq nandi nqa mokho-te gemø-fakhanam, ndabua mba ndøqeív, Yesu ge꞉gutavam. Geté ndego oneáv, mokho-te ndøugu. ");
INSERT INTO kvg_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Yaq Saemon Pita gefakhan, ndego ndaføyamba ndø-ón, manqei ozu mokho-te ndøugu, ndabua ndøgo, Yesu ge꞉gutavam, vø̄qeiv, qa-awam. ");
INSERT INTO kvg_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Até ndabua nømé-a, Yesu-qa kawa-te qaløvøtupam, vø̄qeiv. Ndøgo viní qaveám. Putøgiap ndøveám. ");
INSERT INTO kvg_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Yaq até ndegó-a, ndego paev ezoqa nøme, bugukhokhof go꞉fakhan, manqei ozu-te vø̄-on. Yaq matev geqeiv, ndego gè-unimanqatín, av nqægo, Yesu mø̀ndø-khandí꞉v. ");
INSERT INTO kvg_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Mbumbukiam-qa Manqat mø̀ndø-eín, av nqægo, ndego løvøte-te ndø̀khandí꞉v. Geté ndigu bugukhokhof mokho ndapeáv, taqa yaq-te. ");
INSERT INTO kvg_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Yaq ndigu paev ezoqam, khoev-té ginøqaváz. ");
INSERT INTO kvg_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Meli, ndugu Magdala vemiav-ak, manqei ozu bavokho até go꞉goám. Gè-eivát. Gui-eivam, yaq manqei ozu mokho-té gunø-fakhanám. ");
INSERT INTO kvg_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Yaq ndugu, ma bugukhokhof Yesu-qa kha qæveam, enzol ezoqa menas ndøzømét. Ndabua papaqa-mba ndø-uzupám. Nøme ndego, kawa-té geqotám, neka nøme ndego, mbage-te vø̄qotam. ");
INSERT INTO kvg_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Yaq ndigu Meli āv gimbøe-bevøpém nqǽgo, “Ngólam. Qo gekham-qā qó-eivit?” Yaq ndugu guzø-qavøiu, “Noge Evezøza-qa khatae, gèndapém. Yaq no nø̀tenøtenák, gekham-tē gimø̄veem.” ");
INSERT INTO kvg_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Yaq ndugu nqanek manqat gumu-ein, guqambun, Yesu mba mo꞉-omét, geyam. Geté ndugu matavapøteáv, av nqægo, ndego Yesū. ");
INSERT INTO kvg_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yaq Yesu gumbobevap, “Ngólam. Qo gekham-qā qó-eivit? Qo gekha ezoqam-qā qóvawet?” Ndugu até vø̄e-ein, ndego khae keoge ezoqám. Yaq gumbo-ein, “Khanánqa, av qo khatae toqotendap-a, kopømbâ toqonø-ein, av nqægo, qo gekham-tē qonǿve? Yaq no nømøndó-ndáp.” ");
INSERT INTO kvg_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yaq Yesu gendo-ein, “Meli!” Yaq guqambun, uni vø̄e-omet, ndugu ekeza Iblu manqat-te āv guni-eín nqǽgo, “Labúni!” Taqa manqa mokho, “Nømendim ezoqám.” ");
INSERT INTO kvg_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yaq Yesu gembo-ein, “No kha naqanøká nøkhàna᷄z. Zapa ndǿgo, no Tat-te qavigiáv. Zuá. Geté nogi nøfuap-té qanøqáv, manqat av nqægo vøzø̄-ein: No te-te ndégo tøtø-vesezét, ndego noge Tat neka zoge Tat, ndego noge Mbumbukiam neka zoge Mbumbukiam.” ");
INSERT INTO kvg_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Yaq Meli, ndugu Magdala vemiav-ak, paev ezoqam-té gunøwáv, vøzø̄-ein, “No Evezøza no-omét.” Yaq ndugu manqat nøme vøzø̄-ein, av ndego manqat gumbøe-ein. ");
INSERT INTO kvg_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ta khøuwa-te ndøgo, Sande khagús, paev ezoqa ate gi꞉goam, khoev mokho-té gunu꞉goám. Mboqog ate gi꞉goam gètokøvemém. Zapa ndǿgo, ndigu Zu megetapak-qá møe ndøgoám. Yaq Yesu segezø-fakhán ndǿgo, ti mokho-te vø̄-itan, gezø-ein, “Sambí, zo-te.” ");
INSERT INTO kvg_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yesu nqanek manqat gumu-ein, yaq ndego teqa zenda neka totokha me꞉zømás. Yaq ndigu paev ezoqam, khanakhanakh kandambá gindapem, Evezøza gi-ometam. ");
INSERT INTO kvg_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yaq Yesu nango āv gezømbe-eín nqǽgo, “Sambí, zo-te. Av no Tat gende-khofotan, yaq no zo āv tøté-khofosám.” ");
INSERT INTO kvg_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yesu nqanek manqat guzumbu-ein, yaq até gendego, qozøqozaq zøkhambá, gezø-ein, “Nqova Mbomambaqape vø̀ndafém. ");
INSERT INTO kvg_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Zo ezoqa tiqa manqa-zapazapa sa tøzømbo-navøemat, ndigu segezǿ-navøemát. Geté zo tiqa manqa-zapazapa navøepøteav tøgoat, tiqa manqa-zapazapa, até gezǿgoát.” ");
INSERT INTO kvg_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ta khøuwa-te ndøgo, Yesu ekeza paev ezoqam-te gefakhan, yaq Tomas, iz nøme qaqangeap gimbo-akhaemam, ndigu paev ezoqa tuelv, kopo nøme ndego gegoam, gè-ewawám. ");
INSERT INTO kvg_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Yaq ndigu paev ezoqa nøme, Tomas gimbo-einim, “Ni Evezøza ni-ometám.” Geté Tomas gezø-qavøiu, “No teqa zenda-te, ikuk nqa-nqa qeiviav tøgoat, neka nogi kokosov ta nqa-nqa-te watøzateav vǿgoāt, neka noqa zenda teqa totokha-te wazeav vǿgoāt, ma sumbianq gigenab, yaq no nøzǿ-unimanqatinák.” ");
INSERT INTO kvg_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pula kopo-qa zita-te, paev ezoqa ate gi꞉goam, nqawá ginømøváb, ta khoev mokho-te ndøugu. Até Tomás-a, vø̄ugoam. Mboqog ate gi꞉goam gètokøvupám. Geté Yesu sègefakhán, ti mokho-te vø̄-itan. Gezø-ein, “Sambí, zo-te.” ");
INSERT INTO kvg_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Yaq Yesu Tomas āv gembøe-eín nqǽgo, “Qogi kokosov nqánek qonǿzáv, neka noqa zenda voqóqeīv. Yaq qotøndé-visī, qoqa zenda noqa totokha-te qotéwāz. Yaq qo qavotam matev sège-iváv. Geté vø̀-unimanqatín.” ");
INSERT INTO kvg_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Yaq Tomas manqat sa nqánek ge-eín, “Noge Evezøza neka noge Mbumbukiam.” ");
INSERT INTO kvg_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yaq Yesu gembo-ein, “Qo toqote-unimanqatín ndǿgo, no qotenømend. Geté gekha ezoqām ndigu, no ndi-unimanqatinat, oskiá ndøgo, no nømendeav tigoat, ndigu khanakhanakh mbá giabitigú.” ");
INSERT INTO kvg_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu ekeza paev ezoqam-qa bugug-te, umingiap matev nøme kopoáv gematønumam. Geté ta matev-qa yaq-te, manqat peawapøteáv, nqanek mbuk-te. ");
INSERT INTO kvg_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Geté manqat ndøgo, nqanek mbuk-te nqapeawap, tøne-peawáp ndǿgo, zo tøne-unimanqatiním, av nqægo, Yesu ndego Mesayá neka ndego Mbumbukiam-gé Yó. Yaq zo nqanek manqat tozo-unimanqatinim, zo te mokho-te khandi zøténdapém. ");
INSERT INTO kvg_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Taqa zita-te, Yesu ekeza paev ezoqam nangó genøzø-fakhán. Taibelias kewan-té. Matev āv qanefakhán nqǽgo: ");
INSERT INTO kvg_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saemon Pita neka Tomas, iz nøme gimbo-akhaemam Qaqangeap, neka Natanael, ndego Keina vemiav-ak, Gelili plovins-te ndøgo, neka ndigu Zebedi-gi nakhei menas neka Yesu-gi paev ezoqa menas nøme, namba me꞉goám. ");
INSERT INTO kvg_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Yaq Saemon Pita, ezoqa nøme gezø-ein, “No zonga nømǿ-khakhasám.” Yaq ndigu gindu-qavøinam, “Qanimáv. Ni namba zí꞉tiním.” Yaq ti-ová ndǿgo, khagua-te vømø̄ketab. Geté ta lova ndøgo, voe amba me꞉qeivupát. Zonga mbaín. ");
INSERT INTO kvg_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Yaq khøuwa gefakhatavun, Yesu ndøgeg-té geyám. Geté ndigu paev ezoqam matavapøteáv, av nqægo, ngenek Yesū. ");
INSERT INTO kvg_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yaq Yesu gezø-ein, “Nǿfuap. Zonga møndøzømbé-ndap?” Yaq ndigu gindu-qavøinam, “Mbaín. Ndapeáv.” ");
INSERT INTO kvg_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yaq ndego āv gezømbe-eín nqǽgo, “Voe nandav, nakeamo zenda-té qanø-ogím, ma khagua nandøzømbe-bøyat. Yaq zo zonga ndø̀zømbendáp.” Yaq ndigu āv tini-matønømém, av gezømbe-ein ndægo. Geté ndigu voe nango amba me꞉-itiím. Zapa ndǿgo, zonga khàpumu-khouwéz. ");
INSERT INTO kvg_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yaq ndego paev ezoqa nøme, Yesu kuku qambogoam te-te, Pita gembo-ein, “Evezøzá, ngenek.” Yaq Pita ge-ewag, av nqægo, Evezøza ndøgō, ndego ndabua sekeqape ndøløvøén. Zapa ndǿgo, ndego ta ndabua sekeqape ndøgo, gò꞉khofá, ta lova ndøgo, zonga-qa givawat. Yaq ndego ibøkha-té genøbáf, vø̄tanqa, manqei-te vømø̄qa. ");
INSERT INTO kvg_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Geté paev ezoqa nøme, khagua-us gibøetam, ùnime꞉-tokhotøvém, manqei-te. Voe zonga-us, sège-livavát. Ndigu qambaqapé mbá, gibøetam. Manqei avønín. Ande āv 100 kifigiáp ndægó. ");
INSERT INTO kvg_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Yaq giqa ndøgo, gøinam mba mo꞉qeivím, taq-te zonga vō꞉qoqoutøvupat neka flawa vø̄-abam. ");
INSERT INTO kvg_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yaq Yesu gezø-ein, “Zonga nøme vø̀ndo-upøzonám, nandiv ndakin gizømbe-ndap.” ");
INSERT INTO kvg_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Yaq Saemon Pita, khagua-te, nangó genøketáo, voe manqei-te vø̄-iti. Zonga kandakanda kopoáv gizømbe-ndap. Ate gi꞉goam 153́. Geté voe keqavøepøteáv. ");
INSERT INTO kvg_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yaq Yesu gezø-ein, “Vø̀ndozáv. Lou zólóg.” Ezoqa kopo bevøpøteáv, av nqægo, “Qo gekha ezoqâm?” Zapa ndǿgo, ndigu møe ndøgoném, neka ndigu é-møndæzøtéz, ngenek Evezøzá. ");
INSERT INTO kvg_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yaq Yesu gøinam-té gendowáv, flawa neka zonga vøndō-upøzo, sasa zø-etoam. ");
INSERT INTO kvg_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ndakin gèmbo-misiká, Yesu ekeza paev ezoqam-te gefakhanam, Mbumbukiam ndego løvøte-te gendo-khandi꞉v, taqa zita-te. ");
INSERT INTO kvg_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Yaq ndigu lou loge qamezømbe-navøem, Yesu Saemon Pita āv gembøe-eín nqǽgo, “Sáemon, Zion-ge yo, qo kuku taqágo, no-te? Neka qoqa kuku matev no-te møndømǿ-løvu, nginik ezoqa nøme-qa kuku matev no-te?” Yaq Pita gendo-qavøiu, “Evézøza. Qo mòqote-qatéq, no poev nqanø̂gó qo-te.” Yaq Yesu gembo-ein, “Nogi sip nakheis, gè꞉zøkefé.” ");
INSERT INTO kvg_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yaq Yesu nangó genømbo-eín, “Sáemon, Zion-ge yo, qo kuku taqágo, no-te?” Yaq Pita gendo-qavøiu, “Evézøza. Qo mòqote-qatéq, no poev nqanø̂gó qo-te.” Yaq Yesu gembo-ein, “Nogi sip, gèzø-keogé.” ");
INSERT INTO kvg_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yaq Yesu nangó genømbo-beváp. Ndakin gèmbo-misiká, gembo-ein, “Sáemon, Zion-ge yo, qo poev taqágo, no-te?” Yaq Pita mbøni mbová. Zapa ndǿgo, Yesu gèmbo-misiká, gembo-bevupam, av nqægo, “Qo no-te poev taqāgo?” Yaq Pita gendo-ein, “Evézøza, qo matev ate ndægo mòqote-qatéq. Neka qo mòqote-qatéq, no poev nqanø̂gō qo-te.” Yaq Yesu gembo-ein, “Nogi sip gè꞉zøkefé. ");
INSERT INTO kvg_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","No unimanqatín nqataqa-manqate. Qo ezoqam ndakinak qoqotegoam, qo ndabua segim nonqo qakeza qoløvønøvemám, sasa qoqavɨn, ma taqambe-pøovet. Geté toqo-lawaqape-eq, qo pingim qó-eqagím. Yaq ezoqa vini qáløváz. Yaq ndǿgo tenǿ-itúq, qo ma okho poeveav ndoqotego.” ");
INSERT INTO kvg_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu nqanek manqat ge-ein, tene-omát ndǿgo, Pita ande āv kenénanīm neka ta mokho-te ndøgo, ndego Mbumbukiam-qa iz ande āv kembøé-eqā. Taqa zita-te, Yesu Pita āv gembøe-eín nqǽgo, “No qonøndó-páev.” ");
INSERT INTO kvg_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita gendoqambun, yaq ndego paev ezoqa nøme ndø-omét. Ngenek gèzøpavám. Ezoqa ndégo, te-te ndego, Yesu kuku qambogoam, neka ndego Pasova lou loge-te, Yesu-qa savim-te go꞉vintavam, neka vømbōbevap, av nqægo, “Evézøza, gekha ezoqâm ndego, qo sa teqaqambun?” ");
INSERT INTO kvg_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita ndego ezoqam ge-omet, yaq ndego Yesu āv gembøebeváp nqǽgo, “Evézøza, gemâ ngenek? Áv kenénanīm?” ");
INSERT INTO kvg_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yaq Yesu gembo-qavøiu, “No tønø-pøovat, ndego até teyaget, atema no vøtøndóqavān, yaq gê, ndøgo gekhā ndǿgo, qo-te? Nqanek qoqá matév mbá. Qo soqonøndó-páev.” ");
INSERT INTO kvg_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yesu nqanek manqat ge-ein, yaq ta zapaya ndøgo, Klisten ezoqa bawan mokho-te, manqat āv qane-panqavøém nqǽgo: Ndego paev ezoqam génanimák. Geté Yesu manqat einiáv av nqægo, ndego gēnanimāk. Ndego sa nqánek ge-eín, “No tønø-pøovat, ndego ate teyaget, atema no vøtøndóqavān, gê, ndøgo gekhā ndǿgo, qo-te?” ");
INSERT INTO kvg_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ndego paev ezoqam, teqa yaq-te Yesu nqanek manqat ge-ein, ezoqam ndégo, nqanek emanqat ate nqægo gevotot neka vø̄peawam. Ni mø̀tinøtén, manqat ndøgo, ndego ge-ein, unimanqatín. ");
INSERT INTO kvg_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu matev nøme kopoáv gematønumam. Ta matev vinivinimba ate ndægo, amba tøpeawapɨn, éisa, no nqæmatavap, manqei-qape-te, mbuk ate ndægo, ambá géløvuzuák. ");
INSERT INTO kvg_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tíofilus. Khaiya mbomá, qo-te! Ta mbuk ndøgo, no bugukhokhof qæpeawam, no tøtø-peawám ndǿgo, matev ate ndægo, Yesu gematønumam neka ezoqa vø̄e-zømesimam, ndego teqa sasae ande ge꞉ngaz, ");
INSERT INTO kvg_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","atema ta khøuwa-te ndøgo, Mbumbukiam yan-te vø̄khato. Bugukhokhof, ndego Nqova Mbomambaqape mokho-te, tegi u-anim, manqa é-møndøzø-løvuá, ndigu bugukhokhof gevevesam. ");
INSERT INTO kvg_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yesu tae mutui-te gitøkewem, genanim, nango gendo-khandi꞉v, yaq ndego khøuwa foti mokho-te, gèfakhanumám ti-te, neka Mbumbukiam-qa Megeat Matev-qa yaq-te vø̄e-zømesimam. Ndego khøuwa kopoáv, āv gene-zømesimám nqǽgo: Ndego unimanqatin ndøkhandí꞉v. ");
INSERT INTO kvg_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Khøuwa nøme, Yesu ti namba ge꞉goam, ndego āv gezømbe-eín nqǽgo, “Zelusalem taon naqanøká ndø-ivø̀ve᷄m. Geté manqa mbusa ndøgo, av noge Tat ge꞉ve, tozombøé-kewagát ndǿgo, no qazømbe-manqatam. ");
INSERT INTO kvg_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Zion, ndego ezoqa ibøkha iz, ibøkha-té genøzø-etoumám. Geté zo avønín, ibøkha iz, Nqova Mbomambaqapé qazøté-ndapém.” ");
INSERT INTO kvg_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Khøuwa nøme, Yesu-gi u-anim, te namba gi꞉møvab, ndigu āv gimbøe-bevøpém nqǽgo, “Evézøza. Éisa, qo ni Izlael ezoqam, ndakin megeat matev nqawa poqonimbí-etoām, penømakhaya, yaq ni nikeza ezoqam nimbō-kawaevtāt?” ");
INSERT INTO kvg_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yaq Yesu gezø-qavøiu, “Matev āv taoká, av ndægo, zo zøtēzøtēz, ta khøuwa neka viav, Tat ekeza poev-te gezav. ");
INSERT INTO kvg_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Geté Nqova Mbomambaqape zo-te tendovis, zo bazaføgakh zóndapém. Yaq zo nogi bøi vizu ezoqam zógoát, neka noqá u zóløozumát, nqanek Zelusalem taon-te, neka Zudia plovins-te ate ndægo, neka Samalia manqei-te, atema manqei-qape-qa vaev-te.” ");
INSERT INTO kvg_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesu manqa manqate qamømbøe-navøem, yaq Mbumbukiam yan-té genø-eqeiú. Ndigu até ge-ometát, ge-eqanat, atema khaiya ozoz vømē-otan. ");
INSERT INTO kvg_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Tiqa bøi é-møndømø-føgøføgakhám, yan-te. Yaq nqáe! Tiqa avønin-te, ezoqa menas sègefakház. Ndabua papaqa ndø-uzupám. ");
INSERT INTO kvg_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Yaq ndigu āv gizømbe-eín nqǽgo, “Gélili plovins-ak. Zo gekhá zówanet, yan ndozo-waomit? Ngenek Yesu, Mbumbukiam zo mokho-te gendaf, yaq yan-te vø̄qavig, ndego nqawa āv tendéqaván, av zo ndakin qazøte-ometam, yan-te geqavigat.” ");
INSERT INTO kvg_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Yaq Yesu-gi u-anim, ta manqei poyat ndøgo, Oliv manqei poyat gimbo-akhaemam, gè-ivøvém, Zelusalem taon-te vø̄vesez. Yaq ta manqei pøyat-a, yaq Zelusalem, taqa atap khapémbá. Ande āv 1 kilomitá ndægó. ");
INSERT INTO kvg_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Zelusalem taon-te gimøfakhaz, yaq khoev ova kouwat-té ginøzáv, ma gipindumam. Ezoqam ngínik: Pita neka Zion neka Zems neka Endlu neka Filip neka Tomas neka Batolomeu neka Metiu, neka Zems nøme, ndego Alfius-ge yo, neka Saemon, ndego Zelot ezoqam, neka Zudas, ndego Zems-ge yo. ");
INSERT INTO kvg_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nginik mø̀ndø-møvøbumám, vø̄guligulimam. Até sakhéis-a, vø̄goam. Neka até Melí-a, Yesu-gu evo, neka tegi emekheis, vø̄goam. ");
INSERT INTO kvg_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Khøuwa nøme, ndigu ezoqam, Yesu gi-unimanqatintam, nqawa gimøvab, ezoqam ande av 120 ate gi꞉goam, yaq Pita tenø-itán ndǿgo, vøzø̄-ein, ");
INSERT INTO kvg_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Nǿfuap. Mbumbukiam-qa Manqat-te, Nqova Mbomambaqape Deivid mokho-te, Zudas-qa yaq-te, manqat é-møndo꞉-eín, ndego ndigu ezoqam gezø-ovøemavun, ndigu Yesu gimøvøinam. Yaq nqanek manqat bè-unimanqatín, matev vø̄fakhan. ");
INSERT INTO kvg_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ni Yesu-gi u-anim, nøme ndégo tegoám, neka sasae kopømba vøtīgoam, ni namba.” ");
INSERT INTO kvg_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Moni ndigu, Zudas gendapaz, matev soqaqape ge꞉matanam, khae me꞉wiím. Yaq ta manqei-te ndøgo, ndego sègebøiáv. Pakhapakhá. Teqa kha sège-keqavøemát, neka teqa emu vøndō-qouvøem. ");
INSERT INTO kvg_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ezoqa ewaqape, Zelusalem taon-te giyagam, manqat sùgumu-ewagát, taqa yaq-te. Yaq ta khae manqei ndøgo, ekeza manqat-te, Akeldama mbo-akhaemám. Taqa manqa mokho nqánek, “Khae Manqei Kouk-ús.”) ");
INSERT INTO kvg_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Yaq Pita nøme gezø-ein, “Sams mbuk mokho-te, āv qane-peawáp nqǽgo, ‘Teqa khoev unimé꞉-khakhambá. Ndøgo ezoqa gó꞉yageák.’ Neka nøme ndøpeawap, nqánek, ‘Teqa sasae, ezoqá nøme bendáp.’ ");
INSERT INTO kvg_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Yaq nakémbá, ni ezoqa kopo bizimbo-vawém, ndego ni namba qazi꞉goam, ta khøuwa ate qæpavpavemam, nigi Evezøza Yesu, ni namba ge꞉-okhoam, ");
INSERT INTO kvg_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","sasae ande qandengaz, Zion ezoqa ibøkha iziz gezø-etoumam, atema ta khøuwa-te ndøgo, Yesu ni genøuvan, Mbumbukiam yan-te gendaf. Yaq ngenek ezoqam, nqanek sasae até begót, ni namba, neka u bēløozumit, av bøi ge꞉qeiv, av nqægo, Yesu løvøte-tē gendo-khandī꞉v.” ");
INSERT INTO kvg_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita nqanek manqat ge-ein, yaq ndigu ezoqa menas ndø-upøzó. Nøme ndego, Zoséf. Iz menas nøme mø̀ndømbo-goám, Basabas neka Ziastes. Neka nøme ndego, Matiás. ");
INSERT INTO kvg_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Yaq ndigu āv gini-guligulimém nqǽgo, “Evézøza. Qo ezoqa ewaqape-qa matavap mòqote-qatéq. Qotínømánd, nginik ezoqa menas, ākenégo, qo qoqo-veatav, ");
INSERT INTO kvg_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ndego qoge u-anim tegoat, Zudas-qa iziz vǿendāp. Zudas nqanek sasae, zitá genewuá. Yaq ndǿgo tenøwáv, ma Mbumbukiam manqei gembøe-mendeo.” ");
INSERT INTO kvg_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Yaq ndigu nandi-qasis ndønqagevemém, iz-ús. Yaq Matias-qá iz ndøfakhán. Yaq Keliso-gi u-anim ileven-te, ndégo tindafém. ");
INSERT INTO kvg_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Zu ezoqam-qa khøuwa kandambaqape-te ndøgo, Pentikos ndimbo-akhayam, ndigu ezoqam ate gi꞉goam, khoev kopo-té ginømøváb. ");
INSERT INTO kvg_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Yaq nqova mbaín, yan-te ndo꞉go, u ndowáv. Andé khamøe-qape me꞉fetavún. Yaq khoev ate qægoam, ma gi꞉qonavam, u ùnime꞉kház. ");
INSERT INTO kvg_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Yaq ndigu andé gøina wageap me me꞉qeivím. Sègendo-panqavøém, ezoqa ewaqape-qa kha-te, vø̄qonam. Andé ezoqa sas bugug me me꞉kewagám. ");
INSERT INTO kvg_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Yaq nginik ezoqam ate gi꞉goam, kha Nqova Mbomambaqapé qazømbe-tønøyám. Yaq bawan vinivinimba-qá manqát gini-manqatát, av Nqova Mbomambaqape, matev gezømbe-etoumat. ");
INSERT INTO kvg_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ta khøuwa-te ndøgo, Zelusalem taon-te ndøgo, Zu bawan-ak kandambá giwambupam. Manqei-manqei ate ndǽgo, sugumu-pitát, ndigu ezoqam, Mbumbukiam gimbo-vizupam. ");
INSERT INTO kvg_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Yaq nginik ezoqam, nqanek u giyogem, tinduzáv ndǿgo, matev vǿqeivim. Ezoqa kandambá. Yaq ndigu nqova zøndáf. Zapa ndǿgo, Yesu-gi paev ezoqam, manqat gimanqatat, ndigu tiqá bawan vinivinimba-qá manqát gini-manqatám. ");
INSERT INTO kvg_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ndigu nqova ndafe kandambá, yaq gibevøpem, “Nqáe! Nginik manqa ngimanqate, nginik Gelili plovins-ak mbá. ");
INSERT INTO kvg_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Gê, áv khané꞉go, ni ate nqazi꞉gu nqazizø-yoge, nikeza manqat vinivinimba ngi꞉manqate? ");
INSERT INTO kvg_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ni ezoqa vinivinimba, nøme Patia manqei-ák, nøme Midia manqei-ák, nøme Elam manqei-ák, neka nøme ndigu Mesopotemia-yák, neka nøme Zudia-yák, neka nøme Kapadosia-yák, nøme ndigu Pontus-ák neka nøme ndigu Esia-yák, ");
INSERT INTO kvg_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","nøme Fligia-yák neka nøme Pamfilia-yák, nøme Izip manqei-ák neka nøme Libia-yák, ndøgo Sailini taon avønin-te. Até Lom ezoqám-a, vøndōzav. ");
INSERT INTO kvg_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ti mokho-te, nøme Zu bawan-ák neka nøme bawan vini ezoqám, ndigu ti-te ginøzaz, Mbumbukiam timbo-vizupat. Neka ni ezoqa nøme, Klit manqei bawa-yák, neka ezoqa nøme, Alebia manqei-ák. Geté ni ate nqazi꞉gu, nginik niqa manqat vinivinimba-té qazizø-ewagét. Mbumbukiam-qa matev kandakanda-qa yaq-té gini-manqatét.” ");
INSERT INTO kvg_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ndigu nqova ndafe kandambá neka gò꞉nakém, taqa yaq-te. Yaq āv ginibónd nqǽgo, “Gekha matêv nqanek?” ");
INSERT INTO kvg_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Geté ezoqa nøme gèvongezó, ndigu ezoqam, Yesu gi-unimanqatinim, gi-einim, “Nginik ezoqam, gèndo-íz.” ");
INSERT INTO kvg_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Yaq Pita, ndigu u-anim ileven nøme namba, tenø-itán ndǿgo. Yaq sa manqa ndøyám. Yaq ezoqa ewaqape, gi-oteipam, āv gezømbe-eín nqǽgo, “Zo Zu ezoqam, nogi ezoqam, neka zo ezoqa nøme, nqanek Zelusalem taon-te nqazo-wambap, vø̀ndoyogém, no mokho bazø̄-ovøyam. ");
INSERT INTO kvg_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nginik ezoqam, ambá av nqǣgo, ge-īz, av zo ndøzøte-matavap. Ezoqa lovølova ndø-izumatún. Geté ndakin qanaqanus 9 oklok mbá. ");
INSERT INTO kvg_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Geté matev, ndakin qafakhan, ndǿgo, av Mbumbukiam-ge manqa vevezam ezoqam Zoel ge꞉manqatam. Ndego ge-ein, ");
INSERT INTO kvg_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Mbumbukiam āv gene-eín nqǽgo, “Vaev khøuwa-te, no ezoqa ewaqape, noge Nqova nøzǿ-etoám. Zogi nakhei angana neka zogi nakhei sakheis, noqa manqat ndǿvevezumát Zogi ezoqa ndakinak, umingiap ndǿqeivát, neka zogi laombøkik, venanqei vǿtamāt. ");
INSERT INTO kvg_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ta khøuwa-te ndøgo, no até sasae ezoqám-a, angana neka sakheis, ndigu no ti-unimanqatintat, Nqova Mbomambaqape vøezǿ-etoām. Yaq ndigu noqa manqat ndǿvevezumát. ");
INSERT INTO kvg_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","No umingiap matev nómatønumát, khaiya ova nekā manqei-qape-te. Kouk neka wageap neka ekuqape ndǿfakhán. ");
INSERT INTO kvg_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Khøuwa ndø̀bøivunév, neka løvøyak andé kouk mé꞉goát. Nqanek matev ndø̀khæ-fakhán. Yaq Evezøza-qa Khøuwa Kandambaqape ndǿfakhán, ndego teqa bazaføgakh neka waev te꞉zømas. ");
INSERT INTO kvg_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ta khøuwa-te ndøgo, gekha ezoqām ndego, Evezøza-te tøkeam-qa te-akha, ndego gékhandí꞉v.” ’” ");
INSERT INTO kvg_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pita nqanek Zoel-qa manqat qamømbøe-navøem, yaq ndego manqat nøme āv gezømbe-eín nqǽgo, “Ízlael ezoqam! Manqat qàndoyogé nqanek, nogi ezoqam! No Yesu Nazalet-ak-qa yaq-té qazømbé-eín. Zo zøkeza mø̀zøte-zøtéz, te mokho-te, Mbumbukiam zoqa avønin-te, umingiap matev neka matev kandakanda vinivinimba ndømatønumám. Mbumbukiam tene-matanám ndǿgo, zo tø̀nezøtéz, ndego Yesu ekezan ndokhofotáv. ");
INSERT INTO kvg_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ezoqa ndego zoqa zenda-te giveem, yaq zo ndego ezoqa soqøsoqa mokho-te, tae mutui-te sasa zotøkewem, vozōlaem, ndøgo Mbumbukiam ekezan ndøpøoá. Ndego é-møndæ-otév, matev av nqægo ndø̀fakhán. ");
INSERT INTO kvg_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Geté Yesu løvøte-qa bazaføgakh mokho-te gu꞉goam, Mbumbukiam mø̀ndø-nqovotáv, vø̄khandi꞉v. Løvøte, ngenek ezoqam amba me꞉geiú. Geté kopømba mbaín. ");
INSERT INTO kvg_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yesu løvøte-te tekhandi꞉v, taqa yaq-te, Deivid nupøkhan mba, āv gene-eín nqǽgo, ‘No Evezøza, noqa megemege-te, oskia no-ometám. Ndego noqa avønin-té gegó. Yaq no kha genǿ-wagimák. ");
INSERT INTO kvg_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yaq nakémbá, noqa mbøni mokho-te, no khanakhanákh neka no manqat khanakhanakh-us nomanqaté. Até noqá khá-ya, Mbumbukiam-te mbá qanøtawát. ");
INSERT INTO kvg_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Zapa ndǿgo, qo no ezoqa pakhaezatak-qa manqei-te qónøuvanák. Qo qoge Ezoqam Mbomambaqape, teqa kha, sa qó-ivavák, vǿlanqā. ");
INSERT INTO kvg_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Qo no nakhoa qotenømánd, no khandi ande āv khaténdāp. Qo no namba qotégoát. Yaq no khanakhanakh nógoát.’” ");
INSERT INTO kvg_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pita nqanek Deivid-qa manqat qamømbøe-navøem, yaq nøme āv gezømbe-eín nqǽgo, “Nǿfuap. Nigi atanakha-zapa Deivid-qa yaq-te, no ndaføyambá qazømbé-eín. Ndego mø̀ndønaním, neka vø̄-otøvem. Até ndakin khøuwa-té-a, teqa manqei ozu nqánek qagó. ");
INSERT INTO kvg_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Geté Deivid mø̀ndæ-otév, tegi zi, ezoqa kopo, teqa iziz ndǿndáp neka kawa ezoqam vǿgoāt. Mbumbukiam te-te manqa mbusa ndøvé, taqa yaq-te. Deivid Mbumbukiam-gé manqa vevezam ezoqam ndøgoám. ");
INSERT INTO kvg_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Yaq nakémbá, ndego é-møndøqeív, Keliso tenanim, yaq Mbumbukiam gékhandí꞉v. Unimanqatín. Mbumbukiam ndego ezoqa pakhaezatak-qa manqei-te ivøveáv, neka teqa kha, manqei ozu-te lanqøeveáv. ");
INSERT INTO kvg_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ngenek ezoqam, Mbumbukiam løvøte-te gekhandi꞉v, Yesú. Ni ate nqati꞉gu, nikeza bǿi qatiqeivím. ");
INSERT INTO kvg_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Mbumbukiam ndego ekezan-té genø-eqeiú, neka teqa nakeamo zenda-te vø̄ve. Yaq Eve Nqova Mbomambaqape mbo-etoám, av ibugukhokhof manqa mbusa ge꞉ve, yaq Yesu ndakin ni vønī-etoam. Matev nqánek, zo nqazo-qeivi neka nqāzōyōgē. ");
INSERT INTO kvg_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ni mìzi꞉nøtén, Deivíd mbá, yan-te geqavig. Geté ndego Mesaya me꞉manqatám, av ge-ein nqægo, ‘Evezøza Mbumbukiam, noge Evezøza, āv gembøe-eín nqǽgo, “Noqá nakeamo zenda-té qanøqóm. ");
INSERT INTO kvg_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Até qóqotát, atema no qogi qaqa ezoqam, kopømba ande av zenda tokhotapak awam nonqo, qoqa zenda tokhotapak mokho-te vøtaqambú-āb.” ’ ");
INSERT INTO kvg_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Yaq nakémbá, zo Izlael bawan-ak ate ndøzøte꞉go, zo vø̀ezøtéz. Ngenek Yesu, zo tae mutui-te qazo-tøkewem, Mbumbukiam āv gene-veatáv nqǽgo: Ndego Evezøza neka Mesaya ndǿgoát.” ");
INSERT INTO kvg_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Yaq ndigu ezoqam, Pita-qa manqat giyogem, tiqa mbøni, mø̀ndø-khanáz. Yaq ndigu Pita neka Keliso-gi u-anim nøme, āv gizømbe-beváp nqǽgo, “Nǿfuap. Ni ndakin gekhā nígonēm?” ");
INSERT INTO kvg_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Yaq Pita gezø-qavøiu, “Zo é-mozoqambúz, neka Yesu Keliso-qa iz-te, ibøkha iziz vø̄-upøgim. Yaq Mbumbukiam zoqa manqa-zapazapa, segembøé-navøém, yaq zo Nqova Mbomambaqape vozóndafēm. ");
INSERT INTO kvg_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Manqa mbusa ndøgo, Mbumbukiam taqa yaq-te geve, ndøgo zoqá neka zogi nakheis-qá neka até tiqá ndigú-a, ndigu qamba-qamba ndindu-yageapet. Gekha ezoqām ndigu, ndego Evezøza, nigi Mbumbukiam, ndezø-akhayam, te-te tinduzav, nqanek manqa mbusa tiqa ndígu.” ");
INSERT INTO kvg_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita manqat nøme kandambá gezø-manqatam. Manqat nøme, āv gezømbe-eín nqǽgo, “Mòzoqambúz. Soqaín ndøgo, nginik manqa-zapazapa-us ezoqa namba tøzøte-soqoez, ndakin ngiyage.” ");
INSERT INTO kvg_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ezoqa ndigu, Pita-qa manqat gindapem, ndigu ibøkha iz ndøndapém. Ta khøuwa-te ndøgo, ezoqa kandambá, Klisten bawan-te gi-oz. Ate gi꞉goam, ande āv tri taosen ezoqám ndi꞉gú. ");
INSERT INTO kvg_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ndigu Klisten ezoqam, āv gini-matønumám nqǽgo: Keliso-gi u-anim-qá nømendim manqat ndø-ewagám, neka yaqyaq-a vø̄tøke꞉mam. Ndigu gèpindupám, lou vø̄logɨn neka Evezøza-qa lou loge matev vø̄gonemɨn neka vø̄guligulimemin. ");
INSERT INTO kvg_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mbumbukiam, Keliso-gi u-anim mokho-te, umingiap matev kopoáv gematønumat. Ezoqa ewaqape, nqova ndafe kandambá neka møe vø̄gonemɨn. ");
INSERT INTO kvg_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ndigu ezoqa ate gi꞉goam, Yesu gi-unimanqatinim, ndigu nqova kopo-te sùgumu-yagám. Neka tiqa gigiap ate qazømbe-goam, sège-etoumám, yaqyaq-a. ");
INSERT INTO kvg_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ekeza manqei neka gigiap vinivinimba gèwiám. Yaq moni ndigu, gi꞉qaqasumam, ndígu tizø-etoumám, lou-qa o gigiap-qa gi꞉potonumam. ");
INSERT INTO kvg_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Khøuwa ate qæpavpavemam, ndigu Mbumbukiam-qá khoev-té ginø-pindupám. Yaq Klisten zifuap vinivinimba-qa khoev-te, ndigu lou ndølogám neka Evezøza-qa lou loge matev vømø̄-gonemɨn. Khanakhanakh-ús. Lou sège-etoumám, yaqyaq-a. ");
INSERT INTO kvg_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Yaq tiqa matev ate qægoam, ndigu Mbumbukiam-qá iz me꞉-eqatám. Ezoqa ewaqape, poev ndøveém, ti-te. Yaq khøuwa ate qæpavpavemam, Evezøza Klisten bawan-te, ezoqá nøme ndøyogimám, ndigu khandi gezø-etoamɨn. ");
INSERT INTO kvg_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Khøuwa nøme, ande av khagus tri oklok ndægo, ta khøuwa iz-te ndøgo, Zu ezoqam giguligulimam, Pita neka Zion, Mbumbukiam-qá khoev-té ginø-apát. ");
INSERT INTO kvg_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ta khøuwa iz-te ndøgo, ezoqa kagi ezoqam ndø-eqeitavún. Ndego āv teneqán, kagi. Khøuwa ate qæpavpavemam, ndego mboqog tambav-té ginø-ivøvemɨ́n, ta mboqog ndigu, Qanimav-Qape gimbo-akhaemam. Yaq ndego ezoqa moni-qa zøviamɨ́n, ndigu Mbumbukiam-qa khoev-te gi-onimam. ");
INSERT INTO kvg_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Yaq ndego Pita neka Zion gezømet, gi-onat, ndego moni-qa zøviám. ");
INSERT INTO kvg_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ndigu ezoqa menas, gèwaomém. Yaq Pita ndego āv gembøe-eín nqǽgo, “Ni-tē qotøndé-kewāg.” ");
INSERT INTO kvg_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Yaq ndego vø̄kewag. Ndego āv gene-matavupám nqǽgo: Moni nø̄-etøomēm. ");
INSERT INTO kvg_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Geté Pita gembo-ein, “No moni mbaín. Geté no tøtaqá-etoám ndǿgo, no nqanøgo. Yesu Keliso-qa iz-te, ndego Nazalet vemiav-ak, mòqo-itán neka okho vø̄ngaz.” ");
INSERT INTO kvg_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Yaq Pita nakeamo zenda mbogeá, vø̄-eqeiu. Yaq nqova mbaín, teqa zenda tokhotapak sègembo-føgøføgakhám neka gømig vømbō-føgøføgakhæzam. ");
INSERT INTO kvg_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Yaq ndego sasanqá sege-itán, okho vø̄ngaz. Yaq Mbumbukiam-qa khoev-te, namba me꞉-óz. Sège-okhoát neka vø̄vøvumat, neka Mbumbukiam-qa iz vø̄-eqatat. ");
INSERT INTO kvg_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ezoqa ti-ometám ndǿgo, ge-okhoam neka Mbumbukiam-qa iz ge-eqatat. ");
INSERT INTO kvg_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Gimatøvemem, av nqægo, ezoqa ngēnek, mboqog tambav-te geqonumam, ta mboqog ndigu Qanimav-Qape gimbo-akhaemam, neka gigiap-qa vø̄vi꞉mam, yaq ndigu nqova ndafe kandambá, ta matev-qa yaq-te, ndøgo qambo-fakhan. ");
INSERT INTO kvg_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ndego ezoqam, kagi gegoam, Pita neka Zion, ti-te gèmø-tøkenøvém. Yaq lou-qase-te gizav, ndøgo Solomon-qa Lou-Qase gimbo-akhaemam, ezoqa ewaqape tinøbǿin ndǿgo, ngenek ezoqam vø̄-ometam. Yaq ndigu nqova ndafe kandambá. ");
INSERT INTO kvg_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita nginik ezoqa gezømet, yaq āv gezømbe-eín nqǽgo, “Zo Izlael-ak, nogi ezoqam. Gekha zapâ, zo nqova qazøndaf, matev av nqægo qafakhan? Neka gekha zapâ, ni-te ndozotøndo-keoge? Ge zô, ndozo-matavap, ni ngenek nikeza bazaføgakh-tē qeitǿ-khakheinøvemem, okho gengaz? Ó, ni ezoqam qaniqanîm, Mbumbukiam-qa bøi-te, yaq nakêmbà, ndego ni ginitøke, ngenek ezoqam qeikhakheinøvemem? Āv taoká! ");
INSERT INTO kvg_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ta matev mokho-te, ndego Eibleem neka Aezek neka Zekop-ge Mbumbukiam, ndego nigi atanakha-zapazapa-za-ge Mbumbukiam, ndego tege sasae ezoqam Yesu, iz kandambaqape mbo-etoám. Ezoqam ngének, zo Lom ezoqam-qa zenda-te qazoveem, yaq ndigu vø̄laem. Pailøt ambá sege-nqonqotavɨ́n. Geté zo Yesu zòsanqawém. ");
INSERT INTO kvg_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Zo ngenek Ezoqam Mbomambaqape neka Ndaføyamba-qape, zòsanqawém. Yaq zo Pailøt pepen ezoqam-qa zombo-viømém, sa tezø-nqonqotav. ");
INSERT INTO kvg_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Zo ngenek khandi zapa ezoqam, zòlaém. Geté Mbumbukiam mø̀ndø-khandí꞉v, løvøte-te. Ni nikeza bǿi qatiqeivím. ");
INSERT INTO kvg_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ngenek ezoqam, zo nqazo-omete neka ndø̄zø̄tē-zø̄tēzāt, ngenek Yesu-qa bazaføgakh neka iz mokho-té, bazaføgakh gendap. Nqanek matev, unimanqatin matev-té qando-fakhán. Ni Yesu qei-unimanqatinim, yaq ndego ngenek ezoqam gèkhakhǽv, av zo ndakin nqazøte-omete. ");
INSERT INTO kvg_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Nǿfuap. No mø̀tenøtén, matev ndøgo, zo neka zogi megetapak, Yesu qazombo-matønømem, zapa ndǿgo: Zo zøtezateáv. ");
INSERT INTO kvg_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Mbumbukiam, tegi manqa vevezam ezoqam ate gi꞉goam mokho-te, é-møndi꞉nømánd, av nqægo, ndego Mesaya, tendo-khofotav, ezoqa tekhandi꞉z, ndego nqosøgeap ndǿqeív, vǿnanīm. Yaq ta matev mokho-te ndøgo, qafakhanam, nqanek manqat mø̀ndø-unimanqatín. ");
INSERT INTO kvg_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Yaq ndakin, zo é-mozo-enénd neka Mbumbukiam-te vozóqambūz. Yaq ndǿgo, Mbumbukiam zoqa manqa-zapazapa, segembøé-navøém. ");
INSERT INTO kvg_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Yaq ndego zo pusa taev matev zǿ-etoám, neka Mesaya vøndó-khofotāv, ndego ibugukhokhof geveatav, ezoqa tekhandi꞉z. Ngenek ezoqam, Yesú. ");
INSERT INTO kvg_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Geté ndego bugukhokhof yan-té geabeto꞉gó, atema ta khøuwa-te ndøgo, Mbumbukiam gigiap neka matev ate ndægo nango vǿndakināk, av ndego nupøkhan mba, tegi manqa vevezam ezoqam mokho-te ge꞉-ein, ndigu gevevesam. ");
INSERT INTO kvg_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mozes āv gene-eín nqǽgo, ‘Evezøza, zoge Mbumbukiam, zo mokho-te manqa vevezam ezoqam ndǿveatáv, av no nqate꞉go. Yaq gekha manqāt ndøgo, tezø-manqatat, zo vø̀ndapemát. ");
INSERT INTO kvg_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Geté gekha ezoqām ndego, teqa manqat ndapeav tøgoat, yaq Mbumbukiam ndego géngiú. Yaq ndego Mbumbukiam-ge ezoqam sekemba gégoák.’ ");
INSERT INTO kvg_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Até Samuél-a, neka Mbumbukiam-gi manqa vevezam ezoqam ate gi꞉goam, teqa zita-te gipavavun, ndigu matev ndǿgo tini-manqatám, av ndakin khøuwa-te qæfakhanam. ");
INSERT INTO kvg_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Manqa mbusa ndøgo, Mbumbukiam tegi manqa vevezam ezoqam mokho-te gendo-ein, ndøgo zogi atanakha-zapazapa-za-te geve, ta manqa mbusa ndøgo, zo nonqó. Mbumbukiam Eibleem namba, poev ge-unimanqatin, yaq āv gembøe-eín nqǽgo, ‘Qogi qazi, ezoqa kopo mokho-te, no ezoqa ewaqape matev mbomømboma nøzǿ-matanám, nqanek manqei-qape-te.’ ");
INSERT INTO kvg_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Mbumbukiam ngenek sasae ezoqam Yesu, ndego geveatav, bugukhokhof zo-té gendo-khofotáv. Ndego tende-khofotáv ndǿgo, ndego zo matev mbomømboma zǿmatanám, zoqa manqa-zapazapa-te tøzøtønde-qambuz.” ");
INSERT INTO kvg_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita neka Zion, ezoqa manqat até gezø-manqatám, yaq Mbumbukiam-gi iziz ezoqam neka Mbumbukiam-qa khoev vos keoge ezoqam-ge kawa neka Sadusi ezoqam tīnø̄fākhāz. ");
INSERT INTO kvg_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ndigu khanakhanakh mbaín, ndigu ezoqa menas, ezoqa gi꞉zømesimat, neka gi꞉zømas, av nqægo, Mbumbukiam kopømbaqapē ezoqa løvøte-te tekhandi꞉z, zapa ndø̄go, ndego Yesu ndøkhandī꞉v, løvøte-te. ");
INSERT INTO kvg_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Yaq ndigu Pita neka Zion sègegavém. Yaq ndimbula-té genø-nqeitáz, atema nøme vøndōpave. Manqa ovøepøteáv. Zapa ndǿgo, gèpøistát. ");
INSERT INTO kvg_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Geté ezoqa kopoáv, ndigu tiqa manqat giyogem, gè-unimanqatiním. Yaq ndigu ezoqam, Yesu gi-unimanqatintam, mø̀ndømø-faev-taosen-éz, angana. ");
INSERT INTO kvg_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Yaq khøuwa nøme qandopave, Zelusalem taon-te ndøgo, Zu ezoqa kandakanda neka megetapak neka Mozes-qa guguna manqat nømendim ezoqam ndømøváb. ");
INSERT INTO kvg_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Até Anás-a, ndego Mbumbukiam-ge iziz ezoqam kandambaqape, neka Kayafas, neka ezoqa nøme, Zion gimbo-akhaemam, neka Aleksanda, neka Mbumbukiam-ge iziz ezoqam kandambaqape-gi ezoqa nøme, vø̄goam. ");
INSERT INTO kvg_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Yaq Pita neka Zion, tiqa megemege-té ginø-áb, sasa zøbevap, “Nqanek matev, gekha bazaføgakh-tē neka gekha ezoqam-qâ iz-tē qazonǿ-gonem?” ");
INSERT INTO kvg_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pita, Nqova Mbomambaqape kha é-møndømbøi-tønøyám. Yaq ndigu āv gezømbe-qavøiú nqǽgo, “Zo kawakawa-za neka megetapak! ");
INSERT INTO kvg_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Zo ni ndakin matev mbomambaqape-qa yaq-te nqazonimbi-sinøzumit, ni kagi ezoqam qeimbo-matønømem, yaq ngenek vø̄khakhæv, ");
INSERT INTO kvg_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","zo vø̀ezøtéz neka até Izlael ezoqam ewaqapé-a, betēzøtez: Ngenek ezoqam, zoqa bøi-te ngeya, Yesu Keliso-qá iz-té gene-eqeieqei-év, ndego Nazalet vemiav-ak. Zo ndego tae mutui-té qazonø-tøkewém. Geté Mbumbukiam løvøte-te mø̀ndø-khandí꞉v. ");
INSERT INTO kvg_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ezoqam ngének, teqa yaq-te Mbumbukiam-qa Manqat qæ-ein, av nqægo, ‘Nandi-qapi ndigu, zo khoev puanam ezoqam qazo-sanqabem, ndigu mø̀ndømø-gigiap-qape-éz, khoev puanam nonqo.’ ");
INSERT INTO kvg_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ezoqa nøme mbaín, niqa khandi꞉nat nonqo. Yesu yakhapús. Nqanek manqei-qape ate nqægo, Mbumbukiam ezoqa nøme khofotøveáv, ni tekhandi꞉n.” ");
INSERT INTO kvg_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ndigu megetapak, ndigu ezoqa menas gizømet, manqat ndaføyamba gi-einim neka mivi mbaīn, ndigu nqova ndafe kandambá. Zapa ndǿgo, ndigu mø̀ndæzøtéz, ndigu khokho ezoqám, skul kandakanda mbaín. Neka ndigu mø̀ndæzøtéz, ndigu ezoqa menas, Yesú namba me꞉goám. ");
INSERT INTO kvg_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Geté ndigu zøtezateáv, gekha manqat zǿqavøiū. Amba zømbe-eín. Zapa ndǿgo, ndego ezoqam, kagi gegoam, Pita neka Zion namba me꞉wanám. Ndego mø̀ndø-khakhǽv. Yaq ndøgo bavokho-qapé. ");
INSERT INTO kvg_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Yaq ndigu bavokhó ginø-khofotáz. Yaq gizav, ndigu Zu megetapak, manqa ovøyam khoev-te gu꞉qonavam, manqa ndøvøovømém. ");
INSERT INTO kvg_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Gi-einim, “Gekha zizǿgō, nginik ezoqa menas? Ezoqa ewaqape, nqanek Zelusalem taon-te ngiyage, mø̀ndømu-yogém, av matev gi꞉matønømem ndægo. Unimanqatín. Ndøgo matev viní. Ni kopømba mbaín tizio-naomem. ");
INSERT INTO kvg_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Geté nqanek manqat Yesu-qa yaq-te, ezoqa nøme-te, bepanqàvøe᷄m. Yaq nakémbá. Ni manqa āv qazizømbé-løvuá nqǽgo, ndigu teqa iz-te, ezoqa nøme manqat nqawa bezø̀-ei᷄n.” ");
INSERT INTO kvg_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Yaq ndigu nqawa gizø-akha, khoev mokho-te vø̄u-oz, yaq gèzømbe-khafén. Ndigu Yesu-qa iz-te, manqat nqawa be-eìni᷄m, neka ezoqa nqawa bete-zømèsi᷄m! Matev av nqægo, ùni bete-navøém! ");
INSERT INTO kvg_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Geté Pita neka Zion gizø-qavøiu, “Zo zøkeza mokho-mba, zøté-matøvømēm, av nqægo. Eqeieqei ākhanégo? Zoqâ manqat níndapēm, ó, Mbumbukiam-qā manqat níndapēm? ");
INSERT INTO kvg_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ni kopømba mbaín, manqa sa teikhoutavat, av ni bøi qatiqeivam, neka vø̄i-ewagam.” ");
INSERT INTO kvg_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Yaq ndigu megetapak, kha-khoiv manqat nøme zø-eín. Geté yaq sège-nqonqotáz, vø̄zav. Ndigu nakhoa qeiviáv, yaq-fia nqosøgeap ande āv kizømbé-etoām. Zapa ndǿgo, ezoqa ewaqape Mbumbukiam-qá iz ndø-eqatát, ta matev ndøgo, qafakhan. ");
INSERT INTO kvg_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ngenek ezoqam, ndego kagi-qape geqan, yaq Yesu-qa iz-te vø̄khakhæv, ndego viav 40 mø̀ndømø-løvú. ");
INSERT INTO kvg_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pita neka Zion até vønqonqotáz-ae, ekeza Klisten bawan ezoqam-te e-vø̄zav, yaq emanqat vøzø̄votot, av Mbumbukiam-gi iziz ezoqa kandakanda neka megetapak nøme gizømbe-manqatam. ");
INSERT INTO kvg_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ndigu Klisten bawan ezoqam, nqanek manqat giyogem, yaq sùgumu-guligulimém. Nqova kopo-té. Mbumbukiam āv gimbøe-akhaém nqǽgo, “Bázaføgakh-us-qape. Yan neka manqei-qape neka ndaola, neka gigiap ate nqægo, ta mokho-te nqøugut, qo qokhakheinumát. ");
INSERT INTO kvg_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Qo nigi atanakha-zapa Deivid, ndego qoge sasae ezoqam gegoam, qoge Nqova Mbomambaqape mokho-te, manqat qombo-etoám. Yaq ndego āv gene-eín nqǽgo, ‘Gekha zapâ, bawan vini-ak qaqa ndigu? Neka gekha zapâ, ndigu amba mba ndi꞉voqoyam? ");
INSERT INTO kvg_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nqanek manqei-qape-gi kawakawa-za neka megetapak mø̀ndø-tøkuaném. Ndigu nøfe-qa mba mo꞉keogé, Evezøza namba, neka Mesaya namba, ndego geveatav.’ ");
INSERT INTO kvg_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Unimanqatín. Matev av nqægo, mø̀ndø-fakhán, nqanek taon-te. Ndigu kawakawa-za menas, Elod neka Pontius Pailøt, manqei vini-ak neka Izlael manqei-ak namba me꞉tøkuaném. Neka nøfe-qa mba mo꞉kewagám, te-te ndego, Yesu, qoge sasae ezoqam, ndego qo Mesaya qoqo-veatav. ");
INSERT INTO kvg_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Geté ta matev mokho-te ndøgo, gimatønumat, ndigu qoqá matavap neka poev mba mbopavát. Qoqa bazaføgakh-te, qo nupøkhán mbá, é-moqopøoá, matev av nqægo tàbete-fakhán. ");
INSERT INTO kvg_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yaq ndakin, Evezøza, vø̀mbo-matøvém, kha-khoiv matev ndøgo, gimatønumat. Gìnitøké, ni qogi sasae ezoqam, yaq ni qoqa manqat, ndaføyamba neka mivi mbain tàbati-manqaté. ");
INSERT INTO kvg_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Qo zenda qotó꞉vé, ti-te ndigu, enqoni ndøzøgo, yaq vǿkhakhǣz. Neka qoge sasae ezoqam mbomambaqape, Yesu, teqa iz mokho-te, umingiap matev vinivinimba voqó-matønumāt.” ");
INSERT INTO kvg_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ndigu gumu-guligulimem, yaq manqei ndøgo, ma gi꞉qonavam, sùgumu-kukuvøemát. Yaq kha Nqova Mbomambaqapé qazømbe-tønøyám. Yaq ndigu Mbumbukiam-qá Manqat me꞉zømesimát. Bazaføgakh-ús neka mivi mbaín. ");
INSERT INTO kvg_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ndigu ezoqa ate gi꞉goam, Yesu gi-unimanqatintam, ndigu nqova kopo zømbegoám. Ezoqa kopo einiáv, av nqægo, “Nqanek gigiap, nøkeza nonqo mbā.” Geté gigiap ate qægoam, sège-etoumám, yaqyaq-a. ");
INSERT INTO kvg_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Keliso-gi u-anim, ezoqa āv gini-zømesimám nqǽgo: Yesu løvøte-te mø̀ndø-khandí꞉v. Yaq ndego Evezøzá. Ndigu bazaføgakh-us me꞉zømesimám. Neka Mbumbukiam, matev mbomømboma zømatønumám, kopoáv, ti-te ndigu, ezoqa ewaqape. ");
INSERT INTO kvg_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ezoqa kopo gigiap-qa potonøpøteáv, ti mokho-te. Ezoqa nøme ndigu, manqei o khoev qazøgoam, gèwiám. Yaq moni ndigu, gi꞉qaqasumam, ");
INSERT INTO kvg_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Keliso-gi u-anim-té ginø-upøgimám. Yaq ndigu gèqaqabemɨ́n, yaq gekha ezoqām ndigu, gigiap-qa gipotonumam, vøzø̄-etoamɨn. ");
INSERT INTO kvg_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ezoqa nøme, matev av nqægo gego, teqa iz Zoséf. Ndego Livai bawan-ák. Saiples manqei bawá geqán. Ndigu Keliso-gi u-anim, iz Banabas mbo-akhaemám. (Taqa manqa mokho, “Ezoqa zita tøpøzu ezoqám.”) ");
INSERT INTO kvg_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ngenek manqei ndøwí. Yaq moni ndigu, geqas, Yesu Keliso-gí u-anim-té genøndapáz, ezoqa tøke nonqo. ");
INSERT INTO kvg_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Geté ezoqa nøme mø̀ndøgoám. Iz Ananayás, neka ndego zas vømbōgoam. Tuqa iz Safilá. Até ndegó-a, ekeza manqei nøme, gèwí. ");
INSERT INTO kvg_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Geté moni ndigu, gendapaz, nøme gèkhonáb. Tegu zas mø̀ndæ-otév. Yaq moni nøme ndigu, Yesu Keliso-gí u-anim-té genøndapáz. Yaq āv gezømbe-eín nqǽgo, “Moni ndigu, qeiqasem, ngínik.” ");
INSERT INTO kvg_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Yaq Pita Ananayas gembo-ein, “Ánanayas. Gekha zapâ, qo Saitan qoqombotak, qoqa mbøni mokho-te gendo-on, yaq Nqova Mbomambaqape voqombø̄e-khavoz, qo moni nøme qoqokhonab, manqei qoqowi. ");
INSERT INTO kvg_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ndøgo qakeza manqei ndøgoám. Yaq qo qakeza poev-té qonøwí. Yaq moni qoqoqas, até ndigú-a, gemøqa-qakezanéz. Geté gekha zapâ, qo matavap soqøsoqa qoqo-tonqogim? Qo ambá av nqǣgo, ezoqa mba qombøekhavōz. Geté Mbumbukiam qombøekhavóz.” ");
INSERT INTO kvg_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Yaq Ananayas nqanek manqat ge-ewag, sègebøiáv, vø̄nanim. Yaq ezoqa ewaqape, manqat giyogem, kha zøkhoí. ");
INSERT INTO kvg_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Yaq ezoqa ndakinak, teqa kha ndabuá gini-løvønømém, bavokho sasa ndø-eqanem, vømø̄-ozem. ");
INSERT INTO kvg_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Khapé outøpøteáv. Ande āv tri awáz ndægó, zas tūndū-ōn. Ndugu otevateáv, matev ndøgo, qafakhan. ");
INSERT INTO kvg_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Yaq Pita gumbobevap, “Soqoní-eín. Moni ndigu qazoni-etoam, venanqeî, ndigu manqei qazøte-wiim?” Yaq gundu-qavøiu, “Venanqeí.” ");
INSERT INTO kvg_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Yaq Pita gumbo-ein, “Gekha zapâ, qeivis namba, manqat qazo-kopo꞉nem av nqægo, Evezøza-ge Nqova Mbomambaqape khamasim-te qazoveem? Nqáe! Ezoqa ndigu, qoge anganeam gi-otøvem, mboqog tambav-té gonowaní. Yaq ndigu até qó-a, gé-eqæqonám.” ");
INSERT INTO kvg_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Pita nqanek manqat ge-ein, yaq ndugu teqa megemege-te sègebøiáv, vø̄nanim. Yaq ndigu ezoqa ndakinak ginduqavaz, gi-ometam av nqægo, mø̀ndønanīm, yaq bavokhó ginø-eqeinám, zivis-qa avønin-te vømø̄-otøvem. ");
INSERT INTO kvg_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Yaq Klisten bawan ezoqam ate gi꞉goam neka ezoqa ewaqape, nqanek manqat giyogem, ndigu kha-khoiv kandambá. ");
INSERT INTO kvg_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Keliso-gi u-anim, ezoqam-qa mokho-te, umingiap matev kopoáv gimatønumam. Ndigu ezoqam, Yesu gi-unimanqatintam, Solomon-qa lou-qase-té ginøwambám, ndøgo Mbumbukiam-qa khoev-te. ");
INSERT INTO kvg_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Bavokho ezoqam, møe ndøsinønimám. Yaq ndigu Klisten ezoqam namba, tøkuateáv. Geté ndigu gèzø-vizupám. ");
INSERT INTO kvg_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Yaq Evezøza, ezoqa nøme mba mo꞉-unimanqatiním. Ezoqa kandambá. Angana nekā sakheis. ");
INSERT INTO kvg_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Matev ndøgo, ndigu Keliso-gi u-anim gimatønumat, ta zapaya ndøgo, ezoqa nøme enqoni-us ezoqam ndo-upøgimám. Yaq ndigu ekeza venanqei nonqo neka kita-te, nakhoa-té ginø-abumám. Yaq Pita-gé nqovønqova mba bekhantáz, ma ndego te꞉ma. ");
INSERT INTO kvg_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Até vemivemiav nøme-té-a, Zelusalem taon avønin-te ndøgo, enqoni-us ezoqam ndo-upøgimám, neka ezoqa nøme, nqova soqøsoqa giqantavam. Yaq ndigu ezoqa ate gi꞉goam, gèkhakhǽz. ");
INSERT INTO kvg_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Yaq ndego Mbumbukiam-ge iziz ezoqam kandambaqape neka tegi paev ezoqa ate gi꞉goam, ndigu Sadusi ezoqam gigoam, ndigu ova ndø-einím, Keliso-gi u-anim-te. Ova kandambá qazøgoam. ");
INSERT INTO kvg_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Yaq ndigu até gindigonem, Keliso-gi u-anim sègegavém, ndimbula-te vø̄nqeitaz. ");
INSERT INTO kvg_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Geté ta lova ndøgo, Evezøza-ge enzol ezoqam ndowáv, ndimbula mboqog vøzø̄-mboqogim, ndigu Keliso-gi u-anim bavokho sasa ndøkhatob, ");
INSERT INTO kvg_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","vøzø̄-ein, “Zo Mbumbukiam-qá khoev-té qanøzáv. Yaq ezoqam-qá megemege-té qazomǿwán, manqat ate ndægo, khandi-qa yaq-te, vozomé-zømās.” ");
INSERT INTO kvg_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Yaq ndigu u-anim, manqa o-mba mbøendapém, av enzol ezoqam gezømbe-ein. Yaq qanaqanus, khøuwa gendo-eqan, ndigu Mbumbukiam-qá khoev-té ginøzáv, ezoqa vømē-zømesim. Ta khøuwa iz kopo-te ndøgo, ndego Mbumbukiam-ge iziz ezoqam kandambaqape neka tegi paev ezoqam, Zu megetapak ate gi꞉goam ndøpisám. Manqa ndǿ-ovøemém. Yaq ndigu ndimbula khoev-te, manqat ndøkhofotøvém. Ndigu Keliso-gi u-anim, bègeáv. ");
INSERT INTO kvg_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Geté ndigu sasae ezoqam, ndimbula-te gifakhaz, ndigu Keliso-gi u-anim qaseáv, mokho-te ndøugu. Yaq ndigu sègeveséz, manqat vømø̄-einim, ");
INSERT INTO kvg_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Ni ndimbula khoev-te qeimø-fakhan, mboqog qeizømetat, tokøváp. Neka ndimbula keoge ezoqam mòndo-feazotát, mboqog-te ndøgo. Geté mboqog qeimboqogimem, ezoqam mbaín, mokho-te.” ");
INSERT INTO kvg_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ndego Mbumbukiam-qa khoev vos keoge ezoqam-ge kawa neka Mbumbukiam-gi iziz ezoqa kandakanda, nqanek manqat giyogem, ndigu gò꞉bevupém, av nqægo, “Gê, ndigu gekha matēv zǿfakhan?” ");
INSERT INTO kvg_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Yaq ezoqam tendowáv ndǿgo, vøzø̄-ein, “Nqáe! Nginik ezoqam, zo ndimbula khoev-te qazo-nqeitaz, Mbumbukiam-qá khoev-té gigú. Ezoqa me꞉zømesimít.” ");
INSERT INTO kvg_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Yaq ndego vos keoge ezoqam-ge kawa neka tegi sasae ezoqam, tinøzáv ndǿgo, nginik Keliso-gi u-anim, nqawa vømøndō-upøzo. Geté ndigu tøpøtøzateáv. Zapa ndǿgo, ndigu møe ndøgoném. Soqaín ndøgo, ezoqa qaqa tizøgo, nandi vǿepōub, neka vǿpakhaēz. ");
INSERT INTO kvg_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Yaq ndigu vos keoge ezoqam, Keliso-gi u-anim, Zu megetapak-qá manqa ovøyam-té ginø-tonqozó. Yaq ndego Mbumbukiam-ge iziz ezoqam kandambaqape gezø-ein, ");
INSERT INTO kvg_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ni zo khafeap nizømbové, av nqægo, ‘Zo ezoqa Yesu-qa iz-te me꞉zømèsi᷄m.’ Geté nqáe! Zo nandav nømendim manqat, Zelusalem taon-te ate nqægo, sòzo-vøndøzém. Neka zo nī zoni-løvøyáp, ngenek ezoqam gilaem.” ");
INSERT INTO kvg_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Yaq Pita neka ndigu Keliso-gi u-anim nøme gizø-qavøiu, “Ni Mbumbukiam-qá manqat bambupáev, ambá ndø̄go, ezoqam-qa manqat. ");
INSERT INTO kvg_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nigi atanakha-zapazapa-za-ge Mbumbukiam, Yesu løvøte-té gendo-khandí꞉v, ndego zo qazolaem, tae mutui-te qazo-tøkewem. ");
INSERT INTO kvg_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yaq Mbumbukiam ndego ekezan-té genø-eqeiú, neka teqa nakeamo zenda-te vø̄ve. Yaq ndego kawa neka khandi etoam ezoqam ndǿgoát. Yaq ni Izlael ezoqam tàbizi꞉-qambún, yaq Mbumbukiam niqa manqa-zapazapa bembøē-navøem. ");
INSERT INTO kvg_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Matev ndøgo, Yesu gematønumam neka te-te vø̄fakhanumam, ni bǿi qatiqeivám. Yaq ni ezoqa niti-zømesimít. Neka até Nqova Mbomambaqapé-a, ndego Mbumbukiam ndigu tezø-etoumat, ndigu teqa manqa o-mba ndimbøe-ndape, ndego nqanek matev ate ndægo mø̀ndøqeív.” ");
INSERT INTO kvg_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ndigu iz-akhayapak, nqanek manqat giyogem, ndigu qaqa kandambá gigonem. Yaq ambá pakhapakha zøkhaneamɨ́n. ");
INSERT INTO kvg_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Geté Zu ezoqam-qa manqa ovøyam-te ndøgo, ezoqa kopo mø̀ndu꞉goám. Teqa iz, Gamaliél. Ndego Felisi ezoqám neka Mozes-qá guguna manqat nømendim ezoqám. Ezoqa vizap kandambá gimbogoam. Yaq ndego gè-itán, ndigu Keliso-gi u-anim bavokho vøkhǣ-khofotaz. ");
INSERT INTO kvg_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Yaq ndego gezø-ein, “Zo nogi ezoqam, Izlael bawan-ak. Aiyá qagó, nginik ezoqam gekha matev tozozø-matanam. ");
INSERT INTO kvg_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Zo gèmbo-mataváp. Nupøkhan mbá mbá. Tiudas ndøgoám. Ndego ekeza kha, kandambaqape me꞉veó. Ezoqa fo andléd gimbopavam. Geté ndego gilaem, yaq ndigu te namba gi꞉goam, khokhó sege-panqanimát. Yaq matavap ndøgo, qambogoam, sègembøepá. ");
INSERT INTO kvg_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Taqa zita-te, ta khøuwa-te ndøgo, gaman, ezoqam-qa iziz gindapat, ezoqá nøme ndøfakhán. Teqa iz Zudás. Gelili plovins-ák. Ndego gaman-te nakhag vø̄ngaz. Neka ezoqa kopoáv gimbopavam. Geté até ndégo-a, vø̄laem. Neka tegi paev ezoqam ate gi꞉goam, sège-panqanimát. ");
INSERT INTO kvg_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yaq nakémbá. No nginik ezoqam-qa yaq-te, āv qazømbé-ovøyám nqǽgo: Zo matev ndømatønø̀me᷄m, ti-te. Sègezø-iváv. Av tiqa sasae neka matev ezoqam-qa matavap-te mba qando-fakhanɨn, yaq segemǿ-navøém. ");
INSERT INTO kvg_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Geté, av nqanek matev Mbumbukiam-te qande-fakhan, yaq zo kopømba mbaín, nginik ezoqam tozozømbø-khaz. Soqaín ndøgo, zo Mbumbukiam namba tozo-nøfeapat.” Yaq ndigu iz-akhayapak, Gamaliel-qa manqat, gè-unimanqatiním. ");
INSERT INTO kvg_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Yaq ndigu Keliso-gi u-anim, nango gizø-akha, vøndō-oz. Yaq gèfebám, khafeap vøzømbōve, av nqægo, “Zo ezoqa Yesu-qa iz-te, nqawa me꞉zømèsi᷄m.” Yaq sège-nqonqotáz, vø̄zav. ");
INSERT INTO kvg_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Yaq Keliso-gi u-anim, nqanek Zu ezoqam-qa manqa ovøyam gi-ivøvem, ndigu khanakhanakh-ús giqavanat. Ndigu khanakhanakh-us tinigú ndǿgo, Mbumbukiam ndigu eqeieqei ge꞉zæb, Yesu zapaya mivi matev gindapem. ");
INSERT INTO kvg_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ndigu ezoqa zømesim ivøveáv. Geté khøuwa ate qæpavpavemam, Manqat Mbomambaqape me꞉zømesimám. Mbumbukiam-qa khoev-te neka ezoqam-qa khoev vinivinimba-te, ndigu āv gizømbe-ovøemám nqǽgo: Yesu, ndego Mesayá. Ezoqam ndégo, Mbumbukiam geve, ezoqa tekhandi꞉z. ");
INSERT INTO kvg_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ta khøuwa-te ndøgo, Yesu-gi paev ezoqam, bawan qazø-khouwevtat, yaq ti mokho-te ponqombap ndøfakhán, yaq Zu bawan-ak, ndigu Glik manqat vǿmanqatām-a, yaq ndigu, Iblu manqat vø̄manqatam. Ndigu Zu bawan-ak, Glik manqat gimanqatam, āv gini-einím nqǽgo, “Zo khøuwa kopoav, ngængæm lou-qa yaq-te qazozø-tøkematun, ndigu angana gizø-pakhaez, yaq nigi ngængæm tøke agé upøgimáv.” ");
INSERT INTO kvg_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Keliso-gi u-anim tuelv, nqanek manqat giyogem, yaq ndigu ezoqa ewaqape ndømøváb, Yesu gi-unimanqatintam, vøzø̄-ein, “Matev av nqægo, eqeieqeí mbá, ni Keliso-gi u-anim, Mbumbukiam-qa Manqat zømesim tei-ivøvem, yaq lou etoam matev-tē qanimbō-ngetøgeapāt. ");
INSERT INTO kvg_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yaq nakémbá, nigi nøfuap, ezoqa seven zóvevesám, zo mokho-te, ndigu zo qazøte-zøtez, kha Nqova Mbomambaqapē qazømbe-tønøyām, neka ndigu matavap loloakh ndø̄zø̄gō. Yaq ndígu tizí-áb, ezoqa lou tizø-etoumat. ");
INSERT INTO kvg_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Geté ni Keliso-gi u-anim, bazaføgakh ndǿgo teitǿ-asazát, teiguligulimat neka ezoqa Mbumbukiam-qa Manqat vøtí-zømesimāt.” ");
INSERT INTO kvg_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ezoqa ewaqape khanakhanákh, nqanek manqat-qa yaq-te. Yaq ndigu Stiven ndøveatøvém, teqa unimanqatin bazaføgakh-us qambogoam neka kha Nqova Mbomambaqape vømbø̄e-tønøyam. Ezoqa nøme givevesam, Filíp neka Plokolús neka Nikanó neka Timón neka Pamenás neka Nikolās. Nikolas, ndego Antiok taon-ak ndøgoám. Geté ndego mø̀ndømø-Zu-bawan-ak-év, yaq ndego Mbumbukiam-anim vømbō-vizupam. ");
INSERT INTO kvg_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Yaq ndigu ezoqa seven, givevesam, Keliso-gi u-anim-té ginø-upøzó. Yaq ndigu gèzø-guligulím, neka zenda vøzømbø̄-awam. ");
INSERT INTO kvg_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Mbumbukiam-qa Manqat sège-vøndavát. Yaq Yesu-gi paev ezoqam, Zelusalem taon-te ndøgo, tiqa bawan sà tønø-khouwevtát. Até Mbumbukiam-gí iziz ezoqám-a, ezoqa kopoáv, Yesu-qa manqat vø̄ndapem-a, vø̄-unimanqatinim. ");
INSERT INTO kvg_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Mbumbukiam Stiven gèmbo-tøkeám neka bazaføgakh vømbō-etoumam. Yaq Stiven, ezoqa mokho-te, umingiap matev kandakanda ndømatønumám. ");
INSERT INTO kvg_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Geté ezoqa nøme, ndigu Zu ezoqam-qa guliguli khoev-te gimøvøbumam, ndøgo Nqovotøzat Ezoqam-qa Guliguli Khoev gimbo-akhaemam, ndigu Stiven namba, ponqombap ndøngazém. Nøme ndigu Sailini taon-ák neka nøme Aleksandlia taon-ák neka nøme Silisia manqei-ák neka nøme Esia manqei-ák. ");
INSERT INTO kvg_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Geté Mbumbukiam-ge Nqova Mbomambaqape, Stiven matavap loloakh mbo-etoám. Yaq ndigu kopømba mbaín, teqa manqat tiløvumem. ");
INSERT INTO kvg_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Yaq ndigu khonoam-te, ezoqa nøme tìnø-nøzøzó ndǿgo, gizø-ein, “Zo ezoqa nøme, meakha manqat zómanqatát, av nqægo, ‘Ngenek ezoqam, Mozes-qá neka Mbumbukiam-qá iz ndøngi꞉tatún. Ni mø̀imbo-yogém, manqat av ge꞉manqatam.’” ");
INSERT INTO kvg_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Yaq ta matev mokho-te ndøgo, ndigu ezoqa nøme neka megetapak neka Mozes-qa guguna manqat nømendim ezoqam, qaqa zøløwáz, Stiven-qa yaq-te. Yaq ndigu até gindigonem, Stiven vø̄-møvøinam, Zu megetapak-qa manqa ovøyam-te sasa ndøndafem. ");
INSERT INTO kvg_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Yaq ndigu, ezoqa nøme, khavozam nonqo ndøtonqozó. Yaq ndigu āv gini-einím nqǽgo, “Ngenek ezoqam, Mbumbukiam-qa khoev neka Mozes-qa guguna manqat-qa yaq-te, manqat soqøsoqa oskia ndømanqatatún. ");
INSERT INTO kvg_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ni ngenek āv qeimbøe-yogém nqǽgo, ‘Ngenek Yesu, Nazalet vemiav-ak, Mbumbukiam-qa khoev géngiú neka niqa matev ate ndægo vǿ-enēnd, Mozes nigi atanakha-zapazapa-za gezø-etoam, yaq ni vizimø̄-ndapem.’” ");
INSERT INTO kvg_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Yaq Zu megetapak ate gi꞉goam, manqa ovøyam-te giqonavam, Stiven-te bøi é-møndøzømbo-føgákh. Yaq bugug gimbo-qeivim, ndøgo waev ùnime꞉-papaqá. Andé enzol ezoqam-qá bugug me me꞉kewagám. ");
INSERT INTO kvg_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Yaq ndego Mbumbukiam-ge iziz ezoqam kandambaqape, Stiven gembobevap, “Gê, manqat ndøgo, ngiqa-møvøet, unimanqatîn?” ");
INSERT INTO kvg_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Yaq Stiven gezø-qavøiu, “Tát-za neka ata-za! Zøtøndé-yogēm. Nigi atanakha-zapa Eibleem, Elan taon-te yageav qagoam, gete Mesopotemia manqei-te zua gegoam, yaq ndego Mbumbukiam Iz-akhae-qape mbofakhán, ");
INSERT INTO kvg_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","vømbō-ein, ‘Qoqa manqei neka qakeza ezoqa vø̀zuváz. Yaq manqei ndǿgo toqonǿqáv, ma no tøteqamakh.’ ");
INSERT INTO kvg_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Yaq Eibleem ekeza manqei, ndøgo iz nøme Kalde manqei gimbo-akhaemam, sège-iváv. Yaq Elan taon-té genøwáv, vømø̄qom. Yaq tege eve genanim, Mbumbukiam ndego nqánek gendo-khofotáv, zo ndakin nqazoyage. ");
INSERT INTO kvg_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Geté Mbumbukiam Eibleem-te, manqei-qase etopøteáv. Mbaín! Geté ndego manqa mbusa mbové, av nqægo, manqei ndø̀mbo-etoām, ndego neka tegi zi. Ta khøuwa-te ndøgo, Mbumbukiam manqa mbusa geve, Eibleem nakhasam fakhaneav mbogoám. Zuá. ");
INSERT INTO kvg_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Mbumbukiam Eibleem āv gembøe-eín nqǽgo, ‘Qogi qazi manqei nøme-té géyagát. Ta manqei-te ndøgo, ndigu mo-manqei-aním mbá. Yaq ndigu yaq-fia mbain sasae ezoqam ndǿgoát. Ezoqa ndigu géngenøzotát. Viav kandambá. Até tægoat, viav fo andléd. ");
INSERT INTO kvg_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Geté no ndigu bawan ezoqam, ndigu yaq-fia mbain sasae-te titøpøtavat, yaq-fia nqosøgeap nøzǿ-etoám. Yaq taqa zita-te, qogi qazi gendó-fakház, ta manqei-te ndøgo ti꞉sokhoat. Yaq noqa iz nqánek gí-eqatát.’ ");
INSERT INTO kvg_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Yaq Mbumbukiam, Eibleem namba, poev ndø-unimanqatín, neka ngusu qogøzat matev vømbō-etoam. Yaq tege yo Aezek geqan, ta khøuwa-te ndøgo, ndego khøuwa eit qamømbo-ndap, Eibleem ngusum mbokepøtáz. Yaq ndego Aezek, matev até kopó, tege yo Zekop, ngusum vømbōkepøtaz. Yaq até Zekóp-a, tegi nakhei angana tuelv, ngusu vøzø̄qogaz, ndigu nigi atanakha-zapazapa-za kandakanda. ");
INSERT INTO kvg_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ndigu atanakha-zapazapa-za, tigi eveqase-te Zosef, ova ndø-einím. Yaq ndego gèwiím. Yaq ndigu ezoqam, ma gi꞉wiim, Izip manqei-té ginø-ituím, ndego yaq-fia mbain sasae ezoqam vø̄veem. Geté Mbumbukiam até gegoám, te namba, ");
INSERT INTO kvg_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","neka teqa yage føgakh-te vø̄khandi꞉v. Yaq Zosef Felo-qa megemege-te go꞉-itan, ndego Izip manqei-ak-ge kawa, Mbumbukiam matavap loloakh mbo-etoám. Yaq Felo, até gendego, Zosef vesøteve iz vømbō-akha. Yaq Izip manqei ate qægoam neka kawa-qa khoev ate qægoam, ndégo tembo-kewagám. ");
INSERT INTO kvg_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Yaq Izip neka Keinan manqei ate qægoam, vikia sekeqape ndømát. Yage føgakh kandambá. Nigi atanakha-zapazapa-za, lou mbaín. Gèzø-navøém. ");
INSERT INTO kvg_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yaq Zekop ge-ewag, av nqægo, Izip manqei-te, lou zua ndøgō, yaq ndego ekeza nakheis, nigi atanakha-zapazapa-za, andé tene-khofotáz, ndøgo Izip manqei-te. ");
INSERT INTO kvg_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Yaq khøuwa nøme nqawa ginduzav, Zosef ekeza zapikia-za tènezømás, av nqægo, ‘No zogé zøveqasé.’ Ndakin Felo mø̀ndæ-otév, Zosef-gi namba-qaniap ngínik. ");
INSERT INTO kvg_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yaq Zosef eve-te Zekop, manqat ndøkhofotáv, av nqægo: Ndego ekeza ezoqam namba, Izip manqei-té giabetøndozáv. Ndigu ezoqa ate gi꞉goam seventi-fáev. ");
INSERT INTO kvg_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yaq Zekop Izip manqei-té genøwáv, ekeza ezoqa namba. Yaq ndǿgo teyagám, atema vø̄nanim. Neka até ndigú-a, tegi nakhei angana, nigi atanakha-zapazapa-za, ndǿgo tiyagám, atema vumū-pakhaez. ");
INSERT INTO kvg_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ndigu gipakhaetat, yaq tiqa kha Sekem manqei-té ginø-tonqogimám. Yaq ndǿgo, tinø-osumám, ta manqei ozu-te ndøgo, ibugukhokhof Hamo-gi nakheis-qa manqei ozu qagoam, yaq Eibleem vø̄wi. ");
INSERT INTO kvg_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Khøuwa qækhatoat, Mbumbukiam ekeza manqat te-unimanqatin, av ibugukhokhof Eibleem-te manqa mbusa ge꞉ve, ndigu bawan kandambá qazø-khouwev, Izip manqei-te ndøgo. ");
INSERT INTO kvg_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Geté ndego kawa ezoqam ndakinak, Izip manqei gembo-kewagam, ndego Zosef-qa yaq-te otevateáv. ");
INSERT INTO kvg_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Yaq ngenek kawa ezoqam, nigi atanakha-zapazapa-za gèzømbe-khavozumám neka ngenøgim matev vøzø̄-matønumam. Ndego āv gene-vøovám nqǽgo: Tigi nakhei ndakinak qaniap, bavokhó giabeto-abupít. Yaq ndigu tìabiti-pakhaetét. ");
INSERT INTO kvg_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ta khøuwa-te ndøgo, Mozes tèneqán. Mbumbukiam poev kandambá te-te. Ndego geqan, yaq bugukhokhof evøndipakha-qá khoev-té gunugoám, neka vømbō-kewagam. Løvøyak misiká. ");
INSERT INTO kvg_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Geté bavokho gimø-ivøvem, av Felo manqa ge꞉vøovam, ndego Izip ezoqam-ge kawa, yaq kawa-gú yu ndø-omét. Yaq ndugu gè-anqó, neka kopømba ande av ekeza nakhasam nde꞉go vø̄-okef. ");
INSERT INTO kvg_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Yaq ndigu Mozes, Izip ezoqam-qá matavap loloakh me꞉-ometimám, ate qægoam. Yaq ndego otevat kandambá. Manqa manqate nekā sasae gone-qa yaq-te. ");
INSERT INTO kvg_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Yaq Mozes viav foti qamømbo-ndap, yaq ndego okha ndøwáv, ti-te ndigu, Izlael ezoqam, tegi ekeza ezoqam. ");
INSERT INTO kvg_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Yaq ndego tekewág ndǿgo, Izip ezoqam, Izlael ezoqam ndøfeumát. Yaq Mozes até gendego, vømbōtøke, Izip ezoqam pakhapakha vømbō-khana. ");
INSERT INTO kvg_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mozes āv gene-matavupám nqǽgo: Ekeza ezoqam àbe-matøvemém, av nqægo, ndego Mbumbukiam ndokhofotāv, ndigu vǿe-khandī꞉z. Geté ndigu matavapøteáv. ");
INSERT INTO kvg_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Yaq khøuwa nøme qandopave, Mozes Izlael ezoqa menas ndøzømét, ginøfeat. Yaq ndego ndigu nqawa tøkuzuat-qa ndøgoám, gezø-ein, ‘Nqáe! Zo bawan kopó. Zo gekha zapâ, nqazo-nøfeet?’ ");
INSERT INTO kvg_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Geté ndego, ma nøfe gendengaz, Mozes gènqontáv, vømbō-ein, ‘Ge qô, gekha ezoqām ndǿveataq, nigi kawa neka manqa ovøyam megeat ezoqam toqogoat? ");
INSERT INTO kvg_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Gê, qo até nó-a, løvømbe-qa qógo, av nømøkhaiya Izip ezoqam qotelavao?’ ");
INSERT INTO kvg_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mozes nqanek manqat ge-ewag, yaq ndego gèkhokhón, Midian manqei-te vømø̄qom. Ta manqei-te ndøgo, ndego mo-manqei-aním mbá. Yaq geyagam ndøgo, nakhei angana menás gimbo-fakhaz. ");
INSERT INTO kvg_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Yaq viav foti nøme qame-navøem, leg-av manqei-te, Sainai olol avønin-te, enzol ezoqam mbofakhán. Tae-qase wageap-us mokho-té genømbo-fakhán. ");
INSERT INTO kvg_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mozes nqanek matev geqeiv, ndego nqova ndafe kandambá. Yaq avønin-te gewav, matev uni qeivi-qa gegoam, ndego Evezøza-qá manqa wag ndø-ewág. Ndøgo āv qane-eín nqǽgo, ");
INSERT INTO kvg_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘No qogi atanakha-zapazapa-za-gé Mbumbukiám, ndigu Eibleem neka Aezek neka Zekop.’ Mozes kha wageap kandambá, nqanek manqat ge-ewag. Yaq ndego møe ndøgó, vǿekewāg. ");
INSERT INTO kvg_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Yaq Mbumbukiam gembo-ein, ‘Qoqa tamak vø̀khofoé. Zapa ndǿgo, nqanek manqei, ma nqoqote-ya, khakheitáp. Noqá. ");
INSERT INTO kvg_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","No matev soqøsoqa, Izip ezoqam nogi ezoqam ndizø-matanam, mø̀eqeív. Neka tiqa fumugap, mø̀e-ewág. No ndǿgo tøtøndevís, no ndigu nónqovotáz. Yaq nakémbá, mòqoqáv. No nqawa Izip manqei-té qatǿ-khofotáq.’ ");
INSERT INTO kvg_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ngenek Mozes, ndégo, ibugukhokhof Zu ezoqam gisanqawem, gimbo-einim, ‘Ge qô, gekha ezoqām ndǿveataq, nigi kawa neka manqa ovøyam megeat ezoqam toqogoat?’ Geté ndego Mbumbukiam ndokhofotáv, ezoqa tezømbo-megetet neka vǿnqovotāz. Nqanek sasae, enzol ezoqam mokho-té genømbo-etoám, ndego tae-qase wageap-us mokho-te gembo-fakhan. ");
INSERT INTO kvg_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Yaq ndigu Izlael ezoqam, ndégo tezømbo-m