﻿USE sofia;
DROP TABLE IF EXISTS sofia.kux_vpl;
CREATE TABLE kux_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kux_vpl WRITE;
INSERT INTO kux_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Nyukurnikaparri Mamalu-pulanya yalkiri kamu parna palyarnu. ");
INSERT INTO kux_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Nyukurni katji parna wiya yuti ngarangu wurrakili. Tjitja kalyu tjarluminyirri parnangka kankarrawana ngarrirra parrayurrima. Munga tjarlulu tjutunma. Mamakurnu kurrurnpa kankarrawana kalyungka parrayurrima mayarnyuru. ");
INSERT INTO kux_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Tjiitjanu Mamalu watjarnu, “Tilirriwa.” Mularrpalpi tilirringu. ");
INSERT INTO kux_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","5","Katji palurulu nyangu watjarnu, “Yuwayi, palyaminyirri ngarinpa.” Mamalu tili tjiitja yini yungu-ra “Karrpu.” Tjiitjanu partukanu-pulanya karrpu kamu munga partumparra ngarakuwa. Mamalu munga yini watjarnu “Munga.” Yulyultjarrarringu kamu karrpu kutjungkalpi wiyarringu. ");
INSERT INTO kux_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Kalyulu parna tjuturnu kanyinma. Mamalu watjarnu, “Kurtungka yalkiri tjarlurri miku kalyu partungka-partungka ngarakuwa.” Mularrpakili ngarangu. ");
INSERT INTO kux_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Kalyu kalkinpa pakarnu kankarra ngarama. Kamu kalyu kalkinpa parna kutjuwarrawana ngarrima. Mamalu watjarnu tjilanyatuka partumparra ngaramalpa. ");
INSERT INTO kux_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Tjiitjanu yungu-ra yini “Yalkiri.” Yulyultjarrarringu kamu karrpu kutjarrangkalpi wiyarringu. ");
INSERT INTO kux_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Mamalu watjarnu kalyu kaninytjarra yankuwa miku parna yutilpi ngaramalpa. Parna mularrpalpi yutirringu. ");
INSERT INTO kux_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kamu Mamalu yini yungu-ra “Parna.”Tjiitjanu Mamalu kalyuku yinilpi yungu-ra “Kalyu tjarluminyirri”. Palurulu parra nyangu ngurrkurringu. ");
INSERT INTO kux_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Mamalu watjarnu mangkalpa kutjuwara lukararrakurlu pakalkuwa, kamu warta kalkinpa mangarrikurlu pakalkuwa. ");
INSERT INTO kux_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Mularrpalpi pakarnu ngarama-ya. Mamalu parra nyangu ngurrkurringu watjarnu, “Palya.” ");
INSERT INTO kux_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Yulyultjarrarringu kamu karrpu marnkurrtalpi wiyarringu. ");
INSERT INTO kux_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Mamalu watjarnu tjirntu yakanpa kamu wilpa yutirrikuwa. Mularrpakili yutirringu ngarama-ya. Mamalu watjarnu tjirntu pakalku raayanku maa tjarrpaku mungarriku. Yakanpalpi mungangka raayanku maa tjarrpaku. Miku puntulu laltulu tjirntu yakanpa kamu wilpa nyangamalpa-ya. Tjiitjanu nintilu tjungarnilu watjanmalpa yaltapuru mayarnpuru yalipuru. ");
INSERT INTO kux_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","18","Mamalu-pulanya tili tjarlu kutjarra palyarnu, tjirntu kamu yakanpa. Wilpa lurrtju palyarnu wantingu. Tjirntu tjunu karrpungka raayanku maa tjarrpaku mungarrikulpi. Yakanpalpi tjunu mungangka raayanku. Mamalu parra nyangu watjarnu, “Yuwayi tjilanyartuka palya ngarinpa.” ");
INSERT INTO kux_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Yulyultjarrarringu kamu karrpu muntungkalpi wiyarringu. ");
INSERT INTO kux_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Mamalu watjarnu yawu kutjuwarra kalyungka yutirrikuwa miku-ya parra lalturrikuwa kalyungka. Tjiitjanu Mamalu watjarnu turru kutjuwarralpi yalkiringka yutirrikuwa parra paarrpakanmalpa-ya, tjarlu-tjarlu kamu tjukurn-tjukurnpa. Mularrpakili yutirringu yalkiriwana parra-ya paarrpakanma. ");
INSERT INTO kux_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Tjilanyartuka yawu kutjuwarra tjarlu-tjarlu kamu tjukurn-tjukurnpa lurrtju palyarnu. Tjiitjanu turru kutjuwarra palyarnu yalkiriwana parra-ya paarrpakanmalpa. Tjiitjanu palurulu parra nyangu ngurrkurringu watjarnu, “Palyaminyirri.” ");
INSERT INTO kux_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Tjiitjanu palurulu-tjananya yawuku kamu turruku wangka palyaminyirri watjarnu. Palurulu watjarnu-tjananya, “Wulu nyurra laltumanamalpa.” Mularrpakili-ya wulu maa lalturrima. ");
INSERT INTO kux_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Yulyultjarrarringu karrpu rakangkalpi wiyarringu. ");
INSERT INTO kux_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","25","Mamalu watjarnu yanumalpa kutjuwarra parnangka-ya yutirrikuwa. Mularrpalpi yutilpi-ya ngarangu. Kalkinpa kuka, kalkinpa kuka wiya, kalkinpa parra-ya wayinma parnawana. Mamalu yanumalpa kutjuwarra palyarnu. Mularrpalpi palurulu parra nyangu watjarnu, “Palyaminyirri.” ");
INSERT INTO kux_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Mamalu watjarnu, “Kuwarri ngayantula puntu palyalku ngayanyuru. Miku-tjananyaya kutjuwarra ngampurrtu kanyinmalpa, yawu turru kamu yanumalpa kutjuwarra kuka kamu kalkinpa-ya kuka wiya kamu parra wayinmalpa parnawana.” ");
INSERT INTO kux_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Tjiitjanu Mamalu-pulanya yarnangu palyarnu puntu kamu tutju. Yuwayi mularrpakili palyarnu-pulanya paluruyuru. ");
INSERT INTO kux_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Tjiitjanu palurulu-pulanya wangka palya watjarnu, “Nyuntu kutjarralu nyupararalu wulu-tjananyan tjitji maa laltumanamalpa ngawitji, kamu kumpurru nyinakuwa-ya parnangka. Miku-tjananyaya yawu, turru yanumalpa lurrtju ngampurrmanamalpa.” ");
INSERT INTO kux_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Mama wangkangu, “Kulila, ngayulurna nyurrampa mangkalpa lurrkarrarakulu kutjuwarra warta kutjuwarra mangarrikulu tjunu miku nyurra ngalamalpa. ");
INSERT INTO kux_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Kamu-rna mangkalpa kamu warta yukirikulu tjunu yanumalpa-ya kutjuwarralu kamu turrulu mangarri ngalamalpa.” Yuwayi nyamu. Mama wangkangu tjilanyartuka ngaramalpa. ");
INSERT INTO kux_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Mamalu kutjuwarra parra nyangu watjarnulpi, “Yuwayi kutjuwarra palyatuka ngarinpa.” Yulyultjarrarringu kamu karrpu kalyungkalpi wiyarringu. ");
INSERT INTO kux_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Mamalu parna kamu yalkiri-pulanya palyarnu wiyarnu. Kamu kutjuwarra parnangka kamu yalkiringka-tjananya palyarnu wiyarnu. ");
INSERT INTO kux_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Karrpu wilkingkalpi paluru warakparni nyinama. ");
INSERT INTO kux_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Tjiitjanu wangkangu karrpu kutjungka tarruku wulu warakparni ngaramalpa. Puntu laltulpi warakparnilpi nyinamalpa Mama-ya kulinmalpa. Palurulumarntu kutjuwarra palyarnu wiyarnu karrpungka wilkingkalpi warakparni nyinama, tjilanyartuka. ");
INSERT INTO kux_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ngaatja tjukurrpa Mamalu yalkiri kamu parna-pulanya palyarnu. Mamalu parna kamu yalkiri palyarnu wantingu. ");
INSERT INTO kux_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Mangkalpa mangarrikulu kamu warta tjukuny-tjukunypa wiya-ya pakarnu wurrakili. Mamalu wiya kalyu kankaratjanulu yiyarnu tjilanyartuka. Puntu kutjupa wiya nyinama parna tjawalkuwa. ");
INSERT INTO kux_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Kalyu parnatjanu pakanma. Kamu parna kalyukulu ngarrima. ");
INSERT INTO kux_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ngaatja Mamalu parna manulpi puntu palyarnu ngarritjunu. Tjiitjanu puntungka-lu mulyawana puyurnu. Puntu kanarringulpi nyinama. ");
INSERT INTO kux_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Mamalu kaatanpa palyarnu kakarrawaku ngurra yini Yiitinta. Palurulu puntu nyinatjunu wantingu. ");
INSERT INTO kux_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Palurulu-tjananya warta palyaminyirri laltu mangarrikulu kutjuwarra pakaltjunu. Ngatja warta kutjarra-pula kurtungkaminyirri ngarama. Warta kutjupa ngarama katji puntulu kutjupalu ngalaku kana wulu nyinamalpa. Tjiitja warta kutjupa ngarama katji puntu kutjupalu ngalaku yirrulpa tirrinyanku nintipuka nyinamalpa. ");
INSERT INTO kux_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Tjiingka ngurra Yiitintjanu kalyu tjarlu parntinyanu warta kamu yukiri kanalpi-tjananya kanyinma. Tjiitjanu kiliki kutjutjanu lipirringu munturringu ngarama. ");
INSERT INTO kux_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Kiliki kutju yini Piitjanpa maa parntinyanu ngurra yini Yapilalawana. ");
INSERT INTO kux_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Ngurra tjiingka pamarrpa kawurlkurlu manama-ya. Tjiingka warta lurrtju parnti-parntikulu palya ngarama. ");
INSERT INTO kux_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Kiliki kutjupa yini Kiyanpa maa parntinyanu ngurra kutjupawana yini Kuutjulawana. ");
INSERT INTO kux_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Kiliki kutjupa yini Tayikuri maa parntinyanu ngurra Yatjiriyala kakarrawana. Kiliki kutjupa yini Purayiti. ");
INSERT INTO kux_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Mamalu puntu paluru katingu kaatanta nyinatjunu watjarnu ngampurrtu kanyilkuwa. Kamu parna tjawanmalpa mangarri parltjaku pakaltjunkuwa. ");
INSERT INTO kux_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Mamalu watjarnu, “Yuwayi, palyan warta mangarrikulu kutjuwarra ngalamalpa. ");
INSERT INTO kux_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Warta kutjupa ngarinpa katjin ngalaku yirrulpan tirrinyanku nintipukan nyinamalpa. Warta tjiitja tarrukuminyirri ngarinpa. Wiyan ngalaku. Katjin ngalaku mirrirrikun.” ");
INSERT INTO kux_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Mamalu watjarnu, “Kulu puntu ngatja kutju marlpaparni nyinamalpa? Wiya, ngayulurnara marlpa palyalku puntutjunkuwa.” ");
INSERT INTO kux_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Mamalu parna manulpi kuka-tjananya kamu turru laltu palyarnu. Mamalu-tjananya puntukutu katingu ngaratjunu miku-tjananya yini yungkuwa. Puntulu yini-tjananya kutjupa-kutjupa yungu. Palurulu purtu kulirnu, “Marlpa wiya-tjuya ngaanpa.” ");
INSERT INTO kux_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Mamalu puntu nyalitjunu. Nyali tjarlulpi ngarrima. Tjiitjanu Mamalu kantilypa-lu kutju manulpi kamu yawarralpi marlakulu tjuturnu. ");
INSERT INTO kux_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Tjiitjanu palurulu kantilypa manu tutjulpi palyarnu. Mamalu tutjulpi ngalya katingu-lu puntukutu. ");
INSERT INTO kux_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Katji puntulu tutju nyangulpi palurulu watjarnu, “Yuwayi, ngayuyuru palyarnu, Kitji kamu puyatju ngayukurnutjanu manu tutjulpi palyarnu. Kamu-rna yinilpi yungku tutju.” ");
INSERT INTO kux_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Yuwayi, tjiitjanu puntulungku mama kamu yipi wantirra yanku nyupakutu. Kutjungkarriku-pula nyinamalpa. Kutjarratjanu-pula kutjungkalpi nyinamalpa. ");
INSERT INTO kux_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Puntu kamu tutju-pula wirti nyinama tjantuparni. Wiya-pula kurntarringu. ");
INSERT INTO kux_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Mamalu kuka laltu palyarnu. Lingkakutju nintipuka kuka laltungka-tjananya wayinta nyinangu. Paluru warinykatingu-lu tutjungka kamu tjapirnu, “Kulu Mamaluntapula watjarnu wiya-pulan mangarri warta kutjuwarratjanu ngalaku wantiku-pulan?” ");
INSERT INTO kux_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Tutjulu watjarnu, “Wiya, nyamu-litju mangarri warta kutjuwarratjanu ngalamalpa. ");
INSERT INTO kux_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Kurtungka warta kutju tarruku tjarlu ngarinpa. Mamalu watjarnu, ‘Wiya-pulan mangarri warta tjiitjanu ngalaku. Wiya-pulan pampulku. Wanti-pula mirringkamarra.’” ");
INSERT INTO kux_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Lingkalu watjarnu, “Wiya-pulan mirrirriku. ");
INSERT INTO kux_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Mama-ra ninti ngalaku-pulan nintiminyirri Mamayuru nyinamalpa.” ");
INSERT INTO kux_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Tutjulu warta nyangu kamu kulirnu, “Yuwayi mularrpa mangarri palyaminyirri ngarinpa. Tjinguru-rna ngalaku nintipuka-rna nyinamalpa.” Mularrpakili tutjulu mangarri manu ngalangu. Tjiitjanu yungulpi-ra palurukurnu nyupaku. Mularrpakili puntulu manu ngalangu. ");
INSERT INTO kux_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Tjiitjanu-pula yiirulpalpi tirrinyanu kamu nyangungku-pula wirtilpi ngarama. Nyarlpi-pula wartatjanu manu kamu nyakangku-pula palyarnu wakarnu. Karrpirnungku-pula tjuturnu nyinama. ");
INSERT INTO kux_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Tjiitjanu tjirntu kaninytjarrarringu. Palurulu-pula kulirnu Mama katji kaatanwana parra yanama. Ngurlurringu-pula taputjunu wartangka yaka yanu nyinama. ");
INSERT INTO kux_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Mamalu puntu tjapirnu, “Tjartupan yanu?” ");
INSERT INTO kux_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Puntulu tjangkupungu, “Wiya, kulirnu-rnanta tjiitjaltan kaatanwana parra yaninpa. Ngurlu-rna yaka yaninpa. Ngayu-rna wirtilpi nyininpa.” ");
INSERT INTO kux_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Mamalu tjapirnu, “Nganalunta watjarnu tjiitjaltan wirti nyininpa? Kulun nyuntulun ngalangu mangarri warta tarrukutjanu?” ");
INSERT INTO kux_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Wangkangu paluru, “Wiya, tutju-rnin nyuntulumarntu yungu, palurulu-rni manu yungu. Mularrpakili-rna ngalangu.” ");
INSERT INTO kux_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Mamalu tutjulpi tjapirnu, “Nganatjanun tjilanyarringu?” Paluru wangkangu, “Wiya, lingkalu-rni tirrutjunu. Mularrpakili-rna ngalangu.” ");
INSERT INTO kux_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Mama wangkangu lingkangka, “Yuwayi, nyuntu-rnanta purtalku tutjun nyuntulu tirrutjunu. Tjiitjanu nyuntukungku ngawu wulukili ngaramalpa. Palya-tjanampa kuka kalkinku ngaramalpa. Tjiitjanu nyuntun tjuningka parra wayinmalpa kamu parnan ngalamalpa. ");
INSERT INTO kux_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nyuntu kamu tutju-pulan wulu mingarrtji nyinamalpa. Nyuntukurnu kilaki kamu tutjukurnu kilaki mingarrtji wulu nyinamalpa. Tjiitjanu kutjulu katanta nyuntukurnu kantulku. Nyuntulun palurukurnu tjina tarrkan patjalku. ” ");
INSERT INTO kux_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Mamalu tutjulpi watjarnu, “Nyuntun munta nyinaku marnmarlpan tjarlu kanyilku. Tjitjin yutilkitja marnmarlpan tjarlu kanyilku. Nyuntu-ran nyupaku mikunytju nyinamalpa. Nyuntukurnu nyupalunta wulu tjarlulu kanyinmalpa.” ");
INSERT INTO kux_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","18","Mama puntungkalpi wangkangu-lu, “Nyuntulun nyupangkun kulirnu mangarri tjiitjaltan tarrukun ngalangu. Tjiitjanungka parna-rnanku marrkamanku kamu ngawulku. Tjilka-tjilka laltu pakalmanpa-ya. Tjiitjanu nyuntulun warakpa tjarlu palyanmalpa mangarrilpin parltjaku pakaltjunku ngalkuwanpan. ");
INSERT INTO kux_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kanalukaparrin warakpa tjarlu palyanmalpa kamu palti-paltirrikun mangarri parltjaku ngalamalpa. Tjiitja-rnanta ngayulu parnatjanu palyarnu. Katjin mirrirriku marlakun parnarriku.” ");
INSERT INTO kux_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Yatamtu palurukurnu nyupaku yini-ra yungu Yiipi, tjiitja paluru kutjuwarraku kaparli nyinaku. ");
INSERT INTO kux_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Mamalu kukakurnu puya manu tjantu-pulampa palyarnu yungu. Kamu yirrpirnungku-pula kanyinma. ");
INSERT INTO kux_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Mama wangkangu, “Ngayuyururringu-pula yiirulpa tirrinypalpi nintipuka nyininpa. Yiyalku-rnapulanya miku wiya-pula warta kutjupatjanu ngalaku kana-pula wulu nyinatjakumarra.” ");
INSERT INTO kux_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Mularrpakili-pulanya yiyarnu kaatanpa yini Yiitantjanu. Pakarnu-pula yanu. Puntulu parna tjawanmalpa mangarri pakaltjunkuwa. Mamalu nyukurnikaparri puntu parnatjanu palyarnu. Puntulu parna tjawanmalpa mangarriku. ");
INSERT INTO kux_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Mamalu pinkilykulu laltu-tjananya tjunu Yiitanta kakarrarawaku kaatanpa-ya yangatjunkuwa-ya. Mamalu tjula tawarra warukulu murrutjunu parra yurri-yurrirra yangatjunkuwa marlaku-pula tjarrpatjakumarra. Mularrpakili yangatjunu-ya warta kana kanyilpayi-pula pampultjakumarra. ");
INSERT INTO kux_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Yatampa kamu nyupararra-pula ngarringu. Kamu tutjulpi muntarringu katja kutjulpi kanyirnu. Paluru wangkangu, “Mamalu-rni puntutjunu katjalpi-rna kanyirnu.” Yinilpi-ra yungu Kayinpa. ");
INSERT INTO kux_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Tjiitjanu nyinangu katja kutjupalpi kanyirnu yini yungu-ra Yayipulpa. Paluru tjarlurringu kukunytja-tjananya ngampurrtu kanyinma. Kamu Kayintu parna tjawanma mangarri pakaltjunkuwa. ");
INSERT INTO kux_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Palurulu mangarri manu katingu inytjanu-ra Mamaku yungu. ");
INSERT INTO kux_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Kamu kutjupalu Yayipultu kukunytja kulyarri kurranyutjanu manu pungu kuka karnpikulu inytjanu-ra Mamaku yungu. Mama-ra Yayipulku ngurrkurringu. ");
INSERT INTO kux_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Katji Mamalu Kayinkura mangarri nyangu wiya-ra ngurrkurringu mingarrtjunu. Kayinpa wirrilyirringu kamu mirrparrpa kutjuparringu. ");
INSERT INTO kux_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Mamalu tjapirnu, “Kayin, pantan nganatjanun wirrilyirringu? Nganatjanun mirrparrpa kutjuparringu? ");
INSERT INTO kux_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Katjin palya palyanmara nyuntun ngurrku nyinamara. Nyuntulun ngawu palyarnu. Kutjupalu kukurryurulunta nyanginpa. Katjinta warinykatiku muunpungkunta ngawulkuwa. Wiya-lun kulilku.” ");
INSERT INTO kux_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kayintu palurukurnu marlanypaku yarltingu-ra kamu wangkangu, “Wurnali yarra puutjakarti.” Mularrpa-pula wurnarringu. Kamu tjiingkalpi Kayintu Yayipulpa pungu mirrirntanu. ");
INSERT INTO kux_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Mamalu Kayinpa tjapirnu, “Tjartungku marlanypa?” Palurulu watjarnu, “Wiya, ngurrpa-rnara! Kurlu-rna ngayulu ngampurrmanku?” ");
INSERT INTO kux_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Mama wangkangu, “Nyuntun ngawurringu. Marlanypangkun pungu mirrirntanu. Palurukurnu yirlku parnangka yulinpa-rni ngayu-rni tjapirninpa ngaparrtjilu-rnanta pungkuwa. ");
INSERT INTO kux_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ngayulu-rnanta putalku. Kamun parna tjawalku purtun mangarri parltjaku pakaltjunku. Nyuntulungkun marlanypa pungu mirrirntanu paluruku-ra yirlku parnangka ngarrinpa. Tjiitjanulpi parnalpi-rnangku putalku ");
INSERT INTO kux_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Purtun parna palya kanyinmalpa. Mangarri purtungku pakalku. Wulun ngurraparni parran yanamalpa.” ");
INSERT INTO kux_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","14","Kayinpa wangkangu, “Wiya, marrka-tjun watjarninpa. Purtu-rna kulirninpa. Nyuntulurnin yiyarnin wantikuwa-rnanta wurna-rna parra yankuwa, ngurraparni wulu parra yankuwa. Puntu kutjupalu ngayu nyaku-rni mirri pungku.” ");
INSERT INTO kux_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Tjiitjanu Mama wangkangu, “Wiya, katjintaya pungku ngayulu-rnatjananya ngaparrtjilu puntu wilki pungku.” Mamalu murrutjunu-lu Kayinta ngalyangka puntulu nyaku-ya mirri pungkutjakumarra. ");
INSERT INTO kux_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Mularrpakili Kayintu Mama wantirralpi wurna yanu kakarra nyinama ngurra kutjupangka yini Nodtangka. ");
INSERT INTO kux_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yangka kintirringulpi ngarama ngurra kutjarratjanu turlkungka-ya nyinama kamu mangarri lalypa-ya ngalkunma. Tjiitjangkalpi-ya wumurrima kulinma-ya nyukurnitjanu ngarangu ngurra Egypta. Yangka pinkirrkululu Jew laltuku ngurra wantitjunu-tjananya katja kurranyutjanu wiya pampurnu. Yirna-yirna tjarlulu-ya kamu turlku nintipukalu-ya wangkama kulinma Tjiitju-ya yakalu ngalulku pungkuwaku mirri. ");
INSERT INTO kux_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Wangkangulpi-ya, “Wurra-la wanti! Katji-ya puntu laltu-ya turlkuku wumurriku nyinamalpa. Tjinguru-lanyaya pamarrtu yungkaltjaku.” ");
INSERT INTO kux_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Katji Tjiitju nyinama Jayimankurnungka ngurrangka kutjupa ngurrangka yini Bethanyngka. Nyukurni Jayimanpa mintirrwayitju nyinama. Tjiitjanungka Tjiitju nyinama mangarri ngalkunma. Tjilanyapuru tutjulpi-tjananya tjarrpangu Jayimankurnu ngurrangka warinykatingu-lu Tjiitjukutu. Paluru mulukunpa parntirr-parntirrkulu katingu. Pamarrpa laltukulu manu. Tutjulu yangkirrpungu yintirnu-lu wiyarnu Tjiitjukurnungka katangka. ");
INSERT INTO kux_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Katji-ya puntulu kalkintu nyangu tutjulu-lu Tjiitjungka parntirr-parntirrpa yintirnu wiyarnu. Tutjungka-luya wirrilirringu wangkangu-ya, “Nganaku tutjulu parntirr-parntirrpa yintirnu-lu Tjiitjungka? ");
INSERT INTO kux_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tutjulu-tjananya parntirr-parntirrpa yungkumara pamarrpa laltu mankumara yungkuwa-tjanampa yapunta-yapuntaku.” Tjiitjanu-ya tutjulpi lanymalu warrkinma. ");
INSERT INTO kux_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tjiitjanu Tjiitjulpi-tjananya wangkangu, “Yawi-ya wanti! Nganaku-yan warrkirninpa? Ngayungka-rni palya parntirr-parntirrpa katangka yintirnu. ");
INSERT INTO kux_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yapunta-yapunta-ya wulu nyinamalpa. Yungamalpa-tjananyaya pamarr yawiku karrpu kutjupa karrpu kutjupa. Ngayu-rnantaya wiya wulu nyinamalpa. ");
INSERT INTO kux_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tutjulu ngaalu-rni palya yintirnu ngulampa-rniya mirri pirnkingka tjarrpatjunku. ");
INSERT INTO kux_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kulila-rniya ngayu. Ngulampa katji-ya ngurra kutjuwarralu kulilku wangka palya ngayukurnu, tjukurrpa tutju ngaakulu kulira-ya wangkamalpa. ");
INSERT INTO kux_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ngulampa, wanalpayi kutju yini-ra Judas Ikariya yanu-tjananya yirna-yirna tjarlu-tjarlukutu. Wangkangu-tjananya ngulampa Tjiitju-tjanampa nintitjunku miku-ya ngalulkuwa. ");
INSERT INTO kux_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Katji-ya kulirnu ngurrkurringu-ya. Tjiitjanulpi tjangkupungu-luya pamarr laltu. Tjiitjanu Judaspa marlaku yanu yumuyurulpi-tjananya wanalpayi kalkinta wumurringu, tjiingkalpi yaka nyinama kulinma ngulampa-tjananya Tjiitju nintijunku miku-ya ngalulkuwa. ");
INSERT INTO kux_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Jewspa-ya laltu wumurringu-ya turlku tjarluku miku-ya Mangarri Lalypa ngalkuwanpa. Puntu laltu-ya ngurra kutjungka wumurringku kukunytja manku pungku paalku kunta-kuntalku-ya ngalkuwanpa-ya mungangka. Wanalpayilu tjapirnu-ya Tjiitjungka, “Tjartungka-latju mangarri kamu kuka paalku ngalkuwa-la turlkuku kulintjaku?” ");
INSERT INTO kux_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tjiitjulu-pulanya wanalpayi kutjarra yiyarnu, “Yarra-pula Jerusalemkutu. Katji-pulan tjarrpaku tjiingka nyaku-pulan puntu tjarlitjarra kalyukulu ngalya yanamalpa. Kamu-pulan wanalku ngurrakutu. ");
INSERT INTO kux_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Katji maa tjarrpaku kaninytjarra. Puntu ngurra walytja-pulan tjapilku, ‘Nintipukalu-lanyatju yiyarnu. Tjartungka-latju mangarri kamu kuka kutjalku ngalkuwa-la Tulkuku kulintjaku?’ ");
INSERT INTO kux_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kamu palurungkalpi roompalpi-pulanya kankarra tjamunpalpi nintitjunku. Paalku-pulan kuka kamu mangarri miku-la laltulu ngalkuwanpa.” ");
INSERT INTO kux_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Mularrpakili-pula wanalpayi kutjarra yanu Jerusalemkutu. Nyangu-pula yumuyurukili katji Tjiitju wangkangu. Kutjarralu-pula kuka turlkuku paarnu manu wantitjunu. ");
INSERT INTO kux_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mungangkalpi Tjiitju kamu palurukurnu wanalpayi-ya Bethanytjanu yanu Jerusalemkutu. ");
INSERT INTO kux_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yanu-ya ngurra palunyangka warinykatingu maa tjarrpangu. Katji-ya ngalkunma Tjiitju wangkangu-tjananya, “Mularrpa kutjulu-rni tirrulu yungku tjitjantanku pungkuwa-rniya mirri, ngaatja lurrtjulu-la kuwarri mangarri ngalkuninpa.” ");
INSERT INTO kux_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Katji-ya palurukurnu wanalpayilu kulirnu palunpa-ya karratarringu. Parrangku-ya tjapinma, “Kulu ngayu?” ");
INSERT INTO kux_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tjiitju wangkangu, “Kutjungka-litju mangarri tupultjuninpa. ");
INSERT INTO kux_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ngayu-rna Katja punturringulpi-rna. Kamu ngayu-rna mirrikitja nyininpa yumuyurukili-rni wakarnu tjunu mirli-mirlingka. Puntulu-rni tirrulu yungku. Ngawu minyirri-ra puntu tjiiku ngaraku. Tjinguru wiya lamparnpa yutirringkumara, palya nyinama-ra.” ");
INSERT INTO kux_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ngulampa katji-ya wulu mangarri ngalkunma. Tjiitjulu mangarri manu wangkangu-lu Mamangka yatimanu. Kamu yangkirrpungu yungu-tjananya palurukurnu wanalpayiku. Wituka wangkangu, “Ngaatja mangarri ngayukutju yarnangu. Marra-ya kutjuwarralu ngala.” ");
INSERT INTO kux_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Katji kartak wayinkulu manu kamu wituka Mama yatimanu. Tjiitjanu yungu-tjananya. Kutjun-kutjuntu-ya tjikinma. ");
INSERT INTO kux_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Palurulu-tjananya watjarnu, “Wayinpa ngaatja ngayukutju yirlku. Ngayulu mirrikitjalu-rnatju ngayukurnu yirlku yintilku puntu laltuku. Tjukurrpa kuwarritjanungka Mamalu watjarnu wulu ngaramalpa ngayulu-rnatju yirlku yintilku tjiitjanungka. ");
INSERT INTO kux_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ngayulu-rnantaya mularrtu watjarninpa, ‘Wiya-rna wituka wayinpa tjikilku. Ngulampa-rna ngayu yanku Mama Tjarlu minyirrikutu tjungarningkalpi nyinaku. Tjiingkalpi-rna wituka wayinpa tjikilku.’ “ ");
INSERT INTO kux_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Turlkulpi-raya Mamaku yinkangu. Pakarnu-ya yanu pamarrkutu yini warta olivekutu. ");
INSERT INTO kux_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tjiitju-tjanampa wangkangu “Laltulu-rniyan wantitjunku taputjunku. Yangka nyukurni puntulu kutjulu mirli-mirlingka wangka kutjupa wakarnu ngaaltji tjunu: ‘Puntulu kukunytja-tjananya ngampurrtu kanyinma, Katji-rna ngayulu-rna pungku mirri. Tjiingkalpi-ya kukunytja parra taputjunku.’ ");
INSERT INTO kux_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Katji-rna mirritjanu-rna kana pakalku kurranyu-rna yanku Kalalikutu. Tjiingkalpi-rniyan marlakatiwanalu wanalku nyaku wumurringkulpi-la.” ");
INSERT INTO kux_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Kamu Peterlu watjarnu, “Wiya-rnanta ngayulu wantitjunku. Tjingurunta-ya wanalpayi kalkintu wantitjunku. Ngayulu-rnanta wiya wantitjunku.” ");
INSERT INTO kux_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tjiitjulu watjarnu, “Peter, kulila-rni. Mungangka kuwarri ngayukutjun marnkurrta ngurrparriku-tjun. Tjiingkalpin kulilku tjuk-tjukpa kutjarrangka paarlmanku.” ");
INSERT INTO kux_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Peter marrkaminyirri wangkangu wiyatjunu, “Wiya-rna tjilanya wangkaku. Tjingurulpi-li lurrtju mirrirriku. Wiya-rnanta ngurrparriku.” Kamu wanalpayi-ya laltu tjilanyartuka wangkangu. ");
INSERT INTO kux_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tjiitju kamu palurukurnu wanalpayi-ya warrinykatingu ngurra yini Gethsamanengka. Palurulu-tjananya watjarnu, “Ngaangka-ya nyina kulyakanyila-rnitjuya. Katji-rnalu yanku Mamangka wangkaku.” ");
INSERT INTO kux_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Palurulu-tjananya Peter James kamu John yarltingu katingu. Paluruku-ra tjuni ngawurringu. ");
INSERT INTO kux_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Wangkangu-tjananya, “Ngayukutju tjuni ngawuminyirri. Ngayulu-rnatju luyurrminyirri kulirninpa mirrikitjalpi. Kana-ya nyina ngaangka. Katji-rna yanku tjiikutu” ");
INSERT INTO kux_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Tjiitju pakarnu yanu maa wartungarangu warirrkingka. Paluru wangkangu-lu Mamangka, “Nyuntulurnin watjarnu marnmalpa tjarlukululpi-rna mirrirriku. Mama, kutjupamanku-tjun kulu miku wiya-rna marnmalpa tjarlu kanyilku? Mama, nyaaltji-tjun nyuntu wangkinpa?” ");
INSERT INTO kux_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tjiitju pakarnu marlakurringu nyangulpi-tjananya wanalpayi-ya marnkurrpa kutunpa ngarrima. Wangkangu-lu Peterngka, “Simon kanarriwa. Wayu-tjun ngayuku kana nyininpa?” ");
INSERT INTO kux_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tjiitjanu watjarnu-tjananya, “Kanamarta-ya nyina. Mamangka-luya wangka. Wiya nyurra kutunpa wulu ngarrimalpa. Nyuntunpa nyurra ngarru Mamangka wangkakuwa. Panta nyurra nyalikitjarrinpa punkaninpa yumpalypa. ");
INSERT INTO kux_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tjiitjulu-tjananya palurukurnu wanalpayi wituka wantitjunu marlakulpi yanu witukalpi tjapinma Mama. ");
INSERT INTO kux_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Marlakurringu-tjananya palurukurnu wanalpayikutu. Palurunpa-ya yumpalypa wulu nyinama nyali-nyali. Tjiinpa-ya wiya kana nyinangu wulu-ya kutunpa ngarrima. Katji-ya pakarnu palurunpa-ya kurntarringu-ya. Purtu-raya kulirnu nyaalpa-ya wangkaku Tjiitjungka. ");
INSERT INTO kux_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","42","Tjiitju marlaku yanu wituka wangkangulu Mamangka wituka marlakurringu palurukurnu wanalpayikutu. Wangkangu-tjananya, “Kulu nyurra wulu kutunpa? Nyawa! Wiya nyurra kutunpa wulu ngarrimalpa. Ngayu-rna Mamakurnu Katja puntulpi-rna. Puntulu-rniya ngawulu manku winyulku katiku. Yuwayi, kuwarrikili pakala-ya wuna-la yankuwa. Nyawa. Ngaatjatuka-ya puntu ngawu warrinykatingu warrmarla laltukulu ngayu-rniya mankuwa katikuwa.” ");
INSERT INTO kux_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tjiitju wulu-tjananya wangkama. Tjiitjanu Judaspa warrinykatingu-lu. Judaspa-ra Tjiitjuku wanalpayi nyinama. Tjiintu-ya tjarlu-tjarlu turlku nintipukalu kamu yirna-yirna tjarlulu yungu-raya puntu laltu Judasku miku-ya wanalkuwa. Tjiintu-ya kanyinma tjurla tawarra kamu kuturru lanymaku. ");
INSERT INTO kux_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nyukurni Judastju-tjananya watjarnu, “ Puntu katji-rna ngayulu nyanytjulku ngalula-ya maa kati.” ");
INSERT INTO kux_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Katji-ya warrmarla-ya warrinykatingu. Judaspa-lu kintirringu ngarangu Tjiitjungka. Judaspa-lu wangkangu Tjiitjungka, “Nintipuka.” Kamu nyanytjurnu nintitjunu-tjananya puntu laltungka. ");
INSERT INTO kux_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Manu-ya ngalurnu. ");
INSERT INTO kux_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tjiitjukurnu wanalpayi kutju ngarama. Palurulu tjurla yilarnupatarnu puntu kutjuku langa kurntarnu punkatjunu. Puntu tjitja warakmayin Jewsku tjarlu-tjarluku yirna-yirnaku. ");
INSERT INTO kux_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tjiitju wangkangu-tjananya, “Nganaku nyurra yanama tjurlakulu kamu kuturrukulu mankuwa-rniyan ngayu ngalulkuwa? Wiya, ngayu-rna wiya lanymapayi. ");
INSERT INTO kux_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yungun kutjupa yungun kutjupangka-rnantaya yuti nyinama churchtja tjarlungka. Wulu-rnantaya Mamakurnu wangka watjanma. Tjiitjangkalpi-rniyan wiya ngalurnu. Yumukamu-rniya ngalula kati. Nyukurni-ya puntulu mirli-mirlingka wakarnu tjunu tjiingkalpi-rniya puntulu laltulu ngayu ngalulku katiku.” ");
INSERT INTO kux_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tjiitjukurnu wanalpayi laltu-ya ngurlu tarrputjunu. ");
INSERT INTO kux_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Kulyari kutjulu marlakartiwanalu Tjiitjungka wananma. Palurulungku pulpultjunu warntukulu. Warrmarlalu-ya purtu ngalulkitjalu warntuwiyatjulpi-ya ngalurnu. Ka maa tarrputjunu wirtilpi. ");
INSERT INTO kux_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Warrmarlalu-ya Tjiitju katingu turlku tjarluminyirrikurnu ngurrakutu. Tjiingkalpi-ya tjarlu-tjarlu kamu yirna-yirna laltu-ya kamu turlku nintipuka laltu-ya kutjungkarringu-ya nyinama wangkakitja. ");
INSERT INTO kux_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peterlu marlakartiwanalu wananma. Ka maa tjarrpangu ngurra tjarlukutu yardkutu. Paluru kutjungkarringu-tjananya warrmarlangka kamu warukinti nyinatingulpi ngarntjira nyinama. ");
INSERT INTO kux_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","56","Tjiintu tjarlu-tjarlulu parra-ya nyangama, “Nganalu-lampa watjalku wangka ngawupaka. Miku-la Tjiitju pungkuwa.” Puntulu laltulu-ya tirrulu watjanma. Wiya-ya wangka kutjumarta watjanma. ");
INSERT INTO kux_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Puntu kalkinpa-ya ngarangu tirruwana-ya wangkangu, “Ngaatja-latju puntu kulirnu wangkangu palurulu churchpa tjarlu yangkirrpungku kamu kutjupa palyalku karrpungka marnkurrta.” Nyukurni-ya puntu laltulu-ya churchpa ngaatja palyarnu. Nyarni palurulu kutjulu marlaku palyalku. Wiya, purtu. ");
INSERT INTO kux_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Puntu laltu-ya parrra watjapungama wangkama. Wiya-ya kutjumarta wangkama. ");
INSERT INTO kux_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tjarlu yirna pakarnu ngarangu wangkangu-lu Tjiitjungka, “Puntu ngaantunta-ya watjarninpa nyuntulun ngawu watjarnu. Nyuntulu-tjananyan kulirnu? Nyaalpan nyuntu wangkaku?” ");
INSERT INTO kux_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tjiitju yaka ngarama wiya wangkangu. Tjiitjanu tjarlulu yirnalu tjapirnu, “Yuwa, watjala-lanyatju. Kulun nyuntu Mama Tjarlukuran katja? Kulun Mamalu nyukurni watjarnu ngalya yiyalkitja?” ");
INSERT INTO kux_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tjiitjulu watjarnu, “Yuwayi, ngulampa-rniyan nyaku ngayu Mamakurnu Katja puntulpi-rna nyinamalpa Mama tjarlungka kinti. Nyaku-rniyan ngayu ngangkalingka warinykatiku-rna.” ");
INSERT INTO kux_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Tjiitjanu tjarlu yirna wirrilyirringu tjantungku yangkirrpungu kamu wangkangu-tjananya, “Ngaatja nyurra kulirnu? Palurulungku watjarnu Mamayuru! Nganalpi puntu-la kutjupa katimalpa wangkakuwa. Nyamu-la laltulu kulirnu. Nyaalpa-yan kulirninpa? Kulu-lampa mularrtu tjukurrpa palurulu ngawurnu?” Laltulu-ya watjarnu, “Palurulu-lampa tjukurrpa tjarluminyirri ngawurnu. Palurumarntu mirrirriku.” ");
INSERT INTO kux_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Puntu kalkintu-ya Tjiitjungka-luya miparrta tjalatjunu. Tjiitjanu-ya paniya karrpirnu miku wiya nyakuwa. Tjiitjanu laltulu-ya marumpulu Tjiitju pungama. Kamu-luya wangkama, “Watjala-lanyatju. Nganalunta pungu?” Katji-ya warrmarlalu Tjiitju ngalurnulpi ngaparrku marumpulu pungama. ");
INSERT INTO kux_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Katji Peter warukinti ngantjinma yardta kaninytjarra turlku tjarluminyirrikurnungka ngurrangka wulu nyinama. Tutjulu kutjulu warakmantu warrinykatingu-lu. ");
INSERT INTO kux_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kamu Peter nyangu nyinama. Tjiingkalpi tutjulu kintilpi nyangu wangkangu, “Yuwa, nyangu-rnanta nyuntu Tjiitjungkan Nazarethtjanungka lurrtju ngarama.” ");
INSERT INTO kux_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Peterlu wiyatjunu, “Ngurrpa-rnara paluruku. Nganakuran wangkinpa?” Katji Peter pakarnu yanu gatekutu ngarangulpi. Katji tjuk-tjukpalpi paarlmanu. ");
INSERT INTO kux_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tjiitja tutjulu warakmantu wituka nyangu Peter gateta ngarama. Kamu watjarnu-tjananya puntu laltungka, “Paluru mularrpa Tjiitjuku wanalpayi.” ");
INSERT INTO kux_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Peterlu wituka wiyatjunu. Ngulampalpi katji-ya puntu laltu ngarama wangkangulu-ya Peterngka, “Wiya, nyuntun mularrpa wanalpayi. Tjiitjamarntun Kalalitjanu.” ");
INSERT INTO kux_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kamu Peterlu watjarnu, “Puntu tjiitjan watjarninpa, ngurrpa-rnara paluruku. Mularrtu-rnanta watjarninpa. Mamalu-rni mirrirntanku katji-rna wangka mayutjunu.” ");
INSERT INTO kux_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Katji tjuk-tjukpa mayaminyirri paarlmanu. Kamu Peterlu kulirnu Tjiitjulu kurranyulpi watjarnu, “Marnkurrku-tjun ngurrparriku.” Katji Peterlu Tjiitjuku wangkalpi kulirnu kurntarringulpi kamu mayalpi yulama. ");
INSERT INTO kux_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Raakarra yirna-yirna wamumpu-ya wangkama Tjiitju-ya Payilitkutu katikuwa. Palurunpa-ya turlku tjarlu-tjarlu laltu kamu nintipuka laltu kamu yirna-yirna laltu nyinama. Tjiitjanu Tjiitjuku-raya marumpu karrpirnu katingu Payilitku yungu-raya. ");
INSERT INTO kux_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Payilitu tjapirnu, “Kulun nyuntu Tjarluminyirri Tjuwuku-tjanampa?” Tjiitju wangkangu, “Nyuntunku ngaatja wangka.” ");
INSERT INTO kux_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Yirnalu laltulu-ya Payilita tjakultjunama palurulu kutjuwarra ngawunma. Tjiitjulu-tjananya yakalu ngarala kulinma. ");
INSERT INTO kux_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Payilitpa wangkangu, “Kulun wulu yaka ngaramalpa? Ngaatjanta-ya laltulu watjarnin nyuntulun kutjuwarra ngawunma.” ");
INSERT INTO kux_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tjiitju wulu yaka wangkaparni ngarama. Katji Payilitpa karrartarringu wululpi kulinma. ");
INSERT INTO kux_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Year kutjupangka year kutjupangka Payilitu wulu watjanma puntu kutju pirtitjanu pakara yankuwa. Turlku tjarlungka wumurringama Payilitu-tjananya tjapinma, “Puntu ngana-rna watjalku pirtitjanu pakara yankuwa?” ");
INSERT INTO kux_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nyukurnitjanu puntu yini Parapatja kamu puntu laltu-ya kapamanku-tjanampaya wirrilirringu. Kamu lanymarringulpi-ya puntu kutju mirri-ya pungu. Katji-tjananyaya pirtingka tjarrpatjunu lanymatjanu. ");
INSERT INTO kux_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","9","Puntu laltu-ya kutjungkarringu yanu Payilitpa-ya tjapirnu puntu kutju pakaltjunkuwa yiyalkuwa. Payilitu-tjananya tjapirnu, “Kulu ngaatja nyuntunku Tjuwuku Tjarluminyirri pakaltjunku-rnangkuya?” ");
INSERT INTO kux_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Paluru-tjanampa nintikili nyinama turlku tjarlu-tjarlulu-ya matjulu Tjiitju nyalura katingu. ");
INSERT INTO kux_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Turlku tjarlu-tjarlulu laltulu puntu-tjananyaya parra watjapungama Parapatja tjapilkuwa. Laltulu-ya watjanma, “Parapatja pakaltjurra-lampatju.” ");
INSERT INTO kux_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Payilitu-tjananya tjapirnu, “Nyaaltjinku-rna ngaatja nyuntunkurnu Tjarluminyirri?” ");
INSERT INTO kux_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Katji-ya laltu paarlmanama watjanma-ya, “Tjurra-ya wartangka!” ");
INSERT INTO kux_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Payilitu tjapirnu, “Nyaaltjirnu ngawu ngaalu?” Wulu-ya paarlmanama, “Tjurra-ya wartangka!” ");
INSERT INTO kux_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Payilitu Parapatja pakaltjunu yiyarnu. Kamu watjarnu-tjananya warrmarlalu Tjiitju-ya tjanawana wilypirnpungkuwa katiku wartangka tjunkuwa. ");
INSERT INTO kux_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tjiitjanu warrmarlalu laltulu Tjiitju manulpi-ya katingu tjarrpatjunu Payilitkurnu yaata kaninytjarra. Yarltingu-tjananyaya warrmarla kalkinpa yankuwa-ya. ");
INSERT INTO kux_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tjiitjanu tjarntu tjarlura-ya tjina-tjinayuru purplewanpa tjunu-luya Tjiitjungka. Tjiitjanu manulpi-ya tjilka-tjilka kamu karrpirnu mukartiyuru tjunu-luya Tjiitjukurnungka katangka. ");
INSERT INTO kux_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kamu warrmarla-ya laltuminyirri parra ngarama ngarlpulu paarlmanama, “Yuwa, Tjuwuku-tjanampan Tjarluminyirri.” ");
INSERT INTO kux_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tjiitjanulpi pungu-ya wartakululu katawana kamu tjalatjunama. Katji-ya ngarlpukarra-ya pupatima. ");
INSERT INTO kux_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Katji-ya ngarlpurringu wiyarringu. Kamu tjarntu tjina-tjinayuru purplewanpa yurulypungu-luya. Kamu marlaku-luya tjarntu walytja tjunu. Tjiitjanu Tjiitju katingulpi-ya wartangkalpi tjunkuwa. ");
INSERT INTO kux_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Puntu kutju katji yanama puutjatjanu. Palurukura yini Simonpa. Paluru ngurra kutjupatjanu yini Tjarinitjanu. Katja kutjarra kanyinma Alexander kamu Rufuspa. Warrmarlalu-ya muunpungu Simonpa warta-ra katikuwanpa. ");
INSERT INTO kux_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Warinykatingu-ya ngurra yini Kalkatjakutu nganayi kata kitjikulu. ");
INSERT INTO kux_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Warrmarlalu wama mirritjinikulu Tjiitjuku purtu-raya yungama. ");
INSERT INTO kux_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Katji-ya Tjiitju wartangkalpi kankarra yutitjunu. Tjiingkalpiya warrmarla laltu ngarlpurrima nganalu winimankuwa Tjiitjuku tjarntu kutjupa-kutjupa mankuwa-ya. ");
INSERT INTO kux_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Tjirntungka-ya kankarrangkalpi Tjiitju-ya wartangkalpi yutitjunu. ");
INSERT INTO kux_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ngaatja-ya mirli-mirlingka wakarnu tjunu, “Tjuwuku-tjanampa Tjarluminyirri”. Tjiitjanu murrutjunu-luya palurungkalpi kankarra. ");
INSERT INTO kux_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Warrmarlalu puntu ngawu kutjarra yitingka-pulanyaya Tjiitjungka tjunu. ");
INSERT INTO kux_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nyukurnitjanu puntulu Mamaku tjukurrpa wakarnu tjunu. Wangka ngaatja, “Puntungka ngawungka mirrirringu.” Tjiitja yutirringulpi. ");
INSERT INTO kux_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Puntu laltu-ya wayintara yanama. Nyangu-ya mantarrima watjanma, “Yuwayi. Nyuntulun watjanma churchpan Tjarlu punkatjunku kamu ngurra kutjarratjanulu walytjalulpi marlakun palyalkuwa. ");
INSERT INTO kux_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Yuwayi, walytjalulpi kanalangku tjawutilpi wartatjanu.” ");
INSERT INTO kux_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Turlku tjarlu-tjarlu laltu kamu nintipuka laltu-ya lurrtju mantarrima watjanma, “Ngaalu-tjananya puntu laltu kananma. Wiyangku walytjalulpi kananinpa. ");
INSERT INTO kux_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kulu palurukutju Mamalu yiyarnu Tjarlu-lampa ngayanku? Nyawa-la wartatjanu tjawutikuwa tjiitja-la nyaku kulilkulpi.” Puntu ngawu kutjarralu lurrtju-pula Tjiitjungka yitingka mantarrima kalkinyurulu watjanma. ");
INSERT INTO kux_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Karrpungka ngurra laltuwana mungarringu ngarama. Yulyulytjarralpi tjirntu marlaku yutirringu. ");
INSERT INTO kux_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tjiitjanu Tjiitju paarlmanu watjarnu, “Yilayi, Yilayi lama tjapatjani?” Tjitja watjarnin, “Mama, Mama, nganatjanu-rnin ngayu wantitjunu?” ");
INSERT INTO kux_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Puntu kalkinpa-ya parra ngarama kulirnulpi-ya paluru katji wangkama. Watjarnu-ya “Kulila. Yarltinpa-ra Elijaku.” ");
INSERT INTO kux_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Puntu kutju taputjunu tjarntu lamparnpa manu kamu wamangka tupurltjunu. Kamu puntu palurulu warta lampantalu karrpirnu yititjunu-lu Tjiitjungka tjikilkuwa. Puntu palurulu watjarnu, “Yuwayi, wurra-lara kulyakanyilku katji Elija marlakurriku mankuwa wartatjanu walatjunkuwa.” ");
INSERT INTO kux_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tjiitju wituka paarlmanu kamu mirrirringulpi. ");
INSERT INTO kux_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tjiingka churchtja Tjarlungka tjarntu tjarlu kankarratjanulpi yankirryanu parnakutu. ");
INSERT INTO kux_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Warrmarla tjarlulu kutjulu nyangu Tjiitju mirrirringulpi. Kamu wangkangulpi, “Puntu ngaatja mularrpa Mamakurnu katja.” ");
INSERT INTO kux_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tutjulu laltulu-ya tiwatjanulu nyangama. Tutju yini Mary Magdalan, kamu Tjalumi, kamu tutju kutjupa yini Mary, Jamesku marlatjanuku kamu Josephku-pulampa yipi. ");
INSERT INTO kux_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tutjulu tjiintu wulu Kalalitjanulu Tjiitju-ya parra wananma. Kamu wulu-ya mangarri parra kutjanma ngurra kutjupa ngurra kutjupangka. Kamu tutjulu-ya kalkintu Kalilitjanulu Tjiitju wanarnu. Tjiintu-ya Tjiitju wartangka tiwatjanulu nyangama. ");
INSERT INTO kux_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tjiitju mirrirringulpi Rapungka. Karrpu tjiingkalpi tjamunpa-ya palyanma yungunpalpi-ya miirl-miirlpa tjarukupuru warakparni nyinamalpa. ");
INSERT INTO kux_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Tjirntu tjarrpakitja puntu kutju warrinkatingu-lu Payilatkutu. Puntu yini Josephpa ngurra Arimatheatjanu. Puntu palyaminyirri councilpa nyinama. Palurulu wulu kulinma Mama-lampa puntuku kutjuwarraku tjarluminyirri wulu nyinamalpa. Josephtu marrkaluminyirri Payilatpa tjapirnu Tjiijuku mirri mankuwa katikuwa. ");
INSERT INTO kux_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Payilatu purtu-ra kulinma tjiitjanta Tjiitju wala mirrirringu. Payilatu warrmarla kutju yarltingu tjapirnu, “Kulu mularrpa paluru mirri?” ");
INSERT INTO kux_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Watjarnu, “Yuwayi.” Tjiitjanu Payilatu watjarnu Josephpa Tjiitju mirrilpi manku katikuwa. ");
INSERT INTO kux_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josephtu tjarntu manu katingu wartakutu. Manulpi mirri karrpirnu tjunu tjarntungka. Katingu tjarrpatjunu pirnkingka. Nyukurnitjanu-ya pirnki tjiitja pamarrpa tjarlungka tjawarnu-ya wantitjunu. Josephtu pamarr tjarlu manu maa yurnturnu pirnki yangatjunu. ");
INSERT INTO kux_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Tutju kutjarralu-pula Mary Magdalantu kamu Mary kutjupalu Josephkurnu yipilu nyangu-pula pirnkingka tjarrpatjunu. ");
INSERT INTO kux_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Karrputjarra Tjatiti miil-miilpa ngarangu. Katji-ya warakparni nyinama tjirntu-ya maa tjarrpatjunu. Tjiingkalpi Mary Matalan kamu Tjalumi kamu Mary Jamesku yipi pakara-ya yanu parnti-parnti palyaminyirri manu miku-ya Tjiitju mirri nyitilkuwa. ");
INSERT INTO kux_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tjiinpa ngarringu-ya Tjantingka raakarralpi pakara-ya yanu pirnkikutu. ");
INSERT INTO kux_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Katji-ya maa yanama wangkama-ya, “Nganalu-lampa pamarrpa tjarlu pirnkitjanu yurntulku?” (Pamarrpamarntu tjarluminyirri.) ");
INSERT INTO kux_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tjiintu tutjulu maa nyangu-ya pamarrpa nyukurnikili yurnturnu wantijunu ngarama. ");
INSERT INTO kux_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Katji-ya maa tjarrpangu nyangu-ya karratarringu puntu kulyarri tjarntu tjina-tjinayurrukulu kuru-kurukulu tjungarnikati nyinama. ");
INSERT INTO kux_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Puntu kulyarri wangkangu-tjananya, “Wiya nyurra ngurlurrimalpa. Milyapunginpa-rnantaya tjiitjalta-ran Tjiitjuku Natjuratjanuku nyanginpa, yangka-ya wartangka waralytjunu. Wiya paluru ngaangka. Paluru mirritjanu kanarringulpi pakara yanu. Nyawa-ya ngaangkatuka-ya ngarritjunu. ");
INSERT INTO kux_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Marlaku-ya yarra watjala-tjananyaya palurukurnu wanalpayingka laltungka kamu Piitangka. Tjiitju kurranyurriku Kalalikutu. Tjiingkalpi-ya nyaku-ya. Palurulu nyukurnikili wangka watjarnu wantitjunu.” ");
INSERT INTO kux_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tjiinpa tutju pirnkitjanu pakara-ya marlaku tarrputjunu karrata tiltirryanama-ya. Tjiitjanulpi wiya-tjananyaya watjarnu. Ngurlu wangkaparni nyinama-ya. ");
INSERT INTO kux_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tutju Mary Matalan nyukurni kukurrkulu wilkikulu nyinama. Tjiitjulu kukurrpa laltu-tjananya yiyarnu. Ngulampa Tjiitju Tjantingkalpi raakarra mirritjanu pakarnu. Paluru kurranyu yutirringu-lu tutju palurungka. ");
INSERT INTO kux_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tutju paluru yanu kutjungkarringu-tjananya palurukurnu wanalpayi laltungka. Tjuni-ya luyurrminyirri nyinama kamu yulama. ");
INSERT INTO kux_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Marylu watjarnu-tjananya, “Kulila-rniya! Nyangu-rna Tjiitju mirritjanu pakarnu kanalpi ngarama.” Wiya-luya kulirnu. ");
INSERT INTO kux_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tjiitjanu Tjiitju-pulanya puntu kutjupayuru yutirringu wanalpayi kutjarrangka tjiitja-pula ngurra kutjupakutu maa yanama. ");
INSERT INTO kux_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Puntu kutjarralu-pula ngulampalpi milyapungu. Marlaku-pula yanu watjarnu-tjananyaya wanalpayingka kalkinta. Wiya-pulanyaya kulirnu. ");
INSERT INTO kux_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ngulampa Tjiitju-tjananya yutirringu palurukurnu wanalpayingka 11ta nyinama-ya mangarri ngalkunma. Palurulu-tjananya watjarnu kurntatjunu, “Nganaku wiya-tjananyayan kulirnu tjitjalta-ya watjarnu ngayu-rniya nyangu mirritjanu pakarnu-rna?” ");
INSERT INTO kux_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Palurulu-tjananya watjarnu, “Yarra-ya ngurra kutjupakutu ngurra kutjupakutu kamu tjukurrpa palya ngayukurnu parra-tjananyaya watjanmalpa puntu laltungka. ");
INSERT INTO kux_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Puntulu nganalu-rni ngayu mularrtuminyirri kulilku. Tjiitjalta-tjananyaya kalyungka tupurltjunamalpa. Mamalulpi wulu kana kanyilku. Katji puntulu nganalu-rni wiya kulilku Mamalulpi warukutu yiyalku. ");
INSERT INTO kux_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Katji puntulu nganalu-rni mularrtu kuliku ngayukurnu maya-rnatjanampa yungku miku-ya ngayukurnu yiningka kukurrpa puntungka-tjananyaya yiyalku. Kamu wangka kutjupalpi-ya wangkamalpa. ");
INSERT INTO kux_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Katji-ya lingka ngurrpalu manku. Wiya-ya mirrirriku tjiitjanu. Katji-ya kalyu kara tjikilku. Wiya-ya mirrirriku tjiitjanu. Katji-tjanayaya marumpulu nyurnu pampulku, tjiitjanulpi-ya puntu nyurnutjanu palyarringku.” ");
INSERT INTO kux_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tjarlu Tjiitju-tjananya wangkangu wiyarringulpi Mamalu kankarramanu katingulpi yalkirikutu. Kamu paluru Mamangkalpi-lu tjungarnikarti nyinatingu. ");
INSERT INTO kux_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tjiitjanu palurukurnu wanalpayi-ya yanu parra-tjananyaya tjukurrpa watjanma. Tjarlu Tjiitjulu-tjananya marrkarrmanu palurukurnu warakpa-ya palyanma. Puntu laltulu-ya nyangu kulirnu, “Yuwayi, ngaantu-ya tjungarnilu watjarninpa.” ");
INSERT INTO kux_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Yangka yirna Tjarlu yini Augustuspa nyinama ngurra tjarlungka Rometa. Paluru-tjananya tjarlu nyinama ngurra kutjupa-kutjupaku. Palurulu-tjananya watjarnu yiningku-ya wakalkuwa. ");
INSERT INTO kux_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tjarlu Augustustju-tjananya puntu kutjuwarra watjarnu yankuwa-ya ngurra walytjakutu yiningkuya wakalkuwa. Mularrpakili-ya pakarnu yanu yiningku-ya wakalkuwa. ");
INSERT INTO kux_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josephtu ngurra Galileetjanu pakara yanu ngurra Judeakutu. Ngurra Nazarethtjanu pakara yanu Bethlehemkutu. Kurrarlka Josephkurnu tjamu yini Davidpa tjitji yutirringu ngurrangka tjiingka. ");
INSERT INTO kux_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","6","Joseph Mary nyupararra-pula lurrtju yanu. Katji-pula warinykatingu Bethlehemta. Mary tjamunpa tjitji kanyilkuwa nyinama. ");
INSERT INTO kux_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kamu tjitjilpi yutirringu, palurukurnu katja kurranyulpi. Marylulpi warntu manu tjitji karrpirnu ngarritjunu pulukikurnungka mangkalta. Tjiingkalta yarnangu-ya laltulpi-ya ngurrangka nyinama. ");
INSERT INTO kux_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ngurrangka tjiingka kintikili puntu-ya nyinama kukunytja ngampurrtu-tjananya kanyinma. ");
INSERT INTO kux_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Pinkirrkulu kutju-tjananya yutirringu ngarama. Tili tjarluminyirri Mamakurnu yutirringu-tjananya. Kamu ngurlurringu-ya. ");
INSERT INTO kux_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pinkirrkulu wangkangu-tjananya, “Wiya nyurran ngurluriku. Kulila-rniya. Ngayu-rnangkuya warinykatingu wangkakulu palyakulu. Katji-ya ngatja yarnangu kutjuwarralu kulilku ngurrkurriku-ya. ");
INSERT INTO kux_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kuwarri Davidkurnu ngurrangka tjitji yutirringu ngalkinpangkuya nyuntunku laltuku. Paluru tjarluminyirri Mamakurnu. ");
INSERT INTO kux_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ngayulu-rnantaya watjalku miku nyurran walytjalu nyakuwa. Nyaku nyurran tjitji pulukikurnungka mangkalta ngarrima, yipilu warntungka karrpirnu ngarritjunu.” ");
INSERT INTO kux_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tjiingkalpi-ya pinkirrkulu-ya laltu yalkuritjanu yutirringu ngurrkulu-ya Mama yinkarra marninypungama. ");
INSERT INTO kux_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Mama palyaminyirri yalkuringka kankarra nyininpa. Mama ngurrku nyininpa puntu laltuku miku-ya kurrurnpa palya nyinamalpa parnangka” ");
INSERT INTO kux_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Katji-ya pinkirrkulu marlaku yanu yalkurikutu. Kamu kukunytja ngampurrpayilungkuya watjarnu, “Yanku-la Bethlehemkutu nyakuwa-la Mamalu-lanya watjarnu.” ");
INSERT INTO kux_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mularrpakili-ya wala yanu nyakuwa-ya. Katji-ya warinykatingu-ya Bethlehemta parra-ya nyangama. Kamu-ya nyangu-ya Mary kamu-pulanya Josephpa nyinama. Kamu tjitji ngarrima pulukikurnungka mangkalta. ");
INSERT INTO kux_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Katji-ya kukunytja ngampurrpayilu tjitji paluru nyangu. Yanu-tjananya puntu laltu parra watjanma tjakulpa pinkirrkululu watjarnu. ");
INSERT INTO kux_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Katji-ya laltulu tjukurrpa tjiitja kulirnu karratarringu-ya. ");
INSERT INTO kux_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Marylungku wulu kulinma pinkirrkululu wangkanytjatjanu. ");
INSERT INTO kux_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kukunytja ngampurrpayi-ya marlaku yanu kukunytjakutu. Katji-ya yanu turlku-ya maa yinkalkatima-ya Mama marninypungama, kulirnu-ya nyangu tjiilanyatuka. Palunpa-ya wangkangu, “Mularrpakili pinkirrkululu-lanya mularrtu watjarnu.” ");
ALTER TABLE kux_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
