﻿USE sofia;
DROP TABLE IF EXISTS sofia.kud2014_vpl;
CREATE TABLE kud2014_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kud2014_vpl WRITE;
INSERT INTO kud2014_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Laulele teina Besinana Yeisu ana mumugao vehabadi. Yeisu tubuna Deivida, na Deivida tubuna mugamugaina Abelaham. ");
INSERT INTO kud2014_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Wuwuna teina dova: Abelaham iya natuna Aisake, na Aisake natuna Yakobo, na Yakobo natunao Yuda matahinao. ");
INSERT INTO kud2014_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda natunao Pelesi yo Selaha na hinadi Temali, Pelesi natuna Hesiloni, na Hesiloni natuna Alam, ");
INSERT INTO kud2014_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","na Alam natuna Aminadaba, na Aminadaba natuna Nasoni, na Nasoni natuna Salimoni, ");
INSERT INTO kud2014_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","na Salimoni mwanena Lehabi na natudi Boasa, na Boasa mwanena Ludi, na Boasa yo Ludi natudi Obedi, na Obedi natuna Yesi. ");
INSERT INTO kud2014_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesi natuna Deivida, iya Tauwasawasa, na Deivida Ulaya hiwapena itawaholai, na natudi Solomoni hilabahi. ");
INSERT INTO kud2014_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoni natuna Lehobouma, Lehobouma natuna Abaya, na Abaya natuna Esa. ");
INSERT INTO kud2014_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esa natuna Yehosepata, na Yehosepata natuna Yolam, na Yolam natuna Usaya. ");
INSERT INTO kud2014_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaya natuna Yodam, na Yodam natuna Ehasi, na Ehasi natuna Hesekaya. ");
INSERT INTO kud2014_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaya natuna Manasa, na Manasa natuna Amoni, Amoni natuna Yosaya. ");
INSERT INTO kud2014_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosaya natunao Yekonaya matahinao, na yadi haugai Babiloniwone hilaoma ta Yudeyaone hi'abi avivinidi na hilalawedine tupwa Babiloni ainai ta himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Hauganane Babiloni ainai himiyamiya, Yekonaya natuna Selatiyeli, na Selatiyeli natuna Selubabela. ");
INSERT INTO kud2014_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selubabela natuna Abiyuda, na Abiyuda natuna Elayakim, na Elayakim natuna Esoli. ");
INSERT INTO kud2014_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Esoli natuna Sadoka, na Sadoka natuna Ekim, na Ekim natuna Eliyuda. ");
INSERT INTO kud2014_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyuda natuna Eliyesa, na Eliyesa natuna Madani, na Madani natuna Yakobo. ");
INSERT INTO kud2014_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo natuna Yosepa, iya Meli mwanena, na Meli natuna Yeisu, na Yeisu hi'awa Besinanaei. ");
INSERT INTO kud2014_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ebe Abelaham ainaena na tavahilidima Deivida ainai, neta yaso adi bagibagili 14. Eeta ebe Deivida ainaena yaso tavahilidima haugana Babiloniwone Yudeyaone hilalawedine Babiloni ainai, neta adi bagibagili 14. Na yadi hauga Babiloni ainaena na Besinana towahona yana hauga ainai yaso adi bagibagili hinage 14. ");
INSERT INTO kud2014_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Teina dova Yeisu Besinana ana labahine. Yeisu hinana Meli hiwalo abi'abiyei Yosepa ainai, na howola nigele hiyamiya bwau na Meli hesi ihiuma'o na yana hiumane neta Alu'aluwa Ve'ahihi ainaena. ");
INSERT INTO kud2014_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Na mwanena Yosepa towaho dumwadumwaluna ta nigele ebeha Meli yana hiumane iyata'eyei ana geluwo aidiyai, na inuwavitai ta ebeha yana nuwatuwu dawaniyena ita'wata'wataei. ");
INSERT INTO kud2014_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Na Yosepa yana nuwatuwu howola ipaipaihowa, na yana hauga eno ainai niviniviyena Yaubada yana tausagenawasa ehebo ainai iwalo, ‘Yosepa, owa Deivida tubuna, havena unuwanuwayababa Meli yana hiumane vehabana, neta Alu'aluwa Ve'ahihi ainaena, na hesi bada ulauvai mwanem. ");
INSERT INTO kud2014_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Howola abo natuna towahona ilabahi, na yehana umwauwi Yeisu, wuwuna iya yana bodao yadi pwanoliwo aidiyena mata ilivahidi.’ ");
INSERT INTO kud2014_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ginauli teina bada himahalava'o wuwuna mwalona tauwalo mahalava ehebo Yaubada yana walo iwalo mahalava mugaiyei ta Buki Ve'ahihi ainai ilelelene, iwalo: ");
INSERT INTO kud2014_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","‘Vahala nuwanuwapuyona mata ihiuma yo natuna towahona ilabahi, na yehana himwauwi Imanuweli’. Na Imanuweli ana bui ‘Yaubada baidada’. ");
INSERT INTO kud2014_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Eeta Yosepa eno'enowena itowolo na tausagenawasanane yana walo imulitaei, ta Meli itatawaholaine, ");
INSERT INTO kud2014_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","na nigele 'wapina iya'abitowoi ta ana higa ilabalaba na Yosepa gamane yehana imwau Yeisu. ");
INSERT INTO kud2014_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yeisu hilabahi Betelehem ainai, haugana Helodi iya iloiloina Yudeya holanai. Na hauganane ainai tausonogao tupwa bomatuwena hilaoma ta Yelusalemaone aidiyai hipanivila, ");
INSERT INTO kud2014_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","hiwalo, ‘Havaidova Yudeya yami wasawasa vauvauna hilabahi? Ahanapuiya'o bada hilabahiya'o, wuwuna ana ve'ive'ilala utui a'itaya'o tupwa bomatuwena ipoetaohanine, ainaena alaoma habi pwagogo ainai.’ ");
INSERT INTO kud2014_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Yadi walo teina wasawasa Helodi ibenalei na i'aluwagavai mwala'ina yo hinage Yelusalemao bagibagilidi hi'aluwagavai walo teina vehabana. ");
INSERT INTO kud2014_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ainaena Helodi Yudeyaone yadi taupwaoli mwala'idi yo yadi loina ana tauve'itao iyoga ahaidi na aidiyai ipanivila, iwalo, ‘Havaidova ainai Besinana towahona hilalabahine?’ ");
INSERT INTO kud2014_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Na hiwalo, ‘Betelehem ainai, neta Yudeya holanai, dova tauwalo mahalava yana walomahalava Buki Ve'ahihi holanai, iwalo: ");
INSERT INTO kud2014_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Vehabana Betelehem dalava wasawasa na mwala'ina Yudeya dalavanao maudoidi aidiyena. Wuwuna Betelehem holanaena howola abo Isileli adi tauloina imahalava, na iya yagu bodao imugaiyedi.” ’ ");
INSERT INTO kud2014_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ta Helodi tausonogaowa iyoga dawaniyedima, na ipanivilaedi aiteya hauga ainai utuine imamahalavane. ");
INSERT INTO kud2014_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Eeta Helodi yadi walo ibenaledi na iloinaedi, iwalo, ‘Amlau Betelehem ainai na gamanane ambehaei, na ebe amlobai amwuyoma amvenuwamwauwegau, ta ebe yau hinage yalau na yapwagogo ainai’. ");
INSERT INTO kud2014_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Wasawasa alinana hibenalei na hiso'e'eli ta hilau na utuiwa mwalona tupwa bomatuwena hi'i'itawa mehediyai imahalava na ihinahinali eeta himulitaei na gamanane yana abamiya itowolove'ilala na ainai himamahalavane, ");
INSERT INTO kud2014_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","na utuiwa vehabana hiyaliyaya mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Hiluwu vadai ta gamanawa hinana Meli baidana hi'i'itadine, na hipwagogo gamane ainai. Na velauwowa hivavaidimawa gamanane ainai himwamwauwidine, neta goula yo gado'a yo emodi. ");
INSERT INTO kud2014_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na mulitai niviniviyena Yaubada ivenuwamwauwedi ebeha havena Helodi ainai hiwuyowuyouyo, eeta hitowolo na vali amwahaena hilau gwaipile yadi dalavai. ");
INSERT INTO kud2014_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Na tausonogao bada hilao'o na masigiliyena Yaubada yana tausagenawasa niviniviyena Yosepa ainai imahalava ta ivenuwamwauwei iwalo, ‘Utowolo na gama mahinana ulauvaidi ta amdena tupwa Itipita ainai, na nemai ammiyamiya ana higa yavenuwamwauwegomiu, abo amlau gwaipilema. Yami dena teina wuwuna, Helodi mata gama teina ibehaei na ebeha i'oiye mwalowoi.’ ");
INSERT INTO kud2014_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Eeta masigilinane ainai Yosepa itowolo ta gamane mahinana ilauvaidi na hidedenane Itipita. ");
INSERT INTO kud2014_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Na nemai Itipita himiyamiya ana higa Helodi imwamwalowoine. Yadi vetaumana ainaena Yaubada yana walomahalava, neta ehebo tauwalo mahalava iwalo mahalava mugaiyei, iwalo: ‘Itipita ainaena natugu yayogaenama’. ");
INSERT INTO kud2014_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Na Helodi tausonogaowa iha'wa'ahayaidi ta nigele hiyalau gwaipilema. Yadi oyama vehabana imodi'i'ini mwala'ina, eeta Helodi yana tau'alehao ivetamaledi Betelehem dalavanao aidiyai, yo ebeha hedaheda towatowahodi hiya adi bolimai bwau ainaena i'aituluyo, hi'oiye mwalowoidi. Wuwuna tausonogao yadi aubabada ainaena bada ihanapuiya'o aiteya hauga ainai gamanane itutubuine. ");
INSERT INTO kud2014_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ainaena hauganane imahalava hava tauwalo mahalava Yelemaya mwalona iwalo mahalava mugaiyei, iwalo: ");
INSERT INTO kud2014_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","‘Dou ta'eta'e dalava Lama'a ainena yabenalei. Muya na mehelino hidou ta'eta'eyedi. Letiyeli idoudou natunao vehabadi, na yana dou ainaena nigele howahowana iyaliyaya, natunao yadi mwalowoi vehabana.’ ");
INSERT INTO kud2014_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Eeta Helodi yana mwalowoi tuluhanai Yaubada yana tausagenawasa imahalava Yosepa ainai, haugana Itipita ainai howola himiyamiya, na niviniviyena iwalo ainai, ");
INSERT INTO kud2014_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","iwalo, ‘Yosepa utowolo na gama mahinana ulauvaidi na amwuyo Isileli, wuwuna gamane ana alehawa bada imwalowoi'o’. ");
INSERT INTO kud2014_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Na Yosepa itowolo, ta gamane yo hinanane ilauvaidi, na hiwuwuyone Isileli. ");
INSERT INTO kud2014_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Na haugana hiwuyo Yosepa wasa ibenalei ebeha Helodi natuna Akeleyosi ive'aivelaheyei na ivetauwasawasa Yudeya holanai, eeta Yosepa imeheuhi na nige nuwana ilau gwaipile Yudeya, eena niviniviyena ve'ita Yaubada imohei ta hita'i'ili Galili tupwanane ainai. ");
INSERT INTO kud2014_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Na Nasaleti ainai hivedalava ta himiyamiya. Teina ainaena tauwalo mahalava yadi walomahalava mugamugaina iwalo: ‘Iya yehana himwauwi towaho Nasaleti’. ");
INSERT INTO kud2014_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Hauga tenem ainai Yoni tau'abiye bapitaiso imahalava balabala awawai tupwa Yudeya holanai na iguguya, iwalo, ");
INSERT INTO kud2014_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","‘Mumugamiu yababadi aidiyena amnuwabui wuwuna Yaubada mata muhamuhana alidai ivetauloina’. ");
INSERT INTO kud2014_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tauwalo mahalava Aisaya mugai Yoni vehabana iwalo mahalava, iwalo: ‘Towaho ehebo tupwa balabala awawai alinana mwala'ina ainaena iyogayoga, iwalo: “Bada yana amwaha amsepa na am'abiye duyedumwalu”.’ ");
INSERT INTO kud2014_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yoni ana ale'o lagulagu kameli wiyawiyana, na ana tulituli kameli 'wapina, na ana mwaimwai'e'e yo mwagagau ta'i. ");
INSERT INTO kud2014_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Na Yoni balabala awawai iloguguguya na Yelusalemaone yo Yudeyaone yo we'aha Yolidani papalinane ana taumiyaone maudoidi hilaoma Yoni ainai, ");
INSERT INTO kud2014_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","na mumugadi yababadi hiwalo mahalavaedi ainai, eena i'abi'abiye bapitaisodi we'aha Yolidani ainai. ");
INSERT INTO kud2014_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Na Palisiwone yo Sadusiwone bagibagilidi hinage hilaolaoma habi bapitaiso, na Yoni i'itadi ta iwalowedi, iwalo, ‘Tau'oyamao! omiu dova weso! Na yami nuwatuwu ebeha mata Yaubada yana modi'ini ainaena amdena, awa? ");
INSERT INTO kud2014_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ainaena ilowoinanegomiu yo yami nuwabui moiha amve'itaedi yami paihowa namwanamwadi aidiyena. ");
INSERT INTO kud2014_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Na havena amnuwahaehae wuwuna ebeha omiu Abelaham tubunao na hesi Yaubada howahowana yo gaimao teina aidiyena Abelaham tubunao ipaihowaidi. ");
INSERT INTO kud2014_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Na ebe mumugamiu nigele namwanamwana mata Yaubada iwalo yagaigomiu, dova aiwa, ebe nigele ainona namwanamwana tomowa higoha vehuludi ta aiwa ala'alahina ainai hivehuludi na i'alahidi. ");
INSERT INTO kud2014_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","‘Na ebe amnuwabui, yau we'ahaena ya'abiye bapitaisogomiu na hesi howola abo ehebo towaho ilalaoma, iya imwala'i gabaegau, na nigele howahowagu na aena ana huma ya'avalai. Na towahonane mata ilaoma na Alu'aluwa Ve'ahihi, dova aiwa ala'alahina ainaena i'abiye bapitaisogomiu. ");
INSERT INTO kud2014_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Na towaho teina yana goliyena mata ai'ai dova pegapega itapidi yo ainodi hiholu na mulitai ainodi namwanamwadi ivehae yana vadavada ainai, na mohomohodine aiwa ala'alahina miyamiya vateyaina ainai igabudi.’ ");
INSERT INTO kud2014_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Hauga tenem ainai Yeisu tupwa Galili ilauvehulu na ilau Yolidani Yoni ainai habi bapitaiso. ");
INSERT INTO kud2014_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Eeta Yoni itowoi na Yeisu yana nuwatuwu higwaipile ta iwalo, ‘Ilowoinanei na owa u'abiye bapitaisogau, na vedova ta ulaoma ta ebeha yau ya'abiye bapitaisogo?’ ");
INSERT INTO kud2014_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Na Yeisu Yoni yana walone iyemaihane, iwalo, ‘Nigele. Hesi teina dova. Owa u'abiye bapitaisogau, wuwuna teina ainaena loina maudoidi namwanamwadi tamulitaedi.’ ");
INSERT INTO kud2014_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Eeta Yoni italam ta Yeisu i'abiye bapitaisone. Na Yeisu howola bwahiyena igayogayo taohani, na galewa ilotaho'e na Yeisu Yaubada Alu'aluwana i'i'itane ana oleya dova gabubu i'aituluma na ainai itotowane. ");
INSERT INTO kud2014_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Na hinage ehebo alinana galewaena hibenalei iwalo, ‘Teina natugu yavelauwei iya vehabana yayaliyaya mwala'ina’. ");
INSERT INTO kud2014_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Teina ainaena Yaubada Alu'aluwana Yeisu ilauvai ta ilalaweine balabala awawai ta ebeha ana towoi Tomodulele ainaena ilobai. ");
INSERT INTO kud2014_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Na ahubena 40 holanai nigele iya'ai, ta ainaena ivahali mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Na tautowoinane imahalava na iwalo, Ebe owa Yaubada Natuna, gaima teina uloinaedi ta hiyemala ai'ai’. ");
INSERT INTO kud2014_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Na Yeisu iwalo, ‘Buki Ve'ahihi holanai loina imiyamiya ebeha: “Tomowa yawahidi nigele ai'ai a'ava ainaena, na hesi walowo maudoidi Yaubada awanaena hilaoma iya tomowa yadi abanamwanamwa”.’ ");
INSERT INTO kud2014_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","I'ovi na Tomodulele Yeisu ilauvai ta ilalaweine Yelusalem, na vada tapwalolo mwala'ina ewa'alilinai ihahaeyeine, ");
INSERT INTO kud2014_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","na ainai iwalo, ‘Ebe owa Yaubada Natuna, teina ainaena ugavai, na mata nigele howahowana uyasilahe. Wuwuna Buki Ve'ahihi bada iwalo mahalava'o, iwalo: “Yaubada yana tausagenawasao iloinaedi ta hi'ita avivinigo”. Yo hinage iwalo: “Nimadiyena hi'avalaigo, na ebe havena aem hisilasilahe gaima aidiyai”.’ ");
INSERT INTO kud2014_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Na Yeisu hinage iwalo, ‘Ehebo walo Buki Ve'ahihi ainai imiyamiya iwalo: “Havena yam Bada Yaubada utowotowoi”.’ ");
INSERT INTO kud2014_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Na Tomodulele Yeisu ilauvai ilawei oya mwala'ina ewanai na tenem ainai dalava wasawasaowa bale'uwai maudoidi Yeisu iveve'itane, ");
INSERT INTO kud2014_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","na hinage itowouyoi, iwalo, ‘Tupwa tenem maudoina mata yamohego. Ebe ube'u aitulu na aliguwai upwagogo, na ebe abaloinaone yamohego.’ ");
INSERT INTO kud2014_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Eena Yeisu iwalouyo, iwalo, ‘Tomodulele, ulau vehulugau! Buki Ve'ahihi holanai loina imiyamiya ebeha: “Yam Yaubada ibom ainai upwagogo yo utapwalolo yo ibom yana walo upaihowai”.’ ");
INSERT INTO kud2014_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ainaena Tomodulele Yeisu ilauvehulu na mulitai tausagenawasao himahalava ta hihahaguine. ");
INSERT INTO kud2014_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Na mulitai Yeisu wasa ibenalei ebeha Yoni vada abapaiyai himwauluwuwena'o, ainaena iwuyo Nasaleti Galili tupwanai. ");
INSERT INTO kud2014_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Na Nasaleti ilauvehulu ta imimiyane Kapaneum le'awanai, neta huhuwone Sebuloni yo Napitalai yadi toputopuwai. ");
INSERT INTO kud2014_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ginauli teina vehabana tauwalo mahalava Aisaya mwalona iwalo mahalava na Buki Ve'ahihi ainai ilelelene iwalo: ");
INSERT INTO kud2014_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","‘Sebuloni yo Napitalai yadi dalavao neta ni'u yo bwahi Yolidani ahipudiyai, nigele Yudeyao yadi tupwa yehana Galili. ");
INSERT INTO kud2014_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Hibom guguyou yana tupwa ainai himiyamiya na hesi teina hauga masele mwala'ina bada hi'itaya'o. Wuwuna mwalona mwalowoi yana tupwa yababana ainai himiyamiya na teina hauga bada masele aidiyai i'alataohani'o.’ ");
INSERT INTO kud2014_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Hauga tenem ainaena Yeisu yana guguya ivetuwuni na iwalo, ‘Yami paihowa yababadi aidiyena amnuwabui, wuwuna hauga bada imahalava'o na Yaubada ivetauloina alidai’. ");
INSERT INTO kud2014_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Na ehebo hauga Yeisu ni'u Galili le'awanai ivasavasane na tauyama hitau bwau matahina ilolobaidine yadi vinaya hiyahuyahuwei, ehebo Saimoni, iya hinage hiyogaei Pita, na tahina yehana Andulu. ");
INSERT INTO kud2014_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Na iyogaedima na iwalo, ‘Ammulitaegau na tomowa am'onadi’. ");
INSERT INTO kud2014_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tenem ainai yadi vinayawa hilaugabaei na Yeisu himumulitaeine. ");
INSERT INTO kud2014_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Na hinage tupwana ivasanelau na tauyamao hitau tonuga wagai yadi vinaya hi'atu'atububunidi i'i'ita lobaidine, hiya Yemesa yo Yoni yo tamadi, ibom yehana Sebedi. Eeta Yemesa matahina iyogaedi, ");
INSERT INTO kud2014_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","na hitowolo mwayamwayau tamadiwa wagai hilalaugabaeine, na Yeisu himumulitaeine. ");
INSERT INTO kud2014_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yeisu Galili maudoina ita'i'iliyei na yadi vada tapwalolo aidiyai iguguya, na wasa namwanamwana Yaubada yana loina vehabana iwalo mahalava, na hinage tomowa adi lovalao vagadi yo vagadi aidiyena i'abiye namwanamwadi. ");
INSERT INTO kud2014_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ainaena Yeisu wasana imahalava Siliya dalavanao maudoidi aidiyai, eeta taulovalao bagibagilidi hilawelawedi ainai, hiya hilovala mwala'ina na hiya ma'adi muyamuyao yo hiya vi'avi'a i'abiye yauyauledi yo hiya adi lovala ainaena hi'abi'abivelolo, yo hinage taupeuwo, na Yeisu i'abiye namwanamwadi maudoidi. ");
INSERT INTO kud2014_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Teina wuwuna boda mwala'ina Yeisu himulimulitaei. Hiya Galiliyena yo Dekapolisiyena yo Yelusalemaena yo Yudeyaena yo hinage Yolidani vali tupwanaena. ");
INSERT INTO kud2014_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yeisu boda mwala'ina i'i'itadine, na ihae oyai ta tenemai imimiyane, na ana taumulitao hinage hihahaene, ");
INSERT INTO kud2014_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","na Yeisu ivetuwuni ive'ita aidiyai, iwalo, ");
INSERT INTO kud2014_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","‘Omiu mayami nuwadobi amyaliyaya wuwuna Yaubada yana Abaloina alimiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Omiu taudou hinage amyaliyaya, wuwuna mata Yaubada i'abiye yaliyayagomiu. ");
INSERT INTO kud2014_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Omiu mumugamiu hegohegoyadi amyaliyaya, wuwuna howola abo Yaubada bale'u maudoina imohegomiu. ");
INSERT INTO kud2014_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Na ebe omiu mumuga dumwaluna nuwanuwamiu na amvahavahali amyaliyaya, yo hinage amgadogadomaguni vehabana amyaliyaya, wuwuna mumuga namwanamwana mata atemiyai imwala'i. ");
INSERT INTO kud2014_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Na omiu tau'atemuyamuya amyaliyaya, wuwuna Yaubada hinage mata i'atemuya muyaegomiu. ");
INSERT INTO kud2014_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Omiu atemiu masemaseledi amyaliyaya, wuwuna howola abo Yaubada am'ita. ");
INSERT INTO kud2014_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Omiu tau'abiye nuwadaumwali amyaliyaya, wuwuna Yaubada mata i'awa natunaegomiu. ");
INSERT INTO kud2014_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Na omiu yami paihowa namwanamwana vehabadi tomowa hive'ave'alehaegomiu, amyaliyaya wuwuna Yaubada yana Abaloina alimiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Na ebe vehabagu tomowa hi'ulu'ulumiyaegomiu yo ive'ave'alehaegomiu yo yadi oyamaena hi'awa'awa yababaegomiu, amyaliyaya ta'i. ");
INSERT INTO kud2014_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Moiha ta'i howahowana amyaliyaya mwala'ina, wuwuna howola abo ami maiha namwanamwana galewai mata amlobai. Na omiu dova Yaubada yana tauwalo mahalavao mwalona. Wuwuna hiya hinage yadi miyavitai hilobaidi tomowa aidiyena.’ ");
INSERT INTO kud2014_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","‘Omiu dova yagahu taumiya bale'u vehabadi. Na amnuwatuwu avivini ebe yagahu yana wahiyala i'ovi nigele howahowana na inamwanamwauyo, ainaena tata'wata'wataei na tahiwavehulu amwahai. ");
INSERT INTO kud2014_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","15","Na hinage omiu dova masele taumiya bale'u vehabadi. Ebe lampa tagabu havena walata ainaena ta'oi'oihamui, na hesi ewai tamwauwi, ta vada maudoina imasele. Hinage dova ebe oya vahupounai tadalava sepa nigele howahowana dalavanane tadawani. ");
INSERT INTO kud2014_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Omiu masele tomowa aidiyai, eeta howahowana yami paihowa namwanamwadi hi'ita na Tamamiu galewai hino'owei. ");
INSERT INTO kud2014_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","‘Havena amnuwanuwatuwu ebeha yau yalaoma na Mosese yana loinao nuwana tauwalo mahalavao yadi ve'itao yavaivehuludi. Na hesi yalaoma ebeha ya'abiye mahalava ili'ilimanidi. ");
INSERT INTO kud2014_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yawalo moiha alimiyai, mata bale'u na galewa hisawali, na loina mwala'ina yo iu'iu iso'isosolina mata nigele hiya'ovi na hesi ainodi mata himahalava. ");
INSERT INTO kud2014_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Na ebe yaiya loinadine ehebo aidiyena iu'iu iso'isosolina ita'wata'wataei yo tomowa hinage nigele iyave'itadi, iya Yaubada yana Abaloina holanai duya'ali'aliyai moiha, na hesi ebeha loinadine upaihowaidi yo uve'itaedi, yeham mata imwala'i Yaubada yana Abaloina holanai. ");
INSERT INTO kud2014_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","‘Hinage yawalo alimiyai ebe mumugamiu inamwanamwa mata Palisiwone yo loina ana tauve'itaone mumugadine omiu mumugamiune inamwanamwa gabaedi. Na ebe nigele, mata nigele Yaubada yana Abaloina ainai amyaluwu. ");
INSERT INTO kud2014_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","‘Loina mugamugaina tubudao aidiyai amhanapuiya'o, iwalo, “Havena yemwalowoi, ebe yaiya i'yemwalowoi mata loina ilobai”. ");
INSERT INTO kud2014_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","‘Na yau yaloinaegomiu ebe yaiya owa tahim ainai umodi'ini loina ulobai. Na ebe tahim u'awa yabayababaei loina ulobai, tauloinao aidiyena. Na hinage ebe tahim u'awa yauyauleyei, howola abo dalava ala'alahina uve'alo. ");
INSERT INTO kud2014_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","‘Yaiya owa yam velau uvaiyama yo upwaoliyei Yaubada ainai na ebe unuwatuwui ehebo tahim mayana nuwayababaowa mumugam vehabana, ");
INSERT INTO kud2014_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ilowoinanego yo yam velaune umwauwi abapwaoline vahalinai na uwuyo tahim ainai na utowoi ta baidam amve'au'augeluyo, eena mulitai uwuyoma abo yam velauwa Yaubada ainai upwaoliyei. ");
INSERT INTO kud2014_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","‘Na ebe ehebo towaho ive'ewaigo na ilawego habi lauvetalaego, ilowoinanego ebe mugai pwanoli u'abiye dumwadumwalu mwayamwayauwei baidam. Na ebe nigele, mata am tauve'ewane ilawego tauloina ainai na am loina ulobai, neta himwauwigo vada abapaiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Moiha ta'i, nigele mata uyamahalava ana higa am vagavaga maudoina upaihowai.’ ");
INSERT INTO kud2014_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","‘Loina mugamugaina bada amhanapuiya'o, iwalo, “Havena meheganawali”. ");
INSERT INTO kud2014_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Na yau yaloinaegomiu neta ebe yaiya towaho bo waihiu ainai inuwatuwu dawani, iya atenai bada ipwanoli'o. ");
INSERT INTO kud2014_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ainaena ebe mehe tautuwam yana vinunuwena i'abiye be'ugo ilowoinanego ebe uwunihi vehulu. Muya nigele mwala'ina ebe taum ehebo uvesawali, na hesi muya mwala'i alilina ebe mehem vehabana Yaubada taum maudoina igabae aituluwei dalava ala'alahina ainai. ");
INSERT INTO kud2014_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","‘Hinage dova ebe nima tautuwam yana paihowaena i'abiye be'ugo ilowoinanego ebe utom vehulu. Muya nigele mwala'ina ebe taum ehebo uvesawali, na hesi muya mwala'i alilina ebe nimam vehabana Yaubada taum maudoina igabae aituluwei dalava ala'alahina ainai. ");
INSERT INTO kud2014_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","‘Loina mugamugaina hinage iwalo: “Ebe towaho ehebo nuwanuwana na mwanena ivinawaheyei, towahonane leta ilele na mwanenane imohei ta ebe hivinawahe”. ");
INSERT INTO kud2014_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Na yau yaloinaegomiu neta, ebe towaho mwanena nigele iyapwanoli na towaho ta'i ivinawahe ta itawahola geyo'awa vali waihiu ainai, towaho teina mwanena mugamugaina bada i'abiye be'uya'o ebe waihiunane itawahola geyo'awa vali towaho ainai. Eeta towahowa ebe itawahola waihiu vinavinawahena ainai neta towahonane hinage ipwanoli'o. ");
INSERT INTO kud2014_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","‘Hinage loina miyamiyana bada amhanahanapui iwalo: “Ebe am'awa tamada, havena yami walowone amho'eho'edi na hesi Yaubada vehabana ampaihowaidi”. ");
INSERT INTO kud2014_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Na alimiyai yawalo, havena galewa vehabana am'awa'awa tamada, wuwuna Yaubada yana abamiya. ");
INSERT INTO kud2014_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Hinage havena bale'u vehabana am'awa'awa tamada, wuwuna aena ana abamwau, hinage havena Yelusalem vehabana am'awa'awa tamada, wuwuna tauloina mwala'ina yana dalava. ");
INSERT INTO kud2014_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Hinage havena ulu'ulumiu vehabana am'awa'awa tamada, wuwuna nigele howahowamiu na vahumiu ehebo amloinaei ta ihewa nuwana igiba, awa? ");
INSERT INTO kud2014_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Na hesi ebe utalam, uwalo, “Ehewa”, na ebe uuvala, uwalo, “Nigele”. Wuwuna ebe aubabada bagibagilina, neta Tomodulele ainaena. ");
INSERT INTO kud2014_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","‘Loina miyamiyana amhanapuiya'o iwalo, “Mehe ehebo ana maiha mehe ehebo, na sala ana maiha hinage sala ehebo”. ");
INSERT INTO kud2014_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Na yau yaloinaegomiu ebeha havena amvaivai maiha, na hesi ebe yaiya navanava tautuwamwena igoha, havena nimanane uyemayemaiha, na hesi vali navanavamne hinage utalamwei ta ainai igoha. ");
INSERT INTO kud2014_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Na hinage ebe yaiya lauvetala ainaena am ale'o ivai, hinage am abobone umohei. ");
INSERT INTO kud2014_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","‘Hinage ebe yaiya iloinaego na yana tobwatobwa u'avalai ehebo dalava ainaena ulau ehebo dalava ainai, howahowana utalam dalava bwauna hinage ainai ulawei. ");
INSERT INTO kud2014_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","‘Na hinage ebe yaiya i'awanoi alimwai ehebo ginauli vehabana, ginaulinane umohei, na yaiya yam tobwatobwa i'awanoiyei na iyepaihowa, havena unuwanuwavi. ");
INSERT INTO kud2014_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","‘Loina mugamugaina bada amhanapuiya'o, iwalo, “Ami geluwo amvelauwedi, na hesi ami alahao amsosomanaedi”. ");
INSERT INTO kud2014_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Na yau yaloinaegomiu ami alehao amvelauwedi na hiya hi'abi'abiye muyagomiu vehabadi am'awanoi ta Yaubada ihaguidi. ");
INSERT INTO kud2014_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Teina ainaena Tamada galewai i'awa natunaegomiu, wuwuna ibom velau wuwuna, na ibom yana mahana ihinahinali tauyababa yo hinage taunamwanamwa aidiyai, na hinage yana 'wesu italamwei taudumwaluwo yo hinage hiya nigele taudumwalu aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","‘Na ebe ami geluwo a'ava amvelauwedi, nigele howahowana na paula namwanamwana Yaubada ainaena amlobai, wuwuna tauyababao, dova takesi ana tauvaiwo, mumugadi dova yami velaune, adi geluwo a'ava hivelavelauwedi. ");
INSERT INTO kud2014_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","‘Hinage ebe tahi'a'avamiyao am'awa heliheliyamwedi mata mumugamiu ganamuli mumugadi nigele iyanamwanamwa gabaedi, wuwuna hiya adi geluwo a'ava hiveve'au'augeluwedi, eeta hiya na omiu bada mumugamiu hitoyatoyawa'o. ");
INSERT INTO kud2014_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","‘Na omiu ilowoinanegomiu na bale'uwai mumugamiu hinamwanamwa ta dova Tamamiu galewai.’ ");
INSERT INTO kud2014_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yeisu iwalo, ‘Ebe nuwanuwamiu amvelau hiya wewelohedi aidiyai, havena tomowa mehediyai ampaipaihowai. Ebe dova ampaihowai, mata nigele awanamwanamwa nuwana maiha amyalobai Tamamiu galewai ainaena. ");
INSERT INTO kud2014_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","‘Eeta haugana amvelau wewelohedi aidiyai havena yoguli amyuviyuvi, dova tau'oyamao hiya vada tapwalolo nuwana dalava aidiyai yadi velau tuluhanai yoguli hiyuvidi ta ebeha tomowa hino'owedi. Bada neta adi maiha hauga teina ta'i ainai hilobalobai na hesi hauga ilalaoma nigele maiha mata hiyalobai. ");
INSERT INTO kud2014_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Eeta omiu haugana velau ampaihowai, bada ammohe dawaniyei, ta nima tautuwamiu yana velau, havena nima eha'ehamiu ihanahanapui, ");
INSERT INTO kud2014_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ta ebe havena tomowa hi'ita'ita, na Tamamiu ibom yami velau dawani i'itaya'o mata mulitai maiha namwanamwana imohegomiu.’ ");
INSERT INTO kud2014_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","‘Yami awanoi teina dova, ebe am'awanoi Yaubada ainai havena tau'oya'oyamao dova am'awa'awanoi, wuwuna hiya nuwanuwadi na tomowa mehediyai nuwana tapwalolo holanai nuwana dalava aidiyai hitowotowolo na hi'awa'awanoi. Bada neta adi no'o hauga teina hilobalobai. ");
INSERT INTO kud2014_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Na owa ebe u'awanoi, uluwu mugai yam vada holanai na awa'eda ugudu'auhi na u'awanoi dawani Tamada ainai, na ibom i'itago na mulitai maiha namwanamwana imohego. ");
INSERT INTO kud2014_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","‘Na hinage yam awanoi aidiyai havena walo u'ata'ataiuyoi dova hiya taumiya guguyou yadi oba'obao. Hiya yadi yemidi ebeha walo bagibagilidi aidiyena Yaubada yadi awanoi ibenalei. ");
INSERT INTO kud2014_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Havena omiu dova, wuwuna omiu Tamamiu imiyamiya, na iya yami nuwatuwu dawani ihanapuidi'o na abo mulitai vehabadi am'awanoi. ");
INSERT INTO kud2014_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Ainaena awanoi ana hauga aidiyai teina dova am'awanoi: Tamamai owa galewai yeham ave'ahihiyei, ");
INSERT INTO kud2014_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","na a'awanoi ta owa uloinaegai, ta yam nuwatuwu ebeha apaihowai bale'uwai dova hiya galewai hipaipaihowai. ");
INSERT INTO kud2014_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Amai ahubena ehebo ehebo ainai umohegai. ");
INSERT INTO kud2014_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Na mumugamai yababana unuwahamuidi, dova ai hinage ama geluwo mumugadi yababadi alimaiyai anuwahamuidi. ");
INSERT INTO kud2014_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Havena utowotowoigai, na hesi iya yababanane ainaena uhaguigai.” ");
INSERT INTO kud2014_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","‘Ebe omiu ami geluwo yadi yababao alimiyai amnuwahamuidi, Tamamiu galewai hinage yami yababao alimiyai inuwahamuidi. ");
INSERT INTO kud2014_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Na ebe ami geluwo yadi yababao alimiyai nigele amyanuwahamuidi, Tamamiu hinage omiu yami yababao mata nigele iyanuwahamuidi. ");
INSERT INTO kud2014_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","‘Ebe haugana tapwalolo vehabana amhudi, havena ami oleya hiyabayababa dova taunuwayababa. Teina tau'oyama yadi paihowa dova, wuwuna hiya adi ita hi'abiye yababadi ta ebeha yadi hudi tomowa hihanapui. Bada neta adi no'o hauga teina hilobalobai. ");
INSERT INTO kud2014_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Na omiu hesi haugana am hudi tapwalolo vehabana, ammani'abi yo amhuwali, ta ami oleya hinamwanamwa tomowa aidiyai, ");
INSERT INTO kud2014_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ta ebe tomowa yami hudine havena hihanahanapui, na Tamamiu ta'i hava atemiyai imiyamiya ihanapuiya'o, na ana maiha namwanamwana imohegomiu. ");
INSERT INTO kud2014_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","‘Havena yami wasawasa bale'uwai amtautau'ahaidi, wuwuna wesoweso na pwaha, wasawasa bale'u hi'abi'abiye yababadi na hinage tau'aivavali hiluwuluwu yami vada aidiyai habi aivavali, ");
INSERT INTO kud2014_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","na hesi howahowana na yami wasawasa galewa vehabana am'aipate wahiwahiyala. Wuwuna galewai nigele wesoweso na pwaha ainai hiyamiyamiya. Ainaena yami wasawasa mata nigele hiya'abiye yababadi na hinage nigele tau'aivavali. ");
INSERT INTO kud2014_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Eeta aiteya tupwa ainai yami wasawasa imiyamiya, neta tupwanane ainai yami nuwatuwu hisagena. ");
INSERT INTO kud2014_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","‘Meheda dova tauda ana masele. Eeta ebe meheda ausaladi tauda maudoina himasele, ");
INSERT INTO kud2014_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","na ebe meheda hiyababa tauda hinage maudoina higuguyou, na ebe maselene alidai iboho, mata guguyou mwala'ina ita'i'iliyegita. ");
INSERT INTO kud2014_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","‘Taupaihowa ehebo nigele howahowana na ipaihowa tautaubadao bwau aidiyai, mata ehebo ita'wata'wataei na ehebo vehabana ipaihowa, na ehebo i'awa namwanamwaei na ehebo i'awa yababaei. Dova hinage nigele howahowana Yaubada yana paihowa na wasawasa bale'uwai ta'abi bwauwedi. ");
INSERT INTO kud2014_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","‘Na yawalo auligomiu ebeha havena yami miyamiya bale'uwai vehabana amnuwatuwu mwala'ina, ai'ai yo ami bwahi yo ami ale'o vehabadi. Wuwuna yawahida ginauli mwala'ina alidai, na tobwatobwa 'wapi vehabadi nigele ginauli mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","‘Teina ehebo aba'ita yamohegomiu lowolowo ainaena, hiya nigele hiyalaulaupeli na nigele hiyalaulau'eli, na hinage nigele yadi vadavada. Lowolowowone ginauli iu'iudi na hesi Tamadane galewai hauga maudoina ai'ai imohemohedi. Na amnuwatuwu avivini ebeha omiu ginauli mwala'ina Yaubada ainai. ");
INSERT INTO kud2014_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Na viha alimiyena howahowana yana nuwatuwuwena mata yana hauga bale'uwai i'abi'abiye daodao? Nigele, awa? ");
INSERT INTO kud2014_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","‘Na hava vehabana amnuwanuwatuwu mwala'ina ami ale'o vehabadi? Na ehebo hinage teina aba'ita, vane yadi ini dalavai vehabana amnuwatuwu behabehaei. Hauga maudoina nigele hiyapaipaihowa, na hinage nigele adi ale'o hiyapaipaihowaidi. ");
INSERT INTO kud2014_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Na moiha, Solomoni ana ale'owo yo ana pasao adi ita namwanamwadi, na vane adi ita hesi inamwanamwa alili. ");
INSERT INTO kud2014_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Eeta amnuwatuwu avivini Yaubada yana ita'avivini alimiyai vehabana. Iya awahi ive'aupasadi vane namwanamwadi aidiyena. Mata vane hitaya na i'ahubenama hiwelai yo higabudi, na omiu awahi amnamwanamwa gabaei. Na moiha, ami ale'owo imohegomiu. Ainaena yami yemidi Yaubada ainai havena itapitapiya. ");
INSERT INTO kud2014_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","‘Na havena amnuwanuwatuwu pwano amwalowalo, “Hava a'ai?” nuwana “Hava anuma?” nuwana “Hava ali'wa?” ");
INSERT INTO kud2014_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Walo teina dova hiya howola guguyou ainai himiyamiya yadi aubabada. Na hava yami nuwatuwu Tamamiu galewai bada ihanapuiya'o, dova ai'ai yo ami bwahi yo hinage ami ale'o, na imohemohegomiu. ");
INSERT INTO kud2014_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","‘Eeta howahowana ebe mugai Yaubada yana loina yo yana amwaha dumwadumwaluna ambehaei na ammulitaei, ta ebe ai'ai yo hinage ami ale'o imohegomiu. ");
INSERT INTO kud2014_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","‘Ahubena ehebo ehebo ana nuwanuwatuwu himiyamiya; mata vehabana na i'ahubena vehabana. Eeta mata havena am nuwanuwatuwu i'ahubena vehabana. ");
INSERT INTO kud2014_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","‘Havena tomowa am'awa'awa yababaedi mata dova ta Yaubada hinage i'awa yababaegomiu. ");
INSERT INTO kud2014_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Wuwuna aiteya ginauli aidiyena tomowa am'awa yababaedi mata aidiyena Yaubada i'awa yababaegomiu, na hinage vedova mumugamiu tomowa aidiyai Yaubada dova hinage imumuga alimiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","‘Na nigele howahowana tahim ainai uwalo ebeha mehenai aiwa mu'amu'alina imiyamiya, wuwuna owa hinage mehemwai etupwa imiyamiya, ta nigele uya'ita. ");
INSERT INTO kud2014_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Eeta havena tahim uwalowalo ainai ebeha aiwa mu'amu'alina mehenaena uvaivehulu, wuwuna owa hinage mehemwai etupwa imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Moiha tau'oyama ehebo owa, awa? Na hesi etupwane mehemwena uvaimugaiyei, na ainaena uvinunu ili'ilimani na mulitai abo tahimne mehenaena aiwa mu'amu'alina uvaivehulu. ");
INSERT INTO kud2014_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","‘Havena Yaubada yana paulao edewa umohemohedi, mata dova ta hita'wata'wataedi na hi'alahigo. Nigele howahowana hinage yami bagi maheya ammohemohedi mata dova ta hiwutuye bi'ibi'idi. ");
INSERT INTO kud2014_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","‘Am'awanoi, na Yaubada imohegomiu. Na ambeha ta amlobai. Na hinage am'aigohagoha ta awa'eda hiho'e. ");
INSERT INTO kud2014_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Moiha ebe ta'awanoi, Yaubada imohegita na ebe tabeha howola abo talobai, na hinage ebe ta'aigohagoha awa'eda hiho'e vehabada. ");
INSERT INTO kud2014_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","‘Na vedova omiu hedaheda tamadiyao, ebe natumiyao ai'ai vehabana hi'awa'awanoi, mata gaima ammohedi? ");
INSERT INTO kud2014_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nuwana ebe yama vehabana hi'awa'awanoi weso ammohedi? Mata nigele! ");
INSERT INTO kud2014_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Moiha omiu tauyababa, na yami aiyauya natumiyao aidiyai bada amhanahanapui, ebeha ginauli namwanamwa a'avadi ammohemohedi, dova hinage Tamamiu galewai, ebe am'awanoi ainai, ihanapuiya'o hava namwanamwana ilowoinanegomiu na imohegomiu. ");
INSERT INTO kud2014_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","‘Na ebe hava nuwanuwamiu na tomowa alimiyai hipaihowai omiu hinage dova aidiyai ampaihowai, wuwuna teina Mosese yo tauwalo mahalavao yadi loina ana uini. ");
INSERT INTO kud2014_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","‘Amwaha dinodinona ainaena amluwu na havena amwaha tabatabana ainaena, neta abasilahe ana amwaha. Amwahane tabatabanane ana lau malamalaina, na ainaena tomowa bagibagilidi hilaulau. ");
INSERT INTO kud2014_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Na yawahi namwanamwana ana amwaha ana lau vitaina na ana awa'eda dinodinona ta'i, ainaena tomowa vihavihadi hiluwuluwu. ");
INSERT INTO kud2014_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","‘Tauyewasao oya'oyama aidiyena am'ita avivinigomiu. Wuwuna mata tupwadi howola abo alimiyai hilaowa, adi ita dova sipi manamanahamdi, na holadiyai hesi dova edewa manimanini. ");
INSERT INTO kud2014_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Na yadi paihowa aidiyena howola mata abo amhanapuidi. Wuwuna haihaili nigele howahowana na ainona iyemala sibweya. Buyubuyuwa hinage dova nigele howahowana na ainona iyemala damaya. ");
INSERT INTO kud2014_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Wuwuna aiwa namwanamwadi ainodi ausaladi, na aiwa newanewalidi ainodi yababadi. ");
INSERT INTO kud2014_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Neta moiha, aiwa ausaladi nigele howahowana na ainodi newanewalidi hi'ainowedi, na aiwa newanewalidi hinage dova nigele howahowana na ainodi namwanamwadi hi'ainowedi. ");
INSERT INTO kud2014_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ainaena ebe aiwa nigele hiya'aino namwanamwa tagoha vehuludi na tagabudi. ");
INSERT INTO kud2014_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Dova hinage tauwalo mahalava oya'oyama yadi paihowa aidiyena howahowana amhanapuidi. ");
INSERT INTO kud2014_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","‘Bagibagilidi aliguwai hi'awa'awa taubada na hesi mata nigele hiyaluwu Yaubada yana Abaloina ainai, na yaiyadiwo hiya Tamagu galewai yana walo ana taupaihowao hiya hibom. ");
INSERT INTO kud2014_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Hauga ilalaoma ainai tomowa bagibagilidi howola abo aliguwai hiwalo, “Taubada vehabam apapaihowane, neta yehamwena awalo mahalava yo vi'avi'a tomowa aidiyena agabae mahalavaedi yo paihowa abanuwapwanopwano apapaihowaidine”. ");
INSERT INTO kud2014_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","‘Mata aidiyai yawalo, “Nigele yayahanapuigomiu yaiyadiwo omiu, amwuyo na havena amluwuluwuma wuwuna omiu tauyababao”. ");
INSERT INTO kud2014_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","‘Yagu walo teina ebe yaiya ibenaledi na ipaihowaidi iya dova ehebo tau'abi vada hanahanapuna, yana wahuwahu gaima ainai i'a'abine, ");
INSERT INTO kud2014_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","na mulitai 'wesu italu na abaita isagena yo hinage yaumai mwala'ina itowa na hesi yana vadane nigele iyabuiyei, wuwuna ana logidiwone gaima ainai hi'abi avivini'o. ");
INSERT INTO kud2014_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","‘Na ebe yaiya yagu walowone teina ibenaledi'o na nigele iyapaihowaidi, iya dova tauvada'abi yauyaulena yana wahuwahu namonamo ainai i'a'abine, ");
INSERT INTO kud2014_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","na mulitai 'wesu mwala'ina italu na abaita isagena na hinage yaumai mwala'ina itowa mata vadanane ibuiyei na i'oilo'elo'e moiha.’ ");
INSERT INTO kud2014_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Haugana ve'itaone teina Yeisu ive'ovidi bodaone nuwadi hipwanopwano, ");
INSERT INTO kud2014_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","na hiwalo, ‘Ve'ita teina dumwadumwaluna na wahiwahiyalana, na ita yada loina ana tauve'itao yadi ve'ita tapitapiyadi’. ");
INSERT INTO kud2014_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Oyaena Yeisu idobima ta boda mwala'ina himumulitaeine. ");
INSERT INTO kud2014_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Na ehebo aidiyena mayana lepelo ilaoma Yeisu ainai ipwagogo na iwalo, ‘Taubada, ebe nuwanuwam, howahowana u'abiye namwanamwagau?’ ");
INSERT INTO kud2014_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Eeta Yeisu nimanaena towahowa i'abisawahi, na iwalo, ‘Ehe, nuwanuwagu. Unamwanamwa’. Ta towahowa ana lepelo i'ovi mwayamwayau na inamwanamwauyone. ");
INSERT INTO kud2014_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Na Yeisu iwalo, ‘Ulau na havena teya yaiya hinage ainai uwalowalo mahalavaegau, na hesi udumwalu ulau taupwaoli ainai ta i'itago na hinage upwaoli Yaubada ainai hava dova ada loina Mosese ainaena, eeta ebe tomowa hihanapuigo ebeha bada namwanamwa ulobaiya'o’. ");
INSERT INTO kud2014_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yeisu ilaoma dalava Kapeneum ainai, na tau'alehao hiya Loma adi taumugai ehebo ilaoma na i'awanoi Yeisu ainai, ");
INSERT INTO kud2014_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","iwalo, ‘Taubada yagu hevali ehebo ilovala na vadai ma'ana muya mwala'ina i'eno'eno, na nigele yana wahiyala’. ");
INSERT INTO kud2014_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Na Yeisu iwalo, ‘Mata yalaowa na ya'abiye namwanamwa’. ");
INSERT INTO kud2014_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Na towahowa Yeisu yana walo iyemaiha, iwalo, ‘Taubada, nigele iyalowoinanego ebe yagu vadai uluwu, na hesi u'aubabada mohili na yagu hevaline inamwanamwa. ");
INSERT INTO kud2014_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Wuwuna yau loina yahanahanapui, na agu tauloinao yadi walo ana tau'awa abi, na hinage yagu tau'alehao yaloiloinaedi, na ebe teya ainai yawalo, “Ulau” ilau ta'i, na ehebo ainai yawalo, “Ulaoma” mata ilaoma; na ebe yagu taupaihowa ehebo yawalo auli na yawalo, “Teina upaihowai” mata ipaihowai.’ ");
INSERT INTO kud2014_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Towahowa yana aubabada teina vehabana Yeisu i'aluwagavai mwala'ina, na iwutu gwaipile ta bodaowa himulimulitaeiwa iwalo aulidi, iwalo, ‘Yawalo moiha, nigele teya yaiya yayalobai omiu Isileli alimiyena yana yemidi towaho teina dova, ");
INSERT INTO kud2014_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","na yawalo mahalava alimiyai neta tomowa bagibagili alilidi howola abo tupwa maudoina aidiyena hiho'eyama na Abelaham yo Aisake yo Yakobo baidadiyao hi'ai toyawa Yaubada yana Abaloina holanai, ");
INSERT INTO kud2014_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","na omiu hesi ebeha Yaubada natunaowa igabae mahalavaegomiu guguyou holanai na nemai amdoudou muya ainaena.’ ");
INSERT INTO kud2014_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Badagi na Yeisu tau'alehaone adi taumugaiwa ainai iwalo, ‘Ausala, uwuyo. Yam hevaline mata inamwanamwa, dova yam yemidine’. Tenem hauganane ainai taulovalawa yana wahiyala ilolobauyoine. ");
INSERT INTO kud2014_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Mulitai Yeisu Pita yana vadai iluwu, na Pita lawana i'ita ilovala, tauna i'ala'alawowoli, ");
INSERT INTO kud2014_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","eeta ilau, nimanai i'abi, na ana lovalawa itatalune, na itowolo ta ai'ai i'a'atububunine Yeisu vehabana. ");
INSERT INTO kud2014_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Lavilaviyena dalavane tanitaniwagadiyaone tupwadi tomowa hilawedima, hiya vi'avi'a aidiyai himiyamiya, ta Yeisu vi'avi'aone yana walowena igabae mahalavaedi na hinage taulovala maudoidi i'abiye namwanamwadine. ");
INSERT INTO kud2014_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ginauli teina himahalava na ainaena Aisaya tauwalo mahalava yana walo mahalava mugai imahalava, dova Buki Ve'ahihi ainai iwalo mahalava, iwalo, ‘Iya ada muyao na ada lovalao ana tau'avala’. ");
INSERT INTO kud2014_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Hauga tenem ainai Yeisu boda mwala'ina i'itadi hinoinoini, ainaena ana taumulitao iloinaedi ta wagaena higeyo'awa vali tupwai. ");
INSERT INTO kud2014_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Na ehebo loina ana tauve'ita ilaoma, Yeisu iwalo auli, iwalo, ‘Tauve'ita, nuwanuwagu yamulitaego. Havaidova ainai ulau, yau baidam talau’. ");
INSERT INTO kud2014_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Na Yeisu towahonane iwalo auli, iwalo, ‘Lagulagu nu'ula mayadi guda, na hinage lowolowo ewai mayadi noi, na yau Tomowa Moihagu nigele yagu aba'eno’. ");
INSERT INTO kud2014_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Eena ehebo hinage taumulita ilaoma ta Yeisu ainai iwalo, ‘Taubada, utalamwegau na mugai yawuyo ta tamagu yaha'waha'wai yana mwalowoi, yamwauwi magaiyai, na abo yamulitaego’. ");
INSERT INTO kud2014_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Na Yeisu iwalo, ‘Badagi! Nemai tamamne, na ulaoma umulitaegau, na hiya abo mwalomwalowoidi yadi taumwalowoiwo himagaiyedi’. ");
INSERT INTO kud2014_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yeisu mayana taumulitao higelu wagai, ");
INSERT INTO kud2014_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","na hi'u'e higeyogeyo'awa vali tupwai, eena wagai Yeisu i'eno i'iwahi'o. Hi'ada'adau ta yaumai mwala'ina itotowamane ta bagodu ihiwahiwa do'odo'owei wagai na muhamuhana hihanene. ");
INSERT INTO kud2014_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ainaena Yeisu hivanoi na hiwalo, ‘Taubada uhaguigita mata tahanene’. ");
INSERT INTO kud2014_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Na Yeisu iwalo, ‘Hava vehabana ammeheuhi? Vedova ta nigele yami yemidine, awa?’ Na itowolo ta yaumai yo bagodu iwalo yagaidi, iwalo, ‘Amlaumwau!’ Na ni'u maudoina idadaumwaline. ");
INSERT INTO kud2014_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Idaumwali, eeta ana taumulitaowa nuwadi hipwanopwano na hiwalo, ‘Towaho havahava teina, ta yaumai yo bagodu alinana hibenalei?’ ");
INSERT INTO kud2014_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Na bada higeyo'awa'o ta hiluluwune Gadalawone yadi tupwai, na towatowaho hitau bwau vi'avi'a i'abiye yauyauledi ta magai holanaena himamahalavane. Na mayadi modi'ini, ainaena nigele howahowana teya yaiya yadi tupwai ilau. ");
INSERT INTO kud2014_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Hitaubwauwone Yeisu hi'ita na hilohagali, hiwalo, ‘Ee! Owa Yaubada Natuna, hava utowotowoi na ebeha upaihowai alimaiyai? Lauvetala ana hauga howola, hava vehabana wau ulaoma habi vesilahegai?’ ");
INSERT INTO kud2014_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na vahalidiyai maheya hidumudumuli, na adi tau'ita aviviniwone hi'ita'ita avivinidi. ");
INSERT INTO kud2014_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Na vi'avi'aowa Yeisu ainai hi'awanoi, hiwalo, ‘Ebe ugabae mahalavaegai, howahowana na maheyaone tenem aidiyai uvetamalegai?’ ");
INSERT INTO kud2014_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Na Yeisu iwalo, ‘Ammahalava!’ Eeta towatowahowowa bwauwowa aidiyena vi'avi'aowa himahalava ta hidedenane maheyaowa aidiyai hiluluwune, na maheyaowa maudoidi hisagena ali'alili ta tapatapai hiholu ta ni'uwai hihahanenene. ");
INSERT INTO kud2014_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Na maheyaowa adi tau'ita'ita aviviniwowa yadi meheuhi ainaena hidena ta hilalaune yadi dalavai, na ginauliwone hi'i'itadiwa maudoina hiwalo mahamahalavaedi dalava tanitaniwagadiyao aidiyai, neta hava imamahalavane yauyaulewowa aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Eeta dalava ana taumiyao maudoidi himahalava Yeisu habi itana, na hauganane hi'ita lobai, hisosomanaei ta ebeha yadi dalavane ilauvehulu. ");
INSERT INTO kud2014_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yeisu wagai igelu ta higegeyo'awauyo yana dalavai. ");
INSERT INTO kud2014_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Na ehebo towaho peupeuna boda hi'avalai yana aba'eno ainaena ta hilawei Yeisu ainai. Bodaone yadi yemidi Yeisu ihanapuiya'o ta taupeuwa iwalo auli iwalo, ‘Natugu, uyaliyaya, mumugam yababadi adi nuwahamu bada ulobaiya'o’. ");
INSERT INTO kud2014_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Na tupwadi loina ana tauve'itao Yeisu yana walo hibenalei ta hibom aidiyai hi'au'aubabada, hiwalo, ‘Yeisu teina iwalowalo hinahinali Yaubada ainai’. ");
INSERT INTO kud2014_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yadi nuwatuwune Yeisu bada ihanapuiya'o ta iwalo aulidi iwalo, ‘Hava vehabana am nuwanuwatuwu pwano? ");
INSERT INTO kud2014_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Na hava amnuwatuwui ebe yawalowei towaho teina ainai, nuwana yawalo, “Mumugam yababadi bada yanuwahamuidi'o”, bo yawalo, “Utowolo na ulau”? ");
INSERT INTO kud2014_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Na amhanapui ebeha yau Tomowa Moihagu mayagu loina bale'uwai ta tomowa mumugadi yababadi yanuwahamuidi.’ Na taupeuwa iwalo auli, iwalo, ‘Utowolo na yam aba'eno u'avalai na ulau yam dalavai’. ");
INSERT INTO kud2014_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Eeta taupeuwa itowolo na ilalaune yana dalavai. ");
INSERT INTO kud2014_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Na bodaowa paihowa teina hi'ita na ainaena hive'ahihi yo Yaubada hino'owei, wuwunane iya Yeisu ana tau'abiye wahiyala. ");
INSERT INTO kud2014_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yeisu tupwa teina ilauvehulu ta ilau na towaho ehebo ilobai, yehana Madiu, takesi ana vadane ainai imiyamiya na iwalo auli, iwalo, ‘Madiu, umulitaegau!’ Eeta Madiu itowolo ta Yeisu imumulitaeine. ");
INSERT INTO kud2014_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mulitai vada ehebo ainai Yeisu iluwu habi ai na tauyababao dova takesi adi tauvaiwo yo hinage tupwadi tauyababao hilaoma Yeisu mayana taumulitao baidadiyao himimiya'ahaine. ");
INSERT INTO kud2014_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Eeta tupwadi Palisiwo hi'i'itane ta Yeisu ana taumulitaone aidiyai hipanivila, hiwalo, ‘Hava vehabana yami tauve'itane takesi ana tauvaiwo yo tupwadi hinage tauyababao baidanao hi'ai'aitoyawa?’ ");
INSERT INTO kud2014_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Na Yeisu walo teina ibenalei ta iwalo, ‘Hiya ausaladi nigele nuwanuwadi taulaumulamula, na hesi tau'asiyebwao nuwanuwadi taulaumulamula. ");
INSERT INTO kud2014_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ainaena ilowoinanegomiu ebe Yaubada yana walo ainai amnuwamasele Buki Ve'ahihi ainai iwalo, “Nuwanuwagu atemuyamuya, na nigele nuwagu pwaoli”. Teina yalaoma nigele taudumwadumwalu vehabadi, na hesi tauyababao habi haguidi.’ ");
INSERT INTO kud2014_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Na Yoni ana taumulitao hilaoma ta Yeisu hiwalo auli, hiwalo, ‘Ai na Palisiwone yama tapwalolo vehabana ahudihudi, na vedova ta owa am taumulitaone baidamwao nigele amyahudihudine?’ ");
INSERT INTO kud2014_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yeisu walo vegevegedi imohedi, iwalo, ‘Vedova, howahowana tawahola ana tauvinunuwo hinuwavitai ebe tautawahola towahona baidadi hiyaliyaliyaya? Bo nigele awa? Na amnuwatuwu avivini ebeha haugana tautawahola towahonane ilaugabaidi mata hinuwayababa na hihudi.’ ");
INSERT INTO kud2014_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Na ehebo hinage walovegevegedi ainaena iwalo aulidi, iwalo, ‘Nigele howahowana ebe ale'o vauvauna tupwatupwana ainaena luwuluwu miyamiyana tahaili auhi mata dova ta lotapulihinawa imwala'i. ");
INSERT INTO kud2014_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Na nigele hinage howahowana ebe waini vauvauna wahiwahiyalana tahiwai 'wapi abahiwa miyamiyana ainai. Ebe teina dova tapaihowai, we'ahane yana seseha ainaena 'wapiwa ilotapulihi na we'ahane ilotapahiwai, na isagenavehulu. Hesi ilowainanei ebe waini vauvauna na wahiwahiyalana tahiwai abahiwa vauvauna holanai, eeta ebe maudoina namwanamwana.’ ");
INSERT INTO kud2014_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yeisu howola i'au'aubabada na ehebo tauloina ilaoma ta Yeisu mehenai ipwagogo, na iwalo, ‘Taubada, natugu waihiuna wau imwalowoi'o, na nuwanuwagu ulaoma ta tauna u'abitowoi na itowolouyo’. ");
INSERT INTO kud2014_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Eeta Yeisu mayana taumulitao tauloinane himumulitaeine. ");
INSERT INTO kud2014_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Hilaulau na waihiu ehebo 'wahinana isagesagena bolimai 12, tuluhadiyena ilaoma ta Yeisu ana ale'one papalinane i'a'abitowoine, ");
INSERT INTO kud2014_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","wuwuna yana nuwatuwu atenai iwalo, ‘Bada ebe Yeisu ana ale'o a'ava ya'abitowoi mata yanamwanamwa’. ");
INSERT INTO kud2014_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Na Yeisu i'ita gwaipile ta waihiunane i'i'itane, na iwalo, ‘Yauwedo natugu, yam yemidi ainaena bada unamwanamwa'o’. Na hauga tenem ainai waihiuwa inamwanamwane. ");
INSERT INTO kud2014_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Eena Yeisu ilau tauloinane yana vadai imahalava na i'itadi huwehuwena adi taulauyuviwo hilaulauyuvi yadi nuwavitai vehabana, na hidoudou alinadi mwala'ina moiha. ");
INSERT INTO kud2014_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Eeta iwalo aulidi iwalo, ‘Ammahalava! Gamahinene teina nigele iyamwalowoi na hesi i'eno i'iwahi'o’. Walo teina ainaena na maudoidi himaluwei. ");
INSERT INTO kud2014_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ta bodaowa himahalava na Yeisu iluwu ta gamahinewa nimanai i'a'abine na mayawahina itowolo. ");
INSERT INTO kud2014_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Na mulitai wasa teina hiyewasaei dalava maudoina aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tupwa tenem Yeisu ilaugabaei na ilaulau, na taumehe gibugibu bwau himulimulitaei na hiyogayoga alinadi mwala'ina ainaena hiwalo, ‘Deivida tubuna yo, u'atemuyamuyaegai!’. ");
INSERT INTO kud2014_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Eena vadai iluwu ta taumehe gibugibuwowa hilaoma ainai na Yeisu iwalo, ‘Vedova, amyemidiyegau ebeha howahowagu mehemiu ya'abiye maseledi?’ Na hiya hiwalo, ‘Taubada, howahowam’. ");
INSERT INTO kud2014_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ainaena mehedi i'abitowoidi na iwalo, ‘Yami yemidiyena mehemiu himaseleuyo'o’, ");
INSERT INTO kud2014_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","na mehedi himamaseleuyone. Na Yeisu loina yaiyaina imohedi, iwalo, ‘Havena yaiya ainai amwalowalo mahalavaegau’. ");
INSERT INTO kud2014_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Na hesi hilau ta Yeisu yana walo hidi'wai ta yana paihowawa aidiyai hiwalo mahalavaei dalava maudoina aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Na Yeisu mayana taumulitao hilaulau na ehebo towaho alawai memenana i'a'abigwaipilene, ta hilauvaiyama Yeisu ainai. ");
INSERT INTO kud2014_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Eeta Yeisu alawaiwa iheusili, na towahowa inamwanamwa ta i'a'aubabadane. Na bodaone mayadi yaliyaya Yeisu hino'owei, na hiwalo, ‘Nigele dova yaiya yana paihowa teina dova taya'ita Isileli holanai’. ");
INSERT INTO kud2014_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Na hesi Palisiwone hiwalo, ‘Alawaiwowa yadi taubada yana wahiyalaena Yeisu alawaiwone iheuheusilidine, na nigele Yaubada yana wahiyalaena’. ");
INSERT INTO kud2014_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ainaena Yeisu dalava mwala'idi yo iu'iudi aidiyai ita'i'ili, na yadi vada tapwalolowo aidiyai ive'ive'ita na iloguguya Yaubada yana loina wasana vehabana, na hinage lovala bagibagilidi aidiyena tomowa i'abiye namwanamwadi. ");
INSERT INTO kud2014_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Na bodaone i'itadi na i'atemuyamuyaedi, wuwuna adi vitai aidiyena nigele adi tauhagu, dova sipi nigele adi tau'ita avivini. ");
INSERT INTO kud2014_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Na ana taumulitao iwalo aulidi, ‘Laulau'eli namwanamwana na omiu taulau'eliwone nigele bagibagilimiu, ");
INSERT INTO kud2014_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ainaena oyane taniwagana ainai am'awanoi ta taupaihowa ivetamaledima yana oyane hi'eli’. ");
INSERT INTO kud2014_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yeisu ana taumulitao hitau 12 iyogaedi na loina yo wahiyala imohedi ta ebe howahowadi alu'aluwa yababadi tomowa aidiyena hivai vehuludi yo lovala na tapiya tomowa aidiyena hi'abiye namwanamwadi. ");
INSERT INTO kud2014_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yeisu ana tauyewasao hiya yehadi tauwalo mahalava: Mugai Saimoni, iya iyogaei Pita, na tahina Andulu, yo Yemesa na tahina Yoni, hiya tamadi Sebedi, ");
INSERT INTO kud2014_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","yo Pilipi yo Batolomiu yo Tomasi yo Madiu, iya takesi ana tauvai, na hinage vali Yemesa iya Alipiyosi natuna, yo Tadiusa, ");
INSERT INTO kud2014_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","na hinage vali Saimoni, iya tauhamadudu mwala'ina Isileli yana miyawahi Loma yana abaloina ainaena vehabana, yo Yudasa Isakaliyota, iya howola abo Yeisu ihuhulaei. ");
INSERT INTO kud2014_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yeisu hitau 12 iloinaedi na ivetamaledi, iwalo, ‘Havena amlaulau nigele Yudeyaone aidiyai, na hinage havena Sameliya dalavanao aidiyai amluwuluwu, ");
INSERT INTO kud2014_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","na hesi sipi sawasawalidi aidiyai amlau, hiya neta yada bodao Isileliwone, ");
INSERT INTO kud2014_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","na aidiyai amwalo mahalava ebeha Yaubada yana loina bada ilaoma'o. ");
INSERT INTO kud2014_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Taulovalao am'abiye yawahaidi yo taumwalowoiwo am'abiye towolodi yo taulepelowo am'abiye namwanamwadi, na hinage vi'avi'a tomowa aidiyena amgabae mahalavaedi. Yaubada yana wahiyala bada imohegomiu'o, ainaena omiu hinage ilowoinanegomiu yo amvelau tomowa aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","‘Na yami ta'i'iline ainai havena teya mane yami pehai amdo'odo'oi tamahina vehabana. ");
INSERT INTO kud2014_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Havena hinage peha amvaivai. Havena hinage ami ale'o bwauna amvaivaidi, nuwana aemiu ana huma bwauna, nuwana yami digona bwauna amvaivaidi, wuwuna paihowa ai'aina howahowana amlobai. ");
INSERT INTO kud2014_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","‘Na ebe dalava mwala'ina bo iu'iuna ainai amluwu, ambeha mugai yaiya mumugana namwanamwana, na ainai amvetaumana ana higa dalavanane amlauvehulu. ");
INSERT INTO kud2014_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Haugana amluwu vada teya ainai mugai amwalo velau tomowanane ainai na amwalo, “Yaubada yana nuwadaumwali baidam ammiyamiya”, na abo amluwu. ");
INSERT INTO kud2014_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Na ebe wuwunidiyaone yami walovelau ilauwoinanedi, yami velau imiyamiya, na ebe nigele iyalauwoinanedi, yami walovelau iwuyouyowa alimiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","‘Na ebe nigele teya yaiya iyalauvaigomiu yana vadai, bo yami walo nigele iyabenaledi, dalavanane ainaena ammahalava na aemiu gawalanane am'oiye hoyeholu dalavanane ainai, neta aba'ita dalavane taniwagadiyaone aidiyai, eena mulitai abo dalavanane amlauvehulu. ");
INSERT INTO kud2014_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yawalo moiha, howola abo Yaubada yana lauvetala ana hauga ainai hiya dalavaowa hita'wata'wataegomiuwa muya mwala'i ali'alilina hilobai, na Sodomaowa yo Gomolaowa yadi muya mata i'iu'iu. ");
INSERT INTO kud2014_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","‘Amnuwatuwu avivini ebeha yau yavetamalegomiu dova omiu sipi manamanahamiu amlalau edewa manimaninidi ahi'ahipudiyai, ainaena howahowana amnuwatuwu hanapu weso dova, na hesi ammumuga hegoya dova gabubu. ");
INSERT INTO kud2014_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","‘Eeta am'ita avivinigomiu, wuwuna howola abo tomowa hilawegomiu lauvetala vehabana yo hinage vada tapwalolo aidiyai howola abo hi'aitutuwegomiu, ");
INSERT INTO kud2014_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","yo hilauvaigomiu na hilawegomiu tauloina yo tauwasawasa mehediyai na hive'ewaigomiu wuwuna omiu ebeha yagu bodao, na wasagu aidiyai am'au'aubabadaedi, yo hinage taumiya ganamuli yami walomahalava hibenalei. ");
INSERT INTO kud2014_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","‘Na ebe mehediyai hivetowologomiu havena am'ate'atehawawali ebeha vedova mata amwalone, wuwuna howola abo hauganane ainai Yaubada yami aubabada imohegomiu, ");
INSERT INTO kud2014_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","na nigele ebeha omiu am'au'aubabadane na hesi Tamamiu Alu'aluwana alimiyena i'a'aubabadane. ");
INSERT INTO kud2014_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","‘Na hinage hauga hilalaoma aidiyai tomowa yadi huhu holanai aleha himahalava vehabagu, neta towaho tahina ihuhulaei yo hiyemwalowoi. Hinage dova tama natuna ihuhulaei yo hiyemwalowoi. Hinage hedaheda hinadiyao yo tamadiyao hi'alehaedi na hiyemwalowoidi. ");
INSERT INTO kud2014_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mata tomowa maudoidi hive'alehaegomiu wuwuna omiu ebeha agu tauyemidiwo. Na ebe yaiyadiwo hi'alama'i'ita na hitowolo wahiyala ana higa hauga yana aba'ovi ainai, yaliyaya miyamiya vateyaina hilobai. ");
INSERT INTO kud2014_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","‘Na ebe ehebo tupwa ainai hitalatalaigomiu amdena vali dalava ainai. Yawalo moiha mata nigele dalava maudoina Isileli holanai amyapaihowa ve'ovi na yau Tomowa Moihagu yalaoma. ");
INSERT INTO kud2014_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","‘Taumulita nigele howahowana na yana tauve'ita imwala'i gabaei. Dova hinage taupaihowa nigele howahowana na yana taubada iloinaei. ");
INSERT INTO kud2014_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Na hesi inamwanamwa ebe omiu agu taumulitao baidaguwao tatoyatoyawa. Na yau bada yehagu himwauya'o Tomodulele, omiu yagu bodaone howola abo hi'awa yababaegomiu moiha. ");
INSERT INTO kud2014_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","‘Na havena tomowa ammehemeheuhedi, wuwuna ginauliwone dawadawanidi howola abo Yaubada i'abiye mahalavadi na himasele. ");
INSERT INTO kud2014_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Na hava guguyou ainai ya'au'aubabadaeine alimiyai ahubenai amwalo mahalavaedi tomowa maudoidi aidiyai na hava yawalo himhimwedi alimiyai amwalo mahalavaedi yami vatavata ewadiyena. ");
INSERT INTO kud2014_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","‘Na hiya taumiu hi'oi'oiye mwalowoidi havena ammehemeheuhedi wuwuna hiya taumiu howahowana hi'oiye mwalowoi na hesi alu'aluwamiu nigele howahowadi. Hesi Yaubada ammeheuhei, wuwuna ibom howahowana dalava ala'alahina ainai taumiu na alu'aluwamiu iveyababa bwauwedi. ");
INSERT INTO kud2014_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","‘Aba'ita teina, ebe mesimesisi'wa bwau tagimwalaidi adi maiha neta toea ehebo, na hesi Yaubada i'ita'ita avivinidi, na ebe ehebo imwalowoi neta Tamamiu yana nuwatuwu ainaena. ");
INSERT INTO kud2014_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na omiu hinage nigele howahowana na vahu amvahili ehebo ulu'ulu ainai, Yaubada adi bagibagili ihanahanapuidi. ");
INSERT INTO kud2014_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Eeta havena am mehemeheuhi, wuwuna omiu am hae alili, na abo mesimesisi'wa maudoidi. ");
INSERT INTO kud2014_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","‘Ebe yaiyadiwo hiwalo mahalava vehabagu tomowa mehediyai, howola abo galewai yau hinage vehabadi yawalo mahalava Tamagu mehenai. ");
INSERT INTO kud2014_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Na ebe yaiyadiwo hiuvalaegau tomowa mehediyai, yau hinage howola abo galewai Tamagu mehenai yauvalaedi. ");
INSERT INTO kud2014_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","‘Havena amnuwanuwatuwu ebeha nuwadaumwali yalawenama bale'uwai. Nigele, na aleha hinage. ");
INSERT INTO kud2014_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yagu laoma ainai towaho tamana mata ive'alehaei, na hinage waihiu hinana ive'alehaei, na hinage waihiu lawana iva'alehaei, ");
INSERT INTO kud2014_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","na towaho yana huhu hive'alehaei. ");
INSERT INTO kud2014_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","‘Na ebe yaiya tamana yo hinana ivelauwedi mwala'ina na yau iu'iuna, iya nigele howahowana na imulitaegau. Na ebe yaiya natuna towahona bo waihiuna ivelauwei mwala'ina na yau iu'iuna, iya nigele howahowana na imulitaegau. ");
INSERT INTO kud2014_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Na ebe yaiya yawahina nigele iyatalamwei na imwalowoi aiwa lagalagana ainai, dova yau, iya nigele howahowana na imulitaegau. ");
INSERT INTO kud2014_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Na ebe yaiya iya yawahina vehabana ipaipaihowa, howola abo ivesawali. Na ebe yaiya yawahina ivesawali vehabagu, howola abo yawahina namwanamwana ilobai. ");
INSERT INTO kud2014_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","‘Na omiu ebe yaiya ilauvaigomiu, yau na agu tauvetamalene hinage ilauvaigai. ");
INSERT INTO kud2014_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Na ebe owa tauwalo mahalava ulauvai yana walomahalava vehabana, howola abo walomahalava ana maiha ulobai. Na ebe owa towaho namwanamwana ulauvai mumugana namwanamwa vehabana, howola abo towaho namwanamwana ana maiha ulobai. ");
INSERT INTO kud2014_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Na ebe yaiya tauyemidi vauvauna bwahi gwagwama imohei wuwuna iya agu taumulita yawalo auligo howola abo ana maiha namwanamwana ulobai.’ ");
INSERT INTO kud2014_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yeisu yana guguya ana taumulitao hitau 12 aidiyai ive'ovi na tupwanane ilauvehulu ta itata'i'iline dalava ehebo ehebo aidiyai, ive'ita na iloguguya. ");
INSERT INTO kud2014_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Hauga tenem ainai Yoni tau'abiye bapitaiso bada vada abapai ainai himwauwiya'o na Besinana towahona yana paihowa wasana ibenalei ta tupwadi ana taumulitao ivetamaledi hilalaune Yeisu ainai ");
INSERT INTO kud2014_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","na hipanivila hiwalo, ‘Vedova owa Besinana towahonawa vehabam aha'waha'wane bo vali towaho aha'wai?’ ");
INSERT INTO kud2014_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Na yadi walo Yeisu iyemaiha, iwalo, ‘Amwuyo na Yoni ainai am'aubabada ginauliwone aliguwena bada ambenaledi'o na am'itadi'o, neta, ");
INSERT INTO kud2014_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","taumehegibugibu mehedi bada himasele'o daladaladi bada hinamwanamwa'o ta hilaulau, taulepelo taudi bada hinamwanamwauyo'o na talina 'waba'wabalidi bada walo hibenaledi'o, taumwalowoi hitowolouyo, na hinage wewelohe wasa namwanamwana bada hibenalena'o. ");
INSERT INTO kud2014_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yaiya nigele vehabagu iyanuwatuwu bwaubwau iya mata iyaliyaya.’ ");
INSERT INTO kud2014_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Haugana Yoni ana taumulitao hilaulau gwaipile, Yeisu ivetuwuni na boda aidiyai Yoni vehabana i'au'aubabada, iwalo, ‘Mwalona maudoimiu tupwa balabala awawai amlau Yoni habi benaleina, na hava nuwanuwamiu ebeha am'ita? Nuwana yami nuwatuwu ehebo gwelugwelulu yaumai inu'unu'uvi am'ita, bo? ");
INSERT INTO kud2014_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nuwana ehebo towaho ana ale'o wasawasa habi itana? Nigele, wuwuna hiya ma'adi ale'o wasawasa tauloina mwala'idi yadi tupwai himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","‘Na hava yede vehabana amlalaune balabala awawai? Nuwana yami nuwatuwu ebeha mata ehebo tauwalo mahalava am'ita, awa? Yawalo moiha, towahone am'i'itane tauwalo mahalavao maudoidi imwala'i gabaedi. ");
INSERT INTO kud2014_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yoni vehabana mwalona Yaubada yana walo Buki Ve'ahihi ainai teina dova iwalo mahalava, iwalo: “Teina yagu tauyewasa yavetamale mugaiyei na yam amwaha isepa”.’ ");
INSERT INTO kud2014_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Na Yeisu hinage i'aubabada iwalo, ‘Moiha, Yoni tau'abiye bapitaiso, iya taumiya bale'u maudoidi imwala'i gabaedi, na hesi maudoidi hiya Yaubada yana Abaloina holanai Yoni himwala'i gabaei. ");
INSERT INTO kud2014_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","‘Haugana Yoni tau'abiye bapitaiso yana hauga ainai ta ilaoma wau, tauwahiyala yadi wahiyalaena Yaubada yana Abaloina holanai hiluwuluwu. ");
INSERT INTO kud2014_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mwalona tauwalo mahalava maudoidi yadi walowo yo Mosese yana loinao aidiyena waloyemidi hiwalo mugaiyedi ta ana higa Yoni ilaoma. ");
INSERT INTO kud2014_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na ebe nuwanuwamiu amnuwamasele Yoni vehabana, amhanapui ebeha iya Elaitiya ta'i vehabana amha'waha'wane. ");
INSERT INTO kud2014_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Na ebe yaiya matalinana walo teina ibenaledi. ");
INSERT INTO kud2014_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","‘Omiu teina yasone vedova ebe yayepateyegomiu? Nuwana yawalo omiu bada ta'i dova hedaheda maketi holanai hi'ai'ai'opi'opi na adi geluwo aidiyai hiwuiwui, hiwalo: ");
INSERT INTO kud2014_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ama geluwo vedova ta ai alaulauhi sinaha na nigele amyasobune? Na hinage a'ala'alagumgum, na nigele amyadoune?” ");
INSERT INTO kud2014_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","‘Waloyepatu teina ana hanapu ebeha Yoni ilaoma na nigele iya'ai na nigele iyanuma, na amwalo, “Ebeha alu'aluwa yababana Yoni i'abiye yauyauleya'o”. ");
INSERT INTO kud2014_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Na yau Tomowa Moihagu yalaoma, ya'ai'ai na yanumanuma na hinage vehabagu am'ulu'ulumiyai, amwalo, “Towaho teina tau'ai na taunuma ala'alabili, na hinage takesi ana tauvaiwo yo tupwadi hinage tauyababao nuwana taupwanoliwo ive'au'augeluwedi”. Na hiya tauhanapu moiha howola abo yadi paihowa namwanamwadi aidiyena hanapu moiha himahalava.’ ");
INSERT INTO kud2014_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Na Yeisu dalavadine aidiyai yana paihowa wahiwahiyalana hi'itadi na nigele hiyanuwabui yadi pwanoliwo aidiyena, hiya vehabadi i'ahoni, na iwalo, ");
INSERT INTO kud2014_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","‘Aiyoi Kolasiniwo! Aiyoi Bedesaidawo! Atemuyamuyamiu ta'i. Wuwuna abanuwapwanopwanowo bada yapaihowaidi'o alimiyai, na hesi nigele amyanuwabui, na ebe Taya yo Saidoni aidiyai yapaihowa mugaiyei, nuwana mwalona ebe bada hinuwabui'o, ta maudoidi sibauwa adi ale'o hili'wadi yo pwa'ahu aidiyena hilopwa'ahuyoidi, na hive'itaedi ebeha mumugadi yababadi aidiyena bada hinuwabui'o. ");
INSERT INTO kud2014_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Na hesi omiu nigele, ainaena Yaubada yana lauvetala ana ahubena ainai Yaubada mata Tayawone yo Saidoniwone i'atemuyamuyaedi, na omiu nigele. ");
INSERT INTO kud2014_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","‘Na Kapeneumiwone omiu vedova? Ebeha ambom am'abihinigomiu galewai, awa? Nigele! Na hesi mata Bwebweso duyanai higabae aituluwegomiu, wuwuna abanuwapwanopwanowo bada yapaihowaidi'o alimiyai. Na hesi nigele amyanuwabui. Na ebe Sodoma aidiyai yapaihowa mugaiyei nuwana mwalona bada hinuwabui'o, ainaena Yaubada nigele iyalamanidi, na wau yadi dalavane imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Eeta Yaubada yana loina ana ahubena ainai, mata Sodomaone i'atemuyamuyaedi, na omiu nigele.’ ");
INSERT INTO kud2014_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Hauga tenem ainai Yeisu iwalo, ‘Yauwedo Tamagu, owa galewa na bale'u adi tauloina, hanapu teina udadawanine tauhanapuwo yo taunuwamaselewo aidiyena, na hesi taunuwapwanopwanowo aidiyai uve'itaedine. ");
INSERT INTO kud2014_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Moiha ta'i Tamagu, yam nuwatuwu teina namwanamwana.’ ");
INSERT INTO kud2014_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Na hinage iwalo, ‘Ginauli maudoina bada Tamagu nimaguwai imwaudi'o, na Tamagu ibom ihanapuigau'o, na yau hinage Tamagu yahanahanapui, na hinage ebe yaiyadiwo nuwanuwagu na Tamagu yave'itaei aidiyai, hiya hinage Tamagune hihanapui. ");
INSERT INTO kud2014_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","‘Eena omiu yaiyadiwo ami ava'avala yo yami paihowa vitaina, amlaoma aliguwai, na yave'aiyawasigomiu. ");
INSERT INTO kud2014_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Na omiu amve'ao'aonaegau ta baidaguwao tapaihowa, na ainaena alu'aluwamiu yadi aiyawasi hilobai, wuwuna yau mumugagu hegohegoyana yo taunuwadobi. ");
INSERT INTO kud2014_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Eena paihowa yo ava'avala yamohegomiu, malamalaidi.’ ");
INSERT INTO kud2014_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tapwalolowai Yeisu mayana taumulitao tanovi holanaena hilaulau, na ana taumulitaone hivahali, ta ai'ai dova pegapega hi'abiloloidi na hi'ai'ai. ");
INSERT INTO kud2014_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Na hauganane Palisiwone hi'itadi, Yeisu hiwalo auline, hiwalo, ‘Taubada, hava vehabana ta am taumulitaone Tapwalolo ana loina hididi'waine?’ ");
INSERT INTO kud2014_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Na Yeisu yadi walone iyemaiha, iwalo, ‘Buki Ve'ahihi ainai hileleya'o Deivida vehabana ebe amvahili, amhanapui ebeha ma'ana geluwo hivahali, ");
INSERT INTO kud2014_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ta Yaubada yana vadai iluwu ta beledi ve'ave'ahihina ivai ta hi'a'aine. Beledinane ma'ana loina, ebeha taupwaoli a'ava adi talam hi'ai na nigele teya yaiya. ");
INSERT INTO kud2014_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Buki Ve'ahihi holanai loina hinage imiyamiya ebeha vada tapwalolo ana taupwaoliwo Tapwalolo ana loina hiho'eho'e, na hesi neta nigele pwanoli. ");
INSERT INTO kud2014_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Yawalo moiha, vada tapwalolo ginauli mwala'ina, na hesi ehebo ginauli mwala'i ali'alilina neta, ");
INSERT INTO kud2014_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yaubada yana walo ebeha, “Pwaoli nigele nuwagu na atemuyamuya hesi”. Ebe walo teina ana hanapu amhanahanapui, havena agu taumulitaone am'awa'awa yababaedi. ");
INSERT INTO kud2014_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Wuwuna yau Tomowa Moihagu, Tapwalolo ana tauloina.’ ");
INSERT INTO kud2014_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tenem ainaena Yeisu ilau ta yadi vada tapwalolo ainai iluwu. ");
INSERT INTO kud2014_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Na nemai towaho nimana giyogiyona ilobai. Na Palisiwone Yeisu ainai hipanivila hiwalo, ‘Taubada, vedova, howahowana na Tapwalolo ainai tomowa ta'abiye namwanamwadi?’ Na hesi yadi panivila teina wuwuna ebeha Yeisu iwalo pwano, na ainaena hive'ewai tauloina mehenai. ");
INSERT INTO kud2014_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Na yadi walo iyemaiha, iwalo, ‘Vedova omiu ebe teya mayana lagulagu ehebo mohimohili, na ahubenane Tapwalolo ainai guda holanai ibe'u, howahowana na iniulihini, bo nigele? ");
INSERT INTO kud2014_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Eena lagulagu ginauli iu'iuna, na tomowa teina ginauli mwala'ina. Tapwalolo ainai howahowana paihowa namwanamwadi tapaihowaidi.’ ");
INSERT INTO kud2014_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Eeta Yeisu towahowa iwalo auline, iwalo, ‘Nimam utuwu’. Na towahone nimanane itautuwu ta inamwanamwauyone, dova hali nimanane. ");
INSERT INTO kud2014_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Eena Palisiwone mayadi modi'ini himahalava na hibom hiloiloina vedova ebe Yeisu hi'oiye mwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Na yadi loina dawanine Yeisu bada ihanapuiya'o, ainaena tupwa tenem ilauvehulu na ilalaune vali tupwai, na tomowa bagibagilidi himulitaei, na tenem ainai taulovala maudoidi i'a'abiye namwanamwadine, ");
INSERT INTO kud2014_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","na hinage iloinaedi havena hiwalowalo mahalavaei tomowa aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yana paihowa teina mwalona Aisaya tauwalo mahalava Yaubada yana walo iwalo mahalava mugaiyei, iwalo: ");
INSERT INTO kud2014_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‘Am'ita yagu taupaihowa teina ita'itasipwana na ateguwena yavelauwei mayagu yaliyaya. Alu'aluwagu yamwauwi ainai na loina dumwadumwaludi iwalo mahalavaedi taumiya ganamuli boda maumaudoidi aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Iya mata nigele iya'awa pa'ipa'i'i bo iyalohalohagali, bo dalava holanai iya'au'aubabada alinana mwala'inaena. ");
INSERT INTO kud2014_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tautapitapiya yadi digona lotalotagodudi nigele mata iyata'wata'wataedi. Na hinage wodam butabutana nigele mata iyagabaei, ana higa ibom ainaena loina dumwadumwaluna iwahiyala, ");
INSERT INTO kud2014_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","yo hinage iya yehanaena taumiya ganamuli boda maumaudoidi hiyemidi.’ ");
INSERT INTO kud2014_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ehebo towaho, mwalona alawai yadi paihowaena mehena higigibuine, na hinage memenana hibui, eeta hilawei Yeisu ainai na i'abiye namwanamwane, na mulitai towahonane ivetuwuni na i'aubabada na ivinunu. ");
INSERT INTO kud2014_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ainaena tomowa bagibagilidi nuwadi ipwanopwano na hiwalo, ‘Towaho teina Besinana towahona, Deivida yana huhuwena, nuwana?’ ");
INSERT INTO kud2014_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Na Palisiwone paihowa teina wasana hibenalei na hiwalo, ‘Nigele, na hesi alawaiwowa yadi taubada Tomodulele yana wahiyalaena alu'aluwa yababadi igebegebe mahalavaedi’. ");
INSERT INTO kud2014_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Na Yeisu yadi nuwatuwu bada ihanapuiya'o ta iwalo aulidi, iwalo, ‘Tomodulele iya ana geluwo nigele hiyagebe mahalavaedi’. Na hinage iwalo, ‘Ebe ehebo abaloina ainai tomowa hiwahewahei na hibom hilolo'alehauyoidi, mata abaloinanane itapiya na ibe'u. Dalava nuwana huhu hinage dova, ebe wahei imahalava, howola abo hitapiya na hibe'u. ");
INSERT INTO kud2014_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tomodulele hinage dova, ebe mayana bodao hibom hilolo'alehauyoidi mata yana abaloinane ibe'u. ");
INSERT INTO kud2014_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Bada amwalo'o ebeha yau Tomodulele yana wahiyalaena alu'aluwa yababadi yagebegebe mahalavaedi, eeta yaiya yede yana wahiyalaena omiu ami geluwo higebegebe mahalavaedine? Tomodulele ainaena, bo nuwana Yaubada ainaena? Teina vehabana amnuwanuwatuwu na ebe amhanapui yau yaiya. ");
INSERT INTO kud2014_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Na ebe Yaubada Alu'aluwana yana wahiyalaena alu'aluwa yababadi yagebegebe mahalavaedi, ainaena amhanapui ebeha Yaubada yana Abaloina bada imahalava'o alimiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","‘Aba'ita towaho wahiwahiyalana yana vadai. Nigele howahowana na yaiya teya iluwu na yana tobwatobwa ivaidi, na hesi ebe ehebo towaho balavaiyena tauwahiyalane nimanane yo aenane ipai mugaiyedi na abo mulitai howahowana iluwu vadai ta yana tobwatobwane ivaidi. ");
INSERT INTO kud2014_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","‘Ebe yaiyadiwo nigele hiyahaguhaguigau, hiya agu alehao. Na hinage yaiyadiwo hiya nigele baidaguwao ayapaipaihowa toyatoyawa, hiya yagu paihowa hi'abi'abiye yababa. ");
INSERT INTO kud2014_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Eena teina yawalo ili'ilimani alimiyai ebeha tomowa yadi pwanoliwo yo yadi walo yababadi maudoina Yaubada mata inuwahamuidi. Ebe Alu'aluwa Ve'ahihi hi'awa yabayababaei, mata nigele Yaubada iyanuwahamuidi. ");
INSERT INTO kud2014_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Yau Tomowa Moihagu na ebe yaiya i'awa yabayababaegau Yaubada mata walonane inuwahamui, na ebe yaiya Alu'aluwa Ve'ahihi i'awa yabayababaei nigele howahowana Yaubada inuwahamui, hauga teina ainai na hauga hilalaoma aidiyai.’ ");
INSERT INTO kud2014_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yeisu hinage iwalo aulidi, iwalo, ‘Aiwa ebe ausalana, ainona hinage namwanamwana, na ebe aiwa newanewalina, ainona hinage yababadi. Eeta aiwa ehebo ehebo ainodi aidiyena ta'ita'ita lobaidi. ");
INSERT INTO kud2014_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","‘Omiu tauyababao dova weso natunao, ainaena nigele howahowana na walo namwanamwadi am'ataidi, wuwuna maudoimiu yababamiu, na hinage yami nuwatuwuwone hava dova atemiyai himiyamiya hauga maudoina awamiyena himahamahalava. ");
INSERT INTO kud2014_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Wuwuna towaho namwanamwana atenaena ginauli namwanamwadi himahamahalava, na towaho yababana atenaena ginauli yababadi himahamahalava. ");
INSERT INTO kud2014_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","‘Na yawalo alimiyai ahubenanane Yaubada yana lauvetala ana hauga ainai omiu yami walo yababao maudoidi vehabadi Yaubada ipanivilaegomiu na vehabadi amwalo mahalavaedi. ");
INSERT INTO kud2014_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Yam walo aidiyena Yaubada abo i'awa namwanamwaego bo i'awa yababaego.’ ");
INSERT INTO kud2014_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Eeta loina ana tauve'itao yo tupwana Palisiwo Yeisu hiwalo auline, hiwalo, ‘Tauve'ita, nuwanuwamai ebe ve'ive'ila ehebo upaihowai na a'ita’. ");
INSERT INTO kud2014_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Na Yeisu iwalo, ‘Yaso teina omiu yababamiu na mehemehe'ayomiu, neta wuwuna ve'ive'ilala ambehabeha na ebeha aidiyena amhanapu ili'ilimanigau ebeha Yaubada ainaena yalaoma, na mata nigele ve'ive'ilalaone amya'itadi. Na hesi tauwalo mahalava Yona vehabana amnuwatuwu avivini, iya ve'ive'ilalaede vehabamiu, ");
INSERT INTO kud2014_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","wuwuna Yona ahubena tonuga na boniyai tonuga aidiyai yama mwala'ina diyanai imiyamiya, na yau Tomowa Moihagu hinage dova ahubena tonuga na boniyai tonuga bale'u holanai mata yamiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","‘Howola abo Yaubada yana lauvetala ana ahubena ainai mata Ninevaone hitowolo na yasomiune teina hive'ewaigomiu, wuwuna Yona Ninevaone aidiyai iguguya na mumugadi yababadi aidiyena hinuwabui, na yawalo auligomiu teina ainai towaho teya ihae alili abo Yona. ");
INSERT INTO kud2014_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Hinage dova alawata tupwa yalasi ainaena ilaoma Solomoni yana walo hanahanapu habi benaleina, na howola mata Yaubada yana lauvetala ana ahubena ainai itowolo na omiu teina yasone ive'ewaigomiu, wuwuna iya amwaha daodaowena ilau Solomoni yana walo hanahanapu habi benaleina. Na yawalo auligomiu, teina ainai towaho teya ihae alili abo Solomoni. ");
INSERT INTO kud2014_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","‘Ebe alu'aluwa yababana towaho ehebo holanaena imahalava, mata towahonane inamwanamwa, na alu'aluwa yababanane imahalava maseleyai ilowolowouhi na yana aba'aiyawasi ibehabeha na ebe nigele iyalobai. ");
INSERT INTO kud2014_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Mata alu'aluwanane ibom ainai iwalo, “Nuwana ana ita dova yalau gwaipileuyo yagu abamiyawa mugamugainawa ainai”. Eeta ilau gwaipile ta abamiyanawa ilobai wagawaga a'avana na masemaselena yo atu'atububunina. ");
INSERT INTO kud2014_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Na ainaena ilau ta alu'aluwa hitau 7 yababa alilidi ilauvaidima ta baidanao hiluwu abamiyawa holanai himiya na abo hi'abi'abiye yababa ilimani, mwalona nigele dova. Omiu yasone teina dova na mata yami yababa himwala'i alili.’ ");
INSERT INTO kud2014_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yeisu howola boda aidiyai i'au'aubabada na hinana yo tahinao hilaoma ta maseleyai hitowotowolo na hibehabeha vedova ebe ainai hi'aubabada. ");
INSERT INTO kud2014_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Eeta ehebo towaho alinadi ilawei Yeisu ainai, na iwalo, ‘Tahimwone, hinamne baidadi nuwanuwadi na ebeha am'aubabada’. ");
INSERT INTO kud2014_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Na Yeisu towahonane yana walo iyemaiha, iwalo, ‘Yaiya yede hinagu na yaiyadiwo tahiguwone?’ ");
INSERT INTO kud2014_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Eena ana taumulitaone i'ainima veleleyedi na iwalo, ‘Omiu teina hinaguwowede yo tahiguwowede. ");
INSERT INTO kud2014_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Wuwuna ebe yaiyadiwo Tamagu galewai yana nuwatuwu himulimulitaedi, hiya tahiguwao nuhuguwao hinaguwao’. ");
INSERT INTO kud2014_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ahubena tenem ainai Yeisu vadane ainaena imahalava ta idobi le'awai imimiyane. ");
INSERT INTO kud2014_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Eena boda mwala'ina hitau'ahaiyama ainai, ta ehebo waga i'ava'avai ainai igelu ta imiyamiya, na bodaone le'awai hitowotowolo. ");
INSERT INTO kud2014_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Na ve'ita bagibagilidi ive'itaedi walo vegevegediyena, iwalo, ‘Taupaihowa ehebo yana tanovi ainai ilau, ta patu ivehulu budebudeyanaei, ");
INSERT INTO kud2014_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ta tupwadi patune amwaha papalinai hibebe'une, ainaena lowolowo hi'itadi ta hi'aitulu na hi'a'aidine. ");
INSERT INTO kud2014_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Na tupwadi patu toputopu malagaigaimana ainai hibebe'une, na hi'ini mwayamwayau, wuwuna toputopune nigele iyabado, ");
INSERT INTO kud2014_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","eeta mahana ihinalidi ta hiwewelaine, wuwuna lamlamdi nigele toputopu gwagwamana hiyalobai. ");
INSERT INTO kud2014_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Na tupwadi patu haihaili womawomalina aidiyai hibebe'une ta hi'ini toyawa na haihailine iwahiyala ta ihailiye mwalowoidine. ");
INSERT INTO kud2014_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Eena tupwadi patu toputopu namwanamwana ainai hibebe'une, na hi'ini na himwala'i ta hi'aino, eeta tupwadi ainodi hibagibagili alili, na tupwadi ahipuwai, na tupwadi nigele hiya'aino ili'ilimani. ");
INSERT INTO kud2014_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ebe matalinamiu walo teina ambenalei.’ ");
INSERT INTO kud2014_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Na ana taumulitao hilau ta Yeisu ainai hiwalo, ‘Hava wuwuna walo vegevegediyena bodaone aidiyai uve'ive'itane?’ ");
INSERT INTO kud2014_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ainaena Yeisu iwalo, ‘Omiu Yaubada yana Abaloina holana moiha ana tauhanapuwo, na boda teina nigele. ");
INSERT INTO kud2014_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ebe yaiyadiwo dova mayadi nuwamasele, mata abihepoi mwala'i alilina hilobai, na hesi ebe yaiyadiwo nigele yadi nuwamasele na hava nuwana aidiyai imiyamiya mata maudoina hivesawalidi. ");
INSERT INTO kud2014_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Teina wuwuna ta walovegevegedi yave'ita aidiyai, wuwuna yadi vinunu aidiyena nigele hiya'ita ili'ilimani, na hinage yadi benali aidiyena nigele hiyanuwamasele. ");
INSERT INTO kud2014_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","‘Tomowa teina vehabadi mwalona tauwalo mahalava Aisaya iwalo mugayedi, iwalo: “Mata ambenalei na nigele nuwamiu hiyamasele. Na hinage mata am'ita, na mata nigele nuwamiu hiyamasele. ");
INSERT INTO kud2014_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Wuwuna tomowa teina nuwadi hipwanopwano, ta talinadi hi'wabali'o, na hinage mehedi higibu'o. Mata dova ta mehediyena hi'ita, na talinadiyena hibenali na hinuwamasele, na aliguwai hi'ita gwaipile, ta ya'abiye namwanamwadi.” ");
INSERT INTO kud2014_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","‘Na omiu mayami yaliyaya, wuwuna mehemiyena am'itaya'o na talinamiyena ambenalena'o. ");
INSERT INTO kud2014_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Yawalo moiha, ginauli teina am'ita'itadine na ambenabenaledine mwalona tauwalo mahalava yo taudumwadumwaluwo nuwanuwadi mwala'ina ebe hi'itadi yo hibenaledi, na nigele hiyalobaidi. ");
INSERT INTO kud2014_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","‘Ainaena patu ana vehulu budebudeyana ana hanapu ambenalei. ");
INSERT INTO kud2014_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ebe yaiya Yaubada yana Abaloina aubabadana ibenali mohilei, na nigele iyanuwamasele, mata howola abo tauyababawa ilaoma na walowowa towaho atenaena ivaivehuludi. Neta patuwa hibebe'une amwaha papalinai ana masele. ");
INSERT INTO kud2014_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Na hinage patuwowa toputopu malagaigaimana ainai hibebe'une neta hiya wasa namwanamwana hibenalei ta mayadi yaliyaya hitalam, ");
INSERT INTO kud2014_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","na hesi nigele lamlamdi hiya yaiyai ainaena hauga ahu'ahubalina ta'i ainai himiyamiya, na ebe aiteya hauga ainai wasa namwanamwana ana yemidi vehabana vitai bo aleha hilobai mata hibe'u mwayamwayau. ");
INSERT INTO kud2014_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Na patuwowa haihaili talitalina aidiyai hibebe'uwa hiya wasa namwanamwana hibenalei na hesi yadi nuwatuwu bale'u vehabana, na hinage wasawasa ana hamwawo aidiyena wasa namwanamwana hiyemwalowoi, ainaena nigele howahowana na hi'aino. ");
INSERT INTO kud2014_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Na patuwa toputopu namwanamwadi aidiyai hibebe'uwa hiya wasa namwanamwana hibenalei na ana nuwatuwu aidiyai imiyamiya ta ainodi namwanamwadi imwauwidi. Tupwadi ainodi bagibagili alilidi, na tupwadi ahipuwai na tupwadi nigele hiya'aino ili'ilimani.’ ");
INSERT INTO kud2014_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Na walovegevegedi ehebo hinage Yeisu imohedi, iwalo, ‘Yaubada yana Abaloina bada dova ehebo towaho patu namwanamwadi yana tanoviyai ivehuludi. ");
INSERT INTO kud2014_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Na boniyaiyena hi'eno i'iwahi'o na ana aleha ehebo ilaoma tanoviyai na awahi ana ita ehebo dova patu hinage ivevehuludine patu mohiliwa holadiyai, na mulitai ilalaune. ");
INSERT INTO kud2014_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Na maudoidi hi'ini ta hi'aino na taubadane yana taupaihowao awahiwone hi'ita lobaidi. ");
INSERT INTO kud2014_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","‘Eena taupaihowaowa hilaoma ta hiwalo auline, “Taubada, patu namwanamwana yam tanovi holanai mwalona tavehuludi, na vedova ta awahi baidadiyao hi'ini ovi'ovine?” ");
INSERT INTO kud2014_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘Na tanovi taniwagana iwalo, “Nuwana agu aleha ehebo ivevehuludine”. ‘Na yana taupaihowao hiwalo, “Vedova? Howahowana ebe awahine adavaidi?” ");
INSERT INTO kud2014_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Na taubadane iwalo, “Badagi! Ammwauwi ta hi'ini ehebo, wuwuna ebe amtowoi na awahi amdavaidi, mata tupwana patu hinage baidadi amdavai eheboidi. ");
INSERT INTO kud2014_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Na hauganane laulau'eli hesi ainai taupaihowa yaloinaedi ta awahi hitano'ahai mugaiyedi ta hi'uinidi na higabuvehuludi, abo patu hitano'ahaidi ta yagu vadavada holanai hihiwahinidi.” ’ ");
INSERT INTO kud2014_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ehebo hinage walovegevegedi imohedi, iwalo, ‘Yaubada yana Abaloina bada dova magimagi patuna ehebo towaho ivai na tanovi holanai i'u'umaine. ");
INSERT INTO kud2014_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Magimagi patuna iu'iuna ta'i na yana ini tuluhanai ive'aiwa yo ainaena lowolowo hilaoma na lagalagana aidiyai yadi noi hi'abidi.’ ");
INSERT INTO kud2014_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ehebo hinage walovegevegedi imohedi, iwalo, ‘Yaubada yana Abaloina dova pwalawa ana aba'abiye seseha. Iu'iuna ta'i waihiu ivai na pwalawa mwala'ina baidana ivivilaine, na maudoina isesehane.’ ");
INSERT INTO kud2014_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yeisu yana aubabada teina maudoina walovegevegedi aidiyena tomowa ive'itadi, wuwuna ibom hauga maudoina walovegevegediyena ive'ive'ita tomowa aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Teina ainaena tauwalo mahalava yana waloyemidi imahalava, neta mwalona iwalo mahalava mugai, iwalo: ‘Walo vegevegediyena ya'aubabada, na hava Yaubada imwau dawanidi bale'u ana paihowa vegai ainaena yawalowei’. Awahi yana paihowa ana hanapu. ");
INSERT INTO kud2014_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Na Yeisu boda itauvehuludi ta iluwu vadai, na ana taumulitao hilaoma na ainai hiwalo, ‘Walovegevegedi awahi tanovi ainai ana hanapu ulivahi ta anuwamaselei’. ");
INSERT INTO kud2014_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Na Yeisu iwalo, ‘Patune ana tau'uma neta yau Tomowa Moihagu, ");
INSERT INTO kud2014_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","na tanovine neta bale'u maudoina, na patu namwanamwadi neta hiya Yaubada yana Abaloina ana taumulitao, na awahi neta hiya yababana ana taupaihowao, ");
INSERT INTO kud2014_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","na awahi ana tauvehulu budebudeyana neta ada alehane, iya Tomodulele, na hauga laulau'eli neta hauga yana aba'ovi, na taulau'eliwo hiya tausagenawasa, ");
INSERT INTO kud2014_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","na hauga ana aba'ovi ainai tauyababao hiya dova awahi hitano'ahaidi ta higabu vehuludi. ");
INSERT INTO kud2014_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Na yau Tomowa Moihagu yagu tausagenawasao yavetamaledi ta yababana ana tauve'itao yo ana taupaihowao hitano'ahaidima ta yagu abaloina ainaena, ");
INSERT INTO kud2014_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","higabae mahalavaedi aiwa ala'alahina holanai, neta tupwane ainai tomowao hidou na saladi hivetau'alahedi muya mwala'ina ainaena. ");
INSERT INTO kud2014_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yo mulitai taudumwadumwaluwo Tamadi yana abaloina holanai himasele, dova mahana ihinahinali. Ebe yaiya matalinana ibenalei. ");
INSERT INTO kud2014_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","‘Yaubada yana Abaloina bada dova wasawasa tobwatobwa mwala'ina, toputopu holanai. Na ehebo towaho ilobai, na idawaniuyoi. Ainaena mayana yaliyaya ilau ta yana tobwatobwa maudoina igimwalaedi, na adi maiha ivai na toputopunane igigimwalaine. ");
INSERT INTO kud2014_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","‘Yaubada yana Abaloina dova giniuba mehena namwanamwana imiyamiya na tomowa ehebo yana venuwa ebe bada ta'i ilobai. ");
INSERT INTO kud2014_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Eeta yana tobwatobwa igabaedi ta aivelahena giniuba mehena namwanamwa alilina ivai. ");
INSERT INTO kud2014_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","‘Na Yaubada yana Abaloina bada dova vinaya tomowa hiyahuwei ni'uwai, vali yama yo vali yama hi'onadi, ");
INSERT INTO kud2014_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","na vinayanane imwau yabayababa moiha ta hiniulihini magumaguwai, na himiya, na yama maudoina hive'ahadi, ta yama namwanamwadi gaeba aidiyai himwauwidi na yama yababadi higabaedi. ");
INSERT INTO kud2014_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Dova hinage, hauga yana aba'ovi ainai, tausagenawasao hilaoma ta tauyababao hive'ahadi na hiwaheidi taunamwanamwa aidiyena, ");
INSERT INTO kud2014_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ta higabae mahalavaedi aiwa ala'alahina holanai, na ainai hidoudou na saladi hivetau'alahedi muya ainaena.’ ");
INSERT INTO kud2014_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Na Yeisu ipanivilaedi, iwalo, ‘Vedova, walovegevegedi teina bagibagilidi amhanapuidi'o?’ Na hitalam, hiwalo, ‘Ehe!’ ");
INSERT INTO kud2014_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Na aidiyai iwalo, ‘Teina ta'i amhanapui ebeha loina ana tauve'itao ebe Yaubada yana Abaloina himulitaei, hiya dova ehebo henala taniwagana yana tobwatobwa miyamiyadi na vauvaudi imwau hinidi yana vada ainaena’. ");
INSERT INTO kud2014_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yeisu yana walovegevegedi teina ive'ovidi, na tupwa tenem ilauvehulu, ");
INSERT INTO kud2014_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ta iwuwuyone yana dalavai, na yadi vada tapwalolo ainai iluwu ta ive'ive'ita, na tomowa nuwadi ipwanopwano na hiwalo, ‘Towaho teina havaena yana hanapu yo yana paihowa wahiwahiyaladi ivavaidine?’ ");
INSERT INTO kud2014_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Na hinage hiwalo, ‘Towaho teina iya taulaulau'abi natuna? Na hinana Meli, na tahinao Yemesa yo Yosepa yo Saimoni yo Yudasa, ");
INSERT INTO kud2014_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","na hinage nuhunao baidadao tamiyamiya. Na vedova ta towaho teina ihahanapu aliline?’ ");
INSERT INTO kud2014_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ainaena hisosomanaei, na Yeisu iwalo aulidine, iwalo, ‘Tauwalo mahalava adi ve'ahihi hilobai vali dalavao aidiyai. Na yana dalavai yo yana huhuwo nigele hiyave'ahihiyei.’ ");
INSERT INTO kud2014_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ainaena Yeisu nemai yana paihowa wahiwahiyaladi nigele bagibagilidi iyapaihowaidi, wuwuna nigele hiyayemidiyei. ");
INSERT INTO kud2014_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Hauga tenem ainai Helodi iya Galili ana Tauwasawasa, Yeisu yana paihowa wasana ibenalei, ");
INSERT INTO kud2014_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","na yana taupaihowao iwalo aulidi, iwalo, ‘Nuwana towahone iya Yoni tau'abiye bapitaiso bada ebeha mwalowoiyena itowolouyo ta wahiyala teina ipaipaihowaine’. ");
INSERT INTO kud2014_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Wuwuna mwalona Helodi Yoni i'abi avivini na ipai ta vada abapai ainai imwamwauwine. Na Yoni ana abimomohi ehebo waihiu yehana Helodiyasa neta Helodi tahina Pilipi asolena, ");
INSERT INTO kud2014_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","na Helodi ihaloi ta itatawaholaine, na Yoni Helodi iwalo auline, iwalo, ‘Neta nigele mumuga namwanmawana wuwuna tahim mwanena utatawaholaine’. ");
INSERT INTO kud2014_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Neta wuwuna Helodi nuwanuwana Yoni i'oiye mwalowoi, na hesi tomowa bagibagilidi Yoni hi'awa tauwalo mahalavaei, eeta Helodi imeheuhi ta nigele Yoni iya'oiye mwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mulitai Helodi yana ahubena abalabahina ana abanuwatuwu avivini guyauna ainai tomowa bagibagilidi hitau'ahaiyama, na Helodiyasa natuna waihiuna boda mehediyai iselo na Helodi i'abiye yaliyaya. ");
INSERT INTO kud2014_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Na Helodi vahalane ainai iwalovelau yo ebeha hava nuwanuwana imohei ta'i, na hinage i'awa tamada. ");
INSERT INTO kud2014_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Eeta hinanane iwalo vahalawa ainai ta ainaena vahalawa Helodi iwalo auline, iwalo, ‘Nuwanuwagu Yoni tau'abiye bapitaiso ulu'uluna gaeba ainai umwauwi na umohegau’. ");
INSERT INTO kud2014_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Eeta Helodi nuwana iyababa mwala'ina. Na hesi yana awatamadawa vehabana inuwatuwu avivini, na boda bada yana walo hibenalena'o, eeta italam, ");
INSERT INTO kud2014_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","na yana taupaihowao ivetamaledi vada abapaiyai, ta Yoni gadona hitotomne, ");
INSERT INTO kud2014_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","na ulu'uluna gaebai hido'oi ta hilawenama, na vahalawa himomoheine. Na vahalawa ivai ta ilalaweine hinanane ainai. ");
INSERT INTO kud2014_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Na Yoni ana taumulitao hilaoma ta Yoni tauna hivai ta himamagaiyeine, na mulitai hilau Yeisu ainai na ginauli teina hiwalo mahalavaei. ");
INSERT INTO kud2014_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Na Yeisu ginauli teina ibenaledi, ainaena imahalava ta wagai igelu ta ilalaune balabala awawai. Na bodaone Yeisu yana lau wasana hibenalei, eeta yadi dalava aidiyena himahalava ta amwahaena hilalaune Yeisu ainai. ");
INSERT INTO kud2014_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Na hauganane Yeisu wagaena i'aitulu maguwai boda mwala'ina i'i'itadine, na atemuyamuyaena tau'asi'asiyebwao i'abiye namwanamwadi. ");
INSERT INTO kud2014_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Na lavilaviyena ana taumulitaone Yeisu hiwalo auline, hiwalo, ‘Taubada, tupwa teina balabala awawa na mata iguguyou. Na boda teina uvetamaledi ta hilau, na adi higimwala dalava vahalidiyai.’ ");
INSERT INTO kud2014_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Na Yeisu iwalo, ‘Havena hilaulau, omiu hesi ai'ai ammohedi ta hi'ai’. ");
INSERT INTO kud2014_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Eena hiwalo, ‘Ya! Amaine nigele bahuna, neta bada beledi nima ehe'ehebo na yama bwau.’ ");
INSERT INTO kud2014_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Na Yeisu iwalo, ‘Beledine yo yamane ammohegau’. ");
INSERT INTO kud2014_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Na bodaowa iloinaedi ta awahine ainai himimiyane na beledi nima ehe'ehebo yo yama bwau ivaidi, na i'ita hae galewai, ta ai'aiwone vehabadi i'awa yauwedo, na mulitai itomwahidi, na ana taumulitao imohedi ta hiya tomowa aidiyai higuguyauwedine. ");
INSERT INTO kud2014_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Eena maudoidi hi'ai na hi'ai i'iwahi moiha, na ai'ai hi'ai yetupwa hitano ahaidi, neta boha 12 hi'oiye mwaudi. ");
INSERT INTO kud2014_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tau'aiwone towatowaho a'ava adi bagibagili 5,000 dova, na waiwaihiu yo hedaheda maudoidi nigele hiyavahilidi. ");
INSERT INTO kud2014_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tenem ainaena ana taumulitao iloinaedi ta wagaena higelu yo ebeha himugai vali tupwai. Na iya ebeha tomowa maudoidi ivetamaledi hiwuyo yadi dalavai. ");
INSERT INTO kud2014_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Eeta higelu, na Yeisu boda ivetamaledi, na mulitai ibom oyai ihae habi awanoi Yaubada ainai. Ta bada iboni'o, na Yeisu ibom imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Na ana taumulitaowowa yadi wagane hiwohedobiyei ni'u awawai, na bagodu mwala'ina hilobai ta yadi wagawa igohagoha buibuiyei na hinage yaumai mehediyena ilaolaoma. ");
INSERT INTO kud2014_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Na ahubena yana tupwa ainai Yeisu ni'u ewanaena ilaolaoma ana taumulitao vahalidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tenem ainai ana taumulitaowa Yeisu hi'i'itane ni'u ewanaena ilaolaoma, ta himeheuhi mwala'ina, eeta hiloma'aya'aya, yadi nuwatuwu ebeha alawai hi'i'itane. ");
INSERT INTO kud2014_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Na Yeisu iwalo, ‘Havena ammehemeheuhi! Yau ta'i, bada yami Taubada.’ ");
INSERT INTO kud2014_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Na Pita i'aubabada, iwalo, ‘Taubada, uwalo auligau ta ni'u ewanaena yalaowa alimwai’. ");
INSERT INTO kud2014_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Na Yeisu iwalo, ‘Ulaoma!’ Eeta Pita wagaena i'aitulu na ni'u ewanaena ilaulau Yeisu ainai. ");
INSERT INTO kud2014_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Hauganane ilaulau yaumai mala'ina i'ita, na imeheuhi, ta ni'uwai ihahanenene, na iwui, ‘Taubada, uyayovigau!’. ");
INSERT INTO kud2014_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Na Yeisu ilomwayamwayau ta Pita i'abi avivini na iwalo, ‘Yam yemidi iu'iuna, hava vehabana unuwanuwatuwu bwaubwau?’ ");
INSERT INTO kud2014_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Eena hitau bwauwowa higegelune wagai, na yaumai idaumwali. ");
INSERT INTO kud2014_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Na hiya wagane ana taumiyaone hipwagogo Yeisu ainai, na hiwalo, ‘Moiha ta'i, owa Yaubada Natuna’. ");
INSERT INTO kud2014_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ainaena higeyo'awa tupwa Genesaleta ainai ta hi'a'aitulune le'awai. ");
INSERT INTO kud2014_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Na tupwane ana taumiyaone Yeisu hi'ataiya'o, eeta wasa hivetamaledi dalavaone maudoidi aidiyai ta yadi taulovalovalao maudoidi hilawedi Yeisu ainai, ");
INSERT INTO kud2014_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","na hi'awanoiyei, hiwalo, ‘Taubada, howahowana na taulovalovalaone teina am ale'o papali a'avana hi'abitowoi?’ Na Yeisu italam, ta yaiyadiwo hiya ana ale'o hi'abitowoine hinanamwanamwane. ");
INSERT INTO kud2014_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mulitai Palisiwone na loina ana tauve'itao Yelusalemaena hilaoma Yeisu ainai, na hiwalo auli, hiwalo, ");
INSERT INTO kud2014_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","‘Hava wuwuna am taumulitaone ebe ai i'ovi nigele nimadi hiyauwadine, neta tubudao yadi loina hiho'eho'e?’ ");
INSERT INTO kud2014_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Na Yeisu iwalo, ‘Omiu hinage Yaubada yana loina amho'eho'e, wuwuna tubumiyaone mumugadi ammulimulitaedi. ");
INSERT INTO kud2014_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yaubada yana loina bwau teina, ehebo iwalo, “Tamam yo hinam uve'ahihiyedi”, na bwauna hinage iwalo, “Ebe yaiya tamana nuwana hinana i'awa yabayababaei, ilowoinanei na am'oiye mwalowoi”. ");
INSERT INTO kud2014_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Na omiu yami ve'ita oya'oyama, amwalo, “Ebe yaiya hinana yo tamana iwalo aulidi, iwalo, ‘Yagu tobwatobwa bada yatalamwedi'o Yaubada ainai, nigele howahowana na yahaguigomiu’.” ");
INSERT INTO kud2014_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Eeta neta towahone yana hagu yo yana ve'ahihi tamana na hinana aidiyai i'ovi'o. Tubumiyao yadi loina teina ainaena Yaubada yana walo amveginauli awa'awawaena'o. ");
INSERT INTO kud2014_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","‘Moiha omiu tau'oya'oyama! Mugai tauwalo mahalava Aisaya vehabamiu ilele mugayei, haugana Yaubada yana walo iwalo mahalavaei, iwalo: ");
INSERT INTO kud2014_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Tomowao teina awadiyena hive'ahihiyegau na atediyena nigele, ");
INSERT INTO kud2014_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","na hinage aliguwai hitapwalolo awa'awawa, wuwuna yadi ve'itao yau nigele aliguwena, na hesi tomowa yadi nuwatuwuwena”.’ ");
INSERT INTO kud2014_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Eena tomowa iyogaedi na iwalo, ‘Walo teina ambenalei ta amhanapui ");
INSERT INTO kud2014_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ebeha ai'aiwone awadaena hiluwuluwu nigele howahowana na hi'abiye bi'igita na hesi walo awadaena himahamahalavane hiya hesi hi'abi'abiye bi'igita’. ");
INSERT INTO kud2014_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Na ana taumulitaowowa Yeisu ainai hilaoma na hiwalo, ‘Taubada, bada ubenalena'o ebeha Palisiwowa yam walo teina vehabana hihinimaya?’ ");
INSERT INTO kud2014_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Na Yeisu iwalo, ‘Aiwaowa Tamagu nigele iya'umaidi, mata idavai vehuludi. ");
INSERT INTO kud2014_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Na Palisiwone havena himiyamiya ana higa hibe'u, wuwuna ebe taumugaiwo mehegibugibudi, na adi geluwo mehegibugibudi himugaiyedi, mata maudoidi gudai hibe'u.’ ");
INSERT INTO kud2014_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Na Pita Yeisu ainai iwalo, ‘Walo vegevegedi ana nuwamasele vehabana ulivahi alimaiyai’. ");
INSERT INTO kud2014_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Na Yeisu hinage iwalo, ‘Nuwana omiu hinage howola nigele nuwamiu iyamasele, ");
INSERT INTO kud2014_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ainaena nigele amyahanapui hava awadaena iluwuluwu diyadai, na mulitai ilaulau mohomoho ainai. ");
INSERT INTO kud2014_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Na hesi hava tomowa awadiyena himahamahalava neta atediyena hilaolaoma na hi'abi'abiye bi'idi, ");
INSERT INTO kud2014_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","neta nuwatuwu bi'ibi'idi yo lauwunu yo pwanoli yo mehe'ayo yo aivavali yo walo'oya'oyama yo vehinahinali. ");
INSERT INTO kud2014_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ginauli teina aidiyena tomowa i'abi'abiye bi'idi, na ebe nimada nigele tayauwadi hauga ai ainai neta alu'aluwada mata nigele iya'abiye bi'idi.’ ");
INSERT INTO kud2014_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tenem ainaena Yeisu Isileli tupwanane ilauvehulu na ilalaune Taya yo Saidoni tupwadiyaone aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Na tupwanane ainai Kenani waihiuna ehebo imahalava ta Yeisu iwalo auli, iwalo, ‘Taubada owa Deivida yana huhu, u'atemuyamuyaegau, wuwuna natugu waihiuna bada alu'aluwa yababana i'abiye yauyauleya'o’. ");
INSERT INTO kud2014_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Na Yeisu waihiunane yana yoga nigele iyayemaiha, na ana taumulitaone hilaoma ta Yeisu hi'awanoiyei, hiwalo, ‘Waihiune usosomanaei ta ilau, wuwuna ivetalinagudaguda’. ");
INSERT INTO kud2014_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Na Yeisu iwalo, ‘Yau yalaoma sipi 'wada'wadaleledi Isileli a'ava yana abaloina holanai vehabadi’. ");
INSERT INTO kud2014_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Na hesi waihiunane ilaoma Yeisu mehenai italupwagogo, na iwalo, ‘Taubada uhaguigau’. ");
INSERT INTO kud2014_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Na Yeisu iwalo, ‘Nigele iyadumwalu na hedaheda adi tamohedi edewa aidiyai’. ");
INSERT INTO kud2014_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Na waihiuwa iwalo, ‘Taubada, neta walo moiha. Na edewa hedaheda adi mugumugudi hilemlemhidi.’ ");
INSERT INTO kud2014_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Eeta Yeisu waihiu alinana iyemaiha, iwalo, ‘Waihiu, owa tauyemidi moiha. Ainaena teina hauga yam yemidi ainona imahalava’. Na hauga tenem ainai waihiunane natuna inanamwanamwauyone. ");
INSERT INTO kud2014_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Na hinage Yeisu tupwanane ilauvehulu na ivasane Galili le'awanaena, ta oyai ihae, na nemai imimiyane. ");
INSERT INTO kud2014_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Na boda mwala'ina yadi tau'asiyebwao hihaeyedi Yeisu ainai, hiya daladaladi, yo hiya mehedi gibugibudi yo aedi tapitapiyadi yo buwabuwadi yo vali tau'asiyebwao hinage hiya hilaoma Yeisu aenai himwauwidi ta i'abiye namwanamwadine. ");
INSERT INTO kud2014_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Na bodaowa hi'itadi buwabuwadiyaowa hi'au'aubabada yo aedi tapitapiyadi hiwahiyalauyo yo daladaladi hilaulau dumwadumwalu, yo taumehegibugibu mehedi hi'itanedi. Ainaena bodaowa hiteibaba na Isileli yadi Yaubada hino'owei. ");
INSERT INTO kud2014_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Na Yeisu ana taumulitao iyogaedima na iwawalo aulidine, ‘Boda teina ya'atemuyamuyaedi wuwuna hiya ahubena tonuga teinai baidaguwao amiyamiya ta nigele adi, na nigele nuwagu mavahalidi yavetamaledi yo hiwuyo, mata amwahai himwalowoi’. ");
INSERT INTO kud2014_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Na ana taumulitaone hiwalo auline, hiwalo, ‘Tupwa teina balabala awawa, na boda mwala'ina teina adine mata vedova talobaine?’ ");
INSERT INTO kud2014_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Na Yeisu ipanivilaedi iwalo, ‘Viha ami beledine himiyamiyane?’ Na hiwalo, ‘Beledi 7 na yama tupwadi iu'iudi’. ");
INSERT INTO kud2014_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Eeta boda iloinaedi ta bale'uwai himimiyane. ");
INSERT INTO kud2014_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Na beledi 7 yo yamaowa ivaidi ta vehabadi i'awa yauwedo Yaubada ainai, na i'abitomwahidine na imohedi ana taumulitao ta bodaone aidiyai higuguyauwedine. ");
INSERT INTO kud2014_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Na maudoidi hi'ai na hi'ai i'iwahi na mulitai uleya hitano'ahaidi ta boha 7 hi'oiye mwaudine. ");
INSERT INTO kud2014_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tau'aiwo towatowaho adi bagibagili dova 4,000, na waiwaihiu yo hedaheda bagibagilidi nigele hiyavahilidi. ");
INSERT INTO kud2014_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Mulitai bodaowa ivetamaledi hilalau gwaipilene, na Yeisu wagaena igelu, ta Megadani tupwanai ilalaune. ");
INSERT INTO kud2014_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ehebo hauga ainai tupwadi Palisi yo Sadusi hilaoma na Yeisu hipanivilaei, habi towoina, hiwalo, ‘Howahowana ehebo ve'ive'ilala upaihowai na a'awa moiha ebeha yam wahiyalane Yaubada ainaena ilaoma?’ ");
INSERT INTO kud2014_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Na Yeisu iwalo, ‘Omiu ebe mahana am'ita ilulululuvi na galewai yaloyalovi hihawahawawali, ainaena amhanapui ebeha i'ahubena mahavai namwanamwana. ");
INSERT INTO kud2014_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na ebe malatomtomwai galewa hawahawawalina na guguyou am'ita, neta amwalo ebeha 'wesu ana ve'ive'ilala. Omiu hauga ana oleya vedova na mata galewa am'ita, na amwalo yemidiyedi. Na hesi vedova ta teina haugane Yaubada yana paihowa ainona nigele howahowamiu amwalowei. ");
INSERT INTO kud2014_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yaso teina omiu yababamiu yo mehemehe'ayomiu, neta wuwuna ve'ive'ilala ambehabeha ta ebeha aidiyena amhanapuigau moiha ebeha Yaubada ainaena yalalaomane, na nigele Yona vehabana amyanuwatuwu avivini, iya ta'i ve'ive'ilala vehabamiu.’ Ainaena Yeisu ilauvehuludi na ilalaune. ");
INSERT INTO kud2014_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Eeta vali tupwai higeyogeyo'awa, na ana taumulitaone nigele adi tamahina amwaha vehabana hiyavai, wuwuna hinuwapwanopwanowedi. ");
INSERT INTO kud2014_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Na Yeisu iwalo lau iwalo, ‘Palisiwone yo Sadusiwone adi pwalawa ana aba'abiye seseha ainaena am'ita avivinigomiu’. ");
INSERT INTO kud2014_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Eeta ana taumulitaone hibom aidiyai hiwalo, ‘Nuwana Yeisu yana walo teina wuwuna wau ada tamahinane tanuwapwanopwanoweine’. ");
INSERT INTO kud2014_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Na Yeisu yadi nuwatuwu bada ihanapuiya'o, ta iwawalo aulidine, ‘Hava wuwuna am'au'aubabadane na amwalo, “Nigele ada tamahina”? Nigele ami tamahina vehabana yayawalowalo. Nuwana nigele amyayemidiyegau, awa? ");
INSERT INTO kud2014_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nigele amyanuwamasele hauganane beledi nima ehe'ehebo aidiyena tomowa 5,000 yaveve'aidine, na ai'ai ana tupwa maudoina amtano'ahaidi, na boha ana bagibagili 12 am'o'oiye mwauwidine? ");
INSERT INTO kud2014_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Tomowa hinage 4,000, beledi 7 aidiyena yaveve'aidine na ana tupwa maudoina amtano'ahaidi na boha ana bagibagili 7 hinage am'o'oiye mwauwidine? ");
INSERT INTO kud2014_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Na hava wuwuna ta nigele amyanuwamaselene ebeha nigele ai'ai vehabana yayawalo? Na hesi yawalo vegevegedi Palisiwo yo Sadusiwo yadi aba'abiye seseha ainaena am'ita avivinigomiu.’ ");
INSERT INTO kud2014_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tenem ainai nuwadi imasele ebeha nigele beledi moiha ana aba'abiye seseha vehabana iya au'aubabada, na hesi ebeha Palisiwone yo Sadusiwone yadi ve'itao aidiyena hi'ita avivinidi. ");
INSERT INTO kud2014_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Na Yeisu ilaoma Sisaliya Pilipai tupwanane ainai na ipanivila ana taumulitao aidiyai, iwalo, ‘Vedova tomowa yadi walo ebeha yau Tomowa Moihagu yaiya?’ ");
INSERT INTO kud2014_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ta hiwalo, ‘Tupwadi tomowa hiwalo ebeha owa Yoni tau'abiye bapitaiso, na tupwadi tomowa hiwalo ebeha owa Elaitiya, na tupwadi hiwalo owa Yelemaiya bo nuwana tauwalo mahalava mugamugaina ehebo’. ");
INSERT INTO kud2014_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Na Yeisu ipanivilaedi, iwalo, ‘Na omiu vedova yami nuwatuwu ebeha yau yaiya?’ ");
INSERT INTO kud2014_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Eeta Saimoni Pita iyemaiha na iwalo, ‘Owa Besinana towahona Yaubada Mayawahina Natuna’. ");
INSERT INTO kud2014_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Na Yeisu Pita iwalo auline, iwalo, ‘Saimoni, Yona natuna, owa moiha tauyaliyaya ehebo, wuwuna yam nuwamasele teina nigele tomowa aidiyena, na hesi Tamagu galewai yana hanapu imomohegone. ");
INSERT INTO kud2014_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Eeta yawalo alimwai owa yeham Pita, ana bui gaima, ta mata gaima teina ewanai yagu boda yavetowolodi ta ebe nigele howahowana mwalowoi yana wahiyala i'abi'abitowoidi. ");
INSERT INTO kud2014_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Na hinage abaloina galewai ana abaho'e yamohego, ta ebe hava bale'uwai ugudui, galewai hinage higudui, na hinage ebe hava bale'uwai uho'e, galewai hinage hiho'e.’ ");
INSERT INTO kud2014_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tenem ainai Yeisu ana taumulitao venuwamwau wahiwahiyalana aidiyai imwauwi, iwalo, ‘Havena teya yaiya ainai amwalowalo mahalavaegau ebeha yau Besinana towahona’. ");
INSERT INTO kud2014_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Hauga tenem ainai Yeisu ivetuwuni na ana taumulitao aidiyai ive'ita, iwalo, ‘Ilowoinanei ebe yalau Yelusalem na nemai muya maudoina yalobaidi, tauloinao yo taupwaoliwo mwala'idi yo loina ana tauve'itao aidiyena, na nemai hi'oiye mwalowoigau, na ahubena tonugana ainai Yaubada i'abiye towolouyoigau’. ");
INSERT INTO kud2014_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Na Pita Yeisu ilauvai, ilawei, ta iwawaloweine iwalo, ‘Taubada, ginauli teina havena alimwai imahamahalava!’. ");
INSERT INTO kud2014_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Na Yeisu itowolo gwaipile ta Pita ainai iwalo, ‘Tomodulele, teina ta'i ulauvehulugau! Havena utautau'auhigau! Yam nuwatuwune dova tomowa mohili yadi nuwatuwu, na nigele Yaubada yana nuwatuwu’. ");
INSERT INTO kud2014_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Eeta Yeisu ana taumulitao i'aubabada aidiyai, iwalo, ‘Yaiya ebe nuwanuwana imulitaegau, ilowoinanei ebe iya yana nuwatuwu ita'wata'wataedi, na ibom ana aiwa lagalagana i'avalai, na imwalowoi, neta dova agu mulitane ana amwaha. ");
INSERT INTO kud2014_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","‘Na ebe yaiya yawahina inuwavi, howola abo yawahinane ivesawali. Na ebe yaiya yawahina vehabagu italamwei na imwalowoi, iya mata yawahina namwanamwana ilobai. ");
INSERT INTO kud2014_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","‘Ebe yaiya yana tobwatobwa bagibagilidi na Yaubada yana amwaha inuwapwanopwanowei, neta ginauli awa'awawa, na hesi ginauli mwala'ina neta yawahi namwanamwana. Wuwuna ebe yawahi namwanamwana tavesawali, mata nigele teya hinage maihana iyamiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","‘Howola abo yau Tomowa Moihagu yawuyouyoma, Tamagu yana wasawasa pigapigabuna ainaena yalaoma, na hinage tausagenawasao baidaguwao, ta tomowa yadi paihowa ana maiha yamohedi. ");
INSERT INTO kud2014_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yawalo moiha alimiyai ebeha tomowa tupwamiu mata nigele amyamwalowoi ana higa yau Tomowa Moihagu yagu loina wasawasa ainaena am itauyoigau.’ ");
INSERT INTO kud2014_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ahubena 6 tuluhanai Yeisu ana taumulitao tonuga ilauvaidi, na baidanao hihahaene ehebo oya daodaona ainai. Taumulitaone hiya Pita na Yemesa matahina Yoni. ");
INSERT INTO kud2014_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Hauganane hibom himiyamiya oyai Yeisu manina hi'i'itane pigapigabuna dova mahana ana ita, na ana ale'o hewahewana dova masele i'alahi taohani. ");
INSERT INTO kud2014_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Na tenem ainai Elaitiya yo Mosese himahalavama na Yeisu baidadi hi'au'aubabada. ");
INSERT INTO kud2014_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Na Pita i'apuhini na Yeisu iwalo auline, iwalo, ‘Taubada teina dova yada miyane inamwanamwa, ainaena howahowana ebe utalam gwau tonuga ta'abidi, ehebo owa vehabam, ehebo Mosese vehabana, na ehebo Elaitiya vehabana’. ");
INSERT INTO kud2014_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita yana aubabada howola nigele iyave'ovi na hogahoga maselena itauhamuidine, na hogahogane ainaena alina ehebo hibenalei, iwalo, ‘Teina Natugu yavelauwei, iya vehabana yayaliyaya mwala'ina, ainaena yana walo ambenaledi’. ");
INSERT INTO kud2014_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Na taumulitaowa hitau tonuga alinawa hibenalei ta mayadi meheuhi hitalupwagogo, ");
INSERT INTO kud2014_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","na Yeisu ilaoma i'abitowoidi, iwalo, ‘Amtowolo. Havena ammehemeheuhi’. ");
INSERT INTO kud2014_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Eena hilauta'ai ta Yeisu ibom itowotowolo hi'i'itane. ");
INSERT INTO kud2014_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Eeta oyaena hi'aitulu na Yeisu iloinaedi, iwalo, ‘Ginauliwowa wau am'i'itadine havena tomowa aidiyai amwalowalo mahalavaedi ana higa yau Tomowa Moihagu mwalowoiyena yatowolouyoma’. ");
INSERT INTO kud2014_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Na Yeisu ana taumulitao ainai hipanivila, hiwalo, ‘Hava wuwuna loina ana tauve'itao hiwalo ebeha Elaitiya imugaima na mulitai abo Besinana towahona imahalava?’ ");
INSERT INTO kud2014_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Na Yeisu iwalo, ‘Ehewa, Elaitiya ebeha ilaumugaima ta ebe ginauli maudoina i'abiye dumwaludi. ");
INSERT INTO kud2014_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Na hesi Elaitiyanane bada ilaoma'o, na tomowa nigele hiya'atai na hesi himumuga yababaei hava yadi nuwatuwu dova, mata hinage yau Tomowa Moihagu aliguwai mumugadine dova.’ ");
INSERT INTO kud2014_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ainaena taumulitaone tenem ainai hinuwatuwui ebeha Yeisu Yoni tau'abiye bapitaiso vehabana i'au'aubabadane. ");
INSERT INTO kud2014_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Hauganane Yeisu mayana taumulitao hi'aitulu boda aidiyai, ehebo towaho ilaoma italupwagogo Yeisu mehenai, ");
INSERT INTO kud2014_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","na iwalo, ‘Taubada, natugu u'atemuyamuyaei na u'abiye namwanamwa, wuwuna hauga maudoina manihubu bwadana ivaivai na abi'abivelolo, na tauna himuyamuya mwala'ina, na tupwana hauga aidiyai aiwa ala'alahina aidiyai ibe'ube'u, na tupwana hauga bwahi ni'uni'una aidiyai ihanehanene. ");
INSERT INTO kud2014_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Na am taumulitao aidiyai yalawenama, na nigele howahowadi hi'abiye namwanamwa.’ ");
INSERT INTO kud2014_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Na Yeisu iwalo, ‘Omiu teina yasone vedova? Ainaena ulu'ulumiune yaiyaidi. Nuwana nigele amyayemidiyegau awa? Viha hauga mata yamiya vahaligomiu na yanuwanuwatuwu vehabamiu. Hola gamanane amvaiyama ta ya'ita?’ ");
INSERT INTO kud2014_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Eeta Yeisu alu'aluwa yababanane iloinaei ta manihubu bwadanawa gamane ainaena imamahalavane ta inamwanamwauyone. ");
INSERT INTO kud2014_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mulitai Yeisu ana taumulitao hilaoma na hibom Yeisu baidadi, na hiwalo auli, hiwalo, ‘Taubada, vedova ta ai nigele howahowamai alu'aluwa yababanane agabae mahalavaei’. ");
INSERT INTO kud2014_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Na Yeisu iwalo, ‘Wuwuna yami yemidine hitapiya. Yawalo moiha ebe yami yemidi ana wahiyala dova haiyala patuna, howola oyane tenem ainai amwalo, “Teina ainaena umiyadobi”, ");
INSERT INTO kud2014_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","mata i'awa abi. Dova hinage ginauli maudoina howahowamiu na ampaihowaidi.’ ");
INSERT INTO kud2014_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galili ainai himiyamiya, na Yeisu iwawalo aulidine, iwalo, ‘Yau Tomowa Moihagu, howola abo agu tauhuhula i'aiyauyanegau tomowa nimadiyai, ");
INSERT INTO kud2014_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","na hi'oiye mwalowoigau, na ahubena tonugana ainai Yaubada i'abiye towolouyoigau’. Yeisu yana walomahalava teina vehabana hinuwayababa mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mulitai hilau Kapeneum ainai, na takesi vada tapwalolo vehabana ana tautanowo hilaoma ta Pita ainai hiwalo, ‘Vedova, howahowana na yami tauve'itane itakesi, bo?’ ");
INSERT INTO kud2014_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Na Pita iwalo, ‘Ehe, mata yana takesi imwauwi’. Hauganane Pita iwuyo vadai, Yeisu Pita iwalo auline, iwalo, ‘Saimoni, hava yam nuwatuwu tauloinaone bale'uwai vehabadi? Yaiyadiwo aidiyena takesi hivaivaine? Hibom natudiyao aidiyena, bo vali tomowa aidiyena?’ ");
INSERT INTO kud2014_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Na Pita iwalo, ‘Vali tomowa aidiyena’. Na Yeisu hinage iwalouyo, iwalo, ‘Neta moiha! Na hesi hiya natudiyaone nigele teya adi vitai. ");
INSERT INTO kud2014_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Na havena tata'wata'wata, mata dova alidai hinuwayababa. Ainaena teina ta'i pisilaeni uvai na udobi le'awai ta yama i'aimugai u'atuni, na awanane u'abiye yanali ta holanai mane uvaiyama ta umohedi, neta owa na yau yada takesi, howahowadai.’ ");
INSERT INTO kud2014_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Hauga tenem ainai Yeisu ana taumulitao hilaoma hiwalo auline, hiwalo, ‘Taubada, yaiya alimaiyena yehana imwala'i Yaubada yana Abaloina holanai?’ ");
INSERT INTO kud2014_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Na Yeisu gama ehebo iyogaenama, na gamanane ahi'ahipudiyai ivetowolo, ");
INSERT INTO kud2014_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","na iwalo aulidine, ‘Ebe nigele amyanuwabui na mumugamiu hedaheda iu'iudi dova, mata nigele amyaluwu yana abaloinane ainai. ");
INSERT INTO kud2014_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yawalo moiha yaiyadiwo omiu ebe amnuwadobi gama teina dova, omiu taumiya ewa Yaubada yana Abaloina holanai. ");
INSERT INTO kud2014_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ainaena ebe ehebo tomowa gama teina dova ilauvai vehabagu, iya hinage yau ilauvaigau. ");
INSERT INTO kud2014_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Na hesi ebe yaiya agu tauyemidiwo gamane dova teina ehebo i'abiye be'u, ilowoinanei na gaima mwala'ina gadonai hilauhipwai na magaimana higabae aituluwei ni'uwai ta ihanene. ");
INSERT INTO kud2014_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Omiu taumiya bale'u atemuyamuyamiu wuwuna ababe'u bagibagilidi tomowa ammohemohedi. Moiha, ababe'uwo mata hilaoma, na hesi ebe yaiya ana geluwo i'abiye be'udi howola abo tomowanane ive'atemuyamuya moiha. ");
INSERT INTO kud2014_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","‘Na ebe nimam bo aem i'abiye be'ugo ilowoinanei na utomvehulu. Neta nigele ana yababa ebe nimam tomtomna, nuwana aem tomtomna mata yawahi namwanamwana ulobai. Na hesi iyababa alili alimwai ebe manima bwaubwaum yo ma'ae bwaubwaum na higabae aituluwego aiwa ala'alahi vateyaina ainai. ");
INSERT INTO kud2014_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mehem hinage dova ebe i'abiye be'ugo uma'i vehulu ta'i, wuwuna nigele hinage hava ana yababa, ebe mamehe ehe'ehebom mata yawahi namwanamwana ulobai. Na hesi iyababa ali'alili alimwai ebe mamehe bwaubwaum higabae aituluwego dalava ala'alahina ainai. ");
INSERT INTO kud2014_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","‘Hedaheda teina dova havena teya aidiyena amsosososomanaedi. ");
INSERT INTO kud2014_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Moiha, hedahedawone adi tau'ita aviviniwo neta tausagenawasao hauga maudoina galewai Tamagu mehenai himiyamiya na hivinuvinunuidi. ");
INSERT INTO kud2014_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","‘Na vedova ebe towaho yana sipiwo adi bagibagili analedi ehebo, na ehebo ilaupwanopwano na i'wadalele, mata 99 oyai imwauwidi na 'wada'wadalelenane ibehaei, awa? ");
INSERT INTO kud2014_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na ebe ilobauyoi, yawalo moiha alimiyai mata yana yaliyaya mwala'i alilina. Na hesi hitau 99 namwanamwadine nigele vehabadi iyayaliyaya moiha. ");
INSERT INTO kud2014_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ainaena teina ta'i amhanapui ebeha Tamagu galewai nigele nuwana ebe yaiya teya gama yababa ive'alo na ilauyabayababa. ");
INSERT INTO kud2014_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","‘Na ebe tahim yababana ipaihowai alimwai, utowoi na yana paihowa yababanane am'abiye dumwalu, na ebe alinam ibenalei, ausala, neta bada amve'au'augelu'o. ");
INSERT INTO kud2014_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Na ebe nigele nuwanuwana alinam ibenalei, tomowa ehebo bo bwau hinage ulauvaidi ta baidamwao tahimne ainai amwalo na yana pwanoli i'ita ili'ilimani. ");
INSERT INTO kud2014_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na ebe bada nigele nuwana na ibenalegomiu, amwalo mahalava Yaubada yana bodao aidiyai, na ebe hinage nigele nuwanuwana Yaubada yana bodaone yadi walo ibenalei, amta'wata'wataei na imiya mahalava dova takesi ana tautanowo. ");
INSERT INTO kud2014_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","‘Yawalo moiha hava ebe bale'uwai ampaidi, ginaulidine galewai mata hinage hipaidi, na hinage ebe hava bale'uwai amlivahidi mata ginaulidine galewai hilivahidi. ");
INSERT INTO kud2014_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","‘Teina ta'i yawalo alimiyai, neta ebe yaiyadiwo hitau bwau alimiyena bale'uwai hitalam ehebo ginauli vehabana na vehabana hi'awanoi Tamagu galewai ainai, ipaihowai ta'i. ");
INSERT INTO kud2014_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Wuwuna ebe ehebo tupwa ainai bwau nuwana tonuga tomowa yehaguwena himiyatoyawa, yau hinage ahi'ahipudiyai yamiyamiya.’ ");
INSERT INTO kud2014_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ta Pita ilaoma Yeisu iwalo auli, iwalo, ‘Taubada, ebe tahigu hauga bagibagilina aliguwai yababana ipaipaihowai, maiviha howahowana na yana yababaone yanuwahamuidi, mai 7 bo maiviha?’ ");
INSERT INTO kud2014_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Na Yeisu iwalo, ‘Nigele mai 7 a'ava, na hesi 7 ana bagibagili 70’. ");
INSERT INTO kud2014_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","‘Wuwuna Yaubada yana Abaloina dova tauwasawasa ehebo, iya nuwanuwana ebe yana taupaihowao adi buki hiyemaiha ainai. ");
INSERT INTO kud2014_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ainaena ivetuwuni ta towaho ehebo hilawenama ana buki 10 tausani kina, ");
INSERT INTO kud2014_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","na nigele howahowana iyemaiha, eeta tauwasawasane iloina ta ebeha towahowa mwanena yo natunao yo yadi tobwatobwao maudoidi higimwalaedi, na adi maihane tauwasawasane ivai taupaihowawa ana buki vehabana. ");
INSERT INTO kud2014_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","‘Na taupaihowawa mayana nuwavitai ipwagogo na i'awanoi ainai, iwalo, “Taubada, u'atemuyamuyaegau na howola abo agu buki maudoina yayemaiha”. ");
INSERT INTO kud2014_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Eeta tauwasawasane i'atemuyamuyaei na ana buki maudoina inuwahamuidi, na taupaihowawa imamahalavane. ");
INSERT INTO kud2014_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","‘Imahalava na ana gelu ehebo ilobai, na ana gelune ana buki toea 10 a'ava ainai, na ana geluwa gadona i'abi avivini na i'i'i'ine, iwalo, “Teina ta'i am buki aliguwai uyemaiha!” ");
INSERT INTO kud2014_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","‘Na ana geluwa italupwagogo na ainai i'awanoi, iwalo, “U'atemuyamuyaegau na howola abo yayemaiha alimwai”. ");
INSERT INTO kud2014_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Na ana gelune nigele alinana iyabenalei na vada abapaiyai imwamwauwine ta ebe nemai imiyamiya ana higa ana buki maudoina iyemaiha. ");
INSERT INTO kud2014_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","‘Na taupaihowaowa adi gelune mumuganawa hi'i'itane, ainaena hinuwayababa mwala'ina, na hilau tauwasawasane ainai hiwalo mahalavaei. ");
INSERT INTO kud2014_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Na tauwasawasane yana taupaihowawa iyogaenama na iwalo auline, iwalo, “Owa taupaihowa yababam, wuwuna u'awanoi aliguwai na am buki maudoina yanuwahamuidi, ");
INSERT INTO kud2014_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","eeta owa hinage howahowana am gelu u'atemuyamuyaei na ana buki unuwahamui”. ");
INSERT INTO kud2014_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","‘Ainaena tauwasawasane imodi'ini moiha ta vada abapai ana tau'ita aviviniwo iloinaedi ta taupaihowawa vada abapaiyai himwamwauwine ta ebe nemai imiyamiya ana higa ana buki maudoina iyemaiha ve'ovidi.’ ");
INSERT INTO kud2014_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Na Yeisu yana walo ive'ovi, iwalo, ‘Tamagu galewai hinage mata dova alimiyai ipaihowai, ebe tahimiyao nigele amya'atemuyamuyaedi na yadi yababao amyanuwahamuidi mata nigele iyanuwahamiugomiu’. ");
INSERT INTO kud2014_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yeisu yana ve'itao ive'ovidi na tupwa Galili ilauvehulu na Yudeya tupwanai ilalaune, neta bwahi Yolidani vali tupwanai. ");
INSERT INTO kud2014_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Na boda hinage mwala'ina Yeisu himulitaei na nemai yadi taulovalao i'abiye namwanamwadi. ");
INSERT INTO kud2014_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Na Palisiwone hilaoma ta nuwanuwadi Yeisu hitowoi, ainaena ainai hipanivila, hiwalo, ‘Taubada, ebe towaho mwanena yana paihowa vehabana nigele iyayaliyaya, howahowana na ivinawaheyei?’ ");
INSERT INTO kud2014_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Na Yeisu iwalo, ‘Buki Ve'ahihi ainai lelelewa bada amhanapuiya'o ebeha hauga ana abavetuwuni ainai Yaubada tomowa bwau iyemaseledine, towaho na waihiu. ");
INSERT INTO kud2014_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Na lele teya iwalo, “Teina wuwuna ta towaho tamana na hinana ilauvehuludi na asolena baidana himiya bwau, na hitau bwauwone taudi ehebo ta'i”. ");
INSERT INTO kud2014_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Teina ainaena bada hive'ehebo'o na nigele hiyamiyawahi. Eeta Yaubada bada iyemiya bwauwedi'o ainaena havena teya tomowa mata iyayemiya wahiyedi.’ ");
INSERT INTO kud2014_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Eena hipanivila, hiwalo, ‘Hava wuwuna Mosese iloina ebeha towaho howahowana na vinawahe peipana ilele na mwanena imohei abo mulitai ivinawaheyei?’ ");
INSERT INTO kud2014_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Na Yeisu iwalo, ‘Neta ulu'ulumiu yaiyaidi vehabana Mosese itatalamne alimiyai ta mwanemiyao ebe dova amvinawaheyedi, na hesi hauga abavetuwuni ainai nigele hinage talam vinawahe vehabana iyamiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Na yawalo alimiyai neta ebe towaho mwanena nigele iyapwanoli na bada ivinawaheyei na itawahola wahi vali waihiu ainai, neta imehemehe'ayo.’ ");
INSERT INTO kud2014_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Na ana taumulitao hiwalo auli, hiwalo, ‘Ebe towaho na waihiu adi loina teina dova, howahowana havena hitawatawahola’. ");
INSERT INTO kud2014_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Na Yeisu iwalo, ‘Nuwatuwu teina nigele tomowa maudoidi vehabadi, na hesi yaiyadiwo Yaubada nuwatuwu imohemohedi hiya hibom, ");
INSERT INTO kud2014_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","wuwuna tupwadi towatowaho yadi hauga tubui ainaena nigele tawahola ana nuwatuwu aidiyai iyamiyamiya. Na tupwadi towatowaho uvidi hihapihapidi ainaena nigele howahowana na hitawahola. Na hinage tupwana towatowaho Yaubada yana Abaloina vehabana hibom hive'ahihiuyowedi eeta nigele hiyatawatawahola. Ebe yaiya amwahane howahowana ilowoinanei na imulitaei.’ ");
INSERT INTO kud2014_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tupwadi tomowa hedaheda hilawedima Yeisu ainai ta ebe i'abitowoidi na vehabadi i'awanoi Yaubada ainai. Na ana taumulitaone hesi hedahedaone hilaugagayowedi. ");
INSERT INTO kud2014_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Na Yeisu iwalo, ‘Havena hedaheda amlaulaugagayowedi na hesi amtalamwedi ta aliguwai hilaoma, wuwuna hedaheda teina dova Yaubada yana Abaloina ilowoinanedi moiha’. ");
INSERT INTO kud2014_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Eena Yeisu hedahedaone i'abitowoidi na mulitai ilalauvehuludine. ");
INSERT INTO kud2014_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mulitai ehebo hevali Yeisu ainai ilaoma na iwalo, ‘Tauve'ita, aiteya paihowa namwanamwana yapaihowai na ainaena ebe yawahi miyamiya vateyaina yalobai?’ ");
INSERT INTO kud2014_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Na Yeisu iwalo, ‘Hava wuwuna upanivila aliguwai paihowa namwanamwana vehabana? Wuwuna taunamwanamwa ehebo mohimohili imiyamiya, ainaena ebe nuwanuwam yawahi miyamiya vateyaina ulobai ilowoinanego na ibom yana loinao umulitaedi.’ ");
INSERT INTO kud2014_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Na towahowa ipanivila, iwalo, ‘Aiteya loina?’ Na Yeisu iwalo, ‘Havena yemwalowoi; havena mehe'ayo; havena aivavali; havena ve'ewa awa'awawa; ");
INSERT INTO kud2014_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","na tamam yo hinam uve'ahihiyedi; yo hinage am geluwo uvelauwedi dova ubom uvelavelauwegone’. ");
INSERT INTO kud2014_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Na towahowa iwalo, ‘Loina teina maudoina yamulita ili'ilimanidi'o, na hava hinage yapaihowai?’ ");
INSERT INTO kud2014_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Na Yeisu iwalo, ‘Ebe nuwanuwam mumugam maudoina namwanamwadi, ulau gwaipile yam dalavai na yam tobwatobwa maudoina uvegimwalaedi na adi maihane u'aiyauyanedi tauwewelohe aidiyai, na mulitai ulaoma umulitaegau ta ebe ainaena howola abo yam wasawasa galewai ulobai’. ");
INSERT INTO kud2014_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hevaliwa Yeisu yana walo teina ibenalei na mayana nuwavitai iwuwuyone. Wuwuna yana tobwatobwao ibagibagili alili. ");
INSERT INTO kud2014_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Eeta ana taumulitaowa iwalo aulidi, iwalo, ‘Neta moiha, tomowa wasawasadi yadi luwu Yaubada yana Abaloina holanai i'ololo. ");
INSERT INTO kud2014_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Na hinage yawalo auligomiu ebeha lagulagu mwala'ina kameli nigele howahowana na nidili gudana ainai iluwu, na hesi tomowa wasawasadi yadi luwu Yaubada yana Abaloina holanai i'ololo ali'alili.’ ");
INSERT INTO kud2014_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yeisu ana taumulitao yana walo teina hibenalei na nuwadi ipwanopwano mwala'ina, na hiwalo, ‘Ebe teina dova, yaiya yede howahowana na awanamwanamwane ilobai?’ ");
INSERT INTO kud2014_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ainaena Yeisu ivinuvinunuidi na iwalo, ‘Ginauli teina ivitai ali'alili tomowa aidiyai, na hesi Yaubada ainai ginauli maudoina malamalaidi’. ");
INSERT INTO kud2014_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Na Pita iwalo, ‘Ai vedova? Wuwuna yama tobwatobwa maudoina atauvehuludi na amumulitaegone.’ ");
INSERT INTO kud2014_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Na Yeisu iwalo, ‘Moiha ta'i, howola abo bale'u ana abiye vauvau ainai yau Tomowa Moihagu yagu vatavata wasawasa ainai yamiya, na hinage omiu agu taumulitao am tau 12 yami vatavata 12 aidiyai hinage ammiya na Isileli yadi huhuwo 12 amloinaedi. ");
INSERT INTO kud2014_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na ebe yaiyadiwo omiu yami vadao yo tahimiyao yo nuhumiyao yo tamamiyao yo hinamiyao yo natumiyao yo yami oyao amtauvehuludi'o, howola abo ginaulidine adi maihao ma'adi lauhepoi analedi amlobaidi, yawahimiu miyamiya vateyaina baidana. ");
INSERT INTO kud2014_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Na teina hauga taumugai bagibagilidi howola abo himulita, na hiya himulimulitane howola abo himugai. ");
INSERT INTO kud2014_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","‘Yaubada yana Abaloina dova towaho ehebo mayana tanovi. Towahonane malatomtomwai itowolo na ilau ta yana taupaihowa iyogaedi ta ebe hipaihowa yana tanoviyai. ");
INSERT INTO kud2014_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Na loina imwauwi neta ebeha ahubena ehebo paihowa ana maiha kina ehebo, ta hitalam. Eena ivetamaledi ta hilalaune yana tanoviyai habi paihowa. ");
INSERT INTO kud2014_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","‘Na mahana ihaehaei na towahonane ilau gwaipile abagimwala ainai, na tomowa tupwadi ilobaidi himiyamiya awawa. ");
INSERT INTO kud2014_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Eena iyogaedi na iwalo, “Omiu hinage amlau yagu tanoviyai ampaihowa, na yami paihowa ana maiha dumwaluna yamohegomiu”. ");
INSERT INTO kud2014_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Eeta hilalaune tanoviyai. ‘Na mahana ala'alapwahiyai na lavilaviyena hinage ilau gwaipileuyo na tupwadi hinage ilobaidi na iyogaedi ta ivetamaledine hilalaune tanoviyai. ");
INSERT INTO kud2014_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Na mahana ilulululuvi na imahalavauyo ta ilau dalavai na tomowa tupwadi hinage ilobaidi, eena ipanivilaedi, iwalo, “Hava vehabana ahubena maudoina ammiyamiya awawane?” ");
INSERT INTO kud2014_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Na hiwalo, “Wuwuna nigele teya iyayogaegai habi paihowa”. Na towahowa iwalo, “Omiu hinage amlau tanoviyai ampaihowa”. ");
INSERT INTO kud2014_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","‘Na bada i'imwa'imwa'auhi ta tanovi taniwaganawa yana paihowa ana taumugai iwalo auli, iwalo. “Taupaihowao maudoidi uyogaedima na adi maiha umohedi, hiya taulau mulimulita aidiyena uvetuwuni ana higa hiya ahubena maudoina hipapaihowane ainai ulaumwau”. ");
INSERT INTO kud2014_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","‘Eeta hiya mahana ilulululuvi ainai hipapaihowane hilaoma na adi maiha kina ehebo ehebo hi'a'avalane dova hinage tomowa maudoidi mata kina ehebo ehebo hi'avala. ");
INSERT INTO kud2014_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mulitai maudoidi taupaihowaowa hilaoma na maihadi kina ehebo ehebo hivavaidine. Na taupaihowa mugamugaidi, hiya ahubena maudoina ainai hipapaihowane hilaoma na hinuwanuwatuwu ebeha mata maiha ma'ana lauhepoi hivai, na hesi nigele, hibom hinage kina ehebo ehebo a'ava hivavaidine. ");
INSERT INTO kud2014_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ainaena yadi kina hivaidi na tanovi taniwagana ainai hi'ulu'ulumiyai, ");
INSERT INTO kud2014_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","na hiwalo, “Tomowaone abomohili yadi paihowa hauga ahu'ahubalina, na ai ahubena maudoina mahana holanai apaihowa, na adi maiha dova maudoimai apaihowa ovi'ovine”. ");
INSERT INTO kud2014_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","‘Na tauloinawa iwalo aulidi, iwalo, “Augeluwo, nigele yagu loina iyayababa alimiyai, eeta kina ehebo ehebo amtalamwei ta neta badagi. ");
INSERT INTO kud2014_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yami kina teina amvai ta amlau. Na yau yaloina ebeha tomowa taulau mulimulita adi maiha yamohedi omiu dova ami maihane. ");
INSERT INTO kud2014_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Maiha teina yau yagu abaloina. Nigele omiu amyaloina. Havena yagu velau tomowa aidiyai vehabana amve'alo'alomagigili.” ");
INSERT INTO kud2014_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","‘Eeta hiya himulimulitane howola abo himugai na hiya himugamugaine howola abo himulita.’ ");
INSERT INTO kud2014_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yeisu mayana taumulitao hitau 12 ilauvaidi ta howola Yelusalem vehabana hihaehae na amwaha papalinai hibom, na iwalo aulidi, ");
INSERT INTO kud2014_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","iwalo, ‘Teina ta'i tahae Yelusalem. Yau Tomowa Moihagu agu tauhuhulawa mata ihuhulaegau taupwaoli mwala'idi yo loina adi tauve'itao aidiyai na yagu mwalowoi vehabana hiloina, ");
INSERT INTO kud2014_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","na mulitai hi'aiyauyanegau hiya ganamuli aidiyai na hitalawahiyegau yo balavaena hisapigau, na aiwa lagalagana ainai hitutuye patugau, na ahubena tonugana ainai Yaubada i'abiye towolouyoigau.’ ");
INSERT INTO kud2014_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebedi mwanena manatunao hilaoma na hinadine Yeisu aenai ipwagogo na ainai i'awanoi Yemesa na Yoni vehabadi. ");
INSERT INTO kud2014_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Na Yeisu iwalo, ‘Hava nuwanuwam?’ Na waihiuwa iwalo, ‘Nuwanuwagu na natuguwone aidiyai utalam na ebe hauganane uvetauloina, howahowana na vahalimwai himiya, ehebo nima tautuwamwena na ehebo nima eha'ehamwena’. ");
INSERT INTO kud2014_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Eeta Yeisu towatowahowa aidiyai iwalo, ‘Omiu yami awanoine ana masele nigele amyahanapui. Vedova, muya vedina ainaena mata yanumanumane howahowana omiu hinage ainaena amnuma?’ Na hiwalo, ‘Howahowamai’. ");
INSERT INTO kud2014_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Na Yeisu iwalo, ‘Neta moiha. Vedine ainaena yanumanumane omiu hinage ainaena mata amnuma. Na hesi nigele howahowagu yaloina yaiyadiwo howola abo yagu abaloina ainai nima tautuwaguwena bo nima eha'ehaguwena himiya, wuwuna teina Tamagu ibom ta'i yana abaloina ta ibom iloina.’ ");
INSERT INTO kud2014_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Na vali taumulitaone hitau nimabwaubwau Yemesa na Yoni yadi awanoi hibenalei, ta hi'waunihanihaedi. ");
INSERT INTO kud2014_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Eeta Yeisu maudoidi iyoga ahaidi, na aidiyai iwalo, ‘Omiu amhanapuiya'o neta tauloinao bale'uwai yadi bodao hiloiloina wahiyala adiyai, ");
INSERT INTO kud2014_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","na omiu havena hinage dova amveve'ao'aonaedi. Eeta ebe yaiya owa nuwanuwam na alimiyena uvetauloina am lowoinana yo am geluwo vehabadi uvetaupaihowa. ");
INSERT INTO kud2014_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Na hinage ebe yaiya owa nuwanuwam na alimiyena ivetaumugai ilowainanego yo am geluwo vehabadi uvetaupaihowa mohili. ");
INSERT INTO kud2014_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Dova hinage yau Tomowa Moihagu yalaoma bale'uwai nigele ebeha tomowa vehabagu hipaihowa, na yau hesi yavetaupaihowa tomowa vehabadi, na hinage yatalamwegau mwalowoi ainai tomowa bagibagilimiu ami livahi vehabana.’ ");
INSERT INTO kud2014_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Eeta Yeliko hilaugabaei, na boda mwala'ina Yeisu himulitaei. ");
INSERT INTO kud2014_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Na mehegibugibudi hitau bwau amwaha papalinai himiyamiya Yeisu yana ta'i'ili wasana hibenalei, ta Yeisu ainai hiyoga, hiwalo, ‘Deivida tubuna yo, u'atemuyamuyaegai’. ");
INSERT INTO kud2014_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Na bodaone hitau bwauwa alinadine hibenalei, ta hilaugagayowedi, hiwalo, ‘Amnobu! Badagi yogane!’. Na hesi hitau bwauwowa hiyoga wahiwahiyala, hiwalo, ‘Taubada, owa Deivida tubuna, u'atemuyamuyaegai’. ");
INSERT INTO kud2014_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Eeta Yeisu itowolo na iyogaedi, iwalo, ‘Hava nuwanuwamiu yapaihowai?’ ");
INSERT INTO kud2014_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Na hiwalo, ‘Taubada, howahowana mehemai u'abiye maseledi?’ ");
INSERT INTO kud2014_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Na Yeisu i'atemuyamuyaedi ta mehedi i'abitowoidi na hinanamwanamwane, ta Yeisu hinage himumulitaeine. ");
INSERT INTO kud2014_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Hihaehae Yelusalem vehabana ta Bedipegi vahalinai himahamahalava, neta oya Olibe ainai. Eeta Yeisu ana taumulitao bwau ivetamale mugaiyedi, ");
INSERT INTO kud2014_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","iwalo, ‘Amlau dalavane mehedaenane ainai lagulagu doniki am'ita, aiwa ainai hilauhipwaiya'o, natuna towahona baidana himiyamiya, amlivahidi na amlawedima aliguwai. ");
INSERT INTO kud2014_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ebe yaiya ipanivilaegomiu yami paihowane vehabana, amwalo, “Taubada nuwanuwana, na iyepaihowa” ta ebe italamwei alimiyai.’ ");
INSERT INTO kud2014_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ginauli teina himahalava wuwuna mwalona tauwalo mahalava iwalo mahalavaei, iwalo: ");
INSERT INTO kud2014_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘Saiyoni tomowanao amwalo aulidi, amwalo: Am'ita yami wasawasa mwala'ina ilalaoma alimiyai. Iya taunuwadobi moiha, na doniki ainai igelu. Na donikinane towahona na yauyaubona.’ ");
INSERT INTO kud2014_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Eeta Yeisu yana walowa ana taumulitao hibenalei ta himulitaei hilalaune, ");
INSERT INTO kud2014_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","na doniki manatuna hilobaidi ta hilawedima, na tupwadi ale'o ase tuluhanai hivehedi na Yeisu igelu taohani ewanai. ");
INSERT INTO kud2014_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Na bodaone adi ale'owo amwahai hivehedi, na tupwadi aiwa lagalagadi malugudi higuladi amwaha ana pasa vehabana. ");
INSERT INTO kud2014_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Na tupwadi boda Yeisu nuwanuwanaena, na tupwadi boda tuluhanaena himulimulita, na maudoidi hino'ono'owei na hiyeliyeli hiwalo: ‘Awalo vetuvehaeyego Deivida tubuna. Owa Yaubada yehanaena ulaoma i'awa namwanamwaego. Hosana iya ewa aliliyai.’ ");
INSERT INTO kud2014_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Na hauganane Yeisu iluwu Yelusalem tomowa maudoidi hibatutuli na hiwalo, ‘Yaiya teina?’ ");
INSERT INTO kud2014_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Na ana 'wayabuwowa yadi walo hiyemaiha, hiwalo, ‘Teina tauwalo mahalava Nasaleti towahona, yehana Yeisu, na Galili yana abaloina ainaena ilalaomane’. ");
INSERT INTO kud2014_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Na Yeisu iluwu Yaubada yana vada tapwalolo mwala'ina ainai na taugimwalao yo tauvegimwalao maudoidi ihiwa mahalavaedi, na mane ana tauvesaugelasi yadi gwalatau i'oibuiyedi na gabubu adi tauvegimwalao yadi abamiya hinage i'oibuiyedi, ");
INSERT INTO kud2014_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","na iwalo aulidi, iwalo, ‘Buki Ve'ahihi ainai Yaubada yana walo hileleya'o, iwalo, “Yagu vada yehana himwauwi vada aba'awanoi”, na omiu am'abibui ta ebeha tau'aivavali yadi aba'aidawani.’ ");
INSERT INTO kud2014_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Na taumehegibugibu yo daladaladi Yeisu ainai hilaoma vada tapwalolo holanai na maudoidi i'abiye namwanamwadi. ");
INSERT INTO kud2014_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Na taupwaoliwo mwala'idi yo loina ana tauve'itao Yeisu yana paihowa wahiwahiyaladi hi'itadi, na hinage hedaheda hibenaledi vada tapwalolo holanai, hiwuiwui, hiwalo, ‘Deivida tubuna tano'owei’. ");
INSERT INTO kud2014_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ainaena tauloinaone Yeisu himodi'iniyei hiwalo, ‘Hedaheda teina yadi walo ubenalena'o?’ Na Yeisu iwalo, ‘Ehe, bada yabenalena'o. Na yede Buki Ve'ahihi ainai amvahiliya'o, iwalo: “Hedaheda iu'iudi awadiyena am no'o moiha ulobai”.’ ");
INSERT INTO kud2014_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Eeta Yeisu itauvehuludi na Yelusalemaena imahalava na Betani ainai iluwu ta nemai i'e'enone. ");
INSERT INTO kud2014_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Malatomtomwai Yeisu i'enotowolo ta ilalau gwaipilene Yelusalem, ma'ana vahali, ");
INSERT INTO kud2014_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","na amwahai aiwa ana ita dova damaya i'ita lobaine ta iwutulau vahalinai na nigele teya ainona iya'ita, bada lugulugu a'avana. Ainaena Yeisu aiwanane i'walotutunei, iwalo, ‘Howola mata nigele hinage uya'ainouyo’. Eena aiwanane iwewelai mwayamwayaune. ");
INSERT INTO kud2014_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Na Yeisu ana taumulitao hi'itaya'o na nuwadi ipwanopwano na hiwalo, ‘Vedova ta aiwanane iwewelai mwayamwayaune?’ ");
INSERT INTO kud2014_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Na Yeisu iwalo, ‘Yawalo moiha alimiyai, ebe mayami yemidi na nigele mayami nuwatuwu bwaubwau, ginauli teina aiwane ainai yapapaihowaine omiu hinage dova mata ampaihowai, na ebe oya tenem amloinaei, amwalo, “Udobi ni'uwai”, ipaihowai dova. ");
INSERT INTO kud2014_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yo ebe mayami yemidi Yaubada ainai am'awanoi mata amlobai.’ ");
INSERT INTO kud2014_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yeisu ilau gwaipileuyoma na vada tapwalolo ainai iluwu ta ive'ive'ita, na taupwaoliwo mwala'idi yo tautaubadao hilaoma ta Yeisu hipapanivilaeine, hiwalo, ‘Yaiya yana loinaena ta teina dova upaipaihowaine?’ ");
INSERT INTO kud2014_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ta Yeisu iwawalo aulidine, iwalo, ‘Hola yapanivila mugaiyegomiu, na ebe amyemaiha, yau hinage yawalo alimiyai yagu loina vehabana. ");
INSERT INTO kud2014_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yagu panivila teina: Yaiya yana loinaena Yoni tau'abiye bapitaiso ipaipaihowane? Yaubada bo teya tomowa?’ Ta hibom aidiyai hive'awa pa'ipa'i'i, hiwalo, ‘Yana walo vedova mata tayemaihane? Wuwuna ebe tawalo, “Yaubada ainaena”, mata iwalouyo na iwalo, “Hava yede vehabana ta Yoni nigele amyayemidiyeine?”. ");
INSERT INTO kud2014_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Na hinage nigele howahowana tawalo, “Tomowa aidiyena”, mata dova ta boda himanini alidai wuwuna maudoidi Yoni hi'awa tauwalo mahalavaena'o.’ ");
INSERT INTO kud2014_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ainaena Yeisu yana panivila nigele hiyayemaiha ili'ilimani, na hesi hiwalo, ‘Nigele ayahanapui’. Eeta Yeisu iwalo aulidi, iwalo, ‘Yau hinage mata nigele yayawalo mahalava alimiyai, yaiya yana loinaena ta teina dova yapaipaihowane’. ");
INSERT INTO kud2014_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yeisu iwalo, ‘Vedova yam nuwatuwu? Towaho natunao towatowahodi bwau na tamadine tautuwanane ainai iwalo, “Natugu, mata ulau oyai upaihowa”, ");
INSERT INTO kud2014_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","na ita'wata'wata, na mulitai inuwabui ta ilau ipapaihowane. ");
INSERT INTO kud2014_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Towahone natunane iu'iunane hinage dova iwalo auli, iwalo, “Natugu mata ulau oyai upaihowa”, na natunane iwalo, “Ehe, inamwanamwa, mata yalau”, na hesi nigele iyalau. ");
INSERT INTO kud2014_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ainaena hitau bwauwone aidiyena yaiya tamana yana walo imumulitaeine?’ Na taupwaoliwo yo tautaubadao hiwalo, ‘Tautuwanane’. Eeta Yeisu iwalo aulidi, iwalo, ‘Ehe, moiha ta'i tauyababao hiya dova takesi ana tauvaiwo yo taumehe'ayowo mata hiluwu mugai Yaubada yana Abaloina ainai, na omiu mulitai. ");
INSERT INTO kud2014_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Wuwuna mwalona Yoni amwaha dumwadumwaluna ive'itagomiu na omiu nigele amyayemidiyei, na hesi takesi ana tauvaiwo yo taumehe'ayowo hiyemidiyei. Ta mehemiyena hinage am'itadi'o hinuwabui na omiu ta'i nigele amyanuwabui bo amyayemidiyei, awa?’ ");
INSERT INTO kud2014_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Na Yeisu hinage iwalo aulidi, iwalo, ‘Ehebo walovegevegedi hinage ambenalei, tanovi ana taupaihowa vehabana. Taupaihowane gileipa a'ava i'umaidi yana tanoviyai na abwalu ipaihowai ta itata'i'iline na gileipa ana abatam hinage ipaihowai, na vada abavinunu tanovi holanai i'a'abine, na yana taupaihowao iloinaedi ta hi'ita'ita avivini, na iya ilau amwaha daodaowai. ");
INSERT INTO kud2014_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","‘Na laulau'eli ana haugai taubadawa yana hevahevaliwo tupwadi ivetamaledi yana tanoviyai gileipa ainona habi vaidi tanovi ana tau'ita aviviniwo aidiyena. ");
INSERT INTO kud2014_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Na hauganane hilau tau'ita aviviniwone hevahevaliwowa hi'abi avivinidi ta ehebo hisasapine na bwaunane hi'oiye mwalowoi na tonuganane gaimaena hi'oiye'i'iwahi. ");
INSERT INTO kud2014_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mulitai oyawa taniwaganawa tupwadi hinage yana hevahevaliwo bodadi ivetamaledi, na hiya hinage dova hipaihowai ehebonane aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Na yana aba'ovi ainai natuna towahona ivetamalei aidiyai na iwalo, “Ibom natugu moiha, ainaena mata hive'ahihiyei”. ");
INSERT INTO kud2014_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","‘Na natunawa imahalava aidiyai, na tau'ita aviviniwowa hibom aidiyai hiwalo, “Augeluwo, towaho teina howola abo oyane iloinaei, ainaena mata ta'oiye mwalowoi na ita tanovine taloinaei”. ");
INSERT INTO kud2014_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Eeta hi'abi avivini na higabaei mahalavaei tanovine tuluhanai na hi'oiye mwalowoine.’ ");
INSERT INTO kud2014_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Na Yeisu ipanivila iwalo, ‘Hauganane tanovi taniwagana ilau gwaipilema, hava mata yana tau'ita aviviniwone aidiyai ipaihowai?’ ");
INSERT INTO kud2014_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Na hiwalo, ‘Tau'oiye mwalowoiwone mata i'abiye yababadi moiha na tanovine italamwei tau'ita avivini namwanamwadi aidiyai, ta ebe tanovine ainona tupwana tanovi taniwagana himohei’. ");
INSERT INTO kud2014_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Eena Yeisu hinage Buki Ve'ahihi ainaena iwalo mahalavaei, iwalo, ‘Nuwana Buki Ve'ahihi yana walomahalava nigele amyanuwatuwu avivini, iwalo: “Logidiwa mwalona tau'abi vada hitata'wataeiwa teina hauga bada hivetowoloya'o na ivelogidi mugai, ta logidi maudoidi iloinaedi. Neta Yaubada yana paihowa, mehedai abanuwapwanopwano alidai.” ");
INSERT INTO kud2014_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","‘Ainaena yawalo auligomiu ebeha Yaubada yana Abaloina alimiyena mata ivaivehulu, na imohedi vali boda aidiyai, ta ebe hiya aidiyena ainona namwanamwana imahalava. ");
INSERT INTO kud2014_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ebe yaiya ibe'u teina logidine ainai mata hilihiliyana igodudi, na ebe logidinane ibe'u teya yaiya ewanai mata tauna ilotamutumutu dova gawala.’ ");
INSERT INTO kud2014_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Yeisu yana walovegevegedi teina taupwaoliwo mwala'idi yo Palisiwone hibenalei ta hihanapuiya'o ebeha hiya vehabadi iwalowalo vegevegedine. ");
INSERT INTO kud2014_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Eeta tupwadi amwa'amwaha hibehabeha ta ebeha Yeisu hi'abi avivini, na hesi nigele howahowana hi'abi avivini, wuwuna boda aidiyai himeheuhi, na bodaone Yeisu hi'awa tauwalo mahalavaena'o. ");
INSERT INTO kud2014_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ehebo hinage walovegevegedi Yeisu imohedi, iwalo, ");
INSERT INTO kud2014_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","‘Yaubada yana Abaloina dova tauwasawasa ehebo guyau ipaihowai natuna towahona yana tawahola vehabana. ");
INSERT INTO kud2014_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ainaena yana taupaihowao ivetamaledi yo yaiyadiwo hiya ivenuwamwauwedi'o hiyogaedima guyaune ainai, eeta hilau habi yogaedima na tomowadine hita'wata'wata. ");
INSERT INTO kud2014_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","‘Ainaena tupwadi hinage yana taupaihowao ivetamaledi ta tomowa hiwalo aulidi ebeha yana guyau bada i'atububuniya'o. Yana bulumakau mwala'idi yo bulumakau yauyaubodi bada iwunuidi'o na ai'ai maudoina i'atububuniya'o. Amlaoma na talau natuna yana tawahola guyauna am'ai. ");
INSERT INTO kud2014_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Na hiya nigele hiyalaoma, eeta hitaudawani ta vali tupwa yo vali tupwa aidiyai hilalaune. Ehebo towaho yana oyai ilalaune, ehebo yana paihowa ainai ilalaune. ");
INSERT INTO kud2014_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Na tomowa tupwadi tauwasawasane yana taupaihowao hi'abi avivinidi na hi'abiye hinimayadi na hi'oiye mwalowoidi. ");
INSERT INTO kud2014_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","‘Ainaena tauwasawasane ana modi'i'ini moiha na yana tau'alehao ivetamaledi na tau'oiye mwalowoiwowa hilamani ye'wahadi na yadi dalavao higagabudine. ");
INSERT INTO kud2014_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","‘Na tauwasawasane yana taupaihowao aidiyai iwalo, “Tawahola guyauna bada atu'atububunina na hesi hiya yavenuwamwauwedi'o nigele hiyalaoma wuwuna hiya tauyababao. ");
INSERT INTO kud2014_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ainaena amwaha aidiyai amta'i'ili ta yaiyadiwo amlobaidi amlauvaidima ta tawahola guyauna hi'ai.” ");
INSERT INTO kud2014_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Eeta himahalava amwahai ta tomowa bagibagilidi hitano'ahaidi, tupwadi yabayababadi na tupwadi namwanamwadi eeta tawahola ana vadawa hi'oiye mwaune. ");
INSERT INTO kud2014_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","‘Hauganane tauwasawasa ilaoma taumanao habi itadi na towaho ehebo i'ita lobai, iya nigele tawahola ale'ona iyali'wa, ");
INSERT INTO kud2014_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ainaena ipanivilaei, iwalo, “Augelu, vedova ta tawahola ale'ona nigele uyali'wa, na havanaena ululuwumane?”. Towahonane nigele howahowana yo panivilane teina iyemaiha. ");
INSERT INTO kud2014_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Na tauwasawasane yana taupaihowao iwalo aulidi, “Towaho tenem am'abi avivini na aena yo nimana ampaidi na amgabae mahalavaei tupwa guguyou ainai, na tenem ainai tomowa hidoudou na awadi hivetau'alahedi muya aidiyena”. ");
INSERT INTO kud2014_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","‘Ainaena tomowa bagibagilidi Yaubada yana venuwamwau hilobaiya'o, na hesi vihavihadi ivesinuwaedi.’ ");
INSERT INTO kud2014_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Palisiwo hibom hitau'ahai ta hiloina vedova ebe panivilaena Yeisu hi'oyamaei na yana lauhapuli hilobai. ");
INSERT INTO kud2014_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ta loina hilobaiya'o, na adi taumulitao yo Helodi yana bodao baidadiyao hivetamaledi Yeisu ainai hiwalo, ‘Taubada, bada ahanapuiya'o ebeha owa tauve'ita moiha ta Yaubada yana nuwatuwu uve'itai na hinage tomowa yadi wahiyala vehabana nigele uyameheuhi, na walomoiha uwalo mahalava tomowa maudoidi aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ainaena teina ta'i uwalo alimaiyai, vedova howahowana na Sisa vehabana takesi mane tamwauwi, bo nigele?’ ");
INSERT INTO kud2014_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yeisu yadi nuwatuwu yababana bada ihanapuiya'o ainaena i'aubabada, iwalo, ‘Omiu tau'oyama! Hava wuwuna amtowotowoigau? ");
INSERT INTO kud2014_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Hola manewa takesi vehabana amve'itagau.’ Eeta mane ehebo himomoheine. ");
INSERT INTO kud2014_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Na Yeisu iwalo aulidi, iwalo, ‘Amwalo auligau, mane teina yaiya alu'aluwana na yehana?’ ");
INSERT INTO kud2014_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Na hiwalo, ‘Sisa’. Ainaena Yeisu iwalo, ‘Ehe, dova. Ebe Sisa yana paula Sisa ammohei, na ebe Yaubada yana paula Yaubada ammohei.’ ");
INSERT INTO kud2014_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yeisu yana walo moiha hibenalei ta hi'aluwagavai moiha, ainaena hitauvehulu na hilalaune. ");
INSERT INTO kud2014_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tenem ahubenanane ainai tupwadi Sadusiwone, hiya nigele hiyayemidi taumwalowoi yadi towolouyo vehabana, hilaoma Yeisu ainai hipanivila, ");
INSERT INTO kud2014_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","hiwalo, ‘Tauve'ita, Mosese yana loina iwalo, “Ebe towaho itawahola na mwanenane nigele natudi na towahone imwalowoi, towahonane tahina hiwapenane baidana hitawahola, ta ebe waihiune ilabalaba natunaone neta taumwalowoiwa ainaena”. ");
INSERT INTO kud2014_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ehebo towaho tahinao 6 baidanao himiyamiya, na towahonane itawahola na imwalowoi, na nigele natuna, ta taumwalowoiwa tahina vahalinaena hiwapenane baidana hitawahola, ");
INSERT INTO kud2014_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","na hinage tahinawa imwalowoi, na iya hinage nigele natuna. Na dova hinage bada tahinaone maudoidi hiwapene hitatawaholaine, ");
INSERT INTO kud2014_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","na tuluhadiyai wahiunane hinage imwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ainaena towolouyo ana hauga ainai, waihiunane yaiya mata mwanena moiha? Wuwuna maudoidi bada hitawaholaiya'o.’ ");
INSERT INTO kud2014_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Eeta Yeisu panivila teina iyemaiha, iwalo, ‘Teina yami lauhapuli, wuwuna Buki Ve'ahihi nigele amyahanapui, na hinage Yaubada yana wahiyala nigele amyahanapui. ");
INSERT INTO kud2014_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Towolouyo ana hauga ainai tomowa nigele mata hiyatawahola yo mata nigele hiyavetawahola na hesi yadi miya tausagenawasa galewai dova. ");
INSERT INTO kud2014_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na Yaubada yana walo towolouyo vehabana Buki Ve'ahihi ainai iwalo, ");
INSERT INTO kud2014_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Yau Abelaham yana Yaubada na Aisake yana Yaubada na Yakobo yana Yaubada”. Yaubada nigele tomowa mwalomwalowoidi yadi Yaubada, na hesi tomowa mayawahidi yadi Yaubada, ainaena tautaubadaowa mayawahidi teina ta'i himiyamiya.’ ");
INSERT INTO kud2014_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yeisu yana walo teina boda hibenalei na hi'aluwagavai yana ve'ita wahiwahiyalana vehabana. ");
INSERT INTO kud2014_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ainaena Palisiwone bada hibenalena'o ebeha Yeisu Sadusiwone yadi panivila iyemaihaya'o ta nigele teya hinage yadi abawalo, eeta Palisiwone Yeisu ainai hilaoma, ");
INSERT INTO kud2014_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","na aidiyena ehebo loina ana tauhanapu Yeisu ainai ipanivila habi towoina, iwalo, ");
INSERT INTO kud2014_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","‘Tauve'ita, loina maudoina aidiyena aiteya loina imwala'i alili?’ ");
INSERT INTO kud2014_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Na Yeisu iwalo, ‘ “Bada yam Yaubada uvelauwei atem yo alu'aluwam yo yam nuwatuwu maudoina aidiyena”. ");
INSERT INTO kud2014_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Teina loina mugamugaina na mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na bwauna hinage loina mwala'ina teina dova iwalo, “Tomowa taumiya vahalimwai uvelauwedi, dova ubom uvelavelauwegone”. ");
INSERT INTO kud2014_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Loinao bwau teina loina maudoidi yo tauwalo mahalavao yadi walo maudoina adi wuwu.’ ");
INSERT INTO kud2014_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Haugana Palisiwone hilau ahaiyama, na Yeisu iwalo aulidi, iwalo, ");
INSERT INTO kud2014_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","‘Vedova Besinana towahona, yaiya natuna?’ Na hiwalo, ‘Deivida’. ");
INSERT INTO kud2014_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Na Yeisu iwalo, ‘Vedova ta mwalona Alu'aluwa Ve'ahihi Deivida i'abiye hanapu ta Deivida Besinana towahona i'awa Taubadaeine, iwalo: ");
INSERT INTO kud2014_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Yaubada i'aubabada yagu Taubada ainai iwalo, ‘Nimatautuwaguwai umiya ana higa am alehao yamwau aituluwedi aem elauhanai’.” ");
INSERT INTO kud2014_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Deivida iya Besinana i'awa badaei, vedova yede ta Deivida tubuna ainaena mulitai abo Besinana ilaoma?’ ");
INSERT INTO kud2014_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yeisu yana panivila teina nigele teya yaiya howahowana na iyemaiha, na hauganane tenem ainai nigele yaiya iya'atepatu ta iyapanivilauyo Yeisu ainai. ");
INSERT INTO kud2014_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Eeta Yeisu boda yo ana taumulitao aidiyai iwalo, ");
INSERT INTO kud2014_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","‘Mwalona Isileliwo Mosese iloiloinaedi na wau loina ana tauve'itao yo Palisiwo dova hinage hiloiloinaegomiu. ");
INSERT INTO kud2014_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ainaena hava dova hive'itagomiu ammulitaedi, na hesi yadi paihowao havena amveve'ao'aonaedi, wuwuna hiya hive'ita a'ava na nigele hiyapaipaihowaidi. ");
INSERT INTO kud2014_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Hiya ava'avala vitaidi tomowa himohemohedi na nigele habuluna hiya'aipate ta ava'avaladine aidiyena hiyahaguidi. ");
INSERT INTO kud2014_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","‘Yadi paihowa maudoina hipaipaihowaidi ta ebeha tomowa hi'itadi na hino'owedi, na walowone Buki Ve'ahihi ainaena leleleledi manidiyai yo nimadiyai hi'abiye patudi, na adi ale'o daodaodi hili'wali'wadi, ");
INSERT INTO kud2014_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","na guyau adi haugai nuwanuwadi vatavatai himiya yo hinage vada tapwalolo aidiyai abamiya namwanamwadi nuwanuwadi, ");
INSERT INTO kud2014_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","na ebe abagimwala aidiyai hilau nuwanuwadi na tomowa bagibagilidi hiwalo velauwedi, yo hi'awa tauve'itaedi. ");
INSERT INTO kud2014_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Na omiu nigele tomowa hiya'awa tauve'itaegomiu, wuwuna yami tauve'itane ehebo mohimohili, na maudoimiu amvetoyatoyawa. ");
INSERT INTO kud2014_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","‘Hinage havena teya yaiya bale'u ainai am'awa'awa “Tamaguwei”, wuwuna Tamamiu ehebo mohimohili galewai imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Havena hinage tomowa hi'awa'awa taubadaegomiu, wuwuna Besinana towahona yau yabom yami Taubada. ");
INSERT INTO kud2014_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Na ebe yaiya alimiyena ivetaumugai howahowana ivetaupaihowa alimiyai; ");
INSERT INTO kud2014_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","wuwuna ebe alimiyena i'abihiniuyoi mata imiya'aitulu, na hesi ebe yaiya imwau aituluweuyoi mata ihae. ");
INSERT INTO kud2014_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","‘Omiu loina ana tauve'itao yo Palisiwo atemuyamuyamiu, wuwuna yami oyamaena tomowa am'au'auhidi ta Yaubada yana Abaloina ainai nigele hiyaluwu. ");
INSERT INTO kud2014_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Omiu havena amluwuluwu wuwuna tomowa yaiyadiwo nuwanuwadi ebeha hiluwu am'au'auhidi. ");
INSERT INTO kud2014_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","‘Omiu loina ana tauve'itao yo Palisiwo atemuyamuyamiu, wuwuna ehebo teina yami pwanoli. Am'ada'adau ta'i'ili dalava bagibagilina aidiyai na ebeha ami taumulita ehebo amlobai, na mulitai tomowanane amve'ita ta dova omiu hava ampaipaihowaine iya dova ipaihowai, ta yana yababa imwala'i i'alili eeta ilowoinanei ta iya na omiu dalava ala'alahina am ve'alo. ");
INSERT INTO kud2014_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","‘Taumugaiwone atemuyamuyamiu, wuwuna omiu mehegibugibumiu, amwalo, “Ebe yaiya vada tapwalolo yehanaena i'awa tamada neta nigele teya hava, na hesi ebe yaiya goulaone vada tapwalolo holanai aidiyena i'awa tamada neta ginauli mwala'ina, ta ilowoinanei na ginaulidine ipaihowaidi”. ");
INSERT INTO kud2014_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Moiha, omiu yauyaulemiu na mehegibugibumiu! Hava ihae alili moiha? Vada tapwalolo ana goula, bo vada tapwalolo? Wuwuna vada tapwalolo ainaena goula i'a'abiye tabune. ");
INSERT INTO kud2014_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","‘Na hinage amwalo ebeha, “Ebe yaiya abapwaoli yehanaena i'awa tamada, neta nigele teya hava, na hesi ebe i'awa tamada velaunane abapwaoli ainai neta ginauli mwala'ina, na ebe hava iwalo yemidiyena'o howahowana ipaihowai”. ");
INSERT INTO kud2014_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Omiu yauyaulemiu! Hava mwala'ina? Velaune, bo abapwaoli? Abapwaoline ainaena velaune i'a'abiye tabune. ");
INSERT INTO kud2014_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","‘Ainaena ebe yaiya abapwaoli yehanaena i'awa tamada, iya hinage abapwaoli yana tobwatobwao maudoidi aidiyena i'awa tamada'o. ");
INSERT INTO kud2014_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na hinage ebe yaiya vada tapwalolo yehanaena i'awa tamada, iya hinage vada tapwalolo ana tobwatobwao yehanaena i'awa tamada'o. ");
INSERT INTO kud2014_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na ebe yaiya galewa yehanaena i'awa tamada, iya Yaubada na hinage yana abamiya yehanaena i'awa tamada'o. ");
INSERT INTO kud2014_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","‘Omiu loina ana tauve'itao yo Palisiwone atemuyamuyamiu, wuwuna omiu tau'oya'oyama. Moiha yami velau Yaubada ainai namwanamwana, wuwuna yami velauwone yami ginauli maudoidi aidiyena, tobwatobwa mwala'idi yo hinage ginauli iu'iudi dova vali yaba yo vali yaba aidiyena. Na hesi loina tonuga mwala'idi, amnuwapwanopwanowedi'o, neta mumuga dumwadumwaluna yo atemuyamuya na yemidi. Howahowana ginauli teina mwala'idine ampaihowaidi, na hinage havena ginauli iu'iuna amnuwanuwapwanopwanowedi. ");
INSERT INTO kud2014_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Omiu taumugaiwone mehegibugibumiu, ami li'u ainaena nabugala amvaivai vehuludi na hesi lagulagu mwala'idi kameli dova, amtonotonolidi. ");
INSERT INTO kud2014_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","‘Omiu loina ana tauve'itao yo Palisiwone atemuyamuyamiu moiha, wuwuna yami oyamaena ami vedi yo gaeba papali'a'avadi am'abi'abiye maseledi na hesi holadine bi'ibi'idi, neta aivavali yo mumuga yababadi hi'oiye mwaudi'o. ");
INSERT INTO kud2014_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Omiu Palisiwone mehegibugibumiu, ami vedi yo ami gaeba holadi am'abiye masele mugaiyedi, eeta ebe papalidine hinage himasele. ");
INSERT INTO kud2014_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","‘Omiu loina ana tauve'itao yo Palisiwone atemuyamuyamiu wuwuna omiu tau'oya'oyama, dova magai hewahewadi na masemaselena, ewanai adi ita namwanamwa gaugauna, na hesi holadiyai tomowa hilihiliyadi na ginauli bi'ibi'idi himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Omiu ami ita tomowa mehediyai ebeha taumugai namwanamwamiu, na holamiyai oyama na yababa maudoina himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","‘Omiu loina ana tauve'itao yo Palisiwone atemuyamuyamiu na tau'oya'oyama, wuwuna tauwalo mahalavao mugamugaidi adi magai aidiyai, abanuwatuwu avivini am'abi'abidi na hinage taudumwaluwo mugai adi abanuwatuwu avivini am'atu'atububunidi, ");
INSERT INTO kud2014_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","na amwalo, ebe mwalona tamiyamiya tubudao yadi haugai, havena tahaguhaguidi tauwalo mahalava adi oiyemwalowoi vehabana.’ ");
INSERT INTO kud2014_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yami walo teina ainaena amwalo mahalava ebeha tauwalo mahalava adi tau'oiye mwalowoiwone tubudiyao omiu. ");
INSERT INTO kud2014_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ainaena hiya yadi paihowaone mata amve'ovidi. ");
INSERT INTO kud2014_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","‘Omiu weso natunao, eeta nigele howahowana na dalava aiwa ala'alahina ainaena amdena. ");
INSERT INTO kud2014_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ainaena tauwalo mahalavao yo tauhanapuwo yo loina ana tauve'itao yavetamalediwa na mata tupwadi am'oiye mwalowoidi, nuwana aiwa lagalagana ainai amtutuye patudi, yo tupwadi yami vada tapwalolo aidiyai balavaiyena amsapidi, na dalava ehebo ehebo aidiyena amheusilidi. ");
INSERT INTO kud2014_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Eeta yana aba'ovi ainai, taudumwalu adi oiyemwalowoi ana maiha maudoina omiu mata amlobai. Towaho Abeli iya dumwadumwaluna hi'oiye mwalowoiya'o na ainaena ivetuwuni ta ana higa wau Balakaya natuna Sekalaya hinage hi'oiye mwalowoi vada tapwalolo na abapwaoli ahi'ahipudiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Moiha ta'i, oiyemwalowoi maudoidi adi maiha yaso teina mata amlobai. ");
INSERT INTO kud2014_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","‘Aee Yelusalem! Yelusalem vedova ta tauwalo mahalavao u'o'oiye mwalowoidine na hinage Yaubada yana tauyewasao gaimaena u'o'oiye mwalowoidine. Hauga maudoina nuwanuwagu na yam tomowao yayoga ahaidima dova am'am natunao pepenaena i'oi'au'auhidi, na hesi hita'wata'wataegau. ");
INSERT INTO kud2014_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ainaena Yaubada mata ilauvehulugo na umiya awawa. ");
INSERT INTO kud2014_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Na yawalo auligo ebeha mata nigele uya'itauyoigau ana higa yam tomowaone aliguwai hiwalo, “Iya Yaubada yehanaena ilaoma tano'owei”.’ ");
INSERT INTO kud2014_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yeisu vada tapwalolo mwala'ina habi lauvehuluna na ana taumulitaone hilaoma ta vada tapwalolo ana ita vehabana Yeisu hiveve'itane. ");
INSERT INTO kud2014_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Na Yeisu iwalo, ‘Vadaone, maudoidi am'ita'itadine, yawalo moiha howola abo maudoidi hilo'evehuludi na havena hinage teya gaima iyawenai imiyamiyauyo’. ");
INSERT INTO kud2014_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mulitai ilau Olibe oyana ainai, na ana taumulitao ainai hilaoma ta hibom himiyamiya na hipanivilaei, hiwalo, ‘Taubada, uwalo auligai aiteya hauga ainai vada tapwalolone hilo'evehulu, yo yam hauga wuyoma, yo hauga yana aba'ovi vehabana adi ve'ive'ilala uve'itagai ta ebe ahanapui’. ");
INSERT INTO kud2014_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Eena Yeisu iwalo aulidi, iwalo, ‘Am'ita avivinigomiu mata dova ta tomowa tupwadi hi'oyamaegomiu. ");
INSERT INTO kud2014_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Wuwuna howola abo tomowa bagibagilidi yehaguwena hilaoma ta ebeha himugai pwanoliyegomiu na ehebo ehebo iwalo, “Yau Besinana towahona”, na tomowa bagibagilidi himulitaedi. ");
INSERT INTO kud2014_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Hinage wasa howola abo ambenaledi alehao vahalimiyai na amwaha daodaowai vehabadi, na havena am'ate'atehawawali, wuwuna ginauli teina mata himahalava mugaima na hesi bale'u yana aba'ovi howola. ");
INSERT INTO kud2014_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Howola abo vali boda na vali boda aidiyai hilo'aleha, na hinage vali abaloina na vali abaloina aidiyai hilo'aleha, na vahali mwala'ina yo mwani'ini'i himahalava tupwa bagibagilidi aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Na ginauli teina hauga vitaidi adi abavetuwuni ta'i. ");
INSERT INTO kud2014_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","‘Omiu mata tomowa hi'abi avivinigomiu na hi'abiye muyamuyaegomiu nuwana hi'oiye mwalowoigomiu na tupwa maudoina tomowanao hive'alehaegomiu wuwuna omiu ebeha agu tauyemidiwo. ");
INSERT INTO kud2014_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Hauga vitai ainai howola abo bagibagilidi yadi yemidi itapiya na adi geluwo hihuhulaedi bo nuwana hi'alehaidi. ");
INSERT INTO kud2014_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Hinage tauwalo mahalava oya'oyamao mata himahalava na tupwadi himugai pwanoliyegomiu. ");
INSERT INTO kud2014_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Yo hinage mumuga yababana yana mwala'i ainaena tomowa bagibagilidi yadi velau atediyena itapiya. ");
INSERT INTO kud2014_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Na ebe yaiya i'alama'i'ita na itowolo wahiyala ana higa bale'u yana aba'ovi ainai yaliyaya miyamiya vateyaina mata ilobai. ");
INSERT INTO kud2014_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","‘Eena Yaubada yana Abaloina wasana namwanamwana higuguya mugaiyei tupwa vehopali aidiyai, abo mulitai hauga yana aba'ovi imahalava. ");
INSERT INTO kud2014_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","‘Howola abo ve'ive'ilalawa tauwalo mahalava Daniyela mugai iwawalo mahalavaeiwa imahalava, neta ginauli yababa alilina na didigana tupwa ve'ave'ahihina ainai itowolo. (Ebe yaiya walo teina ivahili howahowana inuwamasele.) ");
INSERT INTO kud2014_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Hauga tenem ainai Yudeya ana taumiyao ilowoinanedi ta oya aidiyai hidena. ");
INSERT INTO kud2014_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Na ebe yaiya vatavatai imiyamiya idena mwayamwayau, na havena iluwuluwuyo yana vadai yana tobwatobwa habi avala. ");
INSERT INTO kud2014_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Na ebe yaiya tanoviyai ipaipaihowa havena ilaulau gwaipile ana ale'o vali tupwai imwamwauwine vehabana. ");
INSERT INTO kud2014_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","‘Na hauga tenem ainai tauhiuhiumao yo tauvehuhuwo hive'atemuyamuya. ");
INSERT INTO kud2014_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ainaena am'awa'awanoi ta hauga namwanamwana Yaubada imohegomiu hauga dena ainai, na havena gwaugwau ana haugai, bo Tapwalolo ana ahubena ainai. ");
INSERT INTO kud2014_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","‘Moiha, hauganane ivitai ali'alili, wuwuna bale'u yana abavetuwuni ainaena ta wau nigele teya hinage vitai dova, na mulitai vitaine mata nigele iyamahalavauyo. ");
INSERT INTO kud2014_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Vitaine ana hauga ebe Yaubada nigele iya'abiye ahubali, mata tomowa maudoidi himwalowoi, na hesi Yaubada haugane i'abiye ahubaliya'o, neta yana tomowa ita'itasipwadi vehabadi. ");
INSERT INTO kud2014_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","‘Ainaena ebe yaiya iwalo auligomiu iwalo, “Besinana teina”, bo “Besinana tenem”, havena amyemiyemidiyei. ");
INSERT INTO kud2014_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Wuwuna Besinana oya'oyama yo tauwalo mahalava oya'oyama mata himahalava na ve'ive'ilala wahiwahiyaladi aidiyai hive'itaedi na aidiyena ebe howahowadi Yaubada yana tomowao vesivesinuwadi hinage ebeha hi'oyamaedi. ");
INSERT INTO kud2014_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Na omiu ginauli teina vehabana bada yawalo mahalavaena'o alimiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","‘Eeta ebe hiwalo auligomiu, hiwalo, “Besinana balabala awawai imiyamiya”. Havena balabala awawai amlaulau. Na ebe hiwalo, “Besinana vada holanai moiha imiyamiya”, havena amyemiyemidiyedi. ");
INSERT INTO kud2014_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yau Tomowa Moihagu, na yagu laugwaipilema ana ita dova pigabu mwala'ina bomatuwena ilohawawali na ana higa bwauli. ");
INSERT INTO kud2014_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","‘Aiteya tupwa lagulagu mwalomwalowoina i'eno'eno ainai neta ainai ao'ao hitautau'ahaiyama. ");
INSERT INTO kud2014_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","‘Na hauga vitainane i'ovi na mulitai mahana yana wahiyala mata itapiya na iguguyou, yo hinage wai'ena yana masele iboho, na utui galewaena hibe'u, yo ginauli maudoina galewai himiyamiya yadi wahiyala hitapiya. ");
INSERT INTO kud2014_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Yau Tomowa Moihagu, na hauga tenem ainai yagu ve'ive'ilala galewaena imahalavama, na boda maudoidi bale'uwai hi'itagau yaloyalovi ewanaena mayagu wahiyala na mayagu wasawasa mwala'ina yalaolaoma, na hidoudou ta'eta'e. ");
INSERT INTO kud2014_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Hinage yoguli hiyuvi yo yagu tausagenawasao yavetamaledi na yagu boda vesivesinuwadi hitano'ahaidima bale'u maudoina ainai na yaumai tupwa vehopali aidiyena. ");
INSERT INTO kud2014_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","‘Aba'ita hapelo ainaena yave'itagomiu neta ebe hapelo luguna vauvaudi imwamwauwidi amhanapuiya'o ebeha ehive ana hauga imamahalava. ");
INSERT INTO kud2014_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Na hinage ebe ve'ive'ilalaone hava yawawalo auligomiuwa am'ita lobaidi bada amhanapuiya'o ebeha yagu hauga laugwaipilema bada ilautebitebiniya'o na mata imahalava wuwuna awa'edai yatowotowolo. ");
INSERT INTO kud2014_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Moiha ta'i, yaso teina mata nigele amya'ovi ana higa ginaulidine maudoina himahalava mugai. ");
INSERT INTO kud2014_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Howola abo galewa na bale'u hisawali, na yagu walo mata nigele hiyasawali. ");
INSERT INTO kud2014_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","‘Hauga tenem ainai nigele teya yaiya iyahanapui aiteya ahubena bo mahana dova hinage tausagenawasa galewai nigele hiyahanapui. Yau Yaubada Natuna hinage nigele yayahanapui na Tamagu ibom mohimohili ihanapuiya'o. ");
INSERT INTO kud2014_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Yau Tomowa Moihagu yagu hauga laoma dova Nowa yana haugai. ");
INSERT INTO kud2014_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Wuwuna Nowa yana haugai tomowa hi'ai'ai na hinumanuma na hivevetawahola na hinage hitawatawahola, na ana higa Nowa yana wagai igegelune; ");
INSERT INTO kud2014_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","na abaita idobi ta ive'aluwagavaidine, ainaena tomowa maudoidi hihanene; eeta yau Tomowa Moihagu yagu wuyoma dova. ");
INSERT INTO kud2014_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","‘Hauga tenem ainai ebe towatowaho hitau bwau hipaipaihowa tanovi holanai, ehebo yalauvai na ehebo imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Hinage ebe waiwaihiu hitau bwau hi'eha'ehalo, ehebo yalauvai na ehebo imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ainaena am'ita avivini ili'ilimani, wuwuna yau yami Taubada yagu wuyoma ana hauga nigele amyahanapui. ");
INSERT INTO kud2014_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Na amnuwatuwu avivini neta ebe vada taniwagana masigiliyena tau'aivavali yana laoma ana mahana ihanapui mata, i'atububu moiha na ihilahilawa ta ebe havena yana vadai i'ai'aivavali. ");
INSERT INTO kud2014_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ainaena omiu hinage am'atububu ili'ilimani na yagu wuyoma vehabana amha'waigau, wuwuna yau Tomowa Moihagu yagu wuyoma ana mahana nigele amyahanapui. ");
INSERT INTO kud2014_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","‘Taupaihowa namwanamwadi na hanahanapudi mumugadi teina dova: ebe yaiya iya yana taubada i'ita sipwai ta vada i'ita avivini na taupaihowa tupwadi adi imohemohe ahubena ehebo ehebo, ");
INSERT INTO kud2014_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","howola abo taubadane ilau gwaipilema na yana taupaihowane ilobai ipaipaihowa dumwadumwalu mata vehabana iyaliyaya na ainai iwalo, ");
INSERT INTO kud2014_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","“Yam paihowa namwanamwana vehabadi yayaliyaya, ainaena ginauli maudoina adi loina yamohego ta uloina”. ");
INSERT INTO kud2014_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","‘Na hesi ebe taupaihowane imumuga yababa mata ibom ainai iwalo, “Yagu Taubadane yana laugwaipilema ibwedabweda”, ");
INSERT INTO kud2014_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","na ivetuwuni ta taupaihowaowa tupwadi i'aitutuwedi yo i'ai'ala'alabili nuwana inumanuma yauyaule. ");
INSERT INTO kud2014_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Eeta yana badawa ive'aluwagavaiyama na yana paihowa yababana i'ita lobai, wuwuna taubadane yana laoma mahanana nigele iyahanapui. ");
INSERT INTO kud2014_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ta elepa daodaona ainaena igohamutu na tau'oya'oyamao baidanao imwau eheboidi ma'adi muya hidoudou na awadi hivetau'alahedi.’ ");
INSERT INTO kud2014_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yeisu hinage iwalo aulidi, iwalo, ‘Yaubada yana Abaloina teina dova: Vavahala nimabwaubwau yadi lampa hivaidi na hilalaune tautawahola towahona ebeha baidadi hivelaulobaloba yana tawahola guyauna ainai. ");
INSERT INTO kud2014_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Aidiyena hitau nima ehe'ehebo yauyauledi na nima ehe'ehebo hanahanapudi. ");
INSERT INTO kud2014_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Na yauyaulediwa yadi lampa ana bwahi ana lauhepoi nigele hiyavaidi, ");
INSERT INTO kud2014_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","na hesi hiya hanahanapudiwa yadi bwahi ana lauhepoi hivaidi'o yadi lampao baidadiyao. ");
INSERT INTO kud2014_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","‘Na tautawahola towahonawa ibwedabweda, eeta maudoidi hiha'waha'wa ta hi'e'eno'i iwahine. ");
INSERT INTO kud2014_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Na bada boniyai holana ta ehebo tomowa iwui, iwalo, “Tautawahola towahonawa bada teina ilalaoma. Amtowolo na tayaliyayai.” ");
INSERT INTO kud2014_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ta vavahalaowa maudoidi hitowolo yadi lampawowa hi'atu'atububuni. ");
INSERT INTO kud2014_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Na vavahalaowa yauyaulediwowa adi geluwone aidiyai hi'awanoi, hiwalo, “Ama geluwo, lampa ana bwahi tupwana ammohegai, wuwuna yama lampa bada habi bohodi”. ");
INSERT INTO kud2014_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘Na tauhanapuwowa hiwalo, “Nuwana nigele howahowana yama bwahi tupwana amohegomiu, bada omiu amlau tauvegimwalao aidiyai na yami lampa adi bwahi amgimwalaidi”. ");
INSERT INTO kud2014_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","‘Eeta hilaulau habi gimwala, na tautawahola towahonawa imahalava ta hiya bada hi'atububu'o baidanao hiluluwune tawahola guyauna vehabana, na awa'eda higuguduine. ");
INSERT INTO kud2014_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Mulitai adi geluwowa gimwalaena hiwuyoma ta hiwalo, “Taubada gudu uho'e ta aluwuwa”. ");
INSERT INTO kud2014_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","‘Na yadi walo iyemaiha, iwalo, “Omiu vali boda, nigele yayahanapuigomiu”. ");
INSERT INTO kud2014_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","‘Ainaena am'ita avivinigomiu, wuwuna yagu hauga laugwaipilema ahubenana nuwana mahanana nigele amyahanapui. ");
INSERT INTO kud2014_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","‘Yaubada yana loina hinage dova ehebo taubada mata ilalau vali tupwa, na yana taupaihowao iyogaedima ta iloinaedi ebeha yana abaloina hi'ita avivini. ");
INSERT INTO kud2014_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Eeta ehebo yana manene yana taupaihowawa imohei ana bagibagili 5,000 kina na towaho bwauna 2,000 kina, na towaho tonugana 1,000 kina, eeta yana aiyauyane aidiyai hiya ehebo ehebo yana hanapu dova, na mulitai taubadanane ilaugabaidi ilalaune amwaha daodaowai. ");
INSERT INTO kud2014_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","‘Ainaena towahowa iya mayana 5,000 kina yana taubada yana manewa ivaidi ta aidiyena iyepaihowadi ta adi lauhepoi 5,000 kina hinage ilolobaine. ");
INSERT INTO kud2014_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Towaho bwauna hinage dova yana 2,000 kinawa iyepaihowa ta ainaena yana taubada yana mane ana lauhepoi 2,000 kina ilolobaine. ");
INSERT INTO kud2014_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Na towaho tonugana, iya mayana 1,000 kina, ivai ta toputopu i'eli na yana taubada yana manewa idadawanine toputopu holanai. ");
INSERT INTO kud2014_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","‘Na hauga daodaona tuluhanai yadi taubadawa ilau gwaipilema na ipanivilaedi yadi paihowawa ainona vehabana. ");
INSERT INTO kud2014_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ainaena towaho iya mayana 5,000 kina ilaoma ma'ana lauhepoi 5,000 kina hinage ilawenama ta imomoheine na iwalo, “Taubada 5,000 kina umomohegaune na 5,000 kina hinage yalolobaine, ta teina manenaede”. ");
INSERT INTO kud2014_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‘Na yana taubadawa iwalo, “Ausala, owa taupaihowa namwanamwana na dumwadumwaluna moiha. Bada upaihowa wahiyala'o ginauli iu'iudi aidiyena, ainaena am loina ginauli mwala'idi vehabadi yamohego, na hinage yagu abayaliyaya teina ainai umiyamiya”. ");
INSERT INTO kud2014_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","‘Mulitai towaho bwauna mayana 2,000 kina imahalava na iwalo, “Taubada, 2,000 kina umomohegaune na ana lauhepoi hinage 2,000 kina yalolobaine, ta teina”. ");
INSERT INTO kud2014_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘Na taubadawa iwalo, “Ausala, owa taupaihowa namwanamwana na dumwadumwaluna. Bada upaihowa wahiyala'o ginauli iu'iudi aidiyena, ainaena am loina ginauli mwala'idi vehabadi yamohego na owa hinage yagu abayaliyaya teina ainai umiyamiya.” ");
INSERT INTO kud2014_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","‘Eena towaho tonugana yana 1,000 kina ilawenama na iwalo, “Taubada yahanapuigo'o owa towaho yaiyaim na yam wasawasa uvaivaine vali tomowa yadi paihowa aidiyena, ");
INSERT INTO kud2014_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ainaena yameheuhi ta 1,000 kinawa toputopu holanai yadadawanine, na yam manewa teina”. ");
INSERT INTO kud2014_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","‘Na taubadawa iwalowei, “Owa taupaihowa yababam na tau'abitau'wata ehebo, uhanapuigau'o neta yagu wasawasa yavaivaine vali tomowa yadi paihowa aidiyena, ");
INSERT INTO kud2014_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","eeta howahowana yagu manene banika ainai umwauwi, ta haugana yawuyoma ma'ana lauhepoi yalobai”. ");
INSERT INTO kud2014_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ta yana hevahevaliwo aidiyai iwalo, “Yagu 1,000 kina ainaena amvai ta towahowa iya 10,000 kina ilolobaine ammohei”. ");
INSERT INTO kud2014_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Wuwuna ebe yaiya ana ava'avala iyepaihowa mata, ana lauhepoi hinage ilobai, ta imwala'i i'alili, na ebe yaiya nigele ana ava'avala iyapaihowai, hava ainai imiyamiyane howola abo ainaena hivaivehulu. ");
INSERT INTO kud2014_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ainaena yana hevahevaliwo iloinaedi ta taupaihowa yababawa higabae mahalavaei maseleyai tupwa guguyou ainai, tenem ainai tomowa ma'adi muya hidoudou na awadi hivetau'alahedi baidanao. ");
INSERT INTO kud2014_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","‘Yau Tomowa Moihagu, howola abo mayagu wasawasa pigapigabuna na mayagu tausagenawasao alaoma na yagu vatavata wasawasa ainai yamiya, ");
INSERT INTO kud2014_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","na abaloina bale'uwai maudoina meheguwai hitano'ahaidima na yave'ahadi dova sipi adi tau'ita avivini ive'ahadi gouti aidiyena, ");
INSERT INTO kud2014_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","na sipi yamwauwahiyedi nimatautuwaguwena na gouti nima'eha'ehaguwena. ");
INSERT INTO kud2014_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Na yau yadi tauwasawasa howola mata hiya nimatautuwaguwena aidiyai yawalo, “Omiu Tamagu yana velauwena amyaliyaya, amlaoma na yami abaloinawa bale'u ana abavetuwuni ainai i'atububuniwa vehabamiu amvai. ");
INSERT INTO kud2014_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Wuwuna mwalona yavahali na ai'ai ammohegau, na hinage gadogu imaguni na bwahi ammohegau, na hinage yavetaumana yami dalavai na amyogaegau yami vadai, ");
INSERT INTO kud2014_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","na hinage nigele agu ale'o na ale'o ammohegau ta yalili'wane, na hinage yalovala na am'ita avivinigau, na hinage vada abapaiyai yamiyamiya na amtautaubo'eyegau.” ");
INSERT INTO kud2014_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","‘Na taudumwaluwowa aliguwai hiwalo, “Taubada, aiteya hauga yede a'i'itagone ma'am vahali na ai'aine aveve'aigone? Bo gadom imagu na bwahi amomohegone? ");
INSERT INTO kud2014_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Bo uvetaumana yama dalavai na ayoyogaegone yama vadai? Bo nigele am ale'o na aveveli'wagone? ");
INSERT INTO kud2014_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","bo nuwana ulovala bo vada paipaiyai umiyamiya na atataubo'eyegone?” ");
INSERT INTO kud2014_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Eena yawalo aidiyai, “Ehe! Neta moiha, ebe yaiya owa augeluwo iu'iudi ehebo aidiyena uhagui, neta ainai yau hinage uhahaguigaune”. ");
INSERT INTO kud2014_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","‘Na hiya nima'eha'ehaguwena himiyamiyane yawalo aulidi, yawalo, “Omiu yababamiu amlauvehulugau amlau aiwa ala'alahi miyamiya vateyaina ainai, neta Yaubada i'atububuniya'o Tomodulele mayana bodao vehabadi, ");
INSERT INTO kud2014_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Wuwuna mwalona mavahaligu na nigele ai'ai amyamohegau, hinage gadogu imaguni na nigele bwahi amyamohegau, ");
INSERT INTO kud2014_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","na yavetaumana yami dalavai na nigele amyayogaegau yami vadai, yo nigele agu ale'o na nigele amyaveli'wagau, yo yalovala na vada abapaiyai yamiyamiya na nigele amyataubo'eyegau.” ");
INSERT INTO kud2014_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","‘Mulitai hiya walo teina hiyemaiha hiwalo, “Taubada, aiteya hauga a'i'itagone ma'amvahali, nuwana gadom imaguni, bo nuwana uvetaumana alimayai, nuwana nigele am ale'o, bo ulovala, bo vada abapaiyai umiyamiya na nigele ayahaguigo?” ");
INSERT INTO kud2014_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","‘Na yawalo, “Moiha ta'i haugadine aidiyai ebe tomowa iu'iudi teina dova nigele amyahagui, neta ainai nigele amyahaguigau”. ");
INSERT INTO kud2014_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Eeta hiya abo hilau muya miyamiya vateyaina ainai, na Taudumwalu hesi hiya yawahi miyamiya vateyaina hilobai.’ ");
INSERT INTO kud2014_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yeisu yana aubabadao ive'ovidi, na ana taumulitao iwalo aulidi, ");
INSERT INTO kud2014_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","iwalo, ‘Amhanapuiya'o ahubena bwau, na Buidi'wa guyauna tapaihowai, na ebe agu tauhuhulane ihuhulaegau agu alehao aidiyai, na aiwa lagalagana ainai hitutuye patugau yau Tomowa Moihagu’. ");
INSERT INTO kud2014_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Na taupwaoli mwala'idi yo Isileli yadi babadao hitau'ahai Kayapasi yana vada mwala'ina ainai, iya taupwaoli yadi taubada mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Na babadaowa hibom hiloina ta ebeha oyamaena Yeisu hi'abi avivini na hi'oiye mwalowoi, ");
INSERT INTO kud2014_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","na hiwalo, ‘Havena Buidi'wa guyauna holanai Yeisu ta'abi'abi avivini, mata dova ta tomowa himodi'iniyegita na hi'alehaegita’. ");
INSERT INTO kud2014_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Haugana Yeisu Betani ainai imiyamiya, Saimoni yana vadai, iya mwalona taulepelo teya. ");
INSERT INTO kud2014_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Na ehebo waihiu mayana woloi ilalaomane, na woloinane ana maiha mwala'ina na gaimapatu namwanamwagaugauna ainai. Yeisu howola vadai i'ai'ai, na waihiunane ilaoma ta woloiwa Yeisu vahunai ihihiwaine. ");
INSERT INTO kud2014_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Na Yeisu ana taumulitaowowa hi'ita ta waihiuwa hi'ulumiyanei hiwalo, ‘Hava wuwuna woloi iyepaipaihei? ");
INSERT INTO kud2014_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ilowoinanei ebe woloinane hivegimwalaei na ana maiha mwala'ina hivai ta tauwewelohe himohedi.’ ");
INSERT INTO kud2014_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Na Yeisu yadi walo teina ibenalena'o, ta iwalo, ‘Havena waihiu teina am'ulu'ulumiyaei, wuwuna yana velau teina aliguwai inamwanamwa moiha. ");
INSERT INTO kud2014_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tauwewelohewo amwalowalowedine hauga maudoina vahalimiyai himiyamiya, na yau hesi mata nigele hauga daodaona baidamiu tayamiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Waihiu teina bada iyewoloigau'o taugu ana mwau magaiyai vehabana. ");
INSERT INTO kud2014_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Na moiha, howola abo wasagu ana guguya tomowa hibenalei bale'u maudoina ainai, na waihiu teina yana paihowa aliguwai ana abanuwatuwu avivini au'aubabadana hiyewasaei hinage.’ ");
INSERT INTO kud2014_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Na Yeisu ana taumulita ehebo yehana Yudasa Isakaliyota ilau taupwaoli mwala'idi aidiyai, ");
INSERT INTO kud2014_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","na iwalo, ‘Viha agu maiha mata ammohegaune ebe Yeisu alimiyai yahuhulaei?’ Eeta mane siliba ana bagibagili 30 himomoheine. ");
INSERT INTO kud2014_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Eena Yudasa yana hawahawaga iha'waha'wai ta ebe Yeisu aidiyai ihuhulaei. ");
INSERT INTO kud2014_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Buidi'wa guyauna hipaihowai beledi a'avana nigele ana abiye seseha hauga ainai. Na Buidi'wa ana ahubena mugamugaina ainai Yeisu tupwadi ana taumulitao hilaoma ainai na hiwalo, ‘Aiteya vada ainai nuwanuwam ebe guyau vehabam a'atububuni?’ ");
INSERT INTO kud2014_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Na Yeisu iwalo, ‘Amlau Yelusalem na yagu awanoi ehebo towaho ainai amwalowei, amwalo, “Taubada yana walo teina dova: Yagu hauga bada ilautebitebiniyao ta nuwanuwagu yam vadai Buidi'wa guyauna ma agu taumulitao a'ai”.’ ");
INSERT INTO kud2014_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Na ana taumulitaowowa Yeisu yana walo himulitaei ta towahowa yana vadai Buidi'wa guyauna hi'a'atububunine. ");
INSERT INTO kud2014_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Na lavilaviyena Yeisu mayana taumulitao hitau 12 hiluwu ta guyaune hi'a'aine. ");
INSERT INTO kud2014_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Na haugana hi'ai'ai Yeisu iwalo, ‘Augeluwo, yawalo moiha mata ehebo alimiyena ihuhulaegau’. ");
INSERT INTO kud2014_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Na Yeisu yana walo teina vehabana hinuwayababa moiha, ainaena ehebo ehebo Yeisu ainai hipanivila, hiwalo, ‘Taubada, yaiya neta? Nuwana yau?’ ");
INSERT INTO kud2014_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Na Yeisu iwalo, ‘Towahonane iya baidagu gaeba ehebo ainaena a'ai'aine, iya mata ihuhulaegau. ");
INSERT INTO kud2014_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yau Tomowa Moihagu mata yamwalowoi dova mwalona Buki Ve'ahihi ainai iwalo mahalava mugaiyei vehabagu, na hesi agu tauhuhulane ive'atemuyamuya, bada ebe mwalona hinanane havena ilabalabahi mata inamwanamwa alili.’ ");
INSERT INTO kud2014_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ainaena ana tauhuhulane Yudasa iwalo, ‘Taubada, aiteya towaho yede? Nuwana yau?’ Na Yeisu iwalo, ‘Bada neta uwalowego'o’. ");
INSERT INTO kud2014_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Howola hi'ai'ai na Yeisu ai'ai ivai ta vehabana iwalovelau na i'abitomwahi ta ana taumulitao imohedi, iwalo, ‘Teina taugu amvai ta am'ai’. ");
INSERT INTO kud2014_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Na waini mavedina hinage ivai ta vehabana iwalovelau Yaubada ainai na imohedi, na iwalo, ‘Maudoimiu amnuma. ");
INSERT INTO kud2014_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Teina 'wahinagu, Yaubada yana ulewahi loina vehabana, isagesagena tomowa bagibagilidi yadi yababao ana abanuwahamu. ");
INSERT INTO kud2014_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Na yawalo auligomiu hauga teina na tuluhanai waini teina havena ainaena yanumanumauyo na ana higa omiu baidaguwao waini vauvauna tanuma Tamagu yana abaloina ainai.’ ");
INSERT INTO kud2014_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Eena wali ehebo hiwaliwaliyei na himahalava ta hihahaene oya Olibe. ");
INSERT INTO kud2014_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yeisu iwalo aulidi, iwalo, ‘Mata boniyaiyena maudoimiu amdena vehulugau dova Buki Ve'ahihi yana walomahalava, iwalo: “Sipi adi tau'ita avivini ya'oiye i'iwahi na sipi maudoina hitaubudebudeyanaei”. ");
INSERT INTO kud2014_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Na yagu towolouyo tuluhanai Galili ainai yamugai na omiu tuluhaguwena amlaowa’. ");
INSERT INTO kud2014_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Na Pita yana walo iyemaiha, iwalo, ‘Mata maudoidi hidena gabaego na yabom baidam’. ");
INSERT INTO kud2014_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Na Yeisu Pita ainai iwalo, ‘Yawalo moiha boniyai teina mata, mulitai abo am'am idou, owa mata mai tonuga uuvalaegau’. ");
INSERT INTO kud2014_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Na Pita iwalo, ‘Taubada, nigele howahowana yauvalaego! Ebe hi'oiye mwalowoigo yau hinage baidam hi'oiye mwalowoigita’. Taumulitaowa maudoidi hinage dova hiwawalone. ");
INSERT INTO kud2014_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Eena Yeisu mayana taumulitao baidanao hilau tanovi ehebo yehanaede Getesemani ainai, na iwawalo aulidine, iwalo, ‘Teinai ammiyamiya, na yau yawutuhae, na ya'awanoi Yaubada ainai’. ");
INSERT INTO kud2014_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Na hitau tonuga ilauvaidi Pita yo Sebedi natunao bwau. Na Yeisu mayana atemuyamuya na mayana nuwayababa iwalo aulidine, ");
INSERT INTO kud2014_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","iwalo, ‘Ategu imuyamuya mwala'ina, nuwana muhamuhana na mata yamwalowoi, ainaena teinai ammiyamiya na am'ita'ita avivini baidaguwao’. ");
INSERT INTO kud2014_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Na Yeisu ihae tupwana na ibe'u aitulu bale'uwai, na i'awanoi, iwalo, ‘Tamagu ee, ebe howahowana muya vedina teina aliguwai uvaivehulu, na havena ainaena yanumanuma, na owa hesi yam nuwatuwuwena upaihowai, na nigele yau yagu nuwatuwuwena’. ");
INSERT INTO kud2014_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","I'ovi na ilau gwaipileuyo ta ana taumulitaowowa hitau tonuga bada hi'eno'o, na Pita ivanoi na iwalo, ‘Pita, nigele howahowana na mahana hawahawaga ehebo ta'ita'ita'auhi?’ ");
INSERT INTO kud2014_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Na hinage iwalo maudoidi aidiyai, iwalo, ‘Amhilahilawa na am'awa'awanoi yo ebe havena towoi amve'ave'alo. Moiha ta'i, alu'aluwamiu nuwanuwana na hesi taumiu hitapiya’. ");
INSERT INTO kud2014_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Na Yeisu iheuyo na i'awa'awanoi, iwalo, ‘Tamagu, muya vedina teina nigele nuwanuwagu ainaena yanuma na hesi ebe yam nuwatuwu, yamulitaei’. ");
INSERT INTO kud2014_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Na Yeisu ilau gwaipileuyo ana taumulitao aidiyai, na ilobaidi hinage hi'eno i'iwahi'o, wuwuna mehedi i'eno'eno alili. ");
INSERT INTO kud2014_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Na hinage ilau vehuludi yo ilau yana awanoi itonugai dova yana awanoi bwauwone. ");
INSERT INTO kud2014_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Na ilau gwaipilema ana taumulitao ivanoidi, iwalo, ‘Howola am'eno'eno yo am'ai'aiyawasi? Na am'ita Tomowa Moihagu yau yagu hauga bada imahalava'o na hihuhulaegau tauyababao aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Amtowolo talau, wuwuna agu tauhuhulawa teina bada imahalava'o.’ ");
INSERT INTO kud2014_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yeisu howola i'au'aubabada na ehebo ana taumulitawa yehana Yudasa tau'alehawone baidanao himamahalavamane. Taupwaoli mwala'idi yo Isileliwone yadi babadao, tau'alehawone hivetamaledine Yudasa baidadi, na bodaone mayadi elepa ale'aleha yo wepasi Yeisu habi abi'avivinina. ");
INSERT INTO kud2014_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yudasa ve'ive'ilala bada iwalowena'o na aidiyai iwalo, ‘Ebe yaiya yanihoi neta iya Yeisunane, na am'abi avivini’. ");
INSERT INTO kud2014_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Eeta idumwalu Yeisu ainai, inihoi na ivelauwei, na iwalo, ‘Yauwedo Taubada’. ");
INSERT INTO kud2014_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Na Yeisu iwalo, ‘Augelu hava vehabana ulalaomane?’ Eena bodaone himahalava ta Yeisu hi'abi avivinine. ");
INSERT INTO kud2014_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Na Yeisu ana bodao aidiyena ehebo yana elepa iwunihiyama ta Taupwaoli mwala'ina yana taupaihowa talinana itom vehulune. ");
INSERT INTO kud2014_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Na Yeisu towahone iwawalo auline, iwalo, ‘Badagi! Elepa ale'alehane umwauyoi yana abamwauwai. Wuwuna tau'alehawone aleha yadi abamwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Uhanapui ebeha ebe nuwanuwagu Tamagu ainai ya'awanoi agu hagu vehabana, bada mata tausagenawasa bahu'alilidi ivetamaledima. ");
INSERT INTO kud2014_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Na nigele! Wuwuna teina amwahane ainaena Buki Ve'ahihi yana walomugai vehabagu mata adi moiha himahalava.’ ");
INSERT INTO kud2014_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tenem ainai Yeisu bodaone iwalo aulidi, iwalo, ‘Ebeha yau tau'aivavali ta ainaena mayami elepa ale'aleha yo wepasi amlaoma habi abi'avivinigau! Na hava wuwuna ahubena maudoidi vada tapwalolo mwala'ina ainai yamiyamiya na yave'ive'ita tomowa aidiyai, na nigele amya'abi avivinigau? ");
INSERT INTO kud2014_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Na ginauli teina himahalava yo ebe tauwalo mahalavao yadi walomugai Buki Ve'ahihi holanai himahalava.’ Na Yeisu ana taumulitaone maudoidi hidedena vehulune. ");
INSERT INTO kud2014_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bodaone bada Yeisu hi'abi aviviniya'o na hilauvaiyama taupwaloliwone yadi taubada mwala'ina yehana Kayapasi ainai. Na Kayapasi yana vadai loina ana tauve'itao yo babadao bada hihulu'ahaima'o ta himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Na Pita amwaha daodaowena Yeisu imulitaeine, ta ilaoma Taupwaoli mwala'ina yana vada ana abwalu ainai iluwu, na tau'ita aviviniwone baidanao himiyamiya yo ebe Pitanane Yeisu ana loina ibenalei. ");
INSERT INTO kud2014_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Na Taupwaoli mwala'idi yo tau'ulewahiwo nuwanuwadi Yeisu ana ve'ewa oya'oyama hilobai na yadi ve'ewa oya'oyama ainaena ebe Yeisu hi'oiye mwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ainaena tauve'ewa oya'oyamawa hilaoma, na hesi yadi ve'ewa nigele dumwaludi. Na mulitai towatowaho bwau hiwutumahalava, ");
INSERT INTO kud2014_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","na hiwalo, ‘Mwalona Yeisu iwalo, “Howahowagu Yaubada yana vada yalo'e vehulu na ahubena tonuga aidiyai ya'abiuyoi”.’ ");
INSERT INTO kud2014_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Eena taupwaoliwo yadi tauloina mwala'ina itowolo, na iwalo, ‘Nigele yam yemaiha, awa? Tomowa yadi ve'ewa alimwai ubenaledi'o?’ ");
INSERT INTO kud2014_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Na Yeisu bada inobu, na Taupwaoli mwala'ina Yeisu iwalo auline, ‘Uwalo moiha Yaubada Mayawahina mehenai, owa ainaede Besinana towahona, Yaubada Natuna, bo nigele?’ ");
INSERT INTO kud2014_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Na Yeisu iwalo, ‘Neta bada uwalowena'o, na hinage yawalo alimwai howola abo yau Tomowa Moihagu am'itagau Tauwahiyala moiha nima tautuwanai yamiyamiya yo hinage galewa yaloyalovinao ewadiyena yalaolaoma’. ");
INSERT INTO kud2014_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ainaena Taupwaoli mwala'ina imodi'ini moiha ta ibom ana ale'o ipulihi, na iwalo, ‘Yana walo yababadi ambenaledi'o? Moiha, towaho teina Yaubada ihinali. Badagi! Havena hinage tauve'ewa hiwalowalo yana pwanoliwone vehabadi. ");
INSERT INTO kud2014_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Vedova yami nuwatuwu Yeisu vehabana?’ Na hiya hiwalo, ‘Iloweinanei ebe imwalowoi’. ");
INSERT INTO kud2014_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ainaena maninane hihowai yo higoha navanavai, yo hinage hisapi, ");
INSERT INTO kud2014_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","na hipanivilaei hiwalo, ‘Ebe owa Besinana towahona, uwalo mahalava alimaiyai yaiya isasapigone?’ ");
INSERT INTO kud2014_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Na Pita howola abwalu alonai imiyamiya, na taupaihowa vahavahalana ehebo imamahalavamane ta ipanivilaeine, iwalo, ‘Mwalona towahowa Galiliyenawa Yeisu iya baidam ammiyamiya, awa?’ ");
INSERT INTO kud2014_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Na tomowa bagibagilidi mehediyai Pita iuvala, iwalo, ‘Ginauli hava uwalowaloweine nigele yayahanapui’. ");
INSERT INTO kud2014_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Na Pita iwutu mahalava tupwana abwalu awa'edanai. Na ehebo vahala Pita i'ita, na taumiyaone aidiyai iwalo, ‘Towaho tenem mwalona Yeisu towaho Nasaleti baidana himayamiya’. ");
INSERT INTO kud2014_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Na Pita iuvalauyo na iwuluma, iwalo, ‘Yaubada ihanapui ebeha towahone yau nigele yayahanapui’. ");
INSERT INTO kud2014_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hauga iu'iuna ainai tauvinunuwone Pita ainai hilaoma, na hiwalo, ‘Moiha u'oyama! Owa Yeisu yana boda ehebo, wuwuna alinamne dova Galili alinadi.’ ");
INSERT INTO kud2014_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Eena Pita ivuluma na walo yababana ainaena iwalo, ‘Tamada! Towaho neta nigele yayahanapui’. Na hauga tenem ainai am'am idou. ");
INSERT INTO kud2014_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ainaena Pita Yeisu yana walowa inuwatuwui ebeha, ‘Mulitai abo am'am idou, na owa mai tonuga uuvalaegau’. Ainaena Pita nuwana iyababa mwala'ina, na imahalava maseleyai idodoune. ");
INSERT INTO kud2014_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Malatomtomwena Taupwaoli mwala'idi yo babadaone maudoidi hiloiloina ebeha Yeisu hi'oiye mwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ainaena Yeisu nimana hipaidi na hilawei Loma yadi tauloina mwala'ina Pailato ainai yo ebeha Pailato iloinaei. ");
INSERT INTO kud2014_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Na Yeisu ana tauhuhulane, Yudasa ihanapuiya'o ebeha mata Yeisu hi'oiye mwalowoi, ta inuwabui na yana mane 30 siliba iwuyowedi taupwaoliwo mwala'idi yo babadao aidiyai, ");
INSERT INTO kud2014_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","na iwalo, ‘Bada lauhapuli yapaihowaiya'o wuwuna towaho namwanamwana alimiyai yahuhulaena'o’. Na hiwalo, ‘Neta nigele teya hava alimaiyai, na owa hesi vehabana unuwatuwu’. ");
INSERT INTO kud2014_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ainaena manewone 30 ivehulu aituluwedi vada tapwalolo mwala'ina holanai, na imahalava ta ilau, na balavaiyena gadona ibom ihipwa'i'iuyoi na imwamwalowoine. ");
INSERT INTO kud2014_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Na taupwaoliwone mane hitanogogoidi, na hiwalo, ‘Nigele howahowana ebe Yaubada ana velau ainai tamwauwi, wuwuna mane teina tomowa ana oiyemwalowoi maihana’. ");
INSERT INTO kud2014_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ainaena hibom hiloina na manenane ainaena ehebo tau'abi walata yana toputopu higimwalai yo ebe toputopunane taumanao adi magai. ");
INSERT INTO kud2014_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Eena toputopunane yehana himwauwi Wahina Toputopuna, na yehanane howola teina imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tenem ainaena tauwalo mahalava Yelemaiya yana waloyemidi imahalava, wuwuna mwalona Buki Ve'ahihi ainai yana walo hileleya'o neta: ‘Isileliwone ana maiha hiyogai ana bagibagili 30 siliba, na manedine hivaidi, ");
INSERT INTO kud2014_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ta ainaena tau'abi walata yana toputopu hiyemaihane dova yada Taubada ivenuwamwauwegau’. ");
INSERT INTO kud2014_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na Yeisu Pailato mehenai hivetowolo, ibom tauloina mwala'ina, na Pailatonane Yeisu ipanivilaei, iwalo, ‘Uwalo mahalava owa Yudeyaone yadi tauwasawasa awa?’ Na Yeisu iwalo, ‘Bada neta uwalo'o’. ");
INSERT INTO kud2014_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Eena taupwaoli mwala'idi yo babadao Yeisu hive'ewai Pailato mehenai, na Yeisu nigele teya yana yemaiha. ");
INSERT INTO kud2014_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Na Pailato iwalo, ‘Vedova walomahalava teina am ve'ewane vehabana ubenaledi'o?’ ");
INSERT INTO kud2014_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Na Yeisu nigele hinage iyayemaiha na bada ta'i inobu. Ainaena Pailato nuwanane ipwanopwano mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bolimai ehebo ehebo aidiyai Buidi'wa guyauna ainai Lomaone yadi mumuga neta vada abapaiyena ehebo towaho ilivahi na imahalava, ebe yaiya boda nuwanuwadi. ");
INSERT INTO kud2014_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Na hauga tenem ainai ehebo towaho vada abapaiyai imiyamiya yehana Balabasi, tomowa maudoidi hihanapuya'o ebeha iya tauyababa mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ainaena tomowa himiya ahaiyama Pailato ainai, na Pailato iwalo aulidi, iwalo, ‘Aiteya towaho nuwanuwamiu yalivahi? Balabasi bo Yeisu iya hiveyehaei Besinana towahona?’ ");
INSERT INTO kud2014_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Wuwuna Pailato ihanapuiya'o ebeha alomagigiliyena hihuhulaei habi oiyemwalowoina. ");
INSERT INTO kud2014_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Na hinage hauganane howola Pailato lauvetala ipaipaihowai na mwanena wasa ivetamalenama, na iwalo, ‘Havena teya hava hinage uloiloinaei towaho teina dumwadumwaluna vehabana, wuwuna wau ya'eno niviniviyeine ta abameheuhi mwala'ina aliguwai’. ");
INSERT INTO kud2014_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Na hesi Taupwaoliwo mwala'idi yo babadao tomowa hiwalo huluhuluidi ta ebe hi'awanoi Pailato ainai na Balabasi ilivahi aidiyai, na Yeisu hi'oiye mwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ainaena Pailato ipanivilauyowedi, iwalo, ‘Hitaubwau aidiyena yaiya nuwanuwamiu na vehabamiu yalivahi?’ Na hiwalo, ‘Balabasi’. ");
INSERT INTO kud2014_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Na Pailato iwalo aidiyai, ‘Vedova mata yaloinaeine Yeisu iya hiveyehaei Besinana towahona?’ Na maudoidi hiwalo, ‘Aiwa lagalagana ainai tatutuye patu’. ");
INSERT INTO kud2014_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Na Pailato iwalo, ‘Hava yede yana lauhapuli na ainaena ebeha aiwa lagalagana ainai tatutuye patu?’ Na hiwui mwalamwala'i, hiwalo, ‘Aiwa lagalagana ainai tatutuye patu’. ");
INSERT INTO kud2014_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ainaena Pailato ihanapuiya'o ebeha nigele yana wahiyala teya na boda hihamahamadudu, ana ita dova mata hivetuwuni na hi'aleha. Na bwahiyena nimanane iuwadi tomowa mehediyai, na iwalo, ‘Havena hinage hava teya yaloiloinaei towaho namwanamwana teina yana mwalowoi vehabana, na omiu ta'i ambom amloina’. ");
INSERT INTO kud2014_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Na boda maudoidi hiwalo, ‘Inamwanamwa. Abom aloinaei, na yana mwalowoi maihana ai yo natumaiyao aidiyai.’ ");
INSERT INTO kud2014_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Eena Pailato yadi walo bada ibenalena'o, ta Balabasi ilivahi, na hinage yana tau'alehao iloinaedi ta Yeisu balavaiyena hisapi na mulitai abo hitutuye patu aiwa lagalagana ainai. ");
INSERT INTO kud2014_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ainaena Pailato yana tau'alehao Yeisu hisasapine na hiluwuwei vada mwala'ina holanai, na tau'aleha maudoidi hitau'ahaidima Yeisu ainai. ");
INSERT INTO kud2014_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Na ana ale'o hiwuludi na ale'o hawahawawalina wasawasana ainaena hiveli'wa habi abitalawahiyeina. ");
INSERT INTO kud2014_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Na ana pwaopwaomi haihaili womawomalina ainaena hipaihowai ta vahunai himwamwauwine, na digona nimanai himwauwi, na hinage mehenai hitalupwagogo ta hi'abi'abitalawahiyei, hiwalo, ‘Yauwedo, owa Yudeya yadi tauwasawasa!’ ");
INSERT INTO kud2014_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Na hihowahowai yo hinage yana digona hivai ta vahunai higogohane, ");
INSERT INTO kud2014_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","eena yadi abitalawahi i'ovi, na ale'o wasawasa ainaena hiwulu, ta ibom ana ale'owena hiveli'wauyoi, na hilauvai habi tutuye patuna aiwa lagalagana ainai. ");
INSERT INTO kud2014_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Na Yeisu himahalavaei ta hilalaweine, na amwahai ehebo Sailini towahona yehana Saimoni hilobai, ta hiloinaei ta ebe Yeisu ana aiwa lagalagana i'avalai. ");
INSERT INTO kud2014_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Na Saimoni i'avalai ana higa himahalava dalava Goligota ainai. (Goligota ana bui neta Ulu'ulu Dalavana.) ");
INSERT INTO kud2014_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Na waini yo we'aha abe'abelena baidana hiyebweli ta himohei yo ebe havena muya ilaulautowoi mwala'ina. Na Yeisu waininane ilautowoi ta ita'wata'wataeine. ");
INSERT INTO kud2014_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Yeisu aiwa lagalagana ainai hitutuye patune, ta hivetowolo, na mulitai tau'alehaowowa Yeisu ana ale'owowa hivaidi na higuguyauwedine hibom aidiyai, na yadi aiyauya dova kati ana yepaipaihi, ta yaiya ebe imugai iya ana ale'o ivai. ");
INSERT INTO kud2014_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Na mulitai himiya ta hi'ita'ita avivini. ");
INSERT INTO kud2014_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Hinage ana aiwa lagalagana vahunai hilele: YEISU TEINA YUDEYA YADI TAUWASAWASA Neta yana mwalowoi wuwuna. ");
INSERT INTO kud2014_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Na hinage tau'aivavaliwowa hitau bwau hive'abahigogoidi, ehebo Yeisu nima tautuwanaena na ehebo nima eha'ehanaena. ");
INSERT INTO kud2014_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Na taulowolowouhi ulu'uludi hilaulau'wadiyedi na himaluwei, ");
INSERT INTO kud2014_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","hiwalo, ‘Atemuyamuyam! Uwalo ebeha howahowam vada tapwalolo ulo'e na ahubena tonuga holadiyai u'abiyoi. Hola ubom uhaguiyoigo na aiwa lagalaganaena u'aituluma, ebe owa Yaubada Natuna.’ ");
INSERT INTO kud2014_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Hinage dova Taupwaoliwo mwala'idi yo loina ana tauve'itao yo babadao Yeisu hi'abitalawahiyei, na hiwalo: ");
INSERT INTO kud2014_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","‘Vali tomowa ihaguhaguidi, na ibom nigele iyahauguyowei, ebe iya Isileli ana tauwasawasa, aiwa lagalaganaena i'aituluma ta tayemidiyei. ");
INSERT INTO kud2014_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Iya Yaubada Natuna na Yaubada iyemidiyei ta iwalo, “Yau Yaubada Natuna”. Hola teina ta'i Yaubada ihagui na ta'ita!’ ");
INSERT INTO kud2014_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tau'aivavaliwone Yeisu baidanao hive'abahidi hiya hinage Yeisu hihinali. ");
INSERT INTO kud2014_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mahana ala'alapwahiyai ana higa lavilaviyena dalava maudoina iguguyou. ");
INSERT INTO kud2014_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Lavilaviyai neta Yeisu alinana mwala'inaena iyoga na iwalo, ‘Eli, Eli, lama sabakitani?’ Na ana bui neta, ‘Yagu Yaubada, yagu Yaubada, hava vehabana ulalaugabaigaune?’ ");
INSERT INTO kud2014_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tupwana tomowa vahalinai hitowotowolo yana yoga hibenalei, na hiwalo, ‘Ambenalei towaho teina Elaitiya iyogayogaei’. ");
INSERT INTO kud2014_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Eena ehebo aidiyena isagena ta balou ivai yo waini abe'abelena ainaena iveda'wa na ehebo aipwala mehenai iwomalei, na iveleleihini Yeisu awanai, ta ebeha imala'u'ui. ");
INSERT INTO kud2014_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Na towahonane ana geluwo hiwalo, ‘Hola ulaumwau na taha'waha'wa, nuwana mata Elaitiya ilaoma na ihagui’. ");
INSERT INTO kud2014_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Na Yeisu alinana mwala'inaena iyogauyo, na yawahina i'o'ovine. ");
INSERT INTO kud2014_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Na ale'o mwala'ina vada tapwalolo mwala'ina ana biliwutuhi ilotapulihi ewaena, ta i'aitulu duyai, na mwani'ini'i isagena, na gaima mwala'idi hilotatomwahi. ");
INSERT INTO kud2014_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Yo hinage magai awadi hilotaho'e, na tauyemidiwo bagibagilidi mwalona himwamwalowoiwa hitowolouyo, ");
INSERT INTO kud2014_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yeisu yana towolouyo tuluhanai hiya hinage magai aidiyena himahalavama na Yelusalem ainai hiluwu, na tomowa bagibagilidi aidiyai himamahalavane. ");
INSERT INTO kud2014_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na tau'alehaone mayadi taumugai howola Yeisu hi'ita'ita avivini, na mwani'ini'i yo ginauli maudoidi himahalava hi'itadi, na himeheuhi mwala'ina, na hiwalo, ‘Moiha, towaho teina iya Yaubada Natuna’. ");
INSERT INTO kud2014_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tupwadi waiwaihiu hinage lovaena hi'itayama. Hiya mwalona Galiliyena Yeisu himulitaenama yo hinage ana hipaipaihowai. ");
INSERT INTO kud2014_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ehebo yehana Meli Magidalaena mayana waligeha, iya Yemesa yo Yosepa hinadi, na hinage Sebedi natunao bwau hinadi. ");
INSERT INTO kud2014_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Lavilaviyena ehebo Alimatiya towahona ilau Pailato ainai, iya wasawasa towahona na hinage Yeisu ana taumulita teya, yehana Yosepa. ");
INSERT INTO kud2014_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Na Pailato ainai Yeisu tauna i'awanoiyei, ta Pailato italam na ebe ivai. ");
INSERT INTO kud2014_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ainaena Yosepa Yeisu tauna hivai, na ale'o masemaselena ainaena hihuma. ");
INSERT INTO kud2014_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Yosepanane ana magai vauvauna ainai himwauwi na magainane hiyayatuine dova duluva gaima holanai, na gaima mwala'ina na po'upo'uwana ainaena magai awana hive'eno auhi, na mulitai Yosepa ilalaune. ");
INSERT INTO kud2014_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meli Magidalaena mayana waligeha magaine vahalinai himiyamiya na hi'ita'ita sipwaidi. ");
INSERT INTO kud2014_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Yeisu hive'abahi neta Yudeyaone yadi ahubena atububu ainai, na i'ahubena neta yadi Tapwalolo ana ahubena, na Taupwaoli mwala'idi yo Palisiwo baidadiyao hilau Pailato ainai, ");
INSERT INTO kud2014_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","na hiwalo, ‘Taubada, tau'oyamawa mwalona mayawahina imiyamiya yana walo anuwatuwu avivini, iwalo, “Ahubena tonugana ainai mwalowoiyena yatowolouyoma”. ");
INSERT INTO kud2014_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ainaena ebe howahowana uloina na magai ana tau'ita aviviniwo hi'ita avivini ili'ilimani ana higa ahubena tonuga, mata dova ta ana taumulitao hilaoma na Yeisu tauna hivai hilawei, na tomowa hi'oyamayedi ebeha Yeisu mwalowoiyena bada itowolouyo'o; yo ainaena oyama mulimulitana mata oyama mugamugaina imwala'i gabaei.’ ");
INSERT INTO kud2014_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Na Pailato iwalo aulidi, iwalo, ‘Yami tau'ita aviviniwo tau'alehao amlawedi, na magai hi'ita avivini ili'ilimani’. ");
INSERT INTO kud2014_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ainaena hilau aibadi hivai, na magai awana ana gudu gaimane hinage hi'aibadini ili'ilimani na ana tau'ita aviviniwo hivevetowolodine. ");
INSERT INTO kud2014_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tapwalolo dagelanai neta malatomtomwai hawahawaga vauvauna ana ahubena mugamugaina ainai Meli Magidalaena mayana waligeha hilaoma magayai habi taubo'eyei. ");
INSERT INTO kud2014_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Na mwani'ini'i mwala'ina isagena, neta Yaubada yana tausagenawasa ehebo galewaena i'aituluma, na gaima magai awanaena ive'i wahiyei na ainai imimiyane. ");
INSERT INTO kud2014_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tausagenawasanane ana ita pigabu dova, na ana ale'o hewahewana moiha. ");
INSERT INTO kud2014_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Na magai ana tau'ita aviviniwo tausagenawasanane hi'i'itane na himeheuhi mwala'ina na hibatubatutuli, na hibe'u bale'uwai dova taumwalomwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Na tausagenawasanane waiwaihiuwone iwalo aulidi, iwalo, ‘Havena ammehemeheuhi. Yahanapuiya'o omiu Yeisu iya bada hi'oiye mwalowoiya'o ambehabehaei. ");
INSERT INTO kud2014_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Iya nigele teinai, wuwuna mwalowoiyena bada itowolouyo'o, dova mwalona iwalo alimiyai. Amlaoma ta yana aba'eno ova'ova'a'avana am'ita. ");
INSERT INTO kud2014_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Na amlau mwayamwayayau ana taumulitao amwalo aidiyai ebeha Yeisu mwalowoiyena bada itowolouyo'o, na mata imugai Galili ainai, na omiu abo ammulitaei tenemai na am'ita. Teina yami wasa bada yawalo auligomiu'o.’ ");
INSERT INTO kud2014_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Na waiwaihiuwone mayadi meheuhi na hinage mayadi yaliyaya magai hilau vehulu na hisagena mwayamwayau ta ebe Yeisu ana taumulitaone aidiyai ginauli teina hiwalo mahalavaedi. ");
INSERT INTO kud2014_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Na Yeisu amwahai ilobaidi na ivelauwedi, na hilaoma aena hi'abitowoidi, na hiwalovetuvehaeyei. ");
INSERT INTO kud2014_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Eena Yeisu iwalo aulidi, iwalo, ‘Havena ammehemeheuhi, na hesi amlau augeluwo nuwadiyai ammwauwi na hilau Galili ainai, ta nemai hi'itagau’. ");
INSERT INTO kud2014_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Waiwaihiudiyaone howola amwahai hilaulau, na magai ana tau'ita aviviniwone tupwadi hilau dalava Yelusalem ainai, na hava dova imamahalavane hiwalo mahalavaedi Taupwaoli mwala'idi aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ainaena Taupwaoliwone yo babadao baidadiyao himiya ahaidima, na hiloina, ta mane mwala'ina tau'ita aviviniwone himohedi. ");
INSERT INTO kud2014_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ta ebe tomowa aidiyai hivetala'aubabadaei, na hiwalo, ‘Masigiliyena a'eno'eno na Yeisu ana taumulitaone hilaoma, na taunane hivavaine’. ");
INSERT INTO kud2014_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Yo hinage hiwalo aulidi, hiwalo, ‘Ebe Loma tauloina mwala'ina wasa teina ibenalei, mata a'oyamaei, na ebe havena alimiyai imanimanini’. ");
INSERT INTO kud2014_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ainaena yadi mane hivaidi, na Taupwaoliwo yo babadao yadi nuwatuwuwone himumulitaedine. Na yadi oyamawa idabalala Yudeyaone aidiyai, ta wau hinage dova hiwalowalo. ");
INSERT INTO kud2014_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ainaena Yeisu ana taumulitao hitau 11 hilau Galili, ta hihae oyawa Yeisu iwalo mahalavaeiwa ainai. ");
INSERT INTO kud2014_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Na Yeisu hi'i'itane, na ainai hitalu pwagogo, na tupwadi aidiyena howola mayadi nuwatuwu bwaubwau. ");
INSERT INTO kud2014_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yeisu ilaoma aidiyai na iwalo aulidi, iwalo, ‘Tamagu bada loina wahiwahiyalana maudoina imohegau'o galewai yo bale'uwai. ");
INSERT INTO kud2014_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Na amlau tupwa maudoidi aidiyai amguguya na ainaena tomowa himulitaegau, yo hinage am'abiye bapitaisowedi Tamagu yehanaena, yo Natuna yau yehaguwena, yo Alu'aluwa Ve'ahihi yehanaena. ");
INSERT INTO kud2014_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Na ve'ita maudoina bada yamohegomiu'o amve'itadi na hiya hinage himulitaedi. Na moiha, yau baidamiu tamiyamiya hauga maudoina wau yo ana higa bale'u yana aba'ovi ainai.’");
INSERT INTO kud2014_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Teina wasa namwanamwana Besinana Yeisu vehabana, iya Yaubada Natuna, wasana ana abavetuwuni. ");
INSERT INTO kud2014_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Mwalona tauwalo mahalava Aisaya Yeisu wasana vehabana ileleya'o, neta Yaubada yana walo iwalo mahalavaena'o, iwalo: ‘Teina yagu tausagenawasa yavetamale mugaiyei na vehabam yam amwaha isepa, ");
INSERT INTO kud2014_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","na balabala awawai alinana mwala'ina ainaena iwalo mahalava na iwalowalo, “Yada Bada yana amwaha amsepa yo am'abiye dumwalu”.’ ");
INSERT INTO kud2014_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yoni tau'abiye bapitaiso imahalava balabala awawai ta iguguya tomowa aidiyai, iwalo, ‘Yami mumuga yababadi aidiyena amnuwabui na ambapitaiso ta ebe Yaubada yami mumugaone inuwahamuidi’. ");
INSERT INTO kud2014_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Na tomowa maudoidi tupwa Yudeya ainaena yo hinage dalava Yelusalem ainaena hiho'eyama Yoni yana guguya habi benaleina, ta yadi mumuga yababadi hiwalo mahalavaedi ta i'abiye bapitaisowedi bwahi Yolidani ainai. ");
INSERT INTO kud2014_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yoni ana ale'one lagulagu kameli wiyawiyana na ana tulituline kameli 'wapina, na anane bilolo yo mwagagau bada. ");
INSERT INTO kud2014_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Na Yoni iguguya ta iwalo, ‘Iya dagelaguwena ilalaoma imwala'i gabaegau, na nigele howahowana aenai yapwagogo na aena ana huma yalivahi. ");
INSERT INTO kud2014_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yau we'ahaena teina ya'abiye bapitaisogomiu, na iya Alu'aluwa Ve'ahihiyena howola abo i'abiye bapitaisogomiu.’ ");
INSERT INTO kud2014_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Hauga tenem ainai Yeisu dalava Nasaleti ilaugabaei, neta tupwa Galili ainaena, ta ilalaomane bwahi Yolidani ainai, ta Yoni Yeisu i'abiye bapitaiso. ");
INSERT INTO kud2014_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Na Yeisu bada bwahiyena igayogayo taohanima na i'itamayahi ta galewa i'ita ilotaho'e na Alu'aluwa Ve'ahihi ana ita dova gabubu i'aituluma ainai. ");
INSERT INTO kud2014_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na hinage ehebo alina galewaena iwalo, ‘Owa natugu moiha vehabam yayaliyaya mwala'ina’. ");
INSERT INTO kud2014_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ainaena Yaubada Alu'aluwana Yeisu ivetamalei ta ilau balabala awawai, ");
INSERT INTO kud2014_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ta ahubena 40 tenem ainai imiyamiya, na hauganane aidiyai Tomodulele itowotowoi, nuwanuwana Yeisu i'abiye be'u, na tupwanane ainai lagulagu manimaninidi hinage himiyamiya, na tausagenawasao Yeisu hi'ita'ita avivini. ");
INSERT INTO kud2014_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Hauganane ainai Wasawasa Helodi iloina ta Yoni vada paipaiyai himwauluwei. Himwau i'ovi na mulitai Yeisu imahalava Galili ta wasa namwanamwana Yaubada ainaena iguguyaei, ");
INSERT INTO kud2014_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","iwalo, ‘Hauga bada imahalavama'o ta Yaubada ebe ivetauloina alidai. Ainaena yami paihowa yababadi aidiyena amnuwabui na wasa namwanamwana amyemidiyei.’ ");
INSERT INTO kud2014_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ehebo hauga Yeisu Galili le'awanai ivasavasane ta tauyamao hitau bwau matahina i'itadi Galili ni'uwai yadi vinaya hiyahuyahuwei, hiya Saimoni yo Andulu. ");
INSERT INTO kud2014_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ta Yeisu iyogaedima iwalo, ‘Amulitaegau na tomowa am'onadi’. ");
INSERT INTO kud2014_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Eeta yadi vinayawa hilaugabaei na Yeisu himumulitaeine. ");
INSERT INTO kud2014_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ivasanelau tupwana ta Yemesa yo Yoni hiya Sebedi natunao i'itadi, yadi vinaya hi'abi'abinonovaidi, ");
INSERT INTO kud2014_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ta iyogaedima eena tamadiwa mayana taupaihowao hilaugabaidi wagai na Yeisu himumulitaeine. ");
INSERT INTO kud2014_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Mulitai hilaoma dalava yehana Kapeneum ainai, ta Tapwalolowai Yeisu vada tapwalolo ainai iluwu ta ive'ita. ");
INSERT INTO kud2014_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Na tomowa maudoidi nuwadi ipwanopwano yana ve'ita vehabana, ta hiwalo, ‘Ve'ita teina moihana na wahiwahiyalana, ita hesi yada loina ana tauve'itao yadi ve'ita itapiya.’ ");
INSERT INTO kud2014_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na vada tapwalolone ainai ehebo tomowa imiyamiya na towahonane holanai alu'aluwa yababana imiyamiya, eeta towahonane Yeisu ainai ilohagali, ");
INSERT INTO kud2014_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","iwalo, ‘Yeisu, owa towaho Nasaleti hava wuwuna ulalaomane alimaiyai? Nuwanuwam ta ebeha umutugai awa? Na owa hesi bada yahanapuigo'o owa ta'i Yaubada Natuna.’ ");
INSERT INTO kud2014_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ta Yeisu iloinaei iwalo, ‘Ulaumwau, na towahone neta ainaena umahalava’. ");
INSERT INTO kud2014_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Eeta alu'aluwa yababanawa towahone i'abiye tai ta ibatubatutuli na ilohagali mwala'ina, na mulitai towahowa ainaena imamahalavane. ");
INSERT INTO kud2014_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Na tomowa maudoidi hinuwapwanopwano, na hibom hipanivilauyowedi hiwalo, ‘Ve'ita vauvauna teina vedova? Teina towahone howahowana alu'aluwa yababadi iloinaedi na hi'awa abiyei.’ ");
INSERT INTO kud2014_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Hauganane ainai Yeisu wasana hiyewasaei Galili tupwanao maudoidi aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","I'ovi na Yeisu vada tapwalolo ainaena imahalava, ta Yemesa na Yoni baidanao hilalaune Saimoni yo Andulu yadi vadai. ");
INSERT INTO kud2014_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Na Saimoni lawana ilovala, tauna hi'ala'alawowoli, eeta Yeisu hiwalo auli taulovalane vehabana. ");
INSERT INTO kud2014_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ta Yeisu iluwu ainai, nimanai i'abi ta i'abiye towolo, eena ana lovala itatalune. Na waihiunane imahalava ta adi i'a'atububuine. ");
INSERT INTO kud2014_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Lavilaviyena mahana bada ihuhugu ta tomowaone yadi taulovalao yo hiya alu'aluwa yababadi aidiyena hilolovalane maudoidi hilauvaidima Yeisu ainai, ");
INSERT INTO kud2014_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","yo hinage dalava ana taumiyao maudoidi hilaugogoima ta vadanane mehenaena hitowotowolo. ");
INSERT INTO kud2014_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Na taulovalao bahudi yo hiya alu'aluwa yababadi i'abiye yauyauledi maudoidi Yeisu i'abiye namwanamwadi, na ebe alu'aluwa yababadi iheusilidi himahalava mata i'auhidi na havena hiwalowalo mahalavaei, wuwuna iya bada hihanapuiya'o. ");
INSERT INTO kud2014_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Malatomtom iu'iuna Yeisu itowolo ta vadaena imahalava ta ibom ilau balabala awawai, ta i'awa'awanoi Yaubada ainai. ");
INSERT INTO kud2014_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Na Saimoni ma'ana geluwo hinage himahalava ta Yeisu hibehabehaei, ");
INSERT INTO kud2014_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ta hilobai na ainai hiwalo, ‘Bodaowa nuwanuwadi owa’. ");
INSERT INTO kud2014_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ta Yeisu iwalo, ‘Talau tupwana hinage dalava aidiyai yo yaguguya. Teina vehabana yalalaomane.’ ");
INSERT INTO kud2014_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Eeta Galili tupwana maudoina hita'i'iliyei ta yadi vada tapwalolo aidiyai iguguya na hinage alu'aluwa yababadi tomowao aidiyena iheusili mahalavaedi. ");
INSERT INTO kud2014_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Taulepelo ehebo Yeisu ainai ilaoma, ta ipwagogo na i'awanoi iwalo, ‘Ebe yam nuwatuwu dova howahowana yo u'abiye namwanamwagau’. ");
INSERT INTO kud2014_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Eeta Yeisu i'atemuyamuyaei, ta nimanaena towahonane 'wapinai i'abi ta iwalo, ‘Ehe ausala, unamwanamwa!’ ");
INSERT INTO kud2014_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ta towahonane ana lepelo isawali mwayamwayau, ta inamwanamwauyone. ");
INSERT INTO kud2014_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Na Yeisu towahonane walo yaiyaina imohei, ");
INSERT INTO kud2014_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","iwalo, ‘Ee, ulau, na havena yaiya ainai uwalowalo mahalavaegau, na hesi udumwalu ulau taupwaoli ainai yo i'itago, ta ebe yam velau umwauwi Yaubada ainai, hava dova ada loina Mosese ainaena, eeta tomowa hihanapuigo ebeha bada uvauvauyo'o’. ");
INSERT INTO kud2014_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ta taulepelowa nigele Yeisu yana loina iyamulitaei, na hesi tomowa bagibagilidi aidiyai iwalo mahamahalava, na boda mwala'ina hilaoma. Teina vehabana Yeisu nigele howahowana imahalava dalavanane ainai, eeta ilau balabala awawai ta nemai imiyamiya, na tomowa dalava bagibagilidi aidiyena hilalaune ainai. ");
INSERT INTO kud2014_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ahubena tupwadi hi'ovi'o na Yeisu iwuwuyone Kapaneum ainai, na wasana hibenalena'o ebeha Yeisu bada iwuyoma'o. ");
INSERT INTO kud2014_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ta boda mwala'ina vada holanai yo hinage maseleyai himiya ahaiyama, ta Yeisu iguguya aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Na towaho peupeuna ehebo hilawenama na ana tau'avalaone hitau vehopali hipageiyama, ");
INSERT INTO kud2014_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","na hitowoi yo ebeha peupeunane iluwuwei Yeisu ainai na nigele howahowadi, wuwuna boda imwala'i alili, eeta hi'avalaihini vada ewanai na ana atovi hivai vehuludi ta ainaena peupeunawa ma'aba'enona hivehoni aituluwei Yeisu mehenai himwamwauwine. ");
INSERT INTO kud2014_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Himwauwi na Yeisu bada towatowahowone yadi yemidi ihanapuiya'o ta peupeunawa iwalo ainai, ‘Natugu, yam mumuga yababadi adi nuwahamu bada ulobaiya'o’. ");
INSERT INTO kud2014_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Na tupwadi loina ana tauve'itao Yeisu vahalinai himiyamiya yana walo hibenalei ta hibom atediyai hinuwanuwatuwu, ");
INSERT INTO kud2014_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","‘Yeisu teina vedova ta Yaubada ainai iwalo hinahinali? Wuwuna nigele teya howahowana yo tomowa yadi mumuga yababadi inuwahamuidi, na hesi Yaubada ibom howahowana.’ ");
INSERT INTO kud2014_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Na hesi Yeisu holanai bada yadi nuwatuwu ihanapuiya'o, ta iwalo, ‘Hava vehabana neta dova amnuwanuwatuwune? ");
INSERT INTO kud2014_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mata vedova teina peupeunane vehabana yawalone, “Yam mumuga yababadi bada yanuwahamuidi'o”, bo yawalo, “Utowolo na yam aba'eno u'avalai ta ulau?” ");
INSERT INTO kud2014_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Na mata amhanapui ebeha yau Tomowa Moihagu mayagu loina bale'uwai na tomowa yadi mumuga yababadi yanuwanuwahamuidi.’ ");
INSERT INTO kud2014_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Eeta peupeunane ainai iwalo, ‘Yau teina yawalowalone, utowolo, yam aba'eno u'avalai ta ulau yam dalavai’. ");
INSERT INTO kud2014_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Eeta itowolo yo yana aba'eno i'avalai ta bodaowa mehediyena imamahalavane. Tenem ainai boda maudoidi nuwadi ipwanopwano na Yaubada hino'owei, hiwalo, ‘Paihowa teina abanuwapwanopwano. Wau mai ehebo ta'i'itane.’ ");
INSERT INTO kud2014_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Mulitai Yeisu imahalavauyo Galili le'awai, ta hinage boda hitau'ahaiyama ta iveve'itane aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Na yana ve'ita ive'ovi ta ilaulau na ehebo takesi ana tauvai i'i'itane takesi abapaihowa vadana ainai imiyamiya. Towahonane yehana Livai, na tamanane Alipiyosi. Ta Yeisu iwalo, ‘Livai, umulitaegau!’ Eeta Livaiwa itowolo na Yeisu imumulitaeine. ");
INSERT INTO kud2014_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Eena Yeisu mayana taumulitao hilaoma Livai yana vadai habi ai, na boda Yeisu himulitaei, hiya tauyababa dova takesi ana tauvaiwo, yo tupwadi tauyababa hinage, na maudoidi Yeisu mayana taumulitao baidadiyao himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Haugana himiyamiya Palisi yadi loina adi tauve'itao hi'i'itane, ta Yeisu ana taumulitaone aidiyai hipanivila, hiwalo, ‘Hava vehabana yami tauve'itane takesi adi tauvai yo hinage yabayababadi tupwadi baidanao hi'ai'ai toyawane?’ ");
INSERT INTO kud2014_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Na Yeisu walone teina ibenaledi ta iwawalone, ‘Hiya ausaladi taulaumulamula nigele nuwadi, na taulovala hesi nuwanuwadi taulaumulamula. Yau yalaoma nigele ebeha taunamwanamwa a'ava vehabadi, na hesi tauyababao yahaguidi.’ ");
INSERT INTO kud2014_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ta Yoni tau'abiye bapitaiso ana taumulitao yo hinage Palisiwo ai'ai ainaena hive'ahihi yadi tapwalolo vehabana, eeta tupwadi tomowa Yeisu ainai hilaoma na hiwalo, ‘Yoni ana taumulitao yo hinage Palisiwo adi taumulitao hive'ahihi ai'ai aidiyena, na vedova ta am taumulitaone nigele hiyave'ahihine?’ ");
INSERT INTO kud2014_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Eeta Yeisu walo vegevegediyena aidiyai iwalo, ‘Vedova, ilowoinanei yo tawahola ana tauvinunuwo hive'ahihi ebe tautawahola towahona baidadi himiyamiya? Nigele ta'i! Wuwuna iya baidadi ta maudoidi hiyaliyaliyaya. ");
INSERT INTO kud2014_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Na hesi amnuwatuwu avivini ebeha hauga ilalaoma yo tautawahola ana alehao hivaivehulu mata hinuwayababa yo hive'ahihi ai'ai aidiyena.’ ");
INSERT INTO kud2014_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ta ehebo hinage walo vegevegedi imohedi, iwalo, ‘Nigele howahowana yo ale'o vauvauna tupwatupwana luwuluwu miyamiyana ta'aibadi'auhi mata dova ta itavapulipulihi mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Na hinage nigele howahowana waini vauvauna tahiwai 'wapi abahiwa miyamiyana aidiyai, mata dova ilotapulihi yo waini na abahiwa tayepaipaihedi, na hesi tahiwai abahiwa vauvaudi aidiyai.’ ");
INSERT INTO kud2014_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tapwalolowai Yeisu mayana taumulitao tanovi holanaena hilaulau ta ana taumulitaone witi patuna hipupudi ta hi'ai'aidi. ");
INSERT INTO kud2014_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Na Palisiwone hi'i'itadine ta Yeisu ainai hiwalo, ‘Taubada, vedova ta am taumulitao Tapwalolo ana loina hiho'eho'ene?’ ");
INSERT INTO kud2014_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Na Yeisu aidiyai iwalo, ‘Buki Ve'ahihi ainai hilelelene Deivida vehabana na ebe amvahili amhanapui ebeha iya ma'ana geluwo hivahali mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ta Yaubada yana vadai iluwu ta beledi ve'ahihi ivai ta hi'a'aine. Beledinane ana loina ebeha taupwaoli a'ava adi talam ta hi'ai. Na bada ta'i hivahali alili, eeta taupwaoli mwala'ina yehana Abayada italamwei ta hi'a'aine.’ ");
INSERT INTO kud2014_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yeisu hinage iwawalo aulidine, iwalo, ‘Yaubada Tapwalolo imohegita yada namwanamwa vehabana, nigele ebeha ita ipaihowagita Tapwalolo vehabana. ");
INSERT INTO kud2014_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Eeta yau Tomowa Moihagu, Tapwalolo ana tauloina.’ ");
INSERT INTO kud2014_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mulitai Yeisu iwuyoma vada tapwalolo ainai ta nemai ehebo towaho nimana giyogiyona ilolobaine. ");
INSERT INTO kud2014_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Na Palisiwone Yeisu hi'ita'ita sipwai na ebe towahonane i'abiye namwanamwa Tapwalolowai mata hive'ewai. ");
INSERT INTO kud2014_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ta Yeisu towahonane ainai iwalo, ‘Utowolo ta uhaema’. Na towahonane itowolo ta ihahaene. ");
INSERT INTO kud2014_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Na Yeisu babadaone iwalo aulidine iwalo, ‘Teina yagu panivila alimiyai, aiteya paihowa namwanamwana alidai? Tapwalolo ainai tomowa tahaguidi bo ta'abiye yababadi? Tahaguidi bo tayemwalowoidi?’ Ta yana walone nigele hiyayemaiha. ");
INSERT INTO kud2014_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ta Yeisu mayana modo'ini ivinunu gwaigwaipile aidiyai, yo mayana nuwayababa yadi ulu'uluyaiyai vehabana, ta towahonane ainai iwalo, ‘Nimam utuwu’, ta towahone nimana ituwu ta inanamwanamwane. ");
INSERT INTO kud2014_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ainaena Palisiwone himahalava ta Helodi yana bodao baidadiyao hi'ulewahi vedova na ebe Yeisu hi'oiye mwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ainaena Yeisu itauvehuludi ta mayana taumulitao hidobi Galili le'awanai, na boda mwala'ina himumulitaeine. ");
INSERT INTO kud2014_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Bodawone teina Yeisu wasanane hibenalei ta Galiliyena yo Yudeyaena yo Yelusalemaena yo Idumeya tupwanaena yo Yolidani hali tupwanaena na tupwadi dalavaone Taya yo Saidoni vahalidiyena hitatau'ahaiyamane. ");
INSERT INTO kud2014_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Ta Yeisu taulovalao i'abiye namwanamwadi, na hesi taulovalao bagibagilidi hinoinoini habi abisawahina, eeta Yeisu ana taumulitaone aidiyai iwalo, ‘Waga vehabagu amvaiyama ta ebe tomowaone besiwa hinoinoinigaune yagelu wagai’. ");
INSERT INTO kud2014_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na tomowaone aidiyai alu'aluwa yababadi hiluwu'o, ebe Yeisu hi'ita, hibe'u pwagogo mehenai na hiwuiwui, hiwalo, ‘Owa Yaubada Natuna’. ");
INSERT INTO kud2014_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Na Yeisu ilaugagayowedi, iwalo, ‘Havena amwalowalo mahalava ebeha yau Yaubada Natuna’. ");
INSERT INTO kud2014_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Mulitai malapo'ewana ainai ihae ta ana taumulitaone ivesinuwaidi iyogaedi ta hihahaene ainai. ");
INSERT INTO kud2014_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ta aidiyai iwalo, ‘Omiu am tau12 yavesinuwaigomiu na baidaguwao tamiyamiya, yo mulitai abo yavetamalegomiu tupwana dalava aidiyai, amguguya, ");
INSERT INTO kud2014_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na wahiyalaena alu'aluwa yababadi tomowa aidiyena amheusili mahalavaedi’. ");
INSERT INTO kud2014_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Na yehadiyao teina: Saimoni (iya hinage hiyogayogaei Pita); ");
INSERT INTO kud2014_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","na hinage Yemesa matahina Yoni, hiya Sebedi natunao, na Yeisu iyogaedi yehadi Tutu natunao; ");
INSERT INTO kud2014_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","na hinage Andulu yo Pilipi yo Batolomiu yo Madiu yo Tomasi yo vali Yemesa, iya Alipiyosi natuna, yo Tadiusa yo vali Saimoni, iya tau'awa pa'ipa'i'i mwala'ina Isileli yana miyawahi Loma ainaena vehabana, ");
INSERT INTO kud2014_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na hinage Yudasa Isakaliyota, iya howola mata Yeisu ihuhulaei. ");
INSERT INTO kud2014_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mulitai Yeisu iwuyo yana dalavai, na boda imwala'i alili hitau'ahaiyama, ta nigele howahowana Yeisu mayana taumulitao hi'aiyawasi yo hi'ai. ");
INSERT INTO kud2014_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Na yana huhuwone hibenalena'o ebeha Yeisu nigele iya'aiyawasi towoi, ta hilau habi lauvaiyama, wuwuna hinuwatuwui hiwalo, ‘Bada iyauyaule'o’. ");
INSERT INTO kud2014_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Na loina ana tauve'itao tupwadi bada Yelusalemaena hidobima ta Yeisu yana paihowa mwala'ina hi'itaya'o ta hiwalo, ‘Towaho teina yana paihowa ana ita dova alawaiwone yadi taubada, neta Tomodulele yana wahiyalaena alu'aluwa yababadi iheuheusilidi’. ");
INSERT INTO kud2014_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Na Yeisu tomowaone iyogaedima ta aba'ita aidiyena ive'ita aidiyai, ipanivila, iwalo, ‘Nigele howahowana Tomodulele ebeha iya ana bodao aidiyai ive'aleha’. ");
INSERT INTO kud2014_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Na hinage iwalo, ‘Ebe teya abaloina ainai tomowaone hiwahei na hibom hilo'alehauyowedi mata abaloinane itapiya yo ibe'u. ");
INSERT INTO kud2014_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Hinage dova ebe huhu ehebo na hiwahei yo hibom hilo'alehauyowedi mata hitapiya yo yadi miya iyababa. ");
INSERT INTO kud2014_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tomodulele hinage dova ebe mayana bodao hibom hilo'alehauyowedi mata yana abaloinane ibe'u yo i'ovi ta'i. ");
INSERT INTO kud2014_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","‘Aba'ita hinage towaho wahiwahiyalana, neta Tomodulele yana vada, nigele howahowana ehebo yaiya iluwu tauwahiyalane yana vadai yo yana tobwatobwa i'aluhewaidi. Na hesi ebe ehebo towaho gulawa ainaena tauwahiyalane nimanane yo aenane ipai mugaiyedi na mulitai howahowana iluwu yana vadai yo yana tobwatobwa i'aluhewaidi. ");
INSERT INTO kud2014_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","‘Eeta teina yawalo ili'ilimani alimiyai ebeha tomowa yadi pwanoliwo yo yadi walo yababana maudoina Yaubada mata inuwahamuidi, ");
INSERT INTO kud2014_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","na hesi ebe yaiya Alu'aluwa Ve'ahihi i'awa yababaei, Yaubada nigele howahowana inuwahamui, na mumuga yababanane ainai mata imiya vateyai’. ");
INSERT INTO kud2014_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Teina Yeisu yana walo wuwuna tomowa hiwalowalo ebeha ana tauhaguwede neta Tomodulele. ");
INSERT INTO kud2014_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yeisu hinana na tahinao hilaoma ta maseleyai hitowolo, na walo a'ava hivetamalei vadai ta ebeha Yeisu imahalavama aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na tomowaone Yeisu vahalinai himimiyane hiwalo auli, ‘Taubada, hinam yo tahimwao maseleyai na ebeha nuwanuwadi owa’. ");
INSERT INTO kud2014_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Na Yeisu aidiyai iwalo, ‘Yaiyadiwo yede hiya tahiguwao yo hinagune?’ ");
INSERT INTO kud2014_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Na hiya vahalinai himimiyane ivinuvinunuidi na iwalo, ‘Teina hiya hinagu yo tahiguwao. ");
INSERT INTO kud2014_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ebe yaiyadiwo Yaubada yana nuwatuwu himulimulitaei hiya tahiguwao yo nuhuguwao yo hinage hinaguwao.’ ");
INSERT INTO kud2014_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Mulitai hinage Yeisu iwuyoma Galili le'awanai habi guguya na boda mwala'ina hitau'ahaiyama ainai, eeta ehebo waga i'ava'avai ainai igelu ta imimiyane na bodaone le'awai hitowotowolo. ");
INSERT INTO kud2014_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Na Yeisu walovegevegedi bahudi aidiyena ive'ita tomowa aidiyai na iwalo, ");
INSERT INTO kud2014_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","‘Ambenalei! Taupaihowa ehebo yana tanoviyai ilau ta holanai patu ivevehuludine, ");
INSERT INTO kud2014_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","na tupwana patuwone amwahai hibe'u, eeta lowolowo hi'itadi ta hi'aitulu hi'a'aidine. ");
INSERT INTO kud2014_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tupwadi hibe'u toputopu malagaigaimana ainai ta hi'ini mwayamwayau, wuwuna toputopu habuluna bada, ");
INSERT INTO kud2014_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","na mahana i'alahidi ta hiwelai wuwuna patune lamlamdine nigele toputopune gwagwamanane hiyalobai. ");
INSERT INTO kud2014_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Na tupwana haihaili womawomalidi aidiyai hibe'u ta hi'ini mwalomwalowoi, ta nigele howahowana yo hi'aino, wuwuna haihaili womawomalidi hiwahiyala ta hipaiye mwalowoidine. ");
INSERT INTO kud2014_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Eena tupwadi patu toputopu namwanamwana ainai hibebe'une, na hi'ini na himwala'i ta hi'aino, eeta tupwadi ainodi hibagibagili alili, na tupwadi ahipuwai, na tupwadi nigele hiya'aino ili'ilimani.’ ");
INSERT INTO kud2014_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ta Yeisu aidiyai iwalo, ‘Ebe matalinamiu walo teina ambenalei’. ");
INSERT INTO kud2014_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mulitai bodaone hilo'uhagwali na Yeisu ibom imiyamiya, ta tupwadi tomowa na ana taumulitaowowa hitau tuwelo wone baidadiyao hilaoma ta Yeisu ainai hipanivila, hiwalo, ‘Yam walovegevegediwone hava adi masele?’ ");
INSERT INTO kud2014_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Na Yeisu iwalo, ‘Omiu bada Yaubada hanapu imohegomiu'o yo yana loina holadi amhanahanapuidi, na hesi tomowa bagibagilidi nigele. ");
INSERT INTO kud2014_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Hiya walovegevegedi hibenalei na ana nuwamasele nigele hiyahanapui, na hinage ana hanapu hibehabeha na nigele howahowadi hilobai. Eeta hinage nigele howahowana yadi pwanoliwone aidiyena hinuwabui na Yaubada inuwahamuidi.’ ");
INSERT INTO kud2014_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ta Yeisu aidiyai iwalo, ‘Vedova yagu walovegevegedi teina nigele amyanuwamasele awa? Yede vedova mata tupwana walovegevegedi teina dova amnuwamaseleine? ");
INSERT INTO kud2014_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","‘Taupaihowane Yaubada yana walo ivehulu budebudeyanaei. ");
INSERT INTO kud2014_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tupwadi patuwa hibe'u amwahai dova tomowa hiya Yaubada yana walo hibenalei na Tomodulele ilaoma aidiyena ivaivehuludi. ");
INSERT INTO kud2014_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","‘Hinage dova patuwone malagaigaima ainai hibe'ube'u, ebeha tomowadine Yaubada yana walo hibenalei mayadi yaliyaya hitatalamne, ");
INSERT INTO kud2014_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","na nigele lamdine iyayaiyai yo iya'abidobi, eeta hauga habuluna ainai himiyamiya, yo ebe aiteya hauga ainai Yaubada yana walo ana yemidi vehabana vitai nuwana alehao hilobai mata hibe'u mwayamwayau. ");
INSERT INTO kud2014_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","‘Na patuwa haihaili womawomalidi aidiyai hibebe'uwa dova tomowaowa hiya Yaubada yana walo hibenalei, ");
INSERT INTO kud2014_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","na wasawasa yo bale'u yana paulao adi nuwatuwu aidiyena Yaubada yana walo hinuwapwanopwanowei eeta nigele howahowana hi'aino. ");
INSERT INTO kud2014_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","‘Na patuwa toputopu namwanamwana ainai hibebe'uwa dova tomowaowa hiya mayadi atetalam Yaubada yana walo hibenalei, ta ainodi namwanamwadi. Tupwadi ainodi bagibagili alilidi, na tupwadi ahipuwai na tupwadi nigele hiya'aino ili'ilimani.’ ");
INSERT INTO kud2014_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yeisu hinage alidiyai iwalo, ‘Havena lampa ala'alahina walata yo halabi ainaena ta'oi'oihamui, na hesi maseleyai tamwauwi ta imasele. ");
INSERT INTO kud2014_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ta ebe ginauliwo dawadawanidi abo mata maselenane i'abiye mahalavaedi yo ta'itadi. ");
INSERT INTO kud2014_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ebe matalinamiu walo teina ambenalei.’ ");
INSERT INTO kud2014_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Na hinage, ‘Amnuwatuwu avivini yo walo ambenali ili'ilimanidi, wuwuna ebe omiu hava am'aiyauya mata dova ana maiha amvai na hesi ma'ana yemutulai. ");
INSERT INTO kud2014_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Wuwuna ebe yaiya ainai Yaubada yana tobwatobwa, mata tobwatobwanane ilauhepoiyei. Na ebe yaiya ainai nigele Yaubada yana tobwatobwa, mata hava namwanamwana ainai imiyamiya Yaubada ainaena ivaivehuludi.’ ");
INSERT INTO kud2014_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yeisu hinage iwalo, ‘Yaubada yana paihowa nuwana yana loina tomowa aidiyai dova hinage venuvenu towaho yana tanoviyai i'umaidi, ");
INSERT INTO kud2014_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","na towahonane boniyai ehebo ehebo i'eno na i'ahubena itowolo, na venuvenuwone hi'ini'ini yo hihaihaili, na hesi yadi ini wuwuna nigele iyahanapui. ");
INSERT INTO kud2014_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Wuwuna toputopu iya iloina yadi ini yo yadi aino vehabana, ");
INSERT INTO kud2014_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","na mulitai abo ainona ihuna tau'abi tanoviwa ivetuwuni yo ilau'eli.’ ");
INSERT INTO kud2014_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yeisu hinage iwalo aulidi iwalo, ‘Vedova Yaubada yana Abaloina walovegevegediyena ya'abiye masele alimiyai? ");
INSERT INTO kud2014_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nuwana teina dova ehebo aiwa patuna ainai yawalo yepatu neta magimagi vehabana. Magimagi patuna habuluna, ");
INSERT INTO kud2014_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","na ebe ta'umai na i'ini yo ive'aiwa mwala'i, mata lagalaganao mwala'idi imwauwidi, ta lagalaganao logulogudiyai lowolowo yadi abatowa.’ ");
INSERT INTO kud2014_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yeisu yana guguya aidiyai walovegevegedi bagibagilidi aidiyena ive'ive'ita, yo ebe tomowa aidiyena howahowana hihanapui. ");
INSERT INTO kud2014_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Iya hauga bagibagilidi walovegevegediyena iguguya bodao aidiyai, na yana hevahevaliwone hibom aidiyai walovegevegediwone ilivalivahidi. ");
INSERT INTO kud2014_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lavilaviyai Yeisu yana guguya wagaena ive'ovi ta ana taumulitaone aidiyai iwalo, ‘Amgeluma yo ta geyo'awa vali tupwai’. ");
INSERT INTO kud2014_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Higelu na boda le'awai hilaugabaidi, na tupwana waga hinage baidadiyao, ");
INSERT INTO kud2014_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","na 'wavilivili mwala'ina itowama, ta bagodu wagai ihiwado'odo'owei ta muhamuhana hihanene. ");
INSERT INTO kud2014_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Na Yeisu waga aiyiuwai ana uludai bada imwauwiya'o ta i'eno i'iwahi'o, na ana taumulitaone hivavanoine ta hiwalo, ‘Taubada, utowolo ta uhaguigita mata dova ta tamwalowoi’. ");
INSERT INTO kud2014_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Eeta Yeisu itowolo ta yaumai yo bagodu iloinaedi, iwalo, ‘Badagi ulaumwau yo udaumwali!’ Eeta yaumai itowalaumwau, na ni'u maudoina idadaumwaline. ");
INSERT INTO kud2014_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Na ana taumulitaone aidiyai iwalo, ‘Hava vehabana ammemeheuhine? Vedova nigele amyayemidiyegau?’ ");
INSERT INTO kud2014_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Na nuwadi hipwanopwano na himeheuhi, ta hibom aidiyai hiwalo, ‘Towaho havahava teina ta yaumai yo bagodu alinana hibenalei yo himumulitaeine?’ ");
INSERT INTO kud2014_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Haugana higeyo'awa ta hiluwu Gelasinewone yadi gadowai, ");
INSERT INTO kud2014_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ta wagaena Yeisu i'aitulu magumaguwai, na towaho ehebo ilolobaine alu'aluwa yababana ainai imiyamiya, yana abamiya guda ainaena imahalava, na gudanane tomowa adi magai. ");
INSERT INTO kud2014_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Na towaho teina mwalona tomowa hitowoi ebeha hipai gulawa pwawapwawati ainaena, na nigele howahowadi, wuwuna hauga maudoina gulawaone iwutuwutuhidi nimanaena yo aenaena, na nigele yaiya howahowana yo i'abi avivini, na ilauvehuludi ta ilau nu'ulai, ");
INSERT INTO kud2014_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","na ana boniyai yo ana ahubena magaiyai yo oya aidiyai ilohalohagali, na hauga maudoina gaima ainaena italatalauyoi. ");
INSERT INTO kud2014_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Na towahonane Yeisu bada amwaha daodaowena i'itaya'o, eeta isagena ta Yeisu mehenai ipwagogo, ");
INSERT INTO kud2014_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","na ilohagali iwalo, ‘Yeisu yo, owa Yaubada Tauwahiyala Natuna, hava utowotowoi ta mata upaihowai aliguwai? Badagi! Yaubada yehanaena ya'awanoi alimwai ta havena u'abi'abiye muyagau.’ ");
INSERT INTO kud2014_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Walo teina i'a'ataine wuwuna Yeisu bada ainai iwalo'o, ‘Alu'aluwa yababam, towaho teina ainaena umahalava’. ");
INSERT INTO kud2014_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Na Yeisu hinage ipanivila alu'aluwane ainai iwalo, ‘Vedova yehamne?’ Ta iya iwalo, ‘Yehaguwede Bagibagilimai, wuwuna amaboda towaho teina holanai amiyamiya’. ");
INSERT INTO kud2014_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Na i'awa'awanoi wahiwahiyala Yeisu ainai iwalo, ebeha havena abamiyane tenem ainaena ivetavetamale mahalavaedi. ");
INSERT INTO kud2014_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na tupwanane ainai maheya bagibagilidi hidumudumuli oyai. ");
INSERT INTO kud2014_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ta alu'aluwa yababadine hi'awanoi Yeisu ainai hiwalo, ‘Uvetamalegai yo aluwu maheya tenem holadiyai’. ");
INSERT INTO kud2014_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Na Yeisu italamwedi ta alu'aluwaowa towahone ainaena himahalava ta maheyaowowa aidiyai hiluluwune, eeta maheyaowowa hiyauyaule ta maudoidi hisagena budebudeyana ta tapatapa ainai higavai ta ni'uwai hihahanene. Na maheyaowa adi bagibagili dova 2000. ");
INSERT INTO kud2014_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Maheyaone adi tau'ita aviviniwone yadi meheuhiyena hidena ta hilalaune dalavai, ta ginauliwowa hi'i'itadiwa maudoina hiwalo mahalavaedi dalava mwala'idi yo dalava habuludi tomowadiyao aidiyai. Na dalavaowa taniwagadiyao hilaoma yo ebeha hiya mehediyena moihana hi'ita. ");
INSERT INTO kud2014_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Na Yeisu ainai hilaoma ta towahowa hi'i'itane, mugai alu'aluwa yababadi holanai himiyamiyawa bada inamwanamwa'o ta ale'o ili'waya'o na imiyamiya. Tenem ainai maudoidi himeheuhi. ");
INSERT INTO kud2014_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Hi'ita i'ovi, na tauvinunuwone tomowa aidiyai hi'aubabadaei vedova towahonane inamwanamwane, na vedova maheyaone yadi mwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Na dalava taniwagadiyao hivetuwuni tenem ainaena ta Yeisu hisosomanaei ebeha yadi dalava ilaugabaei. ");
INSERT INTO kud2014_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Eeta Yeisu idobidobi wagai habi gelu, na towahowa wau i'a'abiye namwanamwawa Yeisu ainai i'awanoi iwalo, ‘Taubada, howahowana yamulitaego?’ ");
INSERT INTO kud2014_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Na Yeisu iwalo, ‘Nigele howahowana, na hesi uwuyo yo ulau yam huhu aidiyai na Yaubada yana atemuyamuyaena i'a'abiye namwanamwagone u'aubabada ta hibenalei’. ");
INSERT INTO kud2014_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Na towahonane ilau abaloina Dekapolisi ana dalava 10 aidiyai, ta Yeisu yana paihowa wahiwahiyaladi vehabadi iyeyewasane, na tomowa maudoidi hibebenaleine ta nuwadi ipwanopwano. ");
INSERT INTO kud2014_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yeisu mayana taumulitao higeyo'awauyo ta boda mwala'ina hitau'ahaiyama le'awai. ");
INSERT INTO kud2014_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Eena ehebo towaho yehana Yailo iya vada tapwalolo ana tau'ita avivini ilaoma ta Yeisu ilobai na mehenai ipwapwagogone, ");
INSERT INTO kud2014_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ta i'awanoi wahiwahiyala, iwalo, ‘Taubada, natugu waihiuna ana lovala ivitai moiha, na iya bada gamahine, na nuwanuwagu ulaoma na u'abisawahi ta inamwanamwa, na havena imwalomwalowoi’. ");
INSERT INTO kud2014_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Eeta Yeisu baidana hilaulau, na boda mwala'ina himulimulitaedi na hi'uha'uhauyoidi amwahai. ");
INSERT INTO kud2014_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na bodaone holadiyai ehebo waihiu ma'ana lovala. Lovalanane neta 'wahina isagesagenaei bolimai 12. ");
INSERT INTO kud2014_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mwalona tau'abiye namwanamwao bagibagilidi aidiyai yana mane maudoina ive'ovidi, na hesi ana lovalane imwalamwala'i. ");
INSERT INTO kud2014_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Waihiunane Yeisu imumulitaeine wuwuna mwalona wasana ibenalena'o, ta atenai inuwanuwatuwu iwalo, ‘Ebe bada Yeisu ana ale'o a'ava ya'abitowoi mata yanamwanamwa’. Eeta itauvahali ta ana ale'o i'a'abitowoine. ");
INSERT INTO kud2014_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Na 'wahinana yana sagena ilaumwau ta'i, ta ibom tauna holanai ilautowoi ebeha bada inamwanamwa'o. ");
INSERT INTO kud2014_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yeisu bada ilautowoiya'o ebeha wahiyala ainaena imahalava'o ta i'ita gwaipile ta boda ipanivilaedi iwalo, ‘Yaiya agu ale'o i'a'abitowoine?’ ");
INSERT INTO kud2014_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ta ana taumulitaone hiwalo auline, ‘Taubada, bada u'itaya'o boda hinoinoihamuigo na hi'uha'uhauhi na owa upanivila, “Yaiya i'abitowoigaune?” ’ ");
INSERT INTO kud2014_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Na Yeisu i'ita'ita behabeha tomowa ahipudiyai yo ebe i'ita yaiya ainai yana wahiyala igegeyo'awane. ");
INSERT INTO kud2014_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Na waihiunane ibom yana namwanamwa wau ilolobaine ihanapuiya'o, ta ilaoma mayana batutuli yo mayana meheuhi na ipwagogo mehenai, ta iwalo mahalava moiha ebeha iya ipapaihowaine. ");
INSERT INTO kud2014_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Na Yeisu iwalo, ‘Natugu, yam yemidi ainaena unamwanamwa'o. Utowolo na mayam yaliyaya ulau. Yam lovala maudoina bada i'ovi'o.’ ");
INSERT INTO kud2014_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Haugana Yeisu i'au'aubabada waihiune ainai, tupwadi tomowa Yailo yana vadaena wasa hilawenama ta hiwalo, ‘Natumwa bada yawahina i'ovi'o, na havena hinage tauve'itane yana hauga ugabagabaei’. ");
INSERT INTO kud2014_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Na Yeisu wasane ibenalei ta Yailo ainai iwalo, ‘Havena u'alu'alugavai na hesi uyemidiyegau’. ");
INSERT INTO kud2014_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Eeta Yeisu boda maudoidi i'auhidi havena himulimulitaei na bada ana taumulitao hitau tonuga baidanao, neta Pita yo Yemesa matahina Yoni. ");
INSERT INTO kud2014_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Hilau ta Yailo yana vadai himahamahalava, na woe yo dou mwala'ina holanai hibebenaleine. ");
INSERT INTO kud2014_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Na Yeisu iluwu ta iwalo aulidine, ‘Hava vehabana amdoudoune na amwoewoene? Gamahinene nigele iyamwalowoi na hesi i'eno i'iwahi'o.’ Ta himaluwei, ");
INSERT INTO kud2014_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","na hesi Yeisu iheusilidi ta himahalava na gamahine tamana yo hinana yo ana taumulitaowa hitau tonugawa Yeisu baidadi hiluwu gamahinewa yana aba'eno ainai. ");
INSERT INTO kud2014_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ta Yeisu gamahinene nimanai i'abi na iwalo, ‘Talita kumi’. Na ana bui, ‘Gamahine utowoloma’. ");
INSERT INTO kud2014_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Na itowolo mwayamwayau ta ilowolowouhi, wuwuna iya ana bolimai 12 ilobaiya'o. Na maudoidi nuwadi ipwanopwano moiha. ");
INSERT INTO kud2014_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Eena Yeisu i'auhidi iwalo, ‘Havena teya yaiya ainai amwalowalo mahalava yagu paihowa teina vehabana, na hesi gamahinene ana am'atububuni ta i'ai’. ");
INSERT INTO kud2014_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Na Yeisu iwuyo yana dalavai, na ana taumulitaone himumulitaeine. ");
INSERT INTO kud2014_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ta Tapwalolowai yadi vada tapwalolo ainai iluwu, ta ivetuwuni ive'ive'ita, na tomowa hibenalei, ta maudoidi nuwadi ipwanopwano yana hanapu, yo yana paihowa vehabadi, na hiwalo, ‘Towaho teina havaena yana hanapune ilolobaine? Na hinage paihowaone wahiwahiyaladine nimanaena ipaipaihowaidine havaena yana wahiyala ilolobaine?’ ");
INSERT INTO kud2014_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Na hinage hiwalo, ‘Towaho teina iya kapentawa awa? Na hinana Meli yo tahinao Yemesa yo Yosepa, yo Yudasi, yo Saimoni, yo hinage nuhunao baidadao tamiyamiya awa?’ Vehabana tomowa Yeisu hisosomanaei. ");
INSERT INTO kud2014_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Na Yeisu aidiyai iwalo, ‘Tauwalo mahalavao adi ve'ahihi hilobalobai vali dalava aidiyai. Na hiya yadi dalavai nigele adi ve'ahihi, wuwuna hiya yadi bodao yo yadi huhuwo hisosomanaedi.’ ");
INSERT INTO kud2014_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Na Yeisu nuwana ipwanopwano wuwuna tomowa nigele hiyayemidiyei, eeta nigele howahowana na paihowa wahiwahiyaladi ipaihowaidi. Ta bada taulovalao bwaubwaudi i'abisawahidi ta hinanamwanamwane. Yeisu ita'i'ili dalava aidiyai, ive'ive'ita. ");
INSERT INTO kud2014_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Na ana taumulitao hitau 12 iyogaedima ta iloinaedi yo ebeha bwaubwau hita'i'ili dalava aidiyai, na hinage loina yo wahiyala imohedi ta ebe howahowadi alu'aluwa yababadi tomowa aidiyena hiheusili mahalavaedi, ");
INSERT INTO kud2014_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ta yana guguya ainai iloinaedi, iwalo, ‘Havena ehebo hava amvaivai. Havena ai'ai nuwana peha nuwana mane tamahina vehabana. Neta bada yami digona nimamiyai, ");
INSERT INTO kud2014_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","yo aemi adi huma amli'wadi na hesi havena ami ale'o bwauna amvaivai.’ ");
INSERT INTO kud2014_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Na hinage iwalo aulidine, ‘Ebe aiteya vada ainai hiyogaegomiu yo ainai amluwu, vadanane ainai amvetaumana ana higa dalavanane amlaugabaei. ");
INSERT INTO kud2014_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na ebe hinage dalava tupwana aidiyai ammahalava, na tomowadine nigele hiyayogaegomiu, yo hinage nigele yami guguya hiyabenaledi, dalavadine gawaladine aemiyena am'oiyeholudi na amlaugabaidi, yo ainaena amve'itadi ebeha mata vitai aidiyai imahalava.’ ");
INSERT INTO kud2014_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Eeta ana taumulitaone hita'i'ili dalava bagibagilidi aidiyai, ta higuguya ebeha tomowa yadi mumuga yababadi hita'wata'wataedi na hinuwabui, ");
INSERT INTO kud2014_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","yo hinage alu'aluwa yababadi tomowa aidiyena hiheusilidi, yo taulovalao maudoidi woloiyena hihaudi ta hinanamwanamwane. ");
INSERT INTO kud2014_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yeisu wasana tomowa hivetala au'aubabadaei tupwa maudoina aidiyai, ta wasawasa Helodi ibebenaleine tupwadi tomowa hiwalowalo ebeha ‘Yoni tau'abiye bapitaiso mwalowoiyena bada itowolouyo'o ta mayana wahiyala ipaipaihowa’. ");
INSERT INTO kud2014_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Na tupwadi hiwalo, ‘Iya Elaitiya’. Na tupwadi hinage hiwalo, ‘Iya tauwalo mahalava ehebo dova tauwalo mahalavao mugamugaidi’. ");
INSERT INTO kud2014_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Helodi hinage Yeisu wasana bada ibenalena'o ta iwalo, ‘Nuwana iya Yoni tau'abiye bapitaisowa, mwalona ya'o'oiye mwalowoiwa na bada itowolouyo'o’. ");
INSERT INTO kud2014_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Wuwuna mwalona Helodi Yoni i'abi avivini ta vada paipaiyai imwauwi, na Yoni ana abi'avivini wuwuna neta ehebo waihiu yehana Helodiyasa, Helodi tahina Pilipi asolena na Helodi ihaloi, ");
INSERT INTO kud2014_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","na Yoni Helodi iwalo auline ebeha, ‘Tenem nigele mumuga namwanamwana, wuwuna tahim asolena uhaloi’. ");
INSERT INTO kud2014_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Na Yoni yana guguya teina vehabana waihiuwa Helodiyasa inuwayababa moiha ta nuwanuwana na Yoni i'oiye mwalowoi, na nigele howahowana ");
INSERT INTO kud2014_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","wuwuna Helodi inuwavi ebeha Yoni towaho dumwaluna na Yaubada yana taupaihowa ehebo, eeta Helodiwa Yoni ive'ahihiyei, na hauga bagibagilina Helodi nuwanuwana na Yoni yana walo ibenabenalei ta vehabadi i'aluwagavai. ");
INSERT INTO kud2014_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mulitai Helodiwa yana ahubena labahina imahalava ta Helodiyasa bada amwaha inuwatuwu lobaiya'o Yoni ana oiyemwalowoi vehabana. Ahubena labahinane ana abanuwatuwu avivini mahulina hipapaihowai, ta tupwana taumanao hiyogaedima habi ai. Taumanaone neta gabemani adi tauloinao, yo tau'alehao adi taumugaiwo yo tupwadi Galili dalavanaone adi babadao. ");
INSERT INTO kud2014_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Hauganane Helodi ma'ana taumanao hi'ai'ai, Helodiyasa natuna waihiuna iluwuma ta selowena i'abiye yaliyayadi. Eeta Helodi vahalawa ainai iwalo yemidi, iwalo, ‘Ebe aiteya ginauli nuwanuwam u'awanoiyegau mata yatalamwei alimwai’. ");
INSERT INTO kud2014_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Na hinage iwalo hae i'awa tamada, iwalo, ‘Moiha yawalo yemidi hava nuwanuwam yamohego, ebe yagu abaloina vehabana u'awanoi mata tupwana yamohego.’ ");
INSERT INTO kud2014_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Eeta vahalanane imahalava ta ilau hinana ainai ipanivila, iwalo, ‘Hinagu, hava yam nuwatuwu ta wasawasa ainai ya'awanoi?’ Na hinana iwalo, ‘Wasawasa uwalo auli uwalo, “Nuwanuwagu Yoni tau'abiye bapitaiso ulu'uluna’”. ");
INSERT INTO kud2014_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Vahalawa ilau mwayamwayau ta iwuyo wasawasa ainai, na iwalo, ‘Nuwanuwagu teina ta'i Yoni tau'abiye bapitaiso ulu'uluna gaeba ainai umwauwi, na umohegau’. ");
INSERT INTO kud2014_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ta Helodi inuwayababa moiha, na nigele howahowana yo ita'wata'wata, wuwuna wau bada iwalo yemidi'o taumanaone mehediyai. ");
INSERT INTO kud2014_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Eeta vada paipai ana tau'ita'ita avivini ehebo iloinaei ta ilau Yoni gadona habitomna. Ainaena tau'ita aviviniwa vada paipaiyai ilau ta Yoni gadona itotomne, ");
INSERT INTO kud2014_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","eena ulu'ulunawa gaeba ainai ido'oi ta ilawenama, vahalawa imohei, ta ivai ilalaune hinana ainai. ");
INSERT INTO kud2014_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Na Yoni ana taumulitao yana mwalowoi wasana hibenalei ta hilaoma Yoni taunane hivai himamagaiyeine. ");
INSERT INTO kud2014_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yeisu yana tauyewasao hitau 12 bada hiwuyoma'o na Yeisu ainai yadi paihowa yo yadi ve'itao maudoina hi'aubabadaedi. ");
INSERT INTO kud2014_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Na tomowa bagibagilidi hilaolaoma yo hiwuyowuyo, ta nigele howahowana na Yeisu mayana taumulitao hi'aiyawasi yo hi'ai, eeta aidiyai iwalo, ‘Tupwa teina talauvehulu na talau ehebo tupwa balabala awawai yo tenem ainai tupwana am'aiyawasi’. ");
INSERT INTO kud2014_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Eena waga ainai higelu ta hilau ehebo balabala awawa ainai. ");
INSERT INTO kud2014_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Na bodaone Yeisu mayana taumulitao yadi gelu hi'itaya'o ta hihanapuiya'o tupwa yehana ainai hilalaune, eeta hiya yo dalava bahudi tomowadi hinage baidadiyao amwahaena hisagena ta himahalava mugai tupwanane ainai. ");
INSERT INTO kud2014_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Na mulitai abo waga iduna, Yeisu i'aitulu maguwai, ta boda mwala'ina namonamowai i'i'itadine, na i'atemuyamuyaedi wuwuna hiya bada dova sipiwo nigele adi tau'ita aviviniwo, eeta ivetuwuni na hanapu bahuna aidiyena iveve'itane aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Na lavilaviyai ana taumulitaone hilaoma ta Yeisu ainai hiwalo, ‘Taubada, tupwa teina balabala awawa na bada mahana ihugu'o, ");
INSERT INTO kud2014_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","boda teina uvetamaledi hilau adi higimwala dalavao yo vadao vahalidiyai aidiyena’. ");
INSERT INTO kud2014_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Na Yeisu aidiyai iwalo, ‘Vedova? Omiu mata nigele amyave'aidi awa?’ Na ana taumulitao hiwalo, ‘Taubada, nigele howahowamai, wuwuna maudoidi adi ana maiha nuwana 2000 kina dova’. ");
INSERT INTO kud2014_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yeisu ipanivilaedi iwalo, ‘Viha beledi alimiyai? Amlau ambeha.’ Eeta bada hilobaiya'o, ta Yeisu hiwalo auline hiwalo, ‘Beledi nima'ehe'ehebo na yama bwau alobaidi'o’. ");
INSERT INTO kud2014_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Eeta Yeisu ana taumulitao iloinaedi yo bodao hiyemiyadi boda yo boda awahiyai. ");
INSERT INTO kud2014_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Hiwaheidi ta himimiyane, boda tupwadi tomowa 100, yo boda tupwadi tomowa 50. ");
INSERT INTO kud2014_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ta beledi nima'ehe'ehebo yo yama bwau ivaidi ta Tamana ainai itamayahi na i'awa yauwedo ai'aiwone vehabadi, na i'abitomwahidi ta ana taumulitao imohedi ta hi'aiyauyanedi. Na hinage yama bwauwa dova i'abitomwahidi. ");
INSERT INTO kud2014_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Maudoidi hi'ai ta hi'ai i'iwahi. ");
INSERT INTO kud2014_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Na beledi yo yama uleyadi hitau'ahaiyama ta boha 12 hi'oiye mwaudine. ");
INSERT INTO kud2014_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tau'aiwone towatowaho a'ava adi bagibagili 5000 dova. ");
INSERT INTO kud2014_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Mulitai ana taumulitao iloinaedi ta wagai higelu, na Yeisu iwalo, ‘Amgelu ammugai Bedesaida hali tupwai na yabom teinai bodaone yawalo hiwuyo yadi dalavai’. ");
INSERT INTO kud2014_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ta higelu na Yeisu bodaowa ivetamaledi i'ovi, na ihae oyai habi awanoi Yaubada ainai. ");
INSERT INTO kud2014_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Bada iboni'o na ana taumulitao ni'u awawai hiwohewohe, na hesi Yeisu ibom magumaguwai ");
INSERT INTO kud2014_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","i'itadi yadi wohe ainaena hitapiya'o, wuwuna wau yaumai mehediyena ilaolaoma. Muhamuhana na i'ahubena Yeisu ni'une ewanaena ilaolaoma, ta ebe vahalidiyena ilau. ");
INSERT INTO kud2014_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tenem ainai Yeisu ana taumulitaone maudoidi Yeisu hi'ita ni'une ewanaena ilaolaoma na hinuwanuwatuwu ebeha iya alawai, ");
INSERT INTO kud2014_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ta himeheuhi mwala'ina. Na Yeisu aidiyai iwalo, ‘Havena ammehemeheuhi. Yau ta'i, am'atepatu.’ ");
INSERT INTO kud2014_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ta wagai igelu baidanao na ni'u idadaumwaline. Na nuwadi ipwanopwano, ");
INSERT INTO kud2014_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","haugana boda iveve'aidine nigele hiyanuwamasele wuwuna atedi mehedi igibu. ");
INSERT INTO kud2014_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Higeyo'awa tupwa Genesaleta ainai ta le'awanai hiluwu, na yadi waga tenem ainai hilowom ta hihahaene. ");
INSERT INTO kud2014_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Hihae na dalava taniwagadiyaone Yeisu hi'atai, ");
INSERT INTO kud2014_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","eeta hisagesagena ta hilau dalava maudoidi aidiyai, ta taulovalao hipageidima mayadi halabi Yeisu ainai, aiteya tupwa ainai hibenalena'o ilalau na boda himulimulitaei. ");
INSERT INTO kud2014_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ta Yeisu ita'i'ili tupwa bagibagilidi aidiyai, tupwana dalava mwala'idi yo dalava habuludi yo oyao aidiyai, na tomowa bahudi yadi tau'asiyebwao hilawedima ta abamaketi aidiyai hiha'waha'wa ta hi'awanoiyeine hiwalo, ‘Taubada howahowana yo yama tau'asiyebwaone am ale'o papalinane hi'abitowoi?’ Na Yeisu aidiyai italam, ta ana ale'o hi'abisawahi na hinanamwanamwane. ");
INSERT INTO kud2014_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Palisiwone yo loina ana tauve'itao tupwadi hinage Yelusalemaena hilaoma ta Yeisu ainai hitau'ahai, ");
INSERT INTO kud2014_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ta hi'ita lobaidi Yeisu ana taumulitao tupwadi hi'ai'ai, na nigele nimadi hiyauwadi, eeta hi'ulumiyaedi. ");
INSERT INTO kud2014_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Wuwuna Palisiwone yo hinage Yudeyaone maudoidi yadi mumuga tubudiyao aidiyena neta dova: Mugai nimadi hiuwa ili'ilimanidi na abo mulitai hi'ai. ");
INSERT INTO kud2014_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Na hinage ebe maketi ainaena hilaoma nimadi hiuwa mugaiyedi, mulitai hi'ai. Na hinage loina bahudi tubudiyaone aidiyena gaeba yo vedi yo walata adi uwa vehabadi himulitaedi. ");
INSERT INTO kud2014_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Eeta teina Palisiwone yo loina ana tauve'itaone Yeisu ainai hipanivila, hiwalo, ‘Hava vehabana am taumulitaone tubudao yadi loina nigele hiyave'ahihiyedi, na manima bi'ibi'idi hi'ai'ai?’ ");
INSERT INTO kud2014_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Na Yeisu aidiyai iwalo, ‘Tau'oyama omiu! Mwalona Aisaya tauwalo mahalava vehabamiu iwalo mahalava, na Yaubada yana walone hilelelene teina dova: “Tomowaone teina hopadiyena hive'ahihiyegau, na atediyena nigele. ");
INSERT INTO kud2014_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Na hinage aliguwai hitapwatapwalolo oyama, wuwuna yadi ve'itao yau nigele aliguwena, na hesi tomowa bada yadi nuwatuwuwena.” ’ ");
INSERT INTO kud2014_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ta Yeisu iwalo aulidi hinage, iwalo, ‘Moiha ta'i, yami mumuga yababadi aidiyena Yaubada yana loina ammwaudawanidi, na tubumiyao hesi yadi mumuga ammulimulitaedi’. ");
INSERT INTO kud2014_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Na hinage iwalo, ‘Amhanapu moiha ta yami paihowa ainaena; Yaubada yana loina amta'wata'wataedi na hesi tubumiyaone yadi mumuga am'abi avivinidi. ");
INSERT INTO kud2014_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mugai Mosese Yaubada yana loina iwalo mahalavaena'o, iwalo, “Tamam yo hinam uve'ahihiyedi”. Na hinage iwalo, “Ebe yaiya tamana nuwana hinana i'awa yababaedi, ilowoinane yo am'oiye mwalowoi”. ");
INSERT INTO kud2014_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Na omiu yami ve'ita oya'oyama teina dova, “Ebe ehebo yaiya tamana yo hinana iwalo aulidi iwalo, ‘Yagu tobwatobwa bada yatalamwena'o Yaubada ainai ta ve'ave'ahihina, ainaena nigele howahowana yo yahaguigomiu’.” ");
INSERT INTO kud2014_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Teina yami loina ainaena tomowa yadi hagu tamadiyao yo hinadiyao aidiyai am'au'auhidi. ");
INSERT INTO kud2014_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tubumiyaone yadi loina teina ainaena, yo yami ve'ita bagibagilidi dova aidiyena, Yaubada yana loina amyepaipaihiyei.’ ");
INSERT INTO kud2014_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Bodaone iyogauyowedima na iwalo aulidine, ‘Yagu walo teina maudoimiu ambenaledi na amnuwamasele: ");
INSERT INTO kud2014_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Nigele teya hava iyamiyamiya ebe ta'ai na hi'abiye bi'igita, na hesi nuwatuwuwo atedaena hilaolaoma hiya howahowana hi'abi'abiye bi'igita.’ ");
INSERT INTO kud2014_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Eeta Yeisu mayana taumulitao bodaone hilauvehuludi ta vadai hiluluwune, na ana taumulitaone hipanivilaeine hiwalo, ‘Howahowana yam walo vegevegedine tomowa aidiyai ebe ulivahi alimaiyai?’ ");
INSERT INTO kud2014_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Na Yeisu aidiyai iwalo, ‘Nuwana omiu hinage yami nuwatuwu nigele iyamasele awa? Ainaede nigele amyahanapui ebeha hava ta'ai na iluwu holadai mata nigele iya'abiye bi'igita, ");
INSERT INTO kud2014_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","wuwuna nigele atedai iyalau na hesi diyada a'ava ainai iluwu, na mulitai abo ilau mohomoho ainai.’ (Yeisu yana ve'ita teina ana hanapu, ebeha nigele teya ai'ai laulaugagayona, na hesi maudoina howahowana ta'ai.) ");
INSERT INTO kud2014_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yeisu hinage iwalo, ‘Hava tomowa atediyena imahamahalava howahowana i'abiye bi'idi, ");
INSERT INTO kud2014_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","dova mehe'ayo, aivavali, yemwalowoi, pwanoli, ");
INSERT INTO kud2014_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","aiduma, nuwatuwu bi'ibi'idi, oyama, abimaitawahola, alomagigili, vetalapili, nuwahaehae, na talinatui. ");
INSERT INTO kud2014_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Teina nuwatuwu yababadine tomowa holadiyena himahamahalava na hi'abi'abiye bi'idi.’ ");
INSERT INTO kud2014_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tenem ainaena Yeisu itowolo na ilalaune Taya yo Saidoni tupwadiyaone aidiyai, ta ehebo vada ainai iluwu, wuwuna nigele nuwana yo tomowa hihanapui yana laoma vehabana. Na hesi nigele howahowana yo imiya aidawani, ");
INSERT INTO kud2014_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","wuwuna ehebo waihiu Yeisu yana laoma wasana ibenalena'o. Na waihiunane nigele Yudeya tomowana na hesi iya Pinisiya waihiuna tupwa Siliya holanaena, na natuna waihiuna bada alu'aluwa yababana i'abiye yababaya'o, eeta hinana ilaoma ta Yeisu ainai ipwagogo aitulu, ta i'awanoiyeine yo ebe alu'aluwa yababanawa natuna ainaena iheusili mahalavaei. ");
INSERT INTO kud2014_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Na Yeisu iwalo, ‘Ilowoinanei ta hedaheda adi yamohe mugaiyedi, na nigele howahowana hedaheda adi yavai ta edewa yamohedi’. ");
INSERT INTO kud2014_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Na waihiune iwalo, ‘Ehewa Taubada, na hesi edewa vatavata elauhanaena hedaheda adi mugumuguna ainaena hi'ai'ai’. ");
INSERT INTO kud2014_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Na Yeisu iwalo, ‘Neta walo moiha. Utowolo na uwuyo yam vadai, alu'aluwa yababana natum ainaena imahalava'o ta bada inamwanamwa'o.’ ");
INSERT INTO kud2014_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Eeta itowolo ta ilalaune yana vadai, na natunane ilobai yana aba'eno ainai, bada inamwanamwa'o. ");
INSERT INTO kud2014_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yeisu Taya ilaugabaei na ilalaune Saidoni, na hinage ibuidi'wa Dekapolisi tupwanaone aidiyena ta imahalava Galili ni'una ainai. ");
INSERT INTO kud2014_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Na ehebo towaho hilauvaiyamane Yeisu ainai iya talinana 'waba'wabalina, na hinage guguguna. Yeisu hi'awanoiyei yo ebeha i'abitowoi na inamwanamwa. ");
INSERT INTO kud2014_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Na Yeisu towahonane ilauvai ta bodaone aidiyena hitatauwahine hibom, na Yeisu nimana towahowa talinanai imwauluwuwedi, na mulitai ibom nimana ihowai, na towahone memenana i'a'abitowoine. ");
INSERT INTO kud2014_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ta Yeisu i'ita hae galewai na atemuyamuyaena iwalo auli iwalo, ‘Epapata’, neta ana bui ‘Ulotaho'e’. ");
INSERT INTO kud2014_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Eeta towahonane talinana hilotaho'e, na hinage memenana bada inamwanamwa'o, yo howahowana i'aubabada na ibenali ili'ilimani. ");
INSERT INTO kud2014_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yeisu tomowa i'auhidi ta ebeha havena yana paihowawa hiwalowalo mahalavaei. Na laugagayone nigele hiya'ita avivini, na hesi hiyewasaei tomowa aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ta hiya bada hibenalena'o nuwadi ipwanopwano mwala'ina na hiwalo, ‘Yana paihowa maudoina namwanamwana na abanuwapwanopwano, wuwuna talina 'wabali i'abiye maseledi, na gugugudi i'abiye dumwaludi ta hi'au'aubabada’. ");
INSERT INTO kud2014_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Hauga tenem ainai boda mwala'ina hinage hitau'ahaiyama Yeisu ainai, na nigele adi. Ta ana taumulitao iyogaedima na aidiyai iwalo, ");
INSERT INTO kud2014_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","‘Tomowa teina ya'atemuyamuyaedi, wuwuna bada ahubena tonuga teinai baidaguwao amiyamiya, na nigele adi. ");
INSERT INTO kud2014_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ebe mavahalidi yavetamaleuyoidi mata amwahai hitai, wuwuna tupwadi amwaha daodaowena hilalaomane.’ ");
INSERT INTO kud2014_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Eena Yeisu ana taumulitaone ainai hiwalo, ‘Vedova balabala awawa teina, na mata vedova tomowaone adi talobaine?’ ");
INSERT INTO kud2014_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ta Yeisu ipanivilaedi iwalo, ‘Viha ami belediwone?’ Na hiwalo, ‘Beledi 7’. ");
INSERT INTO kud2014_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Eeta boda iloinaedi ta bale'uwai himimiyane, na beledi 7 ivaidi, na vehabadi i'awa yauwedo Yaubada ainai, ta i'abitomwahidi, na ana taumulitao imohedi, yo tomowa aidiyai higuyauwei ta hi'a'aine. ");
INSERT INTO kud2014_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tupwana yama habuludi hinage himiyamiya, ta Yeisu vehabadi i'awa yauwedo ta ana taumulitao iloinaedi hinage higuyauwedi tomowa aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Eeta maudoidi hi'ai ta hi'ai i'iwahi na mulitai uleya hitano'ahaiyama ta boha 7 hi'oiye mwaudine. ");
INSERT INTO kud2014_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Na bodaone adi bagibagili 4000 dova. ");
INSERT INTO kud2014_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tenem ainai ivetamaleuyoidi, na mayana taumulitao himwayamwayau ta yadi wagai higelu, ta Dalimanuta tupwanaena hilalaune. ");
INSERT INTO kud2014_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Palisiwone hilaoma, ta Yeisu ainai hi'awa pa'ipa'i'i, ta hitowoi yo ebeha ve'ive'ilala ehebo ipaihowai vehabadi na hi'awa moiha ebeha yana wahiyala Yaubada ainaena ilaoma. ");
INSERT INTO kud2014_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Na Yeisu mayana nuwayababa aidiyai iwalo, ‘Vedova ta yaso teina omiu nuwanuwamiu ve'ive'ilala, na hesi mata nigele ve'ive'ilala amya'ita’. ");
INSERT INTO kud2014_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","I'ovi na itauvehuludi na wagai igeluyo ta higegeyo'awane hali tupwai. ");
INSERT INTO kud2014_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Adi tamahina nigele hiyavai wuwuna hinuwapwanopwanowedi, na beledi ehebo ta'i wagai itutupwane. ");
INSERT INTO kud2014_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ta Yeisu ivenuwamwauwedi iwalo, ‘Palisiwone yo Helodi adi beledi ana abiyeseseha ainaena am'ita avivinigomiu’. ");
INSERT INTO kud2014_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Eeta taumulitaone hibom aidiyai hiwalo, ‘Nuwana Yeisu yana walo wuwuna ada tamahina tanuwapwanopwanowei’. ");
INSERT INTO kud2014_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Na Yeisu yadi nuwatuwu bada ihanapuiya'o ta iwalo, ‘Hava vehabana amwalowalo ebeha nigele ami tamahina? Neta nigele vehabana yayawalo. Nuwana howola manuwapwanopwanomiu, ta nigele howahowana yo yagu walo amhanapuidi. ");
INSERT INTO kud2014_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mamehemiu na hesi nigele amya'ita, na hinage matalinamiu, na hesi nigele amyabenaledi, ainaede nigele howahowana amnuwatuwu avivinidi yagu paihowa bodaone adi ve'ai vehabana awa? ");
INSERT INTO kud2014_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Hauganane beledi nima ehe'ehebo ainaena tomowa 5000 yaveve'aidine, na tupwa viha boha amtatano'ahaidine?’ Ta hiwalo, ‘Boha 12’. ");
INSERT INTO kud2014_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Na Yeisu ipanivila hinage, iwalo, ‘Na hauganane beledi 7 ainaena tomowa 4000 yaveve'aidine, na tupwa viha boha amtatano'ahaidine?’ Na hiwalo, ‘Boha 7’. ");
INSERT INTO kud2014_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Eeta Yeisu iwalo, ‘Omiu besiwa yami nuwatuwu nigele hiyamasele’. ");
INSERT INTO kud2014_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mulitai Bedesaida ainai hilaoma, ta towaho taumehe gibugibu tomowa hilauvaiyama Yeisu ainai, ta hi'awanoiyei yo ebe i'abitowoi na inamwanamwa. ");
INSERT INTO kud2014_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Na Yeisu taumehe gibugibuwa nimanai i'abi ta ilauvai, na dalavanane ainaena himahalava. Ta Yeisu towahonane mehena iwulaidi na nimanaena mehena i'abitowoidi na iwalo, ‘Howahowana hava u'itadi?’ ");
INSERT INTO kud2014_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Na towahonane ivinuvinunu ta iwalo, ‘Tomowa ya'itadi na adi ita dova aiwa hilowolowouhi’. ");
INSERT INTO kud2014_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Na Yeisu hinage towahonane mehena i'abitowoiuyoi, ta ivinunuyo, mehena himasele moiha, na ginauli maudoidi i'itadine. ");
INSERT INTO kud2014_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","I'ovi na Yeisu ivetamalei, iwalo, ‘Havena uwuyowuyo dalava mwala'ina ainai, na hesi ulau yam vadai’. ");
INSERT INTO kud2014_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tenem ainai Yeisu mayana taumulitao hilalau Sisaliya Pilipai dalavanao vehabadi, na amwahai ana taumulitao aidiyai iwalo, ‘Vedova tomowa yadi walo vehabagu ebeha yau yaiya?’ ");
INSERT INTO kud2014_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Na ana taumulitaone hiwalo, ‘Tomowa tupwadi hiwalo ebeha owa Yoni tau'abiye bapitaiso, na tupwadi hiwalo ebeha owa Elaitiya, na tupwadi hiwalo ebeha owa tauwalo mahalava mugamugaina teya’. ");
INSERT INTO kud2014_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Eena hinage ipanivilauyowedine, ‘Na omiu vedova yami nuwatuwu ebeha yau yaiya?’ Na Pita iyemaiha iwalo, ‘Owa Besinana towahona’. ");
INSERT INTO kud2014_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Na Yeisu ivenuwamwauwedi, iwalo, ‘Havena yaiya ainai amwalowalo mahalavaegau’. ");
INSERT INTO kud2014_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Hinage ivetuwuni yo hava howola abo ilobai ive'itaei aidiyai, iwalo, ‘Yau Tomowa Moihagu howola abo muya mwala'ina yalobai. Wuwuna babadaone yo taupwaoliwone mwala'idi yo loina ana tauve'itao mata hisosomanegau, yo hi'oiye mwalowoigau, na ahubena tonuga dagelanai abo yatowolouyoma.’ ");
INSERT INTO kud2014_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yeisu yana walo teina ainaena imwau mahalavaena'o yana mwalowoi vehabana. Na Pita Yeisu ilauvai ta baidana hilau lovai, ta iwalo tomtom ebe havena ginauliwone teina himahamahalava Yeisu ainai. ");
INSERT INTO kud2014_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Na Yeisu i'ita gwaipile ta ana taumulitao ivinuvinunuidi, ta Pita iwalo yagai, iwalo, ‘Owa Tomodulele, teina ta'i ulaugabaigau, wuwuna yam nuwatuwu tomowa yadi nuwatuwu na nigele Yaubada yana nuwatuwu dova’. ");
INSERT INTO kud2014_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Eeta Yeisu boda maudoidi yo ana taumulitao baidadiyao iyogaedima ta aidiyai iwalo, ‘Yaiya ebe nuwanuwam na umulitaegau, ilowoinanego na yam nuwatuwu uta'wata'wataedi yo hinage am aiwa lagalagana u'avalai ta umwalowoi, neta dova agu mulita ana amwaha. ");
INSERT INTO kud2014_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Na ebe yaiya yawahina inuwavi, mata yawahinane ivetau'wadalele. Na ebe yaiya vehabagu yo wasa namwanamwana vehabana yawahina italamwei na imwalowoi, iya mata yawahina moiha ilobai. ");
INSERT INTO kud2014_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ebe yada wasawasao mwala'idi bale'uwai talobaidi neta ginauli awa'awawa, na hesi ginauli mwala'ina neta yawahida moiha. ");
INSERT INTO kud2014_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Wuwuna ebe yawahida moiha tavetau'wadalele, nigele hinage teya ana miyalae iyamiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yau Tomowa Moihagu, na ebe yaiya owa vehabagu uhinimaya na uuvalaegau, yaso teina yababadi na pwanopwanolidi mehediyai, howola abo yauvalaego, hauganane Tamagu yana wasawasa pigapigabuna ainaena yawuyoma yana tausagenawasaone baidaguwao. ");
INSERT INTO kud2014_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","‘Na hinage yawalo ili'ilimani alimiyai ebeha tupwadi alimiyena havena ammwalomwalowoi ana higa Yaubada yana loina wahiwahiyalana imahalava yo am'ita’. ");
INSERT INTO kud2014_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ahubena 6 hi'ovi, na Yeisu ana taumulitao tonuga ilauvaidi, hiya Pita yo Yemesa yo Yoni, ta baidanao hihahaene oya ehebo ewanai ta hibom himiyamiya, na hi'i'itane Yeisu ana oleya pigapigabuna, ");
INSERT INTO kud2014_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","na ana ale'owone hihewahewa moiha, ana ita nigele ehebo yaiya bale'uwai howahowana yo ale'o i'abiye masele yo ana hewa dova. ");
INSERT INTO kud2014_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Na hinage Elaitiya yo Mosese himahalava ta Yeisu baidadi hi'au'aubabada. ");
INSERT INTO kud2014_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ta Pita Yeisu iwalo auline, iwalo, ‘Taubada, yada miya teina namwanamwana, eeta yami gwau tonuga a'abidi, ehebo owa, ehebo Mosese, na ehebo Elaitiya’. ");
INSERT INTO kud2014_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Neta Pita bada iwalowalo awa'awawa wuwuna ma'ana geluwone himeheuhi'o. ");
INSERT INTO kud2014_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","I'ovi na yaloyalovi hinage i'aituluma ta i'oihamuidine, na yaloyalovine ainaena ehebo alinana hibebenaleine, iwalo, ‘Teina Natugu moihana. Yana walowo ambenaledi.’ ");
INSERT INTO kud2014_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ta himwayamwayau hi'ita'ita'auhi, na Yeisu bada ibom na nigele teya hava hiya'ita. ");
INSERT INTO kud2014_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Eeta oyaena hi'ai'aitulu, na Yeisu ilaugagayowedi, iwalo, ‘Ginauliwone wau am'i'itadine, havena tomowa aidiyai amwalowalo mahalavaedi ana higa yau Tomowa Moihagu mwalowoiyena yatowolouyoma’. ");
INSERT INTO kud2014_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ta laugagayowa hinobuwei, na hibom hi'au'aubabada hiwalo, ‘Yana walowone towolouyo vehabana vedova ana hanapu?’ ");
INSERT INTO kud2014_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Na Yeisu ainai hipanivilane hinage, hiwalo, ‘Hava vehabana loina ana tauve'itao hiwalo, ebeha Elaitiya ilaumugaima mulitai abo Besinana ilaoma?’ ");
INSERT INTO kud2014_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Na Yeisu iwalo, ‘Ehe, Elaitiya iya ebeha ilaumugaima yo ainaena ginauli maudoidi i'abiye dumwadumwaludi. Na hesi Elaitiyawa bada ilaoma'o, na hesi tomowa hipaihowa yababana ainai hava yadi nuwatuwu, dova Buki Ve'ahihi iwalo mahalavaena'o. Na hinage yau Tomowa Moihagu, Buki Ve'ahihi iwalo mahalavaegau ebeha muya mwala'ina yalobaidi yo hinage tomowa hisosomanaegau?’ ");
INSERT INTO kud2014_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mulitai oyaena hi'aituluma ta ana taumulitao maudoidi hilobauyoidi yo boda bagibagilidi baidadiyao, na hinage loina ana tauve'itao baidadiyao hiveve'awa pa'ipa'i'i. ");
INSERT INTO kud2014_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Na hauganane bodaone Yeisu hi'ita, nuwadi hipwanopwano mwala'ina, ta ainai hisagena mwayamwayau habi velauwei. ");
INSERT INTO kud2014_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Na Yeisu yadi ve'awapa'ipa'i'i vehabana ipanivila, iwalo, ‘Hava vehabana am'au'aubabadane?’ ");
INSERT INTO kud2014_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Na ehebo towaho bodaone aidiyena Yeisu ainai iwalo, ‘Taubada yadi ve'awapa'ipa'i'i wuwuna natugu, alu'aluwa yababana ainai ta nigele howahowana yo i'aubabada, na hesi am taumulitao nigele howahowadi yo hi'abiye namwanamwa. ");
INSERT INTO kud2014_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Na ana lovalane tupwana hauga alu'aluwa yababana yana paihowaena itai na awanaena gwalagwalabuho himahamahalava, yo ivesalatau'i'i eena ibatubatutuli. Na am taumulitaone bada ya'awanoiyedi'o yo ebeha alu'aluwa yababana gama ainaena higabae mahalavaei, na nigele howahowadi.’ ");
INSERT INTO kud2014_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ta Yeisu aidiyai iwalo, ‘Omiu yede vedova? Ta nuwamiu hipwanopwano aliline! Bada yami nuwapwano ainaena ya'abitau'wata'o. Hola gamanane amlauvaiyama, ya'ita.’ ");
INSERT INTO kud2014_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Eeta gamanane hilawei ainai, na alu'aluwa yababana Yeisu i'i'itane, eeta i'abilauwi ta gamawa itai, na bale'uwai ibe'u, na ibatubatutuli na awanaena gwalagwalabuho imahamahalava. ");
INSERT INTO kud2014_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Na Yeisu gama tamana ainai iwalo, ‘Aiteya hauga ainai yana lovala ivevetuwunine?’ Na tamana iwalo, ‘Yana hauga heda ainaena. ");
INSERT INTO kud2014_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ebe itai hauga tupwana ainai igebeuyoi aiwa ala'alahidi aidiyai, na tupwana hauga we'aha ni'uni'udi aidiyai igebeuyoi yo muhamuhana i'oiye mwalowoiuyo.’ ");
INSERT INTO kud2014_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Na Yeisu towahonane iwalo auline, ‘Bada uwalo ebe howahowana, awa? Na hesi unuwatuwu avivini ebe tayemidi, ginauli maudoina malamalaidi alidai.’ ");
INSERT INTO kud2014_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tenem ainai towahonane iwalo mwala'i, iwalo, ‘Bada yayemidi'o, na nigele yemidi moiha. Nuwanuwagu yo yagu yemidi u'abiye wahiyala.’ ");
INSERT INTO kud2014_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Na Yeisu boda maudoidi hisagesagenama i'itadine, eeta alu'aluwa yababana iwaloweine, iwalo, ‘Owa alu'aluwa yababam yam paihowaena gama iyauyaule, yaloinaego yo utauvehulu ta'i, yo havena hinage ehebo hauga uluwuluwuyo ainai’. ");
INSERT INTO kud2014_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Eeta alu'aluwawa iwuiwui ta gama i'abiye tai, ta ibatubatutuli mwala'ina, na alu'aluwa yababana ainaena imahalava ta ilalaune. Na bodaone gama hi'i'itane ana ita dova imwalowoi, na himeheuhi ta hiwalo, ‘Bada imwalowoi'o’. ");
INSERT INTO kud2014_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Na Yeisu gama nimanai i'abi ta i'abiye towolone, bada inamwanamwa'o. ");
INSERT INTO kud2014_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mulitai Yeisu mayana taumulitao hiluwu vadai, ta nemai hibom. Eena ana taumulitaone Yeisu ainai hiwalo, ‘Taubada, vedova ai ta nigele howahowamai yo alu'aluwa yababana aheusili mahalavaei?’ ");
INSERT INTO kud2014_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Na Yeisu iwalo, ‘Nigele teya hava ainaena alu'aluwa yababadi taheusilidi. Neta ta'i awanoiyena Yaubada ainai.’ ");
INSERT INTO kud2014_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yeisu mayana taumulitaone dalavanane hitauvehulu. Ta Yeisu nigele nuwanuwana boda hihanapui aiteya ainai hilalau, ainaede Galili ana amwahanaena hilalaune, ");
INSERT INTO kud2014_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ta ana taumulitao ive'itadine yana mwalowoi vehabana, iwalo, ‘Howola yau Tomowa Moihagu agu tauhuhulawa abo ihuhulaegau agu alehao aidiyai yo hi'oiye mwalowoigau, na ahubena tonuga tuluhanai abo yatowolouyo’. ");
INSERT INTO kud2014_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Na yana aubabadane vehabana nigele hiyahanapui, na hesi nigele ainai hiyapanivila, wuwuna himeheuhi. ");
INSERT INTO kud2014_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bada dalava Kapeneum ainai himahalava ta vadai hiluluwune, ta nemai Yeisu ipanivila ana taumulitao aidiyai iwalo, ‘Aiteya ginauli vehabana am'awa'awa pa'ipa'i'i amwahai?’ ");
INSERT INTO kud2014_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Na hihinimaya ta nigele hiyayemaiha, wuwuna yadi awapa'ipa'i'i neta ebeha yaiya aidiyena ivetaumugai. ");
INSERT INTO kud2014_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Eeta Yeisu imiya na hitau 12 iyogaedima na ive'ita aidiyai, iwalo, ‘Ebe yaiya owa nuwanuwam ta alimiyena uvetauloina ilowoinanego na ubom umwau aituluyowego yo uvetaupaihowa am geluwo vehabadi’. ");
INSERT INTO kud2014_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ta ehebo gama ilauvaiyama ta ahipudiyai ivetowolo na i'atuhapwali ta iwalo aulidine, ");
INSERT INTO kud2014_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","iwalo, ‘Ebe yaiya owa gama teina dova u'awa taumanaei yau vehabagu, neta yau hinage ya'awa taumanaego, na nigele ebeha yabom aliguwai, na hinage agu tauvetamale Yaubada baidagu u'awa taumanaegai’. ");
INSERT INTO kud2014_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yoni ivetuwuni na iwalo, ‘Taubada, ehebo towaho a'i'itane yehamwena alu'aluwa yababadi iheuheusilidi, eeta alaugagayowei, wuwuna towahonane nigele yada boda’. ");
INSERT INTO kud2014_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Na Yeisu hesi iwalo, ‘Havena amlaulaugagayo. Wuwuna ebe ehebo yaiya ginauli wahiwahiyaladi yehaguwena ipaipaihowaidi, nigele mata iyahinaligau. ");
INSERT INTO kud2014_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ebe yaiyadiwo nigele hiyave'alehaegita hiya ada haguwo. ");
INSERT INTO kud2014_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","‘Na hinage amnuwatuwu avivini neta ebe gadomiu imagumaguni na yaiya bwahi ivenumagomiu wuwuna omiu Besinana yana bodao, iya ana maiha namwanamwana howola abo ilobai. ");
INSERT INTO kud2014_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","‘Ebe yaiya itowoi na agu tauyemidi teya heda teina dova na i'abiye be'u, towahonane nuwana waihiunane ilowoinanei na gaima mwala'ina gadonai hihipwai ta magaimana hivehanene ni'uwai. ");
INSERT INTO kud2014_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","‘Hinage ebe nimam i'abiye be'ugo ilowoinanego yo utom vehulu. Neta nigele ana yababa ebe manima tomtomna mata yawahim namwanamwana ulobai. Na hesi iyababa alili alimwai ebe manima bwaubwaum na higabae aituluwego dalava ala'alahina ainai, tupwanane ainai aiwa nigele yana ababoho. ");
INSERT INTO kud2014_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","‘Yo hinage ebe aem i'abiye be'ugo ilowoinanei utomvehulu. Neta nigele ana yababa teya ebe ae ehe'ehebom mata yawahim namwanamwana ulobai. Na hesi yababa'alili alimwai ebe ma'ae bwaubwaum na higabae aituluwego dalava ala'alahina ainai. ");
INSERT INTO kud2014_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","‘Mehem hinage dova, ebe i'abiye be'ugo uwunihivehulu ta'i, wuwuna nigele ehebo hinage ana yababa ebe mamehe ehe'ehebom mata Yaubada yana Abaloina ulobai. Na hesi yababa alilina alimwai ebe mamehe bwaubwaum higabae aituluwego dalava ala'alahina ainai. ");
INSERT INTO kud2014_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tupwanane ainai wesoweso hi'ai'aidi na nigele yadi aba'ovi, na aiwa ala'alahina nigele yana ababoho. ");
INSERT INTO kud2014_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","‘Ainaena tomowa maudoidi aiwa ala'alahina i'abiye namwanamwadi dova yagahu ai'ai i'abi'abiye namwanamwa. ");
INSERT INTO kud2014_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","‘Yagahu ginauli namwanamwana na ebe ana lautowoi isawali nigele howahowana yo inamwanamwauyo. Ta ilowoinanegomiu yo yami mumuga ambom amlautowoidi adi amna dova amvelauwegomiu ehebo ehebo ainai.’ ");
INSERT INTO kud2014_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yeisu tupwanane itauvehulu, ta Yudeya yana tupwaena ilalaune, ta igegeyo'awane bwahi Yolidani hali tupwanaena, ta boda mwala'ina hitau'ahaiyama ainai, na hinage mumuganawa dova ive'ita aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Na Palisiwone hilaoma ta nuwanuwadi yo Yeisu hitowoi, eeta ainai hipanivila hiwalo, ‘Taubada vedova yada loina vinawahe vehabana? Howahowana yo towaho mwanena ivinawaheyei?’ ");
INSERT INTO kud2014_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Na Yeisu iwalo, ‘Vedova Mosese loina imomohegomiune?’ ");
INSERT INTO kud2014_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Na Palisiwone hiwalo, ‘Mosese italam yo ebe towaho nuwanuwana ivinawahe, mugai pepa ainai yana ta'wata'wata iwalo mahalava, eena mwanena imohei ta ebe ivinawaheyei’. ");
INSERT INTO kud2014_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Na Yeisu aidiyai iwalo, ‘Mosese loina neta ilelelene omiu yami nuwapwanopwano vehabana. ");
INSERT INTO kud2014_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Na hesi amnuwatuwu avivini Yaubada yana yemasele mugai ainaena tomowa bwau iyemaseledine towahona na waihiuna. ");
INSERT INTO kud2014_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Teina wuwuna towaho tamana yo hinana ilauvehuludi na asolena baidana himiyabwau, ");
INSERT INTO kud2014_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","yo hitau bwauwone taudi ehebo ta'i. Mwalona hitau bwau himiya wahiwahi na teina hauga bada hive'ehebo'o. ");
INSERT INTO kud2014_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yaubada bada imwaubwauwedi'o, eeta nigele howahowana yaiya teya iyemiya wahiyedi.’ ");
INSERT INTO kud2014_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Na mulitai Yeisu mayana taumulitao hiwuyoma vadai ta taumulitaone hipanivilauyowei vinawahe vehabana. ");
INSERT INTO kud2014_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Na Yeisu iwalo aulidine, ‘Ebe yaiya towaho asolena ivinawaheyei na itawahola geyo'awa vali waihiu ainai, towaho teina mwanena mugamugaina ainai ipaihowai yababana, wuwuna ipwanoli. ");
INSERT INTO kud2014_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na hinage ebe waihiu asolena ivinawaheyei na itawahola geyo'awa vali towaho ainai, waihiunane ipwanoli'o.’ ");
INSERT INTO kud2014_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tomowa hedaheda hilawedima Yeisu ainai ta ebe i'abi aidiyai. Na hesi ana taumulitaone hedahedaone hi'auhidi. ");
INSERT INTO kud2014_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Na Yeisu ana taumulitao i'itadi ta ihinahinabodaidi iwalo, ‘Havena hedaheda amlaulaugagayowedi, na hesi amtalamwedi yo aliguwai hilaoma, wuwuna hedaheda teina dova Yaubada yana Abaloina ilowoinanedi moiha. ");
INSERT INTO kud2014_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Moiha ta'i ebe yaiyadiwo nigele dova teina hedahedaone yadi yemidine, nigele mata Yaubada yana Abaloina ainai hiyaluwu.’ ");
INSERT INTO kud2014_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Eeta Yeisu hedahedaone i'avalaidi ta nimana imwau aidiyai, na iwalo velauwedine. ");
INSERT INTO kud2014_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yeisu itowolo ta ebeha ilau, na ehebo towaho isagenama ta ipwagogo Yeisu mehenai na iwalo, ‘Taubada, yahanapuiya'o ebeha owa tauve'ita namwanamwana, eeta hava mata yapaihowai ta ebe yawahi miyamiya vateyaina yalobai?’ ");
INSERT INTO kud2014_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Na Yeisu towahonane iwalo auli iwalo, ‘Vedova ta u'awa namwanamwaegaune? Nigele teya yaiya namwanamwana; neta bada Yaubada ibom. ");
INSERT INTO kud2014_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Na Yaubada yana loinao bada uhanapuidi'o, neta ebeha: Havena yemwalowoi, havena pwanoli, havena aivavali, havena ve'ewa oya'oyama, havena oyamaena tomowa yadi tobwatobwa uvaivaidi. Na hinage tamam yo hinam uve'ahihiyedi.’ ");
INSERT INTO kud2014_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Na towahonane iwalo, ‘Taubada, yagu hauga heda ainaena na teina wau loinaone teina yamulitaedi moiha’. ");
INSERT INTO kud2014_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Eeta Yeisu mayana yaliyaya towahonane ivinunui, na iwalo, ‘Neta ta'i ehebo ginauli i'abiye be'ugone. Uwuyo yam dalavai, yo yam tobwatobwa maudoina uvegimwalaedi, yo adi maiha u'aiyauyanei wewelohe aidiyai, na ulaoma umulitaegau, ta mulitai yam wasawasa galewai ulobai.’ ");
INSERT INTO kud2014_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Walo teina towahonane ibenalei na yana wasawasa mwala'ina inuwavi, ainaena nuwana iyababa moiha, ta iwuwuyone na Yeisu yana walo nigele iyamulitaei. ");
INSERT INTO kud2014_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Eeta Yeisu i'ita gwaipile ta ana taumulitao aidiyai iwalo, ‘Ebe yaiyadiwo hiya mayadi wasawasa mwala'ina yadi luwu Yaubada yana Abaloina holanai ivitai’. ");
INSERT INTO kud2014_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Na ana taumulitao nuwadi ipwanopwano yana walo teina vehabana. Ta Yeisu aidiyai iwalo, ‘Natuguwao, Yaubada yana Abaloina ana luwu ivitai alili. ");
INSERT INTO kud2014_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Moiha ta'i kameli iya lagulagu mwala'ina, eeta tupwana vitaina yo kameli nidili gudana holanaena iluwu, na hesi wasawasao yadi luwu Yaubada yana Abaloina ainai ivitai ali'alili.’ ");
INSERT INTO kud2014_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yeisu yana walo teina vehabana, ana taumulitao hinuwapwanopwano moiha ta hiwalo auline, ‘Ebe dova, yaiya yede howahowana na awanamwanamwane ilobai?’ ");
INSERT INTO kud2014_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Eeta Yeisu ivinunuidi na iwalo, ‘Ginauli teina vitai ali'alilina tomowa aidiyai, na hesi nigele iyavitai Yaubada ainai, wuwuna Yaubada ainai ginauli maudoina malamalaina’. ");
INSERT INTO kud2014_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Na Pita iwalo, ‘Taubada, ai vedova? Wuwuna yama tobwatobwao maudoidi bada atauvehuluidi'o na amumulitaegone.’ ");
INSERT INTO kud2014_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Na Yeisu iwalo, ‘Moiha, ebe yaiyadiwo omiu yami vadao, yo tahimiyao yo nuhumiyao yo hinamiyao yo tamamiyao yo natumiyao yo yami toputopu amtauvehuluidi, na hinage muya amlobai vehabagu na wasa namwanamwana ana walomahalava vehabana, ");
INSERT INTO kud2014_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ami maiha teina ta'i amlobai dova 100 vadao yo tahimiyao yo nuhumiyao yo hinamiyao yo natumiyao yo yami toputopuwo, yo hinage howola abo galewai yawahimiu miyamiya vateyaina amlobai. ");
INSERT INTO kud2014_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Na teina ta'i taumugaiwone bagibagilidi howola abo himulita, na hiya taumulita howola abo himugai.’ ");
INSERT INTO kud2014_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Howola amwahai hihaehae Yelusalem vehabana, na Yeisu imugamugai, na ana taumulitao himulimulita, na mayadi nuwapwanopwano, na tupwana tomowa hinage mayadi meheuhi amwahai himulimulitaedi. Eeta ana taumulitaone hitau 12 iyoga'ahauyowedi, na ivetamaledi hava mata imahalava ainai, ");
INSERT INTO kud2014_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","iwalo, ‘Teina ta'i tahahae Yelusalem. Yau Tomowa Moihagu na agu tauhuhulane ihuhulaegau taupwaoliwo mwala'idi yo loina ana tauve'itao aidiyai, yo yagu mwalowoi vehabana hiloina, yo mulitai abo himohegeyo awaegau nigele Yudeya aidiyai, ");
INSERT INTO kud2014_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","yo hitalawahiyegau na hihowaigau ta balavaiyena hisapigau, yo mulitai hi'oiye mwalowoigau, na ahubena tonuga abo yatowolouyoma.’ ");
INSERT INTO kud2014_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yemesa yo Yoni, hiya Sebedi natunao, Yeisu ainai hilaoma yo ainai hiwalo, ‘Taubada, alaoma habi awanoi alimwai’. ");
INSERT INTO kud2014_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Na Yeisu iwalo, ‘Hava nuwanuwamiu yo yapaihowai vehabamiu?’ ");
INSERT INTO kud2014_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Na hiwalo, ‘Nuwanuwamai na yam abaloina ainai vahalimwai amiya, ehebo nima tautuwamwena na ehebo nima eha'ehamwena’. ");
INSERT INTO kud2014_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Na Yeisu aidiyai iwalo, ‘Omiu yami awanoi teina vehabana nigele amyahanapui. Muya vedina ainaena mata yanuma, omiu howahowana amnuma? Na hinage mwalowoi ana bapitaiso vitainane abo yalobai, omiu hinage howahowamiu yo ambapitaiso?’ ");
INSERT INTO kud2014_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Na hiwalo, ‘Howahowamai’. Yeisu iwalo, ‘Moiha, vedinane ainaena mata yanumane, omiu hinage ainaena mata amnuma, yo hinage bapitaisonane ainaena abo yabapitaiso omiu hinage dova ambapitaiso, ");
INSERT INTO kud2014_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","na hesi nigele howahowagu yavesinuwa yaiyadiwo howola abo yagu vetauloina ainai nima tautuwaguwena yo nima eha'ehaguwena himiya, wuwuna Yaubada iya yana abaloina na ivesinuwa?’ ");
INSERT INTO kud2014_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Taumulitao hitau nima bwaubwau Yemesa yo Yoni yadi awanoi vehabana hibenalei ta adi modi'iniyedi. ");
INSERT INTO kud2014_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ta Yeisu maudoidi iyoga ahaidima na iwalo aulidine, ‘Omiu amhanapuiya'o hiya bale'uwai hiyogaedi ebeha babadao yadi tomowao hiloiloina yaiyaiyedi. ");
INSERT INTO kud2014_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Na omiu hesi havena hinage dova hiya ampaipaihowai. Na hesi ebe yaiya owa ebe nuwanuwam yo alimiyena uvetauloina ilowoinanego yo am geluwo vehabadi uvetaupaihowa. ");
INSERT INTO kud2014_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Yaiya hinage ebe owa nuwanuwam yo alimiyena uvetaumugai ilowoinanego yo am geluwo maudoidi vehabadi uvetaupaihowa. ");
INSERT INTO kud2014_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","‘Na yau Tomowa Moihagu yalaoma bale'uwai nigele ebeha tomowa vehabagu hipaihowa, na hesi habi paihowa tomowa vehabadi, na hinage yatalamwegau yo yamwalowoi tomowa bagibagilidi adi livahi vehabana.’ ");
INSERT INTO kud2014_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mulitai hilalau Yeliko ainai, na hauganane Yeisu mayana taumulitao Yeliko hilauvehulu, boda mwala'ina hinage himulitaedi, ta taumehe gibugibu yehana Batimiyo hilolobaine, iya Timiyo natuna, na hauga maudoina amwaha papalinai imiyamiya ta i'awa'awanoi mane yo tobwatobwa vehabadi. ");
INSERT INTO kud2014_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Na Batimiyo wasa ibenalei ebeha Yeisu towaho Nasaleti ilalau, eeta Yeisu ainai iyoga, iwalo, ‘Ae Yeisu, owa Deivida tubuna, u'atemuyamuyaegau!’ ");
INSERT INTO kud2014_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Eeta tomowa maudoidi Batimiyo hi'auhi, hiwalo, ‘Ulaumwau! Havena wui!’ Na bada iwui mwalamwala'i, iwalo, ‘Owa Deivida tubuna, u'atemuyamuyaegau’. ");
INSERT INTO kud2014_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Eena Yeisu itowolo ta iwalo, ‘Amyogaenama’. Na boda hinage hiwalo, ‘Ausala, Yeisu iyogayogaego’. ");
INSERT INTO kud2014_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Eeta ana abobo ivaivehuludi, na itowolo mwayamwayau ta Yeisu ainai ilalaune. ");
INSERT INTO kud2014_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ta Yeisu ainai iwalo, ‘Hava nuwanuwam yo vehabam yapaihowai?’ Na taumehegibugibuwa iwalo, ‘Taubada, howahowana yo mehegu u'abiye maseledi?’ ");
INSERT INTO kud2014_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ta Yeisu iwalo, ‘Ausala! Teina ta'i yam yemidiyena bada mehem hinamwanamwa'o.’ Tenem ainai mehena himaseleuyo, ta amwahai Yeisu imumulitaeine. ");
INSERT INTO kud2014_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Haugana hihaehae Yelusalem vehabana na dalavao habuludi Betani na Bedipegi vahalidiyai himahamahalava, neta oya Olibe elauhanai, na Yelusalem mehediyai tupwana amwaha daodaona. Eeta Yeisu ana taumulitao bwau ivetamalemugaiyedi dalavaowa habuludi aidiyai, ");
INSERT INTO kud2014_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","na aidiyai iwalo, ‘Amlau dalava tenem mehedaine ainai, na ebe ammahalava dalavanane ainai, lagulagu ehebo am'ita lobai aiwa ainai hilauhipwaiya'o, neta doniki vauvauna, iya nigele tomowa ainai hiyagelugelu, lagulagunane amlivahi yo amlawenama. ");
INSERT INTO kud2014_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Na ebe yaiya ipanivila alimiyai na iwalo, “Hava vehabana neta lagulagune amlivalivahine?” Towahonane amwalo auli amwalo, “Taubada nuwanuwana, na hauga ahu'ahubalina ta'i abo mulitai ivetamaleuyowenama”.’ ");
INSERT INTO kud2014_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Eeta hitau bwauwa hilau dalavanane ainai ta lagulagu doniki hilobai vada mehe'awanaena, na aiwa ainai hilauhipwaine, eeta hivetuwuni yo hilivahi. ");
INSERT INTO kud2014_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Hilivalivahi na tupwana tomowa hitowotowolo vahalidiyai hiwalo, ‘Hava vehabana neta lagulagune amlivalivahine?’ ");
INSERT INTO kud2014_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Hitaubwauwa hiwalo, ‘Taubada nuwanuwana, yo hauga ahu'ahubalina ta'i abo ivetamaleuyowenama’. Ta aidiyai hitalamweine. ");
INSERT INTO kud2014_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ta lagulagunane hilauvai ta hilalaweine Yeisu ainai, na adi 'wamaena dagelana hivevehene, eeta Yeisu igelu taohani, ta ilalaune. ");
INSERT INTO kud2014_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Na boda bagibagilidi hinage adi ale'owo amwahai hivehedi, na tupwadi aiwa lagalagadi malugulugudi higuladi amwaha ana yepasa vehabana. ");
INSERT INTO kud2014_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Na tupwana boda adi mugai na tupwana boda adi mulita, na maudoidi Yeisu hino'ono'owei na hiwuiwui, hiwalo, ‘Awalo vetuvehaeyego Taubada, Yaubada yehanaena ulaoma habi haguigai. ");
INSERT INTO kud2014_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Abaloina tubumaiyao Deivida ainaena imahalavauyoma. Teina vehabana Yaubada ewa'aliliyai ano'ono'owei.’ ");
INSERT INTO kud2014_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ta Yeisu bada Yelusalem ainai imahalava'o ta vada tapwalolo mwala'ina ainai iluwu, ta ginauli bahudi vada tapwalolo holanai i'i'itadine, na bada ilavilavi'o, eeta mayana taumulitao hitau 12 baidanao hiwuyo Betani ta nemai hi'e'enone. ");
INSERT INTO kud2014_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","I'ahubena na hitowolo ta Betaniyena hiwuyouyo Yelusalem vehabana, ta Yeisu ivahali, ");
INSERT INTO kud2014_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","na amwaha daodaowena aiwa ana ita dova damaya maluguna i'i'itane, eeta ilau vahalinai yo nuwanuwana ebeha ainona i'ai, na hesi i'itayawa lugu a'avana, wuwuna aiwa ai'aino howola yadi hauga. ");
INSERT INTO kud2014_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Eeta Yeisu aiwanane iwalo yagai, iwalo, ‘Havena hinage u'ai'ainouyo yo tomowa alimwena hi'ai'ai’. Ta yana walo teina ana taumulitao hibebenaleine. ");
INSERT INTO kud2014_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Haugana Yelusalem ainai hilaoma, na vada tapwalolo mwala'ina holanai iluwu, na tauvegimwalao yo taugimwalao holanaena iheusili mahalavaedi, na mane ana tausenisiwo yadi tebeli i'oibuiyedi, na gabubu adi tauvegimwala yadi abamiya hinage i'oibuiyedi. ");
INSERT INTO kud2014_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Na hinage vada holana ilaugagayowei yo havena tomowa mayadi maketi hilaulau vada holanaena. ");
INSERT INTO kud2014_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Na ive'itadi iwalo, ‘Buki Ve'ahihi ainai Yaubada yana walo hilelelene amhanapuiya'o, iwalo, “Yagu vada mata hiyogaei vada aba'awanoi tomowa maudoidi vehabadi”, na omiu am'abigwaipile yami aba'aivavali’. ");
INSERT INTO kud2014_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na taupwaoliwo mwala'idi yo loina ana tauve'itao Yeisu yana paihowa teina wasana hibenalei, na himodi'iniyei, ta hinuwanuwatuwu vedova na hi'oiye mwalowoi, na hesi nigele howahowadi wuwuna himeheuhei na hinage Yeisu yana ve'ita tomowa maudoidi nuwadi ivai. ");
INSERT INTO kud2014_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Na bada imasigili'o, ta Yeisu mayana taumulitao Yelusalem hilaugabaei, ta Betani ainai hilalaune. ");
INSERT INTO kud2014_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","I'ahubena na hitowolo habi wuyo Yelusalem, ta amwahai hilaulau, na Yeisu aiwawa iwawalo yagaiwa hi'itaya'o bada iwelai'o. ");
INSERT INTO kud2014_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Eeta Pita Yeisu yana walo yagaiwa inuwatuwui ta iwalo, ‘Taubada u'ita aiwawa uwawalo yagaiwa bada iwelai'o’. ");
INSERT INTO kud2014_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Na Yeisu aidiyai iwalo, ‘Ebe yami yemidi ammwauwi Yaubada ainai, omiu hinage paihowa wahiwahiyaladi ampaihowaidi. ");
INSERT INTO kud2014_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Hinage yawalo moiha alimiyai ebe yaiya owa nigele uyavenuwabwau na hesi uyemiyemidi yo hava uwalowei mata imahalava ta'i, ebe oya tenem uloinaei yo uwalo, “Umiyadobi uhanene ni'uwai,” yam walone i'awa abiye ta'i. ");
INSERT INTO kud2014_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","‘Eeta yawalo alimiyai ebe hava am'awanoiyei Yaubada ainai amyemidi ta'i, ta howola abo amlobai. ");
INSERT INTO kud2014_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Hinage ebe am'awanoi Yaubada ainai ami geluwo yadi pwanoliwo amnuwahamuidi ebe hava yadi mumuga alimiyai, yo teina ainaena Tamada galewai omiu hinage yami pwanoliwo inuwahamuidi.’ ");
INSERT INTO kud2014_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Hinage hiwuyoma Yelusalem, ta Yeisu vada tapwalolo mwala'ina holanai ilowolowouhi, ta taupwaoliwo mwala'idi yo loina ana tauve'itao yo hinage babadao hilaoma, ");
INSERT INTO kud2014_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ta Yeisu hipanivilaei, hiwalo, ‘Towaho, yaiya yana loinaena ta teina dova upaipaihowaine?’ ");
INSERT INTO kud2014_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Na Yeisu aidiyai iwalo, ‘Mugai yapanivila alimiyai na ebe amyemaiha, yau hinage yawalo auligomiu yagu loina vehabana. ");
INSERT INTO kud2014_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yagu panivila teina: Yaiya yana loinaena ta Yoni tau'abiye bapitaiso ipaipaihowane? Yaubada? bo nuwana ehebo tomowa?’ ");
INSERT INTO kud2014_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Na hibom aidiyai hi'awa pa'ipa'i'iuyowedi, hiwalo, ‘Yana walo vedova mata tayemaihane? Ebe tawalo, “Yaubada ainaena”, mata iwalouyoma yo iwalo, “Abo! Hava yede vehabana ta Yoni nigele amyayemidiyei?” ");
INSERT INTO kud2014_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Na ebe tawalo, “Tomowa ainaena”, mata boda hi'waunihanihaegita.’ Wuwuna tomowa bagibagilidi Yoni hiyemidiyei ebeha iya tauwalo mahalava moiha. ");
INSERT INTO kud2014_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Eeta Yeisu yana walo hiyemaiha hiwalo, ‘Nigele ayahanapui’. Yeisu hinage aidiyai iwalo, ‘Yau havena hinage alimiyai yawalowalo mahalava yaiya yana loinaena ta teina dova yapaipaihowaine’. ");
INSERT INTO kud2014_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yeisu iwalo vegevegediyedi, iwalo, ‘Ehebo towaho yana tanovi i'umai gileipa a'ava na abwalu ipaihowai, ta gileipa yana abatam ipaihowai, na vada tanovi holanai i'a'abine, eena yana taupaihowao iloinaedi ta hi'ita'ita avivini, na iya ilau'o hali tupwai. ");
INSERT INTO kud2014_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","‘Na bada ai'aino ana hauga, ta taubadanane yana hevali ehebo ivetamalei ta ebeha gileipa ainona tanovi ana tau'ita aviviniwo aidiyena ivaidima. ");
INSERT INTO kud2014_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ilaulau ta nigele hiyamohei, na hesi hi'abi avivini ta hi'aitutuwei, na nimanima a'avana hivetamalei ta iwuwuyone. ");
INSERT INTO kud2014_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","‘Taubadanane yana hevali bwauna hinage ivetamalei, ta hinage ilau aidiyai, ta hitalai vahunai, na mayana hinimaya ilalau gwaipilene. ");
INSERT INTO kud2014_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","‘Hinage tonugana ivetamalei aidiyai ta hi'oiye mwalowoi. Na hinage bagibagilidi ivetamaleidi aidiyai, ta tupwadi hitalaidi na tupwadi hi'oiye mwalowoidi, na hinage dova bagidagilidi hi'abiye yababadi. ");
INSERT INTO kud2014_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","‘Tenem ainai ehebo ta'i imiyamiya, iya natuna moiha, dova hinage ivetamalei aidiyai, yana nuwatuwu iwalo, “Iya ta'i natugu, mata hive'ahihiyei”. ");
INSERT INTO kud2014_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","‘Ta natunawa imahalava aidiyai, na tau'ita aviviniwo hibom aidiyai hiwalo, “Taubada teina natuna ilalaoma, na ebe ta'oiye mwalowoi, mata tanovi teina maudoina taloina”. ");
INSERT INTO kud2014_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Eeta hi'abi avivini ta hi'oiye mwalowoi, na tanovi ainaena higabae mahalavae.’ ");
INSERT INTO kud2014_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yeisu i'aubabada i'ovi, na ipanivila aidiyai iwalo, ‘Hava mata taubadanane ipaihowai? Moiha taubadanane mata ilaoma yo taupaihowaowa i'oiye mwalowoidi, eena tanoviwa tau'ita avivini vagadi imohedi.’ ");
INSERT INTO kud2014_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Yeisu hinage walo vegevegedi Buki Ve'ahihi ainaena iwalo mahalavaei iwalo, ‘Amnuwatuwu avivini Buki Ve'ahihi iwalo mahalava teina dova: “Logidiwa mwalona tau'abi vada hita'wata'wataeiwa, na teina hauga bada hivetowoloya'o yo ivelogidi mugai, na logidi maudoidi inamwanamwa gabaedi. ");
INSERT INTO kud2014_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Teina Yaubada yana paihowa abanuwapwanopwano alidai.” ’ ");
INSERT INTO kud2014_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yeisu yana walo vegevegedi teina taupwaoliwone mwala'idi yo Palisiwone hibenalena'o ta hihanapuiya'o ebeha hiya ta'i vehabadi i'au'aubabadane, ainaede tupwana amwa'amwaha hibehebeha yo ebeha hi'abi avivini, na hesi nigele hiya'abi avivini wuwuna himeheuhi boda aidiyai. Ta hilauvehulu ta hilalaune. ");
INSERT INTO kud2014_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Eeta tautaubadaone tupwadi Palisiwone yo hinage Helodi yana bodao hivetamaledi Yeisu ainai yo ebeha panivilaena hi'oyamaei ta yana lauhapuli hilobai. ");
INSERT INTO kud2014_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Hilaoma Yeisu ainai ta hiwalo, ‘Taubada, bada ahanapuiya'o ebeha owa tauve'ita moiha, na tomowa yadi wahiyala vehabana nigele uyameheuhi, na hesi walomoiha uwalo mahalava ehebo ehebo tomowa maudoidi aidiyai, neta Yaubada yana amwaha uve'ita moiha. ");
INSERT INTO kud2014_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Vedova, howahowana yo Wasawasa Sisa vehabana takesi tamwauwi, bo havena? Na Yeisu yadi oyama bada ihanapuiya'o, ta iwalo, ‘Hava vehabana amtowotowoigaune? Abo hola manenane amvaiyama yo ya'ita.’ ");
INSERT INTO kud2014_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Eeta mane siliba ehebo himomoheine. Na Yeisu iwalo, ‘Mane teina ainai yaiya 'alu'aluwana yo yehana?’ Na hiwalo, ‘Wasawasa Sisa’. ");
INSERT INTO kud2014_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Eeta Yeisu iwalo, ‘Ehe dova neta ebe Sisa yana paula ammohe sisa ainai, na ebe Yaubada yana paula Yaubada ammohei’. Na Yeisu yana walo teina vehabana nuwadi ipwanopwano mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Hinage Sadusiwone hilaoma Yeisu ainai, hibom nigele hiyayemidi taumwalowoi yadi towolouyo vehabana, ta hipanivila hiwalo, ");
INSERT INTO kud2014_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","‘Taubada, ada loina teina dova Mosese ileleya'o, iwalo, “Ebe ehebo towaho itawahola na nigele natuna na imwalowoi, towahonane tahina hiwapenane baidana hitawahola, na ebe waihiunane natunao ilabahidi taumwalowoiwa aivelahenao”.’ ");
INSERT INTO kud2014_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Na aba'ita himohei hiwalo, ‘Ehebo towaho matahinao himiyamiya adi bagibagili hitau 7, na adi tautuwane itawahola, na mulitai mwanenane nigele iyalabalaba na towahonane imwamwalowoine. ");
INSERT INTO kud2014_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Eena hinage tahina vahalinaena hiwapenawa itawaholai, ta hinage dova nigele iyalabalaba na imwalowoi. Hinage tahina vahalinaena hiwapenane itawaholai ta dova nigele iyalabalaba na imwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Dova bada tahinao maudoidi hiwapenane hitatawaholaine na himwamwalowoine, na nigele hinage natudiyao; na mulitai hiwapewa imwamwalowoine. ");
INSERT INTO kud2014_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Eeta towolouyo ana haugai waihiunane mata aiteya towaho mwanena moiha? Wuwuna maudoidi bada hitawaholaiya'o.’ ");
INSERT INTO kud2014_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Na Yeisu panivila teina iyemaiha, iwalo, ‘Neta yami pwanoli, wuwuna Buki Ve'ahihi nigele amyahanapui, na hinage Yaubada yana wahiyala nigele amyahanapui. ");
INSERT INTO kud2014_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Towolouyo tuluhanai tomowa nigele hiyatawatawahola, na hesi yadi miya tausagenawasaone galewai dova. ");
INSERT INTO kud2014_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mwalona Yaubada iwalo Mosese ainai towolouyo vehabana, ebe Buki Ve'ahihi amvahili am'ita lobai, hauganane Mosese balabala awawai ilaulau na Yaubada aiwa lohawahawawalina ainaena Mosese ainai iwalo, “Yau Abelaham yana Yaubada, na Aisake yana Yaubada, na Yakobo yana Yaubada”. ");
INSERT INTO kud2014_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ainaena Yaubada nigele tomowa mwalomwalowoidi yadi Yaubada, na hesi tomowa mayawahidi yadi Yaubada, na omiu hava yami ve'itaone ginauli teina vehabana nigele moihana.’ ");
INSERT INTO kud2014_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Hinage loina ana tauve'ita ehebo ilaoma, ta hiya yadi aubabada Yeisu baidadi ibenalena'o, ta yadi panivila adi maiha Yeisu ainaena ibenaledi'o hinamwanamwa alili, eeta iya hinage Yeisu ainai ipanivila, iwalo, ‘Taubada, loina maudoidi aidiyena aiteya loina mwala'ina?’ ");
INSERT INTO kud2014_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ta Yeisu iwalo, ‘Loina mwala'ina teina: “Omiu Isileliwone yagu walo teina ambenalei neta Yaubada yada Bada ehebo ta'i, ");
INSERT INTO kud2014_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ainaena ada Tauloina Yaubada uvelauwei atem maudoina ainaena na alu'aluwam maudoina ainaena na yam nuwatuwu maudoina na hinage yam wahiyala maudoina aidiyena”.’ ");
INSERT INTO kud2014_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","‘Na ehebo hinage loina mwala'ina teina, “Am geluwo uvelau aidiyai dova ubom uvelavelauyoigone”. ‘Loina bwauwone teina loina maudoidi himwala'i gabaedi.’ ");
INSERT INTO kud2014_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Loina ana tauve'itawa Yeisu yana walo ibenalena'o, ta iwalo, ‘Taubada, yam walo neta walo moiha, ebeha iya ta'i Yaubada, nigele teya Yaubada iyamiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Howahowana tavelavelau ainai ateda maudoina ainaena, na yada nuwatuwu maudoina ainaena, na yada wahiyala maudoina ainaena, na hinage ada geluwo tavelavelau aidiyai dova ita tavelavelauyoigita. Loina bwauwone mwala'idi, na hesi lagulagu bo ai'ai tapwaopwaoliyedi Yaubada ainai, hiya nigele loina mwala'ina, awa?’ ");
INSERT INTO kud2014_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Na Yeisu towahonane yana walo ibenalena'o bada moiha, ta aidiyai iwalo, ‘Neta walo moiha, na owa Yaubada yana Abaloina vahalinai umamahalava’. I'ovi na tomowaowa Yeisu higagadaei, ta nigele teya iyapanivilauyo ainai. ");
INSERT INTO kud2014_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Mulitai Yeisu vada tapwalolo mwala'ina holanai ive'ive'ita tomowa aidiyai ta iwalo, ‘Vedova ta tupwana loina ana tauve'itao hiwalo ebeha Deivida tubunao ainaena Besinana towahona ilalaoma. ");
INSERT INTO kud2014_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mwalona vehabana Alu'aluwa Ve'ahihi Deivida ive'ita, eeta Deivida Besinana i'awa Bada ainai, iwalo: “Yaubada iwalo yagu Bada ainai, ‘Nima tautuwaguwena umiya ana higa am alehao yamwau aituluwedi aem elauhanai’”. ");
INSERT INTO kud2014_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deivida iya Besinana i'awa badaei, vedova yede ta Deivida tubuna ainaena mulitai abo Besinana ilaoma?’ Na boda maudoidi Yeisu yana ve'ita nuwadi ivai. ");
INSERT INTO kud2014_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yeisu hinage aidiyai iwalo, ‘Havena loina ana tauve'itao yadi mumuga ammulimulitaei, wuwuna hiya yadi laulau ta'i nuwanuwadi yo adi ale'owo daodaodi hili'wali'wadi na tomowa ahi'ahipudiyai hita'ita'i'ili ta ebe hiwalo vetuvehaedi. ");
INSERT INTO kud2014_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Na hinage nuwanuwadi abamiya namwanamwadi vada tapwalolo aidiyai yo hinage guyau adi hauga aidiyai nuwanuwadi yo vatavatai himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Na hinage tomowa mehediyai Yaubada ainai yadi awanoi daodaodi, na hesi yadi awanoine nigele namwanamwana, wuwuna atediyai hinuwanuwatuwu vedova mata hiwahiwapewo hi'oyamaedi, yo yadi tobwatobwa hivaidi. Ainaena howola abo Yaubada maiha yababana imohedi.’ ");
INSERT INTO kud2014_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Mulitai Yeisu velau ana abamwau vahalinai imiyamiya, na wasawasao bagibagilidi yadi velau mwala'idi i'ita'itadi. ");
INSERT INTO kud2014_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Na hinage hiwape wewelohena i'i'itane yana velau toea bwau a'ava imwamwauwine. ");
INSERT INTO kud2014_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Eeta Yeisu ana taumulitao iyoga ahaidima, ta aidiyai iwalo, ‘Tenem, hiwapene yana velau maudoidi yadi velauwo imwala'i gabaedi. ");
INSERT INTO kud2014_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Wuwuna hibom yadi tupwao mwala'ina himiyamiya, na hesi hiwape tenem wewelohenane yana mane maudoina imwauwiya'o, ta nigele hinage teya yana tupwa iyamiyamiya ebe ainaena ana igimwala.’ ");
INSERT INTO kud2014_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yeisu mayana taumulitao vada tapwalolo mwala'ina ainaena himalava, na ana taumulita ehebo ipanivila, iwalo, ‘Taubada, u'ita vadao teina adi paihowa namwanamwa alili, gaima mwala'idi aidiyena hi'a'abidine’. ");
INSERT INTO kud2014_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Na Yeisu iwalo, ‘Vadaone mwala'idi u'i'itadine mata maudoidi hilo'elo'edi na nigele teya tupwa uya'itauyoi’. ");
INSERT INTO kud2014_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mulitai Yeisu ilau Olibe oyana ainai na italumiyahiwa, na ainaena vada tapwalolo Yelusalem ainai ivinuvinunui, na Pita, Yemesa, Yoni yo Andulu hilaoma ta hibom Yeisu baidadi, hiwalo auli hiwalo, ");
INSERT INTO kud2014_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","‘Taubada, uwalo auligai aiteya hauga ainai vada tapwalolo mwala'ina hilo'e na aiteya ve'ive'ilala aidiyena ahanapui ebeha ginauliwone mata himahalava?’ ");
INSERT INTO kud2014_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Eeta Yeisu i'apuhini, yo aidiyai iwalo mahalava ta iwalo, ‘Am'ita avivinigomiu, havena tomowa tupwadi hi'oya'oyamaegomiu. ");
INSERT INTO kud2014_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Wuwuna howola abo tomowa bagibagilidi yehaguwena hilalaoma na ebeha oyamaena himugaiyegomiu, ta ehebo ehebo aidiyena hiwalo, “Yau Besinananane”, na tomowa bagibagilidi himulitaedi. ");
INSERT INTO kud2014_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Hinage wasa abo ambenaledi alehao vahalimiyai na amwaha daodaowai hibom hi'ale'alehauyoidi, havena am'alu'aluvagavaiyedi. Ginauliwone teina moiha ta'i mata himahalava mugai, na hesi bale'u yana aba'ovi ana hauga howola alili. ");
INSERT INTO kud2014_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Howola abo vali boda yo vali boda hi'aleha, na hinage vali abaloina yo vali abaloina hi'aleha, na hinage mwani'ini'i hisagena tupwa bagibagilidi aidiyai, yo hinage vahali mwala'ina himahalavama. Na ginauliwo teina hauga vitaina ana abavetuwuni ta'i. ");
INSERT INTO kud2014_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","‘Na omiu hesi am'ita avivinigomiu, mata tomowa hi'abi avivinigomiu, yo hilawegomiu lauvetala vehabana, yo vada tapwalolo aidiyai abo hisapigomiu, na hinage mata tauloinao yo tauwasawasawo mehediyai hilawegomiu yo amtowolo na hilauvetalaegomiu. Wuwuna omiu ebeha yagu bodao, yo hinage wasagu aidiyai amwalo mahalavaei. ");
INSERT INTO kud2014_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mata wasa namwanamwana hiwalo mahalava mugaiyei tupwa maudoina aidiyai, na mulitai abo hauga yana aba'ovi. ");
INSERT INTO kud2014_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","‘Na ebe tauloinao mehediyai hivetowologomiu habi lauvetala havena am'alu'aluwagavai vedova mata am'aubabadane, na hesi mayami atepatu am'aubabada ta'i, wuwuna nigele ebeha omiu yami walo am'aubabadaei, na hesi Alu'aluwa Ve'ahihi hauga tenem ainai walo imohegomiu, yo am'aubabada. ");
INSERT INTO kud2014_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","‘Na hinage hauga hilalaoma aidiyai tomowa yadi huhu holanai aleha himahalava vehabagu, neta towaho tahina ihuhulaei yo hiyemwalowoi. Yo hinage dova tama natuna ihuhulaei yo hiyemwalowoi. Yo hinage hedaheda hinadiyao yo tamadiyao hihuhulaedi yo hiyemwalowoidi. ");
INSERT INTO kud2014_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yo tomowa maudoidi hive'alehaegomiu wuwuna omiu ebeha agu tauyemidiwo. Na hesi yaiyadiwo omiu vehabagu am'alama'i'ita ana higa hauga yana aba'ovi ainai, mata omiu ta'i awanamwanamwa amlobai. ");
INSERT INTO kud2014_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","‘Howola abo omiu am'ita tomowa vagadiyao ginauli yababana na didigana moiha hivetowolodi tupwa ve'ave'ahihina ainai (ebe yaiya walo teina ivahili ihanapui), hauga tenem ainai Yudeya ana taumiyaone howahowana ebe hidena oyai. ");
INSERT INTO kud2014_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Na ebe yaiya vatavatai imiyamiya, howahowana idena mwayamwayau, na havena iluwuluwuyo yana vadai yana tobwatobwa habi avalaidi. ");
INSERT INTO kud2014_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yo ebe yaiya tanoviyai ipaipaihowa, havena iwuyowuyo ana ale'owa ilaugabaeiwa vehabana. ");
INSERT INTO kud2014_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","‘Hauga tenem ainai tauhiumao yo tauvehuhuwo mata hive'atemuyamuya. ");
INSERT INTO kud2014_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Eeta maudoimiu am'awa'awanoi yo hauga namwanamwana Yaubada imohegomiu yami hauga dena ainai, na havena gwaugwau ana haugai. ");
INSERT INTO kud2014_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","‘Ehe, hauga tenem ivitai ali'alili, wuwuna hauganane Yaubada bale'u ivetuwuni ainaena ta wau nigele teya hinage vitai tenem dova iyamahalava, na hauga hilalaoma aidiyai mata nigele teya vitai teina dova hiyamahalavauyo. ");
INSERT INTO kud2014_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Vitai tenem ana ahubenao ebe nigele Yaubada iya'abiye ahubalidi, mata tomowa maudoidi himwalowoi, na hesi Yaubada ahubenadine i'abiye ahubalidiya'o, neta iya yana tomowa ve'ave'ahadi vehabadi. ");
INSERT INTO kud2014_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","‘Tenem haugana ainai ebe yaiya alimiyai iwalo, “Besinana teina”, na “tenem”, havena amyemiyemidiyei. ");
INSERT INTO kud2014_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Wuwuna Besinana oya'oyama yo tauwalo mahalava oya'oyama mata himahalava yo ve'ive'ilala wahiwahiyaladi tomowa aidiyai hive'itaedi, yo aidiyena ebe howahowana Yaubada yana bodao ve'ave'ahadi hi'oyamaedi. ");
INSERT INTO kud2014_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Na omiu hesi am'ita avivinigomiu, wuwuna ginauliwone teina vehabadi bada yawalo mahalava mugaiyedi'o alimiyai. ");
INSERT INTO kud2014_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","‘Hauga vitaiwa i'ovi na mulitai mahana iguguyou, yo hinage wai'ena yana masele iboho, ");
INSERT INTO kud2014_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","na utui galewaena hibe'uma yo ginauli maudoidi galewai himiyamiya yadi wahiyala hitapiya. ");
INSERT INTO kud2014_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","‘Hauga tenem ainai taumiya bale'uwone maudoidi yau Tomowa Moihagu hi'itagau yaloyalovi aidiyena ya'ai'aituluma mayagu loina wahiwahiyalana yo mayagu wasawasa pigapigabuna, ");
INSERT INTO kud2014_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","eeta yagu tausagenawasaone yavetamaledi yo yagu boda ve'ave'ahadi hitau'ahaidima bale'u yo galewa yo yaumai maudoidi yadi abalaoma aidiyena. ");
INSERT INTO kud2014_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","‘Aba'ita hapelo ainaena yave'itagomiu. Ebe hapelo lugudi vauvaudi imwaumwauwidi amhanapuiya'o ebeha ehive ana hauga vahalinai. ");
INSERT INTO kud2014_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ta hinage ve'ive'ilalaowa alimiyai bada yawalo mahalavaedi'o, ebe aiteya hauga amlobaidi amhanapuiya'o ebeha yagu hauga wuyoma imamahalava. ");
INSERT INTO kud2014_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yawalo moiha alimiyai, yaso teina mata nigele amya'ovi ana higa ginauliwone maudoidi himahalava. ");
INSERT INTO kud2014_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","‘Howola abo galewa yo bale'u hisawali, na yagu walowone nigele howahowana hisawali. ");
INSERT INTO kud2014_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","‘Nigele teya yaiya iyahanapui aiteya hauga nuwana ahubena ainai yawuyouyoma, na hinage tausagenawasaone galewai nigele hiyahanapui. Yau hinage nigele yayahanapui. Na hesi Tamagu ibom ta'i ihanahanapui. ");
INSERT INTO kud2014_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Eeta am'ita avivini wuwuna yagu hauga wuyouyoma nigele amyahanapui.’ ");
INSERT INTO kud2014_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Aba'ita hinage Yeisu imohedi iwalo, ‘Ebe ehebo taubada yana vada habi laugabaina yo ilalau vali tupwai. Mulitai abo ilau, yana taupaihowao ehebo ehebo yadi paihowa imohedi, na iloinaedi yo ebeha yana vada hi'ita avivini, na hinage vada ana awa'eda ana tau'ita avivini ainai iwalo, “Havena u'eno'eno, na hesi u'ita'ita avivini ili'ilimani”. ");
INSERT INTO kud2014_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Eeta howahowana am'ita'ita avivini yo amha'waha'waigau, wuwuna dova vada taniwagana yana laoma ana hauga nigele amyahanapui, nuwana lavilaviyai, nuwana boniyaiyena, nuwana i'ahu'ahubena, nuwana malatomtomwena. ");
INSERT INTO kud2014_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Havena am'eno'eno, mata dova ta yamahalavama na yave'aluwa gavaigomiu. ");
INSERT INTO kud2014_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","‘Yagu loina teina omiu alimiyai na tomowa maudoina aidiyai, am'ita avivini ili'ilimani.’ ");
INSERT INTO kud2014_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Buidi'wa guyauna ana abanuwatuwu avivini ebe imahalava, ahubena bwau tuluhadiyai. Guyaunane ainai pwalawa a'ava, nigele ana abiye seseha hi'ai'ai. Na taupwaoliwo mwala'idi yo loina ana tauve'itao hinuwanuwatuwu behabeha vedova Yeisu ebe hi'oyamaei yo ebeha hi'abi avivini na hi'oiye mwalowoi, ");
INSERT INTO kud2014_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","na hiwalo, ‘Havena guyaune holanai Yeisu ta'abi'abi avivini, mata dova ta tomowa himanini alidai na hi'alehaegita’. ");
INSERT INTO kud2014_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yeisu howola Betani ainai imiyamiya Saimoni yana vadai, iya mwalona taulepelo ehebo. Na hauganane ainai Saimoni yana vadai i'ai'ai, eena waihiu ehebo mayana woloi iluwu, ta woloinane yehana nadi, ana maiha mwala'ina, na ana gaimapatu namwanamwana moiha, na waihiunane gaimapatu awana i'oiwowoli na woloinane Yeisu vahunai ihihiwaine. ");
INSERT INTO kud2014_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Na tupwana tomowa hi'i'itane, ta waihiune hi'ulumiyanei, hiwalo, ‘Hava vehabana woloine iyepaipaiheine? ");
INSERT INTO kud2014_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Howahowana ebe woloinane ivegimwalaei na ana maiha 300 kina dova ivai, na imohedi wewelohe aidiyai.’ Eeta waihiunane hiwawaloweine. ");
INSERT INTO kud2014_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Na Yeisu iwalo aidiyai, iwalo, ‘Badagi, amlaumwau. Havena waihiune am'abi'abiye dou, wuwuna yana hagu aliguwai inamwanamwa alili. ");
INSERT INTO kud2014_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Wewelohewone amwalowalowedine hauga maudoina vahalimiyai himiyamiyane, yo ebe nuwanuwamiu aiteya hauga na amhaguidi, amhaguidi ta'i. Na yau hesi nigele mata hauga daodaona baidamiu tayamiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Na waihiu teina hava dova ipapaihowaine aliguwai, neta taugu ivewoloi mugaiyei habi atububunigau agu mwau magaiyai vehabana. ");
INSERT INTO kud2014_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na yawalo moiha, howola abo wasagu ana guguya tomowa hibenalei bale'u maudoina ainai, na hinage waihiu teina yana paihowa aliguwai wasana hi'aubabadaei.’ ");
INSERT INTO kud2014_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yeisu ana taumulita ehebo hitau 12 aidiyena iya Yudasa Isakaliyota, ilau taupwaoli mwala'idi aidiyai na nuwanuwana na Yeisu aidiyai ihuhulaei. ");
INSERT INTO kud2014_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Na Yudasa yana walo hibenalena'o, ta hiyaliyaya na ainai hiwalo yemidi yo ebe ana maiha himohei. Eeta Yudasa hauga namwanamwana iha'waha'wai, ta ebe Yeisu ihuhulaei aidiyai na hi'abi avivini. ");
INSERT INTO kud2014_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Buidi'wa guyauna holanai pwalawa a'avana nigele ana aba'abiye seseha hi'ai'ai, na guyaunane ana ahubena mugamugaina ainai, lamiwo hiwunuidi, Buidi'wa ana abanuwatuwu abivini vehabana. Na ahubenanane ainai Yeisu ana taumulitao hiwalo auline, hiwalo, ‘Taubada, havaidova ainai nuwanuwam yo Buidi'wa guyauna vehabana a'atububuni?’ ");
INSERT INTO kud2014_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Eeta ana taumulitao bwau ivetamaledi na iwalo aidiyai, ‘Amlau Yelusalem yo ebe towaho ehebo mayana abagoi we'aha i'ava'avalai amlobai towahonane tuluhanaena amlau, ");
INSERT INTO kud2014_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","yo baidamiu amluwu vadai, na vada taniwagana amwalo ainai, amwalo, “Yama tauve'ita teina dova iwawalone: Aiteya tupwa utalamwei yo ainai ma'agu taumulitao Buidi'wa ai'aina a'ai?” ");
INSERT INTO kud2014_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ta mata tupwa atu'atububunina ewai ive'itagomiu, na tenem ainai Buidi'wa ai'aina am'atububuni vehabada.’ ");
INSERT INTO kud2014_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Eeta taumulitaone hilau dalava Yelusalem ainai, na hava Yeisu dova ginauli iwawalowediwa maudoidi hilobaidi, na vadanane ainai Buidi'wa ai'aina hi'a'atububunine vehabadi. ");
INSERT INTO kud2014_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Na lavilaviyena Yeisu mayana taumulitao hilaoma, ");
INSERT INTO kud2014_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","na hitau 12 himiya habi ai, na yadi aine holanai Yeisu iwalo aidiyai, ‘Augeluwo, yawalo moiha neta ehebo towaho, teina ta'i baidada ta'ai'aine, mata iya muhamuhana ihuhulaegau’. ");
INSERT INTO kud2014_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Na Yeisu yana walo teina vehabana hinuwavitai na ehebo ehebo Yeisu ainai hiwalo, ‘Taubada yaiya neta? Nuwana yau?’ ");
INSERT INTO kud2014_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Na Yeisu iwalo, ‘Agu tauhuhulane omiu amtau 12 alimiyena, na iya baidagu gaeba ehebo ainaena a'ai'ai. ");
INSERT INTO kud2014_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Yau Tomowa Moihagu, howola abo yalau amwahanane mugai Buki Ve'ahihi ainai iwalo mahalavaina'o, na hesi agu tauhuhulane ive'atemuyamuya ta'i, inamwanamwa ebe mwalona hinana havena ilabalabahi, wuwuna yana tubui ainaena ive'atemuyamuya yana paihowa yababana vehabana.’ ");
INSERT INTO kud2014_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Howola hi'ai'ai, na Yeisu ai'ai ivai, na vehabana i'awa yauwedo, ta itomwahi na imomohedine, iwalo, ‘Teina taugu amvai na am'ai’. ");
INSERT INTO kud2014_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Na hinage waini mavedina ivai, ta vehabana i'awa yauwedo Yaubada ainai, na hinage imomohedine, ta maudoidi hinunumane. ");
INSERT INTO kud2014_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Na hinage iwalo aidiyai, ‘Teina 'wahinagu isagesagena tomowa bagibagilidi vehabadi, neta waloyemidi vauvauna. ");
INSERT INTO kud2014_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Na yawalo alimiyai hauga teina yo tuluhanai waini teina havena ainaena yanumanumauyo na ana higa waini vauvauna yanuma Yaubada yana tupwai.’ ");
INSERT INTO kud2014_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Eeta wali ehebo hiwaliyei i'ovi na himahalava ta hihae oya Olive ainai. ");
INSERT INTO kud2014_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yeisu iwalo aidiyai, ‘Mata maudoimiu amdena vehulugau, dova Buki Ve'ahihi yana walomahalava, iwalo, “Tau'ita'ita sipi ya'oiye mwalowoi, na sipiwone hitaubudebudeyanaedi”. ");
INSERT INTO kud2014_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Na yagu towolouyo tuluhanai Galili ainai yalau, na omiu tuluhaguwena abo amlaowa.’ ");
INSERT INTO kud2014_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Na Pita iwalo, ‘Mata maudoidi hitauvehulugo, na yabom baidam’. ");
INSERT INTO kud2014_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Na Yeisu Pita iwalo ainai, ‘Yawalo moiha, mata masigiliyena mulitai abo am'am idou mai bwau, owa mata uuvalaegau mai tonuga’. ");
INSERT INTO kud2014_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Na Pita mayana walo wahiyala iwalo, ‘Taubada, mata nigele yayauvalaego. Ebe hi'oiye mwalowoigo yau hinage baidam hi'oiye mwalowoigita’. Taumulitao maudoidi dova hiwawalone. ");
INSERT INTO kud2014_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mulitai hilalaune ehebo tupwa ainai, yehana Getesemani, na ana taumulitao aidiyai iwalo, ‘Teina ainai ammiyamiya, na yau ya'awanoi Yaubada ainai’. ");
INSERT INTO kud2014_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Na hitau tonuga baidanao ilalauvaidine, hiya Pita yo Yemesa yo Yoni, na Yeisu mayana atehawawali na mayana nuwavitai, ");
INSERT INTO kud2014_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","iwalo aulidi iwalo, ‘Ategu imuyamuya mwala'ina, nuwana mata yamwalowoi, eeta teinai amha'waha'wa na am'ita'ita auhi.’ ");
INSERT INTO kud2014_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Na Yeisu iwutuhae tupwana, na ibe'u aitulu ta i'awa'awanoi ebe howahowana muya teina Yaubada ivaivehulu, ");
INSERT INTO kud2014_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","iwalo, ‘Tamagu, paihowa maudoina howahowam, nuwanuwagu yo muya vedina teina aliguwena uvaivehulu, na havena yau yagu nuwatuwuwena, na owa hesi yam nuwatuwuwena upaihowai’. ");
INSERT INTO kud2014_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Hauganane ilau gwaipile hitau tonugaowa ilobaidi bada hi'eno i'iwahi'o, na Pita ainai iwalo, ‘Saimoni, vedova ta u'eno'enone. Nigele howahowana na hauga ahu'ahubalina ainai u'ita'ita auhi awa?’ ");
INSERT INTO kud2014_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Na hinage iwalo maudoidi aidiyai, ‘Howahowana ebe mehemiu hihilahilawa na am'awa'awanoi, ta ebe havena Tomodulele itowotowoigomiu. Moiha ta'i, alu'aluwamiu nuwanuwana, na hesi taumiu hitapiya’. ");
INSERT INTO kud2014_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Na Yeisu iheuyo ta yana awanoiwa ibwabwauwine. ");
INSERT INTO kud2014_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Haugana Yeisu ilau gwaipile ana taumulitao aidiyai, hinage ilobaidi hi'eno i'iwahi'o, wuwuna mehedi bada i'eno'eno alili, eeta ivanoidi, ta hitowolo mayadi hinimaya, na nigele hava hiyawalowei. ");
INSERT INTO kud2014_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Na Yeisu hinage iheuyo ta i'awanoi, na yana wuyoma tonugana ainai ilobaidi hi'eno i'iwahi'o ta iwalo aulidi, ‘Vedova howola am'eno'eno na am'ai'aiyawasi, awa? Na am'ita yau Tomowa Moihagu yagu hauga huhula tauyababao aidiyai bada imahalava'o. ");
INSERT INTO kud2014_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Amtowolo na talau, wuwuna agu tauhuhulawa bada teina ilalaoma.’ ");
INSERT INTO kud2014_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yeisu howola i'au'aubabada na Yudasa imamahalavane, (iya Yeisu ehebo ana taumulita hitau 12 aidiyena). Na taupwaoliwo mwala'idi yo loina ana tauve'itao yo babadao tau'alehao hivetamaledi Yudasa baidadi ta ebe Yeisu hi'abi avivini, na tau'alehaone mayadi elepa ale'aleha yo wepwasiwo hilalaomane. ");
INSERT INTO kud2014_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na Yudasa bada ve'ive'ilala imohedi'o, iwalo, ‘Ebe yaiya ya'atuhapwali neta Yeisu, na am'abi avivini na am'ita avivini yo talawei’. ");
INSERT INTO kud2014_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Eeta Yudasa ilaoma Yeisu ainai na iwalo, ‘Bada’, na i'a'atuhapwaline. ");
INSERT INTO kud2014_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ta tau'alehauwa hilaoma na Yeisu hi'a'abi avivinine. ");
INSERT INTO kud2014_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Na ehebo aidiyena Yeisu vahalinai itowotowolo yana elepa ale'aleha iniuli wunihi, ta taupwaoli mwala'ina yana taupaihowa talinana itom vehulune. ");
INSERT INTO kud2014_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Na Yeisu iwalo aulidi, iwalo, ‘Vedova yau yami tau'aivavali, ta mayami elepa ale'aleha yo mayami wepasi amlalaomane habi abimomohigau? ");
INSERT INTO kud2014_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Hava wuwuna ta nigele amya'abi avivinigaune ahubena maudoina ahi'ahipumiyai yamiyamiya vada tapwalolo ainai yave'ive'ita tomowa aidiyai? Eeta ginauli teina himahalava'o na ebe Buki Ve'ahihi yana walomahalava iyemala moiha.’ ");
INSERT INTO kud2014_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hauganane ainai Yeisu ana taumulitao maudoidi hidena vehulu. ");
INSERT INTO kud2014_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Na ehebo towaho hevahevalina ma'ana ale'o daodaona ibom Yeisu imumulitaeine, na tau'alehao nuwanuwadi hi'abi avivini, ");
INSERT INTO kud2014_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","na hi'abihapuli ta ana luwuluwu a'ava hivai na mabugebugewana idedenane. ");
INSERT INTO kud2014_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yeisu hilauvai ta hilawei taupwaoliwo yadi tauloina yana vadai, vadanane ainai taupwaoli mwala'idi yo babadao, yo loina ana tauve'itao hitautau'ahaiyama. ");
INSERT INTO kud2014_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Hinage Pita amwaha daodaowena Yeisu imumulitaeine, ta ilaoma taupwaoli mwala'inawa yana dalavai. Ta Pita tau'ita aviviniwowa baidanao himiyamiya aiwa ainai himwaimwaibwa. ");
INSERT INTO kud2014_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na taupwaoli mwala'idi yo tau'ulewahiwo nuwanuwadi Yeisu ana tauve'ewao hibehaedi ta yadi ve'ewa ainaena Yeisu hi'oiye mwalowoi, na nigele teya hiyalobai. ");
INSERT INTO kud2014_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Wuwuna tauve'ewa bagibagilidi hiwalowalo mahalava na hesi yadi walomahalavane nigele hiyatoyatoyawa. Hiya maudoidi bada tau'oyamao. ");
INSERT INTO kud2014_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Na tupwadi hitowolo ta Yeisu hive'ewa oya'oyamaei, hiwalo, ");
INSERT INTO kud2014_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","‘Yeisu yana walo ehebo abebenaleine iwalo, “Vada tapwalolo teina tomowa hi'a'abine, howola mata yalo'evehulu na ahubena tonuga aidiyai ya'abiuyoi, na hesi nigele tomowa nimadiyena”.’ ");
INSERT INTO kud2014_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Na yadi ve'ewao ginauli teina vehabana, nigele hiyatoyatoyawa. ");
INSERT INTO kud2014_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Teina ainaena taupwaoli mwala'ina itowolo mehediyai, na Yeisu ipanivilaei iwalo, ‘Nigele teya yam maiha awa? tomowa tenem yadi ve'ewao alimwai bada ubenaledi'o?’ ");
INSERT INTO kud2014_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Na Yeisu bada inobu, nigele iyawalo. Na hinage taupwaoli mwala'inawa Yeisu ainai ipanivilauyo, iwalo, ‘Vedova, owa Yaubada Natuna yo Besinana towahona, bo nigele?’ ");
INSERT INTO kud2014_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Na Yeisu iwalo, ‘Ehe, yau Tomowa Moihagu, na howola abo am'itagau Tauwahiyala moiha nima tautuwanai yamiyamiya, na hinage galewa yaloyalovinao ewadiyena yalaolaoma’. ");
INSERT INTO kud2014_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Eeta taupwaoli mwala'inawa imodi'ini moiha, ta ibom ana ale'o ipupulihine, na iwalo, ‘Yana walo yababana ambenalena'o? Moiha towaho teina Yaubada ihinali. Badagi, havena ana tauve'ewao hinage hiwalowalo yana lauhapuliwo vehabadi. Na vedova yami nuwatuwu Yeisu vehabana?’ Maudoidi hiwalo, ‘Ilowoinanei na imwalowoi’. ");
INSERT INTO kud2014_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tenem ainai tupwadi tomowa Yeisu hihowai, na mehena ale'owena hihuma na hisapi mayadi talawahi, hiwalo, ‘Uwalo yaiya itatalaigone?’ Na tau'alehaone Yeisu hi'abi avivini ta hitalatalai na hilawelawei. ");
INSERT INTO kud2014_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Na Pita howola gelegeleyai imiyamiya, na taupwaoli mwala'ina yana taupaihowa vahavahalana ehebo imamahalavane, ");
INSERT INTO kud2014_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ta Pita i'ita imwaimwaibwa, eeta waihiune Pita ivinuvinunui ta iwalo, ‘Yeisu towaho Nasaleti, owa baidam ammiyamiya, awa?’ ");
INSERT INTO kud2014_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Na Pita iuvala iwalo, ‘Ginauline uwawaloweine nigele yayahanapui’. Na Pita idena ta tupwana imahalava. ");
INSERT INTO kud2014_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Na vahalawa Pita i'ainimaveleleyei taumiyaone aidiyai, iwalo, ‘Towahone tenem iya Yeisu yana boda ehebo’. ");
INSERT INTO kud2014_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Na Pita ibenalei ta iuvalauyo iwalo, ‘Yau nigele’. Hauga ubwa'ubwana tuluhanai tauvinunuwone Pita hiwawalo auline, hiwalo, ‘Moiha ta'i u'oyama, owa Yeisu yana boda ehebo, wuwuna owa towaho Galili’. ");
INSERT INTO kud2014_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Na Pita i'awa tamada, na walo yababana ainaena iyogahae iwalo, ‘Yeisu iya vehabana amwalowalo, yau nigele yayahanapui, Tamada!’ ");
INSERT INTO kud2014_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Na hauga tenem ainai am'am idou bwauna, na Pita inuwatuwu avivini Yeisu yana walowa ebeha, ‘Mulitai abo am'am idou mai bwau, owa mata uuvalaegau mai tonuga’. Na hinage Pita yana oyama yababanawa inuwatuwui, ta mehelinona hisagena. ");
INSERT INTO kud2014_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","I'ahu'ahubena na taupwaoliwo mwala'idi yo tau'ulewahiwo yo loina adi tauve'itao yo tauloinao maudoidi hitau'ahaiyama ta hiloiloina Yeisu vehabana, na nimana hipaidi ta hilalaweine tauloinane Pailato ainai, ta ebeha Pailato iya iloina. ");
INSERT INTO kud2014_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Na Pailato Yeisu ipanivilaei, iwalo, ‘Uwalo mahalava owa Yudeya yadi tauwasawasa?’ Na Yeisu iwalo ‘Neta bada uwalo'o’. ");
INSERT INTO kud2014_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ta taupwaoli mwala'idiwa ginauli bagibagilidi vehabadi Yeisu hiveve'ewaine. ");
INSERT INTO kud2014_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Eeta Pailato Yeisu ipanivilauyoi, iwalo, ‘Vedova ta nigele yam maihane? Walo mahalava teina, am ve'ewa vehabana ubenalena'o?’ ");
INSERT INTO kud2014_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Na Yeisu nigele teya hinage yana walo. Ainaena Pailato nuwana ipwanopwano mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bolimai ehebo ehebo, Buidi'wa guyauna ana hauga ainai, loina himwauwi neta vada paipaiyena ehebo tomowa ilivahi vehabadi na imahalava, ebe iya boda hivesinuwaei. ");
INSERT INTO kud2014_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Hauga tenem ainai tupwadi Loma adi tau'alehao vada paipaiyai himiyamiya, wuwuna nigele nuwadi Loma yadi loina, ta hi'alehaidi, na ehebo yehana Balabasi alehane holanai tomowa i'oiye mwalowoidi. Eeta Lomaone Balabasi ma'ana geluwo hi'abi avivinidi ta vada paipaiyai himwamwauwidine. ");
INSERT INTO kud2014_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ta boda hitau'ahaiyama, na hi'awanoi Pailato ainai, hiwalo, ‘Howahowana yo ehebo towaho ulivahi vahabamai, dova yama awanoi upaipaihowai bolimai ehebo ehebo aidiyai?’ ");
INSERT INTO kud2014_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Na Pailato iwalo aulidi, ‘Nuwanuwamiu ebe Yudeyaone yami tauwasawasa yalivahi vehabamiu, awa?’ ");
INSERT INTO kud2014_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Wuwuna Pailato ihanapuiya'o ebeha taupwaoli mwala'idi yadi alomagigiliyena Yeisu hilauvaiyama habi oiyemwalowoina. ");
INSERT INTO kud2014_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Na hesi taupwaoli mwala'idi bada tomowa nuwatuwu yababadi hivenuwamwauwedi'o aidiyai, ainaena Yeisu hita'wata'wataei na Balabasi hesi yehana hi'ata'atai na ebe ilivahi vehabadi. ");
INSERT INTO kud2014_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Na Pailato iwalo aulidi iwalo, ‘Hava nuwanuwamiu ebeha omiu Yudeya yami tauwasawasa ainai yapaihowai?’ ");
INSERT INTO kud2014_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Na hilohagali, hiwalo, ‘Aiwa lagalagana ainai tatutuye patu!’ ");
INSERT INTO kud2014_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Na Pailato iwalo, ‘Hava yede yana pwanoli ta ebe mwalowo ilobai?’ Na hiyoga mwalamwala'i, hiwalo, ‘Aiwa lagalagana ainai tatutuye patu’. ");
INSERT INTO kud2014_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Eeta Pailato nuwanuwana yo boda i'abiye yaliyayadi ta Balabasi ilivahi, na yana tau'alehao iloinaedi yo Yeisu balavaiyena hisapi na mulitai abo hitutuye patu aiwa lagalagana ainai. ");
INSERT INTO kud2014_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pailato yana tau'alehao Yeisu hisapi na hilauvai ta yana vadai hiluluwuweine, neta tau'alehao yadi tupwa mwala'ina vada holanai, na tau'alehao yadi boda maudoidi hiyoga ahaidima. ");
INSERT INTO kud2014_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Na wasawasao adi ale'o hawahawawalina ainaena Yeisu hiveveli'wane na ana pwaopwaomi talitali ainaena hi'abilawei ta ulu'ulunai himwamwauwine. ");
INSERT INTO kud2014_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Na hi'abi'abitalawahiyei hiwalo, ‘Yauwedo, owa Yudeya yadi tauwasawasa!’ ");
INSERT INTO kud2014_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Na hinage digona ainaena Yeisu vahunai higoha, na hihowahowai, na talawahiyena mehenai hipwagogo. ");
INSERT INTO kud2014_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Na yadi talawahi i'ovi, ta ale'o wasawasa ainaena hilivahi, na ibom ana ale'owa hiveli'wauyoi, na himahalavaei habi tutuye patuna. ");
INSERT INTO kud2014_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Dalava mwala'ina ainaena himahalava, ta ehebo Sailini towahona nu'ulaena ilaolaoma hilobai, ta hiloinaei na Yeisu ana aiwa lagalagana i'avalai, towahonane yehana Saimoni, na iya Alekisana yo Luposi tamadi. ");
INSERT INTO kud2014_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yeisu hilalaweine tupwa Goligota ainai (Goligota ana hanapu neta Ulu'ulu dalavana). ");
INSERT INTO kud2014_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Na mulamula himomoheine, neta waini mulo baidana yo ebe havena muya ilaulautowoi mwala'ina, na Yeisu ita'wata'wataei. ");
INSERT INTO kud2014_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Eeta aiwa lagalagana bale'uwai himwauwi na Yeisu ainai hitutuye patune, na ma'ana aiwa lagalagana hivetowolone. Mulitai tau'alehaowa Yeisu ana ale'o hivaidi, ta hiveguyauwedi hibom aidiyai, na yadi veguyau dova kati ana ai'opi'opi ainaena, ta ebe yaiya imugai ana ale'o ehebo ivai. ");
INSERT INTO kud2014_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Haugana Yeisu hitutuye patu neta malatomtom ana ahi'ahipu ainai. ");
INSERT INTO kud2014_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Na ana aiwa lagalagana ainai hilelelene, ‘Yudeya yadi tauwasawasa’. Neta yana mwalowoi wuwuna. ");
INSERT INTO kud2014_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Na hinage tau'aivavali bwau hitutuye patudi adi aiwa lagalagao aidiyai ehebo Yeisu nimatautuwanaena na ehebo nima'eha'ehanaena. ");
INSERT INTO kud2014_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na tomowa tupwadi amwahaena Yeisu aiwa lagalagana ainai hi'abitalawahiyei, na himalumaluwei hiwalo, ‘Aha! Uwalo ebeha howahowam vada tapwalolo ulo'e, na ahubena tonuga aidiyai u'abiuyoi. ");
INSERT INTO kud2014_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Hola uhaguiyoigo na aiwa lagalaganaena u'aituluma.’ ");
INSERT INTO kud2014_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Na hinage taupwaoli mwala'idi yo loina ana tauve'itao hibom aidiyai hiwalowalo gagasa, na Yeisu hitalawahiyei hiwalo, ‘Vali tomowa ihaguidi, na iya nigele! ");
INSERT INTO kud2014_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ibom ebeha Besinana na Isileli ana tauwasawasa, hola aiwa lagalagaena i'aituluma na ta'ita yo tayemidiyei.’ Na tau'aivavaliwowa Yeisu baidadi hitutuye patudiwa hinage yadi aiwa lagalagaena hiyogalau na Yeisu hiwalo yagai. ");
INSERT INTO kud2014_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mahana ala'alapwahiyai, tupwa maudoina iguguyou ta ana higa lavilaviyai. ");
INSERT INTO kud2014_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Na lavilaviyai Yeisu alinana mwala'ina ainaena iyoga, na iwalo, ‘Eloi, eloi lama sabakitani’, na ana bui neta, ‘Yagu Yaubada, yagu Yaubada, hava vehabana ulaugabaigaune?’ ");
INSERT INTO kud2014_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Na tupwadi tomowa vahalinai hitowotowolo yana yoga hibenalei, ta hiwalo, ‘Ambenalei Elaitiya iyogayogaeine’. ");
INSERT INTO kud2014_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Eena ehebo aidiyena isagena, ta balou ivai, na waini abe'abelena ainai iveda'wa, na ehebo aiwa mehenai iwomali, ta iveleleihini Yeisu awanai, ta imala'u'uine. Na towahonane iwalo, ‘Hola taha'waha'wa, nuwana mata Elaitiya ilaoma na aiwa lagalagaena ihagui’. ");
INSERT INTO kud2014_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Na Yeisu iyoga mwala'ina, ta yawahina i'o'ovine. ");
INSERT INTO kud2014_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Na ale'owa vada tapwalolo ana biliwutuhi ilotapulihi bwau, ewanaena ta idobi duyanai. ");
INSERT INTO kud2014_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na tau'aleha adi taumugai aiwa lagalagana mehenai itowotowolo Yeisu yana mwalowoi ana ita teina dova i'i'itane, ta iwalo, ‘Moiha towaho teina Yaubada Natuna’. ");
INSERT INTO kud2014_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tupwadi waiwaihiu amwaha daodaowena hivinuvinunu, neta Meli Magidalaena mayana waligeha, iya Yosa yo tahina alomauna Yemesa hinadi, yo Salome hinage. ");
INSERT INTO kud2014_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Hiya mwalona Yeisu himulitaei na ana hipapaihowaine yana ta'i'ili Galili ainai, na tupwadi waiwaihiu hinage Galiliyena Yeisu baidanao hihaema Yelusalem ainai, maudoidi hivinuvinunui. ");
INSERT INTO kud2014_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Bada lavilavi'o na hi'atububuni vali ahubena vehabana, neta Yudeyao yadi Tapwalolo. ");
INSERT INTO kud2014_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Eeta ehebo towaho Alimatiyaena, yehana Yosepa ilaoma, iya ehebo Yudeyaone yadi taumugai mayana yemidi, na iha'waha'wa aiteya hauga Yaubada bale'uwai ivetauloina. Yosepawa ilaoma na mayana atepatu iluwu Pailato mehenai, na Yeisu tauna mwalomwalowoina i'awanoiyei yo ebe imwauwi magaiyai. ");
INSERT INTO kud2014_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailato i'aluwagavai, iwalo, ‘Ae! Yeisu bada imwalowoi'o?’ ");
INSERT INTO kud2014_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Na towahonane iwalo, ‘Oo, bada imwalowoi'o’. Eeta Pailato italam yo Yosepa Yeisu tauna mwalomwalowoina ivavaine. ");
INSERT INTO kud2014_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Na Yosepa ale'o hewahewana igimwalai, na ivai, ta mayana taumulitao Yeisu tauna mwalomwalowoina aiwa lagalagana ainaena hivai'aituluwenama, na ale'onane ainaena hihuhumane, na mulitai abo magai ainai himwamwauwine. Na magainane dova duluva gaima holana yatuyatu nonovaina, na gaima mwala'ina na po'upo'uwana ainaena magai awana himwau'auhine. ");
INSERT INTO kud2014_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Na Meli Magidalaena yo mayana waligeha, iya Yosa hinana, baidana hi'ita'ita sipwaidi, na magaine ainai tauna mwalomwalowoina himwauwine hi'i'itane. ");
INSERT INTO kud2014_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Yudeya yadi Tapwalolo ana ahubena i'ovi, ta Meli Magidalaena mayana waligeha, iya Yemesa hinana, yo Salome baidadi woloi namwanamwana higimwalai ta ebe Yeisu tauna hiyewoloi. ");
INSERT INTO kud2014_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Eeta malatomtomwai, neta wiki ana ahubena mugamugaina ainai, na mahana yana hinali taohani ainai, waiwaihiuwone mayadi woloi hilaoma Yeisu ana magai ainai. ");
INSERT INTO kud2014_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Na hibom aidiyai hi'au'aubabada, hiwalo, ‘Yaiya mata gaimane magai awanaena hive'i wahiyei vehabada?’ Wuwuna gaimanane ivitai alili. ");
INSERT INTO kud2014_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Na hi'ita hae magaiwa ana gudu gaimawa bada awanaena hive'i wahiyena'o. ");
INSERT INTO kud2014_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Waiwaihiuwone magaiyai hiluwu, na nimatautuwadiyena hevali ehebo hi'i'itane, ana ale'o hewahewana imiyamiya, ta hi'aluwagavai. ");
INSERT INTO kud2014_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Na hevaliwa aidiyai iwalo, ‘Havena am'alu'aluwagavai, Yeisu towaho Nasaleti iya hitutuye patuwa ambehabehaei, iya nigele teinai, wuwuna bada mwalowoiyena itowolouyo'o, yana aba'eno a'ava teina am'ita. ");
INSERT INTO kud2014_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Na omiu amlau gwaipile yo Yeisu ana taumulitao aidiyai amwalo mahalava na hinage Pita ainai amwalo mahalava, amwalo, “Yeisu ilau mugai'o Galili na omiu ammulitaei yo tenem ainai am'ita. Dova mwalona yana walomahalava alimiyai.” ’ ");
INSERT INTO kud2014_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Eeta waiwaihiuwowa magaiyena himahalava mwayamwayau na hidedenane, wuwuna nuwadi ipwanopwano moiha, na hinage hibatubatutuli mayadi meheuhi, na nigele yaiya ainai hiyawalo mahalava. ");
INSERT INTO kud2014_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Wiki ana ahubena mugamugaina malatomtomwai, Yeisu yana towolouyo ainai imahalava mugai Meli Magidalaena ainai, iya ainaena mwalona alu'aluwa yababadi hitau 7 Yeisu ivai vehuludi. ");
INSERT INTO kud2014_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Eeta Meliwa ilau na Yeisu ana taumulitao ivenuwamwauwedi, na hiya howola mayadi nuwayababa hidoudou Yeisu vehabana. ");
INSERT INTO kud2014_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ta Meli wasa imohedi iwalo, ‘Yeisu mayawahina imiyamiya, bada ya'itaya'o’. Na hiya hi'awa oya'oyamaei. ");
INSERT INTO kud2014_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mulitai Yeisu ana taumulitao hitau bwau Yelusalemaena himahalava na vali dalava vehabana hilaulau, na Yeisu i'abiye mahalavauyoi vali ita ainaena. ");
INSERT INTO kud2014_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Mulitai hitau bwauwa Yelusalem ainai hiwuyo na adi geluwo hivenuwamwauwedi, na hesi nigele hiyayemidiyedi. ");
INSERT INTO kud2014_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mulitai Yeisu ana taumulitao hitau 11 hi'ai'ai na Yeisu mehediyai imahalava, na iwalowedi yadi nuwatupatupa vehabana, iwalo, ‘Ada geluwo hiya yagu towolouyo tuluhanai hi'itagau na alimiyai hiwalo mahalava'o, na vedova ta nigele amyayemidiyedi?’ ");
INSERT INTO kud2014_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Na loina imohedi iwalo, ‘Amlau tupwa maudoina aidiyai, wasagu tomowa maudoidi aidiyai amguguyaei. ");
INSERT INTO kud2014_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ta ebe yaiyadiwo hiyemidiyegau am'abiye bapitaisowedi na livahi hilobai, na ebe yaiyadiwo nigele hiyayemidi howola abo loina yababana hilobai. ");
INSERT INTO kud2014_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na agu tauyemidiwone ve'ive'ilala wahiwahiyaladi hipaihowaidi, neta yehaguwena alu'aluwa yababadi tomowa aidiyena hiheusili mahalavaedi, na hinage alina vagavagadi aidiyena hi'au'aubabada, ");
INSERT INTO kud2014_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","yo ebe weso hi'abihinidi na hiwomalidi, mata nigele hiyamwalowoi, yo ebe bwahi newanewalidi hinuma mata nigele hiyamwalowoi, na ebe taulovalao hi'abisawahidi, hinamwanamwa ta'i.’ ");
INSERT INTO kud2014_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yada Bada Yeisu yana venuwamwau aidiyai bada i'ovi'o ta ihahaene galewai, na Yaubada nima tautuwanai imimiyane. ");
INSERT INTO kud2014_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Na ana taumulitaowa hilau tupwa maudoidi aidiyai na Yeisu wasana higuguyaei, na hesi yadi Bada ta'i baidadi hipaipaihowa, na yana wahiyalaena paihowao abanuwapwanopwano hipaihowaidi, neta ainaena tomowa wasanane hiyeyemidiyeine.");
INSERT INTO kud2014_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Aee taubada Tiyopilo. Tomowa bagibagilidi hi'aipate ebeha hilele dobiyei hava alidai ivevetuwunine. ");
INSERT INTO kud2014_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yeisu wasana hileledi'o hava dova hiya mehediyena hi'i'itamugaiyei, eeta higuguyanei na hi'au'aubabadanei alimaiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ainaena ginaulidine maudoidi hauga mugai ainaena ta wau yahanapui moiha, eeta nuwanuwagu na ebe ginaulidine ya'aubabada ili'ilimanidi alimwai, owa Tiyopilo tauloina namwanamwam vehabam. ");
INSERT INTO kud2014_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ta ebe ginaulidine bada ubenaledi'o wuwudi uhanapuidi na hinage u'awa moihaedi. ");
INSERT INTO kud2014_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yagu aubabada ana abavetuwuni teina dova: Hauganane Helodi ivetauwasawasa Yudeya ainai, ehebo taupwaoli yehana Sekalaya imiyamiya. Na mwanena yehana Elisabeti. Hitaubwaune yadi huhuwone taupwaoliwo, na hesi Sekalaya yana boda taupwauliwo yehana Abaya. ");
INSERT INTO kud2014_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Na hitau bwauwone Yaubada mehenai himumuga dumwalu ta Yaubada yana loina maudoina hi'awa abi ili'ilimanidi. ");
INSERT INTO kud2014_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Na hesi nigele natudi, wuwuna Elisabeti iya iyaipoi na iyemala ai'aihale'o yo hinage mwanena bada iyemala tautaubada'o. ");
INSERT INTO kud2014_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ehebo hauga ainai Sekalaya yana boda yadi ahubena na pwaoli hipaihowai, Yaubada mehenai. ");
INSERT INTO kud2014_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Wuwuna dova yadi mumuga, ta ana geluwone aidiyena Sekalaya vesinuwa ilobai, ainaena Bada yana vada tapwalolo mwala'ina holanai iluwu na ebe gado'a panena igabu abapwaoline ainai. ");
INSERT INTO kud2014_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Na panene ana hauga gabu ainai boda mwala'ina maseleyai hi'awa'awanoi Yaubada ainai. ");
INSERT INTO kud2014_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Na Yaubada yana tausagenawasa ehebo imahalava Sekalaya mehenai, na itowotowolo gado'a panena ana abagabu nima tautuwanaena. ");
INSERT INTO kud2014_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tenem ainai Sekalaya i'ita na i'aluwagavai, na hinage mayana meheuhi. ");
INSERT INTO kud2014_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Na tausagenawasane iwalo, ‘Sekalaya, havena umehemeheuhi na hesi uyaliyaya, wuwuna Yaubada yam awanoi bada ibenalena'o, ta mwanem Elisabeti mata natum towahona ilabahi na yehana uyogaei Yoni. ");
INSERT INTO kud2014_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Eeta uyaliyaya na hinage tomowa maudoidi hiyaliyaya gamanane ana labahi vehabana. ");
INSERT INTO kud2014_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wuwuna gamanane mata yehana imwala'i Yaubada mehenai. Havena waini yo bwahi wahiwahiyaladi inumanuwadi, na hinage hauga labahina ainaena mata Alu'aluwa Ve'ahihi i'oiye mwau. ");
INSERT INTO kud2014_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Eena iya mata Isileliwo bagibagilidi ilauvaiyoidima yadi Badane Yaubada ainai. ");
INSERT INTO kud2014_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Iya mata Bada mehenai imugai ta yana nuwatuwu yo yana ala'alawowoli dova tauwalo mahalava Elaitiya yana wahiyalane, na yana guguya ainaena tamadiyao nuwadi ibuidi ta natudiyao hinuwatuwu avivini, yo hinage hiya loina adi taulo'ewo nuwadi ibuidima amwaha dumwaluna ainai, na Bada vehabana tomowa i'atububunidi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Na Sekalaya tausagenawasane iwalo auline, iwalo, ‘Walo teina vedova ana awamoiha, wuwuna yau bada yatautaubada'o na mwanegune hinage bada iyemala ai'aihale'o’. ");
INSERT INTO kud2014_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Na tausagenawasane iwalo, ‘Yau Gabeliyela, na hauga maudoina Yaubada mehenai yatowotowolo, na wau ivetamalegau wasa teina namwanamwana ya'aubabadaei alimwai. ");
INSERT INTO kud2014_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Na hesi yagu walone alimwai nigele uya'awa moihaei, ainaena mata memenam ivitai ta nigele howahowana u'aubabada ana higa yagu walone ana moiha imahalava, abo mulitai u'aubabadauyo.’ ");
INSERT INTO kud2014_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na tomowa maudoidi howola maseleyai hiha'waha'wa, na hinuwanuwatuwu hava vehabana Sekalaya ibwedabwedane vada tapwalolo mwala'ina holanai. ");
INSERT INTO kud2014_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mulitai Sekalaya imahalava, ta nigele howahowana i'aubabada aidiyai, wuwuna memenanane ivitai. Eeta hihanapui ebeha vada tapwalolo mwala'ina holanai ve'ive'ilala i'itaya'o. Ainaena nigele howahowana i'aubabada aidiyai, ta nimanaena i'au'aubabada. ");
INSERT INTO kud2014_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Na Sekalaya yana pwaoli ana ahubenao i'ovi ta ilalau gwaipilene yana dalavai. ");
INSERT INTO kud2014_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Na hauga mulitai, mwanena Elisabeti ihiuma, ta wai'ena nima ehe'ehebo holadiyai nigele iyalowolowowouhi na hesi vadai imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Na iwalo, ‘Teina agu hagu Bada ainaena. Mugai yayaipoi ta yahinimaya na hesi teina ta'i agu hinimayawa i'ovi'o.’ ");
INSERT INTO kud2014_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabeti ihiuma na imiyamiya wai'ena ana bagibagili 6 na Yaubada tausagenawasa Gabeliyela ivetamalei Galili, ehebo dalava yehana Nasaleti ainai. ");
INSERT INTO kud2014_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Na ehebo waihiu nuwanuwapuyona ainai imahalava, yehana Meli. Vahalanane iya Yosepa ainai hiwalo abi'abiyei, na towahonane Deivida yana huhu ainaena. ");
INSERT INTO kud2014_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Na tausagenawasane ilau iwalo auli, iwalo, ‘Yauwedo Meli, Bada yana velau mwala'ina alimwai, na iya baidam’. ");
INSERT INTO kud2014_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ta Meli nuwana ipwanopwano na inuwanuwatuwu behabeha walone hava ana masele. ");
INSERT INTO kud2014_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Na tausagenawasanane iwalo, ‘Meli, havena umehemeheuhi. Yaubada yana velau alimwai mwala'i alili imiyamiya, ");
INSERT INTO kud2014_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","na mata uhiuma ta natum towahona ulabahi na yehana umwauwi Yeisu. ");
INSERT INTO kud2014_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Iya howola mata tauwahiyala moiha, na tomowa mata hiwalo vetuvehaeyei na hiwalo, Yaubada Haehae alilina Natuna, na Yaubada mata wahiyala imohei, dova tauwasawasa Deivida yana wasawasa, ");
INSERT INTO kud2014_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","eena Yakobo yana huhuwone alonai ivewasawasa hauga maudoina ilaulau yo nigele ana higa na yana abaloina mata nigele yana aba'ovi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Eeta Meli tausagenawasane ainai iwalo, ‘Vedova mata teina? Wuwuna yau nigele mwanegu.’ ");
INSERT INTO kud2014_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Na tausagenawasa iwalo, ‘Alu'aluwa Ve'ahihi mata alimwai i'aituluma na Yaubada i'abiye wahiyalago na natum ulabahi gama ve'ave'ahihina iya mata hiyogaei Yaubada Natuna. ");
INSERT INTO kud2014_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Na uhanapui ebeha yam huhuwena waihiu yehana Elisabeti i'ai'aihale'o na yaiyaipoina, na hesi bada ihiuma'o, ta teina yana wai'ena 6. ");
INSERT INTO kud2014_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Wuwuna ginauli maudoina Yaubada howahowana ipaihowaidi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ainaena Meli iwalo, ‘Yau Yaubada yana taupaihowa. Hava dova yam walo aliguwai imahalava ta'i.’ Eeta tausagenawasanane Meli ilaugabaei na ilalaune. ");
INSERT INTO kud2014_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Na teina tuluhanai Meli itowolo ta Yudeya oyana ibuidi'waidi ta Elisabeti yana dalava ainai imamahalavane. ");
INSERT INTO kud2014_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Imahalava ta Sekalaya yana vadai iluwu na Elisabeti iwawalo velauweine. ");
INSERT INTO kud2014_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Na hauganane Elisabeti alinana ibenalei, gamawa diyanai iwutugavaine, na hinage Alu'aluwa Ve'ahihi Elisabetinane i'oiye mwau, ");
INSERT INTO kud2014_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","eeta alinana mwala'ina iwalo, ‘Yaubada ivelauwego'o, nigele teya hinage waihiu dova owa. Na natumne mata ulabahine namwanamwa gaugauna moiha. ");
INSERT INTO kud2014_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Vedova ta owa yagu Bada hinana ulaoma, ubobo'eyegaune? ");
INSERT INTO kud2014_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Hola u'ita, yam walovelau yabenaledi, na gama yana yaliyaya ainaena diyaguwai iwutugavai. ");
INSERT INTO kud2014_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Na owa Yaubada yana walo ana tauyemidi, ainaena uyaliyaya, wuwuna mata ana moiha imahalava alimwai.’ ");
INSERT INTO kud2014_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Na Meli iwalo: ‘Bada yano'o'owei, ");
INSERT INTO kud2014_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","na ategune iwalo vetuvehaeyei wuwuna Yaubada iya agu Taulivahi. ");
INSERT INTO kud2014_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Yau yana taupaihowa wewelohegu ta'i, na hesi i'ita dobima aliguwai na ebe hauga mulitai hilalaoma aidiyai yaso vauvaudi hino'owegau. ");
INSERT INTO kud2014_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Wuwuna Yaubada iya Tauwahiyala moiha paihowa wahiwahiyalana ipaipaihowai vehabagu, na iya yehana Ve'ave'ahihina. ");
INSERT INTO kud2014_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Hiya ana tauve'ahihiwo yaso ehebo ehebo aidiyena i'atemuyamuyaedi. ");
INSERT INTO kud2014_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Na hesi hiya taugagasao yo taunuwahaehaewo nimana wahiwahiyalana ainaena i'oi'oipeiyedi. ");
INSERT INTO kud2014_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Na hinage tauwasawasao imwau aituluwedi yadi abamiya wasawasa aidiyena eena tauwewelohe i'abihinidi. ");
INSERT INTO kud2014_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Na hinage tauvahaliwo ive'aidi ta hi'ai i'iwahi na tauwasawasao ivetamaledi nimanima a'avadi. ");
INSERT INTO kud2014_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ibom yana waloyemidine tubudao aidiyai inuwatuwu avivini ainaena ita Isileli i'atemuyamuyaegita na ihaguigita, ");
INSERT INTO kud2014_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","dova yana waloyemidi tubudane Abelaham matubunaone aidiyai ebeha i'atemuyamuya vateyaiyedi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Eeta Meli Elisabeti baidana himiyamiya dova wai'ena tonuga, abo mulitai ilalau gwaipilene yana dalavai. ");
INSERT INTO kud2014_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabeti imiyamiya ta ilabalaba, gama towahona ilabahi. ");
INSERT INTO kud2014_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Na yana bodao yo ana geluwo Bada yana velau ainai hibenalei ta maudoidi baidanao hiyaliyaya. ");
INSERT INTO kud2014_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Na gamanane yana tubui neta ahubena eitina ainai yana bodao hitau'ahaiyama gamanane yana ve'ive'ilala neta tauna hihapi yo ebeha tamana ainai hiyewaligehaei. ");
INSERT INTO kud2014_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Eena hinana i'auhi iwalo, ‘Havena! Na hesi yehana ammwauwi Yoni.’ ");
INSERT INTO kud2014_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ana geluwone hiwalo, ‘Neta yehane omiu nigele yehamiu’. ");
INSERT INTO kud2014_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Eeta nimidiyena tamana hipanivilaei ta ebe vedova yehana hiyogaei. ");
INSERT INTO kud2014_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ta Sekalaya abalaulele i'awanoiyei ta gamanane yehana ilele, iwalo, ‘Yehanaede Yoni’. Na boda maudoidi hi'ita ta hi'aluwagavai. ");
INSERT INTO kud2014_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Na hauganane tenem ainai Sekalaya memenana imalamalaiuyo, ta i'aubabadauyone na Yaubada ino'owei. ");
INSERT INTO kud2014_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Na hesi ana geluwo himeheuhi, na wasanane ita'i'ili Yudeya oyanao na tupwanane maudoidi aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Na tomowaowa yaiyadiwo hibebenaleine hinuwatuwu behabeha, na hibom hipanivilauyoidi hiwalo, ‘Gama teina vedova mata yana paipaihowa?’ Wuwuna hi'itaya'o Yaubada yana wahiyala ainai imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sekalaya Alu'aluwa Ve'ahihi i'oiye mwau ta iwalo mahalava iwalo: ");
INSERT INTO kud2014_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","‘Bada tano'owei, iya Isileli tomowadi yadi Yaubada, wuwuna bada iloma'o habi haguigita yo miya vitai ainaena ilivahigita. ");
INSERT INTO kud2014_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ainaena yana hevali Deivida yana huhuwena ada Tauvaivehulu i'abiye mahalavaya'o alidai ");
INSERT INTO kud2014_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","mwalona tauwalo mahalavao ve'ave'ahihidi mugamugaidi Yaubada yana walo teina dova hiwalo mahalava mugaiyei hiwalo. ");
INSERT INTO kud2014_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Taulivahi mata ivetamalei ta ihaguigita ada alehao aidiyena, yo hinage hiya ada tausosomanao aidiyena, ");
INSERT INTO kud2014_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","na hinage mwalona iwalo yemidi ebeha tubudao mugamugaidi mata i'atemuyamuyaedi, na yana waloyemidine ve'ave'ahihina nigele iyanuwanuwapwanopwanowei. ");
INSERT INTO kud2014_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Waloyemidi teina tubuda Abelaham vehabana Yaubada ainaena ");
INSERT INTO kud2014_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","neta mata ilivahigita ada alehao aidiyena ta ebe mayada atepatu ainai tapaihowa. ");
INSERT INTO kud2014_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Yo hinage mata yada mumuga masemaselena yo dumwadumwaluna ahubena ehebo ehebo iya mehenai. ");
INSERT INTO kud2014_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Na owa natugu, mata hiyogaego Tauwahiyala moiha yana tauwalo mahalava, wuwuna owa mata umugai na Bada yana amwaha u'atububuni, ");
INSERT INTO kud2014_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","yo hinage yana bodao uvenuwamwauwedi neta yadi mumugao yababadi mata inuwahamuidi na livahi hilobai. ");
INSERT INTO kud2014_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Wuwuna Yaubada yana atemuyamuya alidai imwala'i i'alili na howola abo ada livahi galewaena dova masele i'abiye mahalava alidai, ");
INSERT INTO kud2014_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","eeta hiya guguyou yo mwalowoi tupwanao aidiyai himiyamiya hinage i'abiye maseledi, na maudoida imugaiyegita miya daumwali ana amwaha ainai.’ ");
INSERT INTO kud2014_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ta gamane imwala'i yo yana nuwatuwuwo hinage hiwahiyala, na hesi ibom balabala awawai imiyamiya ana higa Isileliwone aidiyai imahalava, na iguguya. ");
INSERT INTO kud2014_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Yoni yana hauga heda ainai ehebo tauwasawasa mwala'ina yehana Sisa Ogusito imiyamiya, na yana loina imwauwi ta ebe dalava ehebo ehebo tomowanao yehadi hileledi. ");
INSERT INTO kud2014_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Loina teina ivetuwuni haugana Kwiliniyo yana hauga vetauloina Siliya ainai. ");
INSERT INTO kud2014_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ainaena tomowa maudoidi hilau dalava tamadiyai na yehadi nemai hileledi. ");
INSERT INTO kud2014_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosepa hinage Nasaletiyena itowolo neta Galili holanaena ta ilau Yudeya, Deivida yana dalava yehana Betelehem ainai wuwuna Yosepa iya Deivida yana huhu. ");
INSERT INTO kud2014_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Eena iya Meli ainai Yosepa hiwalo abi'abiyei baidana hilau ta ebe nemai yehadi hileledi, na Meli bada ihiuma'o. ");
INSERT INTO kud2014_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Haugana Betelehem ainai himiyamiya yana ahubena ilobaiya ta ilalabalabane. ");
INSERT INTO kud2014_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Na ilabalaba ta yana tautuwa towaho i'avalai na ale'o ainaena ihuma ta lagulagu yadi aba'ai ainai imwamwauwine. Wuwuna vada taumana bada imwau'o, na nigele teya hinage tupwa vehabadi ta ainai hi'eno. ");
INSERT INTO kud2014_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na tupwanane ainai Sipi adi tau'ita aviviniwo masigiliyena hihilahilawa na yadi sipiwone hi'ita'ita avivinidi, ");
INSERT INTO kud2014_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","na Bada yana tausagenawasa ive'aluwagavaidima na masele pigapigabuna ainaena maudoidi himeheuhi. ");
INSERT INTO kud2014_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Eeta tausagenawasane iwalo aulidi, iwalo, ‘Havena ammehemeheuhi, na hesi amyaliyaya, wuwuna wasa namwanamwana yavaiyama alimiyai na ainaena mata tomowa maudoina yadi abayaliyaya. ");
INSERT INTO kud2014_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Wasanane teina, wau masigiline Deivida yana dalavai Taulivahiwa bada itubui'o iya Bada Yaubada yana Besinana towahona. ");
INSERT INTO kud2014_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na ana aba'ataiyede teina, iya gamanane ale'o ainaena hihuma na lagulagu yadi aba'ai ainai i'eno'eno mata amlobai.’ ");
INSERT INTO kud2014_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mai'ehebo na tausagenawasa bagibagilidi himahalava, tausagenawasanane baidadi Yaubada hino'ono'owei, ");
INSERT INTO kud2014_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","hiwalo, ‘Yaubada ewa aliliyai ta no'owei, na bale'uwai ana tauyemidiwo himiya daumwali’. ");
INSERT INTO kud2014_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","I'ovi na tausagenawasaowa hilau gwaipile galewai, na sipi adi tau'ita aviviniwone hibom aidiyai hiwalo, ‘Betelehem ainai talau ta ginauliwa i'aubabadaeiwa hola ta'ita’. ");
INSERT INTO kud2014_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Eeta himwayamwayau hilalaune, na Meli yo Yosepa na gamane lagulagu yadi aba'ai ainai i'eno'eno hilolobaidine. ");
INSERT INTO kud2014_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Hi'ita i'ovi na gamane tamana yo hinana hiwalo aulidi hava dova tausagenawasa yana walo aidiyai gamane vehabana. ");
INSERT INTO kud2014_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Eena tupwadi tomowa wasanane hibenalei ta hi'aluwagavai moiha tau'ita'ita sipiwone yadi aubabada vehabana. ");
INSERT INTO kud2014_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Na Meli walo maudoina inuwatuwu avivinidi ta vehabadi inuwanuwatuwu behabeha. ");
INSERT INTO kud2014_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Na tau'ita'ita sipiwone hilau gwaipile na yadi walo vetuvehae ainaena Yaubada yehana hi'abiye mwala'i, wuwuna tausagenawasane yana walomahalava aidiyai ana moiha hi'itaya'o. ");
INSERT INTO kud2014_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Wiki ehebo i'ovi, ta gamane yana ve'ive'ilala neta tauna hihapi na yehana himwauwi Yeisu, iya mwalona tausagenawasa Meli imomoheine haugana howola nigele iyahiuma. ");
INSERT INTO kud2014_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Na mulitai Meli ana abiye masele ana ahubena ainai natunane ilawei Yelusalem habi moheina Bada ainai dova Mosese yana loina. ");
INSERT INTO kud2014_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Yaubada yana loina teina dova hilele, iwalo, ‘Hedaheda tautuwa towatowahodi amtalamwedi Bada ainai’. ");
INSERT INTO kud2014_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Na hinage yadi pwaoli Yaubada ainai hilawedi, dova yana loina imwauwi iwalo, ‘Yami pwaoli gabubu bwau bo natunatudi bwau’. ");
INSERT INTO kud2014_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Hauganane Yelusalem ainai ehebo taubada yehana Simiyoni imiyamiya. Ibom towaho namwanamwana, na hinage Yaubada ive'ahihiyei mwala'ina na iha'waha'wa Isileliwone adi livahi vehabana. Towahonane Alu'aluwa Ve'ahihi ainai imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Na Alu'aluwa Ve'ahihi ive'ita ebeha mata nigele iyamwalowoi ana higa Bada yana Besinana towahona i'ita mugaiyei na abo imwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na Alu'aluwa Ve'ahihi ivenuwamwauwei, ta Simiyoni iluluwune vada tapwalolo mwala'ina ainai, na Yosepa yo Meli gamane Yeisu hi'avalaiyama vada tapwalolo mwala'ina ainai, ta hava dova Mosese yana loina hi'awa abiyei. ");
INSERT INTO kud2014_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyoni gamawa i'avalai ta Yaubada ainai i'a'awa yauwedo, iwalo: ");
INSERT INTO kud2014_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","‘Yaubada yam waloyemidi aliguwai bada yalobaiya'o, eeta teina ta'i utalam ta mayagu yaliyaya yamwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Wuwuna yam livahine tomowa maudoidi vehabadi u'abinonovaiya'o, ");
INSERT INTO kud2014_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","teina ainaena umwamwau mahalavaeine bada meheguwena ya'itaya'o ");
INSERT INTO kud2014_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ta hiya ganamuli yadi masele, na ai yam bodao Isileliwone yama wasawasa vehabana.’ ");
INSERT INTO kud2014_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Na tamana yo hinana hi'aluwagavai mwala'ina yana walowone natudine vehabana. ");
INSERT INTO kud2014_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","I'ovi na Simiyoni iwalo velauwedi, na iwalo Meli ainai, iwalo, ‘U'ita gamane teina, Yaubada ivesinuwaei mata howola abo Isileliwo bagibagilidi i'abiye be'udi na bagibagilidi i'abiye towolodi na iya mata hinage iyemala ve'ive'ilala tomowa aidiyai, na tupwadi hi'awa oya'oyamaei, ");
INSERT INTO kud2014_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","eeta yadi nuwatuwu dawadawanidi imwau mahalavaedi. Na owa Meli mata yam nuwayababane dova elepa ale'aleha atem iwomali.’ ");
INSERT INTO kud2014_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tenem ainai ehebo tauwalo mahalava waihiuna imiyamiya, yehana Ana, iya Panuweli natuna, na hinage Ase yana huhu ehebo. Waihiunane bada ive'ai'aihale'o, na mugai itawahola ta mwamwanena himiyamiya dova bolimai 7. ");
INSERT INTO kud2014_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Eena bada ihiwape'o na imiyamiya bolimai 84 na hesi vada tapwalolo mwala'ina nigele iyalaulaugabai ahubena yo boniyai aidiyai, Yaubada ive'ahihiyei na i'awa'awanoi yo ihudihudi. ");
INSERT INTO kud2014_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Hauga tenem ainai waihiunane ilaoma na Yaubada ainai i'awa yauwedo, na gamanane vehabana i'aubabada, iwalo, ‘Gamane teina Yelusalem ada Taulivahiwa taha'waha'waine’. ");
INSERT INTO kud2014_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Eeta paihowa maudoina hive'ovidi hava dova Yaubada yana loina, na hilalau gwaipilene Galili, wuwuna hiya Nasaleti yadi dalava. ");
INSERT INTO kud2014_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na gamane imwala'i mayana wahiyala, na mayana hanapu, wuwuna Yaubada gamanane ivelauwei mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bolimai ehebo ehebo aidiyai Yeisu hinana yo tamana hihaehae Yelusalem, Buidi'wa guyauna vehabana. ");
INSERT INTO kud2014_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Na haugana Yeisu ana bolimai 12 ilobai baidadi hihahaene guyaunane ainai. ");
INSERT INTO kud2014_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Eeta guyaune i'ovi na maudoidi hilaulau gwaipile yadi dalavai, na gamawa Yeisu Yelusalem ainai imiyamiya. Na tamana yo hinana nigele hiyahanapui, ");
INSERT INTO kud2014_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","na yadi nuwatuwu ebeha iya bodaone holadiyai. Ainaena hilaulau ta imasigili, na Yeisu hibehabehaei yadi bodaone yo adi geluwo aidiyai, ");
INSERT INTO kud2014_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","na nigele hiyalobai, ta hiwuyo Yelusalem hibehabehaei, ");
INSERT INTO kud2014_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","na hesi nigele hiyalobai ana higa ahubena tonuga hi'ovi, abo hilolobaine vada tapwalolo mwala'ina holanai, Yudeya yadi tauve'ita baidanao ibenabenali aidiyai yo ipanipanivilaedi. ");
INSERT INTO kud2014_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Na yana maihao namwanamwadi yo dumwaludi hibenaledi, ainaena maudoidi hi'aluwagavai. ");
INSERT INTO kud2014_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Na haugana tamana yo hinana hi'ita, hi'aluwagavai mwala'ina eeta hinanane iwalo, ‘Natugu, hava vehabana teina dova upapaihowaine, ta mayama nuwayababa tamamne baidagu abehabehaego?’ ");
INSERT INTO kud2014_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Eeta Yeisu iwalo, ‘Hava vehabana ambehabehaegaune? Nigele amyahanapui neta Tamagu yana vadai yamiyamiya?’ ");
INSERT INTO kud2014_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Na tamanane yo hinanane nigele nuwadine iyamasele yana walone vehabana. ");
INSERT INTO kud2014_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","I'ovi na baidanao hilau gwaipile Nasaleti, ta nemai yadi walowo imulitaedi. Na hesi hinanane ginauli teina vehabana inuwanuwatuwu mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Na Yeisu imwalamwala'i mayana hanapu na Yaubada iyaliyaya mwala'ina yo tomowa hinage dova hiyaliyaya ainai. ");
INSERT INTO kud2014_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tauwasawasa mwala'ina Sisa, iya yehana Taibiliya iloiloina bolimai 15, na elauhanai Ponitiyo Pailato Yudeya iloiloinaei, eena Helodi neta Galili tupwanane iloiloinaei, na tahinane Pilipi neta tupwa Ituliya yo Tilakiniti iloiloinaedi, na Lisaniyasi tupwa Abiline iloiloinaei. ");
INSERT INTO kud2014_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Na Anasa yo Kayapasi hiya taupwaoliwo adi tauloinao. Hauga tenem ainai Yaubada yana walo ilaoma Sekalaya natunane Yoni ainai, iya balabala awawai imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tenem ainai Yoni itowolo ta Yolidani maudoina ainai ilalaune na tomowa aidiyai iguguguguya, iwalo, ‘Yami paihowa yababadi amta'wata'wataedi na ya'abiye bapitaisogomiu ta ebe Yaubada yami pwanoliwo inuwahamuidi’. ");
INSERT INTO kud2014_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Dova Yaubada yana Buki ainai tauwalo mahalava Aisaya iwalo mahalava mugaiyei, iwalo: ‘Towaho ehebo nu'ula awawai alinana mwala'ina iyogayoga iwalo: “Bada yana amwaha amsepa, na am'abiye dumwadumwalu. ");
INSERT INTO kud2014_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Oyao maudoina am'elidi ta hiyemala 'wabu, na alo'alodi amhamuidi. Yo hinage amwaha giyogiyodi maudoina am'abiye dumwaludi na da'wada'wadi amtala'wa'walidi. ");
INSERT INTO kud2014_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na ebe tomowa maudoida Yaubada yana livahi ta'ita.” ’ ");
INSERT INTO kud2014_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ainaena tomowa bagibagilidi hilau Yoni ainai ta i'abiye bapitaisodi, na Yoni iwalo aulidine, iwalo, ‘Tau'oyama omiu, dova weso! Yami nuwatuwu ebeha mata Yaubada yana modi'ini ainaena amdena, awa? ");
INSERT INTO kud2014_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ilowoinanegomiu ta yami nuwabui moiha amve'itaedi yami paihowa namwanamwadi aidiyena. Na havena amwalo, “Ai Abelaham tubunao ainaena Yaubada mata i'atemuyamuyaegai.” Nigele ta'i! Am'ita, Yaubada howahowana gaima teina aidiyena Abelaham tubunao i'abilawedi. ");
INSERT INTO kud2014_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Teina haugane Yaubada ilam i'abinonovaiya'o ta ebe aiwa lamlamdi igohaidi. Wuwuna aiwa maudoina nigele hiya'ai'aino mata higoha vehuludi na aiwa ala'alahina ainai higabudi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","I'ovi na bodaowa Yoni hipanivilaei, hiwalo, ‘Hava yede ilowoinanegai ta apaihowai?’ ");
INSERT INTO kud2014_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Na Yoni iwalo, ‘Ebe yaiyadiwo omiu ami ale'o bwau na ami geluwo hiya nigele adi ale'o, ehebo ammohedi. Na hinage ebe amiu mwala'ina, tupwana tauvahaliwo aidiyai am'aiyauyanedi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Na tupwadi takesi ana tauvaiwo hilaoma yadi bapitaiso vehabana, na Yoni ainai hipanivila, hiwalo, ‘Tauve'ita! Hava mata apaihowaine?’ ");
INSERT INTO kud2014_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Na Yoni iwalo, ‘Takesi ana mwala'iyena amvaivai, na havena lauhepoi ammwaumwauwi’. ");
INSERT INTO kud2014_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Na tupwadi hinage tau'alehao hipanivilaei, hiwalo, ‘Na ai, mata hava apaihowaine?’ Eeta Yoni iwalo, ‘Tomowa yadi tobwatobwa havena amhalohaloidi bo oyamaena amvaivaidi. Na hesi yami paihowa maihadi vehabadi amyaliyaya.’ ");
INSERT INTO kud2014_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na tomowa maudoidi mayadi yemidi hiha'waha'wa Besinana towahona yana laoma vehabana, ta Yoni hi'ita na maudoidi hivenuwatuwu bwaubwau hiwalo, ‘Iya Besinana towahona, bo nigele?’. ");
INSERT INTO kud2014_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Eeta Yoni maudoidi aidiyai iwalo mahalava iwalo, ‘Yau nigele. Yau bwahiyena ya'abiye bapitaisogomiu, na hesi ehebo towaho tuluhaguwena ilalaoma mata Alu'aluwa Ve'ahihi na aiwa ala'alahawawalina ainaena i'abiye bapitaisogomiu. Iya imwala'i gabaegau, na nigele iyalowoinanegau na ana ae humahuma yalivahi. ");
INSERT INTO kud2014_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Na towahonane yana digonaena mata witi itapidi ta ainona hiholu na mulitai abo ainona namwanamwadi ihiwaihinidi yana vadavadai na mohomohonane aiwa ala'alahawawali vateyaina ainai igabudi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Na guguya hinage bagibagilidi aidiyena wasa namwanamwana Yoni iguguyaei tomowa aidiyai, ");
INSERT INTO kud2014_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","na hinage Yoni tauwasawasa yehana Helodi i'awa yababaei, iwalo, ‘Helodi, bada ilauhapuli'o. Helodiyasa iya tahina mwanena, na itatawaholaine.’ Na tupwadi hinage Helodi yana pwanoliwo Yoni iwalo mahalavaedi. ");
INSERT INTO kud2014_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ainaena Helodi vada abapaiyai imwauluwuweine. Tenem ainaena Helodi yana pwanoli imwala'i moiha. ");
INSERT INTO kud2014_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Na Yoni boda maudoidi bada i'abiye bapitaisodi'o, abo mulitai Yeisu hinage i'abiye bapitaiso, ta Yeisu Yaubada ainai i'awa'awanoi, na galewa ilotaho'e, ");
INSERT INTO kud2014_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na Alu'aluwa Ve'ahihi iyemala gabubu, ta i'aituluma Yeisu ainai, eena ehebo alina galewaena hibenalei, iwalo, ‘Owa natugu yavelauwego na vehabam yayaliyaya mwala'ina’. ");
INSERT INTO kud2014_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Hauganane Yeisu ana bolimai dova 30 ilobai, yana paihowa tomowa aidiyai ivetuwuni. Na tomowa hinuwatuwui ebeha iya tamana Yosepa na Yosepa tamana Heli, ");
INSERT INTO kud2014_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","na Heli tamana Madati, na Madati tamana Livai na Livai tamana Meliki, na Meliki tamana Yanai, na Yanai tamana Yosepa, ");
INSERT INTO kud2014_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","na Yosepa tamana Matadaya, na Matadaya tamana Emosi, na Emosi tamana Nahum, na Nahum tamana Esili, na Esili tamana Nagai, ");
INSERT INTO kud2014_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","na Nagai tamana Madi, na Madi tamana Matadaya, na Matadaya tamana Semini, na Semini tamana Yoseki, na Yoseki tamana Yoda, ");
INSERT INTO kud2014_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","na Yoda tamana Yaonani, na Yaonani tamana Lesa, na Lesa tamana Selubabela, na Selubabela tamana Selatiyeli, na Selatiyeli tamana Neli, ");
INSERT INTO kud2014_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","na Neli tamana Meliki, na Meliki tamana Adi, na Adi tamana Kosam, na Kosam tamana Elimadam, na Elimadam tamana Eli, ");
INSERT INTO kud2014_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","na Eli tamana Yosuwa, na Yosuwa tamana Eliyesa, na Eliyesa tamana Yolim, na Yolim tamana Madati, na Madati tamana Livai, ");
INSERT INTO kud2014_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","na Livai tamana Simiyoni, na Simiyoni tamana Yuda, na Yuda tamana Yosepa, na Yosepa tamana Yonam, na Yonam tamana Elayakim, ");
INSERT INTO kud2014_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","na Elayakim tamana Meleya, na Meleya tamana Mena, na Mena tamana Matada, na Matada tamana Natani, na Natani tamana Deivida, ");
INSERT INTO kud2014_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","na Deivida tamana Yesi, na Yesi tamana Obedi, na Obedi tamana Boasa, na Boasa tamana Salimoni, na Salimoni tamana Nasoni, ");
INSERT INTO kud2014_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","na Nasoni tamana Aminadaba, na Aminadaba tamana Adimana na Adimana tamana Anai, na Anai tamana Hesiloni, na Hesiloni tamana Pelesi, na Pelesi tamana Yuda, ");
INSERT INTO kud2014_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","na Yuda tamana Yakobo, na Yakobo tamana Aisake, na Aisake tamana Abelaham, na Abelaham tamana Tela, na Tela tamana Neho, ");
INSERT INTO kud2014_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","na Neho tamana Seluge, na Seluge tamana Leu, na Leu tamana Pelegi, na Pelegi tamana Ebe, na Ebe tamana Sala, ");
INSERT INTO kud2014_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","na Sala tamana Keinana, na Keinana tamana Apakisadi, na Apakisadi tamana Sem, na Sem tamana Nowa, na Nowa tamana Lameki, ");
INSERT INTO kud2014_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","na Lameki tamana Metusela, na Metusela tamana Inoke, na Inoke tamana Yeledi, na Yeledi tamana Mahalili, na Mahalili tamana Keinana, ");
INSERT INTO kud2014_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","na Keinana tamana Inosi, na Inosi tamana Seti, na Seti tamana Adam, na Adam tamana Yaubada. ");
INSERT INTO kud2014_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Alu'aluwa Ve'ahihi Yeisu i'oiye mwau na Yolidaniyena ilaulau gwaipile ta Alu'aluwa Ve'ahihi ilalaweine balabala awawai. ");
INSERT INTO kud2014_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Eena ahubena 40 aidiyai Tomodulele itowotowoi yo ebeha Yeisu i'abiye be'u, na ahubenadine aidiyai Yeisu nigele iya'ai, ta ivahali mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Na Tomodulele Yeisu iwalo auli, iwalo, ‘Ebe owa Yaubada Natuna, gaima teina uloinaedi na hiyemala ai'ai vehabam’. ");
INSERT INTO kud2014_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Eena Yeisu iwalo, ‘Yaubada yana Buki holanai loina imiyamiya ebeha: “Tomowa yawahidi nigele ai'ai a'ava ainaena hiyalobalobai”.’ ");
INSERT INTO kud2014_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","I'ovi na Tomodulele Yeisu ihaeyei ewai na bale'u yana abaloinao maudoidi ive'ita mwayamwayauwei, na iwalo, ");
INSERT INTO kud2014_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","‘Teina abaloinao maudoidi yamohego ebe aliguwai upwagogo. Wuwuna maudoidi bada yagu abaloina. Na ebe yaiya nuwanuwagu na yamohei, yamohei ta'i.’ ");
INSERT INTO kud2014_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Na Yeisu iwalo, ‘Yaubada yana Buki holanai loina imiyamiya iwalo: “Yam Yaubada ibom ainai upwagogo na ibom yana walo umulitaedi”.’ ");
INSERT INTO kud2014_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","I'ovi na Tomodulele Yeisu ilauvai ilalaweine Yelusalem vada tapwalolo mwala'ina ewa alilinai imwamwalaeyeine na ainai iwalo, ‘Ebe owa Yaubada Natuna, teina ainaena ugavai na havena usilasilahe, ");
INSERT INTO kud2014_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","wuwuna Yaubada yana Buki bada iwalo mahalava'o, iwalo: “Yaubada yana tausagenawasao mata iloinaedi ta hi'ita avivinigo”. ");
INSERT INTO kud2014_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Na hinage ehebo yana walo, iwalo mahalava: “Mata yana tausagenawasa hi'avalaigo ta havena aem hisilasilahe gaima aidiyai”.’ ");
INSERT INTO kud2014_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ta Yeisu walonane iyemaiha iwalo, ‘Yaubada yana Buki ainai ehebo walo imiyamiya iwalo, “Havena Bada yam Yaubada utowotowoi”.’ ");
INSERT INTO kud2014_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Eeta Tomodulele yana towoiwowa maudoina bada Yeisu ainai ive'ovidi'o, na ilalauvehulune hauga ahu'ahubalina a'ava vehabana. ");
INSERT INTO kud2014_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yeisu Alu'aluwa Ve'ahihi yana wahiyalaena ilau gwaipile Galili. Na tenem ainai Yeisu wasana hi'au'aubabadaei Galili tupwanao aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Na Galili yadi vada tapwalolowo aidiyai iguguya, na maudoidi hi'awa namwanamwaei. ");
INSERT INTO kud2014_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Na mulitai Yeisu ilaoma Nasaleti, iya yana dalava moiha. Na ehebo Tapwalolo ainai Yeisu iluwu vada tapwalolowai, mumugana dova. Eeta itowolo Yaubada yana Buki habi vahilina, ");
INSERT INTO kud2014_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","tauwalo mahalava Aisaya yana lele ainaena, eena i'ala ta ivahili, iwalo: ");
INSERT INTO kud2014_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","‘Bada Alu'aluwana aliguwai imiyamiya. Ibom ivesinuwaegau ta tauwewelohe aidiyai wasa namwanamwana yaguguyaei. Yo paipaidi hinage aidiyai ivetamalegau ta adi livahi vehabana aidiyai yawalo mahalava. Yo mehedigibugibudi hinage hivinunuyo. Na hinage ivetamalegau taumiya vitai ya'abiye yaliyayadi. ");
INSERT INTO kud2014_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Na aiteya bolimai mata Bada ihaguigomiune vehabana yawalo mahalavaei.’ ");
INSERT INTO kud2014_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ta Yeisu Bukine ivahili i'ovi na iyou, ta buki ana tau'ita avivini imoheuyoi, na imimiyane. Na hesi taubenaliwo maudoidi bada nuwadi ivaiya'o, ta himiyamiya na hivinuvinunui. ");
INSERT INTO kud2014_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Eeta iwalo aulidi iwalo, ‘Aubabadane yavavahiline ambenalena'o, mwalona hi'aubabada mugaiyei, na wao bada himahalava'o’. ");
INSERT INTO kud2014_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Na hiya nuwadi ipwanopwano moiha, ainaena yana aubabadao maudoina vehabadi hino'owei mwala'ina, hiwalo, ‘Towaho teina Yosepa natuna, awa? Na hesi vedova?’ ");
INSERT INTO kud2014_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Eena iwalo aulidi, iwalo, ‘Bada yahanapuigomiu'o mata walo vegevegediyena amwalo auligau amwalo, “Owa tau'abiye namwanamwa ta'i, ainaena ubom u'abiye namwanamwago”. Na hinage mata yami walo teya ainaena amwalo auligau amwalo, “Paihowaowa wahiwahiyaladi dalava Kapeneum ainai upapaihowaidiwa, dova hinage upaihowaidi teina yada dalavane ainai”. ");
INSERT INTO kud2014_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","‘Na hesi yawalo ili'ilimani alimiyai neta nigele teya tauwalo mahalava yana bodao aidiyena ana ve'ahihi iyalobalobai. ");
INSERT INTO kud2014_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Na amnuwatuwu avivini neta mwalona tauyewasa Elaitiya yana haugai hiwahiwape bagibagilidi Isileli ainai himiyamiya, na Yaubada nigele teya Isileli waihiuna iyavesinuwaei ta iya'ita avivini hauga vahali ainai, neta bolimai tonuga na tupwana aidiyai nigele dohi, na hesi hiwape Salepati ivesinuwaei Elaitiya ta i'ita avivinine iya Saidoni tupwanaena. ");
INSERT INTO kud2014_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na hinage tauwalo mahalava Elaisa yana haugai taulepelo bagibagilidi Isileli ainai himiyamiya, na nigele teya yaiya aidiyena iya'abiye namwanamwa, na hesi ehebo mohimohili towaho Siliya i'abiye namwanamwane, yehana Nemani.’ ");
INSERT INTO kud2014_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yeisu yana aubabadaone teina aidiyena hiya vada tapwalolowo holanai i'abiye modi'inidi, ");
INSERT INTO kud2014_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","hitowolo ta Yeisu hi'abi avivini na dalavaena hilauvai himahalavaei ta hihahaeyeine yadi dalavane oyana ainai, ta oya ewanai himwauwi ebeha hi'oipeiyei tapatapai. ");
INSERT INTO kud2014_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Na iya bodaone iwaheidi ta ilalaune. ");
INSERT INTO kud2014_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Mulitai idobi Kapaneum, neta Galili tupwanai ta nemai Tapwalolowai tomowa ive'itadi. ");
INSERT INTO kud2014_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Na tomowa maudoidi nuwadi ipwanopwano wuwuna yana ve'ita maudoina wahiwahiyalana. ");
INSERT INTO kud2014_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na vada tapwalolone ainai ehebo towaho imiyamiya, na towahonane alonai vi'avi'a imiyamiya, na alinana mwala'ina iwui, iwalo, ");
INSERT INTO kud2014_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","‘Ya! Owa towaho Nasaleti, hava wuwuna ulalaomane alimaiyai? Nuwanuwam na ebeha umutugai awa? Na owa bada yahanapuigo'o, owa Yaubada ainaena Ve'ave'ahihim.’ ");
INSERT INTO kud2014_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Eena Yeisu iloinaei, iwalo, ‘Ulaumwau na towahone ainaena umahalava’. Eeta boda mehediyai vi'avi'awa towahowa igabaei bale'uwai na ainaena imahalava, na nigele teya havana tomowanane iya'abiye yababa. ");
INSERT INTO kud2014_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ainaena maudoidi hi'aluwagavai ta hibom hipanivila, hiwalo, ‘Vedova teina? Ta walo yana wahiyala ainaena vi'avi'a iloinaedi ta himahamahalava.’ ");
INSERT INTO kud2014_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tenem ainaena Yeisu wasana hivetala au'aubabadaei Galili dalavanao aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yeisu vada tapwalolo ainaena imahalava ta Saimoni yana vadai iluwu. Eena Saimoni lawana ilovala tau'ala'alawowoli ainaena, na Yeisu hi'awanoiyei ebe i'abiye namwanamwa. ");
INSERT INTO kud2014_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Eeta Yeisu iluwu yana aba'eno vahalinai itowolo, na tau'ala'alawowoline iwalowei na tau'ala'awawowoline i'o'ovine, na wahiuwa itowolo ta adi ipapaihowaine. ");
INSERT INTO kud2014_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Na bada mahana ihugu'o na taumiya dalavao taniwagadi yadi taulovalao adi lovala vagadi vagadi hilauvaidima Yeisu ainai, ta maudoidi, i'abitowoidi ta hinanamwanamwane. ");
INSERT INTO kud2014_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Na hinage bagibagilidi aidiyena vi'avi'a himahalava ta hitautau wuiwui, hiwalo, ‘Moiha ta'i owa Yaubada Natuna!’. Na hesi Yeisu ilaugagayowedi havena dova hi'au'aubabada, wuwuna bada hihanapuiya'o ebeha iya Besinana towahona. ");
INSERT INTO kud2014_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bada mala itomtom ta Yeisu dalavanane ilauvehulu na ibom ilau balabala awawai. Na tomowa bagibagilidi hivetuwuni Yeisu hibehabehaei, na hauganane hilobai hiwalo auli, hiwalo, ‘Havena ulaulau. Teinai tamiyamiya.’ ");
INSERT INTO kud2014_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Na iwalo aulidi, iwalo, ‘Tupwadi hinage dalava aidiyai yalau ta Yaubada yana Abaloina wasana yaguguyaei. Teina wasane vehabana Yaubada ivetamalegaune.’ ");
INSERT INTO kud2014_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Eeta imahalava ilalaune Yudeya dalavanao maudoidi aidiyai, na yadi vada tapwalolo holadiyai iguguya ta'i'ili. ");
INSERT INTO kud2014_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ehebo hauga Yeisu itowotowolo le'awa Genesaleta papalinai na boda hilaoma ta hitowolo tutuniyama ebeha Yaubada yana walo Yeisu ainaena hibenalei. ");
INSERT INTO kud2014_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tenem ainai tauyamayamao yadi waga bwau i'i'itadine vahalinai hiniulidi magumaguwai, na tauyamaone bada hi'aitulu'o ta yadi vinaya hiuwauwadi. ");
INSERT INTO kud2014_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Eena Yeisu waga ehebo ainai igelu, neta Saimoni yana waga, eeta Saimoni iwalo auli ta ebe tupwana i'oidobi, ainaena i'oidobi ni'uwai ta wagane ainai imiya na ive'ita boda aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Na yana ve'ita i'ovi ta Saimoni iwawalo auline, iwalo, ‘Saimoni tupwana u'oidobi ni'uwai na yami vinayane amyahuwei’. ");
INSERT INTO kud2014_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Na Saimoni iwalo, ‘Taubada, boniyena ta'i ayama ahubena na nigele teya yama aya'ona. Na yam walo vehabana mata ayahuwei.’ ");
INSERT INTO kud2014_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hiyahuwei ta yama ibagibagili alili hi'onadi ta vinayawa muhamuhana ilotapulihi. ");
INSERT INTO kud2014_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Eeta adi geluwone vali wagaena hiyogaedi ebeha hilaoma hihaguidi, ta hiya yadi wagaena hilaoma na waga bwau hi'oiye mwaudi eeta muhamuhana hihanene. ");
INSERT INTO kud2014_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tenem ainai Saimoni Pita i'ita'ita ta Yeisu ainai ipwagogo, ta iwalo, ‘Taubada ulaugabaigau, wuwuna yau tauyababa’. ");
INSERT INTO kud2014_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Walo teina i'atai wuwuna ma'ana geluwo nuwadi ipwanopwano alili yamaone hi'o'onadine vehabadi, ");
INSERT INTO kud2014_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","na Saimoni ana tauhaguwo Yemesa yo Yoni, hiya Sebedi natunao hinage hi'aluwagavai moiha. Na Yeisu Pita iwalo auli, iwalo, ‘Havena umehemeheuhi. Mata ivetuwuni na ilaulau owa mata tomowa u'onadi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Na wagaone hiniulihaedi le'awai na ginauli maudoina hitauvehuludi na Yeisu himumulitaeine. ");
INSERT INTO kud2014_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Hauga teya ainai Yeisu hinage ehebo dalava ainai imiyamiya. Tupwanane ainai ehebo towaho tauna maudoina lepelo ivai. Eena towahonane Yeisu i'ita lobai ta ainai italupwagogo na i'awanoiyei, iwalo, ‘Taubada, ebe dova yam nuwatuwu, howahowana u'abiye namwanamwagau’. ");
INSERT INTO kud2014_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Na Yeisu nimanaena towahowa taunane i'abitowoi na iwalo, ‘Ehe, nuwanuwagu. Badagi na unamwanamwa.’ Eeta towahowa ana lepelowa i'ovi. ");
INSERT INTO kud2014_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Na Yeisu towahonane ivenuwamwauwei iwalo, ‘Ulau na havena yaiya teya ainai uwalowalo mahalavaegau na hesi udumwalu taupwaoli ainai ta i'itago, na upwaoli Yaubada ainai, hava dova ada loina Mosese ainaena, ta ebe tomowa hihanapuigo ebeha bada uyawahaiuyo'o’. ");
INSERT INTO kud2014_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Na hesi tenem ainai Yeisu wasana imwala'i moiha ta boda bagibagilidi hilaoma ebeha Yeisu yana aubabada hibenalei, na hinage adi lovala ebeha i'abiye namwanamwadi, ");
INSERT INTO kud2014_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","na hesi hauga maudoina boda aidiyena itautauwahi na ibom i'awa'awanoi Yaubada ainai. ");
INSERT INTO kud2014_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ehebo ahubena ainai Yeisu boda ive'ive'itadi, na tupwadi Palisiwo yo loina ana tauve'itao hiya Galili dalavanao maudoidi yo Yudeya na Yelusalem aidiyena hilaoma na boda baidadiyao himiyamiya na hi'au'aubabada. Hauga tenem ainai Yaubada yana wahiyalaena Yeisu taulovalao i'abiye namwanamwadi. ");
INSERT INTO kud2014_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ainaena bodaone aidiyena ehebo taupeu mahalabina hi'avalaiyama na hitowotowoi ebeha hiluwuwei vadai ta Yeisu mehenai himwauwi. ");
INSERT INTO kud2014_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Na hesi nigele howahowadi, wuwuna bodane imwala'i alili. Eeta taupeuwa hi'avala mwalaeyei vadane ewanai na ana atovine hivaivehulu ta ainaena taupeuwa ma'ana aba'avala hivelele dobiyei bodaowa ahipudiyai, ta Yeisu mehenai himwamwauwine. ");
INSERT INTO kud2014_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Eena Yeisu tomowaowa yadi yemidi ihanapuiya'o ta towahonane iwalo auli, iwalo, ‘Augelu, mumugam yababa adi nuwahamu bada ulobaiya'o’. ");
INSERT INTO kud2014_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Na hesi loina ana tauve'itao yo Palisiwowa Yeisu yana aubabadane hibenalena'o ta hibom aidiyai hi'au'aubabada hiwalo, ‘Towaho teina vedova ta Yaubada i'abi'abitalawahiyeine wuwuna nigele teya yaiya howahowana tomowa yadi mumuga yababao inuwahamuidi, bada Yaubada ibom howahowana’. ");
INSERT INTO kud2014_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yadi nuwatuwu Yeisu bada ihanapuiya'o eeta iwalo, ‘Hava vehabana neta dova amnuwanuwatuwune? ");
INSERT INTO kud2014_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Na hava amnuwatuwui ebe towaho teina ainai yawalowei, “Yam mumuga yababao bada yanuwahamuidi'o”, bo yawalo, “Utowolo ulau”? ");
INSERT INTO kud2014_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mata amhanapui yau Tomowa Moihagu mayagu loina bale'uwai ebeha tomowa yadi mumuga yababao mata yanuwahamuidi.’ Eeta taupeuwa iwalo auli, iwalo, ‘Yau teina yawalo auligo, utowolo yam halabi u'avalai na ulau yam dalavai!’. ");
INSERT INTO kud2014_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Na itautowolo ta boda mehediyena yana halabi i'avalai ilalaune yana dalavai mayana yaliyaya Yaubada ino'ono'owei. ");
INSERT INTO kud2014_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tenem ainai boda maudoidi nuwadi ipwanopwano mwala'ina, eeta mayadi ve'ahihi Yaubada hiwalo vetuvehaeyei, hiwalo, ‘Wau ehebo abanuwapwanopwano ta'itaya'o’. ");
INSERT INTO kud2014_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mulitai Yeisu imahalava ta ehebo takesi ana tauvai yehana Livai i'ita lobai yana vada abapaihowa ainai imiyamiya na iwalo auline, iwalo, ‘Livai umulitaegau’. ");
INSERT INTO kud2014_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ainaena Livai itowolo ta ginauli maudoina itauvehuludi eena Yeisu imumulitaeine. ");
INSERT INTO kud2014_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Na Livaiwa ai'ai mwala'ina ipaihowai Yeisu vehabana, eeta boda mwala'ina hilaoma Livai yana vadai ai'aine vehabana, na takesi ana tauvaiwo bodadi hinage baidanao. ");
INSERT INTO kud2014_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tenem ainai Palisiwo yo loina ana tauve'itao hi'ulu'ulumiyai Yeisu ana taumulitao aidiyai, hiwalo, ‘Hava wuwuna ta takesi ana tauvaiwo yo hinage tauyababao tupwadi baidamiyao am'ai'ai toyawane?’ ");
INSERT INTO kud2014_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Na yadi walowone Yeisu iyemaihadi iwalo, ‘Hiya namwanamwadi taulaumulamula nigele nuwadi, na hesi lovalovaladi nuwanuwadi taulaumulamula. ");
INSERT INTO kud2014_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Yau yalaoma nigele ebeha taunamwanamwa vehabadi, na hesi taupwanoliwo habi haguidi, ta ebe hinuwabui.’ ");
INSERT INTO kud2014_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Militai hinage tupwadi tomowa Yeisu hiwalo auli hiwalo, ‘Yoni ana taumulitao hauga maudoina mavahalidi hi'awa'awanoi Yaubada ainai, dova Palisiwone adi taumulitaone yadi paihowa, na vedova ta owa am taumulitaone nigele hiyahudihudine, na hi'ai'ai yo hinumanuma’. ");
INSERT INTO kud2014_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Eeta Yeisu iwalo vegevegedi iwalo, ‘Vedova, howahowana na tautawahola towahona ana taumanao hive'ahihi ai yo numa ainaena ebe tautawahola towahona baidadi hiyaliyaya? Nigele awa? ");
INSERT INTO kud2014_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Na amnuwatuwu avivini ebeha hauga ilalaoma ebe tautawaholawa ilaugabaidi abo hesi hinuwayababa na hive'ahihi, ai'ai yo numa ainaena.’ ");
INSERT INTO kud2014_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Na hinage ehebo walo vegevegedi i'aubabadaei aidiyai, iwalo, ‘Nigele howahowana luwuluwu vauvauna tupwana ta vai na luwuluwu miyamiyana ta bwalui. Nigele! Na ebe dova, neta luwuluwu vauvaunane bada i'abiye yababa'o na hinage vauvaunawa tupwatupwanane luwuluwu miyamiyanane nigele iyalowoinanei. ");
INSERT INTO kud2014_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Na hinage nigele teya yaiya bwahi wahiwahiyalana dova waini vauvauna iyahiwahiwai abahiwa 'wapi miyamiyana aidiyai, mata dova ta ilotapulihi ta bwahi yo abahiwa hiyepaipaihedi. ");
INSERT INTO kud2014_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Na hesi tahiwai 'wapi abahiwa vauvau a'avadi aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Na ebe yaiya waini miyamiyana inuma, mata iwalo ebeha nigele nuwanuwana vauvauna, wuwuna waini miyamiyana hesi inamwanamwa alili.’ ");
INSERT INTO kud2014_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tapwalolo ehebo ainai Yeisu mayana taumulitao baidanao tanovi holanaena hilaulau, na ana taumulitaone witi ainona higigidi ta hi'ai'aidi. ");
INSERT INTO kud2014_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Na tupwadi Palisiwone hiwalo, ‘Yada loina iwalo mahalava ebeha havena tapwalolo ainai tapaipaihowa na omiu vedova ta teina dova ampaipaihowaine?’ ");
INSERT INTO kud2014_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Eeta Yeisu Palisiwone yadi walo iyemaiha iwalo, ‘Yaubada yana Buki ainai hilele Deivida vehabana ebe amvahili amhanapui neta iya ma'ana geluwo hivahali ta ");
INSERT INTO kud2014_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yaubada yana vadai iluwu na beledi ve'ave'ahihina ivai ta hi'a'aine. Beledinane ma'ana loina ebeha taupwaoli a'ava adi talam yo hi'ai. Na hivahali alili ta bada hi'a'aine.’ ");
INSERT INTO kud2014_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Na Yeisu hinage iwalo aulidi iwalo, ‘Yau Tomowa Moihagu Tapwalolo ana tauloina’. ");
INSERT INTO kud2014_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ehebo hinage Tapwalolo ainai Yeisu iluwu vada tapwalolo ainai ta ive'ive'ita. Vadanane ainai ehebo towaho imiyamiya nima tautuwana peupeuna. ");
INSERT INTO kud2014_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Na hinage tupwadi loina ana tauve'itao yo Palisiwo himiyamiya, Yeisu hi'ita'ita sipwai mata dova ta towahonane i'abiye namwanamwa Tapwalolo ainai eeta ebe ainaena hive'ewai tauloina mehenai. ");
INSERT INTO kud2014_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Na hesi yadi nuwatuwune ihanapuiya'o, ainaena towahonane iwalo auli, iwalo, ‘Utowolo na uhaema’. Eeta towahowa itowolo ta ihahaene. ");
INSERT INTO kud2014_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ta Yeisu iwalo aidiyai na iwalo, ‘Hola yapanivilaegomiu. Hava yada loinane itatalamweine Tapwalolo ainai. Tomowa ta'abiye namwanamwadi bo ta'abiye yababadi, bo tomowa tahaguidi bo ta'abiye muyadi?’ ");
INSERT INTO kud2014_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tenem ainai maudoidi ivinunu'abi'abidi na towahowa iwalo auli iwalo, ‘Nimam utautuwudi’. Eeta towahowa nimana itautuwudi ta inanamwanamwane. ");
INSERT INTO kud2014_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Na hesi tauloinaone modi'ini i'oiye mwaudi na hivetuwuni hibommo hi'au'aubabada hava mata Yeisu ainai hipaihowaine. ");
INSERT INTO kud2014_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Hauga tenem ainai Yeisu ihae oyai na nemai masigili maudoina Yaubada ainai i'awa'awanoi. ");
INSERT INTO kud2014_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","I'ahubenama ta ana taumulitao aidiyena hitau 12 ivesinuwaedi ta iyogaedi yana tauyewasao. ");
INSERT INTO kud2014_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tauyewasaone yehadi teina: Saimoni, iya iyogaei Pita na tahina Andulu na hinage Yemesa yo Yoni na Pilipi yo Batolomiu. ");
INSERT INTO kud2014_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Madiu yo Tomasi yo vali Yemesa iya Alipiyosi natuna, na hinage vali Saimoni iya tauhamadudu mwala'ina abaloina vehabana, ");
INSERT INTO kud2014_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","yo Yudasa iya Yemesa natuna, na hinage Yudasa Isakaliyota, iya howola abo Yeisu ihuhulaei. ");
INSERT INTO kud2014_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yana tauyewasaone yo hinage ana taumulitao maudoidi baidanao oyaena hi'aituluma ta 'wabuwai hitowolo, na 'wabunane ainai boda mwala'ina himiyamiya, hiya hilaoma Yudeya yo Yelusalem na hinage Taya na Saidoni tupwa le'awadine aidiyena. ");
INSERT INTO kud2014_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ta hilaoma Yeisu yana aubabada habi benaleina yo hinage ebeha adi lovala i'abiye namwanamwadi. Na hinage hiya alu'aluwa yababadi aidiyai hiluwu nuwanuwadi na i'abiye namwanamwadi. ");
INSERT INTO kud2014_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bodaone maudoidi hitowoi ta ebeha Yeisu hi'abisawahi wuwuna wahiyala imahamahalava ainaena na tomowa maudoidi i'abi'abiye namwanamwadi. ");
INSERT INTO kud2014_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yeisu ana taumulitaowowa ivinuvinunuidi na iwalo aulidi, iwalo, ‘Ebe omiu amwewelohe, amyaliyaya wuwuna Yaubada nimanai ammiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Na omiu ebe amvahali amyaliyaya, wuwuna howola abo diyamiu himwau. Na hinage omiu amdoudou amyaliyaya wuwuna howola abo ammalu. ");
INSERT INTO kud2014_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Amyaliyaya ebe yau Tomowa Moihagu vehabagu tomowa hive'alehaegomiu, bo hita'wata'wataegomiu, bo hisosomanaegomiu bo hi'awa yababaegomiu. ");
INSERT INTO kud2014_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Hauga tenem ainai ebe vitaiwone himahalava vehabadi amyaliyaya na amtowolo amselo, wuwuna ami maiha namwanamwana galewai imiyamiya. Na amnuwatuwui ebeha tau'awa yababaone tubudiyao mwalona tauwalo mahalavao hi'awa yababaedi, dova teina haugane ainai. ");
INSERT INTO kud2014_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","‘Na hinage ebe omiu amvewasawasa, nuwayabayababamiu, wuwuna yami wasawasa bada amlobaiya'o ta mulitai mata nigele. ");
INSERT INTO kud2014_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Na yaiyadiwo omiu teina ta'i bada am'ai'i'iwahi moiha, amnuwayababa wuwuna muhamuhana vahali mwala'ina amlobai. Na hinage ebe teina ta'i ammalumalu, howola abo mayami nuwayababa amdou. ");
INSERT INTO kud2014_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","‘Na haugadine aidiyai ebe tomowa bagibagilidi hi'awa namwanamwaegomiu, amnuwatuwu gwaipile na amnuwayababa, wuwuna mwalona hiya tubudiyaone hinage dova tauwalo mahalava oya'oyama hi'awa namwanamwaedi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","‘Yagu ve'ita teina ambenalei, ami alehao amvelauwedi, na hiya hita'wata'wataegomiu amhaguidi, ");
INSERT INTO kud2014_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","na hinage hiya hi'awa yababaegomiu am'awa namwanamwaedi, na hiya hi'ale'alehaegomiu vehabadi am'awa'awanoi ta Yaubada ihaguidi. ");
INSERT INTO kud2014_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Na ebe yaiya navanavam isapi, havena nimana uveuveuyo, na hesi vali navanavamne hinage umohei ta isapi. Ebe yaiya yam gwaugwau luwuluwuna ivai, amluwuluwu mohili hinage utalamwei ainai. ");
INSERT INTO kud2014_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Na hinage ebe yaiya alimwai i'awanoi ehebo ginauli vehabana, ginaulinane umohei. Na ebe yaiya yam tobwatobwa ivai na ainai imiyamiya havena vehabana uwalowalouyo. ");
INSERT INTO kud2014_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","‘Na ebe hava nuwanuwamiu tomowa alimiyai hipaihowai, omiu hinage dova aidiyai ampaihowai. ");
INSERT INTO kud2014_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","‘Na ebe tomowa tauvelauwego hiya hibom uvelavelauwedi, hava vehabana mata awanamwanamwa uvai? Wuwuna tauyababao adi tauvelauwo, hinage hivelavelauwedi. ");
INSERT INTO kud2014_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Na ebe tau'abi ili'ilimanigo hibom u'abi ili'ilimanidi, hava vehabana mata awanamwanamwa uvai, wuwuna tauyababao hinage neta paihowane hipaipaihowai. ");
INSERT INTO kud2014_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Na ebe yaiyaidiwo uhanapuidi ebeha yam tobwatobwa umomohediwa mata hiyemaihauyoi, hava ana namwanamwa alimiwai? Wuwuna hiya tauyababao hi'ai'aiyauya adi geluwo aidiyai mata yadi ginauliwone adi mwala'i hivedumwaluyoidi. ");
INSERT INTO kud2014_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Na hesi ami alehao amvelauwedi na am'abi ili'ilimanidi, na havena yemaiha vehabana amnuwanuwatuwu. Ainaena ami maiha mata mwala'ina amlobai, ta omiu Yaubada Ewa'aliliyai natunao. Wuwuna hiya tauyababao yo tau'aidumao aidiyai inamwanamwa. ");
INSERT INTO kud2014_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ainaena omiu hinage am'atemuyamuya, dova Tamamiune i'ate'atemuyamuyane. ");
INSERT INTO kud2014_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","‘Hinage havena tomowa am'awa'awa yababaedi, mata dova ta Yaubada hinage i'awa yababaegomiu. Na hinage havena ami geluwo amve'eve'ewaidi, ta ebe omiu havena ve'ewa amlobalobai Yaubada ainaena, na hesi ami geluwo yadi mumuga amnuwahamuidi, ta ebe Yaubada yami mumuga hinage inuwahamuidi. ");
INSERT INTO kud2014_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Na ebe am'aiyauya mata Yaubada i'aiyauya alimiyai. Hava mwaumwauna yo ma'ana lauhepoi mata alimiyai i'atuhiwai. Wuwuna ginauliwone ana mwala'i hava mata u'a'aiyauyaneine mata ulobauyoi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ainaena walo vegevegedi teina imohedi, iwalo, ‘Vedova? Howahowana taumehegibugibu ana gelu mehegibugibuna imugaiyei? Mata nigele, awa? Ebe dova ipaihowai hitau bwauwone guda ainai hibe'u. ");
INSERT INTO kud2014_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Dova hinage taubenali, nigele howahowana na yana tauve'ita ihae gabaei. Na hesi bada ebe yana hanapune imwala'i ta ebe hitau bwauwone yadi hanapu itoyatoyawa. ");
INSERT INTO kud2014_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","‘Nigele iyalowoinanego na tahim vehabana uwalo ebeha mehenai aiwa mu'amu'alina imiyamiya, wuwuna owa hinage mehemwai etupwa imiyamiya na nigele uya'ita. ");
INSERT INTO kud2014_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ainaena havena tahim ainai uwalowalo, uwalo, “Tahigu, ilowoinanegau ebe aiwa mu'amu'alina mehemwena yavai vehulu”, wuwuna owa hinage etupwa mwala'ina mehemwai imiyamiya, nigele uya'ita. Moiha, owa ehebo tau'oyama, awa? Na hesi etupwane mehemwai uvai mugaiyei, ta ebe u'ita ili'ilimani na mulitai tahimne mehenaena aiwa mu'amu'alinane uvaivehulu. ");
INSERT INTO kud2014_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","‘Aiwa namwanamwana nigele howahowana na ainona newanewalina imwauwi. Hinage dova aiwa newanewalina nigele howahowana na ainona namwanamwa imwauwi. ");
INSERT INTO kud2014_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ainaena aiwa ehebo ehebo ainodi aidiyena tahanahanapuidi ebeha aiwadine namwanamwadi bo newanewalidi. Moiha neta, nigele howahowana na haihaili aidiyena damaya ainona talobai, dova hinage nigele howahowana na vilolo ainaena sibweya ainona talobai. ");
INSERT INTO kud2014_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Dova towaho yana mumuga, ebe towaho yana nuwatuwu ausalana yana mumuga maudoina namwanamwana. Na ebe yana nuwatuwu yababadi mumugana maudoina yababadi. Wuwuna nuwatuwuwone hava dova atemiyai himiyamiya hauga maudoina awamiyena himahamahalava. ");
INSERT INTO kud2014_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","‘Ainaena hava vehabana am'awa'awa Badaegaune, na yagu walo nigele amyamulimulitaedi. ");
INSERT INTO kud2014_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Na ebe yaiya owa ulaoma na yagu walo ubenaledi na upaihowaidi, owa yam mumuga dova ehebo tau'abi vada yave'itaei alimiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Iya dova tau'abi vada yana wahuwahu yaiyaina ilobai, gaima a'avana ainai, ta yana vadane ainai i'a'abine. Na haugana 'wesu mwala'ina i'aituluma na aba'ita isagena, ta vadanane iguhui na nigele iya'abiye yababa, wuwuna wahuwahu namwanamwana ainai i'a'abine. ");
INSERT INTO kud2014_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","‘Na hesi ebe yaiya owa yagu walo ubenaledi na nigele uyamulitaedi, owa bada dova tau'abi vada namonamo a'avana ainai yana vada i'a'abine. Eeta haugana aba'ita imahalava vadanane iguhui ta ibe'u mwayamwayau na maudoina ilo'evehulune.’ ");
INSERT INTO kud2014_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yeisu yana walo tomowa aidiyai i'ovi'o, ta imahalava na ilau Kapaneum. ");
INSERT INTO kud2014_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Dalavanane ainai tau'alehao hiya Loma adi taumugai ehebo mayana hevali himiyamiya. Na yana hevaline ivelauwei ili'ilimani. Na hauga tenem ainai ilovala mwala'ina ta habi imwalowoina. ");
INSERT INTO kud2014_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Na tauloinanane Yeisu yana laoma wasana ibenalei, eeta Yudeya yadi babadao tupwadi ivetamaledi Yeisu ainai habi awanoiyei ebe Yeisu ilaoma na yana hevaline i'abiye namwanamwa. ");
INSERT INTO kud2014_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ta babadaowa hilau Yeisu ainai hi'awanoi, hiwalo, ‘Bada, nuwanuwamai ebe talau teina towahone awalowaloweiwa ana dumwalu ebeha uhagui. ");
INSERT INTO kud2014_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Wuwuna iya towaho namwanamwana, na Yudeya maudoida ivelauwegita, ta yada vada tapwalolo i'a'abine.’ ");
INSERT INTO kud2014_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Eeta Yeisu baidadi hilalaune. Hilau ta dalavanane ainai himahamahalava, eena tauloinawa ana geluwo tupwadi hinage ivetamaledi Yeisu habi auhina. Na hilau Yeisu ainai ta hiwalo, ‘Bada, yama taumugai iwalo ebeha owa towaho mwala'ina ainaena nigele iyalowoinanego ebe uluwu yana vadai. ");
INSERT INTO kud2014_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Na hinage nigele iyalowoinanego na baidam amwahai amvelobaloba. Na hesi nuwanuwana ebe uwalo mohili na yana hevaline inamwanamwa. ");
INSERT INTO kud2014_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Na hinage alinana teina dova iwalo, “Yau loina yahanahanapui na agu tauloina yadi walo ana tau'awa abi, na hinage yagu tau'alehao yaloiloinaedi, na ebe teya ainai yawalo, ‘Ulau’ bada ilau ta'i; na ebe ehebo ainai yawalo, ‘Ulaoma’ bada ta'i ilaoma, na ebe yagu taupaihowa ehebo ainai yawalo, ‘Teina upaihowai’, bada ipaihowai”.’ ");
INSERT INTO kud2014_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Teina walowone Yeisu ibenaledi na i'aluwagavai moiha na i'ita gwaipile ta bodaowa himulimulitaeine iwalo aulidi, iwalo, ‘Moiha ta'i nigele teya yaiya Isileli alimiyena yayalobai yana yemidi dova teina towahone’. ");
INSERT INTO kud2014_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Eena tauloinawa yana hevahevaliwone hilau gwaipile yana vadai, ta nemai yana hevaliwa hilobai bada inamwanamwa'o. ");
INSERT INTO kud2014_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nigele hauga daodaona tuluhanai Yeisu ilau ehebo dalava ainai, yehana Naini. Na ana taumulitao yo hinage boda mwala'ina hi'wa'wayabuine. ");
INSERT INTO kud2014_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ilaoma dalavanane ainai ta taumwalowoi himahamahalavaenama dalavanane ainaena. Na taumwalowoine neta hiwape ehebo natuna, bada ehebo mohimohili, ainaena hiwapenane boda mwala'ina baidana hilaulau habi mwauwina magaiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tenem ainai Yeisu hiwapene i'i'itane na i'atemuyamuyaei ta iwalo, ‘Havena udoudou’. ");
INSERT INTO kud2014_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Na iwutu lau ta mwalowoiwa ana huma i'abitowoi eena tau'avalaowa hitowotowolo. Na Yeisu iwalo, ‘Hevali, utowolo’. ");
INSERT INTO kud2014_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ta hevaliwa imiya towolo ta i'au'aubabada, na Yeisu hevaliwa ilauvai ta hinanawa imomoheine. ");
INSERT INTO kud2014_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ainaena tomowaowa himeheuhi na Yaubada hiwalo vetuvehae, hiwalo, ‘Tauwalo mahalava mwala'ina bada imahalavama'o. Teina Yaubada yana taubo'e ita yana tomowao alidai.’ ");
INSERT INTO kud2014_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Eeta Yeisu wasana hiyewasaei Yudeya maudoina, na hinage dalavao vahalinai aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Na mulitai Yoni ana taumulitao wasa teina hiwalo mahalavaei ainai. ");
INSERT INTO kud2014_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ainaena ana taumulitao hitau bwau iyogaedima na iwalo aulidine, iwalo, ‘Amlau na ampanivilaei, ebe iya Besinanawa vehabana ya'au'aubabadane, bo vali towaho hinage taha'wai?’ ");
INSERT INTO kud2014_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Na hilaoma ta Yeisu hiwalo auli, hiwalo, ‘Yoni taubapitaiso ivetamalegai alaoma habi panivilaego ebe owa Besinanawa, bo vali towaho aha'waha'wai?’ ");
INSERT INTO kud2014_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Hauga tenem ainai Yeisu howola taulovalao adi lovala yo adi muya yo vi'avi'a aidiyena i'abi'abiye namwanamwadi yo hinage taumehegibugibu mehedi i'abiye maseledi. ");
INSERT INTO kud2014_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Eeta i'ovi na mulitai yadi panivilawa iyemaiha, iwalo, ‘Amwuyo ta Yoni ainai am'aubabada ginauliwone aliguwena hava bada am'itadi'o yo ambenaledi'o, neta: taumehegibugibu mehedi bada himasele'o, taupeu bada hinamwanamwa'o ta hilaulau, taulepelo taudi hinamwanamwauyo'o, tautalina tui bada talinadi hinamwanamwa'o, taumwalowoi hitowolouyo na hinage tauwewelohe bada wasa namwanamwana hibenalena'o. ");
INSERT INTO kud2014_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Eeta amlau na Yoni amwalo auli havena vehabagu inuwanuwatuwu bwaubwau, wuwuna ebe yaiya yana yemidi aliguwai nigele iyatapitapiya, mata iyaliyaya.’ ");
INSERT INTO kud2014_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Haugana Yoni ana taumulitaowowa hilaulau gwaipile, na Yeisu ivetuwuni boda aidiyai Yoni vehabana iwalo mahalava, iwalo, ‘Mwalona maudoimiu tupwa balabala awawai amlau Yoni habi benaleina, na hava nuwanuwamiu ebeha am'ita? Bo ebeha ehebo awahi mwala'ina yaumai iguhuguhui am'ita? ");
INSERT INTO kud2014_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Bo ehebo towaho ana ale'o wasawasa habi itana? Nigele, awa? Wuwuna hiya adi ale'o namwanamwadi moiha tauloina mwala'idi yadi tupwai himiyamiya na hiyaliyaliyaya. ");
INSERT INTO kud2014_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","‘Na hava yede vehabana amlalaune balabala awawai? Bo yami nuwatuwu ebeha ehebo tauwalo mahalava am'ita, awa? Moiha ta'i towahonane am'i'itane tauwalo mahalavao imwala'i gabaedi. ");
INSERT INTO kud2014_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yoni vehabana mwalona Yaubada yana Buki ainai teina dova iwalo mahalava mugaiyei iwalo: “Teina yagu tausagenawasa yavetamale mugaiyei na yam amwaha isepa”.’ ");
INSERT INTO kud2014_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Na Yeisu hinage iwalo, ‘Yoni iya taumiya bale'u maudoina imwala'i gabaedi, na hesi maudoidi hiya Yaubada yana Abaloina holanai Yoni himwala'i gabaei’. ");
INSERT INTO kud2014_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Eena bodaone yo takesi adi tauvaiwo Yeisu yana aubabada teina hibenaledi ta Yaubada hiwalo vetuvehaeyei, wuwuna hiya mwalona Yoni i'abiye bapitaisodi. ");
INSERT INTO kud2014_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Na hesi Palisiwone yo loina ana tauve'itao Yaubada yana nuwatuwu hita'wata'wataei, ainaena nigele nuwadi na Yoni i'abiye bapitaisodi. ");
INSERT INTO kud2014_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Eeta Yeisu iwalo, ‘Omiu yaso teina vedova ebe yayepategomiu? ");
INSERT INTO kud2014_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nuwana yawalo, omiu bada dova hedaheda abagimwala holanai hi'ai'ai'opi'opi na adi geluwo aidiyai hiyogayoga, hiwalo, “Ama geluwo vedova ta a'abi'abi sinaha na nigele amyasobune, na hinage ayebwayebwasa na nigele amyadoune”. ");
INSERT INTO kud2014_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Waloyepatu teina ana hanapu neta, Yoni tau'abiye bapitaiso ilaoma ta ihudihudi yo waini nigele iyanumanuma, ainaena amwalo ebeha alu'aluwa yababana Yoni i'abiye yauyauleya'o? ");
INSERT INTO kud2014_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yau Tomowa Moihagu yalaoma ya'ai'ai na yanumanuma na hinage vehabagu am'ulu'ulumiya, amwalo, “Towaho teina taunuma yo tau'ai'ala'alabili, na hinage takesi ana tauvaiwo yo tupwadi yabayababadi ive'au'augeluwedi”. ");
INSERT INTO kud2014_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Na hesi hiya tauhanapu moiha mata yadi paihowa namwanamwadi aidiyena hanapu moiha imahamahalava.’ ");
INSERT INTO kud2014_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ehebo hauga Palisi ehebo yehana Saimoni Yeisu iyogaei ta baidana habi ai. Eeta Yeisu iluwu vadai ta imiya habi ai. ");
INSERT INTO kud2014_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na dalavanane ainai wahiu ehebo tauyababa imiyamiya. Iya bada ihanapuiya'o ebeha Palisine yana vadai Yeisu i'ai'ai. Ainaena woloi namwanamwana ma'ana abahiwa namwanamwana ivaiyama, ");
INSERT INTO kud2014_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ta Yeisu vahalinai itowolo na idoudou na mehelinonaena Yeisu aena iyebuta, na waihiunane vahuna daodaona ta vahunaena aena iba'ilidi, yo hinage Yeisu aena inihoidi yo woloiwa ihiwai Yeisu aenai. ");
INSERT INTO kud2014_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Eena Palisiwa ibom inuwanuwatuwu iwalo, ‘Towaho teina, ebe iya tauwalo mahalava, ihanapui waihiune teina tauyababa, ta havena ainai i'abi'abi’. ");
INSERT INTO kud2014_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Na Yeisu i'apuhini iwalo, ‘Saimoni, nuwanuwagu ehebo ginauli yawalo mahalavaei alimwai’. Eeta Saimoni iwalo, ‘Ehewa, aiteya ginauli? Uwalowei aliguwai’. ");
INSERT INTO kud2014_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ta Yeisu iwalo, ‘Ehebo tauwasawasa na tomowa bwau adi vagavaga imwauwi, ehebo ana vagavaga dova 50 kina, na ehebo dova 5 kina. ");
INSERT INTO kud2014_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Na hitau bwauwone nigele howahowadi na hiyemaihadi. Ainaena tauwasawasawa hitau bwauwowa adi vagavaga inuwahamuidi. Na yapanivilaego. Hitaubwauwone aidiyena yaiya yadi taubadane ivelauwei mwala'ina?’ ");
INSERT INTO kud2014_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ta Saimoni Yeisu alinana iyemaiha, iwalo, ‘Towahone iya ana vagavaga mwala'inane ivelauwei mwala'ina’. Eena Yeisu iwalo, ‘Ehe, moiha’. ");
INSERT INTO kud2014_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Na i'ita gwaipile waihiuwa ainai, na iwalo, ‘Saimoni, waihiune teina yana paihowa vehabagu u'itaya'o, nigele dova owa. Wuwuna yam vadai yaluwuma na bwahi aegu anauwa vehabana nigele uyamohegau na hesi waihiune teina mehelinonaena aegu iuwadi na vahunaena iba'ilidi. ");
INSERT INTO kud2014_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na owa yagu mahalava ana niho nigele uyapaihowai aliguwai, na hesi iya yagu mahalava vauvauwai aegu inihoidi. ");
INSERT INTO kud2014_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nigele hinage woloiyena vahugu uyayewoloi, na iya hesi yana woloiyena aegu iyewoloidi. ");
INSERT INTO kud2014_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Iya yana pwanoliwo bagibagilidi bada yanuwahamuidi'o, ainaena ivelauwegau mwala'ina, na hesi ebe yaiya yana pwanoliwo habuludi na yanuwahamuidi, yana velau aliguwai hinage habuluna.’ ");
INSERT INTO kud2014_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","I'ovi na Yeisu waihiuwa iwalo auli, iwalo, ‘Yam pwanoliwo bada yanuwahamuidi'o’. ");
INSERT INTO kud2014_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Na tomowaowa Yeisu baidanao hi'ai'aine, Yeisu yana walo hibenalei ta hibom aidiyai hi'ulu'ulumiyaei, hiwalo, ‘Yaiya yede teina ta ebeha pwanoliwo inuwahamuidi?’ ");
INSERT INTO kud2014_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Eena Yeisu waihiuwa ainai iwalo, ‘Yam yemidi ainaena bada livahi ulobaiya'o, ta mayam yaliyaya ulau’. ");
INSERT INTO kud2014_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mulitai Yeisu itowolo na ilau dalava mwala'idi yo habuludi aidiyai Yaubada yana Abaloina wasa namwanamwana iguguyaei, na ana taumulitaowa hitau 12 baidanao. ");
INSERT INTO kud2014_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Na hinage tupwadi waiwaihiu baidanao, neta hiya mwalona lovala yo alu'aluwa yababadi aidiyena Yeisu abiye namwanamwadi. Waiwaihiuwone neta Meli Magidalaena iya mwalona ainaena alu'aluwa yababadi maudoina 7 Yeisu iheusili mahalavaedi, ");
INSERT INTO kud2014_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","na hinage Yoana iya Kusa mwanena, Kusanane Helodi yana taupaihowa, na hinage Susana yo tupwadi waiwaihiu baidadiyao. Waiwaihiuwone hiya yadi tobwatobwaena Yeisu ma'ana geluwo hi'i'ita avivinidi. ");
INSERT INTO kud2014_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tomowa maudoidi dalava bagibagilidi aidiyena hitaugogoiyama Yeisu ainai, eena Yeisu walo vegevegediyena ive'itadi, iwalo, ");
INSERT INTO kud2014_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","‘Tau'uma ehebo ilau yana oyai patu ivehulubudebudeyanaedi. Tupwadi patu amwahai hibe'u ta tomowa aediyena hiwutu'alatedi yo lowolowo hi'itadi ta hi'aitulu hi'a'aidine. ");
INSERT INTO kud2014_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Na tupwadi patu malagaigaimana ainai hibe'u ta hi'ini na mulitai hiwewelaine, wuwuna toputopunane nigele gwagwamana. ");
INSERT INTO kud2014_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Na tupwadi patu haihaili aidiyai hibe'u ta hi'ini mwalomwalowoi wuwuna haihailine iwahiyala ta i'oiye mwalowoidi. ");
INSERT INTO kud2014_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Na hesi tupwadi patu toputopu namwanamwana ainai hibe'u ta himwala'i na hi'aino, ta aidiyena aino namwanamwana ilobai.’ I'ovi na Yeisu bodaone ivenuwamwauwedi, iwalo ‘Ebe matalinamiu walo teina ambenaledi’. ");
INSERT INTO kud2014_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Mulitai ana taumulitaowowa Yeisu hipanivilaei, hiwalo, ‘Yam walo vegevegedine hava ana hanapu?’ ");
INSERT INTO kud2014_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Na iya iwalo, ‘Omiu Yaubada alimiyai italam ta yana loina holana moiha ana tauhanapuwo, na hesi bagibagilidi walo vegevegedi a'ava hibenalei. “Na adi nuwamasele nigele hiyahanapui, yo hinage ana hanapu hibehabehaei na hesi nigele hiyalobai.” ");
INSERT INTO kud2014_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","‘Na walo vegevegedinane ana livahi teina dova: Patune neta Yaubada yana walo. ");
INSERT INTO kud2014_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Na patuwowa amwahai hibebe'une hiya neta tomowa walo hibenali mohilei, na hesi Tomodulele ilaoma ta atediyena walowa ivaivehulune, ta nigele howahowana hiyemidi ebeha Yaubada howahowana ihaguidi. ");
INSERT INTO kud2014_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Na patuwowa hibebe'une toputopu malagaigaimana aidiyai neta tomowaowa hiya Yaubada yana walo vehabana hiyaliyaya, na hesi nigele lamlamdi hiyayaiyai wuwuna yadi yemidi nigele mwala'ina, ta ebe abatowoi aidiyai himahalava mata hibe'u. ");
INSERT INTO kud2014_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Na patuwowa haihaili aidiyai hibebe'une neta tomowaowa hiya walowa hibenalei, na yadi nuwatuwu maudoina hilaulau nuwatuwu bagibagili yo wasawasa yo bale'u yaliyayanao aidiyai. Ainaena Yaubada yana walo aidiyai nigele ainona iyamahalava. ");
INSERT INTO kud2014_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na patuwowa toputopu namwanamwana aidiyai hibebe'une neta hiya tomowao mayadi atetalam Yaubada yana walo hibenaledi, yo mayadi alama'i'ita ainaena Yaubada yana walo aidiyai i'aino moiha.’ ");
INSERT INTO kud2014_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yeisu hinage aidiyai iwalo, ‘Nigele teya yaiya lampa iyagabu na gaeba ainaena iya'oihamui bo aba'eno elauhanai iyamwauwi na hesi abamwau ewanai imwauwi ta ebe tomowa maselene hi'ita haugana hiluwuluwu. ");
INSERT INTO kud2014_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Hava dawadawanina mata imiya mahalava ta tomowa hibenalei. Na hava oi'oihamuina mata hilobai na hivaiyama maseleyai ta tomowa hi'ita. ");
INSERT INTO kud2014_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","‘Eeta am'ita avivini yami benabenali aidiyena. Wuwuna yaiya ainai hava namwanamwana imiyamiya mata Yaubada ilauhepoiyei iya ainai. Na hesi ebe yaiya ainai nigele na yana nuwatuwu ebeha hava habuluna ainai imiyamiya, mata Yaubada ivaivehulu.’ ");
INSERT INTO kud2014_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mulitai Yeisu hinana yo tahinao hilaoma habi itana na hesi boda imwala'i alili, eeta nigele howahowana hiluwu Yeisu ainai. ");
INSERT INTO kud2014_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ta walo a'ava hivetamalei, hiwalo, ‘Taubada, hinam yo tahimwowa tenem maseleyai hitowotowolo, ebeha nuwanuwadi owa’. ");
INSERT INTO kud2014_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Na Yeisu iwalo aulidi, iwalo, ‘Nigele hibom, na hesi ebe yaiyadiwo Yaubada yana walo hibenalei na hi'awa abiyedi hiya neta hinaguwao yo tahiguwao’. ");
INSERT INTO kud2014_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ehebo hauga Yeisu mayana taumulitao higelu na aidiyai iwalo, ‘Ta'u'e tageyo'awa vali tupwai’. Eeta hi'u'e, ");
INSERT INTO kud2014_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","hisagesagena na Yeisu i'eno'eno ta i'eno i'iwahine. Na yaumai mwala'ina itowa ta bagodu mwala'ina ihiwahiwadi'wa wagai na muhamuhana hihanene. ");
INSERT INTO kud2014_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Eeta ana taumulitaowa Yeisu hivanoi hiwalo, ‘Taubada, Taubada, utowolo, mata tahanene!’ Eeta Yeisu itowolo ta yaumai yo bagodune i'ahonedi, iwalo, ‘Amlaumwau!’ Eeta hilaumwau na idadaumwaline. ");
INSERT INTO kud2014_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ainaena Yeisu ana taumulitaowa iwalo aulidi, iwalo, ‘Vedova? Nuwana nigele amyayemidiyegau awa?’ Na hiya mayadi meheuhi hi'aluwagavai na hibom aidiyai hiwalo, ‘Towaho yehana teina? Ta yaumai yo bagodu alinana hi'a'awa abiyeine.’ ");
INSERT INTO kud2014_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Galili vali tupwanai higeyo'awa'o ta hiluwu Gelasiwone yadi gadowai. ");
INSERT INTO kud2014_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Eena Yeisu i'aitulu le'awai na ehebo taumiya dalava imahalavama ainai. Towahonane alu'aluwa yababadi hiluwu holanai ta ainai himiyamiya. Na towahonane hauga daodaona ale'o nigele iyali'wali'wa, na vada aidiyai nigele iyamiyamiya na hesi magai gudadi aidiyai imiyamiyane. ");
INSERT INTO kud2014_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ta towahowa Yeisu i'ita, na ilohagali ta ibe'u ainai na iwui mwalamwala'i, iwalo ‘Yeisu yo, owa Yaubada Ewa aliliyai Natuna, hava ebeha upaihowai? Badagi! Havena u'abi'abiye muyagau.’ ");
INSERT INTO kud2014_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Walo teina i'a'ataine wuwuna Yeisu bada iwalo auliya'o, ta ebeha alu'aluwa yababana towahone i'aitulu gabaei. Towahonane hauga bagibagilina alu'aluwane i'abiye yeyauyaule eeta hi'abi'abi avivini na nimana yo aena hipaipaidi pwawati aidiyena, na hesi pwawatine iwutuwutuhidi na towahonane ilawelawei nu'ula awawai. ");
INSERT INTO kud2014_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Eeta Yeisu towahonane ipanivilaei, iwalo, ‘Vedova yeham?’ Na towahowa iwalo, ‘Yehaguwede Bagibagilimai’, wuwuna alu'aluwa bagibagilidi holanai himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Na alu'aluwaowa Yeisu ainai hi'awa'awanoi, hiwalo, ‘Havena ugabagabae aituluwegai guda abasilahe ainai. ");
INSERT INTO kud2014_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na hesi uvetamalegai ta aluwu maheyaone bagibagilidine tenem hidumudumuline oyane aidiyai. Eeta Yeisu italam. ");
INSERT INTO kud2014_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ta towahowa ainaena himahalava ta maheyaowa aidiyai hiluluwune. Tenem ainai maheyaowa maudoidi hiyauyaule ta hisagena tapatapana ainai hibe'u ta ni'uwai hihahanenene. ");
INSERT INTO kud2014_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Na maheyaowa adi tau'ita aviviniwowa hi'ita na hidena ta hilalaune hiyewasa hava dova hi'i'itane, dalava mwala'idi yo dalava habuludi tomowadiyaone aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Eeta tomowa bagibagilidi hilaoma ta ebe hiya mehediyena hi'ita hava imamahalavane. Ta Yeisu ainai hilaoma ta towahowa hi'ita mwalona alu'aluwa yababadi holanai himiyamiya bada inamwanamwa'o ta ale'o ili'wa na Yeisu vahalinai imiyamiya. Tenem ainai maudoidi himeheuhi. ");
INSERT INTO kud2014_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Eena tauyewasaowa tomowa aidiyai hi'aubabada vedova towahonane yana namwanamwa. ");
INSERT INTO kud2014_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Eeta Gelasinewowa maudoidi himeheuhi mwala'ina ta Yeisu hisosomanaei ebe ilaugabaidi. Ainaena Yeisu wagai idodobi habi gelu. ");
INSERT INTO kud2014_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ta towahowa i'abiye namwanamwawa iwalo atemuyamuya Yeisu ainai iwalo, ‘Uwalo ta owa na yau talau?’ Na Yeisu iwalo, ");
INSERT INTO kud2014_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","‘Nigele. Hesi ulau gwaipile dalavai ta hava Yaubada alimwai ipaihowaiya'o u'aubabadaei.’ Eeta towahowa ilau dalavai na Yeisu yana paihowa i'aubabadaei taumiya dalava maudoidi aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yeisu mayana taumulitao higeyo'awauyo na boda mwala'ina mayadi yaliyaya hivevedunane. Wuwuna iya vehabana hiha'waha'wane. ");
INSERT INTO kud2014_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Eena ehebo towaho iluwu mahalava, yehana Yailo, iya yadi vada tapwalolo ana tau'ita avivini. Ilaoma ta Yeisu ainai italupwagogo na iwalo, ‘Taubada talau yagu vadai, ");
INSERT INTO kud2014_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ta natugu ilovala mwala'ina u'abiye namwanamwa. Iya bada ehebo mohimohili natugune, ana bolimai 12 na vadai i'e'eno na hauga habuluna na imwalowoi.’ Eeta baidana hilalaune. Hilaulau amwahai na boda mwala'ina himulimulitaedi, ta hiveveduidui. ");
INSERT INTO kud2014_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na bodaone holadiyai ehebo wahiu baidadi, ma'ana lovala. Lovalanane neta 'wahina isagesagenaei bolimai 12 hi'ovi'o, na besiwa isagesagena. Hauga bagibagilina taulaumulamula hitowotowoi ebeha hi'abiye namwanamwa na hesi nigele howahowadi. ");
INSERT INTO kud2014_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Eena wahiunane Yeisu tuluhanaena ilaoma ta ana ale'o papalinane i'abitowoine na wahinawa yana sagena ilalaumwaune. ");
INSERT INTO kud2014_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ainaena Yeisu itautowolo, ta iwalo, ‘Eei! Yaiya i'a'abitowoigaune?’ Na maudoidi hiuvala. Na hesi Pita iwalo auli, iwalo, ‘Bada, nuwana bodaone hiveveduidui ta hitatautupane alimwai’. ");
INSERT INTO kud2014_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Na Yeisu iwalo, ‘Nigele. Teya yaiya agu ale'o i'abitowoine, wuwuna yalautowoi aliguwena wahiyala imahalava'o na tau'abitowoigaune ainai igeyo'awa'o.’ ");
INSERT INTO kud2014_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Na waihiuwa ilautowoiya'o ebeha Yeisu bada yana paihowane ihanapuiya'o, ainaena ilaoma na mayana batutuli ibe'u aitulu Yeisu aenai, na boda mehediyai yana paihowawa wuwuna iwalo mahalavaei, iwalo, ‘Taubada, nuwanuwagu na yanamwanamwa, ainaena am'ale'one ya'a'abitowoine, ta yananamwanamwane’. ");
INSERT INTO kud2014_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Eeta Yeisu waihiunane iwalo auli, iwalo, ‘Natugu, yam yemidi ainaena unamwanamwa'o. Utowolo na mayam yaliyaya ulau.’ ");
INSERT INTO kud2014_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Hauganane Yeisu iwalowalo waihiuwa ainai Yailo yana vadaena yana taupaihowa ehebo wasa ilawenama Yailo ainai, iwalo, ‘Taubada, natum bada imwalowoi'o na havena tauve'itane yana hauga igabagabaei.’ ");
INSERT INTO kud2014_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Wasa teina Yeisu ibenalei ta Yailo iwalo auli, iwalo, ‘Havena umehemeheuhi na hesi uyemidiyegau ebeha natum mata inamwanamwa’. ");
INSERT INTO kud2014_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ainaena hilau ta dalavai himahalava, eena Yeisu boda maudoidi i'auhidi ta ebe vadanane ainai havena hiluwuluwu, bada nuwanuwana Pita na Yoni yo Yemesa na hinage gamahinewa hinana yo tamana baidanao hiluwu. ");
INSERT INTO kud2014_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Na boda vadai howola hidoudou na hinage hiwoewoe gamahinewa vehabana. Ainaena Yeisu i'auhidi iwalo, ‘Badagi! Dou amlaumwau, wuwuna gamahinene nigele iyamwalowoi, na hesi i'eno'eno mohili.’ ");
INSERT INTO kud2014_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Na maudoidi Yeisu himaluwei wuwuna hihanapuiya'o gamahinene bada imwalowoi'o. ");
INSERT INTO kud2014_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Eena Yeisu hedawa nimanai i'abi na iwalo auli, iwalo, ‘Gamahine utowolo’. ");
INSERT INTO kud2014_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Na gamahinewa yawahina iwuyoma ta itotowolone. Eena Yeisu gamahinewa hinana yo tamana aidiyai iwalo, ‘Ai'ai ammohei na i'ai’. ");
INSERT INTO kud2014_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tenem ainai tamana yo hinana nuwadi ipwanopwano moiha. Na Yeisu hinage ivenuwamwauwedi iwalo, ‘Havena teya yaiya ainai amwalowalo mahalava yagu paihowa teina vehabana’. ");
INSERT INTO kud2014_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yeisu ana taumulitao hitau 12 iyoga ahaidi na adi loina yo wahiyala imohedi ta ebe howahowadi alu'aluwa yababadi tomowa aidiyena hiheusili mahalavaedi, yo hinage adi lovalao hi'abiye namwanamwadi. ");
INSERT INTO kud2014_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Eeta ivetamaledi ebeha Yaubada yana Abaloina tomowa aidiyai higuguyaei, yo hinage taulovalao hi'abiye namwanamwadi. ");
INSERT INTO kud2014_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Na hinage yana aubabada ainai iloinaedi iwalo, ‘Havena teya hava amvaivai. Havena digona nuwana boha nuwana ai'ai nuwana mane, nuwana ami ale'o bwauna. ");
INSERT INTO kud2014_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Na ebe aiteya vada ainai hiyogaegomiu na amluwu, vadanane ainai amvetaumana ana higa tupwanane amlaugabaei. ");
INSERT INTO kud2014_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Na ebe aiteya dalava ainai nigele hiyalauvaigomiu yadi vadai, dalavanane gawalanane aemiyena am'oiyeholudi na amlaugabaidi, eena ainaena amve'itadi ebeha mata vitai aidiyai imahalava.’ ");
INSERT INTO kud2014_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Eeta ana taumulitaone hilau ta tupwa maudoina aidiyai hita'i'ili na wasa namwanamwana higuguyaei, na hinage taulovala tupwa ehebo ehebo aidiyai hi'abiye namwanamwadi. ");
INSERT INTO kud2014_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Helodi iya Galili ana tau'ita avivini, ginauli teina himahamahalava wasadi ibenaledi na nuwana ipwanopwano mwala'ina wuwuna tupwadi tomowa hiwalo, ‘Yoni taubapitaiso ebeha mwalowoiyena itowolouyo'o’. ");
INSERT INTO kud2014_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Na tupwadi hiwalo, ‘Nigele, Elaitiya imahalava'o’, na hinage tupwadi hiwalo, ebeha ‘Ibom ehebo tauwalo mahalava mwalona imwalowoi na teina hauga itowolouyo'o’. ");
INSERT INTO kud2014_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ainaena Helodi iwalo, ‘Yoni yau yagu loinaena ta gadona hitotomne. Na aiteya yede towaho teina hiwalowaloweine.’ Tenem ainai Helodi i'ai'aipate mwala'ina ebe Yeisu i'ita. ");
INSERT INTO kud2014_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yeisu yana tauyewasao yadi ta'i'iliyena hiwuyo ta yadi paihowa maudoina hi'aubabadaei Yeisu ainai. Mulitai yadi taubadane ilauvaidi ta baidanao hilau ehebo dalava yehana Bedesaida ainai, ta ebe hibom nemai himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Na nigele howahowadi, wuwuna boda wasa hibenalena'o ta Yeisu himulitaei hilaoma ainai. Eena Yeisu iyaliyayaidi ta aidiyai Yaubada yana Abaloina vehabana ive'ita, na hinage adi lovalao i'abiye namwanamwadi. ");
INSERT INTO kud2014_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Himiyamiya ee mahana ihugu, na hitau 12 hilaoma Yeisu hiwawalo auline, hiwalo, ‘Taubada, boda teina uvetamaledi ta hiwuyo dalavao vahalidai aidiyai, ta nemai ai'ai yo aba'eno hibeha, yo hi'aiyawasi. Wuwuna teina bada balabala awawa.’ ");
INSERT INTO kud2014_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Na Yeisu aidiyai iwalo, ‘Omiu ai'ai ammohedi ta hi'ai?’ Na hiya hiwalo, ‘Vedova mata teina ave'aidine? Wuwuna amaine nigele mwala'ina. Beledi nima ehe'ehebo na yama bwau hitutupwane. Nuwanuwam ebeha alau na bodaone adi agimwala, awa?’ ");
INSERT INTO kud2014_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Na bodaone aidiyena towatowaho a'ava adi bagibagili dova 5,000. Ainaena Yeisu ana taumulitao iwalo aulidi, iwalo, ‘Tomowaone amwaheidi na yadi boda aidiyai ammwauwidi, dova 50 boda ehebo ehebo aidiyai, himiya’. ");
INSERT INTO kud2014_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Eeta yana loinaone maudoina dova hipaihowaidi, ta yadi boda aidiyai himimiyane. ");
INSERT INTO kud2014_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Eena Yeisu beledi nima ehe'ehebo na hinage yama bwauwa ivaidi, na galewai i'ita hae na ai'aiwone vahabadi i'awa yauwedo. Abo mulitai i'abitomwahidi na ana taumulitao imohedi na hiveguyau tomowa aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Na maudoidi hi'ai ta hi'ai i'iwahi, na ai'ai tupwatupwadi hitano'ahaidi, neta boha 12 hi'oiye mwaudine. ");
INSERT INTO kud2014_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yeisu ana taumulitaone hilao'o hilowolowouhi na Yeisu ibom imiyamiya, Yaubada ainai i'awa'awanoi. I'awanoi i'ovi na ana taumulitaowa hilaoma ta ipanivilaedi iwalo, ‘Vedova tomowa yadi walo vehabagu, ebeha yau yaiya?’ ");
INSERT INTO kud2014_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Na ana taumulitaowa hiwalo, ‘Tomowa tupwadi hiwalo, ebeha owa Yoni tau'abiye bapitaiso, na tupwadi hiwalo ebeha owa Elaitiya, na tupwadi hiwalo ebeha owa tauwalo mahalava mugamugaina mwalowoiyena itowolouyoma’. ");
INSERT INTO kud2014_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Hinage ipanivilaedi iwalo, ‘Na omiu vedova yami nuwatuwu ebeha yau yaiya?’ Eeta Pita iwalo, ‘Owa Besinana towahona, Yaubada ainaena’. ");
INSERT INTO kud2014_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tenem ainai Yeisu ana taumulitao ivenuwamwauwedi ebeha havena hiwalowalo mahalavaei tomowa aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yo hinage iwalo aulidi, iwalo, ‘Yau Tomowa Moihagu howola abo muya mwala'ina yalobai. Wuwuna babadao yo taupwaoli mwala'idi yo hinage loina ana tauve'itao mata hisosomanaegau na hi'oiye mwalowoigau, na ahubena tonugana ainai Yaubada i'abiye towolouyoigau.’ ");
INSERT INTO kud2014_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mulitai maudoidi aidiyai iwalo, ‘Ebe yaiya owa nuwanuwam umulitaegau, havena ubom vehabam unuwanuwatuwu. Na hesi ubom yam aiwa lagalagana u'avalai ahubena ehebo ehebo, na umulitaegau. ");
INSERT INTO kud2014_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ebe yaiya yawahina inuvavi howola abo yawahinane ive'wadalele. Na ebe yaiya yawahina vehabagu italamwei na imwalowoi, ibom mata yawahi namwanamwana ilobai. ");
INSERT INTO kud2014_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ebe yaiya yana tobwatobwa mwala'ina, mata Yaubada yana mumuga inuwapwanopwanowei, eeta hava mata namwanamwana ilobaine? ");
INSERT INTO kud2014_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","‘Ebe yaiya tomowa vehabagu ihinimaya na yagu ve'ita vahabadi ihinimaya mata yau Tomowa Moihagu yagu hauga laoma ainai mata yahinimayaei. Haugana yalaolaoma yagu wasawasa ainaena na Tamagu yo yana tausagenawasao ve'ave'ahihidi yadi wasawasa namanamalinaena. ");
INSERT INTO kud2014_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Yawalo moiha alimiyai tomowa tupwamiu teina mata nigele amyamwalowoi ana higa Yaubada yana Abaloina am'ita. ");
INSERT INTO kud2014_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Walowone teina hi'ovi na dova wiki ehebo tuluhanai, Pita yo Yoni yo Yemesa Yeisu ilauvaidi ta baidanao hihae ehebo oya ainai habi awanoi Yaubada ainai. ");
INSERT INTO kud2014_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Eeta howola Yeisu i'awa'awanoi na maninane ana oleya maudoina igwaipile yo hinage ana ale'one iwadaheya moiha dova namali. ");
INSERT INTO kud2014_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Eena towatowaho bwau himahalava, ta Yeisu baidadi hi'au'aubabada, hiya neta Mosese na Elaitiya. ");
INSERT INTO kud2014_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Hiya hinage aidiyena masele ihinahinadi, na Yeisu baidadi hi'au'aubabada vedova mata Yeisu yana mwalowoi Yelusalem ainai Yaubada yana nuwatuwu ana yemala moiha vehabana. ");
INSERT INTO kud2014_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Na Pita ma'ana geluwo bada hi'eno i'iwahi'o, na mulitai hi'eno towolo, ta masele mwala'ina hi'ita Yeisu ma'ana geluwo aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Na mulitai hitau bwauwowa Yeisu hilaugabaei, na Pita i'apuhini iwalo, ‘Taubada, inamwanamwa baidadao teinai tamiyamiya na yami gwau tonuga a'abidi, ehebo owa vehabam, ehebo Mosese vehabana, na ehebo Elaitiya vehabana’. Pita bada iwalowalo awawa. ");
INSERT INTO kud2014_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita yana aubabadane howola nigele iyave'ovi, na ewadiyena hogahoga i'aituluma i'oihamuidi, ainaena taumulitaowa himeheuhi. ");
INSERT INTO kud2014_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Na hogahogane ainaena ehebo alina hibenalei, iwalo, ‘Teina Natugu. Iya yavesinuwai na am'awa abiyei.’ ");
INSERT INTO kud2014_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ta alinawa i'ovi, na Yeisu ibom hi'i'itane itowotowolo. Hauga tenem ainai hava dova mehediyena hi'i'itane nigele teya yaiya ainai hiyawalo mahalavaei. ");
INSERT INTO kud2014_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","I'ahubena ta Yeisu mayana taumulitao oyaena hi'aitulu dalavai na boda mwala'ina baidadiyao hivelaulobaloba. ");
INSERT INTO kud2014_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Na ehebo towaho bodaone aidiyena Yeisu i'ita na iyoga, iwalo, ‘Tauve'ita, nuwanuwagu natugu u'abiye namwanamwa, natugune ehebo mohimohili. ");
INSERT INTO kud2014_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Na hauga bagibagilina ebe alu'aluwa yababana gamanane i'abi avivini, iwuiwui mwala'ina na awanaena gwalagwalabuho himahamahalava. Hauga bagibagilina dova i'abi'abiye muya. ");
INSERT INTO kud2014_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Na amtaumulitaone ya'awanoiyedi ebeha alu'aluwa yababanane higabae mahalavaei, na hesi nigele howahowadi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ainaena Yeisu iyemaiha iwalo, ‘Omiu teina yasone nigele yami yemidi ta tomowa yababamiu? Hauga daodaona maiviha mata yamiya vahaligomiu yo yanuwatuwuigomiu?’ Ainaena towahonane ainai iwalo, ‘Natumne ulawenama aliguwai’. ");
INSERT INTO kud2014_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Na gamawa ilaoma Yeisu ainai, ta alu'aluwa yababanawa gamawa ibuiyei bale'uwai ta itataine. Eena Yeisu iloina ta alu'aluwawa imahalava na gama inamwanamwane. Abo mulitai Yeisu gamanane ilawei tamanawa ainai. ");
INSERT INTO kud2014_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Hauga tenem ainai tomowa maudoidi Yaubada yana wahiyala bada hi'itaya'o, ainaena nuwadi ipwanopwano mwala'ina. Na tomowadine howola mayadi nuwanuwapwanopwano, na Yeisu ana taumulitao iwalo aulidi, ");
INSERT INTO kud2014_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","iwalo, ‘Yagu walone teina mata yawalo mahalavaeine alimiyai amnuwatuwu avivini, neta Tomowa Moihagu mata hihuhulaegau na agu alehao aidiyai himwaugeyo'awahegau’. ");
INSERT INTO kud2014_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tenem ainai i'abiye nuwapwanopwanodi, ainaena nigele howahowadi yo ginauli teina vehabadi nuwadi imasele, ta Yeisu ainai nigele hiyapanivila na ebe i'abiye masele aidiyai, wuwuna himeheuhi. ");
INSERT INTO kud2014_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mulitai ana taumulitaowa hive'awa pa'ipa'i'i yaiya aidiyena adi taumugai. ");
INSERT INTO kud2014_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Na Yeisu hesi bada yadi nuwatuwu ihanapuiya'o. Ainaena ehebo gama ilauvaiyama ta vahalidiyai ivetowolo, na iwalo aulidi iwalo, ");
INSERT INTO kud2014_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","‘Gama teina am'ita. Ebe yaiya gama teina yehaguwena ivelauwei, neta bada ivelauwegau'o, na hinage agu tauvetamalene bada ivelauwena'o. Eena ebe yaiya alimiyena idobi alili iya mata ihae alili.’ ");
INSERT INTO kud2014_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yoni i'apuhini iwalo, ‘Taubada, ehebo towaho a'itaya'o yehamwena alu'aluwa yababadi igabagabae mahalavaedi. Ainaena alaugagayowei, wuwuna towahonane nigele yada boda holanai.’ ");
INSERT INTO kud2014_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Na Yeisu iwalo, ‘Havena am'au'auhi! Wuwuna ebe yaiya iya nigele iyave'ave'alehaegomiu iya ami tauhagu.’ ");
INSERT INTO kud2014_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Bada ahubena ilautebitebi'o na Yeisu ilau gwaipile galewai, ainaena yana nuwatuwu imwauwi ebeha ilau Yelusalem. Eeta itowolo na mayana taumulitao hilalaune. ");
INSERT INTO kud2014_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Hilaulau ta Yeisu ana taumulitao tupwadi ivetamalemugaiyedi, Sameliya yadi dalavai ta ebe yana aba'aiyawasi vehabana hi'atububuni. ");
INSERT INTO kud2014_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Na taumiya dalavaone nigele hiyatalam, wuwuna hihanapuya'o Yeisu ilalau Yelusalem. ");
INSERT INTO kud2014_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Na Yemesa yo Yoni walo teina hibenalei, ta Yeisu ainai hiwalo, ‘Taubada, vedova? Nuwanuwam aiwa ala'alahina galewaena ayogaei ta i'aituluma na i'alayesawalidi?’ ");
INSERT INTO kud2014_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Na Yeisu iwalowedi, ‘Havena neta dova’. ");
INSERT INTO kud2014_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Eeta vali dalavai hilalaune. ");
INSERT INTO kud2014_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Hilaulau, na ehebo towaho ilaoma ta Yeisu ainai iwalo, ‘Yau nuwanuwagu yamulitaego. Aiteya tupwa ainai ulalau yau yamulitaego.’ ");
INSERT INTO kud2014_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ainaena Yeisu towahonane iwalo auli, iwalo, ‘Lagulagu nu'ula mayadi guda yo hinage lowolowo mayadi noi, na hesi yau Tomowa Moihagu nigele yagu aba'eno’. ");
INSERT INTO kud2014_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Eena bwauna hinage ilaoma ta Yeisu towahonane ainai iwalo, ‘Umulitaegau’. Na iya iwalo, ‘Taubada, utalamwegau ta mugai yawuyo tamagu yaha'waha'wai yana mwalowoi vehabana na yamwaumagaiyei abo mulitai yamulitaego’. ");
INSERT INTO kud2014_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Na Yeisu iwalo, ‘Badagi tamamne. Hiya taumwalomwalowoi yadi taumwalowowo himagaiyedi. Na owa hesi yam paihowa ebeha uvetauwalo mahalava Yaubada yana Abaloina vehabana.’ ");
INSERT INTO kud2014_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Na tonugana hinage ilaoma, iwalo, ‘Taubada, inamwanamwa yamulitaego, na hesi utalam mugaiyegau ta yawuyo yagu bodao aidiyai, ya'awa yauwedo na mulitai abo yamulitaego’. ");
INSERT INTO kud2014_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ainaena Yeisu hinage iwalo auline, iwalo, ‘Ebe yaiya owa nuwanuwam upaihowa na hesi mayam nuwatuwu bwau, nigele iyalowoinanego ta Yaubada yana Abaloina vehabana upaihowa’. ");
INSERT INTO kud2014_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Teina tuluhanai, Yeisu tupwadi hinage ana taumulitao ivesinuwaidi, 72 adi bagibagili, na bwau bwau ivetamale mugaiyedi tupwadi dalava aidiyai na taumiya dalava hi'atububunidi Yeisu yana lowouhi aidiyai vehabana. ");
INSERT INTO kud2014_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Na aidiyai iwalo, ‘Lau'eli namwanamwana na hesi taulau'eliwone omiu nigele bagibagilimiu, ainaena tanovi ana Bada ainai am'awanoi ta taupaihowao ivetamaledi na yana alowai hilau'eli. ");
INSERT INTO kud2014_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Am lau. Yau yavetamalegomiu omiu dova sipi manamanahamiu amlalau edewa manimaninidi holadiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","‘Havena mane amvaivai, nuwana boha, nuwana ami aehumahuma amvaivaidi. Na ebe amlaulau havena amwahai yaiya am velavelauwei. ");
INSERT INTO kud2014_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","‘Na ebe ehebo vada ainai amluwu, mugai amwalo, “Nuwadaumwali alimiyai”. ");
INSERT INTO kud2014_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na ebe nuwadaumwali ana taupaihowao himiyamiya yami velau aidiyai imiya'alili. Na ebe nigele, velaunane ilau gwaipilewa alimiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","‘Na ebe vadanane ainai ammiyamiya, na hava amiu bo we'aha mehemiya himwauwi, am'ai, wuwuna taupaihowao ilowoinanedi ebe adi maiha hilobai. Na havena amlaulau vali vada aidiyai, na hesi vadawa ainai amluluwu mugaiwa ainai ammiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","‘Na ebe aiteya dalava ainai mayadi yaliyaya hilauvaigomiu na aidiyai amluwu, na hava mehemiyai himwau mahalavayei am'ai bada. ");
INSERT INTO kud2014_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Na hinage dalavanane ainai ammiyamiyane yadi tau'asiyebwao am'abiye namwanamwadi, na dalava tanitaniwagadiyao aidiyai, amwalo, “Yaubada yana Abaloina muhamuhana na imahalava alimiyai”. ");
INSERT INTO kud2014_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Na ebe aiteya dalava ainai ammahalava, na hisosomanaegomiu, amlau papaliyai na amwalo aidiyai, ");
INSERT INTO kud2014_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","am'ita, yami dalava namonamona aemaiyena agoha yehoyeholuya'o, na amhanapui ebeha bada Yaubada yana Abaloina vahalimiya imiyamiya!’ ");
INSERT INTO kud2014_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yawalo moiha alimiyai, howola Yaubada yana loina ana ahubena, mwala'ina ainai, hiya dalavaowa hitata'wata'wataegomiuwa mata muya mwala'i alilina hilobai, na abo Sodoma adi muya.’ ");
INSERT INTO kud2014_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Dalava ana taumiyao iwalo aidiyai, iwalo, ‘Omiu Kolasini yo omiu Bedesaida nuwayababamiu wuwuna abanuwapwanopwano bada yapaihowadi'o mehemiyai na hesi nigele amyanuwabui. Na ebe Taya yo Saidoni aidiyai yapaihowai nuwana mwalona bada hinuwabui'o, ta ebe hilaunohi'o yo higiba'o ta ebe hive'itauyoidi ebeha yadi mumuga yababana aidiyena bada hinuwabui'o. ");
INSERT INTO kud2014_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Na hesi omiu nigele ali'alili, ainaena Yaubada yana ahubena lauvetala mwala'ina ana hauga ainai, mata Yaubada hiya Taya na Saidoni i'atemuyamuyaedi na omiu nigele. ");
INSERT INTO kud2014_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na Kapaneum omiu vedova, ebeha am'abihinigomiu galewai, awa? Mata nigele! Na hesi mata Yaubada igabae aituluwegomiu bwebweso ainai.’ ");
INSERT INTO kud2014_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","‘Ebe yaiya yami walo ibenaledi neta yau yagu walo ibenalena'o. Na ebe yaiya ita'wata'wataegomiu yau hinage ita'wata'wataegau'o, na hinage agu tauvetamalene ita'wata'wataeina'o. ");
INSERT INTO kud2014_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Eeta ana taumulitao hitau 72 yadi paihowaena hilau gwaipilema na mayadi yaliyaya Yeisu ainai hi'aubabada, hiwalo, ‘Bada, awalo mahalava alimwai neta alu'aluwa yababadi hinage yehamwena aloinaedi na himahalava’. ");
INSERT INTO kud2014_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Na Yeisu aidiyai iwalo, ‘Tomodulele ya'itaya'o galewaena ibe'ube'uma dova namali. ");
INSERT INTO kud2014_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Eeta ambenalei, bada ala'alawowoli yamohegomiu'o ta howahowana weso womawomalidi ewadiyena amlau yo alivai amwutu alatedi yo Tomodulele yana ala'alawowoli maudoidi amdi'waidi na mata nigele muya amyave'alodi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Na hinage yawalo auligomiu, ‘Havena amyaliyaliyaya, yami paihowa alu'aluwa yababadi aidiyai wahiwahiyalana vehabana, na hesi amyaliyaya wuwuna yehamiu bada galewai hileledi'o’. ");
INSERT INTO kud2014_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tenem hauganane ainai Alu'aluwa Ve'ahihi Yeisu i'abiye yaliyaya na iwalo, ‘Yauwedo Tamagu, owa galewa yo bale'u adi tauloina, ve'itane teina udawani tauhanapu yo taunuwamaselewo aidiyai na hesi taunuwapwanopwanowo aidiyai uve'itaena'o. Na moiha Tamagu, yam nuwatuwune teina namwanamwana.’ ");
INSERT INTO kud2014_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yo hinage iwalo, ‘Ginauli maudoina bada Tamagu nimaguwai imwaudi'o, na Tamagu ibom ihanahanapuigau, na yau hinage yabom Tamagu yahanahanapui, yo hinage yaiyadiwo nuwanuwagu na Tamagu yave'itaei aidiyai, hiya hinage hihanahanapui.’ ");
INSERT INTO kud2014_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Haugana Yeisu ana taumulitao baidanao hi'ulewahi na mulitai i'ita gwaipile ta aidiyai iwalo, ‘Omiu amyaliyaya wuwuna ginauli teina mehemiyena am'ita'itadi. ");
INSERT INTO kud2014_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Yawalo moiha, mwalona tauwalo mahalavao yo tauloinao bagibagilidi nuwanuwadi na ginauli teina hi'itadi, yo hinage walowone ambebenaledine, hiya nuwanuwadi ebe hinage hibenaledi, na hesi nigele hiyalobaidi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ehebo loina ana taumugai ilaoma Yeisu ainai na panivilaena ebeha itowoi na iwalo, ‘Taubada hava mata yapaihowai na yawahi vateyai yalobai?’ ");
INSERT INTO kud2014_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Na Yeisu iyemaiha iwalo, ‘Loinaone aidiyai Mosese hava ileleleledine. Na hava uvavahiline ana nuwamasele.’ ");
INSERT INTO kud2014_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Na towahowa iwalo, ‘Ehe loinanane teina dova, “Bada yam Yaubada uvelauwei atem yo alu'aluwam yo yam wahiyala yo yam nuwanuwatuwu maudoina aidiyena. Na hinage tomowa vahalimwai taumiya uvelauwedi dova owa ubom amvelaune.” ");
INSERT INTO kud2014_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","‘Neta walo moiha. Ainaena dova upaihowai na yawahim vateyai ulobai.’ ");
INSERT INTO kud2014_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Na towahone inuwatuwuiyoi ebeha iya taudumwalu, ainaena Yeisu hinage ipanivilauyoi, iwalo, ‘Yaiya yede vahaliguwai ana taumiyane?’ ");
INSERT INTO kud2014_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Eena Yeisu walo vegevegediyena towahone ainai iwalo, ‘Ehebo towaho Yelusalemaena itowolo na ilaulau Yeliko ta amwahai tau'aivavali ilobaidi ta hi'abi avivini na ana ale'o hipulihi igabaedi na hitalai ta hiveyababa moiha, muhamuhana imwalowoi, na hilalaugabaeine. ");
INSERT INTO kud2014_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","I'eno'eno na taupwaoli ehebo imahalava ta tausilahene i'i'itane na ilau ta amwahane papalinaena ilalaune. ");
INSERT INTO kud2014_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Na hinage taupwaoli adi boda Livai ehebo imamahalavane ta towahowa i'i'itane na hinage ivinunumohilei na ilalaugabaeine. ");
INSERT INTO kud2014_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","‘Na mulitai ehebo Sameliya imahalava na towahowa i'ita ta i'atemuyamuyaei, ");
INSERT INTO kud2014_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ainaena ilau vahalinai ta woloi na waini imwau mahalavaedi na ana elowone aidiyai ihiwaidi na ipaidi, i'ovi na yana lagulaguwa ainai ivegelu ta baidana hilalaune ehebo vada taumana ainai, ta nemai i'ita'ita avivini. ");
INSERT INTO kud2014_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Malatomtomwai mane siliba bwau ivaidi ta vadane ana tau'ita avivinine imomoheine, na ainai iwalo, “Tausilahe teina u'ita avivini vehabagu, na hinage ebe viha mane ewanai umwauwi vehabana, mata yalau gwaipilema abo yayemaiha alimwai”.’ ");
INSERT INTO kud2014_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ta Yeisu towahone ipanivilaei, iwalo, ‘Hitautonugane aidiyena yaiya tausilahene ana gelu moiha?’ ");
INSERT INTO kud2014_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Na towahowa iwalo, ‘Towahone ana tauvelaune’. Ainaena Yeisu iwalo, ‘Neta walo moiha, ainaena ulau na dova upaihowai’. ");
INSERT INTO kud2014_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Mulitai Yeisu mayana taumulitao hilau ta himahalava ehebo dalava ainai, na waihiu ehebo yehana Malida ilauvaidi ta hilau yana vadai ");
INSERT INTO kud2014_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","na hinage waihiune tahina imiyamiya, yehanaede Meli. Eena Meli ilaoma ta Yeisu vahalinai imiya, yana walo habi benaleina. ");
INSERT INTO kud2014_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Na Malida ai'ai ipaipaihowai, na yana paihowane bagibagilidi. Ainaena Malida ilaoma Yeisu ainai iwalo, ‘Taubada vedova ta tahigune baidam ammiyamiya na nigele iyahaguigaune. Uwalo ta ilaoma ihaguigau.’ ");
INSERT INTO kud2014_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Na Yeisu iwalo, ‘Malida, havena ginauli bagibagilidi vehabadi unuwanuwatuwu. ");
INSERT INTO kud2014_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Na hesi ehebo ta'i ginauli mwala'ina vehabana unuwanuwatuwu, dova tahimne Meli yana vesinuwane. Meli nuwanuwana na yagu walo ibenaledi, ainaena havena teya paihowa igudugudui. ");
INSERT INTO kud2014_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ehebo hauga ainai Yeisu ibom tupwa ehebo ainai i'awa'awanoi. Yana awanoi tuluhanai ana taumulita teya ainai hiwalo, ‘Bada awanoi uve'itagai, dova Yoni ana taumulitao awanoi iveve'itadine’. ");
INSERT INTO kud2014_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ainaena Yeisu aidiyai iwalo, ‘Teina dova am'awanoi amwalo: “Tamamai yeham ave'ahihiyei, na a'awanoi ta owa uloinaegai. ");
INSERT INTO kud2014_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Amai ahubena ehebo ehebo aidiyai umohemohegai. ");
INSERT INTO kud2014_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Na mumugamai yababadi unuwahamuidi, dova ai hinage ama geluwo yadi yababa anuwahamuidi. Na hesi havena towoi mwala'ina umohemohegai.” ");
INSERT INTO kud2014_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Na hinage Yeisu aidiyai iwalo, ‘Awanoi ana mumuga teina dova. Ebe yaiya owa amtaumana masigili holana ilaoma alimwai na nigele teya hava alimwai ebe umohei tamahina vehabana, ainaena howahowana am gelu teya ainai ulau na u'awanoi uwalo, “Augelu, howahowana uhaguigau ebe beledi tonuga umohegau, ");
INSERT INTO kud2014_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","wuwuna ehebo augelu abomohili amwaha daodaowena ilaoma, na nigele teya hava aliguwai ta tamahina yamohei.” ");
INSERT INTO kud2014_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","‘Na ebe towahone vadane holanaena yam walo iyemaihayama iwalo, “Augelu, havena uvetavetausosomana wuwuna manatuguwao a'e'eno, na hinage awa'eda bada yaguduiya'o, ainaena nigele howahowagu na yahaguigo”. ");
INSERT INTO kud2014_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Na ebe i'awa sewa alimwai, bada uhamadudu, ta ebe i'enotowolo na hava yam awanoi dova imohego. ");
INSERT INTO kud2014_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","‘Ainaena nuwamiyai yamwauwi, am'awanoi ta Yaubada imohegomiu. Na ambeha ta amlobai, na am'aigohagoha ta awa'eda iho'e alimiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Moiha ta'i, ebe ta'awanoi Yaubada ainai mata imohe alidai, na ebe tabeha mata talobai, na ebe ta'aigohagoha mata awa'eda iho'e alidai. ");
INSERT INTO kud2014_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","‘Na vedova omiu taulabalaba ebe natumiyao yama vehabana hi'awanoi, mata weso ammohedi? ");
INSERT INTO kud2014_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Bo ebe pou vehabana hi'awanoi, mata alivai ammohedi? Nigele! ");
INSERT INTO kud2014_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Omiu tauyababa, na hesi yami aiyauya natumiyao aidiyai bada amhanahanapui ebeha ginauli namwanamwa a'avadi ammohemohedi. Dova hinage tamamiu galewai yana aiyauya alimiyai inamwanamwa alili, ainaena ebe am'awanoi mata Alu'aluwa Ve'ahihi imohegomiu.’ ");
INSERT INTO kud2014_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yeisu ehebo towaho ilobai iya alu'aluwa yababana yana wahiyalaena memenana ivitai ta nigele howahowana i'aubabada ainaena Yeisu alu'aluwa yababana igabae mahalavaei ta towahonawa inamwanamwa ta i'au'aubabada. Tenem ainai tomowa hi'ita na nuwadi ipwanopwano. ");
INSERT INTO kud2014_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Eeta tupwadi hiwalo, ‘Alawai yadi badane Tomodulele yana ala'alawowoliyena Yeisu alu'aluwa yababana igabae mahalavaei’. ");
INSERT INTO kud2014_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Na tupwadi hinage Yeisu hitowoi na ebeha ila'ilala ehebo ipaihowai vehabadi, ta ebe ainaena hihanapui ebeha yana ala'alawowoli Yaubada ainaena ilalaomane. ");
INSERT INTO kud2014_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Na Yeisu bodaone yadi nuwatuwu bada ihanapuiya'o, ta iwalo aidiyai iwalo, ‘Ebe ehebo abaloina ainai tomowa hivewahewahei na hibom hi'ale'alehauyoidi, mata abaloinane itapiya na ibe'u. Na hinage dova ebe ehebo huhu hibom hi'ale'alehauyoidi mata yadi miya iyababa. ");
INSERT INTO kud2014_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tomodulele dova ebe mayana bodao hi'alehauyoidi, mata yana abaloinane ibe'u. Na vedova ta amwalo ebeha Tomodulele yana ala'alawowoliyena alu'aluwa yababadi yagabagabae mahalavaedi, ");
INSERT INTO kud2014_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","na yaiya yede yana ala'alawowoliyena omiu yami tomowao alu'aluwa yababadi higabagabae mahalavaedine? Tomodulele ainaena bo Yaubada ainaena? Teina vehabana amnuwanuwatuwu na amhanapui ebeha yau yaiya? ");
INSERT INTO kud2014_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Na yau hesi Yaubada yana ala'alawowoliyena alu'aluwa yababadi yagabagabae mahalavaedi ainaena amhanapui ebeha Yaubada yana loina bada imahalava'o alimiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","‘Tomodulele iya dova towaho ehebo wahiwahiyalana na mayana tobwatobwa aleha ainaena yana vada mwala'ina i'ita'ita avivini ta ebe havena teya yaiya yana tobwatobwao i'abi'abiye yababadi. ");
INSERT INTO kud2014_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Na ebe ehebo towaho wahiyalana imahalava, mata towahonane ipai na yana tobwatobwa alehaone itanoidi nimanaena ta ana geluwo imohedi. ");
INSERT INTO kud2014_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","‘Ebe yaiyadiwo hiya nigele agu tauhaguwo hiya agu alehao. Na hinage yaiyadiwo nigele baidaguwao ayapaipaihowa toyawa, hiya yagu paihowa hi'abi'abiye yababa. ");
INSERT INTO kud2014_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","‘Ebe alu'aluwa yababana imahalava towaho ehebo ainaena, towahonane mata inamwanamwa, na alu'aluwawa yababanane mata ilau yabayababauhi na yana abamiya ibehabeha. Na ebe nigele iyalobai mata alu'aluwawa ibom ainai iwalo, “Nuwana ana ita yalau gwaipileuyo yagu abamiyane miyamiyanawa ainai. ");
INSERT INTO kud2014_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Eeta ilau gwaipile ta ilobai abamiyawa masemaselena na atu'atububuna, ");
INSERT INTO kud2014_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ainaena ilau na alu'aluwa 7 yababa alilidi hinage ilauvaidima ta baidanao hiluwu abamiyawa ainai, ta nemai baidanao himiyamiya na towahonane yana miya hi'abiye yababa moiha, na abo mwalona. ");
INSERT INTO kud2014_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Haugana Yeisu i'au'aubabada na ehebo waihiu bodaowa aidiyena alinana mwala'ina Yeisu iwalo auli, iwalo, ‘Waihiu yehana ilalabahigone na ivevehuhugone iya tauyaliyaya moiha’. ");
INSERT INTO kud2014_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Na Yeisu iwalo, ‘Hiya hesi Yaubada yana walo hibenalei na walonane hi'awa'awa abiyei, hiya moiha tauyaliyayaede’. ");
INSERT INTO kud2014_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Haugana bodaone Yeisu hitowolo polupoluwei, ainaena ivetuwuni aidiyai iwalo, ‘Yaso teina yaso yababana! Wuwuna ve'ive'ilala vehabana hi'awanoi na hesi mata nigele Yaubada iya'abiye mahalava aidiyai na ve'ive'ilalane ala'alawowolina neta Yona ibom i'a'abiye mahalavane. ");
INSERT INTO kud2014_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Wuwuna Yona yana paihowa ainaena Nineva hihahanapuine ebeha iya Yaubada ainaena ilaoma. Dova hinage yau Tomowa Moihagu yagu paihowa aidiyena omiu yaso teina amhanapuigau ebeha Yaubada ainaena yalaoma. ");
INSERT INTO kud2014_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","‘Eeta moiha Yaubada yana lauvetala ana ahubena ainai mata Siba yadi tau'alawata itowolo na omiu yaso teina ive'ewaigomiu wuwuna waihiunane amwaha daodaowena ilaoma Solomoni yana walo hanahanapu habi benaleina, na yawalo auligomiu, teina ainai tomowa teya ihae alili abo Solomoni. ");
INSERT INTO kud2014_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","‘Dova hinage Yaubada yana lauvetala ana ahubena ainai hiya Nineva mata yaso teina hive'ewaigomiu wuwuna Yona aidiyai iguguya ta yadi mumuga yababadi aidiyena hinuwabui'o, na yawalo auligomiu, teina ainai tomowa teya ihae alili na abo Yona. ");
INSERT INTO kud2014_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","‘Mata nigele teya yaiya lampa iyagabu na iyadawadawani guda ainai bo gaeba alonai, na hesi imwauhini abamwau ewanai ta vada ana tauluwuwo i'abiye maseledi. ");
INSERT INTO kud2014_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ainaena mehemne taum ana masele dova, ta ebe mehem masemaselena taum maudoina masele i'oiye mwau. Eena ebe mehem iyababa mata taum maudoina iguguyou. ");
INSERT INTO kud2014_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ainaena u'ita avivini mata dova ta yam maselene iguguyou. ");
INSERT INTO kud2014_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Na ebe taum maudoina masele i'oyemau, na nigele teya guguyou ainai, maudoina mata masemaselena dova lampa mwala'ina yana masele. ");
INSERT INTO kud2014_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yeisu i'aubabada i'ovi, na ehebo Palisi Yeisu iyogaei na baidana hi'ai eeta iluwu na imiya aba'ai ainai. ");
INSERT INTO kud2014_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Na Palisine nuwana ipwanopwano wuwuna i'itaya'o Yeisu nimanane nigele iyauwadi na i'ai'ai. ");
INSERT INTO kud2014_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Na Yeisu Palisine bada yana nuwatuwu ihanapuiya'o, ta ainai iwalo, ‘Omiu Palisiwone dova vedi na gaeba, wuwuna dagela a'avadi amuwadi, na hesi holamiune imwau aiduma yo mumuga yababadi aidiyena. ");
INSERT INTO kud2014_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Omiu buwa! Yaubada ginauli maudoidi dageladi ipaihowaidi eeta iya hinage holadi ipaihowaidi. ");
INSERT INTO kud2014_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Na ebe yami atemuyamuyaena tauwewelohe hagu ammohemohedi neta mata omiu taumasele. ");
INSERT INTO kud2014_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","‘Omiu Palisiwone nuwayabayababamiu! Yami ginauli maudoina 10 na alodiyai ehebo. Yaubada ammohemohei, ginauliwone dova haiyala yo pam yo ai'ai adi abiye namwanamwa maudoidi. Na hesi mumuga dumwaluna na Yaubada ana velau nigele vehabadi amyanuwanuwatuwu. Teina paihowaone neta ginauli mwala'idi ebeha ammulitaedi, na yami aiyauya Yaubada ainai havena amnuwanuwapwanopwanowedi. ");
INSERT INTO kud2014_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","‘Omiu Palisiwone nuwayabayababamiu wuwuna vada tapwalolo aidiyai nuwanuwamiu abamiya namwanamwadi aidiyai ammiyamiya, na hinage nuwanuwamiu ebeha tomowa hivelavelauwegomiu abagimwala aidiyai ve'ahihiyena hive'ahihiyegomiu. ");
INSERT INTO kud2014_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","‘Omiu nuwayabayababamiu, wuwuna ami ita dova magai nigele ila'ilaladi na ewadiyena tomowa hilaulau.’ ");
INSERT INTO kud2014_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Eena ehebo loina ana tauve'ita iwalo Yeisu ainai, iwalo, ‘Tauve'ita yam walowone teina aidiyena ai hinage uhinahinaligai!’ ");
INSERT INTO kud2014_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Na Yeisu iwalo, ‘Omiu loina ana tauve'itao nuwayababamiu, wuwuna tomowa vitai mwala'idi nigele howahowadi na hi'avalaidi na omiu hesi amve'ave'avalaidi. Na omiu nigele habuluna nima gigimiu ehebo amyatuwu ta tenem vitaine amya'abitowoi. ");
INSERT INTO kud2014_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","‘Nuwayabayababamiu, omiu wuwuna tubumiyaowa tauwalo mahalavao higogohaye mwalowoidiwa adi magaiwone am'abi ili'ilimanidi. ");
INSERT INTO kud2014_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Eeta paihowanane ainaena tubumiyaowa am'awa'awa namwanamwaedi, ebeha hiya tauwalo mahalavaowa hi'oiye mwalowoidi'o na omiu adi magaiwowa aidiyai adi abanuwatuwu avivini am'abi'abidi. ");
INSERT INTO kud2014_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ginauli teina vehabadi Yaubada yana hanapu imwauwi, iwalo, ‘Howola abo tauwalo mahalavao yo yagu tauyewasao yavetamalediwa, na tupwadi am'oiye mwalowoidi na tupwadi am'abiye muyadi’. ");
INSERT INTO kud2014_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ainaena yaso teina mata maiha maudoina amlobai tauwalo mahalavaowa himwamwalowoiwa bale'u yana abavetuwuni ainaena ta wau vehabadi, ");
INSERT INTO kud2014_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Neta Abeli hi'oiye mwalowoi na ainaena hi'oi'oiye mwalowoi ana higa Sekalaya hi'oiye mwalowoi vada tapwalolo ana abapwaoli ve'ave'ahihina ahi'ahipudiyai. Ainaena oiye mwalowoi maudoina adi maiha yaso teina mata amlobai. ");
INSERT INTO kud2014_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","‘Na hinage omiu loina ana tauve'itao nuwayabayababamiu wuwuna hanapu ana amwaha amguduiya'o, ta omiu nigele howahowana amluwu, na hinage hiya nuwanuwadi na hiluwu amguduguduidi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Haugana Yeisu dalavanane ilaugabaei loina ana tauve'itao yo Palisiwo hiwalo dobidobiyei. Na ginauli bagibagilidi vehabadi hipanivilaei, ");
INSERT INTO kud2014_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ebeha vedova na yana walohapuli hilobai ta ainaena hive'ewai. ");
INSERT INTO kud2014_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Boda mwala'ina hihuluhulu'ahaiyama ta hitupatupauyoidi, na Yeisu iwalo mugai ana taumulitaowo aidiyai iwalo, ‘Am'ita avivinigomiu na havena Palisiwo yadi paihowa oya'oyama ampaipaihowaidi, wuwuna yadi paihowa dova pwalawa ana abi yeseseha. Aba'abiye sesehane ebe hava habuluna mata i'abiye mwala'i, ");
INSERT INTO kud2014_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","na ginauli dawadawanidi howola Yaubada abo i'abiye mahalavaedi, na hihanapui. ");
INSERT INTO kud2014_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Na hinage hava guguyou ainai amwalowalowedi mata ahubena aidiyai tomowa hibenaledi. Na hava nuwana vehabana amwalo himhim vada holanai mata tomowa maudoina aidiyai hiwalo mahalavaei. ");
INSERT INTO kud2014_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","‘Na augeluwo yavenuwamwauwegomiu, hiya taumiu adi tau'oiye mwalowoi, havena ammehemeheuhedi, wuwuna hiya taumiu ibom howahowana na hi'oiye mwalowoi na alu'aluwamiu nigele howahowadi. ");
INSERT INTO kud2014_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Na hesi Yaubada ammeheuhei, wuwuna iya howahowana dalava ala'alahina ainai taumiu na alu'aluwamiu iveyababa bwauwedi. Moiha iya ibom ammeheuhei! ");
INSERT INTO kud2014_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","‘Viha dova lowolowo adi maiha? Nigele mwala'ina, dova toea bwau na lowolowone adi bagibagili nima ehebo. Na Yaubada nigele lowolowone ehebo iyanuwapwanopwanowei. ");
INSERT INTO kud2014_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Na hinage ulu'ulumiu vahudi maudoidi Yaubada ivahili ve'ovidi. Ainaena havena ammehemeheuhi, wuwuna omiu amhae alili na abo lowolowo bodadi. ");
INSERT INTO kud2014_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","‘Teina hinage amhanapu ili'ilimani. Ebe yaiyadiwo vehabagu tomowa mehediya hiwalo mahalava, yau Tomowa Moihagu mata yawalo mahalavaei Yaubada yana Tausagenawasao mehediya. ");
INSERT INTO kud2014_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Na ebe yaiyadiwo hiuvalaegau tomowa mehediya, yau hinage howola Yaubada yana tausagenawasao mehediya yauvalaedi. ");
INSERT INTO kud2014_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","‘Yau Tomowa Moihagu ebe yaiya i'awa yabayababaegau Yaubada mata inuwahamui. Na ebe yaiya Alu'aluwa Ve'ahihi i'awa yabayababaei, mata nigele Yaubada iyanuwahamui. ");
INSERT INTO kud2014_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","‘Na ebe tomowa hilauvaigomiu vada tapwalolo aidiyai habi lauvetala babadao yo tauloinao mehediyai havena ammehemeheuhi nuwana amnuwanuwatuwu vedova mata yadi panivila amyemaihadine, ");
INSERT INTO kud2014_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","wuwuna hauganane ainai Alu'aluwa Ve'ahihi baidamiu, na iya mata ive'itagomiu hava mata amwaloweine.’ ");
INSERT INTO kud2014_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Bodaone aidiyena towaho ehebo iwalo, ‘Tauve'ita, tahigu ainai uwalo ta tupwana abaloina imohegau mwalona tamamaiwa iwawaloweine’. ");
INSERT INTO kud2014_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Na Yeisu towahone yana walo iyemaiha, iwalo, ‘Augelu, yaiya loina imohegau ta ebeha yavetauloina bo yave'aha alimiyai?’ ");
INSERT INTO kud2014_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Na hinage yana walone itubwei ta boda maudoidi aidiyai iwalo, ‘Am'ita avivinigomiu na havena wasawasa nuwamiu ivaivai, wuwuna nigele mata wasawasa ainaena yawahi namwanamwana amyalobai. ");
INSERT INTO kud2014_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Eeta ehebo aba'ita imohedi walo vegevegediyena, iwalo, ‘Ehebo tauwasawasa yana tanovi mwala'idi na bagibagilidi ta ai'ai mwala'ina aidiyena ilobai. ");
INSERT INTO kud2014_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ainaena towahonane ibom inuwanuwatuwu, ta iwalo, “Ai'ai mwala'ina na yagu vadavada nigele howahowana. Ainaena mata hava yapaihowaine? ");
INSERT INTO kud2014_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nuwana vadavada miyamiyadiwa yalo'e vehuludi na vauvaudi yo mwala'idi ya'abidi ta ai'ai yo yagu ginauli maudoina aidiyai yamwauwidi, ");
INSERT INTO kud2014_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","na mulitai mayagu yaliyaya yawalo, ‘Yau tauwasawasa ehebo bada ya'atububuni vateyai'o na yagu wasawasaone maudoina howahowana bolimai viha hilalaoma vehabadi. Eeta paihowa ainaena ya'aiyawasi na hesi yaliyaya ta'i, wuwuna bada agu yo agu we'aha maudoina howahowagu.’” ");
INSERT INTO kud2014_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","‘Na hesi Yaubada towahowa ainai iwalo, “Owa, yauyaulem! Masigili teina ainai yawahim yavaivehulu. Na teina ginauliwone u'abinonovaidine mata yaiya vehabana.” ’ ");
INSERT INTO kud2014_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Na Yeisu yana walo aba'ovi ainai iwalo, ‘Teina dova mata hiya wasawasa hibom vehabadi hihiwahiwagogoi mata nigele hiyavewasawasa Yaubada mehenai.’ ");
INSERT INTO kud2014_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Eena ana taumulitaowo aidiyai iwalo, ‘Havena yami miya bale'u vehabana amnuwanuwatuwu mwala'ina, amiu yo ami ale'o vehabana. ");
INSERT INTO kud2014_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Wuwuna yawahida ginauli mwala'ina maudoida alidai na ginauli tau vehabadi nigele ginauli mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","‘Teina teya aba'ita yamohegomiu ao'ao vehabana hauga maudoina nigele hiyalaulaupeli, nuwana hiyalaulau'eli, na hinage nigele yadi vadavada, na Yaubada hauga maudoina ai'ai imohemohedi; na hesi omiu amhae alili abo 'ao'ao. ");
INSERT INTO kud2014_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Yaiya alimiyena yana nuwatuwu ainaena howahowana yana hauga bale'uwai i'abiye daodao? Nigele awa? ");
INSERT INTO kud2014_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ebe nigele howahowamiu na ginauli habuludi ampaihowaidi, hava vehabadi vagadi vehabadi am'ate'atehawawaline? ");
INSERT INTO kud2014_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","‘Na hinage teina teya aba'ita, pwalawasi yadi ini vehabana amnuwanuwatuwu. Hauga maudoina nigele hiyapaipaihowa, na hinage nigele adi ale'o hiyapaipaihowadi. Na moiha, Solomoni ana ale'owone yo ana pasaone adi ita namwanamwadi, na hesi pwalawasi adi ita hinamwanamwa alili. ");
INSERT INTO kud2014_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ainaena amnuwanuwatuwu Yaubada yana ita'avivini alimiyai vehabana. Iya nu'ula iyepasadi pwalawasi namwanamwadi aidiyena, mata hitaya na i'ahubena hiwelai na higabudi, na omiu nu'ula pwalawasidi amnamwanamwa gabaei, ainaena howahowana ami ale'o imohegomiu. Eeta havena yami yemidi Yaubada ainai ibelubelu. ");
INSERT INTO kud2014_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ainaena havena amnuwanuwatuwu mwala'ina yo am'ate'atehawawali ai'ai yo we'aha vehabadi. ");
INSERT INTO kud2014_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Taumiya bale'u maudoidi ginauli teina vehabadi hinuwanuwatuwu, na hava yami nuwanuwatuwu Tamamiu bada ihanapuidi'o. ");
INSERT INTO kud2014_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Na ilowoinanegomiu ebe mugai Yaubada yana loina ambehaei, ta ainaena ginauliwone imohegomiu. ");
INSERT INTO kud2014_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Eeta moiha, omiu Tamamiu yana sipiwo, ta havena ammehemeheuhi, wuwuna bada ivesinuwagomiu'o ta ebe yana abaloina ainai amluwu. ");
INSERT INTO kud2014_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","‘Na yami tobwatobwao amvegimwalaedi na manedine am'aiyauyanedi tauwewelohe aidiyai, ta ebe galewai yami wasawasa imiyavateyai. Wasawasane galewai imiyamiyane nigele yana aba'ovi, wuwuna nigele teya tau'aivavali tupwanane ainai, yo hinage nigele hulahula. ");
INSERT INTO kud2014_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Eeta amhanahanapui neta aiteya tupwa ainai yami wasawasa imiyamiyane neta ainai yami nuwatuwu isagena. ");
INSERT INTO kud2014_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","‘Eeta am'abinonovai ili'ilimani ta ami luwuluwu amli'wadi, na hinage mayami lampa masemaseledi amha'waha'wa, ");
INSERT INTO kud2014_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","dova taupaihowao yadi taubada hiha'waha'wai yana laugwaipilema tawahola mahulina vehabana. Eeta ebe aiteya hauga ainai imahalava na awa'eda ainai i'aigohagoha, mwayamwayau awa'edane hiho'e ta iluwu. ");
INSERT INTO kud2014_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ainaena ebe hihilahilawa na hi'atu'atububuni na hiha'waha'wa na ilobaidi, mata hiyaliyaya mwala'ina. Na yawalo moiha, yadi taubadane mata luwuluwu abapaihowa ili'wadi ta taupaihowao himiya na iya vehabadi ivetaupaihowa. ");
INSERT INTO kud2014_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Na hinage ebe yana hauga laugwaipile ainai na ibwedabweda ta masigili holana bo nuwana i'ahu'ahubena na imahalava na bada dova yadi miyamiyane na ilobaidi, mata hinage hiyaliyaya mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","‘Hinage ginauli ehebo teina amnuwatuwu avivini ebe vada taniwagana ihanapui aiteya hauga ainai tau'aivavali iluwuluwune yana vadai, i'atububuni ili'ilimani na ihilahilawa ta ebe havena yana vadane ipapapapa. ");
INSERT INTO kud2014_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ainaena omiu hinage am'atububuni ili'ilimani, wuwuna yau Tomowa Moihagu yagu laugwaipilema ana mahana ainai amwalo mata nigele yayalaoma neta ainai mata yalaoma.’ ");
INSERT INTO kud2014_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Eena Pita iwalo, ‘Bada, neta ai vehabamai uwalowalone, bo tomowa maudoidi vehabadi?’ ");
INSERT INTO kud2014_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Na Yeisu iwalo, ‘Taupaihowa namwanamwadi na hanahanapudi yadi mumuga teina dova, ebe yaiya iya yana taubada ivesinuwaei na vada i'ita avivini, na ana geluwo ai'ai imohemohedi ahubena ehebo ehebo. ");
INSERT INTO kud2014_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Na yana taubadane ilau gwaipilema ta yana taupaihowane ilobai yana paihowa dumwaluna, mata vehabana iyaliyaya na ainai iwalo, ");
INSERT INTO kud2014_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","“Yam paihowa namwanamwana vehabana mata ginauli maudoina adi loina yamohego ta uloina”. ");
INSERT INTO kud2014_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Na ebe taupaihowane ibom ainai iwalo, “Yagu taubadane howola ibwedabweda”, ainaena yabom yagu nuwatuwu yapaihowaidi. Ainaena ana geluwo towatowaho yo waiwaihiu italatalaidi, yo nigele ai'ai iyamohedi, na ibom i'ai'ai yo inumanuma ta inuma yauyaule. ");
INSERT INTO kud2014_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Na mulitai abo yana taubadawa ahubena ehebo ainai mata ilaoma. Na yana laomane neta taupaihowane yana nuwatuwu ebeha mata nigele iyalaoma ta mahanana havena ihanahanapui. Na mata iyemaiha ta taupaihowawa awa'awasewanane baidana imwau eheboidi. ");
INSERT INTO kud2014_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","‘Ainaena ebe yaiya yana Taubada yana nuwatuwu ihanahanapui na nigele iyapaihowai mata sapi mwala'ina ive'alo. ");
INSERT INTO kud2014_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Na taupaihowa yaiya yana taubada yana nuwatuwu nigele iyahanapui, na ipaihowa pwanoli, mata sapi ive'alo, na nigele mwala'ina mata iyavai. Na hava mwala'ina ilolobaine ebeha mwala'ina italamwei. Na yaiya ainai mwala'i alilina tomowa himwaumwauwi, hiya mata yadi awanoi mwali'i alilina hipaihowai.’ ");
INSERT INTO kud2014_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","‘Yalaoma ebeha aiwa yayuvi bale'uwai ta nuwanuwagu imwayamwayau na i'ala hawawali. ");
INSERT INTO kud2014_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Na hesi hauga muhamuhana na bapitaiso muyamuyana mata yalobai, ainaena mayagu ate hawawali, ana higa bapitaisonane aliguwai hipaihowai. ");
INSERT INTO kud2014_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","‘Na vedova? Yami nuwatuwu ebeha yagu laoma bale'uwai neta daumwali amlobai? Nigele ta'i. Na hesi yawalo alimiyai, ebeha mata aleha yo wahei alimiyai himahalava. ");
INSERT INTO kud2014_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Hauga teina aidiyena na hauga hilalaoma aidiyai, mata huhu aidiyena wahei himahalava. Huhuwone alodiyai ebe tomowa adi bagibagili dova nima ehebo, mata alodiyena hitau tonuga himanini hitau bwau aidiyai bo hitau bwau himanini hitau tonuga aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mata hiwahei ta tama natuna towahona ive'alehaei, na natu towahona tamana ainai ive'aleha. Hinage mata hina natuna waihiuna ive'alehaei na natu waihiuna hinana ainai ive'aleha. Aihale mata lawana ive'alehaei na wainiune mata lawanane aihalewa ive'alehaei.’ ");
INSERT INTO kud2014_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yeisu hinage tomowaone aidiyai iwalo, ‘Haugana ebe am'ita bolibolime yalovi gibagibadi hihaehaema, amhanapuiya'o ebeha mata i'wesu, neta moiha. ");
INSERT INTO kud2014_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na ebe tupwa yalasi ainaena yaumai itowatowama, neta bada amhanapuiya'o ebeha hauga muhamuha na mahavai imahalava. ");
INSERT INTO kud2014_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Moiha, omiu bale'u adi ila'ilalao amhanahanapuidi na hesi Yaubada yana ila'ilalao nigele amyahanapuidi hauga vauvauna mehedai vehabana. Teina yami oyama. ");
INSERT INTO kud2014_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","‘Na hava wuwuna ta nigele amyavesinuwa ili'ilimani ta amwaha dumwaluna ainaena amyalaune? ");
INSERT INTO kud2014_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Na ebe am'aleha ilaoma na i'itago ebeha ilauvetalaego, ilauwainanei ebe haugana amlaulau amwahai, utowoi na lauhapuliwa upapaihowaiwa u'abiye dumwalu, ta ebe havena amtaulauvetalane ilawelawego tauloina ainai, mata dova ta tauloinane vada paipai ana tau'ita avivini iloinaei ta vada paipaiyai imwauwigo. ");
INSERT INTO kud2014_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na yawalo moiha mata nigele hiya livahigo vada paipaiyena ana higa am vagavaga maudoina uyemaiha ve'ovi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Hauganane ainai tupwadi tomowa hilaoma ta Yeisu ainai hi'aubabada, taumiya Galili vehabadi, hiwalo, ‘Taubada, taumiya Galili tupwadi hitapwatapwalolo Yaubada ainai na Pailato yana tau'alehao iloinaedi ta tomowadine hi'oiye mwalowoidi'o na 'wahinadi lagulagu 'wahinadi baidana iyeyebweline’. ");
INSERT INTO kud2014_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Eena Yeisu iwalo, ‘Yami nuwatuwu ebaha hibom tauyababao moiha, ainaena hi'oiye mwalowoidine, awa? Nigele! Taumiya Galili maudoidi yadi yababao bada dova. ");
INSERT INTO kud2014_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Na omiu mata ammwalowoi bada dova hibom, ebe yami mumuga yababa aidiyena nigele amyanuwabui. ");
INSERT INTO kud2014_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Na vedova yami nuwatuwu Siloamao hitau 18 vehabadi, haugana vada haliyana daodaona iguli ta'i'ohamuidine, ebeha hibom yadi mumuga yababa alilina taumiya Yelusalem maudoidi aidiyena, eeta mwalowoinane hilolobaine? ");
INSERT INTO kud2014_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nigele ta'i! Omiu hinage ebe nigele yami mumugao aidiyena amyanuwabui, mata ammwalowoi hitau 18 dova.’ ");
INSERT INTO kud2014_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mulitai ehebo hinage walovegevegedi imohedi, iwalo, ‘Ehebo towaho yana oyai aiwa dova mawiho i'umai. Na hauga bagibagilina ilaolaoma aiwanane ainai ta ebe ainona igigi, na hesi nigele teya hauga ainona iyalobai. ");
INSERT INTO kud2014_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ainaena yana oyane ana tau'ita avivinine iwalo auli, iwalo, “Bada uhanapuiya'o ebeha bolimai tonuga yalaolaoma teinai mawiho ainona habi gigina, na hesi nigele teya ainona yayalobai. Teina hauga ugohavehulu wuwuna bale'u namwanamwana ini'ini awawai!” ");
INSERT INTO kud2014_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","‘Na tau'ita aviviniwa yana taubadane iwalo auli, iwalo, “Taubada, badagi! Havena yagohagoha vehulu, na hesi yana yababa yabehaei na gawala ainai yamwauwi na vali bolimaine ainai ta'ita, ");
INSERT INTO kud2014_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","na ebe i'aino, bada ta'i itowotowolo; na ebe nigele iya'aino, abo tagoha vehulu.” ’ ");
INSERT INTO kud2014_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ehebo tapwalolo ainai Yeisu vada tapwalolo ainai iluwu ta ive'ive'ita. ");
INSERT INTO kud2014_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na ehebo waihiu imiyamiya, na bolimai 18 holanai alu'aluwa yababana ainai imiyamiya, ainaena ilovalovala, na yana lau neta ilaulau pwagopwagogo, na nigele howahowana itowolo ta ilau dumwadumwalu. ");
INSERT INTO kud2014_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ta Yeisu waihiunane i'ita ta iyogaei, iwalo, ‘Waihiu, ulaoma’. Ilaoma na iwalo auli, iwalo, ‘Aihale, amlovala ainaena yalivahigo’. ");
INSERT INTO kud2014_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Mai ehebo na itowolo dumwadumwalu ta Yaubada iwalo vetuvehaeyeine. ");
INSERT INTO kud2014_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Teina ainai vada tapwalolo ana tau'ita aviviniwa Yeisu yana paihowane i'ita, na ana modi'i'ini wuwuna tapwalolowai taulovala i'abiye namwanamwa, ainaena towahowa boda aidiyai iwalo mahamahalava iwalo, ‘Maudoida, laugagayo tahanahanapui neta ahubena 6 aidiyai yada paihowao tapaipaihowaidi. Teina nigele ana itane iyanamwanamwa ebe tapwalolowai taulovalao hilawedima na adi lovalao habi abiye namwanamwadi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Eeta yana walo Bada iyemaiha iwalo, ‘Omiu ita oya'oyama ampaipaihowai. Nigele teya yaiya yana bulumakau bo yana doniki tapwalolowai iya livahi ta iya numanuma, bo? ");
INSERT INTO kud2014_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Na vedova waihiune yami nuwatuwune ta ebeha havena yana miyavitai ainaena yalivalivahi na hagu ilobai dova yami lagulaguwone. Teina waihiune iya Abelaham yana boda ehebo, na hesi Tomodulele bolimai 18 holanai i'abi'abi avivini.’ ");
INSERT INTO kud2014_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yeisu yana walo teina ainaena tau'awa ulumwowa ivehinimayadi, na hesi boda ibagibagili alili hiyaliyaya mwala'ina Yeisu yana paihowa wahiwahiyaladi vehabana. ");
INSERT INTO kud2014_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Mulitai bodaone aidiyai hinage iwalo, ‘Vedova mata Yaubada yana Abaloina yayemaselene alimiyai. Nuwana tenem dova, ehebo aiwa ainaena yalivahi. ");
INSERT INTO kud2014_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Towaho ehebo haiyala patuna ivai ta maseleyai i'umai ta imwala'i, na mulitai lowolowo hilaoma ta yadi noi lagalaganaone aidiyai hi'a'abidine.’ ");
INSERT INTO kud2014_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","I'ovi na iwalo aulidi, iwalo, ‘Walo vegevegedi teina vedova mata yayemaselene ta ebe ainaena Yaubada yana Abaloina amhanapui? ");
INSERT INTO kud2014_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nuwana tenem dova: Waihiu ehebo pwalawa ana aba'abiye seseha habuluna ta'i ivai ta pwalawa mwala'ina baidana ivivilaine, ainaena pwalawawa maudoina iseseha.’ ");
INSERT INTO kud2014_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Haugana Yeisu ilaulau Yelusalem na amwahai tupwadi dalava mwala'idi yo habuludi aidiyai imahalava ta aidiyai ive'ive'ita yo iguguguguya. ");
INSERT INTO kud2014_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Na ehebo towaho Yeisu ipanivilaei, iwalo, ‘Taubada, vedova? Nuwana mata tomowa vihavihadi livahi hilobai, awa?’ ");
INSERT INTO kud2014_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Na Yeisu iwalo, ‘Ehe, dova, na hesi amtowoi wahiyala ta amluwu amwahanane dinodinona ainaena. Wuwuna bagibagilidi hitowotowoi na ebeha hiluwu ta hi'aipate ahaya. ");
INSERT INTO kud2014_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Na mata hinage vadane taniwaganane amwaha igudui na omiu maseleyai amtowotowolo na awa'edai am'aigohagoha, na amdoudou, amwalo, “Taubada, awa'edane uho'e na aluwuwa.” ‘Na mata taubadanane yami walo iyemaiha na alimiyai iwalo, “Havanaena amlalaomane? Nigele yayahanapuigomiu!” ");
INSERT INTO kud2014_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","‘Na ebe omiu amyemaiha amwalo, “Ai mugai baidamwao ta'ai'ai, yo tanumanuma toyawa. Na hinage yama dalavai alimaiyai uve'ive'ita”. ");
INSERT INTO kud2014_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","‘Eena mata taubadanane iwalo, “Moiha, nigele yayahanapuigomiu. Havanaena amlalaomane? Amlau gwaipile na havena amluwuluwuma wuwuna omiu yababamiu!” ");
INSERT INTO kud2014_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","‘Na mulitai mata Abelaham yo Aisake yo Yakobo yo hinage tauwalo mahalavao maudoidi baidadiyao am'itadi Yaubada yana Abaloinai himiyamiya na omiu mayami dou yo mayami sala tau'alahe hauganane ainai mata tulutuluhai ammiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Na dalava maudoina aidiyena boda hilaoma ta yadi abamiya namwanamwadi hivaidi Yaubada yana Abaloinai. ");
INSERT INTO kud2014_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Eeta ebe yaiyadiwo teina ta'i himugamugai howola abo himulita, na yaiyadiwo himulimulita howola abo himugai.’ ");
INSERT INTO kud2014_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tenem haugane ainai tupwadi Palisiwo hilaoma na Yeisu hiwalo auli, hiwalo, ‘Teina ta'i umwayamwayau na udena, mata dova ta Helodi i'oiye mwalowoigo!’. ");
INSERT INTO kud2014_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Eena Yeisu aidiyai iwalo, ‘Amlau na taumaninine amwalo auli mata teina ta'i alu'aluwa yababadi tomowa aidiyena yavehulu mahalavaedi, na taulovalao ya'abiye namwanamwadi, na i'ahubena hinage dova, na i'ahubenauyo yagu paihowa maudoina yave'ovi. ");
INSERT INTO kud2014_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","‘Na yau howola yalalau Yelusalem, mata yo i'ahubena yo i'ahubenauyo yamahalava, na nemai yamwalowoi, wuwuna tauwalo mahalavao maudoimai yama abamwalowoi Yelusalem’. Ainaena Yeisu nuwanane iyababa ta Yelusalem vehabana idodoune, iwalo, ");
INSERT INTO kud2014_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","‘Oo kaiyoni Yelusalem, kaiyoni Yelusalem, vedova ta tauwalo mahalavao oiyemwalowoidine, na hinage Yaubada yana tauyewasao ulau gaimaidine? Hauga bagibagilina nuwanuwagu na yam bodao yayoga ahaidima dova am'am natunao pepenaena i'oi'au'auhidi, na bada hita'wata'wataegau'o! ");
INSERT INTO kud2014_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ainaena mata Yaubada yam vada tapwalolo mwala'ina ilaugabaei, na yawalo auligo mata nigele hinage uya'itauyoigau ana higa yam bodao hitalam aliguwai na hiwalo, “Iya Yaubada yehanaena ilalaomane tawalo vetuvehaeyei”.’ ");
INSERT INTO kud2014_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tapwalolo ehebo ainai Yeisu ilau habi ai Palisi yadi taumugai ehebo yana vadai. Vadanane ainai iluwuluwu na boda hivinuvinunui, ");
INSERT INTO kud2014_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","wuwuna tenem ainai ehebo taulovala imiyamiya, tauna maudoina hiseseha. ");
INSERT INTO kud2014_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Eena Yeisu taulovalane vehabana ipanivila loina ana tauve'itao yo Palisi aidiyai, iwalo, ‘Vedova yami nuwatuwu? Howahowana ebe taulovala ahubena Tapwalolo ainai ta'abiye namwanamwa bo nigele?’ ");
INSERT INTO kud2014_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Na yana walone nigele hiyayemaiha na mulitai Yeisu taulovalane nimanai i'abi na ana lovalawa i'abiye namwanamwane. Eena ivetamalei ta ilalaune yana dalavai. ");
INSERT INTO kud2014_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ilaulau na Yeisu i'ita gwaipile aidiyai iwalo, ‘Yaiya ebe mayana lagulagu dova hosi bo bulumakau na ebe teya lagulagune ahubena Tapwalolo ainai ibe'u guda ainai, mata vedova? Howahowana iniulihini bo nigele? ");
INSERT INTO kud2014_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Na hiya bada nigele teya yadi walo.’ ");
INSERT INTO kud2014_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Aine holanai Yeisu tomowa i'itadi nuwanuwadi abamiya namwanamwana ainai himiyamiya, eeta ehebo walo vegevegedi imohedi, iwalo, ");
INSERT INTO kud2014_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","‘Ebe yaiya yana dalavai iyogaego tawahola guyauna vehabana havena abamiya namwanamuwana ainai umiyamiya wuwuna mata dova ta teya towaho mwala'ina ilaoma, ");
INSERT INTO kud2014_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","na guyaune taniwaganane iwalo alimwai na ulau papaliyai na yam abamiyane ainai towahowa mwala'inawa imiya. Na owa mata mayam hinimaya umiya aitulu. ");
INSERT INTO kud2014_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ainaena ebe hiyogaego na ululuwu aidiyai abamiya papaliyai uvesinuwaei ta ainai umiya, na ebe haugana guyau taniwagana ilaoma i'itago mata alimwai iwalo, “Augelu umiyahae ahipuwai, eeta ma'am walo vetuvehae tomowa mehediyai”. ");
INSERT INTO kud2014_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Teina ainaena tahanapui ebeha yaiya i'abihiniuyoi mata howola himwau aituluwei na ebe yaiya imwau aituluweuyoi mata himwauhini ewai.’ ");
INSERT INTO kud2014_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ainaena Yeisu Palisinane iyogaei na ainai iwalo, ‘Ebe ai'ai upaihowai, havena am geluwo yo tahimwao yo yam bodao yo tauwasawasao uyogayogaedi aine ainai, wuwuna hibom howola abo hiyogaego habi yemaiha alimwai. ");
INSERT INTO kud2014_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Na hesi ebe ai'ai upaihowai hiya wewelohewo yo yabayababadi yo peupeudi yo hiya taumehegibugibu uyogaedi, ");
INSERT INTO kud2014_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ta ebe awanamwanamwa moiha ulobai, wuwuna hiya nigele howahowadi na yam velaune hiyemaiha. Na hesi Yaubada ainaena mata ammaiha ulobai, haugana taunamwanamwa mwalowoiyena i'abiye towolodi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Eeta baidanao hi'ai'ai na ehebo aidiyena walo teina ibenalei ta Yeisu iwalo auli iwalo, ‘Ehe dova! Ebe yaiyadiwo hiluluwu Yaubada yana Abaloina ainai na hi'ai mata hiyaliyaya mwala'ina.’ ");
INSERT INTO kud2014_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ainaena Yeisu towahonane yana walo iyemaiha iwalo, ‘Ehebo towaho ai'ai mwala'ina ipaihowai na tomowa maudoidi iyogaedi. ");
INSERT INTO kud2014_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Na ai'ai i'atububuni ta yana hevali ivetamalei tomowa aidiyai na iwalo, “Bada ai'ai hi'atububuya'o ainaena amlaoma talau na ai'ainane am'ai”. ");
INSERT INTO kud2014_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","‘Na maudoidi nigele nuwadi, eeta vali walo yo vali walo himohei. Ehebo iwalo, “Bada tanovi vauvauna yagimwalaiya'o ainaena nuwana yalalau na yataubo'eyei. Na yauwedo mwala'ina, mata nigele yayalaowa.” ");
INSERT INTO kud2014_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","‘Na ehebo hinage iwalo, “Yauwedo mwala'ina, na yau hinage mata nigele yayalaowa wuwuna bulumakau 10 na hinage abatudai 5 bada yagimwalaidi'o ainaena yalalau ebeha yayepaihowadi”. ");
INSERT INTO kud2014_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","‘Na hinage ehebo iwalo, “Yau vauvaugu yatatawaholane ainaena nuwana mata nigele yayalaowa”. ");
INSERT INTO kud2014_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","‘Ainaena hevaliwa ilau gwaipile yana taubadawa ainai iwalo, “Maudoidi nigele nuwadi”. Na vadane taniwaganane imodi'ini ta yana taupaihowane ainai iwalo, “Ulau mwayamwayau dalava mwala'ina adi amwahao maudoidi aidiyai na viha tomowao ulobaidi wewelohedi yo tapitapiyadi yo mehegibugibudi yo yabayababadi besiwa ulauvaidima maudoidi ta hi'ai”. ");
INSERT INTO kud2014_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","‘Eeta hevaliwa ipaihowai dova na mulitai ilaoma na iwalo, “Taubada, tomowaone yayogaedima'o na hesi yam vadane nigele hiya'oiye mwau?” ");
INSERT INTO kud2014_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","‘Hinage Taubadawa iwalo, “Amwaha maudoidi aidiyai ulau na tomowa ulauvaidi ta hilaoma yo yagu vadane hi'oiye mwau. ");
INSERT INTO kud2014_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Na hesi tomowaowa yayoyogamugaiyediwa mata nigele teya aidiyena yagu ai'aine iya'aisawahi.” ’ ");
INSERT INTO kud2014_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Boda mwala'ina baidanao hilaulau ta Yeisu i'ita gwaipile na iwalo, ");
INSERT INTO kud2014_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","‘Yaiya ebe nuwanuwana na imulitaegau mugai inuwaleleyegau na tamana yo hinana yo natunao yo tahinao yo nuhunao na hinage ibom ita'wata'watauyowei. Na ebe nigele, iya nigele agu taumulita. ");
INSERT INTO kud2014_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Na ebe yaiya yawahina nigele iyatalamwei na imwalowoi aiwa lagalagana ainai, iya nigele howahowana na imulitaegau. ");
INSERT INTO kud2014_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","‘Na yaiya inuwanuwatuwu ebeha vada haliyana daodaona i'abi? Ginauli mugaimugaina mata imiya na maiha vehabana inuwanuwatuwu: Ebe mane howahowana mata paihowa ive'ovi bo nigele? ");
INSERT INTO kud2014_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ebe nigele yana mane mata logidi a'ava ivetowolo, na nigele howahowana ive'ovi. Tomowa maudoidi hi'ita ta himaluwei, ");
INSERT INTO kud2014_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","hiwalo, “Towaho teina dova wahiwahiyalana ta logidi ivetowolodi na nigele vadanane maudoina iya'abi?”. ");
INSERT INTO kud2014_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","‘Hinage dova ebe ehebo tauwasawasa mayana tau'alehao 10,000 hilalau habi aleha teya tauwasawasa mayana bodao 20,000 adi bagibagili aidiyai, vedova tauwasawasane yana nuwatuwu? Mata mugai imiya na inuwatuwu howahowana hiwahiyala adi alehao aidiyai bo nigele? ");
INSERT INTO kud2014_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Na ebe nigele, yana tausagenawasao ivetamaledi na hisagena auhidi, ta vali tauwasawasane mayana tau'alehao howola amwaha daodaowai, na baidanao hi'aubabada nuwadaumwali vehabana.’ ");
INSERT INTO kud2014_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","I'ovi na Yeisu iwalo aulidi iwalo, ‘Tenem dova agu mulita ana amwaha ebe yaiya owa nuwanuwam na umulitaegau mugai yam tobwatobwa maudoina ulaugabaidi’. ");
INSERT INTO kud2014_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","‘Yagahu ginauli namwanamwana. Na ebe amnana i'ovi, nigele howahowana na i'amnauyo. ");
INSERT INTO kud2014_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nigele hinage ilowoinanei na bale'u i'abiye namwanamwa, na hesi bada tata'wata'wataei. Ebe matalinamiu walo teina ambenalei.’ ");
INSERT INTO kud2014_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ehebo hauga takesi ana tauvaiwo na hinage tupwadi tauyababao hilaoma Yeisu habi benaleina. ");
INSERT INTO kud2014_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Eena Palisiwo yo loina ana tauve'itao hi'ulu'ulumiyai hiwalo, ‘Towaho teina tauyababao i'awa heliheliyamwedi yo hinage baidanao hi'ai'ai’. ");
INSERT INTO kud2014_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Eeta yadi walone Yeisu iyemaiha walo vegevegediyena iwalo, ");
INSERT INTO kud2014_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","‘Vedova ebe ehebo alimiyena yana sipi adi bagibagili 100 na ehebo i'wadalele, mata 99 nu'ulai ilaugabaidi na sipiwa 'wada'wadalelenane ibehaei ana higa ilobai’. ");
INSERT INTO kud2014_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Na ebe ilobai mayana yaliyaya i'avalai nimanai na ilau gwaipile yana dalavai, ");
INSERT INTO kud2014_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","na ana geluwo iyoga ahaidi na iwalo, “Sipiwa 'wada'wadalelenawa bada yalobaiya'o, ainaena vehabana tayaliyaya”. ");
INSERT INTO kud2014_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Eeta dova hinage ebe ehebo tauyababa inuwabui mata taumiya galewa vehabana hiyaliyaya mwala'ina na hesi taunamwanamwa hitau 99 vehabadi yadi yaliyaya bada tupwana. ");
INSERT INTO kud2014_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","‘Dova hinage ebe waihiu yana mane ana bagibagili 10 kina na ehebo ive'wadalele mata hava ipaihowai na manenane ilobai? Lampa igabu na vada maudoina ise'ili na ibeha ili'ilimani ana higa ilobai. ");
INSERT INTO kud2014_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na ebe ilobai ana geluwo iyogaedima na aidiyai iwalo, “Yagu kinawa 'wada'wadalelenawa bada yalobaiya'o, ainaena vehabana tayaliyaya”. ");
INSERT INTO kud2014_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Dova hinage ebe ehebo tauyababa inuwabui, mata Yaubada yana tausagenawasao vehabana hiyaliyaya mwala'ina.’ ");
INSERT INTO kud2014_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Hinage Yeisu iwalo vegevegediyedi iwalo, ‘Ehebo taubada natunao towatowahodi bwau baidanao himiyamiya, ");
INSERT INTO kud2014_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","na habulune tamana ainai iwalo, “Tamagu, nuwanuwagu teina hauga agu veguveguyau umohegau”. Ainaena taubadawa ginauli maudoina iwahei natunao aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","‘Ahubena tupwana hi'ovi na habalunane yana ginauli ivegimwalaedi. Na ana maihaowa ivai, ta ilalaune amwaha daodaowai ta tenemai yaliyaya awa'awawa aidiyai yana manewa iveve'ovine. ");
INSERT INTO kud2014_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Yana mane maudoina i'ovi na nima'a'avana imiyamiya, na hauga tenem ainai vahali mwala'ina tupwanane ainai imahalava. ");
INSERT INTO kud2014_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Eeta towahowa paihowa ibehabeha ta ehebo dalava ana taubada ilobai, ta ivetamalei yana maheyao i'ita'ita avivinidi. ");
INSERT INTO kud2014_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Na towahonane nuwanuwana na maheya adiyena i'ai, wuwuna nigele ana. ");
INSERT INTO kud2014_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","‘Eena tenem ainai, nuwana imasele na ibom ainai iwalo, “Moiha, tamagu yana taupaihowaone ma'adi, na yau teinai vahali iwunuwunuigau. ");
INSERT INTO kud2014_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ainaena mata yatowolo na yalau tamagu ainai, yawalo, ‘Tamagu bada yalauhapuli'o Yaubada mehenai, na hinage owa mehemwai. ");
INSERT INTO kud2014_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ainaena nigele agu lowoinane ebe u'awa natuguwegau na hesi ebeha u'awa taupaihowaegau.’” ");
INSERT INTO kud2014_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","‘Teina dova inuwanuwatuwu, i'ovi na itowolo ta tamanawa vehabana iwuwuyone, na amwaha daodaowena tamanawa i'itayama ilaolaoma na mayana atemuyamuya isagena i'atuhapwali ta inihoi na baidana hidoudou. ");
INSERT INTO kud2014_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","‘Eeta i'ovi na tamanawa iwalo auli, iwalo, “Tamagu bada yalauhapuli'o Yaubada mehenai yo hinage owa mehemwai, ainaena nigele iyalowoinanegau ebe u'awa natuguwegau”. ");
INSERT INTO kud2014_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","‘Na hesi tamanawa yana taupaihowao iyogaedi na iwalo, “Mwayamwayau ale'o namwanamwana amvaiyama, na natugu amveli'wa yo hinage nimana ana pasapasa amvaiyama ta nimanai ammwauwi yo hinage aehumahuma aenai ammwauwi, ");
INSERT INTO kud2014_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","na mulitai amlau bulumakau yauyaubona na tubutubuina amwunuiyama ta ta'ai toyawa na tayaliyaya.” ");
INSERT INTO kud2014_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Wuwuna natugune teina mwalona imwalowoi'o, na teina hauga mayawahina talobauyoiya'o, eeta hivetuwuni ai hihagahagani mayadi yaliyaya. ");
INSERT INTO kud2014_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","‘Na hesi natunawa mwala'inawa howola oyai ipaipaihowa, na haugana dalavai imahamahalava wali yo selo ibenaledi. ");
INSERT INTO kud2014_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ainaena ehebo yadi taupaihowa iyogaei na ipanivilaei iwalo, “Hava wuwuna hiyaliyaliyayane?”. ");
INSERT INTO kud2014_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Na taupaihowawa iwalo, “Tahimwa bada iwuyoma'o eeta tamamne iwalo ta bulumakau yauyaubona tubutubuina hiwunui ta baidamai ayayaliyaya, wuwuna natunane mayana namwanamwa ilobauyoiya'o”. ");
INSERT INTO kud2014_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","‘Walo teina ibenalei na imodi'ini mwala'ina eeta nigele nuwanuwana iluwu vadai. Na tamanawa imahalava ta natunane mwala'inawa iwalo auli ebeha baidana hiluwu vadai. ");
INSERT INTO kud2014_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Na towahonane ita'wata'wata, wuwuna imodi'ini mwala'ina ainaena tamanawa ainai iwalo, “Tamagu, viha bolimai hi'ovi'o vehabam yapaipaihowa ta yam ve'abei maudoina yapaipaihowaidi, na nigele teya hauga uyavelauwegau, hinage nigele teya lagulagu uyamohegau na ma'augeluwo aya'ai na ayayaliyaya. Moiha nigele! ");
INSERT INTO kud2014_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Na natumne teina yam tobwatobwa maudoina iyepaipaihiyei taumehe'ayo aidiyai, na hava vehabana uvelavelauweine ta bulumakau yauyaubona na tubutubuina uwuwunuine vehabana?” ");
INSERT INTO kud2014_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","‘Na taubadawa natunawa ainai iwalo, “Natugu, uhanapuiya'o neta owa hauga maudoina vahaliguwai umiyamiya ta hava yagu abaloinao maudoina nimamwai himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Inamwanamwa na ta'ai ovi yo tayaliyaya wuwuna tahimne teina imwalowoi na hesi iyayawahaine, i'wadalele na iwuwuyomane.” ’ ");
INSERT INTO kud2014_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yeisu hinage walo vegevegedi ehebo ana taumulitao imohedi iwalo, ‘Wasawasa ehebo mayana tau'ita avivini yana ginauliwo i'ita avivinidi. Na tomowa wasawasane ainai, hiwalo, “Taubada, yam tau'ita avivinine yam tobwatobwaowa iyeyepaipaihedi”. ");
INSERT INTO kud2014_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ainaena wasawasawa yana tau'ita avivinine iyogaenama na ainai iwalo, “Tupwadi walo yababana vehabam yabenalei, eeta teina hauga yagu tobwatobwa adi peipao umoheuyoigau na aliguwena u'ovi?”. ");
INSERT INTO kud2014_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","‘Ainaena tau'ita aviviniwa inuwanuwatuwu, iwalo, “Vedova mata yapaihowane wuwuna bada yagu taubada isosomanegau'o? Eeta nigele howahowagu yatudai, na hinage abahinimaya ebe yalau tomowa aidiyai na ai'ai vehabana ya'awa'awanoi.” ");
INSERT INTO kud2014_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Inuwanuwatuwu, eeta ehebo amwaha inuwatuwu lobai, iwalo, “Ehe teina dova yapaihowai na ainaena augeluwo bagibagilidi yalobaidi ebe paihowa teina ainaena yamahalava”. ");
INSERT INTO kud2014_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","‘Ainaena tau'ita aviviniwa hiya ma'adi vagavagao maudoidi iyogaedi na ehebo ehebo aidiyai ipanivila. Towaho mugamugaina ainai iwalo, “Viha am vagavaga teinai?”. ");
INSERT INTO kud2014_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Na iwalo, “Woloi adi bagibagili 100 agu vagao”. ‘Na tau'ita avivinine iwalo, “Peipane teina ainai amvagavagane ulele 50 a'ava umwau”. ");
INSERT INTO kud2014_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","‘Na ehebo hinage iluwu na ipanivilaei iwalo, “Na owa, viha am vagavaga?” ‘Na iwalo, “Ai'ai adi bagibagili 100 yavaidi'o agu vagavagaone”. ‘Na hinage iwalo, “Peipa ainai ulele am vagaone 80 a'ava”. ‘Na maudoidi dova adi vagao himwau aituluwedi. ");
INSERT INTO kud2014_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","‘Ainaena yana taubadawa yana paihowa teina wasana ibenalei na ino'owei yana hanapu vehabana. Walo vegevegedi teina ainaena ive'ita moiha neta taumiya bale'u hiwahiyala yadi wasawasa ana paihowa vehabana, na hesi Yaubada yana bodao yadi paihowao masele vehabana nigele hiyawahiyala.’ ");
INSERT INTO kud2014_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Eena Yeisu iwalo, ‘Bale'u wasawasanao na ebe wasawasaone aidiyena ami geluwone amvelauwedi mata howola hiya hivedunagomiu abamiya vateyai ainai, hauganane wasawasaone hi'ovi. ");
INSERT INTO kud2014_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","‘Wuwuna ebe yaiya ginauli habuluna ainai i'awa abi, mata hinage ginauli mwala'idi aidiyai i'awa abi. Na ebe habuludi aidiyai i'oyama hinage mwala'idi aidiyai i'oyama. ");
INSERT INTO kud2014_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Omiu hinage ebe nigele bale'u wasawasanao vehabadi amyapaihowa ili'ilimani, mata Yaubada nigele wasawasa moiha iyamohegomiu. ");
INSERT INTO kud2014_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na ebe ami geluwo yadi wasawasa vehabadi nigele amyapaihowa ili'ilimani, nigele howahowana hinage Yaubada yami wasawasane imohegomiu. ");
INSERT INTO kud2014_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","‘Ainaena taupaihowa nigele howahowana na ivetaupaihowa tautaubadao bwau aidiyai, ehebo mata ita'wata'wataei na ehebo vehabana ipaihowa, yo hinage ehebo i'awa namwanamwaei na ehebo i'awa yababaei, eeta nigele howahowana Yaubada yana paihowa na wasawasa bale'u ta'abibwauwedi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Palisiwone walone hibenalei ta Yeisu hi'abi talawahiyei, wuwuna hibom mane nuwanuwadi mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Eeta Yeisu Palisiwone aidiyai iwalo, ‘Omiu amnuwatuwui ebeha mumugamiu namwanamwana tomowa mehediyai na hesi yababana maudoina atemiyai Yaubada ihanahanapuidi, wuwuna ginaulidine tomowa nuwadi ivai Yaubada ainai ginauli awa'awawa. ");
INSERT INTO kud2014_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Na moiha Mosese yo tauwalo mahalavao yadi laulelewo alimiyai imiyamiya ana higa Yoni tau'abiye bapitaiso ilaoma, na hauga tenem ainaena ta wau, wasa namwanamwana Yaubada yana Abaloina vehabana howola awalowalo mahalavaedi, na abaloinane vehabana tomowa bagibagilidi mayadi wahiyala hiluwuluwu. ");
INSERT INTO kud2014_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Galewa na bale'u yadi sawali malamalaina, na hesi Mosese yana loinao bwagana iu'iuna, mata nigele hiya'ovi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Na Yeisu hinage aidiyai iwalo, ‘Ebe yaiya towaho mwanena ivinawaheyei, na itawahola geyo'awa vali waihiu ainai, bada ipwanoli'o. Na hinage ebe waihiu vinavinawahena itawahola vali towaho ainai, towahonane hinage ipwanoli'o.’ ");
INSERT INTO kud2014_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Hinage Yeisu iwalo, ‘Ehebo hauga wasawasa ehebo na Lasalo himiyamiya. Wasawasane ana ale'owo namwanamwadi na hinage anao maudoidi namwanamwadi, ahubena ehebo ehebo aidiyai mayana yaliyaya imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na Lasalo hesi wewelohena yo bonubonuna, eeta wasawasawa yana vada awa'edanai imiyamiya, ");
INSERT INTO kud2014_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","na ebeha wasawasane ana tupwatupwadi ainaena i'ai. Na Lasalonane hauga bagibagilina bonunaone edewa hilemlemhidi. ");
INSERT INTO kud2014_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Haugana Lasalo imwalowoi tausagenawasao hilauvai ta Abelaham vahalinai himwau hiya taudumwaluwo yadi tupwai. Na mulitai hinage wasawasawa imwalowoi na hiye magaiyei, ");
INSERT INTO kud2014_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","na iya mayana muya mwala'ina taumwalomwalowoi yadi tupwa ainai i'ita hae ta Lasalo i'ita Abelaham baidana himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Na iyoga mwala'ina iwalo, “Tamagu yo! U'atemuyamuyaegau na Lasalo uvetamalenama ta we'aha gwagwamana nimanaena memenagu i'abiye gwagwama, wuwuna teina hauga yamuyamuya mwala'ina, aiwa ala'ala hawahawawalina ainai.” ");
INSERT INTO kud2014_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","‘Na Abelaham iwalo, “Natugu, uhanapuiya'o ebeha mwalona yawahim maudoina yaliyaya a'ava, na hesi Lasalo nigele teya abayaliyaya iyalobai, ainaena teina haugane iya mayana yaliyaya na owa umuyamuya. ");
INSERT INTO kud2014_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Na hinage uhanapui ebeha ahi'ahipudai hawahawaga mwala'ina imiyamiya itomgita'o ainaena nigele howahowana teina ainaena ageyo'awawa alimiyai, omiu hinage nigele howahowana amgeyo'awama alimaiyai.” ");
INSERT INTO kud2014_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","‘Wasawasawa iwalo, “Oo, yede ya'awanoiyego nuwanuwagu na Lasalo uvetamalei yagu bodao aidiyai, ");
INSERT INTO kud2014_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","na tahiguwao hitau 5 nuwadiyai imwauwi ta havena hibom hinage hilaolaoma muya teina ainai”. ");
INSERT INTO kud2014_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Eeta Abelaham wasawasawa iwalo auli iwalo, “Tahimwone adi tauvenuwamwauwo himiyamiya, hibom neta Mosese yo tauwalo mahalavao yadi walowo Buki Ve'ahihi ainai. Walowone holanaine howahowana na tahimwone hibenalei ili'ilimani.” ");
INSERT INTO kud2014_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Na hesi wasawasawa iwalo, “Tamagu, neta nigele howahowana. Hesi ebe yaiya mwalowoiyena itowolouyo na ilau aidiyai, na iya hi'ita, abo hinuwabui ili'ilimani.” ");
INSERT INTO kud2014_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Na Abelaham iwalo, “Ebe Mosese yo tauwalo mahalavao yadi walo nigele hiyayemidiyei, nigele howahowana teya yaiya hiyemidiyei, bwagana ebe ehebo mwalowoiyena itowolouyo na ilau alidiyai”.’ ");
INSERT INTO kud2014_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yeisu ana taumulitao aidiyai iwalo, ‘Tomowa tupwadi mata abatowoi hipaihowaidi alimiyai ebeha hi'abiye be'ugomiu, na ebe yaiya abatowoine ipaihowaidi iya atemuyamuyana! ");
INSERT INTO kud2014_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ilowoinanei na gaima mwala'ina hihipwai gadonai na ni'u didigai higabaei, ta ebe havena tautapitapiya himulimulitaei.’ ");
INSERT INTO kud2014_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","‘Ebe am gelu alimwai ipaihowai yababana, uwalowei yana lauhapuline eeta ebe inuwabui unuwahamui. ");
INSERT INTO kud2014_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ta ebe tahimne ahubena ehebo ainai, na mai 7 ipaihowa yababana alimwai, na ehebo ehebo lauhapuline ainai i'awa'awanoi alimwai nuwahamu vehabana howahowana maudoina unuwahamuidi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Eeta Bada yana tauyewasao hiwalo auli hiwalo, ‘Yama yemidi u'abiye wahiyala’. ");
INSERT INTO kud2014_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Na Bada iwalo, ‘Ebe yami yemidi ana wahiyala dova haiyala patuna, howahowamiu aiwa teina mwala'ina ainai amwalo, “Uhuluviyoigo na udobi gabwwai umaiuyoigo”; mata yami walone imulitaei.’ ");
INSERT INTO kud2014_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Hinage adiyai iwalo, ‘Ebe yaiya owa mayam taupaihowa nuwana tautudai bo lagulagu ana tau'ita avivini, na ebe haugana hevalinane paihowaena imahalava, mata nigele uyaloinaei ta iya'ai mugai, ");
INSERT INTO kud2014_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","na hesi uwalo, “Agu u'atububuni ta u'ita avivinigau na ya'ai, abo owa mulitai u'ai na unuma”. ");
INSERT INTO kud2014_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Eeta hevalinane yana paihowa vehabana mata yana taubadane nigele iya'awa yauwedowei, wuwuna iya ta'i yana taupaihowa. ");
INSERT INTO kud2014_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Na omiu hinage dova, ebe haugana ginauli maudoina ampaihowaidi hava dova yaloinaei, amwalo, “Ai taupaihowa ta'i hava dova ama loina ta dova apapaihowaine, neta hesi ama lowoinana moiha”.’ ");
INSERT INTO kud2014_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yeisu bada ilalau Yelusalem vehabana, na Sameliya yo Galili ahi'ahipudiyai imahamahalava. ");
INSERT INTO kud2014_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Na ehebo dalava ainai ilaoma na taulepelo 10 ilobaidi yana amwahaena hitowotowolo, ");
INSERT INTO kud2014_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","na hiyogayoga alinadi mwala'ina, na hiwalo, ‘Taubada Yeisu, u'atemuyamuyaegai’. ");
INSERT INTO kud2014_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ainaena i'ita gwaipile na iwalo, ‘Amlau na taupwaoliwo aidiyai amve'itaegomiu’. Ta hilaulau amwahai na adi lepelo hi'o'ovine, ");
INSERT INTO kud2014_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","na ehebo towaho aidiyena Sameliya towahona i'ita ebeha bada inamwanamwa'o ta iwuyouyo na alinana mwala'ina Yaubada ino'owei, ");
INSERT INTO kud2014_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","na Yeisu aenai ibe'u aitulu na ainai i'awa yauwedo. ");
INSERT INTO kud2014_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ainaena Yeisu towahonane ainai iwalo, ‘Wau amtau 10 ya'abiye namwanamwagomiune na havaidova hitau 9? ");
INSERT INTO kud2014_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Hava ta nigele hiyawuyoma na Yaubada ainai hiya'awa yauwedone? Na owa taumana nigele Yudeya ainaena, na hesi ulaoma habi awayauwedo. ");
INSERT INTO kud2014_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ainaena yam yemidiyena livahi ulobai. Inamwanamwa utowolo na ulau.’ ");
INSERT INTO kud2014_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Palisiwo tupwadi hilaoma na Yeisu hipanivilae aiteya hauga ainai mata Yaubada yana Abaloina imahalava. Eeta Yeisu yadi panivilane iyemaiha teina dova iwalo. ‘Nigele howahowana na Yaubada yana Abaloina ve'ive'ilalana ta'ita. ");
INSERT INTO kud2014_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Na hinage nigele howahowana na hiwalo, “Am'ita teina”, bo “Tenem”, wuwuna Yaubada yana Abaloina gamwagamwanimiyai imiyamiya.’ ");
INSERT INTO kud2014_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ainaena ana taumulitao aidiyai iwalo, ‘Howola abo yalaugabaigomiu, na mulitai nuwanuwamiu mwala'ina na yau Tomowa Moihagu baidamiu tamiyamiya ahubena ehebo ta'i vehabana, na hesi mata nigele amya'itagau. ");
INSERT INTO kud2014_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Na ebe tomowa hiwalo, “Besinana tenem”, o nuwana, “Teina”, havena ammulimulitaedi. ");
INSERT INTO kud2014_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Wuwuna hauganane ebe yalaoma, galewa ana ita masele a'ava dova namali mwala'ina yana masele. ");
INSERT INTO kud2014_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","‘Mulitai na ginaulidine himahalava, mugai yaso teina hita'wata'wataegau na aidiyena muyamuya yalobaidi. ");
INSERT INTO kud2014_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Yagu laugwaipilema ana hauga ainai Nowa yana hauga dova. ");
INSERT INTO kud2014_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Wuwuna Nowa yana haugai tomowa hi'ai'ai na hinumanuma yo hinage hitawatawahola ana higa Nowa yana wagai igelu na aba'ita imahalava ta ainaena tomowa maudoidi imumutudine. Yau Tomowa Moihagu yagu laugwaipileuyoma dova. ");
INSERT INTO kud2014_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","‘Na hinage Lota yana haugai dova, hauganane ainai tomowa maudoidi hi'ai'ai na hinumanuma, yo hinage hipaipaihowa oyai, yo higimwagimwala na hivegivegimwala yo hi'abi'abi vada, ");
INSERT INTO kud2014_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ana higa Lota Sodoma ilaugabaei na aiwa ala'ala hawahawawalina yo gaima ala'alawowolidi galawaena hibe'uma dova 'wesu, na tomowa maudoidi i'oiye mwalowoidi. ");
INSERT INTO kud2014_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ginauli hava himamahalavane aidiyai, hinage mata dova tomowa aidiyai himahalava, hauganane yau Tomowa Moihagu yalau gwaipilema ainai. ");
INSERT INTO kud2014_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","‘Na ahubenanane ainai ebe yaiya vatavatai imiyamiya mata nigele howahowana iluwu vadai ta ebeha yana ginauli i'avala, hinage ebe yaiya oyai ipaipaihowa, nigele howahowana isagena dalava vehabana. ");
INSERT INTO kud2014_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Eena amnuwatuwu avivini hava dova Lota mwanena ainai imamahalavane. ");
INSERT INTO kud2014_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Neta ebe yaiya yawahina vehabana ipaipaihowa mata yawahinane ive'wadalele na ebe yaiya yawahina italamwei na ive'wadalele howola abo ilobauyoi. ");
INSERT INTO kud2014_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Na yawalo moiha alimiyai boniyainane ainai ebe tomowa bwau aba'eno ehebo ainai hi'eno'eno, ehebo yalauvai na ehebo imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Dova hinage ebe waiwaihiu bwau hi'eha'ehalo, ehebo yalauvai na ehebo imiyamiya.’ ");
INSERT INTO kud2014_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Eeta ana taumulitao hipanivilaei, hiwalo, ‘Taubada, havaidova ainai?’ Na Yeisu iwalo, ‘Havaidova ainai mwalowoi imiyamiya neta ainai ao'ao hiyauyaugogoi’. ");
INSERT INTO kud2014_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ehebo walo vegevegedi Yeisu imohedi ta ebeha havena awanoi ainaena hitapitapiya. ");
INSERT INTO kud2014_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Teina dova iwalo, ‘Ehebo dalava ainai tauloina ehebo mwala'ina imiyamiya, iya nigele Yaubada iyameheuhei na hinage tomowa nigele iyave'ahihiyedi. ");
INSERT INTO kud2014_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na tupwanane ainai hinage ehebo hiwape imiyamiya, hauga bagibagilina hiwapenane imahamahalava tauloinane ainai na i'awa'awanoi hagu vehabana iwalo, “Taubada, agu aleha ainaena uvedumwalugau”. ");
INSERT INTO kud2014_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","‘Hauga ehebo ehebo dova yana paihowa na hesi tauloinane nigele nuwana ihagui. Na ehebo hauga ainai tauloinanane tauna isosomana na iya ibom ainai iwalo, “Badagi, Yaubada nigele yayameheuhei na hinage tomowa nigele yayave'ahihiyedi, ");
INSERT INTO kud2014_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","na hesi hiwapene teina yana lau ala'alabilima aliguwai vehabana yavedumwalu ana aleha ainaena, mata dova ta agu tausosomana imwauwi”.’ ");
INSERT INTO kud2014_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ainaena Yeisu hinage iwalo aulidi iwalo, ‘Taubada teina yana walo vehabana am nuwanuwatuwu walo moiha ibom towaho yababana na hesi hiwape ihagui. ");
INSERT INTO kud2014_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Hinage dova Yaubada yana tomowao vesivesinuwadi ihaguidi hauganane ebe hi'awa'awanoi hamahamadudu ainai ahubena yo boniyai aidiyai, ");
INSERT INTO kud2014_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","na yana hagune mata dumwaluna ipaihowa aidiyai. ‘Na vedova omiu yami nuwatuwu ebe hauganane Yau Tomowa Moihagu yalau gwaipilema bale'uwai, viha tomowa mata mayadi yemidi yalobaidi hitowotowolo wahiyala?’ ");
INSERT INTO kud2014_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tomowa tupwadi hinuwanuwatuwu ebeha hiya taudumwalu na vali tomowa nigele, eeta Yeisu iwalo vegevegediyedi teina dova, ");
INSERT INTO kud2014_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","iwalo, ‘Ehebo hauga ainai tomowa hitau bwau hiluwu vada tapwalolo mwala'ina ainai habi awanoi Yaubada ainai. Ehebo Palisi na ehebo takesi ana tauvai. ");
INSERT INTO kud2014_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Palisiwa ibom itowololau lovai i'awa'awanoi iwalo, “Yaubada yo, ya'awa yauwedo alimwai wuwuna yau nigele dova augeluwo mumugadine wuwuna hiya hi'ai'aivavali, yo hi'oya'oyama yo hipwanopwanoli, na yau nigele dova takesi ana tauvaine tenem. ");
INSERT INTO kud2014_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yau hesi wiki ehebo ehebo ahubena bwau yahudihudi, yo hinage yagu tobwatobwao aidiyena tupwadi yamohemohego.” ");
INSERT INTO kud2014_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","‘Na hesi takesi ana tauvaine lovaena itowolo na mayana hinimaya nuwanuwana itutututu na ipwagogo na i'awa'awanoi iwalo, “Yaubada yo, bada uhanapuigau'o ebeha yau tauyababa ainaena u'atemuyamuyaegau!”.’ ");
INSERT INTO kud2014_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Eeta Yeisu aidiyai iwalo, ‘Moiha, towaho teina yana awanoine vehabana mata ana awanamwanamwa ilobai Yaubada ainaena, na hesi Palisine nigele. Wuwuna ebe yaiya i'abihiniuyoi mata hi'abiye talu, na ebe yaiya i'abiye taluyoi mata Yaubada i'abihini.’ ");
INSERT INTO kud2014_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tupwadi tomowa natudiyao habuludi hilauvaidima ta ebe Yeisu i'abi towoidi, na ana taumulitaone hi'a'auhidine. ");
INSERT INTO kud2014_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Na Yeisu iwalo lau aidiyai iwalo, ‘Hedaheda amtalamwedi ta aliguwai hilaoma. Hedaheda teina dova Yaubada yana Abaloina ilowonanaedi moiha. ");
INSERT INTO kud2014_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Wuwuna ebe yaiyadiwo dova teina hedahedaone yadi yemidine, howahowana Yaubada yana Abaloina ainai hiluwu, na ebe nigele, mata nigele hiyaluwu.’ ");
INSERT INTO kud2014_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yudeya yadi taumugai ehebo ilaoma na Yeisu ipanivilae, iwalo, ‘Taubada yahanahanapui ebeha owa tauve'ita namwanamwana, ainaena hava yapaihowai ta ebe yawahi vateyai yalobai?’ ");
INSERT INTO kud2014_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Na Yeisu towahonane iwalo auli iwalo, ‘Vedova ta u'a'awa namwanamwaegau? Wuwuna nigele teya yaiya iyanamwanamwa, bada Yaubada ibom. ");
INSERT INTO kud2014_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Na Yaubada yana loinao bada uhanapuidi'o, neta ebeha: Havena pwanoli, havena yemwalowoi, havena aivavali, havena ve'ewa oya'oyama. Na hinage tamam yo hinam uve'ahihiyedi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Na towahowa iwalo, ‘Yagu hauga heda ainaena ta wau loinaone teina yamulita ili'ilimanidi'o’. ");
INSERT INTO kud2014_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yana walo teina dova Yeisu ibenalei, eeta iwalo, ‘Ehebo ginauli hinage nigele alimwai, neta yam tobwatobwa maudoina uvegimwalaedi na adi maihaone tauwewelohe aidiyai u'aiyauyaei, na ulaoma ta umulitaegau ta ebe howola abo yamtobwatobwa galewai ulobai’. ");
INSERT INTO kud2014_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Walone teina towahonane ibenalei ta inuwayababa moiha wuwuna yana tobwatobwa imwala'i alili. ");
INSERT INTO kud2014_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yana nuwavitaine bada Yeisu ihanapuiya'o, eeta tomowa aidiyai iwalo, ‘Ebe yaiyadiwo hiya mayadi tobwatobwa mwala'ina yadi luwu Yaubada yana Abaloina ainai ivitai alili. ");
INSERT INTO kud2014_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Moiha, kameli iya lagulagu mwala'ina, ta tupwana ivitai na nidili gudana ainaena iluwu, na hesi wasawasao yadi luwu Yaubada yana Abaloina ainai ivitai alili.’ ");
INSERT INTO kud2014_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Taumulitaowa Yeisu baidanao himiyamiyawa walonane hibenalei ta hipanivila hiwalo, ‘Ebe teina dova, yaiya yede howahowana na awanamwanamwane ilobai?’ ");
INSERT INTO kud2014_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Eeta aidiyai iwalo, ‘Hava tomowa aidiyai nigele howahowadi, mata Yaubada ainai ginaulinane malamalaidi’. ");
INSERT INTO kud2014_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ainaena Pita Yeisu ainai iwalo, ‘Taubada, ai mata vedova? Wuwuna bada yama dalavao alaugabaidi'o na amumulitaegone’. ");
INSERT INTO kud2014_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Na Yeisu maudoidi iwalo aulidi iwalo, ‘Yawalo dumwalu alimiyai ebe yaiyadiwo omiu yami dalava yo mwanemiyao yo tahimiyao yo tamamiyao yo hinamiyao yo natumiyao amlaugabaidi na Yaubada yana Abaloina ainai amtalamwegomiu, ");
INSERT INTO kud2014_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","hauga teina ainai maiha mwala'ina amlobai, na hinage hauga ilalaoma ainai yawahi vateyai amvai’. ");
INSERT INTO kud2014_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yeisu hitau 12 iyoga ahaidi ta iyemiya wahiyedi na aidiyai iwalo, ‘Teina hauga tahahae Yelusalem na ginauli maudoina tauwalo mahalavao mwalona hileleya'o yau Tomowa Moihagu vehabagu muhamuhana himahalava ta am'itadi. ");
INSERT INTO kud2014_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Mugai hivaigau nigele Yudeya aidiyai, na hi'abi talawahiyegau yo hi'abiye hinimayagau na hihowaigau, ");
INSERT INTO kud2014_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","yo hinage balavaiyena hipwediligau na abo hi'oiye mwalowoigau, na ahubena tonuga ainai mwalowoiyena yatowolouyo.’ ");
INSERT INTO kud2014_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Na ana taumulitaowa nigele teya yana walone ana nuwamasele aidiyai iyaluwu. ");
INSERT INTO kud2014_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yeisu Yeliko ainai imahalava na ehebo taumehegibugibu amwahai imiyamiya, na i'awa'awanoi mane yo tobwatobwa vehabadi. ");
INSERT INTO kud2014_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Towahowa Yeisu mayana bodao alinadi ibenalei ta isupuna na iwalo, ‘Yaiyadiwo neta?’ ");
INSERT INTO kud2014_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Na hiwalo, ‘Yeisu towaho Nasaleti ilaolaomane’. ");
INSERT INTO kud2014_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Na taumehegibugibunawa iyoga mwala'i na iwalo, ‘Yeisu yo, owa Deivida yana huhu, u'atemuyamuyaegau!’. ");
INSERT INTO kud2014_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Na tomowaowa himugai ta towahonane hi'auhi hiwalo, ‘Ulau mwau havena uyogayoga!’. Na iyoga hamahamadudu iwalo, ‘Deivida tubuna yo, u'atemuyamuyaegau’. ");
INSERT INTO kud2014_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yeisu itowolo na iwalo aidiyai ta towahowa hiyogaenama. Na ilaoma ta ipanivila? iwalo, ");
INSERT INTO kud2014_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","‘Hava nuwanuwam yapaihowai alimwai?’ Na iwalo, ‘Bada, nuwanuwagu ebeha mehegu hinamwanamwa?’ ");
INSERT INTO kud2014_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Na Yeisu iwalo, ‘Uvinunuyo wuwuna yam yemidi ilivahigo'o’. ");
INSERT INTO kud2014_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tenem ainai mehena himasele ta i'awa yauwedo Yaubada ainai na Yeisu imumulitaeine. Na bodaone hi'ita, ta maudoidi Yaubada hino'owei. ");
INSERT INTO kud2014_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yeisu Yeliko ainai iluwu ta dalavane holanaena ilaulau. ");
INSERT INTO kud2014_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Dalavane ainai ehebo takesi tauvai adi taumugai imiyamiya, yehana Sakiusa, ibom wasawasa ehebo. ");
INSERT INTO kud2014_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Na haugana Yeisu ilaulau, Sakiusa nuwanuwana na Yeisu i'ita ebeha iya yaiya, na hesi nigele howahowana yo i'ita, wuwuna ibom towaho ubwa'ubwana ta'i, na hinage boda mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ainaena itau mugai ta aiwa ehebo imwalaei, yehana sikamole, ta ebeha tenem ainaena Yeisu i'ita, haugana ebe vahalinaena ilaulau. ");
INSERT INTO kud2014_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Na haugana Yeisu ilaoma vahalinai, ilau ta'ai ta Sakiusawa i'i'itane, eeta iwalo auli iwalo, ‘Sakiusa, u'aitulu mwayamwayauma, wuwuna mata owa na yau yam vadai tamiyamiya’. ");
INSERT INTO kud2014_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakiusa mwayamwayauwena i'aitulu na mayana yaliyaya Yeisu baidana hivelobaloba. ");
INSERT INTO kud2014_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tenem ainai tomowa ginauli teina hi'itadi, na hi'ulumiya hiwalo, ‘Vedova ta Yeisu iluluwune tauyababa yana vadai’. ");
INSERT INTO kud2014_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Na Sakiusa itowolo ta Bada iwalo ainai iwalo, ‘Bada, wau mata ainai yagu tobwatobwa maudoina yatom bwauwi ta tupwa ehebo maudoina tauwewelohewo yamohedi. Yo hinage ebe yaiya ainaena mugai ya'aivavali yayemaiha ma'ana lauhepoi vehopali dova yamohei.’ ");
INSERT INTO kud2014_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ainaena Yeisu iwalo auli, iwalo, ‘Teina vadane ainai livahi wau imahalava'o, wuwuna towaho teina ibom ehebo Abelaham yana boda. ");
INSERT INTO kud2014_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Moiha yau Tomowa Moihagu yalaoma taulaupwanopwano yabehaedi ta livahidi, towaho teina yalobaiya'o dova.’ ");
INSERT INTO kud2014_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Eeta Yelusalem ainai himahamahalava, na bodaone hinuwanuwatuwu ebeha Yaubada yana Abaloina muhamuhana ivetuwuni, ainaena walo vegevegedi teina imohedi, ");
INSERT INTO kud2014_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","iwalo, ‘Ehebo tauloina bada i'atububuni'o ta ilalau tupwa amwaha daodao ainai ta ebe nemai ivetauloina, na mulitai abo ilau gwaipilema, ");
INSERT INTO kud2014_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","yana taupaihowao iyogaidima na adi veguveguyai mane ehebo ehebo imohedi na iwalo, “Ami veguveguyai teina amyepaihowadi ta ana lauhepoi amlobaidi, ana higa yawuyouyoma!”. ");
INSERT INTO kud2014_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","‘Na mulitai tauloinawa yana bodao tupwadi hita'wata'wataei, nigele nuwadi ivetauloina, ainaena wasa hivetamalei, hiwalo, “Towaho neta nigele nuwanuwamai yo alimaiyai ivetauloina”. ");
INSERT INTO kud2014_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","‘Na bada ta'i ivevetauloinane, ta haugana ilau gwaipilema, na yana taupaihowaowa iyoga ahaidima ta ebeha nuwanuwana na ihanapui viha adi veguveguyaiwa aidiyena lauhepoi hilobaidi'o. ");
INSERT INTO kud2014_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ta ehebo towaho imugai ta yana taubada mehenai itowolo na iwalo auline, iwalo, “Yam mane ehebo mugai umomohegauwa teina ana lauhepoi hinage 10 yalolobaidine”. ");
INSERT INTO kud2014_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Eeta taubadawa iwalo, “Ausala owa tau'awa abi moiha, wuwuna ginauli habuluna na u'abiye mwala'i ainaena am maiha yamohego, neta dalava 10 aidiyai uvetauloina”. ");
INSERT INTO kud2014_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","‘Na towaho bwauna hinage ilaoma ta iwalo, “Taubada, yam manewa ehebo mugai umomohegauwa teina ana lauhepoi 5 yalolobaidine”. ");
INSERT INTO kud2014_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","‘Ainaena ibom hinage iwalo auli, iwalo, “Dalava 5 aidiyai uvetauloina”. ");
INSERT INTO kud2014_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","‘Na tonugadiwa hinage ilaoma ta iwalo, “Taubada, yam manewa teina, ale'o ainaena yahuma ta yamwau dawani ili'ilimani. ");
INSERT INTO kud2014_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Wuwuna yamatauhego owa towaho yaiyaim na yam mane uvaivai tomowa vagadi yadi paihowa aidiyena. Ainaena yam manewa teina uvaiuyoi.” ");
INSERT INTO kud2014_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","‘Teina taupaihowane ainai iwalo, “Owa taupaihowa yababana. Walo hava awamwena hi'ai'aitulu mata aidiyena yave'ewaigo. Uhanapuiya'o neta yau tomowa abi'abitau'watagu. Hava nigele aliguwena yavaivai yo hava nigele yaya'uma'umai yavaivai ");
INSERT INTO kud2014_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ainaena hava ta yagu mane nigele banikai uyamwauwine? Eeta yagu laugwaipilema haugana ainai yagu mane ma'ana lauhepoi yayavaine!” ");
INSERT INTO kud2014_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","‘Ainaena tupwadi tomowa vahalinai hitowotowolo iwalo aulidi, iwalo, “Yagu manene ainaena amvai na towahone ibom lauhepoi mwala'ina ilolobaine ammohei”. ");
INSERT INTO kud2014_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Na hiya hiwalo, “Taubada, havena amohemohei, wuwuna iya bada mane 10 ivaidi'o ta howahowana”. ");
INSERT INTO kud2014_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Na taubadawa aidiyai iwalo, “Bada ta'i ammohei wuwuna ebe yaiya ana veguveguyai ilauhepoiyei, tupwana hinage mata ilobai, na hesi ebe yaiya nigele iyalauhepoiyei hava ainai imiyamiya mata ainaena hivai vehulu. ");
INSERT INTO kud2014_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Eena teina hauga agu alehaowa hiya hita'wata'wataegau ta ebeha nigele nuwanuwadi aidiyai yavetau loina, amvaidima ta meheguwai am'oiye mwalowoidi.” ’ ");
INSERT INTO kud2014_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yeisu yana walo teina i'ovi na hihaehae Yelusalem vehabana, ");
INSERT INTO kud2014_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","na yadi lau ainai Bedipegi yo Betani vahalidiyai himahamahalava, neta Olibe oyana elauhanai, eena ana taumulitao bwau ivetamale mugaiyedi dalavadine aidiyai na iloinaedi, ");
INSERT INTO kud2014_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","iwalo, ‘Dalavane tenem mehedaine ainai ammugai ta mata ehebo lagulagu am'ita, neta doniki yauyaubona, iya tomowa nigele hiyagelugelui, lagulagunane amlivahi ta amlawenama. ");
INSERT INTO kud2014_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Na ebe yaiya iwalo, “Hava vehabana neta lagulagune amlivalivahine?” towahonane amwalo auli, amwalo, “Taubadane nuwanuwana”.’ ");
INSERT INTO kud2014_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Eeta hilau ta ginauli maudoina hilobaidi dova Yeisu iwawalowediwa. ");
INSERT INTO kud2014_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Na haugana donikiwa hilivalivahi, ana taniwagane ipanivilaedi, iwalo, ‘Hava ta yagu lagulagune amlivalivahine?’ ");
INSERT INTO kud2014_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ta hiwalo, ‘Bada nuwanuwana’. ");
INSERT INTO kud2014_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ta lagulaguwa hilauvai na hilalaweine Yeisu ainai, na adi ale'owena dagelana hi'oihamui, ta Yeisu ainai igelu taohani. ");
INSERT INTO kud2014_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ilaulau na tomowa bagibagilidi adi ale'owo amwahai hiveheyedi. ");
INSERT INTO kud2014_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Na bada hilaoma'o Yelusalem vahalinai ta hi'a'aitulu Olibe amwahana ainai na ana taumulitaone bodadi mayadi yaliyaya Yaubada hiwalowalo vetuvehaeyei wuwuna bada yana paihowa wahiwahiyaladi hi'itadi'o, ");
INSERT INTO kud2014_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","hiwalo, ‘Owa Tauwasawasa, Bada yehanaena ulaoma Yaubada i'awa namwanamwaego!’ ‘Nuwadaumwali galewai na walo vetuvehae owa haehae alilim alimwai!’. ");
INSERT INTO kud2014_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ainaena Palisiwo tupwadi bodaone aidiyena Yeisu hiwalo auli, hiwalo, ‘Taubada am taumulitaone uwalo aidiyai ta hilaumwau’. ");
INSERT INTO kud2014_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Na Yeisu iwalo, ‘Havena yalaulaugagayowedi, wuwuna ebe hiya hinobu mata hinage gaimaone hiwui’. ");
INSERT INTO kud2014_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yeisu imahamahalava Yelusalem vahalinai na dalavane mwala'ina i'ita na nuwana iyababa ta idou, iwalo, ");
INSERT INTO kud2014_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","‘Ebe wau teina nuwadaumwali amwahana uhanapui, na hesi wau mehemwai bada itau'aidawani'o. ");
INSERT INTO kud2014_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Hauga ilalaoma mata am alehao ma'wapeyadi hi'aligwaigwaipileyego na tupwa maudoina ainai hiwutu'au'auhigo ");
INSERT INTO kud2014_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","yo higohalo'ego bale'uwai. Na tomowa alomwai mata hi'abiye yababadi. Vada maudoidi mata hi'ovi, na mata nigele gaima ehebo yawenai iyamiyamiya, wuwuna nigele uya'ita lobai haugana Yaubada ilalaowa tauhaguigo.’ ");
INSERT INTO kud2014_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yeisu iluwu vada tapwalolo holanai na tauvegimwalao iheusilidi, na iwalowedi, ");
INSERT INTO kud2014_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","iwalo, ‘Buki Ve'ahihi ainai Yaubada yana walo hileleya'o iwalo: “Yagu Vadane neta aba'awa'awanoi, na hesi omiu ambui ta ebeha yami aba'aivavali”.’ ");
INSERT INTO kud2014_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Na ahubena ehebo ehebo vada tapwalolonane ainai ive'ive'ita, na taupwaoli mwala'idi yo loina ana tauve'itao yo hinage taumugaiwo hi'ai'aipate ta ebe Yeisu hi'oiye mwalowoi, ");
INSERT INTO kud2014_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","na hesi nigele howahowadi, wuwuna Yeisu yana ve'itao tomowa bagibagili alilina nuwadi ivaiya'o. ");
INSERT INTO kud2014_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ehebo hauga ainai Yeisu ive'ive'ita vada tapwalolo mwala'ina ainai, wasa namwanamwana iwalowalo mahalavaei tomowa aidiyai, na taupwaoliwo yo loina ana tauve'itao yo hinage babadao hilaoma ta Yeisu hipanivilaei ");
INSERT INTO kud2014_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","hiwalo, ‘Yaiya towaho yana loinaena ta teina dova upaipaihowane?’ ");
INSERT INTO kud2014_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ainaena Yeisu iwalo aidiyai, iwalo, ‘Mugai yapanivila alimiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yaiya yana loinaena ta Yoni tau'abiye bapitaiso ipaipaihowane, Yaubada bo teya tomowa?’ ");
INSERT INTO kud2014_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ainaena hibom hinuwanuwatuwu, hiwalo, ‘Yana walone mata vedova tayemaihane? Wuwuna ebe tawalo, “Yaubada ainaena”, mata iyemaiha iwalo, “Hava yede vehabana ta Yoni nigele amyayemidiyeine?” ");
INSERT INTO kud2014_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na ebe tawalo, “Tomowa aidiyena”, mata bodaone gaimaena hitalaigita, wuwuna tomowa maudoina Yoni hiyemidiyei ebeha iya ehebo tauwalo mahalava.’ ");
INSERT INTO kud2014_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Eeta yana panivilawa nigele hiyayemaiha ili'ilimani hiwalo, ‘Nigele ayahanapui’. ");
INSERT INTO kud2014_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ainaena Yeisu hinage iwalo, ‘Yau hinage havena alimiyai yawalowalo mahalava yaiya yana loinaena ta teina dova yapaipaihowane’. ");
INSERT INTO kud2014_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yeisu tomowadine iwalo vegevegediyedi, iwalo, ‘Ehebo towaho yana oya i'umai gologolowa a'ava, na yana taupaihowao iloinaedi ta hi'ita avivini, na ibom ilau hali tupwai ta nemai imiya daodao. ");
INSERT INTO kud2014_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Na gigina ana hauga ainai taubadawa yana hevali ehebo ivetamalei ta ebe waini ainona tupwanawa ana tau'ita aviviniwowa aidiyena ivaidima. Ilaulau ta nigele hiyamohei, na bada hisapi ta nimanima a'avana hivetamalei ta ilalau gwaipilene. ");
INSERT INTO kud2014_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Eena taubadawa yana hevali bwauna ivetamalei aidiyai ta hitalai na hinage hi'abiye hinimaya na nimanima'a'avana hivetamalei ta iwuwuyone. ");
INSERT INTO kud2014_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Na hinage tonugana ivetamalei aidiyai yo hinage hitalai ye'i'iwahi na hiheusili mahalavaei oyaena. ");
INSERT INTO kud2014_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","‘Ainaena oyawa taniwagana inuwanuwatuwu ta iwalo, “Hava hinage mata yapaihowaine? Nuwana yau ta'i natugu moiha yavetamalei eeta ebe hive'ahihiyei wuwuna ibom natugu.” ");
INSERT INTO kud2014_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","‘Na hesi haugana tau'ita aviviniwowa taubadawa natunane hi'ita ilaolaoma hibom hi'au'aubabada hiwalo, “Augeluwo, towahone tenem ilaolaomane, ibom taubadawa natu'ehe'ehebona ta'i, ainaena mata ta'oiye mwalowoi na ita oyane taloinaei”. ");
INSERT INTO kud2014_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Eeta hi'abi avivini ta oyaena higabaei aituluwei maseleyai na nemai higohaye mwalowoine. ‘Hava mata taubadane yana tau'ita aviviniwone aidiyai ipaihowaine? ");
INSERT INTO kud2014_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Walo moiha taubadane mata ilaoma na tau'ita aviviniwone i'oiye mwalowoidi ta ebe oyane ana tau'ita avivini vagadi imohedi.’ Ainaena babadaowa Yeisu yana walo teina dova hibenalei ta hiwalo, ‘Mata nigele tenem dova!’ ");
INSERT INTO kud2014_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Na Yeisu i'itadi ta aidiyai iwalo, ‘Vedova yede teina walone Yaubada yana Buki ainai hava ana nuwamasele? Na iwalo: “Logidiwa iya tauvada abi hita'wata'wataei, teina wau itaugwaipile ta inamwanamwa di'wa.” ");
INSERT INTO kud2014_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ebe yaiya ibe'u logidine ainai, mata ilogawowoli ta tupwatupwadi, na ebe logidinane ibe'u teya ewanai mata tauna i'oipihapihagi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tenem ainai taupwaoliwo yo loina ana tauve'itao teya amwa'amwaha hibehabehaei ta ebe Yeisu hi'abi avivini, wuwuna hihanapuiya'o ebeha hibom vehabadi iwalowalo vegevegedine, na hesi nigele hiya'abi avivini wuwuna boda aidiyai himeheuhi. ");
INSERT INTO kud2014_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Eeta hauga maudoina Yeisu hi'ita'ita auhi ta ebe hava yana lauhapuli hilobai, na hiwalo mahalava tauloina ainai ta ilauvetalaei, ainaena tomowa tupwadi hivetamaledi Yeisu ainai ebeha panivilaena hi'oyamaei ta yana lauhapuli hilobai. ");
INSERT INTO kud2014_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ainaena tomowadine hilaoma ta Yeisu hiwalo auli, hiwalo, ‘Taubada, moiha owa yam walowo yo yam ve'itao maudoina dumwadumwaludi, yo hinage ahanapuigo'o ebeha nigele teya tomowa uyamehemeheuhei, na hesi owa Yaubada yana nuwatuwuwo ana tauve'ita moiha. ");
INSERT INTO kud2014_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Eeta vedova, howahowana Tauwasawasa Sisa ainai takesi tamwauwi, bo nigele?’ ");
INSERT INTO kud2014_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Na hesi Yeisu bada yadi oyama ihanapuiya'o, ta aidiyai iwalo, ");
INSERT INTO kud2014_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","‘Yede manene amvaiyama ta ya'ita’. Eeta himohei na iwalo aulidi, iwalo, ‘Amwalo aliguwai yaiya teina alu'aluwana yo yehana manene ainai?’ Na hiya hiwalo, ‘Tauwasawasa Sisa’. ");
INSERT INTO kud2014_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Eeta Yeisu iwalo, ‘Ehe, ainaena Sisa yana ginauli, ammoheuyoi Sisa ainai, na Yaubada yana ginauli Yaubada ammohei’. ");
INSERT INTO kud2014_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yeisu yana walo teina boda mehediyai maudoina dumwadumwaluna, nigele teya walo hapuli ainaena hiyalobai, na hesi mayadi nuwapwanopwano himiya nobu. ");
INSERT INTO kud2014_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Hinage tupwadi Sadusiyao, hiya nigele hiyayemidi taumwalowoi yadi towolouyo vehabana, hilaoma ta Yeisu ainai hipanivila, hiwalo, ");
INSERT INTO kud2014_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","‘Taubada, ada loina teina dova Mosese ileleya'o, iwalo, “Ebe teya towaho itawahola na nigele natunao na imwalowoi, towahonane tahina hiwapenane itawaholai ta ebe waihiune ilabalaba neta natunaone taumwalowoine miyalaenao”.’ ");
INSERT INTO kud2014_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Eeta aba'ita himohei, hiwalo, ‘Ehebo towaho matahinao himiyamiya adi bagibagili hitau 7, na adi tautuwane itawahola na mulitai mwanena nigele iyalabalaba, na towahonane imwamwalowoine. ");
INSERT INTO kud2014_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Na vahalinaena waihiune itatawaholaine. ");
INSERT INTO kud2014_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Yo hinage tonugadine na maudoidine adi bagibagili 7 dova hinage. Nigele natudiyao na himwalowoi ovine. ");
INSERT INTO kud2014_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Na bada tomowaone maudoidi himwalowoi'o, na mulitai waihiuwa hinage imwamwalowoine. ");
INSERT INTO kud2014_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Hava unuwatuwui teina tomowaone vehabadi, aiteya towaho wahiune mwanena moiha, haugana ebe mwalowoiyena hitowolouyo? Wuwuna hitau 7 bada hitawaholaiya'o.’ ");
INSERT INTO kud2014_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Eeta Yeisu yadi walo iyemaiha, iwalo, ‘Amnuwatuwu avivini neta hauga teina ainai waihiu na towaho hitawatawahola, ");
INSERT INTO kud2014_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","na hesi hauga ilalaoma ainai ebe waihiu na towaho mwalowoiyena hitowolouyo nigele mata hiyatawahola. ");
INSERT INTO kud2014_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Wuwuna mata hiya dova tausagenawasao na mata havena hiyamwalomwalowoi, na hesi Yaubada i'awa natunaedi, wuwuna mwalowoiyena hitowolouyo'o. ");
INSERT INTO kud2014_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","‘Mosese mugai bada ive'ita ili'ilimanigita'o taumwalowoi yadi towolouyo vehabana. Haugana nu'ula awawai ilaulau na Yaubada aiwa hawahawawalina ainaena iwalo auli, iwalo, “Yau Abelaham yo Aisake yo Yakobo yadi Yaubada!”. ");
INSERT INTO kud2014_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Teina tahanapui ebeha iya nigele taumwalomwalowoi yadi Yaubada na hesi hiya mayawahidi yadi Yaubada, wuwuna teina babadaone Yaubada yana tupwai teina hauga mayawahidi himiyamiya.’ ");
INSERT INTO kud2014_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","Tenem ainai loina ana tauve'itao himeheuhi, ta tupwadi hiwalo, ‘Tauve'ita, yam yemaiha inawanamwa alili’, ainaena nigele teya panivila hiyamohei. ");
INSERT INTO kud2014_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Eeta Yeisu hinage ipanivila aidiyai, iwalo, ‘Vedova ta tupwadi tomowa hiwalo Deivida yana huhu ainaena Yaubada yana Besinana mata imahalava, ");
INSERT INTO kud2014_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","wuwuna Sam ainai Deivida iwalo: “Yaubada iwalo yagu Bada ainai, iwalo: Nima tautuwaguwena umiya, ");
INSERT INTO kud2014_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ana higa am'alehao yamwau aituluwedi aem elauhanai.” ");
INSERT INTO kud2014_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Deivida iya Besinana i'awa badaei, vedova yede ta Deivida tubuna ainaena mulitai abo Besinana ilaoma?’ ");
INSERT INTO kud2014_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Boda maudoidi hibenabenali na Yeisu ana taumulitao aidiyai iwalo, ");
INSERT INTO kud2014_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","‘Tahiguwao, havena loina ana tauve'itao yadi mumuga ammulimulitaedi. Wuwuna hiya mumugadi ta'i dova hauga maudoina nuwanuwadi adi ale'owo daodaodi hili'wali'wadi na tomowa ahi'ahipudiyai hilaulau gwaipileuhi ta ebe hive'ahihiyedi. Na hinage nuwanuwadi yadi abamiya namwanamwadi vada tapwalolo aidiyai yo hinage yemahuli adi haugai nuwanuwadi ebe vatavatai himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Na hinage tomowa maudoidi mehediyai Yaubada ainai yadi awanoi daodaona, na hesi yadi awanoine nigele namwanamwana, wuwuna atediyai hinuwanuwatuwu vedova mata hiwahiwapewo hi'oyamaedi ta yadi tobwatobwao hivaidi. Ainaena Yaubada mata maiha yababana imohedi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yeisu ivinuvinunu na wasawasao yadi velau mane ana abamwau ainai himwaumwauwidi. ");
INSERT INTO kud2014_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ivinuvinunu na ehebo hiwape wewelohena i'ita lobai, ihae ta yana velau mane bwau habuludi dova toea ehebo imwamwauwine. ");
INSERT INTO kud2014_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ainaena Yeisu iwalo, ‘Moiha maudoidi aidiyena hiwapene tenem yana velaune imwala'i alili, ");
INSERT INTO kud2014_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","wuwuna tomowa maudoidi yadi tupwa mwala'idi himiyamiya, na hesi hiwapene tenem wewelohena, na yana mane maudoina imwauwiya'o na nigele teya hinage yana tupwa iyamiyamiya ta ebe ainaena ana igimwala’. ");
INSERT INTO kud2014_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yeisu ana taumulitao tupwadi vada tapwalolo mwala'ina ana ita namwanamwana hi'itaya'o ta Yeisu ainai hiwalo, ‘Taubada, vada tapwalolo mwala'ina teina ana pasao adi ita hinamwanamwa alili, wuwuna gaima mwala'idi aidiyena hi'a'abine, na hinage tomowa yadi velau tobwatobwa namwanamwadi aidiyena hiyeyepasane’. Eeta Yeisu aidiyai iwalo, ");
INSERT INTO kud2014_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","‘Vadaone wau am'ita'itadine, mata hauga ilalaoma ainai maudoidi hilo'evehuludi na nigele hinage teya tupwana amya'itauyoi’. ");
INSERT INTO kud2014_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Eeta Yeisu ainai hipanivila, hiwalo, ‘Tauve'ita uwalo alimaiyai aiteya hauga ainai vada tapwalolone mwala'inane mata hilo'ene, na aiteya ve'ive'ilala adi oleya aidiyena ahanapui ebeha ginauliwowa uwawalowedine mata himahalava?’ ");
INSERT INTO kud2014_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ta Yeisu aidiyai iwalo, ‘Am'ita avivinigomiu mata dova ta tomowa tupwadi hi'oyamaegomiu, wuwuna howola abo tomowa bagibagilidi yehaguwena hilaoma na himugai pwanoliyegomiu na hiwalo, “Yau Yaubada yana Besinana”, ta hiwalo, “Hauga bada imahalava'o”. Na hesi havena yadi walo ammulimulitaedi. ");
INSERT INTO kud2014_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Na ebe hinage aleha yo manini wasadi ambenaledi, havena am'ate'atehawawali, wuwuna ginauli teina mata himahalava mugai na hesi bale'u yana aba'ovi ana hauga howola.’ ");
INSERT INTO kud2014_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Na hinage iwalo, ‘Mulitai mata teya boda hive'aleha teya boda ainai. Yo hinage teya abaloina ive'aleha vali abaloina ainai. ");
INSERT INTO kud2014_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Na hauganane ainai mwani'ini'i dalava bagibagilidi aidiyai, yo vahali mwala'ina, yo dawodawowo mwala'ina, yo hinage mata abanuwapwanopwano na abameheuhi galewaena himahalavama. ");
INSERT INTO kud2014_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Na mulitai teina ginauli himahalava, mugai ami alehao hi'abi avivinigomiu na hi'abiye muyagomiu, na hinage vada tapwalolo aidiyai hilauvetalaegomiu na vada paipaiyai hihiwaluwuwegomiu. Na hinage mata tauwasawasao yo tauloinao mwala'idi aidiyai hilawegomiu ta hilauvetalaegomiu wuwuna omiu yagu bodao. ");
INSERT INTO kud2014_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yami lauvetala aidiyai wasagu amwalo mahalavaei aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Na havena yami nuwatuwu bahudi, ebe haugana amtowoi ta aidiyai am'aubabada. ");
INSERT INTO kud2014_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Wuwuna yau mata walo dumwaluna yo hanapu yamohegomiu, ta ebe ami alehao havena hi'awa'awa oya'oyamaegomiu. ");
INSERT INTO kud2014_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Haugana ainai mata tamamiyao yo hinamiyao yo tahimiyao yo yami huhuwo yo hinage ami geluwo hihuhulaegomiu, na tupwadi alimiyena hiyemwalowoidi. ");
INSERT INTO kud2014_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mata yehagu vehabana na tomowa maudoidi hita'wata'wataegomiu. ");
INSERT INTO kud2014_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Na hesi mata nigele ulu'ulumiyai vahu ehebo iya'wadalele. ");
INSERT INTO kud2014_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yami towolo wahiyala vehabana mata livahi moihana amlobai. ");
INSERT INTO kud2014_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","‘Ebe aiteya hauga ainai Yelusalem am'ita na tau'alehao himiya gwaigwaipileyei amhanapuiya'o ebeha bada Yelusalem yana hauga yababana ilalauvahavahali. ");
INSERT INTO kud2014_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ainaena Yudeya ana taumiyao howahowana ebe oya aidiyai hidena. Na hinage Yelusalem ana taumiyao howahowana ebe dalavaena himahalava. Hinage dova hiya nu'ulai hipaipaihowa havena dalavai hiwuyowuyouyo. ");
INSERT INTO kud2014_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ahubenaone teina aidiyai Yaubada yana loina mata imahalava tomowa aidiyai, ta ebe Yaubada yana Buki yana walomahalava mugai ana moiha maudoina imahalava. ");
INSERT INTO kud2014_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","‘Hauga tenem ainai tauhiuhiumao yo tauvehuhuwo mata hive'atemuyamuya, wuwuna hauga vitaina taumiya bale'u vehabadi, na tenem ainai mata Yaubada yana modi'iniyena taumiya Yudeya miyavitai moiha hilobai. ");
INSERT INTO kud2014_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Neta mata tau'alehao tupwadi tomowa hi'oiye mwalowoidi na tupwadi hi'abi avivinidi ta dalava vagana vagana aidiyai hivetamaledi, na alehanane ainai, nigele Yudeya mata hiwahiyala ta Yelusalem maudoina hiloinaei na ainai hilaulau gwaigwaipile ana higa yadi hauga ilaumwau. ");
INSERT INTO kud2014_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","26","‘Hinage mulitai mata ve'ive'ilala himahalavama mahana yo wai'ena yo utui aidiyena, na taumiya bale'u maudoidi mata yadi meheuhiyena hitai, wuwuna bagodu woiyawa udoidi mata hilasahaema, na ainaena mayadi meheuhi mwala'ina hiha'waha'wa ebeha aiteya ginauli yo hinage aiteya yababa mata bale'uwai imahalava, wuwuna ginauli bagibagilidi galewai himiyamiya yadi wahiyala mata hitapiya. ");
INSERT INTO kud2014_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Na hauga tenem ainai taumiya bale'u maudoidi Towaho Moihagu hi'itagau yaloyalovi aidiyena ya'ai'aituluma mayagu wahiyala yo mayagu wasawasa mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Na ebe ve'ive'ilalaone teina hivetuwuni mayamayauni na am'itadi, howahowana am'atepatu na am'ita hae, wuwuna ami taulivahi bada ilalaoma.’ ");
INSERT INTO kud2014_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Yeisu hinage ehebo walo vegevegedi iwalowei, iwalo, ‘Aiwane hapelo yo hinage tupwadi aiwao ebe am'itadi na ainodi vauvaudi imwaumwauwidi, amhanapuiya'o ebeha ehive ana hauga ilalauvahavahali. ");
INSERT INTO kud2014_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Dova hinage ebe ve'ive'ilalaone am'ita lobaidi, amhanapuiya'o ebeha iu'iuna na Yaubada yana loina imahalavama. ");
INSERT INTO kud2014_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","‘Moiha yaso teina nigele mata amya'ovi ana higa ginauli teina himahalava. ");
INSERT INTO kud2014_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Galewa yo bale'u mata hisawali na hesi yagu walowo mata nigele hiyasawali. ");
INSERT INTO kud2014_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","‘Am'ita avivinigomiu ta havena amyemayemahuli yo numanuma wahiwahiyalana adi numa aidiyai amlaulau ala'alabili, yo hinage havena yami miyamiya bale'uwai vehabana amnuwanuwatuwu ala'alabili, mata dova ta ahubenanane ainai Yaubada ive'aluwagavaigomiu ta dova vinaya ainaena i'onagomiu. ");
INSERT INTO kud2014_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Wuwuna ahubenanane ainai mata taumiya bale'u maudoidi ive'aluwagavaidi loina yana mahalava ainaena. ");
INSERT INTO kud2014_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ainaena am'atububuni vateyai na hauga maudoina am'awa'awanoi ta ebe mayami atepatu ginauli teina aidiyena amwahiwahiyala na ebe yau Tomowa Moihagu meheguwai amtowolo.’ ");
INSERT INTO kud2014_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Hauga tenem aidiyai Yeisu vada tapwalolo ainai ive'ive'ita, na lavilaviyena iwuyo Olibe oyana ainai ta i'e'enona, ");
INSERT INTO kud2014_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","na malatomtom habuluna tomowa ehebo ehebo hilaulau vada tapwalolo mwala'ina ainai Yeisu habibenaleina. ");
INSERT INTO kud2014_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Buidi'wa guyauna ana hauga bada ilauvahavahaliya'o ta pwalawa a'avana nigele ana abiye seseha hi'ai'ai. ");
INSERT INTO kud2014_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Hauganane ainai taupwaoliwo yadi babadao yo loina ana tauve'itao hinuwanuwatuwu behabeha vedova na Yeisu hi'abi avivini ana oiyemwalowoi vehabana, na hesi nigele howahowadi, wuwuna boda himeheuhedi. ");
INSERT INTO kud2014_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tenem ainai Tomodulele Yudasa ainai iluwu, ibom yehana bwauna Isakaliyota, na hinage Yeisu ana taumulita ehebo hitau 12 aidiyena. ");
INSERT INTO kud2014_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Eeta Yudasa ilau taupwaoli yadi babadao yo vada tapwalolo ana tau'ita ita aviviniwo aidiyai baidadi hi'ulewahi ta ebe vedova na Yeisu ihuhulaei ta hi'abi avivini. ");
INSERT INTO kud2014_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ainaena Yudasa yana walo vehabana hiyaliyaya na ainai hiwalo yemidi ta ebe ana maiha himohei. ");
INSERT INTO kud2014_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ta Yudasa aidiyai italam, ainaena hauga namwanamwana iha'waha'wai ta ebe Yeisu aidiyai ihuhulaei na hi'abi avivini, na havena tomowa mehediyai. ");
INSERT INTO kud2014_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Buidi'wa guyauna ana ahubena bada ilaoma'o ta pwalawa nigele ana abiye seseha hi'ai'ai, yo hinage sipi natunatudi hiwunuidi Buidi'wa ana abanuwatuwu avivini vehabana. ");
INSERT INTO kud2014_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ainaena Yeisu ana taumulitao Yoni na Pita ivenuwamwauwedi, iwalo, ‘Amlau ta Buidi'wa guyauna vehabada am'atububuni’. ");
INSERT INTO kud2014_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Na hiwalo, ‘Havaidova ainai nuwanuwam ebe a'atububuni?’ ");
INSERT INTO kud2014_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yeisu aidiyai iwalo, ‘Amlau Yelusalem ammahalava na ebe towaho ehebo bwahi abagoi i'ava'avalai amlobai, towahonane ammulitaei, na ebe vadai iluwu omiu hinage vadanane ainai amluwu. ");
INSERT INTO kud2014_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Na vadane taniwaganane amwalo auli teina dova, amwalo, “Yama tauve'ita teina dova iwawalone, iwalo, Nuwanuwagu teya tupwa utalamwei ta ma'agu taumulitao Buidi'wa guyauna a'ai?” ");
INSERT INTO kud2014_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Iya mata tupwa mwala'ina ewai ive'itagomiu, ta ainai Buidi'wa guyauna am'abinonovai vehabada.’ ");
INSERT INTO kud2014_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Eeta taumulitaowa hilau ta hava dova Yeisu iwawalo mahalavaeiwa ginauli maudoina hilolobaidine, ta vadanane ainai Buidi'wa guyauna hi'a'atububunine vehabadi. ");
INSERT INTO kud2014_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Bada ai'ai hi'atububuniya'o ta Yeisu mayana tauyewasao himiya ahaiyama ta baidanao hi'ai'ai, ");
INSERT INTO kud2014_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","na yadi ai holanai Yeisu iwalo aulidi, iwalo, ‘Nuwanuwagu mwala'ina na omiu baidagwao Buidi'wa ai'aina teina ta'ai na ebe mulitai taugu imuya. ");
INSERT INTO kud2014_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Moiha, yagu ai teina yana aba'ovi, ta havena hinage Buidi'wa guyauna ya'ai'aiuyoi ana higa ana hanapu moiha imahalava Yaubada yana Abaloina ainai.’ ");
INSERT INTO kud2014_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ainaena waini mavedina ivai ta vehabana i'awa yauwedo Yaubada ainai na mulitai iwalo aulidi, iwalo, ‘Vedi teina amvai ta ehebo ehebo maudoimiu amnuma. ");
INSERT INTO kud2014_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Na yawalo alimiyai hauga teina na tuluhanai, waini teina havena mata yanumauyoi ana higa Yaubada yana Abaloina imahalava.’ ");
INSERT INTO kud2014_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Mulitai ai'ai ivai ta i'awa yauwedo na itomwatomwahi ta imohemohedi na iwawalone iwalo, ‘Teina taugu, omiu yamomohegomiu agu abanuwatuwu avivini vehabana teina dova ampaipaihowai.’ ");
INSERT INTO kud2014_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Dova hinage ai tuluhanai na vedi ivai ta iwalo, ‘Teina 'wahinagu Yaubada yana waloyemidi vauvauna tomowa maudoimiu vehabamiu mata isagena’. ");
INSERT INTO kud2014_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Aine alonai Yeisu iwalo, ‘Am'ita, tauhuhulaegaune towahonane iya baidagu teina aba'aine ainai. ");
INSERT INTO kud2014_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tomowa Moihagu mata Yaubada yana nuwatuwuwena yamwalowoi, na yaiya tauhuhulaegaune neta iya taunuwayababa!’ ");
INSERT INTO kud2014_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ainaena ana taumulitaone hibom aidiyai hi'au'aubabada, hiwalo, ‘Yaiya yede yana nuwatuwu tenem dova ta ebeha ipaihowai?’ ");
INSERT INTO kud2014_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yeisu ana taumulitaone aidiyena ve'awapa'ipa'i'i imahalava ebeha yaiya ihae alili maudoidi aidiyena. ");
INSERT INTO kud2014_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Eeta Yeisu iwalo aulidi, iwalo, ‘Bale'uwai tauwasawasao yadi tomowao aidiyai hiloiloina, ta taupaihowao yadi loinao hi'awa'awa namwanamwaedi, ");
INSERT INTO kud2014_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","na omiu nigele dova hiya, na hesi yaiya omiu alimiyena ihae howahowana imiya'aitulu dova heda, yo hinage ami taumugaiwo hivetaupaihowa vehabamiu. ");
INSERT INTO kud2014_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","‘Yaiya tomowa iya ihae aliline? Tomowane aba'aiyai imiyamiyane bo tomowane ipaipaihowane? Nuwana tomowane aba'aiyai imiyamiyane iya ihae alili, bo? Na yau gamwagamwanimiyai dova taupaihowa. ");
INSERT INTO kud2014_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","‘Moiha omiu yagu miya vitai aidiyena amtowolo wahiyala'o ta teina hauga baidaguwo tamiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ainaena hava dova Tamagu yagu abaloina imohegau'o omiu hinage dova yamomohegomiu, ");
INSERT INTO kud2014_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ta omiu yagu abaloina ainai baidaguwo mata ta'ai yo tanuma, yo hinage vatavata wasawasa aidiyai ammiya na Isileli yadi huhuwo 12 amloinaedi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Hinage Yeisu iwalo, ‘Saimoni, ubenali, Tomodulele bada talam ivaiya'o ebeha maudoimiu itowoigomiu, yo iwaheigomiu dova oya ana taupaihowa yana witiwo iwahewaheidi, ");
INSERT INTO kud2014_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","na hesi havena towoiwone ainai utapitapiya, wuwuna bada vehabam ya'awanoi'o yamtowolo wahiyala vehabana. Ta ebe aiteya hauga u'ita gwaipile tahimwao hinage u'abiye wahiyaladi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Na Pita iwalo, ‘Bada, yatalamwegau'o mata owa baidagu talau vada paipaiyai ta tamwalowoi’. ");
INSERT INTO kud2014_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Na Yeisu iwalo, ‘Pita yawalo moiha alimwai, mata masigiliyena mulitai abo am'am towahona idou, owa mata mai tonuga uuvalaegau ebeha nigele uyahanapuigau’. ");
INSERT INTO kud2014_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Eena Yeisu ipanivilaedi iwalo, ‘Haugana yavetamalegomiu na amlaulau havena yami mane ana abado'o amvavai yo havena yami peha yo aehumahuma amvavaidi. Hauganane ainai vitai amlobai, bo nigele?’ Na hibom hiwalo, ‘Nigele teya hinage hava’. ");
INSERT INTO kud2014_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ainaena Yeisu iwalo, ‘Hesi wau yami mane ana abado'o yo yami pehi amvaidi. Na ebe yaiya alimiyena nigele yana elepa ale'aleha ana ale'o ivegimwalaei ta maihanane ainaena yana elepa ale'aleha igimwalai. ");
INSERT INTO kud2014_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","‘Yawalo auligomiu ebeha teina wuwuna ta Buki Ve'ahihi ainai iwalo, ‘Iya taumumuga yababao baidanao hivahili eheboidi, wuwuna hava vehabagu hilelelelene iyeyemala moiha. ");
INSERT INTO kud2014_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yo hinage hiwalo, ‘Bada, u'ita teina elepa ale'alehao bwau’. Na Yeisu iyemaihadi iwalo, ‘Neta badagi’. ");
INSERT INTO kud2014_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yeisu dalava mwala'ina ilaugabaei ta mayana taumulitao hilau gwaipile Olibe oyana ainai. Hauga tupwadi teina dova yadi paihowa. ");
INSERT INTO kud2014_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Dalavanane ainai hilaoma ta Yeisu ana taumulitao iwalo aulidi iwalo, ‘Am'awa'awanoi Yaubada ainai ta ebe havena abatowoi amve'ave'alodi’. ");
INSERT INTO kud2014_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Na ilaugabaidi ta ilau lovai dova gaima ta gabaei ana daodao na aetutu tulina i'atuwomalei ta i'awa'awanoi, ");
INSERT INTO kud2014_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","iwalo, ‘Tamagu yo, ebe nuwanuwam muya vedina teina aliguwena uvaivehulu. Havena yau yagu nuwatuwu ainaena, na hesi owa yam nuwatuwuwena upaihowai.’ ");
INSERT INTO kud2014_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ainaena Yaubada yana tausagenawasa galewaena imahalava ta Yeisu i'abiye wahiyalane, ");
INSERT INTO kud2014_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","na hesi nuwanane ivitai moiha, na i'awanoi hamahamadudu, ta yamuyamumuna dova 'wahina isagesagena bale'uwai. ");
INSERT INTO kud2014_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yeisu yana awanoi i'ovi na itowolo ta ilau gwaipileuyo, ana taumulitaowa aidiyai, na ilobaidi nuwayababa ainaena bada hi'eno i'iwahi'o, ");
INSERT INTO kud2014_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","eeta iwalo aulidi, iwalo, ‘Havena am'eno'eno. Amtowolo na am'awa'awanoi, ta ebe havena towoi amve'ave'alo.’ ");
INSERT INTO kud2014_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yeisu howola i'au'aubabada na boda himahalava, Yudasa baidadi, ibom Yeisu ana taumulita ehebo, na bodaone imumugaiyedine. Yudasa ilaoma Yeisu vahalinai ta ebeha inihoi, ");
INSERT INTO kud2014_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","na Yeisu iwalo, ‘Yudasa, ebeha yau Towaho Moihagu nihowena uhuhulaegau, bo?’ ");
INSERT INTO kud2014_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Na Yeisu ana taumulitaowa hihanapuiya'o hava mata imahalava, ainaena hiwalo, ‘Bada yama elepa ale'alehao ayepaihowadi, bo havedi?’ ");
INSERT INTO kud2014_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na ehebo ana taumulita yana elepa ale'aleha ilauhini ta taupwaoli mwala'ina yana taupaihowa talina tautuwana itomvehulune. ");
INSERT INTO kud2014_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Na Yeisu iwalo teina mumugane amlaumwau, ‘Havena neta dova!’ Na mulitai Yeisu towahowa talinanawa i'abisawahi ta i'abiye namwanamwane. ");
INSERT INTO kud2014_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Eeta taupwaoli babadadiyao yo vada tapwalolo ana tau'ita aviviniwo yo Yudeya yadi tauloinao hilalaomane, na Yeisu aidiyai iwalo, ‘Hava ta dova yau tau'aivavali na mayami elepa ale'alehao yo yami wepasi amlaoma habi abi'avivinigau! ");
INSERT INTO kud2014_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Na hava ta nigele amya'abi avivinigaune ahubena bagibagilidi haugana ahi'ahipumiyai yamiyamiya vada tapwalolo mwala'ina holanai, na yave'ive'ita tomowa aidiyai. Hesi teina omiu yami mahana haugana yo guguyou yana wahiyala iloina.’ ");
INSERT INTO kud2014_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Eeta Yeisu hi'abi avivini ta hilawei taupwaoli yadi tauloina mwala'ina yana vadai. Na Pita amwaha daodaowena imulimulitaedi. ");
INSERT INTO kud2014_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Vadanane ana abwalu holanai taupaihowao aiwa hivatali ta himwaimwaibwa. Pita i'itadi ta aidiyai hinage iluluwune ta himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Eena taupaihowa ehebo waihiuna Pita ivinuvinunui ta iwalo, ‘Towahone teina mwalona Yeisu baidana ya'i'itadine’. ");
INSERT INTO kud2014_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Na Pita iuvala, iwalo, ‘Waihiu, Yeisu nigele yayahanapu towoi’. ");
INSERT INTO kud2014_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mulitai ehebo hinage towaho Pita ivinuvinunui ta ainai iwalo, ‘Owa ehebo ana taumulita’. Na Pita iwalo, ‘Towaho! Yau nigele!’ ");
INSERT INTO kud2014_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Eena tupwana himiya daodao na towaho ehebo hinage alinana mwala'ina ana geluwo aidiyai iwalo, ‘Moiha teina towahone iya Yeisu ana taumulita ehebo, wuwuna iya Galili towahona’. ");
INSERT INTO kud2014_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Na Pita iwalo, ‘Augelu, towahone vehabana uwalowalone nigele yayahanapui’. Howola i'au'aubabada na bada am'am towahona idodoune. ");
INSERT INTO kud2014_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Eena Bada i'ita gwaipile ta Pita ivinuvinunui, na tenem ainai Pita inuwatuwui haugana Bada yana walo iwalo, ‘Mata boniyaine, mulitai abo am'am idou owa uuvalaegau mai tonuga’. ");
INSERT INTO kud2014_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ainaena Pita nuwana iyababa mwala'ina ta imahalava maseleyai na idoudou vehuludi. ");
INSERT INTO kud2014_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tau'alehaone Yeisu hi'abi avivini na hi'abi'abitalawahiyei na hitalatalai. ");
INSERT INTO kud2014_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Yo hinage mehena hihumadi ta ebe havena i'ita'itadi na hiwalo, ‘Uwalo mahalava yaiya itatalaigone?’ ");
INSERT INTO kud2014_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na tupwadi hinage walo yababadi aidiyena hiwalowalodebai. ");
INSERT INTO kud2014_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","I'ahubena gabaei, ta tau'ulewahiwo yo taupwaoli babadadi yo loina ana tauve'itao himiya ahaiyama, ta ahi'ahipudiyai Yeisu hivetowolo. ");
INSERT INTO kud2014_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Na hipanivilaei, hiwalo, ‘Uwalo dumwalu alimaiyai ebeha owa Besinana towahona’. Eeta Yeisu aidiyai iwalo, ‘Nigele amyayemidiyegau ainaena havena yawalowalo mahalava alimiyai, ");
INSERT INTO kud2014_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","wuwuna ebe panivila yamohegomiu nigele mata amyayemaihadi. ");
INSERT INTO kud2014_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Na amhanapui ebe hauga teina i'ovi na mulitai yau Towaho Moihagu mata Yaubada Tauwahiyala nima tautuwanai yamiyamiya.’ ");
INSERT INTO kud2014_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ainaena maudoidi hiwalo, ‘Yede, owa Yaubada Natuna?’ Eena yadi walo iyemaiha, iwalo, ‘Bada amwalo'o neta yau’. ");
INSERT INTO kud2014_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Eeta hiwalo, ‘Yana walo yababana bada tabenalena'o, ainaena havena ana tauve'ewao vehabadi tanuwanuwatuwu, wuwuna bada tabom tabenalena'o hava iwawalowedine’. ");
INSERT INTO kud2014_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ainaena maudoidi hitowolo ta Yeisu hilauvai hilawei tauloina mwala'ina yehana Pailato mehenai. ");
INSERT INTO kud2014_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Na hivetuwuni yo hive'ewai hiwalo, ‘Towaho teina yana ve'itao abenaledi'o neta alobai tomowa ive'ive'ita pwanolidi iwalo havena Sisa ainai ataketakesi, wuwuna, iwalo iya Besinana towahona yo tauwasawasa’. ");
INSERT INTO kud2014_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Eeta Pailato Yeisu ipanivilaei, iwalo, ‘Uwalo mahalava: owa Yudeya yadi Tauwasawasa, awa?’ Na Yeisu iyemaiha, iwalo ‘Bada neta uwalo'o’. ");
INSERT INTO kud2014_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Na mulitai Pailato taupwaoliwo babadadi yo bodao iwalo aidiyai, iwalo, ‘Towaho teina nigele teya yana pwanoli yayalobai’. ");
INSERT INTO kud2014_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Hesi hiya hiwalo hamahamadudu hiwalo, ‘Yana ve'itaena tomowa gamwagamwanidiyai manini ivetuvetuwuni, Yudeya tupwana maudoina alonai Galili ainai ivetuwuni ilaoma ta wau teina ainai.’ ");
INSERT INTO kud2014_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Yadi walo Pailato benaledi na aidiyai iwalo, ‘Vedova teina Galili gamana, awa?’ ");
INSERT INTO kud2014_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Na hiya hiwalo, ‘Ehe, neta dova’. Ainaena Pailato iloinaedi, iwalo, ‘Galili neta Helodi yana abaloina, ainaena Yeisu amlawei Helodi ainai ta ibom iloinaei, wuwuna teina hauga Helodi bada Yelusalem ainai ilaoma'o’. ");
INSERT INTO kud2014_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hilawei Helodi ainai, na haugana Helodi Yeisu i'ita, iyaliyaya mwala'ina, wuwuna hauga daodaona Helodi nuwanuwana Yeisu i'ita, na wasana ibenaledi'o ta yana paihowa vedevedede nuwanuwana yo i'itadi. ");
INSERT INTO kud2014_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ainaena Helodi Yeisu ipanivilauhei, na hesi nigele teya yana walowone iyayemaiha. ");
INSERT INTO kud2014_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Na taupwaoli babadadi yo loina ana tauve'itao hihae Helodi ainai ta Yeisu hive'ewa hamahamadudui. ");
INSERT INTO kud2014_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Eeta Helodi mayana tau'alehao Yeisu hi'abitalawahiyei yo hi'awa yababaei. Na mulitai tauwasawasa adi ale'o hiveli'wa na hivetamaleuyoi Pailato ainai. ");
INSERT INTO kud2014_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hauga tenem ainai Helodi yo Pailato yadi abi'waunihaniha hauga daodaona ainai hive'au'augelu. ");
INSERT INTO kud2014_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ainaena Pailato taupwaoli babadadiyao yo babadao tupwadi yo taumiya Yudeya iyogagogoidi, ");
INSERT INTO kud2014_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ta iwalo, ‘Towaho teina aliguwai amlawenama ta amwalo mahalavaei ebeha tomowa ive'ive'ita pwanolidi, ta bada hinage mehemiyai yalauvetalaena'o na hesi nigele teya yana pwanoli yayalobai yami ve'ewaone aidiyena. ");
INSERT INTO kud2014_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Helodi hinage nigele teya lauhapuli iyalobai, eeta aliguwai ivevetamalenamane. Ainaena nigele oiyemwalowoi iyalowoinanei, ");
INSERT INTO kud2014_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","na hesi sapi a'ava ammohei na yatalam ebeha imahalava.’ ");
INSERT INTO kud2014_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Buidi'wa abanuwatuwu avivinina ehebo ehebo ainai Pailato taupwanoli ehebo ilivalivahi vada paipaiyena, ebe boda nuwanuwadi. ");
INSERT INTO kud2014_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ainaena bodaone hiwui toyawatoyawa hiwalo, ‘Ibom imwalowoi, na hesi Balabasi ulivahiyama vehabamai’. ");
INSERT INTO kud2014_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balabasi iya oiyemwalowoi vehabana vada paipaiyai himwamwauwine, wuwuna dalavanane ainai mugai Balabasi ma'ana geluwo, taumiya Loma hilo'alehaidi ta tupwadi boda hi'oiye mwalowoidine. ");
INSERT INTO kud2014_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Na hesi Pailato nuwanuwana ebeha Yeisu ilivahi, ainaena bodaone ipanivilaeuyoidi, ");
INSERT INTO kud2014_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","na hesi hiya ta'i hiyogauyo, hiwalo, ‘Uve'abahi, uve'abahi!’. ");
INSERT INTO kud2014_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pailato yana walo tonugana ainai iloinaedi, iwalo, ‘Hava yede yana pwanoli ta ebeha mwalowoi ilobai? Wuwuna nigele teya lauhapuli ainaena yayalobai. Na hesi sapi a'ava ilowoinanei na mulitai talivahi.’ ");
INSERT INTO kud2014_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Na bodaowa howola ta'i hiwuiwui hamahamadudu, hiwalo, ‘Aiwa lagalaga ainai ta'oiye mwalowoi!’. Eeta yadi wuine i'awa abiyei, ");
INSERT INTO kud2014_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ainaena Pailato aidiyai italam ta ebeha Yeisu hive'abahi. ");
INSERT INTO kud2014_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Na tomowaowa nuwanuwadi ta ebeha Balabasi ilivahi vehabadi, ibom tau'oiye mwalowoi teya vada paipaiyai himwamwauwine, mugai iya taumiya Loma adi taumugaiwo i'ale'alehaidi. Eeta Pailato bodaowa nimadiyai Yeisu imwauwi ta ebe yadi nuwatuwuwa hipaihowai. ");
INSERT INTO kud2014_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yeisu hilauvai hilalawei na amwahai ehebo towaho yehana Saimoni hilobai, iya Sailini towahona, dalava tulunaena imahalava ta iluluwu dalava mwala'ina ainai. Ainaena taulo'alehaone Saimoni hi'abiye meheuhi ta Yeisu ana aiwa lagalaga i'avalai ta imulimulitaei. ");
INSERT INTO kud2014_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Na boda mwala'ina Yeisu himulimulitaei, na hinage waiwaihiu bagibagilidi himulimulita na hidoudou mayadi nuwayababa Yeisu vehabana. ");
INSERT INTO kud2014_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Na Yeisu i'ita gwaipile ta waiwaihiwowa aidiyai iwalo, “Omiu Yelusalem waiwaihiuwo, havena vehabagu amdoudou, na hesi ambom vehabamiu yo natumiyao vehabadi amdou, ");
INSERT INTO kud2014_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","wuwuna hauga ilalaoma ainai vitai mata imahalava na yaiyadiwo omiu yaiyaipoimiu yo nigele natumiyao yo nigele amyavehuvehuhu, mata namwanamwa amlobai. ");
INSERT INTO kud2014_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Haugadine aidiyai mata tomowa oya aidiyai hiwalo, ‘Ambe'uma ewamaiyai!’, na oya habuludi aidiyai hiwalo, ‘Amhamuigai!’. ");
INSERT INTO kud2014_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Wuwuna ebe ginauli teina hipaihowai haugana aiwa ma'idahina, hava mata imahalavane haugana aiwane ipogi?’ ");
INSERT INTO kud2014_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Eena towatowaho yababadi bwau hilauvaidi Yeisu baidanao ta ebe hi'oiye mwalowoidi. ");
INSERT INTO kud2014_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Eeta hilau ehebo tupwa ainai himahalava yehana Ulu'ulu, dalavana ta aiwa lagalaga bale'uwai himwauwi na Yeisu ainai hitutuye patu na hivetowolone, hinage towatowahowowa yababadiwa hitau bwauwa adi aiwa lagalaga aidiyai hinage hitutuye patudi, ehebo Yeisu nima tautuwanaena na ehebo Yeisu nima eha'ehanaena hivevetowolodine. ");
INSERT INTO kud2014_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Na Yeisu iwalo, ‘Tamagu yo, yadi paihowa teina unuwahamuidi, wuwuna nigele hiyahanapui hava hipaipaihowaine’. Na tau'alehaowa Yeisu ana ale'owa hivai ta vehabana hi'ai'ai opi'opi dova kati ta yaiyadiwo himugai ale'odine mata hivaidi. ");
INSERT INTO kud2014_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tenem ainai boda hivinuvinunu, na taumiya Yudeya adi taumugaiwo Yeisu hi'abi'abitalawahiyei, hiwalo, ‘Tomowa vagadi ihaguhaguidi, na hola ebe teina ta'i ibom ihaguyoi, ebeha iya Besinana towahona Yaubada ainaena’. ");
INSERT INTO kud2014_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Tau'alehaowa hinage Yeisu hi'abitalawahiyei na waini abe'abelena hivaiyama ta hiveleleihinine, ");
INSERT INTO kud2014_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","na hiwalo, ‘Ebe owa Yudeya yadi tauwasawasa ulivahiuyoigo’. ");
INSERT INTO kud2014_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Yo hinage ana aiwa lagalaga vahunai yana mwalowoi wuwuna hilele hiwalo: TEINA YUDEYA YADI TAUWASAWASA. ");
INSERT INTO kud2014_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Aiwa lagalaga aidiyena ehebo taupwanoliwa Yeisu ainai iwalo yaiyai, iwalo, ‘Moiha owa Besinana towahona? Owa yo ai ulivahigita.’ ");
INSERT INTO kud2014_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Na vehaunawa ana geluwa iwalowei, iwalo, ‘Hava ta Yaubada nigele uyamehuheine? Na u'ita maihana ita tavaivaine ehebonane iya hinage ivaivaine, ");
INSERT INTO kud2014_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ta loinanane owa na yau ilowoinanegita, wuwuna ita mayada pwanoliwo, na hesi towahone teina nigele teya yana lauhapuli.’ ");
INSERT INTO kud2014_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Eena Yeisu ainai iwalo, ‘Yeisu, Howola abo yam Abaloina ana haugai, howahowana ebe unuwatuwuigau?’ ");
INSERT INTO kud2014_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Na Yeisu iwalo, ‘Yawalo moiha alimwai owa na yau mata Abamiya haehaena ainai tamiya’. ");
INSERT INTO kud2014_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ahubena ilau'ahi'ahipuwi ainai mahana iguguyou, ta dalava maudoina iguguyou ana higa lavilaviyena dalava imaseleuyo. ");
INSERT INTO kud2014_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Na ale'o vada tapwalolo mwali'ina ainaena hivebiliwutuhiyeine hauganane ainai ipupulihi bwauwine. ");
INSERT INTO kud2014_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Eena Yeisu alinana mwala'ina iyoga, iwalo, ‘Tamagu yo, alu'aluwagu nimamwai yamwamwauwi’. Yana walo teina i'ataidi na yawahina i'o'ovine. ");
INSERT INTO kud2014_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tenem ainai tau'alehao adi taumugai i'ita bada Yeisu yawahina i'ovi'o, ainaena Yaubada iwalo vetuvehae, iwalo, ‘Moiha towaho teina towaho dumwadumwaluna’. ");
INSERT INTO kud2014_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Na hinage tauvinunu maudoidi hitau'ahaiyama Yeisu hi'itaya'o ebeha bada imwalowoi'o, ainaena mayadi nuwayababa hiwuyo yadi dalavai. ");
INSERT INTO kud2014_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Na Yeisu ana geluwo yo hinage waiwaihiuwowa mugai Galiliyena himumulitaenama, hiya amwaha daodaowai hitowotowolo na Yeisu yana mwalowoi hi'ita'itayama. ");
INSERT INTO kud2014_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Towaho ehebo yehana Yosepa, Yudeya towahona, yana dalava habuluna Alimatiya, ibom towaho namwanamwana yo hinage mayana yemidi mwala'ina. Towahonane ibom iha'waha'wa Yaubada yana Abaloina vehabana. Towahonane ibom ehebo taumiya Yudeya yadi tau'ulewahi teya na hauganane tau'ulewahiwone nuwanuwadi yo Yeisu hi'oiye mwalowoi Yosepa nigele nuwanuwana. ");
INSERT INTO kud2014_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Towahonane Pailato ainai ilau ta Yeisu tauna i'awanoiyei ta ebe magaiyai imwauwi. ");
INSERT INTO kud2014_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ainaena Pailato ainai italamwei, ta Yosepa Yeisu tauna aiwa lagalagana ainaena i'avala aituluwei, ta ihuma ale'o hewahewana ainaena, na mulitai magaiyai imwamwauwine. Magaine hilapai dova duluva gaima holanai na nigele teya hauga taumwalowoi ainai hiyamwauwi. ");
INSERT INTO kud2014_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ahubena tenem ainai taumiya Yudeya yadi hauga atububuni yadi Tapwalolo vehabana. ");
INSERT INTO kud2014_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Na waiwaihiuwowa mwalona Galiliyena Yeisu himumulitaenamawa hiya hilau ta Yeisu magaina hi'itaya'o yo hinage tauna ana abamwauwina hi'itaya'o. ");
INSERT INTO kud2014_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ainaena hiwuyouyoma dalavai ta woloi namwanamwana hi'abinonovai Yeisu tauna ana yewoloi vehabana. Vali ahubena nigele hiyalau na hesi hi'aiyawasi, wuwuna Tapwalolo yana loina. ");
INSERT INTO kud2014_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ainaena i'ahubenauyo neta wiki ana ahubena mugamugaina malatomtomwai waiwaihiuwowa woloiwa hi'a'abinonovaiwa hivai ta hilalawedi magaiyai. ");
INSERT INTO kud2014_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Hilaoma ta hi'itaya'o magaiwa ana gudu gaimawa bada hive'i wahiyena'o. ");
INSERT INTO kud2014_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Eeta magaiwa holanai hiluluwune, na hesi Yeisu taunawa nigele hiya'ita. ");
INSERT INTO kud2014_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ainaena magaiwa ainai mayadi nuwayababa himiya ta hi'ita'ita behabehauhi, na hauga habuluna ainai towatowaho bwau adi ale'o namanamalina na masemaseledi himahalava ta vahalidiyai hitowotowolo. ");
INSERT INTO kud2014_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Waiwaihiuwowa towatowahowowa hi'itadi ta himeheuhi, ainaena hitalupwagogo bale'uwai, na towatowahowowa hiwalo, ‘Hava vehabana mwalomwalowoidi yadi tupwai towaho mayawahina ambehabehaeine? ");
INSERT INTO kud2014_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Iya nigele teinai, bada itowolouyo'o, na hesi yana walo alimiyai amnuwa'avivini mugai Galili ainai baidamiu ammiyamiya, haugana iwalo, ");
INSERT INTO kud2014_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Yau Towaho Moihagu mata tauyababao nimadiyai himwauwigau, ta aiwa lagalagana ainai hitutuye patugau, na ahubena tonugana ainai mwalowoiyena yatowolouyoma”.’ ");
INSERT INTO kud2014_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Waiwaihiuwowa walo teina hinuwatuwuidi, ");
INSERT INTO kud2014_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ainaena magaiwa hilaugabaei ta hiwuyo Yeisu ana taumulitao hitau 11 ma'adi geluwo aidiyai, ta hiwalo mahalava hava dova magaiwa ainai imamahalavane. ");
INSERT INTO kud2014_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tau'aubabadao neta Meli Magidalaena yo Yowana yo Meli iya Yemesa hinana, yo hinage tupwadi waiwaihiu baidadiyao, Yeisu yana towolouyo vehabana ana taumulitao hiwawalo aulidine, ");
INSERT INTO kud2014_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","12","na hesi Yeisu ana taumulitaone waiwaihiuwowa yadi walone nigele hiyayemidiyei, yadi nuwatuwu ebeha bada hi'a'abitalawahi. ");
INSERT INTO kud2014_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ahubena ehebonane ainai Yeisu ana taumulitao bwau hilaulau ehebo dalava ainai, yehana Emeusa. Dalavanane ana daodao Yelusalem ainaena dova mahana hawahawagana bwau ainai tamahalava. ");
INSERT INTO kud2014_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Hitaubwauwone hilaulau na yodi hi'au'aubabada ginauliwowa Yeisu ainai himamahalavawa vehabadi. ");
INSERT INTO kud2014_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Hi'au'aubabada na hilaulau, eena Yeisu aidiyai iwutu mahalava ta baidadi hilaulau. ");
INSERT INTO kud2014_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Yeisu bada hi'itaya'o, na hesi nigele hiya'atai. ");
INSERT INTO kud2014_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ainaena hitau bwauwa ipanivilaedi, iwalo, ‘Ginauli yehana vehabana amlaulau au'aubabadane?’ Na hiya aluwagavaiyena mayadi nuwayababa hitowolo benali. ");
INSERT INTO kud2014_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ta ana geluwa yehana Kaliyopasa iwalo Yeisu ainai, iwalo, ‘Nuwana owa taumana teya Yelusalem holanai ta nigele uyahanapui hava imamahalavane ahubena tonuga hi'ovi'o ainai, awa?’ ");
INSERT INTO kud2014_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yeisu ipanivilaedi iwalo, ‘Ginauli yehana?’ Na hiya hiwalo, ‘Ginauliwone Yeisu Nasaleti towahona ainai imamahalavane vehabadi. Towahone teina ibom tauwalo mahalava, yo Yaubada na tomowa mehediyai yana walowo yo hinage yana paihowao wahiwahiyaladi. ");
INSERT INTO kud2014_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Na yama taupwaoli babadadiyao yo yama taumugaiwo towahonane hiloinaei yana mwalowoi vehabana na mulitai tau'alehao hitutuye patune aiwa lagalaga ainai, ");
INSERT INTO kud2014_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","na ayemidiyei ebeha ibom mata ai Isileli ilivahigai. Ginauli teina ahubena bwau hi'ovi'o aidiyai himahalava na wau ahubena tonugana. ");
INSERT INTO kud2014_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Na tupwadi waiwaihiu alimaiyena nuwamai hi'abiye pwanopwano, wuwuna wau malatomtom habuluna hilau magaiyai, ");
INSERT INTO kud2014_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ta Yeisu tauna nigele hiya'ita, na hilau gwaipile ta hava dova Yaubada yana tausagenawasao yadi walo hiwalo mahalava alimaiyai ebeha bada itowolouyo'o. ");
INSERT INTO kud2014_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Hinage dova tupwadi alimaiyena hilau magaiyai ta hi'ita dova waiwaihiuwowa yadi walomahalavawa na hesi Yeisu nigele hiya'ita.’ ");
INSERT INTO kud2014_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ainaena Yeisu aidiyai iwalo, ‘Yauyaulemiu, wuwuna nigele mugai tauwalo mahalavao yadi walowo amyayemidiyedi. ");
INSERT INTO kud2014_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Na am hanapui ebeha Besinana towahona teina muyaone ilobaidi ta ainaena abo yana wasawasa ainai iluwu.’ ");
INSERT INTO kud2014_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Abo ivetuwuni ta aidiyai ilivalivahi hava dova Buki Ve'ahihi yana walomahalava iya vehabana. Mosese yo tauwalo mahalavao yadi Bukiwo aidiyena ivetuwuni na Buki Ve'ahihi maudoina ive'ovi, ta ebe ainaena hanapu hilobai. ");
INSERT INTO kud2014_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Eena dalava ainai hilaulauwa bada vahalinai himamahalava ta Yeisu aidiyai iwalo, ‘Ammiyamiya na yalalau’. ");
INSERT INTO kud2014_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ta hiya hiwalo, ‘Nigele! Havena ulaulau, teinai ta'eno, wuwuna bada iboni'o.’ Ainaena italam ta iluwu yadi vadai. ");
INSERT INTO kud2014_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yadi hauga ai ainai Yeisu beledi ivai, ta vehabana i'awanoi yo i'awa yauwedo Yaubada ainai, na mulitai i'abitomwahi ta imomohedine. ");
INSERT INTO kud2014_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tenem ainai mehedi imasele ta Yeisu abo hi'a'ataine, na hesi aidiyena isasawaline. ");
INSERT INTO kud2014_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ainaena hitau bwauwa hi'aubabada, hiwalo, ‘Moiha haugana talaolaoma na i'au'aubabada yo Buki Ve'ahihi ilivalivahi alidai ada lausawahiwone vagadi dova aiwa atedai i'ala'alahi’. ");
INSERT INTO kud2014_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Eeta hitowolo mwayamwayau hilau Yelusalem, na nemai adi geluwowa hitau 11 hilobaidi yo tupwadi adi geluwo baidadiyao himiyamiya, ");
INSERT INTO kud2014_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","na Yeisu vehabana hi'au'aubabada, hiwalo, ‘Saimoni bada Badane i'itaya'o, mwalowoiyena itowolouyo'o’. ");
INSERT INTO kud2014_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Eena hitau bwauwa hinage hi'aubabadaei hava dova amwahai aidiyai imamahalavane, yo hinage haugana Yeisu beledi i'abi tomwahi na imohedi ta ainaena abo hi'a'ataine. ");
INSERT INTO kud2014_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","37","Howola adi geluwowa aidiyai hi'au'aubabada na Yeisu imahalava ta ahi'ahipudiyai itowotowolo, na hi'ita ta himeheuhi, yadi nuwatuwu ehebo alu'aluwa. Ainaena Yeisu iwalo, aulidi, iwalo, ‘Nuwadaumwali alimiyai! ");
INSERT INTO kud2014_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Hava wuwuna amnuwavitai na amnuwanuwatuwu bwaune. ");
INSERT INTO kud2014_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nimagu yo aegu hola am'itadi yo am'abi sawahidi, wuwuna alu'aluwa nigele bunumana yo nigele hilihiliyanao dova yau am'itagaune.’ ");
INSERT INTO kud2014_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ainaena nimanawa yo aenawa ive'itadi. ");
INSERT INTO kud2014_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Tenem ainai hiyaliyaya mwala'ina, na hesi tupwana mayadi matauhi wuwuna nigele hiyayemidi moiha, ainaena iwalo, ‘Viha ai'ai, ammohegau ta ya'ai?’ ");
INSERT INTO kud2014_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Eeta yama tupwana ligaligana himohei, ");
INSERT INTO kud2014_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ta mehediyai i'a'aine. ");
INSERT INTO kud2014_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ainaena iwalo aulidi iwalo, ‘Teina ginauliwone bada ya'aubabadaedi'o alimiyai haugana yau baidamiu, neta hava maudoina vehabagu hileledi'o Mosese yana Buki ainai yo tauwalo mahalavao yadi Buki aidiyai yo hinage wali Sam aidiyai, eeta yagu walowowa ana hanapu moiha imahalava'o’. ");
INSERT INTO kud2014_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tenem ainai nuwadi i'abiye masele ta Buki Ve'ahihi hihahanapuine. ");
INSERT INTO kud2014_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Na aidiyai iwalo, ‘Teina dova hileleya'o, iwalo: Besinana towahona mata muya yo mwalowoi ilobaidi, na ahubena tonugana ainai mwalowoiyena itowolouyo, ");
INSERT INTO kud2014_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","na mulitai yehanaena wasa namwanamwana, yo nuwabui yo pwanoli adi nuwahamu vehabadi higuguyaei. Yadi guguyane mata hivetuwuni Yelusalem ainai na ilau ta'i'ili bale'u maudoina. ");
INSERT INTO kud2014_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","‘Ginauli teina ainodi omiu ana tauwalo moiha. ");
INSERT INTO kud2014_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Na hesi yau mata Tamagu yana waloyemidiwa, neta Alu'aluwana yavetamalenama ta ala'alawowoli ewaena i'atuluma alimiyai, ainaena mata Yelusalem ainai amha'waha'wa vehabana.’ ");
INSERT INTO kud2014_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yeisu yana walo iwalowedi na mulitai ana taumulitaowa ilauvaidi hilau Betani, ta nemai nimana i'abihini na iwalo velauwedi. ");
INSERT INTO kud2014_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Yana walovelaune ainai itowolo ta ihahaene galewai. ");
INSERT INTO kud2014_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Hiya yana abahaewa ainai hitalupwagogo yo hino'ono'owei na mulitai mayadi yaliyaya mwala'ina hiwuwuyone Yelusalem. ");
INSERT INTO kud2014_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Hiwuyo ta vada tapwalolo holanai hauga ehebo ehebo Yaubada hiwalowalo vetuvehaeyei.");
INSERT INTO kud2014_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Hauga yana abavetuwuni mayamayauni ainai Walo imiyamiya. Na Walonane iya Besinana Yaubada baidana yo iya ta'i Yaubadanane. ");
INSERT INTO kud2014_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Abavetuwuni ainai Walone iya Yaubada baidana himiyamiya, ");
INSERT INTO kud2014_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","na Walonane iya Besinana Yaubada baidana galewa yo bale'u yo ginauli maudoidi hiyeyemaseledine na nigele teya tauyemasele. ");
INSERT INTO kud2014_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Na Walonane iya yawahi moiha. Na yawahi moiha ainaena masele ivaivaiyama tomowa maudoida alidai. ");
INSERT INTO kud2014_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Na masele ihinali guguyou badobadona ainai na guguyou badobadona nigele howahowana na maselene ihuma. ");
INSERT INTO kud2014_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Yaubada yana tauyewasa ivetamalenama, towaho yehana Yoni iya tau'abiye bapitaiso. ");
INSERT INTO kud2014_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Iya ilaoma na tomowa nuwadiyai habi mwauwina maselene vehabana na ebe tomowa maudoidi hibenalei ta maselene ainai hiyemidi. ");
INSERT INTO kud2014_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Iya Yoni nigele maselene, na hesi ilaoma na ebeha maselene iwalo mahalavaei. ");
INSERT INTO kud2014_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Teina maselene masele moiha, na taumiya bale'u maudoida ihinayayahigita. ");
INSERT INTO kud2014_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Walowa ilaoma'o bale'uwai, na iya bale'u ana tauyemasele, na hesi taumiya bale'u nigele hiyahanapui. ");
INSERT INTO kud2014_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ilaoma ibom yana tomowa aidiyai na hiya hita'wata'wataei. ");
INSERT INTO kud2014_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tomowa tupwadi hiyemidiyei ebeha iya taulivahi na italam yo hiya Yaubada natunao. ");
INSERT INTO kud2014_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Eeta tomowa teina tawalowedi ebeha hiya bada hitubuiuyo'o tubuiuyone nigele dova tomowa 'wahinadiyena yo yadi nuwatuwuwena na hesi tubuiuyo Yaubada ainaena. ");
INSERT INTO kud2014_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Walonane bada ilaoma'o ta iyemala tomowa alidai yo hinage baidada tamiyamiya teina haugane ainai. Na ta'itaya'o yana wasawasa wuwuna iya Yaubada Natuna moiha, na hinage iya tauvelau yo mumugana dumwadumwaluna. ");
INSERT INTO kud2014_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Mugai Yoni Yeisu iwalo mahalavaei alinana mwala'ina ainaena iwalo, ‘Teina iya towahowa yawalowaloweine vehabana hauganane yawalo mahalava neta ehebo towaho tuluhaguwena ilalaoma iya imwala'i gabaegau, wuwuna mulitai abo hilalabahigaune iya mugai imiyamiya’. ");
INSERT INTO kud2014_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Iya tau'aiyauya namwanamwana yo yana ve'i'ila ainaena i'oiye mwaugita. ");
INSERT INTO kud2014_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mosese yana aiyauya namwanamwana, neta loinadine Buki Ve'ahihi ainai, na hesi Yeisu Besinana yana aiyauya inamwanamwa alili, wuwuna ve'i'ila yo mumuga namwanamwana imohegita'o. ");
INSERT INTO kud2014_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nigele teya hauga tomowa Yaubada ana oleya hiya'ita, na hesi Natuna moihanane iya vahalinai imiyamiya ta Tamanane iya ana ita bada ive'itagita'o. ");
INSERT INTO kud2014_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Hauganane tenem ainai Yudeyaone yadi taumugaiwo Yelusalem ainai himiyamiya, ta tupwadi taupwaoliwone yo tupwadi Livai yana huhuwo hivetamaledi Yoni ainai, habi panivilaeina ebeha iya yaiya. ");
INSERT INTO kud2014_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Na Yoni nigele iyauvala yadi panivilane vehabana na hesi yemaiha masemaselena yo namwanamwana imohedi iwalo, ‘Yau nigele Besinana towahona’. ");
INSERT INTO kud2014_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Eena hinage hipanivilauyo, hiwalo, ‘Yaiya yede owa? Owa ebeha Elaitiya awa?’ Na Yoni iwalo, ‘Yau nigele’. Na hinage hipanivilauyoi, ‘Nuwana owa tauwalo mahalavanaede Mosese vehabana iwalowalowa?’ Yo hinage Yoni iyemaiha iwalo, ‘Yau nigele’. ");
INSERT INTO kud2014_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Na hiya hinage hiwalo, ‘Owa yede yaiya? Hava yam walo vehabam, ta ebe awuyo na ama tauvetamalewone aidiyai awalowei.’ ");
INSERT INTO kud2014_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Na Yoni yadi panivilane iyemaiha ta iwalo mahalava iwalo, ‘Mwalona tauwalo mahalava Aisaya yana buki ainai vehabagu iwalo mahalava tenem dova, Tomowa ehebo nu'ula awawai tupwanane ainai ibwaleni ta iyogayoga yo iwalowalo, “Bada yana amwaha amsepa yo am'abiye dumwadumwalu”.’ ");
INSERT INTO kud2014_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Na Palisiwone yadi tauyewasaone Yoni hipanivilaei hiwalo, ‘Ebe owa nigele Besinana towahona, bo nigele Elaitiya, bo nigele teya vali tauwalo mahalava, hava wuwuna tomowa u'abi'abiye bapitaisowedine?’ ");
INSERT INTO kud2014_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Na Yoni iwawalone aidiyai iwalo, ‘Yau we'ahaena tomowa ya'abi'abiye bapitaisowedi, na ehebo towaho nigele amyahanapui ahipumiyai teina ta'i itotowolo, ");
INSERT INTO kud2014_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","iya tuluhaguwena ilalaoma, ta yau nigele iyalowoinanaegau na aenane ana huma yalivahi, wuwuna iya imwala'i gabaegau’. ");
INSERT INTO kud2014_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Teina ginauliwone maudoidi neta Betani ainai himamahalavane, Yoni yana aba'abiye bapitaiso tupwanane ainai, we'aha Yolidani vali geyo'awai. ");
INSERT INTO kud2014_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","I'ahubenama na Yoni Yeisu i'ita ilaolaoma ainai, ta Yoni tomowaone aidiyai iwawalone, ‘Tenem towahone iya Yaubada yana Lami taumiya bale'u maudoida vehabada mata imwalowoi na mumugada yababadi iho'evehuludi. ");
INSERT INTO kud2014_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Mwalona teina towahone vehabana yawalowalone, hauganane yawalo alimiyai neta towaho tuluhaguwena ilalaoma na iya imwala'i gabaegau, wuwuna mulitai abo yau yalaoma na hesi iya bada mwalona imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mwalona nigele yayahanapui ebeha yaiya iya, na yau we'ahaena ya'abiye bapitaisogomiu, ta ebe omiu Isileliwone yadi Yaubada yana Besinana amhanapui.’ ");
INSERT INTO kud2014_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Walone teina Yoni iwalo mahalava Yeisu vehabana, ta aidiyai iwalo, ‘Alu'aluwa Ve'ahihi ya'i'itane ana itane dova gabubu galewaena i'aituluma ta Yeisu ainai itotowone. ");
INSERT INTO kud2014_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mwalona nigele yayahanapui iya yaiya, na Yaubada iya ivetamalegauma ta bapitaiso we'ahaena yapaihowaidi, na aliguwai iwalo mahalavaeine, iwalo, “Howola abo Alu'aluwagu u'ita mata i'aituluma ta towaho ainai itowa, iya mata Alu'aluwa Ve'ahihi ainaena i'abiye bapitaiso tomowa aidiyai”.’ ");
INSERT INTO kud2014_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Na hinage Yoni aidiyai iwalo, ‘Yau towahonane meheguwena bada ya'itaya'o, ainaena teina yawalowalo mahalavane ebeha iya Yaubada Natuna moiha’. ");
INSERT INTO kud2014_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","I'ahubenama, ta Yoni yo ana taumulitao hitau bwau baidanao hitowotowolo, ");
INSERT INTO kud2014_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","na Yeisu hi'i'itane vahalidiyena ilaulau. Ainaena Yoni ana taumulitaone aidiyai iwalo, ‘Tenem towahone iya Yaubada yana Lami’. ");
INSERT INTO kud2014_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tenem ainai hitau bwauwone Yoni yana walo hibenalei ta Yeisu himumulitaeine. ");
INSERT INTO kud2014_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Na Yeisu tuluhanaena hilaulau na i'ita gwaipile ta i'i'itadine. Ta ipanivilaedine iwalo, ‘Hava nuwanuwamiu?’ Na hiya hiwalo, ‘Labai, haidova umiyamiyane?’ (Labai ana bui neta tauve'ita.) ");
INSERT INTO kud2014_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Na Yeisu aidiyai iwawalone iwalo, ‘Ammulitaegau na yagu abamiyane yave'itagomiu’. Ta lavilaviyena hibwabwalenine tupwanane ainai na nemai himimiya yebonine. ");
INSERT INTO kud2014_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Taumulitaone hitau bwaune aidiyena ehebo yehanaede Andulu, iya Saimoni Pita tahina. ");
INSERT INTO kud2014_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andulu, imwayamwayau ta tuwanane ilobai na iwawalone iwalo, ‘Saimoni, Yaubada yana Besinana towahona bada alobaiya'o’. (Besinana towahona ana bui neta Keliso.) ");
INSERT INTO kud2014_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Na Saimoni ilauvai ta Yeisu ainai ilauvaiyamane. Tenem ainai Yeisu Saimoni i'i'itane na iwalo auli iwalo, ‘Owa yeham Saimoni, Yoni natuna, na yeham vauvauna yamwauwi Pita, ana bui Gaima’. ");
INSERT INTO kud2014_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ainaena i'ahubenama Yeisu nuwanuwana ilau Galili, eeta ilau ta nemai Pilipi ilolobaine, na iwawalone ainai iwalo, ‘Umulitaegau’. ");
INSERT INTO kud2014_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipi iya yana dalava Bedesaida, neta Andulu yo Pita yadi dalava hinage. ");
INSERT INTO kud2014_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Na Pilipi Nataniyela ilobai na iwawalone ainai, iwalo, ‘Bada Besinana towahonawa alobaiya'o, iya mwalona Mosese yana Buki loinao aidiyai yo hinage tauwalo mahalavaone yadi laulelewone aidiyai hiwalo mahalavaewa, iya Nasaleti towahona, Yosepa natuna, yehanaede Yeisu’. ");
INSERT INTO kud2014_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Na Nataniyela Pilipi ainai iwalo, ‘Moiha mata Nasaleti hava namwanamwana ainaena ibwalenine?’ Eeta Pilipi iwalo, ‘Ulaoma na towahonane u'ita’. Ta Yeisu ainai hilalaomane. ");
INSERT INTO kud2014_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Hauganane Yeisu Nataniyela i'ita ta tomowaone aidiyai iwawalone Nataniyela vehabana, iwalo, ‘Tenem towahone iya Isileli towahona moiha na nigele teya lauhapuli ainai’. ");
INSERT INTO kud2014_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Na Nataniyela ipanivila Yeisu ainai iwalo, ‘Vedova ta uhahanapuigaune?’ Na Yeisu iwalo, ‘Mulitai abo Pilipi iyoyogaegone yau bada ya'ita mugaiyego'o damaya wuwunai umiyamiya’. ");
INSERT INTO kud2014_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tenem hauganane ainai Nataniyela aluwana igavai ta Yeisu ainai iwalo, ‘Bada moiha ta'i owa Yaubada Natuna, na owa Isileli yama Tauwasawasa’. ");
INSERT INTO kud2014_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Na Yeisu iwawalone ainai iwalo, ‘Uyemidiyegau wuwuna alimwai yawalo owa damayane wuwunai ya'i'itagone, awa? Teina bada aba'ita iu'iuna na howola abo ginauli mwala'idi u'itadi.’ ");
INSERT INTO kud2014_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Na Yeisu hinage iwalo, ‘Yawalo moiha alimwai howola abo galewa ilotaho'e na Yaubada yana tausagenawasao mata am'itadi hihaehae yo hi'ai'aitulu yau Tomowa Moihagu aliguwena’. ");
INSERT INTO kud2014_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ahubena bwau hi'ovi ta tawahola guyauna hipaihowai Kena dalavanai, Galili tupwanane ainai. Na Yeisu hinanane guyaune holanai. ");
INSERT INTO kud2014_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yeisu hinage mayana taumulitao guyaunane ainai hiyogaedi ta baidadiyao hiluwu ta hi'a'aine. ");
INSERT INTO kud2014_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Hauganane yadi aine holanai adi waini hinuma ve'ovidi, ta Yeisu hinana iwalo, ‘Natugu, wainine maudoina bada i'ovi'o’. ");
INSERT INTO kud2014_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Na Yeisu iwalo, ‘Hinagu, hava vehabana ebeha uyepaihowagau? Howola nigele yayavetuwuni.’ ");
INSERT INTO kud2014_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Eena Yeisu hinanane taupaihowaone aidiyai iwawalone, ‘Ebe hava nuwanuwana na ampaihowaidi, ampaihowaidi ta'i’. ");
INSERT INTO kud2014_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Hauganane ainai Yudeyaone mumugadi neta, we'aha abahiwa hipaihowaidi gaima ainaena aba'uwa vehabana. Na tenem guyaune hauganane ainai abahiwa 6 himiyamiya, ova'ova'a'avadi na mwala'idi, howahowana we'aha mwala'i alilina aidiyai hihiwai. ");
INSERT INTO kud2014_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ainaena Yeisu iwalo taupaihowaone aidiyai ta abahiwaone hi'o'oiye mwaudine we'ahaena. ");
INSERT INTO kud2014_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Na Yeisu aidiyai iwalo ta we'ahane iu'iuna higoini abahiwaone holadiyena ta hilalaweine guyaune taniwaganane ainai. ");
INSERT INTO kud2014_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ta guyaune taniwaganane we'ahawa ilautowoi ta ana lautowoine vagana, nigele dova we'aha na hesi dova waini ana lautowoi namwanamwana. Na guyaunane taniwaganane nigele iyahanapui havaena waininane hivavaine, na hesi taupaihowaone hibom hihahanapuine. Eeta guyaune taniwaganane tautawaholane towahonane iyogaei, ");
INSERT INTO kud2014_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ta ainai iwawalone, iwalo, ‘Ita mumugada neta waini namwanamwana tomowa tamohe mugaiyedi abo mulitai waini yababana tamohedi. Na owa hava wuwuna ta wainine namwanamwa alilinane umwau dawani ta uvemulitaeine?’ ");
INSERT INTO kud2014_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Teina ainai Yeisu yana paihowa wahiwahiyalana yo mugamugaina ana ve'ive'ilala i'abiye mahalavaeine Kena dalavanai, Galili tupwanane ainai, na yana wahiyalane ive'itaei tomowaone aidiyai ta ana taumulitaone hiyemidiyeine. ");
INSERT INTO kud2014_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Guyaune i'ovi ta Yeisu hinanane yo tahinaone yo hinage ana taumulitaone baidanao hidodobine Kapaneum, ta tenem ainai ahubena tupwadi aidiyai himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Hauga bada ilautebitebiniya'o na Yudeyaone yadi Buidi'wa guyauna. Hauganane ainai Yeisu ihahaene Yelusalem. ");
INSERT INTO kud2014_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ta iluwu vada tapwalolo mwala'ina holanai na taugimwalaone i'i'itadine hiya bulumakau yo sipi yo gabubu adi tauvegimwalao, na hinage mane ana tauvesaugelasi vada tapwalolo holanai hidabadabalala. ");
INSERT INTO kud2014_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ainaena balavai veiveina ivai ta tomowaone yo lagulaguwone vada tapwalolo ainaena iheheusilidine, na hinage mane ana tauvesaugelasiwo yadi vatavata i'oipeiyedi ta yadi manewone ibudeyanaedi, ");
INSERT INTO kud2014_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","na tauvegimwalao gabubuwone aidiyai iwalo, ‘Yami lowolowo maudoidi teinaena amhiwa bwalenedi na havena Tamagu yana Vadane amyebiyebi'i yo ebeha yami abavegimwala’. ");
INSERT INTO kud2014_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Na ana taumulitaone walowa Buki Ve'ahihi holanai hinuwatuwu avivinine iwalo, ‘Aee Yaubada, yam vadane inamwanamwa alili ainaena nuwagune ivai’. ");
INSERT INTO kud2014_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Eena Yudeyaone adi taumugaiwone hilaoma ta Yeisu hipanivilaei, hiwalo, ‘Teya ve'ive'ilala uve'itagai ta ebe ahanapui yaiya yana loinaena teina ginauliwone upaipaihowaidine?’ ");
INSERT INTO kud2014_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Na Yeisu aidiyai iwalo, ‘Teina Yaubada yana vadane ebe amlo'e, ahubena tonuga ainai mata yavetowolouyoi’. ");
INSERT INTO kud2014_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Na hiya hinage hiwalo, ‘Ebeha teina, vadane ahubena tonuga ainai u'abiuyoi? Na unuwatuwu avivini ebeha vadane teina, bolimai 46 holanai hi'abi'abi abo hiveve'ovine.’ ");
INSERT INTO kud2014_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Na Yeisu nigele vadanane vehabana iya walowalo na hesi yana mwalowoi yo yana towolouyo vehabana. ");
INSERT INTO kud2014_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Eena hauganane Yeisu mwalowoiyena itowolouyo ta ana taumulitaone Buki Ve'ahihi yana walo yo hinage Yeisu yana walo aidiyena hinuwatuwu avivini ta hiyemidi moiha. ");
INSERT INTO kud2014_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yeisu haugana Buidi'wa guyaunane holanai imiyamiya tomowa maudoidi yana paihowa wahiwahiyaladi hi'i'itadine, eeta yehana hiyemidiyei. ");
INSERT INTO kud2014_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Na Yeisu nigele iya'awa moihaedi, wuwuna maudoidi yadi nuwatuwu ihanapu mugaiyedi'o. ");
INSERT INTO kud2014_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nigele howahowana na tomowa tupwadi hi'aubabadaneuyowedi Yeisu ainai, wuwuna hava yadi nuwatuwu atediyai bada ihanapu ili'ilimanidi'o. ");
INSERT INTO kud2014_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ehebo towaho yehana Nikodimo, iya teya Palisi yo hinage Yudeyaone adi taumugai, ");
INSERT INTO kud2014_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","na boniyaiyena ilaoma Yeisu ainai ta iwawalone, iwalo, ‘Bada yahanapuigo'o ebeha owa tauve'ita Yaubada ainaena, wuwuna nigele teya yaiya yana paihowa wahiwahiyalana dova owa ebe Yaubada nigele baidana’. ");
INSERT INTO kud2014_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Na Yeisu iyemaiha iwalo, ‘Yawalo moiha alimwai, ebe nigele uyatubuiuyo, nigele howahowana Yaubada yana Abaloina u'ita’. ");
INSERT INTO kud2014_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ta Nikodimo Yeisu ipanivilaei, iwalo, ‘Vedova ta yau towaho mwala'igu na ebeha yatubuiuyo? Moiha nigele howahowana na hinagu diyanaena yaluwuyo na yatubuiuyo.’ ");
INSERT INTO kud2014_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Na Yeisu iwawalouyone, ‘Yawalo moiha alimwai ebe nigele we'ahaena yo Alu'aluwa Ve'ahihi ainaena uyatubuiuyo, nigele howahowana Yaubada yana Abaloina ainai uluwu. ");
INSERT INTO kud2014_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Hinadaone aidiyena tatubuima tomowa mohili. Na Alu'aluwa yana tubuiuyo Yaubada Alu'aluwana ainaena. ");
INSERT INTO kud2014_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Havena unuwanuwapwanopwano wuwuna yawalo alimwai ebeha utubuiuyo. ");
INSERT INTO kud2014_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Dova bada yaumai yana towa tupwa vagana yo vagana ainai daguguna tabenabenalei, na nigele tayahanapui havaena yaumai ilaolaomane yo havaidova ilalau. Dova hinage hiya Alu'aluwa ainaena hitubuiuyo.’ ");
INSERT INTO kud2014_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Na Nikodimo Yeisu ipanivilaei, iwalo, ‘Teina yam walone vedova ana nuwamaselene?’ ");
INSERT INTO kud2014_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Na Yeisu iwalo, ‘Owa Isileli yadi tauve'ita mwala'ina, na teina yagu walone vehabana nigele uyanuwamasele. ");
INSERT INTO kud2014_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Yawalo moiha alimwai neta ginauliwone bada ya'itadi'o yo yahanapuidi'o ainaena yawalowalo mahalavaedine alimwai, na nigele yagu walowone uyayemidiyedi. ");
INSERT INTO kud2014_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ebe bale'u ginaulidi alimiyai vehabadi yawalowalo mahalavaedi na nigele amyayemidiyedi, vedova mata ginauliwone galewa vehabana yave'itaei amhanapuine. ");
INSERT INTO kud2014_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wuwuna nigele teya iyahae galewai, na hesi yau Tomowa Moihagu, wuwuna yau galewaena ya'a'aitulumane. ");
INSERT INTO kud2014_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Dova mwalona hauganane Isileliwone hilaulau balabala awawai, ta Mosese weso pwawati ainaena ipaihowai ta aiwa ainai i'abiye patu na i'a'abihinine, dova yau mata hi'abihinigau. ");
INSERT INTO kud2014_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ta ebe yaiyadiwo hiyemidi aliguwai, yawahidi miyamiya vateyaina hilobai. ");
INSERT INTO kud2014_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","‘Yaubada tomowa maudoidi bale'uwai ivelauwedi ta Natuna ibom italamwei ta ebe yaiyadiwo hiyemidiyei mata nigele hiyamwalowoi na hesi yawahidi miyamiya vateyaina hilobai. ");
INSERT INTO kud2014_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Na Yaubada Natunane bale'uwai ivetamalenama nigele ebeha omiu taumiya bale'u iyave'ewaigomiu na hesi habi lauyeyawahaigomiu. ");
INSERT INTO kud2014_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ebe yaiya Yaubada Natuna iyemidiyei nigele howahowana lauvetala ilobai, na ebe yaiya nigele iyayemidiyei, iya bada lauvetala ainai iluwu'o. Wuwuna nigele Yaubada Natuna moiha ainai iyayemidi. ");
INSERT INTO kud2014_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Tomowa yadi lauvetala wuwuna teina maselene bada bale'uwai ilaoma'o na yadi paihowa yababadi imiya mahalava na hesi tomowaone guguyoune nuwanuwadi, ta maselene hita'wata'wataei wuwuna mumugadine hiyababa. ");
INSERT INTO kud2014_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ainaena yaiyadiwo ebe mumugadi yababadi, tomowadine maselene hita'wata'wataei ta nigele ainai hiyalaoma, ta mata maselene i'abiye mahalavaedi ebeha hiya mumugadi yababadi. ");
INSERT INTO kud2014_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Na ebe yaiyadiwo hiya mumugadi dumwadumwaludi howahowana maselene ainai hibwaleni ta ebe maselene i'abiye mahalavadi ebeha hiya yadi paihowa namwanamwana Yaubada ainaena.’ ");
INSERT INTO kud2014_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mulitai Yeisu mayana taumulitao hilau dalava mwala'ina Yudeya ainai, ta nemai tupwana ahubena himiyamiya, na Yeisu tomowa i'abi'abiye bapitaisowedi. ");
INSERT INTO kud2014_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yoni hinage tomowaone i'abi'abiye bapitaisowedi Ainoni tupwanane ainai neta Salim vahalinai, wuwuna tupwanane ainai we'aha mwala'ina. Ainaena tomowa maudoidi hilaulau ainai na i'abi'abiye bapitaisowedi. ");
INSERT INTO kud2014_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tenem hauganane ainai Yoni nigele vada abapaiyai hiyamwauwi. ");
INSERT INTO kud2014_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Na Yoni ana taumulitaone yo ehebo Yudeya towahona baidadi walowena hi'awa pa'ipa'i'i abiye bapitaiso vehabana, ebeha yaiya yana abiye bapitaiso namwanamwana ta tomowaone i'abiye maseledi. ");
INSERT INTO kud2014_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Eeta tau'awa pa'ipa'i'iwone hilau ta Yoni ainai hiwawalone, hiwalo, ‘Taubada, unuwatuwu avivini towahowa mwalona Yolidani vali geyo'wanai baidam, eena alimaiyai uwawalo mahalavane towahonane vehabana, iya bada teina haugane tomowa i'abi'abiye bapitaisowedi, na maudoidi yana abiye bapitaisone nuwanuwadi, ta ainai hilaulau’. ");
INSERT INTO kud2014_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ta Yoni aidiyai iwawalone, iwalo, ‘Nigele teya yaiya howahowana iyemala towaho mwala'ina, ebe nigele Yaubada ainai iyatalam, wuwuna ginauli maudoina Yaubada ibom ainaena hilalaomane. ");
INSERT INTO kud2014_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Omiu bada alimiyai yawalo'o ta ambenalena'o ebeha yau nigele Yaubada yana Besinana towahona, na hesi yau Yaubada ivetamale mugaiyegauma abo Besinana towahona imulitama. ");
INSERT INTO kud2014_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yeisu bada iya dova tautawahola towahona na ita ana geluwo, ainaena wasanane yabenalei ta mayagu yaliyaya mwala'ina. Dova bada tautawaholane towahonane mwanena ilobai, yo ebe tautawaholane alinana teya ana gelune ibenalei, ana gelune vehabana iyaliyaya. ");
INSERT INTO kud2014_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ainaena Yeisu mata imwala'i na yau mata ya'iu'iu.’ ");
INSERT INTO kud2014_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Towahonane galewaena ilaoma, tomowa maudoida imwala'i gabaegita, na hesi yaiya iya bale'uwena ilaoma iya bale'u tomowana, yo bale'u ginaulinao vehabadi i'au'aubabada. Na towahonane galewaena i'a'aitulumane tomowa maudoida imwala'i gabaegita. ");
INSERT INTO kud2014_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ginaulidine bada i'itadi'o, vehabadi iwalowalo mahalava na nigele teya yaiya iyabenaledi na iyayemidiyei yana walomahalavaone vehabadi. ");
INSERT INTO kud2014_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Na ebe yaiyadiwo yana walomahalavane hiyemidiyei tenem ainai hi'awa moiha ebeha Yaubada iya taudumwalu. ");
INSERT INTO kud2014_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Towahonane iya Yaubada ivetamalenama iya Yaubada yana walo iwalowalo mahalavaei, wuwuna Yaubada Alu'aluwana i'oiye mwau moiha. ");
INSERT INTO kud2014_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Badane Natunane ivelauwei eeta ginauli maudoina nimanai imwamwauwine, ");
INSERT INTO kud2014_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ta ebe yaiya iya iyemidiyei yawahina miyamiya vateyaina ilobai, na ebe yaiya iya ita'wata'wataei mata nigele yawahina miyamiya vateyaina iyalobai, na hesi Yaubada yana modi'ini ainai mata nigele iya'ovi.’ ");
INSERT INTO kud2014_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yeisu yana abiye bapitaisowena ana taumulitao bagibagilidi ilolobaidine na Yoni ana taumulitaone nigele bagibagilidi. ");
INSERT INTO kud2014_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Na Yeisu nigele iya'abi'abiye bapitaiso, na ana taumulitaone hibom hipaipaihowaine. ");
INSERT INTO kud2014_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Eeta Yeisu bada ihanapuiya'o ebeha Palisiwone bada Yeisu yana paihowaone wasana hibenalena'o, ta Yudeya ilaugabaei habi wuyouyo Galili ainai. ");
INSERT INTO kud2014_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Na yana hauga wuyouyo ainai, Sameliya dalavanaone ahi'ahipudiyena ilalaune, ");
INSERT INTO kud2014_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ta Sameliya dalavana ehebo yehanaede Saika ainai ibwabwalenine. Saika ainaena bale'uwa mwalona Yakobo natuna Yosepa imomoheiwa nigele amwaha daodao. ");
INSERT INTO kud2014_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Dalavane ainai ehebo we'aha eli imiyamiya, iya Yakobo ana eli'eli, na Yeisu ilau ta mahana ala'alapwahiyai ibwabwalenine tupwanane ainai, na amnanane hiyababa ta imiya gabaei habi aiyawasi. ");
INSERT INTO kud2014_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Hauga muhamuhana ainai na ehebo Sameliya waihiuna ibwabwalenine habi we'aha goi na Yeisu waihiunane i'ita ta ainai i'a'awanoine iwalo, 'Waihiu we'aha umohegau ta yanuma'. ");
INSERT INTO kud2014_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Tenem hauganane ainai Yeisu ibom imiyamiya wuwuna ana taumulitaone bada hilao'o dalava mwala'ina ainai adi tamahina habi gimwala. ");
INSERT INTO kud2014_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tenem ainai waihiune iwawalone Yeisu ainai, iwalo, ‘U'ita, owa Yudeya towahona na yau Sameliya waihiuna na hava wuwuna ta u'a'awa we'ahane aliguwai?’ (Wuwuna Yudeya na Sameliya nigele hiya'awa heliheliyam.) ");
INSERT INTO kud2014_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Eeta Yeisu iwawalone waihiune Sameliyaenane ainai iwalo, ‘Ebe uhanapui Yaubada yana velaune alimwai yo hinage ebe uhanapuiya'o ebeha yau yaiya ilowoinanego na u'awanoiyegau ta we'aha yawahim vehabana yamohego’. ");
INSERT INTO kud2014_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ainaena waihinane iwalo, ‘Taubada nigele yam vedigolo na hinage we'aha eline idobi alili. Na havaena mata we'ahane umohegaune yawahi vehabana? ");
INSERT INTO kud2014_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Moiha owa tubudane Yakobo umwala'i gabaei? Yakobo iya we'aha eline teina ipapaihowaine ta mwalona natunaone yo yadi lagulaguwone we'ahanane yadi abanuma.’ ");
INSERT INTO kud2014_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Na Yeisu iwawalone waihiune ainai iwalo, ‘Ebe yaiya teina we'ahane ainaena inuma mata gadona imaguniuyo, ");
INSERT INTO kud2014_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","na ebe yaiya teina we'ahane aliguwena inuma nigele howahowana mata gadonane iyamaguniuyo. Wuwuna ebe we'ahanane yamohei iya atenai ivebidala ta ebe yawahi miyamiya vateyaina ilobai ainaena.’ ");
INSERT INTO kud2014_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Na waihiune Yeisu ainai iwalo, ‘Taubada, we'ahanane umohegau, ta ebe havena gadogune imagumaguni yo havena yawuyouyoma teina we'ahane ainai habi goiuyo’. ");
INSERT INTO kud2014_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Na Yeisu iwalo, ‘Ulau, mwanemne ulauvaiyama’. ");
INSERT INTO kud2014_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Na waihiune iwalo, ‘Yau nigele teya mwanegu’. Yeisu hinage iwalouyo, iwalo, ‘Neta walo moiha ebeha nigele teya mwanem, ");
INSERT INTO kud2014_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","na hesi owa mwanemwone adi bagibagili 5, na towahone utatawaholaine ta baidam ammiyamiyane dalavai nigele mwanem moiha. Na hava uwawaloweine neta walo moiha.’ ");
INSERT INTO kud2014_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tenem ainai waihiune Yeisu yana walo iyemaiha ta iwalo, ‘Taubada bada yahanapuigo'o owa teya tauwalo mahalava. ");
INSERT INTO kud2014_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Eeta uwalo moiha aliguwai aiteya tupwa ainai Yaubada ana walovetuvehae ilowoinaneine? Wuwuna ai tubumaiyaone aidiyena ta wau teina, Sameliya oyanane ainai atapwatapwalolone, na omiu Yudeyaone amwalo ebeha Yelusalem abatapwalolo moiha.’ ");
INSERT INTO kud2014_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Eeta Yeisu waihiune yana walone iyemaiha iwalo, ‘Waihiu, yagu walone uyemidiyei wuwuna hauga ilalaoma ainai mata tomowao nigele howahowana Yaubada ainai hitapwalolo teina Sameliya oyanane ainai bo Yelusalem ainai. ");
INSERT INTO kud2014_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Howahowana uhanapui ebeha omiu Sameliyaone nigele amyahanapui yaiya ainai amtapwatapwalolone, na ai Yudeyaone hesi ahanahanapui yaiya ainai atapwatapwalolone wuwuna Taulivahine alimaiyena ibwabwalenimane. ");
INSERT INTO kud2014_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Na hauga teina bada ibwalenima'o ta hiya Tamadane ana tautapwalolo moihadi ainai hitapwalolo ta yadi tapwalolone alu'aluwadi maudoina ainaena yo hinage walomoiha ainaena. Yaubada tomowa teina dova ibehabehaedi. ");
INSERT INTO kud2014_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yaubada iya alu'aluwa na yaiyadiwo hiya ainai hitapwalolo, alu'aluwadi maudoina yo hinage walomoiha ainaena hitapwalolo.’ ");
INSERT INTO kud2014_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Na waihiune Yeisu ainai iwalo, ‘Bada yahanapuiya'o ebeha howola mata Besinana towahona ilaoma, iya hiyoyogaeine Keliso, na ebe ilaoma iya hanapu maudoina mata iwalo mahalavae alidai’. ");
INSERT INTO kud2014_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Na Yeisu waihiune ainai iwalo, ‘Yau Besinanaede teina yawalowalowane’. ");
INSERT INTO kud2014_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tenem hauganane ainai Yeisu ana taumulitaone hiwuyoma ta yadi taubadane hi'i'itane waihiu baidana hi'au'aubabada, ta aluwadine igagavaine, na hesi nigele teya yaiya iyawalo, ‘Hava nuwanuwam?’ bo ‘Hava wuwuna waihiune baidam am'au'aubabadane?’ ");
INSERT INTO kud2014_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Eeta waihiunane yana abagoi ilaugabai ta ilau dalavai ta tomowaone aidiyai iwawalone, ");
INSERT INTO kud2014_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","iwalo, ‘Amlaoma na towahonane am'ita, iya mumugagune maudoina vehabana aliguwai iwalo mahalavedi'o. Eeta teina iya Besinana towahona.’ ");
INSERT INTO kud2014_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ta tomowaone dalava mwala'ina ainaena hibwalenima ta Yeisu ainai ilalaomane. ");
INSERT INTO kud2014_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Hauganane ainai Yeisu ana taumulitaone hiveve'i'imanei hiwalo, ‘Tauve'ita, teina ai'aine u'ai’. ");
INSERT INTO kud2014_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ta yadi walone iyemaiha na iwalo, ‘Agune nigele amyahanapui.’ ");
INSERT INTO kud2014_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ta ana taumulitaone hibom hi'au'aubabada, hiwalo, ‘Nuwana yaiya ana ilawenama'o?’, ");
INSERT INTO kud2014_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Na Yeisu aidiyai iwalouyo na iwalo, ‘Agu wede neta agu tauvetamalene yana nuwatuwu ya'abigabaedi’. ");
INSERT INTO kud2014_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Na hinage aidiyai iwalo, ‘Yami walo ehebo imiyamiya ebeha wai'ena vehopali hi'ovi na abo laulau eli, na yawalo moiha alimiyai am'ita gwaipile na tanovine ana itane am'ita bada ai'aine ihuna'o ta ana lowoinane laulau eli ana hauga. ");
INSERT INTO kud2014_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Yaiyadiwo hiya hilaulau'eli adi maiha hilobai, na laulau'eline tomowa yawahidi miyamiya vateyaina vehabana. Eeta yaiyadiwo hiya hilalaupeliwa na yaiyadiwo hiya hilalau'eline hiyaliyaya ovi'ovi. ");
INSERT INTO kud2014_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Teina walone walo moiha ebeha towaho ehebo taulaupeli na towaho ehebo taulau'eli. ");
INSERT INTO kud2014_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yau yavetamalegomiu laulau'eli vehabana ta tomowa amtanoidi. Tomowa tupwadi mwalona hilaupeli na hi'abiye masele na omiu amlau'eli.’ ");
INSERT INTO kud2014_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tenem dalavanane ainai Sameliyaone bagibagilidi Yeisu hiyemidiyei wuwuna waihiunane aidiyai iwalo mahalava iwalo, ‘Mumugagu maudoina iwalo mahalavaedi’. ");
INSERT INTO kud2014_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Eeta Sameliyaone hilaoma Yeisu ainai ta hi'awanoiyei ebeha baidadi himiyamiya ta Yeisu nemai ahubena bwau aidiyai imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Na hinage tomowa bagibagilidi Yeisu hiyemidiyei yana walone vehabana. ");
INSERT INTO kud2014_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Na waihiunane ainai hiwalo, ‘Yam walone ainaena a'awa moiha'o, nigele ebeha yam walo a'ava vehabadi na hesi ai ibom yana walone abenalena'o na ainaena ahanapui ili'ilimaniya'o ebeha iya Taulivahinaede taumiya bale'u maudoida vehabada’. ");
INSERT INTO kud2014_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ahubena bwau hi'ovi ta Yeisu tenem tupwane ilaugabaei ta ilalaune Galili. ");
INSERT INTO kud2014_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ta Yeisu yana aubabada tenem dova iwalo, ‘Tauwalo mahalavaone nigele teya adi ve'ahihi ebe hibom yadi tupwai higuguguguya’. ");
INSERT INTO kud2014_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Hauganane ibwaleni Galili ainai, Galiliwone hiyaliyaya yana bwalenine vehabana, wuwuna Buidi'wa guyauna Yelusalem ainai hilau ta Yeisu yana paihowa bada hi'itaya'o guyaune holanai ipapaihowaidine. ");
INSERT INTO kud2014_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ta ainaena Yeisu iwuwuyone Kena dalavanane holanai neta Galili tupwanane ainai. Mwalona tupwanane ainai we'aha mohili ipaihowai ta iyemala wainine. Tenem ainai ehebo tauloina mwala'ina natuna towahona ilovala Kapaneum ainai. ");
INSERT INTO kud2014_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Hauganane ibenalei ebeha Yeisu tupwa Yudeyaena ilaoma ta Galili ainai imiyamiya, tauloinanane ilau na Yeisu ainai i'awanoi iwalo, ‘Howahowana talau Kapaneum na natugu ilovala u'abiye namwanamwa, wuwuna muhamuhana na yana hauga i'ovi’. ");
INSERT INTO kud2014_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Na Yeisu towahonane ainai iwalo, ‘Omiu alimiyena nigele teya towaho iya yemidiyegau na ebe yagu paihowa wahiwahiyalana ana ve'ive'ilala am'ita, abo amyemidiyegau’. ");
INSERT INTO kud2014_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Na tauloinane Yeisu ainai iwalo ‘Bada, umwayamwayau ta talau mata dova ta natugune imwalowoi’. ");
INSERT INTO kud2014_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Na Yeisu iwalo, ‘Uwuyouyo yam vadai ta natumne u'ita bada inamwanamwa'o’. Na towahonane Yeisu yana walone iyemidiyei ta ilau gwaipileuyone. ");
INSERT INTO kud2014_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Hauganane yana laugwaipilene ainai yana taupaihowaone ilobaidi ta wasa himomoheine, hiwalo, ‘Natumwa bada ana lovala i'ovi'o’. ");
INSERT INTO kud2014_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ta aidiyai ipapanivilane mahana viha ainai natunane ana lovalane i'o'ovine. Na hiya hiwalo, ‘Lavi mahana ala'alapwahiyai ana ala'alawowoline isasawaline’. ");
INSERT INTO kud2014_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ta tauloinawa inuwatuwui tenem hauganane ainai Yeisu iwalo, ‘Natumne bada inamwanamwa'o’. Eeta towahonane yana huhuwone baidanao Yeisu hiyeyemidiyeine. ");
INSERT INTO kud2014_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Teina Yeisu yana paihowa wahiwahiyalana ana ve'ive'ilala bwauna hauganane Yudeyaena ilaoma ta Galili ainai ipaipaihowa. ");
INSERT INTO kud2014_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Hauga teina tuluhanai Yudeyaone ehebo abanuwatuwu avivini hipaihowai Yelusalem ainai, eeta Yeisu ihahaene Yelusalem guyaune vehabana. ");
INSERT INTO kud2014_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na Yelusalem ainai neta sipiwone yadi awa'edane ainai ehebo we'aha ni'uni'una imiyamiya. We'ahanane Yudeyaone alinadiyena hiwalo Bedesaida. Na tupwanane ainai vada aba'aiyawasi 5 hi'abidi ta himiyamiya we'ahane papalinai. ");
INSERT INTO kud2014_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Na vadaone aidiyai taulovala bagibagilidi himiyamiya, taumehe gibugibu yo daladaladi yo tapitapiyadi na hiha'waha'wa we'ahane yana mwahali vehabana. ");
INSERT INTO kud2014_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Wuwuna hauga maudoina Yaubada yana tausagenawasa ilaolaoma na we'ahanane inu'unu'uvi na ebe yaiya taulovala teya imwayamwayau na idalahugu mugai mata ana lovalane i'ovi ainaena. ");
INSERT INTO kud2014_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na taulovalaone aidiyena ehebo towaho ilovalovala neta bolimai 38. ");
INSERT INTO kud2014_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Na Yeisu ibwaleni ta towahonane i'i'itane na hinage ihanapuiya'o ebeha bolimai bagibagilidi lovala ainai imiyamiya, eeta Yeisu towahonane ipanivilaei, iwalo, ‘Nuwanuwam unamwanamwa?’ ");
INSERT INTO kud2014_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Na taulovalane iwalo, ‘Taubada, nigele teya agu tauhagu ta teina we'ahane ainai imwau aituluwegau ebe we'ahane yana hauga mwahali. Hauga maudoina yatowoi ebeha yabom ya'aitulu na nigele howahowagu, vali taulovalao hilaoma ta hi'aitulu ta hinamwanamwa na yau bada agu itaede.’ ");
INSERT INTO kud2014_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Na Yeisu towahonane ainai iwalo, ‘Utowolo na yam halabine u'avalai ta ulau’. ");
INSERT INTO kud2014_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tenem ainai towahone inamwanamwa ta yana halabine i'avalai ta ilalaune. Tenem hauganane ainai tapwalolo ana ahubena. ");
INSERT INTO kud2014_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Na Yudeyaone adi taumugaiwone towahonane hi'ita ta ainai hiwawalone, hiwalo, ‘Hava wuwuna tapwalolo udi'wai na yam halabine u'ava'avalauheine?’ ");
INSERT INTO kud2014_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Na yadi walone iyemaiha iwalo, ‘Towahone agu tau'abiye namwanamwane aliguwai iwalo, “Yam halabine u'avalai ta ulau” ’. ");
INSERT INTO kud2014_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Na hinage hipanivilaei hiwalo, ‘Aiteya towaho neta dova alimwai iwawalone?’ ");
INSERT INTO kud2014_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Eeta towahowa lovalaena inamwanamwawa nigele iyahanapui yaiya towaho. Wuwuna Yeisu bada ilao'o tomowa alodiyai ta nigele iya'ita lobai. ");
INSERT INTO kud2014_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Hauga mulitai Yeisu towahonane ilolobaine vada tapwalolo mwala'ina holanai, ta ainai iwawalone iwalo, ‘U'ita bada unamwanamwa'o, na havena hinage yababana upaipaihowai, mata dova ta ginauli yababa alilina ibwaleni alimwai’. ");
INSERT INTO kud2014_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Na towahonane ilau ta Yudeyaone aidiyai iwalo mahalavane ebeha ana tau'abiye namwanamwane iya Yeisu. ");
INSERT INTO kud2014_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Teina ainaena Yudeyaone Yeisu hive'alehaeine wuwuna paihowanane ahubena tapwalolo ainai ipapaihowaine. ");
INSERT INTO kud2014_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Tenem ainai Yeisu Yudeyaone aidiyai iwawalone iwalo, ‘Tamagu ahubena maudoidi aidiyai ipaipaihowa ainaena yau hinage dova’. ");
INSERT INTO kud2014_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yudeyaone yana walone hibenalei ta hitowotowoi vedova na hi'oiye mwalowoi. Wuwuna tapwalolo ana loina idi'wai yo hinage iwalo ebeha iya Yaubada Tamana moihana, yo ebeha Yaubada baidana hivetoyatoyawa. ");
INSERT INTO kud2014_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yeisu tomowaone aidiyai iwalo, ‘Yawalo moiha alimiyai, yau nigele howahowagu yabom paihowa hava yapaihowai. Na Tamagu yana paihowa, ya'itadi ta dova hinage yapaipaihowaidine. ");
INSERT INTO kud2014_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tamagu ivelauwegau mwala'ina ainaena yana paihowa maudoidi ipaipaihowaidi ive'itagau, ta yana paihowa yapaihowaidi. Na mata aluwamiu higavai wuwuna paihowa mwala'i alilidi ive'ive'itagau. ");
INSERT INTO kud2014_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Dova Tamagu taumwalowoiwone i'abiye towolodi ta yawahidine imohemohedine, yau hinage dova yawahi vauvauna yamohe tomowa aidiyai, yaiyadiwo hiya ivesinuwaidi'o. ");
INSERT INTO kud2014_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nigele hinage teya Tamagu yana loina tomowa adi lauvetala vehabana, wuwuna lauvetala ana loina maudoina bada imohegau'o ta yabom yapaihowaidi. ");
INSERT INTO kud2014_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Eeta maudoimiu amve'ahihiyegau bada dova Tamagu amve'ave'ahihiyeine. Na yaiyadiwo hiya nigele hiyave'ahihiyegau, hiya hinage Tamagu tauvetamalegaumane nigele hiyave'ahihiyei. ");
INSERT INTO kud2014_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","‘Yawalo moiha alimiyai ebe yaiyadiwo yagu walowone hibenaledi na iya ivetamalegaumane hiyemidiyei yawahi miyamiyavateyaina hilobai. Na ebe lauvetala ana hauga ainai omiu mata nigele loina amyalobai, wuwuna bada mwalowoi yana tupwa amlaugabaina'o ta amgeyo'awa'o yawahi vauvauna ainai. ");
INSERT INTO kud2014_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Na hinage yawalo moiha alimiyai ebeha hauga ilalaoma na bada teina ilaoma'o ta ebe taumwalowoiwo Yaubada Natuna alinana hibenalei, neta yau alinagu. Na ebe yaiyadiwo alinagu hibenalena'o yawahidi vauvauna hilobai. ");
INSERT INTO kud2014_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tamagu iya yawahi moiha wuwuna, italam'o aliguwai na yau hinage yawahi wuwuna. ");
INSERT INTO kud2014_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na hinage lauvetala ana loina imohegau'o ta yau yapaihowaidi wuwuna yau Tomowa Moihagu. ");
INSERT INTO kud2014_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","‘Eena havena am'alu'aluwagavai teina ginauliwone vehabadi. Hauga ilalaoma ainai taumwalowoi maudoidi alinagune mata hibenalei, ");
INSERT INTO kud2014_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","na magaiyena hibwalenima, ta hiya mumugadi namwanamwadi yawahi namwanamwana hilobai, na hiya mumugadi yababadi lauvetala hilobai. ");
INSERT INTO kud2014_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yau nigele howahowagu yabom paihowa yapaihowaidi, wuwuna yagu loina lauvetala vehabana Yaubada ive'itagau'o, ainaena yagu loina dumwaluna. Wuwuna yau nigele yatowotowoi na yagu nuwatuwu yabom yapaihowaidi, na hava dova iya ivetamalegaumane yana nuwatuwu yapaihowaidi.’ ");
INSERT INTO kud2014_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","‘Ebe yabom vehabagu yawalo mahalava neta nigele walomahalava moiha. ");
INSERT INTO kud2014_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Na hesi vali tomowa iya vehabagu bada iwalo mahalava'o ta yahanapuiya'o hava dova yana walomahalavane vehabagu neta walo moiha. ");
INSERT INTO kud2014_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mwalona omiu tauyewasa tupwadi amvetamaledi towahonane Yoni ainai, ta iya walomoiha ainaena vehabagu iwawalone, ta alimiyai hiwalo mahalavane.’ ");
INSERT INTO kud2014_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Hinage Yeisu aidiyai iwalo, ‘Yau nigele tomowa yadi walomahalava vehabana yayanuwanuwatuwu, na vehabamiu yawalowalo mahalava Yoni yana aubabada vehabana, ta ebeha amnuwamasele ta livahi amlobai. ");
INSERT INTO kud2014_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yoni dova lampa masemaselena, ta omiu mwalona hauga iu'iuna ainai nuwanuwamiu, ta yana maselene ainaena amyaliyaliyaya. ");
INSERT INTO kud2014_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","‘Yoni yana walomahalavane vehabagu neta ginauli mwala'ina, na hesi ehebo ginauli mwala'i alilina imiyamiya, neta aba'itao teina Tamagu ainaena yapaipaihowaidine. Ebe paihowadine vehabadi amnuwatuwu ili'ilimani mata amnuwamasele ebeha Tamagu iya ivetamalegaumane. ");
INSERT INTO kud2014_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Na Tamagu hinage iya iwalo mahalavaegau, na omiu nigele teya hauga alinanane amyabenalei bo maninane amya'ita. ");
INSERT INTO kud2014_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Na hinage yana walowone alimiyai nigele atemiyai hiyamiya. Wuwuna nigele amyayemidiyegau ebeha yau Yaubada ainaena yalalaomane. ");
INSERT INTO kud2014_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Hauga maudoina Buki Ve'ahihi amvahivahili na yami nuwatuwu ebeha howola mata yawahi miyamiya vateyaina amlobai, na nigele amyanuwamasele ebeha Buki Ve'ahihine iwalowalo mahalavaegau. ");
INSERT INTO kud2014_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ainaena nigele nuwanuwamiu yawahi miyamiya vateyaina vehabana amlaoma aliguwai. ");
INSERT INTO kud2014_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","‘Yau nigele yayanuwanuwatuwu yabom agu walo vetuvehae vehabana tomowa aidiyena. ");
INSERT INTO kud2014_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Na omiu bada yahanapuiya'o ebeha nigele teya Yaubada ana velau atemiyai iyamiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Am ita yau Tamagu yehanaena yalalaomane na nigele vehabagu amyayaliyaya, na ebe yaiya ibom yehanaena na ilaoma alimiyai, iya vehabana mata amyaliyaya. ");
INSERT INTO kud2014_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Omiu nuwanuwamiu tomowa aidiyena walo vetuvehae ambenalei, na hesi ami walo vetuvehae Yaubada ainaena nigele nuwanuwamiu. Eeta neta wuwuna nigele amyayemidi. ");
INSERT INTO kud2014_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","‘Havena amnuwanuwatuwu ebeha yau mata yave'ewaigomiu Tamagu mehenai. Hesi Mosese mata howola abo ive'ewaigomiu. Yami nuwatuwu ebeha Mosese yana laugagayo ihaguigomiu, mata nigele. ");
INSERT INTO kud2014_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Na ebe omiu Mosese amyemidiyei moiha, yau hinage amyemidiyegau, wuwuna iya mwalona Buki Ve'ahihi ainai vehabagu iwalo mahalava ta ilelelene. ");
INSERT INTO kud2014_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Na yana walomahalavane nigele amyayemidiyei ainaena nigele howahowana yagu walone amyemidiyei.’ ");
INSERT INTO kud2014_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yeisu Galili le'awanane imiyamiya, na le'awanane yehana bwauna neta Taibiliya. Ta Yeisu igelu na igegeyo'awane vali geyo'awai. ");
INSERT INTO kud2014_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Na hinage boda mwala'ina Yeisu himulimulitaei, wuwuna bada yana paihowa wahiwahiyalana taulovala aidiyai hi'itaya'o. ");
INSERT INTO kud2014_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Eeta Yeisu ana taumulitaone baidanao hihae oyai ta hitalumiyahiwa. ");
INSERT INTO kud2014_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Hauganane ainai bada hauga ilautebitebiniya'o ta Yudeyaone yadi Buidi'wa guyauna hipaihowai. ");
INSERT INTO kud2014_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Eeta Yeisu i'ita gwaipile ta boda mwala'ina i'i'itadine hilaolaoma ainai. Ta Yeisu Pilipi ainai iwalo, ‘Pilipi havaena mata ai'ai tagimwala ta teina tomowaone tave'aidine?’ ");
INSERT INTO kud2014_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Teina panivilane ainaena Yeisu Pilipi itotowoine, na bada ihanapuiya'o hava mata ipaihowai tomowaone vehabadi. ");
INSERT INTO kud2014_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Eeta Pilipi Yeisu ainai iwawalone iwalo, ‘Teina boda imwala'i alili, na ebe 200 kina ainaena beledi tagimwalai na taguyauwei aidiyai, mata nigele howahowana maudoidi hilautowo’. ");
INSERT INTO kud2014_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Na hinage teya Yeisu ana taumulita Andulu, iya Saimoni Pita tahina ainai iwawalone, ");
INSERT INTO kud2014_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","iwalo, ‘Ehebo gama teina yalobaiya'o ma'ana beledi nima ehe'ehebo na yama bwau ainai, na nuwana teina bodane nigele howahowadi’. ");
INSERT INTO kud2014_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ta Yeisu ana taumulitaone aidiyai iwalo, ‘Tomowaone maudoidi aidiyai amwalo ta awahine ainai himiya’. Wuwuna tupwanane tenem i'awahi ta tomowa himimiyane ainai. Na towatowaho hibom hivavahilidine ta adi bagibagili dova tausani 5. ");
INSERT INTO kud2014_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Na Yeisu belediwa ivaidi ta vehabadi i'awa yauwedo Yaubada ainai, na mulitai tomowaone himimiyane aidiyai higuguyauweine. Na hinage yamaone bwau dova aidiyai hipapaihowaine, ta maudoidi hi'ai ta howahowadi? ");
INSERT INTO kud2014_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Hi'ai i'ovi na Yeisu ana taumulitaone aidiyai iwalo, ‘Beledi tupwatupwadine amtano'ahai. Havena teya tupwa amgabagabaei.’ ");
INSERT INTO kud2014_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Eeta beledi 5 ainaena tomowaone hi'a'aine, na taumulitaone tupwawa hitano'ahaidi ta boha 12 hi'oiye mwaudine. ");
INSERT INTO kud2014_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tenem hauganane ainai tomowaone Yeisu yana paihowa wahiwahiyalana ana ve'ive'ilala hi'ita ta hiwalo, “Moiha teina tauwalo mahalavanaede hiwalo yemidiyeiwa ebeha bale'uwai mata ilaoma”. ");
INSERT INTO kud2014_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ta tenem ainai Yeisu tomowaone ihanapuidi ebeha muhamuhana na hi'abi avivini ta aidiyai ivetauwasawasa. Na Yeisu ibom nigele nuwanuwana eeta ibom ilau ta ihahaene oyai. ");
INSERT INTO kud2014_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","I'imwa'imwa'auhi na ana taumulitaone hidodobine Galili le'awanane ainai, ");
INSERT INTO kud2014_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","na yadi wagane ainai higelu ta ebeha higeyo'awauyo Kapeneum tupwanane ainai. Gabwai hiwohewohe ta iguguyou'o na Yeisu nigele aidiyai iyalaoma. ");
INSERT INTO kud2014_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Hauganane ainai yaumai yo bagodu mwala'ina hilolobaine. ");
INSERT INTO kud2014_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Na bada hiwohe ta muhamuhana amwaha daodaowai, na Yeisu ni'une ewanaena ilaolaoma yadi wagane vahalinai hi'i'itane ta maudoidi himeheuhi. ");
INSERT INTO kud2014_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Eeta aidiyai iwalo, “Havena ammehemeheuhi. Yau ta'i.” ");
INSERT INTO kud2014_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Eena taumulitaone hiwalo ta Yeisu igegelune wagai. Na wagane itaumwayaumwayau ta hidunahaene Kapeneum le'awanai. ");
INSERT INTO kud2014_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","I'ahubenama ta vali geyo'awai Galili le'awanai ana taumiyao hihanapuiya'o hiya Yeisu ana taumulitao hibom waga higelui ta hilalaune, Yeisu nigele baidadi. ");
INSERT INTO kud2014_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ahubenanane ainai Taibiliyaena waga tupwadi hilaoma ta tupwanane ainai Yeisu bodaowa belediyena iveve'aidiwa vahalinai hiluluwune. ");
INSERT INTO kud2014_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ta tenem ainai tomowa maudoidi Yeisu mayana taumulitao hibeha ahayaidi, eeta higelu ta higegeyo'awane Kapeneum wagaena Yeisu habi behaeina. ");
INSERT INTO kud2014_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Higeyo'awa ta hilobai na ainai hipanivila hiwalo, ‘Bada, maivihana ulalaomane?’ ");
INSERT INTO kud2014_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Na tomowaone aidiyai iwalo, ‘Yawalo moiha alimiyai omiu nigele amyabehabehaegau yagu paihowa wahiwahiyaladi adi ve'ive'ilala vehabadi, na hesi yami beha wuwuna neta belediwone am'aidi ta am'ai'i'i'wahine vehabana. ");
INSERT INTO kud2014_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Omiu havena ai'ai ovi'ovina vehabana ampaipaihowa na hesi ai'ai yawahi miyamiya vateyaina vehabana ampaihowa. Yau Tomowa Moihagu teina ai'ainane yamohemohegomiu, wuwuna Yaubada Tamagu iya ivesinuwaigau teina yana paihowane vehabana.’ ");
INSERT INTO kud2014_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Na hiya ainai hiwawalone, hiwalo, ‘Hava mata aidiyena Yaubada yana paihowane apaihowaine?’ ");
INSERT INTO kud2014_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Na Yeisu aidiyai iwawalone, iwalo, ‘Yaubada yana paihowa teina, ebeha amyemidiyegau yau Tomowa Moihagu ivetamalegaumane’. ");
INSERT INTO kud2014_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ta ainai hiwalo, ‘Yede ve'ive'ilala upaihowai ta ebe ayemidiyego. ");
INSERT INTO kud2014_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mwalona dova tubumaiyaone nu'ulu awawai na ai'ainane hi'ai'ai, yehanaede mana, dova Buki Ve'ahihi yana walo, ai'ai galewaena imohedi ta hi'a'aine. Eeta owa havaidova hinage yam ve'ive'ilala upaihowai, na a'ita. ");
INSERT INTO kud2014_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Na Yeisu tomowaone aidiyai iwalo, ‘Yawalo moiha alimiyai neta Mosese iya nigele ai'ai galewaena iyamohegomiu, na hesi Tamagu iya ai'ai moiha galewaena imohemohegomiu. ");
INSERT INTO kud2014_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Na ai'ainane neta Yaubada ainaena iya bada ilaoma'o bale'uwai ta tomowa yawahidi imohemohedi.’ ");
INSERT INTO kud2014_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Na hiya hinage Yeisu ainai hiwawalone, hiwalo, ‘Taubada teina ai'aine umohegai hauga maudoina’. ");
INSERT INTO kud2014_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Na Yeisu aidiyai iwalo, ‘Yau ai'ai yawahi vehabana ta ebe yaiya ilaoma aliguwai, mata nigele iyavahali, na hinage ebe yaiya iyemidiyegau mata nigele gadonane iyamaguni. ");
INSERT INTO kud2014_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Bada yawalo'o alimiyai ebeha am'itagau'o na hesi nigele amyayemidiyegau. ");
INSERT INTO kud2014_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tomowaone hiya Tamagu imomohegaune mata hilaoma aliguwai na nigele mata yayasosomanedi. ");
INSERT INTO kud2014_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Wuwuna yau galewaena yalaoma nigele yabom yagu nuwatuwu habi paihowaina, na hesi iya ivetamalegaumane yana nuwatuwuwena. ");
INSERT INTO kud2014_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Agu tauvetamalene yagu tomowa imohegau'o, na teina yana nuwatuwu ta ebeha havena teya aidiyena yavesavesawali, na hesi hauga yana aba'ovi ainai mwalowoiyena ya'abiye towolouyowedi. ");
INSERT INTO kud2014_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Teina Tamagu yana nuwatuwu dova, ebe yaiyadiwo hiya, yau natunane hi'itagau yo hinage hiyemidiyegau yawahi miyamiya vateyaina hilobai, na hauga yana aba'ovi ainai yau mwalowoiyena ya'abiye towolouyowedi.’ ");
INSERT INTO kud2014_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tenem ainai Yudeyaone yana walone hibenalei ta hi'u'ulumiyaneine, wuwuna yana walone ainai iwalo, ‘Yau ai'ainaede galewaena ya'a'aitulumane’. ");
INSERT INTO kud2014_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Na hinage hiya hiwalo, ‘Teina towahone Yosepa natuna, iya Yeisu, awa? Na tamanane yo hinanane tahanahanapuidi, na vedova ta iwalo ebeha iya galewaena i'a'aitulumane?’ ");
INSERT INTO kud2014_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Na Yeisu aidiyai iwawalone, iwalo, ‘Havena abom alimiyai am'ulu'ulumiyai vehabagu. ");
INSERT INTO kud2014_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nigele howahowana yaiya ibom nuwanaena ilaoma aliguwai na hesi ebe yaiyadiwo hiya Tamagu iniulidi na aliguwai hilaoma, hiya hauga yana aba'ovi ainai mwalowoiyena ya'abiye towolouyowedi. ");
INSERT INTO kud2014_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Teina walone bada mwalona tauwalo mahalavao hileleya'o Buki Ve'ahihi ainai, hiwalo, 'Tomowa bagibagilidi adi ve'ita hilobai Yaubada ainaena, na ebe yaiyadiwo hiya Tamagu yana ve'ita hibenalei yo hihanapui hiya mata aliguwai hilaoma. ");
INSERT INTO kud2014_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Na omiu nigele teya alimiyena Tamadane iya'ita, bada yabom, wuwuna yau ainaena yalalaomane. ");
INSERT INTO kud2014_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Yawalo moiha alimiyai ebeha yaiyadiwo hiya hiyemidiyegau yawahi miyamiya vateyaina hilobai. ");
INSERT INTO kud2014_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Wuwuna yau yawahimiune ana. ");
INSERT INTO kud2014_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mwalona nu'ula awawai tubumiyaone ai'ai yehanaede mana hi'ai'ai na hesi nigele yawahi miyamiya vateyaina ainaena hiyalobai na bada himwamwalowoine. ");
INSERT INTO kud2014_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ta teina ai'aine galewaena i'a'aitulumane ebe yaiya i'ai mata nigele iyamwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yau yawahimiune ana galewaena ya'a'aitulumane ta ebe yaiya ai'ainane i'ai yawahina miyamiya vateyaina ilobai, na ai'ainane yamohegomiu neta yau taugu, wuwuna taugune yatalamwei taumiya bale'u bagibagilimiu yawahimiu vehabana.’ ");
INSERT INTO kud2014_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ta tenem ainaena Yudeyaone hivetuwuni na hibom hiveta'eta'e, hiwalo, ‘Vedova ta teina towahone ebeha taunane imohegita ta'ai?’ ");
INSERT INTO kud2014_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Eeta Yeisu aidiyai iwawalone, iwalo, ‘Yawalo moiha alimiyai, yau Tomowa Moihagu, na ebe taugu nigele amya'ai yo hinage 'wahinagune nigele amyanuma, mata nigele yawahimiu amyalobai. ");
INSERT INTO kud2014_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Na ebe yaiya taugune i'ai yo 'wahinagune inuma, yawahi miyamiya vateyaina ilobai, na hauga yana aba'ovi ainai mwalowoiyena ya'abiye towolouyowei. ");
INSERT INTO kud2014_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Na amnuwatuwu avivini ebeha taugune ai'ai moiha, na 'wahinagune abanuma moiha. ");
INSERT INTO kud2014_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ainaena ebe yaiya iya taugune i'ai yo 'wahinagune inuma iya aliguwai imiyamiya na yau hinage ainai yamiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tamagu iya mayawahina ivetamalegauma ta iya hauga maudoina ainaena yawahigune yavaivaine. Yau hinage dova, ebe yaiya i'aigau mata yawahina aliguwena ilobai. ");
INSERT INTO kud2014_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Teina ai'aine galewaena ilalaomane nigele dova ai'aiwa tubumiyaone hi'a'aiwa, balabala awawai wuwuna mwalona ai'aiwa hi'a'aine nigele ainaena yawahidi miyamiya vateyaina hiyalobai, na bada himwamwalowoine. Eeta teina ai'aine aliguwena ebe yaiya i'ai yawahi miyamiya vateyaina mata ilobai.’ ");
INSERT INTO kud2014_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Teina ginauliwone maudoina iwalo mahalavaedi hauganane ive'ive'ita vada tapwalolo holanai tupwa Kapaneum ainai. ");
INSERT INTO kud2014_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ana taumulitaone bagibagilidi Yeisu yana walone teina hibenalei ta hibom aidiyai hiwalo, ‘Teina walone ana benaline ivitai. Yaiya mata ibenaleine?’ ");
INSERT INTO kud2014_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Na Yeisu iya ihanapu mugaiyena'o ebeha teina walone vehabadi hi'ulu'ulumiyaine, ta aidiyai iwalo, ‘Teina walone vehabana nuwamiune iyababa. ");
INSERT INTO kud2014_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yau Tomowa Moihagu mwalona galewaena yadobima na howola abo yawuyo. Na ebe yagu wuyone am'ita, mata amyemidiyegau? ");
INSERT INTO kud2014_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Na Yaubada Alu'aluwana iya yawahimiu ana taumohe ta nigele howahowana na tomowa hibom yadi wahiyalaena. Yagu walo teina bada yamohegomiu'o, na aidiyena Yaubada Alu'aluwana ainaena yawahimiu imohegomiu. ");
INSERT INTO kud2014_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Hesi tupwamiu nigele amyayemidiyegau.’ Yeisu teina walowone iwalowedine, wuwuna ihanapu mugaiyena'o, yaiyadiwo hiya nigele hiyayemidiyei na hinage ihanapuiya'o yaiya ana tauhuhulane. ");
INSERT INTO kud2014_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Na hinage aidiyai iwawalone, iwalo, ‘Teina vehabana mwalona yawawalo mugaine alimiyai, ebeha nigele howahowana na yaiya ibom ilaoma aliguwai na hesi yaiyadiwo hiya Tamagu aidiyai italam’. ");
INSERT INTO kud2014_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Teina ainaena Yeisu ana taumulitaone bagibagilidi hita'wata'wataei ta hilalaugabaeine. ");
INSERT INTO kud2014_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Na hitau 12 a'ava hitutupwane, na Yeisu aidiyai iwawalone, iwalo, ‘Omiu hinage nuwanuwamiu na amlau, awa?’ ");
INSERT INTO kud2014_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Eena Saimoni Pita iwawalone Yeisu ainai, iwalo, ‘Bada, yaiya ainai mata alaune? Wuwuna owa ubom yawahi miyamiya vateyaina ana walo alimwai imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Na ai bada ayemidiyego'o yo ahanapuigo'o ebeha owa Besinana Ve'ave'ahihina Yaubada ainaena.’ ");
INSERT INTO kud2014_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Na Yeisu iwalo, ‘Moiha, amtau 12 yavesinuwaigomiu, na hesi ehebo alimiyena iya Tomodulele yana boda’. ");
INSERT INTO kud2014_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Yeisu teina iwalowalone Yudasa vehabana, iya Saimoni Isakaliyota natuna. Na Yudasanane iya teya Yeisu ana taumulita na hesi howola abo iya ihuhulaei.) ");
INSERT INTO kud2014_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mulita Yeisu Galili maudoina ainai itata'i'iline. Na hesi nigele nuwanuwana na Yudeya tupwanane ainai ita'i'ili, wuwuna Yudeyaone yadi tauloinao nuwanuwadi ebeha hi'oiye mwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Hauga tenem ainai Yudeyaone yadi Gwau guyauna ana hauga ilau tebitebiniya'o. ");
INSERT INTO kud2014_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Eeta Yeisu tahinaone ainai hiwawalone, hiwalo, ‘Teina tupwane ulaugabaei na Yudeya ainai ulau ta ebe nemai amtau mulitaone yam paihowa hi'ita’. ");
INSERT INTO kud2014_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Yo hinage ainai, hiwalo, ‘Uhanapui neta ebeha nigele teya yaiya paihowa dawaniyena ainaena yehana iyamwalamwala'i, na ebe nuwanuwam na tomowaone maudoidi hihanapuigo, ubom uve'itauyowego tomowaone aidiyai’. ");
INSERT INTO kud2014_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tahinaone teina walone hiwawaloweine ainai wuwuna nigele hiyayemidiyei. ");
INSERT INTO kud2014_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ta tenem ainai iwawalone aidiyai, iwalo, ‘Yagu hauga moihana nigele iyabwaleni na tenem tupwanane ainai yalau, na omiu hesi ilowoinanegomiu ta ainai amlau, ebe aiteya hauga nuwanuwamiu. ");
INSERT INTO kud2014_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Wuwuna omiu nigele howahowana taumiya bale'uwone hive'alehaegomiu, na yau hesi hive'alehaegau wuwuna mumugadi yababadiyaone yawalowalo mahalavaedi. ");
INSERT INTO kud2014_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Inamwanamwa omiu ambom amlau guyaune ainai. Yau mata nigele yayalaowa ainai, wuwuna nigele yagu hauga moiha iyabwaleni.’ ");
INSERT INTO kud2014_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Teina walone imohedi ta hilalaune na iya Galili ainai bada imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yeisu tahinaone hilaugabaei ta hilao'o guyaune ainai, na Yeisu tuluhadiyena ilaudawadawani ta tupwanane ainai ibwabwalehine, na nigele teya yaiya iyahanapui. ");
INSERT INTO kud2014_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Hauganane ainai Yudeyaone yadi tauloinao Yeisu hibehabehaei guyaune holanai na hi'au'aubabada, ‘Haidova teina towahonane?’ ");
INSERT INTO kud2014_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ta tenem ainai tomowa bagibagilidi hibom aidiyai hi'ulu'ulumiya Yeisu vehabana, ta tupwadi hiwalo, ‘Iya towaho namwanamwana’. Na tupwadi hiwalo, ‘Nigele! Iya towaho oya'oyamana.’ ");
INSERT INTO kud2014_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Na tomowa bagibagilidi Yudeyaone yadi tauloinao himeheuhedi ta nigele yaiya teya iya'awa namwanamwa Yeisu vehabana. ");
INSERT INTO kud2014_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Na bada guyau gamwagamwana ta Yeisu iluwu vada tapwalolo holanai ta yana ve'ita ivevetuwunine. ");
INSERT INTO kud2014_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Eena Yudeyaone tenem ainai nuwadine ipwanopwano mwala'ina na hiwalo, ‘Havanaena teina towahone yana hanapune ilolobaine? Iya nigele abase'ulu teya ainai iyaluwu.’ ");
INSERT INTO kud2014_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Na Yeisu iwawalone aidiyai, iwalo, ‘Yau nigele yabom yagu nuwatuwuwena na hesi agu tauvetamalene yana nuwatuwu ainaena yave'ive'itane. ");
INSERT INTO kud2014_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Omiu hinage ebe nuwanuwamiu na Yaubada yana nuwatuwu ampaihowai, yagu ve'itane amhanapui ebeha Yaubada ainaena, na nigele yabom yagu nuwatuwu ainaena. ");
INSERT INTO kud2014_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Hesi amnuwatuwu avivini ebe yaiya ibom yana nuwatuwuwena ive'ive'ita iya ibom yehana vehabana ipaipaihowane. Na yau hesi nigele dova omiu, wuwuna yau nuwanuwagu na agu tauvetamalene yehanane ya'abiye mwala'i, eeta yana walone hidumwalu na hinamwanamwa. ");
INSERT INTO kud2014_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosese yana loina imohemohegomiu maudoimiu amta'wata'wataei eeta nuwanuwamiu ebeha am'oiye mwalowoigau.’ ");
INSERT INTO kud2014_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ainaena tomowaone yana walone hiyemaiha na hiwalo, ‘Vedova alu'aluwa yababana ulu'ulum i'abiye yauyaule, eeta neta dova uwalowalone? Na yaiya nuwanuwana ebeha i'oiye mwalowoigo?’ ");
INSERT INTO kud2014_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Eena Yeisu yadi walone iyemaiha na aidiyai iwalo, 'Nuwamiune ipwanopwano wuwuna ahubena Tapwalolo ainai towaho ya'abiye namwanamwa. ");
INSERT INTO kud2014_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Na vedova omiu yami paihowa ahubena Tapwalolo ainai? Wuwuna Mosese yana loinaena natumiyaone towatowahodine taudiyai ve'ive'ilala amhapihapidi. (Na teina loinane nigele Mosese ainaena na hesi mwalona tubudaone mumugadiyaone aidiyena ilalaomane.) ");
INSERT INTO kud2014_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Na amwa'amwahane towatowahodi aidiyai ampaipaihowai ahubena Tapwalolo ainai. Hava wuwuna ta amve'alehaegaune hauganane ahubena Tapwalolo ainai towahone ya'abiye namwanamwane? ");
INSERT INTO kud2014_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Havena walo vesivesinuwaena amve'ewa oya'oyamaegau na hesi mumugagu yo yagu walo amvinunu ili'ilimanidi. ");
INSERT INTO kud2014_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tenem ainai tupwadi Yelusalemaone hiwalo, ‘Nuwana teina towahone iya nuwanuwadi na hi'oiye mwalowoi, awa? ");
INSERT INTO kud2014_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Na am'ita tomowaone ahi'ahipudiyai itowotowolo na i'au'aubabadane aidiyai, na nigele teya alinanane iyayemaiha. Nuwana ada taumugaiwone hi'awa moihae ebeha iya Besinana towahona, awa? ");
INSERT INTO kud2014_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Na tupwadi hiwalo, ‘Maudoida bada tahanapuiya'o havaena ilalaomane. Na ebeha Besinana towahona mata yana abalaoma nigele teya yaiya iyahanapui.’ ");
INSERT INTO kud2014_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Hauganane Yeisu howola ive'ive'ita vada tapwalolo holanai alinana mwala'ina ainaena iwawalone, ‘Moiha amhanapuigau'o ebeha yau havaena yalalaomane? Na amnuwatuwu avivini iya ivetamalegaumane ta yana loinaena yalalaomane. Nigele yau yagu loina ainaena na dalava teina ainai yalaoma, na agu tauvetamalene mumuganane inamwanamwa yo idumwalu, na omiu hesi nigele amyahanapui iya yaiya. ");
INSERT INTO kud2014_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Na yau yahanapuiya'o, wuwuna iya ivetamalegauma ta ainaena yalalaomane.’ ");
INSERT INTO kud2014_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tenem ainai tomowaone hitowoi ta ebeha hi'abi avivini, na hesi nigele teya yaiya iya'abitowoi, wuwuna iya nigele yana hauga iyabwaleni na imwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Na hesi tomowa bagibagilidi hiyemidiyei ta hiwalo, ‘Moiha teina Besinana towahona, nigele howahowana na besinana teya ilaoma na yana paihowa wahiwahiyalana imugaiyei’ ");
INSERT INTO kud2014_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tenem ainai tomowaone yadi walo himhim Palisiwone hibenalei, ta hiya yo taupwaoliwone mwalamwala'idi yadi tau'alehao hivetamaledi na Yeisu ebeha hi'abi avivini. ");
INSERT INTO kud2014_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Eena Yeisu iwawalone, iwalo, ‘Yau bada hauga ubwa'ubwana ainai baidamiu na hinage yawuyouyo agu tauvetamalene ainai. ");
INSERT INTO kud2014_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Na howola mata ambehaegau na nigele mata amyalobaigau, na tupwanane ainai yamiyamiyane omiu nigele howahowamiu na ainai amlaowa.’ ");
INSERT INTO kud2014_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Eeta Yudeyaone hibom aidiyai hiwalo, ‘Havaidova ainai ebeha ilalau ta mata nigele tayalobai? Ebeha ilalau hiya Yudeyaone himiyamiya taumiya ganamuli yadi tupwa ainai ta ive'itadi, awa? ");
INSERT INTO kud2014_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Teina yana walone vedova ana nuwamasele? Wuwuna iwalo, “Howola abo ambehaegau na mata nigele amyalobaigau”, na hinage iwalo, “Tupwanane ainai yamiyamiyane omiu nigele howahowamiu na ainai amlaowa”.’ ");
INSERT INTO kud2014_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Guyau ana ahubena mwala'ina yana aba'ovi ainai, Yeisu ahi'ahipudiyai itowolo na alinana mwala'ina ainaena iyogayoga, iwalo, ‘Yaiya owa gadom imaguni ulaoma aliguwai ta unuma. ");
INSERT INTO kud2014_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Wuwuna Buki Ve'ahihi ainai iwalo mahalavaenao, iwalo, “Agu tauyemidiwone atediyena dova we'aha mayawahina isagesagena”.’ ");
INSERT INTO kud2014_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yeisu yana walone neta Alu'aluwa Ve'ahihi vehabana i'au'aubabadane wuwuna, Alu'aluwa Ve'ahihi mata tauyemidiwo atedi i'oiye mwaudi. Na hauga tenem ainai Alu'aluwa Ve'ahihi nigele iyaluwu tomowaone aidiyai, wuwuna Yeisu howola nigele iyayemala wasawasa. ");
INSERT INTO kud2014_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yeisu yana walo tomowa bagibagilidi hibenalei, ta tupwadi hiwalo, ‘Moiha, teina towahone iya tauwalo mahalavanaede hiwalowaloweine’. ");
INSERT INTO kud2014_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Na tupwadi hinage hiwalo, ‘Iya Besinana towahona’. Na hinage tupwadi aidiyena hiwalo, ‘Ebeha Besinana moiha Galiliyena ilalaomane? ");
INSERT INTO kud2014_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nigele howahowana, wuwuna Buki Ve'ahihi bada ainai iwalo mahalava'o ebeha Besinana Deivida yana huhu ainaena ilalaoma ta Deivida yana dalavane Betelehem ainai mata Besinana itubui.’ ");
INSERT INTO kud2014_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tenem ainai na waheine ibwabwalenine tomowaone ahi'ahipudiyai. ");
INSERT INTO kud2014_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ta tupwadi nuwanuwadi na Yeisu hi'abi avivini, na nigele teya yaiya iya'abitowoi. ");
INSERT INTO kud2014_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Eeta tau'alehao hiwuyo taupwaoli mwalamwala'idi yo Palisiwone aidiyai, na hipanivilaedi hiwalo, ‘Hava wuwuna nigele amya'abi avivinine?’ ");
INSERT INTO kud2014_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Na tau'alehaone yadi babadaone aidiyai hiwawalone hiwalo, ‘Tenem towahone yana walone inamwanamwa alili. Nigele teya hinage yaiya dova.’ ");
INSERT INTO kud2014_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ta Palisiwone hiwalo, ‘Mwali nuwamiune ivai, awa? ");
INSERT INTO kud2014_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Na amhanapui ebeha nigele teya yaiya tauloina nuwana Palisiwone alimaiyena Yeisu ayayemidiyei. ");
INSERT INTO kud2014_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Na hesi tomowa maudoidi Yeisu hiyemidiyei, wuwuna tomowaone nigele Mosese yana loinane ainai hiyanuwamasele, eeta Yaubada adi maiha yababana mata imohedi.’ ");
INSERT INTO kud2014_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ehebo hinage aidiyena tauloina yehanaede Nikodimo, iya mwalona boniyaiyena ilau ta Yeisu baidana hi'aubabadane, ana geluwone aidiyai iwawalone, ");
INSERT INTO kud2014_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","iwalo, ‘Ita yada loina tenem dova, ebeha havena taloiloina awa'awawa na hesi mugai towaho tapanivilaei na yana yababa hava abo ana loina tamohei’. ");
INSERT INTO kud2014_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Na babadaone Nikodimo hiwalo yagai, hiwalo, ‘Nuwana owa hinage gama Galiliyena awa? Na Buki Ve'ahihi uvahili ta uhanapui ebeha nigele hinage teya tauwalo mahalava Galiliyena iyalaoma.’  ");
INSERT INTO kud2014_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Eeta maudoidi bada hilo'uhagwali na hiwuyo yadi dalavai. ");
INSERT INTO kud2014_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yeisu Olive oyanane ainai ihae. ");
INSERT INTO kud2014_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Na malatomtomwai Yeisu ilau gwaipileuyoma vada tapwalolo mwala'ina holanai na tomowa maudoidi himiya gwaigwaipileyei na iya hinage italumiyahiwa ta iveve'itadine. ");
INSERT INTO kud2014_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Na loina ana tauve'itao yo hinage Palisiwo waihiu ehebo hilauvaiyama, wuwuna iya hilobai ipwanoli eeta waihiunane tomowa ahi'ahipudiyai hivetowolo, ");
INSERT INTO kud2014_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","na Yeisu hiwalo auline, hiwalo, ‘Tauve'ita, waihiu teina bada alobaiya'o ipwanoli. ");
INSERT INTO kud2014_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na ita yada loina Mosese ainaena ebe waihiu teina dova talobai, gaimaena tagohaye'i'iwahi ta imwalowoi. Na owa vedova yam nuwatuwu waihiu teina vehabana?’ ");
INSERT INTO kud2014_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Walo teina hi'a'ataine ebeha Yeisu yana walo pwano hilobai na hive'ewai. Eeta Yeisu nigele teya yadi walone iyayemaiha na hesi imiyanobu na ipwagogo ta nimagiginaena namonamowai ilaulaulele, ");
INSERT INTO kud2014_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","na hibom bada howola hipanipanivilaei. Eeta Yeisu itowolo ta iwalo aulidine iwalo, ‘Ehe, ausala, ebe alimiyena nigele teya yaiya yana yababa, mata iya gaima utuwu mugaiyei waihiune tenem ainai’. ");
INSERT INTO kud2014_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Eena hinage ipwagogo ta namonamowai ilaulauleleuyo. ");
INSERT INTO kud2014_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tenem ainai Yeisu yana walo hibenalei ta yadi pwanoliwo hinuwatuwuidi eeta ehebo ehebo ilaulau. Hiya Tautaubadao hilau mugai na maudoidi tuluhadiyena ta hitau bwau hitutupwane Yeisu na waihiuwa ibom itowotowolo. ");
INSERT INTO kud2014_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yeisu itowolo ta waihiuwa iwalo auli, iwalo, ‘Towatowahowa havaidova hilao'o? Nigele teya iyatupwa ta iyave'ewaigo?’ ");
INSERT INTO kud2014_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Na waihiuwa iwalo, ‘Taubada, nigele teya yaiya’. Eena Yeisu iwalo, ‘Ehe, yau hinage mata nigele yayave'ewaigo. Ausala, ulau, na hesi havena upwanopwanoliuyo.’ ");
INSERT INTO kud2014_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yeisu aidiyai iwalouyo, iwalo, ‘Yau tomowa yadi masele, na ebe yaiya iya imulitaegau maselegu yawahina ainai ihinali, na mata nigele hinage guguyou ainai iyalaulau’. ");
INSERT INTO kud2014_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Na Palisiwone Yeisu hiwalo auli hiwalo, ‘Owa ubom vehabam uwalowalo, ainaena nigele ayayemidiyego’. ");
INSERT INTO kud2014_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Na Yeisu hinage iwalouyo aidiyai iwalo, ‘Moiha yabom vehabagu ya'au'aubabada na hesi hava dova yagu walomahalava, neta walo moiha, wuwuna tupwanane ainaena yalalaomane yo hinage mulitai abo ainai yawuyo yahanapuiya'o. Na hesi omiu tupwanane ainaena yalalaomane na hinage howola mata ainai yalau gwaipile nigele amyahanapui. ");
INSERT INTO kud2014_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Na omiu yami ve'ewa, taumiya bale'u yadi nuwatuwuwena amve'eve'ewaigau na yau nigele teya yaiya yayave'eve'ewai. ");
INSERT INTO kud2014_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ebe tomowa yave'ewaidi, teina loina dumwadumwaluna, wuwuna loina teina nigele yau yagu loina na hesi Tamagu iya'ivetamalegaumane baidagu yama loina. ");
INSERT INTO kud2014_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Na hinage yada loinaone leleledi ainai hiwalo mahalava ebeha tauwalo mahalava hitau bwau yadi walo ehe'ehebona, neta walomahalava moiha. ");
INSERT INTO kud2014_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Neta dova yau vehabagu yawalowalo na hinage Tamagu iya ivetamalegauma vehabagu iwawalo mahalavamane.’ ");
INSERT INTO kud2014_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Eena hipanivilaei, hiwalo, ‘Haidova tamamne?’ Na Yeisu iwalo, ‘Nigele amyahanapuigau ainaena Tamagu hinage nigele amyahanapui. Na omiu ebe amhanapuigau neta Tamagu amhanapui.’ ");
INSERT INTO kud2014_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yeisu yana ve'itao teina vada tapwalolo mwala'ina holanai ive'ive'itadi neta velau dedewaganane vahalinai na tenem ainai nigele teya yaiya Yeisu iya'abi avivini wuwuna yana hauga nigele iyalobai. ");
INSERT INTO kud2014_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yeisu hinage aidiyai iwalo, ‘Mata yalauvehulugomiu na omiu ambeha ahayaigau ta mayami mumuga yababa ammwalowoi. Wuwuna tupwanane ainai yalalau omiu nigele howahowamiu amyalaowa.’ ");
INSERT INTO kud2014_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Eena Yudeyaone hibom aidiyai hiwalo, ‘Yana walone hola ambenalei haugana iwalo, “Tupwanane ainai yalalau omiu nigele howahowamiu na ainai amlaowa”. Yana walo teina ana nuwamasele ebeha ibom i'oiye mwalowoiuyo, awa?’ ");
INSERT INTO kud2014_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Na Yeisu iwalo aulidi iwalo, ‘Omiu duyaena amlalaomane na yau ewaena yalalaomane. Ana nuwamasele ebeha omiu bale'uwena na yau hesi nigele bale'uwena yayalaoma. ");
INSERT INTO kud2014_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Eena yawalo auligomiu ebeha mumuga yababadi aidiyena mata ammwalowoi ebe nigele amyayemidiyegau, neta ainaena yawalo alimiyai ebeha ammwalowoi mayami mumuga yababa.’ ");
INSERT INTO kud2014_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Eena hipanivilaei, ‘Yaiya owa?’ Na hinage iwalo aulidi, iwalo, ‘Teina dova mwalona yawalo mahalava alimiyai'. ");
INSERT INTO kud2014_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ginauli bagibagilidi vehabamiu howahowana na yave'ewaigomiu, na hesi mata nigele wuwuna iya ivetamalegaune yana mumuga dumwaluna, eeta hava dova ainaena yabebenalediwa teina vehabadi taumiya bale'u alimiyai yawalo mahalavaedi.’ ");
INSERT INTO kud2014_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Na yana walo Tamana vehabana nigele hiyanuwamasele. ");
INSERT INTO kud2014_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ta Yeisu iwalo aulidi, iwalo, ‘Howola mata yau Tomowa Moihagu am'abihinigau abo neta ainai amhanapuigau yaiya yau, ta amhanapui ebeha yau nigele yagu nuwatuwuwena yayapaihowa na hesi hava dova Tamagu ive'itagaune aidiyena ya'au'aubabadaedine. ");
INSERT INTO kud2014_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na tauvetamalegaune nigele iyalaulaugabaigau na hesi baidagu apaipaihowa ta hauga maudoina yagu paihowa ainaena ya'abi'abiye yaliyaya.’ ");
INSERT INTO kud2014_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tenem ainai tomowa maudoidi Yeisu yana walo hibenaledi na ainai hiyemidi moiha. ");
INSERT INTO kud2014_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yudeyaowa Yeisu hiyemidiyeiwa iwalo aulidi, iwalo, ‘Ebe yagu ve'ita ammulitaedi omiu agu taumulitao moiha. ");
INSERT INTO kud2014_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Na ainaena hanapu moiha amlobai, na hanapunane ainaena livahi amlobai.’ ");
INSERT INTO kud2014_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Na hibom Yeisu hiwalo auli hiwalo, ‘Ai Abelaham yana huhu, ainaena nigele teya yaiya yana loina ainaena iyatau'auhigai. Na hava yam walo ana nuwamasele haugana uwalo, “Livahi amlobai”?’ ");
INSERT INTO kud2014_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yeisu iwalo, ‘Yawalo moiha alimiyai ebe yaiyadiwo mumugadi yababana, hibom yababanane ipaipaidi, yo yababa yana tupwa ainai himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Wuwuna yana taupaihowa mohili mamaihana nigele yana huhuwone aidiyai iyamiya vateyai, na hesi towaho natuna huhu holanai imiya vateyai. ");
INSERT INTO kud2014_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Omiu hinage dova ebe Yaubada Natunane ilivahigomiu, mata teina ta'i ilivahigomiu moiha. ");
INSERT INTO kud2014_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yahanapuigomiu'o ebeha omiu Abelaham yana huhuwo, na hesi amtowotowoi ebeha am'oiye mwalowoigau, wuwuna nigele yagu ve'ita atemiyai amyamwauwidi. ");
INSERT INTO kud2014_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yau hava dova Tamagu ive'itagau teina alimiyai yawalowalowedine, na omiu hesi hava dova tamamiu ainaena ambebenalediwa hinage ampaipaihowaidine.’ ");
INSERT INTO kud2014_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ta Yeisu yana walo hiyemaiha hiwalo, ‘Ai tubumai Abelaham’. Na hinage Yeisu iwalo, ‘Ebe omiu Abelaham tubunao moiha, mumuganane ammulitaedi. ");
INSERT INTO kud2014_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Na hesi omiu yami nuwatuwu vagadi ainaena ebeha amtowotowoi ta am'oiye mwalowoigau, yau Yaubada yana walo moihadi adi tauwalo mahalava. Na am'ita Abelaham mumugana nigele teya tenem dova. ");
INSERT INTO kud2014_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Omiu tamamiu yana paihowa ammulimulitaedi.’ Na hibom hinage hiwalo, ‘Aee, ai nigele tama budabuda. Ai tamamai ehebo bada, Yaubada.’ ");
INSERT INTO kud2014_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yeisu hinage aidiyai iwalo, ‘Ebe Yaubada ibom tamamiu moiha amvelauwegau wuwuna yau Yaubada ivetamalegauma ta tupwa teina ainai yalalaomane, yau nigele yabom yagu nuwatuwuwena yayalaoma na hesi iya ivevetamalegaumane yana nuwatuwu ainaena. ");
INSERT INTO kud2014_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Hava wuwuna yagu walo alimiyai nigele hiyamasele? Yahanapuiya'o wuwuna nigele yagu walomahalava amyabenale ili'ilimani. ");
INSERT INTO kud2014_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Yahanapuigomiu omiu Tomodulele natunao, ainaena nuwanuwamiu na tamamiu yana nuwatuwu ampaihowaidi. Wuwuna hauga yana abavetuwuni ilau ana higa wau ibom tau'oiye mwalowoi na nigele teya amwaha dumwaluna ainai iyamiyamiya. Hauga maudoina oyamaena i'au'aubabada ta iya yana amwaha moihana eeta iya tau'oyamao tamadi. ");
INSERT INTO kud2014_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Na yau hesi walo moiha alimiyai yawalowalo mahalavaedi, na nigele amyemidiyegau. ");
INSERT INTO kud2014_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Vedova, howahowamiu alimiyena ehebo yaiya mumugagu yababadi iwalo mahalavaedi? Nuwana nigele howahowamiu awa? Na ebe walo moihaena ya'au'aubabada alimiyai, hava vehabana nigele amyayemidiyegaune? ");
INSERT INTO kud2014_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Wuwuna ebe yaiya iya Yaubada ainaena ilaoma, iya Yaubada yana walo ana taubenali ili'ilimani. Na omiu nuwana nigele Yaubada ainaena amyalaoma, neta wuwuna nigele Yaubada yana walowone amyabenaledine.’ ");
INSERT INTO kud2014_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tenem ainai Yudeyao yadi tautaubadaone Yeisu ainai hiwalo, ‘Yama walo mugai ainona moiha bada imahalava'o, wuwuna awalo, owa ehebo tomowa Sameliya, na vi'avi'a alimwai imiyamiya’. ");
INSERT INTO kud2014_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Na Yeisu tautaubadaone iwalo aulidi iwalo, ‘Yau yabom nigele teya vi'avi'a aliguwai, wuwuna Tamagu yave'ahihiyei moiha, na omiu hesi nigele amyave'ahihiyegau. ");
INSERT INTO kud2014_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yau nigele yabom yehagu yaya'abi'abihini, na hesi ehebo Tauloina iya yehagu ana tau'abihini iya i'awa moihaegau. ");
INSERT INTO kud2014_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Yawalo moiha alimiyai ebe yaiya yagu walo imulitaedi moiha iya mata nigele iyamwalowoi.’ ");
INSERT INTO kud2014_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ta Yudeyaone Yeisu hiwalo auli, hiwalo, ‘Ahanapuigo'o moiha ebeha vi'avi'a alimwai imiyamiya, wuwuna Abelaham ahanapuiya'o ebeha iya bada imwalowoi'o, na hinage tauwalo mahalava ahanapuidi ebeha bada himwalowoi'o, na uwalo ebe yaiya yam walo imulitaedi moiha mata nigele iyamwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Yaiya towaho yede owa? Tubumai Abelaham bada imwalowoi'o, ainaena havena utowotowoi ta ebeha umwala'i gabaei. Na hinage tauwalo mahalavao bada himwalowoi'o, na yam nuwatuwu ebeha umwala'i gabaedi awa?’ ");
INSERT INTO kud2014_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Eeta Yeisu aidiyai iwalo, ‘Ebe yau yabom yawalo vetuvehaegau, agu walovetuvehaene neta ginauli awa'awawa, na Tamagu iya iwalowalo vetuvehaegaune, iya amwalo ebeha yami Yaubada. ");
INSERT INTO kud2014_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Omiu nigele Yaubada amyahanapui, na hesi yau yahanapuiya'o, ebe yawalo, “Nigele, yayahanapui”, mata ya'oyama, dova omiu yami oyamaone. Na hesi yahanapuiya'o ta yana walo ya'awa abiyei. ");
INSERT INTO kud2014_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Na tubumiune Abelaham yana yaliyayane ebeha yagu hauga i'ita ta bada i'itaya'o ainaena iyaliyaya mwala'ina.’ ");
INSERT INTO kud2014_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Na Yudeyaone ainai hiwalo, ‘Owa howola nigele ambolimai 50 uyalobai, na uwalo ebeha Abelaham u'itaya'o’. ");
INSERT INTO kud2014_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Na Yeisu iwalo aulidi iwalo, ‘Yawalo moiha alimiyai, ebeha mulitai abo Abelaham itubui na yau bada yamiyamiya’. ");
INSERT INTO kud2014_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Eeta Yudeyaone gaima hivaidi ebeha hi'oiye mwalowoi, na Yeisu aidiyena i'aidawanedi na vada tapwaloloyena imamahalavane. ");
INSERT INTO kud2014_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Teya hauga ainai Yeisu ilaulau amwahai na towaho ehebo ilobai mamehegibugibuna na hilalabahine. ");
INSERT INTO kud2014_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Na ana taumulitaone hi'ita ta Yeisu hipanivilaei, hiwalo, ‘Tauve'ita, yaiya yana yababa ainaena towaho teina mamehegibugibuna na hilalabahine, iya yana yababa bo tamana na hinana yadi yababa?’ ");
INSERT INTO kud2014_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Eeta Yeisu iwalo aulidi, iwalo, ‘Nigele iya yana yababayena, nuwana tamana na hinana, na hesi mamehegibugibuna hilabahi ta ainaena Yaubada yana paihowa wahiwahiyalana tomowa maudoidi hi'ita towahone ainai. ");
INSERT INTO kud2014_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Iya ivetamalegauma yana paihowa tapaihowaidi ahubenaena wuwuna ebe masigili ilaoma nigele teya yaiya howahowana na ipaihowa. ");
INSERT INTO kud2014_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Eena yau hauganane bale'uwai yamiyamiya, yau bale'u ana masele.’ ");
INSERT INTO kud2014_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Walo teina iwalowedi i'ovi na bale'u ihowai na tobatoba ipapaihowaine, eena tobatobane ivai ta towahonane mehenane i'a'abidine, ");
INSERT INTO kud2014_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","na iwalo auli iwalo, ‘Ulau ta Sailowam bwahinane ainai mehemne uuwa’. (Sailowam ana bui Vetamale.) Eeta ilau ta ihuhugune, na mehenane i'itanedine, ta ilau gwaipileuyone. ");
INSERT INTO kud2014_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Na towahonane ana geluwo hi'ita na hiwalo, ‘Teina nuwana iya tau'awa'awanoiwa?’ ");
INSERT INTO kud2014_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Na tupwadi hiwalo, ‘Iya ainaede ta'i’. Na tupwadi hiwalo, ‘Nigele, teya towaho. Na hesi ana oleya bada dova’. Na towahonane iwalo, ‘Yau ainaede’. ");
INSERT INTO kud2014_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Eeta hiwalo, ‘Vedova yede ta mehemwone u'i'itanedine?’ ");
INSERT INTO kud2014_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Na iwalo aulidi iwalo, ‘Ehebo towaho yehanaede Yeisu, tobatoba ipaihowai na mehegu i'abidi, na aliguwai iwalo, “Ulau Sailowam bwahinane ainai mehem uuwa”. Ainaena yalau ta mehegune yauwadi ta ya'i'itanedine.’ ");
INSERT INTO kud2014_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Eena hipanivilaei, hiwalo, ‘Haidova ainaede?’ Na towahonane iwalo, ‘Nigele yayahanapui’. ");
INSERT INTO kud2014_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Yeisu ahubena tapwalolo ainai towahonane mehena tobatobaena i'a'abiye namwanamwadine, neta wuwuna towahonane hilauvaiyama Palisiwone aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Na Palisiwone taumehegibugibuwa hipanivilauyowei, hiwalo, ‘Vedova ta mehemne u'i'itanedine?’ Eena iwalo aulidi iwalo, ‘Yeisu tobatoba ipaihowaidi ta meheguwai i'abi'abiyedi na we'aha ainaena yauuwane, ta meheguwone ya'i'itanedine’. ");
INSERT INTO kud2014_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Na tupwadi Palisiwone hiwalo, ‘Iya taupaihowainane nigele Yaubada ainaena, wuwuna ahubena tapwalolo yana loina nigele iyamulitaei’. Na tupwadi hinage hiwalo, ‘Vedova ta tauyababa ve'ive'ilala wahiwahiyalana teina dova ipapaihowaidine? Nuwana nigele howahowana awa?’ Tenem ainai wahei imahalava aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Na hinage Palisiwone mehegibuginane hipanivilauyowei hiwalo, ‘Na owa vedova yam nuwatuwu iya mehemne i'abiye maseledine vehabana?’ Na iwalo, ‘Iya tauwalo mahalava ehebo’. ");
INSERT INTO kud2014_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Na Yudeya babadaone nigele hiyayemidi ebeha towahonane mamehegibugibuna itutubuine na teina ta'i mehena i'itanedine. Eeta tamanawa yo hinanawa hiyogaedima, ");
INSERT INTO kud2014_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ta hipanivilaedi hiwalo, ‘Ebeha heda teina mehegibugibuna amlalabahine? Na vedova yede ta mehenaone i'itanedine?’ ");
INSERT INTO kud2014_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Eena towahonane tamanawa yo hinawa Palisiwone aidiyai hiwalo, ‘Ahanapuiya'o iya moiha natumai na hinage mehegibugibuna alalabahine, ");
INSERT INTO kud2014_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","na hesi nigele ayahanapui vedova ta mehenane i'itanedine, na hinage yaiya i'abiye namwanamwadine nigele ayahanapui. Ta hola ampanivilaei na ibom vehabana i'aubabada, wuwuna bada imwala'i'o.’ ");
INSERT INTO kud2014_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tamana yo hinana walo teina hi'ataidi wuwuna yadi tautaubadaone aidiyai himeheuhi. Wuwuna tautaubadaone yadi loina himwauwidi ta ebe yaiya Yeisu i'awa Besinanaei iya vada tapwalolowena hisosomanaei. ");
INSERT INTO kud2014_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Teina wuwuna towahonane tamana yo hinana hiwalo, ‘Ibom ampanivilaei wau bada imwala'i'o’. ");
INSERT INTO kud2014_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Eeta taumehegibugibuwa hiyogaeuyowei na hiwalo auli hiwalo, ‘Havena Yeisu uno'ono'owei na Yaubada uno'owei wuwuna iya ililivahigone na neta towahone ahanapuiya'o iya towaho yababana.’ ");
INSERT INTO kud2014_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Na iwalo, ‘Nigele yayahanapui nuwana iya tauyababa bo nigele. Na neta bada yahahanapuine ebeha meheguwone higibu na i'abiye namwanamwadine.’ ");
INSERT INTO kud2014_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Na ainai hiwalo, ‘Hava ipapaihowaine ta mehemwone u'i'itanedine?’ ");
INSERT INTO kud2014_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Na iwalo, ‘Bada yawalo auligomiu'o na nigele alinagu amyabenalei. Hava wuwuna nuwanuwamiu ebeha ambenaliuyoi, nuwana omiu ana taumulitao awa?’ ");
INSERT INTO kud2014_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tenem ainai hinahinabodai na hiwalo, ‘Owa bada ana taumulitaede na ai Mosese ana taumulitao, ");
INSERT INTO kud2014_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","wuwuna bada ahanapuiya'o ebeha Yaubada i'au'aubabada Mosese ainai, na towahone Yeisu nigele ayahanapui havaena ilalaomane’. ");
INSERT INTO kud2014_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Na towahowa aidiyai iwalo, ‘Teina ginauli palipalina wuwuna towahonane mehegu i'abiye namwanamwadi na nigele amyahanapui ebeha havaena ilalaomane. ");
INSERT INTO kud2014_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Na bada tahanapuiya'o Yaubada nigele tauyababa alinadi iyamulimulitaedi, na hesi ebe yaiya Yaubada ive'ahihiyei yo yana nuwatuwu ipaihowaidi, mata Yaubada towahonane alinana imulitaei. ");
INSERT INTO kud2014_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Na bada tahanapuiya'o mugai ta wau nigele teya yaiya tayabenalei ebeha taumehegibugibu iya'abiye namwanamwadi. ");
INSERT INTO kud2014_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ebe towaho teina nigele Yaubada ainaena, mata nigele howahowana ve'ive'ilala teina dova iyapaihowaidi.’ ");
INSERT INTO kud2014_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ta Palisiwone taumehegibugibune hiwawalo auline hiwalo, ‘Owa tauyababa yam hauga heda ainaena ta wau. Ta ebeha uve'itagai yaiya owa?’ Eeta vada tapwalolowena hiheusili ta i'aitulu gabaedine. ");
INSERT INTO kud2014_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Na Yeisu towahowa wasana ibenalei ebeha vada tapwalolowena hiheusiliya'o, ta ibehaei na haugana ilobai iwalo auli iwalo, ‘Yaubada yana Besinana towahona uyemidiyei awa?’ ");
INSERT INTO kud2014_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Na towahowa iwalo, ‘Taubada, yaiya iya ta ainai yayemidi?’ ");
INSERT INTO kud2014_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Na Yeisu iwalo, ‘Towahonane teina ta'i uvinuvinunuine na baidam am'au'aubabadane’. ");
INSERT INTO kud2014_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ta towahowa iwalo, ‘Bada yayemidiyego'o’, na italumiyahiwa ta ainai ipwapwagogone. ");
INSERT INTO kud2014_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Na Yeisu iwalo, ‘Yau bale'uwai bada yalaoma'o ta yaloinaegomiu, ta ebe yaiyadiwo mamehegibugibudi mata hi'itanedi, na yaiyadiwo mehedi hi'ita'itanedi mata higibu’. ");
INSERT INTO kud2014_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ta Palisiwone Yeisu yana walo hibenaledi na hiwalo, ‘Vedova, ebeha ai hinage mehegibugibumai, awa?’ ");
INSERT INTO kud2014_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Na Yeisu iwalo aulidi iwalo, ‘Ebe omiu mamehegibugibumiu mata nigele mumuga yababadi alimiyai hiyamiyamiya, na omiu amwalo, ai mehemai a'itanedi'o, ainaena mata yami mumuga yababadi himiya vateyai’. ");
INSERT INTO kud2014_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yeisu hinage aidiyai iwalo, ‘Yawalo moiha alimiyai ebe yaiya sipi adi abwalu amwahanaena nigele iyaluwu na vali tupwaena imwalaedi'wa, iya neta tau'aivavali na taulauwunu. ");
INSERT INTO kud2014_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Na ebe yaiya sipi yadi amwahaena iluwu iya adi tau'ita avivini moiha, ");
INSERT INTO kud2014_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","wuwuna yadi amwahane ana tau'ita avivini amwahanane mata iho'e ta sipi ana tau'ita avivinine iluwu na yana sipiwone yehadiyena iyogaedi ta alinana hibenalei na himulitaei ta himahalava maseleyai. ");
INSERT INTO kud2014_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Maudoidi himahalava na adi tau'ita avivinine imugai na himulitaei wuwuna alinana hihanapuiya'o na himanahamwei. ");
INSERT INTO kud2014_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Na sipiwone nigele howahowana na vali towaho himulitaei, na hesi mata ainaena hidena, wuwuna alinanane nigele hiyahanapui na hinage nigele hiyamanahamwei.’ ");
INSERT INTO kud2014_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Walo vegevegedi teina Yeisu iwalo mahalavaei aidiyai, na ginaulinane vehabana iwalo aulidi nigele iyamasele hibom aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yeisu hinage iwalo aulidi iwalo, ‘Yawalo moiha alimiyai, yau sipi yadi awa'eda. ");
INSERT INTO kud2014_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Na mugamugaidi tau'ita aviviniwone hilaoma, hiya tau'aivavali na taulauwunu eeta sipiwone nigele alinadi hiyabenaledi. ");
INSERT INTO kud2014_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yau hesi sipiwone yadi awa'eda na ebe yaiya iya aliguwena iluwuma iya mata namwanamwa ilobai, wuwuna hauga bagibagilina hiluwuluwu yo himahamahalava na awahi namwanamwana hilobalobaidi, ");
INSERT INTO kud2014_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","na tau'aivavali yadi paihowa neta hilaoma hi'aivavali yo hi'oiye mwalowoidi yo hinage hi'abiye yababadi, na yau yalaoma tomowa yawahidi namwanamwana mwaumwauna aliguwena hilobai. ");
INSERT INTO kud2014_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","‘Na hinage aidiyai iwalo, 'Yau sipi adi tau'ita avivini namwanamwana wuwuna yawahigu yatalamwei ta yagu sipiwone vehabadi yamwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Na ebe yaiya nigele yana sipiwo na maiha vehabana i'ita'ita avivini, na ebe edewa manimaninina i'ita ilaolaoma sipiwone ilauvehuludi na idena. Na edewanane sipi tupwadi i'oiye mwalowoidi, yo meheuhiyena sipi maudoidi hitaubudebudeyanaedi. ");
INSERT INTO kud2014_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Towahonane yana dena wuwuna wau maiha vehabana ipaipaihowa, na sipiwone iya nigele ainaena, eeta vehabadi nigele iyanuwanuwatuwu. ");
INSERT INTO kud2014_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","‘Yau sipi adi tau'ita avivini namwanamwana, wuwuna yagu sipiwone yahanapuidi na hiya hinage hihanapuigau. ");
INSERT INTO kud2014_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Dova hinage Tamagu ihanapuigau na yau yahanapuiya'o. Ta yau yawahigu bada yatalamwena'o ta yagu sipiwone vehabadi yamwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Tupwadi yagu sipiwone himiyamiya, neta hiya teina ta'i nigele yagu abwaluwai hiyamiyamiya, hiya sipiwone aliguwai yalauvaidima ta ebe alinagu hibenalei na hilaoma aliguwai, na ma'adi geluwo hiyeboda ehebo, na ebe adi tau'ita avivini ehebo ta'i. ");
INSERT INTO kud2014_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tamagu ivelauwegau moiha wuwuna yawahigu yatalamwei ta ebe yamwalowoi, na mulitai yawahigu yalobuyoi. ");
INSERT INTO kud2014_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nigele mata yaiya iyaloinaegau ta yamwalowoi. Yau ta'i yatalamwegau ta yamwalowoi, eena howahowagu yawahigu yavaiuyoi. Wuwuna teina dova Tamagu yana nuwatuwu na hinage yana loina aliguwai.’ ");
INSERT INTO kud2014_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yeisu yana walo teina vehabadi Yudeyaone hibom aidiyai hiveta'eta'e mwala'ina, ta wahei aidiyai imahalava. ");
INSERT INTO kud2014_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Na tomowa bagibagilidi hiwalo, ‘Iya vi'avi'a ainai imiyamiya ainaena i'abiye buwane. Havena yana walo ambenabenaledi.’ ");
INSERT INTO kud2014_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Na tupwadi hiwalo, ‘Teina nigele dova vi'avi'a yana walo, wuwuna vi'avi'a nigele howahowana towaho mehegibugibuna mehena i'abiye maseledi!’. ");
INSERT INTO kud2014_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Bolibolimai haugana ainai na Yelusalem vada tapwalolo mwala'ina abiyemaselena hipaihowai. ");
INSERT INTO kud2014_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Eena Yeisu vada tapwalolo holanai ilowolowouhi, ehebo biliutuhi ainai neta tauwasawasa Solomoni yana biliutuhi. ");
INSERT INTO kud2014_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tenem ainai Yudeyaone Yeisu hitowolo gwaigwaipileyei na hiwalo auline, ‘Owa hauga maudoina nuwamai u'oi'oiye pwanopwano na aiteya hauga ainai abo alimaiyai uwalo mahalava moiha ebeha owa Besinana towahona?’ ");
INSERT INTO kud2014_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Na Yeisu aidiyai iwalo, ‘Bada alimiyai yawalo mahalava'o na hesi nigele amyayemidiyegau. Na hinage paihowadine Tamagu yehanaena yapapaihowaidine aidiyena bada hive'itagau'o, ");
INSERT INTO kud2014_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","na bada ta'i nigele amyayemidiyegau, wuwuna omiu nigele yagu sipiwo. ");
INSERT INTO kud2014_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Na yau yagu sipiwone alinagu hibenabenalei, na hiya hinage yahanapuidi'o ta ainaena himulimulitaegau. ");
INSERT INTO kud2014_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Na yawahi miyamiya ateyaina yamohedi ta nigele mata hiyamwalowoi, eeta nigele mata yaiya nimaguwena iya'waya'wayaidi. ");
INSERT INTO kud2014_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Hiya sipiwone Tamagu imohegau, ainaena nigele teya howahowana na Tamagu nimanaena i'wayai, wuwuna iya ginauli maudoina imwala'i gabaedi. ");
INSERT INTO kud2014_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yau na Tamagu ehebo ta'i.’ ");
INSERT INTO kud2014_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Eeta Yudeyaone hinage gaima hivaidi na ebeha Yeisu hitalai. ");
INSERT INTO kud2014_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Na Yeisu i'itadi ta aidiyai iwalo, ‘Paihowa bagibagilidi na namwanamwadi Tamagu ainaena bada yapaihowaidi'o alimiyai, na vedova ta am'awa yabayababaegaune, ta ebeha gaimaena amtalaigau’. ");
INSERT INTO kud2014_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Na Yudeyaone Yeisu yana walowa hiyamaiha, hiwalo, ‘Nigele ebeha yam paihowa namwanamwadi vehabadi atalaigo, na hesi yam walo yaiyai vehabadi atalaigo, wuwuna owa towaho mohili na uwalo ebeha owa Yaubada’. ");
INSERT INTO kud2014_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Na Yeisu hinage aidiyai iwalo, ‘Loina lelelelena yami Buki Ve'ahihi holanai iwalo, “Bada yawalo'o Ebeha omiu yaubadao”. ");
INSERT INTO kud2014_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Na tahanapuiya'o ebeha yana walomahalava maudoina nigele oyama, na Buki Ve'ahihi tenemdova yana walomahalava ebeha hiya Yaubada yana walo imohedi'o i'awa yaubadaedi. ");
INSERT INTO kud2014_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Eeta hava wuwuna haugana yawalo, ebeha yau Yaubada Natuna, na yagu walone vehabana amnuwatuwu ebeha walo awawa. Na yau ihanapuigau ta ivetamalegauma bale'uwai yalaoma na yana paihowa yapaihowaidi. ");
INSERT INTO kud2014_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Eeta am nuwatuwui ebe yau Tamagu yana paihowa nigele yayapaihowaidi havena amyemiyemidiyegau. ");
INSERT INTO kud2014_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Na hesi ebe amnuwatuwui paihowadine yapaipaihowaidi na nigele amyayemidiyegau, bada yede paihowadiyaone amyemidiyedi na tenem ainaena hi'abiye gwaipilegomiu na amhanapuigau ebeha yau Tamagu aliguwai imiyamiya na yau hinage ainai yamiyamiya.’ ");
INSERT INTO kud2014_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tenem ainai Yudeyaone hitowoi na ebeha hi'abi avivini ta nigele howahowadi, eeta Yeisu ilalaugabaidine. ");
INSERT INTO kud2014_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ilau Yolidani bwahi igeyo'awauyoi, neta Yoni yana aba'abiye bapitaiso mugai tupwanane ainai na tenemai imimiyane, ");
INSERT INTO kud2014_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","na tenem ainai tomowa bagibagilidi ainai hilaoma na hibom hiwalo, ‘Yoni nigele teya paihowa wahiwahiyalana iyapaihowaidi, na hesi Yoni yana walomahalava towaho teina vehabana moihana imahalava'o’. ");
INSERT INTO kud2014_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Eeta tupwanane ainai tomowa bagibagilidi Yeisu hiyemidiyei. ");
INSERT INTO kud2014_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ehebo towaho lovalovalana yehanaede Lasalo. Lasalo iya Betani towahona na hinage nuhunao bwau, neta Meli na Malida baidana himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Na Melinane iya howola mata Yeisu aena iyewoloidi yo vahunaena iba'ilidi. ");
INSERT INTO kud2014_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Na haugana nuhudine Lasalo ilovala, na nuhunaone wasa hivetamalei Yeisu ainai hiwalo, ‘Bada, am geluwo Lasalo ilovala’. ");
INSERT INTO kud2014_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ta Yeisu wasane ibenalei na iwalo, ‘Lovala teina ainona ebeha Lasolo mata nigele yana hauga mwalowoi na hesi Yaubada yana wahiyala tomowa maudoidi hi'ita na Yaubada hiwalo vetuvehaeyei na hinage Natuna hiwalo vetuvehaeyegau’. ");
INSERT INTO kud2014_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Na Yeisu Malida yo tahinane na hinage nuhudine Lasalo ivelauwedi mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ta hauganane wasa ibenalei ebeha Lasalo ilovala, eeta tupwanane ainai ahubena bwau imimiyauyone. ");
INSERT INTO kud2014_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ahubena bwau hi'ovi na ana taumulitao aidiyai iwalo, ‘Teina ta'i tawuyo Yudeya’. ");
INSERT INTO kud2014_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Na ana taumulitaone Yeisu ainai hiwalo, ‘Bada, havena talaulau tupwanane ainai, wuwuna Yudeyaone howola ta'i nuwanuwadi ebeha gaimaena hitalaigo’. ");
INSERT INTO kud2014_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Na Yeisu aidiyai iwalo, ‘Ahubena maudoina ainai neta malatomtomwena ana higa ilavilavi, na ebe yaiya ahubenaena ilau mata nigele iyalautupatupa wuwuna bale'u ana masele imiyamiya, ");
INSERT INTO kud2014_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","na hesi ebe masigili ainai ilau neta mata ibe'u, wuwuna nigele masele ainai iyamiyamiya.’ ");
INSERT INTO kud2014_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yana nuwatuwu teina iwalowedi i'ovi na iwalouyo iwalo, ‘Ada gelune Lasalo bada i'eno i'iwahi'o ainaena talau na yavanoi’. ");
INSERT INTO kud2014_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Na ana taumulitaone hiwalo, ‘Bada, unuwatuwui ebeha i'eno i'iwahi neta mata inamwanamwa’. ");
INSERT INTO kud2014_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Na Yeisu yana walo ainona ebeha Lasalo bada imwalowoi'o, na hesi ana taumulitaone yadi nuwatuwu ebeha moiha i'eno i'iwahi'o vehabana iwalowalone. ");
INSERT INTO kud2014_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Eeta Yeisu aidiyai iwalo mahalava moiha, iwalo, ‘Lasalo bada imwalowoi'o, ");
INSERT INTO kud2014_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","na yayaliyaya wuwuna yana mwalowoine nigele ainai yayamiyamiya na ainaena yagu paihowa am'ita na amyemidiyegau. Inamwanamwa bada talau na ta'ita.’ ");
INSERT INTO kud2014_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Na Tomasi iya yehana himwauwi patubwau, i'apuhini na ana geluwo aidiyai iwalo, ‘Badagi yada tauve'ita baidada talau na ebe imwalowoi ita hinage tamwalowoi’. ");
INSERT INTO kud2014_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Haugana Yeisu ilaoma Betani vahalinai wasa ibenalei ebeha ahubena vehopali i'ovi'o aidiyai Lasalo himwauwiya'o magaiyai. ");
INSERT INTO kud2014_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani na Yelusalem nigele amwaha daodao, ");
INSERT INTO kud2014_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","eeta Yudeyaone bagibagilidi mayadi atemuyamuya hilaoma ebeha Malida na Meli nuwadi tupwana hi'abiye namwanamwadi nuhudine vehabana. ");
INSERT INTO kud2014_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Na Malida wasa ibenalei ebeha Yeisu ilalaoma, eeta imahalava Yeisu habi lawenama, na tahinane Meli vadai imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Malida Yeisu ilobai na ainai iwalo, ‘Bada, ebe owa mwalona teinai umiyamiya, nigele mata nuhugune iyamwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Na yahanapuiya'o ebeha hauga teina ebe hava vehabana Yaubada ainai u'awanoi mata imohego ta'i.’ ");
INSERT INTO kud2014_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Eeta Yeisu Malida ainai iwalo, ‘Nuhumne mwalowoiyena mata itowolouyo’. ");
INSERT INTO kud2014_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Na waihiune iwalo, ‘Ehe, yahanapuiya'o ebeha mulitai hauga yana aba'ovi ainai mwalowoiyena abo itowolouyo’. ");
INSERT INTO kud2014_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Na Yeisu iwalo, ‘Yau towolouyo wuwuna yo hinage yawahi moiha. Ainaena ebe yaiya iyemidiyegau, na haugana imwalowoi mata yawahi miyamiya vateyaina ilobai. ");
INSERT INTO kud2014_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na ebe yaiyadiwo hiya mayawahidi hiyemidiyegau mata nigele hiyamwalowoi. Na owa vedova? Yagu walo teina vehabana uyemidiyegau bo nigele?’ ");
INSERT INTO kud2014_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Na Malida iwalo, ‘Bada, yayemidiyego ebeha owa Besibesinanam, Yaubada Natuna bale'uwai ulaoma’. ");
INSERT INTO kud2014_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Malida yana walo tuluhanai ilau gwaipile vadai na tahina Meli ainai iwalo dawani, iwalo, ‘Tauve'itawa bada ilaoma'o na ipanipanivilaego’. ");
INSERT INTO kud2014_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Haugana Meli ibenalei, itowolo mwayamwayau ta imamahalavane habi itana. ");
INSERT INTO kud2014_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Na Yeisu howola nigele iyalaoma dalavai, na hesi tupwanane ainai Malida ilolobaiwa imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Na Yudeyaone hiya Meli baidanao vadai hidoudou, Meli yana lau hi'ita na yadi nuwatuwu ebeha ilalau magaiyai habi dou, ta tuluhanaena hilalaune. ");
INSERT INTO kud2014_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Meli tupwanane ainai imahalava ta Yeisu i'ita, na mehenai ipwagogo aitulu na ainai iwalo, ‘Bada, ebe owa teinai umiyamiya mata nigele nuhugune iyamwalowoi’. ");
INSERT INTO kud2014_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Na tenem ainai Yeisu Meli yana dou i'ita na hinage Yudeyaone hiya baidanao hilaoma yadi dou hinage i'itadi na atena imuya, na nuwana iyababa mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Na aidiyai ipanivila iwalo, ‘Havaidova ainai ana magaine?’ Na hiwalo, ‘Bada, ulaoma ta ave'itago’. ");
INSERT INTO kud2014_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Na Yeisu hinage idou. ");
INSERT INTO kud2014_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Na Yudeyaone Yeisu yana dou hi'ita, eeta hiwalo, ‘Moiha ana gelune ivelauwei mwala'ina’. ");
INSERT INTO kud2014_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Na tupwadi aidiyena hiwalo, ‘Yeisu iya tauwahiyala, na howahowana mehegibugibudi mehedi i'abiye maseledi awa? Na vedova ta nigele iyalaoma lavinai na ana gelune iyalauyeyawahaine ta havena imwalomwalowoi.’ ");
INSERT INTO kud2014_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yeisu mayana nuwayababa na ihae magai ainai, na magaine bada duluva ta ana awa'edane gaima mwala'ina ainaena hive'eno'auhine. ");
INSERT INTO kud2014_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Eena Yeisu boda aidiyai iwalo, ‘Gaimane amvaivehulu’. Na Malida iya taumwalowoiwa nuhunane iwalo, ‘Bada, bada ibova'o, wuwuna ahubena vehopali bada hi'ovi'o ainai himwamwauwine’. ");
INSERT INTO kud2014_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Na Yeisu Malida ainai iwalo, ‘Wau yawalo mahalava alimwai ebeha ebe uyemidiyegau mata Yaubada yana wahiyala abo u'ita’. ");
INSERT INTO kud2014_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Eeta gaimane hivaivehulu na Yeisu i'ita hae na i'awanoi, iwalo, ‘Tamagu yauwedo mwala'ina, wuwuna hauga maudoina alinagu ubenabenaledi. ");
INSERT INTO kud2014_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Na teina ya'awa'awanoine tomowa teina vehabadi ta ebe yam wahiyala hi'ita na hiyemidi moiha ebeha owa uvetamalegaumane.’ ");
INSERT INTO kud2014_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Eeta yana awanoi tuluhanai alinana mwala'ina iyoga iwalo, ‘Lasalo, umahalavama!’ ");
INSERT INTO kud2014_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Na taumwalowoiwa ma'ana huma imamahalavamane, wuwuna nimana yo aena na hinage maninane ale'owena hihuma, eena boda iwalo aulidi, iwalo, ‘Amlivahi vehulu na am'abigabaei ta ilau’. ");
INSERT INTO kud2014_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tenem ainai Yudeyaone Meli ana taubo'ewone Yeisu yana paihowa hi'ita, na bagibagilidi hiyemidiyei moiha, ");
INSERT INTO kud2014_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","na hesi tupwadi nigele hiyayemidiyei, ta hilau gwaipile Palisiwone aidiyai hiwalo mahalava hava dova hi'itaya'o Yeisu ipapaihowaine. ");
INSERT INTO kud2014_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ta Palisiwone na taupwaoliwo mayadi babadao maudoidi himiya ahaidi na hiwalo, ‘Towahone hava ainai mata tapaihowai? Wuwuna paihowa wahiwahiyaladi ipaipaihowaidi. ");
INSERT INTO kud2014_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Na ebe nigele hava ainai tayapaihowai mata tomowa maudoidi ainai hiyemidi na Lomaone yadi loina imahalava ta yada vada tapwalolo na hinage yada boda maudoidi hi'abiye yababadi.’ ");
INSERT INTO kud2014_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Na ehebo aidiyena yehanaede Kayapasi iya bolimai tenem ainai taupwaoli yadi taubada mwala'ina, ana geluwone iwalo aulidi iwalo, ‘Omiu ta'i nuwapwanopwanomiu! ");
INSERT INTO kud2014_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ainaena nigele amyanuwamasele ebeha ginauli namwanamwana alidai imahalava neta ehebo towaho imwalowoi tomowa maudoida vehabada. Na nigele ana ita namwanamwana ebe ita Yudeyaone yada boda hi'abiye yababa.’ ");
INSERT INTO kud2014_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Na Kayapasi walo teina i'a'ataidine nigele iya yana nuwatuwuwena, na hesi bolimai tenem ainai iya taupwaoli yadi taubada mwala'ina. Ainaena hauga tenem ainai iwalo mahalava howola abo Yeisu mata imwalowoi Yudeyaone bodadi vehabadi. ");
INSERT INTO kud2014_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Na nigele ebeha Yudeyaone hiya vehabadi na hesi tupwa maudoidi aidiyai Yaubada yana tomowao ilaugogoidima ta hiveboda ehebo. ");
INSERT INTO kud2014_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ahubenanane tenem ainai tauloinaone yadi loina himwau na ebeha Yeisu hi'oiye mwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tenem ainai Yeisu nigele Yudeyaone mehediyai iyalowolowouhi, eeta ilaugabaidi ta ilau nu'ula papalinai ehebo dalava yehanaede Ipileim ainai, na tenemai ma'ana taumulitao himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Na hauganane ainai Yudeyaone yadi Buidi'wa guyauna ana hauga muhamuhana ta tomowa bagibagilidi yadi dalavaena hihae Yelusalem habi abiye maseledi abo mulitai Buidi'wa hipaihowai. ");
INSERT INTO kud2014_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tenem ainai Yeisu hibehaei, na yadi behane ainai vada tapwalolo vahalinai hitowotowolo na hibom aidiyai hiwalo auliyoidi hiwalo, ‘Vedova yami nuwatuwu? Moiha towahonane nigele mata iyalaoma guyau teina ainai awa?’ ");
INSERT INTO kud2014_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Taupwaoliwo yadi babadao na hinage Palisiwone tomowa aidiyai hiloina neta ebe teya tupwa ainai Yeisu hilobai hiwalo mahalava mwayamwayau babadaone aidiyai ta Yeisu hi'abi avivini. ");
INSERT INTO kud2014_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ahubena 6 hiha'waha'wana na Buidi'wa guyauna hipaihowai, na Yeisu ilau Betani Lasalo yana dalavai, iya mwalona mwalowoiyena Yeisu i'abiye towolouyoine. ");
INSERT INTO kud2014_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Na nemai ai'ai hilauliga Yeisu vehabana, na Malida ilauhuwa, ta Lasalo yo Yeisu mayana bodao himiyagogoi ta hi'ai'ai. ");
INSERT INTO kud2014_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Na Meli woloi dova oiwaga, ana maiha mwala'ina, ivai ta Yeisu aenai ihihiwaine. Mulitai abo Meli ipwagogo ta vahunaena Yeisu aena ibaba'ilidine. Na woloiwa panena mwala'ina ainaena vadane ilau'auhi. ");
INSERT INTO kud2014_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Eena Yudasa Isakaliyota, ibom ehebo Yeisu ana taumulita yo hinage iya mata mulitai Yeisu i'alomagigiyei inuwanuwatuwu ta iwalo, ");
INSERT INTO kud2014_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","‘Hava vehabana ta woloine nigele iyagimwalaei ta ana maiha dova 300 kina iyavai ta tauwewelohe iyahaguidine?’ ");
INSERT INTO kud2014_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yudasa yana walo nigele teina walo moiha ebeha tauwewelohe vehabadi, na hesi ibom vehabana, wuwuna iya tau'aivavali ehebo, na hinage Yeisu mayana taumulitao yadi mane ana tau'ita avivini, na manenane ainaena i'ai'aivavali. ");
INSERT INTO kud2014_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Eeta Yeisu iwalolau Yudasa ainai iwalo, ‘Badagi, havena waihiu teina u'ulu'ulumiyanei. Wuwuna hava teina aliguwai ipapaihowaine neta agu mwau magai vehabana. ");
INSERT INTO kud2014_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Na tauwewelohe uwawalowedine hauga maudoina vahalimiwai mata himiyamiya, na yau hesi nigele hauga daodaona mata baidamiu tayamiyamiya.’ ");
INSERT INTO kud2014_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ta Yudeya bodadi Yeisu wasana hibenalei ebeha Betani ainai imiyamiya, ta dalavanane ainai hilalaune. Yadi lau wuwuna ebeha nuwanuwadi Yeisu hi'ita, yo hinage Lasalo hi'ita, ibom mwalowoiyena Yeisu yana walowena i'abiye towolone. ");
INSERT INTO kud2014_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Tenem ainai Lasalo hi'i'itane na Yudeya bagibagilidi yadi taumugaiwo yadi loina hita'wata'wataedi na Yeisu ibom hiyemidiyei, eeta taupwaoli mwalamwala'idi hiloina toyawa ta ebeha Lasalo hi'oiye mwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","I'ahubena na boda mwala'ina hilaoma Buidi'wa guyauna ainai ta Yeisu wasana hibenalei ebeha ilalaoma Yelusalem. ");
INSERT INTO kud2014_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Eeta luwuluwu hivaidi ta himahalava habi lauvaina na hiwuiwui alinadi mwala'ina hiwalo: ‘Hosana! Ano'owego Bada! Yaubada yehanaena ulaoma uvetauloina mwala'ina Isileli alimaiyai.’ ");
INSERT INTO kud2014_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Na Yeisu lagulagu yehana ase ainai igelu ta ilaulau, dova mwalo Buki Ve'ahihi ainai iwalo mahalava iwalo: ");
INSERT INTO kud2014_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","‘Saiyoni dalava didigana tomowamiu havena ammehemeheuhi. Teina hauga yami tauwasawasa bada iluluwuwa alimiyai, lagulagu ase yauyaubona ainai igelu.’ ");
INSERT INTO kud2014_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Hauganane tenem ainai ana taumulitao nigele walone vehabana hiyanuwamasele, na hesi Yeisu yana towolouyo wasawasana abo nuwadiyena ihae neta Buki Ve'ahihi hilelelelewa ainona imamahalavane. ");
INSERT INTO kud2014_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Eena tupwadi mwalona mehediyai Yeisu Lasalo magaiyena iyogaei na mwalowoiyena itowolouyo, bada hilao'o adi geluwo aidiyai, ta wasanane hiwalo mahalavaei amwaha daodaowai. ");
INSERT INTO kud2014_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tenem ainai Yudeya bagibagilidi Yeisu yana paihowa wahiwahiyalana wasana hibenalei, Eeta hilaoma habi itana. ");
INSERT INTO kud2014_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Eeta Palisiwone hibom aidiyai hiwalo, ‘Am'ita, yada wahiyala bada i'ovi'o, wuwuna tomowa maudoidi Yeisu yana boda aidiyai hilaulau’. ");
INSERT INTO kud2014_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Guyaune ainai tupwadi Gilisiwone ahi'ahipudiyai himiyamiya na hiya habi tapwalolo ta hihae Yelusalem Buidi'wane guyauna ainai. ");
INSERT INTO kud2014_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Na taumiya Gilisi mayadi panivila hilau Pilipi ainai. Na Pilipi iya Bedesaida towahona, neta Galili tupwanai. Eeta hilau hipanivilaei ebe Yeisu hi'ita. ");
INSERT INTO kud2014_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Na Pilipi ilau ta Andulu ainai iwalo mahalava ta hitau bwau Yeisu ainai hilaoma ta taumiya Gilisi yadi nuwatuwu hiwawalo mahalavaeine. ");
INSERT INTO kud2014_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ta Yeisu Gilisiwone yadi walo iyemaiha iwalo, ‘Hauga bada imahalava'o na Tomowa Moihagu yagu wasawasa yalobai. ");
INSERT INTO kud2014_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Yawalo moiha alimiyai, ebe patu bale'u ainai ta'umai, mulitai bale'u holanai ipwaha, na holanaena mata i'ini yo i'aino namwanamwa yo mwala'idi. ");
INSERT INTO kud2014_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Omiu dova hinage patu ebe yawahimiu amnuwavidi mata amvetaudawanidi na ebe yawahimiu amtalamwedi, hauga ilalaoma ainai yawahi miyamiya vateyaina mata amlobai. ");
INSERT INTO kud2014_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ainaena ebe yaiya nuwanuwana na aliguwai ivetaupaihowa, mugai imulitaegau, yo hinage ebe yaiya vehabagu ivetau paihowa Tamagu i'awa namwanamwaei.’ ");
INSERT INTO kud2014_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","‘Hauga teina ainai nuwagu ivitai mwala'ina, ta vedova mata yagu awa'awanoine? Ta vitai teina ainai Tamagu ivaivehulugau. Nuwana havena tenem dova ya'awa'awanoi, wuwuna vitai teina iya vehabana yalalaomane. ");
INSERT INTO kud2014_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Na hesi ya'awanoi na Tamagu ainai yawalo, ‘Tamagu, yeham u'abihini!’. Eena ehebo alina galewaena hibenalei, iwalo, ‘Yehagu bada ya'abihiniya'o na mulitai abo ya'abihiniyoi’. ");
INSERT INTO kud2014_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Na bodaone tenem ainai hitowotowolo, alinane hibenalei ta hiwalo, ‘Tutu idagudagugune’. Tupwadi hiwalo, ‘Nigele, tausagenawasa hesi ainai i'au'aubabadane’. ");
INSERT INTO kud2014_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Mulitai Yeisu aidiyai iwalo, ‘Alinane ambebenaleine nigele yau vehabagu na hesi omiu vehabamiu. ");
INSERT INTO kud2014_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Hauga teina bada imahalava'o yo tauyababa bale'uwai himiyamiya Yaubada iloinaedi, yo hinage bale'u teina ana tauloina Tomodulele mata igabaei aituluwei. ");
INSERT INTO kud2014_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Na yau bale'uwena hi'abihinigau aiwa ainai, ta tomowa maudoidi yaniulidima aliguwai.’ ");
INSERT INTO kud2014_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Eeta tenem dova Yeisu ive'itadi, vedova yana mwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Bodaone yana walo hibenalei ta hiyemaiha, hiwalo, ‘Yama Buki Ve'ahihi iwalo mahalava ebeha Yaubada yana Besinana miyamiya vateyaina, na vedova ta uwalo mata Towahonane hi'abihini? Yaiya teina Towaho?’ ");
INSERT INTO kud2014_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yeisu iwalo, ‘Hauga ubwa'ubwana ainai masele alimiyai imiyamiya ta teina hauga maselene ainai amlau. Wuwuna ebe yaiya guguyou ainai ilau mata nigele amwaha iya'ita lobai. ");
INSERT INTO kud2014_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Teina haugane masele alimiyai imiyamiya, ta maselene amyemidiyei, omiu masele natunao.’ Yeisu yana walo teina i'ataidi na ilaugabaidi ta aidiyena i'a'aidawanine. ");
INSERT INTO kud2014_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yeisu bada ve'ive'ilala bahudi ive'itadi'o na bada ta'i nigele hiyayemidi. ");
INSERT INTO kud2014_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ainaena dova tauwalo mahalava Aisaya mwalona Buki Ve'ahihi ainai iwawaloweiwa, iyemala moiha'o, haugana iwalo: “Bada, wasanane awalo mahalavaena'o, na nigele teya yaiya iyayemidiyedi? Yam wahiyala bada hi'itaya'o na nigele hiyayemidi.” ");
INSERT INTO kud2014_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Na hibom nigele hiyayemidi wuwuna Aisaya hinage Buki Ve'ahihi ainai iwalo mahalava, iwalo: ");
INSERT INTO kud2014_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","‘Yaubada bada mehedi i'abiye gibudi'o, yo hinage yadi nuwatuwu i'abi auhidi'o, Eeta nigele howahowana ta mehediyena hi'itadi, na nigele howahowadi yadi nuwatuwu ainaena hanapu hivai, na nigele howahowadi hi'ita gwaipilema aliguwai ta ebe ya'abiye namwanamwadi.’ ");
INSERT INTO kud2014_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaya walo i'ataidi wuwuna Besinana yana wasawasa i'ita mugaiyedi'o, eeta vehabana iwalo mahalavaedi. ");
INSERT INTO kud2014_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Tenem ainai Yudeyaone adi taumugaiwo tupwana bagibagilidi Yeisu hiyemidiyei, na nigele hiyawalo mahalava, wuwuna Palisiwone himeheuhedi, mata dova vada tapwalolowena hivaivehuludi. ");
INSERT INTO kud2014_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Hiya nuwanuwadi hino'owedi ainaena Yaubada nigele nuwadi. ");
INSERT INTO kud2014_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yeisu boda aidiyai iwalo mahalava iwalo, ‘Ebe yaiyadiwo omiu amyemidiyegau, agu tauvetamale hinage amyemidiyei. ");
INSERT INTO kud2014_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Na yaiyadiwo omiu am'itagau'o, agu tauvetamalene bada am'itaya'o. ");
INSERT INTO kud2014_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yau maseleyede teina yalaoma bale'uwai ta ebe yaiyadiwo amyemidiyegau nigele hinage guguyou ainai amyamiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","‘Na ebe yaiya alinagu ibenalei na nigele iyamulitaedi, nigele mata yababa vehabana yayalauvetalaei. Wuwuna yau yalaoma nigele habi lauvetala na hesi tomowa habi livahidi. ");
INSERT INTO kud2014_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Eeta ebe yaiya owa uta'wata'wataegau yo hinage yagu walo uta'wata'wataedi, hauga yana aba'ovi ainai loina ulobai, nigele aliguwena na hesi yagu walowo aidiyena mata ulobai. ");
INSERT INTO kud2014_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Wuwuna walowone nigele yagu nuwatuwuwena, na hesi agu tauvetamalene hava dova ivenuwamwauwegauwa yawalo mahalava alimiyai. ");
INSERT INTO kud2014_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na yana venuwamwau yahanapuiya'o yawahi miyamiya vateyaina ainai imiyamiya. Ainaena hava Tamagu yana venuwamwau aliguwai teina dova yawalowalowedine.’ ");
INSERT INTO kud2014_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Bada hauga iu'iuna na Buidi'wa guyauna ana ahubena ebe hipaihowai, ta Yeisu ihanapuiya'o bada yana hauga imamahalava na bale'u teina ilaugabaei na iwuyo Tamana ainai. Hesi Yeisu yana bodao i'atemuyamuyaedi mwala'ina, hauga yana abavetuwuni ta ilaoma yana aba'ovi. ");
INSERT INTO kud2014_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Na Tomodulele bada Yudasa ainai iluwu'o ta ivenuwamwauwena'o ebeha Yeisu ihuhulaei. Yudasa iya Saimoni Isakaliyota natuna. Eeta yadi ai ainai ");
INSERT INTO kud2014_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yeisu bada ihanapuiya'o ebeha Yaubada ginauli maudoidi imohena'o ta ibom iloina, yo hinage ihanapuiya'o iya Yaubada ainaena ilaoma yo hinage mata Yaubada ainai ilau gwaipile. ");
INSERT INTO kud2014_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ainaena yadi aba'aiyena Yeisu itowolo ta ana luwuluwu ivai vehuludi na tawelo ivai ta ilau tulituliyei. ");
INSERT INTO kud2014_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Na bwahi ihiwai gaeba mwala'ina ainai na ivetuwuni ta ana taumulitao aedi iuwadi na mulitai tawelowa ilalau tulituliyeiwa ainaena aedi iba'ilidi. ");
INSERT INTO kud2014_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Na haugana Yeisu ilaoma Saimoni Pita ainai, Pita iwalo, ‘Bada, havena aegu uwuwawuwadi’. ");
INSERT INTO kud2014_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Na Yeisu iwalo, ‘Nigele uyahanapui hava wau yapaipaihowaidi alimwai na hesi howola abo uhanapuidi’. ");
INSERT INTO kud2014_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Na Pita Yeisu ainai iwalo, ‘Havena hinage teya hauga aegu uuwauwadi.’ Eena Yeisu Pita yana walo iyemaiha, iwalo, ‘Ebe nigele aem yayauwadi owa nigele augelu’. ");
INSERT INTO kud2014_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Eeta Saimoni Pita italam, iwalo, ‘Bada, ausala. Na hesi havena ae'a'avagu, na nimagu yo vahugu uwuwadi’. ");
INSERT INTO kud2014_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Na Yeisu iwalo, ‘Ebe yaiyadiwo omiu bada amhugu'o, howahowana ae'a'avamiu am'uwadi na ainaena taumiu maudoina imasele. Bada omiu ammasele'o, na hesi nigele maudoimiu.’ ");
INSERT INTO kud2014_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yeisu bada ihanapu mugaiyena'o yaiya iya howola abo ihuhulaei, eeta iwalo, ‘Nigele maudoimiu amyamasele’. ");
INSERT INTO kud2014_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Eeta aedi iuuwadi'o ta ana luwuluwu ili'wauyoi ta imiyauyo na aidiyai i'aubabada, iwalo, ‘Amhanapuiya'o hava yapaipaihowaine alimiyai? ");
INSERT INTO kud2014_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Omiu amyogaigau'o ebeha yau Tauve'ita, na hinage yami Bada, ta neta walo moiha. ");
INSERT INTO kud2014_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Yau yami Bada yo hinage Tauve'ita na bada aemi yauwadi'o, ainaena omiu amve'ao'aonaegau ta hinage ami geluwo aedi amuwadi, ");
INSERT INTO kud2014_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","dova hava teina yave'ive'itaedi alimiyai amve'ao'aonaedi ta ampaihowaidi ami geluwo aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Na yawalo moiha alimiyai mata nigele teya taupaihowa yana taubada iyadi'wai, yo nigele mata teya tauyewasa ana tauvetamale iyataudi'wai. ");
INSERT INTO kud2014_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ainaena ve'itao teina amhanahanapuidi na ebe ampaipaihowaidi mata awanamwanamwa amlobaidi. ");
INSERT INTO kud2014_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","‘Ginauli teina nigele ebeha maudoimiu vehabamiu yayawalowalo, na hesi hiya yavesinuwaedi'o vehabadi yawalowalone, na Buki Ve'ahihi yana walomahalava teya towaho vehabana iwalo: “Towaho teina iya ai'ai yamohei, itaugwaipile ta ive'alehaegau.” ");
INSERT INTO kud2014_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","‘Ginaulidine teina alimiyai yawalo mahalavaedi'o mulitai abo himahalava, ta ebe haugana himahalava amyemidiyegau ta'i. ");
INSERT INTO kud2014_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","‘Moiha, mulitai abo yavetamalegomiu boda aidiyai na ebe yaiya i'abiye yaliyayagomiu, neta yau i'abiye yaliyayagau na ebe yaiya i'abiye yaliyayagau agu tauvetamalene i'abiye yaliyaya.’ ");
INSERT INTO kud2014_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yeisu ginauliwone teina iwalowedi'o ta nuwana ivitai mwala'ina, eeta ana taumulitao aidiyai iwalo mahalava iwalo, ‘Yawalo moiha alimiyai ehebo alimiyena mata ihuhulaegau’. ");
INSERT INTO kud2014_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Na ana taumulitao maudoidi hibom hivinuvinunuyoidi, ta nuwadi ipwanopwano mwala'ina. Wuwuna yana walo ana maselene nigele hiyahanapui. ");
INSERT INTO kud2014_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Na ehebo ana taumulita, ibom Yeisu ana gelu moiha iduivahali Yeisu ainai, ");
INSERT INTO kud2014_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","na Saimoni Pita nimanaena iwalo, ‘Upanivilaei yaiya vehabana iwalowalone’. ");
INSERT INTO kud2014_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Eeta iduivahali ili'ilimani Yeisu ainai na talinanai iwalohimhim, iwalo, ‘Bada, yaiya vehabana uwalowalone?’ ");
INSERT INTO kud2014_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ta Yeisu iwalo auli, iwalo, ‘Mata beledi yatomwahi ta yayebuta na yamohei, iya neta towahonaede’. Eeta Yeisu beledine iu'iuna ivai ta iyebuta ta Yudasa imomoheine, Yudasa iya Saimoni Isakaliyota natuna. ");
INSERT INTO kud2014_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Hauganane Yudasa beledi ivai Tomodulele iluwu ainai. Ta Yeisu Yudasa iwalo auli, ‘Umwayamwayau ta yam nuwatuwu upaihowai.’ ");
INSERT INTO kud2014_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Na hiya Yeisu baidanao hi'a'aine nigele teya yaiya aidiyena iyahanapui hava Yeisu vehabana iwalowalone. ");
INSERT INTO kud2014_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudasa iya yadi mane ana tau'ita'ita avivini, eeta yadi nuwatuwu ebeha Yeisu iwalo auli ta Yudasa ilalau yadi guyau pwalawana iyemaihadi, bo ilalau tupwana mane tauwewelohe imohedi. ");
INSERT INTO kud2014_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Eeta Yudasa belediwa i'ai, na mwayamwayauwena imahalava maseleyai. Neta bada imasigili'o. ");
INSERT INTO kud2014_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudasa bada ilaugabaidi'o, na Yeisu iwalo aulidi, iwalo, ‘Yagu hauga bada imahalava'o na mata yau Tomowa Moihagu yagu wasawasa imahalava yo Yaubada yana wasawasa hinage yayemahalava. ");
INSERT INTO kud2014_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na ebe aliguwena Yaubada yana wasawasa i'abiye mahalava, yau hinage Natuna mata i'abiye wasawasaegau ta yagu wasawasane i'abiye mahalava mwayamwayauwei. ");
INSERT INTO kud2014_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","‘Natuguwao, hauga iu'iu alilina ainai yau baidamiu, na mulitai ambehaegau, dova mwalona Yudeyaone aidiyai yawalo mahalava'o, yawalo, tupwanane ainai yalaulaune omiu nigele howahowamiu na ainai amlaowa. ");
INSERT INTO kud2014_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","‘Ainaena omiu hinage teina hauga loina vauvauna yamohegomiu, neta atemiyena amvelau ehebo ehebo ainai, dova yau yavevelauwegomiune, ");
INSERT INTO kud2014_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ta yami velau ainaena tomowa bodadi hihanapui ebeha omiu agu taumulitao.’ ");
INSERT INTO kud2014_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ainaena Saimoni Pita Yeisu ipanivilaei, iwalo, ‘Bada, havaidova mata ulalau?’ Ta Yeisu iwalo, ‘Nigele howahowam na hauga teina ainai umulitaegau, na hesi howola abo umulitaegau tupwanane ainai’. ");
INSERT INTO kud2014_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Eena Pita Yeisu ipanivilaei, iwalo, ‘Bada, hava wuwuna teina hauga havena yamulimulitaego? Bada yatalam'o ta vehabam howahowana yamwalowoi.’ ");
INSERT INTO kud2014_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ta Yeisu Pita ainai iwalo, ‘Yam walo aliguwai nigele yaya'awa moihayei, na yawalo moiha alimiwai ebeha mata masigili teina ainai uuvalaegau mai tonuga, na mulitai am'am idou’. ");
INSERT INTO kud2014_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yeisu iguguyeidi iwalo, ‘Havena am'alu'aluwagavai, na hesi Yaubada amyemidiyei, yo hinage yau amyemidiyegau. ");
INSERT INTO kud2014_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Na Tamagu yana tupwa ainai aba'aiyawasi bahudi. Ainaena yalalau ta yami abamiya ya'atububuni. Ebe teina nigele walo moiha, mata nigele teina dova yayawalo mahalava alimiyai. ");
INSERT INTO kud2014_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na ebe yalau na yami abamiya ya'atububuni, howola abo yawuyoma na yalauvaigomiu ta tupwanae ainai yamiyamiyane omiu hinage ainai ammiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Na amwahanane ainai yalaulaune bada amhanapuiya'o.’ ");
INSERT INTO kud2014_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Eeta Tomasi iwalo, ‘Bada, aiteya amwaha ainaena ulaulaune? Vedova ebe amwahanane ahanapui?’ ");
INSERT INTO kud2014_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Na Yeisu Tomasi ainai iwalo, ‘Yau amwahaede, na yau walomoiha yo yau yawahimiu wuwudi. Ebe yaiya nuwanuwana na ilau Tamagu ainai, nigele teya amwaha iyamiyamiya, neta bada yau ta'i.’ ");
INSERT INTO kud2014_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Na Yeisu hinage aidiyai iwalo, ‘Yau bada amhanapuigau'o, ainaena Tamagu amhanapuiya'o. Moiha, Tamagu bada amhanapuiya'o, yo hinage am'itaya'o.’ ");
INSERT INTO kud2014_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Na Pilipi Yeisu ainai iwalo, ‘Bada, nuwanuwamai na Tamamne uve'itagai neta bada ainaede’. ");
INSERT INTO kud2014_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Eeta Yeisu Pilipi ainai iwalo, ‘Hauga daodaona alimiyai yamiyamiya na nigele amyahanapuigau? Na yaiyadiwo omiu bada am'itagau'o, omiu hinage Tamagu bada am'itaya'o yo amhanapuiya'o. Eeta hava vehabana uwalo “Tamamne uve'itagai”? ");
INSERT INTO kud2014_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nuwana nigele uyayemidiyegau ebeha yau Tamagu ainai yamiyamiya, na hinage Tamagu ibom aliguwai imiyamiya, awa? Walowone bada yawalowedi'o alimiyai nigele yau yagu walo na hesi Tamagu ainaena, wuwuna ibom aliguwai imiyamiya, yo hinage aliguwena yana paihowa ipaipaihowaidi. ");
INSERT INTO kud2014_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Teina hauga amyemidiyegau neta yau Tamagu ainai yamiyamiya, na Tamagu hinage iya aliguwai imiyamiya. Na ebe yagu walowone nigele amyayemidiyedi, yede yagu paihowaone wahiwahiyaladine amnuwatuwu avivinidi, ta ainaena ebe amyemidiyegau. ");
INSERT INTO kud2014_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Na yawalo moiha alimiyai, ebe yaiyadiwo omiu amyemidiyegau, mata paihowa wahiwahiyaladi yapaipaihowaidiwa omiu hinage dova mata ampaihowaidi, yo hinage howola abo paihowa wahiwahiyala alilidi am'abiye mahalavadi, wuwuna yau yalalau Tamagu ainai. ");
INSERT INTO kud2014_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ebe hava dova nuwanuwamiu na yehaguwena am'awanoi, yamohegomiu ta'i, na neta ainaena Tamagu yana wasawasa ilobai yagu paihowa ainaena. ");
INSERT INTO kud2014_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ebe teya ginauli vehabana yehaguwena am'awanoi mata yapaihowai ta'i.’ ");
INSERT INTO kud2014_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Na hinage Yeisu aidiyai iwalo, ‘Ebe amvelauwegau, yagu loina am'awa abiyedi, ");
INSERT INTO kud2014_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","na howola abo Tamagu ainai ya'awanoi ta ami Tauhagu ehebo imohegomiu. Iya Tauhagune, Alu'aluwa moiha yo dumwadumwaluna, ta iya alimiyai imiya vateyai. ");
INSERT INTO kud2014_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Na hiya taumiya bale'u nigele howahowadi ta Alu'aluwane hilauvai, wuwuna ana oleya nigele hiya'ita yo nigele hiyahanapui. Na hesi Tauhagune amhanapuiya'o iya hauga maudoina atemiyai imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mata nigele yayalaugabaigomiu, ta dova sinasinagehemiu, wuwuna mata yalau gwaipileuyoma. ");
INSERT INTO kud2014_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Na hauga muhamuhana ainai mata yalaugabaigomiu, ta nigele mata taumiya bale'u hiya'itauyoigau, na omiu howola abo am'itagau mayawahigu yamiyamiya, ainaena omiu hinage dova mayawahimiu ammiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Na hauganane tenem ainai amhanapuigau ebeha yau Tamagu ainai yamiyamiya, na omiu aliguwai ammiyamiya na yau alimiyai yamiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ebe yaiya owa yagu loina uhanapuidi yo uyemidiyedi, owa bada uvelauwegau'o. Eena Tamagu hinage ivelauwego'o yo yau hinage yavelauwego na yave'itauyowegau alimwai.’ ");
INSERT INTO kud2014_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ehebo Yudasa (iya nigele Yudasa Isakaliyota) Yeisu ainai iwalo, ‘Bada, vedova ta abom alimaiyai mata umahalavauyo na nigele taumiya bale'u aidiyai?’ ");
INSERT INTO kud2014_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Na Yeisu ainai iwalo, ‘Ebe owa yaiya uvelauwegau yagu walo umulitaedi, eeta Tamagu mata ivelauwego, yo ainaena Tamagu baidagu alaowa alimwai, ta owa baidamai tamiya toyawa. ");
INSERT INTO kud2014_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Na ebe owa yaiya nigele uyavelauwegau, owa yagu walo nigele uyamulitaedi, na yagu walo nigele uyayemidiyedi. Na walone neta ambebenaledine nigele aliguwena, na hesi iya agu tauvetamale Yaubada ainaena. ");
INSERT INTO kud2014_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","‘Ginauli teina yawalo auligomiu'o haugana yau baidamiu tamiyamiya, ");
INSERT INTO kud2014_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","na howola Tauhagune, yehaguwena Yaubada ivetamalenama iya Alu'aluwa Ve'ahihi, ibom mata ginauli bahudi ive'itagomiu, yo hinage walowone maudoidi yawalowalowedine ivenuwamwauwegomiu. ");
INSERT INTO kud2014_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Teina na yalau vehulugomiu, ainaena yagu nuwadaumwali yamwauwi, na nuwadaumwalinane nigele dova taumiya bale'u yadi nuwadaumwali. Eeta havena am'alu'aluwagavai bo ammehemeheuhi. ");
INSERT INTO kud2014_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘Yagu walo bada ambenalena'o ebeha howola mata yalau na mulitai abo yawuyoma alimiyai. Na ebe omiu amvelauwegau, yagu laune Tamadane ainai vehabana amyaliyaya, wuwuna Tamadane iya imwala'i gabaegau. ");
INSERT INTO kud2014_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Hauga teina ainai ginaulidine yawalo mahalavaedi alimiyai, ta ebe hauga ilalaoma ainai himahalava, neta yagu walone am'awa moihaedi. ");
INSERT INTO kud2014_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mata nigele hauga daodaona ya'au'aubabada alimiyai, wuwuna bale'u ana tauloina, Tomodulele, ilalaoma, na iya nigele teya yana wahiyala aliguwai, ");
INSERT INTO kud2014_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","na agu loina hesi Tamagu ainaena hauga maudoina yapaipaihowaidi, ta teina ainaena taumiya bale'u hihanapui ebeha Tamagu yavelauwei. ‘Badagi! Amtowolo, talau.’ ");
INSERT INTO kud2014_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yeisu hinage aidiyai iwalo, ‘Yau aiwa ainona moiha, waini aiwana dova, na Tamagu iya taupaihowa. ");
INSERT INTO kud2014_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Na ebe lagalagaguwone nigele hiya'aino, mata itom vehuludi; na ebe lagalagaguwone ainodi imwauwidi, igula yawahidi ta ebe hi'aino ili'ilimani. ");
INSERT INTO kud2014_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Na omiu dova yagu walo ainaena bada yagulayawahigomiu'o. ");
INSERT INTO kud2014_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Eeta omiu aliguwai ammiyamiya, yau hinage alimiyai yamiyamiya. Wuwuna ebe omiu nigele aliguwai amyamiyamiya, mata nigele amya'aino ili'ilimani. Dova ebe aiwa lagalagana nigele aiwana ainai iyamiyamiya, mata nigele iya'aino. ");
INSERT INTO kud2014_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","‘Yau aiwa'ahipuna na omiu lagalagaguwao, eeta ebe yaiya aliguwai imiyamiya, i'aino ili'ilimani. Wuwuna ebe yau nigele, mata nigele hava teya namwanamwana amyapaihowai. ");
INSERT INTO kud2014_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Na ebe yaiya iya nigele aliguwai iyamiyamiya, mata hitom vehulu ta iwelai, ta lagalaga tomtom vehuludi hitanoidi ta aiwa ala'alahina ainai higabudi. ");
INSERT INTO kud2014_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Na ebe aliguwai ammiyamiya na hinage yagu walo alimiyai imiyamiya, na ebe hava nuwanuwamiu am'awanoi mata amlobaidi. ");
INSERT INTO kud2014_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ebe ammulitaegau moiha, ainomiu hinamwanamwa, na ainaena Tamagu yana wasawasa tomowa hi'ita. ");
INSERT INTO kud2014_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","‘Tamagu ivelauwegau, dova yau hinage yavelauwegomiu, ta yagu velaune ainai ammiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ebe yagu loina ammulita moiha, yagu velau ainai ammiyamiya. Dova yau Tamagu yana loina yamulitaedi, ta yau yana velau ainai yamiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Bada dova yawalo auligomiu'o na teina ta'i yagu yaliyayaena amyaliyaya, ta nuwamiu maudoina hiyaliyaya moiha. ");
INSERT INTO kud2014_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Na teina yagu loina alimiyai ebeha amvelauyoigomiu dova yau yagu velau alimiyai. ");
INSERT INTO kud2014_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Na ebe yaiya ana geluwo vehabadi imwalowoi, neta velau mwala'i alilina. ");
INSERT INTO kud2014_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Omiu hinage dova ebe yagu loina am'awa abiyedi, omiu augeluwo. ");
INSERT INTO kud2014_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nigele howahowana ta ya'awa taupaihowaegomiu, wuwuna taupaihowao yadi taubada yana nuwatuwu nigele hiyahanapui. Na hesi ya'awa augeluwoegomiu, wuwuna hava dova Tamagu ainaena yabebenalediwa bada yawalo mahalavaedi'o. ");
INSERT INTO kud2014_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Omiu nigele amyavesinuwaegau na hesi yau yavesinuwaigomiu ta ebeha yavetamalegomiu ta ampaihowa, na yami paihowane ainaena ainomiu namwanamwadi himahalava, na ainomiune himiya vateyai. Na hinage ebe hava yehaguwena am'awanoiyei, Tamagu ta'i imohegomiu. ");
INSERT INTO kud2014_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Neta bada yagu loinaede alimiyai yawalo mahalavaena'o, ebeha amvelauyoigomiu.’ ");
INSERT INTO kud2014_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yeisu hinage aidiyai iwalo, ‘Ebe taumiya bale'u hita'wata'wataegomiu, amnuwatuwu avivini ebeha yau hinage mwalona hita'wata'wataegaune. ");
INSERT INTO kud2014_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Na ebe omiu mumugamiu dova taumiya bale'u mata taumiya bale'u hivelau alimiyai, wuwuna omiu adi geluwo. Na hesi bale'u teina ainaena omiu bada yavai mahalavaegomiu'o, ainaena nigele taumiya bale'u yadi boda ainai amyamiyamiya. Neta wuwuna ta mata taumiya bale'u hita'wata'wataegomiu. ");
INSERT INTO kud2014_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Amnuwatuwu avivini walo mugai yamohegomiu neta nigele teya taupaihowa yana taubada iyataudi'wai. Yau mugai hive'alehaegau, ainaena omiu hinage dova mata hive'alehaegomiu. Na ebe mugai yagu walo hiyemidiyedi omiu hinage yami walo hiyemidiyedi. ");
INSERT INTO kud2014_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ginauliwone yababadi teina hipaipaihowaidi alimiyai wuwuna omiu yagu bodao, yo hinage agu tauvetamalene nigele hiyahanapui. ");
INSERT INTO kud2014_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ebe mugai nigele yayalaoma ta aidiyai yayawalo mahalava, nigele yadi pwanoli iyamiyamiya. Na hesi bada yalaoma'o ta aidiyai yavenuwamwau'o, ainaena nigele howahowana na yadi pwanoli vehabana hiwalogeyo'awa. ");
INSERT INTO kud2014_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Na ebe yaiya iya ita'wata'wataegau, iya hinage Tamagu ita'wata'wataei. ");
INSERT INTO kud2014_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mugai paihowa abanuwapwanopwano mehediyai yapaipaihowaidi, neta nigele teya yaiya howahowana na ipaihowaidi. Paihowa abanuwapwanopwano hi'itadi'o ta hita'wata'wataegau na Tamagu hita'wata'wataei na mata ive'ewaidi ta nigele teya yadi abauvala. ");
INSERT INTO kud2014_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Na yadi paihowane yababadine imahalava moiha wuwuna Buki Ve'ahihi ainai iwalo yemidi mugai, iwalo: ‘Yadi ta'wata'wata vehabagu nigele wuwuna.’ ");
INSERT INTO kud2014_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Na hesi howola ami Tauhagune Tamagu ainaena ivetamalenama, ta iya iwalo mahalavaegau, ");
INSERT INTO kud2014_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","na omiu hinage amwalo mahalava vehabagu, wuwuna yagu paihowa ana abavetuwuni ainaena ta wau omiu baidaguwao.’ ");
INSERT INTO kud2014_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yeisu ana taumulitao aidiyai iwalo, ‘Bada ginauli teina yawalo mahalavaedi'o alimiyai ainaena nigele mata aidiyena amyabe'u. ");
INSERT INTO kud2014_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Wuwuna howola vada tapwalolowena hiheusiligomiu yo hinage howola hauga ilalaoma ta ebe yaiya i'oiye mwalowoigomiu, iya yana nuwatuwu ebeha teina Yaubada yana awanamwanamwa. ");
INSERT INTO kud2014_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yadi paihowa teina yababadi mata alimiyai hipaihowaidi, wuwuna Tamagu yo yau nigele hiyahanapuigai. ");
INSERT INTO kud2014_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ginauliwone tenem dova bada yawalo mahalavaedi'o alimiyai eeta haugana ebe himahalava amnuwatuwu avivinidi.’ Yo hinage aidiyai iwalo, ‘Ginauliwone teina dova nigele mugai yayawalo mahalavaedi alimiyai, wuwuna yau baidamiu. ");
INSERT INTO kud2014_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Muhamuhana na yalau iya ivetamalegaumawa ainai, ainaena mata yalaugabaigomiu na nigele teya yaiya alimiyena iyapanivilaegau yo iya walo, “Havaidova ulalau?”. ");
INSERT INTO kud2014_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Yagu walo vehabadi nuwamiu hiyababa mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Na hesi yawalo moiha alimiyai neta inamwanamwa alili ebe yalaugabaigomiu, wuwuna ebe nigele yayalaugabaigomiu Tauhagune mata nigele iyalaoma. Na ebe yalaugabaigomiu na yalau mata Tauhagune yavetamalenama alimiyai. ");
INSERT INTO kud2014_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ebe ilaoma, bale'uwai mata yadi paihowa yababana i'abiye mahalavadi na Yaubada yana paihowa namwanamwana yo yana lauvetala i'abiye mahalavadi. ");
INSERT INTO kud2014_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Paihowa yababadi i'abiye mahalavadi wuwuna tomawa nigele hiyayemidiyegau. ");
INSERT INTO kud2014_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Paihowa dumwadumwaluna i'abiye mahalavadi wuwuna yau bada yalalau Tamagu ainai na nigele mata amya'ita'itauyoigau. ");
INSERT INTO kud2014_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Na lauvetala i'abiye mahalavadi wuwuna Yaubada Tomodulele bale'u loinana bada ilauvetalaena'o ta yana yababa maihana ive'aloya'o. ");
INSERT INTO kud2014_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","‘Na ve'ita bahudi himiyamiya, na hesi nigele mata maudoina hauga teina yawalo mahalavaedi alimiyai, wuwuna nigele howahowamiu amhanapuidi. ");
INSERT INTO kud2014_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Howola mata Alu'aluwa Ve'ahihi ilaoma abo iya imugaiyegomiu ginauli dumwadumwaludi maudoidi aidiyai. Na iya mata nigele yana nuwatuwuwena iyawalowalo, na hesi hava ibebenalediwa, iwalowedi, yo hinage iwalowalo ginauli mehemiyai vehabadi. ");
INSERT INTO kud2014_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Eena yagu hanapuwena alimiyai ive'ita ta ainaena yagu wasawasa i'abiye mahalava. ");
INSERT INTO kud2014_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Hinage hava Tamagu yana ginauli maudoina yau aliguwena mata i'abiye mahalava. Neta vehabana yawalo auligomiu yawalo Alu'aluwana mata ive'itagomiu yau vehabagu.’ ");
INSERT INTO kud2014_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yeisu iwalouyo, iwalo, ‘Hauga muhamuhana ainai mata nigele amya'itagau, na hinage hauga muhamuhana ainai abo am'itagau’. ");
INSERT INTO kud2014_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Na tupwadi ana taumulitaowa adi geluwo aidiyai hiwalo, ‘Hava yana walo teina ana hanapu? Wuwuna alidai iwalo, “Hauga muhamuhana ainai nigele mata amya'itagau, na hauga muhamuhana ainai abo am'itauyoigau. Wuwuna yalalau Tamagu ainai”, ");
INSERT INTO kud2014_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","eeta hava “Hauga muhamuhana ana hanapu”?’ Na hiwalo, ‘Ta'i'ita! Nigele tayahanapui hava vehabana iwalowalone’. ");
INSERT INTO kud2014_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Na Yeisu ana taumulitaowa yadi nuwatuwu bada ihanapuidi'o ebeha ainai hipanivila, eeta aidiyai iwalo, ‘Hava vehabana ambom ampanipanivilauyowegomiune?’ Eena iwalo, ‘Hauga muhamuhana mata nigele amya'itagau, na hauga muhamuhana mulitai abo am'itauyoigau, awa? ");
INSERT INTO kud2014_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Yawalo moiha alimiyai mata howola mayami nuwayababa amdoudou, na hesi taumiya bale'u maudoidi hiyaliyaya. Na omiu howola abo yami nuwayababane ibui ta yaliyaya. ");
INSERT INTO kud2014_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Dova haugana ebe waihiu yana hauga labalaba ainai mata muya ilobai, na yana labalaba tuluhanai, muya maudoina inuwavehuludi, wuwuna gama bada i'avalaiya'o ta mayana yaliyaya. ");
INSERT INTO kud2014_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Omiu dova hinage, wuwuna nuwayababa alimiyai, hauga teina, na howola yalau gwaipilema na am'itagau, na vehabagu amyaliyaya moiha. Na yaliyayane mata nigele teya yaiya alimiyena iyavai vehulu. ");
INSERT INTO kud2014_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ta ebe hauganane ilaoma, omiu havena hava aliguwai vehabana ampanipanivila. Na yawalo moiha alimiyai ebe yehaguwena Tamagu ainai hava vehabana am'awanoi, imohegomiu ta'i. ");
INSERT INTO kud2014_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mwalona ta wau nigele teya hava vehabana yehaguwena amya'awa'awanoi. Ainaena teina hauga ebe hava nuwanuwamiu vehabana am'awanoi mata imohegomiu, na ainaena amyaliyaya moiha. ");
INSERT INTO kud2014_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","‘Bada walo vegevegediyena ginauli teina yawalo mahalavaedi'o alimiyai. Na howola hauga ilalaoma mata nigele walo vegevegediyena yayawalo auligomiu, na hesi Tamagu vehabana yawalo mahalava moiha alimiyai. ");
INSERT INTO kud2014_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Hauga howola ainai omiu yehaguwena am'awanoi Yaubada ainai, na mata nigele yau vehabamiu yaya'awa'awanoi, ");
INSERT INTO kud2014_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","wuwuna Tamagu iya bada ivelauwegomiu'o. Na yana velauwegomiune wuwuna omiu amveluwegau, yo hinage amyemidiyegau ebeha Yaubada ainaena yalalaomane. ");
INSERT INTO kud2014_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yau Tamagu ainaena yalaoma ta bale'uwai yamiyamiya, ainaena teina hauga bale'u yalalaugabaei ta yawuwuyo Tamagu ainai.’ ");
INSERT INTO kud2014_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Eena ana taumulitao hibenalei ta hiwalo auli, hiwalo, ‘Bada, teina hauga bada uwalo mahalava'o moiha alimaiyai, na havena walo vegevegediyena. ");
INSERT INTO kud2014_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Teina ainaena ebe ahanapu ili'ilimanigo neta owa ginauli bagibagilidi uhanahanapuidi. Ainaena nigele mata ayapanivilaego, wuwuna bada yama nuwatuwu maudoidi uhanahanapuidi. Na bada ayemidiyego'o ebeha owa Yaubada ainaena ulalaomane.’ ");
INSERT INTO kud2014_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Eeta Yeisu iwalo aulidi iwalo, ‘Bada amyemidiyegau'o, awa? ");
INSERT INTO kud2014_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Na howola abo hauga imahalava, nuwana tawalo, bada hauga imahalavama'o, na maudoimiu amtaubudebudeyanaei yami dalava aidiyai, na yau yabom yamiyamiya. Ta nigele ebeha yau yabom, na hesi Tamagu baidagu. ");
INSERT INTO kud2014_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","‘Walo teina yawalo mahalavaedi'o alimiyai ta ebe mayami nuwadaumwali ammiyamiya, wuwuna yau baidamiu. Hinage howola abo bale'u ainai vitai amlobai na hesi am'atepatu, wuwuna yau bale'u maudoina ana loina yawahiyala gabaena'o.’ ");
INSERT INTO kud2014_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ginauli teina Yeisu bada i'ata'idi'o ta galewa ainai itamayahi, ta i'awa'awanoi, iwalo, ‘Tamagu, yagu hauga bada ibwalenima'o. Ainaena yau natum mata yam wasawasa umohegau ta yam wasawasa ya'abiye mahalava. ");
INSERT INTO kud2014_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Dova owa loina umohegau tomowa maudoidi vehabadi, na ainaena yau yawahi miyamiya vateyaina tomowaowa yamohe geyo'awaei aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Neta yawahi miyamiya vateyaina mata tomowa hihanapuigo ebeha owa ubom Yaubada moiha, yo yau Besibesinanagu hihanapuigau ebeha owa uvevetamalegaumane. ");
INSERT INTO kud2014_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Bale'u teina ainai yam wasawasa ya'abiye mahalavaya'o, wuwuna yagu paihowao umomohegauwa bada yave'ovidi'o. ");
INSERT INTO kud2014_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tamagu ee, owa, teina hauga mehemwai u'abiye wasawasaegau, dova mugai owa na yau yada wasawasawa ainai tamiyamiya, na mulitai bale'u ta'a'atububunine. ");
INSERT INTO kud2014_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","‘Ta mumugam maudoina bada yave'itaena'o hiya taumiya bale'u umomohegaune aidiyai, wuwuna owa yam bodao na umomohegaune, ta yam walo maudoina himulitaedi, ");
INSERT INTO kud2014_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","yo hinage ginauli maudoina umomohegaune hihanapuidi'o ebeha owa alimwena hilalaomane. ");
INSERT INTO kud2014_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Eeta walowa umomohegaune bada yave'itadi'o ta atediyai himwaudi'o, ainaena hihanapu ili'ilimanigau ebeha owa alimwena yalalaomane, yo hinage hiyemidiyegau ebeha owa uvetamalegaumane. ");
INSERT INTO kud2014_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ainaena teina hauga vehabadi ya'awa'awanoi alimwai. Nigele ebeha taumiya bale'u vehabadi, na hesi bodaone umomohegaune vehabadi, wuwuna hiya yam bodao. ");
INSERT INTO kud2014_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Na yam bodaone yau yagu bodao dova hinage yagu bodaone owa yam bodao. Eeta yada bodaone yadi yemidi ainaena yavewasawasa'o. ");
INSERT INTO kud2014_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na yau hauga teina bale'u yalaugabaei na alimwai yalaowa, na hiya bale'uwai himiyamiya, vehabadi ya'awa'awanoi. Tamagu tauwahiyala yeham ala'alawowolina ainaena u'ita avivinidi na yeham umomohegauwa, ainaena hiyeboda ehebo, dova owa na yau tave'ehebone. ");
INSERT INTO kud2014_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Haugana yau baidadi yam wahiyalane umohegau'o ainaena ya'i'ita avivinidine, ta nigele teya yayagabaei, na ehebo a'ava yababa ainaena mugai Buki Ve'ahihi ainai iwalo mahalava'o ta ebe i'wadalele. ");
INSERT INTO kud2014_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","‘Ta yau bada teina na yalalaowa alimwai, na yagu walo teina bale'uwai yagu bodao yawalowalowedine aidiyai ebe yagu yaliyaya ainaena hiyaliyaya mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ta tomowadine yam walo bada yamohedi'o, na hesi taumiya bale'u hive'alehaedi, wuwuna hiya nigele taumiya bale'u yadi boda aidiyai hiyamiyamiya, dova hinage yau nigele yadi boda ainai yayamiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nigele yaya'awanoi vehabadi ta ebeha bale'uwena uvai mahalavaedi, na hesi ya'awa'awanoi vehabadi ta ebe havena Tomodulele i'abi'abitowoidi. ");
INSERT INTO kud2014_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ainaena teina hauga hiya nigele taumiya bale'u yadi boda ainai hiyamiyamiya, wuwuna hiya dova yau. ");
INSERT INTO kud2014_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ya'awanoi alimwai ta yam walo moihaena u'abiye ve'ahihiyedi ta ebe yam bodao masemaseledi. ");
INSERT INTO kud2014_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Dova owa uvetamalegauma taumiya bale'u aidiyai yau hinage teina yavetamaledi taumiya bale'u aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Yagu bodao vehabadi yatalamwegau alimwai ta ebe hauga ilalaoma ainai hiya hinage hitalam moiha alimwai. ");
INSERT INTO kud2014_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","‘Tamagu yo, nigele ebeha hibom vehabadi yaya'awanoi, na hesi hiya hinage mulitai yadi walowena hiyemidiyegau vehabadi. ");
INSERT INTO kud2014_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ya'awanoi alimwai ta ebe maudoidi hive'ehebo alidai, dova owa na yau ehebo ta'i, na ainaena taumiya bale'u hiyemidiyegau ebeha owa uvevetamalegaumane. ");
INSERT INTO kud2014_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mugai yam wasawasa umomohegauwa bada bodadine yamohedi'o, ta ainaena hive'ehebo'o, dova tabom yada ve'ehebone. ");
INSERT INTO kud2014_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ta yau aidiyai yamiyamiya, owa hinage aliguwai umiyamiya, ta teina ainaena hive'ehebo moiha. Ta teina ainaena taumiya bale'u hihanapuigau ebeha owa uvetamalegauma, yo hinage hihanapuigo ebeha owa hiya uvelauwedi, dova yau uvelauwegau. ");
INSERT INTO kud2014_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","‘Tamagu yo, hiya bada umohedi'o aliguwai nuwanuwagu na baidaguwao amiyamiya. Ta tenem ainaena yagu wasawasawa umomohegauwa hi'ita, wuwuna mulitai abo bale'u upaihowai owa uvelau mugaiyegau. ");
INSERT INTO kud2014_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","‘Tamagu yo, owa taudumwalu, na taumiya bale'u nigele hiyahanapuigo, na hesi yau yahanapuigo'o. Na hinage teina bodaone bada hihanapuigo'o ebeha owa uvetamalegaumane. ");
INSERT INTO kud2014_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Eeta mumugam yave'itaena'o aidiyai, na howola abo yave'itauyoidi ta hihanapu ili'ilimanigo, na ainaena yam velaune ateguwai imiyamiya, hiya hinage atediyai imiyamiya, na yau hinage atediyai yamiyamiya.’ ");
INSERT INTO kud2014_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yeisu yana awanoi ive'oviya'o, ta ana taumulitaone baidanao hilau ta ehebo we'aha yehanaede Kidiloni higeyo'awai, ta hilau Olibe oyana ainai hiluluwune. ");
INSERT INTO kud2014_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudasa iya tauhuhulane dalavanane ihanahanapui, wuwuna hauga maudoina Yeisu mayana taumulitao tupwanane ainai hilaulau. ");
INSERT INTO kud2014_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Eeta Yudasa tau'alehaone baidanao hilalaune tupwanane ainai, mayadi wodam yo lampa yo hinage mayadi gogo'aleha, wuwuna tau'alehaone hiya taupwaoliwo yo Palisiwo hivetamaledi Yudasa baidadi. ");
INSERT INTO kud2014_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Na Yeisu bada ihanapuiya'o hava mata imahalavane ainai, eeta ilau ta tau'alehaone ipapanivilaedine, iwalo, ‘Yaiya ambehabehaeine?’ ");
INSERT INTO kud2014_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Na hiya hiwalo, ‘Ehebo Nasaleti towahona, yehanaede Yeisu.’ Ta Yeisu aidiyai iwalo, ‘Yau teina.’ Yudasa na tau'alehawone baidanao hitowotowolo. ");
INSERT INTO kud2014_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Na hauganane Yeisu iwalo, ‘Yau teina,’ maudoidi hitowolo si'isi'i ta hibebe'une bale'uwai. ");
INSERT INTO kud2014_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tau'alehaone hitowolouyoma bale'uwena na hinage Yeisu ipanivilauyone, iwalo, ‘Yaiya yede ambehabehaeine?’ Na hiwalo, ‘Ehebo Nasaleti towahona, yehanaede Yeisu.’ ");
INSERT INTO kud2014_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Na hinage aidiyai iwalouyo, iwalo, ‘Bada alimiyai yawalo'o ebeha yau teina, na ebe yau am'abi avivinigau agu taumulitaone amtalamwedi ta hilau yadi dalavai’. ");
INSERT INTO kud2014_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yeisu walone teina dova i'a'ataine wuwuna yana awanoiwa ebe imahalava ili'ilimani, haugana iwalo: ‘Tamagu tomowaowa umomohegauwa nigele teya yayagabaei.’ ");
INSERT INTO kud2014_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Na Saimoni Pita vahalinai itowotowolo yana aleha elepana iwunihiyama ta ehebo taupwaoli mwala'ina yana taupaihowa talina tautuwana itotomvehulune, yehanaede Maki. ");
INSERT INTO kud2014_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Na Yeisu iwalo Pita ainai, ‘Yam elepane umwauyoi abamwauwinane ainai, nigele howahowana agu muya vedinane ulaugagayowei. Wuwuna vedi teina Tamagu imohegau ta ebeha yanuma.’ ");
INSERT INTO kud2014_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tau'alehaone mayadi taumugaiwo yo Yudeyaone mayadi taupaihowao Yeisu hi'abi avivini ta nimanane hipaidi. ");
INSERT INTO kud2014_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","I'ovi na hilalaweine Anase yana vadai, Anase iya Kayapasi bwahiyana, bolimai tenem ainai Kayapasi iya taupwaoli adi taumugai mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Na hinage iya Kayapasi mwalona Yudeyaone aidiyai iwalo. ‘Howahowana teya towaho imwalowoi tomowa maudoidi vehabadi’. ");
INSERT INTO kud2014_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Na Yeisu hilauvai yo ana taumulitaone hitau bwau Saimoni Pita na ehebo hinage Yeisu ana taumulita iya taupwaoline mwala'inane ana gelu ta bodaone baidadiyao hiluluwune taupwaoline mwala'inane yana vadai. ");
INSERT INTO kud2014_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita nigele iyaluwu na hesi awa'edane vahalinai itowotowolo, eena taumulitawa iya taupwaoli mwala'ina ana geluwa imahalavauyoma ta awa'edane ana tau'ita avivini ehebo waihiu ainai iwalo ebeha Pita hinage iluwu, eeta waihiuwa italam ta Pita iluluwune. ");
INSERT INTO kud2014_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Na waihiuwa Pita ipanivilaei iwalo, ‘Owa nuwana ehebo Yeisu ana taumulita, awa?’ Na Pita iuvala iwalo, ‘Yau nigele’. ");
INSERT INTO kud2014_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Na hauganane gwaugwau ana hauga, ta taupaihowaone yo tau'alehaone aiwa hiyuvi na himwaimwaibwa, eena Pita iluwu aidiyai ta baidanao himwaimwaibwa. ");
INSERT INTO kud2014_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Na taupwaoline mwala'inane Yeisu ipanivilaei, ‘Yaiyadiwo amtaumulitaone yo hinage vedova yam ve'ita aidiyai’. ");
INSERT INTO kud2014_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Na Yeisu iwalo, ‘Yau yagu ve'itane maseleyai yo vada tapwalolo holadiyai, yo hinage Yelusalem vada tapwalolo mwala'ina holanai, eena hiya Yudeyaone maudoidi hauganane ainai hiluwuluwu ta bada yagu ve'ita hibenaledi'o, wuwuna nigele aidiyena yayave'ita dawani. ");
INSERT INTO kud2014_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Na hava wuwuna ta nigele hiya aidiyai uyapanivilane, wuwuna hiya yagu walo maudoina bada hibenaledi'o na hava yagu walo aidiyai bada hihanapuiya'o.’ ");
INSERT INTO kud2014_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Hauganane Yeisu yana walo tenem dova iwalo mahalavaei, ehebo tau'aleha vahalinai itowotowolo nimanaena Yeisu i'o'oinavanavavaine na iwalo, ‘Hava vehabana taupwaoli mwala'ina uwalowalo mehei’. ");
INSERT INTO kud2014_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Towahonane yana walo Yeisu iyemaiha iwalo, ‘Ebe hava yagu walopwano, uwalo mahalava tomowa aidiyai, na ebe yagu walo dumwaluna hava vehabana utatalaigaune?’ ");
INSERT INTO kud2014_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Na Anase Yeisu ivetamalei, ta ma'ana pai tau'alehaone hilalaweine taupwaoli mwala'ina Kayapasi ainai. ");
INSERT INTO kud2014_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Na Pita besiwa baidadi hitowotowolo na himwaimwaibwa, ta hipanivilaei, hiwalo, ‘Owa teina towahone ana taumulita teya, bo?’ Na Pita hinage iuvala iwalo, ‘Yau nigele’. ");
INSERT INTO kud2014_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Na taupwaoli mwala'ina yana taupaihowa teya mwalona Pita talinanane itotomvehulune ana gelu ehebo Pita hinage ipanivilauyoi iwalo, ‘Owa hinage Yeisu baidam alowai ya'i'itagom'une awa?’ ");
INSERT INTO kud2014_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Na Pita hinage iuvala, na tenem hauganane ainai am'amne idodoune. ");
INSERT INTO kud2014_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Eeta Yeisu Kayapasi yana vadaena hilauvai ta hilalaweine tauloina mwala'ina, Pailato yana vadai, na bada malane itomya'o, eeta nigele howahowana Yudeyaone hiluwu Pailato yana vadai, wuwuna hauganane ebe Buidi'wa guyauna hi'ai nigele howahowana Loma tomowana yana vadai hiluwu, neta yadi ve'ahihi mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ainaena Pailato ibwalenima yana vadaena ta ipapanivilaedine, iwalo, ‘Hava yami ve'ewa teina towahone vehabana?’ ");
INSERT INTO kud2014_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Na Yudeyaone hiwalo, ‘Ebe teina towahone nigele taupwanoli, mata nigele ayalauvaiyama alimwai’. ");
INSERT INTO kud2014_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Na hinage Pailato aidiyai iwalo, ‘Ausala, yede ambom amlauvai amlawei na yami loinaena amlauvetalaei.’ Na Yudeyaone hiwalo, ‘Ai nigele ama talam ebeha towaho teya yana mwalowoi vehabana aloina’. ");
INSERT INTO kud2014_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Na Yeisu yana mwalowoi aiwa lagalagana ainai vehabana mwalona bada ibom iwalowedi'o ta teina haugane ainai walowone hibwabwaleni ili'ilimani. ");
INSERT INTO kud2014_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ta Pailato iluwuyo yana vadai, na Yeisu iyogaei ta hinage iluluwune ainai, ta ipapanivilaeine, iwalo, ‘Owa Yudeyaone yadi tauwasawasa?’ ");
INSERT INTO kud2014_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Na Yeisu iwalo, ‘Teina owa yam nuwatuwu ebeha yau Yudeya yadi tauwasawasa, bo nuwana tomowa yadi walo?’ ");
INSERT INTO kud2014_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Na Pailato iwalo, ‘Yau nigele Yudeya towahona, owa hesi yam tomowao yo yam taupwaoliwo hilalauvaigomane aliguwai, hava yede yam pwanoline?’ ");
INSERT INTO kud2014_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Na Yeisu iwalo, ‘Yagu abaloina nigele teina bale'uwai, wuwuna ebe yagu abaloina moiha teina bale'uwai mata yagu hevahevaliwo hi'aleha vehabagu na nigele howahowana Yudeyaone hi'abi avivinigau, na hesi yagu abaloina hali tupwai’. ");
INSERT INTO kud2014_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Hinage Pailato ipanivilaei iwalo, ‘Moiha owa tauwasawasa?’ Yeisu iwalo, ‘Ehe, neta dova yau tauwasawasa. Yalaoma bale'uwai hilabahigau ebeha yavetauwasawasa na mumuga dumwadumwaluna yawalo mahalavaei. Ebe yaiyadiwo nuwadi himasele mata walomoiha hi'awa abiyei.’ ");
INSERT INTO kud2014_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Na hinage Pailato ipanivila, ‘walomoiha hava?’ Pailato ibwaleniuyoma na Yudeyaone aidiyai iwalo, ‘Nigele teya pwanoli yayalobai ainai’. ");
INSERT INTO kud2014_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pailato iwalo Yudeyaone aidiyai, ‘Omiu mumugamiu neta ebe Buidi'wa guyauna ana hauga ainai mata teya taupwanoli yalivahi vehabamiu, ainaena vedova, nuwanuwamiu Yudeya yami tauwasawasa yalivahi vehabamiu?’ ");
INSERT INTO kud2014_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Maudoidi hiwuiwui mwala'ina na hiwalowalo, ‘Havena iya na hesi Balabasi ulivahi’. Na Balabasi iya tau'aivavali mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pailato Yeisu ilauvai ta yana tau'alehaone imomohedine, ta balavai ainaena hipwepwediline. ");
INSERT INTO kud2014_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Hinage haihaili womawomalina hivai ta ana pwaopwaomi hipai ta ulu'ulunai himwamwauwine yo hinage luwuluwu hawahawawalina hivai ta hiveveluwuine, ");
INSERT INTO kud2014_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","mulitai hilaoma vahalinai na hi'abi'abitalawahiyei hiwalo, ‘Yauwedo, owa Yudeya yadi tauwasawasa!’. Na hinage nimadiyena higohagohanavanavai. ");
INSERT INTO kud2014_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailato ibwalenima ta bodaone aidiyai iwalo, ‘Am'ita towahowa teina yamahalavaenama'o ta ebe amhanapui neta nigele teya pwanoli yayalobai ainai’. ");
INSERT INTO kud2014_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Na mulitai Yeisu ulu'uluna ma'ana pwaopwaomi yo ma'ana luwuluwu hawahawawalina hibwaleniyenama, na Pailato bodaone aidiyai iwalo, ‘Towahowa teina am'ita’. ");
INSERT INTO kud2014_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Na taupwaoliwo yadi babadao mayadi taupaihowao Yeisu hi'ita ta hiwuiwui hiwalo, ‘Amtutu yepatu’. Na Pailato aidiyai iwalo, ‘Ambom amlauvai ta amtutuye patu, wuwuna yau nigele teya yana pwanoli yayalobai’. ");
INSERT INTO kud2014_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ta Yudeyaone hiwalouyo, hiwalo, ‘Yama loina neta iya bada mata imwalowoi, wuwuna i'oyama ebeha iya Yaubada Natuna’. ");
INSERT INTO kud2014_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Tenem ainai Pailato walone ibenaledi ta imeheuhi mwala'ina Yudeyaone aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Na hinage Yeisu ilauvaiyoi ta hiluluwune yana vadai na ipanivilaei, iwalo, ‘Owa havaena ulalaomane?’ Na Yeisu nigele hava teya iyawalowei; bada inobu. ");
INSERT INTO kud2014_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ta Pailato iwawalouyone, ‘Nigele yagu panivilane uyayemaiha awa? Na uhanapuiya'o ebeha mayagu loina ta hilivahigo na mayagu loina ta umwalowoi.’ ");
INSERT INTO kud2014_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yeisu iwalo, ‘Nigele teya yam loina aliguwai imiyamiya ebe Yaubada nigele iyatalamwegau alimwai, na hesi uhanapui neta towahone iya itatalamwegaune yam loina ainai, iya ana ve'ewa mwala'ina, na abo owa’. ");
INSERT INTO kud2014_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailato walone tenem ibenalei ta nuwanuwana mwala'ina ebeha Yeisu ilivahi. Na Yudeyaone hiwuiwui mwala'ina hiwalo, ‘Ebe neta towahone ulivahi, owa nigele Sisa ana gelu. Wuwuna neta towahone iwalo ebeha iya tauwasawasa, ainaena tahanapuiya'o ebeha iya Sisa ana aleha.’ ");
INSERT INTO kud2014_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ta Pailato yadi walone ibenalei eeta Yeisu ilauvai ibwaleniyenama ta Pailato imiyatalu yana abamiya talitalini ainai, Yudeyaone yadi yeha neta Gabata. ");
INSERT INTO kud2014_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Na bada mahana ala'alapwahi ainai mulitai abo vali ahubena, na Buidi'wa guyauna hi'ai. Ta Pailato iwalo, ‘Am'ita yami tauwasawasa teina’. ");
INSERT INTO kud2014_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Na hiya hiwuiwui hiwalo, ‘Amtutuye patu’. Hinage Pailato ipanivilauyo, ‘Vedova ta yami tauwasawasa na ebeha hi'oiye mwalowoi?’ Na taupwaoli mwala'idi yana walone hiyemaiha hiwalo, ‘Yama tauwasawasa Sisa ibom’. ");
INSERT INTO kud2014_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Eeta Pailato italam ta ebe Yeisu hi'oiye patu. Tau'alehaone Yeisu hi'abi avivini ta hilalaweine. ");
INSERT INTO kud2014_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ibom ana aiwa lagalagana i'avalai ta hilalaune tupwa ehebo ainai yehanaede ulu'ulu dalavana (na alina Yudeyaena hiwalo Goligota). ");
INSERT INTO kud2014_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ta tenem ainai hi'oiye patu na hinage towatowaho bwau hi'oiye patudi ta hivetowolodine vahalinai, ehebo nima tautuwanaena na ehebo nima eha'ehanaena na Yeisu ahipuwai. ");
INSERT INTO kud2014_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailato ilaulele ta hi'o'oiye patune Yeisu ana aiwa lagalaganane ainai, iwalo: ‘Yeisu towaho Nasaleti iya Yudeya yadi Tauwasawasa’ ");
INSERT INTO kud2014_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Na tupwanane ainai Yeisu hi'oiye patune nigele amwaha daodao Yelusalem ainaena, eeta laulelene Yeisu vahunai himwamwauwiwa Yudeyaone maudoidi hivavahiline, wuwuna alina tonuga ainaena, hilelelene, alina Yudeya alina Loma na alina Gilisi. ");
INSERT INTO kud2014_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Na Yudeya yadi taupwaoli babadadiyao hilaoma ta Pailato ainai hiwalo, ‘Taubada, hava wuwuna ulele uwalo, Yudeya yama Tauwasawasa? Na hesi ebe ulele uwalo teina towahone iwalo ebeha iya Yudeya yadi Tauwasawasa.’ ");
INSERT INTO kud2014_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Na Pailato aidiyai iwalo, ‘Hava yalelelelene imiyamiya lelelelena’. ");
INSERT INTO kud2014_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","24","Na tau'aleha hitau vehopali Yeisu hi'o'oiye patune, ana ale'owa hivaidi ta higuyauwei hibom aidiyai na ana luwuluwu hivai ta hibom hiwalo havena tapulipulihi, wuwuna luwuluwu mwala'ina na tabatabana na nigele ana dahe, eeta ehebo ai'opi'opi hipaihowai dova kati, ta ebe yaiya imugai abo luwuluwunane ivai. Nuwatuwunane dova hipapaihowaine ta ebeha hava Yaubada yana Buki Ve'ahihi ainai iwawaloweiwa ana moiha imahalava haugana iwalo: ‘Agu ale'o higuyauwedi’, na agu luwuluwu hi'ai'opi'opiyedi. ");
INSERT INTO kud2014_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Na Yeisu ana aiwa lagalagana vahalinai waiwaihiu hitau vehopali hitowotowolo, hiya Yeisu hinana matahina yo vali Meli iya Kilopasi mwanena, na hinage Meli Magidalaena. ");
INSERT INTO kud2014_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tenem ainai Yeisu i'itadobi ta hinanane waiwaihiuwone baidanao hitowotowolo i'i'itadine na hinage taumulitawa iya ivelauwei moiha i'i'itane, na hinanane ainai iwalo, ‘Hinagu, natum u'ita’. ");
INSERT INTO kud2014_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Na hinage ana taumulitane ainai iwalo, ‘Augelu, hinam u'ita’. Tenem ainai Yeisu yana mwalowoi tulahanai taumulitawa Yeisu hinanane ilauvai hilau yana vadai ta i'ita avivinine. ");
INSERT INTO kud2014_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Tenem hauganane ainai Yeisu ihanapuiya'o ebeha ginauli maudoina bada hi'ovi'o ta iwalo, ‘Gadogune imaguni’. Ta teina walone ainaena Buki Ve'ahihi yana walomahalava ibwaleni ili'ilimani. ");
INSERT INTO kud2014_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tupwanane ainai waini mayumayuyuna mavedina himwauwi ta imiyamiya, na balou hivai ta hiyebuta we'ahane mavedina ainai na teya aiwa yehanaede hisopa hivai ta baloune mabutabutana hi'atuwomalei na hivelele haeyei Yeisu awanai ta imalahuhuine. ");
INSERT INTO kud2014_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Mulitai Yeisu iwalo, ‘Bada i'ovi'o’. Eeta ulu'uluna iyagelo na yawahina i'o'ovine. ");
INSERT INTO kud2014_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yeisu yo towatowahowowa hitau bwau hitutuye patudi na Yudeyaone adi taumugaiwone hilau ta Pailato ainai hi'awanoi ebe howahowana italam ta aedine higodudi na ebe himwalowoi mwayamwayau ta ebe hi'avala aituluwuwedi adi aiwa lagalaganane aidiyena, wuwuna bada ahubena mwala'ina ilau tebitebiniya'o, eeta hiya nigele nuwadi ebeha towatowahowone besiwa hi'aba'abahi ahubena tapwalolo ainai. ");
INSERT INTO kud2014_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nigele ta Pailato italam ta tau'aleha tupwadi ivetamaledi hilau towatowahowone hitau bwauwa aedine higogodudine, ta himwamwalowoine. ");
INSERT INTO kud2014_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Na haugana hilau Yeisu ainai hilauta'ai, hi'ita bada imwalowoi'o, ta nigele aenane hiyagodudi. ");
INSERT INTO kud2014_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Na hesi ehebo tau'aleha, gitaena luhuluhunai iwowomaline ta 'wahina yo we'aha hisasagenane. ");
INSERT INTO kud2014_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yau ana taumulita teya hava meheguwena ya'i'itadine teina vehabana yawalowalo alimiyai ta ebeha walo moihana teina amhanapui yo amyemidiyedi. ");
INSERT INTO kud2014_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Teina ginauliwone bada hibwaleni'o, ta ebe Buki Ve'ahihi yana walomahalava ibwaleni ili'ilimani, hauganane iwalo, ‘Nigele mata teya hilihiliyanane hiyagodu’. ");
INSERT INTO kud2014_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Na hinage Buki Ve'ahihi yana walomahalava teya iwalo, ‘Towahonane hiwowomaline mata mulitai abo hi'ita’. ");
INSERT INTO kud2014_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ta bada ginauli maudoina hi'ovi'o na ehebo towaho ilaoma ta Yeisu taunane Pailato ainai i'a'awanoiyeine. Iya Alimatiya towahona, yehanaede Yosepa, na hinage iya Yeisu ana taumulita dawadawanina, wuwuna Yudeyaone adi taumugaiwone aidiyai imeheuhi, na Pailato italam Yosepa ainai ta Yeisu tauna ivavaine. ");
INSERT INTO kud2014_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Hinage Nikodimo ilaoma Yosepa ihagui ta Yeisu taunane hivavaine. Iya Nikodimonane mwalona masigiliyena ilau Yeisu ainai ta baidana hi'a'aubabadane, na Nikodimo woloi teya mwala'ina na vitavitaina ivai ta ilawenama, na woloinane ana vitaine dova towaho ana vitai na aiwa bwau aidiyena hipapaihowaine hiya hiwalo mulo yo aloe. ");
INSERT INTO kud2014_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ta towatowahowone hitau bwau Yeisu taunane hivai ta woloinane ainaena hiyewoloi na ale'o daodaodi, na hewahewadi ainaena hihuma woloine baidana, bada dova Yudeyaone yadi yemagai yo yadi atu'atububuni taumwalomwalowoi vehabadi. ");
INSERT INTO kud2014_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na Yeisu yana abamwalowoi vahalinai, teya tanovi, na ainai magai, na magainane nigele teya taumwalowoi hiya mwauwi ainai. ");
INSERT INTO kud2014_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ta magainane ainai Yeisu taunane himwamwauwine, wuwuna vahalidiyai na hinage bada Yudeyaone yadi tapwalolo ana ahubena ilautebitebiniya'o. ");
INSERT INTO kud2014_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Bada wiki ana ahubena mugamugaina ibwaleni'o ta howola maguguyouna, Meli Magidalaena ilau magaiyai ta magaine ana oi'auhi gaima bada hive'iwahiyena'o. ");
INSERT INTO kud2014_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Na isagena iwuyo ta Pita na Yeisu ana gelu moihawa aidiyai iwalo, ‘Badawa magaiyena bada hivaiya'o ta havaidova himwauya'o’. ");
INSERT INTO kud2014_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Eeta taumulitaone Saimoni Pita na Yeisu ana gelu moiha. ");
INSERT INTO kud2014_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Hitau bwau hitowolo na hilalaune magaiyai, na yadi laune ainai hisagesagena mohili ta Yeisu ana gelu moihane itauwahiwahiyala ta imumugaine magaiyai, ");
INSERT INTO kud2014_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ta ipwagogo na i'italuwu magaine holanai ta huma a'ava i'i'itadine hidabadabalala na nigele iyaluwu. ");
INSERT INTO kud2014_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Mulitai abo Saimoni Pita igavaibwaleni ta itau'ali'aliline magaine holanai na hinage humaowone i'i'itadine himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Na ulu'ulunane ana pai na taunane ana huma nigele teya iyabudeyanaedi. ");
INSERT INTO kud2014_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Mulitai abo towahowa taubwaleni mugaiwa iluluwune magaine holanai Pita ainai, ta hinage ale'owone i'itadi ta i'awa moihane. ");
INSERT INTO kud2014_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Na hesi nigele hiyanuwamasele Buki Ve'ahihi yana walomahalava, iwalo, ‘Iya mata itowolouyo’.) ");
INSERT INTO kud2014_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tenem ainai taumulitaone hiwuwuyone yadi vadai. ");
INSERT INTO kud2014_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Na Meli ibom itowolo magaine papalinai i'ai'aimehelino, na mamehelinona ipwagogo ta i'ita luwu magaine holanai. ");
INSERT INTO kud2014_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Na tausagenawasa bwau i'i'itadine ehebo Yeisu aba'ulunai na ehebo aba'aenai himiyamiya na adi luwuluwu hewahewadi. ");
INSERT INTO kud2014_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Na hitau bwau Meli ainai hiwalo, ‘Hava vehabana udoudoune?’ Na aidiyai iwalo, ‘Yagu Bada magaiyena hivaiya'o na nigele yayahanapui havaidova himwamwauwine’. ");
INSERT INTO kud2014_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Iwalo i'ovi na ebeha i'ita gwaipile ta Yeisu vahalinai itowotowolo, na hesi nigele iyahanapui ebeha iya Yeisu. ");
INSERT INTO kud2014_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Eeta Yeisu Meli ainai iwalo, ‘Waihiu, hava vehabana u'ai'aimehelinone, na yaiya ubehabehaeine?’ Na Meli yana nuwatuwu ebeha tanovi ana taupaihowa teya, eeta iwalo, ‘Taubada ebe owa uvavai mahalavaeine uwalo mahalavaei, havaidova ta yavai’. ");
INSERT INTO kud2014_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Na Yeisu Meli yehanane i'atai, iwalo, ‘Meli!’. Na Meli i'ita gwaipile iwalo, ‘Labonai’. (Yudeyaone alinadiyena ana bui neta Tauve'ita.) ");
INSERT INTO kud2014_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yeisu iwalo, ‘Havena aliguwai u'abi'abi. Nigele yayahae Tamagu ainai na hesi ulau ta tahiguwone nuwadiyai umwauwi, yahahae Tamagu ainai na omiu hinage Tamamiu, yagu Yaubada na hinage yami Yaubada.’ ");
INSERT INTO kud2014_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Na Meli ilau taumulitaone aidiyai iwalo, ‘Badawa ya'itaya'o’. Na hava Yeisu iwawaloweiwa, iwalowedine taumulitaone aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Wiki ana ahubena mugamugaina, lavilavinane ainai taumulitaone ehebo vada ainai hiluwu ta awa'edane higudui na holanai himiyamiya, mayadi meheuhi Yudeyaone aidiyai. Na Yeisu ilaoma ahi'ahipudiyai itowolo ta iwalo, ‘Havena ammehemeheuhi’. ");
INSERT INTO kud2014_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mulitai nimana yo luhuluhuna ive'itadi ta hiyaliyaya wuwuna yadi Bada bada hi'itaya'o. ");
INSERT INTO kud2014_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Na hinage Yeisu aidiyai iwalo, ‘Havena ammehemeheuhi, na hesi am'atepatu, wuwuna Tamagu iya ivetamalegauma na yau yavetamalegomiu’. ");
INSERT INTO kud2014_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Iwalo i'ovi na yawahinane iyuvi geyo'awahei aidiyai iwalo, ‘Alu'aluwa Ve'ahihi amvai’. ");
INSERT INTO kud2014_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Na hinage iwalo, ‘Ebe towaho yadi pwanoli amnuwahamuidi, mata Yaubada inuwahamuidi, na ebe nigele, mata besiwa imiyamiya aidiyai’. ");
INSERT INTO kud2014_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomasi iya hitau 12 aidiyena na yehana bwauna Patubwau, haugana Yeisu itaumahalava iya nigele baidadi. ");
INSERT INTO kud2014_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tupwadi hiwalolau Tomasi ainai hiwalo, ‘Yada Bada a'itaya'o’. Na iya iwalo, ‘Neta am'o'oyama, yau ebe ana elowone aidiyai nimagune yamwauwidi yo ya'abisawahidi abo yayemidi’. ");
INSERT INTO kud2014_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wiki ehebo i'ovi na taumulitaone vada ehebonane ainai hiluwu na higudu auhiyoidi ta holanai himiyamiya, na Tomasi baidadi. Na Yeisu ibwalenima ta ahi'ahipudiyai itowolo, na iwalo, ‘Havena ammehemeheuhi’. ");
INSERT INTO kud2014_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Na Tomasi ainai iwalo, ‘Nimagigim utautuwuyama nimagu ainai ta u'ita. Na hinage nimam utautuwuyama luhuluhugu ainai ta umwauwi na havena unuwanuwatuwu bwaubwau na u'awa'awa oya'oyama.’ ");
INSERT INTO kud2014_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Na Tomasi iwalo, ‘Owa yagu Bada yo yagu Yaubada’. ");
INSERT INTO kud2014_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Na Yeisu ainai iwalo, ‘Tomasi bada u'itagau ta uyemidi'o, awa? Na hiya nigele hiya'itagau na hesi hiyemidiyegau mata moiha hiyaliyaya.’ ");
INSERT INTO kud2014_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ta Yeisu aba'ita bahudi ipaihowaidi'o ana taumulitaone mehediyai, na maudoina nigele yayaleledi teina Bukine ainai. ");
INSERT INTO kud2014_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Na bada vihavihadi teina amvahili ta amhanapui yo hinage Yeisu amyemidiyei ebeha iya Yaubada yana Besinana na Yaubada Natuna ta Yeisu yehanaena yawahi miyamiya vateyaina amvai. ");
INSERT INTO kud2014_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yeisu i'abiye mahalavauyoi ana taumulitaone aidiyai Taibiliya ni'unai. ");
INSERT INTO kud2014_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Temdova yana mahalava aidiyai. Ana taumulitaone teina Saimoni Pita yo Tomasi, iya hiwalo Patubwau yo Nataniyela iya yana dalava Kena, neta Galili holanai, na hinage Sebedi natunaone, yo hinage bwau taumulitaone baidadiyao. ");
INSERT INTO kud2014_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tenem ainai Saimoni Pita taumulitaone aidiyai iwalo, ‘Augeluwo, nuwana yalalau yayama’. Na ana geluwone hiwalo, ‘Ehe inamwanamwa, talaowa’. Ta maudoidi higelu wagaena hiwowohene, na tenem boniyainane ainai hiyama ahubena na nigele teya yama hiya'ona. ");
INSERT INTO kud2014_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Na bada malane itomtom ta taumulitaone Yeisu hi'i'itane maguwai itowotowolo, na hesi nigele hiyahanapui ebeha iya Yeisu. ");
INSERT INTO kud2014_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Eeta Yeisu aidiyai iwalo, ‘Tahiguwao viha yamane am'o'onadine?’ Na hiwalo, ‘Nigele’. ");
INSERT INTO kud2014_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Na hinage aidiyai iwalo, ‘Amtaudobi ta vinayane amyahuwei wagane ateyaniyena na yama am'onadi’. Eeta yadi vinayane hiyahuwei na yama bahudi hi'o'onadine, ta nigele howahowadi vinayane hiniulihini. ");
INSERT INTO kud2014_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tenem ainai Yeisu ana taumulitawa iya ana gelu moihawa Pita ainai iwawalone, iwalo, ‘Tenem iya yada Badawa’. Hauganane Pita ibenalei ebeha yadi Badawa, ana luwuluwu ili'wa na idadalahugune ni'uwai. ");
INSERT INTO kud2014_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Na Yeisu ana taumulitaone maudoidi hiwohema vinayane mayamadi hiniulidima ta hidudunane maguwai, wuwuna le'awane nigele amwaha daodao. ");
INSERT INTO kud2014_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ta taumulitaone maguwai hi'aitulu na yama yo beledi hi'i'itadine ali'ahuwai Yeisu bada igabudi'o. ");
INSERT INTO kud2014_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Na hinage Yeisu aidiyai iwalo, ‘Viha hinage ami yama amvaidima na tagabudi?’ ");
INSERT INTO kud2014_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ta Saimoni Pita wagai igeluyo ta vinayawa iniulihini maguwai, na vinayane imwau moiha ta yama ana bagibagili 153 hi'o'onadine na hesi vinayane nigele iyalotapulihi. ");
INSERT INTO kud2014_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Na Yeisu aidiyai iwalo, ‘Amlaoma na am'ai’. Hihanapuiya'o ebeha iya yadi Badawa, ta nigele teya aidiyena iyapanivilaei ebeha ‘Yaiya owa?’ Wuwuna bada hihanapuiya'o. ");
INSERT INTO kud2014_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Eena Yeisu ilau ta belediwa yo yamawa ivaidi ali'ahuwena ta ana taumulitaone imomohedine. ");
INSERT INTO kud2014_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Teina Yeisu yana mahalava tonugana ana taumulitaone aidiyai yana towolouyo tuluhanai. ");
INSERT INTO kud2014_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Hi'ai i'ovi na Yeisu iwawalone Saimoni Pita ainai, iwalo, ‘Saimoni owa Yoni natuna, yam velau imwala'i alili aliguwai, na hiya teina tupwana awa?’ Pita iwalo, ‘Bada uhanapuigau'o ebeha yavelauwego mwala'ina’. Yeisu iwalo, ‘Yagu sipiwone u'ita avivinidi’. ");
INSERT INTO kud2014_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yeisu hinage iwalouyo, iwalo, ‘Saimoni owa Yoni natuna, uvelauwegau mwala'ina?’ Pita iwalo, ‘Ehe, bada uhanapuigau'o ebeha yavelauwego’. Ainaena Yeisu iwalo, ‘Yagu sipiwone u'ita avivinidi’. ");
INSERT INTO kud2014_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yeisu hinage yana walo tonugana Pita ainai iwalo, ‘Saimoni, owa Yoni natuna, uvelauwegau?’ Ta tenem ainai Pita nuwanane iyayababane, wuwuna Yeisu ipanivila mai tonuga ainai, iwalo, ‘Uvelauwegau?’ Na Pita iwalo ainai iwalo, ‘Bada ginauli maudoina uhanapuidi'o, ainaena uhanapuigau'o ebeha yavelauwego’. Ta Yeisu Pita ainai iwalo, ‘Yagu sipiwo u'ita avivinidi. ");
INSERT INTO kud2014_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Yawalo moiha alimwai neta yam hauga heda ainai ubom am luwuluwu uli'wali'wa, na ebe nuwanuwam teya tupwa ainai ulau, mata bada ulau, na mulitai yam hauga yemala tautaubada ainai nimamne utau velele na vali tomowa am luwuluwune hiveli'wago na aiteya tupwa ainai nigele nuwam ulau, tupwanane ainai mata hilawego.’ ");
INSERT INTO kud2014_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Teina walone ainaena Yeisu ilaulau livahi Pita yana mwalowoi vehabana, ta ebe yana mwalowoine ainaena Yaubada yehanane i'abiye mwala'i. Na hinage Pita ainai iwalo, ‘Umulitaegau.’ ");
INSERT INTO kud2014_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita i'ita gwaipile ta teya taumulitawa Yeisu ana gelu moihawa i'i'itane (iya aine hauganane ainai Yeisu vahalinai iduivahali ta ipapanivilaeine, iwalo, ‘Bada yaiya amtauhuhulane’). ");
INSERT INTO kud2014_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Na Pita towahonane i'i'itane, imulimulitaedi ta iwawalone, ‘Bada, teina towahone vedova ana loina?’ ");
INSERT INTO kud2014_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ta Yeisu Pita yana walone iyemaiha iwalo, ‘Ebe nuwanuwagu iya imiyamiya ana higa yawuyoma, neta nigele teya hava, na owa hesi umulitaegau’. ");
INSERT INTO kud2014_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ainaena Yeisu ana taumulitaone teina yana walone hibenalei, eeta hibom aidiyai hi'au'aubabada wuwuna yadi nuwatuwu ebeha taumulitanane mata nigele iyamwalowoi, na Yeisu nigele tenem dova iyawalo, na hesi iwalo, ‘Ebe nuwanuwagu iya imiyamiya ana higa yawuyoma, neta nigele teya hava alimwai’. ");
INSERT INTO kud2014_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Taumulitanane iya ginauliwone teina vehabadi iwawalo mahalavane hinage iya walowone ileleledine teina aubabadane ainai, bada tahanapuiya'o hava iwalo mahalavaedine, walo moiha maudoina. ");
INSERT INTO kud2014_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yeisu yana paihowa ibagibagili alili, na ebe ehebo ehebo taleledi, yanuwatuwui mata buki hibagibagili alili na bale'u tupwa vehopali hi'oiye mwau.");
INSERT INTO kud2014_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiyopilo, bukine yalele mugaiyei holanai Yeisu yana paihowao yo yana ve'itao, hauganane yana paihowa ivetuwuni ");
INSERT INTO kud2014_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ana higa Yaubada ilauvai yo ihahaene galewai. Yeisu yana mwalowoi tuluhanai mayawahina imahalava yana tauyewasao aidiyai, hiya vesivesinuwadi na Alu'aluwa Ve'ahihi yana wahiyalaena adi loina imohedi. ");
INSERT INTO kud2014_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ahubena 40 holadiyai imahamahalava aidiyai, na aba'ita maudoina ive'itadi ainaena yana towolouyo hi'awa moihaei na yana tauyewasao hi'ita na baidanao hi'aubabada neta Yaubada yana Abaloina vehabana ive'itadi. ");
INSERT INTO kud2014_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Howola baidadi himiyamiya na adi loina imohedi iwalo, ‘Havena Yelusalem amlaulaugabaei na hesi Tamadane yana waloyemidine mwalona yawalowena'o vehabana amha'waha'wai. ");
INSERT INTO kud2014_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Amnuwatuwu avivini ebeha Yoni bwahiyena i'abiye bapitaisogomiu na ahubena nigele daodaona na Alu'aluwa Ve'ahihi ainaena bapitaiso amlobai.’ ");
INSERT INTO kud2014_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Haugana Yeisu yana tauyewasao hihulugogoi na hipanivila ainai hiwalo, ‘Bada, howahowana na teina hauga ita Isileli umugaiyegita na tabom taloinauyowegita?’ ");
INSERT INTO kud2014_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Na Yeisu iwalo, ‘Tamagu iya ibom iloiloina na nigele howahowana omiu amhanapui aiteya hauga yana loinane ipaihowaidi. ");
INSERT INTO kud2014_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Na omiu hesi howola abo Alu'aluwa Ve'ahihi ilaoma na i'abiye wahiyalagomiu, na vehabagu ampaihowa na amwalo mahalava Yelusalem ainai yo Yudeya yo Sameliya dalavanao maudoina na bale'u maudoina aidiyai.’ ");
INSERT INTO kud2014_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Haugana walo teina ive'ovidi na hi'ita Yeisu ihaehae galewai, na yaloyalovi i'auhi na mehediyena itau aidawanine. ");
INSERT INTO kud2014_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ta ilaugabaidi na hiya howola hivinuvinunu galewai na towatowaho hitau bwau adi ale'o hewahewadi vahalidiyai hitowotowolo. ");
INSERT INTO kud2014_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Na hiwalo, ‘Omiu Galiliwone, hava vehabana am'ita'ita haene, Yaubada bada Yeisu ilauvaiya'o galewai na howola abo iwuyoma ta ana ita dova hinage yana haene am'i'itane.’ ");
INSERT INTO kud2014_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Olibe oyana ainaena hilau gwaipile Yelusalem neta amwahane nigele iyadaodao wuwuna oyanane neta Yelusalem vahalinai. ");
INSERT INTO kud2014_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Na hiluwu yadi vadai na hihae vada ewanai, na Pita na Yoni yo Yemesa yo Andulu yo Pilipi yo Tomasi yo Batolomiu yo Madiu yo Yemesa Alipiyosi natuna yo Saimoni iya mwalona tauhamadudu abaloina vehabana yo Yudasa iya Yemesa natuna. ");
INSERT INTO kud2014_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Maudoidi teina yadi nuwatuwu ehebo hi'awa'awanoi Yaubada ainai waiwaihiu baidadiyao yo Meli Yeisu hinana na hinage Yeisu tahinao. ");
INSERT INTO kud2014_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Bodaone adi bagibagili dova 120 ehebo ahubena ainai Pita iguguya ahi'ahipudiyai na iwalo, ");
INSERT INTO kud2014_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","‘Tahiguwao mwalona Deivida yana walo Alu'aluwa Ve'ahihi imohei Yudasa Isakaliyota vehabana, na Buki Ve'ahihi ainai imiyamiya, ");
INSERT INTO kud2014_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","na Yudasa mwalona baidada tawalo mahalava Yeisu vehabana na hesi yada Bada ihuhulaei na imohei ana alehao aidiyai’. ( ");
INSERT INTO kud2014_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yudasa bada imwalowoi'o yana paihowa yababana vehabana, na mulitai abo imwalowoi ana maiha ainaena bale'u igimwalai na bale'une holanai ibe'u na diyana italupulihine na hinaena maudoina imahalava. ");
INSERT INTO kud2014_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Na wasana Yelusalem maudoina hibenalei na alinadiyena bale'une yehana himwau Akelidama na ana nuwamasele Bale'u Ma'wahina.) ");
INSERT INTO kud2014_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","‘Dova Buki Sam holanai Deivida yana walo Yudasa vehabana iwalo: “Yana tupwa ova'ova a'avana nigele teya tomowa iyamiyamiya ainai”. Na hinage iwalo: “Tomowa vagana mata ive'aivelaheyei”. Ainaena ilowoinanei walo teina ana nuwamasele moiha imahalava. ");
INSERT INTO kud2014_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","‘Eeta howola abo Yudasa aivelahena yaiya tomowa hauga maudoina imulimulita Bada Yeisu yana hae yo yana dobi aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Na hinage Yoni Yeisu i'abiye bapitaiso hauganane ainai ta ana higa Yeisu yana hae galewai, teina towahonane iya ilaoma ta Yeisu yana towolouyo vehabana ayewasaei.’ ");
INSERT INTO kud2014_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ainaena towatowaho hitau bwau yehadi hi'abihinidi ehebo Yosepa yehana bwauna Basabasi iya hinage hiyogaei Yusito, na bwaunane towaho yehana Madayo. ");
INSERT INTO kud2014_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Eeta hi'awa'awanoi Yaubada ainai hiwalo, ‘Bada ee, owa tomowa maudoidi yadi nuwatuwu uhanapuidi'o ainaena yam vesinuwa towatowaho bwau teina aidiyena uve'itaei alimaiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Na iya mata ibom ivetaupaihowa yo iyewasa Yeisu vehabana, wuwuna Yudasa paihowane ilaugabaina'o na ilau ibom yana tupwai.’ ");
INSERT INTO kud2014_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Na hitaubwauwone ai'opi'opiyena hivesinuwa ta Madayo vesinuwa ainai imiya mahalava eeta iya iluwu tauyewasao yadi boda ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Mulitai Yudeya yadi guyau yehana Penitikosi ana ahubena ainai Yeisu ana tauyemidiwo maudoidi himiya ahaidi. ");
INSERT INTO kud2014_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mai'ehebo na galewaena ehebo dagugu dova yaumai mwala'ina i'aituluma ta vadane i'oiye mwaune. ");
INSERT INTO kud2014_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Na ehebo ginauli hi'i'itane ana ita dova aiwa alahawahawalina vahudiyai itotowane ehebo ehebo ewadiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ainaena maudoidi Alu'aluwa Ve'ahihi i'oiye mwaudi na hivetuwuni ta vali alina yo vali alina aidiyena hi'au'aubabada neta Alu'aluwa Ve'ahihi yana wahiyalaena. ");
INSERT INTO kud2014_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ahubena tenem ainai tautapwalolo Yudeya ainai yo vali tupwa aidiyena bada hilaoma'o na Yelusalem ainai himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Haugana dagugune hibenalei ta boda mwala'ina himiya ahaiyama vadane vahalinai ta aluwadi igavai wuwuna tomowa ehebo ehebo alinana ibenali lobai. ");
INSERT INTO kud2014_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Yadi aluwagavai yo nuwapwanopwano ainaena ta hiwalo, ‘Teina tomowaone tenem dova hi'au'aubabadane neta hiya Galili? ");
INSERT INTO kud2014_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Na vedova ta ita ehebo ehebo yada dalavao alinadi ta benali lobaidine? ");
INSERT INTO kud2014_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Alinane neta Padiya, yo Medi yo Elam yo Mesapotemiya ana taumiyao yo Yudeya yo Kapadosiya yo Ponita yo Esiya yo ");
INSERT INTO kud2014_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Piligiya yo Pamipiliya yo Itipita yo Libiya tupwanao Sailini holadiyai himiyamiya yo Lomaena hilaoma. ");
INSERT INTO kud2014_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Tupwana Yudeya na tupwana nigele Yudeya na hesi yadi tapwalolo ainai hitalamwedi baidadiyao, na hinage Kiliti yo Alebiya na maudoida alinada vagadi na vagadi aidiyena hi'au'aubabada Yaubada yana paihowao wahiwahiyaladi vehabadi.’ ");
INSERT INTO kud2014_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ainaena maudoidi mayadi aluwagavai yo mayadi nuwapwanopwano hibom hipanivilauyowedi hiwalo, ‘Hava wuwuna ta yadi paihowa tenem dova?’ ");
INSERT INTO kud2014_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Na hesi adi geluwo tupwadi hiwalo, ‘Nuwana bwahi wahiwahiyalana hinuma ta hiyayauyaulene’. ");
INSERT INTO kud2014_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pita ana geluwo hitau 11 baidanao hitowolo na Pita ivetuwuni ta alinana mwala'ina aidiyai iguguya iwalo, ‘Omiu Yudeya yo Yelusalem ana taumiyao maudoimiu yagu walo ambenalei na amnuwamasele, ");
INSERT INTO kud2014_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ebeha yama paihowa teina nigele we'aha wahiwahiyalana ainaena, wuwuna howola malatomtom nigele numa yauyaule ana hauga. ");
INSERT INTO kud2014_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Na hesi ginauli teina mwalona tauwalo mahalava Yoeli iwalo mugaiyei, iwalo: ");
INSERT INTO kud2014_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Yaubada iwalo: Howola hauga yana aba'ovi ainai Alu'aluwagu ya'atuhiwai tomowa maudoidi aidiyai, na natumiyao towatowahodi yo waiwaihiudi hiwalo mahalava yo yami hevahevaliwo hi'eno mehe'ita'ita na yami babadao hi'eno nivinivi. ");
INSERT INTO kud2014_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Walo moiha hauga teina ainai Alu'aluwagu ya'atuhiwai yagu taupaihowao towatowaho yo waiwaihiu aidiyai na vehabagu hiwalo mahalava. ");
INSERT INTO kud2014_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Na yagu paihowao abanuwapwanopwano yave'itaedi galewai yo hinage ila'ilala bale'uwai ya'abiye mahalavadi dova 'wahina yo aiwa alahawahawawalina yo asu badobadona, ");
INSERT INTO kud2014_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","yo mahana iguguyou yo wai'ena ana ita iyemala'wahina na mulitai Bada yana ahubena mwala'ina na namanamalina imahalava. ");
INSERT INTO kud2014_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Na ainaena ebe yaiyadiwo Bada yehanaena hiyogayoga ainai ilivahidi ta'i.” ’ ");
INSERT INTO kud2014_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pita hinage iwalo, aidiyai, ‘Augeluwo omiu Yudeya, teina walowone ambenaledi Yeisu Nasaletiyena, Yaubada yana wahiyala yo yana ala'alawowoli yo yana ve'ive'ilala mehemiyai i'abiye mahalava ta ainaena Yaubada yana vesinuwa iyemala moiha. Ita teina ta hanapuiya'o wuwuna alidai ivetuwuni. ");
INSERT INTO kud2014_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yaubada mwalona Yeisune vehabana iloina na hava bale'uwai mata ilobai Yaubada ihanapu mugaiyei na omiu amhuhulaei, ta yami loinaena tomowa tauyababa aiwa lagalagana ainai hiyemwalowoine. ");
INSERT INTO kud2014_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Na Yaubada mwalowoi yana tupwa vitaina ainaena ihahaguine na i'abiye towolouyoi, wuwuna nigele howahowana na mwalowoi yana tupwa ainai imiya vateyai. ");
INSERT INTO kud2014_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Teina vehabana mwalona Deivida Yeisu yana walo iwalo mugaiyei, iwalo: “Bada ya'ita meheguwai imiya vateyai na nimatautuwaguwai imiyamiya, na i'abiye wahiyalagau na havena yatapitapiya. ");
INSERT INTO kud2014_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ainaena yayaliyaya mwala'ina na yano'owei yo yanuwatuwu avivini ebeha havena taugu ipwahapwaha. ");
INSERT INTO kud2014_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Yau nigele mata bwebweso ainai alu'aluwagu umwaumwau vateyai taumwalowoi yadi dalavai nuwana hinage taugu ipwaha. ");
INSERT INTO kud2014_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Na hesi yawahi namwanamwana yana amwaha uve'itaei aliguwai. Ainaena mehemwai u'abiye yaliyaya vateyaigau.” ’ ");
INSERT INTO kud2014_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Na Pita iwalo, ‘Tahiguwao walo teina nigele tubuda Deivida vehabana, wuwuna Deivida tahanapuiya'o ebeha mwalona bada imwalowoi'o ta himwauya'o magaiyai na teina ta'i ana magaine imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Deividanane tauwalo mahalava ehebo na Yaubada yana waloyemidi ainai inuwatuwu avivini ebeha howola Deivida tubuna ehebo Deividanane yana abaloina ivai Yaubada ainaena. ");
INSERT INTO kud2014_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ainaena Besinanane yana towolouyo ihanapu mugaiyei na iwalowei ebeha havena Bwebweso ainai imiyamiya alili na hinage tauna havena ipwahapwaha. ");
INSERT INTO kud2014_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","‘Teina Yeisunane bada mwalowoiyena Yaubada i'abiye towolouyoiya'o na ai maudoimai a'itaya'o. ");
INSERT INTO kud2014_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ainaena Yaubada i'abihini ta nima tautuwanai imiyamiya na ibom Alu'aluwa Ve'ahihinane Yaubada mwalona iwalo yemidiyei na teina hauga bada imohegai'o ainaena paihowa teina am'ita'itadi yo ambenabenaledi ibom ainaena hilalaomane. ");
INSERT INTO kud2014_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Wuwuna nigele Deivida iya yana hae galewa vehabana iyawalowalo, na hesi iwalo: “Yaubada bada iwalo'o yagu Bada ainai, ‘Nimatautuwaguwai umiya ");
INSERT INTO kud2014_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ana higa am alehao yamwau'ituluwedi aem ana abamwau ainai’.” ");
INSERT INTO kud2014_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","‘Teina wuwuna Isileli maudoimiu amhanapui moiha ebeha Yaubada Yeisu bada i'awa Badaena'o ibom Besinana towahona na Yeisunane bada amtutuye patuya'o aiwa lagalagana ainai.’ ");
INSERT INTO kud2014_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tomowaone Pita yana walo hibenalei na vehabana hinuwanuwatuwu mwala'ina, na Pita ma'ana geluwo aidiyai hipanivila, hiwalo, ‘Tahimaiyao, bada alauhapuli'o. Vedova yama paipaihowa?’ ");
INSERT INTO kud2014_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Na Pita iwalo, ‘Yami paihowa yababadi aidiyena amnuwabui na maudoimiu Yeisu Besinana yehanaena avebapitaisogomiu na yami yababao inuwatuwuhamuidi na Alu'aluwa Ve'ahihi imohegomiu. ");
INSERT INTO kud2014_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Wuwuna Yaubada yana waloyemidine ebeha omiu vehabamiu, yo natumiyao hinage vehabadi, yo hiya amwaha daodaowai himiyamiya vehabadi yo yaiyadiwo Yaubada iyogaedi ainai.’ ");
INSERT INTO kud2014_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita yana walo yo yana guguya maudoina aidiyena iwalo mahalava iwalo, ‘Augeluwo, yaso teina yababana ainaena amhaguiyoigomiu’. ");
INSERT INTO kud2014_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Eeta ahubenanane ainai tupwana tomowa Pita yana walo hibenalei ta hibapitaiso na adi bagibagili dova tausani tonuga. ");
INSERT INTO kud2014_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tauyewasaone yadi ve'ita yo yadi ve'awa'au'augelu aidiyai hitalamweuyoidi. Na pwalawa aitomtomna ainai Yeisu abanuwatuwu avivinina hipaipaihowai na hitapwatapwalolo. ");
INSERT INTO kud2014_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Na maudoidi Yaubada hive'ahihiyei, na tauyewasao yadi paihowao abanuwapwanopwano na vedevedede maudoidi hipaihowaidi. ");
INSERT INTO kud2014_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tauyemidiwone maudoidi himiyamiya vahaliuyoidi na hivetobwatobwa ehebo. ");
INSERT INTO kud2014_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Na ebe yadi abaloina dalavai himiyamiya hivegimwalaedi na ginaulidine adi maihaena hi'aiyauyaedi hiya nigele yadi tobwatobwa aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ainaena ahubena ehebo ehebo aidiyai mayadi atetalam hitapwatapwalolo Yelusalem yadi vada tapwalolo mwala'ina ainai, na hibom yadi vadai mayadi yaliyaya hi'ai'aitoyawa. ");
INSERT INTO kud2014_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Na Yaubada hiwalowalo vetuvehaeyei na hinage boda maudoina tauyemidiwone hi'awa'awa namwanamwaedi. Na ahubena ehebo ehebo aidiyai Yaubada tupwana tomowa hinage ilivalivahidi, na tauyemidiwo adi boda imwalamwala'i. ");
INSERT INTO kud2014_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Teya lavilavi ainai, Pita na Yoni hihaehae Yelusalem vada tapwalolo mwala'ina ainai habi awanoi wuwuna neta awanoi ana hauga. ");
INSERT INTO kud2014_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tenem hauganane ainai ehebo towaho ae peupeuna na iya yana hauga tubui hinana diyanai ma'ae peupeuna eeta ana geluwo ahubena ehebo ehebo aidiyai hi'ava'avalaiyama vada tapwalolone ana awa'eda mwala'ina yehana Awa'eda Ausala ainai himwaumwauwi. Na hagu i'awa'awanoi vada tapwalolo ana tauluwuwo aidiyai. Tenem dova hauga bagibagilina ipaipaihowai. ");
INSERT INTO kud2014_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Na ae peupeunane Pita na Yoni i'itadi hiluwuluwu na hagu vehabana i'awanoi aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Eeta Pita na Yoni hivinuvinunui ta Pita iwalo, ‘Uvinunuigai’. ");
INSERT INTO kud2014_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ainaena ae peupeunane ivinuvinunuidi mayana yemidi ebeha hava mata himohei. ");
INSERT INTO kud2014_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Na Pita iwalo, ‘Nigele yagu mane, na teina velaune yamohego. Besinana Yeisu towaho Nasaleti yehanaena yaloinaego na utowolo ta ulau’. ");
INSERT INTO kud2014_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Na nimatautuwanaena i'abiye towolone, na aena yo aetutulina ana tubweuwo maudoina hiwawahiyalane. ");
INSERT INTO kud2014_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Na igavai hae yo idobi italutowolo yo ilau. Abo itautau gavagavai na Yaubada ino'ino'owei na Pita na Yoni baidanao hiluwu vada tapwalolo mwala'ina ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Na boda hi'ita ae peupeunane ilaulau mayana walo vetuvehae Yaubada ainai, ");
INSERT INTO kud2014_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","hi'atai ebeha ae peupeunane mwalona vada tapwalolo ana awa'eda ainai imiyamiya na i'awa'awanoi ana hagu vehabana, na nuwadi ipwanopwano yana namwanamwauyo vehabana. ");
INSERT INTO kud2014_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ae peupeunawa Pita na Yoni i'abi avivinidi vada tapwalolo pepenai, himwauwi yehana Solomoni yana tupwa, na bodaone mayadi nuwapwanopwano hisagena ahaiyama aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Na Pita i'itadi, eeta bodaona iwalo aidiyai. ‘Omiu Isileli, hava vehabana nuwamiu ipwanopwano na amvinuvinunugai? Nigele ai yama wahiyalaena bo nuwana yama mumuga dumwaluna ainaena towaho teina a'abiye namwanamwa ta itau gavagavaine. ");
INSERT INTO kud2014_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Na hesi Yaubada yana wahiyalaena iya Abelaham yo Aisake yo Yakobo yadi Yaubada na tubudao yadi Yaubada na Yaubada yana taupaihowa yehana Yeisu i'abihini iya mwalona Pailato nuwanuwana ilivahi na omiu amuvalaei na am'awa yabayababaei Pailato mehenai. ");
INSERT INTO kud2014_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Walo moiha Yeisu ibom taudumwalu na masemaselena amta'wata'wataei ta tomowa yadi tau'oiye mwalowoi nuwanuwamiu ta vehabana Pailato ainai am'awanoiyei. ");
INSERT INTO kud2014_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Neta yawahi namwanamwana ana Tau'aiyauya am'oiye mwalowoine na Yaubada ibom mwalowoiyena i'abiye towolouyoi na maudoimai a'itaya'o. ");
INSERT INTO kud2014_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ainaena towaho teina bada inamwanamwa'o ta am'itaya'o na amhanapuiya'o neta yemidi Besinana yehanaena mehemiyai inamwanamwa moiha na iwahiyala'o. ");
INSERT INTO kud2014_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","‘Tahiguwao yahanapuigomiu'o ebeha yami nuwapwanopwanowena Yeisu am'oiye mwalowoi dova yami babadao. ");
INSERT INTO kud2014_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Na amnuwatuwu avivini ebeha Yaubada yana tauwalo mahalava aidiyena hiwalo mahalava mugai ebeha Besinanane yana muyamuya ilobaidi ainaena walonane ana moiha bada imahalava'o. ");
INSERT INTO kud2014_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Eeta ilowoinanegomiu ebe amnuwabui ta yami lauhapuliwone ivai gabaedi na lautowoi namwanamwana amlobai Bada ibom ainaena. ");
INSERT INTO kud2014_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Hinage Besinanane ibom ivesinuwa mugaiyei vehabana ivetamalei alimiyai, neta Yeisu. ");
INSERT INTO kud2014_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Iya bada galewai ihae'o na imiyamiya ana higa ginauli maudoidi i'abiye dumwaludi dova Yaubada yana tauwalo mahalavao ve'ave'ahihidi mwalona hiwalo mahalava mugaiyei. ");
INSERT INTO kud2014_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mwalona Mosese hinage iwalo yemidi iwalo: Mata howola yada Bada Yaubada alimiyena ehebo towaho i'abihini na ivetauwalo mahalava vehabamiu dova yau i'abihinigau na yana walomahalava maudoina ambenaledi'o. ");
INSERT INTO kud2014_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Na ebe yaiyadiwo tauwalo mahalavane yana walo hita'wata'wataei Yaubada i'abiye yababadi yo ivaigabaedi yana tomowa aidiyena. ");
INSERT INTO kud2014_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Tauwalo mahalavao Samwela yana haugai na ivetuwuni ta ihahaemane neta hava hiwawalowediwa wau hivevetuwuni. ");
INSERT INTO kud2014_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Na omiu tauwalo mahalavaone tubudiyao ainaena Yaubada waloyemidi tubudane Abelaham imohei iwalo, “Owa yam huhu wena howola abo abaloina maudoina bale'uwai awanamwanamwa yamohedi”. Ainaena awanamwanamwane omiu hinage vehabamiu. ");
INSERT INTO kud2014_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Na Yaubada yana taupaihowa Yeisu mwalowoiyena i'abiye towolouyoi ta omiu Yudeya alimiyai ivetamale mugaiyei na ebe yami lauhapuliwone vehabadi amnuwabui neta yana awanamwanamwa alimiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita na Yoni howola hi'au'aubabada boda aidiyai na taupwaoliwo yo vada tapwalolo ana tuilala mwala'ina, yo hinage Sadusiyao hilaoma, ");
INSERT INTO kud2014_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","mayadi modi'ini wuwuna Pita na Yoni boda hive'itadi ebeha Yeisu mwalowoiyena itowolouyo'o na ainaena mata tomowa maudoida tatowolouyo. ");
INSERT INTO kud2014_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Eeta hi'abi avivinidi ta vada paipaiyai himwauwidi na ebeha i'ahubena abo yadi lauvetala hipaihowai, wuwuna bada iboni'o. ");
INSERT INTO kud2014_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Na hinage yadi guguya bodaone bada hibenalena'o ta tupwana boda hiyemidi, ainaena tauyemidi maudoidi towatowaho adi vahivahili 5,000. ");
INSERT INTO kud2014_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","I'ahubena ta Yudeya yadi tauloinao yo yadi babadao yo loina ana tauve'itao himiya gogoidi Yelusalem. ");
INSERT INTO kud2014_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Na hinage Anasa ibom taupwaoli mwala'ina mayana huhuwo yo yana bodao neta Kayapasi yo Yoni yo Alekisana baidadiyao himiya gogoidi. ");
INSERT INTO kud2014_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ta Pita na Yoni ahi'ahipudiyai hitowolo na hipanivilaedi, hiwalo, ‘Yami paihowa teina yaiya yana wahiyalaena yo hinage yaiya yehanaena ampaipaihowaine?’ ");
INSERT INTO kud2014_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Na Pita Alu'aluwa Ve'ahihi i'oiye mwau na iwalo aidiyai, ‘Yama tauloinao yo yama babadao, ");
INSERT INTO kud2014_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","nuwana yamalauvetala wau wuwuna ae peupeunane ahahaguine yo ebeha vedova ta a'abiye namwanamwane? ");
INSERT INTO kud2014_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Eeta nuwanuwamai omiu yo Isileli maudoimiu amhanapui ebeha towaho teina mehemiyai itowotowolone yana namwanamwa Yeisu Besinana ainaena, ibom towaho Nasaleti, aiwa lagalagana ainai am'oiye mwalowoi na Yaubada i'abiye towolouyoine. ");
INSERT INTO kud2014_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yaubada yana Buki iwalowalo Yeisu vehabana iwalo: “Tau'abi vada omiu logidi teina amta'wata'wataeiwa neta itaugwaipile ta logidi haehae alilina”. ");
INSERT INTO kud2014_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nigele teya yaiya howahowana na ilivahigita. Neta bada Yeisu ibom. Wuwuna nigele ehebo teya dova yeha bale'uwai iyamiyamiya na ainaena livahi talobai. ");
INSERT INTO kud2014_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Na tauloinaone hi'ita Pita na Yoni yadi atepatu, na hihanapuiya'o neta hibom bada taumiya dalava na abase'ulu mwala'ina aidiyai nigele hiyaluwu, ainaena nuwadi ipwanopwano na hinuwatuwu avivini ebeha mwalona Yeisu baidadi himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Na hinage ae peupeunane bada inamwanamwa'o hi'ita lau vahalidiyai itowotowolo, ta nigele howahowana ebeha hava hiwalowei. ");
INSERT INTO kud2014_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ainaena Pita na Yoni hivetamaledi ta hi'aitulu maseleyai na tauloinaowone hibom hi'ulewahi. ");
INSERT INTO kud2014_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Na hiwalo, ‘Vedova taloina towatowaho teina hitau bwau vehabadi, wuwuna Yelusalem maudoidi hinanapuidi'o ila'ilala mwala'ina bada hipaihowaiya'o na nigele howahowana tauvalaei. ");
INSERT INTO kud2014_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Na hesi tatowoi na mumuga teina ta'auhi na havena idabadabalala boda maudoidi aidiyai, eeta taloina wahiyala aidiyai na havena Yeisu yehanaena tomowa aidiyai hi'au'aubabada.’ ");
INSERT INTO kud2014_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Hiyogaedima na hiluwuyo aidiyai na hiloinaedi ta ebe havena Yeisu yehanaena hi'au'aubabada yo hive'ive'ita tomowa aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Hesi Pita na Yoni yadi walo hiyemaihadi, hiwalo, ‘Omiu ambom am'ita sipwai aiteya Yaubada mehenai idumwalu, a'awa abiye gomiu, bo Yaubada a'awa abiyei. ");
INSERT INTO kud2014_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Na ai nigele howahowamai na yama walo ilaumwau ginaulidine a'itadi'o yo abenaledi'o vehabadi.’ ");
INSERT INTO kud2014_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tauyewasaone walo auhi wahiwahiyalana himohedi na hi'abigabaedi ta hilalaune. Nigele howahowana ta hipaidi wuwuna hava imahamahalavane vehabana tomowa maudoidi Yaubada hino'owei. ");
INSERT INTO kud2014_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Wuwuna ae peupeunane ana bolimai 40 na tupwana bada hi'abiye namwanamwaya'o. ");
INSERT INTO kud2014_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pita na Yoni himahalava na hilau adi geluwo aidiyai na taupwaoliwo mwala'idi yo babadao yadi walo hiwalo mahalavaedi. ");
INSERT INTO kud2014_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Na adi geluwone hibenalei ta maudoidi nuwadi ehebo na hitapwalolo Yaubada ainai hiwalo, ‘Bada, owa Tauwasawasa, galewa na bale'u yo ni'u na ginauli maudoina holadiyai himiyamiya tauyemaseledi, ");
INSERT INTO kud2014_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ainaena yam taupaihowa neta tubumai Deivida Alu'aluwa Ve'ahihi yana wahiyalaena yam walo iwalo mahalavaei iwalo: “Hava wuwuna abaloina maudoina Bada ainai hive'aleha. Na hinage hinuwanuwatuwu awawa? ");
INSERT INTO kud2014_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ainaena bale'u yadi tauwasawasao yo yadi tauloinao himiya ahaidi na hi'atububuni habi aleha Bada yo yana Besinana aidiyai.” ");
INSERT INTO kud2014_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","‘Walo moiha dalava teina holanaena hilaoma habi aleha yam taupaihowa masemaselena yo Besinana ibom Yeisu ainai. Hibom tau'alehaone neta Helodi yo Ponitiyo Pailato yo Yudeya yo hinage nigele Yudeya. ");
INSERT INTO kud2014_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Na hipapaihowaine hava dova owa yam ala'alawowoli yo yam nuwatuwu mwalona uloina na hipaihowaidi'o. ");
INSERT INTO kud2014_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Bada ee, yadi walo manimanini yam taupaihowao alimaiyai havena ubenabenaledi na hesi u'abiye wahiyalagai, na mayama atepatu yam walo ayewasaei. ");
INSERT INTO kud2014_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Na hinage yam wahiyalaena tau'asiyebwao uhaguidi, yo u'abiye namwanamwadi. Yam taupaihowa Yeisu vesivesinuwana yehanaena ve'ive'ilalao yo vedevedede u'abiye mahalavadi.’ ");
INSERT INTO kud2014_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Yadi awanoi teina hive'ovidi na vada ainai himiyamiyawa imwahali, na maudoidi Alu'aluwa Ve'ahihi yana wahiyalaena i'oiye mwaudi. Na Yaubada yana walo hiwalo mahalavaei. ");
INSERT INTO kud2014_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tauyemidi maudoidi yadi nuwatuwu yo yadi velau ehebo. Nigele teya yaiya iyawalo, ‘Yau teina yagu ginauli’. Na hesi yaiya ginauli yehana itanitaniwagaeine neta maudoidi vehabadi. ");
INSERT INTO kud2014_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Na hinage Bada Yeisu yana tauyewasao hiwahiyala alili yana towolouyo ana walomahalava vehabana, na maudoidi hivelau toyatoyawa. ");
INSERT INTO kud2014_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Na hinage maudoidi ma'adi yo ma'adi ale'o, wuwuna vewasawasao aidiyena bada yadi bale'u yo yadi vadao hivegimwalaedi'o. ");
INSERT INTO kud2014_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Na adi maiha maudoina hivaiyama na himohedi Yeisu yana tauyewasao, aidiyai na hibom hi'aiyauya yaiyadiwo himiya vitai aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Towaho ehebo Saipilosiyena yehana Yosepa na yehana vauvauna tauyewasao himohei Banabasi, neta ana nuwamasele, ‘Tau'abiye atepatu’, iya Livai yana huhu ehebo. ");
INSERT INTO kud2014_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Na ibom yana tanovi ivegimwalaei na manenane ivaiyama na imohedi Yeisu yana tauyewasao aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Towaho ehebo mamwanena yadi tanovi higimwalaei, na manena hivaiyama. Towahonane yehana Ananayasi na mwanenane Sapaila. ");
INSERT INTO kud2014_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Hitaubwaune hiloina ta tupwana mane hidawani, na ana tupwa Ananayasi ivaiyama tauyewasaone aidiyai, na i'oyama iwalo teina tanovi manena maudoina. ");
INSERT INTO kud2014_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Eeta Pita iwalo auline, ‘Ananayasi hava vehabana Tomodulele nuwam ivai na tanovi ana maiha tupwana umwaudawanine? Neta yam oyama Alu'aluwa Ve'ahihi ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mwalona nigele uyavegimwalaei, tanovine owa yam abaloina, hinage hauganane uvegimwalaei manena owa yam abaloina. Na hava vehabana atemwai unuwanuwatuwu dawani mane vehabana na u'oyama. Na yam oyama teina nigele alimaiyai yo tomowa aidiyai, na hesi Yaubada ainai.’ ");
INSERT INTO kud2014_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pita yana walo teina Ananayasi ibenalei na ibe'u ta imwamwalowoine. Ainaena tomowa maudoidi wasane hibenalei na himeheuhi mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Na hevahevali hilaoma ta tauna ale'owena hihuma na hi'avala mahalavaei ta magaiyai himwamwauwine. ");
INSERT INTO kud2014_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Dova mahana hawahawagana tonuga hi'ovi na mwanenane imahalava ta nigele iyahanapui hava imamahalavane. ");
INSERT INTO kud2014_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Na Pita ipanivilaei iwalo, ‘Sapaila, yami tanovine amvegimwalaeine, viha ana maiha amvavaine? Dova mwanem iwalo alimwai?’ Na Sapaila iwalo, ‘Ehe moiha, neta dova’. ");
INSERT INTO kud2014_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Eeta Pita iwalo, ‘Vedova ta amtau bwau ebeha Bada Alu'aluwana amtowoi? Ubenalei, mwanemne ana taumagaiwone hiluluwuma na hi'avala mahalavaego hinage yam oyama vehabana.’ ");
INSERT INTO kud2014_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Mai ehebo na Sapaila ibe'u Pita aenai, ta imwamwalowoine na hevahevaliwone hiluwuma ta hi'ita bada imwalowoi'o, ta hi'avalai na hilau himagaiyai mwanenane vahalinai. ");
INSERT INTO kud2014_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ainaena tauyemidi maudoidi himeheuhi mwala'ina na hinage yaiyadiwo wasanane hibebenaleine hinage himeheuhi. ");
INSERT INTO kud2014_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Hinage boda ahi'ahipudiyai Yeisu yana tauyewasao ala'alawowoli na ila'ilala bagibagilidi hi'abiye mahalavadi. Na tauyemidi maudoidi himiya ahaidi vada tapwalolo ainai, Solomoni yana tupwai. ");
INSERT INTO kud2014_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Na boda maudoidi himeheuhi ta nigele hiyaluwu tauyemidi baidadiyao, na tomowa maudoidi tauyewasao hive'ahihiyedi na hino'owedi mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Na hesi tauyemidiwone yadi boda imwalamwala'i towatowaho yo waiwaihiu yaiyadiwo Bada hiyemidiyei neta hiluwuluwu. ");
INSERT INTO kud2014_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tauyewasao yadi paihowa aidiyena na tau'asiyebwao hilauvaidima ta amwahai gwalatau yo halabi aidiyai hiveve'enodine. Ebe Pita yana lau ainai, na mahana ihinali ta alu'aluwana italu tau'asi'asiyebwaone aidiyai mata hinamwanamwa. ");
INSERT INTO kud2014_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Hinage dalavaone Yelusalem vahalinai adi taumiyao himiya ahaidima na yadi tau'asiyebwao yo tupwadi yaiyadiwo alu'aluwa yababadi hi'abiye asiyebwadi hivaidima ta maudoidi hi'abiye namwanamwadi. ");
INSERT INTO kud2014_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Taupwaoliwo yadi babadao mwala'idi yo Sadusiyao yadi boda baidadiyao himanini na hi'alomagigiliyedi. ");
INSERT INTO kud2014_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ainaena hitowolo na Yeisu yana tauyewasao hi'abi avivinidi na vada paipaiyai himwamwauwidine. ");
INSERT INTO kud2014_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Na boniyaiyena Bada yana tausagenawasa vada paipai ana awa'eda iho'e na ilauvaidi ta himamahalavane. ");
INSERT INTO kud2014_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Na iwalo aidiyai, ‘Amlau vada tapwalolo ainai ta nemai amtowolo yo tomowa aidiyai walone yawahi namwanamwadi vehabadi amguguyaedi’. ");
INSERT INTO kud2014_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ainaena tausagenawasa yana walo hibenalei na i'ahubena ta vada tapwalolo ainai hiluwu, na boda hive'ive'itadi. Taupwaoli mwala'ina yo ma'ana geluwo Isileliwone babadadiyao hiyogaedi yo hiya tau'ulewahi himiya ahai, neta Isileliwone yadi boda mugamugaina. Na maudoidi hiyogaedima ta yadi taupaihowa vada paipaiyai tupwana hivetamaledi ta Yeisu yana tauyewasao hilauvaidima, na hilauvetala mehediyai. ");
INSERT INTO kud2014_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Na hilau ta vada paipai a'avana hi'i'itane, na hiwuyoma hiwalo, ");
INSERT INTO kud2014_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","‘Vada paipai guduguduna a'i'itane, na ana tau'ita aviviniwone hitowotowolo awa'edane ainai, na hauganane awa'edane aho'e alonane nigele teya tomowa aya'ita.’ ");
INSERT INTO kud2014_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Na vada tapwalolo ana tau'ita avivini mwala'idi yo taupwaoliwo mwala'idi wasa hibenalei ta hi'atehawawali mwala'ina, hava mata imahalavane. ");
INSERT INTO kud2014_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ainaena ehebo towaho aidiyai ilaoma iwalo, ‘Tomowaone vada paipaiyai ammwamwauwidiwa, vada tapwalolo ainai hive'ive'ita boda aidiyai’. ");
INSERT INTO kud2014_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Eeta vada paipai taniwagana yana hevali baidana hilau ta tauyewasaowa hilauvaidi ta hiwuwuyone. Na hesi nigele hiyatotoyaidi wuwuna himeheuhi hiwalo mata tomowa himodi'ini na tau'ita aviviniwone hive'alagaimaidi. ");
INSERT INTO kud2014_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tauyewasaone hiluwuwedi ta tau'ulewahiwo mehediyai hivetowolodi. Na taupwaoli yadi tauloina ipanivilaedi, iwalo, ");
INSERT INTO kud2014_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","‘Walo'auhi wahiwahiyalana amohegomiu'o, awalo havena Yeisu yehanaena amve'ive'ita boda aidiyai. Na am'itaya'o hava ampapaihowaine? Yami ve'ita amtaluye dabalala ta Yelusalem i'oiye mwau, na teina towahone yana mwalowoi vehabana ebeha amve'ewaigai.’ ");
INSERT INTO kud2014_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Na Pita yo tauyewasao tupwadi hiwalo, ‘Ilowoinanegai na Yaubada yana walo amulitaei na havena tomowa yadi walo. ");
INSERT INTO kud2014_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Walo moiha omiu Yeisu aiwa ainai amtutuye patu na ana higa imwalowoi, na tubudao yadi Yaubada Yeisu i'abiye towolouyoine, ");
INSERT INTO kud2014_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","na i'abihini nimatautuwanai imwamwauwine ta ibom Taumugaiyegita yo Taulivahigita, ta ebeha tanuwabui, na ainaena ita Isileliwone yada yababa inuwahamuidi. ");
INSERT INTO kud2014_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Eeta ai ginauli teina vehabadi awalowalo mahalava na hesi Alu'aluwa Ve'ahihi ibom tauwalo mahalava, iya Yaubada yana aiyauya ana tau'awa abiwo alidai.’ ");
INSERT INTO kud2014_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Na tauloinao Yeisu yana tauyewasao yadi walo teina hibenaledi, na adi modi'i'ini moiha, na nuwanuwadi ta hi'oiye mwalowoidi. ");
INSERT INTO kud2014_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Na ehebo aidiyena yehana Gameliyela ibom Palisi na loina ana tauve'ita, na ma'ana ve'ahihi tau'ulewahiwo bodadi aidiyai, itowolo na iloina ta ebeha Yeisu yana tauyewasao himahalavaedi hauga ubwa'ubwana ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ainaena mulitai iwalo tauloinao aidiyai, ‘Omiu Isileli ee, am'ita avivinigomiu na havena amloiloina wahiyala teina tomowaone aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Amnuwatuwu avivini haugana mwalona Tudesi imahalava ebeha ibom taumugai vagana ehebo, na tomowa adi bagibagili dova 400 hiluwu yana boda ainai, na hesi Tudesinane hi'oiye mwalowoi, na ana taumulitao hitaubudebudeyanaedi, na yadi boda i'o'ovine. ");
INSERT INTO kud2014_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","‘Na mulitai tomowa vahilina haugana ainai, ehebo hinage towaho Galiliyena itowolo mahalava yehana Yudasa na tomowa tupwadi iniulidi na himumulitaeine. Iya hinage tomowa tupwadi hi'oiye mwalowoi na ana taumulitaone hilolo'uhagwaline. ");
INSERT INTO kud2014_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","‘Ainaena teina hauga yawalo alimiyai, ebeha havena hava amloiloina towatowaho tenem vehabadi. Ebe adi loina nuwana yadi paihowa teina tomowa aidiyena imahalava, howola abo hitapiya. ");
INSERT INTO kud2014_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Na hesi ebe yadi loina Yaubada ainaena imahalava, nigele howahowamiu na am'auhidi, wuwuna mata dova ta Yaubada amve'alehaei.’ ");
INSERT INTO kud2014_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Eeta Gameliyeli yana loina himulitaei, na tauyewasao hiyogaedima aidiyai, na hisapidi, na hiwalo, ‘Havena Yeisu yehanaena am'au'aubabada tomowa aidiyai’. ");
INSERT INTO kud2014_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Na tau'ulewahiwo hilaugabaidi, yo hilau hibom yadi boda aidiyai mayadi yaliyaya, wuwuna howahowana muyamuya hilobaidi Yeisu yehanaena. ");
INSERT INTO kud2014_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ahubena ehebo ehebo aidiyai himiyamiya ahai vada tapwalolo mwala'ina holanai na hinage tomowa yadi vada aidiyai Yeisu ibom Besinana towahona wasana namwanamwana hive'ive'itaei yo higuguguguyaei. ");
INSERT INTO kud2014_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Haugana tenem ainai Yeisu yana boda imwalamwala'i, ta Gilisiwone Yudeyaone baidadiyao hiveta'eta'e. Gilisiwone hiwalo ai'ai ana aiyauya ahubena ehebo ehebo aidiyai yadi hiwahiwapewo hi'ita'ita di'wadi'waidi. ");
INSERT INTO kud2014_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ainaena Yeisu yana tauyewasao hitau 12 tauyemidiwo maudoidi hiyogaedima na hiwalo, ‘Nigele howahowana Yaubada yana walo ana guguya alaumwauwi na ebeha ai'ai a'aiyauya. ");
INSERT INTO kud2014_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Eeta tahimaiyao, omiu alimiyena towatowaho hitau 7 amvesinuwaidi, yaiyadiwo ma'adi ve'ahihi, na hanahanapudi, na hinage ebeha Alu'aluwa Ve'ahihi yana wahiyala aidiyai, ta paihowa teina ai'ai ana aiyauya vehabana tavetowolodi. ");
INSERT INTO kud2014_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Na ai a'aipate awanoi vehabana, na hinage Yaubada yana walo ana ve'ita vehabana.’ ");
INSERT INTO kud2014_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Boda maudoidi hiyaliyaya yadi loina teina vehabana, eeta hitau 7 hivesinuwadi neta, Sitiveni, ibom yana yemidi mwala'ina Yeisu ainai, na Alu'aluwa Ve'ahihi yana wahiyala ainai, yo Pilipi yo Pilikolasi yo Nikano yo Timoni yo Pamenasi yo hinage Nikolasi, ibom towaho Anitiyoki na bada Yudeya yadi tapwalolo ainai iluwu'o. ");
INSERT INTO kud2014_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ainaena tomowaone teina hi'abihinidi Yeisu yana tauyewasao mehediyai, na hi'abidebaidi na vehabadi hi'awa'awanoi Yaubada ainai, na paihowane hive'avalaidi. ");
INSERT INTO kud2014_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Eeta Yaubada yana walo idabalala tomowa aidiyai, na tauyemidi adi boda imwala'i i'alili tupwa Yelusalem ainai, na taupwaoliwo bodadi hinage walone hibenalei, na Yeisu hiyemidiyei. ");
INSERT INTO kud2014_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sitiveni Yaubada yana ala'alawowoli yo yana atemuyamuya i'oiye mwau, na paihowa abanuwapwanopwano yo ve'ive'ilalao ipaihowaidi tomowa ahi'ahipudiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Na tupwana tomowa hilaoma na Sitiveni baidadi hi'awa pa'ipa'i hiya tupwana Yudeya yadi tapwalolo yehana himwauwi ‘Talatalamdi’, na tupwana Sailini ainaena, na tupwana Alekisanidiliya ainaena, na tupwana Silisiya yo Esiya aidiyena. ");
INSERT INTO kud2014_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Na nigele howahowana hiwahiyala, wuwuna Sitiveni yana walo hanahanapu Alu'aluwa Ve'ahihi ainaena. ");
INSERT INTO kud2014_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Eeta dawaniyena tomowa hiyemaihadi na hivetowolodi ta hiya hiwalo, ‘Abenabenali na Mosese yo Yaubada i'awa'awa yababaedi’. ");
INSERT INTO kud2014_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ta tomowa nuwadiyai himwauwi na Sitiveni hive'alehaei, ainaena maudoidi yo babadao yo tauloinao yo hinage loina ana tauve'itao hilaoma, na hi'abi avivini, na hilauvai tau'ulewahiwo yadi abamiya gogoi ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Na tau'awa oya'oyamaone hilauvaidima na hiwalo, ‘Towaho teina, hauga maudoina aidiyai, Mosese yana loinao yo vada tapwalolo masemaselena hinage ihinalidi. ");
INSERT INTO kud2014_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Na hinage yana walo abenalei iwalo, “Yeisu ibom towaho Nasaleti howola abo vada tapwalolo teina ilo'e vehulu, na yada mumuga Mosese ainaena ivetuwuni na ilalaomawa imwaubuidi, na vagadi imwauwidi”.’ ");
INSERT INTO kud2014_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tau'ulewahiwone maudoidi Sitiveni maninane hivinuvinunui, ana ita dova Tauwalo mahalava manina. ");
INSERT INTO kud2014_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Taupwaoliwo yadi tauloina Sitiveni ipanivilaei, iwalo, ‘Teina tomowaone hava hiwalowalowedine neta moihadi?’ ");
INSERT INTO kud2014_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Na Sitiveni yadi walo iyemaiha iwalo, ‘Tahiguwao yo tamaguwao, yagu walo teina ambenalei, Yaubada Didigana mwalona tubudawa Abelaham Mesapotemiya ainai imiyamiya, na howola nigele iyavedalava Halana ainai ");
INSERT INTO kud2014_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Na iwalo Abelaham ainai, “Yam dalava yo yam huhuwo teina ulaugabaidi na ulau vali dalavai, tupwanane yave'itago ainai umiya”. ");
INSERT INTO kud2014_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","‘Neta ainaena Kalidiya ilaugabaei, na ivedalava Halana ainai. Na Abelaham tamana imwalowoi mulitai abo Yaubada imugaiyei na ivedalavane tupwa teina ainai tamiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ta nigele hinage teya tupwa nuwana bale'u iyamohei Abelaham yana abaloina, na Yaubada iwalo yemidi hauga teina ebeha tupwanane Abelaham mayana huhuwo yadi bale'u hivai, na hauganane ainai Abelaham nigele natuna. ");
INSERT INTO kud2014_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Na hinage Yaubada iwalo mugai ebeha Abelaham tubunao himiya taumana vali boda yadi tupwa ainai, yo dalavaone tanitaniwagadiyaone paihowa vitavitaidi himohedi, na himiya vitai bolimai 400 aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Na hesi Yaubada iwalo, “Howola abo dalava tanitaniwagadi loina vitavitaina yamohedi, na mulitai tupwa tenem ainaena yagu boda himahalava na hipwagogo aliguwai tupwa teina ainai”. ");
INSERT INTO kud2014_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Eeta Yaubada Abelaham ulewahi ana ve'ive'ilala imohei neta 'wapi ana hapi vehabana. Abelaham Aisake ilabahi ta hawahawaga ehebo i'ovi na hapi himomoheine. Dova hinage Aisake natuna Yakobo hapi imohei. Na Yakobo hinage natunao towotowohodi 12 adi bagibagili hapi imomohedine. ");
INSERT INTO kud2014_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","‘Tubudane Yakobo natunao hiya tahidi Yosepa hivegimwalaei Itipita aidiyai, wuwuna hi'alomagigiliyei ta nemai ivetaupaihowa nigele maihana na hesi Yaubada baidana. ");
INSERT INTO kud2014_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Na ihagui ana vitai aidiyena, na hinage hanapu namwanamwana imohei, Itipita yadi Pelo hanapunane i'ita lobai, ainaena Pelo Yosepa i'abihinine na loina imohei tupwa Itipita maudoina ainai, na hinage tauwasawasa yana vada holanai. ");
INSERT INTO kud2014_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","‘Na mulitai vahali imahalava Itipita maudoina yo Kenani aidiyai, na miya vitai imahalava na tubudaone nigele adi. ");
INSERT INTO kud2014_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ta Yakobo wasa ibenalei ebeha ai'ai Itipita ainai imiyamiya, na natunao towatowahodi ivetamaledi Itipita ainai, ai'ai vehabana. ");
INSERT INTO kud2014_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mulitai ivetamaleuyoidi Itipita ainai, na Yosepa tahinao aidiyai iwalo mahalava, iwalo, “Yau tahimu Yosepa”, na hinage Pelo ainai iwalo mahalavaedi iwalo, “Teina tahiguwao”. ");
INSERT INTO kud2014_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ainaena Yosepa tamana Yakobo mayana huhuwo iyogaedima, adi bagibagili 75, na Itipita ainai hilalaomane. ");
INSERT INTO kud2014_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Eeta tubudane Yakobo manatunao hidobi Itipita ta nemai himiyamiya ta himwamwalowoine. ");
INSERT INTO kud2014_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Na yadi asiyebwao mwalomwalowoidi hilawedi ta mwalona Abelaham igimwalaiya'o Sikem, hibom Emoli natunao aidiyena na magainane ana maiha siliba imomohedine neta ainai hiyeyemagaine. ");
INSERT INTO kud2014_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","‘Na hauga bada ilau tebitebiniya'o ta Yaubada yana waloyemidi ainona imiya mahalava Abelaham ainai neta ebeha Isileliwone Itipita hi'aitulu gabaei. Wuwuna tubudaone adi boda ihaehae. ");
INSERT INTO kud2014_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Na tauwasawasa vauvauna itowolo ta yana hauga loina, na tauwasawasane Yosepa nigele iyahanapui. ");
INSERT INTO kud2014_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Tubudaone i'oya'oyamaedi, na muya imohemohedi. Na iwalo wahiyala ta ebe natudiyao vauvaudi hitubui higabae mahalavaedi ta himwalowoi balabala awawai. ");
INSERT INTO kud2014_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","‘Gama Mosese itubui hauga tenem ainai, ibom ana ita inamwanamwa, na tamana yo hinana yadi vadai hi'ita'ita avivini neta wai'ena tonuga. ");
INSERT INTO kud2014_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Na mulitai yadi vadaena himwau mahalavaei, na Pelo natuna waihiuna ilolobaine, na ilauvaiyama yana vadai, na ebeha natuna i'ita avivini. ");
INSERT INTO kud2014_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Eeta Mosese Itipita yadi hanapu maudoina hive'itaei, ta ihanahanapuidi na yana walowone yo yana paihowao hiwahiyala alili. ");
INSERT INTO kud2014_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","‘Hauganane ana bolimai 40 ilobai Mosese nuwanuwana yana tomowao Isileli i'itadi. ");
INSERT INTO kud2014_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ainaena yana itane ainai Itipita ehebo towaho Isileli italai awawai, eeta Mosese tahina ihagui na towaho Itipita i'oiye mwalowoine. ");
INSERT INTO kud2014_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Na Mosese yana nuwatuwu ebeha yana huhuwone mata hihanapui, neta Yaubada nimanane iyeyepaihowa ta Itipitaone aidiyena ivaivehuludi na hesi nigele hiyahanapui. ");
INSERT INTO kud2014_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","I'ahubena ta Mosese tahinao bwau ilolobaidine, na nuwanuwana ebeha i'auhidi ta iwalo, “Augeluwo, omiu boda ehebo na hava vehabana yami miyamiya amveyaveyababa?”. ");
INSERT INTO kud2014_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","‘Na tau'alehaone ehebo aidiyena Mosese yana walo iyemaiha, na iwalo, “Yaiya owa utuwoi na uvetauloina alimaiyai? ");
INSERT INTO kud2014_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Vedova? Nuwanuwam na u'oiye mwalowoigau, lavi dova Itipita towahona u'oiye mwalowoine?” ");
INSERT INTO kud2014_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Walo teina Mosese ibenalei ta imeheuhi, na idena ilau Midiyani ainai, imiya taumana, na tenemai itawahola yo natunao towatowahodi bwau, ilabahidi. ");
INSERT INTO kud2014_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","‘Bolimai 40 tuluhanai Mosese tupwa balabala awawai oya Sainai vahalinai ilowolowouhi, na Yaubada yana tauwalo mahalava i'abiyamahalavauyoi aiwa alahawahawalina ainaena aiwa lugulugudi holadiyena. ");
INSERT INTO kud2014_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ta Mosese i'aluwagavai ta iwutulau tupwanane ala'alahinane vahalinai ebeha i'ita ili'ilimani, ainaena Bada alinana ibenalei iwalo, ");
INSERT INTO kud2014_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Yau tubumwao hibom Abelaham yo Aisake yo Yakobo yadi Yaubada”. Na Mosese yana meheuhiyena ibatubatutuli, ta nigele iya'ita lau. ");
INSERT INTO kud2014_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","‘Ainaena Bada iwalo, “Am ae humahuma uwuludi wuwuna neta bale'une ainai utowotowolone bale'u ve'ahihi. ");
INSERT INTO kud2014_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yagu tomowa yadi miya vitai Itipita holanai yahanapuiya'o, na yadi dou, bada yabenalena'o, ainaena yadobima habi haguidi. Eeta owa utowolo na yavetamalego Itipita ainai, paihowa teina vehabana.” ");
INSERT INTO kud2014_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","‘Isileliwone Mosese hita'wata'wataei, hiwalo, “Yaiya owa ebeha utowoi na uvetauloina na u'abiye dumwalugai?”. Eeta Isileliwone hita'wata'wataei na Yaubada yana vesinuwa haugana tauwalo mahalava aiwa ala'alahawawalina ainai ivesinuwai iwalo iya tauloina na taulivahi. ");
INSERT INTO kud2014_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Yudeyaone imugaiyedi ta Itipita hi'aitulu gagaeine. Mulitai ginauli abanuwapwanopwano na ve'ive'ilala i'abiye mahalavadi Itipita ainai yo ni'u hawahawawalina ainai. Na hinage ginauli abanuwapwanopwano yo ve'ive'ilala i'abiye mahalavadi balabala awawai neta bolimai adi bagibagili 40. ");
INSERT INTO kud2014_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","‘Teina Mosese Isileli aidiyai iwalo, “Yaubada howola abo tahimiyaone aidiyena ehebo Tauwalo mahalava ivesinuwai vehabamiu, dova mwalona yau ivesinuwaigaune.” ");
INSERT INTO kud2014_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Na hinage Mosesenane nu'ulai Isileli tubunao maudoidi baidanao, oya Sainai ainai himiyamiya na tauwalo mahalava Mosese loina namwanamwana yawahida vehabana imomohedine. ");
INSERT INTO kud2014_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","‘Na tubudaone Mosese yana loina hita'wata'wataei, ta nuwanuwadi yo hilau gwaipile Itipita ainai, ");
INSERT INTO kud2014_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Na Eloni ainai hiwalo, “Yada abapwagogowo u'atububunidi, na himugaiyegita, wuwuna Mosese ibom mwalona Itipita ainaena imugaiyegitamawa, havaidova ilao'o”. ");
INSERT INTO kud2014_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tenem haugane ainai abapwagogo aiwa tagitagi hipaihowai ta ana ita dova bulumakau natuna. Na ainai hipwaopwaoli yo nimadiyena hava hipapaihowaine hiyaliyayai ainaena na higuyaguyau. ");
INSERT INTO kud2014_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Eeta Yaubada ita'wata'wataedi, na hibom yadi nuwatuwu hipaihowai, neta utuiwo galewa aidiyai hipwagopwagogo, dova tauwalo mahalavao yadi buki holanai Yaubada yana walo imiyamiya, iwalo: “Omiu Isileli tupwa balabala awawai bolimai 40 ammiyamiya, lagulaguwao amwunuidi, na nigele aliguwai amyapwaopwaoli. ");
INSERT INTO kud2014_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Na yami abapwagogo yehana Moloke yana gwau, am'avalai yami abapwagogo na hinage Lepani yana utui amtagi yo ainai amwalowalo vetuvehae. Ainaena mata ya'oipeiyegomiu na amlau Babiloni tulutuluhanai.” ’ ");
INSERT INTO kud2014_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Na Sitiveni iwalo, ‘Mosese gwaune i'abi, neta dova Yaubada ive'ita ma'ama'ayaune ainai. Ainaena hi'abi na hauganane tupwa balabala awawai hilaulau Yaubada yana gwaune hinage hi'avalai vali tupwai”. ");
INSERT INTO kud2014_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Mulitai tubudiyao Yosuwa baidanao teina gwaune hivaiyama na tupwanane ainai tubudao taumiya dalavao hiheusilidi tupwa teina ainaena, na Yaubada ihaguidi ta hiwahiyala, na yadi bale'u teina hivai, na gwaune imiyamiya ana higa Deivida ivetauwasawasa aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Iya Yaubada ana awanamwanamwa imohei. Na Yaubada ainai ipanivila na ebeha italamwei ta Yakobo, yana Yaubada yana vada i'abi. ");
INSERT INTO kud2014_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Na hesi Yaubada yana vadane Deivida natuna Solomoni i'a'abine. ");
INSERT INTO kud2014_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","‘Yaubada ewa'aliliyai yana vada tomowa nimadiyena hi'abi'abi nigele alonai iyamiyamiya, dova tauwalo mahalava yana walo iwalo: ");
INSERT INTO kud2014_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Galewa yagu abamiya wasawasa, na bale'u aegu adi abamwau. Ainaena aiteya vada howahowana, na vehabagu am'abi na vadanane ainai ya'aiyawasi? ");
INSERT INTO kud2014_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Wuwuna ginauli teina maudoidi yau yapaihowaidi.” ’ ");
INSERT INTO kud2014_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Na Sitiveni iwalo, ‘Omiu tau'ateyaiyaiwo. Yaubada wasana ainai neta atemiu yabidaidi'o yo talinamiu yagohaye tuidi'o. Omiu bada dova hauga daodaona tubumiyao Alu'aluwa Ve'ahihi amta'wata'wataei. ");
INSERT INTO kud2014_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Walo moiha tubumiyao tauwalo mahalavao maudoidi hi'abiye muyadi na hi'oiye mwalowoidi. Hiya Taudumwaluwa yana laoma vehabana hiwalo mugaiyeiwa, na teina hauga omiu hinage Taudumwaluwa amhuhulaei, ta am'o'oiye mwalowoine. ");
INSERT INTO kud2014_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Na omiu Yaubada yana loina himohegomiu tausagena wasao aidiyena, na nigele amyamulitaei.’ ");
INSERT INTO kud2014_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sitiveni yana walo tauloinao hibenalei ta adi modi i'ini mwala'ina, na awadi hitauve'alahi yadi modi'ini vehabana. ");
INSERT INTO kud2014_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Na hesi Alu'aluwa Ve'ahihi Sitiveni i'oiye mwau, ta galewa ivinuvinunui, na Yaubada yana wasawasa masele ainai ihae na Yeisu nimatautuwanai itowotowolo, i'i'itane. ");
INSERT INTO kud2014_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Na iwalo, ‘Am'ita, galewa ilotaho'e na Tomowa Moihana Yaubada nimatautuwanai ya'ita itowotowolo.’ ");
INSERT INTO kud2014_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Hiwuiwui wahiyala, na talinadi hi'abi auhidi, na ebeha havena yana walo hibenabenalei. Eeta maudoidi vehabana hisagena na hi'abi avivini. ");
INSERT INTO kud2014_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Na dalavane tuluhanai higabaei aituluwei, na gaimaena hitatalaine. Na tau'aisamasamaniwone adi luwuluwu himwauwi hevali teya yehana Saulo aenai. ");
INSERT INTO kud2014_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Sitiveni howola gaimaena hitalatalai na Bada ainai i'awa'awanoi, iwalo, ‘Bada Yeisu alu'aluwagu uvaiyawa’. ");
INSERT INTO kud2014_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Na aetutulina i'atuwomalei na iyoga wahiwahiyala iwalo, ‘Bada, yadi mumuga yababana teina havena uyemayemaiha aidiyai’. Na yana walo teina tuluhanai yawahina i'ovi. ");
INSERT INTO kud2014_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Na Saulo bodaone i'awa namwanamwaedi Sitiveni ana oiyemwalowoi vehabana. Ahubena tenem ainai tauyemidiwo tupwa Yelusalem ainai adi alehao hivetuwuni na hi'aleha, ainaena hilouhagwali Yudeya yo Sameliya tupwanao aidiyai, na Yeisu yana tauyewasao hitau 12 Yelusalem ainai himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Na tupwana tomowa Yaubada ana tauyemidiwo Sitiveni hivai ta hidoudouwi i'ovi na abo higagaliyaunaeine. ");
INSERT INTO kud2014_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Na hesi Saulo itowoi na tauyemidiwo yadi boda i'oiye sawali. Vada ehebo ehebo iluwuluwuidi na tauyemidiwo towatowahodi yo waiwaihiudi ilaulaugogoidi na vada paipaiyai imwaumwauluwuwedi. ");
INSERT INTO kud2014_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Tauyemidiwo hilo'uhagwali, ta ebeha tupwa teya ainai wasana namwanamwana higuguyaei tomowa aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ainaena Pilipi idobi Sameliya tupwanane ainai, na tenemai Besinana Tomowana wasana iguguyaei aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Na maudoidi Pilipi yana walo hibenalei, na yana paihowa wahiwahiyalana hi'itadi, ");
INSERT INTO kud2014_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ebe yaiyadiwo hi'asiyebwa, alu'aluwa yababana aidiyena mata imwau mahalavaedi, mayogayogadi yo hinage taubelubelu, yo taulepelowo i'abiye namwanamwadi. Ainaena bodaone hitalatalam toyatoyawa Pilipi yana guguya ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Na ainaena abayaliyaya mwala'ina dalavanane ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na taumiya dalava ehebo yehana Saimoni, iya Pilipi yana walo iyemidiyei. Saimoninane mwalona tau'oba'oba na oyamaena iwalo mahalavaeuyowei ebeha iya teya towaho mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tomowa maudoidi, tomowa mohili yo tomowa mwala'idi ainai hibenabenali ta hiwalo, ‘Teina tomowane dova Yaubada. Owa uwahiyala alili.’ ");
INSERT INTO kud2014_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Eeta Saimoni yana walowone hibenaledi wuwuna yana obaena i'abiye nuwapwanopwanodi hauga maudoina aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Na mulitai Pilipinane imahalavama na wasana namwanamwana Besinana Yeisu yehana yo Yaubada yana loina vehabadi, iguguya, na hiyemidiyei, na hibapitaiso, towatowaho yo waiwaihiu. ");
INSERT INTO kud2014_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Na Saimoni hinage Yaubada iyemidiyei, na yana bapitaiso tuluhanai Pilipi baidana himiyamiya. Na Saimoninane Pilipi yana ala'alawowoli yo yana ve'ive'ila ipaihowaidi wahiwahiyaladi i'itadi, na inuwapwanopwano moiha. ");
INSERT INTO kud2014_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ainaena Yeisu yana tauyewasao Yelusalem ainai himiyamiya, wasa hibenalei ebeha bada Sameliya hitalam'o Yaubada yana walo ainai, eeta Pita na Yoni hivetamaledima. ");
INSERT INTO kud2014_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Na hitau bwaune hidobi Sameliya ainai, na tauyemidi vauvaudi vehabadi hi'awa'awanoi, na Alu'aluwa Ve'ahihi aidiyai iluwu. ");
INSERT INTO kud2014_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Wuwuna howola nigele teya yaiya Alu'aluwa Ve'ahihi iya'oiye mwau na bapitaiso ibom Bada Yeisu yehanaena hivaiya'o. ");
INSERT INTO kud2014_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ainaena Pita na Yoni nimadi aidiyai himwauwi na Alu'aluwa Ve'ahihi aidiyai iluwu. ");
INSERT INTO kud2014_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Na Saimoni paihowa teina i'ita ebeha Yeisu yana tauyewasao nimadi himwau tomowa aidiyai na Alu'aluwa Ve'ahihi aidiyai iluwu, ainaena mani ivai ta ebeha Pita na Yoni imohedi. ");
INSERT INTO kud2014_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Na iwalo, ‘Teina ala'alawowoline ammohegau ta ebe yaiya nimagu ainai yamwauwi mata Alu'aluwa Ve'ahihi iluwui’. ");
INSERT INTO kud2014_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ta Pita Saimoni iwalowei, iwalo, ‘Yam mane baidam amsilahe vateyai, wuwuna ebeha Yaubada yana velau yam mane ainaena uyemaiha. ");
INSERT INTO kud2014_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Owa nigele yama boda, na atem imumuga yababa Yaubada mehenai. ");
INSERT INTO kud2014_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Eeta ilowoinanego na yam yababa ainaena unuwabui, na u'awa'awanoi Bada ainai, na ebe inuwahamuigo. ");
INSERT INTO kud2014_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Na yahanapui atem paipaina alomagigili, yo mumuga yababana aidiyena.’ ");
INSERT INTO kud2014_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Na Saimoni iwalo, ‘Am'awa'awanoi Bada ainai ta ginauline yababadine amwalo mahalavaedi'o, havena aliguwai himiyamiya yo hilaolaoma’. ");
INSERT INTO kud2014_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Mulitai Pita na Yoni yadi Bada vehabana hiwalowalo mahalava na yana walo higuguyaei, na hiwuyo Yelusalem ainai, na yadi wuyone ainai wasa namwanamwana hiwalo mahalavaei Sameliya tupwanao aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Na Bada yana tausagena wasa Pilipi iwalo, ainai ‘U'atububuni na ulau tupwa yavana amwaha Yelusalem yo ilau Gasa ainai’. Amwahane ilaulau balabala awawa ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Eeta Pilipi itowolo ta ilalaune. Tenem hauganane tauloina mwala'ina, Itiyopiyaena ilaulau gwaipile yana dalavai. Iya Itiyopiya yadi alawata yehana Kanidesi yana mane i'ita'ita avivini. Iya ilau Yelusalem ta Yaubada iwalo vetuvehaeyei na iwuyowuyoma. ");
INSERT INTO kud2014_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Igelu ta ilaulau na waloyemidi bukina Aisaya ainai ilaulauvahili. ");
INSERT INTO kud2014_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ainaena Alu'aluwa Ve'ahihi Pilipi iwalo ainai, ‘Ulau mwayamwayau waga niuniuli vahalinai’. ");
INSERT INTO kud2014_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Eeta Pilipi isagena ilau ainai ta ibenabenali na towahone ilaulauvahili Aisaya yana buki ainaena. Na Pilipi ipanivilaei iwalo, ‘Uhanapuiya'o hava uvahivahiline?’ ");
INSERT INTO kud2014_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Na towahonane iwalo, ‘Nigele, wuwuna nigele teya yaiya na ebe i'aubabada ili'ilimani aliguwai’. Na iwalo ta Pilipi imwalae taohani ta waga niuniuline ainai baidana himimiyane. ");
INSERT INTO kud2014_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Yaubada yana Buki ivahivahili iwalo: ‘Ibom dova sipi mata hiwunui, ta dova sipi natuna ebe hiwunuwunui, na ana tautomne mehenai itowotowolo, nigele alinana yo nigele teya hava iyawalowei. ");
INSERT INTO kud2014_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Na hinage yana lauvetala ainai nigele hiya abiye dumwaluyana ililimani, na ihinimaya. Ainaena nigele teya natunao ta ebe hiwalo mahalavae, wuwuna yawahina bale'uwai i'o'ovi.’ ");
INSERT INTO kud2014_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Na towaho Itiyopiyaenane Pilipi iwalo ainai, ‘Yaiya vehabana tauwalo mahalava teina iwalowalone? Ibom vehabana nuwana vali towaho vehabana?’ ");
INSERT INTO kud2014_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ainaena Pilipi ivetuwuni vahilinane ana livahi ainai, na Yeisu wasana ive'itaei. ");
INSERT INTO kud2014_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Eeta amwahanane hilaulau, na bwahi hi'ita lobai, ta towahonane iwalo, ‘Tenem we'ahane! Vedova howahowana ainaena uvebapitaisogau?’ ");
INSERT INTO kud2014_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ta yana taupaihowa iloinaei na waga niuniuli ilaumwauwi, na hitau bwau Pilipi baidana hi'aitulu bwahiyai, na Pilipi towahone i'abiye bapitaisone. ");
INSERT INTO kud2014_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ainaena bwahiyena hihaema na Bada Alu'aluwana Pilipi ilauvai, na towahone Pilipi nigele iya'itauyoi, ainaena mayana yaliyaya ilalaune yana dalavai. ");
INSERT INTO kud2014_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Na Pilipi hilobai dalava Asotosi ainai ilaulau na wasa namwanamwana iguguyaei dalava ehebo ehebo aidiyai, na ana higa imahalava Sisaliya ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo howola i'ale'aleha Bada ana taumulitao aidiyai. Eeta ilau taupwaoli mwala'ina ainai, ");
INSERT INTO kud2014_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nuwanuwana yana letao ileleledi na ilawedi Yudeya yadi miyagogoi Damasiko aidiyai. Na letaone aidiyena ebe Yeisu yana amwaha adi taumulitao ilobaidi, towatowaho yo waiwaihiudi i'abi avivinidi na ivaidima Yelusalem ainai habi lauvetalaedi. Eeta letadine ivaidi na ilau. ");
INSERT INTO kud2014_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Na Saulo ilaulau ta Damasiko ainai muhamuhana imahalava, na masele galewaena imasele ta i'i'iliyei. ");
INSERT INTO kud2014_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ta ibe'u bale'uwai na ehebo alina ibenalei, iwalo, ‘Saulo, Saulo, hava vehabana u'abi'abiye muyagaune?’ ");
INSERT INTO kud2014_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulo iwalo, ‘Bada, yaiya owa?’ Na alinane iwalo, ‘Yau Yeisu, u'abi'abiye muyagaune. ");
INSERT INTO kud2014_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Na hesi utowolo na uluwu dalavai na tenemai amvenuwamwau ubenalei, yo hava mata upaihowaine.’ ");
INSERT INTO kud2014_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Na tomowaone Saulo baidanao hilaulau hitautowolo na tomowa alinana hibenalei na hesi nigele teya hiya'ita. ");
INSERT INTO kud2014_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ainaena Saulo bale'uwena itowoloma na nuwanuwana ta mehena imasele, na hesi nigele howahowana hava i'ita, eeta Saulo hi'abinimai na hiluwuwei Damasiko ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Na nemai ahubena tonuga aidiyai nigele hava teya iya'ita, na hinage nigele iya'ai yo iyanuma. ");
INSERT INTO kud2014_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Na Damasiko ainai Yeisu ana taumulita ehebo imiyamiya, yehana Ananayasi, na yana eno niviniviyena Bada iwalo ainai, iwalo, ‘Ananayasi’. Ta Ananayasinane iwalo, ‘Bada, Yau teina’. ");
INSERT INTO kud2014_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Eeta Bada iwalo, ‘Utowolo na ahi'ahipuwena ulau amwaha yehana Dumwadumwaluna ainai, yo Yudasa yana vadai ehebo towaho upanivilae, ibom towaho Tasosiyena na yehana Saulo, na hauga teina ainai i'awa'awanoi. ");
INSERT INTO kud2014_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Na eno'ita'itaena i'ita'ita na ehebo towaho yehana Ananayasi iluwu ta nimana ulu'ulunai imwauwi na ebe ivinunuyo.’ ");
INSERT INTO kud2014_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Na Ananayasinane iwalo, ‘Bada, towahonane wasana tomowa maudoidi hibenalena'o ebeha towaho yababana, na yam tauyemidiwo Yelusalem ainai bada ive'aleha aliliyedi. ");
INSERT INTO kud2014_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Na hinage taupwaoliwo mwala'idi hitalamwei na hauga teina ilaoma ta ambodao maudoina Damasiko ainai habi paigai ebe yehamwena awa'awanoi.’ ");
INSERT INTO kud2014_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Na Bada iwalo ainai, ‘Badagi, ulau ainai. Wuwuna iya bada yavesinuwaiya'o na wasagu iwalowei tomowa tupwa vehopali alodiyai, yo tauloinao mwala'idi mehediyai yo Isileli hinage aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Na hinage yave'itae yana muyamuyao mwala'idi mata ilobaidi, yau agu walomahalava vehabana.’ ");
INSERT INTO kud2014_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ainaena Ananayasi ilau, na Yudasa yana vadai iluwu, na nimana imwauwi Saulo ulu'uluna ewanai iwalo, ‘Tahigu Saulo, Bada Yeisu imahalava alimwai, ibom ivetamalegauma mehem ya'abiye masele, yo hinage Alu'aluwa Ve'ahihi ainaena i'oiye mwaugo’. ");
INSERT INTO kud2014_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Eeta Saulo mehenaena dova yama onavidi hibe'u na i'itauyone. Ainaena itowolo na ibapitaiso, ");
INSERT INTO kud2014_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","na hinage ai'ai ivai na i'ai ta yana wahiyala ilolobauyoine. Tupwana ahubena aidiyai Saulo Yeisu ana taumulitao baidanao himiyamiya Damasiko ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Na Yudeya yadi vada tapwalolo aidiyai Saulonane iguguya, ‘Ebeha Yeisu ibom Yaubada Natuna moiha’. ");
INSERT INTO kud2014_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Na taubenaliwo hinuwapwanopwano mwala'ina, na hiwalo, ‘Yana guguya teina ambenalei ibom mwalona Yeisu ana taumulitao Yelusalem ainai ive'ave'alehaedi. Na hinage yana laoma teina wuwuna ebeha Yeisu ana taumulitao teinai himiyamiya i'abi avivinidi na ipaidi ta ilawedi Yelusalem, taupwaoliwo mwala'idi aidiyai, bo?’ ");
INSERT INTO kud2014_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Na hesi Saulo yana guguya i'ala'alawowoli, ana moiha ebeha Yeisu iya Yaubada yana Besinana neta wuwuna ivenuwavaivai moiha ainaena ta Yudeyaone himiyamiya Damasiko nigele howahowana yana walo hiyemaiha. ");
INSERT INTO kud2014_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Saulo Damasiko ainai imiyamiya, na Yudeya hiloiloina ebeha hi'oiye mwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Na hesi yadi loina dawani bada Saulo ihanapuidi'o. Boniyai yo ahubena dalavane alina ana awa'eda hivinuvinunui ebeha yana aitulu ainai na hi'oiye mwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Na hesi boniyai ehebo ainai Saulo ana taumulitao boha ainai hiyemiya, na hivedawedawe dobiyei aline hawahawagana ainaena. ");
INSERT INTO kud2014_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Eeta Saulonane iwuyo Yelusalem na itowoi ta ebeha iluwu Yeisu ana taumulitao aidiyai, na himeheuhei, wuwuna nigele hiyayemidiyei ebeha bada inuwabui'o. ");
INSERT INTO kud2014_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Na Banabasi ibom Saulo ihagui, na ilauvaiyama Yeisu yana tauyewasao aidiyai, na i'au'aubabada vedova Saulo amwahai Bada ilolobaine ta alinana ibebenaleine. Na vedova Saulo iguguya atepatu Damasiko ainai Yeisu yehanaena hinage i'aubabadanei. ");
INSERT INTO kud2014_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Eeta hitalam Saulo baidadi himiyamiya. Na Yelusalem maudoina ita'i'iliyei mayana wahiyala Bada yehanaena iguguguguya. ");
INSERT INTO kud2014_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Na Yudeya hibom tau'alina Gilisi Saulo baidadi hive'awa pa'ipa'i'i, na hiloiloina vedova na hi'oiye mwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Na Yeisu ana taumulitao hibenalei, ta Saulo hilawei Sisaliya, na tenem ainai hivetamalei ta ilau Tasisi ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ainaena tautapwalolo Yudeya yo Galili yo Sameliya dalavadi maudoidi himiya ili'ilimani. Na Bada hive'ahihiyei, na Alu'aluwa Ve'ahihi yana wahiyala yo yana vehaguhagu aidiyai na himiyamiya, ta yadi boda imwalamwala'i. ");
INSERT INTO kud2014_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita ita'i'ili Yaubada yana tomowa masemaseledi aidiyai, na ilaoma ehebo dalava yehana Lida ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Na ehebo towaho taubelubeluna ilobai, yehana Eniyasi ibom bolimai 8 yana aba'eno ainai i'eno'eno, nigele howahowana ilowouhi. ");
INSERT INTO kud2014_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Eeta Pita iwalo ainai, ‘Eniyasi, Yeisu Besinana i'abiye namwanamwago. Ainaena utowolo na yam halabi u'avalai na ulau, ta itowolo mwayamwayau.’ ");
INSERT INTO kud2014_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Na tomowaone Lida yo Saloni adi taumiyaone hi'ita na ainaena Bada Yeisu ainai hinuwabui. ");
INSERT INTO kud2014_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Na dalava Yopa ainai Yeisu ana taumulita ehebo waihiuna imiyamiya, yehana Tabita, na ana bui Dokasa, na Dokasa ana bui neta lagulagu teya yehana, na waihiunane velau wuwuna ta tauwewelohe ihaguhaguidi. ");
INSERT INTO kud2014_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Tenem hauganane ainai i'asiyebwa yo imwalowoi, na wagawagana hivai ta hivehuguvi, na hevala ehebo ewanai himwamwauwine. ");
INSERT INTO kud2014_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yopa neta Lida vahalinai ainaena haugana Yeisu ana taumulitao Pita wasana hibenalei ta tomowa bwau hivetamaledi Lida ainai Pita vehabana. Tomowaone wasa hilawei Pita ainai hiwalo, ‘Ulau mwayamwayauma ta'ulaoma alimaiyai’. ");
INSERT INTO kud2014_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Eeta Pita itowolo na tomowaone baidanao hilalaune, haugana himahalava neta hilauvai ta hihae vadane ana hevala ewanai. Na hiwahiwapewone maudoidi Pita hitowolo gwaigwaipileyei na luwuluwu yo abalauli'wa Dokasa mwalona ipapaihowaidiwa hi'abiye mahalavadi na hidoudou. ");
INSERT INTO kud2014_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Na Pita iloinaedi ta vadaena himahalava, na ibom imiyamiya, na aetutulina i'atuwomalei yo i'awa'awanoi Yaubada ainai, eena i'ita gwaipile na tauna iwalo lau ainai iwalo, ‘Tabita utowolo’. Na waihiune mehena i'itanei na Pita i'itane, ta eno'enowena itowolo imimiyane. ");
INSERT INTO kud2014_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Na Pita nimanai i'abi na i'abiye towolone. Na tauyemidiwo yo hiwahiwapewo iyogaedima, na Tabita mayawahina ive'itae aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Na wasane iyewasaei tupwa Yopa maudoina ainai, ainaena tomowa maudoidi Bada Yeisu ainai hiyemidi. ");
INSERT INTO kud2014_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Na Pita Yopa ainai imiya daodao, towaho yehana Saimoni yana vadai, ibom yana paihowa lagulagu 'wapidiyena tobwatobwa ipaipaihowaidi. ");
INSERT INTO kud2014_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Dalava Sisaliya ainai ehebo towaho yehana Koniliyosi imiyamiya, iya Italiwone yadi tau'alehao, adi taumugai. ");
INSERT INTO kud2014_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ibom towaho namwanamwana na mayana huhuwo Yaubada hive'ahihiyei, na hauga maudoina tauwewelohe ihaguhaguidi na i'awa'awanoi Yaubada ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ahubena ehebo lavilaviyena, Koniliyosi i'eno ita'ita na Yaubada yana tausagenawasa ehebo i'ita'ita ili'ilimani na ilaoma ainai iwalo, ‘Koniliyosi!’. ");
INSERT INTO kud2014_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Koniliyosi tausagenawasane ivinuvinunui na mayana meheuhi, iwalo, ‘Bada, hava?’ Na tausagenawasa iwalo, ‘Yaubada yam awanoi yo yam hagu tauwewelohe aidiyai ihanahanapui, na ainaena inuwatuwu avivinigo. ");
INSERT INTO kud2014_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Eeta yam taupaihowao tupwadi uvetamaledi, na hilau Yopa ta Saimoni iya yehana himwau Pita, hilauvaiyama. ");
INSERT INTO kud2014_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Pitanane ehebo hinage Saimoni yana vadai le'awa ainai imiyamiya, na Saimoninane yana paihowa lagulagu 'wapidi aidiyena ginauli ipaipaihowaidi.’ ");
INSERT INTO kud2014_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tausagenawasane yana walo i'ovi na ilalaune. Na Koniliyosi yana taupaihowao bwau iyogaedima na yana tau'aleha ehebo hinage Yaubada ana tauve'ahihi mwala'ina iya Koniliyosi taumiya vahalina. ");
INSERT INTO kud2014_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ainaena tausagenawasane yana walomahalava Koniliyosi i'aubabadaei hitau tonugane aidiyai, na ivetamaledi Yopa ainai ta hilalaune. ");
INSERT INTO kud2014_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","I'ahubenama mahana ala'alapwahiyai hilaulau Yopa vahalinai, na Pita vadai imiyamiya, na ihae ewai habi awanoi. ");
INSERT INTO kud2014_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","I'awa'awanoi mavahalina na howola vadai ai'ai hi'atu'atububuni na Pita i'eno ita'ita. ");
INSERT INTO kud2014_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Na galewa i'i'itane ilotaho'e, na ehebo ginauli i'ita idobidobima, ana ita dova ale'o mwala'ina papalina vehopali aidiyena hi'aba'abahi dobima bale'uwai. ");
INSERT INTO kud2014_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Na holanai vali lagulagu yo vali lagulagu daladaladi yo vali lowolowo yo vali lowolowo. ");
INSERT INTO kud2014_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ainaena ehebo alina Pita iwalo ainai, iwalo, ‘Pita, utowolo yo neta lagulaguwone uwunuidi na u'aidi’. ");
INSERT INTO kud2014_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Na Pita ita'wata'wataedi, iwalo, ‘Bada, badagi wuwuna nigele teya hinage lagulagu laulaugagayodi teina dova yaya'aidi’. ");
INSERT INTO kud2014_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Na alinane iwalouyo iwalo, ‘Yaubada lagulagu bada i'abiye maseledi'o, ainaena havena u'awa'awa yabayababaedi’. ");
INSERT INTO kud2014_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ginauli teina mai tonuga Pita ainai imahalava, alinanane mai tonuga dova iwalowei, na mulitai ginaulinane iheheuyone galewai. ");
INSERT INTO kud2014_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita howola yana eno'ita'itane ainona inuwanuwatuwui na Koniliyosi tomowaowa tonuga ivevetamalediwa Saimoni yana vada hilobai na hilaoma ta ali awa'edanai hitowotowolo. ");
INSERT INTO kud2014_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Na hipanavila hiwalo, ‘Teina ainai taumana yehana Saimoni Pita imiyamiya?’ ");
INSERT INTO kud2014_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Vadanane ewanai Pita inuwatuwu behabeha, na Alu'aluwa Ve'ahihi ainai iwalo, ‘Pita, towatowaho hitau tonuga hibehabehaego, na bada hilaoma'o ta elauhai himiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ainaena utowolo na u'aitulu aidiyai ta baidamwao amlau na havena unuwatuwu gwaigwaipile, wuwuna yau tomowaone yavetamaledima.’ ");
INSERT INTO kud2014_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ta ainaena Pitanane i'aitulu aidiyai na iwalo, ‘Yau Pita. Hava vehabana amlalaomane?’ ");
INSERT INTO kud2014_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Na hiwalo, ‘Tau'alehao yadi taumugai yehana Koniliyosi ivetamalegai ta alalaomane. Iya towaho dumwadumwaluna na Yaubada iwalowalo vetuvehaeyei. Eeta hiya Yudeya maudoidi hive'ahihiyei. Yaubada yana tausagenawasa masemaselena Koniliyosi iwalo auli ta ivetamalegai yo alaoma ebeha ave'i'imanego ta talau yana vadai, yo hava mata u'au'aubabadaneine ibenalei.’ ");
INSERT INTO kud2014_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pita tomowaone iyogaedi, na vadai hivetaumana. I'ahubena na hitowolo ta Pita baidadi hilau, na tupwana adi geluwo Yopa ainaena baidadiyao hilaulaune. ");
INSERT INTO kud2014_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","I'ahubenauyo abo himamahalavane Sisaliya ainai, na tenem ainai Koniliyosi yana huhuwo yo ana geluwo iyoga ahaidima, na yana vadai hiha'waha'wa. ");
INSERT INTO kud2014_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Na Pita imahalava vadai na Koniliyosi imahalavama Pita mehenai ibe'u dobi na ipwagogo. ");
INSERT INTO kud2014_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Na Pita Koniliyosi i'abiye towolo, na iwalo, ‘Utowolo! Yau tomowa mohili owa dova.’ ");
INSERT INTO kud2014_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ainaena Pita yo Koniliyosi baidana hi'au'aubabada na hiluwu vadai, na Pita boda i'itadi hiha'waha'wa. ");
INSERT INTO kud2014_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Eeta iwalo lau aidiyai iwalo, ‘Omiu amhanapuiya'o neta ai Yudeyaone nigele howahowana na omiu nigele Yudeya baidamaiyao ta'awa heliheliyam, neta yama laugagayo ta ebe havena abo'ebo'eyegomiu. Na hesi Yaubada ive'itagau ebeha laugagayone bada i'ovi'o. ");
INSERT INTO kud2014_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ainaena hauganane Koniliyosi yana walo ivetamalenama nigele yayata'wata'wata, na hesi yatalamwegau ta yalalaomane. Na hava vehabana uyogaegaune?’ ");
INSERT INTO kud2014_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Koniliyosi iwalo, ‘Ahubena vehopali bada hi'ovi'o ainai lavilaviyai, dova wau teina ulalaomane eeta yagu vadai ya'awa'awanoi na tomowa ehebo ana ale'o namanamalina meheguwai itaumahalavane. ");
INSERT INTO kud2014_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ta iwalo, “Koniliyosi, Yaubada yam awanoi yo yam aiyauya ihanapuidi'o ainaena i'atemuyamuyaego. ");
INSERT INTO kud2014_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tomowa uvetamaledi ta hilau Yopa ainai towaho yehana Saimoni Pita hilauvai. Na towaho teya hinage yehana Saimoni iya lagulagu 'wapidi ana taulauhaili ainai ivetaumana na Saimoninane yana vada neta ni'u vahalinai.” ");
INSERT INTO kud2014_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Eeta vehabam walo yavetamale mwayamwayawenawane ta u'atemuyamuyaegai na ulalaomane. Ainaena mata maudoimai teina Yaubada mehenai na ginauliwone hava Bada iwawalo auligowa ebeha u'aubabadaei neta maudoimai aha'waha'wa ebeha abenalei.’ ");
INSERT INTO kud2014_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Eeta Pita iwalo aidiyai, ‘Walo moiha bada nuwagu imasele'o ebeha tomowa maudoidi Yaubada mehenai toyatoyawa, na nigele Yudeya hibom iyavelauwedi. ");
INSERT INTO kud2014_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Na hesi vali tomowa tupwa ehebo ehebo tomodiyao ebe hive'ahihiyei, na himumuga dumwalu, Yaubada iyaliyaya vehabadi. ");
INSERT INTO kud2014_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Na Besinana Yeisu ibom maudoida yada Bada na Yaubada nuwadaumwali wasana namwanamwana Yeisu imohegai, ai Isileli yama awanamwanamwa vehabana. Na omiu wasanane amhanahanapui. ");
INSERT INTO kud2014_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Wuwuna Yoni wasanane ivetuwuni Galili ainaena, hauganane iguguya, na tomowa i'abiye bapitaisodi na mulitai Yeisu wasana ivetuwuni Yudeya tupwana maudoina ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Wasanane ebeha Yaubada Yeisu towaho Nasaleti i'abiye wahiyala Alu'aluwa Ve'ahihi ainaena, ta i'ala'alawowoli na tomowa ihaguhaguidi, ebe yaiyadiwo Tomodulele yana ala'alawowoliyena hi'asiyebwa, Yeisu i'abiye namwanamwadi, wuwuna Yaubada yana ala'alawowoli ainaena. ");
INSERT INTO kud2014_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","‘Na ai Yeisu ana tauwalo moiha, wuwuna yana paihowao a'itadi'o Yudeya tupwanane aidiyai yo Yelusalem ainai na ana higa aiwa lagalagana ainai hitutuye patu ta imwamwalowoine. ");
INSERT INTO kud2014_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Na ahubena tonuga ainai Yaubada i'abiye towolouyoi, na i'abiye mahalavauyoi. ");
INSERT INTO kud2014_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Nigele tomowa maudoidi aidiyai, na ai Yaubada ivesinuwaigai ebeha tauwalo moiha alimaiyai, na ana higa yana towolouyo tuluhanai a'ai na anumanuma Yeisunane baidamai. ");
INSERT INTO kud2014_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Na iloinaegai ta tomowa aidiyai aguguya ebeha Yaubada Yeisunane ivesinuwai yo hauga yana aba'ovi ainai lauvetala ipaihowai, tomowa hibom bada himwalowoi vehabadi na hinage ita mayawahida vehabada. ");
INSERT INTO kud2014_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tauwalo mahalava hinage mwalona hiwalo mahalava mugai, ebeha yaiyadiwo Yeisu ainai hiyemidi yadi pwanoli ana nuwahamu Yaubada ainaena hivai Yeisu yehanaena.’ ");
INSERT INTO kud2014_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita howola i'au'aubabada na Alu'aluwa Ve'ahihi i'aitulu taubenabenali aidiyai ");
INSERT INTO kud2014_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Na vali alina yo vali alina aidiyena hi'au'aubabada, na Yaubada hiwalowalo vetuvehaeyei, na Yudeya hibom Yeisu ana tauyemidiwo Pita baidanao Yopa ainaena hilalaomawa, nuwadi ipwanopwano, wuwuna hi'ita Yaubada bada yana velau Alu'aluwa Ve'ahihi imohedi'o hibom nigele Yudeya aidiyai. Ainaena Pita iwalo aidiyai, ");
INSERT INTO kud2014_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","‘Augeluwo! Am'ita Alu'aluwa Ve'ahihi bada hivaiya'o dova ita mwalona, eeta nigele howahowana yadi bapitaiso bwahiyena ta'auhi awa?’ ");
INSERT INTO kud2014_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ainaena Pita iloina Besinana Yeisu yehanaena hibapitaiso, na mulitai tomowadine Pita hi'awanoiyei yo tupwana ahubena hinage himiyamiya, baidadi ta itatalamne. ");
INSERT INTO kud2014_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yeisu yana tauyewasao yo tauyemidiwo, hibom Yudeya ana taumiyao, bada wasa hibenalena'o ebeha tupwana nigele Yudeya tomowadiyao Yaubada yana walo hiyemidiyei. ");
INSERT INTO kud2014_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ainaena hauganane Pita iheuyo Yelusalem ainai, Yeisu ana taumulitao hibom Mosese yana loina ana tauyewasao Pitanane hi'ulumiyanei, ");
INSERT INTO kud2014_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","hiwalo, ‘Vedova ta owa uluwu hibom nigele Yudeya yadi vadai na baidamwao am'ai'ai?’ ");
INSERT INTO kud2014_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Eeta Pita i'avalaihini ta yana paihowa maudoina i'aubabadaei, iwalo, ");
INSERT INTO kud2014_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","‘Mwalona yau Yopa ainai yamiyamiya na ya'awa'awanoi Yaubada ainai, na eno'ita'ita ainaena, ehebo ginauli ya'ita dova ale'o mwala'ina na papalina vehopali aidiyena hi'aba'abahi dobima aliguwai. ");
INSERT INTO kud2014_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ginaulinane yavinuvinunui, na lagulaguwao, yo lagulagu daladaladi, yo hinage lowolowo, ale'onane holanai ya'i'itadine. ");
INSERT INTO kud2014_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Na ehebo alina yabenalei iwalo aliguwai, iwalo, “Pita, utowolo na amlagulagu ulauwunu na u'ai”. ");
INSERT INTO kud2014_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","‘Na yau yawalo, “Bada badagi! Wuwuna nigele hinage teya lagulagu laulaugagayodi teina dova yaya'aidi.” ");
INSERT INTO kud2014_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","‘Na alinane galewaena iwalouyo, iwalo, “Yaubada lagulagu neta bada i'abiye maseledi'o, ainaena havena u'awa'awa yabayababaedi”. ");
INSERT INTO kud2014_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ginauline mai tonuga aliguwai imahalava, na alinane hinage mai tonuga iwalo aliguwai, na mulitai maudoina ihae na i'wadalele galewai. ");
INSERT INTO kud2014_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","‘Na tenem mahanane ainai, towatowaho tonuga himahalavama vadanane ainai himiyamiya, Sisaliya ainaena hilaoma vehabagu. ");
INSERT INTO kud2014_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Eena Alu'aluwa Ve'ahihi iwalo aliguwai, iwalo, “Utowolo yo havena unuwanuwabwaubwau na tomowaone baidamwao amlau”. Na tahidao Yopaene hitau 6 hi'wayabuigau, ta alau Sisaliya ainai ta maudoimai aluluwune Koniliyosi yana vada alonai. ");
INSERT INTO kud2014_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","‘Na towahonane alimaiyai i'au'aubabada iwalo, “Mwalona ehebo tausagenawasa ya'ita yagu vada holanai itowotowolo”, na iwalo, ‘Koniliyosi, tomowa uvetamaledi Yopa ainai, na Saimoni yehana Pita, hilauvaiyama, ");
INSERT INTO kud2014_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","na iya wasanane mata iwalowedi alimiyai yo ainaena owa mayam huhuwo livahi amvai’.” ");
INSERT INTO kud2014_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","‘Eeta ya'avalahini na ya'au'aubabada, na Alu'aluwa Ve'ahihi aidiyai i'aituluma, dova mwalona ita alidai i'aitulu mugaiwa. ");
INSERT INTO kud2014_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ainaena Bada yana walo mwalona yanuwatuwu avivini, iwalo, “Yoni bwahiyena i'abiye bapitaisodi, na omiu mata howola abo Alu'aluwa Ve'ahihi ainaena am'abiye bapitaiso”. ");
INSERT INTO kud2014_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Na ana masele neta Yaubada yana aiyauya aidiyai dova ita alidai, hauganane tayemidi Bada Yeisu Besinana ainai. Ainaena yau nigele howahowana Yaubada yana paihowa teina ya'auhi.’ ");
INSERT INTO kud2014_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Haugana teina walowone hibenaledi ta yadi walo wahiwahiwo hilaumwauwidi na Yaubada hino'owei na hiwalo, ‘Abo Yaubada nigele Yudeya hawahawaga imohedi ta ebe hinuwabui yo yawahi miyamiya vateyaina hivai.’ ");
INSERT INTO kud2014_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Mwalona tauyemidiwo adi alehao Sitiveni hi'oiye mwalowoi, na hinage hitowoi na tauyemidiwo maudoidi hi'oiye uhagwalidi ta hilau Pinisiya yo Saipilosi yo Anitiyoki aidiyai, na wasana namwanamwana hiwalowei Yudeya hibom aidiyai, na nigele dalavanane adi taumiya maudoidi aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Mulitai tupwana tauyemidiwo, Saipilosi yo Sailini, himahalava Anitiyoki ainai na Bada Yeisu wasana higuguyaei nigele Yudeya hinage aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Na Bada i'abiye wahiyaladi, na tomowa maudoidi yadi walo hiyemidiyei, na hinuwabui Bada ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Hibom nigele Yudeya, na hesi hiyemidi'o Bada ainai, eeta tauyemidiwo Yelusalem ainai ta Banabasi hivetamalei Anitiyoki ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Haugana imahalava neta Yaubada yana ve'i'ila mwala'ina i'ita lobai ta iyaliyaya. Ainaena i'abiye wahiyaladi na ebeha maudoidi hauga daodaona Bada ainai hi'awa'awa abi na nuwadi maudoina ainaena hinuwanuwatuwu avivini. ");
INSERT INTO kud2014_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Wuwuna Banabasi towaho namwanamwana, Alu'aluwa Ve'ahihi i'oiye mwau na mayana yemidi mwala'ina Bada ainai. Eeta tomowa boda mwala'ina Bada hiyemidiyei. ");
INSERT INTO kud2014_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Banabasi ilau Tasisi ainai, Paulo ibehaei, ");
INSERT INTO kud2014_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","na ilobai, ebeha baidana hilau gwaipile Anitiyoki ainai. hitau bwau bolimai ehebo holanai hiluwuluwu tauyemidiwo yadi miya toyawa aidiyai, na tomowa maudoidi hive'ive'itadi dalavadine Anitiyoki ainai, ta Yeisu yana tauyewasao hauganane ainai hivetuwuni yehanane Keliso yana boda. ");
INSERT INTO kud2014_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Haugana tenem ainai tauwalo mahalava Yelusalemaena hidobi Anitiyoki ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Na ehebo aidiyena yehana Agabusi, yadi miyagogoi ainai itowolo, na Alu'aluwa Ve'ahihi yana wahiyalaena iwalo mugai ebeha howola vahali mwala'ina imahalava tupwa maudoina aidiyai. Mulitai tauloina Kalodiyosi yana hauga ainai vahali mwala'ina imahalava. ");
INSERT INTO kud2014_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Hauganane Yeisu yana tauyewasao Agabusi yana walone hibenalei, hibom hiloiloina ta ehebo ehebo hitowotowoi na velau hagu mane hivetamalei adi geluwone tupwa Yudeya ainai himiyamiya hihaguidi. ");
INSERT INTO kud2014_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Teina yadi vehaguhagune neta Banabasi na Saulo nimadiyai himwamwauwine ta hilalaweine tauyemidiwo yadi tauloinao tupwa Yudeya aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Hauganane ainai tauwasawasa Helodi yana loina wahiyala ainaena yana tau'alehao tupwana tauyemidiwo hi'abi avivinidi na hi'abiyababadi. ");
INSERT INTO kud2014_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ainaena Yemesa Yoni tahina, Helodi yana loinaena na elepa ale'aleha ainaena hi'oiye mwalowoine. ");
INSERT INTO kud2014_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Na i'i'itane neta teina mumugane Yudeyaone i'abiye yaliyayadi eeta ihamadudui ta Pita ipapaine. Teina mumugane neta Buidi'wa guyauna ainai ivevetuwunine. ");
INSERT INTO kud2014_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Na haugana Pita ipai ta vada paipaiyai imwauwi ta i'ovi na tau'ita avivini tomowa vehopali vehopali ihiwaidi ta ilau boda vehopali ipapaihowaidine. Yana nuwatuwu ebeha Buidi'wa guyauna tuluhanai Yudeyaone imohedi na hi'oiye mwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Eeta vada paipaiyai himwauwi ta imiyamiya na hesi tauyemidiwo vehabana hi'awa'awanoi wahiyala Yaubada ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Mata i'ahubena na boniyainane ainai Helodi Pita mata i'oiye mwalowoi. Na wau boniyainane tau'alehao bwau awa'edane neta gulawa pwawapwawati ainaena Pita hipaigwaigwaipileyei yo himomohi bwauwedi na hi'eno'eno na hinage tau'aleha bwau vehaudi hi'ita'ita avivini. ");
INSERT INTO kud2014_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Nigele bweda na masele vadane alonai ihinali ta Yaubada yana tausagenawasa itowolo mahalava. Towahone Pita labelabenai igoha na ivanoi iwalo, ‘Utowolo mwayamwayau’. Gulawa pwawapwawatiwowa Pita nimanai hibebe'une. ");
INSERT INTO kud2014_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Na tauwagenawasane iwalo lau Pita ainai iwalo, ‘Am ale'o yo am aehumahuma uli'wadi’. Eeta Pita i'awa abiyei, na tausagenawasane iwalouyo iwalo, ‘Am abobo ainaena u'ohamuigo na umulitaegau’. ");
INSERT INTO kud2014_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Eeta tausagenawasane imahalava na Pita imulitaei ta vada paipaine i'aitulu gabaeine. Na hesi tausagenawasane hava ipaipaihowaidine neta moihadi himahamahalava na Pita nigele iyanuwamasele. Yana nuwatuwu ebeha i'e'eno nivinivi. ");
INSERT INTO kud2014_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Hilaoma ta tau'ita avivini ehebo hilaugabaei, na bwauna hinage hilaugabaei, na awa'eda mwala'ina pwawati hipapaihowaine ainai hilaoma, na awa'edane ibom ilotaho'e, na himahalava dalavai, na amwahaena hilau bwaubwau nigele daona na tausagenawasane Pita ilaugabaeine. ");
INSERT INTO kud2014_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ainaena Pita inuwamasele, na iwalo, ‘Yahanapuiya'o ebeha yau Helodi nimanaena Bada iyaiyovigau na yana tausagenawasa ivetamalei, ta ihahaloigaune. Na hinage Yudeyaone yadi nuwanuwatuwu ebeha aliguwai hava hipaihowai neta yalaugabaidi'o.’ ");
INSERT INTO kud2014_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pita bada nuwana imasele'o na ilau Meli yana vadai, Yoni hinana, na Yoni yehana bwauna Maki, na vadanane holanai tauyemidiwo maudoidi himiya gogoi, na hi'awa'awanoi Yaubada ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Na Pita vada ana awa'eda ainai i'aigohagoha, na taupaihowa waihiuna ehebo yehana Loda ilaoma. ");
INSERT INTO kud2014_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Na Pita alinana ibenali lobai, ta iyaliyaya mwala'ina, na nigele awa'eda iho'e, eeta ilau gwaipile ta vada holanai iwalo, ‘Pita awa'edai itowotowolo’. ");
INSERT INTO kud2014_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Na hiwalo, ‘Nuwana uyauyaule!’. Na waihiune awana ipa'i'i ebeha Pitanane. Eeta hiwalo, ‘Nuwana Pita alu'aluwana’. ");
INSERT INTO kud2014_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Hi'awa pa'ipa'i'i na Pita howola i'ai'aigohagoha, ainaena awa'eda hiho'e ta hi'ita ebeha ibom Pita, na nuwadi ipwanopwano moiha. ");
INSERT INTO kud2014_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Na Pita nimanaena i'auhidi na hinobu, na iwalo aulidi Bada vada paipaiyena ilauvaiyama. Ainaena iwalo, ‘Wasa teina amwalowei Yemesa yo augeluwo aidiyai’. Na ilaugabaidi ta ilau vali tupwai. ");
INSERT INTO kud2014_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","I'ahubena na tau'alehao nuwadi ipwanopwano, na hi'atehawawali mwala'ina Pita vehabana, vedova imamahalavane. ");
INSERT INTO kud2014_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Na Helodi iloinaedi ta Pita hibehaei, na nigele hiyalobai, ainaena tau'ita aviviniwone yadi lauvetala ipaihowai, na adi oiyemwalowoi iloinaei. Eeta Helodinane Yudeya ainaena idobima Sisaliya imimiyane. ");
INSERT INTO kud2014_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Helodi hiya Taya yo Saidoni imodi'iniyedi eeta hiya nuwanuwadi ebeha hivenuwa ehebouyo. Ainaena hilaoma ta yana vada ana tau'ita avivini yehana Bilasito baidadi hi'awa heliheliyam. Na hi'awanoiyei ta ebeha tauwasawasane yo hiya hivenuwa ehebo. Wuwuna tauwasawasane yana dalavai hiduivahali lau ai'ai yana tupwa ainaena. ");
INSERT INTO kud2014_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Na Helodi ehebo ahubena iwalowei na baidadi hi'au'aubabada, na ahubenanane ainai ana ale'o vauvauna ili'wa, na yana abamiya wasawasa ainai imiya. ");
INSERT INTO kud2014_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Na bodaone hiyogayoga, na hiwalo, ‘Yam aubabada bada dova Yaubada na nigele tomowa’. ");
INSERT INTO kud2014_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Na yadi no'o ivai ta nigele Yaubada iyawalo vetuvehaeyei eeta Bada yana tausagenawasa Helodi ipaihowai ta i'a'asiyebwane ta mwatamwata hiwomali ta imwamwalowoine. ");
INSERT INTO kud2014_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Neta hauganane ainai tomowa Yaubada yana walo hibenalei yo hi'awa abiyei. Na yadi boda imwalamwala'i. ");
INSERT INTO kud2014_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Na Banabasi yo Saulo yadi paihowa Yelusalem ainai hive'oviya'o, ta hidobiuyo Anitiyoki ainai, na Yoni yehana bwauna Maki hilauvai baidadi. ");
INSERT INTO kud2014_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Tauyemidiwo Anitiyoki ainai, neta tupwadi yadi tauwalo mahalavao yo tauve'itao. Eeta teina yehadi, Banabasi na Simiyoni iya hiyogaei taugibagibana, na Lusiyasi iya gama Sailini, na Mana'eni iya tauwasawasa Helodi ana abi'abiyemwala'i, yo Saulo. ");
INSERT INTO kud2014_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Hibom hitapwatapwalolo mayadi hudi Yaubada ainai na Alu'aluwa Ve'ahihi iwalo aidiyai, iwalo, ‘Nuwanuwagu Banabasi na Saulo yagu paihowa ehebo vehabana hipaihowai, ainaena amtalamwedi paihowanane ainai’. ");
INSERT INTO kud2014_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Eeta Yaubada ainai hi'awanoiuyo mayadi hudi, na hi'abivahuidi, na Banabasi yo Saulo hivetamaledi yadi paihowane vehabana. ");
INSERT INTO kud2014_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Alu'aluwa Ve'ahihi bada ivetamaledi'o ta hi'aitulu Selusiya, na wagaena higelu ta hi'adau bwanabwana Saipilosi vehabana. ");
INSERT INTO kud2014_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Na dalava yehana Salamisi ainai hiduna, ta nemai Yudeya yadi vada tapwalolo ainai Yaubada yana walo higuguyaei. Na ehebo yadi hevali baidadi hita'i'ili yehana Yoni Maki. ");
INSERT INTO kud2014_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bwanabwanane maudoina hita'i'iliyei, na dalava Paposi ainai himahalava, ta tenemai tau'oba yehana Bayeisu, towaho Yudeya, ibom teya tauwalo mahalava oya'oyamana. ");
INSERT INTO kud2014_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Na Bayeisunane Sagiyo Paulosi baidana, iya dalava ana tauloina, na towaho hanahanapuna. Ainaena Sagiyo Paulosi Banabasi na Saulo iyogaedima, na nuwanuwana ebeha Yaubada yana walo ibenalei. ");
INSERT INTO kud2014_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Na hesi tau'obane i'auhidi, wuwuna nigele nuwanuwana na tauloinane Yeisu ainai iyemidi. Tau'obane yehana ana bui Elimasi neta taubalau. ");
INSERT INTO kud2014_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Na Saulo iya yehana bwauna hiyogaei Paulo, Alu'aluwa Ve'ahihi i'oiye mwau na tau'obane ivinuvinunui. ");
INSERT INTO kud2014_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Na iwalo, ‘Owa Tomodulele yo Alawai yana boda, na oyama wuwuna, ainaena paihowa dumwadumwaluna uve'alehaei na Bada yana amwaha dumwadumwaluna hauga maudoina utowotowoi ta u'abiye yababa yo u'abiye giyo. ");
INSERT INTO kud2014_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Eeta teina mata Bada yana wahiyalaena mehem igibu ta mata nigele uyavinunuyo ana higa Yaubada yam ahubena iwawaloweiwa ainai abo uvinunuyo.’ Hauga tenem ainai dova hogahoga na tau'obane mehena iguguyou, ta ibehabeha yaiya ihagui na ivedadabi. ");
INSERT INTO kud2014_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Na tauloinane Sagiyo Bada yana ala'alawowoli teina i'ita na Bada wasana vehabana nuwana ipwanopwano, eeta iyemidiyei. ");
INSERT INTO kud2014_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo ma'ana bodao Paposiyena higelu, na hi'adauyo ta Pega ainai hiluluwune, tupwa Pamipiliya holanai. Na Yoni Maki ilaugabaidi ta iwuyo Yelusalem ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Na bodaone Pega hilaugabaei, na Anitiyoki ainai himahalava, neta tupwa Pisidiya holanai. Eena ahubena Yudeya yadi tapwalolo ana ahubena ainai hiluwu Yudeya yadi vada tapwalolo ainai hitalumiyahiwa. ");
INSERT INTO kud2014_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Haugana Mosese yana loinao yo tauwalo mahalavao yadi laulele vahilina tuluhanai vada tapwalolo adi babadao walo hivetamalei Paulo ma'ana geluwo aidiyai hiwalo, ‘Tahimaiyao, ebe tomowa abiye wahiyalana aubabadadi alimiyai neta amwalowedi’. ");
INSERT INTO kud2014_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ainaena Paulo itowolo na nimana i'abihini, ta iwalo, ‘Tahiguwao Isileli yo omiu vali tupwaena Yaubada ana tauve'ahihiwo, yagu walo teina ambenalei. ");
INSERT INTO kud2014_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Yaubada mwalona Isileli tubudao ivesinuwaidi, na yadi boda i'abiye mwala'i yadi miya taumana Itipita ainai, na yana wahiyala mwala'ina ainaena imugaiyedi, ta Itipita hilaugabaeine. ");
INSERT INTO kud2014_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Na bolimai 40 aidiyai yadi tapiyao i'alama'i'itaedi haugana balabala awawai hilaulau. ");
INSERT INTO kud2014_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Na Kenani bale'une holanai dalava ana bagibagili 7 matomowadi imumutudine. Na tubudaone italamwedi ta Kenani bale'une hiloloinaeine, ");
INSERT INTO kud2014_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","neta bolimai ana bagibagili 450 aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","‘Hi'awa'awanoi na Yaubada yadi tauwasawasa imohedi Saulo, ibom Kisa natuna, na yana huhu Beniyamina ainaena, na bolimai 40 aidiyai iloiloinaedi. ");
INSERT INTO kud2014_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Mulitai Yaubada Saulo isosomanaei, na yadi tauwasawasa vauvauna Deivida imwauwi, iya Deivida vehabana iwalo, “Yesi natuna Deivida yalobai, na yavelauwei wuwuna yagu nuwatuwu maudoina mata ipaihowaidi”. ");
INSERT INTO kud2014_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","‘Ta Deivida yana huhu ainaena Yaubada Isileli adi Taulivahi Yeisu i'abiye mahalava, dova mwalona iwalo mugai. ");
INSERT INTO kud2014_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Na mwalona hauganane ainai Yeisu nigele iyadobima, Yoni iguguya Isileli aidiyai, na yadi lauhapuli aidiyena hinuwabui, na i'abibapitaisodi. ");
INSERT INTO kud2014_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yoni yana paihowa ana aba'ovi ainai iwalo, omiu amnuwatuwui ebeha yau yaiya? Yau nigele Taulivahine na iya tuluhaguwena ilalaoma iya imwala'i gabaegau, ainaena yau nigele iyalowoinanegau na ana aehumahuma yavaivehulu. ");
INSERT INTO kud2014_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","‘Tahiguwao, omiu Isileli yo Abelaham tubunao, na omiu nigele Yudeya yaiyadiwo Yaubada hino'ono'owei teina ainai, ita alidai teina livahine wasana Yaubada ivevetamalenamane. ");
INSERT INTO kud2014_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Wasane neta Yeisu vehabana, na hesi yaiyadiwo Yelusalem ana taumiyao yadi tauloinao baidadiyao nigele hiyahanapui ebeha iya Taulivahine. Na hinage tauwalo mahalavao yadi walo tapwalolo bagibagilidi aidiyai hivahivahili neta nigele hiyanuwatuwu lobai. Hesi Yeisu hive'ewai ta ainaena tauwalo mahalavao yadi walo iyemala moiha. ");
INSERT INTO kud2014_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Nigele teya yana lauhapuli hiya'ita lobai, na hesi Pailato hi'awanoiyei ebeha hi'oiye mwalowoi. ");
INSERT INTO kud2014_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ainaena walodine Buki Ve'ahihi ainai hiwalo mugaiyedi'o Taulivahi vehabana na maudoina Yudeya bada hipaihowaidi'o, na yana mwalowoi tuluhanai aiwa lagalagana ainaena himwau aituluwei, ta magai ainai himwamwauwine. ");
INSERT INTO kud2014_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Eeta Yaubada mwalowoiyena i'abiye towolouyoi, ");
INSERT INTO kud2014_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","na ahubena tupwana bagibagilina aidiyai imahamahalava, ana taumulitaone aidiyai. Hibom mwalona baidanao Galiliyena yo Yelusalemaena hilaoma. Hiya teina wau ana tauwalo moiha hiwalowalo mahalava tomowa aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","‘Na ai hinage wasana namwanamwana amohegomiu, mwalona Yaubada yana waloyemidi tubudao aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Na bada hi'abiye mahalavaya'o yaso vauvauna ita alidai, haugana Yeisu yana mwalowoiyena i'abiye towolouyoi. Teina vehabana Sam bwauna ainai Yaubada yana walo hiwalo mugaiyei, iwalo: “Owa natugu wau teina ainai ya'awa Natuguwego”. ");
INSERT INTO kud2014_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Na Yaubada Yeisu i'abiye towolouyoi ta nigele howahowana Yeisu ipwaha, dova yana walo tenem dova iwalo: “Mata awanamwanamwa ve'ave'ahihina yamohego neta Deivida ainai yawawalo yemidiyeiwa”. ");
INSERT INTO kud2014_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Na ainaena iwalouyo iwalo, “Havena utalatalam ta yam taupaihowa ve'ave'ahihina ipwahapwaha”. ");
INSERT INTO kud2014_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","‘Walo teina nigele Deivida vehabana. Deividanane yana hauga ainai Yaubada yana nuwatuwu ipaihowaidi, na imwalowoi na himwauwi magaiyai, na tubunao baidanao hipwapwahane. ");
INSERT INTO kud2014_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Na hesi towahonane mwalowoiyena Yaubada i'abiye towolone nigele iyapwaha. ");
INSERT INTO kud2014_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","‘Ainaena tahiguwao amhanapui moiha ebeha teina towahone ainaena yami lauhapuli inuwahamuidi ta neta vehabana na wasana aguguyaei alimiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Na ebe yaiya ibom ainai yemidi, yana lauhapuli aidiyena ilivahi, na hesi Mosese yana loina nigele howahowana ilivahigomiu. ");
INSERT INTO kud2014_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ainaena am'ita avivinigomiu na walonane tauwalo mahalavao mwalona vehabana hiwalowalo yemidiwa, havena amve'ave'alo. Walonane iwalo: ");
INSERT INTO kud2014_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Omiu tau'abitalawahi ambenabenali, amlau yabayababa na ammwalowoi. Wuwuna yami hauga ainai paihowa hava yapaipaihowaine mata nigele amyayemidiyei. Bwagana teya tomowa iwalo auligomiu na mata nigele amyayemidiyei.” ’ ");
INSERT INTO kud2014_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Haugana Paulo na Banabasi himahalava, na bodaone hi'awanoiyedi ta vali tapwalolo ainai ve'ita teina vehabana aidiyai hiwaloweuyoi. ");
INSERT INTO kud2014_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Na boda vada tapwalolowena himahalava, na tupwana Yudeya yo tupwana Yaubada ana tauyemidiwo vali tupwa yo vali tupwa aidiyena, Paulo na Banabasi himulitaedi, ainaena Paulo na Banabasi aidiyai higuguya ta ebeha Yaubada yana ve'i'ila hi'ita yo hi'abi avivini. ");
INSERT INTO kud2014_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Na vali tapwalolo ainai dalava ana taumiyaone maudoidi himiya ahaidi Bada yana walo vehabana yo habi benaleina. ");
INSERT INTO kud2014_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Hiya Yudeya boda mwala'ina hi'i'itane, na hi'alomagigili, yo Paulo yana guguya ainai hi'awa yabayababaei. ");
INSERT INTO kud2014_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Hesi Paulo na Banabasi mayadi atepatu hiwalo mahalava Yudeya aidiyai, hiwalo, ‘Ilowoinanei na Yaubada yana walo awalo mahalava mugai alimiyai, na hesi amta'wata'wataei, na omiu ambom amloinaegomiu ebeha nigele howahowana na yawahi vateyai amlobai, neta vehabana ata'wata'awataegomiu ta vali bodao aidiyai aguguya hibom nigele Yudeya. ");
INSERT INTO kud2014_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Wuwuna Bada ivenuwamwau'o alidai, iwalo: “Yami paihowa bada yamohegomiu'o na ebeha omiu nigele Yudeya yadi masele, na tupwa maudoina aidiyai adi livahi amlawei”.’ ");
INSERT INTO kud2014_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ainaena hibom nigele Yudeya Paulo na Banabasi yadi walo teina hibenalei, na hiyaliyaya mwala'ina, ta Yaubada wasana hi'awa namwanamawaei. Na yaiyadiwo Yaubada ivesinuwaidi yo yawahidi miyamiya vateyaina hilobai, ebe walonane hiyemidiyei. ");
INSERT INTO kud2014_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Na Bada wasana ivehulu tupwa maudoina aidiyai, yo holadiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Na Yudeya Paulo na Banabasi hive'alehaedi, na hi'ulumiyaedi, hiya waiwaihiu alawatao yo tautapwalolo yo hinage dalava adi babadao. Eeta Paulo na Banabasi hiheusilidi, ta tupwanane hilalaugabaeine. ");
INSERT INTO kud2014_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Na mulitai abo tupwanane hilaugabaei, aedi namonamona hi'oiye hoyeholudi yadi tupwai neta aba'ita taumiya dalava aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Na ainaena taumulitao hiyaliyaya mwala'ina, na Alu'aluwa Ve'ahihi i'oiye mwaudi. ");
INSERT INTO kud2014_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Aikoniyom ainai Paulo na Banabasi Yudeyaone yadi vada va'ahihi ainai hiluwu ta higuguya. Yadi guguya ainai hibom Yudeya na nigele Yudeya boda mwala'ina hiyeyemidine. ");
INSERT INTO kud2014_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Na Yudeya tupwadi Besinana nigele hiyayemidiyei, na hiwalo huluhuluidi hibom nigele Yudeya ta tauyemidiwo heve'alehaedi. ");
INSERT INTO kud2014_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Eeta Paulo na Banabasi himiya daodao Aikoniyom ainai. Bada vehabana hi'au'aubabada wahiyala. Na Bada yana ve'i'ila iyemala moiha yadi walowo vehabadi neta Paulo na Banabasi ipaihowaidi ta ve'ive'ilala yo ala'alawowoli nimadiyena hi'abi'abiye mahalavadi. ");
INSERT INTO kud2014_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Dalavane alonai neta tomowa hiwahei ta boda bwau. Tupwadi tauyemidiwone aidiyena hilalaune na tupwadi Yudeyaone aidiyena hilalaune. ");
INSERT INTO kud2014_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Eeta Yudeyaone yo nigele Yudeyaone, yadi babadao baidadiyao hi'ulewahi ta ebeha Paulo na Banabasi hiwalo sebasebaiyedi na gaimaena hitalaidi. ");
INSERT INTO kud2014_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Haugana yadi ulewahine hihanapui Paulo na Banabasi hidena ta hilalaune Lisitila yo Debi, dalava mwala'ina Laikoniya tupwanane ainai. Na hinage davala tupwadi Laikoniya alonai, ");
INSERT INTO kud2014_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","aidiyai Yaubada yana walo higuguyaei. ");
INSERT INTO kud2014_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Tomowa ehebo Lisitila ainai imiyamiya neta hinana diyanai aena yababana ta haugana itubui nigele iyalaulau na hesi imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Iya Paulo yana walo ibenalei na Paulo towahone ivinuvinunu ili'ilimani ta iwalo, ‘Teina towahone yana yemidi vehabana howahowana na inamwanamwa’. ");
INSERT INTO kud2014_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Eeta Paulo ilaumwau na towahone ivinuvinunui ta alinana mwala'ina ainaena iwalolau iwalo, ‘Aemwena utowolo dumwadumwalu!’. Towahone itaugavai ihae na idobi italutowolone ta aenaena ilau na ilaoma. ");
INSERT INTO kud2014_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Hava Paulo ipapaihowaine, boda hi'itaya'o ta Laikoniya alinadiyena hiwui hiwalo, ‘Yaubada bwau hiyemala tomowa mohili ta hi'aituluma alidai’. ");
INSERT INTO kud2014_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Banabasi yadi yaubada hiyewaligehaei ta hiwalo ‘Siusi’. Na Paulo yadi yaubada vehauna hiyewaligehaei ta hiwalo ‘Hemisi’, wuwuna iya miyagogoi ana tauloina. ");
INSERT INTO kud2014_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Yaubada Siusi yana taupwaoli yana vada tapwalolo dalavane vahalinai neta bulumakau yo vane ilawedima dalavane awa'edanai na ainai ebeha tomowa baidanao hipwaoli tauyewasaone aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Hesi Paulo na Banabasi teina paihowaone hibenalena'o ta yadi luwuluwu hilivahidi na boda alodiyai hiluwu ta hiwuiwui hiwalo, ");
INSERT INTO kud2014_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","‘Vedova ta teina mumugane ampaipaihowaine? Ai tomowa mohili dova omiu. Na alaoma ebeha wasana namwanamwana a'aubabadaei alimiyai ta teina mumugaone amta'wata'wataedi na am'ita gwaipile Yaubada Mayawahine ainai. Teina Yaubadane iya galewa yo bale'u yo ni'u iyeyemaseledine. Na alodiyai hava himiyamiya hinage iyemaseledine. ");
INSERT INTO kud2014_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Mwalona yaso mugamugaina italamwedi ta yadi nuwatuwuwo hibom himulimulitaedi. ");
INSERT INTO kud2014_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Hesi mumuga namwanamwadi hauga maudoina ipaipaihowaidi neta hiyemala moiha aidiyai. Mahuli yo dohi galewaena imohegita. Ai'ai imohegita ta ateda i'abiye yaliyayadi.’ ");
INSERT INTO kud2014_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Teina abawalo au'auhine wuwudi hiwalowedi na hesi howola boda hi'ai'aipate ebeha Paulo na Banabasi hipwaoli aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Tupwadi Yudeya Anitiyokiyena hilalaomane neta Pisidiya alonai yo Aikoniyomyena hilaoma Lisitila ainai. Hiya tomowa bodadi yadi nuwatuwuwo hi'oiye tomatomadi ta Paulo gaimaena hitalai na hiniulilawei dalavane papalinai. Yadi nuwatuwu ebeha bada imwalowoi'o. ");
INSERT INTO kud2014_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Na hesi haugana tauyemidiwo hilaoma na hitowolo gwaigwaipileyei, itowolo ta dalavane ainai iluluwuyone. I'ahubenama ta iya na Banabasi baidana hilalaune Debi. ");
INSERT INTO kud2014_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulo na Banabasi wasa namwanamwana Debi ainai higuguyaei ta tomowa bodadi hi'abiye nuwabuidi. Na hilau gwaipile ta hilau Lisitila ainai yo Aikoniyom ainai yo hilau Anitiyoki neta Pisidiya alonai. ");
INSERT INTO kud2014_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Yadi lau aidiyai tauyemidiwo hi'abiye wahiyaladi ta hiwalo, ‘Am atepatu yami yemidiwo aidiyai. Wuwuna to'oto'o bagibagilidi mata tagiulidi na abo Yaubada yana Abaloina ainai tamahalava.’ ");
INSERT INTO kud2014_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paulo na Banabasi boda ehebo ehebo alodiyai yadi babadao hivetowolodi. Na mayadi awanoi yo mayadi hudi hi'aiyauyaedi Bada nimanai wuwuna iya ainai yadi yemidi himwauwidi. ");
INSERT INTO kud2014_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidiya tupwana hitauyayahi na abo hilalaune Pamipiliya yana abaloina ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Wasa namwanamwana Pega ainai higuguyaei na abo hidodobine Ateliya. ");
INSERT INTO kud2014_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ta Ateliya ainai na higelu ta hilalaune Anitiyoki teya ainai neta Siliya tupwanai. Mwalona Anitiyoki ainai tauyemidiwo Yaubada yana ve'i'ila yo yana ita'avivini vehabana hi'awanoi ta Paulo na Banabasi hivevetamalediwa neta himahalavauyo wuwuna yadi paihowa hive'ovidi'o. ");
INSERT INTO kud2014_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Haugana Anitiyoki ainai himahalava, tauyemidiwo yadi boda hitau'ahaidi na Yaubada ginauli maudoidi aidiyai ipaipaihowaidi neta hiwalo aulidi. Na nigele Yudeya Yaubada yadi hawahawaga imohedi ta hiyemidi. ");
INSERT INTO kud2014_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Na Anitiyoki ainai tauyemidiwo baidadiyao himiya daodao. ");
INSERT INTO kud2014_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tomowa tupwadi Yudeyaena hilaoma Anitiyoki ainai ta adi geluwo hive'ive'itadi hiwalo, ‘Ebe nigele yami ve'ive'ilala 'wapi ana hapi amyavai dova Mosese iloina ilelelelewa ainai mata nigele livahi amyavai’. ");
INSERT INTO kud2014_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulo na Banabasi tomowaone baidadiyao heveta'eta'e teina walone vehabana. Eeta Paulo na Banabasi tomowa tupwadi hivevetowolodiwa baidadiyao hilau Yelusalem ainai ta tauyewasao yo tauloinao ebeha hi'itadi teina walone vehabana. ");
INSERT INTO kud2014_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Paulo na Banabasi yo tomowaone hivetamaledi ta hilaulau neta haugana Pinisiya tupwanane yo Sameliya tupwanane hiluwuidi ta hilau na hiwalowalo mahalava hiwalo, ‘Hiya nigele Yudeya Yaubada hiyemidiyei’. Teina wasane ainaena tauyemidi maudoidi hiyaliyaya mwala'ina. ");
INSERT INTO kud2014_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Haugana Yelusalem ainai himahalava, tauyemidi yadi boda yo tauyewasao yo tauloinao hi'abiye yaliyayadi. Na Paulo na Banabasi Yaubada ginauli maudoidi aidiyai ipapaihowaidiwa neta hiwalo aulidine. ");
INSERT INTO kud2014_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Hesi Yudeyaone yadi loina adi tauve'itao tupwadi Yeisu himulitaei ainaena hitowolo ta hiwalo, ‘Hiya nigele Yudeya tomowadiyao yaiyadiwo Yeisu hiyemidiyei amwalo aulidi amwalo, “Ve'ive'ilala 'wapi ana hapi amvai ta dova Mosese yana loina ilelelelewa neta ebeha am'awa abiyei”.’ ");
INSERT INTO kud2014_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Eeta tauyewasao yo tauloinao himiya ahai ta teina walone hi'a'aubabadaneine. ");
INSERT INTO kud2014_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Na yadi aubabadane ana daodao alonai neta Pita itowolo ta iwalolau aidiyai iwalo, ‘Tahiguwao, amhanapuiya'o mwalona alomiyena na Yaubada ivesinuwaigau yo ebeha hibom nigele Yudeya aidiyai wasa namwanamwana yaguguyaei, na mata hibenalei yo hiyemidi. ");
INSERT INTO kud2014_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Na tomowa yadi nuwatuwu neta Yaubada ihanapu ili'ilimanidi'o, ta nigele Yudeya yaiyadiwo hiyemidiyei i'awa namwanamwaedi. Yana awanamwanamwa i'abiye mahalava neta Alu'aluwa ve'ahihi imohedi dova ita imomohegitane. ");
INSERT INTO kud2014_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Hiya yo ita nigele iya'ita ve'ahagita. Atedi i'abiye maseledi wuwuna hiyemidi. ");
INSERT INTO kud2014_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ainaena taumulita vauvaudi havena ta'abi'abiye be'udi Mosese yana loina ainaena. Teina vitaine nigele howahowana ebeha ta'avalai wuwuna mwalona ta wau neta loinane yada ababe'u. Teina paihowane ainaena havena Yaubada tatowotowoi. ");
INSERT INTO kud2014_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ta yemidi'o ta Bada Yeisu yana ve'i'ilaena livahi tave'aloya'o bada dova hiya hinage.’ ");
INSERT INTO kud2014_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pita yana walo tuluhanai tomowa maudoidi himiya nobu ta nigele alinadi. Na mulitai Banabasi yo Paulo Yaubada yana ve'ive'ilala yo yana ala'alawowoli maudoidi nigele Yudeya aidiyai ipapaihowaidiwa neta maudoina hi'aubabadanedi. ");
INSERT INTO kud2014_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Yadi aubabada tuluhanai Yemesa iwawalone iwalo, ‘Tahiguwao, ambenabenali! ");
INSERT INTO kud2014_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Pita i'aubabadaei vedova Yaubada nigele Yudeya aidiyai i'abiye mahalavauyoi ta aidiyai yana tomowa ivesinuwaidi. ");
INSERT INTO kud2014_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Tenemdova tauwalo mahalavao yadi walo Yaubada yana buki ainai i'awa namwanamwa iwalo: ");
INSERT INTO kud2014_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Teina tuluhanai mata yawuyoma yo Deivida yana vada iguguliwa yavetowolouyoi. Hava iyayababawa mata ya'abiye vauvauyoi, na yavetowolodi, ");
INSERT INTO kud2014_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","yo mata tomowa maudoidi yau Bada hibehaegau. Na nigele Yudeya mayehadi mata yagu tomowao. ");
INSERT INTO kud2014_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Teina dova Bada alinana mwalona iwawalo mahalavaeine.” ");
INSERT INTO kud2014_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","‘Eeta yagu loina ebeha nigele Yudeya Yaubada hiyemidiyei, havena adi vitai tamwaumwauwi. ");
INSERT INTO kud2014_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Na hesi tawalo aulidi leta ainaena ta havena ai'ai himohemohedi abapwagogo aidiyai hi'ai'aidi. Havena himehemehe'ayo. Hinage havena uibai ma'wahinana yo gadodi hi'i'idi hi'ai'aidi. ");
INSERT INTO kud2014_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Wuwuna teina loinaone Mosese ileleleledine hauga daodaona higuguguyaei hiya Yudeya yadi vada tapwalolo ainai. Ta yana walo higuguyaei tapwalolo ehebo ehebo dalava maudoina ainai.’ ");
INSERT INTO kud2014_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tauyewasao yo tauloinao yo tauyemidiwo bodadi baididiyao hi'ulewahi ta tomowa hivesinuwaidi bodane alonai. Hiya mata Paulo na Banabasi baidadiyao hivetamaledi ta hilau Anitiyoki ainai. Tomowaone hivevetowolodine neta Yudasa (yehana vehauna Basabasi) na hinage Sailasa. Neta hitau bwauwone tahidaone hive'ahihi ili'ilimanidi. ");
INSERT INTO kud2014_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Tomowaone hivetamaledi leta baidana ta hilalaune neta tenem dova yana walo: Tauyewasao yo tauloinao ai tahimiyao yama awayauwedo omiu tahimaiyao maudoimiu alimiyai. Omiu nigele Yudeya tomowadiyao Anitiyoki ainai yo Siliya ainai yo Silisiya adi taumiyao. ");
INSERT INTO kud2014_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Bada abenalena'o neta yama boda ainai tomowa hilaowa ta hi'abiye vitaigomiu yo nuwamiu hi'abiye yababadi'o yadi walo aidiyena hesi nigele alimaiyai hiyapanivila na teina laulaune hipapaihowaine. ");
INSERT INTO kud2014_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Eeta amiya ahai ta maudoimai atalam na tomowa avesinuwaidi ta hilalaowane alimiyai ada geluwo Banabasi yo Paulo baidadiyao. ");
INSERT INTO kud2014_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Hitaubwau yawahidi hitalamwei Bada Yeisu Besinana yahanaena. ");
INSERT INTO kud2014_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Na Yudasa yo Sailasa avetamalediwa'o hiya mata ginauliwowa alelelelediwa howahowadi mata hiwalo auligomiu. ");
INSERT INTO kud2014_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Wuwuna Alu'aluwa Ve'ahihi yana nuwatuwu dova yama nuwatuwu ta ebeha havena a'abi'abiye vitaigomiu, na hesi teina ginauliwone hibom ammulitaedi. ");
INSERT INTO kud2014_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ai'ai himohemohedi abapwagogo aidiyai havena am'ai'aidi. Havena uibai ma'wahinadi yo gadodi hi'i'idi am'ai'aidi. Havena ammehemehe'ayo. Ebe teina ginauliwone havena aidiyai amya'abi'abilau neta mata ammiya ili'ilimani. Kaiyoni. ");
INSERT INTO kud2014_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Tauyewasaone hivetamaledi ta hilalauwa neta hidobi Anitiyoki ainai ta tauyemidiwo yadi boda hilau ahaidi na letane himomohedine. ");
INSERT INTO kud2014_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Na tomowaone letane hivahili ta yana walo abiyewahiyala ainaena ta hiyaliyaya moiha. ");
INSERT INTO kud2014_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yudasa na Sailasa neta hiya Yaubada yana tauwalo mahalavao eeta adi geluwo baidadiyao hi'aubabada mwala'ina. Hi'abiye wahiyaladi ta hitowolo wahiyala. ");
INSERT INTO kud2014_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Hiya baidadiyao himiya daodao, na abo hivetamaledi yo mayadi nuwadaumwali hilau gwaipile tauvetamalediwa aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Hesi Sailasa inuwanuwatuwu ta nemai imimiyane. ");
INSERT INTO kud2014_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo na Banabasi Anitiyoki ainai himiyamiya, na tomowa bagibagilidi baidadiyao Bada yana walo higuguyaei yo heve'itaei. ");
INSERT INTO kud2014_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ahubena viha hi'ovi na Paulo iwalolau Banabasi ainai, iwalo, ‘Talau gwaipileuyo ta tahidaone tataubo'eyedi mwalona dalavaowa aidiyai Bada yana walo taguguyaeiwa hola ta'itauyoidi vedova yadi miyamiya ana ita’. ");
INSERT INTO kud2014_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabasi yana venuwa ebeha Yoni Maki hilauvai ta baidadi hilau. ");
INSERT INTO kud2014_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Na Paulo inuwanuwatuwu ta nigele iyadumwalu, wuwuna mwalona Pamipiliya himiyamiya ta Yoni Maki idena gabaedi na nigele iyamulitaedi ta yadi paihowa hiyave'ovi. ");
INSERT INTO kud2014_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ainaena Paulo na Banabasi teina walowone aidiyena na hi'awa pa'ipa'i'i ta hiwawaheine. Banabasi Yoni Maki ilauvai ta hi'u'e yo hilalaune Saipilosi. ");
INSERT INTO kud2014_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Na Paulo Sailasa ivesinuwai ta baidana ebeha hilau, nigele ta adi geluwo hi'awa'awanoi Paulo yo Sailasa vehabadi ebe Bada yana ve'i'ila yo yana ita'avivini imiya vahalidi. ");
INSERT INTO kud2014_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Na hiso'e'eli ta Siliya na Silisiya yadi abaloina dalavadiyao hiluwuidi yo tauyemidiwo yadi boda maudoidi hi'abi'abiye wahiyaladi. ");
INSERT INTO kud2014_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Neta hauganane ainai Paulo na Sailasa hilau Debi ta hinage hilaugabaei yo hilau Lisitila. Na nemai Lisitila ehebo taumulita imiyamiya, yehana Timoti. Timoti hinana neta waihiu Yudeyaena na Yeisu iyemidiyei. Na tamana towaho Gilisiyena. ");
INSERT INTO kud2014_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tauyemidi maudoidi Lisitila yo Aikoniyom aidiyai neta Timoti hi'awa namwanamwaei moiha. ");
INSERT INTO kud2014_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo nuwanuwana ebeha Timoti ilauvai. Eeta Yudeyaone yadi paihowaena yadi ve'ive'ilala 'wapi ana hapi ivai wuwuna tomowa nemai taumiya hiya Yudeyaone hihanapuiya'o ebeha Timoti tamana towaho Gilisiyena. ");
INSERT INTO kud2014_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Lisitila hilaugabaei yo hilaulau dalava ehebo ehebo hiluwuidi ta Yelusalem ana tauyewasao yo ana tauloinao hava hiloloinaewa neta tauyemidiwo hiwalo aulidi ebeha hi'awa abiyedi. ");
INSERT INTO kud2014_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Eeta tauyemidi yadi boda hi'abiye wahiyaladi ta ahubena ehebo ehebo tomowa hinuwanuwabui na tauyemidi yadi boda imwalamwala'i. ");
INSERT INTO kud2014_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Hi'adau ta hilau tupwa Piligiya yo Galetiya aidiyai na Alu'aluwa Ve'ahihi nigele iyatalamwedi ebeha Bada yana walo higuguyaei Esiya ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Eeta Misiya tupwanane ainai hilau ta sigane ainai himahalava ta hi'ai'aipate ebeha Bitiniya tupwane hiluwui. Na hesi Yeisu Alu'aluwana Ve'ave'ahihina nigele iyatalamwedi ebeha hiluwui. ");
INSERT INTO kud2014_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Eeta Maisiyaena hiso'e'eli ta hidodobine Tilowasi ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Na tenem boniyaine ainai Paulo i'eno ita'ita ta tomowa Masedoniyaena ivinuvinunui na Paulo i'awa'awanoiyei iwalo, ‘U'atemuyamuyaegai na ugeyo'awama Masedoniya ainai yo uhaguigai’. ");
INSERT INTO kud2014_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Haugana Paulo towahone i'eno ita'itaei ta itautowolo yo a'atububuni ta yau ebeha baidaguwao alau Masedoniya wuwuna anuwatuwui neta Yaubada iyogaegai ta wasa namwanamwana tomowa tenem aidiyai aguguyaei. ");
INSERT INTO kud2014_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Eeta Tilowasiyena waga avai ta a'u'e yo adumwalu ta agegeyo'awane bwanabwana yehana Samotilesi ainai. Na i'ahubenama ta agegeyo'awane Niyapoli ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tenem ainaena na aluwu ta alau Masedoniya dalavana mwala'ina Pilipai ainai. Dalavane hinage Loma himimiyaine. Na nigele ahubena hiyabagibagili dalavanane ainai amiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Eeta tapwalolowai dalavane alaugabaei ta alau bwahi papalinai, ta yama nuwatuwu mata Yudeyaone yadi aba'awanoi tenemai alobai. Waiwaihiu nemai himiya ahai ta ainaena amiya na aidiyai a'au'aubabada. ");
INSERT INTO kud2014_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Taubenaligaine ehebo neta Lidiya, wahiu Tayatailaena. Iya luwuluwu hawahawawalidi ivegivegimwalaedi. Waihiune neta Yaubada ana tauwalo vetuvehae teya eeta nuwanuwana yo Bada i'abiho'e ainai na Paulo hava iwalowalowedine neta aidiyai i'awa moiha. ");
INSERT INTO kud2014_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ta tenem hauganane ainai iya yo yana vada alona tomowanao hibapitaiso na tuluhanai ive'i'imanegai iwalo, ‘Omiu amwalo yau Bada ana tauyemidi moihana ainaena amlaoma ta yagu vadai ammiya’. Na nuwamaiyaone i'oi'oidi ta alalaune. ");
INSERT INTO kud2014_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Vali ahubena ainai alaulau aba'awanoi dalavana ainai na taupaihowa waihiuna alolobaine. Waihiune neta alu'aluwa oba'obana iluwui, na howahowana iwalo mahalavaedi hava mata himahalavane hauga mehedai. Teina paihowane ainai na mane mwala'ina yana tauloinao vehabadi ipaipaihowai. ");
INSERT INTO kud2014_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ainaena waihiunane Paulo na ai imulimulitagai na iyogayoga, ‘Teina tomowaone Yaubada ewa aliliyai yana taupaihowao hiya livahi amwahana hi'au'aubabadaei alimiyai.’ ");
INSERT INTO kud2014_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Waihiunane tenem dova iyogayoga ahubena ehebo ehebo aidiyai, ana higa Paulo taunane ita'wata'wata, na i'ita gwaipile ta alu'aluwa oba'obanawa iwalo lauwi, iwalo, ‘Yeisu Besinana yehanaena yaloinaego na waihiu neta ainaena umahalava. Nigebweda na alu'aluwa oba'obanane wahiune i'aitulu gabaeine. ");
INSERT INTO kud2014_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Na waihiune yana tauloinao himodi'iniyedi, wuwuna yadi mane mwala'ina abalobaina waihiunane, na bada Paulo i'abiye namwanamwaya'o, ta Paulo yo Sailasa hi'abi avivinidi, na hiniuli lawedi abagimwala tupwana adi tauloinao aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Hilawedima ta taulauvetala Loma mehediyai na hiwalo, ‘Teina Yudeya tomowadiyao na yada dalava alonai tausosomana himwaumwauwi. ");
INSERT INTO kud2014_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Wuwuna laugagayo hive'ive'itaei neta ita Loma yada laugagayowo hidi'wadi'wai ta nigele howahowana tavaidi yo tamulitaedi.’ ");
INSERT INTO kud2014_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Na bodao hinage hive'ewaidi, ainaena tauloinao hiloina ta Paulo na Banabasi adi ale'o hilivahidi, na hipwedipwedilidine. ");
INSERT INTO kud2014_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ta pwedipwedili mwala'ina himohedi, mulitai abo vada paipaiyai himwamwauwidine, na vada paipai ana tau'ita avivini hiloinaei na vada igudu momohi. ");
INSERT INTO kud2014_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Na tau'ita avivini walo ibenalei, na imwau luwuwedi vada paipai holanai, na aedi ihipwaidi aiwa aidiyai, ta ebe havena hidenadena. ");
INSERT INTO kud2014_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Boniyai gamwagamwana na Paulo yo Sailasa hi'awa'awanoi yo hiwaliwali Yaubada ainai, na tauluwu vada paipaiyai maudoidi hibenabenaledi. ");
INSERT INTO kud2014_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Nigele bweda na mwani'ini'i mwala'ina isagena ta vada paipai ana logidi inu'uvi na aluwadi igavai, na vada paipai ana awa'eda maudoina hilotaho'e, na tauluwu vada paipaiyai aedi adi gulawao maudoidi hilotalivahi. ");
INSERT INTO kud2014_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Na vada paipai ana tau'ita avivini aluwana igavai, na itowolo ta awa'eda ho'eho'edi i'itadi na yana nuwatuwu tauguguyaone bada hidena'o, eeta elepa ivai na ebeha ibom i'oiye mwalowouyoi. ");
INSERT INTO kud2014_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Na Paulo i'ita ta iyoga iwalo, ‘Augelu, havena ubom u'oi'oiye mwalowoigo, wuwuna maudoimai teina amiyamiya’. ");
INSERT INTO kud2014_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Na tau'ita avivinine yana taupaihowao aidiyai iyoga na lampa hivaiyama, na lampane ivai ta iluwu mayana meheuhi, na ibe'u dobi Paulo yo Sailasa mehediyai. ");
INSERT INTO kud2014_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Na mulitai itowolo ta ivaimahalavaedi, na iwalo, ‘Babadao, amwalo aliguwai hava yapaihowai, na yawahigu Yaubada ilivahi?’ ");
INSERT INTO kud2014_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Na Paulo yo Sailasa hiwalo ebe Bada Yeisu ainai uyemidi, mata owa na yam vada alona tomowadi livahi amlobai.’ ");
INSERT INTO kud2014_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Eeta Bada wasana hiyewasae ibom yo yana vada alona aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Boniyai tenem ainai Paulo na Sailasa ivai mahalavaedi, ta elodi iwuwadi na iya yo yana huhuwo hiyaliyaya na hibapitaiso. ");
INSERT INTO kud2014_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Na abo ilauvaidi ta hihae yana vada ainai ta ai'ai imohedi ta hi'a'aine. Na tomowane yana huhuwo baidanao hiyaliyaya mwala'ina wuwuna Yaubada hiyemidiyei. ");
INSERT INTO kud2014_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","I'ahubena ta tauloinao yadi taulaupaiwo hivetamaledi, ta vada paipai ana tau'ita avivini hivenuwa mwau ainai, ebeha tomawa bwau vada paipaiyai amwauwidi'o, ulivahidi na himahalava.’ ");
INSERT INTO kud2014_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Na tau'ita avivini walo teina iwalowei Paulo ainai, iwalo, ‘Tauloinao wasa hivetamalema ebeha yalivahigomiu, ainaena ammahalavama na mayami yaliyaya amlau’. ");
INSERT INTO kud2014_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Na Paulo ita'wata'wata, ta iwalo, ‘Havena alaulau. Wuwuna nigele teya yama lauhapuli lauvetala ainai hiyalobai, na babadao mehediyai hisapigai na vada paipaiyai himwauwigai, wuwuna ai Loma tomowadiyao. Na hava vehabana ebeha hilivahigai ta dawaniyena himwau mahalavaegai? Na hesi hibom hilaoma na hilauvaigai, na amahalava. ");
INSERT INTO kud2014_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Na taulaupaiwo teina walowone hiwalowedi taulauvetala aidiyai ta taulauvetalaone himeheuhi mwala'ina wuwuna Paulo na Sailasa neta hiya Loma. ");
INSERT INTO kud2014_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Eeta hilaoma vada paipaiyai na atemuyamuyaena hiwalo velau Paulo na Sailasa aidiyai, na vada paipaiyena hivaidi, na hi'awanoiyedi ta hilau vali dalavai. ");
INSERT INTO kud2014_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Eeta Paulo yo Sailasa vada paipaiyena hilau Lidiya yana vadai, na tauyemidiwo hi'abiye wahiyaladi na mulitai hilalaugabaidine. ");
INSERT INTO kud2014_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ainaena Paulo na Sailasa Ampipolisi yo Apoloniya aidiyena hilau na Tesalonaika ainai himahalava, na Tesalonaika ainai Yudeya yadi vada tapwalolo imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Eeta Paulo yadi tapwalolo ainai iluwu ipaihowa dova tupwa maudoidi aidiyai ipaipaihowa, na tenem ainai tapwalolo tonuga himiyamiya, na aidiyai Yaubada yana Buki ive'ive'ita, na baidadiyao hi'awa'awa pa'ipa'i'i, ");
INSERT INTO kud2014_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","na Paulo hanapu imohedi iwalo, ‘Besinana ilowoinanei ebe muyamuya ilobai na imwalowoi, na hinage mwalowoiyena itowolouyo’. Na hinage iwalo, ‘Yeisunane yawawaloweiwa alimiyai, ibom Besinana towahona’. ");
INSERT INTO kud2014_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Yudeyao tupwadi hi'awa moihaei na Paulo yo Sailasa yadi boda ainai hiluwu, na Yaubada ana tauyemidiwo yo ana tauve'ahihi hiya Gilisi aidiyena yo waiwaihiu yehadi mwala'idi aidiyena maudoidi hiyemidi. ");
INSERT INTO kud2014_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Hesi Yudeyaone hi'alomagigili ta tomowa yababadi hilaugogoidi ta boda hipapaihowaine. Na dalavane maudoina alonai hidagudagugu ta Yesoni yana vada hive'alehaei, ebeha vedova na Paulo yo Sailasa hibehaedi ta ebe hi'aituluwedi tomowa bodadi mehediyai. ");
INSERT INTO kud2014_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Hesi nigele hiyalobaidi, eeta Yesoni yo tauyemidiwo tupwadi hiniulilawedi dalava adi tauloinao aidiyai na hiwuiwui hiwalo, ‘Paulo na Sailasa hiya neta tupwa maudoina hiveyaveyababa. Na wau hiluwuma yada dalava alonai. ");
INSERT INTO kud2014_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ta Yesoni yana vada ainai imwauwidi ta himiyamiya. Hiya yada tauwasawasa mwala'ina Sisa yana laugagayo hidi'wadi'wai. Na hiwalo, ‘Wasawasa teya yehana Yeisu’. ");
INSERT INTO kud2014_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Dalava ana tauloinao yo bodao walo teina hibenaledi, ta hiveta'eta'e, ");
INSERT INTO kud2014_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","na hiwalo ta Yesoni ana geluwo baidanao hiyemaiha mane ainaena adi livahi vehabana abo mulitai hi'abigabaedine. ");
INSERT INTO kud2014_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Masigiliyena tauyemidiwo Paulo na Sailasa hivetamaledi ta hilalaune Beliya, hauganane himahalava hiluwu Yudeya yadi vada tapwalolo ainai, na Yeisu wasana hive'itaei. ");
INSERT INTO kud2014_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mwalona Tesalonaika ainai Yudeya nigele nuwanuwadi wasanane, na Yudeya Beliya ainai yadi talam namwanamwana ta wasanane nuwadi ivai, ainaena ahubena ehebo ehebo Buki Ve'ahihi hivahivahili na nuwanuwadi wasana namwanamwana ana moiha hihanapui. ");
INSERT INTO kud2014_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Eeta Yudeya bodadi hiyemidiyei, na hinage Gilisi waiwaihiu tupwadi hibom yehadi mwala'idi na hinage Gilisi towatowaho bagibagilidi hiyemidi. ");
INSERT INTO kud2014_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Na Yudeya Tesalonaika ana taumiyao hibenalei ebeha Paulo Yaubada wasana bada iguguyaena'o dalava Beliya ainai, ta hilau mwayamwayauma na bodao hivenuwamwau aidiyai ebeha Paulo na Sailasa hi'alehaidi. ");
INSERT INTO kud2014_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Eeta tauyemidiwo Paulo hivetamalei ta i'dodobine le'awai na Sailasa Timoti baidanao himiyamiya Beliya ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Tupwana tauyemidiwo aidiyena Paulo hi'wayabui ta hilalaune Atenisi na Paulo loina imohedi ebeha Sailasa yo Timoti hilau mwayamwayauma Atenisi ainai, eeta tauve'wayabuwone hilau gwaipile Beliya. ");
INSERT INTO kud2014_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulo Atenisi ainai Sailasa yo Timoti vehabadi iha'waha'wa, na inuwayababa vehabadi, wuwuna i'ita dalavanane ainai yadi abayemidi vagadi aidiyai hipwagopwagogo. ");
INSERT INTO kud2014_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Eeta Yudeya na tupwana Yaubada ana tauyemidiwo, baidadiyao hiveta'eta'e nuwatuwu teina vehabana, Yudeya yadi vada tapwalolo ainai, na hinage tomowa tupwadi ebe yalobaidi abagimwala ainai baidanao hiveta'eta'e ahubena ehebo ehebo aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Na tauhanahanapuwo yadi boda yehadi Epikulo yo Sitoeke Paulo baidanao hiveta'eta'e. Na tupwadi hiwalo, ‘Teina yauyaulene hava ebeha iwaloweine?’ Tupwadi hiwalo, ‘Ana ita dova tupwa teya yaubadadi adi tauguguya’. Teina walone hiwalowei wuwuna Yeisu wasana yo yana towolouyo iguguguyaeine. ");
INSERT INTO kud2014_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Eeta Paulo hilauvai yo hilawei tauloina yadi miyagogoi yehana Aliyopago ainai ta hiwalo, ‘Ve'ita vauvauna teina owa u'au'aubabadaneine ebeha ahanapui. ");
INSERT INTO kud2014_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Na ana benali alimaiyai abanuwapwanopwano, eeta ulivahi alimaiyai na nuwamai imasele, na ahanapui.’ ");
INSERT INTO kud2014_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Yadi panivila wuwuna teina, Atenisiwone yo hinage vali tupwa tomowadi Atenisi ainai himiyamiya neta nigele teya hava hiyapaipaihowai na ginauli vauvaudi hita'eyedi na hiwalowalowedi.) ");
INSERT INTO kud2014_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ainaena Paulo vada miyagogoi holanai itowolo, na iguguya aidiyai, iwalo, ‘Atenisi omiu, bada yahanapuigomiu'o ebeha ammwahamwahaliuhi yami tapwalolo aidiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Wuwuna yami dalavao ya'ita yayahidi yo yalau na abatapwalolo dalavadi ya'i'itadine yo gwalatau aidiyai teina walowone yalolobaidine, iwalo, “Yaubada nigele tayahanapui yana gwalatau”. Ainaena Yaubadane iya amwalo vetuvehaeyeine na hesi nigele amyahanapui iya ya'aubabadaneine alimiyai. ");
INSERT INTO kud2014_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","‘Yaubada bale'u tauyemaselena yo ginauli maudoidi ainai himiyamiya tauyemaseledi, eeta iya galewa na bale'u ana Bada, na vada tapwalolo tomowa hipaipaihowaidi nigele ainai iyamiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Na tomowa ita nigele howahowana na ehebo hava nimadaena tamohei Yaubada ainai, wuwuna iya yawahida yo alu'aluwada yo yada ginauli maudoidi adi tau'aiyauya. ");
INSERT INTO kud2014_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Na ehebo towaho yehana Adam ainaena Yaubada vali tupwa yo vali tupwa tomowadiyao iyemaseledi yo tomowa hidabalala bale'u maudoina aidiyai, eeta boda ehebo ehebo yadi hauga yo yadi abamiya higana Yaubada mwalona iwalowedine. ");
INSERT INTO kud2014_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Yana nuwatuwu ebeha ibom hibehaei yo howola abo hitowoi ta hilobai. Na hesi Yaubada vahalidai imiyamiya. ");
INSERT INTO kud2014_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Wuwuna ibom ainaena yawahida tavaivai na baidada talaulau yo baidada tamiyamiya. Na dova yami tauwalo mahalava teya Yaubada vehabana iwalowalo neta ita hinage maudoida natunao.” ");
INSERT INTO kud2014_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","‘Yaubada natunao ita ainaena nigele ebeha Yaubada ana ita tanuwanuwatuwui dova abapwagogo tomowa yadi nuwatuwuwena hipaihowaidi. Gola bo siliba bo gaima ainaena hileleleledi, hiya nigele dova Yaubada. ");
INSERT INTO kud2014_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nuwapwanopwano haugadi aidiyai Yaubada nigele tomowa yemaihana iyamodeyei. Na wau tomowa maudoida iwalowalo auligita iwalo, ‘Yami mumuga yababadi amtalamwedi. ");
INSERT INTO kud2014_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Wuwuna yada ahubena lauvetala howola Yaubada iwalowena'o na bale'u maudoina ada loina dumwaluna imohegita, towahone ivesinuwaiya'o ainaena, na towahonane mwalowoiyena i'abiye towolouyoi na ainaena tomowa maudoida wasa teina ta'awa moihaei.’ ");
INSERT INTO kud2014_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Na taumwalowoiwo yadi towolouyo wasana hibenalena'o, na tupwadi hiwalo sebasebai, na tupwadi hiwalo, ‘Nuwanuwamai ebe nuwatuwu teina vehabana u'aubabadauyo na abenalei’. ");
INSERT INTO kud2014_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ainaena Paulo bodaone aidiyena imahalava. ");
INSERT INTO kud2014_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Na tupwana tomowa Paulo yana walo hiyemidiyei na yana boda ainai hiluwu, na holadiyena ehebo towaho yehana Diyonisiyo, iya vada abalauvetala ana taupaihowa ehebo na ehebo waihiu yehana Damalisi, na tupwana hinage boda baidadiyao. ");
INSERT INTO kud2014_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Mulitai Paulo Atenisi ilaugabaei na ita'i'ili Kolinita ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Na tenemai Yudeya towahona ilobai, yehana Akwila, na yana dalava Ponita, na mwanena Pilisila vauvauna Italiyena hilaoma, wuwuna tauwasawasa Kalodiyosi Yudeya maudoidi iloinaedi na Loma ainaena himahalava. ");
INSERT INTO kud2014_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ainaena Paulo ilau itaubo'eyedi na baidadi himiyamiya, wuwuna iya yo hiya yadi mane amwahana neta palae hipaipaihowai. ");
INSERT INTO kud2014_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Tapwalolo bagibagili aidiyai vada tapwalolowai Yudeyaone yo Gilisiwone baidadiyao hiveta'eta'e. Na i'ai'aipate ebeha nuwadi igwapile. ");
INSERT INTO kud2014_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Haugana Sailasa na Timoti Masedoniyaena himahalavama, neta Paulo yana paihowa palae hailina ilaugabaei na yana hauga guguya ainai igagabaeine. Na Yudeyaone iwalowalo auli ili'ilimanidi neta Yeisu iya Besinana towahona. ");
INSERT INTO kud2014_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Eeta hi'awa pa'ipa'i'i na hi'awa oya'oyama, ta Paulo ana luwuluwu mu'amu'alina i'oiye hoyeholu mehediyai, neta yadi abitau'wata ana aba'ita ipaihowaine, na iwalo aidiyai, ‘Omiu howola abo amsilahe yami abitau'wata vehabana, ta neta omiu ami ve'ewa na nigele yau agu ve'ewa. Eeta wau'ivetuwuni ta ilaulau mata yalaugabaigomiu na wasana namwanamwana yalawei nigele Yudeya aidiyai.’ ");
INSERT INTO kud2014_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ainaena yadi vada tapwalolo ainaena himahalava, na hiluwu Titiyo Yusito yana vadai, ibom Yaubada ana tauve'ahihi ehebo, na yana vada Yudeya yadi vada tapwalolo vahalinai. ");
INSERT INTO kud2014_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Na vada tapwalolone ana taumugai yehana Kilisiposi, mayana huhuwo Bada Yeisu ainai hiyemidi, na hinage Kolinita bagibagilidi Paulo yana guguya hibenalei, na Yeisu ainai hiyemidi yo bapitaiso hivai. ");
INSERT INTO kud2014_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Masigiliyena Paulo yana eno mehe'ita'itaena Bada Yeisu i'i'itane, na Yeisu iwalo, ‘Paulo, havena u'ate'atehawawali, na hesi wasa uwalowei, na havena ulaulau mwau. ");
INSERT INTO kud2014_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Na yau baidamiu tamiyamiya, wuwuna dalava teina ainai tomowa bagibagilidi hiyemidiyegau, yo yagu bodao imwala'i na nigele howahowana yaiya i'aleha alimwai, yo iveyababago.’ ");
INSERT INTO kud2014_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Eeta bolimai ehebo na tupwana aidiyai Paulo tenemai imiyamiya, na Yaubada yana walo ive'ive'itaei. ");
INSERT INTO kud2014_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Haugana Galiyo ivetauloina mwala'ina, dalava Gilisi ainai, Yudeyaone hiloina na Paulo hilawei habi lauvetala Galiyonane ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Na hiwalo towaho teina tomowa nuwadi i'oi'oidi, na ebeha Yaubada hiwalo vetuvehaiyei na neta yada loinao iho'eho'edi.’ ");
INSERT INTO kud2014_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ta Paulo ebeha iwalouyo, na Galiyo iwalo mugai Yudeya aidiyai, na iwalo, ‘Yudeya omiu yagu walo ambenalei. Ebe towaho teina imumuga yababa yo lauhapuli paipaihowai, ilowoinanei na yami ve'ewa yabenalei. ");
INSERT INTO kud2014_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Na hesi nuwatuwu teina omiu ambom yami walowo yo yehao yo loinao yami dalavaena. Ainaena omiu amloina, na yau yata'wata'wata.’ ");
INSERT INTO kud2014_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Na abalauvetala ainaena iheusilidi ta himamahalavane. ");
INSERT INTO kud2014_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Na bodaone Sositeni hi'abi avivini, iya Yudeya yadi vada tapwalolo ana tau'ita avivini na hitatalaine Galiyo yana abalauvetala mehenai, na hesi Galiyonane nigele vehabadi iyamode. ");
INSERT INTO kud2014_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo Kolinita ainai imiyamiya ahubena bagibagilina na abo mulitai tauyemidiwo ilaugabaidi na Akwila mwanena Pilisila baidanao wagaena higelu na hi'adau Siliya vehabana. Na ehebo ginauli neta mulitai abo higelu Paulo iwalo hae Yaubada mehenai Kenikiliya ainai ta vahuna hi'wa'wahine. ");
INSERT INTO kud2014_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Na Kenikiliya hi'adau ta hilau Epeso ainai, ta Pilisila na Akwila ilaugabaidi na iluwu Yudeya yadi vada tapwalolo ainai, ta baidanao hi'au'aubabada. ");
INSERT INTO kud2014_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ainaena hi'awanoiyei na ebeha hauga daodaona baidadi himiyamiya, na ita'wata'wata. ");
INSERT INTO kud2014_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Na hesi iwalo howola abo yawuyoma, ebe Yaubada italamwegau eeta Epeso ilaugabaei na igeluyo. ");
INSERT INTO kud2014_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Na igelu ta Sisaliya ainai iduna, na ihae Yelusalem ainai na tauyemidiwo baidanao hi'awa heliheliyam, na mulitai ilalaune Anitiyoki ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Anitiyoki ainai imiya daodao, na abo mulitai itowolo ta ilau Galetiya yo Piligiya tupwane ehebo ehebo aidiyai ita'ita i'ili, na Yeisu ana taumulitao maudoidi i'abi'abiye wahiyaladi. ");
INSERT INTO kud2014_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Hauganane ainai ehebo Yudeya towahona yehana Apolosa na Alekisanideliyaena ilaoma Epeso, ibom tauguguya wahiwahiyalana Yeisu vehabana, na Buki Ve'ahihi ihanapu moiha. ");
INSERT INTO kud2014_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ve'ita Bada yana Amwaha ainai ivai ta italam moiha yo Yeisu vehabana ive'ive'itadi yo i'au'aubabadaedi neta ivedumwaludi. Na hesi Yoni yana bapitaiso ibom ihahanapuine. ");
INSERT INTO kud2014_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Yudeyaone yadi vada tapwalolowai ivetuwuni ta i'aubabada wahiyala na haugana Pilisila na Akwila hibenalei ta hilalauvaine. Hilauvai ta hilawei yadi vada ainai ta Yaubada yana Amwaha hi'aubabadaye dumwalune ainai. ");
INSERT INTO kud2014_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Mulitai Apolosa inuwanuwatuwu ebeha igeyo'awa Gilisi ainai, eeta tauyemidiwo Epeso ainai hihagui ta hilaulelelau taumulitao Gilisi aidiyai. Hiwalo aulidi ebe Apolosa hiyaliyayai na hilauvai. Haugana imahalava neta Yaubada yana ve'i'ila ita'aviviniyena na tomowa hiyemidi neta aidiyai ivehaguhagu moiha. ");
INSERT INTO kud2014_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Na yana ve'ita Yudeya yadi ve'ita iwahiyala gabaei wuwuna Buki Ve'ahihi ainaena ive'itadi ebeha Besinana towahona ibom Yeisu. ");
INSERT INTO kud2014_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolosa howola Kolinita ainai imiyamiya, na Paulo ita'i'ili tupwana nu'ula aidiyena na Epeso ainai ilaoma le'awai. Tenem ainai tupwana Yeisu ana taumulitao ilobaidi. ");
INSERT INTO kud2014_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Na iwalo, ‘Augeluwo, hauganane Yeisu amyemidiyei neta Alu'aluwa Ve'ahihi yana wahiyala amlobai bo nigele? Na hiyemaiha hiwalo howola nigele ayabenalei neta Alu'aluwa Ve'ahihi vehabana’. ");
INSERT INTO kud2014_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ainaena Paulo iwalo, ‘Aiteya bapitaiso ainaena ambabapitaisone?’ Na hiwalo, ‘Yoni yana bapitaiso ainaena’. ");
INSERT INTO kud2014_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paulo iwalo aidiyai, ‘Yoni yana bapitaiso neta nuwabui ana bapitaiso yo mumuga yababana vehabana. Na Yoni ivenuwamwauwedi ebeha iya howola abo ilaoma ainai hiyemidi neta Yeisu’. ");
INSERT INTO kud2014_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Teina Epesowone hibenalei na Bada Yeisu yehanaena bapitaiso hivai. ");
INSERT INTO kud2014_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6",