﻿USE sofia;
DROP TABLE IF EXISTS sofia.ktm_vpl;
CREATE TABLE ktm_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ktm_vpl WRITE;
INSERT INTO ktm_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ndre mamunen Petngendrei ihnan lok eleng pe lokpoi, pe sane ndre sulo-on. ");
INSERT INTO ktm_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Odoke lokpoi ti indrehpa ndre mahkele ti pwi. Sane hendre-en ndruhu’ sa pwi, handrai ile ke lon handrai. Lok indrilik, wo isorohe lokpoi ndresih, pe Puko-on tam Petngendrei inemehleu ise pule-en. ");
INSERT INTO ktm_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Eri pe Petngendrei ipe ihpa, “Moleu kihir,” pe moleu ihir. ");
INSERT INTO ktm_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Iy indre-et ile eriy pe ihposan ipe huyen, pe Iy ide kapetne-et odo moleu pe lik. ");
INSERT INTO ktm_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Iy iyuwen moleu ile “meseren,” pe lik ile “lukumwen.” Lukumwen inum pe meseren ihir. Rang eti sei (1). ");
INSERT INTO ktm_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Inum pe Petngendrei ipe ihpa, “Kapetne-et odo wo kah kihir.” ");
INSERT INTO ktm_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ile pe Petngendrei ihnan yor iyin ndrokoron pe itlangan wo se ile eleng pe wo se ile pahndran. Pe ihir ihpa ndre eriy. ");
INSERT INTO ktm_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Pe iy iyuwen eleng ile “parar.” Lukumwen inum pe meseren ihir. Iy eti rang ruu (2). ");
INSERT INTO ktm_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Inum pe Petngendrei ipe ihpa, “Wo iyin pahndran eri kihtok kile ke sehir, pe lok puko-on kihir pe kipkos.” Pe ihir ihpa ndre eriy. ");
INSERT INTO ktm_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Petngendrei iyuwen lok ndre pusukon eri “poi,” pe wo ndre ihtok ile ke sehir, eri Iy iyuwen ile “ndras.” Iy indre-et ile eriy pe ihposan ipe huyen. ");
INSERT INTO ktm_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Inum pe Petngendrei ipe ihpa, “Kei pe sane handrai pe handrai ndre henerenge ti kah hehir odo poi pe hotou mbrwe’ su.” Pe ihir ihpa ndre eriy. ");
INSERT INTO ktm_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ile pe sane kei pe mundriu handrai pe handrai hehir odo poi pe hehwei. Iy indre-et ile eriy pe ihposan ipe huyen. ");
INSERT INTO ktm_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Lukumwen inum pe meseren ihir. Iy eti rang tul (3). ");
INSERT INTO ktm_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Inum pe Petngendrei ipe ihpa, “Sane ndre rama’ su eri kah hehir odo parar, kile pe hampaninyan meseren pe lukumwen. Pe hampaninyan rang, pe rangen handrai pe handrai kinto lon krismas ndre sulo-on. ");
INSERT INTO ktm_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Pe su we hannai hosso parar pe heneraman lok poi.” Pe ihir ihpa ndre eriy. ");
INSERT INTO ktm_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Petngendrei ihnan mundroi ti mandra-an, madan iso meseren, pe ndrou ti lehyen, madan iso lukumwen. Iy ihnan su pudiy yi. ");
INSERT INTO ktm_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Iy iduwe horu horso parar, kile pe hereneraman lokpoi, ");
INSERT INTO ktm_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","pe mada’ horu kisso meseren pe lukumwen, pe we herempaniyan meseren pe lukumwen. Iy indre-et ile eriy pe ihposan ipe huyen. ");
INSERT INTO ktm_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Lukumwen inum pe meseren ihir. Iy eti rang hai (4). ");
INSERT INTO ktm_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Inum pe Petngendrei ipe ihpa, “Sane mente-en lon ndras ndre sulo-on hohu ngoho’ su, eri hehir pe hohor hala sulo-on. Pe nenka-an hono-oh eri hehir pe hohor yi.” ");
INSERT INTO ktm_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ile pe Petngendrei ihnan ni mandra-ane pe mone pe sane se yi honto lon ndras. Pe ihnan nenka-an handrai pe handrai yi. Iy indre-et ile eriy pe ihposan ipe huyen. ");
INSERT INTO ktm_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Pe Petngendrei ipatihi su pe ipe ihpa, “Oduu sane mente-en lon ndras oduhor kile lon ndras ndre mandra-an. Pe oduu nenka-an eri oduhor yi.” ");
INSERT INTO ktm_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Lukumwen inum pe meseren ihir. Iy eti rang lim (5). ");
INSERT INTO ktm_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Inum pe Petngendrei ipe ihpa, “Ka-an handrai pe handrai ndre henehti ngoho’ su eri hehir odo pule-en poi. Su odo hangahang pe su puyep, mandra-ane pe mone.” Pe ihir ihpa ndre eriy. ");
INSERT INTO ktm_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ile pe Petngendrei ihnan su ndre sulo-on. Iy indre-et ile eriy pe ihposan ipe huyen. ");
INSERT INTO ktm_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Pe Petngendrei ipe ihpa, “Mahkele eri tidu ka we tidahnan ndramat hahpa ndre tidu. Kile pe su we mada’ su kise pule-en ni, nenka-an pe ka-an odo hangahang pe puyep, mandra-ane pe mone.” ");
INSERT INTO ktm_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ile pe Petngendrei ihnan ndramat ihpa ke ndre Iy. Iy ihnan ndramat kamal pe pedih. ");
INSERT INTO ktm_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Iy ipatihi horu pe ipe ihpah, “Orpo nedu’ oruu hala sulo-on, pe hasarpat hala lokpoi ndre mandra-an, pe mada’ su kise eriy. Yu uduwe oruu mada’ oruu kise pule-e’ su ni, su ka-an pe su nenka-an.” ");
INSERT INTO ktm_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Petngendrei ipe ihpah, “Sane mbrwen kei handrai pe handrai ndre Yu undretawei eri ana’ oruu odo yo-on. ");
INSERT INTO ktm_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Odoke su ka-an pe nenka-an eri ana’ su song ti mundriu pe ndrokei orwon.” ");
INSERT INTO ktm_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Petngendrei indre-et ile sane ndre sulo-on ndre Iy indrahnan indrinum ti pe, Iy ipe huyen pe ihposan lakopwi. Lukumwen inum pe meseren ihir. Iy eti rang on (6). ");
INSERT INTO ktm_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Petngendrei ke indrahnan sane ndre sulo-on odo lokpoi pe lok eleng indrinum, takokopwe ile eriy. ");
INSERT INTO ktm_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Pe idu rang ndrodul eri Petngendrei indre-et ile pule-en sane ndre sulo-on ndre Iy indrahnan hondrunum ti pe Iy imyau. ");
INSERT INTO ktm_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Petngendrei ipatihi rang ndrodul pe itnembruwen, odosa marai ndre sulo-on ti Iy indritakokopwe indrinum, pe Iy imyau idu eriy. ");
INSERT INTO ktm_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Sane odo lokpoi pe lok eleng eri hehir ihpa ndre kurtih. Kalmene-en Lapan Petngendrei ihnan lokpoi pe lok eleng, ");
INSERT INTO ktm_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","eri Iy ihndrahnan lengin indrundrut mapwi, pe homou ndramat odo po maryan ndruhun tehe sane mapwi. Ile pe sane kei pe sane mundriu hendrerenge mapwi. ");
INSERT INTO ktm_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Lengin isendrut mapwi, odoke wo inu-us lon poi isa ndritan pe isonolwi poi. ");
INSERT INTO ktm_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Inum pe Lapan Petngendrei ikuni poi se, pe iyepisi ndramat kamal ile eriy. Pe Lapan Petngendrei iruhi ngohon ile lon ndrongon ndramat. Ndramat ti ihu ngohon pe ile moren. ");
INSERT INTO ktm_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Inum pe Lapan Petngendrei iduhon poi hombrul ise Iden, pe iduwe ndramat ndre Iy iyepisii eri imin eriy. Iden ti ile wuron rai ea. ");
INSERT INTO ktm_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Iy iduwe kei handrai pe handrai rahye’ su, pe mbrwe’ su ti huyen odo yo-on, eri hehir odo pule-en poi Iden. Idu ndrokoron lok eriy, eri kei ndre ru-iy. Kei he-ei odo hasamat pwi, pe kei he-ei yi eri intawe tawene odo sane huyen pe sane mo-on. ");
INSERT INTO ktm_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Wo handrang ihtot iyin Iden pe inahnan sane henerenge ile huyen. Iy ihtot ile ndre kan ti pe iltalngan iy ile wo mandra-ane ndre haandrang. ");
INSERT INTO ktm_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Wo handrang eri rangan Pison, ihtot iyin lo lok Havilah. ");
INSERT INTO ktm_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Gol huyen, pe kei handrai menuhun huyen, ndrodan ndre pat handrai huyen he-en lok eti. ");
INSERT INTO ktm_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Iy handrang eri Gihon, ihtot iyin lon lok Kus. ");
INSERT INTO ktm_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Iy handrang eri Taigris, ihtot ile wuron rai ea odo lok Asiria, pe iy handrang yi eri kah Yufretis. ");
INSERT INTO ktm_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Inum pe Lapan Petngendrei iduwe ndramat kamal imin pule-en poi ndre Iy indretohon odo Iden, kile pe iy we kina-an, kimpo marai pe madan kisso eriy. ");
INSERT INTO ktm_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Lapan Petngendrei ipe ile tadan ihpa, “Ou oyo-on mbrwen kei ndre sulo-on odo poi ketih, ");
INSERT INTO ktm_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","odoke kei ndre intawe tawene odo sane huyen pe sane mo-on eri ou oyo-on mbrwen kolwii. Uh ou oyo-on eri we amat kidu ke ndre rang etih.” ");
INSERT INTO ktm_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Eri pe Lapan Petngendrei ipe ihpa, “Ndramat kamal iy ke homou imin eri mo-on. Yu we kuhnan homou kowson odo henuwii iy.” ");
INSERT INTO ktm_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ile pe Iy ikuni poi se, pe Iy iyepisi su ka-an pe nenka-an ile eriy. Inum pe Iy ikuni su ile hun ndramat, ile pe Iy ipe kindre-et ndramat kuti kitou ranga’ su. Iy eti uu pe ka-an pe nenka-an handrai handrai ti ndre ranga’ su iyenon ea tih. ");
INSERT INTO ktm_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ile pe ndramat kuti iduwe ranga’ su ka-an pe nenka-an ndre sulo-on. Odoke homou indrahpa ndre iy ti pwi, pe indrila huyen odo we kile kowson eri pwi. ");
INSERT INTO ktm_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Eri pe Lapan Petngendrei ihnan ndramat kamal imtir tuw, pe Iy irwi ndruwin kohlon he-ei, inum pe isokopti ndre kohlon yi, ");
INSERT INTO ktm_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","pe ihtungon ndramat pedih ihir odo ndruwin kohlon iy kamal. Inum pe Iy ikuni iy pedih ti ile hun iy kamal. ");
INSERT INTO ktm_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Pe iy kamal ipe ihpa, “Kah tapa kede! Iy kuti ihpa ke ndre yu. Ndruwin hokuni odo ndruwi pe sengin odo sengi. Petngendrei ihtungon iy odo ndruwi, ile pe iy rangan ‘pedih.’” ");
INSERT INTO ktm_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Iy eti uu pe kamal inna-au odo hun taman pe tinen pe inohtok ile ndrodan mbrulun, pe horu harla ke ndramat homou. ");
INSERT INTO ktm_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Kamal pe pedih ndrihi’ horu kopwi, odoke horu tuno’ horu mah-ah pwi. ");
INSERT INTO ktm_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Lapan Petngendrei ihnan su ka-an ndre sulo-on, odoke mot eri tawene tadan elwe-en lakopwi, iyin pule-e’ su ndre sulo-on. Mot ihndramtan iy pedih ihpah, “Erih? Petngendrei ipe we oruu erndreyo-on mbrwen kei odo lok keti pwi?” ");
INSERT INTO ktm_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Pedih ipe ihpa, “Oru we oryo-on mbrwen kei ndre sulo-on, ");
INSERT INTO ktm_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","tapake mbrwen kei idu ndrokoron lok, eri Petngendrei ipe we oru erndretukunii pe erndreyo-on pwi. Uh oru ortukunii ndre pwi oryo-on, eri oru we armat.” ");
INSERT INTO ktm_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Mot ipe ihpah, “Iy intaheweh, we erndremat pwi. ");
INSERT INTO ktm_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Petngendrei tunon, ipe kihne oruu oryo-on eri we arahpa ndre Iy, pe we orohtuno oruu sane huyen pe sane mo-on.” ");
INSERT INTO ktm_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Pedih indre-et ile kei kuti pe kei ti rahyen lakopwi, pe mbrwen ti mandran pe huyen odo yo-on. Iy ipe kihtunon sane posingat, ile pe iy iyehi mbrwen kei se pe iyo-on. Inum pe iy itou se ile tan mbrulun pe mbrulun iyo-on yi. ");
INSERT INTO ktm_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Horu harani mbrwen kei inum ti pe mada’ horu ipahar lakopwi, pe horu horohtuno horu ihpa ndre horu tih ndrihi’ horu kopwi. Ile pe horu hersokopet ndrokei ile ndrih pe hertese. ");
INSERT INTO ktm_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Lok ndre ipiyeh ti horu hertahrungi ngasan Lapan Petngendrei inelila ipei. Ile pe horu hortudong Tadan harla siliyen kei. ");
INSERT INTO ktm_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Odoke Lapan Petngendrei iyuw iy kamal, “Ou anna kehe?” ");
INSERT INTO ktm_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Iy isomwi ihpa, “Yu uhrungi ngasam enelila pe yu unuh pe utong Tadam, odo yu ndrihi pwi tih.” ");
INSERT INTO ktm_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ile pe Lapan Petngendrei ihndremte, “Ou tunom ihpa ndre ou ndrihim kopwi ti ihpa kehe? Si ipahran ile tadam? Ou ti kihne andrani mbrwen kei ndre Yu upwe ou oyo-on kolwii tih.” ");
INSERT INTO ktm_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Kamal ipe ihpah, “Pedih ndre Ou eduwe iy imin ndroda yu, eri ihngahang yu pe yu uyo-on.” ");
INSERT INTO ktm_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Lapan Petngendrei ihndramtan pedih ihpah, “Ou opo erti ile homosa?” Iy ipe ihpah, “Mot ipusahi yu pe yu uyo-on.” ");
INSERT INTO ktm_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Inum pe Lapan Petngendrei ipe ile tan mot ihpah, “Ou we okun pede-en odo homosa ou opo kitih. Ou kopwi odo lenga’ su ka-an pe nenka-an, idu mahkele pe ile, eri we enelila kile ke mburndrinem, pe ana-an wambruhen poi. ");
INSERT INTO ktm_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Yu we kuhnan ou pe iy pedih, we erehmbore oruu oruu. Su nedun pe su nedum eri we hompo ke pahun kile pule-e’ su. Su nedun pedih ti we hantatawe palam pe ou we eneti kambrulke’ su.” ");
INSERT INTO ktm_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Lapan Petngendrei ipe ile tan iy pedih ihpah, “Yu we kuduwe pede-en kile mundrem kidu ou ndriyem, pe ngendre-en mandra-an we kile tadam, kidu ou otou nedum. We elnget ngendre-en, odoke reh tadam we kinto ke ndre tan mbrulum, pe ou we emmin ke ndre pahndran mbrulum.” ");
INSERT INTO ktm_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Pe Lapan Petngendrei ipe ile tan Adam ihpa, “Ou ohrung mbrulum pe oyo-on mbrwen kei ndre Yu upwe ou we onyo-on pwi tih. Ile pe Yu we kuhnan poi kihmo-on, pe song we hendrerenge huyen pwi. Ou we ndre opo marai puko-on, pe anam song kenon ou. ");
INSERT INTO ktm_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Mundriu pe osukei pudon we hernge pe hosorohe lok, pe ou eri we oyo-on sane henerenge odo langah. ");
INSERT INTO ktm_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ou we opo marai kile puko-on pe panohyum kihir, iyenon ndre ou ala yi ndre poi ndre ou ehir eriy. Ou ehir odo poi pe we ala yi ndre poi.” ");
INSERT INTO ktm_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam iyuwen rangan mbrulun eri Ewah odo iy we kile tinen ndramat ndre sulo-on. ");
INSERT INTO ktm_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Pe Lapan Petngendrei ihnan ndrihi’ horu odo kalatun ka-an, pe Adam horu mbrulun hertasan. ");
INSERT INTO ktm_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Inum pe Lapan Petngendrei ipe ihpa, “Ndramat ke indrahpa ndre homou ta tidu. Iy kah tunon sane huyen pe sane mo-on. Ile pe iy we ke-eu odo Iden. Kihne iy kimin ti pe kiyo-on mbrwen kei odo hasamat pwi, pe kindrimat pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ile pe Lapan Petngendrei iyes Adam iyeu odo Iden, pe ilpo marai ile poi ndre Iy ihnan iy ihir odo eriy. ");
INSERT INTO ktm_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Lapan Petngendrei iyes horu odo Iden inum oh pe iduwe su engel hala ndram. Pe Lapan Petngendrei iduwe semel hondrou inehnelem ihpa ndre ndremleh idu sal ise wuron rai odo Iden. Kile pe homou ndramat kindranon kinna mukehe kei odo hasamat pwi ti pwi. ");
INSERT INTO ktm_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Inum pe Adam imtir mbrulun, pe mbrulun ikuni kom ile mundren pe iduwe nedun kamal homou. Ewah ipe ihpah, “Lapan ipu huyen ile todo pe yu kah nedu homou kamal.” Ile pe iy iyuwen rangan Kein. ");
INSERT INTO ktm_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ndruwen ti pe iy iduwe nedun kamal homou yi, rangan Abel. Horu harla ndre nusuwo’ horu ti pe Abel madan iso tan sipsip pe Kein ti impo marai odo tuhe sane. ");
INSERT INTO ktm_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Song odo langah tan Kein hala sengin ti pe, iy ikuni se pe isurkon Lapan ile eriy. ");
INSERT INTO ktm_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Pe Abel iruhe sipsip homou ndrihou, itngwii, pe isurkon Lapan ile kahen se nama-an. Lapan irih tan Abel ndroda song pe surok tadan. ");
INSERT INTO ktm_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Odoke Lapan ihmboren Kein ndroda song tadan. Kein ihpusuw pe madan imo ile mo-on. ");
INSERT INTO ktm_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ile pe Lapan ipe ile tan Kein ihpah, “Ou madam kimo pe opo loroh kolwii. ");
INSERT INTO ktm_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Lehpe ou opo huyen eri Yu kuhposon ou, pe ou we ondrupo loroh pwi. Pe uh ou endretahrung punou todo pwi, eri ampahar, to-ir we kihndrusi ou. To-ir ingkeli-iy kopwi ipe kikuni ou ala lewen, odoke ou epkwe pe ahtaran iy.” ");
INSERT INTO ktm_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ndre omur ti pe Kein ipe ile tan tinton ihpah, “Toru torndrou kile kotile’ toru.” Horu harla ndre alau ti pe Kein iyepwi tinton imet. ");
INSERT INTO ktm_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Lapan ihndremte Kein ihpah, “Abel inna kehe?” Kein ipe ihpah, “Yu tuno pwi. Ou apa we yu kulla ke kelye-en?” ");
INSERT INTO ktm_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Eri pe Lapan ipe ihpah, “Ou erehe tintom imet ti odosa? Ndrayen tintom iyin poi ti irrah ile Todo, ipe Yu kuhmbrus iy pe kupu nuhen. ");
INSERT INTO ktm_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ou eri ka we elnget pede-en. Poi indrelumwi ndrayen tintom, ile pe ou andranon ondrupo langah kile pule-en pwi yi. ");
INSERT INTO ktm_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Uh ou edehe song kile poi, eri we poi kindrehlingi song tadam pwi. Ile pe ou kah atlang pe owou. Ou ka we enerolila kopwi, sehir kile sehir, odo pule-en lokpoi.” ");
INSERT INTO ktm_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Pe Kein ipe ile ta Lapan ihpah, “Pede-en Ou eduwe ile todo kiti mandra lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ou ana-as yu odo lok ketih. Apa yu kumwin hun Ou kolwii. Pe yu ka we kunelila sehir kile sehir odo lokpoi. Pe homou kihrah todo eri we kepwi yu kumwet.” ");
INSERT INTO ktm_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Odoke Lapan ipe ihpah, “We kindrahpa kiti pwi. Uh homou lau kepwi ou amat, eri Yu we kuse nuhem pe kupu muden kile ta sa lau ndre ndrotulmuu.” Ile pe Lapan ide kalmene-en Kein, odo uh sa lau hahrah tadan, eri we handrapwi iy pwi. ");
INSERT INTO ktm_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Pe Kein itlang iyeu odo madan Lapan pe ilmin lok sehir yi rangan Nod, ilso wuron rai ea odo Iden. ");
INSERT INTO ktm_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kein iyesou pe imtir ndrodan mbrulun, pe nedu’ horu kamal homou ihir, pe horu hartawe rangan Enok. Inum pe Kein ihtungon lok hokor pe iyuwen ile seren nedun. ");
INSERT INTO ktm_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Kom ndrihou tan Kein ti Enok. Enok nedun ti Irat, Irat nedun ti Mehujael, Mehujael nedun ti Metusael, pe Metusael nedun ti Lamek. ");
INSERT INTO ktm_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek iyesou pedih rumuu, homou rangan Adah pe homou Silah. ");
INSERT INTO ktm_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adah nedun homou rangan Jabal. Su yayan Jabal ti mada’ su iso tam makau pe hene-en um pelei. ");
INSERT INTO ktm_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jabal ti tinton homou rangan Jubal. Pe su yayan Jubal eri hompo weriy ile kita pe horruh kuweh. ");
INSERT INTO ktm_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Silah iduwe nedun homou rangan Tubalkein, iy ndramat odo takun bras pe ain pe inahnan ndrake-en sane odo marai ile eriy. Timso-on Tubalkein eri Namah. ");
INSERT INTO ktm_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamek ipe ile ta mbrulun horu ndre rumuu ihpah, “Adah pe Silah, artahrung yu. Oruu mbrulun Lamek, artawe ndralnga’ oruu. Anah homou eleheu iruh yu, pe yu urehe iy imet. ");
INSERT INTO ktm_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Oruu tuno’ oruu ihpa ndre uh homou lau kepwi Kein eri Petngendrei we kipu muden pe kiruhe lau ndrotulmuu hamat. Odoke yu, eri uh homou kiruhe yu kumwet, eri we ndramat ndre ndrotulngeh-pe-ndrotulmuu (77) we hamat kile mudi.” ");
INSERT INTO ktm_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam imtir Ewah yi pe Ewah ile ndriyen pe iduwe nedun kamal homou yi. Ewah ipe ihpah, “Petngendrei indretawe nedu homou yi ile muden Abel ndre Kein iruhei imet.” Ile pe iy iyuwen rangan ile Set. ");
INSERT INTO ktm_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set iyesou pe nedun kamal homou. Iy irson rangan ile Enos. Idu mundrun eriy, eri sa ndramat kah hesurok pe hoyuw Lapan ile rangan nembruwen. ");
INSERT INTO ktm_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Iy kuti su yayan Adam. Kalmene-en Petngendrei ihnan ndramat, eri ihnan su ihpa ke ndre Iy. ");
INSERT INTO ktm_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Iy ihtungon su kamal pe pedih, ipatihi su pe iyuwen su ‘ndramat.’ ");
INSERT INTO ktm_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Kalmene-en Adam krismas tadan ile sangat-pe-tulngeh (130), eri nedun homou kamal ihpa ke ndre iy. Pe iy iyuwen rangan Set. ");
INSERT INTO ktm_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ndruwen nedun erti, pe Adam imin krismas puken ndrorunget (800), pe iy nedun kamal pe pedih se yi. ");
INSERT INTO ktm_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Krismas tadan ile ndre puken ansangat-pe-tulngeh (930), pe iy imet. ");
INSERT INTO ktm_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set eri krismas tadan ile ndre puken sangat-pe-limweh (105), pe nedun homou kamal rangan Enos. ");
INSERT INTO ktm_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Set imin yi, iyenon ndre krismas puken ndrorunget-pe-ondrotoloh (807). Iy nedun kamal pe pedih se yi. ");
INSERT INTO ktm_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Krismas tadan ile ndre puken ansangat-sungoh-pe-ruweh (912), pe iy imet. ");
INSERT INTO ktm_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos eri krismas tadan ile ke onsungoh ti pe nedun homou kamal rangan Kenan. ");
INSERT INTO ktm_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enos imin yi, iyenon ndre krismas puken ndrorunget-sungoh-pe-limweh (815). Iy nedun kamal pe pedih se yi. ");
INSERT INTO ktm_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Krismas tadan ile ndre puken ansangat-pe-limweh (905), pe iy imet. ");
INSERT INTO ktm_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan eri krismas tadan ile ndrotulngeh ti pe nedun homou kamal rangan Mahalalel. ");
INSERT INTO ktm_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenan imin yi, iyenon ndre krismas puken ndrorunget-pe-hangoh (840). Iy nedun kamal pe pedih se yi. ");
INSERT INTO ktm_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Krismas tadan ile ndre puken ansangat-pe-sungoh (910), pe iy imet. ");
INSERT INTO ktm_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel eri krismas tadan onngoh-pe-limweh (65) pe nedun homou kamal rangan Jaret. ");
INSERT INTO ktm_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalalel imin yi, iyenon ndre krismas puken ndrorunget-pe-tulngeh (830). Iy nedun kamal pe pedih se yi. ");
INSERT INTO ktm_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Krismas tadan ile ndre puken ndrorunget-onsungoh-pe-limweh (895), pe iy imet. ");
INSERT INTO ktm_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jaret eri krismas tadan sangat-onngoh-pe-ruweh (162), pe nedun homou kamal rangan Enok. ");
INSERT INTO ktm_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Jaret imin yi, iyenon ndre krismas puken ndrorunget (800). Iy nedun kamal pe pedih se yi. ");
INSERT INTO ktm_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Krismas tadan ile ndre puken ansangat-onngoh-pe-ruweh (962), pe iy imet. ");
INSERT INTO ktm_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enok eri krismas tadan onngoh-pe-limweh (65), pe nedun homou kamal rangan Metuselah. ");
INSERT INTO ktm_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Enok ti kowson Lapan. Pe imin krismas puken tulnget (300) yi, pe nedun kamal pe pedih se yi. ");
INSERT INTO ktm_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Iy imin krismas ihndre puken tulnget-onngoh-pe-limweh (365). ");
INSERT INTO ktm_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enok ti indrimat pwi, odosa iy ti kowson Petngendrei. Petngendrei ikuni iy, pe sa ndramat hendrendre-et ye iy pwi. ");
INSERT INTO ktm_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metuselah eri krismas tadan sangat-ndrorungeh-pe-ondrotoloh (187), pe nedun homou kamal rangan Lamek. ");
INSERT INTO ktm_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Metuselah imin yi, iyenon ndre krismas puken ndrotulnget-ndrorungeh-pe-ruweh (782). Iy nedun kamal pe pedih se yi. ");
INSERT INTO ktm_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Krismas tadan ile ndre puken ansangat-onngoh-pe-ndrosih (969), pe iy imet. ");
INSERT INTO ktm_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek krismas tadan sangat-ndrorungeh-pe-ruweh (182), pe nedun homou kamal. ");
INSERT INTO ktm_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Pe iy ipe ihpah, “Tidu tidempo marai puko-on odo maryan song, odosa Lapan indrahyan poi ndre pihe tih. Odoke nedu kuti we kihnan pe maryan song we kile hukulon pe tidu we titmiyau hepe.” Ile pe Lamek iyuwen rangan nedun ile Noah. ");
INSERT INTO ktm_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamek imin krismas ndre limnget-onsungoh-pe-limweh (595), pe nedun kamal pe pedih se yi. ");
INSERT INTO ktm_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Krismas tadan ile ndre puken ndrotulnget-ndrotulngeh-pe-ondrotoloh (777), pe iy imet. ");
INSERT INTO ktm_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noah krismas tadan ile limnget (500), eri iy nedun ndre tulmuu kamal, Siem, Jafet pe Ham. ");
INSERT INTO ktm_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ndramat hohor hala pule-en lokpoi ndre mandra-an, pe hotou nedu’ su pihin. ");
INSERT INTO ktm_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Su nedun Petngendrei kamal su lakopwi, ile pe su hasa pe hasuwon su se ile reh ta su. ");
INSERT INTO ktm_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ile pe Lapan ipe ihpah, “Yu we kundretawe sa ndramat hondroto pe hondroto ndresale pwi. Su we hamat. Ile pe idu mahkele pe ile, eri su we hondroto kindritapelwen krismas puken sangat-pe-rungeh (120) pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Idu mundrun eti pe ise omur, eri lau se ti mandra-a’ sa pe elwe-e’ sa hodo lokpoi. Su lau eriy, eri yayan nedu’ su pedih odo lokpoi ndre hasuwon su nedun Petngendrei kamal. Su lapan pahun pe ranga’ su inehnding ndre pihe. ");
INSERT INTO ktm_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Lapan indroni punuwon ndramat odo lokpoi ile mo-on lakopwi. Punou mo-on eri immin pala’ su sei ihpa ke sei. ");
INSERT INTO ktm_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ile pe Iy isamat ihpa, “Yu uhnan su pe uduwe su hodo lokpoi ti ile sa? ");
INSERT INTO ktm_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Kile Yu kundretawe su pwi, eri lehpe huyen. Konan. Yu we kuhnan sa ndramat ndre sulo-on ndre Yu uduwei ti we hamat. Ka-an pe nenka-an ndre sulo-on ti we honum yi.” ");
INSERT INTO ktm_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Odoke Noah eri Lapan irih tadan. ");
INSERT INTO ktm_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Kuti pohtidi-iy tan Noah. Noah kopwi ti ndramat huyen pe lila-an huyen ile madan Lapan idu kalmene-en erti. Iy intawonon Lapan iyin munen. ");
INSERT INTO ktm_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Iy nedun ndre tulmuu kamal: Siem, Jafet pe Ham. ");
INSERT INTO ktm_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Odoke sa ndramat ndre sulo-on ti punuwo’ sa indremimel ile madan Lapan pwi. Hompo ke loroh pe horroh ke ndramat odo lok ndre sulo-on. ");
INSERT INTO ktm_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Lapan indre-et ile lokpoi ndre mandra-an, pe indrendroni hemir ndramat huye’ su hondruto hepe pwi. Ndramat ndre sulo-on ti hompo ke to-ir. ");
INSERT INTO ktm_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Lapan ipe ile tan Noah ihpah, “Yu undretawe tawene ihpa ndre ndramat we honum ndresale odo lokpoi, odosa lokpoi ti indritah odo punou mo-on. ");
INSERT INTO ktm_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Opondrih kei huyen pe ohtong sih ndrolim. Ahnan rum ki-in lon pe ewepisi kolta kile ndruwen pe lon. ");
INSERT INTO ktm_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Mandra-an tan ndrol tadam eri kihpa ndre kurti: elwe-en tadan eri mita sangat-pe-tulngeh (130), murun tadan eri mita rungeh-pe-ruweh (22), pe pule-en idu lon ile eleng eri mita sungoh-pe-toloh (13). ");
INSERT INTO ktm_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Otmon mbrungyen ndrol. Kidu mbrungiy pe kise ngerin ndrol eri eduwe lengan ihpa ndre sentimita hangoh-pe-limweh (45) pe ahnan reu ki-in eriy. Ou ohtong eri ndruhun mandro o dek eri kihndre toloh, sih kise poi, sih kise ndrokoron, pe sih kise eleng. Pe eduwe pohngkiu kise padan. ");
INSERT INTO ktm_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Yu we kuhnan nor pe uluw kideh pe kisulmwe-en lokpoi pe sane ndre sulo-on we hamat. ");
INSERT INTO ktm_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Odoke Yu we kuhnan poromis handrai kile tadam yi. Ala lon ndrol ndrodan mbrulum, nedum su kamal pe mbrulu’ su. ");
INSERT INTO ktm_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Ka-an pe nenka-an handrai pe handrai, homou kamal pe homou ndrukwil we hasa hun ou. Ou okuni su hala lon ndrol, kile we hendrimat pwi. ");
INSERT INTO ktm_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Pe okun song handrai pe handrai, ana’ oduu ndramat, pe ana’ su ka-an pe nenka-an yi.” ");
INSERT INTO ktm_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noah ihnan sane ndre sulo-on ihpa ndre Lapan ipe ile tadan. ");
INSERT INTO ktm_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Lapan ipe ile tan Noah, “Ou kopwi odo lenga’ sa ndramat ndre sulo-on odo lokpoi ti ompo sane huyen. Ile pe ou, mbrulum, nedum su kamal pe mbrulu’ su, atla lon ndrol. ");
INSERT INTO ktm_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ou okun ndrotulmuu kamal pe ndrotulmuu ndrukwil odo ka-an handrai handrai ndre huye’ su odo modo. Odoke sane ka-an ndre mo-on odo modo, eri okun rumuu koson, homou kamal pe homou pedih odo handrai handrai. ");
INSERT INTO ktm_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Pe nenka-an yi eri okun ndrotulmuu kamal pe ndrotulmuu ndrukwil odo handrai handrai. Ile pe ka-an pe nenka-an handrai pe handrai we hendrimat pwi, pe we hohor yi odo lokpoi. ");
INSERT INTO ktm_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Rang ndre ndrodul kinum pe Yu we kuhnan lengin kindrut meseren hangoh pe lukumwen hangoh. Ile pe sane ndre sulo-on ndre Yu undrahnan, eri we hamat ndre kilnum.” ");
INSERT INTO ktm_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Pe Noah ihnan sane ndre sulo-on ndre Lapan ipe ile tadan. ");
INSERT INTO ktm_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noah krismas tadan kah ndre puken anngat (600) ti pe wo ideh odo lokpoi. ");
INSERT INTO ktm_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Iy pe mbrulun, nedun su kamal pe su yinan, ha-au wawen nor pe hondroh ile ndrol, ");
INSERT INTO ktm_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","ile ndrodan ka-an huye’ su odo madan Lapan, pe iy ndre mo-o’ su ile ndre-et ta Lapan. Pe nenka-an yi eri ihpa ke eriy. ");
INSERT INTO ktm_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Su ndre sulo-on hala lon ndrol ndrodan Noah, ihpa ndre Lapan ipe ile tadan. ");
INSERT INTO ktm_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Rang ndre ndrodul inum ti pe nor ihir lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noah ke imin lokpoi ti iyenon ndre krismas puken anngat. Pe idu mundrun rang 17th odo ndrou Februari odo krismas eriy, eri kuwor odo wo iyin pahndran poi ti itpar pe wo ihmbruh ise eleng, pe parar iseket ");
INSERT INTO ktm_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","pe lengin indrut ise poi iyenon ndre meseren hangoh pe lukumwen hangoh. ");
INSERT INTO ktm_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Idu ke ndre rang eti pe Noah, mbrulun, nedun su kamal ndre tulmuu, Siem, Jafet pe Ham, ndrodan mbrulu’ su, ha-au hala lon ndrol. ");
INSERT INTO ktm_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","16","Ka-an um pe puyep, mandra-ane pe mone, kamal pe ndrukwil odo handrai pe handrai odo lokpoi, pe nenka-an yi, su hala lon ndrol ndrodan Noah su ihpa ndre Lapan ipe. Inum pe Noah ile lon ndrol pe Lapan idohi pohngkuwen. ");
INSERT INTO ktm_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Wo imndra pe ideh idu lon rang ndre hangoh, iyenon ndre kwin ndrol itlang odo poi pe ndrol itlipit. ");
INSERT INTO ktm_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Wo ideh lakopwi pe ndrol ideheh ise pule-en. ");
INSERT INTO ktm_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Wo ile orwon lakopwi pe isulmu-en puliy elwe-ene ndre sulo-on odo lokpoi. ");
INSERT INTO ktm_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Wo ideh pe ideh lakopwi ile eleng, ihluwen ndre mburmpalan puliy, iyenon ndre mita ondrotoloh yi. ");
INSERT INTO ktm_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Sane ndre sulo-on odo lokpoi hamat: ka-an, nenka-an pe ndramat ndre sulo-on. ");
INSERT INTO ktm_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Sane ndre sulo-on henehti ngoho’ su odo lokpoi ti hamat. ");
INSERT INTO ktm_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Sane ndre sulo-on ndre more’ su hodo pule-en lokpoi ti honum ndresale. Ndramat, ka-an pe nenka-an ti handrai indrimin pwi. Tapake su ndre handrimat pwi ti Noah, mbrulun, nedun kamal ndre tulmuu pe mbrulu’ su, ndroda sane ka-an pe nenka-an ndre hodo lon ndrol. ");
INSERT INTO ktm_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Wo kopwi iyin, iyenon ndre rang sangat-pe-limngeh (150). ");
INSERT INTO ktm_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Lapan indra-amelyen Noah ndrodan ka-an pe nenka-an hodo lon ndrol ti pwi. Iy intawonon Noah su pe Iy ihnan yor inguh pe wo ires munye ile poi. ");
INSERT INTO ktm_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Kuwor odo wo iyin pahndran poi ihtok yi. Kuwor odo parar yi ihtok pe lengin imndroi. ");
INSERT INTO ktm_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Lengin inum pe wo ti kah irras ile pwoi, ilto ndre rang sangat-pe-limngeh (150). ");
INSERT INTO ktm_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Pe idu rang eriy, 17th odo Julai, eri ndrol imandro imin pule-en puliy sih odo Ararat. ");
INSERT INTO ktm_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Wo ti ma irras pe idu 1st odo Oktoba eri mburmpalan puliy hehir. ");
INSERT INTO ktm_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ndruwen mburmpalan puliy hehir, eri rang hangoh ndre inum yi, pe Noah itpiri pindiwa odo ndrol. ");
INSERT INTO ktm_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Iy iduwe kotkot homou ile kiu, odoke inna ndre ndrol pwi yi. Iy ino-oh ke sehir ile sehir iyenon ke wo ihek ndresale. ");
INSERT INTO ktm_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Noah ipe kihtunon wo ti inna poi ndresale ndre mapwi. Ile pe iy iduwe pal ile kiu yi. ");
INSERT INTO ktm_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Odoke wo mapwi isorohe poi ndre mandra-an, pe pal indrepondriti hepe we iy kimandro eriy ti pwi. Ile pe iyuh ile ndre ndrol yi, pe Noah lumwen ile pe ikuni iy yi. ");
INSERT INTO ktm_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noah ikeli-iy rang ndrodul inum yi oh pe iy iduwe pal iyuh ile yi. ");
INSERT INTO ktm_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Idu ndre pehon ti pe pal ise yi pe ihti ndron oliv orwon idu pohon. Ile pe Noah ihtunon ihpah ndre wo ti indriras inna pwoi. ");
INSERT INTO ktm_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Iy ikeli-iy rang ndrodul yi inum pe iy iduwe pal ile petsih yi. Pe pal insa ndre ndrol pwi yi. ");
INSERT INTO ktm_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Krismas tan Noah ti kah puken anngat-pe-sih (601). Idu 1st odo ndrou Januari, eri wo ti kah indrihak ndresale. Noah irkwe mbrungyen ndrol sehir iyeu, pe indre-et lok ile sehir pe sehir. Iy indroni poi eri ke impukos. ");
INSERT INTO ktm_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Pe isto 27th odo ndrou Februari, eri wo indrihak pe poi indrepukos ndresale. ");
INSERT INTO ktm_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Lapan ipe ile tan Noah ihpah, ");
INSERT INTO ktm_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Ala poi odo ndrol ndrodan mbrulum, nedum su kamal pe mbrulu’ su. ");
INSERT INTO ktm_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Etkuni ka-an pe nenka-an ndre sulo-on ndrodan eduu, kile pe su hopo nedu’ su hohor pe hasarpat hala lokpoi ndre mandra-an.” ");
INSERT INTO ktm_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ile pe Noah ile pwoi odo ndrol ndrodan mbrulun, nedun su kamal pe mbrulu’ su. ");
INSERT INTO ktm_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ka-an handrai handrai hehlite su pe hoso hesel hasa kiu, kamal pe ndrukwil hoso hondroh. Su nenka-an yi hahpa ke eriy. ");
INSERT INTO ktm_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noah idihi pat pe ihnan alta ta Lapan ile eriy. Inum pe ikun ka-an pe nenka-an homou homou odo lo’ su ka-an pe nenka-an huyen ile ndre-et ta Lapan, pe itlumwi su ndre homou ea odo pule-en alta. ");
INSERT INTO ktm_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Menuhun yohou eri ihposan Lapan, pe Lapan ipe ile ke ndre Tadan yi ihpa, “Yu we kundreruson poh kinna ta lokpoi pwi yi, konan ipe ye sa lau hopo punou mo-on. Yu tuno ihpa ndre ndramat, idu iy ma ndre kom uu pe kile il nusuwon, eri we kimpo ke punou mo-on. Odoke Yu we kundrahyan sane ngoho’ su hodo ta su odo lokpoi ti pwi yi. ");
INSERT INTO ktm_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Pe iy ndre lokpoi indrinum mapwi tih, eri we sane marai ti we ndre mundru’ su ea. Tehe song ti we ndre mundrun, pe takun sengin song odo langah ti we ndre mundrun. Lok ti we killa wo-on pe mburten. Lengin ndre mundrun pe mundroi ndre mundrun. Meseren pe lukumwen we herehir kopwi. Sane ndre sulo-on kuti we hehhir kopwi iyenon ndre lokpoi kinum.” ");
INSERT INTO ktm_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Lapan iduwe puko-on ile tan Noah pe nedun su pe ipe ihpah, “Otpo nedu’ oduu hala sulo-on, ile pe yaya’ oduu hasarpat hala lokpoi ndre mandra-an. ");
INSERT INTO ktm_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Pe oduu we mada’ oduu kise ta su ka-an, nenka-an pe ni. Su we hoso pahndran oduu pe honnoh taduu. ");
INSERT INTO ktm_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","“Oduu kawe otyo-on yohou ndre sulo-on, kile ndre ndrodan mbrulei pe mbrwen kei. Yu uduwe ndre sulo-on ana’ oduu odo yo-on. ");
INSERT INTO ktm_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Tapake otyo-on sengin yohou ndrai mapwi idu eriy ti kolwii. Odosa ndrai ti ihpa ndre ndramat moren. ");
INSERT INTO ktm_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ipe ye homou kepwi homou ndramat kimet, eri we kikun pede-en. Iy ka-an kehe ndre keti ndramat kimet, eri we kimet yi. ");
INSERT INTO ktm_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Yu Lapan. Yu uhnan ndramat eri ihpa ke ndre Yu. Ile pe uh si lau ndre kepwi homou ndramat kimet, eri sa ndramat we hapwi iy kimet yi. ");
INSERT INTO ktm_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Otpo nedu’ oduu kile sulo-on pe odohor kile pule-en lokpoi ndre mandra-an.” ");
INSERT INTO ktm_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Petngendrei ipe ile tan Noah pe nedun su yi ihpa, ");
INSERT INTO ktm_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Yu mahkele kah kude penuw ndrodan oduu pe su yaya’ oduu, ");
INSERT INTO ktm_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ndrodan ka-an pe nenka-an yi ndre hondroh ise pwoi odo ndrol ndrodan oduu tih. ");
INSERT INTO ktm_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nolwo-on penuw Todo ti kurti: Yu upwe ndre ndrokene ihpa ndre Yu we kundrahnan wo kinsulmu-en lokpoi pwi yi. Yu we kundrahnan sa ndramat ndrodan ka-an pe nenka-an handrimat odo wo ideh pwi yi. ");
INSERT INTO ktm_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","“Ta penuw Todo kurti ile ndrodan oduu ndramat pe su ka-an pe nenka-an yi, pe we kindrito pe kindrito, kenon ndre lokpoi kinum. Ile pe kile kalmene-en poromis Todo kudu, eri ");
INSERT INTO ktm_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Yu we kuduwe ka-uh kayeh Todo ki-in lon kohut. Iy erti kalmene-en ta penuw Todo ndroda lokpoi. ");
INSERT INTO ktm_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Uh Yu kusorohe parar kile kohut pe ka-uh kayeh kihir, ");
INSERT INTO ktm_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","eri we Yu kudawonon poromis Todo ile tadam pe su ka-an, ihpa ndre Yu we kundretawe wo kideh pe kihyan sane ndre sulo-on more’ su ti pwi yi. ");
INSERT INTO ktm_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Uh Yu kundroni ka-uh kayeh ki-in lon kohut, eri Yu we kudawonon ta penuw ndre Yu undrahnan. Ta penuw ndre we kinto pe kinto idu lengo pe lengan sane more’ su hodo lokpoi. ");
INSERT INTO ktm_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ka-uh kayeh erti ile kalmene-en poromis ndre Yu ko umpo ile ta su sane ndre sulo-on ngoho’ su idu ta su.” ");
INSERT INTO ktm_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Su nedun Noah kamal ndre ho-us ndrol ndrodan iy ti Siem, Jafet pe Ham. Ham nedun ti Kenan. ");
INSERT INTO ktm_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Sa ndramat ndre sulo-on odo lokpoi ti hehir odo ke ta su nedun Noah ndre tulmuu. ");
INSERT INTO ktm_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noah ti ndramat odo tehe sane pe iy ti iyin munen odo tehe padan wain ile langah. (Mbrwen wain ti henelisen ihhir ile wain.) ");
INSERT INTO ktm_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Petsih eri iy iying wain ile hudut pe wain ipuhnen iy. Iy ilmetir ile lon emwen pelei odoke iy indretawonon iy pwi pe ndrihin iturup. ");
INSERT INTO ktm_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham indroni taman inemetir kolowen ke pwi, pe iy ilninen ile tan tinton horu. ");
INSERT INTO ktm_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Siem pe Jafet hartakuni kolau iyin ngondru’ horu, pe herlila ile ndruwe’ horu ile um pelei, pe horsorohe tama’ horu. Horu mada’ horu inna munen pwi, kihne herndroni tama’ horu inemetir ndrihin ke pwi. ");
INSERT INTO ktm_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noah ile huyen ti pe isehtunon homosa ndre nedun omur, Ham, ipu ile tadan, ");
INSERT INTO ktm_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","eri pe iy isamtan Kenan (nedun Ham kamal) ihpah, “O saleu, Kenan kile ke hono-on marai ke porah tan tinton su.” ");
INSERT INTO ktm_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Pe Noah ipe yi ihpah, “Titsori rangan Petngendrei. Iy Lapan ta Siem. Kenan we kile hono-on maryan Siem. ");
INSERT INTO ktm_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Lapan we kihnan yayan Jafet kihur kile sulo-on. Pe hodo ndroda su yayan Siem. Pe yayan Kenan su ti we hala hono-on marya’ su yayan Jafet.” ");
INSERT INTO ktm_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Idu ndruwen nor ti pe Noah imin krismas puken tulnget-pe-limngeh (350) yi. ");
INSERT INTO ktm_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Krismas tadan ile ndre puken ansangat-pe-limngeh (950) pe iy imet. ");
INSERT INTO ktm_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Kurti tatili-iy ta su nedun Noah kamal, Siem, Jafet, pe Ham. Su hopo nedu’ su pe hosohor idu ndruwen wo ideh. ");
INSERT INTO ktm_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Su nedun Jafet kamal eri: Gomer, Magok, Madai, Javan, Tubal, Mesek, pe Tiras. ");
INSERT INTO ktm_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Su nedun Gomer kamal ti: Askenas, Rifat, pe Togarmah. ");
INSERT INTO ktm_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Su nedun Javan kamal eri: Elisah, Tarsis, pe su lau odo Saiprus, pe su lau odo Dodan. ");
INSERT INTO ktm_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Sa lau odo ngerin ndras pe mbruso ti hehir odo ta su nedun Javan. Su ndre sulo-on ndre hendrepahran su kurti hehir tan Jafet. Su hemir pe hemir ti hemin ndre kantri tasu iyenon, pe ndre nolwo-o’ su ea. ");
INSERT INTO ktm_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Su nedun Ham kamal ti: Kus, Isip, Libia, pe Kenan. ");
INSERT INTO ktm_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Su nedun Kus kamal eri: Seba, Havilah, Saptah, Ramah, pe Sapteka. Ramah ti nedun rumuu kamal: Seba pe Dedan. ");
INSERT INTO ktm_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Pe Kus ti nedun homou kamal yi rangan Nimrot. Nimrot ti iy lau puko-on lakopwi odo pahun. ");
INSERT INTO ktm_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Lapan iduwe puko-on ile tan Nimrot pe iy ihir ile ndramat puko-on odo pondrih sane yohou. Ile pe sa lau hampa ihpah, “Lapan kihnan ou ala ndramat puko-on odo pondrih yohou ihpa ndre Nimrot.” ");
INSERT INTO ktm_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ndre mamunen eri iy ihtungon taon ndre toloh: Babel, Erek, pe Akat. Taon kuti hoso lon kantri Babilonia. ");
INSERT INTO ktm_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nimrot itlang odo Babilonia ti pe ile Asiria, pe itmon taon mandra-ane ndre hahuu: Niniveh, Rehobotir, Kalah, ");
INSERT INTO ktm_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","pe Resen. Resen ti ise ndrokoron Niniveh pe Kalah. Kalah eri taon mandra-an ihpa ndre siti. ");
INSERT INTO ktm_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Nedun Ham ndre Isip (rangan handrai yi ti Mizraim) ti iduwe: su Lidia, Anam, Lehap, Naptuh, ");
INSERT INTO ktm_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrus, Kasluh, pe Krit. Su lau odo Filistia ti hehir odo ndrongo’ su Krit. ");
INSERT INTO ktm_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Nedun Ham ndre Kenan ti iduwe Saidon. Saidon ti ndrihou tan Kenan. Kenan ti yayan imbruw ile su Hit, ");
INSERT INTO ktm_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","pe su Jebus, pe su Amor, pe su Girgar, ");
INSERT INTO ktm_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","pe su Hivi, pe su Arka, pe su Sini, ");
INSERT INTO ktm_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","pe su Arvat, pe su Semar, pe su Hamat. Su yayan Kenan ti hohor pe hasarpat, ");
INSERT INTO ktm_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","pe ngerin su ile-en ndre Sidon pe ile kup ea, ile ndre Gerar pe ilmendrih ndre Gasa. Ngerin lone’ su ti ile ndre rai ea yi, ile ndre Sodom, Gomorah, Atmah, pe Seboim, mukehe odo Lasa. ");
INSERT INTO ktm_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Su ndre sulo-on ndre hendrepahran su kurti hehir ta Ham. Su hemir pe hemir ti hemin ndre kantri tasu iyenon, pe ndre nolwo-o’ su ea. ");
INSERT INTO ktm_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Tolun kom tan Noah ti Siem. Siem ti papon su lau odo Eber. ");
INSERT INTO ktm_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Su nedun Siem kamal ti: Elam, Asur, Arpaksat, Lidia, pe Aram. ");
INSERT INTO ktm_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Su nedun Aram kamal eri: Us, Hul, Geter, pe Mas. ");
INSERT INTO ktm_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksat ti nedun Selah, pe Selah ti nedun Eber. ");
INSERT INTO ktm_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber ti nedun kamal rumuu: Homou ti rangan Pelek, odosa idu mundrun erti, sa lau odo lokpoi ti hatpar pe hasarpat. Su hemir ti hala sehir, pe su hemir ti hala sehir, pe su hemir ti hala sehir. Ile pe Pelek ti ihpa ndre ‘hatpar.’ Nedun Eber homou yi ti Joktan. ");
INSERT INTO ktm_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Su nedun Joktan kamal eri: Almodat, Selep, Hasarmavet, Jerah, ");
INSERT INTO ktm_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Diklah, ");
INSERT INTO ktm_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO ktm_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havilah, pe Jobap. Su ndre sulo-on kuti nedun Joktan. ");
INSERT INTO ktm_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Su nedun Joktan ti hekuni lok idu Mesa pe ilto Sefar, odo lok puliy ile rai ea. ");
INSERT INTO ktm_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Su ndre sulo-on ndre hendrepahran su kurti hehir tan Siem. Su hemir pe hemir ti hemin ndre kantri tasu iyenon, pe ndre nolwo-o’ su ea. ");
INSERT INTO ktm_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Iy kurti tatili-iy ta su yayan nedun Noah ndre tulmuu. Idu ndruwen wo ideh ti pe ndramat kurti hohor pe hasarpat hala lokpoi ndre mandra-an. Ile pe ndramat ndre sulo-on odo kantri sih sih mahkele eri hehir ke ta su nedun Noah ndre tulmuu. ");
INSERT INTO ktm_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Idu ndruwen wo ideh ti pe ndramat hondrohor hanna sulo-on, odoke nolwo-o’ su ti mapwi handrai kopwi. ");
INSERT INTO ktm_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Su hala wuron rai ea pe hamandro hodo lok sehir mandra-an pe malahan ise Babilonia. ");
INSERT INTO ktm_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Su hopunou ihpah, “Tidu titakun poi palat pe tidapisii. Kinum pe titulmwi poi erti kihir pidikis.” Pat sulo-on hondroto lok kurti pwi, ile pe su hopo pidikis ile tumwe um. Su hentawe kolta ile lengan pidikis pe indrotowei inehndrepit. ");
INSERT INTO ktm_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Inum pe su hapa ihpah, “Tidu kah tidahnan sih taon, pe tidehtong sih tawa elwe-en kile ndre parar eleng. Kile pe ranga’ tidu kihnding, pe titsarpat kile pule-en lokpoi ndresih kolwii.” ");
INSERT INTO ktm_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Odoke Lapan ise pwoi pe isendre-et taon pe tawa ndre sa ndramat henehtong kurtih. ");
INSERT INTO ktm_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Lapan ipe ihpah, “Su ke hokor pe nolwo-o’ su ke handrai, ile pe su hompo sane kutih. Omur ti su we hanon hopo sane ndre sulo-on kile reh ta su. ");
INSERT INTO ktm_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Atsa. Tidu titla pwoi pe titsopelwen nolwo-o’ su kidut, kile pe su homou kihrungi homou kolwii.” ");
INSERT INTO ktm_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ile pe Lapan ihnan su hatpar hala hemir hemir, pe su hasarpat hala lokpoi ndre mandra-an, pe su hendrendrumwi marai odo taon ti pwi. ");
INSERT INTO ktm_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Lok kuti rangan ile Babel, odosa Lapan isopelwen nolwo-on taha ndramat ndre sulo-on, pe ihnan ndramat hasarpat hala pule-en lokpoi ndresih. ");
INSERT INTO ktm_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Iy kuti tatili-iy ta Siem. Krismas ruweh odo ndruwen wo ideh ti, Siem krismas tadan ihir puken sangat, pe iy nedun homou kamal rangan Arpaksat. ");
INSERT INTO ktm_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Inum ti pe Siem imin lokpoi krismas puken limnget (500) yi, pe iy nedun kamal pe pedih se yi. Inum pe iy imet. ");
INSERT INTO ktm_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpaksat krismas tadan ile ndre tulngeh-pe-limweh (35) pe iy nedun kamal homou rangan Selah. ");
INSERT INTO ktm_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Inum ti pe Arpaksat imin lokpoi iyenon ndre krismas puken hangat-pe-toloh (403) yi, pe iy nedun kamal pe pedih se yi. Inum pe iy imet. ");
INSERT INTO ktm_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Selah krismas tadan ile ndre tulngeh pe iy nedun kamal homou rangan Eber. ");
INSERT INTO ktm_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Inum pe Selah imin lokpoi krismas hangat-pe-toloh (403) yi, pe iy nedun kamal pe pedih se yi. Inum pe iy imet. ");
INSERT INTO ktm_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber krismas tadan ile ndre tulngeh-pe-hahuu, (34) pe iy nedun kamal homou rangan Peleg. ");
INSERT INTO ktm_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Inum pe Eber imin yi, iyenon ndre krismas hangat-pe-tulngeh (430) pe iy nedun kamal pe pedih se yi. Inum pe iy imet. ");
INSERT INTO ktm_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg krismas tadan ile ndre tulngeh pe iy nedun kamal homou rangan Reu. ");
INSERT INTO ktm_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Inum pe Peleg imin yi, iyenon ndre krismas runget-pe-ndrosih (209) pe iy nedun kamal pe pedih se yi. Inum pe iy imet. ");
INSERT INTO ktm_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu krismas tadan ile ndre tulngeh-pe-ruweh (32) pe iy nedun kamal homou rangan Seruk. ");
INSERT INTO ktm_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Inum pe Reu imin yi, iyenon ndre krismas runget-pe-ondrotoloh (207) pe iy nedun kamal pe pedih se yi. Inum pe iy imet. ");
INSERT INTO ktm_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruk krismas tadan ile ndre tulngeh, pe iy nedun kamal homou rangan Nahor. ");
INSERT INTO ktm_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Inum pe Seruk imin yi, iyenon ndre krismas runget (200) pe iy nedun kamal pe pedih se yi. Inum pe iy imet. ");
INSERT INTO ktm_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor krismas tadan ile ndre rungeh-pe-ndrosih (29) pe iy nedun kamal homou rangan Terah. ");
INSERT INTO ktm_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Inum pe Nahor imin yi, iyenon ndre krismas sangat-sungoh-pe-ndrosih (119) pe iy nedun kamal pe pedih se yi. Inum pe iy imet. ");
INSERT INTO ktm_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terah imin krismas ihndre ndrotulngeh oh, pe iy ipu nedun. Iy nedun ndre tulmuu kamal. Homou rangan Abram, homou Nahor, pe homou Haran. ");
INSERT INTO ktm_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tatili-iy tan Terah ti ihpah: Terah ti nedun tulmuu kamal: Abram, Nahor, pe Haran. Haran ti nedun Lot. ");
INSERT INTO ktm_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran imet odo lonen ndre Ur ilso Babilonia idu taman ti mapwi imin. ");
INSERT INTO ktm_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram horu Nahor harasou. Mbrulun Abram ti rangan Sarai, pe mbrulun Nahor ti Milkah. Milkah horu Iskah ti tama’ horu Haran. ");
INSERT INTO ktm_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai ti indranon kindripo nedun pwi. ");
INSERT INTO ktm_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah ikuni su lewen pe hatlang odo Ur odo Babilonia (Kaldia), pe su halla hala wuron Kenan. Su ndre ho-us Terah ti Abram pe mbrulun Sarai, pe nedun Haran ndre Lot. Abram ti taman Terah, pe Lot eri papon ti Terah. Su hendrihir Kenan mapwi, pe hamandro hodo taon sih rangan Harran. ");
INSERT INTO ktm_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terah, krismas tadan ile ndre puken runget-pe-limweh (205), pe iy imet imin Harran. ");
INSERT INTO ktm_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Lapan ipe ile tan Abram ihpah, “Atlang owou odo lonem, owou ta sa lewim, owou ta su murwom, owou tan tamam pe tintom su, pe atlang ala lok sehir Yu we kupaninyan kile tadam. ");
INSERT INTO ktm_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Yu we kuhnan papum su hohor hala sulo-on pe we hehir kihpa ndre kantri sih. Yu we kuduwe mandro-om kile huyen pe rangam we kile mandra-an. Pe uh sa ndramat hapa hopo nolou huyen kile ta homou lau yi eri su we hampa kihpa, ‘Lapan kipu huyen kile tadam, ihpa ndre Iy ipu ile tan Abram.’ ");
INSERT INTO ktm_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Yu we kupu huyen kile ta si lau ndre kipu huyen kile tadam, pe Yu we kupu mo-on kile ta si lau ndre kipe nolou mo-on kile puli-im. Pe odo ou kopwi pe Yu we kumpo huyen kile ta sa lau odo hokor pe hokor odo lokpoi.” ");
INSERT INTO ktm_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ile pe Abram ihrungi nolou ta Lapan pe itlang iyeu. Lot itlang pe iyus iy. Krismas tan Abram ti ndrotulngeh-pe-limweh (75) idu mundrun ndre iy itlang odo Harran. ");
INSERT INTO ktm_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Su ndre ho-us Abram ti mbrulun ke Sarai, Lot nedun tinton, tasu sane ndre sulo-on, ndrodan ndre su lewen marai tadan. Su ha-au odo Harran pe helihir lok sehir mandra-an rangan Kenan. ");
INSERT INTO ktm_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Lila tan Abram odo pule-en lok erti ilihir ndre ndruhun surok hene ta su Kenan ise kendrun kei he-ei nombruwen odo Moreh, odo lok hokor rangan Sekem, ise ndrokoron Kenan. Idu kalmene-en eriy, eri su lau odo Kenan hodo lok kurti. ");
INSERT INTO ktm_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Lapan ihir ile ngon Abram pe ipe ihpah, “Yu we kuduwe lok kurti kile tan papum pe tinembrum su.” Ile pe Abram ihtungon alta ta Lapan ile kalmene-en Lapan ihir ile ndrongon iy odo lok erti. ");
INSERT INTO ktm_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Abram imin Sekem oh pe itlang ile wuron puliy ise kup pe imandro imin ndrokoron Betel pe Ai. Betel ile ahai pe Ai ile rai, pe iy ihtungon um pelei tadan imin ndrokoron. Iy ihtungon alta sih yi pe isurok ile ta Lapan. ");
INSERT INTO ktm_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Abram itlang odo ndrokoron Betel pe Ai, pe imandro sehir ile sehir ile wuron lok Negev ise kup ea. (Negev ti lok sehir mandra-an, odoke iseu ke porah, odosa, wo pe sane kei sulo-on hendre-en eriy pwi.) ");
INSERT INTO ktm_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Lengin indrindrut pwi, lok ika, pe sane song inum odo Kenan. Ile pe Abram iyeu ile pwoi ile Isip. Iy ipe we kilmin Isip oh, kenon ndre mandro huyen kihir yi. ");
INSERT INTO ktm_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Abram su hala ndre mukehe Isip ti pe iy ipe ile tan mbrulun ke Sarai ihpa, “Ou ti pedih rahyem lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Sa lau odo Isip we heltuwe ou ti we hapa ou ti mbrulu. Eri kihne su hapwi yu kumwet pe ou emin. ");
INSERT INTO ktm_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Apa kile ta su kihpa ndre yu ti timsu-u ou. Kile pe su handrapwi yu kundrimat pwi, pe hopo huyen kile todo.” ");
INSERT INTO ktm_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abram ihir Isip ti pe sa lau mada’ sa ile ta Sarai, pe heltuwe ihpa ndre ndre ndrokene iy ti pedih rahyen lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Su lau mandra-ane tan king helninen ile tadan, ile pe king ipe ile ta su hala pe hekuni Sarai ile um tadan. ");
INSERT INTO ktm_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","King waso-on Sarai lakopwi, ile pe iy ipu huyen ile tan Abram. King ihlingi Abram ile sipsip sulo-on, makau sulo-on, donki kamal pe donki ndrukwil, kamel sulo-on, pe ndramat kamal pe pedih odo marai. ");
INSERT INTO ktm_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Odoke Lapan iduwe sik sulo-on mo-on hala tan king, odosa iy ikuni Sarai mapwi imin ndrongon iy. Su mbrulun king pe su nedun ndroda sa lau hompo marai tadan, su ndre solo-on helnget sik yi. ");
INSERT INTO ktm_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ile pe king iyuwen Abram pe ipe ihpa, “Ou ti ondrupo sa ile todo? Pedih kurti mbrulum, pe ihpa kehe ou endripa ile todo pwi? ");
INSERT INTO ktm_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ihpa kehe pe ou apa iy ti timsu-um, ile pe yu ukuni iy ile mbrulu tih? Kah, mbrulum idu kiti. Ekuni iy pe ara-au.” ");
INSERT INTO ktm_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Inum pe king ipe ile ta su lau tadan ihpa, “Atakuni Abram su lewen ha-au.” Ile pe Abram iyeu odo Isip ndrodan ndre mbrulun, su lewen, pe tadan sane ndre sulo-on. ");
INSERT INTO ktm_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ile pe Abram itlang iyeu odo Isip, pe ile yi ndre wuron Negev ea. Iy ikuni mbrulun pe tadan sane ndre sulo-on. Lot iyus iy yi. ");
INSERT INTO ktm_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram tadan sane ti sulo-on lakopwi. Iy tadan makau, sipsip, kamel, donki, pe iy tadan silwa pe gol sulo-on. ");
INSERT INTO ktm_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Abram itlang odo Negev pe inemandro sehir ile sehir, iyenon ndre iy ilihir yi ndre ndrokoron Betel pe Ai, lok ndre iy imandro imin eriy pihe ");
INSERT INTO ktm_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","pe ihtungon alta sih tih. Inum pe Abram isurok ile ta Lapan. ");
INSERT INTO ktm_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Isito kurti eri Lot ti mapwi inu-us ke Abram. Lot ti mbrulun pe nedun yi. Iy tadan makau, sipsip, pe donki sulo-on. Iy lewen odo marai sulo-on yi. ");
INSERT INTO ktm_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Odoke song ana’ su sipsip, makau pe donki ti isenonon pwi, odosa horu ta horu sane kurti ile hudut lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ile pe su lewen marai tan Abram ti hompo loroh ile ta su lewen marai ta Lot, ile lahnga’ song ana’ su ka-an. Su lau odo Kenan pe Peres ti mapwi honto lok kurti yi. ");
INSERT INTO ktm_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ile pe Abram isohou ile ta Lot ihpa, “Toru ti ndrai ke hepwil kopwi. Odoke su lewen marai ta toru ti hanta ke su. Pe kihne heduwe lenga’ toru kihmo-on. ");
INSERT INTO ktm_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Enendroni lok ndre mandra-an iyin kiti. Toru tertalngan toru. Uh, ou wasu-um lok ile kamweu, eri yu we kule mudon. Pe uh, ou wasu-um apa ala mudon, eri yu we kule kamweu.” ");
INSERT INTO ktm_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot indre-et, pe iltuwe lok mandra-an pe malahan ile wuron wo Yordan, pe ilto ndre taon Soar. Lok kuti wo he-en eriy, pe sane kei he-en eriy yi. Ndre-et ta lok erti huyen ihpa ndre lok Iden Lapan ihnan pihe, pe ihpa ndre Isip. Idu mundrun kudu eri Lapan indretulmwi Sodom pe Gomorah ti mapwi. ");
INSERT INTO ktm_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ile pe Lot waso-on lok ile wuron Yordan, pe ikuni tadan sane pe lewen su, pe iyeu ile rai. Lot horu Abram hertelnge horu. ");
INSERT INTO ktm_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram imin ndre Kenan, pe Lot iyeu ile lengan taon ndre hesiki odo Yordan. Iy itmon um pelei tadan ise koson Sodom. ");
INSERT INTO ktm_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Su lau odo Sodom ti layo-on mo-o’ su. Su hompo to-ir hudut. Lapan indrehposan su pwi. ");
INSERT INTO ktm_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Abram kah iy kopwi imin, pe Lapan ipe ile tadan ihpa, “Odo kirti pe endre-et kile tolau pe kup, rai pe ahai. ");
INSERT INTO ktm_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Yu we kuduwe lok ndre sulo-on ou eneltuwei kiti we kile lonem, pe lonen papum su, kenon ndre lokpoi pe sane ndre sulo-on kinum. ");
INSERT INTO ktm_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Yu we kuduwe papum su hohor hala sulo-on kihpa ndre on odo papi. Su we hala hudut lakopwi, pe homou kindranon kindrendrumon su pwi. ");
INSERT INTO ktm_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Alla kile pule-en lok ndre mandra-an pe elturii, odosa, Yu kawe kuduwe kile lonem.” ");
INSERT INTO ktm_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ile pe Abram su hatlang pe halmandro hala koson kei nombruwen su odo Mamre. Mamre ti ise koson taon Hebron. Abram ihtungon alta sih pe isurok ile ta Lapan. ");
INSERT INTO ktm_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","King hamou odo rai: Amrafel odo Babilonia, Ariok odo Elasar, Kedorlaomer odo Elam pe Tidal odo Goim. ");
INSERT INTO ktm_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","7","Su king ndre hamou kurti mada’ su iso pule-e’ su king limuu yi odo ahai. Su king odo ahai kurti: Bera king odo Sodom, Birsa odo Gomorah, Sinap odo Atmah, Semeber odo Seboim ndrodan king odo Bela (Soar). Su king ndre limuu odo ahai kurti idu munen eri hoso pahndran king Kedorlaomer odo rai iyenon ndre krismas sungoh-pe-ruweh. Odoke isito krismas sungoh-pe-toloh eri su hehmbore su hodo pahndran king Kedorlaomer. Ile pe idu krismas sungoh-pe-hahuu eri king Kedorlaomer ideparngan su kowos king tadan ndre tulmuu odo rai, pe su hopo pahun ise pwoi. Su horohe su lau odo Rafaim. Pahun kuti ihir odo taon Asterot Karnaim, pe su king ndre hamou kuti hala win. Inum pe su hopo pahun ile pule-e’ su Sus odo taon Ham pe hopo winim su. Su hopo winim pahun ile pule-e’ su Em odo koson taon Kiriataim. Su hala pe hapwi su Hor odo puliy Seir, pe ha-as su helihir ndre Elparan. Inum pe su hopo pahun ile wuron taon Kades (rangan Kades mune ti Enmispat). Pe su hala win pe hekuni lok ndre mandra-an ise lumwen su Amalek. Odo taon Hasason Tamar ti, su hopo pahun ile pule-e’ su lau odo Amor pe hala win. ");
INSERT INTO ktm_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","King ndre limuu odo ahai hehrungi ihpa ndre king ndre hamou odo rai we hospo pahun kise pule-e’ su. Ile pe su hala ndrolon Sidim pe hedihi ndram ise eriy pe hengkeli-iy, iyenon ndre king hamou ti hehir pe su hopo pahun. ");
INSERT INTO ktm_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ndrolon odo Sidim ti sa heni-il kolta odo eriy, ile pe lok ndre mandra-an ti ngat kopwi. Pahun ile puko-on lakopwi, ile pe king odo Sodom horu king odo Gomorah horohtot hara-au, odoke horu hartaketi harla lon ngaden kolta. Su king tulmuu odo ahai ndre mapwi hodo ti hohtot ha-au hala puliy. ");
INSERT INTO ktm_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Su king ndre hamou odo rai ti hopo winim pahun pe hekuni song pe sane ndre sulo-on odo Sodom pe Gomorah pe ha-au. ");
INSERT INTO ktm_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lot, nedun tinton Abram ti, imin Sodom. Ile pe su king odo rai hekuni iy yi, ndrodan ndre tadan sane ndre sulo-on. ");
INSERT INTO ktm_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Orngon homou ihtot iyeu odo pahun pe ilninen ile tan Abram, ihpa ndre su king odo rai hendretakuni Lot. Abram ti imin koson kei mandra-a’ su odo Mamre. Kei kurti keyen orngon homou rangan Mamre yi. Mamre ti iy odo Amor, pe iy tinton rumuu, Eskol pe Aner. Su madan tinton ndre tulmuu kuti kowos tan Abram, iy Hibru. ");
INSERT INTO ktm_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abram ihrung ihpa ndre su king hamou hendretakuni nedun tinton, ile pe iy iyuwen su lau tadan ndre tulnget-sungoh-pe-ndrorumuu (318). Su lau tadan kurti puko-o’ su. Su hala pe ha-as king ndre hamou ndre hekuni Lot. Abram iyes su king kuti helihir ndre taon Dan. ");
INSERT INTO ktm_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Inum pe Abram itlangan su lewen pahun tadan hala hemir pe hemir. Su hopo pahun idu lukumwen pe hala win. Abram iyesilpine su king hamou kuti helihir ndre Hobah. Hobah ti ilso tolau odo Damaskus. ");
INSERT INTO ktm_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Abram su lewen hekuni sane ndre su king hekunii odo pahun munen tih. Abram ikuni Lot, ndroda su lewen Lot, pe sane ndre sulo-on ta Lot. Abram ikuni su pedih pe su lau sulo-on yi. ");
INSERT INTO ktm_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram ipu winim pahun ile pule-e’ su king ndre hamou ndre hekuni Lot, ile pe king odo Sodom ilsohou tadan odo Ndrolon Saveh (Ndrolon Tan King). ");
INSERT INTO ktm_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Pe idu mundrun eriy eri Melkisedek ti iy king odo Salem pe iy pris ta Lapan Mandra-an odo Lok Eleng. Melkisedek ikuni bret pe wain ise hun Abram, ");
INSERT INTO ktm_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","pe ipatihteh ile tadan ihpah, “Lapan Mandra-an Imin Eleng, Iy ihnan lok eleng pe lokpoi, we kimpo ke ndre huyen kile tadam. ");
INSERT INTO ktm_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ou esori rangan Lapan kile eleng, pe ehposon rangan, odosa, Ou opo pahun pe Iy ihnuwii ou ala win.” Pe Abram itlangan sane ndre iy ipu winim odo pahun ti ile ndre ndruhu sungoh. Pe iy iduwe hondroh ile tan Melkisedek. ");
INSERT INTO ktm_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Inum pe king odo Sodom ipe ile tan Abram ihpa, “Ekuni tadam sane ndre sulo-on, tapake eduwe ndromto ti hasa yi.” ");
INSERT INTO ktm_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Odoke Abram ipe ile tan king odo Sodom ihpa, “Pwi, yu undretamumoi ile rangan Lapan Mandra-an Imin Eleng, Iy kopwi ihhnan lok eleng pe lokpoi. ");
INSERT INTO ktm_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Yu we kundretakun hangka-an tadam pwi. Sane tadam ihpa ndre hepe warun esukei o esukei odo hus pulngiyen ndrikei, sane mone pe mandra-ane, ndre sulo-on, yu we kundretakun handrai pwi. Kihne ndre omur ti we ou apa yi ou kopwi ahnan pe yu todo sane sulo-on. ");
INSERT INTO ktm_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Sane ndre su lewen pahun todo handranii, eri todo erti koson. Pe kowos todo ndre tulmuu, Aner, Eskol pe Mamre, ti hehnuwii yu ile pahun, ile pe su we hokun yano’ su.” ");
INSERT INTO ktm_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ndre omur ti pe Abram indroni hangka-an ihpa ndre ndre-et odo mihmih. Pe iy ihrungi pohon Lapan inlou ile tadan ihpa, “Abram, ou onoh kolwii. Yu modo we kisso tadam. Pe Yu we kunehnuwii ou kile sane sulo-on huyen ea.” ");
INSERT INTO ktm_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram ipe ihpa, “O Lapan Mandra-an todo. Ou kopwi owonon opo sane ndre sulo-on. Odoke sane ndre Ou ka we ahngahang yu ti we kinna hangka-an pwi, odosa yu nedu pwi tih. Iy ndramat ndre yu kumwet pe iy kikuni sane kirti eri iy lewen marai todo, Elieser odo Damaskus. ");
INSERT INTO ktm_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ou andrangahang yu kom pwi tih. Ile pe uh yu kumwet eri ndramat lewen marai todo ke porah we kikuni tadan sane todo.” ");
INSERT INTO ktm_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Odoke Lapan ipe ile tan Abram ihpa, “Pwi, lewen marai tadam Elieser ti we kindretakuni sane tadam pwi. Nedum odo ndrayim we kisini ndruhum.” ");
INSERT INTO ktm_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Lapan ikuni Abram ile kiu pe ipe ihpa, “Madam kile lon parar pe endre-et pudiy. Ou etuhne ondrom su. Ndramat ndre we hehir odo mundrem ti we sulo-on kihpa ndre pudiy hoso lom parar.” ");
INSERT INTO ktm_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram tunon Lapan ti impa sane ndrokene, eri pe Abram iduwe tawene tadan pe iy ndrehomou ile ta Lapan. Ile ke bilip tan Abram erti pe Lapan iyuwen iy ‘lau kapin’ pe ihposan iy. ");
INSERT INTO ktm_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Inum pe Lapan ipe ile tan Abram ihpa, “Yu ti Lapan tadam. Yu uwin munen ou pe ou owou odo lonem Ur odo Babilonia. Yu ukuni ou asa lok ketih. Yu upwe we ou ala taman poi ketih.” ");
INSERT INTO ktm_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Odoke Abram ihndremte, “O Lapan Mandra-an, yu we kuhtuno ihpa ndre yu we kule taman lok ketih ihpa kehe?” ");
INSERT INTO ktm_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ile pe Lapan ipe ihpa, “Ala ekuni sane kuti hasa. Ala ekuni homou makau ndrukwil krismas tadan toloh, pe homou meme ndrukwil krismas tadan toloh, pe homou sipsip kamal krismas tadan toloh, pe rumuu pal.” ");
INSERT INTO ktm_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram iltakuni sane kuti hasa hun Lapan. Abram itngwi sane kuti hala ke rumbrul, pe itlangan hala ke sisihi ea, hombrul hala lain he-ei, pe hombrul hala lain he-ei. Iy indretungi pal ti pwi. ");
INSERT INTO ktm_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Nenka-an ndre hana-an sane yohou ti hapa holyo-on yohou kuti, odoke Abram iyes su ha-au. ");
INSERT INTO ktm_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Mundroi ke ipe kile pwoi, pe Abram ihron ke iy ile pwoi pe indremetir tuw. Iy iltuwe ipe yi lik mandra-an isorohe iy. Iy mundren inuh ile puko-on. ");
INSERT INTO ktm_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Pe Lapan ipe ile tadan ihpa, “Ou ohtunom ihpa ndre yayan nedum su we hala yohang odo lok hokor yi. Su we hala lewen marai ke porah ta sa hokor yi. Sa we hopo mo-on kile ta yayam su kenon ndre krismas puken hangat (400). ");
INSERT INTO ktm_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Odoke Yu we kuduwe mo-on mandra-an kile ta su lau ndre hopo mo-on ile ta yayam su ti. Pe yayam su we hekuni sane huyen ndre sulo-on ndroda su, kidu mundrun au ta su odo kantri ndre ihnan su ile hangka-an ke porah. ");
INSERT INTO ktm_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ou eri we emin huyen uu kenon ndre ou ala lopum. Pe ou we amat huyen kopwi pe we hedoni ou. ");
INSERT INTO ktm_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Yayam su we hansa yi sowin pwi. Kilto ndre omur ti ombrum su we hasa ndre keti yi. Yu mapwi ungkeli-iy to-ir ta su lau odo Amor kile mo-on lakopwi oh. Inum pe Yu we kuhnan su kihmo-on, pe ku-es su odo lok ketih.” ");
INSERT INTO ktm_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Mundroi inna pwoi pe lok kah lukumwen pe Abram ihretek ta hangka-an rundrei herihir. Handrai eri kur sehir, paryah intudot iyus lon pe handrai eri hangka-an ihpa ndre sul ndre hopus inai. Pe ka-an ndre rundrei kuti horu-us lengan yohou ndre Abram ipinii pe itlangan iyin lain ndre ru-iy. ");
INSERT INTO ktm_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Idu ke ndre lukumwen erti pe Lapan ipu poromis ile tan Abram. Lapan ipe ihpa, “Yu upu poromis. Lok keti ndre mandra-an, idu ndre kapetne-et odo kantri Isip pe ilto ndre wo mandra-an Yufretis eri Yu we kuduwe lone yayam su. ");
INSERT INTO ktm_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Lok erti ise lumwe’ su Kin pe Kenas pe Katmon, ");
INSERT INTO ktm_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","pe su Hit pe Peres pe Refaim, ");
INSERT INTO ktm_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","pe su Amor pe Kenan pe Girgas pe Jebus.” ");
INSERT INTO ktm_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Mbrulun Abram, Sarai, ti kah pedih il, odoke homou nedun mapwi. Sarai ti tadan pedih lewen marai homou rangan Hagar, iy pedih Isip. ");
INSERT INTO ktm_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ile pe Sarai ipe ile tan Abram ihpa, “Lapan ihndrepti yu, pe yu undrupo kom pwi. Ou ala emtir ndroda Hagar, kile pe iy kipu homou nedu.” Abram ihwaso-on nolou tan Sarai. ");
INSERT INTO ktm_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ile pe Sarai iduwe pedih lewen marai tadan Hagar ti ile mbrulun Abram. Abram kah ilmin Kenan iyenon krismas sungoh, idu mundrun punou kuti ihir. ");
INSERT INTO ktm_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram imtir Hagar pe Hagar ile ndriyen. Hagar ndriyen, ile pe iy kah tawene tadan ti ipe yi iy ti kah iyin pule-en Sarai. Hagar kah isentaryan Sarai pwi. ");
INSERT INTO ktm_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ile pe Sarai ipe ile tan Abram, “Ou kopwi ahnan pe Hagar isentahrung yu pwi. Yu ndre yu uduwe iy ile tadam, odoke idu ndre iy ile ndriyen, eri iy kah mboren tahrung yu. Huyen, Lapan kopwi tunon toru si ipu huyen pe si ipu mo-on.” ");
INSERT INTO ktm_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram isomwi Sarai ihpa, “Ou ohrung oh. Hagar ti lewen marai tadam, pe ou kopwi madam iso tadan. Ou apa opo kihpa kehe kile tadan, eri sane tadam.” Ile pe Sarai ke ipu mo-on ile ta Hagar, pe Hagar iyeu. ");
INSERT INTO ktm_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Hagar iyeu pe ilihir wo ngat hene ise lok on ke porah ndramat hosonto eriy pwi. Wo ngat erti ise ngerin sal ile Sur ea. Engel ta Lapan itureh tadan imin koson wo ngat erti, ");
INSERT INTO ktm_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","pe ipe ile tadan ihpa, “Hagar, lewen marai ta Sarai, ou owus kehe pe ka ala kehe?” Hagar ipe ile tan engel ihpa, “Yu una-au tam bos todo ke Sarai.” ");
INSERT INTO ktm_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Engel ihpa, “Ala yi pe ala ndre lewen marai tadan. ");
INSERT INTO ktm_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Yu we kuduwe papum pe tinombrum pe ombrum su we hala sulo-on, pe we homou ndramat kindranon kindrendrumon su pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Inum pe engel ipe yi ihpa, “Ou we eduwe kom ise ndrinem ti kamal, pe we eyuwen rangan kile Ismael, odosa ou emin mo-on pe Lapan ihnuwii ou. ");
INSERT INTO ktm_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Odoke nedum kamal kiti we kihir kihpa ndre donki puyep. Iy we kimpo ke pahun kile pule-e’ sa hokor pe hokor, pe sa we hompo kihpa ke eriy kile pule-en yi. Iy we kindrimin ndroda su tinton pe timso-on pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagar idawene ihpa, “Orkom, mahkele eri yu ti undroni Petngendrei pe usohou Tadan.” Ile pe iy irson rangan Lapan ndre isohou ile tadan ti “Petngendrei Iltuwei Yu.” ");
INSERT INTO ktm_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ile pe sa heneyuwen rangan wo ngat ise ndrokoron Kades pe Beret ti ile “Lapan Moren Ndre Ineltuwe Yu.” Wo ngat kurti ma ilsou. ");
INSERT INTO ktm_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ile pe Hagar iduwe nedun Abram homou kamal. Abram iyuwen rangan ile Ismael. ");
INSERT INTO ktm_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Krismas tan Abram ti kah ndrorungeh-pe-onoh, idu mundrun ndre Hagar iduwe Ismael. ");
INSERT INTO ktm_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Krismas tan Abram kah onsungoh-pe-ndrosih pe Lapan ihir ngon iy pe ipe ihpa, “Yu ti Lapan Petngendrei, petngendriyen sane ndre sulo-on. Ohrung nolou Todo. Opo sane kihrut kolwii. ");
INSERT INTO ktm_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Yu we kupu poromis kile tadam pe ou we opo poromis kile Todo, pe Yu we kuhnan nedum su hohor hala sulo-on.” ");
INSERT INTO ktm_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram pandrulku-un ile poi pe iduwe mbrulin iltu-uw ndre poi. Pe Lapan ipe ile tadan ihpa, ");
INSERT INTO ktm_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Ohrung poromis Todo ile tadam ti ihpa ndre kurti: Ou ti we ala taman kantri sulo-on. ");
INSERT INTO ktm_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Rangam Abram ti kah we kinum mahkele pe Yu we kurson rangam kile Abraham. Kuti odosa, Yu undrepandranan ou we ala tama’ sa lau odo kantri sulo-on. ");
INSERT INTO ktm_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Yu we kuhnan yayam su hohor hala sulo-on, pe su se ti we hehir hala king. ");
INSERT INTO ktm_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Poromis Todo ile tadam pe papum su ti we kindrito pe kindrito. Poromis Todo ti ihpa ndre Yu ti Lapan tadam, pe Lapan ta su papum yi. ");
INSERT INTO ktm_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Poi Kenan ou ka emin eriy kurti poye’ su lau se yi. Odoke Yu we kuduwe kile poyim, pe su papum we hemin eriy, kenon ndre lokpoi kinum. Pe Yu we Lapan ta su.” ");
INSERT INTO ktm_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Inum ti pe Lapan ipe ile tan Abraham yi ihpah, “Ou we eduwe poromis kuti ki-in kihpa ndre Yu undrupa inna tadam tih. Nedum pe papum su hemir pe hemir ndre we hehir omur ti ha-amelyen kolwii yi. ");
INSERT INTO ktm_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ou pe yayam su we adahnan kihpa ndre Yu upwe tih: oduu kamal ndre sulo-on eri we henemendrele keltun marta’ oduu ke-eu. ");
INSERT INTO ktm_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","13","Idu mahkele pe kile eri oduu we etnemendrele keltun merse-e’ sa kom mone iy ndre hentawe su tapa eriy kinto lon rang ndroruu ti, ndrodan kom mone nedu’ su ndramat lewen marai honto lenga’ oduu pe lewen marai oduu etsihnen su odo mahun ti yi. Iy kurti we kimpaniniyan kihpa ndre poromis kurti imin lenga’ toru kudu eri we kindrito pe kindrito. ");
INSERT INTO ktm_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Homou kamal ndre kindremendrele keltun merse-en pwi, eri iy ti lewi pwi, pe we hana-as iy ke-eu odosa iy indretawei indre-en indrahpa ndre Yu upwe ti pwi tih.” ");
INSERT INTO ktm_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Inum pe Lapan ipe ile tan Abraham yi ihpa, “Ou ka oyuu mbrulum ti kile Sarai kahriy. Kidu mahkele pe kile, eri ou kah oyuu iy Sarah. ");
INSERT INTO ktm_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Yu we kupu huyen kile tadan, pe iy we kiduwe nedum homou kamal. Yu we kupu blesim iy, pe iy we kile tine’ sa lau sulo-on sulo-on. Nedun su se we hala king.” ");
INSERT INTO ktm_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham ihrungi Lapan ipe nolou kuti pe iy pandrulku-un ile poi, pe iduwe mbrulin iltu-uw ndre poi. Odoke iy ideherunge pe irkei. Iy idawene ihpa, “Sa kamal krismas ta sa kah sangat ti hanon hopo kom yi? Krismas ta Sarah ti kah onsungoh, pe iy kenon kipu kom yi?” ");
INSERT INTO ktm_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Iy ipe ile ta Lapan ihpa, “Kile huyen ti Ou eduwe Ismael kisini ndruhu, kidu yu kumwet tih.” ");
INSERT INTO ktm_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Odoke Lapan ipe ile tadan ihpa, “Pwi. Mbrulum Sarah ti we kiduwe nedum homou kamal, pe ou we eyuwen rangan Aisak. Yu we kupu poromis ndrodan iy, pe poromis kuti we ta su yayan, pe we kindre-en. ");
INSERT INTO ktm_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Pe ou ehndremte ile tan Ismael tih? Yu undretahrungi ndrileng tadam. Yu we kupu blesim iy yi, pe kuduwe nedun su hohor. Iy we kile tama’ su lau kakah ndre sungoh-pe-rumuu, pe nedu’ su we hohor hala sulo-on, pe kantri ta su ti we mandra-an pe puko-on. ");
INSERT INTO ktm_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Odoke poromis ndre idu kolu, eri Yu we kuhnan ndrodan Aisak. Sarah we kiduwe Aisak ti kidu mundrun kati, odo krismas imin.” ");
INSERT INTO ktm_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Lapan ipe sane kuti ile tan Abraham inum pe iyeu. ");
INSERT INTO ktm_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Idu ke ndre rang erti pe Abraham ihnan ihpa ndre Lapan ipe ile tadan tih. Iy imndrele keltu’ su kamal ndre sulo-on. Iy imndrele keltun Ismael, su kamal lewen marai tine’ su heduwei su hodo hun Abraham, ile ndrodan ndre su kamal Abraham isihnen su odo mahun ti yi. ");
INSERT INTO ktm_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Krismas tan Abraham ti kah onsungoh-pe-ndrosih (99) idu mundrun iy imndrele keltun iyeu. ");
INSERT INTO ktm_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Pe nedun kamal Ismael ti krismas tadan sungoh-pe-toloh (13). ");
INSERT INTO ktm_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abraham pe Ismael ti hemndrele keltu’ horu idu ke ndre rang Lapan ipe ile tan Abraham. ");
INSERT INTO ktm_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Pe idu ke ndre rang erti, su kamal ndre sulo-on, su ndre tine’ su heduwe su hodo ndrongon Abraham, ndrodan ndre su lewen marai, eri hemndrele keltu’ su yi. ");
INSERT INTO ktm_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Lapan ihir ile ngon Abraham odo lon kei nembruwen odo Mamre. Lon worohnuw mandra pe mundroi issing puko-on pe iduwe mundren Abraham imbrusinget. Ile pe iy iyeu isimin pwoi odo pohnkuwen um pelei tadan. ");
INSERT INTO ktm_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Iy ipiyen madan ile ti pe indroni su lau ndre tulmuu hodo alau hepe odo ndrongon iy. Iy indroni su, eri pe ihtot ile hu su lakopwi. Ipu ruru ile ta su oh pe ");
INSERT INTO ktm_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ipe ihpa, “Oduu ke ndre il ea, pe odohndro odo kerti oh. Yu ti ummin kerti pe upwe kuhnuwii oduu. ");
INSERT INTO ktm_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Yu we kuhtekel homou ndramat pe iy we kipu wo kise pe oduu etsingen ndrike’ oduu kile eriy. Otto pahndran kei muru-un kurti pe etmiyau oh. ");
INSERT INTO ktm_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Yu kupu ana’ oduu hepe song pe otyo-on oh, kile we kipuko-on oduu odo lila-a’ oduu. Wureh taduu lakopwi odo yu uhndremte oduu pe oduu odu-us yu atsa um todo ti, ile pe yu kupoyuyoh oduu oh.” Su hahpa, “Huyen, opo kihpa ndre ou apa tih.” ");
INSERT INTO ktm_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ile pe Abraham iporitai ile lon um pelei pe ipe ile tan Sarah ihpa, “Oportai kopwi, okun sahat palawa tadam iy ndre huyen lakopwi eri pe ahnan kile bret.” ");
INSERT INTO ktm_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Inum ti pe Abraham ihtot ile pe iltakuni makau homou ma inek tapa eriy pe indritamumu-uh pe iduwe ile ta lewen marai tadan. Lewen marai ti iporitai itngwii pe ihnan ile misen. ");
INSERT INTO ktm_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Iy ikuni ndruwon song se ihpa ndre sis, po susun makau, bret, ile ndroda sengin makau misen, pe ikuni ile hu su ndramat kurtih. Abraham ide song pe su hana-an, pe iy idu eleng idu pahndran kei idu koso’ su. ");
INSERT INTO ktm_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ndre ilnum pe su hehndremte iy, “Ou mbrulum Sarah ti inna kehe?” Abraham ihpa, “Iy ilmin lon um pelei.” ");
INSERT INTO ktm_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ile pe Lapan ipe ihpa, “Kidu mundrun kerti odo krismas omur eri Yu we kuse yi, pe mbrulum ke Sarah ti we kiduwe nedum homou kamal.” Sarah ti idu ndruwen Lapan ea odo pohngkuwen um pelei pe intahrung. ");
INSERT INTO ktm_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham pe Sarah kah lopu’ horu, pe Sarah we kindranon kindropo kom pwi. ");
INSERT INTO ktm_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ile pe Sarah irkei pe iparuhur ile ke ndre tadan ihpa, “Yu kah lopu pe mundre indrekulkol pe we kupu nedu kihpa kehe? Pe mbrulu yi eri ke ihpa ke eriy.” ");
INSERT INTO ktm_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Inum ti pe Lapan ihndremte Abraham, “Ihpa kehe Sarah irkei pe ipe ihpa, ‘Yu kah lopu pe iyenon yu we kupu kom?’ ");
INSERT INTO ktm_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Handrai sa mangsan puko-on odo ta Lapan tih? Ihpa ndre Yu undrupa tih: kidu krismas omur eri Yu we kuse yi, kidu mundrun ndre Sarah we kiduwe nedun homou kamal.” ");
INSERT INTO ktm_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sarah inuh, ile pe idewehweh ihpa, “Yu undrerekei pwi.” Odoke Lapan ihpa, “Ndrendrokene, ou erkei tih.” ");
INSERT INTO ktm_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ndre ilnum pe su lau ndre tulmuu hatlang pe hala lok sehir iy ndre su we hodo eriy pe hendre-et kile pwoi kile Sodom, ile pe Abraham iyus su ipe kiltudou su kile sal. ");
INSERT INTO ktm_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ile pe Lapan idawene ihpa, “Handrai sa ndre Yu upwe kupu eri kutnguyon tan Abraham kolwii. ");
INSERT INTO ktm_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Yayan su we hohor pe hala puko-o’ su, pe kindreh hun iy, eri we Yu kupu blesim sa ndramat odo lokpoi ndre mandra-an yi. ");
INSERT INTO ktm_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Yu urih tadan ti upwe kile we iy kipunuwon nedun pe papon su pe we hantahrung Yu pe hodo omur punou huyen ta Lapan. Ipe ye su hahnan kihpa ndre eriy, eri Yu we kuhnan sane ndre sulo-on tadan kihpa ndre Yu undrupa tih.” ");
INSERT INTO ktm_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Lapan ke ipe ile tan Abraham, “Horut inna mandra ke idu lon lok Sodom pe Gomorah, pe punou mo-on pe to-ir ta su yi, eri inna mandra lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Yu we kule pwoi pe kulndre-et. Ndrendrokene ihpa ndre Yu uhrung ti ndre pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Inum ti pe horu ndramat rumuu eri harlila ile wuron Sodom, odoke Lapan ti into ndre ndrodan Abraham. ");
INSERT INTO ktm_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham inuruwe ile hu Lapan pe ihndremte ihpa, “Ou ka we ahyan su ndramat huye’ su ti kile ke ndroda su ndramat mo-o’ su tih? ");
INSERT INTO ktm_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ipe ye su limngeh (50) huye’ su, Ou we atndruwyan taon ti ndre pwi? Iyenon Ou atndruwyan taon kolwii odo ta su ndre limngeh kurti? ");
INSERT INTO ktm_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Yu tuno, sane ndre sulo-on Ou ompo ti huyen kopwi. Odoke uh, ipe ye Ou ahyan taon eri su huye’ su ti we helnget yihin to-ir ta su mo-o’ su tih. Iy erti punou huyen pwi. Ou ti jas odo lokpoi ndre mandra-an pe homosa ndre Ou opo eri kihtot ke ndre sal huyen.” ");
INSERT INTO ktm_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Lapan ihpa, “Ipe ye su limngeh huye’ su he-en Sodom, eri we Yu kundrutandruwyan taon ti pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham ihndremte yi, “Yu we mapwi kunehndremte Ou ilelih lakopwi pe Ou kihne we tawene tadam kihrut kile todo. Lapan, Mandra-an todo. Yu ti ndramat pe unosohou ke porah. ");
INSERT INTO ktm_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Odoke ipe ye su ke hangoh-pe-limuu huye’ su, Ou we atndruwyan taon ndre mandra-an ndre pwi?” Lapan ipe ihpa, “Yu we kundrahyan pwi ipe ye su hangoh-pe-limuu huye’ su he-en eriy tih.” ");
INSERT INTO ktm_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham ihndremte yi, “Pe uh ipe ye su ke hangoh kopwi?” Iy ihpa, “Ipe ye su ke hangoh eri Yu we kundrahyan taon ti pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham ihpa, “Mandra-an todo, lon ndrinem keweh kile todo, odosa yu upwe kusohou yi. We kihpa kehe ipe ye su ke tulngeh kopwi tih?” Iy ihpa, “Yu we kundrupo pwi ipe ye su ke tulngeh tih.” ");
INSERT INTO ktm_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham ihpa, “Ndrinem keweh kile todo, Lau Mandra-an, yu we mapwi kunehndremte ke Ou. Ipe ye su lau huye’ su ti rungeh holto eriy, Ou we ahyan taon ndresih?” Iy ihpa, “Yu we kundrahyan taon pwi, ipe ye Yu kutureh ke ta su rungeh tih.” ");
INSERT INTO ktm_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abraham ihpa, “Mandra-an todo, kihne we Ou lon ndrinem kinei kile todo ile pe yu upwe kusohou ke petsih koson yi. Ihpa kehe, ipe ye Ou ohtunom kihpa ndre su ke sungoh huye’ su holto eriy tih?” Iy ihpa, “Yu we kundrahyan taon odo ta su ndre sungoh ti pwi yi.” ");
INSERT INTO ktm_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Lapan isohou tan Abraham inum ti pe Iy iyeu pe Abraham iyeu ile yi ndre Mamre. ");
INSERT INTO ktm_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Horu engel ndre rumuu herihir Sodom idu pehon eriy, eri pe Lot imin pwoi odo pohon sariy ile taon odo Sodom. Horu herihir kopwi ti pe Lot iltuwe horu pe illa ile ngo horu. Iy ipu ruru ile ta horu ");
INSERT INTO ktm_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","pe ipe ihpa, “Oruu il, yu we kuhnuwii oruu. Arsa um todo. Ersingen ndrike’ oruu oh pe tidene-en. Ndromoh maping ndre lik pe ka erenelila kile yi.” Odoke horu harpa ile tadan ihpa, “Pwi, oru we ermetir ermin ndre malal kutih.” ");
INSERT INTO ktm_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Odoke Lot ihkiki-ei ile puko-on ile pe horu harla um ndrodan iy. Lot ipe ile ta su lau lewen marai tadan pe hahnan bret se yis inna lon pwi, pe hadahangi song se yi ile ndrodan. Song ile misen ti pe horu horyo-on. ");
INSERT INTO ktm_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Horu herndremetir mapwi, eri pe sa lau ndre sulo-on odo lon taon Sodom hasa pe hosokoltan um. Su eleheu pe ilto ndre su il kurou hasa ndre ilnum. ");
INSERT INTO ktm_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Inum pe su hoyuw ile ngo Lot ihpa, “Horu lau harsametir mahkele lukumwen hermin ngon ou ti herndrela ‘he? Okuni horu harsa kiu, pe odu atta mbrutle’ horu.” ");
INSERT INTO ktm_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ile pe Lot ile kiu pe ihndrepti pohngkiu ");
INSERT INTO ktm_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","pe ipe ile ta su, “Oduu tinto, otpo punou mo-on kile ta horu kolwii. ");
INSERT INTO ktm_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Yu nedu horu pihin ndre rumuu, harndrela mundren homou kamal mapwi. Horu we harsa kiu pe oduu otpo homosa kile reh taduu eri kile ta horu. Odoke horu ndramat iy ndre harsametir harsa um todo, eri we yu modo kise ta horu. Oduu otpo hangka-an kile ta horu kolwii.” ");
INSERT INTO ktm_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Odoke su Sodom hohrungi nolou kuti pe hapa ile ta Lot ihpa, “Ehpil odo sala’ odu. Ou ti yohang! Opunou odu kolwii. Owou! Pwi ti odu we otpo mo-on kile ta horu lau tadam, pe ou eri odu we adahyan ou kihmo-on lakopwi.” Pe su hotndrusuwen Lot ile yi, pe hala hapa hetpel pohngkiu. ");
INSERT INTO ktm_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Odoke horu lau hermin lon um ti horohrus ile lumwen pe horuwi iy ile ndre lon um yi pe hoduhi kuwe’ su ihndrepit. ");
INSERT INTO ktm_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Inum pe horu harahnan mada’ sa lau ndre sulo-on he-en kiu ti hehndrepit. Su hendre-et lok tahit ile pe handranon hondroltuwe madan pohngkiu pwi. ");
INSERT INTO ktm_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Horu lau ndre rumuu ti herehndremte Lot ihpa, “Ou se lewim mapwi hodo taon keti yi ndre pwi? Okuni nedum su ndre sulo-on ndroda su konsuwom pe su lau tadam se yi hodo kede eri pe atalang odo taon ketih. ");
INSERT INTO ktm_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Odosa oru ka we arahyan taon kihmo-on. Lapan indrehtunon horut mandra lakopwi ke idu lok kerti ile pe iduwe oru arsa ti odo we arahyan kihmo-on.” ");
INSERT INTO ktm_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ile pe Lot ile ngo horu lau ndre we harasuwon nedun horu pihin ndre rumuu ti pe ipe ile ta horu ihpa, “Orportai! Artalang ara-au odo ketih. Lapan ipe we kihyan taon.” Odoke horu harpa ye iy impa ile ke ndruwot. ");
INSERT INTO ktm_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Idu lirang ti pe horu engel harpa ile ta Lot ihpa, “Oportai! Okuni mbrulum pe nedum horu pihin pe atalang odo taon ketih. Kihne we atmat ndroda sa kamal pe pedih se yi.” ");
INSERT INTO ktm_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lot ihndrene hepe. Odoke Lapan ikarndrundrumwi iy, ile pe horu engel ndre rumuu lumwe’ horu ise lumwen Lot ndrodan mbrulun pe nedu’ horu pihin pe herkuni su ha-au hala kiu odo lon taon. ");
INSERT INTO ktm_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Inum pe iy homou ti ipe ihpa, “Ada-au otportai, kihne atmat. Etndre-et kise omur kolwii. Atmayau pe odohndro odo ndrolon ti kolwii yi. Ada-au atla ndre pule-en puliy eleng, pwi ti we atmat.” ");
INSERT INTO ktm_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Odoke Lot ipe ihpa, “Yoh Lapan, yu undranon kundrahnan ihpa ndre Ou apa ti pwi. ");
INSERT INTO ktm_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ou akarndrum yu pe ehnuwii yu ile mandra-an lakopwi pe okuni yu uweu odo lon horut kurtih. Odoke puliy eri hele-en alau. Kihne we yu mapwi kunohtot hepe lengan ise kiti pe hangka-an horut kurti we kisopudi yu pe yu kumwet. ");
INSERT INTO ktm_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ou onoltuwe taon lehyen ilso tih? Iy eti mukehe hepe. Eduwe yu kule ke lok ertih. Lok eti lehyen kopwi oh. Yu we kule eriy eri we kundrohrut pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Pe engel ipe ihpa, “Erti huyen, yu ti wasu-u yi. Yu we kundrahyan taon kiti pwi. ");
INSERT INTO ktm_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Otportai! Odohtot! Yu we kundrupo handrai hangka-an mapwi uu kenon ndre oduu etndrehir taon etih.” Lot ipe taon erti netlehyen, ile pe sa hoyuwen rangan ile Soar. ");
INSERT INTO ktm_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Mundroi ke inak ise eleng, pe Lot ihir ile Soar. ");
INSERT INTO ktm_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Inum ti pe Lapan ihnan pat mburten ndroda yih ile pwoi ile pule-en Sodom pe Gomorah. ");
INSERT INTO ktm_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Lapan itlumwi taon ndre ruweh ndrodan ndre ndrolon ndre mandra-an. Sa ndramat ndre sulo-on hamat, pe sane ndre sulo-on henerenge odo pule-en poi ti hamat. ");
INSERT INTO ktm_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Odoke mbrulun Lot ti indre-et ise ndre omur, ile pe Lapan iputulwen iy ihir ile odon sol pe itleklek into ndre eriy. ");
INSERT INTO ktm_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Idu maping ndre lik rang sei yi eri pe Abraham iporitai ile lok munen ndre iy horu Lapan horsohou horto eriy. ");
INSERT INTO ktm_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Iy indre-et ile pwoi ile Sodom pe Gomorah pe pule-en ndrolon ndre mandra-an, eri pe indroni ke paryah intudot odo pule-en lok. ");
INSERT INTO ktm_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Idu iy ndre Lapan ihyan taon ndre ruweh odo lok ndrolon ndre Lot imin eriy, eri iy idawonon Abraham, ile pe iduwe Lot iyeu ile lok ndre horut we kindrihir eriy pwi tih. ");
INSERT INTO ktm_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Odoke Lot inuh odo taon Soar, ile pe iy ikuni horu nedun pihin ti pe su ha-au hala puliy hala eleng pe ha-au honto pehliy sih. ");
INSERT INTO ktm_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ile pe nedun Lot tolun eri ipe ile tan iy omur ti ihpa, “Tama’ toru ke ilelih lopun pe homou kamal indrimin ye sehir lok, iy ndre we kise pe kisasuwon toru pe torpo nedu’ toru ti pwi. ");
INSERT INTO ktm_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Tortudou wain kile tadan pe iy ki-ing pe kipu sipak, eri pe toru termetir ndrodan iy kile we torpo nedu’ toru. Tarahnan kihpa kurti we yayan tama’ toru ti we kindrunum pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Idu lukumwen erti pe horu hartawe wain ile tan tama’ horu pe iy iying pe ipu sipak, ile pe iy nedun pedih tolun eri imtir ndrodan iy. Odoke iy ipu sipak ile mo-on pe indrehtunon hepe pwi. ");
INSERT INTO ktm_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ile maping sei yi ti pe iy munen ti ipe ile ye tan iy omur ti ihpa, “Pingi lukumwen eri yu umtir ndrodan iy, pe mahkele eri toru we tarahnan iy kipu sipak pe ou emtir ndrodan iy lukumwen yi. Kile we toru ndre rumuu we nedu’ toru tan tama’ toru. ");
INSERT INTO ktm_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ile pe idu lukumwen eri pe horu hartawe wain ile tan tama’ horu pe iy iying pe ipu sipak, ile pe iy pihin omur ti imtir ndrodan iy yi. Lot ipu sipak ile mo-on ile pe indrehtunon homosa horu nedun horpo ile tadan kurti pwi. ");
INSERT INTO ktm_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ile ke sal kurti pe horu kom pihin kurti harla ndriye’ horu tan tama’ horu ke Lot. ");
INSERT INTO ktm_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Pihin tolun iduwe nedum homou kamal pe iyuwen rangan ile Moap. Iy ke ile tama’ su lau hemir idu mahkele sa heneyuwen su ile Moap. ");
INSERT INTO ktm_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Pe iy nedun pihin omur ti iduwe ye nedun kamal homou yi pe iyuwen iy ile Benami. Iy ke ile tama’ su lau hemir idu mahkele sa heneyuwen su ile Amon. ");
INSERT INTO ktm_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham iyeu odo Mamre pe illa ile kup ea ile Negev pe imandro imin lok sehir ise ndrokoron Kades pe Sur. Ndre omur pe iy horu mbrulun ke Sarah hara-au ile Gerar taon. ");
INSERT INTO ktm_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Pe iy ipe ile ta sa lau odo Gerar ihpa, “Sarah eri timsu-u.” Ile pe Abimelek, king odo Gerar, ihtakalan lewen marai tadan iltakuni Sarah ise ngon iy. ");
INSERT INTO ktm_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Lukumwen sei eri pe Abimelek imih ipe Lapan ihir ile ngon iy pe ipe ihpa, “Ou ka we amat, odosa pedih ou okuni iy kudu, eri iy mbrulndrat.” ");
INSERT INTO ktm_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelek indremetir ndroda Sarah mapwi, ile pe iy ipe ihpa, “Lapan, yu ti ndramat huye! Ihpa kehe pe Ou apa we ahyan yu ndroda su lewi ndre sulo-on tih? ");
INSERT INTO ktm_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham iy ndre iy ipe horu ti timso-o’ horu horu. Pe pedih ti ipe horu ti madan timso-oi yi. Yu upu kurti ile tawene huyen pe undrehrut indrito hangka-an pwi. Upwei ye upu ke ndre punou huyen kopwi.” ");
INSERT INTO ktm_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Lapan ipe idu lon mihmih tadan ihpa, “Ehe. Yu tuno ou opo ile tawene huyen. Ile pe Yu uhndriti ou pe ou anna koson pwi, odo kile pe ou eduwe to-ir kimin modo kolwii. ");
INSERT INTO ktm_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Odoke sowin kopwi eduwe pedih kuti kile ndre ngon mbrulun yi, odosa orngon kuti iy profet, ile pe iy we kisurok kile henuwii ou, pe ou we andrimat pwi. Pe uh ou andratawe pedih mbrulun ti kinna yi pwi, eri ou we amat ndroda su lewim ndre sulo-on.” ");
INSERT INTO ktm_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimelek itlang maping ndre lik pe iyuwen su opisa tadan pe inen nolwo-on Lapan ndre sulo-on ile ta su. Pe su honoh ile mo-on lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Inum ti pe Abimilek ipe pe sa heltokai Abraham. Pe Abimilek ihndremte iy ihpa, “Ou opo punou sa ile tadu tih? Handrai sa horut yu upupu-uh ile tadam uu pe ihnan pe ou apa eduwe horut mandra-an kise puli-i pe ndromto pe lone tih? Handrai sa ndre ou opo ise todo eri mo-on kopwi. ");
INSERT INTO ktm_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Tawene tadam sa uu pe ou opo punou kitih?” ");
INSERT INTO ktm_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham ipe ihpa, “Yu unuh upwe kihne sa lau odo lok keti hesenoru-ur tam Petngendrei pwi, pe kihne su hapwi yu kumwet pe hokuni mbrulu. ");
INSERT INTO ktm_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Sarah eri timsu-u ndre ndrokene. Tama’ oru ke homou, odoke oru homou ndre tinen pe homou ndre tinen, pe yu uwosuwon iy. ");
INSERT INTO ktm_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Idu rang ndre Lapan iyuwen yu uweu odo ndrongon tomo su pe lone, pe oru aralila lok hokor ile hokor odo mahun, eri yu umpa ile ta Sarah ihpa, ‘Uh ou wasu-um yu ile mandra-an, eri hepe iy ndre toru tarla eriy, eri ou we ampa kile ta sa lau kihpa, “Abraham eri timsu-u.” ’” ");
INSERT INTO ktm_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimelek iduwe Sarah ile ndre ngon Abraham yi. Pe iy ihlingi Abraham ile sipsip, makau, pe lewen marai ke porah pedih pe kamal. ");
INSERT INTO ktm_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Pe ipe ile tan Abraham ihpa, “Endre-et, poi ndre mandra-an kuti todo. Ou apa amandro emin kehe, eri emin eriy.” ");
INSERT INTO ktm_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Pe iy ipe ile ta Sarah ihpa, “Yu kawe kuduwe silwa ndre ndralahan posungoh kile tan timsu-um, kile pe sa lau ndre sulo-on hodo ndrodan ou, eri we hohtuno sa, ou ti andrahnan hangka-an mo-on pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Lapan ihndrepti su pedih ndre sulo-on lewen Abimelek pe hondropo nedu’ su pwi. Iy ihnan ihpa kuti ile muden punou sa ndre Abimelek ipu ile ta Sarah, mbrulun Abraham. Ile pe Abraham isurok ile ngon Lapan, pe Lapan ihnan Abimelek ile ndre huyen yi. Pe mbrulun Abimelek ndroda su pedih lewen marai tadan, eri hanon hopo ndre nedu’ su yi. ");
INSERT INTO ktm_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Lapan ipu huyen ile ta Sarah ihpa ndre Iy indripa ipe Iy we kipu tih. ");
INSERT INTO ktm_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Eri pe Sarah ile ndriyen pe iduwe nedun Abraham homou kamal. Idu rang ndre Sarah iduwe nedun, eri Abraham ke inna lau nusuwon. Anah lehyen kurti heduwe iy idu ke ndre pat mundrun iy ndre Lapan ipe we heduwe iy kidu eriy tih. ");
INSERT INTO ktm_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham irson rangan ile Aisak. ");
INSERT INTO ktm_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Rang ihndre ndroruu pe Abraham imndrele keltun me-en Aisak iyeu ihpa ndre Lapan irih tih. ");
INSERT INTO ktm_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham krismas tadan ihndre puken sangat pe heduwe Aisak. ");
INSERT INTO ktm_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sarah ipe ihpa, “Lapan ke indrehlingii yu kom homou pe yu upwo-es ile eriy. Sa ndramat iy ndre hehrung eri we hopwo-es pe herkei ndroda yu.” ");
INSERT INTO ktm_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Inum oh ti pe iy ipe ye sehir yi, “Pihe ti sa lau hampa hapa yu we kundranon kundrisus homou kom pwi. Sa hapa Abraham ti mo-on lopun. Odoke yu ka undretawe nedun Abraham homou kamal.” ");
INSERT INTO ktm_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Kom kurti imndra, pe idu rang ndre iy inum sus, eri pe Abraham ihnan song mandra-an. ");
INSERT INTO ktm_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Petsih eri pe Ismael, nedun Abraham homou munen ndre ta Hagar pedih Isip, pe Aisak horompo ndruwot horso hondroh. ");
INSERT INTO ktm_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sarah indroni horu pe ipe ile tan Abraham, “Adapipan lewen marai todo Hagar pe nedun hara-au. Yu mbori horu hermin. Nedun pedih lewen marai ti we kinna taman sane tadam ti pwi. Sane tadam ndre sulo-on ti we tan nedu kopwi.” ");
INSERT INTO ktm_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Sarah isukuni nolou ti pe tawene tan Abraham ihrut ile mo-on odosa Ismael ti nedun yi. ");
INSERT INTO ktm_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Odoke Lapan ipe ile tan Abraham, “Adawene puko-on kile tang kom pe tinen ti kolwii. Ahnan kihpa ndre Sarah ipe ile tadam tih, odosa we kindreh mundren Aisak eri yayam su we hehir kihpa ndre Yu undrapandranan. ");
INSERT INTO ktm_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Yu we kuduwe su yayan Ismael eri we hohor pe we hohtungon kantri ndre sih yi. Odosa iy ti nedum yi tih.” ");
INSERT INTO ktm_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Idu maping ndre lik rang sei yi ti pe Abraham iduwe song pe wo hedehen ile lon keltun meme hosokoptii ihpa ndre ndrop ti uu pe ndre iltah. Inum oh ti pe Abraham iduwe wo pe song ile ngondrun Hagar pe idepipan Hagar horu Ismael hara-au. Hagar horu nedun hara-au pe haralila kopwi sehir ile sehir hermin lok sa ndramat hosonto eriy pwi odo Berseba. Lok erti on pe pat ke porah kopwi he-en eriy. ");
INSERT INTO ktm_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Hepe wo ke indrimin lon keltun meme ti pwi, ke indrinum ndresale, ile pe iy iduwe nedun imin ndre pahndran kei hopus ");
INSERT INTO ktm_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","pe iy illa ile mahun, alau hepe odo ndrongon nedun. Imandro imin pwoi pe intawene ihpa, “Yu kundre-et nedu kimet ti kolwii.” Imin ke ndre pwoi erti intawene, pe wayen madan irur pe ideng. ");
INSERT INTO ktm_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Lapan ihrungi anah kurti intang, ile pe engel ta Lapan isohou odo heven ile ta Hagar, “Handrai sa ihrut pe ou antawene puko-on ile eriy tih? Onoh kolwii. Lapan indrehrungi ndrelngin kom tadam tih. ");
INSERT INTO ktm_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Atlang ala pe osori iy kidu eleng pe apasi iy. Yayan su eri we hohor pe hohtungon kantri hene mandra-an.” ");
INSERT INTO ktm_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Lapan irwei ndre madan yi, pe iy indre-et ile ti pe indroni wo ngat hene. Iy illa ile pe iltehen wo ile lon keltun meme uu pe ndre iltah oh pe iduwe ile tan nedun pe nedun iying. ");
INSERT INTO ktm_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ismael inemandra eri pe Lapan immin ndrodan iy yi. Pe anah ti ine-en lok sehir on pe pat ke porah he-en eriy odo Paran. Pe iy ti ndramat homou yuhwon. ");
INSERT INTO ktm_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Tinen ikuni pedih homou odo Isip ile mbrulun. ");
INSERT INTO ktm_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Idu rang sei eri Abimelek, ndrodan Fikol ndramat ine-en munen su lewen pahun tadan ti harla pe Abimelek ipe ile tan Abraham ihpa, “Ou ompo sane ndre sulo-on eri Lapan immin ndrodan ou. ");
INSERT INTO ktm_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ile pe idu rang mahkele eri ou adamumoi kile rangan Lapan kihpa ndre ou we ondroposahi yu, nedu su pe yayo su pwi yi. Yu umpo huyen illa tadam, ile pe yu upwe ou opo huyen kile todo pe kile pule-en lok iy ndre ou ka emin eriy ti yi.” ");
INSERT INTO ktm_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham ihpa, “Yu udemumoi.” ");
INSERT INTO ktm_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Odoke Abraham ipe yi ihpa, “Su lau tadam eri hehkikiyan wo ngat todo sih. Ou adawene ihpa kehe ile eriy?” ");
INSERT INTO ktm_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelek ihpa, “Yu tuno homou ipu kirti pwi. Ou andripa hepe inna todo pwi. Yu ti uhrung tapa kurtih.” ");
INSERT INTO ktm_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ile pe Abraham ikuni sipsip se ndrodan ndre makau pe iduwei ile tan Abimelek, pe horu harta penuw. ");
INSERT INTO ktm_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Inum pe Abraham iltakuni nedun sipsip ndrukwil ndre ndrotulmuu yi pe iduwe su hoso ndre mahun, ");
INSERT INTO ktm_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ile pe Abimelek ihndremte iy, “Ou opo kirti ile sa lakopwi?” ");
INSERT INTO ktm_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham ipe ile tadan ihpa, “Ahwasu-um pe ekuni nedun sipsip ndre ndrotulmuu kurtih. Yu uhnan ihpa kudu, erti kile we ou ohtunom ihpa ndre yu, eri ndramat ndre iyeli wo ngat kurtih.” ");
INSERT INTO ktm_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ile pe lok erti heneyuwen ile Berseba, odosa horu harta penuw horto eriy. ");
INSERT INTO ktm_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ndruwen horu herehndrepti suhwo’ horu ile hondroh hermin Berseba inum ti pe Abimelek horu Fikol hara-au ile ndre Filistia yi. ");
INSERT INTO ktm_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Inum pe Abraham idohon kei he-ei rangan tamarisk idu Berseba pe iy illa eriy ilenesurok illa ndrongon Lapan Petngendrei Ndre Immin Ndrepihe Ndrekahai. ");
INSERT INTO ktm_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraham imandro imin Filistia elwe-en hepe lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Idu omur yi ti Lapan ipe kihkelmene bilip tan Abraham. Ile pe Iy iyuw, “Abraham!” Abraham ihpa, “Homosa! Yu umwin kede.” ");
INSERT INTO ktm_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Pe Lapan ipe ihpah, “Ndromoh eri okuni nedum ke ndre homou kamal ndre ou edim iy lakopwi ti pe arla Morayah. Yu we kupahran puliy sih ilso eriy kile tadam. Okuni Aisak arla eriy pe eruhe iy kimet, kinum pe etlumwi iy ndre homou kile surok tadam kise ndrongon Yu.” ");
INSERT INTO ktm_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abraham itlang maping ndre lik pe iyuwen horu lewen marai tadan rumuu ndrodan Aisak pe su hetpili yih odo tune-en yohou odo ofa, pe heduwei ile pule-en donki. Inum pe su ndre hamou halla hala Morayah. ");
INSERT INTO ktm_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Su halla rang ihndre tul ti pe Abraham indre-et ile munen pe indroni lok erti mapwi ile-en. ");
INSERT INTO ktm_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Iy ipe ile ta horu lewen marai tadan ihpah, “Ermin ndre ketih ndrodan ndre donki. Yu oru Aisak we arla ilsou. Oru arlapo lotu kinum oh pe arsa yi.” ");
INSERT INTO ktm_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham ikuni yihin ofa ndre hopus ti pe iduwe ile ndrongon Aisak, pe Aisak isorii. Pe iy ti kene-en yih inai pe semel peris. Inum pe horu horso ke hesel harla. ");
INSERT INTO ktm_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Aisak inlou ihpah, “Tomo!” Pe Abraham ipe ihpa, “Homosa, nedu?” Pe Aisak ihndremte, “Yih inai pe yih odo tune ti hodo, odoke sipsip odo ofa ti inna kehe?” ");
INSERT INTO ktm_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham ihpa, “Lapan Iy ndre Iy we kiduwei.” Ile pe horu harlila ile. ");
INSERT INTO ktm_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Lapan indrepahran puliy ndre horu we harla eriy ti inna tan Abraham munen. Horu herihir eriy, pe Abraham ikuni pat se pe ihtungon alta odo tune-en ofa. Inum pe idapanan yih ile pule-en alta. Inum oh pe Abraham ihndrusi lumwen pe ndriken Aisak, pe isori iy ile pule-en yih ise pule-en alta. ");
INSERT INTO ktm_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Inum pe iy ikuni semel pe ipe kah kilyen kile tan Aisak. ");
INSERT INTO ktm_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Odoke engel ta Lapan iyuw odo heven ihpa, “Ei, Abraham!” Abraham ihpa, “Homosa? Yu udu ketih.” ");
INSERT INTO ktm_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Pe engel ipe ihpah, “Nombrun eruhe nedum kimet. Opo yi hangka-an kile tadan kolwii. Lapan kah tunon ihpa ndre ou ti entawe Iy ine-en munen, ile pe endrehmbrusen nedum ke ndre homou odo ndrongon Iy pwi tih.” ");
INSERT INTO ktm_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham madan ile pe iltuwe sipsip kamal homou su-en ihndrepit ise ndrandran kei he-ei. Ile pe Abraham iltakunii pe iruhei imet. Iy itlumwii ndre homou ile ofa ile ngo Lapan, pe nedun ti immin. ");
INSERT INTO ktm_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ile pe Abraham iyuwen lok erti ile “Lapan Iduwei.” Mahkele ti sa ma hoyuw puliy erti ile “Puliy odo Lapan Intudou.” ");
INSERT INTO ktm_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Engel ta Lapan iyuw Abraham petsih yi odo lom parar ");
INSERT INTO ktm_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ihpah, “Abraham! Ohrung pohon Lapan. Lapan ipe ihpah, ‘Yu upu poromis pe udemumoi ile rongo, ihpa ndre ou ti we okun huyen sulo-on odo hu Yu. Ou ohrung nolou Todo pe edim inna tan nedum ke ndre homou ti pwi tih. ");
INSERT INTO ktm_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ile pe Yu upu poromis ile tadam: Yu we kuhnan pe yayam su we hohor hala sulo-on hahpa ndre pudiy hosso lom parar pe on odo ngerin ndras. Su we hopo pahun pe hohkohon lok hokor pe hokor. ");
INSERT INTO ktm_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Kantri ndre sulo-on we hehndremte hapa Yu kupu blesim su kihpa ndre Yu upu blesim yayam su tih, odosa ou ohrung nolou Todo pe ahnan ihpa ndre Yu upwe ile tadam tih.’” ");
INSERT INTO ktm_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Inum pe Abraham ile yi ndre ndroda horu lewen marai tadan, pe su ha-au hala yi ndre Berseba, pe Abraham imin eriy. ");
INSERT INTO ktm_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Isto omur yi eri pe Abraham ke ihrung ihpa ndre Milkah, mbrulun tinton ke Nahor, eri ipu kom yi. Nedun su eri ndre ndrorumuu: ");
INSERT INTO ktm_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Us eri kom ndrihou. Tinton su eri Bus, Kemwel ndre iduwe Aram tih, ");
INSERT INTO ktm_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Keset, Haso, Pildas, Jitlap, pe Betuel ");
INSERT INTO ktm_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ndre iduwe Rebekah. Milkah nedun su ndre ndrorumuu kurti tan mbrulun ke Nahor, tinton Abraham. ");
INSERT INTO ktm_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Reumah peluwen Milkah eri iduwe nedun Nahor ndre hamou yi. Ranga’ su ti Tebah, Gaham, Tahas pe Makah. ");
INSERT INTO ktm_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah imin iyenon ndre krismas puken sangat-rungeh-pe-ondrotoloh (127). ");
INSERT INTO ktm_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Iy imet imin Hebron, ise lon lok mandra-an Kenan, pe Abraham ikarndrum ile mo-on pe ideng mbrulun. ");
INSERT INTO ktm_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Inum oh ti pe Abraham itlang iyeu odo koson mbrulun pe ile ilndre-et su lau Hit, pe ipe ihpa, ");
INSERT INTO ktm_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Yu ndramat hokor yi pe umwin lenga’ oduu, use usehndremte oduu upwe kusih hombrul poi, kile we kudoni mbrulu kidu eriy.” ");
INSERT INTO ktm_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ile pe su hapa ihpa, ");
INSERT INTO ktm_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Ohrung odu lau il, ou kakah homou tadu. Odu we etpehre sih ngat odo lok kerti, kile we ou odoni mbrulum ti kile eriy. Hombrul lok iy ndre huyen lakopwi eri odu we atpahran kile tadam.” ");
INSERT INTO ktm_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham idu eleng pe ipu ruru ile ta su ");
INSERT INTO ktm_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","pe ipe ihpa, “Ipe ye ndre ndrokene oduu atpa yu we kudoni mbrulu kidu kede, eri yu uhwasu-u upwe oduu edehndremte Efron, nedun Sohar, ");
INSERT INTO ktm_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","pe kipahran pehliy Makpelah ilso mukehe ngerin lok tadan ti kise todo pe yu kusihnen. Edehndremte iy uh, pe iy ipe yu kusihnen, eri iy kidehepuse mbrunen kolwii. Oduu ede-en pe yu kuduwe rehen poi ti kile tadan kihpa ndre iy irih ti, kile we lok erti we kile ndruhun tunton ndramat todo.” ");
INSERT INTO ktm_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efron, eri iy lapan Hit pe imin ndre lenga’ su lewen hodo ndruhun sohou ise pohngkuwen siti. Ile pe iy isohou ile ndralngan ndramat ndre sulo-on ndre he-en eriy ti ihpah, ");
INSERT INTO ktm_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Ohrung lau il, we kindrehpa ndre ou ereh ti pwi. Yu we kuduwe lok ndre mandra-an ndrodan ndre pehliy. Ile pe mahkele idu madan lau ndre sulo-on todo kudu, eri yu uduwe tadam, kile we ou odoni mbrulum kile eriy.” ");
INSERT INTO ktm_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ile pe Abraham ipu ruru petsih yi ile ta su Hit ");
INSERT INTO ktm_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","pe ipe ile tan Efron, kile we sa ndramat hohrungii, “Yu uhndremte ou, ipe ye ou apahran ndre ndrokene kise todo eri yu we kusihnen pe kudoni mbrulu kile eriy.” ");
INSERT INTO ktm_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efron ihpa, ");
INSERT INTO ktm_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Ohrung oh, lau il, rehen poi eri ndralahan silwa ke hangat (400). Yu we kuduwe kile poyim. Ou esihnen kolwii. Odoni mbrulum kile eriy.” ");
INSERT INTO ktm_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Efron idu lenga’ su Hit ndre sulo-on hantahrung ti pe ipahran mbrunen poi. Abraham ihwaso-on tawene tadan, ile pe isihnen poi ti ile ndralahan silwa ndre hangat (400). Pede-en tadan ihpa ndre sa bisnis ndramat odo kalmene-en erti henesihsih ihpa eriy tih. ");
INSERT INTO ktm_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ile pe sane ndre sulo-on tan Efron he-en Makpelah, ise rai odo Mamre, eri ke ile tan Abraham. Poi ndre mandra-an ilto ndre kapetne-et, ndrodan pehliy sih pe kei ndre sulo-on he-en eriy ti Abraham ke indresihnen pe kah tadan. ");
INSERT INTO ktm_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Su Hit ndre sulo-on ndre hala sohou idu rang eriy, eri hohtuno su ihpa ndre lok eri ke inna lonen Abraham. ");
INSERT INTO ktm_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Inum ti pe Abraham idoni mbrulun ke Sarah ile lon pehliy odo Makpelah, rai odo Mamre, ise pule-en poi odo Kenan. ");
INSERT INTO ktm_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ile pe lok ta su Hit kudu eri ke ile lonen tunton ndramat tan Abraham. ");
INSERT INTO ktm_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham ke inna lopun pe krismas tadan ke indrehrukam puke sangat, pe maryan ndre sulo-on ti Lapan ihnan hala ke huyen. ");
INSERT INTO ktm_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abraham iyuwen lewen marai homou ipu marai elwe-en lakopwi imin hun iy pe madan isso sane ndre sulo-on, pe ipe ile tadan ihpa, “Eduwe lumwem kise pahndran ndrimpo pe adamumoi kile todo. ");
INSERT INTO ktm_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ou adamumoi kile rangan Lapan Petngendrei, Mandra-an odo lok eleng pe lokpoi, ihpa ndre ou we endrepondrih homou mbrulun nedu odo lok Kenan keti pwi. ");
INSERT INTO ktm_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ou ala ndre lin lone pe opondrih homou pedih odo lenga’ su ndromto, pe ekuni iy kise kesuwon Aisak.” ");
INSERT INTO ktm_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Odoke lewen marai ipe ihpa, “Uh pedih mboren pe kindru-us yu kinsa Kenan pwi, eri we kihpa kehe? Iyenon yu we kukuni nedum kile ndre lin lonem yi?” ");
INSERT INTO ktm_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham ipe ihpa, “Konan! Ou eduwe nedu kile ndre lin lone kolwii. ");
INSERT INTO ktm_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Lapan Petngendrei odo lok eleng ikuni yu uweu odo lonen tomo pe morlo-i su pe iy idemumoi ndre ndrokene ipe we kiduwe poi keti kile tan papu su. Iy ke ndre Lapan erti we kiduwe engel Tadan ki-in munen ou, pe ou we ala ndre lilin lone, kile we ou altakun homou mbrulun nedu odo ndre eriy. ");
INSERT INTO ktm_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Uh, ipe ye pedih ti kindru-us ou kinsa pwi, eri huyen. Yu we kundrehtuduwen ou kile horut tam poromis kuti pwi. Odoke we kinna ke hesel sal uu pe okuni nedu kile ti pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ile pe lewen marai tadan ke iduwe lumwen ile pahndran pan Abraham, mandra-an tadan, pe idemumoi ile tan Abraham ipe we kihnan kihpa ndre iy ipe tih. ");
INSERT INTO ktm_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Lewen marai ikuni kamel ndre sungoh ile ndroda sane longou se huyene. Pe iy illa ile taon Harran ndre Nahor imin eriy odo Mesopotemia. ");
INSERT INTO ktm_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Iy ihir ile lok ndre Nahor imin eriy ti pe iduwe su kamel hemyau hoso peltin wo ngat sih ise ngerin taon. Into pehon, mukehe mundroi illa poi, eri sa pedih halla pe helengkah wo halla eriy. ");
INSERT INTO ktm_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Iy isurok ihpa, “O Lapan Petngendrei ta mandra-an todo Abraham, ehnuwii yu odo marai ndre yu use odo eriy, pe opo huyen kile tan Abraham, mandra-an todo. ");
INSERT INTO ktm_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Yu kah unsa pe umwin peltin wo ngat iy ndre sa pedih odo taon ka we hasa pe hasikah wo tih. ");
INSERT INTO ktm_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Uh, yu kuhndremte homou pedih kihpa, ‘Ou osori wo kowek tadam kise pwoi pe yu ku-ing hepe,’ pe iy kipe kihpa, ‘Owing, yu we kupu wayen su kamel tadam yi,’ eri iy pedih eriy, eri we kile mbrulun elehwem ke Aisak. Ipe ye kihir kihpa ndre eriy, eri yu we kuhtuno ihpa ndre poromis Tadam eri Ou eduwei iyin ihpa ndre Ou apa ile tan mandra-an todo tih.” ");
INSERT INTO ktm_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Lewen marai indrinum surok mapwi ti pe Rebekah ihir. Iy ikuni wo kowek idu ngondrun. Rebekah eri taman ti Betuel, pe Betuel eri taman ti Nahor pe tinen Milkah. Nahor eri tinton ti Abraham. ");
INSERT INTO ktm_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebekah ti iy rahyen pedih, pe indre-en ndrodan kamal mapwi. Iy ile pwoi ile wo ngat pe iltehen wo oh pe ise ndre eleng yi. ");
INSERT INTO ktm_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Lewen marai tan Abraham iporitai ile hun iy pe ipe ihpa, “Oh, iyenon ou opo hepe wo kise pe yu ku-ing?” ");
INSERT INTO ktm_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Rebekah ipe ihpa, “Lau il, ewing,” pe iy iporitai isori kowek ise pwoi odo ngondrun pe indretowei ise lumwen pe iy iying. ");
INSERT INTO ktm_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Iy iying wo inum ti pe Rebekah ipe ile tadan yi ihpa, “Yu we kutou wo kile ta su kamel tadam yi, kenon ndre su he-ing kah.” ");
INSERT INTO ktm_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Inum ti pe iy iporitai itndrangan wo ile kenil pat sa ka-an heni-ing wo odo eriy, pe ihtot ile ilkah ndre wo yi. Iy impo kopwi uu iyenon ndre su kamel he-ing kah. ");
INSERT INTO ktm_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Lewen marai inehlilis Rebekah pe insohou pwi. Iy ipe kihtunon ihpa ndre marai iy inelila-an ti Lapan ihnan ile huyen ndre pwi. ");
INSERT INTO ktm_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kamel hendri-ing ndre wo kah ti pe lewen marai isini ring gol sih odo ndrongoi pe iduwe ile ndrongon Rebekah, ile ndre ndrodan nah gol ruweh pe inswi ile kendrulumwen Rebekah. Pede-en tan ring odo ndrongoi eri iyenon ndre 5 gram, pe pede-en tan nah sih sih eri iyenon ndre 100 gram. ");
INSERT INTO ktm_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Inum pe lewen marai ihndremte Rebekah ihpa, “Ou tamam si? Pe um taduu ti mandra-an iyenon yu pe su ndramat todo we otso eriy lukumwen ti ndre pwi?” ");
INSERT INTO ktm_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rebekah ipe ihpa, “Yu ti tomo Betuel. Iy ti taman Nahor pe tinen Milkah. ");
INSERT INTO ktm_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Sane mundriu anan kamel eri sulo-on hele-en um tadu, pe um eri mandra-an iyenon oduu we otso eriy yi.” ");
INSERT INTO ktm_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ile pe lewen marai tan Abraham iduwe pandrulku-un ile poi, pe palan ile iltu-uu ndre poi, pe ide urehen Lapan. ");
INSERT INTO ktm_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Iy ipe ihpa, “Lapan, yu uhposan rangam. Ou Mandra-am tan mandra-an todo, Abraham. Ou akarndrundrumwi Abraham pe opo huyen lakopwi ile tadan. Lapan, Ou eduwe yu usihir use ndre um ta lewen Abraham.” ");
INSERT INTO ktm_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ile pe enihin ti ihtot ile emwen tinen, pe inen sane ndre sulo-on. ");
INSERT INTO ktm_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Rebekah timso-on homou rangan Laban. Laban iltuwe ring odo ndrongoi idu ndrongon Rebekah, pe nah ndre ruweh idu kendrulumwen. Pe iy indrehrungi Rebekah indreninen nolou ndre sulo-on ndramat kuti ipe ile tadan tih. Ile pe iy ihtot ile kiu ile ndrongon lewen marai tan Abraham, pe indroni iy ndrodan kamel tadan ma hodo peltin wo ngat. ");
INSERT INTO ktm_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Pe Laban ipe ihpah, “Tarla um. Lapan ti indrehposon ou. Ihpa kehe pe ou odo kerti? Yu uhnan rum sih tadam ilso um pe uduwe ndruhu su kamel tadam ti ilsou yi.” ");
INSERT INTO ktm_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ile pe orngon kurti ile lon um, pe Laban isori sane hala pwoi odo pule-e’ su kamel, pe itou mundriu pe sane song ile ta su. Pe Laban ipu wo ile ta lewen marai tan Abraham ndrodan ndre su lewen odo singi ndrike’ su. ");
INSERT INTO ktm_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Inum pe su hekuni song ise, odoke lewen marai tan Abraham ipe ihpah, “Yu we kunyo-on song mapwi kenon ndre yu kundrepahran sa nolou ndre yu use odo eriy ti oh.” Laban ihpa, “Huyen. Eri ka enen oh.” ");
INSERT INTO ktm_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ile pe iy ke inen ihpa, “Yu ti lewen marai tan Abraham. ");
INSERT INTO ktm_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Lapan ipu huyen lakopwi ile tadan pe ihlingi iy sane sulo-on. Lapan ihlingi iy sipsip, meme, makau, silwa, gol, pedih pe kamal lewen marai ke porah, pe kamel pe donki sulo-on. ");
INSERT INTO ktm_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Pe mbrulun ke Sarah eri ile ndre lopun pe iduwe nedun homou kamal. Pe Abraham indretawe sane ndre sulo-on tadan inna tan kom kutih. ");
INSERT INTO ktm_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","38","Pe iy inlou puko-on ile todo ipe yu we kuhnan kihpa ndre iy ipe ile todo tih. Iy ihpah, ‘Ou we endrepondrih homou kompihin kile mbrulun nedu odo Kenan pwi. Ou we ala ndrongo’ su lewen tomo pe olpondrih homou pedih kile mbrulun nedu.’ ");
INSERT INTO ktm_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Pe yu upwe ile tan Abraham ihpa, ‘Uh, pedih mboren pe kindru-us yu pwi, eri we kihpa kehe?’ ");
INSERT INTO ktm_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Pe iy ipe ihpa, ‘Lapan ndre ine-en munen yu odo lilo-o ndre sulo-on, eri we kiduwe engel Tadan ki-us ou pe we kiduwe lila-am kihir kile ke huyen, pe ou we olkuni homou pedih odo ndre lon emwen tomo su kile mbrulun nedu. ");
INSERT INTO ktm_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Uh ou elihir ndre ndrongo’ su lewen tomo, pe su hendretawe pedih kinna tadam pwi, eri pede-en odo nolou kuti we kindresini ou pwi.’” ");
INSERT INTO ktm_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Yu uhir wo ngat mahkele ti pe usurok ihpa, ‘Lapan, Mandra-an tan mandra-an todo Abraham, ahnan marai todo yu unelila-an kurti kihir kile huyen. ");
INSERT INTO ktm_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Yu ko umwin peltin wo ngat. Uh homou kompihin kise kisikah wo, eri we yu kuhndremte iy kile wo odo ing. ");
INSERT INTO ktm_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Uh iy kipe kihpa, “Ewing pe yu kulkah wo kile ta su kamel tadam yi.” Eri, iy pedih tapa erti Ou apa we kile mbrulun nedun Abraham.’ ");
INSERT INTO ktm_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Yu mapwi unesurok idu ke lon tawene todo ti pe Rebekah isori kowek imin ngondrun pe illa ile pe iltehen wo odo ngat. Pe yu upwe ile tadan, ‘Enihin, opo hepe wo kise pe yu ku-ing.’ ");
INSERT INTO ktm_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Iy sowin kopwi ikuni wo ise pwoi odo ngondrun pe ipe ihpah, ‘Huyen, ou ewing. Yu we kutou wo kile ta su kamel tadam yi.’ Ile pe yu uwing inum oh ti pe iy itou wo ile ta su kamel todo yi. ");
INSERT INTO ktm_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Yu uhndremtan iy ihpa, ‘Ou tamam si?’ Iy ipe ihpa, ‘Yu tomo Betuel. Iy ti taman Nahor pe tinen Milkah.’ Inum pe yu uduwe ring ile ndrongon pe nah ile kendrulumwen ndre rukei. ");
INSERT INTO ktm_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Yu uduwe pandrulku-u ile poi, pe polo ile iltu-uu ndre poi, pe ude urehen Lapan, pe yu usori rangan Lapan, Mandra-an tan mandra-an todo, Abraham. Iy iduwe yu ummel use ndre lon um kamal tan Abraham pe usetureh pihin homou odo eriy we kile mbrulun nedun. ");
INSERT INTO ktm_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ile pe uh oduu etreh pe otpo huyen kile tan Abraham, eri atpa kimmel kile todo. Pe uh oduu etndrereh pwi, eri atpa kile todo yi, kile we yu kundre-et kile se sal yi.” ");
INSERT INTO ktm_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ile pe Laban horu Betuel harpa ihpah, “Lapan Iy ndre Iy iyin munen sal kurti, ile pe oru we arndrepa handrai nolou pwi. ");
INSERT INTO ktm_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebekah ti imin. Ou ekuni iy kile. Iy we kile mbrulun nedun Abraham, ihpa ndre Lapan irih tih.” ");
INSERT INTO ktm_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ndramta marai tan Abraham ihrungi nolwo-o’ su kuti, pe iy pandrulku-un ile poi, pe mbrulin iltu-uu ndre poi, pe ide urehen Lapan. ");
INSERT INTO ktm_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Inum ti pe iy ikuni silwa pe gol, pe kolos huyene pe iduwe hala ta Rebekah. Iy ingahang sane longou mbrune’ sa mandra-an ile tan timso-on pe tinen yi. ");
INSERT INTO ktm_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Inum ti pe ndramta marai tan Abraham ndroda ndre lewen su hoyo-on song, pe su hemtir hoso ndre eriy idu lukumwen ertih. Su hatlang maping ti pe ndramta marai tan Abraham ihpa, “Yu upwe kule ndre ndrongon mandra-an todo yi.” ");
INSERT INTO ktm_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Odoke tinen pe timso-on Rebekah harpa ihpa, “Eduwe Rebekah kimin ndrodan odu oh, kihpa ndre sande sih ndre pwi rang sungoh oh, kinum pe kah iy ki-us ou kile.” ");
INSERT INTO ktm_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Pe ndramta marai tan Abraham ipe ihpah, “Oduu edehndrepti yu kumwin kelau kolwii. Handrai sa ndre yu use odo eriy ti Lapan indruponunson. Yu ku-eu yi sowin.” ");
INSERT INTO ktm_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Pe su hapa ihpah, “Tidu tityuwen Rebekah pe tidehndramtan iy kile reh tadan.” ");
INSERT INTO ktm_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Su heyuwen Rebekah ise, pe hahndramtan iy ihpa, “Ou apa owus ndramat kuti ndre pwi?” Iy ihpa, “Yu we ku-us iy.” ");
INSERT INTO ktm_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ile pe su heduwe Rebekah ndrodan pedehnen marai homou, harla ndrodan ndramtan marai tan Abraham pe lewen su. ");
INSERT INTO ktm_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Pe su hapatihteh Rebekah ihpah: “Ou timso-o’ odu! Ou we ehir ala tine’ sa ndramat posungoh pe posungoh yi! Yayam su we horotawei lok kehe ndre su hopo pahun kile eriy, pe su we hohkohon sa lau pe hokuni lone’ su!” ");
INSERT INTO ktm_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Inum pe Rebekah ndroda su pedehnen hadakukuhe, pe hanak hala pule-en kamel, pe ho-us ndruwen ndramta marai tan Abraham, pe su ha-au hala Kenan. ");
INSERT INTO ktm_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Idu mundrun eti, Aisak ke indra-au odo wo ngat sa heneyuwen “Lapan Moren Ndre Ineltuwe Yu.” Pe iy ile ilmin lok sehir odo Negev. ");
INSERT INTO ktm_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Pehon sei ti iy inelila odo lok mundriu murune he-en eriy, pe indroni su kamel hapai. ");
INSERT INTO ktm_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebekah indroni Aisak eri pe iyeu ise pwoi odo pule-en kamel, ");
INSERT INTO ktm_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","pe ihndremte ndramta marai tan Abraham ihpah, “Iy si kamal inelila ipei lo tidu tih?” Ndramta marai ipe ihpa, “Iy kirti mandra-an todo tih.” Ile pe Rebekah isini kolau odo palan pe itnguyon purmadan ile eriy. ");
INSERT INTO ktm_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ndramta marai innen sane ndre sulo-on iy ihnan ti ile tan Aisak. ");
INSERT INTO ktm_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Inum pe Aisak ikuni Rebekah ile um pelei tan tinen ke Sarah, pe iyesuwon iy. Aisak waso-on Rebekah lakopwi, ile pe iy kolon ke isumwen mat tan tinen. ");
INSERT INTO ktm_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham ti iyesuwon pedih homou yi, rangan Keturah. ");
INSERT INTO ktm_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Pedih kuti iduwe Simran, Joksan, Medan, Midian, Isbak pe Suah. ");
INSERT INTO ktm_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Joksan ti tama Seba pe Dedan. Dedan ti papo’ su Asur, su Letus pe su Leum. ");
INSERT INTO ktm_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Su nedun Midian kamal ti, Efah, Efer, Hanok, Abida pe Elda. Su kom kuti hopo ndre nedu’ su ea pe hohor hala sulo-on lakopwi. Su hokou pe hokou ti hehir odo ndrayen Keturah, mbrulun Abraham omur tih. ");
INSERT INTO ktm_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham iduwe sane ndre sulo-on tadan ti ile tan Aisak. ");
INSERT INTO ktm_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Odoke Abraham indrimat mapwi eri pe iy ihngahang sane longou hala tan nedun su se yi ta horu pedih ndre iy iduwe kom ile ta horu ti yi. Inum pe iy idepipan su ha-au hala mahun odo ndrongon Aisak, hala rai ea. ");
INSERT INTO ktm_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham krismas tadan ihndre puke sangat-pe-ndrotulngeh-pe-limweh (175). ");
INSERT INTO ktm_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Iy ile ndre lopun lakopwi pe iy imet pe indra-au inna ndrongon taman pe papon su. ");
INSERT INTO ktm_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Nedun ndre rumuu, Aisak pe Ismael, hortoni iy ile pehliy odo Makpelah, ile kangahan poi hombrul rai odo lok Mamre. Pehliy kuti ise poi tan Efron, nedun Sohar kamal odo lo’ su Hit. ");
INSERT INTO ktm_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Abraham isihnen poi kuti ta su Hit. Aisak pe Ismael hertoni Abraham ile pehliy ndre Abraham idoni Sarah ile eriy. ");
INSERT INTO ktm_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ndruwen Abraham imet ti pe Lapan ipu huyen ile tan Aisak yi. Aisak ti immin mukehe wo ngat heneyuwen, “Lapan Moren Ndre Ineltuwe Yu.” ");
INSERT INTO ktm_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Iy kurti pohtidi-iy tan Ismael. Ismael eri taman ti Abraham pe tinen Hagar. Hagar ti iy pedih odo Isip pe ile ndramtan marai ta Sarah. ");
INSERT INTO ktm_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Pe ranga’ su nedun Ismael kamal, idu tolun kom pe ilto kom omur ti ihpa: Nebaiot ti tolun kom tan Ismael, pe ndruwen eri Kedar, Atbel, Mipsam, ");
INSERT INTO ktm_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Dumah, Masa, ");
INSERT INTO ktm_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadat, Tema, Jetur, Nafis pe Kedemah. ");
INSERT INTO ktm_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Su ndramat ndre sungoh-pe-rumuu kuti hala tama’ lok ndre kukuro sungoh-pe-rukur. Ranga’ lok hokor pe hokor kuti heneyuwen hala ndre pala’ ranga’ su ndramat ndre sungoh-pe-rumuu kurtih. ");
INSERT INTO ktm_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael krismas tadan ile ndre sangat-pe-tulngeh-pe-onndrotoloh (137) pe iy imet pe indra-au inna ndrongon taman pe papon su. ");
INSERT INTO ktm_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Inum ti pe su papon Ismael ti hamandro hodo poi hombrul odo lengan Havilah pe Sur, ile rai ea odo Isip, ile wuron sal ile Asiria ea. Su ndramat kuti hondronto hondroh ndroda su papon Abraham se yi ti pwi. ");
INSERT INTO ktm_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Kuti pohtidiyen Aisak, nedun Abraham. ");
INSERT INTO ktm_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisak ti krismas tadan hangoh idu iy iyesuwon Rebekah. Rebekah eri taman Betuel, ndramat homou odo Aram, ilso Mesopotemia. Pe Rebekah ti timso-on Laban. ");
INSERT INTO ktm_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Mbrulun Aisak eri indripo nedun pwi, ile pe Aisak isurok ipe Lapan kihnuwii iy. Lapan ihrungi surok tan Aisak pe Rebekah ile ndriyen. ");
INSERT INTO ktm_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Iy nedun ndrapol, pe indretawei mapwi, eri pe horu kom kurti horompo sisihi horu eri pe homou intohat iy ile ta homou hermin lon ndrinen. Ile pe Rebekah ipe ihpa, “Ihpa kehe iy kurti ihir todo?” Iy ipe kihtunon, ile pe iy ilsurok ile ta Lapan. ");
INSERT INTO ktm_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Lapan ipe ile tadan ihpa, “Kantri ruweh ka hermin lon ndrinem. Ndramat ndre rimir we herihir odo mundrem pe we herentadai ke horu. Hemir we puko-o’ su lakopwi pe we hantapelwen su hemir. Kom munen ti we kile lewen marai tan kom omur.” ");
INSERT INTO ktm_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Rang odo tudow kom ti ihir pe Rebekah iduwe kom kamal ndre rumuu ndrapol. ");
INSERT INTO ktm_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Mundren iy munen eri okuwon pe lemum mundren sulo-on. Ile pe su heduwe rangan ile Iso? ");
INSERT INTO ktm_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ndruwen Iso ihir ise moleu ti pe Rebekah iduwe ye homou. Lumwen kom omur kuti indritakorwe kambrulken Iso indrehndrepit. Ile pe su horson rangan ile Yakop? Aisak krismas tadan onngoh idu Rebekah iduwe horu. ");
INSERT INTO ktm_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Horu kom ti harmandra eri pe Iso ihir ndramat odo pondrih yohou. Iy ndramat mundren isenehwaso-on min um pwi. Pe Yakop ti innus ke iy, pe iyeu ine-en ke um. ");
INSERT INTO ktm_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisak inehwaso-on Iso, odo iy waso-on yo-on yohou Iso inerupoi, odoke Rebekah eri waso-on Yakop. ");
INSERT INTO ktm_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Rang sei eri pe Yakop intahing song pe Iso indreh ndrakei ise um. ");
INSERT INTO ktm_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Iy imet song ile mo-on pe ipe ile ta Yakop ihpa, “Yu undrumat song inna mo-on. Opo hepe song tadam rama-an ou antahing ti kise.” Iy erti uu pe sa heneyuwen rangan Iso handrai yi ti Idom? ");
INSERT INTO ktm_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakop ipe ihpa, “Huyen, ou we oyo-on, odoke we ndre apahran pe yu kusuni ndruhum kule kom ndrihou oh tih. Pwi ti we onyo-on song todo ti pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Iso ihpa, “Eri huyen. Kom ndrihou ti ngeri sa? Opo ke song kise. Yu ko umwet!” ");
INSERT INTO ktm_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakop ipe ihpa, “Eri adamumoi ki-in munen oh ihpa ndre ou we eduwe yu kusini ndruhum.” Iso idemumoi. Iy ke ndre indrepatuwen huyen tang kom tolun ti inna ta lusiyen ke Yakop. ");
INSERT INTO ktm_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Inum pe Yakop ihngahang Iso bret pe suwin pin. Iso iyo-on song pe iying suw, inum pe iy itlang iyeu. Kolon Iso ti ipei yi kom tolun ti hangka-an ke porah. ");
INSERT INTO ktm_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Petsih yi eri pe song odo Kenan inum ihpa ndre munen Abraham mapwi imin pe song inum tih. Ile pe Aisak ile taon Gerar pe ilndre-et Abimelek, king ta su Filistia. ");
INSERT INTO ktm_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Lapan ilihir ndrongon Aisak pe ipe ihpah, “Ou ala Isip kolwii. Emin ndre lok Yu upahran ile tadam katih. ");
INSERT INTO ktm_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Emin ndre keti oh. Yu we kumwin ndrodan ou pe we kupu huyen kile tadam. Poi ndre mandra-an kutih Yu we kuduwe kile tadam pe nedum papum su. Yu we kuduwei ki-in kihpa ndre poromis Yu upwe ile tan tamam ke Abraham tih. ");
INSERT INTO ktm_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Yu we kuhnan yayam su hohor kile sulo-on, kihpa ndre pudiy hoso parar, pe we kuduwe lok ndre mandra-an keti kile ta su. Ndramat odo lok ndre sulo-on we hehndremte hapa Yu kupu huyen kile ta su yi kihpa ndre Yu upu ile ta yayam su tih. ");
INSERT INTO ktm_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Yu we kupu huyen kile tadam, odosa, Abraham ihrung nolou Todo pe indrehtaran handrai punou Todo pwi tih.” ");
INSERT INTO ktm_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ile pe Aisak immin ndre taon Gerar. ");
INSERT INTO ktm_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Into sa ndramat odo taon kuti henehndremte iy illa ta Rebekah eri pe iy impa ihpa, “Kuti timsu-u.” Iy innoh, ile pe impa ipe Rebekah ti timso-on. Iy intawene ipe kihne sa heruhe iy pe hekuni Rebekah, odosa, Rebekah ti rahyen pedih lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Aisak imin eriy elwe-en lakopwi, eri pe Abimelek king ta su Filistia indre-et odo mundruk ile pwoi pe indroni Aisak pe Rebekah heresokohe horu. ");
INSERT INTO ktm_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ile pe Abimelek iduwe nolou ile hun Aisak kisendre-et iy pe iy ipe ihpa, “Yu kah tuno ihpa ndre pedih ti mbrulum. Ihpa ‘he pe ou apa iy ti timsu-um tih?” Aisak ipe ihpa, “Yu udawene ihpa ndre uh yu we kupwe mbrulu, eri sa we heruhe yu kumwet.” ");
INSERT INTO ktm_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ile pe Abimelek ipe yi ihpah, “Ou opo kirti mo-on! Lehpe kah homou ndramat ta odu kimtir ndrodan mbrulum, eri we odu odohorut, odoke ou ndre ou eduwe lin horut ise tadu.” ");
INSERT INTO ktm_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Inum pe Abimelek iduwe nolou ile lok ndre sulo-on ihpa, “Uh homou ndramat kipu hangka-an horut kile tan Aisak horu mbrulun, eri we kimet kopwi.” ");
INSERT INTO ktm_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Aisak imin lok etih pe idehe song ile poi. Pe idu ke ndre krismas erti pe sane hehwei pe sengi’ su hala mandran, eri pe iy imburi-iy. Song odo langah tadan ti ile hudut lakopwi, odosa Lapan ipu huyen ile tadan. ");
INSERT INTO ktm_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Iy lehmuyen ihur pe tadan sane sulo-on. ");
INSERT INTO ktm_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Iy tadan sipsip, makau pe lewen marai sulo-on, ile pe su Filistia hendringis pe lon ndrine’ su inei ile tadan. ");
INSERT INTO ktm_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ile pe su Filistia hekuni poi pe hendrepti wo ngat ndre sulo-on ndre Abraham indrimat mapwi pe su lewen marai tadan halii tih. ");
INSERT INTO ktm_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimelek ipe ile tan Aisak ihpa, “Owou odo lenga' odu. Ou anna puko-om lakopwi odo ndrongo odu.” ");
INSERT INTO ktm_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ile pe Aisak iyeu pe ilmandro ile ndrolon odo Gerar. ");
INSERT INTO ktm_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Abraham ihnan wo ngat se odo eriy munen, pe idu Abraham imet, eri pe su Filistia hehndrepti wo ngat kutih. Ile pe Aisak iyeli ndre su yi, pe iduwe ranga’ su hahpa ndre taman iduwe munen. ");
INSERT INTO ktm_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Rang sei, su ndramtan marai tan Aisak hali ngat sih odo ndrolon pe hetureh wo. ");
INSERT INTO ktm_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Odoke su ndramat odo Gerar ndre halla kelye-en ka-an, eri hopo loroh ile ta su ndramat ndre halla kelye-en sane ka-an tan Aisak ti pe hapa ihpah, “Wo ngat kuti tadu.” Su hopo loroh ile ta su lewen Aisak pe hehkike-ei, ile pe Aisak iyuwen wo ngat kutih ile ‘Kike-ei.’ ");
INSERT INTO ktm_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ile pe ndramtan marai tan Aisak hali wo ngat sih yi, pe loroh ihir eriy yi. Ile pe Aisak iyuwen wo ngat erti ile ‘Keles.’ ");
INSERT INTO ktm_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ndre omur Aisak su ha-au odo lok eti pe hali wo ngat sih yi. Wo ngat kuti kah homou ndramat insohou inna eriy pwi. Ile pe Aisak iyuwen wo ngat kuti ile ‘Min Ile Reh.’ Iy ihpa, “Lapan ke indretawe tidu kawe titmin kile reh ta tidu pe ka we tidihir kile huyen odo lok ketih.” ");
INSERT INTO ktm_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Omur ti pe Aisak su hatlang ha-au odo lok kurti pe hala Berseba. ");
INSERT INTO ktm_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Pe idu ke ndre lukumwen odo rang ndre su hehir Berseba, eri pe Lapan ihir ndrongon Aisak pe ipe ihpa, “Yu ti Lapan tan tamam. Nedun Abraham, onoh kolwii, odosa Yu umwin ndrodan ou. Yu we kupu blesim ou pe kuduwe yayam su hohor, odosa Yu undrupo poromisim lewen marai Todo Abraham ile eriy tih.” ");
INSERT INTO ktm_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Aisak ihnan alta odo lok kuti pe ipu lotu ile ta Lapan. Inum ti pe iy ipu ndruhun mandro-on ile lok kuti, pe ndramtan marai tadan hali wo ngat sih yi. ");
INSERT INTO ktm_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimelek indreh Gerar pe ilndre-et Aisak. Ahusat, iy ndramat odo tudou tawene ile tan Abimelek, pe Fikol, ndramat ine-en munen su lewen pahun tan Abimelek ti horu-us Abimelek yi. ");
INSERT INTO ktm_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Aisak ihndremte su ihpa, “Pihe ti oduu otpo loroh ile todo pe ada-as yu odo poiye’ oduu. Ihpa kehe pe mahkele oduu atsandre-et yu?” ");
INSERT INTO ktm_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Su hapa ihpa, “Odu odohtuno odu ihpa ndre Lapan ti imin ndrodan ou, ile pe tawene tadu ti atpa titsohou kile hondroh pe tita penuw. ");
INSERT INTO ktm_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Opo poromis kile tadu kihpa ndre ou we ondropo mo-on kinna tadu pwi, ihpa ndre odu etndrepo mo-on inna tadam pwi tih. Odu otpo huyen ile tadam pe ou owou ile huyen kopwi. Mahkele odu etndroni ihpa ndre Lapan ipu huyen ile tadam.” ");
INSERT INTO ktm_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ile pe Aisak ihnan song mandra-an pe su hoyo-on. ");
INSERT INTO ktm_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Idu maping ndre lik rang sei yi eri pe Aisak pe Abimelek harta penuw. Su kah hala kowos tadan. Inum pe su hatlang odo ndrongon iy pe ha-au yi ndrodan tawene huyen. ");
INSERT INTO ktm_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Idu ke ndre rang eti su ndramtan marai tan Aisak hasa hun iy pe hapa ile tadan ihpa, “Odu adali ngat sih pe etureh wo.” ");
INSERT INTO ktm_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ile pe Aisak iyuwen wo ngat kuti ile ‘Sibah.’ Ile pe sa heneyuwen taon ndre wo ngat kuti ise eriy ti ile Berseba. ");
INSERT INTO ktm_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Iso krismas tadan ihndre hangoh pe iy iyesuwon horu kompihin Hit rumuu. Homou eri Judit, taman Beri. Homou eri Basemat, taman ti Elon. ");
INSERT INTO ktm_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Horu haranahnan mandro-on Aisak pe Rebekah illa mangsan puko-on ndre lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Aisak kah lopun pe madan pwi. Iy iduwe nolou ile ndrongon nedun ndrihou Iso pe Iso isendre-et iy. Aisak ihpa, “Nedu?” Pe Iso ihpa, “Ihpa kehe, tomo.” ");
INSERT INTO ktm_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Aisak ihpa, “Yu kah lopu pe kihne kumwet. ");
INSERT INTO ktm_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Okuni panada tadam, ala ndrakei pe olyohou yu homou ka-an. ");
INSERT INTO ktm_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Edehing song menuhun ngongowin pe kanyan huyen ndre yu urreh, eri pe okuni kise. Yu kuyo-on kinum oh pe kusurok ou. Yu mapwi ndre kumwin eri kupatihteh ou.” ");
INSERT INTO ktm_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Idu iy ndre Aisak inesohou ile tan nedun ke Iso eri pe Rebekah ti ihrungii. Ndruwen ke Iso imur ipe kilyohou, ");
INSERT INTO ktm_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","eri pe Rebekah inen ile tan nedun ke Yakop, “Yu mahkele kopwi uhrungi tamam inehtekel Iso ihpah, ");
INSERT INTO ktm_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Olyohou yu homou ka-an pe edehngi ono. Yu kuyo-on kinum eri ka we kusurok ou kile ta Lapan, kile pe ipe ye yu kah kumwet, eri huyen.’ ");
INSERT INTO ktm_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Nedu, ohrung yu pe ahnan kihpa ndre yu kawe kupwe kile tadam. ");
INSERT INTO ktm_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ala pe olpo rumuu meme ndre harnak tapa eriy, kile we yu kudahngii pe kuhnan song ndre tamam irreh lakopwi tih. ");
INSERT INTO ktm_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Okunii kile hun iy pe iy kiyo-on kinum, pe kipatihteh ou, kile pe omur iy ipe kimet ti huyen.” ");
INSERT INTO ktm_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Odoke Yakop ipe ile tan tinen ihpa, “Ou tunom Iso eri lemlemun hutun pe yu ti pwi. ");
INSERT INTO ktm_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Kihne we tomo ti kisusurok yu pe we kitureh taheweh kurtih. Ile pe kihne yu ndre yu kuhnan pe iy kipiyen surur kile puli-i.” ");
INSERT INTO ktm_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Rebekah ihpa, “Nedu, handrai surur iy kipiyen kile puli-im eri kise puli-i. Ile pe ahnan kihpa ndre yu upwe tih. Ala pe olkuni meme ti kise.” ");
INSERT INTO ktm_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ile pe Yakop ilkuni sane ti ise, pe tinen idahngi song ile ihpa ndre taman irreh tih. ");
INSERT INTO ktm_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Inum ti pe tinen inswi kolos sih huyen tan Iso ile mundren Yakop. Kolos kurti tine’ horu ipu tan Iso, pe intakeptii imin. ");
INSERT INTO ktm_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Inum oh ti pe iy iduwe keltun meme ile petlumwen pe padawon pe ngondrun. ");
INSERT INTO ktm_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Rebekah iduwe song mbrule ile hun iy, ndrodan bret iy itlumwii kah idu. ");
INSERT INTO ktm_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Inum ti pe Yakop ile hun taman pe ipe ihpa, “Tomo.” Aisak isomwii, “Ihpa kehe? Ou si nedu kirti?” ");
INSERT INTO ktm_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakop ihpa, “Yu Iso, nedum tolun tih. Yu uhnan ihpa ndre ou apa tih. Emin eleng pe oyo-on song yu upu anam kurti, kinum oh pe ou apatihteh yu.” ");
INSERT INTO ktm_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Aisak ihpa, “Nedu, ihpa kehe pe ou opondriti sane kirti sowin kopwi tih?” Yakop ihpa, “Lapan tadam ti ihnuwii yu ile pondrih.” ");
INSERT INTO ktm_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Aisak ipe ile ta Yakop, “Iyenon ou asa lehpe kile we yu lumwe kile tadam? Ndre ndrokene, ou ti Iso?” ");
INSERT INTO ktm_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakop ile lehpe koson taman. Aisak isusurok iy pe ipe ihpa, “Kolum ti ihpa ndre kolon Yakop, odoke petlumwem eri ihpa ndre petlumwen Iso.” ");
INSERT INTO ktm_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Aisak iyeterihi Yakop, odosa iy petlumwen eri lemun hutun ihpa ndre tan Iso. Iy ipe ndre kipatihteh ndre Yakop, ");
INSERT INTO ktm_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","eri pe ihndremte ndre petsih yi, “Ndrendrokene? Ou ti Iso?” Iy ihpa, “Ewuh.” ");
INSERT INTO ktm_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Aisak ihpa, “Opo ono se yohou ti kise. Yu kuyo-on oh pe kah kupatenten kile puli-im.” Yakop iduwe song ti ile hun iy ndrodan ndre wain odo ing. ");
INSERT INTO ktm_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Taman iyo-on song ndre ilnum oh pe kah ipe ile tadan, “Asa lehpe pe ehngwi purmodo, nedu.” ");
INSERT INTO ktm_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Iy ile mukehe pe ihngwi purmadan, eri pe taman ihngwi menuhun kolos tadan, eri pe kah iy ipatenten iy. Iy ihpa, “Menuhun nedu kurti ihpa ndre menuhun hombrul lok orowon iy ndre Lapan ihnan ndrake-en ile huyen. ");
INSERT INTO ktm_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","O ya! Lapan kiduwe payiu odo parar kirur kise poi pe kihnan song kirnge odo elmwem! Lapan kihlingi ou kile song pe wain sulo-on! ");
INSERT INTO ktm_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","O ya! Lok sulo-on hala hono-on po maryam pe ndramat hopo ruruim ou. Ya! Su ndre oduu ndrai hopwil ti ou kah madam kise pule-e' su pe su ndre hehir odo tan tinem ti we hopo ruru kile tadam. O ya! Iy si ndre kitneh anam ti kihrut pe iy si ndre kipu huyen kile tadam ti Lapan kipu huyen kile tadan.” ");
INSERT INTO ktm_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aisak ipatihi Yakop inum pe, ndruwen ke iy iyeu, eri pe tinton ke Iso indreh ndrakei ise um. ");
INSERT INTO ktm_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Iy idahngi song se yi pe ikunii ile ndrongon taman. Iy ihpa, “Tomo! Emin eleng pe oyo-on se yohou yu ukuni kurti, kile we ou apatihteh yu.” ");
INSERT INTO ktm_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Aisak ihndremte, “Ou ti si?” Iso isomwii, “Yu Iso, nedum tolun tih.” ");
INSERT INTO ktm_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Aisak ihreretek ndrehomou, pe iy ihndremte, “Pe iy erti si ndre ikuni yohou pe ikunii ise ndrongo yu tih? Ndruwen ke yu uweni inum ti pe ou ehir. Yu undrapandranan huyen ndre sulo-on inna tadan, pe kah tadan ndresale.” ");
INSERT INTO ktm_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Iso ihrungii ihpa kurti pe iy ihretek ile mo-on pe idehel pe ipe ihpa, “Eri we ou apatihi yu ti yi, tomo!” ");
INSERT INTO ktm_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Aisak isomwii, “Ou tintom ise pe istawiwihi yu pe indrekuni puko-on ndre lehpe tadam tih.” ");
INSERT INTO ktm_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Iso ihpa, “Kah peruweh iy ipu kurti ile todo. Kundripa pwi ndre iy rangan Yakop. Isini ndruhu ile kom tolun oh, pe kurti iy ke indrepahno-o patihteh tan tomo ile todo yi. Tomo hangka-an yi imin ndre pwi? Eri pe apatihi kile todo.” ");
INSERT INTO ktm_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Aisak isomwii, “Yu undretawe iy we madan kise puli-im, pe undretawe murwon ndre sulo-on hanna lewen marai tadan. Yu undretawe song pe wain inna tadan yi. Ile pe handrai hangka-an indrimin odo yu we kuduwei kile tadam ti pwi!” ");
INSERT INTO ktm_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Iso ihkiki-ei taman lakopwi yi ihpah, “Puko-on ou otou ti handrai kopwi? Apatihteh yu yi, tomo!” Eri pe iy iru-iy. ");
INSERT INTO ktm_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ndre ilnum oh pe Aisak ke ipe ile tadan, “Tadam hepe payiu odo parar pwi. Sehir poyim huyen pwi. ");
INSERT INTO ktm_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ou we ompo ke pahun, odoke ou we ala lewen marai tan tintom. Pe ipe ye ou opo loroh pe orrou, eri we ehrik owou odo pahndran.” ");
INSERT INTO ktm_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Aisak iduwe puko-on inna ta Yakop, ile pe Iso ipu loroh ile mandra-an pe ihmboren tinton. Iso idawene ihpa, “Mundrun mat tan tomo ti kah mukehe. Odu adani matyan kinum ti pe yu we kurehe Yakop kimet.” ");
INSERT INTO ktm_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Odoke Rebekah ihtunon tawene tungye tan Iso, ile pe iy ipe ile ta Yakop ihpa, “Ohrung oh, tintom Iso eri ke intawene ipe we kiruhe ou amat. ");
INSERT INTO ktm_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Nedu, sa yu kupwe ti ahnan kihpa ndre eriy. Owou sowin kopwi ala ndrongon yahim ke Laban ala ndre Harran, ");
INSERT INTO ktm_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","pe elmin hun iy oh, kenon ndre loroh tan tintom kindraweh ");
INSERT INTO ktm_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","pe kolon kinsumwen handrai sa ndre ou opo ile pule-en tih. Ndre omur eri yu we kuduwe nolou kile pe ou asa yi. Kihne ou emin pe iy kiruhe ou amat, eri sa we hapwi iy kimet yi, pe yu we homou nedu pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebekah ipe ile tan Aisak, “Yu undrehpise ta horu pedih mbrulun Iso odo lok katih. Uh Yakop kesou sa homou kompihin Hit yi, eri mada, kile huyen ti yu ku-eu kumwet.” ");
INSERT INTO ktm_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Aisak iyuwen Yakop, ipwo-es iy, pe ipe ile tadan, “Okun homou pedih odo Kenan kolwii. ");
INSERT INTO ktm_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ala ndre Mesopotemia yi, lonen papum ke Betuel, pe olkun homou nedun yahim ke Laban pihin. ");
INSERT INTO ktm_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","We Lapan Mandra-an kihnuwii ou pe kipuko-on ou kile osou tadam pe we ou ala taman kom sulo-on, pe we ou ala taman lok sulo-on. ");
INSERT INTO ktm_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Iy we kipu huyen kile tadam pe su yayam, ihpa ndre Iy ipu ile tan Abraham. Lok keti Lapan iduwe ile tan Abraham ndre pihe, pe ou we asatakunii.” ");
INSERT INTO ktm_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Aisak iduwe Yakop iyeu ile hu Laban ile Mesopotemia. Laban ti timso-on Rebekah, tinen Yakop horu Iso. Laban pe Rebekah ti tama' horu Betuel, iy odo Aram. ");
INSERT INTO ktm_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Iso ihtunon ihpa ndre Aisak iduwe puko-on ile ta Yakop, pe iduwe iy indra-au inna Mesopotemia ilpondrih mbrulun. Iy ihtunon ihpa ndre Aisak ipatihi iy, pe isinip anan ipe we iy kindrasou homou pedih odo Kenan pwi. ");
INSERT INTO ktm_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Iy ihtunon ihpa ndre Yakop ihrung taman horu tinen pe indra-au inna Mesopotemia. ");
INSERT INTO ktm_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Iso ke ihtunon ihpa ndre taman eri mboren horu harasou odo Kenan. ");
INSERT INTO ktm_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ile pe iy iyeu ile ndrongon Ismael, nedun Abraham, pe iyesuwon pedih homou yi rangan Mahalat. Mahalat eri timso-on ti Nebaiot, pe tama’ horu eri Ismael. ");
INSERT INTO ktm_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakop itlang iyeu odo Berseba pe illa ile wuron Harran ea. ");
INSERT INTO ktm_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Lok ile pehon eri pe iy ihir ile lok sehir pe iyin ndre eriy. Iy ipu ndralulumwen ile pat sih pe imtir. ");
INSERT INTO ktm_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Iy imih pe indroni keserek indreh ndre pwoi uu pe inna ndre lom parar eleng, pe su engel halla eleng pe hassa pwoi odo eriy. ");
INSERT INTO ktm_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Eri pe Lapan indru idu koson pe ipe ihpa, “Yu ti Lapan, Lapan tan Abraham pe tan Aisak. Yu we kuduwe kile tadam pe yayam su lok ndre ou ka enemetir ewen eriy kurtih. ");
INSERT INTO ktm_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Yayam su we hohor kihpa ndre wahun poi. Pe su we hasarpat hala rai pe ahai, kup pe tolau. Pe tapake ou pe yayam su we adahnan pe Yu we kupu huyen kile ta sa lau ndre sulo-on odo lokpoi. ");
INSERT INTO ktm_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Antawonon, ou ala kehe ndre kehe eri Yu we kummwin ndrodan ou pe we modo kiso tadam, pe we kuduwe ou asamandro asa ndre pule-en lok kurti yi. Yu we kundra-au tadam pwi, kenon ndre Yu kundrahnan sane ndre sulo-on kihpa ndre yu undrepandranan su ile tadam tih.” ");
INSERT INTO ktm_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakop itlang pe ipe ihpa, “Lapan ti imin kerti! Iy ti imin lok kerti, odoke yu tuno hepe pwi!” ");
INSERT INTO ktm_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Iy mundren inuh ihmo-on pe ipe ihpa, “Lok kerti hono-on nuhnoh sih! Kerti we omwen Lapan! Pe iy kerti we pohngkiu ndre illa heven ti ndreh.” ");
INSERT INTO ktm_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yakop itlang maping ndre lik, ikuni pat ndre iy palan imin eriy, idotinen idu eleng pe iduwe ile kalmene-en sane ndre hehir kurtih. Inum ti pe iy itndrangan ndronun oliv ile eriy, eri pe ");
INSERT INTO ktm_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","irson rangan lok erti ile Betel. Lok rangan munen eri Lus. ");
INSERT INTO ktm_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Inum pe Yakop ipu poromis ile ta Lapan, “Uh ipe ye Ou emin ndroda yu pe madam kiso todo kile lilo-o yu unelila-an kudu, pe entudou ono song pe pulngiyen mundre ");
INSERT INTO ktm_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","uu kenon ndre yu kusihir ndre lonen tomo yi, pe hangka-an herut kindrihir todo pwi, eri we Ou ala Lapan todo. ");
INSERT INTO ktm_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Kelim ile pat ndre yu undratawei, eri we kile ndruhun surok killa ndrongon Ou. Pe sane Ou anahngahang yu, eri yu we kuntawe hondroh odo lon sungoh hondroh hondroh, killa ndre Tadam yi.” ");
INSERT INTO ktm_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakop itlang odo Betel pe illa ile wuron rai ea. Iy illa ile pe ile uu pe ");
INSERT INTO ktm_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","iy ihir ile lok ta su rai. Iy ihir mukehe wo ngat sih, pe iltuwe sipsip ndre tilmir henemetir hoso eriy. Ngat kudu eri pat sih mandra-an pe mbrewin immin madan pe su sipsip eri heni-ing wo odo ngat kurtih. ");
INSERT INTO ktm_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Sa hengkeli-iy uu kenon ndre sipsip hemir pe hemir ndre hendrihir oh, kinum pe sa ka we honurwon pat ti ke-eu. Kinum pe sa ka we hakah wo odo ngat kuti pe su sipsip he-ing. Ndre kilnum ti pe sa hongkotitye-en pat ti illa ndre ndruhun yi. ");
INSERT INTO ktm_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakop ihndremte su lau kelye-e sipsip ihpa, “Oduu tinto, oduu ti odo lok kehe?” Su hosumwi iy hahpa, “Odu Harran.” ");
INSERT INTO ktm_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Iy ihndremte, “Oduu tuno' oduu Laban ndre papon Nahor ti ndre pwi?” Su hapa ihpa, “O! Odu tuno' odu iy.” ");
INSERT INTO ktm_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Iy ihndremte, “Iy ilmin huyen kopwi?” Su hosomwii hahpa, “Iy ti ilmin huyen, hangka-an indrehrut pwi. Endre-et oh, ipei ti nedun pihin Resel ndroda sipsip tadan.” ");
INSERT INTO ktm_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakop ihpa, “Lok ti mapwi ndrokoron worohnuw mandra pe mundru’ su odo we oduu atakuni su hasa eri mapwi, kile huyen ti pe oduu otpo wo pe su he-ing oh pe atakuni su holyo-on ndre song yi.” ");
INSERT INTO ktm_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Su hosomwii, “Pwi. Isenahpa ndre ou apa ti pwi. Sipsip ndre sulo-on we ndre hansa. Kinum oh pe ka we hokotitye-en pat ke-eu pe hopo waye’ su.” ");
INSERT INTO ktm_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakop mapwi inosohou ta su ti pe, Resel ihir ndrodan ndre sipsip tan taman ke Laban. ");
INSERT INTO ktm_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakop indroni sipsip ta yahen ke Laban, ndrodan tuwen ke Resel, eri pe iy ile wo ngat, ikotitye-en pat iyeu, pe ipu waye’ su sipsip. ");
INSERT INTO ktm_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Inum ti pe iy iyahah ile won Resel, ipwo-es iy, ipu kis ile tadan pe ideng. ");
INSERT INTO ktm_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Iy ipe ile tadan ihpah, “Yu ti nino Rebekah, timso-on tamam.” Resel ihrungi ihpa kurti pe iy ihtot pe ilpa ile tan taman. ");
INSERT INTO ktm_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Pe taman ihrungi nolou ihpa ndre yahen ke Yakop ti insa, eri pe iy ihtot ile hun iy, isekohan iy, ipwo-es iy, ipu kis ile tadan, pe ikuni iy ile um. Yakop imin pwoi, pe inen sane ndre sulo-on ile ta yahen. ");
INSERT INTO ktm_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban ihpa, “Ndrendrokene lakopwi, toru ti mapwi ndrai ke hepwil.” Yakop imin eriy ndrou ndre sih. ");
INSERT INTO ktm_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban ipe ile ta Yakop ihpa, “Ou ti nedun timsu-u, odoke we ondrupo moryo ke porah pwi. Ou ereh apa yu kusih ou kihpa kehe?” ");
INSERT INTO ktm_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban nedun pihin eri rumuu. Tolun eri Leah pe lusiyen eri Resel. ");
INSERT INTO ktm_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leah purmadan eri huyen, odoke Resel eri sengin ke hendrek pe purmadan eri ilsou ndre lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakop irih ta Resel lakopwi, ile pe ipe ihpa, “Yu kupu maryam krismas kihndre ondrotoloh oh, kinum ti pe ou we eduwe Resel kile mbrulu.” ");
INSERT INTO ktm_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban ihpa, “Yu we kuduwe iy kesou ti tapa kile tadam, pe kinna ta homou yi pwi. Ile pe toru termin.” ");
INSERT INTO ktm_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yakop ipu marai krismas ndre ondrotoloh, odo kile we kikuni Resel. Odoke krismas ndre ondrotoloh erti iy iyemelyen ke rang, odosa reh tadan mandra-an eri idu ta Resel. ");
INSERT INTO ktm_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Krismas ndre ondrotoloh inum ti pe Yakop ipe ile ta Laban, “Rangen marai todo eri ke indrinum. Eduwe mbrulu kah kise, pe yu ku-in ndrodan iy.” ");
INSERT INTO ktm_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ile pe Laban ihnan sungyen osou pe sa ndramat ndre sulo-on hala. ");
INSERT INTO ktm_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Odoke idu lukumwen eriy, eri iy ikuni ye Leah ile hu Yakop, pe Yakop imtir iy. ");
INSERT INTO ktm_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban iduwe Silpah ile lewen marai tan Leah. ");
INSERT INTO ktm_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Yakop hepe indritalonan Leah idu lukumwen erti pwi uu pe isto ndre maping sei yi. Iy ile ndrongon Laban pe ipe ihpa, “Ihpa kehe pe ou opo punou kurti ise todo? Yu upu marai ti ile tan Resel. Ihpa kehe pe ou adawiwihi yu tih?” ");
INSERT INTO ktm_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban isomwii, “Iy kurti kastam odo kertih. Pihin munen we kesou ki-in munen pe pihin omur we kidu omur. ");
INSERT INTO ktm_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Rang ndre ndrodul odo osou kurti ndre kinum oh, eri we yu kuduwe Resel kile tadam yi. Yu we kuduwei kile tadam ipe ye ou opo marai todo krismas ndre ondrotoloh yi. Ou ereh erti ndre mborim?” ");
INSERT INTO ktm_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakop ihwaso-on, ile pe mundrun sungyen osou kurti ndre ilnum, eri pe Laban ke iduwe Resel ile mbrulun Yakop. ");
INSERT INTO ktm_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban iduwe Bilhah ile lewen marai tan Resel. ");
INSERT INTO ktm_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakop imtir Resel, pe iy reh tadan mandra-an lakopwi eri idu tadan. Inum pe iy ipu marai tan Laban krismas ndre ondrotoloh yi. ");
INSERT INTO ktm_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Odoke Lapan indroni ihpa ndre reh ta Yakop mandra-an eri idu tan Resel, pe Leah eri pwi. Ile pe Iy iduwe Leah ipu kom pe Resel eri indripo kom pwi. ");
INSERT INTO ktm_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leah ile ndriyen pe iduwe kom homou kamal. Iy ihpa, “Lapan indrendroni pede-en todo, ile pe mahkele, eri we mbrulu ti we kihwaso-on yu.” Ile pe iy irson rangan ile Ruben. ");
INSERT INTO ktm_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Iy ile ndriyen yi pe iduwe kom homou kamal yi. Iy ihpa, “Lapan iduwe nedu kamal homou yi kurti, odo Iy tunon ihpa ndre reh ta Yakop eri indrito todo ti pwi.” Ile pe iy irson rangan ile Simeon. ");
INSERT INTO ktm_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Iy ile ndriyen petsih yi pe iduwe kom kamal homou yi. Iy ihpa, “Mbrulu eri kawe kilipti yu lakopwi odo yu kah undretawe nedun kamal tulmuu.” Ile pe iy iduwe rangan ile Livai. ");
INSERT INTO ktm_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Inum ti pe iy ile ndriyen yi pe iduwe kom kamal homou yi. Iy ihpa, “Kah kudu, eri yu kawe kusori rangan Lapan.” Ile pe iy iduwe rangan ile Judah. Inum ti pe iy ihron tudou kom. ");
INSERT INTO ktm_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Odoke Resel eri indripo homou nedun Yakop pwi, ile pe iy ipu pelwen tinton pe ipe ile ta Yakop, “Opo nedu! Pwi ti yu we kumwet.” ");
INSERT INTO ktm_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakop londrinen inei ile ta Resel pe ipe ihpa, “Ou apa yu ti Lapan? Iy eti reh Tadan. Iy ndre Iy ihndrepti ou.” ");
INSERT INTO ktm_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Resel ihpa, “Emtir ndrodan pedehnen marai todo Bilhah, kile we iy kipu se nedu. Ile ke sal kurti we yu kule tinen su kom kutih.” ");
INSERT INTO ktm_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ile pe Resel iduwe Bilhah ile mbrulun Yakop, pe Yakop imtir iy. ");
INSERT INTO ktm_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilhah ile ndriyen pe iduwe nedun Yakop homou kamal. ");
INSERT INTO ktm_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Resel ihpa, “Lapan ihrungi surok todo pe iduwe nedu kamal homou.” Ile pe iy irson rangan ile Dan. ");
INSERT INTO ktm_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilhah ile ndriyen pe iduwe kom kamal homou yi. ");
INSERT INTO ktm_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Resel ihpa, “Yu upkwe puko-on ile pule-en tinto uu pe kah tawene todo ti indrihir sengin.” Ile pe irson rangan ile Naptali. ");
INSERT INTO ktm_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leah indre-et ihpa ndre iy ke isempo kom pwi, eri pe iy iduwe Silpah, pedehnen marai tadan ile, pe Yakop imtir iy. ");
INSERT INTO ktm_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Eri pe Silpah iduwe kom homou kamal. ");
INSERT INTO ktm_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leah ihpa, “Marngan! Yu uduwe pedehnen marai todo ile mbrulun Yakop pe yu kawe nedu sulo-on.” Eri pe iy irson kom kuti rangan ile Gat. ");
INSERT INTO ktm_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Inum ti pe Silpah iduwe kom homou yi kamal, pe ");
INSERT INTO ktm_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leah ihpa, “Yu uhposon kurti ile mandra-an lakopwi. Sa pedih kawe hampa hapa yu ti pedih odo pwo-es.” Eri pe iy iduwe rangan ile Aser. ");
INSERT INTO ktm_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Idu lo rangen et wit eri pe Ruben ile langahan tama’ su pe itureh mendrek pe ikuni ise hun tinen ke Leah. Resel ipe ile ta Leah ihpa, “Tinto, yu wasu-u se mendrek ndre nedum ikuni ise um tih.” ");
INSERT INTO ktm_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leah ihpa, “Ou okuni mbrulu ti indranon mapwi? Entakeh ye mendrek tan nedu ti ile sa yi?” Resel ihpa, “Uh ou ahngahang yu, eri we Yakop kimtir ou mahkele lukumwen.” ");
INSERT INTO ktm_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ihndre pehon eri pe Yakop indreh langahan wit ise um. Leah ilsondrih iy ile sal. Iy ihrah tadan pe ipe ihpa, “Ou we emtir ndroda yu mahkele lukumwen, odo yu unsihnen ou ile mendrek tan nedu tih.” Ile pe Yakop imtir iy idu lukumwen ertih. ");
INSERT INTO ktm_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Lapan ihrungi surok ta Leah pe iy ile ndriyen, pe iduwe kom kamal homou yi. Iy kuti ke ile ti pe nedun Yakop ta Leah ti ke ile limuu. ");
INSERT INTO ktm_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leah ihpa, “Yu uduwe pedehnen marai todo ile tam mbrulu ti Lapan ke indretawe kendrin kutih.” Ile pe iduwe rangan ile Isakar. ");
INSERT INTO ktm_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leah iduwe kom homou yi. Iy kurti ke ile ti pe nedun Yakop ta Leah ti ihir onmou. ");
INSERT INTO ktm_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Iy ihpa, “Lapan ke indratawe todo kendrin huyen. Mahkele eri mbrulu kawe kirih todo lakopwi odosa yu undretuse nedun kamal onmou.” Ile pe iy irson rangan ile Sebulun. ");
INSERT INTO ktm_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ndre omur pe iy iduwe ye kom pedih homou, pe irson rangan ile Dainah. ");
INSERT INTO ktm_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Inum pe Lapan idehorngon Resel. Iy ihrungi ndrileng tadan pe iduwe iy ke ipu kom. ");
INSERT INTO ktm_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Yakop imtir iy pe iy ile ndriyen, pe iduwe kom homou kamal. Iy ihpa, “Lapan indrahnan mah-ah todo ti indra-au.” ");
INSERT INTO ktm_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ile pe iy irson rangan nedun ti ile Yosep, pe iy ihpa, “Ea Lapan kipu homou nedu kamal yi ndreh!” ");
INSERT INTO ktm_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ndruwen Resel iduwe Yosep ti pe Yakop ipe ile ta Laban, “Ka eduwe yu ku-eu, kile we yu kule ndre lone yi. ");
INSERT INTO ktm_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Eduwe mbrulu pe nedu ti hasa pe odu ada-au. Yu unsihnen su ile marai todo ile tadam. Ou tunom ihpa ndre marai tadam yu uhnan ti mandra-an lakopwi.” ");
INSERT INTO ktm_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban ipe ile tadan, “Pwi ou owou kolwii. Ohrung oh, yu uhreh pe upondriti ihpa ndre Lapan ipu huyen ile todo odosa ou emin ndroda yu tih. ");
INSERT INTO ktm_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Apahran mbrunem pe yu kuduwei kile tadam.” ");
INSERT INTO ktm_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakop ihpa, “Ou ondrohtunom, yu upu marai tadam ile huyen pe ou ondrondroni ihpa ndre sane ka-an tadam hehir hala huyen. ");
INSERT INTO ktm_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Sane tadam pihe ti sulo-on pwi. Mehkele ti hondrohor. Lapan impo huyen ile tadam ti odosa yu umpo marai huyen. Mahkele eri kah mundrun iy ndre yu kawe kupu todo sane ndrendrakan tih.” ");
INSERT INTO ktm_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban ihndremte iy ihpa, “Ou wasu-um sa lakopwi?” Yakop ihpa, “Yu mbori kendrin. Yu we kupu marai kile lakopwi, ipe ye ou ahwasu-um tawene todo kutih. ");
INSERT INTO ktm_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Toru tuno' toru ihpa ndre sipsip sulo-on ti pere' su, pe meme sulo-on eri pode' su ndre homou. Ile pe su erti tadam. Odoke, eduwe yu kulla lenga’ su mahkele, pe kuhlite sipsip pe meme ndre mundre' su mbrulol pe pelou. Tapa iy erti yu urih upwe we kile mbrune tih. ");
INSERT INTO ktm_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Kile pe kidu omur ou asa pe esendroni sipsip pere' su pe meme pode' su hoso lon todo, eri ou tunom ihpa ndre yu eri undrepahna.” ");
INSERT INTO ktm_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban ihpa, “Huyen, we tarahnan kile kihpa ndre ou apa tih.” ");
INSERT INTO ktm_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Odoke idu rang erti pe Laban ikuni su sipsip ndre Yakop waso-on ti pe iduwe nedun su kamal mada’ su ise ta su. ");
INSERT INTO ktm_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Inum ti pe Laban iyeu ile lok sehir alau odo Harran. Iy illa rang ihndre tul pe ilihir lok kutih. Yakop eri immin, pe madan ise ta su ka-an huren ta Laban. ");
INSERT INTO ktm_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yakop ikuni ndrandran almon, popla, pe plen mantan pe ilti keltu' su hepe iyin sehir, hepe iyin sehir ile pe iduwe kalmene-en peren he-en eriy. ");
INSERT INTO ktm_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Iy iduwe ndrang kei kurti he-en purmada' su ka-an odo ndruhun ing wo ta su tih. Iy iduwe ndrang kei he-en kudu, odo su ka-an kurti heseni-ing wo eri pe hasanak ta su hosonto eriy. ");
INSERT INTO ktm_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Kurti kile we su hannak ta su eri we heneltuwe ndrang kei kuti. Ile pe uh su hopo nedu' su, eri we mundren nedu’ su ti we hehir kihpa ndre iy ide kalmene-en ndrandran kei tih. ");
INSERT INTO ktm_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakop itsarpadan nedun sipsip pe meme he-en ndre mahun pe iduwe su mada' su ile wuron su ka-an ta Laban iy ndre mundre' su ile rer he-en eriy ea tih. Ile pe into su hannak ta su, eri pe nedu' su ti hehhir halla kala ndre Yakop waso-on tih. Tapake sal kurti pe iy ile taman meme pe sipsip sulo-on. Pe iduwe su he-en ndre mahun odo lo' su iy ndre ta Laban. ");
INSERT INTO ktm_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Into ndrowe' su ka-an ndrukwil eri pe Yakop intawe ndrandran kei kudu eri into mada' su iy ndre mandra' su pe handritamumu-uh tih. Su hannak ta su ti pe henendroni ndrang kei kurtih. ");
INSERT INTO ktm_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Odoke into iy ndre su ka-an ndre hendriring pe puko-o’ su pwi ti hannak ta su eri pe iy isempo punou kurti pwi. Ile pe Laban tadan ndre sulo-on eri hendriring pe puko-o’ su pwi pe ta Yakop eri hala mandra-a’ su pe puko-o’ su. ");
INSERT INTO ktm_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ile ke sal kurti pe Yakop ile taman sane sulo-on. Iy tadan sipsip, tadan meme, tadan kamel pe donki, pe tadan lewen marai. ");
INSERT INTO ktm_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakop ihrung ihpa ndre kayon su eri hampa ihpa, “Yakop ti indrekuni sane huyen tan tama’ tidu indrinum. Iy ikuni sane tan tama’ tidu pe ihnan tadan ihur ile sulo-on odo eriy.” ");
INSERT INTO ktm_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Iy itlonan ihpa ndre huyen ta yinan munen illa tadan eri ke indrinum. ");
INSERT INTO ktm_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Inum ti pe Lapan ipe ile tadan ihpa, “Ala ndre lonen tamam su yi. Ala ndre ndrongo su murwom. Yu we kumwin ndrodan ou.” ");
INSERT INTO ktm_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ile pe Yakop imin ndroda su sipsip pe meme tadan pe iduwe nolou ile ndrongon mbrulun horu pe horu harla ndrongon iy. ");
INSERT INTO ktm_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Iy ipe ile ta horu ihpa, “Yu undrendroni ihpa ndre tama' oruu eri huyen tadan pihe eri ile handrai, pe mahkele eri ke inna handrai yi. Odoke Lapan tan tomo eri imin ndroda yu. ");
INSERT INTO ktm_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Oruu tuno' oruu ihpa ndre yu upu maryan tama' oruu, eri ile puko-on todo ndre sulo-on. ");
INSERT INTO ktm_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Odoke iy idewiwihi yu. Iy isentawe indre-en ihpa ndre oru orpunou ti pwi. Iy isentawe kendrin marai todo ti isenemimel pwi. “Odoke Lapan ihnan taheweh tadan ti indrila hangka-an ke porah. ");
INSERT INTO ktm_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Idu munen eri tama' oruu ti ipe ihpah, ‘Meme hopo nedu' su pe mundre' su mbrulol, iy erti we mbrunem.’ Eri pe meme hetyen ti pe nedu' su ti mbrulol kopwi. Inum ti pe iy ipe ihpa yi kurti, ‘Meme iy ndre mundre' su ile rer, iy eti we mbrunem.’ Eri pe meme ndre sulo-on hopo nedu' su ti pe mundre' su halla ke rer. ");
INSERT INTO ktm_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ile pe Lapan Iy ndre Iy iduwe su ka-an tan tama' oruu kuti hasa todo. ");
INSERT INTO ktm_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Idu mundrun ndrowe’ su eri pe yu umih, pe undronii upwe ye meme kamal ndre hannak ta su meme ndrukwil eri mundre' su pelou pe karkarat. ");
INSERT INTO ktm_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Engel ta Lapan isohou ile todo idu lon mihmih kuti ihpa, ‘Yakop!’ Pe yu usomwii uhpa, ‘Ah?’ ");
INSERT INTO ktm_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Pe iy ipe ihpa, ‘Endre-et oh, meme kamal ndre sulo-on hanak ta su meme ndrukwil eri pelou pe karkarat kopwi. Yu uhnan kurti ihir odosa Yu undrendroni sane punou ndre sulo-on ndre Laban ke impupu-uh ile puli-im. ");
INSERT INTO ktm_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Yu ti Lapan ndre uhir ile hun ou odo Betel, lok ndre ou okuni pat sih pe atrangan ndronun oliv ile pule-en, pe opo poromis ile Todo tih. Mahkele kopwi adakukohon tadam sane pe ala ndre lok heduwe ou odo eriy.’” ");
INSERT INTO ktm_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Resel pe Leah herreh ile nolou ta Yakop pe harpa ihpa, “Tama’ oru ti we kiduwe taru sa? Oru taru handrai hangka-an indrimin ndrongon tama’ oru ti pwi. ");
INSERT INTO ktm_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Iy inendre-et oru ihpa ndre ndramat ndru-ei. Iy iduwe oru ise tadam pe ou esihnen oru, pe mbrune’ oru eri iy indrepiyen indrinum pe ke indrepatuwen oru arndre-au odo mundren. ");
INSERT INTO ktm_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Sane ndre sulo-on ndre Lapan ikunii odo ndrongon tama’ oru pe iduwe ile tadam eri kah taru pe su nedu’ oru. Handrai sa ndre Lapan ipe ile tadam eri eduwei ki-in kihpa ndre eriy.” ");
INSERT INTO ktm_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Ile pe Yakop idekukuhon tadan sane ndre sulo-on ndre iy imin Mesopotemia pe ikunii ti, pe iyeu ile ndre ndrongon taman ke Aisak ile Kenan. Iy iduwe mbrulun pe nedun su hala pule-en kamel. Su sipsip pe meme tadan ti he-en mune pe su ndramat hodo omur, pe su ha-au. ");
INSERT INTO ktm_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laban mapwi indra-au inandro-or lemlemun sipsip, pe Resel ile um pe ipahno-o lapan se tan taman. ");
INSERT INTO ktm_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakop ke ipe ke-eu ti pe indripa hepe ile ta Laban pwi. ");
INSERT INTO ktm_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Iy ikuni tadan sane ndre sulo-on pe ipuraprap kopwi iyeu. Iy ihrukam wo Yufretis pe ilila ile lok puliy odo Gileat ea. ");
INSERT INTO ktm_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Rang ihndre tul pe Laban ihrung ihpa ndre Yakop eri ikotip indra-au. ");
INSERT INTO ktm_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Iy ikuni su ndramtan pe hodo omur ta Yakop. Rang ihndre ndrodul pe su hosopudi iy odo lok puliy odo Gileat. ");
INSERT INTO ktm_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","25","Yakop su heduwe ndruhu mandro ta su ise Gileat, ile pe Laban su lewen eri he-en eriy yi. Odoke idu lukumwen erti pe Laban imih ipe yi Lapan ihir ndrongon iy pe ipe ihpa, “Omburtou! Opo handrai punou kile ta Yakop kolwii.” ");
INSERT INTO ktm_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ile pe Laban ile ndrongo Yakop pe ipe ile tadan ihpa, “Ihpa kehe ou otong todo pe okuni nedu horu ihpa ndre pedih sa hekuni odo lon pahun tih? ");
INSERT INTO ktm_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Ihpa kehe pe ou oportai okotip owou tih? Hepe andripa inna todo pwi. Lehpe ou andripa kinna todo, eri au tadam ti lehpe yu kuhposon kile weryen tamborin pe kita. ");
INSERT INTO ktm_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ou ahnan pe yu undropwo-es pe undruhung purmadan papu pe nedu horu pwi. Ou opo punou kudu eri mo-on lakopwi! ");
INSERT INTO ktm_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Yu uwonon lehpe kupu handrai punou kile puli-im, odoke pingi lukumwen eri pe Lapan tan tamam ipe ile todo ipe we yu kundrupo handrai ndre handrai kinna puli-im pwi. ");
INSERT INTO ktm_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Yu tuno, ou tawene tadam mandra-an ti apa owou ala yi ndre lonem tih. Odoke ihpa kehe pe ou apahno-o lapan todo se odo lon omwe tih?” ");
INSERT INTO ktm_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakop isomwi iy ihpah, “Yu unuh, upwe kihne ou okuni nedum horu odo ndrongo yu. ");
INSERT INTO ktm_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Odoke uh, ou opondriti homou odo lenga' odu ikuni se lapan tadam ndre ou ampa, eri we horuhe iy kimet. Mahkele eri we ndramtam pe ndromto hala kelye-e toru, pe ou oturtur lon sane ndre sulo-on. Pe uh ou otureh handrai sa iy ndre tadam, eri okunii yi.” Yakop tunon hepe Resel ipahno-o lapan se ta Laban ti pwi. ");
INSERT INTO ktm_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban ile pe ihreh odo pandrol kandis ta Yakop. Inum pe iy ile yi pandrol ta su pedih pe ihreh odo hu Leah odoke indretureh pwi. Iy iturtur odo ndrongo horu pedehnen marai ta Leah horu Resel pe indretureh pwi yi. Inum ti pe iy ile pandrol tan Resel pe ilhereh. ");
INSERT INTO ktm_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Resel ikuni lapan tan taman eri pe iduwe ile lon sedel pek, pe imandro imin pule-en. Laban ihreh odo lon pandrol kandis odoke indropondriti su pwi. ");
INSERT INTO ktm_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Resel ipe ile tan taman ihpa, “Nombrun opo loroh kile todo, tomo. Yu we kundranon kundruto eleng kundruto purmadam pwi. Yu ko untakun sik ndrou todo tih.” Laban ihrihi lok inum, odoke indretureh homou lapan tadan ti pwi. ");
INSERT INTO ktm_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yakop londrinen inei pe ihrurute ihpa, “Yu uhrut odo homosa lakopwi? Handrai sa mo-on yu upu uu pe ou esepondrih yu ile pondrih tih? ");
INSERT INTO ktm_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ou ehrihi lon omwe inum, pe etureh handrai hangka-an yu ukunii odo lon omwem ti ndre pwi? Uh ou etureh eri eduwei kise moleu kurti, kile we su ndramat tadam pe todo heltuwei, pe hohtuno su ihpa ndre toru si intaheweh. ");
INSERT INTO ktm_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Yu umwin ndrongon ou krismas puke rungeh, eri pe unyo-on homou sipsip kamal tadam pwi. Sipsip pe meme tadam hompo nedu su ti pe hangka-an herut indrihir ta su pwi. ");
INSERT INTO ktm_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Handrai hangka-an kihpwi, kidu meseren ndre lukumwen eri ou anahkikiyan yu pe yu unesihnen. Into iy ndre ka-an puyep honorpo sipsip tadam, eri yu ndre yu umpo muden. Yu usentakuni su pe useneliligan hesela tadam pwi, iy erti uu pe ou enehtuduwen yu ile sane ka-an honohpwi tih. ");
INSERT INTO ktm_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Rang sulo-on eri pe mundroi inesingi yu into meseren, pe into lukumwen eri yu ummin ke kiu pe unerir illa mo-on, pe hepe metir indrella modo pwi. ");
INSERT INTO ktm_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Krismas ndre rungeh yu umwin ndrongon ou ti inehpa ke kutih. Krismas sungoh-pe-hahuu yu upu marai ile mbrunen nedum horu eri pe inahpa ke kurtih. Krismas onoh yi yu modo ise sane ka-an tadam eri pe inehpa ke eriy. Idu ke ndre erti isto mahkele, eri ou ompotulwen ke mbrune. ");
INSERT INTO ktm_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Lehpe Lapan tan tomo su, tan Abraham pe Aisak, kisemin ndrongo yu pwi, eri ou lehpe endretawe yu kundra-au rukei ke lumwe. Odoke Lapan indrendroni pede-en todo pe marai yu undrahnan, ile pe pingi lukumwen eri Iy indripaninyan huyen pe mo-on ti inna tadam.” ");
INSERT INTO ktm_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban isomwi Yakop ihpa, “Horu kompihin kurti nedu, su netnedu’ horu eri papu, pe su ka-an kurti todo. Ndrendrokene tadan, eri sane ndre sulo-on ou enendroni he-en kiti todo kopwi. Odoke mahkele eri yu we kundranon kundrupo handrai hangka-an pwi. Yu we kundrehndrepti nedu horu ndrodan ndre papu su eri pwi. ");
INSERT INTO ktm_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Mahkele eri yu upwe toru tarla sih tawene, pe tartaparngan pat kile kalmene-en.” ");
INSERT INTO ktm_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ile pe Yakop ikuni pat sih pe idotinen ile kalmene-en horu. ");
INSERT INTO ktm_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Pe iy ipe ile ta su ndramat tadan pe hedihi pat hondroh yi. Inum oh pe lewen Laban pe Yakop ndre sulo-on hoyo-on song he-en koson pat kurtih. ");
INSERT INTO ktm_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban irson rangan lok kurti ile Jegar Sahaduta, pe Yakop irson rangan lok kurti ile Galet. ");
INSERT INTO ktm_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban ipe ile ta Yakop ihpa, “Kelim pat kurti we kihnan pe toru we tarantawonon penuw ta toru kurtih.” Iy eti uu pe heneyuwen lok eti ile Galet tih. ");
INSERT INTO ktm_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Laban ipe yi ihpa, “Kile we toru tarsarpat ti Lapan madan kiso ta toru, iy si kitparan poromis tatoru tih.” Ile pe lok kurti rangan handrai yi ti Mispah. ");
INSERT INTO ktm_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Laban ipe nolou sehir yi ihpa, “Ipe ye ou olpo mo-on kile ta horu nedu pedih, pe ipe ye ou alasuwon homou pedih yi, eri yu we tuno pwi, odoke antawonon ihpa ndre Lapan eri inendroni toru. ");
INSERT INTO ktm_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Pat yu utparangan iyin lenga' toru ti kurti, pe iy kurti pat ou elyen tih. ");
INSERT INTO ktm_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ndre rundrei kurti, pat yu udihii pe pat ou elyen eri tarantawonon. Yu we kundrahrukam pat yu udihii kurti pe kunapo pahun kinna puli-im pwi ndre pwi. Ou eri ihpa ke eriy, we andrahrukam pat ou elyen pe ansapo pahun kinsa puli-i ti pwi yi. ");
INSERT INTO ktm_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Kile we Lapan tan Abraham, pe Lapan tan Nahor, we horposisihi lenga’ toru.” Ile pe Yakop iru-ur ile sohou imin lenga' horu kuti pe ipu poromis ile ta Lapan Iy ndre taman ke Aisak inesurok ile Tadan tih. ");
INSERT INTO ktm_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Iy iruhei ka-an homou, pe iduwei ile surko' su hodo pule-en puliy, pe itparangan su lewen hala ke hondroh. Su hoyo-on song inum pe hemtir hoso ndre pule-en puliy lukumwen ndre sei ertih. ");
INSERT INTO ktm_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Maping ndre lik ti pe Laban ihngwi purmadan papon su pe nedun horu, inum pe iy ipatihteh su. Inum oh pe iy iyeu ile ndre lonen yi. ");
INSERT INTO ktm_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakop pe su lewen ka henelila sal ile, eri pe engel se hahrah tadan. ");
INSERT INTO ktm_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Iy indroni su, pe ipe ihpa, “Kurti kotilen Lapan,” ile pe iy iduwe rangan lok erti ile Mahanaim. ");
INSERT INTO ktm_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakop iduwe ndramat tadan odo takun nolou eri hala munen, hala ndrongon tinton ke Iso hala Seir. Seir eri ise lon lok mandra-an Idom. ");
INSERT INTO ktm_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Iy ipe ile ta su ipe we su halpa kile tan Iso eri we kihpa ndre kurti, “Mandra-an todo Iso, yu Yakop, lewen marai tadam, uduwe nolou ise ndrongon ou ihpa ndre yu umwin ndrongo Laban uu pe ko use tapa kutih. ");
INSERT INTO ktm_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Yu todo makau, donki, sipsip, meme pe lewen marai kamal pe pedih. Yu uduwe nolou ise ndrongon ou, mandra-an todo, upwe ou ndrinem keweh kile todo.” ");
INSERT INTO ktm_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ndramat odo takun nolou ti hasa ndre ndrongo Yakop yi, pe hapa ihpa, “Odu atla ndrongon Iso, eri pe iy isondrih ou insa sal. Iy ndroda lewen su kamal ndre hangat.” ");
INSERT INTO ktm_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakop inuh ile mo-on pe idawene hutun. Ile pe iy itlangan lewen marai tadan eri ile rimir. Su sipsip, meme, makau pe kamel tadan ti iy itlangan su hala rimir yi. ");
INSERT INTO ktm_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Iy idawene ihpa, “Ipe ye Iso kise pe kipu pahun kile ta su ndramat hemir iy ndre he-en munen, eri su iy ndre hodo omur ti we hohtot ha-au.” ");
INSERT INTO ktm_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Inum ti pe Yakop isurok ihpah, “Lapan tan papu Abraham pe tan tomo Aisak, ehrung yu! Lapan, Ou apa ile todo apa yu kule yi ndre lone pe ndrongo morlo-i su, pe apa we ahnan sane todo ndre sulo-on kile ke huyen. ");
INSERT INTO ktm_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Yu lewen marai Tadam, yu ndramat mo-o, undranon iy ndre huyen pe karundrum tadam ile todo ti pwi. Yu uhndor wo Yordan ule hodoh ule Harran ti todo hangka-an pwi, he-ei ke kendro ise lumwe. Yu use yi mehkele ndrodan ndre lewi rimir. ");
INSERT INTO ktm_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Yu usurok upwe Lapan, Ou ehnuwii yu, kihne Iso kise pe kipu handrai punou kile puli-i. Yu undrunoh. Iy ipei ti kihne we kispo pahun pe kiruhe odu ndre sulo-on, ndrodan ndre su pedih pe kom mone. ");
INSERT INTO ktm_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Antawonon iy ndre Ou apandranan ile todo tih? Ou apa we ahnan sane todo ndre sulo-on kile ke huyen pe apa we yayan nedu pe papu su we hohor hala sulo-on, hahpa ndre on he-en ngerin ndras, pe homou we kindranon kindrendrumon su pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","15","Yakop imtir lukumwen sei iyin lok iy isurok odo eriy kutih. Iy itlang maping ti pe ihlite sane ka-an tadan se. Sane iy ihlitei kuti hangahang tadan ile tan tinton ke Iso. Sane iy ipu tan tinton eri meme ndrukwil runget pe meme kamal rungeh, sipsip ndrukwil runget pe sipsip kamal rungeh, kamel ndrukwil tulngeh ndre nedu’ su mapwi hossus, makau ndrukwil hangoh pe makau kamal sungoh, pe donki ndrukwil rungeh pe donki kamal sungoh. ");
INSERT INTO ktm_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Iy itparan su ka-an kurti ile ndre limmir. Handrai hoso ndre ndrakan odo ta handrai. Iy iduwe meme hala sehir, sipsip hala sehir, kamel hala sehir, makau hala sehir pe donki hala sehir. Inum oh pe iduwe ndramtan ndre limuu mada’ su ise ta su ka-an ndre limmir kutih, pe iy ipe ile ta su ihpa, “Atla munen, pe atawe reu ki-in lenga’ ndramat iyin munen pe ndramat idu ndruwen. Oduu otto omur ti etawe reu ki-in ndrokoro’ oduu kihpa ke eriy, nombrun otso ke hopus.” ");
INSERT INTO ktm_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Iy ipe ile tan ndramat ndre we ki-in munen ti ihpa, “Ala uu pe ahrah tan Iso pe iy kihndremte ou kihpa, ‘Mandra-an tadam ti si pe ou apa ala kehe? Sane ka-an ou okunii kurti ta si?’ ");
INSERT INTO ktm_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Eri pe ou apa kihpa, ‘Sane ta Yakop, ndramat lewen marai tadam tih. Iy ipu tan Iso pe yu ukuni hasa munen. Iy eri mapwi ipei omur.’” ");
INSERT INTO ktm_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Iy ipaninyan ile ta su ndramtan ndre limuu ndre mada' su ise ta su ka-an ndre limmir ti ihpa, “Nolou kudu eri we oduu atpa kile tan Iso ipe ye oduu adahrah tadan tih. ");
INSERT INTO ktm_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ada-amelyen kolwii. Atpa kile tadan kihpa, ‘Yakop lewen marai tadam eri mapwi ipei omur.’” Yakop idawene ihpa, “Yu we kuduwe sane ka-an kuti hala tadan ti we kiduwe tawene tadan keweh kile todo, pe uh yu kuhrah tadan eri we iy kipu huyen kile todo.” ");
INSERT INTO ktm_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Iy iduwe sane ka-an iy ipu tan Iso ti hala munen, pe iy ti imtir iyin ndre Mahanaim. ");
INSERT INTO ktm_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Idu ke ndre lukumwen erti pe Yakop itlang pe ikuni mbrulun ndre rumuu, horu pedih lewen marai ta Resel pe Leah, su nedun ndre sungoh-pe-homou pe hohntor wo Jabok hala hodoh. ");
INSERT INTO ktm_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Inum ti pe iy iyeu ile ndre hodoh pe ihtakalan su ndramat tadan hokuni sane tadan hala hodoh, ");
INSERT INTO ktm_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","pe iy ke ndre homou iyeu imin hodoh. Eri pe orngon homou ihir ile ndrongon iy pe horu hernehmundre kopwi uu pe lok ndre iltanga-ar. ");
INSERT INTO ktm_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ndramat kurti indre-et ihpa ndre iy kindranon kindroruson Yakop pwi, ile pe iy irson hangka-an ile pursuwyon Yakop, pe pursuwyon itluhu. ");
INSERT INTO ktm_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ndramat kurti ipe ihpa, “Ohron lumwem todo, pe yu ku-eu. Lok ilelih meseren.” Yakop ihpa, “Eri ou apatihteh yu ki-in munen oh, pwi ti yu we kundrehron lumwe ki-eu odo tadam pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ndramat kurti ihndremte ihpa, “Ou rangam ti si?” Pe Yakop ihpah, “Yu rongo Yakop.” ");
INSERT INTO ktm_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ndramat kurti ihpa, “Rangam ti we Yakop pwi yi. Ou opkwe ile ndroda Lapan pe ndramat kah, odoke ou ewen ndre pule-en ea, ile pe rangam eri ka we kile Israel.” ");
INSERT INTO ktm_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakop ihpa, “Apahran rangam ti kile todo yi!” Odoke ndramat kuti ihpa, “Ou apa ohtunom rongo ti kile sa?” Inum ti pe iy ipatihteh Yakop. ");
INSERT INTO ktm_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Inum pe Yakop ihpa, “Yu undroni Lapan ile modo, odoke yu undrimat pwi.” Ile pe iy irson rangan lok ile Peniel. ");
INSERT INTO ktm_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Mundroi ise ndre eleng pe Yakop illa iyeu odo Peniel. Iy inelila inehndrum odosa pursuwyon ti indretuluhu tih. ");
INSERT INTO ktm_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Idu pihe uu pe isto mahkele eri su yayan Israel eri hasana-an pursuwyon sane ka-an ti pwi, odosa Lapan idahat hangka-an idu pursuwyon Yakop pe itluhu tih. ");
INSERT INTO ktm_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakop ipiyen madan ile munen ti pe indroni Iso ndroda lewen su ndre hangat. Ile pe iy itlengan nedun su eri hala ndre ndrongon tine' su ea. ");
INSERT INTO ktm_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Inum oh ti pe iy iposisihi su. Horu pedih lewen marai here-en munen ndrodan nedu’ horu, inum oh ti pe Leah ndrodan nedun su, inum pe Resel horu nedun ke Yosep horto ndre omur. ");
INSERT INTO ktm_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Inum oh ti pe Yakop ihngah ile munen. Iy ile ndre mukehe ti pe iduwe pandrulku-un ile poi pe ipu ruru ile tan tinton ke Iso ih ndre pat ondrotoloh. ");
INSERT INTO ktm_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Odoke Iso indroni iy pe ihtot ile pe isekohan iy pe ihungi purmadan, pe horu ndre rumuu hartang. ");
INSERT INTO ktm_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Hartang horu inum ti pe Iso indroni su pedih ndrodan ndre kom mone, pe iy ihndremte, “Sa ndramat kehe ndre hasa ndrodan ou kurtih?” Yakop ihpa, “Mandra-an todo, he-en kiti nedu kopwi. Lapan ikarndrundrumwi yu pe iduwe nedu su ndre sulo-on kutih.” ");
INSERT INTO ktm_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Inum ti pe horu pedih lewen marai tan Resel pe Leah ndrodan nedu' horu hala pe pandrulku-u' su ile poi pe hopo ruru ile tan Iso. ");
INSERT INTO ktm_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Inum pe Leah pe nedun su, pe kah ndruwen lakopwi eri Resel pe nedun ke Yosep. ");
INSERT INTO ktm_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Iso ihndremte yi ihpa, “Ihpa kehe ile ta su ndramat ndre yu uhrah ta su hanna munen tih? Ou opo eti odosa lakopwi tih?” Ile pe Yakop ihpa, “Mandra-an todo, yu upwe kile pe ou akarndrundrumwi yu.” ");
INSERT INTO ktm_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Odoke Iso ipe ihpa, “Todo ti hudut, tinto. Konan, okuni ndre tadam yi.” ");
INSERT INTO ktm_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ile pe Yakop ihpa, “Pwi, tinto, okunii. Odo yu use pe ou ahwasu-um yu pe opo huyen ile todo tih. Yu ultuwe purmadam eri ihpa ndre yu ultuwe purmadan Lapan. ");
INSERT INTO ktm_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ile pe ou okuni tadam sane ertih. Lapan ipu huyen ile todo pe ihlingii yu sane ndre sulo-on ndre yu urih tih.” Yakop inehkike-ei kopwi ile pe Iso ihwaso-on pe ikuni sane ertih. ");
INSERT INTO ktm_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Iso ipe ile ta Yakop, “Kah tara-au. Yu ku-in munen toru.” ");
INSERT INTO ktm_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yakop ihpa, “Mandra-an todo, ou tunom ihpa ndre kom mo-one eri nuruwen su pwi, pe tawene todo sih mandra-an eri ile ta sipsip, meme pe makau ndre ma hetyen tapa eriy pe nedu' su mone tih. Ipe ye yu kuhnan su halla kile puko-on rang ndre sei, eri we su hamat. ");
INSERT INTO ktm_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Kile huyen eri ou omnen toru, pe yu we kulila munye kuse omur. Yu we kulla kile lila-an kom mone pe sane ka-an kurti uu kenon ndre yu kuhir ndrongon ou odo Idom.” ");
INSERT INTO ktm_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Iso ihpa, “Eri kihpa kehe eri yu kupu se ndramat lewen pahun todo honto ndre ndrongon ou.” Odoke Yakop ihpa, “Mandra-an todo, iy kirti konan. Tapa yu wasu-u eri karundrum tadam kise todo tih.” ");
INSERT INTO ktm_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ile pe idu rang erti Iso pe su lewen ha-au hala yi ndre Idom. ");
INSERT INTO ktm_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Odoke Yakop eri iyeu ile tolau ea. Iy imandro ile lok sehir pe ihtungon emwen. Pe iy itmon nonowen sane ka-an tadan ti yi. Iy kurti uu pe rangan lok ti ile Sukot tih. ");
INSERT INTO ktm_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakop imin Sukot oh ti pe itlang ile taon Sekem, odo Kenan. Lili-an iyus ndre Harran uu pe isihir Kenan ti handrai horut indrihir eriy pwi. Yakop iduwe mandro-on imin kangahan poi hombrul ise koson Sekem. ");
INSERT INTO ktm_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Iy ikuni kangahan poi erti odo ndrongon su nedun Hamor, eri pe isihnen ile ndralahan silwa ndre sangat. Nedun Hamor homou ti rangan Sekem. ");
INSERT INTO ktm_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Iy ihtungon alta sih odo lok erti pe irson ile palan rangai El, Lapan ta su Israel. ");
INSERT INTO ktm_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Idu rang sei eri pe Dainah, nedun Yakop horu Leah pihin eri ile ilndrou ile ndrongo su pedih Kenan se. ");
INSERT INTO ktm_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Hamor ti lapan Hivi, pe iy luluai odo lok Sekem. Nedun kamal rangan Sekem eri indroni Dainah pe imbroserihi iy. ");
INSERT INTO ktm_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Odoke iy indre-et ti pe Dainah ti rahyen pedih lakopwi, ile pe iy reh tadan mandra-an ipe kikuni iy kile mbrulun. ");
INSERT INTO ktm_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ile pe iy ipe ile tan taman ihpa, “Yu upwe ou ada salan enihin kurti pe yu kukuni iy kile mbrulu.” ");
INSERT INTO ktm_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakop ihrung ihpa ndre nedun pihin ti horut ihir mundren, odoke nedun su kamal ti hondroto pwi. Su mapwi hala kelye-en sane ka-an pe hondroto um pwi. Ile pe iy indripa hangka-an pwi, iyenon ndre su hasa yi. ");
INSERT INTO ktm_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Taman Sekem, Hamor, ile ilsohou ta Yakop, ");
INSERT INTO ktm_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","pe mapwi imin ke ndre eriy ti pe nedun Yakop su hehir. Su hohrung nolou kurti pe lon ndrine’ su inei pe hopo loroh ile mo-on. Punou Sekem ipu kudu eri indremimel ile tawene ta su nedun Israel ti pwi. ");
INSERT INTO ktm_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Odoke Hamor ipe ile tadan ihpa, “Sekem, nedu, eri reh tadan mandra-an idu tan nedum tih. Yu wasu-u upwe iy kile mbrulun nedu. ");
INSERT INTO ktm_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Yu upwe tidu titla tawene sih. Odu adasuwon su pihne’ oduu pe oduu adasuwon su pihne' odu. ");
INSERT INTO ktm_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Kile we tidu tida-au tito lok katih. Ou si reh tadam kidu lok kehe eri ala pe elmin eriy. Atlila pe we otpo suhen kile reh taduu pe we atla tama' sane sulo-on.” ");
INSERT INTO ktm_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Inum ti pe nedun Hamor, Sekem, ipe ile tan taman Daina pe timso-on su ihpa, “Yu upwe oduu atawe mbrulu Daina. Uh oduu atawe mbrulu, eri handrai sa ndre oduu etreh ti yu we kuduwe taduu. ");
INSERT INTO ktm_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Atpahran mbrunen pihne oduu kihpa ndre oduu etreh. Pe atpahran homosa yi oduu atpa yu kuhngahang oduu. Yu we kuduwei kihpa ndre reh taduu. ");
INSERT INTO ktm_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Odoke su nedun Yakop kamal hadawiwihi Sekem horu taman odosa Sekem ihyan timso-o' su tih. ");
INSERT INTO ktm_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Su hapa ihpa, “Odu we etndretawe timso-o’ odu kinna tan iy si ndramat ndre keltun merse-en mapwi idu ti pwi. Iy erti kihne kiduwe mah-ah kise tadu. ");
INSERT INTO ktm_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Sal ke sih iy ndre we odu edehwaso-o’ odu nolou tadam, eri we ndre hepini keltun merse-e’ su kamal taduu ndre sulo-on ha-au tih. ");
INSERT INTO ktm_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Kile we osou eri kah we kile pe kise, oduu atakun su pihin ta odu pe odu atakun su pihin ta oduu. Kile kah odu etmandro ndrodan oduu pe tidu titla lok ke hokor. ");
INSERT INTO ktm_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Odoke uh, ipe ye oduu etndrepini keltun merse-e’ oduu pwi, eri we odu atakuni timso-o’ odu pe ada-au odo lok ketih.” ");
INSERT INTO ktm_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Tawene tan nedun Yakop su kudu, eri ideng huyen ile ndralngan Hamor horu nedun, ");
INSERT INTO ktm_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ile pe Sekem indritakulkulen sa ndre su hapa ti pwi, odosa iy ipe we kikuni ndre nedun Yakop pihin kutih. Anah kuti iy kakah homou, tapa ise ke pahndran taman, odo lon ndramat tan taman ndre sulo-on. ");
INSERT INTO ktm_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Inum ti pe Hamor horu nedun ke Sekem harla ndruhun sohou ise pohngkuwe sariy odo taon pe harlaninen tawene ta Yakop su nedun ile ta su ndramat odo lon taon kurtih. ");
INSERT INTO ktm_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Hamor ihpa, “Su ndramat kuti huye' su. Su we hondrupo handrai ndre handrai kile pule-e tidu pwi. Tidu titawe su hamandro hodo ndrodan tidu, pe halla pe hopo sane kile reh ta su. Poi ti mandra-an pe iyenon su pe tidu. Tidu we tidasuwon pihne' su pe su hasuwon pihne' tidu. ");
INSERT INTO ktm_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Odoke su hapa tidu kamal ndre sulo-on eri titpini keltun merse-e' tidu ha-au kihpa ndre su ti oh, kile we su pe tidu tidohntok kile hondroh, pe titla ndramat ke hemir. ");
INSERT INTO ktm_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Tidu tidahnan kihpa ndre su hapa eri we sane ka-an ndre sulo-on ta su, ndrodan ndre sane ta su se yi, eri we tidu titakuni tatidu. Oduu atpa titla tama sane ta su, eri we ndre tidahnan kihpa ndre su hapa tih.” ");
INSERT INTO ktm_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ile pe su hereh tawene iy ndre Hamor horu Sekem harpa ti pe su ndre sulo-on hepini keltun merse-e' su ha-au. ");
INSERT INTO ktm_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Rang ile ndre tul, mapwi suwa he-en ndre merse-e' su kamal, eri pe horu nedun Yakop kamal ndre rumuu Simeon pe Levi horpo nuhen timso-o' horu ke Dainah, ile pe hartakuni painat ta horu, pe harla lon taon pe hermendrele sa kamal ndre sulo-on hamat, ");
INSERT INTO ktm_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ndrodan ndre Hamor horu Sekem. Inum ti pe horu harla um tan Sekem pe harlatakuni Dainah pe su ha-au. ");
INSERT INTO ktm_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ndruwen Simeon pe Levi harahnan kurti inum ti pe nedun Yakop kamal huren ti hala pe hokuni sane ndre sulo-on odo lon taon. ");
INSERT INTO ktm_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Sane ndre su hokunii ti sipsip, makau, pe donki, ile ndroda sane ndre sulo-on odo lon taon pe odo ngerin taon yi. ");
INSERT INTO ktm_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Su hokuni sane ndre sulo-on iy ndre huye' su ti pe hokuni sa pedih pe kom mone ndre sulo-on, ile ndrodan ndre sane ta su odo omwe’ su yi. ");
INSERT INTO ktm_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yakop tawene tadan ihrut ile ta Simeon horu Levi pe ipe ihpa, “Oruu erndretawe pede-en insa todo. Su Kenan pe su Peres pe sa ndramat ndre sulo-on odo lok kerti we hehmbore sa yu. Yu ndromto pwi, pe ipe ye su hohntok kile hondroh pe hopo pahun kise puli-i, eri we tidu ndre sulo-on we titmat.” ");
INSERT INTO ktm_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Odoke horu harahpa, “Oru we ermin kopwi pe ernendre-et sa ndramat hantandruwye timso-o' oru kihpa ke kurti? Iy ti pedih odo sal pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Inum ti pe Lapan ipe ile ta Yakop, “Sowin kopwi, ala Betel pe elmin eriy. Ohtong sih alta pe eduwe rongo kise eriy. Yu ti Lapan ndre uhir ise ndrongon ou idu kalmene-en ou ana-au tan tintom Iso tih.” ");
INSERT INTO ktm_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ile pe Yakop ipe ile tam mbrulun pe nedun su ndrodan ndre su ndramat tadan se yi ihpa, “Etpiyen lapan taheweh he-en ndrongo oduu ti ha-au, otnu, pe otnusi taduu sane wohou hala mundre' oduu. ");
INSERT INTO ktm_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Tidu kah we tida-au odo lok kerti pe we titla Betel. Pe yu we kulehtungon alta ta Lapan. Lapan Iy ndre inehnuwii yu illa pede-en todo pe imin ndroda yu idu iy ndre yu unelila ile lok ndre sulo-on tih.” ");
INSERT INTO ktm_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ile pe su heduwe lapan taheweh ndre sulo-on, ndrodan ndre ring hoso ndralnga' su, eri hala ndrongon iy. Pe iy idoni sane kuti hala kendrun kei he-ei rangan ok, odo koson Sekem. ");
INSERT INTO ktm_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Idu Yakop pe nedun su hatlang ha-au, eri pe sa ndramat odo taon he-en koson Sekem ti honoh ile mo-on, ile pe hondrupo handrai punou inna ta su pwi. ");
INSERT INTO ktm_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakop pe ndramtan su ndre sulo-on hehir hala Lus. Lus idu mahkele ti sa hoyuw ile Betel, ise lon poi mandra-an Kenan. ");
INSERT INTO ktm_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Iy ihtungon alta sih pe iduwe rangan lok eti ile ‘Lapan odo Betel,’ odosa Lapan ihir hun iy idu rang ndre iy ina-au tan tinton ke Iso tih. ");
INSERT INTO ktm_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Rebekah ti kelye-en homou rangan Deborah. Deborah imet pe su hedoni iy idu kendrun kei he-ei rangan ok, odo kup ea odo Betel. Ile pe sa henewuyen ile ‘Kei odo Ndrileng.’ ");
INSERT INTO ktm_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakop imin Betel, eri pe Lapan ihir ile ndrongon iy petsih yi pe ipatihteh iy. ");
INSERT INTO ktm_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Lapan ipe ihpa, “Ou rangam ti Yakop, odoke idu mahkele pe kile eri rangam ti kawe Israel. ");
INSERT INTO ktm_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Yu ti Lapan Petngendrei. Ou opo nedum kile sulo-on. Su we hohor, pe kantri mandra-ane we hehir odo ndrongon ou yi, pe yayam su se we hala king. ");
INSERT INTO ktm_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Poi iy ndre Yu uduwe ile tan Abraham pe Aisak, eri Yu we kuduwe kile tadam pe ta yayam su ndre we hehir omur yi tih.” ");
INSERT INTO ktm_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Inum ti pe Lapan iyeu. ");
INSERT INTO ktm_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakop idotinen pat sih ile kalmene-en Lapan isohou tadan odo lok ertih. Inum oh ti pe iy itndrangan wain ile pule-en pat ihpa ndre ofa tadan, pe iy itndrangan ndronun oliv ile eriy yi. ");
INSERT INTO ktm_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Pe iy iduwe rangan lok erti ile Betel. ");
INSERT INTO ktm_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yakop pe ndramtan su ndre sulo-on hatlang ha-au odo Betel pe hala Efrata. Su hanna mukehe hepe odoke hendrihir Efrata ti mapwi, eri pe Resel ipundrindri-is iy ipe kitou nedun. Iy ises nedun ti pe itou nedun tahit. ");
INSERT INTO ktm_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ngendre-en ti ile puko-on lakopwi eri pe pedih kelye-en ti ipe ile tadan ihpa, “Resel, onoh kolwii. Nedum kamal homou yi.” ");
INSERT INTO ktm_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Idu issas ke ipe kimet ti pe iy irson rangan nedun ti ile Benoni, inum ti pe iy imet. Odoke Yakop irson rangan ile Benjamin. ");
INSERT INTO ktm_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Resel imet ti pe hedoni iy idu ngerin sal ile Betlehem, pihe heneyuwen ile Efrata. ");
INSERT INTO ktm_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakop idotinen pat sih ile kelim idu pule-en kapet ta Resel, pe isto mahkele eri pat kudu erti mapwi ilto. ");
INSERT INTO ktm_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Inum oh ti Israel illa ile. Iy ihluwen ndre tawa odo Eder ti pe iduwe ndruhun mandro-on imin eriy. ");
INSERT INTO ktm_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Idu iy ndre Israel mapwi imondro imin lok kudu, eri pe Ruben imtir Bilhah. Bilhah ti pedih lewen marai tan Resel. Bilhah ti mbrulun Yakop yi. Ruben imtir Bilhah eri pe Israel ihtunon. Yakop eri nedun su ndre sungoh-pe-rumuu. ");
INSERT INTO ktm_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Su nedun Leah eri Ruben, nedun Yakop ndrihou, inum oh pe Simeon, Livai, Judah, Isakar, pe Sebulun. ");
INSERT INTO ktm_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Su nedun Resel eri Yosep pe Benjamin. ");
INSERT INTO ktm_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Su nedun Bilhah pedih lewen marai tan Resel eri Dan pe Naptali. ");
INSERT INTO ktm_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Su nedun Silpah pedih lewen marai ta Leah eri Gat pe Aser. Su kom kurti heduwe su odo Paddan Aram odo ndre Mesopotemia. ");
INSERT INTO ktm_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakop ile ilndre-et taman ke Aisak ile Mamre, ise koson Hebron, lok iy ndre Abraham pe Aisak heremin eriy tih. ");
INSERT INTO ktm_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Aisak imin ihndre krismas puken sangat-pe-ndrorungeh ");
INSERT INTO ktm_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","pe ile ndre lopun pe imet, pe nedun horu, Iso pe Yakop hortoni iy. ");
INSERT INTO ktm_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Iy kurti su yayan Iso. Iso rangan handrai yi ti Idom. ");
INSERT INTO ktm_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iso iyesuwon horu pedih Kenan ndre rumuu. Mbrulun homou ti Adah, taman ti Elon, iy odo Hit. Mbrulun homou yi ti Oholibamah, taman ti Anah pe papon Sibeon, lapan Hivi. ");
INSERT INTO ktm_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Pe mbrulun homou yi ti Basemat, taman ti Ismael pe timso-on ti Nebaiot. ");
INSERT INTO ktm_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adah iduwe Elifas, pe Besemat iduwe Ruel, ");
INSERT INTO ktm_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","pe Oholibamah iduwe Jeus, Jalam pe Korah. Su kom nedun Iso kurti heduwe su odo ndre Kenan. ");
INSERT INTO ktm_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Inum ti Iso iyeu odo koson Yakop pe ile lok sehir yi. Tadan sane ndre sulo-on ti iy idekukohon iyus iy. Iy idekukohon mbrulun su, nedun su kamal pe pedih, su lewen ndre sulo-on, tadan sane ka-an, pe tadan sane ndre sulo-on odo lon omwen odo Kenan. ");
INSERT INTO ktm_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Iy iyeu ti odosa iy horu Yakop ndre rumuu ti ta horu sane ka-an ti ile teper, pe lok horu hermin eriy ti lehyen, indranon sane ka-an ta horu ti pwi. ");
INSERT INTO ktm_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ile pe Iso iyeu ile lok puliy odo Seir pe ilmin eriy. ");
INSERT INTO ktm_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Iso ti tinembro' su Idom. Su hosso lok puliy odo Seir. Ranga’ su nedun Iso ti kutih. ");
INSERT INTO ktm_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Adah, mbrulun Iso munen eri nedun ke homou kamal, rangan Elifas, pe Elifas eri nedun su ndre limuu kamal. Ranga'su ti: Teman, Omar, Sefo, Gatam pe Kenas. Iy iduwe kom ile tam pedih homou yi rangan Timna, pe iyuwen rangan ile Amalek. Basemat, mbrulun Iso omur eri nedun ke homou kamal yi, rangan Ruel. Pe Ruel eri nedun su ndre hamou: Nahat, Serah, Samah pe Misah. ");
INSERT INTO ktm_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Oholibamah mbrulun Iso ndrokoron, eri taman ti Anah pe papon eri Sibeon. Oholibamah eri nedun su kamal ndre tulmuu: Jeus, Jalam pe Korah. ");
INSERT INTO ktm_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Iy kuti um kamal sim pe sim ndre hehir odo tan Iso tih: Elifas ti kom ndrihou tan Iso, pe nedun su ti Teman, Omar, Sefo, Kenas, ");
INSERT INTO ktm_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Gatam, pe Amalek. Su kurti hehir odo tam mbrulun Iso rangan Adah. ");
INSERT INTO ktm_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ruel nedun Iso homou yi tam Basemat, eri iduwe kom ndre hamou: Nahat, Serah, Samah, pe Misah. Su um kurti hehir odo tam mbrulun Iso rangan Basemat. ");
INSERT INTO ktm_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Su um hapwing yi hehir odo tam mbrulun Iso rangan Oholibamah, taman eri Anak. Su erti Jeus, Jalam, pe Korah. ");
INSERT INTO ktm_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Su nedun Iso kuti hehir hala lin ndramat hokou pe hokou odo Idom. ");
INSERT INTO ktm_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Seir ti lapan Hor, pe iy ti imandro imnen ile Idom. Su nedun Seir kamal ti Lotan, Sobal, Sibeon, Anah, Dison, Eser pe Disan. Su kamal ndre ndrotulmuu kuti lin ndramat hokou pe hokou odo Hor ndre hodo Idom tih. ");
INSERT INTO ktm_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan eri tinembro’ su Hori pe Heman. Lotan ti timso-on homou rangan Timna. ");
INSERT INTO ktm_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal eri tinembro’ su Alvan, Manahat, Ebal, Sefo, pe Onam. ");
INSERT INTO ktm_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeon eri nedun kamal rumuu, Aia pe Anah. Ndramat rangan Anah kuti ndre ile kelye-en donki tan taman uu pe itureh wo mburten ise lok sehir, on pe pat kopwi iyin eriy tih. ");
INSERT INTO ktm_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anah eri nedun ti Dison horu Oholibamah. Oholibamah ti iy pihin. ");
INSERT INTO ktm_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Su nedun Dison kamal eri Hemdan, Esban, Itran pe Keran. ");
INSERT INTO ktm_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser eri lin ndramat ta su Bilhan, Savan pe Akan. ");
INSERT INTO ktm_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Nedun Disan eri tinembro’ su Us pe Aran. ");
INSERT INTO ktm_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Su nedun Seir kamal ndre ndrotulmuu ti tinembro' su Hor ndre hodo lok Idom. Ranga' su kamal ndre ndrotulmuu kuti Lotan, Sobal, Sibeon, Anah, Dison, Eser, pe Disan. ");
INSERT INTO ktm_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Su Israel ta su king mapwi, eri pe su Idom eri kah ta su king. ");
INSERT INTO ktm_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Ndramat ile king ndre mamunen ta su Idom eri Bela. Taman eri Beor, pe iy immin taon Dinhabah. ");
INSERT INTO ktm_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela imet pe Jobab isini ndruhun. Jobab ti taman Serah, odo taon Bosrah. ");
INSERT INTO ktm_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobab imet pe Husam odo lok Teman isini ndruhun. ");
INSERT INTO ktm_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam imet pe Hadad isini ndruhun. Hadad ti taman Bedad. Hadad iyin munen su lewen pahun ile Moap pe hohkohon su Midian pe hesini lok. Iy immin taon Avit. ");
INSERT INTO ktm_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad imet pe Samlah odo lok Masrekah isini ndruhun. ");
INSERT INTO ktm_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samlah imet pe Saul isini ndruhun. Iy lonen Rehobot ise ngerin wo Yufretis. ");
INSERT INTO ktm_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saul imet pe Balhanan nedun Akbor ti isini ndruhun. ");
INSERT INTO ktm_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Balhanan imet pe Hadad isini ndruhun. Iy immin taon Pau pe rangan mbrulun ti Mehetabel. Mbrulun ti taman Matret pe papon Mesahap. ");
INSERT INTO ktm_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Iso ti lin ndramat ta su lok mandra-ane kutih: Timna, Alvah, Jetet, Oholibamah, Elah, Pinon, Kenas, Teman, Mipsar, Makdiel, pe Iram. Lok kuti hoso Idom. Idom ti rangan Iso handrai yi tih. Pe su Idom ti yayan Iso. Su hokou pe hokou ti ndre lone'su ea pe ndre lin ndramta'su ea, odoke su ndre sulo-on ti yayan ke Iso. ");
INSERT INTO ktm_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakop iyeu imin lok sehir odo Kenan iy ndre taman ke Aisak munen imin eriy tih. ");
INSERT INTO ktm_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Iy kurti pohtidiyen nedun su. Yosep mapwi ndre eleheu, krismas tadan mapwi sungoh-pe-ondrotoloh, eri inu-us su tinton tam Bilhah pe Silpah. Bilhah pe Silpah ti pedehnen marai ta Leah horu Resel, odoke Yakop iyesuwon horu. Yosep inu-us su tinton kuti, pe su mada' su iso sipsip pe meme. Odoke iy ininen punou mo-on kehe ndre su tinton hompo, eri ile tan tama' su. ");
INSERT INTO ktm_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israel waso-on Yosep lakopwi odo lenga' su nedun ndre sulo-on odosa iy ile ndre lopun pe heduwe Yosep. Iy isokopti kolos sih huyen lakopwi pe iduwe tadan. Kolos ti elwe-en pe pusen elwe-en, pe rahyen lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Su hondroni ihpa ndre tama' su ti waso-on Yosep lakopwi odo ndrongo su, eri pe su hehmuno-on iy pe hesenosohou huyen isella tadan pwi. ");
INSERT INTO ktm_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Lukumwen sei ti pe Yosep imihmih, pe inen ile ta su, eri pe su hehmbore su iy lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Iy ihpa, “Atahrung mihmih todo. ");
INSERT INTO ktm_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Tidu ndre sulo-on tito katen titnohndruhus padan wit ile hopus hopus, eri pe todo ti isupu-ur pe ihndrer idu eleng. Taduu eri hesupu-ur pe hosusokaltan todo, pe hopo ruru ile eriy.” ");
INSERT INTO ktm_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ile pe tinton su ti hapa ihpah, “Ou ti apa we ala king pe odu otso pahndram?” Su kah hehmbore su iy lakopwi, odosa iy inemihmih inehpa kuti pe ininen ile ta su tih. ");
INSERT INTO ktm_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Inum ti pe Yosep imihmih petsih yi pe inen ndralngan tinton su yi ihpah, “Yu umih upwe ye undroni mundroi pe ndrou pe su pudiy ndre sungoh-pe-sih hompo ruru ile todo.” ");
INSERT INTO ktm_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Iy inen ndralngan taman ile mihmih kurti yi, odoke taman ihrurute anan pe ipe ihpah, “Mihmih handrai sa kirti? Ou apa we tinem, tintom su, pe yu we atsa hun ou pe otpo ruru kile tadam?” ");
INSERT INTO ktm_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Su tinton Yosep ha-amuno-on iy pe hehmbore su iy ke ile mandra-an lakopwi, odoke tama’ su eri tawene tadan indra-au odo sane ndre sulo-on ndre iy inen kurti pwi. ");
INSERT INTO ktm_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Petsih eri su tinton Yosep hokuni sipsip pe meme tan tama’ su pe hanna Sekem, ");
INSERT INTO ktm_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ile pe Yakop ipe ile ta Yosep ihpah, “Tintom su ti hokuni sipsip pe meme pe hanna Sekem. Sipsip pe meme ti helena-an karas holso eriy. Yu upwe ou ala ndrongo su.” Ile pe Yosep ihpah, “Huyen tomo. Yu we kule.” ");
INSERT INTO ktm_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Taman ihpah, “Ala altalilmi su tintom. Su holto ihpa kehe? Pe altalilmi sane ka-an yi. Kinum pe asa esininen ndrolngo.” Inum oh ti pe taman iltudou iy ile sal odo Ndrolon Hebron. Yosep ihir ile Sekem ti pe ");
INSERT INTO ktm_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","orungon homou itureh tadan ilila sehir ile sehir pe ihndramtan iy ihpah, “Ou ompondrih sa?” ");
INSERT INTO ktm_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yosep ihpah, “Yu umpondrih tinto su. Su hokuni sipsip tan tama' odu pe hansa ke hepe kertih. Ou endre-et hepe su ndre pwi?” ");
INSERT INTO ktm_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Orngon ti ipe ihpa, “Su handra-au odo kertih. Yu uhrungi su hapa we hala Dotan.” Ile pe Yosep illa ile wuron Dotan ea pe iltureh ta su odo eriy. ");
INSERT INTO ktm_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Iy mapwi indroh ndre alau eri pe su hondroni iy, pe hehndrepti nolwo-o’ su ile ke sih hapa we hapwi iy kimet. ");
INSERT INTO ktm_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Su hahpah, “Ya, lapan mihmih ti ipei. ");
INSERT INTO ktm_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Atsa, titrohe iy kimet pe titpiyen iy kile lon sih ngaden wo iy ndre wo handrahak odo lon he-en tih. Kinum oh pe titlaninen titpa sane ka-an puyep handrani iy. Kile we titndre-et sa kihir odo mihmih tadan.” ");
INSERT INTO ktm_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruben ihrungi ihpa kurti ile pe ipe kihnuwii Yosep. Ile pe iy ipe ihpah, “Titruhe iy kimet kolwii. ");
INSERT INTO ktm_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Tidapwi iy kolwii. Kile huyen eri titpiyen ke iy kile lon ngat ise kitih.” Iy ihnan kurti ipe kile pe su ndre ha-au, eri iy we kile yi pe kiruwi Yosep kise eleng, pe kiltawe iy kile ndre ndrongon tama' su yi. ");
INSERT INTO ktm_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yosep illa ile ti uu pe ihir ile hun tinton su, eri pe su hohrontok ile tadan pe here-e kolson idu mundren tih. ");
INSERT INTO ktm_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Inum pe su herwi iy pe hepiyen iy ile lon ngaden wo sih wo indrahak odo lon, ise lok ndre su hodo eriy tih. ");
INSERT INTO ktm_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Inum oh ti pe su hodo pwoi pe hoyo-on song. Su mapwi hana-an song he-en ndre pwoi, eri pe hondroni su ndramat hemir yayan Ismael hondroh Gileat hapa hala Isip. Kamel ta su eri henesursor ndruwon sane se ihpa ndre spais, bam, mirah pe resis. ");
INSERT INTO ktm_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Judah ipe ile tan tinton su ihpa, “Iy ndre oduu atpa tidu titruhe iy kimet oh pe titlatawiwihi tama' tidu titpa ka-an puyep handrani iy, eri huyen, odoke we titndretakun rehen pwi. ");
INSERT INTO ktm_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kile huyen, eri titawe iy kile pe su lau Ismael kurti hesihnen iy, kile we titndreruhe iy pwi. Mandra-an lakopwi, eri iy ti tinto' tidu, tama' tidu homou pe ndraye’ tidu hopwil.” Tinton su hereh tawene ertih. ");
INSERT INTO ktm_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Su ndramat odo Midian kurti hasa ndre mukehe eri pe su tinton Yosep herwi Yosep odo ngat ise eleng, pe su Ismael hesihnen iy ile moni silwa ndre rungeh, pe hekuni iy ile Isip. ");
INSERT INTO ktm_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ndruwen ke su hepiyen Yosep ile ngat eri pe Ruben illa iyeu ile ngerin lok. Iy indra-au pe tunon homosa su hopo idu omur ti pwi. Iy idekukunon ile ndre elwe-en lakopwi oh pe ise yi iseturtur tinton imin ngat, odoke tinton ti indrimin pwi. Iy ikarundrum Yosep, ile pe ire-e kolson. ");
INSERT INTO ktm_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Iy ile ndrongon tinton su pe ipe ihpa, “Anah ti indrimin pwi! Yu kawe kupu kihpa kehe?” ");
INSERT INTO ktm_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Inum pe su heruhe meme homou imet pe hatlaman kolos ta Yosep ile ndrayen meme kutih. ");
INSERT INTO ktm_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Inum oh pe su hokuni kolos kurti ile ndrongon tama’ su pe hapa ihpa, “Odu otpondriti ka-an kurtih. Etlilimi oh, kihne kolos tan nedum ke Yosep tih.” ");
INSERT INTO ktm_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Iy indroni kopwi ti pe ipe ihpah, “Tapa eriy, iy kurti kolson nedu tih. Se ka-an puyep hahrah tadan pe hati iy imet pe handrani iy.” ");
INSERT INTO ktm_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yakop ikarndrum nedun ile pe ire-e kolson idu mundren ti iyeu, inswi tadan kuren sane ile mundren, pe imtuu nedun elwe-en lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Nedun su kamal pe pedih hapasa-as iy, odoke iy ihmboren ipe we su handrapasi iy pwi pe ipe ihpah, “Yu we kumtuu pe kungkarndrum kihpa ke kurti uu kenon ke yu kumwet kule ndrodan nedu.” Ile pe iy imtuu nedun ke Yosep ile lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Idu Yakop mapwi inemutuu pe su nedun se ti hempasa-as iy, eri su Midian hekuni Yosep ile Isip ti pe Potifa isihnen iy ile lewen marai tadan. Potifa eri opisa homou tan king, pe iy eri madan ise pule-e' su gat ndre sulo-on odo lon um tang king. ");
INSERT INTO ktm_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Idu ke ndre hepe kalmene-en eriy, eri pe Judah iyeu odo hun tinton su pe iyeu ile ilmin ndrongon Hirah. Hirah ti iy odo lok sehir yi rangan Adulam. ");
INSERT INTO ktm_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Judah imin Adulam eri pe ihrah tan enihin homou Kenan, taman Sua, pe ipu kowos ile tadan pe ikuni iy ile mbrulun. ");
INSERT INTO ktm_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Mbrulun ti ile ndriyen pe iduwe nedun homou kamal. Iy irson rangan ile Er. ");
INSERT INTO ktm_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Pedih ti ile ndriyen yi pe iduwe nedun kamal homou yi. Iy irson rangan ile Onan. ");
INSERT INTO ktm_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Inum oh ti pe iy iduwe nedun homou yi kamal pe irson rangan ile Selah. Judah ti imin Kesip, idu heduwe Selah tih. ");
INSERT INTO ktm_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Judah ikuni pedih homou Kenan rangan Tamar ile mbrulun Er, kom ndrihou tadan. ");
INSERT INTO ktm_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Punou ndre sulo-on ndre Er impo eri mo-on kopwi ile madan Lapan, ile pe Lapan isini iy imet. ");
INSERT INTO ktm_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ile pe Judah ipe ile tan nedun homou yi rangan Onan, ");
INSERT INTO ktm_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","“Ou ala pe emtir ndrodan nau tan tintom, kile we tintom eri we yayan su he-en.” Odoke Onan tunon ihpa ndre kom kurti we nedun pwi, ile pe iy inemetir nawen tinton odoke wayen mundren ti iy ihnehnan immuw inna-au illa pwoi, kile pe pedih ti kindripo nedun pwi. ");
INSERT INTO ktm_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Lapan indrireh punou kurti pwi ile pe isini iy imet yi. ");
INSERT INTO ktm_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Judah ipe ile tan Tamar, nawen nedun horu ihpah, “Ou ala pe olso nawen nedu horu elmin hun tamam su pe ekeli-iy Selah kile nusuwon oh.” Iy ipe ihpa kurti odo iy inuh ipe kihne we Selah kikuni Tamar yi, eri kihne we kimet kihpa ndre tinton horu tih. Ile pe Tamar ile ilmin hun taman su. ");
INSERT INTO ktm_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ndruwen krismas heski inum ti pe mbrulun Judah imet. Ile pe iy imtuu mbrulun. Idu ndre rangen mutuu ti inum, eri pe iy ile lok sehir rangan Timnah, ipe kilndre-et su lau henendro-or lemun sipsip tadan hodo eriy. Kowos tadan rangan Hirah, iy odo Adulam eri iyus iy. ");
INSERT INTO ktm_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Sa homou inen ndralngan Tamar ipe yinan ti we kilndro-or lemun sipsip tadan kile Timnah. ");
INSERT INTO ktm_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ile pe iy ile irkwe ndrihin nau ti iyeu, pe iduwe tadan sane wuhou ile mundren, pe iserohe purmadan ile kolau odo soruroh purmadai. Inum pe iy imin pwoi potarahan sal ile Enaim, taon sih ise ke ngerin sal mandra-an illa Timnah. Tamar eri tunon ihpa ndre nedun Judah omur, rangan Selah, eri ke inna mandra-an, odoke handrai tawene odo osou kurti indrihir mapwi. ");
INSERT INTO ktm_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Judah indroni iy ti pe kolon eri ipe ye sa homou pedih odo sal, odosa iy isorohe purmadan ile kolau tih. ");
INSERT INTO ktm_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Judah ile hun iy ile ngerin sal pe ihndramtan iy ihpah, “Mbrunem ti heski?” Iy tunon ipe ye Tamar ti pwi. Iy ipe ye su homou pedih odo sal, odo iy isorohe purmadan tih. Tamar ihndremte ihpah, “Ou we eduwe todo homosa?” ");
INSERT INTO ktm_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Judah ihpah, “Yu we kudepipan tadam homou meme kamal iy ndre mapwi inek tapa eriy ti kise.” Tamar ihpah, “Huyen, odoke kihne ou adawiwihi yu. Kile huyen eri ou ottou hangka-an tadam huyen kimmin ndre ndrongo yu, kenon ndre ou eduwe meme ti kinsa. Kinum pe esetakuni yi ndre hangka-an huyen ertih.” ");
INSERT INTO ktm_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Judah ihndremte ihpah, “Yu we kuduwe sa kimin ndrongon ou uu kenon ndre meme ti kinsa?” Tamar ihpah, “Stem tadam mondre osuke-en kile ndrodan kendro ise lumwem.” Ile pe Judah iduwei ile hun iy. Inum ti pe Judah imtir Tamar pe Tamar ile ndriyen tadan. ");
INSERT INTO ktm_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamar iyeu ile ndre emwen pe irupti kolau iyeu odo madan pe iduwe ndrihin nau ile ndre mundren yi. ");
INSERT INTO ktm_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Judah ikuni meme homou pe iduwei ile tan kowos tadan ke Hirah pe ipe iy kiltawei kile tam pedih ndre iy imtir iy pe kiltakuni sane tadan idu ndrongon iy. Odoke iy indretureh tam pedih kurti pwi. ");
INSERT INTO ktm_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Iy ihndremte su lau se odo lok erti ihpah, “Pedih pamok immin ngerin sal odo Enaim ti inna kehe?” Su hapa ihpah, “Homou pedih pamok isemin erti pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Hirah iyeu ile yi pe ilpa ile tan Judah ihpah, “Yu ulpondrih iy tahit. Su lau odo eriy, eri hapa homou pedih pamok isemin lok erti pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Judah ihpah, “Konan, homou pedih erti kah kidekepti tadan sane erti kidu hun iy. Yu mbori iy ndre sa lau harikiyan toru tih. Yu upwe kuduwe meme kuti kile mbrunen odoke ou endretureh tadan pwi tih.” ");
INSERT INTO ktm_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ndrou toloh ndre ilnum pe sa homou inen ile tan Judah ihpah, “Yinam ke Tamar ti intudou ke iy ile ta sa kamal pe kah ndriyen.” Judah ipe ihpah, “Atakuni iy kise pe etulmwi iy kimet.” ");
INSERT INTO ktm_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Sa ndre hantakun Tamar ile odo we hetlumwi iy kimet, eri pe iy iduwe nolou ile munen ile hu yinan ihpah, “Yu ndriye ti tan iy kamal ndre sane tadan idu ndrongon yu kutih. Etlilmen kehii kile we ohtunom sane ti ta si lakopwi. Stem ndrodan ndre osuke-en, pe kendro ti ta si?” ");
INSERT INTO ktm_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judah itureh ihpa ndre sane kurti tadan, ile pe ipe ihpah, “Horut eri idu hu yu, iy ti pwi. Yu ti undrahnan moryo pwi. Yu ti lehpe kundretawe iy kinna mbrulun nedu ke Selah.” Ile pe Judah hepe indremetir ndrodan Tamar pwi yi. ");
INSERT INTO ktm_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Idu mundrun Tamar ipe kitou nedun, eri pe su hetureh ihpa ndre iy eri nedun ndrapol. ");
INSERT INTO ktm_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Iy impotili-it iy, eri pe nedun homou ti itsuwen lumwen ihir ise moleu. Pedih kelye-en ti ihrus ile eriy pe isswi esukei homou rama-an ile petlumwen, pe ipe ihpa, “Iy kurti kom ndrihou tih.” ");
INSERT INTO ktm_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Odoke iy iruwi lumwen ile yi, pe tinton eri ihir ise moleu imnen. Ile pe pedih kelye-en ti ipe ihpa, “Ou ohrukam pe ohmbrusuk ansa rang ewen munen tan tintom!” Ile pe horson rangan ile Peres. ");
INSERT INTO ktm_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Inum ti pe tinton ndre esukei rama-an idu kendrun lumwen ti kah ise moleu idu yi ndruwen, pe horson rangan Serah. ");
INSERT INTO ktm_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Su yayan Ismael hekuni Yosep ile Isip ti pe orngon homou rangan Potifa isihnen iy. Potifa ti kapten ta su gat odo pales, um mandra-an tang king. ");
INSERT INTO ktm_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Sane hehir hala ke huyen ile ta Yosep odosa Lapan imin pule-en. Pe iy inna-an song pe inemetir immin um ta mandra-an tadan, Potifa lapan Isip. ");
INSERT INTO ktm_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potifa indroni ihpa ndre Lapan imin hun Yosep pe sane ndre sulo-on ndre Yosep impo eri hehhir ile ke ndre huyen. ");
INSERT INTO ktm_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potifa ihwaso-on iy lakopwi ile pe ikuni iy ile lewen marai tadan imin ke ndre pahndran, ile pe Yosep madan ise um pe sane ndre sulo-on tan Potifa tih. ");
INSERT INTO ktm_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ile pe idu ke ndre rang erti pe Lapan ipu blesim Potifa, ndrodan ndre sane tadan ndre sulo-on he-en um pe he-en kiu. ");
INSERT INTO ktm_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Eri pe mandra-an ta Yosep iduwe Yosep madan ise pule-en su ndramat pe marai ndre sulo-on tadan. Iy ihron lumwen odo sane ndre sulo-on, kolon sumwi ile eriy, tapake song sa iy inna-an eri Yosep madan inso eriy pwi. Yosep iy sengin indrehndrut pe purmadan huyen, ");
INSERT INTO ktm_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","pe idu rang sei eri pe mbrulun Potifa, mandra-an tadan, eri mbruse-en ihndromuk ile ta Yosep pe ipe ile tadan, “Asa tarla rum.” ");
INSERT INTO ktm_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Yosep mboren pe ipe ile tadan ihpah, “Endre-et oh, mandra-an todo eri iduwe yu modo ise sane tadan ndre sulo-on odo um kerti, ile pe isentawene isela hangka-an pwi, odosa sane ndre sulo-on tadan eri yu modo ise eriy. ");
INSERT INTO ktm_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Homou yi mandra-an odo um keti pwi, tapake Potifa oh pe yu use pahndran. Ile pe iy iduwe sane tadan ndre sulo-on ti hodo pohndro. Tapake ou, eri mbrulun oso ke ndre lumwen. Ihpa kehe pe yu we kupu punou mo-on pe kuduwe to-ir kile purmadan Lapan?” ");
INSERT INTO ktm_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Iy inehtekel Yosep rang sei ihpa ke sei odoke Yosep inehmboren. ");
INSERT INTO ktm_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Odoke idu rang sei eri pe Yosep ile um ipe kilpo marai. Su lewen marai eri homou indrimin lon um pwi. ");
INSERT INTO ktm_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ile pe pedih kurti ihrus ile kolos idu mundren Yosep pe ipe ihpah, “Asa tarla rum.” Odoke Yosep ikalsan iy odo hun pedih kurti pe ihtot iyeu ile kiu, pe kolos tadan ti inso ndre lumwen pedih kutih. ");
INSERT INTO ktm_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Pedih kurti indre-et ihpa ndre Yosep ihtot indra-au pe kolos imin ndre hun iy, ");
INSERT INTO ktm_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","eri pe iy iyuw ile ta su lewen marai se yi ti ihpah, “Etndre-et oh! Lapan Hibru ndre mbrulu ikuni iy imin ndrongo tidu ti impo punou mo-on ile pule-e' tidu. Iy ise lon rum todo pe ipe kimbroserihi yu, odoke yu udehel. ");
INSERT INTO ktm_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Yu udehel ti pe iy ihtot iyeu ile kiu, pe kolos tadan imin ndre pwoi.” ");
INSERT INTO ktm_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Iy idekepti kolos ti imin uu pe ndre mbrulun ti ihir. ");
INSERT INTO ktm_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Inum oh ti pe iy inen ke ndre nolou ndre iy inen ndralnga' su lewen marai ile eriy ti ile tam mbrulun yi. Iy ihpah, “Lapan Hibru lewen marai ou okuni iy imin ndrongon tidu ti ise hun yu ise rum pe ipe kimbroserihi yu. ");
INSERT INTO ktm_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Odoke yu udehel, eri iy ihtot iyeu ile kiu pe kolos tadan immin ndre pwoi.” ");
INSERT INTO ktm_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Mandra-an ta Yosep ihrungii ti pe lon ndrinen inei ile mo-on, ");
INSERT INTO ktm_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ile pe su soldia hokuni Yosep pe hopton iy ile kou iy ndre su kadapus tang king honto eriy tih. ");
INSERT INTO ktm_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Odoke Lapan immin hun Yosep pe inehnuwii iy, ile pe ndramat madan iso tasu kadapus, eri irih ta Yosep lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Iy iduwe Yosep madan ise pule-e' su kadapus ndre sulo-on, ndrodan ndre sane marai handrai pe handrai ndre hehhir odo lon kowen kadapus. ");
INSERT INTO ktm_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Woda ihron lumwen sane ndre sulo-on pe iduwe Yosep madan ise eriy, eri pe sane ndre sulo-on hehir ile huyen, odosa Lapan ti immin hu Yosep. ");
INSERT INTO ktm_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Rang elwe-en hepe ndre ilnum, eri pe horu ndramat rumuu, homou mandra-an odo tune-en bret pe homou madan iso wain tang king odo Isip, eri harahnan tawene tang king ihrut. ");
INSERT INTO ktm_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","King lon ndrinen inei ile ta horu opisa ndre rumuu kurti ");
INSERT INTO ktm_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","pe iduwe horu harla kadapus harla um tan kepten tasu gad, iy ndre Yosep imin eriy tih. ");
INSERT INTO ktm_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Horu hermin kadapus erti ile elwe-en lakopwi, eri pe kapten tasu gad iduwe Yosep ile lewen marai ta horu. ");
INSERT INTO ktm_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Idu lukumwen sei eri pe ndramat mandra-an odo tune-en bret ti pe ndramat madan iso wain eri hermimih, pe mimih ndre rundrei kuti paninye ta horu indrila ke handrai pwi. ");
INSERT INTO ktm_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Idu maping Yosep ile ilndre-et horu ti pe itlonan ihpa ndre horu herentawene ile hangka-an. ");
INSERT INTO ktm_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ile pe Yosep ihndremte horu, “Kede ke indrahpa kehe? Oruu mada’ oruu indrehmo-on kopwi mahkele ti ile sa?” ");
INSERT INTO ktm_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Horu harahpah, “Oru ermimih pe homou ndramat indrimin hepe odo we kipaninyan mihmih taru ti pwi.” Ile pe Yosep ihpah, “Tapa Lapan intawe tawene odo paninye mihmih tih. Erninen mihmih taruu kile todo eh.” ");
INSERT INTO ktm_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ile pe ndramat madan iso wain ti ihpa, “Idu lon mihmih todo, eri yu undroni padan wain homou, ");
INSERT INTO ktm_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ndrolkopwen ndre tulndrei hoso eriy. Nombrun pe motuhron herihir ke petsih. Pe motuhron ti hehsengin pe hahmandran. ");
INSERT INTO ktm_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Yu undretowe kap tang king ti ise lumwe, ile pe yu ukuni mbrwen se pe ulsen ile lon kap pe uduwe ile tan king.” ");
INSERT INTO ktm_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yosep ihpah, “Paninye tadan ti ihpa ndre kurtih. Iy ndrolkopwen ndre tulndrei eri rang ndre tul. ");
INSERT INTO ktm_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Rang ndre tul kinum, eri king we kikuni ou owou odo kou, pe we kiduwe ou ala ndre maryam munen tih. Ou we entudou kapen kile lumwen yi kihpa ndre munen ou entudou wain ile tadan. ");
INSERT INTO ktm_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Odoke antawonon yu ipe ye ou elmin huyen tih. Akarndrundrumwi yu pe ehnuwii yu. Enen kile tang king kile pe yu ku-eu odo lon kou ketih. ");
INSERT INTO ktm_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Yu use keti sa hapahno-o yu odo lok ta su Hibru. Yu usumwin keti pe undrupo hangka-an mo-on pwi. Sa heduwe yu use kou ke porah.” ");
INSERT INTO ktm_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ndramat mandra-an odo tune-en bret ti iltuwe ihpa ndre paninye odo mihmih tan ndramat madan iso wain kuti ile huyen, eri pe iy inen tadan ti yi ihpah, “Yu eri umih yi, upwe ye unesursor mbrwenkusus bret ndre toloh he-en mburumpolo. ");
INSERT INTO ktm_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Mbrwenkusus ndre imin pule-en ti ndruwo’ sane handrai pe handrai tune-en yu upu anan king eri hodo lon, pe nenka-an hana-an.” ");
INSERT INTO ktm_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yosep ihpa, “Paninye tadan ti ihpa ndre kurti: mbrwenkusus ndre toloh eri rang ndre tul. ");
INSERT INTO ktm_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Rang ndre tul kinum eri king we kikuni ou owou odo kou pe hesimdri padawum ke-eu. Kinum ti we iy kihndrule-en purndrunum kise ndran kei, pe nenka-an we hani sengim.” ");
INSERT INTO ktm_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Rang ndre tul inum eri imel idu mundrun rang ndre heduwe king idu eriy, ile pe iy ihnan song mandra-an ana’ su opisa tadan ndre sulo-on. Inum ti pe king ikuni ndramat madan iso wain pe ndramat mandra-an odo tune-en bret ti hara-au odo kou pe iduwe horu harla lenga' su opisa se yi tih. ");
INSERT INTO ktm_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Iy iduwe ndramat madan iso wain ti ile ndre maryan munen ti yi, ");
INSERT INTO ktm_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","odoke iy ihndrule-en ndramat ndre intune-en bret tih. Ndre sulo-on kurti ihir ihpa ke ndre Yosep ipe tih. ");
INSERT INTO ktm_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Odoke ndramat madan iso wain eri indra-amelyen Yosep, hepe indretawonon iy pwi yi. ");
INSERT INTO ktm_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Krismas ruweh ndre ilnum pe king odo Isip imih. Iy ipe yi idu eleng idu ngerin wo Nael, ");
INSERT INTO ktm_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","eri pe makau ndre ndrotulmuu, handritamumu-uh pe mundre' su handranuw, hanak odo wo hasa eleng, pe hoyo-on karas lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Inum ti pe makau ndrotulmuu yi hanak hasa eleng. Su erti keltun ke su isorohe ndruwi' su pe hendriring. Su hasa eleng ti pe hasa ke lenga' su iy ndre hana-an karas odo kahu tih. ");
INSERT INTO ktm_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Eri pe su makau ndre hendriring ti hani su makau ndre handritamumu-uh tih. Inum ti pe iy ihretek imin eleng. ");
INSERT INTO ktm_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Iy madan mapwi metiriu ile pe imtir yi, pe imih handrai yi. Iy imih ipe indroni rais he-ei sengin ndre ndroltulmbrung mandra-ane hoso eriy. ");
INSERT INTO ktm_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Inum ti pe rais he-ei yi ihir. Padan indriroweswes kopwi pe sengin ndre ndroltulmbrung yi hoso eriy, odoke roro-on ke su odosa ngohon langat rai imburwi su. ");
INSERT INTO ktm_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Eri pe su iy ndre sengi' su roro-on kopwi ti heselmi su iy ndre sengi' su ndre hombrung ea tih. King iropulang imin eleng pe itlonan ihpa ndre iy ti inemimih. ");
INSERT INTO ktm_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Idu maping eri pe iy idawene puko-on ile eriy, ile pe iy iduwe nolou ile hu su ndramat odo ndre-et pe su sape ndramat ndre sulo-on odo Isip hasa hun iy. Iy inen ndralnga’ su ile mihmih tadan, odoke homou ndramat indripaninyan inna tadan pwi. ");
INSERT INTO ktm_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Inum ti pe ndramat madan iso wain tang king eri ke idehorungon, ile pe iy ipe ile tan king ihpah, “Yu kah kupahran mehkele kile tadam, ihpa ndre yu undrahnan horut handrai. ");
INSERT INTO ktm_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Yu pe ndramat intune-en bret eri ou lon ndrinem inei ile taru pe opton oru ile kou odo um tan kapten tasu gad. ");
INSERT INTO ktm_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Petsih lukumwen eri pe oru ndre rumuu ermihmih, pe mihmih taru ti ndre paninye tahoru ea. ");
INSERT INTO ktm_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Oru erninen ndralngan anah homou Hibru pe iy ipaninyan ile ta oru. Anah ti impo marai tan kapten tasu gat. ");
INSERT INTO ktm_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Sane ti hehir ihpa ke ndre iy ipe tih. Ou eduwe yu upu ndre marai yi, odoke ou eduwe ndramat odo tune-en bret ti imet.” ");
INSERT INTO ktm_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","King iduwe nolou ile hu Yosep ile omwen kou pe ipe iy kiportai kopwi kisendre-et iy. Yosep isingi lemun pesen inum pe inswi kolson wohou ile mundren. Inum pe iy ile pe indru idu purmadan king. ");
INSERT INTO ktm_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","King ipe ile tadan ihpa, “Yu umtir pe umih, odoke homou ndramat indripaninyan pwi. Yu uhrung sa hapa ou ti ampaninye mihmih.” ");
INSERT INTO ktm_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yosep ihpa, “Yu eri undranon pwi, mandra-an todo, odoke Lapan we kipaninyan kile tadam.” ");
INSERT INTO ktm_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","King ihpa, “Yu umih upwe ye udu eleng udu pesen wo Nael, ");
INSERT INTO ktm_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","eri pe makau ndre ndrotulmuu hendritamumu-uh pe mundre' su enuwen, hanak odo wo hasa eleng ti pe hoyo-on karas lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Inum ti pe makau ndrotulmuu yi hendriring pe patndrondruwin ke su, hanak hasa eleng. Su hasa eleng ti pe hala ke lenga’ su iy ndre hana-an karas hodo kahu tih. Yu undrendre-et hepe makau ihpa kuti odo lon Isip ndre mandra-an pwi. ");
INSERT INTO ktm_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Su makau ndre hendriring ti hani su makau ndre handritamumu-uh, ");
INSERT INTO ktm_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","odoke ou ndramat madam kile ti pe we apa yi hangka-an ke pwi, odosa ndre-et ta su eri ihpa ke ndre munen. Inum ti pe yu uhretek umwin eleng. ");
INSERT INTO ktm_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Yu umih petsih yi eri pe undroni sengin rais ndre ndrotulmbrung hoso ke padan hene. Sengin ti hutun hoso hombrung hombrung, pe mandra' su. ");
INSERT INTO ktm_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Inum ti pe sengin rais ndre ndrotulmbrung yi hehir. Su erti roro-o' su kopwi, odosa ngohon langat rai iruhi su. Padan ndre sengin hoso eriy ti indriring. ");
INSERT INTO ktm_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Pe su ndre serke-e' su kopwi ti heselmi su iy ndre sengi su sulo-on tih. Yu unen mimih todo kurti ile tasu ndramat odo ndre-et, odoke su homou indripaninyan pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yosep ipe ile tang king ihpah, “Mihmih tadam ndre rundrei kirti paninye ta horu ti ile ke handrai. Lapan indripa inna tadam ile sa iy kawe kipu tih. ");
INSERT INTO ktm_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Makau ndre ndrotulmuu handritamumu-uh eri krismas ndre ondrotoloh, pe rais ndre ndrotulmbrung sengin hutun, eri krismas ndre ondrotoloh yi. Paninye ta horu ti ile ke handrai. ");
INSERT INTO ktm_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Makau ndre ndrotulmuu hendriring ndre hasa eleng idu omur pe rais ndre ndrotulmbrung ndre langat rai iruhi su pe hemsir kopwi, eri krismas ndre ondrotoloh song we pwi. ");
INSERT INTO ktm_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Sa ndre yu umpa ile tadam kuti we kihir. Lapan indripaninyan ile tadam handrai sa iy we kihnan tih. ");
INSERT INTO ktm_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","We kidu lon krismas ndre ondrotoloh eri song we kihur lakopwi odo lon Isip ndre mandra-an. ");
INSERT INTO ktm_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Iy kurti kinum, eri krismas ndre ondrotoloh yi eri we song pwi. Krismas ndre sulo-on huyen iy ndre song ihir eri we kile ameli-iy, odosa song pwi eri we kihyan lok ndre mandra-an. ");
INSERT INTO ktm_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Mundrun song ihur ti we sa ndramat kolo' sa kisumwen, odosa song pwi ndre we kidu ndruwen, eri we kile ndre mo-on lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Nolou ke handrai odoke ihir ile mimih ndre rundrei ti odosa, Lapan indretawe tawene Tadan puko-on inna eriy, pe elwe-en pwi pe we kihir. ");
INSERT INTO ktm_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Ile pe ou opondrih homou ndramat huyen pe tadan tawene elwe-en, pe eduwe iy madan kise pule-en lok ndre mandra-an odo Isip. ");
INSERT INTO ktm_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ou ehlite se opisa yi. Marya' su ti odo tapedeng song ta sa lau kidu lon krismas ondrotoloh ndre song mapwi ihur tih. Apa kile tasu pe su we hantukuni song hondroh odo lon song limndreh, pe hantaparngan kidu. ");
INSERT INTO ktm_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Apa kile tasu pe hadapedeng song kile sulo-on, kidu lon krismas ndre ondrotoloh huye' su tih. Pe eduwe puko-on kile ta su, pe su hadaparngan song hala um mandra-ane odo lon siti sih pe sih. Eduwe su hala kelye-en, kihne sa hapahna. ");
INSERT INTO ktm_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Song kurti adakepti kidu, kile pe kidu lon krismas ondrotoloh ndre song pwi kawe kihir Isip, eri song erti we kihkelmuyen taha. Tapa sal kuti we kihnan pe sa ndramat handrimat odo song pwi. ");
INSERT INTO ktm_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","King pe su opisa tadan hapa tawene kurti huyen, ");
INSERT INTO ktm_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","pe iy ipe ile tasu, “Mulou ta Lapan ti imin hun Yosep. Tidu titndranon titndrepondriti homou ye ndramat ihpa ndre iy ti odo hepe pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ile pe king ipe ile ta Yosep, “Lapan indripaninyan sane ndre sulo-on inna tadam, ile pe tapake ou tadam tawene huyen pe palam elwe-en. Homou lau indrahpa ndre ou ti pwi yi. ");
INSERT INTO ktm_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Yu we kuduwe ou madam kise kantri todo ndre mandra-an. Handrai sa ndre ou apa eri sa ndramat we honohrung ke ou. Yu ti king, inum oh pe ou oso pohndro. Homou ye ndramat pwi. ");
INSERT INTO ktm_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Mahkele eri yu kah kuduwe ou ala Gavena odo Isip ndre mandra-an.” ");
INSERT INTO ktm_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","King inswi ring mak tadan iyeu odo kopwen lumwen pe iduwe ile kopwen lumwen Yosep. Iy inswi kolos elwe-en ile mundren Yosep. Kolos erti hahnan odo sane ndre hompo kolson king illa eriy tih. Inum pe iy iduwe sen gol ile padawon. ");
INSERT INTO ktm_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","King iduwe karis tadan sih ti ile ta Yosep odo Yosep kinehtot kile eriy. Pe su gad he-en munen pe hoyuw ihpa, “Edehpil odo sal pe otpo ruru!” Ile pe king iduwe Yosep ile Gavena odo Isip ndre mandra-an. ");
INSERT INTO ktm_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","King ipe ile ta Yosep ihpa, “Yu ti king, pe homou ndramat odo lon Isip we kindripo sane ke porah pwi, kenon ndre ou apa.” ");
INSERT INTO ktm_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Iy iduwe rangan Yosep ile Safenat Panea. Rangai kuti ranga’ sa Isip. Pe iduwe Asenat ile mbrulun. Asenat ti taman Potifera, pris odo Heliopolis siti. ");
INSERT INTO ktm_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Krismas ta Yosep ti tulngeh, idu rang ndre iy ke ipu marai imin pahndran king odo Isip tih. Iy ke itlang odo ndrongon king pe ilndre-et lok ile hokor pe hokor odo lon Isip. ");
INSERT INTO ktm_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Idu lon krismas ndre ondrotoloh, eri song ihur odo lok ndre mandra-an, ");
INSERT INTO ktm_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","eri pe Yosep ideparngan song sulo-on pe iduwe hala omwen song odo siti sih pe sih. Song ndre iy ikuni odo ngerin siti kehe, eri iy intawe illa lon omwen song ndre imin siti ertih. ");
INSERT INTO ktm_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Song Yosep itparngan idu siti sih pe sih ti ile teper, ile pe iy ihron ndrom. Song ti ile hudut lakopwi ihpa ndre on odo ngerin ndras. ");
INSERT INTO ktm_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Idu lon krismas ndre song mapwi ihur, eri Asenat, nedun Potifera pihin ti iduwe nedun Yosep rumuu kamal. ");
INSERT INTO ktm_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yosep ihpah, “Lapan indrahnan pe yu kolu ke insumwen pede-en todo ndre sulo-on, ile ndrodan ndre tomo pe tinto su.” Ile pe iy irson rangan nedun ndrihou ti Manaseh. ");
INSERT INTO ktm_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Iy ipe yi ihpah, “Yu umwin keti pe ukun pede-en odoke Lapan ke indrehlingi yu kom.” Ile pe iy irson rangan nedun omur ti ile Efraim. ");
INSERT INTO ktm_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Krismas ndre ondrotoloh ndre song ihur odo Isip eri ke inum, ");
INSERT INTO ktm_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","pe krismas ndre ondrotoloh yi odo song pwi ti ihir, ihpa ke ndre Yosep indripa munen tih. Lok hokor pe hokor odo mahun eri song pwi, tapake Isip ndre mandra-an eri song he-en eriy. ");
INSERT INTO ktm_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Song ke inum odo Isip ti pe ndramat kah harah song, pe hala hung king pe hehndremte iy ile song. Ile pe iy ipe su helndre-et Yosep pe holpo sa ndre iy kipe kile tasu tih. ");
INSERT INTO ktm_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Song pwi ti imndra lakopwi pe isarpat ile lok ndre mandra-an, ile pe Yosep irwe omwen song ndre sulo-on odo siti sih pe sih pe sa ndramat odo Isip hesih. ");
INSERT INTO ktm_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Sa lau odo lok hokor pe hokor hala Isip pe helsih song odo hu Yosep, odosa lok ndre sulo-on eri song honum. ");
INSERT INTO ktm_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakop ihtunon ihpa ndre song ilto Isip, ile pe iy ipe ile tan nedun su ihpah, “Oduu we otto kopwi kihpa kirtih? ");
INSERT INTO ktm_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Yu uhrung ihpa ndre song ilto Isip. Oduu atla eriy pe atla sihsih ana' tidu, pwi ti we titmat.” ");
INSERT INTO ktm_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ile pe su tinton Yosep ndre sungoh hala Isip pe helsihsih song, ");
INSERT INTO ktm_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","odoke Benjamin lilin tinton Yosep ndre tine' horu homou, eri indru-us su pwi. Yakop ihmbrusen iy immin, odosa iy inuh ipe kihne handrai hangka-an horut kihir tadan. ");
INSERT INTO ktm_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Su nedun Israel ti ndrodan ndre sa ndramat se yi hala helsihsih song, odosa Kenan ndre mandra-an eri song pwi yi. ");
INSERT INTO ktm_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yosep, kah Gavena odo Isip, eri sa ndramat odo lokpoi ndre mandra-an helenesihsih song odo hun iy. Ile pe su tinton Yosep hala pe hopo ruru ile tadan uu pe mbruli' su iltu-uw ndre poi. ");
INSERT INTO ktm_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yosep indroni su tinton ti indra-aterihi su pwi. Iy tunon su odoke ihnan ihpa ndre tunon su pwi tih. Iy ihndremte su ndre puko-on ea ihpah, “Oduu otndroh kehe?” Su hahpah, “Odu otndroh ndre Kenan, atsasih song.” ");
INSERT INTO ktm_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yosep ti tunon iy erti su tinton. Odoke su kopwi eri handrapahran iy pwi. ");
INSERT INTO ktm_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Iy iltahorungon ndre mihmih tadan ile tasu ndre iy imehyen munen odo Kenan pe ihpah, “Oduu ti lulo-ou tih! Oduu atsaturtur lok pe atpa etsahtuno oduu kehe ndre oduu we odu-us eriy pe atsapo pahun tih!” ");
INSERT INTO ktm_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Su hahpah, “Pwi, lau mandra-an. Odu lewen marai tadam, atsasih song. ");
INSERT INTO ktm_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Odu ndre sulo-on keti madan tintoi. Odu ti lulo-ou pwi, lau mandra-an. Odu lau odo taheweh pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yosep ipe ile ta su ihpah, “Pwi! Oduu atsa ti atpa atsaturtur lok oh, kinum pe ndre omur atsapo pahun.” ");
INSERT INTO ktm_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Su hahpa, “Odu madan tintoi ndre sungoh-pe-rumuu, lau il. Nedun ke ndramat homou ilmin ndre Kenan. Tinto' odu homou ti indrimat, pe iy ndre omur lakopwi eri ilmin ndre ndrongon tama' odu.” ");
INSERT INTO ktm_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yosep ihpah, “Ihpa ke yu upwe tih! Oduu ti lulo-ou! ");
INSERT INTO ktm_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Uh oduu edenolou ndre ndrokene, eri yu we kuhtuno. Pe uh oduu edentaheweh, eri yu we kuhtuno yi. Ile pe yu udemumoi ile rangan king ihpa ndre oduu we etndre-au pwi, kenon ndre tinto' oduu lehyen lakopwi ti kise kertih. ");
INSERT INTO ktm_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Oduu homou we ala pe altakun iy. Oduu ndre sulo-on ti we atlato omwen kou oh uu kenon ndre hondrotureh ndre ndrokene odo sohou taduu tih. Uu pe pwi, eri yu upwe ndre ndrokene ile rangan king, oduu ti lulo-ou.” ");
INSERT INTO ktm_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ile pe iy iduwe su hala kou rang ndre tul. ");
INSERT INTO ktm_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Rang tul ndre ilnum ti pe Yosep ipe ile ta su ihpah, “Adahnan kihpa kuti we otto. Yu eri ndramat unoh ta Petngendrei. ");
INSERT INTO ktm_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Yu ka we kuduwe tawene sih. Uh, nolou oduu atpa ti ndre ndrokene, eri oduu homou we kimin ndre omwen kou ndre oduu otto eriy munen, pe oduu huren eri atakuni song ndre oduu etndresihnen eri kile hun morlo-e' oduu ndre hondruto pe ana' su song pwi, eri pe atla yi. ");
INSERT INTO ktm_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Kinum eri oduu we atakuni tinto' oduu ndre lehyen lakopwi eri kise. Kurti kile we kipahran kihpa ndre oduu otnosohou ndre ndrokene, pe we oduu etndremat pwi.” Su hapa huyen ");
INSERT INTO ktm_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","pe homou ipe ile ta homou ihpa, “Ndre ndrokene, tidu kah tidentakun pede-en odo handrai sa ndre tidu titpo ile tan tinto' tidu tih. Iy intamari iy ile ta tidu ti pe tidu titndrehrung iy pwi. Mehkele ti kah tidengkun pede-en oh.” ");
INSERT INTO ktm_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben ihpa, “Yu upwe sa ile taduu? Yu upwe oduu atawe ngendre-en kile tan anah ti kolwii, odoke oduu etndrehrung yu pwi tih. Ile pe etndre-et oh, mahkele tidu kah tidengkun ngendre-en odo mat tadan.” ");
INSERT INTO ktm_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yosep tunon sa su hampa ti, odoke su tuno' su pwi, odosa ndramat odo potuluwi nolou eri isopelwen nolou Isip ile ta su, pe isopelwen nolou Hibru ile ta Yosep tih. ");
INSERT INTO ktm_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yosep iyeu odo hu su pe iltang oh. Iy ihkalmanan ihpa ndre iyenon kisohou tasu yi, eri pe ise yi, ikuni Simeon pe hoswi iy imin ke ndre purmada' su. ");
INSERT INTO ktm_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yosep ipe ile ta su ndramat mada' su ise omwen song ipe su hedehen ndrop ta su ndre haltah kile song, pe heduwe mone-e' su hala ndre lon ndrop ta su yi, pe hotou ana' su ndremis odo sal. Su hahnan ihpa ndre eriy. ");
INSERT INTO ktm_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Su madan tintoi hetnokuhen donki hala song ndre su hesinen ti pe ha-au. ");
INSERT INTO ktm_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Lok ile lukumwen eri pe su hohndro hodo lok sehir, pe homou odo lenga’ su ti itpiri pohon ndrop tadan ipe kipu song kile tan donki, eri pe itureh moni idu ke ndre madan ndrop. ");
INSERT INTO ktm_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Iy iyuw ile tan tinton su ihpah, “Moni todo ti heduwe ise yi oh! Idu ke ndre madan ndrop todo kutih!” Su hehtelim. Honoh pe homou madan ile mada' homou pe hahpa, “Lapan ke impo sa ile pule-e' tidu kede?” ");
INSERT INTO ktm_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Idu iy ndre su hehir hun tama' su ke Yakop odo Kenan, eri su henen sane ndre sulo-on ndre hehir ta su, eri ile tadan. ");
INSERT INTO ktm_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Su henen ndralngan ihpah, “Ndramat ndre Gavena ta su Isip ti ihruto-on odu ile ke mo-on pe ipu nolou ipe odu ti lulo-ou pe atlaturtur kantri tadan. ");
INSERT INTO ktm_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Pe odu atpa ile tadan ihpah, ‘Odu ti lulo-ou pwi. Odu ndramat atsantaheweh pwi. ");
INSERT INTO ktm_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Odu ti madan tintoi ndre sungoh-pe-rumuu taman ke odu homou. Tinto odu homou ti indrimat, pe iy ndre omur tadu eri ilmin Kenan ndrodan tama’ odu.’ ");
INSERT INTO ktm_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Ndramat kurti ipe ihpa, ‘Oduu atpa atsantawehweh pwi, eri yu kah kuturtur odu kihpa kuti: Oduu homou we kimmin ndre hun yu. Oduu huren we atakuni song ana' su morlo-e' oduu ndre horyos holto ti pe atla yi. ");
INSERT INTO ktm_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Atakuni tinto' oduu lehyen ti kise hu yu. Kile pe yu we kuhtuno kihpa ndre oduu ti lulo-ou pwi, pe oduu ndramat edenosohou ndre ndrokene. Eri pe yu we kuduwe tinto' oduu kile yi, pe oduu we otto keti pe otpo suhen.’” ");
INSERT INTO ktm_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Inum ti pe idu su hotluluu song odo ndrop ise pwoi, eri pe su ndre sulo-on hetureh ndropon moni tasu ti he-en madan ndrop. Su hondroni ihpa kudu, eri su pe tama' su ke Yakop honoh. ");
INSERT INTO ktm_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Yakop ipe ile tasu ihpa, “Oduu kawe adahnan pe nedu' su hohpwi odo hu yu. Pihe ti Yosep. Inum ti pe Simeon. Pe kah kurti oduu atpa atakuni Benjamin ke-eu yi. Pede-en ndre sulo-on ti yu untakunii.” ");
INSERT INTO ktm_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruben ipe ile tan taman ihpa, “Ipe ye yu kundrokuni Benjamin kinsa ndre hun ou pwi, eri nedu horu ndre rumuu kamal eri ou eduwe horu harmat. Eduwe yu modo kise tadan pe we kukuni iy kise yi.” ");
INSERT INTO ktm_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Odoke Yakop ihpa, “Yu nedu we kindru-us ou kinna pwi. Tinton indrimat, pe iy ke homou imin. Kihne handrai ndre handrai kihir tadan odo sal. Yu kah mo-o lopu, pe ou we ahnan pe yu we kungkarndrum kopwi pe kihne kumwet.” ");
INSERT INTO ktm_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Song pwi odo Kenan eri ke ile mo-on lakopwi, ");
INSERT INTO ktm_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","pe song ndre su hokuni odo Isip ise eri Yakop pe su ndramat tadan handrani indrinum. Ile pe Yakop ipe ile tan nedun su, “Atla ndre Isip pe atlasihsih ana' tidu hepe song yi.” ");
INSERT INTO ktm_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Judah ipe ile tadan ihpa, “Ndramat kuti idemumoi pe ipe we odu etndrela ndrongon iy pwi yi kenon ndre tinto’ odu lehyen ti ki-us. ");
INSERT INTO ktm_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ipe ye ou eduwe tinto’ odu ti ki-us, eri odu we atla pe atlasih anam song. ");
INSERT INTO ktm_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Pe uh, ou endretawe iy kindru-us odu pwi, eri odu we etndrela pwi yi, odosa ndramat eti ipe we odu etndrela purmadan pwi kenon ndre odu atukuni tinto' odu lehyen ti ki-us.” ");
INSERT INTO ktm_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Yakop ihpah, “Ihpa kehe pe oduu etninen ndralngan orongon kiti atpa oduu tinto’ oduu homou yi? Oduu edentawe pede-en hudut ile mundre.” ");
INSERT INTO ktm_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Su hahpah, “Orongon ti iduwe ke iseu ile hehndremte odu. Iy impa ihpah, ‘Tama’ oduu ti mapwi ilmin? Odu homou tinto’ oduu yi ndre pwi?’ Iy inehndremte ke odu, ile pe odu atpahran ile tadan. Si tunon ipe ye iy we kipe kile tadu pe atakuni tinto’ odu ki-us odu kile?” ");
INSERT INTO ktm_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Judah ipe ile tan taman ihpah, “Eduwe anah ti ki-us yu, pe odu etportai atla, kile we ou pe odu pe nedu' odu we titndremat pwi. ");
INSERT INTO ktm_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Hangka-an kihrut kidu mundren eri we yu kumwet kile nuhen. Uh, odu atsa pe iy kindru-us odu pwi, eri pede-en odo eriy ti kile ngondru. ");
INSERT INTO ktm_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Lehpe ou andritakulkulen odu pwi, eri lehpe odu etndrela kah pe etndresa yi kihpa ndre peruweh kindrinum.” ");
INSERT INTO ktm_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Israel ipe ile tasu ihpa, “Uh kihpa ndre oduu atpa, eri we atakun se ndruwon sane huyene odo lok kerti kile presen tan Gavena. Atakun hepe resin, hepe wayen pakok, spais, mbrwen pastesio, pe almon. ");
INSERT INTO ktm_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","We atakun moni ti rundreh, odosa moni ndre idu lon ndrop pe ise yi eri we atakuni kile yi. Kihne erti su ha-amelyen su. ");
INSERT INTO ktm_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Atakuni tinto' oduu pe atla sowin kopwi. ");
INSERT INTO ktm_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Lapan Mandra-an kihnan ndramat eti pe kikarndrum oduu, kile pe Iy kiduwe Benjamin pe tinto' oduu homou yi ti harsa ndrodan oduu yi. Yu ti konan. Uh su nedu halla ke hepe kihpa kudu, eri poh kidu todo kolwii. Iy erti kawe kinahpa eriy ea.” ");
INSERT INTO ktm_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ile pe su madan tintoi hokuni presen, pe hokuni moni eri rundreh, pe halla ile Isip ndrodan ndre Benjamin. Su hehir Isip ti pe ndresale hala hu Yosep. ");
INSERT INTO ktm_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Idu ke ndre iy indroni Benjamin idu lenga' su, eri pe ipe ile ta lewen marai madan iso um tadan ihpah, “Ekuni su ndramat kurti hala um todo. Su we hoyo-on song ndroda yu kidu worohnuw. Ala pe olroh homou ka-an pe alahnan kile misen.” ");
INSERT INTO ktm_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Lewen marai ihnan ihpa ndre Yosep ipe ile tadan ti pe ikuni su madan tintoi ile um ta Yosep. ");
INSERT INTO ktm_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Su mapwi halila ile um eri pe hantawene hutun ihpa, “Su hantakun tidu titlalih um kurti pwi ti we odo moni munen tidu titsa pe heduwe halla ndre lon ndrop tatidu ti ndreh? Tidu we tidehretek pe su heseroroput hasa pule-e’ tidu, hekuni donki ta tidu, pe hahnan tidu titla lewen marai tadan.” ");
INSERT INTO ktm_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Su mapwi hodo madan pohngkiu odo um ta Yosep, eri pe hala hu lewen marai madan iso um ta Yosep pe hapa ihpa, ");
INSERT INTO ktm_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Oh lau il, odu atsasihsih song petsih kah odo kertih. ");
INSERT INTO ktm_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Odu ada-au ile yi eri pe etmetir otso sal, pe etiper ndropo song tadu ti pe etureh moni tadu ti ndre sulo-on, hendrek indra-au pwi. Idu ke ndre madan ndrop. ");
INSERT INTO ktm_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ile pe odu atakuni moni ti ise yi, ile ndrodan ndre moni hondroh yi odo sihsih ana' odu song kile eriy tih. Odu tuno' odu si iduwe moni ile ndre lon ndrop tadu ti pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Lewen marai ihpa, “Atawene kolwii pe nombrun otnoh. Moni eri oduu atawe ise lumwe. Kihne Lapan taduu, Lapan tan tama' oduu, ti kindretawe moni ti hala ndre lon ndrop taduu yi.” Inum pe iy ikuni Simeon odo lon kou ise hu su. ");
INSERT INTO ktm_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Lewen marai ikuni su madan tintoi ti hala lon um. Iy iduwe wo odo singi ndrike' su. Pe su donki eri iy itou song ile ta su. ");
INSERT INTO ktm_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Su hokuni presen ndre su hopo ta Yosep ti hasa moleu, pe hodo hengkeli-iy Yosep kise um worohnuw. Su hendretahrungi ihpa ndre su ti we hoyo-on song ndrodan iy worohnuw. ");
INSERT INTO ktm_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Idu Yosep ihir ise um ti pe su hokuni presen tasu idu hu su idu um ti ile hun iy, pe hopo ruru ile ndre poi he-en purmadan. ");
INSERT INTO ktm_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Inum pe iy ihndremte su odo sik pe horut, pe su hapa huyen ke su, ile pe iy ihndremte yi tama' su, “Tama’ oduu lopun pihe oduu etninen ndrolngo ti mapwi ilmin?” ");
INSERT INTO ktm_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Su hahpah, “Mandra-an, tama' odu eri mapwi ilmin pe mapwi puko-on.” Inum pe su heduwe pandrulku-u' su ndre rukei ile pwoi pe hopo ruru ile tadan. ");
INSERT INTO ktm_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yosep indroni tinton ke Benjamin, tine' horu homou, eri pe ihpah, “Iy kurti tinto' oduu lehyen omur ndre oduu etninen ndrolngo ile eriy tih? Lapan ipu blesim ou, nedu.” ");
INSERT INTO ktm_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yosep indroni tinton ti pe kolon isup. Iy ihndrepet iy tahit, ile pe iyeu ile lo rum sih yi pe iltang. ");
INSERT INTO ktm_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Iy ideng oh pe inuhen purmadan pe ise ndre rang. Kolon mapwi insop odoke ititsan ke iy pe ipe ile ta lewen marai kide ana' su song. ");
INSERT INTO ktm_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yosep tepolon sih pe tinton su ndre tepolo' su sih. Su Isip hana-an song honto um ta Yosep eri ndre tepolo' su yi, odosa su Isip henehmbore su iy ndre su pe su Hibru hoyo-on song hodo hondroh tih. ");
INSERT INTO ktm_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Su madan tintoi hodo pwoi eri mada' su ile hu Yosep ea. Sa hesehen su he-en sia ti ile pahndran krismas tasu ea. Kom ndrihou imin ndre mune, inum pe iy omur tadan, inum pe homou yi, ilto ndre kom omur. Su heltuwe kurti pe hehretek ile eriy. ");
INSERT INTO ktm_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Song ti idu tepol ta Yosep, pe lewen marai ide ana' su. Song anan Benjamin ti ihluwen tasu ndre sulo-on, ihpa ndre ana' su ndramat limuu. Su hoyo-on song pe he-ing ndrodan Yosep uu pe ilta ndre su ile mo-on. ");
INSERT INTO ktm_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yosep ipe nolou ile ta lewen marai tadan madan iso um ti ihpah, “Edehen ndrop tasu kile song ti uu kenon ndre su we hanon hesorii, pe eduwe mone-e' su kile ndre madan ndropo' su yi. ");
INSERT INTO ktm_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Eduwe kap silwa todo ti kimin madan ndrop tan iy ndre lehyen lakopwi ti, kile ndrodan ndre moni tadan odo sihsih song.” Iy iduwe iyin ihpa ke ndre Yosep ipe tih. ");
INSERT INTO ktm_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Idu maping ndre lik ti pe su lewen marai hapa ile tasu madan tintoi ti hapa su ha-au. Su hokuni donki ta su pe ha-au yi. ");
INSERT INTO ktm_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Su hanna alau odo siti mapwi, eri pe Yosep ipe ile ta lewen marai madan iso um tadan ihpa, “Oporitai odo ndruwe’ su ndramat kurtih. Osopudi su, eri ehndremte su kihpa, ‘Odu otpo huyen ile taduu pe ihpa kehe pe oduu otpo mo-on tih? ");
INSERT INTO ktm_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ihpa kehe pe oduu atpahno-o kap silwa ta mandra-an todo tih? Tapa kap kuti iy ini-ing illa eriy, pe intahu ah illa eriy yi. Punou oduu otpo kiti mo-on lakopwi.’” ");
INSERT INTO ktm_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Idu iy ndre lewen marai isopudi su, eri pe ipe ke ndre sohou iy ndre Yosep ipe ile tadan ile eriy tih. ");
INSERT INTO ktm_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Su hapa ile tadan ihpa, “Mandra-an, ou ampa sa? Odu otut odo nolou ou ampa tih. Odu tuno' odu hangka-an pwi. Odu edenolou ndre ndrokene. ");
INSERT INTO ktm_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ou tunom ihpa ndre odu atakuni moni iy ndre odu otureh idu madan ndrop tadu, eri odu atakuni odo Kenan ti hasa yi tih. Ihpa yi kehe pe odu we atpahna gol ndre silwa odo lon omwen mandra-an tadam tih? ");
INSERT INTO ktm_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Lau il, ipe ye ou otureh odu homou kerti kikuni, eri we heduwe iy kimet, pe odu ndre sulo-on we atla lewen marai tadam.” ");
INSERT INTO ktm_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Iy ihpa, “Huyen, yu wasu-u, odoke tapa iy ndre ikuni kap eri we kile lewen marai todo. Oduu huren ti we ada-au kile.” ");
INSERT INTO ktm_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ile pe su hoportai heduwe ndrop tasu hala pwoi, pe su homou homou itpiri madan ndrop. ");
INSERT INTO ktm_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Lewen marai ta Yosep iturtur iyehiy lakopwi, ide lin hereh idu tan kom ndrihou ti uu pe ilto ndre tan iy omur tasu. Eri pe itureh kap ti imin lon ndrop tan Benjamin. ");
INSERT INTO ktm_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Su hakarndrum pe here-e kolso' su. Su heduwe ndrop hala ndre pule-en donki pe hala ndre siti yi. ");
INSERT INTO ktm_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Idu Judah pe tinton su hehir um ta Yosep, eri iy mapwi imin eriy. Su hopo ruru ile tadan, ");
INSERT INTO ktm_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","pe Yosep ihpa, “Handrai sa ndre oduu otpo kuti? Oduu tuno' oduu sa ndramat ihpa ndre yu ti mulou hampaninye sane ile tasu ti ndre pwi?” ");
INSERT INTO ktm_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Judah ihpa, “Mandra-an, odu we atpa sa kile tadam? Odu we edehkike-ei kihpa kehe? Odu we otruprup odu kihpa kehe? Lapan indretureh horut tadu. Odu ndre sulo-on we atla ndrodan ndramat ndre ikuni kap ti pe atla lewen marai tadam.” ");
INSERT INTO ktm_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yosep ihpa, “Pwi ndre pwi! We kindrahpa kiti pwi! Tapa iy ndramat kap imin hun iy eri we kile lewen marai todo. Oduu huren eri ada-au ndre huye' oduu atla ndrongon tama' oduu.” ");
INSERT INTO ktm_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Judah illa ile hu Yosep pe ipe ihpa, “Oh, Lau Mandra-an, eduwe yu kusohou hepe oh. Lon ndrinem kinei todo kolwii, ou eri ahpa ke king tih. ");
INSERT INTO ktm_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mandra-an, ou ehndremte odu ihpa, ‘Oduu tama' oduu pe homou tinto oduu yi ndre pwi?’ ");
INSERT INTO ktm_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Odu adahpa, ‘Odu tama' odu kah lopun pe tinto odu homou omur. Tama' odu ile ndre lopun pe heduwe iy. Tinton eri indrimat pe iy ke homou mapwi imin. Iy pe tinton eri tine' horu homou, pe taman eden iy lakopwi.’ ");
INSERT INTO ktm_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Mandra-an, ou apa odu atakuni iy kise keti, kile we ou endre-et iy, ");
INSERT INTO ktm_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","pe odu atpa ile tadam ihpa ndre anah kuti we kindra-au odo hun taman pwi. Uh iy ke-eu, eri taman kihne kimet. ");
INSERT INTO ktm_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Inum pe ou ahpa, ‘Atsa purmodo kolwii kenon ndre oduu atakuni tinto' oduu lehyen ti ki-us oduu kise tih.’ ");
INSERT INTO ktm_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Lau Mandra-an, ou ti mandra-an tan tama' odu yi. Idu iy ndre odu atla ndre hun tama' odu yi, eri pe etninen sa ndre ou apa ti ile tadan ndre ilnum. ");
INSERT INTO ktm_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Inum ti pe iy ipe odu atsa yi pe atsasih ana' odu hepe song. ");
INSERT INTO ktm_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Odu adahpa, ‘Odu we etndrela pwi. Odu we etndrela purmadan ndramat kurti pwi kenon ndre tinto' odu lehyen ti kimin lenga' odu. Odu we atla, ipe ye tinto' odu lehyen ti ki-us.’ ");
INSERT INTO ktm_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Tama' odu ipe ile tadu ihpa, ‘Oduu tuno' oduu yu ti nedu ke rumuu tam mbrulu ke Resel tih. ");
INSERT INTO ktm_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Homou eri indra-au todo. Sane ka-an puyep pwi ti kihne hondrurotasi iy ile ke hepe-eu ea pe handrani iy, odosa idu ke ndre eti uu pe isto mehkele, eri yu hepe modo indrito tadan mapwi. ");
INSERT INTO ktm_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ipe ye oduu atakuni ye homou kuti ke-eu odo hu yu pe hangka-an kihrut kidu mundren, eri yu kah lopu, pe kihne kukarndrum uu pe kumwet.’” ");
INSERT INTO ktm_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Judah isohou yi, “Mandra-an, mehkele yu kule hun tomo uu pe anah kurti kindru-us yu pwi, pe iy kindre-et pe anah ti pwi, eri iy we kimet. Iy eden anah ti lakopwi, pe iy kah mo-on lopun. Iy we kikarndrum pe kihne kimet. ");
INSERT INTO ktm_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Yu udemumoi ile tan tomo odo tan anah kutih. Yu upwe ile tadan ihpa ndre uh yu kundrekuni anah kuti kinna ndre hun iy pwi, eri pede-en odo eriy ti yu we kussor kopwi uu pe kulmat kopwi. ");
INSERT INTO ktm_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Ile pe, Mandra-an, mehkele eri yu we kusini ndruhun anah kurti kule lewen marai tadam kumwin ndre kede, pe iy eri eduwe iy ki-us su tinton pe ke-eu kile yi. ");
INSERT INTO ktm_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Yu kule yi ndre ndrongon tomo pe anah ti kindrimin ndroda yu pwi, eri mada. Yu mbori iy ndre kundre-et tomo kile handrai ndre handrai tih.” ");
INSERT INTO ktm_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yosep karundrum tadan ile ta su tinton eri ke ile puko-on lakopwi. Iy ihndrepet iy idu mada' su lewen marai tadan tahit, ile pe iy ipe ile ta su ha-au odo rum hala kiu. Homou ndramat indrimin yi ndroda su pwi idu iy ndre Yosep ipe ile ta su tinton tih. ");
INSERT INTO ktm_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Iy iru-iy ile mandra-an pe su Isip hehrungii, pe ninen ile hu su lewen king. ");
INSERT INTO ktm_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yosep ipe ile tan tinton su ihpa, “Yu ti Yosep. Tomo ti mapwi ilmin?” Odoke tinton su hehrungi iy ipe kudu, eri pe su honnoh ile mo-on lakopwi pe homou insohou hepe pwi. ");
INSERT INTO ktm_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Inum ti pe Yosep ipe ile ta su, “Iyenon oduu atsa mukehe hu yu.” Eri pe su hala mukehe pe iy ihpa, “Yu ti tinto' oduu ke Yosep tih. Oduu atawe yu ule lumwe' su Midian pe su hesihnen yu, pe hekuni yu use Isip tih. ");
INSERT INTO ktm_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Tawene taduu kihrut pe edehtuduwen oduu kile eriy kolwii. Ndre ndrokene tadan, eri Lapan ikuni yu use munen taduu odo we kusetawe mandro-o' sa ndramat hodo huyen, pe handrimat pwi. ");
INSERT INTO ktm_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Song inum odo lok keti eri krismas ruweh ke indrinum pe limweh mapwi, ile pe sa ndramat we hondrupo maryan song mapwi. ");
INSERT INTO ktm_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Lapan iduwe yu ise munen taduu, kile we kuhnuwii oduu ada-au odo lo horut kuti, pe yaya' oduu we hendrisih pwi. ");
INSERT INTO ktm_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Lapan iduwe yu use kerti, oduu ti pwi. Iy iduwe yu modo ise pule-e' su opisa ndre sulo-on tan king. Sane ndre sulo-on odo lok ndre mandra-an kerti ise lumwe. Lok ndre mandra-an Isip eri imin ke pohndro. ");
INSERT INTO ktm_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Etportai atla hun tomo mehkele koson pe atpa kile tadan kile nolwo-on nedun ke Yosep kihpa: ‘Lapan iduwe yu modo ise Isip ndre mandra-an. Asa hu yu sowin kopwi. Adakulkul kolwii. ");
INSERT INTO ktm_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ou we emin Gosen, kile we emin mukehe hu yu. Ou pe nedum su, papum su, tadam sipsip, tadam meme, tadam makau, pe ndrodan ndre sane tadam ndre sulo-on. ");
INSERT INTO ktm_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ipe ye ou emin Gosen, eri we yu modo kise tadam. Krismas limweh odo song pwi eri mapwi idu, pe yu mbori iy ndre ou, ndramtam su, pe sane ka-an tadam atmat ta song tih!” ");
INSERT INTO ktm_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yosep isohou lakopwi, “Mehkele oduu ndre sulo-on kiti, pe ou yi Benjamin, etndrendroni ile mada' oduu ihpa ndre yu eri Yosep ndre ndrokene unosohou ile taduu tih. ");
INSERT INTO ktm_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Atpa kile tan tomo ihpa ndre yu eri kohkoh homou odo Isip, pe etninen ndralngan kile sane ndre sulo-on ndre oduu etndrendronii tih. Kinum oh pe otportai atakuni iy kise kede.” ");
INSERT INTO ktm_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Iy isokohan tinton ke Benjamin pe iru-iy, pe Benjamin ideng yi. ");
INSERT INTO ktm_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Iy mapwi intang eri pe isokohan tinton homou pe homou pe ihngwi purmada' su. Ndruwen kuti pe tinton su kah hosohou ile tadan. ");
INSERT INTO ktm_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ninen ihir pales ihpa ndre tinton Yosep su ti hansa, eri pe king pe su opisa tadan ndre sulo-on hopwo-es lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","King ipe ile ta Yosep, “Apa kile tan tintom su heduwe sane tasu hala pule-en donki pe hala ndre Kenan yi. ");
INSERT INTO ktm_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Eduwe su hala haltakuni tama' su pe ndramta' su pe hasa yi ndre ketih. Yu we kuduwe poi mandra-an hombrul odo Isip ndre huyen lakopwi odo tohe sane eri kile ta su, kile we su handrimat song pwi. ");
INSERT INTO ktm_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Apa kile tasu hokun se wil karis odo Isip, odo takun mbrulu' su pe nedu' su mo-one, pe hokuni tama' su ndrodan. ");
INSERT INTO ktm_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Handrai sa tasu ndre hendrekunii kinsa pwi eri hadawene kile eriy kolwii, odosa sane iy ndre huye' su lakopwi odo Isip eri we kile tasu.” ");
INSERT INTO ktm_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ile pe su nedun Yakop hahnan ihpa ndre hapa ile tasu tih. Yosep iduwe wil karis hala ta su, ihpa ndre king ipe ti pe ile ndrodan ndre ana' su song odo lila-a' su ha-au yi tih. ");
INSERT INTO ktm_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Iy ihngahang kolos sihsih ile ta su homou homou odo senis, odoke Benjamin eri iy iduwe ndralahan silwa ndre tulpweu pe kolson ndre limweh. ");
INSERT INTO ktm_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Taman eri iy ipu tadan sane ndre huyene lakopwi odo Isip, pe iduwe hala pule-en donki kamal ndre siyul. Donki siyul yi ndrukwil, eri heduwe wit pe bret, pe song se yi odo lila-an taman we kise Isip tih. ");
INSERT INTO ktm_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Iy idapipan tinton su kah ha-au, pe ipe ile ta su ihpa, “Atlapa oduu odo sal kolwii.” ");
INSERT INTO ktm_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Su ha-au odo Isip pe hala ndre hun tama' su ke Yakop odo pule-en poi Kenan. ");
INSERT INTO ktm_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Su henen ndralngan tama' su ihpah, “Yosep ti mapwi imin! Iy ti madan ise pule-en lok Isip ndre mandra-an!” Yakop saman iyer, odoke ipe ye su hantaheweh. ");
INSERT INTO ktm_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Odoke su henen sane nolou iy ndre Yosep ipe ile tasu ile eriy, pe iy indroni wil karis ndre Yosep idepipan odo takun iy ile Isip, eri pe tawene tadan ise ndre hun iy yi. ");
INSERT INTO ktm_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Pe Israel ipe ihpa, “Kah ndre ndrokene. Nedu ke Yosep ti mapwi imin. Yu we kule pe kulndre-et iy oh pe kah kumwet.” ");
INSERT INTO ktm_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ile pe Israel idekukohon tadan sane ndre sulo-on pe itlang ile Isip. Iy ihir Berseba ti pe isurok pe itnu-en yohou ile ofa ile ndrongo Lapan tan taman ke Aisak. ");
INSERT INTO ktm_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Lukumwen ti pe Lapan ihir hun Israel ile hangka-an ihpa ndre mimih, pe iyuw ihpa, “Yakop, Yakop.” Yakop ihpa, “Ah? Yu umwin.” ");
INSERT INTO ktm_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Lapan ipe ihpah, “Yu Lapan. Yu Lapan tan tamam. Ou onoh odo we ala Isip ti kolwii. Yu we kuhnan nedum su pe ombrum we hala sulo-on odo eriy. ");
INSERT INTO ktm_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Yu we ku-us ou kule Isip, pe we kukuni ou asa ndre lok keti yi. Pe nedum ndre Yosep ti we kimin kosum kidu mundrun mat tadam.” ");
INSERT INTO ktm_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Inum pe Yakop itlang odo Berseba. Nedun su kamal heduwe iy ile lon karis ndre king odo Isip idepipan tih. Kom mone pe su pedih ti hala lon karis yi. ");
INSERT INTO ktm_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Su hokuni sane ka-an ndre sulo-on ho-us su. Sane ndre sulo-on tasu odo Kenan ti su hokuni ndrodan, pe ha-au hala Isip. ");
INSERT INTO ktm_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Iy ikuni nedun pe papon su ndre sulo-on hala Isip. ");
INSERT INTO ktm_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ranga' su nedun Israel kamal pe papon su ndre ho-us iy hala Isip ti kurtih: Ruben ti tolun kom ta Yakop. ");
INSERT INTO ktm_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruben ti nedun kamal hamou: Hanok, Palu, Hesron pe Karmi. ");
INSERT INTO ktm_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Su nedun Simeon kamal eri Jemuel, Jamin, Ohat, Jakin, Sohar pe Saul. Tinen Saul eri pedih odo Kenan. ");
INSERT INTO ktm_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Su nedun Livai kamal eri Gerson, Kohat pe Merari. ");
INSERT INTO ktm_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Su nedun Judah kamal eri Er, Onan, Selah, Peres, pe Serah. (Odoke Er horu Onan harmat odo ndre Kenan.) Su nedun Peres kamal eri Hesron pe Hamul. ");
INSERT INTO ktm_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Su nedun Isakar kamal eri Tola, Puvah, Iop pe Simron. ");
INSERT INTO ktm_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Su nedun Sebulun kamal eri Seret, Elon pe Jalel. ");
INSERT INTO ktm_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ruben, Simeon, Livai, Judah, Isakar pe Sebulun ti su nedun Leah, mbrulun Yakop. Leah iduwe nedun su kurti odo ndre Mesopotemia. Leah iduwe nedun homou pedih yi rangan Dainah. Su nedun Yakop pe papon su ta Leah ti ndre tulngeh-pe-tulmuu. ");
INSERT INTO ktm_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Su nedun Gat kamal ti rangan su kurti: Sifion, Hagi, Suni, Esbon, Eri, Arodi, pe Areli. ");
INSERT INTO ktm_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Su nedun Aser kamal eri Imnah, Isvah, Isi pe Beriah, pe timso-o' su eri Serah. Nedun Beriah kamal ti Heber pe Malkiel. ");
INSERT INTO ktm_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Su kamal pe pedih, nedun pe papon Yakop horu Silpah, lewen marai ta Leah, eri ndre sungoh-pe-onmou. ");
INSERT INTO ktm_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Nedun Yakop tam mbrulun ke Resel ti rumuu kopwi: Yosep pe Benjamin. ");
INSERT INTO ktm_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yosep imin Isip ti pe iyesuwon Asenat, taman ti Potifera, pris odo Heliopolis. Asenat iduwe nedun Yosep kamal rumuu: Manaseh pe Efraim. ");
INSERT INTO ktm_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamin nedun su kamal ti Bela, Beker, Asbel, Gera, Naman, Ehi, Ros, Mupim, Hupim pe Art. ");
INSERT INTO ktm_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Yakop nedun pe papon su odo tam mbrulun Resel, ti su ndre sungoh-pe-hamou. ");
INSERT INTO ktm_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan eri nedun ke homou kamal, Husim. ");
INSERT INTO ktm_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naptali nedun kamal ti Jasel, Guni, Jeser pe Silem. ");
INSERT INTO ktm_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Yakop nedun pe papon tam mbrulun ndre Bilhah eri su ke ndrotulmuu. Bilhah ti pedih lewen marai ndre Laban iduwe ile henuwii Resel. ");
INSERT INTO ktm_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Su ndrayen Yakop ndre sulo-on hala Isip ti ndre onngoh-pe-onmou. Hondrundrumon su pedih mbrulun nedun su ti pwi. ");
INSERT INTO ktm_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yosep nedun kamal ndre rumuu eri hermin Isip. Ile pe Yakop nedun pe papon ndre sulo-on ndre hohntok hala Isip ti ndre ndrotulngeh. ");
INSERT INTO ktm_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakop ihtakalan Judah ile munen ipe iy kile pe kilpa kile ta Yosep pe kisondrih su kise Gosen. Yakop su hehir Gosen ti pe ");
INSERT INTO ktm_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yosep ipe ile ta su lewen marai tadan haltakuni karis pe iy indreh ile eriy, pe ilsondrih taman ile Gosen. Yosep iltuwe taman ti pe iyahah ile won taman pe ideng elwe-en lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israel ipe ile ta Yosep ihpa, “Yo nedu, ndre ndrokene ou mapwi emin. Yu kah kumwet ti huyen, odo yu ko undrendre-et ou tih.” ");
INSERT INTO ktm_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Inum ti pe Yosep ipe ile tasu ndre sulo-on ihpah, “Yu we kule pe kulpa kile tan king kihpa ndre tinto pe lewen tomo su ndre sulo-on ndre honto Kenan eri kah hansa. ");
INSERT INTO ktm_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Yu we kulpa kile tadan kihpa ndre oduu, eri ndramat odo mada' oduu iso sane ka-an. Yu we kulpa kupwe oduu atsa ti pe atakuni sipsip, meme, makau, pe taduu sane ndre sulo-on. ");
INSERT INTO ktm_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Uh king kiyuw oduu pe kihndremte kile marai sa oduu odompo, ");
INSERT INTO ktm_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","eri atpa kile tadan kihpa ndre oduu ti lau odo hangahang sane ka-an, ihpa ndre su tinembro' oduu hompo tih. Ipe ye oduu adahnan kihpa kudu eri we iy kiduwe oduu otto ndre poi mandra-an odo Gosen. Yosep ipunou ihpa kudu odosa, iy tunon ihpa ndre su Isip ti hosonto hondroh ndroda su ndramat ndre mada' su iso sane ka-an ti pwi tih. ");
INSERT INTO ktm_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Ile pe Yosep ikuni tinton su limuu pe hala ndrongon king. Iy ipe ile tan king ihpa, “Tomo pe tinto su hondroh Kenan hansa pe hekuni sane ka-an tasu ndre sulo-on ndrodan. Su kah hansa pe holto Gosen.” ");
INSERT INTO ktm_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Inum pe iy iduwe tinton su hala purmadan king. ");
INSERT INTO ktm_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","King ihndremte su ihpa, “Oduu odompo marai sa lakopwi?” Su hapa ihpa, “Odu ti ndramat odo mada' odu iso sane ka-an ihpa ndre su papo’ odu ndre pihe hompo tih. ");
INSERT INTO ktm_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Odu ada-au atsa lok keti odosa Kenan eri song pwi, pe sane mundriu anan sane ka-an tadu ti hondrunum yi. Odu atpa ou apahran pe odu otto ndre poi mandra-an odo Gosen.” ");
INSERT INTO ktm_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","King ipe ile ta Yosep, “Ou tamam pe tintom su eri kah hansa Isip. ");
INSERT INTO ktm_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Handrai sa su hapa hopo, eri hopo kile reh tasu. Poi mandra-an odo Gosen ti huyen lakopwi. Eduwe su hamandro hodo eriy. Pe uh lehpe se ndramat huye' su odo lenga' su, eri eduwe su he-en munen su ndramat ndre mada’ su iso sane ka-an todo tih.” ");
INSERT INTO ktm_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Inum ti pe Yosep ikuni taman ke Yakop pe ile purmadan king. Yakop ipatihteh king oh pe ");
INSERT INTO ktm_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","king ihndremte iy, “Ou krismas tadam kah heski?” ");
INSERT INTO ktm_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakop ihpa, “Yu unelila pe unemandro kopwi sehir ile sehir, pe krismas todo ke inna puken sangat-pe-tulngeh. Krismas kurti sulo-on pwi, pe mandro todo ti indrihir huyen ndre erti pwi. Tomo pe papu su ti hodo elwe-en lakopwi, pe mandro-o' su ti huyen hepe.” ");
INSERT INTO ktm_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Inum pe Yakop ipatihteh king ndre petsih yi oh pe iyeu. ");
INSERT INTO ktm_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","King ipe, ile pe Yosep iduwe taman pe tinton su hodo Isip. Su hamandro hodo Gosen, pe Yosep itlangan poi hombrul pe hombrul odo mukehe Rameses Siti ti hala tasu. Poi erti mbrule lakopwi odo lon Isip ndre mandra-an. ");
INSERT INTO ktm_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yosep intawe song anan taman pe tinton su. Su ndramtan taman ndre sulo-on, ile ndrodan ndre kom mone ti iy intawe ndre ana' su song yi. ");
INSERT INTO ktm_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Song inum lakopwi odo lok ndre mandra-an, pe sa ndramat odo Isip pe Kenan helkis ta song. ");
INSERT INTO ktm_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yosep intakuni moni ndre sa henesihsih song ile eriy ti pe ilentawe illa um mandra-an tan king, sa heneyuwen ile pales. ");
INSERT INTO ktm_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Moni ta sa ndramat ndre sulo-on odo Isip pe Kenan ti inum, ile pe sa lau odo Isip hala ndrongo Yosep pe hapa ihpa, “Ana' odu song pe mone-e' odu hondrunum ndresale. Endre-et kile eriy, pwi ti odu we atmat.” ");
INSERT INTO ktm_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yosep ihpa, “Oduu atpa mone-e' oduu hondrunum ndresale eri kah atakuni sane ka-an taduu ti hasa pe otpo suhen kile song.” ");
INSERT INTO ktm_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ile pe su haltakuni hos, sipsip, meme, makau, pe donki tasu hala hu Yosep pe hopo suhen ile song. Idu krismas eriy, eri sa henesihsih song ile ke sipsip, meme, donki, makau, pe hos. ");
INSERT INTO ktm_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Krismas eti inum, pe ile krismas sih yi ti pe sa hala ndre ndrongon Yosep, pe hapa ihpa, “Lau Mandra-an, odu we etndretungyon nolou pwi. Mone-e' odu hondrunum pe sane ka-an tadu ti ou ondrokuni indrinum yi. Odu kah hepe hangka-an indrimin yi odo sihsih ana' odu song kile eriy ti pwi, tapake odu sengin ndramat pe poiye' odu. ");
INSERT INTO ktm_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Endre-et kile eriy, pwi ti odu we atmat. Esihnen odu pe poi tadu kile song, pe odu kah atla hono-on marai tan king, pe iy kah kile taman poi tadu. Angahang odu song kile we odu atndremat pwi. Ahngahang odu pedun sane song odo tohe pe odu atlatohon hala poi, kile pe poi he-en ke porah kolwii. ");
INSERT INTO ktm_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Yosep isihnen poi ndre sulo-on odo Isip pe ile poyen king. Song ti kah pwi lakopwi, ile pe su Isip we handranon hondrupo hangka-an pwi, tapake we heduwe poi hala sihsih. Ile pe poi ndre sulo-on hala ke poyen king. ");
INSERT INTO ktm_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yosep ipu ihpa kuti pe ihnan ndramat ndre sulo-on odo Isip, idu ndrongon hodoh pe ilto hodoh, eri hala ke lewen marai tan king. ");
INSERT INTO ktm_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Tapake poi ndre hoso lumwe' su pris ti Yosep insihnen pwi. Su pris ti hantakun song odo ndrongon king, ile pe su handrimat song pwi. Iy erti uu pe su hondrupo salim poye' su pwi tih. ");
INSERT INTO ktm_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yosep ipe ile ta sa lau ihpa, “Oduu etndrendronii, yu unsihnen oduu ndrodan ndre poi taduu, ile pe king kah tadan oduu. Poi taduu ti hanna poyen king yi. Ile pe podun sane ndre oduu atpa we etutuhe ti kurtih. ");
INSERT INTO ktm_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Kidu rang ndre sane kuti hala mandran pe oduu atakun, eri we edentalengan killa ndre limndreh. Handroh ti ana’ oduu, pe hondroh ti kise tan king. Taduu ti ana' oduu odo yo-on pe se ti odo tohe.” ");
INSERT INTO ktm_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Su hapa ihpa, “Ou ahnan pe odu etndremat pwi, lau mandra-an, ile pe odu ka we atla lewen marai tan king.” ");
INSERT INTO ktm_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ile pe tawene Yosep iduwei ndre song hondroh odo lo' su ndre limndreh ti we killa tan king, eri ihir ile lo. Puko-on ta lo kurti mehkele eri mapwi ilto Isip ihpa ke ndre eriy. Tapake poi ndre hoso lumwe' su pris eri poye’ su hoso ke ndre lumwe' su. ");
INSERT INTO ktm_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Su Israel hoso Isip ti pe hamandro hodo Gosen. Su hohor hala sulo-on, pe hala tama' sane sulo-on. ");
INSERT INTO ktm_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakop imin Isip ti krismas sungoh-pe-ondrotoloh. Pe kah krismas tadan ihntok eri sangat-pe-hangoh-pe-ondrotoloh. ");
INSERT INTO ktm_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Yakop tunon mundrun mat tadan ti kah mukehe, ile pe iy iyuwen nedun ke Yosep pe ipe ile tadan ihpa, “Eduwe lumwem kise pahndran po pe adamumoi kihpa ndre ou we endretoni yu kundruto lok keti pwi. ");
INSERT INTO ktm_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Lok ndre hodoni tomo su holto eriy, eri ou oltoni yu kule yi ndre eriy. Okuni yu ku-eu odo Isip pe oltoni yu kule ndroda su.” Yosep ihpa, “Yu we kuhnan kihpa ndre ou apa tih.” ");
INSERT INTO ktm_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakop ihpa, “Eri adamumoi kihpa ndre ou we ahnan ndre ndrokene tih.” Yosep idamumoi. Ile pe Israel imin ke ndre pule-en sau pe isurok pe ide urehen Lapan. ");
INSERT INTO ktm_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ndruwen sane ndre sulo-on eti honum pe isto ndre omur yi, eri Yosep ihrung ihpa ndre taman ile sik idu poi. Ile pe iy ikuni nedun horu ndre rumuu, Manaseh pe Efraim, pe ile ilndre-et Yakop. ");
INSERT INTO ktm_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Sa homou inen ndralngan Yakop ihpa ndre nedun ke Yosep eri insa isendre-et iy, ile pe iy ititsan ke iy pe imin eleng pule-en sau tadan. ");
INSERT INTO ktm_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakop ipe ihpa, “Lapan Petngendrei ihir hu yu odo Lus, odo Kenan pe ipatihi yu. ");
INSERT INTO ktm_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Iy ipe ile todo ihpa, ‘Yu we kuhngahang ou kom sulo-on, kile pe yayam we hehir kile lok sulo-on. Yu we kuduwe lok kuti kile lonen yayam su ndresale.’” ");
INSERT INTO ktm_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yakop ipe yi ihpah, “Yosep, kom tadam ndre rumuu, iy ndre yu unsa Isip mapwi pe tine' horu iduwe horu, eri nedu. Efraim pe Manaseh eri harahpa ke ndre kom ndre rumuu todo kamal, Ruben pe Simeon. ");
INSERT INTO ktm_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ipe ye ou olpo se nedum kamal omur yi, eri su eti we nedum, pe we hokun poi pe sane se yi eri we hala pahndran Efraim pe Manaseh ea. ");
INSERT INTO ktm_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Yu umpo kurti odosa, tinem ke Resel ti imet, idu iy ndre yu mapwi uwus Mesopotemia upwe kule yi ndre Kenan tih. Iy imet odo ndrokoron sal, kah mukehe odo Efrata. Pe yu udoni iy idu ndre ngerin sal illa Efrata.” Efrata rangan mahkele ti Betlehem. ");
INSERT INTO ktm_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israel indroni horu kom kamal nedun Yosep, eri pe ihndremte, “Horu kom kurti nedun si?” ");
INSERT INTO ktm_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yosep ihpa, “Iy kurti horu nedu, iy ndre yu umwin kede pe Lapan ihlingi yu tih.” Israel ihpa, “Okuni horu harsa, kile pe yu kupatihteh horu.” ");
INSERT INTO ktm_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Madan Israel eri indrekureu odosa iy ke inna lopun ndresale, pe kah isenendre-et isenehii pwi. Yosep iduwe horu kom ti harla hun iy, pe iy idekepti horu idu kanahan pe ihngwi purmada’ horu. ");
INSERT INTO ktm_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Yakop ipe ile ta Yosep, “Yu upwe ye kundrendre-et ou pwi yi, odoke mehkele eri Lapan ihnan pe yu usendre-et ndre ou pe nedum horu yi.” ");
INSERT INTO ktm_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Inum ti pe Yosep ikuni horu hara-au odo kanahan Israel pe ipu ruru ile tan taman, purmadan iltu-uw ndre poi. ");
INSERT INTO ktm_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Inum pe Yosep iduwe Efraim ile kamweu ta Yakop ea pe Manaseh ile mudon. ");
INSERT INTO ktm_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Odoke Israel iduwe lumwen ile ndraposeleh, eri pe lumwen mudon ile ye palan Efraim pe kamweu ile palan Manaseh. Manaseh eri tolun pe Efraim eri lusiyen. ");
INSERT INTO ktm_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Inum oh ti pe iy ipatihteh Yosep ihpah: “Lapan, Ou ndre onu-us tomo horu, Abraham pe Aisak, eri opo blesim horu kom kutih! Lapan, Ou eduwe yu umwin uu pe isto mehkele, eri opo blesim horu! ");
INSERT INTO ktm_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Engel kehe ndre enehnuwii yu odo horut todo ndre sulo-on, eri opo blesim horu! Rongo pe ranga' horu tomo, Abraham pe Aisak we kindrene-en, eri we kindreh hun horu kom kutih. Horu horpo kom kile sulo-on pe yaya' horu kihur.” ");
INSERT INTO ktm_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yosep tawene tadan ihrut hepe odo iy indroni taman iduwe lumwen mudon ile palan Efraim, ile pe iy indretowe lumwen taman pe isori iyeu odo palan Efraim, pe iduwei ile palan Manaseh. ");
INSERT INTO ktm_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Inum pe iy ipe ile tan taman ihpa, “Tomo, indrahpa kiti pwi. Nedu kamal munen ti kurti, eduwe lumwen mudon ti kile palan.” ");
INSERT INTO ktm_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Taman indrehrung iy pwi, pe ipe ihpa, “Yu tuno, nedu. Yu tuno. Su yayan Manaseh eri we hohor hala sulo-on. Odoke su yayan Efraim eri we hohor hala sulo-on lakopwi pe we hehir hala lok mandra-ane.” ");
INSERT INTO ktm_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ile pe iy ipu blesim horu idu rang eti pe ipe ihpa, “Su Israel we heneyuwen ranga' oruu kinto iy ndre su hapa hotou blesing tih. Su we hampa kihpa, ‘Lapan kihnan ou kihpa ndre Efraim pe Manaseh.’” Ile sal kuti pe iy iduwe Efraim ile munen pe Manaseh ile ye omur. ");
INSERT INTO ktm_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Inum ti pe Israel ipe ile ta Yosep, “Mundrun mat todo eri kah mukehe, odoke Lapan we kimmin ndrodan ou pe we kiduwe ou ala ndre lonen papum pe tinembrum su yi. ");
INSERT INTO ktm_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Lok huyen pe ndrolon mandra-an odo Sekem iy ndre yu ukuni tasu Amor odo pahun eri yu kah kuduwe kile tadam koson, tintom su eri pwi.” ");
INSERT INTO ktm_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Inum pe Yakop iduwe nolou ile hun nedun su ndre sulo-on pe ipe ihpa, “Atsa ke hondroh, pe yu kupaninyan sa we hehir taduu kidu omur tih: ");
INSERT INTO ktm_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Atsa ke hondroh pe atahrung, oduu nedun Yakop. Atahrung tama’ oduu ke Israel. ");
INSERT INTO ktm_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Ruben, kom tolun todo, puko-on todo ti ou. Longoh odo eleheu todo ti yu uwepisi ou iyin munen. Ile puko-oi pe rangai ihnding, eri ou emin kalai. ");
INSERT INTO ktm_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ou ti ahpa ndre noren kup, odoke we onso ke lo wambreh tan tintom su, odosa ou anak ile sawen taman, pe opo mbrulun tih. ");
INSERT INTO ktm_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeon pe Livai ti horu ndrin. Painat ta horu ti ndrai idu madan. ");
INSERT INTO ktm_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Yu we kundrimin lon paruhur ta horu pwi, pe we kunna lo sohou ta horu pwi. Horu herempo loroh pe herenopwi ndramat hamat, pe makau ma ndre more' su ti pe horu herentumbru-e ndrike' su ile ke hono-on ndruwot. ");
INSERT INTO ktm_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Surur kile pule-en loroh ta horu, odosa loroh erti homou we kindrundrotowei pwi. Pe surur kile pule-en lon ndrinei nai ta horu, odosa karundrum indrimin eriy pwi tih. Yu we kutsarpadan oruu arla ke lenga' su nedun Yakop, pe we ermin ke lenga' su Israel. ");
INSERT INTO ktm_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Judah, tintom su we hosori rangam. Su pidiwa tadam ti ou lumwem we kise wo' su. Tintom su we hopo ruru kile tadam. ");
INSERT INTO ktm_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ou ti ahpa ndre layon, Judah. Layon ilrop anan yohou oh pe ina-au isa ndre omwen pe inemetir. Iy kirotutlon iy ki-in ti ou si puko-om we eltukuni iy? ");
INSERT INTO ktm_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Judah, kendro tan king we kise lumwem, pe we kindra-au odo lumwem pwi, pe we ta yayam su ndresale. Kantri we hohrung nolwu-um, pe hehlingi ou kile sane, pe we hopo ruru kile tadam. ");
INSERT INTO ktm_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Iy we kisswi donki tadan ma inek tapa eriy ti kisso padan grapevine ndre sengin hutun lakopwi. Kolos tadan we kisingen kile wain rama-an ihpa ndre ndrai. ");
INSERT INTO ktm_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Madam we kirma odo ke ing wain, pe lehem we kiperer odo ke ing pon susun meme. ");
INSERT INTO ktm_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Sebulun, ou ti we emin ngerin ndras. Lom pasis tadam ti we kinehndrepit tan ndrolen yap. Kapetne-et odo lonem eri we kilto ndre Saidon. ");
INSERT INTO ktm_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakar eri ndrakika-an, odoke iy ti ihpa ndre donki itarah iyin lengan sedel pek. ");
INSERT INTO ktm_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Iy indroni ihpa ndre ndruhun mayau tadan ti huyen, pe poyen ti huyen. Ile pe iy ihran won ipe kisursor sane, pe sa we hehkikiyan iy kile hono-on marai ta sa. ");
INSERT INTO ktm_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan we kisini kakah ta su lewen. Su eri we hahpa ndre metnemwen se yi odo Israel. ");
INSERT INTO ktm_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan eri we kihpa ndre mot iyin ngerin sal, mot posin iyin ngerin sal ndre ineti kambrulken hos, pe hos impiyen ndramat intaketi ile omur ea. ");
INSERT INTO ktm_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Lapan, yu ungkeli-iy upwe Ou ehnuwii yu.” ");
INSERT INTO ktm_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gad eri raskel we hanak hun iy, odoke iy we kipu pahun pe kidu omur ta su yi. ");
INSERT INTO ktm_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Aser, ou lonem ti song huyene we he-en eriy. Song odo lok tadam ti iy ndre sa king we henehwaso-o sa tih. ");
INSERT INTO ktm_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naptali ti ihpa ndre dia ndrukwil ndre inelila ile reh tadan, pe intudou nedun eri pe nedun ti rahye' su. ");
INSERT INTO ktm_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yosep ti ihpa ndre donki puyep ise koson wo kolou, ndre pwi homou nedun hos puyep ise padan lok. ");
INSERT INTO ktm_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Su pidiwa tadan hanak hun iy, pe ha-as iy ile panada. ");
INSERT INTO ktm_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Odoke iy lumwen tis panada tadan pe ipkwe, odosa puko-on tadan ti iyus ngo Lapan Mandra-an ta Yakop, Lapan tan Israel we madan kisso tadan pe kintawe puko-on kile tadan. ");
INSERT INTO ktm_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Lapan tan tamam ke Yakop we kihnuwii ou, Lapan, taman sane ndre sulo-on we kipu blesim ou. Lapan we kihlingi ou kile lengin indroh eleng pe wo indroh kwin poi, Lapan we kihlingi ou kile sipsip pe sane ka-an sulo-on, Lapan we kihnan su pedehnem hopo kom sulo-on, ");
INSERT INTO ktm_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Blesing Lapan iduwe tan tamam ti ihluwen blesing ile pule-en puliy, blesing Lapan iduwe tan tamam ti ihluwen blesing ile pule-en sane ndre sulo-on odo padan puliy. Ndre sulo-on kurti yu kah kuduwe kile mburmpalan Yosep, kile mbrulin nedun king imin lenga' su tinton. ");
INSERT INTO ktm_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamin eri ihpa ndre mweh puyep ndre song iyin ndrinen. Maping eri irop anan yohou pe inna-an. Pehon eri iy intelnge sane iy inerupoi.” ");
INSERT INTO ktm_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Su kuti metnemwen ndre sungoh-pe-rupwing odo Israel. Tama' su impatenten su ti pe inesukuni sa iy ndre su we hehir kihpa eriy omur tih. ");
INSERT INTO ktm_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Inum ti pe Yakop isohou tan nedun su pe ipe ihpa, “Yu kumwet, eri atlatoni yu kule ndrodan tomo su kule ndre pehliy ilso lok tan Efron, lapan Hit tih. ");
INSERT INTO ktm_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Pehliy erti ilso rai ea odo Mamre, ise lok rangan Makpelah, odo Kenan. Abraham isihnen poi ndrodan ndre pehliy kurti odo hun Efron, ile ndruhun tunton ndramat. ");
INSERT INTO ktm_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Hedoni Abraham pe mbrulun ke Sarah ti ilto eriy, hedoni Aisak pe mbrulun ke Rebekah ti ilto eriy, pe yu udoni Leah ti ilto eriy yi. ");
INSERT INTO ktm_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Poi pe pehliy ise eriy kuti hesihnen odo ngon su Hit. Atlatoni yu kule eriy yi.” ");
INSERT INTO ktm_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakop isohou tan nedun su ile sohou ndre sulo-on kuti inum ti pe isori ndriken ndre rukei ile pule-en sau, irwi ngohon ke petsih, pe imet. ");
INSERT INTO ktm_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yosep ipiyen iy ile pule-en taman, iru-iy pe ihngwi purmadan. ");
INSERT INTO ktm_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Inum ti pe iy ipe pe su ndrokta tadan hopo marai ile tan taman. Su hoponunson taman pe heduwe marsin ile mundren taman, odo kile pe taman kipso sowin kolwii. ");
INSERT INTO ktm_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Marai odo ponunos ndramat mat ihpa kuti inesini rang hangoh, ile pe su ndrokta hopo marai ile tan taman ti rang ndre hangoh. Pe su Isip hesehel Yakop rang ihndre ndrotulngeh. ");
INSERT INTO ktm_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Mundrun sehel Israel ndre inum ti pe Yosep ipe ile ta su kohkoh tan king ihpah, “Atakuni nolou todo kile hun king. ");
INSERT INTO ktm_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Atlapa nolou todo kuti kile tadan, ‘Tomo ipe ndre kimet eri pe ipe yu kudemumoi kile tadan odo we yu kultoni iy kile ndre ngat iy ihnan kah ilso ndre Kenan. Iyenon yu kule pe kultoni tomo kinum pe we yu kuse yi?’” ");
INSERT INTO ktm_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","King ipe ihpa, “Ala pe oltoni tamam oh, kihpa ndre ou adamumoi ile tadan apa we ahnan tih.” ");
INSERT INTO ktm_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ile pe Yosep ile pe iltunton taman. Su lau lehen palan tang king ndre sulo-on, su lau ndre henehnuwii king ile tawene, pe su kohkoh ndre sulo-on odo Isip, eri ho-us pe heltunton Yakop. ");
INSERT INTO ktm_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Su lewen Yosep ndre sulo-on, su tinton, pe ile ndrodan ndre su lewen Israel ndre sulo-on ho-us. Tapake kom mone, ndrodan ndre sipsip, meme pe makau honto ndre Gosen. ");
INSERT INTO ktm_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ndramat hala wil karis pe ndramat he-en pule-en hos eri ho-us hala yi. Ndramat hudut lakopwi hala. ");
INSERT INTO ktm_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Su helihir ile ndruhun tapurit puken wit, ise ngerin taon Atat, odo mukehe wo Yordan. Su hehir eriy ti pe heru-iy pe hadang ile mo-on lakopwi. Su hodo eriy rang ndrodul pe Yosep ipu lon pengin taman. ");
INSERT INTO ktm_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Su ndramat odo Kenan hondroni su ndramat ta Yosep hantang pe hana-an lon pengin odo Atat ti pe hahpa, “Su Isip henesehel homou ndramat.” Iy kuti uu pe lok ise mukehe Yordan erti sa heneyuwen ile Abel Mizraim tih. ");
INSERT INTO ktm_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ile pe su nedun Yakop hahnan ihpa ndre iy ipe ile ta su tih. ");
INSERT INTO ktm_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Su hosori iy ile Kenan pe hodoni iy ile pehliy odo Makpelah, ise rai odo Mamre. Poi erti Abraham isihnen odo ndrongon Efron lapan Hit, ile ndruhun tunton ndramat. ");
INSERT INTO ktm_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yosep idoni taman oh pe ile ndre Isip yi, ndrodan tinton su pe sa ndramat ndre sulo-on ndre ho-us odo tunton taman tih. ");
INSERT INTO ktm_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Tama' su ke indrimat, ile pe su tinton Yosep hapa ihpah, “Yosep kihne ma kintawonon mo-on ndre sulo-on ndre tidu titpo ile tadan tih. Pe kihne iy kipu muden.” ");
INSERT INTO ktm_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ile pe su heduwe nolou ile hu Yosep pe hapa ihpa, “Tama' tidu ipe ndre kimet, ");
INSERT INTO ktm_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","eri pe iy ipe odu atpa nolwo-on kile tadam kihpa, ‘Tintom su mo-o' su kah. Akarndrundrumwi su pe opo muden horut ndre su hahnan ile tadam ti kolwii.’ Ile pe mehkele, eri odu atpa ou kolum kah ke-eu odo mo-on ndre odu lewen marai ta Lapan tan taman atndrahnan tih.” Nolou tasu ihir hun Yosep ti pe iy ikarndrum su pe ideng. ");
INSERT INTO ktm_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Inum ti pe su tinton Yosep, su ndre su, hala pe hepiyen su ile pwoi idu purmadan, pe hopo ruru ile tadan. Su hapa ihpa, “Odu etndresa. Okuni odu atla hono-on marai tadam.” ");
INSERT INTO ktm_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Odoke Yosep ipe ile tasu ihpa, “Otnoh kolwii. Yu we kunsini ndruhun Lapan pwi. ");
INSERT INTO ktm_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Oduu ti atpa ye otpo mo-on ile puli-i, odoke Lapan ipe iy erti huyen, ile pe mahkele eri we sa ndramat sulo-on handrimat pwi. ");
INSERT INTO ktm_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Otnoh hangka-an kolwii. Yu we modo kise taduu pe su nedu’ oduu.” Pe iy iduwe sohou huyene ile ta su, ile pe tawene tasu kah hala huyen. ");
INSERT INTO ktm_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yosep ke imin Isip ndrodan ndre lewen taman su. Krismas tadan ti ihir ile ndre sangat-pe-sungoh pe iy imet. ");
INSERT INTO ktm_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yosep imin ti uu pe isendre-et ndre su nedun pe papon Efraim yi. Iy isendre-et ndre su nedun Makir yi. Makir ti nedun Manaseh. Su nedun Makir eri Yosep ikuni su pe ihlingii su ile ihpa ndre nedun. ");
INSERT INTO ktm_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Inum ti pe Yosep ipe ile tan tinton su ihpah, “Yu mukehe kawe kumwet. Odoke Lapan we kindra-amelyen oduu pwi. Iy we madan kise taduu pe we kikuni oduu ada-au odo lok kerti, pe kiduwe oduu ada-au atla ndre lok Iy ipu poromisim Abraham, Aisak pe Yakop tih.” ");
INSERT INTO ktm_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Inum ti pe Yosep ihndremte su Israel ipe su hahnan poromis handrai. Iy ipe ihpah, “Lapan we kikuni oduu ada-au ndre ndrokene odo lok ketih, pe atla ndre lok Iy ipe ile ta su papo’ tidu tih. Atamumoi kile todo kihpa ndre uh, oduu atalang ada-u, eri we etsori ndruwi ndrodan ku-us oduu.” ");
INSERT INTO ktm_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yosep krismas tadan sangat-pe-sungoh, pe imet imin ndre Isip. Su ndrokta hetilen iy pe heduwe marasin ile mundren, odo kile pe kindrepuso sowin pwi tih. Inum pe heduwe iy ile lon kes pe iyin ndre Isip. ");
INSERT INTO ktm_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Gutnius ta Nedun Lapan, Yesus Kristus ti ihir ihpa ndre kurtih. ");
INSERT INTO ktm_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Profet Aisaiah ndre pihe ti idetorwe pohon Lapan ihpa, “Yu we kuhtakalan ndramat todo kidokai kise munen, pe iy we kise kisitatilen salam kile huyen. ");
INSERT INTO ktm_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Homou lau iyuw imin lok sehir tam pwi, ihpa, ‘Adahnan salan Lapan ki‑in. Atatilen salan kile huyen.’” ");
INSERT INTO ktm_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ile pe ndramat odo tokai ise munen ti Jon odo Baptais. Jon imin lok sehir ndre akan poi ke porah iyin eriy, pe isohou puko‑on ile ta sa lau ihpa, “Tawene taduu ke‑eu odo punou mo‑on pe atsa otpo baptais, kile pe Lapan kolon ke‑eu odo to‑ir taduu.” ");
INSERT INTO ktm_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ile pe sa lau sulo‑on odo Yerusalem pe lok se yi odo Yuda, hala pe haltahrung Jon. Su henen to‑ir ta su ile moleu pe Jon itou baptais ile ta su odo wo Yordan. ");
INSERT INTO ktm_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Kolewen Jon ti hahnan odo lemlemun kamel, pe iy inehndrusi let iyin ndrokoron. Song anan Jon ti kalangou pe wayen pakok odo purken kei. ");
INSERT INTO ktm_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Iy ipe ile ta sa lau ihpah, “Ndramat homou ndre we kise omur todo ti ise puli‑i lakopwi. Yu ti undranon Iy pwi. Yu undranon kukaluluhu pe kuruwyon esuke‑en su Tadan pwi. ");
INSERT INTO ktm_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yu untudou baptais odo wo, odoke Iy ti we kitou baptais odo Lapan Mulwen.” ");
INSERT INTO ktm_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kalmene‑en kurti pe Yesus iyus taon Nasaret, odo Galili Distrik, pe ile ndrongon Jon. Pe Jon inuhen Iy odo wo Yordan. ");
INSERT INTO ktm_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Idu ke ndre Yesus ise eleng odo lon wo ti, Iy indre‑et ile eleng, pe iltuwe parar iseket idu kopwi. Pe Lapan Mulwen iyuh ise pule‑en ihpa ndre pal. ");
INSERT INTO ktm_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kuruwen pohoi iyus lom parar iseket ti ipe ihpa, “Ou ti Nedu. Yu wasu‑u Ou lakopwi. Yu uhposon Ou.” ");
INSERT INTO ktm_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Idu ke ndre kuruwen pohoi iyus parar ti imnin, eri Lapan Mulwen ikuni Yesus ile lok sehir, pat pe on ke porah iyin eriy. ");
INSERT INTO ktm_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yesus imin lok erti rang ndre hangoh ndroda su ka‑an puyep. Pe Satan ile pe ituhne ipe kihnan Iy pe Iy kindretahrung nolou ta Lapan pwi. Pe su engel henehnuwii Iy. ");
INSERT INTO ktm_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Sa kah hendrundrotowe Jon odo Baptais pe hokuni iy inna kou. Idu ndruwen erti, Yesus ile Galili Distrik pe ipehre Nolwo‑on Lapan. ");
INSERT INTO ktm_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Iy ipe ihpa, “Losengin indrihir. Mundrun ndre Lapan we kile king odo lokpoi ti indrisa. Ada‑as punou mo‑on ha‑au pe otpo bilip kile Nolwo‑on Lapan.” ");
INSERT INTO ktm_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesus inelila odo ngerin Ndras Galili, pe Iy iltuwe horu madan tinton rumuu, Saimon pe Andru. Horu ti lau odo pondrih ni, ile pe horu herempiyi kupwen. ");
INSERT INTO ktm_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Pe Yesus ipe ile ta horu ihpa, “Arsa oru‑us Yu, pe Yu we kutuhnon oruu kile takun ndramat.” ");
INSERT INTO ktm_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ile pe horu herpiyen kupwen ta horu into ndre poi pe horu‑us Yesus. ");
INSERT INTO ktm_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Iy illa ile lehpe lakopwi, pe iltuwe Jems pe Jon. Jems horu Jon ti tama’ horu Sebedi. Horu hermin lon ndrole’ horu, pe heresokopet pe herempisi ta horu kupwen. ");
INSERT INTO ktm_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesus madan ihtek ta horu ti pe iyuwen horu lakopwi. Horu herpiyen tama’ horu ndrodan ndre su lewen marai honto ndre ndrol, pe horu‑us Yesus. ");
INSERT INTO ktm_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Su hala taon Kaperneam, pe idu Sabat, eri Yesus ile lon omwen surok ta su Yuda pe ipehre nolwo‑on Lapan ile ta sa lau. ");
INSERT INTO ktm_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Sa lau hehretek ile suhwon, odosa Iy indrenolou ihpa ndre su ndramat ndre tuno’ su Lo ti pwi. Su sape ndramat odo Lo ti henosohou illa ke nolou ndre sa ndramat se yi hendresohou kah ile eri, odoke Yesus ti isohou ihpa ndre Iy ti Tadan pawa odo sohou. ");
INSERT INTO ktm_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Sa hehretek ti orngon homou sinel imin pule‑en ti idehel idu pule‑en Yesus ihpa, ");
INSERT INTO ktm_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesus odo Nasaret, Ou apa ospo sa kile tadu? Ou apa asahyan odu tih? Yu tuno Ou! Ou ti Ndramat Kapin ta Lapan!” ");
INSERT INTO ktm_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesus ihrurute anan ihpa, “Onlou kah! Asa mahun odo tadan!” ");
INSERT INTO ktm_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Pe sinel kuti iruhyon orngon kuti ile puko‑on, inum pe idehel ile mo‑on pe indreh iyeu. ");
INSERT INTO ktm_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Sa lau ndre sulo‑on hehretek pe poho’ sa idohoh idu kopwi. Homou ihndremte homou ihpa, “Homosa kutih? Iy itou tatuhne pe punou ile handrai yi. Iy isohou Nolwo‑on Lapan ihpa ndre ndramat tadan pawa. Pe inlou ta sa sinel pe su hohrung Iy!” ");
INSERT INTO ktm_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ile pe Yesus rangan ihnding sowin kopwi odo lon Galili Distrik ndre mandra‑an. ");
INSERT INTO ktm_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesus ise kiu odo omwen surok pe illa ile um ta Saimon horu Andru. Sa lau se ho‑us yi, ndrodan ndre Jems pe Jon. ");
INSERT INTO ktm_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Osohon Saimon ti inemetir iyin petle odosa iy imet sik pe mundren mburten, ile pe su henen ndralngan Yesus. ");
INSERT INTO ktm_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iy illa ile hun osohon Saimon, indrotowe lumwen, pe isori iy imin eleng. Osohon Saimon ile huyen, pe itou song ile ta su pe su hoyo‑on. ");
INSERT INTO ktm_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Idu lukumwen ti pe mundrun Sabat inum. Ile pe sa hekuni sa lau ndre hamat sik, ndrodan ndre sa lau ndre sinel hodo ta su, eri hala hu Yesus. ");
INSERT INTO ktm_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Sa lau ndre sulo‑on odo taon Kaperneam ti hala pe hodo malal odo um ta Saimon horu Andru. ");
INSERT INTO ktm_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesus ihnan sik handrai pe handrai odo mundre’ sa lau ti honum. Iy iyes sinel odo mundre’ sa lau yi. Odoke Iy isinip ana’ su sinel we hendresohou pwi, odosa, su tuno’ su Iy ti Nedun Lapan. ");
INSERT INTO ktm_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yesus itlang maping ndrelik odo lon um, pe iyeu ile ngerin taon. Ndramat hondruto sehir erti pwi. Iy imin eriy pe inesurok. ");
INSERT INTO ktm_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimon su lewen hala helpondrih Iy. ");
INSERT INTO ktm_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Su hetureh Tadan pe hapa ihpa, “Sa lau ndre sulo‑on hempondrih Ou.” ");
INSERT INTO ktm_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Odoke Iy ipe ile ta su ihpa, “Tidu titla lok se yi ndre he‑en mukehe odo ketih, pe Yu kulpehre Nolwo‑on Lapan. Yu use ti odo paninye nolou ta Lapan ile lok ndre sulo‑on.” ");
INSERT INTO ktm_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ile pe Iy ile lok ndre sulo‑on odo lon distrik Galili pe ipehre Nolwo‑on Lapan odo lon omwen surok sim pe sim, pe iyesilpinen su sinel ha‑au odo ta sa ndramat. ");
INSERT INTO ktm_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Orngon homou tadan sik lepra ile, pe pandrulku‑un ndre rukei ile poi idu madan Yesus, pe iy ideng ipe ihpa, “Uh Ou ereh, eri ahnan yu kuhir huyen odo madan Lapan.” ");
INSERT INTO ktm_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesus madan ile tadan pe ikarndrum iy lakopwi. Iy itlon lumwen ile pe itkuni orngon kuti, pe ipe ihpa, “Yu wasu‑u. Ou ala huyem.” ");
INSERT INTO ktm_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Pe sik tan orngon ti ihkepwi pe iy ile huyen. ");
INSERT INTO ktm_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesus sowin kopwi ipe ile tadan iyeu, odoke ipe nolou puko‑on ile tadan ihpa, ");
INSERT INTO ktm_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Antahrungii? Nombrun enen ndralngan homou. Ndresale kopwi ala pe elilngan ou kile tam pris, pe ahnan ofa kihpa ndre Lo ta Moses ipe tih. Kile pe sa lau hehtuno sa ihpa ndre ou ti kah huyem.” ");
INSERT INTO ktm_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Odoke orngon ti ile lok ndre sulo‑on odo Galili pe inen sane kuti ile ta sa lau. Ile pe Yesus indranon kindrila lon sih taon pwi, odosa sa ndre sulo‑on hempondrih ke Iy. Iy immin ke lok ndre ndramat hondruto eriy pwi ti, odoke sa lau odo hokor pe hokor halla ndrongon Iy. ");
INSERT INTO ktm_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Rang se inum oh, pe Yesus ile yi ndre Kaperneam, pe ninen ihtot lok ihpa ndre Iy insa yi. ");
INSERT INTO ktm_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Lau hohndur hala yi ndre ndrongon Iy, ile pe um ndre Iy imin eriy ti ihndrepit ta sa lau. Lonu‑um pe kiu ndrodan ti hepe lok ke porah indrisou pwi, pe Yesus impehre Nolwo‑on Lapan ile ta sa. ");
INSERT INTO ktm_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Su lau hamou hosori orngon homou ndriken pe lumwen kakukuw ile. ");
INSERT INTO ktm_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Lok indrehndrepit pe su handranon hana mukehe ta Yesus pwi, ile pe su hosori orngon kuti ile mbrungiy pe hosomukihi ngereu ise eriy. Ngereu ti ise ke ndre pule‑en Yesus. Inum pe su hosokombrute‑en osukei ile lokowon orngon kuti pe heduwe iy ile pwoi melsen, ile purmadan Yesus. ");
INSERT INTO ktm_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesus iltuwei ihpa ndre bilip ta su ti mandra‑an, ile pe Iy ipe ile tan orngon kakukuw ihpa, “Nedu, Yu undra‑as to-ir tadam handra‑au.” ");
INSERT INTO ktm_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Su tisa se odo Lo ta Moses ti hodo pe hehrungi Yesus, ile pe su hadawene ihpa, ");
INSERT INTO ktm_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ei! Iy ti ipe Iy ti sa pe inolou mo‑on ile ta Lapan tih? Homou lau kindranon kindra‑as to-ir ta homou lau pwi. Homou ke Lapan kenon kipu ertih!” ");
INSERT INTO ktm_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Odoke Yesus indrehtunon tawene ta su, ile pe Iy ipe ile ta su ihpa, “Oduu edentawene ihpa kirti ile sa? ");
INSERT INTO ktm_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Iy kehe mangsan ewehen lakopwi? Yu kupwe ‘to‑ir tadam handra‑au’ ndre pwi Yu kupwe ‘atlang, okuni lokowum pe alla’? ");
INSERT INTO ktm_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yu we kulilngan kile ta oduu ihpa ndre Nedun Ndramat ti tadan pawa odo as to‑ir ta sa ndramat odo lokpoi.” Ile pe Iy ipe ile tan orngon kakukuw ti ihpa, ");
INSERT INTO ktm_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Atlang, ekuni lokum pe owou ala emwem!” ");
INSERT INTO ktm_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Orngon ti itlang, ikuni lokowon, pe illa iyeu iyus mada’ sa lau ndre sulo‑on. Sa ndre sulo‑on hehretek pe hemesi‑iy, pe hesori rangan Lapan ile eleng. Pe sa hapa ihpa, “Odu hepe etsenendre‑et hangka‑an ihpa kuti pwi uu ndre mahkele.” ");
INSERT INTO ktm_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesus ile yi ndre ngerin ndras odo Galili. Sa lau sulo‑on hala ndrongon Iy, pe Iy innen Nolwo‑on Lapan ile ta su. ");
INSERT INTO ktm_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Iy inelila ile ti pe iltuwe Livai, taman ti Alfius. Livaia ti imin um odo sihsih takis, odosa iy maryan ti takun takis ta sa lau. Yesus ipe ile tadan ihpa, “Asa owus Yu.” Livai itlang pe iyus Iy. ");
INSERT INTO ktm_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ndruwen erti pe Yesus ile ilyo‑on song ile um ta Livai. Su se ndramat odo takun takis pe sa ndramat se mo‑osa, hala yi pe hana‑an song hodo ke hondroh ndroda Yesus pe su lewen. ");
INSERT INTO ktm_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Su tisa odo Lo (su ti Paraseo) heltuwe Yesus ina‑an song ndroda sa lau mo‑osa pe su lau odo takun takis, ile pe su hehndremte su disaipel Tadan ihpa, “Ihpa kehe pe Iy ina‑an song ndroda sa lau kurtih?” ");
INSERT INTO ktm_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesus ihrungi su pe ipe ile ta su ihpa, “Sa lau hendrimat sik pwi ti hesereh tan ndrokta pwi, tapake sa ndre ta sa sik ti herreh tan ndrokta. Yu use ti odo yuw sa lau huye’ sa ti pwi. Yu use ti usuyuw sa lau mo‑osa.” ");
INSERT INTO ktm_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Petsih ti su lau honu‑us Jon Baptais, pe su lau ndre honohtot Lo ta Moses, eri holuhuw yo‑on song. Ile pe sa lau se hala hu Yesus pe hehndremte Iy, “Su lewen Jon pe su lau mandra‑ane odo Lo ta Moses ti heneluhuw yo‑on song, pe ihpa kehe pe su lewim ti hesempo erti pwi tih?” ");
INSERT INTO ktm_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesus ipe ihpa, “Ihpa kehe? Oduu waso‑o’ oduu atpa sa kowson ndramat ndre iyesou mahkele kopwi ti hoyo‑on song kolwii, idu iy mapwi imin ndroda su tih? Pwi tih! Idu iy mapwi imin, eri su kowson ti we hensinip ana’ su odo yo‑on song pwi. ");
INSERT INTO ktm_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Odoke rang ti we kise, pe sa lau mo‑osa we hekuni iy ke‑eu odo ngo’ su lewen. Iy ndre kah kindra‑au ti pe su ka we holuhuw song.” ");
INSERT INTO ktm_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Homou indresokopti sehir kolau wuhou ile mundren siot ndruken iseket ti pwi, odosa, uh sa we hesingen, eri palan kolau wuhou kuti we kikuw kile lehyen pe kire‑e siot kile mandra‑an lakopwi. ");
INSERT INTO ktm_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Pe homou isentehen wain morowin ile lon keltun meme ndruken pwi. Pwi ti we wain kire‑e keltun meme kurti, pe wain ndrodan ndre keltun meme we herehmo‑on. Ile pe sa hentehen wain morowin ti illa ke lon kalatun meme wuhou.” ");
INSERT INTO ktm_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Idu rang sei Sabat eri Yesus illa iyus lon katen wit. Su lau Tadan ti ho‑us Iy yi, pe hentakun sengin wit pe hana‑an. ");
INSERT INTO ktm_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ile pe su Paraseo hapa ile ta Yesus hahpa, “Hei, Lo ta tidu ti indresinip ana’ tidu odo yo‑on song odo langah ta sa lau ti pwi, odoke Lo ti ipe tidu we titndrepo erti kidu Sabat pwi.” ");
INSERT INTO ktm_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Yesus isomwi su ihpa, “Oduu ti hepe edempo rit pohtidi‑iy tan Devit iyin buk tam Profet Samuel ti ndre pwi? Idu mundrun ndre Abiatar ti hetpris, Devit pe su lewen hamat song pe hala lon omwen Lapan, pe hani bret odo ofa illa ta Lapan. Bret erti immin purmadan Lapan, pe sa lau ke porah we hendreyo‑on pwi. Sa pris kopwi we heyo‑on. Odoke Devit iyo‑on, pe itou se ile ana’ su lewen yi. Oduu edempo ridim nolou kuti ndre pwi?” ");
INSERT INTO ktm_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Inum pe Yesus ipe ile ta su yi ihpa, “Lapan iduwe Sabat ti odo henuwii ndramat. Lapan indrahnan ndramat odo we kinehnuwii Sabat ti pwi. ");
INSERT INTO ktm_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ile pe Nedun Ndramat ti bos odo Sabat yi.” ");
INSERT INTO ktm_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesus ile lon omwen surok yi. Orngon homou imin lenga’ sa lau ti lumwen hakai indrimat. ");
INSERT INTO ktm_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Sa se hodo omwen surok ti hapa hehreh sal odo hopo kotim Yesus, ile pe su mada’ su tis Tadan, kihne Iy kihnan lumwen orngon kuti kile huyen, odosa rang erti Sabat. ");
INSERT INTO ktm_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ile pe Yesus ipe ile tan orngon ndre lumwen mo‑on ti ihpa, “Odo eleng pe esuto munen.” ");
INSERT INTO ktm_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pe Yesus ihndremte su ihpa, “Lo tatidu ti ipe we tidu titpo sa kidu Sabat? Lo ipe tidu we titpo sane huyen or sane mo‑on? Tidu tidehnuwii ndramat kimet kolwii, or tidu tidahnan ndramat kimet?” Odoke homou indripa hangka‑an pwi. ");
INSERT INTO ktm_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesus indre‑et ile ta su pe lon ndrinen inei, odoke ikarundrum su, odosa su hapa we ha‑au hemin ke ndre tawene ta su munen tih. Pe Iy ipe ile tan orngon kuti ihpa, “Otlon lumwem.” Orngon ti itlon lumwen pe lumwen ile huyen ndresale. ");
INSERT INTO ktm_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ile pe su Paraseo hatlang pe ha‑au hala kiu. Su ndresale kopwi hala ndroda su lau ta Herot pe helpunou odo we hapwi Yesus kimet. ");
INSERT INTO ktm_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesus ndroda su disaipel Tadan ha‑au hala Ndras Galili pe sa lau sulo‑on hodo ndruwen. Kaunan sane ndre Yesus impo ti ihtot lon lok odo Galili Distrik, Judea Distrik, ");
INSERT INTO ktm_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","odo taon Yerusalem, odo Idumea Distrik ndroda lok odo wo Yordan hodoh, pe odo taon Tair pe taon Saidon. Ile pe sa lau sulo‑on odo lok erti hasa ndrongon Iy. ");
INSERT INTO ktm_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ile pe Yesus ipe ile ta su disaipel Tadan ihpa, “Sa lau pohpou pohpou hansa. Etpondrih sih ndrol ki‑in, kihne sa hoportai hasa mukehe pe horotawe Yu. Pe uh sa hapa heseporoh Yu, eri Yu we kundreh kile ndrol pe kule mahun odo ta sa.” ");
INSERT INTO ktm_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yesus indrahnan sik ta sa lau sulo‑on munen kah, ile pe sa sik ti hentandrusuwi hapa hala mukehe pe hetkuni Iy, kile pe sik ta sa ha‑au. ");
INSERT INTO ktm_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Su sinel ti yi, into su heneltuwe Yesus, eri pandrulku‑u’ su illa poi pe hoyuw ihpa, “Ou ti Nedun Lapan!” ");
INSERT INTO ktm_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Odoke Yesus ineyahat ana’ su ile puko‑on, ipe su hapahran Iy ti si eri kolwii. ");
INSERT INTO ktm_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesus inek kuh ile malal, pe iyuwen su lau ndre Iy waso‑on su tih. Su hala ndrongon Iy, ");
INSERT INTO ktm_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","pe Iy ihlite su sungoh-pe-rumuu. Su ti we honto ndrodan Iy, pe Iy we kinehtakalan su hompo maryan Lapan. Pe Iy ipe ile ta su ihpah, “Yu ukuni oduu we otto ndroda Yu. Yu we kuhtakalan oduu atlapehre Nolwo‑on Lapan. ");
INSERT INTO ktm_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Pe oduu we taduu puko‑on odo as sinel.” ");
INSERT INTO ktm_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Su lau sungoh-pe-rumuu ndre Yesus ihlitei ti Saimon (Yesus iduwe rangan handrai yi ti Pita), ");
INSERT INTO ktm_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jems pe tinton ke Jon, tama’ horu Sebedi (Yesus iduwe ranga’ horu ile Boanerges. Mining odo rangai erti ihpa ndre ‘Nedun Kurur’). ");
INSERT INTO ktm_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Pe Yesus ihlite yi Andru, Filip, Bartolomyu, Matyu, Tomas, Jems (rangan taman Jems ti Alfius). Yesus ihlite yi Tadius, Saimon (iy odo lain ta su Selot), ");
INSERT INTO ktm_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","pe Yudas Iskariot, iy ndramat ndre iduwe Yesus ile lumwe’ sa lau mo‑osa. ");
INSERT INTO ktm_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesus ile yi ndre um ndre iy immin eriy tih. Pe sa lau sulo‑on yi hala haltahrung Iy, ile pe Iy ndroda su disaipel Tadan handranon hendreyo‑on song pwi. ");
INSERT INTO ktm_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Su murwon Yesus hehrungi sane Yesus impo kuti, pe su hala hapa haltakun Iy, odo sa sulo‑on hapa Iy ti ngungong idu Tadan. ");
INSERT INTO ktm_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Sa sape ndramat se odo Lo ho‑us Yerusalem hala pwoi, pe hapa ihpa, “Belsebul imin pule‑en. Iy ina‑as sa sinel ti ile puko‑on tam Belsebul, mandra‑an ta su sinel.” ");
INSERT INTO ktm_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ile pe Yesus iyuwen su hala mukehe pe ipe ile palan nolou ihpa, “Ihpa kehe pe Satan we ki‑es Satan? ");
INSERT INTO ktm_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Uh sih kantri kitlangan iy kile kantri ruweh, pe sih kipu pahun kile pule‑en sih, eri kantri erti we kitpar. ");
INSERT INTO ktm_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Pe uh su lewen lonu‑um sim hetlangan su hala rimir pe hopo pahun kile ke ndre pule‑e’ su, eri lewen lon um erti we hatpar. ");
INSERT INTO ktm_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Pe uh Satan kipu pahun kile ke ndre pule‑e’ su lewen, eri puko‑on tadan we kinum, pe iy we kinum ndresale.” ");
INSERT INTO ktm_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Homou lau kindranon kinna lon omwen homou ndramat puko‑on pe kikun sane kile reh tadan ti pwi. Iy we kihndrusi lau puko‑on erti kile osukei oh, kile pe iy ka we kenon kikun sane odo lon um ta lau puko‑on kutih.” ");
INSERT INTO ktm_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Yu kupwe ndre ndrokene kile taduu. Lapan we ki‑es to‑ir ndre sulo‑on ndre sa ndramat hompo. Pe nolou mo‑on ndre sa ndramat hampa ile pule‑en Lapan, eri Lapan we ki‑es ke‑eu, ");
INSERT INTO ktm_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","odoke iy si ndramat ndre kipe nolou mo‑on kile ta Lapan Mulwen, eri Lapan we kindra‑as to‑ir tadan erti pwi. To‑ir erti we kindrimin pe kindrimin.” ");
INSERT INTO ktm_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesus ipahran nolou kurti, odosa su sape ndramat odo Lo hapa sinel imin pule‑en. ");
INSERT INTO ktm_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Idu mundrun kurti, eri kah tinen Yesus pe su tinton hehir. Su hodo kiu pe heduwe nolou ile hu Yesus imin lon um. Su hapa Iy kise kiu ndrongo’ su. ");
INSERT INTO ktm_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Lau sulo‑on hemin pwoi hosokaltan Yesus, pe su hapa ile Tadan ihpa, “Yesus, tinem pe tintom su holto kiu pe hapa Ou ala.” ");
INSERT INTO ktm_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pe Iy ipe ihpa, “Nino ti iy si, pe tinto ti su kehe?” ");
INSERT INTO ktm_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Inum pe Iy madan ile ta sa lau ndre hemin pwoi hosokaltan Iy ti pe ipe ihpah, “Su he‑en poi he‑en ti nino pe tinto. ");
INSERT INTO ktm_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Iy si ndre kimpo sane kile reh ta Lapan, eri iy ti tinto pe timsu‑u pe nino.” ");
INSERT INTO ktm_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesus ile ngerin Ndras Galili petsih yi, pe iltudou tatuhne pe punou ile ta sa lau. Lau pohpou pohpou hala haltahrung. Ile pe Iy indreh ile lon ndrol sih, pe intilpit ise koson papi. Iy imin poi imin lon ndrol pe inesohou ile ta sa lau. Sa lau hodo papi pe hantahrung Iy. ");
INSERT INTO ktm_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Pe Yesus isohou sulo‑on ile ke palan nolou odo tatuhne su ile sane sulo‑on. Iy ipe ile ta su ihpa, ");
INSERT INTO ktm_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Oduu atahrung! Orngon homou ile iltehe pedun wit ile langah. ");
INSERT INTO ktm_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Iy ineroti hoso lompurlumwen pe impiyi ile sehir pe sehir. Pedun wit se ti hadaketi hala sal, pe nenka‑an hala pe hanii. ");
INSERT INTO ktm_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Se ti hadaketi hala pule‑en pat. Poi odo pule‑en pat ti menihin, ile pe wit erti hombruu sowin kopwi. ");
INSERT INTO ktm_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Odoke idu ndre mundroi ising, eri ininihi su pe su hekewes pe hamat, odosa su ngondro’ su hana kwin pwi. ");
INSERT INTO ktm_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wit se ti hamandro hala lon esukei pudon. Pe esukei pudon hosomali su, ile pe su hendrupo sengi’ su pwi. ");
INSERT INTO ktm_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Odoke wit se ti horor hala pule‑en poi huyen. Su hombruu, hernge hala mandra‑an pe hotou sengi’ su. Se ti mbrwe’ su inehndre tulngeh ea hoso hombrung, se onngoh, pe se sangat.” ");
INSERT INTO ktm_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Inum pe Yesus ipe ihpa, “Ou si ndralngam eri ohrung nolou kuti kehii.” ");
INSERT INTO ktm_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Sa lau sulo‑on kah handra‑au. Ile pe su lau ndre honto ndroda Yesus ti, pe su aposel Tadan ndre sungoh-pe-rumuu, hehndremte Iy ile mining tam palan nolou ndre Iy indripa kah ile ta sa lau tih. ");
INSERT INTO ktm_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ile pe Yesus ipe ile ta su ihpa, “Nolou tungye odo kapman ta Lapan ti oduu etndrehtuno oduu. Odoke su lau ndre holto ndre mahun, eri Lapan we kimpehre sane kile ke palan nolou killa ta su. ");
INSERT INTO ktm_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kile pe: “‘Su we hehreh pe hehreh odoke we hendrepondriti pwi, su we hehrung pe hehrung yi, odoke su we hendrehtuno su pwi. Odo uh su hopondritii pe hehtuno su, eri kihne su ha‑au odo sal mo‑on pe Lapan ki‑es to‑ir ta su ha‑au.’” ");
INSERT INTO ktm_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Inum pe Yesus ipe ile ta su ihpa, “Oduu ti tuno’ oduu mining odo palan nolou yu upwe ti pwi? Orkom! Oduu we edehtuno oduu mining odo palan nolou ndre sulo‑on ti kihpa kehe? ");
INSERT INTO ktm_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ndramat ndre intehe song kiti eri intehe Nolou ta Lapan. ");
INSERT INTO ktm_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Sa ndramat se ti hahpa ndre wit ndre horor hala sal. Su hehrungi Nolou ta Lapan, odoke sowin kopwi Satan ile pe ikuni nolou erti iyeu. ");
INSERT INTO ktm_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Lau se eri hahpa ndre wit ndre horor ile pule‑en pat. Su hekuni nolou ti sowin kopwi pe hehposon. ");
INSERT INTO ktm_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Odoke nolou erti indrimin ndrine’ su pwi pe su ha‑amelyen sohi kopwi. Ile pe idu sa lau hapa hahyan Nolou ta Lapan pe hotou pede‑en pe hopo mo‑on ile ta su, eri bilip ta su intaketi sowin kopwi. ");
INSERT INTO ktm_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Sa lau se ti hahpa ndre wit ndre hadaketi hala lon osukei pudon. Su lau erti hehrungi Nolwo‑on Lapan ");
INSERT INTO ktm_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","odoke su hantewene hudut ile sane odo lokpoi. Su ede’ su inehnduk ile moni pe henendringis handrai pe handrai. Sane erti hosorohe Nolwo‑on Lapan, pe indrempo sengin pwi. ");
INSERT INTO ktm_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Odoke sa lau se eri hahpa ndre wit ndre hadaketi ile poi huyen. Su hehrungi Nolou ta Lapan, su hokunii, pe hondrotowei. Pe su hopo sengi’ su. Su se sengi’ su ihir ile tulngeh, su se onngoh, pe su se ihir ile sangat.” ");
INSERT INTO ktm_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesus ipe ile ta su yi ihpa, “Sa lau ti henehturmon lam pe hosorohe ile ndrop, erih? Ndre pwi hantawe ile pahndran sau, erih? Pwi! Sa hentawe into moleu. ");
INSERT INTO ktm_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Homosa ndre inna tungye ti we kihir kise rang. Pe homosa ndre sa lau hepulngi, eri we kile tere. ");
INSERT INTO ktm_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ou si ndralngam, eri ehrungi nolou kurti kehii.” ");
INSERT INTO ktm_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Iy ipe yi ihpa, “Atawene kehii kile nolou kutih. Punou sa ou opo kile pule‑e’ si ndramat kihpa kehe eri Lapan we kipu kihpa ke ndre eriy kile puli‑im. Pe Lapan we kitou hepe lakopwi, kihluwen iy ndre ou opo ile ta sa ndramat. ");
INSERT INTO ktm_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Iy si ndramat ndre tadan sane, eri Lapan we kihngahang iy lakopwi. Pe iy si ndre tadan sane pwi, eri Lapan we kikuni ndre sulo‑on ndre hodo ngon iy ti ke‑eu.” ");
INSERT INTO ktm_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesus ipe yi ihpa, “Kapman to Lapan ti ihpa ndre kurtih: Orngon homou itserpede pedun wit hala lo langah. ");
INSERT INTO ktm_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Iy inemetir lukumwen pe immin eleng into meseren, odoke iy tunon sa inahnan wit henerenge ti pwi. ");
INSERT INTO ktm_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Poi iy ndre iy inahnan wit kuti henerenge pe hompo sengi’ su. Ndremanunen ti su hombruu, inum ti ndron hehir, inum pe paren hehir. Ndre ilnum ti sengin wit hehhir. ");
INSERT INTO ktm_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pe idu ndre song ti mandran, eri orngon ti ile pe imndrele padan pe ideparngan sengin. Odosa iy eti kah mundrun takun song mandran odo langah.” ");
INSERT INTO ktm_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Pe Yesus ipe yi ihpa, “Tidu we titpahelos kapman ta Lapan ti kile sa? Tidu we titpehre kile palan nolou sa? ");
INSERT INTO ktm_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kapman ta Lapan ti ihpa ndre mbrwen kei he‑ei sa hana‑an, rangan mastet. Mbrwen mastet ti indrahpa ndre mbrwen kei se ti pwi. Mbrwen ti lehyen lehyen lakopwi. Pe sa hentohon illa lo langah. ");
INSERT INTO ktm_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Sa ndre hendretohon kah ti pe iy inerenge, pe inehluwen kei ndre sulo‑on odo langah. Ndrandran ti halla mandra‑ane, pe lon ndrandran ti wo‑on. Ile pe nenka‑an halla henemandro pe hentumwe emwe’ su honto eriy.” ");
INSERT INTO ktm_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesus ipehre Nolwo‑on Lapan ti ile palan nolou se sulo‑on yi. Iy impahelos sane illa homosa ndre sa lau tuno’ sa, pe we hanon hokuni mining odo eriy tih. ");
INSERT INTO ktm_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nolou ndre sulo‑on ndre Iy ipehre ile ta sa lau, eri illa ke palan nolou. Odoke ndre omur ti su disaipel Tadan kopwi honto ndrodan Iy, pe Iy impahran mining odo palan nolou kuti hala ta su. ");
INSERT INTO ktm_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Idu pehon odo rang erti pe Yesus ipe ile ta su disaipel ihpa, “Tidu titla ndras hodoh.” ");
INSERT INTO ktm_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ile pe su hondroh ile ndrol ndre Yesus imin lon ti pe hokuni Iy ile hodoh. Sa lau ndre sulo‑on ti honto, tapake ndrol se ho‑us su hala hodoh. ");
INSERT INTO ktm_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Langat mandra‑an inguh pe ihnan payau hala mandra‑an, ile pe wo inehturu ile lon ndrol, pe ndrol ipe kiruh. ");
INSERT INTO ktm_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesus ti iduwe palan imin ndralulum pe inemetir imin ku‑in ndrol. Su disaipel hala hesohrungi Iy pe hapa ihpa, “Tisa, emin eleng! Ndrol ke iruh pe tidu kihne kah titmat. Ou karmadam kopwi ile sa?” ");
INSERT INTO ktm_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesus imin eleng pe ihrurute ana’ yor ihpa, “Onum!” pe ipe ile tam payau ihpa, “Otto kopwi!” Ile pe yor imet pe pule‑en ndras iyeweh. ");
INSERT INTO ktm_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pe Iy ipe ile ta su disaipel ihpa, “Ihpa kehe pe oduu otnoh? Oduu ti mapwi etndrempo bilip ile Todo pwi?” ");
INSERT INTO ktm_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Odoke su honoh ile mo‑on. Homou madan ile ta homou pe hapa ihpa, “Iy ndramat sa kurtih? Yor pe payau ti hentahrung nolou Tadan yi!” ");
INSERT INTO ktm_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesus pe su disaipel Tadan hodo ndrol ti pe helihir hala hodoh. Lok su hehir eriy ti lone’ su lau odo Gerasa, ise ngerin Ndras Galili odo rai ea. ");
INSERT INTO ktm_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Yesus indreh ile pwoi odo ndrol, pe orngon homou ihtot ile hun Iy. Orngon kuti sinel imin pule‑en, pe ine‑en lon ngat odo matmat. Sa lau henehndruhus iy tahit. Sa henehndruhus iy ile sen ti tahit yi. ");
INSERT INTO ktm_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Sa henehndrusi iy illa sen odoke iy isomondrihi sen, pe inti‑i haen odo ndriken. Puko‑on tadan ti ilsou lakopwi, pe homou lau kindranon kindrundrotowe iy pwi. ");
INSERT INTO ktm_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Meseren pe lukumwen sei ihpa ke sei, iy inelila ine‑en lom matmat pe inehtot odo padangkuh, pe inesangar pe inemendrele mundren illa pat. ");
INSERT INTO ktm_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Iy idu ndre alau pe iltuwe Yesus, pe ihtot ile, pe pandrulku‑un ile poi idu kendrun ndriken Yesus. ");
INSERT INTO ktm_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Pe Yesus ipe ile tadan ihpa, “Sinel, asa mahun odo tan orngon kitih.” Pe iy idehel puko‑on ihpa “Yesus! Ou Nedun Lapan Mandra‑an imin Eleng! Ou apa opo sa kile todo? Adamumoi kile ta Lapan ihpa ndre ou we endretudou ngendre‑en kile todo pwi yi.” ");
INSERT INTO ktm_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Eri pe Yesus ihndremte iy ihpa, “Ou rangam si?” Pe iy ipe ihpa, “Yu rongo Lijen, odosa odu ti odu sulo‑on.” ");
INSERT INTO ktm_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Pe iy ihndremte Yesus iseu pe iseu, ipe Yesus ki‑es su odo lok erti kolwii. ");
INSERT INTO ktm_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Puu sulo‑on sulo‑on henesusuu hoso tondrih odo lok ertih. ");
INSERT INTO ktm_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Su sinel hehndremte Yesus hahpa, “Ou eduwe odu atla mundre’ su puu holso kitih.” ");
INSERT INTO ktm_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesus ipahran pe su ha‑au odo mundren orngon kuti pe hondroh hala tam puu. Eri pe puu ndre sulo‑on, mukehe ndre pwerungeh (2000), hohtot hala ma‑au pe hondroh hala lon ndras. Su ndre sulo‑on hamat. ");
INSERT INTO ktm_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Su lau ndre mada’ su iso tam puu ti hohtot ha‑au pe helninen hala taon pe lok se yi ndre he‑en ertih. Pe sa lau hala helndre‑et. ");
INSERT INTO ktm_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Sa hala ti pe heltuwe orngon ndre su sinel hodo pule‑en pihe ti indretasan kolewen pe imin poi ndroda Yesus. Ngungong tadan indrinum. Ile pe sa lau honoh. ");
INSERT INTO ktm_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Su lau ndre hodo pe hendre‑et homosa ihir tan orngon ndre sinel hodo pule‑en ti henen ile ta sa lau. Su henen homosa ihir ile ta su puu ti yi. ");
INSERT INTO ktm_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ile pe sa lau odo lok erti honoh pe hapa ile ta Yesus ihpa, “Ou owou odo lok keti pe ala hepe yi.” ");
INSERT INTO ktm_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesus indreh ile yi ndre ndrol, pe orngon ndre Yesus iyes su sinel odo mundren ti ihndremte Yesus ihpa, “Yu upwe Ou ekuni yu ku‑us Ou.” ");
INSERT INTO ktm_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Odoke Yesus mboren pe ipe ile tadan ihpa, “Ala yi ndre emwem pe lonem, pe elninen kile ta su murwom. Ala pe enen homosa ndre Lapan ikarundrum ou pe ipu huyen ile tadam.” ");
INSERT INTO ktm_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ile pe orngon kuti iyeu, pe ile lon taon ndre sungoh ndre he‑en lok erti, pe inen homosa ndre Yesus ipupu‑uh odo henuwii iy. Sa lau ndre sulo‑on hohrungii pe hehretek. ");
INSERT INTO ktm_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesus indreh ile yi ndre ndrol pe ile yi ndre hodoh. Iy ilihir hodoh ti pe sa lau sulo‑on hala ndrongon iy odo papi. Su hapa hohrung nolwo‑on. ");
INSERT INTO ktm_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Pe orngon homou rangan Jairus ise hu Yesus. Jairus ti madan iso marai odo lon omwen surok sim. Iy ile pe pandrulku‑un ile poi idu kendrun ndriken Yesus, ");
INSERT INTO ktm_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","pe ihndremte puko‑on ihpa, “Yu nedu pihin ke imet. Ou asa lumwem kile tadan, kile pe iy kile huyen pe kimet kolwii.” ");
INSERT INTO ktm_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesus iyus iy harla, pe sa lau sulo‑on ho‑us yi. Homou intu‑uw ta homou, pe henelila hosokaltan Yesus ile. ");
INSERT INTO ktm_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pedih homou idu lenga’ sa lau, eri tadan sik. Iy ineruhti ndrai ti indrahpa ndre sa pedih se ti pwi. Sik tadan ti indrehir into mundrun ti pwi, pe kah idu tadan iyenon ndre krismas sungoh-pe-ruweh. ");
INSERT INTO ktm_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Iy indrepiyen mone‑en ndre sulo‑on ile ta sa ndrokta, odoke isella huyen ke pwi. Sik tadan ti ke illih mo‑on lakopwi. ");
INSERT INTO ktm_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Iy ihrungi sa lau heninen Yesus, ile pe iy irehen iy ile lenga’ sa lau ndre hodo ndruwen Yesus. ");
INSERT INTO ktm_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Iy idawene ihpa, “Uh yu kutkuni ke hepe ngerin kolos Tadan, eri sik todo we kinum.” ");
INSERT INTO ktm_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Iy itkuni kolos ta Yesus, pe ndrai tadan inum. Pe iy ihkalmanan lom mundren ihpa ndre sik tadan ti indrinum ndresale. ");
INSERT INTO ktm_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Idu ke ndre erti pe Yesus ihkalmanan ihpa ndre se puko‑on ti iyeu odo mundren. Ile pe Iy indre‑et ile ta sa pe ihndremte, “Si lumwen ile kolos Todo tih?” ");
INSERT INTO ktm_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Su disaipel Tadan hapa ihpa, “Sa lau ndre sulo‑on henelila ho‑us Ou ti hentu‑uw ke Tadam, pe Ou enehndremte ile sa?” ");
INSERT INTO ktm_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Odoke Yesus ma inendre‑et pe impondrih si lau ndre lumwen ile kolos Tadan. ");
INSERT INTO ktm_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Pedih kuti ihkalmanan sa indrihir tadan eri pe iy inuh pe ihreretek. Iy ile pe pandrulku‑un ile poi idu kendrun ndriken Yesus, pe inen sane ndre sulo‑on. ");
INSERT INTO ktm_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Pe Yesus ipe ile tadan ihpa, “Nedu, bilip tadam indrahnan ou ala huyem. Owou ala yi. Adawene sulo‑on kolwii. Sik tadam ti indrinum.” ");
INSERT INTO ktm_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesus ma inesohou ile tam pedih kuti pe lau se hehir. Su lau erti ho‑us um tan Jairus. Su hapa ile tan Jairus ihpa, “Jairus, ou nedum pihin ti indrimat. Konan, ekowi‑iy tisa ti kah kahrii.” ");
INSERT INTO ktm_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Odoke Yesus indretaryan nolou ta su lau kurti pwi. Pe Iy ipe ile tan Jairus ihpa, “Onoh kolwii. Opo ke bilip.” ");
INSERT INTO ktm_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Inum pe Yesus ikuni ke Pita, Jems, pe Jon tinton Jems, pe su ho‑us Iy. ");
INSERT INTO ktm_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Su helihir um tan Jairus ti pe Yesus iltuwe sa lau heneru‑iy pe hentehel. ");
INSERT INTO ktm_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Iy ile lon um pe ipe ile ta sa ihpa, “Oduu edentang pe edentehel ile sa? Enihin kiti indrimat pwi. Iy inemetir kopwi.” ");
INSERT INTO ktm_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pe su herikiyan Iy. Yesus ipe ile ta sa lau ndre sulo‑on hala kiu. Inum pe Iy ikuni taman pe tinen enihin kuti, ndrodan ndre su disaipel Tadan ndre tulmuu, pe su hala lon rum ndre enihin kuti iyin eriy tih. ");
INSERT INTO ktm_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pe Iy lumwen ile lumwen enihin kuti pe ipe ile nolou Aram ihpah, “Talita, kum.” Nolou erti ihpa ndre, “Enehin, yu upwe ile tadam, atlang!” ");
INSERT INTO ktm_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Pe enihin ti isupu‑ur imin eleng pe illa. Krismas tan enihin ti sungoh-pe-ruweh. Su heltuwei pe hehretek pe hemesi‑iy. ");
INSERT INTO ktm_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesus ipe ile ta su ihpa, “Etninen kile ta homou kolwii.” Pe Iy ipe su hopo song pe enihin ti kiyo‑on. ");
INSERT INTO ktm_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesus iyus erti pe ile yi ndre lonen Nasaret. Su disaipel Tadan ho‑us iy hala. ");
INSERT INTO ktm_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Idu Sabat eri Iy ile lon omwen surok pe ipehre Nolwo‑on Lapan ile ta sa lau. Sa lau sulo‑on hehrungi nolou ndre Iy ipehre ti pe hehretek Tadan pe hapa ihpa, “Iy lau kuti ihtunon sane kuti ihpa kehe? Iy impupu‑uh mirakulo yi! Pe puko‑on kuti Iy ikuni odo kehe? ");
INSERT INTO ktm_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Iy ti kamda ke porah. Iy tinen ti Maria, pe tinton su ti Jems, Yosep, Yudas pe Saimon. Pe timso‑on su ti hodo lenga’ tidu hodo kitih.” Ile pe su lau odo ke ndre lonen ti mbore’ su hopo bilip kile Tadan. ");
INSERT INTO ktm_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesus ipe ile ta su ihpa, “Profet ti we rangan huyen pe sa waso‑o’ sa tahrung Iy odo hokor pe hokor. Odoke lilin lonen eri we pwi. Su lin tinton pe timso‑on pe murwon ti we mbore’ su Iy.” ");
INSERT INTO ktm_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ile pe Iy indranon kindripo handrai mirakulo odo lonen ti pwi. Tapake sa sik ndramat se kopwi hala pe Iy iduwe lumwen ile mundre’ su pe su hala huye’ su. ");
INSERT INTO ktm_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesus idawene ile hudut, odosa sa lau odo lonen ti hendrupo bilip ile Tadan pwi tih. Yesus Ililngan Puko‑on Tadan Odoke Su Disaipel Hendrehtuno Su Iy Indrahii Pwi (Sapta 6.6—8.21) Inum pe Yesus ile lok hokor hokor pe ipehre Nolwo‑on Lapan. ");
INSERT INTO ktm_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Pe Iy iyuwen su disaipel Tadan ndre sungoh-pe-rumuu, pe itlangan su hala rumuu rumuu, pe ihtakalan su hala helpehre Nolwo‑on Lapan. Iy iduwe puko‑on odo as sinel ile ta su. ");
INSERT INTO ktm_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Iy ipe ile ta su ihpa, “Atakun hangka‑an kolwii, tapake kendro odo lila. Atakun song kolwii. Atakun ndrop kolwii. Atakun moni kolwii. ");
INSERT INTO ktm_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Atawe su‑e’ oduu. Atakun nuhnuh kile ruweh kolwii, tapake iy ndre idu mundren oduu.” ");
INSERT INTO ktm_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Iy ipe ile ta su yi ihpa, “Uh oduu atla hokor lok pe si lau kiyuwen oduu, eri otto ke ndre um tadan uu kenon ndre oduu ada‑au odo lok ertih. ");
INSERT INTO ktm_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Uh oduu atla hokor lok pe sa lau hendreyuwen oduu atla um pwi, pe hendretahrung oduu pwi eri oduu atakorohon wahun poi odo ndrike’ oduu kidu mada’ su, kinum pe ada‑au. Kile pe su hohtuno su ihpa ndre su ti hendrupo mo‑on.” ");
INSERT INTO ktm_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ile pe su disaipel ndre sungoh-pe-rumuu ti halla hala hokor pe hokor pe hopo marai. Pe su hapa ile ta sa lau ihpa, “Ada‑au odo punou mo‑on ndre oduu edempo tih.” ");
INSERT INTO ktm_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Su ha‑as sa sinel odo ta sa lau. Sa ndre hamat sik ti su disaipel hetndrenge ndronun mbrwen oliv ile pule‑e’ sa, pe sa hala huye’ sa. ");
INSERT INTO ktm_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","King Herot ihrung kaunan Yesus. Sa lau se heninen ihpa, “Jon Baptais indrila yi ndre moren, erti uu pe puko‑on odo pupu‑uh mirakulo ti imin ndrongon iy.” ");
INSERT INTO ktm_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Sa se ti hampa ihpa, “Iy kiti Profet Elaijah.” Sa se yi ti hampa ihpa, “Iy kiti profet homou yi, ihpa ndre su profet se ndre pihe tih.” ");
INSERT INTO ktm_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herot ihrungi nolou ndre sa hampa ti pe ipe ihpa, “Yu unsimndri padawon Jon Baptais ti ndre pihe, pe pwi ti kihne iy inna yi ndre moren.” ");
INSERT INTO ktm_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Pihe ti, Herot ipe ile ta su lewen pe hondrotowe Jon Baptais pe heduwe iy ile kou. Herot ipu kuti odosa, iy iyesuwon Herodias mbrulun tinton ke Filip, ");
INSERT INTO ktm_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","odoke Jon impa ile tadan ipe iy erti punou mo‑on. ");
INSERT INTO ktm_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ile pe Herodias ti lon ndrinen inai ile tan Jon pe ipe kihnan iy kimet, odoke indranon pwi, ");
INSERT INTO ktm_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","odosa Herot ti inoh tan Jon. Herot tunon ihpa ndre Jon ti iy lau kapin odo madan Lapan, ile pe iy intawe Jon immin huyen. Herot waso‑on tahrung sohou tan Jon, tapake nolou Jon impa ti inahnan tawene ta Herot inehrut. ");
INSERT INTO ktm_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Patmundrun ndre Herodias ingkeli‑iy ti ihir. Herot ihnan song mandra‑an idu mundrun rang ndre tinen iduwe iy idu eriy tih. Iy ihnan song erti ana’ su lau mandra‑ane odo marai tadan, su lau mandra‑ane odo ami, pe ana’ su lau mandra‑ane odo Distrik Galili. ");
INSERT INTO ktm_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Su ndre hana‑an song ti pe nedun Herodias pihin ile lon um pe indren ise purmada’ su. Herot ndrodan ndre su lau hana‑an song ti hahwaso‑o’ su ndran tan enihin kutih. Ile pe Herot ipe ile tan enihin kuti ihpa, “Homosa ou wasu‑um, eri yu we kuduwe tadam.” ");
INSERT INTO ktm_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Inum pe Herot idamumoi ihpa, “Mondre Eleng, homosa ou ehndremte yu kile eriy ti yu we kuduwe tadam. Ipe ye ou wasu‑um hombrul kantri todo, eri yu we kutpili kile rumbrul, pe kuduwe hombrul kile tadam.” ");
INSERT INTO ktm_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Enihin kuti ile kiu pe ihndremte tinen ihpa, “Yu we kupwe wasu‑u sa?” Tinen ihpa, “Palan Jon Baptais.” ");
INSERT INTO ktm_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Enihin ti ihtot ile ndre ndrongon king pe ipe ihpa, “Yu wasu‑u mahkele kopwi, palan Jon Baptais kimin lom pelet.” ");
INSERT INTO ktm_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","King ikarundrum lakopwi, odoke iy we kindripo kihpa kehe pwi, odosa iy ‘indretamumoi eleng’ idu mada’ sa lau mandra‑ane tih. ");
INSERT INTO ktm_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ile pe iy ipe ile ta soldia homou ihpa, “Ala sowin kopwi, pe esimndri won Jon Baptais. Eduwe palan kile lon sih pelet pe ekuni kise.” Soldia kuti ile omwen kou pe isimndri padawon Jon ");
INSERT INTO ktm_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","inum pe iduwe palan Jon ile lom pelet pe iduwe ile tan enihin kurtih. Enihin ti ikunii pe iltawei ile tan tinen. ");
INSERT INTO ktm_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Su disaipel tan Jon hohrungi mat tadan ti pe su hala haltakuni iy, pe heltawe iy ile lon ngat. ");
INSERT INTO ktm_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Su aposel hondrupo marai kah, pe kah hala yi ndre hu Yesus. Pe su hennen marai sa su hopo pe nolou sa su hapa ti ile ta Yesus. ");
INSERT INTO ktm_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Odoke sa lau sulo‑on lakopwi halla pe hassa, ile pe Yesus pe su aposel handranon hamyau pe heyo‑on song pwi. Ile pe Iy ipe ile ta su ihpa, “Tidu tida‑au titla hepe ndre ndramat pwi tih. Kile pe oduu etmiyau hepe.” ");
INSERT INTO ktm_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ile pe su hondroh hala ndrol sih pe ha‑au hala lok sehir ndre ndramat hondruto eriy pwi. ");
INSERT INTO ktm_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Odoke sa lau heltuwe su ka helih ti pe sa sulo‑on odo taon sih pe sih odo distrik erti hohtot sal eleng ea, pe helengkeli‑iy holto munen. ");
INSERT INTO ktm_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesus indreh ile pwoi odo ndrol, pe iltuwe sa lau sulo‑o’ sa lakopwi. Pe Iy ikarndrum su ile mandra‑an, odosa su hahpa ndre sipsip ndre homou madan indriso ta su pwi. Ile pe Iy itou punou pe tatuhne ile ta su odo sane sulo‑on. ");
INSERT INTO ktm_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Lok ndre kah inna pehon lakopwi, pe su disaipel halpa ile Tadan ihpa, “Lok kihne kah kile lukumwen pe lok keti isiso alau. ");
INSERT INTO ktm_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Apa kile ta sa lau ha‑au, kile pe sa hala lok ndre he‑en mukehe ti pe hesih ana’ su song pe hoyo‑on.” ");
INSERT INTO ktm_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pe Yesus ipe ihpa, “Oduu ti we otpo song pe su hoyo‑on.” Su hehndremte Yesus, “Ou wasu‑um apa odu otpo rupweu moni pe atla sihsih bret ana’ su pe su hoyo‑on, erih?” ");
INSERT INTO ktm_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesus ihpa, “Bret idu ndrongo oduu ti heski? Atla ndre‑et oh.” Su hala helndre‑et inum pe hasa yi pe hapa ihpa, “Bret limihir pe ni rumuu.” ");
INSERT INTO ktm_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesus ipe ile ta su disaipel Tadan hatparan sa lau hala hemir hemir pe hapa ile ta su hemin poi pule‑en mundriu. ");
INSERT INTO ktm_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ile pe sa lau hemin poi. Se sangat ea, pe se limngeh ea. ");
INSERT INTO ktm_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Inum pe Yesus ikuni bret ndre limihir pe ni ndre rumuu ise lumwen. Iy madan ile eleng, pe ide urehen Lapan. Iy iptan bret inum pe iduwe ile ta su disaipel, pe su hetlenge ile ta sa lau. Pe Iy itmbre‑e ni ndre rumuu ti pe itlangan ile ta sa lau yi. ");
INSERT INTO ktm_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Sa lau ndre sulo‑on hoyo‑on pe ilanon ndre sa. ");
INSERT INTO ktm_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Inum pe su disaipel hadaparngan bret pe ni ndre irswe ti pe hedehen ile ndrop ndre sungoh-pe-ruhet. Ndrop erti ndre haltah. ");
INSERT INTO ktm_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Su lau kamal ndre hoyo‑o song kuti eri ndre polimngeh (5000). ");
INSERT INTO ktm_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Idu ke ndre sa lau hoyo‑on song kah ti pe Yesus ipe ile ta su disaipel hondroh ile ndrol pe henemunen hala Betsaida. Betsaida ti ise tolau rai odo ndras Galili hodoh. Yesus ti ipe we kihtakalan sa lau ha‑au yi ndre oh, kinum pe Iy kidu omur ta su disaipel. ");
INSERT INTO ktm_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Iy ipe ile ta sa lau ha‑au ndre oh, inum pe Iy inek ile puliy pe ilsurok. ");
INSERT INTO ktm_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Lok ti kah inna lukumwen pe ndrol ti indra‑au inna ndrokoron ndras, pe Yesus Iy kopwi into ndre poi. ");
INSERT INTO ktm_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Pe Iy iltuwe su disaipel hempuke puko‑on ile suwei, odosa langat mandra‑an idu munen pe ineruhi ndrol ise yi ndre omur. Ndre lirang ti pe Iy illa iyus pule‑en wo ile ndrongo su. Iy ipe kihrik ndresale, ");
INSERT INTO ktm_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","odoke su heltuwe Iy inelila iyin pule‑en wo. Su hapa yi sinel pe su hedehel, ");
INSERT INTO ktm_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","odosa su heltuwe Iy pe honoh ile mo‑on. Yesus iporitai inlou lakopwi ile ta su ihpah, “Otnoh kolwii. Iy keti Yu.” ");
INSERT INTO ktm_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Inum pe Iy inek ile lon ndrol ndroda su, pe yor imet. Su hehretek ile mo‑on pe poho’ su idu kopwi, ");
INSERT INTO ktm_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","odosa, su ma hontut ile ta Yesus. Pingi kopwi ti pe Iy ihlingi sa lau ndre polimngeh ile bret ke limihir, odoke su disaipel tuno’ su Iy inna huyen mapwi. Su pala’ su mapwi intut. ");
INSERT INTO ktm_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Su hesuwei ile ndras hodoh pe halras ile Genesaret pe heswi ndrol iseu. ");
INSERT INTO ktm_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Su hondroh odo ndrol ile poi ti pe sa lau mada’ sa ile, pe hahpa, “Orkom, iy eti Yesus.” ");
INSERT INTO ktm_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ile pe nolou ihtot ile lok ndre sulo‑on odo erti, pe sa lau hehtuno sa ihpa ndre Yesus insa. Uh kaunan Iy imin lok kehe, eri sa hentawe sa lau sik hala petle pe henesori su halla hu Yesus. ");
INSERT INTO ktm_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Taon pe lok ndre sulo‑on kehe ndre Yesus ile eriy, eri sa hentakuni sa sik halla malal. Pe sa henehndremte Yesus kihran iy pe sa sik heduwe lumwe’ sa kile ngerin kolos Tadan. Pe sa sik ndre sulo‑on ndre lumwe’ sa itkuni kolos Tadan ti hala huye’ sa. ");
INSERT INTO ktm_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Su Paraseo pe su tisa se odo Lo ta Moses ho‑us Yerusalem hala Galili pe henelukum Yesus. ");
INSERT INTO ktm_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Pe su hendroni su disaipel se ta Yesus hesenesingen lumwe’ su illa huyen pwi, odoke ke hana‑an ke song. ");
INSERT INTO ktm_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","4","(Su Paraseo pe su Yuda ti hondrotowe punou ta su il ta su ti ile puko‑on lakopwi. Su we hendreyo‑on song pwi uu kenon ndre su hesingen lumwe’ su. Singi lumwei ti ndre kastam tadan. Song odo suhen ti we hesingen ndre oh, kinum pe su hoyo‑on. Lo ta su il ta su yi ti ipaninyan kastam odo singi kap, pe singi kur, pe singi palet, pe singi lok odo metir.) ");
INSERT INTO ktm_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ile pe su Paraseo pe su tisa odo Lo hehndremte Yesus ihpa, “Ei, Yesus. Su lewim ti hesenohtot punou ta su papo’ tidu pwi ti ile sa? Su lumwe’ su mo‑on odoke hantakun song pe hana‑an ti ou apa huyen?” ");
INSERT INTO ktm_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesus isomwi su ihpa, “Oduu ti ndramat odo tawiwihi sa lau. Profet Aisaiah pihe idetorwe Nolwo‑on Lapan ti idu‑uw taduu. Nolou erti ipe ihpa: “‘Su lau kiti henesori rongo iso poho’ su, odoke tawene ta su ti indrito Todo pwi. ");
INSERT INTO ktm_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Surok su hompo ile Todo ti porah kopwi. odosa lo ndre su hempehre ti sa ndramat hadatorwei. Lo erti Yu undretawei pwi.’ ");
INSERT INTO ktm_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Oduu ti edengkakik puko‑on ile sal ndre ndramat iduwei, pe etndre‑au odo Lo ndre Lapan iduwei.” ");
INSERT INTO ktm_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesus ipe ile ta su lakopwi yi ihpa, “Oduu ti tuno’ oduu lakopwi odo pondrih sal odo atawe Lo ta Lapan kile mahun, pe atkakik puko‑on kile lo ndre sa ndramat hahnan. ");
INSERT INTO ktm_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Lo ta Lapan ndre Moses iduwei ti ipe ihpa, ‘Oso pahndran tamam horu tinem, pe opo huyen kile ta horu.’ Lo erti ipe yi ihpa, ‘Si kom kipu nolou mo‑on kile pule‑en taman horu tinen ti we hapwi iy kimet.’ ");
INSERT INTO ktm_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Odoke oduu etawe lo handrai ihpa, ‘Uh homou lau kipahran pohon kile moleu ipe iy we kihngahang Lapan kile sane, eri iy lau erti we kindrahngahang taman horu tinen kile hangka‑an pwi.’ ");
INSERT INTO ktm_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Lo taduu kuti ihnan, ile pe iy lau kuti we kindranon kindrehnuwii taman horu tinen pwi. ");
INSERT INTO ktm_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Iy lo ndre oduu edempo kuti inahnan lo ndre ndramat ihnan ti illa puko‑on, pe Lo ndre Lapan iduwei ti illa hangka‑an ke porah. Pe oduu edemposisihen sane sulo‑on yi ihpa ke kutih.” ");
INSERT INTO ktm_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesus iyuwen sa lau hala hun Iy yi, pe ipe ile ta su ihpa, “Oduu ndre sulo‑on atawe ndralnga’ oduu kise, pe atahrung kehii. Atawonon nolou ndre Yu ka we kupwe kutih. ");
INSERT INTO ktm_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Sane odo kiu ndre ndramat intakuni hala lom mundren ti handranon hahnan iy kile mo‑on odo madan Lapan pwi. Tapake sane ndre honu‑us lom mundren ndramat hassa moleu ti hanahnan iy illa mo‑on odo madan Lapan. ");
INSERT INTO ktm_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ou si ndre ndralngam, eri ehrungi nolou kuti kehii.” ");
INSERT INTO ktm_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesus isohou ta sa lau oh, inum pe Iy iyeu ile lonu‑um. Pe su disaipel hehndremte Iy, “Mining odo nolou Ou ampa mahkele ti ihpa kehe?” ");
INSERT INTO ktm_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesus ipe ihpa, “Oduu ti tawene ta oduu murun. Oduu tuno’ oduu pwi, erih? Homosa ndre ki‑us kiu pe kile lon ndrinen ndramat, eri kindranon kihnan ndramat kinna mo‑on odo madan Lapan pwi, ");
INSERT INTO ktm_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","odosa hangka‑an erti inna lon ndrinen ndramat ndre ndrokene pwi. Hangka‑an erti ile ke salan song, inum pe ile salan ndre, inum pe iyeu ise yi ndre moleu.” Yesus ipahran nolou kuti, odosa iy ipe song ndre sulo‑on ti huyen kopwi odo yo‑on. ");
INSERT INTO ktm_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","23","Pe Yesus ipe lakopwi yi ihpa, “Sane ndre honu‑us lon ndrinen ndramat hassa kiu ti hanahnan ndramat illa mo‑on odo madan Lapan. Lon ndrinen ndramat ti intawe tawene mo‑osa pe pahna. Lon ndrinei ti intawe tawene odo up ndramat kimet, ndramat impo kowos ile tam pedih pe kamal mbrulndrat, pe ndre‑em putmo‑oi. Lon ndrinei ti intawe taheweh, ndringis sane ta lau homou yi, mah‑ah pwi odo punou mo‑on, ndramat hassap sa, taninen ndramat homou yi pe sane sulo‑on mo‑osa yi. Iy sane kuti honu‑us lon ndrinen ndramat pe henahnan ndramat illa mo‑on odo madan Lapan.” ");
INSERT INTO ktm_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Inum pe Yesus pe su disaipel Tadan ha‑au odo Galili, pe hala lok sehir ise tolau ea. Su helihir koson siti odo Tair. Tair ti ise koson ndras mandra‑an Mediterenia. Yesus ipe sa lau hohtuno sa pe heltuwe Iy kolwii. Iy ile lon um sim, odoke Iy itong ta sa lau tahit. ");
INSERT INTO ktm_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Pedih homou ihtunon ihpa ndre Yesus ti insa. Iy nedun pihin ti sinel imin pule‑en pe inahnan iy ile sik. Iy iporitai kopwi ile hu Yesus pe pandrulku‑un ile poi idu kendrun ndriken. ");
INSERT INTO ktm_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Pedih kuti iy odo Yuda pwi. Iy ti odo Fonisia, ise lok mandra‑an Siria. Iy idu purmadan Yesus pe ihndremte puko‑on ipe Yesus ki‑es sinel odo mundren nedun pihin. ");
INSERT INTO ktm_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Odoke Yesus ipe ihpa, “Tidu titawe song ana’ su nonkom ti kile ta mweh kolwii. Su nonkom ti hoyo‑on oh uu ndre kenon su.” ");
INSERT INTO ktm_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Odoke pedih kuti ipe ihpa, “Ou ampa ti imel, lau il, odoke mweh ndre iso pahndran tepol ti ina‑an tikin lehe’ su nonkom yi.” ");
INSERT INTO ktm_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesus ipe ile tadan ihpa, “Ou apa ihpa kirtih? Eri ka emin eleng pe ala yi ndre ndrongon nedum. Sinel indra‑au odo pule‑en.” ");
INSERT INTO ktm_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Pedih ti ile yi ndre omwen pe iltuwe nedun pihin ti inemetir iyin lok. Sinel indra‑au odo pule‑en ndre ndrokene. ");
INSERT INTO ktm_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesus ipe kise yi ndre Galili, ile pe Iy itlang odo mukehe Tair pe ile tolau ea, pe ihir Saidon. Inum pe Iy isondrih ndrokoron lok uu pe ilihir Dekapolis. ");
INSERT INTO ktm_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Pe sa lau hekuni orngon homou ile hu Yesus. Orngon kuti isentahrung lok pwi pe inolou idu ke lon kolon. Sa lau hosohou karundrum ile ta Yesus, hapa Yesus kiduwe lumwen kile pule‑en. ");
INSERT INTO ktm_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ile pe Yesus ikuni orngon kuti ile mahun odo ta sa lau ndre sulo‑on. Iy iduwe kopwen lumwen hala lon ndralngan orngon kutih. Inum pe Yesus imburnguh ile kopwen lumwen oh pe iduwe ile kalilmen orngon kutih. ");
INSERT INTO ktm_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Pe iy indre‑et ile eleng ile heven, ihti ngohon puko‑on, pe ipe ile tan orngon kuti ihpa, “Efata!” (Iy erti ihpa, “Erwei!”) ");
INSERT INTO ktm_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Eri pe orngon ti ihrung lok lakopwi. Hangka‑an ndre inehndrepti kalilmen ti iyeu, pe iy isohou ile huyen. ");
INSERT INTO ktm_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Pe Yesus isinip ana’ sa lau we hendreninen pwi. Iy isinip ana’ su odoke su heninen lakopwi. ");
INSERT INTO ktm_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Sa lau ndre sulo‑on hehretek pe hemesi‑iy. Sa hapa ihpa, “Orkom, Iy impo sane ndre sulo‑on ti huyen kopwi. Sa lau ndre poho’ sa pwi ti Iy inahnan sa henosohou yi, pe sa ndre ndralnga’ sa pwi ti hentahrung yi.” ");
INSERT INTO ktm_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Idu petsih yi, eri pe lau pohpou pohpou hesetahrung Yesus. Su ana’ su song pwi, ile pe Yesus iyuwen su disaipel Tadan pe ipe ihpa, ");
INSERT INTO ktm_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Yu ukarndrundrumwi sa lau kutile. Su hodo ndroda yu rang kah tul, pe ana’ su song pwi. ");
INSERT INTO ktm_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Uh Yu kupwe kile ta su ha‑au, eri su we mada’ su kinun pe helkis odo sal, odosa su hamat song pe Yu undrupo song ile ta su pwi tih. Su se ti ho‑us alau pe hasa ketih.” ");
INSERT INTO ktm_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Su disaipel Tadan hapa ile Tadan ihpa, “Lok tidu tito eriy keti ndramat hesento eriy pwi, pe tidu we titpondriti song odo kehe pe titawei kile ta sa lau hoyo‑on?” ");
INSERT INTO ktm_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesus ihndremte su ihpa, “Oduu bret heski idu ndrongo oduu?” Su hahpah, “Ndrotulihir kopwi.” ");
INSERT INTO ktm_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesus ipe ile ta sa lau ndre sulo‑on hemin poi. Iy ikuni bret ndre ndrotulihir kuti ise lumwen, pe Iy ide ureh ile ta Lapan. Inum pe Iy ipatan bret pe iduwe hala lumwe’ su disaipel pe su disaipel hetlenge ile ta sa lau. ");
INSERT INTO ktm_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Netnedun ni se mone hodo yi, ile pe Yesus ide urehen Lapan ile eriy yi. Pe Iy ipe ile ta su disaipel hatlangan yi. ");
INSERT INTO ktm_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Lau ndre pohangoh (4000) ti hoyo‑on pe ilruson ndre sa. Su disaipel hetparngan tikin song irswe ti pe hedehen ndrop ndre ndrotulehet ile eriy. Yesus ipe ile ta sa lau ha‑au yi, ");
INSERT INTO ktm_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","inum pe Iy ndroda su disaipel Tadan sowin kopwi hondroh ile ndrol pe hala Distrik Dalmanuta. ");
INSERT INTO ktm_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Su Paraseo hapa hehkelmene Yesus ile pe su hala pe helehkike‑ei nolou ndrodan Iy. Su hapa ile Tadan ihpa, “Yesus, opo handrai mirakulo, kile pe odu edehtuno odu ihpa ndre Ou ti ompo maryan Lapan. Pe kile pe odu edeltuwei kihpa ndre puko‑on ta Lapan ti imin ndrongon Ou.” ");
INSERT INTO ktm_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesus ihkalmanan mundren ile pede‑en pe Iy ihti ngohon ile puko‑on. Iy ipe ihpa, “Ihpa kehe pe su lau odo mahkele ti waso‑o’ su hendre‑et handrai mirakulo tih? Odoke Yu kupwe kile ta oduu. Pwi, we etndrendre‑et pwi.” ");
INSERT INTO ktm_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Iy iyeu ta su, pe indreh ile yi ndre ndrol ndroda su disaipel Tadan pe ha‑au ile ngerin ndras hodoh. ");
INSERT INTO ktm_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Su disaipel kolo’ su isumwen pe hendretakun song sulo‑on pwi. Bret sehir kopwi su hokunii ti ke imin lon ndrol ndroda su. ");
INSERT INTO ktm_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesus ipakolou su ihpa, “Edempahar odo yis ta su Paraseo, pe yis ta Herot.” ");
INSERT INTO ktm_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Su disaipel, homou iparuhur ile ta homou pe hapa ihpah, “Iy kihne kimpa kuti odosa, tidu song pwi ti ndreh?” ");
INSERT INTO ktm_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesus tunon homosa su hampa ti, ile pe ihndremte su, “Oduu edenesohou ile ‘bret pwi’ ti ile sa? Oduu ti mapwi edentut, eri? Oduu ti kolo’ oduu murun, eri? ");
INSERT INTO ktm_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mada’ oduu ti henendre‑et ndre pwi? Ndralnga’ oduu ti hertahrung ndre pwi? Oduu edentahorungon ndre pwi? ");
INSERT INTO ktm_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Idu kalmene‑en Yu uptan bret ndre limihir pe su lau ndre polimngeh (5000) hoyo‑on, pe tikin herswe ti oduu etehen ile ndrop ndre heksi?” Su hahpa, “Sungoh-pe-ruhet.” ");
INSERT INTO ktm_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Pe Yesus ihndremte yi ihpa, “Pe idu Yu uptan bret ndrotulihir ile ta sa lau ndre pohangoh (4000), oduu etehen tikin ndre herswe ti ile ndrop hesiki?” Su hahpa, “Ndrotulehet.” ");
INSERT INTO ktm_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Eri pe Yesus ipe ihpa, “Oduu tuno’ oduu oh, pe ihpa kehe pe ma edentawene hudut? Yu usempa song ti pwi.” ");
INSERT INTO ktm_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesus pe su disaipel hehir hala Betsaida. Pe sa lau se hokuni orngon homou ile hu Yesus. Orngon ti madan pwi, ile pe su lau ti hosohou karundrum ile ta Yesus, hapa Yesus kiduwe lumwen kile pule‑en. ");
INSERT INTO ktm_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Iy ikuni orngon kuti ile ngerin lok, pe Iy imburnguh ile madan orngon kutih. Inum pe Iy lumwen ile madan orngon kuti pe ihndremte, “Ou eneltuwe hangka‑an ndre pwi?” ");
INSERT INTO ktm_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Orngon ti isori madan pe ipe ihpa, “Yu uneltuwe sa lau, odoke su hahpa ndre kei henelila hasa pe hala.” ");
INSERT INTO ktm_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ile pe Yesus iduwe lumwen ile madan orngon kuti petsih yi. Pe orngon ti ihlilis puko‑on pe madan inim ndresale pe indre‑et sane ile huyen. ");
INSERT INTO ktm_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Inum pe Yesus ipe ile tadan ihpa, “Owou ndresale ala emwem. Nombrun ala yi ndre Betsaida.” ");
INSERT INTO ktm_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesus pe su disaipel Tadan hapa hala lok se mone odo koson taon Sisaria Filipai. Su ma hodo sal ti pe Yesus ihndremte su, “Sa lau hapa Yu ti si?” ");
INSERT INTO ktm_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Su hapa ihpah, “Sa se hapa Ou ti Jon Baptais, sa se hapa Ou ti Elaijah, pe sa se yi ti hapa Ou ti homou profet odo ndre pihe.” ");
INSERT INTO ktm_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesus ihndremte su, “Pe oduu? Oduu atpa Yu ti si?” Pita ihpah, “Ou ti Kristus.” ");
INSERT INTO ktm_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ile pe Yesus isinip ana’ su ihpa, “Etninen nolou kiti kile ta homou lau kolwii.” ");
INSERT INTO ktm_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Inum pe Yesus kah idetuhne su disaipel Tadan. Yesus ipe ihpah, “Lapan iduwe Nedun Ndramat ise poi ti odo we kisikun ngendre‑en mandra‑an. Su lau ndre hene‑en munen odo lotu ti we hehmbore su Iy, pe mandra‑an ta su pris ile ndroda su tisa odo lo ti we mbore’ su Iy. Pe sa ndramat we hapwi Iy kimet. Odoke rang tul kinum ti pe Iy we kile yi ndre moren pe kitlang yi.” ");
INSERT INTO ktm_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iy inen pede‑en pe ngendre‑en ndre sulo‑on ndre Iy we kikun ti ile ke moleu ile ta su disaipel. Ile pe Pita ikuni Yesus ile mahun pe ipe ile Tadan ihpah, “Yesus. Ou apa kihpa kiti kolwii.” ");
INSERT INTO ktm_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Odoke Yesus madan ile yi ndre ta su disaipel pe ihrurute ile tam Pita ihpah, “Satan, ala ndruwe! Ou kolum ti indrahpa ndre kolon Lapan ti pwi. Kolum ti kolon ndramat odo lokpoi.” ");
INSERT INTO ktm_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Inum pe Yesus iyuwen su lau ndre sulo‑on ndroda su disaipel hala hun Iy. Pe Iy ipe ile ta su ihpa, “Iy si lau ndre ipe kile lewi, eri kiduwe sane ndre iy ipe kipu ti hala ke tuwei, pe iy kisori kei tondrih tadan, pe kise ki‑us Yu. ");
INSERT INTO ktm_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Odosa iy si lau ndre kihmboren sengin kikun pede‑en pe kimet, eri mulwen we kimin mo‑on. Odoke iy si lau ndre kimet, odosa iy ti lewi pe ininen gutnius Todo, eri mulwen we kimin huyen. ");
INSERT INTO ktm_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Uh homou lau kikuni tadan lokpoi ndre sih, odoke mulwen we kimet, eri sane tadan ndre sulo‑on kuti we hehnuwii iy kihpa kehe? ");
INSERT INTO ktm_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Sane ndre sulo‑on tadan kiti handrai kindranon kisihnen mulwen kile eriy pwi. ");
INSERT INTO ktm_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ndramat odo mahkele ti hendretawe ndruwe’ su ile ta Lapan, pe hompo ke punou mo‑on. Ile pe uh si lau ndre kimah‑ah Todo, pe kimah‑ah odo nolou Todo, eri Yu we kumah‑ah tadan. Yu we kumah‑ah tadan kidu mundrun ndre Yu we kukuni puko‑on tan Tomo, pe kuse yi ndroda su engel tih.” ");
INSERT INTO ktm_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Pe Yesus ipe ile ta su ihpa, “Yu upwe ndre ndrokene kile ta oduu. Sa se lau ndre ka hentahrung Yu hodo keti we hendrimat mapwi, pe su we hendre‑et puko‑on mandra‑an tan kapman ta Lapan, kidu kapman ta Lapan kihir tih.” ");
INSERT INTO ktm_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Rang on inum oh ti pe Yesus ikuni Pita, Jems pe Jon, pe su ho‑us Iy hala puliy sih elwe‑en. Sa homou lau indru‑us su pwi. Su hapa hendre‑et ti pe Yesus mundren inna handrai yi. ");
INSERT INTO ktm_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kolson ti inna peren peren lakopwi. Homou lau odo lokpoi kindranon kindresingi kolau kinna peren kihpa ndre erti pwi. ");
INSERT INTO ktm_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Inum pe su heltuwe Elaijah horu Moses herihir yi, pe herenesohou ndroda Yesus. ");
INSERT INTO ktm_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita inlou ile ta Yesus ihpa, “Tisa todo. Huyen lakopwi odo tidu tito ketih. Yu pe Jems pe Jon we otumon pandrol tulpwing. Sim Tadam, sim tam Moses pe sim tan Elaijah.” ");
INSERT INTO ktm_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita ipe kuti porah kopwi, odosa su ti honoh ile mo‑on. ");
INSERT INTO ktm_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Inum pe kohut hene ihir pe kanunuwen isorohe su. Pe pohon Lapan ihir odo lon kohut kuti pe ipe ihpa, “Iy kuti Nedu. Yu wasu‑u Iy lakopwi. Oduu atahrung nolou Tadan.” ");
INSERT INTO ktm_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Su hendre‑et ile sehir pe sehir, pe mada’ su ihpilpil kopwi ti pe Yesus Iy kopwi idu. Elaijah horu Moses ti herndrela hepe yi. ");
INSERT INTO ktm_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Su ka hana‑au hasa yi ndre pwoi, pe Yesus ipe ile ta su ihpa, “Sane ndre oduu etndre‑et mahkele, eri etninen kile ta homou lau kolwii, kenon ndre Nedun Ndramat ti kimet oh pe ndre kindretalang yi.” ");
INSERT INTO ktm_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Su hendrininen ile ta homou pwi, odoke su ke ndre su ti hampa ihpa, “Talang odo mat ti homosa?” ");
INSERT INTO ktm_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Pe su hehndremte Yesus, “Ihpa kehe pe su tisa odo Lo ti hapa Elaijah ti we kihir ki‑in munen oh, kinum pe Kristus we kihir?” ");
INSERT INTO ktm_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesus ipe ihpa, “Nolou kirti ndre ndrokene. Elaijah ti we kise ki‑in munen pe kisahnan sane ndre sulo‑on he‑en kile huyen. Odoke ihpa kehe pe nolou iyin Buk ta Lapan ti ipe Nedun Ndramat ti we kilnget ngendre‑en sulo‑on pe sa we mbore’ sa tahrung Iy tih? ");
INSERT INTO ktm_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yu kah kunen kile ta oduu. Elaijah ti insa kah. Odoke sa lau hepupu‑uh punou mo‑on ile pule‑en, ihpa ndre nolou iyin Buk ta Lapan ipe we kihpa ndre eriy tih.” ");
INSERT INTO ktm_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesus, Pita, Jems pe Jon kah hehir yi ndre ndroda su disaipel huren tih. Pe su heltuwe sa lau sulo‑on lakopwi hodo ndroda su disaipel se yi tih. Pe su tisa odo Lo ti henehkike‑ei ndroda su disaipel. ");
INSERT INTO ktm_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sa ndre sulo‑on hendroni Yesus ti pe hehretek ile mo‑on. Sa hohtot hala pe hopwo-es Iy. ");
INSERT INTO ktm_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesus ihndremte ihpa, “Oduu edenehkike‑ei ile sa?” ");
INSERT INTO ktm_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Orngon homou idu lenga’ su lau ti inlou ihpa, “Tisa, yu usetudou nedu kamal ise hun Ou. Sinel imin pule‑en pe inahnan iy isenolou pwi. ");
INSERT INTO ktm_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Sinel ti inak ile pule‑en pe inahnan iy intaketi illa pwoi, pe lehen inehndrepit, pe mbruse‑en pohon ihir, pe mundren ndre homou ineselke‑e. Yu uhndremte su disaipel Tadam upwe su hahnan iy kile huyen, odoke su handranon pwi.” ");
INSERT INTO ktm_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesus ipe ile ta su ihpah, “Oduu lau kiti taduu bilip pwi. Yu we kumwin ndrodan oduu elwe‑en kihpa ndre kehe yi? Yu we kukun pede‑en ta oduu pat hesiki yi? Atakuni anah ti kise!” ");
INSERT INTO ktm_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Su lumwe’ su ise lumwen anah kuti ile hu Yesus. Sinel imin pule‑en anah kuti indroni Yesus ti pe ihnan anah ti iselke‑e, pe anah ti ideketi ile poi pe ingkilkil. Anah ti mbruse‑en le. ");
INSERT INTO ktm_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ile pe Yesus ihndremte taman anah kuti ihpa, “Iy impo ihpa kuti kah rang heski?” Taman anah ti ihpa, “Iy mapwi lehyen ti impo ihpa ke kutih. ");
INSERT INTO ktm_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Hangka‑an ndre inahnan iy ti ipe kinahnan iy kimet, ile pe impiyen iy ile lo yih pe lo wo. O Yesus, uh Ou owonon, eri akarundrum pe ehnuwii oru nedu.” ");
INSERT INTO ktm_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus ipe ihpah, “Yu uwonon, odosa Lapan kenon kipu sane ndre sulo‑on odo henuwii si ndramat ndre tadan bilip tih. Odoke ou ti opo bilip ndre pwi?” ");
INSERT INTO ktm_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Taman anah kuti isomwi Yesus sowin kopwi ihpah, “Yu upu bilip, odoke bilip todo ti mandra‑an pwi. Ehnuwii yu, kile pe bilip todo kile mandra‑an.” ");
INSERT INTO ktm_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesus iltuwei ihpa ndre sa lau ka henehndur hala koson, ile pe Iy inlou puko‑on ile ta sinel ti ihpa, “Singlen walul pe pohpiw, yu upwe ile tadam, asa moleu pe owou odo mundren anah kirtih, pe ala yi kolwii!” ");
INSERT INTO ktm_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Sinel ti idehel ile mo‑on, pe irson anah kuti ile poi, inum pe indreh iyeu. Anah kurti hepe mehleu pwi iyin poi, pe sa lau ndre sulo‑on hapa yi iy indrimat. ");
INSERT INTO ktm_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Odoke Yesus lumwen ile lumwen pe isori iy imin eleng. Anah ti moren pe idu eleng. ");
INSERT INTO ktm_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Idu ndre omur, Yesus pe su lewen kopwi hodo lon um ti pe su hehndremte Yesus ihpa, “Ihpa kehe pe odu etndranon etndre‑as sinel kuti pwi tih?” ");
INSERT INTO ktm_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Pe Yesus ipe ihpa, “Tapa surok kopwi kenon ki‑es su iy ihpa ndre kurtih. Handrai pe handrai yi ti indranon pwi.” ");
INSERT INTO ktm_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesus pe su disaipel ha‑au odo lok ertih. Su ha‑au ho‑us Galili ea. Yesus mboren sa lau hehtuno sa Iy imin kehe tih, ");
INSERT INTO ktm_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","odosa Iy mapwi intatuhne su disaipel Tadan tih. Iy ipe ile ta su ihpah, “Sa we heduwe Nedun Ndramat ti we kile lumwe’ sa lau. Sa lau we hapwi Iy kimet. Pe rang tul kinum ti pe Iy we kitlang yi.” ");
INSERT INTO ktm_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Su hendretakuni lon nolwo‑on ti pwi, odoke su horu‑ur pe hendrehndremte Yesus pwi. ");
INSERT INTO ktm_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Su hehir Kaperneam pe hala lon um. Inum pe Yesus ihndremte ihpa, “Oduu edenehkike‑ei sa mahkele odo sal tih? ");
INSERT INTO ktm_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Odoke su kolo’ su ke ndruwot. Su hendrepahran pwi odosa, su hodo sal ti pe henehkike‑ei ile si we madan kiso pule‑e’ su tih. ");
INSERT INTO ktm_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesus imin pwoi oh pe iyuwen su, pe ipe ile ta su ihpah, “Iy si lau ndre ipe ki‑in munen eri kiduwe iy kise pahndra’ sa ndre sulo‑on, pe kiduwe iy kile ndramtan marai ta sa ndre posingat.” ");
INSERT INTO ktm_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Iy ikuni anah homou netlehyen pe iduwe iy idu munen. Inum pe Iy isokohan anah kuti pe ipe ile ta su disaipel ihpah, ");
INSERT INTO ktm_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Si lau ndre kidawonon Yu pe kipu huyen kile ta homou kom ihpa ndre homou kudu, eri impo huyen ile Todo. Pe si ndre kipu huyen kile Todo, eri impo huyen ile tan Iy si ndre ihtakalan Yu use tih.” ");
INSERT INTO ktm_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon ipe ile ta Yesus ihpa, “Tisa, odu etndroni orngon homou ina‑as sinel ile rangam, pe odu atpa iy kipu kahrii, odosa iy ti isemin ndrodan tidu ti pwi.” ");
INSERT INTO ktm_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesus ipe ihpa, “Oduu etsinip anan kolwii. Si ndramat ndre impo mirakulo ile rongo, eri we kindripo nolou mo‑on kile puli‑i pwi. ");
INSERT INTO ktm_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Odosa iy lau ndre kisempo mo‑on kile ta tidu pwi, eri iy ta tidu. ");
INSERT INTO ktm_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Uh homou lau kihlingi ou kile hepe kangkahan wo odosa ou ti tan Kristus, eri Yu kupwe ndre ndrokone kile taduu, iy lau erti we kikuni ndre mbrunen.” ");
INSERT INTO ktm_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yesus ipe lakopwi yi ihpah, “Iy si lau ndre kihnan pe homou nenkom kideketi odo bilip ile Todo, eri kimpahar. Kile huyen ti lehpe iy kindrahnan homou kom ti mapwi eri sa lau hehndrusi pat mandra‑an kile won pe hepiyen iy kile lon ndras. Odosa, pede‑en odo iy kihnan homou nenkom kideketi odo bilip ile Todo ti mandra‑an lakopwi. ");
INSERT INTO ktm_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Uh hakai lumwem kihnan ou opo to‑ir, eri emndrelei pe epiyen ke‑eu. Kile huyen ti ou lumwem ke hakai pe ala heven. Kihne ou lumwem ndre rukei pe sa hepiyen ou ala hel. Yih odo hel ti isemat pwi. ");
INSERT INTO ktm_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Pe uh ndrikem hakai ti kihnan ou opo to‑ir, eri ou emndrelei pe epiyen ke‑eu. Ou ndrikem ke hakai pe ala heven ti huyen. Kihne ou ndrikem rukei pe sa hepiyen ou ala hel. ");
INSERT INTO ktm_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Pe uh sih madam ti kirwi ou pe ou opo to‑ir, eri etluhtii pe epiyen ke‑eu. Kile huyen ti ou madam ke sih pe emin lon kapman to Lapan. Kihne ou madam ndre ruweh pe sa hepiyen ou ala hel. ");
INSERT INTO ktm_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Odo hel, eri ul ndre heneni sengi’ su ti hesenum pwi, pe yih ndre intune‑en su ti isemat pwi. ");
INSERT INTO ktm_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Sa hentawe sol illa mundren song pe yohou odo ofa ndre sulo‑on, kile pe ofa ti kile huyen odo madan Lapan. Yih ti ihpa ke eriy. Yih ti we kihir ta sa lau ndre sulo‑on. ");
INSERT INTO ktm_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Sol ti huyen, odoke uh kanyan ti kinum, eri ou we ahnan kanyan kihir yi ti kihpa kehe? Sol ti intawe kanyan song illa huyen, ile pe oduu yi ti edihir kihpa ndre sol huyen, pe etawe penuw kimin lenga’ oduu homou homou.” ");
INSERT INTO ktm_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesus itlang odo lok erti pe ile distrik odo Yudea. Inum pe Iy ihtor wo Yordan ile hodoh, pe sa lau sulo‑on hala hun Iy. Iy idetuhne su ile nolwo‑on Lapan ihpa ndre Iy impo munen tih. ");
INSERT INTO ktm_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Su Paraseo hala hu Yesus pe hapa hahnan Iy kipe handrai nolou odo lon lo kihrut. Su hapa ile Tadan ihpah, “Yesus, kehe apa eh. Lo ta tidu ti ipe we sa kamal ha‑as mbrulu’ sa ha‑au ndre pwi?” ");
INSERT INTO ktm_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesus ipe ihpah, “Moses ti iduwe Lo sa ile taduu?” ");
INSERT INTO ktm_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Su hapa ihpah, “Moses ti ipe huyen. Moses ipe uh homou kamal ipe ki‑es mbrulun ke‑eu, eri iy kamal erti we kidetorwe nolou odo somendrih osou, kinum pe kiduwe kile lumwen iy pedih ti pe ki‑es iy ke‑eu.” ");
INSERT INTO ktm_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Odoke Yesus ipe ile ta su ihpa, “Oduu ti lau odo tahrung nolou pwi, ile pe Moses idetorwe Lo erti pe iduwei ile ta oduu. Odoke iy erti Lo ta Lapan pwi. ");
INSERT INTO ktm_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Idu ndre lin eri nolou ti ihpa, ‘Lapan ihnan su hala pedih pe kamal.’ ");
INSERT INTO ktm_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Iy eti uu pe kamal ina‑au odo hun taman pe tinen pe inohtok ile ndrodan mbrulun, ");
INSERT INTO ktm_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","pe horu harla ke ndramat homou.’ Ile pe horu ti ndramat rumuu pwi. Horu ti ndramat ke homou. ");
INSERT INTO ktm_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ile pe homosa ndre Lapan indrehtungon inna hondroh, eri ndramat kisomondrihi kolwii.” ");
INSERT INTO ktm_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Inum ti pe Yesus pe su disaipel hala yi ndre um. Pe su disaipel hehndremte Iy ile yi ndre Lo odo osou inemendrih tih. ");
INSERT INTO ktm_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesus ipe ile ta su ihpah, “Iy lau ndre ki‑es mbrulun pe kesou pedih homou yi ti indrahnan to‑ir mandra‑an ile pule‑en mbrulun. ");
INSERT INTO ktm_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Pe iy pedih ndre ke‑eu ta mbrulun pe kesou kamal homou yi ti indrahnan to‑ir mandra‑an yi.” ");
INSERT INTO ktm_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Sa lau hokuni su kom mone hala hu Yesus. Su hapa Yesus kiduwe lumwen kile pule‑e’ su. Odoke su disaipel hehrurute idu pule‑e’ sa lau kutih. ");
INSERT INTO ktm_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesus iltuwei punou ta su disaipel kuti, pe Iy ihwak ana’ su pe ipe ihpah, “Su kom mone ti hasa hu Yu. Oduu adahnan su kolwii, odosa kapman ta Lapan ti ta su lau ndre hahpa ndre su kom kutih. ");
INSERT INTO ktm_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yu kupwe ndre ndrokene kile ta oduu, iy si lau ndre kindretakuni kapman ta Lapan kihpa ndre su kom mone hentakun ti pwi, eri we kindrimin lon pwi. Pwi ndre pwi tih.” ");
INSERT INTO ktm_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Inum pe Iy ikuni su kom mone ti hala kanahan. Iy iduwe lumwen ile pule‑e’ su homou homou pe isurkon su. ");
INSERT INTO ktm_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesus itlang pe illa iyeu, pe orngon homou ihtot ile pe pandrulku‑un ile poi idu purmadan, pe ihndremte Yesus ihpah, “Tisa huyen, yu we kupu homosa lakopwi pe we kule heven?” ");
INSERT INTO ktm_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesus ihndremte iy ihpah, “Ihpa kehe pe ou apa Yu huye? Homou ndramat huyen pwi, tapake Lapan kopwi ti huyen. ");
INSERT INTO ktm_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ou ti tunom Lo tih: ‘Nombrun etruhe ndramat kimet. Oduu tasou ti etmetir ndrodan mbrulu’ oduu koson. Oduu etpahna kolwii. Oduu etaheweh kot kolwii. Oduu etruwi sane ta ndramat homou ke porah kolwii. Oduu etso pahndran tamai pe tinei pe etahrung nolou ta su.’” ");
INSERT INTO ktm_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Orngon kuti ipe ile ta Yesus ihpah, “Tisa, idu ke ndre yu mapwi kom uu pe isito mahkele, eri yu undretumbru‑e handrai Lo kiti pwi.” ");
INSERT INTO ktm_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus indre‑et ile tadan pe ihwaso‑on iy. Iy ipe ile tan orngon kuti ihpah, “Handrai kopwi yi ou tadam mapwi. Ala pe ekuni tadam sane ndre sulo‑on pe sa lau hesihnen ta sa. Pe moni ou okuni odo sane tadam ti eduwe kile ta sa lau ndranuno, kile pe ou we tadam sane sulo‑on odo heven. Kinum pe ou asa owus Yu.” ");
INSERT INTO ktm_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Orngon ti ihrungi nolou ta Yesus kuti pe iy madan ihmo‑on. Iy ikarundrum iy lakopwi pe iyeu, odosa iy ti tadan sane sulo‑on sulo‑on. ");
INSERT INTO ktm_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesus indre‑et ile ta su disaipel Tadan pe ipe ihpa, “Sa lau ndre ta sa sane sulo‑on ti hehnengkarundrum, odosa su we hapa hala lon kapman ta Lapan odoke iy erti we kinna mangsan ewehen kile ta su pwi.” ");
INSERT INTO ktm_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Su disaipel hehretek ile nolou kutih. Odoke Yesus ipe yi ihpah, “Oduu nedu, mangsan ewehen pwi. Ou si ndre apa ala lon kapman ta Lapan ti we ndre ekeles kile keles. ");
INSERT INTO ktm_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamel we ki‑us lon ngaden sou ti mangsan ewehen ile tadan. Odoke ke iy lau ndre tadan sane sulo‑on pe ipe kile heven eri we mangsan puko‑on lakopwi.” ");
INSERT INTO ktm_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nolou Yesus ipe kuti ihnan su disaipel hehretek pe tawene ta su ihrut ile puko‑on lakopwi. Homou madan ile ta homou pe hapa ihpa, “Orkom! Homou lau kindranon kinna lok huyen pwi.” ");
INSERT INTO ktm_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus indre‑et ile ta su pe ipe ihpah, “Ndramat eri indranon pwi, odoke Lapan eri kenon kipu sane ndre sulo‑on.” ");
INSERT INTO ktm_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita ipe ile ta Yesus ihpah, “Odu ada‑au ta sa murwo’ odu, emwe’ odu, pe tadu sane ndre sulo‑on pe etndresa hun Ou, pe edenu‑us Ou.” ");
INSERT INTO ktm_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesus ipe ihpah, “Ndre ndrokene ndre ndrokene. Iy si ndre kiduwe ndruwen kile tan tinton pe timso‑on su, kiduwe ndruwen kile tan taman pe tinen, ke‑eu ta su nedun, pe ke‑eu odo lonen, odosa iy idawonon Yu pe ipu marai odo Gutnius ta Lapan, ");
INSERT INTO ktm_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","eri tadan sane ti we hehir kile sulo‑on sulo‑on. Iy mapwi ndre kimin lokpoi eri Lapan we kihngahang iy sane sulo‑on sulo‑on, we kihluwen sane ndre iy tadan munen tih. Lapan we kihlingi iy um sulo‑on, tinton sulo‑on, timso‑on sulo‑on, tinen sulo‑on, nedun sulo‑on pe poi sulo‑on. (Odoke sa ndramat we hampa ke iy pe henahnan mandro‑on killa mo‑on.) Pe ndre omur ti iy we kile lok huyen ndroda Lapan. ");
INSERT INTO ktm_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Sa lau sulo‑on ndre mahkele he‑en munen eri we hala omur, pe sa lau sulo‑on ndre hodo omur mahkele, eri we hala munen.” ");
INSERT INTO ktm_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesus pe su disaipel tadan kah hehir sal ndre illa Yerusalem, pe su kah henelila hala eriy. Yesus inelila iyin munen. Tawene ta su disaipel ti ihrut pe su hentawene hudut. Sa lau ndre ho‑us su ti honoh. Yesus ikuni su ndre sungoh‑pe‑rumuu ti hala mahun odo ta sa lau, pe petsih yi Iy inen homosa ka we kihir kile tadan odo Yerusalem. ");
INSERT INTO ktm_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Iy ipe ihpah, “Atahrung. Tidu kah titlalih Yerusalem. Odo Yerusalem, eri sa ka we heduwe Nedun Ndramat ilih lumwe’ su pris mandra‑ane pe su tisa odo Lo. Sa ka we helilyan Iy kidu kot, pe sa ka we heduwe nolou kile hondroh pe heruhe Iy kimet. Kinum pe sa ka we heduwe Iy kile ta sa lau odo lok hokor yi, ");
INSERT INTO ktm_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","pe sa lau hokor yi we hetulyan Iy, we hehngowen Iy, we hemburnguhi Iy, we heruhe Iy kile wisiu, pe we hapwi Iy kimet. Pe rang tul ndre kilnum oh pe Iy we kitlang yi.” ");
INSERT INTO ktm_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Inum pe horu nedun Sebedi, Jems horu Jon, harla hu Yesus pe harpa ile Tadan ihpah, “Tisa, oru arpa erehndremte Ou kile ka‑an handrai, pe oru waso‑o’ oru Ou eduwe taru.” ");
INSERT INTO ktm_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesus ihpa, “Oruu waso‑o’ oruu homosa?” ");
INSERT INTO ktm_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Horu harahpah, “Uh Ou ala King odo lokpoi, eri oru waso‑o’ oru Ou eduwe oru homou ndruhun kise lumwem mudon pe homou kise lumwem kamweu.” ");
INSERT INTO ktm_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesus ipe ile ta horu ihpah, “Oruu ti tuno’ oruu homosa oruu erenehndremte kiti pwi. Oruu ti aranon eri‑ing homosa ndre Yu ka we ku‑ing tih? Yu ti we kulnget pede‑en pe kumwet, pe oruu ti we aranon arahpa ndre Yu tih?” ");
INSERT INTO ktm_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Horu harahpa, “Oru aranon.” Yesus ipe ile ta horu, “Ndre ndrokene, oruu ti we artakun pede‑en kihpa ndre Yu. ");
INSERT INTO ktm_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Odoke hehndremte taruu ti Yu kundranon kundripa hangka‑an odo eriy pwi. Iy si we kimin lumwe mudon o kamweu ti sane ta Lapan. Lapan Iy ndre Iy indripa ipe si we kimin sia kehe pe si we kimin sia kehe.” ");
INSERT INTO ktm_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Su disaipel ndre sungoh ti hohtuno su ndremte tan Jems horu Jon ile ta Yesus, pe su hopo loroh ile ta horu. ");
INSERT INTO ktm_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesus iyuwen su ndre sulo‑on pe ipe ile ta su ihpah, “Oduu tuno’ oduu ihpa ndre sa lok ndre tuno’ sa Lapan pwi ti ta sa ndramat hene‑en poho’ sa, pe sa lau ndre sulo‑on hentahrung ke iy. Iy kipe sa hopo homosa, eri sa we hehrung ke iy. ");
INSERT INTO ktm_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Odoke oduu ti we etndrahpa erti pwi. Uh iy si ta oduu ipe kile mandra‑an, eri iy we kile lewen marai ta sa ndre sulo‑on. ");
INSERT INTO ktm_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Pe uh iy si ta oduu ipe ki‑in mune’ oduu, eri iy we kile hono‑on marai ke porah ta sa lau ndre sulo‑on. ");
INSERT INTO ktm_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Odosa, oduu etndre‑et kile tan Nedun Ndramat ti oh. Nedun Ndramat ti insa odo kile pe sa ndramat hopo maryan ti pwi. Iy ise ti we kipu marya’ sa ndramat, pe we kimet, kile pe we kisihnen yi ndre sa sulo‑on.” ");
INSERT INTO ktm_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesus pe su disaipel Tadan hehir taon odo Jeriko. Inum pe su hatlang odo Jeriko, pe sa lau sulo‑on ho‑us su. Su hasa ngerin taon ti pe orngon homou imin eriy. Orngon ti rangan Bartimeus. (Taman ti rangan Timeus.) Bartimeus ti madan pwi, ile pe iy immin ngerin sal pe iyuw moni pe sane ile ta sa lau ndre henehrik tih. ");
INSERT INTO ktm_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Iy ihrungi ihpa ndre Yesus odo Nasaret ke ipei, ile pe iy iyuw ile puko‑on ihpah, “Yesus, Ou Nedun Devit, akarndrundrumwi yu.” ");
INSERT INTO ktm_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Sa lau sulo‑on hehyek anan, hapa iy kimin kopwi. Odoke iy iyuw ile puko‑on lakopwi, “Nedun Devit, akarndrundrumwi yu!” ");
INSERT INTO ktm_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesus ihndro pe ipe ihpah, “Etyuwen iy kise.” Ile pe sa hoyuw ile tadan pe hapa ihpah, “Ndrinem keweh. Odo eleng. Iy iyyuw ou.” ");
INSERT INTO ktm_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Iy ipiyen siot elwe‑en tadan iyeu, iy indreh idu eleng pe ile hu Yesus. ");
INSERT INTO ktm_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesus ipe ihpah, “Ou ereh sa?” Orngon madan pwi ti ihpah, “Tisa, yu upwe modo kihir pe kundre‑et sane.” ");
INSERT INTO ktm_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesus ipe ile tadan ihpah, “Eri huyen, ou ka owou. Bilip tadam indrahnan ou ala huyem.” Idu ke ndre erti pe iy madan ile huyen pe indre‑et lok, pe iyus Yesus odo sal ile Yerusalem. ");
INSERT INTO ktm_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesus pe su disaipel Tadan kah handrila mukehe Yerusalem. Su kah hapa hehir hala Betpage pe Betani. Lok ndre rukur kuti horso puliy Oliv. Pe Yesus ihtakalan horu disaipel Tadan rumuu harla munen. ");
INSERT INTO ktm_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Iy ipe ile ta horu ihpah, “Arla lok ilso munen ilso kitih. Oruu we erihir kopwi ti we erndroni donki homou, sa heduwe osukei ise tadan iseu. Homou lau indrimin pule‑en pe illa mapwi. Oruu oruwyon iy pe erkuni kise. ");
INSERT INTO ktm_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Uh homou kihndremte oruu, eri oruu arpa kile tadan kihpah, ‘Lau Mandra‑an Tadan marai idu eriy.’ Kinum oh pe Iy we kiporitai kisetawei yi.” ");
INSERT INTO ktm_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Horu disaipel ti harla pe herndroni donki homou, mapwi inek tapa eriy. Sa heduwe esukei ise tadan ise madan pohngkiu. Horu hereneruprup ti pe ");
INSERT INTO ktm_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","sa lau se hodo erti hehndremte horu, “Oruu erempo sa ile tan donki kitih?” ");
INSERT INTO ktm_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Horu harpahran nolou ta Yesus ile ta su, ile pe su handripa hangka‑an pwi. ");
INSERT INTO ktm_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Horu hartakuni donki ti ile hu Yesus, pe hartalahtan siot elwe‑en ta horu ile pule‑en. Inum pe Yesus inek ile ndritan pe imin pwoi pule‑en donki. ");
INSERT INTO ktm_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Sa lau sulo‑on henswi siot elwe‑en ea ha‑au odo mundre’ sa pe hatlahtan hala sal. Sa se ti hemndrel ndrandran kei odo ngerin sal pe hatlahtan hala sal. ");
INSERT INTO ktm_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Lau sulo‑on hala munen pe lau sulo‑on hala omur, pe Yesus imin pule‑en donki imin ndrokoron. Sa ndre sulo‑on hoyyuw pe henesangar ihpah, “Hosana! Etsori rangan Lapan!” “Lapan kipu huyen kile Tadan, odosa Iy ikuni pohon Lapan!” ");
INSERT INTO ktm_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Lapan kipu huyen kile tan King ta tidu, iy ihir odo ndrayen papo’ tidu Devit!” “Hosana! Etsori rangan Lapan imin lok eleng!” ");
INSERT INTO ktm_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesus ihir Yerusalem pe ile lon omwen surok mandra‑an. Iy iturtur sane ndre sulo‑on, odoke lok ti ke ipe kile lukumwen, ile pe Iy iyeu ile yi ndre Betani. Su disaipel Tadan ndre sungoh-pe-rumuu ti ho‑us Iy. ");
INSERT INTO ktm_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Su hemtir hodo Betani, pe ndre meseren sei yi, eri su halla hala yi ndre Yerusalem. Su honu‑us sal ti pe Yesus imet song. ");
INSERT INTO ktm_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Iy indroni fik he‑ei, pe illa ile kendrun. Iy ipe kihne fik ti sengin, kile pe Iy kiyo‑on. Iy ihir kendrun fik ti, odoke fik ti sengin hendre‑en pule‑en pwi. Fik ti ndrowuyen mapwi, ndron kopwi iyin pule‑en. ");
INSERT INTO ktm_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ile pe Iy ipe ile tam fik ti ihpa, “Homou lau ka we kinyo‑on sengim pwi yi.” Su disaipel hehrungi Iy ipe nolou ile tan kei kutih. ");
INSERT INTO ktm_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesus pe su disaipel Tadan helihir yi ndre Yerusalem. Iy ile lon sariy odo omwen surok mandra‑an pe iyes sa lau hompo suhen hodo eriy. Iy iruhten tepol ta su lau ndre hompotili‑it moni, pe pai ta su lau ndre heduwe pal odo sihsih he‑en eriy tih. ");
INSERT INTO ktm_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Pe Iy isongodi sa odo takun sane odo suhen odo lon sariyen omwen surok mandra‑an. ");
INSERT INTO ktm_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Inum pe Iy ipahran ile ta su ihpah, “Nolou ndre Lapan ipe pe su profet hadatorwei ti ihpah, “‘Yu emwe ti sa we heyuwen kile omwen surok ta sa kantri ndre sulo‑on.’ Odoke oduu etndrahnan ile ihpa ndre ndruhun tudong ta sa raskel.” ");
INSERT INTO ktm_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Su pris mandra‑ane pe su tisa odo Lo hehrungi nolou ta Yesus ti pe lon ndrine’ su inei. Su hapa hehreh sal odo we hapwi Iy kimet, odoke su honoh Tadan. Su honoh Tadan, odosa sa lau ndre sulo‑on hehrungi suhwon ti pe hehretek ile eriy pe hemesi‑iy. ");
INSERT INTO ktm_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Lok ile ndre pehon ti pe Yesus pe su disaipel Tadan ha‑au yi odo lon siti odo Yerusalem, pe hala ndre Betani. ");
INSERT INTO ktm_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Maping sei yi ti su hala yi ndre Yerusalem. Su hala sal ti pe heltuwe fik ti ndre he‑ei indremi‑is. ");
INSERT INTO ktm_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita idehorungon pe ipe ile ta Yesus ihpah, “Tisa, endre‑et oh, kei ndre Ou orson poh idu pule‑en ti ndre he‑ei indremi‑is!” ");
INSERT INTO ktm_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesus isomwii ihpah, “Otpo bilip kile ta Lapan. ");
INSERT INTO ktm_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Uh homou lau ipe kipe kile ta sih puliy kityuh kile lon ndras, pe iy ipu bilip ihpa ndre puliy ti we kityuh, eri puliy ti we kityuh, odosa iy mundren pe tawene tadan hepe indrohrok pwi tih. ");
INSERT INTO ktm_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ile pe Yu kupwe kile ta oduu, sa ndre sa oduu edehndremte kidu lon surok, eri otpo bilip ihpa ndre oduu etndretakunii, kile pe we kihir kihpa ndre eriy. ");
INSERT INTO ktm_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Pe uh, oduu otto eleng pe etsurok, pe atawonon homou lau ipu handrai punou mo‑on ile pule‑e’ oduu, eri oduu ada‑amelyen, kile pe Tama’ oduu ilmin heven ti kolon ke‑eu odo to‑ir taduu.” ");
INSERT INTO ktm_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesus pe su disaipel hala yi ndre Yerusalem. Yesus inelila iyin lon sariyen omwen surok mandra‑an ti pe su pris mandra‑ane, su tisa odo lo, pe su lau nusuwo’ su odo lotu hala hun Iy. ");
INSERT INTO ktm_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Su hehndremte Iy ihpah, “Ou okuni puko‑on kiti odo kehe pe ompo sane kitih? Si iduwe puko‑on odo po sane kiti ile Tadam?” ");
INSERT INTO ktm_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesus ipe ile ta su ihpah, “Yu we kuhndremte oduu kile nolou handrai. Uh oduu atpahran, eri Yu we kupahran si iduwe puko‑on ile Todo tih. ");
INSERT INTO ktm_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Atpa kile Todo, si iduwe puko‑on ile tan Jon pe iy itou baptais tih? Lapan ndre pwi ndramat?” ");
INSERT INTO ktm_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Su hehkike‑ei idu lenga’ su pe su hahpah, “Uh tidu titpa ‘Lapan,’ eri Iy we kipe kihpah, ‘Pe ihpa kehe pe oduu mbore’ oduu otpo bilip kile ta Jon?’ ");
INSERT INTO ktm_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pe uh tidu titpa ‘ndramat,’ eri we kihpa kehe? Sa lau ndre sulo‑on ti hapa Jon ti iy profet.” Su honoh ta sa lau ");
INSERT INTO ktm_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ile pe su hapa ile ta Yesus ihpah, “Odu tuno’ odu pwi.” Yesus ipe ile ta su ihpah, “Oduu etndrepahran pwi, eri Yu ti kundrepahran Todo ti pwi yi. Yu we kundrepahran si iduwe puko‑on ile Todo ti pwi yi.” ");
INSERT INTO ktm_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesus mapwi imin ndre lon sariy odo omwen surok mandra‑an odo Yerusalem pe Iy ipehre sohou ile ke palan nolou ile ta su lau ihpah, “Orngon homou idohon lok hombrul ile wain. Iy ide sariyen, pe isu‑ei ngat sih odo lisi sengin wain, pe itmon omwen ndram ise lo langah tadan tih. Iy iduwe sa lau se mada’ su ise langah tadan, pe we hompo marai kile eriy, pe iy we kinesihnen su. Inum pe iy iyeu ilndrou ile lok hokor yi. ");
INSERT INTO ktm_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Iy ma insa mapwi ti pe sengin wain tadan ti ihmandran pe sa ka hokun. Iy waso‑on se mbrwen wain kuti, ile pe iy ihtakalan lewen marai tadan homou ile odo kiltakun. ");
INSERT INTO ktm_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Odoke sa lau mada’ sa isso eriy ti hondrotowe lewen marai tadan kuti, hapwi iy, pe ha‑as iy iyeu yi. ");
INSERT INTO ktm_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ile pe orngon ndre tadan wain kuti ihtakalan lewen marai tadan homou yi ile. Su hetpili palan ile kei, pe hahnan iy imah‑ah ile ke mo‑on. ");
INSERT INTO ktm_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Taman wain kuti ihtakalan ndramat homou yi ile, pe iy ndramat kuti su hapwi iy imet. Iy ihtakalan sa lau sulo‑on se yi hala, odoke su lau ndre mada’ su iso wain kuti hapwi su se pe heruhe se hamat. ");
INSERT INTO ktm_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ndramat ke homou kopwi mapwi imin ti orngon kuti waso‑on lakopwi. Iy erti lilin nedun kamal. Orngon kuti ipe ihpah, ‘Huyen, yu ka we kuhtakalan nedu kamal kile. Su lau ti tuno’ su iy. Uh nedu ti kihir hu su ti we su hondrupo mo‑on kile tadan pwi, odosa su tuno’ su ihpa ndre iy ti lilin nedu tih.’ ");
INSERT INTO ktm_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Odoke su lau ndre hompo marai ile wain kuti hapa ihpah, ‘Iy ndramat kuti we kikuni ndruhun taman. Tidu titruhe iy kimet, kile pe langah kuti we ta tidu.’ ");
INSERT INTO ktm_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ile pe su hondrotowe iy pe hapwi iy imet, inum pe hepiyen iy ile ndruwen sariy odo langah. ");
INSERT INTO ktm_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Oduu atawene ihpa kehe? Taman langah odo wain kuti we kipu sa? Iy we kise pe kiruhe su lau kurti hamat pe kiduwe langah kuti kile ta sa lau se yi. ");
INSERT INTO ktm_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Oduu ti tuno’ oduu nolou iyin Buk ta Lapan ti ndre pwi? Nolou ndre ipe ihpah, “‘Pat kuti sa lau odo tumwe um ti hapa mo‑on pe heduwei ile mahun, eri kah inna ndruwen ndrokornu‑um. ");
INSERT INTO ktm_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Lapan Iy ndre Iy ihnan pe tidu titpwo-es kile eriy.’ “Nolou kuti oduu tuno’ oduu ndre pwi?” ");
INSERT INTO ktm_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Sa lau mandra‑asa ta su Yuda heltuwe ihpa ndre Yesus ti impa palan nolou ile ta su. Ile pe su hehreh sal ile puko‑on lakopwi hapa hondrotowe Yesus, odoke su honoh ta sa lau. Ile pe su hendripo hangka‑an inna Tadan pwi, pe su ha‑au. ");
INSERT INTO ktm_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Su lau mandra‑ane odo Yuda hapa hahnan Yesus kipe handrai nolou kihrut, kile pe su helilyan Iy. Ile pe su hahtakalan su Paraseo ndroda su lewen Herot se hala. ");
INSERT INTO ktm_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Su hala pe hapa ile ta Yesus ihpa, “Tisa, Ou ti esentaheweh pwi. Nolou ndre sulo‑on Ou ampa ile ta sa lau ti hemel kopwi. Ou ti esenoh ta homou lau pwi yi. Homosa ndre Ou apa apa kile ta si lau, eri Ou esenoh pwi. Ou antatuhnon sa lau ile punou ta Lapan. Ile pe piyi takis ile tan king Sisar odo Rom ti huyen ndre mo‑on? Kehe apa eh? ");
INSERT INTO ktm_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tidu titpo takis ndre konan?” Yesus tunon tawene ta su, ile pe Iy ipe ile ta su ihpah, “Oduu atpa ataheweh Yu ti ile sa? Otpo hendrek moni kise pe Yu kundre‑et.” ");
INSERT INTO ktm_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Su heduwe moni hendrek ile Tadan. Pe Iy ihndremte su ihpah, “Palan si pe rangan si iyin eriy tih?” Su hahpah, “Palai ti palan Sisar pe rangai ti rangan Sisar.” ");
INSERT INTO ktm_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Eri pe Yesus ipe ile ta su ihpah, “Sane ta Sisar ti atawei kile ndre ta Sisar, pe sane ta Lapan ti atawei kile ndre ta Lapan.” Su hehrungi nolou Iy ipe ti pe hehretek pe hemesi‑iy. ");
INSERT INTO ktm_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Inum pe su Sadyusi hala hu Yesus. Su Sadyusi ti su lau ndre hapa uh, taha tihmat, eri we titndretalang pwi yi. Su hala hu Yesus pe hehndremte ihpah, ");
INSERT INTO ktm_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tisa, Moses idetorwe Lo handrai ta tidu ti ipe uh homou kamal kindripo nedun pwi pe kimet, eri tinton ti we kesuwon nau tadan tih. Kile pe pedih kuti kipu nedun, pe kom ti we nedun tinton ndre indrimat tih. ");
INSERT INTO ktm_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ile pe idu petsih, eri su madan tinton ndre ndrotulmuu hodo. Iy munen ti iyesou, odoke homou nedun pwi pe imet. ");
INSERT INTO ktm_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tinton homou yi ti ikuni pedih nau kutih, odoke iy yi ti homou nedun pwi pe imet. Tinton homou yi ti ikuni pedih nau kurtih, odoke ihpa ke horu rumuu ndre herndremat tih. ");
INSERT INTO ktm_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Su madan tintoi ndre ndrotulmuu ti hasuwon ndre pedih kuti ea, odoke su homou indripo homou nedun pwi pe hamat. Inum pe pedih kuti imet yi. ");
INSERT INTO ktm_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ile pe uh kidu mundrun ndre sa lau ndre sulo‑on ndre handrimat ti we hatlang yi, eri iy si lakopwi ta su ndre ndrotulmuu ti we mbrulun pedih ertih?” ");
INSERT INTO ktm_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesus ipe ile ta su ihpah, “Oduu ti tuno’ oduu nolou he‑en lon Buk ta Lapan ti pwi. Oduu ti tuno’ oduu puko‑on ta Lapan ti pwi yi, ile pe nolwo‑o’ oduu ti indremimel pwi. ");
INSERT INTO ktm_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kidu rang omur kihir pe sa ndramat mat ndre sulo‑on hatlang yi, eri we osou pwi. Sa ndramat ti we hahpa ndre su engel odo heven. ");
INSERT INTO ktm_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Oduu yi ti atpa sa ndramat handrimat ti we handretalang pwi yi. Oduu ti edendroni nolou iyin buk ta Moses ti ndre pwi? Idu kalmene‑en kei innul pe Lapan isohou ile ta Moses ti oduu tuno’ oduu ndre pwi? Idu mundrun erti eri Lapan ipe ile ta Moses ihpa, ‘Yu ti Lapan tan Abraham, Lapan tan Aisak, pe Lapan ta Yakop.’ ");
INSERT INTO ktm_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Etndre‑et oh, Iy ti Lapan ta sa ndramat handrimat ti pwi. Iy ti Lapan ta sa ndramat more’ sa. Abraham, Aisak pe Yakop ti handrimat ndre pihe odoke mulwe’ su ti mapwi hodo, ile pe Lapan ipe ihpah, ‘Yu ti Lapan tan Abraham, Lapan tan Aisak pe Lapan ta Yakop.’ Ile pe nolou ta oduu Sadyusi ti indrohtot sal pwi. Tawene ta oduu ti indremimel pwi!” ");
INSERT INTO ktm_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Orngon homou idu pe intahrung nolou ndre Yesus impa ile ta su Sadyusi tih. Orngon kuti tadan sape mandra‑an odo Lo. Iy ihrungi nolou ta Yesus ti ndre ndrokene, ile pe iy ihndremte Yesus ihpah, “Lo kehe ndre iyin pule‑en Lo ndre sulo‑on tih?” ");
INSERT INTO ktm_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesus ipe ihpah, “Lo mandra‑an lakopwi ti kurtih: ‘Oduu Israel atahrung kehii. Lau Mandra‑an ti Iy homou kopwi, pe Iy Lapan ta tidu. ");
INSERT INTO ktm_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ahwasu‑um Lapan, pe eduwe ou ndre homou kile Tadan. Eduwe ndrinem, eduwe mulwim, eduwe palam, pe eduwe puko‑on tadam ndre sulo‑on kile ke ta Lapan.’ ");
INSERT INTO ktm_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Lo ndre ise pahndran ti kutih: ‘Ahwasu‑um ndramat homou yi ti kihpa ndre ou wasu‑um ke ndre ou.’ Handrai Lo yi indre‑en pule‑en Lo ndre rundrei kuti pwi.” ");
INSERT INTO ktm_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Orngon kuti ipe ile ta Yesus ihpa, “Tisa, Ou apa ti imel kopwi. Ndre ndrokene lakopwi ihpa ndre Ou apa tih. Lapan ti Iy ke homou, pe homou Lapan yi indrimin hepe pwi. ");
INSERT INTO ktm_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tidu tidehwaso‑o’ tidu Iy kile ndrine’ tidu, pe kile pala’ tidu, pe kile puko‑on ta tidu. Pe tidu tidehwaso‑o’ tidu su ndramat se yi, ihpa ndre tidu waso‑on ke ndre tidu tih. Lo ndre rundrei kuti here‑en pule‑en ofa handrai pe handrai ndre tidu tidempo tih.” ");
INSERT INTO ktm_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesus indroni ihpa ndre orngon ti isohou huyen kopwi, ile pe Iy ipe ile tadan ihpah, “Ou ti endrimin alau odo kapman ta Lapan pwi.” Sa honoh ta Yesus, pe homou indrehndremte Iy ile handrai sohou pwi yi. ");
INSERT INTO ktm_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesus imin lon sariy odo omwen surok mandra‑an odo Yerusalem, pe Iy intatuhne sa lau ile nolwo‑on Lapan. Pe Iy ipe ihpah, “Ihpa kehe pe sa lau tuno’ sa Lo ti hapa Kristus ti Devit we kiduwe Iy? ");
INSERT INTO ktm_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Lapan Mulwen iduwe tawene ile tan Devit pe Devit ipe ihpah, “‘Lapan ipe ile ta Lau Mandra‑an todo ihpah, “Asa emin poi emin lumwe mudon kenon ndre Yu kuduwe sa ndramat hompo mo‑on ile Tadam ti hasa pahndran lompurndrikem.” ’ ");
INSERT INTO ktm_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devit ti iyuw Kristus ile Lau Mandra‑an, pe ihpa kehe pe Kristus ti we Devit kiduwe Iy?” Sa lau sulo‑on hentahrung Yesus, pe su hepwo-es mandra‑an ile nolou Tadan. ");
INSERT INTO ktm_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Pe Yesus ipe ile ta su ihpah, “Oduu edempahar ta su tisa odo Lo. Su hentawe kolos elwe‑en ea pe waso‑o’ su hapa sa lau hompo sikan kile ta su odo ndruhun suhen. ");
INSERT INTO ktm_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Su hapa we hemmin ndre munen odo omwen surok. Su hapa we hemmin ndre munen odo lon ndrongon handrai pe handrai. ");
INSERT INTO ktm_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Su hantawiwihi sa pedih nau pe hempahno‑o sane ta su. Su hantaheweh hapa su ti lau odo lotu pe hantaleklek odo mada’ sa lau pe heneruwi surok illa elwe‑en. Su lau kiti we hokun pede‑en mandra‑an omur.” ");
INSERT INTO ktm_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesus imandro imin ndruhun piyi moni odo omwen surok mandra‑an, pe inendre‑et sa lau halla pe hempiyi moni odo hehnuwii omwen surok ertih. Sa lau ta sa moni sulo‑on ti hala pe hempiyi moni mandra‑ane ile lon ndruhun moni. ");
INSERT INTO ktm_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pe pedih homou mbrulun indrimat, pe tadan sane pwi eri ile, pe ipiyen peni rundrik rama‑an ile. ");
INSERT INTO ktm_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesus iyuwen su disaipel Tadan hala pe ipe ihpah, “Yu kupwe kile ta oduu. Pedih mo‑on kuti ihluwen sa ndre sulo‑on odo tudou moni. ");
INSERT INTO ktm_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sa se ti hotou mandra‑an yi, odoke ta sa moni sulo‑on mapwi ilto. Pedih mo‑on kuti kopwi ti indretawe hendrek indrimin pwi. Mone‑en ndre sulo‑on odo sihsih anan song ti iy indrepiyen inna ofa.” ");
INSERT INTO ktm_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesus iyeu odo lon omwen surok mandra‑an pe illa ise kiu. Iy ise ndre mahun ti pe disaipel Tadan homou madan ile ndre omwen surok pe imesi‑iy ihpah, “Ye orkom. Tisa, omwen surok ti mandra‑an le. Rahyen tadan ti ndre ilsou lakopwi. Sa hotmon um sim pe sim holto lon sariyen ti ile ke pat, pe we handranon hendretapar pwi.” ");
INSERT INTO ktm_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesus ipe ihpah, “Eneltuwe um mandra‑ane sim pe sim holto kitih? Sih pat we kindrimin ndruhun pwi. Sa we hatparan ndre sulo‑on odo ndrohu’ su pe we hesarpat hala poi.” ");
INSERT INTO ktm_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesus imin pwoi odo malal Oliv. Malal erti honto eriy ti pe henendre‑et ile hodoh ile pule‑en omwen surok odo Yerusalem. Pita kopwi, ndrodan ndre Jems pe Jon pe Andrew hala koson, pe hapa ile Tadan ihpah, ");
INSERT INTO ktm_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tisa, apahran kile ta odu. Sane Ou ampa kiti we hehir kalmene‑e sa? Pe sa mandra‑an we kihir ki‑in munen oh pe sane Ou ampa kiti we hehir?” ");
INSERT INTO ktm_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesus ipe ile ta su ihpah, “Edempahar pe mada’ oduu kise eleng, kihne sa lau hadawiwihi oduu. ");
INSERT INTO ktm_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Lau sulo‑on we hopo sane kile rongo pe hapa kihpah, ‘Yu ti Iy,’ pe we hoposahi sa lau sulo‑on. ");
INSERT INTO ktm_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Oduu we atahrung kaunan pahun odo lok mukehe pe pahun odo lok alau, odoke otnoh kolwii. Sane kiti Lapan ipe we hehir, odoke iy erti rang omur ti pwi. ");
INSERT INTO ktm_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kantri we hopo pahun. King homou we kipu pahun kile pule‑en king homou. Nunuw mandra‑ane we hehir odo lokpoi. Pe song we honum. Sane kiti hahpa ndre ngendre‑en ndre pedih ipe kitou nedun pe inehkalmanan. ");
INSERT INTO ktm_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Oduu lewi ti mada’ oduu kise eleng. Sa we hondrotowe oduu pe we helilyan oduu. Sa we hapwi oduu odo lon omwen surok. Oduu ti lau Todo, ile pe sa we herwi oduu atla mada’ sa king pe kapman, pe uh ndre etlato mada’ su eri etpehre gutnius Todo. ");
INSERT INTO ktm_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Gutnius Todo ti we ndre kinna ta sa lau ndre sulo‑on odo lokpoi oh, kinum pe rang omur we kihir. ");
INSERT INTO ktm_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pe uh sa hohrus kile ta oduu pe hokuni oduu kile madan kot, eri nombrun atawene hudut kile nolou sa oduu we atpa tih. Nolou sa ndre kihir pala’ oduu eri atpa kopwi, odosa sohou ndre oduu atpa ti suhwo’ oduu pwi. Lapan Mulwen we kiduwe tawene kile ta oduu pe oduu etsohou kile tan kot. ");
INSERT INTO ktm_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Sa ndramat se we helilyan ke ndre tinto’ su, pe we hahtakalan sa lau hapwi su hamat. Sa tamai ti we hopo kihpa erti kile ta su nedu’ su ti yi. Pe su kom ti we hehmbore su tama’ su, pe tine’ su, pe we hehtakalan sa lau hapwi su hamat. ");
INSERT INTO ktm_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Sa ndre sulo‑on we anan ke sa oduu odosa oduu ti Todo tih. Odoke iy si ta oduu ndre kipkwe uu kenon ndre rang omur, eri Lapan we kikuni iy.” ");
INSERT INTO ktm_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Oduu we edeltuwe hangka‑an mo‑on mo‑on we kihir, pe lok ndre ka‑an ti idu eriy, eri ndruhun ti pwi.” (Ou si ndre ompo ritim nolou kuti ohtunom kehii.) “Kidu ka‑an mo‑on kuti kihir, eri ou si ndre emin distrik odo Yuda ti oportai owou ala puliy. ");
INSERT INTO ktm_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ou si ndre enemiyau emin mbrungyen um, eri nombrun ala yi lon um pe altakun hangka‑an. ");
INSERT INTO ktm_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Si kamal ndre kimpo marai kimin langah ti kile yi um pe kiltakun hene pulngiyen kolwii. ");
INSERT INTO ktm_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kidu mundrun eriy, eri su pedih ndre ndriye’ su pe su pedih ndre nedu’ su mapwi hossus ti we hehnengkarundrum lakopwi. ");
INSERT INTO ktm_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Etsurok Lapan, kile pe sane kuti hehir kidu lon ahai pe lengin kolwii, ");
INSERT INTO ktm_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","odosa, idu ke ndre Lapan itou sane uu pe isito mahkele, eri handrai hangka‑an mo‑on mo‑on ihpa erti indrihir mapwi. Pe we omur ti we hangka‑an kindrehluwen pwi. ");
INSERT INTO ktm_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Odoke Lapan indremendrele rangen ka‑an mo‑on kuti inna murun. Kile Lapan kindretawe kihpa kuti pwi, eri ndramat ndre sulo‑on we hamat. Odoke Lapan kolon ile ta su lau ndre Iy ipe Tadan su, ile pe Iy indrahnan rangen ka‑an mo‑on kuti indrila murun. ");
INSERT INTO ktm_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“We kidu mundrun ka‑an mo‑on mo‑on kihir kudu, eri uh homou lau kipe kihpah, ‘Etndre‑et, Iy kuti Kristus!’ o, ‘Etndre‑et, Iy ilto!’ eri otpo bilip kile tadan kolwii. ");
INSERT INTO ktm_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Odosa, kristus taheweh pe profet taheweh, eri sulo‑on we hehir. Pe su we hopo mirakulo sulo‑on, hapa kile pe herwi su ndramat ndre Lapan ipe Tadan tih. Ipe ye su hanon, eri su we herwi su lau lewen Lapan. ");
INSERT INTO ktm_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ile pe oduu mada’ oduu kise eleng, ndrike’ oduu kidu pwoi pe edempahar. Yu undrepahran homosa ndre we hehir omur ti inna ta oduu indrinum.” ");
INSERT INTO ktm_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Suhwon Yesus ile ta su disaipel ti ile lakopwi yi ihpah, “Kidu ndruwen sane pede‑en kuti honum eri, “‘Mundroi we kilik, ndrou we kindrinai pwi, ");
INSERT INTO ktm_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","pudiy we hadaketi odo parar, pe nunuw mandra‑an we kihir lom parar, pe sane ndre sulo‑on odo lom parar we hodut.’ ");
INSERT INTO ktm_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Pe kidu iy ndre sane odo lom parar hohmo‑on, eri sa ndramat we heltuwe Nedun Ndramat kise pwoi odo lon kohut, ndrodan ndre puko‑on pe raman mandra‑an. ");
INSERT INTO ktm_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Iy we kihtakalan su engel Tadan we hala lokpoi ndre mandra‑an, pe hadaparngan sa ndramat ndre Lapan ipe Tadan su tih.” ");
INSERT INTO ktm_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Kei ndre fik ti oduu we etakun se tawene odo eriy. Uh kei kuti nombrun hehir, eri oduu tuno’ oduu ihpa ndre lok ka we kimndroi elwe‑en. ");
INSERT INTO ktm_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Sane kuti ihpa ke eriy. Uh oduu etndroni sane Yu umpehre kuti hehir, eri oduu tuno’ oduu ihpa ndre mundrun Nedun Ndramat ti mukehe kopwi kah kihir. ");
INSERT INTO ktm_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yu kupwe ndre ndrokene kile ta oduu! Sa ndramat odo mahkele ti we se mapwi hodo, pe sane ndre sulo‑on kuti we hehir. ");
INSERT INTO ktm_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Lok eleng pe lokpoi ti we hornum, odoke nolwu‑u ti we kindrinum pwi.” ");
INSERT INTO ktm_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Homou tunon mundrun sane kuti pwi. We kihir rang sa eri homou tunon pwi. Meseren ndre lukumwen eri homou tunon pwi. Su engel odo heven tuno’ su pwi. Nedun ti tunon pwi yi. Taman kopwi Iy ke homou tunon. ");
INSERT INTO ktm_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ile pe mada’ oduu kise eleng pe attatilen oduu kile huyen, odo oduu tuno’ oduu mundrun pwi tih. ");
INSERT INTO ktm_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ihpa ndre orngon homou iyeu ile lok alau pe ipe ile ta su lewen marai tadan mada’ su ise sane tadan. Pe iy itlangan marai handrai handrai hala ta su. Pe iy ipe ile tan iy lau ndre madan iso pohngkiu ti madan kiseu kehii. ");
INSERT INTO ktm_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Ile pe oduu mada’ oduu kiseu kehii, odosa taman um we kise maping, ndre pehon, ndre pwi lukumwen, eri oduu tuno’ oduu pwi. ");
INSERT INTO ktm_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kihne oduu edemetir pe edehretek tadan kihir. ");
INSERT INTO ktm_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nolou Yu umpa kurti ile ta oduu, pe ile ta sa ndramat ndre sulo‑on. Oduu etmin pe mada’ oduu kiseu.” ");
INSERT INTO ktm_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Idu ileruu odo range’ su Yuda hantahorunge ile yi ndre rang ndre Lapan ihnuwii su ha‑au odo Isip, pe rangen Bret Yis Indrila Lon Pwi, eri sa mandra‑ane odo lotu pe sa tisa odo Lo hapa hehreh hesel sal odo hondrotowe Yesus. Su hopunou hapa we hotong kopwi pe hondrotowe Yesus pe hapwi Iy kimet. ");
INSERT INTO ktm_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Odoke su hapa ihpah, “Tidu titpo kolwii oh. Iy keti ma mundrun rang mandra‑an pe sa lau sulo‑on ho‑us hendrek pe hendrek hansa Yerusalem. Kihne tidu titpo ti pe sa lau we hohmbrus Iy pe hopo handrai punou kile ta tidu.” ");
INSERT INTO ktm_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesus imin um ta Saimon odo Betani. Saimon pihe ti sik lepra idu tadan. Yesus imin pwoi imin ndruhun yo‑on song, pe pedih homou ihir. Pedih kuti isori puken wo pus sih. Ka‑an handrai ihpa ndre ndronun ndrilkiya mbrunen mandra‑an pe menuhun huyen idu lom puken wo kutih. Pedih ti itmbru‑e kowen wo pus kuti pe iruhten ka‑an menuhun huyen kuti ile mburmpalan Yesus. ");
INSERT INTO ktm_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Sa lau se ndre hodo ti lon ndrine’ su inei. Homou indre‑et ile ta homou pe hapa ihpah, “Pedih kuti ineruhten ka‑an kuti ile sa? Ka‑an ti huyen le. Iy ineruhten ile ke porah. ");
INSERT INTO ktm_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ipe ye iy kipe pe homou kisihnen, eri moni mandra‑an we kihir odo eriy. Moni ti we kihir tulpweu, pe lehpe heduwe kile ta sa lau ndre tasa sane pwi tih.” Pe sa lau kuti hehrurute idu pule‑en pedih kutih. ");
INSERT INTO ktm_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yesus ipe ile ta su ihpa, “Adahnan iy kolwii! Oduu edempa iy ile sa? Iy ti ipu huyen lakopwi ile Todo. ");
INSERT INTO ktm_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Sa ndramat tasa sane pwi ti we honto ndrongo oduu sei ihpa ke sei, pe oduu we edenehnuwii su. Odoke Yu ti we kundrumwin ndrodan oduu elwe‑en pwi. ");
INSERT INTO ktm_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Homosa ndre pedih kuti kenon kipu kile Todo eri iy indripo. Sa we hedoni Yu, ile pe ka‑an ndre iy iruhten ile puli‑i ti we kidu ndre mundre. ");
INSERT INTO ktm_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yu kupwe ndre ndrokene kile ta oduu, uh sa henen gutnius kile kehe ndre kehe odo lokpoi, eri sa we heninen homosa ndre iy ipu ile Todo kuti yi. Sa ndramat odo lokpoi we hentahorungon iy kise eriy.” ");
INSERT INTO ktm_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yudas Iskariot ti iy homou odo lo’ su lewen Yesus ndre sungoh-pe-rumuu. Iy ile hu su pris mandra‑ane, pe ipe ile ta su ipe we ki‑in munen su, pe su hondrotowe Yesus. ");
INSERT INTO ktm_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Su pris hepwo‑es ile nolou ta Yudas, pe hapa we hesihnen iy kile moni. Ile pe Yudas intametme‑et rang kehe ndre iy we kiduwe Yesus kile lumwe’ su tih. ");
INSERT INTO ktm_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Into Krismas sih pe sih, eri su Yuda hantahorungon rang odo Bret Ndre Yis Inna Lon Pwi tih. Pe into mundrun eriy, eri su hantahorungon rang ndre su hodo Isip pe heduwe ndrayen sipsip hala pohngkiu odo kile pe engel ta Lapan we kindrapwi nedu’ su kamal pwi tih. Ile pe mundrun Bret Ndre Yis Inna Lon Pwi ti kah indrihir, pe su ka we horoh sipsip odo tawonon rang ndre Lapan ihnuwii su odo Isip. Rang ti kah indrihir, ile pe su disaipel hehndremte Yesus ihpa, “Ou apa odu adahnan song mandra‑an ti kidu kehe? Ou ereh idu kehe lakopwi?” ");
INSERT INTO ktm_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ile pe Yesus ipe ile ta horu rumuu ihpah, “Oruu arla lon taon odo Yerusalam. Pe orngon homou inesursor kur sehir wo idu lon we kihrah taruu. Oruu oru‑us iy arla um kehe ndre iy kile eriy tih. ");
INSERT INTO ktm_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Pe arpa kile tan taman um ti kihpah, ‘Tisa ipe rum Tadan ti kehe? Iy ndroda su disaipel Tadan we hasa eriy pe hoyo‑on song mandra‑an odo kastam ta taha ti hodo eriy.’ ");
INSERT INTO ktm_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Pe iy we kipahran rum sih mandra‑an ise eleng odo um etih. Tepol pe sia holto lon rum ertih. Oruu arla pe arlahnan ana’ tidu song odo rum etih.” ");
INSERT INTO ktm_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Horu disaipel harla taon, pe sane ndre sulo‑on hehir ihpa ke ndre Yesus ipe tih. Pe horu harahnan song. ");
INSERT INTO ktm_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mundroi ndre inna pwoi pe lok irkweh, pe Yesus ndroda su disaipel ndre sungoh-pe-rumuu hala taon. Su hala rum mandra‑an ndre song iyin eriy tih. ");
INSERT INTO ktm_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Su hodo pwoi pe hoyo‑on song. Su ma ndre hana‑an song ti pe Yesus ipe ihpa, “Yu kupwe ndre ndrokene kile ta oduu, homou odo lenga’ oduu ti we kiduwe Yu kule lumwe’ sa lau ndre mbore’ sa Yu tih. Homou erti ina‑an song kemin ndroda Yu mahkele.” ");
INSERT INTO ktm_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Su disaipel hehrungi nolou kuti pe tawene ta su ihrut. Su homou homou ihndremte Yesus ihpah, “Kihne yu, erih?” ");
INSERT INTO ktm_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesus ipe ihpah, “Homou erti iy odo lon oduu ndre sungoh-pe-rumuu. Homou erti iy pe Yu erena‑an song into hondroh pe erenelila iso hondroh. Pe mahkele eri oru ertawe lumwe’ oru ile lom palet ke sih pe oryo‑on song. Mahkele ti oru orputon bret taru ile lom palet ke sih. ");
INSERT INTO ktm_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ndre ndrokene, Nolwo‑on Lapan iyin buk ti ipe we Nedun Ndramat ti kimet, odoke iy lau ndre iduwe Nedun Ndramat ile lumwe’ su lau mo‑osa ti ihnan hono‑on karundrum lakopwi. Kile huyen, eri lehpe tinen kindretawe iy pwi.” ");
INSERT INTO ktm_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Su hana‑an ndre song ti pe Yesus ikuni bret ise lumwen, Iy ide ureh ile ta Lapan, Iy iptan, pe itou ile ta su disaipel pe ipe ihpah, “Atakunii pe otyo‑on. Iy kurti sengi.” ");
INSERT INTO ktm_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Inum pe Yesus ikuni kap ndre wain idu lon tih. Iy ide ureh ile ta Lapan yi, Iy iduwe kap ti ile ta su pe su ndre sulo‑on he‑ing. ");
INSERT INTO ktm_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Pe Yesus ipe ile ta su ihpah, “Iy kurti ndrayi. Ndrai kurti ndrai odo poromis, pe we kimuw kile sihnen sa lau sulo‑on. ");
INSERT INTO ktm_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yu kupwe ndre ndrokene kile ta oduu, Yu we kundri‑ing yi hepe wain pwi, kenon ndre kapman ta Lapan kihir pe Yu ku‑ing wain morowin.” ");
INSERT INTO ktm_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Inum pe su hopo weriy handrai odo lotu oh pe ha‑au hala kiu, pe hanak hala puliy Oliv. ");
INSERT INTO ktm_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Pe Yesus ipe ile ta su ihpah, “Bilip ta oduu we ke‑eu odo Todo, pe oduu we ada‑au Todo, odosa nolwo‑on Lapan iyin buk ti ipe ihpa, “‘Yu we kuruhe ndramat ndre madan iso ta sipsip, pe sipsip we hasarpat.’ ");
INSERT INTO ktm_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Odoke Yu we kutlang yi, pe we kunemunen kule Galili.” ");
INSERT INTO ktm_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita ipe ile ta Yesus ihpa, “Su ndre sulo‑on ti bilip tasu we kideketi pe su we ha‑au Tadam. Yu kopwi ti pwi.” ");
INSERT INTO ktm_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesus ipe ile tadan ihpah, “Yu kupwe ndre ndrokene kile tadam, Pita. Mahkele lukumwen eri pawol we kindritang peruweh mapwi, pe ou we apa tunom Yu pwi kihndre patoloh.” ");
INSERT INTO ktm_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Odoke Pita ihkike‑ei puko‑on ihpah, “Konan, sa we hapa hapwi yu kumwet ndrodan Ou, odoke yu we kundranon kundripa upwe yu tuno Ou pwi ti pwi. Yu we kundripa pwi ndre ndrokene.” Su disaipel ndre sulo‑on hapa ihpa ke Pita ti yi. ");
INSERT INTO ktm_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesus pe su disaipel Tadan helihir lok sehir, rangan Getsemani. Iy ipe ile ta su disaipel ihpah, “Otto ketih. Yu kule kulsurok kule ilsou.” ");
INSERT INTO ktm_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Iy ikuni ke Pita, Jems pe Jon ho‑us Iy. Iy mundren ile pede‑en, pe lom mundren ndre homou ti ngendre‑en ile puko‑on lakopwi. Pe Iy inuh ile mo‑on. ");
INSERT INTO ktm_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Pe Iy ipe ile tam Pita, Jems pe Jon ihpah, “Yu uhnangkarundrum. Mo‑o kah le. Lon ndrine pe polo indrehndrepit, pe Yu uhkalmanan ihpa ndre upwe kumwet. Odu otto keti pe mada’ oduu kiseu.” ");
INSERT INTO ktm_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Iy ile ndre alau hepe ti pe ideketi ile poi, pe isurok ipe uh Lapan waso‑on, eri kiduwe ngendre‑en ndre Iy kawe kikun ti ke‑eu. ");
INSERT INTO ktm_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Iy isurok ihpah, “Aba, a Tomo, Ou owonon opo sane ndre sulo‑on. Ekuni kap kuti ke‑eu odo Todo. Odoke Ou owus reh Todo ti kolwii. Ou reh Tadam apa we kihpa kehe eri kihpa ke ndre eriy.” ");
INSERT INTO ktm_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Iy ile ndre ndrongo su disaipel ndre tulmuu pe iltuwe su hendremetir, ile pe Iy ipe ile tam Pita ihpah, “Saimon, ou enemetir ile sa? Ou andranon endrimin hepe eleng elwe‑en pwi, erih? ");
INSERT INTO ktm_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Oduu otto eleng pe etsurok, kihne tawene mo‑on hehir ta oduu pe oduu ataketi. Reh pe waso odo po sane huyen ti idu, odoke mundrei ti puko‑on odo po pwi.” ");
INSERT INTO ktm_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yesus ile ndre mahun petsih yi, pe ilsurok ihpa ndre surok Iy ipu ndre mamunen. ");
INSERT INTO ktm_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Inum pe Iy ise yi ndre ndrongo su disaipel ndre tulmuu kuti, odoke su mada’ su imeh ile mo‑on pe hendremetir yi. Su hehretek ti Yesus insa yi pe inolou ile ta su, odoke su tuno’ su nolou sa su we hapa kile Tadan ti pwi. Ile pe Iy ilsurok petsih yi. ");
INSERT INTO ktm_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yesus ise petsih ti su henemetir, ise peruweh ti su henemetir, pe ise yi kah patoloh ti su henemetir yi. Ile pe Iy ipe ile ta su ndre tulmuu ihpah, “Oduu mapwi edenemetir pe edemiyau, erih? Kah kahrii! Sa ka we heduwe Nedun Ndramat kile lumwe’ sa lau mo‑osa. ");
INSERT INTO ktm_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Atalang pe tidu tida‑au. Etndre‑et oh, iy lau ndre we kiduwe Yu kule lumwe’ sa lau mo‑osa ti insa mukehe!” ");
INSERT INTO ktm_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesus ma impa ise pohon ti pe Yudas ihir. Yudas ti iy homou ta sa lau ndre sungoh-pe-rumuu ta Yesus. Iy ihir ndroda sa lau sulo‑on. Sa lau kuti eri su mandra‑ane odo Lo pe lotu hahtakalan su ho‑us Yudas. Su hokuni semel pe kapwiy pe helpondrih Yesus. ");
INSERT INTO ktm_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudas indripa munen ile ta su ihpah, “Iy si lau ndre yu kuyahah kile won pe kuhngi purmadan, Iy eti Yesus. Oduu edehrus kile Tadan pe atakuni Iy.” Yudas indripa ile ta su ihpa kuti munen kah, ");
INSERT INTO ktm_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ile pe iy ile ndresale ile hu Yesus pe ipe ihpa, “Tisa todo,” pe ihngwi purmadan. ");
INSERT INTO ktm_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Eri pe sa lau hohrus ile ta Yesus pe hadakepti Iy. ");
INSERT INTO ktm_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pe su homou disaipel ti iporepti painat hondrou pe irson ile ta lewen marai homou ta su pris, pe isimndri ndralngan hakap iyeu. ");
INSERT INTO ktm_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesus isohou ile ta sa lau ihpah, “Oduu etakuni semel pe kapwiy, pe atpa etsaroh pe etndrotou Yu ti ile sa? Oduu atpa Yu ti homou raskel? ");
INSERT INTO ktm_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yu unesohou sei ihpa ke sei ile taduu odo lon sariy odo omwen surok mandra‑an odo Yerusalem, pe ihpa kehe pe oduu etndrendrotowe Yu odo eriy pwi? Odoke konan, odosa sane kuti we ndre hehir, kile pe nolou iyin Buk ta Lapan ti kihir ndre ndrokene.” ");
INSERT INTO ktm_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pe su disaipel ndre sulo‑on hohtot ha‑au. Yesus Iy ke homou indriso ndre lumwe’ sa lau mo‑osa. ");
INSERT INTO ktm_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Anah homou eleheu ti idu ndruwen Yesus pe ile, odoke sa hondrotowe iy. Anah ti idesan kolau peren. ");
INSERT INTO ktm_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Odoke sa hohrus ile tadan ti pe iy ipkwe, ile pe kolau ti iseket pe iso ndre lumwe’ sa. Iy kolowen ke pwi pe ihtot iyeu. ");
INSERT INTO ktm_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Su lau ndre hondrotowe Yesus ti hokuni Iy ile um ta hetpris. Su pris mandra‑ane ndre sulo‑on, su lau mandra‑ane odo lotu, pe su sape ndramat odo lo, su ndre sulo‑on ti hodo um ta hetprisa. ");
INSERT INTO ktm_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita ti iyus sa ile, odoke iy isella mukehe pwi, iyeu into ke ndre mahun. Iy ile lon sariy odo um ndre sa mandra‑ane hodo lon tih. Iy imin pwoi ndroda su polis pe ireng yih. ");
INSERT INTO ktm_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Su pris mandra‑ane pe su sape ndramat odo lo, ndroda su lau mandra‑ane odo lotu, hapa hehreh handrai hangka‑an ndre Yesus ipu ihrut, kile pe su hapwi Iy kimet, odoke su hehreh tahit. ");
INSERT INTO ktm_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Su witnes sulo‑on hala pe holsohou taheweh, odoke suhwo’ su inna ke handrai pwi. ");
INSERT INTO ktm_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Inum pe sa lau se hodo eleng pe hadaheweh ihpah, ");
INSERT INTO ktm_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Odu atahrungi Iy ipe ihpah, ‘Yu we kutparan omwen surok mandra‑an odo Yerusalem, pe Yu we kutmon yi kidu lon rang ndre tul. Omwen surok ndre Yu we kutparan ti sa ndramat hotmon ile lumwei, odoke iy ndre Yu we kutmon ti we lumwen ndramat kindretumon pwi!’” ");
INSERT INTO ktm_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Odoke nolou su hopo kuti inna ke handrai pwi yi. Homou ipe ile hesel pe homou ipe ile hesel. ");
INSERT INTO ktm_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Inum pe hetpris itlang idu eleng pe ihndremte Yesus ihpah, “Ou mborim sohou, erih? Ou nolou sa ile nolou ndre su hampa ile puli‑im kutih?” ");
INSERT INTO ktm_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Odoke Yesus indripa handrai nolou pwi. Ile pe hetpris ihndremte Iy ihpah, “Ou ti Nedun Lapan Mandra‑an Imin Eleng, tih? Ou ti Kristus tih, erih?” ");
INSERT INTO ktm_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesus ipe ihpah, “Ewuh, Yu ti Kristus. Pe oduu we etndroni Nedun Ndramat we kimin sia ise lumwei mudon ea ta Lapan, pe oduu we etndroni Iy kimin lon kohut pe kise pwoi.” a ");
INSERT INTO ktm_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Hetpris iy ndre iy ire‑ei kolson pe ipe ihpah, “Orkom! Tidu tidenehereh nolou sa yi? ");
INSERT INTO ktm_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Oduu etndretahrungi Iy mahkele kopwi impa nolou mo‑on ile pule‑en Lapan tih! Oduu atawene ihpa kehe?” Su ndre sulo‑on hapa Iy indretaparan Lo mandra‑an, ile pe we hapwi Iy kimet. ");
INSERT INTO ktm_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Su se ha‑amburngihi Iy. Su hehndrusi kolau ihndrepit idu madan. Inum pe su ho‑up Iy ile mbrutulumwe’ su pe hampa ile Tadan ihpah, “Iy si irson lumwen ile Tadam tih? Kehe apahran eh?” Pe su polis ta hetpris ti hala hekuni Iy iyeu, pe hentalahtan lompurlumwe’ su ile mundren. ");
INSERT INTO ktm_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita mapwi imin lon sariyen um ta hetpris, pe enihin homou lewen marai ihir. ");
INSERT INTO ktm_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Iy iltuwe Pita ireng yih, pe iy ihlilsi Pita, pe ipe ihpah, “Ou yi ti lewen orngon Naseret ndre Yesus tih!” ");
INSERT INTO ktm_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Odoke Pita ipe ihpah, “Yu tuno pwi. Yu tuno homosa ou ampa ti pwi.” Pita itlang pe ipe ke‑eu kile kiu, odoke iy ma idu ke ndre sal ti pe pawol ideng. ");
INSERT INTO ktm_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pita ma inu‑us sal ile kiu ti pe enihin kuti ile pe ipe ile ta sa lau hodo eriy ti ihpah, “Orngon kuti iy homou ta su.” ");
INSERT INTO ktm_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Odoke Pita ipe ihpah, “Enihin ti intaheweh, yu ti pwi.” Indralau ke pwi ti pe sa lau ndre hodo pohngkiu ti hapa ile tam Pita ihpah, “Ou adaheweh kolwii. Ou ti homou ta su, odosa ou yi ti odo Galili.” ");
INSERT INTO ktm_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Odoke Pita idamumoi ihpah, “Mondre eleng, yu tuno iy lau ndre oduu edempa kiti pwi!” ");
INSERT INTO ktm_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Idu ke ndre erti pe pawol ideng petsih yi, pe Pita idehorungon nolou ta Yesus. Pingi kopwi ti Yesus ipe ile tam Pita ihpah, “Pawol we kindritang peruweh mapwi, pe ou we andripa patoloh apa tunom Yu pwi.” Pita idehorungon nolou kuti pe iy ideng ile mo‑on. ");
INSERT INTO ktm_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Idu maping ndre lik ti pe su pris mandra‑ane, sa lau mandra‑ane odo lotu, pe su sape ndramat odo lo, ndrodan ndre su jas ndre sulo‑on ta su Yuda, heduwe tawene ile ke sih. Pe su hehndrusi lumwen Yesus ile osukei inum pe hokuni Iy ile um tam Pailat. ");
INSERT INTO ktm_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailat ihndremte Yesus ihpah, “Ou ti king ta su Yuda, erih?” Yesus ipe ihpah, “Ihpa ndre Ou andripa tih.” ");
INSERT INTO ktm_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Su pris mandra‑ane henehtuduwen Yesus ile nolou taheweh sulo‑on, ");
INSERT INTO ktm_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ile pe Pailat ihndremte Iy petsih yi, “Ou we esei Ou ndre pwi? Endre‑et oh, su heduwe nolou hudut inna puli‑im.” ");
INSERT INTO ktm_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Odoke Yesus kolon ke ndruwot. Pailat idawene hudut, pe imesi‑iy idu ke kolon. ");
INSERT INTO ktm_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Into lon krismas sih sih, eri Pailat ineruwyon ndramat homou odo kadapus. Iy si kadapus ndre sa lau hereh idu tadan, eri Pailat ineruwyon iy ina‑au, into mundrun ndre su Yuda hantawanon rang ndre Lapan ihnuwii su odo Isip tih. ");
INSERT INTO ktm_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Eri pe idu mundrun kudu, eri sa lau se hodo kadapus. Su lau erti heruruwon sane odo Yerusalam pe hapwi ndramat homou imet. Orngon homou rangan Barabas idu lon rurrou kuti yi, ile pe iy ti ke imin kadapus. ");
INSERT INTO ktm_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ile pe sa sulo‑on ka hala hun Pailat pe hehndremte, hapa iy kah kiruwyon homou kadapus ke‑eu. ");
INSERT INTO ktm_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Pailat ti tunon ihpa ndre Yesus ti indripo hangka‑an mo‑on pwi. Su pris mandra‑ane kopwi lon ndrinen su inei ke porah ile Tadan. Ile pe Pailat ihndremte su ihpah, “Oduu waso‑o’ oduu atpa yu kuruwyon king odo Yuda ke‑eu?” ");
INSERT INTO ktm_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Odoke su pris mandra‑ane hetsulke londrine’ sa lau, ile pe sa hoyuw ile tam Pailat ihpah, “Odu waso‑o’ odu ou eruwyon Barabas.” ");
INSERT INTO ktm_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pe Pailat ihndremte su, “Pe Iy lau ndre oduu atpa king ta su Yuda ti yu kupu sa kile Tadan?” ");
INSERT INTO ktm_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Su hasangar ihpah, “Opo nilim Iy kile kei tondrih!” ");
INSERT INTO ktm_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailat ipe ile ta su yi ihpah, “Odoke Iy ipu sa mo‑on?” Odoke su hedehel pe hasangar puko‑on lakopwi ihpah, “Opo nilim Iy kile kei tondrih! Opo nilim Iy kile kei tondrih! Opo nilim Iy kile kei tondrih!” ");
INSERT INTO ktm_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailat ipe kipasi sa lau, ile pe iy iruwyon Barabas ihpa ndre su hereh tih. Iy ipe, pe su soldia odo Rom hapwi Yesus ile wisiu. Inum pe iy iduwe Yesus ile lumwe’ su soldia, pe ihtakalan su hokuni Iy kile pe holpo nilim Iy kile kei tondrih. ");
INSERT INTO ktm_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Su soldia hokuni Yesus ile lon sariy odo um tam Pailat, pe heyuwen su soldia ndre sulo‑on hala. ");
INSERT INTO ktm_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Su heduwe kolos sih rama‑an ile mundren, inum pe su hepsen osukei pudon hopus pe heduwei ile palan. ");
INSERT INTO ktm_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Inum pe su hoyyuw illa Tadan ihpah, “Maping Tadam, king ta su Yuda!” ");
INSERT INTO ktm_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Su hokuni kei pe heneruson ile palan, pe hena‑amburnguh ile Tadan. Su hentawe pandrulku‑u’ su illa pwoi odo purmadan pe hompo ruru ile Tadan. ");
INSERT INTO ktm_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Su hetulyan Iy ihmo‑on oh, pe ndre ilnum ti su hedaso‑o kolos rama‑an ti iyeu odo mundren yi, pe heduwe yi ndre kolson ti ile mundren. Ndre ilnum pe su hokuni Iy odo lon sariyen um tam Pailat ile kiu, pe ka we holpo nilim Iy kile kei tondrih. ");
INSERT INTO ktm_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Su hahrah tan orngon homou rangan Saimon. Iy ti odo taon Sairini. Iy ipe kile Yerusalem odoke su soldia hehkikiyan iy pe iy isursor kei tondrih ta Yesus. (Saimon kuti ndre nedun Aleksenda horu Rufus tih.) ");
INSERT INTO ktm_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Su hokuni Yesus ile lok ndre sa heneyuwen ile Golgota. Mining tan Golgota ti ‘Ndruhun Palndramat’ ile nolou Aram. ");
INSERT INTO ktm_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Su hehir Golgota ti pe hotou wain ile ta Yesus hapa Iy ki‑ing. Wain kuti marsin idu lon, pe sa heni‑ing odo we kihnan mundrei ngendre‑en kinum. Odoke Yesus indri‑ing pwi. ");
INSERT INTO ktm_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Eri pe su soldia kah hopo nilim Iy ile kei tondrih, inum pe hedotinen idu eleng. Inum pe su hopo ndruwot laki ile kolos Tadan. ");
INSERT INTO ktm_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mundroi ti kah idu ihpa ndre 9 kilok maping, pe su soldia hopo nilim Yesus ile kei tondrih. ");
INSERT INTO ktm_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pe sa heduwe kei hendrek malahan idu padan kei tondrih. Kei malahan erti sa hopo nilim ise pule‑en Yesus. Pe sa hadatorwe rong sa ndre Iy ihnan ti iyin eriy. Sa hadatorwei ihpah, “King Ta Su Yuda.” ");
INSERT INTO ktm_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Sa hopo nilim horu lau rumuu mo‑o’ horu yi. Homou idu kei tondrih he‑ei idu mudon, pe homou idu kei tondrih he‑ei idu kamweu, pe Yesus idu ndrokoron. ");
INSERT INTO ktm_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ile pe nolwo‑on Lapan iyin buk ti ihir ndre ndrokene. Nolou erti ipe ihpah, “Pe sa hondrumon Iy yi ndroda sa lau mo‑osa!” ");
INSERT INTO ktm_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Sa lau ndre henehrik sal ti madan sa ile ta Yesus ingakik ise kei tondrih ti pe henehngunguu Iy pe hampa ihpah, “Apa yi puko‑om ti ka asa pwoi! Ou apa we etparan omwen surok mandra‑an odo Yerusalem oh pe otmon yi kidu ke rang tul, eri pe ka asa pwoi pe amat kolwii.” ");
INSERT INTO ktm_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Su pris pe su tisa odo Lo yi ti hampa ihpa ke eriy. Su ke ndre su henesohou into lenga’ su pe henehngowen Iy. Pe su hampa ihpa, “Iy inahnan sa lau se hala huyen, odoke Iy ndre Iy ti kindranon kindrehnuwii Iy pwi. ");
INSERT INTO ktm_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ipe ye Iy ti Kristus pe Iy king odo Israel ti eri kah kise pwoi odo kei tondrih, kile pe tidu titpo bilip kile Tadan.” Horu lau ndre sa hopo nilim horu ile ndrodan Iy ti heruson poh idu pule‑en yi. ");
INSERT INTO ktm_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Idu 12 kilok ti pe lik ihir lok ndre mandra‑an. Lik ti idu aua ihndre toloh. ");
INSERT INTO ktm_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Idu 3 kilok ti pe Yesus ideng puko‑on ile nolou Aram ihpah, “Eloi, Eloi, lama sabaktani?” Mining tadan ti ihpah, “Lapan Todo, Lapan Todo, Ou andra‑au Todo ti ile sa?” ");
INSERT INTO ktm_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sa lau se ndre hodo mukehe ti hehrungi Yesus iyuw pe hapa ihpah, “Atahrung oh, Iy ti iyyuw ile tan Elaijah.” ");
INSERT INTO ktm_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ile pe orngon homou iporitai itlaman palan kolau ile lon wain tudo‑on, inum pe ihndrusi ile palan kei sehir, pe itou ile pohon Yesus, ipe Yesus ki‑ing. Orngon eti ipe ihpa, “Otto oh. Kihne Elaijah kise pe kikuni Iy kile pwoi.” ");
INSERT INTO ktm_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Odoke Yesus idehel sehir kopwi, pe imet. ");
INSERT INTO ktm_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Idu ke ndre Yesus imet ti pe kolau mandra‑an ndre ingkakik pe issorohe rum nembruwen lakopwi odo lon omwen surok mandra‑an odo Yerusalam ti iseket ile ndre rumbrul, idu eleng uu pe ile ndre poi. ");
INSERT INTO ktm_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Pe kapten ta su soldia ndre hapwi Yesus ti indre‑et ile mat ta Yesus ti ipe ihpah, “Ndre ndrokene lakopwi, Iy lau kurti Nedun Lapan!” ");
INSERT INTO ktm_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Su pedih se hodo ke ndre mahun pe henendre‑et. Su se odo lo’ su pedih kuti eri Maria odo taon Makdala, pe Maria homou yi. Iy Maria kuti tinen Josep pe Jems lehyen tih. Salome ti idu lenga’ su pedih kuti yi. ");
INSERT INTO ktm_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Odo Galili, eri su pedih kuti henehnuwii Yesus. Sa pedih sulo‑on ndre ho‑us Iy hasa Yerusalem ti hodo pe henendre‑et yi. ");
INSERT INTO ktm_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Lok ti kah pehon odo rang Paraide. Kah mukehe kopwi pe Sabat kah kihir. (Sabat ti into Paraide mundroi ile pwoi uu pe ilento ndre Sarere pehon mundroi ile pwoi.) Idu pehon Paraide eriy, orngon homou rangan Yosep ile. Yosep ti iy odo taon Arimatea. Iy ti lau mandra‑an homou odo lo’ su lau ndre ndrotulngeh ndre hetpris ine‑en munen su pe su hempunuwon mandro‑o’ su Yuda tih. Iy ti lau huyen, pe ingkeli‑iy kapman ta Lapan. Ile pe iy indrinoh pwi. Iy ile hun Pailat pe ihndremte ipe kikuni Yesus pe kiltonii. ");
INSERT INTO ktm_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat ihrung ihpa ndre Yesus ti indrimat eri pe iy ihretek. Iy ipe kihne Yosep kintaheweh, ile pe iyuwen kapten ta su soldia ti pe ihndremte iy, pe kapten inen ndralngan. ");
INSERT INTO ktm_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pailat ihrung suhwon kapten inum pe iy ipe ile ta Yosep ihpah, “Huyen, Iy ke indrimat ndre ndrokene. Ou ka ala pe okuni Iy kise pwoi pe eltoni Iy.” ");
INSERT INTO ktm_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yosep isihnen kolau hapal mandra‑an. Inum pe iy ile pe ikuni Yesus ise pwoi pe ipulngi Iy ile kolau kutih. Ndre ilnum pe iy iltawe Iy ile ngat sih, sa hali ise padan pat. Inum pe Yosep ikotitye‑en pat hene malahan pe mandra‑an isorohe madan ngat. ");
INSERT INTO ktm_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria odo Makdala pe Maria ndre tinen Yosep ti horto pe herenendre‑et, ile pe horu ti tuno’ horu lok kehe ndre hedoni Yesus idu eriy tih. ");
INSERT INTO ktm_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat inum ti idu mundroi ile pwoi odo Sarere pehon. Eri pe Maria odo Makdala, Maria tinen Jems, pe Salome hala pe hesihnen ndronun sane ndre menehun huye’ sa tih. Su hapa we hokuni hala pe halara‑ai kile mundren Yesus. ");
INSERT INTO ktm_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ile pe idu Sande maping ndre lik eri su hala ngat. ");
INSERT INTO ktm_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Su ma ndre honu‑us sal ti hapa ihpah, “Kede si lau we kihnuwii tidu pe kinurwon pat ke‑eu odo pohngat tih?” ");
INSERT INTO ktm_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Odoke su hapa mada’ su kile ti pe pat mandra‑an ndre idu pohngat ti indra‑au, pe lon ngat idu kopwi. ");
INSERT INTO ktm_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Su hoportai hala pe ndresale hala lon ngat. Pe su hehretek tan orngon homou eleheu iduwe kolos peren pe imin pwoi imin lon ngat, ile lumwei mudon ea. ");
INSERT INTO ktm_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pe iy ipe ile ta su ihpah, “Oduu edehretek kolwii. Yu tuno, oduu ti edempondrih Yesus odo Nasaret ndre sa hopo nilim Iy ise kei tondrih pe Iy imet tih. Iy indrimin keti pwi! Iy indretalang yi! Etndre‑et oh, ndruhun ndre sa heduwe Iy iyin eriy ti kutih. ");
INSERT INTO ktm_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Oduu atla ndrongom Pita pe su disaipel se yi ti, pe etlaninen kile ta su. Atlapa kile ta su kihpah, “Iy we kinemunen kile Galili. Oduu we atla pe atlandre‑et Iy odo eriy, ihpa ndre Iy ipe pihe ile ta oduu tih.” ");
INSERT INTO ktm_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Su pedih ti honoh ile mo‑on. Su henehreretek pe hohtot ha‑au. Su hendreninen inna ta homou lau pwi odosa su honoh ile mo‑on. ");
INSERT INTO ktm_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesus itlang yi idu Sande maping ndrelik. Pe Iy ihir ile ndrongo Maria odo Makdala. Pihe ti Yesus iyes sinel ndre ndrotulmuu odo pule‑en tih. ");
INSERT INTO ktm_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maria odo Makdala ile pe ilninen ile ta su lewen Yesus. Su hantang pe henemutuu hodo, ");
INSERT INTO ktm_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","pe Maria odo Makdala ilninen ile ta su. Iy inen ipe Yesus ti inna ndre moren pe ihir ndrongon iy. Odoke su hondrupo bilip ile tadan pwi. ");
INSERT INTO ktm_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Idu ndruwen kurti pe horu disaipel rumuu herenelila odo sal, pe Yesus ihir ndrongo horu ile handrai yi. ");
INSERT INTO ktm_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pe horu harlaninen ile ta su disaipel se yi tih. Odoke su hondrupo bilip ile ta horu pwi. ");
INSERT INTO ktm_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Inum pe Yesus ke ilihir ile ndrongo su disaipel ndre sungoh-pe-homou. Su hana‑an song, idu Iy ihir ile hu su tih. Iy ihrurute ile ta su, odosa su tasu bilip pwi. Pe idu sa henen ile ta su, hapa Iy indretalang yi ti pe su hondrupo bilip pwi yi. ");
INSERT INTO ktm_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Pe Yesus ipe ile ta su ihpah, “Oduu atla lokpoi ndre mandra‑an pe etninen gutnius kile ta sa ndramat ndre sulo‑on. ");
INSERT INTO ktm_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ndramat ndre kipu bilip pe kipu baptais, eri Lapan we kikuni iy yi. Odoke iy ndramat ndre kindripo bilip pwi, eri we Lapan ki‑es iy. ");
INSERT INTO ktm_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Lapan we kiduwe puko‑on kile ta su ndre hopo bilip ti pe su we hepupu‑uh mirakulo. Su we ha‑as sinel kile rongo, pe su we hosohou nolou handrai yi. ");
INSERT INTO ktm_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Su we hondrutou mot. Su we he‑ing sane ndre ihnanan ndramat imat, odoke we handrimat pwi. Su we heduwe lumwe’ su kile pule‑e’ sa lau sik, pe sa we hala huye’ sa.” ");
INSERT INTO ktm_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Lapan Yesus isohou ile ta su oh, pe Lapan ikuni Iy ile heven. Pe Iy ile ndre ndruhun ise lumwen Lapan mudon. ");
INSERT INTO ktm_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Inum pe su disaipel hala lok ndre sulo‑on. Pe hepehre Nolwo‑on Lapan ile ta sa lau. Lapan immin ndroda su disaipel, pe inahnan mirakulo hehir, ile pe sa lau henehtuno sa ihpa ndre Nolwo‑on Lapan su hentudou ti ndre ndrokene lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","Yu Pol, aposel homou odo pehre Gutnius ta Yesus Kristus. Homou ndramat indrehtakalan yu pwi. Tawene tan ndramat indrahnan yu upu marai kuti pwi. Lapan Taman, Iy ndre isohrungi Yesus Kristus odo mat pe Yesus Kristus, Horu ndre Horu hertawe yu upu marai kutih. ");
INSERT INTO ktm_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","Yu pe su ndramat Kristen odo kede atawe pas kuti ile ta oduu sios sih sih oto lok hokor hokor odo Galesia. ");
INSERT INTO ktm_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","Lapan, Tama' tidu pe Yesus Kristus, Mandra-an ta tidu, hertawe huyen ta Horu pe penuw ta Horu kimin lenga' oduu. ");
INSERT INTO ktm_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","Kristus ihran Iy ile ta su Yuda pe su hapwi Iy imet. Kristus imet ti odo singi to-ir ta tidu ke-eu pe kirwe tidu tida-au odo lo sane mo-on odo mehkele. Iy ipu kuti ile pahndran reh ta Lapan. Iy mandra-an ta tidu pe Tama' tidu. ");
INSERT INTO ktm_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","Tidu titposan Lapan pe titsori rangan sei kihpa ke sei, kinehpa ke eriy. Ndre ndrokene. ");
INSERT INTO ktm_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","Lapan iyuwen oduu yi ile ndrongon Iy ile pahndran huyen Tadan iyus tang Kristus. Oduu etsentahorngon kuti pwi pe edena-au ile ye gutnius sih yi. Yu uhretek ile sa oduu edempo kiti odosa, mundrun inna elwe-en mapwi pe kolo' oduu ke inesumwen Lapan. ");
INSERT INTO ktm_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","Ndre ndrokene, sih gutnius yi pwi. Odoke yu upwe kuti odosa sa ndramat se hapa hanahnan tawene ta oduu kihndrolyut. Su hantatuhne hapa hopotulwen Gutnius ta Kristus pe hotou taheweh kile lon. ");
INSERT INTO ktm_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","Yu kupwe kile ta oduu. Kipe ye odu ndre pwi su homou engel odo heven kipehre sih gutnius ndre ile handrai yi odo iy ndre odu etpehre ile ta oduu eri, ea saleu, Lapan kiduwe iy kile hel ndreh! ");
INSERT INTO ktm_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","Odu etndrepa munen kah pe yu kupwe petsih yi. Iy si ndre kipehre gutnius ile handrai yi odo Gutnius ndre oduu etndretakunii, eri yu urih Lapan kiduwe iy kile hel. ");
INSERT INTO ktm_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","Yu usengkeles upwe kundrehposan ndramat pwi. Yu ti upwe kuhposan Lapan. Kipe ye yu kumposan ndramat ti lehpe kundrunum lewen marai tang Kristus. ");
INSERT INTO ktm_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","Oduu tinto, yu kupwe kile ta oduu. Gutnius ndre yu umpehre ti ndramat handrita lin pwi. ");
INSERT INTO ktm_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","Yu undretakuni odo ngo homou ndramat pwi. Homou ndramat yi indritatuhne yu inna eriy pwi. Yesus Kristus Iy ndre Iy ipaniniyan Gutnius kuti ile todo. ");
INSERT INTO ktm_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","14","Oduu tuno' oduu. Pihe ti yu undrotowe punou ndre su papo' odu Yuda hemin ile eriy ti ile puko-on. Ehe eleheu hesep ndre adentatuhne sane punou kuti yu une-en pule-e' su odo eriy. Yu umpo marai puko-on ile pahndran lotu ta su Yuda. Ile pe yu usengkarundrum sios ta Lapan pwi. Yu untawe ngendre-en ile ta sa Kristen pe untasarpada su. ");
INSERT INTO ktm_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","16","Odoke nino indretawe yu mapwi ti Lapan insusuwon yu munen odo po maryan. Iy kuti ile pahndran karundrum Tadan. Iy ispaniniyan Nedun ile todo, odo kile pe yu kupehre Gutnius tan Nedun kile ta sa ndramat Yuda pwi. Yu undretakun Gutnius kuti odo ndrongon homou ndramat pe upehre pwi. ");
INSERT INTO ktm_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","Yu undrila ndrongo su aposel ta Yesus munen hodo Yerusalem pe undrehndremte su inna sa yu kupaniniye ti pwi. Yu ule ke kantri Arabia pe ndruwen ti yu use ndre taon Damaskus yi. ");
INSERT INTO ktm_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","Krismas toloh ndre inum oh pe yu kah ule Yerusalem pe ulsohou tam Pita. Yu ulmin ndrongon iy rang ke sungoh-pe-lim. ");
INSERT INTO ktm_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","Yu undrendre-et homou aposel yi pwi tapake Jems ndre tinton Yesus. ");
INSERT INTO ktm_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","Yu undritaheweh pwi, Lapan tunon, sa yu umpa ile ta oduu ti ndre ndrokene. ");
INSERT INTO ktm_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","Ndruwen yu unum odo Yerusalem ti yu ule lok se odo Siria pe Silisia Provins. ");
INSERT INTO ktm_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","Kalmene-en erti ndramat lewen sios odo Judia ti tuno' sa yu pwi. ");
INSERT INTO ktm_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","Su honohrung ke nolou ihpah, “Orngon ndre inepwi tidu pe intawe tidu ile kou pihe ti ke impehre bilip ile tang Kristus. Bilip erti iy petsih ipe kidehepuson pe kitsarpadan.” ");
INSERT INTO ktm_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","Ile pe su ndramat Kristen odo Judia Provins hohrung Lapan ipotulwen yu, ile pe su hehposan Iy. ");
INSERT INTO ktm_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","Krismas sungoh-pe-hahuu inum ndre oh pe yu ule ndre Yerusalem yi ndrodan Banabas. Yu ukuni Taitus iyus oru yi. ");
INSERT INTO ktm_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","Yu ule Yerusalem odosa Lapan ipe ile todo ipe yu kule eriy. Yu upaniniyan Gutnius ndre yu umpehre ile ta sa ndramat Yuda pwi ti ile ta su lau mandra-ane odo sios into lo sohou ta odu. Yu wamolu kihne marai yu umpo munen pe iy ndre yu umpo omur ti kinna hangka-an ke pwi. ");
INSERT INTO ktm_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","5","Su ndramat se hapa kalatun martai ti hempini kina-au ile pahndran Lo ta su Yuda. Su ndramat kuti hadaheweh hapa ye su Kristen pe hopto su ise lo sohou tadu. Su hasa heselulu-ou odu. Odu ndramat ndre oto pahndran Yesus ti Lo tasu Yuda ti indrehndrusi odu pwi. Ile pe su lulo-ou kuti hapa heduwe odu atla pahndran Lo tasu Yuda, pe atakun pede-en odo eriy. Odoke odu hepe etndretaryan nolou ta su pwi, odo kile pe ndrokene tang Gutnius ti ki-in ndre ndruhun. Ile pe etndre-et oh, Taitus, ndramat ndre iyus yu ti iy Grik, odoke su mandra-ane kuti homou indrehkike-ei ipe hepini kalatun martan ke-eu ti pwi. ");
INSERT INTO ktm_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","Su ndramat se ti su lau mandra-ane odo lo sios. Odoke ile tawene todo, eri rangai mandra-an ihpe kehe ndre kehe ti hangka-an ke porah. Lapan ti isenehlit ndramat pwi. Ndramat rangan inehnding o pwi ti hala ke hondroh. Su mandra-an odo sios kuti hendripotili-it hangka-an inna ye Gutnius yu umpehre ti pwi. ");
INSERT INTO ktm_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","Pwi ndre pwi. Su heltuwe ihpa ndre Lapan indretawe marai odo pehre Gutnius ile tasu Yuda pwi ti ile todo, ihpa ndre Iy iduwe Pita kipehre Gutnius kile ta su Yuda. ");
INSERT INTO ktm_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","Odo tapa ile puko-on Tadan kuti Iy iduwe yu ule aposel odo kupu marai kile ta su Yuda pwi, ihpa ke Pita ile aposel odo kipu marai kile ta su Yuda tih. ");
INSERT INTO ktm_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","Jems, Pita, pe Jon, su hahpa ndre su kakah, heltuwe ihpa ndre Lapan indretawe marai kuti inna moryo. Ile pe su hopo sikan ile lumwe' oru Banabas. Iy kuti idekalmene-en odo odu otpo marai kile hondroh. Su hapa huyen odo we oru Banabas erpehre Gutnius kile ta su ndramat odo lok se yi, pe su hepehre kile ta su Yuda. ");
INSERT INTO ktm_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","Su hehndremte ke oru hapa oru artahorngon su ndramat ndre ta su sane pwi odo ndrongo su. Iy erti sa yu umpo marai puko-on ile eriy tih. ");
INSERT INTO ktm_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","Idu Pita ise pe imin Antiok ti yu upandrengsi iy idu mada' su ndramat Kristen odosa, sa ndre iy ipu ti mo-on. ");
INSERT INTO ktm_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","Iy immin Antiok ti iy ina-an song imin ndroda su ndramat matlok Kristen. Jems ihtakalan su ndramat se hala Antiok, eri pe Pita itmusuw iyeu ta su ndramat ndre iy ina-an song ndroda su ti pe inyo-on song ndroda su pwi yi. Pita inuh ta su lewen Jems, odosa su ti Yuda, pe hapa su matlok Kristen ti hepini kalatun marta' su ti ha-au. ");
INSERT INTO ktm_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","Su ndramat Yuda Kristen ndre hodo Antiok ti honoh ihpa ke Pita, ile pe ha-au ta su ndramat matlok Kristen kutih. Banabas ti idu ke ndruwe' su pe iyeu ihpa ke eriy. ");
INSERT INTO ktm_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","Idu iy ndre yu ultuwe Pita pe su Kristen ndre honto hondroh ti punou ta su indremimel ile ndrokene ta Gutnius pwi, eri pe yu uhrurute anam Pita idu mada' su, “Ou ti ou matlok pwi. Ou ti Yuda. Odoke ou ndre ou esenehtot Lo ndre sulo-on tam Moses ti pwi. Ile pe nombrun ehkikiyan su matlok Kristen hohtot kastam tatidu Yuda.” ");
INSERT INTO ktm_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","Yu unlou lakopwi ihpa, “Pita, ndre ndrokene toru ti toru Yuda. Pihe ti toru tarsa pahndran Lo tam Moses pe tarampa ihpah, ‘Su lau matlok ti huye' su odo madan Lapan pwi.’ ");
INSERT INTO ktm_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","Odoke mahkele, tidu tuno' tidu ihpa ndre tapa bilip ile ta Yesus Kristus we kiduwe ndramat kihir kile huyen odo madan Lapan. Lo ti isenahnan ndramat isela huyen odo madan Lapan ti pwi. Ile pe ndramat ndre kihtot homosa ndre Lo ipe ti we kinna huyen odo madan Lapan pwi. Tidu se ndramat Yuda ti titndrekakik ile ta Yesus Kristus, pe we titmin kile huyen odo madan Lapan ile pahndran bilip kurtih. Inna pahndran Lo ti pwi.” ");
INSERT INTO ktm_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","Uh tidu titpa titmin kile huyen odo madan Lapan pe titpo bilip ile ta Yesus, pe tideltuwei ihpa ndre tidu Yuda ti ndramat odo to-ir ihpa ke su ndramat matlok, iy erti kawe titpa kihpa kehe? Kristus ipe to-ir ti huyen ndreh? Pwi! Iy kuti indre-en hesel sal pwi ndre pwi. ");
INSERT INTO ktm_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","Pihe ti yu umwin pahndran Lo, odoke yu ka undra-au odo eriy. Ile pe uh yu kule yi ndre pahndran Lo, eri yu ti ndramat odo tumbru-et Lo lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","Yu ti undrunum odo pahndran Lo tih. Lo madan ke inso puli-i pwi, ihpa ndre Lo ti indrapwi yu undrumat. Iy kuti odo we kile pe mandro todo ndroda Lapan ti we kile huyen. Yu ti uhpa ndre undrumat ndroda Yesus use kei tondrih. ");
INSERT INTO ktm_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","Mandro ndre yu ko umwin eriy, eri ke ile huyen, ile pahndran bilip todo ile ta Nedun Lapan. Nedun Lapan ti eden yu pe imet ile nuhe. Ile pe mandro kehe ndre yu umwin ile eriy ti todo pwi. Yu umwin ile reh tang Kristus. ");
INSERT INTO ktm_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","Yu undrehwamulu huyen ta Lapan pwi. Uh, Lo tam Moses ti intawe taha tihla huyen odo madan Lapan, eri Kristus imet ti porah kopwi. ");
INSERT INTO ktm_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","Yesus Kristus imet idu kei tondrih ti oduu tuno' oduu. Oduu atahrungii eri ihpa ke lehpe oduu otndroni ile mada' oduu tih. Iy si ipusahi oduu? Oduu Galesia ti pala' oduu pwi. ");
INSERT INTO ktm_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","Oduu atakun Lapan Mulwen ti odo oduu odompo sane ihpa ndre Lo irih ti, erih? Pwi, oduu atakuni Lapan Mulwen ti iyus tahrung Gutnius pe bilip ile eriy. ");
INSERT INTO ktm_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","Oduu ti pala' oduu pwi ndre ihpa he? Mandro huyen ta oduu ti ihir odo puko-on ta Lapan Mulwen. Oduu ka we etndrumwii kile pahndran puko-on ta sengiy? ");
INSERT INTO ktm_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","Ngendre-en ndre sulo-on ndre oduu atakun ti hala hangka-an ke porah ndreh? Yu undrupo bilip pwi! ");
INSERT INTO ktm_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","Lapan ihlingi oduu Mulwen pe ipu mirakulo imin lenga' oduu. Iy erti odosa oduu otpo bilip ile Lo tih? Ndre pwi Lapan ipu kuti odo oduu atahrungi Gutnius pe otpo bilip ile eriy? ");
INSERT INTO ktm_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","Atawene kile sa ihir ile tan Abraham. Nolou ta Lapan ipe ihpah, “Abram iduwe tawene tadan pe iy ndrehomou ile ta Lapan. Ile ke bilip tan Abram erti pe Lapan iyuwen iy ‘lau kapin’ pe ihposan iy.” ");
INSERT INTO ktm_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","Etndre-et oh, ndramat ndre ta su bilip ti nedun Abraham ndre ndrokene. ");
INSERT INTO ktm_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","Su ndramat ndre Yuda pwi ti we Lapan kiduwe su hodo huyen, ile pahndran bilip ta su ile Tadan. Iy kuti nolou ta Lapan ipaniniyan munen. Ile pe Gutnius eri nolou ta Lapan ipahran ile tan Abraham munen ihpa, “Odo tadam pe Lapan we kipu blesim sa ndramat ndre sulo-on odo lokpoi.” ");
INSERT INTO ktm_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","Abraham ipu bilip pe Lapan ipu blesim iy. Iy we kipu blesim si ndramat ndre ipu bilip ihpa ndre Abraham ti yi. ");
INSERT INTO ktm_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","Sa ndramat kehe ndre henelila ile pahndran Lo ti kihne hapa ye su ti huye' su odo madan Lapan. Pwi. Su ti hemin pahndran tineh, odosa nolou ta Lapan ti ipaniniyan ihpah, “Iy si ndramat imin ile pahndran Lo, o kitmbru-e handrai Lo ti imin pahndran tineh.” ");
INSERT INTO ktm_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","Homou ndramat we kindrimin huyen ile madan Lapan ile pahndran Lo ti pwi. Odosa nolou ta Lapan ti ipe ihpa, “Mandro huyen ile madan Lapan ti inu-us bilip.” ");
INSERT INTO ktm_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","Lo ti indrahpa ndre bilip ti pwi. Lo ti ndre handrai, pe bilip ti ndre handrai. Nolou ta Lapan ti ipe ihpa, “Si ndramat ndre kihtot ndrandran Lo ndre sulo-on pe kindretumbru-e handrai pwi, eri we kimin huyen ile madan Lapan.” ");
INSERT INTO ktm_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","Kristus ise kei tondrih ti ile pahndran nolou ta Lapan ndre ipe ihpa, “Si ndramat ndre kimet kingkak kise kei ti imin pahndran tineh.” Kristus iduwe Iy ile pahndran tineh kuti pe irwi tidu tida-au odo pahndran tineh. ");
INSERT INTO ktm_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","Yesus imet ise kei tondrih ti isihnen taha tih-au odo pahndran tineh kutih. Yesus ipu kuti pe Lapan we kipu blesim su ndramat odo lok se yi ihpa ndre Iy ipu blesim Abraham, pe tidu we titakuni Lapan Mulwen ihpa ndre iy indripo poromis. Iy we kipu ndre rundrei kuti kile pahndran bilip ile ta Yesus. ");
INSERT INTO ktm_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","Oduu tinto, ile sane tidu tidempo, rumuu ndramat hertawe tawene kile hondroh pe horpo sain kile eriy, eri horu homou o homou yi ndramat we kindretaparan pwi, ndre pwi kitou hangka-an yi kile pule-en. ");
INSERT INTO ktm_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","Etndre-et oh, Lapan ti ipu poromis ile tan Abraham pe yayan homou. Nolou ta Lapan ti indripa yayan Abraham sulo-on pwi, homou kopwi, iy erti Kristus. ");
INSERT INTO ktm_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","Lapan ipu poromis ile tan Abraham ti munen. Krismas hangat-pe-tulngeh (430) ndre inum yi oh, pe kah Lapan iduwe Lo ile tam Moses. Ile pe Lo iy iduwe ile tam Moses ti we kindranon kindraho poromis tadan kuti pwi. Poromis kuti we kindrinum pwi. ");
INSERT INTO ktm_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","Odo uh, ipe ye hangngahang ta Lapan ti imang isso Lo, eri kawe kindrimang kinso poromis ti pwi. Odoke Lapan ihngahang Abraham ti iyus poromis. Indri-us Lo ti pwi. ");
INSERT INTO ktm_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","Eri pe Lo ti ka odo handrai sa? Hahngahang ta Lapan ti iyus poromis, ile pe Iy itou Lo ti odo sa yi? Iy iduwe Lo ti odo kipahran sane mo-on taha ndramat tihempo. Lo ti we ki-in uu kenon ndre Kristus, yayan Abraham ndre Lapan ipu poromis ile tadan ti kinsa. Engel odo tudou nolou ile pe ise, ikuni Lo kuti odo hu Lapan pe iduwe ile tam Moses. Moses ikunii pe iduwe ile ta sa ndramat odo Israel. ");
INSERT INTO ktm_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","Odoke ndramat odo tudou nolou ile pe ise ti indrimin lom poromis ta Lapan ile tan Abraham ti pwi. Lapan Iy ke ndre homou kopwi iduwe poromis kuti ile tan Abraham. Homou ndramat indrimin ndrokoron odo takun nolou ile pe ise ti pwi. ");
INSERT INTO ktm_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","Iy kuti ihpa kehe? Lo ti intahepiyen poromis ta Lapan? Pwi! Lo isentahepiyen poromis ti pwi. Ipe ye taha tihtakun handrai Lo ndre we kiduwe taha tihto huyen odo madan Lapan, eri taha ndre sulo-on tihehtot eriy kehii. Odoke we kindrahpa erti pwi. ");
INSERT INTO ktm_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","Nolou ta Lapan ti ipe lokpoi ndre sih ti puko-on tan to-ir insorohei, ile pe hangahang ta Lapan, Iy ipu poromisim ile pahndran bilip ile ta Yesus Kristus, eri ndramat ndre hopo bilip ile tang Krais ti we hokun. ");
INSERT INTO ktm_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","Bilip ile ta Yesus indrihir mapwi ti, eri taha ndre sulo-on ti Lo ihndrusi taha ihpa ndre tihto kou, iyenon ndre bilip kuti ihir ise rang. ");
INSERT INTO ktm_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","Ile pe Lo madan ise ta tidu iyenon ndre Kristus ihir. Iy kuti odo kile pe kiduwe taha tihla huyen odo madan Lapan, ile pahndran bilip ile tang Kristus. ");
INSERT INTO ktm_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","Mehkele bilip kuti mundrun indrihir. Lo kah madan inso ta taha pwi. ");
INSERT INTO ktm_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","Ile pahndran bilip eri oduu ndre sulo-on ti atla nedun Lapan ile hotok ta oduu ndroda Yesus Kristus. ");
INSERT INTO ktm_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","Oduu otndrohtok ile ndroda Yesus idu oduu otpo baptais tih. Mandro-on pe lila-an ti oduu etndretakunii. Oduu etndretakuni Iy ndre homou. ");
INSERT INTO ktm_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","Ile pe ndramat odo lok kehe o kehe, kamal o pedih, o ndramat handrai sa, eri hala ke hondroh. Su ndre sulo-on ti hala ke homou ile hotok ta su ndroda Yesus. ");
INSERT INTO ktm_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","Ou si ndramat ta Yesus eri ou ti yayan Abraham yi, pe we okun sa ndre Lapan indripo poromisim Abraham ile eriy tih. ");
INSERT INTO ktm_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","Nolou yu umpa ti ihpa ndre kutih: Orngon homou tadan sane sulo-on. Orngon kuti nedun kamal homou. Uh anah ti mapwi lehyen pe taman kimet, eri sane tan taman ti iy we kile taman. Odoke idu anah kuti ma lehyen, eri iy ti ihpa ke homou ndramat lewen marai mbrunen pwi. ");
INSERT INTO ktm_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","Iy mapwi lehyen ti sa ndramat se yi mada' sa ise tadan pe sane tadan, kenon ndre mundrun ndre taman indretawei ti kihir. ");
INSERT INTO ktm_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","Tidu ti ihpa ke eriy. Mulou mo-on odo poi heduwe tidu titndrela pahndra' su. ");
INSERT INTO ktm_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","Odoke Lapan ihtakalan Nedun ise idu mundrun ndre Iy indretawei. Pedih ndramat iduwe Iy pe Iy imndra imin pahndran Lo ta su Yuda. ");
INSERT INTO ktm_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","Iy ise ti odo ruprup taha odo pahndran Lo, kile pe Lapan kikuni taha tihla nedun. ");
INSERT INTO ktm_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","Lapan iduwe Mulwen Nedun ise lon ede' tidu eri ipaniniyan ihpa ndre tidu ti nedun. Mulwen Nedun kuti impa inehpa, “Tomo, yu tomo.” ");
INSERT INTO ktm_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","Ou ndramat homou homou ti anna nedun Lapan. Ou ka endrimin ihpa ndre lewen marai keporah ti pwi. Odosa ou anna nedun Lapan, pe Lapan we kihlingi ou sane ndre sulo-on tadan. ");
INSERT INTO ktm_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","Idu munen oduu tuno' oduu Lapan mapwi ti oduu ti lewen sane mulou mo-on. Sane mulou kuti Lapan pwi. ");
INSERT INTO ktm_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","Odoke mehkele ti oduu kah tuno' oduu Lapan pe iy tunon oduu. Su mulou kiti hepe puko-o' su pwi. Ile pe ihpa kehe pe oduu ka atawe ndruwe' oduu ile ta Lapan, pe atla ndre ndrongon mulou ke porah kuti? Oduu atpa atla ndre lewen marai ke porah ta su yi ti ile sa? ");
INSERT INTO ktm_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","Oduu adentawene mandra-an ile sane ndrongon odo rang sei sei, ndrou sih sih, mundrun hesep hesep pe krismas sih sih, odo atpa kile pe atla huye' oduu odo madan Lapan. ");
INSERT INTO ktm_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","Yu ukarndrundrumwi oduu. Sane oduu odompo ti kihne kihnan pe sane marai ndre yu undrupo ile henuwii oduu ti hendrihir hangka-an pwi. ");
INSERT INTO ktm_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","Oduu tinto, yu ti undrunum odo pahndran lo. Yu uhndremte oduu puko-on upwe oduu ada-au odo eriy pe adahpa ndre yu tih. Munen ti oduu etndrepo hangka-an mo-on inna todo pwi. ");
INSERT INTO ktm_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","Oduu tuno' oduu yu upehre Gutnius ile ta oduu ndre mamunen ti sik idu mundre. ");
INSERT INTO ktm_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","Sik todo ti iduwe mundrungot ile ta oduu tapai, odoke oduu etndrehmbore oduu yu pe etndresingte yu pwi. Yu ule ngo oduu ti oduu etpwo-es yu pe etkuni yu ule eseu ta oduu. Oduu otpo kuti ile todo ti ihpa ke lehpe oduu otpo kile ta su homou engel ta Lapan, o otpo kile ta Yesus Kristus. ");
INSERT INTO ktm_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","Oduu etpwo-es yu ile ke mo-on idu yu use ngo oduu. Lehpe ta oduu hangka-an ndre oduu ede' oduu ile eriy lakopwi ti etawe todo, kihpa ndre adapa mada' oduu pe etawe modo, kipe ye madai ti hanapai tih. Yu udamumoi lehpe oduu otpo kuti kile todo, odoke mehkele ti reh ta oduu erti inna he? ");
INSERT INTO ktm_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","Ke indrehpa kehe? Yu umpehre nolou ndrokene ile ta oduu ti ke indrahnan oduu pe oduu ka anan ndrine' oduu yu ndreh? ");
INSERT INTO ktm_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","Su ndramat ndre hapa oduu odohtot Lo tam Moses ti hereh mandra-an hapa tawene ta oduu ti kihpa ndre tawene ta su. Iy kuti inna handrai hangka-an huyen pwi. Su hapa kile pe tawene ta oduu ti kise ke henuwii su. ");
INSERT INTO ktm_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","Su hereh puko-on hapa hokuni oduu kile ngo su ti huyen, kipe ye sa su hapa hokun oduu kile eriy ti huyen. Odoke su hopo kuti kiseu kopwi, nombrun kinto ke ndre iy ndre yu umwin ndrongo' oduu. ");
INSERT INTO ktm_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","Oduu nedu, ngendre-en ndre su pedih hentudou kom pe hentakun ti yu untakun ihpa ke eriy odo ta oduu. Ngendre-en kuti we kinsou kenon ndre oduu etndrela nedun Lapan ihpa ndre Kristus. ");
INSERT INTO ktm_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","Yu reh todo upwe kidu kuti yu kumwin ndroda oduu, odoke yu kuse kihpa kehe? Yu upwe kumwin ndrongo oduu kile pe nolou sa yu unolou puko-on ile ta oduu iyin pas kuti yu kutmangsahan kehii kile ta oduu. Yu tuno homosa yu kupu odo henuwii oduu ti pwi odosa yu kolu insop. Yu ungkarundrum oduu lakopwi. ");
INSERT INTO ktm_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","Oduu kehe ndre atpa otpo sane kile pahndran Lo tam Moses eri atpa kile todo. Oduu tuno' oduu handrai sa Lo kuti ipe ti ndre pwi? ");
INSERT INTO ktm_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","Nolou ta Lapan ti ipe Abraham ti nedun kamal rumuu: Homou tam pedih mbrulun ndrokene, pedih ndre impo sane ile reh, pe homou tam pedih lewen marai ke porah. ");
INSERT INTO ktm_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","Ismael, nedun tam pedih lewen marai ke porah ti ihir odo ndrayen kamal pe pedih inehtok pe kom ihhir. Odoke Aisak, nedun tam pedih impo sane ile reh, ti ihir odo pahndran poromis ndre Lapan iduwe ile tan Abraham. ");
INSERT INTO ktm_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","Horu pedih kuti herehpa ndre poromis ndre runi ta Lapan. Hene Iy iduwe ile tan Abraham pe hene ile tam Moses odo puliy Sainai. Heka ti ihpa ndre poromis Lapan iduwe ile tam Moses odo puliy Sainai. Ile pe nedun su ti we honto ke pahndran Lo ndre Lapan iduwe ile tam Moses. Su we hala ke lewen marai mbrunen pwi. ");
INSERT INTO ktm_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","Heka ti ihpa ndre puliy Sainai ilso Arabia. Heka ti ihpa ndre siti odo Yerusalem mehkele, odo Yerusalem ndrodan ndre nedun su ti honto ke pahndran Lo. ");
INSERT INTO ktm_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","Odoke Yerusalem ilso eleng ti inso pahndran Lo ti pwi. Iy ti tine' tidu Kristen, odo tidu ti tidempo sane ile reh ta tidu. Tine' tidu ihpa ndre tine' tidu Sarah tih. ");
INSERT INTO ktm_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","Nolou ta Lapan ipe ihpa, “Pedih ndre osompo nedum pwi, pe esentakun ngendre-en odo tudou kom pwi ti engei, erkei pe epwo-es. Odosa pedih ndre mbrulun iyeu tadan ti we kipu nedun sulo-on, kidepelwem pedih ndre mbrulun imin ndruhun iy tih.” ");
INSERT INTO ktm_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","Ile pe oduu Kristen ti nedun Lapan ihpa ndre Aisak, ile pahndran poromis Lapan iduwe ile tan Abraham. ");
INSERT INTO ktm_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","Idu kalmene-en erti, kom ndre ihir odo ndrayen kamal pe pedih inohtok ti ineruhe kom ndre ihir puko-on ta Lapan Mulwen, pe intawe ngendre-en ile tadan. Mehkele ti ihpa ke eriy, ndramat ndre hodo pahndran bilip ile ta Lapan ti hentakun ngendre-en inu-us ta su ndramat ndre hodo pahndran Lo tih. ");
INSERT INTO ktm_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","Nolou ta Lapan ipe yi ihpa, “Awas pedih lewen marai ke porah horu nedun hara-au, odosa sane tan tama' horu kom kuti we iy kom nedun pedih lewen marai ke porah ti kindretakun pwi. Sane ndre sulo-on tan tama' horu ti we tan kom ndre tinen immin ile reh tih.” ");
INSERT INTO ktm_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","Ile pe oduu Kristen, tidu ti nedun pedih ndre lewen marai ke porah ti pwi. Tidu ti nedun pedih ndre impo sane ile reh tadan tih. ");
INSERT INTO ktm_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","Kristus indreruwyon tidu. Lo kah madan inso tatidu pwi. Ile pe ndrike' oduu kihes, nombrun adahran oduu kile lumwe' sa ndre we hahnan oduu kile ndramta marai ke porah. ");
INSERT INTO ktm_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","Atahrung kehii. Yu Pol umpa ile ta oduu. Kipe ye oduu adahran su ndramat kuti hepini keltun marta' oduu ha-au, pe etkakik kile Lo ta su Yuda, eri marai ndre Kristus ipu ti we hepe kindrehnuwii oduu pwi. ");
INSERT INTO ktm_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","Adampahar, yu kupwe petsih yi. Iy si ndramat ndre kihran pe hepini keltun martan ke-eu, eri nombrun kitmbru-e handrai Lo. Lo ndre sulo-on ti iy kihtot ndre eriy kenon. ");
INSERT INTO ktm_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","Oduu kehe ndre edengkeles atpa atla huye' oduu odo madan Lapan ile pahndran Lo, eri ndrokoro oduu pe Kristus ti indremendrih. Oduu ti etndre-au odo huyen ta Lapan. ");
INSERT INTO ktm_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","Tidu Kristen ndramat, ile puko-on ta Lapan Mulwen impo marai ile pahndran bilip ta tidu ile ta Yesus Kristus, eri tidu titreh titpa Lapan we kiduwe tidu titla huyen odo madan. Iy kuti sa tidu tidengkelyen tih. ");
INSERT INTO ktm_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","Tidu titndrehtok ndroda Yesus Kristus, ile pe kalatun martai kile pini ndre pwi, eri porah kopwi. Sa mandra-an lakopwi ti tapa bilip ile pahndran reh ta tidu ile ta sa ndramat se yi. ");
INSERT INTO ktm_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","Bilip ta oduu ile ta Yesus Kristus ti inehtot huyen. Iy si ihnan pe oduu otnum tahrung nolou ndrokene tih? ");
INSERT INTO ktm_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","Lapan ti pwi. Iy ti iyuwen oduu atla Kristen ndre mamunen kopwi. ");
INSERT INTO ktm_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","Yis ti hepe kopwi odoke inahnan palawa ndre sih intaptap. ");
INSERT INTO ktm_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","Yu tuno ihpa ndre Lapan we kihnuwii oduu, pe oduu we odohtot tawene todo tih. Yu tuno, oduu we otndrohtot ye sih tawene pwi yi. Iy si ndramat ndre inehyan tawene ta oduu, eri Lapan we kihndrusi iy. ");
INSERT INTO ktm_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","Kipe ye ihpa ndre su hapa, yu mapwi kumpehre kupwe sa kamal hepini keltun marta' su ha-au, eri ihpa kehe pe su Yuda ma hontudou ngendre-en ile todo tih? Oduu Kristen ndramat todo, etndre-et kile todo oh. Kipe ye ndre ndrokene, yu ma kuntatuhne ndramat kile eriy, eri nolou ndre yu umpehre upwe Yesus Kristus imet idu kei tondrih ti we kindrahyan tawene ta sa lau pwi. ");
INSERT INTO ktm_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","Yu wasu-u upwe su ndramat ndre henahnan tawene ta oduu ile mo-on ti hepini keltun marta' su ha-au pe hada mbruwe' su kile ndrodan yi. ");
INSERT INTO ktm_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","Oduu bilip ndramat todo, Lapan ke indretakuni oduu yi, ile pe oduu kah fri. Oduu ka oto ile reh ta oduu. Odoke nombrun etawe reh kuti kiduwe oduu otpo sane mo-on kile pahndran waso ta sengiy. Homou ahwasu-um homou, pe edehnuwii iy si ndre tadan marai. ");
INSERT INTO ktm_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","Odo Lo ndre sulo-on kehe ndre iyus ndrongon Moses ti hala ke handrai hemin komanmen sih. Komanmen erti kurti, “Ehwasu-um ndramat homou yi ihpa ndre ou wasu-um ou ndre ou tih.” ");
INSERT INTO ktm_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","Odoke kipe ye oduu adata-at oduu pe otyo-on oduu kihpa ndre puyep eri adampahar, kihne oduu ndre sulo-on edehrut ndresale. ");
INSERT INTO ktm_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","Homosa yu upwe kupwe ti kutih. Mandro pe lila ta oduu ti etawe Lapan Mulwen ki-in munen, kile pe oduu we etndrepo sane mo-on ndre sengi' oduu irreh ti pwi. ");
INSERT INTO ktm_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","Odo sane ndre sengi' tidu irreh ti Lapan Mulwen ti mboren pe sane ndre Lapan Mulwen waso-on eri sengi' tidu ti wamolon. Horu ndre rundrei ti handrai impo pahun ile pule-en handrai. Ile pe kipe ye Lapan Mulwen ki-in munen mandro pe lila ta oduu ti oduu etndranon etndrepo sa ndre sengi' oduu irreh ti pwi. ");
INSERT INTO ktm_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","Odoke kipe ye oduu etawe Lapan Mulwen ki-in mune' oduu, eri Lo ti tadan puko-on odo we kihndrusi oduu ti pwi. ");
INSERT INTO ktm_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","Punou mo-osa ndre sengiy waso-on ti he-en ke moleu: punou mo-on puso-on ihpa ndre punou ta mweh, pirihei mo-on pe ndramat kamal pe pedih hementir su ke porah kopwi, ");
INSERT INTO ktm_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","21","lotu isela ta Lapan ndrokene ti pwi, tapupu-uh sane ihpa ndre ngam, purku-um pe sane posing, ndramat hanta su ile nolou, henendringis sane ta ndramat homou yi pe hompo loroh, ndramat hapa hosor ranga' su, ndramat tuno' su sa ndramat se yi ti pwi, ndramat hemir hemir henesarpat pe hompo pahun ile pule-e' su, koloi inehrut ile sane ta sa ndramat, koloi inehrut ile ta sa ndramat se yi, hompo pahun pe horoh sa, heni-ing wo puko-on ea ineluhen palai, koloi inehrut ile ta sa ndramat ndre mandro-o sa huyen, pe sane punou mo-on se sulo-on yi. Yu kupwe kile ta oduu ihpa ndre yu undripa munen tih. Su kehe ndre hompo keri-it sane mo-on kuti we hanna pahndran kapman ta Lapan pwi. ");
INSERT INTO ktm_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","23","Odoke Lapan Mulwen inahngahang sane kutih: herreh tan ndramat, pwo-es, ndrinei ineweh, ndrinei isenai sowin pwi, hangahang sane, huyei illa tan ndramat homou yi, hohtot ile punou huyen rang sei sei, homou intamangsan homou ile huyen, pe ndramat henehndrepti su odo tawene mo-on. Sih Lo indranon we kihndrehndrusi si ndramat ndre impo sane punou huyen kuti pwi. ");
INSERT INTO ktm_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","Su ndramtan Yesus Kristus ti hendrepiyen punou mo-on odo sengi' su ti indra-au ndresale. Punou mo-on erti su hopo nilim ile kei tondrih pe indrimat. ");
INSERT INTO ktm_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","Lapan Mulwen iduwe laip ise tatidu, ile pe tidu tidahran Iy ki-in munen tidu odo lila-a tidu ndre sulo-on. ");
INSERT INTO ktm_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","Titmesi-iy ke ndre tidu kolwii, titakursi ndrinen ndramat se yi kolwii, titndringis sane o ndramat se yi kolwii. ");
INSERT INTO ktm_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","Oduu bilip ndramat todo, kipe ye oduu homou Kristen ndramat kipu hangka-an to-ir mo-on, eri oduu kehe ndre etmin huyen ile mulwei ti otsohou kehii kile tadan, pe atawe iy kimin kile huyen yi. Mada' oduu kise ta oduu kehii odo sane sa ndre oduu edempo, kihne oduu ataketi kile ndre sal mo-on yi. ");
INSERT INTO ktm_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","Homou ehnuwii homou kile pede-en tadan. Ile ke sal kuti oduu we edohtot Lo tang Kristus. ");
INSERT INTO ktm_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","Taha Kristen ndramat ti tihla ke hondroh. Ile pe si ndramat ipe ye iy ti iy mandra-an ihpa kehe ti intaheweh - iy intawiwihi ke ndre iy. ");
INSERT INTO ktm_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","Ndramat homou homou kindre-et pe kihkelmene punou sa iy impo ti huyen ndre mo-on. Uh sane iy impo ti huyen, eri iy kimesi-iy iy. Odoke nombrun kimesiyen ke ndre iy, pe kipe iy ti ihluwen sa ndramat ile po sane. ");
INSERT INTO ktm_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","Odosa ndramat homou homou ti we kisori ke ndre pede-en tam punou tadan. ");
INSERT INTO ktm_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","Iy si ndramat ndre intakun tatuhne ile nolwo-on Kristen bilip, eri kihnuwii ndramat ndre intatuhne iy ti kile sane ihpa ndre lehmweh pe song. ");
INSERT INTO ktm_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","Nombrun atawiwihi ke ndre oduu. Lapan ti homou isentawiwihi Iy pwi. Iy tunon sane ndre sulo-on. Hangka-an ou si ndramat odohon ti we ekuni ke ndre sengi hangka-an erti. ");
INSERT INTO ktm_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","Uh ou kolum kisso ke sane ndre sengiy irreh, eri we opondriti mat odo eriy. Odoke uh ou opo sane huyen kile pahndran henuwii ta Lapan Mulwen, eri Lapan Mulwen we kiduwe ou okuni kendrin marai tadam. Kendrin erti mandro huyen ndrokene ndre isenum pwi tih. ");
INSERT INTO ktm_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","Ile pe tidu titpo les odo pupu-uh punou huyen kelwii. Odo uh tidu titpo marai kiseu kopwi, eri we titakuni kendrin huyen kidu patmundrun. ");
INSERT INTO ktm_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","Ile pe mapwi tidu tidanon titpo huyen kile ta ndramat ndre sulo-on, eri titpo. Mandra-an lakopwi, eri titpo huyen kile ta su ndramat ndre hopo bilip ile ta Lapan. ");
INSERT INTO ktm_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","Nolou kuti yu ndre yu udatorou. Etndre-et tatorou todo mandra-an le oh. ");
INSERT INTO ktm_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","Su ndramat ndre hengkeles puko-on hapa keltu' marta' oduu ti hepini ha-au ti odosa, su honnoh ta su Yuda. Uh su henen hapa kei tondrih ta Yesus kopwi we kikuni ndramat kile hu Lapan, eri su Yuda we hetulyan su. ");
INSERT INTO ktm_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","Su ndramat ndre henehran keltu marta' su hempini ha-au ti hesempo sane ndre sulo-on ndre Lo ta su Yuda ipe su hopo ti pwi. Inum oh pe su hapa hepini kalatun ka-an ta oduu ha-au, odo hapa hesursor ke ranga' su kile mandra-an. ");
INSERT INTO ktm_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","Yu Pol, eri we kunsursor rongo kinna hangka-an odo sengiy ti pwi. Yu kusursor tapa rangan Yesus Kristus. Iy imet idu kei tondrih. Marai Kristus ihnan idu kei tondrih ti indrahnan sane odo lokpoi ti handrimat odo tawene todo. Pe yu ndre yu ti undrimat udu kei tondrih, ile pe yu kawe kundruto omur ta sane odo lokpoi pwi. ");
INSERT INTO ktm_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","Kalatu' martai ke-eu ti hangka-an ke porah. Kalatu' martai kiseu ti hangka-an ke porah yi. Homosa mandra-an lakopwi ti Lapan we kihnan taha tihir petsih yi. ");
INSERT INTO ktm_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","Ndramat ndre sulo-on kehe ndre honohtot ile sal yu undripa kudu, eri Lapan we kikarndrundrumwi su, pe we kiduwe ndrine' su keweh. Su ndramat kuti su Israel ndre ndrokene ta Lapan. ");
INSERT INTO ktm_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","Kundrumwi sohou todo kidu kutih. Nombrun homou ndramat kitou pede-en kile todo yi, odosa lekte' suwa he-en mundre ti hapaniniyan ihpa ndre yu ti lewen marai ta Yesus. ");
INSERT INTO ktm_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","Oduu tinto, karundrum ta Mandra-an tatidu, Yesus Kristus, imin ndrodan mulwe' oduu homou homou. Ndrokene. ");
INSERT INTO ktm_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","Yu Pol, aposel homou ta Yesus Kristus tih. Yu usini pohon pe umpo marai Tadan ihpa ndre Lapan ipe yu kupu. Lapan indrekuni tidu yi pe Yesus, tidu tidenkelyen. ");
INSERT INTO ktm_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","Timoti, yu nedu ou ndre ndrokene ile pahndran bilip tadam. Yu udetorwe pas kuti ise ndrongon ou pe usurok ou ile ta Lapan, Iy Tama' tidu, pe Yesus Iy Mandra-an ta tidu. Horu harla huye' Horu kile tadam, hartawe karundrum ta Horu kile tadam, pe hartawe penuw ta Horu kimin ndrodan ou. ");
INSERT INTO ktm_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","Yu urih upwe ou emin ke ndre Efesus ihpa ndre yu upwe ou emin eriy idu kalmene-en ndre yu upwe kule Masedonia. Sa ndramat se odo kirti hontudou taheweh tatuhne illa ta sa ndramat se yi. Tatuhne kuti indre-en bilip ta sios ti pwi. Ayahat ana' su ndramat hontudou taheweh tatuhne kuti pe su honum. ");
INSERT INTO ktm_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","Apa kile ta su pe su honum ninen tatili-iy pe pohtidi-iy ta su. Tatili-iy pe pohtidi-iy kiti hentawe ndramat hanta sa, pe handranon hendrehnuwii bilip ta sa ndramat ile ta Lapan pwi. Sane ndre Lapan waso-on ti tapa ihhir odo bilip ta ndramat. ");
INSERT INTO ktm_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","Pas todo kuti odo we kiduwe taha tihreh tataha. Tihreh tataha ki-us ede' tidu, tawene huyen pe bilip ndre ndrokene. ");
INSERT INTO ktm_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","Su ndramat se erti handra-amelyen sane kuti, ile pe honolou sane ke porah. ");
INSERT INTO ktm_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","Su hapa ye tuno' su Lo ta Lapan ti ile huyen, pe hapa hadatuhne sa lau kile eriy, odoke su tuno' su Lo kuti indrahii pwi. Su hontut odo nolou sa ndre su hampa tih. ");
INSERT INTO ktm_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","Taha Kristen tuno' taha, Lo kuti huyen kipe ye taha tihtawe Lo kuti ki-in ndre ndruhun. ");
INSERT INTO ktm_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","Tihentahorngon, Lo sa hanahnan ti ta sa ndramat huyene ti pwi. Lo sa hanahnan ti odo ta sa lau mo-osa. Sa lau mo-osa kuti ndre hontumbru-e lo pe hontulei sane mo-on, hontumbru-e Lo ta Lapan odo sengiy pe mulwei, honopwi tama' sa pe tine' sa hamat, honu-up ndramat hamat ke porah. ");
INSERT INTO ktm_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","Lo ti odo ta su ndramat ndre henemetir ndrodan kamal pe pedih ke porah, ndramat kamal imentir ndrodan ndramat kamal, pe ndramat hompo suhen illa ndramat ile lewen marai mbrune' su pwi. Lo ti tasu ndramat ndre hentaheweh pe hentamumoi ke porah, pe hompo sane ndre mo-o' su ndre indre-en lon tatuhne tang Kristen bilip pwi tih. ");
INSERT INTO ktm_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","Tatuhne erti iyin lon Gutnius. Gutnius erti nunuwen. Iy iyus hu Lapan. Lapan erti Iy kapin. Iy iduwe ise todo odo yu kupweniniyan. ");
INSERT INTO ktm_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","Yu ude urehen Yesus, Mandra-an ta tidu, odosa Iy ipuko-on yu pe iduwe tawene ile polo, odo yu kupu marai Tadan. Yu ude urehen odosa Iy tawene Tadan ipe yu uwonon pe iduwe yu upu marai Tadan. ");
INSERT INTO ktm_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","Munen yu una Kristen mapwi ti umpo nolou mo-on ile pule-en, unepwi su lewen pe untulyan su. Odoke Lapan ikarndrundrumwi yu, odosa yu tuno sa mo-on yu umpo ile Tadan ti pwi. ");
INSERT INTO ktm_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","Orkom! Reh ta Yesus, Mandra-an ta tidu, ile todo ti mandra-an lakopwi idepelwen to-ir todo. Bilip todo ile Tadan, pe reh todo ile ta sa Kristen ndramat, ti ihir odo reh mandra-an Tadan kuti. ");
INSERT INTO ktm_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","Yesus ise lokpoi ti odo takun yi ndre taha to-ir ndramat titla yi ndre ndrongo Lapan. Tihkuni nolou kuti pe tihpo bilip kile eriy, odosa iy nolou kuti ndre ndrokone. Yu ti mo-o lakopwi umwin lenga' sa to-ir ndramat kurti. ");
INSERT INTO ktm_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","Odoke Lapan ikarndrundrumwi yu, odo kile pe Yesus kililingan ihpa ndre Iy ti isemportai loroh pwi. Yu ti to-ir todo mo-on lakopwi, odoke Iy ikuni yu yi, kile pe sa ndramat heltuwe huyen ta Yesus ile todo kurti, pe hopo bilip kile Tadan. Pe uh su hamat, eri mulwe' su we hala hu Lapan. ");
INSERT INTO ktm_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","Iy ti King pe Lapan homou kopwi, Iy isemat pwi, Iy we kindrimin pe kindrimin, heseneltuwei pwi. Pwo-es kile Tadan pe rangan kile sursor, sei ihpa ke sei, kindre-en pe kindre-en, kindrinum pwi. Ndre ndrokene. ");
INSERT INTO ktm_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","Timoti, yu nedu ou ile rangan Lapan. Yu kupwe kurti kile tadam, ile pahndran nolou su profet pihe hendripa hapa we kihir kile tadam tih. Antahorungon nolou kuti pe opo marai kile pahndran, odo we kipuko-on marai tadam. ");
INSERT INTO ktm_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","Adakorwe bilip tadam. Pe tawene tadam huyen ti kimin kehii. Su ndramat se ti hendritahorngon su odo tawene huyen kuti pwi pe hendreruhten bilip ta su, ihpa ndre ndrole' yap iruh. ");
INSERT INTO ktm_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","Himeneus horu Aleksander ti horu rumuu odo ndroda su lau kutih. Ile pe yu uduwe horu herndrela lumwen Satan, kile pe hermusou pe hornum piket Lapan. ");
INSERT INTO ktm_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","Yu reh todo mandra-an ti upwe kinto lo surok kile ta Lapan ti sa Kristen henesurok odo henuwii sa ndramat ndre sulo-on, pe hanta urehen odo henuwii Tadan. ");
INSERT INTO ktm_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","Henesurok pe henehndremte Lapan kile henuwii kapman pe su ndramat hene-en poho marai pe hene-en munen ndramat, kile pe mandro ta taha kimin kile huyen, ndrine' taha keweh pe tihto huyen odo madan Lapan pe tityoman Iy. ");
INSERT INTO ktm_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","Lapan ti indretakuni taha yi. Surok ihpa kudu eri illa huyen ile ta Lapan, pe Iy impwo-es illa eriy. ");
INSERT INTO ktm_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","Iy waso-on taha ndramat ndre sulo-on tihehtuno taha nolou ndrokene Tadan, pe Iy kikuni taha kile ndrongon Iy yi. ");
INSERT INTO ktm_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","Lapan ti homou kopwi. Pe ndramat ndre imin ndrokoron pe intaparngan taha ndramat pe Lapan ti homou kopwi yi. Iy erti Yesus Kristus. ");
INSERT INTO ktm_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","Idu mundrun ndre Lapan ipaninyan eri Yesus Iy ndre Iy ihran Iy ile lumwe' sa ndramat pe ilnget ngendre-en, pe imet ile sihnen to-ir ta taha ndramat ndre sulo-on. Iy ipe kikuni taha tihla ndrodan Iy yi. ");
INSERT INTO ktm_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","Ile pe Lapan iduwe yu ule aposel odo kupweninye Gutnius kile ta su ndramat ndre su Yuda pwi, pe kudetuhne su kile Kristen bilip pe nolou ndre ndrokene. Nolou todo kuti ndrokene, yu undritaheweh pwi. ");
INSERT INTO ktm_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","Odo lon omwen surok ndre sulo-on, eri yu wasu-u su kamal heduwe su ndresale kile lumwe' Lapan, pe hosori lumwe' su hala eleng pe hosurok. Su nombrun hopo loroh ndre pwi hada su kile nolou. ");
INSERT INTO ktm_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","Yu urih upwe su pedih ti hedese ndrihi' su kehii koson pe honuwnou su kile lakopwi kolwii. Numbrun hopo tili-it ndrampala' su kile handrai pe handrai. Nombrun hehndrulu-ul ndre pwi hotou sane mbrune' su mandra-ane ihpa ndre gol he-en mundre' su. Konan, hopo sane kuti kelwii. ");
INSERT INTO ktm_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","Su pedih ndre hapa su Kristen, eri hopo marai kile huyen, pe heduwe sane marai erti hala nowiye' su. ");
INSERT INTO ktm_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","Su pedih nombrun hosohou. Hodo kopwi pe hohrung ke nolwo-o Lapan. ");
INSERT INTO ktm_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","Yu we kundretawe homou pedih kitou tatuhne kile nolwo-o Lapan pwi. Pedih ki-in munen tang kamal kolwii. Su pedih hosohou kolwii. ");
INSERT INTO ktm_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","Odosa Adam ti Lapan ihnan iy iyin munen odo tan Ewah. ");
INSERT INTO ktm_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","Adam ti Satan indritawiwihi iy pwi. Satan ti idewiwihi pedih pe pedih itmbru-e punou ta Lapan. ");
INSERT INTO ktm_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","Odoke Lapan we kikuni su yi kile pahndran su hotou nedu' su, hadakorwe bilip ta su kile puko-on, hahwaso-o' su sa ndramat, helngwen su odo punou mo-on, pe hedese ndrihi' su kehii odo mada' sa ndramat. ");
INSERT INTO ktm_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","Iy nolou kuti ndrokone: Iy si lau irih ipe ki-in pohon marai odo lotu eri huyen, odosa marai erti huyen lakopwi. ");
INSERT INTO ktm_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","Iy lau erti hangka-an kihrut kidu tadan kelwii, mbrulun homou koson, huyen kila ta sa lau, kinta mangsahan iy kila huyen pe kinnus ke iy, waso-on sa lau halla omwen pe iy tunon tatuhne sa lau ile nolou ta Lapan ile huyen. ");
INSERT INTO ktm_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","Iy ti ndramat odo ing pwi, lorohon pwi, ndrinen ewehen killa ta sa ndramat pe eden moni pwi. ");
INSERT INTO ktm_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","Madan kisso ta mbrulun pe nedun su kile huyen pe kimpunuwon nedun su kile huyen, kile pe su hohrung nolou tadan pe heneyoman iy. ");
INSERT INTO ktm_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","Iy madan kinso ta mbrulun pe nedun su pwi eri we kindroni sios ta Lapan kihpa kehe? ");
INSERT INTO ktm_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","Iy ndramat ndre ile Kristen tapa eriy ti ki-in pohon lotu kolwii, kihne kissap ke iy pe Lapan kililyan iy kihpa ndre Satan. ");
INSERT INTO ktm_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","Sa ndramat Kristen pwi eri henehwaso-o' sa punowon, kihne iy punowon mo-on ti pe su hahyan rangan kihmo-on, pe iy kise rikin ta Satan. ");
INSERT INTO ktm_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","Su ndramat odo henuwii maryan lotu ti hahpa ke su ndramat hene-en pohon marai odo lotu ti yi. Su ndramat huye' su, hesentaheweh pwi, heseni-ing wain sulo-on pwi pe ede' su kisela moni pwi. ");
INSERT INTO ktm_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","Su hadakorwe Kristen bilip kehe ndre indrihir insa moleu ti kile tawene huyen. ");
INSERT INTO ktm_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","Timothy, oduu edehkelmene marai pe punou tasu kehii oh. Etndre-et uu ndre hangka-an horut kindrihir kindrito ta su pwi, eri etawe su hopo marai. ");
INSERT INTO ktm_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","Mbrulu' su ndramat odo henuwii ti punou ta su kile ke huyen, pe hadaninen sane mo-on kelwii, tawene ta su killa ke huyen, pe hopo marai ndre sulo-on killa ke huyen. ");
INSERT INTO ktm_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","Ndramat lewen henuwii marai kuti mbrulun homou koson, pe kindroni mbrulun pe nedun su kehii. ");
INSERT INTO ktm_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","Iy ndramat lewen henuwii marai kehe ndre impo marai huyen, eri sa Kristen ndramat we hotlon iy, pe iy ndre iy ti we kindrerengreng odo ninen bilip tadan idu ta Yesus ti pwi. ");
INSERT INTO ktm_vpl VALUES ("T13_14","084_3_14","1TI","3","14","15","Yu urih upwe kuse pe kusendre-et ou sowin. Odoke yu untatorou pas kuti ise ndrongon ou, kile pe uh yu kunsa sowin pwi eri pas kuti we kipahran punou kehe ndre taha lewen Lapan, Lapan ndre isemat pwi, ti we tihmin kile eriy. Tidu ndramat erti sios ta Lapan. Sios erti ihpa ndre ndruwen ndrokornu-um, intakorwei pe impuko-on bilip ndrokone. ");
INSERT INTO ktm_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","Ndre ndrokene, taheweh pwi, lin nolou ndrokene iyin tunge ihir ile moleu odo mandro huyen odo madan Lapan ti kutih: Yesus ile ndramat pe ise lokpoi, Lapan Mulwen ipaninyan Iy ti Lau Kapin, su engel hendroni Iy, ninen Iy isini lok ndre sulo-on, pe ndramat sulo-on odo lokpoi hopo bilip ile Tadan. Lapan ikuni Iy inna ndre heven. ");
INSERT INTO ktm_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","Lapan Mulwen ipahran ile moleu ipe we kidu emur eri sa ndramat se we hepiyen bilip ta sa pe hehrung mulou mo-osa odo taheweh, pe ho-us tatuhne mo-on ta su. ");
INSERT INTO ktm_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","Taheweh tatuhne kuti sa taheweh ndramat hontudou. Su ndramat kuti tawene ta su ti mo-on, tuno' su sa huyen pe sa mo-on ti pwi. ");
INSERT INTO ktm_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","Su ndramat kuti hapa osou ti mo-on, pe ndramat hasou kelwii, pe sane song se ti mo-on odo yo-on. Odoke Lapan ihnan sane song ndre sulo-on ti odo yo-on. Tidu bilip ndramat ti tihta urehen Lapan odo song kurti kinum oh pe taha tihyo-on. ");
INSERT INTO ktm_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","Lapan ihnan sane ndre sulo-on ti huyen, taha we tihndrembore taha handrai pwi, odoke titsurok pe tita urehen Lapan ki-in munen, kinum pe tihyo-on ndre pwi tihkun. ");
INSERT INTO ktm_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","Odosa surok ta tidu pe nolwo-on Lapan ile pule-en sane kuti harndrahnan sane kuti hanna huyen ile reh ta Lapan. ");
INSERT INTO ktm_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","Ipe ye ou oduwe nolou kuti kile ta su bilip ndramat, eri ou we ala lewen marai huyen ta Yesus Kristus. Pe ou we okun puko-on odo nolou huyene ndre tidu tidempo bilip ile eriy. Pe ou we okun puko-on yi odo sape huyene ndre ou endrekunii pe onohtot ile eriy tih. ");
INSERT INTO ktm_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","Nombrun enen pohtidi-iy mo-on odo lokpoi. Opo marai puko-on odo takun punou huyen ta Lapan. ");
INSERT INTO ktm_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","Sane ndruwot pe marai odo hepuko-on mundre' taha hala puko-on ti huye' su, odoke marai odo takun punou huyen ta Lapan ti ndre huyen lakopwi, odosa iy erti we kihnan ou emin huyen kidu mahkele pe kilto omur yi. ");
INSERT INTO ktm_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","Tihkuni nolou kuti pe tihpo bilip kile eriy, iy nolou kuti ndrokone. ");
INSERT INTO ktm_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","Lapan isemat pwi pe Iy intakun taha ndre sulo-on, pe we kikuni taha ndramat lakopwi ndre tihempo bilip ile Tadan. Tidu titndretawe bilip tatidu puko-on inna ta Lapan pe tidenkeliyen Iy. Ile pe tidu tidempuke pe tidempo marai puko-on. ");
INSERT INTO ktm_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","Apaniniyan nolou kuti kile ta sa Kristen ndramat pe adatuhnon su kile eriy. ");
INSERT INTO ktm_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","Nombrun eduwe sa ndramat hendre-et kile tadam pe hapa ou ti ma kom pe tunom sane inna huyen pwi. Ompo ke ndre punou huyen koson, kile pe su Kristen hondronii pe hopo kihpa ndre ou. Elilngan punou huyen kinto lon suhwum pe lila-am. Elilngan punou huyen odo reh pe waso-oi ndramat. Pe elilngan punou huyen odo bilip ile tang Kristus, pe punuwom ti killa ke ndre nime-en. ");
INSERT INTO ktm_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","Yu kundrihir ndrongon ou mapwi ti ompo ritim buk ta Lapan kile ta sa lau, pe ampaniniye pe antatuhne su kile eriy. ");
INSERT INTO ktm_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","Pihe ti su profet hapaniniyan pe su Kristen ndramat mandra-ane hepiyen lumwe' su ile puli-im pe hapanunuwe ou. Iy kuti presen ta Lapan ihlingi ou ile eriy. Awamelyen kelwii. ");
INSERT INTO ktm_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","Oduwe ou ndre homou kile sane kuti pe opo marai kiseu kopwi kile eriy, kile pe sa ndramat hondroni hotot ta marai tadam. ");
INSERT INTO ktm_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","Elngwen mandro-om pe marai tatuhne tadam ti kehii. Ompo sane kuti kiseu kopwi kile pe Lapan we kikuni ou ndroda sa ndramat hentahrung ou ti atla ndrongon Iy. ");
INSERT INTO ktm_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","Uh homou il kipu handrai horut, eri nombrun ehrurute anan. Atmangsahan suhwom kile tadan kihpa ndre lehpe iy ti tamam. Osohou pe opo sane kile ta su eleheu ti kihpa ndre lehpe ou opo kile ta lilin tintom. ");
INSERT INTO ktm_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","Opo sane kile ta su pedih nusuwo' sa ti kihpa ndre ou ompo ile tan tinem. Endre-et pe opo sane kile ta sa kompihin ti kihpa ndre ou ompo ile ta lilin timsu-um, pe tawene tadam killa ta su ti killa ke ndre nime-en odo madan Lapan. ");
INSERT INTO ktm_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","Su pedih nau ndre nedu' su pwi, pe murwo' su odo hehnuwii su pwi, eri madam kise ta su kehii. ");
INSERT INTO ktm_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","Odoke iy si pedih nau ndre nedun ndre pwi tinton hodo, eri eduwe nedun su pe tinton su kuti, mada' su kise tadan kile pahndran marai lotu. Adatuhnon su kile kuti kile pe su mada' su kise tan tine' su, pe hopo muden marai tine' su ndre pwi toddo' su ipu odo hangngahang su tih. Iy punou kuti huyen ile madan Lapan. ");
INSERT INTO ktm_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","Iy pedih nau ndre homou madan inso tadan pwi, pe iy ke homou immin sehir, erti intawe tawene tadan illa ta Lapan pe inesurok illa Tadan meseren pe lukumwen sei inehpa ke sei, pe inehndremte Lapan ile henuwii iy. ");
INSERT INTO ktm_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","Odoke iy pedih nau ndre intawe mundren illa ke ta sa kamal pe impo sane ndre odo henuwii sengin, eri iy pedih erti sengin ti moren, odoke mulwen ti indrimat. ");
INSERT INTO ktm_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","Apa kuti kile ta su kile pe su hopo punou kuti kelwii, kile pe sa ndramat hapandrengsi su kelwii. ");
INSERT INTO ktm_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","Antahorungon. Si lau ndre karmadan kopwi illa tan taman, tinen, tinton pe timso-on ndrodan ndre su marlo-en, pe mboren kihnuwii su, eri iy ndramat Kristen erti indrekotidi odo bilip tadan. Sa ndramat Kristen pwi ti huye' su lakopwi yi odo tadan, odosa su ti mada' su iso ta su murwo' su tih. ");
INSERT INTO ktm_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","Nombrun okun homou pedih nau yi kile ndroda su ndre ou endretakuni su munen pe sios madan kise ta su, kenon ndre krismas tadan ti kindritapelwen puken onngoh, pe mbrulun ke kamal homou, pe isela ndroda sa kamal se yi pwi. ");
INSERT INTO ktm_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","Okun ke iy si pedih nau kindripo marai huyen, madan ise ta nedun su ile huyen, huyen illa ta sa ndramat lila hala emwen, inesingen ndrike' sa Kristen, madan iso ta sa ndramat honto mo-on, pe impo marai se huyene yi. Okun ke su pedih nau hahpa ndre ertih. ");
INSERT INTO ktm_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","Okun su pedih nau ndre mapwi kompihin ti kelwii, kihne reh ta su odo osou ti kihir pe su hasou yi pe ha-amelyen Yesus, ");
INSERT INTO ktm_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","pe hetmbru-ea poromis ndre su hopo munen ile Tadan. ");
INSERT INTO ktm_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","Su pedih nau erti henelila ke um sim ile sim, hentaninen ke sa ndramat, pe hemputo su ile lon nolwo-o' sa ndramat se yi. ");
INSERT INTO ktm_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","Yu urih su pedih nau kompihin ti hasou yi pe hopo nedu' su, pe mada' su kise tam mbrulu' su, nedu' su, pe omwe' su, kile pe sa ndramat Kristen pwi ti henen tidu Kristen kelwii. ");
INSERT INTO ktm_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","Odosa su pedih nau se ti ka hendripiyen punou ta Lapan pe hanna sal ta Satan. ");
INSERT INTO ktm_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","Iy si pedih Kristen ndre murwon se pedih nau, eri madan kise ta su pedih nau ertih, pe kiduwe pede-en kile ta sios kelwii. Kile pe sios ti madan kise ke ta su pedih nau ndre murwo' su pwi lakopwi tih. ");
INSERT INTO ktm_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","Su ndramat ndre hene-en mune marai odo lotu ti hokun mbrune' su. Su ndre hompo marai huyen ti hokun mbrune' su kile eleng. Iy kuti ile tasu lakopwi ndre hentatuhne sa ndramat ile nolwo-on Lapan. ");
INSERT INTO ktm_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","Odosa nolou iyin lon buk nombruwen ta Lapan ti ipe ihpa, “Nombrun ehndrusumwen pohon makau kidu iy intapurit pedun rais,” pe nolou handrai yi ti ihpa, “Lewen marai ti kikun mbrunen.” ");
INSERT INTO ktm_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","Uh homou lau kipe kihpa, “Ndramat ine-en mune maryan lotu ti ihnan hangka-an kutih,” eri ou ohrung kolwii. Kenon ndre rumuu ndre pwi tulmuu lau hehtuduwen iy, eri ou ka ohrung. ");
INSERT INTO ktm_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","Odoke su ndre hompo mo-on iseu kopwi, eri odo ngondru' su pe ahwak ana' su kidu madan lau, kile pe su se yi ti horu-ur pe hopo kelwii. ");
INSERT INTO ktm_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","Ile rangan Lapan, pe Yesus Kristus, pe su engel ta Lapan, eri yu kupwe kuti kile tadam: Madam kise marai ndre sulo-on ndre yu undripa hala tadam ti kehii, kile pe huyen tadam kile ta sa lau ti killa ke ndre sisihi. Opo huyen kile ke ta su il kolwii. Opo huyen kile ke ta su murwom yi kelwii. Punuwom kile ta sa lau ti killa ke ndre sisihi ea. ");
INSERT INTO ktm_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","Nombrun oporitai otou puko-on kile ta homou ndramat pe iy kipu maryan Lapan, kihne to-ir ta sa kisini ou yi. Emin kile ke ndre huyen odo madan Lapan. ");
INSERT INTO ktm_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","Munen ti ou eni-ing wo ke porah. Kah mahkele pe kile, eri eni-ing hepe-ew ea wain odo henuwii ndrinem, odosa ou enelenget mo-on odo ndrinem tih. ");
INSERT INTO ktm_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","To-ir ta sa lau se ti he-en ke rang. Sa lau erti hanna kot mapwi, odoke sa ndramat hendrehtuno sa ihpa ndre to-ir erti ndre ndrokene. To-ir ta sa lau se ti ma hala tungye, odoke we hehir hala rang kidu omur. ");
INSERT INTO ktm_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","Marai huyene ti hahpa ke eriy. Marai huyen ta sa lau, eri sa ndramat we heltuwe kile ke moleu. Pe marai kehe huyen ndre inna tungye, eri we kihir kise rang kidu omur. ");
INSERT INTO ktm_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","Yu urih upwe su Kristen ndramat ndre hompo marai mbrune' su pwi ti hopo huyen kile ta su bos tasu, kile pe homou kinlou mo-on kile ta Lapan pe bilip ta sios Tadan ti kelwii. ");
INSERT INTO ktm_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","Uh bos ta homou lewen marai ke porah ti iy Kristen, eri lewen marai ti nombrun kidawene kihpa, “Bos todo ti yu tinto, ile pe huyen, yu we kundretahrung iy pwi.” Pwi! Lewen marai ti tawene tadan kihtot kihpah, “Bos todo ti iy Kristen pe yu wasu-u iy. Yu kupu maryan kile huyen kile pe mandro tadan ti kimin huyen.” Tawene kuti we kihnan lewen marai ti we kipu marai kile huyen. Timoti, opunowon su kile kuti. ");
INSERT INTO ktm_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","Iy si ndramat ndre intatuhne sane bilip ndre indre-en sal odo tatuhne ndrokone ta Mandra-an tatidu Yesus Kristus pe bilip tang Kristen sios pwi, ");
INSERT INTO ktm_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","eri tunon sane pwi. Iy ti inesursor ke rangan. Iy ingkeles ke tanonolou, intamanman kopwi, inendringis ke sane, inehtuduwen sa se yi ile sane. Sane punou kuti hantawe tawene mo-on imin lengan ndramat, ");
INSERT INTO ktm_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","pe intawe loroh imin lengan lau. Sane punou kuti hanahnan pe sa ndramat hesenehtuno su sane isenehii pwi, pe hesenehtuno su nolou ndrokene ti pwi. Su hapa ye Kristen sios ti sal odo takun moni pe sane. ");
INSERT INTO ktm_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","Ndrokene, ipe ye tidu tidohtot punou ndre Lapan waso-on, eri tatidu sane we hohor. Titndringis pe tidehpukun sane kolwi. Tadam lehyen ndre mandra-an ti epwo-es koson. ");
INSERT INTO ktm_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","Odosa tine' taha hotou taha ise pwoi ti tihsa ke porah. Tihndretaku hangka-an indru-us tidu pwi. Pe tihmat ti we tihndretakuni hangka-an kindru-us tidu pwi yi. ");
INSERT INTO ktm_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","Ile pe ana' tidu song pe ndrihi' tidu ti iyenon tidu. ");
INSERT INTO ktm_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","Su ndramat kehe ndre herreh sane sulo-on ti kihne se sane erti herwi to-ir, pe to-ir kihya' su hadaketi odo punou huyen. Su kihne hopo sane mo-on pe sane erti hahya' su. ");
INSERT INTO ktm_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","Edei moni ti lin mo-on handrai pe handrai. Sa ndramat se ti reh ta sa mandra-an ti idu ke moni, pe hesenu-us salan bilip ta su ti pwi. Su ndramat erti hahna' hono-ong karundrum. ");
INSERT INTO ktm_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","Timoti, ou ti ndramtan Lapan. Ampahar odo sane ndre yu undripa tih. Opo sane kile huyen, ehwasu-um Lapan pe ohrung Iy, opuko-om bilip tadam, ahwasu-um sursor pede-en, ereh ta sa ndramat pe ala huyem kile ta su. ");
INSERT INTO ktm_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","Opkwe kile bilip tadam pe odo omur ta Yesus, kile pe okun mandro huyen ndre isenum pwi tih. Mandro erti Lapan iyuwen ou ile eriy kalmene-en ou apahran bilip tadam ile moleu idu mada' sa ndramat sulo-on. ");
INSERT INTO ktm_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","Mahkele, idu mada' Lapan ndre ihnan sane ndre sulo-on, pe idu madan Yesus Iy ndre ipahran nolou ndrokene ile tam Pontius Pailat... idu mada' horu eri yu kupwe kuti kile tadam: ");
INSERT INTO ktm_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","Nolou sa ou endretakunii ti ahyan kelwii, kihne sa lau hehndrukton. Ou enohtot ke ndre eriy, kenon ndre Mandra-an tatidu Yesus Kristus kihir yi kidu rang omur. ");
INSERT INTO ktm_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","Rang erti Lapan Iy ndre Iy indrita mundrun ile reh Tadan. Lapan ndre tidu tidemposan pe madan ise pule-en sane ndre sulo-on. Iy King ta su king pe Mandra-an ta sa ndramat mandra-ane. ");
INSERT INTO ktm_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","Iy kopwi isemat pwi, raman inehnelem, indranon homou kinna mukehe pwi. Homou ndramat isendre-et Iy pwi pe we homou kindranon kindre-et Iy pwi. Iy puko-on Tadan mandra-an. Tidu titsori rangan kile eleng kissou kopwi sei ihpa ke sei. Ndrokene. ");
INSERT INTO ktm_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","Apa kile ta su ndramat ndre ta su sane sulo-on odo lokpoi ti nombrun hesursor ke ranga' su. Su heduwe tawene ta su kile sane ihpa ndre moni ti kelwii, odosa sane kuti we hendruto ndresale pwi. Su hekeli-iy ke Lapan koson. Lapan ti intawe sane ndre sulo-on huyen ile ta taha odo posan taha. ");
INSERT INTO ktm_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","Apa kile ta su hopo sane kile huyen, hopo marai huyen kile sulo-on, hala huye' su pe hahngahang sane kile ta sa ndramat. ");
INSERT INTO ktm_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","Mandro-o' su huyen omur ti we kihir odo punou ihpa ndre ertih. Su hopo sane erti, odosa mandro-o' su huyen omur ti lin we kihir odo eriy. Iy erti laip ndre ndrokene tih. ");
INSERT INTO ktm_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","Timoti, adakorowe homosa ndre Lapan indretawe inna tadam ti kehii. Sane mo-on odo lokpoi ndre indre-en tawene ta Lapan pwi ti eduwe ndruwem kile eriy, pe nombrun osohou kile sane ndre hendre-en pahndran Kristen bilip pwi tih. ");
INSERT INTO ktm_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","Sa ndramat se hokun tawene kuti pe hendrehpil odo bilip ta su. Karundrum ta Lapan imin pule-e' oduu. ");
ALTER TABLE ktm_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
