﻿USE sofia;
DROP TABLE IF EXISTS sofia.ktj_vpl;
CREATE TABLE ktj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ktj_vpl WRITE;
INSERT INTO ktj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","'Crɩɛn ‑bʋ, ‑Yusu 'Klɩsʋ a ‑tɩ ɛ nɛ ‑mɔ lɛ. ‑Yusu 'Klɩsʋ a 'mʋ, ɛ mɔ bodɩɔ Dafidɩ a 'yonʋ a 'yu a 'Yu ꞊nɩɔ. Dafidɩ a 'mʋ, ɛ mɔ la Abrahamʋ a 'yonʋ a 'yu a 'yu ꞊nɩɔ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamʋ a 'mʋ, ɛ nɔ‑ kɔ Yisakɩ, ");
INSERT INTO ktj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda kɔ Tama 'hʋɛn‑, 'ʋ kɔ Falɛsɩ kɔ Sala, ");
INSERT INTO ktj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alamʋ 'ɛ kɔ Aminada, ");
INSERT INTO ktj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sala kɔ Rahabʋ 'hʋɛn‑ 'ʋ kɔ Bʋasɩ, ");
INSERT INTO ktj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yisai 'ɛ kɔ Dafidɩ, ");
INSERT INTO ktj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomɔ 'ɛ kɔ Rʋbʋamʋ, ");
INSERT INTO ktj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asafʋ 'ɛ kɔ Sosafatɩ, ");
INSERT INTO ktj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osiasɩ 'ɛ kɔ Sʋatamʋ, ");
INSERT INTO ktj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekiasɩ 'ɛ kɔ Manase, ");
INSERT INTO ktj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Sosiasɩ 'ɛ kɔ Yekonia kɔ 'a 'dɩayɩnʋ 'hʋɛn‑. Ti a 'mʋ 'yri, ‑ɛ ‑bɩ tʋ klɔ la Yisraɛkʋɛ nɩ, 'ʋ gba la 'lɩ ꞊nʋ Babilɔnɩblʋgba 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","‑Tɛ ʋ gba ꞊nʋ, ‑ɛ ‑bɩ ");
INSERT INTO ktj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Solobabɛlɩ 'ɛ kɔ Abiudɩ, ");
INSERT INTO ktj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asɔ 'ɛ kɔ Sadɔkɩ, ");
INSERT INTO ktj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudɩ 'ɛ kɔ Ɛlɩasa, Ɛlɩasa 'ɛ kɔ Mata, Mata 'ɛ kɔ Sakɔbʋ, Sakɔbʋ 'ɛ kɔ Sosɛfʋ. Sosɛfʋ, ɛ nɔ‑ mɔ Mari a nyɩbɩʋ, Mari a 'mʋ, ɛ nɔ‑ mɔ ‑Yusu 'Klɩsʋ a 'dii. ");
INSERT INTO ktj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","‑Yusu a 'mʋ, ɛ nɔ‑ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ‑a mʋ yɩ ya. ");
INSERT INTO ktj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kʋɛ 'lɩ Abrahamʋ ‑mɔ bʋ, ‑bʋ yɛ bodɩɔ Dafidɩ kɩ, ‑tonyibli a ꞊hrɩn nɩ ‑pu ꞊tu 'ʋ ‑hɛn, nʋ‑ nɩ 'ʋ 'waa ‑gbati. Kʋɛ 'lɩ Dafidɩ ‑mɔ bʋ, ‑bʋ yɛ ti ‑mʋ' ‑kɔ 'yri ʋ gba la 'lɩ Yisraɛkʋɛ Babilɔnɩblʋgba 'kwli, ‑tonyibli a ꞊hrɩn nɩ ‑pu ꞊tu 'ʋ ‑hɛn, ʋ nʋ‑ nɩ 'ʋ 'waa ‑gbati. Ɛ kɔ, kʋɛ 'lɩ ti a 'mʋ 'yie bʋ, ‑bʋ yɛ ‑Yusu a kʋkɔti kɩ, ‑tonyibli a ꞊hrɩn nɩ ‑pu ꞊tu 'ʋ ‑hɛn, ʋ nʋ‑ nɩ 'ʋ 'waa ‑gbati. ");
INSERT INTO ktj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","‑Tɛ ‑mʋ', ʋ nu la ‑Yusu 'Klɩsʋ a kʋkɔ, ɛ nɔ‑ ‑bʋ: 'A 'dii Mari a 'mʋ, Sosɛfʋ, ɛ nɔ‑ di la꞊a kɔ, kɛɛ ʋ 'yɛ la 'blɩ nɩ pʋɛ, 'ɛ nɩ la 'kwli, 'kɩ 'lɩ Nyɩsʋa a ‑Hihiu* a 'klɩ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Sosɛfʋ a 'mʋ, ‑ɛ di la꞊a kɔ, 'a 'yrinaabʋɩ 'sii la 'ʋ yɩ, 'kɩ 'ʋ Nyɩsʋa ye'. Ɛ nɔ‑ nu꞊o, 'kɩ ɛ 'yɛ nɩ ‑hʋa bʋ yɛɛ la Mari ‑tɩ, 'kɩ 'ʋ nyibli ye', ‑ɛ di꞊e nu, Mari a 'mʋ, 'a 'nyrɛ 'nɩ ꞊ha yɩ nyre. Ɛ nɔ‑ nu꞊o, 'ɛ pʋ la 'lɩ꞊ɩ 'lɩ, ‑ɛ mɔ, nyiblo ꞊dʋ 'nɩ 'wɩɩn la 'lɩ, 'bʋ mɔ, 'bʋ yɩ la Mari bʋ nɩ tɛ. ");
INSERT INTO ktj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bʋ yɩ la 'lu lɛ nɩ ‑hie, ‑ɛ ‑bɩ Nyɩsʋa a lɛlenyɔ 'hrɩɩ la꞊a yɩ, 'kɩ 'lɩ yanie 'kwli, ɛ wɛn: «Sosɛfʋ o, Dafidɩ a 'yu a 'yu, Mari bʋ ‑hɛ ‑na nʋgba, 'a hʋannʋ 'nɩ 'nuo 'lɩ ‑mʋ, ‑kɔtɩ Nyɩsʋa a ‑Hihiu a 'klɩ, ɛ nɔ‑ nu꞊o, 'ɛ nɩ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ɛ di kɔ 'yu nyɩbɛhɩan. 'Yu a 'mʋ, ꞊tue ꞊nɛ ‑Yusunyrɛ, ‑ɛ ꞊hɛn 'nyrɛ Wanyɔ, ‑ɛ nu꞊o, ɛ nɔ‑ di Nyɩsʋa a dakɔ wa, 'kɩ 'ʋ 'waa dɛ 'kuku a ‑ta'.» ");
INSERT INTO ktj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","‑Tɩ ‑mʋ', Nyɩsʋa lee la 'a winwlɔn‑hanyɔ*, ɛ nyre 'ʋ nɩ. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: ");
INSERT INTO ktj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Nʋgba ‑mʋ', ‑ɛ 'yɩ nyɩbɛdɛ ‑yi, ɛ nɔ‑ di 'kwli nɩ, ɛ 'mʋ 'yu nyɩbɛhɩan kɔ. 'A 'nyrɛ di mɔ Emanuɛ, ‑ɛ ꞊hɛn 'nyrɛ, Nyɩsʋa nɩ 'ʋ ‑a mʋ ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","‑Tɛ Sosɛfʋ 'du la ye', ‑ɛ ‑bɩ dɛ a 'mʋ, Nyɩsʋa a lɛlenyɔ lee la꞊a, ɛ ꞊tuu la 'ʋ꞊ʋ nɩ, 'ɛ kɔ la Mari. ");
INSERT INTO ktj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kɛɛ, ɛ kɔ꞊ɔ 'hʋɛn‑, ʋ 'yɩ la bʋɩ na yɩ ‑pʋ, Mari 'ɛ kɔ la 'yu nyɩbɛhɩan a 'mʋ, Sosɛfʋ 'ɛ ꞊tue la꞊a ‑Yusunyrɛ. ");
INSERT INTO ktj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","‑Yusu a 'mʋ, 'kɩ ʋ kɔɔ 'lɩ꞊ɩ Betelɛmʋdɩɔ 'kwli, 'kɩ 'lɩ Sudeblʋgba 'kwli. Ti a 'mʋ 'yri, ‑ɛ ‑bɩ Helɔdɩ, nɔ‑ mɔ Sudeblʋgba a 'mʋ a 'kɩɩn gbagbʋ. 'Kɩ ɛ nɩ 'lɩ Jrusrɛdɩɔ 'kwli. ‑Tɛ ʋ kɔ ‑Yusu, ɛ kɔ nyibli ꞊dʋ. 'Blʋgba ‑mʋ', ‑ɛ nɩ 'lɩ 'yrʋ a 'hrɩɩlɛ', 'kɩ ʋ nɩ 'lɩ. Ʋ mɔ nyahro'yenyʋ gbagbɩ ꞊nɩɔ. Ʋ nʋ‑ ‑hɔn 'lɩ 'yrʋ a 'hrɩɩlɛ', 'ʋ nyre 'lɩ Jrusrɛdɩɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","‑Tɛ ʋ nyre 'lɩ, ‑ɛ ‑bɩ ʋ wɛn: «'Yu ‑bʋ, ʋ ‑kɔ ‑tɛ ti nɛ bʋ, ‑ɛ di ‑Juukʋɛ* a 'kɩɩn gbagbʋ ‑hɛ, ‑bɩ' ɛ nɩ yɩ 'lɩ? ‑A 'ye 'a nyahroyɛ nɩ, 'ɛ 'hrɩɩ 'lɩ 'yrʋ a 'hrɩɩlɛ'. Ɛ nɔ‑ kɔ ‑tɩ, ꞊a di 'nɛ‑, ‑a 'mʋ꞊ʋ 'ye, ‑a 'mʋ 'a ‑tɩ 'yi 'bʋa ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","‑Tɛ 'kɩɩn Helɔdɩ 'wɩn ‑tɩ a 'mʋ, ‑ɛ ‑bɩ hʋannʋ bi 'lɩ꞊ɩ 'kwli, ɛ kɔ Jrusrɛ a nyibli a pɛpɛ 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ɛ nɔ‑ mɔ bʋ 'kukue Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ lɛ, kɔ tetetɔɔnyʋ 'hʋɛn‑, 'ɛ ‑tʋa 'waa lɛ'bɛtilɛ, ɛ wɛn: «Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ‑a mʋ yɩ ya, 'dɩɔ a 'dɩ ‑bɩ ‑ɛ kɔ 'kwli ʋ di 'lɩ꞊ɩ 'lɩ ‑kɔɔ ‑nɩ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","‑Ɛ ‑bɩ ʋ ꞊tu꞊o ꞊wɔn, ʋ wɛn: «'Kɩ ʋ di 'lɩ꞊ɩ Betelɛmʋ ‑kɔɔ ‑nɩ, 'kɩ 'lɩ Sudeblʋgba 'kwli, ‑ɛ nu꞊o, dɛ ‑mʋ', Nyɩsʋa a winwlɔn‑hanyɔ* 'crɩ la, 'kɩ 'ʋ Wanyɔ a 'mʋ kɩ, ɛ nɔ‑ ‑bʋ: ");
INSERT INTO ktj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Nyɩsʋa wɛn 'nɩ: Betelɛmʋ, 'ɛ mɔ ꞊han‑tɩ, 'ɛ mɔ 'dɩɔ 'cɩmɩɛ, kɛɛ, ɛ mɔ 'dɩɔ gbagbʋ ꞊nɩɔ, 'kɩ 'lɩ Sudeblʋgba 'kwli, ‑ɛ nu꞊o, 'kɩ 'lɩ꞊ɩ 'kwli, 'kɩ 'kɩɩn gbagbʋ di 'lɩ ‑kʋɛ ‑nɩ. Ɛ nɔ‑ di 'na dakɔ Yisraɛkʋɛ ‑naa ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","‑Tɛ Helɔdɩ 'wɩn ‑tɩ a 'mʋ, ɛ nɔ‑ mɔ bʋ da nyahro'yenyʋ gbagbɩ a 'mʋ, 'ɛ 'bɛti ꞊nʋ, ɛ 'mʋ꞊ʋ yi ‑tɛɛ, ti ‑mʋ', ‑ɛ kɔ 'yri nyahroyɛ a 'mʋ, ɛ 'hrɩɩ 'lɩ yakɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","‑Tɛ ʋ ‑hɩhɩa꞊a klɛ, ‑ɛ ‑bɩ ɛ wɛn: «Ba mu 'lɩ Betelɛmʋ, ba ꞊mʋɔ 'yu a 'mʋ lɛ. 'Ba 'ye꞊e, ‑ɛ ‑bɩ ba di 'mʋ ‑lee ‑nɩ, 'na 'mumu, 'mʋ 'lɩ mu, 'mʋ꞊ʋ ‑tɩ a 'yi'bʋalɛ ‑nyi ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","‑Tɛ ʋ 'wɩn 'kɩɩn a tiiwin, ‑ɛ ‑bɩ ʋ bi 'hru wlɔn. Bʋ nɩ 'kɩ 'hru wlɔn, ‑ɛ ‑bɩ ʋ 'ye nyahroyɛ ‑mʋ' nɩ, ʋ 'yee wɛn 'lɩ 'yrʋ a 'hrɩɩlɛ', 'ɛ 'hrɩɩ 'lɩ ꞊nʋ ye' de, 'ɛ nɛɛ ꞊nʋ ye', 'ʋ mi. Kɛɛ, ‑tɛ ‑mʋ', 'yu a 'mʋ, ɛ nɩ 'ʋ, ‑tɛ ɛ nyre 'ʋ, ‑ɛ ‑bɩ ɛ nyra bʋ. ");
INSERT INTO ktj_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","'Tɩ‑ ʋ 'mʋ nyahroyɛ a 'mʋ 'ye mɔ mu, ‑ɛ ‑bɩ ʋ ni dɔdʋ dɩakɩ, ");
INSERT INTO ktj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","'ʋ pa 'lɩ 'kayu bʋ, 'ʋ 'ye 'yu a 'mʋ, ɛ kɔ 'a 'dii Mari 'hʋɛn‑, 'ʋ bla kwlɩ bʋ, 'ʋ ‑tʋa 'yu a 'mʋ, 'a ‑tɩ a 'yi'bʋalɛ, 'ʋ ꞊wlɛ 'waa blɛ, 'ʋ ‑nyi꞊e ‑gʋlʋ kɔ hɩnhrʋnpʋ‑tɛblɩ ‑mʋ', ʋ pɩ 'tɔ, ‑ɛ di꞊e nu, 'a hɩnhrʋn 'mʋ bʋ 'hɛɛn ‑nɩ, ɛ kɔ hɩnhrʋnpʋ‑tɛblɩ ‑bɩ, ʋ dɛɛ milɩ. ");
INSERT INTO ktj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ Nyɩsʋa lee ꞊nʋ nɩ, 'kɩ 'lɩ yanie 'kwli, ‑ɛ mɔ, 'bʋ yɩ kle nɩ ‑mɛ, ʋ 'nɩ 'naa 'lɩ 'kɩɩn Helɔdɩ ‑mɔ. Ɛ nɔ‑ nu꞊o, ‑tɛ ʋ yɩ 'waa 'bli nɩ mi, 'ʋ gba kɩ'bɛɛhru. ");
INSERT INTO ktj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","'Tɩ‑ nyahro'yenyʋ a 'mʋ, ʋ 'mʋ mu, ‑ɛ ‑bɩ Nyɩsʋa a lɛlenyɔ ‑bɩ, ɛ nɔ‑ 'hrɩɩ Sosɛfʋ yɩ, 'kɩ 'lɩ yanie 'kwli, 'ɛ lee ꞊nɛ, ɛ wɛn: «'Du ye', ‑bʋ 'gbaa 'yu ‑bʋ, ɛ kɔ 'a 'dii 'hʋɛn‑ ci lɛ, ba mu 'lɩ Esipʋblʋgba 'kwli, 'kɩ ‑bʋ nɩ 'lɩ bʋ ‑nɩnɩ, ‑bʋ yɛ ti ‑mʋ' kɩ, ‑ɛ kɔ 'yri 'n di ‑mʋ ‑lee ‑nɩ, ‑bʋ di 'bli, ‑ɛ nu꞊o, Helɔdɩ di 'yu ‑bʋ 'a 'lɩla lɛ 'nɩ ꞊mʋɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","‑Tɛ Sosɛfʋ 'wɩn win a 'mʋ, ‑ɛ ‑bɩ ɛ 'du ye', ɛ kɔ 'yu kɔ a 'dii 'hʋɛn‑, 'tɔlʋwɔ nɩ ‑do a 'mʋ, 'ʋ mu 'lɩ Esipʋblʋgba 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","'Kɩ ʋ nɩ 'lɩ ‑nɩnɩ, Helɔdɩ 'ɛ 'kʋ, Nyɩsʋa 'ɛ da Sosɛfʋ, 'kɩ bʋ ‑hɔn 'lɩ Esipʋblʋgba 'kwli, ɛ kɔ 'yu kɔ 'a 'dii 'hʋɛn‑. Dɛ a 'mʋ, ɛ mu 'lu ‑mɔ, ‑ɛ di꞊e nu, ‑tɩ ‑mʋ', Nyɩsʋa a winwlɔn‑hanyʋ* ‑bɩ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, ɛ 'mʋ ‑nue ‑nɩ. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: «Nyɩsʋa wɛn 'nɩ: 'N da 'na 'Yu nɩ, 'kɩ bʋ ‑hɔn 'lɩ Esipʋblʋgba 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","‑Tɛ dɛ a 'mʋ, ɛ 'yɛɛ 'ʋ nɩ nyre, ‑tɛ 'kɩɩn Helɔdɩ yru꞊o, ‑ɛ mɔ, nyahro'yenyʋ ‑mʋ', ʋ kaa ꞊nɛ nɩ, ‑ɛ ‑bɩ ɛ bi la yrʋ' dɩakɩ, 'ɛ lee nɛ 'a 'sɛyo, ɛ wɛn: «Ba bi Betelɛmʋdɩɔ kɩ, ɛ kɔ 'dɩɩ ‑mʋ', ‑ʋ ꞊glaa 'lɩ꞊ɩ, ba 'la 'yonʋ nyɩbɛpʋ a pɛpɛ, ‑ʋ kɔ 'yrɩ nɩ 'hʋɛn, ɛ kɔ 'waa dɛ ‑bɩ ‑mʋ', ‑ʋ 'yɛ 'yrɩ nɩ 'hʋɛn nɩ kʋɛ.» Kɛ‑ ɛ ‑pʋ, ‑kɔtɩ nyahro'yenyʋ ‑mʋ', ʋ lee la꞊a nɩ, ‑ɛ mɔ, ‑tɛ ʋ 'ye la nyahroyɛ a 'mʋ, ɛ ‑wɛ 'klɩ 'yrɩ nɩ 'hʋɛn nɩ. Ɛ nɔ‑ mɔ 'sɛyo a 'mʋ, bʋ mu 'lɩ Betelɛmʋdɩɔ 'kwli, bʋ 'lɩla 'yonʋ a 'mʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","‑Tɛ dɛ a 'mʋ, ɛ mi 'lu ‑mɔ, ‑ɛ ‑bɩ ‑tɩ ‑mʋ', Nyɩsʋa a winwlɔn‑hanyɔ Selemi hla la, ti ‑hi la a ti 'yri, ɛ nyre 'ʋ nɩ. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: ");
INSERT INTO ktj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Ʋ 'wɩn ꞊hienwewin, 'kɩ 'lɩ Ramadɩɔ 'kwli. Rasɛlɩ, ɛ nɔ‑ ni nyaɩ lɛ, 'ɛ yɩ 'a 'yonʋ a ꞊hien we. Ɛ 'nɩ ‑hʋa꞊a lɩ bʋ ꞊ga꞊a, ‑ɛ nu꞊o, 'a 'yonʋ 'kʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","'Kɩ ʋ nɩ 'ʋ ‑nɩnɩ, ‑ɛ ‑bɩ 'kɩɩn Helɔdɩ 'kʋ nɩ. ‑Tɛ ɛ 'kʋ, ‑ɛ ‑bɩ Nyɩsʋa lee nɛ 'a lɛlenyɔ ‑bɩ, 'ɛ 'hrɩɩ Sosɛfʋ yɩ, 'kɩ 'lɩ Esipʋblʋgba 'kwli, ");
INSERT INTO ktj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ɛ wɛn: «Sosɛfʋ o, 'du ye', ‑kɔ 'yu, ‑kɔ 'a 'dii 'hʋɛn‑, ba ꞊hɩan ‑mɔ, ba mu 'aan 'bli Yisraɛ, ‑ɛ nu꞊o, nyibli ‑mʋ', ‑ʋ ꞊mʋɛ la 'yu ‑bʋ a 'kʋkʋʋ lɛ, ʋ 'kʋ nɩ,» ");
INSERT INTO ktj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Sosɛfʋ 'ɛ 'du ye', ɛ kɔ 'yu kɔ 'a 'dii 'hʋɛn‑, 'ʋ ꞊hɩan ‑mɔ, 'ʋ di 'waa 'bli Yisraɛ. ");
INSERT INTO ktj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kɛɛ, Sosɛfʋ 'wɩn nɩ, ‑ɛ mɔ, Akolawusɩ, ‑ɛ mɔ 'kɩɩn Helɔdɩ a 'yu, ɛ nɔ‑ 'cɩcɩ a 'baɩ. Akolawusɩ a 'mʋ, ɛ nɔ‑ mɔ 'kɩ Sudeblʋgba a 'kɩɩn. Ɛ nɔ‑ nu꞊o, Sosɛfʋ a 'mʋ, hʋannʋ 'ɛ ni꞊e, 'kɩ bʋ 'ti 'lɩ Sudeblʋgba 'kwli. Ɛ nɔ‑ kɔ ‑tɩ, Nyɩsʋa 'ɛ lee ꞊nɛ, 'kɩ 'lɩ yanie 'kwli, 'kɩ ɛ 'nɩ 'muo 'lɩ Sudeblʋgba 'kwli. Ɛ nɔ‑ nu꞊o, 'ɛ mu 'lɩ Galileblʋgba 'kwli, ");
INSERT INTO ktj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","'ɛ 'ti 'lɩ 'dɩɔ ‑mʋ', ʋ dɛɛ Nasalɛtɩ 'kwli. ‑Ɛ ‑bɩ ‑tɩ ‑mʋ', Nyɩsʋa a winwlɔn‑hanyɔ* hla la, 'kɩ 'ʋ Wanyɔ ‑mʋ' kɩ, Nyɩsʋa pʋ la lɛ, ɛ di la ya, ɛ nyre 'ʋ nɩ. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: «Ʋ di daa ꞊nɛ Nasalɛtɩ a 'yu.» ");
INSERT INTO ktj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ti a 'mʋ 'yri, ɛ kɔ la nyiblo ꞊dʋ. 'A 'nyrɛ mɔ Saan Batisɩ. 'Kɩ ɛ 'ti 'lɩ Sudeblʋgba 'kwli. 'Blʋgbakʋtɩɔ ‑mʋ', ‑ɛ kɔ 'kwli ɛ 'ti 'lɩ, nyiblo ꞊dʋ 'yɩ 'lɩ 'ti, kɛɛ, nyibli ‑hʋɔhʋɩ, ʋ nʋ‑ mi 'lɩ꞊ɩ ‑mɔ. 'Kɩ ɛ ꞊tuu 'lɩ Nyɩsʋa a ‑tɩ a ‑mɔlɛnɩna ‑wlu. Nyibli ‑mʋ', ‑ʋ mi 'lɩ꞊ɩ ‑mɔ, kɛ‑ ɛ pɩ ꞊nʋ yɩ: ");
INSERT INTO ktj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Ba yru꞊o, 'kɩ 'lɩ 'aan ꞊wlɩ kɩ, ‑ɛ mɔ, a nu ‑tɛblɩ, 'ɛ nyre yɩ, 'kɩ 'ʋ Nyɩsʋa ye'. Ba hie 'ʋ yɩnyre‑tɛblɩ a 'mʋ bʋ, ba ‑nyi 'aan 'klɔ a pɛpɛ Nyɩsʋa, ‑ɛ nu꞊o, ti ‑mʋ', ‑ɛ kɔ 'yri Nyɩsʋa di 'ʋ nyibli a pɛpɛ win kɩ ‑kɔɔ ‑nɩ, ɛ 'mʋɛ yrɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","‑Tɛ ʋ 'yɛ la ‑Yusu nɩ kʋɛ, ɛ kɔ la Nyɩsʋa a winwlɔn‑hanyɔ* ꞊dʋ. 'A 'nyrɛ mɔ la Esai. Esai a 'mʋ, ɛ nɔ‑ na Saan a ‑tɩ ‑mɔ lɛ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ, ɛ nɔ‑ di ‑Yusu a 'hru yɩ kla, 'tɩ‑ ‑Yusu a 'mʋ, ɛ 'mʋ di. ‑Tɩ a 'mʋ, ɛ 'crɩ la, ɛ nɔ‑ ‑bʋ: «Nyɩsʋa wɛn 'nɩ: Nyiblo ꞊dʋ, ‑tɛ ‑mʋ', 'dʋ bii 'lɩ yɩ, 'kɩ ɛ di 'lɩ 'ti. 'Bʋ mɔ, 'bʋ yɩ nɩ hle, ɛ di 'yaa 'lɩ win, ɛ 'mʋ lɛ pʋ: 'Hru ‑bʋ, Kʋkɔnyɔ di na, ba 'sii ꞊nɛ yɩ, 'tɩ‑ Kʋkɔnyɔ a 'mʋ, ɛ 'mʋ di. Ɛ 'wɩ yɩ, 'aan 'klɔ bʋ 'sii 'ʋ yɩ, ‑ɛ di꞊e nu, a 'mʋ ‑mɔ ‑wɛ, 'tɩ‑ Kʋkɔnyɔ 'mʋ di.» ");
INSERT INTO ktj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Saan a 'mʋ, 'a wlawlʋ, ɛ pɩ, ɛ 'yɩ dɛkɔnyɔ a wlawlʋ yɩ 'wɩ. Ʋ nu ꞊gbukɩ‑so* a ‑pupui, 'ʋ hla꞊a, 'ɛ nɛɛ ꞊nɛ mʋmakɔ a 'bɛtɩyɛ kɩ. 'A ‑nɛ dididɛ, ɛ yɩ di, ɛ nɔ‑ mɔ 'kolio kɔ dʋnyra. (Ɛ 'wɩ yɩ, Saan mɔ la Nyɩsʋa a winwlɔn‑hanyɔ ꞊nɩɔ la. ‑Tɛ nɩ ‑do nyibli ‑mʋ', ‑ʋ yɩ la Nyɩsʋa a win wlɔn ‑hɛ, ʋ nɩ la 'mʋ, ti ‑hi la a ti 'yri, kɛ‑ Saan nɩ la 'mʋ ‑wɛ.) ");
INSERT INTO ktj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nyibli ‑hʋɔhʋɩ, ʋ nʋ‑ ‑hʋɛn 'lɩ Jrusrɛdɩɔ kɔ Sudeblʋgba 'kwli lɛ, 'ʋ mi 'lɩ꞊ɩ yɩ, ʋ kɔ 'blʋgbɩ ‑mʋ', ‑ʋ ꞊glaa 'lɩ 'nie gbagbʋ ‑mʋ', ʋ dɛɛ Sudɛn a nyibli 'hʋɛn‑. Kɛ‑ nyibli a pɛpɛ a 'mʋ, ʋ ni, 'ʋ mi 'lɩ꞊ɩ yɩ, 'ʋ yɩ 'a win 'wɩn, ");
INSERT INTO ktj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","'ʋ yɩ 'waa ‑tɛblɩ 'kukui yɩ ‑wɛɛn ‑nɩ, 'kɩ 'ʋ nyibli ‑hʋɔhʋɩ yɩ, 'tɩ‑ Saan, 'ɛ pɩ ꞊nʋ 'nie 'lu lɛ, 'kɩ 'lɩ 'nie gbagbʋ ‑mʋ', ‑ɛ mɔ Sudɛn ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Falisi꞊tumu* kɔ Sadusɩ꞊tumu* a nyibli ‑hʋɔhʋɩ, nʋ‑ mi 'lɩ Saan ‑mɔ ‑wɛ, ‑ɛ di꞊e nu, ɛ 'mʋ ꞊nʋ 'nie 'lu lɛ pʋ. ‑Tɛ Saan 'ye ꞊nʋ, ‑ɛ ‑bɩ ɛ wɛn: «'A mʋ ‑mʋ', a kɛɛ nyibli, 'aan nunuklɔ 'ɛ nyre yɩ, ‑wɛn hro. Nyɩsʋa a yrʋ 'tɩɛ kwlɛ 'a mʋ nɩ. A 'nɩ 'pʋʋ 'lɩ lɛ, ‑ɛ mɔ, a ‑wɛ 'lɩ ba 'gba꞊a ye' ci nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","'Tɩ‑ 'mʋ 'a mʋ 'nie 'lu pʋ, ba nu ꞊haan‑tɛblɩ, ʋ 'mʋ꞊ʋ 'ye, ‑ɛ mɔ, a hie 'ʋ dɛ 'kuku, a ni bʋ, 'a ‑nyi 'aan dɩɔnʋ Nyɩsʋa. ");
INSERT INTO ktj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","A 'nɩ 'pʋʋ 'lɩ lɛ, ‑ɛ mɔ, a mɔ ‑aan 'baɩ gbagbʋ Abrahamʋ a 'yonʋ ꞊nɩɔ, 'a ‑tɩ, Nyɩsʋa 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ pʋʋ nɛ 'a mʋ yrʋ lɛ. 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, Nyɩsʋa ‑wɛ 'lɩ bʋ nu꞊o nɩ, 'hɩ ‑bʋ, bʋ ‑hɛ Abrahamʋ a 'yonʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ʋ ‑wɛ ‑mɔ, 'kɩ bʋ nu 'duwe, bʋ hla 'a ‑nɛ tugbɛ ꞊dʋ, ‑ɛ 'yɛ nɩ tʋ 'kui, ʋ 'mʋ꞊ʋ 'tɔ pʋ. Ɛ ꞊hɛn 'nyrɛ, ‑ɛ mɔ, Nyɩsʋa ‑wɛ ‑mɔ, 'kɩ bʋ pʋʋ nyibli ‑mʋ', ‑ʋ 'yɛ nɩ ꞊tuu 'ʋ꞊ʋ 'ʋ ‑bati lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","'Mɔ ‑bʋ, 'nie, ɛ nɔ‑ 'n pɩ 'a mʋ 'lu lɛ, ‑ɛ di꞊e nu, nyibli 'mʋ꞊ʋ 'ye, ‑ɛ mɔ, a hie 'ʋ 'aan dɛ 'kuku bʋ, 'a ‑nyi 'aan dɩɔnʋ Nyɩsʋa. Kɛɛ, nyiblo ‑bɩ di 'nɩ di. Nɔ‑ di 'ʋ 'mʋ ke' kʋɛ. Nɔ‑ di 'klɩ kɩ nɩ, ɛ 'mʋ 'ʋ 'mʋ 'ʋ ‑hi, 'kɩ 'lɩ Nyɩsʋa a 'nyrɛ 'kwli. 'Mɔ ‑bʋ, 'n 'yɩ nyiblo ꞊dʋ 'pa‑, 'kɩ ꞊bʋ di꞊e ‑hɛɛ ‑nɩ, 'kɩ 'ʋ 'a ‑nɛ ‑kʋandɛ ꞊dʋ a ‑ta'. Nyiblo a 'mʋ, ‑ɛ di di, Nyɩsʋa a ‑Hihiu* kɔ na ‑bʋ, ‑ɛ yɩ wlɩn, nɔ‑ ɛ di 'a mʋ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nyiblo a 'mʋ, ɛ di 'wɩ‑ ‑kʋbʋlɛ꞊hlonnyɔ yɩ, ‑ɛ 'ble ‑ŋmahɛn kʋa, ɛ di nu, ɛ 'mʋ ‑kʋbʋ lɛ ꞊hlon, 'bʋ ꞊hlon ‑kʋbʋ a 'mʋ lɛ, ɛ 'mʋ꞊ʋ bʋ ꞊tu, 'tɩ‑ ɛ 'mʋ 'a ‑tutui 'tɔ pʋ, 'kɩ 'lɩ na ‑mʋ', ‑ɛ 'yɛ nɩ jre 'nyɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","‑Nyrɔwɔ ꞊dʋ, 'kɩ ‑Yusu ‑hɔn 'lɩ Galileblʋgba 'kwli, 'ɛ mu 'lɩ 'nie ‑mʋ', ʋ dɛɛ Sudɛn wien, 'kɩ 'lɩ Saan 'hʋɩ, ‑ɛ di꞊e nu, Saan 'mʋ꞊ʋ 'nie 'lu pʋ. ");
INSERT INTO ktj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kɛɛ, Saan hɩa nɩ, ɛ wɛn: «'Mɔ ‑blɛɛ yɩ, ‑bʋ pʋ wɛn 'nie 'lu, kɛɛ, ‑mɔ ‑di, 'kɩ ꞊bʋ pʋ ‑mʋ 'nie 'lu.» ");
INSERT INTO ktj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kɛɛ, ‑Yusu ꞊tu꞊o ꞊wɔn, ɛ wɛn: «‑Tɛ ti nɛ ‑bʋ, ꞊nɩ 'hɩaa 'lɩ꞊ɩ kɩ, ‑kɔtɩ dɛ Nyɩsʋa ‑hʋa, ‑a blɛɛ yɩ ‑ba nu꞊o.» Ɛ nɔ‑ mɔ Saan bʋ wɛn, bʋ pʋ ‑Yusu 'nie 'lu. ");
INSERT INTO ktj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","‑Tɛ ɛ pʋ꞊ʋ 'nie 'lu, ‑Yusu bʋ yɩ 'lɩ 'nie ‑mɔ nɩ ‑hʋɛn, ‑ɛ ‑bɩ ti nɩ ‑do a ti 'yri, yakɔ ‑ki wlɔn, 'ɛ 'ye Nyɩsʋa a ‑Hihiu*, 'ɛ ‑hɔn 'lɩ yakɔ 'kwli, 'ɛ ꞊tɩɩ 'ʋ꞊ʋ 'lu, ɛ 'wɩ ‑tɛ ‑hungbe bʋ 'yɛ nɩ ꞊tɩɩ wɛn 'ʋ꞊ʋ 'lu, ");
INSERT INTO ktj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ɛ kɔ, 'ʋ 'wɩn Nyɩsʋa a win, 'ɛ ‑hɔn 'lɩ yakɔ 'kwli, 'ɛ pɩ lɛ: «Ɛ nɔ‑ mɔ 'na 'Yu nɩ ‑do, 'n nʋɛ ‑nɩ ‑tɛɛ, ‑ɛ nie 'mʋ dɔdʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ Nyɩsʋa a ‑Hihiu* gba 'lɩ ‑Yusu ‑tɩtɛ ‑mʋ', 'dʋ bii 'lɩ yɩ, ‑ɛ di꞊e nu, 'kuo ‑hʋɩn a nyiblo gbagbʋ Satan 'mʋ 'ʋ꞊ʋ lɛ ꞊tɛɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","'Kɩ 'lɩ ‑tɩtɛ a 'mʋ, 'kɩ ɛ ‑hi 'lɩ ‑nyrɔwɩ a ‑wlɩ nɩ 'hʋɛn kɔ 'tɔlʋwɩ a ‑wlɩ nɩ 'hʋɛn. 'Kɩ ‑nyrɔwɩ a 'mʋ 'kwli, ɛ 'yɩ dɛ ‑di. ‑Tɛ ‑nyrɔwɩ a ꞊wlɩ nɩ 'hʋɛn a 'mʋ, ʋ ‑hi, ‑ɛ ‑bɩ 'kanʋ ‑tʋa la 'a nunuo. ");
INSERT INTO ktj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ɛ nɔ‑ mɔ 'kuo ‑hʋɩn a nyiblo gbagbʋ bʋ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, bʋ lee ꞊nɛ: «'Bʋ mɔ, ꞊nɩ mɔ Nyɩsʋa a 'Yu, lee 'hɩ ‑bʋ, bʋ ‑hɛ 'flɔɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","‑Ɛ ‑bɩ ‑Yusu ꞊tu꞊o ꞊wɔn, ɛ wɛn: «Ʋ 'crɩ꞊ɩ nɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ, ɛ 'yɩ dididɛ nɩ ‑do 'pa‑, ɛ 'nɩ ‑nu꞊o lɩ꞊ɩ, ‑tonyiblo 'nɩ ‑nɩ꞊ɩ 'klɔ, kɛɛ, win a pɛpɛ, ‑ɛ ‑hʋɛn 'lɩ Nyɩsʋa wlɔn, ɛ nɔ‑ ni꞊e, 'tɩ‑ ‑tonyiblo 'ɛ yɩ 'klɔ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","‑Tɛ ɛ ‑hi, ‑ɛ ‑bɩ 'kuo ‑hʋɩn a nyiblo gbagbʋ gba 'lɩ꞊ɩ Jrusrɛdɩɔ 'kwli, ‑ɛ mɔ Nyɩsʋa a dakɔ a 'dɩɔ gbagbʋ, 'ɛ 'yaa 'lɩ꞊ɩ Nyɩsʋa a 'kagbaʋ kɩ, ");
INSERT INTO ktj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","'tɩ‑ 'ɛ yɩ 'kɩ꞊ɩ ‑lee ‑nɩ, ‑ɛ mɔ: «'Bʋ mɔ, ꞊nɩ mɔ Nyɩsʋa a 'Yu, ‑ɛ ‑bɩ ꞊pluu 'lɩ ꞊hlɔn, ‑ɛ nu꞊o, ʋ 'crɩ꞊ɩ nɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ: ‑Na ‑tɩ Nyɩsʋa kɔ bʋ lee nɛ 'a lɛlenyʋ, ʋ 'mʋ ‑mʋ klɔ, ‑ɛ di꞊e nu, ‑na bʋ 'nɩ ꞊ha 'hɩɔ yɩ ꞊gbɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","‑Yusu wɛn: «Ʋ 'crɩ꞊ɩ nɩ ‑wɛ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ: ꞊Yɩ yɩ ‑blɛɛ ‑nɩ, ‑bʋ ꞊tɛɛ 'ʋ ‑na Kʋkɔnyɔ Nyɩsʋa lɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","‑Ɛ ‑bɩ 'kuo ‑hʋɩn a nyiblo gbagbʋ gba꞊a nɩ de, 'kɩ 'lɩ dʋgba blɔblʋ 'lu, 'ɛ tɔɔ ꞊nɛ 'klɔ kɩ a 'blʋgbɩ a pɛpɛ, kɔ 'waa ‑tɩ a 'yi'bʋbʋa, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","«'N kɔ ꞊bʋ ‑nyi ‑mʋ 'a pɛpɛ, 'bʋ mɔ, ꞊nɩ bla 'mʋ kwlɩ yɩ bʋ, 'kɩ 'ʋ 'na 'ʋ꞊tuulɛ a ‑ta'.» ");
INSERT INTO ktj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","‑Ɛ ‑bɩ ‑Yusu wɛn: «Mu, Satan, hlɔɔ 'mʋ ‑mɔ lɛ, ‑ɛ nu꞊o, ʋ 'crɩ꞊ɩ nɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ: ‑Na Kʋkɔnyɔ Nyɩsʋa nɩ ‑do, ɛ nɔ‑ ‑blɛɛ yɩ ‑bʋ bla kwlɩ yɩ bʋ, 'kɩ 'ʋ 'a 'ʋ꞊tuulɛ a ‑ta', nɔ‑ blɛɛ ‑tɩ a 'yi'bʋalɛ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","‑Tɛ ɛ ‑yrɛ, ‑ɛ ‑bɩ 'kuo ‑hʋɩn a nyiblo gbagbʋ ‑ha꞊a mɛ lɛ. Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ Nyɩsʋa a lɛlenyʋ nyre 'ʋ꞊ʋ 'hʋɩ, 'ʋ ‑tʋa 'a ‑hɛɛlɛ. ");
INSERT INTO ktj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","13","‑Yusu 'wɩn nɩ, ‑ɛ mɔ, ʋ pʋ Saan Batisɩ ꞊jɩ'. Ɛ nɔ‑ kɔ ‑tɩ 'ɛ ‑hɔn 'lɩ Sudeblʋgba 'kwli, 'ɛ mu 'lɩ 'a 'dɩɔ, ‑ɛ mɔ Nasalɛtɩ 'kwli, 'kɩ 'lɩ Galileblʋgba 'kwli. Kɛɛ, ɛ 'yɩ 'lɩ ‑wlɛɛn ‑nɩ, 'ɛ mu 'lɩ 'dɩɔ ‑mʋ', ‑ɛ mɔ Kapɛnaɔ 'kwli, ‑ɛ nɩ 'ʋ Galileblʋgba a 'yru wien, 'kɩ 'lɩ Sabuloblʋgba kɔ Nɛfʋtaliblʋgba 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ɛ nu꞊o nɩ, ‑ɛ di꞊e nu, ‑tɩ ‑mʋ', Nyɩsʋa a winwlɔn‑hanyɔ Esai hla la, ɛ 'mʋ 'ʋ nyre. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: ");
INSERT INTO ktj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Ba pʋ 'ʋ nʋa bʋ, 'a mʋ nyibli ‑mʋ', ‑ʋ nɩ 'lɩ Sabuloblʋgba kɔ Nɛfʋtaliblʋgba 'kwli, 'kɩ 'lɩ 'yru wien, kɔ 'a mʋ ‑mʋ', ‑ʋ nɩ 'lɩ Sudɛn a 'nikɩ, ɛ kɔ 'a mʋ hɩapʋnyibli ‑mʋ', ‑ʋ 'yɩ Nyɩsʋa ‑yi, ‑ʋ nɩ 'lɩ Galileblʋgba 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kɛ‑ Nyɩsʋa ‑pʋ, 'kɩ 'ʋ 'aan ‑ta': Dakɔ ‑mʋ', ‑ʋ nɩ 'lɩ halɔ 'nyɩ, ʋ di 'ye ‑nyrɛ gbagbʋ. ‑Nyrɛ a 'mʋ, ɛ yɩ 'nɩ wlɩn, 'kɩ 'ʋ dakɔ a 'mʋ ‑mɔ, ‑ʋ nɩ 'lɩ 'kʋkʋʋ a 'blʋgba 'kwli, ‑ɛ kɔ 'kwli ‑nyrɛ 'yɩ 'lɩ ‑nɩ.» Kɛ‑ Esai a 'pʋplɛwin pʋ la. ");
INSERT INTO ktj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kʋɛ 'ʋ ti a 'mʋ 'yie bʋ, ‑Yusu ‑tʋa la Nyɩsʋa a ‑tɩ a ‑mɔlɛnɩna, ɛ wɛn: «Ba yru꞊o, 'kɩ 'lɩ 'aan ꞊wlɩ kɩ, ‑ɛ mɔ, a ni ‑tɛblɩ, 'ɛ nyre yɩ, 'kɩ 'ʋ Nyɩsʋa ye'. Ba hie 'ʋ yɩnyre‑tɛblɩ a 'mʋ bʋ, ba ‑nyi 'aan 'klɔ a pɛpɛ Nyɩsʋa, ‑ɛ nu꞊o, ti ‑mʋ' ‑kɔ 'yri Nyɩsʋa di nyibli a pɛpɛ win kɩ ‑kɔɔ ‑nɩ, ɛ 'mʋɛ yrɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","‑Nyrɔwɔ ꞊dʋ 'kwli, ‑Yusu mu la 'lɩ Galileblʋgba a 'yru wien. Bʋ yɩ 'kɩ 'yru wien lɛ nɩ 'yrɛɛ ‑nɩ, ‑ɛ ‑bɩ ɛ yɛ 'dɩayɩnʋ nɩ 'hʋɛn kɩ. 'Waa 'nyrɛ mɔ Simɔ, ʋ dɛɛ Piɛlɩ, kɔ Adre. Ʋ mɔ 'pʋpanyibli ꞊nɩɔ. 'Kɩ ʋ nɩ 'lɩ 'waa 'blagbɩ 'kwli, 'ʋ pɩ 'waa ‑tatɩ. ");
INSERT INTO ktj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «Ba di 'lɩ, a 'mʋ 'mʋ ꞊wien lɛ kʋɛ, a 'mʋ 'na ‑nagbopʋ ‑hɛ. 'N di꞊e 'nɩ nu, a 'mʋ ‑tonyibli lɛ 'kukue ‑nɩ. Ɛ 'wɩ yɩ, ‑tɛ a ni, 'a pɩ ‑tatɩ 'a yɩ ‑hrin lɛ 'kukue ‑nɩ, kɛ‑ ba nu, ba 'kukue ‑tonyibli lɛ, ʋ 'mʋ 'na ‑nagbopʋ ‑hɛ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","‑Tɛ ɛ lee 'kɩ ꞊nʋ ‑tɩ a 'mʋ, ‑ɛ ‑bɩ ti nɩ ‑do a ti 'yri, ʋ hie 'ʋ 'waa ‑tatɩ bʋ, 'ʋ ‑tʋa 'a ꞊wienlɛkʋkʋɛ. ");
INSERT INTO ktj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bʋ 'yɩya 'ʋ ye' bʋ, ‑ɛ ‑bɩ ɛ yɛɛ 'ʋ 'dɩayɩnʋ nɩ 'hʋɛn ‑bɩ bʋ. 'Waa 'nyrɛ mɔ Sakɩ kɔ Saan. 'Waa 'baɩ a 'nyrɛ mɔ Sebede. 'Kɩ ʋ nɩ 'lɩ 'waa 'blagbɩ 'kwli, ʋ kɔ 'waa 'baɩ 'hʋɛn‑, 'ʋ yɩ 'waa ‑tatɩ ꞊hrɛntɩ ‑nɩ. ‑Tɛ ɛ yɛɛ 'ʋ 'dɩayɩnʋ nɩ 'hʋɛn a 'mʋ bʋ, ‑ɛ ‑bɩ ɛ da ꞊nʋ nɩ, 'kɩ bʋ ‑hɛ 'a ‑nagbopʋ, ");
INSERT INTO ktj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ti nɩ ‑do a ti 'yri, 'ʋ hie 'ʋ 'waa 'baɩ kɔ 'waa 'blagbɩ bʋ, 'ʋ ‑tʋa ‑Yusu a ꞊wienlɛkʋkʋɛ. ");
INSERT INTO ktj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu ‑tʋa Galileblʋgba a pɛpɛ a kɩnɩna, 'ɛ tʋɛ Nyɩsʋa a ‑tɩ, 'kɩ 'lɩ Nyɩsʋa a 'kayo blɛ, 'ɛ hlɛ꞊ɛ, ‑tɛ Nyɩsʋa di ‑tonyibli a win a kɩkɔɔlɛ nu, 'ɛ ni꞊e, nyibli a 'kʋɛ a pɛpɛ 'ɛ yɩ ‑wɛ, kɔ 'waa kɩkla‑tɛblɩ a pɛpɛ 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ɛ nɔ‑ kɔ ‑tɩ, 'a 'nyrɛ 'ɛ 'hɛɛn bʋ, 'kɩ 'lɩ Galileblʋgba a pɛpɛ 'kwli, nyibli ‑nɩ 'lɩ Siliblʋgba 'kwli, 'ʋ 'wɩn 'a 'nyrɛ. Ɛ nɔ‑ kɔ ‑tɩ 'ʋ gbɛ 'lɩ꞊ɩ 'hʋɩhrennyʋ ‑hʋɔhʋɩ ‑mɔ, ɛ kɔ nyibli ‑mʋ', 'a ‑nɛ kɩkladɛ ꞊dʋ ni. Nyibli a 'mʋ, 'waa dɛ ‑bɩ nɩ 'ʋ, 'kuo ‑hʋɩn* nɩ 'ʋ ꞊nʋ ke', ‑gbugbukʋɛ 'ɛ ni ‑ʋ ‑bɩ, 'waa dɛ ‑bɩ 'ʋ ‑yɩyrɛ lɛ. 'Waa pɛpɛ a 'mʋ, ‑Yusu nu꞊o nɩ, 'waa 'kʋɛ 'ɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ɛ nɔ‑ kɔ ‑tɩ nyibli ‑hʋɔhʋɩ 'ʋ yɩ꞊ɩ ꞊wien lɛ kʋɛ. 'Kɩ ʋ ‑hʋɛn 'lɩ Galileblʋgba kɔ Dekapɔblʋgba, kɔ Jrusrɛ kɔ Sudeblʋgba a pɛpɛ 'kwli, kɔ 'blʋgba ‑mʋ', ‑ɛ nɩ 'lɩ Sudɛn a 'nikɩ. ");
INSERT INTO ktj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","‑Tɛ ‑Yusu 'ye la nyibli ‑hʋɔhʋɩ ‑mʋ', ‑ɛ ‑bɩ 'kɩ ɛ 'ya la 'ʋ dʋgba 'lu, ɛ kɔ 'a ‑nagbopʋ 'hʋɛn‑, 'ɛ nɩ la bʋ, ");
INSERT INTO ktj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","'ɛ ‑tʋa la 'waa tɔɔlɛ. ");
INSERT INTO ktj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ɛ wɛn: «Nyibli ‑mʋ', ‑ʋ yi꞊e, ‑ɛ mɔ, 'kɩ 'lɩ 'waa ꞊wlɩ kɩ, ꞊haandɛ 'yɩ 'lɩ ‑nɩ, 'bʋ mɔ, Nyɩsʋa a ‑Hihiu* 'bʋ 'yɩ 'ʋ ꞊nʋ ke' ‑nɩ, nyibli a 'mʋ, bʋ kɔ plɔ a bleelɛ, ‑ɛ nu꞊o, ʋ nʋ‑ di 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli pa. ");
INSERT INTO ktj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nyibli ‑mʋ', ‑ʋ kɔ ꞊wlɩ bi ꞊hlɔn, bʋ kɔ plɔ a bleelɛ, ‑ɛ nu꞊o, Nyɩsʋa a ꞊gbɛtʋ, ɛ nɔ‑ di 'lɩ ꞊nʋ ꞊wlʋ 'kwli bʋ ꞊tu. ");
INSERT INTO ktj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nyibli ‑mʋ', ‑ʋ kɔ ꞊wlɩ ꞊yɔpɔ ‑nɩ, bʋ kɔ plɔ a bleelɛ, ‑ɛ nu꞊o, ʋ nʋ‑ Nyɩsʋa di 'blʋgba ‑mʋ' ‑nyi, ɛ pʋ lɛ, ɛ di 'a nyibli ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nyibli ‑mʋ', ‑ʋ ꞊mʋɛ꞊ɛ lɛ dɩakɩ, 'kɩ 'lɩ 'waa ꞊wlɩ a pɛpɛ kɩ, 'kɩ 'waa nɩnabʋɩ bʋ 'sii 'ʋ yɩ, 'kɩ 'ʋ Nyɩsʋa ye', nyibli a 'mʋ, bʋ kɔ plɔ a bleelɛ, ‑ɛ nu꞊o, dɛ ‑mʋ', ʋ ꞊mʋɛ lɛ, Nyɩsʋa di ꞊nʋ 'nɩ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nyibli ‑mʋ', ‑ʋ kɔ 'waa 'bio ‑tonyibli a nyaɩ, bʋ kɔ plɔ a bleelɛ, ‑ɛ nu꞊o, 'waa 'mumu, Nyɩsʋa di yru 'waa nyaɩ. ");
INSERT INTO ktj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nyibli ‑mʋ', ‑ʋ kɔ ꞊wlɩ ꞊sii 'ʋ yɩ, bʋ kɔ plɔ a bleelɛ, ‑ɛ nu꞊o, ʋ di Nyɩsʋa 'nɩ 'ye. ");
INSERT INTO ktj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nyibli ‑mʋ', ‑ʋ ꞊mʋɛ꞊ɛ lɛ, 'kɩ nyibli bʋ wʋnwɛɛn kɩ bʋ, bʋ kɔ plɔ a bleelɛ, ‑ɛ nu꞊o, Nyɩsʋa di daa ꞊nʋ 'a 'yonʋ. ");
INSERT INTO ktj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nyibli ‑mʋ', dɛ Nyɩsʋa ‑hʋɛ, ‑ʋ ni꞊e, 'a ‑tɩ 'bʋ yɩ ꞊nʋ ꞊hɩʋɛn nɩ ꞊tui, nyibli a 'mʋ, bʋ kɔ plɔ a bleelɛ, ‑ɛ nu꞊o, ʋ nʋ‑ di 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli pa. ");
INSERT INTO ktj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","'A mʋ ‑mʋ', 'bʋ yɩ 'a mʋ 'yri nɩ ‑hɛ, 'bʋ yɩ 'a mʋ ꞊hɩʋɛn nɩ ꞊tui, 'bʋ yɩ 'a mʋ ‑tɩ nɩ ‑yɛɛ ‑nɩ, 'bʋ yɩ 'a mʋ hɩ klɛ nɩ pɩ, ‑tɛ a mɔ 'na ‑nagbopʋ* a ‑tɩ, ba kɔ plɔ a bleelɛ. ");
INSERT INTO ktj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ba nu dɔdʋ, ‑kɔtɩ ‑nyrɔwɔ, a di Nyɩsʋa yɩ mu, Nyɩsʋa di ‑nyi 'a mʋ 'wio gbagbʋ. Nyɩsʋa a winwlɔn‑hanyʋ* ‑mʋ', ‑ʋ nɩ la 'klɔ, ti ‑hi la a ti 'yri, kɛ‑ nyibli ni la, 'ʋ ꞊tui la ꞊nʋ ꞊hɩʋɛn.» ");
INSERT INTO ktj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Kɛ‑ ‑Yusu pɩ 'a ‑nagbopʋ* yɩ de: «‑Tɛ 'ta nɩ 'mʋ, 'kɩ 'ʋ dididɛ ‑mɔ, kɛ‑ a nɩ 'mʋ, 'kɩ 'ʋ ‑tʋtʋ kɩ a nyibli ‑mɔ ‑wɛ. Kɛɛ, 'ta a 'mʋ, bʋ 'waan nɛ 'a wlɔnnɩnɔ, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑nyi꞊e 'a wlɔnnɩnɔ a 'mʋ de. Ɛ 'yɩ 'kɩ ‑kʋan ꞊dʋ ‑kɔ de, 'bʋ 'yɩ bʋ pɩɩ 'wan, nyibli bʋ na꞊a klɛ. ");
INSERT INTO ktj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","'A mʋ ‑mɔ 'klɔ ‑bʋ, 'a ‑nyrɛ. 'Dɩɔ ‑mʋ', ‑ɛ nɩ 'lɩ dʋgba 'lu, ɛ 'yɩ ‑huhlidɩɔ 'pa‑. ");
INSERT INTO ktj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nyiblo 'bʋ 'bɩa 'napɩ, ɛ 'nɩ ꞊jri꞊e lɩ꞊ɩ kɩka 'lu bʋ, kɛɛ, 'kɩ ɛ ꞊tui 'ʋ꞊ʋ dɛ 'lu bʋ, ‑ɛ di꞊e nu, nyibli ‑mʋ', ‑ʋ nɩ 'lɩ 'kayu bʋ, 'ʋ 'mʋ lɛ yru. ");
INSERT INTO ktj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","‑Tɛ 'napɩ ni wʋnwlɩɩn, 'kɩ 'ʋ nyibli ‑mʋ' ‑mɔ, ‑ʋ nɩ 'lɩ halɔ 'nyɩ, kɛ‑ 'aan nunuklɔ bʋ nu wʋnwlɩɩn, 'kɩ 'ʋ nyibli ye', ‑ɛ di꞊e nu, ꞊haandɛ ‑mʋ', a di nu, ʋ 'mʋ꞊ʋ 'ye, ʋ 'mʋ 'aan 'Baɩ Nyɩsʋa ‑nɩ 'lɩ yakɔ 'kwli 'nyrɛ lɛ pʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«'Aan ꞊wlɩ 'nɩ 'yee 'lɩ꞊ɩ, ‑ɛ mɔ, 'n di nɩ, ‑ɛ di꞊e nu, 'mʋ 'ʋ tete ‑mʋ' lɛ ‑ha, Nyɩsʋa ‑nyi la 'a winwlɔn‑hanyɔ* Moise, ɛ kɔ ‑tɩ ‑mʋ', Nyɩsʋa a winwlɔn‑hanyʋ ‑bɩ 'crɩ la. 'N 'yɩ ‑di, 'kɩ ꞊bʋ ‑ha 'ʋ꞊ʋ 'ʋ, kɛɛ, 'n di nɩ, 'mʋ 'a mʋ ‑tɔɔ ‑nɩ, dɛ ‑mʋ' ɛ ꞊hɛn 'nyrɛ, ɛ kɔ, ‑tɩ ‑bʋ, ɛ hlɛ, 'mʋ꞊ʋ nu. ");
INSERT INTO ktj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ɛ 'yɩ Nyɩsʋa a tetebʋ gbe ꞊dʋ ‑kɔ, ‑bʋ di 'ʋ 'a 'bɩ 'lu ‑hɔn, ɛ 'mʋ꞊ʋ gba ‑gbagba, yakɔ kɔ ‑tʋtʋ 'hʋɛn‑, ʋ 'mʋ bʋ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ɛ nɔ‑ nu꞊o, nyiblo 'bʋ nɩ 'ʋ, 'bʋ yɩ 'ʋ Nyɩsʋa a tetebʋ 'cɩmɩɛ gbe nɩ ‑do 'hru wlɔn nɩ ‑hɛ, 'tɩ‑, 'bʋ yɩ꞊ɩ nyibli ‑bɩ nɩ ‑tʋɛ ‑nɩ, nyiblo a 'mʋ, ɛ nɔ‑ ʋ di nyiblo 'cɩmɩɛ ‑daa ‑nɩ, 'kɩ 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli. Kɛɛ, nyiblo 'bʋ nɩ 'ʋ, 'bʋ yɩ 'ʋ tete a 'mʋ nɩ ꞊tui ‑nɩ, kɔ 'bʋ yɩ꞊ɩ ‑ʋ ‑bɩ nɩ ‑tʋɛ ‑nɩ, ɛ nɔ‑ ʋ di nyiblo gbagbʋ ‑daa ‑nɩ, 'kɩ 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ: Dɛ ‑mʋ', Nyɩsʋa ‑hʋɛ, tetetɔɔnyʋ kɔ Falisi꞊tumu* a nyibli 'hʋɛn‑, ʋ 'nɩ ‑nu꞊o lɩ꞊ɩ. 'A mʋ ‑mɔ ‑bɩ, 'ba 'yɛ nɩ ꞊tuu 'ʋ Nyɩsʋa, 'ba 'yɩ 'ʋ nyibli a 'mʋ 'ʋ ‑hi, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba pa 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«A yi꞊e nɩ, ‑ɛ mɔ, tete ‑bɩ, Nyɩsʋa ‑nyi la ‑aan 'baɩnʋ, ɛ nɔ‑ mɔ: ꞊Nɩ 'laa 'lɩ nyiblo. Nyiblo 'bʋ 'la 'a 'bɩ ‑tonyiblo, ʋ kɔ bʋ pʋʋ ꞊nɛ ‑bati lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kɛɛ, 'mɔ ‑bɩ, kɛ‑ 'n pɩ: 'A ‑nɛ nyiblo 'bʋ yɩ 'a 'dɩayɩ yrʋ lɛ nɩ ‑pɩɩ ‑nɩ, ʋ blɛɛ yɩ bʋ gba 'lɩ nyiblo a 'mʋ ‑batipʋnyʋ yɩ. Nyiblo 'bʋ lee nɛ 'a 'dɩayɩ, ‑ɛ mɔ: ‑Ba nɩ, ʋ blɛɛ yɩ bʋ gba 'lɩ꞊ɩ 'blʋ a nyibli yɩ, ʋ 'mʋ꞊ʋ ‑bati lɛ ‑pʋʋ ‑nɩ. Nyiblo 'bʋ daa nɛ 'a 'dɩayɩ nɩblɩnyɔ, ɛ blɛɛ yɩ bʋ mu 'lɩ na ‑mʋ' 'nyɩ, ‑ɛ 'yɛ nɩ jre yruyru. ");
INSERT INTO ktj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","'Bʋ mɔ, ꞊nɩ yɩ ‑cɔhlʋn* nɩ pi, 'kɩ 'ʋ Nyɩsʋa ye', 'tɩ‑ 'bʋ bi 'lɩ ‑mʋ 'kwli, ‑ɛ mɔ, ‑na 'dɩayɩ ‑bɩ, ɛ 'yɩ plɔ a bleelɛ ‑kɔ ‑na ‑tɩ, ");
INSERT INTO ktj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","hie 'ʋ ‑na ‑cɔhlʋn a 'mʋ bʋ, ‑bʋ mu, ‑kɔ ‑na 'dɩayɩ a 'mʋ 'hʋɛn‑, a 'mʋ ‑tɩ a 'mʋ yrɛ ‑kʋkʋa ‑nɩ, ɛ 'mʋ 'lɩ ‑wɛ, 'tɩ‑ ꞊mʋ ‑mɔ ꞊hɩan, ꞊mʋ ‑cɔhlʋn pi, 'kɩ 'ʋ Nyɩsʋa ye'. ");
INSERT INTO ktj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","'Bʋ mɔ, nyiblo 'bʋ yɛɛ ‑mʋ ‑tɩ, ‑ɛ nu꞊o, ꞊ble 'a 'wliyɛ kʋa, ɛ kɔ ‑mʋ 'hʋɛn‑, 'ba yɩ 'lɩ ‑batipʋʋlɛ' nɩ mi, ꞊mʋɔ꞊ɔ lɛ, 'kɩ ɛ kɔ ‑mʋ 'hʋɛn‑, ba kɔ kɩbʋwɛɛnlɛ, ‑tɛ a 'tɩɛ nɩ 'hru wlɔn, ɛ 'nɩ ꞊ha 'lɩ ‑mʋ ‑batipʋnyɔ yɩ gba, ‑batipʋnyɔ 'nɩ ꞊ha ‑mʋ 'lɩ ‑sadapʋ yɩ gba, 'ʋ 'nɩ ꞊ha ‑mʋ ꞊jɩ' pʋ. ");
INSERT INTO ktj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","'N yɩ ‑mʋ 'nɩ ‑lee ‑nɩ, 'bʋ pʋ ‑mʋ ꞊jɩ', 'kɩ ‑di 'lɩ ꞊jɩ' a 'mʋ nɩ, ꞊mʋ 'wliyɛ a pɛpɛ a 'mʋ 'pɛɛ ‑nɩ, 'tɩ‑ ꞊mʋ ꞊jɩ' 'hrɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«A yi꞊e nɩ, ‑ɛ mɔ, tete ‑bɩ, Nyɩsʋa ‑nyi la ‑aan 'baɩnʋ, ɛ nɔ‑ mɔ: ꞊Nɩ 'nuo 'lɩ ‑wlawlɩ. ");
INSERT INTO ktj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kɛɛ, 'mɔ ‑bɩ, kɛ‑ 'n pɩ, nyiblo 'bʋ ta 'lɩ 'a 'bɩhɩan a nʋgba 'yi lɛ, 'tɩ‑, 'kɩ 'lɩ 'a ꞊wlʋ kɩ, 'bʋ pʋ lɛ: 'N ‑hʋɛ꞊ɛ nɩ, nyiblo a 'mʋ, ɛ nu ‑wlawlɩ, 'kɩ 'lɩ 'a ꞊wlʋ kɩ, ɛ kɔ nʋgba a 'mʋ 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","'Bʋ mɔ, ‑na 'yii 'bʋ yɩ꞊ɩ nɩ ni, ꞊nɩ yɩ dɛ 'kuku nɩ ni, ‑ɛ ‑bɩ ‑ha 'lɩ ꞊nʋ lɛ, ꞊mʋ ꞊nʋ 'wan pʋ. ‑Bʋ ‑ha 'ʋ ‑dɩɔnʋ a 'hʋɩ a 'kɩbɩa, ‑bʋ pʋ꞊ʋ 'wan, ɛ nɔɔ 'ʋ lɛ, 'ɛ ‑hi 'ʋ bʋ pʋ 'lɩ ‑na pɛpɛ na ‑mʋ', ‑ɛ 'yɛ nɩ jre yruyru 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","'Bʋ mɔ, ‑na diidɛdabʋ 'bʋ yɩ꞊ɩ nɩ ni, ꞊nɩ yɩ dɛ 'kuku nɩ ni, 'bɛ 'ʋ꞊ʋ 'ʋ, ꞊mʋ꞊ʋ 'wan pʋ. Ɛ nu ‑tɛɛ, 'kɩ ‑bʋ pʋ ‑na 'hʋɩ a 'kɩbɩa ‑bɩ 'wan, 'ɛ ‑hi 'ʋ ‑na pɛpɛ ‑bʋ mu 'lɩ na ‑mʋ', ‑ɛ 'yɛ nɩ jre yruyru 'nyɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Tete* ‑bɩ, Nyɩsʋa ‑nyi la ‑aan 'baɩnʋ, ɛ nɔ‑ mɔ: Nyiblo 'bʋ tɛ 'a nʋgba bʋ, ɛ kɔ bʋ ‑nyi nʋgba a 'mʋ 'crɩɛn, ‑ɛ hlɛ꞊ɛ, ‑ɛ mɔ, ɛ tɛ꞊ɛ bʋ. ");
INSERT INTO ktj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kɛɛ, 'mɔ ‑bɩ, kɛ‑ 'n pɩ: 'A ‑nɛ nyiblo 'bʋ tɛ 'a nʋgba bʋ, 'bʋ 'yɩ 'a ‑wlawlɩdɛ a ‑tɩ 'pa‑, nʋgba a 'mʋ 'bʋ ‑mu, 'bʋ kɔ nyɩbɩʋ ‑bɩ, 'a yɩ‑hɛnyɩbɩʋ ‑mʋ', ɛ nɔ‑ pʋ nʋgba a 'mʋ ‑wlawlɩdɛ kɩ. 'Ya 'ʋ 'lu de, nʋgba a 'mʋ, ɛ tɛ bʋ, nyiblo ‑di꞊e kɔ, nyiblo a 'mʋ, ɛ ni ‑wlawlɩ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«A yi꞊e nɩ, ‑ɛ mɔ, tete ‑bɩ, Nyɩsʋa ‑nyi la ‑aan 'baɩnʋ, ɛ nɔ‑ mɔ: 'Bʋ mɔ, ꞊nɩ 'sʋʋ Nyɩsʋa, ‑ɛ mɔ: Dɛ ‑bʋ, 'n di꞊e 'nɩ nu, ꞊yɩ 'kɩ yɩ ‑blɛɛ ‑nɩ de, ‑bʋ pʋ lɛ, ‑ɛ mɔ, ꞊nɩ ‑nu꞊o lɩ꞊ɩ. Dɛ ‑bʋ, ‑kɔtɩ ‑nɩ 'sʋʋ Nyɩsʋa, ‑ɛ mɔ, ‑di꞊e 'nɩ nu, nu꞊o. ");
INSERT INTO ktj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kɛɛ, 'mɔ ‑bɩ, kɛ‑ 'n pɩ: A 'yɩ yɩ ‑blɛɛ ‑nɩ ba 'sʋʋ ‑nɩ. A 'yɩ yɩ ‑blɛɛ ‑nɩ ba 'sʋʋ yakɔ, ‑ɛ nu꞊o, ɛ nɔ‑ mɔ Nyɩsʋa a kɩbʋnɩdɛ. ");
INSERT INTO ktj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","A 'nɩ 'sʋʋ 'lɩ ‑tʋtʋ, ‑ɛ nu꞊o, ɛ nɔ‑ mɔ Nyɩsʋa a bʋɩkɩblɛ꞊tudɛ. A 'nɩ 'sʋʋ 'lɩ Jrusrɛdɩɔ, ‑ɛ nu꞊o, ɛ nɔ‑ mɔ Nyɩsʋa a 'dɩɔ. ");
INSERT INTO ktj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","꞊Nɩ 'sʋʋ 'lɩ ‑na 'lu, ‑ɛ nu꞊o, ꞊yɩ 'klɩ ꞊dʋ ‑kɔ, 'kɩ ‑bʋ nu꞊o, ‑na 'lu‑pupui a 'yɛ nɩ ‑do bʋ 'plɛ, ‑hʋʋ' bʋ jre. ");
INSERT INTO ktj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kɛ‑ ba pʋ: Iin 'bʋ mɔ iin, ɛ kɔ, ba pʋ: 'Ʋʋn‑, 'bʋ mɔ 'ʋʋn‑. ꞊Nɩ ‑maa 'ʋ꞊ʋ 'sʋʋlɛ 'lu, ɛ mɔ yɩnyredɛ ꞊nɩɔ. 'Kɩ ɛ ‑hʋɛn 'lɩ 'kuo ‑hʋɩn* a nyiblo gbagbʋ ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«A yi꞊e nɩ, ‑ɛ mɔ, tete ‑bɩ, Nyɩsʋa ‑nyi la ‑aan 'baɩnʋ, ɛ nɔ‑ mɔ: Nyiblo 'bʋ wa 'a 'bɩ a 'yie, ʋ kɔ bʋ wa a 'yie ‑wɛ. Nyiblo 'bʋ ‑yraa nɛ 'a 'bɩ 'nyɛ wlɔn, ʋ kɔ bʋ ‑yraa ꞊nɛ 'nyɛ wlɔn ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kɛɛ, 'mɔ ‑bɩ, kɛ‑ 'n pɩ: Nyiblo 'bʋ nu 'a mʋ yɩnyredɛ ‑mɔ, a 'nɩ 'wɩɩ 'lɩ 'aan dɩɔnʋ klɛ. Nyiblo 'bʋ pʋ 'lɩ 'ŋma ‑na diidɛnʋa 'kwli, ‑ha꞊a mɛ lɛ, bʋ pʋ 'lɩ 'a dɛ ‑bɩ kamlanʋa 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nyiblo 'bʋ ‑hʋɛ bʋ yɛɛ ‑mʋ ‑tɩ, 'kɩ 'lɩ ‑batipʋnyɔ yɩ, 'bʋ yɩ ‑na wlawlʋ nɩ ‑hʋɛ, ‑ha꞊a mɛ lɛ, bʋ gba ‑na kʋɛtɩ. ");
INSERT INTO ktj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nyiblo 'bʋ nɩ 'ʋ ‑mʋ ke', 'kɩ ‑bʋ 'ble 'a blɔ, 'kɩ 'lɩ ‑kiloyɛ nɩ ‑do 'yri, ‑ɛ ‑bɩ pʋ 'ʋ 'hʋɛn a ‑kiloyɛ. ");
INSERT INTO ktj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nyiblo 'bʋ yɩ ‑mʋ dɛ nɩ ‑hʋɛ, ‑ɛ ‑bɩ ‑ha 'lɩ꞊ɩ 'lɩ, ‑bʋ ‑nyi ꞊nɛ꞊ɛ. Nyiblo 'bʋ ‑hʋɛ bʋ 'trɔsɩ ‑mʋ dɛ, ꞊nɩ 'hɩaa 'lɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«A yi꞊e nɩ, ‑ɛ mɔ, tete ‑bɩ, Nyɩsʋa ‑nyi la ‑aan 'baɩnʋ, ɛ nɔ‑ mɔ: Nʋɛ ‑na 'bɩhɩan, kɛɛ, yraa nyiblo ‑bʋ, ‑ɛ yraa ‑mʋ. ");
INSERT INTO ktj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kɛɛ, 'mɔ ‑bɩ, kɛ‑ 'n pɩ: Ba nʋɛ nɛ 'aan yraanyibli, kɔ, ba da Nyɩsʋa, 'kɩ 'ʋ nyibli ‑mʋ', ‑ʋ ꞊tui 'a mʋ ꞊hɩʋɛn a ‑ta', ");
INSERT INTO ktj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","‑ɛ di꞊e nu, 'aan 'Baɩ Nyɩsʋa, ‑ɛ nɩ 'lɩ yakɔ 'kwli, a 'mʋ 'a 'yonʋ ‑hɛ, ‑ɛ nu꞊o, nyibli ‑bʋ, ‑ʋ kɔ 'crɛ, kɔ 'waa dɛ ‑bʋ, ‑ʋ mɔ ꞊haannyibli, Nyɩsʋa ni꞊e nɩ, 'yrʋ 'ɛ yɩ hʋɛn, 'kɩ 'ʋ ꞊nʋ ‑mɔ'. Nyibli ‑bʋ, ‑ʋ 'sii 'ʋ yɩ, kɔ nyibli ‑bʋ, ‑ʋ 'yɩ 'ʋ yɩ 'sii ‑nɩ, Nyɩsʋa ni꞊e nɩ, 'nu 'ɛ yɩ di, 'kɩ 'ʋ nyibli a pɛpɛ a 'mʋ a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","'Bʋ mɔ, 'ba nʋɛ nyibli nɩ ‑do ‑mʋ', ‑ʋ nʋɛ nɛ 'a mʋ, a 'nɩ 'yee 'lɩ꞊ɩ, ‑ɛ mɔ, 'a ‑tɩ Nyɩsʋa di nu 'a mʋ ꞊haandɛ ‑mɔ. Dɛ nɩ ‑do a 'mʋ, 'crɛkɔnyibli ni꞊e nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","'Bʋ mɔ, 'ba yɩ 'aan 'dɩayɩnʋ nɩ ‑do ꞊haandɛ ‑mɔ nɩ ni, 'aan ꞊wlɩ 'nɩ 'yee 'lɩ꞊ɩ, ‑ɛ mɔ, a ni dɛ gbagbʋ. Dɛ a 'mʋ, nyibli ‑mʋ', ‑ʋ 'yɩ Nyɩsʋa ‑yi, ʋ ni꞊e nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ba 'sii 'ʋ yɩ, ꞊wɩ yɩ ‑tɛ 'aan 'Baɩ Nyɩsʋa ‑nɩ 'lɩ yakɔ 'kwli, ɛ ‑nu, 'ɛ 'sii 'ʋ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«'Bʋ mɔ, 'ba yɩ ꞊hɩʋɛnnyiblo ꞊haandɛ ‑mɔ nɩ ni, a 'nɩ 'nuo 'lɩ꞊ɩ, 'kɩ 'ʋ nyibli ye', ‑ɛ di꞊e nu, ʋ 'mʋ 'a mʋ 'nyrɛ lɛ pʋ a ‑tɩ. 'Bʋ mɔ, 'ba yɩ ꞊haandɛ a 'mʋ 'a nunuo lɛ nɩ ni, 'aan 'Baɩ Nyɩsʋa, ‑ɛ nɩ 'lɩ yɔ', ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑nyi 'a mʋ 'a ‑tɩ a 'wio. ");
INSERT INTO ktj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","'Bʋ mʋ, ꞊nɩ yɩ ꞊hɩʋɛnnyiblo dɛ nɩ ‑nyi, 'kɩ 'ʋ 'a ‑hɛɛlɛ a ‑ta', ꞊nɩ 'lee 'lɩ nyibli a pɛpɛ lɛ, ꞊wɩ yɩ nyibli ‑mʋ', ‑ʋ nɛɛ 'li nɩ 'hʋɛn, ‑tɛ ʋ ni 'a nunuo. Nyibli a 'mʋ, 'bʋ nu ꞊hɩʋɛnnyiblo ꞊haandɛ ‑mɔ, ʋ kɔ bʋ na 'a ‑tɩ ‑mɔ lɛ, 'kɩ 'lɩ Nyɩsʋa a 'kayo blɛ, kɔ 'bʋ yɩ lɛ nɩ nɛ. Ʋ ni꞊e nɩ, ‑ɛ di꞊e nu, nyibli 'mʋ ꞊nʋ 'nyrɛ lɛ pʋ. 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, nyiblidʋ a 'mʋ, Nyɩsʋa 'nɩ ‑nyi꞊e lɩ ꞊nʋ 'a 'wio nɩ, ‑ɛ nu꞊o, ‑tonyibli ‑wɛ 'waa 'wio a bʋpʋpʋʋ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","‑Mɔ ‑bɩ, 'bʋ mɔ, ꞊nɩ yɩ ꞊hɩʋɛnnyiblo dɛ nɩ ‑nyi, nu꞊o, nyiblo ꞊dʋ 'nɩ 'wɩɩn 'lɩ, mɔ 'ye ꞊bɩɩ ‑na ꞊wlʋ a nɩnatumu a 'mumu, ɛ 'nɩ 'wɩɩn 'lɩ, ");
INSERT INTO ktj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","‑ɛ di꞊e nu, ‑hɛɛlɛ a 'mʋ, 'a ‑tɩ 'mʋ ‑hli. ꞊Nɩ yɩ naalɛ nɩ ni, ‑ɛ ‑bɩ ‑na 'Baɩ Nyɩsʋa, ‑ɛ yɩ 'a ‑nɛ ‑huhlidɛ ꞊dʋ 'ye, ɛ nɔ‑ di ‑mʋ 'a 'wio ‑nyi.» ");
INSERT INTO ktj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«'Bʋ mɔ, 'ba yɩ Nyɩsʋa nɩ dɛ, a 'nɩ 'daa 'lɩ꞊ɩ, ꞊wɩ yɩ ‑tɛ nyibli ‑mʋ', ‑ʋ nɛɛ 'li nɩ 'hʋɛn, ʋ ni 'a dɩda. Nyibli a 'mʋ, 'bʋ yɩ꞊ɩ nɩ dɛ, ʋ nʋɛ bʋ nyra blɛ, 'kɩ 'lɩ Nyɩsʋa a 'kayo blɛ, ‑tɛ nyibli ‑hʋʋ 'ʋ. 'Bʋ yɩ lɛ nɩ ni, ɛ 'wɩ yɩ, ʋ ni꞊e nɩ, nyibli 'mʋ ꞊nʋ 'ye a ‑tɩ. 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, nyiblidʋ a 'mʋ, Nyɩsʋa 'nɩ ‑nyi꞊e lɩ ꞊nʋ 'a 'wio nɩ, ‑ɛ nu꞊o, ‑tonyibli ‑wɛ 'waa 'wio a bʋpʋpʋʋ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kɛɛ, ‑mɔ ‑bɩ, ꞊nɩ yɩ Nyɩsʋa a dɩda nɩ ‑hʋɛ, pa 'lɩ ‑na ‑gblo 'kwli, ‑bʋ ka 'ʋ 'maju 'ʋ. ꞊Nɩ ka 'kɩ 'ʋ 'maju 'ʋ, ‑ɛ ‑bɩ da ‑na 'Baɩ Nyɩsʋa, ‑ɛ nɩ 'ʋ ‑mʋ 'hʋɩ. ‑Ɛ ‑bɩ ‑na 'Baɩ Nyɩsʋa a 'mʋ, ‑ɛ yɩ 'a ‑nɛ ‑huhlidɛ ꞊dʋ, ‑ni 'ye, ɛ nɔ‑ di ‑mʋ 'a 'wio ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","'Bʋ mɔ, 'ba yɩ Nyɩsʋa nɩ dɛ, 'aan pʋpʋwin 'nɩ 'hʋʋ 'lɩ, ꞊wɩ yɩ ‑tɛ nyibli ‑mʋ', ‑ʋ 'yɩ Nyɩsʋa ‑yi, ʋ ni 'a dɩda. Ʋ nʋ‑ ‑mɔ ‑bɩ, ʋ wɛn 'nɩ, 'waa pʋpʋwin 'bʋ ‑hʋ, 'tɩ‑ Nyɩsʋa 'mʋ 'waa win 'wɩn. ");
INSERT INTO ktj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Dɛ a 'mʋ, ʋ ni, a 'nɩ 'nuo 'lɩ꞊ɩ, ‑kɔtɩ 'tɩ‑ a 'mʋ 'aan 'Baɩ Nyɩsʋa dɛ ‑hʋa mɔ mu, ɛ yi dɛ a 'mʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","‑Tɛ a di Nyɩsʋa a dɩda nu, ɛ nɔ‑ ‑bʋ: ‑Aan ‑nɛ 'Baɩ, ‑ɛ nɩ 'lɩ yɔ', nu꞊o, nyibli a pɛpɛ bʋ yi꞊e, ‑ɛ mɔ, ‑mɔ mɔ Nyɩsʋa. ");
INSERT INTO ktj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","‑Mɔ ‑bʋ kɔɔ nyibli win kɩ. ‑Na kɩwɛɛnlɛ, ɛ nɔ‑ ‑bʋ nue ‑nɩ, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, kɔ 'kɩ 'lɩ yakɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","‑Nyi kɛ ‑a mʋ ‑nyrɔwɔ ‑bʋ a dididɛ. ");
INSERT INTO ktj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Yɩnyre‑tɛblɩ ‑bʋ, ‑a ‑nu, ‑hru 'a ‑tɩ ‑mɔ, ꞊wɩ yɩ ‑tɛ ‑a ni, ꞊a ‑hrui yɩnyre‑tɛblɩ ‑mʋ', nyibli ni ‑a mʋ ‑mɔ a ‑tɩ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","꞊Nɩ 'hɔɔn 'ʋ 'kuo ‑hʋɩn a nyiblo gbagbʋ ‑mɔ', ɛ 'nɩ 'tɛɛ 'ʋ ‑a mʋ lɛ, ‑ɛ di꞊e nu, ‑a 'nɩ ꞊ha ‑tɩ 'wla, kɛɛ, ‑ha 'lɩ ‑a mʋ 'kuo ‑hʋɩn* a nyiblo gbagbʋ a 'klɩ bʋ, ‑ɛ nu꞊o, ‑mɔ blɛɛ yɩ ‑bʋ kɔɔ nyibli win kɩ, ɛ kɔ, ‑mɔ kɔ 'klɩ, kɔ ‑tɩ a 'yi'bʋbʋa, ‑tɛ ɛ tɛ yɩ bʋ. Kɛ‑ bʋ nɩ 'mʋ. Kɛ‑ ba nu Nyɩsʋa a dɩda. ");
INSERT INTO ktj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Yɩnyre‑tɛblɩ ‑mʋ', nyibli nu 'a mʋ ‑mɔ, 'bʋ mɔ, 'ba yɩ 'a ‑tɩ ‑mɔ nɩ ‑hrui, 'aan 'Baɩ Nyɩsʋa, ‑ɛ nɩ 'lɩ yɔ', ɛ di ‑hru 'aan ‑nɛ yɩnyre‑tɛblɩ, a ‑nu, 'a ‑tɩ ‑mɔ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kɛɛ, yɩnyre‑tɛblɩ ‑mʋ', nyibli nu 'a mʋ ‑mɔ, 'ba 'yɛ nɩ ‑hru 'a ‑tɩ ‑mɔ, ‑ɛ ‑bɩ 'aan 'Baɩ Nyɩsʋa 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑hru 'aan ‑nɛ yɩnyre‑tɛblɩ, a ‑nu a ‑tɩ ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«'Bʋ mɔ, 'ba yɩ nɩ ꞊ci, ('kɩ 'ʋ Nyɩsʋa a dɩda a ‑ta',) a 'nɩ 'cɩcɩɩ 'lɩ 'aan yigbaklɩ, ꞊wɩ yɩ ‑tɛ nyibli ‑mʋ', ‑ʋ nɛɛ 'li nɩ 'hʋɛn, ʋ ni ꞊cicie. Nyibli a 'mʋ, 'bʋ yɩ nɩ ꞊ci, ʋ kɔ bʋ ꞊tɩɔ 'ʋ 'waa yigbaklɩ 'ʋ, ‑ɛ di꞊e nu, nyibli a pɛpɛ 'mʋ꞊ʋ 'ye, ‑ɛ mɔ, ʋ yɩ 'nɩ ꞊ci. 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, nyiblidʋ a 'mʋ, Nyɩsʋa 'nɩ ‑nyi꞊e lɩ ꞊nʋ 'a 'wio nɩ, ‑ɛ nu꞊o, ‑tonyibli ‑wɛ 'waa 'wio a bʋpʋpʋʋ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kɛɛ, ‑mɔ ‑bɩ, 'bʋ mɔ, ꞊nɩ yɩ nɩ ꞊ci, yra yrɛ, ‑bʋ pʋ ‑na 'lu lɛ ‑tɛɛ, ");
INSERT INTO ktj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","‑ɛ di꞊e nu, nyibli 'nɩ ꞊ha꞊a 'ye, ‑ɛ mɔ, ‑yɩ 'nɩ ꞊ci. ꞊Nɩ yɩ꞊ɩ nɩ ni, ‑ɛ ‑bɩ ‑na 'Baɩ Nyɩsʋa nɩ ‑do ‑mʋ', ‑ɛ yɩ 'a ‑nɛ ‑huhlidɛ ꞊dʋ 'ye, ɛ nɔ‑ di ‑mʋ 'a 'wio ‑nyi.» ");
INSERT INTO ktj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«A 'nɩ 'kukue 'lɩ ‑pʋpa‑tɛblɩ lɛ, 'kɩ 'nɛ‑ ‑tʋtʋ ‑bʋ kɩ, ‑tɛ 'hlɔ kɔ ‑yrʋsʋ 'hʋɛn‑, ʋ nɩ 'nɛ‑, 'ʋ yɩ ‑tɛblɩ yrɛ nyre, kɔ, ‑tɛ 'yiyrinyibli yɩ 'nɛ‑ 'kayo ‑waa ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kɛɛ, ba 'kukue kʋkɔ‑tɛblɩ lɛ, 'kɩ 'lɩ yakɔ 'kwli, ‑tɛ 'hlɔ kɔ ‑yrʋsʋ 'hʋɛn‑, ʋ 'yɛ nɩ nyree 'lɩ ‑tɛblɩ yrɛ, kɔ, ‑tɛ 'yiyrinyibli 'yɛ nɩ waa 'lɩ 'kayo, ");
INSERT INTO ktj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","‑ɛ nu꞊o, ‑tɛ ‑na kʋkɔ‑tɛblɩ nɩ 'ʋ, 'kɩ ‑na ꞊wlʋ nɩ 'ʋ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«‑Tonyiblo a ꞊wlʋ, ɛ 'wɩ‑ 'a 'yii yɩ, ‑ɛ yɩ꞊ɩ ‑nyrɛ ‑nyi. ‑Na 'yii 'bʋ nu ‑tɛɛ, ‑ɛ ‑bɩ ‑yrui lɛ ‑tɛɛ. ");
INSERT INTO ktj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kɛɛ, ‑na 'yii 'bʋ yɩ nɩ klɛ, ‑ɛ ‑bɩ 'kɩ ‑nɩ 'lɩ halɔ 'nyɩ. ‑Ɛ ‑bɩ ‑nyrɛ ‑mʋ', ‑ɛ nɩ 'lɩ ‑mʋ 'hʋɩ, 'bʋ mɔ halɔ, ‑ɛ ‑bɩ halɔ a 'mʋ, ɛ kɔ bʋ jre dɩakɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nu 'masɛpʋ nɩ 'hʋɛn a ‑kʋan, ti nɩ ‑do a ti 'yri. Ɛ kɔ bʋ yraa nyiblo nɩ ‑do, ɛ 'mʋ 'a nyiblo ‑bɩ ‑nʋɛ ‑nɩ. Ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ti nɩ ‑do a ti 'yri, Nyɩsʋa bʋ kɔɔ nɛ 'a mʋ win kɩ, 'tɩ‑ 'wliyɛ bʋ di 'a mʋ win kɩ ‑kɔɔ ‑nɩ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Ɛ nɔ‑ nu꞊o, 'nɩ yɩ 'a mʋ ‑lee ‑nɩ: Dɛ ‑bʋ, a di di, kɔ, dɛ ‑bʋ, a di 'na, kɔ, wlawlɩ ‑bʋ, a di pʋ, ‑tɛblɩ a 'mʋ, 'a ‑tɩ, a 'nɩ 'hriti 'lɩ ‑nɩ. ‑Hʋnhlʋn ‑bʋ, a pɩ, ɛ mɔ dɛ gbagbʋ ꞊nɩɔ, 'ɛ ‑hi 'ʋ dididɛ 'ʋ, kɔ, 'aan ‑plahʋɩ mɔ dɛ gbagbʋ ꞊nɩɔ, 'ɛ ‑hi 'ʋ 'hʋɩlɛpʋ‑tɛblɩ 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ba ta 'ʋ nʋblɩ ‑mɔ lɛ. Ʋ 'nɩ 'dɔ꞊ɔ lɩ, kɔ, ʋ 'nɩ 'cɛ꞊ɛ lɩ ꞊dedede, kɔ, ʋ 'nɩ ‑pʋ꞊ʋ lɩ ꞊dedede 'kalɩ'. Kɛɛ, 'aan 'Baɩ Nyɩsʋa, ‑ɛ nɩ 'lɩ yɔ', ɛ nɔ‑ yɩ ꞊nʋ dididɛ ‑nyi. Kɛɛ, 'a mʋ ‑mɔ ‑bɩ, Nyɩsʋa nʋɛ nɛ 'a mʋ nɩ, 'ɛ ‑hi 'ʋ nʋblɩ 'ʋ. 'A ‑tɩ, ‑tɛ ɛ ni, 'ɛ yɩ nʋblɩ dididɛ ‑nyi, kɛ‑ ɛ di nu, ɛ 'mʋ 'a mʋ dididɛ ‑nyi ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ɛ 'yɩ nyiblo ꞊dʋ ‑kɔ, 'kɩ 'lɩ 'a mʋ 'nyɩ, 'a hritilɛ a ‑tɩ, ‑bʋ kɔ 'klɩ, 'kɩ ‑bʋ pʋʋ nɛ 'a ‑nyrɔwɩ a dɛ gbe kɩ, 'kɩ 'nɛ‑ 'klɔ ‑bʋ kɩ. ");
INSERT INTO ktj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Dɛ‑ kɔ hritilɛ a yɩ ‑hriti ‑nɩ 'lɩ? ꞊Bɩ 'hʋɩlɛpʋ‑tɛblɩ a ‑tɩ? Ba 'ye ‑piti, ‑tɛ 'waa ‑pui ni ꞊gɩga, 'tɩ‑, ‑tɛ ɛ nu yɩnɩnɔ. ‑Piti a ‑pui a 'mʋ, ɛ 'wɩ‑ ‑tonyiblo a wlawlɩ yɩ. Kɛɛ, ‑piti a 'mʋ, ɛ 'nɩ ‑nu꞊o lɩ ‑kʋan, kɔ, ɛ 'nɩ 'gbla꞊a wlawlɩ, ɛ 'nɩ ‑pʋ꞊ʋ lɩ꞊ɩ, kɛɛ, ɛ nɔ yɩ. ");
INSERT INTO ktj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","꞊Bʋ lee nɛ 'a mʋ: Bodɩɔ Salomɔ, ɛ mɔ ꞊han‑tɩ, 'ɛ kɔ la dɛ, kɛɛ, ‑tɛ ‑piti a ‑pui nu yɩnɩnɔ, Salomɔ a 'mʋ, ɛ 'yɩ la 'a wlawlʋ ‑kɔ, ‑bʋ nu la yɩnɩnɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","‑Piti ‑bʋ, ʋ di ‑hʋan ‑ci, 'tɩ‑ ʋ di ‑hʋan 'tɔ pʋ, 'bʋ mɔ, Nyɩsʋa 'bʋ kɔ bʋ nu꞊o, 'a ‑pui bʋ nɔ yɩ, ꞊bɩ 'a mʋ ‑bʋ, ɛ nʋɛ ‑nɩ, 'a mʋ ɛ 'yɛ nɩ di 'hʋɩlɛpʋ‑tɛblɩ nɩ ‑nyi, 'a mʋ ‑bʋ, ‑ʋ 'yɩ Nyɩsʋa ꞊wlʋ yɩ ‑kuo ‑nɩ ‑tɛɛ? ");
INSERT INTO ktj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","'A ‑tɩ, a 'nɩ 'hriti 'lɩ ‑nɩ, dɛ ‑bʋ, a di di, kɔ, dɛ ‑bʋ, a di 'na, kɔ, dɛ ‑bʋ, a di 'hʋɩ lɛ pʋ a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nyibli ‑mʋ', ‑ʋ 'yɩ Nyɩsʋa ‑yi, ʋ nʋ‑ yɩ ‑tɛblɩdʋ a 'mʋ 'lu ‑mɔ lɛ ‑hie 'a ‑nɛ ti. 'Aan 'Baɩ Nyɩsʋa, ‑ɛ nɩ 'lɩ yɔ', ɛ yi 'aan ‑hʋhʋa‑tɛblɩ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Dɛ ‑mɔ yɩ‑hɛdɛ, a blɛɛ yɩ ba ‑hie 'lu ‑mɔ lɛ 'a ‑nɛ ti, ɛ nɔ‑ mɔ Nyɩsʋa bʋ kɔɔ nɛ 'a mʋ win kɩ, kɔ 'aan 'klɔ bʋ 'sii 'ʋ yɩ, 'kɩ 'ʋ Nyɩsʋa ye', ɛ 'mʋ 'a mʋ 'aan ‑hʋhʋa‑tɛblɩ a 'mʋ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","'Kla 'nɩ 'yaa 'lɩ 'a mʋ ‑wliye, 'kɩ 'ʋ ‑ŋɩŋa a ‑nyrɔwɔ a ‑ta', ‑ɛ nu꞊o, Nyɩsʋa yi ‑nyrɔwɔ a 'mʋ a 'kla‑wliye'yɩya nɩ. Ɛ di ‑hʋan 'a mʋ 'nɩ ‑hɛɛ ‑nɩ. ‑Tɛ ɛ ni, 'ɛ yɩ kɛ 'a mʋ ‑hɛɛ ‑nɩ, kɩkɛ a ‑nyrɔwɔ ‑bʋ 'kwli, kɛ‑ ɛ di ‑hʋan nu, ɛ 'mʋ ‑hʋan 'a mʋ ‑hɛɛ ‑nɩ, 'kɩ 'lɩ ‑ŋɩŋa a ‑nyrɔwɔ a 'mʋ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«A 'nɩ 'yɛɛ 'lɩ 'aan 'bio ‑tɩ, ‑ɛ di꞊e nu, Nyɩsʋa 'nɩ ꞊ha 'a mʋ ‑tɩ ‑yɛɛ ‑nɩ, ");
INSERT INTO ktj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","‑ɛ nu꞊o, ‑tɛ a ni 'aan 'bio a ‑tɩ a yɛɛlɛ, kɛ‑ Nyɩsʋa di 'aan ‑tɩ a yɛɛlɛ nu ‑wɛ, kɔ, ‑tɛ a di 'aan 'bio a 'yiye nu, kɛ‑ Nyɩsʋa di 'aan 'yiye nu ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Dɛ‑ kɔ ‑tɩ, ‑na 'bɩhɩan a kʋɛtɩyɛ ‑bʋ, ‑ɛ nɩ 'lɩ꞊ɩ 'yi, ꞊nɩ yi 'a 'yelɛ, 'tɩ‑ ‑nɛ tugbɛkʋtɩɔ ‑mʋ', ‑ɛ pɛ 'lɩ ‑mʋ 'yi bʋ, ꞊nɩ 'yɛ nɩ 'ye꞊e 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","꞊Yɩ yɩ ‑blɛɛ ‑nɩ ‑bʋ lee ‑na 'bɩhɩan, ‑ɛ mɔ: Nu gbe, ꞊bʋ ‑ha 'lɩ ‑mʋ kʋɛtɩyɛ 'yi, ‑mɔ ‑kɔ 'yi tugbɛkʋtɩɔ pɛ 'lɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","‑Mɔ ‑mʋ', ‑ɛ nɛɛ 'li nɩ 'hʋɛn, yɩ‑hɛdɛ, ‑kɔ ‑bʋ nu, ɛ nɔ‑ mɔ ‑bʋ ‑ha 'lɩ ‑nɛ tugbɛkʋtɩɔ 'yi, ꞊mʋ lɛ yru ‑tɛɛ, 'tɩ‑ ꞊mʋ 'lɩ kʋɛtɩyɛ ‑na 'bɩhɩan 'yi ‑ha. ");
INSERT INTO ktj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Dɛ ‑bʋ, Nyɩsʋa ‑kɔ, a 'nɩ 'nyie 'lɩ꞊ɩ nyibli ‑bʋ, ‑ʋ 'yɩ 'ʋ yɩ 'sii ‑nɩ, ‑ʋ 'wɩ bʋɩcɩ yɩ, ɛ kɔ, dɛ ‑mʋ', ‑ɛ kɔ ‑kʋan, 'kɩ 'ʋ 'a mʋ ‑mɔ, a 'nɩ 'nyie 'lɩ꞊ɩ nyibli ‑mʋ', ‑ʋ 'yɩ ‑kʋan ‑mʋ', ɛ ‑kɔ ‑yi, ‑ʋ 'wɩ ‑gbo yɩ, ‑ɛ nu꞊o, 'ba ‑nyi ꞊nʋ꞊ʋ, ʋ di na꞊a klɛ, 'tɩ‑ ʋ 'mʋ ‑mɔ ꞊hɩan, ʋ 'mʋ 'a mʋ bʋ ‑wɛ mɔ di.» ");
INSERT INTO ktj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«'Ba yɩ dɛ nɩ ‑hʋɛ, ba ‑hʋa꞊a Nyɩsʋa, ɛ 'mʋ 'a mɔ꞊ɔ ‑nyi. 'Ba yɩ dɛ nɩ ‑hʋɛ, ba ꞊mʋɔ꞊ɔ lɛ, a di꞊e 'nɩ 'ye. 'Ba yɩ꞊ɩ nɩ ‑hʋɛ, bʋ paa nɛ 'a mʋ 'kayu bʋ, ba bi gbɔgbɔ, ʋ 'mʋ 'a mʋ ‑lee ‑nɩ: Ba di pa. ");
INSERT INTO ktj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, 'a ‑nɛ nyiblo 'bʋ ‑hʋa Nyɩsʋa dɛ, ɛ di ꞊nɛ꞊ɛ 'nɩ ‑nyi. Nyiblo 'bʋ yɩ dɛ lɛ nɩ ꞊mʋɛ, ɛ di꞊e 'nɩ 'ye. Nyiblo 'bʋ nyra 'ʋ ꞊hʋan.yɩ' bʋ, 'bʋ bi gbɔgbɔ, ʋ di꞊e 'nɩ ‑lee nɩ, bʋ pa. ");
INSERT INTO ktj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","‑Mɔ ‑bʋ, ‑ɛ mɔ 'baɩ, ‑na 'yu 'bʋ yɩ ‑mʋ 'flɔɔ nɩ ‑hʋɛ, ꞊bɩ ‑di ‑nyi꞊e 'hɩɔ? ");
INSERT INTO ktj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","‑Ʋ'ʋ‑, 'bʋ yɩ ‑mʋ ‑hrin.yɛ nɩ ‑hʋɛ, ꞊bɩ ‑di ‑nyi꞊e hre? ");
INSERT INTO ktj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","'Ɛ mɔ ꞊han‑tɩ, 'a mʋ ‑tonyibli, 'kɩ a 'yɩ ꞊haannyibli 'pa‑, kɛɛ, a yi ꞊haan‑tɛblɩ a lɛ'jralɛ, 'a yɩ꞊ɩ 'aan 'yonʋ ‑nyi. 'Bʋ mɔ, 'bʋ nɩ 'mʋ lɛ, 'kɩ 'ʋ 'a mʋ ‑mɔ, ‑ʋ kɔ ꞊wlɩ ‑nyre yɩ, ‑ɛ ‑bɩ 'aan 'Baɩ Nyɩsʋa, ‑ɛ nɩ 'lɩ yakɔ 'kwli, ‑ɛ kɔ ꞊wlʋ ‑nɔ yɩ, nyibli 'bʋ ‑hʋa꞊a ꞊haan‑tɛblɩ, ɛ di ꞊nʋ꞊ʋ 'nɩ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","‑Tɛblɩ a pɛpɛ, a ‑hʋɛ nyibli ‑bɩ bʋ nu 'a mʋ ‑mɔ, 'aan 'mumu, ba nu ꞊nʋ꞊ʋ ‑mɔ ‑wɛ. Dɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ Nyɩsʋa a tete tʋɛ ‑nɩ, ɛ kɔ Nyɩsʋa a winwlɔn‑hanyʋ* 'hʋɛn‑.» ");
INSERT INTO ktj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Paalɛ ‑mʋ', ‑ɛ gbɛ 'lɩ 'a mʋ Nyɩsʋa a 'klɔ yrayrʋ 'kwli, ɛ 'cɩmɩ 'yri lɛ. 'A ‑tɩ, 'ba ‑hʋɛ ba pa 'lɩ Nyɩsʋa a 'klɔ yrayrʋ a 'mʋ 'kwli, ‑ɛ ‑bɩ paalɛ 'cɩmɩɛ ‑mʋ', ɛ nɔ‑ ba naa 'ʋ 'yri, ‑ɛ nu꞊o, paalɛ kɔ 'hru ‑mʋ' 'hʋɛn‑, ‑ʋ gbɛ 'lɩ 'a mʋ 'waanlɛ', ʋ 'bʋa 'yri lɛ, 'tɩ‑ 'waa wlɔnnaalɛ 'yɩ 'mʋ ‑kla, ɛ kɔ, nyibli ‑mʋ', ‑ʋ nɛ꞊ɛ, ʋ ‑hʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kɛɛ, paalɛ kɔ 'hru ‑mʋ', ‑ʋ gbɛ 'lɩ 'a mʋ Nyɩsʋa a 'klɔ yrayrʋ 'kwli, ʋ 'cɩmɩ wlɔn lɛ, 'tɩ‑ 'waa wlɔnnaalɛ kla 'mʋ nɩ, ɛ kɔ, nyibli ‑mʋ', ‑ʋ nɛ꞊ɛ, ʋ 'yɩ ‑hʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Ba ‑gbɛɛ nɛ 'aan dɩɔnʋ, 'kɩ 'ʋ hɩtɔɔnyʋ a ‑ta'. 'Bʋ mɔ, 'ba yɩ ꞊nʋ nɩ 'ye, kɛ‑ a di pʋ, ʋ 'nɩ ‑nu꞊o dɛ ‑hʋan ꞊dʋ. Kɛɛ, ʋ nʋ‑ yɩ 'kɩ nyibli bʋ ‑wɛ. Ʋ 'wɩ ‑jio yɩ, ‑ʋ pʋ 'blakʋɛ klɛ. ");
INSERT INTO ktj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","'Waa nunuŋmlɩ, ʋ ni, nɔ‑ di꞊e nu, a 'mʋ ꞊nʋ yru. ꞊Bʋ pʋ꞊ʋ tugbɛkuo a dɛ yɩ. Nyiblo 'nɩ ‑ha꞊a lɩ ‑gbɔgbʋyɔ, 'kɩ 'ʋ hɩapʋtugbɛ 'yri. Mɔ, nyiblo 'nɩ ‑ha꞊a lɩ bubuokui, 'kɩ 'lɩ ‑jʋ yra. ");
INSERT INTO ktj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tugbɛ ‑mʋ', ‑ɛ yɩ ꞊haan'nie ‑jri, ɛ tʋɩ ꞊haan'kui. Kɛɛ, tugbɛ ‑mʋ', ‑ɛ 'yɛ nɩ ‑jri ꞊haan'nie, ɛ 'nɩ ‑tʋ꞊ʋ lɩ ꞊haan'kui. ");
INSERT INTO ktj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tugbɛ ‑mʋ', ‑ɛ yɩ ꞊haan'nie ‑jri, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ tʋ 'kui ‑hʋɩn, Mɔ, tugbɛ ‑mʋ', ‑ɛ 'yɛ nɩ ‑jri ꞊haan'nie, ɛ 'yɩ 'lɩ꞊ɩ ‑wɛ, bʋ tʋ ꞊haan'kui. ");
INSERT INTO ktj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","'A ‑nɛ tugbɛ ꞊dʋ, ‑ɛ 'yɛ nɩ ‑hʋa ‑bʋ tʋ ꞊haan'kui, ʋ yɩ꞊ɩ 'nɩ 'bɛ, 'ʋ pɩ꞊ɩ 'tɔ. ");
INSERT INTO ktj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","'A ‑tɩ, hɩtɔɔnyʋ a nunuŋmlɩ, ʋ ni, ʋ nʋ‑ a di 'ye, a 'mʋ ꞊nʋ yru.» ");
INSERT INTO ktj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Nyibli ‑mʋ', ‑ʋ dɛɛ 'mʋ Kʋkɔnyɔ 'a ‑nɛ ti, ɛ 'yɩ 'waa pɛpɛ 'pa‑, ʋ 'nɩ ‑pa꞊a 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli nɩ. Kɛɛ, nyiblo ‑bʋ, ‑ɛ di dɛ ‑mʋ' nu, 'na 'Baɩ Nyɩsʋa ‑nɩ 'lɩ yakɔ 'kwli, ɛ ‑hʋɛ, ɛ nɔ‑ di 'lɩ pa. ");
INSERT INTO ktj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","‑Nyrɔwɔ ‑mʋ' ‑kɔ 'kwli, 'n di 'ʋ nyibli ‑bati lɛ ‑pʋʋ ‑nɩ, kɛ‑ nyibli ‑hʋɔhʋɩ di 'mʋ yɩ pʋ: Kʋkɔnyɔ o, 'kɩ 'lɩ ‑na 'nyrɛ 'kwli, ‑a hla 'lɩ Nyɩsʋa a ‑tɩ, 'kɩ 'lɩ ‑na 'nyrɛ 'kwli, ꞊a bla 'kuo ‑hʋɩn* lɛ, ‑ʋ nɩ la 'ʋ nyibli ke', 'kɩ 'lɩ ‑na 'nyrɛ nɩ ‑do a 'mʋ 'kwli, ꞊a nu ꞊wlɩlɛkɛɛ‑tɛblɩ ‑hʋɔhʋɩ. ");
INSERT INTO ktj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","‑Ɛ ‑bɩ kɛ‑ 'n di pʋ, 'mʋ ꞊nʋ klɛ ‑hɩhɩa ‑nɩ, ‑ɛ mɔ: 'N 'yɩ ‑hʋan 'a mʋ nɩ yi. Ba hlɔɔ 'mʋ ‑mɔ lɛ, 'a mʋ ‑mʋ', ‑ʋ 'yɛ nɩ nu dɛ ‑mʋ', Nyɩsʋa ‑hʋɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«'A ‑tɩ o, 'a ‑nɛ nyiblo, 'bʋ nɩ 'ʋ, ‑tɩ ‑bʋ, 'n hla wɛn, 'bʋ yɩ꞊ɩ nʋa yɩ bʋ nɩ pɩ, 'tɩ‑ 'bʋ yɩ꞊ɩ nɩ ni, ‑ɛ ‑bɩ ɛ 'wɩ‑ ꞊tɔkɔnyɔ ‑mʋ' yɩ, ‑ɛ pʋ 'a 'kayu, 'kɩ 'ʋ 'hɩɔ 'pa kɩ, ‑ɛ di꞊e nu, ɛ 'mʋ bʋ ku ‑tɛɛ. ");
INSERT INTO ktj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","‑Tɛ ɛ pʋ 'kɩ 'kayu a 'mʋ, ‑ɛ ‑bɩ 'nu di nɩ, 'nie 'ɛ 'yi, pepe 'ɛ ‑hi, 'ʋ ‑wɔn 'kayu a 'mʋ yɩ, kɛɛ, ɛ 'yɩ 'wlɛ, ‑tɛ ɛ pʋʋ 'ʋ꞊ʋ 'hɩɔ kɩ ‑a tɩ. ");
INSERT INTO ktj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kɛɛ, nyiblo ‑bʋ, ‑tɩ ‑bʋ, 'n hla wɛn, ‑ɛ di꞊e nʋa yɩ bʋ pʋ, 'tɩ‑ ‑ɛ 'yɛ nɩ di꞊e nɩ nu, ɛ 'wɩ nyiblo ‑mʋ' yɩ, ‑ɛ 'yɩ ꞊tɔ ‑kɔ, ‑ɛ pʋ 'a 'kayu 'kɩ 'ʋ 'pʋwɔn kɩ. ");
INSERT INTO ktj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","‑Tɛ ɛ ‑wɛ 'kɩ 'a pʋpʋʋ ‑mɔ, ‑ɛ ‑bɩ 'nu di nɩ, 'nie 'ɛ 'yi, pepe 'ɛ ‑hi, 'ʋ ‑wɔn 'kayu a 'mʋ yɩ. Ɛ nɔ‑ mɔ 'kayu a 'mʋ bʋ 'wlɛ, bʋ nyre yɩ pɛpɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","'Tɩ‑ ‑Yusu 'mʋ tɔɔlɛ a 'mʋ 'lu ‑yra mɔ mu, ‑tɛ ‑mʋ', ɛ nu tɔɔlɛ a 'mʋ, nyibli a pɛpɛ, ‑ʋ nɩ 'ʋ, ɛ maa ꞊nʋ wlɔn lɛ, ");
INSERT INTO ktj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","‑ɛ nu꞊o, ‑tɛ Nyɩsʋa a tetetɔɔnyʋ ni nyibli a tɔɔlɛ, ɛ 'nɩ ‑nu꞊o tɔɔlɛ lɛ, kɛɛ, 'kɩ 'lɩ Nyɩsʋa a 'klɩ 'kwli, 'kɩ ɛ tʋɛ 'lɩ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu ꞊tɩ dʋgba, nyibli a ꞊ju, ʋ nʋ‑ yɩ꞊ɩ ꞊wien lɛ kʋɛ. ");
INSERT INTO ktj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Bʋ yɩ 'kɩ 'lɩ nɩ di, ‑ɛ ‑bɩ ꞊hrannunyɔ ꞊dʋ, ɛ nɔ‑ mu 'ʋ꞊ʋ ye', 'ɛ bla꞊a kwlɩ yɩ, 'tɩ‑ 'ɛ pɩ lɛ: «Kʋkɔnyɔ o, 'n nyaa ‑mʋ lɛ, nu꞊o, 'na 'kʋɛ bʋ ‑wɛ,» ");
INSERT INTO ktj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ɛ nɔ‑ mɔ ‑Yusu bʋ ‑hrɛn꞊ɛ lɛ, 'tɩ‑ 'ɛ lee ꞊nɛ, ‑ɛ mɔ: «'N ‑hʋɛ꞊ɛ nɩ, ‑na 'kʋɛ bʋ ‑wɛ.» Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ 'a 'kʋɛ ‑wɛ nɩ, ");
INSERT INTO ktj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","‑Yusu 'ɛ lee ꞊nɛ, ɛ wɛn: «꞊Nɩ 'lee 'lɩ nyiblo ꞊dʋ, kɛɛ, mu ‑bʋ tɔɔ ‑dɩɔnʋ Nyɩsʋa a ‑cɔhlʋnpinyɔ* yɩ, ɛ 'mʋ꞊ʋ 'ye, ‑ɛ mɔ, ‑na 'kʋɛ ‑wɛ nɩ. 'A ‑tɩ, ‑tɛblɩ ‑mʋ', ʋ ni, 'ʋ yɩ ‑cɔhlʋn* pi, 'kɩ 'ʋ Nyɩsʋa ye', gba꞊a, ꞊wɩ yɩ ‑tɛ Nyɩsʋa a winwlɔn‑hanyɔ* Moise nu la 'a hɩhla, yɩ‑hɛ‑nyrɛ a ti 'yri, ‑ɛ di꞊e nu, nyibli a pɛpɛ 'mʋ꞊ʋ yi, ‑ɛ mɔ, ‑na 'kʋɛ ‑wɛ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","‑Nyrɔwɔ ꞊dʋ, ‑ɛ ‑bɩ 'kɩ ‑Yusu mu 'lɩ Kapɛnaɔdɩɔ 'kwli. ‑Tɛ ɛ pa 'lɩ 'dɩɔ 'kwli, ‑ɛ ‑bɩ Romakʋɛ a 'sɛyo a nyiblo gbagbʋ ꞊dʋ, ɛ nɔ‑ mu 'ʋ꞊ʋ 'hʋɩ, 'ɛ nyɛɛ ꞊nɛ lɛ, ");
INSERT INTO ktj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ɛ wɛn: «Tɔɔnyɔ o, 'ye, 'na ‑kʋannunyɔ pɛ 'lɩ 'kayu bʋ, 'ɛ ‑yɩyrɛ lɛ. Ɛ yɩ 'ye ꞊hɩʋɛn dɩakɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","‑Ɛ ‑bɩ ‑Yusu ꞊tu꞊o ꞊wɔn, ɛ wɛn: «'N di 'lɩ 'nɩ di, 'mʋ꞊ʋ nu, 'a 'kʋɛ 'mʋ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kɛɛ ‑ɛ ‑bɩ, 'sɛyo a nyiblo gbagbʋ a 'mʋ, ɛ ꞊tu꞊o ꞊wɔn, ɛ wɛn: «Tɔɔnyɔ o, 'mɔ ‑bʋ, ‑ɛ 'yɩ ‑Juukʋɛyu* 'pa‑, 'n 'yɩ yɩ ‑blɛɛ ‑nɩ, 'kɩ ‑bʋ pa 'lɩ 'na 'kayu bʋ. Pʋ win dadʋ, 'na ‑kʋannunyɔ a 'kʋɛ 'mʋ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","'Na 'mumu ‑bʋ, 'n kɔ nyibli gbagbɩ ‑bɩ, ʋ nʋ‑ kɔɔ 'mʋ win kɩ. 'Tɩ‑ 'n kɔ 'sɛyo ‑bɩ, 'n kɔɔ win kɩ ‑wɛ. 'Bʋ mɔ, 'nɩ pʋ win, 'nɩ lee nɛ 'a nyɔ, 'kɩ bʋ mu dɛ nu, ‑ɛ ‑bɩ ɛ mi nɩ. 'Bʋ mɔ, 'nɩ lee nɛ 'a nyɔ ‑bɩ, 'kɩ bʋ di 'lɩ, ‑ɛ ‑bɩ ɛ yɩ 'lɩ 'nɩ di, ɛ kɔ, 'bʋ mɔ, 'nɩ lee 'na ‑kʋannunyɔ, 'kɩ bʋ nu dɛ, ‑ɛ ‑bɩ ɛ ni꞊e nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","'Tɩ‑ ‑Yusu 'mʋ win a 'mʋ 'wɩn mɔ mu, ‑ɛ ‑bɩ ‑tɩ ‑mʋ', 'sɛyo a nyiblo gbagbʋ ‑mʋ', ɛ ‑hla, ɛ kɛɛ nɛ 'a ꞊wlɩ lɛ. 'A ‑tɩ, ɛ yɩ nyibli ‑mʋ' 'nɩ ‑lee ‑nɩ, ‑ʋ yɩ꞊ɩ ꞊wien lɛ kʋɛ, ɛ wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ, 'n 'yɩ ‑hʋan nyiblo nɩ 'ye, ‑bʋ nu 'na ꞊wlʋ a yɩkuolɛ lɛ, 'ye ꞊bɩɩ 'kɩ 'lɩ Yisraɛkʋɛ a 'mumu 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, 'kɩ 'lɩ 'yrʋ a 'hrɩɩlɛ', kɔ 'kɩ 'lɩ 'yrʋ a paalɛ', 'kɩ nyibli di 'lɩ ‑wlu lɛ ‑hɔn, ʋ 'mʋ lɛ 'kukue ‑nɩ, ʋ kɔ ‑aan 'baɩnʋ Abrahamʋ, kɔ Yisakɩ, kɔ Sakɔbʋ 'hʋɛn‑, ʋ 'mʋ dɛ ‑mɔ ‑didi ‑nɩ, 'kɩ 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kɛɛ, Yisraɛkʋɛ ‑bɩ ‑mʋ', Nyɩsʋa ‑da, 'kɩ bʋ pa 'lɩ 'a 'klɔ yrayrʋ 'kwli, Nyɩsʋa di pʋ 'lɩ ꞊nʋ ‑patʋ' lɛ, ‑tɩtɛ ‑mʋ', halɔ nɩ 'lɩ, 'Kɩ ʋ di 'lɩ ꞊hien 'lɩ ‑wee ‑nɩ, kɔ, 'kɩ ʋ di 'lɩ yrʋ 'lɩ ‑pʋʋ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","‑Tɛ ‑Yusu 'mʋ ‑yrɛ mɔ mu, ‑ɛ ‑bɩ kɛ‑ ɛ pɩ 'sɛyo a nyiblo gbagbʋ a 'mʋ yɩ, ɛ wɛn: «‑Tɛ ‑kuo ꞊nɛ ꞊wlʋ yɩ ‑ɛ mɔ, Nyɩsʋa di꞊e 'nɩ nu, 'na ‑kʋannunyɔ a 'kʋɛ 'mʋ ‑wɛ, 'a ‑tɩ, ɛ di dɛ a 'mʋ 'nɩ nu. ‑Wɛ 'lɩ ‑bʋ mu 'lɩ 'kayu bʋ nɩ.» Ti nɩ ‑do a 'mʋ, ‑ɛ kɔ 'yri ‑Yusu hlaa la 'ʋ ‑tɩ a 'mʋ, 'kɩ 'sɛyo a nyiblo gbagbʋ a ‑kʋannunyɔ a 'mʋ, 'a 'kʋɛ ‑wɛɛ la 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ɛ kɔ la ‑nyrɔwɔ ‑bɩ, ‑Yusu 'ɛ mu la 'lɩ Piɛlɩ a ‑tɛ. ‑Tɛ ɛ pa 'kayu bʋ, ‑ɛ ‑bɩ 'kɩ ɛ yɛɛ 'ʋ Piɛlɩ a 'dɔɔ bʋ, 'ɛ 'ye꞊e, ‑ɛ mɔ, 'a 'hʋɩ hren nɩ, 'ɛ pɛ bʋ. ");
INSERT INTO ktj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ɛ nɔ‑ mɔ ‑Yusu bʋ klɔ 'a dabʋ bʋ. ‑Ɛ ‑bɩ Piɛlɩ a 'dɔɔ a 'mʋ, 'a 'hʋɩ 'kee nɩ, 'ɛ 'du ye', 'ɛ pi dɛ. ");
INSERT INTO ktj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","‑Winseke, ‑tɛ ‑wuwle‑nyrɔwɔ* ‑wɛ 'lɩ, ‑ɛ ‑bɩ nyibli ‑hʋɔhʋɩ ‑mʋ', 'kuo ‑hʋɩn* nɩ 'ʋ ke', ʋ nʋ‑ ʋ gba 'lɩ ‑Yusu ‑mɔ, 'ɛ bla 'kuo ‑hʋɩn a 'mʋ lɛ, 'ɛ nu꞊o, nyibli a pɛpɛ a 'mʋ, 'waa 'kʋɛ 'ɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ɛ nu꞊o nɩ, ‑ɛ di꞊e nu, ‑tɩ ‑mʋ', Nyɩsʋa a ‑kʋannunyɔ Esai 'crɩ la, ɛ 'mʋ 'lu ‑mɔ mu. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: «Ɛ ꞊gblɛɛ ‑a mʋ nɩ, 'kɩ 'lɩ ‑aan 'kʋɛ 'kwli, 'tɩ‑ 'ɛ gba꞊a.» ");
INSERT INTO ktj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","‑Yusu 'ye꞊e nɩ, ‑ɛ mɔ, nyibli ‑hʋɔhʋɩ, ʋ nʋ‑ ꞊glaa 'lɩ꞊ɩ lɛ. Ɛ nɔ‑ kɔ ‑tɩ 'ɛ lee nɛ 'a ‑nagbopʋ*, bʋ ꞊ta 'lɩ 'yru a 'kɩbɩa ‑bɩ ‑mʋ' kɩ. ");
INSERT INTO ktj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ Nyɩsʋa a tetetɔɔnyɔ ꞊dʋ 'yɩya 'ʋ꞊ʋ ye' bʋ, ɛ wɛn: «Tɔɔnyɔ o, 'a ‑nɛ ‑tɩtɛ, ‑di 'ʋ mu, 'n di kʋɛ ‑mʋ ꞊wien.» ");
INSERT INTO ktj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ɛ nɔ‑ mɔ ‑Yusu bʋ ꞊tu꞊o ꞊wɔn, ɛ wɛn: «'Wan 'kwli a mamʋɩ kɔ bʋpɛɛlɛ, nʋblɩ 'ʋ kɔ 'lʋɛ, kɛɛ, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n 'yɩ bʋpɛɛlɛ ꞊dʋ ‑kɔ, ‑tɛ 'n di 'ʋ ke lɛ ‑haa ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","‑Ɛ ‑bɩ nyiblo ‑bɩ ‑nɩ 'ʋ, 'ɛ mɔ ‑Yusu a ‑nagbopi ‑bɩ. Kɛ‑ ɛ pɩ ‑Yusu yɩ, ɛ wɛn: «Tɔɔnyɔ o, 'tɩ‑ 'mʋ ‑mʋ ꞊wien kʋɛ, ‑ha 'mʋ mɛ lɛ, ꞊bʋ mu, ꞊bʋ ‑ha 'ʋ 'na 'baɩ, ‑ɛ 'kʋ, 'tɩ‑ 'mʋ di, 'mʋ ‑mʋ ꞊wien kʋɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","‑Ɛ ‑bɩ ‑Yusu wɛn: «Ɛ 'yɩ ‑na ‑kʋan 'pa‑, 'kɩ ‑bʋ ‑ha 'ʋ 'kʋkʋkui lɛ. Kɛɛ, kʋɛ 'mʋ ꞊wien lɛ ‑tɛɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ 'kɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ 'ya 'lɩ 'blagbɩ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bʋ nɩ 'kɩ 'ʋ 'nie kɩ, bʋ yɩ nɩ mi, ‑ɛ ‑bɩ duduo cɛ 'lɩ nɩ, 'yru 'ɛ ‑tʋa 'dʋɩ a pʋpʋʋ, 'yru a 'dʋɩ a 'mʋ, 'ʋ ni꞊e, 'nie 'ɛ yɩ 'lɩ 'blagbɩ 'kwli lɛ 'wlɛ. ‑Tɛblɩ a pɛpɛ a 'mʋ, ‑ɛ mi 'lu ‑mɔ, ‑Yusu yɩ 'nɩ ŋme. ");
INSERT INTO ktj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ɛ nɔ‑ mɔ 'a ‑nagbopʋ bʋ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, bʋ ‑ha꞊a ŋmena'. Kɛ‑ ʋ pɩ꞊ɩ yɩ: «Kʋkɔnyɔ o, wa ‑a mʋ, ‑a yɩ ‑wɛ bʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","‑Ɛ ‑bɩ ‑Yusu wɛn: «Dɛ‑ kɔ hʋannʋ a yɩ pie 'lɩ? 'A mʋ ‑bʋ, ‑ʋ 'yɩ Nyɩsʋa ꞊wlʋ yɩ ‑kuo ‑nɩ ‑tɛɛ?» 'tɩ‑, 'ɛ 'du ye', 'ɛ hlee 'lɩ duduo kɔ 'yru 'hʋɛn‑ ‑mɔ, 'kɩ 'lɩ win 'yaklɩ 'kwli, ‑ɛ di꞊e nu, 'a 'dʋɩ 'mʋ 'ʋ ꞊tɩ, 'ɛ mɔ ꞊han‑tɩ, duduo a 'mʋ 'ɛ nyra bʋ. ");
INSERT INTO ktj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","'Waa pɛpɛ a 'mʋ, ɛ mɔ 'waa ꞊wlɩlɛkɛɛdɛ, ʋ wɛn: «Ba 'ye kɛ nyiblo ‑bʋ, pepe kɔ 'yru 'hʋɛn‑, ʋ ꞊tui 'ʋ꞊ʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ʋ nyre 'lɩ Galileblʋgba a 'yru a 'kɩbɩa ‑mʋ' kɩ nɩ, ‑ɛ mɔ Gadalakʋɛ a 'blʋgba. ‑Tɛ ʋ nyre 'lɩ, ‑ɛ ‑bɩ nyɩbɛpʋ nɩ 'hʋɛn ꞊dʋ, ʋ nʋ‑ ‑hɔn 'lɩ 'dabi 'kwli, 'ʋ mu ‑Yusu ye' 'bɛ mɔ. Nyibli nɩ 'hʋɛn a 'mʋ, 'kuo ‑hʋɩn nɩ 'ʋ ꞊nʋ ke', 'ʋ ꞊tui ꞊nʋ ꞊hɩʋɛn. 'Waa ŋmlɩ a yɩnyinyre a ‑tɩ, nyiblo ꞊dʋ 'nɩ ‑na꞊a 'ʋ 'hru ‑mʋ' ‑kɔ wlɔn ʋ nɩ 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","‑Tɛ ʋ 'ye 'kɩ ‑Yusu, ‑ɛ ‑bɩ ʋ ‑tʋa 'lɩ win a 'lɩ'yaalɛ, ʋ wɛn: «Nyɩsʋa a 'Yu, dɛ a 'dɩ ‑bɩ ‑hʋɛ ‑bʋ nu ‑a mʋ ‑mɔ 'lɩ? ꞊Bɩ ‑di nɩ, ꞊mʋ ‑a mʋ ꞊hɩʋɛn ꞊tu, 'tɩ‑ Nyɩsʋa a ‑batipʋ‑nyrɔwɔ 'mʋ 'ʋ nyre?» ");
INSERT INTO ktj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","'Kɩ 'ʋ ‑tɩtɛ nɩ ‑do a 'mʋ, 'kɩ bʋɩca꞊ju gbagbʋ nɩ 'lɩ ꞊nʋ ye', 'ʋ wɛ ‑tʋtʋ, 'ʋ yɩ dɛ di. ");
INSERT INTO ktj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ɛ nɔ‑ mɔ 'kuo ‑hʋɩn a 'mʋ, bʋ nyaa ‑Yusu lɛ, ʋ wɛn: «'Bʋ mɔ, ꞊nɩ yɩ꞊ɩ nɩ ‑hʋɛ, ‑bʋ bla ‑a mʋ lɛ, wɛn, 'kɩ ‑ba bi 'ʋ bʋɩca꞊ju ‑mʋ' ke'.» ");
INSERT INTO ktj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","‑Ɛ ‑bɩ ‑Yusu wɛn: «Ba bi 'ʋ ꞊nʋ ke',» 'ʋ ‑hɔn 'ʋ nyibli nɩ 'hʋɛn a 'mʋ ke', 'ʋ bi 'ʋ bʋɩcɩ ‑nɩ wɛn ke', bʋɩcɩ a pɛpɛ a 'mʋ, 'ʋ 'gba ci lɛ, 'ʋ ꞊tɩ dʋgba, 'ʋ bi 'lɩ 'yru ‑mɔ lɛ, 'ʋ 'kʋkʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","‑Tɛ nyibli ‑mʋ', ‑ʋ nɛɛ bʋɩcɩ a 'mʋ, ʋ 'ye ‑tɛblɩ a 'mʋ, ‑ɛ mu 'lu ‑mɔ, ‑ɛ ‑bɩ ʋ 'gba ci lɛ, 'ʋ 'ya 'dɩɔ, ‑tɛblɩ a pɛpɛ a 'mʋ, ‑ɛ mu 'lu ‑mɔ, 'kɩ 'ʋ nyibli nɩ 'hʋɛn ‑mʋ', 'kuo ‑hʋɩn nɩ wɛn 'ʋ ke' a ‑ta', ʋ na꞊a ‑mɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","‑Tɛ 'dɩɔ a nyibli 'wɩn, ‑ɛ ‑bɩ ʋ ꞊tɩ 'dɩɔ, 'ʋ mu ‑Yusu ye' 'bɛ mɔ. ‑Tɛ ʋ 'ye꞊e, ‑ɛ ‑bɩ ʋ ‑tʋa 'a lɛnyaalɛ, 'kɩ bʋ ‑hɔn 'lɩ 'waa 'blʋgba 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ 'kɩ ‑Yusu 'ya 'lɩ 'blagbɩ 'kwli, 'ɛ ꞊ta 'yru ‑mʋ' kɩ de, 'ɛ mu 'lɩ 'dɩɔ ‑mʋ', ɛ 'ti 'lɩ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","‑Tɛ ɛ nyre 'lɩ, ‑ɛ ‑bɩ nyibli ꞊dʋ ya꞊a lɛ‑yɩyrɛnyɔ ꞊dʋ yɩ. 'Kɩ 'lɩ ‑hanmakɩ 'kwli, 'kɩ ʋ pʋ 'lɩ lɛ‑yɩyrɛnyɔ a 'mʋ bʋ. ‑Tɛ ‑Yusu 'ye꞊e, ‑ɛ mɔ, nyibli a 'mʋ, ʋ kuo ꞊nɛ ꞊wlʋ yɩ, ‑ɛ mɔ, ɛ ‑wɛ 'lɩ bʋ nu꞊o nɩ, 'waa lɛ‑yɩyrɛnyɔ a 'mʋ, 'a 'kʋɛ bʋ ‑wɛ nɩ, ‑ɛ ‑bɩ ɛ lee lɛ‑yɩyrɛnyɔ a 'mʋ nɩ, ɛ wɛn: «'Na 'yu o, ‑na ꞊wlʋ 'nɩ 'bie 'lɩ ꞊hlɔn, ‑tɛblɩ ‑bʋ, ‑nu, ‑ɛ nyre yɩ, 'kɩ 'ʋ Nyɩsʋa ye', ɛ 'wʋwlɛ kɛ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","‑Ɛ ‑bɩ Nyɩsʋa a tetetɔɔnyʋ ‑mʋ', ‑ʋ nɩ 'ʋ, kɛ‑ ʋ pɩ 'waa dɩɔnʋ yɩ, ʋ wɛn: «‑Tɩ ‑bʋ, ‑Yusu ‑bʋ, ɛ hlɛ, ɛ yɩ ‑hɛɛ Nyɩsʋa a ‑tɩ lɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kɛɛ, dɛ a 'mʋ, ʋ nɛɛ ꞊wlʋ klɛ, ‑Yusu yi꞊e nɩ, ɛ wɛn: «Dɛ‑ kɔ yɩnyre꞊wlɩdʋ ‑mʋ' a nɛɛ 'kɩ lɛ 'lɩ? A 'yɩ wɛn yɩ ‑blɛɛ ‑nɩ ba naa wɛn ꞊wlɩdʋ a 'mʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","'Aan ꞊wlɩ wɛn 'nɩ, ‑ɛ mɔ, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ lee nyiblo ‑bʋ, 'a dɛ 'kuku 'wʋwlɛ nɩ, ɛ kɔ, 'aan ꞊wlɩ wɛn 'nɩ, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ lee ꞊nɛ, ‑ɛ mɔ, bʋ 'du ye', bʋ na. ");
INSERT INTO ktj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kɛɛ, ba yi꞊e, ‑ɛ mɔ, 'mɔ ‑mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'tɩ‑ 'mɔ ‑mɔ Nyɩsʋa a 'Yu, ɛ lee 'nɛ‑ ‑tʋtʋ kɩ. Nyɩsʋa a ꞊gbɛtʋ, ɛ nɔ‑ ‑nyi 'mʋ 'klɩ, 'kɩ ꞊bʋ 'wʋwla ‑tonyibli a dɛ 'kuku, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, 'ɛ ‑nyi 'mʋ 'klɩ ‑wɛ, 'kɩ ꞊bʋ nu꞊o, ‑tonyibli a 'kʋɛ 'mʋ ‑wɛ. 'A ‑tɩ, nyiblo ‑bʋ, ʋ ‑ya, 'n kɔ ꞊bʋ nu꞊o, 'a 'kʋɛ 'mʋ ‑wɛ, ‑ɛ di꞊e nu, a 'mʋ꞊ʋ lɛ yru, ‑ɛ mɔ, ‑tɩ ‑bʋ, 'n lee wɛn 'a mʋ, ɛ mɔ ꞊han‑tɩ ꞊nɩɔ.» ‑Ɛ ‑bɩ ɛ ꞊hɩan ‑mɔ de, 'ɛ ‑tʋa 'lɩ lɛ‑yɩyrɛnyɔ a 'mʋ, 'a ‑mɔhleelɛ, ɛ wɛn: «'Du ye', ‑bʋ 'du ‑na ‑hanmakɩ ye', ‑bʋ mu 'lɩ ‑na 'kayu bʋ, ‑na 'kʋɛ ‑wɛ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ nyiblo a 'mʋ, ɛ 'du ye', 'ɛ mu 'lɩ 'a 'kayu bʋ. ");
INSERT INTO ktj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","‑Tɛ nyibli 'ye dɛ a 'mʋ, ‑ɛ ‑bɩ ʋ 'ta 'ʋ blɛ, 'ʋ pɩ Nyɩsʋa 'nyrɛ lɛ, ‑tɛ ɛ ‑nu, 'ɛ ‑nyi ‑tonyibli 'klɩdʋ a 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu ‑hɔn 'lɩ ‑tɩtɛ a 'mʋ nɩ. ‑Tɛ ɛ yɩ 'kɩ nɩ mi, ‑ɛ ‑bɩ 'kɩ ɛ yɛɛ 'ʋ nyɩbɛhɩan ꞊dʋ ‑bʋ. 'A 'nyrɛ mɔ Matie. Matie a 'mʋ, 'blʋwli'tɩ‑kʋan* ɛ ni. 'Kɩ ɛ nɩ 'lɩ 'blʋwli'tɩɩlɛ' bʋ. (Kɛɛ, nyibli 'nɩ ‑hʋa꞊a lɩ 'blʋwli'tɩnyʋ, ‑ɛ nu꞊o, ʋ yɩ di 'yiyriwli.) ‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ꞊ɩ yɩ, ɛ wɛn: «Kʋɛ 'mʋ ꞊wien lɛ, ꞊mʋ 'na ‑nagbopi ‑hɛ.» Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ Matie 'du ye', 'ɛ kʋɛ꞊ɛ ꞊wien. ");
INSERT INTO ktj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Matie a 'mʋ, ɛ nɔ‑ da ‑Yusu kɔ 'a ‑nagbopʋ 'hʋɛn‑ dididɛ ‑mɔ, 'ɛ da 'a 'bio 'blʋwli'tɩnyʋ ‑bɩ, kɔ hɩapʋnyibli ‑bɩ ‑wɛ, ‑ʋ kɔ 'klɔ, ‑ɛ 'yɩ 'ʋ yɩ 'sii ‑nɩ, ‑ɛ di꞊e nu, ʋ 'mʋ dɛ di. ");
INSERT INTO ktj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bʋ nɩ 'ʋ dɛdiilɛ', ‑ɛ ‑bɩ Falisi꞊tumu* a nyibli, ‑ʋ nɩ 'ʋ, ʋ 'ye dɛ a 'mʋ nɩ. Ɛ nɔ‑ mɔ bʋ lee ‑Yusu a ‑nagbopʋ, ‑ɛ mɔ: «Dɛ‑ nu 'kɩ꞊ɩ, 'aan tɔɔnyɔ, kɔ 'blʋwli'tɩnyʋ, kɔ nyiblidʋ ‑bʋ, ‑ʋ kɔ 'klɔ ꞊yɩ 'ʋ yɩ 'sii ‑nɩ 'hʋɛn‑, 'ʋ nɩ 'ʋ dɛdihu nɩ ‑do kɩ 'lɩ? Ɛ 'yɩ wɛn yɩ ‑blɛɛ ‑nɩ, bʋ nu wɛn dɛ a 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","‑Ɛ ‑bɩ ‑Yusu 'wɩn ‑tɩ a 'mʋ, nyibli a 'mʋ, ʋ hlɛ. Bʋ 'wɩn 'kɩ꞊ɩ, ‑ɛ ‑bɩ ɛ wɛn: «Nyiblo ‑bʋ, ‑ɛ kɔ 'hʋɩ ‑nu ‑tɛɛ, ɛ 'nɩ ꞊mʋɔ꞊ɔ lɩ ‑dɔdɔ a 'yiye lɛ, kɛɛ, nyiblo ‑bʋ, ‑ɛ kɔ 'hʋɩ ‑hren, ɛ nɔ‑ ꞊mʋɛ ‑dɔdɔ a 'yiye lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ʋ 'crɩɩ 'lɩ꞊ɩ Nyɩsʋacrɩɛn 'kwli nɩ, ‑ɛ mɔ: Nyɩsʋa wɛn 'nɩ: Dɛ ‑bʋ, 'n ‑hʋɛ, ɛ nɔ‑ mɔ, ba kɔ 'aan 'bio a nyaɩ. Ɛ 'yɩ ba pi 'wlugba‑tɛblɩ a ‑cɔhlʋn* a gblegble nɩ ‑do, 'kɩ 'ʋ 'mʋ ‑mɔ 'pa‑.» ‑Yusu wɛn 'nɩ de: «'N 'yɩ ‑di, 'kɩ 'ʋ nyibli ‑bʋ, ‑ʋ pɩ lɛ, 'waa 'klɔ 'sii 'ʋ yɩ a ‑ta', kɛɛ, nyibli ‑bʋ, ‑ʋ yi꞊e, ‑ɛ mɔ, 'waa 'klɔ 'yɩ 'ʋ yɩ 'sii ‑nɩ, ʋ nʋ‑ kɔ ‑tɩ 'nɩ ‑di, 'mʋ ꞊nʋ ‑lee ‑nɩ, ‑ɛ mɔ, 'waa dɛ 'kuku ‑mʋ', ʋ ni, bʋ hie 'ʋ꞊ʋ bʋ, bʋ ‑nyi 'waa 'klɔ a pɛpɛ Nyɩsʋa.» ");
INSERT INTO ktj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ Saan Batisɩ, ‑ɛ pɩ nyibli 'nie 'lu lɛ, 'a ‑nagbopʋ, ʋ nʋ‑ 'yɩya 'ʋ ‑Yusu 'hʋɩ bʋ, 'ʋ 'bɛti꞊e, ʋ wɛn: «Dɛ‑ nu꞊o, ‑a mʋ ‑bʋ, ‑ʋ mɔ Saan a ‑nagbopʋ, ‑a kɔ Falisi꞊tumu* a nyibli 'hʋɛn‑, ꞊a yɩ ꞊ci*, 'tɩ‑ ‑mɔ ‑bɩ, ‑na ‑nagbopʋ* 'yɛ nɩ ꞊ci 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ, ɛ wɛn: «Nyɩbɛyu ‑bʋ, ‑ɛ pʋɛ 'blɩ, 'a 'bio ‑mʋ', ɛ dɛ 'blɩpadiidɛ kɩ, 'bʋ mu 'lɩ 'blɩpadiidɛ a 'mʋ, 'a ‑tuo kɩ, 'a 'bio a 'mʋ, ʋ 'nɩ ꞊ci꞊e lɩ. Ɛ 'wɩ yɩ, 'blɩ a pʋpa mɔ dɔdʋdɛ ꞊nɩɔ. 'A ‑tɩ, ʋ 'yɩ ꞊cicie ‑kɔ. Dɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ ꞊nɩɔ. Dɔdʋ a ‑tɩ, ti nɩ ‑tie ‑bʋ, 'n di 'nɛ‑ ꞊nʋ 'nyɩ ‑hii ‑nɩ, 'na ‑nagbopʋ 'nɩ ꞊ci꞊e nɩ. Kɛɛ, ɛ di kɔ ti, ‑ɛ di 'ʋ nyre, ʋ 'mʋ 'lɩ 'mʋ 'na ‑nagbopʋ 'nyɩ ‑ha. Ti a 'mʋ 'yri, 'kɩ ʋ di 'ʋ ꞊cii ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","‑A 'blikʋɛ wɛn 'nɩ: Nyɔ 'nɩ ‑nu꞊o lɩ dayrayrʋ a 'kɩbɩa, ɛ 'nɩ ‑ma꞊a da'ka. 'Bʋ mɔ, 'bʋ nu dayrayrʋ a 'kɩbɩa, 'bʋ ‑ma da'ka, ti ‑mʋ' ‑kɔ 'yri ɛ di꞊e yra, dayrayrʋ ‑mʋ', ɛ kɔ bʋ 'yɩya ‑mɔ. 'Bʋ 'yɩya ‑mɔ, dayrayrʋ a 'mʋ, ɛ kɔ bʋ cra da'ka a 'mʋ, 'a 'hʋɔ 'ka ‑mʋ', ɛ 'mʋ 'yri lɛ 'bʋa ‑tɛɛ. ");
INSERT INTO ktj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Mɔ, nyiblo 'nɩ 'du꞊o lɩ yonɔ yrayrɩ, ‑ɛ 'plui ye', ɛ 'nɩ ‑pʋ꞊ʋ 'lɩ꞊ɩ mʋmakɔ a buo 'ka 'kwli. 'Bʋ pʋ 'lɩ꞊ɩ buo 'ka a 'mʋ 'kwli, 'bʋ ka꞊a yɩ, ti ‑mʋ' ‑kɔ 'yri ɛ di 'plu, 'bʋ yɩ nɩ 'yɛ, ɛ kɔ bʋ cra mʋmakɔ a buo ‑mʋ', nɔ a 'mʋ, ɛ 'mʋ bʋ 'wlɛ. Ɛ nɔ‑ kɔ ‑tɩ, 'ʋ pɩ 'lɩ nɔ yrayrɩ mʋmakɔ yrayrʋ a buo 'kwli. 'Bʋ nu꞊o lɛ, ‑ɛ ‑bɩ mʋmakɔ a buo ‑mʋ', ɛ kɔ nɔ a 'mʋ 'hʋɛn‑, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nyre yɩ. ('A ‑tɩ o, nyiblo ꞊dʋ 'nɩ 'du꞊o lɩ ‑tɛblɩ 'kɩ ye', ɛ 'nɩ ‑pʋ꞊ʋ lɩ꞊ɩ ‑tɛblɩ yrayrɩ kɩ. Ʋ 'nɩ ‑bibi꞊e lɩ 'yi lɛ.)» ");
INSERT INTO ktj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","‑Yusu bʋ yɩ ꞊nʋ ‑tɩ a 'mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ ‑bɩ ‑Juukʋɛ* a nyiblo gbagbʋ ꞊dʋ nyre 'ʋ nɩ, 'ɛ bla kwlɩ bʋ, 'kɩ 'ʋ꞊ʋ ye', ɛ wɛn: «‑Tɛ ti nɛ ‑bʋ, 'kɩ 'na 'yu nyrɔyu 'kʋʋ 'ʋ. 'A ‑tɩ, 'n nyaa ‑mʋ lɛ, di 'lɩ ‑bʋ pʋ꞊ʋ dabʋɩ 'lu bʋ, ‑ɛ di꞊e nu, ɛ 'mʋ ‑hʋnhlʋn pʋ de.» ");
INSERT INTO ktj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","‑Ɛ ‑bɩ ‑Yusu wɛn nɩ, 'ɛ 'du ye', 'ɛ kʋɛ꞊ɛ ꞊wien, ɛ kɔ 'a ‑nagbopʋ* 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","‑Ɛ ‑bɩ nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, 'kɩ 'lɩ ꞊nʋ 'nyɩ, nʋgba ꞊dʋ nɩ 'lɩ, 'kʋɛ 'ɛ ni꞊e. 'A 'kʋɛ a 'mʋ, ‑ɛ ni꞊e, ɛ nɔ‑ mɔ ‑hlʋblɛblekʋɛ. ‑Tɛ 'kʋɛ a 'mʋ, ɛ ‑tʋa la 'a nunuo, 'a 'yrɩ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn a 'yrʋ ‑bʋ ‑a nɩ kɩ. Ɛ nɔ‑ mu 'ʋ ‑Yusu ke', 'ɛ ‑hrɛn 'a wlawlʋ a ‑wlubʋdɛ lɛ, ");
INSERT INTO ktj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","‑ɛ nu꞊o, kɛ‑ ɛ pɩ, 'kɩ 'lɩ a dɩɔnʋ a ꞊wlʋ kɩ: «'Nɩ ‑hrɛn 'a wlawlʋ lɛ dadʋ, 'na 'kʋɛ di 'nɩ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","‑Ɛ ‑bɩ ‑Yusu ꞊hɩan ‑mɔ, 'ɛ 'ye꞊e, ɛ wɛn: «'Na 'yu o, ‑na ꞊wlʋ 'nɩ 'bie 'lɩ ꞊hlɔn. ‑Tɛ ‑kuo 'mʋ ꞊wlʋ yɩ a ‑tɩ, 'nɩ nu꞊o, ‑na 'kʋɛ 'ɛ ‑wɛ.» Ti nɩ ‑do a 'mʋ 'yri, ‑ɛ ‑bɩ nʋgba a 'mʋ, 'a 'kʋɛ ‑wɛ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu nyre 'lɩ ‑Juukʋɛ a nyiblo gbagbʋ ‑nɩ wɛn a ‑tɛ nɩ. 'Kɩ ɛ yɛɛ 'lɩ ‑tɛblɩbinyʋ kɔ nyibli ‑hʋɔhʋɩ 'hʋɛn‑ bʋ, 'ʋ pɩ popowli, ‑ɛ ‑bɩ ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","«Ba ‑hɔn 'ʋ ‑wlu. 'Yu nyrɔyu ‑bʋ, ɛ 'yɩ 'kʋ. Ŋmena ɛ yɩ ŋme.» ‑Tɛ ɛ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ʋ ‑tʋa 'a 'caalɛ. ");
INSERT INTO ktj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nyibli a pɛpɛ, ‑ʋ nɩ 'lɩ 'kayu a 'mʋ bʋ, ʋ 'hrɔɔ ꞊nʋ nɩ, ‑Yusu 'ɛ pa 'lɩ ‑gblo a 'mʋ, ‑ɛ kɔ 'kwli 'yu pɛ 'lɩ bʋ, 'ɛ klɔ 'yu a 'mʋ, 'a dabʋ bʋ. ‑Ɛ ‑bɩ 'yu nyrɔyu a 'mʋ, ɛ 'hrɩ 'klɔ, 'ɛ 'du ye'. ");
INSERT INTO ktj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Dɛ a 'mʋ, ‑ɛ mu 'lu ‑mɔ, 'a ‑tɩ 'hɛɛn bʋ, 'kɩ 'lɩ 'blʋgba a pɛpɛ a 'mʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu ‑hɔn 'ʋ ‑tɩtɛ a 'mʋ nɩ, 'ɛ mi. Bʋ yɩ 'kɩ nɩ mi, ‑ɛ ‑bɩ 'yii'dɔnyʋ nɩ 'hʋɛn, ʋ nʋ‑ bi 'ʋ꞊ʋ ke', 'ʋ yɩ꞊ɩ ꞊wien lɛ kʋɛ, 'ʋ 'yɛɛ 'lɩ win, ʋ wɛn: «Dafidɩ* a 'yonʋ a 'Yu o, yru ‑aan nyaɩ!» ");
INSERT INTO ktj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","‑Tɛ ‑Yusu nyre 'lɩ 'kayu bʋ, ‑ɛ ‑bɩ ʋ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, 'ɛ 'bɛti ꞊nʋ: «꞊Bɩ a kuo ꞊nɛ ꞊wlʋ yɩ, ‑ɛ mɔ, 'n ‑wɛ 'lɩ ꞊bʋ nu꞊o nɩ, 'aan 'kʋɛ bʋ ‑wɛ nɩ?» ‑Ɛ ‑bɩ ʋ ꞊tu꞊o ꞊wɔn, ʋ wɛn: «Iin ‑o, Tɔɔnyɔ, ‑a kuo ‑mʋ ꞊wlʋ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ɛ nɔ‑ mɔ ‑Yusu bʋ ‑hrɛn 'waa 'yii lɛ, ɛ wɛn: «Dɛ ‑mʋ', a kuo ꞊wlʋ yɩ, 'n ‑wɛ 'lɩ ꞊bʋ nu 'a mʋ ‑mɔ, ɛ nɔ‑ ‑bʋ mu 'lu ‑mɔ,» ");
INSERT INTO ktj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","'waa 'yii 'ʋ klɛ yɩ. ‑Ɛ ‑bɩ ‑Yusu yɩ hlee 'lɩ ꞊nʋ ‑mɔ, 'kɩ 'lɩ win 'yaklɩ 'kwli, ɛ wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, a 'nɩ 'lee 'lɩ nyiblo ꞊dʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","‑Tɛ ʋ nʋ‑ ‑mɔ ‑bɩ, ʋ ‑hɔn 'ʋ ‑wlu, ‑ɛ ‑bɩ ʋ 'hɛɛn ‑Yusu a 'nyrɛ bʋ, 'kɩ 'lɩ 'blʋgba a pɛpɛ a 'mʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ti ‑mʋ' ‑kɔ 'yri nyibli a 'mʋ, ʋ mi, ti nɩ ‑do a 'mʋ 'yri, ‑ɛ ‑bɩ ʋ ya nyiblo ꞊dʋ ‑Yusu yɩ, ‑ɛ 'yɩ 'plɛlɛ ‑yi, ‑ɛ nu꞊o, 'ku ‑hʋan* nɩ 'ʋ꞊ʋ ke'. ");
INSERT INTO ktj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ɛ nɔ‑ mɔ ‑Yusu bʋ bla 'ku ‑hʋan a 'mʋ lɛ, ‑ɛ nɩ 'ʋ nyiblo a 'mʋ ke'. ‑Tɛ ɛ bla 'kɩ꞊ɩ lɛ, ‑ɛ ‑bɩ nyiblo a 'mʋ, ɛ ‑tʋa 'pʋplɛ. Nyibli ‑nɩ 'ʋ, ɛ kɛɛ 'waa ꞊wlɩ lɛ dɩakɩ, ʋ wɛn: «Dɛ ‑bʋ, ‑ɛ mu 'lu ‑mɔ, ‑a 'yɩ ‑hʋan꞊a nɩ 'ye, 'kɩ 'nɛ‑ Yisraɛkʋɛ a 'bli.» ");
INSERT INTO ktj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kɛɛ, Falisi꞊tumu* a nyibli ‑mʋ', ‑ʋ nɩ ‑tuo kɩ, kɛ‑ ʋ pɩ, ʋ wɛn: «'Kuo ‑hʋɩn a nyiblo gbagbʋ Satan, ɛ nɔ‑ yɩ꞊ɩ 'klɩ ‑nyi, 'kɩ bʋ bla 'kuo ‑hʋɩn lɛ, ‑ʋ nɩ 'ʋ nyibli ke'.» ");
INSERT INTO ktj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu nɛ 'dɩɩ a pɛpɛ kɩ, 'ɛ tʋɛ Nyɩsʋa a ‑tɩ, 'kɩ 'lɩ Nyɩsʋa a 'kayo blɛ, 'ɛ pɩ Nyɩsʋa a ꞊haantitie ‑mʋ', ‑ɛ hlɛ꞊ɛ, ‑tɛ ‑mʋ', Nyɩsʋa di nyibli a win a kɩkɔɔlɛ nu, ɛ kɔ, 'ɛ ni꞊e, nyibli a 'kʋɛ kɔ 'a ‑nɛ kɩkladɛ ꞊dʋ 'hʋɛn‑, 'ʋ yɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","‑Tɛ ɛ yɩ nyibli ‑hʋɔhʋɩ ‑mʋ' 'ye, ‑ɛ ‑bɩ 'waa nyaɩ ‑tʋa 'a nunuo, ‑ɛ nu꞊o, 'waa 'klɩ ‑wɛ 'lɩ nɩ, ɛ kɔ, 'waa ꞊wlɩ bi ꞊hlɔn. Ʋ 'wɩ blablɩ yɩ, ‑ʋ 'yɩ kʋkɔnyɔ ‑kɔ. ");
INSERT INTO ktj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ 'kɩ 'a ‑nagbopʋ* yɩ, ɛ wɛn: «‑Kʋbʋ, ‑ɛ ꞊hlu, ɛ ‑hʋ nɩ, kɛɛ, 'a 'cɩcɛnyibli 'yɩ ‑hʋ. ");
INSERT INTO ktj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","'A ‑tɩ, ba nyaa ‑cikɔnyɔ lɛ, bʋ lee nɛ 'a ‑kʋannunyibli ‑bɩ, bʋ bi 'a mʋ kɩ, a 'mʋ ‑kʋbʋ 'cɛ. (Ɛ 'wɩ yɩ, ba nyaa Nyɩsʋa lɛ, ɛ 'mʋ 'a nyibli ‑bɩ ‑lee ‑nɩ, 'kɩ bʋ ‑hɛɛ nɛ 'a mʋ, a 'mʋ nyibli ‑bɩ lɛ 'kukue ‑nɩ, ʋ 'mʋ 'waa 'klɔ Nyɩsʋa ‑nyi.)» ");
INSERT INTO ktj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","‑Ɛ ‑bɩ ‑Yusu da 'a ‑nagbopʋ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn ‑mʋ' nɩ, 'ɛ ‑nyi ꞊nʋ 'klɩ, 'kɩ bʋ bla 'kuo ‑hʋɩn* lɛ, ‑ʋ nɩ 'ʋ nyibli ke', 'ɛ ‑nyi ꞊nʋ 'klɩ ‑wɛ, 'kɩ bʋ nu꞊o, nyibli a 'kʋɛ a pɛpɛ 'mʋ ‑wɛ, kɔ 'a ‑nɛ kɩkladɛ ꞊dʋ 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","‑Yusu a ‑nagbopʋ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn a 'mʋ, ʋ dɛɛ nɛ 'a ‑mɔnanyʋ* ‑wɛ, 'waa 'nyrɛ, nɔ‑ ‑bʋ: 'Waa yɩ‑hɛnyiblo, ɛ nɔ‑ mɔ Simɔ, ʋ dɛɛ Piɛlɩ ‑wɛ, ɛ kɔ 'a 'dɩayɩ Adre 'hʋɛn‑; ɛ kɔ Sakɩ, kɔ 'a 'dɩayɩ Saan 'hʋɛn‑; ʋ nʋ‑ 'hʋɛn a 'mʋ, ʋ nʋ‑ mɔ Sebede a 'yonʋ; ");
INSERT INTO ktj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","'kɩ Filipʋ kɔ Batelemi 'hʋɛn‑, ʋ nɩ 'ʋ; ɛ kɔ Toma, kɔ Matie, ‑ɛ mɔ 'blʋwli'tɩnyɔ; Alʋfe a 'yu Sakɩ, kɔ Tade 'hʋɛn‑; ");
INSERT INTO ktj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simɔ ‑mʋ', ‑ɛ nɩ 'lɩ nyibli ‑mʋ', ‑ʋ 'yɛ nɩ ‑hʋa Romakʋɛ 'nyɩ; kɔ Judɩa Yisikalio, ‑ɛ mɔ nyiblo ‑mʋ', ‑ɛ di ‑Yusu 'a yraanyibli ‑jɩ' pʋ. ");
INSERT INTO ktj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","‑Yusu a ‑nagbopʋ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn a 'mʋ, ʋ nʋ‑ ɛ tɛ bʋ, 'kɩ bʋ gba Nyɩsʋa a ‑tɩ 'dɩɩ klɛ. Ɛ ti ꞊nʋ nɩ, ɛ wɛn: «'Blʋgbɩ ‑mʋ', ‑ʋ kɔ kɩ ‑Juukʋɛ* 'yɩ 'lɩ ‑nɩ, a 'nɩ 'muo 'lɩ, ɛ kɔ, a 'nɩ 'muo 'lɩ Samaliblʋgba a 'dɩɔ ꞊dʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kɛɛ, Yisraɛkʋɛ a nyibli ‑mʋ', ‑ʋ 'wan, ‑wɛn blablɩ, ‑ʋ 'yɩ kʋkɔnyɔ ꞊dʋ ‑kɔ, ʋ nʋ‑ kɔ ‑mɔ ba mu 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","'Bʋ mɔ, 'ba ‑mu, ‑ɛ ‑bɩ ba lee ꞊nʋ, ‑ɛ mɔ: Ti ‑kɔ 'yri Nyɩsʋa di 'ʋ nyibli win kɩ ‑kɔɔ ‑nɩ, ɛ 'mʋɛ yrɛ. ");
INSERT INTO ktj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ba nu꞊o, nyibli a 'kʋɛ bʋ ‑wɛ, ba ‑ha 'kʋkʋnyibli 'klɔ lɛ, ba nu꞊o, ꞊hrannunyʋ a 'kʋɛ bʋ ‑wɛ, ba bla 'kuo ‑hʋɩn* lɛ, ‑ʋ nɩ 'ʋ nyibli ke'. Nyɩsʋa nu 'a mʋ ꞊haandɛ ‑mɔ nɩ, 'kɩ 'lɩ dadʋke 'kwli. 'A ‑tɩ, 'aan 'mumu, ba nu nyibli ꞊haandɛ ‑mɔ ‑wɛ, 'kɩ 'lɩ dadʋke 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","'Bʋ mɔ, 'ba yɩ nɩ mi, a 'nɩ 'gbaa 'lɩ 'wliyɛ, ");
INSERT INTO ktj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","a 'nɩ 'gbaa 'lɩ blɔ gbagbʋ ꞊dʋ, kɔ 'hʋɛn a wlawlʋ, ɛ kɔ, a 'nɩ 'gbaa 'lɩ 'suin kɔ kotu, ‑ɛ nu꞊o, nyibli ‑mʋ', ‑ʋ kɔ ‑tɩ 'a ni ‑kʋan, nʋ‑ blɛɛ yɩ, ‑bʋ kikle 'a mʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","'A ‑nɛ 'dɩɔ ‑kɔ 'kwli a di 'lɩ nyre, ba ꞊mʋɔ nyiblo lɛ, ‑ɛ di 'a mʋ kʋa 'ble. 'Bʋ mɔ, 'bʋ 'ble 'a mʋ kʋa, 'kɩ ba nɩ 'lɩ꞊ɩ ‑mɔ bʋ ‑nɩnɩ, 'aan mumuti 'mʋ 'ʋ nyre. ");
INSERT INTO ktj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","'Bʋ mɔ, 'ba pa 'lɩ 'kayu ‑bɩ bʋ, ‑ɛ ‑bɩ nyibli ‑mʋ', a di 'lɩ 'kayu a 'mʋ bʋ ‑yɛɛ ‑nɩ, kɛ‑ ba pʋ ꞊nʋ yɩ: Nyɩsʋa bʋ nɩ 'ʋ 'a mʋ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","'Bʋ mɔ, 'kayu a 'mʋ, 'a nyibli 'bʋ 'ble 'a mʋ kʋa, ‑ɛ ‑bɩ ba da Nyɩsʋa, ɛ 'mʋ ꞊nʋ ꞊haandɛ ‑mɔ nu, kɛɛ, 'bʋ 'yɩ 'a mʋ kʋa 'ble, ‑ɛ ‑bɩ Nyɩsʋa 'nɩ 'nuo 'lɩ ꞊nʋ ꞊haandɛ ‑mɔ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","'Bʋ mɔ, 'ba nyre 'lɩ 'dɩɔ ‑bɩ 'kwli, ‑hʋʋ', 'kɩ 'lɩ 'kayu ‑bɩ bʋ, 'bʋ ‑hɩa, 'kɩ bʋ 'ble 'a mʋ kʋa, ɛ kɔ, bʋ 'yɛ nɩ pʋ 'a mʋ nʋa yɩ bʋ, ‑ɛ ‑bɩ ba ꞊hɩan ‑mɔ, ba mu. 'Ba yɩ nɩ mi, ‑ɛ ‑bɩ ba bʋbla 'aan bʋɩ, ‑ɛ di꞊e nu, 'waa ‑tʋtʋ a 'pupu 'mʋ 'a mʋ bʋɩ' lɛ ‑hɔn, a 'mʋ꞊ʋ nyibli a 'mʋ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, 'bʋ mɔ, Nyɩsʋa a yrʋ 'bʋ klɔ ꞊nʋ, 'waa ꞊gbɛtʋ nu꞊o 'waa dɩɔnʋ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, ‑nyrɔwɔ ‑kɔ 'kwli Nyɩsʋa di nyibli ‑bati lɛ ‑pʋʋ ‑nɩ, 'dɩɔ a nyibli ‑mʋ', ‑ʋ 'yɩ 'a mʋ kʋa 'ble, 'waa ‑bati di 'nɩ 'yakla ‑nɩ, ɛ 'mʋ 'ʋ Sodɔmʋdɩɔ kɔ Gomɔlɩdɩɔ a nyibli ‑mʋ', ‑ʋ ni la yɩnyre‑tɛblɩ, a ‑nɛ 'ʋ ‑hi.» ");
INSERT INTO ktj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","(‑Yusu 'tɩɛ yɩ 'lɩ 'a ‑nagbopʋ* ‑mɔ ‑hlee ‑nɩ, ɛ wɛn:) «Ba pʋ 'mʋ nʋa yɩ bʋ. 'N yɩ tɛ 'a mʋ bʋ, ꞊wɩ yɩ ‑tɛ ʋ 'yɛ nɩ tɛ wɛn 'lɩ 'blayonʋ ‑jio 'nyɩ. 'A ‑tɩ, ba nɩ 'ʋ ‑pleelɛ', 'kɩ 'ʋ nyibli ‑mʋ', ‑ʋ di 'a mʋ yɩ ‑wɔn a ‑ta', kɛɛ, a 'nɩ 'wɔɔn 'lɩ ꞊nʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ba ꞊tu 'aan dɩɔnʋ 'yie, 'kɩ 'ʋ nyibli a 'mʋ ‑mɔ, ‑ɛ nu꞊o, ʋ kɔ bʋ gba 'lɩ 'a mʋ ‑batipʋʋlɛ', ɛ kɔ, ʋ 'mʋ 'a mʋ lɔkʋɛ ‑bii ‑nɩ, 'kɩ 'lɩ Nyɩsʋa a 'kayo blɛ. ");
INSERT INTO ktj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","‑Tɛ a mɔ 'na ‑nagbopʋ a ‑tɩ, ʋ kɔ bʋ yɛɛ nɛ 'a mʋ ‑tɩ, 'kɩ 'ʋ 'blʋnaanyʋ kɔ 'kɩɩnpʋ ye'. Ɛ nɔ‑ di꞊e nu, a 'mʋ ꞊nʋ 'na ꞊haantitie pʋ, a 'mʋ꞊ʋ nyibli ‑bɩ ‑mʋ' pʋ, ‑ʋ 'yɩ ‑Juukʋɛ* 'pa‑. ");
INSERT INTO ktj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","'Bʋ klɔ 'a mʋ, 'bʋ yɩ 'lɩ 'a mʋ ‑batipʋnyʋ yɩ nɩ gbɛ, 'kla 'nɩ 'yaa 'lɩ 'a mʋ ‑wliye, 'kɩ 'ʋ ‑tɩ ‑mʋ', a di hla, ɛ kɔ, ‑tɛ a di 'a hɩhla nu a ‑ta'. Win ‑mʋ', a di pʋ, ti a 'mʋ 'yri, Nyɩsʋa, nɔ‑ di 'a mɔ꞊ɔ wlɔn ꞊tu. ");
INSERT INTO ktj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ɛ 'yɩ 'aan ꞊gbɛtʋ 'pa‑, a 'nɩ ‑hle꞊e nɩ, kɛɛ, 'aan 'Baɩ Nyɩsʋa a ‑Hihiu*, ‑ɛ nɩ 'ʋ 'a mʋ ke', ɛ nɔ‑ di hle. ");
INSERT INTO ktj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ti a 'mʋ 'yri, 'dɩayɩnʋ, nʋ‑ di 'waa 'dɩayɩnʋ 'blʋnaanyʋ ꞊jɩ' lɛ pʋ, 'waa 'lɩla a ‑tɩ. Dɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ 'baɩnʋ di 'waa 'yonʋ ‑mɔ nu, 'yonʋ 'mʋ꞊ʋ 'waa 'baɩnʋ kɔ 'waa 'diinʋ 'hʋɛn‑ ‑mɔ nu. ");
INSERT INTO ktj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nyibli a pɛpɛ kɔ bʋ yraa nɛ 'a mʋ, ‑tɛ a mɔ 'na nyibli a ‑tɩ. Kɛɛ, nyiblo, 'bʋ nɩ 'ʋ, 'bʋ 'yɩ ‑sa, 'kɩ 'ʋ Nyɩsʋa a ꞊wlʋ a yɩkuolɛ a ‑ta', 'bʋ gba꞊a 'lu ‑mɔ ‑gbagba, 'klɔ a 'ʋ‑hɔnti 'bʋ nyre 'ʋ, nyiblo a 'mʋ, ɛ nɔ‑ Nyɩsʋa di wa. ");
INSERT INTO ktj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ti ‑mʋ' ‑kɔ 'yri ʋ di 'ʋ 'a mʋ ꞊hɩʋɛn ꞊tuu ‑nɩ, 'kɩ 'lɩ 'dɩɔ ‑bɩ 'kwli, ‑ɛ ‑bɩ ba 'gba ci lɛ, ba mu 'lɩ 'dɩɔ ‑bɩ 'kwli. 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba kaa 'lɩ Yisraɛkʋɛ a 'dɩɩ a pɛpɛ 'lɩ, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'mʋ 'lɩ di de. ");
INSERT INTO ktj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ɛ 'yɩ 'nyɩnyɩnyɔ ꞊dʋ ‑kɔ, ‑bʋ di 'ʋ 'a tɔɔnyɔ 'lu yɩ nɩ. Ɛ 'yɩ ‑kʋannunyɔ ꞊dʋ ‑kɔ, ‑bʋ di 'ʋ 'a 'masɛ 'lu yɩ nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","'A ‑tɩ, 'nyɩnyɩnyɔ kɔ ‑kʋannunyɔ 'hʋɛn‑, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ pʋ lɛ, ‑ɛ mɔ, ꞊hɩʋɛndʋ ‑mʋ', 'waa tɔɔnyɔ kɔ 'waa 'masɛ 'hʋɛn‑, ʋ di 'ye, ʋ di 'lɩ꞊ɩ wlɔn 'nɩ ꞊ta. 'Bʋ mɔ, 'mɔ ‑bʋ, ‑ɛ mɔ 'kayu'baɩ, 'bʋ yɩ 'mʋ Bɛsebulɩ (‑ɛ mɔ Satan) nɩ ‑dɛɛ ‑nɩ, ‑ɛ ‑bɩ ba yi꞊e, ‑ɛ mɔ, 'a mʋ ‑mʋ', ‑ʋ mɔ 'na 'kayubʋkʋɛ, 'nyrɛ, ʋ di 'a mʋ ꞊tue, ɛ di nyre yɩ dɩakɩ, ɛ 'mʋ 'ʋ Bɛsebulɩnyrɛ a 'mʋ 'ʋ ‑hi.» ");
INSERT INTO ktj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","(Kɛ‑ ‑Yusu pɩ 'a ‑nagbopʋ* yɩ de, ɛ wɛn:) «'A ‑tɩ o, nyibli a 'mʋ, ‑ʋ di 'a mʋ ꞊hɩʋɛn ꞊tu, a 'nɩ 'pie 'lɩ 'waa hʋannʋ, ‑ɛ nu꞊o, ti di 'ʋ 'nɩ nyre, ‑ɛ kɔ 'yri ‑tɩ a ‑tɛɛ di 'ʋ pepe' bi, ɛ kɔ, ‑tɛblɩ nɩ ‑tie ‑mʋ', ‑ʋ ‑hli kɛ, nyibli a pɛpɛ 'mʋ꞊ʋ yi. ");
INSERT INTO ktj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","'Bʋ mɔ, ꞊ba bii yɩ, ‑tɩ ‑bʋ, 'n yɩ 'a mʋ ‑lee ‑nɩ, ba hla 'ʋ꞊ʋ ‑tɩtɛ ‑mʋ', nyibli a pɛpɛ ‑wɛ 'lɩ bʋ 'wɩɩn 'ʋ꞊ʋ. ‑Tɩ ‑bʋ, 'n yɩ 'lɩ bʋ ‑blee ‑nɩ, 'n yɩ 'a mʋ ‑lee ‑nɩ, ba lee ꞊nɛ nyibli a pɛpɛ. ");
INSERT INTO ktj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","A 'nɩ 'pie 'lɩ ‑tonyibli a hʋannʋ, ‑kɔtɩ 'aan ‑plahʋɩ nɩ ‑do, ɛ nɔ‑ ʋ ‑wɛ 'lɩ bʋ ‑wɛ bʋ, kɛɛ, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑wɛ 'aan ‑hihiu bʋ. Nyɩsʋa, ɛ nɔ‑ kɔ hʋannʋ ba pie, ‑ɛ nu꞊o, ɛ nɔ‑ ‑wɛ 'lɩ ‑bʋ ‑wɛ ‑tonyiblo a ‑plahʋɩ kɔ 'a ‑hihiu 'hʋɛn‑ bʋ, 'kɩ 'lɩ na ‑mʋ', ‑ɛ 'yɛ nɩ jre 'nyɩ, 'klɔ ‑mɔ 'klɔ, ‑ɛ yɩ ‑tɛblɩ‑hʋɩnnunyʋ bʋ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","꞊Bʋ pʋʋ ꞊nɛ nʋblɩ 'cɩmɩ a dɛ yɩ: 'Bʋ mɔ, ꞊nɩ yɩ ꞊nʋ nɩ ‑tʋɛ, ʋ 'nɩ ‑pʋ꞊ʋ ꞊die dɩakɩ, kɛɛ, 'aan 'Baɩ Nyɩsʋa 'bʋ 'yɩ꞊ɩ kɩ ‑wɛn, a 'yɛɛ ꞊dʋ 'nɩ 'kʋ꞊ʋ lɩ. ");
INSERT INTO ktj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kɛɛ, 'a mʋ ‑mɔ ‑bɩ, 'lunyapli nɩ ‑tie ‑bʋ, a ‑kɔ, 'aan 'Baɩ Nyɩsʋa ‑hre꞊e nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ɛ ꞊hɛn 'nyrɛ, ‑ɛ mɔ, a kɔ 'mini dɩakɩ, 'kɩ 'ʋ Nyɩsʋa ye', 'a ‑hi 'ʋ nʋblɩ ‑hʋɔhʋɩ ‑mʋ' 'ʋ. 'A ‑tɩ, a 'nɩ 'pie 'lɩ ‑tonyibli a hʋannʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«'A ‑nɛ nyiblo, ‑ɛ di꞊e hla, 'kɩ 'ʋ nyibli ye', ‑ɛ mɔ, ɛ mɔ 'na nyiblo ꞊nɩɔ, 'na 'mumu, ‑tɛ ‑batipʋ‑nyrɔwɔ di 'ʋ nyre, 'n di꞊e 'nɩ hla ‑wɛ, 'kɩ 'ʋ 'na 'Baɩ Nyɩsʋa, ‑ɛ nɩ 'lɩ yakɔ 'kwli ye', ‑ɛ mɔ, nyiblo a 'mʋ, ɛ mɔ 'na nyiblo ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kɛɛ, nyiblo 'bʋ hla꞊a, 'kɩ 'ʋ nyibli ye', ‑ɛ mɔ, ɛ 'yɩ 'mʋ ‑yi, 'na 'mumu, ‑batipʋ‑nyrɔwɔ 'bʋ nyre 'ʋ, 'n di꞊e 'nɩ hla ‑wɛ, 'kɩ 'ʋ 'na 'Baɩ Nyɩsʋa, ‑ɛ nɩ 'lɩ yakɔ 'kwli ye', ‑ɛ mɔ, 'n 'yɩ꞊ɩ ‑yi.» ");
INSERT INTO ktj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«A 'nɩ 'yee 'lɩ꞊ɩ, ‑ɛ mɔ, kɩbʋwɛɛnlɛ 'n ya 'nɛ‑ ‑tʋtʋ kɩ. 'N di nɩ, ‑ɛ di꞊e nu, nyibli 'mʋ yɩ ‑wʋnwɔn ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","'N di nɩ, ‑ɛ di꞊e nu, 'yu nyɩbɛhɩan 'mʋ 'a 'baɩ yɩ ‑wɔn, ɛ kɔ, 'yu nyrɔyu 'mʋ 'a 'dii yɩ ‑wɔn, ɛ kɔ, 'yu a nʋgba 'mʋ 'a 'dɔɔ yɩ ‑wɔn ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ɛ ꞊hɛn 'nyrɛ, ‑ɛ mɔ, nyiblo 'bʋ nɩ 'ʋ, 'a yraanyibli di mɔ 'a dɩɔnʋ a 'kayubʋkʋɛ. ");
INSERT INTO ktj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nyiblo 'bʋ nʋɛ nɛ 'a 'dii kɔ 'a 'baɩ 'hʋɛn‑ a dɛ, 'bʋ ‑hi 'ʋ 'mʋ, ‑ɛ ‑bɩ ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ mɔ 'na nyiblo. Nyiblo 'bʋ nʋɛ nɛ 'a 'yonʋ a dɛ, 'bʋ ‑hi 'ʋ 'mʋ, ‑ɛ ‑bɩ ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ mɔ 'na nyiblo. ");
INSERT INTO ktj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nyiblo 'bʋ 'yɛ nɩ ꞊tuu 'ʋ 'na win 'ʋ, 'ye ꞊bɩɩ ɛ ‑wɛn, 'kɩ bʋ 'la꞊a 'na ‑tɩ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ mɔ 'na nyiblo. ");
INSERT INTO ktj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nyiblo 'bʋ 'yɛ nɩ ‑hʋa bʋ 'waan nɛ 'a dɩɔnʋ a ‑hʋnhlʋn, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, 'kɩ 'ʋ 'na ‑ta', 'bʋ mɔ, nyiblo a 'mʋ 'bʋ 'kʋ, ɛ di 'a 'klɔ yrayrʋ 'nɩ 'waan ‑nɩ, 'kɩ 'lɩ Nyɩsʋa yɩ. Kɛɛ, nyiblo 'bʋ ‑wɛn, 'kɩ 'a dɩɔnʋ a ‑hʋnhlʋn bʋ 'wan, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, ‑tɛ ɛ nʋɛ 'mʋ a ‑tɩ, 'bʋ mɔ, nyiblo a 'mʋ 'bʋ 'kʋ, ɛ di kɔ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ, 'kɩ 'lɩ Nyɩsʋa yɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Nyiblo 'bʋ 'ble 'a mʋ kʋa, 'a mʋ ‑mʋ', ‑ʋ mɔ 'na ‑nagbopʋ*, ɛ ꞊hɛn 'nyrɛ, 'mɔ ɛ 'ble kʋa. 'Tɩ‑, nyiblo ‑di 'mʋ kʋa 'ble, ɛ 'wɩ yɩ, na 'Baɩ Nyɩsʋa ‑mʋ', ‑ɛ lee 'nɛ‑ 'mʋ, ɛ nɔ‑ ɛ 'ble kʋa. ");
INSERT INTO ktj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","'Bʋ mɔ, ꞊nɩ 'ble Nyɩsʋa a winwlɔn‑hanyɔ* kʋa, ‑tɛ ɛ mɔ Nyɩsʋa a winwlɔn‑hanyɔ a ‑tɩ, 'wio ‑mʋ', Nyɩsʋa di wɛn 'a winwlɔn‑hanyɔ a 'mʋ ‑nyi, ɛ nɔ‑ ɛ di ‑mʋ ‑nyi ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mɔ, 'na nyiblo nɩ ‑do ‑bʋ, 'ye ꞊bɩɩ ɛ 'yɩ 'mini ‑kɔ, ꞊nɩ ‑ha 'lɩ 'nɩcɛ a ‑ŋanʋwɔ nɩ ‑do, ꞊nɩ ‑nyi ꞊nɛ꞊ɛ, ‑tɛ ɛ mɔ 'na ‑nagbopi a ‑tɩ, ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, Nyɩsʋa, ɛ nɔ‑ di ‑mʋ 'wio ‑nyi.» ");
INSERT INTO ktj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","‑Tɛ ‑Yusu ‑wɛ 'a ‑nagbopʋ* nɩ ‑pu ꞊tu 'ʋ 'hʋɛn ‑mʋ', 'waa tɔɔlɛ ‑mɔ, ‑ɛ ‑bɩ ɛ ‑hɔn 'ʋ ‑tɩtɛ a 'mʋ nɩ, 'ɛ mu 'lɩ 'blʋgba a 'mʋ a 'dɩɩ ‑bɩ 'kwli, 'ɛ mu Nyɩsʋa a ‑tɩ nyibli ‑bɩ lee mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ti a 'mʋ 'yri, Saan, ‑ɛ pɩ la nyibli 'nie 'lu lɛ, 'kɩ ɛ nɩ 'lɩ ꞊jɩ', 'ɛ 'wɩn ‑kʋan ‑mʋ', ‑Yusu ni a ‑tɩ. Ɛ nɔ‑ kɔ ‑tɩ 'ɛ lee nɛ 'a ‑nagbopʋ ‑bɩ, ɛ wɛn: «Ba mu, ba 'bɛti꞊e, ");
INSERT INTO ktj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","꞊bɩ ɛ nɔ‑ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ‑a mʋ yɩ ya, ‑ʋ'ʋ‑ ‑a 'tɩɛ di Wanyɔ a 'mʋ ‑ple?» ");
INSERT INTO ktj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","‑Tɛ Saan a ‑nagbopʋ 'bɛti꞊e, kɛ‑ ɛ ‑pʋ, 'ɛ ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «Ba mu, ‑tɩ ‑bʋ, a yɩ 'wɩn, ɛ kɔ ‑tɛblɩ a yɩ 'ye, ɛ nɔ‑ kɔ ‑tɩ ba lee Saan. ");
INSERT INTO ktj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ba lee ꞊nɛ, ‑ɛ mɔ, 'yii'dɔnyʋ tɛ lɛ, lɛ‑yɩyrɛnyʋ 'ʋ nɛ, ꞊hrannunyʋ a 'kʋɛ yɩ 'nɩ ‑wɛ, 'kikenyʋ 'ʋ yɩ ‑tɩ 'wɩn, kɔ, 'kʋkʋnyibli yɩ 'hrɩ 'klɔ lɛ, ꞊hɩʋɛnnyibli 'ʋ yɩ Nyɩsʋa a ꞊haantitie 'wɩn. ");
INSERT INTO ktj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Plɔ a bleelɛ 'kɩ 'ʋ nyiblo ‑mʋ' ‑mɔ, ‑ɛ 'yɛ nɩ hɩa, 'kɩ bʋ kuo 'mʋ ꞊wlʋ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","‑Tɛ Saan a ‑nagbopʋ a 'mʋ, ʋ ꞊hɩan ‑mɔ, ‑ɛ ‑bɩ ‑Yusu ‑tʋa Saan a ‑tɩ a kɩhleelɛ, 'kɩ 'ʋ nyibli ‑mʋ', ‑ʋ ꞊gbee 'ʋ꞊ʋ 'hʋɩ a ‑ta', ɛ wɛn: «‑Tɛ Saan hlɛ la Nyɩsʋa a ‑tɩ, 'kɩ 'lɩ ‑tɩtɛ ‑mʋ', nyiblo ꞊dʋ 'yɩ 'lɩ 'ti, ‑tɛ a mu la 'lɩ꞊ɩ ‑mɔ, nyiblo a 'dɩ ‑bɩ 'aan ꞊wlɩ pʋ la lɛ, a di la 'lɩ bʋ ‑yɛɛ ‑nɩ 'lɩ? ꞊Bɩ 'aan ꞊wlɩ wɛn 'nɩ, nyiblodʋ ‑bʋ, ‑ɛ yɩ hʋannʋ pie, 'kɩ bʋ lee nyibli ‑tɩ a ‑tɛɛ, ɛ nɔ‑ a di la 'lɩ bʋ ‑yɛɛ ‑nɩ? 'Ʋʋn‑, ɛ 'yɩ 'a nyiblodʋ a 'mʋ 'pa‑. ");
INSERT INTO ktj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","꞊Bɩ 'aan ꞊wlɩ 'ye꞊e nɩ, ‑ɛ mɔ, a di yɛɛ la 'lɩ nyiblo, ‑ɛ pʋ yɩnɔwlawlʋ bʋ? Nyibli ‑mʋ', ‑ʋ pɩ yɩnɔwlawlɩ, 'kɩ ʋ nɩ 'lɩ 'kɩɩnpʋ a 'kayo blɛ. ");
INSERT INTO ktj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","꞊Bʋ 'bɛti 'a mʋ de: Nyiblo a 'dɩ ‑bɩ a mu la 'ye mɔ 'lɩ? ꞊Bɩ Nyɩsʋa a winwlɔn‑hanyɔ*? Iin, 'n yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ɛ kɔ, 'nɩ hlɛ꞊ɛ, ‑ɛ mɔ, Saan ‑hi 'ʋ Nyɩsʋa a winwlɔn‑hanyʋ ‑bɩ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ɛ nɔ‑ mɔ nyiblo ‑mʋ', ‑kɔtɩ ʋ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ, ɛ nɔ‑ di la 'na 'hru yɩ kla, 'tɩ‑ 'mʋ la 'lɩ di. ‑Tɩ a 'mʋ, ʋ 'crɩ la, ɛ nɔ‑ ‑bʋ: Nyɩsʋa wɛn 'nɩ: 'Na 'Yu o, 'n di ‑ha nyiblo, 'kɩ 'ʋ 'na ‑kʋan a ‑ta', ɛ 'mʋ mu, ɛ 'mʋ ‑na 'hru yɩ kla, 'tɩ‑ ꞊mʋ 'lɩ nyre. ");
INSERT INTO ktj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, 'kɩ 'lɩ ‑tonyibli a pɛpɛ 'nyɩ, ɛ 'yɩ ‑hʋan nyiblo ꞊dʋ nɩ kʋɛ, ‑bʋ nɩ 'ʋ Saan Batisɩ 'lu yɩ. Kɛɛ, 'kɩ 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli, nyiblo ‑mʋ', ʋ dɛɛ 'hɩangbe, ɛ nɔ‑ di 'ʋ Saan 'lu yɩ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kʋɛ la 'lɩ ti ‑mʋ', ‑ɛ kɔ 'yri Saan Batisɩ ‑tʋa la 'lɩ Nyɩsʋa a ‑tɩ a ‑mɔlɛnɩna 'yie bʋ, 'kɩ Nyɩsʋa ‑tʋa la 'lɩ nyibli a win a kɩkɔɔlɛ, kɛɛ, Nyɩsʋa a yraanyibli ꞊tui 'ʋ 'klɩ, ‑ɛ di꞊e nu, nyibli 'nɩ ꞊ha 'ʋ Nyɩsʋa 'ʋ ꞊tuu ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tete ‑mʋ', Nyɩsʋa ‑nyi la Moise, kɔ Nyɩsʋa a winwlɔn‑hanyʋ a pɛpɛ 'hʋɛn‑, kʋɛ la 'lɩ bʋ, ‑bʋ yɛ Saan Batisɩ a ti kɩ, ʋ hlɛ la꞊a nɩ, ‑ɛ mɔ, ɛ di kɔ la ti, ‑ɛ kɔ 'yri Nyɩsʋa di la 'ʋ nyibli win kɩ ‑kɔɔ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nyɩsʋa a win hlɛ꞊ɛ nɩ, ‑ɛ mɔ, winwlɔn‑hanyɔ Eli di la 'lɩ 'nɩ di. ꞊Bɩ a kuo ꞊nɛ ꞊wlʋ yɩ, ꞊bɩ a 'yɩ꞊ɩ ꞊wlʋ yɩ ‑kuo ‑nɩ? Dɛ 'n yɩ 'a mʋ ‑lee ‑nɩ, ɛ nɔ‑ mɔ Saan Batisɩ, ɛ nɔ‑ mɔ Eli a 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","'Ba kɔ ‑tɩ'wɩnnʋa, ‑ɛ ‑bɩ ba 'wɩn ‑tɩ ‑dodo. ");
INSERT INTO ktj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","‑Tɛ ti ‑bʋ 'yri a nyibli nɩ 'mʋ, ɛ nɔ‑ ‑bʋ: Ʋ 'wɩ‑ 'yonʋ yɩ, ‑ʋ yɩ hru 'mle, 'kɩ 'ʋ 'dika, ‑ʋ ‑bɩ yɩ yɛɛ 'waa 'bio ‑tɩ, ʋ wɛn: ");
INSERT INTO ktj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‑Tɛ ‑a yɩ 'blɩ nɩ pʋɛ, ‑a yɩ 'blɩpa‑wla ble, a 'yɩ ‑wla yi mɔ ‑di. 'Tɩ‑, ‑tɛ ‑a yɩ ꞊hien nɩ we, a 'yɩ nyaɩŋmlɩ lɛ ‑nu. ");
INSERT INTO ktj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ɛ 'wɩ yɩ, ‑tɛ Saan ‑di, ɛ yɩ ꞊ci*, 'kɩ 'ʋ Nyɩsʋa a dɩda a ‑ta', 'ɛ 'yɛ nɩ 'na nɔ, kɛɛ, kɛ‑ ‑tonyibli pɩ la: 'Ku ‑hʋan* nɩ 'ʋ꞊ʋ ke'. ");
INSERT INTO ktj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","'Mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, ‑tɛ 'n ‑di, 'nɩ ꞊ci꞊e lɩ, 'tɩ‑ 'nɩ 'nɛ nɔ, kɛɛ, kɛ‑ nyibli pɩ: Ba 'ye nyiblo ‑bʋ, dididɛ kɔ nɔ a 'nɩna nɩ ‑do, ɛ nɔ‑ ɛ yɩ 'lu ‑mɔ lɛ ‑hie. 'Blʋwli'tɩnyʋ kɔ nyibli ‑bʋ, ‑ʋ kɔ 'klɔ ꞊yɩ 'ʋ yɩ 'sii ‑nɩ, ʋ nʋ‑ kɔ꞊ɔ 'hʋɛn‑, ‑ʋ ni nɩnatumudɛ.» ‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ de: «Nyibli ‑mʋ', ‑ʋ kɔ Nyɩsʋa a ꞊tɔ, 'waa nunu‑tɛblɩ di꞊e nyibli 'nɩ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, Nyɩsʋa a ꞊tɔ a 'mʋ, ɛ 'sii 'ʋ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","'Dɩɩ ‑mʋ', ‑ɛ kɔ 'kwli ‑Yusu nuu 'lɩ ꞊wlɩlɛkɛɛ‑tɛblɩ ‑hʋɔhʋɩ, ‑ɛ ‑hi 'ʋ 'dɩɩ ‑bɩ 'mʋ 'ʋ, 'waa nyibli 'yɩ 'ʋ dɛ 'kuku bʋ ‑hie. Ɛ nɔ‑ kɔ ‑tɩ 'ɛ ‑tʋa 'waa ‑tɩ a yɛɛlɛ, 'kɩ 'ʋ nyibli ‑mʋ', ‑ʋ nɩ 'ʋ ye', ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«‑Juukʋɛ* ‑mʋ', ‑ʋ nɩ 'lɩ Kolasɛdɩɔ kɔ Bɛtɩsaidadɩɔ 'kwli, 'jrɔ 'kɩ 'ʋ ꞊nʋ ‑mɔ, ‑ɛ nu꞊o, ꞊wlɩlɛkɛɛ‑tɛblɩ ‑mʋ', 'n nuu 'lɩ ꞊nʋ ‑mɔ, 'bʋ mɔ, 'nɩ nuu wɛn 'lɩ꞊ɩ nyibli ‑mʋ', ‑ʋ 'yɩ ‑Juukʋɛ 'pa‑ ‑mɔ, ‑ʋ nɩ 'lɩ Tilɩdɩɔ kɔ Sidɔdɩɔ 'hʋɛn‑ 'kwli, see la, nyibli a 'mʋ, ʋ 'mʋ la nyaɩŋmlɩ lɛ nu, ʋ 'mʋ la ‑tɛblɩ ‑hʋɩn 'hʋɩ lɛ pʋ, ʋ 'mʋ la 'waa dɩɔnʋ 'tɔpupu 'ŋmlɛ, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ nyibli yɩ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, ʋ ‑hʋɛ bʋ hie 'ʋ 'waa dɛ 'kuku a nunuo bʋ, ʋ 'mʋ 'waa 'klɔ Nyɩsʋa ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, ‑nyrɔwɔ ‑kɔ 'kwli Nyɩsʋa di 'ʋ nyibli ‑bati lɛ ‑pʋʋ ‑nɩ, nyibli ‑mʋ', ‑ʋ nɩ 'lɩ Kolasɛdɩɔ kɔ Bɛtɩsaidadɩɔ a 'mʋ 'kwli, 'waa ‑bati di nɩ 'klɩ kɩ, ɛ 'mʋ 'ʋ Tilɩdɩɔ kɔ Sidɔdɩɔ a ‑nɛ 'ʋ ‑hi. ");
INSERT INTO ktj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","'Tɩ‑ nyibli ‑mʋ', ‑ʋ nɩ 'lɩ Kapɛnaɔdɩɔ 'kwli, ʋ 'nɩ 'hie 'lɩ꞊ɩ 'lu ‑mɔ lɛ, ‑ɛ mɔ, Nyɩsʋa di 'lɩ ꞊nʋ 'nɩ 'yaa ‑nɩ ‑yaya, ʋ 'mʋ mu ‑mumu, ʋ 'mʋ yakɔ yɩ kʋɛ. Kɛɛ, ɛ kɔ bʋ ꞊tɩɔ 'lɩ ꞊nʋ ‑tɩɔtɩɔ, ʋ 'mʋ 'lɩ ‑tʋtʋ a ‑wlubʋ nyre. ꞊Wlɩlɛkɛɛ‑tɛblɩ ‑mʋ', 'n nuu 'lɩ ꞊nʋ ‑mɔ, 'bʋ mɔ, 'nɩ nuu wɛn 'lɩ꞊ɩ Sodɔmʋdɩɔ a nyibli ‑mɔ, ‑ʋ kɔ 'klɔ nyre yɩ, nyibli a 'mʋ, ʋ di hie wɛn 'ʋ 'waa dɛ 'kuku a nunuo bʋ, Nyɩsʋa 'nɩ ‑wɛ꞊ɛ wɛn ꞊nʋ bʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, ‑nyrɔwɔ ‑mʋ', ‑ɛ kɔ 'kwli Nyɩsʋa di 'ʋ nyibli ‑bati lɛ ‑pʋʋ ‑nɩ, ‑Juukʋɛ ‑mʋ', ‑ʋ nɩ 'lɩ Kolasɛdɩɔ kɔ Bɛtɩsaidadɩɔ 'kwli, ɛ di ꞊tu ꞊nʋ ꞊hɩʋɛn, ɛ 'mʋ 'ʋ Sodɔmʋkʋɛ 'ʋ ‑hi, ‑ʋ kɔ nunuklɔ ‑nyre la yɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ti a 'mʋ 'yri, kɛ‑ ‑Yusu pɩ, ɛ wɛn: «'Na 'Baɩ o, ‑mɔ mɔ yakɔ kɔ ‑tʋtʋ 'hʋɛn‑ a Kʋkɔnyɔ. 'N pɩ ‑mʋ 'nyrɛ lɛ, ‑tɛ ‑nu, ꞊nɩ ‑hli ‑na nunu‑tɛblɩ ꞊tɔkɔnyʋ kɔ 'crɩɛn.yinyʋ 'hʋɛn‑ 'yi kɩ, 'tɩ‑ ꞊nɩ tɔɔ ꞊nɛ nyibli ‑bʋ, ‑ʋ 'yɩ ꞊dedede ‑yi. ");
INSERT INTO ktj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","'N pɩ ‑mʋ 'nyrɛ lɛ, ‑ɛ nu꞊o, kɛ‑ ‑nu 'a ‑hʋhʋa. ");
INSERT INTO ktj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","'Na 'Baɩ ‑nyi 'mʋ 'klɩ, 'kɩ 'ʋ ‑tɛblɩ a pɛpɛ kɩ. Nyiblo a 'dɩ ‑bɩ 'n pa 'mʋ, nyibli 'yɩ꞊ɩ ‑yi, 'bʋ 'yɩ 'na 'Baɩ nɩ ‑do 'pa‑. Ʋ 'yɩ꞊ɩ ‑yi ‑wɛ, nyiblo a 'dɩ ‑bɩ 'na 'Baɩ ‑mɔ, 'bʋ 'yɩ 'mɔ nɩ ‑do ‑bʋ, ‑ɛ mɔ 'a 'Yu 'pa‑. 'A ‑nɛ nyiblo, 'n ‑hʋɛ ꞊bʋ tɔɔ ꞊nɛ, ɛ yi꞊e nɩ ‑wɛ, nyiblo a 'dɩ ‑bɩ 'na 'Baɩ pa 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","'A mʋ ‑mʋ', ‑ʋ kɔ 'klɩ ‑wɛ 'lɩ, 'kɩ 'ʋ blɛ a 'buble a ‑ta', ba di 'nɛ‑ 'mʋ ‑mɔ, 'mʋ 'a mʋ ‑hɛɛ ‑nɩ, 'mʋ꞊ʋ nu, a 'mʋ ‑wle. ");
INSERT INTO ktj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","'N 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ ꞊tu 'a mʋ ꞊hɩʋɛn, ɛ kɔ, 'nɩ 'yaa꞊a 'lɩ 'na dɩɔnʋ. Ba wɛɛn ꞊nɛ kɩ, 'kɩ ꞊bʋ mɔ 'aan naanyɔ, ‑ɛ di꞊e nu, 'mʋ 'a mʋ ‑tɔɔ ‑nɩ. 'Bʋ mɔ, 'ba wɛɛn ꞊nɛ kɩ, 'n di ‑nyi 'a mʋ ꞊haan'klɔ. ");
INSERT INTO ktj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","‑Tɩ ‑mʋ', 'n di 'a mʋ ‑tɔɔ ‑nɩ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ kla 'mʋ, 'kɩ 'ʋ 'a mʋ ‑mɔ, ɛ kɔ, blɔ ‑mʋ', 'n di 'a mʋ hlɛ, ɛ di 'nɩ 'huhue ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","‑Tɛ ti gbi ‑hi, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ mu lɛ na mɔ. ‑Nyrɔwɔ a 'mʋ, ‑ɛ mɔ la ‑wuwle‑nyrɔwɔ ꞊nɩɔ. 'Kanʋ ni la 'a ‑nagbopʋ nɩ. Bʋ nɩ la 'lɩ mumuo 'kwli, ‑ɛ ‑bɩ ʋ yɩ 'bɛɛ la 'lɩ 'dʋdɔ‑tɛblɩ ꞊dʋ, ‑ʋ 'wɩ ‑kʋbʋ yɩ a ‑ci 'kwli ꞊tɩɔ. ‑Tɛblɩ a 'mʋ, ɛ nɔ‑ kɔ blɩ gbi 'a ‑nagbopʋ yɩ 'cɛ, 'ʋ yɩ 'a 'yɔ di. ");
INSERT INTO ktj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","'Kɩ 'lɩ ‑ci a 'mʋ 'kwli, 'kɩ Falisi꞊tumu* a nyibli nɩ 'lɩ. ‑Tɛ ʋ 'ye 'kɩ dɛ a 'mʋ, ‑ɛ mi 'lu ‑mɔ, ‑ɛ ‑bɩ kɛ‑ ʋ pɩ, 'ʋ yɩ ‑Yusu ‑lee ‑nɩ, ʋ wɛn: «'Ye kɛ dɛ ‑na ‑nagbopʋ ni, ɛ ꞊ŋa nɩ. Nyɩsʋa a tete wɛn 'nɩ: Nyiblo ꞊dʋ 'nɩ 'nuo 'lɩ ‑kʋan, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","‑Ɛ ‑bɩ ɛ ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «‑Tɩ ‑mʋ', ʋ 'crɩɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, 'kɩ 'ʋ ‑aan 'baɩ gbagbʋ, ‑ɛ mɔ bodɩɔ Dafidɩ a ‑ta', 'n pʋ꞊ʋ ꞊haan‑tɩ, ‑ɛ mɔ, a ‑hre꞊e nɩ. ‑Tɩ a 'mʋ, ʋ 'crɩ la, ɛ nɔ‑ ‑bʋ: ‑Nyrɔwɔ ꞊dʋ, ‑tɛ 'kanʋ ni la bodɩɔ Dafidɩ ɛ kɔ 'a nyibli 'hʋɛn‑, ");
INSERT INTO ktj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ɛ pa la 'lɩ Nyɩsʋa a 'kayu bʋ, 'ɛ ‑ha la 'lɩ 'flɔɔ ‑mʋ', ‑ɛ pɛ la 'ʋ 'teble kɩ bʋ, 'ɛ di la꞊a. ‑Ɛ kɔ ‑ta' Nyɩsʋa a tete wɛn 'nɩ, Nyɩsʋa a ‑cɔhlʋnpinyʋ* nɩ ‑do, ʋ nʋ‑ ‑wɛ 'lɩ, ‑bʋ di 'flɔɔdʋ a 'mʋ. 'Bɩ 'flɔɔdʋ a 'mʋ, ‑ɛ nɩ 'lɩ Nyɩsʋa a 'kayu a 'mʋ bʋ, ʋ ‑ha la꞊a nɩ, 'kɩ 'ʋ Nyɩsʋa a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","'Ya 'ʋ 'lu de, 'n pʋ꞊ʋ ꞊haan‑tɩ, ‑ɛ mɔ, a ‑hre dɛ ‑bʋ, Moise 'crɩɩ la 'lɩ 'a tetecrɩɛn 'kwli nɩ. Dɛ a 'mʋ, ɛ nɔ‑ ‑bʋ: 'Kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli, Nyɩsʋa a ‑cɔhlʋnpinyʋ ni ‑kʋan, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ. 'A ‑tɩ, ʋ 'nɩ ꞊tuu꞊o 'ʋ ‑wuwle‑nyrɔwɔ a tete. Kɛɛ, nyiblo ꞊dʋ 'nɩ ‑yɛɛ꞊ɛ lɩ ꞊nʋ ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, nyiblo ‑bʋ, ‑ɛ nɩ mɔ, ɛ 'bʋa nɩ, 'ɛ ‑hi 'ʋ Nyɩsʋa a 'kagbaʋ 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kɛ‑ Nyɩsʋa pɩ 'lɩ 'a 'crɩɛn 'kwli, ‑ɛ mɔ: Dɛ 'n ‑hʋɛ 'a mʋ, ɛ nɔ‑ mɔ, ba kɔ nyibli a nyaɩ, 'ɛ ‑hi 'ʋ ba pie 'mʋ 'wlugba‑tɛblɩ a ‑cɔhlʋn*. Dɛ ‑mʋ', windɛ a 'mʋ, ɛ ꞊hɛn 'nyrɛ, 'bʋ mɔ, 'ba yru wɛn꞊ɛ' lɛ, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba pʋ wɛn lɛ, ‑ɛ mɔ, nyibli ‑mʋ', ‑ʋ 'yɩ dɛ ‑hʋan ꞊dʋ ‑nu, ʋ mɔ dɛ'kukununyʋ ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","'Mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, Nyɩsʋa lee 'nɛ‑ 'mʋ nɩ, 'ɛ ‑nyi 'mʋ 'klɩ, 'kɩ ꞊bʋ lee nɛ 'a ‑nɛ nyiblo ꞊dʋ dɛ, ɛ ‑wɛ 'lɩ bʋ nu, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","‑Tɛ ‑Yusu ‑yrɛ, ‑ɛ ‑bɩ ɛ ‑hɔn 'ʋ ‑tɩtɛ a 'mʋ nɩ, 'ɛ mu 'lɩ Nyɩsʋa a 'kayu bʋ. ");
INSERT INTO ktj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","'Kɩ ɛ yɛɛ 'lɩ nyɩbɛhɩan ꞊dʋ bʋ. Nyɩbɛhɩan a 'mʋ, 'a dabʋ 'kʋ nɩ. Falisi꞊tumu* a nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, ʋ ‑hʋɛ꞊ɛ nɩ, 'kɩ bʋ yɛɛ ‑Yusu ‑tɩ, 'bʋ mɔ, 'bʋ kɔ bʋ nu꞊o, nyɩbɛhɩan a 'mʋ a 'kʋɛ bʋ ‑wɛ, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli. (Falisi꞊tumu a nyibli wɛn 'nɩ, 'bʋ nu꞊o, nyiblo a 'kʋɛ bʋ ‑wɛ, ɛ mɔ ‑kʋandɛ ꞊nɩɔ, ‑ɛ kɔ ‑ta' Nyɩsʋa a tete wɛn 'nɩ, nyiblo 'nɩ 'nuo 'lɩ ‑kʋan, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli.) Ɛ nɔ‑ kɔ ‑tɩ 'ʋ 'bɛti꞊e, ʋ wɛn: «‑Bɩ' Nyɩsʋa a tete pɩ 'lɩ? ꞊Bɩ ɛ hlɛ꞊ɛ nɩ, ‑ɛ mɔ, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli, nyiblo ‑wɛ 'lɩ bʋ pɩa 'hʋɩhrennyʋ nɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «꞊Bɩ 'a mʋ ‑mɔ ‑bɩ, a 'nɩ ‑nu꞊o ‑kʋan, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli? 'Kɩ 'lɩ 'a mʋ 'nyɩ, nyiblo 'bʋ nɩ 'lɩ, 'bʋ kɔ blablɛ, 'tɩ‑ 'a blablɛ a 'mʋ, 'bʋ bi 'lɩ 'niebutɩɔ 'kwli, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli, ꞊bɩ nyiblo a 'mʋ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑ha 'lɩ 'a blablɛ a 'mʋ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ɛ kɔ ‑ta' ‑tonyiblo ‑hi 'ʋ blablɛ nɩ. 'A ‑tɩ, Nyɩsʋa a tete hlɛ꞊ɛ nɩ, ‑ɛ mɔ, ɛ nɔɔ 'ʋ lɛ, 'kɩ ‑tonyiblo bʋ nu 'a 'bɩhɩan ꞊haandɛ ‑mɔ, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ* 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ 'kɩ nyɩbɛhɩan a 'mʋ yɩ, ɛ wɛn 'nɩ: «Hrʋ ‑na dabʋ ‑mʋ', ‑ɛ 'kʋ!» Bʋ hrʋ 'kɩ 'a dabʋ a 'mʋ, ‑ɛ ‑bɩ ɛ 'hrɩ 'klɔ, 'ɛ bi 'ʋ 'a ‑ta', ‑wɛn dabʋ ‑bɩ ‑mʋ'. ");
INSERT INTO ktj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","‑Tɛ ‑Yusu nu꞊o, nyiblo a 'mʋ a 'kʋɛ ‑wɛ, ‑ɛ ‑bɩ Falisi꞊tumu a nyibli a 'mʋ, ʋ ‑hɔn 'ʋ ‑tɛ a 'mʋ nɩ, 'ʋ mu 'hra pa mɔ, ‑tɛ ‑mʋ' ʋ di ‑Yusu a 'lɩla nu, 'ʋ mu 'a ꞊tɔ lɛ ꞊mʋɔ mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","‑Yusu yi dɛ ‑mʋ', ʋ ‑hʋɛ bʋ nu꞊o ‑mɔ nɩ. Ɛ nɔ‑ kɔ ‑tɩ 'ɛ ‑hɔn 'ʋ ‑tɛ a 'mʋ ‑wlu. ‑Tɛ ɛ yɩ nɩ mi, ‑ɛ ‑bɩ nyibli ‑hʋɔhʋɩ kʋɛ꞊ɛ ꞊wien, nyibli a pɛpɛ ‑mʋ', ‑ʋ nɩ 'lɩ ꞊nʋ 'nyɩ, ‑ʋ kɔ 'hʋɩ ‑yɩ hren, 'ɛ nu꞊o, 'waa 'kʋɛ 'ɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kɛɛ, kɛ‑ ɛ ni, 'ɛ yɩ ꞊nʋ ti, ‑ɛ mɔ, ʋ 'nɩ 'lee 'lɩ nyiblo ꞊dʋ, nyiblo a 'dɩ ‑bɩ ɛ pa 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ɛ hla꞊a nɩ, ‑ɛ di꞊e nu, ‑tɩ ‑mʋ', Nyɩsʋa a winwlɔn‑hanyɔ Esai 'crɩ la, ti ‑hi la a ti 'yri, ɛ 'mʋ 'lu ‑mɔ mu. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: ");
INSERT INTO ktj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Nyɩsʋa wɛn 'nɩ: 'Ye nyiblo ‑bʋ, ɛ nɔ‑ mɔ 'na ‑kʋannunyɔ. Ɛ nɔ‑ 'n ‑ha 'lɩ, 'kɩ bʋ nu 'na ‑kʋan. Nyiblo a 'mʋ, 'n nʋɛ ꞊nɛ nɩ, 'ɛ nie 'mʋ dɔdʋ. 'N di꞊e 'nɩ nu, 'na ‑Hihiu* 'mʋ 'ʋ꞊ʋ ke' bi. Nyibli ‑mʋ', ‑ʋ 'yɩ ‑Juukʋɛ* 'pa‑, ɛ di ꞊nʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, 'n di ꞊nʋ 'nɩ wa. ");
INSERT INTO ktj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ kɔ 'blini, ɛ kɔ, 'bʋ yɩ nɩ hle, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ pʋ ‑cici lɛ, ɛ kɔ, 'bʋ yɩ 'dɩɩ 'kwli lɛ nɩ nɛ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ 'yaa 'lɩ win, ‑wɛn 'dɩɔwenyɔ. ");
INSERT INTO ktj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nyibli ‑mʋ', ‑ʋ 'yɩ 'klɩ ‑kɔ, ɛ di yru 'waa nyaɩ, ɛ kɔ, nyibli ‑mʋ', ‑ʋ 'yɩ ‑hɛɛnyɔ ‑kɔ, ɛ 'mʋ ꞊nʋ ‑hɛɛ ‑nɩ. Ɛ nɔ‑ ɛ di nu ‑nunu, nyibli 'mʋ 'a dɛ kɩ wɛn, 'kɩ bʋ 'sii 'ʋ ꞊nʋ yɩ, 'kɩ 'ʋ 'mʋ ye', ");
INSERT INTO ktj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ɛ kɔ, dakɔ a gblegble, ‑ʋ nɩ 'nɛ‑ 'klɔ kɩ, ʋ 'mʋ꞊ʋ ꞊wlʋ yɩ ‑kuo ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","'Hʋɩhrennyʋ ‑mʋ', ʋ gba ‑Yusu yɩ, 'kɩ 'lɩ ꞊nʋ 'nyɩ, nyiblo nɩ 'lɩ, 'a 'yii 'ɛ 'dɔ, kɔ, 'ɛ 'yɩ 'plɛlɛ ‑yi, ‑ɛ nu꞊o, 'ku ‑hʋan* nɩ 'ʋ꞊ʋ ke'. ‑Tɛ ʋ nyre 'ʋ꞊ʋ ‑Yusu ye', ‑ɛ ‑bɩ ‑Yusu nu꞊o nɩ, 'a 'kʋɛ 'ɛ ‑wɛ, nyiblo a 'mʋ, 'ɛ ‑tʋa 'pʋplɛ, kɔ, 'ɛ ‑tʋa lɛyuyruo. ");
INSERT INTO ktj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nyibli a pɛpɛ ‑mʋ', ‑ʋ nɩ 'ʋ, ɛ kɛɛ 'waa ꞊wlɩ lɛ. 'A ‑tɩ, ʋ wɛn: «꞊Bɩ ‑Yusu ‑bʋ, ɛ nɔ‑ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ‑a mʋ yɩ ya, ‑ɛ mɔ bodɩɔ Dafidɩ a 'yonʋ a 'Yu?» ");
INSERT INTO ktj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kɛɛ, Falisi꞊tumu* a nyibli ‑nɩ 'ʋ, 'tɩ‑ ʋ 'mʋ ‑tɩ a 'mʋ 'wɩn mɔ mu, ‑ɛ ‑bɩ ʋ wɛn: «'Ʋʋn‑. Nyiblo ‑bʋ, a yɩ 'ye, 'kuo ‑hʋɩn ‑mʋ', ‑ɛ nɩ 'ʋ nyibli ke', ʋ nʋ‑ ɛ blɛ lɛ, ‑ɛ nu꞊o, Bɛsebulɩ, ‑ɛ mɔ 'kuo ‑hʋɩn a nyiblo gbagbʋ Satan, ɛ nɔ‑ yɩ ‑Yusu 'klɩ ‑nyi, 'kɩ bʋ nu ‑tɛblɩ a 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kɛɛ, ‑Yusu yi 'waa 'lulɛ‑hihie nɩ. Ɛ nɔ‑ kɔ ‑tɩ 'ɛ lee ꞊nʋ, ‑ɛ mɔ: «꞊Bʋ pʋ꞊ʋ dɛ yɩ: 'Kɩ 'lɩ 'blʋgba 'kwli, nyibli 'bʋ 'bɛ ꞊tɩɔ lɛ, ‑ɛ ‑bɩ 'blʋgba a 'mʋ, ɛ di bi ꞊hlɔn. 'Ya 'ʋ 'lu de, 'bʋ mɔ, 'dɩɔ a nyibli, ‑hʋʋ' 'kayubʋkʋɛ, 'bʋ 'bɛ ꞊tɩɔ lɛ, ‑ɛ ‑bɩ nyibli a 'mʋ, ʋ di ‑gbɛ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Dɛ ɛ ꞊hɛn 'nyrɛ, ɛ nɔ‑ mɔ, 'bʋ mɔ, Satan 'bʋ yɩ 'a dɩɔnʋ lɛ nɩ blɛ, ɛ 'wɩ yɩ, 'a dɩɔnʋ ɛ ‑wɛn yɩ. 'A 'blʋgba kɔ bʋ bi ꞊hlɔn. ");
INSERT INTO ktj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","A wɛn 'nɩ, 'n blɛ 'kuo ‑hʋɩn lɛ, ‑ʋ nɩ 'ʋ nyibli ke', ‑ɛ nu꞊o, Bɛsebulɩ, ɛ nɔ‑ yɩ 'mʋ 'klɩ ‑nyi. 'Bʋ mɔ, ‑tɩ a 'mʋ, a hlɛ, 'bʋ mɔ wɛn ꞊han‑tɩ, 'aan 'mumu, nyɔ‑ yɩ 'kɩ 'aan ‑nɛ nyibli 'klɩ ‑nyi, 'ʋ blɛ 'kuo ‑hʋɩn lɛ ‑wɛ 'lɩ? Dɛ ‑mʋ', 'aan nyibli ni, ɛ nɔ‑ tʋɛ ꞊nɛ yɩ, ‑ɛ mɔ, ‑tɩ ‑bʋ, a yɩ 'mʋ ‑yɛɛ ‑nɩ, ɛ mɔ hɩ ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ɛ 'yɩ Satan 'pa‑, kɛɛ, Nyɩsʋa a ‑Hihiu*, ɛ nɔ‑ yɩ 'mʋ 'klɩ ‑nyi, 'kɩ ꞊bʋ bla 'kuo ‑hʋɩn ‑mʋ', ‑ʋ nɩ 'ʋ nyibli ke' lɛ. Dɛ a 'mʋ, ɛ tʋɛ nɛ 'a mɔ꞊ɔ nɩ, ‑ɛ mɔ, Nyɩsʋa ‑tʋa nyibli a win a kɩkɔɔlɛ, 'kɩ 'lɩ 'a mʋ 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Dɛ ɛ ‑nu, ɛ nɔ‑ mɔ, nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ pa 'lɩ 'klɩnɩnyɔ a 'kayu bʋ, bʋ mu ‑tɛblɩ 'yri, 'bʋ mɔ, 'bʋ 'yɩ 'klɩnɩnyɔ a 'mʋ ‑mʋa ‑nɩ 'tɩ‑. 'Bʋ mʋa ꞊nɛ, ‑ɛ ‑bɩ 'hru pɛ 'ʋ bʋ, 'kɩ bʋ 'yri 'a 'kayu a ‑tɛblɩ a pɛpɛ. ");
INSERT INTO ktj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nyiblo 'bʋ nɩ 'ʋ, ɛ kɔ 'mʋ 'hʋɛn‑, ꞊ba 'yɩ ‑pɛ, ɛ ꞊hɛn 'nyrɛ, ɛ ‑wɛn 'mʋ yɩ. 'Tɩ‑ nyiblo 'bʋ 'yɛ nɩ ‑hɛɛ 'mʋ, 'kɩ ‑ba 'kukue nyibli lɛ, 'kɩ 'ʋ Nyɩsʋa ‑mɔ', ɛ 'wɩ yɩ, nyiblo a 'mʋ, ɛ ‑gbɛ ꞊nʋ lɛ, 'ʋ hlʋɛ Nyɩsʋa ‑mɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ɛ nɔ‑ nu꞊o, 'nɩ yɩ 'a mʋ ‑lee ‑nɩ, ‑ɛ mɔ, Nyɩsʋa ‑wɛ 'lɩ bʋ 'wʋwla nyibli a dɛ 'kuku a pɛpɛ nɩ, 'ye ꞊bɩɩ ʋ ‑ha Nyɩsʋa 'yri lɛ. Kɛɛ, nyiblo ‑bʋ, ‑ɛ di Nyɩsʋa a ‑Hihiu 'yri lɛ ‑ha, Nyɩsʋa 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ 'wʋwla 'a dɛ 'kuku a 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","'Ya 'ʋ 'lu de, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, nyiblo ‑bʋ, ‑ɛ di 'mʋ ‑tɩ ‑hʋɩn yrɛ hla, Nyɩsʋa ‑wɛ 'lɩ bʋ 'wʋwla 'a dɛ 'kuku a 'mʋ nɩ. Kɛɛ, nyiblo ‑bʋ, ‑ɛ di Nyɩsʋa a ‑Hihiu ‑tɩ ‑hʋɩn yrɛ hla, Nyɩsʋa 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ 'wʋwla 'a dɛ 'kuku a 'mʋ, 'kɩ 'nɛ‑ 'klɔ ‑bʋ, ‑a nɩ 'nɛ‑ ‑mɔ, ɛ kɔ, 'kɩ 'lɩ 'klɔ ‑mʋ', ‑ɛ di 'lɩ di 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","(Kɛ‑ ‑Yusu pɩ de:) «Tugbɛ ‑mʋ', ‑ɛ yɩ ꞊haan'nie ‑jri, ɛ nɔ‑ tʋɩ ꞊haan'kui. Tugbɛ ‑mʋ', ‑ɛ 'yɛ nɩ ‑jri ꞊haan'nie, ɛ 'nɩ ‑tʋ꞊ʋ ꞊haan'kui. Tugbɛ a 'kuo, ɛ nɔ‑ ʋ yrui ꞊nɛ. ");
INSERT INTO ktj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","'A mʋ ‑mʋ', a kɛɛ nyibli. 'Aan ꞊wlɩ nyre yrɛ, ‑wɛn hro. Ɛ nɔ‑ kɔ ‑tɩ, 'ba nɩ 'ʋ ‑tɩtɛ bʋ, 'a hlɛ ‑tɩ ‑hʋɩn lɛ, ‑ɛ nu꞊o, ‑tɩ ‑mʋ', ‑ɛ 'yii 'lɩ nyiblo a ꞊wlʋ kɩ, ɛ nɔ‑ yɩ 'ʋ꞊ʋ wien ‑dii ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","꞊Haannyiblo a nunu‑tɛblɩ nɔ yɩ, ‑ɛ nu꞊o, 'a ꞊wlʋ nɔ yɩ. 'Crɛkɔnyɔ a nunu‑tɛblɩ nyre yɩ, ‑ɛ nu꞊o, 'a ꞊wlʋ nyre yɩ. ");
INSERT INTO ktj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, ‑nyrɔwɔ ‑mʋ', ‑ɛ kɔ 'yri Nyɩsʋa di 'ʋ nyibli ‑bati lɛ ‑pʋʋ ‑nɩ, 'a ‑nɛ nyiblo 'bʋ nɩ 'ʋ, 'bʋ hla nyiblo ꞊dʋ ‑tɩ ‑hʋɩn 'hʋɩ lɛ, 'kɩ 'nɛ‑ 'klɔ ‑bʋ kɩ, ɛ di Nyɩsʋa klɛ 'nɩ ‑hɩhɩa ‑nɩ, ‑tɩ ‑mʋ', ‑kɔtɩ 'ɛ hla ‑tɩ a 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","'A ‑tɩ, Nyɩsʋa 'bʋ di ‑na ‑bati 'bɛ, ‑tɩ ‑mʋ', ‑hla, 'kɩ 'nɛ‑ 'klɔ ‑bʋ kɩ, ɛ nɔ‑ ɛ di 'lɩ 'kwli lɛ ta, ɛ 'mʋ ‑mʋ ‑lee ‑nɩ, ‑ɛ mɔ: ‑Bati 'yɩ ‑mʋ ‑klɔ, ‑hʋʋ' ‑bati klɔ ‑mʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","‑Yusu bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ Nyɩsʋa a tetetɔɔnyʋ ‑bɩ, kɔ Falisi꞊tumu a nyibli ‑bɩ, ‑ʋ nɩ 'ʋ, ʋ ꞊tu꞊o ꞊wɔn, ʋ wɛn: «Tɔɔnyɔ o, ‑a ‑hʋɛ ‑ba 'ye꞊e, 'bʋ mɔ, ꞊nɩ ‑wɛ 'lɩ ‑bʋ nu ꞊wlɩlɛkɛɛdɛ, ‑ɛ di ‑a mɔ꞊ɔ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, Nyɩsʋa, nɔ‑ lee 'nɛ‑ ‑mʋ ‑tʋtʋ kɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","‑Ɛ ‑bɩ ‑Yusu wɛn: «Ti ‑bʋ 'yri a nyibli ‑bʋ, 'waa nunuklɔ nyre yɩ, 'ʋ plee 'lɩ Nyɩsʋa ke, 'tɩ‑ 'ʋ ‑hʋɛ ꞊wlɩlɛkɛɛdɛ de, ‑ɛ di ꞊nʋ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, Nyɩsʋa, ɛ nɔ‑ lee 'nɛ‑ 'mʋ ‑tʋtʋ kɩ. Kɛɛ, Nyɩsʋa 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ wɛn, 'kɩ ba 'ye ꞊wlɩlɛkɛɛdɛ ꞊dʋ. ꞊Wlɩlɛkɛɛdɛ nɩ ‑do ‑mʋ', Nyɩsʋa di nu, 'kɩ 'ʋ 'a mʋ ‑mɔ, ɛ di 'wɩ‑ 'a dɛ ‑bɩ ‑mʋ', ɛ nu la, 'kɩ 'ʋ winwlɔn‑hanyɔ Jona a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Dɛ ‑mʋ', Jona a 'mʋ, ɛ ‑nu, 'ɛ ‑hi 'lɩ ‑nyrɔwɩ nɩ ta kɔ 'tɔlʋwɩ nɩ ta ‑hrin.yɛ gbagbʋ ‑mʋ' 'kwli, kɛ‑ ɛ di 'mʋ ꞊ti, 'kɩ 'ʋ 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo ‑mɔ. 'N di ‑hii 'lɩ ‑tʋtʋ bʋ ‑nyrɔwɩ nɩ ta kɔ 'tɔlʋwɩ nɩ ta. ");
INSERT INTO ktj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","42","'Tɩ‑ Ninifʋdɩɔ a nyibli 'mʋ la Jona a win 'wɩn, ‑tɛ ɛ yɩ la ꞊nʋ Nyɩsʋa a ‑tɩ ‑lee ‑nɩ, ‑ɛ ‑bɩ ʋ hie la 'ʋ 'waa dɛ 'kuku, ʋ ni la bʋ, 'ʋ ‑nyi la 'waa 'klɔ a pɛpɛ Nyɩsʋa. ‑Ɛ ‑bɩ 'kɩ, 'mɔ ‑bʋ, ‑ɛ nɩ mɔ 'a mʋ ye' bʋ, 'n ‑hi 'ʋ Jona a 'mʋ nɩ, kɛɛ, a 'nɩ ꞊tuu꞊o 'ʋ 'na win 'ʋ. Ɛ nɔ‑ nu꞊o, ti ‑mʋ' ‑kɔ 'yri Nyɩsʋa di 'ʋ ‑tonyibli ‑bati lɛ ‑pʋʋ ‑nɩ, Ninifʋdɩɔ a nyibli a 'mʋ, ʋ nʋ‑ di ye' 'du, ʋ 'mʋ lɛ pʋ, ‑ɛ mɔ, ti ‑bʋ 'yri a nyibli, ʋ mɔ ‑tɩ'wlanyʋ ꞊nɩɔ, 'kɩ 'ʋ Nyɩsʋa ye'. 'Ya 'ʋ 'lu de, ti ‑hi la a ti 'yri, bodɩɔ ꞊dʋ, ɛ nɔ‑ ‑hɔn la 'lɩ ‑tɩtɛ blɔblʋ ꞊dʋ, ʋ dɛɛ Sabablʋgba. Bodɩɔ a 'mʋ, ɛ mɔ la nʋgba ꞊nɩɔ. Ɛ nɔ‑ di la Jrusrɛdɩɔ 'kwli, ɛ 'mʋ la bodɩɔ Salomɔ, ‑ɛ mɔ la Nyɩsʋa a nyiblo, 'a ꞊tɔwin 'wɩn. Kɛɛ, 'mɔ ‑bʋ, ‑ɛ nɩ mɔ 'a mʋ ye' bʋ, 'n ‑hi 'ʋ Salomɔ a 'mʋ nɩ. Kɛɛ, a 'nɩ ꞊tuu꞊o 'ʋ 'na win 'ʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Kɛ‑ ‑Yusu pɩ de: «'Bʋ mɔ, 'ku ‑hʋan 'bʋ nɩ 'ʋ nyiblo ke', 'tɩ‑ 'bʋ ‑hɔn 'ʋ꞊ʋ ke', ‑ɛ ‑bɩ 'kɩ ɛ mi 'lɩ 'wan 'kwli, 'ɛ mi bʋnɩɩlɛ yrayrʋ lɛ ꞊mʋɔ mɔ. Kɛɛ, ɛ 'nɩ 'ye꞊e lɩ bʋnɩɩlɛ. ");
INSERT INTO ktj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‑Tɛ ɛ 'yɛ nɩ 'ye 'kɩ bʋnɩɩlɛ, ‑ɛ ‑bɩ kɛ‑ ɛ pɩ 'a dɩɔnʋ yɩ: 'N kɔ ꞊bʋ ‑mɛ kle, 'mʋ 'lɩ bʋnɩɩlɛ 'ka, 'n ‑hɔn la 'lɩ 'kwli mu. ‑Tɛ ɛ ꞊hɩan ‑mɔ, ‑ɛ ‑bɩ ɛ 'ye꞊e nɩ, ‑ɛ mɔ, bʋnɩɩlɛ a 'mʋ, ɛ nu 'hʋhlʋ, 'ɛ 'hrɛn klɛ ‑tɛɛ, kɔ, 'ɛ ꞊hrɛntɩ ‑nɩ. (Ɛ 'wɩ yɩ, Nyɩsʋa a ‑Hihiu 'yɩ 'ʋ nyiblo a 'mʋ ke' ‑nɩ.) ");
INSERT INTO ktj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","'Bʋ nɩ 'mʋ lɛ, ‑ɛ ‑bɩ 'ku ‑hʋan a 'mʋ, ɛ kɔ bʋ bla 'kuo ‑hʋɩn nɩ ꞊hlon'hʋɛn ‑bɩ, ‑ʋ kɔ 'crɛ, ‑ʋ ‑hi 'ʋ 'a 'mumu 'ʋ, 'waa pɛpɛ a 'mʋ, ʋ 'mʋ ‑mɔ ‑bibi ‑nɩ, ʋ 'mʋ 'ʋ nyiblo a 'mʋ ke' bi. ‑Ɛ ‑bɩ nyiblo a 'mʋ, 'a 'klɔ di nyre yɩ pɛpɛ, ɛ 'mʋ 'ʋ 'a yɩ‑hɛklɔ 'ʋ ‑hi. Kɛ‑ ɛ di 'mʋ ꞊ti ‑wɛ, 'kɩ 'ʋ ti ‑bʋ 'yri a nyibli ‑bʋ ‑mɔ, ‑ʋ kɔ ꞊wlɩ ‑nyre yɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","'Kɩ ʋ nɩ la 'lɩ 'kayu nɩ ‑do a 'mʋ bʋ. ‑Yusu nɩ 'lɩ nyibli a 'mʋ, 'waa ‑mɔhleelɛ 'kwli, 'a 'dii kɔ 'a 'dɩayɩ nyɩbɛpʋ 'hʋɛn‑ 'ʋ nyre 'ʋ. 'Kɩ 'ʋ ‑patʋ', 'kɩ ʋ hree 'ʋ, 'ʋ ꞊mʋɛ 'hru lɛ, 'kɩ bʋ hlee 'lɩ ‑Yusu ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ɛ nɔ‑ mɔ, nyiblo ꞊dʋ bʋ mu꞊o lee mɔ, ‑ɛ mɔ: «'Ye kɛ, ‑na 'dii kɔ ‑na 'dɩayɩnʋ 'hʋɛn‑, 'kɩ 'ʋ nɩ 'lɩ ‑patʋ', 'ʋ ‑hʋɛ bʋ hlee 'lɩ ‑mʋ ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","‑Ɛ ‑bɩ kɛ‑ ‑Yusu ‑pʋ, 'ɛ ‑hɩhɩa nyiblo a 'mʋ klɛ, ɛ wɛn: «‑Ʋ ‑bɩ nɩ 'ʋ, 'ʋ mɔ 'na 'dii kɔ 'na 'dɩayɩnʋ 'hʋɛn‑ ‑wɛ,» ");
INSERT INTO ktj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","'ɛ pʋ 'a ‑nagbopʋ* dabʋ ‑mɔ, ɛ wɛn: «Ba 'ye kɛ, nyibli ‑bʋ, ʋ nʋ‑ mɔ 'na 'dii kɔ 'na 'dɩayɩnʋ ‑wɛ, ");
INSERT INTO ktj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","‑ɛ nu꞊o, nyibli ‑mʋ', ‑ʋ ni 'na 'Baɩ Nyɩsʋa ‑nɩ 'lɩ yakɔ 'kwli a kɩwɛɛnlɛ, ʋ nʋ‑ mɔ 'na 'dɩayɩnʋ, kɔ 'na 'dii ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","‑Nyrɔwɔ a 'mʋ 'kwli, ‑Yusu 'hrɩ la 'lɩ 'kayu bʋ nɩ, 'ɛ mu la 'lɩ Galileblʋgba a 'yru wien, 'ɛ nɩ bʋ, ‑ɛ di꞊e nu, ɛ 'mʋ nyibli Nyɩsʋa a ‑tɩ ‑tɔɔ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nyibli ‑hʋɔhʋɩ, ʋ nʋ‑ ꞊glaa 'lɩ꞊ɩ lɛ. Bʋ 'yɛ nɩ 'ye 'hru, ɛ nɔ‑ nu꞊o, 'ɛ 'ya 'lɩ 'blagbɩ 'kwli, 'ɛ nɩ bʋ, nyibli a 'mʋ, 'ʋ 'wlɛ 'ʋ 'gbahlɔn bʋ, ");
INSERT INTO ktj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","'ɛ ‑hɩhɩɛ ꞊nʋ ‑tɛblɩ ‑hʋɔhʋɩ klɛ, 'kɩ 'lɩ 'ledʋɩ 'kwli. Kɛ‑ ɛ pɩ 'kɩ, ɛ wɛn: «Ba pʋ 'mʋ nʋa yɩ bʋ. Ɛ kɔ la ‑nyrɔwɔ ꞊dʋ, nyɩbɛhɩan ꞊dʋ, ɛ nɔ‑ mu la 'a ‑tɛblɩ 'dɔ mɔ. ‑Tɛblɩ a 'mʋ, ɛ ‑gblɛ 'lɩ꞊ɩ 'a ‑ci 'kwli lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","‑Tɛ ɛ yɩ꞊ɩ nɩ ‑gblɛ, 'a dɛ ‑bɩ bi 'lɩ 'hru wlɔn lɛ, nʋblɩ 'ʋ ‑di, 'ʋ di꞊e. ");
INSERT INTO ktj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","'A 'hʋɛn a dɛ, ɛ ‑gbla, ‑tʋtʋkʋtɩɔ ‑mʋ', ɛ bi 'ʋ kɩ, 'hɩɔ 'pa nɩ 'lɩ꞊ɩ bʋ, 'ɛ 'sii yɩ, 'ɛ ꞊ga ti nɩ ‑do a ti 'yri, ‑ɛ nu꞊o, ‑tʋtʋkʋtɩɔ a 'mʋ, ‑ɛ nɩ 'ʋ 'hɩɔ a 'mʋ kɩ, ɛ 'yɩ ‑hʋ. ");
INSERT INTO ktj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","‑Tɛ ɛ ꞊ga, ‑tɛ 'yrʋ bi 'lɩ yɔ', ɛ nɔ‑ mɔ 'a ꞊kwlɩ bʋ 'yrɔ, ‑ɛ nu꞊o, 'a ‑wlubʋɩ kʋɛ 'hɩɔ a 'mʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","'A ta a dɛ, ɛ ‑gbla, 'kɩ ɛ bi 'lɩ 'witi 'nyɩ. ‑Tɛ ɛ ꞊ga, ‑ɛ ‑bɩ 'witilili 'buu ꞊nɛ 'lu lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","'A ‑hɛn a dɛ, ɛ ‑gbla, ɛ nɔ‑ bi 'ʋ ꞊haan‑tʋtʋ kɩ. ‑Tɛ ɛ ꞊ga, 'ɛ 'sii yɩ, 'ɛ ku ‑tɛɛ, 'ɛ pʋ blɩ. 'A blʋ nɩ ‑do, ɛ pʋ 'yɔ a (100) ‑wlɩ nɩ ꞊hun, ‑ʋ ‑bɩ pʋ 'yɔ a (60) ‑wlɩ nɩ ta, 'a dɛ ‑bɩ pʋ 'yɔ a (30) ‑wlʋ ꞊tu 'ʋ ‑pu. ");
INSERT INTO ktj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","'Bʋ mɔ, 'ba kɔ ‑tɩ'wɩnnʋa, ‑ɛ ‑bɩ ba 'wɩn ‑tɩ ‑dodo.» ");
INSERT INTO ktj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","‑Tɛ ‑Yusu ‑yrɛ 'kɩ, ‑ɛ ‑bɩ 'a ‑nagbopʋ* 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, 'ʋ yɩ꞊ɩ lɛ 'bɛti ‑nɩ, ʋ wɛn: «꞊Bɩ nyibli ‑bʋ, 'kɩ 'ledʋɩ 'kwli ‑tʋɛ 'lɩ ꞊nʋ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","‑Ɛ ‑bɩ ɛ ꞊tu ꞊nʋ ꞊wɔn: «'N ni 'ledʋɩ, 'nɩ tʋɛ ꞊nʋ, ‑ɛ nu꞊o, 'a mʋ ‑bʋ, ‑ʋ mɔ 'na ‑nagbopʋ, Nyɩsʋa ni꞊e nɩ, 'a yrui Nyɩsʋa a ‑tɩ' lɛ, ɛ ꞊hɛn 'nyrɛ, ‑tɛ ɛ ni, 'ɛ kʋɛ nyibli win kɩ. Nyɩsʋa a ‑tɩ a 'mʋ, ɛ ‑hli nyibli 'yi kɩ. Kɛɛ, nyibli ‑bɩ ‑mʋ', Nyɩsʋa 'yɩ꞊ɩ ‑nu, 'kɩ bʋ yru꞊o' lɛ, ");
INSERT INTO ktj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","‑ɛ nu꞊o, nyiblo ‑mʋ', ‑ɛ pɩ Nyɩsʋa a win nʋa yɩ bʋ, Nyɩsʋa di꞊e 'nɩ nu, ɛ 'mʋ꞊ʋ' lɛ yru, ɛ 'mʋ ‑tɛ ɛ nu la 'a 'wɩnwɩɩn 'ʋ ‑hi. Kɛɛ, nyiblo ‑mʋ', ‑ɛ 'yɛ nɩ pʋ꞊ʋ nʋa yɩ bʋ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ yru꞊o' lɛ pɛpɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Dɛ ‑kɔ ‑tɩ 'n nɛɛ 'lɩ 'ledʋɩ 'kwli, 'nɩ yɩ 'lɩ ꞊nʋ ‑mɔ ‑hlee ‑nɩ, ɛ nɔ‑ mɔ, nyiblidʋ a 'mʋ, ʋ yɩ꞊ɩ 'nɩ 'ye ‑tɛɛ, kɛɛ, ʋ 'nɩ ‑yru꞊o lɩ꞊ɩ' lɛ ‑tɛɛ, 'ʋ yɩ꞊ɩ 'wɩn ‑tɛɛ, kɛɛ, ʋ 'nɩ ‑yru꞊o lɩ꞊ɩ' lɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","‑Tɩ ‑mʋ', Nyɩsʋa a winwlɔn‑hanyɔ Esai hla la 'kɩ, ɛ nɔ‑ mi kɛ 'lu ‑mɔ, 'kɩ 'ʋ ꞊nʋ ‑mɔ. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: «Kɛ‑ Nyɩsʋa ‑pʋ: ‑Tɩ ‑bʋ, 'n di hla, a di 'nɩ 'wɩn, kɛɛ, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba yru꞊o' lɛ; dɛ ‑bʋ, 'n di nu, a di꞊e 'nɩ 'ye, kɛɛ, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba yru꞊o lɛ, ");
INSERT INTO ktj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","‑ɛ nu꞊o, dakɔ ‑bʋ, 'waa ꞊wlɩ 'gboklo nɩ, 'ʋ ka 'waa nʋɩ yrɛ, ‑ɛ di꞊e nu, 'waa nʋɩ 'nɩ ꞊ha ‑tɩ 'wɩn, 'ʋ ka 'waa 'yii kɩ, ‑ɛ di꞊e nu, 'waa yii 'nɩ ꞊ha dɛ 'ye, ɛ kɔ, 'waa ꞊wlɩ 'nɩ ꞊ha ‑tɩ' lɛ yru. 'Bʋ mɔ, 'bʋ 'yɛ nɩ nu wɛn ‑tɛblɩ a 'mʋ, ʋ di wɛn 'mʋ yɩ 'nɩ ‑mɛ, 'mʋ wɛn꞊ɛ nu, ʋ 'mʋ wɛn 'ʋ yɩ 'sii ‑nɩ, 'kɩ 'ʋ 'mʋ ye'. Kɛ‑ Nyɩsʋa ‑pʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'a ‑nagbopʋ yɩ de, ɛ wɛn 'nɩ: «'A mʋ ‑mɔ ‑bɩ, ba kɔ plɔ a bleelɛ, ‑ɛ nu꞊o, 'aan 'yii yrui lɛ, 'aan nʋɩ 'ɛ yɩ ‑tɩ 'wɩn. ");
INSERT INTO ktj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ti ‑hi la a ti 'yri a Nyɩsʋa a winwlɔn‑hanyʋ*, kɔ Nyɩsʋa a dakɔ a nyibli ‑hʋɔhʋɩ ‑bɩ 'hʋɛn‑, ʋ ꞊mʋɛ la꞊a lɛ, 'kɩ bʋ 'ye la ‑tɛblɩ gbagbɩ ‑bʋ, a yɩ kɛ 'ye, kɛɛ, ʋ 'yɩ꞊ɩ 'ye, kɔ, 'ʋ ꞊mʋɛ la꞊a lɛ, 'kɩ bʋ 'wɩn la ‑tɛblɩ gbagbɩ ‑bʋ, a yɩ kɛ 'wɩn a ‑tɩ, kɛɛ, ʋ 'yɩ꞊ɩ 'wɩn.» ");
INSERT INTO ktj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","‑Ɛ ‑bɩ, ɛ yɩ ꞊nʋ 'nɩ ‑lee ‑nɩ de, ɛ wɛn: «Ba pʋ 'mʋ nʋa yɩ bʋ, ‑ɛ di꞊e nu, dɛ ‑mʋ', 'ledʋ a 'mʋ, ɛ ꞊hɛn 'nyrɛ, 'mʋ 'a mɔ꞊ɔ klɛ ‑hɩhɩa ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nyiblo 'bʋ nɩ 'ʋ, 'bʋ yɩ꞊ɩ 'wɩn, ‑ɛ mɔ, Nyɩsʋa ‑hʋɛ bʋ kɔɔ nyibli win kɩ, 'tɩ‑ 'bʋ 'yɛ nɩ yru꞊o' lɛ, nyiblo a 'mʋ, ɛ 'wɩ 'hru ‑mʋ' yɩ, ‑ɛ kɔ wlɔn 'dʋdɔ‑tɛblɩ bi 'ʋ lɛ, 'tɩ‑ nʋblɩ 'ʋ ‑di, 'ʋ di꞊e. 'Bʋ yɩ Nyɩsʋa a win nɩ 'wɩn, ‑ɛ ‑bɩ 'kuo ‑hʋɩn* a nyiblo gbagbʋ, ɛ yɩ 'nɩ di, 'ɛ ‑hɛ 'lɩ꞊ɩ Nyɩsʋa a win a 'mʋ ꞊wlɩ klɛ. ");
INSERT INTO ktj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","‑Tʋtʋkʋtɩɔ ‑mʋ', ‑ɛ nɩ 'ʋ 'hɩɔ 'pa kɩ, ‑ɛ kɔ kɩ 'dʋdɔ‑tɛblɩ ‑bɩ bi 'ʋ lɛ ‑wɛ, ɛ nɔ‑ mɔ nyiblo ‑bʋ, ‑ɛ yɩ Nyɩsʋa a win 'wɩn, 'tɩ‑ ‑ɛ yɩ꞊ɩ kɩ ‑wɛn, 'kɩ 'lɩ plɔ a bleelɛ 'kwli, ");
INSERT INTO ktj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","'tɩ‑ ‑ɛ yɩ꞊ɩ kʋa 'ble, 'kɩ 'lɩ ti gbi 'kwli, kɛɛ, ‑ɛ 'yɛ nɩ ‑hʋa, 'kɩ bʋ pʋ 'ma, 'kɩ 'lɩ 'a ꞊wlʋ kɩ. Nyiblodʋ a 'mʋ, 'a 'bio ‑mʋ', ‑ʋ 'yɛ nɩ ‑hʋa Nyɩsʋa a win, 'bʋ yɩ꞊ɩ ꞊hɩʋɛn nɩ ꞊tui, ɛ kɔ, 'bʋ yraa ꞊nɛ, ɛ yɩ 'nɩ sa, 'kɩ 'ʋ 'a ‑nɛ nyɩsʋadɛ a 'mʋ ‑mɔ'. ");
INSERT INTO ktj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","‑Tʋtʋkʋtɩɔ ‑mʋ', ‑ɛ kɔ kɩ 'witi nɩ 'ʋ, ‑ɛ kɔ kɩ 'dʋdɔ‑tɛblɩ ‑bɩ bi 'lɩ lɛ ‑wɛ, ɛ nɔ‑ mɔ nyiblo ‑bʋ, ‑ɛ yɩ Nyɩsʋa a win 'wɩn, 'tɩ‑ nyiblo a 'mʋ 'ɛ yɩ 'klɔ kɩ a 'kla‑wliye'yɩya a hritilɛ ‑hriti ‑nɩ, kɔ, 'ɛ nɛɛ kʋkɔ‑tɛblɩ a ‑tɩ ꞊wlɩ klɛ, ‑ɛ pɩ 'lɩ꞊ɩ kɩka 'nyɩ. ‑Tɛblɩ a pɛpɛ a 'mʋ, nɔ‑ ni꞊e, Nyɩsʋa a win 'ɛ 'yɛ nɩ nu ‑kʋan, 'kɩ 'lɩ 'a ꞊wlʋ kɩ, 'ɛ yɩ 'lɩ lɛ ‑hihre ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","‑Ɛ ‑bɩ ꞊haan‑tʋtʋ ‑mʋ', ‑ɛ kɔ kɩ 'dʋdɔ‑tɛblɩ ‑bɩ bi 'lɩ lɛ ‑wɛ, ɛ nɔ‑ mɔ nyiblo ‑bʋ, ‑ɛ yɩ Nyɩsʋa a win 'wɩn, 'tɩ‑ ‑ɛ yrui꞊e' lɛ, 'ɛ ni ‑kʋan, 'kɩ 'lɩ 'a ꞊wlʋ kɩ, 'wɩ a (100) ‑wlɩ nɩ ꞊hun, kɔ (60) ‑wlɩ nɩ ta, 'kɩ 'ʋ ‑ɛ ‑bɩ ‑mɔ, kɔ (30) ‑wlʋ ꞊tu 'ʋ ‑pu, 'kɩ 'ʋ ‑ɛ ‑bɩ ‑mɔ, ɛ ‑hi 'ʋ ‑tɛ ʋ nu 'a 'wɩnwɩɩn nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kɛ‑ ‑Yusu pɩ la ꞊nʋ yɩ de, ɛ wɛn: «Nyɩsʋa 'bʋ kɔɔ nyiblo win kɩ, dɛ ɛ 'wɩ yɩ, ɛ nɔ‑ ‑bʋ: Nyɩbɛhɩan ꞊dʋ, ɛ nɔ‑ 'dɔ ꞊haan‑kʋbʋ, 'kɩ 'lɩ 'a ‑ci 'kɩ. ");
INSERT INTO ktj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","‑Nyrɔwɔ ꞊dʋ a 'tɔ, ‑tɛ ‑tonyibli a pɛpɛ pɛ blɛ, ‑ɛ ‑bɩ 'a yraanyɔ mu 'lɩ 'a ‑ci a 'mʋ kɩ, 'ɛ 'dɔ yɩnyre‑piti, ‑ɛ 'wɩ ‑kʋbʋ yɩ, 'kɩ 'lɩ 'a ꞊haan‑kʋbʋ a 'mʋ 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","‑Tɛ ‑kʋbʋ a 'mʋ, ɛ ‑mɩ, ɛ pʋ blɩ, ɛ kɔ ‑piti a 'mʋ 'hʋɛn‑, ʋ nʋ‑ ꞊ga. ");
INSERT INTO ktj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","‑Tɛ ‑cikɔnyɔ a ‑kʋannunyibli ‑di, ‑ɛ ‑bɩ ʋ wɛn: Nyɩbɛyu o, ꞊bɩ ꞊yɩ ꞊haan‑kʋbʋ 'dɔ, 'kɩ 'lɩ ‑na ‑ci kɩ? ‑Bɩ' ‑piti ‑hʋɩn ‑hɔn 'kɩ yɩ, 'ɛ ꞊ga 'lɩ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‑Ɛ ‑bɩ ɛ ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: 'Na yraanyɔ, ɛ nɔ‑ nu꞊o. ‑Ɛ ‑bɩ ‑kʋannunyibli wɛn: ꞊Bɩ ‑hʋɛ꞊ɛ nɩ, 'kɩ ‑ba ‑ha ‑piti ‑hʋɩn a 'mʋ? ");
INSERT INTO ktj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ɛ wɛn: 'Ʋʋn‑, a 'nɩ 'haa 'lɩ꞊ɩ, ‑ɛ nu꞊o, 'ba yɩ꞊ɩ nɩ ‑hɛ, 'ba 'bɛ 'lɩ bʋ, a di 'hri ‑kʋbʋ. ");
INSERT INTO ktj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ba ‑ha ꞊nʋ mɛ lɛ, bʋ kuu 'ʋ ‑tɛ nɩ ‑do, ʋ kɔ ‑kʋbʋ 'hʋɛn‑. Ti ‑kʋbʋ'cɛti di 'ʋ nyre, 'tɩ‑ 'mʋ ‑kʋbʋ'cɛnyibli ‑lee ‑nɩ, ‑ɛ mɔ: Yɩ‑hɛdɛ ba nu, ɛ nɔ‑ mɔ, ba 'kukue ‑piti ‑hʋɩn ‑mʋ' lɛ, ba pʋ 'a dui, ba pʋ ꞊nʋ 'tɔ lɛ. 'Ba ‑wɛ mɔ, ‑ɛ ‑bɩ ba 'kukue ‑kʋbʋ ‑mʋ' lɛ, a 'mʋ 'lɩ꞊ɩ 'na 'kalɩ' pʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","‑Tɛ ɛ ‑yrɛ, ‑ɛ ‑bɩ ɛ pʋ ꞊nʋ 'ledʋ ‑bɩ yɩ de, ɛ wɛn: «꞊Bʋ tɔɔ nɛ 'a mʋ, ‑tɛ Nyɩsʋa ‑nu, 'ɛ kɔɔ nyibli dodoyo ‑bɩ win kɩ, 'tɩ‑ nyibli ‑bɩ 'ʋ yɩ kɩ ‑bii ‑nɩ. Dɛ a 'mʋ, ɛ 'wɩ 'dʋdɔdɛ ‑mʋ', ‑ɛ kɔ 'yɛɛ ꞊cɩmɩ ‑nɩ yɩ, ‑ɛ ‑hi 'ʋ 'dʋdɔ‑tɛblɩ ‑bɩ a 'yɔ 'ʋ. 'Dʋdɔdɛ a 'yɛɛ a 'mʋ, ɛ nɔ‑ nyiblo ꞊dʋ ‑gba, 'ɛ 'dɔɔ 'lɩ 'a ‑ci kɩ. ‑Tɛ ɛ ‑mɩ, ɛ ‑ku, ‑ɛ ‑bɩ ɛ ‑hɛ tugbɛ gbagbʋ, 'ɛ ‑hi 'ʋ ‑ci a 'dʋdɔ‑tɛblɩ a pɛpɛ 'lu lɛ, nʋblɩ 'bʋ ‑di, 'ʋ pɩ 'lʋɛ, 'kɩ 'lɩ 'a babʋɩ yra.» ");
INSERT INTO ktj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","‑Tɛ ɛ ‑yrɛ de, ‑ɛ ‑bɩ ɛ pʋ 'ledʋ ‑bɩ de, ɛ wɛn: «Nyɩsʋa 'bʋ kɔɔ nyibli win kɩ, 'tɩ‑ nyibli ‑bɩ 'bʋ yɩ klɛ nɩ ‑bii ‑nɩ, dɛ a 'mʋ, ɛ 'wɩ‑ 'flɔɔ a 'yaadɛ yɩ, nʋgba pʋ 'lɩ 'flɔɔpupu ‑hʋɔhʋɩ ‑mɔ, 'tɩ‑ 'ɛ nyʋa꞊a ‑nyʋanyʋa, 'flɔɔ a pɛpɛ a 'mʋ 'ɛ 'ya.» ");
INSERT INTO ktj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","‑Tɛblɩ a pɛpɛ ‑mʋ', 'kɩ 'lɩ 'ledʋɩ 'kwli, 'kɩ ‑Yusu nɛɛ 'lɩ꞊ɩ 'lɩ, 'ɛ tʋɛ nyibli ‑mʋ'. Ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, 'kɩ bʋ 'yɩ 'ledʋ ‑pʋ, bʋ 'yɩ ꞊nʋ ‑tɔɔ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kɛ‑ ɛ nu 'a nunuo, ‑ɛ di꞊e nu, ‑tɩ ‑mʋ', Nyɩsʋa a winwlɔn‑hanyɔ* ‑bɩ 'crɩ la, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ɛ 'mʋ ‑nue ‑nɩ. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: «Nyɩsʋa wɛn 'nɩ: 'N di nu 'ledʋɩ, 'mʋ 'lɩ ꞊nʋ ‑mɔ ‑hlee ‑nɩ. ‑Tɛblɩ ‑mʋ', nyibli 'yɩ la ‑yi, kʋɛ 'lɩ 'klɔ a ‑wlu꞊tuulɛ 'yie bʋ, 'mʋ ꞊nʋ ‑tɔɔ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu hie 'ʋ nyibli ‑mʋ' bʋ, 'ɛ mu 'lɩ 'kayu bʋ, ɛ kɔ 'a ‑nagbopʋ* 'hʋɛn‑, 'a ‑nagbopʋ a 'mʋ, 'ʋ ‑mu, 'ʋ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, 'ʋ 'bɛti꞊e, ʋ wɛn: «Yɩnyre‑piti ‑mʋ', ‑ɛ kɔ 'ledʋ ‑pʋ wɛn, ꞊nɩ pʋ lɛ, 'kɩ ʋ 'dɔɔ 'lɩ꞊ɩ ‑ci ‑mʋ' kɩ, ‑hɩhɩa ‑a mʋ 'a ‑tɩ klɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","‑Ɛ ‑bɩ ɛ wɛn: «Nyiblo ‑mʋ', ‑ɛ 'dʋɛ ꞊haan‑kʋbʋ ‑mʋ', 'mɔ ‑bʋ, ‑ɛ mɔ nyibli a pɛpɛ a Nyiblo, 'mɔ ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","‑Ci ‑mʋ', ɛ nɔ‑ mɔ 'klɔ ‑bʋ, ‑a nɩ 'nɛ‑ 'kwli. ꞊Haan‑kʋbʋ, nɔ‑ mɔ, nyibli ‑mʋ', Nyɩsʋa kɔɔ win kɩ. Yɩnyre‑piti ‑mɔ ‑bɩ, ɛ nɔ‑ mɔ nyibli ‑mʋ', 'kuo ‑hʋɩn* a nyiblo gbagbʋ kɔɔ win kɩ. ");
INSERT INTO ktj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yraanyɔ ‑mʋ', ‑ɛ 'dʋɛ yɩnyre‑piti ‑mʋ', ɛ nɔ‑ mɔ 'kuo ‑hʋɩn a nyiblo gbagbʋ. ‑Kʋbʋ'cɛti, ɛ nɔ‑ mɔ 'klɔ a 'ʋ‑hɔnti. ‑Kʋbʋ'cɛnyibli, nʋ‑ mɔ Nyɩsʋa a lɛlenyʋ. ");
INSERT INTO ktj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","‑Tɛ ʋ ni, 'ʋ yɩ yɩnyre‑piti ‑mʋ' lɛ 'kukue ‑nɩ, 'ʋ pɩ꞊ɩ 'tɔ lɛ, kɛ‑ nɩ ‑do, ɛ di 'mʋ nɩ, 'klɔ a 'ʋ‑hɔnti 'yri. ");
INSERT INTO ktj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ti a 'mʋ 'yri, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n di tɛ Nyɩsʋa a lɛlenyʋ bʋ, ‑ɛ di꞊e nu, nyibli ‑mʋ', ‑ʋ ni꞊e, 'waa 'bio, 'ʋ ni ‑tɛblɩ ‑hʋɩn, kɔ nyibli ‑mʋ', ‑ʋ ni ‑tɛblɩ ‑hʋɩn, ʋ 'mʋ ꞊nʋ lɛ 'kukue ‑nɩ, 'kɩ 'lɩ nyibli ‑mʋ', Nyɩsʋa kɔɔ win kɩ 'nyɩ, ");
INSERT INTO ktj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ʋ 'mʋ 'lɩ ꞊nʋ na ‑mʋ', ‑ɛ 'yɛ nɩ jre 'nyɩ pʋ. 'Kɩ ʋ di 'ʋ ꞊hien ‑wee ‑nɩ, kɔ, 'kɩ ʋ di 'ʋ yrʋ ‑pʋʋ ‑nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kɛɛ, nyibli ‑mʋ', ‑ʋ ꞊tui 'ʋ Nyɩsʋa 'ʋ, 'a ‑nɛ nyiblo, ɛ di ꞊nʋ 'nɩ 'ye, 'kɩ 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli, ꞊wɩ yɩ ‑tɛ ɛ ni, 'ɛ yɩ 'yrʋ 'ye, ‑ɛ yɩ hʋɛn, 'kɩ 'lɩ yakɔ 'kwli. 'Ba kɔ ‑tɩ'wɩnnʋa, ‑ɛ ‑bɩ ba 'wɩn ‑tɩ ‑dodo.» ");
INSERT INTO ktj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Nyɩsʋa 'bʋ kɔɔ nyiblo win kɩ, dɛ 'n ‑wɛ 'lɩ ꞊bʋ pʋʋ ꞊nɛ yɩ, ɛ nɔ‑ ‑bʋ: Ɛ kɔ la ꞊haandɛ gbagbʋ ꞊dʋ, 'ɛ pɩ la ꞊die. 'Kɩ ʋ ‑hli 'lɩ꞊ɩ ‑ci ꞊dʋ 'kwli, nyiblo ꞊dʋ 'ɛ 'hrɩɩ ꞊nɛ kɩ. ꞊Haandɛ gbagbʋ a 'mʋ, ɛ 'hrɩɩ kɩ a ‑tɩ, 'a plɔ ble nɩ dɩakɩ, 'ɛ ‑hli꞊e de, 'ɛ ‑mu, 'ɛ plo 'a ‑nɛ kʋkɔ‑tɛblɩ a pɛpɛ, 'tɩ‑ 'ɛ nu kʋkɔ‑tɛblɩ a 'mʋ a 'wli, 'ɛ ‑tɔ ‑ci a 'mʋ, ‑ɛ kɔ 'kwli ꞊haandɛ gbagbʋ a 'mʋ, ɛ nɩ 'lɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Nyɩsʋa 'bʋ kɔɔ nyiblo win kɩ, ɛ 'wɩ puplonyɔ ꞊dʋ yɩ, ‑ɛ ꞊mʋɛ 'damayɔ, ‑ʋ pɩ ꞊die a ‑tʋtɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","‑Tɛ ɛ yɛ 'a 'yɛ nɩ ‑do kɩ, ‑ɛ nɔ yɩ ‑tɛɛ, 'tɩ‑ ‑ɛ pɩ ꞊die, ‑ɛ ‑bɩ ɛ mu nɩ, 'ɛ plo 'a ‑nɛ kʋkɔ‑tɛblɩ a pɛpɛ, 'ɛ ‑tɔ 'damayɛ a 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Nyɩsʋa 'bʋ kɔɔ nyibli win kɩ, ɛ 'wɩ ‑tɩta yɩ, ʋ pʋ 'lɩ 'nie ‑mɔ, ‑ɛ kwlɛ ‑hrin a gblegble. ");
INSERT INTO ktj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","'Bʋ 'yii 'lɩ, ‑ɛ ‑bɩ 'pʋpanyibli yɩ꞊ɩ 'nɩ ‑jri, 'ʋ 'yɛɛ 'ʋ꞊ʋ 'gbahlɔn, 'ʋ yɩ blɛ nɩ, 'ʋ yɩ 'lɩ ‑hrin a 'mʋ 'lɩ 'tɩtɩ ‑nɩ, dɛ ‑mʋ', ‑ʋ mɔ 'a ꞊haandɛ, 'ʋ pɩ 'lɩ꞊ɩ ‑tʋgbɩ 'kwli lɛ, 'tɩ‑, 'ʋ pɩ 'a ‑hʋɩn 'wan lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kɛ‑ nɩ ‑do, ɛ di ‑hʋan 'mʋ ꞊ti, ti ‑kɔ 'yri 'klɔ di ‑hʋan 'ʋ ‑wlu ‑hɔn: Nyɩsʋa a lɛlenyʋ di 'lɩ 'nɩ di, nyibli ‑mʋ', ‑ʋ 'yɩ 'ʋ Nyɩsʋa 'ʋ ꞊tuu ‑nɩ, ɛ kɔ nyibli ‑mʋ', ‑ʋ ꞊tuu 'ʋ Nyɩsʋa, ʋ 'mʋ ꞊nʋ 'yi lɛ ‑hɩhɩa ‑nɩ, ");
INSERT INTO ktj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","nyibli ‑mʋ', ‑ʋ 'yɩ 'ʋ Nyɩsʋa 'ʋ ꞊tuu ‑nɩ, na ‑mʋ', ‑ɛ 'yɛ nɩ jre 'klɔ ‑mɔ 'klɔ, ɛ nɔ‑ kɔ 'nyɩ ʋ di 'lɩ ꞊nʋ 'lɩ pʋ. 'Kɩ ʋ di 'lɩ ꞊hien 'lɩ ‑wee ‑nɩ, kɔ, 'kɩ ʋ di 'lɩ yrʋ 'lɩ ‑pʋʋ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","‑Ɛ ‑bɩ ‑Yusu 'bɛti 'a ‑nagbopʋ* ‑nɩ wɛn nɩ, ɛ wɛn: «‑Tɩ a pɛpɛ ‑bʋ, 'n ‑hla, ꞊bɩ a yru꞊o' lɛ?» ‑Ɛ ‑bɩ ʋ wɛn: «Iin, ‑a yru꞊o' lɛ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «'A ‑nɛ tetetɔɔnyɔ ꞊dʋ, ‑ɛ di 'na ‑nagbopi ‑hɛ, ɛ 'wɩ‑ 'kayu'baɩ ‑mʋ', ‑ɛ kɔ ꞊tɔ, ‑ɛ 'dui 'a kʋkɔ‑tɛblɩ yrayrɩ kɔ 'a ‑tɛblɩ 'kɩ 'hʋɛn‑ ye', ‑ɛ nii ꞊nɛ ‑kʋan 'yri.» ");
INSERT INTO ktj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","‑Tɛ ‑Yusu ‑wɛ 'ledʋ a 'mʋ, 'a pʋpʋʋ ‑mɔ, ‑ɛ ‑bɩ ɛ ‑hɔn 'ʋ ‑tɩtɛ a 'mʋ nɩ, ");
INSERT INTO ktj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","'ɛ mu 'lɩ 'dɩɔ ‑mʋ', ‑ɛ kɔ 'kwli ɛ kuu 'lɩ, 'ɛ mu 'lɩ Nyɩsʋa a 'kayu bʋ, 'ɛ ‑tʋa Nyɩsʋa a ‑tɩ a tɔɔlɛ. Nyibli ‑hʋɔhʋɩ ‑mʋ', ‑ʋ nɩ 'ʋ, 'waa ꞊wlɩ kɛɛ lɛ, ʋ wɛn: «Nyɔ‑ tɔɔ ꞊nɛ ꞊tɔwin ‑bʋ, ‑ɛ yɩ 'lɩ꞊ɩ wlɔn 'hrɩ 'lɩ? Kɔ, nyɔ‑ ‑nyi꞊e 'klɩ, 'kɩ bʋ nu ꞊wlɩlɛkɛɛ‑tɛblɩ ‑bʋ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Dɛ ‑a ‑yi, ɛ nɔ‑ mɔ, ɛ mɔ 'camudɛ a 'yu ꞊nɩɔ. 'A 'dii a 'nyrɛ mɔ Mari. 'A 'dɩayɩ nyɩbɛpʋ, nʋ‑ mɔ Sakɩ, kɔ Sosɛfʋ, kɔ Simɔ, kɔ Judɩ. ");
INSERT INTO ktj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","'A 'dɩayɩ nyrɔyo a pɛpɛ nɩ 'nɛ‑ ‑a mʋ 'nyɩ. 'A ‑tɩ, nyɔ‑ ‑nyi 'kɩ꞊ɩ ꞊tɔdʋ ‑bʋ, ɛ ‑kɔ, kɔ, nyɔ‑ ‑nyi꞊e 'klɩdʋ ‑bʋ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","'Waa 'lulɛ‑hihiedʋ a 'mʋ, ɛ nɔ‑ nu꞊o, 'kɩ ʋ 'yɩ꞊ɩ ꞊wlʋ yɩ ‑kuo ‑nɩ. ‑Ɛ ‑bɩ ‑Yusu wɛn 'nɩ: «Nyiblo ‑bʋ, ‑ɛ mɔ Nyɩsʋa a winwlɔn‑hanyɔ*, ʋ ꞊tui 'ʋ꞊ʋ nɩ, 'kɩ 'ʋ 'a ‑nɛ ‑tɩtɛ ꞊dʋ. Kɛɛ, ʋ 'nɩ ꞊tuu꞊o 'ʋ꞊ʋ, 'kɩ 'lɩ 'a dɩɔnʋ a 'dɩɔ 'kwli, kɔ 'kɩ 'lɩ 'a 'kayu bʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","'Kɩ 'lɩ ꞊nʋ 'nyɩ, ‑Yusu 'yɩ 'kɩ ꞊wlɩlɛkɛɛ‑tɛblɩ ‑hʋɔhʋɩ ‑nu de, ‑ɛ nu꞊o, ʋ 'yɩ꞊ɩ ꞊wlʋ yɩ ‑kuo ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ti a 'mʋ 'yri, 'kɩ Galileblʋgba a ‑gʋlʋnʋma, ‑ɛ kɔ 'nyrɛ mɔ Helɔdɩ, ɛ 'wɩɩn la 'ʋ ‑Yusu a 'nyrɛ. ");
INSERT INTO ktj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kɛ‑ ɛ pɩ 'a ‑kʋannunyibli yɩ, ɛ wɛn 'nɩ: «Saan Batisɩ, ‑ɛ pɩ la nyibli 'nie 'lu lɛ, ɛ nɔ‑ ꞊nɩɔ. ‑Tɛ ɛ 'kʋ la, ɛ 'hrɩ 'klɔ de. Ɛ nɔ‑ nu꞊o, 'ɛ nɩ 'klɩ kɩ, 'ɛ ni ꞊wlɩlɛkɛɛ‑tɛblɩ ‑mʋ', ‑ʋ kɔ 'nyrɛ ‑a yɩ 'wɩn.» ");
INSERT INTO ktj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Dɛ ‑mʋ', Helɔdɩ a 'mʋ, ɛ nu la Saan ‑mɔ, 'tɩ‑ Saan a 'mʋ, ɛ 'mʋ la 'kʋ, ɛ nɔ‑ ‑bʋ: Helɔdɩ a 'dɩayɩ nyɩbɛhɩan Filipʋ, ɛ nɔ‑ kɔ la nʋgba, 'a 'nyrɛ 'ɛ mɔ la Helɔdiadɩ. Helɔdiadɩ a 'mʋ, ɛ nɔ‑ Helɔdɩ ‑ha la Filipʋ ꞊jɩ', ɛ kɔ la. ‑Tɛ Saan 'wɩn la ‑tɩ a 'mʋ, ‑ɛ ‑bɩ kɛ‑ ɛ pʋ la, ‑ɛ mɔ: «Ɛ 'yɩ 'ʋ lɛ ‑nɔɔ ‑nɩ, 'kɩ ‑na 'dɩayɩ Filipʋ ‑bʋ, bʋ di 'klɔ nɩ, ‑bʋ di꞊e nʋgba ꞊jɩ' ‑ha, ‑bʋ di꞊e kɔ.» ‑Tɩ a 'mʋ, Saan hla la, ɛ nɔ‑ kɔ ‑tɩ Helɔdiadɩ a 'mʋ, 'ɛ ꞊tutuo la Helɔdɩ, 'kɩ bʋ lee la 'a 'sɛyo, bʋ klɔ la Saan, bʋ mʋa la꞊a, 'tɩ‑ bʋ pʋ la꞊a ꞊jɩ'. ‑Tɛ Saan nɩ 'kɩ 'lɩ ꞊jɩ', ‑ɛ ‑bɩ Helɔdɩ ‑hʋɛ꞊ɛ nɩ, bʋ lee nɛ 'a 'sɛyo, bʋ 'la꞊a. Kɛɛ, ɛ 'yɩ la 'lɩ꞊ɩ 'lɩ ‑wɛ, ‑ɛ nu꞊o, ɛ yɩ pie la nyibli a hʋannʋ. Nyibli wɛn 'nɩ, Saan mɔ la Nyɩsʋa a winwlɔn‑hanyɔ* ꞊nɩɔ la. 'A ‑tɩ, ʋ 'yɩ yɩ ‑blɛɛ ‑nɩ, bʋ ‑hrɛn꞊ɛ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","‑Tɛ ‑nyrɔwɔ ‑mʋ', ʋ kɔ la Helɔdɩ, ɛ nyre la 'ʋ, ‑ɛ ‑bɩ Helɔdɩ da lɛ'mimle. Lɛ'mimle a 'mʋ, ɛ nɔ‑ ʋ mu kɩ, Helɔdiadɩ a 'yu nyrɔyu 'ɛ yɩ ‑wla yi, 'kɩ 'ʋ nyibli a pɛpɛ, ʋ da lɛ'mimle a 'mʋ kɩ ye'. 'A yiyie a 'mʋ, ɛ klɔɔ Helɔdɩ kɩ dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ɛ nɔ‑ nu꞊o, 'ɛ lee ꞊nɛ, ɛ wɛn: «'N 'sʋʋ nɩ, 'a ‑nɛ ꞊dedede, ‑di ‑hʋa, 'n di ‑mɔ꞊ɔ 'nɩ ‑nyi.» ");
INSERT INTO ktj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ɛ nɔ‑ mɔ 'a 'dii bʋ lee nɛ 'a 'yu nyrɔyu dɛ ‑mʋ', ɛ kɔ bʋ nu, 'tɩ‑ 'a 'yu nyrɔyu a 'mʋ, 'ɛ lee Helɔdɩ, ɛ wɛn: «Dɛ 'n ‑hʋɛ, ɛ nɔ‑ mɔ Saan Batisɩ a 'kʋkʋʋ. 'Bɛ 'ʋ 'a 'lu 'ʋ, ‑bʋ pʋ 'lɩ꞊ɩ hu 'kwli, ‑bʋ ya 'mɔ꞊ɔ yɩ, ‑tɛ ti nɛ ‑bʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","‑Tɛ Helɔdɩ 'wɩn, ‑ɛ ‑bɩ 'a ꞊wlʋ bi ꞊hlɔn. Kɛɛ, ‑tɛ ɛ 'sʋʋ wɛn ‑nɩ, 'kɩ 'ʋ nyibli ‑mʋ', ɛ ‑da ye', 'a ‑tɩ, ɛ nɔ‑ nu꞊o, 'ɛ lee nɛ 'a nyibli ‑mʋ' a 'yɛ ‑bɩ, 'kɩ bʋ ‑nyi 'yu nyrɔyu ‑mʋ' dɛ a 'mʋ, ɛ ‑hʋa, ");
INSERT INTO ktj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","bʋ mu 'lɩ ꞊jɩkayu bʋ, bʋ 'bɛ 'ʋ Saan Batisɩ a 'lu, 'a nyiblo a 'mʋ, 'ɛ nu dɛ a 'mʋ, ");
INSERT INTO ktj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","'ɛ pʋ 'lɩ Saan a 'lu hu 'kwli, 'ɛ ya꞊a, 'ɛ ‑nyi꞊e 'yu nyrɔyu a 'mʋ, 'tɩ‑ 'yu nyrɔyu a 'mʋ, 'ɛ gba꞊a 'a 'dii yɩ. ");
INSERT INTO ktj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","‑Tɛ Saan a ‑nagbopʋ di la, ‑ɛ ‑bɩ ʋ gba la 'a 'kʋkʋku nɩ, 'ʋ ‑ha 'ʋ꞊ʋ 'ʋ. ‑Tɛ ʋ ‑wɛ 'ʋ 'a ‑hɩhɩa ‑mɔ, ‑ɛ ‑bɩ ʋ mu nɩ, 'ʋ lee ‑Yusu dɛ a 'mʋ, ‑ɛ muu 'lu ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","‑Tɛ ‑Yusu 'wɩn ‑tɩ a 'mʋ, ‑ɛ ‑bɩ ɛ 'ya 'lɩ 'blagbɩ 'kwli, 'ɛ mu 'lɩ ‑tɩtɛ ‑mʋ', 'dʋ bii 'lɩ yɩ. Kɛɛ, dɛ a 'mʋ, nyibli 'ye꞊e nɩ, 'ʋ ‑hɔn 'dɩɩ klɛ, 'ʋ 'yraa 'yru ꞊wien lɛ, 'ʋ kʋɛ ‑Yusu ꞊wien. ");
INSERT INTO ktj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","‑Yusu bʋ ꞊tɩ 'lɩ 'blagbɩ 'kwli, ‑ɛ ‑bɩ ɛ 'ye nyibli ‑hʋɔhʋɩ ‑mʋ', ‑ʋ nɩ 'ʋ nɩ. Bʋ 'ye 'kɩ ꞊nʋ, ‑ɛ ‑bɩ 'waa nyaɩ ‑tʋa 'a nunuo, nyibli a pɛpɛ ‑mʋ', ‑ʋ kɔ 'hʋɩ ‑hinhren lɛ, 'ɛ nu꞊o, 'waa 'hʋɩ 'ɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","‑Tɛ 'tɔ yɩ nɩ ‑wɛn, ‑ɛ ‑bɩ ‑nagbopʋ* 'yɩya 'ʋ ‑Yusu 'hʋɩ bʋ, 'ʋ yɩ꞊ɩ ‑lee ‑nɩ, ʋ wɛn: «‑Tɩtɛ ‑bʋ, ‑a nɩ 'nɛ‑, 'dʋ bii 'nɛ‑ yɩ, diidɛ 'yɩ 'nɛ‑ ‑nɩ, 'tɩ‑ 'tɔ ‑wɛn nɩ. 'A ‑tɩ, lee nyibli ‑bʋ, bʋ mu 'lɩ 'dɩɩ ‑bʋ, ‑ʋ ꞊glaa 'lɩ ‑a mʋ 'kwli, bʋ mu 'waa dɩɔnʋ a diidɛ lɛ ꞊mʋɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","‑Ɛ ‑bɩ ‑Yusu wɛn: «Ʋ 'yɩ yɩ ‑blɛɛ ‑nɩ, bʋ ‑hɔn 'nɛ‑ ‑wlu. 'Aan ꞊gbɛtʋ, ba ‑nyi ꞊nʋ diidɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kɛ‑ ʋ pɩ꞊ɩ yɩ, ʋ wɛn: «‑A 'yɩ ꞊dedede ‑kɔ, 'bʋ 'yɩ 'flɔɔkui nɩ ꞊hun nɩ ‑do, kɔ ‑hrin.yɔ nɩ 'hʋɛn 'pa‑.» ");
INSERT INTO ktj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","‑Ɛ ‑bɩ ɛ wɛn: «Ba ya 'mɔ꞊ɔ yɩ,» 'ʋ ya ꞊nɛ꞊ɛ yɩ, ");
INSERT INTO ktj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","'tɩ‑ 'ɛ lee nyibli ‑mʋ', 'kɩ bʋ nɩ blɛ, 'kɩ 'ʋ ‑piti kɩ. ‑Tɛ ʋ nɩ 'kɩ blɛ, ‑ɛ ‑bɩ ‑Yusu 'du 'flɔɔkui nɩ ꞊hun kɔ ‑hrin.yɔ nɩ 'hʋɛn a 'mʋ ye', 'ɛ 'du 'lu ye', 'ɛ ta 'lɩ yɔ' lɛ, 'ɛ ‑nyi Nyɩsʋa 'wio, 'kɩ 'ʋ diidɛ a 'mʋ a ‑ta', 'tɩ‑ 'ɛ 'bɛ꞊ɛ ꞊tɩɔ lɛ, 'ɛ ‑nyi꞊e 'a ‑nagbopʋ, 'a ‑nagbopʋ a 'mʋ, 'ʋ ꞊gla꞊a nyibli a pɛpɛ a 'mʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","'Waa pɛpɛ a 'mʋ, 'ʋ di dɛ ‑didi, 'ʋ ꞊mla. ‑Tɛ ʋ ‑wɛ dɛ lɛ, ‑ɛ ‑bɩ dididɛ a 'mʋ, ‑ɛ hie blɛ, ‑nagbopʋ, ʋ 'kukue꞊e lɛ, 'ʋ 'yii 'lɩ ‑tʋgbɛwɩ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn. ");
INSERT INTO ktj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nyibli a 'mʋ, ‑ʋ di dɛ, 'bʋ 'yɩ 'yonʋ kɔ nʋgbɩ 'hʋɛn‑ ‑hre, ʋ ‑wɛ 'lɩ bʋ mɔ nyɩbɛpʋ a (5000) 'miliwɩ nɩ ꞊hun nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ ‑Yusu lee nɛ 'a ‑nagbopʋ nɩ, 'kɩ bʋ 'ya 'lɩ 'blagbɩ 'kwli, bʋ ꞊ta 'yru, ɛ 'mʋ ꞊nʋ ꞊wien kʋɛ. Ti a 'mʋ 'yri, 'kɩ ɛ di 'ʋ nyibli wlu ‑gbaa ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","‑Tɛ ɛ gba 'kɩ ꞊nʋ wlu, ‑ɛ ‑bɩ ɛ nɩ ‑do, ɛ ya 'lɩ dʋgba 'lu, 'ɛ mu 'lɩ Nyɩsʋa ‑mɔ hlee mɔ. ‑Tɛ 'tɔ ‑wɔn, ‑ɛ ‑bɩ ɛ nɩ ‑do, ɛ nɔ‑ 'tɩɛ nɩ 'lɩ dʋgba a 'mʋ 'lu. ");
INSERT INTO ktj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","'Blagbɩ 'tɩɛ nɩ 'ʋ 'nie a ‑hɛyri', 'yru a 'dʋɩ 'ɛ yɩ 'blagbɩ yrɛ ꞊gbɛ, ‑ɛ nu꞊o, pepe yɩ 'nɩ ‑hu dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Yɩ‑hɛhapɩ bʋ pʋ win a ti 'yri, ‑ɛ ‑bɩ ɛ mi 'ʋ ꞊nʋ 'hʋɩ, 'ɛ nɛ 'nie kɩ. ");
INSERT INTO ktj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","‑Tɛ ɛ yɩ 'nie kɩ nɩ nɛ, ʋ 'ye꞊e, ‑ɛ ‑bɩ ʋ 'ta 'ʋ blɛ. Hʋannʋ a ‑tɩ, ʋ wɛn 'nɩ: «'Ku* ꞊nɩɔ,» 'ʋ ‑tʋa ‑cici a lɛpʋpʋʋ. ");
INSERT INTO ktj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ: «Ba 'kee 'ʋblɛ'tɩta. 'Mɔ ꞊nɩɔ. A 'nɩ 'pie 'lɩ hʋannʋ!» ");
INSERT INTO ktj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","‑Ɛ ‑bɩ Piɛlɩ wɛn: «Kʋkɔnyɔ, sɛyɩ‑sɛyɩ, 'bʋ mɔ ‑mɔ, ‑ɛ ‑bɩ lee 'mʋ, ꞊bʋ na 'nie kɩ ‑wɛ, ꞊bʋ di 'ʋ ‑mʋ 'hʋɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","‑Ɛ ‑bɩ ‑Yusu ꞊tu꞊o ꞊wɔn, ɛ wɛn: «Di 'lɩ!» ‑Ɛ ‑bɩ Piɛlɩ ꞊tɩɩ 'lɩ 'blagbɩ 'kwli nɩ, 'ɛ ‑tʋa 'nie a kɩnɩna, 'ɛ mi 'lɩ ‑Yusu 'hʋɩ. ");
INSERT INTO ktj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","‑Tɛ ɛ 'ye꞊e, ‑ɛ mɔ, pepe yɩ 'nɩ ‑hu dɩakɩ, ‑ɛ ‑bɩ hʋannʋ bi 'lɩ꞊ɩ 'kwli, 'ɛ ‑tʋa 'mɩmɩɛ. Bʋ yɩ 'kɩ nɩ 'mɩɛ, ‑ɛ ‑bɩ ɛ 'yaa 'lɩ win, ɛ wɛn: «Kʋkɔnyɔ o, wa 'mʋ ‑o!» ");
INSERT INTO ktj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ ‑Yusu hrʋ dabʋɩ nɩ, 'ɛ klɔ꞊ɔ, 'tɩ‑ 'ɛ lee ꞊nɛ, ɛ wɛn: «꞊Yɩ 'mʋ ꞊wlʋ yɩ ‑kuo ‑nɩ ‑tɛɛ, ‑ɛ mɔ, 'n ‑wɛ 'lɩ ꞊bʋ nu꞊o nɩ, ‑bʋ na 'nie kɩ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","‑Ɛ ‑bɩ ʋ nɩ 'hʋɛn a 'mʋ, ʋ 'ya 'lɩ 'blagbɩ 'kwli. ‑Tɛ ʋ 'ya 'kɩ, ‑ɛ ‑bɩ pepe ꞊tɩɩ 'lɩ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","'A ‑nagbopʋ ‑bɩ ‑mʋ', ‑ʋ nɩ 'lɩ 'blagbɩ 'kwli, ʋ bla꞊a kwlɩ yɩ bʋ, ʋ wɛn: «'Ɛ mɔ ‑tɛɛ, ‑mɔ Nyɩsʋa a 'Yu ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","‑Tɛ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ ꞊ta 'yru, ‑ɛ ‑bɩ ʋ nyre 'lɩ Senesalɛtɩdɩɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","‑Tɛ ʋ nyre 'lɩ, ‑ɛ ‑bɩ nyibli ‑mʋ', ‑ʋ nɩ 'lɩ 'dɩɔ a 'mʋ 'kwli, ʋ yru ‑Yusu nɩ. Ɛ nɔ‑ mɔ bʋ 'hɛɛn 'a 'nyrɛ 'blʋgba a pɛpɛ kɩ bʋ, ‑ɛ mɔ, ‑Yusu nyre 'lɩ ꞊nʋ ‑mɔ nɩ. Ɛ nɔ‑ nu꞊o, nyibli 'ʋ ya꞊a kɩklanyibli a pɛpɛ yɩ, ");
INSERT INTO ktj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","'ʋ nyɛɛ ꞊nɛ lɛ, 'kɩ bʋ wɛn, bʋ ‑hrɛn 'a wlawlʋ lɛ dadʋ, mɔ 'ye ꞊bɩɩ 'a wlawlʋ a 'mʋ a ‑wlubʋdɛ, nyibli a pɛpɛ ‑hrɛn꞊ɛ lɛ, 'waa 'kʋɛ yɩ 'nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ɛ kɔ la ‑nyrɔwɔ ꞊dʋ, Falisi꞊tumu* a nyibli ꞊dʋ, ʋ kɔ Nyɩsʋa a tetetɔɔnyʋ ꞊dʋ 'hʋɛn‑, ʋ nʋ‑ ‑hɔn 'lɩ Jrusrɛdɩɔ 'kwli, 'ʋ mu 'lɩ ‑Yusu ‑mɔ, 'ʋ mu꞊o 'bɛti mɔ, ʋ wɛn: ");
INSERT INTO ktj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Dɛ a 'dɩ ‑bɩ, ‑kɔtɩ ‑na ‑nagbopʋ* 'yɛ nɩ ꞊tuu 'ʋ tete ‑bʋ, ‑aan 'baɩnʋ tɔɔ nɛ ‑a mʋ 'lɩ? 'Bʋ 'mʋ dɛ di, ʋ 'nɩ ‑yra꞊a ꞊jrɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ɛ nɔ‑ mɔ ‑Yusu bʋ ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «'A mʋ ‑mɔ ‑bɩ, dɛ‑ kɔ ‑tɩ 'a 'yɛ nɩ ꞊tuu 'ʋ Nyɩsʋa a tete 'ʋ, 'a ꞊tui 'ʋ 'a mʋ nɩ ‑do a tete 'ʋ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, Nyɩsʋa ‑nyi ‑a mʋ tete. Tete a 'mʋ, ɛ nɔ‑ yɩ ‑a mʋ ‑lee ‑nɩ, ‑ɛ mɔ: ꞊Tuu 'ʋ ‑na 'baɩ kɔ ‑na 'dii 'hʋɛn‑ 'ʋ, 'kɩ 'lɩ 'waa nʋɛlɛ 'kwli. Kɛ‑ tete a 'mʋ, 'a dɛ ‑bɩ pɩ: Nyiblo 'bʋ ‑ha 'a 'dii kɔ 'a 'baɩ 'hʋɛn‑ 'hri lɛ, ʋ kɔ bʋ 'la꞊a. ");
INSERT INTO ktj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kɛɛ, 'a mʋ ‑mɔ ‑bɩ, a wɛn 'nɩ: Nyiblo ‑wɛ 'lɩ bʋ lee nɛ 'a 'baɩ kɔ 'a 'dii 'hʋɛn‑ nɩ, ‑ɛ mɔ: 'Na kʋkɔ‑tɛblɩ a 'kʋtɩɔ ‑bɩ, 'n kɔ ꞊bʋ ‑nyi wɛn꞊ɛ 'a mʋ, 'kɩ 'ʋ 'aan ‑hɛɛlɛ a ‑ta', 'n ‑ha꞊a nɩ, 'kɩ 'ʋ Nyɩsʋa a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","‑Ɛ ‑bɩ a wɛn 'nɩ: Nyiblo a 'mʋ, 'bʋ nu lɛ, 'bʋ hla ‑tɩdʋ a 'mʋ, 'kɩ 'ʋ 'a 'baɩ kɔ 'a 'dii 'hʋɛn‑ ‑mɔ', ‑ɛ ‑bɩ ɛ 'yɩ 'kɩ yɩ ‑blɛɛ ‑nɩ, bʋ ‑hɛɛ 'kɩ ꞊nʋ de. Kɛ‑ a ni 'kɩ, 'a ꞊tui 'ʋ 'aan dɩɔnʋ a tete 'ʋ, 'a 'wlɛ Nyɩsʋa a tete. ");
INSERT INTO ktj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","A nɛ 'li nɩ 'hʋɛn. Ti ꞊dʋ a ti 'yri, winwlɔn‑hanyɔ Esai hla la ‑tɩ a ‑tɛɛ, 'kɩ 'ʋ 'a mʋ ‑bʋ ‑mɔ. Dɛ, ɛ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, ɛ nɔ‑ ‑bʋ: ");
INSERT INTO ktj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Nyɩsʋa wɛn 'nɩ: Dakɔ ‑bʋ, ʋ yɩ ‑nyi 'mʋ ‑tɩ a 'yi'bʋalɛ, 'kɩ 'ʋ wuntɔ 'yri, kɛɛ, 'waa ꞊wlɩ hlɔɔ 'mʋ ‑mɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ʋ wɛn 'nɩ, 'n kɔ ‑tɩ a 'yi'bʋalɛ, kɛɛ, 'na ‑tɩ 'yɩ 'lɩ 'waa ꞊wlɩ kɩ ‑nɩ, ‑ɛ nu꞊o, ‑tonyibli a tete, ʋ tʋɛ ‑nɩ, ɛ nɔ‑ ʋ dɛɛ Nyɩsʋa a tete.» ");
INSERT INTO ktj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","‑Ɛ ‑bɩ ‑Yusu da nyibli ‑bɩ ‑mʋ' nɩ, ‑ʋ nɩ 'ʋ ‑tuo nɩ ‑do a 'mʋ kɩ, 'ɛ ‑tʋa 'waa leelɛ, ɛ wɛn: «Ba pʋ 'mʋ nʋa yɩ bʋ, ‑tɩ 'n di hla, a 'mʋ꞊ʋ' lɛ yru. ");
INSERT INTO ktj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Dididɛ ‑bʋ, ‑ɛ nɛɛ 'lɩ ‑tonyiblo wlɔn, ɛ 'yɩ꞊ɩ 'pa‑, ɛ 'nɩ ‑nu꞊o lɩ꞊ɩ, ɛ 'nɩ 'sii꞊e 'ʋ yɩ, 'kɩ 'ʋ Nyɩsʋa ye'. Kɛɛ, dɛ ‑bʋ, ‑ɛ ‑hʋɛn 'lɩ ‑tonyiblo a ꞊wlʋ kɩ, ɛ nɔ‑ ni꞊e, 'kɩ ɛ 'yɛ nɩ 'sii 'ʋ yɩ, 'kɩ 'ʋ Nyɩsʋa ye'.» ");
INSERT INTO ktj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","‑Ɛ ‑bɩ 'a ‑nagbopʋ* 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, 'ʋ lee ꞊nɛ, ʋ wɛn: «꞊Bɩ ꞊yɩ꞊ɩ ‑yi, ‑ɛ mɔ, ‑tɩ ‑bʋ, ‑hlɛ, ɛ pʋ Falisi꞊tumu* a nyibli a ꞊wlɩ yrʋ' lɛ?» ");
INSERT INTO ktj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","‑Ɛ ‑bɩ ɛ ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «'A ‑nɛ 'dʋdɔdɛ ꞊dʋ, 'bʋ nɩ 'ʋ, 'na 'Baɩ Nyɩsʋa ‑mʋ', ‑ɛ nɩ 'lɩ yakɔ 'kwli, ɛ 'yɩ 'dɔ, ʋ di ‑ha꞊a ‑wlu.» (‑Tɩ a 'mʋ, ‑Yusu hlɛ, Falisi꞊tumu a nyibli ‑mʋ', ‑ʋ 'yɩ ‑tɛɛ a Nyɩsʋanyibli 'pa‑, ʋ nʋ‑ ɛ ꞊hɛn 'nyrɛ.) ");
INSERT INTO ktj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kɛ‑ ‑Yusu pɩ de, ɛ wɛn 'nɩ: «Ba ‑ha ꞊nʋ mɛ lɛ. Ʋ mɔ 'yii'dɔnyʋ ꞊nɩɔ, ‑ʋ ‑hʋɛ ‑bʋ naa 'waa 'bio 'yii'dɔnyʋ. ‑A 'blikʋɛ wɛn 'nɩ: 'Yii'dɔnyɔ 'bʋ yɩ 'a 'bɩhɩan 'yii'dɔnyʋ nɩ ‑nɛɛ ‑nɩ, ʋ nɩ 'hʋɛn a 'mʋ, ʋ di bi 'lɩ 'butɩɔ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","‑Ɛ ‑bɩ kɛ‑ Piɛlɩ pɩ 'kɩ, ɛ wɛn: «'Ledʋ a 'mʋ, ‑pʋ wɛn, ‑hɩhɩa ‑a mɔ꞊ɔ klɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","‑Ɛ ‑bɩ ‑Yusu wɛn 'nɩ: «꞊Bɩ 'aan 'mumu ‑bʋ, a 'yɩ ‑hʋan ‑tɩ a lɛyuyruo nɩ kʋɛ? ");
INSERT INTO ktj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","꞊Bɩ a 'nɩ ‑yru꞊o lɩ꞊ɩ lɛ, ‑ɛ mɔ dididɛ ‑bʋ, ‑ɛ nɛɛ 'lɩ ‑tonyiblo wlɔn, 'kɩ ɛ mi 'lɩ꞊ɩ 'kwli, 'ɛ nɛɛ 'lɩ, 'ɛ yɩ 'lɩ ‑patʋ' bi. ");
INSERT INTO ktj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Dɛ ‑bʋ, ‑ɛ ‑hʋɛn 'lɩ nyiblo wlɔn, 'kɩ ɛ ‑hʋɛn 'lɩ 'a ꞊wlʋ kɩ. Ɛ nɔ‑ ni꞊e, 'ɛ 'yɛ nɩ 'sii 'ʋ yɩ, 'kɩ 'ʋ Nyɩsʋa ye', ");
INSERT INTO ktj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","‑ɛ nu꞊o, 'kɩ 'lɩ ‑tonyiblo a ꞊wlʋ kɩ, 'kɩ 'lulɛ‑hihie ‑hʋɩn ‑hʋɛn 'lɩ ‑wlu, 'ʋ ni꞊e, 'ɛ ni ‑tɛblɩ ‑hʋɩn, 'ɛ 'lɛ nyibli, 'ɛ ni ‑wlawlɩ, 'ɛ ni 'lawlu, 'ɛ yɩ 'yri, 'ɛ pɩ 'a 'bio hɩ klɛ, 'ɛ yɩ nyibli a 'nyrɛ yɩ nyre. ");
INSERT INTO ktj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","‑Tɛblɩ a pɛpɛ a 'mʋ, ɛ nɔ‑ ni꞊e, 'kɩ ‑tonyiblo 'yɛ nɩ 'sii 'ʋ yɩ, 'kɩ 'ʋ Nyɩsʋa ye'. Kɛɛ, nyiblo bʋ yra ꞊jrɛ, bʋ di dɛ, ɛ 'nɩ nu꞊o lɩ꞊ɩ, nyiblo a 'mʋ, ɛ 'nɩ 'sii꞊e 'ʋ yɩ, 'kɩ 'ʋ Nyɩsʋa ye'.» Kɛ‑ ‑Yusu pʋ 'a ‑nagbopʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu ‑hɔn 'lɩ ‑Juukʋɛ a 'blʋ 'kwli nɩ, 'ɛ mu 'lɩ hɩapʋblʋgba ‑bɩ 'kwli. 'Kɩ 'lɩ 'blʋgba a 'mʋ 'kwli, 'kɩ 'dɩɩ ‑mʋ', ‑ʋ mɔ Tilɩ kɔ Sidɔ 'hʋɛn‑, ʋ nɩ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","'Kɩ 'lɩ ‑tɩtɛ a 'mʋ, 'kɩ nʋgba ꞊dʋ nɩ 'lɩ. Nʋgba a 'mʋ, ɛ 'yɩ ‑Juukʋɛyrɔwlʋ 'pa‑. Kanaakʋɛyrɔwlʋ ꞊nɩɔ. (‑Juukʋɛ ‑mɔ ‑bɩ, nyibli ‑mʋ', ‑ʋ 'yɩ ‑Juukʋɛ 'pa‑, ʋ dɛɛ ꞊nʋ ‑gbo.) ‑Tɛ ‑Yusu nyre 'lɩ, ‑ɛ ‑bɩ nʋgba a 'mʋ, ɛ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, 'ɛ 'yaa 'lɩ win, 'ɛ yɩ꞊ɩ ‑lee ‑nɩ, ɛ wɛn: «Dafidɩ* a 'Yu! Yru 'na nyaɩ. 'Ku ‑hʋan* nɩ 'ʋ 'na 'yu nyrɔyu ke', 'ɛ ꞊tui꞊e ꞊hɩʋɛn dɩakɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kɛɛ, ‑Yusu 'yɩ꞊ɩ mɛ lɛ ‑pʋ, 'a ‑nagbopʋ*, 'ʋ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, 'ʋ nyɛɛ ꞊nɛ lɛ, ʋ wɛn: «Bla꞊a lɛ, ‑ɛ nu꞊o, ɛ pɩ ‑cici lɛ dɩakɩ, 'ɛ yɩ ‑a mʋ ꞊wien lɛ kʋɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ nʋgba a 'mʋ yɩ, ɛ wɛn: «Yisraɛkʋɛ* ‑bʋ, ‑ʋ mɔ Nyɩsʋa a dakɔ, ‑ʋ hlɔɔ Nyɩsʋa ‑mɔ lɛ, ‑wɛn blablɩ, ‑ʋ hlɔɔ 'blakɔnyɔ ‑mɔ lɛ, ʋ nɩ ‑do, ʋ nʋ‑ kɔ ‑tɩ Nyɩsʋa 'ɛ tɛɛ 'nɛ‑ 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ɛ nɔ‑ mɔ nʋgba a 'mʋ, bʋ bla꞊a kwlɩ yɩ bʋ, ɛ wɛn: «Tɔɔnyɔ o, ‑hɛɛ 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","‑Ɛ ‑bɩ kɛ‑ ‑Yusu ‑pʋ, 'ɛ ꞊tu꞊o ꞊wɔn, ɛ wɛn: «꞊Bʋ pʋ꞊ʋ dɛ yɩ: Ɛ 'yɩ 'ʋ lɛ ‑nɔɔ ‑nɩ, 'kɩ 'yonʋ ‑mʋ', (‑ʋ mɔ ‑Juukʋɛ,) bʋ nɩ 'lɩ dɛ a didie 'kwli, 'tɩ‑ nyiblo ꞊dʋ bʋ ‑ha 'ʋ ꞊nʋ 'waa dididɛ a 'mʋ ye', bʋ 'wla 'ʋ꞊ʋ ‑gbo ye' bʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","‑Ɛ ‑bɩ nʋgba a 'mʋ, ɛ wɛn: «Tɔɔnyɔ o, ɛ mɔ ꞊han‑tɩ ꞊nɩɔ. Kɛɛ 'kɩ, nyibli 'bʋ yɩ dɛ nɩ di, ‑tɛblɩ yɩ ble ꞊nʋ ꞊jrɛ, 'waa ‑gbo 'ʋ yɩ꞊ɩ lɛ 'tɩ, 'ʋ yɩ꞊ɩ di.» ");
INSERT INTO ktj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","‑Yusu ꞊tu꞊o ꞊wɔn de, ɛ wɛn: «Nʋgba o, ‑tɛ ‑kuo 'mʋ ꞊wlʋ yɩ dɩakɩ, 'a ‑tɩ, dɛ ‑mʋ', ‑hʋɛ, 'n kɔ ꞊bʋ nu꞊o.» ‑Ɛ ‑bɩ ti nɩ ‑do a ti 'yri, 'yu nyrɔyu a 'mʋ a 'kʋɛ ‑wɛ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu ‑hɔn 'lɩ ‑tɩtɛ a 'mʋ nɩ, 'ɛ mu 'lɩ Galileblʋgba a 'yru wien. ‑Tɛ ɛ nyre 'lɩ, ‑ɛ ‑bɩ ɛ 'ya 'lɩ dʋgba 'lu, 'ɛ nɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bʋ nɩ 'kɩ bʋ, ‑ɛ ‑bɩ nyibli ‑hʋɔhʋɩ, ʋ ‑hɔn ‑tɛblɩ 'nyɩ lɛ, 'ʋ di 'ʋ꞊ʋ 'hʋɩ, 'ʋ ya꞊a kɩklanyibli yɩ: lɛ‑yɩyrɛnyibli, 'yii'dɔnyʋ, kɔ nyibli ‑mʋ', ‑ʋ 'yɩ 'plɛlɛ ‑yi, nɩanɩnyʋ kɔ nyibli ‑hʋɔhʋɩ ‑bɩ, hɩapʋkʋɛ ‑bɩ ni, kɩklanyibli a pɛpɛ a 'mʋ, 'ʋ ya 'ʋ ꞊nʋ ‑Yusu a bʋɩ ꞊hlɔn, 'ɛ nu꞊o, 'waa 'kʋɛ 'ɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","‑Tonyibli a ꞊wlɩ kɛɛ lɛ, ‑tɛ ʋ 'ye nyibli ‑mʋ', ‑ʋ 'yɩ mɔ 'plɛlɛ ‑yi, ʋ yɩ 'plɛ, kɔ, nɩanɩnyʋ 'yɩ 'kɩ nɩa ‑nɩ de, lɛ‑yɩyrɛnyibli nɛ nɩ, 'yii'dɔnyʋ yrui lɛ. Dɛ a 'mʋ, ɛ nu꞊o nɩ, Nyɩsʋa ‑mʋ', Yisraɛkʋɛ dɛ mɔ, 'ʋ ‑tʋa 'a 'nyrɛ a lɛpʋpʋʋ. ");
INSERT INTO ktj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu da 'a ‑nagbopʋ* nɩ, ɛ wɛn: «Nyibli ‑bʋ, 'waa nyaɩ ni 'mʋ nɩ, ‑ɛ nu꞊o, ‑tɛ ʋ bi la mɔ 'mʋ 'hʋɩ, 'a ‑nyrɔwɩ nɩ ta a ‑nyrɔwɔ ‑bʋ, 'tɩ‑ ʋ 'yɩ dididɛ ‑kɔ. 'Bʋ 'yɩ dɛ ‑di, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ lee ꞊nʋ, bʋ mu 'lɩ 'waa 'dɩɩ 'kwli lɛ, ‑ɛ di꞊e nu, 'kanʋ a ‑tɩ, 'waa 'klɩ 'nɩ ꞊ha 'lɩ 'hru wlɔn ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","‑Ɛ ‑bɩ 'a ‑nagbopʋ wɛn: «‑Bɩ' ‑a di 'kɩ nu, 'tɩ‑ ‑a 'mʋ nyibli ‑hʋɔhʋɩ ‑bʋ dididɛ ‑nyi, ʋ 'mʋ ꞊mla. ‑Tɩtɛ ‑bʋ, ‑a nɩ 'nɛ‑, 'dʋ bii 'nɛ‑ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","‑Ɛ ‑bɩ ‑Yusu 'bɛti ꞊nʋ nɩ, ɛ wɛn: «'Flɔɔkui nɩ ‑tie nɩ 'ʋ 'a mʋ 'hʋɩ 'lɩ?» Ʋ wɛn: «'A 'yɔ nɩ ꞊hlon'hʋɛn kɔ ‑hrin.yɔ gbi.» ");
INSERT INTO ktj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ɛ nɔ‑ mɔ bʋ lee nyibli ‑mʋ', ‑ʋ nɩ 'ʋ꞊ʋ 'hʋɩ, 'kɩ bʋ nɩ blɛ, ");
INSERT INTO ktj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","'ɛ 'du 'ʋ 'flɔɔkui nɩ ꞊hlon'hʋɛn a 'mʋ ye', ʋ kɔ ‑hrin.yɔ ‑nɩ wɛn 'hʋɛn‑, 'ɛ ‑nyi Nyɩsʋa 'wio, 'ɛ 'bɛ꞊ɛ ꞊tɩɔ lɛ, 'ɛ ‑nyi꞊e 'a ‑nagbopʋ, 'ʋ ꞊gla꞊a nyibli a 'mʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nyibli a pɛpɛ di dɛ ‑tɛɛ, 'ʋ ꞊mla. ‑Tɛ ʋ ꞊mla, 'flɔɔ, ‑ɛ hie bʋ, ‑tɛ 'a ‑nagbopʋ 'kukue꞊e lɛ, ʋ 'yii 'lɩ ‑tʋgbɩ gbagbɩ nɩ ꞊hlon'hʋɛn. ");
INSERT INTO ktj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nyibli a 'mʋ, ‑ʋ di dɛ, 'bʋ mɔ, 'bʋ 'yɩ 'yonʋ kɔ nʋgbɩ 'hʋɛn ‑hre, ʋ mɔ nyɩbɛpʋ a 'miliwɩ nɩ ‑hɛn. ");
INSERT INTO ktj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ɛ nɔ‑ ‑hi, 'tɩ‑ ‑Yusu 'ɛ tɛ ꞊nʋ bʋ, 'kɩ bʋ mu 'lɩ 'waa 'dɩɩ 'kwli lɛ, ɛ nɔ‑ ‑mɔ ‑bɩ, 'ɛ ‑mu, 'ɛ 'ya 'lɩ 'blagbɩ 'kwli, ɛ kɔ 'a ‑nagbopʋ 'hʋɛn‑, 'ʋ mu 'lɩ 'blʋgbakʋtɩɔ ‑bɩ kɩ. 'Kɩ 'lɩ 'blʋgbakʋtɩɔ a 'mʋ kɩ, 'kɩ 'dɩɔ ‑mʋ', ʋ dɛɛ Magada, ɛ nɩ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ Falisi꞊tumu kɔ Sadusɩ꞊tumu* a nyibli 'hʋɛn‑, ʋ nʋ‑ 'yɩya 'ʋ ‑Yusu 'hʋɩ bʋ, ‑ɛ di꞊e nu, ʋ 'mʋ 'ʋ꞊ʋ lɛ ꞊tɛɛ ‑nɩ. Ɛ nɔ‑ nu꞊o, 'ʋ lee ꞊nɛ, 'kɩ bʋ nu ꞊wlɩlɛkɛɛdɛ, ‑ɛ di ꞊nʋ꞊ʋ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, Nyɩsʋa, ɛ nɔ‑ lee 'nɛ꞊ɛ ‑tʋtʋ kɩ. ");
INSERT INTO ktj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kɛɛ, ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «'Tɔ 'bʋ yɩ ‑wɔn mɔ nɩ mi, 'ba 'ye꞊e, ‑ɛ mɔ, 'nu 'yɩ 'lɩ yɔ' lɛ ‑nɩ, ‑ɛ ‑bɩ kɛ‑ a pɩ: 'Yrʋ di ‑hʋan 'nɩ hʋɛn. ");
INSERT INTO ktj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","‑Nyrɛ 'bʋ ‑nyɛ, 'ba 'ye꞊e, ‑ɛ mɔ, 'nu nɩ 'lɩ yakɔ 'kwli, ‑ɛ ‑bɩ kɛ‑ a pɩ: 'Nu di kɛ 'nɩ di. ‑Tɛblɩ ‑mʋ', ‑ɛ mi 'lu ‑mɔ, 'kɩ 'lɩ yakɔ 'kwli, a yi 'waa klɛ‑hɩhɩalɛ, 'a yɩ꞊ɩ 'ye, ‑tɛ ‑nyrɛ di 'mʋ nɩ. Kɛɛ, ‑tɛblɩ ‑bʋ, Nyɩsʋa ni, ‑ʋ mi kɛ 'lu ‑mɔ, a 'yɩ 'waa klɛ‑hɩhɩalɛ ‑yi. ");
INSERT INTO ktj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ti ‑bʋ 'yri a nyibli a nunuklɔ nyre yɩ, 'ʋ plee 'lɩ Nyɩsʋa ke, 'tɩ‑ 'ʋ ‑hʋɛ ꞊wlɩlɛkɛɛdɛ de, ‑ɛ di ꞊nʋ꞊ʋ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, Nyɩsʋa, ɛ nɔ‑ lee 'nɛ‑ 'mʋ ‑tʋtʋ kɩ. Kɛɛ, Nyɩsʋa 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ wɛn, 'kɩ ba 'ye ꞊wlɩlɛkɛɛdɛ ꞊dʋ. ꞊Wlɩlɛkɛɛdɛ nɩ ‑do ‑mʋ', Nyɩsʋa di nu, 'kɩ 'ʋ ꞊nʋ ‑mɔ, ɛ di 'wɩ‑ 'a dɛ ‑bɩ ‑mʋ', ɛ nu la, 'kɩ 'ʋ winwlɔn‑hanyɔ Jona a ‑ta'.» Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ɛ ‑hɔn 'ʋ ꞊nʋ 'hʋɩ, ɛ kɔ 'a ‑nagbopʋ* 'hʋɛn‑, 'ʋ mu 'lɩ Galileblʋgba a 'yru a 'kɩbɩa ‑bɩ kɩ. ");
INSERT INTO ktj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","‑Tɛ ‑Yusu a ‑nagbopʋ* yɩ 'lɩ 'blagbɩ 'kwli nɩ 'yɛ, ɛ ‑hru ꞊nʋ ‑mɔ, 'kɩ bʋ gba 'flɔɔ ‑mʋ', ʋ di di, 'ʋ nyre 'lɩ 'yru a 'kɩbɩa ‑bɩ ‑mʋ' kɩ. ");
INSERT INTO ktj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","‑Ɛ ‑bɩ ‑Yusu ‑tʋa 'waa titie, ɛ wɛn: «Falisi꞊tumu a nyibli, kɔ Sadusɩ꞊tumu* a nyibli 'hʋɛn‑, 'waa 'flɔɔ a 'yaadɛ a ‑tɩ, ba ꞊tu 'aan dɩɔnʋ 'yie.» ");
INSERT INTO ktj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","‑Nagbopʋ ‑mɔ ‑bɩ, ʋ 'yɩ꞊ɩ' lɛ ‑yru, ‑ɛ mɔ, 'yaadɛ a 'mʋ, ‑kɔtɩ ‑Yusu hlɛ, ɛ mɔ dɛ a yɩpʋʋdɛ ꞊nɩɔ, ‑ɛ ꞊hɛn 'nyrɛ, nyibli a 'mʋ, 'waa 'lulɛ‑hihie ‑hʋan. Bʋ 'yɩ 'kɩ ‑tɩ a 'mʋ lɛ ‑yru, ɛ nɔ‑ kɔ ‑tɩ 'ʋ yɩ 'waa dɩɔnʋ lɛ 'bɛti ‑nɩ, ʋ wɛn: «꞊Bɩ ‑tɛ ‑a 'yɩ 'flɔɔ ‑ya, ɛ nɔ‑ kɔ ‑tɩ 'ɛ ni 'pʋplɛ lɛ?» ");
INSERT INTO ktj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","‑Tɩ a 'mʋ, ‑nagbopʋ ‑hla, ‑Yusu 'wɩn nɩ, ɛ wɛn: «'A mʋ ‑bʋ, ‑ʋ 'yɩ 'mʋ ꞊wlʋ yɩ ‑kuo ‑nɩ, dɛ‑ kɔ 'kla ꞊yɛ 'a mʋ ‑wliye 'lɩ? ꞊Bɩ ‑tɛ a 'yɩ dididɛ ‑kɔ a ‑tɩ? ");
INSERT INTO ktj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","A 'tɩɛ 'yɛ ‑tɩ a' lɛyuyruo nɩ kʋɛ, ɛ kɔ, a kla ‑tɩ‑mɔ‑hru‑tɩ. ‑Tɛ 'n wloo la 'flɔɔkui nɩ ꞊hun, 'kɩ nyibli a 'miliwɩ nɩ ꞊hun bʋ di dɛ a ‑ta', ‑tɛ ʋ ‑wɛ la dɛ lɛ, 'flɔɔ ‑mʋ', ‑ɛ hie la bʋ, ‑tʋgbɩwɩ nɩ ‑tie a 'yii la 'lɩ 'lɩ? ꞊Bɩ ɛ ‑hru 'a mʋ ‑mɔ? ");
INSERT INTO ktj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ɛ kɔ, ‑tɛ 'n wloo la 'flɔɔkui nɩ ꞊hlon'hʋɛn, 'kɩ ‑tonyibli a 'miliwɩ nɩ ‑hɛn bʋ di dɛ a ‑ta', 'tɩ‑, ‑tɛ ʋ ‑wɛ la dɛ lɛ, 'flɔɔ ‑mʋ', ‑ɛ hie la bʋ, ‑tʋgbɩwɩ nɩ ‑tie a 'yii la 'lɩ 'lɩ? ꞊Bɩ ɛ ‑hru 'a mʋ ‑mɔ ‑wɛ? ");
INSERT INTO ktj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","꞊Bɩ a 'nɩ 'ye꞊e lɩ꞊ɩ, ‑ɛ mɔ, ɛ 'yɩ 'flɔɔ a ‑tɩ 'pa‑, 'nɩ ‑hla꞊a lɩ꞊ɩ? Kɛ‑ 'n pɩ, ‑ɛ mɔ: Falisi꞊tumu a nyibli, kɔ Sadusɩ꞊tumu a nyibli 'hʋɛn‑, 'waa 'flɔɔ a 'yaadɛ a ‑tɩ, ba ꞊tu 'aan dɩɔnʋ 'yie.» ");
INSERT INTO ktj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","‑Tɛ ‑Yusu pʋ 'kɩ lɛ, ‑ɛ ‑bɩ, 'a ‑nagbopʋ yru꞊o lɛ, ‑ɛ mɔ, ‑Yusu 'nɩ ‑pʋ꞊ʋ lɛ, 'kɩ bʋ ꞊tu 'waa dɩɔnʋ 'yie, 'kɩ 'ʋ 'flɔɔ a 'yaadɛ a ‑ta', kɛɛ, bʋ ꞊tu 'waa dɩɔnʋ 'yie, 'kɩ 'ʋ hɩtɔɔlɛ ‑mʋ', Falisi꞊tumu kɔ Sadusɩ꞊tumu a nyibli 'hʋɛn‑ tʋɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, 'blʋgbakʋtɩɔ ‑mʋ', ‑ɛ 'mʋɛ 'blʋgba ‑mʋ' yrɛ, ‑ɛ kɔ 'nyrɛ mɔ Filipʋ a Sesale, 'kɩ ʋ mu 'lɩ. Bʋ yɩ 'kɩ nɩ mi, ‑ɛ ‑bɩ ɛ yɩ ꞊nʋ 'nɩ 'bɛti ‑nɩ, ɛ wɛn: «'Mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, ‑bɩ' ‑tonyibli pɩ 'na ‑tɩ 'lɩ, ʋ wɛn, nyiblo a 'dɩ ‑bɩ 'n pa 'mʋ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","‑Ɛ ‑bɩ ʋ ꞊tu꞊o ꞊wɔn, ʋ wɛn: «Nyibli ‑bɩ wɛn 'nɩ, Saan Batisɩ ‑mʋ', ‑ɛ pɩ la nyibli 'nie 'lu lɛ, ɛ nɔ‑ ‑pa 'mʋ. ‑Ʋ ‑bɩ wɛn 'nɩ, ‑mɔ Nyɩsʋa a winwlɔn‑hanyɔ Eli ꞊nɩɔ. ‑Ʋ ‑bɩ wɛn 'nɩ, ‑mɔ Nyɩsʋa a winwlɔn‑hanyɔ Selemi ꞊nɩɔ. ‑Ʋ ‑bɩ wɛn 'nɩ, ‑mɔ Nyɩsʋa a winwlɔn‑hanyɔ ‑bɩ ꞊nɩɔ, ‑ɛ 'kʋ la, 'tɩ‑ ‑ɛ 'hrɩ 'klɔ de.» ");
INSERT INTO ktj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","‑Ɛ ‑bɩ ɛ wɛn: «'A mʋ ‑mɔ ‑bɩ, a wɛn, nyiblo a 'dɩ ‑bɩ 'n pa 'mʋ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","‑Ɛ ‑bɩ Simɔ Piɛlɩ bi 'ʋ nɩ, ɛ wɛn: «‑Mɔ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ‑a mʋ yɩ ya. ‑Mɔ 'Klɔhienyɩsʋa a 'Yu ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ꞊ɩ yɩ, ɛ wɛn: «'Ɛ mɔ ‑tɩ a ‑tɛɛ, Simɔ Piɛlɩ, Saan a 'yu. ‑Tɩ ‑mʋ', ‑hla, ɛ 'yɩ ‑tonyiblo ꞊dʋ 'pa‑, ɛ 'yɩ ‑mɔ꞊ɔ wlɔn ꞊tu. 'Na 'Baɩ Nyɩsʋa ‑mʋ', ‑ɛ nɩ 'lɩ yakɔ 'kwli, ɛ nɔ‑ lee ‑mɔ꞊ɔ. ");
INSERT INTO ktj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","'N yɩ 'kɩ ‑mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, ‑na 'nyrɛ mɔ Piɛlɩ, ‑ɛ ꞊hɛn 'nyrɛ 'hɩɔ. Ɛ nɔ‑ kɔ kɩ, 'n di 'ʋ 'na 'cʋɛ 'ʋ ‑pʋʋ ‑nɩ. 'Kʋkʋʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑wɛ 'cʋɛ a 'mʋ bʋ. ");
INSERT INTO ktj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","'N di ‑mʋ Nyɩsʋa a 'klɔ yrayrʋ a 'maju a 'yɔ 'nɩ ‑nyi. ‑Tɛblɩ a pɛpɛ ‑mʋ', ‑di nyibli ‑lee ‑nɩ, ʋ 'nɩ 'nuo 'lɩ, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, Nyɩsʋa ‑mʋ', ‑ɛ nɩ 'lɩ yakɔ 'kwli, ɛ di꞊e 'nɩ hla ‑wɛ, ɛ kɔ, ‑tɛblɩ a pɛpɛ ‑mʋ', ‑di kɩ ‑wɛɛn ‑nɩ, 'kɩ nyibli bʋ nu, Nyɩsʋa di wɛɛn ꞊nɛ kɩ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","‑Ɛ ‑bɩ ‑Yusu ti 'a ‑nagbopʋ nɩ ‑tɛɛ, ɛ wɛn: «A 'nɩ 'lee 'lɩ nyiblo ꞊dʋ, ‑ɛ mɔ, 'mɔ ‑mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya.» ");
INSERT INTO ktj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kʋɛ 'ʋ ti a 'mʋ 'yie bʋ, ‑Yusu ‑tʋa 'a ‑nagbopʋ* ‑tɛblɩ ‑mʋ', ‑ɛ kɔ ‑bʋ mu꞊o yɩ, 'a klɛ‑hɩhɩalɛ, ɛ wɛn: «Ɛ di kɔ ‑nyrɔwɔ, 'mʋ 'lɩ Jrusrɛdɩɔ 'kwli mu, 'blʋ a nyibli bi 'lɩ yɩ, Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ, ʋ kɔ Nyɩsʋa a tetetɔɔnyʋ 'hʋɛn‑, ʋ 'mʋ 'mʋ ꞊hɩʋɛn ꞊tu, ʋ 'mʋ 'mʋ 'la. Kɛɛ, 'bʋ mɔ, 'nɩ 'kʋ, ‑nyrɔwɩ nɩ 'hʋɛn, ta a ‑nyrɔwɔ, Nyɩsʋa di ‑ha 'mʋ 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ɛ nɔ‑ mɔ Piɛlɩ bʋ daa ꞊nɛ 'kɩbɩa ‑mɔ, 'tɩ‑ bʋ lee ꞊nɛ, ‑ɛ mɔ: «‑Tɩ ‑bʋ, ‑yɩ 'lu ‑mɔ lɛ ‑hie, 'nɩ ‑hʋa꞊a lɩ꞊ɩ, bʋ nu ‑mʋ, ɛ kɔ, Nyɩsʋa 'nɩ 'wɛɛn 'lɩ꞊ɩ kɩ, 'kɩ bʋ nu ‑mʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","‑Ɛ ‑bɩ ‑Yusu ꞊hɩan ‑mɔ, 'ɛ lee Piɛlɩ, ɛ wɛn: «hlɔɔ 'mʋ ‑mɔ lɛ, Satan! ‑Kɛ 'mʋ yɩ, 'kɩ ꞊bʋ nu dɛ ‑mʋ', Nyɩsʋa ‑hʋɛ. Dɛ ‑mʋ', ‑yɩ 'lu ‑mɔ lɛ ‑hie, ɛ 'yɩ꞊ɩ 'pa‑, Nyɩsʋa 'nɩ ‑hie lɩ꞊ɩ 'lu ‑mɔ lɛ. ‑Na 'lulɛ‑hihie mɔ ‑tonyibli a 'lulɛ‑hihie ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ɛ yɩ 'a ‑nagbopʋ 'nɩ ‑lee ‑nɩ, ɛ wɛn: «Nyiblo 'bʋ yɩ꞊ɩ nɩ ‑hʋɛ, bʋ kʋɛ 'mʋ ꞊wien lɛ, ɛ 'nɩ 'kʋɛɛ 'lɩ 'a dɩɔnʋ a 'lulɛ‑hihie ꞊wien lɛ, kɛɛ, ‑tɩ ‑mʋ', 'n di꞊e ‑lee ‑nɩ, ɛ nɔ‑ bʋ nu, 'a ‑nɛ ti, 'ye ꞊bɩɩ nyibli ʋ pʋ lɛ, ʋ 'mʋ꞊ʋ 'la, ‑tɛ ɛ pa 'ʋ, 'ɛ mɔ 'na nyiblo a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nyiblo 'bʋ pʋ lɛ, ɛ 'nɩ ‑hʋa꞊a lɩ bʋ 'waan nɛ 'a dɩɔnʋ a ‑hʋnhlʋn, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, 'kɩ 'ʋ 'na ‑ta', nyiblo a 'mʋ, 'bʋ mɔ, 'bʋ 'kʋ, ɛ di 'a 'klɔ yrayrʋ 'nɩ 'waan ‑nɩ, 'kɩ 'lɩ Nyɩsʋa yɩ. Kɛɛ, nyiblo 'bʋ ‑wɛn, 'kɩ 'a dɩɔnʋ a ‑hʋnhlʋn bʋ 'wan, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, ‑tɛ ɛ nʋɛ 'mʋ a ‑tɩ, ‑ɛ ‑bɩ nyiblo a 'mʋ, 'bʋ mɔ, 'bʋ 'kʋ, ɛ di kɔ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ, 'kɩ 'lɩ Nyɩsʋa yɩ. ");
INSERT INTO ktj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nyiblo 'bʋ kɔ 'klɔ ‑bʋ a kʋkɔ‑tɛblɩ a pɛpɛ, 'tɩ‑ bʋ 'waan nɛ 'a dɩɔnʋ a 'klɔ yrayrʋ, 'kɩ 'lɩ Nyɩsʋa yɩ, kʋkɔ‑tɛblɩ a 'mʋ, ɛ 'nɩ ‑pʋ꞊ʋ 'ʋ꞊ʋ ꞊dedede nɩ. Nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ pʋ 'ʋ ꞊dedede 'klɔ yrayrʋ a 'mʋ, 'a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","‑Tɩ a pɛpɛ ‑bʋ, 'n lee nɛ 'a mʋ, 'n hla꞊a nɩ, ‑ɛ nu꞊o, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n di 'lɩ 'nɩ di, 'kɩ 'lɩ 'na 'Baɩ Nyɩsʋa a ‑tɩ a 'yi'bʋalɛ 'kwli, 'n kɔ 'na lɛlenyʋ 'hʋɛn‑. Ti a 'mʋ 'yri, 'kɩ 'na 'Baɩ Nyɩsʋa di ‑hʋan 'a ‑nɛ nyibli ‑bɩ 'wio ‑nyi, kɔ, ɛ 'mʋ ‑ʋ ‑bɩ yrʋ lɛ ‑pʋʋ ‑nɩ, ꞊wɩ yɩ ‑tɛ 'a ‑nɛ nyiblo a nunuklɔ nɩ 'mʋ, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ. ");
INSERT INTO ktj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ, ‑ɛ mɔ, 'kɩ 'lɩ 'a mʋ 'nyɩ, nyibli ‑bɩ nɩ 'lɩ, ʋ 'mʋ ‑hʋan꞊a 'ye, ‑tɛ 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n di 'lɩdidie nu, 'mʋ nyibli win kɩ ‑kɔɔ ‑nɩ, 'tɩ‑ ɛ 'mʋ ‑hʋan nyibli a 'mʋ, 'waa 'kʋkʋʋ a ti kɩ yɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","‑Tɛ ‑nyrɔwɩ nɩ ꞊hlon‑do ‑hi, ‑ɛ ‑bɩ ‑Yusu gba Piɛlɩ, kɔ Sakɩ, kɔ Sakɩ a 'mʋ, 'a 'dɩayɩ nyɩbɛhɩan Saan 'hʋɛn‑ nɩ, 'ʋ mu 'lɩ dʋgba blɔblʋ ꞊dʋ 'lu. ");
INSERT INTO ktj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","'Kɩ ʋ 'nɩ 'lɩ dʋgba a 'mʋ 'lu, ‑ɛ ‑bɩ ‑Yusu 'cɩcɩ nɩ, 'kɩ 'lɩ ꞊nʋ 'yi, 'a yigbakla yɩ 'nɩ wlɩn, ‑wɛn 'yrʋ, 'a 'hʋɩlɛpʋ‑tɛblɩ 'plɛ nɩ, ‑wɛn ‑nyrɛ. ");
INSERT INTO ktj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ ʋ 'ye Nyɩsʋa a winwlɔn‑hanyʋ Moise kɔ Eli 'hʋɛn‑ nɩ. Nyibli nɩ 'hʋɛn a 'mʋ, ʋ 'kʋ la see la. Ʋ nʋ‑ 'hrɩɩ 'ʋ ‑Yusu 'hʋɩ, ɛ kɔ ꞊nʋ 'hʋɛn‑, 'ʋ ‑tʋa toto a pʋpʋʋ. ");
INSERT INTO ktj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Piɛlɩ bʋ yɩ 'kɩ ꞊nʋ nɩ 'ye, ‑ɛ ‑bɩ ɛ yɩ ‑Yusu 'nɩ ‑lee ‑nɩ, ɛ wɛn: «Kʋkɔnyɔ o, ɛ nu ‑tɛɛ, 'kɩ ‑ba nɩ 'nɛ‑ ‑tɩtɛ ‑bʋ bʋ. 'Bʋ mɔ, ꞊nɩ yɩ꞊ɩ nɩ ‑hʋɛ, 'n di pʋ papʋɩ nɩ ta: ‑nɛ pʋpa, Moise a ‑nɛ, kɔ Eli a ‑nɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Win nɩ 'lɩ꞊ɩ wlɔn, ti nɩ ‑do a ti 'yri, ‑jruŋma, 'ɛ yɩ wlɩn, 'ɛ ꞊tɩɩ 'ʋ ꞊nʋ 'lu, 'ɛ ‑hli ꞊nʋ. 'Kɩ 'lɩ ‑jruŋma a 'mʋ 'kwli, 'kɩ Nyɩsʋa a win ‑hʋɛn 'lɩ ‑wlu, 'ɛ pɩ lɛ: «Nyiblo ‑bʋ, ɛ nɔ‑ mɔ 'na nʋɛyu, 'ɛ yɩ 'mʋ plɔ a bleelɛ ‑nyi. Ɛ nɔ‑ ba pʋ nʋa yɩ bʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","'Tɩ‑ ‑nagbopʋ 'mʋ win a 'mʋ 'wɩn mɔ mu, ‑ɛ ‑bɩ hʋannʋ bi 'lɩ ꞊nʋ 'kwli, 'ʋ bla kwlɩ bʋ, 'ʋ kɔ yigbaklɩ blɛ, 'kɩ 'ʋ Nyɩsʋa a 'ʋ꞊tuulɛ a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","‑Ɛ ‑bɩ ‑Yusu 'yɩya 'ʋ ꞊nʋ 'hʋɩ bʋ, 'ɛ ‑hrɛn ꞊nʋ lɛ, ɛ wɛn: «Ba 'du ye', ba 'kee hʋannʋ a pipie.» ");
INSERT INTO ktj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","‑Tɛ ʋ 'du 'yii ye', ‑ɛ ‑bɩ ʋ 'kee nyibli ‑nɩ wɛn a 'yiye nɩ, 'bʋ 'yɩ ‑Yusu nɩ ‑do 'pa‑. ");
INSERT INTO ktj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","‑Tɛ ʋ yɩ 'kɩ dʋgba a 'mʋ nɩ ꞊tɩ, ‑ɛ ‑bɩ ‑Yusu yɩ ꞊nʋ 'nɩ ti, ɛ wɛn: «Dɛ ‑bʋ, a 'ye, a 'nɩ 'lee 'lɩ nyiblo ꞊dʋ, ɛ 'mʋ꞊ʋ gba ‑gbagba, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'mʋ 'kʋ, Nyɩsʋa 'mʋ 'lɩ 'mʋ 'kʋkʋnyibli 'nyɩ ‑ha, ɛ 'mʋ 'mʋ 'klɔ ‑ha.» ");
INSERT INTO ktj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","‑Ɛ ‑bɩ ‑nagbopʋ ‑tʋa 'a lɛ'bɛtilɛ, ʋ wɛn: «Dɛ‑ kɔ ‑tɩ Nyɩsʋa a tetetɔɔnyʋ 'ʋ pɩ lɛ, ‑ɛ mɔ, Nyɩsʋa a winwlɔn‑hanyɔ Eli, nɔ‑ kɔ ‑bʋ 'nyɛɛ 'hru, ‑bʋ di, 'tɩ‑ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya, ɛ 'mʋ di 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","‑Ɛ ‑bɩ ɛ wɛn: «Ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, Eli kɔ bʋ di, ɛ 'mʋ Nyɩsʋa a dakɔ ‑hɛɛ ‑nɩ, ʋ 'mʋ 'waa 'klɔ ꞊hrɛntɩ ‑nɩ, ʋ 'mʋ ‑mɔ ‑wɛ, 'tɩ‑ Wanyɔ a 'mʋ, ɛ 'mʋ di. ");
INSERT INTO ktj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","'N yɩ 'kɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, nyiblo ‑mʋ', ‑ɛ 'wɩ Eli yɩ, ɛ di nɩ, kɛɛ, ʋ 'yɩ꞊ɩ ‑yru, 'tɩ‑ yɩnyre‑tɛblɩ ‑bʋ, ‑tonyibli ‑hʋɛ bʋ nu꞊o ‑mɔ, 'ʋ nu ꞊nɛ꞊ɛ ‑mɔ. ‑Tɛ ʋ ‑nu, 'ʋ ꞊tu Eli ꞊hɩʋɛn, kɛ‑ nɩ ‑do ʋ di nu, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, ʋ 'mʋ 'mʋ ꞊hɩʋɛn ꞊tu.» ");
INSERT INTO ktj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","‑Ɛ ‑bɩ ‑tonyibli a pɛpɛ yru꞊o nɩ, ‑ɛ mɔ, Eli ‑mʋ', ‑kɔtɩ ɛ hlɛ, Saan Batisɩ ɛ ꞊hɛn 'nyrɛ. ");
INSERT INTO ktj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","‑Tɛ ‑Yusu kɔ 'a ‑nagbopʋ* nɩ ‑ta nɩ ‑wɛn 'hʋɛn‑, ʋ ꞊tɩ 'kɩ dʋgba, ‑ɛ ‑bɩ ʋ nyre 'ʋ ‑tɩtɛ ‑mʋ', nyibli ‑hʋɔhʋɩ nɩ 'ʋ. Bʋ nɩ 'kɩ 'ʋ bʋ, ‑ɛ ‑bɩ nyiblo nɩ ‑do ‑bɩ 'yɩya 'ʋ ‑Yusu 'hʋɩ bʋ, 'ɛ bla꞊a kwlɩ yɩ bʋ, ");
INSERT INTO ktj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ɛ wɛn: «Tɔɔnyɔ o, yru 'na 'yu nyɩbɛhɩan a nyaɩ, ‑ɛ nu꞊o, ‑gbugbukʋɛ ni꞊e nɩ, 'ɛ ꞊tui꞊e ꞊hɩʋɛn dɩakɩ. Ɛ kɔ ti, 'ɛ yɩ 'lɩ 'tɔ lɛ bi, kɔ 'kɩ 'lɩ 'nie ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","'N gba 'lɩ꞊ɩ ‑na ‑nagbopʋ yɩ nɩ, kɛɛ, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nu꞊o, 'a 'kʋɛ bʋ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kɛ‑ ‑Yusu pɩ 'kɩ 'a ‑nagbopʋ yɩ, ɛ wɛn: «A mɔ nyibli ꞊nɩɔ, ‑ʋ 'yɩ Nyɩsʋa ꞊wlʋ yɩ ‑kuo ‑nɩ ‑tɛɛ, kɔ, ‑ʋ 'yɩ ꞊haandɛ kɔ dɛ ‑hʋan 'hʋɛn‑ a 'yilɛ‑hɩhɩalɛ ‑yi. Ti nɩ ‑tie 'n kɔ ꞊bʋ ‑hii 'nɛ‑ 'a mʋ 'nyɩ, 'tɩ‑ a 'mʋ Nyɩsʋa ꞊wlʋ yɩ ‑kuo ‑nɩ 'lɩ? ꞊Bɩ kɛ‑ 'n di nu, 'mʋ 'a mʋ lɛ ‑kikle ‑nɩ 'a ‑nɛ ti? Ba ya 'mʋ 'yu a 'mʋ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","‑Tɛ ʋ ya 'kɩ ꞊nɛ꞊ɛ yɩ, ‑ɛ ‑bɩ ‑Yusu hlee 'lɩ 'ku ‑hʋan ‑mʋ', ‑ɛ nɩ 'ʋ 'yu a 'mʋ ke' ‑mɔ, 'kɩ 'lɩ win 'yaklɩ 'kwli. ‑Ɛ ‑bɩ 'ku ‑hʋan a 'mʋ, ɛ ‑hɔn 'ʋ꞊ʋ ke' nɩ. Ɛ nɔ‑ mɔ ti nɩ ‑do a ti 'yri, 'yu a 'mʋ, 'a 'kʋɛ bʋ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","‑Tɛ ti gbi ‑hi, ‑Yusu kɔ 'a ‑nagbopʋ 'hʋɛn‑, ʋ nɩ ‑do, ʋ nɩ 'ʋ bʋ, ‑ɛ ‑bɩ ʋ wɛn: «Dɛ‑ kɔ ‑tɩ, ꞊a 'yɩ wɛn 'lɩ꞊ɩ ‑wɛ, 'kɩ ‑ba bla 'ku ‑hʋan ‑mʋ' lɛ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «A 'yɩ Nyɩsʋa ꞊wlʋ yɩ ‑kuo ‑nɩ ‑tɛɛ, 'kɩ bʋ nu꞊o, 'yu ‑mʋ', 'a 'kʋɛ bʋ ‑wɛ. 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, 'ye ꞊bɩɩ a kuo Nyɩsʋa ꞊wlʋ yɩ dɛ gbe, a ‑wɛ 'lɩ ba lee dʋgba ‑bʋ nɩ: ‑Hɔn mɔ ‑tɩtɛ ‑bʋ, ‑bʋ mu 'lɩ ‑tɩtɛ ‑mʋ', 'ɛ mɔ ꞊han‑tɩ, ɛ 'mʋ 'ʋ ‑tɩtɛ a 'mʋ ‑hɔn. 'A ‑tɩ, a ‑wɛ 'lɩ ba nu 'a ‑nɛ ꞊dedede nɩ.  ");
INSERT INTO ktj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","'Bʋ mɔ, 'ba yɩ Nyɩsʋa nɩ dɛ, 'kɩ 'lɩ ꞊cicie* nɩ ‑do 'kwli, 'kɩ a ‑wɛ 'lɩ ba bla 'lɩ 'kuo ‑hʋɩndʋ a 'mʋ lɛ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","‑Nyrɔwɔ ꞊dʋ, ‑Yusu kɔ 'a ‑nagbopʋ* a pɛpɛ 'hʋɛn‑, ʋ 'kukue lɛ, 'kɩ 'lɩ Galileblʋgba 'kwli, ‑Yusu 'ɛ yɩ la ꞊nʋ ‑lee ‑nɩ, ɛ wɛn: «'Mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, ʋ kɔ bʋ pʋ 'mʋ nyibli ‑jɩ', ");
INSERT INTO ktj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ʋ 'mʋ 'mʋ 'la. Kɛɛ, 'bʋ mɔ, 'nɩ 'kʋ, ‑nyrɔwɩ nɩ 'hʋɛn 'bʋ ‑hi, ta a ‑nyrɔwɔ, Nyɩsʋa kɔ bʋ ‑ha 'lɩ 'mʋ 'kʋkʋnyibli 'nyɩ, ɛ 'mʋ 'mʋ 'klɔ ‑ha.» ‑Tɛ ʋ 'wɩn ‑tɩ a 'mʋ, ‑ɛ ‑bɩ 'waa ꞊wlɩ 'mʋɛ bʋ. ");
INSERT INTO ktj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ nyre 'lɩ Kapɛnaɔdɩɔ 'kwli nɩ. 'Kɩ ‑Juukʋɛ* ‑mʋ', ‑ʋ nɩ 'lɩ 'nyɩ, ɛ kɔ la 'blʋwli'tɩnyʋ, 'ʋ yɩ la 'wli 'tɩ, 'kɩ 'ʋ Nyɩsʋa a 'kagbaʋ a ‑kʋan a ‑ta'. 'Blʋwli'tɩnyʋ a 'mʋ, ʋ nʋ‑ 'yɩya 'ʋ Piɛlɩ 'hʋɩ bʋ, 'ʋ yɩ꞊ɩ 'bɛti ‑nɩ, ʋ wɛn: «꞊Bɩ 'aan ‑nɛ tɔɔnyɔ ‑Yusu ‑bʋ, ɛ yɩ Nyɩsʋa a 'kayu gbagbʋ a 'blʋwli 'nɩ 'pɛɛ ‑nɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","‑Ɛ ‑bɩ Piɛlɩ wɛn: «Iin, ɛ yɩ꞊ɩ 'nɩ 'pɛɛ ‑nɩ,» 'ɛ mu 'lɩ 'kayu bʋ, ‑ɛ di꞊e nu, ɛ 'mʋ ‑Yusu ‑lee ‑nɩ. Bʋ 'mʋ 'kɩ 'lɩ 'kayu bʋ pa, ‑ɛ ‑bɩ ‑Yusu 'nyɛɛ 'hru, 'ɛ 'bɛti꞊e, ɛ wɛn: «Simɔ Piɛlɩ, dɛ‑ ‑yɩ 'lu ‑mɔ lɛ ‑hie, 'kɩ 'ʋ 'blʋwli a 'pɛɛlɛ a ‑ta' 'lɩ? 'Bʋ mɔ, 'blʋgba a naanyʋ 'bʋ yɩ 'blʋwli nɩ 'tɩ, nyibli a 'dɩ ‑bɩ, ʋ ‑hʋɛ 'wli a 'mʋ 'lɩ? ꞊Bɩ 'blʋgba a 'yonʋ ʋ ‑hʋɛ꞊ɛ, ‑ʋ'ʋ‑ hɩapʋnyibli?» (Ti a 'mʋ 'yri, 'blʋgba a naanyʋ, hɩapʋnyibli, ʋ nʋ‑ ʋ ‑hʋɛ la 'blʋwli, ɛ 'yɩ 'blʋgba 'yonʋ 'pa‑.) ");
INSERT INTO ktj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","‑Ɛ ‑bɩ Piɛlɩ ꞊tu꞊o ꞊wɔn, ɛ wɛn: «Hɩapʋnyibli ꞊nɩɔ.» ‑Ɛ ‑bɩ ‑Yusu wɛn 'nɩ: «'A ‑tɩ 'kɩ o, 'blʋgba a 'yonʋ 'yɩ 'pɛɛlɛ ‑kɔ. ");
INSERT INTO ktj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kɛɛ 'kɩ, 'blʋwli'tɩnyʋ ‑bʋ, ‑ʋ 'yɩ 'na ‑nagbopʋ 'pa‑, ‑a 'nɩ ‑hʋa꞊a lɩ ‑ba pʋ 'waa ꞊wlɩ yrʋ' lɛ. 'A ‑tɩ, mu 'lɩ 'yru wien. ꞊Nɩ yɩ nɩ mi, gba ‑wedi, ꞊mʋ 'pa. Yɩ‑hɛ‑hrin.yɛ, ‑di 'pa, kla 'a wuntɔ yɩ. 'Kɩ 'lɩ꞊ɩ wlɔn, ‑di yɛɛ 'lɩ 'wliyɔkɔ a 'yɛɛ nɩ ‑do bʋ, ‑ɛ ‑wɛ 'lɩ ‑bʋ 'pɛɛ ‑aan ‑nɛ 'blʋwli, ‑n kɔ 'mʋ 'hʋɛn‑. Ɛ nɔ‑ ‑di nu, ꞊mʋ ‑aan ‑nɛ 'blʋwli a 'mʋ 'pɛɛ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ti a 'mʋ 'yri, ‑ɛ ‑bɩ ‑Yusu a ‑nagbopʋ* 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, 'ʋ 'bɛti꞊e, ʋ wɛn: «'Kɩ 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli, nyiblo a 'dɩ ‑bɩ, ‑ɛ di 'ʋ 'a 'bio 'lu yɩ nɩ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","‑Tɛ ʋ 'bɛti 'kɩ꞊ɩ, ‑ɛ ‑bɩ ɛ da 'hɩangbe ꞊dʋ, 'ɛ ꞊tu 'ʋ ꞊nʋ꞊ʋ ye' bʋ, ");
INSERT INTO ktj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ɛ wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, 'bʋ mɔ, 'ba 'yɩ 'ʋ dɛ 'kuku a nunuo bʋ ‑hie, ɛ kɔ, 'ba 'yɛ nɩ ꞊tɩɔ 'lɩ 'aan dɩɔnʋ, ꞊wɩ yɩ 'hɩangbi, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba pa 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nyiblo ‑bʋ, ‑ɛ nɩ 'lɩ 'a 'bio 'nyɩ, 'bʋ ꞊tɩɔ 'lɩ 'a dɩɔnʋ 'lɩ, ꞊wɩ yɩ 'hɩangbe ‑bʋ, ɛ nɔ‑ di 'ʋ 'a 'bio 'lu yɩ nɩ, 'kɩ 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","'A ‑nɛ nyiblo, 'bʋ nɩ 'ʋ, ‑tɛ 'hɩangbe ‑bʋ, ɛ nɩ 'mʋ, 'bʋ 'ble 'a nyiblo kʋa, 'kɩ 'ʋ 'na 'nyrɛ a ‑ta', ‑ɛ ‑bɩ 'mɔ ɛ 'ble kʋa.» ");
INSERT INTO ktj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ de, ɛ wɛn: «Nyiblo ‑bʋ, ‑ɛ kuo 'mʋ ꞊wlʋ yɩ, ꞊wɩ 'hɩangbedʋ ‑bʋ yɩ, 'bʋ mɔ, nyiblo 'bʋ nu꞊o, nyiblodʋ a 'mʋ, bʋ 'kee 'na ꞊wlʋ a yɩkuolɛ, ɛ di nɔɔ 'ʋ lɛ, 'kɩ 'ʋ nyiblo a 'mʋ, ‑ɛ nu dɛ a 'mʋ ‑mɔ, 'kɩ bʋ pʋ꞊ʋ 'hɩɔ gbɛtɛɛ lɔ, 'tɩ‑ bʋ pʋ 'lɩ꞊ɩ 'yru ‑mɔ, ɛ 'mʋ 'kʋ. ");
INSERT INTO ktj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","'Jrɔ 'kɩ 'ʋ nyibli ‑mʋ' ‑mɔ, ‑ʋ 'yɩ Nyɩsʋa ‑yi, 'tɩ‑ ‑ʋ ni꞊e, nyibli 'ʋ ni dɛ 'kuku. Ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, ‑tɛblɩdʋ a 'mʋ, ɛ kɔ bʋ mu 'lu ‑mɔ. Kɛɛ, 'jrɔ 'kɩ 'ʋ nyiblo ‑mʋ' ‑mɔ, ‑ɛ di꞊e nu, ɛ 'mʋ 'lu ‑mɔ mu. ");
INSERT INTO ktj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","'Bʋ mɔ, ‑na dabʋ, ‑hʋʋ', ‑na bʋ 'bʋ yɩ꞊ɩ nɩ ni, ꞊nɩ yɩ dɛ 'kuku nɩ ni, ‑ɛ ‑bɩ 'bɛ 'ʋ ꞊nʋ lɛ, ‑bʋ pʋ ꞊nʋ 'wan. Ɛ nu ‑tɛɛ, 'kɩ ‑bʋ gba dabʋkʋtɩɔ, ‑hʋʋ', bʋkʋtɩɔ, ‑bʋ pa 'lɩ Nyɩsʋa a 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ 'kwli, 'ɛ ‑hi 'ʋ ‑na dabʋɩ nɩ 'hʋɛn, ‑hʋʋ', na bʋɩ nɩ 'hʋɛn, bʋ ꞊cɛɛ 'ʋ yɩ, 'tɩ‑ ‑bʋ mu 'lɩ na ‑mʋ', ‑ɛ 'yɛ nɩ jre 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","'Bʋ mɔ, ‑na 'yie 'bʋ yɩ꞊ɩ nɩ ni, ꞊nɩ yɩ dɛ 'kuku nɩ ni, ‑ɛ ‑bɩ ‑ha 'lɩ꞊ɩ 'lɩ, ‑bʋ pʋ꞊ʋ 'wan. Ɛ nu ‑tɛɛ, 'kɩ ‑bʋ kɔ 'yie nɩ ‑do, ‑bʋ pa 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli, 'ɛ ‑hi 'ʋ ‑na 'yii nɩ 'hʋɛn bʋ ꞊cɛɛ 'ʋ yɩ, 'tɩ‑ ‑bʋ mu 'lɩ na ‑mʋ', ‑ɛ 'yɛ nɩ jre 'nyɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Kɛ‑ ‑Yusu pɩ de, ɛ wɛn: «Ba ꞊tu 'aan dɩɔnʋ 'yie, a 'nɩ ꞊ha 'na nyiblo ꞊dʋ ‑yraa ‑nɩ, ‑tɛ ɛ 'yɩ nyiblo gbagbʋ 'pa‑ a ‑tɩ. 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, nyibli ‑mʋ', ‑ʋ 'yɩ nyibli gbagbɩ 'pa‑, Nyɩsʋa a lɛlenyʋ, ʋ nʋ‑ ꞊tui ꞊nʋ 'yie, 'ʋ kɔ 'hru, 'kɩ bʋ nɩ 'ʋ 'na 'Baɩ Nyɩsʋa, ‑ɛ nɩ 'lɩ yakɔ 'kwli 'hʋɩ bʋ.  ");
INSERT INTO ktj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","'Mɔ bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'mɔ Nyɩsʋa tɛɛ 'nɛ‑ ‑tʋtʋ kɩ, ‑ɛ di꞊e nu, nyibli, ‑ʋ 'wan, ‑ʋ hlɔɔ Nyɩsʋa ‑mɔ lɛ, 'mʋ ꞊nʋ lɛ ꞊mʋɔ, 'mʋ ꞊nʋ wa, 'kɩ 'ʋ yɩnyre‑tɛblɩ ‑mʋ', ʋ ni a ‑ta', ʋ 'mʋ Nyɩsʋa yrɛ 'mʋɛ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ɛ pʋʋ ꞊nɛ dɛ yɩ de, ɛ wɛn: «Nyiblo 'bʋ kɔ blablɩ a (100) ꞊wlɩ nɩ ꞊hun, 'bʋ gba ꞊nʋ 'cɛ mɔ, 'tɩ‑ blablɛ nɩ ‑do, bʋ 'wan, dɛ a 'dɩ ‑bɩ nyiblo a 'mʋ, ɛ di nu 'lɩ? Ɛ kɔ bʋ hie 'ʋ blablɩ a (99) ꞊wlɩ nɩ ‑hɛn ꞊tu 'ʋ ‑pu ꞊tu 'ʋ ꞊hʋɩan‑do ‑mʋ' 'cɛɛlɛ' bʋ, bʋ mu blablɛ ‑mʋ', ‑ɛ 'wan lɛ ꞊mʋɔ. ");
INSERT INTO ktj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, 'bʋ yɛ blablɛ nɩ ‑do a 'mʋ kɩ, 'a plɔ di 'nɩ ble dɩakɩ, ɛ 'mʋ 'ʋ blablɩ a (99) ꞊wlɩ nɩ ‑hɛn ꞊tu 'ʋ ‑pu ꞊tu 'ʋ ꞊hʋɩan‑do ‑mʋ', ‑ʋ 'yɩ 'wan a dɛ 'ʋ ‑hi. ");
INSERT INTO ktj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Dɛ nɩ ‑do, ɛ nɔ‑ ɛ pa 'mʋ, 'kɩ 'ʋ 'aan 'Baɩ Nyɩsʋa ‑mɔ, ‑ɛ nɩ 'lɩ yakɔ 'kwli, ‑ɛ nu꞊o, ɛ 'nɩ ‑hʋa꞊a lɩ꞊ɩ, 'kɩ 'a nyibli ‑mʋ', ‑ʋ 'yɩ nyibli gbagbɩ 'pa‑, 'a nyiblo nɩ ‑do bʋ 'wan.» ");
INSERT INTO ktj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","(Kɛ‑ ‑Yusu pɩ de, ɛ wɛn 'nɩ:) «‑Na 'bɩhɩan Nyɩsʋa a nyiblo 'bʋ nu ‑mʋ dɛ 'kuku ‑mɔ, lee ꞊nɛ, ba bii yɩ, ꞊mʋ꞊ʋ ‑lee ‑nɩ, ‑ɛ mɔ, dɛ a 'mʋ, ɛ ‑nu, ɛ nyre yɩ. 'Bʋ mɔ, 'bʋ yru꞊o, ‑ɛ mɔ, ɛ nu dɛ 'kuku, ɛ 'wɩ yɩ, ‑nu꞊o nɩ, 'ɛ ‑hɛ ‑na 'dɩayɩ de. ");
INSERT INTO ktj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kɛɛ, 'bʋ mɔ, 'bʋ 'yɛ nɩ yru꞊o, ‑ɛ mɔ, ɛ nu dɛ 'kuku, ‑ɛ ‑bɩ da nyiblo nɩ ‑do, ‑hʋʋ' nyibli nɩ 'hʋɛn, bʋ bi ‑mʋ kɩ. Ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, Nyɩsʋa a 'crɩɛn 'ɛ hlɛ꞊ɛ, ‑ɛ mɔ, nyiblo 'bʋ 'mʋ 'a 'bɩhɩan ‑tɩ ‑yɛɛ ‑nɩ, ɛ ‑hʋɛ꞊ɛ nɩ, ‑hɛhɩpʋ nɩ 'hʋɛn, ta, bʋ nɩ ‑tuo kɩ. ");
INSERT INTO ktj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kɛɛ, 'bʋ 'yɛ nɩ yru꞊o ‑wɛ, ‑ɛ ‑bɩ da 'cʋɛ a nyibli. 'Bʋ mɔ, 'bʋ 'yɩ 'kɩ꞊ɩ ‑yru pɛpɛ, ‑ɛ ‑bɩ 'kɩ 'lɩ ‑mʋ 'yi, nyiblo a 'mʋ, bʋ mɔ hɩlɛkɔnyɔ, ‑hʋʋ' bʋ mɔ nyiblodʋ ‑mʋ', ‑ɛ 'yɩ Nyɩsʋa ‑yi.» ");
INSERT INTO ktj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","(‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ de, ɛ wɛn:) «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑tɛblɩ a pɛpɛ ‑mʋ', a di lɛ pʋ nyibli 'nɩ 'nuo 'lɩ, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, Nyɩsʋa ‑mʋ', ‑ɛ nɩ 'lɩ yakɔ 'kwli, ɛ di꞊e 'nɩ hla ‑wɛ, ɛ kɔ, ‑tɛblɩ a pɛpɛ ‑mʋ', a di lɛ pʋ nyibli bʋ nu, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, Nyɩsʋa, ‑ɛ nɩ 'lɩ yakɔ 'kwli, ɛ di wɛɛn dɛ a 'mʋ kɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, nyibli nɩ 'hʋɛn, 'kɩ 'lɩ 'a mʋ 'nyɩ, 'bʋ ‑wɛn, 'kɩ bʋ da Nyɩsʋa, 'bʋ ‑hʋa꞊a 'a ‑nɛ ꞊dedede, 'na 'Baɩ Nyɩsʋa ‑mʋ', ‑ɛ nɩ 'lɩ yakɔ 'kwli, ɛ di ꞊nʋ꞊ʋ 'nɩ ‑nyi, ");
INSERT INTO ktj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","‑ɛ nu꞊o, nyibli nɩ 'hʋɛn, ta, 'bʋ 'kukue lɛ, 'kɩ 'lɩ 'na 'nyrɛ 'kwli, 'kɩ 'n nɩ 'lɩ ꞊nʋ 'nyɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","‑Yusu bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ Piɛlɩ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, 'ɛ 'bɛti꞊e, ɛ wɛn: «Kʋkɔnyɔ o, 'na 'bɩhɩan Nyɩsʋa a nyiblo, 'bʋ 'cibi 'ʋ 'mʋ dɛ 'kuku a ‑mɔnunuo, 'wɩ nɩ ‑tie 'n kɔ ꞊bʋ ‑hru 'a dɛ 'kuku a 'mʋ, 'a ‑tɩ ‑mɔ 'lɩ? ꞊Bɩ ꞊bʋ ‑hru 'a dɛ 'kuku a 'mʋ 'a ‑tɩ ‑mɔ, 'wɩ nɩ ꞊hlon'hʋɛn?» ");
INSERT INTO ktj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","‑Ɛ ‑bɩ ɛ wɛn: «'Nɩ ‑pʋ꞊ʋ lɛ ‑bʋ ‑hru 'a dɛ 'kuku a ‑tɩ ‑mɔ, 'wɩ nɩ ꞊hlon'hʋɛn, kɛɛ, ɛ 'yɩ hreelɛ ‑kɔ. 'A ‑nɛ ti, ‑hru 'a dɛ 'kuku a ‑tɩ ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ de, ɛ wɛn: «‑Tɛ Nyɩsʋa nu nyibli a win a kɩkɔɔlɛ, dɛ ɛ 'wɩ yɩ, ɛ nɔ‑ ‑bʋ: 'Blʋgba ꞊dʋ a 'kɩɩn, ɛ nɔ‑ da 'a ‑kʋannunyibli gbagbɩ, ɛ 'mʋ 'wli ‑mʋ' ‑hre, ʋ kɔ bʋ 'pɛɛ ꞊nɛ. ");
INSERT INTO ktj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","‑Tɛ ɛ ꞊tu 'wli a 'mʋ a ‑hihre ‑wlu, ‑ɛ ‑bɩ ʋ ya꞊a 'a ‑kʋannunyɔ ‑bɩ yɩ, ‑ɛ 'ble 'a gba kʋa. 'Wli, ɛ 'ble kʋa, ɛ ‑wɛ 'lɩ 'wliblɛ ‑hʋɔhʋɩ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kɛɛ, 'wlidʋ a 'mʋ, ‑ɛ ti 'mʋ lɛ, ɛ 'yɩ 'lɩ 'a 'pɛɛlɛ ‑wɛ. Ɛ nɔ‑ mɔ 'kɩɩn a 'mʋ, bʋ lee nɛ 'a nyibli, ɛ wɛn: Ba gba nyiblo ‑bʋ, ɛ kɔ 'a nʋgba kɔ 'a 'yonʋ 'hʋɛn‑, ba plo ꞊nʋ, ‑wɛn ꞊koyo, ɛ kɔ, ba plo 'a kʋkɔ‑tɛblɩ a pɛpɛ, ‑ɛ di꞊e nu, ɛ 'mʋ gba a 'mʋ 'pɛɛ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","‑Ɛ ‑bɩ ‑kʋannunyɔ a 'mʋ, ɛ bla꞊a kwlɩ yɩ bʋ, ɛ wɛn: 'N 'ble ‑na bʋ kʋa, 'n nyaa ‑mʋ lɛ, kɔ ꞊wlʋ a 'lɩla. 'N di ‑na gba a pɛpɛ 'nɩ 'pɛɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ 'kɩɩn a 'mʋ, ɛ yru 'a nyaɩ, ɛ wɛn: 'Ye ꞊bɩɩ ꞊yɩ꞊ɩ 'pɛɛ ‑nɩ, 'n tɛ ‑mʋ bʋ, mu. ");
INSERT INTO ktj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","‑Tɛ ɛ ‑hɔn 'ʋ꞊ʋ ye', ɛ yɩ nɩ mi, ‑ɛ ‑bɩ ɛ yɛ 'a 'bɩ ‑kʋannunyɔ ‑bɩ kɩ. 'A 'bɩ a 'mʋ, ɛ yɛ kɩ, ɛ 'ble 'a gba 'cɩmɩɛ kʋa. Ɛ nɔ‑ ‑mʋ', 'kɩɩn tɛ wɛn bʋ, ɛ klɔ 'a 'bɩ a mlanɩ nɩ, 'ɛ nyʋɛ꞊ɛ lɛ, 'ɛ yɩ꞊ɩ ‑lee ‑nɩ: 'Na gba ‑mʋ', 'n kɔ 'lɩ ‑mʋ ‑mɔ, ‑nyi 'mɔ꞊ɔ, ");
INSERT INTO ktj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","'a 'bɩ a 'mʋ, 'ɛ bla꞊a kwlɩ yɩ bʋ, ɛ wɛn: 'N 'ble ‑na bʋ kʋa, 'n nyɛɛ ‑mʋ lɛ, kɔ ꞊wlʋ a 'lɩla. 'N di ‑na gba 'nɩ 'pɛɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kɛɛ, ɛ hɩa nɩ, 'ɛ nɩ 'ʋ 'a 'bɩ a 'mʋ ke', 'ɛ pʋ꞊ʋ ꞊jɩ', ɛ 'mʋ 'lɩ nɩ ‑nɩnɩ, ɛ 'mʋ gba a 'mʋ 'pɛɛ ‑nɩ, 'tɩ‑ ʋ 'mʋ꞊ʋ bʋ tɛ. ");
INSERT INTO ktj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","‑Tɛ 'a 'bio ‑kʋannunyibli ‑mʋ', ʋ 'ye dɛ a 'mʋ, ‑ɛ mu 'lu ‑mɔ, ‑ɛ ‑bɩ 'waa plɔ nɛɛ 'lɩ bʋ dɩakɩ, 'ʋ mu 'lɩ 'kɩɩn ‑mɔ, ‑tɛblɩ a pɛpɛ a 'mʋ, ‑ɛ mu 'lu ‑mɔ, 'ʋ na꞊a ‑mɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ɛ nɔ‑ mɔ 'kɩɩn bʋ da꞊a, ɛ wɛn: ‑Mɔ ‑kʋannunyɔ ‑bʋ, ‑kɔ 'crɛ, gba a pɛpɛ ‑mʋ', 'n kɔ wɛn 'lɩ ‑mʋ ‑mɔ, 'wɛn, 'ye ꞊bɩɩ ꞊yɩ꞊ɩ 'pɛɛ ‑nɩ, 'n tɛ ‑mʋ bʋ, ‑tɛ ‑nyaa 'mʋ lɛ a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","‑Tɛ 'n ‑nu, 'nɩ yru ‑na nyaɩ, kɛ‑ ‑kɔ ‑bʋ nu wɛn ‑na 'bɩhɩan ‑mʋ', 'a nyaɩ a yuyruo. ");
INSERT INTO ktj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ɛ nu꞊o, 'kɩɩn a 'mʋ, 'ɛ kɔ yrʋ'bibie dɩakɩ, 'a ‑tɩ, 'ɛ da 'a nyibli, ɛ wɛn: «Ba pʋ꞊ʋ ꞊jɩ', ʋ 'mʋ꞊ʋ ꞊hɩʋɛn ꞊tu, ‑ɛ di꞊e nu, ɛ 'mʋ 'lɩ nɩ ‑nɩnɩ, ɛ 'mʋ 'na gba a pɛpɛ ‑mʋ' 'pɛɛ ‑nɩ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'kɩ de, ɛ wɛn: «Kɛ‑ nɩ ‑do, 'na 'Baɩ ‑mʋ', ‑ɛ nɩ 'lɩ yakɔ 'kwli, ɛ di 'aan 'yiye nu. ‑Tɛblɩ ‑mʋ', 'aan 'bio Nyɩsʋa a nyibli nu 'a mʋ 'yi ꞊hlɔn lɛ, 'bʋ mɔ, 'ba 'yɛ nɩ ‑hru 'a ‑tɩ ‑mɔ, 'kɩ 'lɩ 'aan ꞊wlɩ kɩ, ‑tɛ 'kɩɩn a 'mʋ, ɛ nu 'a nyiblo ‑mʋ' a ꞊tɔ, kɛ‑ Nyɩsʋa di 'aan ꞊tɔ nu ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","‑Tɛ ‑Yusu ‑wɛ tɔɔlɛ a 'mʋ ‑mɔ, ‑ɛ ‑bɩ ɛ ‑hɔn 'lɩ Galileblʋgba 'kwli nɩ, ɛ kɔ 'a ‑nagbopʋ* 'hʋɛn‑, 'ʋ mu 'lɩ Sudeblʋgba 'kwli, 'kɩ 'lɩ Sudɛn a 'nikɩ. ");
INSERT INTO ktj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nyibli ‑hʋɔhʋɩ, ʋ nʋ‑ yɩ ‑Yusu ꞊wien lɛ kʋɛ. Kɩklanyibli 'bʋ nɩ 'ʋ, ɛ ni꞊e nɩ, 'waa 'kʋɛ 'ɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Falisi꞊tumu* a nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, ʋ nʋ‑ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, ‑ɛ di꞊e nu, ʋ 'mʋ 'ʋ꞊ʋ lɛ ꞊tɛɛ ‑nɩ, ɛ 'mʋ ka, 'kɩ 'ʋ Nyɩsʋa ye'. Ɛ nɔ kɔ ‑tɩ 'ʋ yɩ꞊ɩ lɛ 'bɛti ‑nɩ, 'ʋ pɩ lɛ: «꞊Bɩ Nyɩsʋa a tete hlɛ꞊ɛ nɩ, ‑ɛ mɔ, ‑tonyiblo kɔ 'hru, 'kɩ bʋ pʋ 'lɩ 'a nʋgba ‑patʋ', 'kɩ 'ʋ 'a ‑nɛ ꞊dedede a ‑ta'?» ");
INSERT INTO ktj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «'N pʋ꞊ʋ ꞊haan‑tɩ, ‑ɛ mɔ, a ‑hre꞊e nɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ, 'klɔ a ‑wlu꞊tuulɛ', ‑tɛ Nyɩsʋa yɩ la ‑tonyiblo nɩ ni, ɛ nu꞊o nɩ, ‑tonyiblo a 'mʋ, 'ɛ mɔ nyɩbɛyugbe kɔ nʋgba 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ɛ nɔ‑ kɔ ‑tɩ nyɩbɛyugbe 'mʋ 'ʋ 'a 'baɩ kɔ 'a 'dii 'hʋɛn‑ bʋ hie, ɛ 'mʋ nʋgba kɔ, ɛ kɔ 'a nʋgba a 'mʋ 'hʋɛn‑, ʋ 'mʋ 'hʋɩ bʋ ‑nɩnɩ ‑nɩ, ʋ nɩ 'hʋɛn a 'mʋ, ʋ 'mʋ ‑tonyiblogblo nɩ ‑do ‑hɛ. ");
INSERT INTO ktj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ɛ ꞊hɛn 'nyrɛ, ‑ɛ mɔ, ʋ 'yɩ 'kɩ ‑tonyibli nɩ 'hʋɛn 'pa‑, kɛɛ, ʋ mɔ ‑tonyiblo nɩ ‑do ꞊nɩɔ. 'A ‑tɩ o, nyɩbɛyugbe kɔ 'a nʋgba 'hʋɛn‑, Nyɩsʋa ‑nu, 'ʋ ‑hɛ ‑tonyiblo nɩ ‑do, nyiblo ꞊dʋ 'yɩ yɩ ‑blɛɛ ‑nɩ, bʋ ‑hɩhɩa ꞊nʋ yrɛ.» Kɛ‑ ‑Yusu pʋ ꞊nʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","‑Ɛ ‑bɩ Falisi꞊tumu a nyibli ꞊tu꞊o ꞊wɔn, ʋ wɛn: «Dɛ‑ kɔ ‑tɩ, 'kɩ 'lɩ tete 'kwli, Nyɩsʋa a winwlɔn‑hanyɔ Moise 'ɛ hla꞊a, ‑ɛ mɔ, nyɩbɛyugbe 'bʋ ‑hʋɛ bʋ pʋ 'lɩ 'a nʋgba ‑patʋ', ‑ɛ ‑bɩ bʋ 'crɩ 'crɩɛn, ‑ɛ hlɛ꞊ɛ, ‑ɛ mɔ, ɛ pʋ 'lɩ꞊ɩ ‑patʋ', 'tɩ‑ bʋ ‑ha 'lɩ 'crɩɛn a 'mʋ, bʋ ‑nyi ꞊nɛ꞊ɛ?» ");
INSERT INTO ktj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","‑Ɛ ‑bɩ ‑Yusu wɛn 'nɩ: «'Aan ꞊wlɩ a 'gboklolɛ a ‑tɩ ꞊nɩɔ, Moise 'ɛ ‑nyi 'a mʋ 'hru, 'kɩ ba pʋ 'lɩ 'aan nʋgbɩ ‑patʋ' lɛ. Kɛɛ, 'klɔ a ‑wlu꞊tuulɛ', ɛ 'yɩ la 'mʋ lɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, nʋgba 'bʋ 'yɩ 'ʋ 'a nyɩbɩʋ bʋ ‑hie, 'tɩ‑ 'a nyɩbɩʋ a 'mʋ 'bʋ pʋ 'lɩ꞊ɩ ‑patʋ', 'tɩ‑ 'bʋ kɔ nʋgba ‑bɩ, ‑ɛ ‑bɩ ɛ nu ‑wlawlɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","‑Ɛ ‑bɩ 'a ‑nagbopʋ yɩ 'kɩ꞊ɩ 'nɩ ‑lee ‑nɩ, ʋ wɛn: «'Bʋ mɔ, 'bʋ nɩ 'mʋ lɛ, 'kɩ 'ʋ nyɩbɛyugbe kɔ nʋgba 'hʋɛn‑ ‑mɔ, ‑ɛ ‑bɩ ɛ nu ‑tɛɛ, 'kɩ ʋ 'nɩ 'kʋkɔɔ 'lɩ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «Ɛ 'yɩ nyibli a pɛpɛ 'pa‑, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ yru ‑tɩ a 'mʋ lɛ. Nyibli nɩ ‑do ‑mʋ', Nyɩsʋa ‑nyi 'klɩ, ʋ nʋ‑ yrui ‑tɩ a 'mʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ɛ kɔ ‑tɛblɩ ‑hʋɔhʋɩ, ‑ɛ ni꞊e, 'kɩ nyɩbɛpʋ 'yɛ nɩ kɔ nʋgbɩ: ‑ʋ ‑bɩ nɩ 'ʋ, 'ʋ 'yɩ 'yonʋkɔdɛ, ‑ʋ ‑bɩ 'ʋ nɩ 'ʋ, 'ʋ ‑ha ꞊nʋ bɔtɔ, ‑ɛ di꞊e nu, ʋ 'nɩ ꞊ha nʋgbɩ kɔ, ‑ʋ ‑bɩ 'nɩ ‑kɔ꞊ɔ nʋgbɩ, ‑ɛ di꞊e nu, ʋ 'mʋ Nyɩsʋa a ‑kʋan nɩ ‑do a ‑tɩ 'lu mɔ lɛ ‑hie, Nyɩsʋa a 'mʋ, ɛ 'mʋ nyibli win kɩ ‑kɔɔ ‑nɩ. 'A ‑tɩ, nyiblo ‑bʋ, ‑ɛ ‑wɛ 'lɩ ‑tɩ ‑bʋ a kʋa'buble, ɛ nɔ‑ ‑bʋ 'ble꞊e kʋa.» ");
INSERT INTO ktj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ɛ kɔ la ‑nyrɔwɔ ꞊dʋ, 'ʋ gba 'lɩ 'yonʋ ‑Yusu yɩ, ɛ 'mʋ ꞊nʋ dabʋɩ 'lu blɛ pʋ, kɔ, ɛ 'mʋ Nyɩsʋa da, Nyɩsʋa 'mʋ 'yonʋ a 'mʋ ꞊haandɛ ‑mɔ nu. Kɛɛ, ‑tɛ ‑nagbopʋ* 'ye dɛ a 'mʋ, ‑ɛ ‑bɩ ʋ ‑tʋa 'waa ‑mɔ'pʋplɛ, ʋ wɛn: «A 'nɩ 'haa 'lɩ꞊ɩ 'ku.» ");
INSERT INTO ktj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kɛɛ, ‑ɛ ‑bɩ ‑Yusu wɛn 'nɩ: «Ba ‑ha 'yonʋ mɛ lɛ, bʋ di 'nɛ‑ 'mʋ ‑mɔ. A 'nɩ 'kaa 'lɩ ꞊nʋ yɩ, ‑ɛ nu꞊o, nyibli ‑mʋ', ‑ʋ 'wɩ‑ 'yonʋ ‑bʋ yɩ, ʋ nʋ‑ di 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli pa,» ");
INSERT INTO ktj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","'ɛ ‑tʋa 'waa dabʋɩ a 'lublɛpʋpʋʋ, 'ɛ dɛ Nyɩsʋa, 'kɩ bʋ nu ꞊nʋ ꞊haandɛ ‑mɔ. ‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ɛ ‑hɔn 'lɩ ‑tɩtɛ a 'mʋ nɩ, 'ɛ ‑mu. ");
INSERT INTO ktj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","‑Nyrɔwɔ ꞊dʋ 'kwli, gblotayu ꞊dʋ, ɛ nɔ‑ 'yɩya 'ʋ ‑Yusu 'hʋɩ bʋ, 'ɛ yɩ꞊ɩ 'bɛti ‑nɩ, ɛ wɛn: «Tɔɔnyɔ o, ꞊haandɛ a 'dɩ ‑bɩ 'n di nu, 'tɩ‑ Nyɩsʋa a 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ, 'mʋ꞊ʋ kɔ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","‑Ɛ ‑bɩ ‑Yusu wɛn: «Dɛ‑ kɔ ‑tɩ ꞊nɩ yɩ 'mʋ 'bɛti ‑nɩ, 'kɩ 'ʋ ꞊haandɛ a ‑ta' 'lɩ? Nyɩsʋa nɩ ‑do, ɛ nɔ‑ mɔ ꞊haannyiblo. 'Bʋ mɔ, ꞊nɩ yɩ꞊ɩ nɩ ‑hʋɛ, 'kɩ Nyɩsʋa bʋ ‑nyi ‑mʋ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ, ‑ɛ ‑bɩ ꞊tuu 'ʋ 'a tete 'ʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","‑Ɛ ‑bɩ ɛ 'bɛti꞊e nɩ, ɛ wɛn: «Tete a 'dɩ ‑bɩ 'n di 'ʋ ꞊tuu ‑nɩ 'lɩ?» ‑Ɛ ‑bɩ ‑Yusu wɛn: «꞊Nɩ 'laa 'lɩ nyiblo, ꞊nɩ 'nuo 'lɩ ‑wlawlɩ, ꞊nɩ 'yrie 'lɩ, ꞊nɩ 'pʋʋ 'lɩ nyiblo hɩ kɩ, ");
INSERT INTO ktj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","꞊tuu 'ʋ ‑na 'baɩ kɔ ‑na 'dii 'hʋɛn‑, 'kɩ 'lɩ nʋɛlɛ 'kwli, nʋɛ ‑na 'bɩhɩan ‑tonyiblo, ꞊wɩ yɩ ‑tɛ ‑nu ‑na dɩɔnʋ a nʋɛlɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","‑Ɛ ‑bɩ gblotayu a 'mʋ, ɛ wɛn: «'Ɛ mɔ ‑tɛɛ, tete a pɛpɛ a 'mʋ, 'n ꞊tuu 'ʋ꞊ʋ nɩ. Dɛ a 'dɩ ‑bɩ 'n kɔ ꞊bʋ nu de?» ");
INSERT INTO ktj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ꞊ɩ yɩ, ɛ wɛn: «'Bʋ mɔ, ꞊nɩ ‑hʋɛ ‑bʋ 'sii 'ʋ yɩ pɛpɛ, mu, ‑bʋ plo ‑na kʋkɔ‑tɛblɩ a pɛpɛ, ‑bʋ ‑nyi 'a 'wliyɛ ꞊hɩʋɛnnyibli lɛ, Nyɩsʋa 'mʋ ‑mʋ ꞊haandɛ gbagbʋ ‑mɔ nu, 'kɩ 'lɩ yakɔ 'kwli. ꞊Nɩ nu 'kɩ꞊ɩ, ‑ɛ ‑bɩ kʋɛ 'mʋ ꞊wien lɛ, ꞊mʋ 'na ‑nagbopi* ‑hɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Gblotayu ‑mɔ ‑bɩ, ‑tɛ ɛ 'wɩn ‑tɩ a 'mʋ, ‑Yusu ‑hla, ‑ɛ ‑bɩ 'a ꞊wlʋ bi ꞊hlɔn, 'ɛ ‑hɔn 'ʋ꞊ʋ 'hʋɩ, ‑ɛ nu꞊o, 'a kʋkɔ‑tɛblɩ ‑hʋ nɩ dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","‑Tɛ ɛ mu 'kɩ, ‑ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'a ‑nagbopʋ yɩ, ɛ wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, ɛ di 'mʋ 'nɩ kla, 'kɩ dɛkɔnyɔ bʋ di 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli pa. ");
INSERT INTO ktj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","'Ɛ mɔ ꞊han‑tɩ, ɛ kla 'mʋ nɩ, 'kɩ 'ʋ dɛkɔnyɔ ‑mɔ', ‑ɛ kuo nɛ 'a kʋkɔ‑tɛblɩ ꞊wlʋ yɩ, bʋ kuo Nyɩsʋa ꞊wlʋ yɩ, bʋ pa 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli, 'ɛ ‑hi 'ʋ ꞊gbukɩ‑so* bʋ naa 'ʋ 'die a 'hʋɔ 'yri.» ");
INSERT INTO ktj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","‑Yusu a pʋpʋwin a 'mʋ, ɛ maa nɛ 'a ‑nagbopʋ wlɔn lɛ dɩakɩ. 'A ‑tɩ, ʋ wɛn: «'Bʋ kɔ bʋ nɩ 'mʋ lɛ, ‑ɛ ‑bɩ nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ pa 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","‑Yusu 'ye ꞊nʋ ‑yeye, ɛ wɛn: «'Kɩ 'lɩ ‑tonyiblo a dɩɔnʋ a 'klɩ 'kwli, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ kuo Nyɩsʋa ꞊wlʋ yɩ, 'tɩ‑ bʋ pa 'lɩ 'a 'klɔ yrayrʋ 'kwli. Kɛɛ, 'kɩ 'lɩ Nyɩsʋa a 'klɩ 'kwli, 'a ‑nɛ ꞊dedede ‑wɛ 'lɩ nuelɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","‑Ɛ ‑bɩ kɛ‑ Piɛlɩ pɩ ‑Yusu yɩ: «‑A mʋ ‑mɔ ‑bɩ 'lɩ? 'Ye kɛ, ‑a hie 'ʋ ‑aan nyibli bʋ, ɛ kɔ ‑aan ‑tɛblɩ a pɛpɛ 'hʋɛn‑, ꞊a yɩ ‑mʋ ꞊wien lɛ kʋɛ. 'A ‑tɩ, dɛ a 'dɩ ‑bɩ Nyɩsʋa di ‑a mʋ ‑nyi 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","‑Ɛ ‑bɩ ‑Yusu wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, ti ‑mʋ', ‑ɛ kɔ 'yri 'n di 'ʋ 'na bodɩɔgbata ‑mʋ' kɩ bʋ nɩ, 'kɩ 'lɩ 'klɔ yrayrʋ ‑mʋ' 'kwli, ti a 'mʋ 'yri, 'a mʋ ‑mʋ', ‑ʋ mɔ 'na ‑nagbopʋ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn, 'kɩ a di 'ʋ 'aan ‑nɛ gbatɩ kɩ blɛ nɩ ‑wɛ, ‑ɛ di꞊e nu, a 'mʋ Yisraɛkʋɛ a ꞊tugbi nɩ ‑pu ꞊tu 'ʋ 'hʋɛn ‑bati lɛ ‑pʋʋ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kɔ, 'a ‑nɛ nyiblo 'bʋ hie 'ʋ 'a 'kayo bʋ, kɔ 'a 'dɩayɩnʋ, kɔ 'a 'baɩ kɔ 'a 'dii, kɔ 'a nʋgba kɔ 'a 'yonʋ, kɔ 'a ‑cii 'hʋɛn‑, 'na nʋɛlɛ a ‑tɩ, nyiblo a 'mʋ, ‑tɛblɩ Nyɩsʋa di꞊e ‑nyi, ɛ di 'nɩ ‑hʋ dɩakɩ, ɛ 'mʋ 'ʋ 'a dɛ ‑mʋ', ɛ hie 'ʋ bʋ 'ʋ ‑hi, Nyɩsʋa 'mʋ꞊ʋ 'klɔ yrayrʋ ‑mʋ' ‑nyi, ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kɛɛ, nyibli ‑mʋ', ‑ʋ nɩ 'ʋ 'waa 'bio 'lu yɩ, 'kɩ 'lɩ ‑tɛ ti nɛ ‑bʋ 'kwli, 'waa ‑hʋɔhʋɩ, ʋ nʋ‑ di 'lɩ 'waa 'bio bʋ nɩ ‑nyrɔwɔ ꞊dʋ, ɛ kɔ, nyibli ‑mʋ', ‑ʋ nɩ 'lɩ 'waa 'bio bʋ, 'kɩ 'lɩ ‑tɛ ti nɛ ‑bʋ 'kwli, 'waa ‑hʋɔhʋɩ 'mʋ 'ʋ 'waa 'bio 'lu yɩ nɩ, ‑nyrɔwɔ ꞊dʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","(‑Ɛ ‑bɩ ‑Yusu pʋ 'ledʋ ‑bɩ, ɛ wɛn:) «Nyɩsʋa 'bʋ kɔɔ nyibli win kɩ, dɛ ɛ 'wɩ yɩ, ɛ nɔ‑ ‑bʋ: 'Dʋdɔnyɔ gbagbʋ ꞊dʋ, ɛ nɔ‑ 'hrɩ ‑nyrajruwɔ ꞊dʋ, 'ɛ mu ‑kʋannunyibli lɛ ꞊mʋɔ mɔ, ‑ɛ di꞊e nu, ʋ 'mʋ 'a ‑kʋan nu, 'kɩ 'lɩ 'a ‑ci kɩ. ");
INSERT INTO ktj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","‑Tɛ ɛ 'ye yɩ‑hɛnyibli, ‑ɛ ‑bɩ ɛ kɔ ꞊nʋ 'hʋɛn‑, ʋ ‑yra꞊a nɩ, 'kɩ bʋ 'pɛɛ ꞊nʋ ‑nyrɔwɔ 'mumu a 'wliyɛ, 'ɛ lee ꞊nʋ, 'kɩ bʋ mu 'a ‑kʋan nu, 'kɩ 'lɩ 'a ‑ci kɩ. ");
INSERT INTO ktj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Muu 'ʋ 'yrʋ bʋ 'yaa 'ʋ a ti 'yie, ‑ɛ ‑bɩ ɛ 'hrɩ nɩ de, 'ɛ mu 'lɩ ‑tɩtɛ ‑mʋ', nyibli ‑mʋ', ‑ʋ ꞊mʋɛ ‑kʋan lɛ, ʋ yɩ 'ʋ blɛ nɩ, 'kɩ 'ʋ ‑tɩtɛ a 'mʋ, 'ɛ yɛ 'ʋ nyibli ‑bɩ bʋ, ‑ʋ 'yɛ nɩ nu ‑kʋan ꞊dʋ. ");
INSERT INTO ktj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‑Ɛ ‑bɩ ɛ wɛn: Ba mu 'lɩ 'na ‑ci kɩ ‑wɛ, a 'mʋ ‑kʋan nu. 'Wliyɛ ‑mʋ', ‑ɛ blɛɛ nɛ 'a mʋ yɩ, 'n di 'a mɔ꞊ɔ 'nɩ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ɛ nɔ‑ mɔ nyibli a 'mʋ, bʋ mu 'lɩ 'a ‑ci kɩ. Muu 'ʋ 'yrʋ bʋ nyra bʋ a ti 'yie, ‑ɛ ‑bɩ ɛ 'hrɩ nɩ de, 'ɛ mu ‑kʋannunyibli ‑bɩ lɛ ꞊mʋɔ mɔ. Dɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ ɛ ‑nu 'yrʋ‑hiilɛ a ti 'yri. ");
INSERT INTO ktj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","‑Tɛ ɛ hie 'lɩ ‑haawɔ nɩ ‑do, nyibli 'mʋ ‑kʋan bʋ ‑nyraa ‑nɩ, ‑ɛ ‑bɩ ɛ 'hrɩ nɩ de, 'ɛ mu 'lɩ ‑tɩtɛ ‑mʋ', nyibli ‑mʋ', ‑ʋ ꞊mʋɛ ‑kʋan lɛ, ʋ yɩ 'ʋ blɛ nɩ, 'ɛ yɛ 'ʋ nyibli ‑bɩ bʋ de, ɛ wɛn: Dɛ‑ kɔ ‑nyrɔwɔ ‑gbu ‑bʋ, a yɩ mɔ ‑hii ‑nɩ, 'kɩ a 'yɛ nɩ nu ‑kʋan 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‑Ɛ ‑bɩ ʋ ꞊tu꞊o ꞊wɔn, ʋ wɛn: Nyiblo ꞊dʋ 'yɩ ‑a mʋ ‑kʋan ‑mɔ ‑pʋ a ‑tɩ ꞊nɩɔ. ‑Ɛ ‑bɩ ɛ wɛn: 'Bʋ nɩ 'mʋ lɛ, ‑ɛ ‑bɩ ba mu 'lɩ 'na ‑ci kɩ ‑wɛ, a 'mʋ 'na ‑kʋan nu. ");
INSERT INTO ktj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","‑Tɛ 'yrʋ yɩ 'lɩ yakɔ 'kwli lɛ nɩ ‑wɛ, ‑ɛ ‑bɩ ‑cikɔnyɔ da 'a ‑kʋannunyibli a nyiblo gbagbʋ nɩ, ɛ wɛn: Da ‑kʋannunyibli a pɛpɛ, ꞊mʋ ꞊nʋ 'pɛɛ ‑nɩ. Yɩ‑hɛnyibli ‑bʋ 'pɛɛ ‑nɩ, ʋ nʋ‑ mɔ nyibli ‑bʋ, ‑ʋ pɛɛ 'tɔ, 'n pʋ ‑kʋan kɩ. Ɛ nɔ‑ ‑di nu ‑nunu, yɩ‑hɛnyibli ‑mʋ', 'n pʋ wɛn ‑kʋan kɩ, ꞊mʋ ꞊nʋ kɩ yɛ. ");
INSERT INTO ktj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nyibli ‑mʋ', ‑ʋ nu ‑haawɔ nɩ ‑do a ‑kʋan, ‑tɛ ʋ ‑di, ʋ 'ye ‑nyrɔwɔ 'mumu a 'wliyɛ. ");
INSERT INTO ktj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","‑Tɛ nyibli ‑mʋ', ‑ʋ mɔ wɛn yɩ‑hɛnyibli, ʋ pʋ wɛn ‑kʋan kɩ, ʋ 'ye dɛ a 'mʋ, ‑ɛ mi 'lu ‑mɔ, ‑ɛ ‑bɩ 'waa ꞊wlɩ wɛn, 'waa ‑nɛ 'wliyɛ di 'nɩ ‑hʋ, ɛ 'mʋ 'ʋ 'waa 'bio a ‑nɛ 'ʋ ‑hi. Kɛɛ, ʋ ‑nyi ꞊nʋ ‑nyrɔwɔ 'mumu a 'wliyɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","‑Tɛ ʋ ‑nyi ꞊nʋ 'wliyɛ a 'mʋ, ‑ɛ ‑bɩ ʋ pɩɩ ‑cikɔnyɔ yrʋ lɛ, ");
INSERT INTO ktj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ʋ wɛn: Nyibli ‑mʋ', ‑ʋ pɛɛ 'tɔ, ‑ʋ nu ‑haawɔ nɩ ‑do a ‑kʋan, kɔ ‑a mʋ ‑bʋ, ‑ʋ ‑tʋa wɛn 'lɩ ꞊hɩʋɛn a 'yiye, ‑nyrɔwɔ ‑gbu ‑bʋ 'kwli, 'yrʋ yɩ kɛ yɩ ‑hʋɛn ‑nɩ, ʋ kɔ ‑a mʋ 'hʋɛn‑, 'wliyɛ nɩ ‑do, ɛ nɔ‑ ꞊pɛɛ nɛ ‑a mʋ. ");
INSERT INTO ktj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kɛɛ, ‑cikɔnyɔ ꞊tu 'a nyiblo nɩ ‑do ꞊wɔn, ɛ wɛn: 'Bɩhɩan o, 'n 'yɩ ‑mʋ ‑kaa ‑nɩ. ꞊Bɩ ‑kɔ 'mʋ 'hʋɛn‑, ‑a 'yɩ wɛn꞊ɛ ‑yra, 'kɩ ꞊bʋ 'pɛɛ wɛn ‑mʋ ‑nyrɔwɔ 'mumu a 'wliyɛ. ");
INSERT INTO ktj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","'A ‑tɩ o, gba ‑na 'wliyɛ, ‑bʋ mu. Nyibli ‑bʋ, ‑ʋ pɛɛ 'tɔ, 'n pʋ 'ʋ ‑kʋan 'yie, 'wliyɛ nɩ ‑do ‑mʋ', 'n ‑hʋa ꞊bʋ ‑nyi ꞊nʋ, 'wliyɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ 'n ‑hʋa ꞊bʋ ‑nyi ‑mʋ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","‑Tɛ 'n ni 'na kʋkɔ‑tɛblɩ a naalɛ, 'mɔ kɔɔ 'lɩ꞊ɩ ‑mɔ. ꞊Bɩ ca ꞊tui, ‑tɛ 'na ꞊wlʋ nɔ yɩ a ‑tɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","‑Ɛ ‑bɩ ‑Yusu wɛn 'nɩ de: «'A ‑tɩ o, nyibli ‑bʋ, ‑ʋ nɩ 'lɩ 'waa 'bio bʋ, ‑nyrɔwɔ ꞊dʋ, ʋ nʋ‑ di 'ʋ 'waa 'bio 'lu yɩ nɩ, ɛ kɔ, nyibli ‑mʋ', ‑ʋ nɩ 'ʋ 'waa 'bio 'lu yɩ, ʋ nʋ‑ di 'lɩ 'waa 'bio bʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","‑Tɛ ‑Yusu ‑yrɛ, ‑ɛ ‑bɩ ɛ 'tɩɛ gbɛ 'hru 'lu ‑mɔ, ɛ kɔ 'a ‑nagbopʋ* 'hʋɛn‑, 'ʋ mi 'lɩ Jrusrɛdɩɔ 'kwli. Bʋ yɩ 'kɩ 'hru nɩ nɛ, ‑ɛ ‑bɩ ‑Yusu da 'a ‑nagbopʋ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn nɩ, 'ʋ bii yɩ, 'ɛ lee ꞊nʋ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Ba pʋ 'mʋ nʋa yɩ bʋ. Jrusrɛdɩɔ, ‑a mi 'lɩ 'kwli, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'kɩ ʋ di 'lɩ 'mʋ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ ‑jɩ' pʋ, kɔ tetetɔɔnyʋ 'hʋɛn‑, ʋ 'mʋ 'mʋ ‑bati lɛ ‑pʋʋ ‑nɩ, ʋ 'mʋ lɛ pʋ, 'n blɛɛ 'kʋkʋʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","'Bʋ ‑hi, 'tɩ‑ ʋ 'mʋ 'mʋ nyibli ‑mʋ', ‑ʋ 'yɩ Nyɩsʋa ‑yi ‑jɩ' pʋ, nyibli a 'mʋ, ʋ 'mʋ 'mʋ 'caa ‑nɩ, ʋ 'mʋ 'mʋ lɔkɔ ‑bii ‑nɩ, 'tɩ‑ ʋ 'mʋ 'ʋ 'mʋ tugbɛ 'yie ‑kɔɔ ‑nɩ, ‑ɛ di꞊e nu, ʋ 'mʋ 'mʋ 'la. ‑Nyrɔwɩ nɩ 'hʋɛn 'bʋ ‑hi, ta a ‑nyrɔwɔ, Nyɩsʋa kɔ bʋ ‑ha 'lɩ 'mʋ 'kʋkʋnyibli 'nyɩ, bʋ ‑ha 'mʋ 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ Sebede a nʋgba, ɛ nɔ‑ 'yɩya 'ʋ ‑Yusu 'hʋɩ bʋ, ɛ kɔ 'a 'yonʋ nɩ 'hʋɛn 'hʋɛn‑, ‑ʋ mɔ ‑Yusu a ‑nagbopʋ* Sakɩ kɔ Saan, 'ɛ bla꞊a kwlɩ yɩ bʋ, ‑ɛ di꞊e nu, ɛ 'mʋ꞊ʋ dɛ ‑hʋa. ");
INSERT INTO ktj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ꞊ɩ yɩ, ɛ wɛn: «Dɛ a 'dɩ ‑bɩ ‑hʋɛ ꞊bʋ nu, 'kɩ 'ʋ ‑mʋ ‑mɔ 'lɩ?» ‑Ɛ ‑bɩ ɛ ꞊tu꞊o ꞊wɔn, ɛ wɛn: «Ti ‑mʋ', ‑ɛ kɔ 'yri ‑di nyibli a pɛpɛ win kɩ ‑kɔɔ ‑nɩ, 'kɩ 'lɩ Nyɩsʋa a bʋnɩɩlɛ', 'n ‑hʋɛ꞊ɛ nɩ, ‑bʋ wɛn, 'na 'yonʋ nɩ 'hʋɛn ‑bʋ, bʋ nɩ 'ʋ ‑mʋ 'hʋɩ bʋ, ‑do 'kɩ 'lɩ ‑na diidɛkɩbɩa kɩ, ‑do ‑bɩ 'kɩ 'lɩ ‑na kamlakɩbɩa kɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ: «Dɛ ‑bʋ, a ‑hʋɛ, dɛ bʋ di 'nyrɛ ꞊hɛn, a 'yɩ꞊ɩ ‑yi. ꞊Bɩ ꞊hɩʋɛndʋ ‑mʋ', 'n di 'ye, a ‑wɛ 'lɩ ba 'ye꞊e nɩ?» ‑Ɛ ‑bɩ ʋ wɛn: «‑A ‑wɛ 'lɩ꞊ɩ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","‑Ɛ ‑bɩ ɛ wɛn: «'Ɛ mɔ ꞊han‑tɩ, ꞊hɩʋɛndʋ a 'mʋ, 'n di 'ye, a 'mʋ꞊ʋ 'ye. Kɛɛ, nyiblo, ‑ɛ kɔ ‑bʋ nɩ 'na diidɛkɩbɩa kɩ bʋ, kɔ, nyiblo ‑bɩ ‑mʋ', ‑ɛ kɔ ‑bʋ nɩ 'na kamlakɩbɩa kɩ bʋ, ɛ 'yɩ 'mɔ 'pa‑, 'nɩ ‑wa꞊a lɩ ꞊nʋ 'nyrɛ nɩ. 'Na 'Baɩ Nyɩsʋa a ꞊gbɛtʋ, ɛ nɔ‑ di nyibli a 'mʋ 'nyrɛ wa.» ");
INSERT INTO ktj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","‑Tɛ ‑nagbopʋ nɩ ‑pu ‑bɩ ‑mʋ', ʋ 'wɩn ‑tɩ a 'mʋ, 'dɩayɩnʋ nɩ 'hʋɛn, ʋ lee ‑Yusu, ‑ɛ ‑bɩ ʋ ‑tʋa 'waa yrʋ a lɛpʋʋlɛ. ");
INSERT INTO ktj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ɛ nɔ‑ mɔ ‑Yusu bʋ da 'waa pɛpɛ, ɛ wɛn: «A yi꞊e nɩ, ‑ɛ mɔ, 'klɔ ‑bʋ a 'luyɩnɩnyʋ, ‑ʋ nɛɛ 'waa dakɔ, ʋ ꞊tui ꞊nʋ ꞊hɩʋɛn, 'ʋ yɩ ꞊nʋ 'plɔ. 'Waa 'kɩɩndɛ a 'mʋ, ʋ nii 'lɩ꞊ɩ 'crɛ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","'A mʋ ‑mɔ ‑bɩ, ɛ 'yɩ yɩ ‑blɛɛ ‑nɩ, bʋ ꞊ti 'mʋ lɛ, 'kɩ 'lɩ 'a mʋ 'nyɩ. Nyiblo 'bʋ ‑hʋɛ bʋ mɔ 'aan naanyɔ, nyiblo a 'mʋ, ɛ blɛɛ yɩ, bʋ mɔ 'aan ‑hɛɛnyɔ. ");
INSERT INTO ktj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ɛ kɔ, 'kɩ 'lɩ 'a mʋ 'nyɩ, nyiblo 'bʋ ‑hʋɛ bʋ mɔ 'aan 'luyɩnɩnyɔ, nyiblo a 'mʋ, ɛ blɛɛ yɩ, bʋ ‑wɛ ‑mɔ, 'kɩ bʋ ‑hɛɛ nɛ 'aan pɛpɛ. ");
INSERT INTO ktj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","'Na 'mumu ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n 'yɩ ‑di, 'kɩ nyibli bʋ ‑hɛɛ 'mʋ, kɛɛ, 'n di nɩ, 'kɩ ꞊bʋ ‑hɛɛ nyibli, ɛ kɔ, ꞊bʋ ‑ha 'na dɩɔnʋ, 'mʋ 'kʋ, ‑ɛ di꞊e nu, 'na 'kʋkʋʋ a 'mʋ, ɛ 'mʋ꞊ʋ nu, Nyɩsʋa 'mʋ nyibli ‑hʋɔhʋɩ ꞊gblɛ, 'kɩ 'ʋ 'waa dɛ 'kuku ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, 'kɩ ʋ ‑hʋɛn 'lɩ 'dɩɔ ‑mʋ', ʋ dɛɛ Seliko 'kwli. ‑Tɛ ʋ yɩ 'dɩɔ a 'mʋ 'kwli nɩ ꞊tɩ, nyibli ‑hʋɔhʋɩ kʋɛ ꞊nʋ ꞊wien. ");
INSERT INTO ktj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","'Hru a 'mʋ, ʋ nɛ, ɛ nɔ‑ kɔ 'nyɩa 'yri 'yii'dɔnyʋ nɩ 'hʋɛn nɩ 'ʋ bʋ. 'Yii'dɔnyʋ a 'mʋ, ʋ 'wɩn nɩ, ‑ɛ mɔ, ‑Yusu, ɛ nɔ‑ yɩ ‑hi. Ɛ nɔ‑ mɔ bʋ 'yaa 'lɩ win, ʋ wɛn: «Tɔɔnyɔ o, Dafidɩ a 'Yu, yru ‑aan nyaɩ mɔ!» ");
INSERT INTO ktj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nyibli ‑mʋ', ‑ʋ nɩ 'ʋ ‑tuo a 'mʋ kɩ, ʋ ‑tʋa 'waa ‑mɔ'pʋplɛ, ʋ wɛn: «Ba ma wien mɔ!» Kɛɛ, ʋ hɩa nɩ, 'ʋ 'sii yɩ, 'ʋ 'yɛɛ 'lɩ win, ʋ wɛn: «Dafidɩ a 'Yu, yru ‑aan nyaɩ mɔ!» ");
INSERT INTO ktj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","‑Tɛ ‑Yusu 'wɩn 'waa win, ‑ɛ ‑bɩ ɛ nyra bʋ, 'ɛ da ꞊nʋ. ‑Tɛ ʋ nyre 'ʋ꞊ʋ 'hʋɩ, ‑ɛ ‑bɩ ‑Yusu 'bɛti ꞊nʋ nɩ, ɛ wɛn: «Dɛ a 'dɩ ‑bɩ a ‑hʋɛ, ꞊bʋ nu, 'kɩ 'ʋ 'a mʋ ‑mɔ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","‑Ɛ ‑bɩ ʋ wɛn: «Tɔɔnyɔ o, ‑a ‑hʋɛ ‑bʋ nu꞊o, ‑aan 'yii ‑bʋ, ‑ʋ klɛ, bʋ klɛ yɩ!» ");
INSERT INTO ktj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ɛ nɔ‑ mɔ ‑Yusu bʋ yru 'waa nyaɩ, bʋ ‑hrɛn 'waa 'yii lɛ. Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ ʋ nɩ 'hʋɛn a 'mʋ, ʋ ‑tʋa lɛyuyruo, 'ʋ bi 'ʋ ‑Yusu ke', 'ʋ ‑tʋa 'a ꞊wienlɛkʋkʋɛ. ");
INSERT INTO ktj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","‑Tɛ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ mi 'lɩ Jrusrɛdɩɔ 'kwli, ‑ɛ ‑bɩ 'kɩ ʋ nyre 'lɩ 'dɩɔ ‑mʋ', ‑ɛ kɔ 'nyrɛ mɔ Bɛtɩfase 'kwli, ‑ɛ nɩ 'ʋ dʋgba ‑mʋ' ꞊hlɔn, ‑ɛ kɔ 'lu olifieti nɩ 'lɩ, ‑Yusu 'ɛ lee nɛ 'a ‑nagbopʋ nɩ 'hʋɛn. ");
INSERT INTO ktj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Kɛ‑ ɛ pɩ ꞊nʋ yɩ: «'Dɩɔ ‑mʋ', ‑ɛ nɩ 'lɩ 'a mʋ ye', ba mu 'lɩ꞊ɩ 'kwli. 'Ba 'ya 'dɩɔ, a di yɛɛ 'ʋ 'kasra kɔ 'a 'yu 'hʋɛn‑, ʋ mʋa bʋ. 'Ba yɛɛ 'ʋ ꞊nʋ bʋ, ‑ɛ ‑bɩ ba ꞊wlɛ ꞊nʋ, ba ya 'mʋ ꞊nʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nyiblo ꞊dʋ 'bʋ 'bɛti 'a mʋ, ‑ɛ ‑bɩ kɛ‑ ba pʋ: Kʋkɔnyɔ, ɛ nɔ‑ ‑hʋɛ ꞊nʋ. 'Ba hla꞊a, ti nɩ ‑do a ti 'yri, ɛ di 'nɩ wɛn, a 'mʋ 'lɩ ꞊nʋ 'lɩ ya.» ");
INSERT INTO ktj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Dɛ a 'mʋ, ɛ mu 'lu ‑mɔ, ‑ɛ di꞊e nu, ‑tɩ ‑mʋ', Nyɩsʋa a winwlɔn‑hanyɔ* hla la, ɛ 'mʋ ‑nue ‑nɩ. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: ");
INSERT INTO ktj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Kɛ‑ ba pʋ Siondɩɔ (‑ɛ mɔ Jrusrɛdɩɔ) a nyibli yɩ: Ba 'ye kɛ, 'aan ‑nɛ Bodɩɔ, ɛ nɔ‑ yɩ 'nɛ‑ 'a mʋ ‑mɔ di. Ɛ ꞊tɩɔ 'lɩ 'a dɩɔnʋ nɩ, 'ɛ 'ya 'ʋ 'kasra kɩ, ɛ kɔ 'kasrayu 'hʋɛn‑.» ");
INSERT INTO ktj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","‑Tɛ ‑Yusu lee la 'a ‑nagbopʋ nɩ 'hʋɛn a 'mʋ, ‑ɛ ‑bɩ ʋ mu nɩ, 'ʋ nu dɛ ‑mʋ', ‑Yusu lee ꞊nʋ, ");
INSERT INTO ktj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","'ʋ ya 'kasra kɔ 'a 'yu a 'mʋ 'hʋɛn‑ ‑Yusu yɩ. ‑Tɛ ʋ 'ya ꞊nʋ, ‑ɛ ‑bɩ 'waa danɩ kɔ 'waa wlawlɩ 'hʋɛn‑, ɛ nɔ‑ ʋ pʋ 'ʋ 'kasrɩ a 'mʋ kɩ blɛ, ‑ɛ di꞊e nu, ‑Yusu 'bʋ 'ya 'ʋ꞊ʋ kɩ, ɛ 'mʋ danɩ a 'mʋ kɩ bʋ nɩ. (‑Ɛ nu꞊o, ɛ tʋɛ ꞊nɛ nyibli nɩ, ‑ɛ mɔ, ɛ mɔ bodɩɔ ꞊nɩɔ, ‑ɛ yɛ 'lɩ kɩbʋwɛɛnlɛ 'lɩ, ɛ 'yɩ tʋ 'pa‑, ɛ 'nɩ ‑ya꞊a 'lɩ꞊ɩ 'lɩ. Ɛ nɔ‑ kɔ ‑tɩ, 'ɛ 'ya 'ʋ 'kasrɩ a 'mʋ kɩ.) ");
INSERT INTO ktj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","‑Tɛ ʋ yɩ 'lɩ nɩ di, nyibli ‑hʋɔhʋɩ pʋ 'ʋ 'waa danɩ 'hru wlɔn blɛ. ‑Ʋ ‑bɩ nɩ 'ʋ, 'ʋ 'bɛ ‑hugbi, 'ʋ pʋ 'ʋ꞊ʋ 'hru wlɔn blɛ, ‑Yusu 'ɛ nɛ꞊ɛ klɛ, ");
INSERT INTO ktj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","nyibli 'ʋ nɛ꞊ɛ ye' lɛ, kɔ, ‑ʋ bɩ 'ʋ yɩ꞊ɩ ꞊wien lɛ kʋɛ. Kɛ‑ ʋ ni, 'ʋ 'yɛɛ 'lɩ win, ʋ wɛn: «‑Na 'wio, Dafidɩ a 'Yu, ‑mɔ ‑bʋ, ‑ɛ yɩ 'lɩ di, 'kɩ 'lɩ Kʋkɔnyɔ Nyɩsʋa a 'nyrɛ 'kwli. Nyɩsʋa bʋ kɔ ‑tɩ a 'yi'bʋalɛ, 'kɩ 'lɩ yakɔ 'kwli!» ");
INSERT INTO ktj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","‑Tɛ ‑Yusu pa 'kɩ 'lɩ Jrusrɛdɩɔ 'kwli, ‑ɛ ‑bɩ 'dɩɔ mi 'lɩ, 'ɛ yɩ 'lɩ di, 'ʋ yɩ lɛ 'bɛti ‑nɩ: «Nyiblo a 'dʋ ‑bʋ ɛ pa 'mʋ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","‑Ɛ ‑bɩ nyibli wɛn: «Ɛ nɔ‑ mɔ Nyɩsʋa a winwlɔn‑hanyɔ ‑Yusu. 'Kɩ ɛ 'ti 'lɩ Nasalɛtɩ, 'kɩ 'lɩ Galileblʋgba 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","‑Yusu ‑mɔ ‑bɩ, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli, 'kɩ ɛ pa 'lɩ. 'Kɩ 'lɩ ‑yaa a 'mʋ 'kwli, 'kɩ puplonyibli nɩ 'lɩ, 'wlugba‑tɛblɩ ‑bʋ, ʋ ni, 'ʋ yɩ Nyɩsʋa a ‑cɔhlʋn pi, ɛ nɔ‑ ʋ ple. 'Kɩ 'ʋ ‑tɩtɛ nɩ ‑do a 'mʋ, 'kɩ 'wli'cɩcɩnyʋ nɩ 'ʋ ‑wɛ, 'ʋ yɩ hɩapʋwli 'cɩcɩ ‑nɩ. ‑Tɛ ‑Yusu yɛɛ 'ʋ ꞊nʋ bʋ, ‑ɛ ‑bɩ ɛ ‑tʋa 'waa lɛbʋbla, 'ɛ yɩ 'wli'cɩcɩnyʋ a 'teble yɩ blɛ ꞊jijri ‑nɩ, 'ɛ 'nyrɛɛ 'lɩ ‑hungboplonyʋ a gbatɩ yrɛ. ");
INSERT INTO ktj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «Ʋ 'crɩɩ la 'lɩ꞊ɩ Nyɩsʋacrɩɛn 'kwli nɩ, ‑ɛ mɔ: Nyɩsʋa wɛn 'nɩ: 'Na 'kayu nɩ 'ʋ nɩ, ‑ɛ di꞊e nu, nyibli 'mʋ 'lɩ 'mʋ ‑daa ‑nɩ.» Kɛ‑ ‑Yusu pɩ de, ɛ wɛn: «Kɛɛ, 'a mʋ ‑mɔ ‑bɩ, a ni 'kayu a 'mʋ 'yiyrinyibli a 'kayu ‑mɔ'.» ");
INSERT INTO ktj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ti nɩ ‑do a 'mʋ 'yri, ‑ɛ ‑bɩ 'yii'dɔnyʋ kɔ nɩanɩnyʋ 'hʋɛn‑, ʋ nʋ‑ 'yɩya 'ʋ ‑Yusu 'hʋɩ bʋ, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli, ‑Yusu, 'ɛ nu꞊o, 'waa 'kʋɛ 'ɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ kɔ tetetɔɔnyʋ ‑mʋ', ‑ʋ nɩ 'ʋ ‑tuo a 'mʋ kɩ, ʋ 'ye ꞊wlɩlɛkɛɛ‑tɛblɩ a 'mʋ nɩ, ‑Yusu ‑nu, 'ʋ 'wɩn 'yonʋ a win, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli, 'yonʋ a 'mʋ, 'ʋ 'yɛɛ 'lɩ win, 'ʋ pɩ lɛ: «‑Na 'wio, Dafidɩ a 'Yu!» Ɛ nɔ‑ nu꞊o, nyibli gbagbɩ a 'mʋ, 'ʋ bi yrʋ' lɛ, ");
INSERT INTO ktj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","'ʋ lee ‑Yusu, ‑ɛ mɔ: «꞊Bɩ ‑tɩ ‑mʋ', ʋ hlɛ, ꞊yɩ꞊ɩ 'nɩ 'wɩn?» ‑Ɛ ‑bɩ ‑Yusu wɛn: «Iin, 'n yɩ꞊ɩ 'nɩ 'wɩn. 'N pʋ꞊ʋ ꞊haan‑tɩ, ‑ɛ mɔ, ‑tɩ ‑mʋ', ʋ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, a ‑hre꞊e nɩ. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: Nyɩsʋa o, 'n nu꞊o nɩ, 'yonʋ kɔ 'nyɩnyayonʋ 'hʋɛn‑ 'ʋ pɩ ‑mʋ 'nyrɛ lɛ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","‑Tɛ ɛ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ɛ ‑hɔn 'ʋ ꞊nʋ 'hʋɩ, 'ɛ mu 'lɩ Betanidɩɔ 'kwli. 'Kɩ ɛ pɛɛ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","‑Tɛ ‑nyrɛ ‑nyɛ, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ yɩ ‑mɛ kle, 'ʋ yɩ 'lɩ Jrusrɛdɩɔ 'kwli di. Bʋ yɩ 'kɩ nɩ di, ‑ɛ ‑bɩ 'kanʋ bi 'lɩ ‑Yusu 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Bʋ ta 'kɩ 'lɩ ye' lɛ, ‑ɛ ‑bɩ ɛ 'ye tugbɛdʋ ‑mʋ', ʋ dɛɛ figie nɩ. 'Kɩ ɛ nyra 'ʋ 'hrunyɩa 'yri bʋ, 'ɛ mu 'ʋ꞊ʋ ꞊hlɔn, kɛɛ, hawi nɩ ‑do, ɛ nɔ‑ ɛ yɛɛ 'lɩ꞊ɩ yra bʋ. Ɛ nɔ‑ mɔ bʋ lee tugbɛ a 'mʋ, ‑ɛ mɔ: «Kʋɛ kɛ 'kɩ mɔ bʋ, ꞊nɩ 'tʋʋ 'kɩ 'kui de, 'klɔ ‑mɔ 'klɔ.» Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ tugbɛ a 'mʋ, ɛ 'kʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","‑Tɛ ‑Yusu a ‑nagbopʋ 'ye dɛ a 'mʋ, ‑ɛ ‑bɩ 'waa ꞊wlɩ kɛɛ lɛ dɩakɩ, 'ʋ 'bɛti ‑Yusu, ʋ wɛn: «Dɛ‑ nu 'kɩ꞊ɩ, tugbɛ ‑bʋ, 'ɛ 'wʋ 'ʋ ti nɩ ‑do a 'ti 'yri, 'ɛ 'kʋ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, 'bʋ mɔ, 'ba kuo Nyɩsʋa ꞊wlʋ yɩ ‑tɛɛ, ɛ kɔ, 'ba 'yɛ nɩ pʋ gblɛ, a ‑wɛ 'lɩ ba nu dɛ ‑bʋ, 'n nuu tugbɛ ‑bʋ ‑mɔ nɩ. Ɛ 'yɩ dɛ nɩ ‑do a 'mʋ 'pa‑. A ‑wɛ 'lɩ ba lee dʋgba ‑bʋ nɩ ‑wɛ: ‑Hɔn mɔ ‑tɩtɛ ‑bʋ, ‑bʋ bi 'lɩ 'yru ‑mɔ, ‑ɛ ‑bɩ dɛ a 'mʋ, ɛ di mu 'lu ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","'Bʋ mɔ, 'ba yɩ Nyɩsʋa dɛ nɩ ‑hʋɛ, 'ba kuo ꞊nɛ ꞊wlʋ yɩ, ‑ɛ mɔ, ɛ di꞊e 'a mʋ 'nɩ ‑nyi, 'ɛ mɔ ꞊han‑tɩ, ɛ di 'a mɔ꞊ɔ 'nɩ ‑nyi.» ");
INSERT INTO ktj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ 'kɩ ‑Yusu mu 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli, 'ɛ ‑tʋa nyibli Nyɩsʋa a ‑tɩ a tɔɔlɛ. Bʋ nɩ 'kɩ 'lɩ tɔɔlɛ 'kwli, ‑ɛ ‑bɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ, ʋ kɔ ‑Juukʋɛ a 'blʋ a nyibli ‑bɩ 'hʋɛn‑, ʋ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, ʋ wɛn: «Nyiblo a 'dɩ ‑bɩ ‑nyi 'kɩ ‑mʋ 'klɩ, 'kɩ ‑bʋ bla ‑tɛblɩplonyibli ‑bʋ lɛ 'lɩ? Nyiblo a 'dɩ ‑bɩ ‑lee ‑mʋ ‑wɛ, ‑bʋ nu ‑tɛblɩ a pɛpɛ ‑bʋ, ‑ni 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «'Na 'mumu ‑bʋ, 'n di 'bɛti 'a mʋ dɛ. 'Bʋ mɔ, 'ba ‑hɩhɩa 'mʋ klɛ, ‑ɛ ‑bɩ 'n di 'a mʋ klɛ 'nɩ ‑hɩhɩa ‑nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","꞊Bʋ 'bɛti 'a mʋ: Nyiblo a 'dɩ ‑bɩ ‑lee la Saan, 'kɩ bʋ pʋ la nyibli 'nie 'lu lɛ 'lɩ? ꞊Bɩ Nyɩsʋa ꞊nɩɔ, ‑ʋ'ʋ‑ ‑tonyibli ꞊nɩɔ?» ‑Ɛ ‑bɩ ʋ ‑tʋa 'waa dɩɔnʋ a lɛ'bɛtilɛ, ʋ wɛn: «‑Bɩ' ‑a di 'kɩ pʋ 'lɩ? 'Bʋ mɔ, ꞊ba pʋ lɛ: Nyɩsʋa ‑lee la 'nɛ꞊ɛ, ‑ɛ ‑bɩ ɛ di ꞊hɩan ‑mɔ, ɛ 'mʋ ‑a mʋ 'bɛti ‑nɩ: ‑Tɩ ‑mʋ', Saan hlɛ la, dɛ‑ kɔ ‑tɩ 'a 'yɩ 'kɩ꞊ɩ ꞊haan‑tɩ ‑pʋ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mɔ, 'bʋ mɔ, ꞊ba pʋ lɛ: ‑Tonyibli ꞊nɩɔ, ‑ɛ ‑bɩ nyibli kɔ bʋ yɛɛ nɛ ‑a mʋ ‑tɩ, ‑ɛ nu꞊o, ‑tonyibli a pɛpɛ pʋ꞊ʋ ꞊haan‑tɩ, ‑ɛ mɔ, Saan mɔ la Nyɩsʋa a winwlɔn‑hanyɔ* ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ɛ nɔ‑ nu꞊o, 'ʋ ꞊tu ‑Yusu ꞊wɔn, ʋ wɛn: «‑A 'yɩ 'a ꞊dedede ‑yi.» ‑Ɛ ‑bɩ ‑Yusu wɛn: «'Na 'mumu, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ lee nɛ 'a mʋ ‑wɛ, nyiblo a 'dɩ ‑bɩ, ‑ɛ ‑nyi 'mʋ 'klɩ, 'kɩ ꞊bʋ nu ‑tɛblɩ a pɛpɛ ‑bʋ, 'n ni.» ");
INSERT INTO ktj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ ‑Juukʋɛ* a naanyʋ yɩ, ɛ wɛn: «'N ‑hʋɛ ꞊bʋ pʋ 'a mʋ 'ledʋ yɩ, ‑ɛ di꞊e nu, dɛ a di 'lu ‑mɔ lɛ ‑hie, 'mʋ꞊ʋ 'ye. Nyɩbɛhɩan ꞊dʋ, ɛ nɔ‑ kɔ la 'yonʋ nyɩbɛpʋ nɩ 'hʋɛn, 'ɛ lee la 'a yɩ‑hɛyu, ɛ wɛn: 'Na 'yu o, mu kɛ 'lɩ ‑ci kɩ, ꞊mʋ 'na ‑kʋan nu. ");
INSERT INTO ktj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‑Ɛ ‑bɩ ɛ ‑hɩhɩa 'a 'baɩ klɛ, ‑ɛ mɔ: 'N hɩa nɩ, 'nɩ ‑mu꞊o lɩ. Kɛɛ, muu 'ʋ ye', ‑ɛ ‑bɩ ɛ 'cɩcɩ 'a 'lulɛ‑hihie nɩ, 'ɛ mu 'lɩ 'a 'baɩ a ‑ci kɩ, 'ɛ mu ‑kʋan nu mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Dɛ nɩ ‑do 'a mʋ, nyɩbɛhɩan a 'mʋ, ɛ tɛ wɛn 'a yɩ‑hɛyu ‑mɔ, ɛ nɔ‑ ɛ tɛ 'a 'hʋɛn a 'yu ‑mʋ' ‑mɔ ‑wɛ. Ɛ nɔ‑ ‑mɔ ‑bɩ, ɛ wɛn: ‑Aa, 'na 'baɩ o, 'n di 'lɩ 'nɩ mu. Kɛɛ, ɛ 'yɩ 'lɩ ‑mu.» ");
INSERT INTO ktj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","‑Ɛ ‑bɩ ‑Yusu yɩ 'kɩ ‑Juukʋɛ a naanyʋ ‑mʋ' 'nɩ 'bɛti ‑nɩ, ɛ wɛn: «'Kɩ 'lɩ 'yonʋ nɩ 'hʋɛn a 'mʋ 'nyɩ, nyiblo a 'dʋ ‑bɩ, ‑ɛ ꞊tuu 'ʋ 'a 'baɩ 'lɩ?» ‑Ɛ ‑bɩ ʋ wɛn: «Yɩ‑hɛyu ꞊nɩɔ.» ‑Yusu yɩ 'kɩ ꞊nʋ 'nɩ ‑lee ‑nɩ, ɛ wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ, nyibli ‑mʋ', ‑ʋ di 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli pa, ʋ nʋ‑ mɔ 'blʋwli'tɩnyʋ kɔ 'lawlunʋgbɩ 'hʋɛn‑. 'A mʋ ‑mɔ ‑bɩ, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ ba pa 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","'N hlɛ꞊ɛ nɩ, ‑ɛ nu꞊o, 'a mʋ Yisraɛkʋɛ, Saan Batisɩ di 'nɛ‑ 'a mʋ 'nyɩ, 'ɛ tɔɔ nɛ 'a mʋ 'hru ‑mʋ', ‑ɛ 'sii 'ʋ yɩ, a di gba. Kɛɛ, ‑tɩ ‑mʋ', ɛ ‑hla, a 'yɩ꞊ɩ ꞊haan‑tɩ ‑pʋ. Nyibli ‑bʋ, ‑ʋ mɔ 'blʋwli'tɩnyʋ, kɔ 'lawlunʋgbɩ 'hʋɛn‑, ʋ nʋ‑ pʋ꞊ʋ ꞊haan‑tɩ, 'ʋ 'cɩcɩ 'waa nunuŋmlɩ. ‑Tɛ a 'ye dɛ a 'mʋ, a 'yɩ Saan a 'mʋ nʋa yɩ bʋ ‑pʋ, 'a 'yɩ 'aan nunuŋmlɩ 'cɩcɩ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","(‑Yusu 'tɩɛ yɩ 'lɩ ‑cɔhlʋnpinyʋ* gbagbɩ a 'mʋ kɔ ‑Juukʋɛ* a naanyʋ ‑bɩ 'hʋɛn‑ ‑mɔ ‑hlee ‑nɩ 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli.) Ɛ wɛn: «Ba pʋ 'mʋ nʋa yɩ bʋ, 'mʋ 'a mʋ 'ledʋ ‑bɩ yɩ pʋ: ‑Cikɔnyɔ ꞊dʋ, ɛ nɔ‑ ‑ci la 'a ‑ci. 'Kɩ 'lɩ ‑ci a 'mʋ 'kwli, ɛ 'dɔɔ 'lɩ 'lili ꞊dʋ. 'A 'yɔ, ɛ tʋɩ, ʋ dɛɛ ꞊nɛ rɛsɛn. 'Dʋdɔnyɔ a 'mʋ, 'a ꞊gbɛtʋ, ɛ nɔ‑ ‑ha 'a ‑ci a 'mʋ yɩ, 'ɛ 'blu 'lɩ 'hɩɔ gbɛtɛɛ 'kwli lɛ, ‑ɛ di꞊e nu, 'bʋ yɩ 'a 'yɔ nɩ 'plʋɛ, 'a 'nie 'mʋ 'lɩ 'hʋɔ a 'mʋ 'kwli lɛ bi, ɛ 'mʋ꞊ʋ nɔ ‑mɔ' nu. Ɛ nu 'hɩ‑gbɔ ‑wɛ, ‑ɛ kɔ kɩ ʋ di 'ʋ bʋ nyra, ʋ 'mʋ ‑ci 'yie ꞊tu, 'yiyrinyibli a ‑tɩ. ‑Tɛ ɛ ‑wɛ ‑kʋan a pɛpɛ a 'mʋ ‑mɔ, ‑ɛ ‑bɩ ɛ lee ‑kʋannunyibli ꞊dʋ, 'kɩ bʋ mu ‑ci a 'mʋ, 'a ‑kʋan nu, ‑ɛ di꞊e nu, 'a 'dʋdɔ‑tɛblɩ 'bʋ ‑tʋ, ʋ 'mʋ꞊ʋ 'a 'kɩbɩa ‑nyi, ‑kʋannunyibli a 'mʋ, 'waa 'mumu, ʋ 'mʋ 'waa ‑nɛ 'kɩbɩa kɔ ‑wɛ. ‑Tɛ ‑cikɔnyɔ a 'mʋ, ɛ ‑wɛ ‑kʋan a 'mʋ a yɩblɛ꞊tutulɛ ‑mɔ, ‑ɛ ‑bɩ ɛ mu 'dagba blɔblʋ. ");
INSERT INTO ktj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","‑Tɛ 'dʋdɔ‑tɛblɩ a 'cɩcɛti nyre 'ʋ, ‑ɛ ‑bɩ ‑cikɔnyɔ a 'mʋ, ɛ lee nɛ 'a lɛlenyʋ ‑bɩ, 'kɩ bʋ mu 'lɩ ‑ci'yie꞊tunyʋ ‑mɔ, ʋ 'mʋ ꞊nʋ 'cɩcɛ‑tɛblɩ ‑mʋ', ‑ɛ blɛɛ ‑cikɔnyɔ yɩ ‑nyi, ʋ 'mʋ ꞊nɛ꞊ɛ yɩ ya. ");
INSERT INTO ktj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","‑Tɛ lɛlenyʋ a 'mʋ, ʋ nyre 'lɩ, ‑ɛ ‑bɩ ‑ci'yie꞊tunyʋ a 'mʋ, ʋ klɔ ꞊nʋ nɩ, 'ʋ bi lɛlenyɔ ‑bɩ ‑tɛɛ, 'tɩ‑ 'ʋ 'la 'a 'yɛɛ ‑bɩ, 'ʋ pʋ ta a lɛlenyɔ 'hɩ ‑mɔ lɛ, 'ʋ 'la꞊a. ");
INSERT INTO ktj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","‑Tɛ ‑cikɔnyɔ 'wɩn dɛ a 'mʋ, ‑ɛ mu 'lu ‑mɔ, ‑ɛ ‑bɩ ɛ lee nɛ 'a lɛlenyʋ ‑bɩ de. Nyibli a 'mʋ, ʋ nʋ‑ ‑hʋ, 'ʋ ‑hi 'ʋ yɩ‑hɛnyibli ‑mʋ', ɛ lee mɔ. Kɛɛ, dɛ nɩ ‑do, ‑ci'yie꞊tunyʋ ‑mʋ', ʋ nu yɩ‑hɛnyibli ‑mʋ' ‑mɔ, ɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ ʋ nu 'waa dɛ ‑bɩ ‑bʋ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","‑Tɛ lɛlenyʋ a 'mʋ, ʋ ‑hi, ‑ɛ ‑bɩ ɛ lee nɛ 'a ꞊gbɛtʋ a 'yu, 'kɩ bʋ mu 'lɩ ꞊nʋ ‑mɔ, ‑ɛ nu꞊o, 'a ꞊wlʋ wɛn 'nɩ: ‑Tɛ ɛ mɔ 'na 'yu, ʋ di kɔ 'a 'ʋ꞊tuulɛ. ");
INSERT INTO ktj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kɛɛ, ‑tɛ ‑ci'yie꞊tunyʋ ‑mʋ', ʋ 'ye 'yu a 'mʋ, ‑ɛ yɩ 'lɩ di, ‑ɛ ‑bɩ kɛ‑ ʋ pɩ, 'kɩ 'lɩ 'waa dɩɔnʋ 'nyɩ: Nyiblo ‑bʋ, ‑ɛ di ‑ci ‑bʋ kɔ ‑nyrɔwɔ ꞊dʋ, ɛ nɔ‑ yɩ 'lɩ di. 'A ‑tɩ, ‑ba 'la꞊a, ‑a 'mʋ ‑ci ‑bʋ kɔ, ");
INSERT INTO ktj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","'ʋ klɔ꞊ɔ, 'ʋ 'hrɔɔ 'lɩ꞊ɩ ‑ci 'kwli, 'ʋ 'la꞊a.» ");
INSERT INTO ktj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","‑Ɛ ‑bɩ ‑Yusu wɛn 'nɩ: «'A mʋ 'n yɩ 'bɛti ‑nɩ, nyiblo ‑bʋ, ‑ɛ kɔ ‑ci a 'mʋ, 'bʋ ‑di, dɛ a 'dɩ ‑bɩ ɛ di ‑ci'yie꞊tunyʋ a 'mʋ ‑mɔ nu 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","‑Ɛ ‑bɩ ʋ ꞊tu꞊o ꞊wɔn, ʋ wɛn: «'Crɛkɔnyibli ‑mʋ', ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ yru 'waa nyaɩ, ɛ 'mʋ ꞊nʋ 'la, 'tɩ‑ ɛ 'mʋ 'lɩ ‑ci a 'mʋ 'lɩ ‑ha, ɛ 'mʋ꞊ʋ ‑ci'yie꞊tunyʋ yrayrɩ ‑bɩ ‑nyi, 'dʋdɔ‑tɛblɩ a 'cɩcɛti 'bʋ nyre 'ʋ, ʋ 'mʋ꞊ʋ 'a 'kɩbɩa ‑nyi.» ");
INSERT INTO ktj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ, ɛ wɛn: «‑Tɩ ‑bʋ, ʋ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, 'n pʋ꞊ʋ ꞊haan‑tɩ, a ‑hre꞊e nɩ. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: 'Katuo ‑mʋ', 'kayupʋnyʋ 'yɩ ‑hʋa bʋ nuu ‑kʋan 'yri, ʋ pʋ 'kɩbɩa kɩ, ɛ nɔ‑ ‑hɛ 'kayu a 'mʋ a 'katuo gbagbʋ. Kʋkɔnyɔ Nyɩsʋa, ɛ nɔ‑ nu꞊o, 'ɛ ‑hɛ 'katuo gbagbʋ, 'tɩ‑ 'ɛ nɔɔ 'yie klɛ, 'kɩ 'ʋ ‑a mʋ ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ de ɛ wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, 'a mʋ Nyɩsʋa a dakɔ ‑mʋ', Nyɩsʋa kɔɔ win kɩ, ꞊haandɛ ‑mʋ', ɛ ni 'a mʋ 'yi ꞊hlɔn lɛ, ‑ɛ ‑hʋɛn 'lɩ 'aan win a kɩkɔɔlɛ 'kwli, ɛ di 'a mɔ꞊ɔ ‑jɩ' 'nɩ ‑ha, ɛ 'mʋ꞊ʋ dakɔ ‑bɩ ‑nyi, ‑ʋ di 'ʋ Nyɩsʋa 'ʋ ꞊tuu ‑nɩ.  ");
INSERT INTO ktj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nyiblo 'bʋ bi 'ʋ 'katuo a 'mʋ kɩ, ɛ kɔ bʋ ‑yɩyrɛ lɛ, mɔ, 'katuo a 'mʋ, 'bʋ bi꞊e kɩ, ɛ di wʋwa꞊a lɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nyɩsʋa a ‑cɔhlʋnpinyʋ gbagbɩ kɔ Falisi꞊tumu* a nyibli ‑mʋ', ‑ʋ nɩ 'ʋ ‑tuo a 'mʋ kɩ, ʋ 'wɩn 'ledʋɩ a 'mʋ nɩ, 'ʋ yru꞊o, ‑ɛ mɔ, ʋ nʋ‑ ‑Yusu ꞊hɛn 'nyrɛ. ");
INSERT INTO ktj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","‑Tɛ ʋ yru dɛ a 'mʋ, ‑ɛ ‑bɩ ʋ ꞊mʋɛ 'hru lɛ, 'kɩ bʋ klɔ꞊ɔ, ʋ 'mʋ꞊ʋ 'la. Kɛɛ, hʋannʋ ni ꞊nʋ nɩ, 'kɩ bʋ klɔ꞊ɔ, ‑ɛ nu꞊o, ʋ yi꞊e nɩ, ‑ɛ mɔ, nyibli ‑hʋɔhʋɩ dɛɛ ‑Yusu Nyɩsʋa a winwlɔn‑hanyɔ*. ");
INSERT INTO ktj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","‑Ɛ ‑bɩ 'kɩ ‑Yusu nɛɛ 'lɩ 'ledʋɩ 'kwli de, 'ɛ ‑hɩhɩɛ ‑Juukʋɛ* a naanyʋ, ‑ʋ 'bɛti wɛn꞊ɛ klɛ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Nyɩsʋa 'bʋ kɔɔ nyibli win kɩ, dɛ ɛ 'wɩ yɩ, ɛ nɔ‑ ‑bʋ: Ɛ kɔ la bodɩɔ ꞊dʋ. Ɛ nɔ‑ lee nɛ 'a ‑kʋannunyibli, 'kɩ bʋ pi a 'yu a 'blɩpadiidɛ, ");
INSERT INTO ktj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","'ɛ da nyibli ‑bɩ dididɛ a 'mʋ kɩ. ‑Tɛ dɛditi nyre 'ʋ, ‑ɛ ‑bɩ ɛ lee nɛ 'a ‑kʋannunyibli nɩ, ɛ wɛn: Ba mu, ba da nyibli ‑nɩ wɛn. ‑Tɛ ʋ ‑mu, ʋ yɛɛ 'ʋ ꞊nʋ bʋ, 'ʋ lee ꞊nʋ, ‑ɛ ‑bɩ ʋ wɛn: ‑A hɩa nɩ, ‑a 'nɩ ‑di꞊e 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","‑Ɛ ‑bɩ ɛ lee nɛ 'a ‑kʋannunyibli ‑bɩ de, ɛ wɛn: Ba mu, ba lee nyibli ‑mʋ', 'n da wɛn, 'na didi‑tɛblɩ ‑wɛ ‑mɔ, 'n 'la 'na blo kɔ 'na nʋnʋabloyonʋ 'hʋɛn‑ nɩ. ‑Tɛblɩ a pɛpɛ ‑wɛ ‑mɔ. 'A ‑tɩ, bʋ di 'lɩ, ʋ 'mʋ 'blɩpadiidɛ a 'mʋ di. ");
INSERT INTO ktj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kɛɛ, nyibli a 'mʋ, ʋ ‑da, ‑sɔgblɔlɛ a ‑tɩ, 'ʋ 'yɩ ‑di, 'ʋ mu 'waa ‑kʋan ‑mɔ lɛ, nyiblo ‑bɩ nɩ 'ʋ, 'ɛ mu 'lɩ 'a ‑ci kɩ, ‑ɛ ‑bɩ nɩ 'ʋ, 'ɛ mu plo mɔ, ");
INSERT INTO ktj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","‑ʋ ‑bɩ nɩ 'ʋ, ‑kʋannunyibli a 'mʋ, ‑ʋ mu ꞊nʋ da mɔ, 'ʋ klɔ ꞊nʋ, 'ʋ bi ꞊nʋ ‑bibi, 'ʋ 'lɩla ꞊nʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","‑Tɛ bodɩɔ a 'mʋ, ɛ 'wɩn ‑tɩ a 'mʋ, ‑ɛ ‑bɩ ɛ bi yrʋ', 'ɛ lee nɛ 'a 'sɛyo, 'kɩ bʋ 'la 'crɛkɔnyibli a 'mʋ, kɔ, bʋ pʋ 'waa 'dɩɔ 'tɔ. ");
INSERT INTO ktj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","‑Ɛ ‑bɩ kɛ‑ ɛ pʋ 'a ‑kʋannunyibli yɩ de: 'Blɩpadiidɛ ‑wɛ ‑mɔ, kɛɛ, dididɛ a 'mʋ, ɛ 'yɩ nyibli ‑bʋ, 'n da wɛn yɩ ‑blɛɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ba mu 'lɩ ‑tɩtɛ ‑mʋ', nyibli ‑hʋʋ 'lɩ, nyibli a pɛpɛ ‑mʋ', a di 'lɩ bʋ ‑yɛɛ ‑nɩ, ba da ꞊nʋ, bʋ di 'blɩpadiidɛ kɩ. ");
INSERT INTO ktj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ɛ nɔ‑ mɔ ‑kʋannunyibli a 'mʋ bʋ mu, bʋ 'kukue nyibli a pɛpɛ ‑mʋ' lɛ, ʋ yɛɛ 'ʋ bʋ, ‑ʋ mɔ nyibli ‑mʋ', ‑ʋ ꞊tui 'ʋ Nyɩsʋa, kɔ nyibli ‑mʋ', ‑ʋ 'yɛ nɩ ꞊tuu 'ʋ Nyɩsʋa. (Nyibli a pɛpɛ ‑mʋ', ʋ ‑da, ‑ʋ ‑di, ʋ ‑nyi ꞊nʋ 'blɩpawlawlʋ, ʋ 'mʋ꞊ʋ pʋ.) Nyiblidʋ a 'mʋ, ʋ nʋ‑ ‑wɛ ti kɩ. Ɛ nu꞊o nɩ, 'blɩpakayu ‑mʋ', 'ɛ 'yii 'lɩ, 'kɩ 'ʋ nyibli ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","‑Ɛ ‑bɩ bodɩɔ pa nɩ, ɛ 'mʋ nyibli ‑mʋ', ʋ ‑da 'ye. ‑Tɛ ɛ pa 'kɩ, ‑ɛ ‑bɩ ɛ 'ye꞊e nɩ, ‑ɛ mɔ, 'kɩ 'lɩ nyibli a 'mʋ, ʋ ‑da 'nyɩ, nyiblo nɩ ‑do nɩ 'lɩ, 'ɛ 'yɩ 'blɩpawlawlʋ ‑pʋ. ");
INSERT INTO ktj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ꞊ɩ yɩ: 'Bɩhɩan o, ‑mɔ ‑bʋ, ‑ɛ 'yɩ 'blɩpawlawlʋ ‑pʋ, ꞊yɩ yɩ ‑blɛɛ ‑nɩ, ‑bʋ pa 'nɛ‑. Kɛɛ, ‑tɩ bʋ di꞊e klɛ ‑hɩhɩa ‑nɩ, ɛ 'yɩ꞊ɩ ‑yi. ");
INSERT INTO ktj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ɛ nɔ‑ mɔ bodɩɔ bʋ lee nɛ 'a ‑kʋannunyibli, ɛ wɛn: Ba mʋa nɛ 'a bʋɩ kɔ 'a dabʋɩ. Ba pʋ 'lɩ꞊ɩ ‑patʋ', 'kɩ 'lɩ halɔ 'nyɩ. 'Kɩ ɛ di 'lɩ ꞊hien ‑wee ‑nɩ, kɔ, 'kɩ ɛ di 'ʋ yrʋ ‑pʋʋ ‑nɩ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ de, ɛ wɛn: «Nyɩsʋa dɛ nyibli ‑hʋɔhʋɩ, 'kɩ bʋ wɛn, bʋ kɔɔ ꞊nʋ win kɩ, kɛɛ, nyibli nɩ ‑do ‑mʋ', ‑ʋ wɛɛn dɛ a 'mʋ kɩ, ʋ nʋ‑ ɛ ‑ha 'lɩ, 'kɩ ɛ 'mʋ ꞊nʋ win kɩ ‑kɔɔ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ Falisi꞊tumu* a nyibli, ʋ mu ‑gbolugbo kɔ mɔ, ‑ɛ di꞊e nu, ʋ 'mʋ 'hru lɛ ꞊mʋɔ, ‑tɛ ʋ di ‑Yusu a lɛ'bɛtilɛ nu, 'tɩ‑ a ꞊wɔn꞊tutuo 'kwli, ʋ 'mʋ 'lɩ ‑naa ‑nɩ, ʋ 'mʋ꞊ʋ ‑tɩ ‑yɛɛ ‑nɩ, ʋ 'mʋ꞊ʋ klɔ. ");
INSERT INTO ktj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","‑Tɛ ʋ ‑yra dɛ a 'mʋ, ‑ɛ ‑bɩ ʋ tɛ 'waa ‑nagbopʋ ‑bɩ bʋ, kɔ nyibli ‑bɩ 'hʋɛn‑, ‑ʋ mɔ 'kɩɩn Helɔdɩ a ꞊tumu a nyibli, 'kɩ bʋ mu 'lɩ ‑Yusu 'hʋɩ. ‑Tɛ ʋ nyre 'lɩ꞊ɩ ‑mɔ, ‑ɛ ‑bɩ ʋ wɛn: «Tɔɔnyɔ o, ‑a yi꞊e nɩ, ‑ɛ mɔ, ‑hlɛ ‑tɩ a ‑tɛɛ, ꞊nɩ tʋɛ ‑tɩ a ‑tɛɛ, 'kɩ 'ʋ dɛ ‑mʋ', Nyɩsʋa ‑hʋɛ ‑a mʋ a ‑ta'. 'Bʋ mɔ, ꞊nɩ yɩ꞊ɩ nɩ hlɛ, ꞊nɩ ‑pie꞊e hʋannʋ, 'kɩ 'ʋ ‑tonyiblo a 'lulɛ‑hihie a ‑ta', 'ye ꞊bɩɩ ɛ mɔ nyiblo gbagbʋ. ");
INSERT INTO ktj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","'A ‑tɩ o, lee nɛ ‑a mʋ ‑na 'lulɛ‑hihie, 'kɩ 'ʋ ‑tɩ ‑bʋ, ‑a di ‑mʋ 'bɛti ‑nɩ kɩ: ꞊Bɩ Nyɩsʋa a tete wɛn 'nɩ, ‑ba ‑ha 'blʋwli, ‑ba ‑nyi꞊e Romakʋɛ a 'kɩɩn gbagbʋ, ‑ʋ'ʋ‑, ‑a 'yɩ yɩ ‑blɛɛ ‑nɩ, ‑ba ‑nyi ꞊nɛ꞊ɛ?» ");
INSERT INTO ktj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kɛɛ, ‑Yusu yi 'waa 'lulɛ‑hihie ‑hʋan nɩ. Ɛ nɔ‑ kɔ ‑tɩ 'ɛ yɩ ꞊nʋ ‑lee ‑nɩ, ɛ wɛn: «Dɛ‑ kɔ 'mɔ a yɩ 'bɛti ‑nɩ, 'a yɩ 'ʋ 'mʋ lɛ ꞊tɛɛ ‑nɩ, 'a mʋ ‑bʋ, ‑ʋ nɛɛ 'li nɩ 'hʋɛn 'lɩ? ꞊Bɩ a 'mʋ꞊ʋ 'ye, 'bʋ mɔ, 'nɩ yɩ Romakʋɛ a 'kɩɩn gbagbʋ a ‑tɩ lɛ nɩ ‑hɛɛ ‑nɩ, ɛ kɔ Nyɩsʋa a ‑tɩ 'hʋɛn‑, a 'mʋ 'mʋ ‑tɩ ‑yɛɛ ‑nɩ? ");
INSERT INTO ktj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ba tɔɔ 'mʋ 'wli a 'mʋ, a ni, 'a yɩ 'blʋwli 'pɛɛ ‑nɩ,» 'a 'wliyɔkɔ a 'yɛɛ nɩ ‑do yɩ, 'ʋ ya꞊a 'a 'yɛɛ nɩ ‑do yɩ. ");
INSERT INTO ktj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","‑Ɛ ‑bɩ ɛ wɛn: «Nyiblo a 'dɩ ‑bɩ, ‑ɛ kɔ yigbakla ‑nɩ 'ʋ꞊ʋ kɩ 'lɩ? Nyiblo a 'dɩ ‑bɩ, ‑ɛ kɔ 'nyrɛ ʋ 'crɩɩ 'ʋ ‑wɛ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","‑Ɛ ‑bɩ ʋ wɛn: «Romakʋɛ a 'kɩɩn gbagbʋ ꞊nɩɔ.» ‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'kɩ ꞊nʋ yɩ, ɛ wɛn: «'A ‑tɩ o, dɛ ‑bʋ, ‑ɛ blɛɛ 'kɩɩn gbagbʋ yɩ, ba ‑nyi ꞊nɛ꞊ɛ, ɛ kɔ, dɛ ‑bʋ, ‑ɛ blɛɛ Nyɩsʋa yɩ, ba ‑nyi ꞊nɛ꞊ɛ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","‑Tɛ ʋ 'wɩn ‑tɩ a 'mʋ, ‑Yusu ‑hɩhɩa ꞊nʋ klɛ, ɛ kɛɛ 'waa ꞊wlɩ lɛ. Ɛ nɔ‑ mɔ bʋ hie 'ʋ꞊ʋ bʋ, bʋ mu. ");
INSERT INTO ktj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","'Kɩ 'lɩ Jrusrɛdɩɔ 'kwli, ɛ kɔ la ꞊tumu ꞊dʋ. 'A 'nyrɛ mɔ Sadusɩ꞊tumu*. Ʋ nʋ‑ hlɛ꞊ɛ, ‑ɛ mɔ, 'bʋ mɔ, nyiblo 'bʋ 'kʋ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ, bʋ 'hrɩ 'klɔ, 'kɩ 'lɩ Nyɩsʋa yɩ. Ʋ nʋ‑ kɔ nyibli ‑mu 'ʋ ‑Yusu 'hʋɩ, 'kɩ 'lɩ ‑nyrɔwɔ nɩ ‑do a 'mʋ 'kwli, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ lɛ 'bɛti ‑nɩ. ‑Tɛ ʋ nyre 'kɩ 'ʋ꞊ʋ 'hʋɩ, ‑ɛ ‑bɩ ʋ wɛn: ");
INSERT INTO ktj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Tɔɔnyɔ o, 'ye tete ‑bɩ, Nyɩsʋa a winwlɔn‑hanyɔ Moise 'crɩ la, ɛ hie la ‑a mʋ lɛ, ɛ nɔ‑ ‑bʋ: Nyɩbɛyugbe 'bʋ kɔ nʋgba, 'tɩ‑ muu 'lɩ ye', nyɩbɛyugbe a 'mʋ, 'bʋ 'kʋ, 'bʋ 'yɩ 'ʋ 'yonʋ bʋ ‑hie, ‑ɛ ‑bɩ nyɩbɛyugbe a 'mʋ, ‑ɛ 'kʋ, 'bʋ kɔ 'dɩayɩ nyɩbɛhɩan, ɛ nɔ‑ blɛɛ yɩ, ‑bʋ kɔ 'a nʋgba a 'mʋ, ɛ kɔ꞊ɔ 'hʋɛn‑, ʋ 'mʋ 'yonʋ kɔ, 'kɩ 'ʋ 'a 'dɩayɩ ‑mʋ', ‑ɛ 'kʋ a ‑ta'. Kɛ‑ Moise a tete pɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kɛ‑ ʋ pɩ de, ‑ɛ mɔ: «Ɛ kɔ la 'dɩayɩ nyɩbɛpʋ nɩ ꞊hlon'hʋɛn, 'kɩ 'nɛ‑ ‑a mʋ 'nyɩ, 'waa yɩ‑hɛnyiblo, ɛ nɔ‑ kɔ nʋgba, nyɩbɛhɩan a 'mʋ, 'ɛ 'yɩ 'ʋ 'yu bʋ ‑hie, 'ɛ 'kʋ, 'ɛ ‑hie 'a nʋgba 'a 'dɩayɩnʋ a 'hʋɛn a nyiblo lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Dɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ nu 'hʋɛn a nyiblo, kɔ ta a nyiblo 'hʋɛn‑, 'ɛ mu 'lu ‑mɔ ‑mumu, 'ɛ yɛ ꞊hlon'hʋɛn a nyiblo kɩ. ");
INSERT INTO ktj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","‑Tɛ 'waa pɛpɛ, ʋ 'kʋ 'kɩ, ‑ɛ ‑bɩ nʋgba a 'mʋ, ɛ 'kʋ nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","‑Tɩ ‑a di 'bɛti mɔ, ‑a ‑hʋɛ ‑bʋ ‑hɩhɩa ‑a mʋ klɛ, ɛ nɔ‑ ‑bʋ: ‑Nyrɔwɔ ‑kɔ 'kwli nyibli di 'lɩ 'kʋkʋnyibli 'nyɩ ‑hɔn, ʋ di 'klɔ 'hrɩ, 'kɩ 'lɩ Nyɩsʋa yɩ, nyiblo a 'dɩ ‑bɩ, 'kɩ 'lɩ nyɩbɛpʋ nɩ ꞊hlon'hʋɛn ‑mʋ' 'nyɩ, ‑ɛ di 'kɩ nʋgba a 'mʋ kɔ 'lɩ, ‑ɛ nu꞊o, ‑tɛ ʋ nɩ la 'nɛ‑ ‑tʋtʋ kɩ, nyɩbɛpʋ a pɛpɛ a 'mʋ, ʋ kɔ la꞊a nɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «A kɛ nɩ, ‑ɛ nu꞊o, a 'yɩ Nyɩsʋacrɩɛn ‑yi, 'a 'yɩ꞊ɩ ‑yi ‑wɛ, ‑ɛ mɔ, Nyɩsʋa nɩ 'klɩ kɩ. ");
INSERT INTO ktj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ti ‑mʋ', ‑ɛ kɔ 'yri nyibli di 'lɩ 'kʋkʋnyibli 'nyɩ ‑hɔn, ʋ di 'klɔ 'hrɩ, 'kɩ 'lɩ Nyɩsʋa yɩ, nyɩbɛpʋ kɔ nʋgbɩ 'hʋɛn‑, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ kʋkɔ ‑nɩ. Kɛɛ, ‑tɛ Nyɩsʋa a lɛlenyʋ nɩ 'mʋ, kɛ‑ ʋ di 'mʋ nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","'Ya 'ʋ 'lu de, dɛ ‑bʋ, ‑ɛ mɔ nyibli bʋ ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ, bʋ 'hrɩ 'klɔ, 'n yi꞊e nɩ, ‑ɛ mɔ, ‑tɩ ‑mʋ', Nyɩsʋa ‑hla, 'kɩ 'ʋ꞊ʋ kɩ, a ‑hre꞊e nɩ, 'kɩ 'lɩ 'a 'crɩɛn 'kwli. Kɛ‑ Nyɩsʋa pʋ la: ");
INSERT INTO ktj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","'Mɔ ‑mɔ Nyɩsʋa ‑bʋ, Abrahamʋ dɛ, ɛ kɔ Yisakɩ, kɔ Sakɔbʋ 'hʋɛn‑. Ɛ 'wɩ yɩ, ti ‑mʋ', ‑ɛ kɔ 'yri Nyɩsʋa yɩ la 'lɩ Moise ‑mɔ ‑hlee ‑nɩ, Abrahamʋ, kɔ Yisakɩ, kɔ Sakɔbʋ 'hʋɛn‑, ʋ 'kʋ la nɩ see la. Kɛɛ, ‑a yi꞊e nɩ, ‑ɛ mɔ, ɛ 'yɩ 'kʋkʋnyibli 'pa‑, ʋ 'nɩ ‑da꞊a lɩ Nyɩsʋa, kɛɛ, 'klɔnɩnyibli, ʋ nʋ‑ dɛ꞊ɛ. ('A ‑tɩ, 'ba pʋ lɛ, ‑ɛ mɔ, nyiblo 'bʋ 'kʋ, ɛ 'nɩ 'hrɩ꞊ɩ 'klɔ, 'kɩ 'lɩ Nyɩsʋa yɩ, ɛ 'yɩ ꞊han‑tɩ 'pa‑.)» Kɛ‑ ‑Yusu ‑pʋ. ");
INSERT INTO ktj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nyibli a pɛpɛ ‑mʋ', ‑ʋ pʋ ‑Yusu nʋa yɩ bʋ, 'waa ꞊wlɩ kɛɛ lɛ, tɔɔlɛ a 'mʋ, 'a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","‑Tɛ Falisi꞊tumu* a nyibli 'wɩn, ‑ɛ mɔ, ‑Yusu ꞊tu Sadusɩ꞊tumu* a nyibli ꞊wɔn, 'ɛ nu꞊o, 'kɩ ʋ 'yɩ 'kɩ ‑tɩ ꞊dʋ 'ye, bʋ hla. Ɛ nɔ ‑mɔ bʋ 'kukue lɛ, bʋ mu 'ʋ ‑Yusu 'hʋɩ. ");
INSERT INTO ktj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","'Kɩ 'lɩ ꞊nʋ 'nyɩ, tetetɔɔnyɔ ꞊dʋ nɩ 'lɩ. Ɛ nɔ‑ 'bɛti ‑Yusu, ‑ɛ di꞊e nu, ɛ 'mʋ 'ʋ꞊ʋ lɛ ꞊tɛɛ ‑nɩ, ɛ 'mʋ ka, 'kɩ 'ʋ Nyɩsʋa ye', ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Tɔɔnyɔ o, tete a pɛpɛ ‑bʋ, Nyɩsʋa ‑nyi ‑a mʋ, 'a dɛ a 'dɩ ‑bɩ ‑mɔ tete gbagbʋ, ‑ɛ ‑hi 'ʋ 'a 'bio 'ʋ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","‑Ɛ ‑bɩ ‑Yusu wɛn: «‑Blɛɛ yɩ ‑bʋ nʋɛ ‑na Kʋkɔnyɔ Nyɩsʋa, 'kɩ 'lɩ ‑na ꞊wlʋ a pɛpɛ kɩ, kɔ, 'kɩ 'lɩ ‑na 'lulɛ‑hihie a pɛpɛ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ɛ nɔ‑ mɔ Nyɩsʋa a tete gbagbʋ, 'kɩ 'lɩ tete a pɛpɛ 'nyɩ. Ɛ nɔ‑ nɩ 'ʋ tete a pɛpɛ 'lu yɩ. ");
INSERT INTO ktj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Tete, ‑ɛ blɛ 'ʋ꞊ʋ ke', ‑ɛ mɔ Nyɩsʋa a tete gbagbʋ ‑wɛ, ɛ nɔ‑ mɔ: ‑Blɛɛ yɩ ‑bʋ nʋɛ ‑na 'bɩhɩan ‑tonyiblo, ꞊wɩ yɩ ‑tɛ ‑nu ‑dɩɔnʋ a nʋɛlɛ. ");
INSERT INTO ktj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tete nɩ 'hʋɛn a 'mʋ, ʋ nʋ‑ kɔ 'kwli Moise a tete a pɛpɛ ‑hʋɛn 'lɩ ‑wlu, ʋ kɔ Nyɩsʋa a winwlɔn‑hanyʋ* a tɔɔlɛ 'hʋɛn‑.» ");
INSERT INTO ktj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ Falisi꞊tumu* a nyibli 'kukue lɛ, ‑Yusu 'ɛ yɩ ꞊nʋ lɛ 'bɛti ‑nɩ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Dɛ a 'dɩ ‑bɩ a yɩ 'lu ‑mɔ lɛ ‑hie, 'kɩ 'ʋ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya a ‑ta' 'lɩ? Nyɔ‑ mɔ 'a 'baɩ gbagbʋ 'lɩ?» ‑Ɛ ‑bɩ ʋ wɛn: «Wanyɔ a 'mʋ, ɛ nɔ‑ mɔ bodɩɔ Dafidɩ a 'yonʋ a 'Yu.» ");
INSERT INTO ktj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","‑Ɛ ‑bɩ ɛ 'bɛti ꞊nʋ nɩ, ɛ wɛn: «'Bʋ nɩ 'mʋ lɛ, ‑bɩ' Nyɩsʋa a ‑Hihiu* ‑nu, Dafidɩ 'ɛ daa Wanyɔ a 'mʋ 'a Kʋkɔnyɔ, 'ɛ hla꞊a, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ: ");
INSERT INTO ktj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Kʋkɔnyɔ Nyɩsʋa lee 'na Kʋkɔnyɔ nɩ, ‑ɛ mɔ: Nɩ mɔ 'na diidɛkɩbɩa kɩ bʋ, ‑kɔ 'mʋ 'hʋɛn‑, ‑a 'mʋ nyibli win kɩ ‑kɔɔ ‑nɩ, ɛ 'mʋ꞊ʋ gba ‑gbagba, 'mʋ꞊ʋ nu, ꞊mʋ ‑na yraanyibli bʋɩ 'lu blɛ ꞊tu.» ");
INSERT INTO ktj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","‑Ɛ ‑bɩ ‑Yusu wɛn 'nɩ de: «‑Tɛ Dafidɩ a ꞊gbɛtʋ, ɛ dɛɛ Wanyɔ a 'mʋ, 'a Kʋkɔnyɔ, ‑bɩ' Wanyɔ a 'mʋ, ɛ ‑wɛ 'lɩ bʋ nu 'kɩ Dafidɩ a 'Yu a pʋpa 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, ɛ 'yɩ nyiblo ꞊dʋ ‑kɔ, 'kɩ 'lɩ ꞊nʋ 'nyɩ, ‑ɛ ‑wɛ 'lɩ bʋ ‑hɩhɩa ‑Yusu klɛ. Kʋɛ 'ʋ ‑nyrɔwɔ a 'mʋ 'yie bʋ, nyibli yɩ pie hʋannʋ, 'kɩ bʋ 'bɛti꞊e ‑tɩ ꞊dʋ. ");
INSERT INTO ktj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ kɛ‑ ‑Yusu pɩ nyibli ‑mʋ', kɔ 'a ‑nagbopʋ 'hʋɛn‑ yɩ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Nyɩsʋa a tetetɔɔnyʋ kɔ Falisi꞊tumu* a nyibli 'hʋɛn‑, 'waa ‑kʋan, ɛ nɔ‑ mɔ bʋ ‑hɩhɩa nyibli tete ‑mʋ', Nyɩsʋa ‑nyi la Moise klɛ. ");
INSERT INTO ktj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","'A ‑tɩ, ‑tɩ a pɛpɛ ‑mʋ', ʋ di 'a mʋ ‑lee ‑nɩ, ba nu꞊o, kɔ, ba ꞊tuu 'ʋ꞊ʋ 'ʋ. Kɛɛ, ‑tɛblɩ ‑mʋ', ʋ ni, a 'nɩ 'nuo 'lɩ꞊ɩ, ‑ɛ nu꞊o, ‑tɩ ‑mʋ', ʋ tʋɛ nyibli, 'waa 'mumu, ʋ 'nɩ ‑nu꞊o lɩ꞊ɩ. ");
INSERT INTO ktj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ʋ nɩ 'ʋ nyibli ke', 'kɩ bʋ ꞊tuu 'ʋ tete a gblegble 'ʋ, ‑ʋ kɔ 'ʋ꞊tuulɛ ‑kla 'mʋ, ‑wɛn 'bɛnɩ, kɛɛ, ʋ 'nɩ ‑hɛɛ꞊ɛ lɩ ꞊nʋ dɛ gbe, 'kɩ bʋ ꞊tuu 'ʋ tete a 'mʋ 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","'Waa ‑tɛblɩ a pɛpɛ, ʋ ni, ʋ ni꞊e nɩ, ‑ɛ di꞊e nu, nyibli 'mʋ ꞊nʋ 'yie kɩ bʋ 'nɛɛ ‑nɩ, kɔ, ʋ 'mʋ ꞊nʋ 'nyrɛ lɛ pʋ. Ba 'ye 'waa dukwli gbi ‑mʋ', ‑ʋ kɔ 'kwli, ʋ pɩ 'lɩ Nyɩsʋacrɩɩn lɛ, 'a dɛ ‑bʋ, ʋ 'mʋɛ yɩ bʋ, ɛ kɔ 'a dɛ ‑bʋ, ʋ pɩ 'lɩ dabʋ lɛ. Dukwli a 'mʋ, 'waa ‑nɛ 'bʋa nɩ dɩakɩ. 'Tɩ‑, 'lili ‑mʋ', ʋ ni, 'ʋ mʋɛ 'waa wlawlɩ a ꞊hlɔndɛ blɛ, ‑ɛ mɔ Nyɩsʋa a 'ʋ꞊tuulɛ a yruulɛ, ʋ ni꞊e nɩ, 'waa ‑nɛ, 'ɛ ‑hlɔ dɩakɩ. Ʋ ni ‑tɛblɩ a 'mʋ nɩ, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ nyibli ‑tɔɔ ‑nɩ, ‑ɛ mɔ, ʋ mɔ ‑tɛɛ a Nyɩsʋa a nyibli ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ʋ nʋɛ ꞊nɛ nɩ, 'bʋ da ꞊nʋ dididɛ ‑mɔ, bʋ nɩ 'lɩ ye' bʋ, ‑ɛ di꞊e nu, nyibli 'mʋ ꞊nʋ 'ye. Dɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ ʋ ni, 'bʋ mɔ, 'bʋ mu 'lɩ Nyɩsʋa a 'kayu bʋ. ");
INSERT INTO ktj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","'Bʋ mɔ, 'bʋ mu 'ʋ ‑tɩtɛ ‑mʋ', nyibli ‑hʋʋ 'ʋ, ʋ nʋɛ ꞊nɛ nɩ, 'kɩ nyibli bʋ pʋ ꞊nʋ 'wio blɛ, 'kɩ 'ʋ 'waa 'ʋ꞊tuulɛ a ‑ta'. Ʋ nʋɛ ꞊nɛ nɩ ‑wɛ, 'kɩ nyibli bʋ daa ꞊nʋ Tɔɔnyʋ. ");
INSERT INTO ktj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kɛɛ, 'a mʋ ‑mɔ ‑bɩ, a 'nɩ 'nuo 'lɩ꞊ɩ, nyibli 'nɩ 'daa 'lɩ 'a mʋ tɔɔnyʋ, ‑ɛ nu꞊o, a kɔ Tɔɔnyɔ nɩ ‑do. 'Aan pɛpɛ, a mɔ dɛ nɩ ‑do, ꞊wɩ yɩ 'dɩayɩnʋ. ");
INSERT INTO ktj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","'Kɩ 'nɛ‑ ‑tʋtʋ kɩ, a 'nɩ 'daa 'lɩ nyiblo ꞊dʋ 'aan 'Baɩ, ‑ɛ nu꞊o, a kɔ 'Baɩ nɩ ‑do, 'ɛ nɩ 'lɩ yakɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","A 'nɩ 'nuo 'lɩ꞊ɩ, ʋ 'nɩ 'daa 'lɩ 'a mʋ Nyiblo gbagbʋ, ‑ɛ nu꞊o, a kɔ Nyiblo gbagbʋ nɩ ‑do, ɛ nɔ‑ nɛɛ nɛ 'a mʋ. 'Mɔ ‑mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya. ");
INSERT INTO ktj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","'A ‑tɩ, 'kɩ 'lɩ 'a mʋ 'nyɩ, nyiblo ‑mʋ', ‑ɛ mɔ 'aan nyiblo gbagbʋ, ɛ blɛɛ yɩ bʋ mɔ 'aan ‑hɛɛnyɔ. ");
INSERT INTO ktj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nyiblo ‑mʋ', ‑ɛ 'yɛɛ 'lɩ 'a dɩɔnʋ, Nyɩsʋa di 'lɩ꞊ɩ 'nɩ ꞊tɩɔ ‑nɩ, kɔ, nyiblo ‑mʋ', ‑ɛ ꞊tɩʋɛ 'lɩ 'a dɩɔnʋ, Nyɩsʋa di 'lɩ꞊ɩ 'nɩ 'yaa ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Nyɩsʋa a tetetɔɔnyʋ kɔ Falisi꞊tumu a nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, ʋ nʋ‑ ‑Yusu yɩ 'lɩ ‑mɔ ‑hlee ‑nɩ, ɛ wɛn: «'A mʋ Nyɩsʋa a tetetɔɔnyʋ kɔ Falisi꞊tumu a nyibli 'hʋɛn‑, ‑ʋ nɛɛ 'li nɩ 'hʋɛn, 'jrɔ 'kɩ 'ʋ 'a mʋ ‑mɔ, ‑kɔtɩ 'hru ‑mʋ', nyibli di wɛn na, ʋ 'mʋ wɛn 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli pa, a kɛ꞊ɛ nɩ. Mɔ, 'aan 'mumu, a 'nɩ ‑pa꞊a 'lɩ, 'a kɛ nyibli ‑bɩ yɩ, 'kɩ bʋ pa 'lɩ, 'ye ꞊bɩɩ ʋ yɩ 'lɩ pʋpa nɩ ‑hʋɛ.  ");
INSERT INTO ktj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","'A mʋ Nyɩsʋa a tetetɔɔnyʋ kɔ Falisi꞊tumu a nyibli, ‑ʋ nɛɛ 'li nɩ 'hʋɛn, 'jrɔ 'kɩ 'ʋ 'a mʋ ‑mɔ, ‑ɛ nu꞊o, a ‑hɛ ‑tʋgbanʋgbɩ, 'waa kʋkɔ‑tɛblɩ a pɛpɛ ꞊jrɛ. 'Tɩ‑ 'ba yɩ Nyɩsʋa nɩ dɛ, 'aan Nyɩsʋa a dɩda hlɔ kɩ bʋ, ‑ɛ di꞊e nu, nyibli 'mʋ lɛ pʋ, a mɔ ꞊haannyibli ꞊nɩɔ. Ɛ nɔ‑ di꞊e nu, ‑bati ‑mʋ', Nyɩsʋa di 'a mʋ lɛ ‑pʋʋ ‑nɩ, ɛ 'mʋ 'klɩ kɩ nɩ, ɛ 'mʋ 'ʋ ‑ʋ ‑bɩ a ‑bati 'ʋ ‑hi. ");
INSERT INTO ktj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","'A mʋ Nyɩsʋa a tetetɔɔnyʋ kɔ Falisi꞊tumu a nyibli, ‑ʋ nɛɛ 'li nɩ 'hʋɛn, 'jrɔ 'kɩ 'ʋ 'a mʋ ‑mɔ. A nɛ 'blʋgbɩ a pɛpɛ kɩ, 'yru kɔ ‑tʋtʋ 'hʋɛn‑, 'a ꞊tui 'ʋ 'klɩ, ‑ɛ di꞊e nu, nyiblo nɩ ‑do 'mʋ 'aan nyɩsʋadɛ kɩ wɛn. 'Bʋ mɔ, 'bʋ wɛn꞊ɛ kɩ, ‑ɛ ‑bɩ a ni꞊e nɩ, 'ɛ yɩ 'crɛkɔnyɔ ‑hɛ, 'ɛ yɩ 'ʋ 'a mʋ 'ʋ ‑hi, 'ɛ kʋɛ yɩnyre꞊wlɩ nɩ 'hʋɛn. 'Bʋ nɩ 'mʋ lɛ, ‑ɛ ‑bɩ ɛ blɛɛ yɩ, ‑nyrɔwɔ ꞊dʋ, Nyɩsʋa bʋ pʋ 'lɩ꞊ɩ na ‑mʋ', ‑ɛ 'yɛ nɩ jre 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","'A mʋ Nyɩsʋa a tetetɔɔnyʋ kɔ Falisi꞊tumu a nyibli, ‑ʋ nɛɛ 'li nɩ 'hʋɛn, 'jrɔ 'kɩ 'ʋ 'a mʋ ‑mɔ. A tʋɛ nɛ nyibli nɩ, ‑ɛ mɔ, 'bʋ mɔ, nyiblo 'bʋ 'sʋʋ Nyɩsʋa a 'kagbaʋ, ‑ɛ ‑bɩ ɛ 'yɩ yɩ ‑blɛɛ ‑nɩ, dɛ a 'mʋ, ɛ 'sʋʋ ‑nɩ, bʋ nu꞊o. Kɛɛ, 'bʋ mɔ, 'bʋ 'sʋʋ ‑gʋlʋ ‑mʋ', ‑ɛ nɩ 'lɩ Nyɩsʋa a 'kagbaʋ a 'mʋ bʋ, ‑ɛ ‑bɩ dɛ a 'mʋ, ɛ 'sʋʋ ‑nɩ, ɛ blɛɛ yɩ bʋ nu꞊o, (‑ɛ nu꞊o, a wɛn 'nɩ, ‑gʋlʋ a 'mʋ, ɛ mɔ dɛ gbagbʋ ꞊nɩɔ, 'kɩ 'ʋ Nyɩsʋa ye', 'ɛ ‑hi 'ʋ Nyɩsʋa a 'kagbaʋ 'ʋ.) ");
INSERT INTO ktj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","'A mʋ ‑mʋ', ‑ʋ 'yɩ 'lulɛ‑hihie ‑kɔ, 'tɩ‑ ‑ʋ 'wɩ 'yii'dɔnyʋ yɩ, a yi꞊e nɩ ‑tɛɛ, ‑ɛ mɔ, Nyɩsʋa a 'kagbaʋ mɔ dɛ gbagbʋ ꞊nɩɔ, 'kɩ 'ʋ Nyɩsʋa ye', 'ɛ ‑hi 'ʋ ‑gʋlʋ ‑mʋ', ‑ɛ nɩ 'lɩ 'kayu a 'mʋ 'kwli, ‑ɛ nu꞊o, Nyɩsʋa a 'kagbaʋ, ɛ nɔ‑ nu꞊o, ‑gʋlʋ a 'mʋ, 'ɛ ‑hɛ dɛ gbagbʋ, 'kɩ 'ʋ Nyɩsʋa ye'. ");
INSERT INTO ktj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kɛ‑ a pɩ, 'a tʋɛ nyibli, ‑ɛ mɔ, nyiblo 'bʋ nɩ 'ʋ, 'bʋ 'sʋʋ Nyɩsʋa a ‑cɔhlʋnpiilɛ*, ɛ 'yɩ yɩ ‑blɛɛ ‑nɩ bʋ nu dɛ ‑mʋ', ɛ 'sʋʋ ‑nɩ. Kɛɛ, 'bʋ mɔ, 'bʋ 'sʋʋ ‑cɔhlʋn* ‑mʋ', ‑ɛ nɩ 'ʋ ‑cɔhlʋnpiilɛ', ‑ɛ ‑bɩ dɛ a 'mʋ, ɛ 'sʋʋ ‑nɩ, ɛ blɛɛ yɩ bʋ nu꞊o. ");
INSERT INTO ktj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","'A mʋ nyibli ‑mʋ', ‑ʋ 'wɩ 'yii'dɔnyʋ yɩ, a yi꞊e nɩ ‑tɛɛ, ‑ɛ mɔ, ‑cɔhlʋn mɔ dɛ gbagbʋ ꞊nɩɔ, 'kɩ 'ʋ Nyɩsʋa ye', 'ɛ ‑hi 'ʋ ‑cɔhlʋnpiilɛ ‑mʋ' 'ʋ, ‑ɛ kɔ kɩ ‑cɔhlʋn a 'mʋ, ɛ nɩ 'ʋ, ‑ɛ nu꞊o, ‑cɔhlʋn, ɛ nɔ‑ ni꞊e, ‑cɔhlʋnpiilɛ 'ɛ mɔ dɛ gbagbʋ, 'kɩ 'ʋ Nyɩsʋa ye'. ");
INSERT INTO ktj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","'A ‑tɩ o, nyiblo 'bʋ nɩ 'ʋ, 'bʋ 'sʋʋ ‑cɔhlʋnpiilɛ, ‑ɛ ‑bɩ ‑tɛblɩ a pɛpɛ ‑mʋ', ‑ʋ nɩ 'ʋ꞊ʋ kɩ, ʋ nʋ‑ ɛ 'sʋʋ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mɔ, nyiblo 'bʋ 'sʋʋ Nyɩsʋa a 'kagbaʋ, ɛ ꞊hɛn 'nyrɛ, ɛ 'sʋʋ Nyɩsʋa, ‑ɛ nɩ 'lɩ꞊ɩ bʋ nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","'Bʋ mɔ, nyiblo 'bʋ 'sʋʋ yakɔ, ɛ 'sʋʋ yakɔ, ‑ɛ mɔ Nyɩsʋa a bʋnɩɩlɛ, 'ɛ 'sʋʋ Nyɩsʋa ‑mʋ' ‑wɛ, ‑ɛ nɩ 'lɩ yakɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","'A mʋ Nyɩsʋa a tetetɔɔnyʋ kɔ Falisi꞊tumu a nyibli, ‑ʋ nɛɛ 'li nɩ 'hʋɛn, 'jrɔ 'kɩ 'ʋ 'a mʋ ‑mɔ. 'Bʋ mɔ, 'ba kɔ hawi ‑mʋ', a pɩ 'lɩ dididɛ ‑mɔ, kɔ 'a ‑nɛ 'dʋdɔdɛ 'cɩmɩɛ ꞊dʋ, a ‑hɛ 'lɩ ‑sadɛ 'kwli, ɛ nɔ‑ kɔ ‑pu a dɛ a ‑hɛ 'lɩ, 'a yɩ꞊ɩ Nyɩsʋa ‑nyi. Kɛɛ, a 'nɩ ‑hie꞊e lɩ꞊ɩ 'lu ‑mɔ lɛ, 'kɩ ba nu ‑tɛblɩ gbagbɩ ‑mʋ', ʋ 'crɩɩ 'lɩ Nyɩsʋa a tetecrɩɛn 'kwli. A 'nɩ ‑hie lɩ꞊ɩ 'lu ‑mɔ lɛ, 'kɩ 'aan nunuŋmlɩ bʋ 'sii 'ʋ yɩ, ba kɔ nyibli a nyaɩ, kɔ, ba kuo Nyɩsʋa ꞊wlʋ yɩ ‑tɛɛ. Dɛ a 'mʋ, ɛ nɔ‑ a kɔ ba nu wɛn, 'tɩ‑ a 'mʋ wɛn 'lɩ 'aan 'dʋdɔ‑tɛblɩ a ‑pu a dɛ ‑ha, a 'mʋ wɛn꞊ɛ Nyɩsʋa ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","'A mʋ nyiblinaanyʋ ‑mʋ', ‑ʋ 'wɩ‑ 'yii'dɔnyʋ yɩ, 'n pɩɩ ꞊nɛ dɛ yɩ: A ‑hɛ 'aan 'nɩnanie nɩ, ‑ɛ di꞊e nu, a 'nɩ ꞊ha ‑tamlɩyɛ ꞊dʋ mla, ‑ɛ nɩ 'lɩ 'nie a 'mʋ ‑mɔ, kɛɛ, a 'nɩ 'ye꞊e lɩ bli, ‑ɛ nɩ 'lɩ, 'a mlɛ꞊ɛ. (Ɛ 'wɩ yɩ, a ꞊tui꞊e 'yie, 'kɩ ba ꞊tuu 'ʋ tete 'cɩmɩ, kɛɛ, tete gbagbɩ ‑mʋ', a 'nɩ ꞊tuu꞊o 'ʋ ꞊nʋ 'ʋ.) ");
INSERT INTO ktj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","'A mʋ Nyɩsʋa a tetetɔɔnyʋ kɔ Falisi꞊tumu a nyibli, ‑ʋ nɛɛ 'li nɩ 'hʋɛn, 'jrɔ 'kɩ 'ʋ 'a mʋ ‑mɔ. 'Aan 'kwli'naapʋɛlɩ kɔ 'aan 'kwlitaapʋɛlɩ 'hʋɛn‑, ʋ nʋ‑ a yrɛ lɛ. Kɛɛ, 'kɩ 'lɩ 'aan ꞊wlɩ kɩ, 'yiyrie kɔ ‑hʋhʋa‑tɛblɩ ‑hʋɩn 'hʋɛn‑, ʋ nʋ‑ 'yii 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","‑Mɔ Falisi꞊tumu a nyiblo, ‑ɛ kɔ 'yii ꞊dɔɔ, yra 'lɩ ‑na 'kwli'naapʋɛlɩ 'kwli lɛ, ‑ɛ ‑bɩ 'a ke di 'lɩ 'nɩ 'wʋ, ɛ 'mʋ 'ʋ yɩ 'sii ‑nɩ. (Ɛ ꞊hɛn 'nyrɛ, ꞊tu 'ʋ 'klɩ, ‑ɛ di꞊e nu, ‑na ꞊wlʋ 'mʋ 'ʋ yɩ 'sii ‑nɩ, 'kɩ 'ʋ Nyɩsʋa ye', ‑ɛ di꞊e nu, ‑tɛblɩ a pɛpɛ, 'kɩ 'lɩ ‑na 'klɔ 'kwli, ʋ 'mʋ 'ʋ yɩ 'sii ‑nɩ ‑wɛ.) ");
INSERT INTO ktj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","'A mʋ Nyɩsʋa a tetetɔɔnyʋ kɔ Falisi꞊tumu a nyibli, ‑ʋ nɛɛ 'li nɩ 'hʋɛn, 'jrɔ 'kɩ 'ʋ 'a mʋ ‑mɔ. A 'wɩ 'dabi yɩ, ʋ 'pɛnɩ ‑nɩ. 'Dabi a 'mʋ, ʋ nɔɔ 'yie klɛ, kɛɛ, ʋ 'yii 'lɩ nɩ, 'kɩ 'ʋ 'kʋkʋkui a 'klɩ ‑mɔ, kɔ 'kɩ 'ʋ ꞊hʋnhɔn‑tɛblɩ a gblegble ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Dɛ nɩ ‑do, ɛ nɔ‑ ɛ pa 'mʋ, 'kɩ 'ʋ 'a mʋ ‑mɔ. A nɔɔ 'lɩ nyibli 'yii klɛ, kɛɛ, sɛyɩ‑sɛyɩ a nɛɛ 'li nɩ 'hʋɛn, dɛ 'kuku 'yii 'lɩ 'aan ꞊wlɩ kɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«'A mʋ Nyɩsʋa a tetetɔɔnyʋ, kɔ Falisi꞊tumu a nyibli 'hʋɛn‑, ‑ʋ nɛɛ 'li nɩ 'hʋɛn, 'jrɔ 'kɩ 'ʋ 'a mʋ ‑mɔ, ‑ɛ nu꞊o, Nyɩsʋa a winwlɔn‑hanyʋ*, kɔ nyibli ‑mʋ', ‑ʋ kɔ 'klɔ 'sii la 'ʋ yɩ, 'aan 'baɩnʋ 'lɩlɛ la lɛ, a yɩ 'waa 'dabi 'nɩ ꞊hrɛntɩ ‑nɩ ‑tɛɛ, ");
INSERT INTO ktj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","'tɩ‑ 'a pɩ lɛ: 'Bʋ mɔ, ꞊ba nɩ la 'klɔ ti a 'mʋ 'yri, ‑a 'yɩ la 'lɩ꞊ɩ 'lɩ ‑wɛ, ‑ba bi la ‑aan 'baɩnʋ kɩ, ‑ba 'la la Nyɩsʋa a winwlɔn‑hanyʋ a 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","‑Tɛ a ni 'pʋplɛ lɛ, ɛ ꞊hɛn 'nyrɛ, a yrui꞊e nɩ, ‑ɛ mɔ, nyibli ‑mʋ', ‑ʋ 'lɩlɛ la Nyɩsʋa a winwlɔn‑hanyʋ lɛ, 'a mʋ ‑mɔ 'waa 'yonʋ. ");
INSERT INTO ktj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","'A ‑tɩ o, dɛ ‑mʋ' 'aan 'baɩnʋ ꞊tu la ‑wlu, ba gba꞊a 'lu ‑mɔ, ‑ɛ di꞊e nu, a 'mʋ꞊ʋ 'lu ‑yra. ");
INSERT INTO ktj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","'A mʋ ‑mʋ', a kɛɛ nyibli, 'aan nunuŋmlɩ 'ɛ nyre yɩ, a 'wɩ‑ hro yɩ. Nyɩsʋa a ‑bati di 'a mʋ 'nɩ klɔ, ɛ 'mʋ 'lɩ 'a mʋ na ‑mʋ', ‑ɛ 'yɛ nɩ jre 'nyɩ pʋ. A 'nɩ 'hie 'lɩ꞊ɩ 'lu ‑mɔ lɛ, ‑ɛ mɔ, a di 'lɩ꞊ɩ wlɔn 'nɩ ꞊ta. ");
INSERT INTO ktj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, 'n di ya 'a mʋ Nyɩsʋa a winwlɔn‑hanyʋ, kɔ ꞊tɔkɔnyʋ, kɔ nyibli ‑mʋ', ‑ʋ tʋɛ Nyɩsʋa a ‑tɩ. A di 'waa dɛ ‑bɩ 'nɩ 'la, a 'mʋ 'ʋ ‑ʋ ‑bɩ tugbɛ 'yie ‑kɔɔ ‑nɩ, ‑ɛ di꞊e nu, ʋ 'mʋ 'kʋ, kɔ, a di bii ‑ʋ ‑bɩ lɔkʋɛ, 'kɩ 'lɩ Nyɩsʋa a 'kayo blɛ, kɔ, a 'mʋ ꞊nʋ 'dɩɩ klɛ bla, ‑ɛ di꞊e nu, a 'mʋ ꞊nʋ ꞊hɩʋɛn ꞊tu. ");
INSERT INTO ktj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ɛ nɔ‑ di꞊e nu, Nyɩsʋa a yrʋ 'mʋ 'a mʋ klɔ, 'kɩ nyibli a pɛpɛ ‑mʋ', ‑ʋ 'sii 'ʋ yɩ, ‑ʋ kɔ ‑hlʋ ʋ 'wʋwlɛ la blɛ a ‑ta', kʋɛ 'lɩ Abɛlɩ, ‑ɛ 'sii la 'ʋ yɩ, a ti 'yie bʋ, ‑bʋ yɛ Balasi a 'yu Sakali kɩ, 'aan 'baɩnʋ 'la la, 'kɩ 'ʋ Nyɩsʋa a 'kayu kɔ 'a ‑cɔhlʋnpiilɛ* a ‑gbati. ");
INSERT INTO ktj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ, ‑ɛ mɔ, ti ‑bʋ 'yri a nyibli, ʋ nʋ‑ Nyɩsʋa a yrʋ di klɔ, 'kɩ 'ʋ ‑tɛblɩ a pɛpɛ a 'mʋ a ‑ta'.» ");
INSERT INTO ktj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«'N yɩ Jrusrɛ a nyibli 'nɩ ‑lee ‑nɩ: Nyɩsʋa 'bʋ lee 'nɛ‑ 'a mʋ 'a winwlɔn‑hanyʋ* ‑mɔ, a pɩ ꞊nʋ 'hɩ ‑mɔ lɛ, 'a 'lɛ ꞊nʋ. 'N ‑hʋɛ mɔ꞊ɔ nɩ 'a ‑nɛ ti, ꞊bʋ 'kukue mɔ 'a mʋ lɛ, kɩ mɔ 'mʋ 'hʋɩ, ꞊wɩ yɩ ‑tɛ hapɛ'gba ni, 'ɛ yɩ 'a 'yonʋ lɛ 'kukue ‑nɩ, 'tɩ‑ 'ɛ yɩ ꞊nʋ kɩ bʋ ꞊jri, kɛɛ, a 'yɩ꞊ɩ kɩ ‑wɛn. ");
INSERT INTO ktj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ɛ nɔ‑ kɔ ‑tɩ, Nyɩsʋa 'mʋ 'ʋ 'aan 'dɩɔ bʋ hie, 'a mʋ nɩ ‑do, a 'mʋ 'lɩ 'aan dɩɔnʋ lɛ ‑kikle ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, kʋɛ 'kɩ mɔ bʋ, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba 'ye 'kɩ 'mʋ de, ɛ 'mʋ꞊ʋ gba ‑gbagba, ‑nyrɔwɔ ‑mʋ', ɛ 'mʋ 'ʋ nyre, ‑ɛ kɔ 'kwli a di lɛ pʋ: ‑Na 'wio, ‑mɔ ‑bʋ, ‑ɛ yɩ 'lɩ di, 'kɩ 'lɩ Kʋkɔnyɔ Nyɩsʋa a 'nyrɛ 'kwli. Nyɩsʋa bʋ ‑nyi ‑mʋ ‑tɩ a 'yi'bʋalɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","‑Tɛ ‑Yusu ‑wɛ 'pʋplɛ ‑mɔ, ‑ɛ ‑bɩ ɛ yɩ 'hrɩ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ. Bʋ yɩ 'kɩ nɩ mi, ‑ɛ ‑bɩ 'a ‑nagbopʋ* 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, 'ʋ yɩ꞊ɩ ‑lee ‑nɩ: «'Ye ‑tɛ Nyɩsʋa a 'kagbaʋ nu yɩnɩnɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «A yɩ 'kayu ‑bʋ, 'a yɩnɩnɔ 'nɩ 'ye. Kɛɛ, ꞊bʋ lee nɛ 'a mʋ, yɩnɔkayu ‑bʋ, a yɩ 'ye, ʋ di꞊e 'nɩ 'wla pɛpɛ. 'A 'hɩɔ ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nɩ 'ʋ 'a 'bɩ 'hɩɔ 'lu bʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","‑Yusu bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ɛ kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ ꞊tɩ 'dɩɔ, 'ʋ mu 'lɩ dʋgba ‑mʋ', ‑ɛ kɔ 'lu olifieti nɩ 'lɩ. ‑Tɛ ʋ nyre 'lɩ, ‑ɛ ‑bɩ ‑Yusu nɩ bʋ, nyiblo nɩ ‑do 'yɩ 'ʋ꞊ʋ 'hʋɩ ‑nɩ, 'bʋ 'yɩ 'a ‑nagbopʋ nɩ ‑do 'pa‑. Ɛ nɔ‑ mɔ 'a ‑nagbopʋ bʋ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, bʋ 'bɛti꞊e, ʋ wɛn: «Lee nɛ ‑a mʋ, ti a 'dɩ ‑bɩ, ‑ɛ kɔ 'yri ʋ di 'ʋ Nyɩsʋa a 'kagbaʋ 'wlaa ‑nɩ 'lɩ, ɛ kɔ, dɛ a 'dɩ ‑bɩ, ‑ɛ di 'lu ‑mɔ mu, ‑a di 'ye, 'tɩ‑ ‑a 'mʋ꞊ʋ yi, ‑ɛ mɔ, ‑na kle‑mɛti kɔ 'klɔ ‑bʋ a 'ʋ‑hɔnti nyre 'ʋ nɩ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «Ba nɩ 'ʋ ‑pleelɛ', ‑ɛ di꞊e nu, nyiblo ꞊dʋ 'nɩ ꞊ha 'a mʋ ‑kaa ‑nɩ, ");
INSERT INTO ktj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","‑ɛ nu꞊o, nyibli ‑hʋɔhʋɩ di 'nɩ di, 'kɩ 'lɩ 'na 'nyrɛ 'kwli, ʋ 'mʋ lɛ pʋ, ʋ nʋ‑ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya, 'tɩ‑ ʋ 'mʋ nyibli ‑hʋɔhʋɩ ‑kaa ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","'Ya 'ʋ 'lu de, a di 'nɩ 'wɩn, ‑ɛ mɔ, ʋ ‑wɛn tʋ, 'kɩ 'lɩ 'blʋgbɩ ‑mʋ', ‑ʋ 'mʋɛ nɛ 'a mʋ yrɛ 'kwli, ɛ kɔ, ‑ʋ hlɔɔ nɛ 'a mʋ ‑mɔ lɛ. 'Ba yɩ 'nɩ 'wɩn, a 'nɩ 'pie 'lɩ hʋannʋ, ‑ɛ nu꞊o, ‑tɛblɩ a 'mʋ, ɛ kɔ bʋ mu 'lu ‑mɔ. Kɛɛ, 'bʋ yɩ 'lu ‑mɔ nɩ mi, ɛ 'yɩ 'nyrɛ ꞊hɛn, ‑ɛ mɔ, 'klɔ a 'ʋ‑hɔnti nyre 'ʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","'Blʋgbɩ di yɩ 'nɩ ‑wʋnwɔn ‑nɩ. 'Kɩ 'lɩ 'blʋgbɩ ‑hʋɔhʋɩ kɩ, 'kanʋ di 'nɩ ꞊tɩ, kɔ, ‑tʋtʋ 'mʋ 'hɩhlɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","'Kla‑wliye'yɩya a 'mʋ, ‑ɛ di 'lɩ di, 'klɔ a 'ʋ‑hɔnti, ɛ nɔ‑ kɔ ‑wlu꞊tutuo ꞊nɩɔ. Kɛɛ, 'klɔ a 'mumu, ɛ 'yɛɛ 'ʋ ‑wlu nɩ ‑hʋɛn. Ɛ 'wɩ‑ nʋgba ‑nɩ 'kwli yɩ, ‑ɛ kɔ 'kwli ‑tʋa kɩkla, kɛɛ, ‑kɔ ꞊gbʋgblati ꞊yɛɛ 'ʋ nɩ nyre. ");
INSERT INTO ktj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ti a 'mʋ 'yri, 'aan yraanyibli di pʋ 'a mʋ 'blʋgbanaanyʋ ‑jɩ', ‑ɛ di꞊e nu, ʋ 'mʋ 'a mʋ ꞊hɩʋɛn ꞊tu, ɛ kɔ, ʋ 'mʋ 'a mʋ 'la ‑wɛ. Nyibli a pɛpɛ ‑mʋ', ‑ʋ nɩ 'nɛ‑ 'klɔ kɩ, ʋ kɔ bʋ yraa nɛ 'a mʋ, ‑tɛ a mɔ 'na nyibli a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ti a 'mʋ 'yri, nyibli ‑hʋɔhʋɩ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ kuo 'mʋ ꞊wlʋ yɩ de, ‑ʋ ‑bɩ 'mʋ 'waa 'bio ‑bɩ ‑kaa ‑nɩ, ʋ 'mʋ ꞊nʋ 'blʋnaanyʋ ‑jɩ' pʋ, ʋ 'mʋ ꞊nʋ ꞊hɩʋɛn ꞊tu, ɛ kɔ, nyibli 'mʋ 'yi ‑yɩyraa ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Hɩwinwlɔn‑hanyʋ ‑hʋɔhʋɩ di 'nɩ 'hrɩ, ʋ 'mʋ nyibli ‑hʋɔhʋɩ ‑kaa ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","'A ‑nɛ ‑tɩtɛ ꞊dʋ, kɛ‑ nyibli di nu, ʋ 'mʋ yɩnyre‑tɛblɩ nu, yɩnyre‑tɛblɩ a 'mʋ, ɛ 'mʋ klɛ ‑bii ‑nɩ, ɛ 'mʋ꞊ʋ nu, nyibli ‑hʋɔhʋɩ 'mʋ 'waa 'bio a nʋɛlɛ 'kee ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kɛɛ, nyiblo 'bʋ 'yɩ ‑sa, 'kɩ 'ʋ Nyɩsʋa a ꞊wlʋ a yɩkuolɛ ‑mɔ', 'bʋ gba꞊a 'lu ‑mɔ ‑gbagba, 'klɔ a 'ʋ‑hɔnti 'bʋ nyre 'ʋ, ɛ nɔ‑ Nyɩsʋa di wa. ");
INSERT INTO ktj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","'Kɩ 'nɛ‑ 'klɔ a pɛpɛ ‑bʋ kɩ, 'na nyibli di 'na ꞊haantitie 'nɩ pʋ, ‑ɛ hlɛ꞊ɛ, ‑tɛ ‑mʋ', Nyɩsʋa nu nyibli a win a kɩkɔɔlɛ, ‑ɛ di꞊e nu, dakɔ a pɛpɛ a nyibli 'mʋ 'wɩn, ʋ 'mʋ 'hru kɔ, 'kɩ bʋ kuo ꞊haantitie a 'mʋ ꞊wlʋ yɩ, 'tɩ‑ 'klɔ a 'ʋ‑hɔnti 'mʋ 'ʋ nyre.» ");
INSERT INTO ktj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Nyiblo ‑bʋ, ‑ɛ yɩ win bʋ ‑hre, ɛ blɛɛ yɩ, bʋ kɔ ꞊tɔ, 'tɩ‑ ɛ 'mʋ꞊ʋ' lɛ yru. Win a 'mʋ, ɛ nɔ‑ ‑bʋ: Ɛ di kɔ ti ‑bɩ, a 'mʋ yɩnyredɛ 'ye, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ. Yɩnyredɛ a 'mʋ, Nyɩsʋa a ꞊wlʋ yraa ꞊nɛ nɩ, 'tɩ‑ dɛ a 'mʋ, 'ɛ ni꞊e, Nyɩsʋa 'ɛ hlʋɛ nɛ 'a 'kayu ‑mɔ lɛ. Yɩnyredɛ a 'mʋ, ‑tɩtɛ ɛ 'yɩ 'ʋ ‑kɔ, 'kɩ ɛ di 'ʋ nɩ. Nyɩsʋa a winwlɔn‑hanyɔ* Danɩɛ, ɛ nɔ‑ hla la yɩnyredɛ a 'mʋ, 'a ‑tɩ. 'Bʋ mɔ, 'ba 'ye dɛ a 'mʋ, ");
INSERT INTO ktj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","‑ɛ ‑bɩ nyibli ‑mʋ', ‑ʋ nɩ 'lɩ Sudeblʋgba 'kwli, bʋ 'gba ci lɛ, bʋ mu 'lɩ dʋgbɩ 'lu, ʋ 'nɩ ꞊ha ꞊nʋ lɛ 'lɩla ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nyiblo 'bʋ nɩ 'lɩ 'kayu a ‑yaa 'kwli, bʋ 'gba ci lɛ ‑dodo. Ɛ 'nɩ 'pʋʋ 'lɩ lɛ, bʋ pa 'lɩ 'kayu bʋ, ɛ 'mʋ 'a kʋkɔ‑tɛblɩ bla, 'tɩ‑ ɛ 'mʋ ci lɛ 'gba. ");
INSERT INTO ktj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nyiblo 'bʋ nɩ 'lɩ 'a ‑ci kɩ, bʋ 'gba ci lɛ ‑dodo. Ɛ 'nɩ 'pʋʋ 'lɩ lɛ, bʋ ꞊hɩan ‑mɔ, bʋ bla 'a wlawlɩ, 'kɩ 'lɩ 'dɩɔ 'kwli, 'tɩ‑ ɛ 'mʋ ci lɛ 'gba. ");
INSERT INTO ktj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ti a 'mʋ 'yri, nʋgbɩ ‑mʋ', ‑ʋ di 'kwli lɛ nɩ, ɛ kɔ 'waa dɛ ‑mʋ', ‑ʋ di 'yonʋ 'nya, ʋ di 'ye ꞊hɩʋɛn dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ba da Nyɩsʋa, ‑ɛ di꞊e nu, ‑tɛblɩ a 'mʋ, ɛ 'nɩ ꞊ha 'lu ‑mɔ mu, a 'nɩ ꞊ha ci lɛ 'gba, ti ‑mʋ' ‑kɔ 'yri cɛ yɩ 'ʋ ꞊tɩɩ ‑nɩ, ‑ʋ'ʋ‑ ‑wuwle‑nyrɔwɔ* 'kwli, ");
INSERT INTO ktj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","‑ɛ nu꞊o, ti a 'mʋ 'yri, ꞊hɩʋɛn ‑tonyibli di 'ye, ɛ di 'nɩ 'bʋa, ɛ 'mʋ 'a dɛ ‑mʋ', ‑tonyibli ‑tʋa la 'lɩ 'yiye 'ʋ ‑hi, kʋɛ la 'lɩ ‑tɛ 'klɔ ꞊tu la ‑wlu 'yie bʋ, ‑bʋ yɛ ti ‑bʋ, ‑a nɩ kɩ. Kʋɛ 'lɩ ꞊hɩʋɛn a 'yiye gbagbʋ a 'mʋ a ti 'yie bʋ, ‑bʋ yɛ 'klɔ a 'ʋ‑hɔnti kɩ, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ 'ye ꞊hɩʋɛndʋ a 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nyɩsʋa di ꞊tɩɔ ‑nyrɔwɩ a 'mʋ 'lu, 'kɩ 'ʋ nyibli ‑mʋ', ɛ ‑ha 'lɩ, 'kɩ ‑bʋ mɔ 'a nyibli a ‑ta'. Ɛ nɔ‑ 'yɩ wɛn꞊ɛ 'pa‑, nyiblo ꞊dʋ 'yɩ wɛn 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nɩ wɛn 'klɔ, ti a 'mʋ 'yri. ");
INSERT INTO ktj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ti nɩ ‑do a 'mʋ 'yri, nyiblo 'bʋ lee nɛ 'a mʋ, 'bʋ pʋ lɛ: Ba 'ye kɛ, Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya, 'kɩ ɛ nɩ 'nɛ‑, ‑hʋʋ', 'kɩ ɛ nɩ 'lɩ ‑tɩtɛ ‑mʋ', a 'nɩ 'pʋʋ 'lɩ꞊ɩ ꞊haan‑tɩ, ");
INSERT INTO ktj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","‑ɛ nu꞊o, hɩwanyʋ, kɔ hɩwinwlɔn‑hanyʋ di 'nɩ 'hrɩ, ʋ 'mʋ ꞊wlɩlɛkɛɛ‑tɛblɩ gbagbɩ a gblegble nu, ‑ɛ di꞊e nu, 'bʋ ‑wɛ 'lɩ꞊ɩ, ʋ 'mʋ nyibli ‑mʋ', Nyɩsʋa ‑ha 'lɩ, 'kɩ bʋ mɔ 'a nyibli ‑kaa ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","'A ‑tɩ, ba pʋ 'mʋ nʋa yɩ bʋ, ‑ɛ nu꞊o, ‑tɛblɩ a pɛpɛ, ‑ɛ di 'lu ‑mɔ mu, ɛ nɩ ke', 'nɩ yɩ 'a mʋ ‑lee ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","'Bʋ mɔ, 'bʋ lee nɛ 'a mʋ, ‑ɛ mɔ: Ba di 'lɩ, Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya, 'kɩ ɛ nɩ 'lɩ ‑tɩtɛ ‑mʋ', nyiblo ꞊dʋ 'yɩ 'lɩ 'ti, a 'nɩ 'muo 'lɩ. Mɔ, 'bʋ mɔ, 'bʋ lee nɛ 'a mʋ ‑wɛ, ‑ɛ mɔ: Ba di 'lɩ, 'kɩ ɛ ‑hli 'nɛ‑ ‑tɩtɛ ‑bʋ, a 'nɩ 'pʋʋ 'lɩ꞊ɩ ꞊haan‑tɩ, ");
INSERT INTO ktj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","‑ɛ nu꞊o, Wanyɔ a 'mʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'a didie di 'wɩ‑ ‑tɛ yakɔ ni, 'ɛ pɩ 'yii, kʋɛ 'lɩ 'yrʋ a 'hrɩɩlɛ', ‑bʋ mu, ‑bʋ yɛ 'yrʋ a bʋpɛɛlɛ kɩ. ");
INSERT INTO ktj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","‑A 'blikʋɛ wɛn 'nɩ: ‑Tɛ ‑mʋ', mʋma 'kuku yɩ 'ʋ bʋ pɛ, 'kɩ ke yɩ 'ʋ lɛ 'kukue ‑nɩ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«꞊Hɩʋɛn'yeti a 'mʋ, 'bʋ ‑hi, ‑ɛ ‑bɩ 'yrʋ kɔ ꞊hɔnpʋ 'hʋɛn‑, ʋ di 'nɩ jre, nyahro di ble 'lɩ yakɔ 'kwli lɛ, ɛ kɔ, ‑tɛblɩ a pɛpɛ ‑mʋ', ‑ɛ nɩ 'lɩ yakɔ 'kwli, ɛ 'mʋ ‑ta' lɛ ‑hɔn. ");
INSERT INTO ktj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ti nɩ ‑do a 'mʋ 'yri, nyibli di 'ye dɛ, 'kɩ 'lɩ yakɔ 'kwli, ‑ɛ tʋɛ ꞊nʋ, ‑ɛ mɔ, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n di 'nɩ di. ‑Ɛ ‑bɩ 'klɔ kɩ a dakɔ a pɛpɛ di nu nyaɩ lɛ, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, ʋ 'mʋ 'mʋ 'ye. 'N di 'nɩ di, 'kɩ 'lɩ 'na 'klɩkɩnɩnɩɩ 'kwli, kɔ 'kɩ 'lɩ 'na ‑tɩ a 'yi'bʋalɛ 'kwli. 'Bʋ mɔ, 'nɩ yɩ nɩ di, 'kɩ 'n di 'lɩ 'nuŋmɩ 'nyɩ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","‑Ŋamʋ gbagbʋ di pʋ win, 'mʋ Nyɩsʋa a lɛlenyʋ bʋ tɛ, ʋ 'mʋ 'klɔ ‑bʋ 'a ꞊gɛ a pɛpɛ kɩ na, nyibli ‑mʋ', Nyɩsʋa ‑ha 'lɩ, 'kɩ bʋ ‑hɛ 'a nyibli, ʋ 'mʋ ꞊nʋ lɛ 'kukue ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Ba 'ye kɛ tugbɛ ‑mʋ', ʋ dɛɛ figie. 'Kɩ 'ʋ tugbɛ a 'mʋ 'yie, tɔɔlɛ nɩ 'ʋ. Ɛ nɔ‑ mɔ, ti ‑mʋ' ‑kɔ 'yri ɛ ꞊tui 'ʋ babʋɩ yrayrɩ lɛ, ɛ kɔ, 'a hawi 'bʋ yɩ nɩ ꞊gɛ, ‑ɛ ‑bɩ ‑a yi꞊e nɩ, ‑ɛ mɔ, ‑cii‑ci‑nyrɛ 'mʋɛ yrɛ. Kɛ‑ 'na didie di 'mʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","‑Tɛblɩ a pɛpɛ ‑bʋ, ‑kɔtɩ 'n hla wɛn, 'bʋ yɩ 'lu ‑mɔ nɩ mi, ‑ɛ ‑bɩ ba kɔ 'a yiyie, ‑ɛ mɔ, 'na 'lɩditi 'mʋɛ yrɛ. Ɛ 'wɩ yɩ, 'kɩ 'n nɩ 'ʋ 'maju 'yri. ");
INSERT INTO ktj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","'Nɩ yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, nyibli ‑bʋ, ‑ʋ nɩ 'klɔ, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ 'kʋ, ‑tɛblɩ a pɛpɛ a 'mʋ, ɛ 'mʋ 'ʋ nyre. ");
INSERT INTO ktj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yakɔ kɔ ‑tʋtʋ 'hʋɛn‑, ʋ di bʋ 'nɩ ‑wɛ, kɛɛ, 'na win 'yɩ 'lɩ꞊ɩ ‑wɛ, bʋ ‑wɛ bʋ 'klɔ ‑mɔ 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ de, ɛ wɛn: «Ti ‑mʋ', lɛ'bɔɔ‑nyrɔwɔ bʋ di 'ʋ nyre, ɛ 'yɩ nyiblo ꞊dʋ ‑kɔ, ‑bʋ yi ‑nyrɔwɔ a 'mʋ. Ɛ mɔ, 'na 'mumu a 'mʋ ‑bʋ, ‑ɛ mɔ Nyɩsʋa a 'Yu, 'n kɔ Nyɩsʋa a lɛlenyʋ 'hʋɛn‑, ‑ɛ ꞊dʋ 'yɩ 'ʋ ‑nɩ, ‑ɛ yi ‑nyrɔwɔ a 'mʋ, 'bʋ 'yɩ ‑aan 'Baɩ Nyɩsʋa nɩ ‑do 'pa‑. ");
INSERT INTO ktj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Dɛ ‑bʋ, ‑ɛ mi la 'lu ‑mɔ, nyiblo ‑mʋ', ‑ɛ mɔ Noe a ti 'yri, ɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ di 'lu ‑mɔ mu, ti ‑mʋ', ‑ɛ kɔ 'yri 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n di di. ");
INSERT INTO ktj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Noe a ti 'yri, 'tɩ‑ 'nie 'mʋ la 'ʋ 'klɔ 'ʋ ‑ha, ‑tonyibli yɩ 'mle la lɛ, ʋ yɩ la didi‑tɛblɩ nɩ di, 'ʋ 'nɛ la nɔ, 'ʋ kʋkʋɛ la ‑nɩ, 'ʋ pʋɛ la 'waa 'yonʋ 'blɩ lɛ. Dɛ a 'mʋ, ɛ nɔ‑ ʋ 'ble kʋa ‑bleble, Noe 'ɛ pa la 'lɩ 'a 'mɩɩ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ʋ 'nɩ ‑hie꞊e lɩ ꞊dedede 'lu ‑mɔ lɛ, 'ɛ gba꞊a ‑gbagba, 'nu gbagbʋ 'ɛ bi ꞊hlɔn, 'a 'nie ‑mu 'yi mɔ, 'ɛ gba 'waa pɛpɛ, 'ɛ 'lɩla ꞊nʋ lɛ. ‑Nyrɔwɔ ‑kɔ 'kwli, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n di di, kɛ‑ nɩ ‑do, ɛ di ‑hʋan 'mʋ ꞊ti. ");
INSERT INTO ktj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nyibli nɩ 'hʋɛn, 'bʋ yɩ ‑kʋan nɩ ni, 'kɩ 'lɩ ‑ci nɩ ‑do kɩ, 'n di ‑ha 'ʋ nyiblo nɩ ‑do, 'mʋ 'ʋ ‑ɛ ‑bɩ bʋ hie. ");
INSERT INTO ktj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nʋgbɩ nɩ 'hʋɛn, 'bʋ yɩ ‑kʋbʋ nɩ dui, 'kɩ 'lɩ dugbe nɩ ‑do 'kwli, 'n di ‑ha 'ʋ nyiblo nɩ ‑do, 'mʋ 'ʋ ‑ɛ ‑bɩ bʋ hie. ");
INSERT INTO ktj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","'A ‑tɩ, ba nɩ 'ʋ ‑pleelɛ', a 'nɩ 'ŋmee 'lɩ, ‑ɛ nu꞊o, ‑nyrɔwɔ, 'aan Kʋkɔnyɔ di ya, a 'yɩ꞊ɩ ‑yi. ");
INSERT INTO ktj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","꞊Bʋ pʋ꞊ʋ 'kayukɔnyɔ a dɛ yɩ. 'Kayukɔnyɔ a 'mʋ, 'bʋ yi wɛn ‑haawɔ ‑mʋ', 'kɩ 'lɩ 'tɔlʋwɔ 'kwli, 'yiyrinyɔ di wɛn ya, ɛ di wɛn 'nɩ ‑ple, ‑ɛ di꞊e nu, 'yiyrinyɔ a 'mʋ, ɛ 'nɩ ꞊ha 'a 'kayu wa. ");
INSERT INTO ktj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","'A ‑tɩ, 'aan 'mumu, ba ‑wɛ ‑mɔ, ‑ɛ nu꞊o, ti ‑mʋ', a 'yɛ nɩ di꞊e 'lu ‑mɔ lɛ nɩ ‑hie, 'kɩ 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n di 'ʋ ‑dii ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","‑Tɛ ‑Yusu hla ‑tɩ a 'mʋ, ‑ɛ ‑bɩ ɛ pʋ 'ledʋ, ɛ wɛn: «Ba 'wɩ‑ ‑kʋannunyɔ ‑mʋ' yɩ, 'a 'masɛ ‑wɛ 'lɩ bʋ kuo ꞊wlʋ yɩ, ‑ɛ kɔ 'lu a lɛ‑hihie. Nyiblodʋ a 'mʋ, nɔ‑ 'a 'masɛ, 'bʋ yɩ 'dagba nɩ mi, ɛ di 'a 'kayu lɛ hie, ‑ɛ di꞊e nu, dɛditi 'bʋ nyre 'ʋ, ɛ 'mʋ 'a 'bio ‑kʋannunyibli 'a ‑nɛ ‑nyrɔwɔ a diidɛ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","'A 'masɛ 'bʋ ‑hɔn 'dagba', 'bʋ yɛɛ 'ʋ꞊ʋ ‑kʋan a 'mʋ 'yie bʋ, ‑ɛ ‑bɩ ‑kʋannunyɔ a 'mʋ, bʋ kɔ plɔ a bleelɛ. ");
INSERT INTO ktj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, 'a 'masɛ di nu꞊o 'a ‑tɛblɩ'yie꞊tunyɔ gbagbʋ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kɛɛ, ‑kʋannunyɔ a 'mʋ, 'a 'klɔ 'bʋ nyre yɩ, 'bʋ pʋ lɛ, ‑ɛ mɔ, 'a 'masɛ a didie yɩ 'ʋ 'nɩ ‑wlɛɛn ‑nɩ, ");
INSERT INTO ktj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","'bʋ ‑tʋa 'a 'bio ‑kʋannunyibli a bibie, 'tɩ‑, 'bʋ yɩ 'a dɩɔnʋ didi‑tɛblɩ kɔ nɔ 'hʋɛn‑ wlɔn nɩ ‑hie ‑nɩ, ɛ kɔ nɔ'nanyʋ 'hʋɛn‑, ");
INSERT INTO ktj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","‑ɛ ‑bɩ ‑nyrɔwɔ ‑mʋ', ‑kʋannunyɔ a 'mʋ, ɛ 'yɛ nɩ di 'ʋ nɩ ‑plee ‑nɩ, kɔ ‑haawɔ ‑mʋ', ɛ 'yɩ ‑yi, 'kɩ 'a 'masɛ a 'mʋ, ɛ di 'ʋ ‑dii ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","'Bʋ ‑di, ɛ di gba꞊a ti 'yaklɩ yɩ, 'tɩ ɛ 'mʋ꞊ʋ ꞊hɩʋɛn ꞊tu, ꞊wɩ yɩ nyibli ‑mʋ', ‑ʋ nɛɛ 'li nɩ 'hʋɛn. 'Kɩ ɛ di 'ʋ ꞊hien ‑wee ‑nɩ, kɔ, 'kɩ ɛ di 'ʋ yrʋ ‑pʋʋ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","(‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'a ‑nagbopʋ* yɩ, ɛ wɛn:) «Ti ‑mʋ', ‑ɛ kɔ 'yri Nyɩsʋa di 'ʋ nyibli win kɩ ‑kɔɔ ‑nɩ pɛpɛ, dɛ ɛ 'wɩ yɩ, ɛ nɔ‑ ‑bʋ: 'Yonʋ nyrɔyo nɩ ‑pu ꞊dʋ, ʋ nʋ‑ ʋ da 'blɩ a pʋpa kɩ. ‑Tɛ 'tɔ yɩ nɩ ‑wɛn, ‑ɛ ‑bɩ ʋ gba 'waa 'nyranapɩɩ nɩ, ʋ kɔ 'yu nyrɔyu ‑mʋ', ‑ɛ mi 'blɩ pa mɔ 'hʋɛn‑, 'ʋ mu 'a nyɩbɩʋ ‑ple mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","'Kɩ 'lɩ 'yonʋ nyrɔyo nɩ ‑pu a 'mʋ 'nyɩ, 'waa 'yɔ nɩ ꞊hun nɩ 'lɩ, 'ʋ kɔ ꞊tɔ, ꞊hun ‑bɩ 'ʋ nɩ 'ʋ, 'ʋ 'yɩ ꞊tɔ ‑kɔ. ");
INSERT INTO ktj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","'Yonʋ nyrɔyo ‑mʋ', ‑ʋ 'yɩ ꞊tɔ ‑kɔ, ‑tɛ ʋ yɩ 'waa 'napɩɩ nɩ gbɛ, ʋ 'yɩ 'nyrayrɩɩ ‑gba, ‑ɛ di꞊e nu, 'nyra 'bʋ ‑wɛ, ʋ 'mʋ 'lɩ 'a dɛ ‑bɩ pʋ. ");
INSERT INTO ktj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","'Waa dɛ ‑mʋ', ‑ʋ kɔ ꞊tɔ, ʋ nʋ‑ ‑mɔ ‑bɩ, ‑tɛ ʋ yɩ 'waa 'napɩɩ nɩ gbɛ, ‑ɛ ‑bɩ ʋ gba 'nyrayrɩɩ, ‑ɛ di꞊e nu, 'nyra 'bʋ ‑wɛ 'lɩ, ʋ 'mʋ 'lɩ 'a ‑dɛ ‑bɩ pʋ. ");
INSERT INTO ktj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","‑Tɛ ʋ ‑mu, 'blɩpanyɔ 'yɩ ‑di 'wʋwlɩ. Bʋ 'yɛ nɩ di, nɔ‑ nu꞊o, 'yonʋ nyrɔyo nɩ ‑pu a 'mʋ, 'waa 'yii 'ɛ yɩ yɩ ‑wɛ, 'ʋ bi ŋmena' lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","'Tɔ‑hɛyri', ‑ɛ ‑bɩ ʋ 'wɩn ‑cici. Kɛ‑ nyibli pɩ: Ba 'ye kɛ, 'blɩpanyɔ yɩ 'lɩ 'nɩ di, ba di 'lɩ, ba mu꞊o ye' 'bɛ! ");
INSERT INTO ktj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","‑Ɛ ‑bɩ 'yonʋ nyrɔyo nɩ ‑pu a 'mʋ, ʋ 'du ye', 'ʋ 'yaa 'waa 'napɩɩ 'lu lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","‑Ɛ ‑bɩ 'yonʋ nyrɔyo ‑mʋ', ‑ʋ 'yɩ ꞊tɔ ‑kɔ, ʋ wɛn: Ba ‑nyi ‑a mʋ 'aan 'nyra a dɛ, ‑ɛ nu꞊o, ‑aan 'napɩɩ ‑hʋɛ bʋ jre. ");
INSERT INTO ktj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Kɛɛ, ‑ɛ ‑bɩ 'waa 'bio ‑mʋ', ‑ʋ kɔ ꞊tɔ, ʋ wɛn: ‑Aan 'nyra, ‑a ‑kɔ, ɛ 'yɩ ‑hʋ, 'kɩ 'ʋ ‑aan pɛpɛ ‑mɔ'. Dɛ a kɔ ba nu, ɛ nɔ‑ mɔ, ba mu 'lɩ 'nyraplonyʋ ‑mɔ, a 'mʋ 'aan ‑nɛ ‑tɔ. ");
INSERT INTO ktj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","‑Ɛ ‑bɩ 'yonʋ nyrɔyo a 'mʋ, ‑ʋ 'yɩ ꞊tɔ ‑kɔ, ʋ mu nɩ, 'ʋ mu 'nyra ‑tɔ mɔ. 'Kɩ ʋ ‑mlɛɛ 'lɩ, 'blɩpanyɔ 'ɛ ‑di, 'yonʋ nyrɔyo nɩ ꞊hun ‑mʋ', ‑ʋ ‑wɛ ‑mɔ, ɛ kɔ ꞊nʋ 'hʋɛn‑, 'ʋ pa 'lɩ 'blɩpakayu bʋ. ‑Tɛ ʋ pa 'kɩ, ‑ɛ ‑bɩ ʋ ka 'ʋ 'maju nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","‑Tɛ ti gbi ‑hi, ‑ɛ ‑bɩ 'yonʋ nyrɔyo nɩ ꞊hun ‑mʋ', ‑ʋ mu wɛn 'nyra ‑tɔ mɔ, ʋ nyre 'ʋ nɩ, 'ʋ da 'blɩpanyɔ, ʋ wɛn: Nyɩbɛyu o, ‑ha ‑a mʋ 'maju yɩ! ");
INSERT INTO ktj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kɛɛ, ɛ ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, 'n 'yɩ 'a mʋ ‑yi.» ");
INSERT INTO ktj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ de, ɛ wɛn: «'A ‑tɩ, ba nɩ 'ʋ ‑pleelɛ', a 'nɩ 'ŋmee 'lɩ, ‑ɛ nu꞊o, ‑nyrɔwɔ kɔ ‑haawɔ ‑mʋ', 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n di ya, a 'yɩ꞊ɩ ‑yi.» ");
INSERT INTO ktj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Ti ‑mʋ', ‑ɛ kɔ 'yri Nyɩsʋa di 'ʋ nyibli win kɩ ‑kɔɔ ‑nɩ pɛpɛ, dɛ ɛ di yɩ 'wɩ, ɛ nɔ‑ ‑bʋ: Ɛ kɔ la nyɩbɛyu ꞊dʋ, ɛ nɔ‑ mi la 'dagba blɔblʋ. 'Tɩ‑ ɛ 'mʋ mu, ɛ da 'a ‑kʋannunyibli nɩ, 'ɛ hie ꞊nʋ 'a 'wli lɛ, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ kʋɛsɛ 'yri ‑hlaa ‑nɩ; ");
INSERT INTO ktj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","'ɛ ‑nyi 'a yɩ‑hɛnyiblo 'wliblɛ nɩ ꞊hun, 'ɛ ‑nyi 'hʋɛn a nyiblo 'wliblɛ nɩ 'hʋɛn, kɔ, 'ɛ ‑nyi ta a nyiblo 'wliblɔ nɩ ‑do. 'A ‑nɛ nyiblo 'bʋ nɩ 'ʋ, 'wliblɛ nɩ ‑tie ‑mʋ', ɛ ‑wɛ 'lɩ ‑kʋan a 'yrinuulɛ, ɛ nɔ‑ ɛ ‑nyi꞊e. ‑Tɛ ɛ ‑wɛ ‑kʋan a yɩblɛ꞊tutulɛ ‑mɔ, ‑ɛ ‑bɩ ɛ mu nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nyiblo ‑mʋ', ‑ɛ 'ye 'wliblɛ nɩ ꞊hun, ‑ɛ ‑bɩ ɛ mu nɩ, 'ɛ hlaa ꞊nɛ kʋɛsɛ 'yri, kʋɛsɛ a 'mʋ, 'ɛ pʋ 'ʋ꞊ʋ 'wliblɛ nɩ ꞊hun ‑bɩ. ");
INSERT INTO ktj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nyiblo ‑mʋ', ‑ɛ 'ye 'wliblɛ nɩ 'hʋɛn, kʋɛsɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ ɛ ‑hla, 'ɛ pʋ 'ʋ꞊ʋ 'wliblɛ nɩ 'hʋɛn ‑bɩ. ");
INSERT INTO ktj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kɛɛ, nyiblo ‑mʋ', ‑ɛ 'ye 'wliblɔ nɩ ‑do, ɛ nɔ‑ mɔ ‑bɩ, ɛ mu nɩ, 'ɛ 'blu ‑tʋtʋ, 'ɛ ‑hlii 'lɩ 'a 'masɛ a 'wliblɔ a 'mʋ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","‑Tɛ ɛ gba ti ‑hʋɔhʋɩ, ‑ɛ ‑bɩ 'waa 'masɛ di nɩ. ‑Tɛ ɛ ‑di, ‑ɛ ‑bɩ ɛ ‑tʋa 'a 'wli ‑nɩ wɛn, 'a ‑tɩ a lɛ'bɛtilɛ. ");
INSERT INTO ktj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","‑Ɛ ‑bɩ nyiblo ‑mʋ', ‑ɛ 'ye la 'wliblɛ nɩ ꞊hun, ɛ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, ɛ wɛn: 'Na 'masɛ o, 'wliblɛ nɩ ꞊hun, ‑nyi la 'mʋ, 'n hlaa ꞊nɛ kʋɛsɛ 'yri, 'ɛ pʋ 'ʋ 'wliblɛ nɩ ꞊hun ‑bɩ. Ɛ nɔ‑ ‑bʋ. ");
INSERT INTO ktj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‑Ɛ ‑bɩ 'a 'masɛ wɛn: Ɛ nu ‑tɛɛ. ‑Mɔ ꞊haan‑kʋannunyɔ ꞊nɩɔ. Nyiblo ‑wɛ 'lɩ bʋ kuo ‑mʋ ꞊wlʋ yɩ nɩ. ‑Tɛblɩ ‑bʋ, ‑ɛ 'yɩ ‑hʋ, 'n ‑nyi ‑mʋ, ‑nuu ꞊nʋ ‑kʋan 'yri ‑tɛɛ. 'A ‑tɩ, 'n di ‑nyi ‑mʋ ‑tɛblɩ ‑hʋɔhʋɩ, ꞊mʋ ꞊nʋ ‑kʋan 'yri ‑nuu ‑nɩ. Di 'lɩ, ‑kɔ 'mʋ 'hʋɛn‑, ‑a 'mʋ lɛ 'mle. ");
INSERT INTO ktj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","‑Ɛ ‑bɩ nyiblo ‑mʋ', ‑ɛ 'ye la 'wliblɛ nɩ 'hʋɛn, ɛ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, ɛ wɛn: 'Na 'masɛ o, ‑nyi la 'mʋ 'wliblɛ nɩ 'hʋɛn. 'N hlaa ꞊nɛ kʋɛsɛ 'yri, 'ɛ pʋ 'ʋ 'wliblɛ nɩ 'hʋɛn ‑bɩ. Ɛ nɔ‑ ‑bʋ. ");
INSERT INTO ktj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‑Ɛ ‑bɩ 'a 'masɛ wɛn: Ɛ nu ‑tɛɛ. ‑Mɔ ꞊haan‑kʋannunyibli ꞊nɩɔ. Nyiblo ‑wɛ 'lɩ bʋ kuo ‑mʋ ꞊wlʋ yɩ nɩ. ‑Tɛblɩ ‑bʋ, ‑ɛ 'yɩ ‑hʋ, 'n ‑nyi ‑mʋ, ‑nuu ꞊nʋ ‑kʋan 'yri ‑tɛɛ. Di 'lɩ, ‑kɔ 'mʋ 'hʋɛn‑, ‑a 'mʋ lɛ 'mle. ");
INSERT INTO ktj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","‑Ɛ ‑bɩ nyiblo ‑mʋ', ‑ɛ 'ye la 'wliblɔ nɩ ‑do, ɛ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ ‑wɛ, ɛ wɛn: 'Na 'masɛ o, 'n yi꞊e nɩ, ‑ɛ mɔ, ‑na ŋmlɩ 'yakla nɩ. Dɛ ‑mʋ', ꞊yɩ 'dɔ, ɛ nɔ‑ ‑pʋ lɛ ‑bʋ 'cɛ. ");
INSERT INTO ktj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","'N pie la hʋannʋ. Ɛ nɔ‑ nu꞊o, 'nɩ 'blu la ‑tʋtʋ, 'wliblɔ ‑mʋ', ‑hie la 'mʋ lɛ, 'nɩ ‑hli la꞊a. 'A ‑tɩ, ‑na 'wliblɔ a 'mʋ, ɛ nɔ‑ ‑bʋ. ");
INSERT INTO ktj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","‑Ɛ ‑bɩ 'a 'masɛ ꞊tu꞊o ꞊wɔn, ɛ wɛn: ‑Mɔ ‑kʋannunyɔ ꞊nɩɔ, ‑ɛ kɔ 'klɔ ‑nyre yɩ, 'tɩ‑ ‑mli nɩ. ‑Yi꞊e nɩ, ‑ɛ mɔ, 'dʋdɔ‑tɛblɩ ‑mʋ', 'n 'yɩ 'dɔ, ɛ nɔ‑ 'n pʋ lɛ ꞊bʋ 'cɛ. ");
INSERT INTO ktj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","'A ‑tɩ, ‑blɛɛ wɛn yɩ ‑bʋ pʋ wɛn 'lɩ 'na 'wliblɔ ‑bakɩ', ‑ɛ di꞊e nu, didie ‑bʋ, 'n ‑di, 'mʋ wɛn 'lɩ 'na 'wliblɔ a 'mʋ 'lɩ ‑ha, ɛ kɔ dɛ ‑bʋ, ‑ɛ di wɛn 'ʋ꞊ʋ 'lu bi 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","‑Ɛ ‑bɩ 'masɛ a 'mʋ, ɛ lee nɛ 'a nyibli ‑bɩ, ɛ wɛn: Ba ‑ha꞊a 'wliblɔ a 'mʋ ‑jɩ', ba ‑nyi꞊e nyiblo ‑mʋ', ‑ɛ kɔ 'wliblɛ nɩ ‑pu. ");
INSERT INTO ktj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","'Ɛ mɔ ꞊han‑tɩ, 'a ‑nɛ nyiblo, ‑ɛ kɔ ‑tɛblɩ ‑hʋɔhʋɩ, ɛ nɔ‑ ʋ di ‑tɛblɩ ‑bɩ ‑nyi, ‑ɛ di꞊e nu, 'a ‑tɛblɩ ‑mʋ', ɛ ‑kɔ, ɛ 'mʋ ‑hʋ, ɛ 'mʋ꞊ʋ wlɔn ‑hi. Kɛɛ, nyiblo ‑mʋ', ‑ɛ kɔ ‑tɛblɩ ꞊yɩ ‑hʋ, ʋ kɔ bʋ ‑ha ꞊nɛ꞊ɛ ‑jɩ'. ");
INSERT INTO ktj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","‑Kʋannunyɔ ‑bʋ, ‑ɛ 'yɩ ꞊dedede a nulɛ ‑yi, ba pʋ 'lɩ꞊ɩ ‑patʋ', 'kɩ 'lɩ halɔ 'nyɩ. 'Kɩ ɛ di 'lɩ ꞊hien 'lɩ ‑wee ‑nɩ, kɔ, ɛ di 'ʋ yrʋ ‑pʋʋ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","(Kɛ‑ ‑Yusu pɩ 'a ‑nagbopʋ* yɩ de, ɛ wɛn:) «Ti ‑kɔ 'yri 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n di di, 'kɩ 'lɩ 'na bodɩɔtu 'kwli, 'n kɔ Nyɩsʋa a lɛlenyʋ 'hʋɛn‑, ‑a di di. 'Kɩ 'n di 'ʋ 'na bodɩɔgbata kɩ bʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dakɔ a pɛpɛ, ‑ʋ nɩ 'nɛ‑ ‑tʋtʋ kɩ, ʋ di lɛ 'nɩ 'kukue ‑nɩ, 'kɩ 'ʋ 'mʋ ye', 'mʋ ꞊nʋ 'yi lɛ ‑hɩhɩa ‑nɩ, ꞊wɩ yɩ ‑tɛ blablɩ'yie꞊tunyɔ ni, 'ɛ ‑hɩhɩɛ blablɩ kɔ wlo 'hʋɛn‑ 'yi lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ɛ ꞊hɛn 'nyrɛ, nyibli ‑bʋ, ‑ʋ ni la Nyɩsʋa a kɩwɛɛnlɛ, 'kɩ 'n di 'lɩ ꞊nʋ 'na diidɛkɩbɩa kɩ pʋ, ɛ kɔ, nyibli ‑bʋ, ‑ʋ 'yɛ nɩ nu la Nyɩsʋa a kɩwɛɛnlɛ, 'mʋ 'lɩ ꞊nʋ 'na kamlakɩbɩa kɩ pʋ. ");
INSERT INTO ktj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","'Tɩ‑ 'mɔ ‑bʋ, ‑ɛ mɔ bodɩɔ, 'mʋ nyibli ‑mʋ', ‑ʋ nɩ 'nɛ‑ 'na diidɛkɩbɩa kɩ ‑lee ‑nɩ: Ba di 'lɩ, 'a mʋ 'na 'Baɩ Nyɩsʋa nu ꞊haandɛ ‑mɔ, ba kɔ Nyɩsʋa a 'klɔ yrayrʋ ‑mʋ', ɛ pʋ la lɛ, ɛ di la 'a mʋ ‑nyi, ti ‑mʋ' ‑kɔ 'yri ɛ nu la 'klɔ. ");
INSERT INTO ktj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","‑Ɛ nu꞊o, ‑tɛ 'kanʋ ni la 'mʋ, a ‑nyi la 'mʋ dididɛ; ‑tɛ 'nie'natʋ ni la 'mʋ, a ‑nyi la 'mʋ 'nɩnanie; ‑tɛ 'n mɔ la 'dagbatayu, 'a paa la 'mʋ 'kayu bʋ; ");
INSERT INTO ktj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","‑tɛ 'n 'yɩ la 'hʋɩlɛpʋdɛ ‑kɔ, a ‑nyi la 'mʋ 'hʋɩlɛpʋdɛ, ‑tɛ 'n kɔ la 'hʋɩ a hinhren, a pɩa la 'mʋ nɩ; ɛ kɔ, ‑tɛ 'n nɩ la 'lɩ ꞊jɩ', a di la 'mʋ yɩ ‑mɛ mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","‑Ɛ ‑bɩ nyibli ‑mʋ', ‑ʋ ni la Nyɩsʋa a kɩwɛɛnlɛ, kɛ‑ ʋ di 'mʋ yɩ pʋ: Kʋkɔnyɔ, ti a 'dɩ ‑bɩ ‑kɔ 'yri ‑a 'ye ‑mʋ, 'kanʋ 'ɛ ni la ‑mʋ, ꞊a ‑nyi la ‑mʋ dididɛ 'lɩ; 'nie'natʋ 'ɛ ni la ‑mʋ, ꞊a ‑nyi la ‑mʋ 'nɩnanie 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ti a 'dɩ ‑bɩ ‑kɔ 'yri ‑mɔ la 'dagbatayu, ꞊a paa la ‑mʋ 'kayu bʋ 'lɩ? Ti a 'dɩ ‑bɩ ‑kɔ 'yri ꞊yɩ la 'hʋɩlɛpʋdɛ ‑kɔ, ꞊a ‑nyi la ‑mʋ 'hʋɩlɛpʋdɛ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ti a 'dɩ ‑bɩ ‑kɔ 'yri ‑a 'ye la ‑mʋ', ‑na 'hʋɩ hren la, kɔ, ꞊nɩ nɩ la ꞊jɩ', ꞊a di la ‑mʋ yɩ ‑mɛ mɔ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","‑Ɛ ‑bɩ, 'mɔ bodɩɔ, kɛ‑ 'n di ꞊nʋ yɩ pʋ: 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ, 'ba nu la ꞊haan‑tɛblɩ a 'mʋ 'na 'dɩayɩ ꞊dʋ, ‑ɛ 'yɩ 'mini ‑kɔ 'yi ꞊hlɔn lɛ, ɛ ꞊hɛn 'nyrɛ, ‑ɛ mɔ, 'mɔ a nu la꞊a 'yi ꞊hlɔn lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","'Bʋ ‑hi, 'tɩ‑ 'mɔ bodɩɔ, nyibli ‑mʋ', ‑ʋ nɩ 'lɩ 'na kamlakɩbɩa kɩ, 'mʋ ꞊nʋ ‑lee ‑nɩ, ba 'yɩya 'lɩ 'mʋ bʋ, 'a mʋ ‑mʋ', Nyɩsʋa pʋ 'jrɔ yɩ. Ba mu 'lɩ na ‑mʋ', ‑ɛ 'yɛ nɩ jre 'nyɩ. Na a 'mʋ, Nyɩsʋa ‑wɛ꞊ɛ ‑mɔ, 'kɩ 'ʋ 'kuo ‑hʋɩn* a nyiblo gbagbʋ kɔ 'a ‑hɛɛnyʋ 'hʋɛn‑ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","‑Ɛ nu꞊o, ‑tɛ 'kanʋ ni la 'mʋ, a 'yɩ la 'mʋ dididɛ ‑nyi; ‑tɛ 'nie'natʋ ni la 'mʋ, a 'yɩ la 'mʋ 'nɩnanie ‑nyi; ");
INSERT INTO ktj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","‑tɛ 'n mɔ la 'dagbatayu, a 'yɩ la 'mʋ 'kayu bʋ ‑paa ‑nɩ; ‑tɛ 'n 'yɩ la 'hʋɩlɛpʋdɛ ‑kɔ, a 'yɩ la 'mʋ 'hʋɩlɛpʋdɛ ‑nyi; ‑tɛ 'na 'hʋɩ yɩ la hren, kɔ, ‑tɛ 'n nɩ la ꞊jɩ', a 'yɩ la 'mʋ yɩ ‑mɛ. ");
INSERT INTO ktj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","‑Ɛ ‑bɩ kɛ‑ nyibli a 'mʋ, ʋ di 'mʋ yɩ pʋ: Kʋkɔnyɔ, ti a 'dɩ ‑bɩ ‑kɔ 'yri, ‑a 'ye la ‑mʋ, 'kanʋ 'ɛ ni la ‑mʋ, 'nie'natʋ 'ɛ ni la ‑mʋ, ꞊nɩ mɔ la 'dagbatayu, ꞊nɩ 'yɩ la 'hʋɩlɛpʋdɛ ‑kɔ, ‑na 'hʋɩ 'ɛ hren la, kɔ, ꞊nɩ nɩ la 'lɩ ꞊jɩ', 'tɩ‑ ꞊a 'yɩ la ‑mʋ kɩ ‑dii ‑nɩ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","‑Ɛ ‑bɩ 'mɔ bodɩɔ, kɛ‑ 'n di ꞊nʋ yɩ pʋ: 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ, 'a ‑nɛ ti, 'bʋ mɔ, 'ba 'yɩ la ꞊haan‑tɛblɩ a 'mʋ 'na 'dɩayɩ ꞊dʋ, ‑ɛ 'yɩ 'mini ‑kɔ 'yi ꞊hlɔn lɛ ‑nu, ɛ 'wɩ yɩ, 'mɔ a 'yɩ la꞊a 'yi ꞊hlɔn lɛ ‑nu. ");
INSERT INTO ktj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","‑Tɛblɩ a 'mʋ, a ‑tɩ, Nyɩsʋa di gba 'lɩ ꞊nʋ ‑tɩtɛ ‑bɩ, ‑tɛ ʋ di 'lɩ ꞊nʋ ꞊hɩʋɛn ꞊tuu ‑nɩ, ꞊hɩʋɛndʋ ‑mʋ', ‑ɛ 'yɛ di 'lɩ nɩ ‑wɛ 'klɔ ‑mɔ 'klɔ. Kɛɛ, nyibli ‑mʋ', ‑ʋ ni la Nyɩsʋa a kɩwɛɛnlɛ, ʋ nʋ‑ di 'lɩ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ 'kwli pa.» ");
INSERT INTO ktj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","‑Tɛ ‑Yusu ‑wɛ 'kɩ ‑tɛblɩ a pɛpɛ a 'mʋ, 'a tɔɔlɛ ‑mɔ, ‑ɛ ‑bɩ kɛ‑ ɛ pɩ 'a ‑nagbopʋ* yɩ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«A yi꞊e nɩ, ‑ɛ mɔ, ɛ hie 'lɩ ‑nyrɔwɩ nɩ 'hʋɛn, ‑aan lɛ'mimle, ʋ dɛɛ Pakɩ, ɛ 'mʋ 'ʋ nyre. Ti a 'mʋ 'yri, 'kɩ ʋ di 'ʋ 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo 'na yraanyibli ‑jɩ' pʋ, ‑ɛ di꞊e nu, ʋ 'mʋ 'ʋ 'mʋ tugbɛ 'yie ‑kɔɔ ‑nɩ, ʋ 'mʋ 'mʋ 'la.» ");
INSERT INTO ktj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ti nɩ ‑do a 'mʋ 'yri, 'kɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ, kɔ ‑Juukʋɛ a naanyʋ 'hʋɛn‑, ʋ 'kukue lɛ, 'kɩ 'lɩ ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ a ‑tɛ. Nyiblo a 'mʋ, 'a 'nyrɛ mɔ Kaifʋ. ");
INSERT INTO ktj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","'Waa pɛpɛ, ʋ ‑yra꞊a nɩ, 'kɩ bʋ nu ꞊yrɛ, bʋ klɔ ‑Yusu, ʋ 'mʋ꞊ʋ 'la. ");
INSERT INTO ktj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kɛ‑ ʋ pɩ, ‑ɛ mɔ: «'Bʋ mɔ, ꞊ba yɩ꞊ɩ nɩ kwlɛ, ‑a 'nɩ 'nuo 'lɩ꞊ɩ lɛ'mimle a ti 'yri, ‑ɛ di꞊e nu, nyibli 'nɩ ꞊ha ‑a mʋ ‑mɔ ‑wɔn mɔ di.» ");
INSERT INTO ktj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ti a 'mʋ 'yri, 'kɩ ‑Yusu nɩ 'lɩ Betanidɩɔ 'kwli, ɛ kɔ 'a ‑nagbopʋ* 'hʋɛn‑. 'Kɩ ʋ nɩ 'lɩ Simɔ a ‑tɛ. Simɔ a 'mʋ, ꞊hran nu la꞊a nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Bʋ yɩ 'kɩ dɛ nɩ di, ‑ɛ ‑bɩ nʋgba ꞊dʋ, ɛ nɔ‑ pa 'kayu bʋ, 'ɛ 'ble ‑dawinniyrɩɛ kʋa. ‑Dawinni a 'mʋ, ɛ kɔ 'a 'yrɩɛ 'hʋɛn‑, ʋ pɩ ꞊die dɩakɩ. ‑Tɛ ɛ ‑pa 'kɩ, ‑ɛ ‑bɩ ɛ 'yɩya 'ʋ ‑Yusu 'hʋɩ bʋ, 'ɛ pʋ ‑Yusu ‑dawinni a 'mʋ 'lu. ");
INSERT INTO ktj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","‑Tɛ ‑Yusu a ‑nagbopʋ 'ye dɛ a 'mʋ, ‑ɛ ‑bɩ ʋ bi yrʋ' lɛ, ʋ wɛn: «Dɛ‑ kɔ ‑dawinni ‑bʋ, 'a lɛcɩcralɛ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","'Bʋ plo wɛn꞊ɛ, ɛ di 'ye wɛn 'wliyɛ, ʋ 'mʋ wɛn꞊ɛ ꞊hɩʋɛnnyibli ‑nyi.» ");
INSERT INTO ktj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","‑Tɛ ‑Yusu 'ye꞊e, ‑ɛ mɔ, ʋ bi yrʋ' lɛ, ‑ɛ ‑bɩ ɛ wɛn: «Ba ‑ha꞊a mɛ lɛ, ba 'kee nɛ 'a ‑mɔ'pʋplɛ. Dɛ ‑bʋ, ɛ ‑nu, 'kɩ 'ʋ 'mʋ ‑mɔ, ɛ mɔ yɩnɔdɛ ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ba yi꞊e, ‑ɛ mɔ, ꞊hɩʋɛnnyibli 'tɩɛ di 'nɛ‑ 'a mʋ 'nyɩ nɩ, a 'mʋ ꞊nʋ ꞊haan‑tɛblɩ ‑mɔ nu. Kɛɛ, 'mɔ ‑bɩ, ti ‑bʋ, 'n di 'nɛ‑ 'a mʋ 'nyɩ ‑hi, ɛ 'yɩ ‑hʋ. ");
INSERT INTO ktj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Dɛ ‑bʋ, nʋgba ‑bʋ, ɛ ‑nu, ɛ nɔ‑ ‑mɔ: ‑Tɛ ɛ di wɛn nu, ɛ 'mʋ wɛn 'na ‑plahʋɩ ‑dawinni klɛ 'wla, 'kɩ 'ʋ 'a 'ʋ‑hɩhɩa a ‑ta', ɛ nɔ‑ ɛ ‑wɛ nunuo ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ, 'a ‑nɛ ‑tɩtɛ ꞊dʋ, ʋ di 'ʋ Nyɩsʋa a ꞊haantitie 'ʋ ‑pʋʋ ‑nɩ, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, ꞊haandɛ ‑bʋ, nʋgba ‑bʋ, ɛ ‑nu, ʋ di 'a ‑tɩ ‑mɔ lɛ 'nɩ na, ‑ɛ di꞊e nu, ɛ 'nɩ ꞊ha nyibli ‑mɔ ‑hru.» Kɛ‑ ‑Yusu ‑pʋ. ");
INSERT INTO ktj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","‑Tɛ dɛ 'a mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu a ‑nagbopi* ‑bɩ, 'kɩ 'lɩ 'a ‑nagbopʋ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn ‑mʋ' 'nyɩ, ‑ɛ kɔ 'nyrɛ mɔ Judɩa Yisikalio, ɛ nɔ‑ mu 'lɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ ‑mɔ, ");
INSERT INTO ktj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ɛ wɛn: «'Bʋ mɔ, 'nɩ pʋ 'a mʋ ‑Yusu ‑jɩ', dɛ‑ a di 'mʋ ‑nyi 'lɩ?» Ɛ nɔ‑ mɔ bʋ ‑nyi꞊e 'wliyɔ a (30) ‑wlʋ ꞊tu 'ʋ ‑pu. ('Wliyɛ a 'mʋ, ɛ ‑hʋ nɩ dɩakɩ.) ");
INSERT INTO ktj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kʋɛ 'ʋ ti a 'mʋ 'yri bʋ, Judɩa ‑tʋa ꞊tɔ a lɛ꞊mʋmʋɔ, ‑tɛ ‑mʋ', ɛ di nu, ɛ 'mʋ ꞊nʋ ‑Yusu ‑jɩ' pʋ. ");
INSERT INTO ktj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lɛ'mimle ‑mʋ', ‑ɛ mɔ Pakɩ, 'a yɩ‑hɛ‑nyrɔwɔ, 'kɩ ʋ yɩ 'ʋ 'flɔɔdʋ ‑mʋ', ‑ɛ kɔ ‑mɔ ʋ 'yɛ nɩ pʋ 'lɩ 'yaadɛ ‑dii ‑nɩ. ‑Tɛ ‑nyrɔwɔ a 'mʋ, ɛ nyre 'ʋ, ‑ɛ ‑bɩ ‑Yusu a ‑nagbopʋ mu 'ʋ ‑Yusu 'hʋɩ, 'ʋ 'bɛti꞊e, ʋ wɛn: «‑Bɩ' ‑hʋɛ ‑ba pii 'kɩ Pakɩ a diidɛ yɩ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «Ba mu 'lɩ Jrusrɛdɩɔ 'kwli, 'kɩ 'lɩ nyiblo ‑mʋ', ‑kɔtɩ 'n lee nɛ 'a mʋ ‑mɔ, ba lee ꞊nɛ, ‑ɛ mɔ: ‑Aan tɔɔnyɔ wɛn 'nɩ, 'a ti ‑mʋ', Nyɩsʋa wa 'nyrɛ, ɛ nyre 'ʋ nɩ. 'Kɩ 'nɛ‑ ‑mʋ ‑mɔ, 'kɩ ɛ di 'nɛ‑ Pakɩ a diidɛ ‑dii ‑nɩ, ɛ kɔ 'a ‑nagbopʋ 'hʋɛn‑.» ");
INSERT INTO ktj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","‑Tɩ a 'mʋ, ‑Yusu lee nɛ 'a ‑nagbopʋ, ɛ nɔ‑ ʋ ‑nu, 'ʋ pi Pakɩ a diidɛ a 'mʋ. ‑Tɛ ʋ ‑wɛ 'a pipie ‑mɔ, ‑ɛ ‑bɩ ʋ ‑mɛ kle. ");
INSERT INTO ktj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","‑Tɛ 'yrʋ ‑wɛ 'lɩ yakɔ 'kwli lɛ, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn a 'mʋ 'hʋɛn‑, ʋ nyre 'lɩ 'kayu ‑mʋ', ‑ɛ kɔ bʋ ʋ di 'lɩ Pakɩ a diidɛ 'lɩ ‑dii ‑nɩ 'kwli nɩ, 'ʋ nɩ blɛ, 'ʋ ‑tʋa dididɛ a didie. ");
INSERT INTO ktj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bʋ yɩ 'kɩ dɛ nɩ di, ‑ɛ ‑bɩ ‑Yusu wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, nyiblo nɩ 'nɛ‑ 'a mʋ 'nyɩ. Ɛ nɔ‑ di 'mʋ 'na yraanyibli ‑jɩ' pʋ, ‑ʋ ꞊mʋɛ 'na 'lɩla lɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","‑Tɛ ʋ 'wɩn ‑tɩ a 'mʋ, ‑Yusu ‑hla, ‑ɛ ‑bɩ 'waa ꞊wlɩ 'mʋɛ bʋ dɩakɩ. Kɛ‑ 'waa dodoyo, ʋ pɩ, 'ʋ yɩ 'bɛti ‑nɩ: «Kʋkɔnyɔ o, ꞊bɩ 'mɔ ꞊nɩɔ?» ");
INSERT INTO ktj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","‑Ɛ bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «'Kɩ 'lɩ 'a mʋ 'nyɩ, 'kɩ nyiblo nɩ 'lɩ, ‑ɛ kɔ 'mʋ 'hʋɛn‑, ‑a 'nyra 'lɩ dɛdihu nɩ ‑do dabʋ 'kwli. Ɛ nɔ‑ di꞊e nu. ");
INSERT INTO ktj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","'Ɛ mɔ ꞊han‑tɩ, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n kɔ ꞊bʋ 'kʋ, ꞊wɩ yɩ ‑tɛ ʋ nu la 'a 'cɩcrɩɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, kɛɛ, 'jrɔ 'kɩ 'ʋ nyiblo ‑mʋ' ‑mɔ', ‑ɛ di 'mʋ 'na yraanyibli ‑jɩ' pʋ. Ɛ nɔɔ 'ʋ lɛ, 'kɩ ʋ 'nɩ 'kɔɔ wɛn 'lɩ nyiblo a 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","‑Ɛ ‑bɩ Judɩa ‑mʋ', ‑ɛ di ‑Yusu 'a yraanyibli ‑jɩ' pʋ, ɛ 'bɛti nɩ ‑wɛ, ɛ wɛn: «Tɔɔnyɔ o, ꞊bɩ 'mɔ ꞊nɩɔ?» ‑Ɛ ‑bɩ ‑Yusu wɛn: «Iin, ‑mɔ ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bʋ 'tɩɛ nɩ 'kɩ 'ʋ dɛdihu kɩ, ‑ɛ ‑bɩ ‑Yusu 'du 'flɔɔ ye', 'ɛ ‑nyi Nyɩsʋa 'wio, 'tɩ‑ 'ɛ 'bɛ꞊ɛ ꞊tɩɔ lɛ, 'ɛ ‑nyi꞊e 'a ‑nagbopʋ*, ɛ wɛn: «Ba 'du꞊o ye', ba di꞊e. Ɛ nɔ‑ mɔ 'na 'hʋɩ,» ");
INSERT INTO ktj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","'ɛ 'du ‑wiin‑ŋanʋ ye', 'ɛ ‑nyi Nyɩsʋa 'wio, 'ɛ ‑nyi ꞊nʋ꞊ʋ, ‑ɛ ‑bɩ ɛ wɛn: «'Aan pɛpɛ, ba 'na. ");
INSERT INTO ktj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ɛ nɔ‑ mɔ 'na ‑hlʋ. Ɛ nɔ‑ 'n di bʋ 'wla, 'kɩ 'ʋ ‑tonyibli ‑hʋɔhʋɩ a dɛ 'kuku a ‑ta', Nyɩsʋa 'mʋ꞊ʋ nu, ɛ 'mʋ 'yrɩ yrayrɩ ꞊tu, ɛ kɔ ‑tonyibli 'hʋɛn‑, ‑ɛ di꞊e nu, ɛ 'mʋ 'waa dɛ 'kuku 'wʋwla ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, kʋɛ 'kɩ mɔ bʋ, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ 'na 'kɩ nɔdʋ ‑bʋ de, ɛ 'mʋ ‑nyrɔwɔ ‑mʋ' kɩ yɛ, ‑ɛ kɔ 'kwli 'n di 'lɩ nɔ yrayrɩdʋ ‑bɩ ‑mʋ' 'lɩ 'naa ‑nɩ, 'n kɔ 'a mʋ 'hʋɛn‑, 'kɩ 'lɩ 'na 'Baɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ʋ ble ‑wla, 'tɩ‑ 'ʋ 'du ye', 'ʋ ꞊tɩ 'dɩɔ, 'ʋ mu 'lɩ dʋgba ‑mʋ' 'lu, ‑ɛ kɔ 'lu olifieti nɩ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","‑Tɛ ʋ nyre 'lɩ, ‑ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'a ‑nagbopʋ* yɩ, ɛ wɛn: «'Kɩ 'lɩ 'tɔlʋwɔ ‑bʋ 'kwli, ti di 'ʋ 'nɩ nyre, a 'mʋ 'ʋ 'mʋ 'hʋɩ lɛ ‑gbɛ, ꞊wɩ yɩ ‑tɛ ʋ nu la 'a 'cɩcrɩɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ: Nyɩsʋa wɛn 'nɩ: 'N di 'blakɔnyɔ 'nɩ 'la, blablɩ a ꞊ju 'mʋ ‑gbɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ de, ɛ wɛn: «'Bʋ mɔ, 'nɩ 'kʋ, 'nɩ 'hrɩ 'klɔ, 'kɩ 'n di 'lɩ Galileblʋgba 'kwli mu, 'mʋ 'lɩ 'a mʋ 'lɩ ‑plee ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","‑Ɛ ‑bɩ Piɛlɩ pʋ win, ɛ wɛn: «'Ye ꞊bɩɩ 'waa pɛpɛ, bʋ hie 'ʋ ‑mʋ bʋ, 'mɔ ‑bʋ, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ hie 'ʋ ‑mʋ bʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","‑Ɛ ‑bɩ ‑Yusu wɛn: «'N yɩ ‑mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ, 'kɩ 'lɩ 'tɔlʋwɔ nɩ ‑do ‑bʋ 'kwli, 'tɩ‑ hapɛ 'mʋ ‑nyrɛ da mɔ mu, ‑di nu ‑gaawɩ nɩ ta, ‑ɛ mɔ, ꞊yɩ 'mʋ ‑yi.» ");
INSERT INTO ktj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","‑Ɛ ‑bɩ Piɛlɩ wɛn: «'Ʋʋn‑, 'ye ꞊bɩɩ 'n di 'kʋ, 'n kɔ ‑mʋ 'hʋɛn‑, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ hla꞊a, ‑ɛ mɔ, 'n 'yɩ ‑mʋ ‑yi.» ‑Nagbopʋ a pɛpɛ a 'mʋ, ‑tɩ nɩ ‑do a 'mʋ, Piɛlɩ ‑hla, ɛ nɔ‑ ʋ ‑hla ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, 'kɩ ʋ nyre 'lɩ 'dʋdɔti a ‑ci ‑mʋ', ʋ dɛɛ Gɛsɩmanɩ 'kwli. Kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «Ba nɩ mɔ bʋ, ꞊bʋ mu 'lɩ ye', 'mʋ 'lɩ Nyɩsʋa ‑mɔ ‑hlee ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","‑Tɛ ɛ yɩ 'kɩ nɩ mi, ‑ɛ ‑bɩ ɛ da Piɛlɩ kɔ Sebede a 'yonʋ Sakɩ kɔ Saan 'hʋɛn‑, ʋ kɔ꞊ɔ 'hʋɛn‑ 'ʋ ‑mu. Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ 'a ꞊wlʋ 'mʋɛ bʋ. Hʋannʋ ni꞊e nɩ dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «'Na ꞊wlʋ 'mʋɛ bʋ dɩakɩ. 'Na ꞊wlʋ a bʋ'mʋmʋɛ a 'mʋ, ɛ ‑hʋɛ bʋ 'la 'mʋ. A kɔ 'mʋ 'hʋɛn‑, ‑ba nɩ mɔ bʋ, a 'nɩ 'ŋmee 'lɩ,» ");
INSERT INTO ktj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","'ɛ hlɔɔ ꞊nʋ ‑mɔ lɛ dɛ gbe, 'ɛ bla kwlɩ bʋ, 'ɛ kɔ 'lu bʋ, 'ɛ nyɛɛ Nyɩsʋa lɛ, ɛ wɛn: «'Na 'Baɩ o, 'bʋ mɔ, 'bʋ ‑wɛ 'lɩ꞊ɩ 'lɩ, nu꞊o, ꞊hɩʋɛn ‑bʋ, 'n mi 'ye mɔ, bʋ hlɔɔ 'mʋ ‑mɔ lɛ. Kɛɛ, ɛ 'yɩ dɛ ‑mʋ', 'mɔ ‑bʋ, 'n ‑hʋɛ 'pa‑, kɛɛ, dɛ ‑mʋ', ‑na ꞊gbɛtʋ ‑hʋɛ, ɛ nɔ‑ ‑bʋ mu 'lu ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","‑Tɛ ɛ ‑wɛ 'pʋplɛ ‑mɔ, ‑ɛ ‑bɩ ɛ ꞊hɩan ‑mɔ, 'ɛ mu 'ʋ 'a ‑nagbopʋ nɩ ta a 'mʋ 'hʋɩ, 'ɛ yɛɛ 'ʋ ꞊nʋ ŋmena a ŋmeelɛ' bʋ. ‑Ɛ ‑bɩ kɛ‑ ɛ pɩ Piɛlɩ yɩ, ɛ wɛn: «꞊Bɩ a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba nu ‑haawɔ nɩ ‑do, a kɔ 'mʋ 'hʋɛn‑, 'kɩ ba 'yɩ ‑ŋme? ");
INSERT INTO ktj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","A 'nɩ 'ŋmee 'lɩ, kɛɛ, ba da Nyɩsʋa, ‑ɛ di꞊e nu, dɛ 'bʋ yɩ꞊ɩ nɩ ‑hʋɛ bʋ ꞊tɛɛ 'ʋ 'a mʋ lɛ, 'kɩ ba ‑hɛɛ Nyɩsʋa a ‑tɩ lɛ, a 'nɩ ꞊ha 'a ‑tɩ lɛ ‑hɛɛ ‑nɩ. 'N yi꞊e nɩ, ‑ɛ mɔ, 'aan ꞊wlɩ ‑hʋɛ꞊ɛ nɩ dɩakɩ, 'kɩ a 'nɩ 'ŋmee 'lɩ, a 'mʋ Nyɩsʋa da, kɛɛ, 'bʋ mɔ, Nyɩsʋa 'bʋ 'yɛ nɩ ‑hɛɛ nɛ 'a mʋ, 'a mʋ 'nɩ ‑do, a 'yɩ 'klɩ ‑kɔ, 'kɩ ba nu dɛ a 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ɛ hlɔɔ ꞊nʋ ‑mɔ lɛ de, 'ɛ nyɛɛ Nyɩsʋa lɛ, ɛ wɛn: «'Na 'Baɩ o, 'bʋ mɔ, ꞊hɩʋɛn ‑bʋ, 'n kɔ ꞊bʋ 'ye, 'bʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ hlɔɔ 'mʋ ‑mɔ lɛ, ‑ɛ ‑bɩ dɛ ‑bʋ, ‑na ꞊gbɛtʋ ‑hʋɛ, ɛ nɔ‑ ‑bʋ pa 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","‑Tɛ ɛ ‑wɛ ‑mɔ de, ‑ɛ ‑bɩ 'kɩ ɛ mu 'lɩ ꞊nʋ 'hʋɩ. ‑Tɛ ɛ ‑mu, ‑ɛ ‑bɩ 'kɩ ɛ yɛɛ 'ʋ ꞊nʋ ŋmena a ŋmeelɛ' bʋ de, ‑ɛ nu꞊o, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ pʋ 'yii lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ɛ nɔ‑ mɔ bʋ hlɔɔ ꞊nʋ ‑mɔ lɛ de, bʋ mu Nyɩsʋa a lɛnyaawɩ nɩ ta a dɛ ‑mɔ. Win nɩ ‑do ‑mʋ', ɛ pʋ wɛn, ɛ nɔ‑ ɛ ‑pʋ de. ");
INSERT INTO ktj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","‑Ɛ ‑bɩ ɛ ꞊hɩan ‑mɔ de, 'ɛ mu 'ʋ 'a ‑nagbopʋ 'hʋɩ, ɛ wɛn: «꞊Bɩ a yɩ 'nɩ ŋme de, 'a ‑hɛ 'lɩ ke lɛ? Ba 'ye kɛ, ti 'mʋɛ yrɛ, 'kɩ bʋ pʋ 'mʋ dɛ'kukununyʋ ‑jɩ', 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo. ");
INSERT INTO ktj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ba 'du ye', ‑a 'mʋ mu, ‑ɛ nu꞊o, nyiblo ‑mʋ', ‑ɛ di 'mʋ 'na yraanyibli ‑jɩ' pʋ, 'kɩ ɛ yɩ 'lɩ di.» ");
INSERT INTO ktj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Win nɩ 'lɩ ‑Yusu wlɔn, ‑ɛ ‑bɩ Judɩa, ‑ɛ mɔ ‑Yusu a ‑nagbopʋ* nɩ ‑pu ꞊tu 'ʋ 'hʋɛn a nyiblo ‑bɩ, ɛ nyre 'ʋ nɩ, ɛ kɔ nyibli ‑hʋɔhʋɩ 'hʋɛn‑. Nyibli a 'mʋ, ʋ 'ble ta‑wɔn‑tɛblɩ kɔ ti 'hʋɛn‑ kʋa lɛ. Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ, kɔ ‑Juukʋɛ a naanyʋ ‑bɩ 'hʋɛn‑, ʋ nʋ‑ lee nyibli a 'mʋ, 'kɩ bʋ mu ‑Yusu klɔ. ");
INSERT INTO ktj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judɩa a 'mʋ, ‑ɛ di ꞊nʋ ‑Yusu ‑jɩ' pʋ, 'tɩ‑ ʋ 'mʋ 'hru wlɔn bi, kɛ‑ ɛ pʋ ꞊nʋ yɩ: «Nyiblo ‑mʋ', 'n di 'wlɛɛ ‑nɩ, 'n di 'wio ‑nyi, ɛ nɔ‑ ba klɔ, ɛ 'nɩ ꞊ha 'a mʋ ‑jɩ' ꞊ta.» ");
INSERT INTO ktj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","‑Tɛ ʋ nyre 'kɩ 'ʋ, ‑ɛ ‑bɩ Judɩa 'yɩya 'ʋ ‑Yusu 'hʋɩ bʋ, ɛ wɛn: «Tɔɔnyɔ o, 'n yɛ ‑mʋ kɩ,» 'ɛ 'wlɛɛ ꞊nɛ. ");
INSERT INTO ktj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","‑Ɛ ‑bɩ ‑Yusu wɛn: «'Bɩhɩan o, dɛ ‑bʋ, ‑di nu mɔ, nu꞊o, ꞊mʋ mu.» ‑Ɛ ‑bɩ ti nɩ ‑do a ti 'yri, nyibli ‑mʋ', Judɩa ‑gba, ʋ 'yɩya 'ʋ ‑Yusu 'hʋɩ bʋ, 'ʋ klɔ꞊ɔ. ");
INSERT INTO ktj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nyɩsʋa a ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ, 'a ‑kʋannunyɔ ‑bɩ, ɛ nɩ ‑tuo kɩ ‑wɛ. Nyɩbɛhɩan a 'mʋ, ɛ nɔ‑ kɔ nʋa, ‑Yusu a ‑nagbopi ‑bɩ ‑ha 'lɩ 'a 'plɩɛn bɔ 'kwli, ɛ 'bɛ 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","‑Ɛ ‑bɩ ‑Yusu wɛn: «'Nyra 'lɩ ‑na 'plɩɛn bɔ 'kwli, ‑kɔtɩ nyibli a pɛpɛ ‑mʋ', ‑ʋ ni 'plɩɛn, ‑ʋ ‑wɛn, nyibli ‑bɩ di nu 'plɩɛn, ʋ 'mʋ ꞊nʋ 'la ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","꞊Yɩ꞊ɩ ‑yi, ‑ɛ mɔ, 'n ‑wɛ 'lɩ ꞊bʋ lee wɛn 'na 'Baɩ nɩ, 'kɩ bʋ ‑hɛɛ wɛn 'mʋ. Ɛ di ya wɛn 'mʋ lɛlenyʋ a 'miliwɩ a 'miliwɩ yɩ, ‑ɛ di꞊e nu, ʋ 'mʋ wɛn 'mʋ kɩ ‑dii ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kɛɛ, 'bʋ mɔ, 'bʋ nɩ 'mʋ lɛ, ɛ 'wɩ yɩ, dɛ ‑mʋ', ʋ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ kɔ ‑bʋ mu wɛn 'lu ‑mɔ, dɛ a 'mʋ, ɛ 'yɩ 'lɩ꞊ɩ ‑wɛ, bʋ mu wɛn 'lu ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ nyibli ‑mʋ', ‑ʋ di꞊e klɔ mɔ yɩ, ɛ wɛn: «Ta‑wɔn‑tɛblɩ kɔ ti 'hʋɛn‑, ɛ nɔ‑ a ‑ya, 'a di 'mʋ 'klɔ mɔ, ꞊wɩ yɩ ‑tɛ ʋ ni ‑balʋnyɔ a kʋklɔ. 'Tɩ‑, 'a ‑nɛ ti, 'n nɩ la 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli, 'kɩ 'lɩ 'a mʋ 'nyɩ, 'nɩ tʋɛ la nyibli ‑bɩ, kɛɛ, a 'yɩ la 'mʋ ‑klɔ. ");
INSERT INTO ktj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","‑Tɛblɩ a pɛpɛ ‑bʋ, ɛ mu 'lu ‑mɔ, ‑ɛ di꞊e nu, ‑tɩ ‑mʋ', Nyɩsʋa a winwlɔn‑hanyʋ* 'crɩ la, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ɛ 'mʋ ‑nue ‑nɩ.» ‑Tɛ ‑Yusu pʋ 'kɩ lɛ, ‑ɛ ‑bɩ 'a ‑nagbopʋ a pɛpɛ, ʋ ‑gbɛ꞊ɛ 'hʋɩ lɛ, 'ʋ 'gba ci lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ nyibli ‑mʋ', ‑ʋ klɔ ‑Yusu, 'kɩ ʋ gbɛ 'lɩ꞊ɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* a nyiblo gbagbʋ a 'kayu bʋ. Nyiblo a 'mʋ, 'a 'nyrɛ mɔ Kaifʋ. 'Kɩ 'lɩ 'kayu a 'mʋ bʋ, 'kɩ Nyɩsʋa a tetetɔɔnyʋ, kɔ 'blʋgba a naanyʋ 'hʋɛn‑, ʋ 'kukue 'lɩ lɛ, ‑gbolugbo a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piɛlɩ ‑mɔ ‑bɩ, ɛ yɩ kʋɛ ‑Yusu ꞊wien, 'kɩ 'lɩ ‑mɔhlɔɔlɛ 'kwli, 'ɛ ‑hɛ 'lɩ 'waa ꞊pɩ lɛ, 'ʋ ‑mu ‑mumu, 'ʋ nyre 'lɩ ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ a ‑yaa 'kwli, 'ɛ pa 'lɩ. Nyɩsʋa a 'kagbaʋ a 'yie꞊tunyʋ nɩ 'lɩ ‑wɛ. Nyibli a 'mʋ, ʋ nʋ‑ kɔ 'nyɩ Piɛlɩ nɩ 'lɩ bʋ, ‑ɛ di꞊e nu, ɛ 'mʋ꞊ʋ 'ye, ‑tɛ ‑tɩ a 'mʋ, ɛ di 'lɩ‑wʋwɛ nu. ");
INSERT INTO ktj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","'Kɩ 'lɩ 'kayu a 'mʋ bʋ, ‑cɔhlʋnpinyʋ gbagbɩ, ʋ kɔ ‑gbolugbo a nyibli a pɛpɛ 'hʋɛn‑, ʋ ꞊mʋɛ꞊ɛ lɛ, 'kɩ bʋ yɛɛ ‑Yusu ‑tɩ, 'ye ꞊bɩɩ ɛ mɔ hɩ, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ 'la, ");
INSERT INTO ktj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","kɛɛ, ʋ 'yɩ 'lɩ꞊ɩ kɩkadɛ ꞊dʋ 'lɩ 'yee ‑nɩ, 'ɛ mɔ ꞊han‑tɩ, ‑hɛhɩpʋ ‑hʋɔhʋɩ, 'ʋ 'ma꞊a hɩ 'lu blɛ. Bʋ nɩ 'kɩ 'ʋ bʋ, ‑ɛ ‑bɩ nyibli nɩ 'hʋɛn ꞊plu 'ʋ nɩ, ");
INSERT INTO ktj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ʋ wɛn: «Nyiblo ‑bʋ, ɛ wɛn 'nɩ, ɛ ‑wɛ 'lɩ bʋ 'wla Nyɩsʋa a 'kayu gbagbʋ nɩ, 'tɩ‑ bʋ pʋ꞊ʋ nɩ de, 'kɩ 'lɩ ‑nyrɔwɩ nɩ ta 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","‑Ɛ ‑bɩ ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ 'du ye', 'ɛ 'bɛti ‑Yusu, ɛ wɛn: «꞊Bɩ ‑tɩ a pɛpɛ ‑bʋ, nyibli ‑bʋ, ʋ yɩ ‑mʋ ‑yɛɛ ‑nɩ, ꞊yɩ ‑tɩ ‑kɔ, ‑bʋ ꞊tu ꞊nʋ ꞊wɔn?» ");
INSERT INTO ktj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kɛɛ, ‑Yusu 'yɩ꞊ɩ ‑tɩ ꞊dʋ klɛ ‑hɩhɩa ‑nɩ. ‑Ɛ ‑bɩ ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ yɩ꞊ɩ 'nɩ ‑lee ‑nɩ, ɛ wɛn: «'N ‑hʋɛ꞊ɛ nɩ, ‑bʋ 'sʋʋ ‑nɩ, 'kɩ 'lɩ 'Klɩkɩnɩnyɩsʋa a 'nyrɛ 'kwli, 'bʋ mɔ, ꞊nɩ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya, kɔ, 'bʋ mɔ, ꞊nɩ mɔ Nyɩsʋa a 'Yu.» ");
INSERT INTO ktj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","‑Ɛ ‑bɩ ɛ ꞊tu꞊o ꞊wɔn, ɛ wɛn: «Iin, 'mɔ ꞊nɩɔ. 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, kʋɛ kɛ 'kɩ mɔ bʋ, a di 'mʋ 'nɩ 'ye, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'mʋ 'ʋ 'Klɩkɩnɩnyɩsʋa a diidɛkɩbɩa kɩ bʋ nɩ, 'mʋ 'lɩ yakɔ 'kwli ‑hɔn, 'kɩ 'lɩ 'nuŋmɩ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","‑Yusu bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ a 'mʋ, ɛ cɩcra 'a dɩɔnʋ wlawlʋ lɛ, yrʋ a ‑tɩ, ɛ wɛn: «Ɛ ‑hɛɛ Nyɩsʋa a ‑tɩ lɛ. ‑A 'nɩ 'mʋɔ 'kɩ ‑hɛhɩnyibli ꞊dʋ lɛ. 'Aan 'mumu, a 'wɩn ‑tɩ, ɛ ‑hla nɩ. A 'wɩn nɩ, ‑tɛ ɛ nu Nyɩsʋa a ‑tɩ a lɛ‑hɛɛlɛ. ");
INSERT INTO ktj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","‑Bɩ' a pɩ 'lɩ?» ‑Ɛ ‑bɩ ʋ ꞊tu꞊o ꞊wɔn, ʋ wɛn: «Ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, ɛ ‑hɛɛ Nyɩsʋa a ‑tɩ lɛ. 'A ‑tɩ, ɛ kɔ 'kʋkʋʋ.» ");
INSERT INTO ktj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","‑Ɛ ‑bɩ ʋ ‑tʋa 'a hɩʋn a 'hinhren, 'kɩ 'ʋ 'a yigbakla yɩ, kɔ, 'ʋ yɩ꞊ɩ ŋmli ‑bii ‑nɩ, 'ʋ pɩɩ 'lɩ꞊ɩ 'ŋmɩ nʋɩ' lɛ, ");
INSERT INTO ktj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ʋ wɛn: «‑Mɔ ‑mʋ', ‑ɛ mɔ Wanyɔ, ‑mɔ mɔ winwlɔn‑hanyɔ. 'A ‑tɩ, lee nɛ ‑a mʋ, nyiblo a 'dɩ ‑bɩ ‑hrɛn ‑mʋ dɛ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","‑Tɛ ‑tɛblɩ a pɛpɛ a 'mʋ, ɛ mi 'lu ‑mɔ, 'kɩ Piɛlɩ 'tɩɛ nɩ 'lɩ ‑yaa a 'mʋ 'kwli. Bʋ nɩ 'kɩ 'ʋ bʋ, ‑ɛ ‑bɩ 'yu nyrɔyu ꞊dʋ, ‑ɛ mɔ 'kayu a 'mʋ, 'a ‑kʋannunyɔ ‑bɩ, ɛ nɔ‑ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, ɛ wɛn: «‑Mɔ ‑bʋ, ‑kɔ ‑Yusu ‑mʋ', ‑ɛ kɔ 'lɩ Galileblʋgba 'kwli 'hʋɛn‑, 'a mʋ ‑nɩnɛ la 'hʋɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kɛɛ, Piɛlɩ ‑ga nɩ, 'kɩ 'ʋ nyibli a pɛpɛ ye', ɛ wɛn: «‑Tɩ ‑mʋ', ‑hlɛ, 'nɩ ‑yru꞊o lɩ꞊ɩ' lɛ,» ");
INSERT INTO ktj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","'ɛ ‑hɔn 'ʋ꞊ʋ 'hʋɩ, 'ɛ mu 'lɩ ‑yaa a 'mʋ 'a paalɛ'. ‑Tɛ ɛ nyre 'ʋ, ‑ɛ ‑bɩ 'yu nyrɔyu ‑bɩ 'ye꞊e nɩ de, 'ɛ lee nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, ɛ wɛn: «Nyiblo ‑bʋ, a yɩ 'ye, ɛ kɔ Nasalɛtɩ a ‑Yusu 'hʋɛn‑, ʋ nʋ‑ nɩnɛ ‑mɔ 'hʋɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kɛɛ, Piɛlɩ 'tɩɛ ‑gɛ, ɛ wɛn: «'N 'sʋʋ nɩ, nyiblo ‑bʋ, ‑kɔtɩ a hlɛ, 'n 'yɩ꞊ɩ ‑yi.» ");
INSERT INTO ktj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","‑Tɛ ti gbi ‑hi, ‑ɛ ‑bɩ nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, ʋ 'yɩya 'ʋ Piɛlɩ 'hʋɩ bʋ, ʋ wɛn: «Ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, ‑mɔ ‑bʋ, ‑mɔ ‑Yusu a ‑nagbopi* ꞊nɩɔ, ‑kɔtɩ ‑tɛ ‑ni 'pʋplɛ, ɛ tʋɛ nɛ ‑a mʋ nɩ, ‑ɛ mɔ, ‑mɔ Galilekʋɛyu ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","‑Ɛ ‑bɩ ɛ wɛn: «'Bʋ mɔ, 'nɩ yɩ hɩ nɩ ni, Nyɩsʋa bʋ pʋ 'mʋ 'jrɔ yɩ. 'N 'sʋʋ nɩ, nyiblo ‑bʋ, ‑kɔtɩ a hlɛ, 'n 'yɩ꞊ɩ ‑yi.» Ti nɩ ‑do a 'mʋ 'yri, ‑ɛ ‑bɩ hapɛ da ‑nyrɛ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","‑Ɛ ‑bɩ ‑tɩ ‑mʋ', ‑Yusu lee wɛn Piɛlɩ, ɛ bi 'lɩ꞊ɩ 'kwli. Kɛ‑ ɛ pʋ꞊ʋ yɩ: «'Tɩ‑ hapɛ 'mʋ ‑nyrɛ da, ‑di nu 'na ‑mɔ‑gaawɩ nɩ ta, ‑ɛ mɔ, ꞊yɩ 'mʋ ‑yi.» ‑Tɛ ɛ bi 'lɩ꞊ɩ 'kwli, ‑ɛ ‑bɩ ɛ 'hrɩ 'lɩ ‑yaa 'kwli nɩ, 'ɛ ‑tʋa wuwe, 'kla‑wliye'yɩya a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","‑Tɛ ‑nyrɛ ‑nyɛ, ‑ɛ ‑bɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ a pɛpɛ 'kukue lɛ, ʋ kɔ ‑Juukʋɛ* a naanyʋ 'hʋɛn‑, 'ʋ ‑yra꞊a, 'kɩ bʋ 'la ‑Yusu. ");
INSERT INTO ktj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","‑Ɛ ‑bɩ ʋ wɛn: «Ba lee nɛ ‑aan 'sɛyo, bʋ mʋa ꞊nɛ, ʋ 'mʋ 'lɩ꞊ɩ ‑gʋlʋnʋma Pilatɩ ‑mɔ gba.» (Pilatɩ a 'mʋ, Romakʋɛ a 'kɩɩn gbagbʋ, ɛ nɔ‑ ꞊tu la 'ʋ꞊ʋ gbata kɩ bʋ.) ");
INSERT INTO ktj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judɩa ‑mʋ', ‑ɛ pʋ ‑Yusu 'a yraanyibli ‑jɩ', ‑tɛ ɛ 'wɩn, ‑ɛ mɔ, ‑gbolugbo a nyibli ‑yra꞊a nɩ, ‑ɛ mɔ, ʋ di ‑Yusu 'nɩ 'la, ‑ɛ ‑bɩ ɛ pɩ ꞊wlɩ lɛ, 'kɩ 'ʋ dɛ ‑mʋ', ɛ ‑nu a ‑ta'. 'Kla bʋ yɩ꞊ɩ ‑wliye nɩ 'yɛ, ɛ nɔ‑ mɔ 'wliyɔ a (30) ‑wlʋ ꞊tu 'ʋ ‑pu ‑mʋ', Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ, ʋ kɔ 'blʋgba a ye'nanyʋ 'hʋɛn‑, ʋ ‑nyi꞊e, bʋ gba ꞊nʋ꞊ʋ yɩ, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ, ");
INSERT INTO ktj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","'tɩ‑ bʋ lee ꞊nʋ: «'N nu dɛ 'kuku, ‑tɛ 'n pa 'ʋ, 'nɩ pʋ 'a mʋ nyiblo ‑bʋ ‑jɩ', ‑ɛ 'yɩ ꞊dedede ‑nu, ‑bʋ blɛɛ 'kʋkʋʋ yɩ.» Kɛɛ, ʋ ꞊tu꞊o ꞊wɔn, ʋ wɛn: «‑A mʋ ‑bʋ, ‑a 'yɩ 'lɩ꞊ɩ ‑mɔ ‑kɔ. ‑Mɔ kɔ 'lɩ꞊ɩ ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ɛ nɔ‑ mɔ Judɩa bʋ ‑gbla 'wliyɛ a 'mʋ, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ. ‑Tɛ ɛ 'hrɩ, ‑ɛ ‑bɩ ɛ pʋ 'a dɩɔnʋ 'lulu lɔ. ");
INSERT INTO ktj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","‑Tɛ Judɩa 'la 'kɩ 'a dɩɔnʋ, ‑ɛ ‑bɩ 'wliyɛ ‑mʋ', ɛ ‑gbla wɛn 'kɩ, Nyɩsʋa a ‑cɔhlʋnpinyʋ gbagbɩ 'tɩ꞊ɩ lɛ, ʋ wɛn: «Ɛ mɔ ‑hlʋ a 'wliyɛ ꞊nɩɔ. ‑Aan tete wɛn 'nɩ, ‑a 'nɩ 'pʋʋ 'lɩ 'wliyɛdʋ a 'mʋ Nyɩsʋa a 'kagbaʋ a ‑drɔɔ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","‑Tɛ ʋ hla ‑tɩ a 'mʋ, ‑ɛ ‑bɩ ʋ ‑yra꞊a nɩ, 'kɩ bʋ nu 'wliyɛ a 'mʋ, bʋ ‑tɔ ‑ci ‑mʋ', ʋ dɛɛ yɩnunyɔ a ‑ci, ‑ɛ di꞊e nu, ʋ 'mʋ ‑ci a 'mʋ 'dagbɩ a 'dabi ‑mɔ' nu. ");
INSERT INTO ktj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ɛ nɔ‑ kɔ ‑tɩ, kʋɛ la 'lɩ bʋ, ‑bʋ yɛ ti ‑bʋ kɩ, ‑ci a 'mʋ, 'ʋ dɛɛ ꞊nɛ ‑hlʋ a ‑ci. ");
INSERT INTO ktj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","‑Tɛ dɛ a 'mʋ, ɛ mu la 'lu ‑mɔ, ‑ɛ ‑bɩ ‑tɩ bʋ, Nyɩsʋa a winwlɔn‑hanyɔ* Selemi 'crɩ la, ɛ nɔ‑ mu la 'lu ‑mɔ. ‑Tɩ a 'mʋ, ɛ 'crɩ la, ɛ nɔ‑ ‑bʋ: «Ʋ gba 'wliyɔ a ‑wlʋ ꞊tu 'ʋ ‑pu ‑mʋ' nɩ, ‑ɛ mɔ 'wliyɛ ‑mʋ', Yisraɛkʋɛ wɛɛn la kɩ, bʋ 'pɛɛ la ‑nɩ, 'kɩ 'ʋ 'a ‑ta', ");
INSERT INTO ktj_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","'ʋ ‑tɔ yɩnunyɔ a ‑ci, ꞊wɩ yɩ ‑tɛ Kʋkɔnyɔ Nyɩsʋa nu la 'a hɩhla.» ");
INSERT INTO ktj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","‑Yusu ‑mɔ ‑bɩ, 'kɩ ʋ gba 'lɩ꞊ɩ ‑gʋlʋnʋma Pilatɩ yɩ, ‑gʋlʋnʋma a 'mʋ 'ɛ ‑tʋa 'a lɛ'bɛtilɛ, ɛ wɛn: «꞊Bɩ ‑mɔ mɔ ‑Juukʋɛ* a bodɩɔ?» ‑Ɛ ‑bɩ ‑Yusu wɛn: «Iin, 'mɔ ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ɛ nɔ‑ mɔ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ bʋ yɛɛ ꞊nɛ ‑tɩ ‑hʋɔhʋɩ, kɛɛ, ‑Yusu 'yɩ ‑tɩ ꞊dʋ ꞊wɔn ꞊tu. ");
INSERT INTO ktj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","‑Ɛ ‑bɩ Pilatɩ 'bɛti꞊e nɩ de, ɛ wɛn: «꞊Bɩ ‑tɩ a pɛpɛ ‑bʋ, ʋ yɩ ‑mʋ 'hʋɩ lɛ 'ye, ꞊nɩ 'wɩn꞊ɩ lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kɛɛ, ‑Yusu 'yɩ winbʋ ꞊dʋ klɛ ‑hɩhɩa ‑nɩ. Ɛ mɔ dɛ ꞊nɩɔ, 'ɛ kɛɛ ‑gʋlʋnʋma Pilatɩ a ꞊wlʋ lɛ dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","'A ‑nɛ lɛ'mimle, ‑ɛ mɔ Pakɩ a ti 'yri, ‑gʋlʋnʋma Pilatɩ kɔ bʋ tɛ ꞊jɩklapi nɩ ‑do ‑mʋ', ‑Juukʋɛ di ‑hʋa bʋ. ");
INSERT INTO ktj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ɛ kɔ la ꞊jɩklapi ꞊dʋ. 'A 'nyrɛ mɔ la Balabasɩ. Nyibli a pɛpɛ yi la꞊a nɩ, ‑ɛ mɔ, ɛ mɔ la ‑balʋnyɔ ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","‑Tɛ nyibli 'kukue 'kɩ lɛ, 'kɩ 'lɩ Pilatɩ ‑mɔ, ‑ɛ ‑bɩ Pilatɩ a 'mʋ, ɛ 'bɛti ꞊nʋ nɩ, ɛ wɛn: «Balabasɩ kɔ ‑Yusu ‑bʋ, ʋ dɛɛ Nyɩsʋa kɔ Wanyɔ 'hʋɛn‑, nyiblo a 'dɩ ‑bɩ a ‑hʋɛ ꞊bʋ tɛ bʋ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatɩ 'bʋ yɩ 'pʋplɛ lɛ nɩ ni, ɛ 'wɩ yɩ, ɛ yi꞊e nɩ, ‑ɛ mɔ, 'kɩ 'lɩ ca 'kwli, 'kɩ ‑Juukʋɛ a nyibli gbagbɩ naa 'lɩ, 'ʋ pʋ꞊ʋ ‑Yusu ‑jɩ', ‑ɛ di꞊e nu, ɛ 'mʋ꞊ʋ 'la. ");
INSERT INTO ktj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatɩ bʋ nɩ 'kɩ 'ʋ ‑batipʋʋlɛ', ‑ɛ ‑bɩ 'a nʋgba ya꞊a win yɩ, ‑ɛ mɔ: «꞊Nɩ 'nuo 'lɩ nyiblo ‑mʋ' ꞊dedede ‑mɔ, ‑ɛ nu꞊o, ɛ 'yɩ ꞊dedede ‑nu, ‑bʋ nyre yɩ, ‑ɛ nu꞊o, 'tɔlʋwɔ ‑bʋ, 'kɩ 'lɩ yanie 'kwli, 'n 'ye ꞊hɩʋɛn dɩakɩ a ‑tɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","‑Tɛ dɛ a 'mʋ, ɛ mi 'lu ‑mɔ, ‑ɛ ‑bɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ kɔ ‑Juukʋɛ a 'blʋ 'hʋɛn‑, ʋ lee nyibli a pɛpɛ nɩ, 'kɩ bʋ lee Pilatɩ, bʋ tɛ Balabasɩ bʋ, ɛ 'mʋ ‑Yusu 'la. ");
INSERT INTO ktj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","‑Ɛ ‑bɩ ‑gʋlʋnʋma Pilatɩ 'bɛti nɩ, ɛ wɛn: «Nyibli nɩ 'hʋɛn ‑mʋ' 'nyɩ, nyiblo a 'dɩ ‑bɩ a ‑hʋɛ ꞊bʋ tɛ bʋ 'lɩ?» ‑Ɛ ‑bɩ ʋ wɛn: «Balabasɩ!» ");
INSERT INTO ktj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","‑Ɛ ‑bɩ Pilatɩ wɛn: «'Bʋ mɔ, 'nɩ tɛ Balabasɩ bʋ, dɛ a 'dɩ ‑bɩ a ‑hʋɛ ꞊bʋ nu ‑Yusu ‑bʋ, ʋ dɛɛ Wanyɔ ‑mɔ 'lɩ?» Ɛ nɔ‑ mɔ 'waa pɛpɛ bʋ ꞊tu꞊o ꞊wɔn, ‑ɛ mɔ: «Kɔɔ 'ʋ꞊ʋ tugbɛ 'yie, ɛ 'mʋ 'kʋ!» ");
INSERT INTO ktj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","‑Ɛ ‑bɩ Pilatɩ wɛn: «Dɛ ‑hʋan a 'dɩ ‑bɩ ɛ ‑nu, ‑kɔtɩ 'nɩ kʋɛ 'ʋ꞊ʋ tugbɛ 'yie 'lɩ?» Kɛɛ, ʋ 'yɛɛ 'lɩ win, ʋ wɛn: «Kɔɔ 'ʋ꞊ʋ tugbɛ 'yie, ɛ 'mʋ 'kʋ!» ");
INSERT INTO ktj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatɩ 'ye꞊e nɩ, ‑ɛ mɔ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ꞊tu ꞊nʋ ꞊wɔn. 'Waa ‑cici a lɛpʋpʋʋ bʋ yɩ klɛ nɩ ‑bii ‑nɩ, ɛ nɔ‑ mɔ bʋ 'du 'nie ye', bʋ yra ꞊jrɛ, 'kɩ 'ʋ nyibli a pɛpɛ ‑mʋ' ye', bʋ ‑lee ꞊nʋ, ‑ɛ mɔ: «'Mɔ ‑bʋ, 'n 'yɩ꞊ɩ kɩ wɛn, nyiblo ‑bʋ, 'a ‑hlʋ bʋ 'wlɛ bʋ. 'Aan ꞊gbɛtʋ, 'a mʋ ‑hʋɛ꞊ɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","‑Ɛ ‑bɩ nyibli a pɛpɛ a 'mʋ, ʋ ꞊tu꞊o ꞊wɔn, ʋ wɛn: «‑A kɔ ‑aan 'yonʋ 'hʋɛn‑, ‑a nyra bʋ, 'kɩ 'ʋ 'a 'kʋkʋʋ a ‑ta'.» ");
INSERT INTO ktj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ Pilatɩ tɛ Balabasɩ bʋ, 'tɩ‑ 'ɛ lee nɛ 'a 'sɛyo, 'kɩ bʋ bii ‑Yusu lɔkʋɛ. ‑Tɛ ʋ ‑wɛ 'a bibie ‑mɔ, ‑ɛ ‑bɩ kɛ‑ ɛ pɩ 'a 'sɛyo a 'mʋ yɩ, ɛ wɛn: «Ba gba꞊a, ba kɔɔ 'ʋ꞊ʋ tugbɛ 'yie, ɛ 'mʋ 'kʋ!» ");
INSERT INTO ktj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pilatɩ bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ 'a 'sɛyo gba ‑Yusu nɩ, 'kɩ 'lɩ Pilatɩ a ‑yaa 'kwli, ‑tɛ 'waa bʋnɩɩlɛ nɩ 'ʋ, 'ʋ da 'waa 'bio 'sɛyo a pɛpɛ. ");
INSERT INTO ktj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","‑Tɛ ʋ nyre 'kɩ 'ʋ, ‑ɛ ‑bɩ ʋ ‑hɛ ‑Yusu wlawlɩ, 'ʋ pʋ꞊ʋ wlawlʋ ‑jɔhʋn, ");
INSERT INTO ktj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","kɔ, 'ʋ hlaa ꞊nɛ 'witiklaʋn lɛ. 'Witiklaʋn a 'mʋ, ɛ nɔ‑ ʋ ꞊tu꞊o 'lu, 'ʋ 'nyra꞊a kotu ‑jɩ', 'kɩ 'lɩ 'a diidɛdabʋ 'kwli, 'ʋ bla꞊a kwlɩ yɩ bʋ, 'ʋ 'cɛɛ ꞊nɛ, ʋ wɛn: «‑Na 'wio mɔ, ‑Juukʋɛ* a bodɩɔ,» ");
INSERT INTO ktj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","'ʋ ‑gblɛ 'lɩ꞊ɩ hɩʋn 'yi lɛ, 'ʋ ‑ha꞊a kotu ‑jɩ', 'ʋ pɩ 'ʋ ꞊nɛ 'lu lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","‑Tɛ ʋ ‑wɛ 'a 'caalɛ ‑mɔ, ‑ɛ ‑bɩ ʋ ‑hɛ 'kɩ꞊ɩ wlawlʋ ‑jɔhʋn a 'mʋ nɩ, 'ʋ pʋ꞊ʋ 'a ꞊gbɛtʋ a wlawlɩ, 'tɩ‑ ʋ ꞊tɩɔ ꞊nɛ 'dɩɔ, 'ʋ gbɛ 'lɩ꞊ɩ ‑tɩtɛ ‑mʋ', ʋ di 'lɩ꞊ɩ tugbɛ 'yie ‑kɔɔ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","‑Tɛ ʋ yɩ 'kɩ 'dɩɔ nɩ ꞊tɩ, ‑ɛ ‑bɩ ʋ kɔ nyɩbɛhɩan ꞊dʋ 'hʋɛn‑, ʋ ꞊ŋmee nɩ. Nyɩbɛhɩan a 'mʋ, 'a 'nyrɛ mɔ Simɔ. 'Kɩ ɛ kɔ 'lɩ Silɛnɩdɩɔ 'kwli. Nyɩbɛhɩan a 'mʋ, ɛ nɔ‑ 'sɛyo ‑klɔ, 'ʋ nɩ 'ʋ꞊ʋ ke', 'ɛ 'ble tugbɛ ‑mʋ', ‑ɛ kɔ 'yie ʋ di 'ʋ ‑Yusu 'ʋ ‑kɔɔ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","‑Ɛ ‑bɩ 'kɩ ʋ nyre 'ʋ ‑tɩtɛ ‑mʋ', ʋ dɛɛ Gɔlʋgɔta, ‑ɛ ꞊hɛn 'nyrɛ dʋgba ‑mʋ', ʋ dɛɛ 'Lukla. ");
INSERT INTO ktj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","‑Tɛ ʋ nyre 'ʋ, ‑ɛ ‑bɩ ʋ ‑hʋɛ bʋ ‑nyi꞊e nɔ, ‑ɛ kɔ ‑mɔ ʋ pʋ 'lɩ ‑cɩ kɩklakui. ‑Tɛ ɛ ꞊tɛ꞊ɛ wlɔn, ‑ɛ ‑bɩ ɛ 'yɩ 'a 'nɩna ‑hʋa. ");
INSERT INTO ktj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","'Kɩ 'ʋ ‑tɩtɛ a 'mʋ, 'kɩ ʋ kɔɔ 'ʋ꞊ʋ tugbɛ 'yie, 'ʋ pʋ 'wla, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ 'ye, ‑tɛ ʋ di ‑Yusu a 'hʋɩlɛpʋ‑tɛblɩ a ꞊gɩgla nu. ");
INSERT INTO ktj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","'Kɩ ʋ nɩ 'ʋ bʋ, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ 'yie ꞊tu. ");
INSERT INTO ktj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","'Tɩ‑ 'ʋ 'crɩɩ 'ʋ 'plaɩnkɩbɩa kɩ, ‑tɩ ‑kɔ ‑tɩ ʋ kɔɔ 'ʋ ‑Yusu tugbɛ 'yie. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: «Nyiblo ‑bʋ, ɛ nɔ‑ mɔ ‑Yusu, ‑ɛ mɔ ‑Juukʋɛ* a bodɩɔ.» Tugbɛ a 'mʋ, ‑ɛ kɔ 'yie ʋ kɔɔ 'ʋ ‑Yusu, ɛ nɔ‑ kɔ 'lu yɩ ʋ 'maa 'lɩ 'plaɩnkɩbɩa a 'mʋ bʋ. ");
INSERT INTO ktj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ti nɩ ‑do a 'mʋ 'yri, 'kɩ 'ʋ ‑Yusu 'hʋɩ, ʋ kɔɔ 'ʋ ‑balʋnyʋ nɩ 'hʋɛn, 'kɩ 'ʋ 'waa ‑nɛ ti 'yie, ‑do 'kɩ 'lɩ 'a diidɛkɩbɩa kɩ, ‑do ‑bɩ 'kɩ 'lɩ 'a kamlakɩbɩa kɩ. ");
INSERT INTO ktj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","‑Ɛ ‑bɩ nyibli ‑mʋ', ‑ʋ yɩ ‑hi, ʋ ‑hɛ꞊ɛ 'yri, 'tɩ‑ 'ʋ ꞊gbɛpʋ 'lu lɛ, ");
INSERT INTO ktj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ʋ wɛn: «‑Mɔ ‑bʋ, ‑ɛ pʋ lɛ, ‑ɛ di la Nyɩsʋa a 'kagbaʋ 'wla, 'tɩ‑ ‑ɛ di꞊e pʋ, 'kɩ 'lɩ ‑nyrɔwɩ nɩ ta 'kwli, 'bʋ mɔ, ꞊nɩ mɔ Nyɩsʋa a 'Yu, wa ‑dɩɔnʋ, ꞊mʋ 'ʋ tugbɛ ‑mʋ' 'yie ‑hɔn, ꞊mʋ ꞊tɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","‑Ɛ ‑bɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ, kɔ tetetɔɔnyʋ, kɔ 'blʋ a nyibli ‑bɩ 'hʋɛn‑, ‑ʋ nɩ 'ʋ ‑wɛ, ʋ ‑hɛ꞊ɛ 'yri lɛ ‑wɛ, ʋ wɛn: ");
INSERT INTO ktj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Ɛ wa nyibli ‑bɩ, kɛɛ, ɛ 'yɩ 'lɩ 'a dɩɔnʋ a wʋwa 'lɩ ‑wɛ. 'Bʋ mɔ, Yisraɛkʋɛ a bodɩɔ, bʋ ‑hɔn 'ʋ tugbɛ ‑mʋ' 'yie, bʋ ꞊tɩ, ‑tɛ ti nɛ ‑bʋ. 'Bʋ mɔ, 'bʋ ‑hɔn 'ʋ tugbɛ 'yie, ‑a di pʋ꞊ʋ ꞊haan‑tɩ, ‑ɛ mɔ, ɛ nɔ‑ mɔ Wanyɔ. ");
INSERT INTO ktj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ɛ kuo Nyɩsʋa ꞊wlʋ yɩ. 'A ‑tɩ, Nyɩsʋa a 'mʋ, 'bʋ nʋɛ ꞊nɛ, ‑ɛ ‑bɩ bʋ ‑hɛɛ ꞊nɛ. 'Bɩ nyiblo ‑bʋ, ɛ hla꞊a nɩ, ‑ɛ mɔ, ɛ mɔ Nyɩsʋa a 'Yu ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kɛ‑ nɩ ‑do ‑balʋnyʋ nɩ 'hʋɛn‑ ‑mʋ', ʋ kɔɔ 'ʋ 'waa ti 'yie lɛ, 'kɩ 'ʋ ‑Yusu 'hʋɩ, ʋ ni, 'ʋ 'cɛɛ ꞊nɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","'Yrʋ bʋ yɩ 'ʋ 'lu a ‑hɛyri' nɩ nyre, ‑ɛ ‑bɩ halɔ ka ‑tʋtʋ a pɛpɛ kɩ. Halɔ a 'mʋ, ɛ nɩ 'ʋ ‑nɩnɩ 'ɛ yɛ 'yrʋ‑hiilɛ a ti kɩ. ");
INSERT INTO ktj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","‑Tɛ 'yrʋ‑hiilɛ a ti a 'mʋ, ɛ yɩ 'ʋ nyre, ‑ɛ ‑bɩ ‑Yusu 'yaa 'lɩ win, ɛ wɛn: «Eli, Eli, lama sabatani?», ɛ ꞊hɛn 'nyrɛ: «Nyɩsʋa o, Nyɩsʋa o, dɛ‑ kɔ 'mɔ ‑ha 'yie ‑mɔ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nyibli ‑mʋ', ‑ʋ nɩ ‑tuo kɩ, kɛ‑ 'waa dɛ ‑bɩ pɩ: «Nyɩsʋa a winwlɔn‑hanyɔ Eli ɛ dɛ.» ");
INSERT INTO ktj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","'Kɩ 'lɩ ꞊nʋ 'nyɩ, ɛ kɔ nyiblo ‑bɩ, 'ɛ 'gba ci lɛ, ti nɩ ‑do a ti 'yri, 'ɛ 'du ‑sapoo ye', 'ɛ 'nyra 'lɩ꞊ɩ 'lipanɔ ‑mɔ, 'ɛ mʋa 'ʋ꞊ʋ tugbɛ blɔblʋ 'lu lɛ, 'ɛ ‑nyi꞊e ‑Yusu, ‑ɛ di꞊e nu, ɛ 'mʋ꞊ʋ 'na. ");
INSERT INTO ktj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kɛ‑ ‑ʋ ‑bɩ pɩ, ʋ wɛn: «‑Ba pʋ 'ʋ 'yie bʋ, 'bʋ mɔ, Eli 'bʋ di di, ɛ 'mʋ꞊ʋ ‑hɛɛ ‑nɩ, ‑a 'mʋ꞊ʋ 'ye.» ");
INSERT INTO ktj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Bʋ nɩ 'kɩ dɛ a 'mʋ ‑mɔ, ‑ɛ ‑bɩ ‑Yusu 'gbo nɩ de, 'ɛ mla ‑hʋnhlʋn. ");
INSERT INTO ktj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ti nɩ ‑do a 'mʋ 'yri, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ ‑mʋ', ‑ɛ nɩ 'lɩ Jrusrɛdɩɔ 'kwli bʋ, danʋ gbagbʋ ‑mʋ', ‑ɛ 'bɛ 'kayu a 'mʋ ꞊tɩɔ, 'ɛ ‑ki wlɔn pɛpɛ, kʋɛ 'lɩ 'a 'lu yɩ bʋ, ‑bʋ yɛ 'a ꞊hlɔndɛ kɩ, ‑tʋtʋ 'ɛ 'hɩhlɛ ‑nɩ, 'hɩ gbagbɩ 'ʋ ‑kiki wlɔn lɛ, ");
INSERT INTO ktj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","'dabi 'ʋ ꞊ga wlɔn lɛ, nyibli, ‑ʋ 'kʋ la, 'ʋ yɩ 'klɔ lɛ 'hrɩ, ");
INSERT INTO ktj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","'tɩ‑ ‑nyrɔwɩ nɩ ta 'mʋ ‑hi mɔ mu, ‑ɛ ‑bɩ ‑Yusu ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ nɩ, 'ɛ 'hrɩ 'klɔ, nyibli a 'mʋ, 'ʋ ‑hɔn 'lɩ 'dabi 'kwli lɛ, 'ʋ pa 'lɩ Jrusrɛdɩɔ 'kwli, ‑ɛ mɔ Nyɩsʋa a 'dɩɔ, nyibli ‑hʋɔhʋɩ 'ʋ 'ye ꞊nʋ. ");
INSERT INTO ktj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","'Kɩ 'ʋ ‑Yusu ꞊hlɔn, 'kɩ Romakʋɛ a 'sɛyo a nyiblo gbagbʋ ‑bɩ nyra 'ʋ bʋ, ɛ kɔ 'a 'sɛyo ‑mʋ', ‑ʋ ꞊tui꞊e 'yie 'hʋɛn‑. ‑Tɛ ʋ 'ye ‑tʋtʋ a 'hɩhlɛlɛ, kɔ ‑tɛblɩ a pɛpɛ ‑mʋ', ‑ɛ mi 'lu ‑mɔ 'hʋɛn‑, ‑ɛ ‑bɩ hʋannʋ bi 'lɩ ꞊nʋ 'kwli, ʋ wɛn: «Ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, nyiblo ‑bʋ, ɛ mɔ la Nyɩsʋa 'Yu ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nʋgbɩ ‑hʋɔhʋɩ nɩ 'ʋ, 'ʋ hlɔɔ 'ʋ ‑tɛ a 'mʋ ‑mɔ lɛ dɛ gbe. ‑Tɛblɩ a pɛpɛ ‑mʋ', ‑ɛ mi 'lu ‑mɔ, ʋ yɩ꞊ɩ 'nɩ 'ye. Nʋgbɩ a 'mʋ, ʋ nʋ‑ yɩ la ‑Yusu ꞊wien lɛ kʋɛ, kʋɛ 'lɩ ti ‑mʋ' ‑kɔ 'yri ɛ nɩ la 'lɩ Galileblʋgba 'kwli, 'ʋ yɩ la꞊a ‑hɛɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","'Kɩ 'lɩ ꞊nʋ 'nyɩ, 'kɩ Madala a Mari nɩ 'lɩ, kɔ Mari ‑mʋ', ‑ɛ mɔ Sakɩ kɔ Sosɩ a 'dii, kɔ Sebede a 'yonʋ a 'dii. ");
INSERT INTO ktj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","‑Tɛ 'tɔ yɩ nɩ ‑wɛn, ‑ɛ ‑bɩ dɛkɔnyɔ ꞊dʋ nyre 'ʋ ‑tuo a 'mʋ kɩ. 'A 'nyrɛ mɔ Sosɛfʋ. 'Kɩ ɛ kɔ 'lɩ Alimatedɩɔ 'kwli. Sosɛfʋ a 'mʋ, ɛ mɔ ‑Yusu a ‑nagbopi* ꞊nɩɔ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ɛ nɔ‑ ‑mu, ‑ɛ lee Pilatɩ, 'kɩ bʋ wɛn, bʋ ‑ha 'ʋ ‑Yusu a ‑plahʋɩ tugbɛ 'yie, ɛ 'mʋ꞊ʋ 'ʋ ‑ha. ‑Ɛ ‑bɩ Pilatɩ lee nɛ 'a 'sɛyo nɩ, 'kɩ bʋ ‑nyi Sosɛfʋ ‑Yusu a ‑plahʋɩ a 'mʋ, ‑ɛ di꞊e nu, ɛ 'mʋ꞊ʋ 'ʋ ‑ha. ");
INSERT INTO ktj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","‑Tɛ ʋ ‑nyi꞊e ‑plahʋɩ a 'mʋ, ‑ɛ ‑bɩ ɛ gba꞊a nɩ, 'ɛ 'hɩnhɩan꞊a ‑jisɛ lɛ, ");
INSERT INTO ktj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","'tɩ‑ 'ɛ gba 'lɩ꞊ɩ ‑tɩtɛ ‑mʋ', ɛ di 'ʋ꞊ʋ ꞊tuu ‑nɩ. 'Kɩ 'lɩ ‑tɩtɛ a 'mʋ, 'hɩɔ gbagbʋ nɩ 'ʋ, 'ɛ hlɔ la yra, ‑wɛn dʋgba. 'Kɩ 'lɩ 'hɩɔ gbagbʋ a 'mʋ 'kwli, 'kɩ ʋ 'bluu la 'lɩ 'dabio (ti ꞊dʋ a ti 'yri la, ‑ɛ 'wɩ la ‑wlukayu yɩ). 'Kɩ 'lɩ 'dabio a 'mʋ 'kwli, 'kɩ ɛ pʋ 'lɩ ‑Yusu a ‑plahʋɩ, 'tɩ‑ 'ɛ nu 'hɩɔ 'papɔ, ‑ɛ nɩ 'ʋ, ‑ɛ ꞊hɩan 'lɩ ‑mɔ lɛ, 'ɛ ka 'dabio a 'mʋ yɩ. ‑Tɛ ɛ ‑wɛ ‑mɔ, ‑ɛ ‑bɩ ɛ mu nɩ. ");
INSERT INTO ktj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Madala a Mari, kɔ Mari ‑bɩ ‑mʋ' 'hʋɛn‑, ʋ nɩ ‑tuo kɩ, 'ʋ 'bɛ 'dabio 'yi, 'ʋ nɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","‑Nyrɔwɔ ‑mʋ', ‑ɛ yɩ ‑hi, 'tɩ‑ ‑wuwle‑nyrɔwɔ* 'ɛ yɩ 'ʋ nyre. ‑Ɛ ‑bɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ, kɔ Falisi꞊tumu* a nyibli 'hʋɛn‑, ʋ 'kukue lɛ, 'ʋ mu 'ʋ Pilatɩ ye', ");
INSERT INTO ktj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ʋ wɛn: «Nyɩbɛyu o, ‑tɩ bi 'lɩ ‑a mʋ 'kwli. Ɛ nɔ‑ mɔ, ‑tɛ hɩlɛkɔnyɔ ‑mʋ', ɛ nɩ la 'klɔ, kɛ‑ ɛ pɩ la: 'Bʋ mɔ, 'nɩ 'kʋ, ‑nyrɔwɩ nɩ 'hʋɛn 'bʋ ‑hi, ta a ‑nyrɔwɔ 'kwli, 'n kɔ ꞊bʋ 'hrɩ 'klɔ. ");
INSERT INTO ktj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","'A ‑tɩ, ‑a ‑hʋɛ꞊ɛ nɩ, ‑bʋ lee ‑na 'sɛyo, bʋ ꞊tu 'a 'dabio a 'mʋ 'yie ‑tutu, ‑nyrɔwɩ nɩ ta bʋ ‑yrɛ 'lu, ‑ɛ di꞊e nu, 'a ‑nagbopʋ* 'nɩ ꞊ha di, ʋ 'nɩ ꞊ha 'a ‑plahʋɩ 'yri, 'tɩ‑ ʋ 'nɩ ꞊ha nyibli lɛ ‑lee ‑nɩ, ‑ɛ mɔ, ɛ ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ nɩ, 'ɛ 'hrɩ 'klɔ. Hɩdʋ a 'mʋ, ɛ di nɩ 'klɩ kɩ, ɛ 'mʋ 'ʋ 'a yɩ‑hɛdɛ 'ʋ ‑hi.» ");
INSERT INTO ktj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","‑Ɛ ‑bɩ Pilatɩ ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «'Sɛyo, nʋ‑ ‑mʋ'. Ba mu, ba lee 'sɛyo a 'mʋ, bʋ ꞊tu 'dabio a 'mʋ 'yie, ‑tɛ a ni 'a ‑hʋhʋa.» ");
INSERT INTO ktj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ɛ nɔ‑ mɔ bʋ mu 'lɩ 'dabio yɩ, 'hɩɔ ‑mʋ', ʋ nu wɛn, 'ʋ ka wɛn ‑Yusu a 'dabio yɩ, 'ʋ ꞊tu꞊o yruulɛ, 'ʋ ꞊tu 'ʋ 'sɛyo ‑nɩ wɛn blɛ, ‑ɛ di꞊e nu, ʋ 'mʋ 'dabio 'yie ꞊tu. (Yruulɛ a 'mʋ, ʋ ꞊tu 'hɩɔ a 'mʋ, ɛ di ꞊nʋ꞊ʋ 'nɩ ‑tɔɔ ‑nɩ, 'bʋ mɔ, nyiblo 'bʋ kla 'dabio a 'mʋ yɩ.) ");
INSERT INTO ktj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","‑Tɛ ‑Juukʋɛ* a ‑wuwle‑nyrɔwɔ* a 'mʋ, ɛ ‑hi, 'a 'sɔɔndɩ a ‑nyragblɩ, Madala a Mari, kɔ Mari ‑bɩ ‑mʋ' 'hʋɛn‑, ʋ nʋ‑ mu ‑Yusu a 'dabio 'ye mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ti nɩ ‑do a 'ti 'yri, ‑ɛ ‑bɩ ‑tʋtʋ ‑tʋa 'hɩhlɛlɛ, ‑ɛ nu꞊o, Nyɩsʋa a lɛlenyɔ ‑hɔn 'lɩ yakɔ 'kwli, 'ɛ blike kʋanɩhɩɔ ‑mʋ' lɛ, ʋ ‑nu, 'ʋ ka ‑Yusu a 'dabio yɩ. ‑Tɛ ɛ blike꞊e lɛ, ‑ɛ ‑bɩ ɛ nɩ꞊ɩ kɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nyɩsʋa a lɛlenyɔ a 'mʋ, ɛ yɩ 'nɩ wlɩn, ‑wɛn ‑tɛ yakɔ ni 'yii a pʋpʋʋ, 'a 'hʋɩlɛpʋ‑tɛblɩ 'plɛ nɩ dɩakɩ, 'ɛ 'wɩ ‑nyrɛ yɩ. ");
INSERT INTO ktj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","'Sɛyo ‑mʋ', ‑ʋ ꞊tui 'dabio 'yie, ‑tɛ ʋ 'ye dɛ a 'mʋ, ‑ɛ mi 'lu ‑mɔ, ‑ɛ ‑bɩ hʋannʋ ‑tʋa 'waa nunuo dɩakɩ. 'A ‑tɩ, ʋ yɩ 'nɩ 'hɩhlɛ ‑nɩ, 'ʋ bibi ꞊hlɔn lɛ, 'tɩ‑ 'ʋ pɛ 'kɩ 'ʋ blɛ, ‑wɛn nyibli, ‑ʋ 'kʋ. ");
INSERT INTO ktj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","‑Ɛ ‑bɩ kɛ‑ Nyɩsʋa a lɛlenyɔ pɩ nʋgbɩ ‑mʋ' yɩ, ɛ wɛn 'nɩ: «'A mʋ ‑mʋ', a 'nɩ 'pie 'lɩ hʋannʋ. 'N yi꞊e nɩ, ‑ɛ mɔ, ‑Yusu ‑mʋ', ʋ kɔɔ 'ʋ tugbɛ 'yie, ɛ nɔ‑ a ꞊mʋɛ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ɛ 'yɩ 'nɛ‑ ‑nɩ, ꞊wɩ yɩ ‑tɛ 'a ꞊gbɛtʋ, ɛ nu la 'a hɩhla, Nyɩsʋa ‑ha 'lɩ꞊ɩ 'kʋkʋnyibli 'nyɩ nɩ, 'ɛ ‑ha꞊a 'klɔ. Ba 'de, ba 'ye ‑tɩtɛ, ɛ pɛ mɔ mɔ bʋ. ");
INSERT INTO ktj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","'A ‑tɩ, ba 'kɩka ‑nɩ, ba lee nɛ 'a ‑nagbopʋ*, ‑ɛ mɔ, Nyɩsʋa ‑ha 'lɩ꞊ɩ 'kʋkʋnyibli 'nyɩ nɩ, 'ɛ ‑ha꞊a 'klɔ. ‑Yusu a 'mʋ, ɛ nɔ‑ di 'hru 'nyɛɛ ‑nɩ, ɛ 'mʋ 'a mʋ ‑ple, 'kɩ 'lɩ Galileblʋgba 'kwli. 'Kɩ a di 'lɩ꞊ɩ bʋ ‑yɛɛ ‑nɩ. ‑Tɩ 'n kɔ ꞊bʋ lee wɛn 'a mʋ, ɛ nɔ‑ ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","‑Tɛ ʋ 'wɩn ‑tɩ a 'mʋ, ‑ɛ ‑bɩ ʋ 'kɩka nɩ, 'ʋ ‑hɔn 'lɩ 'dabio yɩ. Hʋannʋ yɩ wɛn ꞊nʋ nɩ ni, kɔ, dɔdʋ yɩ wɛn ꞊nʋ nɩ ni, 'ʋ 'gba ci lɛ, ‑ɛ di꞊e nu, dɛ ‑mʋ', ‑ɛ mu 'lu ‑mɔ, ʋ 'mʋ꞊ʋ ‑mɔ lɛ na ‑tɛɛ, 'kɩ 'ʋ ‑Yusu a ‑nagbopʋ ye'. ");
INSERT INTO ktj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Bʋ yɩ 'kɩ nɩ mi, ‑ɛ ‑bɩ ti nɩ ‑do a ti 'yri, ‑Yusu di ꞊nʋ ye' 'bɛ mɔ, ɛ wɛn: «'Aan 'wio,» ʋ nʋ‑ ‑mɔ ‑bɩ, ‑tɛ ʋ 'ye꞊e, 'ʋ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, 'ʋ bla꞊a kwlɩ yɩ bʋ, 'ʋ klɔ 'a bʋɩ, 'ʋ ‑tʋa 'a ‑tɩ a 'yi'bʋalɛ. ");
INSERT INTO ktj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ, ɛ wɛn: «A 'nɩ 'pie 'lɩ hʋannʋ. Ba mu, ba lee 'na ‑nagbopʋ, bʋ mu 'lɩ Galileblʋgba 'kwli. 'Kɩ ʋ di 'lɩ 'mʋ bʋ ‑yɛɛ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","‑Tɛ nʋgbɩ a 'mʋ, ʋ mi 'kɩ 'lɩ ‑Yusu a ‑nagbopʋ* ‑mɔ, ‑ɛ ‑bɩ 'sɛyo ‑mʋ', ‑ʋ ꞊tui ‑Yusu a 'dabio 'yie, 'waa nyibli ‑bɩ 'ya 'dɩɔ, 'ʋ lee Nyɩsʋa a ‑cɔhlʋnpinyʋ* a nyibli gbagbɩ ‑tɛblɩ a pɛpɛ ‑mʋ', ‑ɛ mu 'lu ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","‑Tɛ ʋ 'wɩn, ‑ɛ ‑bɩ ʋ kɔ 'blʋ a nyibli 'hʋɛn‑, ʋ 'kukue lɛ, ‑ɛ di꞊e nu, ʋ 'mʋ ‑tɩ a 'mʋ lɛ ‑pʋpʋ ‑nɩ. ‑Tɛ ʋ pʋpʋ 'kɩ꞊ɩ' lɛ, ‑ɛ ‑bɩ ʋ wɛn꞊ɛ kɩ, 'kɩ bʋ ‑ha 'lɩ 'wli ‑hʋɔhʋɩ, bʋ ‑nyi꞊e 'sɛyo a 'mʋ. ‑Tɛ ʋ ‑nyi 'kɩ ꞊nʋ꞊ʋ, ");
INSERT INTO ktj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","‑ɛ ‑bɩ kɛ‑ ʋ pɩ ꞊nʋ yɩ, ʋ wɛn: «Kɛ‑ ba pʋ: ‑A nɩ ŋmena', ‑Yusu a ‑nagbopʋ 'ʋ di 'tɔ, 'ʋ 'yri 'a ‑plahʋɩ.» ");
INSERT INTO ktj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kɛ‑ ʋ pɩ de: «'Bʋ mɔ, ‑gʋlʋnʋma 'bʋ 'wɩn, ‑a di 'a klɛ‑hɩhɩalɛ 'nɩ yi, ‑ɛ di꞊e nu, a 'nɩ ꞊ha 'kla‑wliye'yɩya 'ye,» ");
INSERT INTO ktj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","'sɛyo 'ʋ gba 'wliyɛ a 'mʋ, dɛ ‑mʋ', 'blʋ a nyibli pʋ lɛ bʋ nu, 'ʋ nu꞊o. Ɛ nɔ‑ nu꞊o, ‑hɔn 'ʋ ‑nyrɔwɔ a 'mʋ 'yie, ‑bʋ yɛ ‑nyrɔwɔ ‑bʋ kɩ, ‑tɩ a 'mʋ, 'ɛ 'hɛɛn bʋ, 'kɩ 'lɩ ‑Juukʋɛ* 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu a ‑nagbopʋ nɩ ‑pu ꞊tu 'ʋ ‑do ‑mʋ', ʋ mu nɩ, 'kɩ 'lɩ Galileblʋgba 'kwli, dʋgba ‑mʋ', ‑Yusu tɔɔ la ꞊nʋ, ɛ nɔ‑ ʋ 'ya 'lɩ 'lu. ");
INSERT INTO ktj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","'Kɩ dʋgba a 'mʋ 'lu, 'kɩ ɛ 'hrɩɩ 'lɩ ꞊nʋ yɩ. ‑Tɛ ʋ 'ye꞊e, ɛ nɔ‑ mɔ bʋ bla꞊a kwlɩ yɩ bʋ, bʋ 'bʋa nɛ 'a ‑tɩ 'yi. Kɛɛ, 'kɩ 'ʋ ‑tɩtɛ a 'mʋ, 'kɩ nyibli ‑bɩ nɩ 'ʋ, 'ʋ 'yɛ nɩ pʋ꞊ʋ ꞊haan‑tɩ', ‑ɛ mɔ, ‑Yusu ꞊nɩɔ, ‑ɛ 'hrɩɩ ꞊nʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ɛ nɔ ‑mɔ ‑Yusu bʋ 'yɩya 'ʋ ꞊nʋ 'hʋɩ bʋ, ɛ wɛn: «Kʋɛ 'lɩ yakɔ 'kwli bʋ, ‑bʋ yɛ ‑tʋtʋ kɩ, 'klɩ a pɛpɛ, 'n ni, 'nɩ kɔɔ nɛ 'a ‑nɛ ꞊dedede win kɩ, Nyɩsʋa, nɔ‑ ‑nyi 'mɔ꞊ɔ. ");
INSERT INTO ktj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ba mu 'lɩ dakɔ a pɛpɛ ‑mɔ, ‑ʋ nɩ 'nɛ‑ 'klɔ kɩ, ba nu꞊o, bʋ ‑hɛ 'na ‑nagbopʋ. Ba pʋ ꞊nʋ 'nie 'lu lɛ, 'kɩ 'lɩ ‑aan 'Baɩ Nyɩsʋa, kɔ 'a 'Yu, kɔ 'a ‑Hihiu* a 'nyrɛ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ba tɔɔ ꞊nʋ, 'kɩ bʋ ꞊tuu 'ʋ ‑tɩ a pɛpɛ ‑mʋ', 'n lee nɛ 'a mʋ, ba nu. Ba kɔ 'a yiyie, ‑ɛ mɔ, 'kɩ 'n di 'ʋ 'a mʋ 'hʋɩ nɩ, 'a ‑nɛ ‑nyrɔwɔ, ɛ 'mʋ꞊ʋ gba ‑gbagba, 'klɔ 'mʋ 'ʋ ‑wlu ‑hɔn.»");
INSERT INTO ktj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nyɩsʋa a ꞊haanwin, ɛ nɔ‑ 'crɩɩ 'nɛ‑ 'crɩɛn ‑bʋ 'kwli. Nyɩsʋa a win a 'mʋ, 'a 'Yu a ‑tɩ, ɛ nɛ ‑mɔ lɛ. 'A 'Yu a 'mʋ, 'a 'nyrɛ mɔ ‑Yusu 'Klɩsʋ. ");
INSERT INTO ktj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ti ꞊dʋ a ti 'yri, (‑tɛ ʋ 'tɩɛ 'yɛ la ‑Yusu nɩ kʋɛ,) ɛ kɔ la Nyɩsʋa a winwlɔn‑hanyɔ* ꞊dʋ. 'A 'nyrɛ mɔ la Esai. ‑Yusu kɔ nyiblo ꞊dʋ 'hʋɛn‑, ‑ɛ mɔ Saan Batisɩ, ʋ nʋ‑ kɔ ‑tɩ Esai a 'mʋ, ɛ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: «Nyɩsʋa wɛn 'nɩ: 'Na 'Yu o, 'n di ‑ha nyiblo, 'kɩ 'ʋ 'na ‑kʋan a ‑ta', ɛ 'mʋ mu, ɛ 'mʋ ‑na 'hru yɩ kla, 'tɩ‑ ꞊mʋ 'lɩ nyre. Ɛ 'wɩ yɩ, nyiblo a 'mʋ, ɛ di kla nyibli a ꞊wlɩ yrɛ, 'tɩ‑ ꞊mʋ 'lɩ nyre.» ");
INSERT INTO ktj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","'Kɩ 'lɩ 'crɩɛn a 'mʋ 'kwli, ʋ 'crɩ la ‑tɩ ‑bɩ. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: «Nyɩsʋa wɛn 'nɩ: Nyiblo a 'mʋ, ‑tɛ ‑mʋ', 'dʋ bii 'lɩ yɩ, 'kɩ ɛ di 'lɩ 'ti. 'Bʋ mɔ, 'bʋ yɩ nɩ hle, ɛ di 'yaa 'lɩ win, ɛ 'mʋ lɛ pʋ: 'Hru ‑bʋ, Kʋkɔnyɔ di na, ba 'sii ꞊nɛ yɩ, 'tɩ‑ Kʋkɔnyɔ a 'mʋ, ɛ 'mʋ di. Ɛ 'wɩ yɩ, 'aan 'klɔ bʋ 'sii 'ʋ yɩ, ‑ɛ di꞊e nu, a 'mʋ ‑mɔ ‑wɛ, 'tɩ‑ Kʋkɔnyɔ 'mʋ di.» ");
INSERT INTO ktj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","‑Tɛ Esai a 'mʋ, ɛ nu la 'a hɩhla, kɛ‑ nyiblo a 'mʋ, ɛ nu naalɛ. Ɛ nɔ‑ mɔ Saan Batisɩ. Saan a 'mʋ, ‑tɛ ‑mʋ', 'dʋ bii la 'lɩ yɩ, 'kɩ ɛ 'ti la 'lɩ, nyibli 'ʋ mi la 'lɩ꞊ɩ ‑mɔ. 'Bʋ yɩ nɩ hle, ɛ 'yɛɛ 'lɩ win, 'a win 'ɛ yɩ ‑tɛblɩ 'nyɩ lɛ ‑gbɛ, ɛ wɛn: «Ba yru꞊o, 'kɩ 'lɩ 'aan ꞊wlɩ kɩ, ‑ɛ mɔ, a ni yɩnyre‑tɛblɩ, 'kɩ 'ʋ Nyɩsʋa ye'. Ba hie 'ʋ yɩnyre‑tɛblɩ a 'mʋ bʋ, ba ‑nyi 'aan 'klɔ a pɛpɛ Nyɩsʋa, Nyɩsʋa 'mʋ 'aan yɩnyre‑tɛblɩ 'wʋwla ‑nɩ, 'mʋ 'a mʋ 'nie 'lu pʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nyibli ‑hʋɔhʋɩ ‑mʋ', ‑ʋ 'ti 'lɩ Sudeblʋgba 'kwli, kɔ 'dɩɔ ‑mʋ', ‑ɛ mɔ Jrusrɛ, kɛ‑ ʋ ni la, 'ʋ mi la 'ʋ꞊ʋ ye', ʋ 'mʋ 'a win 'wɩn, 'ʋ yɩ la 'waa yɩnyre‑tɛblɩ yrɛ ‑wɛɛn ‑nɩ, 'kɩ 'ʋ nyibli ye', 'tɩ‑, Saan, 'ɛ pɩ la ꞊nʋ 'nie 'lu lɛ, 'kɩ 'lɩ 'nie gbagbʋ ‑mʋ', ‑ɛ kɔ 'nyrɛ mɔ Sudɛn ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Saan a dɩɔnʋ a wlawlʋ, ɛ pɩ la, ɛ 'yɩ la dɛkɔnyɔ a wlawlʋ yɩ 'wɩ. Ʋ nu la ꞊gbukɩ‑so* a ‑pupui, 'ʋ hla la꞊a, 'ɛ nɛɛ la꞊a mʋmakɔ a 'bɛtɩyɛ kɩ. 'A dididɛ, ɛ yɩ la di, ɛ nɔ‑ mɔ 'kolio kɔ dʋnyra. (Saan mɔ la Nyɩsʋa a winwlɔn‑hanyɔ. Ɛ 'wɩ yɩ, ‑tɛ ‑mʋ', 'a 'bio Nyɩsʋa a winwlɔn‑hanyʋ ‑mʋ', ʋ nɩ la 'mʋ, yɩ‑hɛ‑nyrɛ a ti 'yri, kɛ‑ Saan a 'mʋ, ɛ nɩ la 'mʋ ‑wɛ.) ");
INSERT INTO ktj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kɛ‑ ɛ pɩ la nyibli ‑mʋ', ‑ʋ nɩ la 'ʋ yɩ, ‑ɛ mɔ: «Nyiblo ꞊dʋ di 'nɩ di. Nɔ‑ di 'ʋ 'mʋ ke' kʋɛ. Nɔ‑ di 'klɩ kɩ nɩ, ɛ 'mʋ 'ʋ 'mʋ ‑hi, 'kɩ 'lɩ Nyɩsʋa a 'nyrɛ 'kwli. 'Mɔ ‑bʋ, 'n 'yɩ nyiblo ꞊dʋ 'pa‑, 'kɩ ꞊bʋ di꞊e ‑hɛɛ ‑nɩ, 'kɩ 'ʋ 'a ‑nɛ ‑kʋandɛ ꞊dʋ a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","'Mɔ ‑bɩ, 'nie 'n pɩ 'a mʋ 'lu lɛ, kɛɛ, ɛ nɔ‑ ‑mɔ ‑bɩ, Nyɩsʋa a ‑Hihiu*, ɛ nɔ‑ ɛ di 'a mʋ ‑nyi.» ");
INSERT INTO ktj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","‑Nyrɔwɔ ꞊dʋ, ‑Yusu ‑hɔn la 'lɩ 'dɩɔ ‑mʋ', ‑ɛ mɔ Nasalɛtɩ, 'kɩ 'lɩ Galileblʋgba 'kwli, 'ɛ mu 'lɩ Saan ‑mɔ, Saan 'ɛ pʋ꞊ʋ 'nie 'lu, 'kɩ 'lɩ 'nie gbagbʋ ‑mʋ', ‑ɛ kɔ 'nyrɛ mɔ Sudɛn ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","‑Tɛ ɛ yɩ 'lɩ 'nie ‑mɔ nɩ ‑hʋɛn, ‑ɛ ‑bɩ ɛ 'ye yakɔ, 'ɛ ‑ki wlɔn, Nyɩsʋa a ‑Hihiu* 'ɛ ꞊tɩɩ 'ʋ꞊ʋ 'lu, ꞊wɩ yɩ, ‑tɛ ‑hungbe 'yɛ nɩ ꞊tɩɩ 'ʋ꞊ʋ 'lu, ");
INSERT INTO ktj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","kɔ, 'ʋ 'wɩn Nyɩsʋa a win, 'ɛ ‑hɔn 'lɩ yakɔ 'kwli. Kɛ‑ win a 'mʋ, ɛ pɩ: «‑Mɔ mɔ 'na 'Yu nɩ ‑do, 'n nʋɛ ‑nɩ ‑tɛɛ. ‑Nie 'mʋ dɔdʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ti nɩ ‑do a ti 'yri, ‑tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ 'kɩ Nyɩsʋa a ‑Hihiu gba 'lɩ ‑Yusu ‑tɛ ‑mʋ', 'dʋ bii 'lɩ yɩ. ");
INSERT INTO ktj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","‑Tɛ a 'mʋ, ɛ ‑hii 'lɩ ‑nyrɔwɩ a ‑wlɩ nɩ 'hʋɛn, 'kɩ 'lɩ mamʋɩ 'nyɩ. Ti a 'mʋ 'yri, 'kɩ 'kuo ‑hʋɩn* a nyiblo gbagbʋ, ‑ɛ kɔ 'nyrɛ ‑mɔ Satan, ɛ mu la 'ʋ꞊ʋ lɛ ꞊tɛɛ mɔ, ‑ɛ di꞊e nu, ‑Yusu 'mʋ ‑tɩ 'wla, 'kɩ 'ʋ 'a 'Baɩ Nyɩsʋa ye', kɛɛ, ɛ 'yɩ ‑tɩ 'wla, Nyɩsʋa 'ɛ tɛ 'a lɛlenyʋ bʋ, 'ʋ ‑tʋa 'a ‑hɛɛlɛ. ");
INSERT INTO ktj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ʋ nɩ 'ʋ bʋ ‑nɩnɩ, ‑ɛ ‑bɩ Saan Batisɩ ‑nɩ wɛn, ʋ pʋ꞊ʋ ꞊jɩ'. ‑Tɛ ʋ pʋ 'kɩ꞊ɩ ꞊jɩ', ‑ɛ ‑bɩ 'kɩ ‑Yusu mu 'lɩ Galileblʋgba 'kwli, 'ɛ nɛ Nyɩsʋa a win ‑mɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kɛ‑ ɛ pɩ: «Ti ‑mʋ' ‑kɔ 'yri Nyɩsʋa di 'ʋ nyibli a pɛpɛ win kɩ ‑kɔɔ ‑nɩ, ɛ 'mʋɛ yrɛ. 'A ‑tɩ, ba yru꞊o, 'kɩ 'lɩ 'aan ꞊wlɩ kɩ, ‑ɛ mɔ, a nu yɩnyre‑tɛblɩ, 'kɩ 'ʋ Nyɩsʋa ye'. Ba hie 'ʋ yɩnyre‑tɛblɩ a 'mʋ bʋ, ba ‑nyi 'aan 'klɔ a pɛpɛ Nyɩsʋa, kɔ, ba kuo Nyɩsʋa a win ꞊wlʋ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","‑Nyrɔwɔ ꞊dʋ, ‑ɛ ‑bɩ ‑Yusu mu 'lɩ Galileblʋgba a 'yru wien. Bʋ yɩ 'kɩ 'yru wien lɛ nɩ 'yrɛɛ ‑nɩ, ‑ɛ ‑bɩ ɛ yɛ la 'ʋ 'pʋpanyibli nɩ 'hʋɛn ꞊dʋ bʋ. 'Waa 'nyrɛ mɔ Simɔ (‑ɛ mɔ Piɛlɩ) kɔ 'a 'dɩayɩ Adre. 'Kɩ ʋ nɩ 'lɩ 'waa 'blagbɩ 'kwli, 'ʋ pɩ 'waa ‑tatɩ. ");
INSERT INTO ktj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","'Pʋpanyibli nɩ 'hʋɛn a 'mʋ, ɛ yɛɛ 'ʋ bʋ, kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «Ba di 'lɩ, a 'mʋ 'mʋ ꞊wien lɛ kʋɛ, a 'mʋ 'na ‑nagbopʋ ‑hɛ. 'N di꞊e 'nɩ nu, a 'mʋ ‑tonyibli lɛ 'kukue ‑nɩ. Ɛ 'wɩ yɩ, ‑tɛ a ni, 'a pɩ ‑tatɩ, 'a yɩ ‑hrin lɛ 'kukue ‑nɩ, kɛ‑ ba nu, ba 'kukue ‑tonyibli lɛ, ʋ 'mʋ 'na ‑nagbopʋ ‑hɛ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","‑Tɛ ɛ lee 'kɩ ꞊nʋ ‑tɩ a 'mʋ, ‑ɛ ‑bɩ ti nɩ ‑do a ti 'yri, ʋ hie 'ʋ 'waa ‑tatɩ bʋ, 'ʋ ‑tʋa 'a ꞊wienlɛkʋkʋɛ. ");
INSERT INTO ktj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Bʋ 'yɩya 'ʋ ye' bʋ dɛ gbe, ‑ɛ ‑bɩ ɛ yɛɛ 'ʋ 'pʋpanyibli ‑bɩ bʋ. 'Pʋpanyibli a 'mʋ, ʋ nʋ‑ mɔ Sakɩ kɔ Saan kɔ 'waa 'baɩ Sebede, kɔ 'waa 'baɩ a ‑kʋannunyibli, 'ʋ nɩ 'lɩ 'waa 'blagbɩ 'kwli, 'ʋ yɩ 'waa ‑tatɩ ꞊hrɛntɩ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","‑Tɛ ɛ yɛɛ 'ʋ 'dɩayɩnʋ nɩ 'hʋɛn a 'mʋ bʋ, ‑ɛ ‑bɩ ɛ da ꞊nʋ nɩ, 'kɩ bʋ ‑hɛ 'a ‑nagbopʋ, ti nɩ ‑do a ti 'yri, 'ʋ hie 'ʋ 'waa 'baɩ, kɔ 'a ‑kʋannunyibli 'hʋɛn‑ 'blagbɩ 'kwli bʋ, 'ʋ ‑tʋa ‑Yusu a ꞊wienlɛkʋkʋɛ. ");
INSERT INTO ktj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ mu 'lɩ 'dɩɔ ‑mʋ', ‑ɛ mɔ Kapɛnaɔ 'kwli. ‑Tɛ ‑Juukʋɛ* a ‑wuwle‑nyrɔwɔ* nyre 'ʋ, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ 'hʋɛn‑, ʋ pa 'lɩ Nyɩsʋa a 'kayu bʋ, ");
INSERT INTO ktj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","'ɛ bi 'ʋ, 'ɛ ‑tʋa ꞊nʋ Nyɩsʋa a ‑tɩ a tɔɔlɛ. Nyibli ‑mʋ', ‑ʋ nɩ la 'ʋ, ɛ mɔ 'waa ꞊wlɩlɛkɛɛdɛ, 'kɩ ‑Yusu bʋ di tɔɔlɛ lɛ nu. Ɛ 'nɩ ‑tɔɔ꞊ɔ lɩ, ꞊wɩ yɩ ‑tɛ ‑mʋ' ‑Juukʋɛ a tetetɔɔnyʋ ni tɔɔlɛ, kɛɛ, 'kɩ 'lɩ Nyɩsʋa a 'klɩ 'kwli, 'kɩ ɛ tʋɛ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ɛ kɔ nyɩbɛhɩan ꞊dʋ. Ɛ nɔ‑ 'ku ‑hʋan nɩ 'ʋ ke'. 'Kɩ ɛ nɩ 'lɩ Nyɩsʋa a 'kayu bʋ ‑wɛ. Ti nɩ ‑do a 'mʋ 'yri, 'kɩ 'lɩ Nyɩsʋa a 'kayu nɩ ‑do a 'mʋ bʋ, ɛ 'yɛɛ 'lɩ win, ");
INSERT INTO ktj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","'ɛ pɩ lɛ: «Nasalɛtɩ a ‑Yusu, ‑ha ‑a mʋ mɛ lɛ, ꞊nɩ 'bie 'lɩ ‑aan ‑tɩ 'nyɩ. ‑Di nɩ, ꞊mʋ ‑a mʋ bʋ ‑wɛ. 'N yi꞊e nɩ, nyiblo a 'dɩ ‑bɩ ‑pa 'mʋ. ‑Mɔ mɔ Nyɩsʋa a 'Yu, ‑mɔ ɛ lee 'nɛ‑.» ");
INSERT INTO ktj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ‑Yusu ꞊maa 'ku ‑hʋan a 'mʋ 'yi, ɛ wɛn: «Ma wien, 'tɩ‑ ‑hɔn 'ʋ nyiblo ‑bʋ ke'!» ");
INSERT INTO ktj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","‑Ɛ ‑bɩ 'ku ‑hʋan a 'mʋ, ɛ ꞊gbapʋ nyiblo a 'mʋ lɛ, 'ɛ pʋ ‑cici lɛ, 'tɩ‑ 'ɛ ‑hɔn 'ʋ꞊ʋ ke', 'ɛ ‑mu. ");
INSERT INTO ktj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ɛ kɛɛ nyibli a 'mʋ, ‑ʋ nɩ 'ʋ ꞊wlɩ lɛ, 'ʋ yɩ wlɔn lɛ 'pʋplɛ ‑nɩ, 'kɩ 'ʋ dɛ ‑mʋ', ‑ɛ mu 'lu ‑mɔ a ‑ta', ʋ wɛn: «Dɛ a 'mʋ, ɛ mɔ dɛ ꞊nɩɔ. Tɔɔlɛ yrayrʋ ‑bɩ ɛ ‑ya, 'kɩ 'lɩ Nyɩsʋa a 'klɩ 'kwli. Ɛ yɩ 'lɩ Nyɩsʋa a 'klɩ 'kwli nɩ ‑tʋɛ ‑nɩ, 'ɛ kɔɔ 'kuo ‑hʋɩn win kɩ, 'tɩ‑ 'kuo ‑hʋɩn a 'mʋ, ʋ ꞊tui 'ʋ꞊ʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Dɛ a 'mʋ, 'a ‑tɩ, ‑Yusu a 'nyrɛ 'ɛ 'hɛɛn Galileblʋgba a pɛpɛ kɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","‑Tɛ ʋ ‑hɔn 'lɩ Nyɩsʋa a 'kayu bʋ, ‑ɛ ‑bɩ ʋ mu 'lɩ Simɔ (Piɛlɩ) kɔ Adre 'hʋɛn‑ a ‑tɛ, Saan kɔ Sakɩ 'hʋɛn‑, 'ʋ kʋɛ ꞊nʋ ꞊wien. ");
INSERT INTO ktj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","'Kɩ 'lɩ 'kayu a 'mʋ bʋ, 'kɩ ʋ yɛɛ 'lɩ Simɔ a 'mʋ a 'dɔɔ‑ bʋ, 'a 'hʋɩ 'ɛ yɩ hren, 'ɛ pɛ bʋ. ‑Tɛ ʋ nyre 'lɩ 'kayu bʋ, ‑ɛ ‑bɩ ʋ lee ‑Yusu nɩ, ‑ɛ mɔ, Simɔ a 'dɔɔ‑ a 'hʋɩ hren nɩ, ");
INSERT INTO ktj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","‑Yusu 'ɛ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, 'ɛ klɔ 'a dabʋ bʋ, 'ɛ 'du꞊o ye'. Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ Simɔ a 'dɔɔ‑ a 'hʋɩ 'kee nɩ, 'ɛ bi 'ʋ, 'ɛ pi 'waa diidɛ. ");
INSERT INTO ktj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","‑Winseke, ‑tɛ ‑wuwle‑nyrɔwɔ* ‑wɛ 'lɩ, ‑ɛ ‑bɩ nyibli a pɛpɛ ‑mʋ', ‑ʋ kɔ kɩklanyibli, kɔ ‑ʋ ‑bɩ, 'kuo ‑hʋɩn* nɩ 'ʋ ke' lɛ, 'kɩ ʋ gba 'lɩ ꞊nʋ ‑Yusu ‑mɔ, ");
INSERT INTO ktj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","'dɩɔ a nyibli ‑hʋɔhʋɩ, 'ʋ ꞊gbee 'ʋ 'kayu a 'mʋ a ꞊hʋan.yɩ, ");
INSERT INTO ktj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","‑Yusu 'ɛ nu꞊o, nyibli a 'mʋ, 'waa 'kʋɛ a gblegble 'ɛ ‑wɛ, 'ɛ bla 'kuo ‑hʋɩn lɛ ‑wɛ, 'ɛ lee 'kuo ‑hʋɩn a 'mʋ, ‑ɛ mɔ, ʋ 'nɩ 'pʋʋ 'lɩ win, ‑ɛ nu꞊o, 'kuo ‑hʋɩn a 'mʋ, ʋ yi ‑Yusu nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","‑Nyragblɩ, halɔ nɩ ‑tʋtʋ klɛ, ‑Yusu 'ɛ 'du ye', 'ɛ mu 'lɩ ‑tɩtɛ ‑mʋ', 'dʋ bii 'lɩ yɩ, 'ɛ yɩ 'lɩ Nyɩsʋa ‑mɔ ‑hlee ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","‑Ɛ ‑bɩ Simɔ kɔ a 'bio 'hʋɛn‑, ʋ mu꞊o lɛ ꞊mʋɔ mɔ. ");
INSERT INTO ktj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","‑Tɛ ʋ yɛ꞊ɛ kɩ, ‑ɛ ‑bɩ ʋ wɛn: «‑Mɔ nyibli a pɛpɛ ꞊mʋɛ lɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","‑Ɛ ‑bɩ ɛ wɛn: «‑Ba mu 'lɩ ‑tɛ ‑bɩ, ‑ba mu 'lɩ 'dɩɩ ‑bɩ ‑bʋ, ‑ʋ ꞊glaa 'lɩ ‑a mʋ kɩ, 'mʋ 'lɩ Nyɩsʋa a ‑tɩ ‑tɔɔ ‑nɩ ‑wɛ. Ɛ nɔ‑ kɔ ‑tɩ Nyɩsʋa 'ɛ ya 'nɛ‑ 'mʋ ‑tʋtʋ kɩ,» ");
INSERT INTO ktj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","‑Yusu 'ɛ bi Galileblʋgba a pɛpɛ kɩ, 'ɛ nɛ Nyɩsʋa a 'kayo blɛ, 'ɛ tʋɛ Nyɩsʋa a ‑tɩ, kɔ, 'ɛ blɛ 'kuo ‑hʋɩn* lɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","‑Nyrɔwɔ ꞊dʋ, ‑ɛ ‑bɩ ꞊hrannunyɔ ꞊dʋ, ɛ nɔ‑ mu la 'lɩ ‑Yusu ‑mɔ, 'ɛ bla꞊a kwlɩ yɩ, ɛ wɛn: «'N nyaa ‑mʋ lɛ, nu꞊o, 'na 'kʋɛ bʋ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","‑Ɛ ‑bɩ 'a nyaɩ ‑tʋa la ‑Yusu a nunuo, 'ɛ ‑hrɛn la꞊a lɛ, ɛ wɛn: «'N ‑hʋɛ꞊ɛ nɩ, 'kɩ ‑na 'kʋɛ bʋ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ 'a 'kʋɛ ‑wɛ nɩ, ");
INSERT INTO ktj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","‑Yusu 'ɛ ti꞊e ‑tɛɛ, ɛ wɛn: «‑Wɛ 'lɩ ‑bʋ mu 'kɩ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","꞊Nɩ 'lee 'lɩ nyiblo ꞊dʋ, kɛɛ, mu ‑bʋ tɔɔ ‑dɩɔnʋ Nyɩsʋa a ‑cɔhlʋnpinyɔ* yɩ, ɛ 'mʋ꞊ʋ 'ye, ‑ɛ mɔ, ‑na 'kʋɛ ‑wɛ nɩ. 'A ‑tɩ, gba ‑tɛblɩ ‑mʋ', ʋ ni, 'ʋ yɩ ‑cɔhlʋn pi, 'kɩ 'ʋ Nyɩsʋa ye', ‑tɛ Nyɩsʋa a winwlɔn‑hanyɔ* Moise, ɛ nu la 'a hɩhla, ti ‑hi la a ti 'yri, ‑ɛ di꞊e nu, nyibli a pɛpɛ 'mʋ꞊ʋ yi, ‑ɛ mɔ, ‑na 'kʋɛ ‑wɛ nɩ!» ‑Ɛ ‑bɩ ɛ ‑hɔn 'ʋ꞊ʋ 'hʋɩ nɩ, 'ɛ ‑mu. ");
INSERT INTO ktj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kɛɛ, ‑tɛ ɛ ‑mu, ‑ɛ ‑bɩ ɛ ‑tʋa 'a ‑mɔlɛnɩna, 'kɩ 'ʋ nyibli ye', ‑tɛ a 'kʋɛ nu ‑wʋwɛ, ‑tɩ a 'mʋ, 'ɛ 'hɛɛn 'blʋgba kɩ bʋ. ‑Tɛblɩ a 'mʋ, 'a ‑tɩ, ‑Yusu 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ 'ya 'dɩɔ ꞊dʋ 'kwli, 'ɛ bii yɩ. Nyibli, ʋ nʋ‑ ‑hʋɛn 'kɩ ‑tɛblɩ 'nyɩ lɛ, 'ʋ mi 'lɩ꞊ɩ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","‑Nyrɔwɩ gbi bʋ ‑hi, ‑ɛ ‑bɩ ‑Yusu ꞊hɩan ‑mɔ, 'ɛ di 'lɩ 'dɩɔ ‑mʋ', ‑ɛ mɔ Kapɛnaɔ 'kwli. ‑Tɛ nyibli 'wɩn, ‑ɛ mɔ, ‑Yusu ꞊hɩan ‑mɔ, ");
INSERT INTO ktj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","‑ɛ ‑bɩ 'waa ‑hʋɔhʋɩ mu 'lɩ꞊ɩ ‑mɔ. Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ 'kayu ‑mʋ', ɛ nɩ 'lɩ bʋ, ɛ 'yii 'lɩ nɩ, 'kɩ 'ʋ nyibli ‑mɔ', ‑ʋ mu꞊o 'ye mɔ, ɛ mɔ 'hru 'yɩ 'ʋ ꞊hʋan.yɩ ‑nɩ, nyibli a ‑tɩ. 'Kɩ 'lɩ nyibli a 'mʋ 'nyɩ, 'kɩ ‑Juukʋɛ* a tetetɔɔnyʋ ‑bɩ nɩ 'lɩ. Nyibli a pɛpɛ a 'mʋ, ‑ʋ nɩ ‑tuo a 'mʋ kɩ, ʋ nʋ‑ ‑Yusu tʋɛ Nyɩsʋa a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","‑Ɛ ‑bɩ nyibli ‑bɩ, ʋ nʋ‑ mi 'lɩ ‑Yusu ‑mɔ. 'Kɩ 'lɩ nyibli a 'mʋ 'nyɩ, 'kɩ nyibli nɩ ‑hɛn nɩ 'lɩ, 'ʋ 'ble ‑hanmakɩ. ‑Hanmakɩ a 'mʋ, ɛ nɔ‑ kɔ 'kwli, ʋ pɩa 'lɩ lɛ‑yɩyrɛnyɔ bʋ, 'ʋ gbɛ꞊ɛ ‑Yusu yɩ. ");
INSERT INTO ktj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bʋ nyre 'lɩ 'kayu a 'mʋ ye', 'hru 'yɩ ‑tɛ ‑nɩ, 'kɩ 'ʋ nyibli a ‑hʋhʋʋ a ‑ta'. ‑Tɛ bʋ di nu, ʋ 'mʋ 'ʋ 'waa ‑nɛ lɛ‑yɩyrɛnyɔ ‑Yusu 'hʋɩ ‑nyree ‑nɩ, ʋ 'yɩ꞊ɩ ‑yi. Ɛ nɔ‑ mɔ bʋ 'ya 'lɩ 'kayu kɩ, bʋ ‑ha 'lɩ 'hʋɔ, 'kayu a 'mʋ kɩ. ‑Tɛ ‑Yusu ꞊tuu 'ʋ 'yie bʋ ‑tɛɛ, 'kɩ ʋ ꞊tɩɔ 'ʋ lɛ‑yɩyrɛnyɔ a 'mʋ, ‑Yusu 'mʋ꞊ʋ nu, 'a 'kʋɛ 'mʋ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","‑Tɛ ‑Yusu 'ye꞊e, ‑ɛ mɔ, nyibli a 'mʋ, ʋ kuo ꞊nɛ ꞊wlʋ yɩ, ‑ɛ mɔ, ɛ ‑wɛ 'lɩ bʋ nu꞊o nɩ, lɛ‑yɩyrɛnyɔ a 'mʋ, 'a 'kʋɛ bʋ ‑wɛ nɩ, ɛ wɛn: «'Na 'yu, ‑tɛblɩ ‑bʋ, ‑nu, ‑ɛ nyre yɩ, 'kɩ 'ʋ Nyɩsʋa ye', ɛ 'wʋwlɛ kɛ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","‑Ɛ ‑bɩ tetetɔɔnyʋ ‑mʋ', ‑ʋ nɩ 'ʋ, ʋ 'pʋplɛ lɛ, 'kɩ 'lɩ 'waa dɩɔnʋ a ꞊wlɩ kɩ, ʋ wɛn: ");
INSERT INTO ktj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Dɛ ‑bʋ, ‑Yusu ‑bʋ, ɛ ni, ɛ 'wɩ yɩ, Nyɩsʋa a ‑tɩ ɛ yɩ lɛ ‑hɛɛ ‑nɩ, 'ɛ ni 'pʋplɛ lɛ. 'Tɩ‑ ɛ wɛn 'nɩ, ɛ mɔ Nyɩsʋa ꞊nɩɔ. Nyɩsʋa nɩ ‑do, ɛ nɔ‑ ‑wɛ 'lɩ ‑bʋ 'wʋwla nyiblo a dɛ 'kuku.» ");
INSERT INTO ktj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Dɛ a 'mʋ, ʋ nɛɛ ꞊wlɩ klɛ, ‑Yusu yru꞊o nɩ, ‑ɛ ‑bɩ ɛ wɛn: «Dɛ‑ kɔ ꞊wlɩdʋ ‑bʋ a nɛɛ 'kɩ lɛ 'lɩ? A 'yɩ wɛn yɩ ‑blɛɛ ‑nɩ, ba naa wɛn ꞊wlɩdʋ a 'mʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","'Aan ꞊wlɩ wɛn 'nɩ, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ lee nyiblo ‑bʋ, ‑ɛ mɔ, 'a dɛ 'kuku 'wʋwlɛ nɩ, ɛ kɔ, 'aan ꞊wlɩ wɛn 'nɩ, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ lee ꞊nɛ, ‑ɛ mɔ, bʋ 'du ye', bʋ 'du 'a ‑hanmakɩ ye', bʋ na. ");
INSERT INTO ktj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kɛɛ, ba yi꞊e, ‑ɛ mɔ, 'mɔ ‑mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'tɩ‑ 'mɔ ‑mɔ Nyɩsʋa a 'Yu, ɛ lee 'nɛ‑ ‑tʋtʋ kɩ. Nyɩsʋa a ꞊gbɛtʋ, ɛ nɔ‑ ‑nyi 'mʋ 'klɩ, 'kɩ ꞊bʋ 'wʋwla ‑tonyibli a dɛ 'kuku, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, 'ɛ ‑nyi 'mʋ 'klɩ ‑wɛ, 'kɩ ꞊bʋ nu꞊o, ‑tonyibli a 'kʋɛ bʋ ‑wɛ. 'A ‑tɩ, nyiblo ‑bʋ, ʋ ‑ya, 'n kɔ ꞊bʋ nu꞊o, 'a 'kʋɛ 'mʋ ‑wɛ, ‑ɛ di꞊e nu, a 'mʋ꞊ʋ lɛ yru, ‑ɛ mɔ, ‑tɩ ‑bʋ, 'n lee wɛn 'a mʋ, ɛ mɔ ꞊han‑tɩ ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","‑Ɛ ‑bɩ ɛ ꞊hɩan ‑mɔ de, 'ɛ ‑tʋa 'lɩ lɛ‑yɩyrɛnyɔ a 'mʋ, 'a ‑mɔhleelɛ, ɛ wɛn: «'N yɩ ‑mʋ 'nɩ ‑lee ‑nɩ, 'du ye', 'du ‑na ‑hanmakɩ ye', ‑bʋ ‑mu 'lɩ ‑na 'kayu bʋ, ‑na 'kʋɛ ‑wɛ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ nyiblo a 'mʋ, ɛ 'du ye', 'ɛ 'du 'a ‑hanmakɩ ye', nyibli yɩ 'ʋ꞊ʋ ‑mɔ lɛ nɩ tɛ, 'ɛ 'hrɩ, 'ɛ ‑mu. ‑Ɛ ‑bɩ, ɛ kɛɛ nyibli a 'mʋ, ‑ʋ nɩ 'ʋ, 'waa ꞊wlɩ lɛ, 'ʋ pɩ Nyɩsʋa 'nyrɛ lɛ, ʋ wɛn: «‑A 'yɩ ‑hʋan꞊a nɩ 'ye.» ");
INSERT INTO ktj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ti gbi bʋ ‑hi, ‑ɛ ‑bɩ ‑Yusu mu 'lɩ Galileblʋgba a 'yru wien de, nyibli ‑hʋɔhʋɩ 'ʋ mi 'lɩ꞊ɩ 'hʋɩ, 'ɛ tʋɛ ꞊nʋ Nyɩsʋa a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Bʋ yɩ 'yru wien lɛ nɩ 'yrɛɛ ‑nɩ, ‑ɛ ‑bɩ ɛ yɛɛ 'ʋ nyɩbɛhɩan ꞊dʋ bʋ. 'A 'nyrɛ mɔ Lefi, ‑ɛ mɔ Alʋfe a 'yu. Lefi a 'mʋ, ɛ mɔ la 'blʋwli'tɩnyɔ ꞊nɩɔ. 'Kɩ ɛ nɩ 'lɩ 'blʋwli'tɩɩlɛ' bʋ. (Kɛɛ, nyibli 'nɩ ‑hʋa꞊a lɩ 'blʋwli'tɩnyʋ, ‑ɛ nu꞊o, ʋ yɩ di 'yiyriwli.) ‑Ɛ ‑bɩ, kɛ‑ ‑Yusu pɩ Lefi a 'mʋ yɩ: «Kʋɛ 'mʋ ꞊wien lɛ, ꞊mʋ 'na ‑nagbopi ‑hɛ!» ‑Ɛ ‑bɩ Lefi 'du ye', 'ɛ kʋɛ꞊ɛ ꞊wien, ");
INSERT INTO ktj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Lefi a 'mʋ, ɛ nɔ‑ da ‑Yusu kɔ 'a ‑nagbopʋ nɩ 'hʋɛn‑ dididɛ ‑mɔ, 'ɛ da 'a 'bio 'blʋwli'tɩnyʋ ‑bɩ, kɔ hɩapʋnyibli ‑bɩ ‑wɛ, ‑ʋ kɔ 'klɔ, ‑ɛ 'yɩ 'ʋ yɩ 'sii ‑nɩ, ‑ɛ di꞊e nu, ʋ 'mʋ dɛ di. Nyiblidʋ a 'mʋ, ‑ʋ kɔ 'klɔ, ‑ɛ 'yɩ 'ʋ yɩ 'sii ‑nɩ, ʋ nʋ‑ kɔ kasɩ, ‑ʋ yɩ ‑Yusu ꞊wien lɛ kʋɛ. ");
INSERT INTO ktj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bʋ nɩ 'kɩ 'ʋ dɛdiilɛ', ‑ɛ ‑bɩ ‑Juukʋɛ* kɔ tetetɔɔnyʋ kɔ Falisi꞊tumu* a nyibli 'hʋɛn‑, ʋ 'ye꞊e nɩ, ‑ɛ mɔ, ‑Yusu kɔ nyiblidʋ a 'mʋ 'hʋɛn‑, ‑ʋ kɔ 'klɔ ꞊yɩ 'ʋ yɩ 'sii ‑nɩ, ʋ nʋ‑ nɩ 'ʋ dɛdi‑tuo nɩ ‑do kɩ. ‑Ɛ ‑bɩ ʋ lee ‑Yusu a ‑nagbopʋ nɩ, ʋ wɛn: «Dɛ‑ nu 'kɩ꞊ɩ, ‑Yusu kɔ 'blʋwli'tɩnyʋ, kɔ nyiblidʋ ‑bʋ, ‑ʋ kɔ 'klɔ ꞊yɩ 'ʋ yɩ 'sii ‑nɩ 'hʋɛn‑, 'ʋ nɩ 'ʋ dɛdihu nɩ ‑do kɩ 'lɩ? Ɛ 'yɩ wɛn yɩ ‑blɛɛ ‑nɩ, bʋ nu wɛn dɛ a 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","‑Yusu bʋ 'wɩn ‑tɩ a 'mʋ, ɛ nɔ‑ mɔ bʋ pʋ lɛ: «Nyiblo ‑bʋ, ‑ɛ kɔ 'hʋɩ ‑nu ‑tɛɛ, ɛ 'nɩ ꞊mʋɔ꞊ɔ lɩ ‑dɔtɔ a 'yiye lɛ, kɛɛ, nyiblo ‑bʋ, ‑ɛ kɔ 'hʋɩ ‑hren, ɛ nɔ‑ ꞊mʋɛ ‑dɔtɔ a 'yiye lɛ. 'N 'yɩ ‑di, 'kɩ 'ʋ nyibli ‑bʋ, ‑ʋ pʋ lɛ, ‑ɛ mɔ, 'waa 'klɔ 'sii 'ʋ yɩ a ‑ta', kɛɛ, nyibli ‑bʋ, ‑ʋ yi꞊e, ‑ɛ mɔ, 'waa 'klɔ 'yɩ 'ʋ yɩ 'sii ‑nɩ, ʋ nʋ‑ kɔ ‑tɩ 'nɩ ‑di, 'mʋ ꞊nʋ ‑lee ‑nɩ, ‑ɛ mɔ, 'waa dɛ 'kuku ‑mʋ', ʋ ni, bʋ hie 'ʋ꞊ʋ bʋ, bʋ ‑nyi 'waa 'klɔ a pɛpɛ Nyɩsʋa.» ");
INSERT INTO ktj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","‑Nyrɔwɔ ꞊dʋ, Saan Batisɩ ‑ɛ pɩ nyibli 'nie 'lu lɛ, 'a ‑nagbopʋ kɔ Falisi꞊tumu* a nyibli 'hʋɛn‑, ʋ nʋ‑ yɩ ꞊ci*, ꞊wɩ yɩ, ‑tɛ 'waa tete ni 'a hɩhla, nyibli ꞊dʋ 'ʋ mu 'lɩ ‑Yusu ‑mɔ, 'ʋ mu꞊o 'bɛti mɔ, ʋ wɛn: «Dɛ‑ nu 'kɩ꞊ɩ, Saan a ‑nagbopʋ kɔ Falisi꞊tumu a nyibli 'hʋɛn‑ 'ʋ yɩ ꞊ci, 'tɩ‑ ‑mɔ ‑bɩ, ‑na ‑nagbopʋ* 'yɛ nɩ ꞊ci 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ, ɛ wɛn: «Nyɩbɛyu ‑bʋ, ‑ɛ pʋɛ 'blɩ, 'a 'bio ‑mʋ', ɛ dɛ 'blɩpadiidɛ kɩ, 'bʋ mu 'blɩpadiidɛ a 'mʋ, 'a ‑tuo kɩ, a 'bio a 'mʋ, ʋ 'nɩ ꞊ci꞊e lɩ. Ɛ 'wɩ yɩ, 'blɩ a pʋpa mɔ dɔdʋdɛ ꞊nɩɔ. 'A ‑tɩ, ʋ 'yɩ ꞊cicie ‑kɔ, ti nɩ ‑tie ‑mʋ', 'blɩpanyɔ di 'lɩ ꞊nʋ 'nyɩ ‑hii ‑nɩ. Dɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ ꞊nɩɔ. Dɔdʋ a ‑tɩ, ti nɩ ‑tie ‑bʋ, 'n di 'nɛ‑ ꞊nʋ 'hʋɩ ‑hii ‑nɩ, 'na ‑nagbopʋ 'nɩ ꞊ci꞊e nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kɛɛ, ɛ di kɔ ti, ‑ɛ di 'ʋ nyre, ʋ 'mʋ 'lɩ 'mʋ 'na ‑nagbopʋ 'nyɩ ‑ha. Ti a 'mʋ 'yri, 'kɩ ʋ di 'ʋ ꞊cii ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","‑A 'blikʋɛ wɛn 'nɩ: Nyiblo 'nɩ 'du꞊o lɩ dakɩbɩa yrayrʋ ye', ɛ 'nɩ ‑ma꞊a da'ka a 'hʋɔ. 'Bʋ mɔ, 'bʋ nu danʋ yrayrʋ a 'kɩbɩa, 'bʋ ‑ma da'ka, ti ‑kɔ 'yri ʋ di 'ʋ꞊ʋ ‑yraa ‑nɩ, ‑ɛ ‑bɩ danʋ yrayrʋ a 'mʋ, ɛ kɔ bʋ 'yɩya ‑mɔ. 'Bʋ 'yɩya ‑mɔ, dayrayrʋ a 'mʋ, ɛ kɔ bʋ cra da'ka a 'mʋ, 'a 'hʋɔ 'ka a 'mʋ, ɛ 'mʋ 'yri lɛ 'bʋa ‑tɛɛ. ");
INSERT INTO ktj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mɔ, yonɔ yrayrɩ, ‑ɛ 'plui, nyiblo 'nɩ 'du꞊o lɩ꞊ɩ ye', ɛ 'nɩ ‑pʋ꞊ʋ 'lɩ꞊ɩ mʋmakɔ a buo 'ka 'kwli. 'Bʋ pʋ 'lɩ꞊ɩ buo 'ka a 'mʋ 'kwli, 'bʋ ka꞊a yɩ, ti ‑mʋ' ‑kɔ 'yri ɛ di 'plu, 'bʋ yɩ nɩ 'yɛ, ɛ kɔ bʋ wa mʋmakɔ a buo a 'mʋ, nɔ 'mʋ bʋ 'wlɛ. Ɛ nɔ‑ nu꞊o, 'kɩ 'lɩ mʋmakɔ a buo yrayrʋ 'kwli, 'ʋ pɩ 'lɩ nɔ yrayrɩ' lɛ. (Ɛ nɔ‑ nu꞊o 'kɩ, nyiblo 'yɛ nɩ 'du ‑tɛblɩ 'kɩ ye', 'ɛ 'yɛ nɩ pʋ꞊ʋ ‑tɛblɩ yrayrɩ kɩ. Ɛ 'nɩ ‑bibi꞊e lɩ 'yi lɛ.)» ");
INSERT INTO ktj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","‑Wuwle‑nyrɔwɔ ꞊dʋ 'kwli, ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ mu lɛ na mɔ. Bʋ yɩ 'kɩ nɩ mi, ‑ɛ ‑bɩ ʋ 'bɛɛ 'lɩ 'dʋdɔ‑tɛblɩ ꞊dʋ, ‑ɛ 'wɩ ‑kʋbʋ yɩ a ‑ci 'kwli ꞊tɩɔ. Ɛ nɔ‑ kɔ blɩ gbi 'a ‑nagbopʋ yɩ 'cɛ, ʋ yɩ di. ");
INSERT INTO ktj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","'Kɩ Falisi꞊tumu* a nyibli nɩ 'lɩ ‑ci a 'mʋ kɩ. ‑Tɛ ‑Yusu a ‑nagbopʋ yɩ 'dʋdɔ‑tɛblɩ a 'mʋ, 'a blɩ gbi nɩ 'cɛ, ‑ɛ ‑bɩ ʋ yɩ 'kɩ ‑Yusu 'nɩ ‑lee ‑nɩ, ʋ wɛn: «'Ye kɛ dɛ ‑na ‑nagbopʋ ni, ɛ ꞊ŋa nɩ. Nyɩsʋa a tete wɛn 'nɩ: Nyiblo 'nɩ 'nuo 'lɩ ‑kʋan, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ‑wɔn: «‑Tɩ ‑mʋ', ʋ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, 'kɩ 'ʋ ‑aan 'baɩ gbagbʋ, ‑ɛ mɔ bodɩɔ Dafidɩ a ‑ta', 'n pʋ꞊ʋ ꞊haan‑tɩ, ‑ɛ mɔ, a ‑hre꞊e nɩ. Dɛ a 'mʋ, ʋ 'crɩ la, ɛ nɔ‑ ‑bʋ: ‑Nyrɔwɔ ꞊dʋ, ‑tɛ 'kanʋ ni la bodɩɔ Dafidɩ, ɛ kɔ 'a nyibli 'hʋɛn‑, ");
INSERT INTO ktj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ɛ pa la 'lɩ Nyɩsʋa a 'kayu bʋ, 'ɛ ‑ha la 'lɩ 'flɔɔ ‑mʋ', ‑ɛ pɛ la 'ʋ 'teble kɩ bʋ, 'ɛ di la꞊a, 'ɛ ‑nyi la 'a dɛ ‑bɩ 'a nyibli, 'ʋ di la꞊a ‑wɛ. Kɛɛ, Nyɩsʋa a tete wɛn 'nɩ, Nyɩsʋa a ‑cɔhlʋnpinyʋ* nɩ ‑do, ʋ nʋ‑ ‑wɛ 'lɩ ‑bʋ di 'flɔɔdʋ a 'mʋ, ‑kɔtɩ 'flɔɔdʋ a 'mʋ, ‑ɛ nɩ la 'lɩ Nyɩsʋa a 'kayu a 'mʋ bʋ, ʋ ‑ha la꞊a nɩ, 'kɩ 'ʋ Nyɩsʋa a ‑ta'. Ti a 'mʋ 'yri, nyɩbɛyu ‑mʋ', ‑ɛ mɔ Abiata, ɛ nɔ‑ mɔ la ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","‑Ɛ ‑bɩ, kɛ‑ ɛ pɩ ꞊nʋ yɩ de, ɛ wɛn: «‑Tɛ Nyɩsʋa nu la 'klɔ, ‑ɛ ‑bɩ ɛ nu la ‑tonyiblo, 'tɩ‑ 'ɛ ‑ha 'lɩ ‑nyrɔwɔ nɩ ‑do, ‑ɛ kɔ 'kwli ‑tonyiblo di 'ʋ ‑wlee ‑nɩ, ɛ 'mʋ 'lɩ 'hʋɩ lɛ ‑ha. Nyɩsʋa 'yɩ 'lɩ ‑wuwle‑nyrɔwɔ 'lɩ ‑ha, 'kɩ nyiblo 'mʋ ꞊hɩʋɛn 'ye, 'kɩ 'lɩ ‑nyrɔwɔ a 'mʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ɛ nɔ‑ nu꞊o, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, Nyɩsʋa 'ɛ le 'nɛ‑ 'mʋ, 'ɛ ‑nyi 'mʋ 'klɩ, 'kɩ ꞊bʋ lee nɛ 'a ‑nɛ nyiblo ꞊dʋ dɛ, ɛ ‑wɛ 'lɩ bʋ nu, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","‑Wuwle‑nyrɔwɔ ‑bɩ 'kwli, ‑Yusu mu 'lɩ Nyɩsʋa a 'kayu bʋ de. 'Kɩ ɛ yɛɛ 'lɩ nyɩbɛhɩan ꞊dʋ bʋ. Nyɩbɛhɩan a 'mʋ, 'a dabʋ 'kʋ la nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bʋ nɩ 'ʋ bʋ, ‑ɛ ‑bɩ Falisi꞊tumu* a nyibli, ‑ʋ nɩ 'ʋ, ʋ ‑tʋa 'yie a ke'gbaalɛ, ʋ 'mʋ ‑Yusu 'ye, 'bʋ mɔ, 'bʋ kɔ bʋ nu꞊o, nyɩbɛhɩan a 'mʋ a 'kʋɛ bʋ ‑wɛ, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ a 'mʋ 'kwli, ‑ɛ di꞊e nu, ‑Yusu 'bʋ nu꞊o, ʋ 'mʋ꞊ʋ ‑tɩ ‑yɛɛ ‑nɩ. (Falisi꞊tumu a nyibli wɛn 'nɩ, 'bʋ nu꞊o, nyiblo a 'kʋɛ bʋ ‑wɛ, ɛ mɔ ‑kʋan a nunuo ꞊nɩɔ. 'Tɩ‑ Nyɩsʋa a tete wɛn 'nɩ, nyiblo 'nɩ 'nuo 'lɩ ‑kʋan, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli.) ");
INSERT INTO ktj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","‑Ɛ ‑bɩ ‑Yusu lee nyɩbɛhɩan a 'mʋ nɩ, ɛ wɛn: «'Du ye', ‑bʋ ‑nyra 'lɩ nyibli 'nyɩ bʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","‑Ɛ ‑bɩ ‑Yusu 'bɛti Falisi꞊tumu a nyibli a 'mʋ nɩ, ɛ wɛn: «‑Bɩ' Nyɩsʋa a tete pɩ 'lɩ? 'Kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli, nyiblo bʋ nu ꞊haandɛ, kɔ, bʋ nu dɛ ‑hʋan, dɛ a 'dɩ ‑bɩ ‑nu ‑tɛɛ 'lɩ? Nyiblo bʋ wa 'a 'bɩhɩan, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli, ‑ɛ di꞊e nu, ɛ 'nɩ ꞊ha 'kʋ, kɔ, nyiblo bʋ ‑ha 'a 'bɩhɩan a ‑hʋnhlʋn mɛ lɛ bʋ 'wan, dɛ a 'dɩ ‑bɩ ‑nu ‑tɛɛ 'lɩ?» ‑Ɛ ‑bɩ 'waa pɛpɛ, ʋ nu gbee. Ʋ 'nɩ pʋ꞊ʋ win. Ʋ 'nɩ ‑hʋa꞊a ‑Yusu a ꞊wɔn a ꞊tutuo. ");
INSERT INTO ktj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","‑Ɛ ‑bɩ ‑Yusu 'ye꞊e nɩ, ‑ɛ mɔ, nyibli a 'mʋ, 'waa 'lulɛ‑hihie nyre yɩ, kɔ, ʋ 'yɩ nyiblo ꞊dʋ a nyaɩ ‑kɔ. Ɛ nɔ‑ nu꞊o, ‑Yusu 'ɛ ‑ha 'lɩ yrʋ yigbakla, 'ɛ yɩ ꞊nʋ 'ye, kɔ, 'kla 'ɛ 'yɛ꞊ɛ ‑wliye. ‑Ɛ ‑bɩ kɛ‑ ɛ pʋ nyɩbɛhɩan a 'mʋ yɩ, ɛ wɛn: «Hrʋ ‑na dabʋ ‑mʋ', ‑ɛ 'kʋ,» ‑ɛ ‑bɩ, ɛ hrʋ꞊ʋ nɩ. Bʋ hrʋ 'kɩ 'a dabʋ a 'mʋ, ɛ 'hrɩ 'klɔ, 'ɛ bi 'ʋ 'a dɩɔnʋ a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","‑Tɛ ‑Yusu nu꞊o, nyiblo a 'mʋ a 'kʋɛ, ɛ ‑wɛ, ‑ɛ ‑bɩ Falisi꞊tumu a nyibli a 'mʋ, ʋ ‑hɔn 'ʋ ‑tɛ a 'mʋ nɩ, 'ʋ mu 'hra pa mɔ, ʋ kɔ 'kɩɩn Helɔdɩ a nyibli 'hʋɛn‑, ‑tɛ ‑mʋ' ʋ di ‑Yusu a 'lɩla nu, 'ʋ mu 'a ꞊tɔ lɛ ꞊mʋɔ mɔ. ");
INSERT INTO ktj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","'Tɩ‑ dɛ a 'mʋ, ɛ 'mʋ ‑hi mɔ mu, ‑ɛ ‑bɩ 'kɩ ‑Yusu mu 'lɩ Galileblʋgba a 'yru wien, ɛ kɔ 'a ‑nagbopʋ* 'hʋɛn‑, nyibli ‑hʋɔhʋɩ 'ʋ kʋɛ꞊ɛ ꞊wien. Nyibli a 'mʋ, ‑ʋ ‑bɩ ‑hʋɛn 'lɩ Galileblʋgba 'kwli, ‑ʋ ‑bɩ 'ʋ ‑hʋɛn 'lɩ Sudeblʋgba, ");
INSERT INTO ktj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","kɔ Jrusrɛdɩɔ, kɔ Yidumeblʋgba 'kwli, kɔ 'blʋgba ‑mʋ', ‑ɛ nɩ 'lɩ Sudɛn a 'nikɩ, kɔ 'blʋgbɩ, ‑ʋ ꞊glaa 'lɩ 'dɩɩ ‑mʋ', ‑ʋ mɔ Tilɩ kɔ Sidɔ 'hʋɛn‑ 'kwli. Nyibli a pɛpɛ a 'mʋ, ‑ʋ ‑hʋɛn 'lɩ 'waa 'dɩɩ klɛ, ꞊wlɩlɛkɛɛ‑tɛblɩ a pɛpɛ ‑mʋ', ‑Yusu ‑nu, ɛ nɔ‑ kɔ ‑tɩ ʋ 'wɩn. Ɛ nɔ‑ nu꞊o, 'ʋ di 'nɛ꞊ɛ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","‑Ɛ ‑bɩ ɛ lee nɛ 'a ‑nagbopʋ nɩ, bʋ ꞊mʋɛ ꞊nɛ 'blagbɩ lɛ, ‑ɛ di꞊e nu, dakɔ 'bʋ yɩ꞊ɩ ‑hʋnhlʋn lɛ nɩ ‑kɩkɛ ‑nɩ, ɛ 'mʋ 'lɩ꞊ɩ 'kwli 'ya. ");
INSERT INTO ktj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","'Kɩ 'lɩ ‑nyrɔwɔ nɩ ‑do a 'mʋ 'kwli, 'tɩ‑ ɛ 'mʋ 'lɩ 'yru wien mu, ɛ nu꞊o nɩ, nyibli ‑hʋɔhʋɩ a 'kʋɛ 'ɛ ‑wɛ. Ɛ nɔ‑ nu꞊o, nyibli a pɛpɛ ‑mʋ', ‑ʋ kɔ 'hʋɩ ‑hren, 'ʋ 'kɩkɛ ‑nɩ, 'ʋ yɩ 'ʋ꞊ʋ 'hʋɩ ꞊gbee ‑nɩ, 'a ‑nɛ nyiblo, ɛ 'mʋ ‑Yusu lɛ ‑hrɛn, 'a 'kʋɛ 'mʋ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","'Waa 'bio ‑mʋ', ‑ʋ kɔ ke' 'kuo ‑hʋɩn* nɩ 'ʋ, 'bʋ mɔ, 'bʋ 'ye꞊e, ʋ 'gblɛ kwlɩ, 'kɩ 'ʋ꞊ʋ ye', kɔ, 'ʋ 'yɛɛ 'lɩ win dɩakɩ, ʋ wɛn: «‑Mɔ mɔ Nyɩsʋa a 'Yu.» ");
INSERT INTO ktj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kɛɛ, ‑Yusu yɩ ꞊nʋ 'nɩ ‑lee ‑nɩ, 'kɩ 'lɩ win 'yaklɩ 'kwli, ‑ɛ mɔ, ʋ 'nɩ 'lee 'lɩ nyiblo ꞊dʋ, nyiblo a 'dɩ ‑bɩ ɛ pa 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, 'kɩ ‑Yusu 'ya 'lɩ dʋgba ‑bɩ 'lu. ‑Ɛ ‑bɩ nyibli ‑mʋ', ɛ ‑hʋɛ ‑bʋ mɔ 'a ‑mɔnanyʋ, ʋ nʋ‑ ɛ ‑da, 'ʋ mu 'ʋ꞊ʋ 'hʋɩ. ");
INSERT INTO ktj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ʋ mɔ nyibli nɩ ‑pu ꞊tu 'ʋ 'hʋɛn. Ʋ nʋ‑ ɛ ‑ha 'lɩ nyibli a 'mʋ 'nyɩ, 'ɛ nu ꞊nʋ 'a ‑mɔnanyʋ ‑mɔ', ‑ɛ di꞊e nu, ʋ 'mʋ 'ʋ꞊ʋ 'hʋɩ nɩ, ti a pɛpɛ, kɔ, ɛ 'mʋ ꞊nʋ ‑tɛblɩ 'nyɩ lɛ tɛ, ʋ 'mʋ 'a ꞊haantitie nyibli pʋ, ");
INSERT INTO ktj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","kɔ, ɛ 'mʋ ꞊nʋ 'klɩ ‑nyi, 'kɩ bʋ bla 'kuo ‑hʋɩn* ‑mʋ', ‑ʋ nɩ 'ʋ nyibli ke' lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","'A ‑mɔnanyʋ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn a 'mʋ, 'waa 'nyrɛ mɔ: Simɔ, ‑Yusu ꞊tue Piɛlɩnyrɛ, ");
INSERT INTO ktj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","kɔ Sebede a 'yonʋ, ‑ʋ mɔ Sakɩ kɔ 'a 'dɩayɩ Saan 'hʋɛn‑. ‑Yusu ꞊tue ꞊nʋ Bʋanɩsɛsɩnyrɛ, ‑ɛ ꞊hɛn 'nyrɛ 'yonʋ ‑mʋ', ‑ʋ 'wɩ ‑mamʋɛ yɩ; ");
INSERT INTO ktj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","kɔ Adre, kɔ Filipʋ, kɔ Batelemi, kɔ Matie kɔ Toma, kɔ Sakɩ, ‑ɛ mɔ Alʋfe a 'yu, kɔ Tade, kɔ Simɔ. Simɔ a 'mʋ, 'kɩ ɛ nɩ 'lɩ nyibli ‑mʋ', ‑ʋ 'yɛ nɩ ‑hʋa Romakʋɛ 'nyɩ; ");
INSERT INTO ktj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","kɔ Judɩa Yisikalio. Ɛ mɔ nyiblo ‑mʋ', ‑ɛ di ‑Yusu 'a yraanyibli ‑jɩ' pʋ. ");
INSERT INTO ktj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","‑Tɛ ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu mu 'lɩ 'kayu bʋ, ɛ kɔ 'a ‑nagbopʋ* 'hʋɛn‑, Kɛɛ, nyibli ‑hʋɔhʋɩ ꞊glaa 'lɩ꞊ɩ lɛ de. Ɛ nu꞊o, ʋ 'nɩ ‑kɔ꞊ɔ 'hru, 'kɩ bʋ di dɛ. ");
INSERT INTO ktj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","‑Tɛ a 'dʋkʋɛ 'wɩn ‑tɩ a 'mʋ, ‑ɛ mi 'lu ‑mɔ, ‑ɛ ‑bɩ 'waa 'mumu, ʋ daa ꞊nɛ, 'a 'lu ‑hɔn 'ʋ 'hru wlɔn. Ɛ nɔ‑ nu꞊o, 'ʋ bi 'hru wlɔn, 'kɩ 'ʋ 'a gbʋgba a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nyɩsʋa a tetetɔɔnyʋ ꞊dʋ, ʋ nʋ‑ ‑hɔn la 'lɩ Jrusrɛdɩɔ 'kwli, 'ʋ hlee la ‑Yusu a dɛ kɩ, ʋ wɛn: «‑Yusu ‑bʋ, Bɛsebulɩ, ‑ɛ mɔ 'kuo ‑hʋɩn a nyiblo gbagbʋ Satan, ɛ nɔ‑ nɩ 'ʋ꞊ʋ ke', ɛ nɔ‑ yɩ꞊ɩ 'klɩ ‑nyi, 'kɩ bʋ bla 'kuo ‑hʋɩn, ‑ʋ nɩ 'ʋ nyibli ke' lɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ‑Yusu da ꞊nʋ nɩ, 'ɛ ni 'ledʋɩ, 'ɛ ‑hɩhɩɛ ꞊nʋ klɛ, ɛ wɛn: «꞊Bɩ Satan ‑wɛ 'lɩ bʋ bla 'a dɩɔnʋ lɛ nɩ? ");
INSERT INTO ktj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","꞊Bʋ pʋʋ ꞊nɛ dɛ yɩ: 'Kɩ 'lɩ 'blʋgba 'kwli, nyibli 'bʋ 'bɛ ꞊tɩɔ lɛ, 'blʋgba a 'mʋ, ɛ di bi ꞊hlɔn. ");
INSERT INTO ktj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","'Ya 'ʋ 'lu de, 'kayu a 'dʋkʋɛ 'bʋ 'bɛ ꞊tɩɔ, 'kayu a 'mʋ, ɛ di lɛ 'nɩ ‑gbɛ. ");
INSERT INTO ktj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","‑Ɛ ‑bɩ Satan 'bʋ yɩ 'a dɩɔnʋ yɩ nɩ ‑wɛn, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ nu ꞊dedede, 'a 'klɩ di bʋ 'nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ɛ 'wɩ yɩ, nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ pa 'lɩ 'klɩnɩnyɔ a 'kayu bʋ, bʋ mu ‑tɛblɩ 'yri, 'bʋ mɔ, 'bʋ 'yɩ 'klɩnɩnyɔ a 'mʋ ‑mʋa ‑nɩ. Kɛɛ, 'bʋ mʋa ꞊nɛ, ‑ɛ ‑bɩ 'hru pɛ 'ʋ bʋ, 'kɩ bʋ 'yri 'a 'kayu a ‑tɛblɩ a pɛpɛ. ");
INSERT INTO ktj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, 'nɩ yɩ 'a mɔ꞊ɔ ‑lee ‑nɩ, ‑ɛ mɔ, Nyɩsʋa ‑wɛ 'lɩ bʋ 'wʋwla nyibli a dɛ 'kuku a pɛpɛ nɩ, 'ye ꞊bɩɩ ʋ ‑ha Nyɩsʋa 'yri lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kɛɛ, nyiblo ‑bʋ, ‑ɛ di Nyɩsʋa a ‑Hihiu* 'yri lɛ ‑ha, Nyɩsʋa 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ 'wʋwla 'a dɛ 'kuku a 'mʋ, 'klɔ ‑mɔ 'klɔ, ‑ɛ nu꞊o, ɛ nu dɛ 'kuku, ‑ɛ hie 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Kɛ‑ ‑Yusu nu la 'waa klɛ‑hɩhɩalɛ, ‑ɛ nu꞊o, ʋ wɛn 'nɩ, 'ku ‑hʋan nɩ la 'ʋ꞊ʋ ke'. ");
INSERT INTO ktj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","'Kɩ ʋ nɩ 'lɩ 'kayu nɩ ‑do a 'mʋ bʋ, ‑ɛ ‑bɩ ‑Yusu a 'dii kɔ 'a 'dɩayɩ nyɩbɛpʋ 'hʋɛn‑, ʋ nyre 'ʋ nɩ. 'Kɩ ʋ hree 'lɩ ‑patʋ', 'ʋ tɛ 'lɩ nyiblo, 'ɛ mu ‑Yusu da mɔ. ");
INSERT INTO ktj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nyibli ‑hʋɔhʋɩ nɩ bʋ, 'ʋ ꞊glaa 'lɩ ‑Yusu lɛ. ‑Ɛ ‑bɩ, kɛ‑ ʋ pɩ꞊ɩ yɩ: «'Ye kɛ, ‑na 'dii kɔ ‑na 'dɩayɩnʋ, 'kɩ ʋ nɩ 'ʋ ‑patʋ', ‑mɔ ʋ dɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","‑Ɛ ‑bɩ ɛ wɛn: «‑Ʋ ‑bɩ nɩ 'ʋ, 'ʋ mɔ 'na 'dii kɔ 'na 'dɩayɩnʋ 'hʋɛn‑ ‑wɛ,» ");
INSERT INTO ktj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","'ɛ 'du 'yii ye', 'ɛ 'ye nyibli ‑mʋ', ‑ʋ nɩ blɛ, ‑ʋ ꞊glaa 'lɩ꞊ɩ lɛ, ɛ wɛn: «Ba 'ye kɛ, nyibli ‑bʋ, ʋ nʋ‑ mɔ 'na 'dii, 'ʋ mɔ 'na 'dɩayɩnʋ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nyibli ‑mʋ', ‑ʋ ni Nyɩsʋa a kɩwɛɛnlɛ, ʋ nʋ‑ mɔ 'na 'dɩayɩnʋ, kɔ 'na 'dii ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","‑Nyrɔwɔ ꞊dʋ, ‑Yusu 'ɛ mu 'lɩ Galileblʋgba a 'yru wien de, 'ɛ tʋɛ 'lɩ Nyɩsʋa a ‑tɩ, nyibli ‑hʋɔhʋɩ 'ʋ ꞊glaa 'lɩ꞊ɩ lɛ. Bʋ 'yɛ nɩ 'ye 'hru, ɛ nɔ‑ mɔ bʋ ya 'lɩ 'blagbɩ 'kwli, 'ɛ nɩ bʋ, 'ɛ 'yɩya 'lɩ 'nie kɩ bʋ, nyibli a 'mʋ, 'ʋ 'wlɛ 'ʋ 'gbahlɔn bʋ, ");
INSERT INTO ktj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","'ɛ tʋɛ ꞊nʋ ‑tɛblɩ ‑hʋɔhʋɩ, 'kɩ 'lɩ 'ledʋ 'kwli. Kɛ‑ ɛ pɩ nyibli a 'mʋ yɩ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Ba pʋ 'mʋ nʋa yɩ bʋ. Ɛ kɔ la ‑nyrɔwɔ ꞊dʋ, nyɩbɛhɩan ꞊dʋ 'ɛ mu la 'a ‑tɛblɩ 'dɔ mɔ. ‑Tɛblɩ a 'mʋ, ɛ ‑gblɛ 'lɩ꞊ɩ ‑ci 'kwli lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","‑Tɛ ɛ yɩ꞊ɩ nɩ ‑gblɛ, ‑ɛ ‑bɩ 'a dɛ ‑bɩ bi 'lɩ 'hru wlɔn lɛ, nʋblɩ 'ʋ ‑di, 'ʋ di꞊e. ");
INSERT INTO ktj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","'A 'hʋɛn a dɛ, ɛ ‑gbla, ‑tʋtʋkʋtɩɔ ‑mʋ', ɛ bi 'ʋ kɩ, 'hɩɔ 'pa nɩ 'lɩ꞊ɩ bʋ, 'ɛ 'sii yɩ, 'ɛ ꞊ga ti nɩ ‑do a ti 'yri, ‑ɛ nu꞊o, ‑tʋtʋkʋtɩɔ a 'mʋ, ‑ɛ nɩ 'ʋ 'hɩɔ a 'mʋ kɩ, ɛ 'yɩ ‑hʋ. ");
INSERT INTO ktj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","‑Tɛ ɛ ꞊ga, ‑tɛ 'yrʋ bi 'lɩ yɔ', ɛ nɔ‑ mɔ 'a ꞊kwlɩ bʋ 'yrɔ, ‑ɛ nu꞊o, 'a ‑wlubʋɩ kʋɛ 'hɩɔ a 'mʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","'A ta a dɛ, ɛ ‑gbla, 'kɩ ɛ bi 'lɩ 'witi 'nyɩ. ‑Tɛ ɛ ꞊ga, ‑ɛ ‑bɩ 'witilili 'buu ꞊nɛ 'lu lɛ. 'A ‑tɩ, 'dʋdɔdɛ a 'mʋ, ɛ 'yɩ blɩ ‑pʋ. ");
INSERT INTO ktj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","'A ‑hɛn a dɛ, ɛ ‑gbla, ɛ nɔ‑ bi 'ʋ ꞊haan‑tʋtʋ kɩ. ‑Tɛ ɛ ꞊ga, 'ɛ 'sii yɩ, 'ɛ ku ‑tɛɛ, 'ɛ pʋ blɩ. 'A blʋ nɩ ‑do, ɛ pʋ 'yɔ a (30) ‑wlʋ ꞊tu 'ʋ ‑pu, 'a dɛ ‑bɩ pʋ 'yɔ a (60) ‑wlɩ nɩ ta, 'a dɛ ‑bɩ pʋ 'yɔ a (100) ‑wlɩ nɩ ꞊hun.» ");
INSERT INTO ktj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","‑Ɛ ‑bɩ, kɛ‑ ‑Yusu pɩ la 'kɩ ꞊nʋ yɩ, ɛ wɛn: «'Bʋ mɔ, 'ba kɔ ‑tɩ'wɩnnʋa, ‑ɛ ‑bɩ ba 'wɩn ‑tɩ ‑dodo.» ");
INSERT INTO ktj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ti gbi bʋ ‑hi, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* nɩ ‑pu ꞊tu 'ʋ 'hʋɛn kɔ hɩapʋ‑nagbopʋ ‑bɩ 'hʋɛn‑, ʋ nʋ‑ hie 'ʋ. ‑Ɛ ‑bɩ ʋ 'bɛti 'kɩ꞊ɩ 'ledʋ a 'mʋ a 'mini nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","‑Ɛ ‑bɩ, ɛ ꞊tu nyibli a 'mʋ ꞊wɔn, ɛ wɛn: «'A mʋ ‑bʋ, ‑ʋ mɔ 'na ‑nagbopʋ, Nyɩsʋa ni꞊e nɩ, 'a yrui 'a ‑tɩ' lɛ, ɛ ꞊hɛn 'nyrɛ, ‑tɛ ɛ ni, 'ɛ kʋɛ nyibli win kɩ. Nyɩsʋa a ‑tɩ a 'mʋ, ɛ ‑hli nyibli 'yi kɩ. Nyibli ‑mʋ', ‑ʋ 'yɛ nɩ kʋɛ 'mʋ ꞊wien lɛ, ʋ nʋ‑ ‑mɔ ‑bɩ, 'ledʋɩ nɩ ‑do, nʋ‑ ‑wɛ 'lɩ ‑bʋ ‑hɛɛ ꞊nʋ, bʋ yru꞊o lɛ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ɛ nɩ ‑do a 'mʋ, ʋ 'crɩ la꞊a nɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ti ‑hi la a ti 'yri, ‑ɛ mɔ: Ʋ yɩ꞊ɩ 'nɩ 'ye ‑tɛɛ, kɛɛ, ʋ 'nɩ ‑yru꞊o lɩ꞊ɩ lɛ. Ʋ yɩ꞊ɩ 'nɩ 'wɩn ‑tɛɛ, kɛɛ, ʋ 'nɩ ‑yru꞊o lɩ꞊ɩ lɛ ‑wɛ. 'Bʋ mɔ, 'bʋ yɩ wɛn꞊ɛ lɛ nɩ yrui, ʋ di ꞊hɩan wɛn ‑mɔ, ʋ 'mʋ wɛn 'waa 'klɔ Nyɩsʋa ‑nyi, ‑ɛ ‑bɩ Nyɩsʋa di wɛn 'waa dɛ 'kuku 'nɩ 'wʋwla ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ de, ɛ wɛn: «'Ba 'yɛ nɩ yru 'ledʋ ‑bʋ lɛ, ‑ɛ ‑bɩ a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ ba yru ‑ʋ ‑bɩ ‑mʋ' lɛ 'klɔ ‑mɔ 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kɛ‑ ɛ pɩ 'kɩ: «Ɛ 'wɩ yɩ, 'dʋdɔnyɔ ‑mʋ', ɛ nɔ ‑mɔ nyiblo ‑mʋ', ‑ɛ nɛ Nyɩsʋa a win ‑mɔ lɛ. 'Dʋdɔ‑tɛblɩ ‑mʋ', ʋ nʋ‑ mɔ Nyɩsʋa a win. ");
INSERT INTO ktj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","'Hru ‑mʋ', ‑ɛ kɔ wlɔn ɛ yɩ 'ʋ lɛ bi, 'tɩ‑ nʋblɩ 'ʋ ‑di, 'ʋ di꞊e, ɛ nɔ‑ ‑mɔ nyibli ‑bʋ, ‑ʋ pɩ Nyɩsʋa a win nʋa yɩ bʋ, 'tɩ‑ Satan, ‑ɛ mɔ 'kuo ‑hʋɩn* a nyiblo gbagbʋ, 'ɛ yɩ di, 'ɛ ‑hɛ 'lɩ Nyɩsʋa a win a 'mʋ 'waa ꞊wlɩ klɛ. ");
INSERT INTO ktj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","‑Ɛ ‑bɩ ‑tʋtʋkʋtɩɔ ‑mʋ', ‑ɛ nɩ 'ʋ 'hɩɔ 'pa kɩ, ‑ɛ kɔ kɩ 'dʋdɔ‑tɛblɩ ‑bɩ bi 'ʋ lɛ ‑wɛ, ɛ nɔ‑ mɔ nyibli ‑bʋ, ‑ʋ yɩ Nyɩsʋa a win 'wɩn, 'tɩ‑ ‑ʋ yɩ꞊ɩ kɩ wɛn, 'kɩ 'lɩ plɔ a bleelɛ 'kwli, ");
INSERT INTO ktj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","'tɩ‑ ‑ʋ yɩ꞊ɩ kʋa 'ble, 'kɩ 'lɩ ti 'cɩmɩ gbi 'kwli. Kɛɛ, ʋ 'yɩ꞊ɩ ‑hʋa, 'kɩ bʋ pʋ 'ma, 'kɩ 'lɩ 'waa ꞊wlɩ kɩ. Nyibli a 'mʋ, 'waa 'bio ‑mʋ', ‑ʋ 'yɛ nɩ ‑hʋa Nyɩsʋa a win, 'bʋ yɩ ꞊nʋ ꞊hɩʋɛn nɩ ꞊tui, ɛ kɔ, 'bʋ yraa ꞊nʋ, ‑ɛ ‑bɩ 'waa nyɩsʋadɛ a 'mʋ, ɛ sɛ ꞊nʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","‑Tʋtʋkʋtɩɔ ‑mʋ', 'witi nɩ 'ʋ kɩ, ‑ɛ kɔ kɩ 'dʋdɔ‑tɛblɩ ‑bɩ bi 'lɩ lɛ ‑wɛ, ");
INSERT INTO ktj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ʋ nʋ‑ mɔ nyibli ‑bʋ, ‑ʋ yɩ Nyɩsʋa a win 'wɩn, 'tɩ‑ nyibli a 'mʋ 'ʋ yɩ 'klɔ kɩ a 'kla‑wliye'yɩya a hritilɛ ‑hriti ‑nɩ, kɔ, 'ʋ nɛɛ kʋkɔ‑tɛblɩ a ‑tɩ ꞊wlɩ klɛ, ‑tɛblɩdʋ ‑bʋ, ‑ɛ pɩ 'lɩ ꞊nʋ kɩka 'nyɩ; 'klɔ a ‑tɛblɩ ‑bʋ, ʋ nʋɛ ‑nɩ, ɛ nɔ‑ 'waa ꞊wlɩ yɩ ꞊wien lɛ kʋɛ. ‑Tɛblɩ a pɛpɛ a 'mʋ, ɛ ni꞊e nɩ, Nyɩsʋa a win 'ɛ 'yɛ nɩ nu ‑kʋan, 'kɩ 'lɩ 'waa ꞊wlɩ kɩ, 'ɛ yɩ lɛ ‑hihre ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","‑Ɛ ‑bɩ, ꞊haan‑tʋtʋkʋtɩɔ ‑mʋ', ‑ɛ kɔ kɩ 'dʋdɔ‑tɛblɩ ‑bɩ bi 'lɩ, ɛ nɔ‑ mɔ nyibli ‑mʋ', ‑ʋ yɩ Nyɩsʋa a win 'wɩn, ‑ʋ yɩ꞊ɩ kʋa 'ble, 'tɩ‑ 'ɛ ni ‑kʋan, 'kɩ 'lɩ 'waa ꞊wlɩ kɩ, 'wɩ a (30) ‑wlʋ ꞊tu 'ʋ ‑pu, kɔ (60) ‑wlɩ nɩ ta, kɔ (100) ‑wlɩ nɩ ꞊hun, 'ɛ ‑hi 'ʋ ‑tɛ ʋ nu 'a 'wɩnwɩɩn.» ");
INSERT INTO ktj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kɛ‑ ‑Yusu pɩ la ꞊nʋ yɩ de, ɛ wɛn: «Nyiblo 'bʋ 'bɩa 'napɩ, ɛ 'nɩ ꞊jri꞊e lɩ꞊ɩ kɩka 'lu bʋ, kɔ, nyiblo 'bʋ 'bɩa 'napɩ, ɛ 'nɩ ꞊tu꞊o lɩ꞊ɩ ‑bɛlɛ bʋ. Kɛɛ, 'kɩ ɛ ꞊tui 'ʋ꞊ʋ dɛ 'lu bʋ, ‑ɛ di꞊e nu, ɛ 'mʋ 'lɩ 'kayu blɛ yru. ");
INSERT INTO ktj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","‑Tɛblɩ a pɛpɛ ‑mʋ', ‑ɛ ‑hli, ɛ di kɔ ‑nyrɔwɔ, ɛ 'mʋ pepe' bi, ɛ kɔ, ‑tɛblɩ a pɛpɛ ‑mʋ', nyiblo ꞊dʋ 'yɩ la ‑yi, ‑nyrɔwɔ di 'ʋ 'nɩ nyre ‑wɛ, ʋ 'mʋ꞊ʋ lɛ yru. ");
INSERT INTO ktj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ba pʋ 'mʋ nʋa yɩ bʋ ‑tɛɛ: Nyiblo 'bʋ nɩ 'ʋ, 'bʋ kɔ ‑tɩ'wɩnnʋa, bʋ 'wɩn ‑tɩ ‑dodo.» ");
INSERT INTO ktj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ de: «Nyɩsʋa a win ‑bʋ, 'n yɩ 'a mʋ ‑lee ‑nɩ, ba ꞊tu꞊o 'yie. ‑Tɛ ‑mʋ', a di 'a 'wɩnwɩɩn nu, kɛ‑ Nyɩsʋa di 'a mɔ꞊ɔ 'a lɛyruelɛ nu. ");
INSERT INTO ktj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nyiblo ‑mʋ', ‑ɛ pɩ Nyɩsʋa a win nʋa yɩ bʋ, Nyɩsʋa di꞊e 'nɩ nu, ɛ 'mʋ꞊ʋ' lɛ yru, ɛ 'mʋ ‑tɛ ‑mʋ', ɛ nu la 'a 'wɩnwɩɩn 'ʋ ‑hi. Kɛɛ, nyiblo ‑mʋ', ‑ɛ 'yɛ nɩ pʋ꞊ʋ nʋa yɩ bʋ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ yru꞊o' lɛ pɛpɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kɛ‑ ɛ pɩ la ꞊nʋ yɩ de, ɛ wɛn: «‑Tɛ Nyɩsʋa ni nyibli a win a kɩkɔɔlɛ, ɛ 'wɩ‑ nyiblo, ‑ɛ ‑gbla 'dʋdɔ‑tɛblɩ, 'kɩ 'lɩ 'a ‑ci kɩ. ");
INSERT INTO ktj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","‑Tɛ ɛ ‑wɛ 'a ‑gbʋgbla ‑mɔ, ‑ɛ ‑bɩ ɛ mu 'dɩɔ. ‑Nyrɔwɩ a pɛpɛ ‑mʋ', ɛ ‑hii 'lɩ 'dɩɔ, ‑ɛ ‑bɩ 'dʋdɔ‑tɛblɩ a 'mʋ, ɛ ‑gbla mɔ, 'kɩ 'lɩ ‑ci kɩ, ɛ nɩ ‑do, ɛ yɩ 'nɩ mɩ, ɛ mɔ, ɛ 'nɩ ‑hii꞊e 'lɩ ‑ci a 'mʋ kɩ. ");
INSERT INTO ktj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","‑Tʋtʋ nɩ ‑do, ɛ nɔ‑ ni꞊e, 'ɛ yɩ mɩ. 'A ꞊gba, ‑ɛ mɩ yɩ‑hɛdɛ, ‑tɛ ɛ ‑ku, ɛ pʋ blɩ, 'a 'yɔ 'ɛ ‑ku. ");
INSERT INTO ktj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","‑Tɛ 'dʋdɔ‑tɛblɩ a 'mʋ, ɛ ꞊hlu, ‑ɛ ‑bɩ ɛ mu nɩ, 'ɛ gba 'a ‑paka, 'ɛ 'cɛ꞊ɛ, ‑ɛ nu꞊o, 'a 'cɩcɛti nyre 'ʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ, ɛ wɛn: «'N di pʋ 'ledʋ ‑bɩ, ‑tɛ ‑mʋ' Nyɩsʋa ni, 'ɛ kɔɔ nyibli a dodoyo win kɩ, 'tɩ‑ nyibli ‑bɩ 'ʋ yɩ klɛ ‑bii ‑nɩ, 'mʋ 'a mɔ꞊ɔ ‑tɔɔ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Dɛ a 'mʋ, ɛ 'wɩ‑ 'dʋdɔdɛ ‑mʋ', ‑ɛ kɔ 'yɛɛ ꞊cɩmɩ ‑nɩ dɩakɩ, 'ɛ ‑hi 'ʋ 'dʋdɔ‑tɛblɩ a pɛpɛ a 'yɔ 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kɛɛ, 'bʋ 'dɔ꞊ɔ, ɛ yɩ 'nɩ mɩ. 'Bʋ ‑ku, ɛ 'bʋɛ nɩ, 'ɛ yɩ 'ʋ 'dʋdɔ‑tɛblɩ a pɛpɛ 'ʋ ‑hi, kɔ, 'ɛ pɩ babʋɩ gbagbɩ. 'A babʋɩ a 'mʋ, ɛ ‑wɛ 'lɩ nʋblɩ bʋ pʋʋ 'lɩ 'lʋɛ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","‑Tɛ 'ledʋ ‑bʋ, ɛ nɩ 'mʋ, kɛ‑ ‑ʋ ‑bɩ nɩ la 'mʋ, ‑Yusu 'ɛ pɩ la ꞊nʋ, 'ɛ tʋɛ la nyibli Nyɩsʋa a win. ‑Ɛ ‑bɩ dɛ ‑mʋ', nyibli ‑wɛ 'lɩ bʋ yru' lɛ, ɛ nɔ‑ ɛ tʋɛ la ꞊nʋ. ");
INSERT INTO ktj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ti a pɛpɛ, 'bʋ yɩ la ꞊nʋ dɛ nɩ tʋɛ ‑nɩ, 'kɩ 'lɩ 'ledʋɩ 'kwli, ɛ tʋɛ la 'lɩ ꞊nʋ. Kɛɛ, ɛ kɔ 'a ‑nagbopʋ* nɩ ‑do 'hʋɛn‑, 'bʋ 'bɛ ‑mɔ lɛ, 'tɩ‑ 'ledʋɩ a pɛpɛ ‑mʋ', ɛ pɩ, 'ɛ ‑hɩhɩɛ la ꞊nʋ꞊ʋ klɛ. ");
INSERT INTO ktj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","‑Nyrɔwɔ nɩ ‑do a 'mʋ a ‑winse, ‑ɛ ‑bɩ ‑Yusu lee nɛ 'a ‑nagbopʋ* nɩ, ɛ wɛn: «‑Ba ꞊ta 'lɩ 'yru a 'kɩbɩa ‑bɩ ‑mʋ' kɩ,» ");
INSERT INTO ktj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","'a ‑nagbopʋ 'ʋ gba꞊a, 'ʋ 'ya 'lɩ 'blagbɩ ‑mʋ', ‑ɛ kɔ 'kwli ɛ tʋɛ wɛn 'lɩ nyibli Nyɩsʋa a ‑tɩ 'kwli, 'ʋ gba nyibli a 'mʋ wlu, 'ʋ ‑mu. 'Kɩ 'ʋ 'waa 'blagbɩ 'hʋɩ, 'blagbɩ ‑bɩ nɩ 'ʋ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bʋ nɩ 'kɩ 'ʋ 'nie kɩ, bʋ yɩ nɩ mi, ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ duduo cɛ 'lɩ nɩ, 'yru 'ɛ ‑tʋa 'dʋɩ a pʋpʋʋ, 'yru a 'dʋɩ a 'mʋ, 'ʋ ni꞊e, 'nie 'ɛ yɩ 'lɩ 'blagbɩ 'kwli lɛ 'wlɛ. ‑Ɛ ‑bɩ 'blagbɩ ‑tʋa 'lɩ'yiilɛ, 'kɩ 'ʋ 'yru a 'dʋɩ ‑mɔ, ‑ʋ yɩ 'lɩ꞊ɩ 'kwli lɛ 'wlɛ. ");
INSERT INTO ktj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ti a 'mʋ 'yri, 'kɩ ‑Yusu pɛ 'lɩ 'blagbɩ a ‑moko 'yri bʋ, 'ɛ pʋ 'ʋ 'a 'lu 'pela kɩ bʋ, 'ɛ yɩ ŋme. ‑Ɛ ‑bɩ 'a ‑nagbopʋ ‑ha꞊a ŋmena', ʋ wɛn: «Tɔɔnyɔ, ꞊bɩ ɛ 'nɩ 'yaa꞊a lɩ ‑mʋ 'kla ‑wliye, ‑tɛ ‑a mi bʋ ‑wɛ mɔ?», ");
INSERT INTO ktj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","‑Yusu 'ɛ 'du ye', 'ɛ 'plɛɛ 'lɩ pepe kɔ 'yru a 'mʋ 'hʋɛn‑ ‑mɔ, 'kɩ 'lɩ win 'yaklɩ 'kwli, ɛ wɛn: «Ba ma wien, ba wɛɛn kɩ bʋ!» ‑Tɛ ɛ pʋ win, ‑ɛ ‑bɩ duduo a 'mʋ, ɛ nyra bʋ, 'yru a pɛpɛ 'ɛ wɛɛn kɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","‑Ɛ ‑bɩ ‑Yusu ꞊hɩan ‑mɔ, 'ɛ 'plɛɛ 'lɩ 'a ‑nagbopʋ ‑mɔ, ɛ wɛn: «Dɛ‑ kɔ ‑tɩ 'a yɩ hʋannʋ pie 'lɩ? A 'tɩɛ 'yɛɛ Nyɩsʋa ꞊wlʋ yɩ nɩ ‑kue ‑nɩ?» ");
INSERT INTO ktj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","'A ‑nagbopʋ ‑mɔ ‑bɩ, ʋ 'ta 'ʋ blɛ dɩakɩ, 'ʋ yɩ 'lɩ lɛ 'pʋplɛ ‑nɩ, ʋ wɛn: «Ba 'ye kɛ nyiblo ‑bʋ, pepe kɔ 'yru 'hʋɛn‑, ʋ ꞊tui 'ʋ꞊ʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ʋ nyre 'lɩ Galileblʋgba a 'yru a 'kɩbɩa ‑mʋ', ‑ɛ mɔ Gelasakʋɛ a 'blʋgba kɩ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","‑Yusu bʋ ꞊tɩ 'lɩ 'blagbɩ 'kwli, ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ nyɩbɛhɩan ꞊dʋ, ɛ nɔ‑ ‑hɔn 'lɩ 'kudɩɔ bʋ, 'ɛ mu꞊o ye' 'bɛ mɔ. Nyiblo a 'mʋ, 'ku ‑hʋan nɩ 'ʋ꞊ʋ ke', 'ɛ ꞊tui꞊e ꞊hɩʋɛn. ");
INSERT INTO ktj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","'Kɩ ɛ 'ti 'lɩ 'kudɩɔ bʋ, ‑ʋ nɩ 'lɩ dʋgbɩ 'kwli. Nyiblo ꞊dʋ 'yɩ 'lɩ 'a mʋalɛ 'lɩ ‑wɛ, 'ye ꞊bɩɩ ʋ nu 'cɩɩn. ");
INSERT INTO ktj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ɛ kɔ ti, 'ʋ pɩ la 'lɩ꞊ɩ ‑hannya dabʋɩ lɛ, kɔ 'ʋ ni la 'cɩɩn ‑wɛ, 'ʋ yɩ la 'a bʋɩ ‑mʋa ‑nɩ. Kɛɛ, 'a pɛpɛ a 'mʋ, ɛ yɩ cɩcɛ la꞊a lɛ. Nyiblo ꞊dʋ 'yɩ 'kɩ 'a kʋklɔ a 'klɩ ‑kɔ de. ");
INSERT INTO ktj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ti a pɛpɛ, 'tɔ kɔ ‑nyrɛ, dʋgbɩ, nɔ‑ ɛ nɛ 'lu lɛ, kɔ 'dabi ‑mʋ', ‑ɛ nɩ 'lɩ dʋgbɩ 'kwli, nɔ‑ ɛ nɛ 'nyɩ lɛ, 'ɛ pɩ ‑cici lɛ, kɔ, 'ɛ hlɛ 'a dɩɔnʋ 'hɩ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","‑Tɛ ɛ 'ye ‑Yusu, ‑ɛ yɩ 'lɩ di, ‑ɛ ‑bɩ ɛ gba꞊a cigbɛ yɩ, 'ɛ mu 'ʋ꞊ʋ ye', 'ɛ 'gbla kwlɩ, 'kɩ 'ʋ꞊ʋ ye', ‑ɛ di꞊e nu, ‑Yusu 'mʋ꞊ʋ ‑hɛɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'ku ‑hʋan a 'mʋ yɩ, ‑ɛ nɩ 'ʋ nyiblo a 'mʋ ke', ɛ wɛn: «'Ku ‑hʋan, ‑hɔn 'ʋ nyiblo ‑bʋ ke'!» ‑Ɛ ‑bɩ nyiblo a 'mʋ, ɛ 'yɛɛ 'lɩ win, 'ɛ pɩ lɛ: «‑Yusu, ‑Tɩ'yi'bʋanyɩsʋa a 'Yu, dɛ a 'dɩ ‑bɩ ‑hʋɛ ‑bʋ nu 'mʋ ‑mɔ 'lɩ? 'N nyaa ‑mʋ lɛ, 'kɩ 'lɩ Nyɩsʋa a 'nyrɛ 'kwli, ꞊nɩ 'tuo 'mʋ ꞊hɩʋɛn.» ");
INSERT INTO ktj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","‑Ɛ ‑bɩ ‑Yusu 'bɛti꞊e nɩ, ɛ wɛn: «‑Na 'nyrɛ 'lɩ?» ‑Ɛ ‑bɩ ɛ ꞊tu꞊o ꞊wɔn, ɛ wɛn: «'Na 'nyrɛ mɔ Dakɔ, ‑ɛ nu꞊o, ‑a ‑hʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","‑Ɛ ‑bɩ ɛ ‑tʋa ‑Yusu a lɛnyaalɛ dɩakɩ, ɛ wɛn: «꞊Nɩ 'blaa 'lɩ 'kuo ‑hʋɩn lɛ, 'kɩ 'nɛ‑ 'blʋgba ‑bʋ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","'Kɩ 'ʋ ‑tɛ nɩ ‑do a 'mʋ, 'kɩ dʋgba ꞊dʋ nɩ 'ʋ, 'a 'kʋtɩɔ ‑bɩ 'ɛ bi 'yru. 'Kɩ bʋɩca꞊ju gbagbʋ nɩ 'ʋ, 'ʋ wɛ ‑tʋtʋ, 'ʋ yɩ dɛ di. ");
INSERT INTO ktj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","‑Ɛ ‑bɩ 'kuo ‑hʋɩn a 'mʋ, ʋ nyɛɛ ‑Yusu lɛ, ʋ wɛn: «Wɛn꞊ɛ kɩ, 'kɩ ‑ba bi 'ʋ bʋɩcɩ ‑mʋ' ke',» ");
INSERT INTO ktj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","‑Yusu 'ɛ ‑wɛn, 'kuo ‑hʋɩn a 'mʋ, 'ʋ ‑hɔn 'ʋ nyiblo a 'mʋ ke', 'ʋ bi 'ʋ bʋɩcɩ a 'mʋ ke', bʋɩca꞊ju a 'mʋ, 'ʋ 'gba ci lɛ, 'ʋ ꞊tɩ dʋgba, 'ʋ bi 'lɩ 'yru ‑mɔ lɛ, 'ʋ 'kʋkʋ lɛ. Bʋɩcɩ a 'mʋ, ‑ʋ 'kʋkʋ lɛ, ʋ ‑wɛ 'lɩ bʋɩcɩ a 'miliwɩ nɩ 'hʋɛn nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","‑Tɛ nyibli ‑mʋ', ‑ʋ nɛɛ bʋɩcɩ a 'mʋ, ʋ 'ye ‑tɛblɩ a 'mʋ, ‑ɛ mu 'lu ‑mɔ, ‑ɛ ‑bɩ ʋ 'gba ci lɛ, 'ʋ ‑mu, ‑tɛblɩ a pɛpɛ a 'mʋ, ‑ɛ mu 'lu ‑mɔ, 'ʋ na꞊a ‑mɔ lɛ, 'kɩ 'lɩ 'dɩɩ kɔ ‑yrigbi 'hʋɛn‑ klɛ. ‑Tɛ nyibli 'wɩn, ‑ɛ ‑bɩ ʋ di nɩ, ʋ 'mʋ ‑tɛblɩ a 'mʋ, ‑ɛ mu 'lu ‑mɔ 'ye. ");
INSERT INTO ktj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","‑Tɛ ʋ nyre 'ʋ ‑Yusu 'hʋɩ, 'kɩ ʋ yɛɛ 'ʋ nyiblo a 'mʋ bʋ, 'kuo ‑hʋɩn ‑hʋɔhʋɩ nɩ wɛn 'ʋ ke', 'ɛ pʋ wlawlʋ, 'ɛ nɩ bʋ. Ɛ 'wɩ‑ nyiblo ‑bʋ yɩ, nɩblɩ 'yɩ ‑hʋan nɩ ni. Nyibli a 'mʋ bʋ 'ye꞊e, ‑ɛ ‑bɩ hʋannʋ bi 'lɩ ꞊nʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nyibli a 'mʋ, ‑ʋ 'ye ‑tɛblɩ a pɛpɛ a 'mʋ, ‑ɛ mu 'lu ‑mɔ, 'kɩ 'ʋ nyiblo a 'mʋ kɔ bʋɩcɩ 'hʋɛn‑ kɩ, ʋ na꞊a ‑mɔ lɛ, 'kɩ 'ʋ nyibli ‑mʋ', ‑ʋ di ‑ta 'ye mɔ ye'. ");
INSERT INTO ktj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","‑Ɛ ‑bɩ ʋ ‑tʋa ‑Yusu a lɛnyaalɛ, ʋ wɛn: «‑Hɔn 'nɛ‑ ‑a nɛ 'blʋgba ‑bʋ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu 'ya 'lɩ 'blagbɩ 'kwli. ‑Tɛ ɛ 'ya, ‑ɛ ‑bɩ nyiblo a ‑mʋ', 'kuo ‑hʋɩn nɩ wɛn 'ʋ ke', ɛ nyɛɛ ‑Yusu lɛ, 'kɩ bʋ na꞊a ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kɛɛ, ‑Yusu 'yɩ꞊ɩ kɩ ‑wɛn, ɛ wɛn: «Mu 'lɩ ‑na 'dɩɔ 'kwli, 'kɩ 'lɩ ‑na kʋkɔnyibli ‑mɔ, ‑tɛblɩ gbagbɩ a pɛpɛ ‑mʋ', Kʋkɔnyɔ Nyɩsʋa nu ‑mʋ ‑mɔ, kɔ, ‑tɛ ɛ nu ‑na nyaɩ a yuyruo, ‑bʋ na 'a ‑tɩ ‑mɔ lɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ nyiblo a 'mʋ, ɛ bi 'hru wlɔn, 'ɛ mu 'lɩ Dekapɔblʋgba 'kwli, ‑tɛblɩ gbagbɩ a pɛpɛ ‑mʋ', ‑Yusu nu꞊o ‑mɔ, 'ɛ nɛ꞊ɛ ‑mɔ lɛ, nyibli ‑mʋ', ‑ʋ yɩ 'wɩn, 'ɛ kɛɛ 'waa ꞊wlɩ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","'Kɩ ‑Yusu nɩ 'lɩ 'blagbɩ nɩ ‑do a 'mʋ 'kwli, 'ɛ mu 'lɩ Galileblʋgba a 'yru a 'kɩbɩa ‑bɩ ‑mʋ' kɩ. ‑Tɛ ɛ ꞊tɩ, ɛ nɩ 'ʋ 'yru a 'mʋ wien, ‑ɛ ‑bɩ nyibli ‑hʋɔhʋɩ ‑wɛ ti kɩ, 'ʋ ꞊glaa 'lɩ꞊ɩ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Bʋ nɩ 'ʋ bʋ, ‑ɛ ‑bɩ Nyɩsʋa a 'kayu a nyiblo gbagbʋ ‑bɩ nyre 'ʋ nɩ. 'A 'nyrɛ mɔ Sayilu. Bʋ 'ye ‑Yusu, ‑ɛ ‑bɩ ɛ 'gbla kwlɩ, 'kɩ 'ʋ꞊ʋ ye', ");
INSERT INTO ktj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","'ɛ nyɛɛ ꞊nɛ lɛ, ɛ wɛn: «'Na 'yu nyrɔyu gbe, 'a 'hʋɩ hren nɩ, ɛ ‑hʋɛ bʋ 'kʋ. 'N nyaa ‑mʋ lɛ, di 'lɩ, ‑bʋ pʋ꞊ʋ dabʋɩ 'lu bʋ, ‑ɛ di꞊e nu, 'a 'kʋɛ 'mʋ ‑wɛ, ɛ 'mʋ ‑hʋnhlʋn pʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","‑Ɛ ‑bɩ ‑Yusu wɛn nɩ, ɛ kɔ꞊ɔ 'hʋɛn‑ 'ʋ mi, nyibli ‑hʋɔhʋɩ 'ʋ yɩ꞊ɩ ꞊wien kʋɛ, 'ʋ 'nyɩnyrɛ 'lɩ꞊ɩ yrɛ. ");
INSERT INTO ktj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","‑Ɛ ‑bɩ 'kɩ 'lɩ nyibli a 'mʋ 'nyɩ, 'kɩ nʋgba ꞊dʋ nɩ 'lɩ. Ɛ nɔ‑ 'kʋɛ ni. 'A 'kʋɛ a 'mʋ, ɛ nɔ‑ mɔ ‑hlʋblɛblekʋɛ. ‑Tɛ 'kʋɛ a 'mʋ, ɛ ‑tʋa la 'lɩ 'a nunuo, 'a 'yrɩ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn a 'yrʋ ‑bʋ ‑a nɩ kɩ. ");
INSERT INTO ktj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","'A 'hʋɩ a 'mʋ, 'a ‑tɩ, ɛ na ‑dɔtɔpʋ a gblegble yrɛ, ɛ nɩ ꞊hɩʋɛn a 'mʋ, 'a 'yeelɛ ‑mɔ', 'a 'wli a pɛpɛ 'ɛ ‑wɛ꞊ɛ ꞊jrɛ. Kɛɛ, 'a 'kʋɛ a 'mʋ, ɛ 'yɩ ‑wɛ, ɛ yɩ bii klɛ nɩ ‑do. ");
INSERT INTO ktj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","‑Tɛ ɛ 'wɩn ‑Yusu a 'nyrɛ, ɛ nɔ‑ nu꞊o, 'ɛ mu 'lɩ nyibli ‑hʋɔhʋɩ a 'mʋ 'nyɩ, 'kɩ 'ʋ ‑Yusu ke', 'ɛ ‑hrɛn 'a wlawlʋ lɛ, ");
INSERT INTO ktj_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","‑ɛ nu꞊o, kɛ‑ ɛ pɩ 'a dɩɔnʋ yɩ: «'Nɩ ‑hrɛn 'a wlawlʋ lɛ dadʋ, 'na 'kʋɛ di 'nɩ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ti nɩ ‑do a ti 'yri, bʋ ‑hrɛn a wlawlʋ lɛ, ‑ɛ ‑bɩ ‑hlʋ nyra bʋ. Ɛ yru꞊o nɩ, 'kɩ 'lɩ 'a dɩɔnʋ 'hʋɩ ‑mɔ, ‑ɛ mɔ, 'a 'kʋɛ ‑wɛ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ ‑Yusu yru꞊o nɩ, ‑ɛ mɔ, 'klɩ ‑hɔn 'lɩ꞊ɩ 'hʋɩ, 'ɛ ꞊hɩan ‑mɔ, 'kɩ 'lɩ nyibli a 'mʋ 'nyɩ, ɛ wɛn: «Nyiblo a 'dɩ ‑bɩ ‑hrɛn 'na wlawlʋ lɛ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","‑Ɛ ‑bɩ 'a ‑nagbopʋ* ꞊tu꞊o ꞊wɔn, ʋ wɛn: «'Bɩ ‑na 'mumu, ‑yɩ꞊ɩ 'nɩ 'ye, ‑ɛ mɔ, nyibli ‑hʋ nɩ, 'ʋ 'nyɩnyrɛ 'lɩ ‑mʋ yrɛ. 'Tɩ‑ ꞊nɩ yɩ 'bɛti ‑nɩ, ‑ɛ mɔ, nyiblo a 'dɩ ‑bɩ ‑hrɛn ‑mʋ lɛ 'lɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kɛɛ, ‑ɛ ‑bɩ ‑Yusu ‑tʋa 'ʋ 'a dɩɔnʋ 'a 'hʋɩlɛtɩta, ‑ɛ di꞊e nu, ɛ 'mʋ nyiblo a 'mʋ, ‑ɛ ‑hrɛn꞊ɛ lɛ 'ye. ");
INSERT INTO ktj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nʋgba a 'mʋ, hʋannʋ a ‑tɩ, ɛ yɩ 'nɩ 'hɩhlɛ ‑nɩ, ‑ɛ nu꞊o, ɛ yi ‑tɛblɩ a pɛpɛ ‑mʋ', ‑ɛ mu 'lu ‑mɔ nɩ, 'kɩ 'ʋ꞊ʋ ‑mɔ', 'ɛ mu 'ʋ ‑Yusu ye', 'ɛ 'gbla kwlɩ, 'kɩ 'ʋ꞊ʋ ye', 'tɩ‑ ‑tɛblɩ a pɛpɛ ‑mʋ', ɛ ‑nu, 'ɛ na꞊a ‑mɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","‑Tɛ ‑Yusu 'wɩn 'kɩ, ‑ɛ ‑bɩ ɛ wɛn: «'Na 'yu, ‑tɛ ‑kuo 'mʋ ꞊wlʋ yɩ a ‑tɩ, 'nɩ nu꞊o, ‑na 'kʋɛ 'ɛ ‑wɛ. Mu, 'kɩ 'lɩ plɔbleelɛ 'kwli, ‑na 'kʋɛ ‑wɛ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Win nɩ 'lɩ꞊ɩ wlɔn, ‑ɛ ‑bɩ nyibli ‑hɔn 'lɩ nyiblo gbagbʋ Sayilu a ‑tɛ, ʋ wɛn: «Sayilu, ‑na 'yu nyrɔyu gbe ‑nɩ wɛn, ɛ 'kʋ nɩ. 'A ‑tɩ, ‑ha Tɔɔnyɔ ‑Yusu mɛ lɛ, 'ye ꞊bɩɩ ‑mɔ 'yɩ꞊ɩ 'ku ‑ha.» ");
INSERT INTO ktj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kɛɛ, ‑tɩ a pɛpɛ ‑mʋ', ʋ hlɛ, ‑Yusu 'nɩ ‑daa꞊a lɩ꞊ɩ ꞊dedede. Kɛ‑ ɛ pɩ 'kɩ Sayilu yɩ, ɛ wɛn: «‑Na ꞊wlʋ 'nɩ 'bie 'lɩ ꞊hlɔn, kɛɛ, kuo 'mʋ ꞊wlʋ yɩ dadʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","'Tɩ‑ ʋ 'mʋ mu, ɛ 'yɩ ‑wɛn, 'kɩ nyibli ‑bɩ bʋ kʋɛ꞊ɛ ꞊wien, 'bʋ 'yɩ 'a ‑nagbopʋ Piɛlɩ, kɔ Sakɩ, kɔ 'a 'dɩayɩ Saan nɩ ‑do 'pa‑. Ʋ nʋ‑ kɔ꞊ɔ 'hʋɛn‑ ‑mu 'lɩ Sayilu a ‑tɛ. ");
INSERT INTO ktj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","‑Tɛ ʋ nyre 'lɩ, ‑ɛ ‑bɩ ‑Yusu 'ye nyibli ‑hʋɔhʋɩ, 'ʋ 'gbugbe lɛ, 'ʋ pɩ popowli lɛ, kɔ, 'ʋ ni nyaɩ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","‑Tɛ ɛ pa 'lɩ 'kayu bʋ, ‑ɛ ‑bɩ ɛ wɛn: «Dɛ‑ kɔ ‑cici a lɛpʋpʋʋ 'lɩ? Dɛ‑ kɔ 'kɩ wuwe ‑wɛ 'lɩ? 'Yu ‑bʋ, ɛ 'yɩ 'kʋ, ŋmena ɛ yɩ ŋme.» ");
INSERT INTO ktj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ʋ ‑tʋa 'a 'caalɛ. ‑Ɛ ‑bɩ ɛ 'hrɔɔ nyibli a pɛpɛ a 'mʋ nɩ, 'ɛ da 'yu a 'baɩ, kɔ 'a 'dii, kɔ 'a ‑nagbopʋ nɩ ta ‑nɩ wɛn, 'ʋ pa 'lɩ ‑gblo ‑mʋ', ‑ɛ kɔ 'kwli 'yu pɛ 'lɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","‑Tɛ ʋ pa 'lɩ, ‑ɛ ‑bɩ ‑Yusu klɔ 'yu a dabʋ bʋ, ɛ wɛn: «Talita kumi,» ‑ɛ ꞊hɛn 'nyrɛ: «'Yu nyrɔyu, ‑mɔ 'n yɩ ‑lee ‑nɩ, 'du ye'.» ");
INSERT INTO ktj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ti nɩ ‑do a ti 'yri, ɛ 'du ye', 'ɛ ‑tʋa nɩna. 'Yu a 'mʋ, ɛ kɔ 'yrɩ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn. Bʋ 'ye 'kɩ dɛ a 'mʋ, ‑ɛ ‑bɩ ɛ kɛɛ 'waa ꞊wlɩ lɛ dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","‑Ɛ ‑bɩ ‑Yusu ti ꞊nʋ nɩ, 'kɩ 'lɩ win 'yaklɩ 'kwli, ɛ wɛn: «Dɛ ‑bʋ, 'n ‑nu, nyiblo ꞊dʋ 'nɩ 'lee 'lɩ 'a 'bɩ.» ‑Ɛ ‑bɩ kɛ‑ ɛ pʋ de: «Ba ‑nyi꞊e dididɛ, ɛ 'mʋ꞊ʋ di.» ");
INSERT INTO ktj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","‑Tɛ ‑tɛblɩ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu ‑hɔn 'lɩ 'dɩɔ a 'mʋ 'kwli nɩ, 'ɛ mu 'lɩ 'dɩɔ ‑mʋ', ‑ɛ kɔ 'kwli ɛ kuu 'lɩ. Ɛ kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ nʋ‑ ‑mu. ");
INSERT INTO ktj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","‑Tɛ ‑wuwle‑nyrɔwɔ* nyre 'ʋ, ‑ɛ ‑bɩ 'kɩ ʋ mu 'lɩ Nyɩsʋa a 'kayu bʋ, 'ɛ ‑tʋa Nyɩsʋa a ‑tɩ a tɔɔlɛ. Nyibli ‑hʋɔhʋɩ ‑mʋ', ‑ʋ nɩ 'ʋ, ‑tɛ ʋ 'wɩn 'a tɔɔwin a 'mʋ, ‑ɛ ‑bɩ ɛ kɛɛ 'waa ꞊wlɩ lɛ, ʋ wɛn: «Nyiblo a 'dɩ ‑bɩ ‑tɔɔ ꞊nɛ ‑tɩ ‑bʋ, ɛ hlɛ 'lɩ? Nyiblo a 'dɩ ‑bɩ ‑nyi꞊e ꞊tɔdʋ ‑mʋ' 'lɩ? Kɔ, nyiblo a 'dɩ ‑bɩ ‑nyi 'kɩ꞊ɩ 'klɩ, 'kɩ bʋ nu ꞊wlɩlɛkɛɛ‑tɛblɩ ‑bʋ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","‑A yi꞊e nɩ, ‑ɛ mɔ, ɛ mɔ 'camudɛ ꞊nɩɔ, 'ɛ mɔ Mari a 'yu. 'A 'dɩayɩ nyɩbɛpʋ, ʋ nʋ‑ mɔ Sakɩ, kɔ Sosɩ, kɔ Judɩ, kɔ Simɔ. 'A 'dɩayɩ nyrɔyo nɩ 'nɛ‑ ‑a mʋ 'nyɩ ‑wɛ.» 'Waa 'lulɛ‑hihiedʋ a 'mʋ, ɛ nɔ‑ nu꞊o, 'kɩ ʋ 'yɩ꞊ɩ ꞊wlʋ yɩ ‑kuo ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","‑Ɛ ‑bɩ ‑Yusu wɛn: «Nyiblo ‑bʋ, ‑ɛ mɔ Nyɩsʋa a winwlɔn‑hanyɔ*, ʋ ꞊tui 'ʋ꞊ʋ nɩ, 'kɩ 'ʋ 'a ‑nɛ ‑tɩtɛ ꞊dʋ. Kɛɛ, ʋ 'nɩ ꞊tuu꞊o 'ʋ꞊ʋ, 'kɩ 'lɩ 'a dɩɔnʋ a 'dɩɔ 'kwli, kɔ 'kɩ 'lɩ 'a 'dʋkʋɛ 'nyɩ, kɔ, 'kɩ 'lɩ 'a 'kayu bʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","'Kɩ 'lɩ ꞊nʋ 'nyɩ, ‑Yusu 'yɩ 'kɩ 'lɩ ꞊wlɩlɛkɛɛdɛ ꞊dʋ ‑nu, bʋ 'yɩ bʋ pʋ 'hʋɩhrennyʋ ‑bɩ dabʋɩ 'lu bʋ, 'waa 'kʋɛ 'mʋ ‑wɛ a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ɛ kɛɛ ‑Yusu a ꞊wlɩ lɛ, ‑tɛ ʋ ‑nu, 'kɩ ʋ 'yɩ꞊ɩ ꞊wlʋ yɩ ‑kuo ‑nɩ. ‑Tɛ ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu mi 'dɩɩ ‑mʋ', ‑ʋ ꞊glaa 'lɩ Nasalɛtɩ lɛ klɛ, 'ɛ tʋɛ nyibli Nyɩsʋa a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","‑Ɛ ‑bɩ ɛ da 'a ‑nagbopʋ* nɩ ‑pu ꞊tu 'ʋ 'hʋɛn nɩ, 'ɛ lee ꞊nʋ, ‑ɛ mɔ, bʋ nu 'hʋnhʋɛn.yo, bʋ na 'dɩɩ klɛ, 'ɛ ‑nyi ꞊nʋ 'klɩ, 'kɩ bʋ bla 'kuo ‑hʋɩn* lɛ, ‑ʋ nɩ 'ʋ nyibli ke'. ");
INSERT INTO ktj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","‑Ɛ ‑bɩ ɛ wɛn: «'Bʋ mɔ, 'ba yɩ 'dɩɩ klɛ nɩ nɛ, a 'nɩ 'gbaa 'lɩ ꞊dedede, 'bʋ 'yɩ kotu nɩ ‑do 'pa‑, a 'nɩ 'gbaa 'lɩ diidɛ ‑wɛ, kɔ blɔ, kɔ 'wliyɛ, ");
INSERT INTO ktj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","kɛɛ, ba gba 'suin nɩ ‑do, kɔ wlawlɩ ‑mʋ', a ‑pʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","‑Ɛ ‑bɩ ɛ wɛn de: «'Bʋ mɔ, 'ba nyre 'lɩ 'dɩɔ ꞊dʋ 'kwli, 'kayu ‑mʋ', ‑ɛ kɔ bʋ ʋ di 'lɩ 'a mʋ ‑paa ‑nɩ, 'kɩ ba nɩ 'lɩ ‑nɩnɩ, ɛ 'mʋ 'aan 'dɩɔ a 'mʋ a 'kwli‑hʋnhʋɔn a ti kɩ yɛ. ");
INSERT INTO ktj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","'Bʋ mɔ, 'ba nyre 'lɩ 'dɩɔ ‑bɩ 'kwli, 'bʋ ‑hɩa, 'kɩ bʋ 'ble 'a mʋ kʋa, kɔ, 'bʋ 'yɛ nɩ pʋ 'a mʋ nʋa yɩ bʋ, ‑ɛ ‑bɩ ba ‑hɔn 'lɩ 'dɩɔ a 'mʋ 'kwli. 'Ba yɩ nɩ mi, ba bʋbla 'aan bʋɩ, ‑ɛ di꞊e nu, 'waa ‑tʋtʋ a 'pupu 'mʋ 'a mʋ bʋɩ' lɛ ‑hɔn, a 'mʋ꞊ʋ nyibli a 'mʋ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, 'bʋ mɔ, Nyɩsʋa a yrʋ 'bʋ klɔ ꞊nʋ, 'waa ꞊gbɛtʋ nu꞊o 'waa dɩɔnʋ ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","‑Tɛ ɛ ‑wɛ 'kɩ 'waa titie ‑mɔ, ‑ɛ ‑bɩ 'a ‑nagbopʋ bi 'kɩ 'dɩɩ klɛ, 'ʋ yɩ nyibli ‑lee ‑nɩ, ʋ wɛn: «Ba hie 'ʋ 'aan dɛ 'kuku bʋ, ba ‑nyi 'aan 'klɔ a pɛpɛ Nyɩsʋa,» ");
INSERT INTO ktj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","‑nagbopʋ a 'mʋ, 'ʋ blɛ 'kuo ‑hʋɩn ‑mʋ', ‑ʋ nɩ 'ʋ nyibli ke' lɛ, kɔ, 'ʋ pɩ 'hʋɩhrennyʋ ‑hʋɔhʋɩ 'nyra 'lu lɛ, 'ʋ ni꞊e, 'waa 'kʋɛ 'ɛ yɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ti a 'mʋ 'yri, 'kɩɩn Helɔdɩ, ‑ɛ mɔ Galileblʋgba a 'kɩɩn, ɛ 'wɩn ‑Yusu a 'nyrɛ nɩ ‑wɛ. ꞊Wlɩlɛkɛɛ‑tɛblɩ ‑mʋ', ɛ ni a ‑ta', 'a 'nyrɛ 'hɛɛn 'blʋgba a pɛpɛ kɩ bʋ. Nyibli ‑bɩ wɛn: «Saan Batisɩ, ‑ɛ pɩ la nyibli 'nie 'lu lɛ, ɛ nɔ‑ ꞊nɩɔ. ‑Tɛ ɛ 'kʋ la, ɛ 'hrɩ 'klɔ de. Ɛ nɔ‑ nu꞊o, 'ɛ nɩ 'klɩ kɩ, 'ɛ ni ꞊wlɩlɛkɛɛ‑tɛblɩ ‑mʋ', ‑ɛ kɔ 'nyrɛ ‑a yɩ 'wɩn.» ");
INSERT INTO ktj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nyibli ‑bɩ wɛn: «Eli*, ‑ɛ mɔ Nyɩsʋa a winwlɔn‑hanyɔ*, ɛ nɔ‑ 'hrɩ 'klɔ.» Kɛ‑ ‑ʋ ‑bɩ pɩ ‑wɛ: «Nyɩsʋa a winwlɔn‑hanyɔ ‑bɩ ꞊nɩɔ. ‑Tɛ 'a winwlɔn‑hanyʋ nɩ la 'mʋ, ti ‑hi la a ti 'yri, kɛ‑ ɛ nɩ 'mʋ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Helɔdɩ ‑mɔ ‑bɩ, ‑tɛ ɛ 'wɩn, ‑ɛ ‑bɩ ɛ wɛn: «Saan Batisɩ ꞊nɩɔ, ‑ɛ kɔ 'lu 'n lee la nyibli bʋ 'bɛ la 'ʋ, ɛ nɔ‑ 'hrɩ 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","'Ɛ mɔ ‑tɛɛ, dɛ a 'mʋ, 'kɩɩn Helɔdɩ nu la Saan Batisɩ ‑mɔ, 'tɩ‑ 'ɛ mu la 'kʋ mɔ, ɛ nɔ‑ ‑bʋ: Helɔdɩ, 'a 'dɩayɩ Filipʋ, ɛ nɔ‑ kɔ la nʋgba. 'A 'nyrɛ mɔ la Helɔdiadɩ. Helɔdiadɩ a 'mʋ, ɛ nɔ‑ Helɔdɩ ‑ha la Filipʋ ‑jɩ', 'ɛ kɔ la꞊a. ‑Tɛ Saan Batisɩ 'wɩn la, ‑ɛ ‑bɩ ɛ wɛn: «Ɛ 'yɩ 'ʋ lɛ ‑nɔɔ ‑nɩ, 'kɩ ‑na 'dɩayɩ Filipʋ bʋ di 'klɔ nɩ, ‑bʋ di꞊e 'a nʋgba ‑jɩ' ‑ha, ‑bʋ di꞊e kɔ.» Helɔdiadɩ ‑mɔ ‑bɩ, ‑tɩ a 'mʋ, Saan Batisɩ ‑hla, ɛ nɔ‑ nu꞊o, 'ɛ pɩɩ ꞊nɛ yrʋ lɛ dɩakɩ, 'ɛ lee Helɔdɩ, bʋ lee nɛ 'a 'sɛyo bʋ klɔ Saan Batisɩ, bʋ mʋa ꞊nɛ, 'tɩ‑ bʋ pʋ꞊ʋ ꞊jɩ'. ‑Tɛ ʋ pʋ 'kɩ꞊ɩ ꞊jɩ', ‑ɛ ‑bɩ Helɔdiadɩ ꞊mʋɛ 'a 'lɩla lɛ. Kɛɛ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ");
INSERT INTO ktj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","‑ɛ nu꞊o, Helɔdɩ, ɛ yɩ Saan Batisɩ 'nɩ pie, kɔ, 'ɛ ꞊tui 'ʋ꞊ʋ. Ɛ yi꞊e nɩ, ‑ɛ mɔ, 'a 'klɔ 'sii 'ʋ yɩ, 'tɩ‑ 'ɛ mɔ Nyɩsʋa a nyiblo. Ɛ nɔ‑ nu꞊o, 'ɛ ꞊tui꞊e 'yie. 'A ‑nɛ ti, ɛ kɔ꞊ɔ 'hʋɛn‑ 'bʋ yɩ toto nɩ pɩ, Saan a totowin ‑hɛ Helɔdɩ 'ku dɩakɩ, kɛɛ, ɛ nʋɛ ꞊nɛ nɩ, 'kɩ bʋ 'wɩn 'a win. ");
INSERT INTO ktj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","‑Nyrɔwɔ ꞊dʋ 'kɩ, ‑ɛ ‑bɩ 'a nʋgba Helɔdiadɩ, ɛ 'ye la 'hru, 'kɩ bʋ nu꞊o, bʋ 'la Saan. ‑Nyrɔwɔ a 'mʋ, ɛ nɔ‑ mɔ la ‑nyrɔwɔ ‑mʋ', ‑ɛ kɔ 'kwli ʋ kɔɔ la 'ʋ Helɔdɩ, 'a lɛ'mimle. ‑Nyrɔwɔ a 'mʋ 'a ‑tɩ, ɛ da la nyibli, ʋ 'mʋ lɛ 'mle, kɔ, ʋ 'mʋ dɛ di. Nyibli a 'mʋ, ɛ ‑da, nʋ‑ mɔ 'a 'blʋgba, ‑ɛ mɔ Galileblʋgba a naanyʋ, kɔ 'sɛyo a nyibli gbagbɩ, kɔ 'blʋgba a nyibli gbagbɩ ‑bɩ 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","'Kɩ ʋ nɩ 'kɩ 'ʋ bʋ, ‑ɛ ‑bɩ Helɔdiadɩ a 'yu nyrɔyu pa 'lɩ ꞊nʋ 'nyɩ, 'ɛ ‑tʋa yiyie. 'A yiyie a 'mʋ, ɛ klɔɔ Helɔdɩ kɩ dɩakɩ, ɛ kɔ nyibli ‑mʋ', ɛ da wɛn lɛ'mimle kɩ 'hʋɛn‑. ‑Ɛ ‑bɩ kɛ‑ ɛ pɩ꞊ɩ yɩ, ɛ wɛn: «‑Hʋa 'a ‑nɛ dɛ, ‑na ꞊wlʋ nʋɛ ‑nɩ. 'N di ‑mɔ꞊ɔ 'nɩ ‑nyi.» ");
INSERT INTO ktj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kɛ‑ ɛ pɩ꞊ɩ yɩ de: «'N 'sʋʋ nɩ, 'a ‑nɛ dɛ, ‑di ‑hʋa, 'n di ‑mɔ꞊ɔ 'nɩ ‑nyi, 'ye ꞊bɩɩ ɛ mɔ 'na 'blʋgba a 'kʋtɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","‑Tɛ 'yu nyrɔyu 'wɩn, ‑ɛ ‑bɩ ɛ 'hrɩ nɩ, 'ɛ mu 'a 'dii 'bɛti mɔ, ɛ wɛn: «'Na 'dii, dɛ a 'dɩ ‑bɩ ꞊bʋ ‑hʋa 'lɩ?» ‑Ɛ ‑bɩ 'a 'dii wɛn: «Dɛ ‑bʋ ‑hʋa, ɛ nɔ‑ mɔ Saan Batisɩ a 'kʋkʋʋ. Bʋ 'bɛ 'ʋ 'a 'lu, bʋ ya 'lɩ꞊ɩ 'lɩ, ‑a 'mʋ꞊ʋ 'ye, ‑ɛ mɔ, ɛ 'kʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","'Tɩ‑ 'a 'dii 'mʋ ‑yrɛ, ‑ɛ ‑bɩ 'yu nyrɔyu a 'mʋ, ɛ 'kɩka nɩ, 'ɛ pa de, 'ɛ mu 'ʋ 'kɩɩn ye', ɛ wɛn: «Dɛ 'n ‑hʋɛ, ɛ nɔ‑ mɔ Saan Batisɩ a 'kʋkʋʋ. 'Bɛ 'ʋ 'a 'lu, ‑bʋ pʋ 'lɩ꞊ɩ hu 'kwli, ‑bʋ ya 'mɔ꞊ɔ yɩ, ‑tɛ ti nɛ ‑bʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","‑Tɛ 'kɩɩn 'wɩn, ‑ɛ ‑bɩ 'a ꞊wlʋ 'mʋɛ bʋ. Kɛɛ, ‑tɛ ɛ 'sʋʋ wɛn ‑nɩ, 'kɩ 'ʋ nyibli ‑mʋ', ɛ ‑da ye', 'a ‑tɩ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ hɩa. ");
INSERT INTO ktj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ti nɩ ‑do a ti 'yri, 'ɛ lee nɛ 'a 'sɛyotayu ‑bɩ, ɛ wɛn: «Mu 'lɩ ꞊jɩkayu bʋ, ‑bʋ 'bɛ 'ʋ Saan Batisɩ a 'lu, ‑bʋ ya 'mɔ꞊ɔ yɩ, ‑tɛ ti nɛ ‑bʋ,» 'sɛyotayu a 'mʋ, 'ɛ mu 'lɩ ꞊jɩkayu bʋ, 'ɛ 'bɛ 'ʋ Saan a 'lu, ");
INSERT INTO ktj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","'ɛ pʋ 'lɩ꞊ɩ hu 'kwli, 'ɛ ya꞊a, 'ɛ ‑nyi꞊e 'yu nyrɔyu a 'mʋ, 'yu nyrɔyu a 'mʋ, 'ɛ gba꞊a 'a 'dii yɩ. ");
INSERT INTO ktj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","‑Tɛ Saan a ‑nagbopʋ 'wɩn 'a 'kʋkʋ‑tɩ, ‑ɛ ‑bɩ ʋ di la nɩ, 'ʋ ‑hʋa 'a ‑plahʋɩ, 'ʋ gba la꞊a, 'ʋ ꞊tu la꞊a. Kɛ‑ Saan Batisɩ nu la 'kʋkʋʋ. ");
INSERT INTO ktj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","‑Tɛ ‑Yusu lee la 'a ‑mɔnanyʋ*, bʋ na la 'dɩɩ klɛ, bʋ hla la 'a ‑tɩ, 'a ‑mɔnanyʋ a 'mʋ, ʋ ‑mɛ kle, 'ʋ ‑di, 'ʋ ꞊gbee 'ʋ ‑Yusu 'hʋɩ. ‑Tɛblɩ a pɛpɛ, ʋ ‑nu, kɔ, ‑tɩ a pɛpɛ, ʋ tɔɔ nyibli, ɛ nɔ‑ ʋ nɛ ‑mɔ lɛ, 'kɩ 'ʋ ‑Yusu ye'. ");
INSERT INTO ktj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nyibli ‑hʋɔhʋɩ mi la 'ʋ ꞊nʋ 'hʋɩ lɛ, 'ʋ pɩ la toto, 'tɩ‑ 'ʋ ‑hʋɛn la 'ʋ ꞊nʋ 'hʋɩ. Ɛ nɔ‑ nu꞊o, ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, 'ʋ 'yɛ nɩ kɔ ti, 'kɩ bʋ di dɛ. Ɛ nɔ‑ kɔ ‑tɩ, ‑Yusu 'ɛ lee nɛ 'a ‑nagbopʋ, ɛ wɛn: «Ba 'de, ‑ba mu 'lɩ ‑tɛ ‑mʋ', 'dʋ bii 'lɩ yɩ, ‑ɛ di꞊e nu, ‑a 'mʋ 'lɩ 'hʋɩ lɛ ‑ha dɛ gbe.» ");
INSERT INTO ktj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","‑Ɛ ‑bɩ ʋ bi 'lɩ 'blagbɩ 'kwli, 'ʋ mu 'lɩ ‑tɛ ‑mʋ', 'dʋ bii 'lɩ yɩ. ");
INSERT INTO ktj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kɛɛ, nyibli ‑hʋɔhʋɩ, ‑ʋ 'ye ꞊nʋ, ‑tɛ ʋ yɩ nɩ mi, ʋ yru ꞊nʋ nɩ, 'dɩɩ a pɛpɛ a nyibli 'ʋ 'bɛ ‑wlu, 'ʋ 'yraa 'yru wien lɛ, 'ʋ 'bɛ ꞊nʋ ye', 'kɩ 'ʋ ‑tɛ ‑mʋ', ʋ di 'ʋ ‑kwlɛɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","‑Tɛ ‑Yusu ꞊tɩ 'lɩ 'blagbɩ 'kwli, ‑ɛ ‑bɩ ɛ 'ye nyibli ‑hʋɔhʋɩ a 'mʋ, ‑ʋ nɩ 'ʋ nɩ. Bʋ 'ye ꞊nʋ, ‑ɛ ‑bɩ 'waa nyaɩ ‑tʋa 'a nunuo, ‑ɛ nu꞊o, ʋ 'wɩ‑ blablɩ yɩ, ‑ʋ 'yɩ kʋkɔnyɔ ‑kɔ, 'ɛ bi 'ʋ, 'ɛ ‑tʋa 'waa ‑tɛblɩ ‑hʋɔhʋɩ a tɔɔlɛ. ");
INSERT INTO ktj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","‑Tɛ 'tɔ yɩ nɩ ‑wɛn, ‑ɛ ‑bɩ ‑nagbopʋ 'yɩya 'ʋ ‑Yusu 'hʋɩ bʋ, 'ʋ lee ꞊nɛ, ʋ wɛn: «‑Tɩtɛ ‑bʋ, ‑a nɩ 'nɛ‑, 'dʋ bii 'nɛ‑ yɩ, dididɛ 'yɩ 'nɛ‑ ‑nɩ, 'tɩ‑ 'tɔ ‑wɛn nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","'A ‑tɩ, lee nyibli ‑bʋ, bʋ mu 'lɩ 'dɩɩ kɔ ‑yrigbi ‑mʋ' klɛ, ‑ʋ ꞊glaa 'lɩ ‑a mʋ lɛ, bʋ mu 'waa dɩɔnʋ a diidɛ lɛ ꞊mʋɔ, ʋ 'mʋ꞊ʋ ‑tɔ.» ");
INSERT INTO ktj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","‑Ɛ ‑bɩ ‑Yusu wɛn: «'Aan ꞊gbɛtʋ, ba ‑nyi ꞊nʋ diidɛ.» ‑Ɛ ‑bɩ ʋ wɛn: «Dɛ a 'dɩ ‑bɩ ‑a di gba, ‑a 'mʋ 'waa diidɛ ‑tɔ 'lɩ? 'Wliblɔ, ‑a di gba, 'tɩ‑ ‑a 'mʋ 'waa diidɛ 'ye.» ");
INSERT INTO ktj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","‑Ɛ ‑bɩ ‑Yusu wɛn: «'Flɔɔkui nɩ ‑tie a kɔ 'lɩ? Ba mu 'lɩ 'aan blɔ 'kwli lɛ ta.» ‑Tɛ ʋ ta 'lɩ lɛ, ‑ɛ ‑bɩ ʋ lee ꞊nɛ nɩ, ʋ wɛn: «‑A kɔ 'flɔɔkui nɩ ꞊hun kɔ ‑hrin.yɔ nɩ 'hʋɛn.» ");
INSERT INTO ktj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ‑Yusu lee ꞊nʋ nɩ, ɛ wɛn: «Ba lee nyibli ‑mʋ', bʋ nu dui, bʋ nɩ blɛ, 'kɩ 'ʋ ‑piti kɩ.» ꞊Hɔnpʋ a 'mʋ 'kwli, ‑ɛ ‑bɩ ‑piti 'yɛ nɩ 'kʋɩ, ");
INSERT INTO ktj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","'ʋ pʋ dui, 'ʋ nɩ blɛ. Du ‑bɩ nu nyibli a (100) ‑wlɩ nɩ ꞊hun, du ‑bɩ 'ɛ nu nyibli a (50) ‑wlɩ nɩ 'hʋɛn ꞊tu 'ʋ ‑pu. ");
INSERT INTO ktj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","‑Tɛ ʋ nɩ 'kɩ blɛ, ‑ɛ ‑bɩ ‑Yusu 'du 'flɔɔkui nɩ ꞊hun kɔ ‑hrin.yɔ nɩ 'hʋɛn a 'mʋ ye', 'ɛ 'du 'lu ye', 'ɛ ta 'lɩ yɔ' lɛ, 'ɛ ‑nyi Nyɩsʋa 'wio, 'kɩ 'ʋ dididɛ a 'mʋ a ‑ta', 'tɩ‑ 'ɛ 'bɛ꞊ɛ ꞊tɩɔ lɛ, 'ɛ ‑nyi꞊e 'a ‑nagbopʋ, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ nyibli a pɛpɛ a 'mʋ lɛ ꞊gla, 'ɛ ꞊gla ‑hrin.yɔ nɩ 'hʋɛn a 'mʋ nyibli a pɛpɛ lɛ, ");
INSERT INTO ktj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","'waa pɛpɛ, 'ʋ di dɛ ‑didi, 'ʋ ꞊mla. ");
INSERT INTO ktj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","‑Tɛ ʋ ‑wɛ dɛ lɛ, ‑ɛ ‑bɩ 'flɔɔ kɔ ‑hrin 'hʋɛn‑, ‑ʋ hie blɛ, ‑nagbopʋ 'ʋ 'tɩ ꞊nʋ lɛ, 'ʋ 'yii 'lɩ ‑tʋgbɛwɩ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn. ");
INSERT INTO ktj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nyibli ‑mʋ', ‑ʋ di dɛ, nyɩbɛpʋ a 'miliwɩ nɩ ꞊hun, ʋ nʋ‑ nɩ la 'lɩ ꞊nʋ 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ ‑Yusu lee nɛ 'a ‑nagbopʋ nɩ, bʋ 'ya 'lɩ 'blagbɩ 'kwli, bʋ ꞊ta 'yru, bʋ muu 'dɩɔ ‑mʋ', ‑ɛ mɔ Bɛtɩsaida yɩ, 'tɩ‑ ɛ 'mʋ ꞊nʋ ꞊wien kʋɛ. Ti a 'mʋ 'yri, 'kɩ ɛ di 'ʋ nyibli wlu ‑gbaa ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","‑Tɛ ʋ ‑gbɛ lɛ, ‑ɛ ‑bɩ 'kɩ ɛ mu 'lɩ dʋgba 'lu, 'ɛ mu 'lɩ Nyɩsʋa ‑mɔ hlee mɔ. ");
INSERT INTO ktj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","‑Tɛ 'tɔ ‑wɔn, ‑ɛ ‑bɩ 'kɩ 'blagbɩ 'tɩɛ nɩ 'ʋ 'nie a ‑hɛyri'. ‑Yusu nɩ ‑do, nɔ‑ nɩ 'ʋ 'gbahlɔn. ");
INSERT INTO ktj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","‑Ɛ ‑bɩ ɛ 'ye꞊e nɩ, ‑ɛ mɔ, biblie pʋɛ ꞊nʋ lɛ, ‑ɛ nu꞊o, pepe yɩ 'nɩ ‑hu dɩakɩ, 'ɛ ‑wɛn ꞊nʋ yɩ dɩakɩ. Yɩ‑hɛhapɛ bʋ pʋ win a ti 'yri, ‑ɛ ‑bɩ ɛ ‑tʋa 'lɩ 'waa ‑mɔmumuo, 'ɛ nɛ 'nie klɛ, 'ɛ pʋ 'lɩ 'waa lɛ‑hihie dɛ gbe. ");
INSERT INTO ktj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","‑Tɛ ʋ 'ye꞊e, ‑ɛ mɔ, ɛ nɛ 'nie klɛ, ‑ɛ ‑bɩ ʋ daa ꞊nɛ 'ku, 'ʋ 'ta 'ʋ blɛ, hʋannʋ a ‑tɩ, 'ʋ pɩ ‑cici lɛ. Ti nɩ ‑do a ti 'yri, kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ: «Ba 'kee 'ʋblɛ'tɩta. 'Mɔ ꞊nɩɔ. A 'nɩ 'pie 'lɩ hʋannʋ,» ");
INSERT INTO ktj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","'ɛ 'ya 'lɩ ꞊nʋ ‑mɔ, 'kɩ 'lɩ 'blagbɩ 'kwli. ‑Tɛ ɛ 'ya 'kɩ, ‑ɛ ‑bɩ pepe nyra bʋ. Ɛ kɛɛ 'waa ꞊wlɩ lɛ dɩakɩ, ");
INSERT INTO ktj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","‑ɛ nu꞊o, ‑tɛ ‑Yusu wloo wɛn 'flɔɔ, 'waa ꞊wlɩ 'yɩ꞊ɩ ‑klɔ, ‑ɛ mɔ, ‑Yusu, ɛ nɔ‑ ‑wɛ 'lɩ 'a ‑nɛ ꞊dedede. 'Waa ꞊wlɩ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ yru 'ʋ dɛ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","‑Tɛ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ ꞊ta 'yru, ʋ nyre 'lɩ Senesalɛtɩdɩɔ 'kwli, 'ʋ ꞊tɩ 'lɩ 'blagbɩ 'kwli, 'ʋ mʋa ꞊nɛ bʋ. ");
INSERT INTO ktj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","‑Tɛ ʋ ꞊tɩ 'kɩ 'lɩ 'blagbɩ 'kwli, ‑ɛ ‑bɩ ti nɩ ‑do a ti 'yri, nyibli yru ‑Yusu nɩ, ");
INSERT INTO ktj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","'ʋ bi 'blʋgba a pɛpɛ kɩ, 'ʋ blɛ 'waa kɩklanyibli, 'ʋ pɩ ꞊nʋ ‑hanmakɩ 'kwli lɛ, 'ʋ yɛ 'lɩ ꞊nʋ lɛ, kɩ 'ʋ ‑tɛ ‑mʋ', ‑Yusu nɩ 'ʋ, ɛ 'mʋ꞊ʋ nu, 'waa 'kʋɛ 'mʋ ‑wɛ a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","'A ‑nɛ 'dɩɔ kɔ ‑yrugbi, ‑Yusu mi 'lɩ kɩ, kɛ‑ ʋ ni, 'ʋ yɩ kɩklanyibli ti kɩ ‑wɛ, 'kɩ 'ʋ 'dika, 'tɩ‑ 'ʋ nyɛɛ ꞊nɛ lɛ, 'kɩ bʋ wɛn, bʋ ‑hrɛn 'a wlawlʋ lɛ dadʋ, mɔ 'ye ꞊bɩɩ ɛ mɔ 'a wlawlʋ a ‑wlubʋdɛ, nyibli a pɛpɛ ‑yɩ lɛ ‑hrɛn, 'waa 'kʋɛ yɩ 'nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ɛ kɔ ‑nyrɔwɔ ꞊dʋ, Falisi꞊tumu* a nyibli ꞊dʋ, ʋ kɔ Nyɩsʋa a tetetɔɔnyʋ ꞊dʋ 'hʋɛn‑, nʋ‑ ‑hɔn 'lɩ Jrusrɛdɩɔ 'kwli, 'ʋ 'kukue lɛ, 'kɩ 'ʋ ‑Yusu 'hʋɩ. ");
INSERT INTO ktj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","'Kɩ ʋ nɩ 'ʋ, ‑ɛ ‑bɩ ʋ 'ye꞊e nɩ, ‑ɛ mɔ, ‑Yusu a ‑nagbopʋ* ‑bɩ 'yɩ ꞊jrɛ ‑yra, 'ʋ yɩ dɛ di. ");
INSERT INTO ktj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","'Ɛ mɔ ꞊han‑tɩ, Falisi꞊tumu a nyibli bi 'lɩ yɩ, ʋ kɔ ‑Juukʋɛ* ‑bɩ 'hʋɛn‑, ʋ ꞊tui 'ʋ 'waa 'baɩnʋ a tete nɩ. Ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, 'kɩ 'a nyiblo bʋ 'yɩ ꞊jrɛ ‑yra ‑tɛɛ, 'tɩ‑ bʋ di dɛ. ");
INSERT INTO ktj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, 'a nyiblo bʋ ‑hɔn 'lɩ 'maɩ ye', 'kɩ bʋ 'yɩ bʋɩ lɛ ‑yra, 'tɩ‑ bʋ di dɛ, 'ʋ ꞊tui 'ʋ 'waa 'baɩnʋ a tete ‑hʋɔhʋɩ ‑bɩ, ʋ hie ꞊nʋ lɛ nɩ. Ɛ nɔ‑ mɔ: ‑Tɛ ʋ di 'nie'naapʋɛlɩ kɔ 'plɛɛ‑tɛblɩ kɔ 'plɩyɩ 'hʋɛn‑ a lɛyɩyra nu. Ʋ wɛn 'nɩ, ɛ nɔ‑ ni꞊e, 'tɩ‑ 'ʋ yɩ 'ʋ yɩ 'sii ‑nɩ, 'kɩ 'ʋ Nyɩsʋa ye'. ");
INSERT INTO ktj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","‑Ɛ ‑bɩ ʋ 'bɛti 'kɩ ‑Yusu nɩ: «Dɛ‑ kɔ ‑tɩ 'kɩ ‑na ‑nagbopʋ 'ʋ 'yɛ nɩ ꞊tu 'ʋ tete ‑bʋ, ‑aan 'baɩnʋ tɔɔ nɛ ‑a mʋ 'lɩ? 'Bʋ mɔ, 'bʋ yɩ dɛ di mɔ nɩ mi, 'kɩ 'ʋ 'yɛ nɩ yra ꞊jrɛ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","‑Ɛ ‑bɩ ɛ ꞊tu ꞊nʋ ‑wɔn, ɛ wɛn: «A nɛ 'li nɩ 'hʋɛn. Ti ꞊dʋ a ti 'yri la, winwlɔn‑hanyɔ Esai hla la ‑tɩ a ‑tɛɛ, 'kɩ 'ʋ 'a mʋ ‑bʋ ‑mɔ. Dɛ, ɛ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, ɛ nɔ‑ ‑bʋ: Nyɩsʋa wɛn 'nɩ: Dakɔ ‑bʋ, ʋ yɩ ‑nyi 'mʋ ‑tɩ a 'yi'bʋalɛ, 'kɩ 'ʋ wuntɔ 'yri, kɛɛ, 'waa ꞊wlɩ hlɔɔ 'mʋ ‑mɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ʋ wɛn 'nɩ, 'n kɔ ‑tɩ a 'yi'bʋalɛ, kɛɛ, 'na ‑tɩ 'yɩ 'lɩ 'waa ꞊wlɩ kɩ ‑nɩ, ‑ɛ nu꞊o, ‑tonyibli a tete, ʋ tʋɛ ‑nɩ, ɛ nɔ‑ ʋ dɛɛ Nyɩsʋa a tete.» ");
INSERT INTO ktj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ de: «A hie 'ʋ Nyɩsʋa a tete bʋ, 'a ꞊tui 'ʋ ‑tonyibli a tete 'ʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","‑Ɛ ‑bɩ ɛ hlee 'lɩ ꞊nʋ ‑mɔ de, ɛ wɛn: «A wɛn 'nɩ, a kɔ ꞊tɔ, 'a pʋ Nyɩsʋa a tete 'kɩbɩa kɩ, 'a nɛɛ nɛ 'aan tete. ");
INSERT INTO ktj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","'Ɛ mɔ ‑tɛɛ, Nyɩsʋa a winwlɔn‑hanyɔ Moise hla la꞊a nɩ, 'kɩ 'lɩ Nyɩsʋa a tete 'kwli. Tete a 'mʋ, ɛ wɛn 'nɩ: ꞊Tuu 'ʋ ‑na 'baɩ kɔ ‑na 'dii 'hʋɛn‑, 'kɩ 'lɩ 'waa nʋɛlɛ 'kwli. Kɛ‑ tete a 'mʋ, 'a dɛ ‑bɩ pɩ: Nyiblo 'bʋ ‑ha 'a 'baɩ kɔ 'a 'dii 'hʋɛn‑ 'hri lɛ, ʋ kɔ bʋ 'la꞊a. ");
INSERT INTO ktj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kɛɛ, 'a mʋ ‑mɔ ‑bɩ, a wɛn 'nɩ: Nyiblo ‑wɛ 'lɩ bʋ lee nɛ 'a 'baɩ kɔ 'a 'dii 'hʋɛn‑ nɩ, ‑ɛ mɔ: 'Na kʋkɔ‑tɛblɩ a 'kʋtɩɔ ‑bɩ, 'n kɔ ꞊bʋ ‑nyi wɛn 'a mʋ, 'kɩ 'ʋ 'aan ‑hɛɛlɛ a ‑ta', 'n ‑ha꞊a nɩ, 'kɩ 'ʋ Nyɩsʋa a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","‑Ɛ ‑bɩ a wɛn 'nɩ: Nyiblo a 'mʋ, 'bʋ nu lɛ, 'bʋ hla ‑tɩdʋ a 'mʋ, 'kɩ 'ʋ 'a 'baɩ kɔ 'a 'dii 'hʋɛn‑ ‑mɔ', ‑ɛ ‑bɩ ɛ 'yɩ 'kɩ yɩ ‑blɛɛ ‑nɩ, bʋ ‑hɛɛ 'kɩ ꞊nʋ de. ");
INSERT INTO ktj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kɛ‑ a ni 'kɩ, 'a ꞊tui 'ʋ 'aan dɩɔnʋ a tete 'ʋ, 'a 'wlɛ Nyɩsʋa a tete, 'tɩ‑, 'a ni yɩnyre‑tɛblɩ ‑bɩ, ‑ʋ 'wlɛ Nyɩsʋa a tete.» ");
INSERT INTO ktj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","‑Ɛ ‑bɩ ‑Yusu da nyibli ‑bɩ ‑mʋ', ‑ʋ nɩ ‑tuo a 'mʋ kɩ nɩ. Kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «'Aan pɛpɛ, ba pʋ 'mʋ nʋa yɩ bʋ, ‑tɩ 'n di hla, a 'mʋ꞊ʋ' lɛ yru. ");
INSERT INTO ktj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ɛ 'yɩ dididɛ ‑bʋ, ‑ɛ nɛɛ 'lɩ ‑tonyiblo wlɔn, ‑ɛ mi 'lɩ꞊ɩ 'kwli, ɛ 'nɩ ‑nu꞊o lɩ꞊ɩ, nyiblo a 'mʋ, ɛ 'nɩ 'sii꞊e 'ʋ yɩ, 'kɩ 'ʋ Nyɩsʋa ye'. Kɛɛ, dɛ ‑bʋ, ‑ɛ ‑hʋɛn 'lɩ ‑tonyiblo ꞊wlʋ kɩ, ɛ nɔ‑ ni꞊e, 'kɩ ɛ 'yɛ nɩ 'sii 'ʋ yɩ, 'kɩ 'ʋ Nyɩsʋa ye'. ");
INSERT INTO ktj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ba 'nɛɛ 'ʋ nʋa bʋ ‑tɛɛ, nyiblo 'bʋ kɔ ‑tɩ'wɩnnʋa, ɛ 'mʋ꞊ʋ' lɛ yru.» ");
INSERT INTO ktj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","‑Tɛ ‑Yusu ‑wɛ 'kɩ 'lɩ nyibli a 'mʋ, 'waa ‑mɔhleelɛ ‑mɔ, ‑ɛ ‑bɩ ɛ ‑hɔn 'ʋ ꞊nʋ 'hʋɩ, 'ɛ mu 'lɩ 'kayu bʋ. ‑Tɛ ɛ nyre 'lɩ, ‑ɛ ‑bɩ 'a ‑nagbopʋ* 'bɛti꞊e nɩ, 'kɩ 'ʋ 'ledʋ a 'mʋ, ɛ pʋ wɛn, 'a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «꞊Bɩ 'a mʋ ‑bɩ ‑bʋ, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba kɔ ‑tɩ 'a lɛyuyruo? ꞊Bɩ a 'nɩ 'wɩn꞊ɩ lɩ, ‑ɛ mɔ, ɛ 'yɩ dididɛ ‑bʋ, ‑ɛ nɛɛ 'lɩ nyiblo wlɔn, ‑ɛ yɩ 'lɩ꞊ɩ 'kwli bi, ɛ 'yɩ꞊ɩ 'pa‑, ɛ 'nɩ ‑nu꞊o lɩ꞊ɩ, ɛ 'nɩ 'sii꞊e 'ʋ yɩ, 'kɩ 'ʋ Nyɩsʋa ye'? ");
INSERT INTO ktj_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","‑Ɛ nu꞊o, dididɛ 'nɩ ‑mu꞊o 'lɩ nyiblo a ꞊wlʋ kɩ. Kɛɛ, 'kɩ ɛ mi 'lɩ꞊ɩ 'kwli, 'kɩ ɛ nɛɛ 'lɩ, 'ɛ yɩ 'lɩ ‑patʋ' bi.» 'Kɩ 'lɩ win a 'mʋ 'kwli, ‑Yusu yɩ ꞊nʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, 'a ‑nɛ dididɛ ꞊dʋ nu ‑tɛɛ, 'kɩ nyiblo bʋ di꞊e, ‑ɛ nu꞊o, ɛ 'yɩ꞊ɩ 'pa‑, ɛ 'nɩ ‑nu꞊o lɩ꞊ɩ, nyiblo 'nɩ 'sii꞊e 'ʋ yɩ, 'kɩ 'ʋ Nyɩsʋa ye'. ");
INSERT INTO ktj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ de, ɛ wɛn: «Dɛ ‑bʋ, ‑ɛ ‑hʋɛn 'lɩ ‑tonyiblo a ꞊wlʋ kɩ, ɛ nɔ‑ ni꞊e, 'kɩ ɛ 'yɛ nɩ 'sii 'ʋ yɩ, 'kɩ 'ʋ Nyɩsʋa ye', ");
INSERT INTO ktj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","‑ɛ nu꞊o, 'kɩ 'lɩ ‑tonyiblo a ꞊wlʋ kɩ, 'kɩ 'lulɛ‑hihie ‑hʋan ‑hʋɛn 'lɩ ‑wlu, 'ɛ ni꞊e, 'ɛ ni ‑tɛblɩ ‑hʋɩn: 'ɛ ni 'lawlu, 'ɛ yɩ 'yri, 'ɛ 'lɛ nyibli, ");
INSERT INTO ktj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","'ɛ ni ‑wlawlɩ, 'ɛ ‑hʋɛ bʋ kɔ 'a 'bio a kʋkɔ‑tɛblɩ ‑wɛ, 'ɛ ni 'crɛ, 'ɛ ni 'a 'bio ꞊yrɛ lɛ, 'ɛ 'yɩ ‑tʋɩ ‑kɔ, 'ɛ kɔ ca, 'ɛ yɩ nyibli a 'nyrɛ yrɛ nyre, 'ɛ 'yɛɛ 'lɩ 'a dɩɔnʋ, ɛ 'nɩ ‑hie꞊e 'lu lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yɩnyre‑tɛblɩ a pɛpɛ a 'mʋ, 'kɩ ɛ ‑hʋɛn 'lɩ ‑tonyiblo a ꞊wlʋ kɩ. Ɛ nɔ‑ ni꞊e, 'kɩ ɛ 'yɛ nɩ 'sii 'ʋ yɩ, 'kɩ 'ʋ Nyɩsʋa ye'.» Kɛ‑ ‑Yusu pʋ 'a ‑nagbopʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu ‑hɔn 'lɩ ‑Juukʋɛ a 'blʋgba 'kwli nɩ, 'ɛ mu 'lɩ hɩapʋblʋgba ‑bɩ 'kwli. 'Kɩ 'lɩ 'blʋgba a 'mʋ 'kwli, 'kɩ 'dɩɔ ‑mʋ', ‑ɛ mɔ Tilɩ, ɛ nɩ 'lɩ. ‑Tɛ ɛ nyre 'lɩ Tilɩ a 'mʋ 'kwli, ‑ɛ ‑bɩ 'kɩ 'lɩ ‑huhlike 'kwli, 'ɛ pa 'lɩ nyiblo ꞊dʋ a ‑tɛ, ‑ɛ nu꞊o, ɛ 'yɩ꞊ɩ ‑hʋa, 'kɩ nyiblo ꞊dʋ bʋ yru꞊o. Kɛɛ, nyibli yru꞊o nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","'Kɩ 'lɩ nyibli a 'mʋ 'nyɩ, 'kɩ nʋgba ꞊dʋ nɩ 'lɩ. Nʋgba a 'mʋ, ɛ 'yɩ ‑Juukʋɛyrɔwlʋ 'pa‑. 'Kɩ ɛ kɔ 'lɩ Fenisi, 'kɩ 'lɩ Siliblʋgba 'kwli. ('Kɩ 'lɩ ‑Juukʋɛ ‑mɔ ‑bɩ ‑mɔ, nyibli 'bʋ 'yɩ ‑Juukʋɛ 'pa‑, ʋ dɛɛ ꞊nʋ ‑gbo.) Nʋgba a 'mʋ, nɔ‑ kɔ 'yu nyrɔyu 'ku ‑hʋan* nɩ 'ʋ ke'. ‑Tɛ nʋgba a 'mʋ, ɛ 'wɩn 'kɩ ‑Yusu a 'nyrɛ, ‑ɛ ‑bɩ 'kɩ ɛ mu 'lɩ꞊ɩ ‑mɔ, 'ɛ 'gbla kwlɩ, 'kɩ 'ʋ꞊ʋ ye', ɛ wɛn: «'N nyaa ‑mʋ lɛ, bla 'ku ‑hʋan ‑mʋ' lɛ, ‑ɛ nɩ 'ʋ 'na 'yu ke'.» ");
INSERT INTO ktj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","‑Ɛ ‑bɩ ‑Yusu ꞊tu 'kɩ nʋgba a 'mʋ ꞊wɔn, ɛ wɛn: «꞊Bʋ pʋʋ ꞊nɛ dɛ yɩ: Yɩ‑hɛdɛ, ‑kɔ ‑bʋ ‑ha 'yonʋ mɛ lɛ, bʋ ꞊mla. Ɛ 'yɩ 'ʋ lɛ ‑nɔɔ ‑nɩ, 'yonʋ ‑mʋ', (‑ʋ mɔ ‑Juukʋɛ,) bʋ nɩ 'lɩ dɛ a didie 'kwli, 'tɩ‑ nyiblo ꞊dʋ bʋ ‑ha 'ʋ ꞊nʋ 'waa dididɛ a 'mʋ ye', bʋ 'wla 'ʋ꞊ʋ ‑gbo ye' bʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","‑Ɛ ‑bɩ nʋgba a 'mʋ, ɛ ꞊tu꞊o ꞊wɔn, ɛ wɛn: «Tɔɔnyɔ o, ɛ mɔ ꞊han‑tɩ ꞊nɩɔ. Kɛɛ 'kɩ, 'yonʋ 'bʋ yɩ dɛ nɩ di, ‑tɛblɩ yɩ ble ꞊nʋ ꞊jrɛ, 'waa ‑gbo 'ʋ yɩ꞊ɩ lɛ 'tɩ, 'ʋ yɩ꞊ɩ di.» ");
INSERT INTO ktj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","‑Ɛ ‑bɩ ‑Yusu wɛn: «‑Tɛ ꞊tu 'mʋ ꞊wɔn, 'kɩ 'lɩ ꞊haanwin 'kwli, ɛ nɔ‑ kɔ ‑tɩ 'nɩ nu꞊o, 'ku ‑hʋan 'ɛ ‑hɔn 'ʋ ‑na 'yu nyrɔyu ke'. 'A ‑tɩ, ‑wɛ 'lɩ ‑bʋ mu 'lɩ 'kayu bʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","‑Tɛ nʋgba a 'mʋ, ɛ nyre 'lɩ 'kayu bʋ, 'ɛ mɔ ꞊han‑tɩ, 'kɩ ɛ yɛɛ 'ʋ 'a 'yu bʋ, 'ɛ pɛ bʋ gbee. 'Ku ‑hʋan ‑hɔn 'ʋ꞊ʋ ke' nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu ‑hɔn 'lɩ Tilɩdɩɔ 'kwli nɩ, 'ɛ 'bɛ Sidɔdɩɔ ꞊tɩɔ, kɔ, 'ɛ naa 'lɩ Dekapɔblʋgba 'kwli, 'tɩ‑ 'ɛ nyre 'lɩ Galileblʋgba a 'yru wien. ");
INSERT INTO ktj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","‑Tɛ ɛ ‑nyre 'kɩ, ‑ɛ ‑bɩ ʋ ya꞊a 'kikenyɔ ꞊dʋ yɩ, ‑ɛ 'yɩ 'plɛlɛ ‑yi. ‑Ɛ ‑bɩ ʋ ‑tʋa ‑Yusu a lɛnyaalɛ, bʋ pʋ꞊ʋ dabʋɩ 'lu bʋ, 'a 'kʋɛ 'mʋ ‑wɛ, ");
INSERT INTO ktj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","‑Yusu, 'ɛ ‑ha 'lɩ꞊ɩ nyibli 'nyɩ, 'ʋ bii yɩ, 'tɩ‑ 'ɛ 'nyra 'lɩ꞊ɩ ‑jio nʋɩ' lɛ, kʋɛ 'ʋ bʋ de, 'ɛ pʋ 'a ‑jio hɩʋn, 'ɛ kʋa 'ʋ꞊ʋ 'a mɛ kɩ bʋ, ");
INSERT INTO ktj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","'tɩ‑ 'ɛ 'wla 'yi wla, 'ɛ tɛ 'lɩ yɔ' lɛ, 'ɛ 'wla ‑hʋnhlʋn bʋ, 'ɛ lee nyiblo a 'mʋ, ɛ wɛn: «Ɛfata,» ‑ɛ ꞊hɛn 'nyrɛ: «Bʋ klɛ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ 'a nʋɩ klɛ yɩ, 'ɛ ‑tʋa ‑tɩ a 'wɩnwɩɩn ‑tɛɛ, kɔ, 'a mɛ 'ɛ ꞊wlɛ kɩ bʋ ‑tɛɛ, 'ɛ ‑tʋa 'pʋplɛ ‑tɛɛ. ");
INSERT INTO ktj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","‑Ɛ ‑bɩ ‑Yusu ti nyibli a 'mʋ, ‑ʋ ꞊gbee 'ʋ nɩ, ‑ɛ mɔ, ‑tɛblɩ a pɛpɛ a 'mʋ, ‑ɛ mu 'lu ‑mɔ, ʋ 'nɩ 'naa 'lɩ꞊ɩ ‑mɔ lɛ, 'kɩ 'ʋ nyiblo ꞊dʋ ye'. Kɛɛ, ɛ nɩ 'lɩ 'waa leelɛ 'kwli, 'ʋ ‑tʋa 'a ‑mɔlɛnɩna. ");
INSERT INTO ktj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","‑Ɛ ‑bɩ ɛ kɛɛ nyibli a ꞊wlɩ lɛ dɩakɩ, 'ʋ pɩ lɛ: «‑Tɛblɩ a pɛpɛ, ɛ ni, ɛ mɔ yɩnɔ‑tɛblɩ. Ba 'ye kɛ, ɛ ni꞊e nɩ, 'kikenyʋ, 'ʋ yɩ ‑tɩ 'wɩn, kɔ, nyibli ‑mʋ', ‑ʋ 'yɩ 'plɛlɛ ‑yi, 'ʋ yɩ 'plɛ ‑tɛɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ti a 'mʋ 'yri, nyibli ‑hʋɔhʋɩ ‑bɩ, ʋ nʋ‑ ‑di, 'ʋ ꞊gbee 'ʋ ‑Yusu 'hʋɩ, ʋ 'mʋ 'a tɔɔwin 'wɩn. Ʋ 'yɩ dididɛ ‑kɔ. ‑Ɛ ‑bɩ ‑Yusu da 'a ‑nagbopʋ* nɩ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Nyibli ‑bʋ, 'waa nyaɩ ni 'mʋ nɩ, ‑ɛ nu꞊o, ‑tɛ ʋ bi la 'nɛ‑ 'mʋ 'hʋɩ, 'a ‑nyrɔwɩ nɩ ta a ‑nyrɔwɔ ‑bʋ, 'tɩ‑ ʋ 'yɩ dididɛ ‑kɔ. ");
INSERT INTO ktj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","'Bʋ 'yɩ dɛ ‑di, 'nɩ pʋ lɛ, bʋ mu 'waa 'dɩɩ klɛ, ‑ɛ ‑bɩ ʋ nɩ 'hru wlɔn, 'waa 'klɩ 'mʋ 'lɩ ‑wɛ, 'kanʋ a ‑tɩ, ‑ɛ nu꞊o, ‑tɛ ‑ʋ ‑bɩ ‑hɔn 'lɩ ‑wlu, 'dʋ hlɔ 'lɩ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","‑Ɛ ‑bɩ 'a ‑nagbopʋ ꞊tu꞊o ꞊wɔn, ʋ wɛn: «‑Bɩ' ‑a di 'kɩ nu, 'tɩ‑ ‑a 'mʋ ꞊nʋ dididɛ ‑nyi, ‑ɛ di ꞊nʋ ꞊mla 'lɩ? ‑Tɩtɛ ‑bʋ, ‑a nɩ 'nɛ‑, 'dʋ bii 'nɛ‑ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","‑Ɛ ‑bɩ ‑Yusu 'bɛti ꞊nʋ nɩ, ɛ wɛn: «'Flɔɔkui nɩ ‑tie ‑nɩ 'ʋ 'a mʋ 'hʋɩ 'lɩ?» ‑Ɛ ‑bɩ ʋ wɛn: «'A 'yɔ nɩ ꞊hlon'hʋɛn.» ");
INSERT INTO ktj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","‑Ɛ ‑bɩ ɛ lee nyibli a 'mʋ, ‑ʋ nɩ 'ʋ꞊ʋ 'hʋɩ nɩ, 'kɩ bʋ nɩ blɛ, 'ɛ 'du 'flɔɔkui nɩ ꞊hlon'hʋɛn a 'mʋ ye', 'ɛ ‑nyi Nyɩsʋa 'wio, 'ɛ 'bɛ꞊ɛ ꞊tɩɔ lɛ, 'ɛ ‑nyi꞊e 'a ‑nagbopʋ, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ ꞊gla, ‑nagbopʋ a 'mʋ, 'ʋ ꞊gla ꞊nʋ꞊ʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ʋ nɩ ‑do a 'mʋ de, ʋ kɔ ‑hrin.yɔ gbi ‑wɛ, ‑Yusu 'ɛ ‑nyi Nyɩsʋa 'wio de, 'ɛ lee nɛ 'a ‑nagbopʋ de, 'kɩ bʋ ꞊gla ꞊nʋ꞊ʋ lɛ, 'ʋ ꞊gla ꞊nʋ꞊ʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","‑Ɛ ‑bɩ nyibli a pɛpɛ, ʋ di dɛ ‑tɛɛ, 'ʋ ꞊mla. ‑Tɛ ʋ ꞊mla, 'flɔɔ, ‑ɛ hie bʋ, ‑tɛ 'a ‑nagbopʋ 'kukue꞊e lɛ, ʋ 'yii 'lɩ ‑tʋgbɛ gbagbɩ nɩ ꞊hlon'hʋɛn. ");
INSERT INTO ktj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nyibli, ‑ʋ di dɛ, ʋ ‑wɛ 'lɩ ‑tonyibli a 'miliwɩ nɩ ‑hɛn. ‑Tɛ ɛ ‑hi 'kɩ, ‑ɛ ‑bɩ ‑Yusu tɛ ꞊nʋ bʋ, 'kɩ bʋ mu 'lɩ 'waa 'dɩɩ klɛ, ");
INSERT INTO ktj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ɛ nɔ‑ ‑mɔ ‑bɩ, ɛ kɔ 'a ‑nagbopʋ 'hʋɛn‑, 'ʋ ‑mu, 'ʋ 'ya 'lɩ 'blagbɩ 'kwli, 'ʋ mu 'lɩ 'blʋgba a 'kɩbɩa ‑bɩ ‑mʋ', ‑ɛ kɔ 'kwli 'dɩɔ nɩ 'lɩ, ʋ dɛɛ Damanuta. ");
INSERT INTO ktj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ Falisi꞊tumu a nyibli nyre 'ʋ nɩ, ʋ kɔ ‑Yusu 'hʋɛn‑, 'ʋ ‑tʋa hihle, ‑ɛ di꞊e nu, ʋ 'mʋ 'ʋ꞊ʋ lɛ ꞊tɛɛ ‑nɩ. Ʋ ‑hʋɛ bʋ 'ye꞊e, 'bʋ mɔ, 'bʋ ‑wɛ 'lɩ bʋ nu ꞊wlɩlɛkɛɛdɛ, ‑ɛ di ꞊nʋ꞊ʋ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, Nyɩsʋa, ɛ nɔ‑ lee 'nɛ꞊ɛ ‑tʋtʋ kɩ. ");
INSERT INTO ktj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ‑Yusu 'wla ‑hʋnhlʋn bʋ, ɛ wɛn: «Dɛ‑ nu 'kɩ꞊ɩ, ti ‑bʋ 'yri a nyibli ‑bʋ, 'ʋ ‑hʋɛ ꞊wlɩlɛkɛɛdɛ de, ‑ɛ di ꞊nʋ꞊ʋ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, Nyɩsʋa, nɔ‑ lee 'nɛ‑ 'mʋ ‑tʋtʋ kɩ. 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ: ‑Tɛ a nɩ 'mʋ a nyibli, Nyɩsʋa 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ wɛn꞊ɛ kɩ, 'kɩ ba 'ye 'a ‑nɛ ꞊wlɩlɛkɛɛdɛ ꞊dʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ɛ ‑hɔn 'ʋ ꞊nʋ 'hʋɩ, ɛ kɔ 'a ‑nagbopʋ* 'hʋɛn‑, 'ʋ 'ya 'lɩ 'blagbɩ 'kwli, 'ʋ mu 'lɩ Galileblʋgba a 'yru a 'kɩbɩa ‑bɩ kɩ. ");
INSERT INTO ktj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","‑Tɛ ‑Yusu a ‑nagbopʋ* yɩ 'lɩ 'blagbɩ 'kwli nɩ 'yɛ, ‑ɛ ‑bɩ ɛ ‑hru ꞊nʋ ‑mɔ 'kɩ bʋ gba dididɛ, 'bʋ 'yɩ 'flɔɔkuo nɩ ‑do 'pa‑, ‑ɛ nɩ 'lɩ 'waa ‑tɛblɩ 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","‑Ɛ ‑bɩ ‑Yusu yɩ ꞊nʋ 'nɩ ti, ɛ wɛn: «Falisi꞊tumu a nyibli a 'flɔɔ a 'yaadɛ, kɔ 'kɩɩn Helɔdɩ a 'flɔɔ a 'yaadɛ a ‑tɩ, ba ꞊tu 'aan dɩɔnʋ 'yie.» ");
INSERT INTO ktj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kɛɛ ‑nagbopʋ a 'mʋ, ʋ 'yɩ꞊ɩ lɛ ‑yru, ‑ɛ mɔ, 'yaadɛ a 'mʋ, ‑kɔtɩ ‑Yusu hlɛ, ɛ mɔ dɛ a yɩpʋʋdɛ ꞊nɩɔ, ‑ɛ ꞊hɛn 'nyrɛ, nyibli a 'mʋ, 'waa 'lulɛ‑hihie ‑hʋan. Bʋ 'yɩ 'kɩ ‑tɩ a 'mʋ lɛ ‑yru, ɛ nɔ‑ nu꞊o, 'ʋ ‑tʋa lɛ'bɛtilɛ, ʋ wɛn: «꞊Bɩ ‑tɛ ‑a 'yɩ 'flɔɔ ‑ya, ɛ nɔ‑ kɔ ‑tɩ 'ɛ ni 'pʋplɛ lɛ?» ");
INSERT INTO ktj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","‑Tɩ a 'mʋ, ‑nagbopʋ ‑hla, ‑Yusu 'wɩn nɩ, ɛ wɛn: «Dɛ‑ kɔ 'kla ꞊yɛ 'a mʋ ‑wliye 'lɩ? ꞊Bɩ ‑tɛ a 'yɩ kɛ dididɛ ‑kɔ a ‑tɩ? A 'tɩɛ 'yɛ ‑tɩ a lɛyuyruo nɩ kʋɛ. 'Aan ꞊wlɩ 'gboklo nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","A kɔ 'yii, kɛɛ, a 'nɩ ‑yru꞊o lɛ. A kɔ nʋɩ, kɛɛ, a 'nɩ ‑yru꞊o ‑tɩ' lɛ. Ɛ kɔ, a kla ‑tɩ‑mɔ‑hru‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","‑Tɛ 'n wloo la 'flɔɔkui nɩ ꞊hun, 'kɩ ‑tonyibli a 'miliwɩ nɩ ꞊hun bʋ di dɛ a ‑ta', ‑tɛ ʋ ‑wɛ la dɛ lɛ, 'flɔɔ ‑mʋ', ‑ɛ hie la bʋ, ‑tʋgbɩwɩ nɩ ‑tie a 'yii la 'lɩ 'lɩ?» ‑Ɛ ‑bɩ ʋ wɛn: «'A 'yɔ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn.» ");
INSERT INTO ktj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","‑Ɛ ‑bɩ ɛ wɛn: «'Tɩ‑, ‑tɛ 'n wloo la 'flɔɔkui nɩ ꞊hlon'hʋɛn, 'kɩ ‑tonyibli a 'miliwɩ nɩ ‑hɛn bʋ di dɛ a ‑ta', ‑tɛ ʋ ‑wɛ la dɛ lɛ, 'flɔɔ ‑mʋ', ‑ɛ hie la bʋ, ‑tʋgbɩwɩ nɩ ‑tie a 'yii la 'lɩ 'lɩ?» ‑Ɛ ‑bɩ ʋ wɛn: «'A 'yɔ nɩ ꞊hlon'hʋɛn.» ");
INSERT INTO ktj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","‑Ɛ ‑bɩ ɛ wɛn: «A 'tɩɛ 'yɛ ‑tɩ a lɛyuyruo nɩ kʋɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","‑Tɛ ʋ nyre 'lɩ Bɛtɩsaidadɩɔ 'kwli, ‑ɛ ‑bɩ ʋ ya ‑Yusu 'yiiklanyɔ ꞊dʋ yɩ, 'ʋ ‑tʋa 'a lɛnyaalɛ, bʋ pʋ꞊ʋ dabʋɩ 'lu blɛ, 'a 'yii 'mʋ yɩ klɛ, ");
INSERT INTO ktj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","‑Yusu 'ɛ 'ble 'yiiklanyɔ a 'mʋ a dabʋ kʋa, 'ɛ ꞊tɩɔ ꞊nɛ 'dɩɔ. Bʋ ꞊tɩɔ 'kɩ꞊ɩ 'dɩɔ, ‑ɛ ‑bɩ ɛ plʋ꞊ʋ hɩʋn 'yi klɛ, 'ɛ pʋ꞊ʋ dabʋɩ 'lu bʋ, 'ɛ 'bɛti꞊e, ɛ wɛn: «꞊Bɩ ‑yɩ 'ye dɛ?», ");
INSERT INTO ktj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","'yiiklanyɔ a 'mʋ 'ɛ ꞊wlɛ 'yii, ɛ wɛn: «'N yɩ 'ye ‑tonyibli, kɛɛ, ʋ 'wɩ ti yɩ, 'ʋ nɛ,» ");
INSERT INTO ktj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","‑Yusu 'ɛ gba 'ʋ꞊ʋ dabʋɩ 'yi kɩ de. ‑Tɛ ɛ ‑ha 'ʋ 'a dabʋɩ, ‑ɛ ‑bɩ nyiblo a 'mʋ, ɛ tɛ 'lɩ ye' lɛ. 'A 'yii klɛ yɩ. Ɛ yrui 'kɩ lɛ ‑tɛɛ. ");
INSERT INTO ktj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","‑Ɛ ‑bɩ ‑Yusu wɛn: «Mu 'lɩ ‑na 'dɩɔ 'kwli, kɛɛ, ꞊nɩ 'naa 'lɩ Bɛtɩsaidadɩɔ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, 'kɩ ʋ mi 'lɩ 'dɩɩ ꞊dʋ kɩ. 'Dɩɩ a 'mʋ, ʋ 'mʋɛ 'blʋgba ‑mʋ', ‑ɛ kɔ 'nyrɛ ‑mɔ Filipʋ a Sesale yrɛ. Ʋ nɩ 'kɩ 'hru wlɔn, ‑ɛ ‑bɩ ɛ 'bɛti ꞊nʋ nɩ: «Nyibli wɛn 'nɩ, nyiblo a 'dɩ ‑bɩ 'n pa 'mʋ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","‑Ɛ ‑bɩ ʋ ꞊tu꞊o ꞊wɔn, ʋ wɛn: «‑Ʋ ‑bɩ wɛn 'nɩ, ‑mɔ Saan Batisɩ ꞊nɩɔ, ‑ɛ pɩ la nyibli 'nie 'lu lɛ. ‑Ʋ ‑bɩ wɛn 'nɩ, ‑mɔ Nyɩsʋa a winwlɔn‑hanyɔ Eli ꞊nɩɔ. ‑Ʋ ‑bɩ wɛn 'nɩ, ‑mɔ Nyɩsʋa a winwlɔn‑hanyɔ ‑bɩ ꞊nɩɔ, ‑ɛ 'kʋ la, 'tɩ‑ ‑ɛ 'hrɩ 'klɔ de.» ");
INSERT INTO ktj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","‑Ɛ ‑bɩ ɛ wɛn: «'A mʋ ‑mɔ ‑bɩ, a wɛn nyiblo a 'dɩ ‑bɩ 'n pa 'mʋ 'lɩ?» ‑Ɛ ‑bɩ Piɛlɩ bi 'ʋ nɩ, ɛ wɛn: «‑Mɔ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la 'a dakɔ yɩ ya.» ");
INSERT INTO ktj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","‑Ɛ ‑bɩ ‑Yusu ti ꞊nʋ nɩ ‑tɛɛ, ɛ wɛn: «A 'nɩ 'hlaa 'lɩ꞊ɩ nyiblo ꞊dʋ yɩ, nyiblo a 'dɩ ‑bɩ 'n pa 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","‑Ɛ ‑bɩ ‑Yusu bi 'ʋ nɩ, 'ɛ ‑tʋa 'a ‑nagbopʋ* a tɔɔlɛ, 'kɩ 'ʋ ‑tɛblɩ a pɛpɛ ‑mʋ', ‑ɛ di꞊e yrɛ mu a ‑ta', ɛ wɛn: «'Mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, ‑nyrɔwɔ ꞊dʋ, 'n di 'ye ꞊hɩʋɛn dɩakɩ. 'Blʋ a nyibli, ʋ kɔ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ, ʋ kɔ 'blʋ a tetetɔɔnyʋ 'hʋɛn‑, ʋ kɔ bʋ yraa 'mʋ, 'tɩ‑ ʋ 'mʋ 'mʋ 'la. 'Bʋ mɔ, 'nɩ 'kʋ, ‑nyrɔwɩ nɩ 'hʋɛn 'bʋ ‑hi, ta a ‑nyrɔwɔ, 'n kɔ ꞊bʋ 'hrɩ 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","‑Tɛ ɛ yɩ ꞊nʋ ‑tɩ a 'mʋ nɩ ‑tʋɛ ‑nɩ, ɛ 'yɩ ꞊nʋ ꞊dedede 'yi kɩ ‑hlii ‑nɩ. Ɛ nɔ‑ mɔ, Piɛlɩ bʋ daa ꞊nɛ 'kɩbɩa ‑mɔ, 'ɛ yɩ꞊ɩ ‑mɔ 'plɛ, ɛ wɛn: «‑Tɩ ‑bʋ, ‑yɩ 'lu ‑mɔ lɛ ‑hie, 'nɩ ‑hʋa꞊a lɩ꞊ɩ, bʋ nu ‑mʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","‑Ɛ ‑bɩ ‑Yusu ꞊hɩan ‑mɔ, 'ɛ ta 'lɩ 'a ‑nagbopʋ ‑bɩ ‑mʋ' ‑mɔ lɛ, 'tɩ‑ 'ɛ ‑maa Piɛlɩ 'yi, ɛ wɛn: «hlɔɔ 'mʋ ‑mɔ lɛ, Satan! Dɛ ‑mʋ', ‑yɩ 'lu ‑mɔ lɛ ‑hie, ɛ 'yɩ꞊ɩ 'pa‑, Nyɩsʋa 'nɩ ‑hie lɩ꞊ɩ 'lu ‑mɔ lɛ. ‑Na 'lulɛ‑hihie mɔ ‑tonyibli a 'lulɛ‑hihie ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ɛ da nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, ʋ kɔ 'a ‑nagbopʋ 'hʋɛn‑ nɩ, ɛ wɛn: «Nyiblo 'bʋ yɩ꞊ɩ nɩ ‑hʋɛ, 'kɩ bʋ kʋɛ 'mʋ ꞊wien lɛ, ɛ 'nɩ 'kʋɛɛ 'lɩ 'a dɩɔnʋ a 'lulɛ‑hihie ꞊wien lɛ, kɛɛ, ‑tɩ ‑mʋ', 'n di꞊e ‑lee ‑nɩ, ɛ nɔ‑ bʋ nu 'a ‑nɛ ti, 'ye ꞊bɩɩ nyibli pʋ lɛ, ʋ 'mʋ꞊ʋ 'la, ‑tɛ ɛ pa 'ʋ, 'ɛ mɔ 'na nyiblo a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nyiblo 'bʋ pʋ lɛ, ɛ 'nɩ ‑hʋa꞊a lɩ bʋ 'waan nɛ 'a dɩɔnʋ a ‑hʋnhlʋn, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, 'kɩ 'ʋ 'na ‑ta', nyiblo a 'mʋ, 'bʋ 'kʋ, ɛ di 'a 'klɔ yrayrʋ 'nɩ 'waan ‑nɩ, 'kɩ 'lɩ Nyɩsʋa yɩ. Kɛɛ, nyiblo 'bʋ ‑wɛn, 'kɩ 'a dɩɔnʋ a ‑hʋnhlʋn bʋ 'wan, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, ‑tɛ ɛ nʋɛ 'mʋ a ‑tɩ, ɛ kɔ, 'kɩ 'ʋ Nyɩsʋa a ꞊haantitie a ‑tɩ, ‑ɛ ‑bɩ nyiblo a 'mʋ, 'bʋ mɔ, 'bʋ 'kʋ, ɛ di kɔ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ, 'kɩ 'lɩ Nyɩsʋa yɩ. ");
INSERT INTO ktj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nyiblo 'bʋ kɔ 'klɔ ‑bʋ a kʋkɔ‑tɛblɩ a pɛpɛ, 'tɩ‑ 'bʋ 'waan nɛ 'a dɩɔnʋ a 'klɔ yrayrʋ, 'kɩ 'lɩ Nyɩsʋa yɩ, kʋkɔ‑tɛblɩ a 'mʋ, ɛ 'nɩ ‑pʋ꞊ʋ 'ʋ꞊ʋ ꞊dedede nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nyiblo 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ pʋ 'ʋ ꞊dedede 'klɔ yrayrʋ a 'mʋ a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","'Kɩ a nɩ 'lɩ nyibli ‑bʋ, ‑ʋ 'yɛ nɩ ꞊tuu 'ʋ Nyɩsʋa, ‑ʋ ‑plee 'lɩ Nyɩsʋa ke 'nyɩ. 'Bʋ mɔ, 'ba yɩ ‑tʋɩ nɩ pie, 'kɩ 'ʋ nyibli a 'mʋ ye', 'kɩ ꞊bʋ di 'aan Kʋkɔnyɔ' pa, kɔ, 'kɩ ba di 'ʋ 'na win 'ʋ ꞊tuu ‑nɩ, ‑ɛ ‑bɩ 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, ti ‑mʋ' ‑kɔ 'yri 'n di 'ʋ ‑dii ‑nɩ de, 'kɩ 'lɩ 'na 'Baɩ a ‑tɩ a 'yi'bʋalɛ 'kwli, 'n kɔ 'a lɛlenyʋ 'hʋɛn‑, ti a 'mʋ 'yri, 'n di pie ‑tʋɩ ‑wɛ, 'kɩ 'ʋ Nyɩsʋa ye', 'kɩ ꞊bʋ hla꞊a, ‑ɛ mɔ, a mɔ 'na nyibli.» ");
INSERT INTO ktj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","‑Ɛ ‑bɩ ‑Yusu yɩ ꞊nʋ 'nɩ ‑lee ‑nɩ de, ɛ wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, 'kɩ 'lɩ 'a mʋ 'nyɩ, nyibli ‑bɩ nɩ 'lɩ, ʋ 'mʋ꞊ʋ 'ye ‑nyrɔwɔ ꞊dʋ, ‑tɛ Nyɩsʋa di nyibli a win a kɩkɔɔlɛ nu, 'kɩ 'lɩ 'a 'klɩ 'kwli, 'tɩ‑ ɛ 'mʋ nyibli a 'mʋ, 'waa 'kʋkʋʋ a ti kɩ yɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","‑Tɛ ‑nyrɔwɩ nɩ ꞊hlon‑do ‑hi, ‑ɛ ‑bɩ ‑Yusu gba Piɛlɩ kɔ Sakɩ kɔ Saan 'hʋɛn‑ nɩ, 'ʋ mu 'lɩ dʋgba blɔblʋ ꞊dʋ 'lu. Ʋ nɩ ‑do, 'kɩ ʋ nɩ 'lɩ, ‑ɛ ‑bɩ ‑Yusu 'cɩcɩ nɩ, 'kɩ 'lɩ ꞊nʋ 'yi. ");
INSERT INTO ktj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","'A wlawlɩ 'plɛ nɩ dɩakɩ, 'tɩ‑ 'ʋ yɩ wlɩn. ‑Tɛ ʋ nu 'pʋplɛ, nyiblo ꞊dʋ 'yɩ 'nɛ‑ 'klɔ kɩ ‑nɩ, ‑bʋ nu dɛ, bʋ nu 'pʋplɛ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ ʋ 'ye Nyɩsʋa a winwlɔn‑hanyʋ Eli kɔ Moise 'hʋɛn‑ nɩ. Nyibli nɩ 'hʋɛn a 'mʋ, ʋ 'kʋ la see la. Nʋ‑ 'hrɩɩ 'ʋ ‑Yusu 'hʋɩ, ʋ kɔ ‑Yusu 'hʋɛn‑ 'ʋ ‑tʋa toto a pʋpʋʋ. ");
INSERT INTO ktj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Piɛlɩ bʋ yɩ 'kɩ ꞊nʋ nɩ 'ye, ‑ɛ ‑bɩ ɛ yɩ ‑Yusu 'nɩ ‑lee ‑nɩ, ɛ wɛn: «Tɔɔnyɔ, ɛ nu ‑tɛɛ, 'kɩ ‑ba nɩ 'nɛ‑ ‑tɩtɛ ‑bʋ bʋ. ‑Ba pʋ papʋɩ nɩ ta, ‑nɛ pʋpa, Moise a ‑nɛ, kɔ Eli a ‑nɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Piɛlɩ hla ‑tɩ a 'mʋ nɩ, ‑ɛ nu꞊o, ɛ kɔ 'a 'bio 'hʋɛn‑, ʋ ta 'ʋ blɛ, 'a ‑tɩ, ‑tɩ bʋ di hla, ɛ 'yɩ꞊ɩ ‑yi. ");
INSERT INTO ktj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","‑Ɛ ‑bɩ ti nɩ ‑do a ti 'yri, ‑jruŋma ꞊tɩɩ 'ʋ ꞊nʋ 'lu, 'ɛ ‑hli ꞊nʋ. 'Kɩ 'lɩ ‑jruŋma a 'mʋ 'kwli, 'kɩ Nyɩsʋa a win ‑hʋɛn 'lɩ ‑wlu, 'ɛ pɩ lɛ: «Nyiblo ‑bʋ, ɛ nɔ‑ mɔ 'na nʋɛyu. Ɛ nɔ‑ ba pʋ nʋa yɩ bʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ti nɩ ‑do a ti 'yri, bʋ yɩ 'ʋ 'waa dɩɔnʋ 'hʋɩ lɛ nɩ tɛ, ‑ɛ ‑bɩ ʋ 'kee nyibli ‑nɩ wɛn a 'yiye nɩ, 'bʋ 'yɩ ‑Yusu nɩ ‑do 'pa‑. ");
INSERT INTO ktj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","‑Tɛ ʋ yɩ 'kɩ dʋgba a 'mʋ nɩ ꞊tɩ, ‑ɛ ‑bɩ ‑Yusu yɩ ꞊nʋ 'nɩ ti, ɛ wɛn: «Dɛ ‑bʋ, a 'ye, a 'nɩ 'lee 'lɩ nyiblo ꞊dʋ, ɛ 'mʋ꞊ʋ gba ‑gbagba, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'mʋ 'kʋ, 'mʋ 'lɩ 'kʋkʋnyibli 'nyɩ ‑hɔn, 'mʋ 'klɔ 'hrɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","‑Tɩ a 'mʋ, ‑Yusu ‑hla, ʋ ꞊tuu 'ʋ꞊ʋ nɩ. Kɛɛ, ʋ yɩ 'bɛti 'waa dɩɔnʋ lɛ, bʋ 'kʋ, bʋ ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ, bʋ 'hrɩ 'klɔ, dɛ a 'dɩ ‑bɩ ɛ ꞊hɛn 'nyrɛ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","‑Ɛ ‑bɩ ‑nagbopʋ ‑tʋa 'a lɛ'bɛtilɛ, ʋ wɛn: «Dɛ‑ kɔ ‑tɩ, Nyɩsʋa a tetetɔɔnyʋ 'ʋ pɩ lɛ, ‑ɛ mɔ, Nyɩsʋa a winwlɔn‑hanyɔ Eli, ɛ nɔ‑ kɔ ‑bʋ 'nyɛɛ 'hru, ‑bʋ di, 'tɩ‑ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya, ɛ 'mʋ di 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","‑Ɛ ‑bɩ ɛ wɛn: «Ɛ mɔ ꞊han‑tɩ, Eli, ɛ nɔ‑ kɔ ‑bʋ di yɩ‑hɛdɛ, ɛ 'mʋ Nyɩsʋa a dakɔ ‑hɛɛ ‑nɩ, ʋ 'mʋ 'waa 'klɔ ꞊hrɛntɩ ‑nɩ, ʋ 'mʋ ‑mɔ ‑wɛ, 'tɩ‑ Wanyɔ a 'mʋ, ɛ 'mʋ di. 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ: Nyiblo, ‑ɛ 'wɩ‑ Eli yɩ, ɛ di nɩ, 'tɩ‑ yɩnyre‑tɛblɩ ‑bʋ, ‑tonyibli ‑hʋɛ bʋ nu꞊o ‑mɔ, 'ʋ nu ꞊nɛ꞊ɛ ‑mɔ, ‑tɛ ʋ nu la 'a 'cɩcrɩɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ti ‑hi la a ti 'yri. Ʋ 'crɩ꞊ɩ nɩ ‑wɛ, ‑ɛ mɔ, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n kɔ ꞊bʋ 'ye ꞊hɩʋɛn dɩakɩ, 'tɩ‑ nyibli 'mʋ 'mʋ ‑yraa ‑nɩ ‑wɛ. Dɛ ɛ ꞊hɛn 'nyrɛ, ꞊bɩ a ‑hie꞊e 'lu ‑mɔ lɛ nɩ?» ");
INSERT INTO ktj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","‑Tɛ ʋ ꞊tɩ 'kɩ dʋgba a 'mʋ, ‑ɛ ‑bɩ ‑nagbopʋ* a 'mʋ, ‑Yusu hie wɛn 'ʋ bʋ, 'tɩ‑ ɛ 'mʋ 'ʋ ꞊nʋ 'hʋɩ nyre, ɛ 'ye nyibli ‑hʋɔhʋɩ, 'ʋ ꞊glaa 'lɩ ꞊nʋ lɛ, ʋ kɔ tetetɔɔnyʋ 'hʋɛn‑. Tetetɔɔnyʋ a 'mʋ, ʋ nʋ‑ pɩ gblɛ, ʋ kɔ ‑nagbopʋ ‑bɩ a 'mʋ 'hʋɛn‑, ʋ hie wɛn 'ʋ bʋ. ");
INSERT INTO ktj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","‑Tɛ nyibli 'ye 'kɩ ‑Yusu, ‑ɛ yɩ 'lɩ di, ‑ɛ ‑bɩ 'waa ꞊wlɩ kɛɛ lɛ, 'ʋ mu꞊o ye' 'bɛ mɔ, 'kɩ 'lɩ cigbɛ 'kwli, ʋ 'mʋ꞊ʋ 'wio ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","‑Tɛ ‑Yusu nyre 'ʋ, ‑ɛ ‑bɩ ɛ 'bɛti 'a ‑nagbopʋ a 'mʋ, ɛ yɛɛ 'ʋ bʋ nɩ, ɛ wɛn: «Dɛ‑ kɔ gblɛ a pɩ 'kɩ, a kɔ tetetɔɔnyʋ 'hʋɛn‑ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","'Kɩ 'lɩ nyibli ‑hʋɔhʋɩ a 'mʋ 'nyɩ, 'kɩ nyiblo ꞊dʋ nɩ 'lɩ. Ɛ nɔ‑ ꞊tu꞊o ꞊wɔn, ɛ wɛn: «Tɔɔnyɔ, 'n ya 'nɛ‑ ‑mʋ 'na 'yu yɩ, ꞊mʋ꞊ʋ nu, 'a 'kʋɛ 'mʋ ‑wɛ, ‑ɛ nu꞊o, 'ku ‑hʋan nɩ 'ʋ꞊ʋ ke'. Ɛ nɔ‑ ni꞊e, 'kɩ ɛ 'yɩ 'lɩ 'pʋplɛ 'lɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","'A ‑nɛ ti, 'ku ‑hʋan a 'mʋ, 'bʋ 'hrɩ 'blo, ɛ kɔ bʋ pʋ꞊ʋ ꞊hlɔn lɛ, 'tɩ‑ 'yu a 'mʋ, hɩʋnplu 'ɛ nyrɛ꞊ɛ wien bʋ, kɔ, 'ɛ yɩ 'nyɩ di, kɔ, 'a 'hʋɩ 'ɛ yɩ 'hiun. 'N lee ‑na ‑nagbopʋ nɩ, bʋ bla 'ku ‑hʋan a 'mʋ lɛ, kɛɛ, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kɛ‑ ‑Yusu pɩ 'kɩ 'a ‑nagbopʋ yɩ, ɛ wɛn: «A mɔ nyibli ꞊nɩɔ, ‑ʋ 'yɩ Nyɩsʋa ꞊wlʋ yɩ ‑kuo ‑nɩ ‑tɛɛ. Ti nɩ ‑tie 'n kɔ ꞊bʋ ‑hii 'nɛ‑ 'a mʋ 'nyɩ, 'tɩ‑ a 'mʋ Nyɩsʋa ꞊wlʋ yɩ ‑kuo ‑nɩ 'lɩ? ꞊Bɩ kɛ‑ 'n di nu, 'mʋ 'a mʋ lɛ ‑kikle ‑nɩ 'a ‑nɛ ti? Ba ya 'mʋ 'yu a 'mʋ yɩ,» ");
INSERT INTO ktj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","'ʋ ya ꞊nɛ꞊ɛ yɩ. ‑Tɛ ɛ 'ye ‑Yusu, ‑ɛ ‑bɩ 'ku ‑hʋan a 'mʋ, ɛ ‑tʋa 'yu a 'mʋ a lɛ꞊gbapʋlɛ, 'kɩ 'lɩ 'klɩ 'kwli, 'yu a 'mʋ 'ɛ bi ꞊hlɔn, 'ɛ ‑tʋa ‑tʋtʋ a klɛ'blikelɛ, 'ɛ ‑wlɛ hɩʋn, hɩʋnplu 'ɛ pɛ꞊ɛ wien bʋ. ");
INSERT INTO ktj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","‑Ɛ ‑bɩ ‑Yusu 'bɛti 'a 'baɩ nɩ, ɛ wɛn: «‑Tɛ ɛ ‑tʋa la 'lɩ 'a nunuo, ti nɩ ‑tie ɛ ‑hi 'ʋ 'lɩ?» ‑Ɛ ‑bɩ 'a 'baɩ wɛn: «Kʋɛ 'lɩ 'a 'hɩandɛ 'yie bʋ. ");
INSERT INTO ktj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ɛ kɔ ti, 'ku ‑hʋan a 'mʋ, 'ɛ pɩ 'lɩ꞊ɩ 'tɔ, kɔ 'kɩ 'lɩ 'nie ‑mɔ, ɛ 'mʋ꞊ʋ 'la a ‑tɩ. Yru ‑aan nyaɩ, ‑bʋ ‑hɛɛ nɛ ‑a mʋ, ꞊nɩ ‑wɛ 'lɩ꞊ɩ 'lɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","‑Ɛ ‑bɩ ‑Yusu wɛn: «‑Wɛn 'nɩ: ꞊Nɩ ‑wɛ 'lɩ꞊ɩ 'lɩ. 'A ‑nɛ ꞊dedede ‑wɛ 'lɩ bʋ nue nɩ, 'kɩ 'ʋ nyiblo ‑mʋ' ‑mɔ, ‑ɛ kuo Nyɩsʋa ꞊wlʋ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ 'yu a 'mʋ, 'a 'baɩ wɛn: «Iin, 'n ‑hʋɛ ꞊bʋ kuo ꞊nɛ ꞊wlʋ yɩ, kɛɛ, ‑hɛɛ 'mʋ, 'kɩ ꞊bʋ kuo ꞊nɛ ꞊wlʋ yɩ ‑tɛɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","‑Ɛ ‑bɩ ‑Yusu 'ye꞊e nɩ, ‑ɛ mɔ, nyibli yɩ bii klɛ dɩakɩ, 'ɛ hlee 'lɩ 'ku ‑hʋan a 'mʋ ‑mɔ, 'kɩ 'lɩ win 'yaklɩ 'kwli, ɛ wɛn: «'Ku ‑hʋan, ‑mɔ ‑mʋ', ‑ɛ ni꞊e, 'yu ‑bʋ 'ɛ 'ke, kɔ, 'ɛ 'yɛ nɩ 'plɛ, 'n yɩ ‑mʋ 'nɩ ‑lee ‑nɩ, ‑hɔn 'ʋ꞊ʋ ke', ꞊nɩ 'bie 'ʋ꞊ʋ ke' de!» ");
INSERT INTO ktj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","‑Yusu bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ 'ku ‑hʋan a 'mʋ, ɛ ‑tʋa 'a blɛbʋblalɛ. Ɛ nɩ 'lɩ 'a blɛbʋblalɛ 'kwli, 'ɛ ‑hɔn 'ʋ꞊ʋ ke'. ‑Tɛ ɛ ‑hɔn 'ʋ꞊ʋ ke', ‑ɛ ‑bɩ 'yu a 'mʋ, ɛ pɛ 'ʋ bʋ gbee, ɛ 'wɩ ‑tɛ bʋ 'yɛ nɩ 'kʋ wɛn. Ɛ nɔ‑ nu꞊o, nyibli ‑hʋɔhʋɩ a 'mʋ, ‑ʋ nɩ ‑tuo a 'mʋ kɩ, 'ʋ pɩ lɛ: «Ɛ 'kʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kɛɛ ‑ɛ ‑bɩ ‑Yusu klɔ 'a dabʋ bʋ, ɛ 'du꞊o ye', 'yu a 'mʋ 'ɛ nyra bʋ. ‑Ɛ ‑bɩ nyibli pʋ꞊ʋ ꞊haan‑tɩ, ‑ɛ mɔ, ‑Yusu nu꞊o nɩ, 'yu a 'mʋ, 'a 'kʋɛ 'ɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ 'hʋɛn‑, ʋ mu 'lɩ 'kayu bʋ. ‑Tɛ ʋ nɩ ‑do, ʋ nɩ 'kɩ 'ʋ bʋ, ‑ɛ ‑bɩ ʋ 'bɛti ‑Yusu nɩ, ʋ wɛn: «Dɛ‑ ‑nu 'kɩ꞊ɩ, ꞊a 'yɩ wɛn 'lɩ꞊ɩ 'lɩ ‑wɛ, ‑ba bla wɛn 'ku ‑hʋan a 'mʋ lɛ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «Nyɩsʋa a dɩda nɩ ‑do, ɛ nɔ‑ ni꞊e, 'tɩ‑ nyiblo 'ɛ ‑wɛ 'lɩ bʋ bla 'kuo‑hʋɩndʋ a 'mʋ lɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ ‑hɔn 'ʋ ‑tɛ a 'mʋ nɩ, 'ʋ ‑mu, 'ʋ 'bɛɛ 'lɩ Galileblʋgba 'kwli ꞊tɩɔ. Ɛ 'yɩ꞊ɩ ‑hʋa, 'kɩ nyibli ꞊dʋ bʋ 'ye꞊e, ");
INSERT INTO ktj_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","‑ɛ di꞊e nu, ɛ 'mʋ ti kɔ, ɛ 'mʋ 'a ‑nagbopʋ ‑tɔɔ ‑nɩ. ‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ: «'Mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, ʋ kɔ bʋ pʋ 'mʋ nyibli ‑jɩ', ʋ 'mʋ 'mʋ 'la. Kɛɛ, 'bʋ mɔ, 'nɩ 'kʋ, ‑nyrɔwɩ nɩ 'hʋɛn‑ 'bʋ ‑hi, ta a ‑nyrɔwɔ, 'n kɔ ꞊bʋ ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ, ꞊bʋ 'hrɩ 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","‑Tɩ a 'mʋ ‑Yusu ‑hla, 'a ‑nagbopʋ 'yɩ꞊ɩ lɛ ‑yru. Kɛɛ ʋ yɩ pie hʋannʋ, 'kɩ bʋ 'bɛti꞊e, dɛ a 'dɩ ‑bɩ ɛ ꞊hɛn 'nyrɛ. ");
INSERT INTO ktj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ʋ nyre 'lɩ Kapɛnaɔdɩɔ 'kwli nɩ, 'ʋ mu 'lɩ 'kayu bʋ. ‑Tɛ ʋ nyre 'kɩ 'lɩ 'kayu bʋ, ‑ɛ ‑bɩ ɛ yɩ 'a ‑nagbopʋ* 'nɩ 'bɛti ‑nɩ, ɛ wɛn: «‑Tɩ a 'dɩ ‑bɩ a hlɛ wɛn 'lɩ 'hru wlɔn 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","‑Ɛ ‑bɩ 'waa pɛpɛ, ʋ nu ꞊blii, ‑tʋɩ a ‑tɩ, ‑ɛ nu꞊o, 'kɩ 'ʋ 'hru wlɔn, ʋ pɩpɩ wɛn꞊ɛ' lɛ, 'kɩ 'lɩ 'waa dɩɔnʋ 'nyɩ, nyiblo a 'dɩ ‑bɩ ‑nɩ 'ʋ 'a 'bio 'lu yɩ. ");
INSERT INTO ktj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","‑Ɛ ‑bɩ ‑Yusu nɩ bʋ, 'ɛ da ꞊nʋ, ɛ wɛn: «Nyiblo 'bʋ yɩ꞊ɩ nɩ ‑hʋɛ, bʋ nɩ 'ʋ 'a 'bio 'lu yɩ, bʋ ꞊tɩɔ 'lɩ 'a dɩɔnʋ, ɛ 'mʋ 'a 'bio a lɛleyu' pa.» ");
INSERT INTO ktj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","‑Ɛ ‑bɩ ɛ ‑jri 'lɩ 'hɩangbe, 'ɛ ꞊tu 'ʋ ꞊nʋ꞊ʋ ye' bʋ, 'ɛ 'ble꞊e kʋa, 'ɛ ꞊jri꞊e dabʋɩ 'lu bʋ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«'A ‑nɛ nyiblo 'bʋ nɩ 'ʋ, ‑tɛ 'hɩangbe ‑bʋ, ɛ nɩ 'mʋ, 'bʋ 'ble 'a nyiblo kʋa, 'kɩ 'ʋ 'na 'nyrɛ a ‑ta', ‑ɛ ‑bɩ 'mɔ ɛ 'ble kʋa. Kɔ, nyiblo 'bʋ nɩ 'ʋ, 'bʋ 'ble 'mʋ kʋa, ɛ 'yɩ 'mɔ nɩ ‑do 'pa‑, ɛ 'yɩ 'mʋ kʋa 'ble, kɛɛ, ɛ 'ble 'na 'Baɩ Nyɩsʋa kʋa ‑wɛ, ‑ɛ lee 'nɛ‑ 'mʋ ‑tʋtʋ kɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","‑Ɛ ‑bɩ Saan, ‑ɛ mɔ ‑Yusu a ‑nagbopi* ‑bɩ, ɛ wɛn: «Tɔɔnyɔ, ‑a 'ye nyiblo ꞊dʋ, 'ɛ blɛ 'kuo ‑hʋɩn* lɛ, 'kɩ 'lɩ ‑na 'nyrɛ 'kwli. ‑Aan 'mumu, ‑a lee ꞊nɛ nɩ, bʋ 'kee nɛ 'a nunuo, ‑ɛ nu꞊o, ɛ 'nɩ ‑kʋɛ꞊ɛ lɩ ‑a mʋ wien lɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","‑Ɛ ‑bɩ ‑Yusu wɛn: «A 'nɩ 'lee 'lɩ꞊ɩ, ‑ɛ mɔ, bʋ 'kee nɛ 'a nunuo, ‑ɛ nu꞊o, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, nyiblo ꞊dʋ bʋ gba 'na 'nyrɛ, bʋ nu ꞊wlɩlɛkɛɛdɛ, 'tɩ‑ bʋ ‑hɔn 'ʋ ‑wlu, bʋ nyre 'na 'nyrɛ yɩ. ");
INSERT INTO ktj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nyiblo 'bʋ 'yɛ nɩ ‑wɔn ‑a mʋ yɩ, ɛ ꞊hɛn 'nyrɛ, ɛ kɔ ‑a mʋ 'hʋɛn‑ ‑a pɛ. ");
INSERT INTO ktj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kɔ, nyiblo 'bʋ ‑nyi 'a mʋ 'nɩpɔlʋ nɩ ‑do, ‑tɛ a mɔ 'na nyibli a ‑tɩ, 'n yɩ 'a mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ, ‑ɛ mɔ, Nyɩsʋa, nɔ‑ di꞊e 'wio ‑nyi.» ");
INSERT INTO ktj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ de, ɛ wɛn: «Nyiblo ‑mʋ', ‑ɛ kuo 'mʋ ꞊wlʋ yɩ, ‑ɛ 'wɩ‑ 'hɩangbedʋ ‑bʋ yɩ, 'bʋ mɔ, nyiblo 'bʋ nu꞊o, nyiblodʋ a 'mʋ, bʋ 'kee 'na ꞊wlʋ a yɩkuolɛ, ɛ di nɔɔ 'ʋ lɛ, 'kɩ 'ʋ nyiblo a 'mʋ, ‑ɛ nu dɛ a 'mʋ ‑mɔ, bʋ pʋ꞊ʋ gbɛtɛɛ a 'hɩɔ lɔ, 'tɩ‑ bʋ pʋ 'lɩ꞊ɩ 'yru ‑mɔ, ɛ 'mʋ 'kʋ. ");
INSERT INTO ktj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","'Bʋ mɔ, ‑na dabʋ 'bʋ yɩ꞊ɩ nɩ ni, ꞊nɩ yɩ dɛ 'kuku nɩ ni, ‑ɛ ‑bɩ 'bɛ 'ʋ꞊ʋ. Ɛ nu ‑tɛɛ, 'kɩ ‑bʋ pa 'lɩ dabʋkʋtɩɔ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ 'kwli, 'ɛ ‑hi 'ʋ ‑na dabʋɩ nɩ 'hʋɛn bʋ ꞊cɛɛ 'ʋ yɩ, 'tɩ‑ ‑bʋ mu 'lɩ na ‑mʋ' 'nyɩ, ‑ɛ 'yɛ nɩ jre 'klɔ ‑mɔ 'klɔ.  ");
INSERT INTO ktj_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","'Kɩ 'lɩ ‑tɩtɛ a 'mʋ, nyɩ ‑mʋ', ‑ʋ yɩ 'hʋɩ di, ʋ 'nɩ 'kʋ꞊ʋ lɩ, ɛ kɔ, na 'nɩ ‑jre꞊e lɩ ‑wɛ, 'klɔ ‑mɔ 'klɔ. ");
INSERT INTO ktj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","'Bʋ mɔ, ‑na bʋ 'bʋ yɩ꞊ɩ nɩ ni, ꞊nɩ yɩ dɛ 'kuku nɩ ni, ‑ɛ ‑bɩ 'bɛ 'ʋ꞊ʋ. Ɛ nu ‑tɛɛ, 'kɩ ‑bʋ paa 'lɩ bʋkʋtɩɔ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ 'kwli, 'ɛ ‑hi 'ʋ ‑na bʋɩ nɩ 'hʋɛn bʋ ꞊cɛɛ 'ʋ yɩ, 'tɩ‑ bʋ pʋ 'lɩ ‑mʋ na ‑mʋ' 'nyɩ, ‑ɛ 'yɛ nɩ jre 'klɔ ‑mɔ 'klɔ.  ");
INSERT INTO ktj_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","'Kɩ 'lɩ ‑tɩtɛ a 'mʋ, nyɩ ‑mʋ', ‑ʋ yɩ 'hʋɩ di, ʋ 'nɩ 'kʋ꞊ʋ lɩ, ɛ kɔ, na 'nɩ ‑jre꞊e lɩ ‑wɛ, 'klɔ ‑mɔ 'klɔ. ");
INSERT INTO ktj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","'Bʋ mɔ, ‑na 'yie 'bʋ yɩ꞊ɩ nɩ ni, ꞊nɩ yɩ dɛ 'kuku nɩ ni, ‑ɛ ‑bɩ ‑ha 'lɩ꞊ɩ 'lɩ. Ɛ nu ‑tɛɛ, 'kɩ ‑bʋ paa 'lɩ 'yie nɩ ‑do Nyɩsʋa a bʋnɩɩlɛ', 'ɛ ‑hi 'ʋ ‑na 'yii nɩ 'hʋɛn, bʋ ꞊cɛɛ 'ʋ yɩ, 'tɩ‑ bʋ pʋ 'lɩ ‑mʋ na ‑mʋ' 'nyɩ, ‑ɛ 'yɛ nɩ jre 'klɔ ‑mɔ 'klɔ. ");
INSERT INTO ktj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","'Kɩ 'lɩ ‑tɩtɛ a 'mʋ, nyɩ ‑mʋ', ‑ʋ yɩ 'hʋɩ di, ʋ 'nɩ 'kʋ꞊ʋ lɩ, ɛ kɔ, na 'nɩ ‑jre꞊e lɩ ‑wɛ 'klɔ ‑mɔ 'klɔ. ");
INSERT INTO ktj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","'A ‑nɛ nyiblo, 'bʋ nɩ 'ʋ, 'bʋ yɩ 'mʋ ꞊wien lɛ nɩ kʋɛ, ɛ kɔ bʋ ‑ha Nyɩsʋa mɛ lɛ, bʋ klaa ꞊nɛ 'yi, ‑ɛ di꞊e nu, 'a nunuklɔ 'nɩ ꞊ha yɩ nyre, ꞊wɩ yɩ, ‑tɛ ʋ ni, 'bʋ pʋ mʋma 'ta, 'ʋ pɩ꞊ɩ na', ‑ɛ di꞊e nu, ɛ 'nɩ ꞊ha yɩ nyre. ");
INSERT INTO ktj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","꞊Bʋ pʋʋ ꞊nɛ 'ta a dɛ yɩ de. 'Ta mɔ ꞊haandɛ ꞊nɩɔ. Kɛɛ, 'bʋ mɔ, 'bʋ 'waan nɛ 'a wlɔnnɩnɔ, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nu꞊o, bʋ nɔ 'kɩ wlɔn de. ‑Ɛ ‑bɩ ɛ 'yɩ 'kɩ ‑kʋan ꞊dʋ ‑kɔ de. A 'nɩ 'wɩɩ 'lɩ 'tadʋ ‑mʋ' yɩ, ‑ɛ 'waan nɛ 'a wlɔnnɩnɔ, kɛɛ, a kɔ 'aan 'bio 'hʋɛn‑, ba kɔ kɩbʋwɛɛnlɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","‑Nyrɔwɩ gbi bʋ ‑hi, ‑ɛ ‑bɩ ‑Yusu ‑hɔn 'lɩ Kapɛnaɔdɩɔ 'kwli nɩ, ɛ kɔ 'a ‑nagbopʋ* 'hʋɛn‑, 'ʋ mu 'lɩ Sudeblʋgba 'kwli, 'kɩ 'lɩ Sudɛn a 'nikɩ. 'Kɩ 'lɩ ‑tɛ a 'mʋ, nyibli ‑hʋɔhʋɩ, nʋ‑ ‑wɛ 'lɩ ti kɩ de, 'ʋ ꞊glaa 'lɩ꞊ɩ lɛ, ‑ɛ ‑bɩ ɛ ‑tʋa 'waa Nyɩsʋa a ‑tɩ a tɔɔlɛ, ꞊wɩ yɩ, ‑tɛ ‑mʋ', ɛ ni꞊e lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","‑Ɛ ‑bɩ Falisi꞊tumu* a nyibli, nʋ‑ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, ʋ 'mʋ꞊ʋ lɛ ꞊tɛɛ ‑nɩ, ‑ɛ di꞊e nu, ɛ 'mʋ ka, 'kɩ 'ʋ Nyɩsʋa ye'. Kɛ‑ ʋ pɩ 'kɩ꞊ɩ yɩ, 'ʋ yɩ꞊ɩ 'bɛti ‑nɩ: «꞊Bɩ ɛ kɔ 'ʋ nɩ, ‑tɛ ‑aan tete ni 'a hɩhla, 'kɩ nyɩbɛyu bʋ pʋ 'lɩ 'a nʋgba ‑patʋ'?» ");
INSERT INTO ktj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «Tete a 'dɩ ‑bɩ Moise ‑nyi la 'a mʋ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","‑Ɛ ‑bɩ ʋ wɛn: «Nyɩsʋa a winwlɔn‑hanyɔ* Moise hla꞊a nɩ, ‑ɛ mɔ, nyɩbɛyugbe 'bʋ ‑hʋɛ bʋ pʋ 'lɩ 'a nʋgba ‑patʋ', ‑ɛ ‑bɩ bʋ 'crɩ 'crɩɛn, ‑ɛ hlɛ꞊ɛ, ‑ɛ mɔ, ɛ pʋ 'lɩ꞊ɩ ‑patʋ', 'tɩ‑, bʋ ‑nyi꞊e 'crɩɛn a 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","‑Ɛ ‑bɩ ‑Yusu wɛn: «'Aan ꞊wlɩ a 'gboklolɛ a ‑tɩ, Moise 'ɛ ‑nyi 'a mʋ tetedʋ a 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kɛ‑ ɛ pɩ ꞊nʋ yɩ de, ɛ wɛn: «Yɩ‑hɛ‑nyrɛ, ‑tɛ Nyɩsʋa nu la 'klɔ, ɛ nu ‑tonyiblo, ‑tonyiblo a 'mʋ, 'ɛ mɔ nyɩbɛyugbe kɔ nʋgba 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ɛ nɔ‑ kɔ ‑tɩ, nyɩbɛyu 'mʋ 'ʋ 'a 'baɩ kɔ 'a 'dii 'hʋɛn‑ bʋ hie, ɛ 'mʋ nʋgba kɔ, ɛ kɔ 'a nʋgba a 'mʋ 'hʋɛn‑, ʋ 'mʋ 'hʋɩ bʋ ‑nɩnɩ ‑nɩ, ");
INSERT INTO ktj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ʋ nɩ 'hʋɛn a 'mʋ, ʋ 'mʋ ‑tonyiblogblo nɩ ‑do ‑hɛ. Ɛ ꞊hɛn 'nyrɛ, ‑ɛ mɔ, ʋ 'yɩ 'kɩ ‑tonyibli nɩ 'hʋɛn 'pa‑, kɛɛ, ʋ mɔ ‑tonyiblo nɩ ‑do ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","'A ‑tɩ o, nyɩbɛyugbe kɔ 'a nʋgba 'hʋɛn‑, Nyɩsʋa ‑nu, 'ʋ ‑hɛ ‑tonyiblo nɩ ‑do, nyiblo ꞊dʋ 'yɩ yɩ ‑blɛɛ ‑nɩ, bʋ ‑hɩhɩa ꞊nʋ yrɛ.» Kɛ‑ ‑Yusu ‑pʋ ꞊nʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","‑Tɛ ʋ ‑hɩhɩɛ yrɛ, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ 'hʋɛn‑, ʋ mu 'lɩ 'kayu bʋ. ‑Ɛ ‑bɩ 'a ‑nagbopʋ a 'mʋ, ʋ yɩ 'bɛti꞊e lɛ de, nyɩbɛyu kɔ 'a nʋgba bʋ ‑gba 'blɩ lɛ a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","‑Ɛ ‑bɩ ɛ wɛn: «Nyɩbɛyugbe 'bʋ pʋ 'lɩ 'a nʋgba ‑patʋ', 'tɩ‑ 'bʋ kɔ nʋgba ‑bɩ, ‑ɛ ‑bɩ ɛ nu ‑wlawlɩ, 'kɩ 'ʋ 'a yɩ‑hɛnʋgba ye'. ");
INSERT INTO ktj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kɛ‑ ɛ nɩ 'mʋ, 'kɩ 'ʋ nʋgba ‑mɔ ‑wɛ. Nʋgba 'bʋ hie 'ʋ 'a nyɩbɩʋ bʋ, 'bʋ kɔ nyɩbɩʋ ‑bɩ, ‑ɛ ‑bɩ ɛ nu ‑wlawlɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ɛ kɔ la ‑nyrɔwɔ ꞊dʋ, 'ʋ gba ‑Yusu 'yonʋ yɩ, ‑ɛ di꞊e nu, ɛ 'mʋ ꞊nʋ lɛ ‑hrɛn, ɛ 'mʋ Nyɩsʋa da, Nyɩsʋa 'mʋ 'yonʋ a 'mʋ ꞊haandɛ ‑mɔ nu. Kɛɛ, ‑tɛ ‑nagbopʋ* 'ye dɛ a 'mʋ, ‑ɛ ‑bɩ ʋ ‑tʋa 'waa ‑mɔ'pʋplɛ, ʋ wɛn: «A 'nɩ 'haa 'lɩ꞊ɩ 'ku.» ");
INSERT INTO ktj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","‑Tɛ ‑Yusu 'ye dɛ a 'mʋ, 'a ‑nagbopʋ ‑nu, ‑ɛ ‑bɩ ɛ 'yɩ 'a plɔ ‑blee ‑nɩ, ɛ wɛn: «Ba ‑ha 'yonʋ mɛ lɛ, bʋ di 'nɛ‑ 'mʋ ‑mɔ. A 'nɩ 'kaa 'lɩ ꞊nʋ yɩ, ‑ɛ nu꞊o, nyibli ‑mʋ', ‑ʋ 'wɩ‑ 'yonʋ ‑bʋ yɩ, ʋ nʋ‑ di 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli pa. ");
INSERT INTO ktj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, nyiblo 'bʋ 'yɛ nɩ ‑ha Nyɩsʋa mɛ lɛ, 'bʋ 'yɛ nɩ kɔɔ ꞊nɛ win kɩ, ꞊wɩ yɩ, ‑tɛ 'hɩangbe ni, 'ɛ ‑hɛ 'a 'baɩ mɛ lɛ, 'a 'baɩ 'ɛ kʋɛ ꞊nɛ win kɩ, ‑ɛ ‑bɩ nyiblo a 'mʋ, ɛ 'yɩ 'lɩ꞊ɩ ‑wɛ, bʋ pa 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","‑Yusu bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ɛ ‑tʋa 'yonʋ a kʋalɛ'buble, 'ɛ pɩ ꞊nʋ dabʋɩ 'lu blɛ, 'tɩ‑ 'ɛ da Nyɩsʋa, 'kɩ bʋ nu ꞊nʋ ꞊haandɛ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","‑Tɛ ‑Yusu ‑wɛ ‑mɔ, 'kɩ bʋ bi 'hru wlɔn, ɛ kɔ nyiblo ꞊dʋ, 'ɛ ya꞊a cigbɛ yɩ, 'ɛ 'gbla kwlɩ, 'kɩ 'ʋ꞊ʋ ye', ɛ wɛn: «Tɔɔnyɔ o, ‑mɔ mɔ ꞊haannyiblo. Dɛ a 'dɩ ‑bɩ 'n di nu, 'tɩ‑ Nyɩsʋa a 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ 'mʋ꞊ʋ kɔ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","‑Ɛ ‑bɩ ‑Yusu wɛn: «Dɛ‑ kɔ 'mɔ ‑dɛɛ ꞊haannyiblo 'lɩ? Nyiblo ꞊dʋ 'yɩ ꞊haannyiblo 'pa‑, 'bʋ 'yɩ Nyɩsʋa nɩ ‑do. ");
INSERT INTO ktj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","‑Yi Nyɩsʋa a tete nɩ, ‑ʋ mɔ: ꞊Nɩ 'laa 'lɩ nyiblo, ꞊nɩ 'nuo 'lɩ ‑wlawlɩ, ꞊nɩ 'yrie 'lɩ, ꞊nɩ 'pʋʋ 'lɩ nyiblo hɩ kɩ, ꞊nɩ 'kaa 'lɩ nyiblo, ꞊tuu 'ʋ ‑na 'baɩ kɔ ‑na 'dii 'hʋɛn‑, 'kɩ 'lɩ nʋɛlɛ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","‑Ɛ ‑bɩ ɛ ꞊tu ‑Yusu ꞊wɔn, ɛ wɛn: «Tɔɔnyɔ o, kʋɛ 'lɩ 'na 'hɩandɛ 'yie bʋ, ‑bʋ yɛ ‑nyrɔwɔ ‑bʋ kɩ, tete a pɛpɛ a 'mʋ, 'n ꞊tuu 'ʋ꞊ʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ‑Yusu ta 'lɩ꞊ɩ 'yi lɛ, 'kɩ 'lɩ nʋɛlɛ 'kwli, 'ɛ lee ꞊nɛ, ɛ wɛn: «Ɛ hie 'ʋ ‑mʋ dɛ nɩ ‑do. Ɛ nɔ‑ mɔ, mu ‑bʋ plo ‑na kʋkɔ‑tɛblɩ a pɛpɛ ‑mʋ', ‑kɔ, ‑bʋ ‑nyi 'a 'wliyɛ ꞊hɩʋɛnnyibli, Nyɩsʋa 'mʋ ‑mʋ ꞊haandɛ gbagbʋ ‑mɔ nu, 'kɩ 'lɩ yakɔ 'kwli. ꞊Nɩ nu 'kɩ꞊ɩ, ‑ɛ ‑bɩ kʋɛ 'mʋ ꞊wien lɛ, ꞊mʋ 'na ‑nagbopi* ‑hɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Bʋ 'wɩn 'kɩ ‑tɩ a 'mʋ, ‑Yusu ‑hla, ‑ɛ ‑bɩ 'a ꞊wlʋ bi ꞊hlɔn, 'ɛ ‑hɔn 'ʋ꞊ʋ 'hʋɩ, 'kɩ 'lɩ 'kla‑wliye'yɩya 'kwli, ‑ɛ nu꞊o, 'a kʋkɔ‑tɛblɩ ‑hʋ nɩ dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","‑Tɛ ɛ ‑mu 'kɩ, ‑ɛ ‑bɩ ‑Yusu naa nɛ 'a ‑nagbopʋ 'yie kɩ, ɛ wɛn: «Ɛ di 'mʋ 'nɩ kla, 'kɩ dɛkɔnyɔ bʋ di 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli pa.» ");
INSERT INTO ktj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","‑Yusu a win a 'mʋ, ɛ kɛɛ nɛ 'a ‑nagbopʋ a ꞊wlɩ lɛ. Kɛ‑ ɛ pɩ ꞊nʋ yɩ de, ɛ wɛn: «'Na 'yonʋ ‑na, dɛkɔnyʋ ‑mʋ', ‑ʋ kuo 'waa kʋkɔ‑tɛblɩ ꞊wlʋ yɩ, ɛ kla 'mʋ nɩ, 'kɩ bʋ pa 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","'Ɛ mɔ ꞊han‑tɩ, ɛ kla 'mʋ nɩ, 'kɩ 'ʋ dɛkɔnyɔ ‑mɔ', ‑ɛ kuo nɛ 'a kʋkɔ‑tɛblɩ ꞊wlʋ yɩ, bʋ kuo Nyɩsʋa ꞊wlʋ yɩ, kɔ, bʋ pa 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli, 'ɛ ‑hi 'ʋ ꞊gbukɩ‑so* bʋ naa 'ʋ 'die a 'hʋɔ 'yri.» ");
INSERT INTO ktj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","‑Yusu a pʋpʋwin a 'mʋ, ɛ maa nɛ 'a ‑nagbopʋ wlɔn lɛ dɩakɩ. ‑Ɛ ‑bɩ ʋ wɛn: «'Bʋ kɔ bʋ nɩ 'mʋ lɛ, ‑ɛ ‑bɩ nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ pa 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","‑Yusu bʋ 'ye ꞊nʋ de, ‑ɛ ‑bɩ ɛ wɛn: «'Kɩ 'lɩ ‑tonyiblo a dɩɔnʋ a 'klɩ 'kwli, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ kuo Nyɩsʋa ꞊wlʋ yɩ, 'tɩ‑ bʋ pa 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli. Kɛɛ, 'kɩ 'lɩ Nyɩsʋa a 'klɩ 'kwli, 'a ‑nɛ ꞊dedede ‑wɛ 'lɩ nuelɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","‑Ɛ ‑bɩ kɛ‑ Piɛlɩ pɩ ‑Yusu yɩ, ɛ wɛn: «‑A mʋ ‑bɩ ‑bʋ 'lɩ? 'Ye kɛ, ‑a ‑hie 'ʋ ‑aan nyibli bʋ, ɛ kɔ ‑aan ‑tɛblɩ a pɛpɛ 'hʋɛn‑, ꞊a yɩ ‑mʋ ꞊wien lɛ kʋɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","‑Ɛ ‑bɩ ‑Yusu wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, nyiblo 'bʋ nɩ 'ʋ, 'bʋ hie 'ʋ 'a 'kayu, kɔ 'a 'dɩayɩnʋ, kɔ 'a 'dii, kɔ 'a 'baɩ, kɔ 'a 'yonʋ, kɔ 'a ‑cii 'hʋɛn‑ bʋ, 'na nʋɛlɛ a ‑tɩ, kɔ, ɛ 'mʋ 'na ꞊haantitie nyibli pʋ a ‑tɩ, ");
INSERT INTO ktj_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","‑ɛ ‑bɩ nyiblo a 'mʋ, 'klɔ ‑bʋ, ɛ nɩ 'nɛ‑ ‑mɔ, ‑tɛblɩ, Nyɩsʋa di꞊e ‑nyi, ɛ di 'nɩ ‑hʋ, ɛ mʋ 'ʋ ‑tɛblɩ ‑mʋ', ɛ hie 'ʋ bʋ 'ʋ ‑hi, ‑ɛ mɔ 'kɩ 'kayo, 'dɩayɩnʋ, 'diinʋ, 'yonʋ, kɔ ‑cii 'hʋɛn‑, kɛɛ, ʋ di ꞊tu꞊o ꞊hɩʋɛn ‑wɛ. 'Ya 'ʋ 'lu de, ti ‑kɔ 'yri Nyɩsʋa di 'ʋ 'klɔ yrayrʋ ‑bɩ 'ʋ ‑nuu ‑nɩ, nyiblo a 'mʋ, Nyɩsʋa di ‑nyi꞊e 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kɛɛ, nyibli ‑mʋ', ‑ʋ nɩ 'ʋ 'waa 'bio 'lu yɩ, 'kɩ 'lɩ ‑tɛ ti nɛ ‑bʋ 'kwli, 'waa ‑hʋɔhʋɩ, ʋ nʋ‑ di 'lɩ 'waa 'bio bʋ nɩ, ‑nyrɔwɔ ꞊dʋ, ɛ kɔ, nyibli ‑mʋ', ‑ʋ nɩ 'lɩ 'waa 'bio bʋ, 'kɩ 'lɩ ‑tɛ ti nɛ bʋ 'kwli, 'waa ‑hʋɔhʋɩ 'mʋ 'ʋ 'waa 'bio 'lu yɩ nɩ, ‑nyrɔwɔ ꞊dʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","'Hru ‑mʋ', ‑ɛ mi Jrusrɛdɩɔ 'kwli, ɛ nɔ‑ kɔ wlɔn ʋ nɩ 'ʋ, 'ʋ mi 'kɩ. ‑Yusu, ɛ nɔ‑ 'nyɛɛ 'hru, 'a ‑nagbopʋ* 'ʋ nɩ 'ʋ꞊ʋ ke', hʋannʋ 'ɛ ni ꞊nʋ dɩakɩ. Ti nɩ ‑do a ti 'yri, ‑Yusu 'ɛ 'du 'a ‑nagbopʋ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn ye', 'ʋ bii yɩ. Bʋ bii 'kɩ yɩ, ‑ɛ ‑bɩ ɛ ‑tʋa 'lɩ 'waa ‑mɔhleelɛ, 'kɩ 'ʋ ‑tɛblɩ a pɛpɛ ‑mʋ', ‑ɛ di꞊e yrɛ mu a ‑ta', ");
INSERT INTO ktj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ɛ wɛn: «Ba pʋ 'mʋ nʋa yɩ bʋ. Jrusrɛdɩɔ, ‑a mi 'kwli. 'Mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'kɩ ʋ di 'lɩ 'mʋ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ ‑jɩ' pʋ, kɔ tetetɔɔnyʋ 'hʋɛn‑, ʋ 'mʋ 'mʋ ‑bati lɛ ‑pʋʋ ‑nɩ, ʋ 'mʋ lɛ pʋ, 'n blɛɛ 'kʋkʋʋ yɩ. 'Bʋ ‑hi, 'tɩ‑ ʋ 'mʋ 'mʋ nyibli ‑mʋ', ‑ʋ 'yɩ Nyɩsʋa ‑yi ‑jɩ' pʋ, ");
INSERT INTO ktj_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","nyibli a 'mʋ, ʋ 'mʋ 'mʋ 'caa ‑nɩ, ʋ 'mʋ 'mʋ hɩʋn 'hrin, kɔ, ʋ 'mʋ 'mʋ lɔkɔ ‑bii ‑nɩ, 'tɩ‑ ʋ 'mʋ 'mʋ 'la. ‑Nyrɔwɩ nɩ 'hʋɛn 'bʋ ‑hi, ta a ‑nyrɔwɔ, 'tɩ‑ 'mʋ 'lɩ 'kʋkʋnyibli 'nyɩ ‑hɔn, 'mʋ 'klɔ 'hrɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu a ‑nagbopʋ* nɩ 'hʋɛn ‑bɩ, ‑ʋ mɔ Sakɩ kɔ Saan 'hʋɛn‑, ‑ʋ mɔ Sebede a 'yonʋ, ʋ nʋ‑ mu 'ʋ ‑Yusu 'hʋɩ, ʋ wɛn: «Tɔɔnyɔ o, dɛ ‑bʋ, ‑a di ‑mʋ ‑hʋa, ‑a ‑hʋɛ꞊ɛ nɩ, ‑bʋ nu꞊o, 'kɩ 'ʋ ‑a mʋ ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","‑Ɛ ‑bɩ ‑Yusu wɛn: «Dɛ a 'dɩ ‑bɩ a ‑hʋɛ ꞊bʋ nu 'kɩ 'ʋ 'a mʋ ‑mɔ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","‑Ɛ ‑bɩ ʋ wɛn: «Ti ‑mʋ', ‑ɛ kɔ 'yri nyibli a pɛpɛ di 'ʋ꞊ʋ 'yee ‑nɩ, ‑ɛ mɔ, ‑kɔɔ nyibli a pɛpɛ win kɩ, 'kɩ 'lɩ Nyɩsʋa a bʋnɩɩlɛ', ‑a ‑hʋɛ꞊ɛ nɩ, ‑ba nɩ 'ʋ ‑mʋ 'hʋɩ bʋ, nyiblo nɩ ‑do 'kɩ 'lɩ ‑na diidɛkɩbɩa kɩ, ‑do ‑bɩ 'kɩ 'lɩ ‑na kamlakɩbɩa kɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ, ɛ wɛn: «Dɛ ‑bʋ, a ‑hʋɛ, dɛ bʋ di 'nyrɛ ꞊hɛn, a 'yɩ꞊ɩ ‑yi. ꞊Bɩ ꞊hɩʋɛndʋ ‑mʋ', 'n di 'ye, a ‑wɛ 'lɩ ba 'ye꞊e nɩ? Kɔ, ‑tɛ 'n di 'kʋkʋʋ nu, ꞊bɩ a ‑wɛ 'lɩ ba wɛn꞊ɛ kɩ nɩ, ba nu 'kʋkʋʋ lɛ nɩ ‑wɛ?» ");
INSERT INTO ktj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","‑Ɛ ‑bɩ ʋ wɛn: «‑A ‑wɛ 'lɩ꞊ɩ nɩ.» ‑Ɛ ‑bɩ ɛ wɛn: «Ɛ mɔ ꞊han‑tɩ, ꞊hɩʋɛndʋ a 'mʋ, 'n di 'ye, a 'mʋ꞊ʋ 'ye, kɔ, 'kʋkʋʋdʋ, 'n di 'kʋ, a 'mʋ 'kʋkʋʋ lɛ nu ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kɛɛ, nyiblo, ‑ɛ kɔ ‑bʋ nɩ 'na diidɛkɩbɩa kɩ bʋ, kɔ, nyiblo, ‑ɛ kɔ ‑bʋ nɩ 'na kamlakɩbɩa kɩ bʋ, ɛ 'yɩ 'mɔ 'pa‑, 'nɩ ‑wa꞊a lɩ꞊ɩ 'nyrɛ nɩ. Nyɩsʋa a ꞊gbɛtʋ, ɛ nɔ‑ di nyibli a 'mʋ 'nyrɛ wa.» ");
INSERT INTO ktj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","‑Tɛ ‑nagbopʋ nɩ ‑pu ‑bɩ ‑mʋ', ʋ 'wɩn ‑tɩ a 'mʋ, Sakɩ kɔ Saan 'hʋɛn‑, ʋ hla ‑Yusu yɩ, ‑ɛ ‑bɩ ʋ ‑tʋa 'waa yrʋ a lɛpʋʋlɛ. ");
INSERT INTO ktj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","‑Ɛ ‑bɩ ‑Yusu da 'waa pɛpɛ nɩ, ɛ wɛn: «A yi꞊e nɩ, ‑ɛ mɔ, 'klɔ ‑bʋ a 'luyɩnɩnyʋ, ‑ʋ nɛɛ 'waa dakɔ, ʋ ꞊tui ꞊nʋ ꞊hɩʋɛn, 'ʋ 'plʋɛ ꞊nʋ. 'Waa 'kɩɩndɛ a 'mʋ, ʋ nii 'lɩ꞊ɩ 'crɛ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","'A mʋ ‑mɔ ‑bɩ, ɛ 'yɩ 'mʋ lɛ ‑nɩ, 'kɩ 'lɩ 'a mʋ 'nyɩ. Nyiblo 'bʋ yɩ꞊ɩ nɩ ‑hʋɛ, bʋ mɔ 'aan naanyɔ, nyiblo a 'mʋ, ɛ blɛɛ yɩ bʋ mɔ 'aan ‑hɛɛnyɔ. ");
INSERT INTO ktj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ɛ kɔ, 'kɩ 'lɩ 'a mʋ 'nyɩ, nyiblo 'bʋ ‑hʋɛ bʋ mɔ 'aan 'luyɩnɩnyɔ, nyiblo a 'mʋ, ɛ blɛɛ yɩ bʋ ‑wɛ ‑mɔ, 'kɩ bʋ ‑hɛɛ nɛ 'aan pɛpɛ. ");
INSERT INTO ktj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","'Na 'mumu ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n 'yɩ ‑di, 'kɩ nyibli bʋ ‑hɛɛ 'mʋ, kɛɛ, 'n di nɩ, 'kɩ ꞊bʋ ‑hɛɛ nyibli, ɛ kɔ, ꞊bʋ ‑ha 'na dɩɔnʋ, 'mʋ 'kʋ, ‑ɛ di꞊e nu, 'na 'kʋkʋʋ a 'mʋ, ɛ 'mʋ꞊ʋ nu, Nyɩsʋa 'mʋ nyibli ‑hʋɔhʋɩ ꞊gblɛ, 'kɩ 'ʋ 'waa dɛ 'kuku ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ nyre 'lɩ 'dɩɔ ‑mʋ', ‑ɛ mɔ Seliko 'kwli nɩ. ‑Tɛ ʋ yɩ 'dɩɔ a 'mʋ 'kwli nɩ ꞊tɩ, ʋ kɔ nyibli ‑hʋɔhʋɩ 'hʋɛn‑, ‑ɛ ‑bɩ 'kɩ 'ʋ 'hrunyɩa 'yri, 'kɩ 'yii'dɔnyɔ ꞊dʋ nɩ 'ʋ bʋ, 'ɛ ‑hʋɛ nyibli 'wli lɛ, ‑ɛ di꞊e nu, ɛ 'mʋ dɛ di. 'Yii'dɔnyɔ a 'mʋ, 'a 'nyrɛ mɔ Batime. 'A 'baɩ a 'nyrɛ mɔ Time. ");
INSERT INTO ktj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","‑Tɛ ɛ 'wɩn, ‑ɛ mɔ, Nasalɛtɩ a ‑Yusu, ɛ nɔ‑ yɩ ‑hi, ‑ɛ ‑bɩ ɛ ‑tʋa 'lɩ win a 'lɩ'yaalɛ, ɛ wɛn: «‑Yusu o, Dafidɩ a 'Yu, yru 'na nyaɩ mɔ!» ");
INSERT INTO ktj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, 'ʋ ‑tʋa 'a ‑mɔ'pʋplɛ, ʋ wɛn: «Ma wien mɔ!» Kɛɛ, ɛ hɩa nɩ, 'ɛ 'yaa 'lɩ win dɩakɩ de, ɛ wɛn: «‑Yusu o, Dafidɩ a 'Yu, yru 'na nyaɩ mɔ!» ");
INSERT INTO ktj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","‑Tɛ ‑Yusu 'wɩn 'a win, ‑ɛ ‑bɩ ɛ nyra bʋ, ɛ wɛn: «Ba da꞊a, bʋ 'de,» 'ʋ da꞊a, ʋ wɛn: «‑Mɔ ɛ dɛ. Pʋ 'lɩ 'klɩ lɛ, ‑bʋ 'du ye', ‑bʋ mu 'ʋ꞊ʋ 'hʋɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","‑Ɛ ‑bɩ Batime a 'mʋ, ɛ ꞊hɩnhɩan 'ʋ 'a kʋɛtɩ bʋ, ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ ‑gbisa, ɛ nyra bʋ, 'ɛ mu 'ʋ ‑Yusu 'hʋɩ. ");
INSERT INTO ktj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","‑Tɛ ɛ nyre 'kɩ 'ʋ, ‑ɛ ‑bɩ ‑Yusu 'bɛti꞊e nɩ, ɛ wɛn: «Dɛ a 'dɩ ‑bɩ ‑hʋɛ ꞊bʋ nu, 'kɩ 'ʋ ‑mʋ ‑mɔ 'lɩ?» ‑Ɛ ‑bɩ ɛ wɛn: «Tɔɔnyɔ o, 'n ‑hʋɛ꞊ɛ nɩ, ‑bʋ nu꞊o, 'na 'yii ‑bʋ, ‑ɛ klɛ, bʋ klɛ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","‑Ɛ ‑bɩ ‑Yusu lee ꞊nɛ nɩ, ɛ wɛn: «‑Tɛ ‑kuo 'mʋ ꞊wlʋ yɩ, ɛ nɔ‑ nu꞊o, 'nɩ nu꞊o, ‑na 'yii 'ɛ klɛ yɩ. 'A ‑tɩ, ‑wɛ 'lɩ ‑bʋ mu 'lɩ 'kayu bʋ nɩ.» Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ ɛ ‑tʋa lɛyuyruo, 'ɛ bi 'ʋ ‑Yusu ke', 'ɛ ‑tʋa 'a ꞊wienlɛkʋkʋɛ. ");
INSERT INTO ktj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","‑Tɛ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ mi la Jrusrɛdɩɔ 'kwli, bʋ 'mʋɛ 'dɩɩ ‑bʋ, ‑ʋ mɔ Bɛtɩfase kɔ Betani 'hʋɛn‑ yrɛ, 'kɩ 'ʋ dʋgba ‑mʋ' ꞊hlɔn, ‑ɛ kɔ 'lu olifieti nɩ 'lɩ, ‑ɛ ‑bɩ ‑Yusu lee nɛ 'a ‑nagbopʋ nɩ 'hʋɛn ‑bɩ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «'Dɩɔ ‑mʋ', ‑ɛ nɩ 'lɩ 'a mʋ ye', ba mu 'lɩ꞊ɩ 'kwli. 'Bʋ mɔ, 'ba 'ya 'dɩɔ, a di yɛɛ 'ʋ 'kasrayu, ʋ mʋa ‑nɩ bʋ. Nyiblo ꞊dʋ 'yɩ ‑hʋan 'ʋ 'kasrayu a 'mʋ kɩ nɩ 'yɛ. 'Ba yɛ 'ʋ꞊ʋ bʋ, ba ꞊wlɛ꞊ɛ, ba ya 'mɔ꞊ɔ yɩ. ");
INSERT INTO ktj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","'Bʋ mɔ, nyiblo ꞊dʋ 'bʋ 'bɛti 'a mʋ, 'bʋ pʋ lɛ: Dɛ a 'dɩ ‑bɩ a ni 'lɩ? ‑ɛ ‑bɩ kɛ‑ ba pʋ꞊ʋ yɩ: Kʋkɔnyɔ, ɛ nɔ‑ ‑hʋɛ꞊ɛ. Ɛ di 'lɩ꞊ɩ 'nɩ ya, ‑tɛ ti nɛ ‑bʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","‑Tɛ ʋ ‑mu, ʋ 'ya 'dɩɔ a 'mʋ 'kwli, 'ɛ mɔ ꞊han‑tɩ, 'ʋ yɛɛ 'ʋ 'kasrayu a 'mʋ, ʋ mʋa bʋ, 'kɩ 'ʋ ꞊hʋan.yɩ, ‑nagbopʋ nɩ 'hʋɛn a 'mʋ, 'ʋ ꞊wlɛ꞊ɛ. 'Kɩ 'ʋ ꞊hʋan.yɩ a 'mʋ, 'kɩ nyibli ‑hʋɔhʋɩ nɛɛ 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","'Kɩ 'lɩ nyibli a 'mʋ 'nyɩ, 'kɩ ‑ʋ ‑bɩ nɩ 'lɩ, 'ʋ 'bɛti ꞊nʋ, ʋ wɛn: «Dɛ a 'dɩ ‑bɩ a ni 'lɩ? Dɛ‑ kɔ 'kasrayu ‑bʋ 'a ꞊wʋwlɛ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","‑nagbopʋ a 'mʋ 'ʋ lee ꞊nʋ ‑tɩ ‑bʋ, ‑Yusu lee wɛn ꞊nʋ, ‑ɛ ‑bɩ nyibli a 'mʋ, ʋ ‑ha ꞊nʋ mɛ lɛ, 'ʋ ‑mu, ");
INSERT INTO ktj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","'ʋ ya 'kasrayu a 'mʋ ‑Yusu yɩ. ‑Tɛ ʋ nyre 'lɩ, 'ʋ pʋ 'ʋ 'waa danɩ kɔ 'waa wlawlɩ 'kasrayu a 'mʋ kɩ blɛ, ‑ɛ di꞊e nu, ‑Yusu 'bʋ 'ya 'ʋ꞊ʋ kɩ, ɛ 'mʋ danɩ a 'mʋ kɩ bʋ nɩ. (‑Ɛ nu꞊o, ɛ tʋɛ ꞊nɛ nyibli yɩ, ‑ɛ mɔ, ɛ nɔ‑ mɔ bodɩɔ ‑mʋ', ‑ɛ 'yɛ nɩ ya 'lɩ tʋ, kɛɛ, ‑ɛ yɛ 'lɩ kɩbʋwɛɛnlɛ. Ɛ nɔ‑ kɔ ‑tɩ 'ɛ 'yɛ 'ʋ 'kasra a 'mʋ kɩ.) ");
INSERT INTO ktj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","‑Tɛ ʋ yɩ 'lɩ nɩ di, nyibli ‑hʋɔhʋɩ 'ʋ pʋ 'ʋ 'waa danɩ 'hru wlɔn blɛ. ‑Ʋ ‑bɩ nɩ 'ʋ, 'ʋ 'bɛ ‑hugbi, 'ʋ pʋ 'ʋ꞊ʋ 'hru wlɔn blɛ ‑wɛ, ‑Yusu 'ɛ nɛ꞊ɛ klɛ, ");
INSERT INTO ktj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","nyibli 'ʋ nɛ꞊ɛ ye' lɛ, ‑ʋ ‑bɩ 'ʋ yɩ꞊ɩ ꞊wien lɛ kʋɛ. Kɛ‑ ʋ ni, 'ʋ 'yɛɛ 'lɩ win, ʋ wɛn: «‑Na 'wio, ‑mɔ ‑bʋ, ‑ɛ yɩ 'lɩ di, 'kɩ 'lɩ Kʋkɔnyɔ Nyɩsʋa a 'nyrɛ 'kwli. Nyɩsʋa bʋ ‑nyi ‑mʋ ‑tɩ a 'yi'bʋalɛ! ");
INSERT INTO ktj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ba pʋ Nyɩsʋa 'nyrɛ lɛ, ‑ɛ nu꞊o, ɛ nɔ‑ di ‑a mʋ win kɩ kɔɔ mɔ, ‑tɛ ‑aan 'baɩ gbagbʋ bodɩɔ Dafidɩ nu la nyibli a win a kɩkɔɔlɛ. Nyɩsʋa bʋ kɔ ‑tɩ a 'yi'bʋalɛ, 'kɩ 'lɩ yakɔ 'kwli!» ");
INSERT INTO ktj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","‑Tɛ ‑Yusu 'ya 'kɩ Jrusrɛdɩɔ 'kwli, ‑ɛ ‑bɩ 'kɩ ɛ mu 'lɩ Nyɩsʋa a 'kagbaʋ bʋ, 'ɛ 'ye ‑tɛblɩ a pɛpɛ ‑mʋ', ‑ʋ nɩ 'lɩ. ‑Tɛ 'tɔ yɩ nɩ ‑wɛn, ‑ɛ ‑bɩ ɛ kɔ 'a ‑nagbopʋ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn a 'mʋ 'hʋɛn‑, ʋ ꞊hɩan ‑mɔ, 'ʋ mu 'lɩ Betanidɩɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","‑Tɛ ‑nyrɛ ‑nyɛ, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ ‑hʋɛn 'lɩ Betanidɩɔ 'kwli nɩ, 'ʋ mi. ‑Tɛ ʋ yɩ 'dɩɔ a 'mʋ 'kwli nɩ ꞊tɩ, ‑ɛ ‑bɩ 'kanʋ bi 'lɩ ‑Yusu 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bʋ ta 'lɩ ye' lɛ, ‑ɛ ‑bɩ ɛ 'ye tugbɛdʋ ‑mʋ', ʋ dɛɛ figie nɩ. Tugbɛ a 'mʋ, ɛ hlɔɔ ꞊nʋ ‑mɔ lɛ, hawi 'ɛ ‑hʋ 'lɩ꞊ɩ yra, ‑Yusu 'ɛ mu 'ʋ꞊ʋ ꞊hlɔn, ‑ɛ di꞊e nu, ɛ 'mʋ꞊ʋ 'ye, 'bʋ mɔ, 'bʋ tʋ 'kui. Bʋ nyre 'kɩ 'ʋ꞊ʋ ꞊hlɔn, ‑ɛ ‑bɩ hawi nɩ ‑do ɛ yɛ 'lɩ꞊ɩ yra bʋ, ‑ɛ nu꞊o, ɛ 'yɩ wɛn 'ʋ 'a tʋtʋʋ a ti 'yri nɩ nyre. ");
INSERT INTO ktj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ tugbɛ a 'mʋ yɩ: «Kʋɛ mɔ ‑nyrɔwɔ ‑bʋ 'yie bʋ, ꞊nɩ 'tʋʋ 'kɩ 'kui nɩ de, nyibli 'nɩ ꞊ha꞊a di.» Win a 'mʋ, ‑Yusu ‑pʋ, 'a ‑nagbopʋ 'wɩn꞊ɩ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ʋ nyre 'lɩ Jrusrɛdɩɔ 'kwli nɩ, ‑Yusu 'ɛ ‑mu, 'ɛ pa 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli. 'Kɩ 'lɩ ‑yaa a 'mʋ 'kwli, 'kɩ puplonyibli nɩ 'lɩ, 'ʋ ple 'wlugba‑tɛblɩ, 'kɩ 'ʋ Nyɩsʋa a ‑cɔhlʋn* a pipie a ‑ta'. 'Kɩ 'wli'cɩcɩnyibli nɩ 'lɩ ‑wɛ, 'ʋ yɩ hɩapʋwli 'cɩcɩ ‑nɩ. ‑Tɛ ‑Yusu yɛɛ 'ʋ puplonyibli a 'mʋ bʋ, ʋ kɔ nyibli ‑mʋ', ‑ʋ ‑tʋɛ ‑tɛblɩ 'hʋɛn‑, ‑ɛ ‑bɩ ɛ ‑tʋa 'waa lɛbʋbla, 'ɛ yɩ 'wli'cɩcɩnyibli a 'teble blɛ ꞊jijri ‑nɩ, kɔ, 'ɛ 'nyrɛɛ 'lɩ ‑hungboplonyʋ a gbatɩ yrɛ, 'ʋ yɩ ꞊hlɔn lɛ bi, ");
INSERT INTO ktj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","'ɛ 'yɩ nyiblo ꞊dʋ mɛ lɛ ‑ha, 'kɩ bʋ 'ble dɛ, bʋ 'bɛ ‑yaa a 'mʋ 'kwli ꞊tɩɔ, ");
INSERT INTO ktj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","'tɩ‑ 'ɛ ‑tʋa 'kɩ 'waa tɔɔlɛ, ɛ wɛn: «Ʋ 'crɩ꞊ɩ nɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ: Nyɩsʋa wɛn 'nɩ: 'Na 'kayu nɩ 'ʋ nɩ, 'kɩ 'klɔ ‑bʋ a dakɔ a pɛpɛ 'mʋ 'lɩ 'mʋ ‑daa ‑nɩ.» ‑Ɛ ‑bɩ ‑Yusu wɛn 'nɩ de: «Kɛɛ, 'a mʋ ‑mɔ ‑bɩ, a nu 'kayu a 'mʋ 'yiyrinyibli a 'kayu ‑mɔ'.» ");
INSERT INTO ktj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Dɛ a 'mʋ, ‑ɛ mu 'lu ‑mɔ, Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ, ʋ kɔ tetetɔɔnyʋ 'hʋɛn‑, ʋ 'wɩn꞊ɩ nɩ. Ɛ nɔ‑ nu꞊o, 'ʋ ꞊mʋɛ 'hru lɛ, ‑ɛ di꞊e nu, ʋ 'mʋ ‑Yusu 'la, ‑ɛ nu꞊o, dakɔ nʋɛ nɛ 'a tɔɔwin nɩ dɩakɩ. Ɛ nɔ‑ nu꞊o, nyibli gbagbɩ a 'mʋ 'ʋ ꞊tui ‑Yusu ca ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","‑Tɛ 'tɔ yɩ nɩ ‑wɛn, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ ꞊tɩ 'dɩɔ, 'ʋ mu 'lɩ ‑tɩtɛ ‑bɩ. ");
INSERT INTO ktj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","‑Nyrajru', ‑tɛ ʋ yɩ 'kɩ kle nɩ ‑mɛ, ‑ɛ ‑bɩ tugbɛ, ‑ɛ mɔ figie, ‑Yusu pʋ 'tʋ 'jrɔ ‑mɔ, ɛ nɔ‑ kɔ 'hʋɩ ʋ nɛɛ 'ʋ de. ‑Tɛ ʋ nyre 'kɩ 'ʋ꞊ʋ 'hʋɩ, kʋɛ 'lɩ 'a 'lu 'yri bʋ, ‑bʋ yɛ 'a bʋɩ kɩ, 'a pɛpɛ 'kʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","‑Ɛ ‑bɩ dɛ ‑mʋ', ‑ɛ mu 'tʋ 'lu ‑mɔ, ɛ bi 'lɩ Piɛlɩ 'kwli, ɛ wɛn: «Tɔɔnyɔ, 'ye tugbɛ ‑bʋ, ‑pʋ 'tʋ 'jrɔ ‑mɔ, ɛ 'kʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","‑Ɛ ‑bɩ ‑Yusu wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ba kuo Nyɩsʋa ꞊wlʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","'Bʋ mɔ, 'ba kuo Nyɩsʋa ꞊wlʋ yɩ, a ‑wɛ 'lɩ ba lee dʋgba ‑bʋ nɩ: ‑Hɔn mɔ ‑tɛ ‑bʋ, ‑bʋ bi 'lɩ 'yru ‑mɔ. 'Bʋ mɔ, 'ba 'yɛ nɩ pʋ gblɛ, 'kɩ 'lɩ 'aan ꞊wlɩ kɩ, kɛɛ, 'ba pʋ꞊ʋ ꞊haan‑tɩ, ‑ɛ mɔ, ‑tɩ ‑mʋ', a ‑hla, ɛ di mu 'lu ‑mɔ, 'ɛ mɔ ꞊han‑tɩ, Nyɩsʋa di꞊e 'nɩ nu, ɛ 'mʋ 'lu ‑mɔ mu. ");
INSERT INTO ktj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ɛ nɔ‑ nu꞊o, 'nɩ yɩ 'a mʋ ‑lee ‑nɩ, 'ba yɩ Nyɩsʋa dɛ nɩ ‑hʋɛ, ba kuo ꞊nɛ ꞊wlʋ yɩ, ‑ɛ mɔ, ɛ ‑wɛ 'a mʋ dɛ a 'mʋ, 'a ‑nyinyie ‑mɔ. 'Bʋ mɔ, 'ba kuo ꞊nɛ ꞊wlʋ yɩ, ɛ mɔ ꞊han‑tɩ, ɛ di 'a mɔ꞊ɔ 'nɩ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kɛɛ, 'ba yɩ Nyɩsʋa nɩ dɛ, nyiblo 'bʋ nu 'a mʋ yɩnyredɛ ‑mɔ, ‑ɛ ‑bɩ ba ‑hru 'a yɩnyredɛ a 'mʋ a ‑tɩ ‑mɔ, ‑ɛ di꞊e nu, 'aan 'Baɩ Nyɩsʋa, ‑ɛ nɩ 'lɩ yakɔ 'kwli, ɛ 'mʋ 'aan ‑nɛ yɩnyre‑tɛblɩ a ‑tɩ ‑mɔ ‑hru ‑wɛ.  ");
INSERT INTO ktj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kɛɛ, yɩnyre‑tɛblɩ ‑mʋ', nyibli nu 'a mʋ ‑mɔ, 'bʋ mɔ, 'ba 'yɛ nɩ ‑hru 'waa ‑tɩ ‑mɔ, ‑ɛ ‑bɩ 'aan 'Baɩ Nyɩsʋa, ‑ɛ nɩ 'lɩ yakɔ 'kwli, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑hru 'aan ‑nɛ yɩnyre‑tɛblɩ a ‑nu a ‑tɩ ‑mɔ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ 'tɩɛ gbɛ 'waa 'hru, ‑ɛ mi Jrusrɛdɩɔ 'kwli 'lu ‑mɔ. ‑Tɛ ʋ ‑nyre 'kɩ, ‑ɛ ‑bɩ ‑Yusu mu 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli. Bʋ yɩ 'lɩ lɛ nɩ 'dɛɛ ‑nɩ, ‑ɛ ‑bɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ, kɔ Nyɩsʋa a tetetɔɔnyʋ, ʋ kɔ ‑Juukʋɛ a 'blʋ a nyibli ‑bɩ 'hʋɛn‑, ʋ nyre 'ʋ꞊ʋ 'hʋɩ, ");
INSERT INTO ktj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","'ʋ 'bɛti꞊e, ʋ wɛn: «Nyiblo a 'dɩ ‑bɩ ‑nyi 'kɩ ‑mʋ 'klɩ, 'kɩ ‑bʋ bla ‑tɛblɩplonyibli ‑bʋ lɛ 'lɩ? Nyiblo a 'dɩ ‑bɩ ‑lee ‑mʋ ‑wɛ, ‑bʋ nu ‑tɛblɩ a pɛpɛ ‑bʋ, ‑ni 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","‑Ɛ ‑bɩ ‑Yusu wɛn: «'N di 'bɛti 'a mʋ dɛ nɩ ‑do ‑wɛ. 'Bʋ mɔ, 'ba ‑hɩhɩa 'mʋ klɛ, 'tɩ‑ 'mʋ 'a mʋ klɛ ‑hɩhɩa ‑nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","'A mʋ 'n yɩ 'bɛti ‑nɩ: Nyiblo a 'dɩ ‑bɩ ‑lee la Saan, bʋ pʋ la nyibli 'nie 'lu lɛ 'lɩ? ꞊Bɩ Nyɩsʋa ꞊nɩɔ, ‑ʋ'ʋ‑ ‑tonyibli ꞊nɩɔ? Ba ‑hɩhɩa 'mʋ klɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","‑Ɛ ‑bɩ ʋ ‑tʋa lɛ'bɛtilɛ, 'kɩ 'lɩ 'waa dɩɔnʋ 'nyɩ, ʋ wɛn: «‑Bɩ' ‑a di 'kɩ pʋ? 'Bʋ mɔ, ꞊ba pʋ lɛ, Nyɩsʋa ‑lee la 'nɛ꞊ɛ, ‑ɛ ‑bɩ ɛ di ꞊hɩan ‑mɔ, ɛ 'mʋ ‑a mʋ 'bɛti ‑nɩ: ‑Tɩ ‑mʋ', Saan hlɛ la, dɛ‑ kɔ ‑tɩ 'a 'yɩ 'kɩ꞊ɩ ꞊haan‑tɩ ‑pʋ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mɔ, 'bʋ mɔ, ꞊ba pʋ lɛ, ‑tonyibli ꞊nɩɔ, ‑ɛ ‑bɩ nyibli kɔ bʋ yɛɛ nɛ ‑a mʋ ‑tɩ.» Kɛ‑ ʋ pʋ 'bɛtilɛ, ‑ɛ nu꞊o, nyibli pʋ꞊ʋ ꞊haan‑tɩ, ‑ɛ mɔ, Saan mɔ la Nyɩsʋa a winwlɔn‑hanyɔ* ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ɛ nɔ‑ nu꞊o, 'ʋ ꞊tu ‑Yusu ꞊wɔn, ʋ wɛn: «‑A 'yɩ 'a ꞊dedede ‑yi.» ‑Ɛ ‑bɩ ‑Yusu wɛn: «'Na 'mumu, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ ꞊bʋ lee nɛ 'a mʋ ‑wɛ, nyiblo a 'dɩ ‑bɩ, ‑ɛ ‑nyi 'mʋ 'klɩ, 'kɩ ꞊bʋ nu ‑tɛblɩ a pɛpɛ ‑bʋ, 'n ni.» ");
INSERT INTO ktj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","(‑Yusu 'tɩɛ yɩ 'lɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ, kɔ tetetɔɔnyʋ, kɔ ‑Juukʋɛ* a naanyʋ ‑bɩ 'hʋɛn‑ ‑mɔ ‑hlee ‑nɩ, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli.) 'Kɩ 'lɩ 'ledʋɩ 'kwli, 'kɩ ɛ yɩ 'lɩ ꞊nʋ ‑mɔ ‑hlee ‑nɩ, ɛ wɛn: «Ɛ kɔ la 'dʋdɔnyɔ ꞊dʋ. Ɛ nɔ‑ ‑ci la 'a ‑ci. ‑Ci a 'mʋ kɩ, ɛ 'dɔɔ 'lɩ 'lili ꞊dʋ. 'A 'yɔ, ɛ tʋɩ, ʋ dɛɛ ꞊nɛ rɛsɛn. 'Dʋdɔnyɔ a 'mʋ, ɛ nɔ‑ ‑ha 'a ‑ci a 'mʋ yɩ, 'ɛ 'blu 'lɩ 'hɩɔ gbɛtɛɛ 'kwli lɛ, ‑ɛ di꞊e nu, 'bʋ yɩ 'a 'yɔ a 'mʋ nɩ 'plʋɛ, 'a 'nie 'mʋ 'lɩ 'hʋɔ a 'mʋ 'kwli lɛ bi, ʋ 'mʋ꞊ʋ nɔ ‑mɔ' nu. Ɛ nu 'hɩ‑gbɔ ‑wɛ, ‑ɛ kɔ kɩ ɛ di 'ʋ bʋ nyra, ɛ 'mʋ ‑ci 'yie ꞊tu, 'yiyrinyibli a ‑tɩ. ‑Tɛ ɛ ‑wɛ ‑kʋan a pɛpɛ a 'mʋ ‑mɔ, ‑ɛ ‑bɩ ɛ lee ‑kʋannunyibli ꞊dʋ, bʋ nu ‑ci a 'mʋ 'a ‑kʋan, ‑ɛ di꞊e nu, 'dʋdɔ‑tɛblɩ 'bʋ ‑tʋ, ʋ 'mʋ꞊ʋ 'a 'kɩbɩa ‑nyi, ‑kʋannunyibli a 'mʋ, 'waa 'mumu, ʋ 'mʋ 'waa ‑nɛ 'kɩbɩa kɔ. ‑Cikɔnyɔ a 'mʋ, ‑tɛ ɛ ‑wɛ ‑kʋan a yɩblɛ꞊tutulɛ ‑mɔ, ‑ɛ ‑bɩ ɛ mu 'dagba blɔblʋ. ");
INSERT INTO ktj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","‑Tɛ 'dʋdɔ‑tɛblɩ a 'cɩcɛti nyre 'ʋ, ‑ɛ ‑bɩ ‑cikɔnyɔ a 'mʋ, ɛ lee nɛ 'a lɛlenyɔ ‑bɩ, 'kɩ bʋ mu 'lɩ ‑ci'yie꞊tunyʋ ‑mɔ, ʋ 'mʋ꞊ʋ 'cɩcɛ‑tɛblɩ a 'kɩbɩa ‑mʋ', ‑ɛ blɛɛ ‑cikɔnyɔ yɩ ‑nyi, ɛ 'mʋ ꞊nɛ꞊ɛ yɩ ya. ");
INSERT INTO ktj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","‑Tɛ lɛlenyɔ a 'mʋ, ɛ nyre 'lɩ, ‑ɛ ‑bɩ ‑ci'yie꞊tunyʋ a 'mʋ, ʋ klɔ꞊ɔ nɩ, 'ʋ bi꞊e ‑tɛɛ, 'kɩ ʋ 'yɩ꞊ɩ ꞊dedede ‑nyi, 'ʋ ‑mɩa ꞊nɛ kle. ");
INSERT INTO ktj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","‑Ɛ ‑bɩ ‑cikɔnyɔ le 'a lɛlenyɔ ‑bɩ de, 'ʋ klɔ꞊ɔ ‑wɛ, 'ʋ pʋ 'ʋ꞊ʋ dɛ 'lu, 'ʋ ‑ha꞊a 'yri lɛ, 'ʋ ‑mɩa ꞊nɛ kle, ");
INSERT INTO ktj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","‑cikɔnyɔ a 'mʋ, 'ɛ tɛ 'lɩ ‑ɛ ‑bɩ de, 'ʋ klɔ꞊ɔ, 'ʋ 'la꞊a, 'ɛ le ‑ʋ ‑bɩ de, 'ʋ bi ‑ʋ ‑bɩ, 'ʋ 'la ‑ʋ ‑bɩ. ");
INSERT INTO ktj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nyiblo nɩ ‑do, ɛ nɔ‑ hie 'kɩ 'ʋ ‑cikɔnyɔ a 'mʋ 'hʋɩ. Nyiblo a 'mʋ, ɛ nɔ‑ mɔ 'a 'yu, ɛ nʋɛ ‑nɩ, ‑cikɔnyɔ 'ɛ le 'lɩ ꞊nʋ꞊ʋ ‑mɔ, ‑ɛ nu꞊o, 'a ꞊wlʋ wɛn 'nɩ: ‑Tɛ ɛ mɔ 'na 'yu, ʋ di kɔ 'a 'ʋ꞊tuulɛ. ");
INSERT INTO ktj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","‑Tɛ ɛ waan 'lɩ, ‑ɛ ‑bɩ kɛ‑ ʋ pɩ, 'kɩ 'lɩ 'waa dɩɔnʋ 'nyɩ, ʋ wɛn: Nyiblo ‑bʋ, ‑ɛ di ‑ci ‑bʋ kɔ ‑nyrɔwɔ ꞊dʋ, ɛ nɔ‑ yɩ 'lɩ di. 'A ‑tɩ, ‑ba 'la꞊a, ‑a 'mʋ ‑ci ‑bʋ gba, ");
INSERT INTO ktj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","'ʋ klɔ꞊ɔ, 'ʋ 'la꞊a, 'ʋ 'du꞊o ye', 'ʋ ‑ha 'lɩ꞊ɩ ‑ci 'kwli, 'ʋ pʋ꞊ʋ 'wan.» ");
INSERT INTO ktj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","‑Ɛ ‑bɩ ‑Yusu wɛn 'nɩ de: «'A mʋ 'n yɩ 'bɛti ‑nɩ, nyiblo a 'mʋ, ‑ɛ kɔ ‑ci a 'mʋ, 'bʋ 'wɩn ‑tɛblɩ a pɛpɛ a 'mʋ, ‑ɛ mu 'lu ‑mɔ, dɛ a 'dɩ ‑bɩ ɛ di nu 'lɩ? 'A 'mumu, ɛ di 'nɩ di, ɛ 'mʋ ‑ci'yie꞊tunyʋ a 'mʋ 'la, 'tɩ‑ ɛ 'mʋ 'lɩ ‑ci a 'mʋ 'lɩ ‑ha, ɛ 'mʋ꞊ʋ nyibli ‑bɩ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","‑Tɩ ‑bʋ, ʋ 'crɩ la, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, 'n pʋ꞊ʋ ꞊haan‑tɩ, a ‑hre꞊e nɩ. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: 'Katuo ‑mʋ', 'kayupʋnyʋ 'yɩ ‑hʋa bʋ nuu ‑kʋan 'yri, ʋ pʋ 'kɩbɩa kɩ, ɛ nɔ‑ ‑hɛ 'kayu a 'mʋ a 'katuo gbagbʋ. ");
INSERT INTO ktj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kʋkɔnyɔ Nyɩsʋa, ɛ nɔ‑ nu꞊o, 'ɛ ‑hɛ 'katuo gbagbʋ, 'tɩ‑ 'ɛ nɔɔ 'yie klɛ, 'kɩ 'ʋ ‑a mʋ ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","'Tɩ‑ ‑Yusu 'mʋ ‑yrɛ, ‑ɛ ‑bɩ ‑Juukʋɛ a naanyʋ, ‑ʋ nɩ 'ʋ, ʋ yru꞊o nɩ, ‑ɛ mɔ, ʋ nʋ‑ ‑Yusu pʋ 'ledʋ a 'mʋ yɩ. ‑Tɛ ʋ yru dɛ a 'mʋ, ‑ɛ ‑bɩ ʋ ꞊mʋɛ 'a kʋklɔ a 'hru lɛ, ʋ 'mʋ꞊ʋ 'la. Kɛɛ, ‑tɛ ʋ yɩ nyibli a hʋannʋ pie, ɛ nɔ‑ nu꞊o, 'ʋ ‑ha꞊a mɛ lɛ, 'ʋ ‑mu. ");
INSERT INTO ktj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Juukʋɛ* a naanyʋ tɛ Falisi꞊tumu* a nyibli, kɔ nyibli ‑bɩ 'hʋɛn‑ bʋ, ‑ʋ mɔ 'kɩɩn Helɔdɩ a ꞊tumu a nyibli. Ʋ nʋ‑ mu 'ʋ ‑Yusu 'hʋɩ, ʋ 'mʋ꞊ʋ lɛ 'bɛti ‑nɩ, ‑ɛ di꞊e nu, 'kɩ 'lɩ 'a ꞊wɔn꞊tutuo 'kwli, ʋ 'mʋ 'lɩ ‑naa ‑nɩ, ʋ 'mʋ꞊ʋ ‑tɩ ‑yɛɛ ‑nɩ, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ klɔ. ");
INSERT INTO ktj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","‑Tɛ ʋ nyre 'kɩ 'ʋ꞊ʋ 'hʋɩ, ‑ɛ ‑bɩ ʋ wɛn: «Tɔɔnyɔ o, ‑a yi꞊e nɩ, ‑ɛ mɔ, ‑hlɛ ‑tɩ a ‑tɛɛ. 'Bʋ mɔ, ꞊nɩ yɩ꞊ɩ nɩ hlɛ, ꞊nɩ ‑pie꞊e hʋannʋ, 'kɩ 'ʋ ‑tonyibli a 'lulɛ‑hihie a ‑ta', 'ye ꞊bɩɩ ɛ mɔ nyiblo gbagbʋ. Kɛɛ, ‑tʋɛ ‑tɩ a ‑tɛɛ, 'kɩ 'ʋ dɛ ‑mʋ', Nyɩsʋa ‑hʋɛ a ‑ta'. Lee 'kɩ ‑a mʋ, ꞊bɩ Nyɩsʋa a tete wɛn 'nɩ, ‑ba ‑ha 'blʋwli, ‑ba ‑nyi꞊e Romakʋɛ a 'kɩɩn gbagbʋ, ‑ʋ'ʋ‑, ‑a 'yɩ yɩ ‑blɛɛ ‑nɩ, ‑ba ‑nyi ꞊nɛ꞊ɛ?» ");
INSERT INTO ktj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kɛɛ, ‑Yusu yi꞊e nɩ, dɛ‑ mɔ 'waa 'lulɛ‑hihie, 'ʋ yɩ ꞊nɛ꞊ɛ 'yi kɩ ‑hlii ‑nɩ, ‑ɛ ‑bɩ ɛ wɛn: «Dɛ‑ kɔ 'mɔ a yɩ 'bɛti ‑nɩ, 'a yɩ 'ʋ 'mʋ lɛ ꞊tɛɛ ‑nɩ 'lɩ? ꞊Bɩ a 'mʋ꞊ʋ 'ye, 'bʋ mɔ, 'nɩ ‑hɛɛ Romakʋɛ a 'kɩɩn gbagbʋ kɔ Nyɩsʋa 'hʋɛn‑ a ‑tɩ lɛ, a 'mʋ 'mʋ ‑tɩ ‑yɛɛ ‑nɩ? Ba ya 'mʋ 'wliyɔkɔ a 'yɛɛ nɩ ‑do yɩ, 'mʋ꞊ʋ 'ye», ");
INSERT INTO ktj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","'ʋ ya ꞊nɛ꞊ɛ yɩ. ‑Ɛ ‑bɩ ɛ wɛn: «Nyiblo a 'dɩ ‑bɩ, ‑ɛ kɔ yigbakla ‑nɩ 'ʋ꞊ʋ kɩ 'lɩ? Nyiblo a 'dɩ ‑bɩ, ‑ɛ kɔ 'nyrɛ ʋ 'crɩɩ 'ʋ ‑wɛ lɩ?» ‑Ɛ ‑bɩ ʋ wɛn: «Romakʋɛ a 'kɩɩn gbagbʋ ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'kɩ ꞊nʋ yɩ, ɛ wɛn: «'A ‑tɩ o, dɛ ‑bʋ, ‑ɛ blɛɛ 'kɩɩn gbagbʋ yɩ, ba ‑nyi ꞊nɛ꞊ɛ, ɛ kɔ, dɛ ‑bʋ, ‑ɛ blɛɛ Nyɩsʋa yɩ, ba ‑nyi ꞊nɛ꞊ɛ ‑wɛ». ꞊Wɔn a 'mʋ, ‑Yusu ꞊tu ꞊nʋ, ɛ kɛɛ ꞊nʋ ꞊wlɩ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","'Kɩ 'lɩ Jrusrɛdɩɔ 'kwli, ɛ kɔ la ꞊tumu ꞊dʋ. 'A 'nyrɛ mɔ Sadusɩ꞊tumu*. Ʋ nʋ‑ hlɛ꞊ɛ, ‑ɛ mɔ, 'bʋ mɔ, nyiblo 'bʋ 'kʋ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ, bʋ 'hrɩ 'klɔ, 'kɩ 'lɩ Nyɩsʋa yɩ. Ʋ nʋ‑ kɔ nyibli ‑mu 'ʋ ‑Yusu 'hʋɩ, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ lɛ 'bɛti ‑nɩ. ‑Tɛ ʋ nyre 'kɩ 'ʋ꞊ʋ 'hʋɩ, ‑ɛ ‑bɩ ʋ wɛn: ");
INSERT INTO ktj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Tɔɔnyɔ o, Nyɩsʋa a winwlɔn‑hanyɔ* Moise 'crɩ la tete ‑bɩ, 'ɛ hie la꞊a ‑a mʋ lɛ. Tete a 'mʋ, ɛ nɔ‑ ‑bʋ: Nyɩbɛyugbe 'bʋ nɩ 'ʋ, 'bʋ kɔ nʋgba, 'tɩ‑ nyɩbɛyugbe a 'mʋ, 'bʋ 'yɩ 'ʋ 'yonʋ bʋ ‑hie, 'bʋ 'kʋ, nyɩbɛyugbe a 'mʋ, ‑ɛ 'kʋ, 'bʋ kɔ 'dɩayɩ nyɩbɛhɩan, ɛ nɔ‑ blɛɛ yɩ, ‑bʋ kɔ 'a nʋgba a 'mʋ, ɛ kɔ꞊ɔ 'hʋɛn‑, ʋ 'mʋ 'yonʋ kɔ, 'kɩ 'ʋ 'a 'dɩayɩ ‑mʋ', ‑ɛ 'kʋ a ‑ta'. Kɛ‑ Moise a tete pɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","‑Ɛ ‑bɩ kɛ‑ ʋ pɩ de, ʋ wɛn: «Ɛ kɔ la 'dɩayɩ nyɩbɛpʋ nɩ ꞊hlon'hʋɛn ꞊dʋ, 'waa yɩ‑hɛnyiblo, nɔ‑ kɔ la nʋgba. Nyɩbɛyu a 'mʋ, ɛ 'yɩ 'ʋ 'yu bʋ ‑hie, 'ɛ 'kʋ, ");
INSERT INTO ktj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","'hʋɛn a nyiblo 'ɛ kɔ꞊ɔ, 'ɛ 'yɩ 'ʋ 'yu bʋ ‑hie ‑wɛ, 'ɛ 'kʋ. Dɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ nu ta a nyiblo. ");
INSERT INTO ktj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ɛ nɔ‑ mu 'lu ‑mɔ ‑mumu, ꞊hlon'hʋɛn a nyiblo 'ɛ kɔ꞊ɔ ‑wɛ, 'ɛ 'yɩ 'ʋ 'yu bʋ ‑hie, 'ɛ 'kʋ ‑wɛ. ‑Tɛ 'waa pɛpɛ, ʋ 'kʋ 'kɩ, ‑ɛ ‑bɩ nʋgba a 'mʋ, ɛ 'kʋ nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ɛ nɔ‑ mɔ ‑tɩ ‑mʋ', ‑a di wɛn ‑mʋ 'bɛti mɔ, ꞊mʋ ‑a mʋ klɛ ‑hɩhɩa ‑nɩ. ‑Nyrɔwɔ ‑kɔ 'kwli nyibli di 'lɩ 'kʋkʋnyibli 'nyɩ ‑hɔn, ʋ di 'klɔ 'hrɩ, 'kɩ 'lɩ Nyɩsʋa yɩ, nyiblo a 'dɩ ‑bɩ ‑di 'kɩ nʋgba a 'mʋ kɔ 'lɩ, ‑kɔtɩ ‑tɛ ʋ nɩ la 'nɛ‑ ‑tʋtʋ kɩ, nyibli nɩ ꞊hlon'hʋɛn a 'mʋ, ʋ kɔ la꞊a nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «A kɛ nɩ, ‑kɔtɩ a 'yɩ Nyɩsʋacrɩɛn ‑yi, 'a 'yɩ꞊ɩ ‑yi, ‑ɛ mɔ, Nyɩsʋa nɩ 'klɩ kɩ. ");
INSERT INTO ktj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ti ‑mʋ' ‑kɔ 'yri nyibli di 'lɩ 'kʋkʋnyibli 'nyɩ ‑hɔn, ʋ di 'klɔ 'hrɩ, 'kɩ 'lɩ Nyɩsʋa yɩ, nyɩbɛpʋ kɔ nʋgbɩ 'hʋɛn‑, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ kʋkɔ ‑nɩ. Kɛɛ, ‑tɛ Nyɩsʋa a lɛlenyʋ nɩ 'mʋ, kɛ‑ ʋ di 'mʋ nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","'Ya 'ʋ 'lu de, dɛ ‑bʋ, ‑ɛ mɔ nyibli bʋ ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ, bʋ 'hrɩ 'klɔ, 'n yi꞊e nɩ, ‑ɛ mɔ, a ‑hre Nyɩsʋacrɩɛn ‑mʋ', Moise 'crɩ la nɩ. Ɛ 'crɩ la dɛ, Nyɩsʋa lee la꞊a, ‑tɛ Nyɩsʋa a 'mʋ, ɛ nɩ la 'lɩ ‑gbakuo 'kwli, ‑ɛ yɩ la wlɩn, 'tɩ‑ ‑tɛ ɛ yɩ la 'lɩ Moise a 'mʋ ‑mɔ ‑hlee ‑nɩ. Nyɩsʋa wɛn 'nɩ: 'Mɔ mɔ Nyɩsʋa ‑bʋ, Abrahamʋ dɛ, ɛ kɔ Yisakɩ, kɔ Sakɔbʋ 'hʋɛn‑. Kɛ‑ Nyɩsʋa pʋ la. ");
INSERT INTO ktj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ɛ 'wɩ yɩ, ti ‑mʋ' ‑kɔ 'yri Nyɩsʋa yɩ la 'lɩ Moise ‑mɔ ‑hlee ‑nɩ, Abrahamʋ kɔ Yisakɩ kɔ Sakɔbʋ 'hʋɛn‑, ʋ 'kʋ la nɩ see la. Kɛɛ, ‑a yi꞊e nɩ, ‑ɛ mɔ, ɛ 'yɩ 'kʋkʋnyibli 'pa‑, ʋ 'nɩ ‑da꞊a lɩ Nyɩsʋa, kɛɛ, 'klɔnɩnyibli, ʋ nʋ‑ dɛ꞊ɛ. 'A ‑tɩ, 'bʋ mɔ, 'ba pʋ lɛ, nyiblo 'bʋ 'kʋ, ɛ 'nɩ 'hrɩ꞊ɩ 'klɔ, 'kɩ 'lɩ Nyɩsʋa yɩ, ‑ɛ ‑bɩ 'a dɛ a 'mʋ, a kaa ꞊nɛ 'yri nɩ pɛpɛ.» Kɛ‑ ‑Yusu ‑pʋ. ");
INSERT INTO ktj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tetetɔɔnyɔ ‑bɩ, ‑ɛ nɩ ‑tuo kɩ, ɛ 'wɩn ‑tɩ a pɛpɛ ‑mʋ', ʋ ‑hla nɩ. Bʋ 'wɩn 'kɩ, ‑ɛ mɔ, ‑Yusu ꞊tu Sadusɩ꞊tumu* a nyibli ꞊wɔn ‑tɛɛ, ‑ɛ ‑bɩ ɛ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, 'ɛ 'bɛti꞊e, ɛ wɛn: «Tete a pɛpɛ ‑mʋ', Nyɩsʋa ‑nyi ‑a mʋ, 'a dɛ a 'dɩ ‑bɩ, ‑ɛ nɩ 'ʋ tete a pɛpɛ 'lu yɩ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","‑Ɛ ‑bɩ ‑Yusu ꞊tu꞊o ꞊wɔn, ɛ wɛn: «Nyɩsʋa a tete ‑mʋ', ‑ɛ nɩ 'ʋ tete a pɛpɛ 'lu yɩ, ɛ nɔ‑ ‑bʋ: Ba pʋ 'ʋ nʋa bʋ, 'a mʋ Yisraɛkʋɛ: ‑Aan ‑nɛ Kʋkɔnyɔ Nyɩsʋa, ɛ nɔ‑ mɔ Nyɩsʋa nɩ ‑do. 'Bɛ 'ʋ꞊ʋ kɩ, nyɩsʋa ꞊dʋ 'yɩ 'kɩ 'ʋ ‑nɩ de. ");
INSERT INTO ktj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","‑Blɛɛ yɩ, ‑bʋ nʋɛ ‑na Kʋkɔnyɔ Nyɩsʋa, 'kɩ 'lɩ ‑na ꞊wlʋ a pɛpɛ kɩ, kɔ 'kɩ 'lɩ ‑na 'lulɛ‑hihie a pɛpɛ 'kwli, kɔ 'kɩ 'lɩ ‑na 'klɩ a pɛpɛ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nyɩsʋa a tete, ‑ɛ kʋɛ 'ʋ꞊ʋ ‑mɔ, ɛ nɔ‑ ‑bʋ: ‑Blɛɛ yɩ, ‑bʋ nʋɛ ‑na 'bɩ ‑tonyiblo, ꞊wɩ yɩ, ‑tɛ ‑nu ‑na dɩɔnʋ a nʋɛlɛ. Ɛ 'yɩ Nyɩsʋa a tete ꞊dʋ ‑kɔ, ‑bʋ nɩ 'ʋ ʋ nɩ 'hʋɛn a 'mʋ 'lu yɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","‑Ɛ ‑bɩ tetetɔɔnyɔ a 'mʋ, ɛ wɛn: «‑Tɩ ‑mʋ', ‑hla, 'a ‑tɛɛ ꞊nɩɔ. ‑Aan ‑nɛ Kʋkɔnyɔ Nyɩsʋa, ɛ nɔ‑ mɔ Nyɩsʋa nɩ ‑do. 'Bɛ 'ʋ꞊ʋ kɩ, nyɩsʋa ꞊dʋ 'yɩ 'kɩ 'ʋ ‑nɩ de. ");
INSERT INTO ktj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","‑Tonyiblo blɛɛ yɩ, bʋ nʋɛ Nyɩsʋa, 'kɩ 'lɩ 'a ꞊wlʋ a pɛpɛ kɩ, kɔ 'kɩ 'lɩ 'a 'lulɛ‑hihie a pɛpɛ 'kwli, kɔ 'kɩ 'lɩ 'a 'klɩ a pɛpɛ 'kwli. Ɛ blɛɛ yɩ ‑wɛ, bʋ nʋɛ nɛ 'a 'bɩ ‑tonyiblo, ꞊wɩ yɩ, ‑tɛ ɛ nu 'a dɩɔnʋ a nʋɛlɛ. Ɛ nɔ‑ mɔ dɛ gbagbʋ, ‑ɛ ‑hi 'ʋ bʋ pi 'a ‑nɛ 'wlugba‑tɛblɩ a ‑cɔhlʋn* a gblegble ꞊dʋ, 'kɩ 'ʋ Nyɩsʋa ye'.» ");
INSERT INTO ktj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","‑Yusu bʋ 'ye꞊e, ‑ɛ mɔ, tetetɔɔnyɔ a 'mʋ, ɛ ꞊tu꞊o ꞊wɔn, 'kɩ 'lɩ ꞊tɔ 'kwli, ‑ɛ ‑bɩ ɛ wɛn: «Ɛ hie 'ʋ ‑mʋ dɛ nɩ ‑do, ꞊mʋ Nyɩsʋa yrɛ 'mʋɛ ‑nɩ, 'kɩ bʋ kɔɔ ‑mʋ win kɩ.» ‑Tɛ dɛ a 'mʋ, ɛ ‑hi, nyiblo ꞊dʋ 'yɩ 'kɩ꞊ɩ 'bɛti ‑nɩ de, ‑ɛ di꞊e nu, 'kɩ 'lɩ 'a ꞊wɔn꞊tuwin 'kwli, ʋ 'mʋ 'lɩ ‑naa ‑nɩ, ʋ 'mʋ꞊ʋ ‑tɩ ‑yɛɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu ‑tʋa nyibli Nyɩsʋa a ‑tɩ a tɔɔlɛ, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ. ‑Tɛ ɛ yɩ 'kɩ ꞊nʋ nɩ ‑tʋɛ ‑nɩ, ‑ɛ ‑bɩ ɛ wɛn: «Tetetɔɔnyʋ* wɛn 'nɩ: Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya, Wanyɔ a 'mʋ, ɛ nɔ‑ mɔ bodɩɔ Dafidɩ a 'yonʋ a 'Yu. 'A mʋ 'n yɩ 'bɛti ‑nɩ: Dɛ‑ kɔ ‑tɩ 'ʋ hlɛ꞊ɛ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","‑kɔtɩ Nyɩsʋa a ‑Hihiu* nu꞊o nɩ, bodɩɔ Dafidɩ, 'ɛ hla꞊a, 'ʋ 'crɩ꞊ɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ: Kʋkɔnyɔ Nyɩsʋa lee 'na Kʋkɔnyɔ nɩ, ‑ɛ mɔ: Nɩ mɔ 'na diidɛkɩbɩa kɩ bʋ, ‑kɔ 'mʋ 'hʋɛn‑, ‑a 'mʋ nyibli win kɩ ‑kɔɔ ‑nɩ, ɛ 'mʋ꞊ʋ gba ‑gbagba, 'mʋ꞊ʋ nu, ꞊mʋ ‑na yraanyibli bʋɩ 'lu blɛ ꞊tu.» ");
INSERT INTO ktj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","‑Ɛ ‑bɩ ‑Yusu wɛn 'nɩ de: «‑Tɛ Dafidɩ a 'mʋ, ɛ dɛɛ Wanyɔ a 'mʋ Kʋkɔnyɔ, ‑bɩ' Wanyɔ a 'mʋ, ɛ ‑wɛ 'lɩ bʋ nu 'kɩ Dafidɩ a 'Yu a pʋpa 'lɩ?» Nyibli ‑hʋɔhʋɩ a 'mʋ, ‑ʋ nɩ ‑tuo kɩ, ‑tɩ ‑mʋ', ‑Yusu ‑hla, ɛ blee 'waa plɔ nɩ dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Kɛ‑ ɛ pɩ ꞊nʋ yɩ, 'kɩ 'lɩ 'a tɔɔwin 'kwli: «Ba ꞊tu 'aan dɩɔnʋ 'yie, 'kɩ 'ʋ tetetɔɔnyʋ a ‑ta', ʋ 'nɩ ꞊ha 'a mʋ ‑kaa ‑nɩ. Ʋ nʋɛ 'kɩ nyibli bʋ daa ꞊nʋ nyibli gbagbɩ. 'Bʋ yɩ lɛ nɩ nɛ, ʋ pɩ nyibli gbagbɩ a wlawlɩ, ‑ɛ di꞊e nu, nyibli 'mʋ ꞊nʋ 'ye. 'Bʋ yɩ 'ʋ ‑tɩtɛ ꞊dʋ nɩ mi, ‑tɛ nyibli ‑hʋʋ 'ʋ, ‑ɛ ‑bɩ ʋ ‑hʋɛ꞊ɛ nɩ, nyibli bʋ pʋ ꞊nʋ 'wio blɛ, 'kɩ 'ʋ 'waa 'ʋ꞊tuulɛ a ‑ta', ");
INSERT INTO ktj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","'ʋ nʋɛ ꞊nɛ nɩ ‑wɛ, 'bʋ mu 'lɩ Nyɩsʋa a 'kayu bʋ, 'kɩ bʋ nɩ 'lɩ ye' bʋ, ‑ɛ di꞊e nu, nyibli a pɛpɛ 'mʋ ꞊nʋ 'ye. Dɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ ʋ ni, 'bʋ da ꞊nʋ dididɛ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ʋ nɩ ‑do a 'mʋ, ʋ nʋ‑ ‑hɛ ‑tʋgbanʋgbɩ kʋkɔ‑tɛblɩ a pɛpɛ ꞊jrɛ. 'Tɩ‑, tetetɔɔnyʋ a 'mʋ, 'bʋ yɩ Nyɩsʋa nɩ dɛ, 'waa Nyɩsʋa a dɩda hlɔ kɩ bʋ, ‑ɛ di꞊e nu, nyibli 'mʋ lɛ pʋ, ʋ mɔ ꞊haannyibli ꞊nɩɔ. 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, ‑bati ‑mʋ', Nyɩsʋa di ꞊nʋ lɛ ‑pʋʋ ‑nɩ, ɛ di nɩ 'klɩ kɩ, ɛ 'mʋ 'ʋ nyibli ‑bɩ a ‑bati 'ʋ ‑hi.» ");
INSERT INTO ktj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","‑Tɛ ‑Yusu ‑wɛ hihle ‑mɔ, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ, ‑ɛ ‑bɩ ɛ nɩ bʋ, 'kɩ 'ʋ dukwli ‑mʋ' 'hʋɩ, ‑ɛ kɔ 'kwli nyibli pɩ 'lɩ 'wli lɛ, 'kɩ 'ʋ Nyɩsʋa a ‑kʋan a ‑ta'. ‑Ɛ ‑bɩ ‑Yusu yɩ꞊ɩ 'nɩ 'ye, ‑tɛ nyibli ni 'lɩ 'wli a lɛpʋpʋʋ. 'Kɩ 'lɩ dukwli a 'mʋ 'kwli, dɛkɔnyʋ ‑hʋɔhʋɩ pɩ 'lɩ 'wli lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ɛ kɔ ‑tʋgbanʋgba ꞊dʋ, ꞊hɩʋɛn ni. Ɛ nɔ‑ nyre 'ʋ, 'ɛ pʋ 'lɩ 'wliyɔkɔ a 'yɔ nɩ 'hʋɛn, ‑ʋ 'yɩ 'lɩ ꞊dedede a ‑tʋtɔ 'lɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","‑Tɛ ‑Yusu 'ye꞊e, ‑ɛ ‑bɩ ɛ da 'a ‑nagbopʋ* nɩ, ɛ wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, 'kɩ 'lɩ Nyɩsʋa 'yi, ꞊hɩʋɛnnʋgba ‑bʋ, ɛ pʋ 'lɩ 'wliyɛ, 'ɛ ‑hi 'ʋ nyibli a pɛpɛ ‑bʋ 'ʋ, ");
INSERT INTO ktj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","‑kɔtɩ nyibli a pɛpɛ ‑bʋ, 'wliyɛ ‑mʋ', ‑ɛ 'yɩ ‑kʋan ‑kɔ, 'kɩ 'ʋ ꞊nʋ ‑mɔ, ɛ nɔ‑ ʋ pʋ 'lɩ lɛ. Nʋgba ‑bʋ, ɛ nɔ‑ ‑mɔ ‑bɩ, ꞊han‑tɩ, ꞊hɩʋɛn 'ɛ ni꞊e, kɛɛ, kɛ‑ ɛ nɩ 'mʋ, 'wliyɛ a pɛpɛ ‑mʋ', ɛ di wɛn nu, ɛ 'mʋ wɛn 'a dɩɔnʋ yɩ ‑wɔn, ɛ nɔ‑ ɛ pʋ 'lɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","‑Tɛ ‑Yusu ‑yrɛ 'kɩ, ‑ɛ ‑bɩ ɛ kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ 'du ye', 'ʋ yɩ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ 'hrɩ. ‑Tɛ ʋ yɩ 'kɩ nɩ mi, ‑ɛ ‑bɩ ‑Yusu a ‑nagbopi ‑bɩ wɛn: «Tɔɔnyɔ o, 'ye 'hɩ gbagbɩ ‑bʋ, ʋ ‑nu, 'ʋ pʋ Nyɩsʋa a 'kagbaʋ ‑bʋ, 'ye ‑tɛ 'kayu a 'mʋ, ɛ nu yɩnɩnɔ.» ");
INSERT INTO ktj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","‑Ɛ ‑bɩ ‑Yusu wɛn: «'Kayu ‑bʋ, ‑kɔ yɩnɔ‑pli ‑pɩ, kɔ 'a yiyie, ‑ɛ mɔ, yɩnɔkayu a 'mʋ, ʋ di꞊e 'nɩ 'wla pɛpɛ. 'A 'hɩɔ ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nɩ 'ʋ 'a 'bɩ 'hɩɔ 'lu bʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","‑Yusu bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ɛ kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ ꞊tɩ 'dɩɔ, 'ʋ mu 'lɩ dʋgba ‑mʋ', ‑ɛ kɔ 'lu olifieti nɩ 'lɩ. Dʋgba a 'mʋ, ɛ 'bɛ Nyɩsʋa a 'kagbaʋ 'yi. ‑Tɛ ʋ nyre 'lɩ, ‑ɛ ‑bɩ ‑Yusu nɩ bʋ, Piɛlɩ kɔ Sakɩ, kɔ Saan, kɔ Adre 'hʋɛn‑ 'ʋ mu 'ʋ꞊ʋ 'hʋɩ, 'ʋ 'bɛti꞊e, ʋ wɛn: ");
INSERT INTO ktj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Lee nɛ ‑a mʋ, ti a 'dɩ ‑bɩ, ‑ɛ kɔ 'yri ʋ di 'ʋ Nyɩsʋa a 'kagbaʋ 'wlaa ‑nɩ, ɛ kɔ, dɛ a 'dɩ ‑bɩ, ‑ɛ di 'lu ‑mɔ mu, ‑a di 'ye, 'tɩ‑ ‑a 'mʋ꞊ʋ yi, ‑ɛ mɔ, ‑tɛblɩ a pɛpɛ ‑bʋ, ‑kɔ ‑tɩ ‑hla wɛn, ɛ kɔ bʋ mu 'lu ‑mɔ?» ");
INSERT INTO ktj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ, ɛ wɛn: «Ba nɩ 'ʋ ‑pleelɛ', ‑ɛ di꞊e nu, nyiblo ꞊dʋ 'nɩ ꞊ha 'a mʋ ‑kaa ‑nɩ, ");
INSERT INTO ktj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","‑kɔtɩ nyibli ‑hʋɔhʋɩ di 'nɩ di, 'kɩ 'lɩ 'na 'nyrɛ 'kwli, ʋ 'mʋ lɛ pʋ, ʋ nʋ‑ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya, 'tɩ‑ ʋ 'mʋ nyibli ‑hʋɔhʋɩ ‑kaa ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","'Ya 'ʋ 'lu de, a di 'nɩ 'wɩn, ‑ɛ mɔ, ʋ ‑wɛn tʋ, 'kɩ 'lɩ 'blʋgbɩ ‑mʋ' kɩ, ‑ʋ 'mʋɛ nɛ 'a mʋ yrɛ, kɔ, ‑ʋ hlɔɔ nɛ 'a mʋ ‑mɔ lɛ. 'Bʋ mɔ, 'ba yɩ nɩ 'wɩn, a 'nɩ 'pie 'lɩ hʋannʋ, ‑ɛ nu꞊o, ‑tɛblɩ a 'mʋ, ɛ kɔ bʋ mu 'lu ‑mɔ. Kɛɛ, 'bʋ yɩ 'lu ‑mɔ nɩ mi, ɛ 'yɩ 'nyrɛ ꞊hɛn, ‑ɛ mɔ, 'klɔ a 'ʋ‑hɔnti nyre 'ʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","'Blʋgbɩ di yɩ 'nɩ ‑wʋnwɔn ‑nɩ. 'Kɩ 'lɩ 'blʋgbɩ ‑hʋɔhʋɩ 'kwli, ‑tʋtʋ di 'nɩ 'hɩhlɛ ‑nɩ, kɔ, 'kanʋ di 'nɩ ꞊tɩ. 'Kla‑wliye'yɩya a 'mʋ, ‑ɛ di di, 'klɔ a 'ʋ‑hɔnti, ɛ nɔ‑ kɔ ‑wlu꞊tutuo ꞊nɩɔ. Kɛɛ, 'klɔ a 'mumu, ɛ 'yɛɛ 'ʋ ‑wlu nɩ ‑hʋɛn. Ɛ 'wɩ‑ nʋgba ‑nɩ 'kwli yɩ, ‑ɛ kɔ 'kwli ‑tʋa kɩkla, kɛɛ ‑kɔ ꞊gbʋgblati ꞊yɛɛ 'ʋ nɩ nyre. ");
INSERT INTO ktj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","‑Tɛblɩ a 'mʋ, 'bʋ yɩ 'lu ‑mɔ nɩ mi, ba nɩ 'ʋ ‑pleelɛ'. Ʋ kɔ bʋ gba 'lɩ 'a mʋ ‑batipʋʋlɛ', ɛ kɔ, ʋ di 'a mʋ 'nɩ bi, 'kɩ 'lɩ Nyɩsʋa a 'kayo blɛ. ‑Tɛ a mɔ 'na ‑nagbopʋ a ‑tɩ, ʋ kɔ bʋ yɛɛ nɛ 'a mʋ ‑tɩ, 'kɩ 'ʋ 'blʋnaanyʋ kɔ 'kɩɩnpʋ ye'. Ɛ nɔ‑ di꞊e nu, a 'mʋ ꞊nʋ 'na ꞊haantitie pʋ. ");
INSERT INTO ktj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ɛ blɛɛ yɩ, 'na ‑nagbopʋ bʋ pʋ 'na ꞊haantitie 'klɔ ‑bʋ 'a dakɔ a pɛpɛ, 'tɩ‑ 'klɔ a 'ʋ‑hɔnti 'mʋ 'ʋ nyre. ");
INSERT INTO ktj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","'Bʋ klɔ 'a mʋ, 'kɩ ʋ 'mʋ 'lɩ 'a mʋ ‑batipʋnyʋ yɩ gba a ‑tɩ, 'kla 'nɩ 'yaa 'lɩ 'a mʋ ‑wliye, 'kɩ 'ʋ ‑tɩ ‑mʋ', a di hla a ‑ta'. Win ‑mʋ', a di pʋ, ti a 'mʋ 'yri, Nyɩsʋa, nɔ‑ di 'a mɔ꞊ɔ wlɔn ꞊tu. Ɛ 'yɩ 'aan ꞊gbɛtʋ 'pa‑, a 'nɩ ‑hle꞊e nɩ, kɛɛ, Nyɩsʋa a ‑Hihiu*, ‑ɛ nɩ 'ʋ 'a mʋ ke', ɛ nɔ‑ di hle. ");
INSERT INTO ktj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ti a 'mʋ 'yri, 'dɩayɩnʋ, nʋ‑ di 'waa 'dɩayɩnʋ 'blʋ a naanyʋ ꞊jrɛ pʋ, 'waa 'lɩla a ‑tɩ. Dɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ 'baɩnʋ di 'waa 'yonʋ ‑mɔ nu, 'yonʋ 'mʋ꞊ʋ 'waa 'baɩnʋ kɔ 'waa 'diinʋ 'hʋɛn‑ ‑mɔ nu. ");
INSERT INTO ktj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nyibli a pɛpɛ kɔ bʋ yraa nɛ 'a mʋ, ‑tɛ a mɔ 'na nyibli a ‑tɩ. Kɛɛ, nyiblo 'bʋ 'yɩ ‑sa, 'kɩ 'ʋ Nyɩsʋa a ꞊wlʋ a yɩkuolɛ ‑mɔ', 'bʋ gba꞊a 'lu ‑mɔ ‑gbagba, 'klɔ a 'ʋ‑hɔnti 'bʋ nyre 'ʋ, nyiblo a 'mʋ, ɛ nɔ‑ Nyɩsʋa di wa.» ");
INSERT INTO ktj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Nyiblo ‑bʋ, ‑ɛ di win ‑bʋ ‑hre, ɛ blɛɛ yɩ, bʋ kɔ ꞊tɔ, 'tɩ‑ ɛ 'mʋ꞊ʋ' lɛ yru. Win a 'mʋ, ɛ nɔ‑ ‑bʋ: Ɛ di kɔ ti ‑bɩ, a 'mʋ yɩnyredɛ 'ye, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ. Yɩnyredɛ a 'mʋ, Nyɩsʋa a ꞊wlʋ yraa ꞊nɛ nɩ, 'tɩ‑ dɛ a 'mʋ, 'ɛ ni꞊e, Nyɩsʋa 'ɛ hlʋɛ nɛ 'a 'kagbaʋ ‑mɔ lɛ. Yɩnyredɛ a 'mʋ, ‑tɩtɛ ɛ 'yɩ 'ʋ ‑kɔ, 'kɩ ɛ di 'ʋ nɩ. 'Bʋ mɔ, 'ba 'ye dɛ a 'mʋ, ‑ɛ ‑bɩ nyibli ‑mʋ', ‑ʋ nɩ 'lɩ Sudeblʋgba 'kwli, bʋ 'gba ci lɛ, bʋ mu 'lɩ dʋgbɩ 'lu, ʋ 'nɩ ꞊ha ꞊nʋ lɛ 'lɩla ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nyiblo 'bʋ nɩ 'lɩ 'a 'kayu a ‑yaa 'kwli, bʋ 'gba ci lɛ ‑dodo. Ɛ 'nɩ 'pʋʋ 'lɩ lɛ, bʋ pa 'lɩ 'a 'kayu bʋ, ɛ 'mʋ 'a kʋkɔ‑tɛblɩ bla, 'tɩ‑ ɛ 'mʋ ci lɛ 'gba. ");
INSERT INTO ktj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nyiblo 'bʋ nɩ 'lɩ 'a ‑ci kɩ, bʋ 'gba ci lɛ ‑dodo. Ɛ 'nɩ 'pʋʋ 'lɩ lɛ, bʋ ꞊hɩan ‑mɔ, bʋ bla 'a wlawlɩ, 'kɩ 'lɩ 'dɩɔ 'kwli, 'tɩ‑ ɛ 'mʋ ci lɛ 'gba. ");
INSERT INTO ktj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ti a 'mʋ 'yri, nʋgbɩ ‑mʋ', ‑ʋ di 'kwli lɛ nɩ, ɛ kɔ 'waa dɛ ‑mʋ', ‑ʋ di 'yonʋ 'nya, ʋ di 'ye ꞊hɩʋɛn dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ba da Nyɩsʋa, ‑tɛblɩ a 'mʋ, ɛ 'nɩ ꞊ha 'lu ‑mɔ mu, a 'nɩ ꞊ha ci lɛ 'gba, ti ‑mʋ' ‑kɔ 'yri cɛ yɩ 'ʋ ꞊tɩɩ ‑nɩ, ");
INSERT INTO ktj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","‑ɛ nu꞊o, ‑nyrɔwɩ a 'mʋ 'kwli, ꞊hɩʋɛn ‑tonyibli di 'ye, ɛ di 'nɩ 'bʋa, ɛ 'mʋ 'a dɛ ‑mʋ', ‑tonyibli ‑tʋa la 'lɩ 'yiye 'ʋ ‑hi, kʋɛ la 'lɩ ‑tɛ Nyɩsʋa nu la 'klɔ 'yie bʋ, ‑bʋ yɛ ti ‑bʋ, ‑a nɩ kɩ. Kʋɛ 'lɩ ꞊hɩʋɛn a 'yiye gbagbʋ a 'mʋ a ti 'yie bʋ, ‑bʋ yɛ 'klɔ a 'ʋ‑hɔnti kɩ, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ 'ye ꞊hɩʋɛndʋ a 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nyɩsʋa di ꞊tɩɔ ‑nyrɔwɩ a 'mʋ 'lu, 'kɩ 'ʋ nyibli ‑mʋ', ɛ ‑ha 'lɩ, 'kɩ ‑bʋ mɔ 'a nyibli a ‑ta'. Ɛ nɔ‑ 'yɩ wɛn꞊ɛ 'pa‑, nyiblo ꞊dʋ 'yɩ wɛn 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nɩ wɛn 'klɔ, ti a 'mʋ 'yri. ");
INSERT INTO ktj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ti nɩ ‑do a 'mʋ 'yri, nyiblo 'bʋ lee nɛ 'a mʋ, 'bʋ pʋ lɛ: Ba 'ye kɛ, Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya, 'kɩ ɛ nɩ 'nɛ‑, ‑hʋʋ', 'kɩ ɛ nɩ 'lɩ ‑tɩtɛ ‑mʋ', a 'nɩ 'pʋʋ 'lɩ꞊ɩ ꞊haan‑tɩ, ");
INSERT INTO ktj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","‑ɛ nu꞊o, hɩwanyʋ, kɔ hɩwinwlɔn‑hanyʋ di 'nɩ 'hrɩ, ʋ 'mʋ ꞊wlɩlɛkɛɛ‑tɛblɩ a gblegble nu, ‑ɛ di꞊e nu, 'bʋ ‑wɛ 'lɩ꞊ɩ, ʋ 'mʋ nyibli ‑mʋ', Nyɩsʋa ‑ha 'lɩ, 'kɩ bʋ mɔ 'a nyibli ‑kaa ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","'A ‑tɩ, 'a mʋ ‑mɔ ‑bɩ, ba nɩ 'ʋ ‑pleelɛ', ‑ɛ nu꞊o, ‑tɛblɩ a pɛpɛ a 'mʋ, ‑ɛ di 'lu ‑mɔ mu, ɛ nɩ ke', 'nɩ yɩ 'a mʋ ‑lee ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«꞊Hɩʋɛn'yeti a 'mʋ, 'bʋ ‑hi, ‑ɛ ‑bɩ 'yrʋ kɔ ꞊hɔnpʋ 'hʋɛn‑, ʋ di 'nɩ jre, ");
INSERT INTO ktj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","nyahro di ble 'lɩ yakɔ 'kwli lɛ, ɛ kɔ, ‑tɛblɩ a pɛpɛ ‑mʋ', ‑ɛ nɩ 'lɩ yakɔ 'kwli, ɛ 'mʋ ‑ta' lɛ ‑hɔn. ");
INSERT INTO ktj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ti nɩ ‑do a 'mʋ 'yri, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, nyibli di 'mʋ 'nɩ 'ye. 'N di 'nɩ di, 'kɩ 'lɩ 'na 'klɩkɩnɩnɩɩ 'kwli, kɔ 'kɩ 'lɩ 'na ‑tɩ a 'yi'bʋalɛ 'kwli. 'Bʋ mɔ, 'nɩ yɩ nɩ di, 'kɩ 'n di 'lɩ 'nuŋmɩ 'nyɩ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","'N di tɛ Nyɩsʋa a lɛlenyʋ bʋ, ʋ 'mʋ 'klɔ ‑bʋ 'a ꞊gɛ a pɛpɛ kɩ na, nyibli ‑mʋ', Nyɩsʋa ‑ha 'lɩ, 'kɩ bʋ ‑hɛ 'a nyibli, ʋ 'mʋ ꞊nʋ lɛ 'kukue ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Ba 'ye kɛ tugbɛ ‑mʋ', ʋ dɛɛ figie. 'Kɩ 'ʋ tugbɛ a 'mʋ 'yie, tɔɔlɛ nɩ 'ʋ. Ɛ nɔ‑ mɔ, ti ‑mʋ' ‑kɔ 'yri ɛ ꞊tui 'ʋ babʋɩ yrayrɩ lɛ, ɛ kɔ, 'a hawi 'bʋ yɩ nɩ ꞊gɛ, ‑ɛ ‑bɩ ‑a yi꞊e nɩ, ‑ɛ mɔ, ‑cii‑ci‑nyrɛ 'mʋɛ yrɛ. Kɛ‑ 'na didie di 'mʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","‑Tɛblɩ a pɛpɛ ‑bʋ, ‑kɔtɩ 'n hla wɛn, 'bʋ yɩ 'lu ‑mɔ nɩ mi, ‑ɛ ‑bɩ ba kɔ 'a yiyie, ‑ɛ mɔ, 'na diditi 'mʋɛ yrɛ. Ɛ 'wɩ yɩ, 'kɩ 'n nɩ 'ʋ 'maju 'yri. ");
INSERT INTO ktj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, nyibli ‑bʋ, ‑ʋ nɩ 'klɔ, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ 'kʋ, 'tɩ‑ ‑tɛblɩ a pɛpɛ a 'mʋ, ɛ 'mʋ 'ʋ nyre. ");
INSERT INTO ktj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yakɔ kɔ ‑tʋtʋ 'hʋɛn‑, ʋ di bʋ 'nɩ ‑wɛ, kɛɛ, 'na win 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑wɛ bʋ, 'klɔ ‑mɔ 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ de: «Ti ‑mʋ', lɛ'bɔɔ‑nyrɔwɔ bʋ di 'ʋ ‑nyre, ɛ 'yɩ nyiblo ꞊dʋ ‑kɔ, ‑bʋ yi ‑nyrɔwɔ a 'mʋ. Ɛ mɔ, 'mɔ ‑bʋ, ‑ɛ mɔ Nyɩsʋa a 'Yu, 'n kɔ 'a lɛlenyʋ 'hʋɛn‑, ‑ɛ ꞊dʋ 'yɩ 'ʋ ‑nɩ, ‑ɛ yi ‑nyrɔwɔ a 'mʋ, 'bʋ 'yɩ 'na 'Baɩ Nyɩsʋa nɩ ‑do 'pa‑. ");
INSERT INTO ktj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ba nɩ 'ʋ ‑pleelɛ', a 'nɩ 'ŋmee 'lɩ, ‑kɔtɩ a 'yɩ lɛ'bɔɔ‑nyrɔwɔ a ti ‑yi. ");
INSERT INTO ktj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","'Na mumuo kɔ 'na 'lɩdidie 'hʋɛn‑, ɛ di 'wɩ‑ nyɩbɛyu ꞊dʋ yɩ, ‑ɛ mi la 'dagba blɔblʋ. Nɔ‑ hie la 'a 'kayu 'a ‑kʋannunyibli lɛ. 'Tɩ‑ ɛ 'mʋ la mu, ɛ ꞊gla la ‑kʋan nɩ. 'A ‑nɛ ‑kʋannunyɔ 'bʋ nɩ 'ʋ, ɛ ‑nyi la꞊a 'a ‑nɛ ‑kʋandɛ nɩ, ɛ di la nu. ‑Ɛ ‑bɩ kɛ‑ ɛ pɩ la 'kayu'yie꞊tunyɔ yɩ, ɛ wɛn: ꞊Tu 'kayu 'yie, ꞊nɩ 'ŋmee 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","'A ‑tɩ o, ba nɩ 'ʋ ‑pleelɛ', a 'nɩ 'ŋmee 'lɩ, ‑ɛ nu꞊o, ti, 'kayukɔnyɔ di ya, a 'yɩ꞊ɩ ‑yi. ‑Baklɛ ‑winse, ‑baklɛ 'tɔ‑hɛyri', ‑baklɛ mu ‑nyrɛ a ‑nyɛɛlɛ 'yie, ‑baklɛ ‑nyrajru', 'kɩ ɛ di 'ʋ nyree ‑nɩ. A 'yɩ 'a ꞊dedede ‑yi. ");
INSERT INTO ktj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","'Bʋ ꞊hɩan ‑mɔ ti nɩ ‑do a ti 'yri, ɛ 'yɩ yɩ ‑blɛɛ ‑nɩ bʋ yɛɛ 'ʋ 'a mʋ ŋmenaŋmeelɛ' bʋ. ");
INSERT INTO ktj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ɛ nɔ‑ mɔ ‑tɩ 'n ‑hʋɛ ꞊bʋ lee wɛn 'a mʋ, a kɔ nyibli a pɛpɛ 'hʋɛn‑: Ba nɩ 'ʋ ‑pleelɛ', a 'nɩ 'ŋmee 'lɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ɛ hie 'lɩ ‑nyrɔwɩ nɩ 'hʋɛn, ‑Juukʋɛ a lɛ'mimle gbagbʋ ‑bɩ 'mʋ 'ʋ nyre. Lɛ'mimle a 'mʋ, 'a 'nyrɛ mɔ Pakɩ. Pakɩ a 'mʋ a ti 'yri, 'flɔɔdʋ ‑mʋ', ‑ɛ kɔ ‑mɔ ʋ 'yɛ nɩ pʋ 'lɩ 'a 'yaadɛ, ɛ nɔ‑ ʋ yɩ di. ‑Ɛ ‑bɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ, ʋ kɔ tetetɔɔnyʋ 'hʋɛn‑, ʋ ꞊mʋɛ ꞊tɔ lɛ, ʋ 'mʋ ‑Yusu klɔ, 'kɩ 'lɩ ꞊yrɛ 'kwli, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ 'la. ");
INSERT INTO ktj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kɛɛ, ʋ wɛn: «'Bʋ mɔ, ꞊ba yɩ꞊ɩ nɩ kwlɛ, ‑a 'nɩ 'nuo 'lɩ꞊ɩ lɛ'mimle a ti 'yri, ‑ɛ di꞊e nu, nyibli 'nɩ ꞊ha ‑a mʋ ‑mɔ ‑wɔn mɔ di.» ");
INSERT INTO ktj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ti a 'mʋ 'yri, 'kɩ ‑Yusu nɩ 'lɩ Betanidɩɔ 'kwli, ɛ kɔ 'a ‑nagbopʋ* 'hʋɛn‑. 'Kɩ ʋ nɩ 'lɩ Simɔ a ‑tɛ. Simɔ a 'mʋ, ꞊hran nu la꞊a nɩ. Bʋ yɩ 'kɩ dɛ nɩ di, ‑ɛ ‑bɩ nʋgba ꞊dʋ, ɛ nɔ‑ pa 'kayu bʋ, 'ɛ 'ble ‑dawinniyrɩɛ kʋa. ‑Dawinni a 'mʋ, ɛ kɔ 'a 'yrɩɛ 'hʋɛn‑, ɛ pɩ ꞊die dɩakɩ. ‑Tɛ ɛ ‑pa 'kɩ, ‑ɛ ‑bɩ ɛ 'bɛ 'ʋ 'yrɩɛ a 'mʋ a 'lu nɩ, 'tɩ‑ 'ɛ pʋ ‑dawinni a 'mʋ ‑Yusu 'lu. ");
INSERT INTO ktj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nyibli ‑nɩ 'ʋ, 'waa dɛ ‑bɩ a plɔ 'yɩ ‑ble, ʋ wɛn: «Dɛ‑ kɔ ‑dawinni ‑bʋ, 'a lɛcɩcralɛ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","'Bʋ plo wɛn꞊ɛ, ɛ di 'ye wɛn 'wliyɛ dɩakɩ, ‑ɛ ‑wɛ 'lɩ ‑kʋannunyɔ ‑bɩ a 'pɛɛlɛ, 'kɩ 'lɩ 'yrʋ 'mumu 'kwli, ʋ 'mʋ wɛn꞊ɛ ꞊hɩʋɛnnyibli ‑nyi.» Kɛ‑ ɛ ꞊ti 'mʋ, 'ʋ yɩ nʋgba a 'mʋ ‑mɔ 'plɛ. ");
INSERT INTO ktj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","‑Ɛ ‑bɩ ‑Yusu wɛn: «Ba ‑ha꞊a mɛ lɛ, ba 'kee nɛ 'a ‑mɔ'pʋplɛ. Dɛ ‑bʋ, ɛ ‑nu, 'kɩ 'ʋ 'mʋ ‑mɔ, ɛ mɔ yɩnɔdɛ. ");
INSERT INTO ktj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ba kɔ 'a yiyie, ꞊hɩʋɛnnyibli 'tɩɛ di 'nɛ‑ 'a mʋ 'nyɩ nɩ. Ti ‑mʋ' kɔ 'yri a di 'ʋ꞊ʋ ‑hʋa, a ‑wɛ 'lɩ ba nu ꞊nʋ ꞊haandɛ ‑mɔ nɩ. 'Mɔ ‑bɩ, ti ‑mʋ', 'n di 'nɛ‑ 'a mʋ 'nyɩ ‑hi, ɛ 'yɩ ‑hʋ. ");
INSERT INTO ktj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dɛ nʋgba ‑bʋ, ɛ ‑wɛ 'lɩ, ɛ nɔ‑ ɛ ‑nu: Ti nɩ ke', 'ɛ ‑wɛ 'na ‑plahʋɩ ‑dawinni a pʋpʋʋ ‑mɔ, 'kɩ 'ʋ 'na ‑hɩhɩa a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ, 'a ‑nɛ ‑tɩtɛ ꞊dʋ, ʋ di 'ʋ Nyɩsʋa a ꞊haantitie 'ʋ ‑pʋʋ ‑nɩ, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, ꞊haandɛ ‑bʋ, nʋgba ‑bʋ, ɛ ‑nu, ʋ di 'a ‑tɩ ‑mɔ lɛ 'nɩ na, ‑ɛ di꞊e nu, ɛ 'nɩ ꞊ha nyibli ‑mɔ ‑hru.» Kɛ‑ ‑Yusu ‑pʋ. ");
INSERT INTO ktj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ Judɩa Yisikalio, ‑ɛ mɔ ‑Yusu a ‑nagbopi* ‑bɩ, 'kɩ 'lɩ 'a ‑nagbopʋ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn a 'mʋ 'nyɩ, ɛ nɔ‑ mu 'lɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ ‑mɔ, 'ɛ mu la ꞊nʋ 'ye mɔ, ‑tɛ ‑mʋ', ɛ di ꞊nʋ ‑Yusu a ‑jɩ'pʋpʋʋ nu a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","‑Tɛ ɛ pʋ 'kuna, ‑ɛ ‑bɩ ʋ ‑tʋa dɔdʋ a nunuo dɩakɩ, ʋ wɛn: «‑A di ‑nyi ‑mʋ 'wliyɛ.» Kʋɛ 'lɩ ti a 'mʋ 'yri bʋ, Judɩa ꞊mʋɛ 'kɩ ꞊tɔ lɛ, ‑tɛ ‑mʋ', ɛ di ꞊nʋ ‑Yusu a ‑jɩ'pʋpʋʋ nu. ");
INSERT INTO ktj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Lɛ'mimle ‑mʋ', ‑ɛ mɔ Pakɩ, 'a yɩ‑hɛ‑nyrɔwɔ, 'kɩ ʋ yɩ 'ʋ 'flɔɔdʋ ‑mʋ', ‑ɛ kɔ ‑mɔ ʋ 'yɛ nɩ pʋ 'lɩ 'a 'yaadɛ ‑dii ‑nɩ, 'ʋ 'lɛɛ 'ʋ 'blayonʋ lɛ ‑wɛ, 'kɩ 'ʋ dididɛ gbagbʋ a 'mʋ a ‑ta'. ‑Tɛ ‑nyrɔwɔ a 'mʋ, ɛ nyre 'ʋ, ‑ɛ ‑bɩ ‑Yusu a ‑nagbopʋ wɛn: «Tɔɔnyɔ o, ‑bɩ' ‑hʋɛ ‑ba pii 'kɩ Pakɩ a diidɛ yɩ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","‑Ɛ ‑bɩ ɛ lee nɛ 'a ‑nagbopʋ nɩ 'hʋɛn ‑bɩ, ɛ wɛn: «Ba mu Jrusrɛdɩɔ 'kwli. A kɔ nyiblo ꞊dʋ 'hʋɛn‑, a di 'nɩ ꞊ŋmee ‑nɩ. Nyiblo a 'mʋ, ɛ 'ble 'nɩya. Ɛ nɔ‑ ba kʋɛ ꞊wien. ");
INSERT INTO ktj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","'Kayu ‑mʋ', ‑ɛ kɔ bʋ ɛ di 'lɩ pa, kɛ‑ ba pʋ 'a kʋkɔnyɔ yɩ: ‑Aan tɔɔnyɔ yɩ 'nɩ 'bɛti ‑nɩ: ‑Gblo a 'dɩ ‑bɩ ‑kɔ 'kwli, ɛ kɔ 'a ‑nagbopʋ 'hʋɛn‑, ʋ di 'lɩ 'waa Pakɩ a diidɛ 'lɩ ‑dii ‑nɩ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","‑Ɛ ‑bɩ ‑Yusu wɛn 'nɩ de: Ɛ di tɔɔ nɛ 'a mʋ ‑gblo gbagbʋ, 'kɩ 'lɩ 'a yɔ'kayu a 'mʋ, 'a yɩ‑hɛ‑gbɔ yra. 'Kɩ 'kayu a ‑tɛblɩ a pɛpɛ ꞊cɛɛ 'lɩ. 'Kɩ ba pii 'lɩ ‑aan diidɛ,» ");
INSERT INTO ktj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","‑nagbopʋ nɩ 'hʋɛn a 'mʋ, 'ʋ mu 'lɩ Jrusrɛdɩɔ 'kwli. 'Tɩ‑ ʋ 'mʋ 'lɩ nyre, 'ɛ mɔ ꞊han‑tɩ, ‑tɛ ‑Yusu nu wɛn 'a hɩhla, kɛ‑ ʋ nu 'ʋ ‑tɛblɩ a 'mʋ, 'a bʋyɛɛlɛ, 'ʋ bi 'ʋ, 'ʋ pi Pakɩ a diidɛ a 'mʋ. ‑Tɛ ʋ ‑wɛ 'a pipie ‑mɔ, ‑ɛ ‑bɩ ʋ ‑mɛ kle. ");
INSERT INTO ktj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","‑Tɛ 'yrʋ ‑wɛ 'lɩ yakɔ 'kwli lɛ, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn a 'mʋ 'hʋɛn‑, ʋ nyre 'lɩ 'kayu ‑mʋ', ‑ɛ kɔ bʋ ʋ di 'lɩ Pakɩ a diidɛ 'lɩ ‑dii ‑nɩ 'kwli nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bʋ yɩ 'kɩ dɛ nɩ di, ‑ɛ ‑bɩ ‑Yusu wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ, nyiblo nɩ 'nɛ‑ 'a mʋ 'nyɩ, ‑ɛ kɔ 'mʋ 'hʋɛn‑ ‑yɩ dɛ di. Ɛ nɔ‑ di 'mʋ 'na yraanyibli, ‑ʋ ꞊mʋɛ 'na 'lɩla lɛ ‑jɩ' pʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bʋ 'wɩn ‑tɩ a 'mʋ, ‑Yusu ‑hla, ‑ɛ ‑bɩ 'waa ꞊wlɩ 'mʋɛ bʋ dɩakɩ. Kɛ‑ 'waa dodoyo pɩ, 'ʋ yɩ 'bɛti ‑nɩ: «꞊Bɩ 'mɔ ꞊nɩɔ?» ");
INSERT INTO ktj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «'Kɩ 'lɩ 'a mʋ 'nyɩ, ‑ʋ mɔ 'na ‑nagbopʋ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn, 'kɩ nyiblo a 'mʋ, ɛ nɩ 'lɩ, ɛ kɔ 'mʋ 'hʋɛn‑, ‑a 'nyrɛ 'lɩ dɛdihu nɩ ‑do dabʋ 'kwli. Ɛ nɔ‑ di꞊e nu. ");
INSERT INTO ktj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","'Ɛ mɔ ꞊han‑tɩ, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n kɔ ꞊bʋ 'kʋ, ꞊wɩ yɩ, ‑tɛ ʋ nu la 'a 'cɩcrɩɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, kɛɛ, 'jrɔ 'kɩ 'ʋ nyiblo ‑mʋ' ‑mɔ, ‑ɛ di 'mʋ 'na yraanyibli ‑jɩ' pʋ. Ɛ nɔɔ 'ʋ lɛ, 'kɩ ʋ 'nɩ 'kɔɔ wɛn 'lɩ nyiblo a 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Bʋ 'tɩɛ nɩ 'ʋ dɛdiilɛ', ‑ɛ ‑bɩ ‑Yusu 'du 'flɔɔ ye', 'ɛ ‑nyi Nyɩsʋa 'wio, 'tɩ‑ 'ɛ 'bɛ꞊ɛ ꞊tɩɔ lɛ, 'ɛ ‑nyi꞊e 'a ‑nagbopʋ*, ɛ wɛn: «Ba 'du꞊o ye', ba di꞊e. Ɛ nɔ‑ mɔ 'na 'hʋɩ,» ");
INSERT INTO ktj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","'ɛ 'du ‑wiin‑ŋanʋ ye', 'ɛ ‑nyi Nyɩsʋa 'wio, 'ɛ ‑nyi ꞊nʋ꞊ʋ, 'waa pɛpɛ 'ʋ 'na꞊a. ");
INSERT INTO ktj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","‑Ɛ ‑bɩ ɛ wɛn: «Ɛ nɔ‑ mɔ 'na ‑hlʋ. Ɛ nɔ‑ 'n di bʋ 'wla, 'kɩ 'ʋ ‑tonyibli ‑hʋɔhʋɩ a ‑ta', Nyɩsʋa 'mʋ꞊ʋ nu, ɛ 'mʋ 'yrɩ yrayrɩ ꞊tu, ɛ kɔ ‑tonyibli 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ, kʋɛ 'nɛ‑ ti ‑bʋ 'yie bʋ, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ 'na 'kɩ nɔdʋ ‑bʋ de, ɛ 'mʋ ‑nyrɔwɔ ‑mʋ' kɩ yɛ, ‑ɛ kɔ 'kwli 'n di 'lɩ nɔ yrayrɩdʋ ‑bɩ ‑mʋ' 'lɩ 'naa ‑nɩ, 'kɩ 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ʋ ble ‑wla, 'tɩ‑ ʋ 'du ye', 'ʋ ꞊tɩ 'dɩɔ, 'ʋ mu 'lɩ dʋgba ‑mʋ' 'lu, ‑ɛ kɔ 'lu olifieti nɩ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","‑Tɛ ʋ nyre 'lɩ, ‑ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'a ‑nagbopʋ* yɩ, ɛ wɛn: «Ti di 'ʋ 'nɩ nyre, a 'mʋ 'ʋ 'mʋ 'hʋɩ lɛ ‑gbɛ, ꞊wɩ yɩ, ‑tɛ ʋ nu la 'a 'cɩcrɩɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ: Nyɩsʋa wɛn 'nɩ: 'N di 'blakɔnyɔ 'nɩ 'la, blablɩ 'mʋ ‑gbɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ de, ɛ wɛn: «'Bʋ mɔ, 'nɩ 'kʋ, 'nɩ 'hrɩ 'klɔ, 'kɩ 'n di 'lɩ Galileblʋgba 'kwli mu, 'mʋ 'lɩ 'a mʋ 'lɩ ‑plee ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","‑Ɛ ‑bɩ Piɛlɩ wɛn: «'Ye ꞊bɩɩ 'waa pɛpɛ bʋ hie 'ʋ ‑mʋ bʋ, 'mɔ ‑bʋ, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ hie 'ʋ ‑mʋ bʋ 'klɔ ‑mɔ 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","‑Ɛ ‑bɩ ‑Yusu wɛn: «'N yɩ ‑mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ: 'Kɩ 'lɩ 'tɔlʋwɔ nɩ ‑do ‑bʋ 'kwli, 'tɩ‑ hapɛ 'mʋ ‑nyrɛ a daawɩ nɩ 'hʋɛn nu, ‑di nu ‑gaawɩ nɩ ta, ‑ɛ mɔ, ꞊yɩ 'mʋ ‑yi.» ");
INSERT INTO ktj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","‑Ɛ ‑bɩ Piɛlɩ 'yaa 'lɩ win, 'ɛ ꞊tu꞊o ꞊wɔn, ɛ wɛn: «'Ʋʋn‑, 'ye ꞊bɩɩ 'n di 'kʋ, 'n kɔ ‑mʋ 'hʋɛn‑, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ hla꞊a, ‑ɛ mɔ, 'n 'yɩ ‑mʋ ‑yi.» 'Waa pɛpɛ, ‑tɩ nɩ ‑do a 'mʋ, Piɛlɩ ‑hla, ɛ nɔ‑ ʋ ‑hla ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ 'kɩ ʋ nyre 'lɩ 'dʋdɔti a ‑ci ‑mʋ', ʋ dɛɛ Gɛsɩmanɩ 'kwli. ‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'kɩ 'a ‑nagbopʋ* yɩ, ɛ wɛn: «Ba nɩ mɔ bʋ, ꞊bʋ mu 'lɩ ye', 'mʋ 'lɩ Nyɩsʋa ‑mɔ ‑hlee ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Bʋ yɩ 'kɩ nɩ mi, ‑ɛ ‑bɩ ɛ da Piɛlɩ kɔ Saan kɔ Sakɩ nɩ, ɛ kɔ ꞊nʋ 'hʋɛn‑ 'ʋ ‑mu. Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ 'a ꞊wlʋ 'mʋɛ bʋ. Hʋannʋ ni꞊e nɩ dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «'Na ꞊wlʋ 'mʋɛ bʋ dɩakɩ. 'Na ꞊wlʋ a bʋ'mʋmʋɛ a 'mʋ, ɛ ‑hʋɛ bʋ 'la 'mʋ. Ba nɩ mɔ bʋ, a 'nɩ 'ŋmee 'lɩ,» ");
INSERT INTO ktj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","'ɛ hlɔɔ ꞊nʋ ‑mɔ lɛ dɛ gbe, 'ɛ 'gbla kwlɩ, 'ɛ nyɛɛ Nyɩsʋa lɛ, 'bʋ mɔ, 'bʋ ‑wɛ 'lɩ꞊ɩ, 'kɩ 'a ꞊hɩʋɛn'yeti ‑mʋ', ‑ɛ di 'lɩ di, bʋ hlɔɔ ꞊nɛ ‑mɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ɛ wɛn: «'Na 'Baɩ o, ‑wɛ 'lɩ 'a ‑nɛ dɛ nɩ. Nu꞊o, ꞊hɩʋɛn ‑bʋ, 'n mi 'ye mɔ, bʋ hlɔɔ 'mʋ ‑mɔ lɛ. Kɛɛ, ɛ 'nɩ 'mɔɔ 'lɩ dɛ ‑bʋ, 'n ‑hʋɛ, kɛɛ, bʋ mɔ dɛ ‑mʋ', ‑hʋɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Bʋ nu 'kɩ 'pʋplɛ lɛ, ‑ɛ ‑bɩ ɛ ꞊hɩan ‑mɔ, 'ɛ mu 'ʋ 'a ‑nagbopʋ nɩ ta a 'mʋ 'hʋɩ, 'ɛ yɛɛ 'ʋ ꞊nʋ ŋmena a ŋmeelɛ' bʋ. ‑Ɛ ‑bɩ kɛ‑ ɛ pɩ Piɛlɩ yɩ, ɛ wɛn: «Simɔ, ꞊bɩ ‑yɩ 'nɩ ŋme? ꞊Yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, 'kɩ ‑bʋ 'yɩ ‑ŋme, 'kɩ 'lɩ ‑haawɔ nɩ ‑do 'kwli? ");
INSERT INTO ktj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","A 'nɩ 'ŋmee 'lɩ, kɛɛ, ba da Nyɩsʋa, ‑ɛ di꞊e nu, dɛ 'bʋ yɩ꞊ɩ nɩ ‑hʋɛ bʋ ꞊tɛɛ 'ʋ 'a mʋ lɛ, 'kɩ ba ‑hɛɛ Nyɩsʋa a ‑tɩ lɛ, a 'nɩ ꞊ha 'a ‑tɩ lɛ ‑hɛɛ ‑nɩ. 'N yi꞊e nɩ, ‑ɛ mɔ, 'aan ꞊wlɩ ‑hʋɛ꞊ɛ nɩ dɩakɩ, 'kɩ a 'nɩ 'ŋmee 'lɩ, a 'mʋ Nyɩsʋa da, kɛɛ, 'bʋ mɔ, Nyɩsʋa 'bʋ 'yɛ nɩ ‑hɛɛ nɛ 'a mʋ, 'a mʋ nɩ ‑do, a 'yɩ 'klɩ ‑kɔ, 'kɩ ba nu dɛ a 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ɛ hlɔɔ ꞊nʋ ‑mɔ lɛ de, 'ɛ ‑tʋa Nyɩsʋa a lɛnyaalɛ de, 'kɩ 'lɩ win nɩ ‑do ‑mʋ', ɛ pʋ wɛn 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","‑Tɛ ɛ ‑wɛ ‑mɔ, 'ɛ ꞊hɩan ‑mɔ, 'ɛ mu 'ʋ ꞊nʋ 'hʋɩ, 'ɛ yɛɛ 'ʋ ꞊nʋ ŋmena a ŋmeelɛ' bʋ de, ‑ɛ nu꞊o, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ pʋ 'yii lɛ. ‑Tɛ ʋ ꞊wlɛ 'kɩ 'yii, ‑tɛ bʋ di꞊e yɩ pʋ, ʋ 'yɩ꞊ɩ ‑yi. ");
INSERT INTO ktj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","‑Ɛ ‑bɩ ɛ mu nɩ de, 'tɩ‑ 'ɛ ꞊hɩan ‑mɔ de, 'wɩ nɩ ta a dɛ, ‑ɛ ‑bɩ ɛ wɛn: «꞊Bɩ a yɩ 'nɩ ŋme de, 'a ‑hɛ 'lɩ ke lɛ? Ɛ 'yɩ 'kɩ ŋmuŋmeti 'pa‑. Ba 'ye kɛ, ti nyre 'ʋ nɩ, 'kɩ bʋ pʋ 'mʋ dɛ'kukununyʋ ‑jɩ', 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo. ");
INSERT INTO ktj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ba 'du ye', ‑a 'mʋ mu, ‑ɛ nu꞊o, nyiblo ‑mʋ', ‑ɛ di 'mʋ 'na yraanyibli ‑jɩ' pʋ, 'kɩ ɛ yɩ 'lɩ di.» ");
INSERT INTO ktj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Win nɩ 'lɩ ‑Yusu wlɔn, ‑ɛ ‑bɩ Judɩa, ‑ɛ mɔ ‑Yusu a ‑nagbopʋ* nɩ ‑pu ꞊tu 'ʋ 'hʋɛn a nyiblo ‑bɩ, ɛ nyre 'ʋ nɩ, ɛ kɔ nyibli ‑hʋɔhʋɩ 'hʋɛn‑. Nyibli a 'mʋ, ʋ 'ble ta‑wɔn‑tɛblɩ kɔ ti 'hʋɛn‑ kʋa lɛ. Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ, kɔ tetetɔɔnyʋ, kɔ ‑Juukʋɛ a naanyʋ ‑bɩ 'hʋɛn‑, ʋ nʋ‑ lee nyibli a 'mʋ, bʋ mu ‑Yusu klɔ. ");
INSERT INTO ktj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judɩa a 'mʋ, ‑ɛ di ꞊nʋ ‑Yusu ‑jɩ' pʋ, 'tɩ‑ ʋ 'mʋ 'hru wlɔn bi, kɛ‑ ɛ pʋ ꞊nʋ yɩ: «Nyiblo ‑mʋ', 'n di 'wlɛɛ ‑nɩ, 'n di 'wio ‑nyi, ɛ nɔ‑ ba klɔ, ɛ 'nɩ ꞊ha 'a mʋ ‑jɩ' ꞊ta, a 'mʋ꞊ʋ gba.» ");
INSERT INTO ktj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","‑Tɛ ʋ nyre kɩ 'ʋ, ‑ɛ ‑bɩ Judɩa 'yɩya 'ʋ ‑Yusu 'hʋɩ bʋ, ɛ wɛn: «Tɔɔnyɔ o,» 'ɛ 'wlɛɛ ꞊nɛ. ");
INSERT INTO ktj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ti nɩ ‑do a ti 'yri, nyibli a 'mʋ, Judɩa ‑gba, ‑ɛ ‑bɩ ʋ klɔ ‑Yusu nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nyɩsʋa a ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ, 'a ‑kʋannunyɔ ‑bɩ, ɛ nɩ ‑tuo kɩ ‑wɛ. ‑Ɛ ‑bɩ ‑Yusu a ‑nagbopi ‑bɩ, ɛ nɔ‑ ‑ha 'lɩ 'a 'plɩɛn bɔ 'kwli, 'ɛ nu꞊o, 'ɛ 'bɛ 'ʋ ‑kʋannunyɔ a 'mʋ, 'a nʋa. ");
INSERT INTO ktj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ: «Ta‑wɔn‑tɛblɩ kɔ ti 'hʋɛn‑, ɛ nɔ‑ a ‑ya, 'a di 'mʋ klɔ mɔ, ꞊wɩ yɩ, ‑tɛ ‑mʋ', ʋ ni ‑balʋnyɔ a kʋklɔ. ");
INSERT INTO ktj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","'Tɩ‑, 'a ‑nɛ ti, 'n nɩ la 'lɩ 'a mʋ 'nyɩ, 'nɩ tʋɛ la 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli, kɛɛ, a 'yɩ la 'mʋ ‑klɔ. ‑Tɛblɩ a pɛpɛ ‑bʋ, ɛ mi 'lu ‑mɔ, ‑ɛ di꞊e nu, ‑tɩ ‑mʋ', ʋ 'crɩ la, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ɛ 'mʋ ‑nue ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","‑Yusu bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ 'a ‑nagbopʋ a pɛpɛ ‑gbɛ 'ʋ꞊ʋ 'hʋɩ lɛ, 'ʋ 'gba ci lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kɛɛ, ɛ kɔ gblotayu ꞊dʋ, ɛ nɔ‑ yɩ ‑Yusu ꞊wien kʋɛ. Gblotayu a 'mʋ, danʋ nɩ ‑do ɛ 'wlɛɛ klɛ. ‑Ɛ ‑bɩ ʋ klɔ꞊ɔ nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Kɛɛ, 'kɩ ɛ hie 'lɩ ꞊nʋ 'a danʋ a 'mʋ ‑jɩ' bʋ, 'ɛ ꞊ga 'hʋɩ wlɔn, 'ɛ 'gba ci lɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","'Tɩ‑ dɛ a 'mʋ, ɛ 'mʋ ‑hi, ‑ɛ ‑bɩ ʋ gbɛ ‑Yusu nɩ, 'kɩ 'lɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* a nyiblo gbagbʋ a 'kayu bʋ. 'Kayu a 'mʋ bʋ, 'kɩ ‑cɔhlʋnpinyʋ* gbagbɩ a pɛpɛ, kɔ Nyɩsʋa a tetetɔɔnyʋ, kɔ 'blʋgba a naanyʋ ‑bɩ 'hʋɛn‑, 'kɩ 'waa pɛpɛ, ʋ 'kukue 'lɩ lɛ, 'kɩ 'ʋ ‑gbolugbo a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piɛlɩ ‑mɔ ‑bɩ, ɛ yɩ kʋɛ ‑Yusu ꞊wien, 'kɩ 'lɩ ‑mɔhlɔɔlɛ 'kwli, 'ɛ ‑hɛ 'lɩ 'waa ꞊pɩ lɛ, 'ɛ ‑mu, 'ɛ pa 'lɩ ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ a ‑yaa 'kwli ‑wɛ. 'Kɩ Nyɩsʋa a 'kagbaʋ a 'yie꞊tunyʋ nɩ 'lɩ, 'ʋ 'tie na, 'ʋ yɩ꞊ɩ 'wɛn. Nyibli a 'mʋ, ʋ nʋ‑ kɔ 'nyɩ Piɛlɩ nɩ 'lɩ bʋ, 'ɛ yɩ na 'wɛn ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","'Kɩ 'lɩ 'kayu a 'mʋ bʋ, ‑cɔhlʋnpinyʋ gbagbɩ, ʋ kɔ ‑gbolugbo a nyibli a pɛpɛ 'hʋɛn‑, ʋ ꞊mʋɛ꞊ɛ lɛ, 'kɩ bʋ yɛɛ ‑Yusu ‑tɩ, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ 'la, kɛɛ, ʋ 'yɩ 'lɩ꞊ɩ kɩkadɛ ꞊dʋ 'lɩ 'yee ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nyibli ‑hʋɔhʋɩ pɩ꞊ɩ hɩ kɩ. Kɛɛ, 'waa 'pʋplɛwin puple 'lɩ klɛ. ");
INSERT INTO ktj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kɛɛ ‑ɛ ‑bɩ nyibli ‑bɩ 'du ye', 'ʋ yɛɛ ꞊nɛ ‑tɩ, 'kɩ 'lɩ hɩ 'kwli, ʋ wɛn: ");
INSERT INTO ktj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«‑Aan 'mumu, ‑a 'wɩn la nɩ, ‑tɛ ɛ pɩ la lɛ, ‑ɛ mɔ: Nyɩsʋa a 'kagbaʋ ‑bʋ, ‑tonyibli ‑pʋ, 'n di꞊e 'nɩ 'wla, 'tɩ‑ 'mʋ 'a dɛ ‑bɩ pʋ, 'kɩ 'lɩ ‑nyrɔwɩ nɩ ta 'kwli, 'kɩ ‑tonyibli 'yɛ di 'ʋ dabʋɩ 'hʋɩ nɩ gba.» ");
INSERT INTO ktj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kɛɛ, 'kɩ 'ʋ ‑tɛ a 'mʋ, 'waa win 'tɩɛ puple 'lɩ klɛ de. ");
INSERT INTO ktj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","‑Ɛ ‑bɩ ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ 'du ye', 'kɩ 'ʋ nyibli a pɛpɛ ye', 'ɛ 'bɛti ‑Yusu, ɛ wɛn: «꞊Bɩ ‑tɩ a pɛpɛ ‑bʋ, nyibli ‑bʋ, ʋ yɩ ‑mʋ ‑yɛɛ ‑nɩ, ꞊yɩ ‑tɩ ‑kɔ, ‑bʋ ꞊tu ꞊nʋ ꞊wɔn?» ");
INSERT INTO ktj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kɛɛ, ‑Yusu 'yɩ꞊ɩ ‑tɩ ꞊dʋ klɛ ‑hɩhɩa ‑nɩ. ‑Ɛ ‑bɩ ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ 'bɛti꞊e nɩ de, ɛ wɛn: «꞊Bɩ ‑mɔ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la 'lɩ ya? ꞊Bɩ ‑mɔ mɔ Nyɩsʋa a 'Yu?» ");
INSERT INTO ktj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","‑Ɛ ‑bɩ ‑Yusu ꞊tu꞊o ꞊wɔn, ɛ wɛn: «Iin, 'mɔ ꞊nɩɔ. Ɛ di kɔ ti, a 'mʋ 'mʋ 'ye, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'mʋ 'ʋ 'Klɩkɩnɩnyɩsʋa a diidɛkɩbɩa kɩ bʋ nɩ, 'mʋ 'lɩ yakɔ 'kwli ‑hɔn, 'kɩ 'lɩ 'nuŋma 'nyɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","‑Yusu bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ a 'mʋ, ɛ cɩcra 'a dɩɔnʋ wlawlʋ lɛ, yrʋ a ‑tɩ, ɛ wɛn: «‑A 'nɩ 'mʋɔɔ 'kɩ ‑hɛhɩnyibli ꞊dʋ lɛ de, ");
INSERT INTO ktj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","'bɩ 'aan 'mumu, a 'wɩn ‑tɩ, ɛ ‑hla nɩ. A 'wɩn nɩ, ‑tɛ ɛ nu Nyɩsʋa a ‑tɩ a lɛ‑hɛɛlɛ. ‑Bɩ' a pɩ 'lɩ?» ‑Ɛ ‑bɩ 'waa pɛpɛ, ʋ wɛn: «Ɛ mɔ ꞊han‑tɩ, ɛ ‑hɛɛ Nyɩsʋa a ‑tɩ lɛ. 'A ‑tɩ, ɛ kɔ 'kʋkʋʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","‑Ɛ ‑bɩ ‑ʋ ‑bɩ ‑tʋa 'a hɩʋn a 'hinhren, ɛ kɔ, 'ʋ mʋa nɛ 'a 'yii klɛ, 'ʋ yɩ꞊ɩ ŋmli ‑bii ‑nɩ, ʋ wɛn: «Winwlɔn‑hanyɔ o, lee nɛ ‑a mʋ, nyiblo a 'dɩ ‑bɩ ‑hrɛn ‑mʋ dɛ 'lɩ?» ɛ kɔ, Nyɩsʋa a 'kagbaʋ a 'yie꞊tunyʋ a 'mʋ, 'ʋ pɩɩ 'lɩ꞊ɩ 'ŋmɩ nʋɩ' lɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","‑Tɛ ‑tɛblɩ a 'mʋ, ɛ mi 'lu ‑mɔ, 'kɩ Piɛlɩ 'tɩɛ nɩ 'lɩ ‑yaa a 'mʋ 'kwli. Bʋ nɩ 'kɩ 'ʋ bʋ, ‑ɛ ‑bɩ 'yu nyrɔyu ꞊dʋ, ‑ɛ nii 'lɩ ‑cɔhlʋnpinyʋ* a nyiblo gbagbʋ a ‑tɛ ‑kʋan, ɛ nɔ‑ nyre 'ʋ, 'ɛ 'ye Piɛlɩ, 'ɛ yɩ na 'wɛn. ");
INSERT INTO ktj_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Bʋ 'ye 'kɩ꞊ɩ, ‑ɛ ‑bɩ ɛ ‑hrʋʋ ꞊nɛ 'yie lɛ, ɛ wɛn: «‑Mɔ ‑bʋ, ‑kɔ Nasalɛtɩ a ‑Yusu 'hʋɛn‑, 'a mʋ ‑nɩnɛ la 'hʋɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kɛɛ, Piɛlɩ ‑ga nɩ, ɛ wɛn: «‑Tɩ ‑mʋ', ‑hlɛ, 'nɩ 'wɩn꞊ɩ lɩ꞊ɩ, ɛ kɔ, 'nɩ ‑yru꞊o lɩ꞊ɩ' lɛ,» 'ɛ ‑hɔn 'ʋ꞊ʋ 'hʋɩ, 'ɛ mu 'lɩ ‑yaa a 'mʋ 'a paalɛ'. Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ hapɛ da ‑nyrɛ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kɛɛ ‑ɛ ‑bɩ 'yu nyrɔyu nɩ ‑do a 'mʋ, ɛ 'ye꞊e nɩ de, ‑ɛ ‑bɩ kɛ‑ ɛ pɩ nyibli ‑mʋ', ‑ʋ nɩ 'ʋ yɩ, ɛ wɛn: «Nyiblo ‑bʋ, ɛ mɔ ‑Yusu a ‑nagbopi* ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","‑Ɛ ‑bɩ Piɛlɩ ‑ga nɩ de. Ti gbi bʋ ‑hi, ‑ɛ ‑bɩ nyibli a 'mʋ, ‑ʋ nɩ 'ʋ, ʋ wɛn: «Ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, ‑mɔ ‑bʋ, ‑mɔ ‑Yusu a ‑nagbopi ꞊nɩɔ, ‑kɔtɩ ‑na 'mumu, 'kɩ ‑kɔ 'lɩ Galileblʋgba 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","‑Ɛ ‑bɩ ɛ wɛn: «'Bʋ mɔ, 'nɩ yɩ hɩ nɩ ni, Nyɩsʋa bʋ pʋ 'mʋ 'jrɔ yɩ. 'N 'sʋʋ nɩ, nyiblo ‑bʋ, ‑kɔtɩ a hlɛ, 'n 'yɩ꞊ɩ ‑yi.» ");
INSERT INTO ktj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ti nɩ ‑do a 'mʋ 'yri, ‑ɛ ‑bɩ hapɛ nu ‑nyrɛ a daawɩ nɩ 'hʋɛn a dɛ nɩ. ‑Ɛ ‑bɩ ‑tɩ ‑mʋ', ‑Yusu lee wɛn Piɛlɩ, ɛ bi 'lɩ꞊ɩ 'kwli. Kɛ‑ ɛ pʋ꞊ʋ yɩ: «'Tɩ‑ hapɛ 'mʋ ‑nyrɛ a daawɩ nɩ 'hʋɛn nu, ‑di nu 'na ‑mɔ‑gaawɩ nɩ ta, ‑ɛ mɔ, ꞊yɩ 'mʋ ‑yi.» Bʋ bi 'kɩ 'lɩ꞊ɩ 'kwli, ‑ɛ ‑bɩ ɛ ‑tʋa wuwe. ");
INSERT INTO ktj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","'Tɩ‑ ‑nyrɛ 'mʋ ‑nyɛ, ‑ɛ ‑bɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ 'kukue lɛ de, ʋ kɔ ‑Juukʋɛ* a naanyʋ, kɔ tetetɔɔnyʋ, kɔ ‑gbolugbo a nyibli a pɛpɛ 'hʋɛn‑, ʋ 'mʋ ‑Yusu a ‑tɩ' lɛ ‑pʋpʋ ‑nɩ. ‑Ɛ ‑bɩ ʋ wɛn: «‑Ba lee nɛ ‑aan 'sɛyo, bʋ mʋa ꞊nɛ, ʋ 'mʋ 'lɩ꞊ɩ Pilatɩ ‑mɔ gba.» (Pilatɩ a 'mʋ, ɛ nɔ‑ mɔ ‑gʋlʋnʋma ‑mʋ', Romakʋɛ a 'kɩɩn gbagbʋ ꞊tu la gbata kɩ bʋ.) ");
INSERT INTO ktj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Bʋ gba 'kɩ 'lɩ꞊ɩ Pilatɩ ‑mɔ, ‑ɛ ‑bɩ ɛ ‑tʋa 'a lɛ'bɛtilɛ, ɛ wɛn: «꞊Bɩ ‑mɔ mɔ ‑Juukʋɛ a bodɩɔ?» ‑Ɛ ‑bɩ ‑Yusu wɛn: «Iin, 'mɔ ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","‑Ɛ ‑bɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ gbagbɩ ‑tʋa 'a ‑tɩ ‑hʋɔhʋɩ a yɛɛlɛ. ");
INSERT INTO ktj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","‑Ɛ ‑bɩ Pilatɩ 'bɛti nɩ de, ɛ wɛn: «꞊Bɩ ‑tɩ a pɛpɛ ‑bʋ, ʋ yɩ ‑mʋ ‑yɛɛ ‑nɩ, ꞊yɩ ‑tɩ ꞊dʋ ‑kɔ, ‑bʋ hla?» ");
INSERT INTO ktj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kɛɛ, ‑Yusu 'yɩ꞊ɩ ꞊wɔn ꞊tu. Ɛ mɔ dɛ, ‑ɛ kɛɛ Pilatɩ a ꞊wlʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","'A ‑nɛ lɛ'mimle, ‑ɛ mɔ Pakɩ a ti 'yri, Pilatɩ kɔ bʋ tɛ ꞊jɩklapi nɩ ‑do ‑mʋ', ‑Juukʋɛ di ‑hʋa bʋ. ");
INSERT INTO ktj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ti a 'mʋ 'yri, ɛ kɔ la ꞊jɩklapi ꞊dʋ. 'A 'nyrɛ mɔ Balabasɩ. Ɛ mɔ ‑balʋnyɔ ꞊nɩɔ. Balabasɩ a 'mʋ, ʋ pʋ la꞊a ꞊jɩ', ɛ kɔ 'a 'bio ‑balʋnyibli ‑bɩ 'hʋɛn‑, ‑ɛ nu꞊o, ti ‑bʋ, ‑ɛ kɔ 'yri 'blʋgba yɩ mɔ ꞊gbʋgblɔ ‑nɩ, 'kɩ ʋ 'la mɔ nyiblo. ");
INSERT INTO ktj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","‑Ɛ bɩ nyibli ‑hʋɔhʋɩ mu 'lɩ Pilatɩ ‑mɔ, 'ʋ lee ꞊nɛ, ʋ wɛn: «‑A ‑hʋɛ꞊ɛ nɩ, ‑bʋ ‑tɛ ꞊jɩklapi nɩ ‑do bʋ, ꞊wɩ yɩ, ‑tɛ ‑mʋ', ‑ni꞊e lɛ 'a ‑nɛ 'yrʋ, lɛ'mimle, ‑ɛ mɔ Pakɩ a ti 'yri.» ");
INSERT INTO ktj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","‑Ɛ ‑bɩ Pilatɩ wɛn: «꞊Bɩ a ‑hʋɛ꞊ɛ nɩ, ꞊bʋ tɛ 'aan bodɩɔ, ‑ɛ mɔ ‑Juukʋɛ a bodɩɔ bʋ?» ");
INSERT INTO ktj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kɛ‑ Pilatɩ nu 'pʋplɛ, ‑ɛ nu꞊o, ɛ yi꞊e nɩ, ‑ɛ mɔ, 'kɩ 'lɩ ca 'kwli, 'kɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ pʋʋ 'lɩ꞊ɩ ‑Yusu ‑jɩ', ‑ɛ di꞊e nu, ɛ 'mʋ꞊ʋ 'la. ");
INSERT INTO ktj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pilatɩ bʋ 'bɛti 'kɩ ꞊nʋ, ‑ɛ ‑bɩ ‑cɔhlʋnpinyʋ gbagbɩ ꞊tutuo nyibli ‑mʋ' nɩ, 'kɩ bʋ lee Pilatɩ, bʋ tɛ Balabasɩ bʋ, kɛɛ, ɛ 'nɩ 'tɛɛ 'lɩ ‑Yusu bʋ. ");
INSERT INTO ktj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","‑Ɛ ‑bɩ Pilatɩ ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «'Bʋ mɔ, 'nɩ tɛ Balabasɩ bʋ, dɛ a 'dɩ ‑bɩ a ‑hʋɛ, ꞊bʋ nu nyiblo ‑bʋ, a dɛɛ nɛ 'aan bodɩɔ ‑mɔ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","‑Ɛ ‑bɩ ʋ 'yaa 'lɩ win, ʋ wɛn: «Kɔɔ 'ʋ꞊ʋ tugbɛ 'yie, ɛ 'mʋ 'kʋ!» ");
INSERT INTO ktj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","‑Ɛ ‑bɩ Pilatɩ wɛn: «Dɛ ‑hʋan a 'dɩ ‑bɩ ɛ ‑nu, ‑kɔtɩ 'nɩ kʋɛ 'ʋ꞊ʋ tugbɛ 'yie 'lɩ?» Kɛɛ, ʋ 'yɛɛ 'lɩ win, ʋ wɛn: «Kɔɔ 'ʋ꞊ʋ tugbɛ 'yie, ɛ 'mʋ 'kʋ!» ");
INSERT INTO ktj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","‑Tɛ Pilatɩ ‑hʋɛ bʋ blee nyibli a plɔ, ɛ nɔ‑ nu꞊o, 'ɛ tɛ Balabasɩ bʋ, 'tɩ‑ 'ɛ lee nɛ 'a 'sɛyo, bʋ bii ‑Yusu lɔkʋɛ. ‑Tɛ ʋ bi 'kɩ꞊ɩ, ‑ɛ ‑bɩ ɛ lee nɛ 'a 'sɛyo a 'mʋ nɩ, ɛ wɛn: «Ba gba꞊a, ba kɔɔ 'ʋ꞊ʋ tugbɛ 'yie, ɛ 'mʋ 'kʋ.» ");
INSERT INTO ktj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pilatɩ bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ 'a 'sɛyo gba ‑Yusu nɩ, 'kɩ 'lɩ Pilatɩ a 'mʋ 'a ‑yaa 'kwli, ‑tɛ 'waa bʋnɩɩlɛ nɩ 'lɩ, 'ʋ da 'waa 'bio 'sɛyo a pɛpɛ. ");
INSERT INTO ktj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","‑Tɛ ʋ ‑nyre 'kɩ, ‑ɛ ‑bɩ ʋ pʋ ‑Yusu wlawlʋ ‑jɔhʋn, 'ʋ hlaa ꞊nɛ 'witiklaʋn lɛ. 'Witiklaʋn a 'mʋ, ɛ nɔ‑ ʋ ꞊tu꞊o 'lu. ");
INSERT INTO ktj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","‑Ɛ ‑bɩ ʋ ‑tʋa 'a 'wioblɛpʋpʋʋ, ʋ wɛn: «‑Na 'wio mɔ, ‑Juukʋɛ* a bodɩɔ,» ");
INSERT INTO ktj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","kɔ, 'ʋ pɩ 'ʋ꞊ʋ kotu 'lu lɛ, 'ʋ ‑gblɛ 'lɩ꞊ɩ hɩʋn 'yi lɛ, 'tɩ‑ 'ʋ 'gbla kwlɩ, 'kɩ 'ʋ꞊ʋ ye', 'ʋ ꞊tɩɔ 'ʋ 'li lɛ, 'kɩ 'ʋ 'a 'caalɛ a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","‑Tɛ ʋ ‑wɛ 'kɩ 'a 'caalɛ ‑mɔ, ‑ɛ ‑bɩ ʋ ‑hɛ꞊ɛ wlawlʋ ‑jɔhʋn a 'mʋ nɩ, 'ʋ pʋ꞊ʋ 'a ꞊gbɛtʋ, 'a wlawlɩ, 'tɩ‑ 'ʋ ꞊tɩɔ ꞊nɛ 'dɩɔ, 'ʋ gbɛ 'lɩ꞊ɩ ‑tɩtɛ ‑mʋ', ʋ di 'lɩ꞊ɩ tugbɛ 'yie ‑kɔɔ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Bʋ yɩ 'kɩ nɩ mi, ‑ɛ ‑bɩ ʋ kɔ nyɩbɛhɩan ꞊dʋ 'hʋɛn‑, ʋ ꞊ŋmee nɩ. Nyɩbɛhɩan a 'mʋ, 'a 'nyrɛ mɔ Simɔ. 'Kɩ ɛ kɔ 'lɩ Silɛnɩdɩɔ 'kwli. Ɛ nɔ‑ mɔ Alɛsadrɩ kɔ Rufusɩ 'hʋɛn‑ a 'baɩ. Nɔ‑ ‑hʋɛn ‑titi. Bʋ yɩ 'kɩ lɛ nɩ ‑hihi ‑nɩ, ‑ɛ ‑bɩ 'sɛyo klɔ꞊ɔ nɩ, 'ʋ nɩ 'ʋ꞊ʋ ke', 'ɛ 'ble tugbɛ ‑mʋ', ‑ɛ kɔ 'yie ʋ di 'ʋ ‑Yusu 'ʋ ‑kɔɔ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","‑Ɛ ‑bɩ ʋ gba 'lɩ ‑Yusu dʋgba ‑mʋ' 'lu, ʋ dɛɛ Gɔlʋgɔta, ‑ɛ ꞊hɛn 'nyrɛ 'Lukla. ");
INSERT INTO ktj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","‑Tɛ ʋ nyre 'lɩ, ‑ɛ ‑bɩ ʋ ‑hʋɛ bʋ ‑nyi꞊e nɔ, ʋ pʋ 'lɩ ‑cɩ ‑mɔ, ʋ dɛɛ milɩ, kɛɛ, ‑Yusu 'yɩ꞊ɩ 'na. ");
INSERT INTO ktj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","'Kɩ 'ʋ ‑tɩtɛ a 'mʋ, 'kɩ ʋ kɔɔ 'ʋ꞊ʋ tugbɛ 'yie, 'ʋ pʋ 'wla, ‑ɛ di꞊e nu, ʋ 'mʋ ‑Yusu a 'hʋɩlɛpʋ‑tɛblɩ, 'a ꞊glalɛ yi. ");
INSERT INTO ktj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Muu 'yrʋ bʋ 'yaa 'ʋ a ti 'yie, 'kɩ ʋ kɔɔ la 'ʋ꞊ʋ tugbɛ 'yie, ");
INSERT INTO ktj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","'ʋ 'crɩɩ la 'ʋ 'plaɩnkɩbɩa kɩ, ‑tɩ ‑kɔ ‑tɩ ʋ kɔɔ 'ʋ꞊ʋ tugbɛ 'yie. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: «Nyiblo ‑bʋ, ɛ nɔ‑ mɔ ‑Juukʋɛ* a bodɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ti nɩ ‑do a 'mʋ 'yri, 'kɩ 'ʋ ‑Yusu 'hʋɩ, ʋ kɔɔ 'ʋ ‑balʋnyʋ nɩ 'hʋɛn, 'kɩ 'ʋ 'waa ‑nɛ ti 'yie, ‑do 'kɩ 'lɩ 'a diidɛkɩbɩa kɩ, ‑do ‑bɩ 'kɩ 'lɩ 'a kamlakɩbɩa kɩ.  ");
INSERT INTO ktj_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","‑Ɛ ‑bɩ ‑tɩ ‑mʋ', ʋ 'crɩɩ 'la 'lɩ Nyɩsʋacrɩɛn 'kwli ti ‑hi la a ti 'yri, ɛ mu kɛ 'lu ‑mɔ. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: «'Kɩ ʋ ‑hree 'lɩ꞊ɩ ‑balʋnyʋ 'nyɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","‑Ɛ ‑bɩ nyibli ‑mʋ', ‑ʋ yɩ ‑hi, ʋ ‑hɛ꞊ɛ 'yri, 'ʋ ꞊gbɛpʋ 'lu lɛ, ʋ wɛn: «‑Mɔ ‑bʋ, ‑ɛ pʋ la lɛ, ‑ɛ di la Nyɩsʋa a 'kagbaʋ 'wla, 'tɩ‑ ‑ɛ di la꞊a pʋ, 'kɩ 'lɩ ‑nyrɔwɩ nɩ ta 'kwli, ");
INSERT INTO ktj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","wa ‑dɩɔnʋ, ꞊mʋ 'ʋ tugbɛ ‑mʋ' 'yie ‑hɔn, ꞊mʋ ꞊tɩ.» ");
INSERT INTO ktj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","‑Ɛ ‑bɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ, ʋ kɔ tetetɔɔnyʋ 'hʋɛn‑, ‑ʋ nɩ 'ʋ, ʋ ‑hɛ꞊ɛ 'yri lɛ ‑wɛ, ʋ wɛn: «Ɛ wa nyibli ‑bɩ nɩ, kɛɛ, ɛ 'yɩ 'lɩ 'a dɩɔnʋ a wʋwa 'lɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","'Bʋ mɔ Wanyɔ, ‑ɛ mɔ Yisraɛkʋɛ a bodɩɔ ‑wɛ, bʋ ‑hɔn 'ʋ tugbɛ ‑mʋ' 'yie, bʋ ꞊tɩ, ‑tɛ ti nɛ ‑bʋ. 'Bʋ mɔ, ꞊ba 'ye dɛ a 'mʋ, ‑a di pʋ꞊ʋ ꞊haan‑tɩ, ‑ɛ mɔ, ɛ nɔ‑ mɔ Wanyɔ.» Nyibli nɩ 'hʋɛn ‑mʋ', ʋ kɔɔ 'ʋ 'waa ti 'yie lɛ, 'kɩ 'ʋ ‑Yusu 'hʋɩ, ʋ 'cɛɛ ꞊nɛ nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","'Yrʋ bʋ yɩ 'ʋ 'lu a ‑hɛyri' nɩ nyre, ‑ɛ ‑bɩ halɔ ka ‑tʋtʋ a pɛpɛ kɩ. Halɔ a 'mʋ, ɛ nɩ 'ʋ ‑nɩnɩ, 'ɛ yɛ 'yrʋ‑hiilɛ a ti kɩ. ");
INSERT INTO ktj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","‑Tɛ 'yrʋ‑hiilɛ a ti a 'mʋ, ɛ yɩ 'ʋ nyre, ‑ɛ ‑bɩ ‑Yusu 'yaa 'lɩ win, ɛ wɛn: «Eloi, Eloi, lama sabatani?» ‑ɛ ꞊hɛn 'nyrɛ, «Nyɩsʋa o, Nyɩsʋa o, dɛ‑ kɔ 'mɔ ‑ha 'yie ‑mɔ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nyibli ‑mʋ', ‑ʋ nɩ ‑tuo kɩ, kɛ‑ 'waa dɛ ‑bɩ pɩ: «Ba 'ye kɛ, Nyɩsʋa a winwlɔn‑hanyɔ Eli ɛ dɛ,» ");
INSERT INTO ktj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","'kɩ 'lɩ ꞊nʋ 'nyɩ, ‑ɛ ‑bɩ 'ɛ ‑mu, 'ɛ 'gba ci lɛ, 'ɛ 'du ‑sapoo ye', 'ɛ 'nyra 'lɩ꞊ɩ 'lipanɔ ‑mɔ, 'ɛ mʋa 'ʋ꞊ʋ tugbɛ blɔblʋ 'lu lɛ, 'ɛ ‑nyi꞊e ‑Yusu, ‑ɛ di꞊e nu, ɛ 'mʋ꞊ʋ 'na. Ɛ wɛn: «‑Ba pʋ 'ʋ 'yie bʋ, 'bʋ mɔ, Eli 'bʋ di di, ɛ 'mʋ 'ʋ꞊ʋ tugbɛ a 'mʋ 'yie ‑ha, ‑a 'mʋ꞊ʋ 'ye.» ");
INSERT INTO ktj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Bʋ nɩ 'kɩ dɛ a 'mʋ ‑mɔ, ‑ɛ ‑bɩ ‑Yusu 'gbo nɩ, 'ɛ mla ‑hʋnhlʋn. ");
INSERT INTO ktj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ti a 'mʋ 'yri, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ, ‑ɛ nɩ 'lɩ Jrusrɛdɩɔ 'kwli, danʋ gbagbʋ ‑mʋ', ‑ɛ 'bɛ 'kayu a 'mʋ ꞊tɩɔ, 'ɛ ‑ki wlɔn pɛpɛ, kʋɛ 'lɩ 'a 'lu yɩ bʋ, ‑bʋ yɛ 'a ꞊hlɔndɛ kɩ. ");
INSERT INTO ktj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","'Kɩ 'ʋ ‑Yusu ꞊hlɔn, 'kɩ Romakʋɛ a 'sɛyo a nyiblo gbagbʋ ‑bɩ nyra 'ʋ bʋ. Ɛ nɔ‑ 'bɛ꞊ɛ 'yi. Bʋ 'ye 'kɩ, ‑tɛ ‑Yusu nu la 'kʋkʋʋ, ‑ɛ ‑bɩ ɛ wɛn: «Ɛ mɔ ꞊han‑tɩ, nyiblo ‑bʋ, ɛ mɔ la Nyɩsʋa a 'Yu ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nʋgbɩ ‑bɩ nɩ 'ʋ, 'ʋ hlɔɔ 'ʋ ‑tɛ a 'mʋ ‑mɔ lɛ dɛ gbe, 'ʋ yɩ ‑tɛblɩ a 'mʋ, ‑ɛ mi 'lu ‑mɔ 'ye. 'Kɩ 'lɩ ꞊nʋ 'nyɩ, Madala a Mari nɩ 'lɩ, ɛ kɔ Mari ‑mʋ', ‑ɛ mɔ Sakɩ 'cɩmɩɛ kɔ Sosɩ a 'dii, kɔ Salome. ");
INSERT INTO ktj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nʋgbɩ a 'mʋ, ʋ nʋ‑ yɩ la ‑Yusu ꞊wien lɛ kʋɛ, ‑tɛ ɛ nɩ la 'lɩ Galileblʋgba 'kwli, 'ʋ yɩ la꞊a ‑hɛɛ ‑nɩ. Ʋ kɔ nʋgbɩ ‑bɩ 'hʋɛn‑, ʋ kɔ ‑Yusu 'hʋɛn‑, ʋ nʋ‑ di la Jrusrɛ. ");
INSERT INTO ktj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","‑Tɛ 'tɔ yɩ nɩ ‑wɛn, ‑ɛ ‑bɩ nyiblo ꞊dʋ nyre 'ʋ ‑tuo a 'mʋ kɩ. 'A 'nyrɛ mɔ Sosɛfʋ. 'Kɩ ɛ kɔ 'lɩ Alimatedɩɔ 'kwli. Sosɛfʋ a 'mʋ, ɛ mɔ ‑Juukʋɛ* a ‑gbolugbo a nyiblo ‑bɩ ꞊nɩɔ. Nyibli ꞊tui 'ʋ꞊ʋ nɩ dɩakɩ. Ti ‑mʋ', Nyɩsʋa di nyibli win kɩ ‑kɔɔ ‑nɩ, ti a 'mʋ, ɛ nɔ‑ ɛ yɩ 'ʋ lɛ ‑plee ‑nɩ. Sosɛfʋ bʋ nyre 'ʋ ‑tuo a 'mʋ kɩ, ‑Juukʋɛ a ‑wuwle‑nyrɔwɔ* yɩ 'ʋ 'nɩ nyre, 'yrʋ bʋ pa a ti 'yri. Ɛ nɔ‑ nu꞊o, 'ɛ ꞊tu 'ʋ 'klɩ, 'ɛ 'yɩ 'yie ‑pie, 'kɩ bʋ mu 'lɩ Pilatɩ ‑mɔ, 'ɛ lee ꞊nɛ, bʋ wɛn꞊ɛ, ɛ 'mʋ 'ʋ ‑Yusu a ‑plahʋɩ tugbɛ 'yie ‑ha, ɛ 'mʋ 'ʋ꞊ʋ ‑ha. ");
INSERT INTO ktj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","‑Tɛ ‑Yusu 'yɩ 'ʋ tugbɛ 'yie ‑wlɛɛn ‑nɩ, 'ɛ 'kʋ, ɛ kɛɛ Pilatɩ a ꞊wlɩ lɛ. Ɛ nɔ‑ nu꞊o, 'ɛ da 'a 'sɛyo a nyiblo gbagbʋ, 'ɛ 'bɛti꞊e, 'bʋ mɔ, ‑tɛ ‑Yusu 'kʋ wɛn, 'a ti 'bʋ ‑wlɛn 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","‑Tɛ 'sɛyo a nyiblo gbagbʋ a 'mʋ, ɛ ꞊tu꞊o ꞊wɔn, ‑ɛ ‑bɩ Pilatɩ wɛn꞊ɛ kɩ, 'kɩ Sosɛfʋ bʋ ‑ha 'ʋ ‑Yusu tugbɛ 'yie. ");
INSERT INTO ktj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","‑Tɛ ɛ ‑wɛn 'kɩ, ‑ɛ ‑bɩ Sosɛfʋ mu ‑jisɛ ‑tɔ mɔ, 'ɛ ‑di, 'ɛ ‑ha 'ʋ ‑Yusu tugbɛ 'yie, 'ɛ 'hɩnhɩan 'lɩ꞊ɩ ‑jisɛ 'a mʋ 'kwli lɛ, 'tɩ‑ 'ɛ gba 'lɩ꞊ɩ ‑tɩtɛ ‑mʋ', ɛ di 'lɩ꞊ɩ ꞊tuu ‑nɩ. 'Kɩ 'lɩ ‑tɩtɛ a 'mʋ, 'hɩɔ gbagbʋ nɩ 'ʋ, 'ɛ hlɔ yra, ‑wɛn dʋgba. 'Kɩ 'lɩ 'hɩɔ gbagbʋ a 'mʋ 'kwli, 'kɩ ʋ 'bluu la 'lɩ 'dabio, (ti ꞊dʋ a ti 'yri la, ‑ɛ 'wɩ‑ ‑wlukayu yɩ). 'Kɩ 'lɩ 'dabio a 'mʋ 'kwli, 'kɩ ɛ pʋ 'lɩ ‑Yusu a ‑plahʋɩ, 'tɩ‑ 'ɛ nu 'hɩɔ 'papɔ, ‑ɛ nɩ 'ʋ, ‑ɛ ꞊hɩan 'lɩ ‑mɔ lɛ, 'ɛ ka 'dabio a 'mʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","‑Tɛ ‑mʋ', ʋ pʋ 'ʋ ‑Yusu bʋ, Madala a Mari, kɔ Mari, ‑ɛ mɔ Sosɩ a 'dii, ʋ 'ye 'ʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","‑Wuwle‑nyrɔwɔ* a 'mʋ bʋ ‑hi, 'yrʋ a bʋpɛɛlɛ a ti 'yri, ‑ɛ ‑bɩ Madala a Mari, ɛ kɔ Mari, ‑ɛ mɔ Sakɩ a 'dii, kɔ nʋgba ‑bɩ 'hʋɛn‑, ‑ɛ mɔ Salome, ʋ nʋ‑ mu ‑dawinninyra ‑tɔ mɔ, ʋ 'mʋ꞊ʋ ‑Yusu a ‑plahʋɩ lɛ pʋ. ");
INSERT INTO ktj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","'Sɔɔndɩ a ‑nyrajru', 'yrʋ a 'hrɩɩlɛ a ti 'yri, ‑ɛ ‑bɩ nʋgbɩ a 'mʋ, ʋ nʋ‑ ‑tuo 'lɩ 'dabio yɩ. ");
INSERT INTO ktj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bʋ nɩ 'hru wlɔn, ‑ɛ ‑bɩ ʋ ‑tʋa 'a lɛpʋpʋlɛ, ʋ wɛn: «Nyiblo a 'dɩ ‑bɩ, ‑ɛ di 'ʋ kʋanɩhɩɔ a 'mʋ 'ʋ ‑ha 'lɩ, ʋ ‑nu, 'ʋ ka 'dabio yɩ?» ");
INSERT INTO ktj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kɛɛ, ‑tɛ ʋ nyre 'lɩ, ‑ɛ ‑bɩ ʋ 'ye꞊e nɩ, ‑ɛ mɔ, kʋanɩhɩɔ a 'mʋ, ʋ blike꞊e lɛ, 'ʋ pʋ꞊ʋ 'kɩbɩa kɩ. ");
INSERT INTO ktj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","‑Ɛ ‑bɩ ʋ pa 'lɩ 'dabio 'kwli. Bʋ pa 'kɩ 'lɩ, ‑ɛ ‑bɩ ʋ yɛɛ 'lɩ gblotayu ꞊dʋ bʋ. Ɛ nɔ‑ nɩ 'ʋ diidɛkɩbɩa kɩ bʋ, 'ɛ pʋ wlawlɩ pʋɔpʋɩ. Nyɩsʋa a lɛlenyɔ ꞊nɩɔ. Bʋ 'ye 'kɩ꞊ɩ, ‑ɛ ‑bɩ hʋannʋ ‑tʋa 'waa nunuo dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kɛɛ ‑ɛ ‑bɩ gblotayu a 'mʋ, ɛ wɛn: «A 'nɩ 'pie 'lɩ hʋannʋ. 'N yi꞊e nɩ, ‑ɛ mɔ, Nasalɛtɩ a ‑Yusu, ʋ kɔɔ 'ʋ tugbɛ 'yie, ɛ nɔ‑ a ꞊mʋɛ lɛ. Ba 'ye kɛ ‑tɩtɛ ‑mʋ', ʋ pʋ la 'ʋ꞊ʋ bʋ, ɛ nɔ‑ ‑bʋ. Nyɩsʋa ‑ha 'lɩ꞊ɩ 'kʋkʋnyibli 'nyɩ nɩ, 'ɛ ‑ha꞊a 'klɔ. Ɛ 'yɩ 'nɛ‑ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","'A ‑tɩ, ba mu, ba lee nɛ 'a ‑nagbopʋ*, kɔ, ba lee Piɛlɩ ‑wɛ, ‑ɛ mɔ, ɛ di 'nyɛɛ 'hru, ɛ 'mʋ 'a mʋ ‑ple, 'kɩ 'lɩ Galileblʋgba 'kwli. 'Kɩ a di 'lɩ꞊ɩ bʋ ‑yɛɛ ‑nɩ, ꞊wɩ yɩ, ‑tɛ ‑mʋ', ɛ nu la 'a hɩhla.» ");
INSERT INTO ktj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","‑Tɛ gblotayu a 'mʋ, ɛ ‑wɛ 'kɩ 'pʋplɛ ‑mɔ, ‑ɛ ‑bɩ ʋ 'hrɩ nɩ, 'ʋ 'gba ci lɛ, ‑ɛ nu꞊o, hʋannʋ ‑hi ꞊nʋ wlɔn dɩakɩ. Hʋannʋ a ‑tɩ, ʋ 'yɩ nyiblo ꞊dʋ ‑tɩ ꞊dʋ ‑lee ‑nɩ.  ");
INSERT INTO ktj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","'Sɔɔndɩ a ‑nyragblɩ, 'kɩ ‑Yusu ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ, 'ɛ 'hrɩ 'klɔ. Yɩ‑hɛnyiblo ‑mʋ', ɛ 'hrɩɩ yɩ, ɛ nɔ‑ mɔ Madala a Mari. Ɛ nɔ‑ mɔ nʋgba ‑mʋ', ‑ɛ kɔ ke' ɛ bla la 'ʋ 'kuo ‑hʋɩn* nɩ ꞊hlon'hʋɛn lɛ. ");
INSERT INTO ktj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nyibli ‑mʋ', ‑ʋ yɩ la ‑Yusu ꞊wien lɛ kʋɛ, ʋ nʋ‑ Mari mu la lee mɔ, ‑ɛ mɔ, ‑Yusu ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ nɩ, 'ɛ 'hrɩ 'klɔ. ‑Tɛ ɛ nyre la 'lɩ ꞊nʋ ‑mɔ, ɛ yɛɛ la 'lɩ ꞊nʋ ꞊hien kɔ 'kla‑wliye'yɩya 'nyɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ la ꞊nʋ yɩ, ɛ wɛn: «‑Yusu 'hrɩ 'klɔ, 'na 'mumu a 'mʋ, 'n 'ye꞊e nɩ.» Kɛɛ, ʋ 'yɩ la꞊a ꞊haan‑tɩ ‑pʋ. ");
INSERT INTO ktj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑nagbopʋ nɩ 'hʋɛn ‑bɩ, ʋ nʋ‑ ‑hɔn 'lɩ Jrusrɛdɩɔ 'kwli, 'ʋ mi 'lɩ 'dɩɔ ‑bɩ kɩ. Ʋ nʋ‑ ‑Yusu 'hrɩɩ yɩ ‑wɛ, 'kɩ 'lɩ 'tu ‑bɩ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","‑Tɛ ʋ yru꞊o, ‑ɛ ‑bɩ ʋ ꞊hɩan ‑mɔ, 'ʋ di Jrusrɛ, 'ʋ lee 'waa 'bio ‑bɩ. Kɛɛ ‑ɛ ‑bɩ ʋ 'yɩ꞊ɩ ꞊haan‑tɩ ‑pʋ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Dɛ a 'mʋ, ‑tɛ ɛ ‑hi ‑wɛ, ‑ɛ ‑bɩ ‑Yusu a ‑nagbopʋ nɩ ‑pu ꞊tu 'ʋ ‑do a 'mʋ, ʋ yɩ di dɛ. Bʋ nɩ 'kɩ 'ʋ dɛdiilɛ', ‑ɛ ‑bɩ ‑Yusu 'hrɩɩ ꞊nʋ yɩ ‑wɛ, 'ɛ 'plɛ ꞊nʋ ‑mɔ, ‑tɛ ʋ ‑nu, 'kɩ ʋ 'yɩ ꞊wlʋ a yɩkuolɛ ‑kɔ, 'tɩ‑ 'waa ꞊wlɩ 'ʋ 'gboklo ‑nɩ, ‑ɛ nu꞊o, ‑tɛ ɛ 'hrɩ 'klɔ, nyibli ‑mʋ', ‑ʋ 'ye꞊e, ‑Yusu a ‑nagbopʋ 'yɩ ꞊nʋ ꞊haan‑tɩ ‑pʋ. ");
INSERT INTO ktj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ 'kɩ ꞊nʋ yɩ de, ɛ wɛn: «Ba mu, ba na 'klɔ a pɛpɛ ‑bʋ kɩ, ba pʋ 'na ꞊haantitie nyibli a pɛpɛ. ");
INSERT INTO ktj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nyiblo 'bʋ nɩ 'ʋ, 'bʋ 'wɩn ꞊haantitie a 'mʋ, 'bʋ kuo 'mʋ ꞊wlʋ yɩ, 'tɩ‑ 'bʋ pʋ꞊ʋ 'nie 'lu, nyiblo a 'mʋ, ɛ nɔ‑ 'n di wa, 'kɩ 'ʋ Nyɩsʋa a yrʋ ‑mɔ'. Kɛɛ, nyiblo 'bʋ 'yɩ 'mʋ ꞊wlʋ yɩ ‑kuo ‑nɩ, nyiblo a 'mʋ, ɛ nɔ‑ Nyɩsʋa a ‑bati di klɔ. ");
INSERT INTO ktj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nyibli ‑mʋ', ‑ʋ di 'mʋ ꞊wlʋ yɩ kuo ‑nɩ, ꞊wlɩlɛkɛɛ‑tɛblɩ ‑mʋ', 'n di 'lɩ ꞊nʋ 'lɩ ‑naa ‑nɩ, 'n di nu, ɛ nɔ‑ ‑bʋ: 'Kɩ 'lɩ 'na 'nyrɛ 'kwli, ʋ di bla 'kuo ‑hʋɩn* lɛ, ‑ʋ nɩ 'ʋ nyibli ke', ɛ kɔ, ʋ di pʋ win ‑mʋ', ʋ 'yɩ ‑yi. ");
INSERT INTO ktj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","'Ya 'ʋ 'lu de, 'ye ꞊bɩɩ ʋ klɔ hro, kɔ, ʋ 'na 'a ‑nɛ ꞊dedede, 'kʋɛ nɩ 'lɩ ‑mɔ, ‑tɛblɩ a 'mʋ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nu ꞊nʋ ‑balʋ'. Ʋ di pʋ 'hʋɩhrennyʋ dabʋɩ 'lu blɛ, Nyɩsʋa 'mʋ꞊ʋ nu, 'waa 'kʋɛ 'mʋ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","‑Tɛ Kʋkɔnyɔ ‑Yusu ‑wɛ 'kɩ 'lɩ 'waa ‑mɔhleelɛ ‑mɔ, ‑ɛ ‑bɩ Nyɩsʋa nu꞊o nɩ, ‑Yusu 'ɛ mu 'lɩ yakɔ 'kwli, 'ɛ nɩ 'ʋ 'a diidɛkɩbɩa kɩ bʋ, ");
INSERT INTO ktj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","'a ‑nagbopʋ* ‑mɔ ‑bɩ, 'ʋ ‑mu, 'ʋ pɩ nyibli 'a ꞊haantitie, 'kɩ 'ʋ 'a ‑nɛ ‑tɩtɛ ꞊dʋ. Kʋkɔnyɔ a 'mʋ, ɛ yɩ ꞊nʋ 'nɩ ‑hɛɛ ‑nɩ, 'kɩ 'lɩ 'waa ‑kʋan a 'mʋ 'kwli. 'Kɩ ɛ nɛɛ 'lɩ ꞊wlɩlɛkɛɛ‑tɛblɩ 'kwli, 'ɛ tʋɛ ꞊nɛ nyibli, ‑ɛ mɔ, ‑tɩ ‑mʋ', 'a ‑nagbopʋ hlɛ, ɛ mɔ ‑tɩ a ‑tɛɛ ꞊nɩɔ.");
INSERT INTO ktj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","‑Na 'wio Teofilɩ. ‑Kɔ 'a yiyie, ‑ɛ mɔ, 'kɩ 'nɛ‑ ‑a mʋ 'nyɩ, ‑tɛblɩ ‑hʋɔhʋɩ mu 'lu ‑mɔ, 'kɩ 'ʋ ‑Yusu 'Klɩsʋ a ‑ta'. ‑Tɛblɩ a 'mʋ, ‑ɛ mu la 'lu ‑mɔ, nyibli ‑hʋɔhʋɩ 'ye la꞊a nɩ, 'ʋ ‑hɛɛ la nyibli ‑mʋ', 'kɩ bʋ pʋ Nyɩsʋa a ꞊haantitie, 'ʋ nɛ la꞊a ‑mɔ lɛ, 'kɩ 'ʋ nyibli yɩ. Ɛ kɔ nyibli ‑hʋɔhʋɩ ‑bɩ, 'ʋ yɩ꞊ɩ 'crɩ, ꞊wɩ yɩ, ‑tɛ nyibli a 'mʋ, ‑ʋ 'ye la ‑tɛblɩ a 'mʋ, ʋ nu la 'a hɩhla. ");
INSERT INTO ktj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","'A ‑tɩ, 'na 'mumu, 'n 'bɛti nɩ, ‑tɛ ‑tɛblɩ a 'mʋ, ɛ nu la 'lu‑mɔmumuo, kʋɛ 'ʋ 'a ‑wlu꞊tutuo 'yie bʋ. ‑Tɛ 'n 'bɛti ‑nɩ, ‑ɛ ‑bɩ 'n 'ye꞊e nɩ, ‑ɛ mɔ, ɛ nɔɔ 'ʋ lɛ, ‑tɛblɩ a 'mʋ, ‑tɛ ɛ nu yrɛkʋkʋɛlɛ kɔ, ‑tɛ ɛ nu 'lu‑mɔmumuo, ꞊bʋ 'crɩɩ ‑mʋ Teofilɩ ‑mɔ, ‑mɔ nyiblo gbagbʋ, 'mʋ꞊ʋ ‑mɔ lɛ na. ");
INSERT INTO ktj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","'N ni꞊e nɩ, tɔɔlɛ ‑mʋ', ʋ tɔɔ ‑mʋ, ꞊mʋ꞊ʋ yru, ‑ɛ mɔ, ɛ mɔ ‑tɩ a ‑tɛɛ ꞊nɩɔ. ‑Ɛ ‑bɩ dɛ, 'n 'crɩ, nɔ‑ ‑bʋ: ");
INSERT INTO ktj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ti ‑kɔ 'yri Helɔdɩ mɔ la Sudeblʋgba a 'kɩɩn, ɛ kɔ la Nyɩsʋa a ‑cɔhlʋnpinyɔ* ꞊dʋ. 'A 'nyrɛ mɔ Sakali. 'Kɩ ɛ nɩ la 'lɩ ‑cɔhlʋnpinyʋ a ꞊tumu ‑bɩ 'nyɩ, ‑ʋ ni ‑kʋan lɛ, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ, 'kɩ 'lɩ Jrusrɛdɩɔ 'kwli. ꞊Tumu a 'mʋ, ʋ mɔ la ‑cɔhlʋnpinyɔ Abia a ꞊tumu ꞊nɩɔ. Sakali a nʋgba, 'a 'nyrɛ mɔ Elisabɛtɩ. 'Kɩ ɛ kɔ 'lɩ ‑cɔhlʋnpinyɔ Ayrɔ a ꞊tugba 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakali kɔ Elisabɛtɩ a 'mʋ 'hʋɛn‑, ʋ 'sii la 'ʋ yɩ, 'kɩ 'ʋ Nyɩsʋa ye', kɔ, 'ʋ ꞊tui la 'ʋ Nyɩsʋa a tete a pɛpɛ 'ʋ ‑tɛɛ, 'kɩ 'lɩ 'waa ꞊wlɩ a pɛpɛ kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kɛɛ, ʋ 'yɩ la 'yu ‑kɔ, ‑ɛ nu꞊o, Elisabɛtɩ 'yɛ la 'yukɔdɛ, 'tɩ‑ ʋ nɩ 'hʋɛn a 'mʋ, ʋ ku la nɩ dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","‑Nyrɔwɔ ꞊dʋ 'kɩ, ‑ɛ ‑bɩ Abia a ꞊tugba a ti nyre 'ʋ nɩ, 'kɩ bʋ nu ‑cɔhlʋnpi‑kʋan*, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ. Ɛ nɔ‑ nu꞊o, Sakali, 'ɛ yɩ ‑cɔhlʋn pi, 'kɩ 'ʋ Nyɩsʋa ye', ");
INSERT INTO ktj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","꞊wɩ yɩ, ‑tɛ ‑cɔhlʋnpinyʋ ni꞊e lɛ, ꞊tumu ‑bɩ a ti 'bʋ nyre 'ʋ, 'ʋ pɩ 'wla, ‑cɔhlʋnpinyɔ ‑mʋ', 'wla yɩ di, nɔ‑ pʋɛ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ, ‑ɛ di꞊e nu, ɛ 'mʋ hɩnhrʋnpʋ‑tɛblɩ nu, ɛ 'mʋ ‑cɔhlʋn pi, 'kɩ 'ʋ Nyɩsʋa ye'. Sakali a 'mʋ, nɔ‑ 'wla ‑di, 'kɩ bʋ pa 'lɩ Nyɩsʋa a 'kagbaʋ bʋ, ɛ 'mʋ hɩnhrʋnpʋ‑tɛblɩ a ‑cɔhlʋn pi. ");
INSERT INTO ktj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ti ‑kɔ 'yri ɛ ꞊tu ‑cɔhlʋn a pipie ‑wlu, 'kɩ nyibli ‑hʋɔhʋɩ 'wlɛ 'ʋ ‑patʋ' bʋ, 'ʋ dɛ Nyɩsʋa. ");
INSERT INTO ktj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sakali bʋ yɩ 'kɩ ‑cɔhlʋn nɩ pi, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ, ‑ɛ ‑bɩ Nyɩsʋa a lɛlenyɔ 'hrɩɩ 'ʋ꞊ʋ 'hʋɩ. 'Kɩ ɛ nɩ 'ʋ ‑tɛ ‑mʋ', Sakali yɩ 'ʋ ‑cɔhlʋn ‑pii ‑nɩ a diidɛkɩbɩa kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","‑Tɛ Sakali a 'mʋ, ɛ 'ye꞊e, ‑ɛ ‑bɩ ɛ ta 'ʋ bʋ, hʋannʋ 'ɛ ‑tʋa 'a nunuo. ");
INSERT INTO ktj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kɛɛ Nyɩsʋa a lɛlenyɔ lee ꞊nɛ nɩ: «Sakali, ꞊nɩ 'pie 'lɩ hʋannʋ, ‑ɛ nu꞊o, Nyɩsʋa wɛn ‑na lɛnyaawin kɩ. ‑Na nʋgba Elisabɛtɩ di kɔɔ ‑mʋ 'yu nyɩbɛyu lɛ. 'Yu a 'mʋ, ꞊tue꞊e Saannyrɛ. ");
INSERT INTO ktj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","'Ba kɔ 'yu a 'mʋ, ‑di kɔ plɔ a bleelɛ dɩakɩ, kɔ, nyibli ‑hʋɔhʋɩ di nu dɔdʋ. ");
INSERT INTO ktj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ɛ di ‑hɛ nyiblo gbagbʋ, 'kɩ 'lɩ Nyɩsʋa 'yi. Ɛ 'yɩ yɩ ‑blɛɛ ‑nɩ, bʋ 'na nɔ, mɔ, ɛ 'yɩ yɩ ‑blɛɛ ‑nɩ ‑wɛ, bʋ 'na 'a ‑nɛ kɩklanyɔ ꞊dʋ. Nyɩsʋa a ‑Hihiu* di nɩ 'ʋ꞊ʋ ke', 'tɩ‑ ɛ 'mʋ ‑kʋɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ɛ di꞊e 'nɩ nu, Yisraɛkʋɛ ‑hʋɔhʋɩ 'mʋ Kʋkɔnyɔ Nyɩsʋa ꞊wlʋ yɩ ‑kuo ‑nɩ de. ");
INSERT INTO ktj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","‑Tɛ Nyɩsʋa a winwlɔn‑hanyɔ Eli nu la 'klɩ a kɩnɩnɩɩ, kɔ, ‑tɛ 'a 'klɔ nɩ la 'mʋ, kɛ‑ ɛ di 'mʋ nɩ ‑wɛ, ɛ 'mʋ nyibli ‑lee ‑nɩ, ‑ɛ mɔ, Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la 'a dakɔ yɩ ya, ɛ di 'nɩ di. Ɛ di꞊e 'nɩ nu, Nyɩsʋa a dakɔ a 'mʋ, ʋ 'mʋ ‑mɔ ‑wɛ, 'tɩ‑ Wanyɔ a 'mʋ, ɛ mʋ di. Ɛ di꞊e 'nɩ nu, 'baɩnʋ kɔ 'waa 'yonʋ 'hʋɛn‑, ʋ 'mʋ win' lɛ 'wɩnwɩn ‑nɩ, ɛ 'mʋ꞊ʋ nu ‑wɛ, nyibli ‑mʋ', ‑ʋ 'yɛ nɩ ꞊tuu 'ʋ Nyɩsʋa 'ʋ, ʋ 'mʋ ꞊tɔ kɔ, 'tɩ‑ ʋ 'mʋ Nyɩsʋa ꞊wlʋ yɩ ‑kuo ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","'Tɩ‑ Nyɩsʋa a lɛlenyɔ a 'mʋ, ɛ 'mʋ ‑yrɛ, ‑ɛ ‑bɩ kɛ‑ Sakali pɩ꞊ɩ yɩ: «‑Bɩ' 'n di 'a yiyie nu, ‑ɛ mɔ, ‑tɩ a 'mʋ, ‑hla, ɛ mɔ ꞊han‑tɩ ꞊nɩɔ 'lɩ? ‑Ɛ nu꞊o, 'n kɔ 'na nʋgba 'hʋɛn‑, ‑a ‑wɛ 'yi.» ");
INSERT INTO ktj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","‑Ɛ ‑bɩ Nyɩsʋa a lɛlenyɔ ꞊tu꞊o ꞊wɔn, ɛ wɛn: «'Na 'nyrɛ mɔ Gabriɛ. 'Kɩ 'n 'cibi 'ʋ Nyɩsʋa 'hʋɩ, 'nɩ ni 'a ‑kʋan. Nɔ‑ le 'nɛ‑ 'mʋ ‑mʋ ‑mɔ, 'kɩ ꞊bʋ pʋ ‑mʋ ꞊haantitie ‑bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kɛɛ, ꞊yɩ 'na win ꞊haan‑tɩ ‑pʋ. Nɔ‑ di꞊e nu, 'kɩ ‑nɩ 'yɛ nɩ di 'plɛlɛ nɩ yi, ɛ 'mʋ꞊ʋ gba ‑gbagba, ‑tɩ ‑bʋ, 'n ‑hla, ɛ 'mʋ ‑nue ‑nɩ, ti ‑mʋ', Nyɩsʋa di 'ʋ꞊ʋ ‑hʋa ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ti nɩ ‑do a 'mʋ ‑kɔ 'yri Nyɩsʋa a lɛlenyɔ kɔ Sakali 'hʋɛn‑, ʋ pɩpɩ win wlɔn blɛ, nyibli ‑hʋɔhʋɩ ꞊wlɛ 'ʋ ‑patʋ' bʋ, 'ʋ yɩ Sakali ‑ple, 'ɛ kɛɛ ꞊nʋ lɛ, ‑tɛ ɛ ‑nu, 'ɛ ‑wlɛn 'lɩ Nyɩsʋa a 'kagbaʋ bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","'Tɩ‑ ɛ 'mʋ 'hrɩ, ɛ 'yɩ 'lɩ nyibli a ‑mɔhleelɛ 'lɩ ‑wɛ. Dabʋɩ nɩ ‑do, ɛ pɩ, 'ɛ 'yɩ 'lɩ 'pʋplɛ ‑wɛ. Ɛ nɔ‑ nu꞊o, nyibli 'ʋ yru꞊o, ‑ɛ mɔ, ɛ 'ye ꞊dedede, ‑ɛ mu 'lu ‑mɔ, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ɛ nu 'ʋ ‑nyrɔwɩ gbi ‑bɩ, ‑ɛ di꞊e nu, ‑kʋan ‑mʋ', ɛ blɛɛ yɩ bʋ nu, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ, ɛ 'mʋ꞊ʋ ‑mɔ ‑wɛ. ‑Tɛ 'a ‑nyrɔwɩ a 'mʋ, ɛ ‑yrɛ 'lu, ‑ɛ ‑bɩ ɛ mu 'lɩ 'waa 'dɩɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ti gbi bʋ ‑hi, ‑ɛ ‑bɩ 'a nʋgba Elisabɛtɩ nɩ 'kwli. Ɛ 'nɩ 'hrɩ꞊ɩ lɩ, ‑ɛ di꞊e nu, nyibli 'nɩ ꞊ha꞊a 'ye, 'ɛ nu ꞊hɔnpʋɩ nɩ ꞊hun. Kɛ‑ ɛ pɩ: ");
INSERT INTO ktj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Nyɩsʋa pʋ 'na ‑tɩ ꞊wlɩ ‑mɔ lɛ, 'ɛ nu꞊o, 'kɩ nyibli 'yɛ nɩ di 'mʋ nɩ 'caa ‑nɩ de, 'kɩ ꞊bʋ 'yɛ nɩ di 'yu nɩ kɔ a ‑tɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","‑Tɛ Elisabɛtɩ a 'kwli kɔ ꞊hɔnpʋɩ nɩ ꞊hlon‑do, ‑ɛ ‑bɩ Nyɩsʋa tɛ 'a lɛlenyɔ Gabriɛ bʋ, 'kɩ bʋ mu la 'lɩ Galileblʋgba a 'dɩɔ ‑bɩ 'kwli, ‑ɛ kɔ 'nyrɛ ‑mɔ Nasalɛtɩ. ");
INSERT INTO ktj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","'Dɩɔ a 'mʋ 'kwli, 'kɩ 'yu nyrɔyu ꞊dʋ nɩ 'lɩ. 'A 'nyrɛ mɔ Mari. Ɛ 'yɩ nyɩbɛdɛ ‑yi. Kɛɛ, nyɩbɛyu ꞊dʋ nɩ 'ʋ, 'ʋ dɛɛ ꞊nɛ Sosɛfʋ. 'A 'baɩ gbagbʋ, nɔ‑ mɔ la bodɩɔ Dafidɩ. Sosɛfʋ a 'mʋ, nɔ‑ di꞊e kɔ. ‑Ɛ ‑bɩ Mari a 'mʋ, nɔ‑ kɔ ‑mɔ Nyɩsʋa tɛ la 'lɩ 'a lɛlenyɔ. ");
INSERT INTO ktj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","‑Tɛ ɛ pa 'lɩ Mari a ‑tɛ, ‑ɛ ‑bɩ ɛ wɛn: «Mari, ‑mɔ 'n ‑yɛ. Kɔ plɔ a bleelɛ. ‑Mɔ ‑bʋ Kʋkɔnyɔ Nyɩsʋa ‑ha, 'kɩ 'ʋ 'a ‑kʋan a ‑ta'. Ɛ ꞊tui ‑mʋ 'yie.» ");
INSERT INTO ktj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","'Tɩ‑ ɛ 'mʋ wuntɔbʋdʋ a 'mʋ 'wɩn mɔ mu, ‑ɛ ‑bɩ ɛ 'ta 'ʋ bʋ, 'ɛ ‑tʋa 'lulɛ‑hihie, dɛ‑ wuntɔbʋdʋ a 'mʋ, bʋ di 'nyrɛ ꞊hɛn. ");
INSERT INTO ktj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","‑Ɛ ‑bɩ Nyɩsʋa a lɛlenyɔ yɩ꞊ɩ 'nɩ ‑lee ‑nɩ, ɛ wɛn: «Mari, ꞊nɩ 'pie 'lɩ hʋannʋ. Nyɩsʋa tʋɛ ‑mʋ 'a nʋɛlɛ yɩ. ");
INSERT INTO ktj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ɛ nɔ‑ mɔ, ‑di nɩ 'kwli, ꞊mʋ 'yu nyɩbɛyu kɔ. 'Yu a 'mʋ, ‑di kɔ, ‑di daa ꞊nɛ ‑Yusu. ");
INSERT INTO ktj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ɛ di kɔ ‑tɩ a 'yi'bʋbʋa, ɛ kɔ, ɛ di mɔ ‑Tɩ'yi'bʋanyɩsʋa a 'Yu, 'tɩ‑ Kʋkɔnyɔ Nyɩsʋa a ꞊gbɛtʋ, ɛ di꞊e 'nɩ nu, 'yu a 'mʋ, ɛ 'mʋ bodɩɔ ‑hɛ, ꞊wɩ yɩ, ‑tɛ 'a 'baɩ gbagbʋ bodɩɔ Dafidɩ nɩ la 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ɛ di mɔ Yisraɛkʋɛ a bodɩɔ, ‑tɛ ti tɛ yɩ bʋ. 'A bodɩɔdɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ kɔ 'lu‑yrɛɛlɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","‑Ɛ ‑bɩ Mari wɛn: «‑Tɛ 'n 'yɩ nyɩbɛdɛ ‑yi, ‑bɩ' 'n ‑wɛ 'lɩ ꞊bʋ nu 'kɩ 'kwli a nɩnɩɩ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","‑Ɛ ‑bɩ Nyɩsʋa a lɛlenyɔ wɛn: «Nyɩsʋa a ‑Hihiu* di 'lɩ ‑mʋ 'nɩ ꞊tɩɩ ‑nɩ. ‑Tɩ'yi'bʋanyɩsʋa a ꞊gbɛtʋ, ɛ di nɩ ‑tuo kɩ, 'tɩ‑ 'a 'klɩ 'mʋ꞊ʋ nu, 'kɩ 'lɩ wlɔnlɛmaadɛ 'kwli, ꞊mʋ 'kwli nɩ. Nɔ‑ kɔ ‑tɩ 'yu a 'mʋ, ‑di kɔ, Nyɩsʋa di꞊e 'nɩ ‑ha, 'kɩ 'ʋ 'a ‑kʋan a ‑ta', kɔ, ɛ di mɔ Nyɩsʋa a 'Yu. ");
INSERT INTO ktj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","'Ye kɛ, ‑na 'dɩayɩ nyrɔyu Elisabɛtɩ, ꞊han‑tɩ, 'ɛ ‑wɛ 'yi, kɛɛ, ‑tɛ ɛ nɩ mɔ 'kwli, 'a ꞊hɔnpʋɩ nɩ ꞊hlon‑do a ꞊hɔnpʋ, nɔ‑ ‑bʋ, kɛɛ, ‑tonyibli wɛn 'nɩ, ɛ 'yɩ la 'yukɔdɛ. ");
INSERT INTO ktj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kɛɛ, 'a ‑nɛ ꞊dedede, Nyɩsʋa ‑wɛ 'lɩ bʋ nu꞊o nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","‑Ɛ ‑bɩ Mari wɛn: «‑Aa, 'mɔ Kʋkɔnyɔ Nyɩsʋa a ‑kʋannunʋgba ꞊nɩɔ. Dɛ ‑bʋ, ɛ ‑hʋɛ, 'na 'mumu, 'n ‑hʋɛ꞊ɛ nɩ ‑wɛ. ‑Tɛ ‑nu 'pʋplɛ, kɛ‑ bʋ nu 'lu‑mɔmumuo.» ‑Ɛ ‑bɩ Nyɩsʋa a lɛlenyɔ a 'mʋ, ɛ mu nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ti nɩ ‑do a 'mʋ 'yri, ‑ɛ ‑bɩ Mari bi 'hru wlɔn, 'ɛ 'kɩka ‑nɩ, 'ɛ mu 'lɩ 'dɩɔ ‑mʋ' ‑kɔ 'kwli Sakali kɔ Elisabɛtɩ 'hʋɛn‑, ʋ 'ti 'lɩ. 'Dɩɔ a 'mʋ, 'kɩ ɛ nɩ 'lɩ Sudeblʋgba a dʋgbɩ 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","‑Tɛ ɛ nyre 'lɩ, 'kɩ ɛ pa 'lɩ Sakali a 'kayu bʋ, 'ɛ pʋ Elisabɛtɩ 'wio. ");
INSERT INTO ktj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ti nɩ ‑do a ti 'yri, 'tɩ‑ Elisabɛtɩ 'mʋ Mari a win 'wɩn, ‑ɛ ‑bɩ 'a 'yu ‑mʋ', ‑ɛ nɩ 'lɩ꞊ɩ 'kwli, ɛ ‑tʋa susue, Nyɩsʋa a ‑Hihiu* 'ɛ bi 'ʋ Elisabɛtɩ ke', 'ɛ nu꞊o, ");
INSERT INTO ktj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","'ɛ 'yaa 'lɩ win, ɛ wɛn: «Nyɩsʋa nu ‑mʋ ꞊haandɛ ‑mɔ, 'ɛ ‑hi 'ʋ nʋgbɩ a pɛpɛ 'ʋ, kɔ, 'yu ‑bʋ, ‑di kɔ, ɛ 'mʋ꞊ʋ ꞊haandɛ ‑mɔ nu ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","'Mɔ ‑bʋ, ‑ɛ 'yɩ nyiblo ꞊dʋ 'pa‑, 'tɩ‑ 'na Kʋkɔnyɔ a 'dii, bʋ di 'nɛ‑ 'na 'kayu bʋ di, ɛ kɛɛ 'mʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","'Ye kɛ, ‑tɛ ‑pa 'kayu bʋ, 'tɩ‑ 'mʋ ‑na win 'wɩn, dɔdʋ nu꞊o nɩ, 'yu ‑bʋ, ‑ɛ nɩ 'lɩ 'mʋ 'kwli, 'ɛ ‑tʋa susue. ");
INSERT INTO ktj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Dɛ a 'mʋ, Nyɩsʋa pʋ la lɛ, ɛ di la nu, ‑kuo ꞊nɛ ꞊wlʋ yɩ, ‑ɛ mɔ, ɛ di꞊e 'nɩ nu. Nɔ‑ nu꞊o, ꞊nɩ kɔ plɔ a bleelɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","‑Ɛ ‑bɩ Mari wɛn: «'Kɩ 'lɩ 'na ꞊wlʋ a pɛpɛ kɩ, 'n 'bʋɛ Kʋkɔnyɔ a ‑tɩ 'yi. ");
INSERT INTO ktj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","'N kɔ plɔ a bleelɛ, 'kɩ 'ʋ Nyɩsʋa a ‑ta', ‑ɛ mɔ 'na Wanyɔ, ");
INSERT INTO ktj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","‑ɛ nu꞊o, 'mɔ ‑bʋ, ‑ɛ mɔ 'a ‑kʋannunyɔ, 'ye ꞊bɩɩ 'n 'yɩ nyiblo ꞊dʋ 'pa‑, ɛ pʋ 'na ‑tɩ ꞊wlɩ ‑mɔ lɛ. 'Ɛ mɔ ꞊han‑tɩ, kʋɛ kɛ 'kɩ mɔ bʋ, nyibli a ꞊hrɩn a ꞊hrɩn di꞊e 'nɩ hla, ‑ɛ mɔ, 'mɔ ‑mɔ nʋgba ‑mʋ', ‑ɛ kɔ plɔ a bleelɛ, ");
INSERT INTO ktj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","‑ɛ nu꞊o, 'Klɩkɩnɩnyɩsʋa nu 'mʋ ꞊haan‑tɛblɩ gbagbɩ ‑mɔ. Nɔ‑ mɔ Nyɩsʋa. ");
INSERT INTO ktj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nyibli a ꞊hrɩn a ꞊hrɩn ‑mʋ', ‑ʋ yɩ꞊ɩ pie, 'tɩ‑, ‑ʋ ꞊tui 'ʋ꞊ʋ, ɛ di yru 'waa nyaɩ. ");
INSERT INTO ktj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ɛ kɔ 'klɩ, 'kɩ bʋ nu ‑tɛblɩ gbagbɩ: Nyibli ‑mʋ', ‑ʋ 'yaa 'lɩ 'waa dɩɔnʋ, Nyɩsʋa ‑gba ꞊nʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","'Kɩɩnpʋ kɔ bodɩɔpʋ 'hʋɛn‑, ɛ ‑ha ꞊nʋ gbatɩ klɛ, kɛɛ, nyibli ‑mʋ', ‑ʋ 'yɩ nyibli ꞊dʋ 'pa‑, ʋ nʋ‑ ɛ pʋ gbatɩ klɛ. ");
INSERT INTO ktj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nyibli ‑mʋ', 'kanʋ ni, ɛ ‑ha 'lɩ ꞊haan‑tɛblɩ, 'ɛ ‑nyi ꞊nʋ꞊ʋ. Dɛkɔnyibli ‑mɔ ‑bɩ, ɛ ‑ha ꞊nʋ ‑tɛblɩ a pɛpɛ ꞊jrɛ, 'ɛ bla ꞊nʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","'Tɩ‑, 'ɛ lee la ‑aan 'baɩnʋ, ‑ɛ mɔ, ɛ di nu la 'a dakɔ Yisraɛkʋɛ ꞊haandɛ ‑mɔ, ‑tɛ 'klɔ tɛ yɩ bʋ. Kɛ‑ ɛ nu la Abrahamʋ kɔ 'a 'yonʋ a 'yonʋ a leelɛ. 'Lɩpʋʋdɛ a 'mʋ, ɛ 'yɩ꞊ɩ ‑mɔ ‑hru, 'ɛ dii nɛ 'a dakɔ kɩ.» Kɛ‑ Mari nu Nyɩsʋa a 'nyrɛ a lɛpʋpʋʋ. ");
INSERT INTO ktj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ti Mari ‑hi 'lɩ Elisabɛtɩ ‑mɔ, ɛ ‑wɛ 'lɩ ꞊hɔnpʋɩ nɩ ta nɩ, 'tɩ‑ 'ɛ ꞊hɩan ‑mɔ, 'ɛ mu 'lɩ 'a 'dɩɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ti ‑mʋ' ‑kɔ 'yri, Elisabɛtɩ di 'ʋ ꞊gblaa ‑nɩ, ɛ nyre 'ʋ nɩ, 'ɛ kɔ 'yu nyɩbɛhɩan. ");
INSERT INTO ktj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","'Waa 'dɩɔ a nyibli kɔ 'a ꞊tugba a nyibli 'wɩn nɩ, ‑ɛ mɔ, Nyɩsʋa yru 'a nyaɩ nɩ, 'ɛ nu꞊o ꞊haandɛ gbagbʋ ‑mɔ. Nɔ‑ nu꞊o, ɛ kɔ ꞊nʋ 'hʋɛn‑, 'ʋ bibi kɩ, 'ʋ ni dɔdʋ. ");
INSERT INTO ktj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","‑Tɛ 'yu kɔ 'wee, ‑ɛ ‑bɩ ʋ di nɩ, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ yɩ 'bɛ. ‑Ɛ ‑bɩ ʋ ‑hʋɛ bʋ ꞊tue꞊e 'a 'baɩ Sakali a 'nyrɛ. ");
INSERT INTO ktj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kɛɛ, ‑ɛ ‑bɩ 'a 'dii wɛn: «'Ʋʋn‑, 'a 'nyrɛ mɔ Saan.» ");
INSERT INTO ktj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","‑Ɛ ‑bɩ nyibli ‑mʋ', ‑ʋ nɩ ‑tuo kɩ, ʋ wɛn: «Dɛ‑ kɔ 'kɩ Saannyrɛ 'lɩ, ‑ɛ nu꞊o, nyiblo ꞊dʋ 'yɩ 'lɩ ‑na ꞊tugba 'kwli ‑nɩ, ‑bʋ kɔ Saannyrɛ?» ");
INSERT INTO ktj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","'ʋ pʋ dabʋ, 'ʋ 'bɛti 'a 'baɩ Sakali, 'nyrɛ ɛ ‑hʋɛ bʋ ꞊tue 'a 'yu. ");
INSERT INTO ktj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","‑Ɛ ‑bɩ Sakali a 'mʋ, ɛ ‑hʋa 'plaɩnkɩbɩa gbe, ʋ ‑wɛ 'lɩ bʋ 'crɩɩ 'ʋ kɩ. ‑Tɛ ʋ ‑nyi ꞊nɛ꞊ɛ, ‑ɛ ‑bɩ ɛ 'crɩɩ 'ʋ: «'A 'nyrɛ mɔ Saan.» ");
INSERT INTO ktj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","‑Tɛ nyibli ‑hre dɛ a 'mʋ, ɛ 'crɩ, ‑ɛ ‑bɩ ɛ kɛɛ 'waa pɛpɛ lɛ. Ti nɩ ‑do a ti 'yri, Sakali a mɛ ꞊wlɛ nɩ, 'ɛ ‑tʋa 'pʋplɛ, 'ɛ 'yaa 'lɩ win, 'ɛ ‑tʋa Nyɩsʋa a 'nyrɛlɛpʋpʋʋ. ");
INSERT INTO ktj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Dɛ a 'mʋ, ‑ɛ mu 'lu ‑mɔ, ɛ kɛɛ 'waa 'dɩɔ a nyibli lɛ, kɔ, nyibli ‑mʋ', ‑ʋ ‑hɔn 'lɩ Sudeblʋgba a dʋgbɩ 'nyɩ, 'ʋ nɛ꞊ɛ ‑mɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nyibli a pɛpɛ, ‑ʋ yɩ 'wɩn, ʋ yɩ ‑hie꞊e 'lu ‑mɔ lɛ, ʋ wɛn: «'Yu gbe ‑bʋ, ɛ di ‑hɛ nyiblo gbagbʋ.» Ɛ mɔ ꞊han‑tɩ, Nyɩsʋa a 'mʋ, nɔ‑ ꞊tui꞊e 'yie. ");
INSERT INTO ktj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ 'yu a 'mʋ, 'a 'baɩ Sakali, Nyɩsʋa a ‑Hihiu* bi 'ʋ꞊ʋ ke', Sakali a 'mʋ 'ɛ ‑tʋa Nyɩsʋa a win a wlɔn‑hɩhɩɛ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Nyibli a pɛpɛ, bʋ pʋ ‑aan Kʋkɔnyɔ, ‑ɛ mɔ Yisraɛkʋɛ a Nyɩsʋa 'nyrɛ lɛ, ‑ɛ nu꞊o, ‑a mʋ ‑bʋ, ‑ʋ mɔ 'a dakɔ, ɛ kɔ 'lɩ ‑aan dɛ ‑mɔ. Ɛ nɔ‑ nu꞊o, 'ɛ di ‑a mʋ ꞊gblɛ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","'Kɩ 'lɩ 'a ‑kʋannunyɔ bodɩɔ Dafidɩ a 'yonʋ a 'yonʋ 'nyɩ, ɛ ‑ha 'lɩ Wanyɔ, ‑ɛ nɩ 'klɩ kɩ, 'ɛ ya ‑a mɔ꞊ɔ yɩ. ");
INSERT INTO ktj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","‑Tɩ a 'mʋ, 'a winwlɔn‑hanyʋ* hla la꞊a nɩ, ti ‑hi la a ti 'yri. ");
INSERT INTO ktj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Wanyɔ a 'mʋ, ɛ nɔ‑ di 'lɩ ‑a mʋ nyibli ‑mʋ', ‑ʋ ‑wɛn ‑a mʋ yɩ, kɔ, ‑ʋ yraa nɛ ‑a mʋ a 'klɩ bʋ ‑ha. ");
INSERT INTO ktj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ɛ yru ‑aan 'baɩnʋ a nyaɩ, ɛ kɔ, 'yrɩ ‑mʋ', ɛ ꞊tu la, ɛ kɔ ‑aan 'baɩnʋ 'hʋɛn‑, ɛ ꞊tui 'ʋ꞊ʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ɛ 'sʋʋ la꞊a nɩ, 'kɩ 'ʋ ‑aan 'baɩ Abrahamʋ ye', ");
INSERT INTO ktj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","‑ɛ mɔ, ɛ di ‑a mʋ 'nɩ ꞊gblɛ, 'kɩ 'lɩ ‑aan yraanyibli a 'klɩ bʋ, ‑ɛ di꞊e nu, ꞊ba yɩ 'a ‑kʋan nɩ ni, ‑a 'nɩ ꞊ha hʋannʋ pie, ");
INSERT INTO ktj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kɔ, ‑a 'mʋ 'a ‑kʋan nu ‑tɛɛ, ti a pɛpɛ, ‑a di 'nɛ‑ 'klɔ kɩ ‑hi, ꞊wɩ yɩ, nyibli ‑mʋ', ɛ kɔɔ win kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","‑Mɔ ‑bʋ, ‑ɛ mɔ 'na 'yu gbe, ʋ di daa ‑mʋ ‑Tɩ'yi'bʋanyɩsʋa a winwlɔn‑hanyɔ, ‑ɛ nu꞊o, ‑mɔ di 'hru 'nyɛɛ ‑nɩ, ꞊mʋ 'hru yɩ kla, ‑tonyibli a ꞊wlɩ 'mʋ ‑mɔ ‑wɛ, 'tɩ‑ Kʋkɔnyɔ a 'mʋ, ɛ 'mʋ di, ");
INSERT INTO ktj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","꞊mʋ Nyɩsʋa a dakɔ ‑lee ‑nɩ, ‑ɛ mɔ, Nyɩsʋa di 'wʋwla 'waa ‑tɛblɩ 'kukui, ɛ 'mʋ ꞊nʋ wa, ");
INSERT INTO ktj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","‑ɛ nu꞊o, Nyɩsʋa a ꞊wlʋ nɔ yɩ, ɛ kɔ, 'ɛ yrui nyibli a nyaɩ. Ɛ yɩ ‑nyi ‑a mʋ ‑nyrɛ, ‑ɛ ‑hʋɛn 'lɩ yakɔ 'kwli, ");
INSERT INTO ktj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","‑nyrɛ a 'mʋ, ɛ 'mʋ꞊ʋ nu, nyibli ‑mʋ', ‑ʋ nɩ 'lɩ halɔ 'nyɩ, ɛ kɔ, ‑ʋ yɩ 'kʋkʋʋ a hʋannʋ pie, ʋ 'mʋ lɛ yru, ɛ 'mʋ꞊ʋ nu ‑wɛ, kɩbʋwɛɛnlɛ 'mʋ 'nɛ‑ ‑a mʋ 'nyɩ nɩ.» Ɛ nɔ‑ mɔ Sakali a ‑wla a win. ");
INSERT INTO ktj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","'Yu a 'mʋ, ‑ɛ mɔ Saan, ɛ kui nɩ. 'A Nyɩsʋa a nʋɛlɛ yɩ bii la klɛ. ‑Tɛ ɛ ‑ku 'kɩ, 'kɩ ɛ 'ti 'lɩ ‑tɩtɛ ‑mʋ', nyibli 'yɩ 'lɩ 'ti. 'Kɩ ɛ nɩ 'lɩ ‑nɩnɩ, ti 'ɛ nyre 'ʋ, 'kɩ bʋ ‑tʋa 'a ‑kʋan a nunuo, 'kɩ 'lɩ Yisraɛkʋɛ 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ti a 'mʋ 'yri, Romakʋɛ a 'kɩɩn gbagbʋ ‑bɩ nɩ la 'ʋ. 'A 'nyrɛ mɔ Ogusɩ. 'Kɩɩn Ogusɩ a 'mʋ, ɛ nɔ‑ mɔ la Romakʋɛ a 'blʋgbɩ a pɛpɛ a 'kɩɩn gbagbʋ. ‑Nyrɔwɔ ꞊dʋ, 'ɛ lee nɛ 'a ‑kʋannunyibli, 'kɩ bʋ ‑hre la 'a 'blʋgbɩ a nyibli a pɛpɛ, ɛ wɛn: «'A ‑nɛ nyiblo 'bʋ nɩ 'ʋ, bʋ mu 'lɩ 'a dɩɔnʋ a 'dɩɔ 'kwli, 'kɩ ʋ di 'lɩ꞊ɩ 'lɩ ‑hree ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nyibli‑hredɛ a 'mʋ, ɛ mɔ la 'a yɩ‑hɛdɛ ꞊nɩɔ. Ti a 'mʋ 'yri, nyiblo ‑bʋ, ‑ɛ mɔ Kiliniusɩ, ɛ nɔ‑ mɔ la Siliblʋgba a ‑gʋlʋnʋma. ");
INSERT INTO ktj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ɛ nɔ‑ nu꞊o, 'a ‑nɛ nyiblo 'bʋ nɩ 'ʋ, 'ɛ mi 'lɩ 'a dɩɔnʋ a 'dɩɔ 'kwli, ‑ɛ di꞊e nu, ʋ 'mʋ 'lɩ꞊ɩ 'lɩ ‑hree ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Ti a 'mʋ 'yri, nyɩbɛyu ‑mʋ', ‑ɛ mɔ Sosɛfʋ, ɛ kɔ Mari 'hʋɛn‑, 'kɩ ʋ 'ti 'lɩ 'dɩɔ ‑mʋ', ‑ɛ mɔ Nasalɛtɩ, 'kɩ 'lɩ Galileblʋgba 'kwli. Mari a 'mʋ, ɛ nɩ la 'kwli, 'kɩ 'lɩ Nyɩsʋa a 'klɩ 'kwli. Ɛ kɔ Sosɛfʋ 'hʋɛn‑, ʋ 'yɩ bʋɩ na yɩ bʋ ‑pʋ. Kɛɛ, Sosɛfʋ, ɛ nɔ‑ di꞊e kɔ. Sosɛfʋ a 'mumu a 'mʋ, 'kɩ ɛ kɔ 'lɩ 'dɩɔ ‑mʋ', ʋ dɛɛ Betelɛmʋ, 'kɩ 'lɩ Sudeblʋgba 'kwli. 'Kɩ Betelɛmʋ a 'mʋ 'kwli, 'kɩ Sosɛfʋ a 'baɩ gbagbʋ, ‑ɛ mɔ la bodɩɔ Dafidɩ, ɛ kɔ la 'lɩ ‑wɛ. Ɛ nɔ‑ nu꞊o, Sosɛfʋ kɔ Mari 'hʋɛn‑, 'ʋ ‑hɔn 'lɩ Nasalɛtɩdɩɔ 'kwli, 'ʋ mu 'lɩ Sosɛfʋ a ꞊gbɛtʋ a 'dɩɔ 'kwli, ‑ɛ mɔ Betelɛmʋ, ‑ɛ di꞊e nu, ʋ 'mʋ 'lɩ ꞊nʋ 'lɩ ‑hree ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","‑Tɛ ʋ nyre 'lɩ Betelɛmʋdɩɔ 'kwli, ‑ɛ ‑bɩ 'dɩɔ a 'kayo a pɛpɛ 'yii 'lɩ lɛ, 'kɩ 'ʋ 'dagbɩ ‑mɔ. Ɛ nɔ‑ nu꞊o, 'ʋ mu 'lɩ 'wlugba‑tɛblɩ a 'kayu ‑bɩ bʋ. ‑Ɛ ‑bɩ ti ‑mʋ' ‑kɔ 'yri Mari di 'ʋ ꞊gblaa ‑nɩ, ɛ nyre 'ʋ nɩ, 'ɛ kɔ 'a yɩ‑hɛyu. 'Yu a 'mʋ, ɛ mɔ nyɩbɛyu ꞊nɩɔ, 'ɛ 'hɩnhɩan꞊a danɩ lɛ, 'ɛ pɩa 'lɩ꞊ɩ 'wlugba‑tɛblɩ a dɛdihu 'kwli bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","'Tɔ', 'kɩ blablɩ'yie꞊tunyʋ nɩ la 'ʋ Betelɛmʋdɩɔ ꞊hlɔn, 'ʋ ꞊tui la 'waa blablɩ 'yie. ");
INSERT INTO ktj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ Nyɩsʋa a lɛlenyɔ 'hrɩɩ ꞊nʋ yɩ, Nyɩsʋa a ‑nyrɛ 'ɛ ꞊glaa 'lɩ ꞊nʋ, 'ɛ yɩ wlɩn. Nyɩsʋa a ‑nyrɛ a 'mʋ, ɛ kɔ 'a lɛlenyɔ a 'mʋ 'hʋɛn‑, ʋ nʋ‑ pʋ 'lɩ ꞊nʋ hʋannʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kɛ‑ Nyɩsʋa a lɛlenyɔ a 'mʋ, ɛ pɩ ꞊nʋ yɩ: «A 'nɩ 'pie 'lɩ hʋannʋ. 'N ya 'a mʋ ꞊haantitie yɩ. Ɛ mɔ dɔdʋdɛ gbagbʋ ꞊nɩɔ, 'kɩ 'ʋ 'aan dakɔ a pɛpɛ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","꞊Haantitie a 'mʋ, ɛ nɔ‑ ‑bʋ: Kɩkɛ a ‑nyrɔwɔ ‑bʋ 'kwli, 'aan Wanyɔ kʋɛ kɛ nɩ. 'Kɩ ʋ kɔɔ 'nɛ꞊ɛ Betelɛmʋdɩɔ 'kwli, ‑ɛ kɔ 'kwli bodɩɔ Dafidɩ kɔ la 'nɛ‑ ‑wɛ. Ɛ nɔ‑ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la 'a mʋ yɩ ya. Wanyɔ a 'mʋ, ɛ nɔ‑ mɔ Kʋkɔnyɔ, ‑ɛ kɔɔ nyibli a pɛpɛ win kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","‑Tɛ a di 'a yuyruo nu, ɛ nɔ‑ ‑bʋ: 'Ba mu 'dɩɔ, ba pa 'lɩ 'wlugba‑tɛblɩ a 'kayu bʋ. 'Kɩ a di 'lɩ 'yupanʋ bʋ ‑yɛɛ ‑nɩ, ʋ 'mʋ꞊ʋ danɩ lɛ 'hɩnhɩan ‑nɩ, ʋ 'mʋ 'lɩ꞊ɩ 'wlugba‑tɛblɩ a 'mʋ, 'waa dɛdihu 'kwli bʋ ‑pɩa ‑nɩ. ‑Ɛ ‑bɩ Wanyɔ a 'mʋ, ɛ nɔ‑ ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ Nyɩsʋa a lɛlenyʋ ‑hʋɔhʋɩ ‑bɩ ꞊glaa 'lɩ yɩ‑hɛlɛlenyɔ ‑mʋ' lɛ, 'ʋ pɩ Nyɩsʋa 'nyrɛ lɛ. Kɛ‑ ʋ pɩ: ");
INSERT INTO ktj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Nyɩsʋa, ‑ɛ nɩ 'lɩ yakɔ 'kwli, ɛ kɔ ‑tɩ a 'yi'bʋbʋa, kɔ, 'ɛ yɩ nyibli ‑mʋ', ‑ʋ nɩ 'nɛ‑ ‑tʋtʋ kɩ kɩbʋwɛɛnlɛ ‑nyi, 'kɩ 'ʋ 'waa nʋɛlɛ a ‑ta'.» ");
INSERT INTO ktj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nyɩsʋa a lɛlenyʋ a 'mʋ, bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ʋ ‑hɔn 'ʋ blablɩ'yie꞊tunyʋ a 'mʋ 'hʋɩ, 'ʋ mu 'lɩ yakɔ 'kwli. ‑Tɛ ʋ ‑hɔn 'ʋ ꞊nʋ 'hʋɩ, ‑ɛ ‑bɩ blablɩ'yie꞊tunyʋ a 'mʋ, ʋ wɛn: «‑Ba mu 'lɩ Betelɛmʋdɩɔ 'kwli, ‑a 'mʋ 'yupanʋ a 'mʋ 'ye, ‑kɔtɩ Kʋkɔnyɔ lee nɛ ‑a mʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ ʋ bi 'hru wlɔn. 'Tɩ‑ ʋ 'mʋ 'lɩ 'yupanʋ a 'mʋ, 'a kɔɔlɛ' nyre mɔ mu, 'ɛ mɔ ꞊han‑tɩ, 'kɩ ʋ yɛɛ 'ʋ Mari kɔ Sosɛfʋ kɔ 'yupanʋ a 'mʋ 'hʋɛn‑ bʋ, 'yupanʋ a 'mʋ, 'ʋ 'hɩnhɩan꞊a danɩ lɛ, 'ʋ pɩa 'lɩ꞊ɩ 'wlugba‑tɛblɩ a dɛdihu 'kwli bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","‑Tɛ ʋ 'ye 'yu a 'mʋ, ‑ɛ ‑bɩ ‑tɩ a pɛpɛ ‑mʋ', Nyɩsʋa a lɛlenyɔ lee wɛn ꞊nʋ, ʋ na 'a pɛpɛ ‑mɔ lɛ, 'kɩ 'ʋ nyibli a pɛpɛ ye'. ");
INSERT INTO ktj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","‑Tɛ ʋ 'wɩn ‑tɩ a 'mʋ, blablɩ'yie꞊tunyʋ na ‑mɔ lɛ, ‑ɛ ‑bɩ ɛ kɛɛ ꞊nʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","‑Tɩ a pɛpɛ a 'mʋ, ɛ 'yɩ Mari ‑mɔ ‑hru, 'tɩ‑ 'ɛ nɛɛ ꞊nɛ ꞊wlʋ klɛ 'a ‑nɛ ti. ");
INSERT INTO ktj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","‑Tɛ blablɩ'yie꞊tunyʋ a 'mʋ, ʋ ‑mɛ kle, ‑ɛ ‑bɩ ʋ pɩ Nyɩsʋa 'nyrɛ lɛ, ‑tɛ ɛ ‑nu, 'ɛ ya ꞊nʋ 'a lɛlenyɔ yɩ, kɔ, 'ɛ nu꞊o, 'ʋ 'ye 'yupanʋ a 'mʋ. 'Tɩ‑ ‑tɛblɩ a pɛpɛ, Nyɩsʋa a lɛlenyɔ lee ꞊nʋ, kɔ 'waa ꞊gbɛtʋ, ʋ 'ye, 'a pɛpɛ a 'mʋ, 'ɛ mɔ ꞊han‑tɩ, 'ɛ mu 'lu ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","‑Nyrɔwɩ nɩ ꞊blɩɛn꞊blɩɛn bʋ ‑hi, ‑ɛ ‑bɩ ti ‑mʋ' ‑kɔ 'yri ʋ di 'ʋ 'yu a 'mʋ yɩ 'bɛɛ ‑nɩ, ɛ nyre 'ʋ nɩ, 'ʋ 'bɛ꞊ɛ yɩ, ꞊wɩ yɩ, ‑tɛ Moise a tete pɩ, ‑ɛ mɔ, 'yu 'bʋ kɔ ‑nyrɔwɩ nɩ ꞊blɩɛn꞊blɩɛn, bʋ 'bɛ꞊ɛ yɩ, 'ʋ ‑nyi 'yu a 'mʋ ‑Yusunyrɛ, ‑ɛ mɔ 'nyrɛ ‑mʋ', Nyɩsʋa a lɛlenyɔ tɔɔ la 'a 'dii, ‑tɛ ɛ 'yɛ la 'kwli nɩ nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","‑Tɛ ‑nyrɔwɩ gbi ‑hi, ‑ɛ ‑bɩ ti nyre 'ʋ nɩ, 'kɩ Sosɛfʋ kɔ Mari 'hʋɛn‑ bʋ ‑ha ‑cɔhlʋn*, ‑ɛ di꞊e nu, Nyɩsʋa a ‑cɔhlʋnpinyʋ* 'mʋ꞊ʋ pi, 'kɩ 'ʋ Nyɩsʋa ye', Mari bʋ 'sii 'ʋ yɩ a ‑tɩ. Ɛ nɔ‑ mɔ tete ‑bɩ, Nyɩsʋa ‑nyi la 'a winwlɔn‑hanyɔ* Moise, ti ‑hi la ti a 'yri la, 'kɩ 'ʋ 'a ‑nɛ nʋgba, ‑ɛ ꞊gbla, 'a yɩ'siilɛ a ‑ta'. ‑Ɛ ‑bɩ ʋ gba 'yu nɩ, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ, ‑ɛ nɩ 'lɩ Jrusrɛdɩɔ 'kwli, ‑ɛ di꞊e nu, ʋ 'mʋ 'lɩ꞊ɩ ‑ha, ʋ 'mʋ꞊ʋ Nyɩsʋa ‑nyi, 'kɩ 'ʋ 'a ‑kʋan a ‑ta', ");
INSERT INTO ktj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","꞊wɩ yɩ, ‑tɛ ʋ nu 'a 'cɩcrɩɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ: «'A ‑nɛ nʋgba a yɩ‑hɛyu, ‑ɛ mɔ 'yu nyɩbɛyu, ʋ di꞊e 'nɩ ‑ha, ʋ 'mʋ꞊ʋ Nyɩsʋa ‑nyi.» ");
INSERT INTO ktj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","'Tɩ‑ ɛ 'mʋ ‑hi, ‑ɛ ‑bɩ ʋ pi ‑cɔhlʋn a 'mʋ nɩ, Nyɩsʋa a tete ‑hʋɛ, 'kɩ 'ʋ nʋgba, ‑ɛ ꞊gbla a yɩ'siilɛ a ‑ta'. ‑cɔhlʋndʋ a 'mʋ, ɛ mɔ la palɛ‑hungbo nɩ 'hʋɛn, ‑ʋ'ʋ‑ ‑hungboyrɔ nɩ 'hʋɛn. ");
INSERT INTO ktj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ɛ kɔ nyiblo ꞊dʋ, 'ɛ 'ti 'lɩ Jrusrɛdɩɔ 'kwli. 'A 'nyrɛ mɔ Simeɔ. Simeɔ a 'mʋ, 'a 'klɔ 'sii 'ʋ yɩ, 'ɛ ꞊tui 'ʋ Nyɩsʋa 'ʋ. Wanyɔ ‑mʋ', Kʋkɔnyɔ Nyɩsʋa pʋ la lɛ, ɛ di la ya, ɛ 'mʋ 'a dakɔ wa, ɛ nɔ‑ kɔ 'lɩdidie Simeɔ a 'mʋ, ɛ yɩ ‑ple. 'Kɩ Nyɩsʋa a ‑Hihiu* nɩ 'ʋ꞊ʋ ke'. ");
INSERT INTO ktj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nyɩsʋa a ‑Hihiu a 'mʋ, ɛ lee la꞊a nɩ, ‑ɛ mɔ, ɛ 'yɩ la 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ 'kʋ la, 'bʋ mɔ, 'bʋ 'yɩ Wanyɔ a 'mʋ 'ye. ");
INSERT INTO ktj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nyɩsʋa a ‑Hihiu nɩ ‑do a 'mʋ, ɛ nɔ‑ kɔ 'klɩ ‑nu꞊o, 'ɛ mu 'lɩ Nyɩsʋa a 'kagbaʋ bʋ. Bʋ nɩ kɩ 'ʋ bʋ, ‑ɛ ‑bɩ ‑Yusu a 'baɩ kɔ 'a 'dii 'hʋɛn‑, ʋ nʋ‑ ‑di, 'ʋ ya ‑Yusu a 'mʋ, dɛ ‑mʋ', Nyɩsʋa a tete hlɛ, ʋ 'mʋ꞊ʋ nu. ");
INSERT INTO ktj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Bʋ 'ye 'kɩ ꞊nʋ, ‑ɛ ‑bɩ ɛ ‑ha ꞊nʋ 'yu a 'mʋ ‑jɩ', 'ɛ 'ble꞊e kʋa, 'ɛ ‑nyi Nyɩsʋa 'wio, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Kʋkɔnyɔ o, ‑wɛ 'lɩ ‑bʋ daa 'kɩ 'lɩ 'mʋ bʋ nɩ, ꞊bʋ 'kʋ, 'kɩ 'lɩ plɔ a bleelɛ 'kwli, ‑ɛ nu꞊o, dɛ ‑mʋ', ‑pʋ la 'lɩ, ɛ muu kɛ 'lu ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Wanyɔ ‑mʋ', ‑pʋ la lɛ, ‑di la ya, 'kɩ 'ʋ dakɔ a pɛpɛ a wʋwa a ‑ta', 'na 'yie 'ye kɛ꞊ɛ nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Wanyɔ a 'mʋ, ɛ nɔ‑ mɔ ‑nyrɛ. Ɛ nɔ‑ di꞊e nu, dakɔ a pɛpɛ, ʋ 'mʋ꞊ʋ lɛ yru, ‑ɛ mɔ, ‑mɔ mɔ Nyɩsʋa. Ɛ di꞊e 'nɩ nu ‑wɛ, ‑na dakɔ Yisraɛkʋɛ, ʋ 'mʋ ‑tɩ a 'yi'bʋbʋa kɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","‑Tɩ a pɛpɛ a 'mʋ, Simeɔ ‑hla, 'kɩ 'ʋ ‑Yusu a ‑ta', ɛ kɛɛ nɛ 'a 'dii kɔ 'a 'baɩ 'hʋɛn‑ a ꞊wlɩ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeɔ nɩ ‑do a 'mʋ, ɛ ‑hʋa Nyɩsʋa 'klɩ, 'kɩ bʋ nu꞊o ꞊haandɛ ‑mɔ. ‑Ɛ ‑bɩ kɛ‑ ɛ pɩ 'kɩ Mari yɩ: «Nyɩsʋa lee 'nɛ‑ 'yu ‑bʋ ‑tʋtʋ kɩ, ‑ɛ di꞊e nu, 'kɩ 'lɩ Yisraɛkʋɛ 'nyɩ, nyibli ‑hʋɔhʋɩ, ‑ʋ di꞊e nʋa yɩ bʋ pʋ, Nyɩsʋa 'mʋ ꞊nʋ wa, kɛɛ, nyibli ‑mʋ', ‑ʋ 'yɛ nɩ di꞊e nʋa yɩ bʋ nɩ pʋ, Nyɩsʋa 'mʋ ꞊nʋ ‑bati lɛ ‑pʋʋ ‑nɩ. 'Yu a 'mʋ, ɛ nɔ‑ di꞊e nyibli ‑tɔɔ ‑nɩ, ‑ɛ mɔ Nyɩsʋa ni ‑kʋan, kɛɛ, nyibli ‑hʋɔhʋɩ di 'nɩ hɩa, 'kɩ bʋ 'wɩn Nyɩsʋa a 'Yu a 'mʋ 'a win. ");
INSERT INTO ktj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ɛ di꞊e 'nɩ nu ‑wɛ, nyibli ‑hʋɔhʋɩ a ‑huhli‑tɩ ‑mʋ', ʋ yɩ 'lu ‑mɔ lɛ ‑hie, ɛ 'mʋ pepe' bi. ‑Na 'mumu, 'kla ‑di ‑mʋ ‑wliye 'ya, ɛ di 'wɩ‑ ‑tɛ ʋ 'yɛ nɩ pʋ wɛn ‑mʋ ta‑wɔnplɩɛn 'kwli.» Kɛ‑ Simeɔ ‑pʋ. ");
INSERT INTO ktj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ɛ kɔ nʋgba ꞊dʋ ‑wɛ. 'A 'nyrɛ mɔ Hana. Ɛ mɔ Nyɩsʋa a winwlɔn‑hanyɔ* ꞊nɩɔ. 'A 'baɩ a 'nyrɛ mɔ Fanɩɛ. Ɛ pɩ Asɛ꞊tugba. Ɛ ‑wɛ la 'yi dɩakɩ. ‑Tɛ ɛ 'tɩɛ mɔ la nyrayotayu, 'kɩ ɛ kɔɔ la 'ʋ nyɩbɩʋ. Ɛ kɔ꞊ɔ 'hʋɛn‑, ʋ nu 'yrɩ nɩ ꞊hlon'hʋɛn, 'tɩ‑ 'a nyɩbɩʋ a 'mʋ, 'a ‑tɩ 'ɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ɛ 'yɩ 'kɩ nyɩbɩʋ ‑kɔ de, 'ɛ nɩ 'klɔ ‑nɩnɩ, 'ɛ nu 'yrɩ a (84) ‑wlɩ nɩ ‑hɛn ꞊tu 'ʋ ‑hɛn. 'A ‑nɛ ti, 'tɔ kɔ 'nyrɛ 'hʋɛn‑, ɛ 'cibi 'lɩ Nyɩsʋa a 'kagbaʋ bʋ nɩ. Nyɩsʋa a ‑kʋan, ɛ ni, ɛ nɔ‑ mɔ bʋ ꞊ci*, kɔ, bʋ da Nyɩsʋa. ");
INSERT INTO ktj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ɛ kɔ Simeɔ 'hʋɛn‑, ʋ nyre 'ʋ ti nɩ ‑do 'yri, 'ɛ ‑nyi Nyɩsʋa 'wio, 'kɩ 'ʋ ‑Yusu a ‑ta', kɔ, Jrusrɛ a nyibli a pɛpɛ ‑mʋ', ‑ʋ yɩ꞊ɩ ‑ple, 'kɩ Nyɩsʋa bʋ wa 'a dakɔ, ʋ nʋ‑ ɛ yɩ ‑Yusu a ‑tɩ ‑lee ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","‑Tɛ Mari kɔ Sosɛfʋ 'hʋɛn‑, ʋ ‑wɛ ‑tɛblɩ a pɛpɛ a 'mʋ, Nyɩsʋa a tete ‑hʋɛ, 'a nunuo ‑mɔ, ‑ɛ ‑bɩ ʋ ‑mɛ kle, 'ʋ mu 'lɩ 'waa 'dɩɔ ‑mʋ', ‑ɛ mɔ Nasalɛtɩ, 'kɩ 'lɩ Galileblʋgba 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","'Yu a 'mʋ, ʋ ‑kɔ, ɛ kui nɩ, kɔ, 'ɛ nɩ 'klɩ, Nyɩsʋa 'ɛ ‑nyi꞊e ꞊tɔ. Nyibli a pɛpɛ yɩ꞊ɩ 'nɩ 'ye, ‑ɛ mɔ, Nyɩsʋa nʋɛ ꞊nɛ nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","'A ‑nɛ 'yrʋ, ‑Yusu a 'dii kɔ 'a 'baɩ 'hʋɛn‑, ʋ mi la 'lɩ Jrusrɛdɩɔ 'kwli, lɛ'mimle, ‑ɛ mɔ Pakɩ a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","‑Tɛ ‑Yusu kɔ la 'yrɩ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn, ɛ nɔ‑ mɔ 'a yɩ‑hɛdɛ, 'kɩ bʋ mu lɛ'mimledʋ a 'mʋ kɩ, ɛ kɔ 'a 'dii kɔ 'a 'baɩ 'hʋɛn‑, ꞊wɩ yɩ, ‑tɛ ʋ ni꞊e lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","‑Tɛ lɛ'mimle ‑wɛ 'lɩ, ‑ɛ ‑bɩ ‑Yusu a 'dii kɔ 'a 'baɩ 'hʋɛn‑, ʋ ꞊hɩan ‑mɔ, 'ʋ mi 'lɩ 'waa 'dɩɔ 'kwli. Kɛɛ, ‑Yusu ‑mɔ ‑bɩ, ɛ 'yɩ ‑mu. 'Kɩ ɛ 'tɩɛ nɩ 'lɩ Jrusrɛdɩɔ 'kwli. 'A 'baɩ kɔ 'a 'dii 'hʋɛn‑, ʋ 'yɩ 'ʋ꞊ʋ ꞊dedede 'hʋɩ ‑yi. ");
INSERT INTO ktj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","'Waa ꞊wlʋ daa ꞊nɛ, ‑Yusu kɔ 'hrunanyʋ ‑bɩ 'hʋɛn‑, nʋ‑ mi. Bʋ na ‑nyrɔwɔ 'mumu a 'hru, ‑ɛ ‑bɩ ʋ ‑tʋa 'a lɛ꞊mʋmʋɔ, 'kɩ 'lɩ 'waa 'dʋkʋɛ kɔ 'waa yiyinyibli 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","‑Tɛ ʋ 'yɩ 'kɩ꞊ɩ 'ye, ‑ɛ ‑bɩ ʋ ‑mɛ kle, 'ʋ mu 'lɩ Jrusrɛdɩɔ 'kwli, ʋ 'mʋ꞊ʋ 'yie lɛ ꞊mʋɔ ‑nɩ, kɛɛ, ʋ 'yɩ꞊ɩ 'ye. ");
INSERT INTO ktj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","‑Nyrɔwɩ nɩ ta a ‑nyrɔwɔ 'kwli, ‑ɛ ‑bɩ ʋ 'ye꞊e nɩ, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ, 'ɛ nɩ bʋ, 'kɩ 'lɩ ‑Juukʋɛ* a tetetɔɔnyʋ 'nyɩ, 'ɛ pɩ ꞊nʋ nʋa yɩ bʋ, 'ɛ yɩ ꞊nʋ lɛ 'bɛti ‑nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","'Yu bʋ di 'mʋ lɛ nɩ, bʋ di ꞊tɔdʋ a 'mʋ kɔ, kɔ, bʋ di 'waa lɛ'bɛti‑tɛblɩ a klɛ‑hɩhɩalɛ nu, ɛ kɛɛ nyibli ‑mʋ', ‑ʋ nɩ ‑tuo kɩ a ꞊wlʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","‑Tɛ 'a 'dʋkʋɛ 'ye꞊e, ‑ɛ ‑bɩ ɛ kɛɛ ꞊nʋ lɛ, ‑ɛ ‑bɩ 'a 'dii wɛn: «Dɛ kɔ ‑mɔ nu 'a nunuo lɛ 'lɩ, ꞊nɩ pʋ 'lɩ ‑a mʋ hʋannʋ 'kwli? ‑Na 'baɩ kɔ 'mʋ 'hʋɛn‑, ꞊wlɩlɛkɛɛlɛ 'kwli ‑a ꞊mʋɛ 'lɩ ‑mʋ lɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","‑Ɛ ‑bɩ ɛ ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «Dɛ‑ kɔ ‑tɩ 'a ꞊mʋɛ 'mʋ lɛ 'lɩ? ꞊Bɩ a 'yɩ 'a yiyie ‑kɔ, ‑ɛ mɔ, 'kɩ 'n di 'nɛ‑ 'na 'Baɩ Nyɩsʋa a 'kagbaʋ bʋ nɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kɛɛ, ‑tɩ a 'mʋ, ɛ hlɛ ꞊nʋ yɩ, ʋ 'nɩ ‑yru꞊o lɩ꞊ɩ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","‑Tɛ ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu kɔ ꞊nʋ 'hʋɛn‑, ʋ ‑mɛ kle, 'ʋ mu 'lɩ Nasalɛtɩ, ‑ɛ mɔ 'waa 'dɩɔ. Ɛ ꞊tui 'ʋ ꞊nʋ nɩ 'a nɛ ti. ‑Tɛblɩ a pɛpɛ a 'mʋ, ‑ɛ mu 'lu ‑mɔ, ɛ 'yɩ 'a 'dii ‑mɔ ‑hru. 'A pɛpɛ nɩ 'lɩ 'a ꞊wlʋ kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","‑Yusu kui la nɩ, kɔ, 'a ꞊tɔ 'ɛ yɩ la klɛ ‑bii ‑nɩ, Nyɩsʋa kɔ nyibli 'hʋɛn‑, 'ʋ nʋɛ la꞊a dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","‑Tɛ 'yrɩ gbi ‑hi, ‑ɛ ‑bɩ Saan, ‑ɛ mɔ Sakali a 'yu, 'kɩ ɛ 'tɩɛ nɩ 'lɩ ‑tɩtɛ ‑mʋ', nyibli 'yɩ 'lɩ 'ti, Nyɩsʋa 'ɛ da꞊a, ɛ wɛn: «Lee 'na ‑tɩ nyibli.» Ti a 'mʋ 'yri, Romakʋɛ a 'kɩɩn gbagbʋ Tibɛlɩ, ‑tɛ ɛ bi la gbata kɩ, 'a 'yrɩ nɩ ‑pu ꞊tu 'ʋ ꞊hun a 'yrʋ ꞊nɩɔ. Pʋsɩ Pilatɩ, ɛ nɔ‑ mɔ Sudeblʋgba a ‑gʋlʋnʋma. Helɔdɩ, ɛ nɔ‑ kɔɔ Galileblʋgba win kɩ. 'A 'dɩayɩ Filipʋ, ɛ nɔ‑ kɔɔ Yituleblʋgba win kɩ, kɔ Trakonitɩblʋgba 'hʋɛn‑. Lisaniasɩ, ɛ nɔ‑ kɔɔ Abilɛnɩblʋgba win kɩ. Hanɩ kɔ Kaifʋ 'hʋɛn‑, ʋ nʋ‑ mɔ Nyɩsʋa a ‑cɔhlʋnpinyʋ* a nyibli gbagbɩ. ");
INSERT INTO ktj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","‑Ɛ ‑bɩ Saan a 'mʋ, ɛ bi 'hru wlɔn, 'ɛ mu 'lɩ 'nie ‑mʋ', ʋ dɛɛ Sudɛn wien, 'ɛ ‑tʋa 'blʋgbakɩbɩa ‑mʋ', ‑ɛ nɩ 'ʋ 'nie wien a kɩnɩna. 'Bʋ yɩ nɩ 'plɛ, 'ɛ 'yɛɛ 'lɩ win, 'ɛ yɩ nyibli ‑lee ‑nɩ, ɛ wɛn: «Ba yru꞊o, 'kɩ 'lɩ 'aan ꞊wlɩ kɩ, ‑ɛ mɔ, a ni yɩnyre‑tɛblɩ, 'kɩ 'ʋ Nyɩsʋa ye'. Ba hie 'ʋ yɩnyre‑tɛblɩ a 'mʋ bʋ, ba ‑nyi 'aan 'klɔ a pɛpɛ Nyɩsʋa, Nyɩsʋa 'mʋ 'aan yɩnyre‑tɛblɩ 'wʋwla ‑nɩ, 'mʋ 'a mʋ 'nie 'lu pʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","‑Tɛ Saan yɩ ‑tɩ a 'mʋ nɩ hlɛ, ‑ɛ ‑bɩ ‑tɩ ‑mʋ', Nyɩsʋa a winwlɔn‑hanyɔ Esai 'crɩ la, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ti ꞊dʋ ‑hi la a ti 'yri, ɛ nyre 'ʋ nɩ. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: «Nyɩsʋa wɛn 'nɩ: Nyiblo ꞊dʋ, ‑tɛ ‑mʋ', 'dʋ bii 'lɩ yɩ, 'kɩ ɛ di 'lɩ 'ti. 'Bʋ mɔ, 'bʋ yɩ nɩ hle, ɛ di 'yaa 'lɩ win, ɛ 'mʋ lɛ pʋ: 'Hru ‑bʋ, Kʋkɔnyɔ di na, ba 'sii ꞊nɛ yɩ, 'tɩ‑ Kʋkɔnyɔ a 'mʋ, ɛ 'mʋ di. Ɛ 'wɩ yɩ, 'aan 'klɔ bʋ 'sii 'ʋ yɩ, ‑ɛ di꞊e nu, a 'mʋ ‑mɔ ‑wɛ, 'tɩ‑ Kʋkɔnyɔ 'mʋ di. ");
INSERT INTO ktj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ba ka 'nɩhannɩ a pɛpɛ, kɔ, ba wa dʋgbɩ a pɛpɛ, ‑ɛ di꞊e nu, 'hrii 'mʋ kɩ bʋ ‑wɛɛn ‑nɩ. 'Hrii ‑mʋ', ‑ʋ 'yɩ 'lɩ yɩ blɛ ‑nyraa ‑nɩ, ba 'sii ꞊nʋ yɩ ‑wɛ, 'a dɛ ‑mʋ', ‑ʋ nyre yɩ, ba ꞊hrɛntɩ ꞊nʋ. ");
INSERT INTO ktj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","‑Ɛ ‑bɩ Wanyɔ ‑mʋ', Nyɩsʋa di ya, nyibli a pɛpɛ di꞊e 'nɩ 'ye.» ");
INSERT INTO ktj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nyibli ‑hʋɔhʋɩ, ʋ nʋ‑ mi 'lɩ Saan ‑mɔ, ‑ɛ di꞊e nu, ɛ 'mʋ ꞊nʋ 'nie 'lu pʋ. Kɛ‑ ɛ pɩ nyibli a 'mʋ yɩ, ɛ wɛn: «'A mʋ ‑mʋ', a kɛɛ nyibli, 'aan nunuklɔ 'ɛ nyre yɩ, ‑wɛn hro. Nyɩsʋa a yrʋ 'tɩɛ kwlɛ 'a mʋ nɩ. A 'nɩ 'pʋʋ 'lɩ lɛ, ‑ɛ mɔ, a ‑wɛ 'lɩ ba 'gba꞊a ye' ci nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","'Tɩ‑ 'mʋ 'a mʋ 'nie 'lu pʋ, ba nu ꞊haan‑tɛblɩ, ʋ 'mʋ꞊ʋ 'ye, ‑ɛ mɔ, a hie 'ʋ dɛ 'kuku, a ni bʋ, 'a ‑nyi 'aan dɩɔnʋ Nyɩsʋa. A 'nɩ 'pʋʋ 'lɩ lɛ, ‑ɛ mɔ, a mɔ ‑aan 'baɩ gbagbʋ Abrahamʋ a 'yonʋ ꞊nɩɔ, 'a ‑tɩ, Nyɩsʋa 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ pʋʋ nɛ 'a mʋ yrʋ lɛ. 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, Nyɩsʋa ‑wɛ 'lɩ bʋ nu꞊o nɩ, 'hɩ ‑bʋ, bʋ ‑hɛ Abrahamʋ a 'yonʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ʋ ‑wɛ ‑mɔ, 'kɩ bʋ nu 'duwe, bʋ hla 'a ‑nɛ tugbɛ ꞊dʋ, ‑ɛ 'yɛ nɩ tʋ 'kui, ʋ 'mʋ꞊ʋ 'tɔ pʋ. Ɛ ꞊hɛn 'nyrɛ, ‑ɛ mɔ, Nyɩsʋa ‑wɛ ‑mɔ, 'kɩ bʋ pʋʋ nyibli ‑mʋ', ‑ʋ 'yɛ nɩ ꞊tuu 'ʋ꞊ʋ 'ʋ ‑bati lɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kɛ‑ nyibli ‑mʋ', ‑ʋ nɩ ‑tuo kɩ, ʋ pɩ, 'ʋ yɩ꞊ɩ 'bɛti ‑nɩ: «Dɛ a 'dɩ ‑bɩ ‑a di nu 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","‑Ɛ ‑bɩ ɛ ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «Nyiblo 'bʋ nɩ 'ʋ, 'bʋ kɔ wlawlɩ nɩ 'hʋɛn, bʋ ‑ha 'lɩ wlawlʋ nɩ ‑do, bʋ ‑nyi꞊e nyiblo ‑mʋ', ‑ɛ 'yɩ 'a dɛ ‑kɔ. Nyiblo 'bʋ nɩ 'ʋ, 'bʋ kɔ dididɛ, bʋ ‑nyi 'a 'bɩ ‑mʋ', ‑ɛ 'yɩ 'a dɛ ‑kɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ɛ kɔ 'blʋwli'tɩnyʋ, 'ʋ mu 'lɩ꞊ɩ ‑mɔ ‑wɛ, ‑ɛ di꞊e nu, ɛ 'mʋ ꞊nʋ 'nie 'lu pʋ, ʋ wɛn: «Tɔɔnyɔ, dɛ a 'dɩ ‑bɩ ‑a di nu 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","‑Ɛ ‑bɩ ɛ ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «‑Tie ‑mʋ', Romakʋɛ a naanyʋ pʋ lɛ, nyibli bʋ 'pɛɛ ‑nɩ, a 'nɩ 'pʋʋ 'ʋ꞊ʋ dɛ 'lu. 'A ‑tɛɛ, nɔ‑ ba 'tɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","'Sɛyo mu 'lɩ꞊ɩ ‑mɔ ‑wɛ, ʋ wɛn: «‑Aan 'mumu, dɛ‑ ‑a di nu 'lɩ?» ‑Ɛ ‑bɩ ɛ ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «A 'nɩ 'nuo 'lɩ 'klɩ, a 'nɩ 'haa 'lɩ nyibli 'wli ꞊jrɛ. A 'nɩ 'pʋʋ 'lɩ nyibli hɩ klɛ, 'kɩ 'ʋ dɛ ‑mʋ', ʋ 'yɩ ‑nu a ‑ta', ‑ɛ di꞊e nu, ʋ 'mʋ 'a mʋ 'wli ‑nyi a ‑tɩ. 'Aan 'pɛɛwli nu 'a mʋ ‑tɛɛ. A 'nɩ 'pʋʋ 'lɩ꞊ɩ 'yiyriwli ꞊dʋ kɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nyibli a pɛpɛ, ʋ nɩ 'ʋ ‑pleelɛ'. Ʋ nʋ‑ ‑mɔ ‑bɩ, ʋ wɛn 'nɩ, ‑baklɛ, Saan, nɔ‑ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya, 'kɩ 'ʋ dakɔ a wʋwa a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kɛ‑ Saan pɩ ꞊nʋ yɩ, ɛ wɛn: «'Mɔ ‑bʋ, 'nie, ɛ nɔ‑ 'n pɩ 'a mʋ 'lu lɛ. Kɛɛ, nyiblo ‑bɩ di 'nɩ di. Nɔ‑ di 'ʋ 'mʋ ke' kʋɛ. Nɔ‑ di 'klɩ kɩ nɩ, ɛ 'mʋ 'ʋ 'mʋ ‑hi, 'kɩ 'lɩ Nyɩsʋa a 'nyrɛ 'kwli. 'Mɔ ‑bʋ, 'n 'yɩ nyiblo ꞊dʋ 'pa‑, 'kɩ ꞊bʋ di꞊e ‑hɛɛ ‑nɩ, 'kɩ 'ʋ 'a ‑nɛ ‑kʋandɛ ꞊dʋ a ‑ta'. Nyiblo a 'mʋ, ‑ɛ di di, Nyɩsʋa a ‑Hihiu*, kɔ na ‑bʋ, ‑ɛ yɩ wlɩn, ɛ nɔ‑ ɛ di 'a mʋ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nyiblo a 'mʋ, ɛ di 'wɩ‑ ‑kʋbʋlɛ꞊hlonnyɔ yɩ, ‑ɛ 'ble ‑ŋmahɛn kʋa, ɛ di nu, ɛ 'mʋ ‑kʋbʋ lɛ ꞊hlon, 'bʋ ꞊hlon ‑kʋbʋ a 'mʋ lɛ, ɛ 'mʋ꞊ʋ bʋ ꞊tu, ɛ 'mʋ 'a ꞊tutui 'tɔ pʋ, 'kɩ 'lɩ na ‑mʋ', ‑ɛ 'yɛ nɩ jre 'nyɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","꞊Tɔ a gblegble a 'mʋ, Saan pɩ, ɛ nɔ‑ kɔ 'kwli ɛ nɛɛ 'lɩ, 'ɛ pɩ nyibli Nyɩsʋa a ꞊haantitie. ");
INSERT INTO ktj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kɛɛ, ‑ɛ ‑bɩ ‑gʋlʋnʋma Helɔdɩ, ɛ nɔ‑ Saan ‑kii la nɩ, ‑ɛ nu꞊o, Helɔdɩ a 'mʋ, ɛ nɔ‑ ‑ha la 'a 'dɩayɩ nʋgba ‑jɩ', kɔ, 'ɛ nu la yɩnyre‑tɛblɩ ‑hʋɔhʋɩ ‑bɩ. ");
INSERT INTO ktj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","‑Tɛ Saan ‑kii la꞊a, ‑ɛ ‑bɩ Helɔdɩ a 'mʋ, ɛ nu la yɩnyredɛ ‑bɩ de. Ɛ nɔ‑ mɔ bʋ pʋ la Saan a 'mʋ ꞊jɩ'. ");
INSERT INTO ktj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","‑Tɛ ʋ 'tɩɛ 'yɛɛ la Saan ꞊jɩ' nɩ pɩ, 'tɩ‑ Saan 'mʋ nyibli a pɛpɛ 'nie 'lu lɛ pʋ, ‑ɛ ‑bɩ ‑Yusu nyre 'ʋ nɩ, Saan 'ɛ pʋ꞊ʋ 'nie 'lu, ‑Yusu 'ɛ ‑tʋa Nyɩsʋa a dɩda. Ɛ nɩ 'lɩ Nyɩsʋa a dɩda 'kwli, yakɔ 'ɛ ‑ki wlɔn, ");
INSERT INTO ktj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Nyɩsʋa a ‑Hihiu* 'ɛ ꞊tɩɩ 'ʋ꞊ʋ 'lu, ꞊wɩ yɩ, ‑tɛ ‑hungbe 'yɛ nɩ ꞊tɩɩ 'ʋ꞊ʋ 'lu, 'tɩ‑ 'ʋ 'wɩn Nyɩsʋa a win, 'ɛ ‑hɔn 'lɩ yakɔ 'kwli, 'ɛ pɩ lɛ: «‑Mɔ mɔ 'na 'Yu nɩ ‑do, 'n nʋɛ ‑nɩ ‑tɛɛ. ‑Nie 'mʋ dɔdʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","38","Dɛ a 'mʋ bʋ ‑hi, ‑ɛ ‑bɩ ‑Yusu ꞊tu ‑kʋan ‑wlu. Ti a 'mʋ 'yri, ɛ ‑wɛ 'lɩ bʋ kɔ la 'yrɩ a (30) ‑wlʋ ꞊tu 'ʋ ‑pu nɩ. Nyibli a ꞊wlɩ wɛn 'nɩ, Sosɛfʋ ‑mɔ 'a 'baɩ. Sosɛfʋ a 'mʋ, 'a 'baɩnʋ a 'nyrɛ, nɔ‑ ‑bʋ: ");
INSERT INTO ktj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nyɩsʋa a ‑Hihiu* kɔɔ ‑Yusu win kɩ pɛpɛ. ‑Yusu a 'mʋ, ɛ nɔ‑ ‑hɔn 'lɩ 'nie ‑mʋ', ‑ɛ mɔ Sudɛn wien, Nyɩsʋa a ‑Hihiu a 'mʋ, 'ɛ gba 'lɩ꞊ɩ ‑tɛ ‑mʋ', nyiblo ꞊dʋ 'yɩ 'lɩ 'ti. ");
INSERT INTO ktj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","‑Ɛ ‑bɩ 'kuo ‑hʋɩn* a nyiblo gbagbʋ, kɛ‑ ɛ pɩ, 'ɛ yɩ 'ʋ ‑Yusu lɛ ꞊tɛɛ ‑nɩ, ‑ɛ di꞊e nu, ɛ 'mʋ ‑tɩ 'wla, 'kɩ 'ʋ 'a 'Baɩ Nyɩsʋa ye', 'ɛ ꞊tɛɛ 'ʋ꞊ʋ lɛ, 'kɩ 'lɩ ‑nyrɔwɩ a ‑wlɩ nɩ 'hʋɛn 'kwli. 'Kɩ 'lɩ ‑nyrɔwɩ a 'mʋ 'kwli, ‑Yusu ꞊ci* nɩ. ‑Tɛ ɛ ‑hi, ‑ɛ ‑bɩ 'kanʋ ‑tʋa la 'a nunuo. ");
INSERT INTO ktj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","‑Ɛ ‑bɩ 'kuo ‑hʋɩn a nyiblo gbagbʋ wɛn: «'Bʋ mɔ, ꞊nɩ mɔ Nyɩsʋa a 'Yu, lee 'hɩɔ ‑bʋ, bʋ ‑hɛ 'flɔɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","‑Ɛ ‑bɩ ‑Yusu ꞊tu꞊o ꞊wɔn, ɛ wɛn: «Ʋ 'crɩ꞊ɩ nɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ, ɛ 'yɩ dididɛ nɩ ‑do 'pa‑, ɛ 'nɩ ‑nu꞊o lɩ꞊ɩ, ‑tonyiblo 'nɩ ‑nɩ꞊ɩ 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","‑Tɛ ɛ ‑hi, ‑ɛ ‑bɩ 'kɩ 'kuo ‑hʋɩn a nyiblo gbagbʋ gba 'lɩ ‑Yusu dʋgba ꞊dʋ 'lu, ti nɩ ‑do a ti 'yri, 'ɛ tɔɔ ꞊nɛ ‑tʋtʋ kɩ a 'blʋgbɩ a pɛpɛ, ");
INSERT INTO ktj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ɛ wɛn: «'Blʋgbɩ ‑bʋ, 'a 'klɩ, kɔ 'a ‑tɩ a 'yi'bʋbʋa, 'n di ‑mɔ꞊ɔ 'nɩ ‑nyi. 'A pɛpɛ a 'mʋ, ʋ ‑nyi 'mɔ꞊ɔ nɩ. 'Na 'mumu, nyiblo, 'n ‑hʋɛ, ɛ nɔ‑ 'n di꞊e ‑nyi ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","'A ‑tɩ, 'bʋ mɔ, ꞊nɩ bla 'mʋ kwlɩ yɩ bʋ, 'kɩ 'ʋ 'na 'ʋ꞊tuulɛ a ‑ta', ‑mɔ di 'a pɛpɛ a 'mʋ kɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","‑Ɛ ‑bɩ ‑Yusu ꞊tu꞊o ꞊wɔn, ɛ wɛn: «Ʋ 'crɩ꞊ɩ nɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ: ‑Na Kʋkɔnyɔ Nyɩsʋa nɩ ‑do, ɛ nɔ‑ blɛɛ yɩ, ‑bʋ bla kwlɩ bʋ, 'kɩ 'ʋ 'a 'ʋ꞊tuulɛ a ‑ta', nɔ‑ blɛɛ ‑tɩ a 'yi'bʋalɛ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Dɛ a 'mʋ, ‑tɛ ɛ ‑hi, ‑ɛ ‑bɩ 'kuo ‑hʋɩn a nyiblo gbagbʋ gba 'lɩ꞊ɩ Jrusrɛdɩɔ 'kwli, 'ɛ 'yaa 'lɩ꞊ɩ Nyɩsʋa a 'kagbaʋ kɩ, ɛ wɛn: «'Bʋ mɔ, ꞊nɩ mɔ Nyɩsʋa a 'Yu, ‑ɛ ‑bɩ ‑bʋ ꞊pluu 'lɩ ꞊hlɔn, ");
INSERT INTO ktj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","‑ɛ nu꞊o, ʋ 'crɩ꞊ɩ nɩ, ‑ɛ mɔ: ‑Na ‑tɩ, Nyɩsʋa kɔ bʋ lee nɛ 'a lɛlenyʋ, ʋ 'mʋ ‑mʋ 'yie ꞊tu, ");
INSERT INTO ktj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ʋ 'mʋ ‑mʋ klɔ, ‑ɛ di꞊e nu, ‑na bʋ 'nɩ ꞊ha 'hɩɔ yɩ ꞊gbɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","‑Ɛ ‑bɩ ‑Yusu ꞊tu꞊o ꞊wɔn, ɛ wɛn: «Ʋ 'crɩ꞊ɩ nɩ ‑wɛ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ: ꞊Yɩ yɩ ‑blɛɛ ‑nɩ, ‑bʋ ꞊tɛɛ 'ʋ ‑na Kʋkɔnyɔ Nyɩsʋa lɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","‑Tɛ 'kuo ‑hʋɩn a nyiblo gbagbʋ ‑wɛ 'kɩ ‑Yusu a lɛ꞊tɛɛlɛ ‑mɔ, 'kɩ 'lɩ 'kabɩ a gblegble 'kwli, ‑ɛ ‑bɩ ɛ ‑ha꞊a mɛ lɛ, 'ɛ mu 'ʋ ti lɛ ‑ple mɔ, ‑ɛ kɔ 'yri ɛ di 'ʋ꞊ʋ lɛ ꞊tɛɛ mɔ ‑dii ‑nɩ de. ");
INSERT INTO ktj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu ꞊hɩan ‑mɔ, 'ɛ mu 'lɩ Galileblʋgba 'kwli. Nyɩsʋa a ‑Hihiu*, 'ɛ kɔɔ ꞊nɛ win kɩ pɛpɛ, 'ɛ ‑nyi꞊e 'klɩ. 'A 'nyrɛ 'hɛɛn la 'blʋgba a pɛpɛ kɩ bʋ, ");
INSERT INTO ktj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","'ɛ tʋɛ Nyɩsʋa a ‑tɩ, 'kɩ 'lɩ Nyɩsʋa a 'kayo blɛ, nyibli a pɛpɛ 'ʋ 'bʋɛ Nyɩsʋa a ‑tɩ 'yi. ");
INSERT INTO ktj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","‑Nyrɔwɔ ꞊dʋ, 'kɩ ‑Yusu mu 'lɩ Nasalɛtɩ, ‑ɛ mɔ 'dɩɔ ‑kɔ 'kwli ɛ kuu 'lɩ. ‑Wuwle‑nyrɔwɔ*, 'ɛ pa 'lɩ Nyɩsʋa a 'kayu bʋ, ꞊wɩ yɩ, ‑tɛ ɛ ni꞊e lɛ, 'ɛ 'du ye', ‑ɛ di꞊e nu, ɛ 'mʋ Nyɩsʋacrɩɛn ‑hre, ");
INSERT INTO ktj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","'ʋ ‑nyi꞊e 'crɩɛn ‑mʋ', Nyɩsʋa a winwlɔn‑hanyɔ Esai 'crɩ la, 'ɛ kla꞊a yɩ, 'ɛ yɛ 'crɩɛnkʋtɩɔ ‑mʋ' kɩ, ɛ ꞊mʋɛ wɛn lɛ. 'Crɩɛnkʋtɩɔ a 'mʋ, 'a win, ɛ nɔ‑ ‑bʋ: ");
INSERT INTO ktj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Nyɩsʋa a ‑Hihiu*, ɛ nɔ‑ nɩ 'ʋ 'mʋ ke', Nyɩsʋa 'ɛ ‑ha 'lɩ 'mʋ, 'kɩ ꞊bʋ pʋ 'a ꞊haantitie nyibli ‑mʋ', ‑ʋ nɩ nyaɩ lɛ, Nyɩsʋa 'ɛ lee 'mʋ, 'kɩ ꞊bʋ lee ꞊koyo, ‑ɛ mɔ, ɛ di ꞊nʋ 'nɩ ꞊gblɛ. ꞊Bʋ lee 'yii'dɔnyʋ, ‑ɛ mɔ, ɛ di꞊e 'nɩ nu, ʋ 'mʋ lɛ yru. ꞊Bʋ lee nyibli ‑mʋ', ʋ ꞊tui ꞊hɩʋɛn, ‑ɛ mɔ, ɛ di ꞊nʋ 'nɩ ꞊gblɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","꞊Bʋ lee 'waa pɛpɛ, ‑ɛ mɔ, ti nyre 'ʋ nɩ, ‑ɛ kɔ 'yri Kʋkɔnyɔ di 'ʋ ꞊nʋ꞊ʋ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, ɛ nʋɛ ꞊nʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","‑Tɛ ‑Yusu ‑wɛ ‑mɔ, ‑ɛ ‑bɩ ɛ 'pla 'crɩɛn a 'mʋ nɩ, 'ɛ ‑nyi꞊e Nyɩsʋa a 'kayu a ‑kʋannunyɔ, 'ɛ nɩ bʋ. Nyibli a pɛpɛ, ‑ʋ nɩ 'lɩ Nyɩsʋa a 'kayu bʋ, ʋ 'wlaa ꞊nɛ 'yii ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ de, ɛ wɛn: «'Crɩɛnkʋtɩɔ ‑mʋ', 'n ‑hre wɛn, a 'wɩn wɛn, ‑tɩ ‑bʋ, ɛ hlɛ, kɩkɛ ‑bʋ, 'kɩ ɛ muu kɛ 'ʋ 'lu ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nyibli a pɛpɛ, ‑ʋ nɩ 'ʋ, ʋ wɛn 'nɩ: «Ɛ yɩ 'nɩ 'plɛ ‑tɛɛ.» Ɛ kɛɛ ꞊nʋ ꞊wlɩ lɛ, 'kɩ 'ʋ yɩnɔwin, ɛ pɩ a ‑ta', ʋ wɛn: «꞊Bɩ nyiblo ‑bʋ, ɛ 'yɩ Sosɛfʋ a 'yu 'pa‑?» ");
INSERT INTO ktj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","‑Ɛ ‑bɩ ‑Yusu wɛn: «'N yi꞊e nɩ, ‑ɛ mɔ, a di pʋ 'mʋ 'ledʋ ‑bʋ yɩ, ‑ɛ mɔ: ‑Dɔtɔ, pɩa ‑dɩɔnʋ, a 'mʋ 'mʋ yrɛ pʋ de: ꞊Wlɩlɛkɛɛ‑tɛblɩ a pɛpɛ ‑mʋ', ‑nuu 'lɩ Kapɛnaɔdɩɔ 'kwli, ‑a 'wɩn 'a ‑tɩ nɩ. Ʋ nɩ ‑do a 'mʋ, nuu 'nɛ꞊ɛ ‑dɩɔnʋ a 'dɩɔ 'kwli ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ɛ wɛn 'nɩ de: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ɛ 'yɩ Nyɩsʋa a winwlɔn‑hanyɔ* ꞊dʋ ‑kɔ, ʋ kuo ꞊wlʋ yɩ, 'kɩ 'lɩ 'a dɩɔnʋ a 'dɩɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ de, ꞊wlɩlɛkɛɛ‑tɛblɩ ‑mʋ', Nyɩsʋa a winwlɔn‑hanyɔ Eli ni la, bʋ bi 'lɩ 'a mʋ 'kwli, ti ‑kɔ 'yri 'nu 'kee la didie, 'ɛ gba 'yrɩ nɩ ta nɛ ꞊hɔnpʋɩ nɩ ꞊hlon'hʋɛn, kɔ, ‑tɛ 'kanʋ yɩ la lɛ di, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ. Ti a 'mʋ 'yri, ‑tʋgbanʋgbɩ ‑hʋ la 'nɛ‑ Yisraɛkʋɛ a 'blʋgba 'kwli nɩ, 'ʋ ‑hʋɛ la ‑hɛɛlɛ. ");
INSERT INTO ktj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kɛɛ, ɛ 'yɩ la nyiblo ꞊dʋ ‑kɔ, Nyɩsʋa bʋ lee la 'lɩ Eli ‑mɔ, 'bʋ 'yɩ la ‑tʋgbanʋgba nɩ ‑do ‑mʋ', ‑ɛ 'yɩ Yisraɛkʋɛyrʋwlʋ 'pa‑. 'Kɩ ɛ 'ti la 'lɩ hɩapʋdakɔ ‑bɩ 'nyɩ, 'kɩ 'lɩ Salɛtadɩɔ 'kwli, ‑ɛ 'mʋɛ Sidɔdɩɔ yrɛ, Eli a 'mʋ 'ɛ ‑hɛɛ la꞊a, 'kɩ 'lɩ ꞊wlɩlɛkɛɛdɛ 'kwli, ‑ɛ nu꞊o, ‑tʋgbanʋgba a 'mʋ, ɛ kuo la Nyɩsʋa ꞊wlʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kʋɛ 'ʋ꞊ʋ ‑mɔ bʋ de, Nyɩsʋa a winwlɔn‑hanyɔ Elise a ti 'yri, ꞊hrannunyʋ ‑hʋʋ la 'nɛ‑ Yisraɛkʋɛ a 'blʋgba 'kwli nɩ. Kɛɛ, Elise a 'mʋ, ɛ 'yɩ la 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑wɛɛ la nyiblo ꞊dʋ a 'kʋɛ, 'bʋ 'yɩ nyiblo ‑bʋ, ‑ɛ mɔ Naama, ‑ɛ 'yɩ Yisraɛkʋɛyu 'pa‑, ‑ɛ kɔ 'lɩ Siliblʋgba 'kwli. Ɛ nɔ‑ kɔ 'kʋɛ ɛ ‑wɛɛ la ‑nɩ, ‑ɛ nu꞊o, ɛ kuo la Nyɩsʋa ꞊wlʋ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nyibli a pɛpɛ a 'mʋ, ‑ʋ nɩ 'lɩ Nyɩsʋa a 'kayu bʋ, ‑tɛ ʋ 'wɩn ‑tɩ a 'mʋ, ‑Yusu ‑hla, ‑ɛ ‑bɩ ʋ bi yrʋ' lɛ, ");
INSERT INTO ktj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","'ʋ 'du ye' lɛ, 'ʋ klɔ꞊ɔ, 'ʋ ꞊tɩɔ ꞊nɛ 'dɩɔ, 'ʋ gba 'lɩ꞊ɩ dʋgba ‑mʋ', ‑ɛ kɔ 'lu 'waa 'dɩɔ nɩ 'lɩ, ‑ɛ di꞊e nu, ʋ 'mʋ 'lɩ꞊ɩ yɩ 'nyraa ‑nɩ, ɛ 'mʋ ꞊hlɔn bi, ɛ 'mʋ 'kʋ. ");
INSERT INTO ktj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kɛɛ, 'kɩ ɛ naa 'lɩ ꞊nʋ 'nyɩ, 'ɛ ‑mu. ");
INSERT INTO ktj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ 'kɩ ‑Yusu mu 'lɩ 'dɩɔ ‑mʋ' 'kwli, ‑ɛ kɔ 'nyrɛ mɔ Kapɛnaɔ, 'kɩ 'lɩ Galileblʋgba 'kwli. ‑Tɛ ‑Juukʋɛ* a ‑wuwle‑nyrɔwɔ* nyre 'ʋ, ‑ɛ ‑bɩ 'kɩ ɛ mu 'lɩ Nyɩsʋa a 'kayu bʋ, ");
INSERT INTO ktj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","'ɛ bi 'ʋ yɔ', 'ɛ ‑tʋa nyibli Nyɩsʋa a ‑tɩ a tɔɔlɛ. Nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, ɛ mɔ 'waa ꞊wlɩlɛkɛɛdɛ, 'kɩ ‑Yusu bʋ di tɔɔlɛ lɛ nu, ‑ɛ nu꞊o, 'kɩ 'lɩ Nyɩsʋa a 'klɩ 'kwli, 'kɩ ɛ tʋɛ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ɛ kɔ nyɩbɛhɩan ꞊dʋ. Ɛ nɔ‑ 'ku ‑hʋan nɩ 'ʋ ke'. 'Kɩ 'lɩ Nyɩsʋa a 'kayu nɩ ‑do a 'mʋ bʋ, ɛ 'yɛɛ 'lɩ win, 'ɛ pɩ lɛ: ");
INSERT INTO ktj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Nasalɛtɩ a ‑Yusu, ‑ha ‑a mʋ mɛ lɛ, ꞊nɩ 'bie 'lɩ ‑aan ‑tɩ 'nyɩ. ‑Di nɩ, ꞊mʋ ‑a mʋ bʋ ‑wɛ. 'N yi꞊e nɩ, nyiblo a 'dɩ ‑bɩ ‑pa 'mʋ. ‑Mɔ mɔ Nyɩsʋa a 'Yu, ‑mɔ ɛ lee 'nɛ‑.» ");
INSERT INTO ktj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ‑Yusu ꞊maa 'ku ‑hʋan a 'mʋ 'yi, ɛ wɛn: «Ma wien, 'tɩ‑, ‑hɔn 'ʋ nyiblo ‑bʋ ke'!» Ɛ nɔ‑ mɔ 'ku ‑hʋan a 'mʋ bʋ ‑hli nyiblo a 'mʋ bʋ, 'kɩ 'ʋ nyibli a pɛpɛ ye', 'tɩ‑ 'ɛ ‑hɔn 'ʋ꞊ʋ ke', 'ɛ ‑mu, kɛɛ, ɛ 'yɩ꞊ɩ dɛ ‑hʋan ꞊dʋ ‑mɔ ‑nu. ");
INSERT INTO ktj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nyibli a pɛpɛ ‑mʋ', ‑ʋ nɩ 'ʋ, ɛ mɔ 'waa ꞊wlɩlɛkɛɛdɛ. Kɛ‑ ʋ pɩ, 'ʋ ye' lɛ 'pʋplɛ ‑nɩ, ʋ wɛn: «Dɛ a 'mʋ, ɛ mɔ dɛ ꞊nɩɔ. Nyiblo ‑bʋ, 'a pʋpʋwin nɩ 'klɩ kɩ dɩakɩ, 'tɩ‑, 'ɛ kɔɔ 'kuo ‑hʋɩn win kɩ. 'Bʋ pʋ lɛ, 'ku ‑hʋan bʋ ‑hɔn 'ʋ nyiblo ke', 'kɩ 'lɩ Nyɩsʋa a 'nyrɛ 'kwli, ɛ ‑hʋɛn 'ʋ꞊ʋ ke'.» ");
INSERT INTO ktj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Dɛ a 'mʋ, 'a ‑tɩ, ‑Yusu a 'nyrɛ 'ɛ 'hɛɛn bʋ, 'kɩ 'lɩ 'blʋgba a pɛpɛ a 'mʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","‑Tɛ ‑Yusu ‑hɔn 'lɩ Nyɩsʋa a 'kayu bʋ, ‑ɛ ‑bɩ 'kɩ ɛ mu 'lɩ Simɔ (Piɛlɩ) a ‑tɛ. 'Kɩ 'lɩ 'kayu a 'mʋ bʋ, 'kɩ ɛ yɛɛ 'lɩ Simɔ a 'mʋ 'a 'dɔɔ bʋ, 'a 'hʋɩ 'ɛ yɩ hren dɩakɩ. Ɛ nɔ‑ nu꞊o, nyibli a pɛpɛ ‑mʋ', ‑ʋ nɩ 'ʋ, 'ʋ nyɛɛ ‑Yusu lɛ, bʋ nu꞊o, nʋgba a 'mʋ, 'a 'hʋɩ bʋ 'kee ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ɛ nɔ‑ mɔ ‑Yusu bʋ ꞊jri꞊e 'lu bʋ, bʋ ꞊mʋma 'hʋɩ hinhren a 'mʋ 'yi lɛ, 'ɛ yɩ꞊ɩ ‑lee ‑nɩ, 'kɩ bʋ hlɔɔ nʋgba a 'mʋ ‑mɔ lɛ. Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ 'a 'hʋɩ 'kee nɩ, 'ɛ 'du ye', 'ɛ pi 'waa dididɛ. ");
INSERT INTO ktj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","‑Tɛ 'yrʋ ‑wɛ 'lɩ yakɔ 'kwli lɛ, ‑tɛ ‑wuwle‑nyrɔwɔ* ‑wɛ 'lɩ, ‑ɛ ‑bɩ nyibli a pɛpɛ ‑mʋ', ‑ʋ kɔ nyibli, 'kʋɛ a gblegble ni, ʋ nʋ‑ gba 'lɩ 'waa nyibli a 'mʋ ‑Yusu ‑mɔ, 'ɛ pʋ 'waa dodoyo dabʋɩ 'lu blɛ, 'ɛ nu꞊o, 'waa 'kʋɛ 'ɛ ‑wɛ, ");
INSERT INTO ktj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","'kuo ‑hʋɩn* 'ʋ ‑hɔn 'ʋ 'hʋɩhrennyibli ‑hʋɔhʋɩ ke' lɛ, 'ʋ 'yɛɛ 'lɩ win, 'ʋ pɩ lɛ: «‑Mɔ mɔ Nyɩsʋa a 'Yu!» Kɛɛ ‑Yusu ꞊maa ꞊nʋ 'yi, 'ɛ lee ꞊nʋ, ‑ɛ mɔ, ʋ 'nɩ 'hlaa 'lɩ ‑tɩ a 'mʋ, ‑ɛ nu꞊o, 'kuo ‑hʋɩn a 'mʋ, ʋ yi꞊e nɩ, ‑ɛ mɔ, ‑Yusu, ɛ nɔ‑ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la 'a dakɔ yɩ ya. ");
INSERT INTO ktj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","‑Tɛ ‑nyrɛ ‑nyɛ, ‑ɛ ‑bɩ ‑Yusu 'du ye', 'ɛ mu 'lɩ ‑tɩtɛ ‑mʋ', 'dʋ bii 'ʋ yɩ, nyibli a ꞊ju a gblegble 'ʋ mu꞊o 'yie lɛ ꞊mʋɔ mɔ. ‑Tɛ ʋ yɛ꞊ɛ kɩ, ‑ɛ ‑bɩ ʋ ‑hʋɛ bʋ ka꞊a yɩ, ʋ wɛn: «꞊Nɩ 'hɔɔn mɔ ‑a mʋ 'hʋɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kɛ‑ ɛ nɔ‑ ‑mɔ ‑bɩ, ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «꞊Haantitie ‑mʋ', ‑ɛ hlɛ꞊ɛ, ‑tɛ ‑mʋ', Nyɩsʋa ni nyibli a win a kɩkɔɔlɛ, 'n kɔ ꞊bʋ pʋ꞊ʋ 'dɩɩ ‑bɩ a nyibli. Ɛ nɔ‑ kɔ ‑tɩ Nyɩsʋa 'ɛ lee 'nɛ‑ 'mʋ ‑tʋtʋ kɩ,» ");
INSERT INTO ktj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","‑Yusu 'ɛ bi ‑Juukʋɛ a 'blʋgbɩ a pɛpɛ ‑mʋ' kɩ, 'ɛ nɛ Nyɩsʋa a 'kayo blɛ, 'ɛ nɛ Nyɩsʋa a ‑tɩ ‑mɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","‑Nyrɔwɔ ꞊dʋ, ‑Yusu nɩ la 'lɩ Galileblʋgba a 'yru wien, nyibli ‑hʋɔhʋɩ 'ʋ ꞊gbee la 'ʋ꞊ʋ 'hʋɩ, ‑ɛ di꞊e nu, ʋ 'mʋ Nyɩsʋa a ‑tɩ 'wɩn. ");
INSERT INTO ktj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","'Kɩ ɛ nɩ 'kɩ 'ʋ bʋ, ‑ɛ ‑bɩ ɛ 'ye 'blagbɩ nɩ 'hʋɛn, 'ʋ nɩ 'ʋ 'nie wien. 'Blagbɩ a 'mʋ 'kwli, 'kɩ 'pʋpanyibli ‑hɔn 'lɩ ‑wlu, 'ʋ yrɛ la 'waa ‑tatɩ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","'Blagbɩ a 'mʋ, nɔ‑ kɔ 'yɛɛ ‑bɩ ‑Yusu 'ya 'lɩ 'kwli, nyibli a ‑hʋhʋ‑tɩ. 'Blagbɩ a 'mʋ, Simɔ ‑kɔ꞊ɔ, ‑Yusu 'ɛ lee ꞊nɛ, 'kɩ bʋ 'yɩya 'lɩ 'nie kɩ bʋ dɛ gbe. ‑Tɛ ʋ 'yɩya 'lɩ 'nie kɩ bʋ, ‑ɛ ‑bɩ ɛ nɩ bʋ, 'ɛ ‑tʋa nyibli a 'mʋ Nyɩsʋa a ‑tɩ a tɔɔlɛ. ");
INSERT INTO ktj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","‑Tɛ ɛ ‑wɛ nyibli a tɔɔlɛ ‑mɔ, ‑ɛ ‑bɩ ɛ lee Simɔ nɩ, ɛ wɛn: «Bli, ‑ba mu 'ʋ 'wlo kɩ, ‑kɔ ‑na 'bio 'hʋɛn‑, ba pʋ 'aan ‑tatɩ, ba 'pa.» ");
INSERT INTO ktj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","‑Ɛ ‑bɩ Simɔ wɛn: «Tɔɔnyɔ o, 'tɔlʋwɔ a pɛpɛ ‑bʋ 'kwli, ‑a 'ye ꞊hɩʋɛn, ‑a 'yɩ ꞊dedede 'pa. Kɛɛ, ‑tɛ ‑pʋ 'kɩ lɛ, ꞊bʋ nu꞊o, 'n di꞊e 'nɩ nu,» ");
INSERT INTO ktj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","'ʋ pʋ 'waa ‑tatɩ, 'ʋ 'la ‑hrin. ‑Hrin a 'mʋ, ʋ 'la, 'a ‑hʋhʋʋ a ‑tɩ, 'waa ‑tatɩ ‑tʋa cɩcrɛ, ");
INSERT INTO ktj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","'ʋ pʋ dabʋɩ, 'ʋ da 'waa 'bio, ‑ʋ nɩ 'lɩ 'blagbɩ ‑bɩ ‑mʋ' 'kwli, bʋ di ꞊nʋ ‑hɛɛ ‑nɩ, 'ʋ ‑di, 'ʋ 'yii 'lɩ 'blagbɩ nɩ 'hʋɛn a 'mʋ, 'kɩ 'ʋ ‑hrin ‑mɔ. ‑Hrin a kʋanɩ‑tɩ, 'blagbɩ a 'mʋ, ʋ ‑hʋɛ bʋ ꞊mɩɛ. ");
INSERT INTO ktj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","‑Tɛ Simɔ, ʋ dɛɛ Piɛlɩ, ɛ 'ye dɛ a 'mʋ, ‑ɛ ‑bɩ ɛ 'gbla ‑Yusu kwlɩ yɩ, ɛ wɛn: «Kʋkɔnyɔ, hlɔɔ 'mʋ ‑mɔ lɛ, ‑ɛ nu꞊o, 'n mɔ dɛ'kukununyɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kɛ‑ Simɔ ‑pʋ, ‑ɛ nu꞊o, ɛ 'ta 'ʋ bʋ, ɛ kɔ 'a 'bio 'pʋpanyibli 'hʋɛn‑, 'kɩ 'ʋ ‑hrin ‑hʋɔhʋɩ, ʋ 'la a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Dɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ mu 'lu ‑mɔ, 'kɩ 'ʋ Sakɩ kɔ Saan 'hʋɛn‑ ‑mɔ, ‑ʋ mɔ Sebede a 'yonʋ, ‑ʋ kɔ Simɔ 'hʋɛn‑ ‑ni ‑kʋan. Kɛɛ, ‑Yusu lee Simɔ nɩ, ɛ wɛn: «꞊Nɩ 'pie 'lɩ hʋannʋ. Kʋɛ mɔ ti ‑bʋ 'yie bʋ, ɛ 'nɩ 'mɔɔ 'kɩ ‑hrin nɩ de, ꞊nɩ 'kukue 'lɩ꞊ɩ lɛ nɩ, kɛɛ, ‑tonyibli, ʋ nʋ‑ ‑di lɛ 'kukue ‑nɩ, ‑ɛ di꞊e nu, ʋ 'mʋ 'na ‑nagbopʋ ‑hɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","‑Tɛ ‑Yusu ‑yrɛ, ‑ɛ ‑bɩ ʋ kwlɛɛ 'waa 'blagbɩ nɩ, 'ʋ hie 'ʋ 'waa ‑tɛblɩ a pɛpɛ bʋ, 'ʋ kʋɛ ‑Yusu ꞊wien, 'kɩ 'ʋ 'a ꞊wienlɛkʋkʋɛ a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","‑Nyrɔwɔ ꞊dʋ, ‑Yusu nɩ la 'lɩ 'dɩɔ ꞊dʋ 'kwli. 'Kɩ 'lɩ 'dɩɔ a 'mʋ 'kwli, 'kɩ ꞊hrannunyɔ ꞊dʋ nɩ la 'lɩ. Nyɩbɛyu a 'mʋ, 'a 'hʋɩ a pɛpɛ mɔ la ꞊ji dadʋ. ‑Tɛ ɛ 'ye ‑Yusu, ɛ nɔ‑ mɔ bʋ bla꞊a kwlɩ yɩ, ɛ wɛn: «Kʋkɔnyɔ o, 'n nyaa ‑mʋ lɛ, nu꞊o, 'na 'kʋɛ bʋ ‑wɛ,» ");
INSERT INTO ktj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","‑Yusu 'ɛ ‑hrɛn꞊ɛ lɛ, 'tɩ‑ 'ɛ lee ꞊nɛ, ‑ɛ mɔ: «'N ‑hʋɛ꞊ɛ nɩ, ‑na 'kʋɛ bʋ ‑wɛ.» Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ 'a 'kʋɛ ‑wɛ nɩ, ");
INSERT INTO ktj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","‑Yusu 'ɛ lee ꞊nɛ, ɛ wɛn: «꞊Nɩ 'lee 'lɩ nyiblo ꞊dʋ, kɛɛ, mu ‑bʋ tɔɔ ‑dɩɔnʋ Nyɩsʋa a ‑cɔhlʋnpinyɔ* yɩ, ɛ 'mʋ꞊ʋ 'ye, ‑ɛ mɔ, ‑na 'kʋɛ ‑wɛ nɩ. 'A ‑tɩ, gba ‑tɛblɩ ‑mʋ', ʋ ni, 'ʋ yɩ ‑cɔhlʋn* pi, 'kɩ 'ʋ Nyɩsʋa ye', ꞊wɩ yɩ, ‑tɛ Nyɩsʋa a winwlɔn‑hanyɔ Moise nu la 'a hɩhla, yɩ‑hɛ‑nyrɛ a ti 'yri, ‑ɛ di꞊e nu, nyibli a pɛpɛ 'mʋ꞊ʋ 'ye, ‑ɛ mɔ, ‑na 'kʋɛ ‑wɛ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","'Ɛ mɔ ꞊han‑tɩ, ‑Yusu 'ɛ nu win a pʋpʋʋ lɛ, kɛɛ, 'a 'nyrɛ a bʋ'hɛɛnlɛ bii kɩ, 'kɩ 'lɩ 'blʋgba a 'mʋ 'kwli. Dɛ nɩ ‑do a 'mʋ a ‑tɩ, ‑tonyibli 'ʋ ‑hʋɛn ‑tɛblɩ 'nyɩ lɛ, 'ʋ mi 'ʋ꞊ʋ 'hʋɩ, ‑ɛ di꞊e nu, ʋ 'mʋ 'a win 'wɩn, ɛ kɔ, ‑Yusu 'mʋ꞊ʋ nu, 'waa 'kʋɛ 'mʋ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kɛɛ, ‑ɛ ‑bɩ ‑Yusu ‑hɔn ‑ta', 'ɛ mu 'lɩ ‑tɩtɛ ‑mʋ', nyibli 'yɩ 'lɩ 'ti, ‑ɛ di꞊e nu, ɛ 'mʋ Nyɩsʋa da. ");
INSERT INTO ktj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","‑Nyrɔwɔ ꞊dʋ 'kwli, 'kɩ ‑Yusu nɩ la 'lɩ 'kayu ꞊dʋ bʋ, 'ɛ tʋɛ la nyibli Nyɩsʋa a ‑tɩ. 'Kɩ Falisi꞊tumu* kɔ Nyɩsʋa a tetetɔɔnyʋ 'hʋɛn‑, ʋ nɩ la 'lɩ ꞊nʋ 'nyɩ. 'Kɩ ʋ ‑hɔn 'lɩ Galileblʋgba kɔ Sudeblʋgba a 'dɩɩ klɛ, ɛ kɔ, 'kɩ Jrusrɛdɩɔ 'kwli, 'ʋ ‑di. Kʋkɔnyɔ Nyɩsʋa yɩ ‑nyi ‑Yusu 'klɩ, 'kɩ bʋ nu꞊o, nyibli a 'kʋɛ bʋ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","'Kɩ ʋ nɩ 'ʋ bʋ, ‑ɛ ‑bɩ nyibli ꞊dʋ nyre 'ʋ nɩ, 'ʋ 'ble ‑hanmakɩ. 'Kɩ 'lɩ ‑hanmakɩ a 'mʋ 'kwli, 'kɩ ʋ pɩa 'lɩ lɛ‑yɩyrɛnyɔ bʋ. Ʋ ‑hʋɛ꞊ɛ nɩ, bʋ paa 'lɩ꞊ɩ 'kayu bʋ, ‑ɛ di꞊e nu, ʋ 'mʋ 'ʋ꞊ʋ ‑Yusu yɩ bʋ ꞊tu. ");
INSERT INTO ktj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","‑Tɛ ʋ nyre 'lɩ 'kayu a 'mʋ 'hʋɩ, ‑ɛ ‑bɩ ʋ yɛɛ 'ʋ nyibli ‑hʋɔhʋɩ bʋ. 'A ‑tɩ, ʋ 'yɩ 'hru 'ye, 'kɩ bʋ paa lɛ‑yɩyrɛnyɔ a 'mʋ 'kayu bʋ. Bʋ 'yɛ nɩ 'ye 'kɩ 'hru, ɛ nɔ‑ mɔ bʋ 'ya 'lɩ 'kayu a 'mʋ kɩ, bʋ ‑ha 'hʋɔ. 'Kɩ ʋ naa 'ʋ lɛ‑yɩyrɛnyɔ ‑mʋ', ‑ɛ nɩ wɛn 'lɩ ‑hanmakɩ 'kwli, 'ʋ ꞊tɩɔ 'ʋ꞊ʋ ‑Yusu ye', 'kɩ 'lɩ ‑tonyibli 'nyɩ, ‑ɛ di꞊e nu, ‑Yusu 'mʋ꞊ʋ nu, 'a 'kʋɛ 'mʋ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","‑Tɛ ‑Yusu 'ye꞊e, ‑ɛ mɔ, nyibli a 'mʋ, ʋ kuo ꞊nɛ ꞊wlʋ yɩ, ‑ɛ mɔ, ɛ ‑wɛ 'lɩ bʋ nu꞊o nɩ, lɛ‑yɩyrɛnyɔ a 'mʋ, 'a 'kʋɛ bʋ ‑wɛ nɩ, ‑ɛ ‑bɩ ɛ lee ꞊nɛ nɩ, ‑ɛ mɔ: «Nyɩbɛyu o, ‑tɛblɩ nɩ ‑tie ‑mʋ', ‑nu, ‑ɛ nyre yɩ, 'kɩ 'ʋ Nyɩsʋa ye', ɛ 'wʋwlɛ kɛ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ tetetɔɔnyʋ, ‑ʋ nɩ 'ʋ, ʋ ‑tʋa wlɔnlɛ'pʋplɛ lɛ, ʋ wɛn: «‑Tɩ ‑bʋ, ‑Yusu ‑bʋ, ɛ hlɛ, ɛ yɩ ‑hɛɛ Nyɩsʋa a ‑tɩ lɛ. Nyiblo a 'dɩ ‑bɩ ɛ pa 'mʋ 'lɩ? 'Tɩ‑ 'ɛ pɩ lɛ, ‑ɛ mɔ, ɛ mɔ Nyɩsʋa ꞊nɩɔ. Nyɩsʋa nɩ ‑do, ɛ nɔ‑ wɛ 'lɩ bʋ 'wʋwla nyiblo a dɛ 'kuku.» ");
INSERT INTO ktj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Dɛ a 'mʋ, ʋ nɛɛ ꞊wlɩ klɛ, ‑Yusu yru꞊o nɩ, ‑ɛ ‑bɩ ɛ wɛn: «Dɛ‑ kɔ ꞊wlɩdʋ ‑bʋ a nɛɛ 'kɩ lɛ 'lɩ? A 'yɩ wɛn yɩ ‑blɛɛ ‑nɩ, ba naa wɛn ꞊wlɩdʋ a 'mʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","'Aan ꞊wlɩ wɛn 'nɩ, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ lee nyiblo ‑bʋ, ‑ɛ mɔ, 'a dɛ 'kuku 'wʋwlɛ nɩ, ɛ kɔ, 'aan ꞊wlɩ wɛn 'nɩ, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ lee ꞊nɛ, ‑ɛ mɔ, bʋ 'du ye', bʋ na. ");
INSERT INTO ktj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kɛɛ, ba yi꞊e, ‑ɛ mɔ, 'mɔ ‑mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'tɩ‑, 'mɔ ‑mɔ Nyɩsʋa a 'Yu, ɛ lee 'nɛ‑ ‑tʋtʋ kɩ. Nyɩsʋa a ꞊gbɛtʋ, ɛ nɔ‑ ‑nyi 'mʋ 'klɩ, 'kɩ ꞊bʋ 'wʋwla ‑tonyibli a dɛ 'kuku, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, 'ɛ ‑nyi 'mʋ 'klɩ ‑wɛ, 'kɩ ꞊bʋ nu꞊o, ‑tonyibli a 'kʋɛ 'mʋ ‑wɛ. 'A ‑tɩ, nyiblo ‑bʋ, ʋ ‑ya, 'n kɔ ꞊bʋ nu꞊o, 'a 'kʋɛ 'mʋ ‑wɛ, ‑ɛ di꞊e nu, a 'mʋ꞊ʋ lɛ yru, ‑ɛ mɔ, ‑tɩ ‑bʋ, 'n lee wɛn 'a mʋ, ɛ mɔ ꞊han‑tɩ ꞊nɩɔ.» ‑Ɛ ‑bɩ ɛ ꞊hɩan ‑mɔ de, 'ɛ ‑tʋa 'lɩ lɛ‑yɩyrɛnyɔ a 'mʋ, 'a ‑mɔhleelɛ, ɛ wɛn: «'N yɩ ‑mʋ 'nɩ ‑lee ‑nɩ, 'du ye', 'du ‑na ‑hanmakɩ ye', ‑bʋ mu 'lɩ ‑na 'kayu bʋ, ‑na 'kʋɛ ‑wɛ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ti nɩ ‑do a ti 'yri, nyibli yɩ wɛn 'ʋ꞊ʋ ‑mɔ lɛ nɩ tɛ, 'ɛ 'du ye', 'ɛ 'du 'a ‑hanmakɩ ye', 'ɛ 'hrɩ, 'ɛ ‑tʋa 'lɩ 'a 'kayu a bʋmumuo, 'kɩ 'lɩ Nyɩsʋa a 'nyrɛ a lɛpʋpʋʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, ‑ɛ ‑bɩ ɛ kɛɛ 'waa ꞊wlɩ lɛ, 'ʋ 'ta 'ʋ blɛ, 'ʋ pɩ Nyɩsʋa 'nyrɛ lɛ, ʋ wɛn: «‑A 'ye kɛ wlɔnlɛmaa‑tɛblɩ gbagbɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu yɩ ꞊tɩ 'dɩɔ. Bʋ yɩ 'kɩ nɩ mi, 'kɩ 'ʋ 'hru wlɔn, 'kɩ ɛ yɛɛ 'ʋ 'blʋwli'tɩnyɔ ꞊dʋ bʋ. 'A 'nyrɛ mɔ Lefi, 'ɛ nɩ 'lɩ 'blʋwli'tɩɩlɛ' bʋ. (‑Tonyibli a pɛpɛ yraa 'blʋwli'tɩnyʋ nɩ, ‑ɛ nu꞊o, ʋ yɩ di 'wli dɩakɩ.) ‑Tɛ ‑Yusu nyre 'ʋ꞊ʋ 'hʋɩ, kɛ‑ ɛ pʋ꞊ʋ yɩ: «Kʋɛ 'mʋ ꞊wien lɛ, ꞊mʋ 'na ‑nagbopi ‑hɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","‑Ɛ ‑bɩ Lefi 'du ye', 'ɛ hie 'ʋ 'a ‑kʋan a pɛpɛ bʋ, 'ɛ kʋɛ ‑Yusu ꞊wien. ");
INSERT INTO ktj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lefi a 'mʋ, ɛ nɔ‑ da ‑Yusu kɔ 'a ‑nagbopʋ 'hʋɛn‑ diidɛ ‑mɔ, 'ɛ da 'a 'bio 'blʋwli'tɩnyʋ ‑hʋɔhʋɩ, kɔ hɩapʋnyibli ‑bɩ 'hʋɛn‑, ‑ʋ kɔ 'klɔ, ‑ɛ 'yɩ 'ʋ yɩ 'sii ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Falisi꞊tumu* a nyibli, ʋ kɔ Nyɩsʋa a tetetɔɔnyʋ 'hʋɛn‑, ‑ʋ mɔ Falisi꞊tumu a nyibli ‑wɛ, ‑tɛ ʋ 'ye dɛ a 'mʋ, ‑ɛ ‑bɩ ʋ ‑tʋa wlɔnlɛ'pʋplɛlɛ, 'ʋ lee ‑Yusu a ‑nagbopʋ, ʋ wɛn: «Dɛ‑ nu 'kɩ꞊ɩ, a kɔ 'blʋwli'tɩnyʋ kɔ nyiblidʋ ‑bʋ, ‑ʋ kɔ 'klɔ ꞊yɩ 'ʋ yɩ 'sii ‑nɩ 'hʋɛn‑, 'a nɩ 'ʋ dɛdihu nɩ ‑do kɩ 'lɩ? A 'yɩ wɛn yɩ ‑blɛɛ ‑nɩ, ba nu dɛ a 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","‑Yusu bʋ 'wɩn ‑tɩ a 'mʋ, ɛ nɔ‑ mɔ bʋ pʋ lɛ: «Nyiblo ‑bʋ, ‑ɛ kɔ 'hʋɩ ‑nu ‑tɛɛ, ɛ 'nɩ ‑hʋa꞊a lɩ ‑dɔtɔ a 'yiye, kɛɛ, nyiblo ‑bʋ, ‑ɛ kɔ 'hʋɩ ‑hren, ɛ nɔ‑ ꞊mʋɛ ‑dɔtɔ a 'yiye lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","'N 'yɩ ‑di, 'kɩ 'ʋ nyibli ‑bʋ, ‑ʋ pɩ lɛ, ‑ɛ mɔ, 'waa 'klɔ 'sii 'ʋ yɩ a ‑ta', kɛɛ, nyibli ‑bʋ, ‑ʋ yi꞊e, ‑ɛ mɔ, 'waa 'klɔ 'yɩ 'ʋ yɩ 'sii ‑nɩ, ʋ nʋ‑ kɔ ‑tɩ 'nɩ ‑di, 'mʋ ꞊nʋ ‑lee ‑nɩ, ‑ɛ mɔ, 'waa dɛ 'kuku ‑bʋ, ʋ ni, bʋ hie 'ʋ꞊ʋ bʋ, bʋ ‑nyi 'waa 'klɔ a pɛpɛ Nyɩsʋa.» ");
INSERT INTO ktj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kɛ‑ nyibli ‑bɩ pɩ ‑Yusu yɩ, ʋ wɛn: «Saan* Batisɩ, ‑ɛ pɩ nyibli 'nie 'lu lɛ, 'a ‑nagbopʋ* yɩ 'nɩ ꞊ci* 'a ‑nɛ ti, 'ʋ dɛ Nyɩsʋa. Dɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ Falisi꞊tumu* a nyibli ni ‑wɛ, ꞊wɩ yɩ, ‑tɛ 'waa tete ni ꞊nʋ 'a tɔɔlɛ. Kɛɛ, ‑mɔ ‑bɩ, ‑na ‑nagbopʋ 'nɩ ꞊ci꞊e lɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ, ɛ wɛn: «Nyɩbɛyu ‑bʋ, ‑ɛ pʋɛ 'blɩ, 'a 'bio ‑mʋ', ɛ dɛ 'blɩpadiidɛ kɩ, 'bʋ mu 'blɩpadiidɛ a 'mʋ, 'a ‑tuo kɩ, nyiblo ꞊dʋ 'nɩ ‑lee꞊e lɩ ꞊nʋ bʋ ꞊ci. Ɛ 'wɩ yɩ, 'blɩ a pʋpa, ɛ mɔ dɔdʋdɛ ꞊nɩɔ. 'A ‑tɩ, ʋ 'yɩ ꞊cicie ‑kɔ. Dɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ ꞊nɩɔ. Dɔdʋ a ‑tɩ, ti nɩ ‑tie ‑bʋ, 'n di 'nɛ‑ ꞊nʋ 'nyɩ ‑hii ‑nɩ, 'na ‑nagbopʋ 'nɩ ꞊ci꞊e nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kɛɛ, ɛ di kɔ ti, ‑ɛ di 'ʋ nyre, ʋ 'mʋ 'lɩ 'mʋ 'na ‑nagbopʋ 'nyɩ ‑ha. Ti a 'mʋ 'yri, 'kɩ ʋ di 'ʋ ꞊cii ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","‑Ɛ ‑bɩ ɛ pɩ ꞊nʋ 'ledʋ yɩ, ɛ wɛn: «Nyiblo 'nɩ ‑cra꞊a lɩ wlawlʋ yrayrʋ, ɛ 'nɩ ‑ha꞊a 'ʋ 'a 'kɩbɩa, ɛ 'nɩ ‑ma꞊a lɩ danʋ 'ka a 'hʋɔ. 'Bʋ mɔ, 'bʋ nu꞊o, ɛ di nyre wlawlʋ yrayrʋ a 'mʋ yɩ, ɛ kɔ, 'a 'kɩbɩa ‑mʋ', ɛ ‑nu, 'ɛ ‑ma danʋ 'ka a 'mʋ, ɛ kɔ꞊ɔ 'hʋɛn‑, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ ‑mʋɛ. ");
INSERT INTO ktj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mɔ, yonɔ yrayrɩ ‑bʋ, ‑ɛ 'plui, nyiblo 'nɩ 'du꞊o lɩ꞊ɩ ye', ɛ 'nɩ ‑pʋ꞊ʋ 'lɩ꞊ɩ mʋmakɔ a buo 'ka 'kwli. 'Bʋ pʋ 'lɩ꞊ɩ buo 'ka 'kwli, 'bʋ ka꞊a yɩ, ti ‑kɔ 'yri ɛ di 'plu, 'bʋ yɩ nɩ 'yɛ, ɛ kɔ bʋ wa mʋmakɔ a buo a 'mʋ, nɔ 'mʋ bʋ 'wlɛ. ");
INSERT INTO ktj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ɛ nɔ‑ nu꞊o, 'kɩ 'lɩ buo yrayrʋ 'kwli, 'ʋ pɩ 'lɩ nɔ yrayrɩ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nyiblo 'bʋ nɩ 'ʋ, 'bʋ nʋɛ nɔ 'kɩ a 'nɩna, ɛ 'nɩ ‑hʋa꞊a lɩ nɔ yrayrɩ a 'nɩna. Kɛ‑ ɛ di pʋ: Nɔ 'kɩ ‑mʋ', ɛ nɔ‑ nɔ wlɔn, 'ɛ ‑hi 'ʋ nɔ yrayrɩ 'ʋ. (Ɛ nɔ‑ nu꞊o, nyiblo ꞊dʋ 'nɩ 'du꞊o lɩ ‑tɛblɩ 'kɩ ye', ɛ 'nɩ ‑pʋ꞊ʋ lɩ꞊ɩ ‑tɛblɩ yrayrɩ kɩ. Ʋ 'nɩ ‑bibi꞊e lɩ 'yi lɛ.)» ");
INSERT INTO ktj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","‑Wuwle‑nyrɔwɔ ꞊dʋ, ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ mu lɛ na mɔ. ‑Tɛ ʋ yɩ nɩ mi, 'dʋdɔ‑tɛblɩ ꞊dʋ, ‑ɛ 'wɩ ‑kʋbʋ yɩ, ɛ nɔ‑ kɔ ‑ci ʋ yɩ 'lɩ 'kwli ꞊tɩɔ 'bɛɛ ‑nɩ. 'Dʋdɔ‑tɛblɩ a 'mʋ, ɛ nɔ‑ kɔ blɩ gbi 'a ‑nagbopʋ 'cɛ, 'ʋ hihiue 'lɩ꞊ɩ ꞊jrɛ, 'ʋ yɩ꞊ɩ di. ");
INSERT INTO ktj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","'Kɩ 'lɩ ‑ci nɩ ‑do a 'mʋ 'kwli, 'kɩ Falisi꞊tumu* a nyibli ‑bɩ nɩ 'lɩ. ‑Tɛ ‑Yusu a ‑nagbopʋ, ʋ yɩ 'dʋdɔ‑tɛblɩ a 'mʋ, 'a blɩ gbi nɩ 'cɛ, ‑ɛ ‑bɩ kɛ‑ ʋ pɩ ꞊nʋ yɩ, ʋ wɛn: «Dɛ ‑bʋ, a ni, ɛ ꞊ŋa nɩ. Nyɩsʋa a tete wɛn 'nɩ, nyiblo ꞊dʋ 'nɩ 'nuo 'lɩ ‑kʋan, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «‑Tɩ ‑mʋ', ʋ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, 'kɩ 'ʋ ‑aan 'baɩ gbagbʋ, ‑ɛ mɔ bodɩɔ Dafidɩ a ‑ta', 'n pʋ꞊ʋ ꞊haan‑tɩ, ‑ɛ mɔ, a ‑hre꞊e nɩ. ‑Tɩ a 'mʋ, ʋ 'crɩ la, ɛ nɔ‑ ‑bʋ: ‑Nyrɔwɔ ꞊dʋ, ‑tɛ 'kanʋ ni la bodɩɔ Dafidɩ, ɛ kɔ 'a nyibli 'hʋɛn‑, ");
INSERT INTO ktj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","'kɩ 'lɩ Nyɩsʋa a 'kayu bʋ, 'kɩ ɛ pa la 'lɩ, 'ɛ ‑ha la 'ʋ 'flɔɔ, ‑ɛ pɛ la 'ʋ 'teble kɩ bʋ, 'ɛ di꞊e, 'ɛ ‑nyi la 'a dɛ gbe 'a nyibli, 'ʋ di la꞊a ‑wɛ. Kɛɛ, Nyɩsʋa a tete wɛn 'nɩ, Nyɩsʋa a ‑cɔhlʋnpinyʋ* nɩ ‑do, ʋ nʋ‑ blɛɛ yɩ, ‑bʋ di 'flɔɔdʋ a 'mʋ. 'Bɩ 'flɔɔdʋ a 'mʋ, ‑ɛ nɩ 'lɩ Nyɩsʋa a 'kayu bʋ, ʋ ‑ha la꞊a nɩ, 'kɩ 'ʋ Nyɩsʋa a ‑ta'.» ");
INSERT INTO ktj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ de: «'Mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, Nyɩsʋa lee 'nɛ‑ 'mʋ nɩ, 'ɛ ‑nyi 'mʋ 'klɩ, 'kɩ ꞊bʋ lee nɛ 'a ‑nɛ nyiblo ꞊dʋ dɛ, ɛ ‑wɛ 'lɩ bʋ nu, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","‑Wuwle‑nyrɔwɔ ‑bɩ 'kwli, ‑ɛ ‑bɩ ‑Yusu mu 'lɩ Nyɩsʋa a 'kayu bʋ de, 'ɛ tʋɛ nyibli Nyɩsʋa a ‑tɩ. 'Kɩ 'lɩ 'kayu a 'mʋ bʋ, 'kɩ ɛ yɛɛ 'lɩ nyɩbɛyu ꞊dʋ bʋ. Nyɩbɛyu a 'mʋ, 'a diidɛdabʋ 'kʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Bʋ nɩ 'kɩ 'ʋ bʋ, ‑ɛ ‑bɩ Nyɩsʋa a tetetɔɔnyʋ kɔ Falisi꞊tumu* a nyibli, ‑ʋ nɩ 'ʋ 'hʋɛn‑, ʋ ‑tʋa 'yie a ke'gbaalɛ, ʋ 'mʋ ‑Yusu 'ye, 'bʋ mɔ, 'bʋ kɔ bʋ nu꞊o, nyɩbɛyu a 'mʋ a 'kʋɛ 'mʋ ‑wɛ, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ ‑mʋ' 'kwli, ‑ɛ di꞊e nu, ‑Yusu 'bʋ nu꞊o, ʋ 'mʋ꞊ʋ ‑tɩ ‑yɛɛ ‑nɩ. (Falisi꞊tumu a nyibli wɛn 'nɩ, bʋ nu꞊o, nyiblo a 'kʋɛ bʋ ‑wɛ, ɛ mɔ ‑kʋandɛ ꞊nɩɔ. 'Tɩ‑ Nyɩsʋa a tete wɛn 'nɩ, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli, nyiblo 'yɩ yɩ ‑blɛɛ ‑nɩ, bʋ nu ‑kʋan.) ");
INSERT INTO ktj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kɛɛ ‑ɛ ‑bɩ ‑Yusu yru 'waa 'lulɛ‑hihie lɛ. Ɛ nɔ‑ nu꞊o, 'ɛ lee nyɩbɛyu a 'mʋ, ɛ wɛn: «'Du ye', ‑bʋ nyra 'lɩ nyibli 'nyɩ bʋ,» nyɩbɛyu a 'mʋ 'ɛ 'du ye', 'ɛ nyra 'lɩ ꞊nʋ 'nyɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","‑Ɛ ‑bɩ ‑Yusu 'bɛti tetetɔɔnyʋ kɔ Falisi꞊tumu a nyibli 'hʋɛn‑ nɩ, ɛ wɛn: «‑Bɩ' Nyɩsʋa a tete pɩ 'lɩ? 'Kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli, nyiblo bʋ nu ꞊haandɛ, kɔ, bʋ nu dɛ ‑hʋan, dɛ a 'dɩ ‑bɩ ‑nu ‑tɛɛ 'lɩ? Nyiblo bʋ wa 'a 'bɩhɩan, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli, ‑ɛ di꞊e nu, ɛ 'nɩ ꞊ha 'kʋ, kɔ, nyiblo bʋ ‑ha 'a 'bɩhɩan a ‑hʋnhlʋn mɛ lɛ bʋ 'wan, dɛ a 'dɩ ‑bɩ ‑nu ‑tɛɛ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Bʋ yɩ 'lɩ ꞊nʋ 'yi lɛ nɩ tɛ, ‑ɛ ‑bɩ kɛ‑ ɛ pɩ nyɩbɛyu a 'mʋ yɩ, ɛ wɛn: «Hrʋ ‑na dabʋ ‑mʋ', ‑ɛ 'kʋ,» ‑ɛ ‑bɩ ɛ hrʋ 'a dabʋ nɩ. Bʋ hrʋ 'kɩ dabʋ a 'mʋ, ‑ɛ ‑bɩ ɛ 'hrɩ 'klɔ, 'ɛ bi 'ʋ 'a dɩɔnʋ a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","‑Tɛ ‑Yusu nu 'kɩ꞊ɩ, nyiblo a 'mʋ a 'kʋɛ, ɛ ‑wɛ, ‑ɛ ‑bɩ Nyɩsʋa a tetetɔɔnyʋ kɔ Falisi꞊tumu a nyibli 'hʋɛn‑, ʋ bi yrʋ' lɛ dɩakɩ, 'ʋ ‑tʋa ꞊tɔ a lɛ꞊mʋmʋɔ, ‑tɛ ʋ di nu, ʋ 'mʋ ‑Yusu ‑balʋ' nu. ");
INSERT INTO ktj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ti a 'mʋ 'yri, dʋgba ꞊dʋ nɩ 'ʋ. Ɛ nɔ‑ kɔ 'lu ɛ 'ya 'lɩ, ‑ɛ di꞊e nu, ɛ 'mʋ Nyɩsʋa da. 'Kɩ ɛ ‑hi 'lɩ 'tɔlʋwɔ a 'mʋ 'lɩ, 'kɩ 'ʋ Nyɩsʋa a dɩda a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","‑Tɛ ‑nyrɛ ‑nyɛ, ‑ɛ ‑bɩ ɛ da 'a ‑nagbopʋ* nɩ, 'kɩ 'lɩ ꞊nʋ 'nyɩ, 'ɛ ‑ha 'lɩ nyibli nɩ ‑pu ꞊tu 'ʋ 'hʋɛn, 'ɛ dɛɛ ꞊nʋ 'a ‑mɔnanyʋ. ");
INSERT INTO ktj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nyibli a 'mʋ, ʋ nʋ‑ mɔ: Simɔ, ɛ ‑nyi Piɛlɩnyrɛ, ɛ kɔ Simɔ a 'mʋ, 'a 'dɩayɩ Adre 'hʋɛn‑, kɔ Sakɩ, kɔ Saan, kɔ Filipʋ, kɔ Batelemi, ");
INSERT INTO ktj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","kɔ Matie, kɔ Toma, kɔ Alʋfe a 'yu Sakɩ, kɔ Simɔ. Simɔ a 'mʋ, 'kɩ ɛ nɩ la 'lɩ nyibli ‑mʋ' 'nyɩ, ‑ʋ 'yɛ nɩ ‑hʋa Romakʋɛ; ");
INSERT INTO ktj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","kɔ Sakɩ a 'yu Judɩ, kɔ Judɩa Yisikalio. Ɛ mɔ nyiblo ‑mʋ', ‑ɛ di ‑Yusu 'a yraanyibli ‑jɩ' pʋ. ");
INSERT INTO ktj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ ꞊tɩ 'lɩ dʋgba a 'mʋ 'lu nɩ, 'ʋ nyra 'ʋ ‑tɩtɛ ‑mʋ', 'dʋ 'wlɛɛ 'ʋ bʋ. 'Kɩ 'ʋ ‑tɛ a 'mʋ, ‑Yusu a ‑nagbopʋ ‑hʋɔhʋɩ ‑bɩ 'kukue wɛn 'ʋ lɛ, ʋ kɔ nyibli ‑hʋɔhʋɩ ‑bɩ 'hʋɛn‑. 'Kɩ ‑ʋ ‑bɩ ‑hɔn 'lɩ Jrusrɛdɩɔ 'kwli, ɛ kɔ 'kɩ 'lɩ ‑Juukʋɛ a 'blʋgbɩ a pɛpɛ kɩ, kɔ 'dɩɩ ‑bɩ ‑mʋ', ‑ʋ nɩ 'lɩ 'yru wien, ‑ʋ mɔ Tilɩdɩɔ kɔ Sidɔdɩɔ 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ʋ di nɩ, ‑ɛ di꞊e nu, ʋ 'mʋ 'a win 'wɩn, kɔ, ɛ 'mʋ꞊ʋ nu, 'waa 'kʋɛ 'mʋ ‑wɛ, ɛ kɔ, ɛ 'mʋ nyibli a 'kuo ‑hʋɩn* lɛ bla. ");
INSERT INTO ktj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nyibli a pɛpɛ ꞊mʋɛ꞊ɛ lɛ, 'kɩ bʋ ‑hrɛn꞊ɛ lɛ, ‑ɛ nu꞊o, 'klɩ ‑hʋɛn 'lɩ꞊ɩ 'hʋɩ, ɛ ni꞊e nɩ, 'waa 'kʋɛ 'ɛ yɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu 'du 'lu ye', 'ɛ ta 'lɩ 'a ‑nagbopʋ* ‑mɔ lɛ, ɛ wɛn: «'A mʋ ‑bʋ, ‑ʋ mɔ 'na ‑nagbopʋ, ꞊hɩʋɛn ni, ba kɔ plɔ a bleelɛ, ‑ɛ nu꞊o, ti ‑kɔ 'yri Nyɩsʋa di 'ʋ 'klɔ yrayrʋ ‑nuu ‑nɩ, a kɔ 'mʋ 'hʋɛn‑, ‑a di 'lɩ 'klɔ yrayrʋ a 'mʋ 'kwli nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","'A mʋ ‑bʋ, 'kanʋ ni, 'kɩ 'nɛ‑ 'klɔ kɩ, ba kɔ plɔ a bleelɛ, ‑ɛ nu꞊o, 'kanʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nu 'a mʋ de. 'A mʋ ‑bʋ, ‑ʋ yɩ we, 'kɩ 'nɛ‑ 'klɔ kɩ, ba kɔ plɔ a bleelɛ, ‑ɛ nu꞊o, a di 'nɩ 'ca. ");
INSERT INTO ktj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","'Bʋ mɔ, nyibli 'bʋ yraa nɛ 'a mʋ, 'bʋ pʋ 'lɩ 'a mʋ ‑patʋ', kɔ, 'bʋ yɩ 'a mʋ 'yri lɛ nɩ ‑hɛ, ɛ kɔ, 'bʋ yɩ 'aan 'nyrɛ yɩ nɩ nyre, ‑tɛ a paa 'ʋ, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'a ‑hɛ 'na ‑nagbopʋ, 'bʋ mɔ, 'ba yɩ ꞊hɩʋɛndʋ a 'mʋ nɩ 'ye, ‑ɛ ‑bɩ ‑ba kɔ plɔ a bleelɛ. ");
INSERT INTO ktj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ti ‑mʋ' ‑kɔ 'yri 'kla‑wliye'yɩya a 'mʋ, ɛ di 'ʋ nyre, 'kɩ 'ʋ 'a mʋ ‑mɔ, ba nu dɔdʋ, kɔ, ba yi ‑wla, ‑ɛ nu꞊o, 'kɩ 'lɩ yakɔ 'kwli, Nyɩsʋa di ‑nyi 'a mʋ 'wio gbagbʋ. Kɛ‑ nɩ ‑do ɛ ꞊ti la 'mʋ: ‑tɛ nyibli ‑bʋ, ʋ yraa nɛ 'a mʋ, ʋ ni, kɛ‑ 'waa 'baɩnʋ ni la, 'ʋ ꞊tui la Nyɩsʋa a winwlɔn‑hanyʋ* ꞊hɩʋɛn.» ");
INSERT INTO ktj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nyibli ‑bʋ, ‑ʋ 'yɛ nɩ ꞊tuu 'ʋ Nyɩsʋa, kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ, ‑ɛ mɔ: «'A mʋ ‑bʋ, ‑ʋ mɔ dɛkɔnyibli, 'jrɔ 'kɩ 'ʋ 'a mʋ ‑mɔ, ‑ɛ nu꞊o, a 'ye 'aan ‑nɛ plɔ a bleelɛ nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","'A mʋ ‑bʋ, ‑ʋ kɔ didi‑tɛblɩ a pɛpɛ, a ‑hʋɛ, 'kɩ 'nɛ‑ 'klɔ kɩ, 'jrɔ 'kɩ 'ʋ 'a mʋ ‑mɔ, ‑ɛ nu꞊o, 'kanʋ di 'a mʋ 'nɩ nu. 'Jrɔ 'kɩ 'ʋ 'a mʋ ‑bʋ, ‑ʋ 'cɛ kɛ ‑mɔ, 'kɩ 'nɛ‑ 'klɔ ‑bʋ 'kwli, ‑ɛ nu꞊o, a di nu nyaɩ lɛ, a 'mʋ we. ");
INSERT INTO ktj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","'Jrɔ 'kɩ 'ʋ 'a mʋ ‑mɔ, 'bʋ mɔ, nyibli a pɛpɛ 'bʋ yɩ 'aan ꞊haan‑tɩ nɩ hlɛ, ‑ɛ nu꞊o, nyibli ‑mʋ', ‑ʋ yraa 'na ‑nagbopʋ, dɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ 'waa 'baɩnʋ ni la 'waa hɩwinwlɔn‑hanyʋ ‑mɔ ‑wɛ, 'ʋ hlɛ la 'waa ꞊haan‑tɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ de: «'Aan pɛpɛ, ba pʋ 'mʋ nʋa yɩ bʋ. 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ: Ba nʋɛ nɛ 'aan yraanyibli. Nyibli 'bʋ yraa nɛ 'a mʋ, ba nu ꞊nʋ ꞊haandɛ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nyibli 'bʋ pʋ 'a mʋ 'jrɔ yɩ, nyibli 'bʋ yɩ 'a mʋ ꞊hɩʋɛn nɩ ꞊tui, ba da Nyɩsʋa, 'kɩ bʋ nu ꞊nʋ ꞊haandɛ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nyiblo 'bʋ pʋʋ 'lɩ ‑mʋ 'ŋma nʋa', tɔɔ 'ʋ nʋa ‑bɩ 'ʋ, ɛ 'mʋ 'a 'yɛ ‑bɩ pʋ. Nyiblo 'bʋ ‑ha 'ʋ ‑na kʋɛtɩ, ‑ha꞊a mɛ lɛ, bʋ gba ‑na wlawlʋ ‑bɩ. ");
INSERT INTO ktj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nyiblo 'bʋ yɩ ‑mʋ dɛ nɩ ‑hʋɛ, ‑ha 'lɩ꞊ɩ 'lɩ, ‑bʋ ‑nyi ꞊nɛ꞊ɛ. Nyiblo 'bʋ ‑ha ‑mʋ ‑na dɛ ‑jɩ', ꞊nɩ 'bɛtie 'lɩ 'a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","꞊Haandɛ ‑bʋ, a ‑hʋɛ ‑tonyibli bʋ nu 'a mʋ ‑mɔ, 'aan 'mumu, ba nu ꞊nʋ꞊ʋ ‑mɔ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","'Bʋ mɔ, 'ba nʋɛ nyibli nɩ ‑do ‑bʋ, ‑ʋ nʋɛ nɛ 'a mʋ, 'aan ꞊wlɩ 'nɩ 'yee 'lɩ꞊ɩ, ‑ɛ mɔ, Nyɩsʋa di pʋ 'a mʋ 'nyrɛ lɛ. Mɔ, nyibli ‑mʋ', ‑ʋ 'yɩ Nyɩsʋa ‑yi, ʋ nʋɛ nyibli ‑mʋ' nɩ ‑wɛ, ‑ʋ nʋɛ ꞊nʋ. ");
INSERT INTO ktj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nyibli nɩ ‑do ‑mʋ', ‑ʋ ni 'a mʋ ꞊haandɛ ‑mɔ, 'bʋ mɔ, ʋ nɩ ‑do a 'mʋ, 'ba yɩ ꞊nʋ ꞊haandɛ ‑mɔ nɩ ni, 'aan ꞊wlɩ 'nɩ 'yee 'lɩ꞊ɩ, ‑ɛ mɔ, Nyɩsʋa di pʋ 'a mʋ 'nyrɛ lɛ. Dɛ nɩ ‑do a 'mʋ, nyibli ‑bʋ, ‑ʋ 'yɩ Nyɩsʋa ‑yi, ɛ nɔ‑ ʋ ni ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","'Bʋ mɔ, 'ba pʋ lɛ, ba ‑nyi 'aan 'wliyɛ nyibli nɩ ‑do ‑mʋ', ‑ʋ di꞊e kle ‑mɩa ‑nɩ, ‑ʋ di 'a mɔ꞊ɔ ‑nyi, 'aan ꞊wlɩ 'nɩ 'yee 'lɩ꞊ɩ, ‑ɛ mɔ, Nyɩsʋa di pʋ 'a mʋ 'nyrɛ lɛ. Nyibli ‑mʋ', ‑ʋ 'yɩ Nyɩsʋa ‑yi, ʋ ni꞊e nɩ ‑wɛ, 'kɩ 'lɩ 'waa dɩɔnʋ 'nyɩ, ‑tɛ ʋ yi꞊e, ‑ɛ mɔ, 'waa 'bio di 'wliyɛ a 'mʋ kle 'nɩ ‑mɩa ‑nɩ a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Dɛ ba nu, ɛ nɔ‑ mɔ, ba nʋɛ nɛ 'aan yraanyibli, ba nu ꞊nʋ ꞊haandɛ mɔ. 'Bʋ mɔ, 'ba ‑nyi nyiblo dɛ, a 'nɩ 'mʋɔ 'lɩ꞊ɩ lɛ, 'kɩ bʋ ‑mɩa ꞊nɛ kle. 'Bʋ mɔ, 'ba yɩ꞊ɩ lɛ nɩ ni, Nyɩsʋa di nu 'a mʋ ꞊haandɛ gbagbʋ ‑mɔ, ɛ kɔ, a di ‑hɛ Nyɩsʋa a 'yonʋ, ‑ɛ nu꞊o, 'kuopanyibli kɔ 'crɛkɔnyibli 'hʋɛn‑, ɛ ni ꞊nʋ ꞊haandɛ ‑mɔ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ba kɔ nyibli a nyaɩ, ꞊wɩ yɩ, ‑tɛ 'aan 'Baɩ Nyɩsʋa ‑nu, 'ɛ kɔ nyibli a nyaɩ dɩakɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«A 'nɩ 'yɛɛ 'lɩ 'aan 'bio ‑tɩ, ‑ɛ di꞊e nu, Nyɩsʋa 'nɩ ꞊ha 'a mʋ ‑tɩ ‑yɛɛ ‑nɩ. A 'nɩ 'pʋʋ 'lɩ 'aan 'bio ‑bati lɛ, ‑ɛ di꞊e nu, Nyɩsʋa 'nɩ ꞊ha 'a mʋ ‑bati lɛ ‑pʋʋ ‑nɩ ‑wɛ. Yɩnyre‑tɛblɩ ‑mʋ', nyibli ni 'a mʋ ‑mɔ, 'a ‑tɩ bʋ ‑hru 'a mʋ ‑mɔ, ‑ɛ di꞊e nu, yɩnyre‑tɛblɩ ‑mʋ', a ni, Nyɩsʋa 'mʋ 'a ‑tɩ ‑mɔ hru ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","‑Tɛblɩ ‑mʋ', 'aan 'bio ‑hʋɛ 'a mʋ, ba ‑nyi ꞊nʋ꞊ʋ, ‑ɛ di꞊e nu, 'ba ‑hʋa Nyɩsʋa dɛ, ɛ 'mʋ 'a mɔ꞊ɔ ‑nyi. 'Bʋ mɔ, 'ba yɩ꞊ɩ lɛ nɩ ni, ɛ 'wɩ‑, ‑tɛ ʋ 'yɛ nɩ lɔ wɛn ‑kʋbʋ, ʋ 'mʋ 'a mɔ꞊ɔ ‑nyi a ‑tɩ. ‑Kʋbʋlɔɔpɔlʋ ‑mʋ', ʋ ni, 'ʋ lʋɛ ‑kʋbʋ, ʋ di 'lɩ꞊ɩ 'nɩ 'yii ‑nɩ ‑tɛɛ, ʋ 'mʋ 'lɩ ‑kʋbʋ a 'mʋ 'aan blɔ 'kwli pʋ, ʋ 'mʋ 'lɩ꞊ɩ 'lɩ ‑kɔɔ ‑nɩ, kɔ, ʋ 'mʋ blɔ a 'mʋ bʋ bla, ‑ɛ di꞊e nu, ʋ 'mʋ 'lɩ 'a dɛ ‑bɩ pʋ, blɔ 'mʋ 'lɩ 'yii ‑nɩ ‑tɛɛ. ‑Tɛ a di 'aan 'bio a 'yiye nu, kɛ‑ Nyɩsʋa di 'aan 'yiye nu.» ");
INSERT INTO ktj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","'Ledʋ, ‑Yusu pʋ ꞊nʋ yɩ, ɛ nɔ‑ ‑bʋ: «'Yii'dɔnyɔ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ 'ble 'a 'bɩ 'yii'dɔnyɔ a dabʋ kʋa, bʋ na 'hru. 'Bʋ nu꞊o, ʋ nɩ 'hʋɛn a 'mʋ, ʋ di bi 'lɩ 'butɩɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ɛ 'yɩ 'nyɩnyɩnyɔ ꞊dʋ ‑kɔ, ‑bʋ di 'ʋ 'a tɔɔnyɔ 'lu yɩ nɩ. Kɛɛ, 'nyɩnyɩnyɔ ‑mʋ', ‑ɛ 'nyɩ ‑tɛɛ, ‑tɛ 'a tɔɔnyɔ nɩ 'mʋ, kɛ‑ ɛ di 'mʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Dɛ‑ kɔ ‑tɩ, ‑na 'bɩhɩan a kʋɛtɩyɛ ‑bʋ, ‑ɛ nɩ 'lɩ꞊ɩ 'yi, ꞊nɩ yi 'a 'yelɛ, 'tɩ‑ ‑nɛ tugbɛkʋtɩɔ ‑mʋ', ‑ɛ pɛ 'lɩ ‑mʋ 'yi bʋ, ꞊nɩ 'yɛ nɩ 'ye꞊e 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","꞊Yɩ yɩ ‑blɛɛ ‑nɩ, ‑bʋ lee ‑na 'bɩhɩan, ‑ɛ mɔ: Nu gbe, ꞊bʋ ‑ha 'lɩ ‑mʋ kʋɛtɩyɛ 'yi, ‑mɔ ‑kɔ 'yi tugbɛkʋtɩɔ pɛ 'lɩ bʋ. ‑Mɔ ‑mʋ', ‑ɛ nɛɛ 'li nɩ 'hʋɛn, yɩ‑hɛdɛ, ‑kɔ ‑bʋ nu, ɛ nɔ‑ mɔ ‑bʋ ‑ha 'lɩ ‑nɛ tugbɛkʋtɩɔ 'yi, ꞊mʋ lɛ yru ‑tɛɛ, 'tɩ‑ ꞊mʋ 'lɩ kʋɛtɩyɛ ‑na 'bɩhɩan 'yi ‑ha.» ");
INSERT INTO ktj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kɛ‑ ‑Yusu pɩ de: «Tugbɛ ‑mʋ', ‑ɛ yɩ ꞊haan'nie ‑jri, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ tʋ 'kui ‑hʋɩn. Mɔ, tugbɛ ‑mʋ', ‑ɛ 'yɛ nɩ ‑jri ꞊haan'nie, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ tʋ ꞊haan'kui. ");
INSERT INTO ktj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tugbɛ a 'kuo, ɛ nɔ‑ ʋ yrui ꞊nɛ. Ɛ 'yɩ nyiblo ꞊dʋ ‑kɔ, ‑bʋ ‑ha bubuokui, 'kɩ 'lɩ ꞊wɔnmlʋtu yra. Nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑ha 'ʋ ‑gbɔgbʋyɔ gbʋkawiti 'yri. ");
INSERT INTO ktj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","꞊Haannyiblo a nunu‑tɛblɩ nɔ yɩ, ‑ɛ nu꞊o, 'a ꞊wlʋ nɔ yɩ. 'Crɛkɔnyɔ a nunu‑tɛblɩ nyre yɩ, ‑ɛ nu꞊o, 'a ꞊wlʋ nyre yɩ. ‑Tɩ ‑mʋ', ‑ɛ 'yii 'lɩ nyiblo a ꞊wlʋ kɩ, ɛ nɔ‑ yɩ 'ʋ꞊ʋ wien ‑dii ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Kɛ‑ ‑Yusu pɩ de, ɛ wɛn: «Dɛ‑ kɔ ‑tɩ 'a dɛɛ 'mʋ Kʋkɔnyɔ ti a pɛpɛ, 'tɩ‑ ‑tɩ 'n hlɛ, 'a 'yɛ nɩ nu꞊o 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nyiblo 'bʋ nɩ 'ʋ, ‑tɩ ‑bʋ, 'n hlɛ, 'bʋ yɩ꞊ɩ nʋa yɩ bʋ nɩ pɩ, 'tɩ‑ 'bʋ yɩ꞊ɩ nɩ ni, 'n di 'a mʋ 'nɩ ‑lee ‑nɩ, nyiblo ɛ 'wɩ yɩ. ");
INSERT INTO ktj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ɛ 'wɩ nyiblo ‑mʋ' yɩ, ‑ɛ pɩ 'a 'kayu. Ɛ 'blu ‑tʋtʋ ‑blublu, 'ɛ yɛ 'hɩɔ 'pa kɩ. 'Kɩ ɛ pʋ 'ʋ 'kayu a 'mʋ, ‑ɛ di꞊e nu, ɛ 'mʋ bʋ ku ‑tɛɛ. ‑Tɛ ɛ pʋ꞊ʋ, ‑ɛ ‑bɩ 'nie'yiti nyre 'ʋ nɩ, 'nie a 'mʋ 'ɛ ‑wɔn 'kayu a 'mʋ ‑mɔ ‑wɔnwɔn, kɛɛ, ɛ 'yɩ 'lɩ 'a 'wʋwla 'lɩ ‑wɛ, ‑tɛ ɛ ku bʋ a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kɛɛ, nyiblo ‑mʋ', ‑tɩ ‑bʋ, 'n hlɛ, ‑ɛ di 'wɩn, 'tɩ‑ ‑ɛ 'yɛ nɩ di꞊e nɩ nu, ɛ 'wɩ‑ nyiblo ‑mʋ' yɩ, ‑ɛ 'yɩ ‑tʋtʋ 'blu, ‑ɛ pʋ 'kayu. ‑Tɛ ɛ ‑wɛ 'a pʋpʋʋ ‑mɔ, ‑ɛ ‑bɩ 'nie 'yi nɩ, 'ɛ ‑wɔn 'kayu a 'mʋ yɩ. Ɛ nɔ‑ mɔ 'kayu a 'mʋ bʋ 'wlɛ, 'ɛ nyre yɩ pɛpɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","‑Tɛ ‑Yusu ‑wɛ 'lɩ nyibli a ‑mɔhleelɛ ‑mɔ, ‑ɛ ‑bɩ ɛ mu 'lɩ Kapɛnaɔdɩɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","'Kɩ 'lɩ 'dɩɔ a 'mʋ 'kwli, 'kɩ Romakʋɛ a 'sɛyo a nyiblo gbagbʋ ꞊dʋ nɩ 'lɩ. 'A ‑kʋannunyɔ ꞊dʋ nɩ 'lɩ, 'a ꞊wlʋ 'ɛ ‑ha 'lɩ꞊ɩ dɩakɩ. ‑Kʋannunyɔ a 'mʋ, ɛ nɔ‑ kɔ 'hʋɩ ‑hren, ɛ mi 'kʋ mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","‑Tɛ 'sɛyo a nyiblo gbagbʋ a 'mʋ, ɛ 'wɩn ‑Yusu a 'lɩdi‑tɩ, ɛ nɔ‑ mɔ bʋ tɛ꞊ɛ ‑Juukʋɛ* a 'blʋ a nyibli ꞊dʋ yɩ, bʋ lee ꞊nɛ, ‑ɛ mɔ, bʋ di 'lɩ꞊ɩ ‑mɔ, ɛ 'mʋ꞊ʋ nu, 'a ‑kʋannunyɔ a 'mʋ, 'a 'hʋɩ 'mʋ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","‑Tɛ ‑Juukʋɛ a 'blʋ a nyibli a 'mʋ, ʋ nyre 'ʋ ‑Yusu 'hʋɩ, ‑ɛ ‑bɩ ʋ ‑tʋa 'a lɛnyaalɛ, ʋ wɛn: «'Sɛyo a nyiblo gbagbʋ a 'mʋ, ɛ blɛɛ yɩ, ‑bʋ ‑hɛɛ ꞊nɛ, ");
INSERT INTO ktj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","‑ɛ nu꞊o, ɛ nʋɛ nɛ ‑aan dakɔ nɩ, 'tɩ‑, ɛ nɔ‑ ‑hɛɛ nɛ ‑a mʋ, ꞊a pʋ Nyɩsʋa a 'kayu, 'kɩ 'nɛ‑ ‑aan 'dɩɔ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","‑Tɛ ʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ʋ kɔ ‑Yusu 'hʋɛn‑, ʋ bi 'hru wlɔn, 'ʋ ‑mu. ‑Tɛ ʋ 'mʋɛ 'sɛyo a nyiblo gbagbʋ a 'kayu lɛ, ‑ɛ ‑bɩ nyiblo gbagbʋ a 'mʋ, ɛ lee nɛ 'a 'bio nɩ, 'kɩ bʋ lee ‑Yusu, ‑ɛ mɔ: «Tɔɔnyɔ o, 'nɩ ‑hʋa꞊a lɩ꞊ɩ, ꞊bʋ ‑ha ‑mʋ 'ku. 'Mɔ ‑bʋ, ‑ɛ 'yɩ ‑Juukʋɛyu 'pa‑, 'n 'yɩ yɩ ‑blɛɛ ‑nɩ, 'kɩ ‑bʋ pa 'lɩ 'na 'kayu bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ɛ nɔ‑ nu꞊o, 'nɩ pʋ lɛ, ‑ɛ mɔ, ɛ 'yɩ 'ʋ lɛ ‑nɔɔ ‑nɩ, 'kɩ 'na ꞊gbɛtʋ ꞊bʋ mu wɛn 'lɩ ‑mʋ ‑mɔ. Kɛɛ, pʋ win dadʋ, 'na ‑kʋannunyɔ a 'kʋɛ 'mʋ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","'Na 'mumu ‑bʋ, 'n kɔ nyibli gbagbɩ ‑bɩ. Ʋ nʋ‑ kɔɔ 'mʋ win kɩ. 'Tɩ‑, 'n kɔ 'sɛyo ‑bɩ, 'n kɔɔ win kɩ ‑wɛ. 'Bʋ mɔ 'nɩ pʋ win, 'nɩ lee nɛ 'a nyɔ, 'kɩ bʋ mu dɛ nu, ‑ɛ ‑bɩ ɛ mi nɩ. 'Bʋ mɔ, 'nɩ lee nɛ 'a nyɔ ‑bɩ, 'kɩ bʋ di 'lɩ, ‑ɛ ‑bɩ ɛ yɩ 'lɩ 'nɩ di, ɛ kɔ, 'bʋ mɔ, 'nɩ lee 'na ‑kʋannunyɔ, 'kɩ bʋ nu dɛ, ‑ɛ ‑bɩ ɛ ni꞊e nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","‑Tɛ ‑Yusu 'wɩn ‑tɩ a 'mʋ, 'sɛyo a nyiblo gbagbʋ, ɛ ‑hla, ‑ɛ ‑bɩ 'a ꞊wlʋ kɛɛ lɛ. Ɛ nɔ‑ mɔ bʋ ꞊hɩan ‑mɔ, nyibli ‑mʋ', ‑ʋ yɩ꞊ɩ ꞊wien lɛ kʋɛ, kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ: Nyiblo bʋ di 'na ꞊wlʋ a yɩkuolɛ lɛ nu, 'n 'yɛ 'a nyiblo nɩ 'ye, 'kɩ 'nɛ‑ Yisraɛkʋɛ a 'bli.» ");
INSERT INTO ktj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","‑Yusu bʋ ‑yrɛ, ‑ɛ ‑bɩ 'sɛyo a nyiblo gbagbʋ a lɛlenyʋ ‑nɩ wɛn, ʋ ‑mɛ kle. ‑Tɛ ʋ nyre 'lɩ 'sɛyo a nyiblo gbagbʋ a 'mʋ a 'kayu bʋ, ‑ɛ ‑bɩ ʋ 'ye꞊e nɩ, ‑ɛ mɔ, 'a ‑kʋannunyɔ ‑nɩ wɛn, 'a 'hʋɩ 'kee nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ti gbi bʋ ‑hi, ‑ɛ ‑bɩ 'kɩ ‑Yusu mi 'lɩ 'dɩɔ ‑mʋ', ‑ɛ mɔ Naɛ 'kwli. Ɛ kɔ 'a ‑nagbopʋ* kɔ nyibli ‑hʋɔhʋɩ ‑bɩ 'hʋɛn‑, ʋ nʋ‑ nɛ 'hru nɩ ‑do, 'ʋ mi 'lɩ 'dɩɔ a 'mʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","‑Tɛ ʋ nyre 'lɩ 'dɩɔ a 'mʋ a 'duwle, ‑ɛ ‑bɩ nyibli ‑hɔn 'lɩ 'dɩɔ a 'mʋ 'kwli, 'ʋ 'ble 'kʋkʋku. 'Kʋkʋku a 'mʋ, ɛ nɔ‑ mɔ 'a 'dii a ‑nɛ 'yu nɩ ‑do, ɛ ‑kɔ. 'A 'dii a 'mʋ, ɛ mɔ ‑tʋgbanʋgba ꞊nɩɔ. 'Dɩɔ a 'mʋ a nyibli ‑hʋɔhʋɩ, ʋ nʋ‑ ꞊glaa 'lɩ nʋgba a 'mʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","‑Tɛ Kʋkɔnyɔ ‑Yusu 'ye nʋgba 'a mʋ, ‑ɛ ‑bɩ 'a nyaɩ ‑tʋa 'a nunuo. Ɛ nɔ‑ mɔ bʋ ꞊ga꞊a, ‑ɛ mɔ: «Pʋ nʋa bʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","‑Ɛ ‑bɩ ɛ 'yɩya 'ʋ 'kɔfɩ a 'mʋ 'hʋɩ bʋ, nyibli 'ble, 'ɛ ‑hrɛn꞊ɛ lɛ, ‑ɛ di꞊e nu, ʋ 'mʋ bʋ nyra. 'Kɔfɩ a 'mʋ, ɛ 'yɩ yɩkadɛ ‑kɔ. ‑Tɛ ʋ nyra bʋ, ‑ɛ ‑bɩ kɛ‑ ‑Yusu ‑pʋ: «Gblotayu o, 'n yɩ ‑mʋ 'nɩ ‑lee ‑nɩ, 'du ye'.» ");
INSERT INTO ktj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ gblotayu a 'mʋ, ɛ ꞊wlɛɛ 'yii, 'ɛ 'du ye', 'ɛ nɩ bʋ, 'ɛ ‑tʋa win a pʋpʋʋ. Ɛ nɔ‑ mɔ ‑Yusu bʋ 'du 'a dabʋ ye', bʋ ꞊tu 'lɩ꞊ɩ 'a 'dii ‑jɩ' bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nyibli a pɛpɛ ‑mʋ', ‑ʋ nɩ 'ʋ, ɛ pʋ 'lɩ ꞊nʋ hʋannʋ 'kwli, 'ʋ pɩ Nyɩsʋa 'nyrɛ lɛ, kɛ‑ ʋ pɩ: «Nyɩsʋa a winwlɔn‑hanyɔ* gbagbʋ 'hrɩɩ 'nɛ‑ ‑a mʋ 'nyɩ, 'tɩ‑ Nyɩsʋa a ꞊gbɛtʋ, ɛ nɔ‑ di 'a dakɔ ‑hɛɛ mɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Dɛ nɩ ‑do a 'mʋ a ‑tɩ, ‑Yusu a 'nyrɛ, ɛ kɛɛ 'lɩ ‑Juukʋɛ* a 'blʋgba a pɛpɛ ‑mʋ' nɩ, ɛ kɔ 'blʋgbɩ ‑bɩ ‑mʋ', ‑ʋ ꞊glaa 'lɩ ꞊nʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ti a 'mʋ 'yri, Saan, ‑ɛ pɩ la nyibli 'nie 'lu lɛ, ('kɩ ɛ nɩ la 'lɩ ꞊jɩ'). ‑Tɛblɩ a pɛpɛ, ‑Yusu ni la, ʋ mi la 'lɩ꞊ɩ ‑mɔ, 'ʋ nɛ la꞊a ‑mɔ lɛ. Ɛ nɔ‑ nu꞊o, Saan 'ɛ da la 'a ‑nagbopʋ nɩ 'hʋɛn ꞊dʋ, ");
INSERT INTO ktj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","'ɛ lee la 'lɩ ꞊nʋ Kʋkɔnyɔ ‑Yusu ‑mɔ, ɛ wɛn: «Ba mu, ba 'bɛti꞊e, ꞊bɩ ɛ nɔ‑ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ‑a mʋ yɩ ya, ‑ʋ'ʋ‑, ‑a 'tɩɛ di Wanyɔ a 'mʋ ‑ple?» ");
INSERT INTO ktj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","‑Tɛ ʋ nyre 'ʋ ‑Yusu 'hʋɩ, ‑ɛ ‑bɩ ʋ wɛn: «Saan Batisɩ tɛ ‑a mʋ bʋ, 'kɩ 'nɛ‑ ‑mʋ ‑mɔ, ‑ɛ di꞊e nu, ‑a 'mʋ ‑mʋ 'bɛti ‑nɩ, 'bʋ mɔ, ꞊nɩ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ‑a mʋ yɩ ya, ‑ʋ'ʋ‑ ‑ba 'tɩɛ di Wanyɔ a 'mʋ ‑ple?» ");
INSERT INTO ktj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","‑Tɛ ʋ nyre 'ʋ, ‑ɛ ‑bɩ 'waa 'mumu, ʋ yɩ꞊ɩ 'nɩ 'ye, ‑ɛ mɔ, ‑Yusu ni꞊e nɩ, nyibli ‑hʋɔhʋɩ a 'kʋɛ 'ɛ yɩ ‑wɛ, kɔ 'ɛ blɛ 'kuo ‑hʋɩn* ‑hʋɔhʋɩ lɛ, ‑ʋ nɩ 'ʋ nyibli ke', 'ɛ klɛ 'yii'dɔnyʋ ‑hʋɔhʋɩ a 'yii yɩ. ");
INSERT INTO ktj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kɛ‑ ‑Yusu ‑pʋ, 'ɛ ꞊tu Saan Batisɩ a nyibli a 'mʋ ꞊wɔn, ɛ wɛn: «Ba mu, ‑tɛblɩ ‑bʋ, a 'ye, ɛ kɔ a 'wɩn, ɛ nɔ‑ kɔ ‑tɩ ba lee Saan. Ba lee ꞊nɛ, ‑ɛ mɔ, 'yii'dɔnyʋ tɛ lɛ, lɛ‑yɩyrɛnyʋ 'ʋ nɛ, ꞊hrannunyʋ a 'kʋɛ yɩ 'nɩ ‑wɛ, 'kikenyʋ 'ʋ yɩ ‑tɩ 'wɩn, kɔ, 'kʋkʋnyibli yɩ 'hrɩ 'klɔ lɛ, ꞊hɩʋɛnnyibli 'ʋ yɩ Nyɩsʋa a ꞊haantitie 'wɩn. ");
INSERT INTO ktj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Plɔ a bleelɛ 'kɩ 'ʋ nyiblo ‑mʋ' ‑mɔ, ‑ɛ 'yɛ nɩ hɩa, 'kɩ bʋ kuo 'mʋ ꞊wlʋ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","‑Tɛ Saan a lɛlenyʋ a 'mʋ, ʋ ꞊hɩan ‑mɔ, ‑ɛ ‑bɩ ‑Yusu ‑tʋa Saan a ‑tɩ a kɩhleelɛ, 'kɩ 'ʋ nyibli ‑mʋ', ‑ʋ ꞊gbee 'ʋ꞊ʋ 'hʋɩ a ‑ta', ɛ wɛn: «Saan ‑bʋ, ‑ɛ nɛ la Nyɩsʋa a ‑tɩ ‑mɔ lɛ, 'kɩ 'lɩ ‑tɩtɛ ‑mʋ', nyiblo ꞊dʋ 'yɩ 'lɩ 'ti, ‑tɛ a mu la 'lɩ꞊ɩ ‑mɔ, nyiblo a 'dɩ ‑bɩ 'aan ꞊wlɩ pʋ la lɛ, a di la 'lɩ bʋ ‑yɛɛ ‑nɩ 'lɩ? ꞊Bɩ 'aan ꞊wlɩ wɛn 'nɩ, a di yɛɛ la 'lɩ nyiblodʋ ‑bʋ bʋ, ‑ɛ yɩ hʋannʋ pie, 'kɩ bʋ hla ‑tɩ a ‑tɛɛ? 'Ʋʋn‑, ɛ 'yɩ 'a nyiblodʋ a 'mʋ 'pa‑. ");
INSERT INTO ktj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","꞊Bɩ 'aan ꞊wlɩ 'ye꞊e nɩ, ‑ɛ mɔ, nyiblo ‑bʋ, a di la 'lɩ bʋ ‑yɛɛ ‑nɩ, ɛ di pʋ la yɩnɔwlawlɩ? Nyibli ‑mʋ', ‑ʋ pɩ yɩnɔwlawlɩ, kɔ, ‑ʋ kɔ 'a ‑nɛ dɛ, 'waa ꞊wlɩ ‑hʋɛ, 'kɩ ʋ nɩ 'lɩ 'kɩɩnpʋ a 'kayo blɛ. ");
INSERT INTO ktj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","꞊Bʋ 'bɛti 'a mʋ de: Nyiblo a 'dɩ ‑bɩ a mu la 'ye mɔ 'lɩ? ꞊Bɩ Nyɩsʋa a winwlɔn‑hanyɔ*? Iin, 'n yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ɛ kɔ, 'nɩ hlɛ꞊ɛ, ‑ɛ mɔ, Saan ‑hi 'ʋ Nyɩsʋa a winwlɔn‑hanyʋ ‑bɩ nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ɛ nɔ‑ mɔ nyiblo ‑mʋ', ‑kɔtɩ ʋ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ, ɛ nɔ‑ di la 'na 'hru yɩ kla, 'tɩ‑ 'mʋ la 'lɩ di. ‑Tɩ a 'mʋ, ʋ 'crɩ la, ɛ nɔ‑ ‑bʋ: Nyɩsʋa wɛn 'nɩ: 'Na 'Yu o, 'n di ‑ha nyiblo, 'kɩ 'ʋ 'na ‑kʋan a ‑ta', ɛ 'mʋ mu, ɛ 'mʋ ‑na 'hru yɩ kla, 'tɩ‑ ꞊mʋ 'lɩ nyre. ");
INSERT INTO ktj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, 'kɩ 'lɩ ‑tonyibli a pɛpɛ 'nyɩ, ɛ 'yɩ ‑hʋan nyiblo ꞊dʋ nɩ kʋɛ, ‑bʋ nɩ 'ʋ Saan 'lu yɩ. Kɛɛ, 'kɩ 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli, nyiblo ‑mʋ', ʋ dɛɛ 'hɩangbe, ɛ nɔ‑ di 'ʋ Saan 'lu yɩ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ de, ɛ wɛn: «Nyibli a pɛpɛ, ʋ pɩ la꞊a nʋa yɩ bʋ, ʋ kɔ 'blʋwli'tɩnyʋ 'hʋɛn‑, 'ʋ yɩ la Nyɩsʋa ꞊wɔn ‑nyi, ɛ kɔ, 'ʋ ‑hʋɛ la꞊a, 'kɩ Saan bʋ pʋ la ꞊nʋ 'nie 'lu lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kɛɛ, Falisi꞊tumu* a nyibli kɔ Nyɩsʋa a tetetɔɔnyʋ 'hʋɛn‑, dɛ ‑mʋ', Nyɩsʋa ‑hʋa la ꞊nʋ, ʋ hɩɛ la꞊a kɩ, ɛ nɔ‑ kɔ ‑tɩ 'ʋ hɩa la꞊a kɩ ‑wɛ, 'kɩ Saan bʋ pʋ la ꞊nʋ 'nie 'lu lɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ de, ɛ wɛn: «‑Tɛ ti ‑bʋ 'yri a nyibli nɩ 'mʋ, ɛ nɔ‑ ‑bʋ: ");
INSERT INTO ktj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ʋ 'wɩ‑ 'yonʋ gbi yɩ, ‑ʋ yɩ hru 'mle, 'kɩ 'ʋ 'dika, ‑ʋ ‑bɩ kɛɛ 'waa 'bio nɩ, ʋ wɛn: ‑Tɛ ‑a yɩ 'blɩ nɩ pʋɛ, ‑a yɩ 'blɩpa‑wla ble, a 'yɩ ‑wla yi mɔ ‑di. 'Tɩ‑, ‑tɛ ‑a yɩ ꞊hien nɩ we, a 'yɩ nyaɩŋmlɩ lɛ ‑nu. ");
INSERT INTO ktj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ɛ 'wɩ yɩ, ‑tɛ Saan Batisɩ ‑di, ɛ yɩ 'nɩ ꞊ci*, 'kɩ 'ʋ Nyɩsʋa a dɩda a ‑ta', 'ɛ 'yɛ nɩ 'na nɔ, kɛɛ, kɛ‑ a pɩ: 'Ku ‑hʋan* nɩ 'ʋ꞊ʋ ke'. ");
INSERT INTO ktj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","'Mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, ‑tɛ 'n ‑di, 'nɩ ꞊ci꞊e lɩ, 'nɩ 'nɛ nɔ, kɛɛ, kɛ‑ a pɩ: Ba 'ye nyiblo ‑bʋ, dididɛ kɔ nɔ a 'nɩna nɩ ‑do, ɛ nɔ‑ ɛ yɩ 'lu ‑mɔ lɛ ‑hie. 'Blʋwli'tɩnyʋ kɔ nyibli ‑bʋ, ‑ʋ kɔ 'klɔ ꞊yɩ 'ʋ yɩ 'sii ‑nɩ, ʋ nʋ‑ kɔ꞊ɔ 'hʋɛn‑, ‑ʋ ni nɩnatumudɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ de: «Nyibli nɩ ‑tie ‑mʋ', ‑ʋ wɛn Nyɩsʋa a ꞊tɔ kɩ, ʋ yɩ꞊ɩ 'nɩ yru, ‑ɛ mɔ, Nyɩsʋa a ꞊tɔ a 'mʋ, ɛ 'sii 'ʋ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ɛ kɔ la Falisi꞊tumu a nyiblo ꞊dʋ. 'A 'nyrɛ mɔ la Simɔ. Ɛ nɔ‑ da ‑Yusu dɛ di mɔ. ‑Tɛ ʋ nyre 'lɩ 'kayu bʋ, ʋ nɩ bʋ, 'ʋ ‑tʋa dɛ a didie. ");
INSERT INTO ktj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","'Kɩ 'lɩ 'dɩɔ a 'mʋ 'kwli, 'kɩ 'lawlunʋgba ꞊dʋ nɩ 'lɩ. ‑Tɛ ɛ 'wɩn, ‑ɛ mɔ, ‑Yusu mu dɛ di mɔ, 'kɩ 'lɩ Simɔ a ‑tɛ, ‑ɛ ‑bɩ ɛ ‑ha 'lɩ 'yrɩɛ, ʋ nu yɩnɔhɩɔ, ʋ ‑nu. 'Kɩ 'lɩ 'yrɩɛ a 'mʋ 'kwli, 'kɩ hɩnhrʋnpʋnyra nɩ 'lɩ; ");
INSERT INTO ktj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","'ɛ mu 'ʋ ‑Yusu a bʋɩ ꞊hlɔn, 'ɛ yɩ we, 'a 'yii a mɩ 'ɛ yɩ 'ʋ ‑Yusu a bʋɩ klɛ bi, 'ɛ ni 'a 'lu‑pupui, 'ɛ 'hrɛn ‑Yusu a bʋɩ lɛ, 'ɛ 'ble 'a bʋɩ kʋa, 'ɛ ‑tʋa 'a hɩnhrʋnpʋnyra ‑nɩ wɛn a blɛ'wʋwlalɛ. ");
INSERT INTO ktj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","‑Tɛ Simɔ 'ye dɛ a 'mʋ, ‑ɛ ‑bɩ ɛ ‑tʋa 'lɩ 'a dɩɔnʋ a ꞊wlʋ a kɩ'plɛɛlɛ, ɛ wɛn: «Nyiblo ‑bʋ, 'bʋ mɔ wɛn Nyɩsʋa a sɛyɩ a winwlɔn‑hanyɔ*, ɛ di wɛn꞊ɛ 'nɩ yi, ‑ɛ mɔ, nʋgba ‑bʋ, ‑ɛ ‑hrɛn꞊ɛ lɛ, nyiblo a 'dɩ ‑bɩ ɛ pa 'mʋ. Ɛ di wɛn꞊ɛ 'nɩ yi, ‑ɛ mɔ, 'lawlunʋgba ꞊nɩɔ, ɛ 'yɩ wɛn yɩ ‑blɛɛ ‑nɩ, bʋ ‑ha wɛn꞊ɛ mɛ lɛ, ‑bʋ 'mʋɛ wɛn꞊ɛ lɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kɛ‑ ‑Yusu pɩ 'kɩ꞊ɩ yɩ, ɛ wɛn: «Simɔ o, 'n kɔ ‑tɩ ꞊bʋ lee ‑mʋ.» ‑Ɛ ‑bɩ Simɔ ɛ wɛn: «Tɔɔnyɔ, pʋ win.» ");
INSERT INTO ktj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","‑Ɛ ‑bɩ ‑Yusu wɛn 'nɩ: «Ɛ kɔ la dɛkɔnyɔ ꞊dʋ. Ɛ nɔ‑ nyibli nɩ 'hʋɛn ꞊dʋ 'trɔsɩ la 'wliyɛ. Yɩ‑hɛnyiblo a gba mɔ 'wliyɛ ‑mʋ', ‑kʋannunyɔ nɩ ‑do ‑wɛ 'lɩ bʋ 'yee 'lɩ ‑nyrɔwɩ a ‑hɔtrʋwɩ nɩ ꞊hun 'kwli. 'Hʋɛn a nyiblo a ‑nɛ gba, ɛ mɔ, 'wliyɛ ‑mʋ', nyiblo nɩ ‑do ‑wɛ 'lɩ bʋ 'ye, 'kɩ 'lɩ ‑nyrɔwɩ a (50) ‑wlɩ nɩ 'hʋɛn ꞊tu 'ʋ ‑pu 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","‑Tɛ ʋ 'yɩ 'wliyɛ ‑kɔ, 'kɩ bʋ 'pɛɛ nyɩbɛyu a 'mʋ, 'a gba, ‑ɛ ‑bɩ nyɩbɛyu a 'mʋ, ɛ lee ꞊nʋ nɩ, ɛ wɛn: 'Na gba nɩ wɛn, 'ye ‑bɩ a 'yɩ꞊ɩ 'pɛɛ ‑nɩ, 'n ‑hru 'a ‑tɩ ‑mɔ.» ‑Ɛ ‑bɩ ‑Yusu 'bɛti Simɔ nɩ, ɛ wɛn: «'Kɩ 'lɩ ʋ nɩ 'hʋɛn a 'mʋ 'nyɩ, nyiblo a 'dɩ ‑bɩ sɛyɩ‑sɛyɩ, ‑ɛ di nyɩbɛyu a 'mʋ ‑nʋɛ ‑nɩ, ‑ɛ di 'ʋ 'a 'bɩ 'ʋ ‑hi 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simɔ wɛn: «'N pʋ꞊ʋ ꞊haan‑tɩ, nyiblo ‑mʋ', ‑ɛ kɔ gba gbagbʋ a ‑tɩ ʋ ‑hru ‑mɔ, ɛ nɔ‑ ꞊nɩɔ.» ‑Ɛ ‑bɩ ‑Yusu wɛn: «'A ‑tɛɛ, nɔ‑ ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","‑Ɛ ‑bɩ ɛ ꞊hɩan ‑mɔ, 'ɛ ta 'lɩ nʋgba a 'mʋ ‑mɔ lɛ, 'tɩ‑ 'ɛ yɩ 'kɩ Simɔ ‑lee ‑nɩ: «Ta 'ʋ lɛ, dɛ nʋgba ‑bʋ, ɛ ‑nu. ‑Tɛ 'n pa 'nɛ‑ ‑na ‑tɛ, ꞊yɩ ‑na ‑kʋannunyɔ ‑lee ‑nɩ, 'kɩ bʋ yra 'na bʋɩ lɛ, ‑tɛ ʋ ni꞊e lɛ, 'kɩ 'nɛ‑ ‑aan 'bli. Kɛɛ, nʋgba ‑bʋ, ɛ nɔ‑ ‑mɔ ‑bɩ, ɛ nu 'a 'yii a mɩ, 'ɛ yra 'na bʋɩ lɛ, kɔ, 'ɛ nu 'a 'lu‑pupui, 'ɛ 'hran꞊a lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","'Ya 'ʋ 'lu de, ‑tɛ 'n pa 'nɛ‑ ‑na ‑tɛ, ꞊yɩ 'mʋ 'wlɛɛ ‑nɩ, 'kɩ 'ʋ 'na 'wio a bʋpʋpʋʋ a ‑ta', ‑ɛ mɔ ‑aan 'blidɛ. Kɛɛ, ‑tɛ 'n pa wɛn 'nɛ‑ ‑na ‑tɛ, nʋgba ‑bʋ, ɛ 'tɩɛ yɩ 'na bʋɩ 'wlɛɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","꞊Yɩ 'mʋ 'nyra 'lu ‑pʋ, ‑ɛ mɔ ‑aan 'blidɛ, kɛɛ, ɛ nɔ‑ ‑mɔ ‑bɩ, ɛ 'wlaa 'na bʋɩ hɩnhrʋnpʋnyra lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ɛ nɔ‑ nu꞊o, 'nɩ yɩ ‑mʋ ‑lee ‑nɩ, ‑ɛ mɔ, yɩnyre‑tɛblɩ ‑hʋɔhʋɩ ‑mʋ', ɛ ‑nu, Nyɩsʋa ‑hru 'a ‑tɩ ‑mɔ. Ɛ nɔ‑ kɔ ‑tɩ, 'ɛ kɔ nʋɛlɛ gbagbʋ, 'kɩ 'ʋ 'mʋ ‑mɔ. Kɛɛ, nyiblo 'bʋ nɩ 'ʋ, yɩnyre‑tɛblɩ ‑mʋ', ‑kɔtɩ Nyɩsʋa ‑hru ‑mɔ, 'bʋ 'yɩ ‑hʋ, ‑ɛ ‑bɩ nyiblo a 'mʋ, 'a nʋɛlɛ 'yɩ ‑hʋ, 'kɩ 'ʋ 'mʋ ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kɛ‑ ‑Yusu pɩ nʋgba a 'mʋ yɩ, ɛ wɛn: «Nyɩsʋa ‑hru ‑na dɛ 'kuku a ‑tɩ ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","‑Yusu bʋ pʋ 'kɩ lɛ, ti nɩ ‑do a ti 'yri, nyibli ‑mʋ', ‑ʋ kɔ꞊ɔ 'hʋɛn‑, ‑ʋ nɩ 'ʋ dɛdihu kɩ, ʋ ‑tʋa 'lɩ lɛ'pʋplɛlɛ, 'kɩ 'lɩ 'waa ꞊wlɩ kɩ, ʋ wɛn: «Nyiblodʋ a 'dɩ ‑bɩ nyiblo ‑bʋ, ɛ pa 'mʋ 'lɩ, 'ɛ pɩ lɛ: Nyɩsʋa ‑hru ‑na dɛ 'kuku a ‑tɩ ‑mɔ?» ");
INSERT INTO ktj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ nʋgba a 'mʋ yɩ de, ɛ wɛn: «Kɔ plɔ a bleelɛ, ꞊nɩ yɩ nɩ mi, ‑ɛ nu꞊o, ‑tɛ ‑kuo 'mʋ ꞊wlʋ yɩ a ‑tɩ, Nyɩsʋa ꞊gblɛ ‑mʋ nɩ, 'ɛ ‑ha 'lɩ ‑mʋ dɛ 'kuku a 'klɩ bʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","‑Tɛ ti gbi ‑hi, ‑ɛ ‑bɩ ‑Yusu nɛ la 'dɩɩ kɩ, 'ɛ pɩ la Nyɩsʋa a ꞊haantitie, ‑ɛ hlɛ꞊ɛ, ‑ɛ mɔ, Nyɩsʋa di kɔɔ nyibli win kɩ. 'A ‑nagbopʋ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn ‑mʋ', ");
INSERT INTO ktj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ʋ kɔ nʋgbɩ ‑bɩ 'hʋɛn‑, ʋ nʋ‑ yɩ꞊ɩ ꞊wien kʋɛ. Nʋgbɩ a 'mʋ, ʋ nʋ‑ kɔ ke' ɛ bla la 'ʋ 'kuo ‑hʋɩn* lɛ, kɔ, 'ɛ nu la꞊a, 'waa 'kʋɛ 'ɛ ‑wɛ la. Nʋgbɩ a 'mʋ, 'waa 'nyrɛ, nɔ‑ ‑bʋ: Mari ‑mʋ', ʋ dɛɛ Madala a Mari, ‑ɛ kɔ ke' ‑Yusu bla la 'ʋ 'kuo ‑hʋɩn nɩ ꞊hlon'hʋɛn lɛ; ");
INSERT INTO ktj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ɛ kɔ 'kɩɩn Helɔdɩ a 'kayu a 'yie꞊tunyɔ Kusa a nʋgba, ‑ɛ mɔ Sanɩ, kɔ Sisanɩ, kɔ nʋgbɩ ‑hʋɔhʋɩ ‑bɩ 'hʋɛn‑. Nʋgbɩ a pɛpɛ a 'mʋ, ʋ mɔ la dɛkɔnʋgbɩ dadʋ, 'ʋ ni la 'waa kʋkɔ‑tɛblɩ, 'ʋ yɩ la ‑Yusu kɔ 'a ‑nagbopʋ 'hʋɛn‑ ‑hɛɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","'A ‑nɛ 'dɩɔ 'bʋ nɩ 'ʋ, nyibli ‑hʋɛn 'lɩ ‑wlu, 'ʋ mi 'lɩ ‑Yusu ‑mɔ. ‑Tɛ nyibli ‑hʋɔhʋɩ a 'mʋ, ʋ ꞊glaa 'lɩ꞊ɩ lɛ, ‑ɛ ‑bɩ ɛ ‑tʋa 'waa 'ledʋ a yɩpʋpʋʋ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Ɛ kɔ la ‑nyrɔwɔ ꞊dʋ, nyɩbɛyu ꞊dʋ, 'ɛ mu la 'a ‑tɛblɩ 'dɔ mɔ. ‑Tɛ ɛ nyre 'ʋ, ‑ɛ ‑bɩ ɛ ‑tʋa 'a ‑gbʋgbla, 'kɩ 'lɩ ‑ci 'kwli. ‑Tɛ ɛ yɩ꞊ɩ nɩ ‑gblɛ, ‑ɛ ‑bɩ 'kɩ 'a dɛ ‑bɩ bii 'lɩ 'hru wlɔn, nyibli 'ʋ nɛ꞊ɛ klɛ, nʋblɩ 'ʋ yɩ 'a dɛ ‑bɩ di. ");
INSERT INTO ktj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","'A 'hʋɛn a dɛ, ɛ ‑gbla, ‑tʋtʋkʋtɩɔ ‑mʋ', ɛ bi 'ʋ kɩ, 'hɩɔ 'pa nɩ 'lɩ꞊ɩ bʋ, 'ɛ 'sii yɩ, 'ɛ ꞊ga. Kɛɛ, ‑tɛ ɛ ꞊ga, ‑ɛ ‑bɩ ɛ ma nɩ, ‑ɛ nu꞊o, ‑tʋtʋkʋtɩɔ a 'mʋ, ɛ 'yɩ 'nie ‑kɔ. ");
INSERT INTO ktj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","'A ta a dɛ, ɛ ‑gbla, 'kɩ ɛ bi 'lɩ 'witi 'nyɩ. ‑Tɛ ɛ ꞊ga, ‑ɛ ‑bɩ 'witilili a 'mʋ, ɛ 'ya nɩ, 'ɛ 'buu ꞊nɛ 'lu lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","'A ‑hɛn a dɛ, ɛ ‑gbla, ɛ nɔ‑ bi 'ʋ ꞊haan‑tʋtʋ kɩ. ‑Tɛ ɛ ꞊ga, ɛ ku nɩ ‑tɛɛ, 'ɛ pʋ blɩ. 'A blʋ nɩ ‑do, ɛ pʋ 'yɔ a ‑wlɩ nɩ ꞊hun.» ‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'kɩ ꞊nʋ yɩ: «'Bʋ mɔ, 'ba kɔ ‑tɩ'wɩnnʋa, ‑ɛ ‑bɩ ba 'wɩn ‑tɩ ‑dodo.» ");
INSERT INTO ktj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ɛ nɔ‑ mɔ 'a ‑nagbopʋ* bʋ 'bɛti꞊e lɛ, ʋ wɛn: «'Ledʋ ‑bʋ, ‑pʋ, 'a 'mini 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","‑Ɛ ‑bɩ ɛ wɛn: «'A mʋ ‑bʋ, ‑ʋ mɔ 'na ‑nagbopʋ, Nyɩsʋa ni꞊e nɩ, 'a yrui Nyɩsʋa a ‑tɩ' lɛ, ɛ ꞊hɛn 'nyrɛ, ‑tɛ Nyɩsʋa ni, 'ɛ kʋɛ nyibli win kɩ. Nyɩsʋa a ‑tɩ a 'mʋ, ɛ ‑hli nyibli 'yi kɩ. Nyibli ‑bʋ, ‑ʋ 'yɛ nɩ na 'mʋ ‑mɔ, 'kɩ 'lɩ 'ledʋɩ nɩ ‑do 'kwli, 'kɩ ʋ yɩ 'lɩ꞊ɩ 'lɩ 'wɩɩn ‑nɩ. Ɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ ʋ 'crɩ la, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ: Ʋ yɩ꞊ɩ 'nɩ 'ye ‑tɛɛ, kɛɛ, ʋ 'nɩ ‑yru꞊o lɩ꞊ɩ lɛ, 'ʋ yɩ꞊ɩ 'wɩn ‑tɛɛ, kɛɛ, ʋ 'nɩ ‑yru꞊o lɩ꞊ɩ' lɛ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","‑Ɛ ‑bɩ ɛ yɩ ꞊nʋ 'nɩ ‑lee ‑nɩ, ɛ wɛn: «Dɛ ‑mʋ', 'ledʋ ‑bʋ, ɛ ꞊hɛn 'nyrɛ, ɛ nɔ‑ ‑bʋ: 'Dʋdɔ‑tɛblɩ ‑mʋ', ɛ nɔ‑ mɔ Nyɩsʋa a win. 'Dʋdɔnyɔ, nɔ‑ mɔ nyiblo ‑bʋ, ‑ɛ nɛ Nyɩsʋa a ‑tɩ ‑mɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","'Hru ‑mʋ', ‑ɛ kɔ wlɔn ɛ bii 'lɩ lɛ, 'tɩ‑ nʋblɩ 'ʋ yɩ꞊ɩ di mɔ di, ɛ nɔ‑ mɔ nyibli ‑bʋ, ‑ʋ yɩ Nyɩsʋa a win 'wɩn, 'tɩ‑ 'kuo ‑hʋɩn* a nyiblo gbagbʋ 'ɛ yɩ di, 'ɛ ‑hɛ 'lɩ ꞊nʋ win a 'mʋ ꞊wlʋ klɛ, ‑ɛ di꞊e nu, ʋ 'nɩ ꞊ha Nyɩsʋa a win a 'mʋ ꞊wlʋ yɩ ‑kuo ‑nɩ, Nyɩsʋa 'nɩ ꞊ha ꞊nʋ wa. ");
INSERT INTO ktj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","‑Tʋtʋkʋtɩɔ ‑mʋ', 'hɩɔ 'pa nɩ 'lɩ bʋ, ‑ɛ kɔ kɩ 'dʋdɔ‑tɛblɩ ‑bɩ ‑mʋ', ɛ bii 'ʋ lɛ ‑wɛ, ɛ nɔ‑ mɔ nyibli ‑bʋ, ‑ʋ yɩ Nyɩsʋa a win 'wɩn, 'tɩ‑ ‑ʋ yɩ꞊ɩ kɩ wɛn, 'kɩ 'lɩ plɔ a bleelɛ 'kwli, 'tɩ‑ ‑ʋ kue ꞊nɛ ꞊wlʋ yɩ, 'kɩ 'lɩ ti gbi 'kwli. Kɛɛ, ʋ 'nɩ ‑hʋa꞊a lɩ꞊ɩ, 'kɩ bʋ pʋ 'ma, 'kɩ 'lɩ 'waa ꞊wlʋ kɩ. Nyibli a 'mʋ, ti ‑mʋ', ‑ɛ kɔ 'yri 'kuo ‑hʋɩn a nyiblo gbagbʋ yɩ 'ʋ ꞊nʋ lɛ ꞊tɛɛ ‑nɩ, 'kɩ bʋ nu dɛ 'kuku, ‑ɛ ‑bɩ ʋ yɩ 'kee Nyɩsʋa a win a ꞊wlʋ a yɩkuolɛ. ");
INSERT INTO ktj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","‑Tʋtʋkʋtɩɔ ‑mʋ', 'witi nɩ 'ʋ kɩ, ‑ɛ kɔ kɩ 'dʋdɔ‑tɛblɩ ‑bɩ bii 'lɩ ‑wɛ, ɛ nɔ‑ mɔ nyibli ‑bʋ, ‑ʋ yɩ Nyɩsʋa a win 'wɩn, 'tɩ‑ nyibli a 'mʋ, 'ʋ yɩ hriti ‑nɩ, 'kɩ 'ʋ 'kla‑wliye'yɩya a ‑ta', kɔ, 'ʋ nɛɛ kʋkɔ‑tɛblɩ a ‑tɩ ꞊wlɩ klɛ, ‑ɛ pɩ 'lɩ ꞊nʋ kɩka 'nyɩ, kɔ, 'klɔ a ‑tɛblɩ ‑bʋ, ‑ɛ kɔ 'tʋ ni ꞊nʋ, ɛ nɔ‑ 'waa ꞊wlɩ yɩ ꞊wien lɛ kʋɛ. ‑Tɛblɩ a pɛpɛ a 'mʋ, ɛ ni꞊e nɩ, 'kɩ Nyɩsʋa a win 'yɛ nɩ nu ‑kʋan, 'kɩ 'lɩ 'waa ꞊wlɩ kɩ, 'ɛ yɩ lɛ ‑hihre ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","꞊Haan‑tʋtʋ ‑mʋ', ‑ɛ kɔ kɩ 'dʋdɔ‑tɛblɩ ‑bɩ ‑mʋ', ɛ bii 'lɩ lɛ, ɛ nɔ‑ mɔ nyibli ‑bʋ, ‑ʋ yɩ Nyɩsʋa a win 'wɩn, kɔ, ‑ʋ ꞊tui꞊e bʋ, 'kɩ 'lɩ ꞊haan꞊wlʋ kɩ, 'tɩ‑ ‑ʋ ‑hɛ꞊ɛ mɛ lɛ, 'ɛ ni ‑kʋan 'a ‑nɛ ti, 'kɩ 'lɩ 'waa ꞊wlɩ kɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ de: «Nyiblo 'bʋ 'bɩa 'napɩ, ɛ 'nɩ ꞊jri꞊e lɩ꞊ɩ kɩka 'lu bʋ, ɛ kɔ, nyiblo 'bʋ 'bɩa 'napɩ, ɛ 'nɩ ꞊tu꞊o lɩ꞊ɩ ‑bɛlɛ bʋ. Kɛɛ, 'kɩ ɛ ꞊tui 'lɩ꞊ɩ dɛ yra bʋ, ‑ɛ di꞊e nu, nyibli ‑mʋ', ‑ʋ di 'kayu bʋ pa, ʋ 'mʋ lɛ yru. ");
INSERT INTO ktj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","‑Tɛblɩ a pɛpɛ ‑mʋ', ‑ɛ ‑hli, ɛ di kɔ ‑nyrɔwɔ, ɛ 'mʋ pepe' bi, ɛ kɔ, ‑tɛblɩ a pɛpɛ ‑mʋ', nyiblo ꞊dʋ 'yɩ la ‑yi, ɛ di kɔ lɛyruelɛ, 'tɩ‑ ɛ 'mʋ pepe' bi. ");
INSERT INTO ktj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nyɩsʋa a win ‑bʋ, 'n nɛ ‑mɔ lɛ, ba ꞊tu꞊o 'yie. ‑Tɛ a di 'a 'wɩnwɩɩn nu, kɛ‑ Nyɩsʋa di 'a mʋ 'a lɛyruelɛ nu. Nyiblo ‑mʋ', ‑ɛ pɩ Nyɩsʋa a win nʋa yɩ bʋ, Nyɩsʋa di꞊e 'nɩ nu, ɛ 'mʋ 'a lɛyuyruo kɔ, ɛ 'mʋ ‑tɛ ɛ nu la 'a 'wɩnwɩɩn 'ʋ ‑hi. Kɛɛ, nyiblo ‑mʋ', ‑ɛ 'yɛ nɩ pʋ꞊ʋ nʋa yɩ bʋ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ yru꞊o' lɛ pɛpɛ, 'ye ꞊bɩɩ ɛ pʋ lɛ, ‑ɛ mɔ, ɛ yrui꞊e' lɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","'Kɩ ʋ nɩ 'lɩ 'kayu nɩ ‑do a 'mʋ bʋ, ‑Yusu a 'dii kɔ 'a 'dɩayɩ nyɩbɛpʋ 'hʋɛn‑ 'ʋ nyre 'ʋ, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ 'ye. Kɛɛ, nyibli ‑hʋɔhʋɩ a ‑tɩ, ʋ 'yɩ 'lɩ꞊ɩ ‑wɛ, bʋ nyre 'ʋ꞊ʋ 'hʋɩ. ");
INSERT INTO ktj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ɛ nɔ‑ mɔ nyibli bʋ lee ꞊nɛ: «'Ye kɛ, ‑na 'dii kɔ ‑na 'dɩayɩnʋ 'hʋɛn‑, 'kɩ ʋ nɩ 'lɩ ‑patʋ', 'ʋ ‑hʋɛ ‑na 'yiye.» ");
INSERT INTO ktj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ: «Nyibli ‑mʋ', ‑ʋ pɩ Nyɩsʋa a win nʋa yɩ bʋ, 'tɩ‑ ‑ʋ ꞊tui 'ʋ꞊ʋ 'ʋ, ʋ nʋ‑ mɔ 'na 'dii kɔ 'na 'dɩayɩnʋ 'hʋɛn‑.» ");
INSERT INTO ktj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","‑Nyrɔwɔ ꞊dʋ 'kwli, ‑Yusu 'ya 'lɩ 'blagbɩ 'kwli, ɛ kɔ 'a ‑nagbopʋ* 'hʋɛn‑. Kɛ‑ ɛ pɩ, 'ɛ yɩ ꞊nʋ ‑lee ‑nɩ: «‑Ba ꞊ta, ‑ba mu 'lɩ 'yru a 'kɩbɩa ‑bɩ ‑mʋ' kɩ,» 'ʋ ‑mu. ");
INSERT INTO ktj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","‑Tɛ ʋ yɩ nɩ mi, ‑ɛ ‑bɩ ‑Yusu bi ŋmena'. Ti nɩ ‑do a ti 'yri, 'kɩ 'lɩ 'yru a 'mʋ kɩ, ‑ɛ ‑bɩ 'duduo cɛ 'lɩ nɩ. 'Blagbɩ ‑mɔ ‑bɩ, ɛ yɩ 'lɩ 'nɩ 'yii ‑nɩ, 'kɩ 'ʋ 'yru a 'dʋɩ ‑mɔ', ɛ ‑hʋɛ bʋ ꞊mɩɛ, ");
INSERT INTO ktj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","'a ‑nagbopʋ, 'ʋ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, 'ʋ ‑ha꞊a ŋmena', ʋ wɛn: «Tɔɔnyɔ o, ‑a yɩ ‑wɛ bʋ,» ‑Yusu 'ɛ 'du ye', 'ɛ hlee 'lɩ 'duduo kɔ 'yru a 'dʋɩ 'hʋɛn ‑mɔ, 'kɩ 'lɩ win 'yaklɩ 'kwli. ‑Tɛ ɛ pʋ win, ‑ɛ ‑bɩ ti nɩ ‑do a ti 'yri, ɛ 'kee yɔ'lɛ'yɩya nɩ, pepe 'ɛ nyra bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'kɩ 'a ‑nagbopʋ yɩ: «'Bʋ mɔ, 'nɩ yɩ 'a mʋ nɩ 'ye, 'n yi꞊e nɩ, ‑ɛ mɔ, a 'yɩ Nyɩsʋa ꞊wlʋ yɩ ‑kuo ‑nɩ.» 'A ‑nagbopʋ ‑mɔ ‑bɩ, ʋ 'ta 'ʋ blɛ, ‑tɛ ɛ ma ꞊nʋ wlɔn lɛ a ‑tɩ, 'ʋ yɩ 'lɩ lɛ 'pʋplɛ ‑nɩ, ʋ wɛn: «Ba 'ye kɛ nyiblo ‑bʋ. Ɛ yɩ hlee 'lɩ 'duduo kɔ 'yru 'hʋɛn‑ ‑mɔ, 'tɩ‑ 'ʋ ꞊tui 'ʋ 'a win 'ʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ʋ nyre 'lɩ Galileblʋgba a 'yru a 'kɩbɩa ‑bɩ 'mʋ kɩ nɩ, ‑ɛ mɔ Gelasakʋɛ a 'blʋgba. 'Blʋgba a 'mʋ, ɛ 'bɛ Galileblʋgba 'yi. ");
INSERT INTO ktj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","‑Yusu bʋ ‑hɔn 'kɩ 'lɩ 'blagbɩ 'kwli, ‑ɛ ‑bɩ nyɩbɛyu ꞊dʋ ‑hɔn 'lɩ 'dɩɔ a 'mʋ 'kwli, 'ɛ di꞊e ye' 'bɛ mɔ. Nyiblo a 'mʋ, 'kuo ‑hʋɩn, nʋ‑ nɩ 'ʋ꞊ʋ ke', ‑ʋ ꞊tui꞊e ꞊hɩʋɛn. Kʋɛ 'lɩ ti blɛblɩ 'yie bʋ, ɛ 'nɩ ‑pʋ꞊ʋ lɩ wlawlʋ, kɔ, ɛ 'yɩ 'lɩ 'kayu ꞊dʋ bʋ 'ti, kɛɛ, 'dabi ‑mʋ', ‑ʋ nɩ 'lɩ dʋgbɩ 'kwli, ʋ nʋ‑ kɔ 'nyɩ, ɛ 'ti 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ɛ kɔ ‑nyrɔwɔ ‑bɩ, 'ku ‑hʋan 'bʋ yɩ꞊ɩ klɛ nɩ 'yɛ, ‑tonyibli ni 'cɩɩn, 'ʋ mʋɛ nɛ 'a bʋɩ, kɔ, 'ʋ pɩ 'a dabʋɩ ‑hannya. Kɛɛ, 'a pɛpɛ a 'mʋ, ɛ yɩ la꞊a 'nɩ cɛ, 'ku ‑hʋan a 'mʋ, 'ɛ gbɛ 'lɩ꞊ɩ ‑tɩtɛ ‑mʋ', nyibli 'yɩ 'lɩ 'ti. Kɛɛ, ‑tɛ ɛ 'ye ‑Yusu, ‑ɛ ‑bɩ ɛ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, 'ɛ bla꞊a kwlɩ yɩ bʋ, ‑ɛ di꞊e nu, ‑Yusu 'mʋ꞊ʋ ‑hɛɛ ‑nɩ. Ɛ nɔ‑ mɔ ‑Yusu bʋ lee 'ku ‑hʋan a 'mʋ, ‑ɛ mɔ, bʋ ‑hɔn 'ʋ nyiblo a 'mʋ ke'. Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ nyɩbɛyu a 'mʋ, ɛ ‑tʋa 'lɩ win a 'lɩ'yaalɛ, ɛ wɛn: «‑Yusu, ‑Tɩ'yi'bʋanyɩsʋa a 'Yu, dɛ a 'dɩ ‑bɩ ‑hʋɛ ‑bʋ nu 'mʋ ‑mɔ lɩ? 'N nyaa ‑mʋ lɛ, ꞊nɩ 'tuo 'lɩ 'mʋ ꞊hɩʋɛn.» ");
INSERT INTO ktj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","‑Ɛ ‑bɩ ‑Yusu 'bɛti꞊e nɩ, ɛ wɛn: «‑Na 'nyrɛ 'lɩ?» ‑Ɛ ‑bɩ ɛ ꞊tu꞊o ꞊wɔn, ɛ wɛn: «'Na 'nyrɛ mɔ Dakɔ.» Kɛ‑ ɛ ‑pʋ, ‑ɛ nu꞊o, 'kuo ‑hʋɩn ‑hʋɔhʋɩ, ʋ nʋ‑ nɩ 'ʋ꞊ʋ ke'. ");
INSERT INTO ktj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","‑Ɛ ‑bɩ 'kuo ‑hʋɩn a 'mʋ, ʋ ‑tʋa ‑Yusu a lɛnyaalɛ, ‑ɛ di꞊e nu, ɛ 'nɩ ꞊ha ꞊nʋ ‑lee ‑nɩ, 'kɩ bʋ mu 'lɩ 'hʋɔ ‑mʋ', ‑ɛ kɔ 'kwli ꞊hɩʋɛn a 'yiye nɩ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","'Kɩ 'ʋ ‑tɛ nɩ ‑do a 'mʋ, dʋgba nɩ 'ʋ, 'a 'kʋtɩɔ ‑bɩ, 'ɛ bi 'lɩ 'yru ‑mɔ. 'Kɩ bʋɩca꞊ju gbagbʋ nɩ 'ʋ, 'ʋ ‑wɛ ‑tʋtʋ, 'ʋ yɩ dɛ di. Ɛ nɔ‑ ‑mɔ 'kuo ‑hʋɩn a 'mʋ, bʋ ‑tʋa ‑Yusu a lɛnyaalɛ, ʋ wɛn: «‑A nyaa ‑mʋ lɛ, wɛn, 'kɩ ‑ba bi 'ʋ bʋɩcɩ ‑mʋ' ke',» ‑Yusu 'ɛ ‑wɛn, ");
INSERT INTO ktj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","'kuo ‑hʋɩn a 'mʋ, 'ʋ ‑hɔn 'ʋ nyiblo a 'mʋ ke', 'ʋ bi 'ʋ bʋɩcɩ a 'mʋ ke', bʋɩca꞊ju a 'mʋ, 'ʋ 'gba ci lɛ, 'ʋ ꞊tɩ dʋgba, 'ʋ bi 'lɩ 'yru ‑mɔ lɛ, 'ʋ 'kʋkʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","‑Tɛ nyibli ‑mʋ', ‑ʋ nɛɛ bʋɩcɩ a 'mʋ, ʋ 'ye ‑tɛblɩ a 'mʋ, ‑ɛ mu 'lu ‑mɔ, ‑ɛ ‑bɩ ʋ 'gba ci lɛ, 'ʋ nɛ꞊ɛ ‑mɔ lɛ, 'kɩ 'lɩ 'dɩɩ kɔ ‑yrigbi 'hʋɛn‑ klɛ. ");
INSERT INTO ktj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","‑Tɛ nyibli 'wɩn, ‑ɛ ‑bɩ ʋ di nɩ, ʋ 'mʋ ‑tɛblɩ a 'mʋ, ‑ɛ mu 'lu ‑mɔ 'ye. ‑Tɛ ʋ nyre 'ʋ ‑Yusu 'hʋɩ, 'kɩ ʋ yɛɛ 'ʋ nyiblo a 'mʋ bʋ, ‑ɛ kɔ ke' 'kuo ‑hʋɩn ‑hɔn wɛn 'ʋ. 'Kɩ ɛ nɩ 'ʋ ‑Yusu a bʋɩ ꞊hlɔn bʋ, 'ɛ pʋ wlawlʋ. Ɛ 'wɩ‑ nyiblo ‑bʋ yɩ, nʋblɩ 'yɩ ‑hʋan nɩ ni. ‑Tɛ nyibli a 'mʋ, ʋ 'ye꞊e, ‑ɛ ‑bɩ hʋannʋ bi 'lɩ ꞊nʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nyibli ‑mʋ', ‑ʋ 'ye ‑tɛblɩ a pɛpɛ a 'mʋ, ‑ɛ mu 'lu ‑mɔ, ʋ nʋ‑ nɛ꞊ɛ ‑mɔ lɛ, 'kɩ 'waa 'bio ‑mʋ', ‑ʋ di ‑ta 'ye mɔ yɩ, ‑tɛ ‑bʋ, ‑Yusu nu 'kuo ‑mʋ', ‑ʋ nɩ 'ʋ nyiblo a 'mʋ ke' a lɛbʋbla. ");
INSERT INTO ktj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nyibli a pɛpɛ ‑mʋ', ‑ʋ 'ti 'lɩ 'blʋgba a 'mʋ 'kwli, ‑ɛ mɔ Gelasakʋɛ a 'blʋgba, ʋ ‑tʋa ‑Yusu a lɛnyaalɛ, 'kɩ bʋ ‑hɔn 'lɩ 'waa 'blʋgba a 'mʋ 'kwli, ‑ɛ nu꞊o, hʋannʋ bi 'lɩ ꞊nʋ 'kwli. Ɛ nɔ‑ mɔ ‑Yusu bʋ 'ya 'lɩ 'blagbɩ 'kwli, bʋ mu. ");
INSERT INTO ktj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kɛɛ, nyiblo ‑mʋ', 'kuo ‑hʋɩn ‑hɔn wɛn 'ʋ ke', ɛ nyɛɛ ‑Yusu lɛ, 'kɩ bʋ na꞊a ‑mɔ. Kɛɛ, ‑Yusu 'yɩ꞊ɩ kɩ ‑wɛn, 'ɛ lee ꞊nɛ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«꞊Hɩan ‑mɔ, ‑bʋ mu 'lɩ ‑na 'dɩɔ 'kwli, 'kɩ 'lɩ ‑na 'dʋkʋɛ ‑mɔ, ‑tɛblɩ gbagbɩ a pɛpɛ ‑mʋ', Nyɩsʋa nu ‑mʋ ‑mɔ, ‑bʋ na 'a ‑tɩ ‑mɔ lɛ.» Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ nyiblo a 'mʋ, ɛ bi 'hru wlɔn, 'ɛ mu 'lɩ 'a 'dɩɔ 'kwli, ‑tɛblɩ gbagbɩ a pɛpɛ ‑mʋ', ‑Yusu nu꞊o ‑mɔ, 'ɛ na꞊a ‑mɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ti ‑kɔ 'yri ‑Yusu ‑hɔn 'lɩ 'yru a 'kɩbɩa ‑bɩ ‑mʋ' kɩ, nyibli ‑hʋɔhʋɩ, ʋ nʋ‑ mu la꞊a ye' 'bɛ mɔ, ‑ɛ nu꞊o, 'waa pɛpɛ, ʋ yɩ la꞊a 'nɩ ‑ple. ");
INSERT INTO ktj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","'Kɩ ʋ nɩ 'ʋ bʋ, ‑ɛ ‑bɩ nyɩbɛyu ꞊dʋ nyre nɩ. 'A 'nyrɛ mɔ Sayilu. Ɛ mɔ Nyɩsʋa a 'kayu a nyiblo gbagbʋ ꞊nɩɔ. ‑Tɛ ɛ nyre 'ʋ, ‑ɛ ‑bɩ ɛ bla kwlɩ bʋ, 'kɩ 'ʋ ‑Yusu ye', 'ɛ nyɛɛ ꞊nɛ lɛ, 'kɩ bʋ di 'lɩ 'a ‑tɛ. ");
INSERT INTO ktj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Nyɩbɛhɩan a 'mʋ, ɛ kɔ 'yu nyrɔyu nɩ ‑do. Ɛ ‑wɛ 'lɩ bʋ kɔ 'yrɩ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn nɩ. 'Yu nyrɔyu a 'mʋ, ɛ nɔ‑ ‑hʋɛ ‑bʋ 'kʋ. ‑Ɛ ‑bɩ ‑Yusu wɛn nɩ, ɛ kɔ꞊ɔ 'hʋɛn‑ 'ʋ mi. 'Kɩ 'lɩ 'hru wlɔn, nyibli ‑hʋɔhʋɩ ‑tʋa 'lɩ 'a yrɛ'nyraalɛ. ");
INSERT INTO ktj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","'Kɩ 'lɩ ‑tonyibli a 'mʋ 'nyɩ, 'kɩ nʋgba ꞊dʋ nɩ 'lɩ. Ɛ nɔ‑ 'kʋɛ ni. 'A 'kʋɛ a 'mʋ, ɛ nɔ‑ mɔ ‑hlʋblɛblekʋɛ. ‑Tɛ 'kʋɛ a 'mʋ, ɛ ‑tʋa la 'a nunuo, 'a 'yrɩ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn a 'yrʋ ‑a nɩ kɩ. 'A 'hʋɩ a 'mʋ, 'a ‑tɩ, ɛ na ‑dɔtɔpʋ yrɛ ‑nana, 'a 'wli a pɛpɛ 'ɛ ‑wɛ꞊ɛ ꞊jrɛ. Kɛɛ, ɛ 'yɩ la nyiblo ꞊dʋ ‑kɔ, ‑bʋ ‑wɛ la 'lɩ 'a 'pɩpɩa. ");
INSERT INTO ktj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nʋgba a 'mʋ, ɛ nɔ‑ mu 'ʋ ‑Yusu ke', 'ɛ ‑hrɛn 'a wlawlʋ a ‑wlubʋdɛ lɛ. ‑Ɛ ‑bɩ ti nɩ ‑do a ti 'yri, ‑hlʋ 'kee nɛ 'a blɛbuble nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","‑Ɛ ‑bɩ ‑Yusu 'bɛti nɩ, ɛ wɛn: «Nyiblo a 'dɩ ‑bɩ ‑hrɛn 'mʋ lɛ 'lɩ?» Nyiblo ꞊dʋ 'bʋ 'yɛ nɩ ‑hɩhɩa꞊a klɛ, ɛ nɔ‑ mɔ Piɛlɩ bʋ ꞊tu꞊o ꞊wɔn, ɛ wɛn: «Kʋkɔnyɔ o, nyibli ‑mʋ', ‑ʋ ꞊glaa 'lɩ ‑mʋ lɛ, ʋ ‑hʋ nɩ. 'A ‑tɩ, ʋ nʋ‑ yɩ ‑mʋ yrɛ ꞊gbɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","‑Ɛ ‑bɩ ‑Yusu wɛn: «Nyiblo ‑hrɛn 'mʋ lɛ. 'N yruu 'lɩ꞊ɩ 'na 'hʋɩ 'kwli nɩ, ‑ɛ mɔ, 'klɩ ‑hɔn 'lɩ 'mʋ 'hʋɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nʋgba a 'mʋ, bʋ 'ye꞊e, ‑ɛ mɔ, ɛ bi pepe', ‑ɛ ‑bɩ hʋannʋ bi 'lɩ꞊ɩ 'kwli, 'ɛ 'yɩya 'ʋ ‑Yusu 'hʋɩ bʋ, 'ɛ bla꞊a kwlɩ yɩ bʋ, 'ɛ lee ꞊nɛ, 'kɩ 'ʋ nyibli a pɛpɛ ye', ‑tɩ ‑bʋ ‑kɔ ‑tɩ 'ɛ ‑hrɛn꞊ɛ lɛ, kɔ, ‑tɛ 'a 'kʋɛ nu ‑wʋwɛ ti nɩ ‑do a ti 'yri. ");
INSERT INTO ktj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","‑Tɛ ‑Yusu 'wɩn 'kɩ, ‑ɛ ‑bɩ ɛ wɛn: «'Na 'yu o, ‑tɛ ‑kuo 'mʋ ꞊wlʋ yɩ a ‑tɩ, 'nɩ nu꞊o, ‑na 'kʋɛ 'ɛ ‑wɛ. Mu, 'kɩ 'lɩ plɔ a bleelɛ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Win nɩ 'lɩ꞊ɩ wlɔn, ‑ɛ ‑bɩ nyiblo ‑hɔn 'lɩ nyiblo gbagbʋ Sayilu a ‑tɛ, ɛ wɛn: «Sayilu, ‑na 'yu nyrɔyu ‑nɩ wɛn, ɛ 'kʋ nɩ. 'A ‑tɩ, ‑ha Tɔɔnyɔ ‑Yusu mɛ lɛ, ꞊bɩ ꞊yɩ꞊ɩ 'ku ‑ha.» ");
INSERT INTO ktj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","‑Tɛ ‑Yusu 'wɩn ‑tɩ a 'mʋ, ‑ɛ ‑bɩ ɛ lee Sayilu nɩ, ɛ wɛn: «‑Na ꞊wlʋ 'nɩ 'bie 'lɩ ꞊hlɔn, kɛɛ, kuo 'mʋ ꞊wlʋ yɩ dadʋ, ɛ di 'hrɩ 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","‑Tɛ ʋ nyre 'lɩ Sayilu a ‑tɛ, ‑Yusu 'yɩ ‑wɛn, 'kɩ ɛ kɔ nyibli ‑hʋɔhʋɩ 'hʋɛn‑ bʋ pa 'lɩ 'kayu a 'mʋ bʋ, 'bʋ 'yɩ 'a ‑nagbopʋ* Piɛlɩ, kɔ Saan, kɔ Sakɩ, ʋ kɔ 'yu a 'mʋ, 'a 'baɩ kɔ 'a 'dii 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nyibli a pɛpɛ pɩ popowli lɛ, 'ʋ ni nyaɩ lɛ, 'yu a 'mʋ a ‑tɩ. ‑Ɛ ‑bɩ ‑Yusu wɛn 'nɩ: «Ba 'kee wuwe. Ɛ 'yɩ 'kʋ. Ŋmena ɛ yɩ ŋme.» ");
INSERT INTO ktj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ʋ ‑tʋa 'a 'caalɛ, ‑ɛ nu꞊o, ʋ yi꞊e nɩ, ‑ɛ mɔ, 'yu 'kʋ nɩ, ");
INSERT INTO ktj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","‑Yusu ‑mɔ ‑bɩ, 'ɛ klɔ 'yu a 'mʋ, 'a dabʋ bʋ, 'ɛ 'yaa 'lɩ win, ɛ wɛn: «'Yu o, 'du ye'!», ");
INSERT INTO ktj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","'a ‑hihiu 'ɛ bi 'ʋ꞊ʋ ke' de. ‑Ɛ ‑bɩ ti nɩ ‑do a ti 'yri, ɛ 'du ye', ‑Yusu 'ɛ lee nɛ 'a 'dʋkʋɛ, ɛ wɛn: «Ba ‑nyi꞊e diidɛ, ɛ 'mʋ꞊ʋ di.» ");
INSERT INTO ktj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","'A 'baɩ kɔ 'a 'dii 'hʋɛn‑, 'waa ꞊wlɩ kɛɛ lɛ. Kɛɛ ‑Yusu ti ꞊nʋ nɩ, ɛ wɛn: «Dɛ ‑bʋ, ‑ɛ mu 'lu ‑mɔ, a 'nɩ 'lee 'lɩ nyiblo ꞊dʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu 'kukue 'a ‑nagbopʋ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn lɛ, 'ɛ ‑nyi ꞊nʋ 'klɩ, 'kɩ bʋ bla 'kuo ‑hʋɩn* lɛ, ‑ʋ nɩ 'ʋ nyibli ke', kɔ, bʋ nu꞊o, nyibli a 'kʋɛ bʋ ‑wɛ, ");
INSERT INTO ktj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","'ɛ lee ꞊nʋ, ‑ɛ mɔ, bʋ na 'dɩɩ klɛ, bʋ hla꞊a, ‑tɛ Nyɩsʋa di nyibli a win a kɩkɔɔlɛ nu, ɛ kɔ, bʋ nu꞊o, nyibli a 'kʋɛ bʋ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kɛ‑ ɛ pɩ, 'ɛ yɩ ꞊nʋ ‑lee ‑nɩ, ɛ wɛn: «'Bʋ mɔ, 'ba yɩ 'dɩɩ kɩ nɩ nɛ, a 'nɩ 'gbaa 'lɩ ꞊dedede, a 'nɩ 'gbaa 'lɩ kotu, kɔ blɔ, kɔ dididɛ, kɔ 'wliyɛ, kɔ, a 'nɩ 'gbaa 'lɩ wlawlʋ a 'hʋɛn a dɛ. ");
INSERT INTO ktj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","'A ‑nɛ 'dɩɔ ‑kɔ 'kwli a di 'lɩ nyre, 'kayu ‑mʋ', ‑ɛ kɔ bʋ ʋ di 'lɩ 'a mʋ 'lɩ ‑paa ‑nɩ, 'kɩ ba nɩ 'lɩ bʋ ‑nɩnɩ, 'aan mumuti 'mʋ 'ʋ nyre. ");
INSERT INTO ktj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","'Dɩɔ ‑kɔ 'kwli a di 'lɩ mu, 'kɩ ʋ 'yɛ nɩ di 'a mʋ kʋa nɩ 'ble, ba ‑hɔn 'lɩ 'dɩɔ a 'mʋ 'kwli. 'Ba yɩ nɩ mi, ba bʋbla 'aan bʋɩ, ‑ɛ di꞊e nu, 'waa ‑tʋtʋ a 'pupu 'mʋ 'a mʋ bʋɩ lɛ ‑hɔn, a 'mʋ꞊ʋ nyibli a 'mʋ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, Nyɩsʋa a yrʋ 'bʋ klɔ ꞊nʋ, 'waa ꞊gbɛtʋ nu꞊o 'waa dɩɔnʋ ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","‑Tɛ ɛ ‑wɛ 'waa titie ‑mɔ, ‑ɛ ‑bɩ 'a ‑nagbopʋ bi 'hru wlɔn, 'ʋ nɛ nyibli yrɛ, 'ʋ pɩ ꞊nʋ Nyɩsʋa a ꞊haantitie. 'A ‑nɛ ‑tɩtɛ, ʋ di 'ʋ nyre, ʋ kɔ bʋ nu꞊o, 'hʋɩhrennyʋ a 'hʋɩ bʋ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ti a 'mʋ 'yri, Galileblʋgba a ‑gʋlʋnʋma, ‑ɛ kɔ 'nyrɛ mɔ Helɔdɩ, ɛ 'wɩn ‑tɛblɩ a pɛpɛ ‑mʋ' nɩ, ‑Yusu ni. Dɛ bʋ di 'lu ‑mɔ lɛ ‑hie, 'kɩ 'ʋ ‑Yusu a ‑ta', ɛ 'yɩ꞊ɩ ‑yi, ‑ɛ nu꞊o, kɛ‑ nyibli ‑bɩ pɩ: «Ɛ mɔ Saan Batisɩ ꞊nɩɔ. ‑Tɛ ɛ 'kʋ la, ɛ 'hrɩ 'klɔ de.» ");
INSERT INTO ktj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Kɛ‑ ‑ʋ ‑bɩ pɩ: «Eli*, ‑ɛ mɔ la Nyɩsʋa a winwlɔn‑hanyɔ*, ɛ nɔ‑ 'hrɩ 'klɔ.» ‑Ʋ ‑bɩ wɛn 'nɩ: «Nyɩsʋa a winwlɔn‑hanyɔ ‑bɩ, ‑ɛ 'kʋ la, ɛ nɔ‑ 'hrɩ 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","‑Ɛ ‑bɩ kɛ‑ Helɔdɩ ‑mɔ ‑bɩ, ɛ pɩ 'kɩ: «'N lee la nyibli, bʋ 'bɛ la 'ʋ Saan a 'lu. 'A ‑tɩ, nyiblo ‑bʋ, ‑ɛ kɔ 'nyrɛ 'n yɩ 'wɩn, ‑ɛ ni ‑tɛblɩ a pɛpɛ ‑bʋ, nyiblo a 'dɩ ‑bɩ ɛ pa 'mʋ 'lɩ?» Ɛ nɔ‑ nu꞊o, 'ɛ ꞊mʋɛ ‑Yusu a 'yiye lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","‑Tɛ ‑Yusu lee la 'a ‑mɔnanyʋ*, 'kɩ bʋ na la 'dɩɩ klɛ, ‑tɛ ʋ ‑mɛ kle, ‑ɛ ‑bɩ ʋ lee ‑Yusu ‑tɛblɩ a pɛpɛ ‑mʋ', ʋ ‑nu, 'ɛ gba ꞊nʋ, 'ʋ mu 'lɩ ‑tɩtɛ ‑mʋ', 'dʋ bi 'lɩ yɩ, 'kɩ 'ʋ 'dɩɔ ‑mʋ', ʋ dɛɛ Bɛtɩsaida ꞊hlɔn. ");
INSERT INTO ktj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kɛɛ, nyibli ‑mʋ', ʋ hie wɛn 'ʋ bʋ, ʋ 'wɩn nɩ, ‑ɛ mɔ, ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ mi 'lɩ ‑tɩtɛ ‑bɩ. Ɛ nɔ‑ nu꞊o, 'ʋ kʋɛ ꞊nʋ ꞊wien. Nyibli a pɛpɛ a 'mʋ, ‑ʋ ‑di, ‑Yusu 'ble ꞊nʋ kʋa ‑tɛɛ, kɔ, 'ɛ tɔɔ ꞊nʋ, ‑tɛ Nyɩsʋa di nyibli a win a kɩkɔɔlɛ nu, kɔ, nyibli, ‑ʋ kɔ kɩkladɛ, 'ɛ nu꞊o, 'waa 'kʋɛ 'ɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","‑Tɛ 'tɔ yɩ nɩ ‑wɛn, ‑ɛ ‑bɩ ‑nagbopʋ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn ‑mʋ', ʋ 'yɩya 'ʋ ‑Yusu 'hʋɩ bʋ, ʋ wɛn: «Lee nyibli ‑bʋ, 'kɩ bʋ mu 'lɩ 'dɩɩ kɔ ‑yrigbi ‑mʋ' klɛ, ‑ʋ ꞊glaa 'lɩ ‑a mʋ lɛ, ‑ɛ di꞊e nu, ʋ 'mʋ 'lɩ bʋpɛɛlɛ kɔ diidɛ 'hʋɛn‑ lɛ ꞊mʋɔ ‑nɩ, ‑kɔtɩ ‑tɩtɛ ‑bʋ, ‑a nɩ 'nɛ‑, 'dʋ bii 'nɛ‑ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","‑Ɛ ‑bɩ ‑Yusu wɛn: «'Aan ꞊gbɛtʋ, ba ‑nyi ꞊nʋ diidɛ.» Ʋ wɛn: «'Flɔɔkui nɩ ꞊hun kɔ ‑hrin.yɔ gbi nɩ 'hʋɛn‑, nʋ‑ nɩ mɔ. 'Bʋ mɔ, ꞊ba 'yɩ dididɛ ‑tɔ mɔ ‑mu, 'kɩ 'ʋ nyibli a pɛpɛ ‑bʋ ‑mɔ, ‑a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ‑ba ‑nyi ꞊nʋ dididɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","'Kɩ 'lɩ nyibli a 'mʋ 'nyɩ, nyɩbɛpʋ a 'miliwɩ nɩ ꞊hun, nʋ‑ nɩ 'lɩ. ‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'a ‑nagbopʋ yɩ, ɛ wɛn: «Ba lee ꞊nʋ, bʋ nu dui, bʋ nɩ blɛ, du nɩ ‑do 'bʋ nɩ 'ʋ, bʋ nu nyibli a (50) ‑wlɩ nɩ 'hʋɛn ꞊tu 'ʋ ‑pu.» ");
INSERT INTO ktj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Dɛ a 'mʋ, ‑Yusu lee ꞊nʋ, ɛ nɔ‑ ʋ ‑nu, 'ʋ lee nyibli, 'kɩ bʋ nɩ blɛ. ");
INSERT INTO ktj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","‑Tɛ ʋ nɩ 'kɩ blɛ, ‑ɛ ‑bɩ ‑Yusu 'du 'flɔɔkui nɩ ꞊hun kɔ ‑hrin.yɔ nɩ 'hʋɛn a 'mʋ ye', 'ɛ 'du 'lu ye', 'ɛ ta 'lɩ yɔ' lɛ, 'ɛ ‑nyi Nyɩsʋa 'wio, 'kɩ 'ʋ dididɛ a 'mʋ a ‑ta', 'ɛ 'bɛ꞊ɛ ꞊tɩɔ lɛ, 'ɛ ‑nyi꞊e 'a ‑nagbopʋ, 'kɩ bʋ ꞊gla꞊a nyibli a 'mʋ lɛ, ");
INSERT INTO ktj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","‑tonyibli a 'mʋ, 'ʋ di dɛ ‑didi, 'waa pɛpɛ 'ʋ ꞊mla. ‑Tɛ ʋ ‑wɛ dɛ lɛ, dididɛ a 'mʋ, 'a dɛ ‑bɩ ‑hie bʋ, 'a ‑nagbopʋ 'ʋ 'kukue꞊e lɛ, 'ʋ 'yii 'lɩ ‑tʋgbɩwɩ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn. ");
INSERT INTO ktj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","‑Nyrɔwɔ ꞊dʋ 'kwli, ‑Yusu bii la yɩ, 'ɛ dɛ la Nyɩsʋa. ‑Ɛ ‑bɩ 'a ‑nagbopʋ* mu 'ʋ꞊ʋ 'hʋɩ, 'ɛ ‑tʋa 'waa lɛ'bɛtilɛ, ɛ wɛn: «Nyibli wɛn 'nɩ, nyiblo a 'dɩ ‑bɩ 'n pa 'mʋ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","‑Ɛ ‑bɩ ʋ ꞊tu꞊o ‑wɔn, ʋ wɛn: «‑Ʋ ‑bɩ wɛn 'nɩ, ‑mɔ mɔ Saan Batisɩ, ‑ɛ pɩ la nyibli 'nie 'lu lɛ. ‑Ʋ ‑bɩ wɛn 'nɩ, ‑mɔ Nyɩsʋa a winwlɔn‑hanyɔ Eli ꞊nɩɔ. ‑Ʋ ‑bɩ wɛn 'nɩ, ‑mɔ Nyɩsʋa a winwlɔn‑hanyɔ ‑bɩ ꞊nɩɔ, ‑ɛ 'kʋ la, ti ‑hi la a ti 'yri, 'tɩ‑ ‑ɛ 'hrɩ 'klɔ de.» ");
INSERT INTO ktj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","‑Ɛ ‑bɩ ɛ 'bɛti ꞊nʋ nɩ de, ɛ wɛn 'nɩ: «'A mʋ ‑mɔ ‑bɩ, a wɛn 'nɩ, nyiblo a 'dɩ ‑bɩ 'n pa 'mʋ 'lɩ?» ‑Ɛ ‑bɩ Piɛlɩ bi 'ʋ nɩ, ɛ wɛn: «‑Mɔ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya.» ");
INSERT INTO ktj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","‑Yusu lee ꞊nʋ nɩ ‑tɛɛ, ɛ wɛn: «A 'nɩ 'lee 'lɩ nyiblo ꞊dʋ, nyiblo a 'dɩ ‑bɩ 'n pa 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ de: «'Mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n kɔ ꞊bʋ 'ye ꞊hɩʋɛn dɩakɩ. 'Blʋ a nyibli, kɔ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ, kɔ Nyɩsʋa a tetetɔɔnyʋ 'hʋɛn‑, ʋ kɔ bʋ yraa 'mʋ, ʋ 'mʋ 'mʋ 'la. 'Bʋ mɔ, 'nɩ 'kʋ, ‑nyrɔwɩ nɩ 'hʋɛn, ta a ‑nyrɔwɔ, Nyɩsʋa di ‑ha 'mʋ 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nyibli a pɛpɛ, ‑ʋ nɩ 'ʋ, kɛ‑ ɛ pɩ ꞊nʋ yɩ: «Nyiblo 'bʋ nɩ 'ʋ, 'bʋ yɩ꞊ɩ nɩ ‑hʋɛ, bʋ kʋɛ 'mʋ ꞊wien lɛ, ɛ 'nɩ 'kʋɛɛ 'lɩ 'a dɩɔnʋ a 'lulɛ‑hihie ꞊wien lɛ, kɛɛ, ‑tɩ ‑bʋ, 'n di꞊e ‑lee ‑nɩ, ɛ nɔ‑ bʋ nu 'a ‑nɛ ‑nyrɔwɔ, 'ye ꞊bɩɩ nyibli bʋ pʋ lɛ, ʋ 'mʋ꞊ʋ 'la, ‑tɛ ɛ pa 'ʋ, 'ɛ mɔ 'na nyiblo a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nyiblo 'bʋ pʋ lɛ, ɛ 'nɩ ‑hʋa꞊a lɩ bʋ 'waan nɛ 'a dɩɔnʋ a ‑hʋnhlʋn, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, 'kɩ 'ʋ 'na ‑ta', nyiblo a 'mʋ, 'bʋ mɔ, 'bʋ 'kʋ, ɛ di 'a 'klɔ yrayrʋ 'nɩ 'waan ‑nɩ, 'kɩ 'lɩ Nyɩsʋa yɩ. Kɛɛ, nyiblo 'bʋ ‑wɛn, 'kɩ 'a dɩɔnʋ a ‑hʋnhlʋn bʋ 'wan, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, ‑tɛ ɛ nʋɛ 'mʋ a ‑tɩ, ‑ɛ ‑bɩ nyiblo a 'mʋ, 'bʋ mɔ, 'bʋ 'kʋ, ɛ di kɔ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ, 'kɩ 'lɩ Nyɩsʋa yɩ. ");
INSERT INTO ktj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nyiblo 'bʋ kɔ 'klɔ ‑bʋ a kʋkɔ‑tɛblɩ a pɛpɛ, 'tɩ‑ 'bʋ 'waan nɛ 'a dɩɔnʋ a 'klɔ yrayrʋ, 'kɩ 'lɩ Nyɩsʋa yɩ, kɔ, Nyɩsʋa a ‑bati bʋ klɔ꞊ɔ, kʋkɔ‑tɛblɩ a 'mʋ, ɛ 'nɩ ‑pʋ꞊ʋ 'ʋ꞊ʋ ꞊dedede nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","'Bʋ mɔ, 'ba yɩ ‑tʋɩ nɩ pie, 'kɩ 'ʋ nyibli a 'mʋ ye', 'kɩ ꞊bʋ di 'aan Kʋkɔnyɔ' pa, kɔ, 'kɩ ba di 'ʋ 'na win 'ʋ ꞊tuu ‑nɩ, ‑ɛ ‑bɩ 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, ti ‑mʋ' ‑kɔ 'yri 'n di 'ʋ ‑dii ‑nɩ de, 'kɩ 'lɩ 'na 'Baɩ a ‑tɩ a 'yi'bʋalɛ 'kwli, 'n kɔ 'a lɛlenyʋ 'hʋɛn‑, ti a 'mʋ 'yri, 'na 'mumu, 'n di pie ‑tʋɩ ‑wɛ, 'kɩ 'ʋ Nyɩsʋa ye', 'kɩ ꞊bʋ hla꞊a, ‑ɛ mɔ, a mɔ 'na nyibli. ");
INSERT INTO ktj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, 'kɩ 'lɩ 'a mʋ 'nyɩ, nyibli ‑bɩ nɩ 'lɩ, ʋ 'mʋ ‑hʋan꞊a 'ye, ‑tɛ Nyɩsʋa di nyibli a win a kɩkɔɔlɛ nu, 'tɩ‑ ɛ 'mʋ ‑hʋan nyibli a 'mʋ, 'waa 'kʋkʋʋ a ti kɩ yɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","‑Yusu bʋ ‑wɛ 'kɩ ‑tɩ a 'mʋ, 'a hɩhla ‑mɔ, 'a 'wee nɩ ‑do bʋ ‑hi, ‑ɛ ‑bɩ ɛ gba Piɛlɩ, kɔ Saan, kɔ Sakɩ 'hʋɛn‑ nɩ, 'ʋ 'ya 'lɩ dʋgba ꞊dʋ 'lu, ʋ 'mʋ Nyɩsʋa da. ");
INSERT INTO ktj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ʋ nɩ 'lɩ Nyɩsʋa a dɩda 'kwli, ‑ɛ ‑bɩ ‑Yusu a yigbakla 'cɩcɩ nɩ, kɔ, 'a wlawlʋ 'ɛ ‑tʋa 'pʋplɛ, 'tɩ‑ 'ɛ yɩ wlɩn dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ ʋ 'ye nyibli nɩ 'hʋɛn, ʋ kɔ ‑Yusu 'hʋɛn‑ ‑ʋ pɩ toto. Nyibli a 'mʋ, ʋ nʋ‑ mɔ Nyɩsʋa a winwlɔn‑hanyɔ Moise kɔ Eli 'hʋɛn‑. Nyibli nɩ 'hʋɛn a 'mʋ, ʋ 'kʋ la nɩ, ");
INSERT INTO ktj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","'ʋ 'hrɩɩ 'ʋ ‑Yusu 'hʋɩ, 'kɩ 'lɩ ‑tɩ a 'yi'bʋalɛ ‑mʋ', Nyɩsʋa ‑nyi ꞊nʋ 'kwli. ‑Tɛ Nyɩsʋa ‑hʋɛ ‑Yusu bʋ nu 'kʋkʋʋ, 'kɩ 'lɩ Jrusrɛdɩɔ 'kwli, ɛ nɔ‑ kɔ ‑tɩ ʋ hlɛ. ");
INSERT INTO ktj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","‑Tɛ dɛ a 'mʋ, ɛ yɩ 'lu ‑mɔ nɩ mi, ‑ɛ ‑bɩ Piɛlɩ kɔ 'a 'bio 'hʋɛn‑, ʋ hlɛ 'lɩ ŋmena' bʋ. Kɛɛ, ‑tɛ ʋ ꞊wlɛɛ 'yii, ‑ɛ ‑bɩ ʋ 'ye ‑tɩ a 'yi'bʋalɛ a 'mʋ nɩ, 'ɛ ꞊glaa 'lɩ ‑Yusu kɔ nyibli nɩ 'hʋɛn ‑nɩ wɛn nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","'Tɩ‑ Moise kɔ Eli 'hʋɛn‑, ʋ 'mʋ 'ʋ ‑Yusu 'hʋɩ ‑hɔn mɔ mu, ‑ɛ ‑bɩ kɛ‑ Piɛlɩ pɩ 'kɩ ‑Yusu yɩ, ɛ wɛn: «Tɔɔnyɔ o, ɛ nu ‑tɛɛ, 'kɩ ‑ba nɩ 'nɛ‑ ‑tɩtɛ ‑bʋ bʋ. ‑Ba pʋ papʋɩ nɩ ta, ‑nɛ pʋpa, Moise a ‑nɛ, kɔ Eli a ‑nɛ.» ‑Tɩ bʋ di hla, ɛ 'yɩ꞊ɩ ‑yi. Ɛ nɔ‑ kɔ ‑tɩ 'ɛ ni 'pʋplɛ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Piɛlɩ nɩ 'lɩ 'pʋplɛ 'kwli, ‑jru 'ɛ 'hrɩɩ 'ʋ, 'ɛ ‑hli ‑Yusu kɔ Moise kɔ Eli 'hʋɛn‑. ‑Tɛ Piɛlɩ kɔ 'a 'bio 'hʋɛn‑, ʋ 'ye dɛ a 'mʋ, ‑ɛ ‑bɩ hʋannʋ bi 'lɩ ꞊nʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","'Kɩ 'lɩ ‑jru a 'mʋ 'kwli, 'kɩ Nyɩsʋa a win ‑hʋɛn 'lɩ ‑wlu, 'ɛ pɩ lɛ: «Nyiblo ‑bʋ, ɛ nɔ‑ mɔ 'na 'Yu. Ɛ nɔ‑ 'n ‑ha, 'kɩ 'ʋ 'na ‑kʋan a ‑ta'. Ba pʋ꞊ʋ nʋa yɩ bʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bʋ 'wɩn win a 'mʋ, ‑ɛ ‑bɩ ‑Yusu nɩ ‑do 'a ‑nagbopʋ* yɩ 'kɩ 'ye. ‑Tɛ ʋ ꞊tɩ 'lɩ dʋgba a 'mʋ 'lu, dɛ a 'mʋ, ‑Yusu a ‑nagbopʋ 'ye, ʋ 'yɩ꞊ɩ nyiblo ꞊dʋ ‑lee ‑nɩ, 'ɛ gba ti ‑hʋɔhʋɩ. ");
INSERT INTO ktj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","‑Tɛ ‑nyrɛ ‑nyɛ, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* nɩ ta ‑mʋ' 'hʋɛn, ʋ ꞊tɩ dʋgba. ‑Tɛ ʋ ꞊tɩ 'kɩ dʋgba, ‑ɛ ‑bɩ nyibli ‑hʋɔhʋɩ di ‑Yusu ye' 'bɛ mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","'Kɩ 'lɩ nyibli ‑hʋɔhʋɩ a 'mʋ 'nyɩ, 'kɩ nyiblo ꞊dʋ nɩ 'lɩ, 'ɛ 'yɛɛ 'lɩ win, 'ɛ pɩ lɛ: «Tɔɔnyɔ o, 'n nyaa ‑mʋ lɛ, 'ye 'na 'yu nyɩbɛhɩan. Ɛ nɔ‑ mɔ 'na 'yu nɩ ‑do. ");
INSERT INTO ktj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ɛ kɔ ti, 'ku ‑hʋan 'ɛ 'yɛ꞊ɛ klɛ, 'ɛ ni꞊e, 'ɛ 'gbugbe lɛ, 'ɛ bʋblɛ꞊ɛ blɛ dɩakɩ, 'ɛ ni꞊e, hɩʋnplu 'ɛ nyrɛ꞊ɛ wien bʋ, 'ɛ ꞊tui꞊e ꞊hɩʋɛn. Ɛ gbɛ ti ‑hʋɔhʋɩ, 'tɩ‑ 'ɛ ‑hʋɛn 'ʋ꞊ʋ ke'. ");
INSERT INTO ktj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","'N nyaa ‑na ‑nagbopʋ lɛ, 'kɩ bʋ bla 'ku ‑hʋan a 'mʋ lɛ, kɛɛ, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kɛɛ, kɛ‑ ‑Yusu pɩ, 'ɛ yɩ 'a ‑nagbopʋ ‑lee ‑nɩ, ɛ wɛn: «A mɔ nyibli ꞊nɩɔ, ‑ʋ 'yɩ Nyɩsʋa ꞊wlʋ yɩ ‑kuo ‑nɩ ‑tɛɛ, 'tɩ‑, ‑ʋ 'yɩ ꞊haandɛ kɔ dɛ ‑hʋan a 'yilɛ‑hɩhɩalɛ ‑yi. Ti nɩ ‑tie 'n di 'nɛ‑ 'a mʋ 'nyɩ ‑hii ‑nɩ, 'tɩ‑ a 'mʋ Nyɩsʋa ꞊wlʋ yɩ ‑kuo ‑nɩ 'lɩ? ꞊Bɩ kɛ‑ 'n di nu 'a ‑nɛ ti, 'mʋ 'a mʋ lɛ ‑kikle ‑nɩ nɩ ‑do? Ya 'mʋ ‑na 'yu a 'mʋ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","‑Tɛ 'yu a 'mʋ, ɛ 'yɩyɛ 'ʋ ‑Yusu 'hʋɩ bʋ, ‑ɛ ‑bɩ 'ku ‑hʋan a 'mʋ, ɛ pʋ꞊ʋ ꞊hlɔn, 'ɛ ‑tʋa 'a blɛ‑huhlilɛ. Ɛ nɔ‑ mɔ ‑Yusu bʋ hlee 'lɩ 'ku ‑hʋan a 'mʋ ‑mɔ, 'kɩ 'lɩ win 'yaklɩ 'kwli, 'tɩ‑ 'ku ‑hʋan 'a mʋ, 'ɛ ‑hɔn la 'ʋ 'yu a 'mʋ ke'. Kɛ‑ ‑Yusu ‑nu, 'tɩ‑ 'yu a 'mʋ, 'a 'kʋɛ 'ɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nyibli a pɛpɛ ‑mʋ', ‑ʋ nɩ la 'ʋ ‑tɩtɛ a 'mʋ, ɛ kɛɛ la 'waa ꞊wlɩ lɛ, 'kɩ 'ʋ Nyɩsʋa a 'klɩ a kɩnɩnɩɩ a ‑ta'. ‑Tɛblɩ ‑mʋ', ‑Yusu ‑nu, ɛ 'tɩɛ kɛɛ nyibli a ꞊wlɩ lɛ. ‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'a ‑nagbopʋ* yɩ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Ba pʋ 'mʋ nʋa yɩ bʋ ‑tɛɛ, ‑tɩ ‑mʋ', 'n di 'a mʋ ‑lee ‑nɩ, a 'mʋ꞊ʋ kʋa 'ble ‑tɛɛ: 'Mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, ʋ kɔ bʋ pʋ 'mʋ nyibli ‑jɩ'.» ");
INSERT INTO ktj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","‑Tɩ a 'mʋ, ‑Yusu ‑hla, 'a ‑nagbopʋ 'yɩ꞊ɩ lɛ ‑yru. Kɛɛ, ʋ yɩ pie hʋannʋ, 'kɩ bʋ 'bɛti꞊e, dɛ‑ windɛ a 'mʋ, ɛ ꞊hɛn 'nyrɛ. ");
INSERT INTO ktj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu a ‑nagbopʋ* pɩpɩ꞊ɩ' lɛ, nyiblo a 'dɩ ‑bɩ ‑bʋ di 'ʋ 'a 'bɩ 'lu yɩ nɩ, 'kɩ 'lɩ ꞊nʋ 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Dɛ a 'mʋ, ʋ yɩ 'lu ‑mɔ lɛ ‑hie, ‑Yusu yi꞊e nɩ. Ɛ nɔ‑ mɔ bʋ da 'hɩangbe, bʋ ꞊tu꞊o 'ʋ 'a dɩɔnʋ 'hʋɩ bʋ, ");
INSERT INTO ktj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ɛ wɛn: «'A ‑nɛ nyiblo 'bʋ nɩ 'ʋ, ‑tɛ 'hɩangbe ‑bʋ ɛ nɩ 'mʋ, 'bʋ 'ble 'a nyɔ kʋa ‑tɛɛ, 'kɩ 'ʋ 'na 'nyrɛ a ‑ta', ‑ɛ ‑bɩ 'mɔ ɛ 'ble kʋa. Ɛ kɔ, nyiblo, ‑ɛ 'ble 'mʋ kʋa, ɛ 'ble Nyɩsʋa kʋa ‑wɛ, ‑ɛ lee 'nɛ‑ 'mʋ ‑tʋtʋ kɩ. Nyiblo ‑mʋ', ‑ɛ 'yɩ nyiblo ꞊dʋ 'pa‑, 'kɩ 'lɩ 'a mʋ 'nyɩ, sɛyɩ‑sɛyɩ, ɛ nɔ‑ mɔ nyiblo, ‑ɛ nɩ 'ʋ 'a 'bio 'lu yɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","‑Ɛ ‑bɩ Saan, ‑ɛ mɔ ‑Yusu a ‑nagbopi* ‑bɩ, ɛ wɛn: «Tɔɔnyɔ o, ‑a 'ye nyiblo ꞊dʋ, 'ɛ blɛ 'kuo ‑hʋɩn* lɛ, 'kɩ 'lɩ ‑na 'nyrɛ 'kwli. ‑A mʋ ‑mɔ ‑bɩ, ‑a lee ꞊nɛ nɩ, ‑ɛ mɔ, bʋ 'kee nɛ 'a nunuo, ‑ɛ nu꞊o, ɛ 'nɩ ‑kʋɛ꞊ɛ mɔ ‑a mʋ ꞊wien lɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","‑Ɛ ‑bɩ ‑Yusu wɛn: «A 'nɩ 'lee 'lɩ꞊ɩ, ‑ɛ mɔ, bʋ 'kee nɛ 'a nunuo, ‑ɛ nu꞊o, nyiblo 'bʋ nɩ 'ʋ, 'bʋ 'yɛ nɩ ‑wɔn 'a mʋ yɩ, ɛ kɔ 'a mʋ 'hʋɛn‑, 'a mʋ ‑pɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ti ‑mʋ' ‑kɔ 'yri Nyɩsʋa di꞊e nu, ‑Yusu 'mʋ 'lɩ yakɔ 'kwli mu, ti a 'mʋ, ɛ 'mʋɛ yrɛ. Ɛ nɔ‑ kɔ ‑tɩ 'ɛ ‑yra꞊a, 'kɩ bʋ mu 'lɩ Jrusrɛdɩɔ 'kwli, ");
INSERT INTO ktj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","'ɛ lee nyibli, bʋ 'nyɛɛ 'hru, nyibli a 'mʋ 'ʋ ‑mu, 'ʋ nyre 'lɩ Samaliblʋgba a 'dɩɔ ‑bɩ 'kwli, ‑ɛ di꞊e nu, ʋ 'mʋ 'kayu lɛ ꞊mʋɔ, ‑ɛ kɔ bʋ ‑Yusu di 'lɩ pa. ");
INSERT INTO ktj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kɛɛ, 'dɩɔ a 'mʋ, 'a nyibli hɩa nɩ, 'kɩ bʋ 'ble ‑Yusu kʋa, ‑ɛ nu꞊o, ɛ mi 'lɩ Jrusrɛdɩɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","‑Tɛ ‑Yusu a ‑nagbopʋ* Sakɩ kɔ Saan 'hʋɛn‑, ʋ 'wɩn, ‑ɛ ‑bɩ ʋ wɛn: «Kʋkɔnyɔ, ꞊bɩ ‑hʋɛ꞊ɛ nɩ, 'kɩ ‑ba nu꞊o, ‑tɛyɛ bʋ ‑hɔn 'lɩ yakɔ 'kwli, bʋ ꞊tɩ, ɛ 'mʋ nyibli ‑bʋ bʋ ‑wɛ?» ");
INSERT INTO ktj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","‑Ɛ ‑bɩ ‑Yusu ꞊hɩan ‑mɔ, 'ɛ 'plɛ ꞊nʋ ‑mɔ, 'kɩ 'ʋ ‑tɩ a 'mʋ, ʋ ‑hla a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ʋ mu 'lɩ 'dɩɔ ‑bɩ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","‑Tɛ ʋ nɩ 'hru wlɔn, ‑ɛ ‑bɩ nyiblo ꞊dʋ lee ‑Yusu nɩ, ɛ wɛn: «'A ‑nɛ ‑tɩtɛ, ‑di 'ʋ mu, 'n di kʋɛ ‑mʋ ꞊wien.» ");
INSERT INTO ktj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","‑Ɛ ‑bɩ ‑Yusu ꞊tu꞊o ‑wɔn, ɛ wɛn: «'Wan 'kwli a mamʋɩ kɔ bʋpɛɛlɛ, nʋblɩ 'ʋ kɔ 'lʋɛ, kɛɛ, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n 'yɩ bʋpɛɛlɛ ꞊dʋ ‑kɔ, ‑tɛ 'n di 'ʋ ke lɛ ‑haa ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ nyiblo ‑bɩ yɩ, ɛ wɛn: «Kʋɛ 'mʋ ꞊wien, ꞊mʋ 'na ‑nagbopi* ‑hɛ.» ‑Ɛ ‑bɩ nyiblo a 'mʋ, ɛ ꞊tu꞊o ‑wɔn, ɛ wɛn: «Tɔɔnyɔ o, 'tɩ‑ 'mʋ ‑mʋ ꞊wien kʋɛ, ‑ha 'mʋ mɛ lɛ, ꞊bʋ mu, ꞊bʋ ‑ha 'ʋ 'na 'baɩ, ‑ɛ 'kʋ, 'tɩ‑ 'mʋ di, 'mʋ ‑mʋ ꞊wien kʋɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","‑Ɛ ‑bɩ ‑Yusu wɛn: «Ɛ 'yɩ ‑na ‑kʋan 'pa‑, 'kɩ ‑bʋ ‑ha 'ʋ 'kʋkʋkui lɛ. Kɛɛ, mu ‑bʋ lee nyibli, ‑ɛ mɔ, Nyɩsʋa ‑hʋɛ bʋ kɔɔ ꞊nʋ win kɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nyiblo ‑bɩ nɩ 'ʋ, ɛ wɛn: «Tɔɔnyɔ o, 'n di kʋɛ ‑mʋ ꞊wien, 'mʋ ‑na ‑nagbopi ‑hɛ. Kɛɛ, ‑ha 'mʋ mɛ lɛ, ꞊bʋ ti 'na 'dʋkʋɛ, 'tɩ‑ 'mʋ 'lɩ di, 'mʋ ‑mʋ ꞊wien kʋɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Kɛ‑ ‑Yusu pɩ, 'ɛ yɩ꞊ɩ ‑lee ‑nɩ: «꞊Wɩ nyiblo ‑mʋ' yɩ, ‑ɛ klɔ ‑ci, 'tɩ‑ ‑ɛ 'kee nɛ 'a ‑cicie. Nyiblo 'bʋ yɩ ‑kʋan a nunuo lɛ nɩ ni, ‑ɛ ‑bɩ Nyɩsʋa 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nu꞊o 'a ‑kʋannunyɔ ‑mɔ'.» ");
INSERT INTO ktj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ Kʋkɔnyɔ ‑Yusu ‑ha 'lɩ nyibli a ‑wlɩ nɩ ta ꞊tu 'ʋ ‑pu ꞊tu 'ʋ 'hʋɛn ‑bɩ, 'ɛ nu 'waa 'hʋnhʋɛn.yo, 'ɛ lee ꞊nʋ, 'kɩ bʋ 'nyɛɛ 'hru, bʋ mu 'lɩ 'dɩɩ a pɛpɛ ‑mʋ', ‑ɛ kɔ 'kwli 'a ꞊gbɛtʋ, ɛ di 'lɩ mu. ");
INSERT INTO ktj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kɛ‑ ɛ pɩ, 'ɛ yɩ ꞊nʋ ‑lee ‑nɩ, ɛ wɛn: «‑Kʋbʋ, ‑ɛ ꞊hlu, ɛ ‑hʋ nɩ, kɛɛ, 'a 'cɩcɛnyibli 'yɩ ‑hʋ. 'A ‑tɩ, ba nyaa ‑cikɔnyɔ lɛ, bʋ lee nɛ 'a ‑kʋannunyibli ‑bɩ, bʋ bi 'a mʋ kɩ, a 'mʋ ‑kʋbʋ 'cɛ. (Ɛ ꞊hɛn 'nyrɛ, ‑ɛ mɔ, ba nyaa Nyɩsʋa lɛ, ɛ 'mʋ 'a nyibli ‑bɩ ‑lee ‑nɩ, 'kɩ bʋ ‑hɛɛ nɛ 'a mʋ, a 'mʋ nyibli ‑bɩ lɛ 'kukue ‑nɩ, ʋ 'mʋ 'waa 'klɔ Nyɩsʋa ‑nyi.) ");
INSERT INTO ktj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ba mu. 'N yɩ tɛ 'a mʋ bʋ, ꞊wɩ yɩ 'blayonʋ, ʋ yɩ bʋ tɛ, 'kɩ 'lɩ ‑jio 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","'Ba yɩ nɩ mi, a 'nɩ 'gbaa 'lɩ 'wliyɛ, a 'nɩ 'gbaa 'lɩ blɔ ‑wɛ, kɔ 'suin 'hʋɛn‑, kɔ, a 'nɩ 'wlɛɛn 'lɩ 'hru wlɔn, nyibli a 'wiolɛ‑nyi‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","'A ‑nɛ 'kayu, a di 'lɩ bʋ pa, yɩ‑hɛdɛ, a di nu, kɛ‑ ba pʋ: Nyɩsʋa bʋ nɩ 'ʋ 'a mʋ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nyiblo 'bʋ nɩ 'lɩ 'kayu a 'mʋ bʋ, 'bʋ ‑hʋɛ꞊ɛ, 'kɩ Nyɩsʋa bʋ nɩ 'ʋ꞊ʋ ‑mɔ, bʋ nu꞊o ꞊haandɛ ‑mɔ, ‑ɛ ‑bɩ Nyɩsʋa kɔ bʋ nɩ 'ʋ꞊ʋ ‑mɔ. Kɛɛ, 'bʋ 'yɛ nɩ ‑hʋa꞊a, ‑ɛ ‑bɩ Nyɩsʋa 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nɩ 'ʋ꞊ʋ ‑mɔ, kɔ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nu꞊o ꞊haandɛ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","'Kayu ‑mʋ', ‑ɛ kɔ bʋ ʋ di 'lɩ 'a mʋ kʋa 'blee ‑nɩ, 'kɩ ba nɩ 'lɩ bʋ. A 'nɩ 'naa 'lɩ 'kayo blɛ. Dididɛ ‑mʋ', ʋ di 'a mʋ ‑nyi, ɛ nɔ‑ ba di, 'nie, ʋ di 'a mʋ ‑nyi, ɛ nɔ‑ ba 'na, ‑ɛ nu꞊o, nyiblo ‑bʋ, ‑ɛ ni ‑kʋan, ɛ blɛɛ 'pɛɛlɛ yɩ. ");
INSERT INTO ktj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","'A ‑nɛ 'dɩɔ ꞊dʋ, a di 'lɩ 'kwli pa, 'bʋ 'ble 'a mʋ kʋa, dididɛ ‑mʋ', ʋ di 'a mʋ ‑nyi, ba di꞊e, ");
INSERT INTO ktj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ɛ kɔ, ba da Nyɩsʋa, ‑ɛ di꞊e nu, ɛ 'mʋ꞊ʋ nu, 'dɩɔ a 'mʋ, 'a nyibli a 'kʋɛ 'mʋ ‑wɛ, ɛ kɔ, ba lee ꞊nʋ, ‑ɛ mɔ: Ti ‑mʋ' ‑kɔ 'yri Nyɩsʋa di 'ʋ 'a mʋ win kɩ ‑kɔɔ ‑nɩ, ɛ 'mʋɛ yrɛ. ");
INSERT INTO ktj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","'Dɩɔ ‑kɔ 'kwli a di 'lɩ pa, 'kɩ ʋ 'yɛ nɩ di 'a mʋ kʋa nɩ 'ble, ba mu 'lɩ 'dɩɔ a 'mʋ, 'a 'dika. Kɛ‑ ba pʋ: ");
INSERT INTO ktj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","'Aan 'dɩɔ a 'pupu ‑bʋ, ‑ɛ nɩ ‑a mʋ bʋɩ lɛ a ‑tɩ, ‑a di ‑aan bʋɩ 'nɩ ‑bʋbla ‑nɩ, ‑a 'mʋ 'a mɔ꞊ɔ yɩ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, Nyɩsʋa a yrʋ 'bʋ klɔ 'a mʋ, 'a mʋ nu꞊o 'aan dɩɔnʋ ‑mɔ. Kɛɛ, ba kɔ 'a yiyie, ‑ɛ mɔ: Ti ‑mʋ' ‑kɔ 'yri Nyɩsʋa di nyibli win kɩ ‑kɔɔ ‑nɩ, ɛ 'mʋɛ yrɛ. ");
INSERT INTO ktj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑nyrɔwɔ ‑mʋ', ‑ɛ kɔ 'kwli Nyɩsʋa di 'ʋ nyibli ‑bati lɛ ‑pʋʋ ‑nɩ, ɛ di ꞊tu 'dɩɔ a 'mʋ 'a nyibli ꞊hɩʋɛn, ɛ 'mʋ 'ʋ Sodɔmʋkʋɛ 'ʋ ‑hi, ‑ʋ kɔ nunuklɔ ‑nyre la yɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","(Kɛ‑ ‑Yusu pɩ 'a ‑nagbopʋ* yɩ, ɛ wɛn:) «‑Juukʋɛ* ‑mʋ', ‑ʋ nɩ 'lɩ Kolasɛdɩɔ, kɔ Bɛtɩsaidadɩɔ 'kwli, 'jrɔ 'kɩ 'ʋ ꞊nʋ ‑mɔ, ‑ɛ nu꞊o, ꞊wlɩlɛkɛɛ‑tɛblɩ ‑mʋ', 'n nuu 'lɩ ꞊nʋ ‑mɔ, 'bʋ mɔ, 'nɩ nuu wɛn 'lɩ꞊ɩ nyibli ‑mʋ', ‑ʋ 'yɩ ‑Juukʋɛ 'pa‑ ‑mɔ, ‑ʋ nɩ 'lɩ Tilɩdɩɔ kɔ Sidɔdɩɔ 'hʋɛn‑ 'kwli, see la, nyibli a 'mʋ, ʋ 'mʋ la nyaɩŋmlɩ lɛ nu, ʋ 'mʋ la ‑tɛblɩ ‑hʋɩn 'hʋɩ lɛ pʋ, ʋ 'mʋ la 'waa dɩɔnʋ 'tɔpupu 'ŋmlɛ, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ nyibli yɩ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, ʋ ‑hʋɛ bʋ hie 'ʋ dɛ 'kuku a nunuo bʋ, ʋ 'mʋ 'waa 'klɔ Nyɩsʋa ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","'Ɛ mɔ ꞊han‑tɩ, ‑nyrɔwɔ ‑mʋ', ‑ɛ kɔ 'kwli Nyɩsʋa di 'ʋ nyibli ‑bati lɛ ‑pʋʋ ‑nɩ, nyibli ‑mʋ', ‑ʋ nɩ 'lɩ Kolasɛdɩɔ kɔ Bɛtɩsaidadɩɔ a 'mʋ 'kwli, 'waa ‑bati di nɩ 'klɩ kɩ, ɛ 'mʋ 'ʋ Tilɩdɩɔ kɔ Sidɔdɩɔ a ‑nɛ 'ʋ ‑hi. ");
INSERT INTO ktj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","'Tɩ‑ nyibli ‑mʋ', ‑ʋ nɩ 'lɩ Kapɛnaɔdɩɔ 'kwli, ʋ 'nɩ 'hie 'lɩ꞊ɩ 'lu ‑mɔ lɛ, ‑ɛ mɔ, Nyɩsʋa di 'lɩ ꞊nʋ 'nɩ 'yaa ‑nɩ ‑yaya, ʋ 'mʋ mu ‑mumu, ʋ 'mʋ yakɔ yɩ kʋɛ. Kɛɛ, ɛ di 'lɩ ꞊nʋ 'nɩ ꞊tɩɔ ‑nɩ ‑tɩɔtɩɔ, ʋ 'mʋ 'lɩ ‑tʋtʋ bʋ nyre.» ");
INSERT INTO ktj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kɛ‑ ɛ pɩ 'a ‑nagbopʋ yɩ, ɛ wɛn: «Nyiblo 'bʋ yɩ 'a mʋ nʋa yɩ bʋ nɩ pɩ, ‑ɛ ‑bɩ ɛ ꞊hɛn 'nyrɛ 'mɔ ɛ pɩ nʋa yɩ bʋ, ɛ kɔ, nyiblo 'bʋ hɩa nɛ 'a mʋ yɩ, ɛ ꞊hɛn 'nyrɛ, 'mɔ ɛ hɩa yɩ, kɔ, nyiblo 'bʋ hɩa 'mʋ yɩ, ɛ 'wɩ yɩ, Nyɩsʋa, ‑ɛ lee 'nɛ‑ 'mʋ ‑tʋtʋ kɩ, ɛ nɔ‑ ɛ hɩa yɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","‑Tɛ ti gbi ‑hi, ‑ɛ ‑bɩ ‑nagbopʋ a (72) ‑wlɩ nɩ ta ꞊tu 'ʋ ‑pu ꞊tu 'ʋ 'hʋɛn, ‑Yusu lee la, 'kɩ bʋ mu la Nyɩsʋa a ꞊haantitie pʋ, ‑tɛ ʋ ꞊hɩan ‑mɔ, ‑ɛ ‑bɩ dɔdʋ ni ꞊nʋ nɩ dɩakɩ, ʋ wɛn: «Kʋkɔnyɔ o, 'ye kɛ, 'bʋ mɔ, ꞊ba yɩ ‑na 'nyrɛ nɩ ni, ꞊ba yɩ 'lɩ 'kuo ‑hʋɩn* ‑mɔ nɩ ‑hlee ‑nɩ, 'ʋ ꞊tui 'ʋ ‑aan win nɩ, 'ʋ ‑hʋɛn 'ʋ nyibli ke' lɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","‑Ɛ ‑bɩ ‑Yusu wɛn: «‑Tɛ 'n ta 'lɩ yakɔ 'kwli lɛ, ‑ɛ ‑bɩ 'n 'ye Satan nɩ, ‑ɛ mɔ 'kuo ‑hʋɩn a nyiblo gbagbʋ, 'ɛ ble 'lɩ yakɔ 'kwli, ꞊wɩ yɩ ‑tɛ bʋ 'yɛ nɩ ꞊tɩ wɛn. ");
INSERT INTO ktj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ba 'ye kɛ, 'n ‑nyi 'a mʋ 'klɩ, 'kɩ ba na hro kɔ ‑ji‑kayɩ 'hʋɛn‑ klɛ, ɛ kɔ, ba ‑wɛ Nyɩsʋa a yraanyɔ Satan a 'klɩ bʋ. ꞊Dedede 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ nu 'a mʋ dɛ ‑hʋan ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kɛɛ, a 'nɩ 'nuo 'lɩ dɔdʋ, ‑tɛ 'kuo ‑hʋɩn ꞊tui 'ʋ 'a mʋ 'ʋ a ‑tɩ. Kɛɛ, dɛ ‑kɔ dɔdʋ ba nu, ɛ nɔ‑ mɔ ‑tɛ Nyɩsʋa ‑nu, 'ɛ 'crɩ 'aan 'nyrɛ, 'kɩ 'lɩ yakɔ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ti nɩ ‑do a 'mʋ 'yri, ‑ɛ ‑bɩ Nyɩsʋa a ‑Hihiu* nu꞊o nɩ, dɔdʋ 'ɛ ‑hi ‑Yusu wlɔn dɩakɩ. Kɛ‑ ɛ pɩ Nyɩsʋa yɩ, ɛ wɛn: «'Na 'Baɩ o, ‑mɔ mɔ yakɔ kɔ ‑tʋtʋ 'hʋɛn‑ a Kʋkɔnyɔ. 'N pɩ ‑mʋ 'nyrɛ lɛ, ‑tɛ ‑nu, ꞊nɩ ‑hli ‑na nunu‑tɛblɩ ꞊tɔkɔnyʋ, kɔ 'crɩɛn.yinyʋ 'yi kɩ, 'tɩ‑ ꞊nɩ tɔɔ ꞊nʋ nyibli ‑bʋ, ‑ʋ 'yɩ ꞊dedede ‑yi. 'N pɩ ‑mʋ 'nyrɛ lɛ, ‑ɛ nu꞊o, kɛ‑ ‑nu 'a ‑hʋhʋa. ");
INSERT INTO ktj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","'Na 'Baɩ, ‑nyi 'mʋ 'klɩ, 'kɩ 'ʋ ‑tɛblɩ a pɛpɛ kɩ. Nyiblo a 'dɩ ‑bɩ 'n pa 'mʋ, nyibli 'yɩ꞊ɩ ‑yi, 'bʋ 'yɩ 'na 'Baɩ nɩ ‑do 'pa‑. Ʋ 'yɩ꞊ɩ ‑yi ‑wɛ, nyiblo 'na 'Baɩ pa 'mʋ, 'bʋ 'yɩ 'mɔ nɩ ‑do ‑bʋ 'pa‑, ‑ɛ mɔ 'a 'Yu. 'A ‑nɛ nyiblo, 'n di ‑hʋa ꞊bʋ tɔɔ ꞊nɛ, ɛ yi꞊e nɩ ‑wɛ, nyiblo a 'dɩ ‑bɩ 'na 'Baɩ pa 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","‑Tɛ ‑Yusu kɔ 'a ‑nagbopʋ nɩ ‑do 'hʋɛn‑, ʋ nɩ bʋ, ‑ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «'A mʋ ‑mʋ', ‑ʋ yɩ ‑tɛblɩ a pɛpɛ ‑bʋ 'ye, ba kɔ plɔ a bleelɛ. ");
INSERT INTO ktj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ti ‑hi la a ti 'yri a Nyɩsʋa a winwlɔn‑hanyʋ* kɔ bodɩɔpʋ ‑hʋɔhʋɩ 'hʋɛn‑, ʋ ꞊mʋɛ la꞊a lɛ, 'kɩ bʋ 'ye la ‑tɛblɩ gbagbɩ ‑bʋ, a yɩ kɛ 'ye, kɛɛ, ʋ 'yɩ꞊ɩ 'ye, kɔ, 'ʋ ꞊mʋɛ la꞊a lɛ, 'kɩ bʋ 'wɩn la ‑tɛblɩ gbagbɩ ‑bʋ, a yɩ kɛ 'wɩn, kɛɛ, ʋ 'yɩ꞊ɩ 'wɩn.» ");
INSERT INTO ktj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","‑Yusu bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ Nyɩsʋa a tetetɔɔnyɔ ‑bɩ, ‑ɛ nɩ 'ʋ, ɛ 'du ye', 'ɛ mu 'ʋ ‑Yusu lɛ ꞊tɛɛ mɔ, ‑ɛ di꞊e nu, ɛ 'mʋ꞊ʋ 'ye, 'bʋ mɔ, 'bʋ di ‑tɩ ꞊dʋ hla, ‑ɛ 'yɩ 'ʋ yɩ 'sii ‑nɩ. Ɛ nɔ‑ mɔ bʋ 'bɛti꞊e, ɛ wɛn: «Tɔɔnyɔ o, dɛ a 'dɩ ‑bɩ 'n kɔ ꞊bʋ nu, 'tɩ‑ 'mʋ Nyɩsʋa a 'klɔ yrayrʋ ‑mʋ' kɔ, ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","‑Ɛ ‑bɩ ‑Yusu wɛn: «Dɛ a 'dɩ ‑bɩ ʋ 'crɩɩ 'lɩ Nyɩsʋa a tetecrɩɛn 'kwli? Dɛ a 'mʋ, ʋ 'crɩ, ꞊nɩ yɩ꞊ɩ nɩ ‑hre, ‑bɩ' ‑ni 'a 'wɩnwɩɩn 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","‑Ɛ ‑bɩ ɛ wɛn: «‑Blɛɛ yɩ, ‑bʋ nʋɛ ‑na Kʋkɔnyɔ Nyɩsʋa, 'kɩ 'lɩ ‑na ꞊wlʋ a pɛpɛ kɩ, ɛ kɔ, 'kɩ 'lɩ ‑na 'lulɛ‑hihie a pɛpɛ 'kwli, kɔ, 'kɩ 'lɩ ‑na 'klɩ a pɛpɛ 'kwli, ɛ kɔ, ‑blɛɛ yɩ, ‑bʋ nʋɛ ‑na 'bɩhɩan ‑tonyiblo, ꞊wɩ yɩ, ‑tɛ ‑nu ‑dɩɔnʋ a nʋɛlɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","‑Ɛ ‑bɩ ‑Yusu wɛn 'nɩ: «'A ‑tɛɛ, nɔ‑ ꞊nɩɔ. 'A ‑tɩ o, dɛ a 'mʋ, ɛ nɔ‑ ‑bʋ nu, ꞊mʋ 'klɔ yrayrʋ a 'mʋ kɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kɛɛ, tetetɔɔnyɔ a 'mʋ, ɛ ‑hʋɛ bʋ ‑nyi 'a dɩɔnʋ ꞊wɔn. Nɔ‑ kɔ ‑tɩ 'ɛ 'bɛti ‑Yusu, ɛ wɛn: «Nyiblo a 'dɩ ‑bɩ ‑mɔ 'kɩ 'na 'bɩ ‑tonyiblo 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","‑Ɛ ‑bɩ ‑Yusu wɛn: «Ɛ kɔ la nyɩbɛyu ꞊dʋ. Ɛ nɔ‑ ‑hɔn 'lɩ Jrusrɛdɩɔ 'kwli, 'ɛ mi 'lɩ Selikodɩɔ 'kwli. ‑Tɛ ɛ mu ‑mumu, ‑ɛ ‑bɩ, ɛ bi 'lɩ ‑balʋnyibli 'nyɩ, 'ʋ ‑hɛ꞊ɛ wlawlɩ, ‑ɛ di꞊e nu, ʋ 'mʋ 'a ‑tɛblɩ 'yri, 'ʋ bi꞊e ‑bibi, 'ʋ dʋa꞊a 'lɩla, 'tɩ‑ 'ʋ hie 'ʋ꞊ʋ bʋ, 'ʋ ‑mu. ");
INSERT INTO ktj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Bʋ pɛ 'kɩ 'ʋ bʋ, ‑ɛ ‑bɩ Nyɩsʋa a ‑cɔhlʋnpinyɔ* ꞊dʋ yɩ 'lɩ 'nɩ di. ‑Tɛ ‑cɔhlʋnpinyɔ a 'mʋ, ɛ 'ye꞊e, ɛ nɔ‑ mɔ bʋ 'bɛɛ kɩ, bʋ na 'lɩ 'hru a 'kɩbɩa ‑bɩ kɩ, bʋ ‑hi. ");
INSERT INTO ktj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","‑Tɛ ɛ ‑hi, ‑ɛ ‑bɩ Lefipi ꞊dʋ, ‑ɛ mɔ Nyɩsʋa a ‑cɔhlʋnpinyɔ a ‑kʋannunyɔ ꞊dʋ, ɛ nɔ‑ nyre 'ʋ ‑tɩtɛ a 'mʋ. ‑Tɛ ɛ nyre 'kɩ 'ʋ, ɛ 'ye꞊e, ‑ɛ ‑bɩ 'kɩ ɛ na 'lɩ 'hru a 'kɩbɩa ‑bɩ kɩ, 'ɛ ‑hi. ");
INSERT INTO ktj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","‑Tɛ ɛ ‑hi 'kɩ, ‑ɛ ‑bɩ Samalikʋɛyu ꞊dʋ, ‑ɛ mɔ hɩapʋdakɔ ‑bɩ a nyiblo, nɔ‑ yɩ 'lɩ di, ('ɛ nɩ 'ʋ 'kasra kɩ. Samalikʋɛ kɔ ‑Juukʋɛ* 'hʋɛn‑, ʋ nyinyre lɛ.) ‑Tɛ Samalikʋɛyu a 'mʋ, ɛ nyre 'ʋ nyiblo a 'mʋ 'hʋɩ, ɛ 'ye꞊e, ‑ɛ ‑bɩ 'a nyaɩ ‑tʋa 'a nunuo dɩakɩ, ");
INSERT INTO ktj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","'ɛ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ ‑tɛɛ, 'ɛ nu 'nyra kɔ ‑wiin, 'ɛ nu 'a ꞊ji a ‑kʋan, 'tɩ‑ 'ɛ mʋa ꞊nɛ lɛ. ‑Tɛ ɛ ‑wɛ 'a ꞊ji a ‑kʋan a nunuo ‑mɔ, ‑ɛ ‑bɩ ɛ 'yaa 'ʋ꞊ʋ 'a 'kasra kɩ, 'ʋ mu 'lɩ Selikodɩɔ 'kwli, 'kɩ 'lɩ 'dagbɩ a 'kayu ‑bɩ bʋ, 'ɛ pʋ 'a ꞊tɔ. ");
INSERT INTO ktj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","‑Tɛ ‑nyrɛ ‑nyɛ, ‑ɛ ‑bɩ ɛ ‑ha 'lɩ 'wliyɛ, 'ɛ ‑nyi꞊e 'kayukɔnyɔ, ɛ wɛn: ꞊Tu 'na nyiblo ‑bʋ 'yie ‑tɛɛ. Ti ‑kɔ 'yri 'n di ‑mɔ ꞊hɩan, 'n di 'ʋ ‑dii ‑nɩ, 'bʋ mɔ, dɛ 'bʋ bi 'ʋ 'wliyɛ ‑bʋ 'lu, 'n di ‑mɔ꞊ɔ 'nɩ 'pɛɛ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","'Tɩ‑ ‑Yusu 'mʋ ‑yrɛ, kɛ‑ ɛ pɩ tetetɔɔnyɔ a 'mʋ yɩ, 'ɛ yɩ꞊ɩ 'bɛti ‑nɩ, ɛ wɛn: «'Kɩ 'lɩ ‑mʋ 'yi, 'kɩ 'lɩ nyibli nɩ ta a 'mʋ 'nyɩ, nyiblo a 'dɩ ‑bɩ ‑ɛ nu dɛ, ‑ɛ tʋɛ ꞊nɛ yɩ, ‑ɛ mɔ, ɛ nɔ‑ mɔ nyiblo ‑mʋ', ‑balʋnyibli ‑bi a 'bɩhɩan 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","‑Ɛ ‑bɩ tetetɔɔnyɔ a 'mʋ, ɛ wɛn: «Nyiblo ‑mʋ', ‑ɛ nu꞊o ꞊haandɛ 'yi ꞊hlɔn lɛ, ɛ nɔ‑ ꞊nɩɔ.» ‑Ɛ ‑bɩ ‑Yusu wɛn: «‑Na 'mumu, ꞊nɩ ‑mu, dɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ ‑bʋ nu.» ");
INSERT INTO ktj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ bi 'hru wlɔn de, 'ʋ pa 'lɩ 'dɩɔ ‑bɩ 'kwli. 'Kɩ 'lɩ 'dɩɔ a 'mʋ 'kwli, 'kɩ nʋgba ꞊dʋ nɩ 'lɩ. 'A 'nyrɛ mɔ Matɩ. Ɛ nɔ‑ 'ble ‑Yusu kʋa, 'kɩ 'lɩ 'a 'kayu bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Matɩ a 'mʋ, ɛ kɔ 'dɩayɩ nyrɔyu ꞊dʋ. 'A 'nyrɛ mɔ Mari. ‑Tɛ ‑Yusu nɩ bʋ, ɛ ‑tʋa 'waa tɔɔlɛ, Mari a 'mʋ 'ɛ nɩ 'ʋ꞊ʋ 'hʋɩ bʋ, ‑ɛ di꞊e nu, ɛ 'mʋ 'a tɔɔwin nʋa yɩ bʋ pʋ. ");
INSERT INTO ktj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Matɩ ‑mɔ ‑bɩ, 'kayu a ‑kʋan a gblegble ‑mʋ', ɛ nɔ‑ kɔ ‑tɩ ꞊yɛɛ ꞊nɛ 'kla ‑wliye. Ɛ nɔ‑ mɔ bʋ 'yɩya 'ʋ ‑Yusu 'hʋɩ bʋ, bʋ lee ꞊nɛ, ‑ɛ mɔ: «Kʋkɔnyɔ o, ꞊bɩ ɛ 'nɩ 'yaa lɩ ‑mʋ 'kla ‑wliye, 'kɩ 'na 'dɩayɩ nyrɔyu bʋ ‑ha 'mɔ nɩ ‑do mɛ lɛ, ꞊bʋ nu ‑kʋan a pɛpɛ? 'A ‑tɩ, lee ꞊nɛ bʋ ‑hɛɛ 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","‑Ɛ ‑bɩ Kʋkɔnyɔ ꞊tu꞊o ‑wɔn, ɛ wɛn: «Matɩ o, ꞊yɛɛ ‑dɩɔnʋ 'kla ‑wliye, ɛ kɔ, ꞊nɩ nɛɛ ꞊wlɩ lɛ dɩakɩ, 'kɩ 'ʋ ‑tɛblɩ ‑hʋɔhʋɩ kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kɛɛ, ɛ kɔ dɛ nɩ ‑do, ‑ɛ mɔ yɩnɔdɛ. Dɛ a 'mʋ, ɛ nɔ‑ Mari ‑ha 'lɩ. 'Tɩ‑ nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑ha ꞊nɛ꞊ɛ ‑jɩ'.» ");
INSERT INTO ktj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","‑Nyrɔwɔ ꞊dʋ 'kwli, 'kɩ ‑Yusu mu 'lɩ ‑tɩtɛ ‑bɩ, 'ɛ mu Nyɩsʋa da mɔ. ‑Tɛ ɛ ‑wɛ ‑mɔ, ‑ɛ ‑bɩ 'a ‑nagbopi ‑bɩ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, ɛ wɛn: «Tɔɔnyɔ o, Saan Batisɩ tɔɔ nɛ 'a ‑nagbopʋ nɩ, ‑tɛ ʋ di Nyɩsʋa a dɩda nu. ‑Na 'mumu, tɔɔ nɛ ‑a mʋ ‑tɛ ‑bʋ, ‑a di Nyɩsʋa a dɩda nu.» ");
INSERT INTO ktj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «'Bʋ mɔ, 'ba yɩ Nyɩsʋa nɩ dɛ, kɛ‑ ba pʋ: ‑Aan 'Baɩ, nu꞊o, nyibli a pɛpɛ bʋ yi꞊e, ‑ɛ mɔ, ‑mɔ mɔ Nyɩsʋa. ‑Mɔ ‑bʋ kɔɔ nyibli win kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","‑Nyi ‑a mʋ 'a ‑nɛ ‑nyrɔwɔ a diidɛ. ");
INSERT INTO ktj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","‑Aan dɛ 'kuku ‑bʋ, ‑a ‑nu, ‑hru 'a ‑tɩ ‑mɔ, ‑kɔtɩ dɛ 'kuku ‑mʋ', nyibli ni ‑a mʋ ‑mɔ, ‑a ‑hrui 'a ‑tɩ ‑mɔ ‑wɛ. ꞊Nɩ 'hɔɔn 'ʋ 'kuo ‑hʋɩn* a nyiblo gbagbʋ ‑mɔ', ɛ 'nɩ 'tɛɛ 'ʋ ‑a mʋ lɛ, ‑ɛ di꞊e nu, ‑a 'nɩ ꞊ha ‑tɩ 'wla.» ");
INSERT INTO ktj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ de, ɛ wɛn: «꞊Bʋ pʋ꞊ʋ nɩnatumupʋ nɩ 'hʋɛn a dɛ yɩ: 'Bʋ mɔ, ꞊nɩ kɔ nɩnatumu, ꞊nɩ mu 'lɩ꞊ɩ ‑mɔ 'tɔ‑hɛyri', ꞊nɩ lee ꞊nɛ, ‑ɛ mɔ: 'N kɔ 'dagbatayu, 'ɛ pa 'lɩ 'mʋ ‑mɔ. 'A ‑tɩ, 'n nyaa ‑mʋ lɛ, ‑nyi 'mʋ dididɛ. 'N 'yɩ dididɛ ‑kɔ, ꞊bʋ di꞊e ‑nyi 'tɔ ‑bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","‑Baklɛ, ‑na nɩnatumu 'a mʋ, ‑ɛ nɩ 'lɩ 'a 'kayu bʋ, kɛ‑ ɛ di ‑mʋ yɩ pʋ: ‑Hɛ 'mʋ 'ku. 'N ‑wɛ 'ʋ 'na 'maju a kɩka ‑mɔ. 'N kɔ 'na 'yonʋ 'hʋɛn‑, ‑a pɛ bʋ. 'N yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ 'du ye', ‑na dididɛ‑nyi‑tɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","‑Ɛ ‑bɩ ‑Yusu wɛn 'nɩ de, «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, 'bʋ mɔ, 'bʋ 'du ye', ɛ 'yɩ ‑tɛ ‑mɔ 'a nɩnatumu a ‑tɩ 'pa‑. Kɛɛ, ‑tɛ ꞊yɩ 'yie ‑pie, ꞊nɛɛ 'ʋ 'a ‑hʋhʋa yɩ bʋ, ɛ nɔ‑ kɔ ‑tɩ, 'ɛ 'mʋ ye' 'du, ɛ 'mʋ ‑mʋ ‑tɛblɩ a pɛpɛ ‑mʋ', ‑na ꞊wlʋ ‑hʋɛ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, 'bʋ mɔ, 'ba yɩ dɛ nɩ ‑hʋɛ, ba ‑hʋa꞊a Nyɩsʋa, ɛ 'mʋ 'a mɔ꞊ɔ ‑nyi. 'Ba yɩ dɛ nɩ ‑hʋɛ, ba ꞊mʋɔ꞊ɔ lɛ, a di꞊e 'nɩ 'ye. 'Ba yɩ꞊ɩ nɩ ‑hʋɛ, bʋ paa nɛ 'a mʋ 'kayu bʋ, ba bi gbɔgbɔ, ʋ 'mʋ 'a mʋ ‑lee ‑nɩ: Ba di pa. ");
INSERT INTO ktj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","'Ɛ mɔ ꞊han‑tɩ, 'a ‑nɛ nyiblo 'bʋ ‑hʋa Nyɩsʋa dɛ, ɛ di ꞊nɛ꞊ɛ 'nɩ ‑nyi. Nyiblo 'bʋ yɩ dɛ lɛ nɩ ꞊mʋɛ, ɛ di꞊e 'nɩ 'ye. Nyiblo 'bʋ nyra 'ʋ ꞊hʋan.yɩ' bʋ, 'bʋ bi gbɔgbɔ, ʋ di꞊e 'nɩ ‑lee ‑nɩ, bʋ pa. ");
INSERT INTO ktj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","‑Mɔ mɔ 'baɩ, ‑na 'yu 'bʋ yɩ ‑mʋ ‑hrin.yɛ nɩ ‑hʋɛ, ꞊bɩ ‑di ‑nyi꞊e hre, ");
INSERT INTO ktj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ɛ kɔ, 'bʋ mɔ, 'bʋ yɩ ‑mʋ hapɛ'yi‑ŋɔnʋ nɩ ‑hʋɛ, ꞊bɩ ‑di ‑nyi꞊e ‑ji‑kaya? ");
INSERT INTO ktj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","'Ɛ mɔ ꞊han‑tɩ, 'a mʋ ‑tonyibli, 'kɩ a 'yɩ ꞊haannyibli 'pa‑, kɛɛ, a yi ꞊haan‑tɛblɩ a lɛ'jralɛ, 'a yɩ꞊ɩ 'aan 'yonʋ ‑nyi. 'Bʋ mɔ, 'bʋ nɩ 'mʋ lɛ, 'kɩ 'ʋ 'a mʋ ‑mɔ, ‑ʋ kɔ ꞊wlɩ ‑nyre yɩ, ‑ɛ ‑bɩ 'aan 'Baɩ, ‑ɛ nɩ 'lɩ yakɔ 'kwli, ‑ɛ kɔ ꞊wlʋ ‑nɔ yɩ, nyibli 'bʋ ‑hʋa꞊a 'a ‑Hihiu*, ɛ di ꞊nʋ꞊ʋ 'nɩ ‑nyi.» ");
INSERT INTO ktj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","‑Nyrɔwɔ ꞊dʋ 'kwli, ‑Yusu bla la 'ku ‑hʋan lɛ, ‑ɛ nɩ la 'ʋ nyiblo ꞊dʋ ke'. 'Ku ‑hʋan a 'mʋ, ɛ nu꞊o nɩ, 'kɩ nyiblo a 'mʋ, 'ɛ 'yɩ win a pʋlɛ ‑yi. ‑Tɛ 'ku ‑hʋan a 'mʋ, ɛ ‑hɔn 'ʋ nyiblo a 'mʋ ke', ‑ɛ ‑bɩ ɛ ‑tʋa win a pʋpʋʋ. ‑Ɛ ‑bɩ nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, 'waa ꞊wlɩ kɛɛ lɛ dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kɛɛ, kɛ‑ ‑ʋ ‑bɩ pɩ, ʋ wɛn: «Bɛsebulɩ*, ‑ɛ mɔ 'kuo ‑hʋɩn a nyiblo gbagbʋ Satan, ɛ nɔ‑ yɩ ‑Yusu 'klɩ ‑nyi, 'kɩ bʋ bla 'kuo ‑hʋɩn, ‑ʋ nɩ 'ʋ nyibli ke' lɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nyibli ‑bɩ, ‑ʋ nɩ 'ʋ, ʋ ‑hʋɛ bʋ ꞊tɛɛ 'ʋ꞊ʋ lɛ, 'ʋ lee ꞊nɛ, 'kɩ bʋ nu ꞊wlɩlɛkɛɛ‑tɛblɩ, ɛ 'mʋ ꞊nʋ꞊ʋ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, Nyɩsʋa, ɛ nɔ‑ yɩ꞊ɩ 'klɩ ‑nyi, 'kɩ bʋ bla 'kuo ‑hʋɩn lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kɛɛ, ‑Yusu yi 'waa 'lulɛ‑hihie nɩ. Ɛ nɔ‑ nu꞊o, 'ɛ lee ꞊nʋ, ɛ wɛn: «꞊Bʋ pʋʋ ꞊nɛ dɛ yɩ: 'Kɩ 'lɩ 'blʋgba 'kwli, nyibli 'bʋ 'bɛ ꞊tɩɔ lɛ, 'blʋgba a 'mʋ, ɛ di bi ꞊hlɔn, 'waa 'kayo 'mʋ lɛ 'wʋwlɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","'A ‑tɩ, Satan 'bʋ yɩ 'a dɩɔnʋ yɩ nɩ ‑wɛn, ‑ɛ ‑bɩ 'a 'blʋgba di bi ꞊hlɔn. A wɛn 'nɩ, 'n blɛ 'kuo ‑hʋɩn lɛ, ‑ʋ nɩ 'ʋ nyibli ke', ‑ɛ nu꞊o, Bɛsebulɩ, ɛ nɔ‑ yɩ 'mʋ 'klɩ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","'Bʋ mɔ, ‑tɩ ‑bʋ, a hlɛ, 'bʋ mɔ wɛn ꞊haan‑tɩ, 'aan 'mumu, nyɔ‑ yɩ 'kɩ 'aan ‑nɛ nyibli 'klɩ ‑nyi, 'ʋ blɛ 'kuo ‑hʋɩn lɛ ‑wɛ 'lɩ? Dɛ ‑mʋ', 'aan nyibli ni, ɛ nɔ‑ tʋɛ ꞊nɛ yɩ, ‑ɛ mɔ, ‑tɩ ‑bʋ, a yɩ 'mʋ ‑yɛɛ ‑nɩ, ɛ mɔ hɩ ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ɛ 'yɩ Satan 'pa‑, kɛɛ, Nyɩsʋa a ꞊gbɛtʋ, ɛ nɔ‑ yɩ 'mʋ 'klɩ ‑nyi, 'kɩ ꞊bʋ bla 'kuo ‑hʋɩn ‑mʋ', ‑ʋ nɩ 'ʋ nyibli ke' lɛ. Dɛ a 'mʋ, ɛ tʋɛ nɛ 'a mɔ꞊ɔ nɩ, ‑ɛ mɔ, Nyɩsʋa ‑tʋa nyibli a win a kɩkɔɔlɛ, 'kɩ 'lɩ 'a mʋ 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","꞊Bʋ pʋ꞊ʋ dɛ yɩ: 'Bʋ mɔ, 'klɩnɩnyɔ 'bʋ kɔ ta‑wɔn‑tɛblɩ, 'kɩ lɩ 'a 'kayu bʋ, 'tɩ‑ 'bʋ yɩ 'a 'kayu a 'mʋ 'yie nɩ ꞊tui, ɛ 'yɩ nyiblo ꞊dʋ ‑kɔ, ‑bʋ pa 'lɩ 'kayu a 'mʋ bʋ, ‑bʋ 'yri 'a kʋkɔ‑tɛblɩ. ");
INSERT INTO ktj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kɛɛ, 'klɩnɩnyɔ ‑bɩ, ‑ɛ nɩ 'klɩ, ‑ɛ ‑hi 'ʋ yɩ‑hɛnyiblo 'mʋ 'ʋ, 'bʋ nyre 'ʋ, ɛ di ‑ha 'ʋ꞊ʋ 'hru wlɔn, ɛ 'mʋ꞊ʋ 'a ta‑wɔn‑tɛblɩ ‑jɩ' ‑ha, ɛ kuo ꞊wlʋ yɩ, ɛ 'mʋ 'a kʋkɔ‑tɛblɩ a pɛpɛ gba, ɛ 'mʋ꞊ʋ nyibli lɛ ꞊gla. ");
INSERT INTO ktj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nyiblo 'bʋ nɩ 'ʋ, ɛ kɔ 'mʋ 'hʋɛn‑, ꞊ba 'yɩ ‑pɛ, ɛ ꞊hɛn 'nyrɛ, ɛ ‑wɛn 'mʋ yɩ. 'Tɩ‑ nyiblo 'bʋ 'yɛ nɩ ‑hɛɛ 'mʋ, 'kɩ ‑ba 'kukue nyibli lɛ, 'kɩ 'ʋ Nyɩsʋa ‑mɔ', ɛ 'wɩ yɩ, nyiblo a 'mʋ, ɛ ‑gbɛ ꞊nʋ lɛ, 'ʋ hlʋɛ Nyɩsʋa ‑mɔ lɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kɛ‑ ‑Yusu pɩ de: «'Bʋ mɔ, 'ku ‑hʋan 'bʋ nɩ 'ʋ nyiblo ke', 'tɩ‑ 'bʋ ‑hɔn 'ʋ꞊ʋ ke', ‑ɛ ‑bɩ 'kɩ ɛ mi 'lɩ 'wan 'kwli, 'ɛ mi bʋnɩɩlɛ yrayrʋ lɛ ꞊mʋɔ mɔ. ‑Tɛ ɛ 'yɩ 'lɩ bʋnɩɩlɛ 'ye, ‑ɛ ‑bɩ kɛ‑ ɛ pɩ 'a dɩɔnʋ yɩ: 'N kɔ ꞊bʋ ‑mɛ kle, 'mʋ 'lɩ 'na bʋnɩɩlɛ 'ka, 'n ‑hɔn la 'lɩ 'kwli mu. ");
INSERT INTO ktj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","‑Tɛ ɛ ꞊hɩan ‑mɔ, ‑ɛ ‑bɩ ɛ 'ye꞊e nɩ, ‑ɛ mɔ, bʋnɩɩlɛ a 'mʋ, ɛ 'hrɛn klɛ ‑tɛɛ, 'ɛ ꞊hrɛntɩ ‑nɩ. (Ɛ 'wɩ yɩ, Nyɩsʋa a ‑Hihiu 'yɩ 'ʋ nyiblo a 'mʋ ke' ‑nɩ.) ");
INSERT INTO ktj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","'Bʋ nɩ 'mʋ lɛ, ‑ɛ ‑bɩ 'ku ‑hʋan a 'mʋ, ɛ kɔ bʋ bla 'kuo ‑hʋɩn nɩ ꞊hlon'hʋɛn ‑bɩ, ‑ʋ kɔ 'crɛ, ‑ʋ ‑hi 'ʋ 'a 'mumu 'ʋ, 'waa pɛpɛ a 'mʋ, ʋ 'mʋ ‑mɔ ‑bibi ‑nɩ, ʋ 'mʋ 'ʋ nyiblo a 'mʋ ke' bi. ‑Ɛ ‑bɩ nyiblo a 'mʋ, 'a 'klɔ di nyre yɩ pɛpɛ, ɛ 'mʋ 'ʋ 'a yɩ‑hɛklɔ 'ʋ ‑hi.» ");
INSERT INTO ktj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","‑Yusu bʋ nɩ 'lɩ win a pʋpʋʋ 'kwli, ‑ɛ ‑bɩ nʋgba ꞊dʋ, ‑ɛ nɩ 'lɩ nyibli ‑hʋɔhʋɩ 'nyɩ, ɛ nɔ‑ 'yaa 'lɩ win, ɛ wɛn: «Plɔ a bleelɛ, 'kɩ 'ʋ nʋgba ‑mʋ', ‑ɛ ꞊gbla ‑mʋ, 'tɩ‑ ‑ɛ 'nya ‑mʋ ‑mɔ'.» ");
INSERT INTO ktj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","‑Ɛ ‑bɩ ‑Yusu ꞊tu꞊o ꞊wɔn, ɛ wɛn: «Nyibli ‑bʋ, ‑ʋ pɩ Nyɩsʋa a win nʋa yɩ bʋ, 'tɩ‑ ‑ʋ ꞊tui 'ʋ꞊ʋ 'ʋ, sɛyɩ‑sɛyɩ, ʋ nʋ‑ kɔ plɔ a bleelɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nyibli ‑hʋɔhʋɩ, ʋ nʋ‑ yɩ lɛ 'kukue ‑nɩ, 'kɩ 'ʋ ‑Yusu 'hʋɩ. Kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «Ti ‑bʋ 'yri a nyibli ‑bʋ, 'waa nunuklɔ nyre yɩ. Ʋ ‑hʋɛ ꞊wlɩlɛkɛɛdɛ, ‑ɛ di ꞊nʋ꞊ʋ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, Nyɩsʋa, ɛ nɔ‑ lee 'nɛ‑ 'mʋ ‑tʋtʋ kɩ. Kɛɛ, Nyɩsʋa 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ wɛn, 'kɩ bʋ 'ye ꞊wlɩlɛkɛɛdɛ ꞊dʋ. ꞊Wlɩlɛkɛɛdɛ nɩ ‑do, Nyɩsʋa di nu, 'kɩ 'ʋ ꞊nʋ ‑mɔ, ɛ di 'wɩ‑ 'a dɛ ‑bɩ ‑mʋ', ɛ nu la, 'kɩ 'ʋ winwlɔn‑hanyɔ Jona a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","꞊Wlɩlɛkɛɛdɛ ‑mʋ', Nyɩsʋa nu la 'lɩ Jona a 'klɔ 'kwli, 'tɩ‑ Ninifʋdɩɔ a nyibli 'ye la, kɛ‑ ɛ di 'mʋ ꞊ti, 'kɩ 'ʋ 'mɔ ‑bʋ ‑mɔ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo. Nyɩsʋa di nu ꞊wlɩlɛkɛɛdɛ, 'kɩ 'lɩ 'na 'klɔ 'kwli ‑wɛ, ‑ɛ di꞊e nu, ti ‑bʋ 'yri a nyibli 'mʋ꞊ʋ 'ye. ");
INSERT INTO ktj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","'Ɛ mɔ ꞊han‑tɩ, ‑tɛ Ninifʋkʋɛ a 'mʋ, ʋ 'wɩn la Jona a win, ‑ɛ yɩ la ꞊nʋ Nyɩsʋa a ‑tɩ ‑lee ‑nɩ, ‑ɛ ‑bɩ ʋ hie la 'ʋ dɛ 'kuku, ʋ ni la bʋ, 'ʋ ‑nyi la 'waa 'klɔ a pɛpɛ Nyɩsʋa. ‑Ɛ ‑bɩ 'kɩ, 'mɔ ‑bʋ, ‑ɛ nɩ ‑mɔ 'a mʋ ye' bʋ, 'n ‑hi 'ʋ Jona a 'mʋ nɩ, kɛɛ, a 'nɩ ꞊tuu꞊o 'ʋ 'na win 'ʋ. Ɛ nɔ‑ nu꞊o, ti ‑mʋ' ‑kɔ 'yri Nyɩsʋa di 'ʋ ‑tonyibli ‑bati lɛ ‑pʋʋ ‑nɩ, Ninifʋdɩɔ a nyibli a 'mʋ, ʋ nʋ‑ di ye' 'du, ʋ 'mʋ lɛ pʋ, ‑ɛ mɔ, ti ‑bʋ 'yri a nyibli, ʋ mɔ ‑tɩ'wlanyʋ ꞊nɩɔ, 'kɩ 'ʋ Nyɩsʋa ye'. 'Ya 'ʋ 'lu de, ti ‑hi la a ti 'yri, bodɩɔ ꞊dʋ, ɛ nɔ‑ ‑hɔn la 'lɩ ‑tɩtɛ blɔblʋ ꞊dʋ, ʋ dɛɛ Sabablʋgba. Bodɩɔ a 'mʋ, ɛ mɔ la nʋgba ꞊nɩɔ. Ɛ nɔ‑ di la 'lɩ Jrusrɛdɩɔ 'kwli, ɛ 'mʋ la bodɩɔ Salomɔ, ‑ɛ mɔ la Nyɩsʋa a nyiblo, 'a ꞊tɔwin 'wɩn. ‑Ɛ ‑bɩ 'kɩ o, 'mɔ ‑bʋ, ‑ɛ nɩ mɔ 'a mʋ ye' bʋ, 'n ‑hi 'ʋ Salomɔ a 'mʋ nɩ. Kɛɛ, a 'nɩ ꞊tuu꞊o 'ʋ 'na win 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nyiblo 'bʋ 'bɩa 'napɩ, ɛ 'nɩ ‑hli꞊e lɩ꞊ɩ, mɔ ɛ 'nɩ ꞊jri꞊e lɩ꞊ɩ kɩka 'lu bʋ, kɛɛ, ɛ ꞊tui 'ʋ꞊ʋ dɛ 'lu bʋ, ‑ɛ di꞊e nu, nyibli ‑mʋ', ‑ʋ di 'lɩ 'kayu bʋ pa, ʋ 'mʋ lɛ yru. ");
INSERT INTO ktj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","‑Tonyiblo a ꞊wlʋ, ɛ 'wɩ‑ 'a 'yii yɩ, ‑ɛ yɩ꞊ɩ ‑nyrɛ ‑nyi. ‑Na 'yii 'bʋ nu ‑tɛɛ, ‑ɛ ‑bɩ ‑yrui lɛ ‑tɛɛ. Kɛɛ, ‑na 'yii 'bʋ yɩ nɩ klɛ, ‑ɛ ‑bɩ 'kɩ ‑nɩ 'lɩ halɔ 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","'A ‑tɩ, ꞊tu ‑dɩɔnʋ 'yie, ‑ɛ di꞊e nu, ‑nyrɛ ‑mʋ', ‑ɛ nɩ 'lɩ ‑mʋ 'lɩ, ɛ 'nɩ ꞊ha halɔ ‑hɛ. ");
INSERT INTO ktj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","'Bʋ mɔ, ‑na ꞊wlʋ 'bʋ nɩ 'lɩ ‑nyrɛ 'kwli, halɔ a dɛ ꞊dʋ 'bʋ 'yɩ 'lɩ ‑na ꞊wlʋ kɩ ‑nɩ, ‑ɛ ‑bɩ ‑na ꞊wlʋ a pɛpɛ a 'mʋ, 'kɩ ɛ di 'lɩ ‑nyrɛ 'kwli nɩ, ꞊wɩ 'napɩ yɩ, ‑ɛ ni꞊e, ꞊nɩ yrui lɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","‑Tɛ ‑Yusu ‑wɛ 'pʋplɛ ‑mɔ, ‑ɛ ‑bɩ Falisi꞊tumu a nyiblo ‑bɩ, nɔ‑ daa diidɛ ‑mɔ. ‑Tɛ ‑Yusu pa 'lɩ 'a ‑tɛ, ‑ɛ ‑bɩ ʋ mu 'ʋ dɛdihu kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","‑Tɛ ‑Juukʋɛ* a tete pɩ, ‑ɛ mɔ, nyiblo bʋ yra ꞊jrɛ, 'tɩ‑ ɛ 'mʋ dɛ di, ‑Yusu 'yɩ꞊ɩ ‑nu. ‑Tɛ Falisi꞊tumu a nyiblo a 'mʋ, ɛ 'ye꞊e, ‑ɛ mɔ, ‑Yusu 'yɩ ꞊jrɛ ‑yra, ɛ maa ꞊nɛ wlɔn lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","‑Ɛ ‑bɩ kɛ‑ Kʋkɔnyɔ pɩ꞊ɩ yɩ, ɛ wɛn: «'A mʋ Falisi꞊tumu a nyibli, 'aan 'kwli'naapʋɛlɩ kɔ 'aan 'kwlitaapʋɛlɩ 'hʋɛn‑, nʋ‑ a yrɛ lɛ. Kɛɛ, 'yiyrie kɔ 'crɛ 'hʋɛn‑, nʋ‑ 'yii 'lɩ 'aan ꞊wlɩ kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","A ba nɩ ‑tɛɛ. 'Bɩ a yi꞊e nɩ, ‑ɛ mɔ, Nyɩsʋa, nɔ‑ nu ‑tɛblɩ ‑mʋ', ‑tonyibli a 'yie yɩ 'ye, 'ɛ nu ‑tɛblɩ ‑mʋ', ‑tonyibli a 'yie 'yɛ nɩ 'ye ‑wɛ. ꞊Bɩ a pʋ꞊ʋ ꞊haan‑tɩ, ‑tɛblɩ nɩ ‑tie ‑mʋ', ‑ɛ nɩ 'lɩ ‑tonyiblo a ꞊wlʋ kɩ, 'yie 'yɛ nɩ 'ye, Nyɩsʋa 'nɩ 'ye꞊e lɩ꞊ɩ ‑wɛ? ");
INSERT INTO ktj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Dɛ a kɔ ba nu, ɛ nɔ‑ mɔ, ‑tɛblɩ ‑mʋ', ‑ɛ nɩ 'lɩ 'aan 'kwlitaapʋɛlɩ kɔ 'aan 'kwli'naapʋɛlɩ 'kwli, ba ‑ha 'lɩ꞊ɩ 'lɩ, ba ‑nyi꞊e ꞊hɩʋɛnnyibli. 'Bʋ mɔ, 'ba yɩ꞊ɩ lɛ nɩ ni, ‑ɛ ‑bɩ ‑tɛblɩ a pɛpɛ di 'ʋ yɩ 'nɩ 'sii ‑nɩ, 'kɩ 'ʋ Nyɩsʋa ye', a 'mʋ꞊ʋ ‑kʋan 'yri ‑nuu ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","'A mʋ Falisi꞊tumu a nyibli, 'jrɔ 'kɩ 'ʋ 'a mʋ ‑mɔ! 'Bʋ mɔ, 'ba kɔ hawi ‑mʋ', a pɩ 'lɩ dididɛ ‑mɔ, kɔ 'a ‑nɛ 'dʋdɔdɛ ꞊dʋ, a ‑hɛ 'lɩ 'aan ‑sadɛ 'kwli, nɔ‑ kɔ ‑pu a dɛ a ‑hɛ 'lɩ, 'a yɩ꞊ɩ Nyɩsʋa ‑nyi. Kɛɛ, a 'nɩ ‑hie lɩ꞊ɩ 'lu ‑mɔ lɛ, ‑ɛ mɔ, 'aan 'klɔ bʋ 'sii 'ʋ yɩ, kɔ, ba nʋɛ Nyɩsʋa. Kɛɛ, dɛ a 'mʋ, ɛ nɔ‑ a kɔ ba nu wɛn, 'tɩ‑ a 'mʋ wɛn 'lɩ 'aan 'dʋdɔ‑tɛblɩ a ‑pu a dɛ 'lɩ ‑ha, a 'mʋ wɛn꞊ɛ Nyɩsʋa ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","'A mʋ Falisi꞊tumu a nyibli, 'jrɔ 'kɩ 'ʋ 'a mʋ ‑mɔ, ‑kɔtɩ 'ba mu 'lɩ Nyɩsʋa a 'kayo blɛ, a nʋɛ ba nɩ 'lɩ ye' blɛ, ‑ɛ di꞊e nu, nyibli 'mʋ 'a mʋ 'ye ‑tɛɛ. Kɔ, 'bʋ mɔ, 'ba mu 'lɩ 'dika, a nʋɛ 'kɩ nyibli bʋ pʋ 'a mʋ 'wio blɛ, 'kɩ 'ʋ 'aan 'ʋ꞊tuulɛ a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","'Jrɔ 'kɩ 'ʋ 'a mʋ ‑bʋ ‑mɔ, ‑ʋ 'yɩ 'ʋ yɩ 'sii ‑nɩ, 'kɩ 'ʋ Nyɩsʋa ye'. A 'wɩ‑ 'dabi yɩ, ‑ʋ 'yɩ 'ʋ yɩ 'sii ‑nɩ, 'kɩ 'ʋ Nyɩsʋa ye'. ‑Tonyibli 'bʋ 'yɛ nɩ yru 'dabi a 'mʋ lɛ, 'bʋ yɩ ꞊nʋ klɛ nɩ nɛ, ‑ɛ ‑bɩ 'dabi a 'mʋ, ʋ ni꞊e nɩ, 'kɩ ʋ 'yɩ 'ʋ yɩ 'sii ‑nɩ, 'kɩ 'ʋ Nyɩsʋa ye'.» ");
INSERT INTO ktj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tetetɔɔnyʋ ‑mʋ', ‑ʋ nɩ 'ʋ, kɛ‑ 'waa nyiblo ‑bɩ pɩ ‑Yusu yɩ, ɛ wɛn: «Tɔɔnyɔ o, 'bʋ mɔ, ꞊nɩ yɩ 'pʋplɛ lɛ nɩ ni, ɛ 'wɩ yɩ, ‑a mʋ ‑hɛ 'yri lɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","‑Ɛ ‑bɩ ‑Yusu ꞊tu꞊o ‑wɔn, ‑ɛ wɛn: «'A mʋ tetetɔɔnyʋ, 'jrɔ 'kɩ 'ʋ 'a mʋ ‑mɔ ‑wɛ, ‑ɛ nu꞊o, a yɩ hlɛ nyibli tete a gblegble a 'bɛnʋ, ʋ 'yɩ 'lɩ 'buble 'lɩ ‑wɛ, ɛ kɔ, a 'nɩ ‑hɛɛ lɩ ꞊nʋ, 'kɩ bʋ ꞊tuu 'ʋ tete a 'mʋ 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","'Jrɔ 'kɩ 'ʋ 'a mʋ ‑mɔ, ‑tɛ a nu Nyɩsʋa a winwlɔn‑hanyʋ* ‑bʋ, 'aan 'baɩnʋ 'lɩla lɛ, 'a yɩ 'waa 'dabi ꞊hrɛntɩ ‑nɩ ‑tɛɛ. ");
INSERT INTO ktj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","‑Tɛ a ni 'a nunuo lɛ, ɛ tʋɛ ꞊nɛ nyibli yɩ, ‑ɛ mɔ, ‑tɛblɩ a 'mʋ, 'aan 'baɩnʋ nu la, a wɛn꞊ɛ kɩ, ‑ɛ nu꞊o, ʋ nʋ‑ ‑mɔ ‑bɩ, ʋ 'la Nyɩsʋa a winwlɔn‑hanyʋ nɩ, 'a mʋ ‑mɔ ‑bɩ, 'a yɩ 'waa 'dabi ꞊hrɛntɩ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, Nyɩsʋa ‑mʋ', ‑ɛ kɔ ꞊tɔ, kɛ‑ ɛ pʋ la, 'kɩ 'ʋ 'aan dɛ kɩ, ‑ɛ mɔ: 'N di ya ꞊nʋ winwlɔn‑hanyʋ, kɔ titiepʋnyʋ 'hʋɛn‑ yɩ, kɛɛ, ʋ di ‑ʋ ‑bɩ 'nɩ 'la, ʋ 'mʋ ‑ʋ ‑bɩ ꞊hɩʋɛn ꞊tu. ");
INSERT INTO ktj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","'A mʋ ‑bʋ, Nyɩsʋa a yrʋ di 'a mʋ 'nɩ klɔ, 'kɩ 'ʋ winwlɔn‑hanyʋ a pɛpɛ a 'mʋ a ‑ta', ‑ɛ kɔ ‑hlʋ ‑mʋ', ʋ 'wʋwla blɛ, kʋɛ 'lɩ ti ‑mʋ' 'yie bʋ, ‑ɛ kɔ 'yri Nyɩsʋa nu la 'klɔ, ‑bʋ yɛ ti ‑bʋ kɩ, ");
INSERT INTO ktj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","‑ɛ ꞊hɛn 'nyrɛ, kʋɛ la 'lɩ Abɛlɩ a 'lɩlati 'yie bʋ, ‑bʋ yɛ Sakali a ti kɩ, ‑ɛ mɔ Sakali ‑mʋ', ʋ 'la la, 'kɩ 'ʋ Nyɩsʋa a ‑cɔhlʋnpiilɛ* kɔ 'a 'kayu a ‑gbati. 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, ti ‑bʋ 'yri a nyibli, nʋ‑ Nyɩsʋa a yrʋ di klɔ, 'kɩ 'ʋ ‑tɛblɩ a 'mʋ a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","'Jrɔ 'kɩ 'ʋ 'a mʋ Nyɩsʋa a tetetɔɔnyʋ ‑mɔ, ‑kɔtɩ 'aan tɔɔlɛ kɛ 'hru ‑mʋ', ‑tonyibli di wɛn na, ʋ 'mʋ wɛn꞊ɛ yi, ‑tɛ Nyɩsʋa ni ‑tonyibli a wʋwa. 'Aan 'mumu, a 'nɩ ‑gba꞊a lɩ 'hru a 'mʋ, 'tɩ‑ 'a ka nyibli ‑bɩ ‑mʋ' yɩ, ‑ʋ ‑hʋɛ ‑bʋ ‑gba wɛn 'hru a 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","‑Tɛ ‑Yusu ‑wɛ 'pʋplɛ ‑mɔ, ‑ɛ ‑bɩ ɛ ‑hɔn 'ʋ ‑tɩtɛ a 'mʋ nɩ. Kʋɛ la 'lɩ ti a 'mʋ 'yie bʋ, Nyɩsʋa a tetetɔɔnyʋ, kɔ Falisi꞊tumu a nyibli 'hʋɛn‑, ʋ ‑tʋa la 'a yrʋ a lɛpʋʋlɛ, 'ʋ yɩ꞊ɩ lɛ 'bɛti ‑nɩ 'a ‑nɛ ti, 'kɩ 'ʋ ‑tɛblɩ ‑hʋɔhʋɩ kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","'Kɩ 'lɩ lɛ'bɛtilɛ a 'mʋ 'kwli, 'kɩ ʋ nɛɛ 'lɩ, 'ʋ yɩ 'ʋ꞊ʋ lɛ ꞊tɛɛ ‑nɩ, ‑ɛ di꞊e nu, 'bʋ ‑ka, ʋ 'mʋ꞊ʋ ‑tɩ ‑yɛɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","‑Tɛ ‑Yusu yɩ nyibli nɩ ‑tʋɛ ‑nɩ, ‑ɛ ‑bɩ nyibli ‑hʋɔhʋɩ ‑bɩ 'kukue lɛ. Nyiblo ꞊dʋ 'yɩ 'lɩ 'waa ‑hihre 'lɩ ‑wɛ. 'Waa ‑hʋhʋʋ a ‑tɩ, 'ʋ nɩnɛ klɛ. Yɩ‑hɛnyibli, ‑Yusu yɩ 'lɩ ‑mɔ ‑hlee ‑nɩ, ʋ nʋ‑ mɔ 'a ‑nagbopʋ. Kɛ‑ ɛ pɩ ꞊nʋ yɩ: «Ba ꞊tu 'aan dɩɔnʋ 'yie, 'kɩ 'ʋ Falisi꞊tumu* a nyibli a ‑ta', ‑ʋ nɛɛ 'li nɩ 'hʋɛn. 'Waa 'li nɩ 'hʋɛn a naalɛ a 'mʋ, ɛ 'wɩ ‑wleyɛ yɩ, ‑ɛ ‑pa, 'tɩ‑ ‑ɛ ni꞊e, 'a 'bio ‑wloyɔ ‑bɩ 'ʋ pʋɛ. ");
INSERT INTO ktj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ti di 'ʋ 'nɩ nyre, ‑ɛ kɔ 'yri ‑tɩ a ‑tɛɛ di 'ʋ pepe' bi, ɛ kɔ, ‑tɛblɩ nɩ ‑tie ‑mʋ', ‑ʋ ‑hli kɛ, nyibli a pɛpɛ 'mʋ꞊ʋ yi. ");
INSERT INTO ktj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","'Bʋ mɔ, 'ba bii yɩ, ‑tɩ ‑mʋ', a hlɛ, ‑tɛ ‑mʋ', ‑tonyibli ‑wɛ 'ʋ ti kɩ, 'kɩ ʋ di 'ʋ꞊ʋ ‑mɔ lɛ ‑naa ‑nɩ, ʋ 'mʋ 'wɩn. ‑Tɩ ‑mʋ', a blee 'lɩ bʋ, a hlɛ, 'kɩ ‑tɩtɛ ‑mʋ', 'dʋ bii 'ʋ yɩ, ʋ kɔ bʋ naa ‑mɔ lɛ, 'kɩ 'ʋ nyibli a pɛpɛ ye'.» ");
INSERT INTO ktj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","(Kɛ‑ ‑Yusu pɩ 'a ‑nagbopʋ* yɩ, ɛ wɛn:) «'A mʋ ‑mʋ', ‑ʋ mɔ 'na nɩnatumupʋ, 'n yɩ 'a mʋ 'nɩ ‑lee ‑nɩ: A 'nɩ 'pie 'lɩ ‑tonyibli a hʋannʋ. 'Aan ‑plahʋɩ nɩ ‑do, ɛ nɔ‑ ʋ ‑wɛ 'lɩ bʋ ‑wɛ bʋ, kɛɛ, ʋ 'yɩ 'klɩ ꞊dʋ ‑kɔ 'kɩ de, 'kɩ bʋ nu 'ʋ 'a mʋ ꞊dedede 'yie. ");
INSERT INTO ktj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kɛɛ, Nyɩsʋa, nɔ‑ kɔ hʋannʋ ba pie, ‑ɛ nu꞊o, ɛ nɔ‑ kɔ 'klɩ, 'kɩ bʋ ‑wɛ ‑tonyiblo bʋ, 'ɛ kɔ 'klɩ ‑wɛ, 'kɩ bʋ pʋ 'lɩ ‑tonyiblo na 'nyɩ, ‑ɛ 'yɛ nɩ jre yruyru. Iin, Nyɩsʋa, nɔ‑ kɔ hʋannʋ ba pie. ");
INSERT INTO ktj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","꞊Bʋ pʋʋ ꞊nɛ nʋblɩ 'cɩmɩ a dɛ yɩ: 'Bʋ mɔ, ꞊nɩ yɩ ꞊nʋ nɩ ‑tʋɛ, ʋ 'nɩ ‑pʋ꞊ʋ lɩ ꞊die dɩakɩ, kɛɛ, nʋblɩ a 'mʋ, 'a dɛ 'bʋ nɩ 'ʋ, Nyɩsʋa yi꞊e nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","'Aan 'mumu, kɛ‑ nɩ ‑do ɛ ꞊ti 'mʋ: 'Lunyapli nɩ ‑tie ‑bʋ, a ‑kɔ, 'aan 'Baɩ Nyɩsʋa, ɛ ‑hre꞊e nɩ. Ɛ ꞊hɛn 'nyrɛ, ‑ɛ mɔ, a kɔ 'mini dɩakɩ, 'kɩ 'ʋ Nyɩsʋa ye', 'a ‑hi 'ʋ nʋblɩ ‑hʋɔhʋɩ ‑mʋ' 'ʋ. 'A ‑tɩ o, a 'nɩ 'pie 'lɩ ‑tonyibli a hʋannʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, nyiblo 'bʋ hla꞊a, 'kɩ 'ʋ nyibli ye', ‑ɛ mɔ, ɛ mɔ 'na nyiblo ꞊nɩɔ, 'na 'mumu ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, ‑batipʋ‑nyrɔwɔ 'bʋ nyre 'ʋ, 'n di꞊e 'nɩ hla ‑wɛ, 'kɩ 'ʋ Nyɩsʋa a lɛlenyʋ ye', ‑ɛ mɔ, nyiblo a 'mʋ, ɛ mɔ 'na nyiblo ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kɛɛ, nyiblo 'bʋ hla꞊a, 'kɩ 'ʋ nyibli ye', ‑ɛ mɔ, ɛ 'yɩ 'mʋ ‑yi, 'na 'mumu, ‑batipʋ‑nyrɔwɔ 'bʋ nyre 'ʋ, 'n di꞊e 'nɩ hla ‑wɛ, 'kɩ 'ʋ Nyɩsʋa a lɛlenyʋ ye', ‑ɛ mɔ, 'n 'yɩ꞊ɩ ‑yi. ");
INSERT INTO ktj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","'Ya 'ʋ 'lu de, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, nyiblo ‑bʋ, ‑ɛ di 'mʋ ‑tɩ ‑hʋɩn yrɛ hla, Nyɩsʋa ‑wɛ 'lɩ bʋ 'wʋwla 'a dɛ 'kuku a 'mʋ nɩ. Kɛɛ, nyiblo ‑bʋ, ‑ɛ di Nyɩsʋa a ‑Hihiu* ‑tɩ ‑hʋɩn yrɛ hla, Nyɩsʋa 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ 'wʋwla 'a dɛ 'kuku a 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","'Bʋ mɔ, 'bʋ klɔ 'a mʋ, 'kɩ ʋ 'mʋ 'lɩ 'a mʋ ‑batipʋʋlɛ' gba a ‑tɩ, 'kɩ 'ʋ Nyɩsʋa a 'kayo a nyibli gbagbɩ ye', kɔ 'kɩ 'ʋ 'blʋgba a naanyʋ ye', 'kla 'nɩ 'yaa 'lɩ 'a mʋ ‑wliye, 'kɩ ‑tɛ a di 'waa ꞊wɔn a ꞊tutuo nu a ‑ta', ɛ kɔ 'kɩ 'ʋ ‑tɩ ‑mʋ', a di hla a ‑ta', ");
INSERT INTO ktj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","‑ɛ nu꞊o, ti a 'mʋ 'yri, ‑tɩ ‑mʋ', a di hla, Nyɩsʋa a ‑Hihiu, nɔ‑ di 'a mɔ꞊ɔ ‑tɔɔ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","‑Yusu bʋ nɩ 'lɩ win a pʋpʋʋ 'kwli, ‑ɛ ‑bɩ nyiblo ꞊dʋ nɩ 'lɩ nyibli 'nyɩ, 'ɛ yɩ ‑Yusu ‑lee ‑nɩ, ɛ wɛn: «Tɔɔnyɔ o, lee 'na 'dɩayɩ, ‑tɛblɩ ‑bʋ, ‑aan 'baɩ hie ‑a mʋ lɛ, ɛ kɔ 'mʋ 'hʋɛn‑ ‑ba ꞊gla꞊a.» ");
INSERT INTO ktj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ꞊ɩ yɩ, ɛ wɛn: «Nyiblo ꞊dʋ 'yɩ 'mʋ 'aan ‑batipʋnyɔ kɔ 'aan ‑tɛblɩ꞊glanyɔ ‑mɔ' ‑nu.» ");
INSERT INTO ktj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ nyibli a pɛpɛ a 'mʋ yɩ, ɛ wɛn: «Ba ꞊tu 'aan dɩɔnʋ 'yie, 'kɩ 'ʋ kʋkɔ‑tɛblɩ ‑hʋɔhʋɩ a nʋɛlɛ a ‑ta'. 'Ye ꞊bɩɩ nyiblo 'ble kʋkɔ‑tɛblɩ ‑hʋɔhʋɩ kʋa, ɛ 'yɩ꞊ɩ 'pa‑, ɛ 'yɩ 'a dɩɔnʋ a ‑hʋnhlʋn kʋa 'ble.» ");
INSERT INTO ktj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","‑Ɛ ‑bɩ ɛ pɩ ꞊nʋ 'ledʋ yɩ, ɛ wɛn: «Ɛ kɔ la dɛkɔnyɔ ꞊dʋ. Nɔ‑ kɔ la ‑cii ‑hʋɔhʋɩ, 'a 'dʋdɔ‑tɛblɩ 'wʋ la nɩ dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ɛ nɔ‑ yɩ la 'a dɩɔnʋ ‑lee ‑nɩ, ɛ wɛn: ‑Bɩ' 'n di 'kɩ 'na 'dʋdɔ‑tɛblɩ ‑bʋ a blɛ꞊tutuo nu, ‑ɛ nu꞊o, 'n 'yɩ 'a blɛ꞊tuulɛ ‑kɔ. ");
INSERT INTO ktj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","‑Ɛ ‑bɩ ɛ wɛn: Ɩn'hɩn‑, dɛ 'n di nu, ɛ nɔ‑ ‑bʋ: 'Kayo a pɛpɛ ‑bʋ ‑kɔ bʋ 'n pɩ 'lɩ 'na 'dʋdɔ‑tɛblɩ lɛ, 'n kɔ ꞊bʋ 'wla ꞊nʋ, 'mʋ 'waa yrayrɩ pʋ, ‑ʋ kɔ 'bʋbʋa di 'ʋ 'a 'kɩ 'ʋ ‑hi. Ʋ nʋ‑ kɔ 'kwli 'n di 'lɩ 'na ‑kʋbʋ kɔ 'na kʋkɔ‑tɛblɩ a pɛpɛ 'lɩ pʋ. ");
INSERT INTO ktj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","'Nɩ ‑wɛ ‑mɔ, kɛ‑ 'n di 'na dɩɔnʋ yɩ pʋ: 'N ꞊tu kʋkɔ‑tɛblɩ ‑hʋɔhʋɩ bʋ, ‑ʋ di 'mʋ ‑hɛɛ ‑nɩ, 'kɩ 'lɩ 'yrɩ ‑hʋɔhʋɩ 'kwli. 'A ‑tɩ o, ꞊bʋ nɩ bʋ, 'mʋ ‑wle, 'mʋ dɛ di ‑tɛɛ, kɔ, 'mʋ lɛ 'mle. ");
INSERT INTO ktj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kɛɛ, kɛ‑ Nyɩsʋa pɩ꞊ɩ yɩ, ɛ wɛn: ‑Ba nɩ 'dɔ. 'Tɔlʋwɔ nɩ ‑do ‑bʋ 'kwli, ‑di 'nɩ 'kʋ. ꞊Nɩ 'kʋ, ‑tɛblɩ a pɛpɛ ‑bʋ, ꞊tu bʋ, dɛ a 'dɩ ‑bɩ ɛ di 'ʋ ‑mʋ 'ʋ pʋ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","‑Ɛ ‑bɩ ‑Yusu wɛn 'nɩ de: «Kɛ‑ ɛ di 'mʋ ꞊ti, 'kɩ 'ʋ nyiblodʋ ‑bʋ ‑mɔ', ‑ɛ yɩ kʋkɔ‑tɛblɩ lɛ 'kukue ‑nɩ, 'kɩ 'ʋ 'a dɩɔnʋ ‑mɔ, kɛɛ, ‑ɛ 'yɩ ꞊dedede ‑kɔ, 'kɩ 'lɩ Nyɩsʋa 'yi.» ");
INSERT INTO ktj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kɛ‑ ‑Yusu pɩ 'a ‑nagbopʋ* yɩ de, ɛ wɛn: «Ɛ nɔ‑ nu꞊o, 'nɩ yɩ 'a mʋ ‑lee ‑nɩ: Dɛ ‑bʋ, a di di, kɔ wlawlɩ ‑bʋ, a di pʋ, ‑tɛblɩ a 'mʋ, 'a ‑tɩ, a 'nɩ 'hriti 'lɩ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","‑Hʋnhlʋn ‑bʋ, a pɩ, ɛ mɔ dɛ gbagbʋ ꞊nɩɔ, 'ɛ ‑hi 'ʋ dididɛ 'ʋ, kɔ, 'aan ‑plahʋɩ mɔ dɛ gbagbʋ ꞊nɩɔ, 'ɛ ‑hi 'ʋ 'hʋɩlɛpʋ‑tɛblɩ 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ba ta 'ʋ 'maa ‑mɔ lɛ, ʋ 'nɩ 'dɔ꞊ɔ lɩ, kɔ, ʋ 'nɩ 'cɛ꞊ɛ lɩ ꞊dedede, mɔ, 'ʋ 'yɩ ꞊gbi'‑handɛ ‑kɔ, ‑ɛ kɔ 'kwli ʋ di 'lɩ dididɛ lɛ pʋ. Kɛɛ, Nyɩsʋa, ɛ nɔ‑ yɩ ꞊nʋ dididɛ ‑nyi. Kɛɛ, 'a mʋ ‑mɔ ‑bɩ, Nyɩsʋa nʋɛ nɛ 'a mʋ nɩ, 'ɛ ‑hi 'ʋ nʋblɩ 'ʋ. 'A ‑tɩ, ‑tɛ ɛ ni, 'ɛ yɩ nʋblɩ dididɛ ‑nyi, kɛ‑ ɛ di nu, ɛ 'mʋ 'a mʋ dididɛ ‑nyi ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ɛ 'yɩ nyiblo ꞊dʋ ‑kɔ, 'kɩ 'lɩ 'a mʋ 'nyɩ, 'a hritilɛ a ‑tɩ, ‑bʋ kɔ 'klɩ, 'kɩ ‑bʋ pʋʋ nɛ 'a ‑nyrɔwɩ a dɛ gbe kɩ, 'kɩ 'nɛ‑ 'klɔ ‑bʋ kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","'A ‑tɩ, ‑tɛ a 'yɩ 'kɩ 'klɩ ‑kɔ, 'kɩ ba pʋʋ nɛ 'aan ‑nyrɔwɩ kɩ, a 'yɩ 'kɩ yɩ ‑blɛɛ ‑nɩ, ba hriti ‑nɩ de, 'kɩ 'ʋ 'klɔ ‑bʋ a ‑tɛblɩ a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ba 'ye ‑piti, ‑tɛ 'a ‑pui nu yɩnɩnɔ. ‑Piti a ‑pui a 'mʋ, ɛ 'wɩ‑ ‑tonyiblo a wlawlɩ yɩ. Kɛɛ, ‑piti a 'mʋ, ɛ 'nɩ ‑nu꞊o lɩ ‑kʋan, mɔ, ɛ 'nɩ 'gbla꞊a wlawlɩ, ɛ 'nɩ ‑pʋ꞊ʋ lɩ꞊ɩ, kɛɛ, ɛ nɔ yɩ. ꞊Bʋ lee nɛ 'a mʋ: Bodɩɔ Salomɔ, ɛ mɔ ꞊han‑tɩ, 'ɛ kɔ la dɛ, kɛɛ, ‑tɛ ‑piti a ‑pui nu yɩnɩnɔ, Salomɔ a 'mʋ, ɛ 'yɩ la 'a wlawlʋ ‑kɔ, ‑bʋ nu la yɩnɩnɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","‑Piti ‑bʋ, ʋ di ‑hʋan ‑ci, 'tɩ‑ ʋ di ‑hʋan 'tɔ pʋ, 'bʋ mɔ, Nyɩsʋa 'bʋ kɔ bʋ nu꞊o, 'a ‑pui bʋ nɔ yɩ, ꞊bɩ 'a mʋ ‑bʋ, ɛ nʋɛ ‑nɩ, 'a mʋ ɛ 'yɛ nɩ di 'hʋɩlɛpʋ‑tɛblɩ nɩ ‑nyi, 'a mʋ ‑bʋ, ‑ʋ 'yɩ Nyɩsʋa ꞊wlʋ yɩ ‑kuo ‑nɩ ‑tɛɛ? ");
INSERT INTO ktj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","'A ‑tɩ, a 'nɩ 'hriti 'lɩ ‑nɩ, 'aan 'kwli a ‑gʋtʋ 'nɩ 'nuo 'lɩ 'a mʋ. ");
INSERT INTO ktj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nyibli ‑mʋ', ‑ʋ 'yɩ Nyɩsʋa ‑yi, ʋ nʋ‑ yɩ ‑tɛblɩdʋ a 'mʋ 'lu ‑mɔ lɛ ‑hie 'a ‑nɛ ti. Kɛɛ, 'aan 'Baɩ Nyɩsʋa yi 'aan ‑hʋhʋa‑tɛblɩ nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Dɛ a blɛɛ yɩ ba ‑hie 'lu ‑mɔ lɛ 'a ‑nɛ ti, ɛ nɔ‑ mɔ, Nyɩsʋa bʋ kɔɔ nɛ 'a mʋ win kɩ. Ɛ nɔ‑ di꞊e nu, ɛ 'mʋ 'a mʋ 'aan ‑hʋhʋa‑tɛblɩ a 'mʋ ‑nyi.» ");
INSERT INTO ktj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","(Kɛ‑ ‑Yusu pɩ 'a ‑nagbopʋ* yɩ de, ɛ wɛn:) «'A mʋ ‑bʋ, ‑ʋ nɛ 'mʋ ‑mɔ, ‑ʋ mɔ 'na nyibli, a 'yɩ ‑hʋ, kɛɛ, a 'nɩ 'pie 'lɩ hʋannʋ. 'Aan 'Baɩ Nyɩsʋa ‑ha 'lɩ 'a mʋ nɩ, ɛ 'mʋ 'a mʋ 'klɔ yrayrʋ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ba plo 'aan kʋkɔ‑tɛblɩ, ba ‑ha 'lɩ 'a 'wliyɛ, ba ‑nyi꞊e ꞊hɩʋɛnnyibli. Ɛ ꞊hɛn 'nyrɛ, ba ꞊mʋɔ 'wli a 'kwlipʋdɛ ‑mʋ' lɛ, ‑ɛ 'yɛ nɩ di lɛ nɩ ‑cɩcrɛ ‑nɩ. Ba 'kukue kʋkɔ‑tɛblɩ lɛ, 'kɩ 'lɩ yakɔ 'kwli, ‑tɛ ɛ 'yɛ nɩ di 'lɩ bʋ nɩ ‑wɛ, kɔ, ‑tɛ 'yiyrinyibli 'yɩ 'lɩ nyinyre 'lɩ ‑wɛ, ‑tɛ 'hlɔ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nyree 'lɩ dɛ yɩ. ");
INSERT INTO ktj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","'Nɩ yɩ 'pʋplɛ lɛ nɩ ni, ɛ 'wɩ yɩ, ‑tɛ ‑tonyiblo a kʋkɔ‑tɛblɩ nɩ 'ʋ, 'kɩ 'a ꞊wlʋ nɩ 'ʋ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","(Kɛ‑ ‑Yusu pɩ 'a ‑nagbopʋ* yɩ de, ɛ wɛn:) «Ba ‑wɛ ‑mɔ, a 'mʋ ‑kʋan nu. Ba 'wɩ ‑kʋannunyibli ‑mʋ' yɩ, ‑ʋ yɩ 'waa 'masɛ, ‑ɛ mu 'blɩpʋpa kɩ a diditi ‑ple. ‑Tɛ 'a ‑kʋannunyibli ni꞊e, kɛ‑ ba nu꞊o ‑wɛ. 'Tɔ 'bʋ ‑wɔn, 'tɩ‑ 'waa 'masɛ 'mʋ 'lɩ di, ʋ yɩ ‑wɛ ‑mɔ, 'waa 'napɩ 'nɩ ‑jre꞊e lɩ, ‑ɛ di꞊e nu, 'waa 'masɛ 'bʋ ‑di, 'bʋ bibi 'maju, ʋ 'mʋ꞊ʋ 'maju yɩ ‑ha. ");
INSERT INTO ktj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","‑Kʋannunyibli a 'mʋ, 'bʋ mɔ, 'waa 'masɛ 'bʋ ‑di, 'bʋ yɛɛ 'ʋ ꞊nʋ ‑pleelɛ' bʋ, 'bʋ 'yɛ 'nɩ ŋme, ‑ɛ ‑bɩ bʋ kɔ plɔ a bleelɛ. 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ɛ kɔ bʋ lee ꞊nʋ, ‑ɛ mɔ, bʋ nɩ bʋ, ʋ 'mʋ dɛ di, 'tɩ‑ 'a ꞊gbɛtʋ, ɛ 'mʋ 'ʋ bi, ɛ 'mʋ diidɛ a 'mʋ ‑hie. ");
INSERT INTO ktj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","'Bʋ mɔ, 'bʋ di 'tɔ‑hɛyri', ‑ʋ'ʋ‑, 'tɔ‑hɛyri 'bʋ ‑hi, 'bʋ yɛɛ 'ʋ ꞊nʋ ‑pleelɛ' bʋ, 'bʋ 'yɛ nɩ ŋme, ‑ɛ ‑bɩ bʋ kɔ plɔ a bleelɛ. ");
INSERT INTO ktj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ba kɔ 'a lɛyuyruo: 'Bʋ mɔ, 'kayukɔnyɔ 'bʋ yi wɛn ti ‑mʋ', 'yiyrinyɔ di wɛn ya, ɛ di wɛn 'nɩ ‑ple, ‑ɛ di꞊e nu, 'yiyrinyɔ a 'mʋ, ɛ 'nɩ ꞊ha 'a 'kayu wa. ");
INSERT INTO ktj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","'A ‑tɩ, 'aan 'mumu, ba ‑wɛ ‑mɔ, a 'nɩ 'ŋmee 'lɩ, ‑ɛ nu꞊o, ti ‑mʋ', a 'yɛ nɩ di꞊e 'lu ‑mɔ lɛ nɩ ‑hie, 'kɩ 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n di 'ʋ ‑dii ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","‑Yusu bʋ pʋ 'ledʋ a 'mʋ, ‑ɛ ‑bɩ Piɛlɩ wɛn: «Kʋkɔnyɔ o, ꞊bɩ ‑a mʋ nɩ ‑do a ‑tɩ, ꞊nɩ pʋ 'ledʋ ‑bʋ, ‑ʋ'ʋ‑ nyibli a pɛpɛ a ‑tɩ ꞊nɩɔ?» ");
INSERT INTO ktj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","‑Ɛ ‑bɩ Kʋkɔnyɔ wɛn 'nɩ: «Ba 'wɩ‑ ‑kʋannunyɔ ‑mʋ' yɩ, ‑ɛ kɔ 'lulɛ‑hihie, kɔ 'a 'masɛ ‑wɛ 'lɩ bʋ kuo ꞊wlʋ yɩ. Nyiblodʋ a 'mʋ, nɔ‑ 'a 'masɛ, 'bʋ yɩ 'dagba nɩ mi, ɛ di 'kayu lɛ hie, ‑ɛ di꞊e nu, dɛditi 'bʋ nyre 'ʋ, ɛ 'mʋ 'a 'bio ‑kʋannunyibli 'a ‑nɛ ‑nyrɔwɔ a diidɛ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","'A 'masɛ 'bʋ ‑hɔn 'dagba', 'bʋ yɛɛ 'ʋ꞊ʋ ‑kʋan a 'mʋ 'yie bʋ, ‑ɛ ‑bɩ ‑kʋannunyɔ a 'mʋ, bʋ kɔ plɔ a bleelɛ. ");
INSERT INTO ktj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, 'a 'masɛ di nu꞊o 'a ‑tɛblɩ'yie꞊tunyɔ gbagbʋ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kɛɛ, ‑kʋannunyɔ a 'mʋ, 'bʋ pʋ lɛ, ‑ɛ mɔ, 'a 'masɛ yɩ ke' 'nɩ ‑wlɛɛn ‑nɩ, 'bʋ ‑tʋa 'a 'bio ‑kʋannunyibli a bibie, 'tɩ‑, 'bʋ yɩ 'a dɩɔnʋ didi‑tɛblɩ kɔ nɔ 'hʋɛn‑ wlɔn nɩ ‑hie ‑nɩ, ");
INSERT INTO ktj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","‑ɛ ‑bɩ ‑nyrɔwɔ ‑mʋ', ‑kʋannunyɔ a 'mʋ, ɛ 'yɛ nɩ di 'ʋ nɩ ‑plee ‑nɩ, ɛ kɔ ‑haawɔ ‑mʋ', ɛ 'yɩ ‑yi, 'kɩ 'a 'masɛ a 'mʋ, ɛ di 'ʋ ‑dii ‑nɩ. 'Bʋ ‑di, ɛ di gba꞊a ti 'yaklɩ yɩ, 'tɩ‑ ɛ 'mʋ꞊ʋ ꞊hɩʋɛn ꞊tu, ꞊wɩ yɩ nyibli ‑mʋ', ‑ʋ 'yɩ Nyɩsʋa ꞊wlʋ yɩ ‑kuo ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","‑Kʋannunyɔ 'bʋ nɩ 'ʋ, dɛ ‑bʋ, 'a 'masɛ ‑hʋɛ, 'bʋ yi꞊e 'tɩ‑ 'bʋ 'yɛ nɩ ‑hʋa bʋ nu꞊o, 'a 'masɛ di ꞊tu꞊o ꞊hɩʋɛn dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kɛɛ, ‑kʋannunyɔ 'bʋ nɩ 'ʋ, dɛ ‑bʋ, 'a 'masɛ ‑hʋɛ, 'bʋ 'yɩ꞊ɩ ‑yi, 'tɩ‑ ‑tɛblɩdʋ ‑bʋ, ‑ɛ blɛɛ ꞊hɩʋɛn a ꞊tutuo yɩ, 'bʋ yɩ꞊ɩ nɩ ni, ꞊hɩʋɛn ‑mʋ', ʋ di꞊e ꞊tu, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ ‑hʋ. Nyɩsʋa 'bʋ ‑nyi nyiblo ‑tɛblɩ ‑hʋɔhʋɩ, ‑ɛ ‑bɩ ɛ di ‑hʋa nyiblo a 'mʋ ‑tɛblɩ ‑hʋɔhʋɩ, ɛ kɔ, 'bʋ hie nyiblo ‑tɛblɩ ‑hʋɔhʋɩ lɛ, ɛ di ‑hʋa꞊a ‑tɛblɩ ‑hʋɔhʋɩ, ɛ di 'ʋ ‑tɛblɩ ‑mʋ' 'ʋ ‑hi, ɛ ‑hie la꞊a lɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Kɛ‑ ‑Yusu pɩ de, ɛ wɛn: «'N di nɩ, 'mʋ꞊ʋ nu, na 'mʋ wlɩn, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ. 'N ‑hʋɛ wɛn꞊ɛ nɩ, 'kɩ na a 'mʋ, bʋ wlɩn wɛn ‑dodo. ");
INSERT INTO ktj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kɛɛ, 'tɩ‑ na a 'mʋ, ɛ 'mʋ wlɩn, 'n kɔ ꞊bʋ 'ye ꞊hɩʋɛn. Ɛ mɔ ꞊han‑tɩ, ꞊hɩʋɛn a 'yiye a 'mʋ, ɛ 'yɛ 'ʋ nɩ nyre, kɛɛ, 'na ꞊wlʋ 'mʋɛ bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","A 'nɩ 'yee 'lɩ꞊ɩ, ‑ɛ mɔ, 'n di 'nɛ‑ ‑tʋtʋ kɩ nɩ, 'mʋ꞊ʋ nu, nyibli 'mʋ kɩbʋwɛɛnlɛ kɔ. Kɛɛ, 'n di nɩ, ‑ɛ di꞊e nu, nyibli 'mʋ ꞊tɩɔ lɛ 'bɛ. ");
INSERT INTO ktj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kʋɛ 'kɩ mɔ bʋ, 'kayubʋkʋɛ nɩ ꞊hun 'bʋ nɩ 'ʋ, ʋ di 'nɩ ꞊gla, nyibli nɩ ta 'mʋ nyibli nɩ 'hʋɛn yɩ ‑wɔn, ɛ kɔ, nyibli nɩ 'hʋɛn 'mʋ nyibli nɩ ta yɩ ‑wɔn. ");
INSERT INTO ktj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","'Baɩ di 'a 'yu nyɩbɛhɩan yɩ 'nɩ ‑wɔn, 'yu nyɩbɛhɩan ‑mɔ ‑bɩ, ɛ 'mʋ 'a 'baɩ yɩ ‑wɔn; 'dii 'mʋ 'a 'yu nyrɔyu yɩ ‑wɔn, 'yu nyrɔyu ‑mɔ ‑bɩ, ɛ 'mʋ 'a 'dii yɩ ‑wɔn ‑wɛ; 'yu a nʋgba ‑mɔ ‑bɩ, ɛ 'mʋ 'a 'dɔɔ yɩ ‑wɔn, 'dɔɔ ‑mɔ ‑bɩ, ɛ 'mʋ 'a 'yu a nʋgba yɩ ‑wɔn ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kɛ‑ ‑Yusu pɩ nyibli a 'mʋ yɩ, ɛ wɛn: «'Bʋ mɔ, 'ba 'ye꞊e, ‑ɛ mɔ, 'nu nɩ 'lɩ yɔ' lɛ, kɛ‑ a pɩ: 'Nu di 'nɩ di. 'Ɛ mɔ ‑tɛɛ, 'nu a 'mʋ 'ɛ yɩ di. ");
INSERT INTO ktj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ɛ kɔ, 'ba 'ye꞊e, ‑ɛ mɔ, 'nu 'yɩ 'lɩ yɔ' lɛ ‑nɩ, kɛ‑ a pɩ: 'Yrʋ di 'nɩ hʋɛn. 'Ɛ mɔ ꞊han‑tɩ, 'yrʋ a 'mʋ 'ɛ yɩ hʋɛn. ");
INSERT INTO ktj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","'A mʋ nyibli ‑bʋ, ‑ʋ nɛɛ 'li nɩ 'hʋɛn, a yrui yakɔ kɔ ‑tʋtʋ 'hʋɛn‑ a ‑tɛblɩ lɛ, 'a yɩ꞊ɩ 'ye, ‑tɛ ‑mʋ', ‑nyrɛ di 'mʋ nɩ. Kɛɛ, ‑tɛblɩ ‑bʋ, Nyɩsʋa ni, ‑ɛ mi kɛ 'lu ‑mɔ, 'kɩ ti ‑bʋ, ‑a nɩ 'lɩ 'kwli, dɛ a 'dɩ ‑bɩ bʋ ꞊hɛn 'nyrɛ, a 'nɩ ‑hʋa꞊a lɩ ba yru꞊o' lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Dɛ‑ kɔ ‑tɩ 'aan ꞊gbɛtʋ 'a 'yɛ nɩ 'ye꞊e, ‑tɛ a kɔ ba nu 'aan dɩɔnʋ a naalɛ ‑tɛɛ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","꞊Nɩ 'ble nyiblo a 'wliyɛ kʋa, 'a ‑tɩ, nyiblo a 'mʋ 'bʋ yɩ ‑mʋ ‑tɩ nɩ ‑yɛɛ ‑nɩ, 'tɩ‑ 'bʋ yɩ 'lɩ ‑mʋ ‑batipʋʋlɛ' nɩ gbɛ, ꞊tu 'ʋ 'klɩ, ‑tɛ a 'tɩɛ nɩ 'hru wlɔn, a 'mʋ kɩbʋwɛɛnlɛ kɔ, ɛ 'nɩ ꞊ha 'lɩ ‑mʋ ‑batipʋnyɔ yɩ gba, ‑batipʋnyɔ 'nɩ ꞊ha ‑mʋ ‑sadapʋ yɩ gba, ʋ 'nɩ ꞊ha ‑mʋ ꞊jɩ' pʋ. ");
INSERT INTO ktj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, 'bʋ pʋ ‑mʋ ꞊jɩ', 'kɩ ‑di 'lɩ ꞊jɩ' a 'mʋ nɩ, 'wliyɛ a pɛpɛ a 'mʋ, ꞊ble kʋa, ꞊mʋ꞊ʋ 'pɛɛ ‑nɩ, 'tɩ‑ ꞊mʋ 'lɩ ꞊jɩ' 'hrɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ti a 'mʋ 'yri, nyibli ꞊dʋ, nʋ‑ mu 'lɩ ‑Yusu ‑mɔ, 'ʋ 'bɛti꞊e, 'kɩ 'ʋ nyibli ‑bɩ a ‑ta', ‑ʋ 'ti 'lɩ Galileblʋgba 'kwli. Nyibli a 'mʋ, ti ‑mʋ' kɔ 'yri ʋ yɩ la 'ʋ ‑cɔhlʋn* ‑pii ‑nɩ, 'kɩ 'ʋ Nyɩsʋa ye', 'kɩ ‑gʋlʋnʋma Pilatɩ lee la 'a 'sɛyo, 'kɩ bʋ 'la la ꞊nʋ, 'waa ‑hlʋ ‑mʋ', ‑ɛ 'wlɛ bʋ, 'ɛ bi 'lɩ ‑cɔhlʋn a mʋma a ‑hlʋ 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Bʋ 'bɛti 'kɩ ‑Yusu, ‑ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ‑wɔn, ɛ wɛn: «꞊Bɩ a pʋ꞊ʋ ꞊haan‑tɩ, ‑ɛ mɔ, Galilekʋɛ a 'mʋ, ‑tɛ ʋ nu la 'waa 'lɩla, ɛ ꞊hɛn 'nyrɛ, ‑ɛ mɔ, 'waa dɛ 'kuku, ʋ ‑nu, ɛ ‑hʋ nɩ dɩakɩ, 'ɛ ‑hi 'ʋ 'waa 'bio Galilekʋɛ a ‑nɛ 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","'Ʋʋn‑, kɛ‑ 'n pɩ 'a mʋ yɩ, 'bʋ mɔ, 'ba 'yɩ 'ʋ 'aan dɛ 'kuku, a ni bʋ ‑hie, 'ba 'yɩ 'aan 'klɔ a pɛpɛ Nyɩsʋa ‑nyi, kɛ‑ a di 'kʋkʋʋ nu ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kʋɛ 'ʋ꞊ʋ ‑mɔ de, nyibli nɩ ‑pu ꞊tu 'ʋ ꞊blɩɛn꞊blɩɛn, ‑ʋ 'kʋ, 'kɩ 'lɩ Jrusrɛdɩɔ 'kwli, 'waa ‑tɩ bʋ bi 'lɩ 'a mʋ 'kwli. Yɔ'kayu ‑mʋ', ‑ɛ ꞊hɩan 'lɩ ‑mɔ lɛ, ‑ɛ nɩ 'lɩ Jrusrɛdɩɔ a 'kʋtɩɔ ‑mʋ', ʋ dɛɛ Siloe 'kwli, nɔ‑ bi la ꞊nʋ kɩ, 'ʋ 'kʋ la. ꞊Bɩ a pʋ꞊ʋ ꞊haan‑tɩ de, ‑ɛ mɔ, ɛ ꞊hɛn 'nyrɛ, 'waa dɛ 'kuku, ʋ ‑nu, ɛ ‑hʋ nɩ dɩakɩ, 'ɛ ‑hi 'ʋ 'waa 'bio Jrusrɛkʋɛ a ‑nɛ 'ʋ? ");
INSERT INTO ktj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","'Ʋʋn‑, kɛ‑ 'n pɩ 'a mʋ yɩ, 'ba 'yɩ 'ʋ 'aan dɛ 'kuku, a ni bʋ ‑hie, 'ba 'yɩ 'aan 'klɔ a pɛpɛ Nyɩsʋa ‑nyi, kɛ‑ a di 'kʋkʋʋ nu ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","‑Ɛ ‑bɩ ‑Yusu pʋ ꞊nʋ 'ledʋ yɩ de, ɛ wɛn: «Nyɩbɛyu ꞊dʋ, nɔ‑ 'dɔ figietu, ‑ɛ mɔ tugbɛ, ‑ɛ tʋɩ 'kui, 'kɩ 'lɩ 'a ‑ci kɩ. Ti ‑hʋɔhʋɩ bʋ ‑hi, ‑ɛ ‑bɩ ‑cikɔnyɔ a 'mʋ, ɛ di nɩ, ɛ 'mʋ tugbɛ a 'mʋ, 'a 'kui ‑ha, kɛɛ, ɛ 'yɩ 'lɩ꞊ɩ 'kuo nɩ ‑do yra bʋ ‑yɛɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ 'kɩ ‑ci'yie꞊tunyɔ yɩ, ɛ wɛn: 'Ye kɛ, 'a 'yrɩ nɩ ta a 'yrʋ ‑bʋ, ‑tɛ 'n ‑tʋa la 'nɛ‑ lɛdidie, 'mʋ tugbɛ ‑bʋ, 'a 'kui ‑ha. Kɛɛ, 'nɩ ‑di, 'nɩ ‑yɛɛ 'lɩ꞊ɩ 'kuo nɩ ‑do yra bʋ. 'A ‑tɩ, hla꞊a, ‑ɛ nu꞊o, ɛ nɩ 'nɛ‑ ‑tʋtʋkʋtɩɔ ‑bʋ kɩ dadʋ. ");
INSERT INTO ktj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kɛɛ ‑ɛ ‑bɩ ‑ci'yie꞊tunyɔ ꞊tu꞊o ꞊wɔn, ɛ wɛn: ‑Ha꞊a mɛ lɛ, 'yrʋ ‑bʋ bʋ ‑hi. 'N di 'blu꞊o 'hʋɩ lɛ, 'mʋ 'lɩ ‑pla yrayrɩ pʋ. ");
INSERT INTO ktj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","'Nɩ nu 'kɩ꞊ɩ, 'n pʋ꞊ʋ ꞊haan‑tɩ, 'yrʋ, ‑ɛ yɩ 'lɩ di, ɛ di 'nɩ tʋ. 'Bʋ 'yɩ 'kɩ ‑tʋ, ‑ɛ ‑bɩ ‑wɛ 'lɩ ‑bʋ hla꞊a nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ɛ kɔ la ‑wuwle‑nyrɔwɔ ꞊dʋ, ‑Yusu 'ɛ tʋɛ la nyibli Nyɩsʋa a ‑tɩ, 'kɩ 'lɩ Nyɩsʋa a 'kayu bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ɛ kɔ nʋgba ꞊dʋ. Nɔ‑ 'ku ‑hʋan* nɩ 'ʋ ke'. 'Ku ‑hʋan a 'mʋ, nɔ‑ pʋ꞊ʋ 'kʋɛ. 'Kʋɛ a 'mʋ, 'a 'yrɩ nɩ ‑pu ꞊tu 'ʋ ꞊blɩɛn꞊blɩɛn a 'yrʋ, nɔ‑ ‑bʋ. Ɛ 'kli yɩ. Ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ 'hrɩ 'lɩ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","‑Tɛ ‑Yusu 'ye꞊e, ‑ɛ ‑bɩ ɛ da꞊a nɩ, ɛ wɛn: «Nʋgba o, ‑na 'kʋɛ ‑wɛ nɩ,» ");
INSERT INTO ktj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","'ɛ pʋ꞊ʋ dabʋ 'lu bʋ. ‑Ɛ ‑bɩ ti nɩ ‑do a ti 'yri, ɛ ‑tʋa lɛ'hɩhrɩɩ. Ɛ nɔ‑ ‑mɔ bʋ pʋ Nyɩsʋa 'nyrɛ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kɛɛ, Nyɩsʋa a 'kayu a nyiblo gbagbʋ, ‑ɛ nɩ 'ʋ, ‑tɛ ɛ 'ye dɛ a 'mʋ, ‑Yusu ‑nu, ‑ɛ ‑bɩ ɛ kɔ yrʋ'bibie dɩakɩ, ‑tɛ ɛ mɔ ‑wuwle‑nyrɔwɔ a ‑tɩ, 'tɩ‑ ‑Yusu nu꞊o, nyiblo a 'kʋɛ 'ɛ ‑wɛ. ‑Ɛ ‑bɩ kɛ‑ nyiblo gbagbʋ a 'mʋ, ɛ pɩ 'kɩ nyibli ‑hʋɔhʋɩ ‑mʋ' yɩ, ‑ʋ nɩ 'ʋ, ɛ wɛn: «'Kɩ 'lɩ 'wee 'kwli, ‑nyrɔwɩ nɩ ꞊hlon‑do, nʋ‑ nɩ 'lɩ, ‑ɛ kɔ 'kwli ‑tonyibli blɛɛ yɩ bʋ nuu 'lɩ ‑kʋan. 'A ‑tɩ, 'kɩ 'lɩ ‑nyrɔwɩ a 'mʋ 'kwli, 'kɩ ba di 'lɩ, ɛ 'mʋ꞊ʋ nu, 'aan 'kʋɛ 'mʋ ‑wɛ. 'Ba yɩ nɩ di, a 'nɩ 'yaa 'lɩ ‑wuwle‑nyrɔwɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","‑Ɛ ‑bɩ kɛ‑ Kʋkɔnyɔ pɩ꞊ɩ yɩ, ɛ wɛn: «'A mʋ ‑bʋ, ‑ʋ nɛɛ 'li nɩ 'hʋɛn. Nyiblo 'bʋ kɔ bli kɔ 'a ‑nɛ 'wlugbadɛ ꞊dʋ, ꞊bɩ ɛ 'nɩ ꞊wlɛ꞊ɛ lɩ꞊ɩ nɩ, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli, ‑ɛ di꞊e nu, ɛ 'mʋ 'lɩ꞊ɩ 'naalɛ' gba? ");
INSERT INTO ktj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","'Tɩ‑ nʋgba ‑bʋ, ‑ɛ mɔ ‑aan 'baɩ gbagbʋ Abrahamʋ a 'yonʋ a 'yu ‑bɩ, Satan mʋa ‑nɩ, 'kɩ 'lɩ 'yrɩ nɩ ‑pu ꞊tu 'ʋ ꞊blɩɛn꞊blɩɛn 'kwli, ꞊bɩ ɛ 'yɩ yɩnɔdɛ 'pa‑, 'kɩ ꞊bʋ nu꞊o, 'a 'kʋɛ bʋ ‑wɛ, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli?» ");
INSERT INTO ktj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","‑Yusu bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ‑tʋɩ ‑tʋa 'a yraanyibli a nunuo dɩakɩ. Kɛɛ, nyibli ‑bɩ ‑mʋ', ‑ʋ nɩ 'ʋ, ʋ kɔ plɔ a bleelɛ, 'kɩ 'ʋ yɩnɔ‑tɛblɩ a pɛpɛ a 'mʋ, ‑Yusu ni a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ, ɛ wɛn: «'N di pʋ 'ledʋ, 'mʋ 'a mɔ꞊ɔ ‑tɔɔ ‑nɩ, ‑tɛ Nyɩsʋa ni, 'ɛ kɔɔ nyibli dodoyo win kɩ, 'tɩ‑ nyibli 'ʋ yɩ klɛ ‑bii ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Dɛ a 'mʋ, ɛ 'wɩ‑ 'dʋdɔdɛ ‑mʋ' yɩ, ‑ɛ kɔ 'yɛɛ ꞊cɩmɩ ‑nɩ dɩakɩ, 'ɛ ‑hi 'ʋ 'dʋdɔ‑tɛblɩ ‑bɩ a 'yɔ 'ʋ. 'Dʋdɔdɛ a 'yɛɛ a 'mʋ, ɛ nɔ‑ nyiblo ꞊dʋ ‑gba, 'ɛ 'dɔɔ 'lɩ꞊ɩ 'a ‑ci kɩ, 'ɛ ꞊mɩ, 'ɛ ‑hɛ tugbɛ gbagbʋ, ‑ɛ kɔ babʋɩ 'nyɩ nʋblɩ pɩɩ 'lɩ 'lʋɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ de, ɛ wɛn: «꞊Bʋ pʋ 'ledʋ ‑bɩ, 'mʋ 'a mɔ꞊ɔ ‑tɔɔ ‑nɩ, ‑tɛ Nyɩsʋa ni, 'ɛ kɔɔ nyibli dodoyo win kɩ, 'tɩ‑ nyibli ‑bɩ 'ʋ yɩ klɛ ‑bii ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Dɛ a 'mʋ, ɛ 'wɩ‑ 'flɔɔ a 'yaadɛ yɩ, nʋgba ꞊dʋ pʋ 'lɩ 'flɔɔpupu ‑hʋɔhʋɩ ‑mɔ, 'tɩ‑ 'ɛ nyʋa꞊a ‑nyʋanyʋa, 'flɔɔ a pɛpɛ a 'mʋ 'ɛ 'ya.» ");
INSERT INTO ktj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ 'tɩɛ nɩ 'lɩ Jrusrɛdɩɔ a 'hru wlɔn. ‑Tɛ ɛ ni, 'ɛ yɩ 'dɩɩ ꞊tɩɔ lɛ 'bɛ, kɛ‑ ɛ ni, 'ɛ tʋɛ Nyɩsʋa a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ɛ kɔ la ‑nyrɔwɔ ꞊dʋ, nyiblo ꞊dʋ 'ɛ 'bɛti la꞊a, ‑ɛ mɔ: «'Masɛ o, ꞊bɩ ‑tonyibli ‑bʋ, Nyɩsʋa di wa, ‑batipʋ‑nyrɔwɔ 'bʋ nyre 'ʋ, ꞊bɩ ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ ‑hʋ?» ‑Ɛ ‑bɩ nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, ɛ ꞊tu ꞊nʋ ‑wɔn, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Paalɛ ‑mʋ', ‑ɛ pʋɛ 'lɩ 'a mʋ Nyɩsʋa a 'klɔ yrayrʋ 'kwli, ɛ 'cɩmɩ 'yri lɛ. 'Bʋ mɔ, 'ba yɩ꞊ɩ nɩ ‑hʋɛ, 'kɩ ba pa 'lɩ Nyɩsʋa a 'klɔ yrayrʋ a 'mʋ 'kwli, ‑ɛ ‑bɩ ba ꞊tu 'ʋ 'klɩ, a 'mʋ 'ʋ paalɛ a 'mʋ 'yri ‑naa ‑nɩ. 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, nyibli ‑hʋɔhʋɩ di꞊e 'nɩ ‑hʋa, 'kɩ bʋ pa 'lɩ Nyɩsʋa a 'klɔ yrayrʋ a 'mʋ 'kwli. Kɛɛ, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Dɛ ɛ di yɩ 'wɩ, ɛ nɔ‑ ‑bʋ: 'Kɩ 'kayukɔnyɔ di 'lɩ 'kayu 'kwli nɩ, ɛ 'mʋ 'maju ꞊gba. 'A mʋ ‑mɔ ‑bɩ, 'kɩ a di 'lɩ ‑patʋ' nɩ, a 'mʋ 'maju ‑bibi ‑nɩ, a 'mʋ lɛ pʋ ‑wɛ: Kʋkɔnyɔ o, ‑ha ‑a mʋ 'maju yɩ, ɛ 'mʋ lɛ pʋ, ɛ 'mʋ 'a mʋ ꞊wɔn ꞊tu: 'N 'yɩ 'a mʋ ‑yi. ");
INSERT INTO ktj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","‑Ɛ ‑bɩ kɛ‑ a di pʋ: ‑Kɔ ‑a mʋ 'hʋɛn‑, ‑a mʋ yɩ la 'ʋ ‑tɩtɛ nɩ ‑do dɛ ‑dii ‑nɩ, kɔ, ꞊nɩ tʋɛ la Nyɩsʋa a ‑tɩ, 'kɩ 'lɩ ‑aan 'dɩɩ a 'dika. ");
INSERT INTO ktj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kɛ‑ ɛ di 'a mʋ yɩ pʋ de: 'N 'yɩ 'a mʋ ‑yi, ba hlɔɔ 'mʋ ‑mɔ lɛ, ‑ɛ nu꞊o, 'aan pɛpɛ ‑mʋ', yɩnyre‑tɛblɩ Nyɩsʋa 'yɛ nɩ ‑hʋa ba nu, ɛ nɔ‑ a ni. ");
INSERT INTO ktj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ti nɩ ‑do a 'mʋ 'yri, a di 'ye 'aan 'baɩnʋ Abrahamʋ, Yisakɩ kɔ Sakɔbʋ 'hʋɛn‑, ʋ kɔ Nyɩsʋa a winwlɔn‑hanyʋ* a pɛpɛ, 'kɩ 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli. 'A mʋ ‑mɔ ‑bɩ, ʋ di pʋ 'lɩ 'a mʋ ‑patʋ'. 'Kɩ a di 'ʋ ꞊hien ‑wee ‑nɩ, kɔ, 'kɩ a di 'ʋ yrʋ ‑pʋʋ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ti a 'mʋ 'yri, 'klɔ ‑bʋ, 'a ꞊gɛ nɩ ‑hɛn 'yri, 'kɩ nyibli di 'lɩ lɛ ‑hɔn, ʋ 'mʋ lɛ 'kukue ‑nɩ, ʋ 'mʋ dɛ ‑mɔ ‑didi ‑nɩ, 'kɩ 'lɩ Nyɩsʋa a 'klɔ yrayrʋ a 'mʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nyibli ‑bɩ, ‑ʋ nɩ 'lɩ 'waa 'bio bʋ, 'kɩ 'lɩ ‑tɛ ti nɛ ‑bʋ 'kwli, nʋ‑ di 'lɩ 'waa 'bio 'lu yɩ nɩ ‑nyrɔwɔ ꞊dʋ, kɔ, nyibli ‑bɩ, ‑ʋ nɩ 'ʋ 'waa 'bio 'lu yɩ, 'kɩ 'lɩ ‑tɛ ti nɛ ‑bʋ 'kwli, nʋ‑ di 'lɩ 'waa 'bio bʋ nɩ ‑nyrɔwɔ ꞊dʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ti nɩ ‑do a ti 'yri, Falisi꞊tumu* a nyibli ꞊dʋ, nʋ‑ 'yɩya 'ʋ ‑Yusu 'hʋɩ bʋ, 'ʋ lee ꞊nɛ, ʋ wɛn: «‑Tɩtɛ ‑bʋ, ‑nɩ mɔ, ‑hɔn mɔ ‑wlu, ‑bʋ mu 'lɩ ‑tɩtɛ ‑bɩ, ‑ɛ nu꞊o, 'kɩɩn Helɔdɩ ꞊mʋɛ ‑na 'lɩla lɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «Ba mu, ba lee Helɔdɩ a 'mʋ, ‑ɛ kɔ ‑yrʋkʋ, ‑wɛn 'gbekle, ‑ɛ mɔ: Kɩkɛ ‑bʋ, kɔ ‑ŋɩŋa 'hʋɛn‑, 'n blɛ 'kuo ‑hʋɩn* lɛ, ‑ʋ nɩ 'ʋ nyibli ke', ɛ kɔ, 'n ni꞊e nɩ, nyibli a 'kʋɛ 'ɛ yɩ ‑wɛ, ꞊nyrɛɛ, 'tɩ‑ 'mʋ 'na ‑kʋan 'lu ‑yra. ");
INSERT INTO ktj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kɛɛ, kɩkɛ, ‑ŋɩŋa, kɔ ꞊nyrɛɛ, 'n kɔ ꞊bʋ gba 'na ‑kʋan 'lu ‑mɔ, 'mʋ 'lɩ Jrusrɛdɩɔ 'kwli nyre, ‑ɛ nu꞊o, ɛ 'yɩ 'ʋ lɛ ‑nɔɔ ‑nɩ, 'kɩ bʋ 'la Nyɩsʋa a winwlɔn‑hanyɔ*, 'kɩ 'lɩ ‑tɩtɛ ‑bɩ, 'bʋ 'yɩ 'lɩ Jrusrɛdɩɔ 'kwli 'pa‑. ");
INSERT INTO ktj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","'N yɩ Jrusrɛ a nyibli 'nɩ ‑lee ‑nɩ: Nyɩsʋa 'bʋ lee 'nɛ‑ 'a mʋ 'a winwlɔn‑hanyʋ ‑mɔ, a pɩ ꞊nʋ 'hɩ ‑mɔ lɛ, 'a 'lɛ ꞊nʋ. 'N ‑hʋɛ mɔ꞊ɔ nɩ 'a ‑nɛ ti, ꞊bʋ 'kukue mɔ 'a mʋ lɛ, kɩ mɔ 'mʋ 'hʋɩ, ꞊wɩ yɩ, ‑tɛ hapɛ'gba ni, 'ɛ yɩ 'a 'yonʋ lɛ 'kukue ‑nɩ, 'tɩ‑ 'ɛ yɩ ꞊nʋ kɩ bʋ ꞊jri, kɛɛ, a 'yɩ꞊ɩ kɩ ‑wɛn. ");
INSERT INTO ktj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ɛ nɔ‑ kɔ ‑tɩ, Nyɩsʋa 'mʋ 'ʋ 'aan 'dɩɔ bʋ hie, 'a mʋ nɩ ‑do, a 'mʋ 'aan dɩɔnʋ lɛ ‑kikle ‑nɩ. 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, kʋɛ 'kɩ mɔ bʋ, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba 'ye 'kɩ 'mʋ de, ɛ 'mʋ꞊ʋ gba ‑gbagba, ti 'mʋ 'ʋ nyre, ‑ɛ kɔ 'yri a di lɛ pʋ: ‑Na 'wio, ‑mɔ ‑bʋ, ‑ɛ yɩ 'lɩ di, 'kɩ 'lɩ Kʋkɔnyɔ Nyɩsʋa a 'nyrɛ 'kwli. Nyɩsʋa bʋ ‑nyi ‑mʋ ‑tɩ a 'yi'bʋbʋa.» ");
INSERT INTO ktj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","‑Nyrɔwɔ ꞊dʋ 'kwli, Falisi꞊tumu* a nyiblo gbagbʋ ꞊dʋ, nɔ‑ da la ‑Yusu diidɛ ‑mɔ. ‑Tɛ ‑Yusu pa 'lɩ 'a 'kayu bʋ, ‑ɛ ‑bɩ Falisi꞊tumu a nyibli, ‑ʋ nɩ 'ʋ, ʋ ‑tʋa 'a ‑gbɛɛlɛ. ");
INSERT INTO ktj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","'Kɩ 'lɩ ‑tɛ a 'mʋ, 'kɩ nyɩbɛhɩan ꞊dʋ nyra 'ʋ꞊ʋ ye' bʋ. Nyɩbɛhɩan a 'mʋ, 'kʋɛ ni꞊e nɩ. Ɛ 'yii 'lɩ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nyɩsʋa a tetetɔɔnyʋ kɔ Falisi꞊tumu a nyibli 'hʋɛn‑, ‑ʋ nɩ 'ʋ, kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ: «‑Aan tete hlɛ꞊ɛ nɩ, ꞊bɩ ɛ nɔɔ 'ʋ lɛ, ‑ʋ'ʋ‑, ɛ 'yɩ 'ʋ lɛ ‑nɔɔ ‑nɩ, 'kɩ nyiblo bʋ nu꞊o, 'hʋɩhrennyɔ a 'kʋɛ bʋ ‑wɛ, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli?» ");
INSERT INTO ktj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kɛɛ ‑ɛ ‑bɩ ʋ 'nɩ ‑hʋa꞊a lɩ꞊ɩ bʋ ꞊tu꞊o ꞊wɔn. Ɛ nɔ‑ mɔ, ‑Yusu bʋ ‑hrɛn 'hʋɩhrennyɔ a 'mʋ lɛ, bʋ nu꞊o, 'a 'kʋɛ bʋ ‑wɛ, 'tɩ‑ bʋ lee ꞊nɛ, ‑ɛ mɔ: «‑Na 'kʋɛ ‑wɛ nɩ. ‑Wɛ 'lɩ ‑bʋ mu 'lɩ ‑na 'kayu bʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «'Kɩ 'lɩ 'a mʋ 'nyɩ, nyiblo a 'yu ‑hʋʋ' 'a bli 'bʋ bi 'lɩ 'niebutɩɔ 'kwli, ɛ di 'lɩ꞊ɩ 'nɩ ‑ha ti nɩ ‑do a ti 'yri, 'ye ꞊bɩɩ ɛ mɔ ‑wuwle‑nyrɔwɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","‑Tɩ a 'mʋ, ‑Yusu ‑hla, ʋ 'nɩ 'ye꞊e lɩ ‑tɩ bʋ di꞊e ꞊wɔn ꞊tu. ");
INSERT INTO ktj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","‑Tɛ ʋ nɩ 'kɩ 'ʋ dɛdiilɛ', ‑ɛ ‑bɩ ‑Yusu ‑gbɛɛ ꞊nɛ nɩ, ‑ɛ mɔ, nyibli a pɛpɛ, 'kayu a 'baɩ da wɛn, 'kɩ ʋ nɩ 'ʋ꞊ʋ 'hʋɩ bʋ. ‑Ɛ ‑bɩ ɛ pɩ ꞊nʋ ꞊tɔ', 'ɛ pʋʋ ꞊nɛ 'blɩpadiidɛ a dɛ yɩ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«'Bʋ mɔ, nyiblo 'bʋ da ‑mʋ 'blɩpadiidɛ kɩ, ꞊nɩ 'mʋɔ 'lɩ꞊ɩ lɛ, 'kɩ ‑bʋ nɩ 'ʋ nyiblo ‑mʋ', ‑ɛ da ‑mʋ 'hʋɩ bʋ. ‑Baklɛ, ɛ da wɛn nyiblo ‑bɩ, ‑ɛ nɩ 'ʋ ‑mʋ 'lu yɩ, ");
INSERT INTO ktj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","'tɩ‑ nyiblo a 'mʋ, ‑ɛ da wɛn 'a mʋ nɩ 'hʋɛn a 'mʋ, ɛ 'mʋ ‑mʋ ‑lee ‑nɩ: 'Du ye', nyiblo ‑bʋ, ɛ 'mʋ mɔ 'mʋ 'hʋɩ bʋ nɩ. ꞊Nɩ kɔ ‑bʋ ‑hlɔɔ ꞊nɛ ‑mɔ lɛ, ‑bʋ nɩ bʋ, ‑tʋɩ di ‑mʋ 'nɩ nu. ");
INSERT INTO ktj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ɛ 'nɩ 'nɩɩ 'lɩ 'mʋ lɛ, kɛɛ, 'bʋ da ‑mʋ, ꞊nɩ yɩ bʋ nɩ nɩ, nyiblo a 'mʋ, ‑ɛ da ‑mʋ, hlɔɔ ꞊nɛ ‑mɔ lɛ, ‑ɛ di꞊e nu, ti ‑mʋ' ‑kɔ 'yri ɛ di 'ʋ ‑dii ‑nɩ, ɛ 'mʋ ‑mʋ ‑lee ‑nɩ: 'Bɩhɩan o, di mɔ 'mʋ 'hʋɩ, ꞊mʋ bʋ nɩ. Dɛ a 'mʋ, nɔ‑ di꞊e nu, ꞊mʋ yrɛ'bʋbʋa kɔ, 'kɩ 'ʋ nyibli a pɛpɛ ‑mʋ' ye', ‑ʋ kɔ ‑mʋ 'hʋɛn‑ a nɩ 'ʋ dɛdiilɛ', ");
INSERT INTO ktj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","‑ɛ nu꞊o 'a ‑nɛ nyiblo 'bʋ nɩ 'ʋ, 'bʋ yɩ 'lɩ 'a dɩɔnʋ nɩ 'yɛɛ ‑nɩ, ʋ di 'lɩ꞊ɩ 'nɩ ꞊tɩɔ ‑nɩ, kɔ, nyiblo 'bʋ nɩ 'ʋ, 'bʋ yɩ 'lɩ 'a dɩɔnʋ nɩ ꞊tɩʋɛ ‑nɩ, ɛ nɔ‑ ʋ di 'lɩ 'yaa ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","‑Yusu bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ kɛ‑ ɛ pɩ 'kayu'baɩ yɩ, ‑ɛ da꞊a diidɛ ‑mɔ, ɛ wɛn: «'Bʋ mɔ, ꞊nɩ yɩ nyibli lɛ'mlediidɛ ‑mɔ nɩ dɛ, ꞊nɩ 'daa 'lɩ ‑na nɩnatumupʋ nɩ ‑do, kɔ ‑na 'dɩayɩnʋ, kɔ ‑na ꞊tugba a nyibli, kɔ ‑na 'dɩɔ 'kwli a nyibli nɩ ‑do, ‑ʋ mɔ dɛkɔnyibli, ‑ɛ nu꞊o, dɛ ‑mʋ', ‑di ꞊nʋ ‑mɔ nu, ʋ ‑wɛ 'lɩ bʋ nu ‑mɔ꞊ɔ ‑mɔ nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","'Bʋ mɔ, ꞊nɩ yɩ nyibli lɛ'mlediidɛ ‑mɔ nɩ dɛ, ‑ɛ ‑bɩ da ꞊hɩʋɛnnyibli, kɔ nɩanɩnyʋ, kɔ lɛ‑yɩyrɛnyibli, kɔ 'yii'dɔnyʋ 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","'Bʋ mɔ, ꞊nɩ yɩ꞊ɩ nɩ ni, ‑di kɔ plɔ a bleelɛ, ‑ɛ nu꞊o, dɛ a 'mʋ, ‑di ꞊nʋ ‑mɔ nu, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ nu ‑mɔ꞊ɔ ‑mɔ ‑wɛ. Kɛɛ, Nyɩsʋa, nɔ‑ di ‑mʋ 'a 'wio ‑nyi, ‑nyrɔwɔ ‑mʋ', ɛ di 'lɩ nyibli ‑mʋ', ‑ʋ 'sii 'ʋ yɩ 'kʋkʋnyibli 'nyɩ ‑haa ‑nɩ, ɛ di ꞊nʋ 'klɔ ‑ha.» ");
INSERT INTO ktj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","‑Tɛ ‑Yusu hla ‑tɩ a 'mʋ, ‑ɛ ‑bɩ nyiblo ꞊dʋ nɩ 'lɩ nyibli ‑mʋ' 'nyɩ, ‑ʋ nɩ 'ʋ dɛdiilɛ', 'ɛ yɩ ‑Yusu ‑lee ‑nɩ, ɛ wɛn: «Plɔ a bleelɛ 'kɩ 'ʋ nyibli ‑mʋ' ‑mɔ, Nyɩsʋa di 'a ‑dina kɩ da ‑nyrɔwɔ ꞊dʋ, 'kɩ 'lɩ 'a 'klɔ yrayrʋ ‑mʋ', ɛ di nu 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ɛ nɔ‑ mɔ ‑Yusu bʋ pʋ nyiblo a 'mʋ 'ledʋ yɩ, ɛ wɛn: «Ɛ kɔ la nyiblo ꞊dʋ. Nɔ‑ lee nyibli ‑hʋɔhʋɩ lɛ, ‑ɛ mɔ, ɛ di da ꞊nʋ ‑dina kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","‑Tɛ dɛditi nyre 'ʋ, ‑ɛ ‑bɩ ɛ lee nɛ 'a ‑kʋannunyɔ, 'kɩ bʋ lee nyibli ‑mʋ', ɛ da wɛn, ‑ɛ mɔ, diidɛ ‑wɛ ‑mɔ, bʋ di 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kɛɛ, nyibli a pɛpɛ a 'mʋ, ʋ ꞊tu꞊o ꞊wɔn, ‑ɛ mɔ, ʋ 'yɩ 'lɩ didie 'lɩ ‑wɛ. Yɩ‑hɛnyiblo, ɛ lee ‑kʋannunyɔ a 'mʋ nɩ, ‑ɛ mɔ: 'N ‑tɔ 'na ‑ci. 'N kɔ ꞊bʋ mu꞊o 'ye. 'A ‑tɩ, ‑kɔ 'ʋ ꞊wɔn, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ di 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","‑Ɛ ‑bɩ 'hʋɛn a nyiblo wɛn: 'N ‑tɔ blo nɩ ‑pu. 'N kɔ ꞊bʋ mu ꞊nʋ 'ye. 'A ‑tɩ, ‑kɔ 'ʋ ꞊wɔn, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ di 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ta a nyiblo wɛn 'nɩ: 'Mɔ ꞊tɩɛ ‑pa 'blɩ. Ɛ nɔ‑ nu꞊o, 'kɩ 'n 'yɛ nɩ di 'lɩ nɩ di. ");
INSERT INTO ktj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ɛ nɔ‑ mɔ ‑kʋannunyɔ a 'mʋ, bʋ ꞊hɩan ‑mɔ, bʋ lee nɛ 'a 'masɛ ‑tɩ a pɛpɛ a 'mʋ, nyibli a 'mʋ, ʋ ‑nu, 'ʋ ꞊tu꞊o ꞊wɔn. ‑Tɛ 'masɛ 'wɩn ‑tɩ a 'mʋ, ɛ kɔ yrʋ'bibie dɩakɩ, 'ɛ lee nɛ 'a ‑kʋannunyɔ, ɛ wɛn: 'Kɩka ‑nɩ, ‑bʋ mu 'lɩ 'dika, ɛ kɔ, ‑bʋ ꞊glaa 'lɩ 'dɩɔ 'lɩ, ‑bʋ ‑wɛ ꞊hɩʋɛnnyibli kɔ nɩanɩnyʋ, kɔ 'yii'dɔnyʋ, kɔ lɛ‑yɩyrɛnyibli ti kɩ, bʋ di 'lɩ, ");
INSERT INTO ktj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","‑kʋannunyɔ a 'mʋ 'ɛ ‑mu, 'ɛ da ꞊nʋ lɛ, 'tɩ‑ 'ɛ ꞊hɩan ‑mɔ, 'ɛ lee nɛ 'a 'masɛ, ɛ wɛn: Dɛ ‑tɛ wɛn 'mʋ ‑mɔ, 'n nu꞊o nɩ. Kɛɛ, kɩbʋnɩ‑tɛblɩ 'tɩɛ hie blɛ. ");
INSERT INTO ktj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","‑Ɛ ‑bɩ 'kayukɔnyɔ ꞊tu꞊o ꞊wɔn, ɛ wɛn: ꞊Tɩ 'dɩɔ, ‑bʋ pa 'lɩ 'hrii wlɔn lɛ, 'a ‑nɛ nyiblo, ‑di 'lɩ bʋ ‑yɛɛ ‑nɩ, nɩ 'ʋ꞊ʋ ke', bʋ di 'lɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","'Tɩ‑ ‑Yusu 'mʋ ‑yrɛ mɔ mu, ‑ɛ ‑bɩ ɛ wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, yɩ‑hɛnyibli ‑mʋ', 'n ‑da, 'kɩ 'lɩ ꞊nʋ 'nyɩ, ɛ kɔ nyibli ‑bɩ, 'a nyiblo nɩ ‑do 'nɩ ꞊die ‑hʋan 'na ‑dina a 'mʋ kɩ nɩ, 'kɩ 'lɩ 'klɔ yrayrʋ ‑mʋ' 'kwli, Nyɩsʋa di nu.» ");
INSERT INTO ktj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ɛ kɔ la ‑nyrɔwɔ ꞊dʋ, nyibli ‑hʋɔhʋɩ, nʋ‑ kɔ ‑Yusu 'hʋɛn‑, ‑ʋ nɛ la 'hru. ‑Yusu bʋ ꞊hɩan ‑mɔ, ‑ɛ ‑bɩ ɛ ‑tʋa 'waa leelɛ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«'Bʋ mɔ, nyiblo 'bʋ ‑hʋɛ bʋ di 'nɛ‑ 'mʋ 'hʋɩ, ɛ 'mʋ 'na ‑nagbopi ‑hɛ a ‑tɩ, ɛ kɔ bʋ nʋɛ 'mʋ, bʋ ‑hi 'ʋ 'a 'baɩ kɔ 'a 'dii 'hʋɛn‑ 'ʋ, kɔ 'a nʋgba, kɔ 'a 'yonʋ, kɔ 'a 'dɩayɩnʋ, ɛ kɔ 'a dɩɔnʋ. 'Bʋ 'yɩ꞊ɩ 'pa‑, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑hɛ 'na ‑nagbopi. ");
INSERT INTO ktj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nyiblo 'bʋ 'yɛ nɩ ꞊tuu 'ʋ 'na win 'ʋ, mɔ 'ye ꞊bɩɩ ʋ pʋ lɛ, ʋ 'mʋ꞊ʋ 'la, ‑tɛ ɛ mɔ 'na nyiblo a ‑tɩ, ‑ɛ ‑bɩ nyiblo a 'mʋ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑hɛ 'na ‑nagbopi. ");
INSERT INTO ktj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","꞊Bʋ pʋʋ ꞊nɛ 'kayupʋnyɔ a dɛ yɩ. ꞊Nɩ ‑hʋɛ ‑bʋ pʋ 'kayu gbagbʋ, ꞊nɩ 'mʋ ‑kʋan ‑wlu ꞊tu, ‑yɩ nɩ bʋ, ꞊nɩ yɩ 'lu lɛ ‑hie, ꞊nɩ gbʋgbɛ 'a 'wliyɛ ‑mɔ lɛ, ‑di nu, ꞊mʋ 'kayu a 'mʋ pʋ, ‑ɛ di꞊e nu, ꞊mʋ꞊ʋ yi, 'bʋ mɔ, 'wliyɛ ‑hʋɔhʋɩ 'bʋ nɩ 'lɩ ‑mʋ ‑jɩ', ‑di nu, ꞊mʋ 'kayu a 'mʋ ‑mɔ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","'Bʋ mɔ, ꞊nɩ 'yɩ ‑tɛblɩ nɩ ‑tie a 'mʋ ‑nu, ꞊nɩ ꞊tu ‑kʋan a 'mʋ ‑wlu, 'tɩ‑ mu 'lɩ ye', ꞊nɩ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ‑bʋ ‑wɛ 'kayu a 'mʋ ‑mɔ, nyibli a pɛpɛ, ‑ʋ di dɛ a 'mʋ 'ye, ʋ di ‑mʋ 'nɩ 'caa ‑nɩ, ");
INSERT INTO ktj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ʋ 'mʋ lɛ pʋ: Nyiblo ‑bʋ, ɛ ꞊tu 'a 'kayu a pʋpʋʋ ‑wlu, kɛɛ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ ‑yra ‑kʋan a 'mʋ 'lu. ");
INSERT INTO ktj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","꞊Bʋ pʋ꞊ʋ bodɩɔ ꞊dʋ a dɛ yɩ ‑wɛ. Bodɩɔ a 'mʋ, 'bʋ 'mʋ tʋ kɩ mu, 'bʋ 'mʋ 'a 'bɩ bodɩɔ yɩ ‑wɔn mɔ mu, ɛ yɩ nɩ bʋ, 'ɛ yɩ 'lu lɛ ‑hie, 'bʋ mɔ, 'bʋ gba 'sɛyo a (10'000) 'miliwɩ nɩ ‑pu, 'bʋ ‑wɛ 'lɩ bʋ nyra 'a 'bɩ bodɩɔ yɩ bʋ, ‑ɛ gba 'sɛyo a (20'000) 'miliwɩ a ‑wlʋ. ");
INSERT INTO ktj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","'Bʋ mɔ, 'bʋ 'ye꞊e, ‑ɛ mɔ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, 'a 'bɩ bodɩɔ 'bʋ 'tɩɛ hlɔ 'lɩ ‑mɔ, tʋ 'bʋ 'tɩɛ 'yɛ nɩ 'bɛ, ɛ kɔ bʋ tɛ 'a lɛlenyɔ bʋ, 'kɩ bʋ mu 'a 'bɩ bodɩɔ a 'mʋ 'bɛti ‑nɩ: Dɛ a 'dɩ ‑bɩ ‑a di nu, 'tɩ‑ tʋ 'nɩ ꞊ha bʋ bi 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","'Tɩ‑ ‑Yusu 'mʋ ‑yrɛ mɔ mu, ‑ɛ ‑bɩ ɛ wɛn: «'A ‑tɩ o, 'kɩ 'lɩ 'a mʋ 'nyɩ, nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ ‑hɛ 'na ‑nagbopi, 'bʋ mɔ, 'bʋ 'yɩ ‑mɔ ‑wɛ, 'kɩ bʋ hie 'ʋ 'a kʋkɔ‑tɛblɩ a pɛpɛ bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","A yi꞊e nɩ, ‑ɛ mɔ, 'ta mɔ ꞊haandɛ ꞊nɩɔ. Kɛɛ, 'bʋ 'waan nɛ 'a wlɔnnɩnɔ, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ 'kɩ de, bʋ nu꞊o, bʋ nɔ 'kɩ wlɔn de. ");
INSERT INTO ktj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ɛ 'yɩ 'kɩ ‑kʋan ꞊dʋ ‑kɔ. Ʋ kɔ bʋ pʋ꞊ʋ 'wan. 'Ba kɔ ‑tɩ'wɩnnʋa, ‑ɛ ‑bɩ ba pʋ 'mʋ nʋa yɩ bʋ ‑dodo.» ");
INSERT INTO ktj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","‑Nyrɔwɔ ꞊dʋ, 'blʋwli'tɩnyʋ, kɔ hɩapʋnyibli, ‑ʋ kɔ 'klɔ 'yɩ 'ʋ yɩ 'sii ‑nɩ, ʋ nʋ‑ mu 'ʋ ‑Yusu 'hʋɩ, ‑ɛ di꞊e nu, 'bʋ yɩ win nɩ pɩ, ʋ 'mʋ 'a win nʋa yɩ bʋ pʋ, kɔ, ʋ 'mʋ 'a tɔɔwin 'wɩn. ");
INSERT INTO ktj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","‑Tɛ Falisi꞊tumu* a nyibli kɔ tetetɔɔnyʋ, ‑ʋ nɩ 'ʋ, ʋ 'ye dɛ a 'mʋ, ‑ɛ ‑bɩ ʋ bi yrʋ', 'ʋ ‑tʋa wlɔnlɛ'pʋplɛ lɛ, ʋ wɛn: «Nyibli ‑bʋ, ‑ʋ kɔ 'klɔ 'yɩ 'ʋ yɩ 'sii ‑nɩ, nʋ‑ ɛ yɩ 'ʋ 'hʋɩ lɛ ‑wlɛɛn ‑nɩ, ɛ kɔ ꞊nʋ 'hʋɛn‑, 'ʋ yɩ dɛ di ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","‑Tɛ ‑Yusu 'wɩn, ‑ɛ ‑bɩ ɛ pʋʋ ꞊nɛ dɛ yɩ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«'Kɩ 'lɩ 'a mʋ 'nyɩ, nyiblo 'bʋ kɔ blablɩ a (100) ‑wlɩ nɩ ꞊hun, 'bʋ gba ꞊nʋ 'cɛ mɔ, 'tɩ‑ blablɛ nɩ ‑do 'bʋ 'wan, dɛ a 'dɩ ‑bɩ ɛ di nu 'lɩ? Ɛ kɔ bʋ hie 'ʋ blablɩ a (99) ‑wlɩ nɩ ‑hɛn ꞊tu 'ʋ ‑pu ꞊tu 'ʋ ꞊hʋɩan‑do ‑mʋ' bʋ, 'kɩ 'lɩ 'cɛɛlɛ', ɛ 'mʋ blablɛ nɩ ‑do a 'mʋ lɛ ꞊mʋɔ ‑mʋɔmʋɔ, ɛ 'mʋ꞊ʋ kɩ yɛ. ");
INSERT INTO ktj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","'Bʋ yɛ꞊ɛ kɩ, 'a plɔ di 'nɩ ble, ɛ 'mʋ꞊ʋ ‑plɩ' bʋ pʋ, ");
INSERT INTO ktj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ɛ 'mʋ 'lɩ 'kayu bʋ mu, ɛ 'mʋ 'a 'bio da, nyibli ‑mʋ', ‑ʋ ꞊glaa 'lɩ꞊ɩ 'lɩ, ɛ 'mʋ ꞊nʋ da ‑wɛ, 'tɩ‑ ɛ 'mʋ ꞊nʋ ‑lee ‑nɩ, ‑ɛ mɔ: Ba bi 'mʋ kɩ, ‑ba nu dɔdʋ, 'na blablɛ, ‑ɛ 'wan wɛn, 'n 'ye꞊e nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","‑Ɛ ‑bɩ ‑Yusu wɛn 'nɩ: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, kɛ‑ nɩ ‑do, ɛ di 'mʋ ꞊ti, 'kɩ 'lɩ yakɔ 'kwli. Dɔdʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ nɩ 'lɩ yakɔ 'kwli, 'kɩ 'ʋ nyibli a (99) ‑wlɩ nɩ ‑hɛn ꞊tu 'ʋ ‑pu ꞊tu 'ʋ ꞊hʋɩan‑do, ‑ʋ pʋ lɛ, ‑ʋ 'sii 'ʋ yɩ, 'tɩ‑ ‑ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ‑bʋ ‑nyi 'waa 'klɔ Nyɩsʋa a ‑tɩ. Kɛɛ, dɛ'kukununyɔ nɩ ‑do 'bʋ hie 'ʋ 'a dɛ 'kuku bʋ, 'bʋ ‑ha 'lɩ 'a dɩɔnʋ a 'klɔ, 'bʋ ‑nyi꞊e Nyɩsʋa, ɛ nɔ‑ kɔ ‑tɩ, ʋ 'mʋ dɔdʋ nu, 'kɩ 'lɩ yakɔ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kɛ‑ ‑Yusu pɩ de, ɛ wɛn: «꞊Bʋ pʋʋ ꞊nɛ 'wliyɛ a dɛ yɩ: 'Bʋ mɔ, nʋgba 'bʋ kɔ 'wli a 'yɔ nɩ ‑pu, 'tɩ‑ 'bʋ 'waan nɛ 'a 'yɛ nɩ ‑do, ɛ kɔ bʋ 'bɩa 'napɩ, bʋ ‑ha 'kayu kʋɛtɩ blɛ, 'tɩ‑ ɛ 'mʋ 'wliyɛ a 'mʋ lɛ ꞊mʋɔ. ");
INSERT INTO ktj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","'Bʋ 'ye꞊e, ɛ kɔ bʋ da 'a 'bio, ɛ kɔ nyibli ‑mʋ', ‑ʋ ꞊glaa 'lɩ꞊ɩ 'lɩ, ɛ 'mʋ ꞊nʋ ‑lee ‑nɩ, ‑ɛ mɔ: Ba bi 'mʋ kɩ, ‑ba nu dɔdʋ, ‑ɛ nu꞊o, 'na 'wliyɛ, ‑ɛ 'wan wɛn, 'n 'ye꞊e nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'kɩ de: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, kɛ‑ ɛ di 'mʋ ꞊ti, 'kɩ 'lɩ Nyɩsʋa a lɛlenyʋ 'nyɩ, ‑ʋ nɩ 'lɩ yakɔ 'kwli. 'Bʋ mɔ, dɛ'kukununy nɩ ‑do 'bʋ hie 'ʋ 'a dɛ 'kuku bʋ, 'bʋ ‑ha 'lɩ 'a dɩɔnʋ a 'klɔ, 'bʋ ‑nyi꞊e Nyɩsʋa, ɛ nɔ‑ kɔ ‑tɩ Nyɩsʋa a lɛlenyʋ 'mʋ dɔdʋ nu, 'kɩ 'lɩ yakɔ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","‑Ɛ ‑bɩ ‑Yusu pʋ 'ledʋ ‑bɩ de, ɛ wɛn: «Ɛ kɔ la nyɩbɛhɩan ꞊dʋ, 'ɛ kɔ la 'yonʋ nyɩbɛpʋ nɩ 'hʋɛn. ");
INSERT INTO ktj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","‑Nyrɔwɔ ꞊dʋ, ‑ɛ ‑bɩ nyiblo ‑mʋ', ‑ɛ mɔ 'hɩangbe, ɛ lee nɛ 'a 'baɩ nɩ, ɛ wɛn: 'Na 'baɩ o, ꞊nɩ 'kʋ ‑hʋan, 'nɛɛ 'wliyɛ, ‑ɛ blɛɛ 'mʋ yɩ, 'n di ‑hʋan gba, ‑nyi 'mɔ꞊ɔ ‑dodo. ‑Tɛ 'yu a 'mʋ, ɛ hla ‑tɩ a 'mʋ, ‑ɛ ‑bɩ 'a 'baɩ ꞊gla la ꞊nʋ 'a 'wliyɛ a 'mʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","‑Nyrɔwɩ bʋ ‑hi, ‑ɛ ‑bɩ 'hɩangbe a 'mʋ, ɛ 'du la 'a ‑nɛ 'wliyɛ ye', 'ɛ mu 'lɩ 'blʋgba ‑bɩ 'kwli, ‑ɛ hlɔɔ nɛ 'a 'bli ‑mɔ lɛ dɩakɩ. ‑Tɛ ɛ nyre 'lɩ 'blʋgba a 'mʋ 'kwli, ‑ɛ ‑bɩ ɛ ‑tʋa 'wliyɛ a 'mʋ, 'a lɛcɩcralɛ. 'Klɔdʋ a 'mʋ, nɔ‑ nu la꞊a, 'a 'wliyɛ a pɛpɛ 'ɛ ‑wɛ la. ");
INSERT INTO ktj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","‑Tɛ ɛ ‑wɛ 'kɩ 'wliyɛ a lɛcɩcralɛ ‑mɔ, ‑ɛ ‑bɩ 'kanʋ bi 'lɩ 'blʋgba a 'mʋ 'kwli, 'yu a 'mʋ 'ɛ ‑tʋa ꞊hɩʋɛn a 'yiye, 'kanʋ a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ɛ nɔ‑ nu꞊o, 'ɛ mu ‑kʋan lɛ ꞊mʋɔ mɔ, 'kɩ 'lɩ nyɩbɛyu ꞊dʋ ‑mɔ, ‑ɛ kɔ 'lɩ 'blʋgba a 'mʋ 'kwli. Nyɩbɛyu a 'mʋ, ɛ kɔ bʋɩcɩ, 'kɩ 'lɩ 'a ‑yrugba kɩ, 'ʋ nɩ 'lɩ ‑gblo 'kwli. ‑Ɛ ‑bɩ nyɩbɛyu a 'mʋ, ɛ lee 'hɩangbe a 'mʋ nɩ, bʋ ꞊tu ꞊nʋ 'yie. ");
INSERT INTO ktj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","‑Tɛ 'hɩangbe a 'mʋ, ɛ ꞊tui ꞊nʋ 'yie, ‑ɛ ‑bɩ ɛ ‑hʋɛ꞊ɛ nɩ, 'kanʋ a ‑tɩ, bʋ di bʋɩcɩ a 'mʋ, 'waa didi‑tɛblɩ ‑mʋ', ʋ yɛ ꞊nʋ yrɛ, kɛɛ, nyiblo ꞊dʋ 'nɩ ‑nyi꞊e lɩ꞊ɩ 'a dɛ. ");
INSERT INTO ktj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","‑Ɛ ‑bɩ ꞊wlʋ di꞊e ‑mɔ, ɛ wɛn: 'Na 'baɩ a ‑kʋannunyibli a pɛpɛ, ʋ yɩ di dɛ, 'ʋ ꞊mlɛ, didi‑tɛblɩ 'ɛ yɩ blɛ hie, 'mɔ ‑bɩ, 'nɩ nɩ 'nɛ‑ 'kanʋ yɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","'N di 'du ye', 'mʋ ‑mɔ ꞊hɩan, 'mʋ 'lɩ 'na 'baɩ ‑mɔ mu, 'mʋ꞊ʋ lee ‑nɩ, ‑ɛ mɔ: 'Na 'baɩ o, 'n ‑hɛɛ Nyɩsʋa a ‑tɩ lɛ, kɔ, 'n ‑hɛɛ ‑na ‑tɩ lɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","'A ‑tɩ, 'n 'yɩ yɩ ‑blɛɛ ‑nɩ, ‑bʋ daa 'kɩ 'mʋ ‑na 'yu de, kɛɛ, daa 'mʋ ‑na ‑kʋannunyiblo. ");
INSERT INTO ktj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","‑Ɛ ‑bɩ ɛ 'du ye', 'ɛ bi 'hru wlɔn, 'ɛ mu 'lɩ 'a 'baɩ ‑mɔ. Bʋ waan 'lɩ, ‑ɛ ‑bɩ 'a 'baɩ yru꞊o nɩ, 'a 'yu a 'mʋ, 'a nyaɩ 'ɛ ‑tʋa 'a nunuo dɩakɩ, 'ɛ 'gba cigbɛ, 'ɛ mu꞊o ye' 'bɛ mɔ. ‑Tɛ ɛ nyre 'ʋ꞊ʋ 'hʋɩ, ‑ɛ ‑bɩ ɛ 'wlɛɛ ꞊nɛ nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","‑Ɛ ‑bɩ 'a 'yu wɛn: 'Na 'baɩ o, 'n ‑hɛɛ Nyɩsʋa a ‑tɩ lɛ, kɔ 'n ‑hɛɛ ‑na ‑tɩ lɛ ‑wɛ. 'A ‑tɩ, 'n 'yɩ 'kɩ yɩ ‑blɛɛ ‑nɩ, ‑bʋ daa 'mʋ ‑na 'yu. ");
INSERT INTO ktj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","‑Ɛ ‑bɩ 'a 'baɩ lee nɛ 'a ‑kʋannunyibli nɩ, ɛ wɛn: Ba pʋ 'lɩ 'klɩ lɛ, ba ya 'lɩ wlawlʋ ‑mʋ', ‑ɛ nɔ yɩ, 'kɩ 'lɩ wlawlɩ a pɛpɛ 'nyɩ, ‑ʋ nɩ 'nɛ‑ 'kayu bʋ, ba pʋ ꞊nɛ꞊ɛ. Ba pʋ 'lɩ꞊ɩ 'bʋɛyɛ ‑jɩ' (ɛ 'mʋ꞊ʋ yi, ‑ɛ mɔ, 'n dɛɛ ꞊nɛ 'na 'yu). Ba pʋ꞊ʋ 'suin ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ba ya 'lɩ bliyu ‑mʋ', ‑a pʋ 'kɩbɩa kɩ, a 'mʋ꞊ʋ 'la, ‑ɛ di꞊e nu, ‑a 'mʋ dɛ di, ‑a 'mʋ lɛ 'mle ‑tɛɛ, ");
INSERT INTO ktj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","‑ɛ nu꞊o, 'na 'yu ‑bʋ, ɛ 'wɩ yɩ, ɛ 'kʋ la nɩ, 'ɛ 'hrɩ 'klɔ. Ɛ 'wan la nɩ, 'nɩ 'ye kɛ꞊ɛ. ‑Ɛ ‑bɩ ʋ ‑tʋa lɛ'mimle a nunuo. ");
INSERT INTO ktj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ti a 'mʋ 'yri, 'a 'yu ‑mʋ', ‑ɛ mɔ nyɩ'ka, 'kɩ ɛ nɩ 'lɩ ‑titi. ‑Tɛ ɛ ‑hɔn ‑titi, bʋ 'mʋɛ 'kɩ 'kayu yrɛ, ‑ɛ ‑bɩ ɛ 'wɩn bibi‑tɛblɩ kɔ ‑wla a win, ");
INSERT INTO ktj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","'ɛ da ‑kʋannunyiblo ‑bɩ, 'ɛ 'bɛti꞊e, ɛ wɛn: Dɛ‑ a 'dɩ ‑bɩ, ‑ɛ mi 'lu ‑mɔ, ‑ɛ kɔ ‑wla nyibli yɩ yi 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‑Ɛ ‑bɩ ‑kʋannunyiblo a 'mʋ, ɛ wɛn: ‑Na 'dɩayɩ ‑mʋ', ‑ɛ mu la, nɔ‑ di de. Ɛ mɔ ‑na 'baɩ a dɔdʋ, 'kɩ 'a 'yu, ‑ɛ 'wan la, bʋ di꞊e 'ye, 'a 'hʋɩ bʋ di ‑tɛɛ nu. Ɛ nɔ‑ nu꞊o, 'ɛ 'la bliyu ‑mʋ', ɛ pʋ la 'kɩbɩa kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","‑Tɛ nyɩ'ka a 'mʋ, ɛ 'wɩn ‑tɩ a 'mʋ, ‑ɛ ‑bɩ ɛ bi yrʋ'. Yrʋ a ‑tɩ, ɛ 'nɩ ‑hʋa꞊a lɩ bʋ pa 'kayu bʋ. Nɔ‑ nu꞊o, 'a 'baɩ 'ɛ 'hrɩ, 'ɛ ‑tʋa 'a lɛnyaalɛ, ɛ wɛn: Pa 'kayu bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kɛɛ ‑ɛ ‑bɩ ɛ ꞊tu 'a 'baɩ ꞊wɔn, ɛ wɛn: 'Ye kɛ, 'kɩ 'n nɩ 'nɛ‑ ‑mʋ 'hʋɩ ti a pɛpɛ, 'nɩ yɩ ‑mʋ ‑hɛɛ ‑nɩ. 'N 'yɩ ‑hʋan ‑na ‑tɩ lɛ nɩ ‑hɛɛ ‑nɩ, 'a 'yrɩ 'wʋwlɛ klɛ. Kɛɛ, ꞊yɩ ‑hʋan 'mʋ wliyu nɩ 'lɛɛ ‑nɩ, 'n kɔ 'na 'bio 'hʋɛn‑, ‑a 'mʋ lɛ 'mle. ");
INSERT INTO ktj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kɛɛ, ‑na 'yu ‑mʋ', ‑ɛ gba la ‑na 'wliyɛ, ‑ɛ ‑nyi꞊e 'lawlunʋgbɩ lɛ, ‑tɛ ɛ ꞊hɩan ‑mɔ, nɔ‑ ꞊lɛɛ bliyu ‑mʋ', ‑a pʋ la 'kɩbɩa kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","‑Ɛ ‑bɩ 'a 'baɩ wɛn: 'Na 'yu o, 'kɩ ꞊cibi 'nɛ‑ 'mʋ 'hʋɩ. 'A ‑nɛ ꞊dedede, 'n ‑kɔ, ‑mɔ kɔ꞊ɔ. ");
INSERT INTO ktj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kɛɛ, ɛ blɛɛ yɩ, ‑ba nu lɛ'mimle, ‑ɛ nu꞊o, ‑na 'dɩayɩ ‑bʋ, ɛ 'wɩ yɩ, ɛ 'kʋ la nɩ, 'ɛ 'hrɩ 'klɔ de. Ɛ 'wan la nɩ, 'nɩ 'ye kɛ꞊ɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","‑Nyrɔwɔ ꞊dʋ, ‑Yusu pʋ la 'ledʋ, 'kɩ 'ʋ 'a ‑nagbopʋ* yɩ, ɛ wɛn: «Ɛ kɔ la dɛkɔnyɔ ꞊dʋ. Nɔ‑ kɔ la 'wli'yie꞊tunyɔ. ‑Nyrɔwɔ ꞊dʋ, ‑ɛ ‑bɩ nyibli ꞊dʋ mu la 'lɩ dɛkɔnyɔ a 'mʋ ‑mɔ, ʋ wɛn: Ta 'ʋ lɛ, ‑na 'wli'yie꞊tunyɔ ‑bʋ, ɛ cɩcrɛ ‑na kʋkɔ‑tɛblɩ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ɛ nɔ‑ mɔ dɛkɔnyɔ a 'mʋ, bʋ da꞊a, ɛ wɛn: 'N yɩ 'wɩn ‑na 'nyrɛ ‑hʋan. 'A ‑tɩ, lee 'mʋ, ‑tɛ ‑ni 'na kʋkɔ‑tɛblɩ a naalɛ. 'N pʋ꞊ʋ ꞊haan‑tɩ, ‑ɛ mɔ, ꞊yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ‑bʋ mɔ 'kɩ 'na 'wli'yie꞊tunyɔ de. ");
INSERT INTO ktj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","‑Ɛ ‑bɩ kɛ‑ 'wli'yie꞊tunyɔ a 'mʋ, ɛ pɩ 'a dɩɔnʋ yɩ, ɛ wɛn: 'Na 'masɛ di ‑ha 'mʋ ‑kʋan kɩ. ‑Bɩ' 'n di nu 'lɩ? 'N 'yɩ 'klɩ ‑kɔ, 'kɩ ꞊bʋ ‑mɛ ‑tʋtʋ yɩ, ɛ kɔ, ‑tʋɩ di 'mʋ 'nɩ nu, 'nɩ kɔ ꞊bʋ ‑hʋa lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ɩn'hɩn‑, dɛ 'n di nu, 'n yi꞊e nɩ. 'Nɩ nu dɛ a 'mʋ, 'bʋ ‑ha 'mʋ ‑kʋan kɩ, nyibli ‑bɩ di 'ble 'mʋ kʋa, 'kɩ 'lɩ 'waa 'kayo bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ nyibli ‑bʋ, ‑ʋ 'ble 'a 'masɛ a gbɩ kʋa lɛ, ɛ ‑tʋa 'waa dodoyo a dɩda. ‑Tɛ 'a yɩ‑hɛnyiblo nyre 'ʋ, ‑ɛ ‑bɩ ɛ 'bɛti꞊e nɩ, ɛ wɛn: 'Na 'masɛ a gba ‑mʋ', ꞊ble kʋa, ‑tie ɛ ‑mɔ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‑Ɛ ‑bɩ ɛ wɛn: 'Nyratɛɛ a (100) ‑wlɩ nɩ ꞊hun a 'wliyɛ a gba, nɔ‑ nɩ 'nɛ‑ 'mʋ ‑mɔ. ‑Ɛ ‑bɩ 'wli'yie꞊tunyɔ a 'mʋ, ɛ wɛn: 'Ye ‑na 'crɩɛn, ‑ɛ kɔ kɩ ʋ 'crɩɩ 'ʋ ‑na gba, ɛ nɔ‑ ‑bʋ. 'A ‑tɩ, 'kɩka ‑nɩ, ‑bʋ nɩ bʋ, ‑bʋ 'crɩɩ, ‑ɛ mɔ, 'nyratɛɛ a (50) ‑wlɩ nɩ 'hʋɛn ꞊tu 'ʋ ‑pu a 'wliyɛ a gba, ɛ nɔ‑ nɩ 'nɛ‑ 'mʋ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nyiblo ‑bɩ nɩ 'ʋ, kɛ‑ ɛ pɩ꞊ɩ yɩ, ɛ wɛn: ‑Mɔ bɩ, ‑tie ꞊ble kʋa 'lɩ? ‑Ɛ ‑bɩ ɛ wɛn: ‑Kʋbʋblɛ a (500) ‑hɔtrʋwɩ nɩ ꞊hun a 'wliyɛ a gba, ɛ nɔ‑ nɩ 'nɛ‑ 'mʋ ‑mɔ. ‑Ɛ ‑bɩ 'wli'yie꞊tunyɔ wɛn: 'Ye ‑na 'crɩɛn, ‑ɛ kɔ kɩ ʋ 'crɩɩ 'ʋ ‑na gba, ɛ nɔ‑ ‑bʋ. 'A ‑tɩ, 'kɩka ‑nɩ, ‑bʋ nɩ bʋ, ‑bʋ 'crɩ ‑kʋbʋblɛ a (400) ‑hɔtrʋwɩ nɩ ‑hɛn a 'wliyɛ a gba. ");
INSERT INTO ktj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","'Wli'yie꞊tunyɔ a 'mʋ, ‑ɛ 'yɩ 'ʋ yɩ 'sii ‑nɩ, ‑tɛ 'a 'masɛ 'ye dɛ a 'mʋ, ɛ ‑nu, ‑ɛ ‑bɩ ɛ ‑tʋa a 'nyrɛ a lɛpʋpʋʋ, ‑tɛ ɛ ‑nu, 'ɛ ‑hie ꞊haandɛ 'lu ‑mɔ lɛ, 'kɩ 'ʋ dɛ, ɛ di ‑hʋan ‑hɛ a ‑ta'. Ɛ mɔ ‑tɛɛ, nyibli ‑mʋ', ‑ʋ 'yɛ nɩ ꞊tuu 'ʋ Nyɩsʋa 'ʋ, ‑ʋ ꞊mʋɛ 'klɔ ‑bʋ a ‑hʋhʋa‑tɛblɩ lɛ, ʋ kɔ ꞊tɔ, 'kɩ 'ʋ gblagblʋ a nunuo a ‑ta'. 'Waa ꞊tɔ a 'mʋ, ɛ ‑hi 'ʋ Nyɩsʋa a nyibli a ꞊tɔ nɩ, ʋ ‑kɔ, 'kɩ 'ʋ yɩ'siidɛ a nunuo a ‑ta'.» ");
INSERT INTO ktj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Kɛ‑ ‑Yusu pɩ de, ɛ wɛn: «꞊Tɔ 'n pɩ 'a mʋ, ɛ nɔ‑ mɔ: 'Klɔ ‑bʋ, 'a kʋkɔ‑tɛblɩ ‑mʋ', ‑ɛ kɛɛ nyibli, ba 'du꞊o ye', ba ‑nyi꞊e nyibli lɛ, nyibli a 'mʋ, ʋ 'mʋ 'aan nɩnatumupʋ ‑hɛ. Ɛ nɔ‑ di꞊e nu, ti ‑mʋ' ‑kɔ 'yri kʋkɔ‑tɛblɩ a 'mʋ, ɛ di 'a mʋ ꞊jrɛ ‑wɛ, ʋ 'mʋ 'a mʋ kʋa 'ble, 'kɩ 'lɩ yakɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nyiblo ‑bʋ, ‑ɛ 'sii 'ʋ yɩ, 'kɩ 'ʋ ‑tɛblɩ 'cɩmɩ a yɩblɛ꞊tutulɛ a ‑ta', ɛ di 'ʋ yɩ 'nɩ 'sii ‑nɩ, 'kɩ 'ʋ ‑tɛblɩ gbagbɩ a yɩblɛ꞊tutulɛ a ‑ta'. Kɛɛ, nyiblo ‑bʋ, ‑ɛ 'yɩ 'ʋ 'yɩ 'sii ‑nɩ, 'kɩ 'ʋ ‑tɛblɩ 'cɩmɩ a yɩblɛ꞊tutulɛ a ‑ta', ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ 'sii 'ʋ yɩ, 'kɩ 'ʋ ‑tɛblɩ gbagbɩ a yɩblɛ꞊tutulɛ a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","'A ‑tɩ, 'ba 'yɩ 'ʋ yɩ 'sii ‑nɩ, 'kɩ 'ʋ 'klɔ ‑bʋ a kʋkɔ‑tɛblɩ, ‑ɛ kɛɛ nyibli, a yɩblɛ꞊tutulɛ a ‑ta', Nyɩsʋa 'yɩ 'lɩ꞊ɩ ‑wɛ, bʋ kuo nɛ 'a mʋ ꞊wlʋ yɩ, bʋ ‑nyi 'a mʋ ‑tɛɛ a kʋkɔ‑tɛblɩ. ");
INSERT INTO ktj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","꞊Hɩan ‑mɔ de, 'bʋ mɔ, 'ba 'yɩ 'ʋ yɩ 'sii ‑nɩ, 'kɩ 'ʋ ‑tonyibli ‑bɩ a kʋkɔ‑tɛblɩ a yɩblɛ꞊tutulɛ a ‑ta', Nyɩsʋa 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑nyi 'a mʋ kʋkɔ‑tɛblɩ ‑bʋ, ‑ɛ blɛɛ nɛ 'a mʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","‑Kʋannunyɔ ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nu 'masɛpʋ nɩ 'hʋɛn a ‑kʋan, ti nɩ ‑do a ti 'yri. Ɛ kɔ bʋ yraa nyiblo nɩ ‑do, ɛ 'mʋ nyiblo ‑bɩ ‑nʋɛ ‑nɩ. Ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ti nɩ ‑do a ti 'yri, Nyɩsʋa bʋ kɔɔ nɛ 'a mʋ win kɩ, 'tɩ‑ 'wliyɛ bʋ di 'a mʋ win kɩ ‑kɔɔ ‑nɩ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","‑Tɛ Falisi꞊tumu* a nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, ʋ 'wɩn ‑Yusu a pʋpʋwin a pɛpɛ, ‑ɛ ‑bɩ ʋ ‑tʋa 'a 'caalɛ, ‑ɛ nu꞊o, ʋ nʋɛ 'wli dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ, ɛ wɛn: «A ni ‑tɛblɩ, ‑ɛ di꞊e nu, nyibli 'mʋ lɛ pʋ, ‑ɛ mɔ: A 'sii 'ʋ yɩ. Kɛɛ, Nyɩsʋa yi 'aan ꞊wlɩ nɩ. Ɛ mɔ ꞊han‑tɩ, ‑tɛblɩ ‑mʋ', nyibli dɛɛ ‑tɛblɩ gbagbɩ, Nyɩsʋa yraa ꞊nɛ nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","‑Tɛblɩ ‑mʋ', ʋ 'crɩɩ la 'lɩ Moise a tetecrɩɩn 'kwli, kɔ 'kɩ 'lɩ Nyɩsʋa a winwlɔn‑hanyʋ* a 'crɩɩn 'kwli, ɛ nɔ‑ ʋ tɔɔ ‑nɩ ‑tɔɔtɔɔ, Saan Batisɩ 'ɛ ‑di. Kʋɛ 'lɩ ti a 'mʋ 'yie bʋ, Nyɩsʋa a win ‑bʋ, ‑ɛ hlɛ꞊ɛ, ‑ɛ mɔ, Nyɩsʋa kɔɔ nyibli win kɩ, ɛ nɔ‑ 'n nɛ ‑mɔ lɛ, 'a ‑nɛ nyiblo, 'ɛ ꞊tui 'ʋ 'klɩ, ‑ɛ di꞊e nu, Nyɩsʋa 'mʋ꞊ʋ win kɩ ‑kɔɔ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yakɔ kɔ ‑tʋtʋ 'hʋɛn‑, ʋ di bʋ 'nɩ ‑wɛ, kɛɛ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, 'kɩ Nyɩsʋa a tetebʋ ꞊dʋ a 'kʋtɩɔ bʋ ‑wɛ bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","'A ‑nɛ nyɩbɛyugbe, 'bʋ nɩ 'ʋ, 'bʋ pʋ 'lɩ 'a nʋgba ‑patʋ', 'tɩ‑ 'bʋ kɔ nʋgba ‑bɩ, ‑ɛ ‑bɩ nyɩbɛyugbe a 'mʋ, ɛ nu ‑wlawlɩ. Nʋgba a 'mʋ, ɛ di 'lɩ ‑patʋ' pʋ, nyɩbɛyugbe ‑bɩ 'bʋ kɔ꞊ɔ, nyɩbɛyugbe a 'mʋ, ɛ nu ‑wlawlɩ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Kɛ‑ ‑Yusu pɩ de: «Ɛ kɔ la dɛkɔnyɔ ꞊dʋ. 'A 'hʋɩlɛpʋ‑tɛblɩ, ɛ pɩ la 'hʋɩ lɛ, ɛ nɔ la yɩ dɩakɩ, 'tɩ‑ 'ɛ pɩ la ꞊die. 'A ‑nɛ ‑nyrɔwɔ, ɛ kɔ bʋ 'mle la lɛ, bʋ pi la ꞊haandii‑tɛblɩ a gblegble, ɛ kɔ 'a 'bio 'hʋɛn‑, 'ʋ yɩ la꞊a di. ");
INSERT INTO ktj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nyiblo ‑bɩ nɩ la 'ʋ. 'A 'nyrɛ mɔ Lasa. ꞊Hɩʋɛn ni la꞊a nɩ. 'A 'hʋɩ a pɛpɛ nu la ꞊ji dadʋ. Ɛ nɔ‑ ‑nyrɔwɔ ꞊dʋ, ‑ɛ pɛ la 'ʋ dɛkɔnyɔ a 'mʋ 'a ꞊hʋan.yɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ɛ ‑hʋɛ꞊ɛ nɩ, didi‑tɛblɩ ‑mʋ', ‑ɛ yɩ dɛkɔnyɔ kɔ 'a nɩnatumupʋ 'hʋɛn‑ ꞊jrɛ 'ble, bʋ 'tɩ꞊ɩ lɛ, bʋ di꞊e, kɛɛ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ. 'Kɩ ɛ yɩ 'ʋ bʋ pɛ, ‑gbo 'ʋ yɩ 'lɩ 'a ꞊ji 'yi lɛ mɛ. ");
INSERT INTO ktj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","'Kɩ ʋ nɩ 'ʋ bʋ ‑nɩnɩ, ‑ɛ ‑bɩ ꞊hɩʋɛnnyɔ a 'mʋ, ɛ 'kʋ nɩ, Nyɩsʋa a lɛlenyɔ 'ɛ gba 'lɩ꞊ɩ Nyɩsʋa a bʋnɩɩlɛ', 'kɩ 'ʋ ‑aan ‑nɛ 'baɩ Abrahamʋ 'hʋɩ. ‑Ɛ ‑bɩ dɛkɔnyɔ ‑mɔ ‑bɩ, ɛ 'kʋ nɩ ‑wɛ, 'ʋ ‑ha 'ʋ꞊ʋ. ");
INSERT INTO ktj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","‑Tɛ ɛ mu 'yi ꞊wlɛ mɔ, 'kɩ ɛ 'hrɩɩ 'lɩ 'kuopʋ a 'bli, 'ɛ yɩ ꞊hɩʋɛn 'ye dɩakɩ. Bʋ 'du 'kɩ 'lu ye', ‑ɛ ‑bɩ 'kɩ 'lɩ ‑tɩtɛ blɔblʋ, 'kɩ ɛ tɛɛ 'lɩ lɛ, 'ɛ yɩ Abrahamʋ 'ye, Lasa 'ɛ nɩ 'ʋ꞊ʋ 'hʋɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","‑Ɛ ‑bɩ ɛ 'yaa 'lɩ win, ɛ wɛn: ‑Aan 'baɩ Abrahamʋ, 'n yɩ 'ye ꞊hɩʋɛn dɩakɩ, 'kɩ 'nɛ‑ na ‑bʋ 'nyɩ. 'A ‑tɩ, yru 'na nyaɩ, ‑bʋ lee Lasa, bʋ 'nyra 'a ‑jie 'nie yɩ, ɛ 'mʋ 'ʋ꞊ʋ 'na mɛ kɩ 'tee ‑nɩ, 'na mɛ a 'mʋ, ɛ 'mʋ ‑pʋpɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","‑Ɛ ‑bɩ Abrahamʋ wɛn: 'Na 'yu o, bʋ bi 'lɩ ‑mʋ 'kwli, ‑ɛ mɔ, ‑tɛ ‑nɩ la 'lɩ ‑tʋtʋ kɩ, 'a ‑nɛ dɛ, ‑na ꞊wlʋ ‑hʋɛ la, ɛ nɔ‑ ‑kɔ la. Kɛɛ, Lasa ‑mɔ ‑bɩ, ɛ 'yɩ la ꞊dedede ‑kɔ. ‑Tɛ ti nɛ ‑bʋ, ɛ kɔ plɔ a bleelɛ, ‑mɔ ‑bɩ, ꞊nɩ yɩ ꞊hɩʋɛn 'ye. ");
INSERT INTO ktj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Dɛ 'n kɔ ꞊bʋ lee ‑mʋ, ɛ nɔ‑ ‑mɔ, a kɔ ‑a mʋ 'hʋɛn‑ ‑gbati, 'butɩɔ nɩ 'ʋ, ‑ɛ hlɔ 'kwli bʋ. 'A ‑tɩ, nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑hɔn 'nɛ‑ ‑a mʋ ‑mɔ, bʋ mu 'lɩ 'a mʋ ‑mɔ, mɔ, nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑hɔn 'lɩ 'a mʋ ‑mɔ, bʋ di 'nɛ‑ ‑a mʋ ‑mɔ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","‑Ɛ ‑bɩ dɛkɔnyɔ wɛn: ‑Aan 'baɩ Abrahamʋ, 'n nyɛɛ ‑mʋ lɛ, lee Lasa, bʋ mu 'lɩ 'na 'baɩ a 'kayu bʋ, ");
INSERT INTO ktj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","‑tɛ 'na 'dɩayɩnʋ nɩ ꞊hun nɩ 'lɩ, ɛ 'mʋ ꞊nʋ ‑lee ‑nɩ, ‑tɛ 'n nu naalɛ, ʋ 'nɩ ꞊ha naalɛ lɛ nu, ‑ɛ di꞊e nu, 'bʋ 'kʋ, ʋ 'nɩ ꞊ha 'nɛ‑ ꞊hɩʋɛn'yeelɛ' ‑bʋ di. ");
INSERT INTO ktj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","‑Ɛ ‑bɩ Abrahamʋ ꞊tu꞊o ꞊wɔn de, ɛ wɛn: ‑Na 'dɩayɩnʋ, Nyɩsʋa a tete, Moise 'crɩ la, 'kɩ ɛ nɩ 'lɩ ꞊nʋ ‑mɔ, 'tɩ‑ 'ʋ kɔ Nyɩsʋa a winwlɔn‑hanyʋ* a 'crɩɩn. Nyɩsʋa a nyibli a 'mʋ, ʋ nʋ‑ bʋ pʋ nʋa yɩ bʋ, ʋ 'mʋ Nyɩsʋa a 'hru a nalɛ yi. ");
INSERT INTO ktj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","‑Ɛ ‑bɩ dɛkɔnyɔ wɛn: 'Ʋʋn‑, ‑aan 'baɩ Abrahamʋ o, ɛ 'yɛ nɩ ꞊cɛ. Kɛɛ, nyiblo 'bʋ ‑hɔn 'nɛ‑ 'kʋkʋnyibli ‑mɔ, 'bʋ yɩ 'lɩ ꞊nʋ ‑mɔ nɩ ‑hlee ‑nɩ, ʋ di 'waa dɛ 'kuku 'nɩ yru, ʋ 'mʋ 'ʋ꞊ʋ bʋ hie, ʋ 'mʋ 'waa 'klɔ Nyɩsʋa ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","‑Ɛ ‑bɩ Abrahamʋ ꞊tu꞊o ꞊wɔn de, ɛ wɛn: 'Bʋ mɔ, 'bʋ 'yɩ Moise kɔ Nyɩsʋa a winwlɔn‑hanyʋ nʋa yɩ bʋ ‑pʋ, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ pʋ nyiblo ꞊dʋ nʋa yɩ bʋ de, kɔ, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ kuo Nyɩsʋa ꞊wlʋ yɩ, 'ye ꞊bɩɩ nyiblo ꞊dʋ ‑hɔn 'nɛ‑ 'kʋkʋnyibli 'nyɩ, ɛ 'hrɩ 'klɔ, ɛ hlee 'lɩ ꞊nʋ ‑mɔ.» Kɛ‑ ‑Yusu pʋ nyibli a 'mʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kɛ‑ ‑Yusu pɩ 'a ‑nagbopʋ* yɩ, ɛ wɛn: «'A ‑nɛ ti, ɛ di kɔ ‑tɛblɩ ‑bɩ, ‑ʋ di nyibli 'tu, ʋ 'mʋ Nyɩsʋa a ꞊wlʋ a yɩkuolɛ 'kee ‑nɩ. Kɛɛ, 'jrɔ 'kɩ 'ʋ nyiblo ‑mʋ' ‑mɔ, ‑ɛ di꞊e nu, 'a 'bɩ 'mʋ Nyɩsʋa a ꞊wlʋ a yɩkuolɛ 'kee ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ɛ di nu wɛn ‑tɛɛ, 'kɩ bʋ pʋ wɛn nyiblodʋ a 'mʋ 'hɩɔ gbɛtɛɛ lɔ, bʋ pʋ wɛn 'lɩ꞊ɩ 'yru ‑mɔ, ɛ 'mʋ wɛn 'kʋ, 'ɛ ‑hi 'ʋ bʋ nu꞊o, nyiblo ‑bʋ, ‑ɛ kuo Nyɩsʋa ꞊wlʋ yɩ, ‑wɛn 'hɩangbe, bʋ 'kee Nyɩsʋa a ꞊wlʋ a yɩkuolɛ. ");
INSERT INTO ktj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ba ꞊tu 'aan dɩɔnʋ 'yie ‑tɛɛ. ‑Na 'bɩ Nyɩsʋa a nyiblo 'bʋ nu ‑mʋ dɛ 'kuku ‑mɔ, lee ꞊nɛ: Dɛ ‑nu 'mʋ ‑mɔ, ɛ nyre yɩ. 'Bʋ mɔ, 'bʋ 'wɩn, 'bʋ 'cɩcɩ 'a nunuklɔ, ‑ɛ ‑bɩ ‑hru 'a dɛ 'kuku a ‑tɩ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","'Bʋ mɔ, 'bʋ nu ‑mʋ dɛ 'kuku ‑mɔ, 'wɩ nɩ ꞊hlon'hʋɛn, 'kɩ 'lɩ ‑nyrɔwɔ nɩ ‑do 'kwli, kɔ, 'a ‑nɛ ti, 'bʋ yɩ 'lɩ ‑mʋ ‑mɔ nɩ di, 'bʋ yɩ꞊ɩ nɩ yrui, ‑ɛ mɔ, dɛ ɛ ‑nu, ɛ nyre yɩ, ‑ɛ ‑bɩ ‑hru 'a dɛ 'kuku a ‑tɩ ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kɛ‑ Kʋkɔnyɔ ‑Yusu a ‑mɔnanyʋ* pɩ꞊ɩ yɩ, ʋ wɛn: «‑Hɛɛ nɛ ‑a mʋ, ‑ba kuo Nyɩsʋa ꞊wlʋ yɩ ‑tɛɛ, ‑aan ꞊wlʋ a yɩkuolɛ a 'mʋ, ɛ 'mʋ klɛ ‑bii ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","‑Ɛ ‑bɩ Kʋkɔnyɔ ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «'Bʋ mɔ, 'ba kuo wɛn Nyɩsʋa ꞊wlʋ yɩ dɛ gbe, a ‑wɛ 'lɩ ba lee wɛn tugbɛ ‑mʋ' nɩ: 'Hri ‑wlu, ‑bʋ mu 'lɩ 'yru ‑mɔ, 'ɛ mɔ ꞊han‑tɩ, ɛ di wɛn 'ʋ 'a mʋ 'nɩ ꞊tuu ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kɛ‑ ‑Yusu pɩ 'a ‑nagbopʋ* yɩ de, ɛ wɛn: «꞊Bʋ pʋ ꞊nɛ ‑kʋannunyɔ a dɛ yɩ: 'Kɩ 'lɩ 'a mʋ 'nyɩ, nyiblo 'bʋ kɔ ‑kʋannunyɔ, ‑kʋannunyɔ a 'mʋ, 'bʋ yɩ nyiblo a 'mʋ 'a ‑ci a ‑kʋan nɩ ni, ɛ kɔ, 'bʋ yɩ 'a 'wlugba‑tɛblɩ nɩ ‑nɛɛ ‑nɩ, 'tɩ‑ 'bʋ yɩ 'lɩ ‑ci kɩ nɩ ‑hʋɛn, ‑cikɔnyɔ 'bʋ 'ye 'lɩ꞊ɩ ye', ꞊bɩ kɛ‑ ɛ di꞊e yɩ pʋ: 'Kɩka ‑nɩ, ‑bʋ di 'lɩ, ‑a 'mʋ dɛ di? ");
INSERT INTO ktj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","'Ʋʋn‑, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ pʋ lɛ. Kɛɛ, kɛ‑ ɛ di pʋ: Mu ‑na wlawlɩ 'cɩcɩ ‑nɩ, ꞊mʋ 'na dididɛ pi mɔ di, ꞊mʋ 'mɔ꞊ɔ yɩ ya, 'mʋ dɛ di. 'Nɩ ‑wɛ dɛ lɛ, ‑ɛ ‑bɩ ‑na 'mumu, ‑wɛ 'lɩ ‑bʋ di dɛ nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","‑Kʋannunyɔ a 'mʋ, 'bʋ nu ‑kʋan ‑mʋ', 'a 'masɛ pʋ lɛ bʋ nu, ꞊bɩ a pʋ꞊ʋ ꞊haan‑tɩ, ɛ di ‑nyi 'a ‑kʋannunyɔ 'wio? 'Ʋʋn‑, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ ‑nyi꞊e 'wio. ");
INSERT INTO ktj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kɛ‑ nɩ ‑do, ɛ ꞊ti 'mʋ, 'kɩ 'ʋ 'a mʋ ‑mɔ: 'Bʋ mɔ, ‑tɛblɩ a pɛpɛ ‑mʋ', Nyɩsʋa pʋ lɛ ba nu, 'ba nu꞊o, kɛ‑ ba pʋ: ‑A mɔ ‑na ‑kʋannunyibli ꞊nɩɔ. ‑A 'yɩ 'wio ꞊dʋ ‑kɔ, ‑ɛ nu꞊o, ‑kʋan, ‑a kɔ ‑ba nu wɛn, ɛ nɔ‑ ‑a ‑nu.» ");
INSERT INTO ktj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ 'tɩɛ gbɛ 'hru ‑mʋ', ‑ɛ mi 'lɩ Jrusrɛdɩɔ 'kwli 'lu ‑mɔ. 'Kɩ ʋ naa 'lɩ Samaliblʋgba kɔ Galileblʋgba a 'blʋ‑paʋn 'yri. ");
INSERT INTO ktj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","'Bʋ yɩ 'kɩ 'lɩ 'dɩɔ 'kwli nɩ pʋɛ, ‑ɛ ‑bɩ ꞊hrannunyʋ nɩ ‑pu, nʋ‑ di ‑Yusu ye' 'bɛ mɔ. ‑Tɛ ʋ 'mʋɛ ꞊nɛ yrɛ, ‑ɛ ‑bɩ ʋ nyra blɛ, ");
INSERT INTO ktj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","'ʋ ‑tʋa 'lɩ win a 'lɩ'yaalɛ, 'ʋ dɛ ‑Yusu, ʋ wɛn: «Tɔɔnyɔ o, yru ‑aan nyaɩ!» ");
INSERT INTO ktj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","‑Tɛ ɛ 'ye ꞊nʋ, ‑ɛ ‑bɩ ɛ wɛn: «Ba mu, ba tɔɔ nɛ 'aan dɩɔnʋ Nyɩsʋa a ‑cɔhlʋnpinyʋ* yɩ, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ 'ye, ‑ɛ mɔ, 'aan 'kʋɛ ‑wɛ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","‑Tɛ ʋ yɩ nɩ mi, ‑ɛ ‑bɩ ʋ 'ye꞊e nɩ, ‑ɛ mɔ, 'waa 'kʋɛ ‑wɛ nɩ. Kɛɛ, nyiblo nɩ ‑do, 'kɩ 'lɩ ꞊nʋ 'nyɩ, ɛ nɔ‑ ꞊hɩan ‑mɔ, 'ɛ 'yɛɛ 'lɩ win, 'ɛ pɩ Nyɩsʋa 'nyrɛ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","‑Tɛ ɛ nyre 'ʋ ‑Yusu 'hʋɩ, ‑ɛ ‑bɩ ɛ 'gbla kwlɩ, 'kɩ 'ʋ꞊ʋ ye', 'ɛ ‑nyi꞊e 'wio. 'Tɩ‑ nyiblo a 'mʋ, ɛ mɔ Samalikʋɛyu ꞊nɩɔ. (Samalikʋɛ a 'mʋ, ‑Juukʋɛ* wɛn 'nɩ, ʋ 'yɩ ꞊haannyibli 'pa‑.) ");
INSERT INTO ktj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kɛ‑ ‑Yusu pɩ de, ‑ɛ mɔ: «Nyibli nɩ ‑pu ‑bʋ, ‑ʋ kɔ 'kʋɛ 'n nu꞊o, 'ɛ ‑wɛ, 'waa nyibli nɩ ꞊hʋɩan‑do ‑bɩ ‑mʋ', ‑bɩ' ʋ nɩ yɩ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Dɛ‑ nu꞊o, 'kɩ nyiblo ꞊dʋ, 'kɩ 'lɩ ꞊nʋ 'nyɩ, ɛ 'yɩ꞊ɩ 'lu ‑mɔ lɛ ‑hie, 'kɩ bʋ di 'nɛ‑ 'mʋ yɩ, ɛ 'mʋ Nyɩsʋa 'wio ‑nyi, 'bʋ 'yɩ hɩapʋdakɔ a nyiblo ‑bʋ 'pa‑?» ");
INSERT INTO ktj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'kɩ nyiblo a 'mʋ yɩ, ɛ wɛn: «'Du ye', ‑bʋ mu. ‑Tɛ ‑kuo 'mʋ ꞊wlʋ yɩ, ɛ nɔ‑ nu꞊o, Nyɩsʋa 'ɛ wa ‑mʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","‑Nyrɔwɔ ꞊dʋ 'kwli, Falisi꞊tumu* a nyibli ꞊dʋ, ʋ nʋ‑ 'bɛti ‑Yusu, ʋ wɛn: «Ti a 'dɩ ‑bɩ ‑kɔ 'yri Nyɩsʋa di ‑tonyibli a win a kɩkɔɔlɛ ‑wlu ꞊tuu ‑nɩ, ɛ 'mʋ 'a ‑kʋan 'lu ‑yra 'lɩ?» ‑Ɛ ‑bɩ ɛ ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «Nyɩsʋa 'bʋ ꞊tu nyibli a win a kɩkɔɔlɛ ‑wlu, nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ 'ye ‑tɛblɩ, ‑ɛ di 'lu ‑mɔ mu, ‑ɛ di꞊e nyibli ‑tɔɔ ‑nɩ, ‑ɛ mɔ, Nyɩsʋa ꞊tu 'a nunuo ‑wlu. ");
INSERT INTO ktj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ pʋ lɛ: Ba ta 'nɛ‑ lɛ, ‑ʋ'ʋ‑ ba ta 'lɩ ‑tɩtɛ ‑mʋ' lɛ. Ba kɔ 'a yiyie, ‑ɛ mɔ, Nyɩsʋa ꞊tu nyibli a win a kɩkɔɔlɛ ‑wlu, 'kɩ 'lɩ 'a mʋ 'nyɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ 'kɩ 'a ‑nagbopʋ* yɩ, ɛ wɛn: «Ɛ di kɔ ti, ‑ɛ kɔ 'yri a di 'ʋ꞊ʋ ‑hʋa ‑nɩ dɩakɩ, 'kɩ 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, ꞊bʋ nɩ 'ʋ 'a mʋ 'hʋɩ, 'kɩ 'lɩ ‑nyrɔwɩ gbi 'kwli, kɛɛ, ɛ 'nɩ ‑mɔ꞊ɔ lɩ꞊ɩ nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ti di 'ʋ 'nɩ nyre, ʋ 'mʋ 'a mʋ ‑lee ‑nɩ, ‑ɛ mɔ: 'Kɩ ɛ nɩ 'nɛ‑, ‑ʋ'ʋ‑ 'kɩ ɛ nɩ 'lɩ ‑tɩtɛ ‑mʋ'. Kɛɛ, a 'nɩ 'muo 'lɩ, kɔ, a 'nɩ 'gbaa 'lɩ cigbɛ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","‑Nyrɔwɔ ‑mʋ', ‑ɛ kɔ 'kwli 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n di di de, 'na didie di 'wɩ ‑tɛ yakɔ ni 'yii a pʋpʋʋ, 'ɛ yɩ wlɩn, kʋɛ 'lɩ 'yrʋ a 'hrɩɩlɛ' bʋ, ‑bʋ mu, ‑bʋ yɛ 'yrʋ a bʋpɛɛlɛ kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kɛɛ, 'tɩ‑ dɛ a 'mʋ, ɛ 'mʋ 'lu ‑mɔ mu, 'n kɔ ꞊bʋ 'ye ꞊hɩʋɛn dɩakɩ, kɔ, ti ‑bʋ 'yri a nyibli kɔ bʋ yraa 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Dɛ ‑mʋ', ‑ɛ mi la 'lu ‑mɔ, Noe a ti 'yri, ɛ nɩ ‑do a 'mʋ, nɔ‑ di 'lu ‑mɔ mu, ti ‑mʋ' ‑kɔ 'yri 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n di di. ");
INSERT INTO ktj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noe a ti 'yri, nyibli yɩ di la dɛ, 'ʋ 'nɛ la nɔ, 'ʋ kʋkʋɛ la ‑nɩ, 'ʋ pʋɛ la 'waa 'yonʋ 'blɩ. Ɛ nɔ‑ ʋ 'ble 'ʋ kʋa ‑bleble, Noe 'ɛ pa la 'lɩ 'a 'mɩɩ 'kwli, 'tɩ‑ 'nu gbagbʋ 'ɛ bi la ꞊hlɔn, 'a 'yiyinie 'ɛ gba la ꞊nʋ, 'ɛ ‑wɛ la ꞊nʋ bʋ pɛpɛ. ");
INSERT INTO ktj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","‑Tɛblɩ nɩ ‑do, ‑ɛ mi la 'lu ‑mɔ, nyiblo ‑bʋ, ‑ɛ mɔ Lɔtɩ a ti 'yri, nɔ‑ di 'lu ‑mɔ mu ‑wɛ, 'na diditi 'yri. Lɔtɩ a ti 'yri, ‑tonyibli yɩ di la dɛ, 'ʋ 'nɛ la nɔ, 'ʋ ‑tʋɛ la ‑tɛblɩ, 'ʋ ple la, 'ʋ 'dʋɛ la, 'ʋ pɩ la 'kayo. ");
INSERT INTO ktj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kɛɛ, ‑nyrɔwɔ ‑mʋ', Lɔtɩ ‑hɔn la 'lɩ Sodɔmʋdɩɔ 'kwli, ‑ɛ ‑bɩ na kɔ 'nʋ ‑mʋ' 'hʋɛn‑, ‑ʋ 'lɩlɛ nyibli lɛ, ʋ nʋ‑ ‑hɔn la 'lɩ yakɔ 'kwli, 'ʋ ‑wɛ nyibli a pɛpɛ bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ti ‑mʋ' ‑kɔ 'yri, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n di di de, ‑tɛblɩ nɩ ‑do a 'mʋ, ʋ nʋ‑ di 'lu ‑mɔ mu. ");
INSERT INTO ktj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","‑Nyrɔwɔ nɩ ‑do a 'mʋ, nyiblo 'bʋ nɩ 'lɩ 'a 'kayu a ‑yaa 'kwli, bʋ 'gba ci lɛ ‑dodo. Ɛ 'nɩ 'paa 'lɩ 'kayu bʋ, 'a kʋkɔ‑tɛblɩ a bʋbla a ‑tɩ, 'tɩ‑ ɛ 'mʋ ci lɛ 'gba. Nyiblo 'bʋ nɩ 'lɩ 'a ‑ci kɩ, bʋ 'gba ci lɛ ‑dodo. Ɛ 'nɩ 'hɩaan 'lɩ ‑mɔ, ɛ 'nɩ 'die 'lɩ 'dɩɔ. ");
INSERT INTO ktj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Dɛ ‑mʋ', ‑ɛ nu la Lɔtɩ a nʋgba, 'a ‑tɩ bʋ bi 'lɩ 'a mʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nyiblo 'bʋ 'yɛ nɩ ‑hʋa bʋ 'waan nɛ 'a dɩɔnʋ a ‑hʋnhlʋn, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, 'kɩ 'ʋ 'na ‑ta', 'bʋ mɔ, nyiblo a 'mʋ 'bʋ 'kʋ, ɛ di 'a 'klɔ yrayrʋ 'nɩ 'waan ‑nɩ ‑wɛ, 'kɩ 'lɩ Nyɩsʋa yɩ. Kɛɛ, nyiblo 'bʋ ‑wɛn, 'kɩ 'a dɩɔnʋ a ‑hʋnhlʋn bʋ 'wan, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, ‑tɛ ɛ nʋɛ 'mʋ a ‑tɩ, 'bʋ mɔ, nyiblo a 'mʋ 'bʋ 'kʋ, ɛ di kɔ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ, 'kɩ 'lɩ Nyɩsʋa yɩ. ");
INSERT INTO ktj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, ti a 'mʋ 'yri, nyibli nɩ 'hʋɛn 'bʋ pɛ 'ʋ dɛ kɩ bʋ, 'n di ‑ha 'ʋ nyiblo nɩ ‑do, 'mʋ 'ʋ ‑ɛ ‑bɩ bʋ hie. ");
INSERT INTO ktj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nʋgbɩ nɩ 'hʋɛn 'bʋ yɩ ‑kʋbʋ nɩ dui, 'kɩ 'lɩ dugbe nɩ ‑do 'kwli, 'n di ‑ha 'ʋ nyiblo nɩ ‑do, 'mʋ 'ʋ ‑ɛ ‑bɩ bʋ hie.  ");
INSERT INTO ktj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nyibli nɩ 'hʋɛn 'bʋ yɩ ‑kʋan nɩ ni, 'kɩ 'lɩ ‑ci nɩ ‑do kɩ, 'n di gba nyiblo nɩ ‑do, 'mʋ 'ʋ ‑do ‑bɩ bʋ hie.» ");
INSERT INTO ktj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","‑Yusu bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ 'a ‑nagbopʋ 'bɛti꞊e nɩ, ʋ wɛn: «‑Bɩ' ‑tɛblɩ a 'mʋ, ɛ di 'lu ‑mɔ yɩ ‑muu ‑nɩ 'lɩ?» ‑Ɛ ‑bɩ ɛ ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «‑A 'blikʋɛ wɛn 'nɩ: ‑Tɛ ‑mʋ', mʋma 'kuku yɩ 'ʋ bʋ pɛ, 'kɩ ke yɩ 'ʋ lɛ 'kukue ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ɛ pʋ Falisi꞊tumu* a nyibli 'ledʋ ‑bɩ yɩ de, ɛ 'mʋ ꞊nʋ꞊ʋ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, bʋ 'cibi 'ʋ Nyɩsʋa a dɩda, ʋ 'nɩ 'saa 'lɩ. Kɛ‑ ɛ pɩ ꞊nʋ yɩ: ");
INSERT INTO ktj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","«'Kɩ 'lɩ 'dɩɔ ꞊dʋ 'kwli, 'kɩ ‑batipʋnyɔ ꞊dʋ nɩ la 'lɩ. ‑Batipʋnyɔ a 'mʋ, ɛ 'yɩ la Nyɩsʋa a hʋannʋ ‑kɔ, kɔ, ɛ 'yɩ la 'ʋ nyiblo ꞊dʋ a 'ʋ꞊tuulɛ ‑kɔ. ");
INSERT INTO ktj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","'Kɩ 'lɩ 'dɩɔ nɩ ‑do a 'mʋ 'kwli, 'kɩ ‑tʋgbanʋgba ꞊dʋ nɩ la 'lɩ ‑wɛ. ‑Tʋgbanʋgba a 'mʋ, ɛ 'cibi la 'lɩ ‑batipʋnyɔ a 'mʋ ‑mɔ nɩ. 'Bʋ mu 'lɩ, kɛ‑ ɛ pɩ: Ɛ kɔ nyiblo ꞊dʋ, ɛ kɔ 'mʋ 'hʋɛn‑, ‑a kɔ ‑tɩ. 'A ‑tɩ, 'n ‑hʋɛ꞊ɛ nɩ, ‑bʋ nu꞊o, ꞊bʋ kɔ 'ʋ ‑wɔn. ");
INSERT INTO ktj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ti ‑hʋɔhʋɩ, nɔ‑ ‑hi, kɛɛ, ‑batipʋnyɔ a 'mʋ, ɛ 'nɩ ‑hʋa꞊a lɩ꞊ɩ, bʋ ‑nyi nʋgba a 'mʋ ꞊wɔn. Ɛ nɔ‑ ɛ nu ‑nunu, 'ɛ ‑tʋa 'a dɩɔnʋ a 'nyrɛ꞊hɩnhɛn, ɛ wɛn: 'Ɛ mɔ ꞊han‑tɩ, 'nɩ 'yɛ nɩ pie Nyɩsʋa, kɔ, 'n 'yɩ 'ʋ ‑tonyiblo ꞊dʋ a 'ʋ꞊tuulɛ ‑kɔ. ");
INSERT INTO ktj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Kɛɛ, ‑tɛ nʋgba ‑bʋ, ɛ ni 'na 'ku‑hɩhɩa, 'a ‑tɩ, 'n kɔ ꞊bʋ nu꞊o, bʋ kɔ 'ʋ ꞊wɔn. 'Nɩ 'yɩ꞊ɩ ‑nu, ɛ 'tɩɛ di 'mʋ 'ku ‑ha, ɛ 'mʋ꞊ʋ nu ‑nunu, 'na 'klɩ 'mʋ 'lɩ ‑wɛ pɛpɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kɛ‑ ‑Yusu pɩ de, ɛ wɛn: «꞊Bɩ ‑tɩ a 'mʋ, hɩ‑batipʋnyɔ a 'mʋ, ɛ ‑hla, a 'wɩn nɩ? ");
INSERT INTO ktj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nyɩsʋa ‑mɔ ‑bɩ, nyibli ‑mʋ', ɛ ‑ha 'lɩ, 'kɩ bʋ ‑hɛ 'a nyibli, ‑ʋ dɛ꞊ɛ 'tɔ kɔ ‑nyrɛ 'hʋɛn‑, ꞊bɩ ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nu꞊o, bʋ kɔ 'ʋ ꞊wɔn 'ʋ ‑wɛ, ꞊bɩ ɛ di ‑wlɛn 'ʋ bʋ, 'tɩ‑ ɛ 'mʋ ꞊nʋ ‑hɛɛ ‑nɩ? ");
INSERT INTO ktj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, ɛ kɔ bʋ ‑nyi ꞊nʋ ꞊wɔn, ɛ 'mʋ ꞊nʋ ‑hɛɛ ‑nɩ, ti nɩ ‑do a ti 'yri. Kɛɛ, ꞊bʋ 'bɛti 'a mʋ 'na dɛ: Ti ‑mʋ' ‑kɔ 'yri 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n di di, ꞊bɩ 'n di yɛɛ 'nɛ‑ nyibli ‑bʋ, ‑ʋ nu Nyɩsʋa a ꞊wlʋ a yɩkuolɛ lɛ?» ");
INSERT INTO ktj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu pʋ 'ledʋ ‑bɩ, 'kɩ 'ʋ nyibli ‑mʋ' ‑mɔ', ‑ʋ pɩ lɛ, ‑ɛ mɔ, 'waa nɩnabʋɩ 'sii 'ʋ yɩ, 'kɩ 'ʋ Nyɩsʋa ye', 'tɩ‑ ‑ʋ pɩ lɛ, ‑ɛ mɔ, ʋ nɩ 'ʋ 'waa 'bio ‑tonyibli 'lu yɩ, ‑ʋ ni yɩnyre‑tɛblɩ. Kɛ‑ ‑Yusu pɩ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Nyibli nɩ 'hʋɛn, nʋ‑ mu la Nyɩsʋa da mɔ, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ. ‑Ɛ ‑bɩ mɔ Falisi꞊tumu a nyiblo ꞊nɩɔ. (Ɛ nɔ‑ pɩ lɛ, ‑ɛ mɔ, 'a 'yrinaabʋɩ 'sii 'ʋ yɩ.) ‑Ɛ ‑bɩ mɔ 'blʋwli'tɩnyɔ. (Ɛ kɔ ‑nyrɔwɩ, 'ɛ yɩ 'blʋwli a 'mʋ, 'a dɛ 'yri.) ");
INSERT INTO ktj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","‑Tɛ ʋ nyre 'lɩ Nyɩsʋa a 'kagbaʋ bʋ, ‑ɛ ‑bɩ Falisi꞊tumu a nyiblo ‑mʋ', ɛ ‑tʋa Nyɩsʋa a dɩda, ɛ wɛn: Nyɩsʋa o, ‑na 'wio, ‑tɛ ‑nu, ꞊nɩ nu꞊o, 'kɩ 'n 'yɩ nyiblidʋ ‑bʋ yɩ 'wɩ, ‑ʋ mɔ 'yiyrinyibli, 'crɛkɔnyibli kɔ ‑wlawlɩnyibli 'hʋɛn‑. 'N ‑nyi ‑mʋ 'wio de, ‑tɛ ‑nu, ꞊nɩ nu꞊o, 'kɩ 'n 'yɩ 'blʋwli'tɩnyɔ ‑mʋ' yɩ 'wɩ. ");
INSERT INTO ktj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","'N ni ꞊ciiwɩ* nɩ 'hʋɛn, 'kɩ 'lɩ 'wee 'kwli, ɛ kɔ, 'bʋ mɔ, 'nɩ kɔ ‑tɛblɩ nɩ ‑pu, 'a ‑pu a dɛ ‑mʋ', 'n kɔ ꞊bʋ ‑ha 'lɩ꞊ɩ 'lɩ, ꞊bʋ ‑nyi ‑mɔ꞊ɔ. Ɛ nɔ‑ mɔ Falisi꞊tumu a nyiblo a ‑nɛ pʋpʋwin. ");
INSERT INTO ktj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","'Blʋwli'tɩnyɔ ‑mɔ ‑bɩ, ɛ bii yɩ, ɛ mɔ, ɛ 'yɩ 'yii ye' 'du, kɛɛ, 'a dɩɔnʋ 'a dabʋ, nɔ‑ ɛ 'ma ‑wliye bʋ, ɛ wɛn: Nyɩsʋa o, 'mɔ ‑bʋ, ‑ɛ mɔ dɛ'kukununyɔ, yru 'na nyaɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","‑Ɛ ‑bɩ ‑Yusu wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, ‑tɛ 'blʋwli'tɩnyɔ a 'mʋ, ɛ ‑mɛ kle, ɛ mu 'lɩ 'kayu bʋ, ‑ɛ ‑bɩ Nyɩsʋa 'sii 'ʋ꞊ʋ yɩ, 'kɩ 'ʋ 'a dɩɔnʋ ye'. Kɛɛ, ɛ 'yɩ 'ʋ Falisi꞊tumu a nyiblo ‑mʋ' yɩ 'sii ‑nɩ. Ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, nyiblo 'bʋ 'yaa 'lɩ 'a dɩɔnʋ, Nyɩsʋa di 'lɩ꞊ɩ 'nɩ ꞊tɩɔ ‑nɩ, kɛɛ, nyiblo 'bʋ ꞊tɩɔ 'lɩ 'a dɩɔnʋ, Nyɩsʋa di 'lɩ꞊ɩ 'nɩ 'yaa ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ɛ kɔ la ‑nyrɔwɔ ꞊dʋ, 'ʋ gba 'yonʋ ‑Yusu yɩ, 'kɩ ɛ 'mʋ ꞊nʋ dabʋɩ 'lu blɛ pʋ, ɛ 'mʋ Nyɩsʋa da, Nyɩsʋa 'mʋ 'yonʋ a 'mʋ ꞊haandɛ ‑mɔ nu. Kɛɛ, ‑tɛ ‑nagbopʋ* 'ye dɛ a 'mʋ, ‑ɛ ‑bɩ ʋ ‑tʋa 'waa ‑mɔ'pʋplɛ, ʋ wɛn: «A 'nɩ 'haa 'lɩ꞊ɩ 'ku.» ");
INSERT INTO ktj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ɛ nɔ‑ mɔ ‑Yusu bʋ da 'a ‑nagbopʋ, ɛ wɛn: «Ba ‑ha 'yonʋ mɛ lɛ, bʋ di 'nɛ‑ 'mʋ ‑mɔ. A 'nɩ 'kaa 'lɩ ꞊nʋ yɩ, ‑ɛ nu꞊o, nyibli ‑mʋ', ‑ʋ 'wɩ‑ 'yonʋ ‑bʋ yɩ, ʋ nʋ‑ di 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli pa. ");
INSERT INTO ktj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, nyiblo 'bʋ 'yɛ nɩ ‑ha Nyɩsʋa mɛ lɛ, 'bʋ 'yɛ nɩ kɔɔ ꞊nɛ win kɩ, ꞊wɩ yɩ ‑tɛ 'hɩangbe ni, 'ɛ ‑hɛ 'a 'baɩ mɛ lɛ, 'a 'baɩ 'ɛ kʋɛ ꞊nɛ win kɩ, ‑ɛ ‑bɩ nyiblo a 'mʋ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ pa 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","‑Juukʋɛ* a nyiblo gbagbʋ ꞊dʋ ‑nɩ 'ʋ, ɛ nɔ‑ 'bɛti ‑Yusu, ɛ wɛn: «Tɔɔnyɔ o, ‑mɔ ꞊haannyiblo ꞊nɩɔ. Dɛ a 'dɩ ‑bɩ 'n di nu, 'tɩ‑ Nyɩsʋa a 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ, 'mʋ꞊ʋ kɔ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","‑Ɛ ‑bɩ ‑Yusu wɛn: «Dɛ‑ kɔ 'mɔ ‑dɛɛ ꞊haannyiblo 'lɩ? Nyiblo ꞊dʋ 'yɩ ꞊haannyiblo 'pa‑, 'bʋ 'yɩ Nyɩsʋa nɩ ‑do. ");
INSERT INTO ktj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","‑Yi Nyɩsʋa a tete nɩ, ‑ʋ mɔ: ꞊Nɩ 'nuo 'lɩ ‑wlawlɩ, ꞊nɩ 'laa 'lɩ nyiblo, ꞊nɩ 'yrie 'lɩ, ꞊nɩ 'pʋʋ 'lɩ nyiblo hɩ kɩ, ꞊tuu 'ʋ ‑na 'baɩ kɔ ‑na dii 'hʋɛn‑ 'ʋ, 'kɩ 'lɩ nʋɛlɛ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","‑Ɛ ‑bɩ ɛ wɛn: «Kʋɛ la 'lɩ 'na 'hɩandɛ 'yie bʋ, ‑bʋ yɛ ‑nyrɔwɔ ‑bʋ kɩ, tete a pɛpɛ a 'mʋ, 'n ꞊tuu 'ʋ꞊ʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","‑Tɛ ‑Yusu 'wɩn, ‑ɛ ‑bɩ kɛ‑ ɛ pɩ꞊ɩ yɩ, ɛ wɛn: «Ɛ hie 'ʋ ‑mʋ dɛ nɩ ‑do. Ɛ nɔ‑ mɔ, mu ‑bʋ plo ‑na kʋkɔ‑tɛblɩ a pɛpɛ ‑mʋ', kɔ, ‑bʋ ꞊gla 'a 'wliyɛ ꞊hɩʋɛnnyibli lɛ, Nyɩsʋa 'mʋ ‑mʋ ꞊haandɛ gbagbʋ ‑mɔ nu, 'kɩ 'lɩ yakɔ 'kwli. ꞊Nɩ nu 'kɩ꞊ɩ, ‑ɛ ‑bɩ kʋɛ 'mʋ ꞊wien lɛ, ꞊mʋ 'na ‑nagbopi* ‑hɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","‑Tɛ ɛ 'wɩn ‑tɩ a 'mʋ, ‑ɛ ‑bɩ 'a ꞊wlʋ bi ꞊hlɔn dɩakɩ, ‑ɛ nu꞊o, ‑tɛblɩ ɛ ‑kɔ, ɛ ‑hʋ nɩ dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","‑Tɛ ‑Yusu 'ye꞊e, ‑ɛ mɔ, nyɩbɛhɩan a 'mʋ, 'a ꞊wlʋ bi ꞊hlɔn, ‑ɛ ‑bɩ ɛ wɛn: «Ɛ di 'mʋ 'nɩ kla, 'kɩ dɛkɔnyɔ bʋ di 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli pa. ");
INSERT INTO ktj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","'Ɛ mɔ ꞊han‑tɩ, ɛ kla 'mʋ nɩ, 'kɩ 'ʋ dɛkɔnyɔ ‑mɔ, 'tɩ‑ ‑ɛ kuo nɛ 'a kʋkɔ‑tɛblɩ ꞊wlʋ yɩ, bʋ kuo Nyɩsʋa ꞊wlʋ yɩ, kɔ, bʋ pa 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli, 'ɛ ‑hi 'ʋ ꞊gbukɩ‑so* bʋ naa 'ʋ 'die a 'hʋɔ 'yri.» ");
INSERT INTO ktj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","‑Tɛ nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, ʋ 'wɩn ‑Yusu a pʋpʋwin a 'mʋ, ‑ɛ ‑bɩ ʋ wɛn: «'Bʋ kɔ bʋ nɩ 'mʋ lɛ, nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ pa 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","‑Ɛ ‑bɩ ‑Yusu wɛn: «‑Tonyiblo a dɩɔnʋ a 'klɩ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nu꞊o, bʋ kuo Nyɩsʋa ꞊wlʋ yɩ, 'tɩ‑ bʋ pa 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli. Kɛɛ, 'kɩ 'lɩ Nyɩsʋa a 'klɩ 'kwli, ɛ ‑wɛ 'lɩ꞊ɩ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","‑Ɛ ‑bɩ kɛ‑ Piɛlɩ pɩ ‑Yusu yɩ: «‑A mʋ ‑mɔ ‑bɩ 'lɩ? 'Ye kɛ, ‑a hie 'ʋ ‑aan nyibli bʋ, ɛ kɔ ‑aan ‑tɛblɩ a pɛpɛ 'hʋɛn‑, ꞊a yɩ ‑mʋ wien lɛ kʋɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","‑Ɛ ‑bɩ ‑Yusu wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, nyiblo 'bʋ hie 'ʋ 'a 'kayu bʋ, 'a nʋgba, 'a 'dɩayɩnʋ, kɔ 'a 'dii kɔ 'a 'baɩ 'hʋɛn‑ bʋ, ɛ kɔ 'a 'yonʋ, ‑tɛ Nyɩsʋa kɔɔ ꞊nɛ win kɩ a ‑tɩ, ");
INSERT INTO ktj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","‑ɛ ‑bɩ nyiblo a 'mʋ, 'klɔ ‑bʋ, ‑a nɩ 'nɛ‑ ‑mɔ, ‑tɛblɩ, Nyɩsʋa di꞊e ‑nyi, ɛ di 'nɩ ‑hʋ, ɛ 'mʋ 'ʋ dɛ ‑mʋ', ɛ hie 'ʋ bʋ 'ʋ ‑hi. 'Ya 'ʋ 'lu de, ti ‑mʋ', ‑ɛ kɔ 'yri Nyɩsʋa di 'ʋ 'klɔ yrayrʋ ‑bɩ 'ʋ ‑nuu ‑nɩ, nyiblo a 'mʋ, Nyɩsʋa di ‑nyi꞊e 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* nɩ ‑pu ꞊tu 'ʋ 'hʋɛn ‑mʋ' 'hʋɛn‑, ʋ bii yɩ. ‑Tɛ ʋ bii yɩ, kɛ‑ ɛ pɩ 'kɩ ꞊nʋ yɩ, ɛ wɛn: «Ba pʋ 'mʋ nʋa yɩ bʋ. ‑A mi Jrusrɛdɩɔ 'kwli. 'Bʋ mɔ, ꞊ba nyre 'lɩ, ‑ɛ ‑bɩ ‑tɛblɩ a pɛpɛ ‑mʋ', Nyɩsʋa a winwlɔn‑hanyʋ* 'crɩ la, 'kɩ 'ʋ 'mʋ kɩ, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, ‑tɛblɩ a pɛpɛ a 'mʋ, ɛ di mu 'lu ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nyibli ‑mʋ', ‑ʋ 'yɩ Nyɩsʋa ‑yi, ʋ nʋ‑ ʋ di 'mʋ ‑jɩ' pʋ, nyibli a 'mʋ, ʋ 'mʋ 'mʋ 'caa ‑nɩ, ʋ 'mʋ 'mʋ ꞊hɩʋɛn ꞊tu, kɔ, ʋ 'mʋ 'mʋ hɩʋn 'hrin, ");
INSERT INTO ktj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","kɔ, ʋ 'mʋ 'mʋ lɔkɔ ‑bii ‑nɩ, 'tɩ‑ ʋ 'mʋ 'mʋ 'la. ‑Nyrɔwɩ nɩ 'hʋɛn 'bʋ ‑hi, ta a ‑nyrɔwɔ, 'tɩ‑ 'mʋ 'lɩ 'kʋkʋnyibli 'nyɩ ‑hɔn, 'mʋ 'klɔ 'hrɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","‑Tɛ ‑Yusu hla ‑tɩ a 'mʋ, dɛ a 'mʋ, 'a pʋpʋwin ꞊hɛn 'nyrɛ, 'a ‑nagbopʋ 'yɩ꞊ɩ lɛ ‑yru. Ɛ ‑hli ꞊nʋ 'yi kɩ. Dɛ ‑kɔ ‑tɩ ɛ ‑hla, ʋ 'yɩ꞊ɩ ‑yi. ");
INSERT INTO ktj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ 'mʋɛ 'dɩɔ ‑mʋ', ‑ɛ mɔ Seliko yrɛ, nyibli ‑hʋɔhʋɩ, nʋ‑ yɩ ꞊nʋ ꞊wien kʋɛ. 'Kɩ 'ʋ 'hrunyɩa 'yri, 'kɩ 'yii'dɔnyɔ ꞊dʋ nɩ 'ʋ bʋ, 'ɛ ‑hʋɛ nyibli 'wli lɛ, ‑ɛ di꞊e nu, ɛ 'mʋ dɛ di. ");
INSERT INTO ktj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","‑Tɛ ɛ 'wɩn nyibli a 'mʋ, ‑ʋ yɩ 'lɩ di a win, ‑ɛ ‑bɩ ɛ 'bɛti nɩ, ɛ wɛn: «Dɛ a 'dɩ ‑bɩ ‑mi 'lu ‑mɔ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ɛ nɔ‑ ‑mɔ bʋ ‑hɩhɩa꞊a klɛ, ‑ɛ mɔ, Nasalɛtɩ a ‑Yusu, ‑ɛ yɩ ‑hi. ");
INSERT INTO ktj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","‑Ɛ ‑bɩ ɛ 'yaa 'lɩ win, ɛ wɛn: «‑Yusu o, Dafidɩ a 'Yu, yru 'na nyaɩ mɔ!» ");
INSERT INTO ktj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nyibli ‑mʋ', ‑ʋ kɔ ‑Yusu 'hʋɛn‑ ‑mi la, ʋ ‑tʋa 'a ‑mɔ'pʋplɛ, ʋ wɛn: «Ma wien mɔ!» Kɛɛ, ɛ hɩa nɩ, 'ɛ 'yaa 'lɩ win dɩakɩ de, ɛ wɛn: «‑Yusu o, Dafidɩ a 'Yu, yru 'na nyaɩ mɔ!» ");
INSERT INTO ktj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","‑Tɛ ‑Yusu 'wɩn 'a win, ‑ɛ ‑bɩ ɛ nyra bʋ, 'ɛ lee nyibli, bʋ ya 'ʋ ꞊nɛ꞊ɛ 'hʋɩ. ‑Tɛ 'yii'dɔnyɔ a 'mʋ, ɛ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, ‑ɛ ‑bɩ ‑Yusu 'bɛti꞊e nɩ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Dɛ a 'dɩ ‑bɩ ‑hʋɛ ꞊bʋ nu ‑mʋ ‑mɔ 'lɩ?» ‑Ɛ ‑bɩ ɛ ꞊tu꞊o ꞊wɔn, ɛ wɛn: «Kʋkɔnyɔ o, 'n ‑hʋɛ꞊ɛ nɩ, ‑bʋ nu꞊o, 'na 'yii ‑bʋ, ‑ɛ klɛ, bʋ klɛ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","‑Ɛ ‑bɩ ‑Yusu lee ꞊nɛ nɩ, ‑ɛ mɔ: «‑Na 'yii bʋ ‑wɛ. ‑Tɛ ‑kuo 'mʋ ꞊wlʋ yɩ a ‑tɩ, ɛ nɔ‑ kɔ ‑tɩ, 'nɩ nu꞊o, ‑na 'yii 'ʋ klɛ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ ɛ ‑tʋa lɛyuyruo, 'ɛ bi 'ʋ ‑Yusu ke', 'ɛ ‑tʋa 'a ꞊wienlɛkʋkʋɛ, 'ɛ pɩ Nyɩsʋa 'nyrɛ lɛ. Nyibli a pɛpɛ ‑mʋ', ‑ʋ yɩ ‑tɛblɩ a 'mʋ 'ye, ʋ yɩ ‑nyi Nyɩsʋa ‑tɩ a 'yi'bʋbʋa. ");
INSERT INTO ktj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu pa 'lɩ Selikodɩɔ 'kwli, 'ɛ yɩ꞊ɩ ꞊tɩɔ 'bɛ. ");
INSERT INTO ktj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","'Kɩ 'lɩ 'dɩɔ a 'mʋ 'kwli, 'kɩ nyɩbɛhɩan ꞊dʋ nɩ 'lɩ. 'A 'nyrɛ mɔ Sase. Ɛ mɔ 'blʋwli'tɩnyʋ a nyiblo gbagbʋ ꞊nɩɔ, 'ɛ mɔ dɛkɔnyɔ. (Nyibli a ꞊wlɩ yraa la 'blʋwli'tɩnyʋ nɩ, ‑tɛ ʋ yɩ la 'wli 'yri a ‑tɩ. ‑Tɛ 'a 'bio 'blʋwli'tɩnyʋ ni, 'ʋ ‑hʋɛ ‑tonyibli 'wli dɩakɩ, kɛ‑ 'a 'mumu, ɛ ni꞊e ‑wɛ.) ");
INSERT INTO ktj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nyɩbɛhɩan a 'mʋ, nɔ‑ ‑hʋɛ ‑bʋ 'ye꞊e, nyiblo a 'dɩ ‑bɩ ‑Yusu pa 'mʋ. Kɛɛ, Sase 'gbugbe nɩ. 'A ‑tɩ, ɛ 'yɩ 'lɩ ‑Yusu a 'yiye 'lɩ ‑wɛ, ‑kɔtɩ ‑tonyibli ꞊glaa 'lɩ ‑Yusu lɛ, ʋ ‑hʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ɛ nɔ‑ mɔ bʋ 'gba ci, bʋ mu 'lɩ ye', ‑tɩtɛ ‑mʋ', ‑Yusu di 'ʋ ‑naa ‑nɩ. 'Kɩ pepetugbɛ ꞊dʋ nyra 'ʋ bʋ, 'ʋ dɛɛ ꞊nɛ sikomɔ. Ɛ nɔ‑ kɔ yra ɛ 'ya 'lɩ, ‑ɛ di꞊e nu, ɛ 'mʋ ‑Yusu 'ye. ");
INSERT INTO ktj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","'Kɩ ɛ nɩ 'lɩ, ‑ɛ ‑bɩ ‑Yusu nyre 'ʋ ‑tɩtɛ a 'mʋ nɩ, ɛ 'wla pepetugbɛ a 'mʋ 'yi wla. ‑Ɛ ‑bɩ ɛ 'ye Sase nɩ, ɛ wɛn: «Sase, pʋ 'lɩ 'klɩ lɛ, ‑bʋ ꞊tɩ, ‑ɛ nu꞊o, kɩkɛ ‑bʋ, 'kɩ 'n di kɛ 'lɩ ‑mʋ ‑mɔ pa.» ");
INSERT INTO ktj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kɩka kɩka, Sase 'ɛ ꞊tɩ, 'ɛ gba 'lɩ ‑Yusu 'kayu bʋ, 'ɛ 'ble꞊e kʋa ‑tɛɛ, 'kɩ 'lɩ plɔ a bleelɛ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nyibli a pɛpɛ ‑mʋ', ‑ʋ nɩ 'ʋ, ʋ 'ye꞊e nɩ, ‑ɛ mɔ, ‑Yusu pa 'lɩ Sase ‑mɔ. ‑Tɛ ʋ 'ye 'kɩ dɛ a 'mʋ, ‑ɛ ‑bɩ ʋ ‑tʋa lɛ'pʋplɛlɛ, ʋ wɛn: «'Kɩ ɛ pa 'lɩ dɛ'kukununyɔ a ‑tɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Bʋ nɩ 'kɩ 'lɩ 'kayu bʋ, Sase 'du ye', 'ɛ nyra bʋ, 'kɩ 'ʋ ‑Yusu ye', 'ɛ yɩ꞊ɩ ‑lee ‑nɩ, ɛ wɛn: «Kʋkɔnyɔ o, 'na kʋkɔ‑tɛblɩ ‑bʋ, 'n di 'bɛ꞊ɛ ꞊tɩɔ, 'mʋ 'a 'kʋtɩɔ ‑bɩ ꞊hɩʋɛnnyibli ‑nyi. 'Bʋ mɔ, 'nɩ ‑ha ‑tonyiblo dɛ ‑jɩ', dɛ a 'mʋ, 'a gble nɩ ‑hɛn, ɛ nɔ‑ 'n di꞊e ‑nyi.» ");
INSERT INTO ktj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'kɩ Sase yɩ, ɛ wɛn: «Kɩkɛ ‑bʋ, ‑kɔ ‑na 'kayubʋkʋɛ 'hʋɛn‑, Nyɩsʋa wa kɛ 'a mʋ nɩ. Abrahamʋ, ‑ɛ mɔ Nyɩsʋa a dakɔ ‑bʋ a 'baɩ gbagbʋ, ‑na 'mumu, ‑mɔ 'a 'yu a 'yu ‑bɩ ꞊nɩɔ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","'Mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'mɔ Nyɩsʋa lee 'nɛ‑ ‑tʋtʋ kɩ, 'kɩ 'mʋ nyibli ‑mʋ', ‑ʋ 'wan, ‑ʋ hlɔɔ Nyɩsʋa ‑mɔ lɛ lɛ ꞊mʋɔ, 'mʋ ꞊nʋ wa, 'kɩ 'ʋ 'waa dɛ 'kuku, ʋ ‑nu a ‑ta', ʋ 'mʋ Nyɩsʋa yrɛ 'mʋɛ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, ‑ʋ pʋ wɛn ‑Yusu nʋa yɩ bʋ, 'kɩ ʋ nɩ 'ʋ, ‑Yusu 'ɛ pʋ 'ledʋ ‑bɩ. ‑Tɛ ‑Yusu 'mʋɛ la Jrusrɛdɩɔ yrɛ, nyibli a 'mʋ, ʋ 'ye la꞊a nɩ, ‑ɛ mɔ, Nyɩsʋa a 'klɔ yrayrʋ mi la ‑wlu ꞊tu mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","‑Yusu ‑hʋɛ bʋ lee la ꞊nʋ, ‑ɛ mɔ, ɛ 'yɩ꞊ɩ 'pa‑, ɛ nɔ‑ nu꞊o, 'ɛ pʋ la ꞊nʋ 'ledʋ yɩ, ɛ wɛn: «꞊Tugba gbagbʋ ꞊dʋ a nyiblo, nɔ‑ mi la 'dagba blɔblʋ, 'kɩ 'lɩ 'kɩɩnpʋ nɩ 'hʋɛn ‑mɔ, ‑ɛ di꞊e nu, 'kɩɩnpʋ a 'mʋ, ʋ 'mʋ꞊ʋ nu, ɛ 'mʋ 'blʋgbakʋtɩɔ ‑bɩ a 'kɩɩn ‑hɛ. ");
INSERT INTO ktj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","‑Tɛ ɛ 'mʋ mu, ‑ɛ ‑bɩ ɛ da 'a ‑kʋannunyibli nɩ ‑pu ‑mʋ' nɩ, 'ɛ hie ꞊nʋ 'wliblɛ nɩ ‑pu lɛ, 'a ‑nɛ nyiblo 'bʋ nɩ 'ʋ, 'a ‑nɛ 'wliblɔ, 'tɩ‑ 'ɛ lee ꞊nʋ, ɛ wɛn: 'Wliblɛ ‑bʋ, 'n hie 'a mʋ lɛ, ba hla 'a kʋɛsɛ, 'tɩ‑ 'mʋ kle ‑mɛ. ");
INSERT INTO ktj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kɛɛ, nyiblo gbagbʋ a 'mʋ, nyibli yraa ꞊nɛ nɩ, 'ʋ lee nyibli, 'kɩ bʋ lee 'blʋgba a 'kɩɩnpʋ, ‑ɛ mɔ, ʋ 'nɩ ‑hʋa꞊a lɩ꞊ɩ, 'kɩ bʋ ‑hɛ 'waa 'kɩɩn. ");
INSERT INTO ktj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kɛɛ, kɛ‑ ɛ nɩ 'mʋ, 'ʋ ‑nyi꞊e 'kɩɩndɛ, 'ɛ di 'bli. ‑Tɛ ɛ di 'kɩ, ‑ɛ ‑bɩ nyibli ‑mʋ', ɛ hie la 'wliblɛ lɛ, ɛ da ꞊nʋ nɩ, ‑ɛ di꞊e nu, ‑tie 'a ‑nɛ nyiblo 'yee 'lɩ 'a ‑nɛ kʋɛsɛ 'kwli, ɛ 'mʋ꞊ʋ yi. ");
INSERT INTO ktj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","‑Tɛ yɩ‑hɛnyiblo nyre 'ʋ, ‑ɛ ‑bɩ ɛ wɛn: 'Na 'masɛ o, 'wliblɔ ‑mʋ', ‑hie la 'mʋ lɛ, 'n hla 'a kʋɛsɛ nɩ, 'ɛ pʋ 'ʋ 'wliblɛ nɩ ‑pu ‑bɩ 'lu. ");
INSERT INTO ktj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‑Ɛ ‑bɩ 'a 'masɛ wɛn: Ɛ nu ‑tɛɛ. ‑Mɔ ꞊haan‑kʋannunyɔ ꞊nɩɔ. ‑Tɛblɩ ‑bʋ, ‑ɛ 'yɩ ‑hʋ, 'n ‑nyi ‑mʋ, ‑nuu ꞊nɛ ‑kʋan 'yri ‑tɛɛ. 'A ‑tɩ, 'n di ‑nyi ‑mʋ 'klɩ, 'kɩ ‑bʋ kɔɔ 'dɩɩ nɩ ‑pu win kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","‑Tɛ yɩ‑hɛnyiblo ‑hi, ‑ɛ ‑bɩ 'hʋɛn a nyiblo nyre 'ʋ nɩ, ɛ wɛn: 'Na 'masɛ o, 'wliblɔ ‑mʋ', ‑hie la 'mʋ lɛ, 'n hla 'a kʋɛsɛ nɩ, 'ɛ pʋ 'ʋ 'wliblɛ nɩ ꞊hun ‑bɩ 'lu. ");
INSERT INTO ktj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","‑Ɛ ‑bɩ 'a 'masɛ wɛn: 'N di ‑nyi ‑mʋ 'klɩ, 'kɩ ‑bʋ kɔɔ 'dɩɩ nɩ ꞊hun ‑bɩ win kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","‑Tɛ 'hʋɛn a nyiblo ‑hi, ‑ɛ ‑bɩ ta a nyiblo nyre 'ʋ nɩ, ɛ wɛn: 'Na 'masɛ o, 'wliblɔ ‑bʋ, ‑hie la 'mʋ lɛ, ɛ nɔ‑ ‑bʋ. 'N mʋa mɔ 'wliblɔ a 'mʋ lɛ, 'kɩ 'lɩ danʋ 'kwli, 'nɩ ‑hli mɔ꞊ɔ ‑tɛɛ. ");
INSERT INTO ktj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","'N yɩ pie la ‑na hʋannʋ, ‑ɛ nu꞊o, ‑na ŋmlɩ 'yakla nɩ dɩakɩ. Dɛ ‑mʋ', ꞊yɩ bʋ ꞊tu, ɛ nɔ‑ ‑pʋ lɛ ‑bʋ gba, kɔ, 'dʋdɔ‑tɛblɩ ‑mʋ', ꞊yɩ 'dɔ, ɛ nɔ‑ pʋ lɛ ‑bʋ 'cɛ. ");
INSERT INTO ktj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","‑Ɛ ‑bɩ 'a 'masɛ wɛn: ‑Mɔ ‑kʋannunyɔ ꞊nɩɔ, ‑ɛ kɔ 'klɔ ‑nyre yɩ. ‑Na dɩɔnʋ a pʋpʋwin 'n di nu, 'mʋ ‑na ‑bati pʋ. ‑Yi꞊e nɩ, ‑ɛ mɔ, 'na ŋmlɩ 'yakla nɩ, kɔ, 'dʋdɔ‑tɛblɩ ‑mʋ', 'n 'yɩ 'dɔ, ɛ nɔ‑ 'n pʋ lɛ, ꞊bʋ 'cɛ. ");
INSERT INTO ktj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","'A ‑tɩ, ‑kɔ ‑bʋ pʋ wɛn 'lɩ 'na 'wliblɔ a 'mʋ ‑bakɩ', ‑ɛ di꞊e nu, didie ‑bʋ, 'n ‑di, 'mʋ wɛn 'na 'wliblɔ ‑hʋa, ɛ kɔ 'a dɛ ‑mʋ', ‑ɛ di wɛn 'ʋ꞊ʋ 'lu bi 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ɛ nɔ‑ mɔ 'a 'masɛ bʋ lee nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, ɛ wɛn: Ba ‑ha꞊a 'a ‑nɛ 'wliblɔ a 'mʋ ‑jɩ', ba ‑nyi꞊e nyiblo ‑bʋ, ‑ɛ kɔ 'wliblɛ nɩ ‑pu. ");
INSERT INTO ktj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","‑Ɛ ‑bɩ ʋ wɛn: 'Masɛ o, ɛ kɔ 'wliblɛ nɩ ‑pu. ");
INSERT INTO ktj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‑Ɛ ‑bɩ ɛ ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: 'A ‑nɛ nyiblo, ‑ɛ kɔ ‑tɛblɩ ‑hʋɔhʋɩ, ɛ nɔ‑ ʋ di ‑tɛblɩ ‑bɩ ‑nyi. Kɛɛ, nyiblo ‑mʋ', ‑ɛ kɔ ‑tɛblɩ ꞊yɩ ‑hʋ, ʋ kɔ bʋ ‑ha ꞊nɛ꞊ɛ ‑jɩ'. ");
INSERT INTO ktj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","꞊Hɩan ‑mɔ de, nyibli ‑mʋ', ‑ʋ yraa 'mʋ, ‑ʋ 'yɛ nɩ ‑hʋa ꞊bʋ ‑hɛ 'waa 'kɩɩn, ba ya 'mʋ ꞊nʋ yɩ, a 'mʋ ꞊nʋ 'la.» ");
INSERT INTO ktj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","‑Yusu bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ɛ pʋ nyibli ‑mʋ' ye', 'ʋ mi 'lɩ Jrusrɛdɩɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","‑Tɛ ʋ 'mʋɛ 'dɩɩ ‑mʋ', ‑ʋ mɔ Bɛtɩfase kɔ Betani 'hʋɛn‑ yrɛ, ‑ɛ ‑bɩ 'kɩ ʋ mu 'lɩ dʋgba ‑mʋ' ꞊hlɔn, ‑ɛ kɔ 'lu olifieti nɩ 'lɩ, 'ɛ lee nɛ 'a ‑nagbopʋ* nɩ 'hʋɛn, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«Ba mu 'lɩ 'dɩɔ ‑mʋ' 'kwli, ‑ɛ nɩ 'lɩ 'a mʋ ye'. 'Bʋ mɔ, 'ba pa 'lɩ 'dɩɔ a 'mʋ 'kwli, a di yɛɛ 'ʋ 'kasrayu, ʋ mʋa ‑nɩ bʋ. Nyiblo 'yɩ ‑hʋan 'ʋ꞊ʋ kɩ nɩ 'yɛɛ. Ba ꞊wlɛ꞊ɛ, ba ya 'mɔ꞊ɔ yɩ. ");
INSERT INTO ktj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","'Bʋ mɔ, nyiblo ꞊dʋ 'bʋ 'bɛti 'a mʋ: Dɛ‑ kɔ ‑tɩ 'a yɩ꞊ɩ ꞊wlɛ 'lɩ? ‑ɛ ‑bɩ kɛ‑ ba pʋ: Kʋkɔnyɔ, ɛ nɔ‑ ‑hʋɛ꞊ɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","‑Tɛ ʋ nyre 'lɩ 'dɩɔ a 'mʋ 'kwli, ‑ɛ ‑bɩ ɛ mɔ ꞊han‑tɩ, 'kɩ ʋ yɛɛ 'ʋ 'kasrayu a 'mʋ bʋ, ꞊wɩ yɩ, ‑tɛ ‑Yusu nu wɛn 'a hɩhla, ");
INSERT INTO ktj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","'ʋ ‑tʋa 'a ꞊wʋwlɛ. ‑Ɛ ‑bɩ kɛ‑ 'kasrayu a 'mʋ, 'a kʋkɔnyibli pɩ ꞊nʋ yɩ, ʋ wɛn: «Dɛ‑ kɔ ‑tɩ 'a yɩ 'kasrayu ‑bʋ ꞊wlɛ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","‑Ɛ ‑bɩ ʋ ꞊tu ꞊nʋ ꞊wɔn, ʋ wɛn: «‑Aan Kʋkɔnyɔ, nɔ‑ ‑hʋɛ꞊ɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ɛ nɔ‑ mɔ bʋ ya꞊a ‑Yusu yɩ. ‑Tɛ ʋ ya꞊a, ‑ɛ ‑bɩ ʋ pʋ 'ʋ 'waa danɩ 'kasrayu a 'mʋ kɩ blɛ, 'tɩ‑ 'ʋ ‑hɛɛ ‑Yusu, 'ɛ 'ya 'ʋ 'kasrayu a 'mʋ kɩ. (Ɛ 'wɩ yɩ, ɛ tʋɛ ꞊nɛ nyibli nɩ, ‑ɛ mɔ, ɛ mɔ bodɩɔ ꞊nɩɔ, ‑ɛ yɛ kɩbʋwɛɛnlɛ, ɛ 'yɩ tʋ 'pa‑, ɛ 'nɩ ‑ya꞊a lɩ꞊ɩ. Ɛ nɔ‑ kɔ ‑tɩ 'ɛ 'ya 'ʋ 'kasra a 'mʋ kɩ.) ");
INSERT INTO ktj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bʋ yɩ 'kɩ nɩ mi, nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, ‑ɛ ‑bɩ ʋ pʋ 'ʋ 'waa danɩ 'hru wlɔn blɛ, ‑Yusu 'ɛ nɛ꞊ɛ klɛ. ");
INSERT INTO ktj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","‑Tɛ ʋ yɩ Jrusrɛ yrɛ nɩ 'mʋɛ ‑nɩ, ‑ɛ ‑bɩ 'kɩ ʋ nyre 'ʋ 'hrukʋtɩɔ ‑mʋ', ‑ɛ ‑hɔn 'lɩ olifieti a dʋgba 'lu, ‑ɛ mi 'lɩ Jrusrɛ. ‑Ɛ ‑bɩ nyibli a pɛpɛ ‑mʋ', ‑ʋ yɩ ‑Yusu ꞊wien lɛ kʋɛ, ʋ ‑tʋa dɔdʋ a nunuo, 'ʋ 'yɛɛ 'lɩ win, 'ʋ pɩ Nyɩsʋa 'nyrɛ lɛ, 'kɩ 'ʋ ꞊wlɩlɛkɛɛ‑tɛblɩ a pɛpɛ ‑mʋ', ɛ ‑nu a ‑ta', ");
INSERT INTO ktj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ʋ wɛn: «‑Na 'wio, ‑mɔ bodɩɔ ‑bʋ, ‑ɛ yɩ 'lɩ di, 'kɩ 'lɩ Nyɩsʋa a 'nyrɛ 'kwli, Nyɩsʋa bʋ ‑nyi ‑mʋ ‑tɩ a 'yi'bʋalɛ. Nyɩsʋa, ‑ɛ nɩ 'lɩ yakɔ 'kwli, nɔ‑ yɩ ‑a mʋ kɩbʋwɛɛnlɛ ‑nyi. ‑Tɩ a 'yi'bʋalɛ, 'kɩ 'ʋ꞊ʋ ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","'Kɩ 'lɩ nyibli a 'mʋ 'nyɩ, Falisi꞊tumu* a nyibli ‑bɩ nɩ 'lɩ. Kɛ‑ ʋ pɩ ‑Yusu yɩ: «Tɔɔnyɔ o, lee ‑na ‑nagbopʋ, bʋ 'kee ‑cici a lɛpʋpʋʋ!» ");
INSERT INTO ktj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, 'bʋ mɔ, 'bʋ 'kee ‑cici a lɛpʋpʋʋ, 'hɩ ‑bʋ, ‑ʋ nɩ 'hru wlɔn lɛ, nʋ‑ di ‑cici lɛ pʋ, ʋ 'mʋ 'mʋ 'nyrɛ lɛ pʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","‑Tɛ ‑Yusu 'mʋɛ 'kɩ Jrusrɛdɩɔ yrɛ, ɛ 'ye꞊e, ‑ɛ ‑bɩ ɛ ‑tʋa wuwe, 'kɩ 'ʋ ‑tɛblɩ nɩ ‑tie ‑mʋ', ‑ɛ di 'ʋ nyre, 'kɩ 'ʋ 'dɩɔ a 'mʋ, 'a ‑ta', ");
INSERT INTO ktj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ɛ wɛn: «'N ‑hʋɛ wɛn꞊ɛ nɩ dɩakɩ, ‑nyrɔwɔ ‑bʋ, 'a mʋ Jrusrɛdɩɔ a nyibli, ‑tɛblɩ ‑bʋ, ‑ɛ mi kɛ 'lu ‑mɔ, 'kɩ ba yru wɛn꞊ɛ' lɛ. ‑Tɛblɩ a 'mʋ, ɛ ‑wɛ 'lɩ bʋ nu wɛn꞊ɛ nɩ, a kɔ Nyɩsʋa 'hʋɛn‑, ba kɔ wɛn kɩbʋwɛɛnlɛ. Kɛɛ, ‑tɛ ti nɛ ‑bʋ, ‑tɛblɩ a 'mʋ, ɛ ‑hli 'a mʋ 'yi kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, ti di 'ʋ 'nɩ nyre, ‑ɛ kɔ 'yri dakɔ ‑bɩ, ‑ʋ mɔ 'aan yraanyibli, ʋ di 'ʋ ‑dii ‑nɩ, ʋ 'mʋ 'lɩ 'dɩɔ ‑bʋ 'lɩ ꞊glaa ‑nɩ, ‑ɛ di꞊e nu, 'bʋ yɩ 'a mʋ ‑mɔ nɩ ‑wɛn, nyiblo ꞊dʋ 'nɩ ꞊ha 'hrɩ, ");
INSERT INTO ktj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ʋ 'mʋ 'a mʋ bʋ ‑wɛ pɛpɛ, a kɔ 'aan ‑tɛblɩ a pɛpɛ 'hʋɛn‑, kɔ, ʋ 'mʋ 'aan 'dɩɔ a 'kayo a pɛpɛ 'wla, ‑ɛ nu꞊o, ti ‑mʋ', ‑ɛ kɔ 'yri Nyɩsʋa dii nɛ 'a mʋ kɩ, a 'yɩ ti a 'mʋ ‑yru.» ");
INSERT INTO ktj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","‑Tɛ ʋ nyre 'lɩ Jrusrɛdɩɔ 'kwli, ‑ɛ ‑bɩ 'kɩ ‑Yusu pa 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli. 'Kɩ 'lɩ ‑yaa a 'mʋ 'kwli, 'kɩ puplonyibli nɩ 'lɩ, 'ʋ ple 'wlugba‑tɛblɩ, 'kɩ 'ʋ Nyɩsʋa a ‑cɔhlʋn* a pipie a ‑ta'. ‑Tɛ ɛ yɛɛ 'ʋ ꞊nʋ bʋ, ‑ɛ ‑bɩ ɛ ‑tʋa 'waa lɛbʋbla. ");
INSERT INTO ktj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «Ɛ 'crɩɩ nɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ: Nyɩsʋa wɛn 'nɩ: 'Na 'kayu nɩ 'ʋ nɩ, ‑ɛ di꞊e nu, nyibli 'mʋ 'lɩ 'mʋ ‑daa ‑nɩ.» Kɛ‑ ‑Yusu pɩ de, ɛ wɛn: «Kɛɛ, 'a mʋ ‑mɔ ‑bɩ, a nu 'kayu a 'mʋ 'yiyrinyibli a 'kayu ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kʋɛ 'ʋ ‑nyrɔwɔ a 'mʋ 'yie bʋ, ɛ tʋɛ nyibli Nyɩsʋa a ‑tɩ, 'a ‑nɛ ‑nyrɔwɔ, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli. Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ ‑mɔ ‑bɩ, ʋ kɔ Nyɩsʋa a tetetɔɔnyʋ, kɔ 'blʋ a nyibli gbagbɩ 'hʋɛn‑, ʋ ꞊mʋɛ ‑Yusu a 'lɩla a 'hru lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kɛɛ, ‑tɛ bʋ di 'a 'lɩla nu, ʋ 'yɩ꞊ɩ ‑yi, ‑ɛ nu꞊o, 'a ‑nɛ ‑nyrɔwɔ, nyibli ‑hʋɔhʋɩ ꞊glɛɛ 'lɩ꞊ɩ lɛ, ‑ɛ di꞊e nu, ʋ 'mʋ 'a tɔɔwin 'wɩn. ");
INSERT INTO ktj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","‑Nyrɔwɔ ꞊dʋ 'kwli, ‑Yusu tʋɛ la nyibli, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli, 'ɛ pɩ ꞊nʋ Nyɩsʋa a ꞊haantitie. 'Kɩ ɛ nɩ 'kɩ 'ʋ bʋ, ‑ɛ ‑bɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ, kɔ Nyɩsʋa a tetetɔɔnyʋ, kɔ ‑Juukʋɛ a 'blʋ a nyibli ‑bɩ 'hʋɛn‑, ʋ nʋ‑ nyre 'ʋ꞊ʋ 'hʋɩ, ");
INSERT INTO ktj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ʋ wɛn: «Nyiblo a 'dɩ ‑bɩ ‑nyi ‑mʋ 'klɩ, 'kɩ ‑bʋ bla ‑tɛblɩplonyibli ‑bʋ lɛ 'lɩ? Nyiblo a 'dɩ ‑bɩ ‑lee ‑mʋ ‑wɛ, 'kɩ ‑bʋ nu ‑tɛblɩ a pɛpɛ ‑bʋ, ‑ni 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «'Na 'mumu ‑bʋ, 'n di 'bɛti 'a mʋ dɛ. Ba lee 'mʋ, ");
INSERT INTO ktj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","nyiblo a 'dɩ ‑bɩ lee la Saan, 'kɩ bʋ pʋ la nyibli 'nie 'lu lɛ 'lɩ? ꞊Bɩ Nyɩsʋa lee la꞊a, ‑ʋ'ʋ‑ ‑tonyiblo lee la꞊a?» ");
INSERT INTO ktj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","‑Ɛ ‑bɩ ʋ ‑tʋa 'waa dɩɔnʋ a lɛ'bɛtilɛ, ʋ wɛn: «‑Bɩ' ‑a di 'kɩ pʋ 'lɩ? 'Bʋ mɔ, ꞊ba pʋ lɛ, Nyɩsʋa ‑lee la 'nɛ꞊ɛ, ɛ di ꞊hɩan ‑mɔ, ɛ 'mʋ ‑a mʋ 'bɛti ‑nɩ: ‑Tɩ ‑mʋ', Saan hlɛ la, dɛ‑ kɔ ‑tɩ, 'a 'yɩ la ‑tɩ a 'mʋ ꞊haan‑tɩ ‑pʋ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mɔ, 'bʋ mɔ, ꞊ba pʋ lɛ, ‑tonyibli ꞊nɩɔ, nyibli a pɛpɛ, ʋ di pʋ ‑a mʋ 'hɩ ‑mɔ lɛ, ʋ 'mʋ ‑a mʋ 'la, ‑kɔtɩ ʋ pʋ꞊ʋ ꞊haan‑tɩ, ‑ɛ mɔ, Saan mɔ la Nyɩsʋa a winwlɔn‑hanyɔ* ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ɛ nɔ‑ nu꞊o, 'ʋ ꞊tu ‑Yusu ꞊wɔn, ʋ wɛn: «‑A 'yɩ nyiblo a 'mʋ ‑yi, ‑ɛ lee la꞊a, 'kɩ bʋ pʋ la nyibli 'nie 'lu lɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","‑Ɛ ‑bɩ ‑Yusu wɛn: «'Na 'mumu, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ lee nɛ 'a mʋ, nyiblo ‑bʋ, ‑ɛ ‑nyi 'mʋ 'klɩ, 'kɩ ꞊bʋ nu ‑tɛblɩ a pɛpɛ ‑bʋ, 'n ni.» ");
INSERT INTO ktj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","(Nyibli ‑mʋ', ‑ʋ nɩ 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli, ‑Yusu 'tɩɛ yɩ 'lɩ ꞊nʋ ‑mɔ ‑hlee ‑nɩ,) ɛ wɛn: «Ɛ kɔ la 'dʋdɔnyɔ ꞊dʋ. Ɛ nɔ‑ kɔ la ‑ci. 'Kɩ 'lɩ ‑ci 'a mʋ kɩ, ɛ 'dɔɔ 'lɩ 'lili ꞊dʋ. 'A 'yɔ, ɛ tʋɩ, ʋ dɛɛ ꞊nɛ rɛsɛn. ‑Tɛ ɛ ‑wɛ 'a 'dʋdɔ ‑mɔ, ‑ɛ ‑bɩ, ɛ lee ‑kʋannunyibli ꞊dʋ, 'kɩ bʋ mu ‑ci a 'mʋ, 'a ‑kʋan nu, ‑ɛ di꞊e nu, 'a 'dʋdɔ‑tɛblɩ 'bʋ ‑tʋ, ʋ 'mʋ꞊ʋ 'a 'kɩbɩa ‑nyi, ‑kʋannunyibli a 'mʋ, 'waa 'mumu, ʋ 'mʋ 'waa ‑nɛ 'kɩbɩa kɔ. ‑Tɛ ‑cikɔnyɔ a 'mʋ, ɛ ‑wɛ ‑kʋan a 'mʋ, 'a yɩblɛ꞊tutulɛ ‑mɔ, ‑ɛ ‑bɩ ɛ mu 'dagba blɔblʋ', ɛ 'mʋ 'lɩ ti ‑hʋɔhʋɩ 'lɩ ‑hii ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","‑Tɛ 'dʋdɔ‑tɛblɩ a 'cɩcɛti nyre 'ʋ, ‑ɛ ‑bɩ ‑cikɔnyɔ a 'mʋ, ɛ lee nɛ 'a lɛlenyɔ ‑bɩ, 'kɩ bʋ mu 'lɩ ‑ci'yie꞊tunyʋ ‑mɔ, ʋ 'mʋ꞊ʋ 'cɩcɛ‑tɛblɩ a 'kɩbɩa, ‑ɛ blee ‑cikɔnyɔ yɩ ‑nyi, ɛ 'mʋ ꞊nɛ꞊ɛ yɩ ya. ‑Tɛ lɛlenyɔ a 'mʋ, ɛ nyre 'lɩ, ‑ɛ ‑bɩ ‑ci'yie꞊tunyʋ a 'mʋ, ʋ da 'lɩ꞊ɩ bʋ, 'ʋ bi꞊e ‑tɛɛ, 'kɩ ʋ 'yɩ꞊ɩ ꞊dedede ‑nyi, 'ʋ ‑mɩa ꞊nɛ kle. ");
INSERT INTO ktj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","‑Ɛ ‑bɩ ‑cikɔnyɔ lee nɛ 'a lɛlenyɔ ‑bɩ de, 'ʋ da 'lɩ꞊ɩ bʋ, 'ʋ bi꞊e, 'ʋ ‑ha꞊a 'yri lɛ, 'kɩ ʋ 'yɩ꞊ɩ ꞊dedede ‑nyi ‑wɛ, 'ʋ ‑mɩa ꞊nɛ kle, ");
INSERT INTO ktj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","‑cikɔnyɔ a 'mʋ, 'ɛ lee nɛ 'a ta a lɛlenyɔ, 'ʋ klɔ꞊ɔ, 'ʋ 'la꞊a ‑tɛblɩ 'yri lɛ, 'tɩ‑ 'ʋ ꞊hɩnhɩan 'lɩ꞊ɩ ‑patʋ'. ");
INSERT INTO ktj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","‑Ɛ ‑bɩ kɛ‑ ‑cikɔnyɔ a 'mʋ, ɛ pɩ 'kɩ 'a dɩɔnʋ yɩ, ɛ wɛn: ‑Bɩ' 'n di nu 'lɩ? 'Na nʋɛyu, nɔ‑ ꞊bʋ lee 'lɩ ꞊nʋ ‑mɔ. 'N pʋ꞊ʋ ꞊haan‑tɩ, ‑ɛ mɔ, ʋ di kɔ 'ʋ 'a 'ʋ꞊tuulɛ. ");
INSERT INTO ktj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","‑Tɛ ɛ waan 'lɩ, ‑ɛ ‑bɩ ʋ yɩ 'pʋplɛ' lɛ, ʋ wɛn: Nyiblo ‑bʋ, ‑ɛ di ‑ci ‑bʋ kɔ ‑nyrɔwɔ ꞊dʋ, ɛ nɔ‑ yɩ 'lɩ di. 'A ‑tɩ, ‑ba 'la꞊a, ‑a 'mʋ ‑ci ‑bʋ kɔ, ");
INSERT INTO ktj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","'ʋ klɔ꞊ɔ, 'ʋ 'hrɔɔ 'lɩ꞊ɩ ‑ci 'kwli, 'ʋ 'la꞊a.» ‑Ɛ ‑bɩ ‑Yusu wɛn 'nɩ: «'N yɩ a 'mʋ 'nɩ 'bɛti ‑nɩ, nyiblo a 'mʋ, ‑ɛ kɔ ‑ci a 'mʋ, 'bʋ 'wɩn ‑tɛblɩ a pɛpɛ a 'mʋ, ‑ɛ mu 'lu ‑mɔ, dɛ a 'dɩ ‑bɩ ɛ di ꞊nʋ ‑mɔ nu 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","'A ꞊gbɛtʋ, ɛ di 'nɩ di, ɛ 'mʋ ‑ci'yie꞊tunyʋ a 'mʋ 'la, 'tɩ‑, ɛ 'mʋ 'lɩ ‑ci a 'mʋ 'lɩ ‑ha, ɛ 'mʋ꞊ʋ nyibli ‑bɩ ‑nyi.» Nyibli a 'mʋ, ‑ʋ pɩ ‑Yusu nʋa yɩ bʋ, ‑ɛ ‑bɩ ʋ wɛn: «Yruyru, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ mu 'lu ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","‑Yusu bʋ ta 'ʋ ꞊nʋ ‑mɔ lɛ ‑tata, ‑ɛ ‑bɩ ɛ wɛn: «'A ‑tɩ, ‑tɩ ‑bʋ, ʋ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, dɛ ‑mʋ', ɛ ꞊hɛn 'nyrɛ, ba ‑hie꞊e 'lu ‑mɔ lɛ. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: 'Katuo ‑mʋ', 'kayupʋnyʋ 'yɛ nɩ ‑hʋa la bʋ nu la ‑kʋan 'yri, ʋ pʋ la 'kɩbɩa kɩ, ɛ nɔ‑ ‑hɛ 'kayu a 'mʋ a 'katuo gbagbʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ de, ɛ wɛn: «Nyiblo 'bʋ ꞊gbɛ 'katuo a 'mʋ yɩ, ɛ kɔ bʋ ‑yɩyrɛ lɛ, mɔ, nyiblo, 'katuo a 'mʋ, 'bʋ bi꞊e kɩ, ɛ di wʋwa꞊a lɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","'Tɩ‑ ‑Yusu 'mʋ ‑yrɛ mɔ mu, ‑ɛ ‑bɩ Nyɩsʋa a tetetɔɔnyʋ, kɔ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ 'hʋɛn‑, ‑ʋ nɩ 'ʋ, ʋ yru꞊o nɩ, ‑ɛ mɔ, ʋ nʋ‑ ‑Yusu pʋ 'ledʋ a 'mʋ yɩ. ‑Tɛ ʋ yru dɛ a 'mʋ, ‑ɛ ‑bɩ ti nɩ ‑do a 'ti 'yri, ʋ ‑tʋa 'hru a lɛ꞊mʋmʋɔ, ʋ 'mʋ꞊ʋ klɔ, ʋ 'mʋ꞊ʋ 'la. Kɛɛ, ‑tɛ ʋ yɩ nyibli a hʋannʋ pie, ɛ nɔ‑ nu꞊o, 'ʋ ‑ha꞊a mɛ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kɛɛ ‑ɛ ‑bɩ ʋ ‑tʋa ‑Yusu a ‑gbɛɛlɛ. Ɛ nɔ‑ nu꞊o, 'ʋ tɛ nyibli bʋ, 'kɩ 'ʋ꞊ʋ 'hʋɩ, ʋ 'mʋ nyibli ‑mʋ', ‑ʋ kɔ 'ʋ꞊tuulɛ a ŋmlɩ lɛ nu, ʋ 'mʋ꞊ʋ lɛ 'bɛti ‑nɩ, ‑ɛ di꞊e nu, 'kɩ 'lɩ 'a klɛ‑hɩhɩawin 'kwli, ʋ 'mʋ 'lɩ ‑naa ‑nɩ, ʋ 'mʋ꞊ʋ ‑tɩ ‑yɛɛ ‑nɩ, ʋ 'mʋ꞊ʋ klɔ a ‑tɩ, ʋ 'mʋ꞊ʋ Romakʋɛ a ‑gʋlʋnʋma ‑jɩ' pʋ, ɛ 'mʋ꞊ʋ ‑bati lɛ ‑pʋʋ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","‑Tɛ ʋ nyre 'kɩ 'ʋ꞊ʋ 'hʋɩ, ‑ɛ ‑bɩ ʋ wɛn: «Tɔɔnyɔ o, ‑a yi꞊e nɩ, ‑ɛ mɔ, ‑hlɛ ‑tɩ a ‑tɛɛ, 'tɩ‑ ꞊nɩ tʋɛ ꞊nɛ nyibli. 'Bʋ mɔ, ꞊nɩ yɩ꞊ɩ nɩ hlɛ, ‑tonyibli a 'lulɛ‑hihie a hʋannʋ 'nɩ ‑nu꞊o lɩ ‑mʋ, 'ye ꞊bɩɩ ɛ mɔ nyiblo gbagbʋ. ‑Na ‑tɩ a ‑tɛɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ ‑tʋɛ ‑nɩ, 'kɩ 'ʋ dɛ ‑mʋ', Nyɩsʋa ‑hʋɛ a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","'A ‑tɩ o, lee nɛ ‑a mʋ, ꞊bɩ Nyɩsʋa a tete wɛn 'nɩ, ‑ba ‑ha 'blʋwli, ‑ba ‑nyi꞊e Romakʋɛ a 'kɩɩn gbagbʋ, ‑ʋ'ʋ‑, ꞊bɩ ‑a 'yɩ yɩ ‑blɛɛ nɩ, ‑ba ‑nyi ꞊nɛ꞊ɛ?» ");
INSERT INTO ktj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kɛɛ, ‑Yusu yru 'waa ꞊yrɛ a 'mʋ nɩ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Ba tɔɔ 'mʋ 'wliyɔkɔ a 'yɛ nɩ ‑do yɩ.» ‑Tɛ ʋ ‑nyi ꞊nɛ꞊ɛ, ‑ɛ ‑bɩ ɛ wɛn: «Nyiblo a 'dɩ ‑bɩ, ‑ɛ kɔ yigbakla ‑nɩ 'ʋ꞊ʋ kɩ 'lɩ? Nyiblo a 'dɩ ‑bɩ, ‑ɛ kɔ 'nyrɛ ʋ 'crɩɩ 'ʋ ‑wɛ 'lɩ?» ‑Ɛ ‑bɩ ʋ wɛn: «Romakʋɛ a 'kɩɩn gbagbʋ ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'kɩ ꞊nʋ yɩ, ɛ wɛn: «'A ‑tɩ o, dɛ ‑bʋ, ‑ɛ blɛɛ 'kɩɩn gbagbʋ yɩ, ba ‑nyi ꞊nɛ꞊ɛ, ɛ kɔ, dɛ ‑bʋ, ‑ɛ blɛɛ Nyɩsʋa yɩ, ba ‑nyi ꞊nɛ꞊ɛ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ɛ ꞊hɛn 'nyrɛ, ‑Yusu 'yɩ ꞊dedede klɛ ‑hɩhɩa ‑nɩ, 'kɩ 'ʋ nyibli ye', ‑ɛ kɔ 'kwli 'a yraanyibli di 'lɩ ‑naa ‑nɩ, ʋ 'mʋ꞊ʋ ‑tɩ ‑yɛɛ ‑nɩ. Kɛɛ, ‑tɩ a 'mʋ, ‑Yusu ‑hɩhɩa ꞊nʋ klɛ, ɛ kɛɛ 'waa ꞊wlɩ lɛ. 'A ‑tɩ, ʋ 'yɩ 'kɩ ‑tɩ ꞊dʋ ‑hla de. ");
INSERT INTO ktj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","'Kɩ 'lɩ Jrusrɛdɩɔ 'kwli, ɛ kɔ la ꞊tumu ꞊dʋ. 'A 'nyrɛ mɔ Sadusɩ꞊tumu*. Ʋ nʋ‑ hlɛ꞊ɛ, ‑ɛ mɔ, 'bʋ mɔ, nyiblo 'bʋ 'kʋ, ɛ 'yɩ 'kɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ, bʋ 'hrɩ 'klɔ, 'kɩ 'lɩ Nyɩsʋa yɩ. Ʋ nʋ‑ kɔ nyibli ‑mu 'ʋ ‑Yusu 'hʋɩ, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ lɛ 'bɛti ‑nɩ. ‑Tɛ ʋ nyre 'kɩ 'ʋ꞊ʋ 'hʋɩ, ‑ɛ ‑bɩ kɛ‑ ʋ pɩ꞊ɩ yɩ, ʋ wɛn: ");
INSERT INTO ktj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Tɔɔnyɔ o, Nyɩsʋa a winwlɔn‑hanyɔ* Moise 'crɩ la tete ‑bɩ, 'ɛ hie ‑a mɔ꞊ɔ lɛ. Tete a 'mʋ, ɛ nɔ‑ ‑bʋ: Nyɩbɛyugbe 'bʋ kɔ nʋgba, 'tɩ‑ 'bʋ 'yɩ 'ʋ 'yonʋ bʋ ‑hie, 'bʋ 'kʋ, nyɩbɛyugbe a 'mʋ, ‑ɛ 'kʋ, 'bʋ kɔ 'dɩayɩ nyɩbɛhɩan, ɛ nɔ‑ blɛɛ yɩ, ‑bʋ kɔ nʋgba a 'mʋ, ɛ kɔ꞊ɔ 'hʋɛn‑, ʋ 'mʋ 'yonʋ kɔ, 'kɩ 'ʋ 'a 'dɩayɩ ‑mʋ', ‑ɛ 'kʋ a ‑ta'. Kɛ‑ Moise a tete pɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ʋ wɛn 'nɩ de: «Ɛ kɔ la 'dɩayɩ nyɩbɛpʋ nɩ ꞊hlon'hʋɛn, 'waa yɩ‑hɛnyiblo, nɔ‑ kɔ la nʋgba, 'ɛ 'yɩ 'yu bʋ ‑hie, 'ɛ 'kʋ, ");
INSERT INTO ktj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","'hʋɛn a nyiblo 'ɛ kɔ꞊ɔ, 'a 'mumu, 'ɛ 'yɩ 'yu bʋ ‑hie, 'ɛ 'kʋ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Dɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ nu ta a nyiblo. Dɛ a 'mʋ, ɛ nɔ‑ mu 'lu ‑mɔ ‑mumu, ꞊hlon'hʋɛn a nyiblo 'ɛ kɔ꞊ɔ ‑wɛ, 'kɩ ɛ 'yɩ 'yu bʋ ‑hie, 'ɛ 'kʋ. ");
INSERT INTO ktj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","‑Tɛ 'waa pɛpɛ, ʋ 'kʋ 'kɩ, ‑ɛ ‑bɩ nʋgba a 'mʋ, ɛ 'kʋ nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nɔ‑ mɔ ‑tɩ, ‑a di ‑mʋ 'bɛti mɔ, ꞊mʋ ‑a mʋ klɛ ‑hɩhɩa ‑nɩ. ‑Nyrɔwɔ ‑kɔ 'kwli nyibli di 'lɩ 'kʋkʋnyibli 'nyɩ ‑hɔn, ʋ di 'klɔ 'hrɩ, 'kɩ 'lɩ Nyɩsʋa yɩ, nyiblo a 'dɩ ‑bɩ ‑di 'kɩ nʋgba a 'mʋ kɔ 'lɩ, ‑ɛ nu꞊o, ‑tɛ ʋ nɩ la 'nɛ‑ ‑tʋtʋ kɩ, nyibli nɩ ꞊hlon'hʋɛn a pɛpɛ a 'mʋ, ʋ kɔ la꞊a nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «Nʋgbɩ kɔ nyɩbɛpʋ 'hʋɛn‑, ‑ʋ nɩ 'klɔ, ʋ nʋ‑ yɩ ‑kʋkɔ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kɛɛ, 'bʋ ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ, 'bʋ 'hrɩ 'klɔ, 'kɩ 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli, nyibli a 'mʋ, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ kʋkɔ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ 'kʋ 'kɩ de. Kɛɛ, ‑tɛ Nyɩsʋa a lɛlenyʋ nɩ 'mʋ, kɛ‑ ʋ di 'mʋ nɩ ‑wɛ. Ʋ mɔ Nyɩsʋa a 'yonʋ ꞊nɩɔ, ‑ɛ nu꞊o, 'kɩ ʋ ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ, 'ʋ 'hrɩ 'klɔ. ");
INSERT INTO ktj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Dɛ ‑bʋ, ‑ɛ mɔ nyibli bʋ di 'lɩ 'kʋkʋnyibli 'nyɩ ‑hɔn, bʋ di 'klɔ 'hrɩ, Nyɩsʋa a winwlɔn‑hanyɔ Moise, nɔ‑ 'crɩ la 'a ‑tɩ. Dɛ ‑mʋ', Nyɩsʋa lee ꞊nɛ, ɛ nɔ‑ ɛ 'crɩ la. ‑Tɛ Nyɩsʋa a 'mʋ, ɛ nɩ la 'lɩ ‑gbakuo, ‑ɛ yɩ la wlɩn 'kwli, 'kɩ ɛ hlee la 'lɩ Moise ‑mɔ. 'Kɩ 'lɩ 'crɩɛnkʋtɩɔ a 'mʋ 'kwli, ‑tɛ Moise yɩ la Kʋkɔnyɔ nɩ dɛ, ‑ɛ ‑bɩ kɛ‑ ɛ pɩ la: 'Mɔ mɔ Nyɩsʋa ‑bʋ, Abrahamʋ dɛ, ɛ kɔ Yisakɩ, kɔ Sakɔbʋ 'hʋɛn‑. Kɛ‑ Nyɩsʋa pʋ la. ");
INSERT INTO ktj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ɛ 'wɩ yɩ, ti ‑mʋ' ‑kɔ 'yri Nyɩsʋa yɩ la 'lɩ Moise ‑mɔ ‑hlee ‑nɩ, Abrahamʋ kɔ Yisakɩ kɔ Sakɔbʋ 'hʋɛn‑, ʋ 'kʋ la nɩ see la. Kɛɛ, ‑a yi꞊e nɩ, ‑ɛ mɔ, ɛ 'yɩ 'kʋkʋnyibli 'pa‑, ʋ 'nɩ ‑da꞊a lɩ Nyɩsʋa, kɛɛ, 'klɔnɩnyibli, ʋ nʋ‑ dɛ꞊ɛ. Nyibli ‑mʋ', ‑ʋ nɩ 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli, ʋ 'yɩ 'kʋ, kɛɛ, ʋ nɩ 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","‑Ɛ ‑bɩ tetetɔɔnyʋ ‑bɩ ‑mʋ', ‑ʋ nɩ 'ʋ, ʋ wɛn: «Tɔɔnyɔ, ‑tɩ ‑bʋ, ‑hlɛ, 'a ‑tɛɛ, nɔ‑ ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bʋ pʋ 'kɩ lɛ, nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, ʋ yɩ pie hʋannʋ, 'kɩ bʋ 'bɛti꞊e lɛ de. ");
INSERT INTO ktj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ, ɛ wɛn: «Ɛ kɔ nyibli, 'ʋ pɩ lɛ: Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya, Wanyɔ a 'mʋ, ɛ nɔ‑ mɔ bodɩɔ Dafidɩ a 'yonʋ a 'Yu. 'A mʋ 'n yɩ 'kɩ 'bɛti ‑nɩ: Dɛ‑ kɔ ‑tɩ 'ʋ hlɛ꞊ɛ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dafidɩ a 'mumu, ɛ hla꞊a nɩ, 'kɩ 'lɩ Nyɩsʋa a ‑wlablecrɩɛn* 'kwli, ‑ɛ mɔ: Kʋkɔnyɔ Nyɩsʋa lee 'na Kʋkɔnyɔ nɩ, ‑ɛ mɔ: Nɩ mɔ 'na diidɛkɩbɩa kɩ bʋ, ‑kɔ 'mʋ 'hʋɛn‑, ");
INSERT INTO ktj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","‑a 'mʋ nyibli win kɩ ‑kɔɔ ‑nɩ, ɛ 'mʋ꞊ʋ gba ‑gbagba, 'mʋ꞊ʋ nu, ꞊mʋ ‑na yraanyibli bʋɩ 'lu blɛ ꞊tu.» ");
INSERT INTO ktj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","‑Ɛ ‑bɩ ‑Yusu wɛn 'nɩ de: «‑Tɛ Dafidɩ a 'mʋ, ɛ dɛɛ Wanyɔ a 'mʋ 'a Kʋkɔnyɔ, ‑bɩ' Wanyɔ a 'mʋ, ɛ ‑wɛ 'lɩ bʋ nu 'kɩ Dafidɩ a 'Yu a pʋpa 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nyibli ‑hʋɔhʋɩ ‑mʋ', ‑ʋ nɩ ‑tuo kɩ, ‑tɩ ‑mʋ', ‑Yusu ‑hla, ʋ pʋ꞊ʋ nʋa yɩ bʋ, ‑Yusu 'ɛ yɩ 'lɩ 'a ‑nagbopʋ* ‑mɔ ‑hlee ‑nɩ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Ba ꞊tu 'aan dɩɔnʋ 'yie, 'kɩ 'ʋ tetetɔɔnyʋ ‑mɔ, ʋ 'nɩ ꞊ha 'a mʋ ‑kaa ‑nɩ. Ʋ nʋɛ 'kɩ nyibli bʋ daa ꞊nʋ nyibli gbagbɩ. 'Bʋ yɩ lɛ nɩ nɛ, ʋ pɩ nyibli gbagbɩ a wlawlɩ, ‑ɛ di꞊e nu, nyibli 'mʋ ꞊nʋ 'ye. 'Bʋ yɩ 'ʋ ‑tɩtɛ ꞊dʋ nɩ mi, ‑tɛ nyibli ‑hʋʋ 'ʋ, ‑ɛ ‑bɩ ʋ ‑hʋɛ꞊ɛ nɩ, nyibli bʋ pʋ ꞊nʋ 'wio blɛ, 'kɩ 'ʋ 'waa 'ʋ꞊tuulɛ a ‑ta', 'ʋ nʋɛ ꞊nɛ nɩ ‑wɛ, 'bʋ mu 'lɩ Nyɩsʋa a 'kayu bʋ, 'kɩ bʋ nɩ 'lɩ ye' bʋ, ‑ɛ di꞊e nu, nyibli a pɛpɛ 'mʋ ꞊nʋ 'ye. Dɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ ʋ ni, 'bʋ da ꞊nʋ dididɛ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ʋ nɩ ‑do a 'mʋ, ʋ nʋ‑ ‑hɛ ‑tʋgbanʋgbɩ kʋkɔ‑tɛblɩ a pɛpɛ ꞊jrɛ. 'Tɩ‑, tetetɔɔnyʋ a 'mʋ, 'bʋ yɩ Nyɩsʋa nɩ dɛ, 'waa Nyɩsʋa a dɩda hlɔ kɩ bʋ, ‑ɛ di꞊e nu, nyibli 'mʋ lɛ pʋ, ʋ mɔ ꞊haannyibli ꞊nɩɔ. 'N yɩ 'a 'mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, ‑bati ‑mʋ', Nyɩsʋa di ꞊nʋ lɛ ‑pʋʋ ‑nɩ, ɛ di nɩ 'klɩ kɩ, ɛ 'mʋ 'ʋ nyibli ‑bɩ a ‑bati 'ʋ ‑hi.» ");
INSERT INTO ktj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","'Kɩ ‑Yusu kɔ ‑nagbopʋ* 'hʋɛn‑, ʋ nɩ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ, 'kɩ 'ʋ dukwli ‑mʋ', ‑ɛ kɔ 'kwli nyibli pɩ 'lɩ 'wli lɛ 'hʋɩ, 'kɩ 'ʋ Nyɩsʋa a ‑kʋan a ‑ta'. ‑Yusu yɩ꞊ɩ 'nɩ 'ye, ‑tɛ dɛkɔnyibli ni 'lɩ 'wli a lɛpʋpʋʋ. ");
INSERT INTO ktj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kɛɛ, bʋ nɩ 'kɩ 'ʋ bʋ, ‑ɛ ‑bɩ ɛ 'ye ‑tʋgbanʋgba ꞊dʋ, ꞊hɩʋɛn ni. ‑Tɛ nʋgba a 'mʋ, ɛ nyre 'ʋ, ‑ɛ ‑bɩ 'wliyɔ gbi nɩ 'hʋɛn, ‑ɛ 'yɩ 'lɩ ꞊dedede a ‑tʋtɔ ‑wɛ, ɛ nɔ‑ ɛ pʋ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","‑Tɛ ‑Yusu 'ye꞊e, ‑ɛ ‑bɩ ɛ wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, 'kɩ 'lɩ Nyɩsʋa 'yi, ꞊hɩʋɛnnʋgba ‑bʋ, ɛ pʋ 'lɩ 'wliyɛ, 'ɛ ‑hi 'ʋ nyibli a pɛpɛ ‑bʋ 'ʋ, ");
INSERT INTO ktj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","‑ɛ nu꞊o, nyibli ‑bɩ ‑mʋ', 'wliyɛ ‑bʋ, ‑ɛ 'yɩ ‑kʋan ‑kɔ, 'kɩ 'ʋ ꞊nʋ ‑mɔ, ɛ nɔ‑ ʋ pʋ 'lɩ lɛ. Nʋgba ‑bʋ, ɛ nɔ‑ ‑mɔ ‑bɩ, ꞊han‑tɩ ꞊hɩʋɛn 'ɛ ni꞊e, kɛɛ, kɛ‑ ɛ nɩ 'mʋ, 'wliyɛ a pɛpɛ ‑mʋ', ɛ di wɛn nu, ɛ 'mʋ wɛn 'a dɩɔnʋ yɩ ‑wɔn, ɛ nɔ‑ ɛ pʋ 'lɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nyibli ‑bɩ, nʋ‑ hlɛ la Nyɩsʋa a 'kagbaʋ a ‑tɩ. Kɛ‑ ʋ pɩ la, ‑ɛ mɔ: «Ɛ nɔ yɩ dɩakɩ. Ta lɛ ‑bʋ 'ye, yɩnɔhɩ, ʋ ‑nu, 'ʋ pʋ꞊ʋ, ɛ kɔ yɩnɔ‑tɛblɩ a gblegble, ʋ ‑ha, ʋ ꞊tu 'lɩ 'kayu a 'mʋ bʋ, Nyɩsʋa a ‑tɩ a 'yi'bʋalɛ a ‑tɩ.» ‑Ɛ ‑bɩ ‑Yusu wɛn: ");
INSERT INTO ktj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«'Kayu ‑bʋ, a yɩ 'ye, ‑nyrɔwɔ di 'ʋ 'nɩ nyre, ‑ɛ kɔ 'kwli ʋ di 'ʋ꞊ʋ 'ʋ 'wlaa ‑nɩ pɛpɛ. 'A 'hɩɔ ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nɩ 'ʋ 'a 'bɩ 'hɩɔ 'lu bʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","‑Ɛ ‑bɩ ʋ 'bɛti ‑Yusu nɩ, ʋ wɛn: «Tɔɔnyɔ, lee nɛ ‑a mʋ, ti a 'dɩ ‑bɩ ‑kɔ 'yri ʋ di 'ʋ Nyɩsʋa a 'kagbaʋ a 'mʋ 'wlaa ‑nɩ, ɛ kɔ, dɛ a 'dɩ ‑bɩ, ‑ɛ di 'lu ‑mɔ ‑mu, ‑a di 'ye, 'tɩ‑ ‑a 'mʋ꞊ʋ yi, ‑ɛ mɔ, ‑tɛblɩ a pɛpɛ ‑mʋ', ‑kɔ ‑tɩ ‑hla wɛn, ɛ mi 'lu ‑mɔ mu mɔ?» ");
INSERT INTO ktj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","‑Ɛ ‑bɩ ɛ ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «Ba ꞊tu 'aan dɩɔnʋ 'yie, nyiblo ꞊dʋ 'nɩ ꞊ha 'a mʋ ‑kaa ‑nɩ, ‑ɛ nu꞊o, nyibli ‑hʋɔhʋɩ di 'nɩ di, ʋ 'mʋ lɛ pʋ, ʋ nʋ‑ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya, ʋ 'mʋ lɛ pʋ ‑wɛ, ti ‑mʋ', ‑ɛ kɔ 'yri Wanyɔ a 'mʋ, ɛ di ya, ɛ 'mʋɛ yrɛ. Kɛɛ, a 'nɩ 'kʋɛɛ 'lɩ ꞊nʋ ꞊wien. ");
INSERT INTO ktj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","'Ya 'ʋ 'lu de, a di 'nɩ 'wɩn, ‑ɛ mɔ, ʋ ‑wɛn tʋ, 'kɩ 'lɩ 'blʋgbɩ ‑bɩ kɩ, ɛ kɔ, a 'mʋ 'wɩn, ‑ɛ mɔ, ɛ kɔ nyibli ‑bɩ, 'ʋ yɩ 'blʋgbɩ ‑bɩ ꞊gbugblo ‑nɩ. 'Bʋ mɔ, 'ba yɩ nɩ 'wɩn, a 'nɩ 'pie 'lɩ hʋannʋ, ‑ɛ nu꞊o, ‑tɛblɩ a pɛpɛ a 'mʋ, ɛ kɔ bʋ mu 'lu ‑mɔ. Kɛɛ, 'bʋ yɩ 'lu ‑mɔ nɩ mi, ɛ 'yɩ 'nyrɛ ꞊hɛn, ‑ɛ mɔ, ti nɩ ‑do a 'mʋ 'yri, 'kɩ 'klɔ a 'ʋ‑hɔnti di 'ʋ ‑nyree ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kɛ‑ ɛ pɩ de: «'Blʋgbɩ di yɩ 'nɩ ‑wʋnwɔn ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","'Kɩ 'lɩ 'blʋgbɩ ‑hʋɔhʋɩ 'kwli, ‑tʋtʋ di 'nɩ 'hɩhlɛ ‑nɩ dɩakɩ, 'kanʋ 'mʋ ꞊tɩ, ꞊tɩtakʋɛ 'mʋ nyibli klɔ. Hʋannʋ‑tɛblɩ 'mʋ 'lɩ yakɔ 'kwli lɛ 'hrɩɩ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kɛɛ, 'tɩ‑ ‑tɛblɩ a pɛpɛ a 'mʋ, ɛ 'mʋ 'ʋ nyre, ʋ di 'a mʋ 'nɩ klɔ, ‑tɛ a mɔ 'na nyibli a ‑tɩ, ʋ 'mʋ 'a mʋ ꞊hɩʋɛn ꞊tu, ɛ kɔ, ʋ 'mʋ 'lɩ 'a mʋ Nyɩsʋa a 'kayo a nyibli gbagbɩ ‑mɔ gba, ‑ɛ di꞊e nu, ʋ 'mʋ 'a mʋ ‑bati lɛ ‑pʋʋ ‑nɩ, ɛ kɔ, ʋ 'mʋ 'a mʋ ‑jɩ' lɛ pʋ, kɔ, ʋ 'mʋ 'a mʋ ‑tɩ ‑yɛɛ ‑nɩ, 'kɩ 'ʋ 'blʋgbɩ a bodɩɔpʋ kɔ ‑gʋlʋnʋmapʋ ye'. ");
INSERT INTO ktj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","'Bʋ mɔ, ‑tɛblɩ a 'mʋ, 'bʋ nyre 'ʋ, 'kɩ 'ʋ 'a mʋ ‑mɔ, a di kɔ 'hru, 'kɩ ba hla꞊a, ‑ɛ mɔ, a kuo 'mʋ ꞊wlʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","'A ‑tɩ, 'bʋ pa, 'bʋ yɛɛ nɛ 'a mʋ ‑tɩ, ‑tɩ ‑bʋ, a di hla, 'a ‑tɩ 'nɩ 'yaa 'lɩ 'a mʋ 'kla ‑wliye, 'tɩ‑ ‑tɛblɩ a 'mʋ, ɛ 'mʋ 'ʋ nyre. ");
INSERT INTO ktj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","'Na ꞊gbɛtʋ, 'mɔ ‑di 'a mʋ ꞊tɔ ‑nyi, a 'mʋ win pʋ. Nyibli ‑mʋ', ‑ʋ yɩ 'a mʋ ‑tɩ ‑yɛɛ ‑nɩ, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nyra 'a mʋ yɩ bʋ, ɛ kɔ, bʋ ꞊tu 'a mʋ ꞊wɔn ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","'Aan 'baɩnʋ, kɔ 'aan 'diinʋ, kɔ 'aan 'dɩayɩnʋ, kɔ 'aan ꞊tugba a nyibli, kɔ 'aan nɩnatumupʋ, ʋ di pʋ 'a mʋ 'blʋgba a naanyʋ ‑jɩ', ʋ 'mʋ ‑ʋ ‑bɩ lɛ 'lɩla ‑nɩ, 'kɩ 'lɩ 'a mʋ 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nyibli a pɛpɛ kɔ bʋ yraa nɛ 'a mʋ, ‑tɛ a mɔ 'na nyibli a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kɛɛ, ꞊dedede 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nyre 'ʋ, 'kɩ 'ʋ 'a mʋ ‑mɔ, mɔ, 'aan 'lunyapli nɩ ‑do 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ 'wan. ");
INSERT INTO ktj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","A 'nɩ 'saa 'lɩ. Ɛ nɔ‑ di꞊e nu, Nyɩsʋa 'mʋ 'a mʋ 'klɔ yrayrʋ ‑nyi.» ");
INSERT INTO ktj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Kɛ‑ ‑Yusu pɩ 'a ‑nagbopʋ* yɩ de, ɛ mɔ: «'Bʋ mɔ, 'ba 'ye Jrusrɛdɩɔ, hɩapʋdakɔ ‑bɩ a 'sɛyo 'bʋ ꞊glaa 'lɩ꞊ɩ lɛ, ‑ɛ ‑bɩ ba yi꞊e, ‑ɛ mɔ, Jrusrɛ a mʋ, 'a 'wʋwlati yɩ 'ʋ 'nɩ nyre. ");
INSERT INTO ktj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","'Ba 'ye ‑tɛblɩ a 'mʋ, ‑ɛ ‑bɩ nyibli ‑mʋ', ‑ʋ nɩ 'lɩ Sudeblʋgba 'kwli, bʋ 'gba ci lɛ, bʋ mu 'lɩ dʋgbɩ 'lu, kɔ, nyibli ‑mʋ', ‑ʋ nɩ 'lɩ Jrusrɛdɩɔ 'kwli, bʋ hlɔ ‑mɔ, kɔ, nyibli ‑mʋ', ‑ʋ nɩ 'lɩ ‑titi, ʋ 'nɩ 'die 'lɩ 'dɩɔ, ʋ 'nɩ ꞊ha ꞊nʋ lɛ 'lɩla ‑nɩ, ");
INSERT INTO ktj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","‑ɛ nu꞊o, ‑nyrɔwɔ a 'mʋ 'kwli, Nyɩsʋa di ꞊tu 'a dakɔ ꞊hɩʋɛn. Kɛ‑ ‑tɩ a pɛpɛ ‑mʋ', Nyɩsʋa a winwlɔn‑hanyɔ* hla la, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ɛ di 'lu a ‑mɔmumuo nu. ");
INSERT INTO ktj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ti a 'mʋ 'yri, nʋgbɩ ‑mʋ', ‑ʋ di 'kwli lɛ nɩ, kɔ 'waa dɛ ‑mʋ', ‑ʋ di 'yonʋ 'nya, ʋ di 'ye ꞊hɩʋɛn dɩakɩ, kɔ, dakɔ 'mʋ ꞊hɩʋɛn 'ye dɩakɩ, Nyɩsʋa 'mʋ 'a dakɔ yrʋ lɛ ‑pʋʋ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ʋ di nu 'plɩɛn, ʋ 'mʋ ‑ʋ ‑bɩ lɛ 'lɩla ‑nɩ, ʋ 'mʋ 'lɩ ‑ʋ ‑bɩ dakɔ ‑mʋ', ‑ʋ 'yɩ Nyɩsʋa ‑yi a 'bli gba, ʋ 'mʋ ꞊kodɛ nu mɔ mu. Dakɔ ‑mʋ', ‑ʋ 'yɩ Nyɩsʋa ‑yi, nʋ‑ di Jrusrɛdɩɔ 'wla, ɛ 'mʋ꞊ʋ gba ‑gbagba, 'waa ‑nɛ ti 'mʋ 'lɩ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Kɛ‑ ‑Yusu pɩ de, ɛ wɛn: «꞊Hɩʋɛn'yeti a 'mʋ, 'bʋ nyre 'ʋ, hʋannʋ‑tɛblɩ di mu 'lu ‑mɔ, 'kɩ 'lɩ 'yrʋ 'yi, kɔ 'kɩ 'lɩ ꞊hɔnpʋ kɔ nyahroyɔ 'hʋɛn‑ 'yi. 'Kɩ 'nɛ‑ ‑tʋtʋ ‑bʋ kɩ, dakɔ a pɛpɛ di nɩ 'lɩ hʋannʋ 'kwli, 'kɩ 'ʋ 'yru kɔ 'a 'dʋɩ 'hʋɛn‑ a ‑cici a ‑ta'. Dɛ bʋ di 'lu ‑mɔ lɛ ‑hie, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ yi꞊e. ");
INSERT INTO ktj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","‑Tɛblɩ ‑di 'nɛ‑ ‑tʋtʋ kɩ 'lu ‑mɔ ‑muu ‑nɩ, nyibli 'bʋ yɩ 'a ‑tɩ 'lu ‑mɔ lɛ nɩ ‑hie, 'a hʋannʋ, nɔ‑ di ꞊nʋ lɛ 'lɩla ‑nɩ. ‑Tɛblɩ a pɛpɛ, ‑ɛ nɩ 'lɩ yakɔ 'kwli, ɛ di ‑hɔn ‑ta' lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ti nɩ ‑do a 'mʋ 'yri, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'kɩ ʋ di 'ʋ 'mʋ 'yee ‑nɩ. 'N kɔ ꞊bʋ di, 'kɩ 'lɩ 'na 'klɩkɩnɩnɩɩ a pɛpɛ 'kwli, kɔ 'kɩ 'lɩ 'na ‑tɩ a 'yi'bʋbʋa 'kwli. 'Bʋ mɔ, 'nɩ yɩ nɩ di, 'kɩ 'n di 'lɩ 'nuŋmɩ 'nyɩ nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ti ‑mʋ' ‑kɔ 'yri ‑tɛblɩ a 'mʋ, ɛ di ‑wlu ꞊tu, ba 'hrɩ 'lɩ lɛ, ɛ kɔ, ba ‑ha 'lɩ 'lu ‑wlu, ‑ɛ nu꞊o, ‑nyrɔwɔ, Nyɩsʋa di 'ʋ 'a mʋ ꞊gblɛɛ ‑nɩ, ɛ 'mʋɛ yrɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","‑Yusu bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ɛ pʋ ꞊nʋ 'ledʋ ‑bɩ yɩ, ɛ wɛn: «Ba 'ye tugbɛ ‑mʋ', ʋ dɛɛ figietu, kɔ ti ‑bɩ. ");
INSERT INTO ktj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","'Bʋ mɔ, 'ba yɩ ꞊nʋ nɩ 'ye, 'bʋ yɩ hawi yrayrɩ nɩ pɩ, ‑ɛ ‑bɩ a yi꞊e nɩ, ‑ɛ mɔ, ‑ci‑nyrɛ 'mʋɛ yrɛ. ");
INSERT INTO ktj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","‑Tɛblɩ a pɛpɛ ‑bʋ, ‑kɔtɩ 'n hla wɛn, 'bʋ yɩ 'lu ‑mɔ nɩ mi, ‑ɛ ‑bɩ ba kɔ 'a yiyie, ‑ɛ mɔ, ti ‑mʋ' ‑kɔ 'yri Nyɩsʋa di 'ʋ nyibli win kɩ ‑kɔɔ ‑nɩ pɛpɛ, ɛ 'mʋɛ yrɛ. ");
INSERT INTO ktj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, nyibli ‑bʋ, ‑ʋ nɩ 'klɔ, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ 'kʋ, ‑tɛblɩ a pɛpɛ a 'mʋ, ɛ 'mʋ 'ʋ nyre. ");
INSERT INTO ktj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yakɔ kɔ ‑tʋtʋ 'hʋɛn‑, ʋ di bʋ 'nɩ ‑wɛ, kɛɛ, 'na win 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑wɛ bʋ, 'klɔ ‑mɔ 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ de, ɛ wɛn: «Ba ꞊tu 'aan dɩɔnʋ 'yie, 'aan 'lulɛ‑hihie 'nɩ 'nɩɩ 'lɩ lɛ'mimle nɩ ‑do 'kwli, kɔ, a 'nɩ 'naa 'lɩ nɔ dɩakɩ, kɔ, a 'nɩ 'hritie 'lɩ ‑nɩ, 'kɩ 'ʋ ‑tɛblɩ ‑mʋ', nyiblo blɛɛ yɩ bʋ kɔ a ‑ta', ‑kɔtɩ ‑tɛblɩ a pɛpɛ a 'mʋ, ʋ ni꞊e nɩ, 'aan 'lulɛ‑hihie 'ɛ yɩ 'yi lɛ ‑bibi ‑nɩ. 'Ba yɩ ‑tɛblɩ a 'mʋ nɩ ni, ‑ɛ ‑bɩ ‑nyrɔwɔ, 'n di ya, ɛ di 'a mʋ bʋ 'nɩ ꞊hu, ");
INSERT INTO ktj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","꞊wɩ yɩ, ‑tɛ cro ni, 'ɛ kwlɛ mʋma. ‑Nyrɔwɔ a 'mʋ, ɛ kɔ bʋ yɛɛ 'ʋ nyibli a pɛpɛ bʋ, ‑ʋ nɩ 'nɛ‑ ‑tʋtʋ kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ba nɩ 'ʋ ‑pleelɛ', a 'nɩ 'ŋmee 'lɩ, ba 'cibi 'ʋ Nyɩsʋa a dɩda, ‑ɛ di꞊e nu, ‑tɛblɩ a pɛpɛ a 'mʋ, ‑ɛ di di, a 'mʋ 'lɩ꞊ɩ 'kwli ꞊tɩɔ 'bɛɛ ‑nɩ, 'tɩ‑ 'bʋ mɔ, 'mɔ ‑bʋ, ‑ɛ mɔ, ‑tonyibli a pɛpɛ a Nyiblo, 'nɩ yɩ 'lɩ nɩ di, a 'nɩ ꞊ha hʋannʋ pie.» Kɛ‑ ‑Yusu pɩ nyibli yɩ. ");
INSERT INTO ktj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","‑Nyrɛ', 'kɩ ‑Yusu tʋɛ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ. 'Tɔ 'bʋ ‑wɔn, ‑ɛ ‑bɩ ɛ ꞊tɩ 'dɩɔ, 'ɛ mi 'lɩ olifieti a dʋgba 'lu pɛɛ mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","‑Nyrɛ 'bʋ ‑nyɛ, ‑ɛ ‑bɩ nyibli a pɛpɛ yɩ ‑wɛ ti kɩ, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ bʋ, ʋ 'mʋ 'a win 'wɩn. ");
INSERT INTO ktj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Juukʋɛ a lɛ'mimle gbagbʋ mi 'ʋ nyre mɔ. Lɛ'mimle a 'mʋ, 'a 'nyrɛ mɔ Pakɩ. Pakɩ a 'mʋ a ti 'yri, 'flɔɔdʋ ‑mʋ', ‑ɛ kɔ ‑mɔ ʋ 'yɛ nɩ pʋ 'lɩ 'yaadɛ, ɛ nɔ‑ ʋ yɩ di. ‑Tɛ ‑nyrɔwɔdʋ a 'mʋ, ɛ yɩ yrɛ nɩ 'mʋɛ, ");
INSERT INTO ktj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","‑ɛ ‑bɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ kɔ tetetɔɔnyʋ 'hʋɛn‑, ʋ ꞊mʋɛ ‑Yusu a 'lɩla lɛ. Kɛɛ, ʋ yɩ pie nyibli a hʋannʋ. Ɛ nɔ‑ nu꞊o, 'ʋ ꞊mʋɛ ꞊tɔ lɛ, ‑tɛ ‑mʋ', ʋ di 'a 'lɩla nu. ");
INSERT INTO ktj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","'Kɩ 'lɩ ‑Yusu a ‑nagbopʋ* nɩ ‑pu ꞊tu 'ʋ 'hʋɛn ‑mʋ' 'nyɩ, ɛ kɔ ‑nagbopi ‑bɩ. 'A 'nyrɛ mɔ Judɩa. 'A kɩbʋhlanyrɛ mɔ Yisikalio. Ɛ nɔ‑ 'kuo ‑hʋɩn* a nyiblo gbagbʋ Satan, ɛ bi 'ʋ ke'. ");
INSERT INTO ktj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judɩa a 'mʋ, ɛ nɔ‑ 'du ye', 'ɛ mu 'lɩ ‑cɔhlʋnpinyʋ* gbagbɩ ‑mɔ, kɔ Nyɩsʋa a 'kagbaʋ a 'yie꞊tunyʋ gbagbɩ 'hʋɛn‑, 'ɛ mu ꞊nʋ lee mɔ, ‑tɛ ɛ di ꞊nʋ ‑Yusu a ‑jɩ'pʋpʋʋ nu. ");
INSERT INTO ktj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","‑Tɛ ʋ pʋpʋ 'lɩ꞊ɩ lɛ, ‑ɛ ‑bɩ 'waa plɔ ble nɩ. 'A ‑tɩ, ʋ pʋ 'lɩ꞊ɩ nɩ, 'kɩ bʋ ‑nyi꞊e 'wliyɛ, 'bʋ mɔ, ‑tɛblɩ a pɛpɛ a 'mʋ, 'bʋ kɔ bʋ mu 'lu ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","‑Ɛ ‑bɩ Judɩa wɛn nɩ. Ɛ nu꞊o nɩ, kʋɛ 'ʋ ti a 'mʋ 'yie bʋ, 'ɛ ꞊mʋɛ ꞊tɔ lɛ, ‑tɛ ‑mʋ', ɛ di ‑Yusu nyibli a 'mʋ 'a ‑jɩ'pʋpʋʋ nu, 'kɩ nyibli 'yɛ nɩ di 'ʋ꞊ʋ ꞊dedede 'hʋɩ nɩ yi. ");
INSERT INTO ktj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Lɛ'mimle ‑mʋ', ‑ɛ mɔ Pakɩ a yɩ‑hɛ‑nyrɔwɔ 'kwli, 'kɩ ʋ yɩ 'ʋ 'flɔɔdʋ ‑mʋ', ‑ɛ kɔ ‑mɔ ʋ 'yɛ nɩ pʋ 'lɩ 'yaadɛ ‑dii ‑nɩ, 'ʋ 'lɛɛ 'ʋ 'blayonʋ lɛ ‑wɛ, 'kɩ 'ʋ dididɛ gbagbʋ a 'mʋ 'a ‑ta'. ‑Tɛ ‑nyrɔwɔ a 'mʋ, ɛ nyre 'ʋ, ");
INSERT INTO ktj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","‑ɛ ‑bɩ ‑Yusu yɩ Piɛlɩ kɔ Saan 'hʋɛn‑ 'nɩ ‑lee ‑nɩ, ɛ wɛn: «Ba mu Pakɩ a diidɛ ‑mɔ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","‑Ɛ ‑bɩ ʋ 'bɛti꞊e nɩ: «‑Bɩ' ‑hʋɛ ‑ba pii dididɛ a 'mʋ yɩ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","‑Ɛ ‑bɩ ɛ ꞊tu ꞊nʋ ꞊wɔn: «Ba pʋ 'ʋ nʋa bʋ: Ba mu 'lɩ Jrusrɛdɩɔ 'kwli. A kɔ nyɩbɛhɩan ꞊dʋ 'hʋɛn‑, a di 'nɩ ꞊ŋmee ‑nɩ. Nyiblo a 'mʋ, ɛ 'ble 'nɩya. Ɛ nɔ‑ ba kʋɛ ꞊wien. 'Kayu ‑kɔ bʋ ɛ di 'lɩ pa, 'kɩ ba pa 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ba lee 'kayu a 'mʋ, 'a kʋkɔnyɔ, kɛ‑ ba pʋ: ‑Aan tɔɔnyɔ yɩ ‑mʋ 'nɩ 'bɛti ‑nɩ, ‑gblo a 'dɩ ‑bɩ ‑kɔ 'kwli, ɛ kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ di 'lɩ Pakɩ a diidɛ 'lɩ ‑dii ‑nɩ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","‑Ɛ ‑bɩ ‑Yusu wɛn 'nɩ de: «Ɛ di tɔɔ nɛ 'a mʋ ‑gblo gbagbʋ, 'kɩ 'lɩ 'a yɔ'kayu a 'mʋ, 'a yɩ‑hɛ‑gbɔ yra. 'Kɩ 'kayu a ‑tɛblɩ a pɛpɛ ꞊cɛɛ 'lɩ. 'Kɩ ba pii 'lɩ diidɛ a 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","‑Tɛ ʋ nyre 'lɩ, ‑ɛ ‑bɩ ɛ mɔ ꞊han‑tɩ, ‑tɛ ‑Yusu nu wɛn 'a hɩhla, kɛ‑ ʋ nu 'ʋ ‑tɛblɩ a 'mʋ, 'a bʋyɛɛlɛ, 'ʋ bi 'ʋ, 'ʋ pi Pakɩ a diidɛ a 'mʋ. ‑Tɛ ʋ ‑wɛ 'a pipie ‑mɔ, ‑ɛ ‑bɩ ʋ ‑mɛ kle. ");
INSERT INTO ktj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","‑Winse, ‑tɛ dɛditi nyre 'ʋ, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ 'kukue lɛ, ʋ 'mʋ dɛ di. ");
INSERT INTO ktj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «'Na ꞊wlʋ ꞊mʋɛ mɔ꞊ɔ lɛ dɩakɩ, 'kɩ a kɔ 'mʋ 'hʋɛn‑ ba di Pakɩ a diidɛ ‑bʋ, 'tɩ‑ ɛ 'mʋ 'na ꞊hɩʋɛn'yeti kɩ yɛ. ");
INSERT INTO ktj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kɛɛ, 'n yɩ 'kɩ 'a mʋ 'nɩ ‑lee ‑nɩ: 'N 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ di Pakɩ a diidɛ de, ɛ 'mʋ ti ‑mʋ' kɩ yɛ, ‑ɛ kɔ 'yri Nyɩsʋa di ‑hʋan 'ʋ 'a dakɔ a wʋwa ‑mɔ ‑wɛ, 'kɩ 'lɩ 'a 'klɔ yrayrʋ ‑mʋ' 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ɛ 'du ‑wiin‑ŋanʋ ye', 'ɛ ‑nyi Nyɩsʋa 'wio, ɛ wɛn: «Ba klɔ bʋ, ba ‑hie꞊e. ");
INSERT INTO ktj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, kʋɛ kɛ 'kɩ mɔ bʋ, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ 'na 'kɩ nɔdʋ ‑bʋ de, ɛ 'mʋ꞊ʋ gba ‑gbagba, ɛ 'mʋ ti ‑mʋ' kɩ yɛ, ‑ɛ kɔ 'yri Nyɩsʋa di 'a dakɔ a wʋwa ‑mɔ ‑wɛ,» ");
INSERT INTO ktj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","'ɛ 'du 'flɔɔ ye', 'ɛ ‑nyi Nyɩsʋa 'wio, 'ɛ 'bɛ꞊ɛ ꞊tɩɔ lɛ, 'ɛ ‑nyi꞊e 'a ‑nagbopʋ, ɛ wɛn: «'Flɔɔ ‑bʋ, ɛ nɔ‑ mɔ 'na 'hʋɩ, 'n di ‑ha, 'kɩ 'ʋ 'aan ‑ta'. Kʋɛ kɛ 'kɩ mɔ bʋ, 'flɔɔ a ꞊tɩɔlɛ'bɛdɛ a 'mʋ, kɔ 'a didie a 'mʋ 'hʋɛn‑, ɛ nɔ‑ ba gba 'lu ‑mɔ, ‑ɛ di꞊e nu, a 'mʋ 'na ‑tɩ 'lu ‑mɔ lɛ ‑hie, 'a ‑nɛ ti.» ");
INSERT INTO ktj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","‑Tɛ ʋ ‑wɛ dɛ lɛ, ‑ɛ ‑bɩ ɛ 'du ‑wiin‑ŋanʋ ye', 'ɛ ‑nyi Nyɩsʋa 'wio, 'ɛ ‑nyi꞊e 'a ‑nagbopʋ, 'kɩ bʋ ‑hie꞊e, ɛ wɛn: «‑Wiin ‑bʋ, ɛ ꞊hɛn 'nyrɛ Nyɩsʋa a 'yrɩ yrayrɩ a ꞊tutuo. Nyɩsʋa a 'mʋ, ɛ di nu 'na ‑hlʋ, ɛ 'mʋ 'yrɩ yrayrɩ a 'mʋ ꞊tu, ɛ kɔ 'a mʋ 'hʋɛn‑. 'Na ‑hlʋ a 'mʋ, 'n di꞊e bʋ 'nɩ 'wla, 'kɩ 'ʋ 'aan ‑ta'.» ");
INSERT INTO ktj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ de: «Ba pʋ 'ʋ nʋa bʋ ‑tɛɛ: Nyiblo ꞊dʋ nɩ mɔ dɛdi‑tuo ‑bʋ kɩ. Nɔ‑ di 'mʋ 'na yraanyibli ‑jɩ' pʋ, ‑ʋ ꞊mʋɛ 'na 'lɩla lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","'Ɛ mɔ ‑tɛɛ, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'n kɔ ꞊bʋ 'kʋ, ꞊wɩ yɩ, ‑tɛ Nyɩsʋa nu 'a ‑hʋhʋa. Kɛɛ, 'jrɔ 'kɩ 'ʋ nyiblo ‑mʋ' ‑mɔ, ‑ɛ di 'mʋ 'na yraanyibli ‑jɩ' pʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","‑Tɛ ‑Yusu ‑yrɛ, ‑ɛ ‑bɩ 'a ‑nagbopʋ ‑tʋa 'a lɛ'bɛtilɛ, ʋ wɛn: «Nyiblo a 'dɩ ‑bɩ, ‑ɛ nɩ 'nɛ‑ ‑a mʋ 'nyɩ, ‑ɛ di꞊e 'a yraanyibli ‑jɩ' pʋ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ 'a ‑nagbopʋ ‑tʋa lɛ'bɛtilɛ, 'kɩ 'lɩ gblɛ a pʋpʋʋ 'kwli, ʋ wɛn: «Nyiblo a 'dɩ ‑bɩ, 'kɩ 'nɛ‑ ‑a mʋ 'nyɩ, ʋ di lɛ pʋ, ‑ɛ nɩ 'ʋ 'a 'bio 'lu yɩ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Bʋ nɩ 'lɩ ‑tɩ a 'mʋ, 'a hɩhla 'kwli, ‑ɛ ‑bɩ ‑Yusu lee ꞊nʋ nɩ, ɛ wɛn: «'Kɩ 'nɛ‑ 'klɔ ‑bʋ kɩ, 'kɩɩnpʋ kɔ bodɩɔpʋ 'hʋɛn‑, ʋ tʋɛ ꞊nɛ 'waa nyibli yɩ, ‑ɛ mɔ, ʋ nɩ 'klɩ kɩ, 'tɩ‑ 'ʋ ‑hʋɛ꞊ɛ, 'kɩ 'waa nyibli a 'mʋ, bʋ hla꞊a, ‑ɛ mɔ, 'waa naanyʋ ni ꞊nʋ ꞊haan‑tɛblɩ 'yi ꞊hlɔn lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kɛɛ, 'a mʋ ‑mɔ ‑bɩ, 'aan dɛ 'yɩ yɩ ‑blɛɛ ‑nɩ, bʋ nɩ 'mʋ lɛ. Nyiblo ‑mʋ', ‑ɛ mɔ nyiblo gbagbʋ, ɛ blɛɛ yɩ, bʋ mɔ 'aan lɛlenyɔ, 'tɩ‑ nyiblo ‑mʋ', ‑ɛ kɔɔ nɛ 'a mʋ win kɩ, ɛ blɛɛ yɩ, bʋ 'wɩ nyiblo ‑bʋ yɩ, ‑ɛ ꞊tui 'ʋ 'a 'bio 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","꞊Bʋ pʋʋ ꞊nɛ dɛ yɩ: Nyiblo ‑mʋ', ‑ɛ nɩ 'ʋ dɛdihu kɩ, ɛ kɔ nyiblo ‑bɩ ‑mʋ', ‑ɛ mɔ lɛlenyɔ, ‑ɛ yɩ didi‑tɛblɩ ‑hie, 'kɩ 'lɩ ʋ nɩ 'hʋɛn a 'mʋ 'nyɩ, nyiblo a 'dɩ ‑bɩ ‑nɩ 'ʋ 'a 'bɩhɩan 'lu yɩ 'lɩ? ꞊Bɩ ɛ 'yɩ nyiblo ‑mʋ', ‑ɛ nɩ 'ʋ dɛdihu kɩ 'pa‑? Kɛ‑ ɛ ꞊ti 'mʋ, 'kɩ 'lɩ ‑tonyibli 'nyɩ. Kɛɛ, 'mɔ ‑bɩ, 'kɩ 'nɛ‑ 'a mʋ 'nyɩ, 'n 'wɩ‑ lɛlenyɔ yɩ. ");
INSERT INTO ktj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","‑Tɛ ʋ yɩ 'ʋ 'mʋ lɛ nɩ ꞊tɛɛ nɩ, a 'yɩ 'ʋ 'mʋ bʋ ‑hie, kɛɛ, a 'cibi 'ʋ 'mʋ 'hʋɩ. ");
INSERT INTO ktj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ɛ nɔ‑ nu꞊o, 'nɩ yɩ 'a mʋ ‑lee ‑nɩ, ‑ɛ mɔ, ti ‑mʋ' ‑kɔ 'yri 'n di 'ʋ nyibli win kɩ ‑kɔɔ ‑nɩ, 'n di ‑nyi 'a mʋ 'klɩ, a kɔ 'mʋ 'hʋɛn‑, ‑a 'mʋ ‑kʋan a 'mʋ nu, ꞊wɩ yɩ, ‑tɛ 'na 'Baɩ Nyɩsʋa ‑nu, 'ɛ ‑nyi 'mʋ 'klɩ, 'kɩ ɛ kɔ 'mʋ 'hʋɛn‑, ‑ba kɔɔ nyibli win kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ti a 'mʋ, 'bʋ nyre 'ʋ, a kɔ 'mʋ 'hʋɛn‑, 'kɩ ‑a di 'ʋ ‑tɛ nɩ ‑do dɛ ‑dii ‑nɩ. 'Kɩ a di 'ʋ ‑batipʋgbatɩ kɩ blɛ nɩ, a 'mʋ Yisraɛkʋɛ a ꞊tugbi nɩ ‑pu ꞊tu 'ʋ 'hʋɛn ‑mʋ' ‑bati lɛ ‑pʋʋ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","‑Yusu, nɔ‑ yɩ 'lɩ Simɔ Piɛlɩ ‑mɔ ‑hlee ‑nɩ, ɛ wɛn: «Simɔ o, pʋ 'mʋ nʋa yɩ bʋ. Satan, ‑ɛ mɔ 'kuo ‑hʋɩn* a nyiblo gbagbʋ, nɔ‑ ‑hʋa Nyɩsʋa 'klɩ, 'kɩ bʋ ꞊tɛɛ 'ʋ ‑mʋ lɛ, ꞊wɩ yɩ, ‑tɛ nʋgba ni, 'bʋ ꞊hlon ‑kʋbʋ lɛ, 'ɛ ‑hɛ 'lɩ 'a ꞊tutui 'lɩ, ꞊haan‑kʋbʋ 'ɛ yɩ 'lɩ ‑ŋmahɛn 'kwli hie. ");
INSERT INTO ktj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kɛɛ, 'mɔ ‑bʋ, 'n nyaa Nyɩsʋa lɛ, 'kɩ 'ʋ ‑na ‑ta', 'kɩ ‑bʋ 'cibi 'ʋ 'na ꞊wlʋ a yɩkuolɛ. Ti ‑mʋ' ‑kɔ 'yri ‑di꞊e yru, ‑ɛ mɔ, ‑nu yɩnyredɛ, ‑ɛ ‑bɩ ‑bʋ ‑nyi ‑na 'dɩayɩnʋ 'klɩ, 'kɩ bʋ kuo 'mʋ ꞊wlʋ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","‑Ɛ ‑bɩ kɛ‑ Simɔ pɩ꞊ɩ yɩ: «Kʋkɔnyɔ, 'bʋ mɔ, 'bʋ pʋ ‑mʋ ꞊jɩ', 'n di꞊e 'nɩ ‑hʋa, bʋ pʋ 'mʋ ꞊jɩ' ‑wɛ. 'Bʋ mɔ, 'bʋ 'la ‑mʋ, 'na mumu, 'n di꞊e 'nɩ ‑hʋa, bʋ 'la 'mʋ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ꞊ɩ yɩ, ɛ wɛn: «Piɛlɩ, 'n yɩ ‑mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, 'kɩ 'lɩ 'tɔlʋwɔ nɩ ‑do ‑bʋ 'kwli, 'tɩ‑ hapɛ 'mʋ ‑nyrɛ da, ‑di nu 'na ‑mɔ‑gaawɩ nɩ ta, ‑ɛ mɔ, ꞊yɩ 'mʋ ‑yi.» ");
INSERT INTO ktj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ de, ɛ wɛn: «'N lee la 'a mʋ nɩ, 'kɩ ba na la 'dɩɩ klɛ, ba pʋ la 'na ꞊haantitie nyibli, 'nɩ lee la 'a mʋ, ‑ɛ mɔ, 'ba yɩ la nɩ mi, a 'nɩ 'gbaa la 'lɩ 'wliyɛ, kɔ blɔ, kɔ 'suin 'hʋɛn‑. ‑Tɛ a 'yɩ la ‑tɛblɩ a 'mʋ ‑gba, ꞊bɩ dɛ nɩ 'ʋ, a 'yɩ la ‑kɔ, a ‑hʋa la?» ‑Ɛ ‑bɩ ʋ wɛn: «'Ʋʋn‑, ɛ 'yɩ la dɛ ꞊dʋ ‑kɔ, ‑a 'yɩ la ‑kɔ, ‑a ‑hʋa la.» ");
INSERT INTO ktj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ de: «Kɛɛ, ‑tɛ ti nɛ ‑bʋ, ɛ 'yɩ 'mʋ lɛ ‑nɩ. Nyiblo 'bʋ kɔ 'wliyɛ, 'bʋ kɔ blɔ, bʋ gba꞊a. Kɔ, nyiblo 'bʋ 'yɩ 'plɩɩn ‑kɔ, bʋ plo 'a dɩɔnʋ a wlawlʋ ‑bɩ, ɛ 'mʋ 'plɩɩn ‑tɔ. ");
INSERT INTO ktj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, 'n yɩ a 'mʋ 'nɩ ‑lee ‑nɩ, ‑tɩ ‑mʋ', ʋ 'crɩ la, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ɛ kɔ bʋ mu 'lu ‑mɔ, 'kɩ 'ʋ 'mʋ kɩ. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: 'Kɩ ʋ ‑hree 'lɩ꞊ɩ ‑balʋnyibli 'nyɩ. Ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, ‑tɩ a 'mʋ ʋ, 'crɩ la, 'kɩ 'ʋ 'mʋ kɩ, ɛ 'tɩɛ nyre 'ʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","‑Ɛ ‑bɩ ʋ wɛn: «Kʋkɔnyɔ, 'ye kɛ, ‑a kɔ 'plɩɛn nɩ 'hʋɛn.» ‑Ɛ ‑bɩ ɛ wɛn: «Ɛ nu ‑tɛɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ ꞊tɩ 'dɩɔ, 'ʋ mu 'lɩ dʋgba ‑mʋ', ‑ɛ kɔ 'lu olifieti nɩ 'lɩ. 'Kɩ 'lɩ dʋgba a 'mʋ 'lu, 'kɩ ‑Yusu 'cibi 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","‑Tɛ ʋ nyre 'lɩ ‑tuo a 'mʋ kɩ, ‑ɛ ‑bɩ kɛ‑ ‑Yusu pɩ: «Ba da Nyɩsʋa, ‑ɛ di꞊e nu, 'kuo ‑hʋɩn* a nyiblo gbagbʋ 'bʋ yɩ 'ʋ 'a mʋ lɛ nɩ ꞊tɛɛ ‑nɩ, a 'nɩ ꞊ha dɛ 'kuku nu.» ");
INSERT INTO ktj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ɛ ‑hɔn 'ʋ ꞊nʋ 'hʋɩ, 'ɛ 'yɩya 'ʋ ye' bʋ dɛ gbe. ‑Ɛ ‑bɩ ɛ 'gbla kwlɩ, 'ɛ ‑tʋa Nyɩsʋa a dɩda, ");
INSERT INTO ktj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ɛ wɛn: «'Na 'Baɩ, 'bʋ mɔ, ꞊nɩ yɩ꞊ɩ nɩ ‑hʋɛ, hlɔɔ 'mʋ ꞊hɩʋɛn ‑bʋ ‑mɔ lɛ, 'n kɔ ꞊bʋ 'ye. Kɛɛ, bʋ mɔ ‑na kɩwɛɛnlɛ, ɛ 'nɩ 'mɔɔ 'lɩ 'na kɩwɛɛnlɛ.»  ");
INSERT INTO ktj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Bʋ nɩ 'kɩ 'ʋ bʋ, ‑ɛ ‑bɩ Nyɩsʋa a lɛlenyɔ 'hrɩɩ ꞊nɛ yɩ, 'ɛ di꞊e 'klɩ ‑nyi mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ hʋannʋ bi 'lɩ꞊ɩ 'kwli, ɛ nɔ‑ mɔ, bʋ ꞊tu 'ʋ 'klɩ, bʋ da Nyɩsʋa de. ‑Hihiu ‑bʋ, ‑ɛ ‑hʋɛn 'lɩ꞊ɩ 'hʋɩ, ɛ 'wɩ‑ ‑hlʋ a tapʋɩ yɩ. ");
INSERT INTO ktj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","‑Tɛ ɛ da 'kɩ Nyɩsʋa, ‑ɛ ‑bɩ ɛ 'du ye', 'ɛ mu 'lɩ 'a ‑nagbopʋ 'hʋɩ. ‑Tɛ ɛ nyre 'ʋ ꞊nʋ 'hʋɩ, ʋ yɩ 'nɩ ŋme, 'kla‑wliye'yɩya a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ 'kɩ ꞊nʋ yɩ: «Dɛ kɔ ŋmena a yɩ ŋme 'lɩ? Ba 'du ye', ba da Nyɩsʋa, ‑ɛ di꞊e nu, 'kuo ‑hʋɩn a nyiblo gbagbʋ, 'bʋ yɩ 'ʋ 'a mʋ lɛ nɩ ꞊tɛɛ ‑nɩ, a 'nɩ ꞊ha dɛ 'kuku nu.» ");
INSERT INTO ktj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Win nɩ 'lɩ ‑Yusu wlɔn, ‑ɛ ‑bɩ nyibli ‑hʋɔhʋɩ waan 'lɩ nɩ. Judɩa, ‑ɛ mɔ ‑Yusu a ‑nagbopʋ* nɩ ‑pu ꞊tu 'ʋ 'hʋɛn a nyiblo ‑bɩ, ɛ nɔ‑ pʋ nyibli a 'mʋ ye', 'ɛ ꞊cɩcrɛ 'ʋ ‑Yusu 'hʋɩ bʋ, 'ɛ 'wlɛɛ ꞊nɛ. ");
INSERT INTO ktj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ꞊ɩ yɩ: «Judɩa, ꞊bɩ 'kɩ 'lɩ 'na 'wlɛɛlɛ 'kwli, 'kɩ ‑hʋɛ ‑bʋ naa 'lɩ, ‑bʋ pʋ 'mʋ 'na yraanyibli ‑jɩ', 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo?» ");
INSERT INTO ktj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","‑Tɛ ‑Yusu a ‑nagbopʋ yru dɛ a 'mʋ, ‑ɛ mi 'ʋ nyre mɔ, ‑ɛ ‑bɩ ʋ 'bɛti ‑Yusu nɩ, ʋ wɛn: «Kʋkɔnyɔ, ꞊bɩ ‑ba nu 'plɩɛn, ‑ba ‑wɔn ꞊nʋ ‑mɔ?» ");
INSERT INTO ktj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","'Kɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* a nyiblo gbagbʋ a ‑kʋannunyɔ nɩ 'ʋ ‑tuo a 'mʋ kɩ. ‑Ɛ ‑bɩ ‑Yusu a ‑nagbopi ‑bɩ nu 'a 'plɩɛn, 'ɛ 'bɛ 'ʋ ‑kʋannunyɔ a 'mʋ, 'a diidɛnʋa. ");
INSERT INTO ktj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","‑Ɛ ‑bɩ ‑Yusu wɛn: «Ɛ ‑wɛ ‑mɔ», 'ɛ ‑hrɛn nyɩbɛyu a 'mʋ a nʋa lɛ, 'ɛ nu꞊o, 'ɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","‑Tɛ ɛ ꞊tu 'ʋ nʋa a 'mʋ 'a ‑ta', ‑ɛ ‑bɩ ɛ ꞊hɩan ‑mɔ, 'ɛ yɩ 'lɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ gbagbɩ ‑mɔ ‑hlee ‑nɩ, kɔ Nyɩsʋa a 'kagbaʋ a 'yie꞊tunyʋ gbagbɩ, kɔ ‑Juukʋɛ a 'blʋ a nyibli, ‑ʋ di꞊e klɔ mɔ 'hʋɛn‑. Kɛ‑ ɛ pɩ: «Ta‑wɔn‑tɛblɩ kɔ ti 'hʋɛn‑, ɛ nɔ‑ a ‑ya, 'a di 'mʋ klɔ mɔ, ‑tɛ ʋ ni ‑balʋnyɔ a kʋklɔ. ");
INSERT INTO ktj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","'Tɩ‑, 'a ‑nɛ ti, 'kɩ a kɔ 'mʋ 'hʋɛn‑, ‑a nɩ la 'lɩ Nyɩsʋa a 'kagbaʋ bʋ, 'kɩ a 'yɩ 'lɩ na kʋklɔ lɛ ꞊mʋɔ ‑nɩ. Kɛɛ, ti ‑mʋ', Nyɩsʋa ‑nyi 'a mʋ, a kɔ 'kuo ‑hʋɩn* a nyiblo gbagbʋ 'hʋɛn‑, ‑ɛ mɔ halɔ 'nyɩ a nyiblo gbagbʋ, ti a 'mʋ, ɛ nɔ‑ nyre 'ʋ. Ɛ nɔ‑ nu꞊o, 'a kɔ 'klɩ, 'kɩ ba nu 'aan ‑kʋan.» ");
INSERT INTO ktj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","‑Tɛ ‑Yusu ‑wɛ win a pʋpʋʋ ‑mɔ, ‑ɛ ‑bɩ ʋ klɔ꞊ɔ nɩ, 'ʋ gbɛ 'lɩ꞊ɩ ‑cɔhlʋnpinyʋ* a nyiblo gbagbʋ a 'kayu bʋ. Piɛlɩ ‑mɔ ‑bɩ, ɛ yɩ kʋɛ ‑Yusu ꞊wien, 'kɩ 'lɩ ‑mɔhlɔɔlɛ 'kwli, 'ɛ ‑hɛ 'lɩ 'waa ꞊pɩ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","'Kɩ 'ʋ ‑patʋ', 'kɩ ʋ 'tie 'ʋ nagba, 'ʋ ꞊glaa 'lɩ꞊ɩ lɛ. Nyibli ‑mʋ', ‑ʋ ꞊glaa 'lɩ nagba a 'mʋ lɛ, ʋ nʋ‑ kɔ 'nyɩ Piɛlɩ nɩ 'lɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","'Kɩ ʋ nɩ 'kɩ 'ʋ bʋ, ‑ɛ ‑bɩ ‑kʋannunʋgba ‑bɩ 'ye꞊e nɩ, 'ɛ ‑hrʋʋ ꞊nɛ 'yie lɛ, ɛ wɛn: «Nyiblo ‑bʋ, ɛ mɔ ‑Yusu a ‑nagbopi* ꞊nɩɔ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kɛɛ, ‑ɛ ‑bɩ Piɛlɩ ‑ga nɩ, ɛ wɛn: «Nʋgba o, 'n 'yɩ꞊ɩ ‑yi mɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","‑Tɛ ɛ ‑hi, ‑ɛ ‑bɩ nyɩbɛyu ‑bɩ 'ye Piɛlɩ nɩ. Kɛ‑ ɛ pɩ, 'ɛ yɩ꞊ɩ ‑lee ‑nɩ: «‑Mɔ ‑bʋ, 'kɩ ‑nɩ 'lɩ 'a nyibli a 'mʋ 'nyɩ.» ‑Ɛ ‑bɩ ɛ wɛn: «Nyɩbɛyu o, ɛ 'yɩ 'mɔ 'pa‑.» ");
INSERT INTO ktj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","‑Haawɔ nɩ ‑do bʋ ‑hi, ‑ɛ ‑bɩ nyɩbɛhɩan ‑bɩ nɩ 'ʋ. Kɛ‑ ɛ pɩ꞊ɩ yɩ, 'kɩ 'lɩ win 'yaklɩ 'kwli: «꞊Han‑tɩ ꞊nɩɔ, nyiblo ‑bʋ, ɛ mɔ ‑Yusu a ‑nagbopi ‑bɩ ꞊nɩɔ ‑wɛ, ‑kɔtɩ ʋ nɩ 'hʋɛn a 'mʋ, ʋ mɔ Galilekʋɛ ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","‑Ɛ ‑bɩ kɛ‑ Piɛlɩ pɩ nyɩbɛhɩan a 'mʋ yɩ: «Nyɩbɛyu o, ‑tɩ ‑bʋ, ‑hlɛ, 'nɩ ‑yru꞊o 'lɩ꞊ɩ lɛ.» Bʋ nɩ 'lɩ win a pʋpʋʋ 'kwli, ‑ɛ ‑bɩ hapɛ da ‑nyrɛ nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Hapɛ bʋ da 'kɩ ‑nyrɛ, ‑ɛ ‑bɩ Kʋkɔnyɔ ‑Yusu ꞊hɩan ‑mɔ, 'ɛ ‑tʋa Piɛlɩ a 'yiye. Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ ‑tɩ ‑mʋ', Kʋkɔnyɔ lee wɛn꞊ɛ, ‑ɛ mɔ: «'Tɩ‑ hapɛ 'mʋ kɛ ‑nyrɛ da, ‑di nu kɛ 'na ‑mɔ‑gaawɩ nɩ ta, ꞊mʋ lɛ pʋ, ꞊yɩ 'mʋ ‑yi,» ‑ɛ ‑bɩ ‑tɩ a 'mʋ, ɛ bi 'lɩ꞊ɩ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","‑Tɛ ɛ bi 'lɩ꞊ɩ 'kwli, ‑ɛ ‑bɩ ɛ 'hrɩ 'lɩ ‑yaa 'kwli nɩ, 'ɛ ‑tʋa wuwe, 'kla‑wliye'yɩya a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Nyibli ‑mʋ', ‑ʋ ꞊tui ‑Yusu 'yie, ʋ 'cɛɛ ꞊nɛ nɩ, 'ʋ mʋa nɛ 'a 'yii klɛ, 'tɩ‑, 'ʋ yɩ꞊ɩ bi. Ʋ nɩ 'lɩ 'a bibie 'kwli, ‑ɛ ‑bɩ ʋ yɩ꞊ɩ lɛ 'nɩ 'bɛti ‑nɩ, ʋ wɛn: «Nyɩsʋa a winwlɔn‑hanyɔ o, lee nɛ ‑a mʋ, nyiblo a 'dɩ ‑bɩ ‑hren ‑mʋ dɛ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","'Tɩ‑ ʋ 'mʋ ‑yrɛ mɔ mu, ‑ɛ ‑bɩ ʋ ‑ha꞊a 'yri lɛ dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","‑Tɛ ‑nyrɛ ‑nyɛ, ‑ɛ ‑bɩ ‑Juukʋɛ a naanyʋ, kɔ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ, kɔ tetetɔɔnyʋ 'hʋɛn‑, nʋ‑ 'kukue lɛ, 'kɩ 'ʋ ‑Yusu a ‑bati a lɛpʋʋlɛ a ‑ta'. ‑Ɛ ‑bɩ ʋ lee nyibli ‑mʋ', ‑ʋ yɩ la ꞊nʋ ‑hɛɛ ‑nɩ nɩ, 'kɩ bʋ ya 'lɩ ‑Yusu 'waa ‑gbolugbo gbagbʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","‑Tɛ ʋ ya ꞊nʋ꞊ʋ yɩ, ‑ɛ ‑bɩ ʋ 'bɛti꞊e nɩ, ʋ wɛn: «꞊Bɩ ‑mɔ mɔ Wanyɔ ꞊mʋ, Nyɩsʋa pʋ la lɛ, ɛ di la ya, 'kɩ 'ʋ 'a dakɔ a wʋwa a ‑ta'? 'Bʋ mɔ ‑mɔ, lee nɛ ‑a mʋ.» ‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ: «'Bʋ mɔ, 'nɩ pʋ lɛ: Iin, 'mɔ ꞊nɩɔ, a 'nɩ ‑pʋ꞊ʋ lɩ꞊ɩ ꞊haan‑tɩ nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ɛ mɔ, 'bʋ mɔ, 'nɩ 'bɛti 'a mʋ ‑wɛ, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba ‑hɩhɩa 'mʋ klɛ. ");
INSERT INTO ktj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kɛɛ, kʋɛ kɛ 'kɩ mɔ bʋ, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'kɩ 'n di 'ʋ 'Klɩkɩnɩnyɩsʋa a diidɛkɩbɩa kɩ bʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","‑Ɛ ‑bɩ 'waa pɛpɛ, ʋ wɛn: «꞊Bɩ ‑mɔ Nyɩsʋa a 'Yu ꞊nɩɔ?» ‑Ɛ ‑bɩ ɛ ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «Ɛ mɔ ꞊han‑tɩ, 'mɔ ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","‑Ɛ ‑bɩ ʋ wɛn: «‑A 'nɩ ‑hʋa꞊a 'kɩ ‑hɛhɩnyibli ꞊dʋ de. ‑Aan ꞊gbɛtʋ, ‑a 'wɩn 'a wlɔn bʋ a win nɩ. (‑Tɛ ɛ pʋ lɛ, ‑ɛ mɔ, ɛ mɔ Nyɩsʋa a 'Yu ꞊nɩɔ, ɛ mɔ Nyɩsʋa a ‑tɩ a lɛ‑hɛɛlɛ ꞊nɩɔ. 'A ‑tɩ 'kɩ o, ɛ kɔ bʋ 'kʋ.)» ");
INSERT INTO ktj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Bʋ ‑yrɛ 'kɩ, ‑ɛ ‑bɩ ʋ 'du ye', 'ʋ gba 'lɩ꞊ɩ Romakʋɛ a ‑gʋlʋnʋma ‑mɔ. 'A 'nyrɛ mɔ Pilatɩ. (Romakʋɛ, nʋ‑ kɔɔ ‑Juukʋɛ* win kɩ. ‑Juukʋɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ 'la nyiblo 'bʋ mɔ, Romakʋɛ 'bʋ 'yɩ ‑wɛn. Ɛ nɔ‑ kɔ ‑tɩ, ‑Juukʋɛ 'ʋ gba 'lɩ ‑Yusu Pilatɩ ‑mɔ,) ");
INSERT INTO ktj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","'ʋ ‑tʋa 'a ‑tɩ a yɛɛlɛ, ʋ wɛn: «‑A 'nɛɛ nyiblo ‑bʋ 'yie kɩ bʋ. Ɛ nɔ‑ ‑wɛn ‑a mʋ yɩ, 'kɩ 'nɛ‑ ‑aan 'blʋgba 'kwli, 'ɛ yɩ nyibli ‑lee ‑nɩ, ‑ɛ mɔ, ʋ 'nɩ 'pɛɛ 'lɩ 'blʋwli ‑mʋ', Romakʋɛ a 'kɩɩn gbagbʋ pʋ lɛ, ‑ba 'pɛɛ ‑nɩ. 'Ya 'ʋ 'lu de, ɛ wɛn, ɛ nɔ‑ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ‑a mʋ yɩ ya, ɛ ꞊hɛn 'nyrɛ, ‑ɛ mɔ, ɛ mɔ bodɩɔ ‑bɩ ꞊nɩɔ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","‑Ɛ ‑bɩ Pilatɩ yɩ꞊ɩ 'nɩ 'bɛti ‑nɩ, ɛ wɛn: «꞊Bɩ ‑mɔ mɔ ‑Juukʋɛ a bodɩɔ?» ‑Ɛ ‑bɩ kɛ‑ ‑Yusu ‑pʋ: «Iin, 'mɔ ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","‑Ɛ ‑bɩ Pilatɩ ‑tʋa 'lɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ kɔ nyibli ‑hʋɔhʋɩ ‑mʋ' 'hʋɛn‑, 'waa ‑mɔhleelɛ, ɛ wɛn: «Nyiblo ‑bʋ, dɛ ‑hʋan bʋ di nu, 'nɩ 'ye꞊e lɩ꞊ɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kɛɛ, ʋ 'yɩ Pilatɩ kɩ ‑wɛn, 'ʋ ‑tʋa 'lɩ win a 'yaalɛ, ʋ wɛn: «Nyiblo ‑bʋ, 'a tɔɔwin ꞊gbugblo 'blʋgba a pɛpɛ nɩ, kʋɛ 'lɩ Galileblʋgba 'kwli bʋ, ‑bʋ nyre 'nɛ‑ Jrusrɛdɩɔ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","‑Tɛ Pilatɩ 'wɩn 'waa win a 'mʋ, ‑ɛ ‑bɩ ɛ yɩ 'nɩ 'bɛti ‑nɩ, ɛ wɛn: «꞊Bɩ nyiblo ‑bʋ, ɛ mɔ Galilekʋɛyu ꞊nɩɔ?» ");
INSERT INTO ktj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","‑Ɛ ‑bɩ ʋ wɛn: «Iin.» 'A ‑tɩ 'kɩ o, 'kɩɩn ‑bʋ, ‑ɛ mɔ Helɔdɩ, nɔ‑ kɔɔ Galileblʋgba win kɩ. ‑Tɛ Pilatɩ 'wɩn 'kɩ, ‑ɛ mɔ 'kɩ ‑Yusu ‑hɔn 'lɩ Galileblʋgba a 'mʋ 'kwli, ‑ɛ ‑bɩ ɛ lee nɛ 'a nyibli nɩ, 'kɩ bʋ gba 'lɩ꞊ɩ Helɔdɩ ‑mɔ. Ti a 'mʋ 'yri, 'kɩ 'kɩɩn Helɔdɩ a 'mʋ, ɛ nɩ 'lɩ Jrusrɛdɩɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","‑Tɛ Helɔdɩ 'ye ‑Yusu, ‑ɛ ‑bɩ ɛ kɔ plɔ a bleelɛ, ‑ɛ nu꞊o, ɛ yɩ 'wɩn 'a 'nyrɛ lɛ, see la, 'ɛ ꞊mʋɛ la 'a 'yiye lɛ, ‑ɛ di꞊e nu, ɛ 'mʋ ꞊wlɩlɛkɛɛ‑tɛblɩ, ‑Yusu di nu 'ye. ");
INSERT INTO ktj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","‑Yusu bʋ nɩ 'ʋ꞊ʋ ye', ‑ɛ ‑bɩ ɛ ‑tʋa 'a ‑tɛblɩ ‑hʋɔhʋɩ a lɛ'bɛtilɛ, kɛɛ, ‑Yusu 'yɩ꞊ɩ 'a ꞊dedede klɛ ‑hɩhɩa ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","'Kɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ kɔ tetetɔɔnyʋ 'hʋɛn‑, ʋ nɩ 'ʋ. Ʋ nʋ‑ yɩ ‑Yusu ‑tɩ ‑yɛɛ ‑nɩ, 'kɩ 'lɩ win 'yaklɩ 'kwli, ");
INSERT INTO ktj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Helɔdɩ kɔ 'a nyibli 'hʋɛn‑, 'ʋ 'cɛɛ ‑Yusu, kɔ, 'ʋ yɩ 'a ‑tɩ lɛ ‑hɛɛ ‑nɩ, 'ʋ pʋ꞊ʋ bodɩɔwlawlʋ, 'ʋ gba 'lɩ꞊ɩ Pilatɩ yɩ de. ");
INSERT INTO ktj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Helɔdɩ kɔ Pilatɩ 'hʋɛn‑, ʋ nyinyre la lɛ, kɛɛ, ‑nyrɔwɔ a 'mʋ 'kwli, ʋ ‑hɛ nɩnatumupʋ. ");
INSERT INTO ktj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ Pilatɩ da Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ, kɔ ‑Juukʋɛ* a naanyʋ kɔ nyibli ‑bɩ 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Kɛ‑ ɛ pɩ ꞊nʋ yɩ: «A wɛn 'nɩ, nyiblo ‑bʋ, ɛ nɔ‑ ‑wɛn 'a mʋ yɩ, 'kɩ 'nɛ‑ 'blʋgba ‑bʋ 'kwli. Ɛ nɔ‑ kɔ ‑tɩ, 'a ya 'mɔ꞊ɔ yɩ. Ba pʋ 'mʋ nʋa yɩ bʋ ‑tɛɛ: 'Na ꞊gbɛtʋ, 'n 'bɛti꞊e nɩ, kɩ mɔ 'a mʋ ye'. Yɩnyre‑tɛblɩ a pɛpɛ ‑bʋ, a 'ma꞊a 'lu bʋ, ɛ 'yɩ 'a nunu‑tɛblɩ 'pa‑. ");
INSERT INTO ktj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Mɔ, Helɔdɩ 'ye꞊e nɩ ‑wɛ, ‑ɛ mɔ, ‑tɛblɩ a 'mʋ, ɛ 'yɩ 'a nunu‑tɛblɩ 'pa‑. Ɛ nɔ‑ kɔ ‑tɩ, 'ɛ ‑mɩa ꞊nɛ kle. 'A ‑tɩ o, nyiblo ‑bʋ, ɛ 'yɩ yɩnyredɛ ꞊dʋ ‑nu, ‑bʋ blɛɛ 'kʋkʋʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","'A ‑tɩ, 'na 'sɛyo bʋ nu lɔkɔ, bʋ bi꞊e, 'tɩ‑ 'mʋ꞊ʋ bʋ tɛ.»  ");
INSERT INTO ktj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","'Bɩ ‑Juukʋɛ a lɛ'mimle ‑mʋ', ‑ɛ mɔ Pakɩ, 'bʋ nyre 'ʋ, Pilatɩ kɔ bʋ ‑ha nyiblo nɩ ‑do ꞊jɩ', 'kɩ 'ʋ ‑Juukʋɛ a plɔ a bleelɛ a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kɛɛ, 'waa pɛpɛ a 'mʋ, ʋ ‑tʋa Pilatɩ a 'yilɛ꞊mʋmalɛ, ʋ wɛn: «Nu꞊o, nyiblo ‑bʋ bʋ 'kʋ, ‑bʋ ‑ha Balabasɩ ꞊jɩ'!» ");
INSERT INTO ktj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","'Tɩ‑, Balabasɩ a 'mʋ, ɛ kɔ nyibli ‑bɩ 'hʋɛn‑, ʋ nʋ‑ ‑wɛn la Romakʋɛ a naanyʋ yɩ, 'kɩ 'lɩ Jrusrɛdɩɔ 'kwli, 'tɩ‑ 'kɩ 'lɩ yɩ‑wʋnwɔnlɛ a 'mʋ 'kwli, ʋ 'laa la 'lɩ nyiblo. Ɛ nɔ‑ kɔ ‑tɩ, 'ʋ pʋ la ꞊nʋ ‑jɩ'. ");
INSERT INTO ktj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatɩ ‑hʋɛ꞊ɛ nɩ, bʋ tɛ ‑Yusu bʋ. Ɛ nɔ‑ kɔ ‑tɩ, 'ɛ ‑tʋa 'lɩ nyibli a 'mʋ, 'waa ‑mɔhleelɛ de. ");
INSERT INTO ktj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kɛɛ, ‑tɛ ʋ 'wɩn 'a win, ‑ɛ ‑bɩ 'waa pɛpɛ a 'mʋ, ʋ ‑tʋa Pilatɩ a 'yilɛ꞊mʋmalɛ, ʋ wɛn: «Kɔɔ 'ʋ꞊ʋ tugbɛ 'yie, ɛ 'mʋ 'kʋ! Kɔɔ 'ʋ꞊ʋ tugbɛ 'yie, ɛ 'mʋ 'kʋ!» ");
INSERT INTO ktj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","‑Ɛ ‑bɩ kɛ‑ Pilatɩ pɩ ꞊nʋ yɩ de, 'wɩ nɩ ta a dɛ: «Dɛ ‑hʋan a 'dɩ ‑bɩ ɛ ‑nu 'lɩ? 'N 'yɩ 'lɩ꞊ɩ dɛ ‑hʋan ꞊dʋ 'lɩ 'yee ‑nɩ, ‑bʋ blɛɛ 'kʋkʋʋ yɩ. 'A ‑tɩ o, 'n di lee 'na 'sɛyo, bʋ bii ꞊nɛ lɔkɔ. 'Bʋ ‑wɛ 'a bibie ‑mɔ, ‑ɛ ‑bɩ 'n tɛ꞊ɛ bʋ.» ");
INSERT INTO ktj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kɛɛ, ʋ 'tɩɛ ꞊mʋmʋɛ꞊ɛ 'yi lɛ, ʋ wɛn: «Kɔɔ 'ʋ꞊ʋ tugbɛ 'yie, ɛ 'mʋ 'kʋ!» 'Waa win nɩ 'ʋ Pilatɩ a win 'lu yɩ dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Bʋ 'yɛ nɩ wɛn ‑tɩ a 'mʋ, Pilatɩ hlɛ kɩ, ɛ nɔ‑ mɔ Pilatɩ bʋ ‑yra꞊a, 'kɩ bʋ wɛn dɛ ‑mʋ', 'waa ꞊wlɩ ‑hʋɛ kɩ, ");
INSERT INTO ktj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","'ɛ tɛ nyiblo ‑mʋ', ‑Juukʋɛ ‑hʋɛ bʋ, ‑ɛ mɔ Balabasɩ, ʋ pʋ la ꞊jɩ', 'kɩ 'ʋ 'blʋgba a ꞊gbugblolɛ a ‑ta', ɛ kɔ, ‑tɛ ɛ ‑nu, 'ɛ 'la la nyiblo a ‑tɩ. ‑Yusu ‑mɔ ‑bɩ, ɛ nɔ‑ ɛ ‑nyi 'a 'sɛyo, 'kɩ bʋ gba꞊a, bʋ 'la꞊a, ꞊wɩ yɩ, ‑tɛ ‑Juukʋɛ ni 'a ‑hʋhʋa. ");
INSERT INTO ktj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","‑Tɛ dɛ a 'mʋ, ‑ɛ ‑hi, ‑ɛ ‑bɩ Pilatɩ a 'sɛyo gbɛ ‑Yusu nɩ, 'ʋ ꞊tɩʋɛ ꞊nɛ 'dɩɔ, ʋ 'mʋ꞊ʋ 'la. Bʋ yɩ 'kɩ nɩ mi, ‑ɛ ‑bɩ ʋ kɔ nyɩbɛhɩan ‑bɩ 'hʋɛn‑, ʋ ꞊ŋmee nɩ. Nyɩbɛhɩan a 'mʋ, 'a 'nyrɛ mɔ Simɔ. 'Kɩ ɛ kɔɔ 'lɩ Silɛnɩdɩɔ 'kwli. Nɔ‑ ‑hʋɛn ‑titi. Simɔ a 'mʋ, ɛ nɔ‑ 'sɛyo ‑klɔ, 'ʋ hlɛ꞊ɛ ‑Yusu a tugbɛ, 'tɩ‑ 'ʋ lee ꞊nɛ, bʋ kʋɛ ꞊nʋ ꞊wien. ");
INSERT INTO ktj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nyibli ‑hʋɔhʋɩ, nʋ‑ yɩ ‑Yusu ꞊wien kʋɛ. Nʋgbɩ ‑hʋɔhʋɩ, nʋ‑ 'wlɛ꞊ɛ ke' bʋ, 'ʋ yɩ 'ʋ 'a ‑ta' ‑wee ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Bʋ yɩ 'kɩ꞊ɩ ‑mɔ nɩ ‑wee ‑nɩ, ‑ɛ ‑bɩ ‑Yusu ꞊hɩan ‑mɔ, 'ɛ ‑tʋa 'waa leelɛ, ɛ wɛn: «'A mʋ Jrusrɛ a nʋgbɩ, a 'nɩ 'wee 'lɩ, 'kɩ 'ʋ 'na ‑ta', kɛɛ, ba we, 'kɩ 'ʋ 'aan dɩɔnʋ, kɔ 'kɩ 'ʋ 'aan 'yonʋ a ‑ta', ");
INSERT INTO ktj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","‑ɛ nu꞊o, ꞊hɩʋɛn'yeti di 'ʋ 'nɩ nyre. Ti a mʋ 'yri, kɛ‑ ʋ di pʋ: Plɔ a bleelɛ 'kɩ 'ʋ nʋgbɩ ‑mʋ' ‑mɔ, ‑ʋ 'yɩ 'yukɔdɛ, ɛ kɔ 'waa dɛ ‑mʋ', ‑ʋ 'yɩ ‑hʋan 'yu nɩ kʋɛ, kɔ ‑ʋ ‑bɩ ‑mʋ', ‑ʋ 'yɩ ‑hʋan 'yu nɩ 'nyɛ. ");
INSERT INTO ktj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ti a 'mʋ 'yri, ‑ɛ ‑bɩ kɛ‑ ‑tonyibli di pʋ, dʋgbɩ bʋ bi 'ʋ ꞊nʋ 'lu, ʋ 'mʋ lɛ 'kʋkʋ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","'Mɔ ‑bʋ, ‑ɛ kɔ 'klɔ ꞊sii 'ʋ yɩ, ‑ɛ 'wɩ‑ tugbɛ yrayrʋ yɩ, ʋ ni lɛ, ʋ ꞊tui ꞊hɩʋɛn, 'tɩ‑ 'a mʋ ‑bʋ, ‑ʋ kɔ 'klɔ 'yɩ 'ʋ yɩ 'sii ‑nɩ, ‑ʋ 'wɩ‑ ti jɛjɩ yɩ, ‑bɩ' 'aan dɛ di ‑hʋan 'mʋ ꞊ti 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","'Sɛyo a 'mʋ, ʋ gbɛ 'crɛkɔnyibli nɩ 'hʋɛn, ʋ 'mʋ ꞊nʋ 'la, ʋ kɔ ‑Yusu 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","'Kɩ ʋ nyre 'kɩ 'ʋ ‑tuo ‑mʋ' kɩ, ‑ɛ kɔ 'nyrɛ ‑mɔ 'Lukla. ‑Tɛ ʋ nyre 'ʋ, ‑ɛ ‑bɩ 'sɛyo kɔɔ 'ʋ ‑Yusu tugbɛ 'yie. 'Kɩ 'ʋ ‑tuo nɩ ‑do a 'mʋ kɩ, 'kɩ ʋ kɔɔ 'ʋ 'crɛkɔnyibli nɩ 'hʋɛn a 'mʋ 'waa ‑nɛ ti 'yie, nyiblo nɩ ‑do, 'kɩ 'lɩ ‑Yusu a diidɛkɩbɩa kɩ, ‑do ‑bɩ, 'kɩ 'lɩ 'a kamlakɩbɩa kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","‑Yusu 'mʋ 'ʋ tugbɛ 'yie nɩ, ‑ɛ ‑bɩ kɛ‑ ɛ pɩ: «Na 'Baɩ o, dɛ 'kuku ‑bʋ, ʋ ni, ‑hru 'a ‑tɩ ‑mɔ, ‑kɔtɩ ‑tɛblɩ ‑bʋ, ʋ ni, ʋ 'yɩ꞊ɩ ‑yi.» 'Sɛyo ‑mɔ ‑bɩ, ʋ pʋ 'wla, ‑Yusu a 'hʋɩlɛpʋ‑tɛblɩ a ‑tɩ, ʋ 'mʋ꞊ʋ yi, ‑tɛ ʋ di 'a ꞊gɩgla nu. ");
INSERT INTO ktj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Hɩapʋnyibli ‑bɩ, ‑ʋ nɩ 'ʋ ‑tuo a 'mʋ kɩ, 'kɩ ʋ pʋ 'ʋ 'yie bʋ, 'ʋ yɩ ‑tɛblɩ a pɛpɛ a 'mʋ, ‑ɛ mi 'lu ‑mɔ 'ye. ‑Ɛ ‑bɩ ‑Juukʋɛ* a 'blʋ a nyibli 'cɛɛ ꞊nɛ nɩ, ʋ wɛn: «Ɛ wa nyibli ‑bɩ. 'A ‑tɩ 'kɩ o, 'bʋ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ‑a mʋ yɩ ya, bʋ wa 'a dɩɔnʋ!» ");
INSERT INTO ktj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","'Sɛyo ‑mɔ bɩ, ʋ ‑hɛ꞊ɛ 'yri lɛ ‑wɛ, 'ʋ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, 'ʋ yɩ꞊ɩ 'linɩnɔ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","‑Ɛ ‑bɩ kɛ‑ ʋ pɩ꞊ɩ yɩ: «'Bʋ mɔ, ꞊nɩ mɔ ‑Juukʋɛ a bodɩɔ, ‑ɛ ‑bɩ wa ‑dɩɔnʋ!» ");
INSERT INTO ktj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","'Kɩ 'ʋ 'a tugbɛ a 'mʋ 'yie, ʋ 'crɩɩ 'ʋ 'plaɩnkɩbɩa kɩ, ‑ɛ mɔ: «Nyiblo ‑bʋ, ɛ nɔ‑ mɔ ‑Juukʋɛ a bodɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","'Kɩ 'lɩ 'crɛkɔnyibli nɩ 'hʋɛn ‑mʋ', ʋ kɔɔ 'ʋ 'waa ti 'yie lɛ, nyiblo nɩ ‑do nɩ 'lɩ, 'ɛ ‑hɛ ‑Yusu 'yri lɛ, ɛ wɛn: «꞊Yɩ lɛ ‑pʋ, ‑ɛ mɔ, ‑mɔ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ‑a mʋ yɩ ya. Wa 'kɩ ‑dɩɔnʋ, ꞊mʋ ‑a mʋ wa ‑wɛ mɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kɛɛ, 'a 'bɩhɩan ‑bɩ ‑mʋ', ‑ɛ nɩ 'ʋ, ɛ nɔ‑ ‑tʋa 'a 'bɩ a 'mʋ, 'a ‑mɔ'pʋplɛ, ɛ wɛn: «‑Mɔ ‑bʋ, ꞊yɩ Nyɩsʋa a hʋannʋ ‑kɔ mɔ. ꞊Hɩʋɛn nɩ ‑do ‑bʋ, ‑yɩ 'ye, ɛ nɔ‑ nyɩbɛhɩan ‑bʋ, ɛ yɩ 'ye ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","‑A mʋ ‑mɔ ‑bɩ, ‑aan ꞊hɩʋɛn ‑bʋ, ‑a yɩ 'ye, ɛ kɔ 'ʋ nɩ, ‑ɛ nu꞊o, yɩnyre‑tɛblɩ ‑mʋ', ‑a nu, ɛ nʋ‑ kɔ ‑bati klɔ ‑a mʋ. Kɛɛ, ɛ nɔ‑ ‑mɔ ‑bɩ, ɛ 'yɩ dɛ ‑hʋan ꞊dʋ ‑nu.» ");
INSERT INTO ktj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","‑Tɛ ɛ ‑wɛ 'kɩ ‑tɩ a 'mʋ, 'a hɩhla ‑mɔ, ‑ɛ ‑bɩ kɛ‑ ɛ pɩ ‑Yusu yɩ, ɛ wɛn: «‑Yusu o, 'na ‑tɩ 'nɩ 'hruo 'lɩ ‑mʋ ‑mɔ, ti ‑mʋ' ‑kɔ 'yri ‑di di de, 'kɩ 'lɩ ‑na 'klɩ a kɩnɩnɩɩ 'kwli, ꞊mʋ ‑tonyibli win kɩ ‑kɔɔ ‑nɩ pɛpɛ.» ");
INSERT INTO ktj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'kɩ꞊ɩ yɩ, ɛ wɛn: «'N yɩ ‑mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, kɩkɛ ‑bʋ, ‑kɔ 'mʋ 'hʋɛn‑, 'kɩ ‑a di kɛ 'lɩ 'na 'Baɩ Nyɩsʋa a ꞊haan'dɩɔ* 'kwli nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Muu 'ʋ 'yrʋ bʋ nyra bʋ a ti 'yie, ‑ɛ ‑bɩ halɔ ka ‑tʋtʋ a pɛpɛ kɩ. Halɔ a 'mʋ, ɛ nɩ 'ʋ ‑nɩnɩ, 'ɛ yɛ 'yrʋ‑hiilɛ a ti kɩ. Ti nɩ ‑do a 'mʋ 'yri, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ ‑mʋ' bʋ, ‑ɛ nɩ 'lɩ Jrusrɛdɩɔ 'kwli, danʋ gbagbʋ ‑mʋ', ‑ɛ 'bɛ 'kayu a 'mʋ ꞊tɩɔ, 'ɛ ‑ki wlɔn pɛpɛ. ");
INSERT INTO ktj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","‑Ɛ ‑bɩ ‑Yusu 'gbo nɩ, ɛ wɛn: «'Na 'Baɩ, ‑mɔ 'n pʋ 'lɩ 'na ‑hihiu ‑jɩ'.» ‑Tɛ ɛ ‑yrɛ 'kɩ, ‑ɛ ‑bɩ ɛ mla ‑hʋnhlʋn. ");
INSERT INTO ktj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Romakʋɛ a 'sɛyo a nyiblo gbagbʋ ‑mʋ', ‑ɛ nɩ 'ʋ, ‑tɛ ɛ 'ye ‑tɛblɩ a pɛpɛ a 'mʋ, ‑ɛ mu 'lu ‑mɔ, ‑ɛ ‑bɩ ɛ ‑tʋa Nyɩsʋa a 'nyrɛlɛpʋpʋʋ, 'tɩ‑ 'ɛ pɩ win, ɛ wɛn: «Ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, nyiblo ‑bʋ, ɛ 'yɩ dɛ ‑hʋan ꞊dʋ ‑nu.» ");
INSERT INTO ktj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nyibli a pɛpɛ ‑mʋ', ‑ʋ di ‑ta 'ye mɔ, ʋ 'ye ‑tɛblɩ a 'mʋ nɩ, ‑ɛ mu 'lu ‑mɔ. 'Waa plɔ yɩ 'lɩ bʋ nɩ 'nɛɛ ‑nɩ, 'ʋ ‑mɛ kle. ");
INSERT INTO ktj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","‑Yusu a nɩnatumupʋ a pɛpɛ ‑mʋ', kɔ nʋgbɩ ‑bɩ, ‑ʋ yɩ la꞊a ꞊wien lɛ kʋɛ, ‑ʋ ‑hɔn 'lɩ Galileblʋgba 'kwli, ʋ hlɔɔ 'ʋ ‑tɛ a 'mʋ ‑mɔ lɛ dɛ gbe, 'ʋ 'ye ‑tɛblɩ a pɛpɛ a 'mʋ, ‑ɛ mu 'lu ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ɛ kɔ la nyɩbɛhɩan ꞊dʋ, 'ɛ kɔ la 'lɩ ‑Juukʋɛ a 'dɩɔ ‑bɩ 'kwli. 'A 'nyrɛ mɔ Sosɛfʋ. 'A 'dɩɔ a 'mʋ, 'a 'nyrɛ mɔ Alimate. Nyɩbɛhɩan a 'mʋ, 'a ꞊wlʋ nɔ yɩ dɩakɩ, kɔ, 'a 'klɔ 'sii 'ʋ yɩ. Ti ‑mʋ', ‑ɛ kɔ 'yri Nyɩsʋa di 'ʋ nyibli win kɩ ‑kɔɔ ‑nɩ, ɛ nɔ‑ ɛ yɩ ‑ple. Ɛ mɔ ‑Juukʋɛ* a ‑gbolugbo gbagbʋ a nyiblo ‑bɩ ꞊nɩɔ. Kɛɛ, ‑tɛblɩ ‑mʋ', 'a 'bio ‑hla, kɔ, ʋ nu ‑Yusu 'yi ꞊hlɔn lɛ, ɛ 'yɩ꞊ɩ kɩ ‑wɛn. ");
INSERT INTO ktj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Sosɛfʋ a 'mʋ, ɛ nɔ‑ mu 'lɩ Pilatɩ ‑mɔ, 'ɛ lee ꞊nɛ, 'kɩ bʋ wɛn, bʋ ‑ha 'ʋ ‑Yusu a ‑plahʋɩ tugbɛ 'yie, ɛ 'mʋ 'ʋ꞊ʋ 'ʋ ‑ha, Pilatɩ a 'mʋ, 'ɛ ‑wɛn. ");
INSERT INTO ktj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Sosɛfʋ a 'mʋ, ɛ nɔ‑ mu, 'ɛ ‑ha 'ʋ ‑Yusu a ‑plahʋɩ tugbɛ 'yie, 'ɛ 'hɩnhɩʋan꞊a ‑jisɛ lɛ, 'tɩ‑ 'ʋ gba 'lɩ꞊ɩ ‑tɩtɛ ‑mʋ', ʋ di 'ʋ꞊ʋ ꞊tuu ‑nɩ. 'Kɩ 'ʋ ‑tɛ a 'mʋ, 'hɩɔ gbagbʋ nɩ 'ʋ, 'ɛ hlɔ yra, 'ɛ 'wɩ‑ dʋgba yɩ. Ti ꞊dʋ a ti 'yri la, 'kɩ 'lɩ 'hɩɔ gbagbʋ a 'mʋ 'kwli, 'kɩ ʋ 'bluu la 'lɩ 'dabio, (‑ɛ 'wɩ‑ ‑wlukayu yɩ). 'Dabio a 'mʋ 'kwli, ʋ 'yɩ ‑hʋan 'lɩ 'kʋkʋku nɩ pɩ. Ɛ nɔ‑ kɔ 'kwli, ʋ ꞊tu 'lɩ ‑Yusu a ‑plahʋɩ. ");
INSERT INTO ktj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ɛ mɔ la 'wee a ‑nyrɔwɩ nɩ ꞊hun a 'yrʋ‑hiilɛ a ti 'yri ꞊nɩɔ, ‑Juukʋɛ a ‑wuwle‑nyrɔwɔ*, ‑ɛ mɔ 'sɛɛdɩ, 'ɛ mi la 'ʋ nyre mɔ, 'yrʋ bʋ pa a ti 'yri. ");
INSERT INTO ktj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nʋgbɩ ‑mʋ', ‑ʋ yɩ la ‑Yusu ꞊wien lɛ kʋɛ, ‑ʋ ‑hɔn la 'lɩ Galileblʋgba 'kwli, ʋ nʋ‑ kɔ Sosɛfʋ 'hʋɛn‑, ‑ʋ mu 'lɩ 'dabio yɩ, nʋgbɩ a 'mʋ, 'ʋ ta 'lɩ 'dabio a 'mʋ 'kwli lɛ, 'ʋ 'ye꞊e, ‑tɛ ‑mʋ', ʋ nu 'lɩ ‑Yusu a 'dabio a 'kwlibʋpʋpʋʋ. ");
INSERT INTO ktj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","‑Tɛ ʋ ‑gbɛɛ ‑tɛblɩ a pɛpɛ a 'mʋ, ‑ɛ ‑bɩ ʋ ‑mɛ kle, 'ʋ 'ya 'dɩɔ, 'ʋ ‑wɛ hɩnhrʋnpʋ‑tɛblɩ ‑mɔ, kɔ ‑dawinninyra 'hʋɛn‑, ʋ 'mʋ꞊ʋ ‑Yusu a 'hʋɩ lɛ plʋ. ‑Tɛ ‑wuwle‑nyrɔwɔ nyre 'ʋ, ‑ɛ ‑bɩ ʋ ‑wle nɩ, ꞊wɩ yɩ, ‑tɛ Nyɩsʋa a tete ni 'a hɩhla. ");
INSERT INTO ktj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","‑Tɛ ‑wuwle‑nyrɔwɔ* ‑hi, 'sɔɔndɩ a ‑nyragblɩ, ‑ɛ ‑bɩ nʋgbɩ a 'mʋ, ʋ 'du ye', ‑dawinninyra ‑mʋ', ʋ ‑wɛ la ‑mɔ, 'ʋ gba 'lɩ꞊ɩ ‑Yusu a 'dabio yɩ. ");
INSERT INTO ktj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","‑Tɛ ʋ nyre 'lɩ, ‑ɛ ‑bɩ ʋ 'ye꞊e nɩ, ‑ɛ mɔ, kʋanɩhɩɔ ‑mʋ', nyibli nu la, 'ʋ ka la 'dabio yɩ, ʋ blike꞊e lɛ, 'ʋ ‑ha 'ʋ꞊ʋ 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ɛ nɔ‑ mɔ bʋ pa 'lɩ 'dabio a 'mʋ 'kwli, kɛɛ, ʋ 'yɩ 'lɩ Kʋkɔnyɔ ‑Yusu a ‑plahʋɩ bʋ ‑yɛɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","'Waa ꞊wlɩ kɛɛ lɛ, ‑tɛ ʋ 'yɩ 'lɩ꞊ɩ 'dabio 'kwli bʋ ‑yɛɛ ‑nɩ. 'A ‑tɩ, dɛ bʋ di 'lu ‑mɔ lɛ ‑hie, ʋ 'yɩ꞊ɩ ‑yi. 'Kɩ ʋ nɩ 'kɩ 'ʋ bʋ, ‑ɛ ‑bɩ nyɩbɛpʋ nɩ 'hʋɛn ꞊dʋ, nʋ‑ 'hrɩɩ 'ʋ ꞊nʋ 'hʋɩ. Nyɩbɛpʋ nɩ 'hʋɛn a 'mʋ, ʋ pʋ wlawlɩ pʋɔpʋɩ, 'ɛ yɩ wlɩn. Nyɩsʋa a lɛlenyʋ ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","‑Tɛ ʋ 'ye nyibli nɩ 'hʋɛn a 'mʋ, ‑ɛ ‑bɩ hʋannʋ bi 'lɩ ꞊nʋ 'kwli, 'ʋ pʋ 'li ‑wlu lɛ. ‑Ɛ ‑bɩ kɛ‑ nyibli nɩ 'hʋɛn a 'mʋ, ʋ pɩ ꞊nʋ yɩ: «A 'nɩ 'mʋɔ 'nɛ꞊ɛ 'kʋkʋnyibli 'nyɩ lɛ. Ɛ nɩ 'klɔ. ");
INSERT INTO ktj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ɛ 'yɩ 'nɛ‑ ‑nɩ. Nyɩsʋa ‑ha 'lɩ꞊ɩ 'kʋkʋnyibli 'nyɩ nɩ, 'ɛ ‑ha꞊a 'klɔ. ‑Tɛ ɛ 'tɩɛ nɩ la 'lɩ Galileblʋgba 'kwli, ‑tɩ ‑bʋ, ɛ lee la 'a mʋ, bʋ bi 'lɩ 'a mʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Kɛ‑ ɛ pɩ la 'a mʋ yɩ: Ʋ kɔ bʋ pʋ ‑tonyibli a pɛpɛ a Nyiblo 'crɛkɔnyibli ‑jɩ', ʋ 'mʋ 'ʋ꞊ʋ tugbɛ 'yie ‑kɔɔ ‑nɩ, ɛ 'mʋ 'kʋ. 'Tɩ‑ 'bʋ 'kʋ, ‑nyrɔwɩ nɩ 'hʋɛn, ta a ‑nyrɔwɔ, ɛ kɔ bʋ ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ, bʋ 'hrɩ 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","‑Tɛ ʋ 'wɩn 'kɩ ‑tɩ a 'mʋ, ‑ɛ ‑bɩ ‑tɩ ‑mʋ', ‑Yusu lee la ꞊nʋ, ɛ bi 'lɩ ꞊nʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","‑Tɛ ɛ bi 'lɩ ꞊nʋ 'kwli, ‑ɛ ‑bɩ ʋ ꞊hɩan ‑mɔ, 'ʋ mu 'lɩ ‑Yusu a ‑nagbopʋ* nɩ ‑pu ꞊tu 'ʋ ‑do ‑mʋ' ‑mɔ, ɛ kɔ nyibli a pɛpɛ ‑bɩ ‑mʋ', ‑ʋ nɛ la ‑Yusu ‑mɔ ‑wɛ, ‑tɛblɩ a pɛpɛ a 'mʋ, ‑ɛ mu 'lu ‑mɔ, 'ʋ na꞊a ‑mɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nʋgbɩ a 'mʋ, ‑ʋ nɛ ‑tɛblɩ a 'mʋ ‑mɔ lɛ, 'waa 'nyrɛ mɔ Madala a Mari, kɔ Sanɩ, kɔ Mari ‑bɩ, ‑ɛ mɔ Sakɩ a 'dii. Nʋgbɩ ‑bɩ ‑mʋ', ‑ʋ kɔ ꞊nʋ 'hʋɛn, ‑ʋ mu 'lɩ 'dabio yɩ, ‑tɛblɩ nɩ ‑do a 'mʋ, ɛ nɔ‑ ʋ na ‑mɔ lɛ ‑wɛ, 'kɩ 'ʋ ‑Yusu a ‑mɔnanyʋ* ye'. ");
INSERT INTO ktj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kɛɛ, ‑Yusu a ‑mɔnanyʋ a 'mʋ, 'kɩ 'lɩ 'waa 'lulɛ‑hihie 'kwli, ʋ yɩ꞊ɩ 'nɩ 'ye, ‑ɛ mɔ, ‑tɩ a 'mʋ, nʋgbɩ a 'mʋ, ʋ na ‑mɔ lɛ, ɛ 'yɩ 'lukɔ‑moko ‑kɔ, ʋ 'nɩ ‑pʋ꞊ʋ lɩ꞊ɩ ꞊haan‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ɛ nɔ‑ mɔ Piɛlɩ bʋ 'du ye', bʋ gba 'lɩ 'dabio cigbɛ yɩ. ‑Tɛ ɛ nyre 'ʋ, ‑ɛ ‑bɩ ɛ ꞊tɩ 'ʋ nɩ, 'ɛ ta 'lɩ꞊ɩ 'kwli lɛ, 'ɛ 'yɩ 'lɩ ꞊dedede 'lɩ 'ye, 'bʋ 'yɩ ‑jisɛi nɩ ‑do ‑mʋ', ʋ 'hɩnhɩan la꞊a lɛ 'pa‑. ‑Ɛ ‑bɩ ɛ ꞊hɩan ‑mɔ, 'ɛ mu 'lɩ 'kayu bʋ. 'A 'mumu, 'a ꞊wlʋ kɛɛ lɛ dɩakɩ, 'kɩ 'ʋ ‑tɛblɩ a 'mʋ, ‑ɛ mu 'lu ‑mɔ a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","‑Nyrɔwɔ nɩ ‑do a 'mʋ 'kwli, ‑Yusu a ‑nagbopʋ* nɩ 'hʋɛn ‑bɩ, nʋ‑ ‑hɔn 'lɩ Jrusrɛdɩɔ 'kwli, 'ʋ mi 'lɩ Emausɩdɩɔ 'kwli. ‑Hɔn 'lɩ Jrusrɛdɩɔ 'kwli, ‑bʋ mu 'lɩ Emausɩ, ɛ ‑wɛ 'lɩ ‑kilowɩ nɩ ‑pu ꞊tu 'ʋ ‑do nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","‑Tɛ ʋ nɩ 'hru wlɔn, ‑tɛblɩ a pɛpɛ ‑mʋ', ‑ɛ mu 'lu ‑mɔ, ɛ nɔ‑ kɔ ‑tɩ ʋ nɛ ‑mɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bʋ nɩ 'lɩ ‑tɩ a 'mʋ, 'a lɛpʋpʋlɛ 'kwli, ‑ɛ ‑bɩ ‑Yusu 'hrɩɩ 'ʋ ꞊nʋ 'hʋɩ, ɛ kɔ ꞊nʋ 'hʋɛn, 'ʋ ‑mu. ");
INSERT INTO ktj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kɛɛ, ɛ 'wɩ‑ ‑tɛ dɛ 'yɛ nɩ kaa nyibli a 'yii kɩ. Ɛ nɔ‑ kɔ ‑tɩ, 'ʋ 'yɛ nɩ yru꞊o. ");
INSERT INTO ktj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","‑Ɛ ‑bɩ ‑Yusu 'bɛti ꞊nʋ nɩ, ɛ wɛn: «‑Tɩ a 'dɩ ‑bɩ a pɩpɩ' lɛ 'lɩ?» ‑Tɛ ɛ 'bɛti ‑tɩ a 'mʋ, ‑ɛ ‑bɩ 'a ‑nagbopʋ nɩ 'hʋɛn a 'mʋ, ʋ nyra bʋ, ‑ɛ nu꞊o, 'waa ꞊wlɩ 'mʋɛ bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ti nɩ ‑do a ti 'yri, nyiblo ‑mʋ', ‑ɛ mɔ Klopasɩ, ɛ ꞊tu꞊o ꞊wɔn, ɛ wɛn: «'N pʋ꞊ʋ ꞊haan‑tɩ, 'kɩ 'lɩ Jrusrɛ a nyibli a pɛpɛ 'nyɩ, ‑mɔ nɩ ‑do, ‑mɔ 'yɩ dɛ ‑bʋ, ‑ɛ mu 'lu ‑mɔ a ‑tɩ 'wɩn.» ");
INSERT INTO ktj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","‑Ɛ ‑bɩ ɛ wɛn: «‑Tɩ a 'dɩ ‑bɩ 'lɩ?» ‑Ɛ ‑bɩ ‑nagbopi a 'mʋ, ɛ wɛn: «‑Tɩ ‑mʋ', ‑ɛ mu 'lu ‑mɔ, 'kɩ 'ʋ Nasalɛtɩ a ‑Yusu ‑mɔ. Ɛ mɔ Nyɩsʋa winwlɔn‑hanyɔ* ꞊nɩɔ. 'Kɩ 'ʋ Nyɩsʋa kɔ ‑tonyibli 'hʋɛn‑ ‑gbati, 'a ꞊wlɩlɛkɛɛ‑tɛblɩ, ɛ ni la, ɛ kɔ 'a tɔɔwin 'hʋɛn‑, ʋ tʋɛ la꞊a ‑a mʋ nɩ, ‑ɛ mɔ, ɛ nɩ la 'klɩ kɩ dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kɛɛ, Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ, ʋ kɔ ‑aan naanyʋ gbagbɩ 'hʋɛn‑, ʋ nʋ‑ pʋ꞊ʋ Romakʋɛ a 'kɩɩnpʋ ‑jɩ', 'ʋ pʋʋ ꞊nɛ ‑bati lɛ. 'Ɛ mɔ ꞊han‑tɩ, ‑tɛ ʋ pʋʋ ꞊nɛ ‑bati lɛ, 'ʋ kɔɔ 'ʋ꞊ʋ tugbɛ 'yie, 'ɛ 'kʋ. ");
INSERT INTO ktj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","‑A mʋ ‑mɔ ‑bɩ, ‑a kuo ꞊nɛ ꞊wlʋ yɩ, ‑ɛ mɔ, ɛ nɔ‑ mɔ ‑aan ‑nɛ Wanyɔ ‑mʋ', Nyɩsʋa ya la, ‑ɛ di Yisraɛkʋɛ ꞊gblɛ, 'kɩ 'lɩ Romakʋɛ ‑jɩ'. ‑Tɛ ‑tɛblɩ a pɛpɛ a 'mʋ, ɛ mu 'lu ‑mɔ, 'a ‑nyrɔwɩ nɩ ta a ‑nyrɔwɔ ‑bʋ. ");
INSERT INTO ktj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ɛ mɔ ꞊han‑tɩ, nʋgbɩ ‑bɩ 'kɩ 'nɛ‑ ‑a mʋ 'nyɩ, ‑tɩ ‑bʋ, ʋ ‑hla, ɛ kɛɛ nɛ ‑aan ꞊wlɩ lɛ. ‑Nyragblɩ, nʋgbɩ a 'mʋ, nʋ‑ ‑tuo 'lɩ 'dabio yɩ, ");
INSERT INTO ktj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kɛɛ, ‑tɛ ʋ ‑mu, ʋ 'yɩ 'lɩ ‑Yusu a ‑plahʋɩ bʋ ‑yɛɛ ‑nɩ, 'ʋ di ‑a mʋ lee mɔ, ‑ɛ mɔ, Nyɩsʋa a lɛlenyʋ 'hrɩɩ ꞊nʋ yɩ, 'ʋ lee ꞊nʋ, ‑ɛ mɔ, ‑Yusu ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ nɩ, 'ɛ 'hrɩ 'klɔ. ");
INSERT INTO ktj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ɛ kɔ nyibli ‑bɩ, 'kɩ 'nɛ‑ ‑a mʋ 'nyɩ, ‑tɛ ʋ 'wɩn ‑tɩ a 'mʋ, ɛ nɔ‑ mɔ bʋ mu 'lɩ 'dabio a 'mʋ yɩ. 'Ɛ mɔ ꞊han‑tɩ, ‑tɛ nʋgbɩ a 'mʋ, ʋ nu 'a hɩhla, kɛ‑ ɛ nu naalɛ, kɛɛ, ʋ 'yɩ 'lɩ ‑Yusu a 'mʋ bʋ ‑yɛɛ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ, ɛ wɛn: «'Hʋʋ‑, a 'yɩ 'lulɛ‑hihie ‑kɔ. ‑Tɩ a pɛpɛ ‑mʋ', Nyɩsʋa a winwlɔn‑hanyɔ hla la, ti ‑hi la ti 'yri, 'aan ꞊wlɩ 'nɩ ‑klɔ꞊ɔ lɩ꞊ɩ 'wʋwlɩ, kɔ, 'a 'yɩ꞊ɩ ꞊wlʋ yɩ ‑kuo ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Winwlɔn‑hanyʋ a 'mʋ, ʋ hla la꞊a nɩ, ‑ɛ mɔ, Wanyɔ a 'mʋ, Nyɩsʋa pʋ la lɛ, ɛ di la ya, ɛ blɛɛ yɩ bʋ 'ye ꞊hɩʋɛn, 'tɩ‑ Nyɩsʋa 'mʋ꞊ʋ ‑tɩ a 'yi'bʋbʋa ‑nyi.» ");
INSERT INTO ktj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","‑Tɛblɩ a pɛpɛ ‑mʋ', ʋ 'crɩɩ la, 'kɩ 'ʋ꞊ʋ kɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ɛ ‑hɩhɩa ꞊nʋ klɛ, 'kʋɛ 'lɩ Moise a 'crɩɛn 'kwli bʋ, ‑bʋ yɛ Nyɩsʋa a winwlɔn‑hanyʋ ‑bɩ a 'crɩɩn kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","‑Tɛ ʋ mi 'lɩ Emausɩdɩɔ 'kwli nyre mɔ, ‑ɛ ‑bɩ ‑Yusu ‑hʋɛ꞊ɛ nɩ, bʋ gba 'a 'hru 'lu ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kɛɛ, ʋ nyɛɛ ꞊nɛ lɛ, ʋ wɛn: «Pɛɛ mɔ ‑a mʋ 'hʋɩ, 'tɔ yɩ 'nɩ ‑wɔn,» ɛ kɔ ꞊nʋ 'hʋɛn‑, 'ʋ 'ya 'dɩɔ, 'ɛ pa 'lɩ ꞊nʋ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","‑Tɛ ʋ ‑pa, ‑ɛ ‑bɩ ʋ nɩ blɛ, dididɛ a ‑tɩ. Bʋ nɩ 'ʋ dɛdi‑tuo kɩ, ‑ɛ ‑bɩ ɛ 'du 'flɔɔ ye', 'ɛ ‑nyi Nyɩsʋa 'wio, 'tɩ‑ 'ɛ 'bɛ꞊ɛ ꞊tɩɔ lɛ, 'ɛ ‑nyi ꞊nʋ꞊ʋ. ");
INSERT INTO ktj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","‑Tɛ ɛ ‑nyi 'kɩ ꞊nʋ꞊ʋ, ‑ɛ ‑bɩ ʋ ‑tʋa 'a yuyruo. Kɛɛ, ti a 'mʋ 'yri, ‑ɛ ‑bɩ ɛ 'waan ꞊nʋ 'yi kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kɛ‑ ʋ pɩpɩ yrɛ, ʋ wɛn: «Ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, ‑tɛ ɛ ‑hɩhɩɛ wɛn ‑a mʋ Nyɩsʋacrɩɛn klɛ, dɔdʋ nɩ wɛn 'lɩ ‑aan ꞊wlɩ kɩ dɩakɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","‑Ɛ ‑bɩ ti nɩ ‑do a ti 'yri, ʋ 'du ye', 'ʋ bi 'hru wlɔn de, 'ʋ mu 'lɩ Jrusrɛdɩɔ 'kwli. 'Kɩ ʋ yɛɛ 'ʋ ‑Yusu a ‑nagbopʋ nɩ ‑pu ꞊tu 'ʋ ‑do ‑mʋ' bʋ, ʋ kɔ 'waa 'bio 'hʋɛn‑. Nyibli a 'mʋ, ʋ 'kukue lɛ, 'kɩ 'lɩ 'kayu nɩ ‑do bʋ, ");
INSERT INTO ktj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","'ʋ lee nyibli nɩ 'hʋɛn ‑mʋ', ‑ʋ ‑di, ʋ wɛn: «Ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, ‑aan Kʋkɔnyɔ ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ nɩ, 'ɛ 'hrɩɩ Simɔ Piɛlɩ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ʋ nɩ 'hʋɛn a 'mʋ, dɛ ‑mʋ', ‑ɛ mu 'lu ‑mɔ, 'kɩ 'lɩ 'hru wlɔn, ʋ 'ye, ɛ nɔ‑ ʋ na ‑mɔ lɛ, ɛ kɔ ‑tɛ ʋ nu 'a yuyruo, ti ‑mʋ' ‑kɔ 'yri ɛ yɩ 'ʋ 'flɔɔ ꞊tɩɔ lɛ 'bɛɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bʋ nɩ 'lɩ ‑tɩ a 'mʋ a hɩhla 'kwli, ‑ɛ ‑bɩ 'kɩ ‑Yusu 'hrɩɩ 'lɩ ꞊nʋ 'nyɩ, 'ɛ pʋ 'waa 'wio bʋ, ɛ wɛn: «Nyɩsʋa bʋ nɩ 'ʋ 'a mʋ ‑mɔ!» ");
INSERT INTO ktj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","‑Tɛ ʋ 'ye꞊e, ‑ɛ ‑bɩ hʋannʋ bi 'lɩ ꞊nʋ 'kwli. Ʋ nʋ‑ ‑mɔ ‑bɩ, ʋ daa ꞊nɛ, 'ku ꞊hrɩɩ 'lɩ ꞊nʋ 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","‑Ɛ ‑bɩ ɛ wɛn: «Dɛ a 'dɩ ‑bɩ ‑kɔ hʋannʋ a yɩ 'kɩ pie 'lɩ? Dɛ‑ kɔ ‑tɩ 'a 'yɛ nɩ pʋ꞊ʋ ꞊haan‑tɩ, ‑ɛ mɔ, 'mɔ ꞊nɩɔ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ba 'ye 'na dabʋɩ a 'kwli kɔ 'na bʋɩ. 'Mɔ ‑Yusu ꞊nɩɔ. Ba 'ye 'mʋ, 'n kɔ 'hʋɩ, 'n 'yɩ 'ku 'pa‑. 'Ku 'yɩ 'hʋɩ ‑kɔ, 'ɛ 'yɩ 'kla ‑kɔ. 'Bɩ 'aan 'mumu a 'mʋ, a yɩ꞊ɩ 'nɩ 'ye, ‑ɛ mɔ, 'n kɔ 'hʋɩ.» ");
INSERT INTO ktj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","‑Tɛ ɛ ‑wɛ ‑tɩ a 'mʋ a hɩhla ‑mɔ, ‑ɛ ‑bɩ ɛ tɔɔ ꞊nʋ 'a dabʋɩ kɔ 'a bʋɩ 'hʋɛn‑ yɩ, (ʋ 'mʋ ŋmaŋmɩ a 'hʋɛ 'ye, 'sɛyo ‑nu, 'ʋ kɔɔ 'ʋ꞊ʋ tugbɛ 'yie.) ");
INSERT INTO ktj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Dɔdʋ yɩ wɛn ꞊nʋ nɩ ni, 'waa ꞊wlɩ 'ɛ yɩ lɛ ‑kɛɛ ‑nɩ. Ɛ nɔ‑ nu꞊o, 'ʋ 'tɩɛ 'yɛ꞊ɛ ꞊wlʋ yɩ nɩ ‑kue ‑nɩ, ‑ɛ mɔ, ɛ 'hrɩ 'klɔ. Ɛ nɔ‑ kɔ ‑tɩ 'ɛ lee ꞊nʋ: «'Bʋ mɔ, 'ba kɔ 'nɛ‑ dididɛ ꞊dʋ, ba ‑nyi 'mɔ꞊ɔ, 'mʋ꞊ʋ di!» ");
INSERT INTO ktj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","'ʋ ‑ha 'lɩ 'tɔpʋ‑hrin.yɛ a 'kʋtɩɔ, 'ʋ ‑nyi ꞊nɛ꞊ɛ, ");
INSERT INTO ktj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","'ɛ klɔ꞊ɔ bʋ, 'ɛ di꞊e, 'kɩ 'ʋ ꞊nʋ ye'. ");
INSERT INTO ktj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «‑Tɛ 'n 'tɩɛ nɩ la 'nɛ‑ 'a mʋ 'nyɩ, ‑tɩ ‑bʋ, 'n lee la 'a mʋ, bʋ bi 'lɩ 'a mʋ 'kwli. Kɛ‑ 'n pʋ la 'a mʋ yɩ: ‑Tɛblɩ a pɛpɛ ‑mʋ', ʋ na la ‑mɔ lɛ, 'kɩ 'ʋ 'mʋ kɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ɛ kɔ bʋ nue ‑nɩ. Ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, ɛ nue nɩ. ‑Tɛblɩ a 'mʋ, 'kɩ 'a dɛ ‑bɩ nɩ 'lɩ Moise a tetecrɩɛn 'kwli, 'a dɛ ‑bɩ 'ɛ nɩ 'lɩ winwlɔn‑hanyʋ* ‑bɩ a 'crɩɩn 'kwli, 'a dɛ ‑bɩ 'ɛ nɩ 'lɩ ‑wlablecrɩɛn* 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ɛ nu꞊o nɩ, 'ʋ yru Nyɩsʋa a ‑tɩ a 'mʋ lɛ, ‑ɛ nɩ 'lɩ Nyɩsʋacrɩɛn 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","‑Ɛ ‑bɩ ɛ wɛn: «Kɛ‑ Nyɩsʋa a win pɩ: Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la 'a dakɔ yɩ ya, ɛ kɔ bʋ 'ye ꞊hɩʋɛn, kɔ, ɛ kɔ bʋ 'kʋ. 'Bʋ 'kʋ, ‑nyrɔwɩ nɩ ta a ‑nyrɔwɔ, ɛ kɔ bʋ ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ, bʋ 'hrɩ 'klɔ. ");
INSERT INTO ktj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Wanyɔ a 'mʋ, ɛ nɔ‑ kɔ 'nyrɛ 'kwli, a di 'lɩ Nyɩsʋa a ‑tɩ ‑mɔ lɛ ‑naa ‑nɩ. Nyɩsʋa a ‑tɩ a 'mʋ, a di nyibli ‑lee ‑nɩ, ɛ nɔ‑ ‑bʋ: Bʋ hie 'ʋ 'waa dɛ 'kuku bʋ, bʋ ‑nyi 'waa 'klɔ a pɛpɛ Nyɩsʋa, ‑ɛ di꞊e nu, ɛ 'mʋ 'waa dɛ 'kuku 'wʋwla ‑nɩ. 'Bʋ mɔ, 'ba yɩ Nyɩsʋa a ‑tɩ a 'mʋ ‑mɔ lɛ nɩ nɛ, 'kɩ ba kʋɛ 'nɛ‑ Jrusrɛdɩɔ 'kwli bʋ, kɔ, ba na ‑tɩ a 'mʋ ‑mɔ lɛ, 'kɩ 'ʋ dakɔ a pɛpɛ yɩ, ‑ʋ nɩ 'nɛ‑ 'klɔ kɩ. ");
INSERT INTO ktj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","'Bɩ ‑tɛblɩ a pɛpɛ ‑mʋ', ‑ɛ muu la 'lu ‑mɔ, a 'ye꞊e nɩ. 'A ‑tɩ, ba mu, ba na 'na ‑tɩ ‑mɔ lɛ, 'kɩ 'ʋ nyibli a pɛpɛ yɩ. ");
INSERT INTO ktj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","'Na 'Baɩ Nyɩsʋa pʋ la 'lɩ꞊ɩ nɩ, ‑ɛ mɔ, ɛ di ‑nyi la 'a mʋ 'a ‑Hihiu. 'Na ꞊gbɛtʋ, 'mɔ di 'a mʋ ‑Hihiu* a 'mʋ yɩ ya. 'A ‑tɩ, 'kɩ ba nɩ 'nɛ‑ 'dɩɔ ‑bʋ 'kwli bʋ, ‑Hihiu a 'mʋ, ɛ 'mʋ 'lɩ yɔ' ‑hɔn, ɛ 'mʋ 'ʋ 'a mʋ ke' bi, ɛ 'mʋ 'a mʋ 'klɩ ‑nyi.» ");
INSERT INTO ktj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu gba 'a ‑nagbopʋ* nɩ, 'ʋ ꞊tɩ Jrusrɛdɩɔ 'kwli, 'ʋ mu 'lɩ 'dɩɔ ‑mʋ', ʋ dɛɛ Betani ꞊hlɔn. ‑Tɛ ʋ nyre 'ʋ 'hru a 'mʋ, 'a ‑hɛyri', ‑ɛ ‑bɩ ɛ 'du dabʋɩ ye', 'ɛ pʋ ꞊nʋ wa ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ɛ nɩ 'lɩ win a pʋpʋʋ 'kwli, Nyɩsʋa 'ɛ nu꞊o, ‑Yusu 'ɛ ‑hɔn 'lɩ ꞊nʋ 'nyɩ, 'ɛ mu 'lɩ yakɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","'A ‑nagbopʋ ‑mɔ ‑bɩ, ʋ 'gbla kwlɩ, 'kɩ 'ʋ 'a ‑tɩ a 'yi'bʋalɛ a ‑ta'. ‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ʋ ꞊hɩan ‑mɔ, 'ʋ mu 'lɩ Jrusrɛdɩɔ 'kwli, 'kɩ 'lɩ dɔdʋke 'kwli. ");
INSERT INTO ktj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","'Kɩ 'lɩ Jrusrɛdɩɔ a 'mʋ 'kwli, ʋ 'cibi 'lɩ Nyɩsʋa a 'kagbaʋ bʋ nɩ, 'ʋ pɩ Nyɩsʋa 'nyrɛ lɛ.");
INSERT INTO ktj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Yɩ‑hɛ‑nyrɛ, 'tɩ‑ Nyɩsʋa 'mʋ la 'a ‑nɛ ꞊dedede nu mɔ mu, nyiblo ‑mʋ', ‑ɛ mɔ Nyɩsʋa a Win, ɛ nɩ la 'klɔ. 'Kɩ ɛ nɩ la 'ʋ Nyɩsʋa 'hʋɩ. 'A 'mumu, ɛ mɔ Nyɩsʋa ꞊nɩɔ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ɛ nɔ‑ Nyɩsʋa naa 'lɩ, 'ɛ nu 'a ‑nɛ dɛ. Ɛ 'yɩ ꞊dedede ‑kɔ, Nyɩsʋa bʋ nu, bʋ 'yɩ 'lɩ ‑Yusu 'lɩ ‑naa ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nyiblo a 'mʋ, ɛ nɔ‑ yɩ nyibli 'klɔ yrayrʋ ‑nyi, ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ. 'Klɔ yrayrʋ a 'mʋ, ɛ nɔ‑ yɩ nyibli ‑nyrɛ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","‑Nyrɛ a 'mʋ, ɛ yɩ 'nɩ wlɩn, 'kɩ 'lɩ halɔ 'nyɩ, halɔ 'yɩ 'klɩ ꞊dʋ ‑kɔ, 'kɩ bʋ jrɔ ‑nyrɛ a 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ɛ kɔ la nyiblo ꞊dʋ, ‑ɛ kɔ 'nyrɛ ‑mɔ Saan Batisɩ. Nɔ‑ Nyɩsʋa lee la ‑nɩ, ");
INSERT INTO ktj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","'kɩ bʋ lee ‑nyrɛ a 'mʋ a ‑tɩ nyibli lɛ, nyibli a 'mʋ, ʋ 'mʋ Nyɩsʋa a Win ꞊wlʋ yɩ ‑kuo ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Saan a 'mʋ, ɛ 'yɩ la ‑nyrɛ a 'mʋ 'pa‑, kɛɛ, ɛ nɔ‑ ‑mɔ ‑bɩ, ɛ di la nɩ, 'kɩ ɛ 'mʋ la ‑nyrɛ a 'mʋ 'a ‑tɩ ‑mɔ lɛ na. ");
INSERT INTO ktj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","‑Nyrɛ a 'mʋ, ɛ nɔ‑ mɔ sɛyɩ a ‑nyrɛ, ‑ɛ di 'nɛ‑ 'klɔ 'kwli, ‑ɛ di꞊e nu, nyibli a pɛpɛ 'mʋ lɛ yru. ");
INSERT INTO ktj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nyiblo a 'mʋ, ‑ɛ mɔ Nyɩsʋa a Win, ɛ mɔ ꞊han‑tɩ, ɛ nɔ‑ kɔ 'mʋ Nyɩsʋa naa 'lɩ, 'ɛ nu 'klɔ. Kɛɛ, ‑tɛ ɛ di la 'nɛ‑ 'klɔ 'kwli, 'klɔ 'kwli a nyibli 'yɩ la꞊a ‑yru. ");
INSERT INTO ktj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ɛ di la 'nɛ‑, 'a dɩɔnʋ a dakɔ, ‑ʋ mɔ ‑Juukʋɛ* 'nyɩ, kɛɛ, ʋ 'yɩ la꞊a kʋa 'ble. ");
INSERT INTO ktj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kɛɛ, 'kɩ 'lɩ ꞊nʋ 'nyɩ, ɛ kɔ nyibli ‑bɩ, 'ʋ 'ble꞊e kʋa, 'tɩ‑ 'ʋ kuo ꞊nɛ ꞊wlʋ yɩ. Nyibli a 'mʋ, ‑ʋ kuo ꞊nɛ ꞊wlʋ yɩ, ɛ ‑nyi ꞊nʋ 'hru, 'kɩ bʋ ‑hɛ Nyɩsʋa a 'yonʋ. ");
INSERT INTO ktj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ʋ 'yɩ Nyɩsʋa a 'yonʋ ‑hɛ, ꞊wɩ yɩ, ‑tɛ ‑tonyiblo ni, 'ɛ yɩ 'a 'baɩ a 'yu ‑hɛ. Kɛɛ, Nyɩsʋa a ꞊gbɛtʋ, nɔ‑ ‑nyi ꞊nʋ 'klɔ yrayrʋ. ");
INSERT INTO ktj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nyiblo a 'mʋ, ‑ɛ mɔ Nyɩsʋa a Win, ɛ ‑hɛ ‑tonyiblo, 'ɛ 'ti la 'nɛ‑ ‑a mʋ 'nyɩ, ꞊a 'ye 'a ‑tɩ a 'yi'bʋbʋa, ‑ɛ mɔ ‑tɩ a 'yi'bʋbʋa ‑mʋ', Nyɩsʋa ‑nyi 'a 'Yu nɩ ‑do. Nʋɛlɛ, kɔ nyaɩ a yuyruo, kɔ ‑tɩ a ‑tɛɛ, nʋ‑ 'yii la 'lɩ꞊ɩ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nyiblo a 'mʋ, ɛ nɔ‑ kɔ ‑tɩ Saan hla la, 'kɩ 'ʋ nyibli ye'. Kɛ‑ ɛ pɩ la: «Ɛ nɔ‑ di 'ʋ 'mʋ ke' kʋɛ, kɛɛ, ɛ nɔ‑ nɩ 'ʋ 'mʋ 'lu yɩ, ‑ɛ nu꞊o, ɛ nɔ‑ ‑mɔ ‑bɩ, ʋ 'yɛ la 'mʋ nɩ kʋɛ, 'ɛ nɩ la 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nyiblo a 'mʋ, ɛ 'cibi 'ʋ, 'ɛ ni ‑a mʋ ꞊haan‑tɛblɩ ‑mɔ, 'kɩ 'lɩ dadʋke 'kwli. ꞊Haan‑tɛblɩ, ɛ nu ‑a mʋ 'yi ꞊hlɔn lɛ, ɛ ‑hʋ nɩ dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nyiblo a 'mʋ, ɛ nɔ‑ mɔ ‑Yusu 'Klɩsʋ. 'Kɩ Nyɩsʋa naa 'lɩ 'a winwlɔn‑hanyɔ* Moise 'mʋ, 'ɛ ‑nyi ‑a mʋ 'a tete, kɛɛ, 'kɩ 'lɩ ‑Yusu 'Klɩsʋ 'lɩ, 'kɩ ɛ naa 'lɩ, 'ɛ nu ‑a mʋ ꞊haandɛ ‑mɔ, 'kɩ 'lɩ dadʋke 'kwli, 'ɛ tɔɔ nɛ ‑a mʋ ‑tɩ a ‑tɛɛ. ");
INSERT INTO ktj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nyiblo ꞊dʋ 'yɩ ‑hʋan Nyɩsʋa nɩ 'ye. Kɛɛ, a 'Yu nɩ ‑do ‑mʋ', ‑ɛ mɔ Nyɩsʋa ‑wɛ, 'tɩ‑ ‑ɛ nɩ 'ʋ ‑aan 'Baɩ Nyɩsʋa 'hʋɩ, ɛ nɔ‑ tɔɔ nɛ ‑a mʋ Nyɩsʋa a 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","‑Nyrɔwɔ ꞊dʋ 'kwli, ‑Juukʋɛ* a 'blʋ a nyibli ‑mʋ', ‑ʋ nɩ 'lɩ Jrusrɛdɩɔ 'kwli, nʋ‑ le Nyɩsʋa a ‑cɔhlʋnpinyʋ*, kɔ Lefipʋ a ꞊tugba a nyibli, 'kɩ bʋ mu 'lɩ Betanidɩɔ 'kwli, bʋ 'bɛti Saan, nyiblo a 'dɩ ‑bɩ ɛ pa 'mʋ. ‑Tɛ ʋ nyre 'lɩ Saan ‑mɔ, ʋ wɛn: «꞊Bɩ ‑mɔ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya?» ");
INSERT INTO ktj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ɛ nɔ‑ mɔ bʋ ‑hɩhɩa ꞊nʋ klɛ, 'kɩ 'lɩ ‑tɛɛke 'kwli, ɛ wɛn: «'Ʋʋn‑, 'n 'yɩ Wanyɔ a 'mʋ 'pa‑, ‑kɔtɩ a hlɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kɛ‑ ʋ pɩ de, ʋ wɛn: «꞊Bɩ ‑mɔ mɔ Nyɩsʋa a winwlɔn‑hanyɔ Eli?» Ɛ wɛn: «'Ʋʋn‑, 'n 'yɩ Eli 'pa‑.» ‑Ɛ ‑bɩ ʋ 'bɛti꞊e nɩ de, ʋ wɛn: «'A ‑tɩ, ꞊bɩ ‑mɔ mɔ Nyɩsʋa a winwlɔn‑hanyɔ gbagbʋ ‑mʋ', Moise pʋ la lɛ, Nyɩsʋa di la ya?» Ɛ wɛn: «'Ʋʋn‑, 'n 'yɩ winwlɔn‑hanyɔ a 'mʋ 'pa‑.» ");
INSERT INTO ktj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ʋ 'tɩɛ gbɛ 'a lɛ'bɛtilɛ 'lu ‑mɔ: «Nyiblo a 'dɩ ‑bɩ ‑pa 'mʋ 'lɩ? ‑Hɩhɩa ‑a mʋ klɛ, ‑ɛ di꞊e nu, nyibli ‑bʋ, ‑ʋ lee 'nɛ‑ ‑a mʋ, ‑a 'mʋ 'waa klɛ‑hɩhɩalɛ yi.» ");
INSERT INTO ktj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «Nyɩsʋa a winwlɔn‑hanyɔ Esai 'crɩ la꞊a nɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ: Nyɩsʋa wɛn 'nɩ: Ɛ di kɔ nyiblo ꞊dʋ, ɛ 'mʋ 'lɩ ‑tɩtɛ ‑mʋ' 'dʋ bi 'lɩ yɩ 'ti. 'Bʋ yɩ nɩ hle, ɛ 'mʋ 'lɩ win 'lɩ 'yaa ‑nɩ. Nyibli ‑mʋ', ‑ʋ di꞊e nʋa yɩ bʋ pʋ, kɛ‑ ɛ di ꞊nʋ yɩ pʋ: Ba 'sii 'ʋ Kʋkɔnyɔ a 'hru yɩ, 'tɩ‑ Kʋkɔnyɔ a 'mʋ, ɛ 'mʋ di. Ɛ 'wɩ yɩ, 'aan 'klɔ bʋ 'sii 'ʋ yɩ, ‑ɛ di꞊e nu, a 'mʋ ‑mɔ ‑wɛ, 'tɩ‑ Kʋkɔnyɔ 'mʋ di.» Kɛ‑ Saan pɩ lɛlenyʋ a 'mʋ yɩ de: «Nyiblo a 'mʋ, ‑kɔtɩ Nyɩsʋa hla la, 'mɔ ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Lɛlenyʋ a 'mʋ, ‑ʋ di 'nɛ‑ Saan ‑mɔ, Falisi꞊tumu* a nyibli nɩ 'lɩ ꞊nʋ 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Kɛ‑ ʋ pɩ 'kɩ, 'ʋ yɩ Saan 'bɛti ‑nɩ, ʋ wɛn: «‑Wɛn 'nɩ, ꞊yɩ Wanyɔ ‑mʋ' 'pa‑, Nyɩsʋa pʋ la lɛ, ɛ di la ya, kɔ, ꞊yɩ Eli 'pa‑, kɔ, ‑wɛn 'nɩ, ꞊yɩ Nyɩsʋa a winwlɔn‑hanyɔ ‑mʋ', ‑kɔtɩ Moise hla la 'pa‑. 'A ‑tɩ, nyiblo a 'dɩ ‑bɩ ‑nyi 'kɩ ‑mʋ 'klɩ, 'kɩ ‑bʋ pʋ nyibli 'nie 'lu lɛ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","‑Ɛ ‑bɩ ɛ wɛn: «'Mɔ ‑bɩ, 'nie, nɔ‑ 'n pɩ nyibli 'lu lɛ. Kɛɛ, 'kɩ 'lɩ 'a mʋ 'nyɩ, nyiblo nɩ 'lɩ. Nyiblo a 'mʋ, a 'yɛ꞊ɛ nɩ yi. ");
INSERT INTO ktj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ti ‑mʋ' ‑kɔ 'yri 'n di 'ʋ ‑kʋan 'lu ‑yraa ‑nɩ, 'kɩ nyiblo a 'mʋ, ɛ di 'ʋ 'a ‑kʋan ‑wlu ꞊tuu ‑nɩ, 'kɩ 'nɛ‑ 'a mʋ 'nyɩ. 'Na 'mumu, 'n 'cɩmɩ nɩ dɩakɩ, 'kɩ 'ʋ꞊ʋ ‑mɔ', 'kɩ ꞊bʋ di 'a ‑kʋandɛ ꞊dʋ nu.» Kɛ‑ Saan pʋ lɛlenyʋ a 'mʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","‑Tɛblɩ a pɛpɛ a 'mʋ, 'kɩ 'lɩ 'dɩɔ ‑mʋ', ‑ɛ mɔ Betani 'kwli, 'kɩ ɛ muu 'lɩ 'lu ‑mɔ. 'Dɩɔ a 'mʋ, 'kɩ ɛ nɩ 'lɩ 'nie ‑mʋ', ‑ɛ mɔ Sudɛn a 'nikɩ. 'Kɩ Saan pɩɩ 'lɩ nyibli 'nie 'lu lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","‑Tɛ ‑nyrɔwɔ nɩ ‑do ‑hi, ‑ɛ ‑bɩ Saan 'ye ‑Yusu nɩ. ‑Yusu a 'mumu, 'ɛ mi 'lɩ꞊ɩ ‑mɔ yɩ. ‑Ɛ ‑bɩ Saan wɛn: «Ba 'ye kɛ, nyiblo ‑bʋ, ‑ɛ yɩ 'lɩ di, ɛ nɔ‑ mɔ ‑cɔhlʋn ‑mʋ', Nyɩsʋa ‑ha, ‑ɛ 'wɩ‑ 'blayu yɩ, ʋ yɩ Nyɩsʋa ‑pie ‑nɩ. ‑cɔhlʋn a 'mʋ, ɛ nɔ‑ di 'klɔ ‑bʋ kɩ a nyibli a dɛ 'kuku 'wʋwla ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ɛ nɔ‑ kɔ ‑tɩ, 'n hla mɔ, ‑ɛ mɔ: Nyiblo di kʋɛ 'ʋ 'mʋ ke', kɛɛ, ɛ nɔ‑ nɩ 'ʋ 'mʋ 'lu yɩ, ‑ɛ nu꞊o, ɛ nɔ‑ ‑mɔ ‑bɩ, ‑tɛ ʋ 'yɛ la 'mʋ nɩ kʋɛ, ɛ nɩ la 'klɔ. ");
INSERT INTO ktj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","‑Tɛ 'n hlɛ mɔ꞊ɔ, nyiblo bʋ di 'mʋ pa, 'n 'yɩ mɔ꞊ɔ ‑yi. Kɛɛ, 'n di nɩ, 'mʋ nyibli 'nie 'lu lɛ pʋ, ‑ɛ di꞊e nu, nyiblo, ɛ ‑mɔ, dakɔ, ‑ʋ mɔ Yisraɛkʋɛ, ʋ 'mʋ꞊ʋ yi.» ");
INSERT INTO ktj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","‑Ɛ ‑bɩ kɛ‑ Saan pɩ de: «Nyiblo bʋ di la' pa, ‑tɛ 'n 'yɛ la꞊a nɩ yi, ‑ɛ ‑bɩ Nyɩsʋa ‑mʋ', ‑ɛ lee la 'mʋ, 'kɩ ꞊bʋ mu la nyibli 'nie 'lu lɛ pʋ, ɛ wɛn: ‑Di 'ye 'na ‑Hihiu*, ɛ 'mʋ 'ʋ nyiblo ꞊dʋ 'lu ꞊tɩɩ ‑nɩ, ɛ 'mʋ 'ʋ꞊ʋ ke' nɩ. Nyiblo a 'mʋ, nɔ‑ di nyibli 'na ‑Hihiu ‑nyi. 'Ɛ mɔ ‑tɛɛ, 'n 'ye la Nyɩsʋa a ‑Hihiu a 'mʋ nɩ, 'ɛ ꞊tɩɩ la 'ʋ nyiblo a 'mʋ 'lu, ꞊wɩ yɩ, ‑tɛ ‑plija, ɛ 'yɛ nɩ ꞊tɩɩ 'ʋ꞊ʋ 'lu, ɛ 'mʋ 'ʋ꞊ʋ ke' nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","'N 'ye dɛ a 'mʋ nɩ. Ɛ nɔ‑ nu꞊o, 'nɩ hlɛ꞊ɛ, ‑ɛ mɔ, nyiblo a 'mʋ, ɛ nɔ‑ mɔ Nyɩsʋa a 'Yu.» ");
INSERT INTO ktj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","‑Tɛ ‑nyrɛ ‑nyɛ, ‑ɛ ‑bɩ 'kɩ 'ʋ ‑tɩtɛ nɩ ‑do a 'mʋ, 'kɩ Saan Batisɩ di 'ʋ de, ɛ kɔ 'a ‑nagbopʋ nɩ 'hʋɛn ‑bɩ 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","'Kɩ ɛ nɩ 'ʋ bʋ, ‑ɛ ‑bɩ ɛ 'ye ‑Yusu nɩ, 'ɛ yɩ ‑hi. ‑Tɛ ɛ 'ye꞊e, ‑ɛ ‑bɩ ɛ wɛn: «Ba 'ye kɛ nyiblo ‑bʋ, ‑ɛ 'yɩ 'lɩ di, ɛ nɔ‑ mɔ ‑cɔhlʋn* ‑mʋ', Nyɩsʋa ‑ha, ‑ɛ 'wɩ‑ 'blayu yɩ, ʋ yɩ Nyɩsʋa ‑pie ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","‑Tɩ a 'mʋ, Saan ‑hla, 'a ‑nagbopʋ nɩ 'hʋɛn ‑mʋ', ‑ʋ nɩ ‑tuo kɩ, ʋ 'wɩn nɩ. ‑Tɛ ʋ 'wɩn, ɛ nɔ‑ mɔ bʋ 'du ye', bʋ kʋɛ ‑Yusu ꞊wien. ");
INSERT INTO ktj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","‑Tɛ ʋ yɩ nɩ mi, ‑ɛ ‑bɩ ‑Yusu ꞊hɩan ‑mɔ. Bʋ 'ye 'kɩ꞊ɩ, ‑ɛ mɔ, ʋ yɩ kʋɛ꞊ɛ ꞊wien, ‑ɛ ‑bɩ ɛ wɛn: «Bʋ kla nɩ, ‑ɛ kɔ 'mɔ a yɩ ꞊wien kʋɛ 'lɩ?» ‑Ɛ ‑bɩ ʋ ꞊tu꞊o ꞊wɔn, ‑ɛ mɔ: «‑Bɩ' ꞊tii yɩ 'lɩ, Rabi?» ‑ɛ ꞊hɛn 'nyrɛ tɔɔnyɔ, 'kɩ 'lɩ ‑Juukʋɛ* a 'bliwin 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","‑Ɛ ‑bɩ ɛ wɛn: «Ba kʋɛ 'mʋ ꞊wien, a di dɛ 'nɩ 'ye,» 'ʋ kʋɛ꞊ɛ ꞊wien, ‑tɩtɛ, ɛ nɩ 'ʋ, 'ʋ 'yee 'ʋ. 'Kɩ ʋ nɩ 'ʋ꞊ʋ 'hʋɩ bʋ, kʋɛ 'ʋ 'yrʋ‑hiilɛ 'yie bʋ, ‑bʋ yɛ 'tɔ a ‑wʋnwɔn kɩ. ");
INSERT INTO ktj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","‑Nagbopʋ nɩ 'hʋɛn a 'mʋ, ‑ʋ 'wɩn Saan a 'mʋ a win, 'tɩ‑ ‑ʋ kʋɛ ‑Yusu ꞊wien, ‑ɛ ‑bɩ a 'nyrɛ mɔ Adre. Adre a 'mʋ, ɛ mɔ Simɔ Piɛlɩ a 'dɩayɩ ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ Adre a 'mʋ, ɛ mu 'lɩ 'a 'dɩayɩ Simɔ Piɛlɩ ‑mɔ, ɛ wɛn: «‑A 'ye Wanyɔ ‑mʋ' nɩ, Nyɩsʋa pʋ la lɛ, ɛ di la ya, 'kɩ 'ʋ 'a dakɔ a wʋwa a ‑ta',» ");
INSERT INTO ktj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","'ɛ gba 'lɩ꞊ɩ ‑Yusu 'hʋɩ. ‑Yusu bʋ 'ye 'kɩ꞊ɩ, ‑ɛ ‑bɩ ɛ wɛn: «‑Mɔ mɔ Simɔ, Saan a 'yu. Kʋɛ 'kɩ mɔ bʋ, 'bʋ yɩ ‑mʋ nɩ dɛ, kɛ‑ ʋ di pʋ: Sefasɩ». Sefasɩnyrɛ a 'mʋ, ɛ nɔ‑ mɔ Piɛlɩ, ‑ɛ ꞊hɛn 'nyrɛ 'hɩɔ. ");
INSERT INTO ktj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","‑Tɛ ‑nyrɛ ‑nyɛ, ‑ɛ ‑bɩ ‑Yusu pʋ 'lɩ꞊ɩ nɩ, 'kɩ bʋ mu 'lɩ Galileblʋgba 'kwli. ‑Tɛ ɛ yɩ nɩ mi, ‑ɛ ‑bɩ ɛ kɔ nyiblo ꞊dʋ 'hʋɛn‑, ʋ ꞊ŋmee nɩ. Nyiblo a 'mʋ, 'a 'nyrɛ mɔ Filipʋ. ‑Yusu wɛn: «Kʋɛ 'mʋ ꞊wien, ꞊mʋ 'na ‑nagbopi ‑hɛ,» 'ɛ kʋɛ꞊ɛ ꞊wien. ");
INSERT INTO ktj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipʋ a 'mʋ, 'kɩ ɛ kɔ 'lɩ 'dɩɔ ‑mʋ', ‑ɛ mɔ Bɛtɩsaida 'kwli. 'Kɩ Adre kɔ Piɛlɩ 'hʋɛn‑, ʋ kɔ 'lɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ 'kɩ Filipʋ mu 'lɩ nyiblo ‑bɩ ‑mɔ. Nyiblo a 'mʋ, 'a 'nyrɛ mɔ Natanaɛlɩ. ‑Ɛ ‑bɩ Filipʋ wɛn: «Wanyɔ ‑mʋ', ‑kɔtɩ Moise kɔ Nyɩsʋa a winwlɔn‑hanyʋ* ‑bɩ 'hʋɛn‑, ʋ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑a 'ye꞊e nɩ. Wanyɔ a 'mʋ, 'a 'nyrɛ mɔ ‑Yusu. 'A 'baɩ, nɔ‑ mɔ Sosɛfʋ, ‑ɛ nɩ 'lɩ Nasalɛtɩdɩɔ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaɛlɩ wɛn 'nɩ: «'Kɩ 'lɩ Nasalɛtɩdɩɔ 'kwli, ꞊haandɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑hɔn 'lɩ ‑wlu.» Filipʋ wɛn: «'De ‑ba mu, ‑na 'mumu ꞊mʋ꞊ʋ 'ye.» ");
INSERT INTO ktj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","‑Tɛ ʋ yɩ ꞊nɛ yrɛ nɩ 'mʋɛ ‑nɩ, ‑ɛ ‑bɩ ‑Yusu 'ye꞊e nɩ, ɛ wɛn: «Nyiblo ‑bʋ, ‑ɛ yɩ 'lɩ di, ɛ 'sii 'ʋ yɩ. Ɛ mɔ ꞊Haanyisraɛkʋɛyu ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","‑Ɛ ‑bɩ Natanaɛlɩ wɛn: «‑Bɩ' ‑nu 'na 'yiye 'lɩ?» ‑Ɛ ‑bɩ ɛ wɛn: «‑Tɛ ‑nɩ wɛn 'ʋ pepeklɔɔtu ‑mʋ' ꞊hlɔn, ʋ dɛɛ figie, 'tɩ‑ Filipʋ 'mʋ wɛn ‑mʋ da mɔ mu, 'n 'ye wɛn ‑mʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","‑Ɛ ‑bɩ Natanaɛlɩ wɛn: «Tɔɔnyɔ o, ɛ mɔ ꞊han‑tɩ, ‑mɔ Nyɩsʋa a 'Yu ꞊nɩɔ, ꞊nɩ mɔ Yisraɛkʋɛ a bodɩɔ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","‑Ɛ ‑bɩ ɛ wɛn: «꞊Bɩ ‑tɛ 'n pʋ lɛ, 'n 'ye wɛn ‑mʋ nɩ, 'kɩ 'lɩ pepeklɔɔtu bʋ, ɛ nɔ‑ kɔ ‑tɩ ꞊nɩ pʋ lɛ, ‑kuo 'mʋ ꞊wlʋ yɩ? Nu gbe, ‑di 'ye ‑tɛblɩ gbagbɩ ‑bɩ, ‑ɛ di 'ʋ 'a dɛ ‑bʋ, ꞊ye kɛ 'ʋ ‑hi.» ");
INSERT INTO ktj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","‑Ɛ ‑bɩ ɛ wɛn 'nɩ de: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ, a di yakɔ nɩ 'ye, ɛ 'mʋ wlɔn ‑ki, Nyɩsʋa a lɛlenyʋ 'mʋ 'lɩ Nyɩsʋa ‑mɔ ‑hɔn, ʋ 'mʋ 'ya, ʋ 'mʋ ꞊tɩ, 'kɩ 'ʋ 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo 'lu yɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","‑Nyrɔwɩ nɩ 'hʋɛn bʋ ‑hi, ‑ɛ ‑bɩ 'blɩ a pʋpa a lɛ'mimle, nɔ‑ mii 'lu ‑mɔ, 'kɩ 'lɩ Galileblʋgba 'kwli. 'Kɩ ʋ daa 'lɩ ‑Yusu a 'dii, ");
INSERT INTO ktj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","'ʋ da ‑Yusu ‑wɛ, 'kɩ 'lɩ 'blɩpaalɛ a 'mʋ kɩ. ");
INSERT INTO ktj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ti nɩ ‑do a ti 'yri, nɔ, ʋ 'nɛ wɛn, ɛ ‑wɛ nɩ. ‑Ɛ ‑bɩ kɛ‑ ‑Yusu a 'dii pɩ꞊ɩ yɩ: «Nɔ a pɛpɛ ‑wɛ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ɛ nɔ‑ mɔ ‑Yusu bʋ ‑hɩhɩa꞊a klɛ, ‑ɛ mɔ: «'Na 'dii o, ‑ha 'mʋ mɛ lɛ, ɛ 'yɩ ‑mɔ 'pa‑, ꞊nɩ ‑lee꞊e 'mʋ nɩ, ‑kʋan 'n kɔ ꞊bʋ nu. Ti ‑mʋ' ‑kɔ 'yri 'n di 'ʋ ꞊wlɩlɛkɛɛdɛ ‑nuu ‑nɩ, ti a 'mʋ, ɛ 'yɛɛ 'ʋ 'ʋ nɩ nyre.» ");
INSERT INTO ktj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ kɛ‑ 'a 'dii pɩ nyibli ‑mʋ', ‑ʋ ꞊glɛ ‑tɛblɩ yɩ, ɛ wɛn: «‑Tɩ a pɛpɛ ‑bʋ, ɛ di 'a mʋ ‑lee ‑nɩ, nɔ‑ ba nu.» ");
INSERT INTO ktj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kɛɛ, 'kɩ yɩ gbagbɩ nɩ ꞊hlon‑do, ʋ nu 'hɩ, ʋ ‑nu, ‑ɛ kɔ 'kwli ʋ pɩ 'lɩ 'nie lɛ nɩ 'ʋ, 'kɩ 'ʋ bʋɩ a lɛyɩyra a ‑ta', ꞊wɩ yɩ, ‑tɛ ‑Juukʋɛ* a tete ni 'a ‑hʋhʋa. Yɩ a 'mʋ, 'a 'yɛ nɩ ‑do gbɛ 'litayrɩɩ a ꞊wlɩ nɩ ꞊hun. ");
INSERT INTO ktj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Kɛ‑ ‑Yusu pɩ ‑tɛblɩ꞊glanyʋ a 'mʋ yɩ, ɛ wɛn: «Ba nu 'nie, ba 'yii 'lɩ ꞊nʋ lɛ,» 'ʋ 'yii 'lɩ꞊ɩ lɛ ‑tɛɛ. ");
INSERT INTO ktj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","‑Ɛ ‑bɩ ɛ wɛn: «Ba 'pi 'kɩ 'a dɛ gbe, ba gba꞊a ‑tɛblɩ꞊glanyʋ a nyiblo gbagbʋ yɩ,» 'ʋ gba 'lɩ꞊ɩ, 'ɛ ꞊tɛ꞊ɛ wlɔn. ");
INSERT INTO ktj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Bʋ ꞊tɛ 'kɩ꞊ɩ wlɔn, ‑ɛ ‑bɩ ɛ ‑hɛ nɔ. ‑Bɩ' nɔ a 'mʋ, bʋ di yɩ ‑hɔɔn ‑nɩ, ɛ 'yɩ 'ʋ ‑yi. Kɛɛ, ‑tɛblɩ꞊glanyʋ a 'mʋ, ʋ nʋ‑ yi꞊e. Ɛ nɔ‑ mɔ nyiblo gbagbʋ a 'mʋ, bʋ da 'blɩpanyɔ, ");
INSERT INTO ktj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ɛ wɛn: «'A ‑nɛ nyiblo 'bʋ da lɛ'mimle, ꞊haannɔ, ɛ nɔ‑ ʋ yɩ 'hru 'nyɛɛ ‑nɩ, ʋ pɩ. Nyibli 'bʋ 'na 'kɩ꞊ɩ ‑tɛɛ, 'tɩ‑ nɔ ‑mʋ', ‑ɛ 'yɩ ꞊haannɔ 'pa‑, 'ʋ pɩ꞊ɩ ‑wɛ. Kɛɛ, ‑mɔ ‑bɩ, kʋɛ wɛn 'lɩ bʋ, ꞊haannɔ, nɔ‑ ꞊tu bʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kɛ‑ ‑Yusu nu 'a yɩ‑hɛ꞊wlɩlɛkɛɛdɛ a nunuo, 'kɩ 'lɩ Galileblʋgba a 'dɩɔ ‑mʋ', ‑ɛ mɔ Kana 'kwli. Kɛ‑ ɛ ‑nu, 'ɛ tɔɔ nɛ 'a ‑nagbopʋ* 'klɩ ‑mʋ', Nyɩsʋa ‑nyi꞊e. Dɛ a 'mʋ, ɛ nɔ‑ nu꞊o, 'ʋ kuo ꞊nɛ ꞊wlʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ 'kɩ ɛ mu 'lɩ Kapɛnaɔdɩɔ 'kwli, ɛ kɔ 'a 'dii, kɔ 'a 'dɩayɩnʋ, kɔ 'a ‑nagbopʋ 'hʋɛn‑, ‑ɛ di꞊e nu, ʋ 'mʋ 'lɩ ‑nyrɔwɩ gbi 'lɩ ‑hi. ");
INSERT INTO ktj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Juukʋɛ* a lɛ'mimle gbagbʋ ‑mʋ', ʋ dɛɛ Pakɩ, ɛ 'mʋɛ yrɛ. Ɛ nɔ‑ nu꞊o, ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, 'ʋ mu 'lɩ Jrusrɛdɩɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","‑Tɛ ʋ nyre 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli, 'kɩ ʋ yɛɛ 'lɩ puplonyibli bʋ, ‑ʋ ple blo, kɔ blablɩ, kɔ ‑hungbo 'hʋɛn‑, ‑ɛ di꞊e nu, ‑tonyibli 'mʋ꞊ʋ ‑tɔ, ʋ 'mʋ꞊ʋ nu, ʋ 'mʋ ‑cɔhlʋn* pi. 'Kɩ 'ʋ ‑tɩtɛ nɩ ‑do a 'mʋ, 'kɩ ʋ yɛɛ 'ʋ 'wli'cɩcɩnyibli bʋ ‑wɛ, 'ʋ nɩ 'lɩ 'waa 'teble ye' blɛ, 'ʋ yɩ hɩapʋwli 'cɩcɩ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","‑Tɛ ‑Yusu 'ye ꞊nʋ, ɛ nɔ‑ mɔ, bʋ nu lɔkɔ, bʋ bla ꞊nʋ lɛ pɛpɛ, 'ʋ ‑hɔn 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa a 'mʋ 'kwli, ʋ kɔ 'waa 'wlugba‑tɛblɩ a 'mʋ 'hʋɛn‑, 'tɩ‑ 'ɛ 'wla 'wli'cɩcɩnyʋ a 'wli bʋ, 'kɩ 'ʋ ‑tʋtʋ kɩ, 'ɛ ꞊jri 'waa 'teble yɩ blɛ. ");
INSERT INTO ktj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ, 'ɛ yɩ ‑hungboplonyʋ ‑mʋ' ‑lee ‑nɩ, ɛ wɛn: «Ba ‑ha 'nɛ‑ ‑tɛblɩ ‑bʋ! A 'nɩ 'nuo 'lɩ 'na 'Baɩ Nyɩsʋa a 'kayu puplokayu ‑mɔ!» ");
INSERT INTO ktj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","‑Yusu a ‑nagbopʋ ‑mʋ', ‑ʋ nɩ 'ʋ, ‑tɩ ‑mʋ', ʋ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, ɛ bi 'lɩ ꞊nʋ 'kwli. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: «Nyɩsʋa o, 'n nʋɛ ‑na 'kayu nɩ dɩakɩ. ‑Tɛ 'n nu 'a nʋɛlɛ, ɛ 'wɩ‑ na yɩ, ‑ɛ yɩ wlɩn, 'kɩ 'lɩ 'na 'hʋɩ 'kwli, ‑ɛ yɩ 'mʋ lɛ hien.» ");
INSERT INTO ktj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ɛ nɔ‑ mɔ, ‑Juukʋɛ a nyibli gbagbɩ ‑mʋ', ‑ʋ nɩ ‑tuo kɩ, bʋ 'bɛti꞊e, ʋ wɛn: «Nyiblo a 'dɩ ‑bɩ ‑mɔ, ꞊nɩ blɛ ꞊nʋ lɛ 'lɩ? Nu ꞊wlɩlɛkɛɛdɛ, ‑ɛ di ‑a mɔ꞊ɔ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, 'klɩ ‑mʋ', ‑ɛ kɔ 'kwli ‑blɛɛ 'lɩ ꞊nʋ lɛ, 'kɩ ɛ kʋɛ 'lɩ Nyɩsʋa ‑mɔ bʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «Dɛ 'n di nu, ɛ nɔ‑ ‑bʋ: Ba 'wla Nyɩsʋa a 'kagbaʋ ‑bʋ, 'n di 'du꞊o ye' de, 'kɩ 'lɩ ‑nyrɔwɩ nɩ ta 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","‑Ɛ ‑bɩ ʋ wɛn: «꞊Bɩ 'kayu ‑bʋ, ʋ ‑pʋ, 'kɩ 'lɩ 'yrɩ a (46) ‑wlɩ nɩ 'hʋɛn ꞊tu 'ʋ ꞊hlon‑do 'kwli, ɛ nɔ‑ ‑pɩ lɛ, ‑di ye' 'du, 'kɩ 'lɩ ‑nyrɔwɩ nɩ ta 'kwli?» ");
INSERT INTO ktj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kɛɛ, Nyɩsʋa a 'kagbaʋ ‑mʋ', ‑Yusu ꞊hɛn 'nyrɛ, ɛ nɔ‑ mɔ 'a dɩɔnʋ a ‑plahʋɩ. ");
INSERT INTO ktj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","‑Tɛ ɛ ‑hie ti ‑hʋɔhʋɩ, ti ‑mʋ' ‑kɔ 'yri ɛ 'kʋ, 'tɩ‑ ɛ 'hrɩ 'klɔ, 'kɩ ɛ bi 'lɩ 'a ‑nagbopʋ 'kwli, ‑ɛ mɔ, 'a ‑plahʋɩ a ‑tɩ ɛ hlɛ la, ɛ 'yɩ la Nyɩsʋa a 'kagbaʋ 'pa‑, ɛ 'yɩ la꞊a 'nyrɛ ꞊hɛn. ‑Tɩ a 'mʋ, ʋ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, yɩ‑hɛ‑nyrɛ a ti 'yri, ɛ kɔ ‑tɩ a pɛpɛ ‑mʋ', ‑Yusu lee la ꞊nʋ, ʋ kuo ꞊nɛ ꞊wlʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ti ‑mʋ', ‑ɛ kɔ 'yri ‑Yusu 'tɩɛ nɩ la 'lɩ lɛ'mimle ‑mʋ', ‑ɛ mɔ Pakɩ kɩ, 'kɩ 'lɩ Jrusrɛdɩɔ 'kwli, ɛ ni la ꞊wlɩlɛkɛɛ‑tɛblɩ ‑hʋɔhʋɩ. Nyibli ‑hʋɔhʋɩ bʋ yɩ ꞊wlɩlɛkɛɛ‑tɛblɩ a 'mʋ nɩ 'ye, ɛ nɔ‑ nu꞊o, 'ʋ pʋ꞊ʋ ꞊han‑tɩ, ‑ɛ mɔ, ɛ nɔ‑ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya. ");
INSERT INTO ktj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kɛɛ, ‑Yusu 'yɩ ꞊nʋ ꞊wlʋ yɩ ‑kuo ‑nɩ, ‑ɛ nu꞊o, ‑tɛ 'waa ꞊wlɩ nɩ 'mʋ, ɛ yi꞊e nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","‑Yusu 'nɩ ꞊mʋɔ lɩ꞊ɩ lɛ, 'kɩ nyiblo ꞊dʋ bʋ lee ꞊nɛ, ‑tɛ ‑tonyibli a ꞊wlɩ nɩ 'mʋ, ‑ɛ nu꞊o, 'a ꞊gbɛtʋ, ɛ yi ‑tɛblɩ a pɛpɛ ‑mʋ', ‑ɛ nɩ 'lɩ ‑tonyiblo a ꞊wlʋ kɩ nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ɛ kɔ la nyiblo ꞊dʋ. 'A 'nyrɛ mɔ la Nikodɛmʋ. Ɛ mɔ la Falisi꞊tumu* a nyiblo ꞊nɩɔ. Ɛ mɔ la ‑Juukʋɛ* a ye'nanyɔ ‑bɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nikodɛmʋ a 'mʋ, ɛ nɔ‑ 'tɔlʋwɔ ꞊dʋ 'kwli, ‑ɛ mu la 'lɩ ‑Yusu ‑mɔ, ɛ wɛn: «Tɔɔnyɔ, ‑a yi꞊e nɩ, ‑ɛ mɔ, Nyɩsʋa, nɔ‑ lee 'nɛ‑ ‑mʋ ‑a mʋ 'nyɩ, ꞊mʋ ‑a mʋ ‑tɔɔ ‑nɩ, ‑ɛ nu꞊o, ꞊wlɩlɛkɛɛ‑tɛblɩ ‑mʋ', ‑ni, nyiblo ꞊dʋ 'yɩ 'lɩ 'a nunuo 'lɩ ‑wɛ, 'bʋ mɔ, Nyɩsʋa 'bʋ 'yɩ 'ʋ꞊ʋ ‑mɔ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","‑Ɛ ‑bɩ ‑Yusu wɛn: «'N yɩ ‑mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ pa 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli, 'bʋ mɔ, 'bʋ 'yɩ kɔɔwɩ nɩ 'hʋɛn ‑nu.» ");
INSERT INTO ktj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","‑Ɛ ‑bɩ Nikodɛmʋ wɛn: «‑Tonyiblo ‑bʋ, ‑ɛ ‑ku, ‑bɩ' ɛ wɛ 'lɩ bʋ nu kɔɔwɩ nɩ 'hʋɛn a nunuo 'lɩ? Ɛ mɔ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ pa 'lɩ 'a 'dii 'kwli, 'tɩ‑ bʋ kɔ꞊ɔ de.» ");
INSERT INTO ktj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","‑Ɛ ‑bɩ ɛ wɛn: «'N yɩ ‑mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ, nyiblo 'bʋ nu kɔɔwɔ nɩ ‑do, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ pa 'lɩ Nyɩsʋa a 'klɔ yrayrʋ 'kwli. Kɛɛ, ɛ ‑hʋɛ꞊ɛ nɩ, 'kɩ Nyɩsʋa a ‑Hihiu* bʋ ‑nyi꞊e 'klɔ yrayrʋ, 'tɩ‑ ɛ 'mʋ 'lɩ Nyɩsʋa a 'klɔ yrayrʋ a 'mʋ 'kwli pa. ");
INSERT INTO ktj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","‑Tonyibli, nʋ‑ ni꞊e, 'ʋ kʋɛ ‑tonyiblo yrayrʋ, kɛɛ, Nyɩsʋa a ‑Hihiu, nɔ‑ ni꞊e, ‑tonyiblo 'ɛ kʋɛ 'klɔ yrayrʋ, ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ɛ 'nɩ 'kɛɛ 'lɩ ‑na ꞊wlɩ lɛ, 'bʋ mɔ, 'nɩ pʋ lɛ, a kɔ ba nu kɔɔwɩ nɩ 'hʋɛn. ");
INSERT INTO ktj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","‑Tɛ pepe ‑hʋɛ bʋ mu 'lɩ, 'kɩ ɛ ‑hui 'lɩ, ꞊yɩ 'a ‑hihiwin 'nɩ 'wɩn, kɛɛ, ‑tɩtɛ, ɛ ‑hʋɛn 'lɩ, kɔ, ‑tɩtɛ, ɛ mi 'lɩ, ꞊yɩ 'a ꞊dedede ‑yi. Kɛ‑ Nyɩsʋa a ‑Hihiu nɩ 'mʋ. Nyiblo ‑mʋ', ‑Hihiu a 'mʋ, ɛ di 'klɔ yrayrʋ ‑nyi, ꞊yɩ꞊ɩ ‑yi.» ");
INSERT INTO ktj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","‑Ɛ ‑bɩ Nikodɛmʋ wɛn: «‑Bɩ' dɛ a 'mʋ, ɛ ‑wɛ 'lɩ bʋ nu 'lu‑mɔmumuo 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","‑Ɛ ‑bɩ ɛ wɛn: «‑Mɔ ‑bʋ, ‑ɛ mɔ tɔɔnyɔ gbagbʋ, 'kɩ 'nɛ‑ ‑Juukʋɛ a 'bli, ‑mɔ 'yɩ ‑tɛblɩ a 'mʋ ‑yi. ");
INSERT INTO ktj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Dɛ ‑bʋ, 'n 'ye, ɛ kɔ dɛ ‑bʋ, 'n ‑yi, ɛ nɔ‑ kɔ ‑tɩ 'n hlɛ. Kɛɛ, a 'nɩ ‑pʋ꞊ʋ 'mʋ ꞊han‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","‑Tɛblɩ ‑bʋ, ‑ɛ mii 'nɛ‑ ‑tʋtʋ kɩ 'lu ‑mɔ, 'bʋ mɔ, 'nɩ yɩ 'a ‑tɩ ‑mɔ lɛ nɩ nɛ, a 'nɩ ‑pʋ꞊ʋ lɩ꞊ɩ ꞊han‑tɩ. 'Ba 'yɛ nɩ pʋ꞊ʋ ꞊han‑tɩ, ‑ɛ ‑bɩ ‑tɛblɩ ‑mʋ', ‑ɛ mi 'lu ‑mɔ, 'kɩ 'lɩ yakɔ 'kwli, 'bʋ mɔ, 'nɩ yɩ 'a ‑tɩ ‑mɔ lɛ nɩ nɛ, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba pʋ 'a ‑tɩ ꞊han‑tɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","‑Tonyiblo ꞊dʋ 'yɩ ‑hʋan 'lɩ yakɔ 'kwli nɩ mi, 'bʋ yɩ 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo 'pa‑. 'Mɔ ‑bʋ, 'mɔ ‑hɔn 'lɩ yakɔ 'kwli. 'A ‑tɩ, 'hru pɛ 'ʋ bʋ, 'kɩ ꞊bʋ na yakɔ 'kwli a ‑tɩ ‑mɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Bʋ bi 'lɩ ‑mʋ 'kwli, ti ‑mʋ' ‑kɔ 'yri Yisraɛkʋɛ nɩ la 'hru wlɔn, 'kɩ 'lɩ 'pʋwɔnblʋgba kɩ, ti ‑hi la a ti 'yri, Moise 'du la 'plɩdɛ ye', 'ɛ nu la hre, 'tɩ‑ 'ɛ 'bɛ la tugbɛ. Nɔ‑ kɔ 'lu ɛ 'ba la 'ʋ hre a 'mʋ bʋ, ‑ɛ di꞊e nu, 'a ‑nɛ nyiblo, 'bʋ 'wla la 'yi wla, 'bʋ taa la 'lɩ hre 'a mʋ ‑mɔ lɛ, 'kɩ 'lɩ ꞊wlʋ a yɩkuolɛ 'kwli, ɛ 'nɩ ꞊ha la 'kʋ. Kɛ‑ ɛ di 'mʋ ꞊ti, 'kɩ 'ʋ 'mɔ ‑bʋ ‑mɔ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo. Ʋ di 'ba 'ʋ 'mʋ tugbɛ 'yie bʋ, ");
INSERT INTO ktj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","‑ɛ di꞊e nu, 'a ‑nɛ nyiblo, 'bʋ taa 'lɩ 'mʋ ‑mɔ lɛ, 'kɩ 'lɩ 'na ꞊wlʋ a yɩkuolɛ 'kwli, Nyɩsʋa 'mʋ꞊ʋ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ɛ mɔ ꞊han‑tɩ, Nyɩsʋa nʋɛ ‑tonyibli a pɛpɛ nɩ dɩakɩ. Ɛ nɔ‑ kɔ ‑tɩ, 'ɛ ‑ha 'a 'Yu nɩ ‑do, ‑ɛ di꞊e nu, 'a ‑nɛ nyiblo, 'bʋ kuo ꞊nɛ ꞊wlʋ yɩ, ɛ 'nɩ ꞊ha 'wan, kɛɛ, Nyɩsʋa a 'mʋ, ɛ 'mʋ꞊ʋ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nyɩsʋa 'yɩ 'nɛ‑ 'a 'Yu ‑tʋtʋ kɩ tɛ, ‑ɛ di꞊e nu, ɛ 'mʋ ‑tonyibli ‑bati lɛ ‑pʋʋ ‑nɩ, kɛɛ, ɛ 'mʋ ꞊nʋ wa a ‑tɩ ꞊nɩɔ, ʋ 'nɩ ꞊ha 'wan. ");
INSERT INTO ktj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nyiblo ‑bʋ, 'bʋ kuo Nyɩsʋa a 'Yu ꞊wlʋ yɩ, Nyɩsʋa a ‑bati 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ klɔ꞊ɔ. Kɛɛ, nyiblo 'bʋ 'yɩ꞊ɩ ꞊wlʋ yɩ ‑kuo ‑nɩ, Nyɩsʋa a ‑bati ‑wɛ 'a kʋklɔ ‑mɔ, ‑tɛ ɛ ‑nu 'kɩ, ɛ 'yɩ Nyɩsʋa a 'Yu a 'mʋ ꞊wlʋ yɩ ‑kuo ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","‑Tɛ Nyɩsʋa ni nyibli a ‑bati a lɛpʋʋlɛ, ɛ nɔ‑ ‑bʋ: Ɛ mɔ ꞊han‑tɩ, ‑nyrɛ, ‑ɛ mɔ Nyɩsʋa a 'Yu, 'ɛ di 'nɛ‑ ‑tʋtʋ kɩ, kɛɛ, nyibli 'yɩ ‑nyrɛ a 'mʋ ‑hʋa. Halɔ, nɔ‑ ʋ ‑hʋɛ, ‑ɛ nu꞊o, 'waa nunu‑tɛblɩ nyre yɩ. ");
INSERT INTO ktj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nyiblo 'bʋ nɩ 'ʋ, 'bʋ yɩ dɛ ‑hʋan nɩ ni, 'a ꞊wlʋ yraa ‑nyrɛ nɩ. Halɔ 'nyɩ, 'kɩ ɛ yɩ 'lɩ bʋ nɩ, ‑kɔtɩ ɛ yɩ pie hʋannʋ, 'kɩ 'a nunu‑tɛblɩ ‑hʋɩn bʋ bi pepe'. ");
INSERT INTO ktj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kɛɛ, nyiblo 'bʋ yɩ ꞊haandɛ nɩ ni, ɛ yɩ 'mʋɛ ‑nyrɛ lɛ, ‑ɛ di꞊e nu, nyibli 'mʋ꞊ʋ 'ye, ‑ɛ mɔ, 'a nunu‑tɛblɩ, ɛ ni, ɛ kwlɛɛ Nyɩsʋa kɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, 'kɩ ʋ mu 'lɩ Sudeblʋgba 'kwli. 'Kɩ 'lɩ ‑tɩtɛ a 'mʋ, ɛ ‑hii 'lɩ ti gbi, 'ɛ pɩ nyibli 'nie 'lu lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Saan pɩ nyibli 'nie 'lu lɛ ‑wɛ. Ɛ nɔ‑ ‑mɔ ‑bɩ, 'kɩ ɛ nɩ 'lɩ Enɔdɩɔ 'kwli, 'kɩ 'lɩ Salimʋdɩɔ 'hʋɩ, ‑kɔtɩ 'kɩ 'ʋ ‑tɩtɛ a 'mʋ, 'nie ‑hʋʋ 'ʋ nɩ, nyibli 'ʋ mi 'lɩ꞊ɩ ‑mɔ lɛ, 'ɛ pɩ ꞊nʋ 'nie 'lu lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ti a 'mʋ 'yri, ʋ 'yɛ꞊ɛ ꞊jɩ' nɩ pɩ. ");
INSERT INTO ktj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","‑Ɛ ‑bɩ, Saan a ‑nagbopʋ ‑bɩ, kɔ ‑Juukʋɛ* a ye'nanyɔ ‑bɩ 'hʋɛn‑, ʋ nʋ‑ pɩ toto, 'kɩ 'ʋ nyiblo a bʋɩ a lɛyɩyra a ‑ta', ");
INSERT INTO ktj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","'ʋ mu 'lɩ Saan 'hʋɩ, ʋ wɛn: «Tɔɔnyɔ, ꞊bɩ ɛ yɩ bi 'lɩ ‑mʋ 'kwli, nyiblo ‑mʋ', ‑ɛ kɔ ‑mʋ 'hʋɛn‑ a nɩ mɔ 'lɩ 'nie ‑mʋ', ‑ɛ mɔ Sudɛn a 'nikɩ, ‑kɔtɩ ‑lee la ‑a mʋ, ꞊nɩ pʋ la lɛ, ‑ɛ mɔ, ɛ nɔ‑ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya? ‑Ɛ ‑bɩ 'kɩ, nyiblo a 'mʋ, ɛ pɩ nyibli 'nie 'lu lɛ ‑wɛ, 'tɩ‑ nyibli a pɛpɛ ‑mʋ', ‑ʋ di wɛn 'nɛ‑ ‑mʋ ‑mɔ di, 'kɩ ʋ mi 'lɩ꞊ɩ ‑mɔ, 'ɛ pɩ ꞊nʋ 'nie 'lu lɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Saan ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «Nyɩsʋa ‑bʋ, ‑ɛ nɩ 'lɩ yakɔ 'kwli, ɛ nɔ‑ yɩ ‑a mʋ 'a ‑nɛ ‑kʋandɛdʋ, ‑a di nu ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","'Mɔ Saan, 'na ‑kʋan, 'n ‑kɔ, ɛ nɔ‑ mɔ ꞊bʋ tɔɔ Wanyɔ a 'mʋ nyibli, ‑ɛ di꞊e nu, nyibli 'mʋ 'lɩ꞊ɩ ‑mɔ mu. 'Aan 'mumu, a yi꞊e nɩ, 'n lee la 'a mʋ, ‑ɛ mɔ, 'n 'yɩ Wanyɔ ‑mʋ' 'pa‑, Nyɩsʋa pʋ la lɛ, ɛ di la ya. 'Mɔ ‑bɩ, 'n 'nyɛɛ 'hru, ‑ɛ di꞊e nu, 'mʋ 'a mʋ ‑lee ‑nɩ, ‑ɛ mɔ, Wanyɔ a 'mʋ, ɛ yɩ 'lɩ 'nɩ di. ");
INSERT INTO ktj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","꞊Bʋ pʋ꞊ʋ 'blɩ a pʋpa a dɛ yɩ. Nyɩbɛhɩan ‑mʋ', ‑ɛ pʋɛ 'blɩ, nʋgba ‑mʋ', ‑ɛ kɔ꞊ɔ 'hʋɛn‑, ‑ʋ pʋɛ 'blɩ, nɔ‑ kɔ nʋgba a 'mʋ. Ɛ 'yɩ 'blɩpanyɔ a nɩnatumu 'pa‑, ɛ 'yɩ nʋgba a 'mʋ ‑kɔ. Kɛɛ, 'kɩ ɛ yɩ 'ʋ 'blɩpanyɔ 'hʋɩ bʋ nɩ, 'ɛ pɩ꞊ɩ nʋa yɩ bʋ, kɔ, 'ɛ ni dɔdʋ, 'bʋ yɩ 'a win nɩ 'wɩn. ‑Yusu 'wɩ‑ 'blɩpanyɔ yɩ, 'mɔ ꞊wɩ 'a nɩnatumu yɩ, 'a dɔdʋ mɔ 'na dɔdʋ. Ɛ nɔ‑ 'yii 'lɩ 'mʋ. Nyibli 'wɩ‑ 'blɩpanʋgba yɩ. Ɛ nɔ‑ nu꞊o, 'ʋ mi 'lɩ ‑Yusu ‑mɔ. Ɛ 'yɩ 'mɔ 'pa‑, ʋ 'yɩ yɩ ‑blɛɛ ‑nɩ, bʋ di 'nɛ‑ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ɛ nɔɔ 'ʋ lɛ, 'kɩ ‑Yusu a 'nyrɛ bʋ 'bʋa, 'mɔ ‑bɩ, 'na 'nyrɛ bʋ ꞊tɩɩ 'lɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","'Kɩ ‑Yusu ‑hɔn 'lɩ yakɔ 'kwli. Ɛ nɔ‑ nu꞊o, 'ɛ nɩ 'ʋ nyibli a pɛpɛ 'lu yɩ. ‑A mʋ ‑mɔ ‑bɩ, 'kɩ ‑a kɔ 'nɛ‑ ‑tʋtʋ kɩ. Ɛ nɔ‑ kɔ ‑tɩ, ꞊a yɩ ‑tʋtʋ kɩ a ‑tɛblɩ kɩ ‑hlee ‑nɩ. Ɛ nɔ‑ ‑mɔ ‑bɩ, 'kɩ ɛ ‑hɔn 'lɩ yakɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","‑Tɛblɩ ‑mʋ', ɛ 'ye, kɔ, ɛ 'wɩn, ɛ nɔ‑ kɔ ‑tɩ ɛ nɛ ‑mɔ lɛ. Kɛɛ, nyibli ‑mʋ', ‑ʋ kuo ꞊nɛ ꞊wlʋ yɩ, ʋ 'yɩ ‑hʋ. ");
INSERT INTO ktj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kɛɛ, nyibli a 'mʋ, ‑ʋ kuo ꞊nɛ ꞊wlʋ yɩ, ʋ hlɛ꞊ɛ nɩ, ‑ɛ mɔ, ‑tɩ a pɛpɛ ‑mʋ', Nyɩsʋa hlɛ, ɛ mɔ ‑tɩ a ‑tɛɛ ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","‑Yusu a 'mumu, Nyɩsʋa lee 'nɛ‑ ‑a mʋ ‑mɔ, Nyɩsʋa a win, nɔ‑ ɛ nɛ ‑mɔ lɛ, ‑ɛ nu꞊o, Nyɩsʋa ‑nyi꞊e 'a ‑Hihiu* a pɛpɛ nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nyɩsʋa nʋɛ nɛ 'a 'Yu a 'mʋ nɩ. Ɛ nɔ‑ kɔ ‑tɩ, 'ɛ ‑nyi꞊e ‑tɛblɩ a pɛpɛ, ‑ɛ di꞊e nu, ɛ 'mʋ꞊ʋ win kɩ ‑kɔɔ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nyiblo 'bʋ kuo Nyɩsʋa a 'Yu a 'mʋ ꞊wlʋ yɩ, ‑ɛ ‑bɩ ɛ kɔ 'klɔ yrayrʋ, ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ. Kɛɛ, nyiblo 'bʋ 'yɩ꞊ɩ ꞊wlʋ yɩ ‑kuo ‑nɩ, 'tɩ‑ 'bʋ 'yɛ nɩ ꞊tuu 'ʋ꞊ʋ, nyiblo a 'mʋ, ɛ 'yɩ 'klɔ yrayrʋ a 'mʋ ‑kɔ, kɛɛ, Nyɩsʋa a yrʋ, nɔ‑ di꞊e klɔ. ");
INSERT INTO ktj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Falisi꞊tumu* a nyibli 'wɩn nɩ, ‑ɛ mɔ, ‑Yusu ni꞊e nɩ, nyibli 'ʋ yɩ꞊ɩ ꞊wien kʋɛ, kɔ, 'ɛ pɩ ꞊nʋ 'nie 'lu lɛ. Nyibli a 'mʋ, ʋ ‑hʋ nɩ, 'ʋ ‑hi 'ʋ Saan a nyibli 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Kɛɛ, 'kɩ 'lɩ ‑tɩ a ‑tɛɛ a hɩhla 'kwli, ‑Yusu a 'mʋ, ɛ 'nɩ ‑pʋ꞊ʋ nyibli 'nie 'lu lɛ. 'A ‑nagbopʋ*, ʋ nʋ‑ pɩ nyibli 'nie 'lu lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","‑Tɩ ‑mʋ', nyibli ‑hla, ‑tɛ ‑Yusu 'wɩn, ‑ɛ ‑bɩ ɛ ‑hɔn 'lɩ Sudeblʋgba 'kwli nɩ, ɛ kɔ 'a ‑nagbopʋ 'hʋɛn‑, 'ʋ mi 'lɩ Galileblʋgba 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","'Tɩ‑ ʋ 'mʋ 'lɩ Galileblʋgba 'kwli nyre, ʋ kɔ bʋ 'bɛɛ 'lɩ Samaliblʋgba 'kwli ꞊tɩɔ. ");
INSERT INTO ktj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Bʋ yɩ 'kɩ 'lɩ Samaliblʋgba 'kwli ꞊tɩɔ nɩ 'bɛɛ ‑nɩ, ‑ɛ ‑bɩ ʋ nyre 'ʋ 'dɩɔ ꞊dʋ ꞊hlɔn. 'Dɩɔ a 'mʋ, 'a 'nyrɛ mɔ Sisalɩ. 'Kɩ ‑Juukʋɛ* a 'baɩ gbagbʋ Sakɔbʋ a ‑ci nɩ 'ʋ ‑tɛ a 'mʋ, ‑ɛ ‑mʋ', ɛ ‑nyi la 'a 'yu Sosɛfʋ. ");
INSERT INTO ktj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","'Kɩ 'lɩ ‑ci a 'mʋ 'kwli, 'kɩ Sakɔbʋ 'bluu la 'ʋ 'niebutɩɔ. ‑Tɛ ʋ nyre 'kɩ 'ʋ 'niebutɩɔ a 'mʋ wien, ‑ɛ ‑bɩ 'kɩ ‑Yusu a ‑nagbopʋ hie 'ʋ꞊ʋ bʋ, 'ʋ mu 'dɩɔ, ‑ɛ di꞊e nu, ʋ 'mʋ didi‑tɛblɩ ‑tɔ. ‑Yusu ‑mɔ ‑bɩ, 'a 'klɩ ‑wɛ 'lɩ nɩ, 'dagba ‑mʋ' a ‑tɩ. Ɛ nɔ‑ nu꞊o, 'ɛ nɩ 'ʋ 'niebutɩɔ a 'mʋ wien bʋ. Ti a 'mʋ 'yri, ‑ɛ ‑bɩ 'yrʋ nyra bʋ. Ɛ nɩ ‑do bʋ nɩ 'kɩ 'ʋ bʋ, ‑ɛ ‑bɩ Samalikʋɛyrɔlʋ ꞊dʋ, ɛ nɔ‑ di 'nie 'pi mɔ. ‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ꞊ɩ yɩ, ɛ wɛn: «‑Nyi 'mʋ 'nie, ꞊bʋ 'na.» ");
INSERT INTO ktj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","‑Ɛ ‑bɩ nʋgba a 'mʋ, ɛ ꞊tu꞊o ꞊wɔn, ɛ wɛn: «'Hebe, ‑mɔ ‑Juukʋɛyu, ‑mɔ ‑hʋɛ 'mɔ ‑bʋ, ‑ɛ mɔ Samalikʋɛyrɔlʋ 'nie.» 'Ɛ mɔ ꞊han‑tɩ, ‑Juukʋɛ kɔ Samalikʋɛ 'hʋɛn‑, ʋ 'nɩ 'wɩnwɩn꞊ɩ win' lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ꞊ɩ yɩ, ɛ wɛn: «'Bʋ mɔ, ꞊nɩ yi wɛn dɛ ‑mʋ', Nyɩsʋa yɩ nyibli ‑nyi, kɔ, 'bʋ mɔ, ꞊nɩ yi wɛn 'mɔ ‑bʋ, ‑ɛ ‑hʋɛ ‑mʋ 'nie, ‑ɛ ‑bɩ ‑mɔ di wɛn 'mʋ 'nie ‑hʋa. 'Mɔ ‑bɩ, 'niedʋ ‑mʋ', ‑ɛ yɩ nyibli 'klɔ yrayrʋ ‑nyi, ɛ nɔ‑ 'n di wɛn ‑mʋ ‑nyi.» ");
INSERT INTO ktj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","‑Ɛ ‑bɩ nʋgba a 'mʋ, ɛ wɛn: «Nyɩbɛyu o, ꞊yɩ 'nie'piidɛ ‑kɔ, 'tɩ‑ 'niebutɩɔ ‑bʋ, ɛ hlɔ 'kwli bʋ. ‑Bɩ' ‑wɛ 'lɩ ‑bʋ nu 'nie a 'mʋ, 'a 'pipie 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","‑Aan 'baɩ gbagbʋ Sakɔbʋ, ɛ nɔ‑ hie ‑a mʋ 'niebutɩɔ ‑bʋ lɛ. 'A 'mumu, ɛ 'na 'a 'nie nɩ, ɛ kɔ 'a 'yonʋ 'hʋɛn‑, 'a 'wlugba‑tɛblɩ 'na 'a 'nie a 'mʋ nɩ ‑wɛ. ꞊Bɩ ‑pʋ꞊ʋ ꞊haan‑tɩ, ‑mɔ nɩ 'ʋ꞊ʋ 'lu yɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","‑Ɛ ‑bɩ ‑Yusu wɛn: «Nyiblo ‑mʋ', ‑ɛ di 'niebutɩɔ ‑bʋ a 'nie 'na, 'nie'natʋ 'tɩɛ di꞊e nu. ");
INSERT INTO ktj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Kɛɛ, nyiblo 'bʋ nɩ 'ʋ, 'bʋ yɩ 'niedʋ ‑mʋ', 'n di꞊e ‑nyi nɩ 'nɛ, 'nie'natʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ nu 'kɩ꞊ɩ de yuyru, ‑ɛ nu꞊o, 'niedʋ ‑mʋ', 'n di꞊e ‑nyi, ɛ di 'wɩ‑ 'nie ‑mʋ' yɩ, ‑ɛ yɩ 'lɩ ‑tʋtʋ 'kwli 'hrɩ ti a pɛpɛ, ‑ɛ yɩ nyiblo a 'mʋ 'klɔ yrayrʋ, ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ ‑nyi.» ");
INSERT INTO ktj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","‑Ɛ ‑bɩ nʋgba a 'mʋ, ɛ wɛn: «‑Nyi 'mʋ 'niedʋ a 'mʋ, ‑ɛ di꞊e nu, 'nie'natʋ 'nɩ ꞊ha 'kɩ 'mʋ nu de, kɔ, 'nɩ ꞊ha 'kɩ 'nɛ‑ 'niebutɩɔ ‑bʋ wien di de, 'nie'pi‑tɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","‑Ɛ ‑bɩ ‑Yusu wɛn: «Mu ‑bʋ da ‑na nyɩbɩʋ, ɛ kɔ ‑mʋ 'hʋɛn‑, ba di 'lɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","‑Ɛ ‑bɩ nʋgba a 'mʋ, ɛ wɛn: «'N 'yɩ nyɩbɩʋ ‑kɔ.» ‑Ɛ ‑bɩ ‑Yusu wɛn: «꞊Haan‑tɩ ꞊nɩɔ. ꞊Yɩ nyɩbɩʋ ‑kɔ, ");
INSERT INTO ktj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","‑ɛ nu꞊o, ‑bʋ kɔ nyɩbɩʋ, ‑bʋ kɔ nyɩbɩʋ, ɛ ‑wɛ 'kɩ 'lɩ nyɩbɛpʋ nɩ ꞊hun nɩ, 'tɩ‑ nyiblo ‑mʋ', ‑ɛ kɔ ‑mʋ 'hʋɛn‑, a nɩnɩ 'hʋɩ, ‑tɛ ti nɛ ‑bʋ, ɛ 'yɩ ‑na nyɩbɩʋ 'pa‑.» ");
INSERT INTO ktj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","‑Ɛ ‑bɩ nʋgba a 'mʋ, ɛ wɛn: «'N yɩ꞊ɩ 'nɩ 'ye, ‑ɛ mɔ, ‑mɔ Nyɩsʋa a winwlɔn‑hanyɔ* ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","‑A mʋ Samalikʋɛ, 'kɩ 'lɩ dʋgba ‑mʋ' 'lu, 'kɩ ‑aan 'baɩnʋ dɛɛ la 'lɩ Nyɩsʋa, kɛɛ, 'a mʋ ‑Juukʋɛ, a wɛn 'nɩ, Jrusrɛdɩɔ nɩ ‑do, ɛ nɔ‑ mɔ Nyɩsʋa a daalɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","‑Ɛ ‑bɩ ‑Yusu wɛn: «Nʋgba o, ‑tɩ 'n hlɛ, pʋ꞊ʋ ꞊han‑tɩ. Ti di 'ʋ 'nɩ nyre, ‑ɛ kɔ 'yri a 'yɛ nɩ di 'ʋ ‑aan 'Baɩ Nyɩsʋa nɩ ‑daa ‑nɩ, 'kɩ 'lɩ dʋgba ‑mʋ' 'lu, kɔ 'kɩ 'lɩ Jrusrɛdɩɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","'A mʋ Samalikʋɛ, Nyɩsʋa ‑mʋ', a dɛ, a 'yɩ꞊ɩ ‑yi. Kɛɛ, ‑a mʋ ‑bʋ, ‑ʋ mɔ ‑Juukʋɛ, Nyɩsʋa ‑mʋ', ‑a dɛ, ‑a yi꞊e nɩ, ‑ɛ nu꞊o, 'kɩ Nyɩsʋa nɛɛ 'lɩ ‑Juukʋɛ 'mʋ, 'ɛ wɛ nyibli. ");
INSERT INTO ktj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","24","Ti di 'ʋ 'nɩ nyre, 'tɩ‑, ɛ ‑wɛ 'ʋ nyinyre ‑mɔ, ‑ɛ kɔ 'yri Nyɩsʋa a ‑Hihiu* di 'ʋ nyibli 'klɩ ‑nyii ‑nɩ, ‑ɛ di꞊e nu, ʋ 'mʋ Nyɩsʋa da, 'kɩ 'ʋ 'a ‑nɛ ‑tɩtɛ ꞊dʋ. Nyɩsʋa a ‑Hihiu, nɔ‑ tʋɛ nyibli ‑tɩ a ‑tɛɛ. ‑Tɛ ‑aan 'Baɩ Nyɩsʋa ‑hʋɛ nyibli bʋ nu 'a dɩda, kɛ‑ ɛ nɩ 'mʋ. Nyɩsʋa mɔ ‑Hihiu ꞊nɩɔ. Nyibli ‑mʋ', ‑ʋ ‑hʋɛ ‑bʋ da Nyɩsʋa, Nyɩsʋa a ‑Hihiu kɔ bʋ nɩ 'ʋ ꞊nʋ ke'. Nyɩsʋa a ‑Hihiu a 'mʋ, ɛ tʋɛ ꞊nɛ꞊ɛ ‑tonyibli, ‑tɛ ‑mʋ', Nyɩsʋa a 'mʋ, ɛ nɩ 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","‑Ɛ ‑bɩ nʋgba a 'mʋ, ɛ wɛn: «'N yi꞊e nɩ, ‑ɛ mɔ, Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ‑a mʋ yɩ ya, ɛ kɔ bʋ di. 'Bʋ ‑di, ɛ nɔ‑ di ‑a mʋ ‑tɛblɩ a pɛpɛ klɛ ‑hɩhɩa ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","‑Ɛ ‑bɩ ‑Yusu wɛn: «'Mɔ, nɔ‑ ‑bʋ, ‑ɛ kɔ ‑mʋ 'hʋɛn‑ ‑yɩ hle.» ");
INSERT INTO ktj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ ‑Yusu a ‑nagbopʋ, ‑ʋ mu wɛn 'dɩɔ, ʋ nyre 'ʋ nɩ. Ɛ mɔ 'waa ꞊wlɩlɛkɛɛdɛ, ‑tɛ ‑Yusu kɔ nʋgba 'hʋɛn‑, ʋ pɩ toto. Kɛɛ, 'waa nyiblo ꞊dʋ 'yɩ 'bɛti ‑nɩ, ‑ɛ mɔ: «‑Tɩ a 'dɩ ‑bɩ ‑yɩ꞊ɩ 'bɛti ‑nɩ 'lɩ?» ɛ kɔ, «‑Tɩ a 'dɩ ‑bɩ, ɛ kɔ ‑mʋ 'hʋɛn‑, a hlɛ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nʋgba ‑mɔ ‑bɩ, ɛ hie 'ʋ 'a 'nɩya bʋ, 'ɛ gba cigbɛ 'dɩɔ, 'ɛ lee nɛ 'a nyibli, ‑ɛ mɔ: ");
INSERT INTO ktj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Ba di 'lɩ, a 'mʋ nyiblo ꞊dʋ 'ye. Nɔ‑ lee 'mʋ, ‑tɛblɩ a pɛpɛ ‑mʋ', 'n ‑nu. ꞊Bɩ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ‑a mʋ yɩ ya, ɛ nɔ‑ ꞊nɩɔ a 'gbɛ?» ");
INSERT INTO ktj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nɔ‑ mɔ nyibli a 'mʋ bʋ ‑hɔn 'lɩ 'dɩɔ 'kwli, bʋ mu 'lɩ꞊ɩ 'hʋɩ. ");
INSERT INTO ktj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","‑Tɛ nyibli a 'mʋ, ʋ 'yɛ nɩ nyre, ‑ɛ ‑bɩ ‑Yusu a ‑nagbopʋ ‑tʋa ‑Yusu a lɛnyaalɛ, ʋ wɛn: «Tɔɔnyɔ o, di dɛ 'tɩ‑.» ");
INSERT INTO ktj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kɛɛ, ɛ ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «'N kɔ diidɛ ꞊dʋ, a 'yɩ ‑yi.» ");
INSERT INTO ktj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","‑Ɛ ‑bɩ 'a ‑nagbopʋ ‑tʋa 'waa dɩɔnʋ a lɛ'bɛtilɛ, ʋ wɛn: «꞊Bɩ nyiblo ꞊dʋ ya꞊a diidɛ yɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","‑Ɛ ‑bɩ ɛ wɛn: «'Na diidɛ, nɔ‑ mɔ ꞊bʋ nu Nyɩsʋa, ‑ɛ lee 'nɛ‑ 'mʋ 'klɔ kɩ a kɩwɛɛnlɛ, ɛ ꞊hɛn 'nyrɛ, ‑kʋan ‑mʋ', ɛ ‑nyi 'mʋ, ꞊bʋ nu, ꞊bʋ ‑yra꞊a 'lu. ");
INSERT INTO ktj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","‑A 'blikʋɛ wɛn 'nɩ: ꞊Nɩ 'dɔ ‑kʋbʋ, ꞊hɔnpʋɩ nɩ ‑hɛn 'bʋ ꞊cɛ, ‑ɛ ‑bɩ ‑yɩ꞊ɩ 'nɩ 'cɛ. Kɛɛ, 'mɔ ‑bɩ, 'n yɩ 'a mʋ 'nɩ ‑lee ‑nɩ: Ba 'du 'lu ye', ba ta 'lɩ ‑ci klɛ. ‑Kʋbʋ ‑wɛ ꞊huhluo ‑mɔ. Ɛ ‑wɛ 'lɩ 'cɩcɛ.» (Ɛ 'wɩ yɩ, nyibli ‑mʋ', ‑ʋ mi 'lɩ꞊ɩ 'hʋɩ, ‑ʋ ‑wɛ ‑mɔ, 'kɩ ‑bʋ kɔ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ, ʋ nʋ‑ kɔ ‑tɩ ɛ hlɛ.) ");
INSERT INTO ktj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","«‑Kʋannunyɔ ‑mʋ', ‑ɛ yɩ ‑kʋbʋ 'cɛ, ɛ kɔ 'a ‑nɛ 'pɛɛlɛ nɩ. 'A ‑kʋan a 'mʋ, ɛ nɔ‑ ni꞊e, nyibli 'ʋ kʋɛ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ. ‑Ɛ ‑bɩ 'kɩ, nyiblo ‑mʋ', ‑ɛ 'dʋɛ ‑kʋbʋ, ɛ kɔ nyiblo ‑bɩ ‑mʋ', ‑ɛ yɩ꞊ɩ 'cɛ, ʋ di bibi 'yi lɛ, ʋ 'mʋ dɔdʋ nu. ");
INSERT INTO ktj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","'Ledʋ ‑mʋ', ‑ɛ pɩ lɛ, ‑ɛ mɔ: ‑Ʋ ‑bɩ 'dʋɛ ‑kʋbʋ, ‑ʋ ‑bɩ 'ʋ yɩ꞊ɩ 'cɛ, ɛ mɔ ‑tɩ a ‑tɛɛ ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","‑Ci ‑bɩ, ‑ɛ kɔ ‑kʋan a 'yɩ ‑nu, ‑ɛ kɔ kɩ 'n lee 'lɩ 'a mʋ, ɛ nɔ‑ kɔ ‑kʋbʋ a yɩ 'kɩ 'cɛ. Nyibli ‑bɩ, nʋ‑ nu ‑ci a 'mʋ a ‑kʋan, 'a mʋ ‑mɔ ‑bɩ, 'a yɩ 'kɩ 'a ‑kʋbʋ 'cɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samalikʋɛ ‑nɩ wɛn, ‑ʋ nɩ 'lɩ Sisalɩdɩɔ ‑nɩ wɛn 'kwli, 'waa nyibli ‑hʋɔhʋɩ, nʋ‑ kuo ‑Yusu ꞊wlʋ yɩ, ‑kɔtɩ kɛ‑ nʋgba ‑mʋ', ɛ pʋ ꞊nʋ yɩ: «Nyiblo ‑bʋ, ɛ nɔ‑ lee 'mʋ ‑tɛblɩ a pɛpɛ ‑mʋ', 'n ‑nu, 'kɩ 'lɩ 'na 'klɔ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ɛ nɔ‑ kɔ ‑tɩ, ‑tɛ Samalikʋɛ a 'mʋ, ʋ nyre 'kɩ 'ʋ ‑Yusu 'hʋɩ, 'ʋ ‑tʋa 'a lɛnyaalɛ, 'kɩ bʋ nɩ 'lɩ ꞊nʋ ‑mɔ, 'ɛ mɔ ꞊han‑tɩ, ɛ ‑wɛn, 'ɛ ‑hi 'ʋ ꞊nʋ ‑nyrɔwɩ nɩ 'hʋɛn 'hʋɩ. ");
INSERT INTO ktj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nyibli ‑hʋɔhʋɩ ‑bɩ kuo ‑Yusu ꞊wlʋ yɩ, 'kɩ 'ʋ ‑tɩ ‑mʋ', ɛ ‑hla a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kɛ‑ ʋ pɩ 'kɩ nʋgba 'a mʋ yɩ, ‑ɛ mɔ: «Ɛ 'yɩ ‑tɩ ‑bʋ, ‑lee nɛ ‑a mʋ ‑tɛ ti nɛ ‑bʋ a ‑tɩ 'pa‑, ‑a 'yɩ꞊ɩ ꞊wlʋ yɩ kuo ‑nɩ. Kɛɛ, ‑aan ꞊gbɛtʋ, ‑a 'wɩn 'a win nɩ, ɛ nɔ‑ kɔ ‑tɩ, ꞊a kuo ꞊nɛ ꞊wlʋ yɩ, 'tɩ‑ ꞊hɩan ‑mɔ de, ‑a kɔ 'a yiyie, ‑ɛ mɔ, ɛ nɔ‑ mɔ Wanyɔ, ‑ɛ ‑wɛ 'klɔ ‑bʋ a nyibli.» ");
INSERT INTO ktj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","‑Tɛ ɛ ‑hi 'ʋ ‑nyrɔwɩ nɩ 'hʋɛn ‑tɩtɛ a 'mʋ, ‑ɛ ‑bɩ 'kɩ ɛ mu 'lɩ Galileblʋgba 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","'A ꞊gbɛtʋ, ɛ hla la꞊a nɩ, ‑ɛ mɔ: «Nyɩsʋa a winwlɔn‑hanyɔ* 'bʋ nɩ 'lɩ 'a 'blikʋɛ 'nyɩ, ɛ 'yɩ 'lɩ 'ʋ꞊tuulɛ ‑kɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kɛɛ, Galileblʋgba a nyibli a 'mʋ, ʋ mu la lɛ'mimle, ‑ɛ mɔ Pakɩ kɩ, 'kɩ 'lɩ Jrusrɛdɩɔ 'kwli, 'ʋ 'ye la ‑tɛblɩ a pɛpɛ ‑mʋ', ‑Yusu nu la. Ɛ nɔ‑ nu꞊o, ‑tɛ ‑Yusu nyre 'lɩ Galileblʋgba 'kwli, nyibli a 'mʋ, 'ʋ 'ble꞊e kʋa ‑tɛɛ. ");
INSERT INTO ktj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","‑Ɛ ‑bɩ 'kɩ ɛ mu 'lɩ 'dɩɔ ‑mʋ', ‑ɛ mɔ Kana 'kwli. 'Dɩɔ a 'mʋ, ɛ nɔ‑ kɔ 'kwli ɛ nuu la 'lɩ 'a yɩ‑hɛ꞊wlɩlɛkɛɛdɛ, 'nie 'ɛ ‑hɛ la ‑wiin. Ɛ kɔ la nyɩbɛhɩan ꞊dʋ. Ɛ mɔ la 'blʋgba a 'kɩɩn a ‑kʋannunyɔ gbagbʋ ꞊nɩɔ la, 'ɛ nɩ la 'lɩ Kapɛnaɔdɩɔ 'kwli, 'kɩ 'lɩ Galileblʋgba a 'mʋ 'kwli. Nyɩbɛhɩan a 'mʋ, ɛ kɔ la 'yu nyɩbɛhɩan. 'Yu nyɩbɛhɩan a 'mʋ, ɛ nɔ‑ kɔ 'hʋɩ ‑yɩ la hren. ");
INSERT INTO ktj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","‑Tɛ nyiblo gbagbʋ a 'mʋ, ɛ 'wɩn, ‑ɛ mɔ, 'kɩ ‑Yusu ‑hɔn 'lɩ Sudeblʋgba 'kwli, 'ɛ mu 'lɩ Galileblʋgba 'kwli, ‑ɛ ‑bɩ ɛ ‑hɔn 'lɩ 'a 'dɩɔ 'kwli nɩ, 'ɛ mu 'lɩ ‑Yusu ‑mɔ, 'ɛ ‑tʋa 'a lɛnyaalɛ, ɛ wɛn: «'N nyaa ‑mʋ lɛ, di 'lɩ 'na 'dɩɔ Kapɛnaɔ 'kwli, ꞊mʋ꞊ʋ nu, 'na 'yu a 'kʋɛ 'mʋ ‑wɛ. Ɛ ‑hʋɛ bʋ 'kʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ꞊ɩ yɩ, ɛ wɛn: «'Bʋ mɔ, 'ba 'yɛ nɩ 'ye ꞊wlɩlɛkɛɛ‑tɛblɩ gbagbɩ ‑mʋ', 'n ni, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba kuo 'mʋ ꞊wlʋ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","‑Ɛ ‑bɩ nyiblo gbagbʋ a 'mʋ, ɛ ꞊tu꞊o ꞊wɔn, ɛ wɛn: «Tɔɔnyɔ o, di 'lɩ 'na 'dɩɔ 'kwli, 'na 'yu 'nɩ ꞊ha 'kʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","‑Ɛ ‑bɩ ‑Yusu yɩ꞊ɩ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ: «‑Wɛ 'lɩ ‑bʋ mu nɩ. ‑Na 'yu 'tɩɛ di 'klɔ nɩ.» ‑Tɩ a 'mʋ, ‑Yusu lee ꞊nɛ, ɛ kuo ꞊nɛ ꞊wlʋ yɩ, 'ɛ ‑mu. ");
INSERT INTO ktj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ɛ nɩ 'hru wlɔn, 'a ‑kʋannunyibli 'ʋ di꞊e ye' 'bɛ mɔ, 'ʋ lee ꞊nɛ: «‑Na 'yu nɩ 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","‑Ɛ ‑bɩ ɛ 'bɛti ꞊nʋ nɩ, ɛ wɛn: «Ti a 'dɩ ‑bɩ ‑kɔ 'yri 'a 'hʋɩ 'kee ‑nɩ 'lɩ?» ‑Ɛ ‑bɩ ʋ wɛn: «‑Tɛ ‑dina bi 'tʋ 'lɩ, 'a ‑haawɔ nɩ ‑do ‑hi 'tʋ, 'kɩ 'a 'hʋɩ 'kee 'tʋ 'ʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","‑Ɛ ‑bɩ ɛ 'ye꞊e nɩ, ‑ɛ mɔ, ti ‑mʋ' ‑kɔ 'yri ‑Yusu lee 'tʋ 'ʋ꞊ʋ, ‑ɛ mɔ, 'a 'yu 'tɩɛ di 'klɔ nɩ, ti nɩ ‑do a 'mʋ 'yri, 'kɩ 'a 'yu a 'mʋ a 'hʋɩ 'kee 'tʋ 'ʋ ‑nɩ. Ɛ nɔ‑ mɔ, ɛ kɔ 'a 'kayubʋkʋɛ 'hʋɛn‑, bʋ kuo ‑Yusu ꞊wlʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","‑Yusu bʋ ‑hɔn 'lɩ Sudeblʋgba 'kwli, bʋ mu 'lɩ Galileblʋgba 'kwli, bʋ nu ꞊wlɩlɛkɛɛ‑tɛblɩ, 'a 'wɩ nɩ 'hʋɛn a dɛ, nɔ‑ ‑bʋ. ");
INSERT INTO ktj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Juukʋɛ* mi lɛ'mimle kɩ, 'kɩ 'lɩ Jrusrɛdɩɔ 'kwli. 'Kɩ 'lɩ ‑tɛ a 'mʋ, 'kɩ ‑Yusu mu 'lɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Paalɛ ꞊dʋ nɩ 'ʋ, 'ʋ dɛɛ ꞊nɛ Blablɛ a Paalɛ. Ɛ nɔ‑ kɔ 'yri ʋ nɛɛ 'ʋ, 'ʋ pʋɛ 'lɩ Jrusrɛdɩɔ 'kwli. 'Kɩ 'ʋ paalɛ a 'mʋ 'hʋɩ, 'kɩ 'wlo ꞊dʋ, nyibli 'blu la, ɛ nɩ 'ʋ. 'Wlo a 'mʋ, 'a 'nyrɛ mɔ Betesada, 'kɩ 'lɩ ‑Juukʋɛwin 'kwli. Ɛ nɔ‑ kɔ wien, ʋ pʋ 'ʋ papʋɩ nɩ ꞊hun. ");
INSERT INTO ktj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","'Kɩ 'lɩ papʋɩ a 'mʋ bʋ, 'hʋɩhrennyʋ ‑hʋɔhʋɩ, nʋ‑ pɛ 'lɩ blɛ, 'yii'dɔnyʋ, bʋɩklanyʋ, kɔ lɛ‑yɩyrɛnyʋ. Dɛ, ʋ yɩ ‑ple, ɛ nɔ‑ mɔ, 'nie bʋ ꞊gbuta ‑nɩ, ");
INSERT INTO ktj_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","‑kɔtɩ ɛ kʋɛ ti, Nyɩsʋa a lɛlenyɔ ꞊dʋ, 'ɛ yɩ 'lɩ ꞊tɩɩ ‑nɩ, 'ɛ yɩ꞊ɩ ꞊gbuta ‑nɩ. 'A ‑nɛ ti, Nyɩsʋa a lɛlenyɔ 'bʋ ꞊gbuta꞊a, yɩ‑hɛhʋɩhrennyɔ, ‑ɛ di 'lɩ ꞊tɩ, 'ye ꞊bɩɩ ‑tɛ 'a 'kʋɛ nɩ 'mʋ, ɛ kɔ bʋ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ti nɩ ‑do a 'mʋ 'yri, ɛ kɔ 'hʋɩhrennyɔ ‑bɩ, 'ɛ nɩ 'lɩ 'a 'bio 'nyɩ. ‑Tɛ 'a 'hʋɩ ‑tʋa la 'lɩ hinhren, ɛ ‑wɛ 'lɩ 'hrɩ a (38) ‑wlʋ ꞊tu 'ʋ ‑pu ꞊tu 'ʋ ꞊blɩɛn꞊blɩɛn nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","‑Tɛ ‑Yusu nyre 'ʋ, ‑ɛ ‑bɩ ɛ 'ye nyiblo a 'mʋ nɩ, ‑ɛ pɛ bʋ. Ɛ yi꞊e nɩ, ‑ɛ mɔ, ‑tɛ 'a 'hʋɩ ‑tʋa la 'lɩ hinhren, ɛ ‑wlɛn 'ʋ bʋ. ‑Ɛ ‑bɩ ɛ 'bɛti꞊e nɩ, ɛ wɛn: «꞊Bɩ ‑hʋɛ꞊ɛ nɩ, ‑na 'kʋɛ bʋ ‑wɛ?» ");
INSERT INTO ktj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","‑Ɛ ‑bɩ 'hʋɩhrennyɔ a 'mʋ, ɛ wɛn: «Tɔɔnyɔ o, 'n 'yɩ nyiblo ꞊dʋ ‑kɔ, ‑bʋ ꞊tɩɔ 'lɩ 'mʋ 'nie ‑mɔ, ti ‑mʋ' ‑kɔ 'yri ɛ yɩ ꞊gbuta ‑nɩ. 'Bʋ mɔ, 'nɩ ‑hʋɛ ꞊bʋ ꞊tɩ wɛn 'lɩ, ‑ɛ ‑bɩ nyiblo ‑bɩ ‑hi 'mʋ ye'.» ");
INSERT INTO ktj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kɛ‑ ‑Yusu pɩ 'kɩ, ɛ wɛn: «'Du ye', ‑bʋ 'du ‑na kɔ ye', ꞊mʋ na.» ");
INSERT INTO ktj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ 'a 'kʋɛ ‑wɛ nɩ, 'ɛ 'du 'a kɔ ye', 'ɛ ‑tʋa nɩna. Kɛɛ, dɛ a 'mʋ, ‑Juukʋɛ a ‑wuwle‑nyrɔwɔ* 'kwli, 'kɩ ɛ mu la 'lɩ 'lu ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","‑Juukʋɛ a ye'nanyʋ, ʋ 'ye nyiblo a 'mʋ nɩ, ‑ɛ kɔ 'kʋɛ ‑wɛ, 'ʋ lee ꞊nɛ, ʋ wɛn: «Kɩkɛ a ‑nyrɔwɔ ‑bʋ, ɛ mɔ kɛ ‑wuwle‑nyrɔwɔ. 'A ‑tɩ, ꞊yɩ wɛn yɩ ‑blɛɛ ‑nɩ, ‑bʋ 'ble wɛn ‑na kɔ ‑wuwle‑nyrɔwɔ a 'mʋ, ɛ mɔ ‑kʋan ꞊nɩɔ, 'tɩ‑ ɛ ꞊ŋa nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","‑Ɛ ‑bɩ ɛ wɛn: «Nyiblo ‑mʋ', ‑ɛ nu꞊o, 'na 'kʋɛ, 'ɛ ‑wɛ, ɛ nɔ‑ lee 'mʋ, ꞊bʋ 'du 'na kɔ ye', ꞊bʋ na.» ");
INSERT INTO ktj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","‑Ɛ ‑bɩ ʋ wɛn: «Nyiblo a 'dɩ ‑bɩ, ‑ɛ lee ‑mʋ, ‑bʋ 'du ‑na kɔ ye', ‑bʋ na 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nyiblo a 'mʋ, ‑ɛ kɔ 'kʋɛ ‑wɛ, ɛ 'yɩ ‑Yusu ‑yi, ‑ɛ nu꞊o, ‑Yusu mu nɩ 'wʋwlɩ, nyibli ‑hʋɔhʋɩ ‑mʋ', ‑ʋ nɩ 'ʋ a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","‑Tɛ ɛ gba ti gbi, ‑ɛ ‑bɩ 'kɩ ‑Yusu yɛɛ 'lɩ꞊ɩ Nyɩsʋa a 'kagbaʋ bʋ. Kɛ‑ ɛ pɩ꞊ɩ yɩ, ɛ wɛn: «'Ye kɛ, ‑na 'kʋɛ ‑wɛ nɩ. ꞊Nɩ 'nuo 'kɩ dɛ 'kuku de, ‑ɛ di꞊e nu, ꞊hɩʋɛn a 'yiye ‑bʋ, ‑ɛ ‑hi 'a dɛ ‑bʋ wlɔn, ɛ 'nɩ ꞊ha ‑mʋ nu de.» ");
INSERT INTO ktj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","‑Ɛ ‑bɩ nyiblo a 'mʋ, ɛ mu nɩ, 'ɛ lee ‑Juukʋɛ a ye'nanyʋ, ‑ɛ mɔ, ‑Yusu, nɔ‑ nu꞊o, 'a 'kʋɛ 'ɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kʋɛ 'ʋ ti a 'mʋ 'yie bʋ, ‑ɛ ‑bɩ ʋ ‑tʋa ‑Yusu a bʋɩ a lɛ꞊mʋmʋɔ, ‑tɛ ɛ nu꞊o, nyiblo a 'kʋɛ 'ɛ ‑wɛ, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ɛ nɔ‑ mɔ ‑Yusu bʋ ‑hɩhɩa ꞊nʋ klɛ, ‑ɛ mɔ: «'A ‑nɛ ti, 'na 'Baɩ ni ‑kʋan. 'Na 'mumu, dɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ 'n ni.» ");
INSERT INTO ktj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","‑Tɛ ‑Yusu pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ‑Juukʋɛ a ye'nanyʋ a 'mʋ, ʋ ꞊mʋɛ 'hru lɛ de, 'kɩ bʋ 'la꞊a, ‑ɛ nu꞊o, ɛ hla꞊a nɩ de, ‑ɛ mɔ, Nyɩsʋa, nɔ‑ mɔ 'a 'Baɩ, ɛ ꞊hɛn 'nyrɛ, ɛ wɛn 'nɩ, ɛ kɔ Nyɩsʋa 'hʋɛn‑, ʋ wɛɛn nɩ. Ɛ 'yɩ bʋ 'wla ‑wuwle‑nyrɔwɔ a tete nɩ ‑do a ‑tɩ 'pa‑, ʋ 'nɩ ꞊mʋɔ꞊ɔ lɩ 'a 'lɩla lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","‑Tɩ ‑mʋ', ‑Juukʋɛ* a ye'nanyʋ yɩ ‑Yusu ‑yɛɛ ‑nɩ, ɛ nɔ‑ ɛ ‑hɩhɩɛ ꞊nʋ klɛ, ɛ wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, 'mɔ ‑bʋ, ‑ɛ mɔ Nyɩsʋa a 'Yu, 'n 'yɩ 'lɩ ꞊dedede a nunuo 'lɩ ‑wɛ, 'mɔ nɩ ‑do. Dɛ ‑mʋ', 'n yɩ 'ye, 'na 'Baɩ ni, ɛ nɔ‑ 'na 'mumu, 'n ni ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","'Ɛ mɔ ꞊han‑tɩ, 'na 'Baɩ 'ɛ nʋɛ 'mʋ. 'A ‑tɩ, ‑tɛblɩ a pɛpɛ ‑mʋ', ɛ ni, ɛ tʋɛ 'mɔ꞊ɔ nɩ. Ɛ di 'mʋ 'nɩ ‑lee ‑nɩ, ꞊bʋ nu ꞊wlɩlɛkɛɛ‑tɛblɩ ‑bɩ, ‑ɛ ‑hi 'ʋ 'a dɛ ‑bʋ 'ʋ, 'n nu 'kɩ, ‑tɛ ti nɛ ‑bʋ 'kwli, ɛ 'mʋ 'a mʋ lɛ ‑kɛɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ɛ 'wɩ‑ ‑tɛ 'na 'Baɩ ni, 'ɛ ‑hɛ 'lɩ nyibli 'kʋkʋnyibli 'nyɩ, 'ɛ ‑hɛ ꞊nʋ 'klɔ lɛ, kɛ‑ 'n ni, nyibli ‑mʋ', 'n ‑hʋɛ ꞊bʋ ‑nyi 'klɔ yrayrʋ, 'nɩ yɩ ꞊nʋ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","'Ya 'ʋ 'lu de, 'na 'Baɩ 'nɩ ‑pʋʋ꞊ʋ nyiblo ꞊dʋ ‑bati lɛ, kɛɛ, ɛ ‑nyi 'mʋ 'klɩ a pɛpɛ nɩ, 'kɩ ꞊bʋ pʋʋ nyibli ‑bati lɛ, ");
INSERT INTO ktj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","‑ɛ di꞊e nu, nyibli a pɛpɛ 'mʋ 'ʋ 'mʋ 'ʋ ꞊tuu ‑nɩ, ꞊wɩ yɩ, ‑tɛ ʋ ni 'ʋ 'na 'Baɩ a 'ʋ꞊tuulɛ. Nyiblo ‑bʋ, ‑ɛ 'yɛ nɩ ꞊tuu 'ʋ 'mʋ 'ʋ, 'na 'Baɩ ‑mʋ', ‑ɛ lee 'nɛ‑ 'mʋ 'klɔ kɩ, ɛ nɔ‑ ɛ 'yɛ nɩ ꞊tuu 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ: Nyiblo 'bʋ nɩ 'ʋ, 'bʋ pʋ 'na win nʋa yɩ bʋ, kɔ, 'bʋ kuo 'na 'Baɩ Nyɩsʋa ꞊wlʋ yɩ, ‑ɛ lee 'nɛ‑ 'mʋ ‑tʋtʋ kɩ, nyiblo a 'mʋ, ɛ nɔ‑ kɔ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ. ‑Bati 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ klɔ 'kɩ꞊ɩ de, kɛɛ, ɛ ‑hɔn kɛ 'lɩ 'kʋkʋʋ wlɔn, 'ɛ pa 'lɩ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ, ti di 'ʋ 'nɩ nyre, 'ɛ ‑wɛ 'ʋ nyinyre ‑mɔ ‑dodo, ‑ɛ kɔ 'yri 'kʋkʋnyibli di 'ʋ 'mɔ ‑bʋ, ‑ɛ mɔ Nyɩsʋa a 'Yu a win 'ʋ 'wɩɩn ‑nɩ, ɛ kɔ, nyibli ‑mʋ', ‑ʋ nɩ 'klɔ, ‑ʋ di 'na win 'wɩn, ʋ di kɔ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","'Na 'Baɩ kɔ 'klɩ, 'kɩ bʋ nu꞊o, nyibli bʋ nɩ 'klɔ. 'Klɩ nɩ ‑do a 'mʋ, ɛ nɔ‑ ɛ ‑nyi 'mʋ, ‑ɛ di꞊e nu, 'mʋ nyibli 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ ‑nyi, ");
INSERT INTO ktj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'ɛ ‑nyi 'mʋ 'klɩ ‑wɛ, 'kɩ ꞊bʋ pʋʋ nyibli ‑bati lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ɛ 'nɩ 'kɛɛ 'lɩ 'aan ꞊wlɩ lɛ, ‑kɔtɩ ti di 'ʋ 'nɩ nyre, ‑ɛ kɔ 'yri nyibli a pɛpɛ ‑bʋ, ‑ʋ 'kʋ, ʋ ꞊tu, ʋ di 'ʋ 'na win 'ʋ 'wɩɩn ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","'Bʋ 'wɩn 'na win a 'mʋ, ʋ di ‑hɔn 'lɩ 'dabi 'kwli lɛ. Nyibli ‑mʋ', ‑ʋ nu ꞊haandɛ, ʋ di kɔ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ, kɛɛ, nyibli ‑mʋ', ‑ʋ nu ‑tɛblɩ ‑hʋɩn, ‑bati di ꞊nʋ 'nɩ klɔ. ");
INSERT INTO ktj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","'Mɔ nɩ ‑do, 'n 'yɩ 'lɩ ꞊dedede a nunuo 'lɩ ‑wɛ, Nyɩsʋa 'bʋ 'yɩ 'mʋ 'a 'klɩ ‑nyi. 'Bʋ mɔ, 'nɩ yɩ nyiblo ꞊dʋ a ‑bati nɩ 'bɛ, ‑tɛ Nyɩsʋa nu꞊o 'na leelɛ, kɛ‑ 'n di꞊e nu. 'N pɩ ‑tɛɛ a ‑bati, ‑ɛ nu꞊o, Nyɩsʋa, nɔ‑ lee 'nɛ‑ 'mʋ ‑tʋtʋ kɩ, dɛ ɛ ‑hʋɛ ꞊bʋ nu, ɛ nɔ‑ 'n ni ‑tɛɛ. Ɛ 'yɩ dɛ, 'na ꞊gbɛtʋ, 'n ‑hʋɛ 'pa‑, 'nɩ ‑nu꞊o lɩ꞊ɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kɛ‑ ‑Yusu pɩ de: «'Bʋ mɔ, 'mɔ nɩ ‑do, 'nɩ yɩ wɛn꞊ɛ nɩ hlɛ, nyiblo a 'dɩ ‑bɩ 'n pa 'mʋ, ‑ɛ ‑bɩ nyibli 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ yru wɛn꞊ɛ, ‑ɛ mɔ, 'n hlɛ wɛn ‑tɩ a ‑tɛɛ. ");
INSERT INTO ktj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kɛɛ, Nyɩsʋa, nɔ‑ hlɛ꞊ɛ, nyiblo a 'dɩ ‑bɩ 'n pa 'mʋ, 'tɩ‑ 'n yi꞊e nɩ, ‑ɛ mɔ, ‑tɩ ‑mʋ', ɛ hlɛ, 'kɩ 'ʋ 'mʋ kɩ, ɛ mɔ ‑tɩ a ‑tɛɛ ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","'A mʋ ‑mɔ ‑bɩ, a tɛ nyibli bʋ, 'ʋ mu 'lɩ Saan Batisɩ ‑mɔ, 'ɛ lee nɛ 'a mʋ ‑wɛ, nyiblo a 'dɩ ‑bɩ 'n pa 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ɛ 'yɩ 'nyrɛ ꞊hɛn, ‑ɛ mɔ, 'n ꞊mʋɛ nyiblo lɛ, ‑ɛ hlɛ꞊ɛ, nyiblo a 'dɩ ‑bɩ 'n pa 'mʋ. Kɛɛ, 'n ni꞊e nɩ, ‑ɛ di꞊e nu, a 'mʋ Saan a dɛ 'lu ‑mɔ lɛ ‑hie, a 'mʋ꞊ʋ lɛ yru, ‑ɛ mɔ, Nyɩsʋa ‑hʋɛ bʋ wa 'a mʋ. ");
INSERT INTO ktj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Saan a 'mʋ, ɛ 'wɩ la 'napɩ yɩ, ‑ɛ yɩ la wlɩn, ‑ɛ di꞊e nu, nyibli 'mʋ la lɛ yru. 'Kɩ 'lɩ ti gbi 'kwli, a ni la dɔdʋ, 'kɩ 'ʋ dɛ a 'mʋ 'a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ɛ kɔ ‑tɛblɩ ‑bɩ, 'ɛ nɩ 'ʋ, 'ɛ ‑hi Saan a pʋpʋwin wlɔn. Nɔ‑ mɔ ꞊wlɩlɛkɛɛ‑tɛblɩ ‑mʋ', 'n ni, 'kɩ 'lɩ 'na 'Baɩ a 'klɩ 'kwli. ꞊Wlɩlɛkɛɛ‑tɛblɩ a 'mʋ, ɛ tʋɛ ꞊nɛ yɩ, ‑ɛ mɔ, 'na 'Baɩ, nɔ‑ lee 'nɛ‑ 'mʋ 'klɔ ‑bʋ kɩ. ");
INSERT INTO ktj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","'Tɩ‑ 'na 'Baɩ a 'mʋ, ‑ɛ lee 'nɛ‑ 'mʋ, ɛ hlɛ꞊ɛ nɩ ‑wɛ, nyiblo a 'dɩ ‑bɩ 'n pa 'mʋ. A 'yɩ ‑hʋan 'a win nɩ 'wɩn, kɔ, a 'yɩ ‑hʋan꞊a nɩ 'ye ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","A 'nɩ ꞊tuu꞊o lɩ 'a win bʋ, 'kɩ 'lɩ 'aan ꞊wlɩ kɩ, ‑tɛ a 'yɩ 'mʋ ꞊wlʋ yɩ ‑kuo ‑nɩ a ‑tɩ, 'mɔ ‑bʋ, ɛ lee 'nɛ‑ 'klɔ ‑bʋ kɩ. ");
INSERT INTO ktj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","A yɩ Nyɩsʋacrɩɩn 'nɩ 'nyɩ, ‑ɛ nu꞊o, a yi꞊e nɩ, ‑ɛ mɔ, ɛ nɔ‑ tʋɛ nɛ 'a mʋ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ. Ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, Nyɩsʋacrɩɩn a 'mʋ, nʋ‑ hlɛ 'na ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kɛɛ, a 'nɩ ‑hʋa꞊a ba di 'nɛ‑ 'mʋ ‑mɔ, ‑ɛ di꞊e nu, 'mʋ 'a mʋ 'klɔ yrayrʋ a 'mʋ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","A wɛn 'nɩ, ‑ɛ mɔ, 'mɔ ꞊mʋɛ꞊ɛ lɛ, 'kɩ nyibli bʋ 'yaa 'lɩ 'na 'nyrɛ. Kɛɛ, ɛ 'yɩ 'mʋ lɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","'A mʋ ‑mɔ ‑bɩ, a nɩ 'dɔ. 'N yi꞊e nɩ, ‑ɛ mɔ, 'kɩ 'lɩ 'aan ꞊wlɩ kɩ, a 'yɩ Nyɩsʋa ‑nʋɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","'Na 'Baɩ lee 'nɛ‑ 'mʋ 'a mʋ 'nyɩ, kɛɛ, a 'nɩ ‑hʋa꞊a lɩ ba 'ble 'mʋ kʋa. Kɛɛ, nyiblo 'bʋ ‑di, 'kɩ 'lɩ 'a dɩɔnʋ a 'klɩ 'kwli, ‑ɛ ‑bɩ a 'ble꞊e kʋa. ");
INSERT INTO ktj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Dɛ a nʋɛ ‑nɩ, ɛ nɔ‑ mɔ 'aan 'bio bʋ 'yaa 'lɩ 'aan 'nyrɛ. Kɛɛ, a 'nɩ ꞊mʋɔ꞊ɔ lɩ꞊ɩ lɛ, 'kɩ Nyɩsʋa ‑mʋ', ‑ɛ mɔ Nyɩsʋa nɩ ‑do, bʋ 'yaa 'lɩ 'aan 'nyrɛ. 'Bʋ mɔ, 'ba nɩ 'mʋ lɛ, ‑ɛ ‑bɩ a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba kuo 'mʋ ꞊wlʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kɛɛ, a 'nɩ 'yee 'lɩ꞊ɩ, ‑ɛ mɔ, 'n di yɛɛ nɛ 'a mʋ ‑tɩ, 'kɩ 'ʋ 'na 'Baɩ ye'. 'A winwlɔn‑hanyɔ* Moise ‑mʋ', a kuo ꞊wlʋ yɩ, nɔ‑ di 'a mʋ ‑tɩ ‑yɛɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","'Bʋ mɔ, 'bʋ mɔ wɛn ꞊han‑tɩ, 'ba kuo wɛn Moise ꞊wlʋ yɩ, a di kuo wɛn 'mʋ ꞊wlʋ yɩ ‑wɛ, ‑ɛ nu꞊o, Moise 'crɩ 'na ‑tɩ nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kɛɛ, ‑tɩ ‑mʋ', ɛ 'crɩ, ‑tɛ a 'yɩ꞊ɩ ꞊han‑tɩ' ‑pʋ, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba pʋ 'na win ꞊han‑tɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ ꞊ta nɩ, 'kɩ 'lɩ Galileblʋgba a 'yru a 'kɩbɩa ‑bɩ kɩ. 'Yru a 'mʋ, ʋ dɛɛ ꞊nɛ Tibeliadɩ a 'yru; ");
INSERT INTO ktj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","nyibli ‑hʋɔhʋɩ, nʋ‑ yɩ ‑Yusu ꞊wien kʋɛ, ‑ɛ nu꞊o, ꞊wlɩlɛkɛɛ‑tɛblɩ ‑mʋ', ɛ ni mɔ, 'ɛ ni mɔ꞊ɔ, nyibli a 'kʋɛ 'ɛ yɩ mɔ ‑wɛ, ʋ 'ye mɔ꞊ɔ nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","‑Tɛ ‑Yusu kɔ 'a ‑nagbopʋ 'hʋɛn‑, ʋ nyre 'lɩ, ‑ɛ ‑bɩ 'kɩ ʋ 'ya 'lɩ dʋgba 'lu, 'ʋ nɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ti a 'mʋ 'yri, ‑Juukʋɛ* a lɛ'mimle ‑mʋ', ʋ dɛɛ Pakɩ, ɛ 'mʋɛ yrɛ. Ɛ nɔ‑ kɔ ‑tɩ, nyibli ‑hʋɔhʋɩ 'ʋ nɩ ‑tuo kɩ. ");
INSERT INTO ktj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","‑Yusu bʋ 'du 'lu ye', ‑ɛ ‑bɩ ɛ 'ye nyibli ‑hʋɔhʋɩ, 'ʋ yɩ 'ʋ꞊ʋ 'hʋɩ di. ‑Tɛ ɛ 'ye ꞊nʋ, ‑ɛ ‑bɩ ɛ 'bɛti 'a ‑nagbopi Filipʋ nɩ, ɛ wɛn: «‑Bɩ' ‑a di 'kɩ diidɛ yɩ 'yee ‑nɩ, ‑a 'mʋ꞊ʋ ‑tɔ, nyibli a pɛpɛ ‑bʋ, ‑ʋ ‑di, ʋ 'mʋ dɛ di 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ɛ 'bɛti nɩ, ‑ɛ di꞊e nu, ɛ 'mʋ꞊ʋ yi, 'bʋ mɔ, Filipʋ 'bʋ kuo ꞊nɛ ꞊wlʋ yɩ, ‑ɛ nu꞊o, 'tɩ‑ ɛ 'mʋ꞊ʋ 'bɛti mɔ mu, dɛ ɛ di nu, ɛ ‑wɛ 'a yiyie ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","‑Ɛ ‑bɩ Filipʋ wɛn: «Mɔ 'ye ꞊bɩɩ ‑a kɔ wɛn 'wliblɔ, ‑a 'yɩ wɛn 'lɩ꞊ɩ 'lɩ ‑wɛ, ‑ba ‑tɔ wɛn 'flɔɔ, 'a 'kʋtɩɔgbe bʋ di wɛn 'a ‑nɛ nyiblo kɩ yɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","‑Ɛ ‑bɩ ‑Yusu a ‑nagbopi Adre, ‑ɛ mɔ Simɔ Piɛlɩ a 'dɩayɩ, kɛ‑ ɛ pɩ 'kɩ ‑Yusu yɩ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«'Yu nyɩbɛhɩan ꞊dʋ nɩ mɔ, 'ɛ kɔ 'flɔɔkui nɩ ꞊hun kɔ ‑hrin.yɔ nɩ 'hʋɛn. Kɛɛ, ɛ 'yɩ 'lɩ ꞊dedede 'lɩ ‑wɛ, 'kɩ 'ʋ nyibli ‑hʋɔhʋɩ ‑bʋ ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","‑Ɛ ‑bɩ ‑Yusu wɛn: «Ba lee nyibli a pɛpɛ ‑bʋ, bʋ 'plaa blɛ.» 'Kɩ 'ʋ ‑tɩtɛ a 'mʋ, ‑piti ‑hʋɔhʋɩ nɩ 'ʋ. 'Kɩ 'lɩ nyibli a pɛpɛ a 'mʋ 'nyɩ, nyɩbɛpʋ ‑nɩ ‑tuo kɩ, ʋ ‑wɛ 'lɩ 'miliwɩ nɩ ꞊hun nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","‑Tɛ ʋ 'plaa 'kɩ 'ʋ ‑piti kɩ blɛ, ‑ɛ ‑bɩ ‑Yusu 'du 'flɔɔ a 'mʋ ye', 'ɛ ‑nyi Nyɩsʋa 'wio, 'ɛ ꞊gla 'flɔɔ a 'mʋ nyibli lɛ, 'ɛ 'du ‑hrin ye' ‑wɛ, 'ɛ ꞊gla ꞊nʋ꞊ʋ lɛ, nyibli a pɛpɛ a 'mʋ, 'ʋ di 'waa ꞊wlʋ a diidɛ, 'ʋ ꞊mla. ");
INSERT INTO ktj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","‑Tɛ ʋ ꞊mla 'kɩ, ‑ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'a ‑nagbopʋ yɩ: «Ba 'tɩ 'flɔɔkɛtɩ a pɛpɛ ‑mʋ' lɛ, ‑ɛ hie bʋ, 'a ꞊dedede 'nɩ ꞊ha 'wan.» ");
INSERT INTO ktj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","'Flɔɔkui nɩ ꞊hun ‑mʋ', ‑Yusu ‑nu, ɛ ‑wlo, nyibli ‑di, 'a dɛ ‑hie bʋ, ʋ 'tɩ lɛ, ɛ 'yii 'lɩ ‑tʋgbɩ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn. ");
INSERT INTO ktj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","꞊Wlɩlɛkɛɛdɛ ‑mʋ', ‑Yusu ‑nu, ‑tɛ nyibli 'ye꞊e, ‑ɛ ‑bɩ ʋ wɛn: «Ɛ mɔ ꞊han‑tɩ, nyiblo ‑bʋ, ɛ nɔ‑ mɔ Nyɩsʋa a winwlɔn‑hanyɔ* ‑mʋ', Nyɩsʋa pʋ la lɛ, ‑ɛ di la 'nɛ‑ 'klɔ kɩ di.» ");
INSERT INTO ktj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kɛɛ, ‑Yusu yru꞊o nɩ, ‑ɛ mɔ, ʋ di꞊e 'nɩ klɔ, 'kɩ 'lɩ 'klɩke 'kwli, ʋ 'mʋ꞊ʋ bodɩɔdɛ ‑nyi. Dɛ a 'mʋ, ɛ 'yɩ ‑Yusu a kɩwɛɛnlɛ 'pa‑. Ɛ nɔ‑ kɔ ‑tɩ, 'ɛ hlɔɔ ꞊nʋ ‑mɔ lɛ, ɛ nɩ ‑do, 'ɛ mu 'lɩ dʋgba 'lu de. ");
INSERT INTO ktj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","'Yrʋ bʋ mu bʋ pɛ a ti 'yri, ‑ɛ ‑bɩ ‑Yusu a ‑nagbopʋ* mu 'lɩ 'yru wien. ");
INSERT INTO ktj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","'Tɔ yɩ 'nɩ ‑wɔn, ‑Yusu 'yɛ 'lɩ ꞊nʋ 'nyɩ nɩ mi. Ɛ nɔ‑ mɔ bʋ 'ya 'lɩ 'blagbɩ 'kwli, bʋ bli, 'ʋ ꞊tɛ 'yru kɩ, 'ʋ mi 'lɩ 'dɩɔ ‑mʋ', ‑ɛ mɔ Kapɛnaɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Bʋ nɩ 'kɩ 'lɩ 'yru kɩ, ‑ɛ ‑bɩ pepe gbagbʋ yɩ 'nɩ ‑hi, 'yru 'ɛ pɩ 'dʋɩ gbagbɩ, ");
INSERT INTO ktj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","'ʋ bli ‑blibli, 'ʋ nyre 'lɩ ‑kilowɩ nɩ ꞊hun ‑ʋ'ʋ‑ ꞊hlon‑do 'yri. ‑Ɛ ‑bɩ ti nɩ ‑do a ti 'yri, ʋ 'ye ‑Yusu nɩ, 'ɛ nɛ 'yru kɩ, 'ɛ yɩ 'blagbɩ lɛ 'mʋɛ ‑nɩ. Bʋ 'ye 'kɩ꞊ɩ, ‑ɛ ‑bɩ hʋannʋ bi 'lɩ ꞊nʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kɛɛ, ‑Yusu wɛn: «'Mɔ ꞊nɩɔ, a 'nɩ 'pie 'lɩ hʋannʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ʋ ‑hʋɛ ‑Yusu bʋ 'ya 'lɩ ꞊nʋ ‑mɔ. ‑Ɛ ‑bɩ ti nɩ ‑do a ti 'yri, ‑tɩtɛ ‑mʋ', ʋ mi 'lɩ, 'blagbɩ nyre 'ʋ nɩ, 'ʋ ‑kwlɛ. ");
INSERT INTO ktj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","‑Tɛ ‑nyrɛ ‑nyɛ, nyibli ‑hʋɔhʋɩ ‑mʋ', ‑ʋ hie 'lɩ 'yru a 'kɩbɩa ‑mʋ' kɩ, ‑tɩtɛ nɩ ‑do ‑mʋ', ‑Yusu wloo 'tʋ 'ʋ 'flɔɔ, nyibli a 'mʋ, nʋ‑ ꞊mʋɛ ‑Yusu lɛ. Ʋ yi꞊e nɩ, ‑ɛ mɔ, 'blagbɩ nɩ ‑do, ɛ nɔ‑ pɛ 'tʋ 'ʋ 'nʋwɔn 'yri bʋ, 'ʋ yi꞊e ‑wɛ, ‑ɛ mɔ, ‑Yusu 'yɩ 'tʋ 'lɩ 'blagbɩ a 'mʋ 'kwli 'ya. 'A ‑nagbopʋ* nɩ ‑do, nʋ‑ 'ya 'tʋ 'lɩ, ‑ʋ mu 'tʋ. ");
INSERT INTO ktj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","'Kɩ 'lɩ 'dɩɔ ‑mʋ', ‑ɛ mɔ Tibeliadɩ 'kwli, nyibli ‑bɩ ya 'blagbɩ, 'ʋ di 'ʋ ‑tɩtɛ ‑mʋ', ‑Yusu ‑nyii 'tʋ 'ʋ Nyɩsʋa 'wio, 'ɛ wloo 'tʋ 'flɔɔ, 'ʋ di 'tʋ꞊ʋ. ");
INSERT INTO ktj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","‑Tɛ nyibli a 'mʋ, ʋ 'ye꞊e, ‑ɛ mɔ, ‑Yusu kɔ 'a ‑nagbopʋ 'hʋɛn‑, ʋ 'yɩ 'ʋ ‑nɩ, ‑ɛ ‑bɩ ʋ 'ya 'lɩ 'waa 'blagbɩ 'kwli lɛ, 'ʋ mu 'lɩ Kapɛnaɔ, 'ʋ mu ‑Yusu lɛ ꞊mʋɔ mɔ. ");
INSERT INTO ktj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","'Kɩ ʋ yɛɛ 'lɩ꞊ɩ 'yru a 'kɩbɩa ‑bɩ ‑mʋ' kɩ bʋ, ʋ wɛn: «Tɔɔnyɔ, ti a 'dɩ ‑bɩ ‑kɔ 'yri ‑nyre 'nɛ‑ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ: ꞊Wlɩlɛkɛɛ‑tɛblɩ ‑bʋ, 'n ni, Nyɩsʋa, nɔ‑ ‑nyi 'mʋ 'klɩ, 'nɩ ni꞊e. Kɛɛ, ɛ 'yɩ ꞊bɩɩ ba yru dɛ a 'mʋ lɛ a ‑tɩ 'pa‑, a 'nɩ ꞊mʋɔ꞊ɔ 'mʋ lɛ. Ɛ 'wɩ yɩ, diidɛ ‑mʋ', a di 'tʋ, 'a ꞊mla 'tʋ, ɛ nɔ‑ kɔ ‑tɩ, 'a ꞊mʋɛ 'mʋ lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","A 'nɩ 'hie 'lɩ diidɛ a ‑tɩ nɩ ‑do 'lu ‑mɔ lɛ, ‑ɛ 'yɛ nɩ ‑wlɛn 'ʋ, ‑ɛ pʋɛ, kɛɛ, diidɛ ‑mʋ', ‑ɛ ni꞊e, 'a kʋɛ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ, ɛ nɔ‑ kɔ ‑tɩ ba ‑hie 'lu ‑mɔ lɛ. 'Mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'mɔ ‑di 'a mʋ diidɛ a 'mʋ ‑nyi, ‑ɛ nu꞊o, 'na 'Baɩ Nyɩsʋa, nɔ‑ lee 'nɛ‑ 'mʋ 'klɔ ‑bʋ kɩ, 'kɩ ꞊bʋ ‑nyi 'a mʋ diidɛ a 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","‑Ɛ ‑bɩ ʋ wɛn: «Dɛ a 'dɩ ‑bɩ ‑a di nu, 'tɩ‑ Nyɩsʋa 'mʋ ‑aan dɛ kɩ wɛn 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «Dɛ Nyɩsʋa ‑hʋɛ ba nu, ɛ nɔ‑ mɔ, 'mɔ ‑bʋ, ɛ tɛ 'nɛ‑ 'klɔ ‑bʋ kɩ, ba kuo 'mʋ ꞊wlʋ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","‑Ɛ ‑bɩ ʋ wɛn: «'Bʋ mɔ, ꞊nɩ ‑hʋɛ ‑ba pʋ ‑na win ꞊han‑tɩ, ‑ɛ ‑bɩ nu ꞊wlɩlɛkɛɛdɛ ‑bɩ, ‑ɛ di 'a dɛ ‑mʋ' yɩ 'wɩ, Nyɩsʋa a winwlɔn‑hanyɔ* Moise ni la. 'A ‑nɛ ‑nyrɔwɔ, ‑nyi ‑a mʋ diidɛ, ‑a 'mʋ꞊ʋ di, ꞊wɩ yɩ, ‑tɛ ‑aan 'baɩnʋ ni la, ti ‑mʋ', ‑ɛ ‑kɔ 'yri ʋ nɩ la 'lɩ 'pʋwɔnblʋgba kɩ, 'ʋ yɩ la diidɛdʋ ‑mʋ' di, ʋ dɛɛ manɩ, ‑ɛ ‑hʋɛn la 'lɩ yakɔ 'kwli. Dɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ ʋ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ: Ɛ ‑nyi ꞊nʋ 'flɔɔ, ‑ɛ ‑hʋɛn 'lɩ yakɔ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ: ‑Tɛɛ a diidɛ ‑mʋ', ‑kɔtɩ 'n hla wɛn, ɛ 'yɩ Moise 'pa‑, ɛ 'yɩ 'a mɔ꞊ɔ ‑nyi. Kɛɛ, ‑tɛɛ a diidɛ a 'mʋ, ‑ɛ ‑hʋɛn 'lɩ yakɔ 'kwli, 'na 'Baɩ Nyɩsʋa, nɔ‑ yɩ 'a mɔ꞊ɔ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","‑Tɛɛ a diidɛ ‑mʋ', Nyɩsʋa yɩ nyibli ‑nyi, ɛ nɔ‑ mɔ diidɛdʋ ‑mʋ', ‑ɛ ‑hɔn 'lɩ yakɔ 'kwli, 'tɩ‑ ‑ɛ ni꞊e, 'klɔ ‑bʋ 'kwli a nyibli, 'ʋ kʋɛ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","‑Ɛ ‑bɩ ʋ wɛn: «Tɔɔnyɔ, ‑nyi ‑a mʋ diidɛ a 'mʋ 'a ‑nɛ ti.» ");
INSERT INTO ktj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","‑Ɛ ‑bɩ ɛ yɩ 'kɩ ꞊nʋ 'nɩ ‑lee ‑nɩ, ɛ wɛn: «'N 'wɩ‑ diidɛdʋ ‑mʋ' yɩ, ‑ɛ yɩ nyibli 'klɔ yrayrʋ ‑nyi. Nyiblo 'bʋ kuo 'mʋ ꞊wlʋ yɩ, 'bʋ ‑hɛ 'na ‑nagbopi, ɛ 'wɩ‑ nyiblo ‑mʋ' yɩ, 'kanʋ kɔ 'nie'natʋ 'yɛ nɩ nu. ");
INSERT INTO ktj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","'N lee nɛ 'a mʋ nɩ, ‑ɛ mɔ, a 'ye 'mʋ nɩ, kɛɛ, a 'yɩ 'mʋ ꞊wlʋ yɩ ‑kuo ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nyibli a pɛpɛ ‑mʋ', 'na 'Baɩ yɩ 'mʋ ‑nyi, ʋ di ‑hɛ 'na ‑nagbopʋ. 'Klɔ ‑mɔ 'klɔ, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ bla 'waa nyiblo nɩ ‑do lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","'N 'yɩ 'lɩ yakɔ 'kwli ‑hɔn, ‑ɛ di꞊e nu, 'mʋ 'na dɩɔnʋ a kɩwɛɛnlɛ nu, kɛɛ, Nyɩsʋa ‑bʋ, ‑ɛ lee 'nɛ‑ 'mʋ ‑tʋtʋ kɩ, ɛ nɔ‑ kɔ kɩwɛɛnlɛ 'n kɔ ꞊bʋ nu. ");
INSERT INTO ktj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Dɛ Nyɩsʋa ‑hʋɛ, ɛ nɔ‑ mɔ, nyibli a pɛpɛ ‑bʋ, ɛ ‑nyi 'mʋ, 'nɩ 'waan 'lɩ 'waa 'yɛɛ nɩ ‑do, kɛɛ, lɛ'bɔɔ‑nyrɔwɔ a ti 'yri, 'n kɔ ꞊bʋ ‑ha 'lɩ ꞊nʋ 'kʋkʋnyibli 'nyɩ, ꞊bʋ ‑ha ꞊nʋ 'klɔ. ");
INSERT INTO ktj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ɛ mɔ ꞊han‑tɩ, dɛ 'na 'Baɩ ‑hʋɛ, ɛ nɔ‑ mɔ, 'a ‑nɛ nyiblo, ‑ɛ yru꞊o, ‑ɛ mɔ, 'mɔ ‑mɔ Nyɩsʋa a 'Yu, kɔ, ‑ɛ kuo 'mʋ ꞊wlʋ yɩ, nyiblo a 'mʋ, bʋ kɔ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ, 'tɩ‑ lɛ'bɔɔ‑nyrɔwɔ 'kwli, 'n kɔ ꞊bʋ ‑ha 'lɩ꞊ɩ 'kʋkʋnyibli 'nyɩ, 'mʋ꞊ʋ 'klɔ ‑ha.» ");
INSERT INTO ktj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","‑Tɛ ‑Juukʋɛ* a nyibli gbagbɩ 'wɩn dɛ a 'mʋ, ‑ɛ ‑bɩ ʋ ‑tʋa ‑Yusu a yrʋ a lɛpʋʋlɛ, ‑tɛ ɛ pʋ lɛ, ‑ɛ mɔ, ɛ nɔ‑ mɔ diidɛdʋ ‑mʋ', ‑ɛ ‑hɔn 'lɩ yakɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kɛ‑ ʋ pɩ: «꞊Bɩ nyiblo ‑bʋ, ɛ 'yɩ Sosɛfʋ a 'yu ‑Yusu 'pa‑? ‑A yi 'a 'baɩ kɔ 'a dii 'hʋɛn‑ nɩ. ‑Bɩ' ɛ ni 'kɩ, 'ɛ pɩ lɛ, ‑ɛ mɔ, 'kɩ ɛ ‑hɔn 'lɩ yakɔ 'kwli 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","‑Ɛ ‑bɩ ɛ ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «Dɛ‑ kɔ 'mɔ a pɩɩ yrʋ lɛ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ kuo 'mʋ ꞊wlʋ yɩ, bʋ ‑hɛ 'na ‑nagbopi, 'bʋ mɔ, 'na 'Baɩ ‑bʋ, ‑ɛ le 'mʋ, 'bʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑jrii ‑nɩ. 'Na 'mumu ‑bʋ, lɛ'bɔɔ‑nyrɔwɔ 'kwli, 'a ‑nɛ nyiblo, ‑ɛ kuo 'mʋ ꞊wlʋ yɩ, 'mɔ ‑di 'lɩ꞊ɩ 'kʋkʋnyibli 'nyɩ ‑ha, 'mʋ꞊ʋ 'klɔ ‑ha. ");
INSERT INTO ktj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nyɩsʋa a winwlɔn‑hanyʋ 'crɩ la꞊a nɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ: Nyɩsʋa, nɔ‑ di nyibli a pɛpɛ ‑tɔɔ ‑nɩ. 'A ‑nɛ nyiblo 'bʋ yɩ 'na 'Baɩ Nyɩsʋa nʋa yɩ bʋ nɩ pɩ, 'tɩ‑ 'bʋ yɩ 'a tɔɔwin kʋa nɩ 'ble, ɛ nɔ‑ di 'na ‑nagbopi ‑hɛ. ");
INSERT INTO ktj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ɛ 'yɩ 'nyrɛ ꞊hɛn, ‑ɛ mɔ, nyiblo ꞊dʋ 'ye 'na 'Baɩ Nyɩsʋa nɩ, 'bʋ 'yɩ 'mɔ nɩ ‑do ‑bʋ 'pa‑, ‑ɛ ‑hɔn 'lɩ꞊ɩ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ, nyiblo 'bʋ kuo 'mʋ ꞊wlʋ yɩ, nɔ‑ kɔ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","'Mɔ ‑mɔ diidɛdʋ ‑mʋ', ‑ɛ ni꞊e, nyiblo 'ɛ kʋɛ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","'Aan 'baɩnʋ, ‑ʋ nɩ la 'lɩ 'pʋwɔnblʋgba kɩ, ꞊han‑tɩ, 'ʋ yɩ la diidɛ ‑mʋ', ʋ dɛɛ manɩ, ‑ɛ ‑hʋɛ la 'lɩ yakɔ 'kwli di, kɛɛ, ʋ 'kʋkʋɩ la lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kɛɛ, ‑tɛɛ a diidɛ ‑mʋ', ‑ɛ ‑hʋɛ 'lɩ yakɔ 'kwli, nyiblo ‑mʋ', ‑ɛ di꞊e di, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ 'kʋ, ɛ ꞊hɛn 'nyrɛ, ɛ di kɔ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","'Mɔ ‑mɔ diidɛ ‑mʋ', ‑ɛ ‑hɔn 'lɩ yakɔ 'kwli, ‑ɛ ni꞊e, 'tɩ‑ ‑tonyibli 'ʋ kʋɛ 'klɔ yrayrʋ, ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ. 'A ‑nɛ nyiblo, ‑ɛ di diidɛ a 'mʋ di, 'a 'klɔ yrayrʋ, ɛ di kɔ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ kɔ 'lu‑yrɛɛlɛ. Diidɛ a 'mʋ, 'n di ‑ha, ɛ nɔ‑ mɔ 'na dɩɔnʋ a 'hʋɩ. 'N ‑hɛ 'na 'hʋɩ a 'mʋ nɩ, ‑ɛ di꞊e nu, 'klɔ kɩ a nyibli 'mʋ 'klɔ yrayrʋ kɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","‑Tɩ a 'mʋ, ‑Yusu ‑hla, ɛ pʋ ‑Juukʋɛ a ye'nanyʋ 'yrʋ dɩakɩ, 'ʋ yɩ 'waa dɩɔnʋ lɛ 'bɛti ‑nɩ, ʋ wɛn: «‑Bɩ' nyiblo ‑bʋ, ɛ ‑wɛ 'lɩ bʋ nu ‑a mʋ 'a dɩɔnʋ a 'hʋɩ a ‑nyinyie, ‑a 'mʋ꞊ʋ di lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'bʋ mɔ, 'ba 'yɛ nɩ di 'na 'hʋɩ, ɛ kɔ, 'ba 'yɛ nɩ 'na 'na ‑hlʋ, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba kɔ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ 'klɔ ‑mɔ 'klɔ. ");
INSERT INTO ktj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nyiblo 'bʋ nɩ 'ʋ, 'bʋ yɩ 'na 'hʋɩ nɩ di, kɔ, 'bʋ yɩ 'na ‑hlʋ nɩ 'nɛ, nyiblo a 'mʋ, ɛ kɔ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ, 'tɩ‑ lɛ'bɔɔ‑nyrɔwɔ 'kwli, 'n di 'lɩ꞊ɩ 'kʋkʋnyibli 'nyɩ 'nɩ ‑ha, 'mʋ꞊ʋ 'klɔ ‑ha. ");
INSERT INTO ktj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","'Na 'hʋɩ mɔ ‑tɛɛ a diidɛ ꞊nɩɔ, 'na ‑hlʋ 'ɛ mɔ ‑tɛɛ a 'nɩnadɛ. ");
INSERT INTO ktj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nyiblo, ‑ɛ yɩ 'na 'hʋɩ di, kɔ, ‑ɛ 'nɛ 'na ‑hlʋ, ɛ kɔ 'mʋ 'hʋɛn‑, ‑a ‑mʋɛ nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","'Na 'Baɩ ‑mʋ', ‑ɛ lee 'nɛ‑ 'mʋ 'klɔ ‑bʋ kɩ, ɛ nɔ‑ ni꞊e, nyibli 'ʋ yɩ 'klɔ nɩ. Ɛ nɔ‑ nu꞊o, 'tɩ‑ 'na 'mumu ‑bʋ, 'nɩ nɩ 'klɔ. Kɛ‑ ɛ ꞊ti 'mʋ, 'kɩ 'ʋ nyiblo ‑mʋ', ‑ɛ yɩ 'na 'hʋɩ di ‑mɔ'. 'Mɔ ‑ni꞊e, nyiblo a 'mʋ, 'ɛ yɩ 'klɔ nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","'Mɔ ‑mɔ ‑tɛɛ a diidɛ, ‑ɛ ‑hɔn 'lɩ yakɔ 'kwli. Ɛ 'yɩ diidɛ ‑mʋ' yɩ 'wɩ, ‑ɛ ‑hʋɛn la 'lɩ yakɔ 'kwli, ʋ dɛɛ manɩ, 'aan 'baɩnʋ yɩ la di, 'kɩ 'lɩ 'pʋwɔnblʋgba kɩ. ꞊Han‑tɩ, 'ʋ yɩ la diidɛdʋ a 'mʋ di, kɛɛ, kɛ‑ ɛ nɩ 'mʋ, 'ʋ 'kʋkʋɩ la lɛ. Nyiblo ‑mʋ', ‑ɛ di ‑tɛɛ a diidɛ ‑mʋ', 'n pa 'mʋ di, ɛ di kɔ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tɔɔwin a pɛpɛ ‑bʋ, ‑Yusu ‑tɔɔ ‑nɩ, 'kɩ ɛ tɔɔ 'lɩ꞊ɩ Nyɩsʋa a 'kayu ‑mʋ' bʋ, ‑ɛ nɩ 'lɩ Kapɛnaɔdɩɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nyibli ‑mʋ', ‑ʋ yɩ ‑Yusu ꞊wien lɛ kʋɛ, 'waa ‑hʋɔhʋɩ, 'tɩ‑ ʋ 'mʋ 'a tɔɔwin a 'mʋ 'wɩn, ʋ wɛn: «Tɔɔwin ‑bʋ, ɛ nɩ 'klɩ kɩ. Nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ wɛn꞊ɛ kɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","‑Yusu bʋ yru꞊o, ‑ɛ mɔ, nyibli a 'mʋ, ʋ ye' lɛ 'nɩ 'pʋplɛ ‑nɩ, ‑ɛ ‑bɩ ɛ ‑tʋa 'waa leelɛ, ɛ wɛn: «꞊Bɩ ‑tɩ ‑bʋ, 'n ‑hla, ɛ yɩ 'a mʋ 'nɩ 'hran? ");
INSERT INTO ktj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","'Mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'bʋ mɔ, 'ba 'ye 'mʋ, 'nɩ yɩ 'lɩ yakɔ 'kwli nɩ mi, ‑tɩtɛ ‑mʋ', 'n ‑hɔn 'lɩ, ‑bɩ' a di 'kɩ pʋ lɩ? ");
INSERT INTO ktj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nyɩsʋa a ‑Hihiu* nɩ ‑do, nɔ‑ yɩ nyiblo 'klɔ yrayrʋ ‑nyi. ‑Tonyibli a 'klɩ 'yɩ 'lɩ ꞊dedede 'lɩ ‑wɛ. Win ‑bʋ, 'n tɔɔ nɛ 'a mʋ, ɛ nɔ‑ ni꞊e, Nyɩsʋa 'ɛ yɩ 'a mʋ 'a ‑Hihiu ‑nyi, ‑Hihiu a 'mʋ, ɛ 'mʋ 'a mʋ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kɛɛ, 'kɩ 'lɩ 'a mʋ 'nyɩ, nyibli nɩ 'lɩ, 'ʋ 'yɩ 'mʋ ꞊wlʋ yɩ ‑kuo ‑nɩ.» Kʋɛ la 'lɩ bʋ, ‑Yusu yi nyibli ‑mʋ' nɩ, ‑ʋ 'yɩ꞊ɩ ꞊wlʋ yɩ ‑kuo ‑nɩ, kɔ, 'ɛ yi nyiblo ‑mʋ', ‑ɛ di꞊e 'a yraanyibli ‑jɩ' pʋ. ");
INSERT INTO ktj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ de, ɛ wɛn: «Ɛ nɔ‑ nu꞊o, 'nɩ lee nɛ 'a mʋ, ‑ɛ mɔ, nyiblo ꞊dʋ 'yɩ 'lɩ 'na ꞊wlʋ a yɩkuolɛ 'lɩ ‑wɛ, 'kɩ bʋ ‑hɛ 'na ‑nagbopi*, 'bʋ mɔ, Nyɩsʋa 'bʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑jrii ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nyibli ‑hʋɔhʋɩ ‑mʋ', ‑ʋ yɩ la꞊a ꞊wien lɛ kʋɛ, kʋɛ 'ʋ ti a 'mʋ 'yie bʋ, ‑ɛ ‑bɩ ʋ 'kee nɛ 'a ꞊wienlɛkʋkʋɛ nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","'A ‑nagbopʋ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn ‑mʋ', kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «'Aan 'mumu ‑bʋ, ꞊bɩ a ‑hʋɛ ba hie 'ʋ 'mʋ bʋ, ba 'kee 'na ꞊wienlɛkʋkʋɛ ‑wɛ?» ");
INSERT INTO ktj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","‑Ɛ ‑bɩ Simɔ Piɛlɩ ꞊tu꞊o ꞊wɔn, ɛ wɛn: «Kʋkɔnyɔ, nyiblo a 'dɩ ‑bɩ kɔ ‑mɔ ‑a di 'lɩ mu de 'lɩ? ‑Mɔ nɩ ‑do, ‑mɔ kɔ win ‑ni꞊e, nyiblo 'ɛ kʋɛ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","‑Tɛ ti nɛ ‑bʋ, ‑a kuo ‑mʋ ꞊wlʋ yɩ, 'tɩ‑ ꞊a yi꞊e, ‑ɛ mɔ, ‑mɔ mɔ Nyɩsʋa a 'Yu ‑Yusu 'Klɩsʋ, ɛ lee 'nɛ‑ 'klɔ kɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «'A mʋ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn ‑bʋ, 'mɔ ‑ha 'lɩ 'a mʋ 'lɩ, ‑ɛ di꞊e nu, a 'mʋ 'na ‑nagbopʋ ‑hɛ. Kɛɛ, 'kɩ 'lɩ 'a mʋ 'nyɩ nyiblo nɩ 'lɩ, 'ɛ mɔ 'ku ‑hʋan*.» ");
INSERT INTO ktj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judɩa, ‑ɛ mɔ Simɔ Yisikalio a 'yu, nɔ‑ ɛ ꞊hɛn 'nyrɛ. Ɛ mɔ ‑Yusu a ‑nagbopʋ nɩ ‑pu ꞊tu 'ʋ 'hʋɛn a nyiblo ‑bɩ ꞊nɩɔ. Kɛɛ, ɛ nɔ‑ di ‑Yusu 'a yraanyibli ‑jɩ' pʋ. ");
INSERT INTO ktj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ɛ nɛ Galileblʋgba 'kwli lɛ; ɛ 'nɩ ‑hʋa꞊a lɩ bʋ mu 'lɩ Sudeblʋgba 'kwli, ‑ɛ nu꞊o, ‑Juukʋɛ* a ye'nanyʋ ꞊mʋɛ 'a 'lɩla lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ti a 'mʋ 'yri, ‑ɛ ‑bɩ ‑Juukʋɛ a lɛ'mimle ‑mʋ', ʋ dɛɛ Papʋɩ a lɛ'mimle, 'a ti 'mʋɛ yrɛ. ");
INSERT INTO ktj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ɛ nɔ‑ nu꞊o, ‑Yusu a 'dɩayɩnʋ 'ʋ lee ꞊nɛ, ‑ɛ mɔ: «‑Hɔn 'nɛ‑ Galileblʋgba 'kwli, ‑bʋ mu 'lɩ Sudeblʋgba 'kwli, ‑ɛ di꞊e nu, ‑na ‑nagbopʋ* ‑mʋ', ‑ʋ nɩ 'lɩ, ʋ 'mʋ ꞊wlɩlɛkɛɛ‑tɛblɩ ‑mʋ', ‑ni 'ye. ");
INSERT INTO ktj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nyiblo ‑mʋ', ‑ɛ ‑hʋɛ nyibli a pɛpɛ bʋ yi꞊e, ɛ 'nɩ ‑nu꞊o lɩ 'a ‑nɛ ‑tɛblɩ, 'kɩ 'lɩ ‑huhlike 'kwli. 'A ‑tɩ, ‑tɛ ‑ni ꞊wlɩlɛkɛɛ‑tɛblɩ, nu꞊o, 'kɩ 'ʋ nyibli a pɛpɛ ye', ‑ɛ di꞊e nu, ʋ 'mʋ ‑mʋ yi.» ");
INSERT INTO ktj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","‑Yusu a 'dɩayɩnʋ a 'mʋ, ʋ 'yɩ꞊ɩ ꞊wlʋ yɩ ‑kuo ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «Ti 'yɛ 'ʋ nɩ nyre, 'kɩ ꞊bʋ mu 'lɩ. Kɛɛ, 'kɩ 'ʋ 'a mʋ ‑mɔ, 'a ‑nɛ ti mɔ ꞊haanti ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","'Klɔ ‑bʋ kɩ a nyibli, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ yraa nɛ 'a mʋ, kɛɛ, 'mɔ ‑bɩ, ʋ yraa 'mʋ nɩ, ‑ɛ nu꞊o, 'n hlɛ꞊ɛ nɩ, ‑ɛ mɔ, 'waa nunu‑tɛblɩ nyre yɩ. ");
INSERT INTO ktj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","'A mʋ ‑mɔ ‑bɩ, ba mu lɛ'mimle kɩ. 'Mɔ ‑bɩ, 'nɩ ‑mu꞊o 'lɩ, ‑ɛ nu꞊o, ti 'yɛ 'ʋ nɩ nyre, 'kɩ ꞊bʋ mu 'lɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Kɛ‑ ɛ pʋ ꞊nʋ yɩ, 'kɩ ɛ 'yɩ ‑ta' ‑hɔn, 'ɛ nɩ 'lɩ Galileblʋgba 'kwli bʋ. ");
INSERT INTO ktj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","‑Tɛ ‑Yusu a 'dɩayɩnʋ a 'mʋ, ʋ mu lɛ'mimle kɩ, 'kɩ 'lɩ Jrusrɛ, ‑ɛ ‑bɩ ‑Yusu mu 'lɩ nɩ ‑wɛ, 'kɩ 'lɩ ‑huhlike 'kwli, ‑ɛ di꞊e nu, nyibli 'nɩ ꞊ha꞊a 'ye. ");
INSERT INTO ktj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Lɛ'mimle a ti 'yri, ‑Juukʋɛ* a ye'nanyʋ ꞊mʋɛ ‑Yusu lɛ, 'a ‑tɩ, 'ʋ yɩ lɛ 'bɛti ‑nɩ, ‑ɛ mɔ: «‑Bɩ' ‑Yusu nɩ yɩ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","'ʋ hlɛ 'a ‑tɩ, 'kɩ 'lɩ nyibli ‑mʋ' 'nyɩ. ‑Ʋ ‑bɩ wɛn 'nɩ: «Ɛ mɔ ꞊haannyiblo ꞊nɩɔ.» ‑Ʋ ‑bɩ wɛn 'nɩ: «'Ʋʋn‑, ɛ 'yɩ ꞊haannyiblo 'pa‑, ɛ kɛɛ nyibli.» ");
INSERT INTO ktj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kɛɛ, nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ hla꞊a, 'kɩ 'ʋ nyibli ye', 'bʋ 'yɩ 'lɩ yɩbiilɛ 'kwli 'pa‑, ‑ɛ nu꞊o, ʋ yɩ pie 'waa ye'nanyʋ a hʋannʋ. ");
INSERT INTO ktj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","‑Tɛ ʋ 'bɛɛ lɛ'mimle bʋ, ‑ɛ ‑bɩ ‑Yusu mu 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli, 'ɛ ‑tʋa Nyɩsʋa a ‑tɩ a tɔɔlɛ. ");
INSERT INTO ktj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","‑Juukʋɛ bʋ yɩ 'a win nɩ 'wɩn, ‑ɛ ‑bɩ 'waa ꞊wlɩ kɛɛ lɛ. 'A ‑tɩ, kɛ‑ ʋ pɩ: «Nyiblo ‑bʋ, tetetɔɔnyɔ ꞊dʋ 'yɩ ‑hʋan꞊a tete nɩ ‑tʋɛ ‑nɩ. ‑Bɩ' ɛ ‑wɛ 'lɩ bʋ nu ‑tɛblɩ ‑hʋɔhʋɩ ‑bʋ, 'a yiyie 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «‑Tɛblɩ ‑bʋ, 'n tʋɛ nɛ 'a mʋ, Nyɩsʋa, ‑ɛ lee 'nɛ‑ 'mʋ, nɔ‑ yɩ 'mʋ 'a ꞊tɔ ‑nyi. Ɛ 'yɩ 'na ꞊gbɛtʋ a ꞊tɔ 'pa‑. ");
INSERT INTO ktj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nyiblo 'bʋ ‑hʋɛ bʋ nu dɛ ‑mʋ', ‑ɛ yɩ Nyɩsʋa a plɔ ‑blee ‑nɩ, ɛ nɔ‑ di꞊e lɛ yru, 'bʋ mɔ, tɔɔlɛ ‑bʋ, 'n tʋɛ ‑nɩ, 'bʋ mɔ Nyɩsʋa a 'lulɛ‑hihie, ‑ʋ'ʋ‑ 'bʋ mɔ 'lɩ 'na ꞊gbɛtʋ a 'klɩ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nyiblo ‑mʋ', ‑ɛ tʋɛ ‑nɩ, 'kɩ 'lɩ 'a dɩɔnʋ a 'klɩ 'kwli, ɛ ‑hʋɛ꞊ɛ nɩ, 'kɩ nyibli bʋ 'yaa 'lɩ 'a 'nyrɛ. Kɛɛ, nyiblo ‑mʋ', ꞊bʋ yɩ nɩ ‑tʋɛ ‑nɩ, ‑ɛ yɩ nyibli ‑lee ‑nɩ, bʋ 'yaa 'lɩ nyiblo ‑mʋ', ‑ɛ lee 'nɛ‑ 'a 'nyrɛ, nyiblo a 'mʋ, ɛ nɔ‑ hlɛ ‑tɩ a ‑tɛɛ. Hɩ 'yɩ 'lɩ 'a pʋpʋwin 'nyɩ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moise ‑nyi 'aan 'baɩnʋ tete nɩ. Kɛɛ, 'kɩ 'lɩ 'a mʋ 'nyɩ, nyiblo ꞊dʋ 'nɩ ꞊tuu꞊o 'ʋ tete a 'mʋ. Dɛ ‑hʋan a 'dɩ ‑bɩ 'n ‑nu, ‑kɔtɩ 'a ꞊mʋɛ 'na 'lɩla lɛ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","‑Ɛ ‑bɩ nyibli a 'mʋ, ʋ ꞊tu꞊o ꞊wɔn, ʋ wɛn: «‑Mɔ nyɔ ‑bʋ, 'ku ‑hʋan* nɩ 'ʋ ‑mʋ ke'. Nyiblo a 'dɩ ‑bɩ ꞊mʋɛ ‑na 'lɩla lɛ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","‑Ɛ ‑bɩ ‑Yusu wɛn: «Dɛ nɩ ‑do, 'n ‑nu, ɛ nɔ‑ mɔ, 'n nu la꞊a nɩ, nyiblo ꞊dʋ a 'kʋɛ 'ɛ ‑wɛ la, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ* 'kwli. Ɛ kɛɛ la 'aan ꞊wlɩ lɛ, 'kɩ ꞊bʋ di la dɛ a 'mʋ nu, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Kɛɛ, 'aan 'mumu, a ni ‑kʋan ‑wɛ, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli, ‑ɛ nu꞊o, Moise lee la 'aan 'baɩnʋ nɩ, 'kɩ ba 'bɛ 'aan 'yonʋ nyɩbɛpʋ yrɛ, 'bʋ kɔ ‑nyrɔwɩ nɩ ꞊blɩɛn꞊blɩɛn. 'A ‑tɩ, kʋɛ 'lɩ ti a 'mʋ 'yie bʋ, 'ye ꞊bɩɩ ɛ mɔ ‑wuwle‑nyrɔwɔ, a kɔ ba 'bɛ 'aan 'yonʋ yrɛ. Ba kɔ 'a yiyie, ‑ɛ mɔ, 'aan 'baɩnʋ, ‑ʋ nɩ la 'klɔ, nʋ‑ 'nyɛɛ 'hru, ‑ʋ ꞊tu꞊o ‑wlu, 'tɩ‑ Moise 'ɛ 'hrɩ 'klɔ. ");
INSERT INTO ktj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","‑Tɛ a yɩ 'aan 'yonʋ nyɩbɛpʋ yrɛ 'bɛ, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli, ‑ɛ di꞊e nu, a 'nɩ ꞊ha Moise a tete 'wla, ꞊bɩ nyiblo ‑bʋ, 'kʋɛ ni, ‑bʋ nu꞊o, 'a 'kʋɛ bʋ ‑wɛ, ɛ 'yɩ 'ʋ yɩ'bɩbɛ a 'mʋ 'ʋ ‑hi? ‑Tɛ 'n nu꞊o, nyiblo a 'kʋɛ 'ɛ ‑wɛ, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli, ɛ nɔ‑ kɔ 'mɔ a pɩɩ yrʋ lɛ? ");
INSERT INTO ktj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","‑Tɛblɩ nɩ ‑do ‑bʋ, 'aan 'yii yɩ 'ye, ɛ 'nɩ 'nuo 'lɩ꞊ɩ, a 'nɩ 'yɛɛ 'lɩ nyiblo ‑tɩ. Kɛɛ, 'ba 'mʋ ‑tɩ hla, ba ‑hie 'lu lɛ ‑tɛɛ, 'tɩ‑ a 'mʋ꞊ʋ hla.» ");
INSERT INTO ktj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Kɛ‑ Jrusrɛ a nyibli ‑bɩ pɩ: «꞊Bɩ ɛ 'yɩ nyiblo ‑bʋ 'pa‑, ‑ɛ kɔ 'lɩla ʋ ꞊mʋɛ lɛ? ");
INSERT INTO ktj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ba 'ye kɛ, ɛ nɔ‑ yɩ 'lɩ hle, 'kɩ 'lɩ nyibli a pɛpɛ ye'. Ɛ mɔ, ‑aan ye'nanyʋ 'nɩ ‑pʋ꞊ʋ lɩ꞊ɩ mɛ lɛ. ꞊Bɩ ʋ yru꞊o nɩ, ‑ɛ mɔ, ɛ nɔ‑ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ‑a mʋ yɩ ya? ");
INSERT INTO ktj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kɛɛ, dɛ ‑a yi, ɛ nɔ‑ mɔ, Wanyɔ a 'mʋ, 'bʋ ‑di, ‑tɩtɛ ‑mʋ', ɛ ‑hɔn 'ʋ, nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ yii 'ʋ. Kɛɛ, nyiblo ‑bʋ, ‑tɩtɛ, ɛ ‑hɔn 'ʋ, ‑a yii 'ʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ti nɩ ‑do a 'mʋ 'yri, ‑Yusu yɩ 'nɩ ‑tɔɔ ‑nɩ, 'kɩ 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli, 'ɛ 'yɛɛ 'lɩ win, ɛ wɛn: «꞊Bɩ sɛyɩ, nyiblo, 'n pa 'mʋ, a yi꞊e nɩ? Ɛ kɔ, ‑tɩtɛ, 'n ‑hɔn 'lɩ, a yii 'lɩ nɩ? Ɛ 'yɩ 'na dɩɔnʋ a 'klɩ 'pa‑, ɛ 'yɩ 'mʋ ‑ya. Nyiblo ‑bɩ, nɔ‑ lee 'nɛ‑ 'mʋ. Nyiblo a 'mʋ, ɛ mɔ ꞊wlʋyɩkuonyɔ ꞊nɩɔ. 'A mʋ ‑mɔ ‑bɩ, a 'yɩ꞊ɩ ‑yi. ");
INSERT INTO ktj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Kɛɛ, 'mɔ ‑bɩ, 'n yi꞊e nɩ, ‑ɛ nu꞊o, 'kɩ 'n ‑hɔn 'lɩ꞊ɩ ‑mɔ, ɛ kɔ, ɛ nɔ‑ lee 'nɛ‑ 'mʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","‑Tɛ nyibli ‑mʋ', ʋ 'wɩn, ‑ɛ ‑bɩ ʋ ‑hʋɛ bʋ klɔ꞊ɔ, kɛɛ, nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ gba 'ʋ꞊ʋ dabʋ 'hʋɩ, ‑ɛ nu꞊o, ti 'yɛɛ 'ʋ nɩ nyre, 'kɩ bʋ klɔ꞊ɔ. ");
INSERT INTO ktj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kɛɛ, 'kɩ 'lɩ nyibli a 'mʋ 'nyɩ, 'waa ‑hʋɔhʋɩ kuo ꞊nɛ ꞊wlʋ yɩ. Kɛ‑ ʋ pɩ: «Nyiblo ‑bʋ, ɛ nɔ‑ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ‑a mʋ yɩ ya. ꞊Bɩ ɛ di kɔ nyiblo ‑bɩ, ɛ 'mʋ ꞊wlɩlɛkɛɛ‑tɛblɩ ‑bɩ nu, ɛ 'mʋ 'ʋ nyiblo ‑bʋ 'ʋ ‑hi?» ");
INSERT INTO ktj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","‑Tɩ ‑mʋ', nyibli yɩ 'lɩ bʋ ‑blee ‑nɩ, ʋ hlɛ, 'kɩ 'ʋ ‑Yusu kɩ, Falisi꞊tumu a nyibli 'wɩn nɩ. Ɛ nɔ‑ kɔ ‑tɩ, Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ kɔ Falisi꞊tumu a nyibli 'hʋɛn‑, 'ʋ lee 'sɛyo, bʋ klɔ ‑Yusu. ");
INSERT INTO ktj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","‑Tɛ ‑Yusu 'ye dɛ a 'mʋ, ‑ɛ ‑bɩ kɛ‑ ɛ pɩ: «'N 'tɩɛ di 'nɛ‑ 'a mʋ ti gbi 'nyɩ ‑hi, 'tɩ‑ nyiblo ‑bʋ, ‑ɛ lee 'nɛ‑ 'mʋ, 'mʋ 'lɩ꞊ɩ ‑mɔ mu. ");
INSERT INTO ktj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","A di ꞊mʋɔ 'mʋ lɛ, kɛɛ, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba 'ye 'mʋ, ‑ɛ nu꞊o, ‑tɩtɛ ‑mʋ', 'n mi 'lɩ, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ ba nyre 'lɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","‑Ɛ ‑bɩ ‑Juukʋɛ* ‑tʋa lɛ'bɛtilɛ, ʋ wɛn: «‑Bɩ' ɛ di 'kɩ yɩ ‑muu ‑nɩ, 'kɩ ‑a 'yɛ nɩ di꞊e nɩ 'ye 'lɩ? ꞊Bɩ 'kɩ ɛ di 'lɩ ‑aan 'bio ‑Juukʋɛ ‑mʋ' ‑mɔ mu, ‑ʋ nɩ 'lɩ dakɔ ‑mʋ', ‑ʋ 'yɩ ‑Juukʋɛ 'pa‑ 'nyɩ, ɛ 'mʋ dakɔ a 'mʋ, 'a nyibli ‑tɔɔ ‑nɩ ‑wɛ? ");
INSERT INTO ktj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‑Tɩ ‑bʋ, ɛ ‑hla, dɛ a 'dɩ ‑bɩ ɛ ꞊hɛn 'nyrɛ 'lɩ, ‑tɛ ɛ pʋ lɛ, ‑ɛ mɔ: A di ꞊mʋɔ 'mʋ lɛ, kɛɛ, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba 'ye 'mʋ, ‑ɛ nu꞊o, ‑tɩtɛ ‑mʋ', 'n mi 'lɩ, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba nyre 'lɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Lɛ'mimle a 'mʋ, 'a lɛ'bɔɔ‑nyrɔwɔ, ɛ nɔ‑ mɔ ‑nyrɔwɔ gbagbʋ. ‑Nyrɔwɔ a 'mʋ 'kwli, ‑ɛ ‑bɩ ‑Yusu 'du ye', 'kɩ 'ʋ nyibli ‑hʋɔhʋɩ a 'mʋ ye', 'ɛ 'yɛɛ 'lɩ win, ɛ wɛn: «Nyiblo 'bʋ nɩ 'ʋ, 'nɩnatʋ 'bʋ yɩ꞊ɩ nɩ ni, ‑ɛ ‑bɩ 'kɩ bʋ di 'nɛ‑ 'mʋ ‑mɔ, ɛ 'mʋ 'na. ");
INSERT INTO ktj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nyiblo 'bʋ kuo 'mʋ ꞊wlʋ yɩ, ɛ 'wɩ‑ ‑tɛ 'nɩyie 'yɛ nɩ nɩ 'lɩ 'a ꞊wlʋ kɩ, 'niedʋ ‑mʋ', ‑ɛ ni꞊e, ‑tonyibli 'ʋ kʋɛ 'klɔ yrayrʋ, nɔ‑ di 'lɩ 'a ꞊wlʋ klɛ ‑hɔn. Kɛ‑ ʋ nu la 'a 'cɩcrɩɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Dɛ ‑bʋ ‑kɔ ‑tɩ ‑Yusu ‑hla, ɛ nɔ‑ mɔ Nyɩsʋa a ‑Hihiu* ‑mʋ', Nyɩsʋa di nyibli ‑mʋ', ‑ʋ kuo ꞊nɛ ꞊wlʋ yɩ ‑nyi. Ti a 'mʋ 'yri, Nyɩsʋa 'yɛɛ 'a ‑Hihiu nyibli nɩ ‑nyi, ‑kɔtɩ ‑Yusu 'yɛɛ 'lɩ yakɔ 'kwli nɩ mi, 'kɩ 'lɩ 'a ‑tɩ a 'yi'bʋalɛ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","‑Tɛ nyibli a 'mʋ, ʋ 'wɩn ‑Yusu a win, kɛ‑ 'waa dɛ ‑bɩ pɩ: «Ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, nyiblo ‑bʋ, ɛ nɔ‑ mɔ Nyɩsʋa a winwlɔn‑hanyʋ* ‑mʋ', ʋ pʋ la lɛ, ‑ɛ di la di,» ");
INSERT INTO ktj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","‑ʋ ‑bɩ 'ʋ pɩ lɛ: «Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya, ɛ nɔ‑ ꞊nɩɔ,» ‑ʋ ‑bɩ 'ʋ hlɛ꞊ɛ de: «Wanyɔ a 'mʋ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ kɔ 'lɩ Galileblʋgba 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kɛɛ, kɛ‑ Nyɩsʋacrɩɛn pɩ: Wanyɔ a 'mʋ, 'kɩ 'lɩ bodɩɔ Dafidɩ a ꞊tugba 'kwli, 'kɩ ɛ di 'lɩ kɔ, kɔ, ɛ di kɔ 'lɩ Betelɛmʋdɩɔ 'kwli, ‑ɛ mɔ Dafidɩ a 'mʋ a 'dɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ɛ 'wɩ yɩ, nyibli a 'mʋ, ʋ ꞊gla nɩ, ‑Yusu a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","‑Ʋ ‑bɩ ‑hʋɛ bʋ klɔ꞊ɔ, kɛɛ, nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ gba 'ʋ꞊ʋ dabʋ 'hʋɩ. ");
INSERT INTO ktj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","‑Ɛ ‑bɩ 'sɛyo ‑nɩ wɛn, ʋ ꞊hɩan ‑mɔ, 'ʋ mu 'lɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ kɔ Falisi꞊tumu* a nyibli 'hʋɛn‑ ‑mɔ, nyibli gbagbɩ a 'mʋ, 'ʋ 'bɛti ꞊nʋ: «Dɛ‑ kɔ ‑Yusu a 'yɩ ‑ya 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","‑Ɛ ‑bɩ 'sɛyo a 'mʋ, ʋ ꞊tu ꞊nʋ ꞊wɔn, ʋ wɛn: «‑A 'yɩ ‑hʋan nyiblo nɩ 'ye, ‑bʋ nu hihle lɛ, ꞊wɩ yɩ, ‑tɛ nyiblo ‑bʋ, ɛ ni hihle.» ");
INSERT INTO ktj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ɛ nɔ‑ mɔ Falisi꞊tumu a nyibli bʋ 'bɛti ꞊nʋ: «꞊Bɩ 'aan 'mumu, a wɛn nɩ, 'kɩ nyiblo ‑mʋ' bʋ kaa nɛ 'a mʋ. ");
INSERT INTO ktj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","‑A mʋ Falisi꞊tumu, ‑aan nyiblo ꞊dʋ 'yɩ꞊ɩ ꞊wlʋ yɩ ‑kuo ‑nɩ, 'tɩ‑, ɛ mɔ 'blʋgba a ye'nanyɔ ꞊dʋ 'yɩ꞊ɩ ꞊wlʋ yɩ ‑kuo ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kɛɛ, dakɔ a nyibli ‑mʋ', ‑ʋ kuo ꞊nɛ ꞊wlʋ yɩ, ʋ 'yɩ Moise a tete ‑yi. 'A ‑tɩ, Nyɩsʋa a ‑bati di ꞊nʋ 'nɩ klɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Falisi꞊tumu a nyiblo ‑mʋ', ‑ɛ kɔ 'nyrɛ ‑mɔ Nikodɛmʋ, ɛ nɩ ‑tuo kɩ ‑wɛ. Nikodɛmʋ a 'mʋ, nɔ‑ mu la ‑Yusu 'ye mɔ, ti ꞊dʋ ‑hi la a ti 'yri. Ɛ nɔ‑ a 'mʋ, ɛ nɔ‑ yɩ 'a 'bio ‑lee ‑nɩ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«‑Aan tete wɛn 'nɩ: 'Tɩ‑ ‑a 'mʋ nyiblo ‑tɩ ‑yɛɛ ‑nɩ, ‑a kɔ ‑ba pʋ꞊ʋ nʋa yɩ bʋ. ꞊Ba 'ye꞊e, ‑ɛ mɔ, ɛ nu dɛ, 'ɛ nyre yɩ, ‑ɛ ‑bɩ ‑bati klɔ꞊ɔ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","‑Ɛ ‑bɩ ʋ ꞊tu꞊o ꞊wɔn, ʋ wɛn: «꞊Bɩ ‑na 'mumu, 'kɩ ‑kɔ 'lɩ Galileblʋgba 'kwli ‑wɛ? ‑Hre Nyɩsʋacrɩɩn ‑tɛɛ. ‑Di꞊e 'nɩ 'ye, ‑ɛ mɔ, Nyɩsʋa a winwlɔn‑hanyɔ* ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ kɔ 'lɩ Galileblʋgba 'kwli.»  ");
INSERT INTO ktj_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ʋ ‑gbɛ nɩ. Nyiblo 'bʋ nɩ 'ʋ, 'ɛ mu 'lɩ 'a 'kayu bʋ. ");
INSERT INTO ktj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","'Kɩ ‑Yusu mu 'lɩ dʋgba ‑mʋ', ‑ɛ kɔ 'lu olifieti nɩ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","‑Tɛ ‑nyrɛ ‑nyɛ, ‑ɛ ‑bɩ ɛ ꞊hɩan ‑mɔ, 'ɛ mu 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli, nyibli ‑hʋɔhʋɩ 'ʋ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, 'ɛ nɩ bʋ, 'ɛ ‑tʋa 'waa tɔɔlɛ. ");
INSERT INTO ktj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ɛ nɩ 'lɩ 'waa tɔɔlɛ 'kwli, tetetɔɔnyʋ kɔ Falisi꞊tumu* a nyibli 'hʋɛn‑ 'ʋ nyree 'ʋ꞊ʋ nʋgba 'hʋɩ. Nʋgba a 'mʋ, ɛ nɩ 'lɩ ‑wlawlɩ a nunuo 'kwli, 'ʋ klɔ꞊ɔ, 'ʋ ya꞊a, 'ʋ ꞊tu 'ʋ꞊ʋ nyibli a pɛpɛ yɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","‑Ɛ ‑bɩ ʋ yɩ 'kɩ ‑Yusu 'nɩ ‑lee ‑nɩ, ʋ wɛn: «Tɔɔnyɔ, nʋgba ‑bʋ, ɛ nɩ 'lɩ ‑wlawlɩ a nunuo 'kwli, ꞊a klɔ꞊ɔ, ꞊a ya꞊a, ");
INSERT INTO ktj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","‑ɛ nu꞊o, Nyɩsʋa a winwlɔn‑hanyɔ* Moise, 'a tetebʋ ‑bɩ yɩ ‑a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, nʋgbɩ, ‑ʋ ni dɛ a 'mʋ, ‑ba pʋ ꞊nʋ 'hɩ ‑mɔ lɛ, ‑ba 'la ꞊nʋ. ‑Na 'mumu, ‑bɩ' ‑pɩ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ʋ hlɛ꞊ɛ nɩ, ‑ɛ di꞊e nu, ʋ 'mʋ ‑Yusu 'yi ꞊tɛ, ʋ 'mʋ꞊ʋ 'ye, 'bʋ di Nyɩsʋa a tete 'wla, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ ‑tɩ ‑yɛɛ ‑nɩ. ‑Ɛ ‑bɩ ‑Yusu pʋ 'lu ‑wlu, 'ɛ ni ‑jie, 'ɛ yɩ 'ʋ ‑tʋtʋ kɩ 'crɩɩ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bʋ 'tɩɛ bʋ yɩ꞊ɩ nɩ 'bɛti ‑nɩ, ‑ɛ ‑bɩ ɛ ‑ha 'lɩ 'lu ‑wlu, ɛ wɛn: «'Kɩ 'lɩ 'a mʋ 'nyɩ, nyiblo ‑bʋ, ‑ɛ 'yɩ ‑hʋan dɛ 'kuku nɩ ni, nɔ‑ ‑bʋ mɔ yɩ‑hɛnyiblo, ‑bʋ pʋ꞊ʋ 'hɩɔ ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","‑Ɛ ‑bɩ ɛ pʋ 'lu ‑wlu de, 'ɛ yɩ 'ʋ ‑tʋtʋ kɩ 'crɩɩ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","'Tɩ‑ ʋ 'mʋ ‑Yusu a pʋpʋwin a 'mʋ 'wɩn, ‑ɛ ‑bɩ 'waa dodoyo ‑tʋa mumuo, nyɩ'kɩ, nʋ‑ mɔ yɩ‑hɛnyibli, ‑ʋ ‑tʋa mumuo. ‑Ɛ ‑bɩ ‑Yusu kɔ nʋgba a 'mʋ 'hʋɛn‑, nʋ‑ hie 'ʋ, 'kɩ 'ʋ nyibli a 'mʋ ye'. Nʋgba a 'mʋ, ɛ 'tɩɛ nyra 'lɩ ꞊nʋ 'nyɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","‑Ɛ ‑bɩ ‑Yusu ‑ha 'lɩ 'lu ‑wlu, ɛ wɛn: «Nʋgba o, nyibli ‑bʋ, ‑ʋ yɩ wɛn ‑mʋ ‑tɩ ‑yɛɛ ‑nɩ, ‑bɩ' ʋ nɩ yɩ 'lɩ? ꞊Bɩ nyiblo ꞊dʋ 'yɩ 'ʋ ‑hie, ‑bʋ pʋ lɛ, ‑blɛɛ 'kʋkʋʋ yɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","‑Ɛ ‑bɩ nʋgba a 'mʋ, ɛ wɛn: «Iin ‑o, Kʋkɔnyɔ o. 'A nyiblo ꞊dʋ 'yɩ 'ʋ ‑hie.» ‑Ɛ ‑bɩ ‑Yusu wɛn: «'Na 'mumu ‑wɛ, 'nɩ ‑pʋ꞊ʋ lɛ, ‑ɛ mɔ, ‑blɛɛ 'kʋkʋʋ yɩ. ‑Wɛ 'lɩ ‑bʋ mu nɩ. Kɛɛ, ꞊nɩ 'nuo 'kɩ dɛ 'kuku de.» ");
INSERT INTO ktj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kɛ‑ ‑Yusu pɩ de, ɛ wɛn: «'Mɔ ‑yɩ 'klɔ ‑bʋ kɩ a nyibli ‑nyrɛ ‑nyi, ‑ɛ di꞊e nu, ʋ 'mʋ ‑tɩ a ‑tɛɛ' lɛ yru. Nyiblo 'bʋ kuo 'mʋ ꞊wlʋ yɩ, ɛ kɔ bʋ kɔ ‑nyrɛdʋ a 'mʋ, ‑ɛ yɩ nyiblo 'klɔ yrayrʋ ‑nyi. Ɛ di 'kee 'lɩ halɔ a' lɛnɩna.» ");
INSERT INTO ktj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","‑Ɛ ‑bɩ Falisi꞊tumu* a nyibli ꞊tu꞊o ꞊wɔn, ʋ wɛn: «‑Na ꞊gbɛtʋ, ‑mɔ hlɛ ‑na dɩɔnʋ a ‑tɩ. 'A ‑tɩ o, ‑tɩ a 'mʋ, ‑hlɛ, ɛ 'yɩ ꞊han‑tɩ 'pa‑.» ");
INSERT INTO ktj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","‑Ɛ ‑bɩ ‑Yusu wɛn: «Ɛ mɔ, 'ye ꞊bɩɩ 'mɔ nɩ ‑do, 'n yɩ 'na dɩɔnʋ a ‑tɩ nɩ hlɛ, ‑tɩ ‑mʋ', 'n hlɛ, ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, ‑ɛ nu꞊o, ‑tɩtɛ 'n ‑hɔn 'ʋ, ɛ kɔ, ‑tɩtɛ, 'n mi 'ʋ, 'n yi 'ʋ nɩ. Kɛɛ, 'a mʋ ‑mɔ ‑bɩ, ‑tɩtɛ 'n ‑hɔn 'lɩ, ɛ kɔ ‑tɩtɛ, 'n mi 'lɩ, a 'yɩ 'lɩ ‑yi. ");
INSERT INTO ktj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","‑Tɛ ‑tonyibli ni 'waa 'bio a ‑tɩ a yɛɛlɛ, kɛ‑ nɩ ‑do, a ni nyibli a ‑tɩ a yɛɛlɛ. 'Mɔ ‑bɩ, 'nɩ ‑yɛɛ꞊ɛ nyiblo ꞊dʋ ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kɛɛ, 'bʋ mɔ, 'nɩ kɔ ꞊bʋ yɛɛ nyibli ‑tɩ, ɛ 'wɩ yɩ, ‑tɩ ‑mʋ', 'n hlɛ, ɛ mɔ ꞊han‑tɩ ꞊nɩɔ, ‑ɛ nu꞊o, ɛ 'yɩ 'mɔ nɩ ‑do 'pa‑, 'nɩ ‑yɛɛ꞊ɛ nyibli ‑tɩ, kɛɛ, 'na 'Baɩ ‑mʋ', ‑ɛ lee 'nɛ‑ 'mʋ, ɛ kɔ 'mʋ 'hʋɛn‑, ‑a mʋ pɛ. ");
INSERT INTO ktj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ʋ 'crɩɩ la 'lɩ꞊ɩ Nyɩsʋa a tetecrɩɛn 'kwli nɩ, ‑ɛ mɔ, ‑hɛhɩpʋ nɩ 'hʋɛn, 'bʋ hla ‑tɩtu nɩ ‑do, ɛ ꞊hɛn 'nyrɛ, ‑ɛ mɔ, ‑tɩ a 'mʋ, ɛ mɔ ꞊han‑tɩ ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","'N hlɛ 'na dɩɔnʋ a ‑tɩ, ɛ kɔ, 'na 'Baɩ ‑mʋ', ‑ɛ lee 'nɛ‑ 'mʋ, 'ɛ hlɛ 'na ‑tɩ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","‑Ɛ ‑bɩ ʋ 'bɛti꞊e nɩ, ʋ wɛn: «‑Bɩ' ‑na 'Baɩ nɩ yɩ 'lɩ?» ‑Ɛ ‑bɩ ‑Yusu wɛn: «Mɔ, a 'yɩ 'mʋ ‑yi, kɔ, 'a 'yɩ 'na 'Baɩ ‑yi ‑wɛ. 'Bʋ mɔ, 'ba yi wɛn 'mʋ, ‑ɛ ‑bɩ a di wɛn 'na 'Baɩ 'nɩ yi ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","‑Tɛ ‑Yusu tʋɛ nyibli ‑tɛblɩ a 'mʋ, 'kɩ ɛ nɩ 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli. Dukwli ‑mʋ', ‑ɛ kɔ 'kwli ʋ pɩ 'lɩ 'wli lɛ, ɛ nɔ‑ kɔ 'hʋɩ, ɛ nɩ 'ʋ. Kɛɛ, nyiblo ꞊dʋ 'yɩ 'lɩ 'a kʋklɔ 'lɩ ‑wɛ, ‑kɔtɩ ti 'yɛɛ 'ʋ nɩ nyre, 'kɩ bʋ klɔ꞊ɔ. ");
INSERT INTO ktj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ de: «'N di 'nɩ mu, a 'mʋ 'mʋ lɛ ꞊mʋɔ, kɛɛ, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba 'ye 'mʋ. A di 'kʋkʋ lɛ, 'kɩ 'lɩ 'aan dɛ 'kuku 'nyɩ. ‑Tɩtɛ 'n mi 'lɩ, a 'yɩ 'lɩ mumuo 'lɩ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","‑Ɛ ‑bɩ kɛ‑ ‑Juukʋɛ* a ye'nanyʋ pɩ: «꞊Bɩ ɛ di 'a dɩɔnʋ 'nɩ 'la, ‑ɛ nu꞊o, ɛ wɛn 'nɩ, ‑tɩtɛ ‑mʋ', ɛ mi 'lɩ, ‑a 'yɩ 'lɩ mumuo 'lɩ ‑wɛ?» ");
INSERT INTO ktj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","‑Ɛ ‑bɩ ɛ wɛn: «'A mʋ ‑bʋ, a mɔ 'klɔ ‑bʋ kɩ a nyibli ꞊nɩɔ. Kɛɛ, 'mɔ ‑bɩ, 'n 'yɩ 'nɛ‑ 'klɔ ‑bʋ kɩ ‑hɔn. 'Kɩ 'n ‑hɔn 'lɩ yakɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","'N lee nɛ 'a mʋ nɩ, ‑ɛ mɔ, a di 'kʋkʋ lɛ, 'kɩ 'lɩ 'aan dɛ 'kuku 'nyɩ. A kɔ ba kɔ 'a yiyie, ‑ɛ mɔ, nyiblo ‑mʋ', 'n pʋ lɛ, 'n ‑mɔ, ɛ nɔ‑ 'n pa 'mʋ. 'Bʋ mɔ, 'ba 'yɩ꞊ɩ ꞊han‑tɩ ‑pʋ, a di 'kʋkʋ lɛ, 'kɩ 'lɩ 'aan dɛ 'kuku 'nyɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","‑Ɛ ‑bɩ ʋ 'bɛti꞊e nɩ, ʋ wɛn: «Nyiblo a 'dɩ ‑bɩ ‑pa 'mʋ 'lɩ?» ‑Ɛ ‑bɩ ɛ wɛn: «꞊Bɩ a ‑hʋɛ꞊ɛ nɩ, ꞊bʋ hla꞊a de? 'Mɔ ‑mɔ nyiblo ‑mʋ', ‑kɔtɩ 'n hlɛ, kʋɛ la 'lɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","'N kɔ wɛn ‑tɩ ‑hʋɔhʋɩ a hɩhla, 'kɩ 'ʋ 'a mʋ kɩ, ɛ kɔ, 'n kɔ wɛn 'hru, 'kɩ ꞊bʋ yɛɛ wɛn 'a mʋ ‑tɩ. Kɛɛ, 'nɩ ‑hla꞊a 'kɩ ‑tɩ a pɛpɛ a 'mʋ nɩ. Nyiblo ‑mʋ', ‑ɛ lee 'nɛ‑ 'mʋ, ‑tɩ nɩ ‑do ‑mʋ', 'n 'wɩɩn 'ʋ꞊ʋ wien, ɛ nɔ‑ 'n hlɛ, nyiblo a 'mʋ, ɛ hlɛ ‑tɩ a ‑tɛɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ʋ 'nɩ ‑yru꞊o lɩ꞊ɩ, ‑ɛ mɔ, 'a 'Baɩ a ‑tɩ ɛ hlɛ. ");
INSERT INTO ktj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ de, ɛ wɛn: «Ti ‑mʋ' ‑kɔ 'yri 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, a di 'ʋ 'mʋ ye' 'duu ‑nɩ, 'kɩ 'ʋ tugbɛ 'yie, 'mʋ ‑tʋtʋ ‑mɔ lɛ ‑hlɔɔ ‑nɩ, a di꞊e 'nɩ yru, ‑ɛ mɔ, 'mɔ ‑mɔ nyiblo ‑mʋ', 'n pʋ lɛ, 'n pa 'mʋ. A di꞊e' lɛ 'nɩ yru, ‑ɛ mɔ, 'nɩ ‑nu꞊o ꞊dedede, 'kɩ 'lɩ 'na dɩɔnʋ a 'klɩ 'kwli. ‑Tɩ nɩ ‑do ‑mʋ', 'na 'Baɩ tɔɔ 'mʋ, ɛ nɔ‑ 'n hlɛ. ");
INSERT INTO ktj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nyiblo ‑mʋ', ‑ɛ lee 'nɛ‑ 'mʋ, 'kɩ ɛ nɩ 'ʋ 'mʋ 'hʋɩ. Ɛ 'yɩ 'ʋ 'mʋ bʋ ‑tɩa ‑nɩ, ‑ɛ nu꞊o, 'a ‑nɛ ti, dɛ ‑mʋ', ‑ɛ yɩ 'a plɔ ‑blee ‑nɩ, ɛ nɔ‑ 'n ni.» ");
INSERT INTO ktj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","‑Tɛ ‑Yusu pʋ 'kɩ lɛ, ‑ɛ ‑bɩ nyibli ‑hʋɔhʋɩ ‑tʋa 'a ꞊wlʋ a yɩkuolɛ. ");
INSERT INTO ktj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","‑Ɛ ‑bɩ nyibli a 'mʋ, ‑ʋ kuo ‑Yusu ꞊wlʋ yɩ, kɛ‑ ɛ pɩ ꞊nʋ yɩ: «'Na tɔɔwin ‑mʋ', 'ba yɩ 'ʋ꞊ʋ nɩ ꞊tui ‑nɩ, ‑ɛ ‑bɩ 'a mʋ ‑mɔ 'na ‑tɛɛ a ‑nagbopʋ*. ");
INSERT INTO ktj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","'Na tɔɔwin a 'mʋ, 'a 'ʋ꞊tuulɛ, ɛ di꞊e 'nɩ nu, a 'mʋ ‑tɩ a ‑tɛɛ yi, ‑tɩ a ‑tɛɛ a 'mʋ, ɛ 'mʋ 'a mʋ ꞊gblɛ, 'kɩ 'lɩ ꞊kodɛ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","‑Ɛ ‑bɩ ‑Juukʋɛ* a ye'nanyʋ wɛn: «‑A mɔ Abrahamʋ a 'yonʋ a 'yonʋ ꞊nɩɔ. ‑A 'yɩ ‑hʋan nyiblo ꞊dʋ a ꞊koyo nɩ ‑hɛ. Dɛ‑ kɔ ‑a mʋ ‑yɩ ‑lee ‑nɩ, ‑ɛ mɔ, ‑tɩ a ‑tɛɛ di ‑a mʋ 'nɩ ꞊gblɛ, 'kɩ 'lɩ ꞊kodɛ 'nyɩ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","‑Ɛ ‑bɩ ɛ wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ, 'a ‑nɛ nyiblo 'bʋ nɩ 'ʋ, 'bʋ yɩ dɛ 'kuku nɩ ni, ‑ɛ ‑bɩ ɛ mɔ dɛ 'kuku a ꞊koyu ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","꞊Koyu 'yɩ yɩ ‑blɛɛ ‑nɩ, bʋ mɔ ꞊tugbatayu. Kɛɛ, 'baɩ a 'yu, ɛ nɔ‑ mɔ ꞊tugbatayu. ");
INSERT INTO ktj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","'Mɔ ‑bʋ, ‑ɛ mɔ Nyɩsʋa a 'Yu, 'bʋ mɔ, 'nɩ ꞊gblɛ 'a mʋ, ‑ɛ ‑bɩ ɛ mɔ ‑tɛɛ, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba mɔ 'kɩ ꞊koyo de. ");
INSERT INTO ktj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","'N yi꞊e nɩ, ‑ɛ mɔ, a mɔ Abrahamʋ a 'yonʋ a 'yonʋ ꞊nɩɔ. Kɛɛ, a ꞊mʋɛ 'na 'lɩla lɛ, ‑ɛ nu꞊o, a 'nɩ ‑wɛn꞊ɛ 'na tɔɔwin kɩ. ");
INSERT INTO ktj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Dɛ ‑mʋ', 'na 'Baɩ tɔɔ 'mʋ, ɛ nɔ‑ 'n yɩ 'a mʋ ‑lee ‑nɩ. 'A mʋ ‑mɔ ‑bɩ, dɛ ‑mʋ', 'aan 'baɩ lee nɛ 'a mʋ, ɛ nɔ‑ a ni.» ");
INSERT INTO ktj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","‑Ɛ ‑bɩ ʋ wɛn: «‑Aan 'baɩ, nɔ‑ mɔ Abrahamʋ.» ‑Ɛ ‑bɩ ‑Yusu wɛn: «'Bʋ mɔ, 'ba mɔ wɛn Abrahamʋ a 'yonʋ, ‑ɛ ‑bɩ ‑tɛblɩ ‑mʋ', ɛ ni la, nɔ‑ a di wɛn nu. ");
INSERT INTO ktj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kɛɛ, 'ye ꞊bɩɩ 'n lee nɛ 'a mʋ ‑tɩ a ‑tɛɛ ‑mʋ', Nyɩsʋa lee 'mʋ, a 'tɩɛ di 'na 'lɩla lɛ ꞊mʋɔ. Dɛ a 'mʋ, Abrahamʋ 'nɩ ‑nu꞊o la꞊a. ");
INSERT INTO ktj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kɛɛ, ‑tɛblɩ nɩ ‑do ‑mʋ', 'aan 'baɩ ni la, ɛ nɔ‑ a ni ‑wɛ.» ‑Ɛ ‑bɩ ʋ wɛn: «‑Aan 'dii 'yɩ 'lawlunʋgba 'pa‑. ‑Aan 'baɩ nɩ ‑do, ‑a yi, ɛ nɔ‑ mɔ Nyɩsʋa.» ");
INSERT INTO ktj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","‑Ɛ ‑bɩ ‑Yusu wɛn: «'Bʋ mɔ, Nyɩsʋa 'bʋ mɔ wɛn 'aan 'Baɩ, ‑ɛ ‑bɩ a di wɛn 'mʋ 'nɩ ‑nʋɛ ‑nɩ, ‑tɛ 'n ‑hɔn 'lɩ Nyɩsʋa ‑mɔ a ‑tɩ. 'N 'yɩ ‑di, 'kɩ 'lɩ 'na ꞊gbɛtʋ a 'klɩ 'kwli, kɛɛ, ɛ nɔ‑ lee 'nɛ‑ 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Dɛ‑ kɔ ‑tɩ, ‑tɩ ‑bʋ, 'n hlɛ, 'a 'yɛ nɩ yru꞊o' lɛ 'lɩ? ‑Tɩ kɔ ‑tɩ 'a 'yɛ nɩ yru꞊o' lɛ, ɛ nɔ‑ mɔ, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba pʋ 'mʋ nʋa yɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","'Aan 'baɩ, nɔ‑ mɔ Satan, ‑ɛ mɔ 'kuo ‑hʋɩn* a nyiblo gbagbʋ. 'A mʋ ‑mɔ 'a 'yonʋ. ‑Tɛblɩ ‑mʋ', ‑ɛ yɩ 'aan 'baɩ a plɔ ‑blee ‑nɩ, ɛ nɔ‑ a nʋɛ ‑nɩ ba nu. Kʋɛ la 'lɩ bʋ, ɛ 'lɛ nyibli. Ɛ yraa ‑tɩ a ‑tɛɛ nɩ, ‑ɛ nu꞊o, ‑tɩ a ‑tɛɛ 'yɩ 'lɩ 'a ꞊wlʋ kɩ ‑nɩ. Hɩ a nunuo, nɔ‑ mɔ 'a ‑kʋan, ‑ɛ nu꞊o, ɛ mɔ hɩlɛkɔnyɔ ꞊nɩɔ. 'Kɩ 'lɩ꞊ɩ ‑mɔ, 'kɩ hɩ a gblegble a pɛpɛ ‑hʋɛn 'lɩ ‑wlu. ");
INSERT INTO ktj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kɛɛ, 'mɔ ‑bɩ, 'n hlɛ ‑tɩ a ‑tɛɛ. Ɛ nɔ‑ kɔ ‑tɩ, 'kɩ 'a 'yɩ 'mʋ ꞊wlʋ yɩ ‑kuo ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","꞊Bɩ ɛ kɔ nyiblo, 'kɩ 'lɩ 'a mʋ 'nyɩ, ‑ɛ ‑wɛ 'lɩ ‑bʋ lee 'mʋ, ‑ɛ mɔ, 'n nu dɛ 'kuku? Ɛ 'yɩ nyiblo ꞊dʋ ‑kɔ. Dɛ‑ kɔ ‑tɩ, ‑tɛ 'n hlɛ ‑tɩ a ‑tɛɛ, 'kɩ a 'yɛ nɩ pʋ 'na win ꞊han‑tɩ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nyiblo ‑mʋ', ‑ɛ mɔ Nyɩsʋa a nyiblo, ɛ pɩ Nyɩsʋa a 'mʋ, 'a win nʋa yɩ bʋ ‑tɛɛ. Kɛɛ, 'a mʋ ‑mɔ ‑bɩ, a 'yɩ Nyɩsʋa a nyibli 'pa‑. Ɛ nɔ‑ nu꞊o 'kɩ, 'a 'yɛ nɩ pʋ Nyɩsʋa a 'mʋ, 'a win nʋa yɩ bʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","‑Ɛ ‑bɩ ‑Juukʋɛ* a ye'nanyʋ ꞊tu꞊o ꞊wɔn, ʋ wɛn: «'A ‑tɩ, ‑tɛ ‑a lee wɛn ‑mʋ, ‑ɛ mɔ, ꞊yɩ Nyɩsʋa ‑yi, kɔ, 'ku ‑hʋan* nɩ 'ʋ ‑mʋ ke', ‑a kɔ wɛn 'ʋ ꞊wɔn.» ");
INSERT INTO ktj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","‑Ɛ ‑bɩ ‑Yusu wɛn: «'Ku ‑hʋan 'yɩ 'ʋ 'mʋ ke' ‑nɩ. Kɛɛ, 'na 'Baɩ 'n yɩ ‑tɩ a 'yi'bʋalɛ ‑nyi. 'A mʋ ‑mɔ ‑bɩ, a hɩa nɩ, 'kɩ ba ‑nyi 'mʋ ‑tɩ a 'yi'bʋalɛ. ");
INSERT INTO ktj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","'Mɔ ‑bɩ, 'nɩ ꞊mʋɔ꞊ɔ lɩ꞊ɩ lɛ, 'kɩ nyibli bʋ ‑nyi 'mʋ ‑tɩ a 'yi'bʋalɛ, kɛɛ, Nyɩsʋa, nɔ‑ ꞊mʋɛ꞊ɛ lɛ. Ɛ nɔ‑ di ‑bati 'bɛ. ");
INSERT INTO ktj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, nyiblo 'bʋ yɩ 'ʋ 'na win nɩ ꞊tui ‑nɩ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ 'kʋ yruyru.» ");
INSERT INTO ktj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","‑Ɛ ‑bɩ ʋ wɛn: «‑A yi 'kɩ꞊ɩ nɩ, ‑ɛ mɔ, 'ku ‑hʋan nɩ 'ʋ ‑mʋ ke'. ‑Aan 'baɩ gbagbʋ Abrahamʋ 'kʋ nɩ, Nyɩsʋa a winwlɔn‑hanyʋ* 'kʋ nɩ ‑wɛ. ‑Mɔ ‑bɩ, kɛ‑ pɩ, nyiblo 'bʋ yɩ 'ʋ ‑na win nɩ ꞊tui ‑nɩ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ 'kʋ yruyru. ");
INSERT INTO ktj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","‑Aan 'baɩ Abrahamʋ 'kʋ nɩ. ꞊Bɩ ‑na ꞊wlʋ wɛn, ‑mɔ nɩ 'ʋ꞊ʋ 'lu yɩ? Nyɩsʋa a winwlɔn‑hanyʋ 'kʋ nɩ ‑wɛ. Nyɔ‑ ‑dɛɛ 'kɩ ‑dɩɔnʋ sɛyɩ‑sɛyɩ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «'Bʋ mɔ, 'nɩ yɩ wɛn 'na dɩɔnʋ nɩ 'bʋɛ ‑nɩ, 'na dɩɔnʋ a 'bʋalɛ a 'mʋ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ da wɛn ꞊dedede. Nyiblo ‑bʋ, ‑ɛ 'bʋɛ 'mʋ, ɛ nɔ‑ mɔ 'na 'Baɩ Nyɩsʋa. A wɛn 'nɩ, Nyɩsʋa a 'mʋ, nɔ‑ a dɛ. ");
INSERT INTO ktj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kɛɛ, a 'yɩ꞊ɩ ‑yi. 'Mɔ ‑bɩ, 'n yi꞊e nɩ. 'Bʋ mɔ, 'nɩ pʋ wɛn lɛ, ‑ɛ mɔ, 'n 'yɩ꞊ɩ ‑yi, ‑ɛ ‑bɩ 'n di mɔ wɛn hɩlɛkɔnyɔ, ꞊wɩ yɩ 'a mʋ. Kɛɛ, 'n yi꞊e nɩ, 'tɩ‑ 'nɩ ꞊tui 'ʋ 'a win 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","'Aan 'baɩ gbagbʋ Abrahamʋ yɩ ‑hie la꞊a 'lu ‑mɔ lɛ, ‑ɛ mɔ, ɛ di 'ye la ‑nyrɔwɔ ‑mʋ', ‑ɛ kɔ 'kwli ʋ di la 'lɩ 'mʋ ‑kɔɔ ‑nɩ, 'ɛ ni la 'a ‑tɩ a dɔdʋ. ‑Tɛ ɛ 'ye la 'kɩ ‑nyrɔwɔ a 'mʋ, ‑ɛ ‑bɩ ɛ ni la dɔdʋ dɩakɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","‑Ɛ ‑bɩ ʋ wɛn: «‑Mɔ ‑bʋ, ‑ɛ 'yɛ 'yrɩ a (50) ‑wlɩ nɩ 'hʋɛn ꞊tu 'ʋ ‑pu nɩ kʋɛ, ‑mɔ pɩ lɛ, ‑ɛ 'ye Abrahamʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","‑Ɛ ‑bɩ ‑Yusu wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, 'tɩ‑ ʋ 'mʋ Abrahamʋ kɔ mɔ mu, 'mɔ ‑bʋ, 'n nɩ la 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ʋ 'du 'hɩ ye' lɛ, ʋ 'mʋ ꞊nɛ꞊ɛ ‑mɔ lɛ pʋ, ʋ 'mʋ꞊ʋ 'la a ‑tɩ. Kɛɛ, ‑Yusu ‑hli ꞊nʋ 'yii kɩ, 'ɛ 'hrɩɩ 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","‑Yusu bʋ nɩ 'hru wlɔn, ɛ kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ‑ɛ ‑bɩ ɛ yɛɛ 'ʋ nyiblo ꞊dʋ bʋ. Nyiblo a 'mʋ, kʋɛ la 'lɩ 'a kʋkɔti 'yie bʋ, 'a 'yii 'dɔ nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","‑Yusu a ‑nagbopʋ yɩ 'kɩ 'nɩ 'bɛti ‑nɩ, ʋ wɛn: «Tɔɔnyɔ o, ꞊bɩ nyiblo ‑bʋ, 'a dɛ 'kuku a ‑tɩ, ‑hʋʋ' 'a 'dii kɔ 'a 'baɩ 'hʋɛn‑ a dɛ 'kuku a ‑tɩ, 'a 'yii 'dɔ?» ");
INSERT INTO ktj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «Ɛ 'yɩ 'a dɛ 'kuku a ‑tɩ 'pa‑, mɔ, ɛ 'yɩ 'a 'dii kɔ 'a 'baɩ 'hʋɛn‑ a dɛ 'kuku a ‑tɩ 'pa‑, 'a 'yii 'yɩ 'dɔ. 'A 'yii 'dɔ nɩ, ‑ɛ di꞊e nu, nyibli 'mʋ꞊ʋ 'ye, ‑ɛ mɔ, Nyɩsʋa kɔ 'klɩ, 'kɩ bʋ nuu 'ʋ꞊ʋ ‑kʋan 'yie. ");
INSERT INTO ktj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","‑Tɛ ‑nyrɛ 'tɩɛ nɩ 'lɩ, ‑kʋan ‑mʋ', Nyɩsʋa, ‑ɛ lee 'nɛ‑ 'mʋ, ɛ pʋ lɛ ‑ba nu, ‑a kɔ ‑ba nu꞊o. 'Tɔ yɩ 'nɩ ‑wɔn. 'Tɔ 'bʋ ‑wɔn, nyiblo ꞊dʋ 'yɩ 'lɩ ‑kʋan a nunuo 'lɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","‑Tɛ 'n 'tɩɛ nɩ 'nɛ‑ 'klɔ kɩ, 'mɔ ‑yɩ 'klɔ ‑bʋ kɩ a nyibli ‑nyrɛ ‑nyi, ‑ɛ di꞊e nu, ʋ 'mʋ ‑tɩ a ‑tɛɛ lɛ yru.» ");
INSERT INTO ktj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","'Tɩ‑ ɛ 'mʋ 'kɩ ‑yrɛ mɔ mu, ‑ɛ ‑bɩ ɛ pʋ hɩʋn bʋ, 'ɛ nyʋa 'ʋ hɩʋn a 'mʋ ‑tʋtʋ kɩ, 'ɛ nu 'a 'blu, 'ɛ 'du꞊o ye', 'ɛ hri꞊e 'yii'dɔnyɔ a 'mʋ 'yi klɛ, ");
INSERT INTO ktj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ɛ wɛn: «'Wlo ‑mʋ', ʋ 'blu, ʋ dɛɛ Siloe, mu 'lɩ꞊ɩ wien, ꞊mʋ yrɛ yra.» (Siloenyrɛ a 'mʋ, ɛ ꞊hɛn 'nyrɛ lɛlenyɔ.) ‑Tɛ 'yii'dɔnyɔ a 'mʋ, ɛ ‑mu, ‑ɛ ‑bɩ ɛ yra yrɛ. ‑Tɛ ɛ ꞊hɩan ‑mɔ, ‑ɛ ‑bɩ ɛ ‑tʋa lɛyuyruo. ");
INSERT INTO ktj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","'A 'bio kɔ nyibli ‑bɩ ‑mʋ', ‑ʋ yɩ la꞊a lɛ 'ye, ‑tɛ ɛ ‑hʋɛ la 'wli lɛ, ɛ 'mʋ la dɛ di a ‑tɩ, nyibli a pɛpɛ a 'mʋ, kɛ‑ ʋ pɩ, 'ʋ yɩ lɛ 'bɛti ‑nɩ. «꞊Bɩ ɛ 'yɩ nyiblo ‑bʋ, ‑ɛ ‑hʋɛ la 'wli lɛ 'pa‑?» ");
INSERT INTO ktj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","‑Ʋ ‑bɩ wɛn: «Ɛ nɔ‑ ꞊nɩɔ.» Kɛɛ ‑ʋ ‑bɩ wɛn: «'Ʋʋn‑, ɛ 'yɩ꞊ɩ 'pa‑, kɛɛ, ɛ 'wɩ‑ yɩ.» Kɛɛ, nyiblo a 'mʋ, kɛ‑ ɛ pɩ, ɛ wɛn: «'Mɔ ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","‑Ɛ ‑bɩ ʋ yɩ꞊ɩ 'nɩ 'bɛti ‑nɩ, ʋ wɛn: «‑Bɩ' ‑na 'yii nu 'kɩ yɩkɩklɛ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","‑Ɛ ‑bɩ ɛ wɛn: «Nyiblo ‑bʋ, ʋ dɛɛ ‑Yusu, nɔ‑ nyʋa hɩʋn ‑pla. Ɛ nɔ‑ ɛ hri 'mʋ 'yi klɛ, 'tɩ‑ 'ɛ lee 'mʋ, ꞊bʋ mu 'lɩ 'wlo ‑mʋ', ʋ dɛɛ Siloe wien, ‑ɛ di꞊e nu, 'mʋ yrɛ yra, 'nɩ mu 'lɩ, 'nɩ yra yrɛ. ‑Tɛ 'n yra 'kɩ yrɛ, ‑ɛ ‑bɩ 'n ‑tʋa lɛyuyruo.» ");
INSERT INTO ktj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","‑Ɛ ‑bɩ ʋ 'bɛti꞊e nɩ de, ʋ wɛn: «‑Bɩ' nyiblo a 'mʋ, ɛ nɩ yɩ 'lɩ?» ‑Ɛ ‑bɩ ɛ wɛn: «'N 'yɩ 'a ꞊dedede ‑yi.» ");
INSERT INTO ktj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nyiblo a 'mʋ, ‑ɛ kɔ 'yii ꞊dɔ mɔ, 'kɩ ʋ gba 'lɩ꞊ɩ Falisi꞊tumu a nyibli yɩ. ");
INSERT INTO ktj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","'Tɩ‑ ‑nyrɔwɔ ‑mʋ', ‑Yusu nuu 'ʋ ‑pla, ɛ klaa 'ʋ 'a 'yii yɩ, ɛ mɔ ‑wuwle‑nyrɔwɔ* ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ɛ nɔ‑ kɔ ‑tɩ, Falisi꞊tumu a nyibli 'ʋ yɩ nyiblo a 'mʋ 'bɛti ‑nɩ, ‑ɛ mɔ: «Dɛ‑ nu꞊o, ꞊nɩ yrui lɛ 'lɩ?» ‑Ɛ ‑bɩ ɛ wɛn: «Ɛ nu ‑pla, 'ɛ hri꞊e 'na 'yii klɛ, 'nɩ yra yrɛ. ‑Tɛ 'n yra yrɛ, ‑ɛ ‑bɩ 'n ‑tʋa lɛyuyruo.» ");
INSERT INTO ktj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","‑Ɛ ‑bɩ kɛ‑ Falisi꞊tumu a nyibli ‑bɩ pɩ: «Nyiblo ‑mʋ', ‑ɛ mɔ ‑Yusu, ɛ 'yɩ 'lɩ Nyɩsʋa ‑mɔ ‑hɔn, ‑kɔtɩ ɛ 'nɩ ꞊tuu꞊o 'ʋ tetebʋ ‑mʋ', ‑ɛ pɩ lɛ, ‑ɛ mɔ, nyiblo 'nɩ 'nuo 'lɩ ‑kʋan, 'kɩ 'lɩ ‑wuwle‑nyrɔwɔ 'kwli.» ‑Ʋ ‑bɩ wɛn 'nɩ: «'Bʋ mɔ wɛn ‑tonyiblo, ‑ɛ ni dɛ 'kuku, ɛ 'yɩ wɛn 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nu wɛn ꞊wlɩlɛkɛɛ‑tɛblɩ ‑bʋ, ɛ ni.» Dɛ a 'mʋ, ɛ nɔ‑ kɔ ‑tɩ, 'ʋ ꞊gla. ");
INSERT INTO ktj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","‑Ɛ ‑bɩ nyiblo a 'mʋ, ‑ɛ kɔ 'yii ꞊dɔ mɔ, nʋ‑ ʋ yɩ 'bɛti ‑nɩ de: «Nyiblo ‑bʋ, ‑ɛ kla ‑na 'yii yɩ, 'kɩ 'lɩ ‑mʋ 'yi, nyiblo a 'dɩ ‑bɩ ɛ pa 'mʋ 'lɩ?» ‑Ɛ ‑bɩ ɛ wɛn: «'Mɔ ‑bɩ, 'wɛn, ɛ mɔ Nyɩsʋa a winwlɔn‑hanyɔ* ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kɛɛ, ‑Juukʋɛ* a ye'nanyʋ a 'mʋ, ‑ʋ mɔ Falisi꞊tumu a nyibli, ʋ 'nɩ ‑pʋ꞊ʋ lɩ꞊ɩ ꞊han‑tɩ, 'kɩ nyiblo a 'mʋ, a 'yii bʋ di mɔ 'dɔ, 'tɩ‑ bʋ di kɛ lɛ yru. Ɛ nɔ‑ mɔ bʋ da 'a 'baɩ kɔ a 'dii 'hʋɛn‑, ");
INSERT INTO ktj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","bʋ 'bɛti ꞊nʋ, ‑ɛ mɔ: «꞊Bɩ sɛyɩ‑sɛyɩ, nyiblo ‑bʋ, 'aan 'yu ꞊nɩɔ? ꞊Bɩ a wɛn 'nɩ, ‑tɛ a kɔ la꞊a, 'a 'yii 'dɔ la nɩ. 'Bʋ mɔ sɛyɩ a ‑tɩ, 'a 'yii 'bʋ 'dɔ la, dɛ‑ kɔ ‑tɩ 'ɛ yrui kɛ lɛ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","‑Ɛ ‑bɩ a 'baɩ kɔ 'a 'dii 'hʋɛn‑, ʋ wɛn: «‑A yi꞊e nɩ, ‑ɛ mɔ, ‑aan 'yu ꞊nɩɔ, ‑a yi꞊e ‑wɛ, ‑ɛ mɔ, ‑tɛ ‑a kɔ la꞊a, 'a 'yii 'dɔ la nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kɛɛ, dɛ ‑bʋ di꞊e nu, bʋ di lɛ yru, ɛ kɔ, nyiblo, ‑bʋ di 'a 'yii a 'mʋ yɩ kla, ɛ nɔ‑ ‑a 'yɩ ‑yi. 'A 'mumu, ba 'bɛti꞊e, ‑ɛ nu꞊o, ɛ 'yɩ 'hɩan 'pa‑. Ɛ ‑wɛ 'lɩ bʋ ‑hɩhɩa 'a mʋ klɛ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ɛ nɔ‑ mɔ ‑tɩ, 'a 'dii kɔ 'a 'baɩ 'hʋɛn‑, ʋ ‑hla, ‑tɛ ʋ yɩ ‑Juukʋɛ a ye'nanyʋ a 'mʋ a hʋannʋ pie a ‑tɩ. 'Ɛ mɔ ‑tɛɛ, ‑Juukʋɛ a ye'nanyʋ a 'mʋ, ʋ pʋ la 'lɩ꞊ɩ nɩ, ‑ɛ mɔ, nyiblo 'bʋ pʋ lɛ, ‑ɛ mɔ, ‑Yusu, nɔ‑ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya, nyiblo a 'mʋ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ pa la 'lɩ Nyɩsʋa a 'kayu bʋ de. ");
INSERT INTO ktj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","‑Tɩ a 'mʋ, ɛ nɔ‑ kɔ ‑tɩ 'a 'dii kɔ 'a 'baɩ 'hʋɛn‑, 'ʋ pʋ lɛ: «Ɛ 'yɩ 'hɩan 'pa‑. 'A 'mumu, ba 'bɛti꞊e.» ");
INSERT INTO ktj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","‑Tɛ 'a 'dii kɔ 'a 'baɩ 'hʋɛn‑, ʋ ‑yrɛ, ‑ɛ ‑bɩ ‑Juukʋɛ a ye'nanyʋ ‑mʋ', ‑ʋ mɔ Falisi꞊tumu a nyibli, ʋ da꞊a nɩ de, ʋ wɛn: «Kɩ mɔ Nyɩsʋa ye', ‑a nɩ mɔ. 'A ‑tɩ, hla ‑tɩ a ‑tɛɛ, ꞊mʋ Nyɩsʋa ‑tɩ a 'yi'bʋalɛ ‑nyi. ‑A mʋ ‑bʋ, ‑a yi꞊e nɩ, ‑ɛ mɔ, ‑Yusu ‑mʋ', ɛ mɔ dɛ'kukununyɔ ꞊nɩɔ. Ɛ 'yɩ 'lɩ Nyɩsʋa ‑mɔ ‑hɔn.» ");
INSERT INTO ktj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Kɛ‑ ɛ pʋ ꞊nʋ yɩ, 'ɛ ꞊tu ꞊nʋ ꞊wɔn: «Bʋ mɔ dɛ'kukununyɔ, ‑ʋ'ʋ‑, bʋ 'yɩ dɛ'kukununyɔ 'pa‑, 'n 'yɩ 'a ꞊dedede ‑yi. Kɛɛ, 'mɔ ‑bɩ, dɛ 'n ‑yi, ɛ nɔ‑ mɔ, 'na 'yii 'dɔ la nɩ, kɛɛ, ‑tɛ ti nɛ ‑bʋ, 'n yrui lɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","‑Ɛ ‑bɩ ʋ wɛn: «Dɛ a 'dɩ ‑bɩ ɛ nu ‑mʋ ‑mɔ 'lɩ? ‑Bɩ' ɛ ‑nu, 'tɩ‑ ꞊nɩ yrui lɛ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","‑Ɛ ‑bɩ ɛ ꞊tu ꞊nʋ ꞊wɔn de, ɛ wɛn: «'Bɩ 'n lee wɛn 'a mʋ nɩ. Kɛɛ, a 'yɩ 'na win nʋa yɩ bʋ ‑pʋ. Dɛ‑ kɔ ‑tɩ 'a ‑hʋɛ꞊ɛ, 'kɩ ꞊bʋ hla꞊a de 'lɩ? 'N yɩ꞊ɩ 'nɩ 'ye, ‑ɛ mɔ, a ‑hʋɛ ba ‑hɛ ‑Yusu a 'mʋ, 'a ‑nagbopʋ* ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ʋ ‑tʋa 'a 'yrilɛ‑hɩhɩa, ʋ wɛn: «‑Mɔ mɔ 'a ‑nagbopi. ‑A mʋ ‑mɔ ‑bɩ, Nyɩsʋa a winwlɔn‑hanyɔ Moise a ‑nagbopʋ ‑a pa 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","‑A yi꞊e nɩ, ‑ɛ mɔ, Moise, nɔ‑ Nyɩsʋa hlee 'lɩ ‑mɔ. Kɛɛ, ‑Yusu ‑mɔ ‑bɩ, ‑tɛ bʋ di yɩ ‑hɔɔn ‑nɩ, ‑a 'yɩ꞊ɩ ‑yi.» ");
INSERT INTO ktj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","‑Ɛ ‑bɩ ɛ wɛn: «‑Yusu ‑bʋ, ‑ɛ nu꞊o, 'nɩ yrui lɛ, 'ba yɩ lɛ nɩ pɩ, ‑tɩtɛ ɛ ‑hɔn 'lɩ, a 'yɩ 'lɩ ‑yi, ɛ kɛɛ 'na ꞊wlɩ lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","‑A yi꞊e nɩ, ‑ɛ mɔ, nyiblo ‑bʋ, ‑ɛ mɔ dɛ'kukununyɔ, 'bʋ yɩ Nyɩsʋa nɩ dɛ, Nyɩsʋa 'nɩ 'wɩn꞊ɩ lɩ 'a win. Kɛɛ, nyiblo ‑bʋ, ‑ɛ ꞊tui 'ʋ Nyɩsʋa, dɛ ‑mʋ', ɛ ‑hʋɛ, 'bʋ yɩ꞊ɩ nɩ ni, nyiblo a 'mʋ, ɛ nɔ‑ kɔ win Nyɩsʋa pɩ nʋa yɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nyiblo ꞊dʋ 'yɩ ‑hʋan nɩ 'wɩn, ‑ɛ mɔ, ‑tonyiblo ‑bʋ, ‑ɛ kɔ 'yii ꞊dɔ, kʋɛ la 'lɩ 'a 'hɩan‑nyrɛ 'yie bʋ, ‑tonyiblo ‑bɩ bʋ di꞊e nu, 'yii'dɔnyɔ a 'mʋ, bʋ di lɛ yru. ");
INSERT INTO ktj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","‑Yusu a 'mumu, 'bʋ 'yɩ wɛn 'lɩ Nyɩsʋa ‑mɔ ‑hɔn, ɛ 'yɩ wɛn 'lɩ ꞊wlɩlɛkɛɛdɛdʋ a 'mʋ, 'a nunuo 'lɩ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","‑Tɛ ʋ 'wɩn ‑tɩ a 'mʋ, ɛ ‑hla, ‑ɛ ‑bɩ ʋ wɛn: «‑Mɔ ‑bʋ, kʋɛ 'lɩ ‑na kʋkɔti 'yie bʋ, ‑ɛ ni dɛ 'kuku nɩ ‑do, ‑mɔ pɩ lɛ, ‑ɛ tʋɛ nɛ ‑a mʋ,» 'ʋ pʋ 'lɩ꞊ɩ ‑patʋ'. ");
INSERT INTO ktj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","‑Yusu 'wɩn nɩ, ‑ɛ mɔ, ʋ pʋ 'lɩ꞊ɩ ‑patʋ'. ‑Tɛ ɛ kɔ꞊ɔ 'hʋɛn‑, ʋ ꞊ŋmee ‑nɩ, ‑ɛ ‑bɩ ‑Yusu wɛn: «‑Tonyibli a pɛpɛ a Nyiblo ‑mʋ', ‑ɛ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya, ꞊bɩ ‑kuo ꞊nɛ ꞊wlʋ yɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","‑Ɛ ‑bɩ nyiblo ‑mʋ', ‑ɛ kɔ 'yii ꞊dɔ mɔ, ɛ wɛn: «Lee 'mʋ, nyiblo a 'dɩ ‑bɩ ɛ pa 'mʋ, ‑ɛ di꞊e nu, 'mʋ꞊ʋ ꞊wlʋ yɩ ‑kuo ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","‑Ɛ ‑bɩ ‑Yusu wɛn: «Ɛ nɔ‑ ‑bʋ yɩ 'kɩ 'ye. 'Mɔ ꞊nɩɔ, 'mɔ ‑bʋ, ‑ɛ yɩ 'lɩ ‑mʋ ‑mɔ ‑hlee ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","‑Ɛ ‑bɩ ɛ wɛn: «Kʋkɔnyɔ, 'n kuo ‑mʋ ꞊wlʋ yɩ,» 'ɛ bla꞊a kwlɩ yɩ bʋ, 'kɩ 'ʋ 'a ‑tɩ a 'yi'bʋalɛ a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","‑Ɛ ‑bɩ ‑Yusu wɛn: «'N di 'nɛ‑ ‑tʋtʋ kɩ nɩ, ‑ɛ di꞊e nu, 'mʋ꞊ʋ nu, nyibli ‑bʋ, ‑ʋ kuo Nyɩsʋa ꞊wlʋ yɩ, ɛ kɔ nyibli ‑bʋ, ‑ʋ 'yɩ꞊ɩ ꞊wlʋ yɩ ‑kuo ‑nɩ, ʋ 'mʋ 'yi lɛ ‑hʋnhɔn ‑nɩ. Ɛ ꞊hɛn 'nyrɛ, nyibli ‑mʋ', ‑ʋ kɔ 'yii ꞊dɔ, ʋ di yru lɛ, kɛɛ, nyibli ‑mʋ', ‑ʋ pɩ lɛ, ‑ɛ mɔ, ʋ yrui lɛ, 'n di ꞊nʋ꞊ʋ 'nɩ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, 'waa 'yii 'dɔ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Falisi꞊tumu* a nyibli ‑bɩ ‑mʋ', ‑ʋ nɩ 'ʋ, ʋ 'wɩn win a 'mʋ nɩ. 'A ‑tɩ, kɛ‑ ʋ pɩ, ʋ wɛn: «꞊Bɩ ɛ ꞊hɛn 'nyrɛ, ‑aan 'mumu, ‑aan 'yii 'dɔ nɩ ‑wɛ 'a?» ");
INSERT INTO ktj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «'Aan 'yii 'bʋ 'dɔ wɛn, ɛ ꞊hɛn 'nyrɛ, 'ba 'yɛ nɩ yru wɛn Nyɩsʋa a ‑tɩ' lɛ, ‑ɛ ‑bɩ Nyɩsʋa a ‑bati 'yɩ wɛn 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ klɔ wɛn 'a mʋ. Kɛɛ, ‑tɛ a pɩ lɛ, ‑ɛ mɔ, a yrui lɛ, ‑ɛ ꞊hɛn 'nyrɛ, a yrui Nyɩsʋa a ‑tɩ' lɛ, 'a ‑tɩ, Nyɩsʋa a ‑bati di 'a mʋ 'nɩ klɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","(‑Juukʋɛ* a ye'nanyʋ, ‑mʋ', ‑Yusu 'tɩɛ yɩ 'lɩ ꞊nʋ ‑mɔ ‑hlee ‑nɩ.) Kɛ‑ ɛ pɩ ꞊nʋ yɩ: «꞊Bʋ pʋ꞊ʋ blablɩ kɔ blablɩkɔnyɔ, ‑ɛ mɔ blablɩ'yie꞊tunyɔ ‑wɛ a dɛ yɩ. 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ, ‑ɛ mɔ, blablɩ ‑mʋ', ‑ʋ nɩ 'lɩ ‑gblo 'kwli, nyiblo 'bʋ yɩ 'lɩ ꞊nʋ ‑mɔ nɩ pʋɛ, 'bʋ 'yɛ nɩ naa 'ʋ ‑gblo a 'mʋ, 'a paalɛ', kɛɛ, 'bʋ yɩ ‑gblo 'hʋɩ lɛ nɩ 'yɛɛ ‑nɩ, ɛ 'wɩ yɩ, nyiblo a 'mʋ, ɛ mɔ 'yiyrinyɔ kɔ ‑balʋnyɔ 'hʋɛn‑ ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kɛɛ, 'bʋ naa 'ʋ ‑gblo a 'mʋ, 'a paalɛ', ‑ɛ ‑bɩ, ɛ nɔ‑ mɔ blablɩ a 'mʋ, 'a kʋkɔnyɔ. ");
INSERT INTO ktj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","‑Gblo'yie꞊tunyɔ ‑mʋ', ‑ɛ nɩ 'ʋ ‑gblo a paalɛ', ɛ ‑hɛ blablɩkɔnyɔ a 'mʋ mɛ lɛ, 'ɛ pʋɛ 'lɩ 'a blablɩ ‑mɔ. Blablɩkɔnyɔ a 'mʋ, 'bʋ yɩ 'a blablɩ nɩ dɛ, ‑ɛ ‑bɩ 'a blablɩ a 'mʋ, ʋ kɔ bʋ pʋ꞊ʋ nʋa yɩ bʋ. Blablɩkɔnyɔ a 'mʋ, 'tɩ‑ ɛ 'mʋ 'lɩ 'a ‑nɛ blablɛ ꞊dʋ ‑patʋ' 'hrɔɔ ‑nɩ, ɛ kɔ bʋ da 'a 'nyrɛ. ");
INSERT INTO ktj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","'Bʋ 'hrɔɔ 'kɩ a blablɩ a pɛpɛ a 'mʋ, ‑ɛ ‑bɩ ɛ nɛɛ ꞊nʋ ye', blablɩ a 'mʋ, 'ʋ yɩ꞊ɩ ꞊wien lɛ kʋɛ, ‑kɔtɩ ʋ yi 'a win nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kɛɛ, nyiblo ‑mʋ', 'bʋ nɩ 'ʋ, blablɩ a 'mʋ, 'bʋ 'yɩ꞊ɩ ‑yi, ‑ɛ ‑bɩ ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ kʋɛ꞊ɛ ꞊wien lɛ, kɛɛ, ʋ di 'gba ci lɛ, ‑tɛ ʋ 'yɩ 'a win ‑yi a ‑tɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","'Ledʋ a 'mʋ, ‑Yusu pʋ ‑Juukʋɛ a ye'nanyʋ a 'mʋ yɩ, ʋ 'yɩ꞊ɩ' lɛ ‑yru. ");
INSERT INTO ktj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ de, ɛ wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ, 'mɔ ‑bʋ, 'n 'wɩ‑ blablɩ‑gblo a paalɛ yɩ. ");
INSERT INTO ktj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nyibli a pɛpɛ ‑mʋ', ‑ʋ pɩ lɛ, ‑ɛ mɔ, ʋ mɔ ‑tɛɛ a blablɩkɔnyɔ, ‑ʋ na 'mʋ ye', ‑ʋ ‑hi, 'tɩ‑ 'nɩ ‑di, nyibli a 'mʋ, nʋ‑ mɔ 'yiyrinyibli kɔ ‑balʋnyʋ 'hʋɛn‑. Kɛɛ, blablɩ ‑bʋ, ‑ʋ mɔ ‑tɛɛ a blablɩ, ʋ 'yɩ ꞊nʋ nʋa yɩ bʋ ‑pʋ. ");
INSERT INTO ktj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","'Mɔ ‑mɔ blablɩ‑gblo a paalɛ a 'mʋ. Paalɛ a 'mʋ, 'n pa 'mʋ, nyiblo ‑di 'ʋ naa ‑nɩ, ɛ nɔ‑ Nyɩsʋa di wa. Ɛ di 'nɩ pa, ɛ 'mʋ 'hrɩ, ɛ 'mʋ diidɛ 'ye. ");
INSERT INTO ktj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","'Yiyrinyɔ yɩ 'lɩ 'nɩ di, ɛ 'mʋ 'na blablɩ, ‑ʋ mɔ 'na nyibli 'yri, ɛ 'mʋ ꞊nʋ lɛ 'lɩla ‑nɩ, kɔ, ɛ 'mʋ ꞊nʋ bʋ ‑wɛ a ‑tɩ. 'Mɔ ‑bɩ, 'n di nɩ, ‑ɛ di꞊e nu, 'mʋ nyibli 'klɔ yrayrʋ ‑nyi, ɛ kɔ, 'mʋ ꞊nʋ ꞊han‑tɩ 'yi ꞊hlɔn lɛ nu. ");
INSERT INTO ktj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","'Mɔ ‑bʋ, 'mɔ ‑mɔ ‑tɛɛ a blablɩkɔnyɔ kɔ 'waa ‑tɛɛ a 'yie꞊tunyɔ. ‑Tɛɛ a blablɩkɔnyɔ ‑hɛ 'a dɩɔnʋ a ‑hʋnhlʋn nɩ, 'kɩ 'ʋ 'a blablɩ a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kɛɛ, ‑kʋannunyɔ ‑mʋ', ‑ɛ 'yɩ blablɩ a 'mʋ a kʋkɔnyɔ 'pa‑, ɛ ꞊tui ꞊nʋ 'yie, 'wliyɛ a ‑tɩ. Nyiblodʋ a 'mʋ, 'bʋ mɔ, 'bʋ 'ye ‑ji, 'bʋ yɩ 'lɩ nɩ di, ɛ kɔ bʋ hie 'ʋ blablɩ bʋ, bʋ 'gba ci lɛ, ‑ɛ nu꞊o, ɛ 'yɩ꞊ɩ 'pa‑, ɛ 'yɩ blablɩ a 'mʋ ‑kɔ. ‑Ji 'bʋ nyre 'kɩ 'ʋ, ‑ɛ ‑bɩ ɛ klɔ blablɩ ‑bɩ nɩ, 'a dɛ ‑bɩ ‑mʋ', 'ɛ ‑gbʋgbɛ ‑tɛblɩ 'nyɩ lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","‑Kʋannunyɔ 'bʋ 'ye ‑ji, ɛ 'gbɛ ci, ‑kɔtɩ blablɩ a ‑tɩ, ɛ 'nɩ 'yaa꞊a lɩ꞊ɩ 'kla ‑wliye, ɛ nɔ‑ ‑mɔ ‑bɩ, 'wliyɛ a ‑tɩ, 'ɛ ni ‑kʋan. ");
INSERT INTO ktj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","'Mɔ ‑bʋ, 'mɔ ‑mɔ ‑tɛɛ a blablɩkɔnyɔ. ‑Tɛ 'na 'Baɩ Nyɩsʋa ‑nu, 'ɛ yi 'mʋ, 'na 'mumu, 'nɩ yi꞊e, kɛ‑ 'n nu 'na nyibli, ‑ʋ mɔ 'na blablɩ a yiyie, 'na nyibli a 'mʋ, 'ʋ yi 'mʋ ‑wɛ. 'N ‑hɛ 'na ‑hʋnhlʋn nɩ, 'kɩ 'ʋ 'waa ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","'N kɔ blablɩ ‑bɩ, ‑ʋ 'yɩ 'nɛ‑ 'na ‑gblo ‑bʋ 'kwli ‑nɩ, (ɛ ꞊hɛn 'nyrɛ, 'na nyibli ‑bɩ ‑mʋ', ‑ʋ 'yɩ ‑Juukʋɛ* 'pa‑). 'N kɔ ꞊bʋ naa ꞊nʋ ‑wɛ, ʋ 'mʋ 'na win 'wɩn, ʋ 'mʋ 'mʋ nʋa yɩ bʋ pʋ, ʋ kɔ 'waa 'bio 'hʋɛn‑, ʋ 'mʋ 'yi lɛ ‑bibi ‑nɩ, ʋ 'mʋ 'bla꞊ju nɩ ‑do ‑hɛ, ꞊wɩ yɩ Nyɩsʋa a dakɔ nɩ ‑do, ‑ɛ kɔ blablɩkɔnyɔ nɩ ‑do. ");
INSERT INTO ktj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","'Na 'Baɩ Nyɩsʋa nʋɛ 'mʋ nɩ, ‑kɔtɩ 'n di 'na ‑hʋnhlʋn 'nɩ ‑ha, 'mʋ 'kʋ, ‑ɛ di꞊e nu, 'mʋ ‑hʋnhlʋn a 'mʋ kle ya, 'mʋ 'klɔ 'hrɩ de. ");
INSERT INTO ktj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ 'la 'mʋ, 'bʋ mɔ, 'nɩ 'yɩ꞊ɩ kɩ ‑wɛn. 'Na ꞊gbɛtʋ, 'n ‑hʋɛ ꞊bʋ ‑ha 'na ‑hʋnhlʋn, 'mʋ 'kʋ. 'N kɔ 'klɩ, 'kɩ ꞊bʋ ‑ha 'na ‑hʋnhlʋn, 'n kɔ 'klɩ de, 'kɩ ꞊bʋ ‑mɩa 'na ‑hʋnhlʋn a 'mʋ kle. Ɛ nɔ‑ mɔ dɛ, 'na 'Baɩ Nyɩsʋa lee 'mʋ ꞊bʋ nu.» ");
INSERT INTO ktj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","‑Tɩ a 'mʋ ‑Yusu ‑hla, ɛ nu꞊o nɩ, ‑Juukʋɛ a ye'nanyʋ ‑mʋ', ‑ʋ nɩ 'ʋ, 'ʋ ꞊gla de. ");
INSERT INTO ktj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","'Waa ‑hʋɔhʋɩ wɛn: «'Ku ‑hʋan* nɩ 'ʋ nyiblo ‑bʋ ke'. 'A 'lu ‑hɔn 'ʋ 'hru wlɔn. A 'nɩ 'pʋʋ 'lɩ꞊ɩ nʋa yɩ bʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","‑Ʋ ‑bɩ wɛn: «Nyiblo ‑mʋ', 'ku ‑hʋan nɩ 'ʋ ke', ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nu hihle lɛ. 'Ku ‑hʋan 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nu꞊o, 'yii'dɔnyɔ bʋ yru lɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","‑Tɛ ti ‑hʋɔhʋɩ ‑hi, ‑ɛ ‑bɩ cɛ a ti nyre 'ʋ nɩ. Ti nɩ ‑do a 'mʋ 'yri, lɛ'mimle nɩ 'lɩ Jrusrɛdɩɔ 'kwli, 'kɩ 'ʋ Nyɩsʋa a 'kagbaʋ a ‑ta'. ‑Nyrɔwɔ ‑mʋ', ‑ɛ kɔ 'kwli ʋ ꞊tu la 'lɩ 'kagbaʋ a 'mʋ Nyɩsʋa ‑jɩ' bʋ, ‑nyrɔwɔdʋ a 'mʋ, ɛ nɔ‑ nyre 'ʋ de, ɛ nɔ‑ kɔ lɛ'mimle ʋ ni. ");
INSERT INTO ktj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","'Kɩ ‑Yusu nɩ 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli, pʋpa ‑mʋ', ʋ dɛɛ Salomɔ a pʋpa, ɛ nɔ‑ ɛ yɩ 'ʋ blɛ ‑hihie ‑nɩ, ");
INSERT INTO ktj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","‑Juukʋɛ a ye'nanyʋ 'ʋ 'kukue 'ʋ꞊ʋ 'hʋɩ lɛ. Kɛ‑ ʋ pɩ꞊ɩ yɩ, ʋ wɛn: «Ti nɩ ‑tie ‑a di ‑ple, ‑ɛ di 'ʋ nyre, 'tɩ‑ ꞊mʋ ‑a mʋ ‑lee ‑nɩ, nyiblo a 'dɩ ‑bɩ ‑pa 'mʋ? ꞊Nɩ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ‑a mʋ yɩ ya, ‑ɛ ‑bɩ ‑bʋ lee nɛ ‑a mʋ ‑dodo.» ");
INSERT INTO ktj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","‑Ɛ ‑bɩ ɛ wɛn: «'N lee mɔ 'a mʋ nɩ, kɛɛ, ‑tɩ ‑bʋ, 'n yɩ 'a mʋ ‑lee ‑nɩ, a 'nɩ ‑pʋ꞊ʋ lɩ꞊ɩ ꞊han‑tɩ'. ꞊Wlɩlɛkɛɛ‑tɛblɩ ‑bʋ, 'n ni, 'kɩ 'lɩ Nyɩsʋa a 'nyrɛ 'kwli, ɛ tʋɛ nɛ 'a mɔ꞊ɔ nɩ, nyiblo a 'dɩ ‑bɩ 'n pa 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kɛɛ, ‑tɩ ‑bʋ, 'n hlɛ, a 'nɩ ‑pʋ꞊ʋ lɩ꞊ɩ ꞊han‑tɩ, ‑ɛ nu꞊o a 'yɩ 'na nyibli 'pa‑. ");
INSERT INTO ktj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","'Bʋ mɔ, 'nɩ yɩ win nɩ pɩ, 'na nyibli pɩ 'mʋ nʋa yɩ bʋ, 'nɩ yi ꞊nʋ, 'ʋ yɩ 'mʋ ꞊wien kʋɛ. ");
INSERT INTO ktj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","'Na nyibli a 'mʋ, 'n yɩ ‑nyi ꞊nʋ 'klɔ yrayrʋ, ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ. Ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ ‑wɛ bʋ, 'klɔ ‑mɔ 'klɔ. Nyiblo ꞊dʋ 'yɩ 'klɩ ‑kɔ, bʋ ‑ha 'mʋ ꞊nʋ ‑jɩ'. ");
INSERT INTO ktj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","'Na 'Baɩ Nyɩsʋa, nɔ‑ ‑nyi 'mʋ ꞊nʋ. 'A 'klɩ nɩ 'ʋ 'klɩ a pɛpɛ 'lu yɩ. 'A ‑tɩ, ɛ 'yɩ nyiblo ꞊dʋ ‑kɔ, ‑bʋ kɔ 'klɩ, ‑bʋ ‑ha nyiblo ꞊dʋ 'na 'Baɩ Nyɩsʋa ‑jɩ'. ");
INSERT INTO ktj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","'N kɔ 'na 'Baɩ Nyɩsʋa 'hʋɛn‑, ‑a mɔ dɛ nɩ ‑do ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","‑Tɛ ‑Juukʋɛ a ye'nanyʋ ‑nɩ wɛn, ʋ 'wɩn ‑tɩ a 'mʋ, ɛ ‑hla, ‑ɛ ‑bɩ ʋ 'du 'hɩ ye' lɛ de, ʋ 'mʋ ꞊nɛ꞊ɛ ‑mɔ lɛ pʋ, ʋ 'mʋ꞊ʋ 'la. ");
INSERT INTO ktj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «'Kɩ 'lɩ 'na 'Baɩ Nyɩsʋa a 'klɩ 'kwli, 'n nu ꞊haan‑tɛblɩ ‑hʋɔhʋɩ, 'kɩ 'ʋ 'a mʋ ye'. ꞊Haan‑tɩ a 'dɩ ‑bɩ, ‑kɔtɩ 'a pɩ lɛ, a 'mʋ 'mʋ 'la 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","‑Ɛ ‑bɩ ʋ ꞊tu꞊o ꞊wɔn, ʋ wɛn: «Ɛ 'yɩ ‑bʋ nu ꞊haandɛ a ‑tɩ 'pa‑, ‑a ꞊nɩ ꞊mʋɔ꞊ɔ lɩ ‑na 'lɩla lɛ, kɛɛ ‑yɩ ‑hɛɛ Nyɩsʋa a ‑tɩ lɛ. Ɛ nɔ‑ kɔ ‑tɩ, ꞊a ‑hʋɛ ‑na 'lɩla. ‑Mɔ ‑bʋ, ‑ɛ mɔ ‑tonyiblo, ‑mɔ pɩ lɛ, ‑mɔ Nyɩsʋa ꞊nɩɔ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «Ʋ 'crɩ la꞊a nɩ, 'kɩ 'lɩ 'aan tetecrɩɛn 'kwli, ‑ɛ mɔ Nyɩsʋacrɩɛn: Nyɩsʋa wɛn 'nɩ: A mɔ nyɩsʋapʋ ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","‑Tɩ ‑mʋ', Nyɩsʋa hlaa 'lɩ 'a 'crɩɛn 'kwli, nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ hla꞊a, ‑ɛ mɔ, ɛ 'yɩ ‑tɩ a ‑tɛɛ 'pa‑. Nyibli ‑mʋ', ɛ lee win a 'mʋ, nʋ‑ ɛ dɛɛ nyɩsʋapʋ. ");
INSERT INTO ktj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","'Mɔ ‑bɩ, Nyɩsʋa pʋ 'mʋ 'kɩbɩa kɩ, 'mʋ 'a ‑kʋan nu a ‑tɩ. Ɛ nɔ‑ lee 'nɛ‑ 'mʋ 'klɔ ‑bʋ kɩ. 'A mʋ ‑mɔ ‑bɩ, a wɛn 'nɩ, 'mɔ ‑hɛɛ Nyɩsʋa a ‑tɩ lɛ, ‑tɛ 'n hlɛ꞊ɛ, ‑ɛ mɔ, 'mɔ Nyɩsʋa a 'Yu ꞊nɩɔ a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","'Bʋ mɔ, ‑kʋan ‑bʋ, 'n ni, 'bʋ 'yɩ Nyɩsʋa a kɩwɛɛnlɛ 'pa‑, ‑ɛ ‑bɩ a 'nɩ 'kuo 'lɩ 'mʋ ꞊wlʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kɛɛ, 'bʋ mɔ, ‑kʋan ‑bʋ, 'n ni, ‑ɛ mɔ Nyɩsʋa a kɩwɛɛnlɛ, 'ba 'yɛ nɩ ‑hʋa ba kuo 'mʋ ꞊wlʋ yɩ, ‑ɛ ‑bɩ ‑kʋan a 'mʋ, ɛ nɔ‑ ba kuo ꞊wlʋ yɩ, ‑ɛ di꞊e nu, a 'mʋ꞊ʋ' lɛ yru ‑tɛɛ, ‑ɛ mɔ, 'n kɔ 'na 'Baɩ 'hʋɛn‑, ‑a mɔ dɛ nɩ ‑do ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ‑Juukʋɛ a ye'nanyʋ a 'mʋ, ʋ ꞊mʋɛ 'hru lɛ de, 'kɩ bʋ klɔ꞊ɔ, kɛɛ, ɛ ta ꞊nʋ ‑jɩ', 'ɛ ‑mu. ");
INSERT INTO ktj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ 'kɩ 'lɩ Sudɛn a 'nikɩ ‑tɩtɛ nɩ ‑do ‑mʋ', Saan pɩɩ la 'lɩ nyibli 'nie 'lu lɛ, ti ‑hi la a ti 'yri, 'kɩ ‑Yusu ‑hi 'lɩ ti ‑hʋɔhʋɩ, ");
INSERT INTO ktj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","nyibli ‑hʋɔhʋɩ 'ʋ mi 'lɩ꞊ɩ ‑mɔ, ʋ wɛn: «Saan 'yɩ ꞊wlɩlɛkɛɛ‑tɛblɩ ꞊dʋ ‑nu, kɛɛ, ‑tɩ a pɛpɛ ‑mʋ', ɛ hla la, 'kɩ 'ʋ ‑Yusu a ‑ta', ɛ mɔ ‑tɩ a ‑tɛɛ ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","'Kɩ 'ʋ ‑tuo nɩ ‑do a 'mʋ kɩ, nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, 'waa ‑hʋɔhʋɩ kuo ‑Yusu ꞊wlʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ɛ kɔ la ‑Yusu a nɩnatumu ꞊dʋ. 'A 'nyrɛ mɔ Lasa. 'Kɩ ɛ nɩ 'lɩ Betanidɩɔ 'kwli, 'kɩ 'lɩ Sudeblʋgba 'kwli, ɛ kɔ 'a 'dɩayɩ nyrɔyo nɩ 'hʋɛn 'hʋɛn‑. 'Waa 'nyrɛ mɔ, Mari kɔ Matɩ. ");
INSERT INTO ktj_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mari, nɔ‑ mɔ nʋgba ‑mʋ', ‑ɛ gba la hɩnhrʋnpʋnyra, ‑ɛ 'wla la꞊a ‑Yusu a bʋɩ klɛ, 'tɩ‑ ‑ɛ nu la 'a dɩɔnʋ a 'lu‑pupui, ‑ɛ 'hran la ‑Yusu a bʋɩ lɛ. 'Waa 'dɩayɩ Lasa, nɔ‑ 'kʋɛ ‑klɔ; ");
INSERT INTO ktj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","'dɩayɩ nyrɔyo a 'mʋ, 'ʋ le nyiblo, 'kɩ 'lɩ ‑Yusu ‑mɔ, 'kɩ bʋ lee ꞊nɛ, ‑ɛ mɔ: «‑Na nɩnatumu Lasa a 'hʋɩ yɩ 'nɩ hren.» ");
INSERT INTO ktj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","‑Tɛ ‑Yusu 'wɩn titie a 'mʋ, ‑ɛ ‑bɩ ɛ wɛn: «Lasa a 'hʋɩ a hinhren 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ 'la꞊a. Kɛɛ, ɛ di tɔɔ ꞊nɛ nyibli yɩ, ‑ɛ mɔ, Nyɩsʋa kɔ 'klɩ, kɔ ‑tɩ a 'yi'bʋalɛ. 'Kɩ Nyɩsʋa di 'lɩ 'hʋɩ a hinhren a 'mʋ 'kwli ‑naa ‑nɩ, ɛ 'mʋ꞊ʋ nyibli yɩ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, 'mɔ ‑bʋ, ‑ɛ mɔ Nyɩsʋa a 'Yu, 'n kɔ ‑tɩ a 'yi'bʋbʋa.» ");
INSERT INTO ktj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","'Dɩayɩnʋ nɩ ta a 'mʋ, ‑ʋ mɔ Matɩ kɔ Mari kɔ Lasa 'hʋɛn‑, ‑Yusu nʋɛ ꞊nʋ nɩ dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ɛ mɔ ꞊han‑tɩ, 'ɛ nʋɛ ꞊nʋ dɩakɩ, kɛɛ, ‑tɛ ɛ 'wɩn Lasa a 'hʋɩhrennyrɛ, ‑tɩtɛ ‑mʋ', ɛ nɩ 'lɩ, ɛ ‑hii 'lɩ ‑nyrɔwɩ nɩ 'hʋɛn, ");
INSERT INTO ktj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","'tɩ‑ 'ɛ lee nɛ 'a ‑nagbopʋ*, ɛ wɛn: «‑Ba 'du ye', ‑ba mu 'lɩ Sudeblʋgba 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","‑Ɛ ‑bɩ 'a ‑nagbopʋ wɛn: «Tɔɔnyɔ o, ‑tɩtɛ ‑mʋ', ‑pʋ lɛ, ‑ba mu 'lɩ, 'kɩ ʋ ‑hʋɛ bʋ bii mɔ 'lɩ ‑mʋ 'hɩ, bʋ 'la mɔ ‑mʋ, dɛ a 'mʋ, 'a ti 'yɛɛ kɩ bʋ nɩ hlʋɛ. ‑Ɛ ‑bɩ, 'kɩ ‑hʋɛ ‑ba mu 'lɩ de?» ");
INSERT INTO ktj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","‑Ɛ ‑bɩ ‑Yusu wɛn: «‑Nyrɔwɔ kɔ 'a ‑nɛ ti, halɔ 'ɛ kɔ 'a ‑nɛ ti. Nyiblo 'bʋ yɩ ‑nyrɛ' nɩ ‑nɛɛ ‑nɩ, 'a bʋɩ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ bibi lɛ, ‑ɛ nu꞊o, ɛ yɩ nyiblo ‑mʋ' 'nɩ 'ye, ‑ɛ yɩ 'klɔ ‑bʋ a nyibli ‑nyrɛ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kɛɛ, nyiblo 'bʋ yɩ 'tɔ' nɩ ‑nɛɛ ‑nɩ, 'a bʋɩ kɔ bʋ bibi lɛ, halɔ a ‑tɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","‑Ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ de, ɛ wɛn: «‑Aan nɩnatumu yɩ 'nɩ ŋme, kɛɛ, 'n mi nɩ, 'mʋ꞊ʋ ŋmena' ‑ha.» ");
INSERT INTO ktj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","‑Ɛ ‑bɩ 'a ‑nagbopʋ wɛn: «Kʋkɔnyɔ o, 'bʋ yɩ nɩ ŋme, ɛ 'wɩ yɩ, 'a 'hʋɩ di 'nɩ 'kee ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kɛɛ, dɛ ‑mʋ', ‑Yusu pʋ lɛ, ‑ɛ mɔ, Lasa yɩ 'nɩ ŋme, ɛ 'wɩ yɩ 'kʋkʋʋ ɛ ꞊hɛn 'nyrɛ. Kɛɛ, 'a ‑nagbopʋ ‑mɔ bɩ, 'waa ꞊wlɩ 'ye꞊e nɩ, ‑ɛ mɔ, sɛyɩ a ŋmena a ‑tɩ ɛ hlɛ. ");
INSERT INTO ktj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","‑Yusu 'yɩ 'kɩ ꞊nʋ ‑tɩ ꞊dʋ 'yi kɩ ‑hlii ‑nɩ de, 'ɛ lee ꞊nʋ, ‑ɛ mɔ: «Lasa 'kʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Kɛɛ, 'aan ‑tɩ, 'n kɔ plɔ a bleelɛ, 'kɩ ꞊bʋ 'yɩ 'ʋ Lasa 'hʋɩ ‑nɩ, ‑ɛ nu꞊o, dɛ a 'mʋ, ɛ di 'a mʋ 'nɩ ‑hɛɛ ‑nɩ, 'kɩ ba kuo 'mʋ ꞊wlʋ yɩ. 'A ‑tɩ, ‑ba mu 'ʋ꞊ʋ 'hʋɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","‑Ɛ ‑bɩ Toma, ʋ dɛɛ ꞊Yrupʋyu, ɛ nɔ‑ yɩ 'a 'bio ‑nagbopʋ ‑lee ‑nɩ, ɛ wɛn: «‑Ba kʋɛ ‑Yusu ꞊wien, ‑ɛ di꞊e nu, ɛ kɔ ‑a mʋ 'hʋɛn‑, ‑a 'mʋ 'ʋ ‑tɩtɛ nɩ ‑do 'kʋʋ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","‑Tɛ ‑Yusu yɩ 'lɩ 'dɩɔ a 'mʋ 'kwli nyre mɔ nɩ mi, ‑ɛ ‑bɩ ɛ 'wɩn nɩ, ‑ɛ mɔ, ‑tɛ ʋ ‑ha 'ʋ Lasa, ɛ kɔ kɛ ‑nyrɔwɩ nɩ ‑hɛn. ");
INSERT INTO ktj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betanidɩɔ 'mʋɛ Jrusrɛdɩɔ yrɛ. 'Waa ‑mɔlɛhʋhlɔ 'yɩ 'lɩ ‑kilowɩ nɩ ta ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ɛ nɔ‑ kɔ ‑tɩ, ‑Juukʋɛ* ‑hʋɔhʋɩ 'ʋ ‑hɔn 'lɩ Jrusrɛ, 'ʋ di Matɩ kɔ Mari 'hʋɛn‑ yɩ ‑mɛ mɔ, ʋ 'mʋ 'lɩ ꞊nʋ ꞊wlʋ 'kwli bʋ ꞊tu, 'waa 'dɩayɩ Lasa a 'kʋkʋ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","‑Tɛ Matɩ 'wɩn, ‑ɛ mɔ, 'kɩ ‑Yusu yɩ 'lɩ di, ‑ɛ ‑bɩ ɛ mu꞊o yɩ 'bɛ mɔ, kɛɛ, 'kɩ Mari ‑mɔ ‑bɩ, ɛ nɩ 'lɩ 'kayu bʋ. ");
INSERT INTO ktj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","‑Tɛ Matɩ nyre 'ʋ ‑Yusu 'hʋɩ, ‑ɛ ‑bɩ ɛ wɛn: «Kʋkɔnyɔ o, 'bʋ mɔ, ꞊nɩ nɩ mɔ 'nɛ‑, 'na 'dɩayɩ 'yɩ wɛn 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ 'kʋ wɛn. ");
INSERT INTO ktj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kɛɛ, ‑tɛ ti nɛ ‑bʋ, 'n yi꞊e nɩ, ‑ɛ mɔ, 'a ‑nɛ dɛ, ‑di Nyɩsʋa ‑hʋa, ɛ di꞊e 'nɩ nu.» ");
INSERT INTO ktj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","‑Ɛ ‑bɩ ‑Yusu wɛn: «‑Na 'dɩayɩ di 'hrɩ 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","‑Ɛ ‑bɩ Matɩ wɛn: «Iin, 'n yi꞊e nɩ, ‑ɛ mɔ, lɛ'bɔɔ‑nyrɔwɔ a ti 'yri, ti ‑mʋ', ‑ɛ kɔ 'yri Nyɩsʋa di nyibli 'klɔ ‑ha.» ");
INSERT INTO ktj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","‑Ɛ ‑bɩ ‑Yusu wɛn: «'Mɔ ‑hɛ 'lɩ ‑tonyibli 'kʋkʋnyibli 'nyɩ lɛ, ‑ɛ yɩ ꞊nʋ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ ‑nyi. Nyiblo 'bʋ kuo 'mʋ ꞊wlʋ yɩ, ‑ɛ ‑bɩ 'n ‑nyi꞊e 'klɔ yrayrʋ a 'mʋ. 'Ye ꞊bɩɩ ɛ 'kʋ, ɛ 'tɩɛ di 'klɔ a 'mʋ kɔ. ");
INSERT INTO ktj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nyiblo ‑bʋ, ‑ɛ pɩ ‑hʋnhlʋn, 'bʋ mɔ, 'bʋ kuo 'mʋ ꞊wlʋ yɩ, ‑ɛ ‑bɩ sɛyɩ‑sɛyɩ ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ 'kʋ. ꞊Bɩ dɛ a 'mʋ, ‑pʋ꞊ʋ ꞊han‑tɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","‑Ɛ ‑bɩ ɛ wɛn: «Iin, Kʋkɔnyɔ, 'n pʋ꞊ʋ ꞊han‑tɩ, ‑ɛ mɔ, ‑mɔ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ‑ɛ di la 'a dakɔ yɩ ya. ‑Mɔ mɔ Nyɩsʋa a 'Yu, ‑ɛ di la 'nɛ‑ 'klɔ ‑bʋ kɩ di.» ");
INSERT INTO ktj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ Matɩ mu 'a 'dɩayɩ Mari da mɔ, 'ʋ bii yɩ, ɛ wɛn: «Tɔɔnyɔ di nɩ, ‑mɔ ɛ dɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","‑Tɛ Mari 'wɩn dɩdawin a 'mʋ, ‑ɛ ‑bɩ ɛ 'kɩka nɩ, 'ɛ 'du ye', 'ɛ mu 'lɩ ‑Yusu 'hʋɩ. ");
INSERT INTO ktj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","‑Yusu a 'mʋ, ɛ 'yɛɛ 'dɩɔ nɩ 'yɛ. ‑Tɩtɛ nɩ ‑do ‑mʋ', Matɩ yɛɛ wɛn 'ʋ꞊ʋ bʋ, 'kɩ ɛ 'tɩɛ nɩ 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","‑Juukʋɛ* ‑mʋ', ‑ʋ di 'lɩ꞊ɩ ꞊wlʋ 'kwli bʋ ꞊tu mɔ, ‑tɛ ʋ 'ye꞊e, ‑ɛ mɔ, Mari a 'mʋ, ɛ 'kɩka nɩ, 'ɛ 'hrɩ, ‑ɛ ‑bɩ 'waa 'mumu, ʋ 'du ye', 'ʋ kʋɛ꞊ɛ ꞊wien. Ʋ nʋ‑ ‑mɔ ‑bɩ, ʋ daa ꞊nɛ, 'kɩ ɛ mi 'lɩ 'dabio yɩ, ɛ 'mʋ we. ");
INSERT INTO ktj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","‑Tɛ Mari nyre 'ʋ ‑tɩtɛ ‑mʋ', ‑Yusu nɩ 'ʋ, ‑tɛ ɛ 'ye꞊e, ‑ɛ ‑bɩ ɛ 'gbla kwlɩ, 'kɩ 'ʋ 'a bʋɩ ꞊hlɔn, ɛ wɛn: «Kʋkɔnyɔ o, ꞊nɩ nɩ mɔ 'nɛ‑, 'na 'dɩayɩ 'yɩ wɛn 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ 'kʋ wɛn.» ");
INSERT INTO ktj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","‑Tɛ Mari pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ‑Yusu 'ye꞊e nɩ, ‑ɛ mɔ, ɛ yɩ 'nɩ we, ɛ kɔ nyibli ‑mʋ', ‑ʋ kʋɛ꞊ɛ ꞊wien, 'ʋ yɩ we ‑wɛ. Dɛ a 'mʋ, ɛ bʋbla꞊a yɩ bʋ dɩakɩ, kɔ, 'ɛ nie ꞊nɛ nyaɩ dɩakɩ, ");
INSERT INTO ktj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","‑ɛ ‑bɩ ɛ wɛn: «‑Tɛ a ‑ha 'ʋ꞊ʋ, ‑bɩ' a ꞊tuu ꞊nɛ yɩ lɩ?» ‑Ɛ ‑bɩ ʋ wɛn: «Kʋkɔnyɔ, di 'lɩ, ꞊mʋ 'ʋ ‑tɩtɛ a 'mʋ 'ye.» ");
INSERT INTO ktj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","‑Ɛ ‑bɩ ‑Yusu ‑tʋa wuwe. ");
INSERT INTO ktj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, ʋ wɛn: «Ba 'ye kɛ, ɛ nʋɛ ꞊nɛ nɩ dɩakɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","'Kɩ 'lɩ nyibli a 'mʋ 'nyɩ, 'kɩ nyibli nɩ 'lɩ, ʋ wɛn: «'Bɩ nɔ‑ kla mɔ 'yii'dɔnyɔ a 'yii yɩ. Ɛ kɔ bʋ nu wɛn 'kɩ꞊ɩ, 'kɩ Lasa 'yɛɛ di wɛn nɩ 'kʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","‑Yusu bʋblɛ yɩ bʋ de, 'ɛ mu 'lɩ 'dabio yɩ. 'Dabio a 'mʋ, ɛ mɔ 'hɩɔ a 'hʋɔ ꞊nɩɔ. 'Kɩ ɛ nɩ 'lɩ dʋgba 'kwli, 'ʋ nu 'hɩɔkɩbɩa, 'ʋ ka꞊a yɩ. ");
INSERT INTO ktj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","‑Ɛ ‑bɩ ‑Yusu wɛn: «Ba ‑ha 'ʋ 'hɩɔ ‑mʋ', ʋ ‑nu, 'ʋ ka 'dabio yɩ.» Kɛɛ, kɛ‑ Lasa a 'dɩayɩ nyrɔyu Matɩ pɩ: «Kʋkɔnyɔ o, ɛ di pʋ 'nʋ, ‑ɛ nu꞊o, ɛ ‑hii 'lɩ 'dabio 'kwli ‑nyrɔwɩ nɩ ‑hɛn.» ");
INSERT INTO ktj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","‑Ɛ ‑bɩ ‑Yusu ꞊tu꞊o ꞊wɔn, ɛ wɛn: «'N lee wɛn ‑mʋ nɩ, ‑ɛ mɔ, ꞊nɩ kuo 'mʋ ꞊wlʋ yɩ, ‑di Nyɩsʋa a ‑tɩ a 'yi'bʋbʋa 'nɩ 'ye.» ");
INSERT INTO ktj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ɛ nɔ‑ mɔ bʋ ‑ha 'ʋ 'hɩɔ a 'mʋ, ‑Yusu 'ɛ 'du 'lu ye', 'ɛ ta 'lɩ yakɔ 'kwli lɛ, ɛ wɛn: «'Na 'Baɩ, 'n ‑nyi ‑mʋ 'wio, ‑kɔtɩ ‑wɛn 'na lɛnyaawin kɩ. ");
INSERT INTO ktj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","'N yi꞊e nɩ, ‑ɛ mɔ, 'a ‑nɛ ti, ‑yɩ wɛn 'na lɛnyaawin kɩ. Kɛɛ, ‑tɩ ‑bʋ, 'n ‑hla, 'n hla꞊a nɩ, nyibli ‑bʋ, ‑ʋ ꞊glaa 'lɩ 'mʋ lɛ a ‑tɩ, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ ꞊han‑tɩ pʋ, ‑ɛ mɔ, ‑mɔ lee 'nɛ‑ 'mʋ 'klɔ ‑bʋ kɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","‑Tɛ ɛ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ɛ 'yaa 'lɩ win, ɛ wɛn: «Lasa, 'hrɩ 'lɩ 'dabio 'kwli!» ");
INSERT INTO ktj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ Lasa 'hrɩ nɩ. 'A bʋɩ kɔ 'a dabʋɩ 'hʋɛn‑, ʋ 'tɩɛ 'hɩnhɩʋɛn ‑jisɛ lɛ, kɔ, 'ʋ 'hɩnhɩʋan 'a 'lu dakɩbɩa lɛ. ‑Ɛ ‑bɩ ‑Yusu wɛn: «Ba ꞊wlɛ꞊ɛ, kɔ, ba ‑ha꞊a mɛ lɛ, bʋ na.» ");
INSERT INTO ktj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","‑Juukʋɛ ‑mʋ', ‑ʋ mu Mari yɩ ‑mɛ mɔ, ‑ʋ 'ye dɛ ‑mʋ', ‑Yusu ‑nu, 'waa ‑hʋɔhʋɩ kuo ‑Yusu ꞊wlʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kɛɛ, 'kɩ 'lɩ ꞊nʋ 'nyɩ, nyibli ‑bɩ nɩ 'lɩ, 'ʋ mu Falisi꞊tumu* a nyibli 'ye mɔ, 'ʋ lee ꞊nʋ dɛ a 'mʋ, ‑Yusu ‑nu. ");
INSERT INTO ktj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","‑Tɛ ʋ 'wɩn, ‑ɛ ‑bɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ, kɔ Falisi꞊tumu a nyibli a 'mʋ 'hʋɛn‑, ʋ kɔ 'waa nyibli gbagbɩ 'hʋɛn‑, ʋ da ‑gbolugbo, ʋ wɛn: «‑Bɩ' ‑a di 'kɩ nu 'lɩ, ‑ɛ nu꞊o, nyiblo ‑bʋ, ɛ ni ꞊wlɩlɛkɛɛ‑tɛblɩ ‑hʋɔhʋɩ? ");
INSERT INTO ktj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","'Bʋ mɔ, ꞊ba ‑ha꞊a mɛ lɛ, bʋ 'tɩɛ yɩ꞊ɩ 'lu ‑mɔ nɩ gbɛ, nyibli a pɛpɛ di kuo ꞊nɛ ꞊wlʋ yɩ, 'tɩ‑ Romakʋɛ a nyibli gbagbɩ 'mʋ di, ʋ 'mʋ ‑a mʋ gbatɩ klɛ ‑ha, ‑a mʋ ‑bʋ, ‑ʋ mɔ Nyɩsʋa a 'kagbaʋ ‑bʋ, kɔ ‑aan dakɔ a nyibli gbagbɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","'Kɩ 'lɩ ꞊nʋ 'nyɩ, nyiblo ‑mʋ', ‑ɛ mɔ la 'yrʋ a 'mʋ bʋ, 'a ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ, ɛ wɛn: «A 'yɩ ꞊dedede a lɛyuyruo ‑kɔ. ");
INSERT INTO ktj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","꞊Bɩ ɛ 'yɩ ‑tɛɛ ‑nu, 'kɩ nyiblo nɩ ‑do, 'bʋ 'kʋ, 'kɩ 'ʋ ‑aan dakɔ a pɛpɛ a ‑ta', 'ɛ ‑hi 'ʋ ‑aan dakɔ a pɛpɛ a 'mʋ bʋ ‑wɛ bʋ?» ");
INSERT INTO ktj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Sɛyɩ‑sɛyɩ, win a 'mʋ, ɛ ‑pʋ, ɛ 'yɩ 'a dɩɔnʋ a 'lulɛ‑hihie 'pa‑. Kɛɛ, ‑tɛ ɛ mɔ 'yrʋ a 'mʋ, 'a ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ, ‑ɛ nɔ‑ kɔ ‑tɩ Nyɩsʋa 'ɛ ꞊tu꞊o win a 'mʋ wlɔn, 'ɛ hlɛ꞊ɛ, ‑ɛ mɔ, ‑Yusu di 'nɩ 'kʋ, 'kɩ 'ʋ ‑Juukʋɛ a dakɔ a pɛpɛ a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kɛɛ, ɛ 'yɩ 'ʋ ‑Juukʋɛ nɩ ‑do a ‑ta' 'pa‑, ɛ 'nɩ 'kʋ꞊ʋ nɩ. Kɛɛ, ɛ di 'nɩ 'kʋ, 'kɩ 'ʋ Nyɩsʋa a 'yonʋ a pɛpɛ, ‑ʋ 'hɛɛn 'blʋgbɩ kɩ bʋ a ‑ta', ‑Yusu a 'mʋ, ɛ 'mʋ ꞊nʋ lɛ 'kukue ‑nɩ, ʋ 'mʋ dɛ nɩ ‑do ‑hɛ. ");
INSERT INTO ktj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kʋɛ 'ʋ ‑nyrɔwɔ a 'mʋ 'yie bʋ, ‑Juukʋɛ a ye'nanyʋ ‑yra꞊a nɩ, 'kɩ bʋ 'la ‑Yusu. ");
INSERT INTO ktj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Dɛ a 'mʋ, ɛ nu꞊o nɩ, ‑Yusu 'nɩ ‑pa꞊a la, 'kɩ 'lɩ nyibli 'nyɩ lɛ de, 'kɩ 'lɩ ‑Juukʋɛ a 'blʋgba 'kwli. ‑Ɛ ‑bɩ ɛ kɔ 'a ‑nagbopʋ* 'hʋɛn‑, 'kɩ ʋ mu 'lɩ 'dɩɔ ‑mʋ', ʋ dɛɛ Eflaimʋ 'kwli, 'ʋ ‑hii 'lɩ ‑nyrɔwɩ ‑hʋɔhʋɩ. 'Kɩ 'lɩ Eflaimʋ a 'mʋ ke', ‑tʋtʋkʋtɩɔ ꞊dʋ nɩ 'lɩ, nyiblo ꞊dʋ 'ɛ 'yɩ 'lɩ kɩ 'ti. ");
INSERT INTO ktj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","‑Juukʋɛ a lɛ'mimle ‑mʋ', ʋ dɛɛ Pakɩ, 'a ti 'mʋɛ yrɛ. 'Tɩ‑ lɛ'mimle a 'mʋ, ɛ 'mʋ 'ʋ nyre, 'blʋgba a 'mʋ, 'a nyibli ‑hʋɔhʋɩ mu 'lɩ Jrusrɛdɩɔ 'kwli, ‑ɛ di꞊e nu, dɛ ‑mʋ', ʋ kɔ bʋ nu, 'tɩ‑ ʋ 'mʋ 'ʋ yɩ 'sii ‑nɩ, 'kɩ 'ʋ Nyɩsʋa ye', ʋ 'mʋ꞊ʋ nu, 'tɩ‑ ʋ 'mʋ lɛ 'mle. ");
INSERT INTO ktj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nyibli a 'mʋ, ʋ ꞊mʋɛ ‑Yusu lɛ. ‑Tɛ ʋ nɩ 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli, ‑ɛ ‑bɩ ʋ ‑tʋa 'ʋ lɛ'bɛtilɛ, ʋ wɛn: «꞊Bɩ 'aan ꞊wlɩ wɛn 'nɩ, ɛ di lɛ'mimle kɩ 'nɩ di?» ");
INSERT INTO ktj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nyɩsʋa a ‑cɔhlʋnpinyʋ gbagbɩ kɔ Falisi꞊tumu a nyibli hla la꞊a nɩ, ‑ɛ mɔ, 'bʋ mɔ, nyiblo ꞊dʋ 'bʋ yi 'ʋ ‑tɩtɛ ‑mʋ', ‑Yusu nɩ 'ʋ, ‑ɛ ‑bɩ bʋ lee ꞊nʋ, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ klɔ. ");
INSERT INTO ktj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","‑Nyrɔwɩ nɩ ꞊hlon‑do ‑hie 'lɩ, ‑Juukʋɛ* a lɛ'mimle ‑mʋ', ‑ɛ mɔ Pakɩ, ɛ 'mʋ 'ʋ nyre, 'kɩ ‑Yusu kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ mu 'lɩ Betanidɩɔ 'kwli. 'Kɩ 'lɩ 'dɩɔ a 'mʋ 'kwli, 'kɩ nyiblo ‑mʋ', ‑ɛ mɔ Lasa, ɛ 'ti 'lɩ. Lasa a 'mʋ, ɛ nɔ‑ ‑Yusu ‑ha mɔ 'lɩ 'kʋkʋnyibli 'nyɩ, ɛ ‑ha mɔ 'klɔ. Lasa a 'mʋ, ɛ kɔ 'a 'dɩayɩ nyrɔyo nɩ 'hʋɛn, Matɩ kɔ Mari 'hʋɛn‑, ʋ nʋ‑ kɔ ‑mɔ ɛ mu 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","‑Tɛ ɛ nyre 'ʋ, ‑ɛ ‑bɩ ʋ pie ꞊nɛ nɩ, Matɩ 'ɛ ‑ha 'lɩ ‑Yusu a diidɛ. Lasa kɔ nyibli ‑bɩ, ʋ kɔ ‑Yusu 'hʋɛn‑, nʋ‑ yɩ diidɛ a 'mʋ di. ");
INSERT INTO ktj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Bʋ yɩ 'kɩ dɛ nɩ di, ‑ɛ ‑bɩ Mari 'du ‑dawinniyrɩɛ ye'. ‑Dawinni a 'mʋ, ɛ pɩ ꞊die dɩakɩ. ‑Tɛ ɛ 'du꞊o ye', ‑ɛ ‑bɩ ɛ plʋ꞊ʋ ‑Yusu a bʋɩ lɛ, 'ɛ nu 'a dɩɔnʋ a 'lunyapli, 'ɛ 'hran ‑Yusu a bʋɩ lɛ, ‑dawinni a hɩnhrʋn 'ɛ 'hɛɛn 'lɩ 'kayu bʋ. ");
INSERT INTO ktj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","‑Tɛ Mari nu dɛ a 'mʋ, ‑ɛ ‑bɩ ‑Yusu a ‑nagbopi ‑bɩ, ‑ɛ kɔ 'nyrɛ mɔ Judɩa Yisikalio, ‑ɛ di ‑Yusu 'a yraanyibli ‑jɩ' pʋ, kɛ‑ ɛ pʋ: ");
INSERT INTO ktj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«'Aa. Dɛ‑ kɔ ‑dawinni a 'mʋ a 'yɩ ‑plo 'lɩ? 'A 'wliyɛ ‑wɛ 'lɩ bʋ mɔ wɛn ‑kʋannunyɔ nɩ ‑do a 'pɛɛwli nɩ, 'kɩ 'lɩ ꞊hɔnpʋɩ nɩ ‑pu 'kwli. 'Bʋ mɔ, 'bʋ plo wɛn꞊ɛ, ‑a ‑wɛ 'lɩ ‑ba ‑nyi wɛn 'a 'wliyɛ ꞊hɩʋɛnnyibli nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ɛ 'yɩ ꞊bɩɩ bʋ kɔ ꞊hɩʋɛnnyibli a nyaɩ a ‑tɩ, bʋ nu 'pʋplɛ lɛ, kɛɛ ‑tɛ ɛ mɔ 'yiyrinyɔ a ‑tɩ, ɛ nɔ‑ kɔ ‑tɩ, 'ɛ ni 'pʋplɛ lɛ. Ɛ mɔ ꞊han‑tɩ, ɛ nɔ‑ ꞊tui 'waa 'wli blɛ, kɛɛ, 'wli a 'mʋ, ɛ ꞊tui blɛ, ɛ kla 'a 'yiyri‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'kɩ, 'ɛ ‑hɩhɩɛ꞊ɛ klɛ, ɛ wɛn: «‑Ha꞊a mɛ lɛ. Dɛ ʋ kɔ bʋ nu wɛn ‑nyrɔwɔ ‑mʋ', ‑ɛ kɔ 'kwli 'n di wɛn 'ʋ 'kʋʋ ‑nɩ, ʋ di wɛn 'ʋ 'mʋ 'ʋ ‑haa ‑nɩ, dɛ a 'mʋ, ɛ nɔ‑ ɛ ‑nu ‑dodo. ");
INSERT INTO ktj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ba kɔ 'a yiyie, ‑ɛ mɔ, ꞊hɩʋɛnnyibli 'tɩɛ di 'nɛ‑ 'a mʋ 'nyɩ nɩ. Kɛɛ, 'mɔ ‑bɩ, ti 'n di 'nɛ‑ 'a mʋ 'nyɩ ‑hii ‑nɩ, ɛ 'yɩ ‑hʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ti nɩ ‑do a 'mʋ 'yri, 'kɩ ‑Juukʋɛ ‑hʋɔhʋɩ 'wɩɩn 'ʋ, ‑ɛ mɔ, 'kɩ ‑Yusu nɩ 'lɩ Betanidɩɔ 'kwli. Ɛ nɔ‑ mɔ bʋ mu 'lɩ. Ɛ 'yɩ ‑Yusu a 'yiye‑tɩ nɩ ‑do a ‑tɩ 'pa‑, ʋ 'yɩ 'lɩ ‑mu. Kɛɛ, ʋ mu 'lɩ nɩ ‑wɛ, ‑ɛ di꞊e nu, Lasa ‑mʋ', ‑Yusu ‑ha mɔ 'lɩ 'kʋkʋnyibli 'nyɩ, ɛ ‑ha mɔ 'klɔ, ʋ 'mʋ꞊ʋ 'ye. ");
INSERT INTO ktj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","‑Ɛ ‑bɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ ‑yra꞊a nɩ, 'kɩ bʋ 'la Lasa ‑wɛ, ");
INSERT INTO ktj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","‑ɛ nu꞊o, ɛ nɔ‑ kɔ ‑tɩ, ‑Juukʋɛ ‑hʋɔhʋɩ 'ʋ kuo ‑Yusu ꞊wlʋ yɩ, 'ʋ 'kee nyibli gbagbɩ a 'mʋ, 'waa ‑mɔnɩna. ");
INSERT INTO ktj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","‑Tɛ ‑nyrɛ ‑nyɛ, ‑ɛ ‑bɩ nyibli ‑mʋ', ‑ʋ di Pakɩ a lɛ'mimle kɩ, ʋ 'wɩn nɩ, ‑ɛ mɔ, ‑Yusu di di Jrusrɛdɩɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","‑Tɛ ʋ 'wɩn 'kɩ, ‑ɛ ‑bɩ ʋ 'bɛ yohran, 'ʋ 'ble꞊e kʋa lɛ, 'ʋ ꞊tɩ 'dɩɔ, 'ʋ mu ‑Yusu ye' 'bɛ mɔ. Kɛ‑ ʋ pɩ, 'ʋ 'yɛɛ 'lɩ win, ʋ wɛn: «‑Na 'wio, ‑mɔ ‑mʋ', ‑ɛ yɩ 'lɩ di, 'kɩ 'lɩ Kʋkɔnyɔ a 'nyrɛ 'kwli. Nyɩsʋa bʋ nu ‑mʋ ꞊haandɛ ‑mɔ. Ba 'ye Yisraɛkʋɛ a bodɩɔ, ‑ɛ yɩ 'lɩ di. Ba 'de ‑ba pʋ꞊ʋ 'nyrɛ lɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","'Kasrayu ꞊dʋ nɩ 'ʋ. Ɛ nɔ‑ kɔ kɩ ‑Yusu 'ya 'ʋ, ꞊wɩ yɩ, ‑tɛ ‑mʋ', Nyɩsʋacrɩɛn nu la 'a hɩhla, ‑ɛ mɔ: ");
INSERT INTO ktj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Sion* (Jrusrɛ) a nyibli, a 'nɩ 'pie 'lɩ hʋannʋ. Ba 'ye kɛ, 'aan bodɩɔ, nɔ‑ yɩ 'lɩ di. 'Kɩ ɛ nɩ 'ʋ 'kasrayu kɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ti a 'mʋ 'yri, ‑tɛblɩ ‑mʋ', ‑Yusu kɔ nyibli ‑mʋ' 'hʋɛn‑, ʋ ni, 'a ‑nagbopʋ* 'nɩ ‑yru꞊o la꞊a' lɛ. Kɛɛ, ti ‑mʋ' ‑kɔ 'yri ‑Yusu mu 'lɩ yakɔ 'kwli, 'kɩ 'lɩ ‑tɩ a 'yi'bʋalɛ 'kwli, 'tɩ‑ 'ɛ bi 'lɩ ꞊nʋ 'kwli, ‑ɛ mɔ, ‑tɩ a ‑tɛɛ ꞊nɩɔ, ‑tɛ ‑mʋ', Nyɩsʋacrɩɛn nu la 'a hɩhla, kɛ‑ nyibli ‑mʋ', ʋ ni la 'a nunuo. ");
INSERT INTO ktj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","‑Tɛ ‑Yusu lee mɔ Lasa, 'kɩ bʋ 'hrɩ mɔ 'klɔ, bʋ ‑hɔn mɔ 'lɩ 'dabio 'kwli, nyibli ‑hʋɔhʋɩ 'ye mɔ dɛ a 'mʋ nɩ, 'ʋ mu mɔ, 'ʋ lee mɔ nyibli ‑bɩ lɛ dɛ a 'mʋ, ‑Yusu ‑nu. ");
INSERT INTO ktj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ɛ nɔ‑ kɔ ‑tɩ, nyibli ‑nɩ wɛn, 'ʋ di꞊e ye' 'bɛ mɔ, ‑kɔtɩ ʋ 'wɩn mɔ nɩ, ‑ɛ mɔ, ‑Yusu nu mɔ ꞊wlɩlɛkɛɛ‑tɛblɩ a 'mʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","‑Ɛ ‑bɩ Falisi꞊tumu* a nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, ʋ nʋ‑ ‑mɔ ‑bɩ, kɛ‑ ʋ pɩ, 'ʋ yɩ 'lɩ lɛ 'pʋplɛ ‑nɩ, ʋ wɛn: «‑A yɩ꞊ɩ 'nɩ 'ye, ‑ɛ mɔ, nyiblo ‑bʋ, ɛ ‑hi ‑a mʋ wlɔn. Nyibli a pɛpɛ yɩ kʋɛ꞊ɛ ꞊wien.» ");
INSERT INTO ktj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","‑Juukʋɛ a lɛ'mimle a 'mʋ a ti 'yri, nyibli ‑mʋ', ‑ʋ mu 'lɩ Jrusrɛdɩɔ 'kwli, ‑ʋ mu Nyɩsʋa da mɔ, 'kɩ 'lɩ ꞊nʋ 'nyɩ, Glɛkɩkʋɛ nɩ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nyibli a 'mʋ, ʋ nʋ‑ mu 'ʋ ‑Yusu a ‑nagbopi* Filipʋ 'hʋɩ. 'Kɩ ɛ kɔ 'lɩ Bɛtɩsaida, ‑ɛ mɔ Galileblʋgba a 'dɩɔ ‑bɩ, ʋ wɛn: «Nyɩbɛyu, ‑a ‑hʋɛ ‑ba yi wɛn ‑Yusu.» ");
INSERT INTO ktj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ɛ nɔ‑ mɔ Filipʋ a 'mʋ, bʋ mu, bʋ lee nɛ 'a 'bɩ Adre, 'tɩ‑ ʋ nɩ 'hʋɛn a 'mʋ, 'ʋ bibi kɩ, 'ʋ ‑mu, 'ʋ lee ‑Yusu. ");
INSERT INTO ktj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","‑Ɛ ‑bɩ ‑Yusu wɛn: «Ti nyre 'ʋ nɩ, 'kɩ 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, Nyɩsʋa bʋ ‑nyi 'mʋ ‑tɩ a 'yi'bʋalɛ. ");
INSERT INTO ktj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","꞊Bʋ pʋ꞊ʋ ‑kʋbʋyɛ a dɛ yɩ. ‑Kʋbʋyɛ 'bʋ 'yɩ ‑tʋtʋ lɛ ‑hrɛn, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ mɩ, kɔ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ pʋ blʋ, kɛɛ, ɛ nɩ ‑do di 'ʋ nɩ. Kɛɛ, 'bʋ mɔ, 'bʋ ‑hrɛn ‑tʋtʋ lɛ, ɛ di 'nɩ mɩ, ɛ 'mʋ blʋ pʋ. ‑Kʋbʋ a 'mʋ, 'a mɩmɩɩ 'wɩ‑ 'kʋkʋʋ yɩ. 'Na 'mumu, 'n 'wɩ‑ ‑kʋbʋyɛ yɩ. 'N kɔ ꞊bʋ 'kʋ, ‑ɛ di꞊e nu, nyibli ‑hʋɔhʋɩ 'mʋ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ kɔ. ");
INSERT INTO ktj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","‑Ɛ ‑bɩ nyiblo 'bʋ 'yɩ ‑mɔ ‑wɛ, bʋ 'kʋ, 'na ꞊wlʋ a yɩkuolɛ a ‑tɩ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ kɔ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ. Kɛɛ, nyiblo 'bʋ ‑wɛ ‑mɔ, 'kɩ bʋ 'kʋ, ‑tɛ ɛ mɔ 'na nyiblo a ‑tɩ, ɛ di kɔ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","'Bʋ mɔ, nyiblo 'bʋ ‑hʋɛ, bʋ nu 'na ‑kʋan, ‑ɛ ‑bɩ ɛ blɛɛ yɩ, bʋ na 'mʋ ‑mɔ, 'a ‑nɛ ‑tɩtɛ, 'n di 'ʋ mu, ɛ kɔ bʋ mu 'ʋ ‑wɛ, 'ye ꞊bɩɩ ɛ mɔ 'lɩ 'kʋʋlɛ'. 'A ‑nɛ nyiblo, 'bʋ yɩ 'na ‑kʋan nɩ ni, 'na 'Baɩ Nyɩsʋa, nɔ‑ di꞊e ‑tɩ a 'yi'bʋalɛ ‑nyi.» ");
INSERT INTO ktj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«‑Tɛ ti nɛ ‑bʋ, 'na ‑hihiu hlɔɔ 'mʋ ‑mɔ lɛ. ‑Bɩ' 'n di 'kɩ 'na 'Baɩ yɩ pʋ 'lɩ? ꞊Bɩ kɛ‑ ꞊bʋ pʋ: 'Na 'Baɩ Nyɩsʋa o, nu꞊o, ꞊hɩʋɛn'yeti, ‑ɛ di 'lɩ di, bʋ hlɔɔ 'mʋ ‑mɔ lɛ. 'Ʋʋn‑, 'nɩ ‑pʋ꞊ʋ lɛ nɩ, ‑ɛ nu꞊o, ꞊hɩʋɛn'yeti a 'mʋ, nɔ‑ 'mʋ 'lɩ wlɔn ‑naa ‑nɩ, ɛ nɔ‑ kɔ ‑tɩ, 'nɩ di 'nɛ‑ 'klɔ ‑bʋ kɩ. ");
INSERT INTO ktj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Kɛ‑ 'n di pʋ: 'Na 'Baɩ o, nu꞊o, ‑na ‑tɩ bʋ 'bʋa 'yi.» Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ Nyɩsʋa a win ‑hɔn 'lɩ yakɔ 'kwli, 'ɛ pɩ lɛ: «'N ‑wɛ 'a nunuo ‑mɔ, 'na ‑tɩ 'ɛ 'bʋa 'yi, kɛɛ, 'n kɔ ꞊bʋ nu꞊o de.» ");
INSERT INTO ktj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, ʋ 'wɩn win a 'mʋ nɩ, ʋ wɛn: «Yakɔ, ‑ɛ ꞊ma.» ‑Ʋ ‑bɩ wɛn: «Nyɩsʋa a lɛlenyɔ ‑bɩ, ‑ɛ yɩ 'plɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kɛɛ, ‑Yusu wɛn: «Ɛ 'yɩ 'na ‑tɩ 'pa‑, win a 'mʋ, ɛ 'yɩ ‑pɩɩ ‑nɩ, 'a mʋ kɔ ‑tɩ ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ti ‑bʋ, ‑ɛ kɔ 'yri Nyɩsʋa di 'ʋ 'klɔ a nyibli ‑bati lɛ ‑pʋʋ ‑nɩ, ɛ nyre 'ʋ nɩ. ‑Tɛ ti nɛ ‑bʋ, Nyɩsʋa di 'klɔ ‑bʋ, 'a nyiblo gbagbʋ Satan lɛ 'nɩ bla. ");
INSERT INTO ktj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","'Mɔ ‑bɩ, ti ‑mʋ' ‑kɔ 'yri ʋ di 'ʋ 'mʋ ye' 'duu ‑nɩ, 'kɩ 'ʋ tugbɛ 'yie, 'mʋ ‑tʋtʋ ‑mɔ lɛ ‑hlɔɔ ‑nɩ, ti a 'mʋ 'yri, 'n di꞊e 'nɩ nu, nyibli a pɛpɛ 'mʋ 'mʋ lɛ 'mʋɛ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","'Kʋkʋʋdʋ ‑mʋ', ɛ di la 'kʋ, ɛ nɔ‑ ɛ ꞊hɛn 'nyrɛ. Ɛ nɔ‑ kɔ ‑tɩ, 'ɛ nu 'pʋplɛ lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","‑Ɛ ‑bɩ kɛ‑ nyibli ‑mʋ', ʋ pɩ꞊ɩ yɩ, ʋ wɛn: «'Kɩ 'lɩ Nyɩsʋa a tetecrɩɛn 'kwli, ʋ 'crɩ la 'lɩ꞊ɩ nɩ, ‑ɛ mɔ, Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ‑a mʋ yɩ ya, ɛ di hie 'klɔ. Dɛ‑ kɔ ‑tɩ, ‑mɔ ‑bɩ, ꞊nɩ pɩ lɛ, ‑ɛ mɔ, nyiblo ‑mʋ', ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, ʋ di 'du꞊o ye', 'kɩ 'ʋ tugbɛ 'yie, ɛ 'mʋ ‑tʋtʋ ‑mɔ lɛ ‑hlɔɔ ‑nɩ? Nyiblo a 'dɩ ‑bɩ, ‑ɛ mɔ 'kɩ ‑tonyibli a pɛpɛ a Nyiblo 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ, ɛ wɛn: «‑Nyrɛ 'tɩɛ di 'nɛ‑ 'a mʋ 'nyɩ nɩ, 'kɩ 'lɩ ti gbi 'kwli. ‑Tɛ ‑nyrɛ a 'mʋ, ɛ 'tɩɛ nɩ 'nɛ‑ 'a mʋ 'nyɩ, 'kɩ ba na꞊a 'mʋ, ‑ɛ di꞊e nu, halɔ 'nɩ ꞊ha 'a mʋ bʋ ꞊hu, ‑kɔtɩ nyiblo ‑mʋ', ‑ɛ nɛɛ halɔ 'nyɩ, ‑tɩtɛ ‑mʋ', ɛ mi 'ʋ, ɛ 'yɩ 'ʋ ‑yi. ");
INSERT INTO ktj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","'A ‑tɩ, ‑tɛ ‑nyrɛ 'tɩɛ nɩ 'nɛ‑ 'a mʋ 'nyɩ, ba kuo ꞊nɛ ꞊wlʋ yɩ, ‑ɛ di꞊e nu, a 'mʋ nyibli ‑mʋ' pa, ‑ʋ nɛɛ ‑nyrɛ'.» ‑Tɛ ‑Yusu ‑wɛ ‑tɩ a 'mʋ, 'a hɩhla ‑mɔ, ‑ɛ ‑bɩ ɛ hlɔɔ ꞊nʋ ‑mɔ lɛ, 'ɛ ‑hli ꞊nʋ 'yi kɩ. ");
INSERT INTO ktj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ɛ mɔ ꞊han‑tɩ, 'ɛ nu ꞊wlɩlɛkɛɛ‑tɛblɩ, 'ʋ ‑hʋ, kɛɛ, nyibli 'yɩ꞊ɩ ꞊wlʋ yɩ ‑kuo ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Dɛ a 'mʋ, ɛ mu 'lu ‑mɔ, ‑ɛ di꞊e nu, ‑tɩ ‑mʋ', Nyɩsʋa a winwlɔn‑hanyɔ Esai hla la, ɛ 'mʋ ‑nue ‑nɩ. ‑Tɩ a 'mʋ, Esai hla la, ɛ nɔ‑ ‑bʋ: «Nyɩsʋa o, ‑tɩ ‑bʋ, ‑a hlɛ, nyiblo a 'dɩ ‑bɩ, ‑ɛ pʋ꞊ʋ ꞊han‑tɩ 'lɩ? Nyiblo a 'dɩ ‑bɩ, ‑ɛ yru ‑na 'klɩkɩnɩnɩɩ 'lɩ? Ɛ 'yɩ 'a nyiblo ꞊dʋ ‑kɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","‑Tɩ ‑bʋ, ‑kɔtɩ 'kɩ ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ kuo ‑Yusu ꞊wlʋ yɩ, Esai a 'mʋ, ɛ hla꞊a nɩ. Kɛ‑ ɛ pʋ: ");
INSERT INTO ktj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Nyɩsʋa nu꞊o nɩ, 'waa 'yii 'ɛ 'dɔ, ‑ɛ di꞊e nu, ʋ 'nɩ ꞊ha dɛ lɛ yru, kɔ, 'ɛ nu꞊o, 'waa ꞊wlɩ 'ɛ 'gboklo ‑nɩ, ‑ɛ di꞊e nu, ʋ 'nɩ ꞊ha ‑tɩ' lɛ yru. Ɛ mɔ ꞊han‑tɩ, 'bʋ mɔ, 'bʋ yɩ wɛn ‑tɩ' lɛ nɩ yrui, ʋ di 'mʋɛ wɛn꞊ɛ yrɛ, ‑ɛ di꞊e nu, ɛ 'mʋ wɛn ꞊nʋ wa.» ");
INSERT INTO ktj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Esai a 'mʋ, ɛ hla ‑tɩ a 'mʋ nɩ, ‑kɔtɩ ɛ 'ye la ‑Yusu a ‑tɩ a 'yi'bʋalɛ nɩ, 'ɛ hla la ‑Yusu a 'mʋ, 'a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ɛ mɔ ꞊han‑tɩ Esai 'ɛ nu hihle lɛ, kɛɛ ‑Juukʋɛ a ye'nanyʋ ‑hʋɔhʋɩ, ʋ kuo ‑Yusu ꞊wlʋ yɩ ‑wɛ. Kɛɛ, ʋ 'yɩ꞊ɩ ‑hla, 'kɩ 'ʋ nyibli ye', ‑ɛ nu꞊o, ʋ yɩ pie Falisi꞊tumu* a nyibli a hʋannʋ, ‑kɔtɩ 'bʋ 'wɩn, ʋ di bla ꞊nʋ lɛ, 'kɩ 'lɩ Nyɩsʋa a 'kayo a pɛpɛ blɛ. ");
INSERT INTO ktj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ʋ ‑hʋɛ꞊ɛ nɩ, nyibli bʋ 'yaa 'lɩ 'waa 'nyrɛ, 'ɛ ‑hi 'ʋ Nyɩsʋa bʋ 'yaa 'lɩ 'waa 'nyrɛ. ");
INSERT INTO ktj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","‑Ɛ ‑bɩ ‑Yusu 'yɛɛ 'lɩ win, 'ɛ yɩ nyibli ‑lee ‑nɩ, ɛ wɛn: «Nyiblo 'bʋ nɩ 'ʋ, 'bʋ kuo 'mʋ ꞊wlʋ yɩ, ɛ 'yɩ 'mɔ nɩ ‑do 'pa‑, ɛ 'yɩ 'mʋ ꞊wlʋ yɩ ‑kuo ‑nɩ, kɛɛ, 'na 'Baɩ ‑mʋ', ‑ɛ lee 'nɛ‑ 'mʋ 'klɔ ‑bʋ kɩ, ɛ nɔ‑ ɛ kuo ꞊wlʋ yɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nyiblo 'bʋ 'ye 'mʋ, ‑ɛ ‑bɩ ɛ 'ye 'na 'Baɩ ‑mʋ' nɩ ‑wɛ, ‑ɛ lee 'nɛ‑ 'mʋ 'klɔ kɩ. ");
INSERT INTO ktj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","'N di 'nɛ‑ 'klɔ ‑bʋ kɩ nɩ, ꞊wɩ yɩ ‑nyrɛ, ‑ɛ di꞊e nu, 'a ‑nɛ nyiblo 'bʋ kuo 'mʋ ꞊wlʋ yɩ, ɛ 'nɩ ꞊ha 'lɩ halɔ 'nyɩ nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nyiblo 'bʋ yɩ 'na win nɩ 'wɩn, 'tɩ‑ bʋ 'yɛ nɩ ꞊tuu 'ʋ win a 'mʋ, ɛ 'yɩ 'mɔ 'pa‑, 'nɩ ‑pʋʋ꞊ʋ lɩ꞊ɩ ‑bati lɛ nɩ, ‑kɔtɩ 'mɔ ‑bɩ, 'n di nɩ, 'kɩ ꞊bʋ wa nyibli. 'N 'yɩ ‑di, 'kɩ ꞊bʋ pʋʋ nyibli ‑bati lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nyiblo 'bʋ hɩa 'mʋ yɩ, kɔ, 'bʋ 'yɛ nɩ pʋ 'mʋ nʋa yɩ bʋ, ‑ɛ ‑bɩ 'kɩ 'lɩ lɛ'bɔɔ‑nyrɔwɔ 'kwli, ‑bati di꞊e 'nɩ klɔ, ‑tɛ ɛ 'yɩ 'na win nʋa yɩ bʋ ‑pʋ a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ɛ mɔ ꞊han‑tɩ, ɛ 'yɩ 'lɩ 'mɔ nɩ ‑do a 'klɩ 'kwli 'pa‑, 'n 'yɩ 'lɩ ‑tɔɔ ‑nɩ, kɛɛ, 'na 'Baɩ ‑mʋ', ‑ɛ lee 'nɛ‑ 'mʋ 'klɔ kɩ, nɔ‑ lee 'mʋ ‑tɩ ‑mʋ', 'n kɔ ꞊bʋ tɔɔ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","'N yi꞊e nɩ, ‑ɛ mɔ, ‑tɩ ‑mʋ', ɛ ‑hʋɛ ꞊bʋ tɔɔ nyibli, nɔ‑ ni꞊e, nyibli 'ʋ kʋɛ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ. Ɛ nɔ‑ kɔ ‑tɩ, ‑tɩ nɩ ‑do ‑mʋ', 'na 'Baɩ lee 'mʋ ꞊bʋ tɔɔ nyibli, ɛ nɩ ‑do, nɔ‑ 'n tʋɛ ꞊nʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ɛ hie 'lɩ ‑nyrɔwɔ nɩ ‑do, ‑Juukʋɛ* a lɛ'mimle, ‑ɛ mɔ Pakɩ, ɛ 'mʋ 'ʋ nyre. ‑Yusu yi꞊e nɩ, ‑ɛ mɔ, ti nyre 'ʋ nɩ, 'kɩ bʋ ‑hɔn 'nɛ‑ 'klɔ ‑bʋ kɩ, ɛ 'mʋ 'lɩ 'a 'Baɩ Nyɩsʋa ‑mɔ mu. Nyibli ‑mʋ' ‑ʋ mɔ 'a nyibli, 'kɩ 'nɛ‑ 'klɔ ‑bʋ kɩ, ɛ nʋɛ ꞊nʋ nɩ ti a pɛpɛ, kɔ, ɛ 'cibi 'ʋ 'waa nʋɛlɛ. ");
INSERT INTO ktj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","‑Winse, 'kɩ ‑Yusu kɔ 'a ‑nagbopʋ 'hʋɛn‑ ʋ nɩ 'ʋ dɛdiilɛ'. 'Tɩ‑ ʋ 'mʋ dɛ di, ɛ 'yɩ 'kayu a ‑kʋannunyɔ ꞊dʋ ‑kɔ, ‑bʋ yra ꞊nʋ bʋɩ lɛ, ꞊wɩ yɩ, ‑tɛ ‑Juukʋɛ ni꞊e lɛ. 'Kɩ ʋ nɩ 'kɩ 'ʋ dɛdiilɛ a 'mʋ, 'kuo ‑hʋɩn* a nyiblo gbagbʋ Satan, 'ɛ lee Judɩa Yisikalio, ‑ɛ mɔ Simɔ a 'yu, 'kɩ bʋ pʋ ‑Yusu 'a yraanyibli ‑jɩ'. ");
INSERT INTO ktj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","‑Yusu a 'mʋ, ɛ yi꞊e nɩ, ‑ɛ mɔ, Nyɩsʋa ‑nyi꞊e 'klɩ, 'kɩ bʋ kɔɔ ‑tɛblɩ a pɛpɛ win kɩ, 'ɛ yi꞊e ‑wɛ, ‑ɛ mɔ, 'kɩ ɛ ‑hɔn 'lɩ Nyɩsʋa ‑mɔ, kɔ, ɛ 'mʋ ‑mɔ ꞊hɩan, ɛ 'mʋ 'lɩ꞊ɩ ‑mɔ mu. ");
INSERT INTO ktj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","꞊Han‑tɩ, 'ɛ yi ‑tɛblɩ a pɛpɛ a 'mʋ, kɛɛ, ɛ 'du ye', 'ɛ ‑hɛ a 'luyɩwlawlʋ, 'ɛ 'du ‑pledanʋ ye', 'ɛ mʋa꞊a ‑gbɩ kɩ bʋ, ");
INSERT INTO ktj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","'ɛ pʋ 'lɩ 'nie 'pɔlʋ 'kwli, 'ɛ ‑tʋa 'a ‑nagbopʋ a bʋɩ a lɛyɩyra. 'Bʋ yra 'a ‑nagbopi ‑bɩ a bʋɩ lɛ, ‑ɛ ‑bɩ ɛ kɔ bʋ nu ‑pledanʋ a 'mʋ, ɛ mʋa wɛn ‑gbɩ kɩ bʋ, bʋ 'hran 'a bʋɩ lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nɔ‑ ɛ nu ‑nunu, 'ɛ nyre 'ʋ Simɔ Piɛlɩ 'hʋɩ. ‑Tɛ ɛ nyre 'kɩ 'ʋ꞊ʋ 'hʋɩ, ‑ɛ ‑bɩ Simɔ Piɛlɩ wɛn: «Kʋkɔnyɔ, ꞊bɩ ꞊mʋ 'na bʋɩ lɛ yra?» ");
INSERT INTO ktj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","‑Ɛ ‑bɩ ‑Yusu wɛn: «Dɛ ‑bʋ, 'n ni, ‑tɛ ti nɛ ‑bʋ, ꞊nɩ ‑yru꞊o 'lɩ꞊ɩ' lɛ, kɛɛ, 'kɩ 'lɩ ye' 'kɩ ‑di 'lɩ꞊ɩ' lɛ ‑yruu ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","‑Ɛ ‑bɩ Piɛlɩ wɛn: «'Klɔ a 'klɔ, ꞊nɩ ‑yra꞊a 'na bʋɩ lɛ nɩ.» ‑Ɛ ‑bɩ ‑Yusu wɛn: «'Bʋ mɔ, 'nɩ 'yɩ ‑na bʋɩ lɛ ‑yra, ꞊nɩ ‑mɔ꞊ɔ 'na nyiblo nɩ de.» ");
INSERT INTO ktj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","‑Ɛ ‑bɩ Simɔ Piɛlɩ wɛn: «'Bʋ mɔ 'kɩ 'a ‑tɩ, ɛ 'nɩ 'mɔɔ 'lɩ 'na bʋɩ nɩ ‑do, kɛɛ, yra 'mʋ ꞊jrɛ, ‑bʋ yra 'na 'lu lɛ ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","‑Ɛ ‑bɩ ‑Yusu wɛn: «Nyiblo 'bʋ ‑ple, 'bʋ na lɛ dɛ gbe, ɛ 'nɩ ‑ple꞊e 'kɩ nɩ de, 'bʋ 'yɩ bʋ yra bʋɩ lɛ nɩ ‑do 'pa‑, ‑ɛ nu꞊o, ɛ 'wʋ 'lɩ nɩ ‑tɛɛ. 'A mʋ ‑mɔ ‑bɩ, a 'wʋ 'lɩ nɩ. Kɛɛ, ɛ 'yɩ 'aan pɛpɛ 'pa‑, a 'yɩ 'lɩ 'wʋ.» Ɛ 'wɩ yɩ, 'waa yɩ'siilɛ, 'kɩ 'ʋ Nyɩsʋa yɩ, ɛ nɔ‑ kɔ ‑tɩ ‑Yusu ꞊hɛn 'nyrɛ. ");
INSERT INTO ktj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ɛ yi nyiblo ‑mʋ', ‑ɛ di꞊e 'a yraanyibli ‑jɩ' pʋ nɩ, 'kɩ 'lɩ ꞊nʋ 'nyɩ. Nɔ‑ nu꞊o, 'ɛ pʋ lɛ: «Ɛ 'yɩ 'aan pɛpɛ 'pa‑, a 'yɩ 'lɩ 'wʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","‑Tɛ ɛ ‑wɛ 'waa bʋɩ a lɛyɩyra ‑mɔ, ‑ɛ ‑bɩ ɛ pʋ 'a 'luyɩwlawlʋ nɩ, 'ɛ nɩ bʋ de, 'kɩ 'ʋ dɛdi‑tuo nɩ ‑do a 'mʋ kɩ, ɛ wɛn: «Dɛ ‑bʋ, 'n nu 'a mʋ ‑mɔ, dɛ, ‑ɛ ꞊hɛn 'nyrɛ, ꞊bɩ a yru꞊o' lɛ? ");
INSERT INTO ktj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","'Ba yɩ 'mʋ nɩ dɛ, kɛ‑ a pɩ: Tɔɔnyɔ, kɔ Kʋkɔnyɔ 'hʋɛn‑. 'Tɩ‑ 'ɛ mɔ ꞊han‑tɩ, 'nɩ mɔ꞊ɔ. ");
INSERT INTO ktj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","'A ‑tɩ o, 'mɔ ‑bʋ, ‑ɛ mɔ 'aan Tɔɔnyɔ kɔ 'aan Kʋkɔnyɔ 'hʋɛn‑, ‑tɛ 'n ꞊tɩɔ 'lɩ 'na dɩɔnʋ, 'nɩ yra 'a mʋ bʋɩ lɛ, 'a ‑tɩ, 'aan 'mumu, ba ꞊tɩɔ 'lɩ 'aan dɩɔnʋ ‑wɛ, nyiblo 'bʋ nɩ 'ʋ, ɛ 'mʋ 'a 'bɩ a bʋɩ lɛ yra. ");
INSERT INTO ktj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","'N tɔɔ nɛ 'a mɔ꞊ɔ nɩ, ‑ɛ mɔ, 'n ꞊tɩɔ 'lɩ 'na dɩɔnʋ nɩ, 'nɩ ‑hɛ 'aan lɛleyu, ‑ɛ di꞊e nu, dɛ ‑bʋ, 'n nu 'a mʋ ‑mɔ, a 'mʋ꞊ʋ nu ‑wɛ, 'kɩ 'lɩ 'a mʋ 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑kʋannunyɔ ꞊dʋ 'yɩ 'ʋ 'a nyiblo gbagbʋ 'lu yɩ ‑nɩ, mɔ, lɛleyu 'yɩ 'ʋ nyiblo ‑mʋ', ‑ɛ yɩ 'ʋ꞊ʋ ‑tɩtɛ lɛ tɛ 'lu yɩ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","'A ‑tɩ o, a yi 'kɩ꞊ɩ nɩ. 'Bʋ mɔ, 'ba yɩ꞊ɩ nɩ ni, a di kɔ plɔ a bleelɛ. ");
INSERT INTO ktj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ɛ 'yɩ 'aan pɛpɛ 'pa‑, 'n 'yɩ 'a mʋ 'nyrɛ ꞊hɛn. Nyibli ‑mʋ', 'n ‑ha 'lɩ, 'kɩ ‑bʋ na 'mʋ ‑mɔ, 'n yi ꞊nʋ nɩ. Kɛɛ, ‑tɩ ‑mʋ', ʋ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, ɛ blɛɛ yɩ, bʋ mu 'lu ‑mɔ. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: Nyiblo ‑bʋ, ‑ɛ kɔ 'mʋ 'hʋɛn‑, ‑a 'nyrɛ 'lɩ 'pɔlʋ nɩ ‑do dabʋ 'kwli, ɛ nɔ‑ ‑hɛ 'na yraanyɔ. ");
INSERT INTO ktj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","'N hlɛ 'a mɔ꞊ɔ yɩ nɩ ‑dodo, 'tɩ‑ ɛ 'mʋ 'ʋ nyre, ‑ɛ di꞊e nu, ti ‑mʋ' ‑kɔ 'yri ɛ di 'ʋ nyre, a 'mʋ 'mʋ ꞊wlʋ yɩ ‑kuo ‑nɩ, ‑ɛ mɔ, 'mɔ ‑mɔ nyiblo ‑mʋ', Nyɩsʋa lee 'nɛ‑ ‑tʋtʋ kɩ. ");
INSERT INTO ktj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, nyiblo 'bʋ nɩ 'ʋ, 'bʋ 'ble 'na lɛleyu kʋa, ɛ 'wɩ yɩ, 'mɔ ɛ 'ble kʋa. Kɔ, nyiblo 'bʋ 'ble 'mʋ kʋa, ɛ 'wɩ yɩ, 'na 'Baɩ Nyɩsʋa, ‑ɛ tɛ 'nɛ‑ 'mʋ, nɔ‑ ɛ 'ble kʋa.» ");
INSERT INTO ktj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","'Tɩ‑ ‑Yusu 'mʋ win a 'mʋ pʋ mɔ mu, ‑ɛ ‑bɩ 'a ꞊wlʋ 'mʋɛ bʋ dɩakɩ. Ɛ 'yɩ 'a ‑nagbopʋ* ꞊dedede 'yi kɩ ‑hlii ‑nɩ, kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, nyiblo nɩ 'nɛ‑ 'a mʋ 'nyɩ. Ɛ nɔ‑ di 'mʋ 'na yraanyibli ‑jɩ' pʋ, ‑ʋ ꞊mʋɛ 'na 'lɩla lɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","‑Ɛ ‑bɩ ʋ ‑tʋa 'lɩ 'yilɛtɩtalɛ. Nyiblo a 'dɩ ‑bɩ ‑Yusu bʋ di 'nyrɛ ꞊hɛn, 'kɩ 'lɩ ꞊nʋ 'nyɩ, ʋ 'yɩ꞊ɩ ‑yi. ");
INSERT INTO ktj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","‑Nagbopi ‑bɩ nɩ 'ʋ, ‑Yusu ‑nʋɛ ‑nɩ ‑tɛɛ. Nɔ‑ nɩ 'ʋ ‑Yusu 'hʋɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ɛ nɔ‑ Simɔ Piɛlɩ nu ‑jie, ɛ lee ‑nɩ, bʋ 'bɛti ‑Yusu, nyiblo a 'dɩ ‑bɩ ‑Yusu ꞊hɛn 'nyrɛ, ");
INSERT INTO ktj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","‑nagbopi a 'mʋ 'ɛ hlee 'lɩ ‑Yusu nʋa', 'ɛ 'bɛti꞊e, ɛ wɛn: «Kʋkɔnyɔ, nyiblo a 'dɩ ‑bɩ ꞊hɛn 'nyrɛ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","‑Ɛ ‑bɩ ‑Yusu wɛn: «'Flɔɔkʋtɩɔ ‑bʋ, 'n di 'lɩ 'yanu ‑mɔ 'nyra, nyiblo, 'n di꞊e ‑nyi, nyiblo a 'mʋ, ɛ nɔ‑ ꞊nɩɔ,» 'ɛ 'du 'flɔɔkʋtɩɔ ye', 'ɛ 'nyra 'lɩ꞊ɩ 'yanu ‑mɔ, 'ɛ ‑nyi꞊e Judɩa, ‑ɛ mɔ Simɔ Yisikalio a 'yu. ");
INSERT INTO ktj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","'Tɩ‑ Judɩa 'mʋ 'flɔɔkʋtɩɔ a 'mʋ di mɔ mu, ‑ɛ ‑bɩ Satan kɔɔ ꞊nɛ win kɩ pɛpɛ. Kɛ‑ ‑Yusu pɩ 'kɩ꞊ɩ yɩ, ɛ wɛn: «Pʋ 'lɩ 'klɩ lɛ, dɛ ‑kɔ ‑bʋ nu, ꞊mʋ꞊ʋ nu.» ");
INSERT INTO ktj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nyibli a pɛpɛ ‑mʋ', ‑ʋ nɩ 'ʋ dɛdi‑tuo a 'mʋ kɩ, 'waa 'yɛɛ ꞊dʋ 'yɩ꞊ɩ ‑yi, ‑tɩ ‑bʋ, ‑kɔtɩ ‑Yusu 'ɛ nu 'pʋplɛ lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","‑Tɛ Judɩa mɔ la 'kɩ 'wliblɛ꞊tunyɔ, 'a ‑tɩ, ‑ʋ ‑bɩ wɛn 'nɩ, ‑Yusu lee la꞊a nɩ, 'kɩ bʋ mu la lɛ'mimle a diidɛ ‑tɔ, ‑ʋ ‑bɩ wɛn 'nɩ, ‑ɛ mɔ, ‑Yusu lee la꞊a nɩ, 'kɩ bʋ ‑ha 'lɩ 'wliyɛ, bʋ ‑nyi꞊e ꞊hɩʋɛnnyibli. ");
INSERT INTO ktj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","‑Tɛ Judɩa a 'mʋ, ɛ ‑wɛ 'kɩ 'flɔɔkʋtɩɔ a 'mʋ lɛ, ‑ɛ ‑bɩ ti nɩ ‑do a ti 'yri, ɛ bi 'lɩ ‑patʋ', 'kɩ 'lɩ halɔ 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","‑Tɛ Judɩa bi 'kɩ 'lɩ ‑patʋ', ‑ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'kɩ 'a ‑nagbopʋ yɩ, ɛ wɛn: «‑Tɛ ti nɛ ‑bʋ, 'mɔ ‑bʋ, ‑ɛ mɔ ‑tonyibli a pɛpɛ a Nyiblo, 'na ‑tɩ a 'yi'bʋalɛ di bi pepe'. 'N di꞊e 'nɩ nu, nyibli 'mʋ Nyɩsʋa a ‑tɩ a 'yi'bʋalɛ 'ye ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","'Bʋ mɔ, 'nɩ nu dɛ a 'mʋ, ‑ɛ ‑bɩ Nyɩsʋa di꞊e 'nɩ nu ‑wɛ, nyibli 'mʋ 'na ‑tɩ a 'yi'bʋalɛ 'ye. Ɛ 'tɩɛ ni꞊e nɩ. Ɛ di ‑nyi 'mʋ ꞊haanbʋnɩɩlɛ, 'kɩ 'ʋ 'a dɩɔnʋ 'hʋɩ. ");
INSERT INTO ktj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","'Na 'yonʋ ‑na, ti ‑mʋ', 'n 'tɩɛ di 'nɛ‑ 'a mʋ 'hʋɩ ‑hi, ɛ 'yɩ 'kɩ ‑hʋ de. A di ꞊mʋɔ 'mʋ lɛ. Kɛɛ, ‑tɩ nɩ ‑do ‑mʋ', 'n lee la ‑Juukʋɛ* a ye'nanyʋ, nɔ‑ 'n di 'a mʋ ‑lee ‑nɩ ‑wɛ. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: ‑Tɩtɛ 'n mi 'lɩ, a 'yɩ 'lɩ mumuo ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","'N yɩ ‑nyi 'a mʋ tetebʋ yrayrʋ. Tetebʋ a 'mʋ, ɛ nɔ‑ ‑bʋ: Ba nʋnʋɛ ‑nɩ. ‑Tɛ 'n nu 'aan nʋɛlɛ, kɛ‑ ba nu, ba nʋnʋɛ ‑nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","'Bʋ mɔ, 'ba nʋnʋɛ ‑nɩ, ‑ɛ ‑bɩ nyibli a pɛpɛ di꞊e 'nɩ yru, ‑ɛ mɔ, a mɔ 'na ‑nagbopʋ ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","‑Ɛ ‑bɩ Simɔ Piɛlɩ 'bɛti꞊e nɩ, ɛ wɛn: «Kʋkɔnyɔ, ‑bɩ' ‑mii yɩ 'lɩ?» ‑Ɛ ‑bɩ ‑Yusu ꞊tu꞊o ꞊wɔn, ɛ wɛn: «‑Tɛ ti nɛ ‑bʋ, ‑tɩtɛ 'n mi 'lɩ, ꞊yɩ 'lɩ 'na ꞊wienkʋkʋɛ ‑wɛ. Kɛɛ, ti di 'ʋ 'nɩ nyre, ‑ɛ kɔ 'yri ‑di 'ʋ 'mʋ ꞊wien ‑kʋɛ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","‑Ɛ ‑bɩ Piɛlɩ wɛn: «Kʋkɔnyɔ, 'n ‑wɛ ‑mɔ, 'kɩ ꞊bʋ ‑ha 'na ‑hʋnhlʋn, 'kɩ 'ʋ ‑na ‑ta'. Dɛ‑ kɔ ‑tɩ ꞊nɩ pɩ lɛ, ‑ɛ mɔ, ‑tɛ ti nɛ ‑bʋ, 'n 'yɩ 'lɩ ‑na ꞊wienkʋkʋɛ 'lɩ ‑wɛ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","‑Ɛ ‑bɩ ‑Yusu wɛn: «꞊Bɩ ꞊han‑tɩ, ‑wɛ ‑mɔ, 'kɩ ‑bʋ ‑ha ‑na ‑hʋnhlʋn, 'kɩ 'ʋ 'na ‑ta'? 'N yɩ ‑mʋ 'nɩ ‑lee ‑nɩ, 'tɩ‑ hapɛ 'mʋ kɛ ‑nyrɛ da mɔ mu, ‑di nu 'na ‑mɔ‑gaawɩ nɩ ta, ‑ɛ mɔ, ꞊yɩ 'mʋ ‑yi.» ");
INSERT INTO ktj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ, ɛ wɛn: «'Aan ꞊wlɩ 'nɩ 'bie 'lɩ ꞊hlɔn. Ba kuo Nyɩsʋa ꞊wlʋ yɩ, ɛ kɔ, ba kuo 'mʋ ꞊wlʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Bʋnɩɩlɛ ‑hʋʋ 'lɩ 'na 'Baɩ ‑mɔ nɩ. 'N mi nɩ, 'mʋ 'aan bʋnɩɩlɛ ‑mɔ ‑wɛ. 'Bʋ 'yɩ wɛn ‑tɩ a ‑tɛɛ 'pa‑, 'n 'yɩ wɛn 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ lee wɛn 'a mɔ꞊ɔ. ");
INSERT INTO ktj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","'Bʋ mɔ, 'nɩ ‑mu, 'nɩ ‑wɛ 'aan bʋnɩɩlɛ ‑mɔ, ‑ɛ ‑bɩ 'n di 'lɩ 'nɩ di, 'mʋ 'a mʋ gba, ‑ɛ di꞊e nu, ‑tɩtɛ ‑mʋ', 'n nɩ 'ʋ, a 'mʋ 'ʋ nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","'Hru, nyiblo di na, 'tɩ‑ ‑tɩtɛ ‑mʋ', 'n nɩ 'ʋ, ɛ 'mʋ 'ʋ nyre, a yi꞊e nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","‑Ɛ ‑bɩ kɛ‑ Toma pɩ꞊ɩ yɩ, ɛ wɛn: «Kʋkɔnyɔ o, ‑tɩtɛ ‑mʋ', ‑mii 'lɩ, ‑a 'yɩ 'lɩ ‑yi. ‑Bɩ' ‑a ‑wɛ 'lɩ ‑ba nu 'hru a yiyie 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","‑Ɛ ‑bɩ ‑Yusu ꞊tu꞊o ꞊wɔn, ɛ wɛn: «'Na ꞊gbɛtʋ, 'mɔ ‑mɔ 'hru, 'mɔ ‑mɔ ‑tɩ a ‑tɛɛ, kɔ, 'mɔ ‑mɔ 'klɔ yrayrʋ ‑wɛ. Ɛ 'yɩ nyiblo ꞊dʋ ‑kɔ, ‑bʋ mu 'lɩ 'na 'Baɩ ‑mɔ, 'bʋ pa, 'bʋ 'yɩ 'lɩ 'mʋ 'lɩ ‑naa ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","'Bʋ mɔ, 'ba yi 'mʋ, ‑ɛ ‑bɩ a yi 'na 'Baɩ nɩ ‑wɛ. Kʋɛ 'kɩ mɔ bʋ, a yi꞊e nɩ, 'a 'ye꞊e ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","‑Ɛ ‑bɩ Filipʋ wɛn: «Kʋkɔnyɔ o, tɔɔ nɛ ‑a mʋ ‑na 'Baɩ. ꞊Nɩ tɔɔ nɛ ‑a mɔ꞊ɔ, ‑a di kɔ plɔ a bleelɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","‑Ɛ ‑bɩ ‑Yusu ꞊tu꞊o ꞊wɔn de, ɛ wɛn: «Filipʋ o, 'mɔ ‑bʋ, ɛ kɔ 'a mʋ 'hʋɛn‑, ‑ʋ ‑wʋnwlɛn 'hʋɩ, 'mɔ ꞊yɩ ‑hʋan nɩ yi. Nyiblo 'bʋ 'ye 'mʋ, ‑ɛ ‑bɩ ɛ 'ye 'na 'Baɩ nɩ. Dɛ‑ kɔ ‑tɩ, ꞊nɩ pɩ 'kɩ lɛ, ꞊bʋ tɔɔ nɛ 'a mʋ 'na 'Baɩ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","꞊Bɩ ꞊nɩ ‑pʋ꞊ʋ lɩ꞊ɩ ꞊han‑tɩ, ‑ɛ mɔ, 'n kɔ 'na 'Baɩ 'hʋɛn‑, ‑a ‑mʋɛ nɩ, ‑a 'wɩ‑ nyiblo nɩ ‑do yɩ. ‑Tɩ ‑bʋ, 'n yɩ 'aan pɛpɛ ‑lee ‑nɩ, ɛ 'yɩ 'na ꞊gbɛtʋ a 'lulɛ‑hihie 'pa‑, kɛɛ, 'na 'Baɩ a 'lulɛ‑hihie ꞊nɩɔ. Ɛ nɔ‑ nɩ 'ʋ 'mʋ ke', 'ɛ nɛɛ 'lɩ 'mʋ', 'ɛ ni ‑kʋan. ");
INSERT INTO ktj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","‑Tɩ ‑bʋ, 'n hlɛ, ‑ɛ mɔ, 'n kɔ 'na 'Baɩ 'hʋɛn‑, ‑a ‑mʋɛ nɩ, ‑a 'wɩ‑ nyiblo nɩ ‑do yɩ, ba pʋ꞊ʋ ꞊han‑tɩ. 'Ba 'yɩ꞊ɩ ꞊han‑tɩ ‑pʋ, 'na pʋpʋwin a ‑tɩ, ‑ɛ ‑bɩ ba pʋ꞊ʋ ꞊han‑tɩ, 'na nunu‑tɛblɩ a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, nyiblo 'bʋ 'kuo 'mʋ ꞊wlʋ yɩ, nunu‑tɛblɩ 'n ni, ɛ di꞊e 'nɩ nu ‑wɛ. 'Tɩ‑ 'a ‑nɛ nunu‑tɛblɩ ‑mʋ', ɛ di nu, ɛ di 'ʋ 'nɛɛ 'nɩ ‑hi dɩakɩ, ‑ɛ nu꞊o, 'kɩ 'n mi 'lɩ 'na 'Baɩ ‑mɔ, ‑ɛ di꞊e nu, ɛ 'mʋ 'na nyibli ‑mʋ', ‑ʋ ni 'na ‑kʋan 'klɩ ‑nyi, ʋ 'mʋ 'na ‑kʋan nu. ");
INSERT INTO ktj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","‑Tɛblɩ a pɛpɛ ‑mʋ', a di ‑hʋa, 'kɩ 'lɩ 'na 'nyrɛ 'kwli, 'n di꞊e 'nɩ nu, ‑ɛ di꞊e nu, 'mɔ ‑bʋ, ‑ɛ mɔ Nyɩsʋa a 'Yu, 'mʋ nyibli 'na 'Baɩ a ‑tɩ a 'yi'bʋbʋa ‑tɔɔ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","'Bʋ mɔ, 'ba yɩ dɛ nɩ ‑hʋɛ, 'kɩ 'lɩ 'na 'nyrɛ 'kwli, 'n di꞊e 'nɩ nu.» ");
INSERT INTO ktj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","‑Ɛ ‑bɩ kɛ‑ ‑Yusu pɩ 'a ‑nagbopʋ* yɩ de, ɛ wɛn: «'Bʋ mɔ, 'ba nʋɛ 'mʋ, a di 'ʋ 'na tete 'nɩ ꞊tuu ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ti ‑mʋ' ‑kɔ 'yri 'n di 'lɩ 'na 'Baɩ Nyɩsʋa ‑mɔ mu, 'n di nyaa ꞊nɛ lɛ, 'kɩ bʋ ya 'a mʋ nyiblo ‑bɩ yɩ, 'kɩ 'ʋ 'na ‑ta'. Nyiblo a 'mʋ, ɛ nɔ‑ mɔ Nyɩsʋa a ‑Hihiu, ‑ɛ hlɛ ‑tɩ a ‑tɛɛ. Ɛ nɔ‑ di 'ʋ 'a mʋ ke' nɩ, 'a ‑nɛ ti, ɛ 'mʋ 'a mʋ ‑hɛɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","'Klɔ kɩ a nyibli, ‑ʋ 'yɩ Nyɩsʋa ‑yi, ‑Hihiu a 'mʋ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nɩ 'ʋ ꞊nʋ ke', ‑kɔtɩ ʋ nʋ‑ mɔ ‑bɩ, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ yru꞊o, 'tɩ‑ ʋ 'nɩ ‑mʋɔ꞊ɔ lɩ 'a yiyie lɛ. 'A mʋ ‑mɔ ‑bɩ, a yi Nyɩsʋa a ‑Hihiu a 'mʋ nɩ, ‑kɔtɩ Nyɩsʋa a ‑Hihiu a 'mʋ, 'kɩ ɛ nɩ 'lɩ 'a mʋ 'nyɩ, kɔ, ɛ 'mʋ 'ʋ 'a mʋ ke' nɩ ‑nyrɔwɔ ꞊dʋ. ");
INSERT INTO ktj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","'N 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ hie 'ʋ 'a mʋ nɩ ‑do bʋ. Kɛɛ, 'nɩ ‑mu, 'n kɔ ꞊bʋ di 'nɛ‑ 'a mʋ 'nyɩ de. ");
INSERT INTO ktj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ti ꞊dʋ 'yɩ 'lɩ ‑hie, 'klɔ kɩ a nyibli 'mʋ 'na 'yiye 'kee ‑nɩ. Kɛɛ, 'a mʋ ‑mɔ ‑bɩ, a di 'mʋ 'nɩ 'ye, ‑ɛ nu꞊o, 'n nɩ 'klɔ, 'aan 'mumu, a di nɩ 'klɔ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","‑Nyrɔwɔ a 'mʋ 'bʋ nyre 'ʋ, a di yru꞊o lɛ, ‑ɛ mɔ, 'n kɔ 'na 'Baɩ 'hʋɛn‑, ‑a ‑mʋɛ nɩ, ‑a mɔ dɛ nɩ ‑do, 'aan 'mumu, a kɔ 'mʋ 'hʋɛn‑, ‑a ‑mʋɛ nɩ ‑wɛ, ‑a mɔ dɛ nɩ ‑do. ");
INSERT INTO ktj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nyiblo 'bʋ nɩ 'ʋ, 'bʋ 'ble 'na tete kʋa, kɔ, 'bʋ yɩ 'ʋ tete a 'mʋ nɩ ꞊tui ‑nɩ, nyiblo a 'mʋ, nɔ‑ nʋɛ 'mʋ. Nyiblo ‑bʋ, ‑ɛ nʋɛ 'mʋ, 'na 'Baɩ di꞊e 'nɩ ‑nʋɛ ‑nɩ ‑wɛ, 'na 'mumu, 'mʋ꞊ʋ ‑nʋɛ ‑nɩ, 'tɩ‑ 'mʋ꞊ʋ nu, ɛ 'mʋ 'mʋ yru.» ");
INSERT INTO ktj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","‑Ɛ ‑bɩ, Judɩa ‑mʋ', ‑ɛ 'yɩ Judɩa Yisikalio 'pa‑, kɛ‑ ɛ pɩ꞊ɩ yɩ, ɛ wɛn: «Kʋkɔnyɔ o, ‑bɩ' ‑nu, ꞊nɩ pɩ lɛ, ‑ɛ mɔ, ‑di꞊e 'nɩ nu, ‑a 'mʋ ‑mʋ yru, kɛɛ, ꞊yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ‑bʋ nu꞊o, 'klɔ kɩ a nyibli bʋ yru ‑mʋ?» ");
INSERT INTO ktj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","‑Ɛ ‑bɩ ‑Yusu ꞊tu꞊o ꞊wɔn, ɛ wɛn: «Nyiblo 'bʋ nʋɛ 'mʋ, ɛ kɔ, ‑tɩ ‑bʋ, 'n di꞊e ‑lee ‑nɩ, 'bʋ yɩ 'ʋ꞊ʋ nɩ ꞊tui ‑nɩ, 'n di꞊e 'nɩ nu, nyiblo a 'mʋ, ɛ 'mʋ 'mʋ yru. ‑Ɛ ‑bɩ 'na 'Baɩ di꞊e 'nɩ ‑nʋɛ ‑nɩ, 'tɩ‑ 'na 'Baɩ a 'mʋ, ɛ kɔ 'mʋ 'hʋɛn‑, ‑a 'mʋ 'lɩ꞊ɩ ‑mɔ mu, ‑a 'mʋ 'lɩ꞊ɩ ‑mɔ nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nyiblo 'bʋ 'yɩ 'mʋ ‑nʋɛ ‑nɩ, ɛ 'nɩ ꞊tuu꞊o 'ʋ 'na win nɩ. ‑Tɩ ‑bʋ, 'n yɩ 'a mʋ ‑lee ‑nɩ, a yɩ 'wɩn, ɛ 'yɩ 'na ꞊gbɛtʋ a wlɔn bʋ a win 'pa‑, kɛɛ, 'na 'Baɩ Nyɩsʋa, nɔ‑ le 'mʋ, ꞊bʋ lee nɛ 'a mɔ꞊ɔ. ");
INSERT INTO ktj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","‑Tɛ 'n 'tɩɛ nɩ mɔ 'a mʋ 'hʋɩ, 'n yɩ 'a mʋ 'nɩ ‑lee ‑nɩ ‑dodo. ");
INSERT INTO ktj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","'Na 'Baɩ Nyɩsʋa, nɔ‑ di 'a mʋ 'a ‑Hihiu yɩ ya, 'kɩ 'lɩ 'na 'nyrɛ 'kwli. 'A ‑Hihiu a 'mʋ, ɛ nɔ‑ di 'a mʋ ‑tɛblɩ a pɛpɛ ‑tɔɔ ‑nɩ, kɔ, ‑tɩ a pɛpɛ ‑mʋ', 'n lee nɛ 'a mʋ, ɛ 'mʋ 'lɩ 'a mɔ꞊ɔ 'kwli lɛ pʋ. ");
INSERT INTO ktj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","'N di꞊e 'nɩ nu, a 'mʋ plɔ a bleelɛ kɔ. Plɔ a bleelɛdʋ ‑mʋ', 'n ‑kɔ, ɛ nɔ‑ 'n di 'a mʋ ‑nyi. Ɛ 'yɩ plɔ a bleelɛdʋ ‑mʋ', 'klɔ a nyibli yɩ 'waa 'bio lɛ ‑nyi 'pa‑, 'nɩ ‑nyi꞊e lɩ 'a mɔ꞊ɔ nɩ. 'A ‑tɩ o, a 'nɩ 'pie 'lɩ hʋannʋ, ɛ kɔ, 'aan ꞊wlɩ 'nɩ 'bie 'lɩ ꞊hlɔn. ");
INSERT INTO ktj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","A 'wɩn nɩ, ‑tɛ 'n lee nɛ 'a mʋ, ‑ɛ mɔ: 'N mi nɩ, kɛɛ, 'n di 'nɩ di de, 'kɩ 'nɛ‑ 'a mʋ 'nyɩ. 'Bʋ mɔ, 'ba nʋɛ wɛn 'mʋ, a di nu wɛn dɔdʋ, ‑tɛ 'n mi 'lɩ 'na 'Baɩ ‑mɔ a ‑tɩ. 'Na 'Baɩ, nɔ‑ nɩ 'ʋ 'mʋ 'lu yɩ. ");
INSERT INTO ktj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","‑Tɛblɩ a pɛpɛ ‑bʋ, 'n yɩ 'a mɔ꞊ɔ 'nɩ ‑lee ‑nɩ ‑dodo, 'tɩ‑ ɛ 'mʋ 'lu ‑mɔ mu. 'Bʋ mɔ, 'bʋ yɩ 'lu ‑mɔ nɩ mi, ‑ɛ ‑bɩ ɛ di bi 'lɩ 'a mʋ 'kwli lɛ, a 'mʋ 'mʋ ꞊wlʋ yɩ ‑kuo ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ti 'n ‑kɔ, 'kɩ ꞊bʋ hlee 'lɩ 'a mʋ ‑mɔ, ɛ 'yɩ ‑hʋ, ‑ɛ nu꞊o, 'klɔ ‑bʋ, 'a nyiblo gbagbʋ Satan, ɛ yɩ 'lɩ 'nɩ di. ꞊Han‑tɩ, ɛ 'yɩ 'klɩ ‑kɔ, 'kɩ 'ʋ 'mʋ kɩ, ");
INSERT INTO ktj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","kɛɛ, 'klɔ kɩ a nyibli blɛɛ yɩ bʋ yru꞊o, ‑ɛ mɔ, 'n nʋɛ 'na 'Baɩ Nyɩsʋa nɩ. Ɛ nɔ‑ kɔ ‑tɩ, dɛ ‑mʋ', 'na 'Baɩ lee 'mʋ, ꞊bʋ nu, 'mʋ꞊ʋ nu. 'A ‑tɩ o, ba 'du ye', ‑a 'mʋ mu.» ");
INSERT INTO ktj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kɛ‑ ‑Yusu pɩ 'a ‑nagbopʋ* yɩ, ɛ wɛn: «'Mɔ ‑bʋ, 'mɔ ‑mɔ ꞊haantugbɛ, 'a mʋ ‑mʋ', ‑ʋ mɔ 'na nyibli, 'a mɔ tugbɛ a 'mʋ, 'a babʋɩ, 'na 'Baɩ Nyɩsʋa, nɔ‑ mɔ tugbɛ a 'mʋ, 'a 'dʋdɔnyɔ. ");
INSERT INTO ktj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","'A ‑nɛ bʋba 'bʋ nɩ 'ʋ, 'bʋ 'yɛ nɩ tʋ, 'dʋdɔnyɔ a 'mʋ, ɛ yɩ 'ʋ꞊ʋ 'nɩ 'bɛ, kɔ, 'a ‑nɛ bʋba, 'bʋ yɩ nɩ tʋɩ, ɛ kɔ bʋ ‑pa꞊a 'hʋɩ lɛ, ‑ɛ di꞊e nu, ɛ 'mʋ 'ʋ yɩ 'sii ‑nɩ, ɛ 'mʋ tʋ dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","'A mʋ ‑mɔ ‑bɩ, ‑tɩ ‑mʋ', 'n tɔɔ nɛ 'a mʋ, ɛ nu꞊o nɩ, 'a 'sii 'ʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ba 'cibi 'ʋ, ba kʋɛ 'lɩ 'mʋ bʋ, ꞊wɩ yɩ, ‑tɛ 'n ‑nu, 'n kɔ 'a mʋ 'hʋɛn‑, ꞊a ‑mʋɛ. 'Bʋ mɔ, bʋba 'bʋ 'yɩ 'lɩ tugbɛ 'kwli bʋ ‑kʋɛ, ‑ɛ ‑bɩ ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ bʋ tʋ ɛ nɩ ‑do. Kɛ‑ nɩ ‑do, ɛ ꞊ti 'mʋ, 'kɩ 'ʋ 'a mʋ ‑mɔ. 'Bʋ mɔ, 'ba 'yɩ 'lɩ 'mʋ bʋ ‑kʋɛ, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba nu 'na ‑kʋan. ");
INSERT INTO ktj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","'Mɔ ‑mɔ tugbɛ, 'a mɔ 'a babʋɩ. 'Bʋ mɔ, nyiblo 'bʋ kʋɛ 'lɩ 'mʋ 'kwli bʋ, 'tɩ‑ ɛ kɔ 'mʋ 'hʋɛn‑, ꞊ba ‑mʋɛ, nyiblo a 'mʋ, ɛ 'wɩ‑ bʋba ‑mʋ' yɩ, ‑ɛ tʋɩ ‑tɛɛ, ɛ ꞊hɛn 'nyrɛ, nyiblo ‑mʋ', ‑ɛ ni 'na ‑kʋan ‑tɛɛ. 'Bʋ mɔ, 'ba 'yɩ 'lɩ 'mʋ bʋ ‑kʋɛ, 'a mʋ nɩ ‑do, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba nu ꞊dedede. ");
INSERT INTO ktj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","'Bʋ mɔ, nyiblo 'bʋ 'yɩ 'lɩ 'mʋ' bʋ ‑kʋɛ, Nyɩsʋa di pʋ꞊ʋ 'wan, ‑wɛn tibabʋɩ ‑mʋ', ʋ 'bɛ 'ʋ lɛ, 'tɩ‑ ʋ pʋ 'wan lɛ, ‑ɛ di꞊e nu, 'bʋ ‑ma, ʋ 'mʋ꞊ʋ lɛ 'kukue ‑nɩ, ʋ 'mʋ꞊ʋ 'tɔ pʋ. ");
INSERT INTO ktj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","'Bʋ mɔ, 'ba kʋɛ 'lɩ 'mʋ' bʋ, kɔ, 'ba 'ble 'na tɔɔwin kʋa, 'kɩ 'lɩ 'aan ꞊wlɩ kɩ, ‑ɛ ‑bɩ ba ‑hʋa Nyɩsʋa 'a ‑nɛ ꞊dedede, ɛ 'mʋ 'a mɔ꞊ɔ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","'Bʋ mɔ, 'ba 'cibi 'ʋ 'na ‑kʋan a nunuo ‑tɛɛ, ‑ɛ ‑bɩ a di꞊e nyibli 'nɩ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, 'a mʋ ‑mɔ 'na ‑nagbopʋ. Dɛ a 'mʋ, nɔ‑ di꞊e nu, nyibli 'mʋ 'na 'Baɩ Nyɩsʋa ‑tɩ a 'yi'bʋalɛ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","'N nʋɛ nɛ 'a mʋ nɩ, ꞊wɩ yɩ, ‑tɛ 'na 'Baɩ Nyɩsʋa ‑nu, 'ɛ nʋɛ 'mʋ. Ba 'tɩɛ ba kʋɛ 'lɩ 'mʋ' bʋ, ‑ɛ di꞊e nu, a 'mʋ꞊ʋ yi, ‑ɛ mɔ, 'n nʋɛ nɛ 'a mʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","'Bʋ mɔ, 'ba yɩ 'ʋ 'na tete nɩ ꞊tui ‑nɩ, ‑ɛ ‑bɩ a di꞊e 'nɩ yi 'a ‑nɛ ti, ‑ɛ mɔ, 'n nʋɛ nɛ 'a mʋ nɩ, ꞊wɩ yɩ, ‑tɛ 'n ‑nu, 'nɩ ꞊tuu 'ʋ Nyɩsʋa a tete 'ʋ, 'nɩ yi꞊e, ‑ɛ mɔ, ɛ nʋɛ 'mʋ nɩ, 'a ‑nɛ ti. ");
INSERT INTO ktj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","'N yɩ 'a mʋ ‑tɩ a pɛpɛ ‑bʋ 'nɩ ‑lee ‑nɩ, ‑ɛ di꞊e nu, ‑tɛ 'n ni dɔdʋ a nunuo, a 'mʋ lɛ nu ‑wɛ, kɔ, 'aan dɔdʋ a 'mʋ, ɛ 'mʋ ꞊cɛ. ");
INSERT INTO ktj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ba 'ye, ‑tɩ ‑bʋ, 'n yɩ 'a mʋ lee ‑nɩ, ɛ nɔ‑ ‑bʋ: Ba nʋnʋɛ ‑nɩ, ꞊wɩ yɩ, ‑tɛ 'n ‑nu, 'nɩ nʋɛ nɛ 'a mʋ. ");
INSERT INTO ktj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nʋɛlɛ gbagbʋ ‑mʋ', ‑ɛ ‑hi 'ʋ nʋɛlɛ a pɛpɛ 'ʋ, ɛ nɔ‑ mɔ, nyiblo bʋ ‑ha 'a dɩɔnʋ a ‑hʋnhlʋn, 'kɩ 'ʋ 'a 'bio a wʋwa a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","‑Tɩ ‑bʋ, 'n yɩ 'a mʋ lee ‑nɩ, 'ba yɩ꞊ɩ nɩ ni, ‑ɛ ‑bɩ a mɔ 'na nɩnatumupʋ ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","'Nɩ ‑daa꞊a 'kɩ 'a mʋ 'na ‑kʋannunyibli nɩ de, ‑kɔtɩ dɛ ‑mʋ', ‑kʋannunyɔ a 'masɛ ni, ‑kʋannunyɔ a 'mʋ, ɛ 'yɩ꞊ɩ ‑yi. 'N dɛɛ nɛ 'a mʋ 'na nɩnatumupʋ. A yi dɛ a 'mʋ nɩ, ‑kɔtɩ ‑tɩ a pɛpɛ ‑mʋ', 'na 'Baɩ Nyɩsʋa tɔɔ 'mʋ, 'n tɔɔ nɛ 'a mɔ꞊ɔ nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ɛ 'yɩ 'a mʋ 'pa‑, a 'yɩ 'lɩ 'mʋ 'lɩ ‑ha, 'kɩ ꞊bʋ mɔ 'aan Kʋkɔnyɔ. Kɛɛ, 'mɔ ‑ha 'lɩ 'a mʋ, 'kɩ ba kʋɛ 'mʋ ꞊wien, 'nɩ lee nɛ 'a mʋ, 'kɩ ba mu 'na ‑kʋan nu ‑wɛ. ‑Kʋan ‑mʋ', a di nu, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ mɔ dadʋ a ‑kʋan. 'A ‑nɛ dɛ, a di 'na 'Baɩ Nyɩsʋa ‑hʋa, 'kɩ 'lɩ 'na 'nyrɛ 'kwli, ɛ di 'a mɔ꞊ɔ 'nɩ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","'A ‑tɩ o, dɛ ‑mʋ', 'n ‑hʋɛ 'a mʋ, ɛ nɔ‑ mɔ: Ba nʋnʋɛ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Kɛ‑ ‑Yusu pɩ de, ɛ wɛn: «'Klɔ a nyibli 'bʋ yraa nɛ 'a mʋ, ba kɔ 'a yiyie, ‑ɛ mɔ, 'mɔ ‑mɔ yɩ‑hɛnyiblo, ʋ yraa ‑nɩ, 'tɩ‑ 'ʋ mu 'a mʋ yraa mɔ. ");
INSERT INTO ktj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","'Bʋ mɔ, 'ba mɔ wɛn 'klɔ a nyibli, 'klɔ a nyibli di nʋɛ wɛn 'aan dɛ, ‑ɛ nu꞊o, 'kɩ a di wɛn 'lɩ ꞊nʋ 'nyɩ nɩ. Kɛɛ, ɛ 'yɩ 'mʋ lɛ ‑nɩ. 'Na ꞊gbɛtʋ, 'mɔ ‑ha 'lɩ 'a mʋ 'klɔ a nyibli 'nyɩ, 'nɩ pʋ 'a mʋ 'kɩbɩa kɩ. A 'yɩ kɩ 'lɩ ꞊nʋ 'nyɩ ‑nɩ. Ɛ nɔ‑ kɔ ‑tɩ, 'ʋ yraa nɛ 'a mʋ. ");
INSERT INTO ktj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‑Tɩ ‑bʋ, 'n lee la 'a mʋ, ɛ 'nɩ 'hruo 'lɩ 'a mʋ ‑mɔ. Ɛ nɔ‑ mɔ: ‑Kʋannunyɔ ꞊dʋ 'yɩ 'ʋ 'a 'masɛ 'lu yɩ ‑nɩ. Dɛ ɛ ꞊hɛn 'nyrɛ, ɛ nɔ‑ mɔ, nyibli ‑mʋ', ‑tɛ ʋ naa 'ʋ, 'ʋ ꞊tu 'mʋ ꞊hɩʋɛn, 'kɩ ʋ di 'ʋ ‑naa ‑nɩ, ʋ 'mʋ 'a mʋ ꞊hɩʋɛn ꞊tu ‑wɛ. Nyibli ‑mʋ', ‑ʋ ꞊tui 'ʋ 'na tɔɔwin 'ʋ, ʋ kɔ bʋ ꞊tuu 'ʋ 'aan tɔɔwin 'ʋ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","'Bʋ yɩ 'a mʋ ꞊hɩʋɛn nɩ ꞊tui, ba yi꞊e, ‑ɛ mɔ, ‑tɛ a mɔ 'na ‑nagbopʋ a ‑tɩ ꞊nɩɔ. 'Tɩ‑, 'na 'Baɩ ‑bʋ, ‑ɛ tɛ 'nɛ‑ 'mʋ 'klɔ kɩ, ʋ 'yɩ꞊ɩ ‑yi. ");
INSERT INTO ktj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","'Bʋ mɔ, 'nɩ 'yɩ wɛn 'nɛ‑ ‑di, 'nɩ 'yɩ wɛn ꞊nʋ Nyɩsʋa a ‑tɩ ‑lee ‑nɩ, Nyɩsʋa 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ yɛɛ wɛn ꞊nʋ ‑tɩ, 'kɩ 'ʋ 'waa dɛ 'kuku ‑mʋ', ʋ ‑nu a ‑ta'. Kɛɛ, dɛ ‑bʋ, 'n ‑di, 'n lee ꞊nʋ Nyɩsʋa a ‑tɩ, 'bʋ 'tɩɛ yɩ dɛ 'kuku nɩ ni, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ kɔ 'hru, 'kɩ bʋ ꞊ta Nyɩsʋa ‑jɩ'. ");
INSERT INTO ktj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nyiblo ‑bʋ, ‑ɛ yraa 'mʋ, ɛ yraa 'na 'Baɩ nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","'Bʋ mɔ, 'nɩ 'yɩ ‑hʋan 'lɩ ꞊nʋ 'nyɩ ꞊wlɩlɛkɛɛdɛ ꞊dʋ nɩ ‑nii ‑nɩ, nyiblo ꞊dʋ 'yɩ ‑hʋan nɩ ni, ‑ɛ ‑bɩ Nyɩsʋa 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ yɛɛ ꞊nʋ ‑tɩ, 'kɩ 'ʋ 'waa dɛ 'kuku ‑mʋ', ʋ ‑nu a ‑ta'. Kɛɛ, ꞊wlɩlɛkɛɛ‑tɛblɩ ‑mʋ', 'n nuu 'lɩ ꞊nʋ 'nyɩ, ʋ 'ye꞊e nɩ, kɛɛ, kɛ‑ ɛ 'nɩ 'mʋ, 'n kɔ 'na 'Baɩ 'hʋɛn‑, 'ʋ yraa nɛ ‑a mʋ. ");
INSERT INTO ktj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","‑Tɛblɩ a 'mʋ, ‑ɛ mi 'lu ‑mɔ, ɛ mi 'lu ‑mɔ, ‑ɛ di꞊e nu, ‑tɩ ‑mʋ', 'waa 'baɩnʋ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, ɛ 'mʋ ‑nue ‑nɩ. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: ꞊Han‑tɩ ꞊hɔn, 'n 'yɩ ꞊dedede ‑nu, ʋ yraa 'mʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Kɛ‑ ‑Yusu pɩ ꞊nʋ yɩ de, ɛ wɛn: «Nyiblo ‑mʋ', ‑ɛ di 'a mʋ ‑hɛɛ ‑nɩ, ɛ di 'nɩ di. 'Kɩ ɛ di 'lɩ 'na 'Baɩ ‑mɔ ‑hɔn. 'Bʋ mɔ, 'nɩ mu 'lɩ 'na 'Baɩ ‑mɔ, 'n kɔ ꞊bʋ ya 'a mʋ nyiblo a 'mʋ yɩ. Nyiblo a 'mʋ, ɛ nɔ‑ mɔ Nyɩsʋa a ‑Hihiu*. Ɛ nɔ‑ di nyibli ‑tɩ a ‑tɛɛ ‑tɔɔ ‑nɩ. 'Bʋ mɔ, 'bʋ ‑di, ɛ di 'a mʋ 'nɩ ‑lee ‑nɩ, nyiblo a 'dɩ ‑bɩ 'n pa 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","'A mʋ ‑mɔ ‑bɩ, a di꞊e 'nɩ hla ‑wɛ, nyiblo a 'dɩ ‑bɩ 'n pa 'mʋ, ‑ɛ nu꞊o, kʋɛ la 'lɩ 'na ‑kʋan a ‑wlu꞊tuulɛ 'yie bʋ, a kɔ 'mʋ 'hʋɛn‑, ‑a mʋ nɩnɛ 'hʋɩ. ");
INSERT INTO ktj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","'N yɩ 'a mʋ ‑tɩ a 'mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ di꞊e nu, ꞊hɩʋɛn a 'mʋ, 'a 'yiyeti a 'mʋ, 'bʋ nyre 'ʋ, a 'nɩ ꞊ha 'na ꞊wlʋ a yɩkuolɛ 'kee ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ʋ di bla 'a mʋ Nyɩsʋa a 'kayo blɛ. Ti di 'ʋ 'nɩ nyre ‑wɛ, ‑ɛ kɔ 'yri nyibli ‑mʋ', ‑ʋ di 'a mʋ lɛ 'lɩla ‑nɩ, ʋ di꞊e hla, ‑ɛ mɔ, ɛ mɔ Nyɩsʋa a ‑kʋan ꞊nɩɔ, 'ʋ ni꞊e. ");
INSERT INTO ktj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Kɛ‑ ʋ di 'a nunuo nu, ‑tɛ ʋ 'yɩ 'na 'Baɩ ‑yi, ɛ kɔ, ‑tɛ ʋ 'yɩ 'mʋ ‑yi a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kɛɛ, 'n yɩ 'a mʋ ‑tɩ a 'mʋ nɩ ‑lee ‑nɩ, ‑ɛ di꞊e nu, ti ‑mʋ' ‑kɔ 'yri ʋ di ‑tɛblɩ a 'mʋ nu, ɛ 'mʋ 'lɩ 'a mʋ 'kwli lɛ bi, ‑ɛ mɔ, 'n lee nɛ 'a mʋ nɩ.» «Kʋɛ la 'lɩ bʋ, 'n 'yɩ la 'a mʋ ‑tɩ a 'mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ nu꞊o, 'kɩ 'n nɩ la 'lɩ 'a mʋ 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","‑Tɛ ti nɛ ‑bʋ, 'n mi nɩ. Nyiblo ‑mʋ', ‑ɛ lee 'nɛ‑ 'mʋ ‑tʋtʋ kɩ, ɛ nɔ‑ kɔ 'hʋɩ 'n mi 'lɩ. Kɛɛ, 'kɩ 'lɩ 'a mʋ 'nyɩ, nyiblo ꞊dʋ 'nɩ 'bɛti꞊e 'mʋ, ‑ɛ mɔ: ‑Bɩ' ‑mi yɩ 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","'Aan ꞊wlɩ 'mʋɛ bʋ, ‑tɛ 'n lee nɛ 'a mʋ, ‑ɛ mɔ, 'n di 'nɩ mu a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kɛɛ, ba pʋ꞊ʋ ꞊han‑tɩ, ɛ di nɔɔ 'ʋ lɛ, 'kɩ 'ʋ 'a mʋ ‑mɔ, 'kɩ ꞊bʋ mu, ‑ɛ nu꞊o, 'bʋ mɔ, 'nɩ 'yɩ ‑mu, ‑ɛ ‑bɩ nyiblo ‑mʋ', ‑ɛ di wɛn 'a mʋ ‑hɛɛ ‑nɩ, ‑ɛ mɔ, Nyɩsʋa a ‑Hihiu, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ di 'nɛ‑ 'a mʋ ‑mɔ. Kɛɛ, 'bʋ mɔ, 'nɩ ‑mu, 'n di 'a mɔ꞊ɔ yɩ 'nɩ ya. ");
INSERT INTO ktj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","'Bʋ mɔ, 'bʋ ‑di, ɛ di 'klɔ a nyibli 'nɩ ‑tɔɔ ‑nɩ, ‑ɛ mɔ, ʋ ni dɛ 'kuku, 'tɩ‑ ɛ 'mʋ ꞊nʋ 'hru ‑tɔɔ ‑nɩ, ‑ɛ 'sii 'ʋ yɩ, ɛ kɔ ‑bati ‑mʋ', Nyɩsʋa di pʋ 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Dɛ 'kuku ‑mʋ', nyibli ni, ɛ di ꞊nʋ ‑tɔɔ ‑nɩ, ɛ nɔ‑ mɔ, bʋ 'yɩ 'mʋ ꞊wlʋ yɩ ‑kuo ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ʋ di꞊e 'nɩ 'ye, ‑ɛ mɔ, 'na 'hru 'sii 'ʋ yɩ, ‑kɔtɩ 'kɩ 'n mi 'lɩ 'na 'Baɩ ‑mɔ, 'kɩ a 'yɛ nɩ di 'kɩ 'mʋ nɩ 'ye de. ");
INSERT INTO ktj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","'Ya 'ʋ 'lu de, ‑bati ‑mʋ', Nyɩsʋa di ꞊nʋ lɛ ‑pʋʋ ‑nɩ, ɛ nɔ‑ mɔ ‑bati ‑mʋ', ‑ɛ klɔ 'klɔ ‑bʋ, 'a nyiblo gbagbʋ Satan. ");
INSERT INTO ktj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","'N kɔ ‑tɛblɩ ‑hʋɔhʋɩ, ꞊bʋ lee nɛ 'a mʋ de, kɛɛ, ‑tɛ ti nɛ ‑bʋ, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ba kɔ 'a lɛyuyruo, ‑kɔtɩ ɛ ‑hi 'aan 'lulɛ‑hihie wlɔn. ");
INSERT INTO ktj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nyɩsʋa a ‑Hihiu, ‑ɛ yɩ nyibli ‑tɩ a ‑tɛɛ ‑lee ‑nɩ, 'bʋ mɔ, 'bʋ ‑di, ɛ di꞊e 'nɩ nu, a 'mʋ ‑tɩ a ‑tɛɛ a 'mʋ lɛ yru pɛpɛ. ‑Tɩ ‑mʋ', ɛ di 'a mʋ ‑lee ‑nɩ, ɛ 'yɩ 'a ꞊gbɛtʋ a wlɔn bʋ a win 'pa‑, kɛɛ, ‑tɩ ‑mʋ', 'a 'mumu, ɛ di 'wɩn, ɛ nɔ‑ ɛ di 'a mʋ ‑lee ‑nɩ, kɔ, ‑tɛblɩ ‑mʋ', ‑ɛ di ‑hʋan 'lu ‑mɔ mu, 'a pɛpɛ a 'mʋ, ɛ nɔ‑ ɛ di 'a mʋ ‑tɔɔ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ɛ di tɔɔ nyibli 'na ‑tɩ a 'yi'bʋalɛ, ‑ɛ nu꞊o, ‑tɩ ‑mʋ', 'n di Nyɩsʋa a ‑Hihiu ‑lee ‑nɩ, ɛ nɔ‑ ɛ di 'wɩn, 'tɩ‑ ɛ di 'a mʋ ‑lee ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","‑Tɛblɩ a pɛpɛ, 'na 'Baɩ ‑kɔ, 'mɔ kɔ꞊ɔ ‑wɛ. Ɛ nɔ‑ kɔ ‑tɩ, 'nɩ hla꞊a, ‑ɛ mɔ, ‑tɩ ‑mʋ', 'n di Nyɩsʋa a ‑Hihiu ‑lee ‑nɩ, ɛ nɔ‑ ɛ di 'wɩn, 'tɩ‑ ɛ di 'a mʋ ‑lee ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Ti ꞊dʋ 'yɩ 'lɩ ‑hie, a 'mʋ 'na 'yiye 'kee ‑nɩ, 'bʋ ‑hi, ɛ di gba ti gbi, 'tɩ‑ a 'mʋ 'mʋ 'ye de.» ");
INSERT INTO ktj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","'Kɩ 'lɩ ʋ nɩ ‑do a 'mʋ 'nyɩ, kɛ‑ 'a ‑nagbopʋ* ‑bɩ pɩ, 'ʋ yɩ lɛ 'bɛti ‑nɩ: «Dɛ a 'dɩ ‑bɩ, dɛ a 'mʋ, ɛ ꞊hɛn 'nyrɛ 'lɩ, ‑tɛ ɛ pɩ lɛ, ‑ɛ mɔ: Ti ꞊dʋ 'yɩ 'lɩ ‑hie, a 'mʋ 'na 'yiye 'kee ‑nɩ, 'bʋ ‑hi, ɛ di gba ti gbi, 'tɩ‑ a 'mʋ 'mʋ 'ye de? Dɛ‑ kɔ ‑tɩ, 'ɛ pɩ lɛ de, ‑ɛ mɔ: A 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ ba 'ye 'mʋ, ‑ɛ nu꞊o, 'kɩ 'n mi 'lɩ 'na 'Baɩ ‑mɔ? ");
INSERT INTO ktj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ti gbi a 'mʋ, ‑kɔtɩ ɛ ‑hla, dɛ‑ ɛ ꞊hɛn 'nyrɛ 'lɩ? ‑Tɩ a 'mʋ, ɛ ‑hla, ‑a 'nɩ ‑yru꞊o lɩ꞊ɩ lɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","‑Tɛ ‑Yusu yru꞊o, ‑ɛ mɔ, ʋ ‑hʋɛ bʋ 'bɛti꞊e, ‑ɛ ‑bɩ, ɛ ‑tʋa 'waa leelɛ, ɛ wɛn: «'N lee nɛ 'a mʋ nɩ, ‑ɛ mɔ: 'Kɩ 'lɩ ti gbi 'kwli, a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ ba 'ye 'mʋ, 'tɩ‑, 'tɩ‑ 'kɩ 'lɩ ti ‑bɩ 'kwli, a 'mʋ 'mʋ 'ye de. ꞊Bɩ dɛ a 'mʋ, ɛ nɔ‑ kɔ kɩ a yɩ 'ʋ 'aan dɩɔnʋ lɛ 'bɛti ‑nɩ? ");
INSERT INTO ktj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, a di 'nɩ we, ɛ kɔ, a 'mʋ nyaɩ lɛ nu, kɛɛ, 'klɔ a nyibli di nu dɔdʋ, 'a mʋ mɔ ‑bɩ, 'aan ꞊wlɩ 'mʋ bʋ 'mʋɛ. Kɛɛ, 'bʋ ‑hie ti gbi, ‑ɛ ‑bɩ a di ‑tʋa dɔdʋ a nunuo de. ");
INSERT INTO ktj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","꞊Bʋ pʋ꞊ʋ ‑ŋlanʋgba a dɛ yɩ: ‑Ŋlanʋgba, 'bʋ yɩ ꞊gbla mɔ nɩ mi, ‑ɛ ‑bɩ 'a ꞊wlʋ yɩ 'mʋɛ bʋ, 'kɩ 'ʋ ꞊hɩʋɛn ‑mʋ', ɛ di 'ye a ‑ta'. Kɛɛ, 'bʋ ꞊gbla, ‑ɛ ‑bɩ ꞊hɩʋɛn ‑mʋ', ɛ yɩ wɛn 'ye, 'a ‑tɩ ‑hru꞊o ‑mɔ. ‑Ɛ ‑bɩ ɛ ni dɔdʋ, ‑tɛ ɛ ‑nu, 'ɛ pʋ 'nɛ‑ 'yu yrayrʋ 'klɔ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kɛ‑ ɛ ꞊ti 'mʋ ‑wɛ, 'kɩ 'ʋ 'a mʋ ‑mɔ. ‑Tɛ ti nɛ ‑bʋ, 'aan ꞊wlɩ 'mʋɛ bʋ, ꞊hɩʋɛn a 'yiye a ‑tɩ. Kɛɛ, 'n kɔ 'a mʋ 'hʋɛn‑, ‑a di 'nɩ 'yiye ‑nɩ de. 'Bʋ mɔ, ꞊ba 'yiye ‑nɩ, a di nu dɔdʋ, 'tɩ‑ nyiblo ꞊dʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ nu꞊o, ba 'kee dɔdʋ a 'mʋ, 'a nunuo. ");
INSERT INTO ktj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ti a 'mʋ 'bʋ nyre 'ʋ, ‑ɛ ‑bɩ a di 'kee 'na lɛ'bɛtilɛ de, ‑ɛ nu꞊o, a di ‑tɛblɩ a pɛpɛ a 'mʋ lɛ 'nɩ yru. 'N yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑tɛblɩ a pɛpɛ ‑mʋ', a di 'na 'Baɩ ‑hʋa, 'kɩ 'lɩ 'na 'nyrɛ 'kwli, ɛ di 'a mɔ꞊ɔ 'nɩ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kʋɛ la 'lɩ bʋ, ‑bʋ yɛ ti ‑bʋ kɩ, a 'yɛɛ 'na 'Baɩ ꞊dedede nɩ ‑hʋɛ, 'kɩ 'lɩ 'na 'nyrɛ 'kwli. 'Bʋ mɔ, 'ba yɩ dɛ nɩ ‑hʋɛ, ‑ɛ ‑bɩ ba ‑hʋa꞊a 'na 'Baɩ. Ɛ di 'a mɔ꞊ɔ 'nɩ ‑nyi, ‑ɛ di꞊e nu, 'aan dɔdʋ 'mʋ ꞊cɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«‑Tɩ a pɛpɛ ‑bʋ, 'n lee nɛ 'a mʋ, 'kɩ 'n naa 'lɩ 'ledʋɩ 'kwli, 'nɩ hla꞊a. Ti di 'ʋ 'nɩ nyre, ‑ɛ kɔ 'yri 'n 'yɛ nɩ di 'ledʋɩ nɩ nu, 'n 'yɛ nɩ di 'lɩ 'a mʋ ‑mɔ nɩ ‑hlee ‑nɩ, kɛɛ, ‑tɛblɩ ‑mʋ', ‑ɛ kʋɛ 'ʋ 'na 'Baɩ kɩ bʋ, 'n di yrue nɛ 'a mɔ꞊ɔ' lɛ ‑tɛɛ. ");
INSERT INTO ktj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ti a 'mʋ, 'bʋ nyre 'ʋ, a di ‑hʋa 'na 'Baɩ ‑tɛblɩ, 'kɩ 'lɩ 'na 'nyrɛ 'kwli. 'Na 'mumu, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ ‑hʋa꞊a ꞊dedede, 'kɩ 'ʋ 'aan ‑ta', kɛɛ, 'aan ꞊gbɛtʋ 'a mʋ di꞊e ‑tɛblɩ lɛ ‑hʋa, ");
INSERT INTO ktj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","‑kɔtɩ 'na 'Baɩ a 'mʋ, ɛ nʋɛ nɛ 'a mʋ nɩ, ‑ɛ nu꞊o, a nʋɛ 'mʋ nɩ ‑wɛ, 'tɩ‑ 'a kuo 'mʋ ꞊wlʋ yɩ, ‑ɛ mɔ, 'kɩ 'n ‑hɔn 'lɩ Nyɩsʋa ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","'Kɩ 'n ‑hɔn 'lɩ 'na 'Baɩ ‑mɔ, 'nɩ di 'nɛ‑ 'klɔ kɩ. ‑Tɛ ti nɛ ‑bʋ, 'n mi 'nɛ‑ 'klɔ kɩ ‑hɔn mɔ, 'mʋ 'lɩ 'na 'Baɩ ‑mɔ mu.» ");
INSERT INTO ktj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","‑Ɛ ‑bɩ 'a ‑nagbopʋ* ꞊tu꞊o ꞊wɔn, ʋ wɛn: «'Ye kɛ, ‑tɛ ti nɛ ‑bʋ, ‑tɛ ‑yɛ' nɩ hlee 'lɩ 'ledʋɩ 'kwli, 'a ‑tɩ, ‑tɩ ‑mʋ', ‑hlɛ, ‑a yrui꞊e' lɛ ‑tɛɛ. ");
INSERT INTO ktj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","‑A yi 'kɩ꞊ɩ nɩ, ‑ɛ mɔ, 'ye ꞊bɩɩ nyiblo 'yɩ ‑mʋ dɛ 'bɛti ‑nɩ, dɛ ‑mʋ', ɛ ‑hʋɛ, ɛ nɩ ke', ꞊nɩ ‑wɛ 'a yiyie ‑mɔ. Ɛ nɔ‑ kɔ ‑tɩ, ꞊a yi꞊e, ‑ɛ mɔ 'kɩ ‑hɔn 'lɩ Nyɩsʋa ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn: «꞊Bɩ a yi 'kɩ꞊ɩ nɩ, ‑ɛ mɔ, 'kɩ 'n ‑hɔn 'lɩ Nyɩsʋa ‑mɔ? ");
INSERT INTO ktj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","'A ‑tɩ 'kɩ, ti di 'ʋ 'nɩ nyre, 'tɩ‑ ɛ mɔ, ɛ ‑wɛ 'ʋ nyinyre ‑mɔ, ‑ɛ kɔ 'yri 'aan pɛpɛ a di ‑gbɛ, 'a ‑nɛ nyiblo 'bʋ nɩ 'ʋ, ɛ 'mʋ 'lɩ 'a ‑nɛ 'kayu bʋ mu, a 'mʋ 'ʋ 'mɔ nɩ ‑do bʋ ‑hie. Kɛɛ, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ꞊bʋ nu ‑do, ‑ɛ nu꞊o, 'kɩ 'na 'Baɩ nɩ mɔ 'mʋ 'hʋɩ. ");
INSERT INTO ktj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","'N lee nɛ 'a mʋ ‑tɩ a pɛpɛ a 'mʋ nɩ, ‑ɛ di꞊e nu, 'a mʋ ‑mʋ', ‑ʋ kɔ 'mʋ 'hʋɛn‑, ‑ʋ ‑mʋɛ, a 'mʋ kɩbʋwɛɛnlɛ kɔ. 'Kɩ 'nɛ‑ 'klɔ ‑bʋ kɩ, a di 'ye ꞊hɩʋɛn. Kɛɛ, 'aan ꞊wlɩ 'nɩ 'bie 'lɩ ꞊hlɔn, ‑ɛ nu꞊o, 'n ‑wɛ 'klɔ ‑bʋ 'a 'klɩ bʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","'Tɩ‑ ‑Yusu 'mʋ 'kɩ ‑yrɛ mɔ mu, ‑ɛ ‑bɩ ɛ 'du 'lu ye', 'ɛ ta 'lɩ yakɔ 'kwli lɛ, ɛ wɛn: «'Na 'Baɩ o, ti nyre 'ʋ nɩ, 'kɩ 'mɔ ‑bʋ, ‑ɛ mɔ ‑na 'Yu, ‑bʋ nu꞊o, nyibli bʋ 'ye 'na ‑tɩ a 'yi'bʋalɛ, ‑ɛ di꞊e nu, 'mʋ ꞊nʋ ‑na ‑tɩ a 'yi'bʋalɛ ‑tɔɔ ‑nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","‑Nyi 'mʋ 'klɩ, 'kɩ 'ʋ ‑tonyibli a pɛpɛ kɩ, ‑ɛ di꞊e nu, nyibli a pɛpɛ ‑bʋ, ‑nyi 'mʋ, 'mʋ ꞊nʋ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","'Klɔ yrayrʋ a 'mʋ, ɛ nɔ‑ mɔ bʋ yi ‑mʋ, ‑mɔ ‑mʋ', ‑ɛ mɔ ‑tɛɛ a Nyɩsʋa nɩ ‑do, ɛ kɔ, bʋ yi 'mʋ ‑wɛ, 'mɔ ‑bʋ, ‑ɛ mɔ ‑Yusu 'Klɩsʋ, ‑lee 'nɛ‑ 'klɔ kɩ. ");
INSERT INTO ktj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","‑Tɛ 'n nɩ 'nɛ‑ 'klɔ kɩ, 'n tɔɔ nyibli ‑na ‑tɩ a 'yi'bʋalɛ nɩ. ‑Kʋan ‑mʋ', ‑nyi la 'mʋ, ꞊bʋ nu, 'n ‑yra꞊a 'lu nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","‑Ɛ ‑bɩ 'kɩ, 'na 'Baɩ o, wɛn, 'kɩ ꞊bʋ di 'lɩ ‑mʋ 'hʋɩ de, 'mʋ ‑tɩ a 'yi'bʋalɛ kɔ. Ti ‑mʋ', ‑ɛ kɔ 'yri 'n nɩ la 'ʋ ‑mʋ 'hʋɩ, ‑tɩ a 'yi'bʋalɛ nɩ ‑do ‑mʋ', 'n kɔ la, 'tɩ‑ 'klɔ 'mʋ la nue mɔ mu, ‑nyi 'mʋ ‑tɩ a 'yi'bʋalɛ a 'mʋ de. ");
INSERT INTO ktj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nyibli ‑mʋ', ‑ʋ nɩ la 'lɩ 'klɔ 'ka 'kwli, ‑ha 'lɩ ꞊nʋ nɩ, ꞊nɩ ‑nyi 'mʋ ꞊nʋ, ꞊nɩ nu꞊o, nyibli a 'mʋ, 'ʋ yi ‑mʋ. ‑Mɔ kɔ nyibli a 'mʋ, ꞊nɩ ‑ha 'lɩ ꞊nʋ, ꞊nɩ ‑nyi 'mʋ ꞊nʋ, 'ʋ ꞊tui 'ʋ ‑na win. ");
INSERT INTO ktj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ʋ yi 'kɩ꞊ɩ nɩ, ‑ɛ mɔ, 'a ‑nɛ dɛ, ‑nyi 'mʋ, 'kɩ ɛ ‑hɔn 'lɩ ‑mʋ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Win ‑bʋ, ꞊tu 'mʋ wlɔn, ɛ nɔ‑ 'n tɔɔ ꞊nʋ, 'ʋ 'ble꞊e kʋa ‑tɛɛ. Ʋ yru꞊o nɩ, ‑ɛ mɔ, 'kɩ 'n ‑hɔn 'lɩ ‑mʋ ‑mɔ, kɔ, 'ʋ yi꞊e ‑tɛɛ, ‑ɛ mɔ, ‑mɔ lee 'nɛ‑ 'mʋ 'klɔ kɩ. ");
INSERT INTO ktj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nyibli a 'mʋ, ʋ nʋ‑ kɔ ‑tɩ, 'nɩ dɛ ‑mʋ. 'Nɩ ‑da꞊a lɩ ‑mʋ, 'kɩ 'ʋ 'klɔ kɩ a nyibli ‑mʋ', ‑ʋ 'yɩ ‑mʋ ‑yi a ‑ta'. Kɛɛ, nyibli ‑bʋ, ‑nyi 'mʋ, ʋ nʋ‑ kɔ ‑tɩ, 'nɩ dɛ ‑mʋ, ‑ɛ nu꞊o, ‑mɔ kɔ ꞊nʋ. ");
INSERT INTO ktj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","'A ‑nɛ dɛ, kɔ 'a ‑nɛ nyiblo 'n ‑kɔ, ‑mɔ kɔ ꞊nʋ, mɔ, 'a ‑nɛ dɛ, kɔ 'a ‑nɛ nyiblo, ‑kɔ, 'mɔ kɔ ꞊nʋ ‑wɛ. Ʋ nʋ‑ ni꞊e, nyibli 'ʋ yɩ 'na ‑tɩ a 'yi'bʋalɛ 'ye. ");
INSERT INTO ktj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ti ꞊dʋ 'yɩ 'lɩ ‑hie, 'mʋ 'nɛ‑ 'klɔ ‑bʋ kɩ ‑hɔn, 'mʋ 'lɩ ‑mʋ ‑mɔ di. Kɛɛ, ʋ nʋ‑ ‑mɔ ‑bɩ, 'kɩ ʋ 'tɩɛ di 'nɛ‑ 'klɔ ‑bʋ kɩ nɩ. 'Na 'Baɩ Nyɩsʋa, nu 'klɩ ‑mʋ', ‑nyi 'mʋ, ‑bʋ ꞊tu ꞊nʋ 'yie, ‑ɛ di꞊e nu, ʋ 'mʋ ‑mʋɛ, ꞊wɩ yɩ, ‑tɛ 'n kɔ ‑mʋ 'hʋɛn‑, ‑a ‑nu, ꞊a ‑mʋɛ. ");
INSERT INTO ktj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ti a pɛpɛ ‑bʋ, 'n ‑hi 'nɛ‑ ꞊nʋ 'nyɩ, 'n ꞊tui la ꞊nʋ 'yie, 'kɩ 'lɩ ‑na 'klɩ ‑mʋ', ‑nyi 'mʋ 'kwli. 'N ꞊tu ꞊nʋ 'yie nɩ ‑tɛɛ, 'waa 'yɛ nɩ ‑do ꞊dʋ 'yɩ 'wan, 'bʋ 'yɩ nyiblo nɩ ‑do ‑bʋ, ‑kɔtɩ ʋ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ, ɛ di 'nɩ 'wan. ‑Ɛ ‑bɩ ‑tɩ a 'mʋ, ʋ 'crɩ la, ɛ nue nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Kɛɛ, ‑tɛ ti nɛ ‑bʋ, 'kɩ 'n yɩ 'lɩ ‑mʋ ‑mɔ di. ‑Tɩ a pɛpɛ ‑bʋ, 'n yɩ ꞊nʋ 'nɩ ‑lee ‑nɩ, ‑tɛ 'n 'tɩɛ nɩ 'nɛ‑ ꞊nʋ 'nyɩ, 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, ‑ɛ di꞊e nu, ‑tɛ 'n ni dɔdʋ a nunuo, ʋ 'mʋ dɔdʋ a nunuo lɛ nu ‑wɛ, 'tɩ‑ dɔdʋ a 'mʋ, ɛ 'mʋ ꞊cɛ. ");
INSERT INTO ktj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","'N tɔɔ ꞊nʋ ‑na win nɩ, kɛɛ, 'klɔ a nyibli yraa ꞊nʋ nɩ, ‑tɛ 'na nyibli 'yɩ 'klɔ a nyibli 'pa‑ a ‑tɩ, ꞊wɩ yɩ, ‑tɛ 'n ‑nu, 'nɩ 'yɩ 'klɔ a nyiblo 'pa‑. ");
INSERT INTO ktj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","'Nɩ ‑nyaa꞊a ‑mʋ lɛ, 'kɩ ‑bʋ ‑ha 'nɛ‑ ꞊nʋ 'klɔ ‑bʋ kɩ, kɛɛ, 'n nyɛɛ ‑mʋ lɛ, 'kɩ ‑bʋ ꞊tu ꞊nʋ 'yie, ‑ɛ di꞊e nu, 'kuo ‑hʋɩn* a nyiblo gbagbʋ 'nɩ ꞊ha ꞊nʋ lɛ ‑hrɛn. ");
INSERT INTO ktj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ʋ 'yɩ 'klɔ a nyibli 'pa‑, ꞊wɩ yɩ, ‑tɛ 'na 'mumu, 'n ‑nu, 'kɩ 'n 'yɩ 'klɔ a nyiblo 'pa‑. ");
INSERT INTO ktj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Tɔɔ ꞊nʋ ‑tɩ a ‑tɛɛ, ‑ɛ di꞊e nu, ʋ 'mʋ ‑na nyibli mɔ pɛpɛ. ‑Tɩ a ‑tɛɛ a 'mʋ, ɛ nɔ‑ mɔ ‑na win. ");
INSERT INTO ktj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","‑Tɛ ‑nu, ꞊nɩ lee 'nɛ‑ 'mʋ 'klɔ ‑bʋ kɩ, kɛ‑ nɩ ‑do, 'n ‑nu, 'nɩ lee ꞊nʋ ‑wɛ, 'kɩ bʋ bi 'klɔ ‑bʋ kɩ, bʋ pʋ ‑na ꞊haantitie nyibli. ");
INSERT INTO ktj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","'N ‑hɛ 'na dɩɔnʋ nɩ pɛpɛ, 'nɩ yɩ ‑mʋ 'na dɩɔnʋ ‑nyi, 'kɩ 'ʋ 'waa ‑ta', ‑ɛ di꞊e nu, ʋ 'mʋ ‑na nyibli mɔ ‑tɛɛ. ");
INSERT INTO ktj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ɛ 'yɩ 'na nyibli ‑bʋ nɩ ‑do a ‑tɩ 'pa‑, 'nɩ ‑da꞊a ‑mʋ. Kɛɛ, 'n dɛ ‑mʋ nɩ ‑wɛ, 'kɩ 'ʋ nyibli ‑bɩ ‑bʋ, 'na nyibli di 'na ‑tɩ ‑lee ‑nɩ, ‑ʋ di 'mʋ ꞊wlʋ yɩ ‑kuo ‑nɩ a ‑tɩ. ");
INSERT INTO ktj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","'N nyɛɛ ‑mʋ lɛ, 'waa pɛpɛ bʋ ‑mʋɛ. 'Na 'Baɩ, ‑tɛ 'n kɔ ‑mʋ 'hʋɛn‑, ‑a ‑nu, ꞊a 'wɩ‑ nyiblo nɩ ‑do yɩ, nu꞊o, ʋ kɔ ‑a mʋ 'hʋɛn‑, ‑ba ‑mʋɛ ‑wɛ. Nu꞊o, bʋ ‑mʋɛ, ‑ɛ di꞊e nu, 'klɔ kɩ a nyibli ‑mʋ', ‑ʋ 'yɩ ‑mʋ ‑yi, ʋ 'mʋ꞊ʋ ꞊han‑tɩ pʋ, ‑ɛ mɔ, ‑mɔ lee 'nɛ‑ 'mʋ 'klɔ kɩ. ");
INSERT INTO ktj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","‑Tɩ a 'yi'bʋalɛ ‑mʋ', ‑nyi 'mʋ, 'n ‑nyi ꞊nʋ꞊ʋ nɩ, ‑ɛ di꞊e nu, ʋ 'mʋ ‑mʋɛ, ꞊wɩ yɩ, ‑tɛ ‑kɔ 'mʋ 'hʋɛn‑, ‑a ‑nu, ꞊a ‑mʋɛ, ");
INSERT INTO ktj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ɛ ꞊hɛn 'nyrɛ, ʋ kɔ 'mʋ 'hʋɛn‑, ‑a 'wɩ‑ nyiblo nɩ ‑do yɩ, 'tɩ‑ ‑kɔ 'mʋ 'hʋɛn‑, ‑a 'wɩ‑ nyiblo nɩ ‑do yɩ, ‑ɛ di꞊e nu, ʋ 'mʋ ‑mʋɛ pɛpɛ, ɛ kɔ, 'klɔ kɩ a nyibli, ʋ 'mʋ꞊ʋ yru, ‑ɛ mɔ, ‑mɔ lee 'nɛ‑ 'mʋ, 'tɩ‑ ʋ 'mʋ꞊ʋ lɛ yru, ‑ɛ mɔ, ‑nʋɛ ꞊nʋ nɩ, ꞊wɩ yɩ, ‑tɛ ‑nu, ꞊nɩ nʋɛ 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","'Na 'Baɩ o, ‑nyi 'mʋ ꞊nʋ nɩ. 'A ‑tɩ, 'n ‑hʋɛ꞊ɛ nɩ, ‑tɩtɛ 'n di 'ʋ nɩ, ʋ kɔ 'mʋ 'hʋɛn‑, ‑ba nɩ 'ʋ ‑wɛ, ‑ɛ di꞊e nu, ʋ 'mʋ 'na ‑tɩ a 'yi'bʋalɛ 'ye. ‑Tɩ a 'yi'bʋalɛ a 'mʋ, ‑nyi la 'mɔ꞊ɔ nɩ, ‑ɛ nu꞊o, 'tɩ‑ 'klɔ 'mʋ la ‑nue ‑nɩ, ‑nʋɛ la 'mʋ nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","'Na 'Baɩ o, ‑mɔ ‑mʋ', ‑ɛ 'sii 'ʋ yɩ, nyibli ‑hʋɔhʋɩ, ‑ʋ nɩ 'nɛ‑ 'klɔ ‑bʋ kɩ, ʋ 'yɩ ‑mʋ ‑yi. Kɛɛ, 'mɔ ‑bɩ, 'n yi ‑mʋ nɩ, ɛ kɔ nyibli ‑mʋ', ‑ʋ yi꞊e, ‑ɛ mɔ, ‑mɔ lee 'nɛ‑ 'mʋ 'klɔ kɩ, nyibli a 'mʋ, ʋ yi ‑mʋ nɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","'N nu꞊o nɩ, 'ʋ yi ‑mʋ, ɛ kɔ, 'mʋ꞊ʋ 'lu ‑mɔ gba, ʋ 'mʋ ‑mʋ yi ‑tɛɛ, ‑ɛ di꞊e nu, ʋ 'mʋ 'waa 'bio ‑nʋɛ ‑nɩ, ꞊wɩ yɩ, ‑tɛ ‑nu, ꞊nɩ nʋɛ 'mʋ, 'tɩ‑ 'n kɔ ꞊nʋ 'hʋɛn‑, ‑a 'mʋ nyiblo nɩ ‑do yɩ 'wɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","‑Tɛ ‑Yusu ‑wɛ 'kɩ 'lɩ Nyɩsʋa a ‑mɔhleelɛ ‑mɔ, ‑ɛ ‑bɩ ɛ kɔ 'a ‑nagbopʋ* 'hʋɛn‑, ʋ 'du ye', 'ʋ ꞊tɩ Jrusrɛdɩɔ 'kwli. Kɛɛ, Judɩa, ‑ɛ mɔ ‑Yusu a ‑nagbopi ‑bɩ, ɛ nɔ‑ kɔ ꞊nʋ 'hʋɛn‑, ‑ʋ 'yɩ ‑mu. 'Nɩhannʋ ꞊dʋ nɩ 'ʋ. 'A 'nyrɛ mɔ Sedrɔ. Sedrɔ a 'mʋ, nɔ‑ kɔ 'nikɩ 'dʋdɔti a ‑ci ꞊dʋ nɩ 'lɩ. Nɔ‑ kɔ kɩ ʋ mu 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","'Waa pɛpɛ, 'kɩ ʋ 'yɛɛ 'lɩ lɛ. Nɔ‑ nu꞊o, Judɩa a 'mʋ, 'ɛ yi 'lɩ ‑tɛ a 'mʋ, 'ɛ kɔ 'kɩ 'hru, 'kɩ bʋ pʋ ‑Yusu 'a yraanyibli ‑jɩ'. ");
INSERT INTO ktj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","'Kɩ 'lɩ 'dɩɔ a 'mʋ 'kwli, Romakʋɛ a tayie nɩ 'lɩ, ɛ kɔ Nyɩsʋa a 'kagbaʋ a 'yie꞊tunyʋ 'hʋɛn‑. Nyibli a 'mʋ, nʋ‑ Judɩa pʋ ye', 'ʋ mi ‑Yusu klɔ mɔ, 'kɩ 'lɩ 'dʋdɔti a ‑ci a 'mʋ kɩ. Nyibli a 'mʋ, Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ kɔ Falisi꞊tumu* a nyibli 'hʋɛn‑, ‑ʋ mɔ ‑Juukʋɛ a 'blʋ a nyibli, nʋ‑ tɛ 'lɩ ꞊nʋ, 'tɩ‑ 'blʋ a nyibli a 'mʋ, ‑ʋ tɛ 'lɩ ꞊nʋ, 'waa pɛpɛ, nʋ‑ mu 'lɩ ‑tɛ a 'mʋ. 'Sɛyo ‑mʋ', ‑ʋ kɔ ꞊nʋ 'hʋɛn‑ ‑mu, ʋ 'ble 'napɩ, kɔ ꞊gbii, kɔ ta‑wɔn‑tɛblɩ kʋa lɛ, 'ʋ ‑mu. ");
INSERT INTO ktj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","‑Yusu yi ‑tɛblɩ a pɛpɛ a 'mʋ nɩ, ‑ɛ kɔ ‑bʋ nu꞊o. Nɔ‑ nu꞊o, 'ɛ 'yɩya 'ʋ ꞊nʋ ye' bʋ, 'ɛ 'bɛti ꞊nʋ, ɛ wɛn: «Nyiblo a 'dɩ ‑bɩ a ꞊mʋɛ lɛ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","‑Ɛ ‑bɩ ʋ wɛn: «Nasalɛtɩ a ‑Yusu.» ‑Ɛ ‑bɩ ɛ wɛn: «'Mɔ, nɔ‑ ‑bʋ.» 'Kɩ Judɩa 'tɩɛ nɩ 'lɩ ‑Yusu a yraanyibli 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","‑Yusu bʋ pʋ 'kɩ lɛ: «'Mɔ, nɔ‑ ‑bʋ,» ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ ʋ naa ke ‑naanaa, 'ʋ bi ꞊hlɔn lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","‑Ɛ ‑bɩ ɛ 'bɛti ꞊nʋ nɩ de, ɛ wɛn: «Nyiblo a 'dɩ ‑bɩ a ꞊mʋɛ lɛ 'lɩ?» ‑Ɛ ‑bɩ ʋ wɛn: «Nasalɛtɩ a ‑Yusu.» ");
INSERT INTO ktj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","‑Ɛ ‑bɩ ɛ wɛn: «'Bɩ 'n lee wɛn 'a mʋ nɩ, ‑ɛ mɔ, 'mɔ, nɔ‑ ‑bʋ. ‑Tɛ ɛ mɔ 'mɔ, a ‑hʋɛ ba klɔ, ba ‑ha 'na ‑nagbopʋ mɛ lɛ, bʋ mu, a 'nɩ 'klɔɔ 'lɩ ꞊nʋ.» ‑Ɛ ‑bɩ 'sɛyo ‑ha ‑Yusu a ‑nagbopʋ mɛ lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","‑Tɛ ɛ pʋ lɛ, ‑ɛ ‑bɩ dɛ ‑mʋ', ɛ hla la, ti ‑hi la a ti 'yri, ɛ nue kɛ nɩ. Dɛ a 'mʋ, ɛ nɔ‑ ‑bʋ: «'Na 'Baɩ Nyɩsʋa o, nyibli ‑mʋ', ‑nyi la 'mʋ, 'n 'yɩ 'a nyiblo nɩ ‑do 'waan ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","'Kɩ 'lɩ ‑Yusu a yraanyibli a 'mʋ 'nyɩ, nyiblo ꞊dʋ nɩ 'lɩ, 'a 'nyrɛ 'ɛ mɔ Malikusɩ. Ɛ mɔ Nyɩsʋa a ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ a ‑kʋannunyɔ ꞊nɩɔ. ‑Ɛ ‑bɩ Simɔ Piɛlɩ, ‑ɛ mɔ ‑Yusu a ‑nagbopi ‑bɩ, ‑ɛ nɩ 'ʋ ‑Yusu 'hʋɩ, ɛ nu 'a 'plɩɛn, 'ɛ 'bɛ 'ʋ Malikusɩ a 'mʋ, 'a diidɛnʋa 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","‑Ɛ ‑bɩ ‑Yusu wɛn: «Piɛlɩ o, pʋ 'lɩ ‑na 'plɩɛn bɔ 'kwli. ꞊Bɩ ꞊yɩ꞊ɩ ‑yi, ‑ɛ mɔ, 'n kɔ ꞊bʋ ‑yra ꞊hɩʋɛn ‑mʋ', Nyɩsʋa ‑hʋɛ ꞊bʋ 'ye 'lu?» ");
INSERT INTO ktj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","‑Ɛ ‑bɩ ti nɩ ‑do a ti 'yri, nyibli a 'mʋ, Judɩa ‑gba, ʋ kɔ 'waa nyibli gbagbɩ 'hʋɛn‑, ʋ klɔ ‑Yusu nɩ, 'ʋ mʋa ꞊nɛ, ");
INSERT INTO ktj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","'ʋ gba꞊a 'dɩɔ. Yɩ‑hɛnyiblo ‑kɔ ‑mɔ ʋ gba 'lɩ꞊ɩ, nɔ‑ mɔ ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ. Nyɩbɛhɩan a 'mʋ, 'a 'nyrɛ mɔ Hanɩ. Ɛ nɔ‑ mɔ Kaifʋ a tʋa. Kaifʋ a 'mʋ, ɛ nɔ‑ mɔ 'yrʋ a 'mʋ 'kwli a ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ. ");
INSERT INTO ktj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaifʋ nɩ ‑do a 'mʋ, nɔ‑ pʋ la ‑Juukʋɛ* ꞊tɔ' ti ꞊dʋ ‑hi la a ti 'yri, ‑ɛ mɔ: «Ɛ nu ‑tɛɛ, 'kɩ nyiblo nɩ ‑do bʋ 'kʋ, 'kɩ 'ʋ ‑aan dakɔ a pɛpɛ a ‑ta', 'ɛ ‑hi 'ʋ ‑aan dakɔ a pɛpɛ bʋ 'kʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Bʋ yɩ 'kɩ ‑Yusu nɩ gbɛ, ‑ɛ ‑bɩ Simɔ Piɛlɩ kɔ ‑Yusu a ‑nagbopi ‑bɩ 'hʋɛn‑, ʋ nʋ‑ yɩ꞊ɩ ꞊wien lɛ kʋɛ. ‑Nagbopi ‑bɩ a 'mʋ, ‑cɔhlʋnpinyʋ* a nyiblo gbagbʋ, ‑ɛ mɔ Hanɩ, ɛ yi꞊e nɩ. Ɛ nɔ‑ nu꞊o, ɛ kɔ ‑Yusu 'hʋɛn‑ 'ʋ pa 'ʋ ‑tɛ nɩ ‑do, 'kɩ 'lɩ nyɩbɛhɩan a 'mʋ, ‑ɛ mɔ Hanɩ, 'a ‑yaa 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Kɛɛ, Piɛlɩ ‑mɔ ‑bɩ, 'kɩ ɛ hree 'ʋ ‑yaa a 'mʋ, 'a ꞊hʋan.yɩ'. ‑Nagbopi ‑mʋ', ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ ‑yi, nɔ‑ lee 'yu nyrɔyu ‑mʋ', ‑ɛ ꞊tui 'maju 'yie, 'ɛ paa Piɛlɩ. ");
INSERT INTO ktj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Piɛlɩ bʋ pa 'kɩ, ‑ɛ ‑bɩ 'yu nyrɔyu a 'mʋ, ɛ yɩ꞊ɩ 'nɩ 'bɛti ‑nɩ, ɛ wɛn: «'Bɩ ‑mɔ ‑Yusu a ‑nagbopi ‑bɩ ꞊nɩɔ ‑wɛ.» ‑Ɛ bɩ Piɛlɩ wɛn: «Yruyru, 'n 'yɩ 'lɩ ꞊nʋ 'nyɩ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","‑Tɛ cɛ yɩ 'kɩ nɩ ꞊tɩ, ‑ɛ ‑bɩ ‑kʋannunyibli ‑mʋ', ‑ʋ kɔ Nyɩsʋa a 'kagbaʋ a 'yie꞊tunyʋ 'hʋɛn‑, ‑ʋ nɩ 'ʋ, ʋ 'tie na, 'ʋ yɩ꞊ɩ 'wɛn. 'Kɩ Piɛlɩ nɩ 'lɩ ꞊nʋ 'nyɩ, 'ɛ yɩ na 'wɛn ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ti a 'mʋ 'yri, ‑ɛ ‑bɩ ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ Hanɩ, ɛ ‑tʋa ‑Yusu tete a lɛ'bɛtilɛ, ɛ wɛn: «Nyibli a 'dɩ ‑bɩ ‑mɔ ‑na ‑nagbopʋ* 'lɩ, kɔ, dɛ a 'dɩ ‑bɩ ‑mɔ ‑na tɔɔwin 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","‑Ɛ ‑bɩ ‑Yusu ꞊tu꞊o ꞊wɔn, ɛ wɛn: «Nyibli a pɛpɛ yi ‑tɩ a pɛpɛ, 'n tɔɔ ‑nɩ nɩ. 'N 'yɩ ‑tɩ ꞊dʋ ‑hli. 'A ‑nɛ ti, 'n tʋɛ la nɩ, 'kɩ 'lɩ Nyɩsʋa a 'kayo bʋ, ɛ kɔ, 'kɩ 'lɩ 'a 'kagbaʋ a ‑yaa 'kwli, ‑tɛ ‑Juukʋɛ* a pɛpɛ 'yɛɛ 'lɩ lɛ, ʋ kɔ 'waa nyibli gbagbɩ 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","'A ‑tɩ, ꞊nɩ 'bɛtie 'lɩ 'mʋ. Nyibli ‑mʋ', ‑ʋ nɩ la ‑tuo kɩ, ʋ nʋ‑ ‑bʋ 'bɛti ‑nɩ. ‑Tɛblɩ a pɛpɛ, 'n tɔɔ la ‑nɩ, ʋ yi꞊e nɩ. 'Waa ‑hʋɔhʋɩ nɩ 'nɛ‑ ‑a mʋ 'nyɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","‑Yusu bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ Nyɩsʋa a 'kagbaʋ a 'yie꞊tunyɔ ‑bɩ, ‑ɛ nɩ 'ʋ, ɛ pʋ 'lɩ꞊ɩ 'ŋma nʋa', ɛ wɛn: «Kɛ‑ ‑ni ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ a ꞊wɔn꞊tutuo?» ");
INSERT INTO ktj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","‑Ɛ ‑bɩ ‑Yusu wɛn: «'Bʋ mɔ, 'nɩ hla ‑tɩ, 'bʋ nyre yɩ, tɔɔ 'mɔ꞊ɔ, kɛɛ, 'bʋ mɔ, ‑tɩ ‑bʋ, 'n ‑hla, 'bʋ nɔ yɩ, dɛ‑ kɔ 'na bibie 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ti a 'mʋ 'yri, ‑ɛ ‑bɩ Hanɩ lee nɛ 'a 'sɛyo nɩ, bʋ gba 'lɩ꞊ɩ ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ Kaifʋ ‑mɔ. ‑Yusu 'tɩɛ nɩ 'lili'. ");
INSERT INTO ktj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ti a 'mʋ 'yri, Simɔ Piɛlɩ 'tɩɛ nɩ 'lɩ na'wɛnnyʋ 'nyɩ, 'kɩ 'lɩ ‑yaa a 'mʋ 'kwli. ‑Ɛ ‑bɩ kɛ‑ nyiblo ꞊dʋ pɩ꞊ɩ yɩ, ɛ wɛn: «‑Mɔ ‑bʋ, ‑mɔ ‑Yusu a ‑nagbopi ‑bɩ ꞊nɩɔ.» Kɛɛ ‑ɛ ‑bɩ ɛ wɛn: «'Ʋʋn‑, 'n 'yɩ 'lɩ ꞊nʋ 'nyɩ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","‑Ɛ ‑bɩ ‑cɔhlʋnpinyʋ* a nyiblo gbagbʋ a ‑kʋannunyɔ ‑bɩ nɩ 'ʋ ‑wɛ. Nyiblo ‑mʋ', ‑ɛ kɔ nʋa Piɛlɩ 'bɛ wɛn 'ʋ, ɛ nɔ‑ kɔ 'dɩayɩ ꞊nɩɔ. Nɔ‑ yɩ Piɛlɩ ‑lee ‑nɩ ‑wɛ, ɛ wɛn: «‑Mɔ ‑bʋ, ‑mɔ ‑Yusu a ‑nagbopi ꞊nɩɔ, ‑ɛ nu꞊o, ɛ kɔ ‑mʋ 'hʋɛn‑, 'n 'ye wɛn 'a mʋ nɩ, 'kɩ 'lɩ ti bʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Kɛɛ, Piɛlɩ ‑ga nɩ de. Bʋ ‑ga 'kɩ, ‑ɛ ‑bɩ ti nɩ ‑do a ti 'yri, hapɛ da ‑nyrɛ nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","‑Tɛ ‑nyrɛ ‑nyɛ 'kɩ, ‑ɛ ‑bɩ ‑Juukʋɛ* ‑ha 'lɩ ‑Yusu Kaifʋ a ‑yaa 'kwli nɩ, 'ʋ gba 'lɩ꞊ɩ Romakʋɛ a ‑gʋlʋnʋma a 'kagbaʋ bʋ. ‑Gʋlʋnʋma a 'mʋ, 'a 'nyrɛ mɔ Pilatɩ. ‑Juukʋɛ ‑mɔ ‑bɩ, 'waa nyiblo ꞊dʋ yɩ 'lɩ ‑yaa a 'mʋ 'kwli ‑pa. Ʋ wɛn 'nɩ, 'bʋ pa 'lɩ ‑gʋlʋnʋma, ‑ɛ 'yɩ ‑Juukʋɛyu 'pa‑ a ‑tɛ, ‑ɛ ‑bɩ ʋ 'yɩ 'ʋ yɩ 'sii ‑nɩ, 'kɩ 'ʋ Nyɩsʋa ye'. 'A ‑tɩ, ʋ 'nɩ ‑di꞊e lɛ'mimle, ‑ɛ mɔ Pakɩ a diidɛ nɩ. Ɛ nɔ‑ nu꞊o, 'ʋ hree 'ʋ ‑patʋ'. ");
INSERT INTO ktj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Bʋ 'wlɛ 'kɩ 'ʋ ‑patʋ' bʋ, ɛ nɔ‑ nu꞊o, Pilatɩ 'ɛ 'hrɩ, 'ɛ mu 'ʋ ꞊nʋ ye', ɛ wɛn: «Ba lee 'mʋ dɛ ‑mʋ', nyiblo ‑bʋ, ɛ ‑nu, ‑kɔtɩ a yɩ꞊ɩ ‑yɛɛ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","‑Ɛ ‑bɩ ʋ wɛn: «'Bʋ 'yɩ wɛn dɛ‑hʋannunyɔ 'pa‑, ‑a 'nɩ ‑ya꞊a wɛn꞊ɛ ‑mɔ yɩ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ Pilatɩ wɛn: «Ba gba꞊a, ba pʋʋ ꞊nɛ ‑bati lɛ 'a mʋ nɩ ‑do. Dɛ ‑mʋ', a ‑hʋɛ, ɛ nɔ‑ ba nu꞊o ‑mɔ, ‑tɛ ‑mʋ', 'aan tete ni 'a hɩhla.» ‑Ɛ ‑bɩ ʋ wɛn: «'A mʋ Romakʋɛ, a pʋ 'lɩ tete, ‑ɛ mɔ, ‑a mʋ ‑Juukʋɛ, ‑a 'nɩ 'laa 'lɩ nyiblo. 'A ‑tɩ, ‑a ‑hʋɛ꞊ɛ nɩ, ba kɔɔ 'ʋ꞊ʋ tugbɛ 'yie, ɛ 'mʋ 'kʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","‑Tɛ ʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ dɛ ‑mʋ', ‑Yusu hla la, 'kɩ 'ʋ 'a 'kʋkʋʋdʋ a 'mʋ a ‑ta', ti ꞊dʋ ‑hi la a ti 'yri, ‑ɛ ‑bɩ dɛ a 'mʋ, nɔ‑ di kɛ 'lu ‑mɔ mu. ");
INSERT INTO ktj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","‑Ɛ ‑bɩ Pilatɩ pa nɩ de, 'ɛ lee nɛ 'a 'sɛyo, 'kɩ bʋ 'yɩya 'ʋ꞊ʋ ‑Yusu ye' bʋ. Bʋ 'yɩya 'kɩ 'ʋ ꞊nɛ꞊ɛ ye' bʋ, ‑ɛ ‑bɩ ɛ wɛn: «꞊Bɩ ‑mɔ mɔ ‑Juukʋɛ a bodɩɔ?» ");
INSERT INTO ktj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","‑Ɛ ‑bɩ ‑Yusu wɛn: «꞊Bɩ ‑tɩ ‑bʋ, ‑yɩ 'mʋ 'bɛti ‑nɩ, ‑na ꞊gbɛtʋ, ‑hie꞊e 'lu ‑mɔ lɛ, 'kɩ 'ʋ 'mʋ ‑mɔ, ‑ʋ'ʋ‑ nyibli ꞊dʋ lee ‑mɔ꞊ɔ?» ");
INSERT INTO ktj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","‑Ɛ ‑bɩ Pilatɩ wɛn: «'Mɔ ‑bʋ, 'n 'yɩ ‑Juukʋɛyu 'pa‑. ‑Na ꞊gbɛtʋ a dakɔ kɔ ‑cɔhlʋnpinyʋ* gbagbɩ 'hʋɛn‑, ʋ nʋ‑ ya 'nɛ‑ ‑mʋ 'mʋ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","‑Ɛ ‑bɩ ‑Yusu wɛn: «'Na bodɩɔdɛ 'yɩ 'klɔ ‑bʋ a nyibli a bodɩɔdɛ yɩ 'wɩ, 'tɩ‑ ɛ 'yɩ ‑tonyibli 'pa‑, ʋ 'yɩ 'mʋ bodɩɔdɛ ‑nyi, Nyɩsʋa a ꞊gbɛtʋ, nɔ‑ ‑nyi 'mɔ꞊ɔ. 'Bʋ mɔ, 'nɩ 'wɩ wɛn 'klɔ ‑bʋ a bodɩɔpʋ yɩ, 'na ‑nagbopʋ* di wɛn 'nɩ ‑wɔn, 'kɩ 'lɩ 'dʋdɔti bʋ, ‑ɛ di꞊e nu, ʋ 'nɩ ꞊ha wɛn 'mʋ ‑Juukʋɛ ‑jɩ' pʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","‑Ɛ ‑bɩ Pilatɩ wɛn: «'A ‑tɩ, ‑mɔ bodɩɔ ꞊nɩɔ 'a?» ‑Ɛ ‑bɩ ‑Yusu wɛn: «Ɛ nɔ‑ ‑hlɛ, 'mɔ bodɩɔ ꞊nɩɔ. Ɛ nɔ‑ nu꞊o, 'nɩ ‑hɔn 'lɩ Nyɩsʋa yɩ, 'ʋ kɔ 'mʋ, 'mʋ nyibli ‑tɩ a ‑tɛɛ ‑tɔɔ ‑nɩ. 'A ‑tɩ, nyiblo 'bʋ nʋɛ ‑tɩ a ‑tɛɛ, ɛ pɩ 'mʋ nʋa yɩ bʋ, 'tɩ‑ 'ɛ pɩ 'na ‑tɩ ꞊han‑tɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","‑Ɛ ‑bɩ Pilatɩ wɛn: «Dɛ‑ mɔ 'kɩ ‑tɩ a ‑tɛɛ 'lɩ?» Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ɛ 'hrɩ nɩ de, 'ɛ mu 'ʋ ‑Juukʋɛ a 'mʋ ye', ɛ wɛn: «'Mɔ ‑bɩ ‑o, 'nɩ 'yee꞊e 'lɩ꞊ɩ dɛ ‑hʋan ꞊dʋ 'lɩ, ɛ ‑nu, ‑ɛ blɛɛ 'kʋkʋʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kɛɛ, ɛ mɔ ‑aan dɛ ꞊nɩɔ, ꞊a ni꞊i lɛ, 'aan lɛ'mimle ‑mʋ', ‑ɛ mɔ Pakɩ a ti 'yri: 'n kɔ ꞊bʋ tɛ ꞊jɩklapi nɩ ‑do bʋ, a ‑hʋɛ. 'A ‑tɩ, ꞊bɩ a ‑hʋɛ꞊ɛ nɩ, 'kɩ ꞊bʋ tɛ 'aan bodɩɔ bʋ?» ");
INSERT INTO ktj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","‑Ɛ ‑bɩ ti nɩ ‑do a ti 'yri, ʋ ‑tʋa ꞊yɛ a lɛpʋpʋʋ, ʋ wɛn: «'Klɔ a 'klɔ, ‑a 'nɩ ‑hʋa꞊a lɩ꞊ɩ, Balabasɩ ‑a ‑hʋɛ.» ‑Ɛ kɔ ‑ta' Balabasɩ a 'mʋ, ɛ mɔ ‑balʋnyiblo ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","‑Ɛ ‑bɩ Pilatɩ lee 'sɛyo nɩ, ɛ wɛn: «Ba gba꞊a, ba bii ꞊nɛ lɔkɔ,» 'ʋ gba꞊a, 'ʋ bi꞊e. ");
INSERT INTO ktj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","‑Tɛ ʋ ‑wɛ 'a bibie ‑mɔ, ‑ɛ ‑bɩ ʋ hlaa ꞊nɛ 'witiklaʋn lɛ, 'ʋ ꞊tu ꞊nɛ꞊ɛ 'lu, kɔ, 'ʋ pʋ꞊ʋ wlawlʋ ‑jɔhʋn. Wlawlʋdʋ a 'mʋ, bodɩɔpʋ nɩ ‑do, nʋ‑ pɩ꞊ɩ lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","‑Ɛ ‑bɩ ʋ 'yɩya 'ʋ꞊ʋ 'hʋɩ bʋ, 'ʋ 'cɛɛ ꞊nɛ, ʋ wɛn: «‑Na 'wio mɔ, ‑Juukʋɛ a bodɩɔ,» kɔ, 'ʋ pɩ 'lɩ꞊ɩ 'ŋmɩ nʋɩ' lɛ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","‑Ɛ ‑bɩ Pilatɩ 'hrɩ nɩ de, ɛ wɛn: «'N yɛ 'a mɔ꞊ɔ yɩ, 'kɩ 'nɛ‑ ‑patʋ', ‑ɛ di꞊e nu, a 'mʋ꞊ʋ yi, ‑ɛ mɔ, 'nɩ 'yee꞊e 'lɩ꞊ɩ dɛ ‑hʋan ꞊dʋ 'lɩ, ɛ ‑nu, ‑ɛ blɛɛ 'kʋkʋʋ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","‑Ɛ ‑bɩ ‑Yusu 'hrɩ nɩ, 'a 'witiklaʋn 'ɛ nɩ 'ʋ꞊ʋ 'lu, kɔ, 'a wlawlʋ ‑jɔhʋn 'ɛ nɩ 'lɩ꞊ɩ 'lɩ. ‑Ɛ ‑bɩ Pilatɩ wɛn: «'Aan nyiblo, nɔ‑ ‑bʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","‑Tɛ Nyɩsʋa a ‑cɔhlʋnpinyʋ* gbagbɩ kɔ Nyɩsʋa a 'kagbaʋ a 'yie꞊tunyʋ 'hʋɛn‑, ʋ pʋ 'ʋ ‑Yusu 'yie 'hʋɩ, ‑ɛ ‑bɩ ʋ ‑tʋa ꞊yɛ a lɛpʋpʋʋ, ʋ wɛn: «Kɔɔ 'ʋ꞊ʋ tugbɛ 'yie, ɛ 'mʋ 'kʋ!» ‑Ɛ ‑bɩ Pilatɩ wɛn: «Ba gba꞊a, ba kɔɔ 'ʋ꞊ʋ tugbɛ 'yie, 'aan ꞊gbɛtʋ, ‑ɛ nu꞊o, 'mɔ ‑bʋ, 'nɩ 'yee꞊e 'lɩ꞊ɩ dɛ ‑hʋan ꞊dʋ 'lɩ, ɛ ‑nu, ‑ɛ blɛɛ 'kʋkʋʋ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","‑Ɛ ‑bɩ ‑Juukʋɛ wɛn: «Pilatɩ, ‑a mʋ ‑bʋ, ‑a kɔ tete. Tete a 'mʋ, ɛ wɛn 'nɩ, nyiblo, ‑ɛ di 'a dɩɔnʋ Nyɩsʋa ‑daa ‑nɩ, nyiblo a 'mʋ, ɛ blɛɛ 'kʋkʋʋ yɩ. 'A ‑tɩ, ‑tɛ ɛ pʋ lɛ, ‑ɛ mɔ, ɛ mɔ Nyɩsʋa a 'Yu ꞊nɩɔ, ɛ nɔ‑ kɔ ‑tɩ 'ɛ blɛɛ 'kʋkʋʋ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","‑Tɛ Pilatɩ 'wɩn 'kɩ ‑Juukʋɛ a pʋpʋwin, ‑ɛ ‑bɩ hʋannʋ bi 'lɩ꞊ɩ 'kwli, ");
INSERT INTO ktj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","'ɛ pa 'lɩ 'a 'kagbaʋ bʋ de, 'ɛ yɩ ‑Yusu 'bɛti ‑nɩ, ɛ wɛn: «꞊Bɩ 'kɩ ‑hɔn 'lɩ Nyɩsʋa ‑mɔ?» Kɛɛ, ‑Yusu 'yɩ꞊ɩ ꞊dedede klɛ ‑hɩhɩa ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ɛ nɔ‑ nu꞊o, Pilatɩ 'ɛ yɩ꞊ɩ ‑lee ‑nɩ, ɛ wɛn: «꞊Bɩ 'mɔ Pilatɩ, 'mɔ ‑yɩ ‑mʋ 'bɛti ‑nɩ, ꞊nɩ 'yɛ nɩ pʋ 'mʋ mɛ lɛ. ꞊Yɩ꞊ɩ ‑yi, ‑ɛ mɔ, 'mɔ ‑mɔ 'blʋgba ‑bʋ, 'a ‑gʋlʋnʋma, 'n kɔ 'klɩ, 'kɩ ꞊bʋ tɛ ‑mʋ bʋ, 'tɩ‑ 'nɩ kɔ 'klɩ ‑wɛ, 'kɩ ꞊bʋ kɔɔ 'ʋ ‑mʋ tugbɛ 'yie.» ");
INSERT INTO ktj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","‑Ɛ ‑bɩ ‑Yusu wɛn: «꞊Nɩ ‑kɔ꞊ɔ wɛn 'klɩ nɩ, 'kɩ 'ʋ 'mʋ kɩ, 'bʋ mɔ, Nyɩsʋa 'bʋ 'yɩ wɛn ‑mʋ 'klɩ ‑nyi. Nɔ‑ nu꞊o, nyiblo ‑bʋ, ‑ɛ pʋ 'mʋ ‑mʋ ‑jɩ', 'ɛ nu dɛ ‑hʋan, 'ɛ ‑hi 'ʋ ‑mʋ 'ʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kʋɛ 'kɩ 'ʋ ti a 'mʋ 'yri bʋ, ‑ɛ ‑bɩ Pilatɩ ꞊tui 'ʋ 'klɩ de, ‑ɛ di꞊e nu, ɛ 'mʋ ‑Yusu bʋ tɛ. Ɛ nɔ‑ mɔ ‑Juukʋɛ bʋ ꞊mʋma lɛ, ʋ wɛn: «'Bʋ mɔ, ꞊nɩ tɛ nyiblo ‑mʋ' bʋ, ‑ɛ ‑bɩ ‑kɔ Romakʋɛ a 'kɩɩn gbagbʋ 'hʋɛn‑, a 'yɩ ‑pɛ. Ɛ kɔ, 'bʋ mɔ, nyiblo 'bʋ yɩ 'a dɩɔnʋ bodɩɔ nɩ ‑dɛɛ ‑nɩ, ‑ɛ ‑bɩ ɛ kɔ 'kɩɩn gbagbʋ a 'mʋ 'hʋɛn‑, ʋ 'yɩ ‑pɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","‑Tɛ Pilatɩ 'wɩn 'kɩ ‑tɩ a 'mʋ, ‑Juukʋɛ ‑hla, ɛ nɔ‑ mɔ bʋ 'hrɔɔ 'ʋ ‑Yusu ‑patʋ', 'tɩ‑ 'ɛ nɩ 'lɩ 'a ‑batipʋgbata 'kwli bʋ. ‑Tɛ a 'mʋ, ɛ nɩ 'ʋ bʋ, ʋ pʋ la 'ʋ 'hɩ papʋɛ blɛ. ‑Tɩtɛ a 'mʋ, 'a 'nyrɛ mɔ Gabata, 'kɩ 'lɩ ‑Juukʋɛwin 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ɛ mɔ Pakɩ a 'wee a ‑nyrɔwɩ nɩ ꞊hun a ‑nyragblɩ, 'kɩ Pilatɩ pʋʋ la 'ʋ ‑Yusu ‑bati lɛ. ‑Ɛ ‑bɩ Pilatɩ wɛn: «‑Juukʋɛ ‑na, 'aan bodɩɔ, nɔ‑ ‑bʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","‑Ɛ ‑bɩ ʋ ‑tʋa ꞊yɛ a lɛpʋpʋʋ de, ʋ wɛn: «Bʋ 'kʋ, bʋ 'kʋ, kɔɔ 'ʋ꞊ʋ tugbɛ 'yie!» ‑Ɛ ‑bɩ Pilatɩ wɛn: «꞊Bɩ 'aan ‑nɛ bodɩɔ, nɔ‑ ꞊bʋ kɔɔ 'ʋ tugbɛ 'yie?» ‑Ɛ ‑bɩ ‑cɔhlʋnpinyʋ gbagbɩ wɛn: «‑A 'yɩ bodɩɔ ꞊dʋ ‑yi, 'bʋ 'yɩ Romakʋɛ a 'kɩɩn gbagbʋ 'pa‑.» ");
INSERT INTO ktj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","‑Ɛ ‑bɩ Pilatɩ lee nɛ 'a 'sɛyo nɩ, ɛ wɛn: «Ba gba꞊a, ba kɔɔ 'ʋ꞊ʋ tugbɛ 'yie, ɛ 'mʋ 'kʋ, ꞊wɩ yɩ, ‑tɛ ‑Juukʋɛ ni 'a ‑hʋhʋa,» 'sɛyo a 'mʋ, 'ʋ klɔ ‑Yusu, 'ʋ gbɛ꞊ɛ. ");
INSERT INTO ktj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","‑Ɛ ‑bɩ ʋ hlɛ ‑Yusu nɩ, 'ɛ 'ble 'a dɩɔnʋ a tugbɛ ‑mʋ', ‑ɛ kɔ 'yie ʋ di 'ʋ꞊ʋ ‑kɔɔ ‑nɩ, 'ʋ ꞊tɩɔ ꞊nɛ Jrusrɛdɩɔ 'kwli. ‑Tɩtɛ ‑mʋ', ʋ gba 'lɩ꞊ɩ 'lɩ, ɛ nɔ‑ ʋ dɛɛ 'Lukla, ‑ɛ mɔ Gɔlʋgɔta, 'kɩ 'lɩ ‑Juukʋɛwin 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","'Kɩ ʋ kɔɔ 'lɩ꞊ɩ tugbɛ 'yie, 'ʋ kɔɔ 'ʋ dɛ'kukununyʋ nɩ 'hʋɛn ‑wɛ, 'kɩ 'ʋ 'waa ‑nɛ ti 'yie, nyiblo nɩ ‑do, 'kɩ 'lɩ ‑Yusu a diidɛkɩbɩa kɩ, ‑do ‑bɩ 'kɩ 'lɩ 'a kamlakɩbɩa kɩ. ");
INSERT INTO ktj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","‑Ɛ ‑bɩ Pilatɩ lee nɛ 'a nyibli nɩ, 'ʋ 'crɩ wuntɔdɛ, 'kɩ 'ʋ 'plaɩnkɩbɩa kɩ, 'ʋ 'ma 'ʋ꞊ʋ ‑Yusu a tugbɛ 'lu bʋ. Winbʋ a 'mʋ, kɛ‑ ɛ pɩ: «Nyiblo ‑bʋ, ɛ nɔ‑ mɔ Nasalɛtɩ a ‑Yusu, ‑ɛ mɔ ‑Juukʋɛ a bodɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Winbʋ a 'mʋ, ʋ 'crɩɩ 'lɩ꞊ɩ wingble nɩ ta 'kwli, ‑ɛ mɔ ‑Juukʋɛwin, kɔ Romakʋɛwin, kɔ Glɛkɩkʋɛwin. ‑Tɩtɛ a 'mʋ, ʋ kɔɔ 'ʋ ‑Yusu tugbɛ 'yie, ɛ 'mʋɛ 'dɩɔ yrɛ. 'A ‑tɩ, ‑Juukʋɛ ‑hʋɔhʋɩ yɩ win a 'mʋ 'nɩ ‑hre. ");
INSERT INTO ktj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","‑Tɛ ‑Juukʋɛ a ‑cɔhlʋnpinyʋ* gbagbɩ ‑hre win a 'mʋ, ‑ɛ ‑bɩ ʋ mu 'lɩ Pilatɩ ‑mɔ, ʋ wɛn: «꞊Yɩ yɩ ‑blɛɛ ‑nɩ, ‑bʋ 'crɩ wɛn, ‑ɛ mɔ, ‑Yusu mɔ ‑Juukʋɛ a bodɩɔ ꞊nɩɔ, kɛɛ, kɛ‑ ‑kɔ ‑bʋ pʋ wɛn: Nyiblo ‑bʋ, ɛ wɛn 'nɩ, ɛ nɔ‑ mɔ ‑Juukʋɛ a bodɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Kɛɛ, Pilatɩ wɛn: «Dɛ ‑mʋ', 'n 'crɩ, 'n 'crɩ꞊ɩ nɩ. 'Nɩ 'cɩcɩ꞊ɩ lɩ꞊ɩ nɩ de.» ");
INSERT INTO ktj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","‑Tɛ 'sɛyo ‑wɛ 'kɩ ‑Yusu a kʋkɔ ‑mɔ, 'kɩ 'ʋ tugbɛ 'yie, ‑ɛ ‑bɩ ʋ 'du 'a 'hʋɩlɛpʋ‑tɛblɩ 'mʋ ye', 'ʋ nu 'a dui nɩ ‑hɛn, 'ʋ ꞊gla꞊a, nyiblo 'bʋ nɩ 'ʋ, 'a ‑nɛ du. Kɛɛ, wlawlʋ nɩ ‑do nɩ 'ʋ, ‑ɛ mɔ danʋ nɩ ‑do a wlawlʋ blɔblʋ. ");
INSERT INTO ktj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","‑Ɛ ‑bɩ ʋ wɛn: «‑A 'nɩ 'cɩcraa 'lɩ꞊ɩ lɛ. Wlawlʋ ‑bʋ a ‑tɩ, ‑ba pʋ 'wla, nyiblo, 'wla di di, nɔ‑ di꞊e gba.» Dɛ a 'mʋ, ɛ nɔ‑ 'sɛyo ‑nu. ‑Ɛ ‑bɩ ‑tɩ ‑mʋ', winwlɔn‑hanyɔ* ‑bɩ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, ti ‑hi la a ti 'yri, ɛ nue kɛ nɩ. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: «Ʋ ꞊gla 'na 'hʋɩlɛpʋ‑tɛblɩ nɩ, 'tɩ‑ 'na wlawlʋ a ‑tɩ, 'ʋ pʋ 'wla.» ");
INSERT INTO ktj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","‑Tɛ ‑Yusu nɩ 'ʋ tugbɛ 'yie, ɛ kɔ la nʋgbɩ, 'ʋ nɩ la 'ʋ꞊ʋ ꞊hlɔn. Nʋgbɩ a 'mʋ, 'waa 'nyrɛ, nɔ‑ ‑bʋ: ‑Yusu a ꞊gbɛtʋ a 'dii, kɔ 'a 'dii a 'dɩayɩ, kɔ Mari ‑bɩ ‑mʋ', ‑ɛ mɔ Klopasɩ a nʋgba, kɔ Mari, ‑ɛ kɔ 'lɩ Madala. ");
INSERT INTO ktj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","‑Nagbopi* ‑mʋ', ‑Yusu nʋɛ ‑nɩ ‑tɛɛ, 'kɩ ɛ nɩ 'ʋ ‑wɛ. ‑Yusu bʋ 'ye 'kɩ 'a 'dii, 'kɩ 'ʋ ‑nagbopi a 'mʋ 'hʋɩ, 'kɩ 'ʋ꞊ʋ ꞊hlɔn, ‑ɛ ‑bɩ ɛ wɛn: «'Na 'dii o, ‑na 'yu, nɔ‑ ‑bʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","‑Ɛ ‑bɩ ɛ lee nɛ 'a ‑nagbopi a 'mʋ nɩ, ɛ wɛn: «‑Mɔ ‑bɩ, ‑na 'dii, nɔ‑ ‑bʋ.» Kʋɛ 'ʋ ti a 'mʋ 'yri bʋ, 'kɩ ‑nagbopi a 'mʋ, ɛ gba 'lɩ ‑Yusu a 'dii 'a dɩɔnʋ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","‑Tɛ dɛ a 'mʋ, ɛ ‑hi 'kɩ, ‑ɛ ‑bɩ ‑Yusu yi꞊e nɩ, ‑ɛ ‑mɔ, 'a ‑kʋan ‑yrɛ 'lu, ‑ɛ ‑bɩ ɛ wɛn: «'Na plɔ ma yɩ.» Kɛ‑ ɛ ‑pʋ, ‑ɛ di꞊e nu, ‑tɩ ‑bʋ, ʋ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑tɩ a 'mʋ, ɛ 'mʋ kɛ ‑nue ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","'Kɩ 'ʋ tugbɛ a 'mʋ 'hʋɩ, 'kɩ 'lipanɔ a 'pɔlʋwɔ nɩ 'ʋ. Nɔ‑ kɔ ‑mɔ 'sɛyo 'nyra 'lɩ dɛ, ‑ɛ 'wɩ‑ damuo yɩ, 'ʋ mʋa 'ʋ꞊ʋ tugbɛ 'yri lɛ, 'ʋ ‑nyi꞊e ‑Yusu, 'ɛ 'na꞊a. ");
INSERT INTO ktj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","‑Tɛ ɛ 'na 'kɩ꞊ɩ, ɛ wɛn: «‑Kʋan a pɛpɛ ‑yrɛ kɛ 'lu nɩ.» ‑Ɛ ‑bɩ ɛ ꞊tɩɔ 'ʋ 'lu, 'ɛ mla ‑hʋnhlʋn. ");
INSERT INTO ktj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ti ‑hie 'lɩ, ‑Juukʋɛ* a ‑wuwle‑nyrɔwɔ* 'mʋ ‑wlu ꞊tu, ɛ 'yɩ ‑hʋ. ‑Nyrɔwɔdʋ a 'mʋ, ɛ nɩ 'dɔ, 'kɩ 'lɩ ‑nyrɔwɩ a pɛpɛ 'nyɩ, 'kɩ 'lɩ Pakɩ a 'wee 'kwli. 'A ‑tɩ, ʋ 'nɩ ‑hʋa꞊a lɩ꞊ɩ, 'kɩ 'kʋkʋkui bʋ 'tɩɛ nɩ 'ʋ ti 'yie lɛ ‑wuwle‑nyrɔwɔ a 'mʋ 'kwli. Ɛ nɔ‑ nu꞊o, 'ʋ lee Pilatɩ, ɛ 'mʋ 'a 'sɛyo ‑lee ‑nɩ, bʋ nu 'plɩdɛ, bʋ ‑yɩyra ‑Yusu kɔ ‑balʋnyʋ nɩ 'hʋɛn a 'mʋ, 'waa bʋɩ lɛ, ‑ɛ di꞊e nu, ʋ 'mʋ 'kʋ 'wʋwlɩ, ɛ 'mʋ ꞊nʋ ti ‑nyi, 'kɩ bʋ ‑ha 'ʋ ꞊nʋ ti 'yie lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","‑Tɛ 'sɛyo nyre 'kɩ 'ʋ, ‑ɛ ‑bɩ ʋ ‑yɩyra nyibli nɩ 'hʋɛn ‑mʋ', ‑ʋ kɔ ‑Yusu 'hʋɛn‑, ʋ kɔɔ wɛn 'ʋ ti 'yie, 'waa bʋɩ lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","‑Tɛ ʋ 'yɩya 'ʋ ‑Yusu 'hʋɩ bʋ, ‑ɛ di꞊e nu, ʋ 'mʋ 'a bʋɩ ‑yra, ‑ɛ ‑bɩ ʋ 'ye꞊e nɩ, ‑ɛ mɔ, ɛ 'kʋ nɩ. 'A ‑tɩ, ʋ 'yɩ 'a bʋɩ ‑yra. ");
INSERT INTO ktj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kɛɛ ‑ɛ ‑bɩ, 'sɛyotayu ‑bɩ nu 'di, 'ɛ waa ‑Yusu a ꞊mʋɛyɛ ke yɩ. Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ ‑hlʋ kɔ 'nie 'hʋɛn‑, nʋ‑ ‑hɔn 'lɩ꞊ɩ 'hʋɩ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nyiblo, ‑ɛ 'ye ‑tɛblɩ a pɛpɛ a 'mʋ, nɔ‑ nɛ꞊ɛ ‑mɔ lɛ, 'tɩ‑ 'a ‑mɔlɛnawin mɔ ‑tɩ a ‑tɛɛ. Ɛ yru ti lɛ, ‑ɛ mɔ, ‑tɩ a ‑tɛɛ, ɛ nɛ ‑mɔ lɛ, ‑ɛ di꞊e nu, a 'mʋ꞊ʋ ꞊han‑tɩ pʋ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","‑Tɛ 'sɛyo nu ‑tɛblɩ a 'mʋ, 'kɩ 'ʋ ‑Yusu ‑mɔ, ‑ɛ ‑bɩ ‑tɩ ‑mʋ', ʋ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑tɩ a 'mʋ, ɛ mu kɛ 'lu ‑mɔ. ‑Tɩ a 'mʋ, ɛ nɔ‑ ‑bʋ: «Ʋ 'nɩ ‑yra꞊a lɩ 'a 'kla nɩ ‑do nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","'Kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ʋ 'crɩɩ la 'lɩ꞊ɩ nɩ de: «Nyiblo ‑bʋ, ʋ waa ke yɩ, ʋ di꞊e 'nɩ 'ye.» ");
INSERT INTO ktj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ɛ kɔ la ‑Yusu a ‑nagbopi* ꞊dʋ. 'A 'nyrɛ mɔ la Sosɛfʋ. 'Kɩ ɛ kɔ 'lɩ 'dɩɔ ‑kɔ 'nyrɛ ‑mɔ Alimate 'kwli. Kɛɛ, ɛ 'yɩ ‑hʋan nyiblo ꞊dʋ nɩ lee ‑nɩ, ‑ɛ mɔ, ɛ mɔ ‑Yusu a ‑nagbopi ꞊nɩɔ, ‑ɛ nu꞊o, ɛ yɩ pie ‑Juukʋɛ* a 'blʋ a nyibli a hʋannʋ. ‑Yusu bʋ 'kʋ 'kɩ, ‑ɛ ‑bɩ Sosɛfʋ a 'mʋ, ɛ nɔ‑ mu 'lɩ Pilatɩ ‑mɔ, 'ɛ ‑hʋa ‑hala, ɛ 'mʋ ‑Yusu a ‑plahʋɩ tugbɛ 'yie ‑ha, ɛ 'mʋ꞊ʋ 'ʋ ‑ha. ‑Ɛ ‑bɩ Pilatɩ wɛn nɩ. Pilatɩ bʋ wɛn 'kɩ, ‑ɛ ‑bɩ Sosɛfʋ mu nɩ, 'ʋ ‑ha 'ʋ ‑Yusu a ‑plahʋɩ tugbɛ 'yie. ");
INSERT INTO ktj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ti a 'mʋ 'yri, ‑ɛ ‑bɩ Nikodɛmʋ nyre 'ʋ nɩ. Nikodɛmʋ nɩ ‑do a 'mʋ, nɔ‑ mu la 'lɩ ‑Yusu ‑mɔ 'tɔ', ti ꞊dʋ ‑hi la a ti 'yri; 'ɛ ya hɩnhrʋnpʋ‑tɛblɩ, ‑ɛ ‑wɛ 'lɩ ‑bʋ 'wɛɛ ‑kilowɩ a (30) ‑wlʋ ꞊tu 'ʋ ‑pu nɩ. Hɩnhrʋnpʋ‑tɛblɩ a 'mʋ, 'waa 'nyrɛ mɔ milɩ kɔ alowɛsɩ. ");
INSERT INTO ktj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","‑Ɛ ‑bɩ nyibli nɩ 'hʋɛn a 'mʋ, ʋ 'du ‑Yusu a ‑plahʋɩ ye', 'ʋ nu hɩnhrʋnpʋ‑tɛblɩ a 'mʋ kɔ ‑jisɛ 'hʋɛn‑, 'ʋ 'hɩnhɩan ‑Yusu a ‑plahʋɩ lɛ, ꞊wɩ yɩ, ‑tɛ ‑Juukʋɛ ni 'waa 'kʋkʋkui a 'ʋ‑hɩhɩa. ");
INSERT INTO ktj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","‑Tɛ nɩ ‑do ‑mʋ', ʋ kɔɔ 'ʋ ‑Yusu tugbɛ 'yie, 'dʋdɔti a ‑ci ꞊dʋ nɩ 'ʋ. 'Kɩ 'lɩ ‑ci a 'mʋ 'kwli, 'kɩ 'hɩɔ gbagbʋ nɩ 'lɩ. 'Hɩɔ a 'mʋ, ɛ hlɔ yra, ‑wɛn dʋgba. Nɔ‑ ‑kɔ 'kwli, ʋ 'bluu la 'lɩ 'dabio, (ti ‑hi la a ti 'yri. ꞊Nɩ 'ye꞊e, ɛ 'wɩ‑ bʋtikayu yɩ.) 'Dabio a 'mʋ, ʋ 'yɩ ‑hʋan 'lɩ nyiblo ꞊dʋ nɩ pɩ. ");
INSERT INTO ktj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","‑Juukʋɛ a ‑wuwle‑nyrɔwɔ* gbagbʋ mi ‑wlu ꞊tu mɔ. Nɔ‑ kɔ ‑tɩ 'ʋ 'kɩka ‑nɩ, 'ʋ pʋ 'lɩ ‑Yusu a ‑plahʋɩ 'dabio a 'mʋ 'kwli, ‑ɛ nu꞊o, ɛ 'mʋɛ 'ʋ ‑tɩtɛ ‑mʋ', ‑Yusu 'kʋʋ 'ʋ yrɛ. ");
INSERT INTO ktj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","‑Juukʋɛ* a ‑wuwle‑nyrɔwɔ*, ‑ɛ mɔ 'sɛɛdɩ, bʋ ‑hi, 'a 'sɔɔndɩ a ‑nyragblɩ, halɔ 'tɩɛ nɩ ‑tʋtʋ kɩ lɛ, ‑ɛ ‑bɩ Mari, ‑ɛ kɔ 'lɩ Madala, ɛ kɔ 'a 'bio ‑bɩ 'hʋɛn‑, ʋ nʋ‑ ‑tuo 'lɩ 'dabio ‑mʋ' yɩ, ‑ɛ kɔ 'kwli ʋ pʋ 'lɩ ‑Yusu a ‑plahʋɩ. ‑Tɛ ʋ nyre 'ʋ, ‑ɛ ‑bɩ ʋ 'ye꞊e nɩ, ‑ɛ mɔ, 'dabio a ꞊ju, ‑ɛ mɔ 'hɩɔ, ʋ blike꞊e lɛ, 'ʋ ‑ha 'ʋ꞊ʋ 'dabio a 'mʋ wien. ");
INSERT INTO ktj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Bʋ 'ye 'kɩ꞊ɩ, ‑ɛ mɔ, 'hɩɔ a 'mʋ, ʋ blike꞊e lɛ, ‑ɛ ‑bɩ Mari 'gba ci lɛ, 'ɛ mu 'lɩ Simɔ Piɛlɩ kɔ ‑nagbopi* ‑bɩ 'mʋ, ‑Yusu nʋɛ ‑nɩ ‑mɔ, ɛ wɛn: «Ʋ ‑ha 'lɩ ‑aan Kʋkɔnyɔ ‑Yusu a ‑plahʋɩ 'dabio 'kwli nɩ, 'tɩ‑ ‑tɛ ʋ pʋ 'ʋ꞊ʋ bʋ, ‑a 'yɩ 'ʋ ‑yi.» ");
INSERT INTO ktj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kɩka, kɩka, ‑ɛ ‑bɩ Simɔ Piɛlɩ kɔ ‑nagbopi ‑bɩ ‑mʋ' 'hʋɛn‑, ʋ 'hrɩ nɩ, 'ʋ 'gba 'lɩ cigbɛ 'dabio yɩ. ");
INSERT INTO ktj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bʋ yɩ 'kɩ nɩ mi, ‑ɛ ‑bɩ ‑nagbopi ‑bɩ a 'mʋ, ɛ ‑hi Piɛlɩ lɛ, 'ɛ 'nyɛɛ 'hru, 'ɛ nyre 'lɩ 'dabio yɩ. ");
INSERT INTO ktj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","‑Ɛ ‑bɩ ɛ ꞊tɩ 'ʋ nɩ, 'ɛ ta 'lɩ 'dabio 'kwli lɛ, ‑jisɛ ‑mʋ', ‑ɛ pɛ 'ʋ bʋ, nɔ‑ ɛ 'ye, kɛɛ, ɛ 'yɩ 'lɩ 'dabio 'kwli ‑pa. ");
INSERT INTO ktj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","‑Tɛ Simɔ Piɛlɩ ‑mɔ ‑bɩ, ɛ nyre 'ʋ, ‑ɛ ‑bɩ ɛ pa 'lɩ 'dabio 'kwli nɩ, 'ɛ 'ye ‑jisɛ ‑mʋ', ʋ 'hɩnhɩan la ‑Yusu lɛ; ");
INSERT INTO ktj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","kɔ danʋ ‑mʋ', ʋ mʋa la꞊a 'lu lɛ. ‑Jisɛ kɔ danʋ a 'mʋ 'hʋɛn‑, ʋ pɛ 'dɔ bʋ. Ɛ 'wɩ yɩ, ‑tɛ ʋ nɩ la 'mʋ, 'ʋ 'hɩnhɩan la꞊a ‑Yusu lɛ, kɛ‑ nɩ ‑do ʋ nɩ 'mʋ, 'ʋ pɛ 'ʋ bʋ. ");
INSERT INTO ktj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","‑Ɛ ‑bɩ ‑nagbopi a 'mʋ, ‑ɛ 'nyɛɛ wɛn 'hru, ‑ɛ nyre wɛn 'lɩ, ɛ pa 'lɩ 'dabio 'kwli nɩ ‑wɛ, 'ɛ 'ye꞊e, ‑ɛ mɔ, ‑Yusu 'yɩ 'lɩ 'dabio 'kwli ‑nɩ. Ɛ nɔ‑ mɔ bʋ pʋ 'kɩ꞊ɩ ꞊haan‑tɩ, ‑ɛ mɔ, ‑Yusu ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ nɩ, 'ɛ 'hrɩ 'klɔ, ");
INSERT INTO ktj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","‑ɛ nu꞊o, kʋɛ la 'lɩ bʋ, ʋ 'yɛ la꞊a lɛ nɩ yrui, ‑tɛ Nyɩsʋa a winwlɔn‑hanyɔ* nu la 'a 'cɩcrɩɩ, 'kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ‑ɛ mɔ, ‑Yusu kɔ bʋ ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ, ɛ 'mʋ 'klɔ 'hrɩ. ");
INSERT INTO ktj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","‑Ɛ ‑bɩ ‑nagbopʋ nɩ 'hʋɛn a 'mʋ, ʋ ꞊hɩan ‑mɔ, 'ʋ mu 'lɩ Jrusrɛdɩɔ 'kwli de. ");
INSERT INTO ktj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","‑Ɛ ‑bɩ Mari ‑mɛ kle de, 'ɛ nɩ 'ʋ ‑Yusu a 'dabio wien bʋ, 'ɛ yɩ we, 'ɛ ꞊tɩ 'ʋ, 'ɛ ta 'lɩ 'dabio 'kwli lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Bʋ yɩ 'kɩ 'lɩ lɛ nɩ tɛ, ‑ɛ ‑bɩ ɛ 'ye 'lɩ Nyɩsʋa a lɛlenyʋ nɩ 'hʋɛn, 'ʋ pʋ ‑tɛblɩ pʋɔpʋɩ 'hʋɩ lɛ, 'ʋ nɩ 'ʋ ‑tɛ ‑mʋ', ʋ pɩa la 'ʋ ‑Yusu a 'hʋɩ bʋ, nyiblo nɩ ‑do 'kɩ 'ʋ ‑tɩtɛ ‑mʋ', ‑Yusu a 'lu ꞊gbɛɛ la 'lɩ, ‑do ‑bɩ 'kɩ 'lɩ ‑tɩtɛ ‑mʋ', 'a bʋɩ ꞊gbɛɛ la 'lɩ. ");
INSERT INTO ktj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","‑Ɛ ‑bɩ ʋ wɛn: «Nʋgba o, ɛ kla nɩ ‑ɛ kɔ ꞊hien ‑yɩ we 'lɩ?» ‑Ɛ ‑bɩ Mari wɛn: «Ʋ ‑ha 'nɛ‑ 'na Tɔɔnyɔ nɩ. Ɛ mɔ, ‑tɛ bʋ di 'ʋ꞊ʋ bʋ pʋ, 'n 'yɩ 'ʋ ‑yi.» ");
INSERT INTO ktj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ɛ nɩ 'lɩ 'a hɩhla 'kwli, ‑ɛ ‑bɩ ɛ ꞊hɩan ‑mɔ. ‑Tɛ ɛ ꞊hɩan 'kɩ ‑mɔ, ‑ɛ ‑bɩ ɛ 'ye ‑Yusu nɩ, kɛɛ, ɛ 'nɩ ‑yruo꞊o lɩ꞊ɩ lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","‑Yusu yɩ꞊ɩ 'nɩ 'bɛti ‑nɩ, ɛ wɛn: «Nʋgba o, dɛ‑ kɔ ꞊hien ‑yɩ we 'lɩ? Nyiblo a 'dɩ ‑bɩ ꞊mʋɛ lɛ 'lɩ?» Mari ‑mɔ ‑bɩ, ‑tɛ ɛ 'ye ‑Yusu, 'kɩ 'lɩ 'a ꞊wlʋ kɩ, ɛ wɛn 'nɩ, 'dʋdɔ‑tɛblɩ a ‑ci ‑mʋ', nɔ‑ kɔ 'yie꞊tunyɔ ꞊nɩɔ. 'A ‑tɩ, ɛ wɛn: «Nyɩbɛyu o, 'bʋ mɔ ‑mɔ, ꞊nɩ gba꞊a, lee 'mʋ, ‑tɛ ‑pʋ 'ʋ꞊ʋ bʋ, ‑ɛ di꞊e nu, 'mʋ꞊ʋ bla.» ");
INSERT INTO ktj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Kɛɛ, ‑Yusu da꞊a nɩ, ɛ wɛn: «Mari.» ‑Ɛ ‑bɩ Mari ꞊hɩan ‑mɔ, ɛ wɛn: «Rabuni,» ‑ɛ ꞊hɛn 'nyrɛ Tɔɔnyɔ, 'kɩ 'lɩ ‑Juukʋɛwin 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","‑Yusu wɛn: «꞊Nɩ 'kaa 'lɩ 'mʋ yɩ, ‑ɛ nu꞊o, 'n 'yɛɛ 'lɩ 'na 'Baɩ ‑mɔ nɩ mi, 'kɩ 'lɩ yakɔ 'kwli. Kɛɛ, mu 'lɩ ‑na 'dɩayɩnʋ ‑mɔ, ‑ʋ mɔ 'na ‑nagbopʋ*, ‑bʋ lee ꞊nʋ, ‑ɛ mɔ, 'kɩ 'n mi 'lɩ 'na 'Baɩ ‑mɔ, ‑ɛ mɔ 'aan 'Baɩ ‑wɛ, 'kɩ 'lɩ 'na Nyɩsʋa ‑mɔ, ‑ɛ mɔ 'aan Nyɩsʋa ‑wɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","‑Ɛ ‑bɩ Mari mu ‑nagbopʋ a 'mʋ lee mɔ, ‑ɛ mɔ, ɛ 'ye Tɔɔnyɔ nɩ. Ɛ nɔ‑ lee ꞊nɛ ‑tɛblɩ a pɛpɛ ‑mʋ', ɛ yɩ ꞊nʋ ‑lee ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","‑Nyrɔwɔ nɩ ‑do a 'mʋ, ‑ɛ mɔ 'sɔɔndɩ a ‑winse, ‑Yusu a ‑nagbopʋ* 'kukue lɛ, 'kɩ 'lɩ 'kayu ‑bɩ bʋ. ‑Tɛ ʋ yɩ la ‑Juukʋɛ* a 'blʋ a nyibli a hʋannʋ pie, 'a ‑tɩ, ʋ ꞊gba 'maji a pɛpɛ nɩ. 'Kɩ ʋ nɩ kɩ 'ʋ bʋ, ‑ɛ ‑bɩ ti nɩ ‑do a ti 'yri, ‑Yusu 'hrɩɩ 'lɩ ꞊nʋ 'nyɩ nɩ, ɛ wɛn: «Ba kɔ plɔ a bleelɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ɛ tɔɔ ꞊nʋ 'a dabʋɩ a 'kwli kɔ 'a ꞊mʋɛyɛ 'hʋɛn‑ yɩ. ‑Nagbopʋ a 'mʋ, bʋ 'ye 'kɩ Kʋkɔnyɔ ‑Yusu, ‑ɛ ‑bɩ ʋ ni dɔdʋ. ");
INSERT INTO ktj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","‑Ɛ ‑bɩ ɛ wɛn 'nɩ de: «Ba kɔ plɔ a bleelɛ. ‑Tɛ 'na 'Baɩ ‑nu, 'ɛ lee 'nɛ‑ 'mʋ 'klɔ ‑bʋ kɩ, 'mʋ 'a ‑tɩ hla, 'na 'mumu, 'n yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ba na 'klɔ kɩ, ba hla 'na ‑tɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","‑Tɛ ɛ ‑hi 'kɩ, ‑ɛ ‑bɩ ɛ 'wlaa ꞊nʋ pepe 'lu, ɛ wɛn: «Nyɩsʋa a ‑Hihiu* bʋ nɩ 'ʋ 'a mʋ ke'. ");
INSERT INTO ktj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nyiblo 'bʋ nɩ 'ʋ, 'ba lee ꞊nɛ, 'kɩ 'lɩ Nyɩsʋa a ‑Hihiu a 'klɩ 'kwli, ‑ɛ mɔ: ‑Na ‑tɛblɩ 'kukui 'wʋwlɛ nɩ, ɛ mɔ ꞊han‑tɩ, 'a ‑tɛblɩ 'kukui 'wʋwlɛ nɩ pɛpɛ. Kɛɛ, nyiblo 'bʋ nɩ 'ʋ, 'ba 'yɩ꞊ɩ ‑lee ‑nɩ, ‑ɛ mɔ: ‑Na ‑tɛblɩ 'kukui 'wʋwlɛ nɩ, ɛ mɔ ꞊han‑tɩ, 'a ‑tɛblɩ 'kukui 'yɩ 'wʋwlɛ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","‑Tɛ ‑Yusu 'hrɩɩ ꞊nʋ yɩ, Toma, ‑ɛ mɔ ‑Yusu a ‑nagbopi* ‑mʋ', ʋ dɛɛ ꞊Yrupʋyu, nɔ‑ 'yɩ 'lɩ 'a 'bio 'nyɩ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","‑Tɛ 'a 'bio 'ye 'kɩ꞊ɩ, ‑ɛ ‑bɩ kɛ‑ ʋ pɩ꞊ɩ yɩ: «Toma o, ‑a 'ye Kʋkɔnyɔ nɩ.» ‑Ɛ ‑bɩ Toma wɛn: «'Nɩ 'yɩ ŋmaŋmɔɔ ‑mʋ', ʋ kɔɔ 'lɩ꞊ɩ ꞊jɩ' a ꞊pɩ 'ye, 'na ‑jie 'bʋ 'yɩ꞊ɩ lɛ ‑hrɛn, kɔ, 'nɩ 'yɩ 'lɩ 'na dabʋ 'a ꞊mʋɛyɛ, ʋ wa kɩ yɩ, 'a 'hʋɔ 'kwli 'nyra, 'n 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ ꞊bʋ pʋ꞊ʋ ꞊han‑tɩ ‑pi, ‑ɛ mɔ, Kʋkɔnyɔ 'hrɩ 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","'Wee nɩ ‑do bʋ ‑hi, ‑ɛ ‑bɩ ‑Yusu a ‑nagbopʋ 'kukue lɛ de. 'Kɩ Toma nɩ 'kɩ 'lɩ ꞊nʋ 'nyɩ. ‑Ɛ ‑bɩ ʋ ꞊gba 'kayu, ʋ nɩ 'lɩ bʋ, 'a 'maji a pɛpɛ nɩ de. Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ ‑Yusu 'hrɩɩ 'lɩ ꞊nʋ 'nyɩ nɩ de, ɛ wɛn: «Ba kɔ plɔ a bleelɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","‑Ɛ ‑bɩ ɛ wɛn: «Toma, 'yɩya 'nɛ‑ ‑na ‑jie bʋ, kɔ, 'ye 'na dabʋɩ a 'kwli, 'yɩya 'nɛ‑ ‑na dabʋ bʋ, ‑bʋ 'nyra 'lɩ ‑na ‑jiomɩ 'na ꞊mʋɛyɛ, ʋ wa kɩ yɩ, 'a 'hʋɔ 'kwli. 'N 'hrɩ 'klɔ nɩ, ꞊nɩ 'pʋʋ 'kɩ꞊ɩ gblɛ de, kɛɛ, pʋ꞊ʋ ꞊han‑tɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","‑Ɛ ‑bɩ Toma wɛn: «'Na Kʋkɔnyɔ, kɔ 'na Nyɩsʋa.» ‑Ɛ ‑bɩ ‑Yusu wɛn: ");
INSERT INTO ktj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","«꞊Bɩ ‑tɛ ꞊ye 'mʋ, nɔ‑ kɔ ‑tɩ, ꞊nɩ pɩ꞊ɩ ꞊han‑tɩ, ‑ɛ mɔ, 'n 'hrɩ 'klɔ. Dɔdʋ 'kɩ 'ʋ nyiblo ‑mʋ' ‑mɔ, ‑ɛ 'yɩ 'mʋ 'ye, 'tɩ‑ ‑ɛ pʋ꞊ʋ ꞊han‑tɩ, ‑ɛ mɔ, 'n 'hrɩ 'klɔ, 'tɩ‑ ‑ɛ kuo 'mʋ ꞊wlʋ yɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","‑Yusu nu ꞊wlɩlɛkɛɛ‑tɛblɩ ‑bɩ, 'kɩ 'ʋ 'a ‑nagbopʋ* ye'. ‑Tɛblɩ a 'mʋ, ɛ 'yɩ 'crɩɩ ‑nɩ, 'kɩ 'nɛ‑ 'crɩɛn ‑bʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kɛɛ, 'a dɛ ‑bʋ, ‑ɛ 'crɩɩ ‑nɩ, ɛ 'crɩɩ nɩ, ‑ɛ di꞊e nu, a 'mʋ꞊ʋ ꞊wlʋ yɩ kuo ‑nɩ, ‑ɛ mɔ, ‑Yusu, nɔ‑ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la ya, ɛ 'mʋ la 'a dakɔ wa, kɔ, 'ɛ mɔ Nyɩsʋa a 'Yu. 'Bʋ mɔ, 'ba pʋ Wanyɔ a 'mʋ, 'a ‑tɩ ꞊han‑tɩ, 'ba kuo ꞊nɛ ꞊wlʋ yɩ, kɔ, 'ba yɩ꞊ɩ ꞊wien nɩ kʋɛ, ɛ di ‑nyi 'a mʋ 'klɔ yrayrʋ. ");
INSERT INTO ktj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","2","‑Tɛ ‑tɛblɩ a pɛpɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu 'hrɩɩ nɛ 'a ‑nagbopʋ yɩ de, 'kɩ 'lɩ Galileblʋgba a 'yru wien. ‑Yusu a ‑nagbopʋ ‑mʋ', ‑Yusu 'hrɩɩ la yɩ, 'waa 'nyrɛ, nɔ‑ ‑bʋ: Simɔ Piɛlɩ, kɔ Toma, ʋ dɛɛ ꞊Yrupʋyu, kɔ Natanaɛlɩ, ‑ɛ kɔ 'lɩ Kana, 'kɩ 'lɩ Galileblʋgba 'kwli, kɔ Sebede a 'yonʋ nɩ 'hʋɛn, kɔ ‑nagbopʋ nɩ 'hʋɛn ‑bɩ. Nyibli a 'mʋ, nʋ‑ ‑Yusu 'hrɩɩ yɩ. ‑Tɛ ɛ nu 'waa yɩ'hrɩɩlɛ, ɛ nɔ‑ ‑bʋ: ");
INSERT INTO ktj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","‑Nyrɔwɔ ꞊dʋ, Simɔ Piɛlɩ wɛn: «‑A 'bio ‑na o, 'n mi 'pa mɔ.» ‑Ɛ ‑bɩ ʋ wɛn: «‑Kɔ ‑a mʋ 'hʋɛn‑ ‑mi.» ‑Ɛ ‑bɩ ʋ 'du ye', 'ʋ mu 'lɩ 'yru wien. 'Kɩ ʋ 'ya 'lɩ 'blagbɩ 'kwli, 'ʋ mu 'pa mɔ. Kɛɛ, ʋ 'yɩ ꞊dedede 'pa, 'tɔlʋwɔ a pɛpɛ a 'mʋ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","‑Nyrɛ bʋ ‑nyɛ 'kɩ lɛ, ‑ɛ ‑bɩ ʋ 'ye ‑Yusu nɩ, 'kɩ 'ʋ 'yru a 'mʋ wien, kɛɛ, ʋ 'yɩ꞊ɩ ‑yru. ");
INSERT INTO ktj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","‑Ɛ ‑bɩ ɛ wɛn: «'Yonʋ ‑na, ꞊bɩ a 'pa dɛ?» ‑Ɛ ‑bɩ ʋ wɛn: «'Klɔ a 'klɔ, ‑a 'yɩ dɛ 'ye.» ");
INSERT INTO ktj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","‑Ɛ ‑bɩ ɛ wɛn: «Ba pʋ 'aan ‑tɩta, 'kɩ 'lɩ 'blagbɩ a diidɛkɩbɩa kɩ. A di 'ye dɛ,» 'ʋ pʋ꞊ʋ, 'kɩ 'lɩ 'blagbɩ a diidɛkɩbɩa kɩ. Bʋ pʋ 'kɩ꞊ɩ, ‑ɛ ‑bɩ ɛ pʋ 'lɩ ‑hrin ‑hʋɔhʋɩ. 'A ‑tɩ, ʋ 'yɩ 'lɩ 'a 'nie‑hɩhɩa 'lɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","‑Ɛ ‑bɩ ‑nagbopi a 'mʋ, ‑Yusu ‑nʋɛ ‑nɩ ‑tɛɛ, bʋ 'ye 'kɩ ꞊wlɩlɛkɛɛdɛ a 'mʋ, ‑ɛ ‑bɩ ɛ wɛn: «Simɔ Piɛlɩ, ‑aan Tɔɔnyɔ ꞊nɩɔ.» Ti nɩ ‑do a ti 'yri, ‑tɛ Simɔ Piɛlɩ 'wɩn, ‑ɛ mɔ, 'waa Tɔɔnyɔ ꞊nɩɔ, ‑ɛ ‑bɩ ɛ pʋ 'a wlawlʋ nɩ, 'ɛ mʋa꞊a bʋ, ‑ɛ nu꞊o, ɛ ꞊ga wɛn 'hʋɩ wlɔn, 'tɩ‑ 'ɛ bi 'nie, 'ɛ mu 'lɩ ‑Yusu 'hʋɩ. ");
INSERT INTO ktj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","‑Nagbopʋ ‑bɩ ‑mʋ', 'blagbɩ, nɔ‑ ʋ gbɛ, 'ʋ mi 'lɩ ‑Yusu 'hʋɩ ‑wɛ. Ʋ yɩ nɩ mi, ʋ yɩ 'waa ‑tatɩ 'nie ‑mɔ lɛ nɩ ‑jri, ‑hrin a kʋanɩ‑tɩ. Ʋ 'yɩ 'gbahlɔn ‑mɔ lɛ ‑hlɔɔ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","‑Tɛ ʋ ‑kwlɛ 'kɩ, ʋ ꞊tɩ, ‑ɛ ‑bɩ ʋ 'yee 'ʋ na ‑Yusu 'hʋɩ, ‑ɛ yɩ wlɩn, ‑hrin pɛ 'ʋ 'lu bʋ, kɔ 'flɔɔ, 'ɛ pɛ 'ʋ꞊ʋ 'kɩbɩa ‑mɔ bʋ. ");
INSERT INTO ktj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","‑Ɛ ‑bɩ ɛ wɛn: «‑Hrin 'aan ‑tatɩ pʋ 'lɩ, ba ya 'lɩ 'a dɛ,» ");
INSERT INTO ktj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simɔ Piɛlɩ, 'ɛ ‑mu, 'ɛ 'ya 'lɩ 'blagbɩ 'kwli, 'ɛ ‑jri 'lɩ ‑tɩta, 'ɛ pʋ 'ʋ꞊ʋ 'gbahlɔn bʋ, 'ɛ ‑ha 'lɩ꞊ɩ ‑hrin gbagbɩ a (153) ꞊wlɩ nɩ ꞊hlon'hʋɛn ꞊tu 'ʋ ‑pu ꞊tu 'ʋ ta 'kwli. ꞊Haan‑tɩ, ‑hrin a 'mʋ, 'ʋ ‑hʋ, kɛɛ ‑tɩta 'yɩ lɛ ‑cɩcrɛ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","‑Ɛ ‑bɩ ‑Yusu wɛn: «Ba di 'lɩ, a 'mʋ dɛ di.» 'A ‑nagbopi ꞊dʋ 'yɩ꞊ɩ 'bɛti ‑nɩ, ‑tʋɩ a ‑tɩ, ‑ɛ mɔ: «Nyiblo a 'dɩ ‑bɩ ‑mɔ 'lɩ?» ‑ɛ nu꞊o, ʋ yi꞊e nɩ, ‑ɛ mɔ, Kʋkɔnyɔ ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","‑Ɛ ‑bɩ ‑Yusu 'yɩya 'ʋ ꞊nʋ 'hʋɩ bʋ, 'ɛ ‑nyi ꞊nʋ 'flɔɔ kɔ ‑hrin ‑nɩ wɛn. ");
INSERT INTO ktj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","‑Tɛ ɛ ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ, 'a 'wɩ nɩ ta a yɩ'hrɩɩlɛ ɛ 'hrɩɩ ꞊nʋ yɩ. ");
INSERT INTO ktj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","‑Tɛ ʋ ‑wɛ dɛ lɛ, ‑ɛ ‑bɩ ‑Yusu ‑tʋa 'lɩ Simɔ Piɛlɩ a ‑mɔ'pʋplɛ, ɛ wɛn: «Simɔ, Saan a 'yu, ꞊bɩ ‑nʋɛ 'mʋ nɩ, 'ɛ ‑hi 'ʋ nyibli ‑bɩ ‑bʋ 'ʋ?» ‑Ɛ ‑bɩ Piɛlɩ wɛn: «Iin, Kʋkɔnyɔ, ‑yi꞊e nɩ, ‑ɛ mɔ, 'n nʋɛ ‑mʋ nɩ.» ‑Ɛ ‑bɩ ‑Yusu wɛn: «Naa 'na ‑nagbopʋ*, ‑tɛ blablɩkɔnyɔ ni 'a blablɩ a naalɛ.» ");
INSERT INTO ktj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","‑Ɛ ‑bɩ ‑Yusu 'bɛti꞊e nɩ de, ɛ wɛn: «Simɔ, Saan a 'yu, ꞊bɩ ‑nʋɛ 'mʋ nɩ?» ‑Ɛ ‑bɩ Piɛlɩ wɛn: «Iin, Kʋkɔnyɔ o, ‑yi꞊e nɩ, ‑ɛ mɔ, 'n nʋɛ ‑mʋ nɩ.» ‑Ɛ ‑bɩ ‑Yusu wɛn: «Naa 'na ‑nagbopʋ.» ");
INSERT INTO ktj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","‑Ɛ ‑bɩ ‑Yusu 'bɛti꞊e nɩ de, ɛ wɛn: «Simɔ, Saan a 'yu, ꞊bɩ ‑nʋɛ 'mʋ nɩ?» ‑Tɛ ‑Yusu 'bɛti 'kɩ꞊ɩ 'wɩ nɩ ta a dɛ, ‑ɛ ‑bɩ Piɛlɩ a ꞊wlʋ 'mʋɛ bʋ, ɛ wɛn: «Kʋkɔnyɔ o, ‑yi 'a ‑nɛ dɛ nɩ. ‑Yi꞊e nɩ, ‑ɛ mɔ, 'n nʋɛ ‑mʋ nɩ.» ‑Ɛ ‑bɩ ‑Yusu wɛn: «Naa 'na ‑nagbopʋ. ");
INSERT INTO ktj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","'N yɩ ‑mʋ 'nɩ ‑lee ‑nɩ ‑tɛɛ, ‑ɛ mɔ, ti ‑mʋ' ‑kɔ 'yri ‑mɔ la gblotayu, ‑tɛ ‑mʋ', ‑na ꞊wlʋ 'yee la 'lɩ, 'kɩ ‑mi la 'lɩ, kɛɛ, ꞊nɩ ‑wɛ ‑hʋan 'yi, ‑di ꞊gblɛ ‑hʋan dabʋɩ lɛ, nyiblo ‑bɩ 'mʋ ‑hʋan 'lɩ ‑mʋ ‑tɛ ‑bɩ gba, ‑tɛ ‑na ꞊wlʋ 'yɩ 'lɩ ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ɛ ꞊hɛn 'nyrɛ, ꞊hɩʋɛn'kʋkʋʋdʋ ‑mʋ', Piɛlɩ di 'kʋ, ‑ɛ di Nyɩsʋa ‑tɩ a 'yi'bʋalɛ ‑nyi, nɔ‑ ‑Yusu tʋɛ ꞊nɛ, 'ɛ ni 'pʋplɛ lɛ. Bʋ pʋ 'kɩ lɛ, ‑ɛ ‑bɩ ʋ 'du ye'. Bʋ 'du 'kɩ ye', ‑ɛ ‑bɩ ‑Yusu lee Piɛlɩ nɩ, ɛ wɛn: «Piɛlɩ, kʋɛ 'mʋ ꞊wien.» ");
INSERT INTO ktj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","‑Ɛ ‑bɩ Piɛlɩ ꞊hɩan ‑mɔ. Bʋ ꞊hɩan 'kɩ ‑mɔ, ‑ɛ ‑bɩ ɛ 'ye ‑nagbopi a 'mʋ, ‑Yusu nʋɛ ‑nɩ ‑tɛɛ nɩ, 'ɛ kʋɛ ꞊nʋ ꞊wien ‑wɛ. ‑Tɛ ‑Yusu kɔ 'a ‑nagbopʋ 'hʋɛn‑, ʋ yɩ la 'waa lɛ'bɔɔdiidɛ nɩ di, ‑tɛ ɛ 'yɛɛ la nɩ 'kʋɩ, ‑nagbopi nɩ ‑do a 'mʋ, nɔ‑ 'ma la 'ʋ 'a 'lu ‑Yusu ‑wliye bʋ, 'ɛ 'bɛti la꞊a, ɛ wɛn: «Kʋkɔnyɔ, nyiblo a 'dɩ ‑bɩ, ‑ɛ di ‑mʋ ‑na yraanyibli ‑jɩ' pʋ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","‑Tɛ Piɛlɩ 'ye 'kɩ ‑nagbopi a 'mʋ, ‑ɛ ‑bɩ ɛ 'bɛti ‑Yusu nɩ, ɛ wɛn: «Kʋkɔnyɔ, ‑ɛ ‑bɩ ‑bʋ, dɛ a 'dɩ ‑bɩ ‑di ‑hʋan꞊a nu 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","‑Ɛ ‑bɩ ‑Yusu wɛn: «'Bʋ mɔ, 'nɩ yɩ꞊ɩ nɩ ‑hʋɛ, bʋ hie 'klɔ, ꞊bʋ ya 'lɩ yakɔ 'kwli, ꞊bʋ ꞊hɩan ‑mɔ, ꞊bʋ yɛɛ 'nɛ꞊ɛ bʋ, ꞊bɩ ‑kɔ 'lɩ꞊ɩ ‑mɔ? ‑Mɔ ‑bɩ, kʋɛ 'mʋ ꞊wien.» ");
INSERT INTO ktj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","‑Tɩ a 'mʋ, ‑Yusu ‑hla, ɛ nu꞊o nɩ, Nyɩsʋa a nyibli 'ʋ pɩ lɛ, ‑ɛ mɔ, ‑nagbopi a 'mʋ, ɛ 'nɩ 'kʋ꞊ʋ nɩ. Kɛɛ, sɛyɩ‑sɛyɩ, ‑Yusu 'yɩ lɛ ‑pʋ, ‑ɛ mɔ, ɛ 'nɩ 'kʋ꞊ʋ nɩ. Kɛɛ, ɛ wɛn 'nɩ: «'Bʋ mɔ, ꞊nɩ yɩ꞊ɩ nɩ ‑hʋɛ, bʋ hie 'klɔ, ꞊bʋ ya 'lɩ yakɔ 'kwli, ꞊bʋ ꞊hɩan ‑mɔ, ꞊bʋ yɛɛ 'nɛ꞊ɛ bʋ, ꞊bɩ ‑kɔ 'lɩ꞊ɩ ‑mɔ?» ");
INSERT INTO ktj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","‑Nagbopi nɩ ‑do a 'mʋ, ‑kɔtɩ ‑Yusu 'ɛ pʋ lɛ, ɛ nɔ‑ nɛ ‑tɛblɩ a pɛpɛ ‑bʋ ‑mɔ lɛ. Ɛ yi꞊e nɩ, ‑ɛ nu꞊o, ɛ nɩ la ‑tuo kɩ, 'ɛ pʋ 'nɛ꞊ɛ 'crɩɛn ‑bʋ 'kwli. 'A ‑nɛ nyiblo 'kɩ 'nɛ‑ ‑a mʋ 'nyɩ, ɛ yi꞊e nɩ, ‑ɛ mɔ, ‑tɩ a ‑tɛɛ, ɛ nɛ ‑mɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","‑Yusu nu ‑tɛblɩ ‑hʋɔhʋɩ ‑bɩ. 'Bʋ nu, ꞊ba ‑kɔ ‑ba 'crɩ wɛn 'a pɛpɛ, 'n pʋ꞊ʋ ꞊haan‑tɩ, ‑ɛ mɔ, 'a 'crɩɩn 'nɩ ‑wɛɛn꞊ɛ wɛn 'nɛ‑ 'klɔ ‑bʋ kɩ nɩ.");
INSERT INTO ktj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","‑Na 'wio Teofilɩ. 'Kɩ 'lɩ 'na yɩ‑hɛcrɩɛn 'kwli, 'n lee ‑mʋ ‑tɛblɩ a pɛpɛ ‑mʋ', ‑Yusu 'Klɩsʋ ni la nɩ, kɔ, ‑tɛ ɛ ni la nyibli a tɔɔlɛ, kʋɛ la 'lɩ bʋ, ");
INSERT INTO ktj_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","‑bʋ mu ‑mumu, ‑bʋ yɛ ‑nyrɔwɔ ‑mʋ' kɩ, ‑ɛ kɔ 'kwli Nyɩsʋa nu la꞊a, ‑Yusu a 'mʋ 'ɛ mu la 'lɩ yakɔ 'kwli. 'Tɩ‑ ɛ 'mʋ la mu, nyibli ‑mʋ', ɛ ‑ha la 'lɩ, 'kɩ bʋ ‑hɛ la 'a ‑mɔnanyʋ, 'ɛ lee la ꞊nʋ lɛ'bɔɔwin, 'kɩ 'lɩ Nyɩsʋa a ‑Hihiu* a 'klɩ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","‑Tɛ ɛ 'kʋ, 'tɩ‑ ɛ 'hrɩ 'klɔ, 'kɩ 'lɩ ‑nyrɔwɩ a ‑wlɩ nɩ 'hʋɛn 'kwli, 'kɩ ɛ 'hrɩɩ ꞊nʋ yrɛ, 'ɛ tɔɔ ꞊nʋ꞊ʋ, ‑ɛ mɔ, ɛ 'hrɩ 'klɔ, 'tɩ‑ ‑tɛ Nyɩsʋa ni nyibli a win a kɩkɔɔlɛ, ɛ nɔ‑ kɔ ‑tɩ ɛ tɔɔ ꞊nʋ. ");
INSERT INTO ktj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","‑Nyrɔwɔ ꞊dʋ 'kwli, ‑tɛ ‑Yusu nɩ la 'lɩ 'a ‑mɔnanyʋ 'nyɩ de, ‑ɛ ‑bɩ ɛ yɩ la ꞊nʋ 'nɩ ti, kɛ‑ ɛ pɩ la: «A 'nɩ 'hlɔɔ 'lɩ 'dɩɔ ‑bʋ, ‑ɛ mɔ Jrusrɛ ‑mɔ lɛ, kɛɛ, ba ‑ple Nyɩsʋa a ‑Hihiu, Nyɩsʋa a 'mʋ, ɛ pʋ lɛ, ɛ di 'a mʋ ‑nyi, ꞊wɩ yɩ, ‑tɛ 'n nu la 'aan leelɛ. ");
INSERT INTO ktj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Saan ‑mɔ ‑bɩ, 'nie, ɛ nɔ‑ ɛ pʋ 'a mʋ 'lu lɛ, kɛɛ, 'kɩ 'lɩ ‑nyrɔwɩ gbi 'kwli, Nyɩsʋa di ‑nyi 'a mʋ 'a ‑Hihiu.» ");
INSERT INTO ktj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nyibli ‑mʋ', ‑ʋ ꞊gbee 'ʋ ‑Yusu 'hʋɩ, ʋ ‑tʋa 'a lɛ'bɛtilɛ, ʋ wɛn: «Kʋkɔnyɔ o, ‑a mʋ Yisraɛkʋɛ, ꞊bɩ ti ‑bʋ 'yri, 'kɩ ‑di 'lɩ ‑a mʋ Romakʋɛ a 'klɩ bʋ ‑ha, ‑ɛ di꞊e nu, ‑a mʋ nɩ ‑do, ‑a 'mʋ ‑aan 'blʋgba ‑naa ‑nɩ?» ");
INSERT INTO ktj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","‑Ɛ ‑bɩ ‑Yusu ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «Ti ‑mʋ', ‑ɛ kɔ 'yri ‑tɛblɩ a 'mʋ, ɛ di 'lu ‑mɔ mu, a 'yɩ yɩ ‑blɛɛ ‑nɩ, ba yi꞊e, ‑ɛ nu꞊o, ‑aan 'Baɩ Nyɩsʋa, nɔ‑ wa ti a 'mʋ 'nyrɛ, ‑tɛ ɛ nu 'a ‑hʋhʋa. ");
INSERT INTO ktj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ti ‑mʋ' ‑kɔ 'yri Nyɩsʋa a ‑Hihiu* di 'ʋ 'a mʋ ke' bi, a di kɔ 'klɩ, 'kɩ ba lee nyibli ‑tɛblɩ a pɛpɛ ‑mʋ', a 'ye 'kɩ 'ʋ 'na ‑ta'. Ba na 'na ‑tɩ ‑mɔ lɛ, 'kɩ 'nɛ‑ Jrusrɛdɩɔ 'kwli, ba mu 'lɩ Sudeblʋgba kɔ Samaliblʋgba a pɛpɛ kɩ ‑wɛ, ba bi 'klɔ a pɛpɛ kɩ, ba na 'na ‑tɩ ‑mɔ lɛ.» ");
INSERT INTO ktj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","‑Tɛ ɛ ‑yrɛ 'kɩ, ‑ɛ ‑bɩ ɛ ‑tʋa 'lɩ yakɔ a 'kwlimumuo. 'A ‑mɔnanyʋ* yɩ 'ʋ꞊ʋ ‑mɔ lɛ nɩ tɛ, 'nuŋma 'ɛ ‑hli ꞊nʋ꞊ʋ 'yi kɩ, 'ʋ 'kee 'a 'yiye. ");
INSERT INTO ktj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ʋ nɩ 'lɩ yɔ' a lɛtɩta 'kwli, ti nɩ ‑do a ti 'yri, nyibli nɩ 'hʋɛn, ‑ʋ pʋ ‑tɛblɩ pʋɔpʋɩ 'hʋɩ lɛ, ʋ 'hrɩɩ 'ʋ ꞊nʋ 'hʋɩ. Nyibli a 'mʋ, ʋ mɔ Nyɩsʋa a lɛlenyʋ ꞊nɩɔ. ");
INSERT INTO ktj_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Kɛ‑ ʋ pɩ ꞊nʋ yɩ: «Galilekʋɛ, dɛ‑ kɔ ‑tɩ 'a nyra mɔ bʋ, 'a tɛ 'lɩ yɔ' lɛ 'lɩ? ‑Yusu mu 'lɩ yakɔ 'kwli. ‑Tɛ a nu 'a 'yiye, ɛ nu mumuo, kɛ‑ ɛ di didie nu.» ");
INSERT INTO ktj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, ‑ɛ ‑bɩ ‑Yusu a ‑mɔnanyʋ* a 'mʋ, ʋ ꞊tɩ 'lɩ dʋgba ‑mʋ', ‑ɛ mɔ olifieti a dʋgba 'lu nɩ, 'ʋ mu 'lɩ Jrusrɛdɩɔ 'kwli. ‑Hɔn 'lɩ Jrusrɛdɩɔ 'kwli, ‑bʋ mu 'lɩ dʋgba a 'mʋ 'lu, ɛ ‑wɛ 'lɩ ‑kiloyɛ nɩ ‑do nɩ. ");
INSERT INTO ktj_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","‑Tɛ ʋ nyre 'lɩ, ‑ɛ ‑bɩ ʋ 'ya 'lɩ yɔ'kayu yra, 'ʋ mu 'lɩ ‑gblo ‑mʋ', ‑ɛ kɔ 'kwli ʋ yɩ la 'lɩ lɛ 'kukue ‑nɩ. Nyibli ‑nɩ ‑tuo a 'mʋ kɩ, 'waa 'nyrɛ nɔ‑ ‑bʋ: Piɛlɩ, Saan, Sakɩ, Adre, Filipʋ, Toma, Batelemi, Matie, Alʋfe a 'yu Sakɩ, Simɔ, ‑ɛ nɩ la 'lɩ nyibli ‑mʋ', ‑ʋ 'yɛ nɩ ‑hʋa la Romakʋɛ 'nyɩ, kɔ Sakɩ a 'yu Judɩ. ");
INSERT INTO ktj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nʋgbɩ nɩ 'lɩ ꞊nʋ 'nyɩ lɛ ‑wɛ, ʋ kɔ Mari, ‑ɛ mɔ ‑Yusu a 'dii, kɔ ‑Yusu a 'dɩayɩ nyɩbɛpʋ 'hʋɛn‑. 'Waa pɛpɛ a 'mʋ, ʋ nʋ‑ yɩ 'lɩ ‑gblo a 'mʋ 'kwli lɛ 'kukue ‑nɩ, 'ʋ dɛ Nyɩsʋa. ");
INSERT INTO ktj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","‑Nyrɔwɔ ꞊dʋ 'kwli, nyibli a ‑wlɩ nɩ ꞊hlon‑do, nʋ‑ 'kukue lɛ de, 'kɩ 'ʋ Nyɩsʋa a dɩda ‑mɔ. Bʋ nɩ 'kɩ 'ʋ bʋ, ‑ɛ ‑bɩ Piɛlɩ 'du ye', ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«'Dɩayɩnʋ ‑na, ‑tɩ ‑mʋ', ʋ 'crɩɩ la 'lɩ Nyɩsʋacrɩɛn 'kwli, ('kɩ 'ʋ Judɩa a ‑ta',) ɛ kɔ bʋ mu 'lu ‑mɔ. 'Ɛ mɔ ꞊han‑tɩ, Nyɩsʋa a ‑Hihiu* 'ɛ naa la 'lɩ bodɩɔ Dafidɩ 'mʋ, 'ɛ 'crɩ la꞊a, ‑ɛ mɔ, Judɩa, nɔ‑ di la ‑Yusu 'a yraanyibli yɩ gba, 'kɩ 'ʋ 'a kʋklɔ a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","‑Tɛ ‑Yusu ‑nu, 'ɛ ‑ha 'lɩ ‑a mʋ, 'kɩ ‑ba nu Nyɩsʋa a ‑kʋan, kɛ‑ ɛ ‑nu, 'ɛ ‑ha 'lɩ Judɩa, 'kɩ bʋ nu Nyɩsʋa a ‑kʋan. ");
INSERT INTO ktj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","‑Tɛ Judɩa a 'mʋ, ɛ pʋ ‑Yusu 'crɛkɔnyibli ‑jɩ', 'wliyɛ ‑mʋ', ʋ 'pɛɛ la꞊a, ɛ nɔ‑ ɛ ‑nu, 'ɛ ‑tɔ ‑ci, 'kɩ 'lɩ ‑ci a 'mʋ kɩ, 'ɛ ble 'lɩ yɔ', 'ɛ bi ꞊hlɔn, 'a 'kwli 'ɛ ‑crɛ, 'a 'ŋmi 'ɛ ‑gblɛ ‑tɛblɩ 'nyɩ lɛ. ");
INSERT INTO ktj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nyibli a pɛpɛ, ‑ʋ nɩ 'nɛ‑ Jrusrɛdɩɔ 'kwli, dɛ a 'mʋ, ‑ɛ mu 'lu ‑mɔ, ʋ 'wɩn nɩ. Ɛ nɔ‑ nu꞊o, ‑ci a 'mʋ 'ʋ dɛɛ ꞊nɛ Hakɛdama, 'kɩ 'lɩ ‑Juukʋɛwin 'kwli, ɛ ꞊hɛn 'nyrɛ ‑hlʋ‑ci. ");
INSERT INTO ktj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","'Ɛ mɔ ‑tɛɛ, dɛ ʋ 'crɩ la, 'kɩ 'lɩ Nyɩsʋa a ‑wlablecrɩɛn* 'kwli, ɛ nɔ‑ ‑bʋ: Nyibli bʋ hie 'ʋ 'a 'kayu bʋ, ‑ɛ ꞊dʋ 'nɩ 'tie 'lɩ꞊ɩ bʋ. 'Ya 'ʋ 'lu de, dɛ ‑bɩ, ʋ 'crɩ la, ɛ nɔ‑ ‑bʋ: 'A ‑kʋan ‑mʋ', ɛ ni la, nyiblo ‑bɩ bʋ nu꞊o. ");
INSERT INTO ktj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","'A ‑tɩ o, ‑a blɛɛ yɩ, ‑ba ꞊mʋɔ nyiblo lɛ, ‑ɛ di 'ʋ Judɩa a ‑ta' bi. Nyiblo a 'mʋ, ɛ blɛɛ yɩ bʋ mɔ nyiblodʋ ‑mʋ', ‑ɛ kɔ ‑a mʋ 'hʋɛn‑, ‑ʋ yɩ la Kʋkɔnyɔ ꞊wien lɛ kʋɛ, kʋɛ 'lɩ ti ‑mʋ', ‑ɛ kɔ 'yri Saan Batisɩ pʋ la ‑Yusu 'nie 'lu 'yie bʋ, ‑bʋ yɛ ‑nyrɔwɔ ‑mʋ' kɩ, ‑ɛ kɔ 'yri Nyɩsʋa nu la꞊a, ‑Yusu 'ɛ mu la 'lɩ yakɔ 'kwli. Nyiblo a 'mʋ, ɛ kɔ ‑a mʋ 'hʋɛn‑, ‑a 'mʋ kɩ ‑bibi ‑nɩ, ‑a 'mʋ nyibli ‑lee ‑nɩ, ‑ɛ mɔ, ‑a yi꞊e nɩ, ‑Yusu ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ nɩ, 'ɛ 'hrɩ 'klɔ.» ");
INSERT INTO ktj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","'Tɩ‑ Piɛlɩ 'mʋ ‑yrɛ mɔ mu, ‑ɛ ‑bɩ ɛ wa nyibli nɩ 'hʋɛn 'nyrɛ. ‑Ɛ ‑bɩ a 'nyrɛ mɔ Sosɛfʋ, 'ʋ dɛɛ ꞊nɛ Basabasɩ, ‑ɛ ‑bɩ a 'nyrɛ 'ɛ mɔ Matiasɩ. ");
INSERT INTO ktj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","‑Tɛ ʋ wa 'kɩ ꞊nʋ 'nyrɛ lɛ, ‑ɛ ‑bɩ ʋ da Nyɩsʋa nɩ, ʋ wɛn: «Kʋkɔnyɔ o, ‑mɔ yi nyibli a pɛpɛ a ꞊wlɩ, tɔɔ nɛ ‑a mʋ nyiblo ‑bʋ, ‑ha 'lɩ, 'kɩ 'lɩ nyibli nɩ 'hʋɛn ‑bʋ 'nyɩ, ");
INSERT INTO ktj_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","'kɩ bʋ nu ‑Yusu a ‑mɔnanyɔ a ‑kʋan ‑mʋ', Judɩa hie 'ʋ bʋ, 'ɛ mu 'lɩ ‑tɛ ‑mʋ', ɛ kɔ bʋ mu 'lɩ.» ");
INSERT INTO ktj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","‑Tɛ ʋ ‑wɛ Nyɩsʋa a dɩda ‑mɔ, ‑ɛ ‑bɩ ʋ pʋ 'wla, 'wla a 'mʋ 'ɛ pʋ 'lɩ Matiasɩ a 'nyrɛ. Matiasɩ a 'mʋ, ɛ nɔ‑ ʋ pʋ ‑Yusu a ‑mɔnanyʋ nɩ ‑pu ꞊tu 'ʋ ‑do a 'mʋ kɩ. ");
INSERT INTO ktj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ɛ kɔ la ‑Juukʋɛ* a lɛ'mimle ‑bɩ, 'ʋ dɛɛ ꞊nɛ Patɩkɔtɩ. ‑Tɛ lɛ'mimle a 'mʋ, 'a ‑nyrɔwɔ nyre 'ʋ, ‑ɛ ‑bɩ ‑Yusu a nyibli 'kukue lɛ, 'kɩ 'ʋ ‑tɛ nɩ ‑do, 'kɩ 'lɩ Jrusrɛdɩɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","'Kɩ ʋ nɩ 'ʋ ‑tɛ nɩ ‑do a 'mʋ bʋ, ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ ʋ 'wɩn win, 'ɛ ‑hɔn 'lɩ yakɔ 'kwli, ꞊wɩ yɩ ‑tɛ duduo bʋ 'yɛ nɩ ‑hi wɛn. Win a 'mʋ, ɛ kaa 'lɩ 'kayu a pɛpɛ ‑mʋ' blɛ, ‑ɛ kɔ bʋ ʋ 'kukue 'lɩ lɛ. ");
INSERT INTO ktj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","‑Ɛ ‑bɩ ʋ 'ye ‑tɛblɩ ‑mʋ' nɩ, ‑ɛ 'wɩ‑ na a ‑huhli yɩ, 'ɛ pʋ dodoyo, 'ɛ ꞊tɩɩ 'ʋ ꞊nʋ 'lu. ");
INSERT INTO ktj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kɛ‑ ɛ ꞊ti 'mʋ, Nyɩsʋa a ‑Hihiu 'ɛ bi 'ʋ nyibli a pɛpɛ a 'mʋ ke', nyibli a 'mʋ 'ʋ ‑tʋa dakɔ a gblegble a win, 'waa 'mumu, ʋ 'yɩ ‑yi a pʋpʋʋ. Nyɩsʋa a ‑Hihiu a 'mʋ, ɛ nɔ‑ nu꞊o, 'ʋ pɩ win a 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","‑Ɛ ‑bɩ, 'kɩ 'lɩ Jrusrɛdɩɔ 'kwli, ɛ kɔ la ‑Juukʋɛ ꞊dʋ, ‑ʋ yɩ Nyɩsʋa ꞊wien kʋɛ. ‑Juukʋɛ a 'mʋ, nʋ‑ ‑hɔn la 'lɩ 'blʋgbɩ a gblegble klɛ, ‑ʋ nɩ 'nɛ‑ 'klɔ a pɛpɛ kɩ, 'ʋ di Jrusrɛdɩɔ 'kwli. ");
INSERT INTO ktj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nyibli a 'mʋ, 'tɩ‑ ʋ 'mʋ win a 'mʋ 'wɩn mɔ mu, 'waa ‑hʋɔhʋɩ ya cigbɛ, 'ʋ ‑di, 'ʋ 'kukue lɛ, 'kɩ 'ʋ ‑tuo a 'mʋ kɩ. Ɛ kɛɛ 'waa pɛpɛ a ꞊wlɩ lɛ, ‑kɔtɩ ʋ yɩ ‑Yusu a nyibli 'nɩ 'ye, 'ʋ pɩ 'bliwin a gblegble, 'tɩ‑ 'a ‑nɛ nyiblo, ‑ɛ di ‑tuo a 'mʋ kɩ, 'ɛ yɩ 'a dɩɔnʋ a 'bliwin 'wɩn. ");
INSERT INTO ktj_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ɛ kɛɛ ꞊nʋ ꞊wlɩ lɛ dɩakɩ, ʋ wɛn: «'Bɩ nyibli ‑bʋ, ‑ʋ yɩ hle, 'kɩ 'waa pɛpɛ, ʋ kɔ 'lɩ Galileblʋgba 'kwli. 'Waa 'bliwin mɔ ‑Juukʋɛwin. ");
INSERT INTO ktj_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Dɛ‑ kɔ ‑tɩ 'ʋ pɩ ‑aan ‑nɛ 'bliwin 'lɩ, ꞊a yɩ꞊ɩ 'wɩn 'lɩ? ");
INSERT INTO ktj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","'Kɩ 'nɛ‑ ‑a mʋ 'nyɩ nyibli nɩ 'nɛ‑, 'ʋ ‑hɔn 'lɩ Patɩblʋgba 'kwli, ‑ʋ ‑bɩ 'ʋ ‑hɔn 'lɩ Mɛdɩblʋgba 'kwli, kɔ Elamʋ, kɔ Mesopotami, kɔ Sude, kɔ Kapadɔsɩ, kɔ Pɔn, kɔ Asi, ");
INSERT INTO ktj_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","kɔ Flisi, kɔ Pafili kɔ Esipʋblʋgba 'kwli, kɔ Libi a 'blʋgbakʋtɩɔ ‑mʋ' 'kwli, ‑ɛ 'mʋɛ Silɛnɩdɩɔ yrɛ, kɔ Klɛtɩblʋgba kɔ Arabiblʋgba 'kwli, ‑ʋ ‑bɩ 'ʋ ‑hɔn 'lɩ Rɔmʋdɩɔ 'kwli. ‑Ʋ ‑bɩ nɩ 'nɛ‑ ‑a mʋ 'nyɩ, 'ʋ mɔ ‑Juukʋɛ, ‑ʋ ‑bɩ 'yɩ ‑Juukʋɛ 'pa‑, kɛɛ, ʋ ‑hɛ ‑Juukʋɛ. Kɛɛ, ‑aan pɛpɛ, ‑a yɩ 'nɩ 'wɩn, ‑tɛ ʋ pɩ ‑aan 'bliwin, 'ʋ nɛ Nyɩsʋa a nunu‑tɛblɩ gbagbɩ a ‑tɩ ‑mɔ lɛ.» ");
INSERT INTO ktj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ɛ kɛɛ 'waa pɛpɛ lɛ dɩakɩ. 'A ‑tɩ, dɛ bʋ di 'lu ‑mɔ lɛ ‑hie, ʋ 'nɩ 'ye꞊e lɩ꞊ɩ. Kɛ‑ ʋ pɩpɩ yrɛ: «Dɛ a 'dɩ ‑bɩ dɛ a 'mʋ, ɛ ꞊hɛn 'nyrɛ 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kɛɛ, ‑ʋ ‑bɩ nɩ 'ʋ, 'ʋ yɩ ‑Yusu a nyibli 'caa ‑nɩ, ʋ wɛn: «Nɔ ni ꞊nʋ nɩ.» ");
INSERT INTO ktj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Piɛlɩ kɔ 'a 'bio ‑Yusu a ‑mɔnanyʋ* nɩ ‑pu ꞊tu 'ʋ ‑do ‑mʋ' 'hʋɛn‑, 'tɩ‑ ʋ 'mʋ ‑tɩ a 'mʋ 'wɩn mɔ mu, ‑ɛ ‑bɩ ʋ 'du ye', Piɛlɩ 'ɛ 'yɛɛ 'lɩ win, 'ɛ yɩ 'lɩ nyibli ‑hʋɔhʋɩ ‑mʋ', ‑ʋ nɩ 'ʋ ‑mɔ ‑hlee ‑nɩ, ɛ wɛn: «'A mʋ ‑Juukʋɛ*, 'dagbɩ kɔ Jrusrɛdɩɔ a nyibli 'hʋɛn‑, ba pʋ 'mʋ nʋa yɩ bʋ, ‑tɩ 'n di ‑mɔ lɛ na, a 'mʋ꞊ʋ 'wɩn. ");
INSERT INTO ktj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","'Kɩ 'lɩ 'a mʋ 'nyɩ, ‑ʋ ‑bɩ wɛn 'nɩ, nyibli ‑bʋ, nɔ ‑ni ꞊nʋ. Kɛɛ, ɛ 'yɩ nɔ 'pa‑, ɛ 'nɩ ‑nu꞊o lɩ ꞊nʋ, ‑kɔtɩ 'yrʋ, nɔ‑ 'tɩɛ 'ya 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kɛɛ, ‑tɛblɩ ‑bʋ, ‑ɛ mi 'lu ‑mɔ, Nyɩsʋa a winwlɔn‑hanyɔ* Sʋɛlɩ hla la꞊a nɩ, ti ‑bʋ, ‑ɛ nɛ, 'a 'yrɩ ꞊gbʋgbɛ klɛ. Kɛ‑ ɛ pɩ la: ");
INSERT INTO ktj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Nyɩsʋa wɛn 'nɩ, lɛ'bɔɔti 'yri, ‑tɛblɩ ‑bʋ, ‑ɛ di 'lu ‑mɔ mu, ɛ nɔ‑ ‑bʋ: 'N di 'na ‑Hihiu* dakɔ a pɛpɛ 'nɩ ‑nyi. 'Aan 'yonʋ di ‑hɛ 'na win wlɔn, ʋ 'mʋ ‑tɛblɩ 'ye, 'aan kukunyʋ di 'ya yanie, 'kɩ 'ʋ Nyɩsʋa a ‑tɛblɩ kɩ. ");
INSERT INTO ktj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","'Na ‑Hihiu di bi 'ʋ 'na ‑kʋannunyibli a pɛpɛ ke', nyɩbɛpʋ kɔ nʋgbɩ 'hʋɛn‑, ʋ 'mʋ 'na win wlɔn ‑hɛ. ");
INSERT INTO ktj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","'N di꞊e 'nɩ nu, 'kɩ 'lɩ yɔ' kɔ 'kɩ 'nɛ‑ ‑tʋtʋ kɩ, a 'mʋ ‑tɛblɩ 'ye, ‑ɛ di 'a mʋ ꞊wlɩ lɛ ‑kɛɛ ‑nɩ. A di 'ye ‑hlʋ, kɔ na‑huhli, kɔ nahlʋn 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","'Yrʋ di 'nɩ jre, ꞊hɔnpʋ di 'nɩ ꞊hlu, ꞊wɩ yɩ ‑hlʋ, 'tɩ‑ Kʋkɔnyɔ a ‑nyrɔwɔ 'mʋ 'ʋ nyre, ‑ɛ mɔ ‑nyrɔwɔ gbagbʋ ‑mʋ', ‑ɛ kɔ 'kwli ɛ di 'ʋ 'a ‑tɩ 'yi 'bʋa ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ti a 'mʋ 'yri, ‑tonyiblo 'bʋ da Kʋkɔnyɔ, Kʋkɔnyɔ a 'mʋ, ɛ di꞊e 'nɩ wa.» ");
INSERT INTO ktj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Kɛ‑ Piɛlɩ pɩ de: «Yisraɛkʋɛ*, ba pʋ 'mʋ nʋa yɩ bʋ: Nasalɛtɩ a ‑Yusu, Nyɩsʋa, nɔ‑ lee 'nɛ꞊ɛ 'a mʋ 'nyɩ, 'ɛ naa 'lɩ꞊ɩ 'lɩ, 'ɛ nu ꞊wlɩlɛkɛɛ‑tɛblɩ a gblegble, 'kɩ 'lɩ 'a mʋ 'nyɩ, ‑ɛ di꞊e nu, a 'mʋ꞊ʋ yi, ‑ɛ mɔ, Nyɩsʋa, nɔ‑ lee 'nɛ꞊ɛ 'a mʋ 'nyɩ. ");
INSERT INTO ktj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kɛɛ, ‑Yusu a 'mʋ, ʋ pʋ 'a mɔ꞊ɔ ‑jɩ', 'a naa 'lɩ Romakʋɛ, ‑ʋ 'yɩ Nyɩsʋa ‑yi 'lɩ, 'a kɔ 'ʋ꞊ʋ tugbɛ 'yie, ‑ɛ di꞊e nu, a 'mʋ꞊ʋ 'la. Kɛɛ, ‑tɛblɩ a 'mʋ, Nyɩsʋa a ꞊gbɛtʋ, nɔ‑ ‑hʋa la꞊a, nɔ‑ ‑hie la꞊a 'lu ‑mɔ lɛ, ti ‑hi la a ti 'yri, 'tɩ‑ 'ɛ mu la 'lu ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","‑Tɛ ‑Yusu 'kʋ, Nyɩsʋa ‑ha 'lɩ꞊ɩ 'kʋkʋʋ a 'klɩ bʋ, 'ɛ ‑ha꞊a 'klɔ, ‑kɔtɩ ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, 'kʋkʋʋ bʋ di꞊e 'klɩ kɩ ‑kɔɔ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","'Ɛ mɔ ‑tɛɛ, kɛ‑ ‑aan 'baɩ gbagbʋ bodɩɔ Dafidɩ pʋ la, 'kɩ 'ʋ ‑Yusu a ‑ta', ɛ wɛn: Kʋkɔnyɔ Nyɩsʋa, 'n yɩ꞊ɩ 'nɩ 'ye 'a ‑nɛ ti. 'Kɩ ɛ nɩ 'ʋ 'mʋ 'hʋɩ, ‑ɛ di꞊e nu, 'nɩ ꞊ha hʋannʋ pie. ");
INSERT INTO ktj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ɛ nɔ‑ nu꞊o, 'nɩ kɔ plɔ a bleelɛ, kɔ, 'na win 'ɛ mɔ dɔdʋwin. 'Ye ꞊bɩɩ 'n di 'kʋ, 'nɩ ‑pie꞊e 'kɩ 'kʋkʋʋ a hʋannʋ, ‑kɔtɩ 'n yi꞊e nɩ, ‑ɛ mɔ, Nyɩsʋa di nu 'mʋ ꞊haandɛ ‑mɔ, ");
INSERT INTO ktj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","'nɩ yi꞊e, ‑ɛ mɔ, ‑mɔ Nyɩsʋa, ꞊yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ‑bʋ hie 'lɩ 'mʋ 'kuo a 'bli bʋ, kɔ, ꞊yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ‑bʋ ‑hɔn 'ʋ꞊ʋ ‑mɔ', 'mɔ ‑bʋ, ‑ɛ mɔ ‑na nyiblo, 'na ‑plahʋɩ bʋ ꞊hɔɔn 'lɩ 'dabio 'kwli. ");
INSERT INTO ktj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","‑Tɔɔ 'mʋ 'hru, 'n kɔ ꞊bʋ na nɩ, 'tɩ‑ 'mʋ ꞊haan'klɔ kɔ. 'Kɩ 'ʋ 'mʋ 'hʋɩ, 'kɩ ‑di 'ʋ nɩ. Ɛ nɔ‑ di꞊e nu, 'mʋ dɔdʋ nu dɩakɩ.» ");
INSERT INTO ktj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","‑Ɛ ‑bɩ Piɛlɩ wɛn 'nɩ de: «'Na 'dɩayɩnʋ ‑na, ba kɔ 'a yiyie, ‑ɛ mɔ, ‑tɩ ‑mʋ', ‑aan 'baɩ gbagbʋ bodɩɔ Dafidɩ hla la, ɛ 'yɩ la 'a dɩɔnʋ 'nyrɛ ꞊hɛn, ‑ɛ nu꞊o, ɛ 'kʋ la nɩ, 'ʋ ‑ha la 'ʋ꞊ʋ 'ʋ. 'A 'dabio 'tɩɛ nɩ 'nɛ‑ ‑aan 'bli. ");
INSERT INTO ktj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Kɛɛ, Dafidɩ a 'mʋ, ɛ mɔ la Nyɩsʋa a winwlɔn‑hanyɔ ꞊nɩɔ, 'tɩ‑ 'ɛ yi la꞊a, ‑ɛ mɔ, Nyɩsʋa 'sʋʋ la꞊a nɩ, ‑ɛ mɔ, Dafidɩ a 'mʋ, 'a 'yonʋ a 'yu ‑bɩ di ‑hɛ la bodɩɔ gbagbʋ, ‑ɛ mɔ Wanyɔ ‑mʋ', Nyɩsʋa pʋ la lɛ, ɛ di la 'a dakɔ yɩ ya. ");
INSERT INTO ktj_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","‑Tɛ Dafidɩ hla la꞊a, ‑ɛ mɔ: Nyɩsʋa, ꞊yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ‑bʋ hie 'lɩ 'mʋ 'kʋkʋnyibli 'nyɩ bʋ, kɔ, ꞊yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ‑bʋ ‑hɔn 'ʋ꞊ʋ ‑mɔ', 'na ‑plahʋɩ bʋ ꞊hɔɔn 'lɩ 'dabio 'kwli, ‑Tɛ Dafidɩ hla la ‑tɩ a 'mʋ, ‑Yusu 'Klɩsʋ bʋ ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ, bʋ 'hrɩ 'klɔ, nɔ‑ kɔ ‑tɩ ɛ yɩ la 'ye, 'ɛ nɛ la꞊a ‑mɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","‑Yusu ‑bʋ, ‑kɔtɩ 'n nɛ ‑mɔ lɛ, Nyɩsʋa ‑ha 'lɩ꞊ɩ 'kʋkʋnyibli 'nyɩ nɩ, 'ɛ ‑ha꞊a 'klɔ. Dɛ a 'mʋ, ‑aan pɛpɛ, ‑ʋ nɩ mɔ, ‑a 'ye꞊e nɩ, ꞊a hlɛ꞊ɛ. ");
INSERT INTO ktj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","‑Tɛ dɛ a 'mʋ, ɛ ‑hi, Nyɩsʋa nu꞊o nɩ, ‑Yusu 'ɛ mu 'lɩ yakɔ 'kwli, 'ɛ nɩ 'ʋ꞊ʋ 'hʋɩ bʋ, Nyɩsʋa a ꞊gbɛtʋ 'ɛ ‑nyi꞊e 'klɩ, 'kɩ bʋ ya ‑a mʋ 'a ‑Hihiu yɩ, Nyɩsʋa pʋ la lɛ, ɛ di la ‑a mʋ yɩ ya, 'ɛ mɔ ‑tɛɛ, ‑Hihiu a 'mʋ, 'ɛ ya ‑a mɔ꞊ɔ yɩ, ꞊wɩ yɩ, ‑tɛ a ni 'a 'yiye ‑tɛ ti nɛ ‑bʋ. ");
INSERT INTO ktj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","‑Tɛ ‑Yusu ‑nu, 'ɛ 'hrɩ 'klɔ, 'ɛ mu 'lɩ yakɔ 'kwli, Dafidɩ a 'mʋ, ɛ 'yɩ la lɛ ‑nu. Kɛɛ, ‑Yusu, nɔ‑ Dafidɩ ꞊hɛn 'nyrɛ, ‑tɛ ɛ pɩ la lɛ: Kʋkɔnyɔ Nyɩsʋa lee 'na Kʋkɔnyɔ nɩ, ɛ wɛn: Nɩ mɔ 'na diidɛkɩbɩa kɩ bʋ, ɛ 'mʋ꞊ʋ gba ‑gbagba, ");
INSERT INTO ktj_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","'mʋ꞊ʋ nu, ꞊mʋ ‑na yraanyibli bʋɩ 'lu blɛ ꞊tu.» ");
INSERT INTO ktj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Kɛ‑ Piɛlɩ pɩ de, ɛ wɛn: «'A mʋ Yisraɛkʋɛ a pɛpɛ, 'n yɩ 'a mʋ 'nɩ ‑lee ‑nɩ, ‑ɛ mɔ, ‑Yusu ‑bʋ, a kɔ 'ʋ tugbɛ 'yie, nɔ‑ Nyɩsʋa nu ‑aan Kʋkɔnyɔ, kɔ ‑aan Wanyɔ 'hʋɛn‑ ‑mɔ.» ");
INSERT INTO ktj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nyibli ‑mʋ', ‑ʋ nɩ 'ʋ, bʋ 'wɩn ‑tɩ a 'mʋ, ‑ɛ ‑bɩ ɛ ‑hrɛn 'waa ꞊wlɩ lɛ dɩakɩ, 'ʋ ‑tʋa Piɛlɩ kɔ ‑Yusu a ‑mɔnanyʋ ‑bɩ ‑mʋ' a lɛ'bɛtilɛ, ʋ wɛn: «'Dɩayɩnʋ ‑na, dɛ‑ ‑a di 'kɩ nu 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","‑Ɛ ‑bɩ Piɛlɩ ꞊tu ꞊nʋ ꞊wɔn, ɛ wɛn: «'A ‑nɛ nyiblo 'bʋ nɩ 'ʋ, bʋ hie 'ʋ 'a ‑nɛ dɛ 'kuku bʋ, bʋ ‑nyi 'a 'klɔ a pɛpɛ Nyɩsʋa, bʋ ‑hʋa꞊a, 'kɩ bʋ pʋ꞊ʋ 'nie 'lu, 'kɩ 'lɩ ‑Yusu 'Klɩsʋ a 'nyrɛ 'kwli, ‑ɛ di꞊e nu, Nyɩsʋa 'mʋ 'a dɛ 'kuku a 'mʋ 'wʋwla ‑nɩ, 'tɩ‑ Nyɩsʋa 'mʋ꞊ʋ 'a ‑Hihiu ‑nyi. ");
INSERT INTO ktj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nɔ‑ mɔ dɛ, Nyɩsʋa pʋ la lɛ, ɛ di la nu, 'kɩ 'ʋ 'a mʋ kɔ 'aan 'yonʋ 'hʋɛn‑ ‑mɔ, kɔ 'kɩ 'ʋ nyibli ‑mʋ' ‑mɔ, ‑ʋ nɩ 'nɛ‑ 'klɔ a pɛpɛ kɩ, ‑ɛ ꞊hɛn 'nyrɛ, nyibli a pɛpɛ ‑bʋ, Nyɩsʋa di da, ʋ 'mʋ 'a nyibli ‑hɛ.» ");
INSERT INTO ktj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piɛlɩ na ‑tɩ ‑hʋɔhʋɩ ‑mɔ lɛ, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ ꞊han‑tɩ pʋ. Kɛ‑ ɛ ‑pʋ: «Ba wɛn, 'kɩ Nyɩsʋa bʋ wa 'a mʋ, 'a ‑bati 'nɩ ꞊ha 'a mʋ klɔ, ꞊wɩ yɩ, ‑tɛ ɛ di nu, ɛ 'mʋ nyibli ‑mʋ', ‑ʋ ni dɛ 'kuku klɔ.» ");
INSERT INTO ktj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nyibli ‑hʋɔhʋɩ 'kɩ 'lɩ ꞊nʋ 'nyɩ, nʋ‑ pʋ Piɛlɩ a win ꞊han‑tɩ, 'tɩ‑ nyibli a 'mʋ, 'ʋ pʋ ꞊nʋ 'nie 'lu lɛ. ‑Nyrɔwɔ a 'mʋ 'kwli, nyibli, ‑ʋ bi ‑Yusu a nyibli kɩ, ʋ ‑wɛ 'lɩ nyibli a 'miliwɩ nɩ ta nɩ. ");
INSERT INTO ktj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","'A ‑nɛ ti, nyibli a 'mʋ, ʋ ꞊mʋɛ꞊ɛ lɛ, 'kɩ ‑Yusu a ‑mɔnanyʋ bʋ tɔɔ ꞊nʋ Nyɩsʋa a ‑tɩ, 'ʋ yɩ dɛ ‑mɔ ‑didi ‑nɩ, 'ʋ yɩ ‑Yusu a lɛ'bɔɔdiidɛ di ‑wɛ, 'ʋ dɛ Nyɩsʋa. ");
INSERT INTO ktj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","'A ‑nɛ nyiblo 'bʋ nɩ 'ʋ, ɛ yɩ pie Nyɩsʋa, ‑kɔtɩ 'kɩ Nyɩsʋa nɛɛ 'lɩ 'a ‑mɔnanyʋ* 'lɩ, 'ɛ ni ꞊wlɩlɛkɛɛ‑tɛblɩ ‑hʋɔhʋɩ. ");
INSERT INTO ktj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nyibli a pɛpɛ, ‑ʋ kuo ‑Yusu ꞊wlʋ yɩ, ʋ ‑mʋɛ nɩ, ‑tɛblɩ a pɛpɛ, ʋ ‑kɔ, 'ʋ ꞊glɛ꞊ɛ, ");
INSERT INTO ktj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","'ʋ ple 'waa kʋkɔ‑tɛblɩ, 'ʋ ‑hɛ 'lɩ 'a 'wliyɛ 'lɩ, 'ʋ ꞊glɛ꞊ɛ ꞊hɩʋɛnnyibli lɛ, ‑ʋ nɩ 'lɩ ꞊nʋ 'nyɩ, ꞊wɩ yɩ, ‑tɛ 'waa 'kla‑wliye'yɩya ꞊ti 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","'A ‑nɛ ‑nyrɔwɔ, 'kɩ ʋ yɩ 'lɩ Nyɩsʋa a 'kagbaʋ blɛ 'kukue ‑nɩ, 'kɩ 'ʋ Nyɩsʋa a dɩda a ‑ta', 'ʋ yɩ yɩ blɛ ‑bibi ‑nɩ ‑wɛ, 'kɩ 'lɩ 'waa 'kayo blɛ, 'ʋ yɩ ‑Yusu a lɛ'bɔɔdiidɛ di, kɔ, 'ʋ yɩ dii‑tɛblɩ ‑mɔ ‑didi ‑nɩ, 'kɩ 'lɩ ꞊wlʋ a 'ʋbʋ'wʋwlɛ 'kwli, ");
INSERT INTO ktj_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","'ʋ pɩ Nyɩsʋa 'nyrɛ lɛ, dakɔ a pɛpɛ 'ʋ nʋɛ 'waa dɛ, kɔ, 'a ‑nɛ ‑nyrɔwɔ, Nyɩsʋa 'ɛ ni꞊e, nyibli ‑bɩ 'ʋ kue ‑Yusu ꞊wlʋ yɩ, nyibli a 'mʋ, 'ʋ yɩ ‑Yusu a nyibli kɩ bi. ");
INSERT INTO ktj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","‑Nyrɔwɔ ꞊dʋ 'kwli, 'yrʋ‑hiilɛ a ti 'yri, ‑tɛ Nyɩsʋa a dɩdati nyre 'ʋ, Piɛlɩ kɔ Saan 'hʋɛn‑, ʋ mi 'lɩ Nyɩsʋa a 'kagbaʋ bʋ, ʋ 'mʋ꞊ʋ da. ");
INSERT INTO ktj_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nyɩsʋa a 'kagbaʋ a 'mʋ, 'a ‑yaa kɔ 'maju ‑bɩ, 'ʋ dɛɛ ꞊nɛ Yɩnɔmaju. Nɔ‑ kɔ yɩ lɛ‑yɩyrɛnyɔ ꞊dʋ nɩ 'ʋ bʋ, 'ɛ 'yɩ ‑hʋan nalɛ nɩ yi, kʋɛ la 'lɩ 'a kɔɔlɛ 'yie bʋ. 'A ‑nɛ ‑nyrɔwɔ, ʋ yɛ꞊ɛ nɩ, 'ʋ ꞊tui 'ʋ꞊ʋ ‑tɩtɛ a 'mʋ bʋ, ‑ɛ di꞊e nu, nyibli ‑mʋ', ‑ʋ pʋɛ 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli, ɛ 'mʋ ꞊nʋ 'wli lɛ ‑hʋa. ");
INSERT INTO ktj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","'Kɩ ɛ nɩ 'ʋ bʋ, Piɛlɩ kɔ Saan 'hʋɛn‑, 'ʋ mi 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli pa mɔ. Bʋ 'ye ꞊nʋ, ‑ɛ ‑bɩ ɛ ‑tʋa 'waa 'wliyɛ a ‑hʋhʋa. ");
INSERT INTO ktj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Piɛlɩ kɔ Saan 'hʋɛn‑, 'ʋ ta 'lɩ꞊ɩ 'yi lɛ ‑tata, ‑ɛ ‑bɩ Piɛlɩ wɛn: «Ta 'nɛ‑ ‑a mʋ ‑mɔ lɛ gbee», ");
INSERT INTO ktj_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","lɛ‑yɩyrɛnyɔ 'ɛ ‑tʋa 'waa 'yiye. Ɛ nɔ‑ ‑mɔ ‑bɩ, 'a ꞊wlʋ 'ye꞊e nɩ, ‑ɛ mɔ, ʋ di ‑nyi꞊e ꞊dedede. ");
INSERT INTO ktj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","‑Ɛ ‑bɩ kɛ‑ Piɛlɩ pɩ 'kɩ꞊ɩ yɩ de, ‑ɛ mɔ: «'N 'yɩ 'wliyɛ ‑kɔ. Kɛɛ, dɛ 'n ‑kɔ, 'n di ‑mɔ꞊ɔ 'nɩ ‑nyi: 'Kɩ 'lɩ Nasalɛtɩ a ‑Yusu 'Klɩsʋ a 'nyrɛ 'kwli, 'n yɩ ‑mʋ 'nɩ ‑lee ‑nɩ, 'du ye', ‑bʋ na», ");
INSERT INTO ktj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Piɛlɩ 'ɛ 'ble 'a diidɛdabʋ kʋa, 'ɛ 'du꞊o ye'. Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ 'a bʋɩ kɔ 'a ‑gblekegbleke 'hʋɛn‑, ‑ʋ 'kʋ mɔ, ʋ kɔ 'kɩ 'klɩ, ");
INSERT INTO ktj_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","'ɛ ꞊plu, 'ɛ nyra bʋ, 'tɩ‑ 'ɛ ‑tʋa nɩna, ɛ kɔ Piɛlɩ kɔ Saan 'hʋɛn‑, 'ʋ pa 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli, 'ɛ nɛ, 'ɛ ꞊plui, kɔ, 'ɛ pɩ Nyɩsʋa 'nyrɛ lɛ. ");
INSERT INTO ktj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nyibli a pɛpɛ ‑mʋ', ‑ʋ nɩ 'ʋ, ʋ 'ye꞊e nɩ, ‑tɛ ɛ yɩ nɩ nɛ, kɔ, ‑tɛ ɛ pɩ Nyɩsʋa 'nyrɛ lɛ. ");
INSERT INTO ktj_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","‑Tɛ ʋ yru꞊o, ‑ɛ mɔ, ɛ nɔ‑ yɩ mɔ 'ʋ Nyɩsʋa a 'kagbaʋ a 'maju ye' blɛ nɩ, ‑ɛ ‑hʋɛ mɔ nyibli 'wli lɛ, ‑ɛ ‑bɩ 'waa pɛpɛ, ʋ ta 'ʋ blɛ, ‑kɔtɩ 'waa ꞊wlɩ kɛɛ lɛ, 'kɩ ʋ dɛ a 'mʋ, ‑ɛ mu 'lu ‑mɔ a ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nyiblo a 'mʋ, ‑ɛ kɔ 'kʋɛ ‑wɛ, ɛ 'nɩ ‑hɔn꞊ɔ 'ʋ Piɛlɩ kɔ Saan 'hʋɛn‑ 'hʋɩ. 'Kɩ ʋ nɩ 'lɩ Nyɩsʋa a 'kagbaʋ a pʋpa ‑mʋ' bʋ, ʋ dɛɛ Salomɔ a pʋpa. Nyibli a pɛpɛ ‑mʋ', ‑ʋ 'wɩn ‑tɩ a 'mʋ, ɛ kɛɛ ꞊nʋ lɛ, 'ʋ gba 'lɩ cigbɛ. ");
INSERT INTO ktj_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","‑Tɛ Piɛlɩ 'ye dakɔ a 'mʋ, ‑ʋ ‑di, ‑ɛ ‑bɩ kɛ‑ ɛ pɩ ꞊nʋ yɩ, ɛ wɛn: «'A mʋ Yisraɛkʋɛ, ɛ 'nɩ 'kɛɛ 'lɩ 'aan ꞊wlɩ lɛ, ‑tɛ nyiblo ‑bʋ a 'kʋɛ ‑wɛ a ‑tɩ. A 'nɩ 'yee 'lɩ꞊ɩ, ‑ɛ mɔ, ‑aan 'klɩ kɔ ‑ba kɔ Nyɩsʋa a nʋɛlɛ dɩakɩ a ‑tɩ, nʋ‑ nu꞊o, nyiblo ‑bʋ, ‑ɛ 'yɩ la nalɛ ‑yi, 'ɛ yi kɛ nalɛ. ");
INSERT INTO ktj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","'Ʋʋn‑, ɛ 'yɩ 'mʋ lɛ ‑nɩ. Kɛɛ, Nyɩsʋa ‑mʋ', ‑aan 'baɩnʋ Abrahamʋ, kɔ Yisakɩ, kɔ Sakɔbʋ 'hʋɛn‑, ʋ dɛ la, ʋ kɔ ‑aan 'baɩnʋ ‑bɩ 'hʋɛn‑, Nyɩsʋa nɩ ‑do a 'mʋ, ɛ nɔ‑ ‑nyi 'a ‑kʋannunyɔ ‑Yusu ‑tɩ a 'yi'bʋbʋa. Ɛ nɔ‑ nu꞊o, nyiblo ‑bʋ a 'kʋɛ 'ɛ ‑wɛ. ‑Yusu a 'mʋ, 'a mʋ pʋ꞊ʋ Romakʋɛ ‑jɩ', 'tɩ‑ 'waa ‑gʋlʋnʋma Pilatɩ 'ɛ pʋʋ ꞊nɛ ‑bati lɛ, 'tɩ‑ 'ɛ pʋ lɛ, ɛ 'mʋ꞊ʋ bʋ tɛ, kɛɛ, 'a mʋ ‑mɔ ‑bɩ, a pʋ꞊ʋ ‑tɩ 'lu lɛ, 'a pʋ lɛ, ‑Yusu mɔ ‑balʋnyiblo ꞊nɩɔ, 'a ‑tɩ, Pilatɩ 'nɩ 'tɛɛ 'lɩ꞊ɩ bʋ, bʋ 'la꞊a. ");
INSERT INTO ktj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kɛɛ, ‑Yusu a 'mʋ, ɛ ‑nyi 'a dɩɔnʋ Nyɩsʋa nɩ pɛpɛ, 'ɛ 'sii 'ʋ yɩ, 'kɩ 'ʋ Nyɩsʋa ye'. Kɛɛ, 'a mʋ ‑mɔ ‑bɩ, a 'nɩ ‑hʋa꞊a mɔ꞊ɔ, 'kɩ Pilatɩ bʋ tɛ mɔ꞊ɔ bʋ, kɛɛ, ‑balʋnyiblo ꞊dʋ, ‑ɛ nɩ mɔ ꞊jɩ', nɔ‑ a ‑hʋa Pilatɩ bʋ tɛ mɔ bʋ, ‑Yusu 'mʋ mɔ 'ʋ ‑balʋnyiblo a 'mʋ, 'a ‑ta' bi. ");
INSERT INTO ktj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kɛ‑ a ‑nu, 'a 'la ‑Yusu ‑mʋ', ‑ɛ ‑ni꞊e, nyibli 'ʋ kʋɛ 'klɔ yrayrʋ ‑mʋ', ‑ɛ 'yɛ nɩ ‑wɛ 'lɩ. Kɛɛ, Nyɩsʋa ‑ha 'lɩ꞊ɩ 'kʋkʋnyibli 'nyɩ nɩ, 'ɛ ‑ha꞊a 'klɔ. ‑Tɛ ‑Yusu 'hrɩ mɔ 'klɔ, ‑aan 'mumu, ‑a 'ye mɔ꞊ɔ nɩ. ");
INSERT INTO ktj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nyiblo ‑bʋ, a ‑yi, 'tɩ‑ ‑ɛ nyra 'nɛ‑ 'a mʋ ye' bʋ, ‑tɛ ‑a kuo ‑Yusu a 'mʋ ꞊wlʋ yɩ, ɛ nɔ‑ nu꞊o, ‑Yusu a 'mʋ 'ɛ nu꞊o, 'ɛ yi 'kɩ nalɛ. ‑Yusu a 'mʋ, nɔ‑ nu꞊o, 'tɩ‑ nyiblo ‑bʋ, 'ɛ kuo ꞊nɛ ꞊wlʋ yɩ, ‑Yusu 'ɛ nu꞊o, 'a 'kʋɛ 'ɛ ‑wɛ. Ɛ nɔ‑ a yɩ 'kɩ 'ye. ");
INSERT INTO ktj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","‑Ɛ ‑bɩ 'kɩ, 'dɩayɩnʋ ‑na, 'n yi꞊e nɩ, a kɔ 'aan nyibli gbagbɩ 'hʋɛn‑, dɛ ‑mʋ', a nu ‑Yusu ‑mɔ, a 'yɩ꞊ɩ ‑yi. ");
INSERT INTO ktj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kɛɛ, ‑tɛ a 'la ‑Yusu, ɛ ꞊hɛn 'nyrɛ, ‑ɛ mɔ, dɛ ‑mʋ', Nyɩsʋa naa la 'lɩ 'a winwlɔn‑hanyʋ* a pɛpɛ wlɔn, ɛ na la ‑mɔ lɛ, dɛ a 'mʋ, Nyɩsʋa nu꞊o nɩ, 'ɛ nyre 'ʋ. Ɛ nɔ‑ mɔ: Wanyɔ ‑mʋ', ɛ pʋ la lɛ, ɛ di la 'a dakɔ yɩ ya, Wanyɔ a 'mʋ, ɛ kɔ bʋ 'ye ꞊hɩʋɛn, 'tɩ‑ ɛ 'mʋ 'kʋ. ");
INSERT INTO ktj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","'A ‑tɩ o, ba hie 'ʋ 'aan dɛ 'kuku bʋ, ba ‑nyi 'aan 'klɔ a pɛpɛ Nyɩsʋa, ‑ɛ di꞊e nu, ɛ 'mʋ 'aan dɛ 'kuku a 'mʋ 'wʋwla ‑nɩ, ");
INSERT INTO ktj_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","'tɩ‑ Kʋkɔnyɔ Nyɩsʋa a ꞊gbɛtʋ, ɛ 'mʋ꞊ʋ nu, a 'mʋ plɔ a bleelɛ kɔ, kɔ, ɛ 'mʋ 'a mʋ ‑Yusu yɩ ya, ‑ɛ mɔ Wanyɔ ‑mʋ', ɛ ‑ha la, see la, 'kɩ 'ʋ 'aan ‑ta'. ");
INSERT INTO ktj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","‑Tɛ ti nɛ ‑bʋ, ‑Yusu 'tɩɛ di 'lɩ yakɔ 'kwli bʋ nɩ, ɛ 'mʋ꞊ʋ gba ‑gbagba, ti ‑mʋ' ‑kɔ 'yri Nyɩsʋa di ‑tɛblɩ yrayrɩ nu, ɛ 'mʋ 'ʋ nyre. ‑Tɩ a 'mʋ, Nyɩsʋa ꞊tu la꞊a 'a winwlɔn‑hanyʋ wlɔn, 'ʋ hla la꞊a, ti ‑hi la a ti 'yri. ");
INSERT INTO ktj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","'Ɛ mɔ ‑tɛɛ, kɛ‑ winwlɔn‑hanyɔ Moise pʋ la, ‑ɛ mɔ: Kʋkɔnyɔ Nyɩsʋa di ‑ha winwlɔn‑hanyɔ, 'kɩ 'lɩ ‑aan dakɔ 'nyɩ, ɛ 'mʋ 'mʋ yɩ 'wɩ. ‑Tɩ a pɛpɛ ‑mʋ', ɛ di hla, ba pʋ꞊ʋ nʋa yɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nyiblo, 'bʋ 'yɛ nɩ di winwlɔn‑hanyɔ a 'mʋ, 'a win nʋa yɩ bʋ nɩ pʋ, ʋ blɛɛ yɩ, bʋ ‑ha 'lɩ꞊ɩ dakɔ 'nyɩ, ʋ 'mʋ꞊ʋ 'la. ");
INSERT INTO ktj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Kʋɛ la 'lɩ Nyɩsʋa a winwlɔn‑hanyɔ Samuɛlɩ ‑mɔ bʋ, kɔ winwlɔn‑hanyʋ ‑bɩ ‑mʋ', ‑ʋ kʋɛ 'ʋ꞊ʋ ‑mɔ bʋ, ‑tɛblɩ ‑bʋ, ‑ɛ mi kɛ 'lu ‑mɔ, 'a pɛpɛ, ʋ hla la꞊a nɩ. ");
INSERT INTO ktj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","‑Tɩ ‑mʋ', Nyɩsʋa naa la 'lɩ 'a winwlɔn‑hanyɔ wlɔn, ɛ hla la, 'a mʋ ‑kɔ ‑tɩ 'ɛ hla la꞊a. 'Yrɩ ‑mʋ', Nyɩsʋa ꞊tu la, ɛ kɔ ‑aan 'baɩnʋ 'hʋɛn‑, 'a mʋ ‑kɔ ‑tɩ, 'ɛ ꞊tu la 'yrɩ a 'mʋ. 'Ɛ mɔ ‑tɛɛ, kɛ‑ ɛ pɩ la Abrahamʋ yɩ, ‑ɛ mɔ: 'Kɩ 'n di 'lɩ ‑na 'yonʋ a 'yonʋ 'lɩ ‑naa ‑nɩ, 'mʋ 'klɔ ‑bʋ, 'a nyibli a pɛpɛ ꞊haandɛ ‑mɔ nu. ");
INSERT INTO ktj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","'A mʋ ‑mɔ yɩ‑hɛnyibli, ‑ʋ kɔ ‑tɩ Nyɩsʋa 'ɛ ‑ha 'lɩ 'a ‑kʋannunyɔ ‑Yusu 'kʋkʋnyibli 'nyɩ, 'ɛ ‑ha꞊a 'klɔ, ‑ɛ di꞊e nu, ɛ 'mʋ 'a mʋ ꞊haandɛ ‑mɔ nu. ꞊Haandɛ a 'mʋ, ɛ nɔ‑ mɔ, bʋ ‑hɛɛ nɛ 'a mʋ, ba hie 'ʋ 'aan dɛ 'kuku bʋ.» ");
INSERT INTO ktj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Piɛlɩ kɔ Saan 'hʋɛn‑, ‑ʋ mɔ ‑Yusu a ‑mɔnanyʋ*, bʋ nɩ 'lɩ dakɔ a ‑mɔhleelɛ 'kwli, ‑ɛ ‑bɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* a nyibli gbagbɩ, ʋ nyre 'ʋ nɩ, ʋ kɔ Nyɩsʋa a 'kagbaʋ a 'yie꞊tunyʋ a nyibli gbagbɩ, kɔ Sadusɩ꞊tumu* a nyibli ‑bɩ 'hʋɛn‑. (Sadusɩ꞊tumu a nyibli a 'mʋ, ʋ nʋ‑ hlɛ꞊ɛ, ‑ɛ mɔ, ɛ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, 'kɩ ‑tonyiblo 'bʋ 'kʋ, 'tɩ‑ Nyɩsʋa bʋ ‑ha 'lɩ꞊ɩ 'kʋkʋnyibli 'nyɩ, bʋ ‑ha꞊a 'klɔ.) ");
INSERT INTO ktj_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","‑Juukʋɛ a nyibli gbagbɩ a 'mʋ, ‑ʋ ‑di, ʋ 'yɩ plɔ a bleelɛ ‑kɔ, ‑ɛ nu꞊o, ‑Yusu a ‑mɔnanyʋ a 'mʋ, ʋ tʋɛ dakɔ nɩ, ‑ɛ mɔ, Nyɩsʋa ‑ha 'lɩ ‑Yusu 'kʋkʋnyibli 'nyɩ nɩ, 'ɛ ‑ha꞊a 'klɔ, ɛ ꞊hɛn 'nyrɛ, ‑ɛ mɔ, ɛ ‑wɛ 'lɩ nyiblo bʋ 'kʋ nɩ, Nyɩsʋa bʋ ‑ha 'lɩ꞊ɩ 'kʋkʋnyibli 'nyɩ nɩ, bʋ ‑ha꞊a 'klɔ nɩ. ");
INSERT INTO ktj_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","‑Tɛ ‑Juukʋɛ a nyibli gbagbɩ a 'mʋ, ʋ nyre 'kɩ 'ʋ, ‑ɛ ‑bɩ ʋ klɔ ‑Yusu a ‑mɔnanyʋ a 'mʋ nɩ. ‑Tɛ 'tɔ ‑wɔn a ‑tɩ, 'ʋ 'yɩ ꞊nʋ ‑bati lɛ ‑pʋʋ ‑nɩ, 'ʋ pʋ ꞊nʋ ꞊jɩ'. ");
INSERT INTO ktj_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kɛɛ, nyibli ‑mʋ', ‑ʋ 'wɩn ‑Yusu a ‑tɩ, 'waa ‑hʋɔhʋɩ kuo ‑Yusu ꞊wlʋ yɩ, 'ʋ bi ‑Yusu a nyibli kɩ. Ɛ nɔ‑ nu꞊o, 'kɩ 'lɩ ‑Yusu a nyibli a pɛpɛ 'nyɩ, 'ʋ ‑wɛ kɛ 'lɩ nyɩbɛpʋ a 'miliwɩ nɩ ꞊hun. ");
INSERT INTO ktj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","‑Tɛ ‑nyrɛ ‑nyɛ, ‑ɛ ‑bɩ ‑Juukʋɛ a nyibli gbagbɩ, kɔ Nyɩsʋa a tetetɔɔnyʋ, ‑ʋ nɩ 'lɩ Jrusrɛdɩɔ 'kwli 'hʋɛn‑, nʋ‑ 'kukue lɛ, 'kɩ ʋ 'mʋ ‑Yusu a ‑mɔnanyʋ ‑bati lɛ ‑pʋʋ ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nyɩsʋa a ‑cɔhlʋnpinyʋ a nyiblo gbagbʋ, ‑ɛ mɔ Hanɩ, ɛ nɩ ‑tuo kɩ ‑wɛ, ɛ kɔ Kaifʋ, kɔ Saan, kɔ Alɛsadrɩ, kɔ Hanɩ a 'mʋ, 'a ꞊tugba a nyibli ‑bɩ 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","‑Tɛ 'waa pɛpɛ a 'mʋ, ʋ ‑wɛ ti kɩ, ‑ɛ ‑bɩ ʋ lee nyibli, 'kɩ bʋ ya ꞊nʋ ‑Yusu a ‑mɔnanyʋ nɩ 'hʋɛn‑ a 'mʋ yɩ. ‑Tɛ ʋ nyre 'kɩ 'lɩ ꞊nʋ 'nyɩ, ‑ɛ ‑bɩ ʋ yɩ ꞊nʋ lɛ 'nɩ 'bɛti ‑nɩ: «Nyiblo a 'dɩ ‑bɩ, ‑ɛ ‑nyi 'a mʋ 'klɩ, kɔ, ‑ɛ lee nɛ 'a mʋ, ‑ɛ mɔ, ba nu꞊o, lɛ‑yɩyrɛnyɔ ‑mʋ' bʋ na 'lɩ?» ");
INSERT INTO ktj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nyɩsʋa a ‑Hihiu* kɔɔ Piɛlɩ win kɩ pɛpɛ. 'A ‑tɩ, kɛ‑ ɛ pɩ, 'ɛ ‑hɩhɩɛ ꞊nʋ klɛ, ɛ wɛn: «'A mʋ dakɔ a ye'nanyʋ, 'a mʋ nyibli gbagbɩ, ");
INSERT INTO ktj_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","a pɩɩ kɛ ‑a mʋ ‑bati lɛ, 'a yɩ kɛ ‑a mʋ 'bɛti ‑nɩ, 'kɩ 'ʋ ꞊haandɛ ‑bʋ, ‑a ‑nu a ‑ta', 'kɩ 'ʋ lɛ‑yɩyrɛnyɔ ‑mɔ. ‑Tɛ a yɩ ‑a mʋ lɛ 'bɛti ‑nɩ, ");
INSERT INTO ktj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","'a mʋ ‑bʋ, a kɔ dakɔ a pɛpɛ, ‑ʋ mɔ Yisraɛkʋɛ 'hʋɛn‑, ba kɔ 'a yiyie, ‑ɛ mɔ, nyiblo ‑bʋ, ‑ɛ nɩ mɔ 'a mʋ ye', ‑ɛ kɔ 'kʋɛ ‑wɛ, Nasalɛtɩ a ‑Yusu 'Klɩsʋ, ɛ nɔ‑ kɔ 'klɩ ‑nu꞊o, 'a 'kʋɛ a 'mʋ 'ɛ ‑wɛ. ‑Yusu a 'mʋ, ɛ nɔ‑ a kɔ 'ʋ tugbɛ 'yie, a 'la. Ɛ nɔ‑ Nyɩsʋa ‑ha 'lɩ 'kʋkʋnyibli 'nyɩ, ɛ ‑ha 'klɔ. ");
INSERT INTO ktj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","'Kɩ 'lɩ Nyɩsʋacrɩɛn 'kwli, ʋ 'crɩ la ‑tɩ, 'kɩ 'ʋ ‑Yusu a ‑ta'. ‑Tɩ a 'mʋ, ʋ 'crɩ la, ɛ nɔ‑ ‑bʋ, 'Katuo ‑mʋ', 'a mʋ 'kayopʋnyʋ, a 'yɩ ‑hʋa ba nuu ‑kʋan 'yri, a pʋ bʋ, ɛ nɔ‑ ‑hɛ 'katuo gbagbʋ. Kɛ‑ Nyɩsʋa a win pɩ. 'Katuo a 'mʋ, nɔ‑ mɔ ‑Yusu. ('Kayupʋnyʋ ‑mɔ ‑bɩ, ʋ nʋ‑ mɔ 'a mʋ.)» ");
INSERT INTO ktj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kɛ‑ Piɛlɩ pɩ de: «‑Yusu nɩ ‑do, ɛ nɔ‑ ‑wɛ 'lɩ ‑bʋ wa nyibli, 'kɩ 'ʋ Nyɩsʋa a ‑bati a ‑ta'. 'Kɩ 'nɛ‑ 'klɔ a pɛpɛ ‑bʋ kɩ, Nyɩsʋa 'yɩ nyiblo ꞊dʋ ‑ha, 'kɩ ‑bʋ wa ‑a mʋ.» ");
INSERT INTO ktj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","‑Gbolugbo a nyibli, ʋ yɩ꞊ɩ 'nɩ 'ye, ‑ɛ mɔ, Piɛlɩ kɔ Saan 'hʋɛn‑, ʋ 'nɩ ‑pie꞊e lɩ hʋannʋ, 'bʋ yɩ ‑mɔ lɛ nɩ nɛ, ‑ɛ kɔ ‑ta', ‑gbolugbo a nyibli a 'mʋ, ʋ yi꞊e nɩ, ‑ɛ mɔ, Piɛlɩ kɔ Saan 'hʋɛn‑, ʋ 'yɩ 'crɩɛn gbagbʋ ꞊dʋ ‑yi, 'tɩ‑ ʋ 'yɩ nyibli gbagbɩ 'pa‑. Dɛ a 'mʋ, ɛ kɛɛ 'waa ꞊wlɩ lɛ. Kɛɛ, ʋ yru ꞊nʋ nɩ, 'ʋ yi꞊e, ‑ɛ mɔ, ʋ nɛ mɔ ‑Yusu ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kɛɛ, ʋ 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, bʋ hla꞊a, ‑ɛ mɔ, lɛ‑yɩyrɛnyɔ a 'kʋɛ 'yɩ ‑wɛ, ‑kɔtɩ 'kɩ ɛ nɩ 'ʋ ꞊nʋ ye' bʋ. ");
INSERT INTO ktj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","‑Ɛ ‑bɩ ʋ lee Piɛlɩ kɔ Saan 'hʋɛn‑ nɩ, 'kɩ bʋ 'hrɩ 'lɩ ꞊nʋ 'nyɩ. ‑Tɛ ʋ 'hrɩ 'lɩ ꞊nʋ 'nyɩ, ‑ɛ ‑bɩ ʋ ‑tʋa 'waa dɩɔnʋ a lɛ'bɛtilɛ, ");
INSERT INTO ktj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ʋ wɛn: «Dɛ a 'dɩ ‑bɩ ‑a di nyibli bʋ ‑mɔ nu 'lɩ, ‑ɛ nu꞊o, nyibli a pɛpɛ, ‑ʋ nɩ 'nɛ‑ Jrusrɛdɩɔ 'kwli, ʋ yi꞊e nɩ, ‑ɛ mɔ, Piɛlɩ kɔ Saan 'hʋɛn‑, ʋ nu ꞊wlɩlɛkɛɛdɛ gbagbʋ. 'Tɩ‑ ‑a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ‑ba hla꞊a, ‑ɛ mɔ, hɩ ꞊nɩɔ, ʋ 'yɩ꞊ɩ ‑nu. ");
INSERT INTO ktj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","‑Ba ‑hɩʋɩ 'lɩ 'yie bʋ, ‑ba ti ꞊nʋ, ‑ɛ di꞊e nu, ʋ 'nɩ ꞊ha ‑Yusu a ‑tɩ ‑mɔ lɛ na de, 'kɩ 'ʋ nyibli ꞊dʋ ye'. Ɛ nɔ‑ di꞊e nu, dɛ ‑bʋ, ‑ɛ mu 'lu ‑mɔ, 'kɩ ɛ 'yɛ nɩ di 'blʋgba a pɛpɛ kɩ bʋ 'hɛɛn ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","'Tɩ‑ ʋ 'mʋ ‑yrɛ, ‑ɛ ‑bɩ ʋ da Piɛlɩ kɔ Saan 'hʋɛn‑ nɩ de, ʋ wɛn: «A 'nɩ 'naa 'lɩ ‑Yusu a ‑tɩ ‑mɔ lɛ de, 'kɩ 'ʋ nyibli ꞊dʋ ye'.» ");
INSERT INTO ktj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kɛɛ, Piɛlɩ kɔ Saan 'hʋɛn‑, ʋ ꞊tu ꞊nʋ ꞊wɔn, ʋ wɛn: «'Aan ꞊gbɛtʋ, ba 'ye꞊e, 'bʋ mɔ, 'bʋ nɔɔ 'ʋ lɛ, 'kɩ 'ʋ Nyɩsʋa ye', 'kɩ ‑ba ꞊tuu 'ʋ 'a mʋ, 'ɛ ‑hi 'ʋ, ‑ba ꞊tuu 'ʋ Nyɩsʋa 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Dɛ ‑bʋ, ‑a 'ye, ɛ kɔ ‑tɩ ‑bʋ, ‑a 'wɩn, ‑a 'yɩ 'lɩ꞊ɩ 'lɩ ‑wɛ, ‑ba ma wien, ‑ba 'yɩ꞊ɩ kɩ ‑hlee ‑nɩ.» ");
INSERT INTO ktj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","‑Juukʋɛ a nyibli gbagbɩ, ʋ 'nɩ 'ye꞊e 'hru, bʋ di gba, bʋ di Piɛlɩ kɔ Saan 'hʋɛn‑ ꞊hɩʋɛn ꞊tu, ‑ɛ nu꞊o, nyibli a pɛpɛ, ʋ pɩɩ Nyɩsʋa 'nyrɛ lɛ, 'kɩ 'ʋ dɛ ‑mʋ', ‑ɛ mu 'lu ‑mɔ a ‑ta'. Ɛ nɔ‑ kɔ ‑tɩ, nyibli gbagbɩ a 'mʋ 'ʋ yɩ nyibli a hʋannʋ pie, 'ʋ yɩ Piɛlɩ kɔ Saan 'hʋɛn‑ ‑lee ‑nɩ, ‑ɛ mɔ: «'Bʋ mɔ, 'ba 'tɩɛ yɩ 'aan nunuŋmlɩ a 'mʋ 'lu ‑mɔ nɩ gbɛ, ‑a di ꞊tu 'a mʋ ꞊hɩʋɛn», 'tɩ‑, 'ʋ tɛ ꞊nʋ bʋ. ");
INSERT INTO ktj_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Nyiblo a 'mʋ, ‑ɛ kɔ 'kʋɛ ‑wɛ, 'kɩ 'lɩ ꞊wlɩlɛkɛɛdɛ 'kwli, ɛ kɔ 'yrɩ a ‑wlɩ nɩ 'hʋɛn, 'ɛ nɩ dɛ lɛ. ");
INSERT INTO ktj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","‑Tɛ ʋ tɛ 'kɩ Piɛlɩ kɔ Saan 'hʋɛn‑ bʋ, ‑ɛ ‑bɩ ʋ mu 'lɩ 'waa 'bio ‑mɔ, ‑tɛblɩ a pɛpɛ a 'mʋ, Nyɩsʋa a ‑cɔhlʋnpinyʋ* kɔ nyibli gbagbɩ ‑bɩ 'hʋɛn‑, ʋ lee ꞊nʋ, 'ʋ na꞊a ‑mɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","‑Tɛ ʋ 'wɩn ‑tɩ a 'mʋ, ‑ɛ ‑bɩ ʋ ‑tʋa Nyɩsʋa a dɩda, 'kɩ 'lɩ 'lulɛ‑hihie nɩ ‑do 'kwli, ʋ wɛn: «Kʋkɔnyɔ, ‑mɔ nu yakɔ kɔ ‑tʋtʋ, kɔ 'yru 'hʋɛn‑, kɔ 'a ‑nɛ dɛ, ‑ɛ nɩ 'nɛ‑ 'klɔ kɩ. ");
INSERT INTO ktj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","‑Aan 'baɩ gbagbʋ bodɩɔ Dafidɩ, ‑ɛ mɔ ‑na ‑kʋannunyɔ, Dafidɩ a 'mʋ, ‑na ‑Hihiu* nu la꞊a nɩ, 'ɛ hla la꞊a, ‑ɛ mɔ: Dɛ‑ kɔ ‑tɩ dakɔ a gblegble ‑mʋ', ‑ʋ 'yɩ ‑Juukʋɛ* 'pa‑, 'ʋ 'yaa 'lɩ 'waa dɩɔnʋ, 'tɩ‑ 'ʋ pɩ yrʋ, 'ʋ yɩ ‑tɛblɩ ‑hʋɩn 'lu ‑mɔ lɛ ‑hie, 'kɩ 'ʋ Kʋkɔnyɔ ‑mɔ 'lɩ? Kɛɛ, ‑tɛblɩ a 'mʋ, ʋ 'yɩ 'lɩ 'a nunuo 'lɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","‑Tʋtʋ ‑bʋ, 'a 'blʋgbɩnaanyʋ bibi 'yi lɛ, ‑ɛ di꞊e nu, ʋ 'mʋ Kʋkɔnyɔ yɩ ‑wɔn, ɛ kɔ Wanyɔ ‑mʋ', ɛ pʋ la lɛ, ɛ di la ya 'hʋɛn‑. Kɛ‑ Dafidɩ pʋ la. ");
INSERT INTO ktj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","'Ɛ mɔ ‑tɛɛ, 'kɩ 'nɛ‑ 'dɩɔ ‑bʋ 'kwli, 'kɩɩn Helɔdɩ kɔ ‑gʋlʋnʋma Pʋsɩ Pilatɩ 'hʋɛn‑, ʋ bibi 'yi lɛ, ʋ kɔ dakɔ a nyibli ‑mʋ', ‑ʋ 'yɩ ‑Juukʋɛ 'pa‑, kɔ Yisraɛkʋɛ a ꞊tugbi 'hʋɛn‑, 'kɩ bʋ ‑wɔn ‑na ‑kʋannunyɔ ‑Yusu yɩ. Ɛ nɔ‑ ‑ha 'lɩ, 'kɩ bʋ mɔ Wanyɔ ‑mʋ', ‑pʋ la lɛ, ‑di la ya. ");
INSERT INTO ktj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kɛɛ, ‑tɛblɩ nɩ ‑do ‑mʋ', ‑mɔ 'Klɩkɩnɩnyɩsʋa, ‑hie la 'lu ‑mɔ lɛ, kɔ ‑yra la, see la a ti 'yri, ɛ nɩ ‑do a 'mʋ, ɛ nɔ‑ ʋ ‑wɛ 'lɩ bʋ nu. ");
INSERT INTO ktj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","‑Ɛ ‑bɩ ‑tɛ ti nɛ ‑bʋ, Kʋkɔnyɔ o, 'ye kɛ ‑tɩ ʋ ‑hla, ʋ wɛn: ‑A di ꞊tu 'a mʋ ꞊hɩʋɛn. 'A ‑tɩ o, ‑a mʋ ‑bʋ, ‑ʋ mɔ ‑na ‑kʋannunyibli, ‑nyi ‑a mʋ 'klɩ, ‑a 'nɩ ꞊ha hʋannʋ pie, 'kɩ ‑ba na ‑na ‑tɩ ‑mɔ lɛ. ");
INSERT INTO ktj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nu꞊o, nyibli bʋ 'ye꞊e, ‑ɛ mɔ, ‑nɩ 'klɩ kɩ. Kɔ, nu꞊o, nyibli a 'kʋɛ bʋ ‑wɛ, kɔ, ‑bʋ nu ꞊wlɩlɛkɛɛ‑tɛblɩ ‑bɩ, 'kɩ 'lɩ ‑na 'Yu ‑Yusu, ‑nyi 'klɩ a 'nyrɛ 'kwli.» ");
INSERT INTO ktj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","‑Tɛ ʋ ‑wɛ 'kɩ Nyɩsʋa a dɩda ‑mɔ, ‑ɛ ‑bɩ ‑tɛ ‑mʋ', ʋ 'kukue wɛn 'ʋ lɛ, 'a ‑tʋtʋ ‑tʋa 'hɩhlɛlɛ. ‑Ɛ ‑bɩ Nyɩsʋa a ‑Hihiu ‑mʋ', ‑ɛ nɩ 'ʋ ꞊nʋ ke', ɛ kɔɔ ꞊nʋ win kɩ pɛpɛ, 'ɛ nu꞊o, ‑Yusu a nyibli a 'mʋ, 'kɩ ʋ 'yɛ nɩ pie hʋannʋ, 'ʋ yɩ nyibli Nyɩsʋa a ‑tɩ ‑lee ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","‑Tonyibli a pɛpɛ ‑mʋ', ‑ʋ kuo ‑Yusu ꞊wlʋ yɩ, ꞊han‑tɩ 'ʋ ‑hʋ, kɛɛ, ʋ kɔ 'lulɛ‑hihie nɩ ‑do. 'Kɩ 'lɩ ꞊nʋ 'nyɩ, nyiblo ꞊dʋ 'nɩ ‑pʋ꞊ʋ lɛ, ‑ɛ mɔ, ɛ nɩ ‑do, ɛ nɔ‑ kɔ 'a kʋkɔ‑tɛblɩ, kɛɛ 'a ‑nɛ nyiblo, ‑tɛblɩ a pɛpɛ, ɛ ‑kɔ, ɛ yɩ꞊ɩ 'nɩ ꞊gla, ɛ kɔ 'a 'bio a pɛpɛ 'hʋɛn‑. ");
INSERT INTO ktj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","‑Yusu a ‑mɔnanyʋ* kɔ 'klɩ dɩakɩ, 'kɩ bʋ lee nyibli lɛ, ‑ɛ mɔ, ‑tɛ ‑Yusu 'Klɩsʋ 'kʋ, ɛ ‑hɔn 'lɩ 'kʋkʋnyibli 'nyɩ nɩ, 'ɛ 'hrɩ 'klɔ. ‑Yusu a nyibli a 'mʋ, Nyɩsʋa ni ꞊nʋ ꞊haandɛ ‑mɔ dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","'Kɩ 'lɩ ꞊nʋ 'nyɩ, nyiblo ꞊dʋ 'nɩ 'ye꞊e lɩ ꞊hɩʋɛn, ‑kɔtɩ 'a ‑nɛ nyiblo 'bʋ nɩ 'ʋ, 'bʋ kɔ ‑cio kɔ 'kayo, ɛ ple꞊e nɩ, ");
INSERT INTO ktj_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","'ɛ gbɛ 'lɩ 'a 'wliyɛ a 'mʋ ‑Yusu a ‑mɔnanyʋ ‑mɔ, ‑ɛ di꞊e nu, ʋ 'mʋ꞊ʋ nyibli lɛ ꞊gla, ꞊wɩ yɩ, ‑tɛ 'waa 'kla‑wliye'yɩya ꞊ti 'mʋ. ");
INSERT INTO ktj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ɛ kɔ nyiblo ꞊dʋ. 'A 'nyrɛ mɔ Sosɛfʋ. Lefipʋ꞊tugba* a nyiblo ꞊nɩɔ. 'Kɩ ɛ kɔ 'lɩ Sipreblʋgba 'kwli, ‑Yusu a ‑mɔnanyʋ 'ʋ ꞊tue la꞊a Banabasɩnyrɛ, ‑ɛ ꞊hɛn 'nyrɛ, ‑ɛ ꞊tui 'lɩ nyibli ꞊wlʋ 'kwli blɛ. ");
INSERT INTO ktj_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Sosɛfʋ a 'mʋ, ɛ plo 'a ‑ci ‑bɩ, 'tɩ‑, 'ɛ gba 'lɩ 'a 'wliyɛ ‑Yusu a ‑mɔnanyʋ ‑mɔ. ");
INSERT INTO ktj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ɛ kɔ la nyɩbɛyu ꞊dʋ. 'A 'nyrɛ mɔ Ananiasɩ. 'A nʋgba a 'nyrɛ mɔ Safila. Ʋ nʋ‑ plo 'waa ‑ci ‑bɩ, ");
INSERT INTO ktj_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananiasɩ 'ɛ ꞊tu 'wliyɛ a 'kʋtɩɔ ‑bɩ bʋ, 'ɛ gba 'a dɛ ‑bɩ ‑mʋ' ‑Yusu a ‑mɔnanyʋ* yɩ. 'A nʋgba yi꞊e nɩ, ‑ɛ mɔ, 'a nyɩbɩʋ ꞊tu 'wliyɛ a 'mʋ, 'a 'kʋtɩɔ ‑bɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","‑Tɛ Ananiasɩ a 'mʋ, ɛ nyre 'kɩ 'ʋ, ‑ɛ ‑bɩ Piɛlɩ wɛn: «Ananiasɩ, dɛ‑ kɔ ‑tɩ ꞊nɩ ‑ha 'kuo ‑hʋɩn* a nyiblo gbagbʋ Satan mɛ lɛ, 'ɛ kɔɔ ‑mʋ win kɩ, 'ɛ nu꞊o, ꞊nɩ ni hɩ, 'kɩ 'ʋ Nyɩsʋa a ‑Hihiu* ye', ‑ɛ mɔ, 'aan ‑ci, a plo wɛn, 'a 'wliyɛ a pɛpɛ, nɔ‑ ‑bʋ 'lɩ? Kɛɛ, ꞊tu 'a 'kʋtɩɔ ‑bɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","'Tɩ‑ ꞊mʋ ‑ci a 'mʋ plo mɔ mu, ꞊bɩ ɛ 'yɩ ‑mɔ 'pa‑, ꞊yɩ꞊ɩ ‑kɔ? 'Bɩ ‑mɔ kɔ꞊ɔ ‑o. ‑Tɛ ‑plo꞊o, ‑mɔ kɔ 'a 'wliyɛ ‑wɛ. ꞊Bɩ ɛ 'yɩ꞊ɩ 'pa‑? Dɛ‑ nu꞊o, ꞊nɩ ‑yra꞊a, 'kɩ 'lɩ ‑na ꞊wlʋ kɩ, 'kɩ ‑bʋ nu hɩdʋ ‑bʋ 'lɩ? Ɛ 'yɩ ‑tonyibli 'pa‑, ꞊yɩ ꞊nʋ hɩ lɛ ‑nuu ‑nɩ, kɛɛ, Nyɩsʋa, ɛ nɔ‑ ‑nuu hɩ lɛ.» ");
INSERT INTO ktj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","‑Tɛ Ananiasɩ 'wɩn wuntɔbʋ a 'mʋ, ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ ɛ bi ꞊hlɔn, 'ɛ 'kʋ. Ɛ nu꞊o nɩ, nyibli a pɛpɛ ‑mʋ', ‑ʋ 'wɩn ‑tɩ a 'mʋ, ʋ bi hʋannʋ' dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Gbloyɔ ‑mʋ', ‑ʋ nɩ 'ʋ, ʋ 'hɩnhɩan꞊a danʋ lɛ, 'ʋ gba꞊a, 'ʋ ‑ha 'ʋ꞊ʋ 'ʋ. ");
INSERT INTO ktj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","‑Haawɩ nɩ ta bʋ ‑hi, ‑ɛ ‑bɩ Ananiasɩ a nʋgba nyre 'lɩ 'a 'bio 'nyɩ nɩ. Dɛ ‑bʋ, ‑ɛ mu 'lu ‑mɔ, ɛ 'yɩ 'ʋ꞊ʋ ꞊dedede 'hʋɩ ‑yii ‑nɩ. ");
INSERT INTO ktj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","‑Ɛ ‑bɩ Piɛlɩ 'bɛti꞊e nɩ, ɛ wɛn: «꞊Bɩ sɛyɩ‑sɛyɩ, ‑tɛ a plo 'aan ‑ci, 'a 'wliyɛ a pɛpɛ, nɔ‑ ‑bʋ?» ‑Ɛ ‑bɩ ɛ wɛn: «Iin, 'wliyɛ a pɛpɛ, nɔ‑ ꞊nɩɔ.» ");
INSERT INTO ktj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","‑Ɛ ‑bɩ Piɛlɩ wɛn 'nɩ de: «‑Bɩ' a ‑nu, ‑kɔ ‑na nyɩbɩʋ 'hʋɛn‑, 'a ‑yra hɩdʋ ‑bʋ, ‑ɛ di꞊e nu, a 'mʋ Nyɩsʋa a ‑Hihiu 'yi ꞊tɛ 'lɩ? 'Ye kɛ, nyibli, ‑ʋ ‑ha 'ʋ ‑na nyɩbɩʋ 'ʋ, ‑tɛ ɛ 'kʋ, 'kɩ ʋ nɩ 'ʋ ꞊hʋan.yɩ. ‑Na 'mumu, ‑di 'nɩ 'kʋ ‑wɛ, ʋ 'mʋ ‑mʋ ꞊tu mɔ gba.» ");
INSERT INTO ktj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ti nɩ ‑do a ti 'yri, ‑ɛ ‑bɩ ɛ bi ꞊hlɔn, 'kɩ 'ʋ Piɛlɩ a 'mumu 'yi ꞊hlɔn, 'ɛ 'kʋ, gbloyɔ ‑nɩ wɛn, 'ʋ ‑pa. Bʋ 'ye꞊e, ‑ɛ mɔ, nʋgba a 'mʋ, ɛ 'kʋ nɩ, ‑ɛ ‑bɩ ʋ gba꞊a nɩ, 'ʋ pʋ 'ʋ꞊ʋ 'a nyɩbɩʋ 'hʋɩ bʋ. ");
INSERT INTO ktj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","'Cʋɛ a nyibli a pɛpɛ, kɔ nyibli ‑bɩ ‑mʋ', ‑ʋ 'wɩn, ʋ bi hʋannʋ' dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","‑Yusu a ‑mɔnanyʋ ni ꞊wlɩlɛkɛɛ‑tɛblɩ ‑hʋɔhʋɩ, 'kɩ 'lɩ Nyɩsʋa a 'nyrɛ 'kwli. 'Kɩ ‑Yusu a nyibli a pɛpɛ 'kukue 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli lɛ, 'kɩ 'lɩ pʋpa ‑mʋ', ʋ dɛɛ Salomɔ a pʋpa. ");
INSERT INTO ktj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nyibli ‑mʋ', ‑ʋ 'yɩ ‑Yusu ꞊wlʋ yɩ ‑kuo ‑nɩ, ʋ yɩ pie la hʋannʋ, 'kɩ bʋ bi ꞊nʋ kɩ. Kɛɛ, kɛ‑ ɛ nɩ 'mʋ, 'ʋ 'bʋa la 'waa ‑tɩ 'yi dɩakɩ. ");
INSERT INTO ktj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","‑Tonyibli ‑hʋɔhʋɩ, nʋgbɩ kɔ nyɩbɛpʋ, ʋ kuo Kʋkɔnyɔ ‑Yusu ꞊wlʋ yɩ, 'ʋ yɩ ‑Yusu a nyibli kɩ bi. ");
INSERT INTO ktj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Nyibli gbɛ la 'waa 'hʋɩhrennyʋ, 'ʋ pɩɛ la 'ʋ ꞊nʋ 'safʋɩ kɔ kʋɛ 'hʋɛn‑ kɩ blɛ, 'kɩ 'lɩ 'hrii wlɔn lɛ, ‑ɛ di꞊e nu, ti ‑mʋ' ‑kɔ 'yri Piɛlɩ di 'ʋ ‑hii mɔ di, 'a ꞊gbɛtʋ 'bʋ 'yɩ ‑ʋ ‑bɩ lɛ ‑hrɛn, 'a ‑hikɔ dadʋ 'mʋ ꞊nʋ lɛ ‑hrɛn. ");
INSERT INTO ktj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","'Dɩɩ ‑mʋ', ‑ʋ ꞊glaa 'lɩ Jrusrɛ lɛ, nʋ‑ nyibli ‑hʋɛn 'lɩ klɛ, 'ʋ yɛ 'waa 'hʋɩhrennyʋ, kɔ nyibli ‑mʋ', 'kuo ‑hʋɩn* nɩ 'ʋ ke' lɛ, 'waa pɛpɛ a 'mʋ, 'waa 'kʋɛ 'ɛ yɩ ‑wɛ. ");
INSERT INTO ktj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","‑Ɛ ‑bɩ Nyɩsʋa a ‑cɔhlʋnpinyʋ* a nyibli gbagbɩ, kɔ nyibli a pɛpɛ ‑mʋ', ‑ʋ nɩ 'ʋ꞊ʋ 'hʋɩ, ‑ʋ mɔ ꞊tumu ‑mʋ', ʋ dɛ Sadusɩ꞊tumu* a nyibli, ca 'yii 'lɩ ꞊nʋ nɩ, 'kɩ 'ʋ ‑tɛblɩ ‑mʋ', ‑Yusu a ‑mɔnanyʋ ni a ‑ta', 'ʋ ‑yra꞊a, 'kɩ bʋ nyra ꞊nʋ bʋ, ");
INSERT INTO ktj_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","'ʋ klɔ ‑Yusu a ‑mɔnanyʋ a 'mʋ, 'ʋ pʋ ꞊nʋ ꞊jɩ'. ");
INSERT INTO ktj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kɛɛ, 'tɔ', 'kɩ Nyɩsʋa a lɛlenyɔ ꞊dʋ ‑ha 'ʋ ꞊jɩkayu a 'maji lɛ, 'ɛ 'hrɔɔ ꞊nʋ, 'ɛ lee ꞊nʋ, ɛ wɛn: ");
INSERT INTO ktj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Ba mu 'lɩ Nyɩsʋa a 'kagbaʋ a ‑yaa 'kwli, ‑ɛ di꞊e 