﻿USE sofia;
DROP TABLE IF EXISTS sofia.ksr_vpl;
CREATE TABLE ksr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ksr_vpl WRITE;
INSERT INTO ksr_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Kanakanaiyanoŋ Anutunoŋ Siwe ano namo mokolooŋ orono. ");
INSERT INTO ksr_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Mokolooŋ orono namo ii gbameŋa ano kijikajuyawo ero. Ero apu aŋgoŋ dusiitawo ii paŋgamanoŋ esuuro ero. Kaeŋ ero Anutuwaa Uŋa Toroyanoŋ apu iikawaa qaganoŋ kema kaŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Kaeŋ laligoro Anutunoŋ kokaeŋ jeŋ kotoro: “Asasaga mono asugiwa.” Kaeŋ jeŋ kotoro gomaŋ mono asariro. ");
INSERT INTO ksr_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Asariro iiro awaa kolooro asasaga ano paŋgamaŋ mendeema orono. ");
INSERT INTO ksr_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Asasagaa qata weeŋ ano paŋgamambaa qata gomantiiŋa kaeŋ oroono. Kaeŋ oroono weemboria mutuya tegoro gomaŋ tiiŋ ano. ");
INSERT INTO ksr_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ano Anutunoŋ kokaeŋ jeŋ kotoro: “Mono apu batugianoŋ sombimbaa jawo kotiga asugiŋ apu mendeeno eugeŋ ano emugeŋ ewao.” ");
INSERT INTO ksr_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Kaeŋ jeŋ kotoŋ sombimbaa jawo kotiga mokolooŋ iikanoŋ apu mendeeno deema jawo qaganoŋ eugeŋ ano jawo baatanoŋ emugeŋ eri. Kaeŋ kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Anutunoŋ sombimbaa jawo kotiga eugeŋaa qata sombiŋ qaro. Kaeŋ qaro weemboria woiya tegoro gomaŋ mombo tiiŋ ano. ");
INSERT INTO ksr_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ano Anutunoŋ kokaeŋ jeŋ kotoro: “Apu sombiŋ baatanoŋ ejuti, ii mono meŋ kululuugi tuuŋ motooŋgo kolooro namo toboga asugiwa.” Kaeŋ jeŋ kotoro mono kaeŋ asugiro. ");
INSERT INTO ksr_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kaeŋ asugiro tobogaa qata namo qama apu tuuŋ somata kululuugiti, iikawaa qata kowe oroono. Orooma iriiro iikanoŋ mono awaa kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Awaa kolooro kokaeŋ jeŋ kotoro: “Namo qaganoŋ mono iwoi toŋgoŋa kuuya kokaeŋ asugiŋ waabu: Loloo gbojoja iwoi kogiawo ii mono asugiŋ waama kuuŋ sogoŋkebu. Gere kasa tanigia kania kania mono namonoŋ asugiŋ hoŋgia kogiawo kuuŋ sogoŋkebu.” Kaeŋ jeŋ kotoro mono kaeŋ asugiro: ");
INSERT INTO ksr_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Namo qaganoŋ iwoi toŋgoŋa kuuya asugiŋ waagi. Loloo gbojoja iwoi kogiawo tanigia kania kania ii asugigi. Gere kasa tanigia kania kania ii namonoŋ asugiŋ hoŋgia kuuŋ sogogi. Kaeŋ asugiro Anutunoŋ iŋiiro iikanoŋ mono awaa kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Weemboria karooŋa tegoro gomaŋ mombo tiiŋ ano. ");
INSERT INTO ksr_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ano Anutunoŋ kokaeŋ jeŋ kotoro: “Sombimbaa jawo kotiganoŋ mono asasaga asugiŋ weeŋ ano gomantiiŋa ii mendeema oroma nama (yara) yambu, koŋuru kambaŋ ano weeŋ kambaŋ, gbani kambaŋ ano weemboria motomotoombaa aiweseyaga ewu. ");
INSERT INTO ksr_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Iikanoŋ mono sombimbaa jawo kotakota kanoŋ asasaga ano namo meŋ asariwu.” Kaeŋ jeŋ kotoro mono kaeŋ asugigi: ");
INSERT INTO ksr_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Anutunoŋ asasaga somata woi mokolooŋ orono: Asasagaa galeŋa weeŋ jaaya nano iikawaa kamakamaata koiŋ ii gomantiiŋaa galeŋaga nama eŋ ubao. Seŋgelao ii kaaŋiadeeŋ mokolooŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Anutunoŋ ii sombimbaa jawo kotiga iikanoŋ namo meŋ asariwutiwaajoŋ oŋoono. ");
INSERT INTO ksr_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Ii namo meŋ asariŋ weeŋ ano gomantiiŋaa galeŋgiaga nama asasaga ano paŋgamaŋa mendeema orombutiwaajoŋ oŋoono. Kaeŋ asugiro Anutunoŋ iŋiiro iikanoŋ mono awaa kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Weemboria 4:ya tegoro gomaŋ mombo tiiŋ ano. ");
INSERT INTO ksr_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ano Anutunoŋ kokaeŋ jeŋ kotoro: “Apu kowe iikawaa uutanoŋ mono iwoi isiŋosoŋgiawo asugiŋ sokoma apu qeŋ kondondoŋgoŋ laŋ kema kaŋ laligowu. Kaaŋiadeeŋ kooŋa kooŋa namo qaganoŋ kanakeewaŋ elelaoŋ kotoŋ kema kaŋ laligowu.” ");
INSERT INTO ksr_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Kaeŋ jeŋ kowewaa oroya somasomata ano iwoi isiŋosoŋgiawo tanigia kania kania apu qeŋ kondondoŋgoŋ qeqelala kema kaŋkejuti, ii mokolooŋ oŋono. Kaaŋagadeeŋ kooŋ tanigia kania kania eŋgaŋgiawo ii mokolooŋ oŋono. Mokolooŋ oŋoma iŋiiro iikanoŋ mono awaa kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Awaa kolooro kotuegoŋ oŋoma qaa kokaeŋ jeŋ kotoro: “Oŋo mono ko meragiawo juma seiŋ apu kowe sokoma laligowu ano kooŋ oŋo mono kaaŋiadeeŋ namo qaganoŋ kolooŋ seiwu.” ");
INSERT INTO ksr_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Qaa kaeŋ jeŋ kotoro weemboria 5:ya tegoro gomaŋ mombo tiiŋ ano. ");
INSERT INTO ksr_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ano Anutunoŋ kokaeŋ jeŋ kotoro: “Namo qaganoŋ mono iwoi kuuya laaligogiawo tanigia kania kania asugiwu. Miriwaa oroya, iwoi bagianoŋ koma kondondoŋgoŋkejuti ano duuyaa oroya tanigia kania kania, ii mono asugiwu.” Kaeŋ jeŋ kotoro mono kaeŋ asugigi: ");
INSERT INTO ksr_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Anutunoŋ duuyaa oroya tanigia kania kania ii mokolooŋ oŋono. Miriwaa oroya tanigia kania kania ii mokolooŋ oŋono ano iwoi kuuya bagia namonoŋ koma kondondoŋgoŋkejuti, tanigia kania kania ii mokolooŋ oŋono. Mokolooŋ oŋoma iŋiiro iikanoŋ mono awaa kolooro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Kawaa gematanoŋ Anutunoŋ kokaeŋ jeŋ kotoro: “Ayo, anana mono eja ananaa tani kaaŋa meniŋ iwoi kuuya galeŋ koma oŋoma laligowa. Iwoi kuuya ii kowewaa soraya, sombimbaa kooŋa ano miriwaa oroya, namo kuuya ano iwoi kuuya bagia namonoŋ koma kondondoŋgoŋkejuti, mono iyoŋoo galeŋgiaga kolooŋ laligowa.” ");
INSERT INTO ksr_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Kaeŋ jeŋ kotoŋ iyaŋaa kaitaniaa so eja mokolooro. Anutuwaa kaitania kaaŋa laligowaatiwaajoŋ ii mokolooŋ muro. Eja ano emba laligowaotiwaajoŋ ii mokolooŋ orono. ");
INSERT INTO ksr_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Mokolooŋ oroma ii kotuegoŋ kokaeŋ jeŋ kotoŋ orono: “Oro mono gbili mokoloori kolooŋ seiŋ ama baloŋ sokoma laligowu. Kaeŋ laligoŋ baloŋ toya koloowu. Kaeŋ kolooŋ kowewaa soraya, kanakeewambaa kooŋa ano oro mokoleŋ lagiso buubuu namonoŋ kema kaŋkejuti, mono ii kuuya galeŋ koma poŋgia kolooŋ laligowu.” ");
INSERT INTO ksr_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Kaeŋ jeŋ kotoŋ qaa kokaeŋ irijoro: “Mobu, niinoŋ monjaŋ logoya kania kania baloŋ kuuya sokoma asugiŋ waama kogia kuuŋ sogoŋkejuti ano gere kasa kuuya hoŋ kogiawo kuuŋ sogoŋkejuti, iikanoŋ nembanenegia koloowaatiwaajoŋ anjeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Duuyaa oroya kuuya, kanakeewambaa kooŋa kuuya ano iwoi kuuya namonoŋ kema kaŋkejuti ano tosia kuuya sewaŋ aasoŋ horoŋkejuti, iyoŋoojoŋ loloo gbojoja toŋgoŋa kania kania ii nenegia koloowaatiwaajoŋ anjeŋ.” Qaa kaeŋ jero mono kaeŋ asugiro. ");
INSERT INTO ksr_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Asugiro Anutunoŋ iwoi kuuya mokolooroti, ii iiro awaa totooŋ kolooro keraqeeaŋgo moro. Weemboria 6:ya tegoro gomaŋ mombo tiiŋ ano. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Gomaŋ ano siwe jakeya jakeya ano namo yoroo iwoigara akadamugarawo kuuya ii mono mokolooŋ oŋondabororo. ");
INSERT INTO ksr_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Anutunoŋ gawoŋa ii mero tegoro weemboria 7 iikanoŋ kendoŋ raro. Gawoŋa kuuya merotiwaajoŋ weemboria 7 kanoŋ haamo mero. ");
INSERT INTO ksr_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Mokomokoloo gawoŋa kuuya merotiwaajoŋ ama weemboria iikanoŋ haamo mero. Kawaajoŋ weemboria 7:ŋa ii kendoŋ jeŋ kotuegoŋ jeŋ kobooro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Anutunoŋ siwe namo mokolooro asugiritiwaa sunduya ii kiaŋ. Poŋ Anutunoŋ siwe namo mokolooŋ oronoti, kambaŋ iikanoŋ ");
INSERT INTO ksr_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","6","Poŋ Anutuwaa uuaiŋaajoŋ namo qaganoŋ koŋ mende kiro gawoŋ komakoomowaajoŋ eja moŋ mende laligoroto, namo uutanoŋa bedu iikanoŋadeeŋ kouma namo qaga sokoma meŋ samoriro. Kawaajoŋ duuyaa gere kasa moŋ me sombembaa loloo gbojoja iwoi moŋ ii namonoŋ mende asugiŋ ero. ");
INSERT INTO ksr_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Kambaŋ kanoŋ Poŋ Anutunoŋ baloŋ sububuŋ meŋ iikanoŋ eja meŋ yagoŋ laaligowaa buu aasoŋa sewaŋanoŋ upipiiro kemero horoŋ gbiliŋ laaligowaa uŋayawo kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Kaeŋ kolooro Poŋ Anutunoŋ weeŋ koukoutanoŋ baageŋ gomaŋ qata Eeden kanoŋ oyaŋboyaŋ gawoŋ (paradais) komoma eja mokolooroti, ii iikanoŋ oono laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Oono laligoro jeŋ kotoro namonoŋga gere tanigia kania kania asugiŋ waagi. Gere ii iimasiiŋsiiŋgiawo kolooro hoŋgia neneya ii naaŋgiawo. Oyaŋboyaŋ gawoŋ biiwianoŋ laaligo kotigaa geria ano momakootowaa geria ii motooŋ jeŋ kotoro asugiri. Momakootowaa geriaa kania ii kokaeŋ: Hoŋa neŋ iikanoŋ awaa ano bologa iikawaa kania ii moma kotowaobo. ");
INSERT INTO ksr_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Gere kaaŋ waagi apu moŋ ii Eedenoŋa kanaiŋ oyaŋboyaŋ gawoŋ kotoŋ kelekele meŋ iikanoŋadeeŋ kamaaŋ juma apu boria gowoya 4 kolooŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Apu gowoya mutuyaa qata Piison, ii Hawila baloŋ kuuya liligoŋ eŋ kenja. Baloŋ kanoŋ goul eja. ");
INSERT INTO ksr_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Baloŋ iikawaa goulya ii awaa soro kolooja. Selemoroŋ uŋkoowayawo qata bedelion ano jamo hoŋawo qata oniks ii kaaŋagadeeŋ iikanoŋ ejao. ");
INSERT INTO ksr_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Apu gowoya woiyaa qata Giihon. Ii (Mesopotemiawaa) baloŋ qata Kuus ii kuuya liligoŋ kenja. ");
INSERT INTO ksr_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Apu gowoya karooŋaa qata Taigris. Ii Assiria baloŋ batanoŋ weeŋ koukoutanoŋ baageŋ kemeŋ kenja. Apu gowoya jaŋgo 4 iikawaa qata ii Yufreitis. ");
INSERT INTO ksr_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Kaeŋ kolooro Poŋ Anutunoŋ eja wama oyaŋboyaŋ gawoŋ Eeden koma komoma galeŋ kombaatiwaajoŋ jeŋ oono. ");
INSERT INTO ksr_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ooma kokaeŋ jeŋ kotoŋ muro: “Oyaŋboyaŋ gawoŋ uutanoŋ gere kuuya nama kenjuti, iyoŋoo hoŋgia ii saanoŋ afaaŋgoŋ meŋ neŋ laligowa. ");
INSERT INTO ksr_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Kaento, momakootowaa gere hoŋa ii mono mende newa. Ii neŋ awaawaa kania ano bologaa kania moma kotowagati eeŋ, gii mono weemboria iikanoŋadeeŋ koomu kotiga komuwaga. Kawaajoŋ ii mono mende newa.” ");
INSERT INTO ksr_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Kaeŋ jeŋ Poŋ Anutunoŋ jero: “Eja aŋodeeŋ laligoro awaa mende kolooja. Kawaajoŋ nii mono iyaŋa kaaŋa ala-ilailaaya mokoloomaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Kaeŋ jeŋ duuyaa oro kuuya ano kanakeewambaa kooŋ kuuya ii namonoŋ mokolooŋ oŋoma ejawaa kosianoŋ uŋuama ejanoŋ qagia nomaeŋ qabaati, ii iima mobaatiwaajoŋ iwaa baatanoŋ oŋoono. Oŋoono ejanoŋ iwoi laaligogiawo kuuya iyoŋoo qagia motomotooŋ qaro Anutunoŋ kaeŋ ewaatiwaajoŋ jeŋ kotiiro. ");
INSERT INTO ksr_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Kaeŋ kolooro ejanoŋ miriwaa oro kuuya, kanakeewambaa kooŋ kuuya ano duuyaa oro kuuya ii qagia qadabororo. Qadaboroto, iyaŋa kaaŋa ala-ilailaaya laligowaatiwaajoŋ moŋ mende mokolooro. ");
INSERT INTO ksr_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Mende mokolooro Poŋ Anutunoŋ kaeŋ iima kotoŋ eja meŋ bimooro komunagbiili gaoŋ ero. Ero maroŋ siita moŋ horoŋ siitaa duŋa busuyanoŋ meŋ kojaŋgiro. ");
INSERT INTO ksr_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Kojaŋgiŋ maroŋ siita ejawaanoŋga meroti, iikanoŋ emba mero. Meŋ nama ejawaanoŋ wama karo. ");
INSERT INTO ksr_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Wama karo ejanoŋ ii iima kokaeŋ jero: “Yai! Koi neenaa taninaga. Iwaa sii busuya ii neenaa sii busunoŋga asugija. Anutunoŋ ii ejawaa sele kitianoŋga mero letoma eja tani kaaŋa laligojiwaajoŋ qata emba (= ejawaa alia) qabu.” ");
INSERT INTO ksr_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Kaeŋ jero Anutunoŋ jeŋ kotoŋ orono: “Kaeŋ kolooro ejanoŋ mono nemuŋmaŋa oromesaoŋ embiawo qokotaaŋ selemotooŋgo kolooŋ laligowao.” ");
INSERT INTO ksr_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Eja iikanoŋ embiawo opo surugara qaa bombolaŋ laligorito, kileŋ iyaŋgaraajoŋ gamugara mende moma laligori. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Poŋ Anutunoŋ namowaa oro laaligogiawo kuuya mokolooŋ oŋonoti, iyoŋoo batugianoŋ mokolenoŋ osoŋkakale momonoŋ oro kuuya uŋuuguŋ uro. Kaeŋ uma emba kokaeŋ ijoro: “Oyaŋboyaŋ gawonoŋ gere kuuya nama kenjuti, iyoŋoo hoŋgia moŋ mende newaotiwaajoŋ Anutunoŋ oŋanoŋ jeŋ kotoŋ orono me qaago?” ");
INSERT INTO ksr_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Kaeŋ ijoro embanoŋ meleema mokoleŋ kokaeŋ ijoro: “Oyaŋboyaŋ gawonoŋ gere tosia nama kenjuti, iyoŋoo hoŋgia ii saanoŋ newotiwaajoŋ jero. ");
INSERT INTO ksr_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Jeroto, gawoŋ biiwianoŋ gere moŋ nanji, iikawaa hoŋa ii neŋ komuwobotiwaajoŋ mono kokaeŋ jero: ‘Ii mono mende newao. Ii mende oosiriwao.’ Kaeŋ jeŋ kotoŋ norono laligojo.” ");
INSERT INTO ksr_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Kaeŋ meleema jero mokolenoŋ emba kokaeŋ ijoro: “Ii awawi totooŋ! Oro mende komuwaota. ");
INSERT INTO ksr_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kaento, gere iikawaa hoŋa neri weemboria iikanondeeŋ mono jaagaranoŋ tooro Anutu kaaŋa kolooŋ awaawaa kania ano bologaa kania moma kotowaota. Anutunoŋ kaeŋ koloowabotiwaajoŋ moma qaa kaeŋ jero.” ");
INSERT INTO ksr_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Kaeŋ ijoro embanoŋ gere ii uuŋ iigigiiro hoŋa awaa nenetaa so kolooro. “Ii iima-aiŋaiŋawo nano momakooto somata afaaŋkota nombaa,” kaeŋ romoŋgoŋ hoŋa moŋ metogoŋ nero. Neŋ loya iwo laligoroti, ii kaaŋiadeeŋ muro nero. ");
INSERT INTO ksr_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Nero jaagaranoŋ mono iikanondeeŋ tooro bombolaŋ laligoriti, ii iima kotoŋ aori. Kaeŋ iima kotoŋ aoŋ nama fig gerewaa seŋa memburatiŋ opo suru kaaŋa uuŋ lama rari. ");
INSERT INTO ksr_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Rari weeŋ jaaya kemero gomaŋ gooriro Poŋ Anutunoŋ oyaŋboyaŋ gawonoŋ riiŋ karo kana otoŋa mori. Ii moma loemba yoronoŋ Poŋ Anutuwaa jaasewaŋanoŋga kokomomola meŋ oyaŋboyaŋ gawombaa gere uugianoŋ kema asaŋgori. ");
INSERT INTO ksr_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Asaŋgorito, Poŋ Anutunoŋ Aadambaajoŋ kokaeŋ qaro, “Gii dakanoŋ laligojaŋ?” ");
INSERT INTO ksr_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Kaeŋ qaro kokaeŋ meleeno: “Gii oyaŋboyaŋ gawoŋ uutanoŋ riiŋ kana goo kana otoŋga moma selena bombolaŋ rajeŋiwaajoŋ toroko mojeŋ. Kawaajoŋ kokomomola meŋ asaŋgojeŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Kaeŋ meleeno kokaeŋ ijoro: “Gii bombolaŋ laligojaŋi, ii moronoŋ gijoro mojaŋ? Nii gere mombaa kota newabotiwaa soŋgo ama gombeti, gii iikanoŋa moŋ nejaŋa me qaago?” ");
INSERT INTO ksr_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Kaeŋ ijoro ejanoŋ jero: “Emba niwo laligowaatiwaajoŋ nonati, iinoŋ gere iikawaa kota nono nejeŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Kaeŋ ijoro Poŋ Anutunoŋ emba kokaeŋ qisiŋ muro: “Gii mono naambaajoŋa kaeŋ anjaŋa?” Qisiŋ muro kokaeŋ meleeno: “Mokolenoŋ niijoŋgoro nejeŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Kaeŋ meleeno Poŋ Anutunoŋ mokoleŋ kokaeŋ jeŋ muro: “Kaeŋ anjaŋiwaajoŋ ama gii mono miriwaa oro kuuya ano duuyaa oro kuuya yoŋoo batugianoŋ kokaeŋ jeŋ qasuaaŋ gombe laligowa: Gii mono namonoŋ laligowagatiwaa so baganoŋ kondondoŋgoŋ kema kaŋ sububuŋ uutanoŋ laligoŋ kikisi iwoi neŋkeba. ");
INSERT INTO ksr_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Kaeŋ neŋ embawo batugaranoŋ kere ama orombe ii moma laligowaga. Kere ii goo gbiliuruga ano iwaa gbiliuruta yoŋoo batugianoŋ toroqeŋ eŋ uro kokaeŋ koloowaa: Yoŋoonoŋga eja moŋnoŋ goo waŋga rinjaŋgoro gii iwaa kana gbakoyanoŋ kiŋkebaga.” ");
INSERT INTO ksr_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Toroqeŋ emba kokaeŋ jeŋ muro: “Gii koro ama laligona masu guro siimbobolo somata gombe ii moma merabora oŋomakebaga. Ii kileŋ naaŋga mono logaageŋ eŋ gono iinoŋ galeŋga kolooŋ laligowaa.” ");
INSERT INTO ksr_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Toroqeŋ eja kokaeŋ jeŋ muro: “Nii gere mombaa hoŋa newabotiwaajoŋ ‘Ii mende newa,’ jeŋ soŋgo ama gombeto, giinoŋ kileŋ embagaanoŋ qaa otaaŋ nejaŋa. Kawaajoŋ nii namo ii goojoŋ ama seigowe ewaa. Kaeŋ ero gii namonoŋ laligowagatiwaa so mono ureŋ aoŋ siimbobolo moma gawoŋ mamaga meŋ nenega mokolooŋ laligowa. ");
INSERT INTO ksr_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Gawoŋ meŋ laligona goo nene gawonoŋ joŋ kowororo iwoi ii kouro duuyaa logoya iwoi neŋ laligowa. ");
INSERT INTO ksr_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kaeŋ laligoŋ nogo ariŋ gawoŋ mena gbamo yakaga hoŋa kolooro neŋ laligowa. Kaeŋ laligowagato, namonoŋ meŋ gombetiwaajoŋ namo iikanondeeŋ mombo eleema kemeba. Selega sububunonoŋ meŋ gombeta laligoŋ umago mono mombo sububuŋ koloowaga.” Kaeŋ jeŋ muro. ");
INSERT INTO ksr_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ejanoŋ embia iwoi kuuya laaligogiawo laligojuti, iyoŋoo nemuŋgia kolooro ejanoŋ qata Iiw (Eewa) qaro. ");
INSERT INTO ksr_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Poŋ Anutunoŋ oro selianoŋ opo suru meŋ Aadam embiawo lama orono laligori. ");
INSERT INTO ksr_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Kaaŋa laligori Poŋ Anutunoŋ kokaeŋ jero: “Yai! Ejemba ii nonoonoŋga mombaa so kolooŋ awagaa kania ano bologaa kania mendeema orombaotiwaajoŋ mojao. Kaeŋ kolooro laaligo kotigaa gere kota mende newaotiwaajoŋ soŋgo ambeto, yoronoŋ kambaŋ kokaamba toroqeŋ borogara boraama ii kaaŋagadeeŋ meŋ neŋ iikaaŋanoŋ mende komuŋ tetegoya qaa kotiiŋ laligoŋ ubaobo.” ");
INSERT INTO ksr_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kaeŋ jeŋ kawaajoŋ oyaŋboyaŋ gawoŋ Eeden iikanoŋa konjoma oroma namonoŋa meŋ oronoti, mono namo iikanoŋadeeŋ komakoomo gawoŋ mewaotiwaajoŋ wasiŋ orono seleeŋgeŋ kemeŋ keni. ");
INSERT INTO ksr_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ejemba kaeŋ konjoma oroma oyaŋboyaŋ gawoŋ Eedembaa leegeŋanoŋ weeŋ koukoutanoŋ baageŋ zerubim gajoba tosaaŋa kuuŋ oŋono laaligo kotigaa gere iikawaa kania utuŋ galeŋ koŋgi. Yoŋoo borogianoŋ manjawaa sooya somata ano iikanoŋ gere bolaŋ kaaŋa bilibiliawo jeŋ batanoŋ gematanoŋ liligoŋ bilisikwaa so kolooro nama galeŋ koma laligogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Aadamnoŋ embiawo laligoŋ agimiŋ aori Iiwnoŋ (Eewa) koro ama Kein (Kain) mero. Meŋ Kein qawaajoŋ kokaeŋ jero: “Anutunoŋ ilaaŋ nono merana mejeŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Iiwnoŋ kanageŋ Aadambaa meria Aabel, Keimbaa koga mero. Aabelnoŋ laligoŋ somariiŋ lama galeŋgiaga kolooro Keinoŋ komakoomo ejaga kolooŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Kaeŋ laligori kambaŋ moŋnoŋ Keinoŋ gawonoŋa nene tosia meŋ kaŋ Pombaajoŋ siimoloŋ ooŋ muro. ");
INSERT INTO ksr_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Aabelnoŋ kaaŋagadeeŋ lama tuuŋanoŋa mutu kolokolooya moŋ meŋ kaŋ qeŋ kitia kelegawonoŋ Pombaa siimoloŋ ooro. Ooro Poŋnoŋ Aabel aŋa ano iwaanoŋ siimoloŋ iima moro naaŋawo kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","‘Naaŋawo kolooroto, Poŋnoŋ Kein ano iwaanoŋ siimoloŋ ii iima togoro. Kaeŋ kolooro Keimbaa iriŋa soono uuta katitigoro jaasewaŋanoŋ bosoleero. ");
INSERT INTO ksr_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Bosoleero Poŋnoŋ Kein kokaeŋ ijoro. “Iriŋga mono naambaajoŋ soono jaasewaŋganoŋ bosoleeja? ");
INSERT INTO ksr_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Gii iwoi awaa ana meŋ aŋaliŋ gombe saanoŋ jaasewaŋga hak otaambaga me qaago? Iwoi awaa mende ana siŋgisoŋgowaa Toyanoŋ mono uugaa naguyanoŋ nama koumambaajoŋ awelegoŋ embomakeja. Kaeŋ embomakejato, gii mono iikawaa soŋgo ama galeŋ meŋ haamo amba.” ");
INSERT INTO ksr_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Poŋnoŋ Kein kaeŋ ijoroto, Keinoŋ kileŋ koga Aabel kokaeŋ ijoro: “Mono kana anorodeeŋ gawonoŋ kembo.” Kaeŋ ijoro gawonoŋ kema Keinoŋ luguŋ koga Aabel qelanjiŋ meŋ qero komuro. ");
INSERT INTO ksr_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Komuro Poŋnoŋ Kein kokaeŋ qisiŋ muro: “Koga Aabel ii dakanoŋ laligoja?” Qisiŋ muro kokaeŋ meleeno: “Nii mende mojeŋ. Nii konaa galeŋa qaago.” ");
INSERT INTO ksr_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Kaeŋ meleeno Poŋnoŋ ijoro: “Gii naa iwoiga anjaŋa? Moba, kogaa sayanoŋ mono namonoŋga asugiŋ qaro mojeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Namo kokawaa qaa oota aantama kogaa saya boroganoŋga meji, niinoŋ mono kokanoŋa konjoma gombe kemba. Joramoraa aŋgonjora ii mono goo qaganoŋ ambe uja. ");
INSERT INTO ksr_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Konjoma gombe komakoomo gawoŋ mena namonoŋ moriaŋaa hoŋa aŋgoŋ koma gono baloŋ so momolagoŋ keqeleŋ ama oloŋ koma laŋ kema kaŋ laligowa.” ");
INSERT INTO ksr_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kaeŋ jero Keinoŋ Poŋ kokaeŋ ijoro, “Qaanaa iroŋa meleena qananoŋ uji, iikanoŋ mono esuŋna uuguŋ bimooro bosimambaajoŋ amamaamaŋa. ");
INSERT INTO ksr_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Moba, gii kete nii gawoŋqeqe balonoŋa notaana jaasewaŋganoŋa momolagoŋ baloŋ so keqeleŋ ama oloŋ koma laŋ kema kaŋ laligomaŋa. Kawaajoŋ moŋnoŋ nii niima afaaŋgoŋ nuro komumambo.” ");
INSERT INTO ksr_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Kaeŋ ijoroto, Poŋnoŋ kokaeŋ jero moro: “Kaeŋ qaago! Moŋnoŋ Kein qero komuwaati eeŋ, iikawaa iroŋa mono iwaa qaganoŋ uro ambeŋa 7 koloowaa.” Kaeŋ jeŋ moŋnoŋ Kein mokolooŋ qero komuwabotiwaajoŋ selianoŋ aiwese tere moŋ ano. ");
INSERT INTO ksr_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kaeŋ ano Pombaa jaasewaŋa mesaoŋ kema kema baloŋ qata Lansaŋ ewaewaŋ (Nood) kanoŋ keuma laligoro. Baloŋ ii Eeden weeŋ koukoutanoŋ baageŋ eja. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Keinoŋ embiawo laligoŋ agimiŋ aori koro ama Henok mero. Keinoŋ taoŋ moŋ meŋ meriaa qata Henok qaro. ");
INSERT INTO ksr_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henokwaa meria qata Irad. Iradwaa meria Mehujael. Mehujaelwaa meria Metusael. Metusaelwaa meria Lamek. Kaeŋ koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameknoŋ emba woi orono: Moŋ qata Ada, moŋ qata Zila. ");
INSERT INTO ksr_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adanoŋ koro ama Jaabal mero. Iinoŋ ejemba opo sel kuuŋgianoŋ eŋ laligoŋ bao bulmakao galeŋ koma oŋoma laligojuti, iyoŋoo beŋisigia kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jaabalwaa kogaa qata Juubal. Iinoŋ ejemba gita kulele qeŋ awelo uuŋ laligojuti, iyoŋoo beŋisigia kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zilanoŋ kaaŋagadeeŋ meria qata Tuubal-Kein mero. Iinoŋ somariiŋ gawombaa tulsya ano manjaqeqewaa iwoiya kania kania ii braas ano ainoŋ ooro bolbolgoro qokotaaŋ meŋkero. Tuubal-Keimbaa naaŋa qata Nama. ");
INSERT INTO ksr_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameknoŋ kambaŋ moŋnoŋ embawoita ii kokaeŋ irijoro, “Ada ano Zila embawoina, oro mono geja ama qaana koi mobao: Moŋnoŋ nii nuŋ qijiriro iikawaa iroŋaajoŋ mono eja moŋ qewe komuwaa. Moŋnoŋ nii gbilibuuruŋ nuro sa iikawaa iroŋaajoŋ mono eja gbaworo moŋ qewe komuwaa. ");
INSERT INTO ksr_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Moŋnoŋ Kein qero iroŋa iwaa qaganoŋ uro ambeŋa 7 koloowaato, moŋnoŋ Lamek nii nuro iikawaa iroŋa mono iwaa qaganoŋ uro ambeŋa 77 koloowaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Eja mutuya Aadam iinoŋ mombo embiawo laligoŋ agimiŋ aori meragara moŋ kolooro kokaeŋ jero: “Keinoŋ Aabel qero komurotiwaajoŋ Anutunoŋ Aabelwaa kitianoŋ merana moŋ nonja.” Kawaajoŋ qata Seet (Nonja) qaro. ");
INSERT INTO ksr_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seetwaa meria kaaŋagadeeŋ kolooro qata Enos qaro. Kiaŋ. Kambaŋ iikanoŋ ejemba yoŋonoŋ kanaiŋ Pombaa qata qama kooliŋ laligogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Aadambaa esameraaŋa ano amboisiuruta yoŋoo qa areŋgia koi. Anutunoŋ eja mokolooroti, iinoŋ ii iyaŋaa kaitaniaa so mero. ");
INSERT INTO ksr_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Kaeŋ meŋ eja ano emba laligowaotiwaajoŋ mokolooŋ oroma kambaŋ kanoŋ qagara ejemba qama kotuegoŋ orono. ");
INSERT INTO ksr_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Aadamnoŋ laligoro yambuya 130 tegoro meria moŋ kolooro. Ii Aadam iyaŋaa kaitaniaa so laligoro qata Seet qaro. ");
INSERT INTO ksr_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Seet kolooro kambaŋ iikanoŋadeeŋ Aadamnoŋ toroqeŋ yambu 800 laligoŋ kouma laligoro kambaŋ batuya kanoŋ meraboraaŋa tosaaŋa kolooŋ ugi. ");
INSERT INTO ksr_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Aadamnoŋ kaeŋ laligoŋ uro yambuya mindiriŋ 930 motogoŋ komuro. ");
INSERT INTO ksr_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Komuro meria Seet iinoŋ yambuya 105 tegoro meria Enos kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enos kolooro kambaŋ iikanoŋadeeŋ Seetnoŋ toroqeŋ yambu 807 laligoŋ kouma laligoro kambaŋ batuya kanoŋ meraboraaŋa tosaaŋa kolooŋ ugi. ");
INSERT INTO ksr_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ugi Seetnoŋ laligoŋ kema kema uro yambuya mindiriŋ 912 motogoŋ komuro. ");
INSERT INTO ksr_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Komuro meria Enos iinoŋ yambuya 90 tegoro meria Keinan kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Keinanoŋ kolooro kambaŋ iikanoŋadeeŋ Enosnoŋ toroqeŋ yambu 815 laligoŋ kouma laligoro kambaŋ batuya kanoŋ meraboraaŋa tosaaŋa kolooŋ ugi. ");
INSERT INTO ksr_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ugi Enosnoŋ laligoŋ kema kema uro yambuya mindiriŋ 905 motogoŋ komuro. ");
INSERT INTO ksr_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Komuro meria Keinan iinoŋ yambuya 70 tegoro meria Mahalalel kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalalel kolooro kambaŋ iikanoŋadeeŋ Keinanoŋ toroqeŋ yambu 840 laligoŋ kouma laligoro kambaŋ batuya kanoŋ meraboraaŋa tosaaŋa kolooŋ ugi. ");
INSERT INTO ksr_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ugi Keinanoŋ laligoŋ kema kema uro yambuya mindiriŋ 910 motogoŋ komuro. ");
INSERT INTO ksr_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Komuro meria Mahalalel iinoŋ yambuya 65 tegoro meria Jared kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Jared kolooro kambaŋ iikanoŋadeeŋ Mahalalelnoŋ toroqeŋ yambu 830 laligoŋ kouma laligoro kambaŋ batuya kanoŋ meraboraaŋa tosaaŋa kolooŋ ugi. ");
INSERT INTO ksr_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ugi Mahalalelnoŋ laligoŋ kema kema uro yambuya mindiriŋ 895 motogoŋ komuro. ");
INSERT INTO ksr_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Komuro meria Jared iinoŋ yambuya 162 tegoro meria Enok kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Enok kolooro kambaŋ iikanoŋadeeŋ Jarednoŋ toroqeŋ yambu 800 laligoŋ kouma laligoro kambaŋ batuya kanoŋ meraboraaŋa tosaaŋa kolooŋ ugi. ");
INSERT INTO ksr_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ugi Jarednoŋ laligoŋ kema kema uro yambuya mindiriŋ 962 motogoŋ komuro. ");
INSERT INTO ksr_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Komuro meria Enok iinoŋ yambuya 65 tegoro meria Metusela kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Metusela kolooro kambaŋ iikanoŋadeeŋ Enoknoŋ yambu 300:waa so uuta Anutuwo somoŋgoŋ kema kaŋ laligoro kambaŋ batuya kanoŋ meraboraaŋa tosaaŋa kolooŋ ugi. ");
INSERT INTO ksr_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ugi Enoknoŋ laligoŋ uro yambuya mindiriŋ 365 motogoro. ");
INSERT INTO ksr_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Motogoŋ uuta Anutuwo somoŋgoŋ kema kaŋ laligoro Anutunoŋ eeŋ jaa seliawo mero. ");
INSERT INTO ksr_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mero meria Metusela iinoŋ yambuya 187 tegoro meria Lamek kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Kolooro kambaŋ iikanoŋadeeŋ Metuselanoŋ toroqeŋ yambu 782 laligoŋ kema kema uro kambaŋ batuya kanoŋ meraboraaŋa tosaaŋa kolooŋ ugi. ");
INSERT INTO ksr_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ugi Metuselanoŋ laligoŋ kema kema uro yambuya mindiriŋ 969 motogoŋ komuro. ");
INSERT INTO ksr_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Komuro meria Lameknoŋ yambuya 182 tegoro meria moŋ kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Kolooro qata Nooa (uluŋkoleŋ) qama kokaeŋ jero: “Anutunoŋ baloŋ seigoro nono boronananoŋ gawoŋ koma komoma seleqeqe ama siimbobolo moma laligoniŋ mera koi kanoŋ mono saanoŋ uluŋkoleŋ nonomakebaa.” ");
INSERT INTO ksr_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nooa kolooro kambaŋ iikanoŋadeeŋ Lameknoŋ toroqeŋ yambuya 595 tegoro kambaŋ batuya kanoŋ meraboraaŋa tosaaŋa kolooŋ ugi. ");
INSERT INTO ksr_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ugi Lameknoŋ laligoŋ kema kema uro yambuya mindiriŋ 777 motogoŋ komuro. ");
INSERT INTO ksr_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Lameknoŋ komuro meria Nooa iinoŋ yambuya 500 tegoro merauruta karooŋ qagia Seem, Haam ano Jaafet koloogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ejemba namo qaganoŋ laligogi jaŋgogianoŋ kanaiŋ somariiro boraurugia ii kaaŋagadeeŋ koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Koloogi kambaŋ kanoŋ Anutuwaa merauruta yoŋonoŋ ejemba yoŋoo boraurugia iŋisosoroogi. Iŋisosoroogitiwaa so ii oŋoŋgi embaurugia koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Kaeŋ koloogi kambaŋ iikanoŋ Poŋnoŋ qaa kokaeŋ jero: “Namo ejembanoŋ jaa selewo kambaŋ tetegoya qaa laligoŋ ubuto, yoŋonoŋ mono komuwu. Areŋgia kaeŋ ama oŋonjeŋ. Kambaŋ kokaamba kanaiŋ laaligogia mono yambu 120 jaŋgo ii mende uuguŋ laligoŋ ubuya.” ");
INSERT INTO ksr_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Anutuwaa merauruta yoŋonoŋ baloŋ ejemba yoŋoo boraurugia oŋoŋgi embaurugia kolooŋ merabora oŋoŋgiti, kambaŋ iikanoŋ ano kanageŋ kaaŋagadeeŋ eja damubiribirigiawo kolooŋ somariiŋ namonoŋ laligogi. Monowaa monoyanoŋga beŋurugia qabuŋawo laligogiti, iyoŋonoŋ mono ii koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Baloŋ ejemba yoŋoo kileŋagia ii somata qatawo kolooro uugiaa momo areŋgia kuuya ii kambaŋ so bologagadeeŋ suulaŋ (pororo) ama laligogiti, ii Poŋnoŋ iiro. ");
INSERT INTO ksr_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ii iima ejemba mokolooŋ oŋono namonoŋ laligogiti, iikawaajoŋ Anutunoŋ moma boliŋ wosobirinoŋ uuta saa qero siimbobolo moma laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Kaeŋ moma laligoŋ qaa kokaeŋ jero: “Ejemba mokolooŋ oŋombeti, niinoŋ mono ii balonoŋa uŋuŋ tiwilaaŋ oŋomaŋa. Ejemba, miriwaa oroya, iwoi bagianoŋ koma kondondoŋgoŋkejuti ano kanakeewambaa kooŋa mokolooŋ oŋombetiwaajoŋ moma boliŋ aoŋ ii mono uŋuŋ tiwilaaŋ oŋomaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Kaeŋ jeroto, eja Nooa iinoŋ Pombaa jaanoŋ kiaŋkoomuya mokolooŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Nooawaa gbiliuruta yoŋoo sundugia ii kokaeŋ: Merauruta karooŋ qagia Seem, Haam ano Jaafet koloogi. Nooanoŋ ejemba batugianoŋ eja solaŋa koposowaa qaaya qaa laligoŋ uuta Anutuwo somoŋgoŋ kema kaŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Nooanoŋ kaeŋ laligoroto, ejemba tosaaŋa kuuya ii Anutuwaa jaanoŋ dogoŋ bolidaborogi. Kawaajoŋ ejemba pororo uŋuŋ tiwilaaŋ oŋoŋgi, iikanoŋ baloŋ kuuya sokoma ero. ");
INSERT INTO ksr_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ejemba kuuya namonoŋ kema kaŋ laaligogia meŋ bolidaborogi gomaŋ baloŋ kuuya yoŋoo nanamemeŋgia ii dogoŋ aŋgonjorayawo kolooro Anutunoŋ namonoŋ uuŋ tanigia kaaŋa ii iiro. ");
INSERT INTO ksr_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Kaeŋ iima Anutunoŋ Nooa qaa kokaeŋ ijoro: “Ejemba yoŋoojoŋ ama uŋuŋ tiwitiwilaaŋ aoao ii namo kuuya sokoma eja. Kawaajoŋ niinoŋ ejemba kuuya meŋ komuŋ oŋomambaajoŋ qaana somoŋgowe. Moba, niinoŋ apunoŋ baloŋ meleembe kemero iwoi kuuya isiŋosoŋgiawo ii komudaborowuya. ");
INSERT INTO ksr_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Kawaajoŋ gii mono geeŋgo reeŋ gere koma kanoŋ waŋgoga mewa. Iikawaa uuta kotona uuta melamelaa koloowa. Waŋgowaa uuta ano selia ii qandonoŋ kuuŋ mokotaadaborowa. ");
INSERT INTO ksr_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Waŋgo ii kokaaŋa mewa: korigaya 133 miita (450 fiit), aaregeŋa 22 miita (75 fiit) ano koŋaya 13 miita (45 fiit) kaeŋ mewa. ");
INSERT INTO ksr_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Waareŋa mejugoŋ sopa ano waareŋ batugaranoŋ liligoŋ jeŋgenaŋ tintiŋa 44 sentimiita (18 ins) ii kotoŋ mesaowa. Waŋgowaa uuta mosona uuta qaga, batuya ano dusiita karooŋ koloowu. Waŋgo naguya ii nemuŋaageŋ amba. ");
INSERT INTO ksr_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Moba! Niinoŋ mono jewe gboulu somatanoŋ kouma baloŋ kuuya qeŋ tururo ejemba ano iwoi laaligowaa aasoŋgiawo kuuya sombiŋ baatanoŋ laligojuti, iyoŋonoŋ mono apu nemotoŋ komuwu. Kaeŋ komugi namowaa iwoiya kuuya ii mono qaondaborowuya. ");
INSERT INTO ksr_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Kaeŋ asugiwaato, niinoŋ giwo soomoŋgo areŋ kokaeŋ anjeŋ: Gii mono waŋgonoŋ uba. Gii, embaga ano mera eŋarouruga oŋonoŋ mono motooŋ waŋgonoŋ ubu. ");
INSERT INTO ksr_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Uma laligogi iwoi laaligogiawo kuuya ii qaondaborowubotiwaajoŋ yoŋoonoŋa woi woi ejia ano embia ii sogianoŋ uŋuana giwo motooŋ waŋgonoŋ ubu. ");
INSERT INTO ksr_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Kooŋ tanigia kania kania, miriwaa oroya tanigia kania kania ano namowaa mokoleŋ, lolooŋ iwoi tanigia kania kania kuuya yoŋoonoŋga woi woi ii mono komuwubotiwaajoŋ otana goonoŋ kagi waŋgonoŋ ubu. ");
INSERT INTO ksr_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Kaaŋagadeeŋ oŋoaŋgia ano kooŋ, oro iwoi kuuya yoŋonoŋ newutiwaa so mono nembanene kania kania mokolooŋ korama meŋ kululuuŋ waŋgonoŋ ana kalaŋ koŋkoŋa ewaa.” ");
INSERT INTO ksr_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Anutunoŋ Nooa kaeŋ ambaatiwaajoŋ jeŋ kotoŋ muroti, iikawaa so mono teŋ koma ii kuuya ama medabororo. ");
INSERT INTO ksr_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Nooanoŋ waŋgo medabororo Poŋnoŋ qaa kokaeŋ ijoro: “Gii ejemba tuuŋ koi yoŋoo batugianoŋ solaŋa kolooŋ laligojaŋ. Niinoŋ goo kanaga kaeŋ mokoloojeŋ. Kawaajoŋ gii ano sumaŋuruga kuuya oŋo mono waŋgonoŋ ubu. ");
INSERT INTO ksr_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Oro neneya, doŋqiziziŋgia qaa ii kuuya yoŋoonoŋa sewen sewen, ejia 7 ano embia 7:baa so oŋoona goonoŋ koubu. Kaaŋagadeeŋ oro aŋgojoragiawo kuuya yoŋoonoŋga woi woi ejia ano embia kaaŋa oŋoona goonoŋ koubu. ");
INSERT INTO ksr_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Toroqeŋ kooŋ kania kania kuuya yoŋoonoŋga kaaŋagadeeŋ sewen sewen, ejia 7 ano embia 7 ii oŋoona giwo waŋgonoŋ ubu. Kaeŋ ana oro ano kooŋ tanigia kania kania kuuya ii mende qaombuto, toroqeŋ namonoŋ kolooŋ seisei ama laligowuya. ");
INSERT INTO ksr_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ugi weemboria 7 tegoro jeŋ kotowe koŋ rombuŋ somatanoŋ mono namonoŋ kamaaro gomantiiŋa weemboria 40:waa so toroqeŋ koŋ kiwaa. Kaeŋ kiro iwoi isiŋosoŋgiawo kuuya namonoŋ mokolooŋ oŋombeti, ii mono motooŋ jeŋ tegowe qaombuya.” ");
INSERT INTO ksr_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Poŋnoŋ Nooa kaeŋ ambaatiwaajoŋ jeŋ kotoŋ muro iikawaa sogadeeŋ mono teŋ koma ii kuuya andabororo. ");
INSERT INTO ksr_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Kaeŋ ama mero Nooawaa yambuyanoŋ 600 kolooro gboulu somatanoŋ namo qaganoŋ kouro. ");
INSERT INTO ksr_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Koubaatiwaajoŋ ano Nooa embiawo ano mera eŋarourugara yoŋonoŋ motooŋ gboulunoŋ komuwubotiwaajoŋ oloŋ koma waŋgonoŋ ugi. ");
INSERT INTO ksr_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Kaaŋagadeeŋ oro neneya, doŋqiziziŋa ano oro aŋgojoragiawo ano kooŋ ano iwoi kuuya bagianoŋ koma kondondoŋgoŋkejuti, ");
INSERT INTO ksr_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ii woi woi kuuya ejia ano embia ii sogianoŋ kaŋ waŋgonoŋ Nooawaanoŋ ugi. Anutunoŋ Nooa jeŋ kotoŋ muroti, ii mono iikawaa so kolooro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Kaeŋ kolooro weemboria 7:baajoŋ jeroti, ii tegoro gboulu somatanoŋ baloŋ qaganoŋ kouro. ");
INSERT INTO ksr_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nooawaa yambuyanoŋ 600 kolooro yambu iikawaa koiŋa 2 kawaa weemboria jaŋgo 17 kanoŋ apu jaaya kuuya, apu diiŋgiawo iikawaa nemuŋgia kuuya ii emugeŋga somariiŋ boŋguŋ waagi. Kaaŋagadeeŋ eukanoŋ kanakeewambaa apuya iikawaa qaa oogia ii aantaŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Koŋ rombuŋ somata ii balonoŋ kamaaŋ kiŋ ero kema gomantiiŋa asaga 40 keno. ");
INSERT INTO ksr_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Koŋnoŋ kanaiŋ kimambaajoŋ ano weemboria kanoŋ Nooa ano merauruta Seem, Haam ano Jaafet, Nooa embiawo ano eŋarourugara karooŋ yoŋonoŋ motooŋ waŋgonoŋ udaborogi. ");
INSERT INTO ksr_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Toroqeŋ duuyaa oroya ano miriwaa oroya kuuya, iwoi kuuya bagianoŋ koma kondondoŋgoŋkejuti, kooŋ kuuya ano iwoi eŋgaŋgiawo kuuya ii ejemba yoŋowo motooŋ waŋgonoŋ udaborogi. ");
INSERT INTO ksr_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Anutunoŋ iwoi kuuya mokolooŋ oŋono laaligowaa aasoŋ horoŋkejuti, iyoŋoonoŋga woi woi (2-2) ii Nooawaanoŋ kouma waŋgonoŋ udaborogi. ");
INSERT INTO ksr_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Anutunoŋ Nooa jeŋ kotoŋ murotiwaa so iwoi isiŋosoŋgiawo kuuya waŋgonoŋ udaborogiti, ii ejia ano embia koloori. Kuuyanoŋ udaborogi Poŋ aŋo Nooawaa gematanoŋ waŋgowaa naguya kono. ");
INSERT INTO ksr_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Naguya kono iikanondeeŋ gboulu somatanoŋ kanaiŋ gomantiiŋa asaga 40:waa so toroqeŋ namonoŋ waaro. Apunoŋ somariiŋ waama baloŋ koma turuŋ uma waŋgo namonoŋa metaano uro. ");
INSERT INTO ksr_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Uro apunoŋ baloŋ qaganoŋ somariiŋ saa qeŋ ugi waŋgonoŋ apu qaganoŋ aŋodeeŋ eeŋ laŋ kema karo. ");
INSERT INTO ksr_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Kaeŋ kolooro apunoŋ baloŋ qaganoŋ mombo somariiŋ uro. Baaŋa koriga koriga sombiŋ baatanoŋ nama kenjuti, ii kuuya musuluŋgoŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Musuluŋgoŋ oŋoma uma baaŋa kuuya koma turuŋ 8 miita (25 fiit) kawaa so uŋuuguŋ ero. ");
INSERT INTO ksr_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Kaeŋ ero iwoi isiŋosoŋgiawo kuuya namo qaganoŋ kema kaŋ laligogiti, iyoŋonoŋ apu nemotoŋ komudaborogi. Iwoi kuuya ii kooŋ me miriwaa oroya me duuyaa oroya me mokoleŋ, lagiso ano iwoi kuuya tuuŋ meŋ balonoŋ qeqelala kema kaŋkejuti ano ejemba kuuya ii motooŋ qaondaborogi. ");
INSERT INTO ksr_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Iwoi kuuya baloŋ toboganoŋ laligoŋ laaligowaa aasoŋa sewaŋgianoŋ horoŋ laligogiti, ii koreyanoŋ komudaborogi. ");
INSERT INTO ksr_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Iwoi laaligogiawo kuuya namonoŋ laligogiti, ii Anutunoŋ uŋudabororo. Iwoi kuuya ii ejemba, oro me iwoi bagianoŋ koma kondondoŋgoŋkejuti me kanakeewambaa kooŋa kooŋa ii mono Anutunoŋ uŋudabororo. Nooa ano sumaŋuruta waŋgo uutanoŋ laligogiti, iyoŋogadeeŋ mono iŋiima kobooŋ aŋgoŋ koma gou gajogia kono. ");
INSERT INTO ksr_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Apu gboulu kanoŋ baloŋ qeŋ turuŋ mende horoŋ kemeroto, weemboria 150:waa so ero. ");
INSERT INTO ksr_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Weemboria 150 ii tegoro kanoŋ Anutunoŋ Nooawaa ano duuyaa oroya ano miriwaa oroya ano iwoi kuuya iwo waŋgonoŋ laligogiti, ii romoŋgoŋ oŋoma haamo somata ano namo qaganoŋ qero apunoŋ kanaiŋ horoŋ kamaaro. ");
INSERT INTO ksr_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Anutunoŋ emugeŋ apu diiŋgiawo iyoŋoo jaagia ano eukanoŋ kanakeewambaa apuya iikawaa qaa oogia ii kojaŋgiŋ soŋgo ano konoŋ riima toboriŋ sombinoŋga mombo mende kamaaro. ");
INSERT INTO ksr_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Mende kamaaro apu somatanoŋ kanaiŋ namo qaganoŋ erotinoŋa eleema horoŋ kamaaŋ kemero. Weemboria 150:waa so apunoŋ horoŋ kamaaŋ kemeŋ egi. ");
INSERT INTO ksr_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Kaeŋ egi waŋgonoŋ koiŋ 7 kawaa weemboria 17 kanoŋ baaŋa qata Ararat kawaa waŋanoŋ mokotaaŋ kotiiŋ raro. ");
INSERT INTO ksr_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Kanoŋ raro apu kanoŋ toroqeŋ horoŋ kamaaŋ kamaaŋ keno. Kema koiŋ 10 kawaa weeŋa mutuya kanoŋ baaŋa iikawaa waŋgia ii asuganoŋ asugigi. ");
INSERT INTO ksr_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Asugigi weemboria 40 tegoro Nooanoŋ waŋgowaa jeŋgenaŋa wala memeta ii metano. ");
INSERT INTO ksr_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Metama aoao kooŋ moŋ wasiro kanakeewaŋ laŋ elelaoŋ kema kaŋ mende eleema laligoro balombaa apuya kanoŋ juguro. ");
INSERT INTO ksr_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Kawaa gematanoŋ Nooanoŋ kewo moŋ wasiro keno. Namo qaganoŋ apunoŋ horoŋ kemeja me qaago, iikawaa kania momambaajoŋ ii wasiro keno. ");
INSERT INTO ksr_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Kewonoŋ kema kaŋ apunoŋ toroqeŋ baloŋ sokoma turuŋ erotiwaajoŋ haamo memeyaa raraŋa mende mokolooŋ waŋgonoŋ eleeno Nooanoŋ boria boraama meŋ waŋgo uutanoŋ oono. ");
INSERT INTO ksr_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Oono weemboria 7:baa so toroqeŋ mamboma laligoŋ kanoŋ kewo ii mombo waŋgonoŋga wasiro keno. ");
INSERT INTO ksr_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Kema mare kanoŋ eleema oil gere seŋa gbiligbili moŋ ii motogoŋ jetanoŋ kisama Nooawaanoŋ karo. Kaeŋ karo Nooanoŋ ii iima kokaeŋ moma asariro: Apunoŋ mono horoŋ kamaaro namonoŋ asugidaboroja. ");
INSERT INTO ksr_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Kaeŋ moma asariŋ mombo weemboria 7:baa so mamboma nama kewo ii mombo wasiro elelaoŋ keno. Kenoto, kambaŋ iikanoŋ ii iwaanoŋ mombo mende eleema karo. ");
INSERT INTO ksr_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nooawaa laaligo yambuya 601 kawaa koiŋ mutuyaa weemboria mutuya kanoŋ apunoŋ namo qaganoŋ juguŋ toboriŋ ero. Kaeŋ kolooro Nooanoŋ waŋgowaa waareŋa mero keno kokaeŋ uuŋ iiro: Namo qaganoŋ mono toboriŋ ero. ");
INSERT INTO ksr_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ii iiroto, mombo mamboŋgi toboriŋ koiŋ woiyaa weemboria 27 kanoŋ toboridaboroŋ ero. ");
INSERT INTO ksr_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Anutunoŋ Nooa qaa kokaeŋ ijoro: ");
INSERT INTO ksr_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Gii embagawo ano mera eŋarouruga, oŋo mono waŋgo mesaoŋ kamaawu. ");
INSERT INTO ksr_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Kamaaŋ oro iwoi laaligogiawo kuuya giwo waŋgonoŋ laligojuti, ii kooŋa kooŋa, miriwaa oroya ano mokoleŋ iwoi kuuya bagia namonoŋ koma kondondoŋgoŋkejuti, ii mono kuuya uŋuama kamaawu. Kaeŋ ana saanoŋ balonoŋ kolooŋ seisei ama deema baloŋ sokoma laligowuya.” ");
INSERT INTO ksr_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Kaeŋ ijoro Nooa embiawo ano mera eŋarouruta yoŋonoŋ motooŋ waŋgo mesaoŋ kamaagi. ");
INSERT INTO ksr_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Kamaagi duuyaa oroya kuuya, mokoleŋ iwoi kuuya, kooŋ kuuya ano iwoi kuuya namonoŋ kema kaŋkejuti, iyoŋonoŋ mono kaaŋiadeeŋ isigiaa so waŋgo mesaoŋ awaŋaoŋ kaŋ kamaadaborogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Kamaadaborogi Nooanoŋ Pombaajoŋ siimoloŋ alata moŋ meŋ miriwaa oroya doŋqiziziŋgiawo ii kuuya ano kooŋ doŋqiziziŋgia qaa ii kuuya yoŋoonoŋa tosia oŋoma alatanoŋ ama Anutuwaajoŋ siimoloŋ ooro. ");
INSERT INTO ksr_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ooro Poŋnoŋ moroŋ uŋkoowaya aiŋawo ii moro sokono uutanoŋ qaa kokaeŋ jero: “Ejemba yoŋoo uugiaa momo areŋgianoŋ mono meraboraaŋgianoŋga kanaiŋ bologa koloojuto, kileŋ namo ii kambaŋ moŋnoŋ ejemba yoŋoojoŋ ama mombo mende qasuaamaŋa. Iwoi kuuya laaligogiawo laligojuti, niinoŋ ii uŋudaboroweto, iikawaa so kambaŋ moŋnoŋ mombo mende jeŋ tegoŋ uŋumaŋa. ");
INSERT INTO ksr_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Namonoŋ eŋ ubaatiwaa so mono namonoŋ koma komogi hoŋa kolooro megi iikanoŋ mono mende qaondaborowaa. Gomaŋ olomooro saŋgoŋa momakebu ano geriawo kolooro gere tooro momakebu. Koŋuru kambaŋ ano weeŋ kambaŋ, gomantiiŋa ano asasaga ii kambaŋa kambaŋa ewaewaŋ ama awaŋaoŋ eŋ kembao. Ii kuuya tetegoya qaa eŋ uro laligowu. Kaaŋanoŋ mono kaeŋ toroqeŋ ewaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Kaeŋ jeŋ Anutunoŋ Nooa ano merauruta kokaeŋ jeŋ kotuegoŋ oŋono: “Oŋo mono kolooŋ seisei ama gomaŋ sokoma laligowu. ");
INSERT INTO ksr_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Kaeŋ aŋgi balombaa oroya kuuya, kanakeewambaa kooŋa kuuya, iwoi kuuya bagianoŋ namo koma kondondoŋgoŋkejuti ano kowewaa soraya kuuya ii mono oŋoo borogianoŋ oŋoombe oŋonoŋ ii galeŋ koma oŋoma laligogi yoŋonoŋ oŋoojoŋ keegia moma jeneŋgia ororo laligowuya. ");
INSERT INTO ksr_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Iwoi kuuya isiŋosoŋgiawo kema kaŋ laligojuti, ii oŋoo nenega kolooŋ ewaa. Wala logoya iwoi toŋgoŋa nenegiaga oŋombeta kete iwoi kuuya koi kaaŋagadeeŋ oŋonjeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Motooŋgo ii mono mende newu. Ii oro sayawo. Sa ii laaligowaa sareya koloojiwaajoŋ ama soŋgo koi ama oŋonjeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Oŋoaŋgiaa sagia ii moŋnoŋ moŋ mende maaba. Moŋnoŋ sa ii maabaati, iikawaa iroŋanoŋ mono iyaŋaa qaganoŋ ubaa. Oro moŋnoŋ me ejemba moŋnoŋ ejemba moŋ qero laaligoyaa sareya maabaati, iikawaa iroŋanoŋ mono iyaŋaa qaganoŋ uro komuwaa. ");
INSERT INTO ksr_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Anutunoŋ ejemba iyaŋaa kaitania kaaŋa merotiwaajoŋ ama moŋ moronoŋ ejemba moŋ qero komuwaati, moŋnoŋ mono ii kaaŋiadeeŋ qero komuwaa. ");
INSERT INTO ksr_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Oŋo mono kolooŋ seiŋ laligowu. Kaeŋ namo qaganoŋ kolooŋ seigi jaŋgogianoŋ somariiŋ ubaa.” ");
INSERT INTO ksr_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Anutunoŋ toroqeŋ Nooa ano merauruta iwo laligogiti, iyoŋoojoŋ qaa kokaeŋ jero: ");
INSERT INTO ksr_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Niinoŋ kete oŋo ano oŋoo kerasuru-urugia kanageŋ koloowuti, oŋowo soomoŋgo areŋ anjeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Kaaŋiadeeŋ iwoi laaligogiawo kuuya, ii miriwaa me duuyaa kooŋ oroya kuuya giwo laligoŋ waŋgonoŋa kamaajuti, mono balombaa ilawoila laaligogiawo kuuya yoŋowo soomoŋgo areŋ kokaeŋ anjeŋ: ");
INSERT INTO ksr_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Niinoŋ soomoŋgo arena ii oŋowo kokaeŋ ama kotiijeŋ: Niinoŋ apu gboulunoŋ ilawoila isiŋosoŋgiawo kuuya ii mombo mende uŋuwe qaombuya. Apu gboulu ii namo tiwilaawaatiwaajoŋ mombo mende ambe kawaa.” ");
INSERT INTO ksr_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Anutunoŋ toroqeŋ qaa kokaeŋ jero: “Niinoŋ mono soomoŋgo areŋ koi ii neenaa ano oŋo ano ilawoila laaligogiawo kuuya oŋowo laligojuti, ananaa batunananoŋ ambe tetegoya qaa kotiiŋ eŋ ubaa. Soomoŋgo areŋ iikawaa aiweseya ii kokaeŋ: ");
INSERT INTO ksr_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Niinoŋ marilolona ii koosunoŋ ambe ewaa. Niinoŋ neena ano namonoŋ laligojuti, ananaa batunananoŋ soomoŋgo areŋ anjeŋi, mariloloŋ kanoŋ mono iikawaa aiweseya kolooŋ ewaa. ");
INSERT INTO ksr_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Niinoŋ kambaŋ moŋnoŋ koosuya namo qaganoŋ horoŋ oŋombe kamaaŋ ajoroogi mariloloŋnanoŋ koosunoŋ asugiwaati, ");
INSERT INTO ksr_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","kambaŋ iikanoŋ niinoŋ soomoŋgo arena ii romoŋgomaŋa. Ii neena ano oŋo ano ilawoila laaligogiawo kuuya tanigia kania kania ananaa batunananoŋ ambeti, mono ii romoŋgomaŋa. Kawaajoŋ apu yoŋonoŋ mombo kaaŋ mende somariiŋ iwoi isiŋosoŋgiawo kuuya tiwilaawutiwaajoŋ gboulu somata mende koloowaa. ");
INSERT INTO ksr_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Kambaŋ moŋnoŋ marilolonanoŋ koosunoŋ asugiwaati, niinoŋ ii iima iikanondeeŋ soomoŋgo arena ii romoŋgomaŋa. Ii tetegoya qaa neena ano ilawoila laaligogiawo kuuya tanigia kania kania namo qaganoŋ laligojuti, ananaa batunananoŋ ama meŋ kotiiwe ewaa.” ");
INSERT INTO ksr_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Anutunoŋ Nooawaajoŋ kaeŋ jeŋ toroqeŋ kokaeŋ ijoro: “Niinoŋ soomoŋgo areŋ koi ii neena ano namowaa ilawoila laaligogiawo kuuya ananaa batunananoŋ ama meŋ kotiijeŋ. Soomoŋgo areŋ iikawaa aiweseya ii mono kiaŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nooawaa merauruta waŋgonoŋa kamaagiti, iyoŋoo qagia ii Seem, Haam ano Jaafet. Haam ii Keinambaa maŋaga. ");
INSERT INTO ksr_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Yoŋonoŋ Nooawaa merauruta karooŋ koloogi. Ejemba kuuya deeŋqeema baloŋ sokoma laligojoŋi, anana iyoŋoonoŋa kolooniŋ. ");
INSERT INTO ksr_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nooanoŋ komakoomo ejaga kolooŋ wain apu kasa gawoŋ mutuya komoro. ");
INSERT INTO ksr_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ii komoroto, kambaŋ moŋnoŋ wain apu tosia meŋ nero uuta eŋkaloloŋ kolooro iyaŋaa opo sel kuuŋ uutanoŋ opoqiisia qetegoŋ bombolaŋ ero. ");
INSERT INTO ksr_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Keinambaa maŋa Haam iinoŋ maŋanoŋ bombolaŋ eroti, ii iima seleeŋgeŋ kemeŋ daremuŋwoita irijoro moriti, iikanoŋ maŋa gamu qeŋ muro. ");
INSERT INTO ksr_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Seem ano Jaafet yoronoŋ ii morito, maleku moŋ meŋ sawiŋgaranoŋ ama gemagema uma maŋgaranoŋ bombolaŋ eroti, ii esuuri. Jaagara moŋgeŋ uuritiwaajoŋ ama maŋgaranoŋ asuganoŋ eroti, ii mende iiri. ");
INSERT INTO ksr_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nooanoŋ eŋkaloloŋa qaono uuta tororo moma waama meria meraanoŋ sili ama muroti, ii moro. ");
INSERT INTO ksr_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ii moma uuta duuro Haambaajoŋ kokaeŋ jero: “Keinan ii jeŋ qasuaaŋ mujeŋ. Iinoŋ mono daremuŋwoita yoroo weleŋqeqeurugara yoŋoo weleŋqeqegia omaya kolooŋ laligowaa.” ");
INSERT INTO ksr_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Toroqeŋ kokaeŋ jero: “Anutu, Seembaa Poŋa, ii mono mepeseejeŋ. Keinanoŋ mono Seembaa weleŋqeqeya omaya kolooŋ laligowaa. ");
INSERT INTO ksr_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Anutunoŋ mono Jaafetwaa baloŋa meŋ somariiro Seembaa opo sel kuunoŋ laligowuya. Keinan yoŋonoŋ mono Seem yoŋoo weleŋqeqeurugia omaya kolooŋ laligowu.” ");
INSERT INTO ksr_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Gboulu somatanoŋ tegoro Nooanoŋ toroqeŋ yambu 350:waa so laligoŋ uro. ");
INSERT INTO ksr_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Laaligoyaa yambuya ii mindiriŋ 950 kawaa so laligoŋ kouma komuro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nooawaa merauruta Seem, Haam ano Jaafet yoŋoo gbiliurugia gboulu tegoro koloogiti, iyoŋoo qa areŋgia kokaeŋ: ");
INSERT INTO ksr_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jaafetwaa merauruta yoŋoo qagia ii Goomer, Maagog, Maadai, Jaawan, Tuubal, Mesek ano Tiiras. ");
INSERT INTO ksr_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Goomerwaa merauruta yoŋoo qagia ii Askenas, Riifat ano Togarma. ");
INSERT INTO ksr_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Jaawambaa merauruta yoŋoo qagia ii Elisa, Tarsis ano Saiprus kanageso ano Rodos kanageso. ");
INSERT INTO ksr_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Yoŋoo esameraurugia ii juma deeŋqeema (gomaŋ leelee) Batugaranoŋ Kowe goraayanoŋ ano kowe iikawaa watoya watoya kanoŋ iyaŋgiaa baloŋgianoŋ kema laligoju. Yoŋonoŋ isigia so, tuuŋgia so ano qaagia so iyaŋgiaa gomaŋgianoŋ kema laligogi. Jaafetwaa kanagesouruta kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Haambaa merauruta yoŋoo qagia ii Kuus, Iijipt, Libia ano Keinan. ");
INSERT INTO ksr_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kuuswaa merauruta yoŋoo qagia ii Seba, Hawila, Sabta, Raama ano Sabteka. Raamawaa merawoita yoroo qagara ii Saba ano Dedan. ");
INSERT INTO ksr_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuuswaa meria moŋ qata Nimrod kolooro. Iinoŋ somariiŋ waama manjaqeqewaa kawali eja kotiga totooŋ kolooŋ namonoŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Iinoŋ Pombaa jaasewaŋanoŋ borojaŋ eja kotiga laligorotiwaajoŋ ama qaa saaŋa kokaeŋ jeŋkeju: “Moŋnoŋ Pombaa jaasewaŋanoŋ Nimrod kaaŋa borojaŋ eja kotiga kolooja.” ");
INSERT INTO ksr_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimrodwaa bentotoŋa ii baloŋ koi kaaŋanoŋ kanaigi: Baabel, Erek, Akad ano Kalne. Taoŋ 4 ii Babilonia (Sinar) gomanoŋ eju. ");
INSERT INTO ksr_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nimrodnoŋ Babilonia baloŋ mesaoŋ Assiria kema gomaŋ somasomata qagia Niiniwe, Rehobotir ano Kala ii mero. ");
INSERT INTO ksr_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Kaaŋagadeeŋ Resen ii Niiniwe ano siti somata qata Kala yoroo batugaranoŋ mero. ");
INSERT INTO ksr_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Iijiptwaa gbiliuruta yoŋonoŋ Libia (Luud) kanageso, Anam kanageso, Lehab kanageso ano Naftu kanageso kolooju. ");
INSERT INTO ksr_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Kaaŋagadeeŋ Patrus, Kaslu ano Kriit. Kriit ii Filistia kanageso yoŋoo beŋisigia kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Keinambaa meria mutuya ii Saidon. Iwaa gematanoŋ Keinanoŋ kanageso koi kaaŋa yoŋoo beŋisigia kolooro: Hit kanageso, ");
INSERT INTO ksr_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Jebus kanageso, Amor kanageso, Girgas kanageso, ");
INSERT INTO ksr_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiwi kanageso, Arka kanageso, Siini kanageso, ");
INSERT INTO ksr_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwad kanageso, Zemar kanageso ano Hamat kanageso. Keinanoŋ korebore yoŋoo wanjale beŋisigia kolooro yoŋonoŋ kanageŋ juma deeŋqeeŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kaeŋ deeŋqeeŋgi Keinan kanageso yoŋoonoŋ baloŋ goraaya ii gomaŋ qata Saidon iikanoŋa kanaiŋ kema Gerar gomanoŋ kema Gaza kanoŋ tegoja. Kaaŋagadeeŋ Sodom baageŋ kema Gomora kema Adma ano Zeboim kema Lasa kanoŋ tegoja. ");
INSERT INTO ksr_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Haambaa merauruta ii isigia so, qaagia so, baloŋgia so ano kanageso tuuŋgia so kaeŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Jaafetwaa data Seem iwaa merauruta kaaŋiadeeŋ koloogi. Seemnoŋ kaeŋ Eberwaa merauruta kuuya yoŋoo wanjale beŋisigia kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Seembaa merauruta yoŋoo qagia ii Elam, Asur, Arfaksad, Lidia (Luud) ano Aram. ");
INSERT INTO ksr_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Arambaa merauruta yoŋoo qagia ii Uuz, Huul, Geter ano Mas. Kaeŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaksadwaa meria Sela kolooro Selawaa meria Eber kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberwaa merawoita woi koloori. Moŋnoŋ kolooŋ laligoŋ kouroti, kambaŋ iikanoŋ namo ejembanoŋ juma deeŋqeeŋgi. Kawaajoŋ iwaa qata Peleg (Siiŋserereŋ) qagi. Kogaa qata ii Joktan. ");
INSERT INTO ksr_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktambaa merauruta kokaeŋ koloogi: Almodad, Selef, Hazarmawet, Jera, ");
INSERT INTO ksr_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uuzal, Dikla, ");
INSERT INTO ksr_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Oobal, Abimael, Saba, ");
INSERT INTO ksr_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Oofir, Hawila ano Joobab. Eja kuuya ii Joktambaa meraurutaga. ");
INSERT INTO ksr_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Yoŋoo rama laaligo baloŋgia ii gomaŋ qata Meesa iikanoŋa kanaiŋ gomaŋ qata Sefar kanoŋ baageŋ kema weeŋ koukoutaa baloŋ baaŋayawo kanoŋ tegoja. ");
INSERT INTO ksr_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Seembaa merauruta ii isigia so, qaagia so, baloŋgia so ano kanageso tuuŋgia so kaeŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Nooawaa esameraaŋuruta ii isigia so, kanagesogia ano baloŋgia so kaeŋ koloogi. Yoŋonoŋ juma seiŋ deeŋqeema kanageso tuuŋa tuuŋa koloogi gboulu somatanoŋ tegoro kema baloŋ sokoma laligogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Wala eeŋanoŋ baloŋa baloŋa kuuya yoŋonoŋ qaa motooŋgo jegi iikanoŋ mindiriŋ oŋono laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Kaeŋ laligoŋ mesaoŋ weeŋ koukoutanoŋ baageŋ kema Babilon uutanoŋ baloŋ koria somata moŋ mokolooŋ kanoŋ mirigia meŋ ragi. ");
INSERT INTO ksr_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Kanoŋ rama iyaŋgiodeeŋ kokaeŋ amiŋ mogi: “Mono kawu. Anana mono gbakoŋ meŋ mozozoŋgoŋ gerenoŋ ooniŋ kotakota koloowaa.” Kaeŋ jeŋ miri sopaya mewombaajoŋ jamo kowonjiŋ qaagoto, birik ama batugianoŋ namo saposapo qandoŋ kaaŋa aŋgi iikanoŋ birik ii mokotaaŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Gawoŋ kaeŋ meŋ toroqeŋ kokaeŋ jegi: “Mono kawu. Anana mono ananaajoŋ siti moŋ meŋ iikanoŋ miri koriga totooŋ (taua) meniŋ waareŋanoŋ sombiŋ oosiriwaa. Kaeŋ oosiriro mende deeŋqeema baloŋ kuuya sokoma laŋ kema laligowombotiwaajoŋ mono anana qabuŋananawo koloowoŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Kaeŋ jeŋ gawoŋ megito, Poŋnoŋ ejemba siti ano miri koriga megiti, ii iimambaajoŋ kamaaro. ");
INSERT INTO ksr_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Kamaaŋ ii iima kokaeŋ jero: “Yoŋonoŋ siiŋserereŋ qaagoto, kanatuuru areŋgia motooŋgo qaagia motooŋgo jeŋ nama iwoi koi kanaiŋ mejuti eeŋ, kanageŋ ii me woi mewombaa areŋgia ambuyati, ii mono iikawaajoŋ mende amamaaŋ osiwuya. ");
INSERT INTO ksr_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ayo, anana mono balonoŋ kemeŋ qaagia meŋ sooniŋ tuuŋ moŋ yoŋonoŋ tuuŋ tosia yoŋoo qaagia mende moma asariŋ laligowu.” ");
INSERT INTO ksr_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Poŋnoŋ kaeŋ jeŋ ejemba kanoŋ mendeqendeema oŋono gomaŋ kuuya sokoma kema kaŋ siti memewaa gawoŋa somoŋgoŋ mesaogi. ");
INSERT INTO ksr_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Poŋnoŋ ejemba kuuya yoŋoo qaagia meŋ sooroti, iikawaajoŋ gomaŋ iikawaa qata Baabel (eŋkaloloŋ sisau) jegi. Iikanoŋa Poŋnoŋ ii mendeqendeema oŋono deema baloŋ kuuya sokoma keŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Seembaa gbiliuruta yoŋoo qa areŋgia koi. Gboulu gematanoŋ yambu woi tegoro Seemnoŋ yambuya 100 tegoro kambaŋ kanoŋ meria Arfaksad kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arfaksadnoŋ kolooro kawaa gematanoŋ Seemnoŋ toroqeŋ yambu 500 laligoro kambaŋ batuya kanoŋ meraborauruta tosaaŋa koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaksadnoŋ yambuya 35 tegoro meria Sela kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Selanoŋ kolooro kawaa gematanoŋ Arfaksadnoŋ toroqeŋ yambu 403 laligoro kambaŋ batuya kanoŋ meraborauruta tosaaŋa koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Selanoŋ yambuya 30 tegoro meria Eber kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ebernoŋ kolooro kawaa gematanoŋ Selanoŋ toroqeŋ yambu 403 laligoro kambaŋ batuya kanoŋ meraborauruta tosaaŋa koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebernoŋ yambuya 34 tegoro meria Peleg kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pelegnoŋ kolooro kawaa gematanoŋ Ebernoŋ toroqeŋ yambu 430 laligoro kambaŋ batuya kanoŋ meraborauruta tosaaŋa koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelegnoŋ yambuya 30 tegoro meria Reu kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reunoŋ kolooro kawaa gematanoŋ Pelegnoŋ toroqeŋ yambu 209 laligoro kambaŋ batuya kanoŋ meraborauruta tosaaŋa koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reunoŋ yambuya 32 kolooro meria Serug kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serugnoŋ kolooro kawaa gematanoŋ Reunoŋ toroqeŋ yambu 207 laligoro kambaŋ batuya kanoŋ meraborauruta tosaaŋa koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serugnoŋ yambuya 30 tegoro meria Naahor kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Naahornoŋ kolooro kawaa gematanoŋ Serugnoŋ toroqeŋ yambu 200 laligoro kambaŋ batuya kanoŋ meraborauruta tosaaŋa koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naahornoŋ yambuya 29 kolooro meria Tera kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Teranoŋ kolooro kawaa gematanoŋ Naahornoŋ toroqeŋ yambu 119 laligoro kambaŋ batuya kanoŋ meraborauruta tosaaŋa koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Teranoŋ yambuya 70 tegoro meria Abram, Naahor ano Haran koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Terawaa gbiliuruta yoŋoo qa areŋgia koi. Terawaa merauruta Abram, Naahor ano Haran koloogi. Harambaa meria Loot kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haranoŋ Kaldia yoŋoo balonoŋ laligoŋ iyaŋaa kolokoloo gomaŋa qata Uur iikanoŋ komuro Harambaa maŋa Teranoŋ toroqeŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram ano Naahor yoronoŋ ororoŋ emba meri. Abrambaa embia qata Saarai kolooro Naahorwaa embia qata Milka. Milkanoŋ Harambaa borataga kolooro. Haranoŋ Milka ano Iska yoroo maŋgaraga. ");
INSERT INTO ksr_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saarainoŋ emba aruŋaga meria qaa eeŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Teranoŋ meria Abram, esia Loot Harambaa meria ano eŋaroya Saarai, meria Abrambaa embia ii uŋuano motooŋ Kaldia balombaa gomaŋ qata Uur mesaoŋ Keinan balonoŋ kembombaajoŋ keŋgi. Kaeŋ keŋgito, Haran gomaŋ balonoŋ kaŋ nama kanoŋ mirigia meŋ ragi. ");
INSERT INTO ksr_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ragi Teranoŋ yambuya 205 kolooro Haran gomaŋ kanoŋ rama komuro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Poŋnoŋ Abram kokaeŋ ijoro: “Gii gomaŋga, kanatuuruga ano maŋgaanoŋ miri iwoi mesaoŋ baloŋ qendeema gomaŋati, mono iikanoŋ kemba. ");
INSERT INTO ksr_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Niinoŋ kolooŋ seisei gombe gbiliuruganoŋ kanageso somata koloowuya. Niinoŋ kotuegoŋ naŋgoŋ gombe qabuŋaganoŋ somariiŋ somata koloowaa. Kaeŋ kolooro Anutu niinoŋ goojoŋ ama kanageso tosaaŋa kotuegoŋ oŋoma laligowaa. ");
INSERT INTO ksr_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Daeŋ yoŋonoŋ gii kotuegoŋ gombuti, niinoŋ mono ii kotuegoŋ oŋoma laligomaŋa. Daeŋ yoŋonoŋ gii jeŋ qasuaaŋ gombuti, niinoŋ mono ii kaaŋagadeeŋ jeŋ qasuaaŋ oŋoma laligomaŋa. Goojoŋ ama noo kotumotuenanoŋ mono namowaa kanageso tuuŋ kuuya yoŋoo qagianoŋ uro oyaŋboyaŋ mokoloowuya.” ");
INSERT INTO ksr_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Kaeŋ ijoro Abramnoŋ Poŋnoŋ jerotiwaa so Haran gomaŋ mesaoŋ keno Lootnoŋ iwo keni. Abramnoŋ yambuya 75 kolooro kanoŋ Haran gomaŋ mesaoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Kemaŋ jeŋ embia Saarai, beeta Loot, esuhinaya kuuya meŋ kululuugi seiroti ano weleŋqeqe ejemba Haran gomanoŋ laligoŋ oŋoŋgiti, ii uŋuama gomaŋgia mesaoŋ Keinan balonoŋ kembombaajoŋ kema kema iikanoŋ keugi. ");
INSERT INTO ksr_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abramnoŋ baloŋ kanoŋ kema laligoŋ gomaŋ qata Sekem kanoŋ kouma jujuu gere somata qata More kawaa kosianoŋ kuuŋ meŋ raro. Kambaŋ kanoŋ Keinan ejemba yoŋonoŋ baloŋ iikanoŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Kaeŋ laligogi Poŋnoŋ Abram asugiŋ muŋ kokaeŋ ijoro: “Baloŋ koi ii mono goo gbiliuruga buŋa qeŋ oŋomaŋa.” Kaeŋ ijoro Abramnoŋ Poŋ iwaanoŋ asugiroti, iwaajoŋ siimoloŋ ooŋoombaa alata moŋ mero. ");
INSERT INTO ksr_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Iikanoŋadeeŋ mesaoŋ toroqeŋ Beetel gomambaa weeŋ koukoutanoŋ baageŋ baloŋ baaŋawo kanoŋ kema opo sel kuuŋa mororoŋgoŋ mero nano. Kaeŋ nano Beetel gomaŋ kanoŋ weeŋ kemekemetanoŋ baageŋ raro Ai taoŋnoŋ weeŋ koukoutanoŋ baageŋ raro. Kaeŋ rari batugaranoŋ nama Pombaa siimoloŋ alata moŋ iikanoŋ meŋ Pombaa qata qama kooliŋ muro. ");
INSERT INTO ksr_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Kawaa gematanoŋ baloŋ ii mesaoŋ toroqeŋ Saut waageŋ kema distrik qata Negew kanoŋ rama laligogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kambaŋ kanoŋ Keinan balonoŋ bodi kolooro. Bodi iikanoŋ kotiiŋ biŋawo kolooro Abramnoŋ Iijipt kantrinoŋ tawayagadeeŋ laligowombaajoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Kananoŋ kema Iijipt dodowigi Abramnoŋ embia Saarai qaa kokaeŋ ijoro: “Moba, giinoŋ emba iimasiiŋsiiŋgawo koloojaŋi, ii mojeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Kawaajoŋ Iijipt eja yoŋonoŋ gii giima kokaeŋ jewuya: ‘Koi iwaa embiaga.’ Kaeŋ jeŋ nii nugi komumaŋato, gii giima koboogi laligowaga. ");
INSERT INTO ksr_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Kawaajoŋ gii mono kokaeŋ jewa: ‘Nii iwaa naaŋaga.’ Kaeŋ jenago goojoŋ ama awaagadeeŋ ama noma noo laaligona gou gajona koŋgi laligomaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abramnoŋ Iijipt keuro Iijipt ejemba yoŋonoŋ Saarai iigi emba iima-aiŋaiŋawo awaa soro kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Iikanondeeŋ Faarao kiŋ pombaa poŋ qereweŋa jawiŋuruta yoŋonoŋ ii iigitiwaajoŋ Faarao kimbaanoŋ kema Saaraiwaa selia mepeseegi moro. Ii moma jero Saarai wama kiŋ pombaa jiŋkaroŋ miri uutanoŋ ugi. ");
INSERT INTO ksr_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ugi Faarao kiŋnoŋ Saaraiwaajoŋ ama Abram awaagadeeŋ ama muro. Kaeŋ ama muro iwoi koi kaaŋa ii Abrambaa buŋa kolooro: lama, bulmakao, doŋgi ejia ano embia, weleŋqeqe eja ano emba ano kamel jaasooŋgoya ii Abram muro buŋa qeŋ aoro. ");
INSERT INTO ksr_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ii buŋa qeŋ aoroto, Poŋnoŋ Abrambaa embia Saarainoŋ Faarao kimbaa mirinoŋ laligorotiwaajoŋ ama jero ji bologa kotiganoŋ Faarao kiŋ ano ejemba iwaa jiŋkaroŋ mirinoŋ laligogiti, iyoŋoo qagianoŋ uro. ");
INSERT INTO ksr_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Kaeŋ uro Faarao kiŋnoŋ Abram koma hororo karo kokaeŋ qisiŋ muro: “Gii mono naa terega ama nona? Naambaajoŋ ‘Ii embanaga,’ kaeŋ mende jena mobe? ");
INSERT INTO ksr_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Naambaajoŋ ‘Ii noo naanaga,’ jena? Kaeŋ jena niinoŋ ii embanaga kolootiwaajoŋ oombe? Embaga koi. Mono ii wama kembao.” ");
INSERT INTO ksr_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Kaeŋ jeŋ ejauruta jeŋ kotoŋ oŋono Abram wama kananoŋ kema oŋooŋgi embia ano ilawoilaya kuuya eŋ muroti, ii meŋ uŋuama keŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abramnoŋ Iijipt baloŋ mesaoŋ embia ano bao hina iwoiya kuuya meŋ uŋuama Lootwo motooŋ eleema kema Keinan balombaa leeya Saut waageŋ qata Negew kanoŋ kougi. ");
INSERT INTO ksr_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abrambaanoŋ lama bulmakao ano goul silwa ii ambembo eŋ muro eja kindiŋbiriawo laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Kaeŋ laligoŋ Negew distrik uutanoŋ rama mesaoŋ tawayagadeeŋ rooŋqeqegianoŋ eŋ waama kema laligoŋ Beetel gomanoŋ kougi. Opo sel kuuŋa wala Beetel ano Ai gomaŋ iyoroo batugaranoŋ kuuŋ mero nanoti, mono iikanoŋ kougi. ");
INSERT INTO ksr_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Wala siimoloŋ alata meroti, mono iikanoŋ kouma Pombaa qata qamago qama kooliro. ");
INSERT INTO ksr_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lootnoŋ Abrambo rama mesaoŋ laligoroti, iinoŋ kaaŋiadeeŋ lama bulmakao tuuŋa tuuŋa ano opo sel kuuŋa kuuŋa ii mamaga meŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Kaeŋ laligoŋ oro esuhina iwoigara mamaga eŋ orono balonoŋ mende sokono. Ii motooŋ uŋuagiwaotiwaa so mende kolooro kileŋ motooŋ rama laligowotiwaajoŋ amamaari. ");
INSERT INTO ksr_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Amamaaŋ Abram ano Loot yoroonoŋ oro galeŋurugara yoŋoo batugianoŋ balombaa aŋgowowoya asugiro. Kambaŋ kanoŋ Keinan kanageso ano Periz kanageso yoŋonoŋ baloŋ iikawaa toya koloogi yoŋowo motooŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Kaeŋ laligoŋ Abramnoŋ beeta Loot kokaeŋ ijoro: “Anara mono maŋ mera laligojo. Kawaajoŋ nii ano gii batunaranoŋ me oro galeŋurunara yoŋoo batugianoŋ andoruru mono mende ewa. ");
INSERT INTO ksr_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Kawaajoŋ saanoŋ deembo. Baloŋ kuuya mono goo jaasewaŋganoŋ asuganoŋ eŋ kenji, ii saanoŋ iijaŋ. Kaeŋ ano giinoŋ qaninaraageŋ kemaŋa jewagi eeŋ, niinoŋ saanoŋ dindinaraageŋ kemaŋa. Me giinoŋ dindinaraageŋ kemaŋa jewagati eeŋ, niinoŋ saanoŋ qaninaraageŋ kemaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Kaeŋ ijoro Lootnoŋ Jordan balombaageŋ uuŋ baloŋ koria somata kuuya iiro Anutunoŋ ii awaa bedu mero Pombaanoŋ oyaŋboyaŋ urukisi kelegawo kaaŋa kolooro. Ii Iijipt yoŋoonoŋ baloŋ kaaŋa eŋ Zoar gomaŋ baageŋ keno. Wala Poŋnoŋ Sodom ano Gomora mende tiwilaaŋ orono kambaŋ kanoŋ baloŋ ii kaaŋa ero. ");
INSERT INTO ksr_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Kaeŋ ero Lootnoŋ ii iima gosiŋ Jordambaa baloŋ koria somata kuuya ii meweeŋgoŋ weeŋ koukoutanoŋ baageŋ keno. Kaeŋ ama deeni. ");
INSERT INTO ksr_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Deema Abramnoŋ Keinan balonoŋ kema laligoroto, Lootnoŋ baloŋ koria somataa taoŋa taoŋa yoŋoo batugianoŋ kema kaŋ laligoro. Kaeŋ laligoŋ opo sel kuuŋa metogoŋ meŋ kuuŋ kema nama tetegoyanoŋ Sodom kosianoŋ keuma laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Kanoŋ laligoroto, Sodom kanatuuru yoŋonoŋ kanageso bologa kolooŋ Poŋ qetama siŋgisoŋgo jekania booroŋgia ama meŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lootnoŋ Abram ooma keno kambaŋ kanoŋ Poŋnoŋ Abram qaa kokaeŋ ijoro: “Mono jaaga hak ataama bagaageŋ uuŋ waama eleema gemagaageŋ uuŋ kaaŋagadeeŋ weeŋ koukoutanoŋ ano weeŋ kemekemetanoŋ baageŋ uuwa. ");
INSERT INTO ksr_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Baloŋ kuuya koi iijaŋi, ii mono gii ano goo gbiliuruga oŋoo buŋa qewe kambaŋ tetegoya qaa buŋagiaga eŋ ubaa. ");
INSERT INTO ksr_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Niinoŋ gbiliuruga kolooŋ seisei mamaga oŋombe jaŋgogianoŋ somariiŋ namowaa sakasiŋa kaaŋa koloowaa. Moronoŋ sakasiŋ jaŋgoya weeŋgonagati, iinoŋ saanoŋ gbiliuruga yoŋoo jaŋgogia mewaa. ");
INSERT INTO ksr_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Niinoŋ baloŋ koi mono goo buŋaga qeŋ gonjeŋ. Kawaajoŋ saanoŋ waama kema kaŋ baloŋ kuuya koi bakabaka eugeŋ emugeŋ iima kotoŋ laligowa.” ");
INSERT INTO ksr_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kaeŋ ijoro Abramnoŋ waama opo sel kuuŋa qetegoŋ meŋ kuuŋ kema Hebron gomanoŋ kaŋ Mamre gomanoŋ jujuu gere somata nama keŋgiti, iikawaa kosogianoŋ raro. Kanoŋ rama Pombaajoŋ siimoloŋ alata moŋ mero. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Kambaŋ kanoŋ Babilombaa (Sinarwaa) kiŋa qata Amrafel, Elasarwaa kiŋa qata Ariok, Elambaa kiŋa qata Kedorlaomer ano Goimbaa kiŋa qata Tidal laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Yoŋonoŋ kiŋ koi yoŋowo kanaiŋ manja aogi: Sodom taombaa kiŋa qata Bera, Gomora taombaa kiŋa qata Birsa, Adma taombaa kiŋa qata Sinab, Seboim taombaa kiŋa qata Semeber ano Bela (qata moŋ Zoar) taoŋ kawaa kiŋa. ");
INSERT INTO ksr_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Kiŋ kuuya koi yoŋonoŋ dondooŋa qata Sidim kanoŋ ajorooŋ ku-usuŋgia mindiriŋ soomoŋgo aŋgi. Sidim dondooŋanoŋ kambaŋ kokaamba Sii Kowe Koomuya ii eja. ");
INSERT INTO ksr_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Yoŋonoŋ yambu 12:waa so Kedorlaomerwaa jeŋkooto baatanoŋ laligoŋ kouma yambu 13:ŋa kanoŋ iwaa qaa baatanoŋ kembombaajoŋ qotogoŋ kareŋ motoŋ manja qegi. ");
INSERT INTO ksr_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Kaeŋ aŋgi yambu 14:ŋa kanoŋ Kedorlaomer ano kiŋ tosaaŋa iwo soomoŋgo ama laligogiti, iyoŋonoŋ kaŋ kanageso koi kaaŋa yoŋowo manja qeŋ haamo aŋgi: Refa kanageso ii Asterot Karnaim gomanoŋ uŋuŋ haamo aŋgi. Zuzi kanageso ii Haam gomanoŋ ano Eme kanageso ii Kiriataim gomaŋ kanoŋ uŋuŋ haamo aŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Hoor kanageso ii Seir baloŋ baaŋawo kanoŋ uŋuŋ oŋotaaŋ kema kema El Paran gomaŋ kanoŋ keuma haamo ama oŋoŋgi. El Paran ii baloŋ qararaŋkoŋkoŋaa goraayanoŋ eja. ");
INSERT INTO ksr_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Haamo ama oŋoma iikanondeeŋ eleema En Mispat (qata moŋ Kaades) kanoŋ kaŋ Amalek kanageso haamo ama oŋoma baloŋgia kuuya aŋgoŋ koŋgi. Amor kanageso Hazezon Taamar balonoŋ laligogiti, ii kaaŋiadeeŋ uŋuŋ haamo ama oŋoŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Kaeŋ kolooro Sodombaa kiŋa, Gomorawaa kiŋa, Admawaa kiŋa, Zeboimbaa kiŋa ano Bela (qata moŋ Zoar) kawaa kiŋa yoŋonoŋ waama asasa riiŋ Sidim dondooŋanoŋ keuma kiŋ koi kaaŋa yoŋowo manja qewombaa jawoya ama aroŋ qeŋ naŋgi: ");
INSERT INTO ksr_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Elambaa kiŋa Kedorlaomer, Goimbaa kiŋa Tidal, Babilombaa (Sinarwaa) kiŋa Amrafel ano Elasarwaa kiŋa Ariok. Kiŋ 4 yoŋonoŋ kiŋ 5 yoŋowo aroŋ qegi. ");
INSERT INTO ksr_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Kaeŋ aroŋ qegito, Sidim baloŋ dondooŋa kanoŋ roŋ resa saposapoyawo kanoŋ saa qeŋ raro. Kaeŋ raro Sodom ano Gomora taoŋ yoroo kiŋ poŋgianoŋ manjaqeqe ejaurugara yoŋowo unjurama kemaligi eja tosianoŋ roŋ iikanoŋ ritooŋ kemeŋ uŋuro. Kaeŋ uŋuro alaurugia tosaaŋa kuuya yoŋonoŋ oloŋ koma unjurama baloŋ baaŋawo kanoŋ ugi. ");
INSERT INTO ksr_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ugi kiŋ 4 yoŋonoŋ Sodom ano Gomora kema esuhinagia ano nembanenegia kuuya ii leiŋ qeŋ meŋ togoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abrambaa beeta Lootnoŋ Sodom laligorotiwaajoŋ ama ii kaaŋiadeeŋ esuhinayawo wama keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Kaeŋ keŋgi eja moŋnoŋ oloŋ koma misiŋgoŋ kaŋ iikawaa buzu qaaya ii Hibruu (waba) eja Abram ijoro. Kambaŋ kanoŋ Abramnoŋ Amor eja qata Mamre iwaanoŋ jujuu gere somasomata iikawaa kosogianoŋ laligoro. Mamrenoŋ kowoita qagara Eskol ano Aner yorowo motooŋ Abrambo soomoŋgo ama laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abramnoŋ beeta Loot wama keŋgiti, iikawaa qaaya moma ejauruta 318 aŋaa mirinoŋ kolooŋ momo moma manjaqeqe koma gbiliŋ laligogiti, ii oŋoono ajorooŋ kere tuuŋ oŋotaaŋ Noot waageŋ kema laligoŋ Dan gomanoŋ keugi. ");
INSERT INTO ksr_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Abramnoŋ ejauruta mendeema oŋono yoŋonoŋ gomantiiŋa kanoŋ konjoma kere tuuŋ qelanjiŋ uŋuŋ haamo ama oŋoŋgi. Haamo ama oŋoma oŋotaaŋ kema laligoŋ Damaskaswaa Noot leegeŋ gomaŋ qata Hoba kanoŋ keugi. ");
INSERT INTO ksr_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Kanoŋ keuma esuhina kuuya leiŋ qeŋ meŋ keŋgiti, ii mokoloogi. Beeta Loot ano iwaanoŋ ilawoila ii meŋ wama eleema kagi. Sodom ano Gomora yoŋoo emba meraaŋurugia ano ejemba tosaaŋa ii kaaŋiadeeŋ kuuya uŋuama kagi. ");
INSERT INTO ksr_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abramnoŋ kaeŋ Kedorlaomer ano kiŋ tosaaŋa iwo soomoŋgo ama laligogiti, ii uŋuŋ haamo ama oŋoma eleema karo Sodombaa kiŋa iinoŋ Sawe dondooŋa (qata moŋ Kimbaa dondooŋa) kanoŋ mokolooŋ iimambaajoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Kambaŋ kanoŋ Melkizedek Saalembaa kiŋa iinoŋ bered ano wain apu meŋ karo. Iinoŋ Anutu uutaa jigo gawoŋ galeŋa kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Kaeŋ ama Abram kotuegoŋ muŋ qaa kokaeŋ ijoro: “Anutu uuta Siwe namo mokolooŋ oronoti, iinoŋ mono Abram gii kotuegoŋ gono laligowa. ");
INSERT INTO ksr_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Anutu uutanoŋ kereuruga goo boronoŋ ama oŋonoti, mono ii mepeseejoŋ.” Kaeŋ ijoro Abramnoŋ ilawoilaya kuuya mendeeno tuuŋ ten kolooro iikanoŋga motomotooŋ (10%) meŋ mamatewooya muro. ");
INSERT INTO ksr_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ii muro Sodombaa kiŋanoŋ Abram kokaeŋ ijoro: “Ejembauruna ii nombagato, esuhina ii mono geeŋgaa buŋa koloowa.” ");
INSERT INTO ksr_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Kaeŋ ijoroto, Abramnoŋ Sodombaa kiŋaajoŋ kokaeŋ jero: “Qaana kotiiwaatiwaajoŋ niinoŋ borona Poŋ Anutu uuta Siwe namo mokolooŋ oronoti, iwaanoŋ baageŋ meŋ waama jojopaŋ qaa kokaeŋ jejeŋ: ");
INSERT INTO ksr_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Nii goonoŋ iwoi moŋ ii mende totooŋ memaŋa. Beweso kasagaa kitia me kana esugaa kasia ii kaaŋiadeeŋ mende memaŋa. Kaeŋ ambe giinoŋ kanageŋ kokaeŋ jewabo: ‘Niinoŋ Abram iwoi mube iinoŋ eja esuhina qaqabuŋayawo kolooŋ laligoja.’ Gii mono kaeŋ jemambaajoŋ amamaaŋ laligowa. ");
INSERT INTO ksr_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Nii iwoi moŋ mende toroqeŋ memaŋato, ejaurunanoŋ naa iwoiga negiti, ii meleema nonoŋgi sokondaboroja. Kaaŋagadeeŋ eja alauruna Aner, Eskol ano Mamre niwo kagiti, iyoŋonoŋ mono tawagia soya jejeya mewu.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Kaeŋ ama Abrambaa jaaya meleeno jaameleŋ uŋa iiro Poŋnoŋ qaa kokaeŋ jeŋ asugiro, “Abram, gii toroko mende moba. Niinoŋ goo reeŋ koloojeŋ. Goo tawaga mono somata qatawo kolooŋ eŋ ubaa.” ");
INSERT INTO ksr_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Qaa kaeŋ ijoroto, Abramnoŋ kokaeŋ jero, “Oo Poŋ somatana, nii meraborana qaa laligowego tawa nona iikanoŋ mono nomaeŋ ilaaŋ nonaga? Niinoŋ komuwe Damaskas eja Eliezer iinoŋ noo esuhinanaa toya koloowaa.” ");
INSERT INTO ksr_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Kaeŋ jeŋ toroqeŋ kokaeŋ jero, “Giinoŋ gbili moŋ mende nonatiwaajoŋ gawoŋ ejana waŋa noo mirinoŋ laligoji, iinoŋ mono noo ilawoilana kuuya buŋa qeŋ aowaa.” ");
INSERT INTO ksr_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Kaeŋ jero Pombaanoŋ qaa je moŋ ii iwaanoŋ kokaeŋ asugiro moro, “Eja iikanoŋ esuhinagaa toya mende koloowaato, geeŋgaa seleganoŋga mera moŋ koloowaati, iinoŋ mono goonoŋ ilawoila kuuya buŋa qeŋ aowaa.” ");
INSERT INTO ksr_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Qaa kaeŋ asugiro Anutunoŋ Abram wama seleeŋgeŋ kemeŋ qaa kokaeŋ ijoro, “Mono sombinoŋ uuna uro seŋgelao weeŋgoŋ oŋombaatiwaa so koloowaati eeŋ, ii mono saanoŋ weeŋgoŋ oŋomba.” Kaeŋ ijoŋ kokaeŋ toroqeŋ jero, “Goo gbiliuruga yoŋoo jaŋgogianoŋ mono iikawaa so koloowaa.” ");
INSERT INTO ksr_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Kaeŋ jero Abramnoŋ Poŋ moma laariŋ muro momalaaria iiro sokono qaaya jeŋ tegoro solaŋaniro. ");
INSERT INTO ksr_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Poŋnoŋ toroqeŋ qaa kokaeŋ ijoro, “Niinoŋ Poŋ koloojeŋ. Gii Kaldia balombaa gomaŋ qata Uur kanoŋ laligona guambe koi kari. Baloŋ koi gombe buŋa qeŋ aowaatiwaajoŋ ama gii guama koi kawe.” ");
INSERT INTO ksr_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Kaeŋ jeroto, Abramnoŋ kokaeŋ ijero, “Oo Poŋ somatana, baloŋ koi kanoŋ noo buŋaga koloowaati, ii mono naa aiwesega iima moma kotomaŋa?” ");
INSERT INTO ksr_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Kaeŋ jero Poŋnoŋ iwaajoŋ kokaeŋ jero, “Gii mono kema bulmakao embia kowiŋa yambuya karooŋ, meme (noniŋ) embia yambuya karooŋ ano lama ejia yambuya karooŋ ano kewo moŋ ano kewo susu gbilia moŋ ii meŋ noonoŋ kawa.” ");
INSERT INTO ksr_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Kaeŋ jero Abramnoŋ kema ii korebore meŋ kaŋ oro ii biiwianoŋ qosoma oŋoma leegeŋ leegeŋ ii areŋgoro kana leelee arenoŋ egi. Kaeŋ anoto, kooŋ ii mende qosono. ");
INSERT INTO ksr_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Mende qosoma qamogia lee lee areŋgoŋ oŋono kooŋ kawalia yoŋonoŋ kaŋ qamo yoŋoo qagianoŋ kamaaŋ koŋgito, Abramnoŋ ii konjoma oŋono keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Weeŋ jaaya tegoŋ kememambaajoŋ anoti, kambaŋ iikanoŋ Abrambaa jaayanoŋ kamaaŋ mero gaoŋ biŋawo ero. Kaeŋ ero paŋgamaŋ ziwiziwiwaa kanjaŋa kanoŋ kaŋ turuŋ muro. ");
INSERT INTO ksr_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Turuŋ muro Poŋnoŋ kokaeŋ ijoro, “Qaa hoŋa koi mono geja ama moba: Goo gbiliuruganoŋ mono baloŋgia mesaoŋ kantri moŋnoŋ kema wabaga laligoŋ ubuya. Kaeŋ laligoŋ yoŋoo weleŋqeqeurugia omaya koloogi ii yambu 400:waa so meluŋgoŋ oŋoma laligowuya. ");
INSERT INTO ksr_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Kaeŋ laligowuyato, niinoŋ kantri weleŋqeqeurugia omaya kolooŋ laligowuyati, iyoŋoo qaagia kaaŋagadeeŋ jeŋ tegoŋ iroŋa meleembe qagianoŋ ubaa. Kaeŋ uro isama oŋoŋgi kantri ii mesaoŋ esuhinagia mamaga meŋ eleema kawuya. ");
INSERT INTO ksr_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","16","Niinoŋ Amor kanageso ii baloŋ kokanoŋ uulaŋawo mende oŋotaamaŋa. Wala siŋgisoŋgoya siŋgisoŋgoya ama bolidaborogi i iroŋa tororo meleema oŋomaŋatiwaa kambaŋanoŋ koloowaati, kambaŋ iikanoŋ mono ii oŋotaamaŋa. Kawaajoŋ goo esauruga yoŋoo esaurugia kolooŋ laligowuyati, kambaŋ kanoŋ goo gbiliuruganoŋ mono eleema koi kawuya. (15) Yoŋonoŋ kaeŋ kawuto, geeŋgo wala yambugaa kambaŋanoŋ waziiŋ komuro luaenoŋ maŋasauruga yoŋoonoŋ kena roŋ koma gombuya.” ");
INSERT INTO ksr_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Poŋnoŋ kaeŋ jero weeŋ jaayanoŋ tegoŋ kemero paŋgamaŋ mero iwoi kokaeŋ kolooro iiro: Monjoŋ mombaa uutanoŋ gere bolaŋanoŋ kokobilibiliawo jeŋ asariro kowa konduŋkonduŋawo pumpuŋgoro. Iwoi iikanoŋ asugiŋ oro koomuya qoosoŋa iyoŋoo batugianoŋ nama kema karo. ");
INSERT INTO ksr_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Poŋnoŋ oro leelee iikawaa batugianoŋ kema kaŋ somaŋa kanoŋ Abrambo soomoŋgo areŋ ama (kaisareyanoŋ ii meŋ kotiiŋ) qaa kokaeŋ ijoro, “Niinoŋ baloŋ koi ii goo gbiliuruga ii buŋa qeŋ oŋomaŋa. Iikawaa jawoya ii Iijiptwaa apu gowoya (Nail) iikanoŋa kanaiŋ kaŋ koi uuguŋ kema apu bereŋa somata qata Yufreitis iikanoŋ tegowaa. ");
INSERT INTO ksr_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Kambaŋ kokaamba ii kanageso koi kaaŋa yoŋoo baloŋ eja: Kin kanageso, Kenas kanageso, Kadmon kanageso, ");
INSERT INTO ksr_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hit kanageso, Periz kanageso ano Refaim kanageso, ");
INSERT INTO ksr_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amor kanageso, Keinan kanageso, Girgas kanageso ano Jebus kanageso. Yoŋoonoŋ baloŋ kuuya ii mono meŋ sokoma laligowu.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abrambaa embia Saarainoŋ aruŋa laligoŋ merabora mende meroto, Saaraiwaa weleŋ embia qata Haagar laligoro. Ii Iijipt embaga. ");
INSERT INTO ksr_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Iinoŋ laligorotiwaajoŋ Saarainoŋ Abram kokaeŋ ijoro: “Poŋnoŋ soŋgo somoŋgoŋ nono merabora mende mewetiwaajoŋ gii mono weleŋ embana mena koro ama merabora moŋ mero noo buŋaga koloonaga.” Kaeŋ ijoro Abramnoŋ Saaraiwaa qaayaajoŋ uumotooŋgo ano. ");
INSERT INTO ksr_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Abramnoŋ Keinan balonoŋ yambu 10 laligoro tegoro kambaŋ kanoŋ Abrambaa embia Saarainoŋ Iijiptga weleŋ embia Haagar meŋ loyawo motooŋ ewaotiwaajoŋ muro. ");
INSERT INTO ksr_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Kaeŋ muro meŋ laligoro koro ano. Koro anjeŋ, kaeŋ moma galeŋ embia Saarai ii kanaiŋ jejewili ama muro. ");
INSERT INTO ksr_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Kaeŋ ama muro Saarainoŋ Abram kokaeŋ ijoro: “Uunanoŋ boliro siimbobolo momakejeŋi, iikawaa qaayanoŋ mono goo qaanoŋ uma ewaa. Niinoŋ weleŋ embana goo boroganoŋ ambe koro ama ii moma iikanondeeŋ kanaiŋ jejewili ama noma laligoja. Kawaajoŋ Poŋnoŋ mono nii ano gii anaraa batunaranoŋ qaa gosiŋ jeŋ tegowa.” ");
INSERT INTO ksr_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Kaeŋ ijoro Abramnoŋ kokaeŋ jero: “Weleŋ embaganoŋ mono geeŋgaa boroganoŋ laligojiwaajoŋ nomaeŋ mona sokonji, mono iikawaa so ii ama muba.” Kaeŋ jero Saarainoŋ Haagar laŋ horoŋ ureeŋ ama muro mesaoŋ togoŋ oloŋ koma keno. ");
INSERT INTO ksr_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Keno Pombaanoŋ gajoba moŋnoŋ baloŋ qararaŋkoŋkoŋanoŋ apu jaaya mombaa kosianoŋ mokolooŋ muro. Apu jaaya ii Suur gomanoŋ kekembaa kana goraayanoŋ eja. ");
INSERT INTO ksr_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Iikanoŋ mokolooŋ muŋ kokaeŋ jero: “Haagar, Saaraiwaa weleŋ embia, gii mono daeŋkaya kajaŋa dakanoŋ kembaga?” Kaeŋ jero kokaeŋ meleeno: “Nii galeŋ embana Saaraiwaanoŋga asaŋgoŋ oloŋ koma kajeŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Kaeŋ jero Pombaa gajobanoŋ Haagar kokaeŋ jeŋ kotoŋ muro: “Gii mono mombo Saaraiwaanoŋ kema weleŋa qeŋ iwaa qaa baatanoŋ laligowa.” ");
INSERT INTO ksr_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Qaa ii toroqeŋ kokaeŋ jero moro: “Haagar, nii mono goo gbiliuruga kolooŋseiseigia oŋombe jaŋgogia mende weeŋweeŋgoyaa so kaaŋa laligowuya.” ");
INSERT INTO ksr_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Pombaa gajobanoŋ mombo toroqeŋ Haagar kokaeŋ ijoro: “Gii kokowo koloojaŋa meraga mewaga. Dologo koi tapekokoro moma saana ii mono Pombaa gejianoŋ kemero moja. Kawaajoŋ merawaa qata Ismael qaba. ");
INSERT INTO ksr_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Iinoŋ eja doŋgi bao kombo kaaŋa kolooŋ (aŋaa jaajaa laŋ kema kaŋ) laligowaa. Iinoŋ borianoŋ ejemba kuuya qetaama oŋono ejemba kuuya yoŋonoŋ ii qotogoŋ muŋ laligowuya. Iinoŋ kouruta kuuya yoŋowo kerekere aŋodeeŋ ama kanawaeŋ qeŋ laligowaa.” ");
INSERT INTO ksr_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Kaeŋ ijoro Haagarnoŋ kokaeŋ jero: “Niinoŋ mono keteda koi moŋnoŋ nii niimakeji, ii iijeŋ.” Kawaajoŋ Poŋ iwaajoŋ qaa jeroti, iwaa qata kokaeŋ qama muro: “Gii Poŋ nii niimakejaŋi, ii koloojaŋ.” Qata kaeŋ qaro. ");
INSERT INTO ksr_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Kania kawaajoŋ ama apu roŋ iikawaa qata ii Beer Lahai Roi (Laaligoyawo laligoŋ niimakejiwaa apu roŋa) qagita eja. Apu roŋ ii toroqeŋ gomaŋ woi qagara Kaades ano Bered iyoroo batugaranoŋ eja. ");
INSERT INTO ksr_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Haagarnoŋ Abrambaa meria mero. Abramnoŋ iyaŋaa meria Haagar meroti, iwaa qata Ismael qaro. ");
INSERT INTO ksr_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abramnoŋ yambuya 86 kolooro Haagarnoŋ Ismael mera ii Abrambaanoŋa mero. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abramnoŋ yambuya 99 kolooro Poŋnoŋ asugiŋ muŋ qaa kokaeŋ ijoro: “Niinoŋ Anutu ku-usuŋ kuuyaa Toya koloojeŋ. Kawaajoŋ gii mono noo qaana teŋ koma pondaŋ nanamemeŋ dindiŋa otaaŋ laligowa. ");
INSERT INTO ksr_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Nii soomoŋgo areŋ gii ano nii anaraa batunaranoŋ ambeti, ii meŋ kotiiŋ kolooŋseisei gombe gbiliuruga yoŋoo jaŋgogianoŋ mono somata totooŋ koloowaa.” ");
INSERT INTO ksr_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Kaeŋ ijoro Abramnoŋ simiŋ kuma usugoro Anutunoŋ iwaajoŋ qaa kokaeŋ jero: ");
INSERT INTO ksr_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Moba, niinoŋ soomoŋgo areŋna giwo kokaeŋ anjeŋ: Giinoŋ kanatuuru mamaga yoŋoo wanjale beŋisigiaga koloowaga. Qaa kaeŋ jeŋ somoŋgowe ewaa. ");
INSERT INTO ksr_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Goo qaga Abram ii mende toroqeŋ qagi ewaato, giinoŋ kanatuuru mamaga yoŋoo beŋisigiaga koloowaatiwaajoŋ kuuŋ gonjeŋi, iikawaajoŋ ama qaga mono Aabraham qagi ewaa. ");
INSERT INTO ksr_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Niinoŋ kolooŋ seisei gombe gbiliuruga ii honoŋa qaa koloowuya. Yoŋonoŋ juma deema kanageso tuuŋa tuuŋa mamaga koloowuya. Goo gbiliuruga yoŋoonoŋa tosianoŋ kiŋ poŋa poŋa koloowuya. ");
INSERT INTO ksr_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Niinoŋ mono soomoŋgo areŋna ii neena ano gii ano gbiliuruga goo gemaganoŋ toroqeŋ kolooŋ ubuti, ananaa batunananoŋ ambe kotiiŋ tetegoya qaa eŋ uma ewaa. Niinoŋ goo Anutuga ano gbiliuruga goo gemaganoŋ kolooŋ ubuti, mono iyoŋoo Anutugiaga kolooŋ laligomaŋa. ");
INSERT INTO ksr_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Gii Keinan balonoŋ wabaga laligojaŋi, niinoŋ baloŋ ii jinoŋa qaa gii ano goo gbiliuruga oŋoo buŋaga qeŋ oŋombe buŋagia tetegoya qaa eŋ uma ewaa. Kaeŋ ero niinoŋ mono oŋoo Anutugiaga kolooŋ laligomaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Anutunoŋ Aabrahambaajoŋ kaeŋ jeŋ toroqeŋ qaa kokaeŋ ijoro: “Kaeŋ laligomaŋato, giinoŋ mono noonoŋ soomoŋgo areŋnaa qaaya ii teŋ koma otaaŋ laligowa. Goo gbiliuruga goo gemaganoŋ toroqeŋ kolooŋ ubuti, iyoŋonoŋ mono kaaŋiadeeŋ ii teŋ koma otaaŋ laligoŋ ubu. ");
INSERT INTO ksr_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Gii ano goo gbiliuruga oŋowo soomoŋgo areŋna ama ii otaawutiwaajoŋ jejeŋi, iikawaa aiweseya ii kokaeŋ: Oŋoo batugianoŋ eja kuuya yoŋoo selegianoŋ mono noo aiwesena kotowu. ");
INSERT INTO ksr_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Noo aiwesena mono selegianoŋ kotowu. Iikanoŋ soomoŋgo areŋ nii ano oŋoo batunananoŋ ambe eji, iikawaa aiweseyaga eŋ ubaa. ");
INSERT INTO ksr_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Kambaŋ koi kanoŋa kanaiŋ eja kuuya oŋoo batugianoŋ toroqeŋ kolooŋ ubuti, iyoŋoo selegianoŋ mono gomaŋ boria 8 kolooro kanoŋ noo aiwesena kotoŋ laligowu. Oŋoaŋgiaa gomaŋ uutanoŋ oŋoaŋgiaa ano weleŋqeqeurugia yoŋoo meraurugia koloowuti, ii mono ororoŋ ama oŋoma laligowu. Weleŋqeqe tosaaŋa ii waba yoŋoonoŋga moneŋnoŋ sewaŋgia megi yoŋoo meragia koloowu. Yoŋonoŋ iyaŋgiaa gbiliurugia mende koloojuto, ii kileŋ noo aiwesena ii mono yoŋoo selegianoŋ kaaŋiadeeŋ kotoŋ laligowu. ");
INSERT INTO ksr_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Weleŋqeqe tosianoŋ oŋoaŋgiaa gomaŋ uutanoŋ koloogi weleŋqeqe tosaaŋa ii monenoŋ sewaŋgia megi yoŋoo meragia koloowu. Noo aiwesena ii mono yoŋoo selegianoŋ kaaŋiadeeŋ kotoŋ laligowu. Noonoŋ soomoŋgo areŋnaa aiweseya selegianoŋ kotowuti, ii mono soomoŋgo areŋ tetegoya qaa eŋ ubaatiwaajoŋ jeŋ kotiijeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Eja moŋ moronoŋ noo aiwesena selianoŋ mende kotogi eeŋ laligowaati, iinoŋ mono noo soomoŋgo areŋna uuguŋ qetamakeja. Kawaajoŋ eja kaaŋa ii mono ejemba tuuŋ oŋoo batugianoŋga yakariŋ mugi seleeŋgeŋ kamaaŋ laligowaa.” ");
INSERT INTO ksr_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Anutunoŋ toroqeŋ Aabraham kokaeŋ ijoro: “Gii embagaa qata Saarai ii mende toroqeŋ qama laligowato, iwaa qata mono Saara (jawiŋ emba) qama laligowa. ");
INSERT INTO ksr_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Niinoŋ Saara kotuegoŋ mube iinoŋ goojoŋ mera moŋ mewaa. Niinoŋ kotuegoŋ mube iinoŋ ejemba tuuŋa tuuŋa mamaga yoŋoo nemuŋ beŋisigiaga koloowaa. Iwaa gbiliuruta yoŋoonoŋga tosianoŋ kanageso tuuŋ yoŋoonoŋ eja poŋa poŋa koloowuya.” ");
INSERT INTO ksr_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Poŋnoŋ kaeŋ ijoro Aabrahamnoŋ ii moma simiŋ kuma usugoŋ uutanoŋ kokaeŋ romoŋgoŋ kawaajoŋ jomoro, “Eja yambuna 100 kolooro mera mono nomaeŋ mokoloowenaga? Kaaŋagadeeŋ Saaranoŋ yambuya 90 kolooro mono nomaeŋ mera menaga?” ");
INSERT INTO ksr_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Aabrahamnoŋ kaeŋ romoŋgoŋ waliŋgoŋ Anutu kokaeŋ qisiŋ muro: “Gii saanoŋ Ismael kuuŋ muna qaga bosino noo gbiliuruna ii iwaanoŋga koloowu.” ");
INSERT INTO ksr_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Kaeŋ qisiro Anutunoŋ kokaeŋ meleeno, “Embaga Saaranoŋ mono geeŋgaa mera dindiŋa mewaa. Ii mero qata Aisak (jomoja) qaba. Niinoŋ Aisakwo ano iwaa gbiliuruta yoŋowo soomoŋgo areŋna ambe kotiiŋ tetegoya qaa eŋ ubaa. ");
INSERT INTO ksr_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ismael kotuegoŋ mumambaajoŋ qisiŋ nonjaŋi, ii kaaŋiadeeŋ saanoŋ moma goma kotuegoŋ mumaŋa. Iinoŋ eja poŋ 12 iyoŋoo nemuŋ beŋisigia koloowaa. Niinoŋ kolooŋ seisei mube gbiliuruta yoŋoo jaŋgogianoŋ mono somata totooŋ koloowaa. Yoŋonoŋ seiŋ kanageso tuuŋ somata koloowuya. ");
INSERT INTO ksr_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Kaeŋ koloowuyato, Saaranoŋ geeŋgaa meraga Aisak ii yambu eugeŋanoŋ kambaŋ kokaamba mewaati, niinoŋ mono neenaa soomoŋgo areŋna ii iwo ama meŋ kotiimaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Anutunoŋ Aabrahambo qaa kaeŋ amiri tegoro ii mesaoŋ waama uro. ");
INSERT INTO ksr_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Weemboria iikanoŋadeeŋ Aabrahamnoŋ Anutuwaanoŋ qaa teŋ koma aŋaa meria Ismaelwaa selianoŋ Anutuwaa aiweseya kotoro. Kaaŋagadeeŋ weleŋqeqeuruta aŋaa miri uutanoŋ koloogi tosaaŋa monenoŋ sewaŋgia mero laligogiti, eja kuuya ii iwaa miri uutanoŋ ragiti, ii mono kuuya kaaŋiadeeŋ ama oŋono. ");
INSERT INTO ksr_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Aabrahamnoŋ yambuya 99 kolooro selianoŋ aiwese ii kotogi. ");
INSERT INTO ksr_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Meria Ismael ii yambuya 13 kolooro selianoŋ ii kotogi. ");
INSERT INTO ksr_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Aabraham ano meria Ismael yoroo selegaranoŋ aiwese ii somaŋa motooŋgo iikanondeeŋ kotogi. ");
INSERT INTO ksr_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Eja kuuya Aabrahambaa miri uutanoŋ ragiti, tosianoŋ iyaŋaa miri uutanoŋ koloogi tosaaŋa ii waba yoŋoonoŋga sewaŋgia mero laligogiti, kuuya iyoŋoo selegianoŋ aiwese ii kaaŋiadeeŋ kotogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Aabrahamnoŋ Mamre gomanoŋ jujuu gere somasomata iyoŋoo batugianoŋ laligoro Poŋnoŋ asugiŋ muro. Weemboria moŋ iikanoŋ weeŋ jeta kotakota qero Aabrahamnoŋ opo sel kuuŋaa qaayanoŋ raro. ");
INSERT INTO ksr_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Rama ataama uuŋ iiro eja karooŋanoŋ bataageŋ naŋgi. Naŋgi iŋiima opo sel kuuŋ qaayanoŋga alanzaŋ waama joujoloŋgia jeŋ uŋuamambaajoŋ sararagoŋ bobogariŋ keno. Kema waegia meŋ simiŋ kuma namonoŋ usugoŋ kemero. ");
INSERT INTO ksr_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Kemeŋ kokaeŋ jero: “Oo poŋuruna, niinoŋ oŋoo weleŋqeqegia kolooŋ oŋoo jaagianoŋ kaleŋ moriaŋ mokolooŋ laligojeŋi eeŋ, oŋo mono nii mende nuuguŋ kembu. ");
INSERT INTO ksr_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Nii oŋoo weleŋqeqegia kolooŋ saanoŋ apu moŋ meŋ kaŋ oŋombe kanagia soŋgbama gere kokawaa umuganoŋ rama haamo mewu. ");
INSERT INTO ksr_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Nii saanoŋ nene melaa moŋ meŋ kaŋ oŋombe newuya. Iikanoŋ meŋ kotiiŋ oŋonogo saanoŋ kana mombo toroqeŋ kembuya. Niinoŋ koi kaandiaga laligowe oŋo nii goda qeŋ noma kajutiwaajoŋ saanoŋ weleŋ qeŋ oŋomaŋa.” Kaeŋ jero meleema kokaeŋ jegi: “Daŋgiseŋ, jejaŋiwaa so kaeŋ saanoŋ amboŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Kaeŋ jegi Aabrahamnoŋ uulaŋawo bobogariŋ sel kuuŋ uutanoŋ kema uma Saara kokaeŋ ijoro: “Gii mono uulaŋawo flaua awaa totooŋ gomba (sapalaŋ) karoombaa so meŋ meleema yoŋoojoŋ bered oowa.” ");
INSERT INTO ksr_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Kaeŋ jeŋ uulaŋawo bulmakao tuuŋnoŋ kema bulmakao doŋa busuya loota meweeŋgoŋ weleŋqeqeya moŋ muro kanaiŋ uulaŋawo qeŋ kojoŋgoŋ ooro. ");
INSERT INTO ksr_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ii ooro tegoro ii, kele kosiga ano aju apuya tosia meŋ kema eja ragiti, iyoŋoo bagianoŋ ano. Bagianoŋ ano neŋ ragi iyaŋa kambaŋ kanoŋ kosogianoŋ gere kanianoŋ galeŋgia nano. ");
INSERT INTO ksr_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Nano kokaeŋ qisiŋ mugi: “Embaga Saara ii dakanoŋ?” Qisiŋ mugi jero: “Ii opo sel kuuŋ uutanoŋ endu raja.” ");
INSERT INTO ksr_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Kaeŋ jero eja yoŋoonoŋga moŋnoŋ kokaeŋ ijoro: “Yambu motooŋgowaa so tegoro niinoŋ oŋanoŋ eleema koi kawe embaga Saaranoŋ mono meriawo kolooŋ laligowaa.” Kaeŋ ijoroto, Saaranoŋ opo sel kuumbaa qaa ootayanoŋ loyaa gematanoŋ nama qaa ii gejianoŋ kemero moro. ");
INSERT INTO ksr_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Aabraham ano Saara yoronoŋ ejemba waŋa koloori yambugaraa jaŋgoyanoŋ somata kolooro laligori. Saaranoŋ koimbaa aima laligoroti, iikawaa kambaŋanoŋ mono uugudabororo. ");
INSERT INTO ksr_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Kawaajoŋ Saaranoŋ ii moma uutanoŋ kokaeŋ romoŋgoŋ jomoro: “Niinoŋ mono emba waŋa soosooliya koloowe lona eja poŋnanoŋ kaaŋiadeeŋ eja waŋa kolooro iwo ewotatiwaa naaŋanoŋ mombo asugiŋ nonaga me qaago?” ");
INSERT INTO ksr_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Kaeŋ romoŋgoro Poŋnoŋ Aabraham qisiŋ muŋ kokaeŋ ijoro: “Saaranoŋ naambaajoŋ jomoma kokaeŋ romoŋgoja: ‘Nii emba waŋa totooŋ kolooŋ oŋanoŋ merabora mewenaga me?’ ");
INSERT INTO ksr_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Poŋnoŋ iwoi mombaajoŋ mende totooŋ osiŋkeja. Kawaajoŋ jejeŋi, ‘Yambu motooŋgowaa so tegoro niinoŋ oŋanoŋ eleema koi kawe Saaranoŋ mono meriawo kolooŋ laligowaa.’” ");
INSERT INTO ksr_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Saaranoŋ keeta moma ii qaloweeŋ kokaeŋ ijoro: “Nii mende jomojeŋ.” Kaeŋ jeroto, Poŋnoŋ kokaeŋ ijoro: “Qaago, gii mono oŋanoŋ jomojaŋa.” Kaeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Kaeŋ jero eja karooŋ yoŋonoŋ waama oromesaoŋ Sodom taonoŋ baageŋ eleema kembombaajoŋ aŋgi. Aabrahamnoŋ kaaŋiadeeŋ ii oŋoomambaajoŋ yoŋowo motooŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Poŋnoŋ iyaŋaajoŋ kokaeŋ jero: “Nii iwoi amambaajoŋ mojeŋi, qaa ii alana Aabrahambaa jaanoŋ saanoŋ mende mesaŋgomaŋa. ");
INSERT INTO ksr_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Kokaembaajoŋ ii mesaŋgomambaajoŋ amamaajeŋ: Aabrahamnoŋ noo alana qaita moŋ. kolooja. Iinoŋ kolooŋ seisei kondooro kanageso somata ku-usuŋgiawo kolooŋ laligowuya. Noo kotumotuenanoŋ mono iwaajoŋ ama namowaa kanageso tuuŋa kuuya yoŋoo qagianoŋ uro oyaŋboyaŋ mokoloowuya. ");
INSERT INTO ksr_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Niinoŋ ii kokaembaajoŋ meweeŋgoŋ muwe: Iinoŋ meraborauruta ano gbiliuruta iwaa gematanoŋ kolooŋ laligoŋ ubuti, ii mono Pombaanoŋ kana iŋisaama nanamemeŋ dindiŋa sokomakeji, ii otaawutiwaajoŋ jeŋ kotoŋ oŋoma laligowaa. Kaeŋ laligoro qaaya teŋ koma otaaŋ laligowuti eeŋ, Poŋ niinoŋ Aabrahambaajoŋ iwoi asugiwaatiwaajoŋ jeŋ somoŋgoweti, iikanoŋ mono kuuya hoŋawo kolooŋkebaa.” ");
INSERT INTO ksr_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Poŋnoŋ aŋodeeŋ kaeŋ jeŋ toroqeŋ Aabraham kokaeŋ ijoro: “Sodom ano Gomora yoŋonoŋ siŋgisoŋgo lombotawo biŋawo ama laligogi kakasililiŋ somata uuta asugiro mamaganoŋ iikawaajoŋ qama saamakeju. Kawaajoŋ yoŋoo siŋgisoŋgogiaa qaayanoŋ mono somariiŋ uuta totooŋ kolooja. ");
INSERT INTO ksr_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Kawaajoŋ nii mono yoŋoonoŋ kemeŋ kaniagia iimaŋa. Kakasililiŋ aŋgitiwaajoŋ ama mamaganoŋ noo jaananoŋ qama saama laligogiti, ii kuuya oŋanoŋ aŋgi me qaago, niinoŋ ii gosiŋ momambaajoŋ mojeŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Kaeŋ jero eja woiyanoŋ eleema Sodom baageŋ kenito, Aabrahamnoŋ toroqeŋ Pombaa jaasewaŋanoŋ nano. ");
INSERT INTO ksr_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Nama Pombaa kosianoŋ kema kokaeŋ qisiŋ muro: “Gii ejemba solaŋa ano ejemba aŋgonjoragiawo ii motooŋ tiwilaaŋ oŋomambaajoŋ jejaŋ me? ");
INSERT INTO ksr_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Taoŋ iikanoŋ ejemba solaŋa 50 laligojuti eeŋ, gii ii oŋanoŋ meŋ kileeŋ oŋomambaajoŋ jejaŋ me? Taoŋ ii yoŋoojoŋ ama iŋiima koboonaga me qaago? ");
INSERT INTO ksr_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Gii mono kaeŋ amambaajoŋ amamaanaga. Ii yamageŋ! (qaago totooŋ!) Giinoŋ ejemba solaŋa ii ejemba aŋgonjoragiawo yoŋowo motooŋ mindiriŋ uŋuna mende sokombabo. Iyoŋowo motooŋ komuwubo. Giinoŋ namo ejemba kuuya nonoo qaanana jeŋ tegoŋkejaŋi, iikawaajoŋ mono geeŋgaa kanaga dindiŋa otaana sokombaa.” ");
INSERT INTO ksr_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Aabrahamnoŋ kaeŋ ijoro Poŋnoŋ meleema kokaeŋ jero: “Niinoŋ Sodom taonoŋ ejemba solaŋa 50 mokolooŋ oŋomaŋati eeŋ, iyoŋoojoŋ ama taoŋ kuuya ii saanoŋ iŋiima koboomaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Kaeŋ jero Aabrahamnoŋ mombo kokaeŋ ijoro: “Poŋ, nii kikisi sububuŋ omaya kaaŋa koloojento, kileŋ qaa kotiga Poŋna goonoŋ kuuŋ jejeŋ. Ii mende sokonjato, ii kileŋ moma nomba. ");
INSERT INTO ksr_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Taoŋ iikanoŋ ejemba solaŋa 50 qaagoto, 45 laligowuyagati eeŋ, giinoŋ ejemba 5 yoŋoojoŋ ama taoŋ kuuya ii kileŋ tiwilaaŋ oŋombaga me qaago?” Kaeŋ ijoro Poŋnoŋ kokaeŋ jero: “Niinoŋ ejemba solaŋa 45 iikanoŋ mokolooŋ oŋomaŋati eeŋ, taoŋ ii mono mende meŋ kileemaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Aabrahamnoŋ duŋanoŋ mombo qaa kokaeŋ ijoro: “Ejemba solaŋa 40 taoŋ iikanoŋ mokolooŋ oŋombagati eeŋ, mono nomaeŋ anaga?” Kaeŋ ijoro kokaeŋ meleeno: “Ejemba 40 yoŋoojoŋ ama taoŋ ii mende meŋ kileemaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Kaeŋ ijoro jero: “Oo Poŋ, uuga waababoto, niinoŋ mombo qaa gijomambaajoŋ mojeŋ. Ejemba solaŋa 30 taoŋ iikanoŋ mokolooŋ oŋombagi eeŋ, mono nomaeŋ anaga?” Kaeŋ ijoro kokaeŋ meleeno: “Ejemba solaŋa 30 taoŋ iikanoŋ mokolooŋ oŋomaŋati eeŋ, niinoŋ mono taoŋ ii mende meŋ kileemaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Aabrahamnoŋ toroqeŋ kokaeŋ ijoro: “Poŋ, nii qaa kotiga Poŋnaajoŋ kuuŋ jejeŋ. Ii mende sokonjato, ii kileŋ moma nomba. Ejemba solaŋa 20 ii taoŋ kanoŋ mokolooŋ oŋombagi eeŋ, gii mono nomaeŋ anaga?” Kaeŋ ijoro kokaeŋ meleeno, “Ejemba 20 iyoŋoojoŋ ama taoŋ ii mende meŋ kileemaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Kaeŋ jero Aabrahamnoŋ mombo kokaeŋ qisiro: “Oo Poŋ uuga waababoto, niinoŋ mombo somaŋa motooŋgo koi qaa gijomambaajoŋ mojeŋ. Ejemba solaŋa 10 iikanoŋ mokolooŋ oŋombagi eeŋ, mono nomaeŋ anaga?” Kaeŋ ijoro kokaeŋ meleeno, “Ejemba 10 iyoŋoojoŋ ama taoŋ ii mende meŋ kileemaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Kaeŋ amiŋ mori tegoro Poŋnoŋ Aabraham mesaoŋ keno iinoŋ mombo eleema mirianoŋ karo. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Siwe gajoba woi ii Aabraham mesaoŋ kema mare kolooro Sodom keuri. Keuri Lootnoŋ taombaa kiropo naguyanoŋ raro. Rama iriima waama joujoloŋgara jeŋ uruamambaajoŋ kema namonoŋ simiŋ kuma usugoŋ kemero. ");
INSERT INTO ksr_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Kemeŋ kokaeŋ jero: “Oo eja poŋwoina, oro saanoŋ weleŋqeqegara noo mirinoŋ kaŋ kanagara soŋgbambe niwo motooŋ ewoŋa. Eŋ waama saanoŋ umugawodeeŋ kana toroqeŋ kembao.” Kaeŋ jeroto, yoronoŋ kokaeŋ ijori: “Qaago, noro saanoŋ qenjaaro sombeŋ moŋnoŋ kema ewota.” ");
INSERT INTO ksr_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Kaeŋ ijorito, Lootnoŋ kotiiŋ kaparaŋ koma uruama aŋaa mirianoŋ kema ugi. Uma weleŋqeqeuruta jeŋ kotoŋ oŋono bered yiistya qaa oogi. Kaaŋagadeeŋ nembanene naaŋawo meagoŋ ooŋ oroŋgi neri. ");
INSERT INTO ksr_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ii neŋ gaoŋ ewowaa ani iikanondeeŋ Sodom ejembanoŋ kaŋ miri ii liligogi. Sodom taombaa bakaya kuuya iikanoŋa ejemba waŋa ano sagbili ii donoŋ donoŋ ambembo horoŋ kougi. ");
INSERT INTO ksr_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Kouma Lootwaajoŋ kokaeŋ qagi: “Eja woi mare goonoŋ kajaoti, ii daeŋgeŋ? Eja nono yorowo serowiliŋ ambombaajoŋ mojoŋ. Kawaajoŋ mono ii uruama nonoonoŋ kamaawu.” ");
INSERT INTO ksr_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Kaeŋ qagi Lootnoŋ nagu metama yoŋoonoŋ kemeŋ gematanoŋ nagu kono. ");
INSERT INTO ksr_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Nagu koma kokaeŋ iŋijoro: “Alauruna, kaeŋ qaago. Sili kilega ii mono mende ambu. ");
INSERT INTO ksr_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Mobu. Noo borawoina woi saraŋ laligoŋ kambaŋ moŋnoŋ ejawo mende eri. Ii saanoŋ oŋoojoŋ uruama kamaawe naa iwoiga ambombaajoŋ mojuti, ii saanoŋ siiŋgia metogowu. Kaento, noo miri waareŋanoŋ eja woi urualeema sopa somoŋgoŋ oronji, iiga mono iwoi kilega moŋ mende totooŋ ama orombu.” ");
INSERT INTO ksr_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Kaeŋ iŋijoroto, yoŋonoŋ kokaeŋ meleema tereema qagi: “Mono togowa. Giinoŋ koi kaŋ wabaya laligoŋ geeŋgaajoŋ moroga jeŋ mona uro nonoga pondaŋ jeŋ kotoŋ nonomambaajoŋ mojaŋ? Yoronoŋ mende kamaawaoti eeŋ, mono geeŋgo nonoonoŋ kana kakasililiŋ tokoroŋkota ama gomboŋa.” Kaeŋ jeŋ Loot utaŋgi gemagema keno uma miri naguya qosombombaajoŋ ama naŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Kaeŋ ama naŋgito, eja woi yoronoŋ borogara boraama Loot horoŋ giliri miri uutanoŋ uro nagu koni. ");
INSERT INTO ksr_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Nagu koma nama eja somata melaa miri naguyanoŋ seleeŋgeŋ naŋgiti, ii qaagaranoŋ jeri jaagia gooro jibujabu qeŋ nagu mokoloowombaajoŋ koromojoroŋ ama moŋgama amamaagi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Eja woi yoronoŋ Loot kokaeŋ ijori: “Gii merauruga, qegaborauruga ano tinitosauruga tosaaŋa kuuya taoŋ kokanoŋ laligojuti, ii mono uŋuana taoŋ koi mesaoŋ kembu. ");
INSERT INTO ksr_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Nono taoŋ koi meŋ kileeŋ kondemondeemboŋa. Kanageso koi yoŋoo kakasililimbaajoŋ mamaganoŋ Pombaa jaanoŋ honoŋa qaa qama saama laligogi. Kawaajoŋ iinoŋ wasiŋ norono gomaŋ koi meŋ kileeŋ kondemondeembojoŋ koi kajo.” ");
INSERT INTO ksr_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Kaeŋ ijori moma Lootnoŋ kema qega buŋawoita borawoita orombaotiwaajoŋ jero laligoriti, ii kokaeŋ irijoro: “Oro mono alanzaŋ waari gomaŋ koi mesaoŋ kemboŋa. Poŋnoŋ taoŋ koi tiwilaaŋ kondemondeemambaajoŋ anja.” Kaeŋ irijoro yoronoŋ qaa ii mori goŋgeegee tani kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Gomaŋ weŋgeraŋ suluro Siwe gajoba woi yoronoŋ Loot horoŋ kuuŋ muŋ kokaeŋ jeri: “Anutunoŋ Sodom yoŋoo siŋgisoŋgogiaa iroŋa meleema taoŋgia kondemondeembaa. Giinoŋ yoŋowo motooŋ tiwilaawabotiwaajoŋ mono uulaŋawo waama embaga ano borawoiga giwo rajaoti, ii uŋuama taoŋ koi mesaowu.” ");
INSERT INTO ksr_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Kaeŋ jeri Lootnoŋ toroqeŋ ezelobezelo ano eja woi yoronoŋ Lootwaa boria qelanjiŋ meŋ embia ano borawoita yoŋoo borogia kaaŋiadeeŋ qelanjiŋ meŋ uŋuama taoŋ seleeŋgeŋ keŋgi. Poŋnoŋ kaeŋ kiaŋkomuŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Taoŋ seleeŋgeŋ keŋgi eja woi iyoroonoŋga moŋnoŋ qaa kokaeŋ jero: “Laaligogia aŋgoŋ kombutiwaajoŋ oŋo mono uulaŋawo misiŋgoŋ kemaliwu. Gemagianoŋ mende eleema uuŋ dindiŋagadeeŋ kema baloŋ korianoŋ endu keuma kanoŋ kaaŋagadeeŋ doroŋ mende ambu. Tiwilaawubotiwaajoŋ mono baaŋanoŋ eu uma misiŋgoŋ kemaliwu.” ");
INSERT INTO ksr_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Kaeŋ jeroto, Lootnoŋ kokaeŋ jero mori: “Oo Poŋna, gii mono kaeŋ ambombaajoŋ mende jewa. ");
INSERT INTO ksr_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Gii waŋ taraana somoŋgoŋ kiaŋkoomu somata qendeena goo jaanoŋ oŋanoŋ kaleŋ moriaŋ mokolooŋ weleŋqeqega koloojento, moba, niinoŋ baaŋanoŋ eu misiŋgoŋ kemalimambaajoŋ amamaamaŋa. Kondemondeeŋ koinoŋ noo qananoŋ uro komumambotiwaa toroko mojeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Moba, taoŋ melaa moŋ endu ero iijaŋi, iikanoŋ koriga qaagoto, saanoŋ kemboŋatiwaa so kolooja. Kawaajoŋ saanoŋ jena iikanoŋ misiŋgoŋ kemaliŋ qeaŋgoŋ laligowoŋa. Gomaŋ melaada ii iina kosere ero iikanoŋ saanoŋ kema waŋ taraanana somoŋgowoŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Kaeŋ jero moma moŋnoŋ kokaeŋ meleeno: “Ii awaa! Qaa jejaŋi, iikawaajoŋ kaaŋagadeeŋ saanoŋ wambelaaŋ gomaŋa. Taoŋ melaa iikawaajoŋ jejaŋi, ii mende meŋ kileemaŋa. ");
INSERT INTO ksr_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ii mende meŋ kileemaŋato, oŋo mono uulaŋawo iikanoŋ misiŋgoŋ kemaliwu. Iikanoŋ mende keugi kambaŋ batuya kokaamba niinoŋ iwoi moŋ amambaajoŋ amamaamaŋa. Oŋo wala iikanoŋ keugi iikawaa gematanoŋ saanoŋ jeŋ kotowe kondemondeeŋ asugiwaa.” Lootnoŋ taombaajoŋ ‘melaada’ jerotiwaajoŋ ama taoŋ iikawaa qata ii Zoar (melaada) qagita eja. ");
INSERT INTO ksr_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Weeŋ kouro Lootnoŋ Zoar taonoŋ keuro. ");
INSERT INTO ksr_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Keuro Poŋnoŋ jero sombinoŋa salfa jamo geriawonoŋ ii koŋ kaaŋa Sodom ano Gomora yoŋoo qagianoŋ kamaaŋ turuŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Turuŋ oŋoma kanoŋ taoŋ woi ii ano gomaŋ koria kuuya kosogaranoŋ eji, ejemba kuuya iikanoŋ laligogiti ano gere kasa iwoi toŋgoŋa baloŋ iikanoŋ eroti, ii meŋ kileeŋ oŋondabororo. ");
INSERT INTO ksr_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lootwaa embianoŋ loya otaaŋ kema mombo eleema gematanoŋ uuŋ iikanondeeŋ letoma sii jamo kolooŋ tando kaaŋa nano. ");
INSERT INTO ksr_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Aabrahamnoŋ umugawodeeŋ waama wala Pombaa jaasewaŋanoŋ nama qaa amiŋ moriti, iikanoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Iikanoŋ kema nama Sodom, Gomora ano gomaŋ koria somata kuuya kaambaageŋ uuro keno baloŋ iikanoŋ kaaso injaŋa somatanoŋ kululuuŋ waaro iiro. Ii gere somata jeŋ kaaso somata waamakeji, iikawaa so kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Anutunoŋ baloŋ koria iikawaa taoŋa taoŋa meŋ kileeŋ kondemondeenoti, kambaŋ iikanoŋ Aabraham romoŋgoŋ muro. Beeta Lootnoŋ taoŋ iikanoŋ laligoro ii meleeno kemebombaajoŋ aŋgi Anutunoŋ kambaŋ iikanoŋadeeŋ jeŋ kotoro Loot kondemondeeŋ iikawaa uutanoŋga wama kagi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lootnoŋ Zoar taonoŋ laligomambaa toroko moro. Kawaajoŋ borawoita uruama Zoar mesaoŋ baloŋ baaŋawo kanoŋ kema ragi. Borawoita woi yorowo kobaa uutanoŋ eŋ waama laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Iikanoŋ laligoŋ borata somatanoŋ kambaŋ moŋnoŋ kogaajoŋ kokaeŋ jero: “Anaraa maŋnaranoŋ eja waŋa kolooja. Ejembanoŋ gomaŋ so agimiŋ aoŋ merabora mokolooŋ oŋomakejuto, baloŋ kokanoŋ eja moŋ norombaatiwaajoŋ mende laligoja. ");
INSERT INTO ksr_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kawaajoŋ saanoŋ kana maŋnara wain apu muri neŋ uuta eŋkaloloŋ kolooro iwo eŋ koro ama gbili mokoloori kanagesonananoŋ toroqeŋ laligowuya.” ");
INSERT INTO ksr_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Kaeŋ jeŋ gomantiiŋa iikanoŋadeeŋ maŋgara wain apu muri nero. Neŋ uuta eŋkaloloŋ kolooro datanoŋ kema iwo ero. Naa kambanoŋ kooroŋanoŋ karoti ano naa kambanoŋ waaroti, ii maŋanoŋ mende moro. ");
INSERT INTO ksr_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Eŋ waama borata somatanoŋ koga kokaeŋ ijoro: “Niinoŋ woraŋ gomantiiŋa maŋnawo ejeŋa. Saanoŋ kete gomantiiŋa kaaŋagadeeŋ wain apu mombo muri neŋ uuta eŋkaloloŋ kolooro giinoŋ mono kema iwo ewao. Kaeŋ eŋ maŋnaraanoŋa koro ama gbili mokoloori kanagesonananoŋ toroqeŋ laligowuya.” ");
INSERT INTO ksr_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Kaeŋ jeŋ gomantiiŋa iikanoŋ kaaŋagadeeŋ maŋgara wain apu muri nero. Neŋ uuta eŋkaloloŋ kolooro koganoŋ kema iwo ero. Naa kambanoŋ kooroŋanoŋ karoti ano naa kambanoŋ waaroti, ii maŋanoŋ mende moro. ");
INSERT INTO ksr_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Kaeŋ anitiwaajoŋ motooŋgara maŋgaraa koro ani. ");
INSERT INTO ksr_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Borata somatanoŋ mera ejaga meŋ qata Moab (maŋnaanoŋa) qaro. Moab iwaa gbiliurutanoŋ kolooŋ seisei ama kougi kambaŋ kokaamba kaaŋagadeeŋ qagia Moab kanageso qamakejoŋ. ");
INSERT INTO ksr_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Borata gosoganoŋ kaaŋiadeeŋ mera ejaga meŋ qata Ben Ami (kanagesonaa meria) qaro. Eja iikawaa gbiliurutanoŋ kolooŋ seisei ama kougi kambaŋ kokaamba kaaŋagadeeŋ qagia Amon kanageso qamakejoŋ. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Aabrahamnoŋ Mamre gomaŋ mesaoŋ toroqeŋ Saut waageŋ distrik qata Negew kanoŋ kema gomaŋ qagara Kaades ano Sur iyoroo batugaranoŋ laligoro. Kawaa gematanoŋ toroqeŋ taoŋ qata Gerar kanoŋ kema tawagadeeŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Kanoŋ laligoŋ ejemba ii kokaeŋ iŋijoro mogi: “Saara ii naanaga.” Kaeŋ iŋijoro Gerarwaa kiŋa Abimelek iinoŋ qaa ano keno Saara wama jiŋkaroŋ mirianoŋ kagi. ");
INSERT INTO ksr_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Kaeŋ aŋgito, Anutunoŋ gomantiiŋa moŋnoŋ Abimelekwaanoŋ kaŋ gaonoŋ kokaeŋ ijoro: “Emba buŋa qeŋ aojaŋi, ii eja mombaa embiaga. Kawaajoŋ gii mono iwaajoŋ ama koomuwaa buŋaga koloowaga.” ");
INSERT INTO ksr_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Kaeŋ ijoroto, kiŋ Abimeleknoŋ Saara mende merotiwaajoŋ ama kokaeŋ jero: “Poŋ, nii siŋgisoŋgowaa qaana qaa. Kawaajoŋ giinoŋ nii ano kanagesouruna nono eeŋ totooŋ tiwilaaŋ nonombabo. ");
INSERT INTO ksr_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Aabrahamnoŋ mono aŋo kokaeŋ nijoro: ‘Emba ii naanaga.’ Embanoŋ kaaŋagadeeŋ kokaeŋ nijoro: ‘Aabraham ii naanaga.’ Kawaajoŋ uunanoŋ gbiŋgbaoŋ mende ero emba ii jewe karo boronanoŋ kaamaa moŋ mende anjeŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kaeŋ jero Anutunoŋ gaonoŋ kitia kokaeŋ ijoro: “Qaa jejaŋi, ii oŋanoŋ. Goo uuganoŋ gbiŋgbaoŋ moŋ mende ero goonoŋ karoti, ii mojeŋ. Kawaajoŋ giinoŋ emba ii oosiriŋ noo jaananoŋ siŋgisoŋgo ambabotiwaajoŋ sopa somoŋgoŋ goma laligowe. ");
INSERT INTO ksr_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Kawaajoŋ emba ii mono mombo meleema loya muba. Eja ii gejatootoo ejaga. Ii saanoŋ goojoŋ qama kooliro mende komuwaga. Ii mombo mende mubagi eeŋ, qaa koi mono oŋanoŋ moba: Gii ano tinitosauruga oŋo mono kuuya komuwuya.” ");
INSERT INTO ksr_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Qaa kaeŋ ijoro kiŋnoŋ moma umugawodeeŋ waama poŋ jawiŋuruta kuuya oŋoono ajoroogi Poŋnoŋ qaa kuuya jeroti, ii iŋijoro moma aaruŋ lalaŋaniŋ toroko mamaga mogi. ");
INSERT INTO ksr_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Kaeŋ moma kiŋ Abimeleknoŋ Aabrahambaajoŋ qaa ano uro kokaeŋ jeŋ qisiŋ muro: “Gii mono naa terega ama nonona? Niinoŋ naa bologa moŋ ama gombe giinoŋ kondoona siŋgisoŋgowaa qaa lombotanoŋ mono nii ano kanagesona noo sopa totoŋ uutanoŋ laligojuti, nonoo qanananoŋ umambaajoŋ anja? Giinoŋ iwoi mende aaŋaa so ii soŋgo waleema ama nona. ");
INSERT INTO ksr_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Giinoŋ mono kania naambaajoŋ sili ii anjaŋ?” Kiŋ Abimeleknoŋ Aabraham kaeŋ qisiŋ muro. ");
INSERT INTO ksr_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Qisiŋ muro kokaeŋ meleeno: “Niinoŋ qaa ii kokaeŋ romoŋgoŋ jewe: ‘Baloŋ kokawaa kanageso oŋonoŋ Anutuwaa jeta uuguwubotiwaajoŋ toroko mende mobuyaga. Kawaajoŋ nii embanaajoŋ ama nugi komumambo.’ ");
INSERT INTO ksr_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Iinoŋ oŋanoŋ naanaga, maŋnaa borata kolooja. Nemunaa borata mende koloojiwaajoŋ ii embana mewe. ");
INSERT INTO ksr_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Anutunoŋ maŋnaanoŋ miri mesaoŋ moŋgeŋ kemaŋiwaajoŋ nijoroti, niinoŋ kambaŋ iikanoŋ Saara kokaeŋ ijowe: ‘Anara daeŋ daeŋ kemboti, iikanoŋ noojoŋ naanaga jewa. Kaeŋ ama iikanoŋ nii uujopa qendeema noma laligowa.’” ");
INSERT INTO ksr_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Kaeŋ ijoro moma Abimeleknoŋ Aabrahambaa embia Saara meleema muro. Kaaŋiadeeŋ lama bulmakao ano weleŋqeqe ejemba ii kaaŋiadeeŋ muro. ");
INSERT INTO ksr_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Muŋ qaa kokaeŋ jero: “Moba. Noonoŋ baloŋ koi wosoganoŋ eji, iikanoŋ mono geeŋgaa naaŋgaa so laligowa.” ");
INSERT INTO ksr_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Kaeŋ jeŋ Saara kokaeŋ ijoro: “Moba. Niinoŋ moneŋ silwa jamo 1000:baa so naaŋga mube kanoŋ tawaga kolooja. Tawa kanoŋ kaniaga qendeeno ejemba kuuya giwo laligojuti, iyoŋonoŋ ii iima kokaeŋ jeŋ moma yagowu, ‘Siŋgisoŋgowaa qaaya ii Saarawaanoŋ mende eja.’” Kaeŋ jero. ");
INSERT INTO ksr_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Aabrahambaa embia Saarawaajoŋ ama Poŋnoŋ emba kuuya kiŋ Abimelekwaa miri uutanoŋ laligogiti, iyoŋoonoŋ mera memewaa kania somoŋgoro. Kawaajoŋ Aabrahamnoŋ Anutuwaajoŋ qama kooliro Abimelek meŋ qeaŋgoro. Kaaŋagadeeŋ embia ano weleŋqeqe embauruta meŋ qeaŋgoŋ oŋono mombo meraboragiawo koloogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Poŋnoŋ Saara kaleŋ moriaŋ mumambaa qaaya jeŋ somoŋgoro eroti, iikawaa so ii galeŋ koma muro laligoro. Qaa jeroti, iikawaa so ii kokaeŋ ama muro: ");
INSERT INTO ksr_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saaranoŋ koro ano Aabrahamnoŋ eja waŋa kolooro kileŋ iwaa meria ejaga mero. Anutunoŋ mera koloowaatiwaa qaaya walawala jeŋ somoŋgorotiwaa so ii mono kambaŋ iikanoŋadeeŋ kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Saaranoŋ Aabrahambaa meria mero qata Aisak (jomoja) qaro. ");
INSERT INTO ksr_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Qaro Aisaknoŋ weeŋa 8 kolooro kambaŋ kanoŋ Anutuwaa aiweseya selianoŋ kotoro. Anutunoŋ qaa jeŋ kotoro erotiwaa so ii kotoro. ");
INSERT INTO ksr_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Aabrahamnoŋ yambuya 100 kolooro meria Aisak kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Kolooro Saaranoŋ qaa kokaeŋ jero: “Anutunoŋ jomo mokolooŋ nono. Kawaajoŋ daeŋ yoŋonoŋ noo sunduna mobuyati, iyoŋonoŋ mono niima jomowuya.” ");
INSERT INTO ksr_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Kaeŋ jeŋ toroqeŋ kokaeŋ jero: “Saaranoŋ mera galeŋkoŋkoŋaga koloowaati, moronoŋ qaa ii walawala moma Aabrahambaajoŋ jenaga? Kaeŋ qaagoto, kambaŋ kokaamba iinoŋ eja waŋa kolooro niinoŋ kileŋ iwaa meria mejeŋ.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Aisaknoŋ somariiŋ aju mesaoro weemboria iikanoŋadeeŋ Aabrahamnoŋ nene lombaŋ somata ano. ");
INSERT INTO ksr_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Iijipt emba Haagarnoŋ Aabrahambaa meria Ismael meroti, iinoŋ kambaŋ moŋnoŋ koga Aisak mepaegoŋ goŋgeegee ama muro Saaranoŋ ii iiro. ");
INSERT INTO ksr_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Kaeŋ iima Aabraham kokaeŋ ijoro: “Weleŋ embawaa merianoŋ mono noo merana Aisakwo goonoŋ ilawoila ii mende mendeema buŋa qeŋ aowaota. Weleŋ emba ii ano meria ii mono konjona kembao.” ");
INSERT INTO ksr_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Saaranoŋ qaa ii jeroti, iikanoŋ Aabrahambaa uuta qero Ismael ii meria koloorotiwaajoŋ ama uukamakamaa moro uuta kaambogawo kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Kaeŋ kolooro Anutunoŋ ii qaa kokaeŋ ijoro: “Meraga ano weleŋ embaga Haagar yoroojoŋ mono uugoojoŋ somata mende moba. Aisakwaa gbiliuruta yoŋonondeeŋ mono goo qabuŋaga bosima laligowuya. Kawaajoŋ Saaranoŋ qaa gijoji, ii kuuya mono moma teŋ komba. ");
INSERT INTO ksr_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Weleŋ embagaa merianoŋ goo gbiliga koloojiwaajoŋ niinoŋ ii kaaŋiadeeŋ kolooŋ seisei mube gbiliurutanoŋ kanageso somata koloowuya.” ");
INSERT INTO ksr_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Kaeŋ jero moma Aabrahamnoŋ eŋ gomaamba totooŋanoŋ waama nene tosia meŋ apu jua lama selianoŋ memeta kanoŋ apu kosoŋ kaŋ Haagarwaa sawiŋanoŋ ama meriawo wasiŋ orono mesaoŋ keni. Kema Beerseba baloŋ qararaŋkoŋkoŋanoŋ keuma liligoŋ laligori. ");
INSERT INTO ksr_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Laligori lama selianoŋ apu meŋ kenoti, iikanoŋ qaono meria ii bambaŋ mombaa baatanoŋ ano ero. ");
INSERT INTO ksr_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ano ero nama kokaeŋ romoŋgoro: “Merananoŋ jaana qaganoŋ komuwaati, ii iimambaajoŋ amamaaŋ doomorona mojeŋ.” Kaeŋ romoŋgoŋ mou motogi kenjiwaa so sigeŋsigeŋ kema rama silama saaro. ");
INSERT INTO ksr_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Mera saaroti, ii Anutunoŋ moro gajobayanoŋ siwenoŋga Haagarwaajoŋ qama kokaeŋ jero: “Haagar, gii naa lombowaa uutanoŋ laligojaŋ? Keega mono mende moba. Meranoŋ endu eŋ saaji, Anutunoŋ saaya ii moja. ");
INSERT INTO ksr_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Mono waama meraga balonoŋga kobibiina waaro borianoŋ meŋ migigiiŋ muba. Niinoŋ ii kanageŋ kolooŋseisei mube gbiliurutanoŋ seiŋ kanageso somata qabuŋagiawo koloowuya.” ");
INSERT INTO ksr_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Siwe gajobanoŋ kaeŋ jero Anutunoŋ jaaya metooro uuŋ apu roŋa moŋ iiro. Ii iima lama selia meŋ kema kanoŋ apu kosoŋ kaŋ meria muro nero. ");
INSERT INTO ksr_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Anutunoŋ Ismaelwo nano somariiŋ baloŋ qararaŋkoŋkoŋanoŋ laligoŋ idoŋ nene ejaga kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Baloŋ gbaŋgbarasia qata Paran kanoŋ laligoro nemuŋanoŋ Iijipt kantrinoŋga emba moŋ meŋ embiaga muro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Kambaŋ kanoŋ Abimelek ano iwaa manjaqeqe tuuŋaa kawali galeŋa qata Fikol yoronoŋ Aabrahambaajoŋ kokaeŋ jeri: “Giinoŋ ilawoila kuuya ama meŋkejaŋi, Anutunoŋ mono iikanoŋ giwo namakeja. ");
INSERT INTO ksr_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Kawaajoŋ giinoŋ mono kete kokaamba Anutuwaa jaanoŋ jojopaŋ qaa kokaeŋ jeŋgo jeŋ kotiiwa: ‘Niinoŋ gii, merauruga ano gbiliuruga oŋowo osoŋkakale moŋ mende ama laligomaŋa.’ Kaeŋ jeŋ kotiiŋ niinoŋ kiaŋkomuŋ goma laligoweti, iikawaa so giinoŋ mono kaaŋiadeeŋ baloŋ koi ano nii kiaŋkoomu noroma laligowa. Gii gomaŋ kokanoŋ wabaga kolooŋ laligojaŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Kaeŋ jeri Aabrahamnoŋ kokaeŋ jero: “Niinoŋ jojopaŋ qaa ii saanoŋ jeŋgo jeŋ kotiimaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Kaeŋ jeroto, Abimelekwaa weleŋqeqeurutanoŋ apu roŋ moŋ iyaŋgiaajoŋ aŋgoŋ koŋgiti, Aabrahamnoŋ iikawaajoŋ Abimelek jeŋ muro. ");
INSERT INTO ksr_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Jeŋ muroto, Abimeleknoŋ kokaeŋ meleema jero: “Moronoŋ sili ii anoti, ii niinoŋ mende mojeŋ. Geeŋgo iikawaa qaaya moŋ wala mende jena moma laligoŋ keteda koi qaa ii mojeŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Kaeŋ meleema jero Aabrahamnoŋ kema lama ano bulmakao meŋ kaŋ Abimelek muro kambaŋ iikanondeeŋ batugaranoŋ soomoŋgo ani. ");
INSERT INTO ksr_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Iikaeŋ ama Aabrahamnoŋ lama tuuŋgianoŋgaga lama embia melaa 7 metogoŋ mendeema oŋono yaŋgiodeeŋ naŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Kaeŋ naŋgi Abimeleknoŋ Aabraham kokaeŋ qisiŋ muro: “Lama embia melaa 7 gosiŋ endu ama oŋona yaŋgiodeeŋ nanjuti, ii kania naambaajoŋa?” ");
INSERT INTO ksr_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Qisiŋ muro kokaeŋ meleeno: “Niinoŋ apu roŋa koi osowetiwaa qaaya jeweti, ii moma laarijaŋ i eeŋ, lama melaa 7 koi mono noo boronanoŋga buŋa qeŋ aona noo qaanaa daŋgunuya koloowaa.” ");
INSERT INTO ksr_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Kaeŋ meleema eja woi ii baloŋ kanoŋ nama jojopaŋ qaagara jeŋgo jeŋ somoŋgoŋ aori. Kawaajoŋ gomaŋ iikawaa qata Beerseba qamakeju. ");
INSERT INTO ksr_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Beerseba gomanoŋ soomoŋgo kaeŋ ani tegoro Abimelek ano iwaa manjaqeqe tuuŋaa kawali galeŋa Fikol yoronoŋ waama eleema Filistin yoŋoo balonoŋ keni. ");
INSERT INTO ksr_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Keni Aabrahamnoŋ bereŋ gere moŋ Beerseba gomaŋ iikanoŋ komoma Poŋ Anutu beŋ kombombaŋa iwaa qata qama kooliro. ");
INSERT INTO ksr_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Qama kooliŋ nama Filistin yoŋoo balonoŋ kambaŋ koriga wabaga kolooŋ laligoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Iwoi ii kolooro kambaŋ tosia tegoro Anutunoŋ Aabraham aŋgotete meŋ muro. Qata “Aabraham!” qaro iinoŋ “Nii koi nanjeŋ,” jeŋ meleeno. ");
INSERT INTO ksr_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Kaeŋ meleeno kokaeŋ ijoro: “Motooŋ mera soroga Aisak uuganoŋ jopagoŋ muŋkejaŋi, ii mono wama Mooria balonoŋ kema baaŋa moŋ qendeema gomaŋati, iikanoŋ uma ii noo siimoloŋ oowa.” ");
INSERT INTO ksr_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kaeŋ ijoro Aabrahamnoŋ eŋ gomaamba totooŋanoŋ waama doŋgi qaganoŋ duŋ raraya meagoŋ weleŋqeqeya woi ano meria Aisak uŋuano. Siimolombaa geria soyanoŋ kondaboroŋ boraŋgoŋ ama uŋuama Anutunoŋ baloŋ ijoroti, iikanoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Kema laligoŋ weemboria karooŋa kanoŋ jaayanoŋ uuŋ waama baloŋ ii iiro koriganoŋ ero. ");
INSERT INTO ksr_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ii iima weleŋqeqewoita ii kokaeŋ irijoro: “Oro doŋgiwo koi rari nii ano mera noronoŋ endu kema Anutu waeya meŋ mepeseeŋ mombo eleema oroonoŋ kawota.” ");
INSERT INTO ksr_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Aabrahamnoŋ kaeŋ irijoŋ siimoloŋ ooŋoombaa gere boraŋawo meŋ meria Aisakwaa sawiŋanoŋ ano uro aŋo gere jo ano soo mero. Kaeŋ mero motooŋgara keni. ");
INSERT INTO ksr_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Kaeŋ kema Aisaknoŋ doroŋ ama maŋa Aabraham kokaeŋ ijoro: “Ama!” Kaeŋ ijoro kokaeŋ meleeno: “Wae, merana naama?” Kaeŋ meleeno kokaeŋ qisiro: “Gere jeta ano gere ii koi meŋ kajoto, siimoloŋ ooŋoombaa lamaya ii dakanoŋ?” ");
INSERT INTO ksr_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Kaeŋ qisiro maŋanoŋ kokaeŋ meleeno: “Merana, Anutu aŋo mono siimoloŋ ooŋoombaa lamaya moŋ mokolooŋ norombaa.” Kaeŋ meleeno toroqeŋ motooŋgara keni. ");
INSERT INTO ksr_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Kema Anutunoŋ baloŋ jeroti, iikanoŋ keuma nama siimoloŋ ooŋoombaa alataya moŋ meŋ gere iikawaa qaganoŋ ama areŋgoro. Areŋgoŋ meria Aisak somoŋgoŋ alatanoŋ gere qaganoŋ ano. ");
INSERT INTO ksr_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ama meria uumambaajoŋ boria boraama soo kopiŋanoŋa horomambaajoŋ ano. ");
INSERT INTO ksr_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Soo horomambaajoŋ ano iikanondeeŋ Pombaa gajobanoŋ Siwenoŋa Aabrahambaajoŋ kokaeŋ qaro: “Aabraham, Aabraham!” Kaeŋ qaro “Nii koi nanjeŋ,” jeŋ meleeno. ");
INSERT INTO ksr_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Kaeŋ meleeno kokaeŋ ijoro: “Boroga mono merawaa qaganoŋ mende amba. Iwaa qaganoŋ iwoi moŋ mende amba. Giinoŋ meraga motooŋgo soro ii noojoŋ mende aŋgoŋ konjaŋiwaajoŋ kanaga kete kokaeŋ moma yagojeŋ: Gii Anutuwaa qaa jeta uuguwabotiwaajoŋ keega momakejaŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Kaeŋ ijoro iikanondeeŋ ataama uuŋ iiro lama ejia moŋ ilianoŋ gere bambaŋawonoŋ giliro kemero nano. Ii iima kema meŋ kaŋ meriaa kitianoŋ lama iikanoŋ siimoloŋ ooro. ");
INSERT INTO ksr_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Kawaajoŋ Aabrahamnoŋ baloŋ iikawaa qata ii ‘Poŋnoŋ mokolooŋ norombaa,’ jeŋ qaro. Kambaŋ kokaamba kaaŋiadeeŋ qaa kokaeŋ qamakeju: “Poŋnoŋ ii baaŋanoŋ mokolooŋ norombaa.” ");
INSERT INTO ksr_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Pombaa gajobanoŋ Aabrahambaajoŋ Siwenoŋa mombo kokaeŋ qaro indiŋa woi kolooro: ");
INSERT INTO ksr_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Poŋ niinoŋ kokaeŋ jejeŋ: Neeno neenaa qananoŋ qama jojopaŋ qaa kokaeŋ jeŋgo jeŋ kotiijeŋ: Giinoŋ sili koi ama meraga motoondago ii noojoŋ mende aŋgoŋ konjaŋi, ");
INSERT INTO ksr_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","iikawaajoŋ niinoŋ oŋanoŋ gii kotuegoŋ goma kolooŋseisei gombe gbiliuruga yoŋonoŋ honombonoŋa qaa seiwuya. Seigi jaŋgogianoŋ mono sombiŋ kanakeewambaa seŋgelaoya kaaŋa koloowaa ano kowe goraayanoŋ sakasiŋ eŋ kenjuti, iikawaa so koloowaa. Goo gbiliuruga yoŋonoŋ mono kotiiŋ kereurugia uŋuŋ haamo ama siti baloŋgia uŋuama aŋgoŋ koma laligowuya. ");
INSERT INTO ksr_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Giinoŋ noo qaana teŋ konjaŋi, iikawaajoŋ goo gbiliuruga yoŋoonoŋga mombaajoŋ ama noo kotumotuenanoŋ mono namowaa kanageso tuuŋ kuuya yoŋoo qagianoŋ uro oyaŋboyaŋ mokoloowuya.” ");
INSERT INTO ksr_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Pombaa gajobanoŋ kaeŋ ijoro Aabraham meriawo eleema weleŋqeqewoita yoroonoŋ kema aitoŋgoŋ motooŋ Beerseba gomanoŋ keŋgi. Aabrahamnoŋ Beerseba gomaŋ kanoŋ opo sel kuuŋa mororoŋgoŋ laligoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Kambaŋ tosia tegoro buzu qaa moŋ kokaeŋ aŋgi Aabrahambaanoŋ karo: “Milkanoŋ kaaŋiadeeŋ nemuŋga kolooja. Iinoŋ koga Naahorwaa merauruta tosaaŋa oŋono.” ");
INSERT INTO ksr_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Meria mutuyaa qata ii Uz, iwaa koga Buz ano iwaa kanianoŋ Kemuel, Arambaa maŋa. ");
INSERT INTO ksr_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kemuelwaa kanianoŋ Kesed, Hazo, Pildas, Jidlaf ano Betuel. ");
INSERT INTO ksr_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuelnoŋ Rebekawaa maŋaga kolooro. Milkanoŋ Aabrahambaa koga Naahorwaa merauruta 8 ii oŋono. ");
INSERT INTO ksr_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Naahorwaa embia sewaŋa mende memeta qata Reuma iinoŋ kaaŋiadeeŋ merauruta tosaaŋa oŋono. Yoŋoo qagia ii Tebe, Gaham, Tahas ano Maaka. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saaranoŋ laligoŋ uro yambuya 127 kolooro. Saaranoŋ yambu iikawaa so laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Laligoŋ Keinan balonoŋ gomaŋ qata Kiriat Arba, qata alia Hebron qamakejuti, iikanoŋ komuro. Komuro Aabrahamnoŋ iikanondeeŋ embiaajoŋ jiŋgeŋ qama saamambaajoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Kema saaro tegoro waama embiaa qamoya mesaoŋ kema nama Hit ejemba ii qaa kokaeŋ iŋijoro: ");
INSERT INTO ksr_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Nii oŋoo batugianoŋ waba kaŋ tawatawa laligojeŋ. Kawaajoŋ oŋo mono baloŋgiaa bakaya moŋ kokaamba noŋgi sewaŋa mewe qasirina kolooro alauruna yoŋoo qamogia iikanoŋ ama roŋ koma oŋomakemaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Qaa kaeŋ iŋijoro Hit yoŋonoŋ meleema kokaeŋ jegi: ");
INSERT INTO ksr_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Oo eja poŋ, gii saanoŋ nonoonoŋ qaa koi moba. Gii nonoo batunananoŋ Anutuwaa eja jawiŋa laligojaŋiwaajoŋ ama qasiriga aiŋganoŋ daeŋkaya iima sororogoŋ mewaatiwaajoŋ mojaŋi, iikanoŋ mono saanoŋ qamoga roŋ komba. Giinoŋ qamoga osoŋ roŋ komaŋa jena nonoonoŋga moŋnoŋ ii mende aŋgoŋ koma gombaa.” ");
INSERT INTO ksr_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Kaeŋ jegi Aabrahamnoŋ waama baloŋ toya Hit ejemba yoŋoo wosogianoŋ kemeŋ usugoŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Usugoŋ oŋoma nama yoŋoojoŋ qaa kokaeŋ jero: “Niinoŋ qamona osoŋ roŋ komaŋiwaajoŋ saanoŋ jewuti eeŋ, mono noonoŋ qaa koi moma Zoharwaa meria Efron iwaanoŋ kema qaa jena koi toroqeŋ jeŋ kuuŋ mubu. ");
INSERT INTO ksr_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Kuuŋ mugi moma kobaa qata Makpela iwaa buŋa kolooŋ gawoŋaa jaaŋaageŋ eji, mono ii jeŋ tegoro sewaŋa memaŋa. Mono qisigi sewaŋa dawi jeŋ tegoro sewaŋa kuuya mewe noonoŋ qasirina oŋoo batugianoŋ ewaa.” ");
INSERT INTO ksr_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Kaeŋ jero Efronoŋ alauruta Hit kanageso kuuya taoŋgiaa kiropo naguyanoŋ kaŋ sombenoŋ ajoroogiti, iyoŋoo batugianoŋ raro qaa geja ama mogi Efronoŋ Aabraham kokaeŋ meleema muro: ");
INSERT INTO ksr_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Oo eja poŋna, kaeŋ qaagoto, mono jewe geja ama moba. Niinoŋ baloŋ koria ii ano kobaa iikanoŋ nanji, ii kalenaga gonjeŋ. Neenaa kanagesouruna yoŋoo jaagianoŋ nama ii gombe iiju. Qamoga ii saanoŋ iikanoŋ osoŋ roŋ komba.” ");
INSERT INTO ksr_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Kaeŋ jero Aabrahamnoŋ baloŋ toya yoŋoo wosogianoŋ mombo kemeŋ usugoŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Usugoŋ oŋoma nama yoŋoo jaagianoŋ Efron kokaeŋ ijoro mogi: “Noonoŋ qaa koi mono geja ama moba. Giinoŋ saanoŋ kaeŋ anagato, niinoŋ mono baloŋ koria iikawaa sewaŋa ii gomaŋa. Ii saanoŋ jeŋ tawa mena niinoŋ qamona iikanoŋ osoŋ roŋ komaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Kaeŋ ijoro mogi Efronoŋ Aabraham kokaeŋ meleema muro: ");
INSERT INTO ksr_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Oo eja poŋna, noonoŋ qaa koi mono geja ama moba. Baloŋ iikawaa sewaŋa ii 400 silwa kota (50 kilogram). Ala-ala koloojotiwaajoŋ ama kanoŋ mono anaraa batunaranoŋ iwoi omaya kolooja. Kawaajoŋ qamoga saanoŋ iikanoŋ osoŋ roŋ komba.” ");
INSERT INTO ksr_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Kaeŋ meleema muro moma Aabrahamnoŋ baloŋ sewaŋaa jaŋgoya Efronoŋ Hit kanageso yoŋoo jaagianoŋ jero mogiti, iikawaa uumotooŋ ano. Jaŋgoya silwa kota 400 ii koŋkororo ejembanoŋ kambaŋ kanoŋ sewaŋaa soya jegi eroti, iikawaa so moneŋ ii gosiŋ muro. ");
INSERT INTO ksr_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Kaeŋ muro Efrombaanoŋ baloŋ koria Mamre kosianoŋ Makpela kanoŋ eroti, kobaa iikanoŋ nanoti ano gere kuuya baloŋ kawaa jawo uutanoŋ naŋgiti, iikawaa qaaya jeŋ tegoro. ");
INSERT INTO ksr_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Qaaya jeŋ tegoro Aabrahambaa buŋa kolooro. Hit kanageso kuuya taoŋgiaa kiropo naguyanoŋ kaŋ sombenoŋ ajoroogiti, iyoŋonoŋ tawa ii iigi buŋaya kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Kawaa gematanoŋ Aabrahamnoŋ embia Saarawaa qamoya ii Keinan balombaa kobaayanoŋ osoŋ roŋ kono. Kobaa ii Mamre qata alia Hebron kawaa kosianoŋ baloŋ koria qata Makpela kanoŋ eja. ");
INSERT INTO ksr_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Kaeŋ kolooro baloŋ koria ano kobaa iikanoŋ nanji, ii Hit kanageso yoŋonoŋ Aabrahambaa buŋa qeŋ mugi qasiria kolooro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Aabrahamnoŋ eja waŋa kolooro Anutunoŋ iwoi kuuya ama meroti, iikanoŋ ii kotuegoŋ muro laligoŋ kouro. ");
INSERT INTO ksr_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Kaeŋ ama kambaŋ moŋnoŋ miriaa weleŋqeqe jawiŋa waŋa, miria uutanoŋ ilawoila eŋ muroti, iikawaa galeŋa iwaajoŋ qaa kokaeŋ jero, “Gii mono qaaga jeŋ kotiiwaatiwaajoŋ boroga noo tawonaa baatanoŋ amba. ");
INSERT INTO ksr_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Kaeŋ ama Poŋ, Siwe ano namo yoroo Anutugaraa qatanoŋ jojopaŋ qaa kokaeŋ jewa: Niinoŋ Keinan kanageso yoŋoo batugianoŋ koi laligojento, giinoŋ mono meranaa embia ii yoŋoo naaŋ boragiaga moŋ mende meŋ muba. ");
INSERT INTO ksr_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Kaeŋ qaagoto, gii mono neenaa kantrinoŋ kema tinitosauruna yoŋoonoŋga merana Aisakwaa embiaga wama kawa.” ");
INSERT INTO ksr_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Kaeŋ jero weleŋqeqe jawiŋanoŋ kokaeŋ qisiŋ muro: “Kema jewe emba kanoŋ niwo baloŋ kokanoŋ kamambaajoŋ togowaati eeŋ, niinoŋ mono nomaeŋ amaŋa? Meraga Aisak wama kantri kanati, iikanoŋ mombo eleema kembota me qaago?” ");
INSERT INTO ksr_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Kaeŋ qisiŋ muro Aabrahamnoŋ kokaeŋ meleeno: “Qaago totooŋ! Gii noo merana wama kanoŋ mombo mende kembao. ");
INSERT INTO ksr_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Siwewaa Poŋa Anutunoŋ nii maŋnaa mirinoŋ ano kolokoloo kantrinanoŋga qaa kokaeŋ jero mobe jojopaŋ qaanoŋ somoŋgoŋ nuano kawe: ‘Niinoŋ baloŋ koi mono goo gbiliuruga yoŋoo buŋa qeŋ oŋomaŋa.’ Kawaajoŋ iinoŋ mono Siwe gajobaya wasiro wala keno giinoŋ saanoŋ meranaa emba ii iikanoŋa wama kawa. ");
INSERT INTO ksr_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Kema jena emba kanoŋ giwo kamambaa togowaati eeŋ, jojopaŋ qaaga koi kanoŋ mono mende toroqeŋ somoŋgoŋ gombaa. Noo merana ii mono mende totooŋ wama iikanoŋ eleema kembaota.” ");
INSERT INTO ksr_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Kaeŋ jero weleŋqeqe jawiŋanoŋ qaa ii jeŋ somoŋgoŋ muŋ jojopaŋ qaanoŋ jeŋ kotiimambaajoŋ boria somataya Aabrahambaa tawo baatanoŋ ano. ");
INSERT INTO ksr_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Kaeŋ jeŋ kotiiŋ nama somatayaanoŋ kamel 10 ano iwaa kowianoŋa iwoi akadamugiawo kania kania motooŋ mero. Ii meŋ mesaoŋ Noot Mesopotemia (Aram Naharaim) kantrinoŋ kema Naahornoŋ taoŋ laligoroti, iikanoŋ keuro. ");
INSERT INTO ksr_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Keuma taoŋ seleeŋgeŋ apu roŋa eroti, iikawaa kosianoŋ kameluruta oŋoono simiŋgia misigoŋ kemeŋ haamo megi. Weeŋ jaaya kememambaajoŋ ano taonoŋa emba yoŋonoŋ apu kosowombaajoŋ apu roŋanoŋ kaka kambaŋgia ii kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Iikanoŋ nama kokaeŋ qama kooliro: “Oo Poŋ, somatana Aabrahambaa Anutuya, gii mono kete toomoriaŋ noma somatana Aabrahambaajoŋ qaa jeŋ somoŋgonati, iikawaa hoŋanoŋ asugiwaa. ");
INSERT INTO ksr_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Moba, nii apu roŋ kosianoŋ kokanoŋ nambe taombaa emba saraŋurugia yoŋonoŋ apu kosowombaajoŋ kawuya. ");
INSERT INTO ksr_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kagi kokaeŋ koloowaatiwaajoŋ qama koolijeŋ: Niinoŋ emba saraŋ mombaajoŋ kokaeŋ jemaŋa: ‘Gii saanoŋ koworaŋeŋga meeraŋgona apu newenaga.’ Kaeŋ jewe iinoŋ kokaeŋ meleema nijowaa: ‘Saanoŋ nena kameluruga kaaŋagadeeŋ apu uŋuagimaŋa.’ Kaeŋ nijowaati, emba saraŋ iikaya giinoŋ weleŋqeqe ejaga Aisakwaa buŋa qenati, iinoŋ mono ii koloowaa. Kaeŋ kolooro giinoŋ somatanaajoŋ qaa jeŋ somoŋgonati, iikanoŋ hoŋawo kolooja, kaeŋ momaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Qamakooli ii qama kooliro mende tegoro iikanondeeŋ emba moŋ qata Rebeka iinoŋ koworaŋeŋ sawiŋanoŋ aŋgoŋ apu roŋanoŋ karo. Iinoŋ Aabrahambaa koga Naahor ano embia Milka, yoroo meragara qata Betuel iwaa borataga. ");
INSERT INTO ksr_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Emba iikawaa kaitania ii iima-aiŋaiŋawo totooŋ kolooro emba saraŋ jumuŋa ejanoŋ mende memetaga laligoro. Iinoŋ kamaaŋ apu roŋnoŋ kemeŋ apu kosoŋ kouro. ");
INSERT INTO ksr_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Kouro iikanondeeŋ weleŋqeqe jawiŋanoŋ uulaŋawo iwaa kosianoŋ kema kokaeŋ jero: “Gii saanoŋ koworaŋeŋganoŋa apu moŋ nona newenaga.” ");
INSERT INTO ksr_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Kaeŋ jero kokaeŋ meleeno: “Oo poŋna, saanoŋ newa.” Kaeŋ jeŋ uulaŋawo koworaŋeŋa borianoŋ meŋ kamaaŋ meeraŋgoro apu nero. ");
INSERT INTO ksr_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ii nero kokaeŋ jero: “Niinoŋ kameluruga yoŋoojoŋ kaaŋagadeeŋ apu kosoŋ oŋombe neŋ kema negi uŋuro mesaowu.” ");
INSERT INTO ksr_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Kaeŋ jeŋ uulaŋawo koworaŋeŋanoŋa apu molaaro kuuya juunoŋ kemero mombo qikqigoŋ kema apu roŋnoŋ apu kosomambaajoŋ kemeŋ kameluruta kuuya yoŋoojoŋ apu sogianoŋ kosoro. ");
INSERT INTO ksr_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Kaeŋ ano weleŋqeqe jawiŋanoŋ goroŋ nama ii tororo iima kokaeŋ moma romoŋgoro: “Oŋanoŋ, Poŋnoŋ kana koriga koi kajeŋatiwaa moriaŋa ii mono kokaeŋ kondooro asugija me nomaeŋ?” ");
INSERT INTO ksr_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kaeŋ romoŋgoŋ nano kamel yoŋonoŋ apu nedaborogi weleŋqeqe jawiŋanoŋ mopoŋ (pinjoŋ) goulnoŋ memeta moŋ lombota 5 gram ii meŋ emba sarambaa sewaŋanoŋ ama borojeŋjeŋ goulnoŋ memeta woi lombogara 110 gram ii borianoŋ kotogoro uro. ");
INSERT INTO ksr_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Kotogoro uro kokaeŋ qisiŋ muro: “Gii morowaa borataga? Maŋgaa miri uutanoŋ nononoŋ gomantiiŋa ewonagatiwaa titiŋa moŋ nanja me qaago, ii saanoŋ jena mobenaga.” ");
INSERT INTO ksr_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Kaeŋ qisiŋ muro kokaeŋ meleema muro: “Nii Betuelwaa borataga. Au asana qagara Milka ano Naahor.” ");
INSERT INTO ksr_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Kaeŋ jeŋ toroqeŋ kokaeŋ jero: “Nonoonoŋ lolo hai ano kamel yoŋoo loloo qaqanoŋ neneya ii mamaga raja ano gomantiiŋa gaoŋ ewutiwaa titiŋa ii kaaŋagadeeŋ saanoŋ nanja.” ");
INSERT INTO ksr_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Kaeŋ jero weleŋqeqe jawiŋanoŋ namonoŋ kemeŋ usugoŋ Pombaa waeya meŋ mepeseero. ");
INSERT INTO ksr_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Mepeseeŋ kokaeŋ jero: “Oo Anutu, somatana Aabrahambaa Poŋa, niinoŋ gii mepeseeŋ gonjeŋ. Giinoŋ somatanaajoŋ kaleŋ moriambaa qaaga jeŋ somoŋgonati, ii tororo otaana mende looriro. Iikawaa so Poŋ giinoŋ nuana kana koriga koi kaŋ laligoŋ somatanaa tinitosauruta yoŋoo mirinoŋ koujeŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Kaeŋ asugiro emba saraŋnoŋ uulaŋawo qiqigoŋ kema iikawaa sunduya ii nemuŋaa sumaŋuruta mirinoŋ laligogiti, ii iŋijoro mogi. ");
INSERT INTO ksr_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebekawaa naaŋa qata Laban laligoro. Iinoŋ ii moma Aabrahambaa weleŋqeqe jawiŋa iimambaajoŋ uulaŋawo seleeŋgeŋ apu roŋanoŋ qiqigoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Naaŋaa borianoŋ goul borojeŋjeŋ ano sewaŋanoŋ goul mopoŋ raro iiro naaŋa Rebekanoŋ weleŋqeqe jawiŋanoŋ qaa jero moroti, iikawaa sunduya jero moma iwaanoŋ keno. Kema apu roŋanoŋ keuma eja ii iiro kanoŋ kameluruta yoŋoo kooroŋgianoŋ nano. ");
INSERT INTO ksr_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Nano kokaeŋ jero: “Poŋnoŋ kotuegoŋ gono laligojaŋi, gii mono kana mirinoŋ kembo. Seleeŋgeŋ kokanoŋ mende namba. Niinoŋ oŋoaŋgia ewutiwaa miria ano kameluruga yoŋoo duŋ kaaŋiadeeŋ meweeŋgojeŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Kaeŋ jero weleŋqeqe jawiŋanoŋ mirinoŋ karo kamel qagianoŋ esuhina raroti, ii Labanoŋ mesuma mero kamaaro jero kamel yoŋoojoŋ loloo hai ano qaqanoŋ nene meŋ kaŋ oŋoŋgi. Weleŋqeqe jawiŋ ano iwaa ejaurutanoŋ kanagia soŋgbambutiwaa apuya ii kaaŋiadeeŋ motooŋ kosoŋ kaŋ oŋoŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Kawaa gematanoŋ nene weleŋqeqe jawimbaa batanoŋ koŋgito, iinoŋ kokaeŋ jero: “Wala qaa meŋ kajeŋi, ii jewe mogigo mono nene koi nemaŋa.” Kaeŋ jero Labanoŋ kokaeŋ jero: “Ii saanoŋ jena moboŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Kaeŋ jero kokaeŋ iŋijoro: “Niinoŋ Aabrahambaa weleŋqeqe ejaga koloojeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Poŋnoŋ somatana honoŋa qaa kotuegoŋ muro eja uuta esuhinawo kolooŋ laligoja. Poŋnoŋ lama ano bulmakao, silwa ano goul, weleŋqeqe eja ano emba ano kamel, doŋgi ii mamaga muro laligoja. ");
INSERT INTO ksr_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Somatanaa embia Saara iinoŋ emba waŋa totooŋ kolooŋ kambaŋ kanoŋ somatanaajoŋ meria moŋ mero. Maŋanoŋ esuhinaya kuuya ii meriaajoŋ buŋa qeŋ muro laligoja. ");
INSERT INTO ksr_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","“Somatananoŋ niinoŋ jojopaŋ qaa kokaeŋ jemambaajoŋ jeŋ kotoŋ nono: ‘Niinoŋ Keinan yoŋoo balonoŋ koi laligojento, giinoŋ mono meranaa embia ii Keinan yoŋoo naamboragiaga moŋ mende meŋ muba. ");
INSERT INTO ksr_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Kaeŋ qaagoto, gii mono maŋnaa gomaŋ mirinoŋ neenaa tinitosauruna yoŋoonoŋ kema meranaa emba ii iikanoŋa wama kawa.’ ");
INSERT INTO ksr_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Kaeŋ nijoro somatana ii kokaeŋ qisiŋ mube, ‘Niinoŋ kema jewe emba kanoŋ niwo mende kawaati eeŋ, niinoŋ mono nomaeŋ amaŋa?’ ");
INSERT INTO ksr_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Kaeŋ qisiŋ mube kokaeŋ meleeno: ‘Niinoŋ Pombaa jaanoŋ kema kaŋ ama meŋ laligoweti, iinoŋ mono Siwe gajobaya wasiro giwo keno kana kembagi, iikanoŋ toomoriaŋawo koloowaa. Kaeŋ neenaa maŋnaa gomaŋ mirinoŋ kema tinitosauruna yoŋoonoŋga meranaa emba ii meŋ kawa. ");
INSERT INTO ksr_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Noo tinitosauruna yoŋoonoŋ kema jojopaŋ qaa noojoŋ jenati, iikanoŋ mono kawaa gematanoŋ mende toroqeŋ somoŋgoŋ gombaa. Emba moŋ mende gombuti eeŋ, giinoŋ kileŋ jojopaŋ qaa iikawaa kasanoŋga loloowaga.’ ");
INSERT INTO ksr_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Kaeŋ jero kete apu roŋanoŋ kouma nama kokaeŋ qama koolijeŋ: ‘Oo Anutu, somatana Aabrahambaa Poŋa, nii kana koriga kajeŋi, ii mono uuaiŋgaa so mona toomoriaŋawo koloowaa. ");
INSERT INTO ksr_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Iiba, niinoŋ apu roŋ kokawaa kosianoŋ nanjeŋ. Kokaeŋ nambe emba saraŋ moŋnoŋ apu kosomambaajoŋ karo niinoŋ ii kokaeŋ ijomaŋa: “Gii saanoŋ koworaŋeŋganoŋga apu melaa moŋ nona newenaga?” ");
INSERT INTO ksr_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Kaeŋ jewe iinoŋ kokaeŋ meleema jewaa: “Saanoŋ nena kameluruga yoŋoo apu kaaŋiadeeŋ kosoŋ oŋomaŋa.” Kaeŋ meleema jewaati eeŋ, niinoŋ iikawaajoŋ kokaeŋ momaŋa: Poŋ giinoŋ ii somatanaa meriaa embiaga koloowaatiwaajoŋ meweeŋgojaŋ.’ ");
INSERT INTO ksr_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Uunanoŋga qamakooli ii mende qama koolidaborowe iikanondeeŋ Rebeka iinoŋ koworaŋeŋ sawiŋanoŋ aŋgoŋ iikanoŋ kajaa. Kaŋ apu roŋanoŋ kemeŋ apu kosoro niinoŋ iwaajoŋ kokaeŋ jejeŋa: ‘Saanoŋ apu moŋ nona newenaga.’ ");
INSERT INTO ksr_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Kaeŋ jewe iinoŋ uulaŋawo koworaŋeŋa sawiŋanoŋga mero kamaaro kokaeŋ jejaa: ‘Saanoŋ nena kameluruga yoŋoo apu kaaŋiadeeŋ oŋombe newuya.’ Kaeŋ jero newe kameluruna ii kaaŋagadeeŋ apu uŋuagija. ");
INSERT INTO ksr_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Uŋuagiro kokaeŋ qisiŋ mujeŋ, ‘Gii morowaa borataga?’ Qisiŋ mube kokaeŋ meleenja: ‘Nii Betuelwaa borataga. Au asana qagara Milka ano Naahor.’ Kaeŋ meleeno niinoŋ mopoŋ sewaŋanoŋ mondoŋ borojeŋjeŋ borianoŋ mewe uja. ");
INSERT INTO ksr_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Kambaŋ iikanondeeŋ namonoŋ kemeŋ usugoŋ Pombaa waeya meŋ mepeseejeŋa. Anutu somatana Aabrahambaa Poŋanoŋ mono kana dindiŋa nuano somatanaa kogaa mirinoŋ kaŋ esia meriaa embiaga koloowaatiwaajoŋ mokoloojeŋ. Kawaajoŋ Poŋ mepeseeŋ mujeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","“Kaeŋ kaŋ koi nanjeŋ. Kawaajoŋ oŋo somatana isosorooŋ sakitiuruta koloojutiwaa qaaya pondaŋ otaaŋ kiaŋkomuŋ mujuti eeŋ, ii mono qendeema jegi momaŋa. Kaeŋ mende ambuti eeŋ, qaa ii kaaŋiadeeŋ jegi momaŋa. Ii moma moŋgeŋ eleema kemambaajoŋ romoŋgomaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Kaeŋ jedabororo Laban ano Betuel yoronoŋ kokaeŋ meleema jeri, “Qaa koi Pombaanoŋga kaja. Kawaajoŋ noronoŋ qaa kaeŋ me kaeŋ jewotiwaa so qaago. ");
INSERT INTO ksr_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Moba, Rebekanoŋ koi nanja. Poŋnoŋ jeŋmindiŋ anjiwaa so saanoŋ ii wama kema somatagaa meria muna embia koloowaa.” ");
INSERT INTO ksr_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Kaeŋ jeri qaagara moma Aabrahambaa weleŋqeqe jawiŋanoŋ kamaaŋ Pombaa jaanoŋ namonoŋ kemeŋ usugoro. ");
INSERT INTO ksr_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Usugoro tegoro waama gesianoŋga goul ano silwa akadamuya iima-aiŋaiŋgiawo ano opo maleku teregiawo unjuma Rebeka muro. Kaaŋiadeeŋ kaleŋ iwoi tosia sewaŋgia somata ii nemuŋ naaŋa orono. ");
INSERT INTO ksr_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Oroma ii ano ejauruta iwo kagiti, iyoŋonoŋ nene qaaŋ neŋ rama rama gomaŋ tiiro egi. Egi gomaŋ ano waagi weleŋqeqe jawiŋanoŋ kokaeŋ jero: “Saanoŋ wasiŋ noŋgi somatanaanoŋ kemaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Kaeŋ jeroto, nemuŋ naaŋa yoronoŋ kokaeŋ meleeni, “Saanoŋ naamboranara mesaona toroqeŋ kambaŋ tosaaŋa weemboria ten kaeŋ nonowo laligowaa. Kawaa gematanoŋ saanoŋ ii wama kembu.” ");
INSERT INTO ksr_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Kaeŋ meleenito, weleŋqeqe jawiŋanoŋ kokaeŋ meleema jero mogi, “Weleŋ kanana kajeŋi, ii Poŋnoŋ kotuegoro toomoriaŋawo kolooja. Kawaajoŋ kambana mono mende qeŋ koriiwu. Mono wasiŋ noŋgi saanoŋ eleema kema somatanaanoŋ keumaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Kaeŋ jero moma kokaeŋ jeri, “Saanoŋ emba saraŋ ii qaji karo iyaŋa qisiŋ muboŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Kaeŋ jeŋ Rebeka qari karo kokaeŋ qisiŋ muri, “Gii eja kokawo kemambaa mojaŋ me qaago?” Qisiŋ muri “Saanoŋ kemaŋa,” jero. ");
INSERT INTO ksr_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kaeŋ jero nama naamboragara ii weleŋ embiawo wasiŋ oroŋgi Aabrahambaa weleŋqeqe jawiŋ ano iwaa ejauruta yoŋonoŋ ii uruama kembombaa aŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Kembombaa aŋgi kanoŋ nemuŋmaŋ naaŋ koaŋurutanoŋ Rebeka kotuegoŋ muŋ kokaeŋ jegi, “Oo naaŋ boranana, Poŋnoŋ saanoŋ kolooŋseisei gono giinoŋ gbiliuruga milyoŋa milyoŋa yoŋoo bemunjalegiaga koloowa. Yoŋonoŋ mono kotiiŋ kereurugia uŋuŋ haamo ama siti baloŋgia uŋuama aŋgoŋ koma laligowu.” ");
INSERT INTO ksr_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Kaeŋ jegi tegoro Rebekanoŋ weleŋqeqe embauruta yoŋowo waama kamel qagianoŋ uma rama weleŋqeqe jawiŋa otaaŋ keŋgi. Jawiŋ iinoŋ Rebeka wama galeŋ kono eleema kana keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Kema kema Keinan balonoŋ kougi. Aisaknoŋ baloŋ kawaa Saut leegeŋ distrik qata Negew kanoŋ laligoŋ kambaŋ iikanondeeŋ apu roŋ qata Ber Lahai Roi ii mesaoŋ baloŋ qararaŋkoŋkoŋanoŋ kaŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Kaŋ laligoŋ gomaŋ tiimambaa ano kanoŋ kuuŋa mesaoŋ baloŋ koria somata kanoŋ kema liligoŋ qaa romoŋgoŋ jaa riŋ waama iiro tosianoŋ kamel qagianoŋ rama iwaa kosianoŋ kawombaajoŋ kagi. ");
INSERT INTO ksr_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Kaeŋ kagi Rebekanoŋ jaa riŋ waama Aisak iima kamel qaganoŋ raroti, iikanoŋadeeŋ uulaŋawo luguŋ namonoŋ kamaaro. ");
INSERT INTO ksr_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Kamaaŋ weleŋqeqe jawiŋaajoŋ qisiŋ kokaeŋ jero, “Eja baloŋ korianoŋ endu nama jaasewaŋ qeŋ nonoma kaji, ii moronoŋ?” Kaeŋ jero kokaeŋ meleeno, “Iinoŋ mono somatanaa meriaga.” Kaeŋ meleeno moma waŋ kawaseŋa horoŋ jaasewaŋa esuuro. ");
INSERT INTO ksr_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Esuuro aitoŋgoŋ weleŋqeqe jawiŋanoŋ iwoi kuuya ama meŋ laligoroti, iikawaa sunduya ii Aisak jero moro. ");
INSERT INTO ksr_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Moro tegoro Aisaknoŋ Rebeka wano nemuŋa Saarawaa opo sel kuuŋanoŋ uma laligoro kanageŋ mero embia kolooro uutanoŋ jopagoŋ muŋ laligoro. Aisakwaa nemuŋanoŋ komuro wosobiri uutanoŋ laligorotiwaajoŋ ama uluŋkoleŋa kaeŋ mokolooro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Aisaknoŋ emba mero maŋa Aabrahamnoŋ embia moŋ qata Ketura mero. ");
INSERT INTO ksr_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Mero Keturanoŋ Aabrahambaa merauruta kokaeŋ oŋono: Zimran, Joksan, Medan, Midian, Isbak ano Suua. ");
INSERT INTO ksr_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Joksanoŋ merawoita qagara Seba ano Dedan yoroo maŋgaraga kolooro. Dedan iinoŋ Asur kanageso, Letus kanageso ano Leum kanageso yoŋoo beŋisigiaga kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midiambaa merauruta ii Efa, Efer, Hanok, Abida ano Elda. Ii kuuya Keturawaa esauruta kolooŋ laligogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Aabrahamnoŋ esuhinaya kuuya ii meria Aisak buŋa qeŋ muro. ");
INSERT INTO ksr_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ii muroto, embauruta waŋgia mende memeta yoŋoo meraurugia yoŋoojoŋ kaleŋ iwoi jaŋ qeŋ mendeema oŋono. Mendeema oŋoma jaawo laligoŋ wasiŋ oŋono dagia Aisak mesaoŋ baloŋ moŋ weeŋ koukoutanoŋ baageŋ kanoŋ keŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Aabrahamnoŋ laligoŋ kouro mindimindiri yambuya 175 kolooro komuro. ");
INSERT INTO ksr_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Laaligo yambuyaa jaŋgoyanoŋ uuta kolooŋ sokono waziiŋ eja waŋa kolooŋ sewaŋ aasoŋ konoga horoŋ goroŋ qeŋ komuro Anutunoŋ wano tinitosauruta komugiti, iyoŋoonoŋ kema toroqero. ");
INSERT INTO ksr_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Komuro merawoita Aisak ano Ismael yoronoŋ maŋgaraa qamoya meŋ kema Makpela kobaanoŋ roŋ koni. Kobaa ii Hit eja Efron Zoharwaa meria iwaa baloŋ korianoŋ Mamre gomaŋ mirinoŋa weeŋ koukoutanoŋ baageŋ eja. ");
INSERT INTO ksr_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Aabrahamnoŋ baloŋ koria ii Hit kanageso yoŋoonoŋga sewaŋa meroti, iikanoŋ ii ano embia Saara ii roŋ koma oroŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Aabrahamnoŋ komuro Anutunoŋ meria Aisak kotuegoŋ muŋ laligoro. Iinoŋ Negew balonoŋ apu roŋ qata Ber Lahai Roi (Laaligoyawo laligoŋ niimakejiwaa apu roŋa) iikawaa kosianoŋ rama laligoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Iijipt emba Haagar iinoŋ Saarawaa weleŋ embia laligoro Aabrahamnoŋ mero koro ama meria Ismael mero. Ismaelwaa merauruta yoŋoo qa areŋgia kokaeŋ: ");
INSERT INTO ksr_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismaelwaa merauruta yoŋoo qagia ano koloogitiwaa areŋgia ii kokaeŋ: Meria mutuya qata Nebaiot. Iwaa gematanoŋ Kedar, Adbel, Mibsam, ");
INSERT INTO ksr_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","toroqeŋ Misma, Duma ano Masa, ");
INSERT INTO ksr_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Nafis ano Kedema. ");
INSERT INTO ksr_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ismaelwaa meraurutanoŋ kaeŋ kolooŋ asa tuuŋgia 12 kolooŋ laligoŋ kougi. Asa qagia qagiti, iikawaa so opo kuuŋ tambogia ano jigo mirigia kaaŋagadeeŋ qama meŋ laligoŋ kougi. ");
INSERT INTO ksr_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismaelnoŋ laligoŋ kouro yambuya mindiriŋ 137 kolooro komuro. Kaeŋ eja waŋa kolooŋ sewaŋ aasoŋ konoga horoŋ goroŋ qeŋ komuro Anutunoŋ wano tinitosauruta komugiti, iyoŋoonoŋ kema toroqero. ");
INSERT INTO ksr_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ismaelwaa gbiliuruta yoŋonoŋ koriganoŋ koriganoŋ deema kema laligoŋ baloŋ qagara Hawila ano Suur yoroo batugaranoŋ gomaŋ meŋ laligogi. Gomaŋgia ii Iijipt kantriwaa jawoyanoŋga kanaiŋ weeŋ koukoutanoŋ Assiria waageŋ keŋgiti, kana iikawaa kosianoŋ kanoŋ eja. Ismaelwaa gbiliuruta yoŋonoŋ Aabrahambaa gbiliuruta tosaaŋa kuuya ii kerekere ama oŋoma laligogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Aabrahambaa meria Aisak iwaa gbiliuruta yoŋoo qa areŋgia ii kokaeŋ: Aabrahambaa meria Aisak. ");
INSERT INTO ksr_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisaknoŋ yambuya 40 kolooro Mesopotemia (Padan Aram) kantrinoŋa Aram eja qata Betuelwaa borata Rebeka embia mero. Rebekawaa naaŋa ii Aram eja qata Laban. ");
INSERT INTO ksr_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Aisakwaa embianoŋ aruŋa laligorotiwaajoŋ ama Poŋ qama kooliŋ muro. Qama kooliŋ muro qamakoolia moro Rebekanoŋ koro ano. ");
INSERT INTO ksr_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Koro ano merawoi yoronoŋ nemuŋgaraa goroŋ uutanoŋ utama aori. Ii moma kokaeŋ jero: “Iwoi koi kaaŋa ii mono naambaajoŋ asugiŋ nonja?” Kaeŋ jeŋ kema iikawaajoŋ Poŋ qisiŋ muro. ");
INSERT INTO ksr_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Qisiŋ muro kokaeŋ ijoro: “Goo goroŋ uuganoŋ tuuŋ woi yoŋoo beŋisigiaga ejao. Iyoroonoŋga kanageso woi asugiŋ deema laligowuya. Ejemba tuuŋ moŋnoŋ tuuŋ alia uŋuuguŋ ku-usuŋgia kotakota koloowuya. Datanoŋ koga weleŋ qeŋ muŋ laligowaa.” ");
INSERT INTO ksr_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Mera meme kambaŋanoŋ kaŋ kuuro goroŋ uutanoŋ mera sunesune woi eri. ");
INSERT INTO ksr_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Wala goroŋanoŋga asugiroti, iwaa selianoŋ jejegbili kolooro sele juyanoŋ selia kuuya sokoma ero. Kawaajoŋ qata Iisoo (juyawo) qagi. ");
INSERT INTO ksr_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Iwaa kanianoŋ koganoŋ Iisoowaa kana gbakoyanoŋ borianoŋ meŋ asugiro. Kawaajoŋ iwaa qata Jeikob qagi. (Jeikob qaa kawaa kania woi: gbako ano tiligoja.) Aisaknoŋ yambuya 60 kolooro kambaŋ kanoŋ Rebekanoŋ merawoita woi ii orono. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Mera woi iyoronoŋ asugiŋ somariiri Iisoonoŋ borojaŋ gawombaa kania tororo moma yagoŋ pondaŋ jolonoŋ laligomambaajoŋ moroto, koganoŋ eja bonjoŋa kolooŋ kaparaŋ koma mirinoŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisaknoŋ duuyaa oroya nemambaa moma laligoro. Kawaajoŋ uutanoŋ Iisoo mamaga jopagoŋ muŋ laligoroto, Rebekanoŋ uu womboyanoŋ Jeikob mamaga jopagoŋ muŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Kambaŋ moŋnoŋ Jeikobnoŋ koziŋ meŋ iyaŋaajoŋ nene qaaŋ ooŋ raro datanoŋ jolonoŋga kaŋ selia bimooro wosoya mamaga kiro. ");
INSERT INTO ksr_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Kaeŋ kiro Jeikob kokaeŋ ijoro: “Selena bimooro wosona mamaga nijiwaajoŋ mono uulaŋawo koziŋ qaaŋa nejoŋgbala ii nona nemaŋa.” Kawaajoŋ qata Edom (nejoŋgbala) qagi. ");
INSERT INTO ksr_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Kaeŋ ijoro Jeikobnoŋ jero: “Dana, gii wala asuginagi, qabuŋaga ii mono wala togoŋ nona nene qaaŋ ii saanoŋ gombe newa.” ");
INSERT INTO ksr_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Kaeŋ jero qaa kokaeŋ meleema muro: “Kona moba, nii komumambaajoŋ anjeŋ. Kawaajoŋ wala asugiwetiwaa qabuŋananoŋ mono nomaeŋ ilaaŋ nonaga?” ");
INSERT INTO ksr_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Kaeŋ meleema muro kokaeŋ ijoro: “Iikawaa qaaya ii mono wala jojopaŋ qaanoŋ jeŋ kotiina momaŋa.” Kaeŋ ijoro ii jojopaŋ qaanoŋ jeŋ kotiiŋ muŋ wala asugirotiwaa qabuŋaya ii Jeikob togoŋ muro nenenoŋ sewaŋa mero. ");
INSERT INTO ksr_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Sewaŋa meŋ bered ano koziŋ qaaŋa Iisoo muro neŋ waama nama mesaoŋ keno. Iisoonoŋ wala asugirotiwaa qabuŋaya ii iikawaajoŋ moro kamakamaata kolooro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Wala Aabrahambaa kambaŋanoŋ bodi kolooro. Kaaŋagadeeŋ Aisakwaa kambanoŋ bodi mombo kolooŋ gomaŋ sokoma ero. Bodi kolooro Aisaknoŋ mesaoŋ Filistin yoŋoo kiŋ poŋgia qata Abimelek iwaa gomanoŋ Gerar kanoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Kema laligoro Poŋnoŋ asugiŋ muŋ kokaeŋ jero: “Gii Iijipt balonoŋ mende kemba. Gomaŋ koi buŋaga koloowaatiwaajoŋ jeŋ kotoweti, mono kokanoŋ rama laligowa. ");
INSERT INTO ksr_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Niinoŋ maŋga Aabrahambaajoŋ soomoŋgo qaa muŋ ii jojopaŋ qaanoŋ jeŋ kotiiweti, ii mono galeŋ kombe hoŋawo koloowaa. Niinoŋ baloŋ kuuya koi ii gii ano goo gbiliuruga oŋoo buŋaga qeŋ oŋomaŋa. Kawaajoŋ saanoŋ baloŋ kokanoŋ rama waba laligona niinoŋ giwo laligoŋ kotuegoŋ gombe laligowaga. ");
INSERT INTO ksr_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Niinoŋ gbiliuruga kolooŋseisei oŋombe jaŋgogianoŋ sombinoŋ seŋgelao rama kenjuti, mono iikawaa so koloowuya. Kaeŋ aŋgi baloŋ kuuya koi ii oŋoo buŋaga qeŋ oŋomaŋa. Goo gbiliuruga yoŋoonoŋga mombaajoŋ ama noo kotumotuenanoŋ mono namowaa kanageso tuuŋ kuuya yoŋoo qagianoŋ uro oyaŋboyaŋ mokoloowuya. ");
INSERT INTO ksr_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Niinoŋ kokaembaajoŋ kaeŋ amaŋa: Aabrahamnoŋ noo qaana teŋ koma laligoro. Jojopaŋ qaana, jeŋkooto qaana ano kana qaana muweti, iinoŋ ii kuuya otaaŋ laligoro.” ");
INSERT INTO ksr_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Anutunoŋ kaeŋ jero Aisaknoŋ toroqeŋ Gerar taonoŋ rama laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Laligoro gomaŋ iikawaa ejia yoŋonoŋ embiaajoŋ qisiŋ mugi kokaeŋ jero, “Ii naanaga.” Kaeŋ jeŋ uutanoŋ kokaeŋ romoŋgoro: “Rebekawaa kaitanianoŋ iima-aiŋaiŋawo koloojiwaajoŋ eja iyoŋonoŋ mono iwaajoŋ ama nii nugi komumambo.” Kaeŋ romoŋgoŋ “Ii embanaga,” kaeŋ jemambaajoŋ keeta moma laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Aisaknoŋ iikanoŋ kambaŋ koriga laligoŋ kouma kambaŋ moŋnoŋ embiawo suuŋgoŋ aŋgoŋ aori Filistin yoŋoo kiŋgia Abimelek iinoŋ jeŋgenanoŋga seleeŋgeŋ jaa riro kemero ii iriiro. ");
INSERT INTO ksr_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Iriima Aisak oono karo kokaeŋ ijoro moro: “Moba, iinoŋ mono goo embaga kolooja. Mono naambaajoŋ ‘Ii naanaga,’ jena?” Kaeŋ moma kokaeŋ meleema muro: “Nii iwaajoŋ ama nugi komumambotiwaajoŋ romoŋgoŋ kaeŋ jewe.” ");
INSERT INTO ksr_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Meleema muro kiŋ Abimeleknoŋ kokaeŋ ijoro: “Gii mono naa terega ama nononjaŋa? Noo ejauruna yoŋoonoŋa moŋnoŋ mono afaaŋgoŋ goo embagawo enaga. Kaeŋ kolooro giinoŋ kondoona siŋgisoŋgowaa qaa lombotanoŋ mono nonoo qanananoŋ unaga.” ");
INSERT INTO ksr_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Kaeŋ jeŋ kanageso tuuŋa kuuya yoŋoojoŋ jeŋkooto kokaeŋ ama oŋono: “Moŋnoŋ moŋ eja koi me iwaa embia meŋ boliŋ orombaati, ii mono koomuwaa buŋaga jeŋ tegoniŋ komuwaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Aisaknoŋ baloŋ iikanoŋ nene gawoŋ koma komoro Poŋnoŋ kotuegoŋ muro yambu iikanoŋ hoŋa komoroti, ii 100:waa so seiŋ kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Kaeŋ kolooro toomoriaŋ somasomata mokolooŋ laligoro esuhinayanoŋ toroqeŋ somariiŋ uro kindiŋbiri eja qaqabuŋayawo kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Iwaanoŋ lama, meme (noniŋ) ano bulmakao tuuŋa tuuŋa ii kolooŋ seigi. Kaaŋiadeeŋ weleŋqeqeuruta mamaga oŋono laligogi. Kawaajoŋ Filistin yoŋonoŋ ii iima kanaiŋ goroŋkiki ama gemaqeqe qaa jegi. ");
INSERT INTO ksr_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Gemaqeqe qaa jeŋ maŋa Aabrahambaa weleŋqeqeurutanoŋ apu roŋ iwaa kambanoŋ osogiti, ii kuuya balonoŋ qeŋ turudaborogi. ");
INSERT INTO ksr_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Kaeŋ kolooro kiŋ Abimeleknoŋ Aisak kokaeŋ ijoro: “Gii ku-usuŋgawo kolooŋ mamaga nunuugujaŋiwaajoŋ mono kololooŋ nonomesaoŋ moŋgeŋ kemba.” ");
INSERT INTO ksr_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Kaeŋ jero moma baloŋ ii mesaoŋ Gerar dooŋanoŋ kema kemeŋ opo sel kuuŋ mororoŋgoŋ kuuŋ kanoŋ rama laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Rama laligoŋ apu roŋ maŋa Aabrahambaa kambanoŋ osogito, Aabraham komuro Filistin yoŋonoŋ qeŋ turugiti, ii Aisaknoŋ jero mombo osoŋ luluuma meagogi. Meagogi maŋanoŋ apu roŋ qagia qaroti, Aisaknoŋ ii iikayadeeŋ mombo qaro. ");
INSERT INTO ksr_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Kaeŋ qaro weleŋqeqeurutanoŋ dondooŋanoŋ apu roŋ osoŋ laligoŋ apu roŋ moŋ apuya soraaya ujuŋgoŋ kouroti, ii mokoloogi. ");
INSERT INTO ksr_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ii mokoloogito, Gerar yoŋoo lama bulmakao galeŋgianoŋ Aisakwaa lama bulmakao galeŋuruta yoŋowo kanaiŋ aŋgowowo ama qaa kokaeŋ jegi, “Oo ii nonoonoŋga!” Iyaŋawo aŋgowowo qaa kaeŋ jegitiwaajoŋ ama Aisaknoŋ apu roŋ iikawaa qata Esek (Aŋgowowo) qaro. ");
INSERT INTO ksr_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Iikawaa gematanoŋ apu roŋ moŋ mombo osogi iikawaajoŋ kaaŋagadeeŋ aŋgowowo aŋgi. Kaeŋ aŋgitiwaajoŋ ama apu roŋ iikawaa qata Sitna (Kerekere) qaro. ");
INSERT INTO ksr_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Kaeŋ qama baloŋ ii mesaoŋ kema apu roŋ moŋ mombo jero osogi. Apu roŋ iikawaajoŋ aŋgowowo qaa mende kolooro kawaajoŋ qata Rehobot (Tintiŋa awaa) qama qaa kokaeŋ jero: “Kete Poŋnoŋ tintiŋa awaa nonono saanoŋ baloŋ kokanoŋ laligoŋkolooŋ seisei amboŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Kaeŋ jeŋ kanoŋ laligoŋ mesaoŋ Beerseba gomanoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Beerseba keno gomantiiŋa iikanoŋ Poŋnoŋ asugiŋ muŋ kokaeŋ ijoro: “Niinoŋ maŋga Aabrahambaa Anutuya koloojeŋ. Niinoŋ giwo laligoŋ kotuegoŋ goma laligomaŋa. Kawaajoŋ toroko mende moba. Niinoŋ gawoŋ ejana Aabrahambaajoŋ ama goo gbiliuruga kolooŋseisei oŋombe jaŋgogianoŋ uuta koloowaa.” ");
INSERT INTO ksr_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Kaeŋ ijoro Aisaknoŋ siimoloŋ alata moŋ iikanoŋ meŋ Pombaa qata qamago qama kooliro. Qama kooliŋ opo kuuŋa mororoŋgoŋ meŋ rama laligogi. Laligoŋ jero weleŋ ejaurutanoŋ apu roŋ moŋ iikanoŋ osogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Aisaknoŋ Beerseba laligoro kambaŋ moŋnoŋ kiŋ Abimelek iinoŋ Gerar taoŋ mesaoŋ iwaanoŋ karo. Goro qaa jeje alia Ahuzat ano manjaqeqe tuuŋaa kawali galeŋa Fikol yoronoŋ iwo motooŋ kagi. ");
INSERT INTO ksr_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Kagi Aisaknoŋ kokaeŋ qisiŋ oŋono: “Oŋo kere moma noma baloŋgianoŋga konjoma noŋgito, kileŋ mono naambaajoŋa noonoŋ koi kaju?” ");
INSERT INTO ksr_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Qisiŋ oŋono kokaeŋ meleeŋgi: “Poŋnoŋ giwo nanji, nono ii asuganoŋ iima moma kotojoŋ. Kawaajoŋ kokaeŋ romoŋgojoŋ: ‘Nononoŋ giwo soomoŋgo ambombaajoŋ aiŋnana mojoŋ. Saanoŋ gii ano nonoo batunananoŋ soomoŋgo ama ii jojopaŋ qaanoŋ jeŋ kotiiniŋ kokaeŋ ewaa: ");
INSERT INTO ksr_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Nono kakasililiŋ moŋ mende ama goninto, kambaŋ so awaa ama goma gomesaoniŋ luaenoŋ miriga mesaoŋ kema kaŋ laligona. Iikawaa so giinoŋ kaaŋiadeeŋ nono iwoi bologa moŋ mende ama nonoma laligowa.’ Kambaŋ kokaamba Poŋnoŋ kotuegoŋ gono laligojaŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Kaeŋ jegi Aisaknoŋ jejelombaŋ mozozoŋgoŋ ooŋ ano nene qaaŋ neŋ ragi. ");
INSERT INTO ksr_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Rama eŋ gomaamba umugawo waama soomoŋgogia somoŋgoŋ aoŋ ii jojopaŋ qaanoŋ jeŋ kotiigi. Jeŋ kotiigi Aisaknoŋ ii wasiŋ oŋono luae qaganoŋ mesaoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Keŋgi weeŋ iikanoŋadeeŋ Aisakwaa weleŋ eja yoŋonoŋ kaŋ apu roŋ moŋ osogiti, iikawaa sunduya kokaeŋ ijogi: ");
INSERT INTO ksr_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","“Nono apu mokoloojoŋ.” Kaeŋ ijogi moma apu roŋ iikawaa qata Siba qaro. Kawaajoŋ taoŋ iikawaa qata ii kambaŋ kokaamba kaaŋagadeeŋ toroqeŋ Beerseba qamakejoŋ. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Iisoonoŋ yambuya 40 kolooro Hit emba woi orono. Qagara Judit, maŋa qata Beeri ano Basemat, maŋa qata Elon. ");
INSERT INTO ksr_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Emba iyoronoŋ Aisak ano Rebeka uukonduŋ ano wosobiri somata totooŋ mokolooŋ oroma laligori. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Aisaknoŋ laligoŋ kouma eja waŋa kolooro jaaya umuŋ kono iwoi mombo iima kotomambaajoŋ amamaaro. Kaeŋ amamaaŋ mutu meria Iisoo koma horoŋ muro karo kokaeŋ ijoro: “Merana moba.” Ii moma kokaeŋ meleema muro: “Amana, nii koi nanjeŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Meleema muro kokaeŋ ijoro: “Moba, nii eja waŋa koloojeŋ. Naa kambanoŋ komumaŋati, ii mende mojeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Kawaajoŋ gii saanoŋ tiwo wasaga ano kisare gesoga meŋ jolonoŋ kema orowaa borojaŋ meŋ qeŋ noonoŋ kawa. ");
INSERT INTO ksr_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Kaŋ nene naaŋawo aiŋnaa so ooŋ mozozoŋgoŋ meŋ kaŋ nona nemaŋa. Ii neŋ nama kotumotue gomaŋa. Ii wala gombe tegoro niinoŋ iikawaa gematanoŋ saanoŋ komumaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Aisaknoŋ meria Iisoowaajoŋ qaa kaeŋ jero Rebekanoŋ ii geja ama moro. Moro Iisoonoŋ mesaoŋ tiwojuŋ meŋ oro qeŋ maŋa mumambaajoŋ juŋnoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Keno Rebekanoŋ meria Jeikob qaa kokaeŋ ijoro: “Merana moba, maŋganoŋ daga Iisoo qaa kokaeŋ ijoro mojeŋa: ");
INSERT INTO ksr_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Gii mono oro meŋ kaŋ noma nene naaŋawo ooŋ mozozoŋgoŋ nona nemaŋa. Neŋgo Pombaa jaasewaŋanoŋ kotumotue gomaŋa. Ii wala gombe tegoro iikawaa gematanoŋ saanoŋ komumaŋa.’ ");
INSERT INTO ksr_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Kawaajoŋ merana, mono geja awaagadeeŋ ama moba. Qaa dologo koi jeŋ kotoŋ gomaŋati, gii mono iikawaa so amba. ");
INSERT INTO ksr_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Mono meme tuuŋnoŋ kema iikanoŋa meme (noniŋ) doŋa kelegawo woi meŋ kaŋ nona niinoŋ iikanoŋ maŋgaa aiŋaa so nembanene naaŋawo ooŋ mozozoŋgomaŋa. ");
INSERT INTO ksr_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ooŋ mozozoŋgowe meŋ kema amaga muna neŋ kotumotue gonaga. Iikawaa gematanoŋ saanoŋ komuwaa.” ");
INSERT INTO ksr_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Kaeŋ jero Jeikobnoŋ moma nemuŋa Rebeka kokaeŋ ijoro: “Nemuna moba, dana Iisoonoŋ sele juyawo koloojato, noo selenanoŋ solaŋa kolooja. ");
INSERT INTO ksr_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Maŋnanoŋ nii noosiriŋ monagati eeŋ, nii iwaa jaasewaŋanoŋ tiliqili eja kaaŋa koloowe moma nombabo. Kaeŋ moma nono kotumotue qaagoto, qasumasuaa horowe neenaa qananoŋ ubabo.” ");
INSERT INTO ksr_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Kaeŋ ijoro nemuŋanoŋ kokaeŋ jero moro: “Merana, qasuaaŋ gonagati eeŋ, iikanoŋ mono saanoŋ noo qananoŋ ubaa. Giinoŋ mono kileŋ qaa jejeŋi, ii moma teŋ koma kema iwoi ii meŋ kawa.” ");
INSERT INTO ksr_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Kaeŋ jero kema meme (noniŋ) woi meŋ kaŋ nemuŋa muro. Muro nene aiŋawo maŋanoŋ naaŋa moroti, iikawaa so ooŋ mozozoŋgoro. ");
INSERT INTO ksr_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ooŋ mutu meria Iisoowaa opoqiisi malekuya awaa totooŋ opo kowianoŋ galeŋ konoti, ii meŋ meria kanageŋa Jeikob muro mouro. ");
INSERT INTO ksr_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Mouro meme (noniŋ) selia ii meŋ boria kokosiiŋ aroya solaŋa esuuro. ");
INSERT INTO ksr_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Esuuŋ nene aiŋawo ano bered ooroti, ii meŋ Jeikobwaa borianoŋ ano. ");
INSERT INTO ksr_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ano meŋ maŋaanoŋ kema “Ama!” jero. Jero kokaeŋ meleeno: “Oo merana, gii moronoŋ?” ");
INSERT INTO ksr_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Kaeŋ meleeno maŋa kokaeŋ ijoro: “Nii mutu meraga Iisoo. Jeŋ kotoŋ nonjaŋi, nii mono iikawaa so andaborojeŋ. Saanoŋ waama rama orona meŋ kajeŋi, ii neŋ kotuegoŋ nomba.” ");
INSERT INTO ksr_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Kaeŋ ijoro moma meria kokaeŋ qisiŋ muro: “Merana, ii mono nomaeŋ uulaŋawo mokoloojaŋa?” Qisiŋ muro kokaeŋ meleeno: “Anutu, goo Poŋganoŋ mono ilaaŋ nono ii uulaŋawo mokoloojeŋa?” ");
INSERT INTO ksr_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Kaeŋ meleeno Aisaknoŋ Jeikob kokaeŋ ijoro: “Merana, gii oŋanoŋ merana Iisoo koloojaŋ me qaago, ii momambaajoŋ mono saanoŋ kosonanoŋ koi kana goosirimaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Kaeŋ ijoro maŋa Aisakwaa kosianoŋ keno oosiriŋ moma kokaeŋ jero: “Qaa aroganoŋ Jeikobwaa aroya koloojato, boroganoŋ Iisoowaa boria kaaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Boria juyawo data Iisoowaa boro tani kaaŋa koloorotiwaajoŋ Aisaknoŋ ii mende moma kotoŋ muŋ kotuegoŋ mumambaajoŋ ano. ");
INSERT INTO ksr_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Kileŋ mombo kokaeŋ qisiŋ muro: “Gii oŋanoŋ merana Iisooga me qaago?” Qisiŋ muro kokaeŋ meleeno: “Nii mono Iisooga.” ");
INSERT INTO ksr_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Kaeŋ meleeno kokaeŋ ijoro: “Merana saanoŋ oroga tosaaŋa nona neŋ kotumotuena gomaŋa.” Kaeŋ ijoro ii muro nero. Nero wain apu tosaaŋa motooŋ maama muro nero. ");
INSERT INTO ksr_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Neŋ nama meria kokaeŋ ijoro: “Gii saanoŋ kosonanoŋ kaŋ buuna kitoŋ newa.” ");
INSERT INTO ksr_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Kaeŋ ijoro kosianoŋ kema buuta kitoŋ nero. Nero opoqiisi malekuyaa moroŋa moma kotuegoŋ muŋ kokaeŋ jero: “Aha merana, Poŋnoŋ juŋ kotuegoro eji, noo meranaa selianoŋ uŋkoowa awaa soro kaaŋa kolooro mojeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Anutunoŋ mono siwewaa bedu uŋjijiya ano namowaa toomoriaŋa togoŋ gono yaka logoyaga, yagoŋ dumuŋ kota ano wain apu iwoiga ii honoŋa qaa asugiŋ seiwu. ");
INSERT INTO ksr_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Kantria kantria yoŋonoŋ mono weleŋ qeŋ goma laligowu. Kanageso tuuŋa tuuŋa yoŋonoŋ mono simiŋ kuma goma laligowu. Giinoŋ mono geeŋgaa daremunuruga yoŋoo eja poŋgia kolooŋ laligowa. Nemuŋgaa merauruta yoŋonoŋ mono simiŋ kuma goma laligowu. Moŋnoŋ qasuaaŋ gombaati, qasumasuaanoŋ mono iwaa qaganoŋ ubaa. Moŋnoŋ kotuegoŋ gombaati, kotumotuenoŋ mono iwaa qaganoŋ ubaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aisaknoŋ Jeikob kotuegoŋ mudabororo maŋaanoŋ miri uuta mesaoŋ seleeŋgeŋ keno alanzaŋ iikanoŋadeeŋ data Iisoonoŋ tiwojuŋ laligoro tegoro mirinoŋ karo. ");
INSERT INTO ksr_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Kaŋ iinoŋ kaaŋagadeeŋ nene naaŋawo ooŋ mozozoŋgoŋ meŋ kaŋ maŋa muŋ kokaeŋ ijoro: “Amana, saanoŋ waama rama orona tosaaŋa neŋ kotumotuega nomba.” ");
INSERT INTO ksr_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Kaeŋ ijoro maŋa Aisaknoŋ kokaeŋ qisiŋ muro: “Gii moronoŋ?” Qisiŋ muro kokaeŋ meleema ijoro: “Nii mutu meraga Iisoo.” ");
INSERT INTO ksr_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Kaeŋ ijorotiwaajoŋ Aisaknoŋ aaruŋ lalaŋaniŋ jeneŋa mamaga ororo kokaeŋ ijoro: “Gii mende kana iikanoŋ tiwojuŋ eja moŋnoŋ oro meŋ kaŋ nonjaati, ii mono moronoŋ? Iinoŋ ii nono neŋ kotumotuena mono mudaborojeŋa. Ii mudaborojeŋatiwaajoŋ iikanoŋ mono oŋanoŋ iwaa qaganoŋ eŋ ubaa.” ");
INSERT INTO ksr_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Iisoonoŋ maŋaa qaa jeta ii moma uukonduŋ ama amburereŋ meŋ silama saama maŋaajoŋ kokaeŋ weleno: “Amana, nii mono kaaŋagadeeŋ kotuegoŋ nomba.” ");
INSERT INTO ksr_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Kaeŋ welenoto, maŋanoŋ meleema ijoro: “Koganoŋ mono tiliqili qaganoŋ kaŋ goonoŋ kotumotue tagoŋ meŋ kenja.” ");
INSERT INTO ksr_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Kaeŋ ijoro Iisoonoŋ kokaeŋ jero: “Konanoŋ mono indiŋa woi tiligoŋ nono laligojeŋ: Iinoŋ wala asugiwetiwaa qabuŋaya ii wala nuandabororo ano kete noonoŋ kotumotue ii kaaŋagadeeŋ tagoŋ nuama meja. Kawaajoŋ qata Jeikob (tiliqili eja) qamakejoŋi, ii mono soyanoŋ kolooja. Kotumotue moŋ mono noojoŋ eŋ gonja me qaago?” ");
INSERT INTO ksr_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Kaeŋ jero maŋanoŋ Iisoowaajoŋ kokaeŋ meleeno: “Moba, niinoŋ koga goo eja poŋga laligowaatiwaajoŋ kuuŋ mujeŋ. Tinitosauruta kuuya yoŋonoŋ ii weleŋ qeŋ muŋ laligowutiwaajoŋ jeŋ kotoŋ oŋonjeŋ. Yaka logoya, yagoŋ dumuŋ kota ano wain apu iwoi ii mono jedaborojeŋa Anutunoŋ ii muŋ laligowaa. Oo merana, naa kotumotuena moŋ toroqeŋ eŋ nonagi, ii gombenaga? Ii mono amamaajeŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Kaeŋ meleeno maŋaajoŋ kokaeŋ jero: “Oo amana, kotumotue motooŋgo iigadeeŋ mono eŋ gonja me nomaeŋ? Oo amana, mono nii moŋ kotuegoŋ nomba.” Kaeŋ jeŋ kanaiŋ silama saaro. ");
INSERT INTO ksr_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Saaro maŋanoŋ kokaeŋ meleema ijoro: “Moba, giinoŋ mono baloŋ toomoriaŋawo mesaoŋ koriganoŋ kema laligowa. Iikanoŋ sombimbaa bedu uŋjijiya ii kanakeewaŋga mende kamaaŋkebaa. ");
INSERT INTO ksr_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Gii manjawaa soo somatanoŋ ejemba laŋ uŋuŋ laaligoga aŋgoŋ koma kogaa weleŋqeqeya kamakamaata kolooŋ laligowa. Kaeŋ laligowagato, kanawaeŋ qeŋ koga utama muŋ kambaŋ iikanoŋ kareŋ motoŋ iwaa galeŋ koŋkoŋa uŋuŋ yakariŋ geeŋgaa nanaŋ laligowa.” ");
INSERT INTO ksr_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Maŋanoŋ Jeikob kotumotueya muroti, Iisoonoŋ iikawaajoŋ ama kanaiŋ koga uukazi moma muŋ laligoro. Aŋaa uutanoŋ kaeŋ moma alia mombaajoŋ kokaeŋ jero: “Maŋnaraa koomuyaa kambaŋanoŋ mono torija. Iinoŋ komuro jiŋgeŋ qama saama kambaŋ iikanoŋ saanoŋ kona Jeikob qewe komuwaa.” ");
INSERT INTO ksr_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Iisoowaa momoyanoŋ kaaŋa kolooro moŋnoŋ iikawaa buzuya moma Rebekawaanoŋ kema jero moma meria kanageŋa Jeikobwaajoŋ qaa ano kema wama karo kokaeŋ ijoro: “Moba, daga Iisoonoŋ mono iroŋa meleeno qaganoŋ uro guro komuwagatiwaajoŋ romoŋgoja. ");
INSERT INTO ksr_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Kawaajoŋ merana, niinoŋ qaa gijomaŋati, ii mono teŋ komba. Mono keteda koi waama oloŋ koma Haran gomanoŋ naana Labambaanoŋ kemba. ");
INSERT INTO ksr_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Kema iwo kambaŋ tosaaŋa toroqeŋ laligona dagaa uuduuduuyanoŋ olomoowaa. ");
INSERT INTO ksr_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Uuduuduuya olomooŋ kamaaro iwoi ama munati, ii duduurogo niinoŋ kawaa gematanoŋ goojoŋ qaa ambe karo guama kawu. Iinoŋ guro komuna moŋnoŋ ii qero komuwabo. Mono naambaajoŋ kambaŋ motooŋgo iikanondeeŋ ororoŋ qaoni oromesaoŋ saamambo.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebekanoŋ loya Aisakwaanoŋ kema kokaeŋ ijoro: “Niinoŋ eŋarowoina Hit emba yoroojoŋ ama toroqeŋ laligomambaajoŋ mojona tiiro siimbobolo momakejeŋ. Jeikobnoŋ kaaŋagadeeŋ Hit yoŋoo boraurugia yoŋoonoŋga moŋ eŋarowoinara kaaŋa embiaga mewabo. Baloŋ kokanoŋ koloogiti, iyoŋoo siligia mono kaaŋagadeeŋ eja. Kaaŋa moŋ meŋ kawaboti eeŋ, niinoŋ mono laaligona naambaajoŋ toroqeŋ laligowenaga? Siimbobolonanoŋ mono toroqeŋ honoŋa qaa koloowabo.” Rebekanoŋ kaeŋ jero. ");
INSERT INTO ksr_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Kaeŋ jero Aisaknoŋ Jeikob koma hororo karo kotuegoŋ kokaeŋ jeŋ kotoŋ muro: “Merana, gii Keinan yoŋoo naamboragia yoŋoonoŋga moŋ embaga mende mewa. ");
INSERT INTO ksr_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Kaeŋ qaagoto, mono waama Mesopotemia (Padan Aram) balonoŋ kema nemuŋgaa maŋa Betuelwaa mirinoŋ keuma owaga Labambaa borauruta yoŋoonoŋga moŋ embaga mewa. ");
INSERT INTO ksr_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Embaga mena Anutu, ku-usuŋ kuuyaa Toyanoŋ mono gii kotuegoŋ kolooŋseisei gono gbiliuruga yoŋoo jaŋgogianoŋ seiro kanageso tuuŋ mamaga yoŋoo maŋ beŋgiaga koloowa. ");
INSERT INTO ksr_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Anutunoŋ mono gii ano gbiliuruga oŋo Aabrahambaa kotumotueya ii toroqeŋ oŋombaa. Kaaŋagadeeŋ baloŋ asaga Aabraham muro giinoŋ iikanoŋ waba kolooŋ laligojaŋi, ii buŋa qeŋ aowaga.” ");
INSERT INTO ksr_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Kaeŋ jeŋ Jeikob wasiro mesaoŋ Mesopotemia (Padan Aram) balonoŋ Labambaanoŋ kemambaajoŋ keno. Laban ii Aram eja Betuelwaa meriaga, Jeikob ano Iisoo yoroo nemuŋgara Rebekawaa naaŋaga. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Aisaknoŋ Jeikob kotuegoŋ muŋ embia mewiwaajoŋ Mesopotemia balonoŋ wasiroti, ii Iisoonoŋ moro. Kotuegoŋ muŋ kokaeŋ jeŋ kotoŋ muro: “Gii Keinan yoŋoo naamboragia yoŋoonoŋga moŋ embaga mende mewa.” ");
INSERT INTO ksr_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Kaeŋ jeŋ kotoro nemuŋmaŋa yoroo qaa jegara teŋ koma mesaoŋ Mesopotemia (Padan Aram) balonoŋ kenoti, Iisoonoŋ ii kaaŋagadeeŋ moro. ");
INSERT INTO ksr_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ii moma maŋa Aisaknoŋ Keinan emba togoŋ moma boliŋ aoŋ laligoroti, Iisoonoŋ ii iima moma kotoro. ");
INSERT INTO ksr_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ii moma kotoŋ maŋaa jaanoŋ sokombaatiwaajoŋ asia Aabrahambaa meria Ismaelnoŋ komuro iwaa mirinoŋ kema borata Malahat, Nebaiotwaa naaŋa ii mero embauruta karooŋ koloogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jeikobnoŋ Beerseba gomaŋ mesaoŋ Haran gomanoŋ kemambaajoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Kema laligoŋ baloŋ moŋnoŋ keuma weeŋ jaaya kemerotiwaajoŋ ama iikanoŋ jamo ragiti, iikanoŋa moŋ meŋ waŋ qemboŋa qeŋ gomantiiŋanoŋ gaoŋ ero. ");
INSERT INTO ksr_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Gaoŋ eŋ iikanoŋ gaoŋ kuku moŋ kokaeŋ iiro: Do mombaa kitia namonoŋ kuugi kema qaga ii Siwenoŋ uma kuuŋ nano Anutuwaa gajobauruta yoŋonoŋ iikanoŋ riiŋ uma kamaaŋ aŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Kaeŋ aŋgi Poŋnoŋ iwaa kosianoŋ nama qaa kokaeŋ ijoro: “Niinoŋ Poŋ, asaga Aabrahambaa Anutuya ano maŋga Aisakwaa Anutuya koloojeŋ. Baloŋ koi ejaŋi, niinoŋ ii gii ano goo gbiliuruga oŋoo buŋaga qeŋ oŋomaŋa. ");
INSERT INTO ksr_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Goo gbiliuruga yoŋonoŋ kolooŋ seisei aŋgi jaŋgogianoŋ namowaa sububuŋ kaaŋa koloowaa. Kaeŋ kolooro juma deema baloŋ weeŋ koukoutanoŋ ano kemekemetanoŋ, Saut ano Noot lee lee, eu ano emu iikanoŋ baageŋ sokoma kema laligowu. Goojoŋ ama goo gbiliuruga yoŋoonoŋga mombaajoŋ ama noo kotumotuenanoŋ mono namowaa kanageso tuuŋ kuuya yoŋoo qagianoŋ uro oyaŋboyaŋ mokoloowuya. ");
INSERT INTO ksr_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Moba, niinoŋ giwo laligoŋ daeŋ daeŋ kema kaŋ laligowagati, iikawaa so mono sopa somoŋgoŋ goma laligoŋ uma guambe baloŋ kokanoŋ mombo eleema kawaga. Niinoŋ gii mende gomesaoŋ qaa jeŋ somoŋgoŋ gombeti, iikawaa so ambe hoŋa koloodaborowaa.” ");
INSERT INTO ksr_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Kaeŋ ijoro Jeikobnoŋ gaoŋ uutanoŋga uuta tooro moma waama kokaeŋ jero: “Poŋnoŋ mono oŋanoŋ baloŋ koi kanoŋ laligojato, niinoŋ ii wala mende mojeŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Kaeŋ jero jeneŋa ororo qaa kokaeŋ jero: “Baloŋ koi mono kowoga ano keemomoyawo kolooja. Koi kanoŋ mono oŋanoŋ Anutuwaanoŋ duŋ raraya ano Siwewaa naguya kolooja.” ");
INSERT INTO ksr_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Kaeŋ jeŋ gomaŋ ano umugawodeeŋ waama jamo qemboŋa qeŋ eroti, ii meŋ waama jawo tooŋ osoŋ kuuŋ qaganoŋ kele apuya maama moriro. ");
INSERT INTO ksr_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Moriŋ gomaŋ iikawaa qata Betel (Anutuwaa miri) qaro. Wala taoŋ iikawaa qata ii Luz qama laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jeikobnoŋ baloŋ iikawaa qata doŋgoga Betel qama qaa kokaeŋ jeŋ somoŋgoŋ jojopaŋ qaanoŋ jeŋ kotiiro: “Oo Anutu, giinoŋ niwo laligoŋ kana koi kemaŋati, iikanoŋ nii galeŋ koma noma nembanenena ano selenaa esuya mokolooŋ nona ");
INSERT INTO ksr_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","saanoŋ luae qaganoŋ maŋnaa mirinoŋ mombo eleema kamaŋati eeŋ, niinoŋ mono goo uuaiŋga teŋ koma laligowe giinoŋ noo Poŋ Anutuna kolooŋ laligowa. ");
INSERT INTO ksr_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Jamo koi meŋ waama jawo tooŋ osoŋ kuujeŋi, iikanoŋ mono goo duŋ raraga ero iwoi kuuya togoŋ noma laligowagi, niinoŋ ii oŋanoŋ mendeembe tuuŋ 10 koloogi iikanoŋa motomotooŋ meŋ leuŋ goma laligomaŋa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jeikobnoŋ kaeŋ jeŋ mesaoŋ kana toroqeŋ kema weeŋ koukoutaa kanageso yoŋoo balonoŋ keuro. ");
INSERT INTO ksr_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Kanoŋ keuma baloŋ korianoŋ apu roŋ moŋ iiro. Miri toya yoŋonoŋ lama tuuŋgia uŋuama iikanoŋ apu oŋoma laligogi. Kambaŋ kanoŋ apu roŋ kawaa kosianoŋ lama tuuŋ karooŋ egi apu roŋ qaa ootanoŋ jamo somata ii mende metaŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Lama galeŋ yoŋonoŋ wala lama tuuŋgia kuuya iikanoŋ meŋ kululuuŋ oŋoma jamo ii apu roŋ qaa ootanoŋga gbililiŋgogi kenogo lamaurugia apu oŋoŋgi negi jamo ii mombo duŋanoŋ komakegi. ");
INSERT INTO ksr_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jeikobnoŋ lama galeŋ ii kokaeŋ qisiŋ oŋono: “Eja alauruna, oŋo dakaya?” Qisiŋ oŋono “Nono Harambaajoŋa,” kaeŋ meleema mugi. ");
INSERT INTO ksr_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Meleema mugi kokaeŋ qisiŋ oŋono: “Oŋo Naahorwaa esia Laban moma muju me qaago?” Qisiŋ oŋono “Saanoŋ moma mujoŋ,” jegi. ");
INSERT INTO ksr_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Jegi kokaeŋ qisiŋ oŋoma jero: “Ii saanoŋ laligoja me qaago?” Kaeŋ jero kokaeŋ ijogi: “Ii saanoŋ laligoja. Iiba, iwaa borata Reizelnoŋ mono endu lama uŋuama kaja.” ");
INSERT INTO ksr_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Kaeŋ ijogi Jeikobnoŋ jero: “Iibu, weeŋ somata ero lama ii gomantiiŋaajoŋ kululuuŋ oŋombombaa kambaŋanoŋ mende torija. Kawaajoŋ saanoŋ lamagia apu oŋoŋgi negi mombo uŋuama laaligogianoŋ kema oŋooŋgi nenegia newu.” ");
INSERT INTO ksr_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Kaeŋ jero kokaeŋ meleeŋgi: “Kaeŋ saanoŋ mende amboŋa. Wala lama tuuŋ kuuya kululuuŋ oŋoma jamo ii apu roŋ qaa ootanoŋga gbililiŋgoniŋ kenogo mono lamaurunana apu oŋoniŋ newuya.” ");
INSERT INTO ksr_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Jeikobnoŋ yoŋowo qaa kaeŋ amiŋ moma naŋgi iikanoŋadeeŋ Reizelnoŋ maŋaanoŋ lama tuuŋ uŋuama karo. Reizel iinoŋ lama galeŋ gawoŋ meŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Karo Jeikobnoŋ owayaa borata Reizel ano owayaanoŋ lama tuuŋ iŋiima apu roŋ qaa ootanoŋ kema jamo ii metaama owaya Labambaanoŋ lamauruta apu uŋuagiro. ");
INSERT INTO ksr_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Uŋuagidaboroŋ Jeikobnoŋ Reizel buuta kitoŋ neŋ kanaiŋ kotakota qama saaro. ");
INSERT INTO ksr_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Saama Reizelwaajoŋ jero: “Nii goo maŋgaa tinitosaya koloojeŋ. Nii Rebekawaa meriaga.” Kaeŋ jero Reizelnoŋ moma uulaŋawo bobogariŋ maŋaanoŋ kema buzu ii jero moro. ");
INSERT INTO ksr_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labanoŋ naaŋaa meria Jeikobwaa buzuya moma ii uulaŋawo mokoloomambaajoŋ keno. Kema mokolooŋ iima suuŋgoŋ aŋgomuŋ buuta kitoŋ neŋ wama mirianoŋ uri. Uma iwoi kuuya kolooroti, Jeikobnoŋ iikawaa sunduya jero moro. ");
INSERT INTO ksr_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ii moma kokaeŋ jero: “Saanoŋ, giinoŋ neenaa sakitina koloojaŋ.” Kaeŋ jero koiŋ motooŋgowaa so iwo rama laligoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Kaeŋ laligoro Labanoŋ Jeikob kokaeŋ ijoro: “Gii tinitosana laligojaŋiwaajoŋ tawaga qaa eeŋ weleŋ qeŋ nombabo. Ii mende sokombaa. Kawaajoŋ tawaga dawi mewagiwaajoŋ mojaŋi, ii saanoŋ jena momaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labambaa borawoita woi laligori. Somataa qata Lea. Kogaa qata Reizel. ");
INSERT INTO ksr_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leawaa jaayanoŋ iima-aiŋaiŋawo kolooroto, Reizel seliaa kaitania ano jaasewaŋa ii kuuya iima-aiŋaiŋawo totooŋ kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jeikobwaa uunaaŋa ii Reizelwaanoŋ erotiwaajoŋ ama qaa kokaeŋ jero: “Niinoŋ boraga kanageŋa Reizel memambaajoŋ saanoŋ yambu 7 weleŋ qeŋ goma laligomaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Kaeŋ jero kokaeŋ ijoro: “Ii eja morota moŋ mube mende sokombaboto, gii gombe sokombaa. Kawaajoŋ saanoŋ niwo koi laligowa.” ");
INSERT INTO ksr_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Kaeŋ jero Reizel memambaajoŋ yambu 7 weleŋ qeŋ muŋ laligoro. Uunaaŋanoŋ Reizelwaajoŋ erotiwaajoŋ ama yambu iikawaajoŋ moro weeŋ afaaŋa tani kolooro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Yambu 7 tegoro Jeikobnoŋ owaya Laban kokaeŋ ijoro: “Noo gawoŋ meme kambananoŋ mono tegojiwaajoŋ saanoŋ embana Reizel nona iwo eŋ laligomaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Labanoŋ qaa ii moma miri toya kuuya horoŋ kululuuŋ oŋoma lombaŋ ano neŋ korisoro aŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ii aŋgi tegoro gomaŋ tiiro Labanoŋ borata Lea wama kema Jeikob muro miri uutanoŋ uma motooŋ eri. ");
INSERT INTO ksr_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labanoŋ weleŋ embia qata Zilpa ii borata Leawaa weleŋqeqeyaga laligowaatiwaajoŋ muro. ");
INSERT INTO ksr_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Motooŋ eri gomaŋ ano Jeikobnoŋ embia iima moro Reizel qaagoto, ii Lea kolooro yooyaanoŋ kema kokaeŋ jeŋ muro: “Gii mono naa terega ama nonjaŋate? Nii Reizel memambaajoŋ weleŋ qeŋ goma laligoweto, gii mono naambaajoŋ tiligoŋ nonjaŋ?” ");
INSERT INTO ksr_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ii moma meleema kokaeŋ ijoro: “Gomaŋ kokanoŋ data eeŋ laligoro koganoŋ eja mewaatiwaa nanamemeŋa ii nonoonoŋ mende eja. ");
INSERT INTO ksr_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Kawaajoŋ saanoŋ maraŋ korisoro ii Leawo sonda motooŋgowaa so laligoŋ aisoona tegoro koga kaaŋagadeeŋ gomaŋa. Ii mewaatiwaajoŋ mono kaaŋagadeeŋ yambu 7 toroqeŋ weleŋ qeŋ noma laligowa.” ");
INSERT INTO ksr_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Kaeŋ ijoro uumotooŋgo ama Leawo maraŋ korisoro kambaŋ ii sonda motooŋgowaa so laligoro tegoro Labanoŋ borata Reizel kaaŋagadeeŋ embia koloowaatiwaajoŋ muro. ");
INSERT INTO ksr_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labanoŋ weleŋ embia qata Bilha ii borata Reizelwaa weleŋqeqeyaga laligowaatiwaajoŋ muro. ");
INSERT INTO ksr_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jeikobnoŋ Reizel ii kaaŋagadeeŋ embiaga mero. Uunaaŋanoŋ Reizelwaajoŋ erotiwaajoŋ ama Reizel ii Lea uuguŋ jopagoŋ muŋ laligoro. Kawaajoŋ yambu 7 toroqeŋ Laban weleŋa qeŋ muŋ laligoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Jeikobwaa uutanoŋ Leawaajoŋ mamaga mende ero zizi togoro Poŋnoŋ iiro mende sokono Lea koro ambaatiwaajoŋ ilaaŋ muroto, koga Reizelnoŋ aruŋa laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leanoŋ korowo kolooŋ laligoŋ mera ejaga meŋ qaa kokaeŋ jero, “Poŋnoŋ tapekokorona iiro lonanoŋ saanoŋ kanaiŋ jopagoŋ noma laligowaa.” Kaeŋ jeŋ qata iikawaa so Ruuben qaro. (Ruuben = Tapekokorona iiro.) ");
INSERT INTO ksr_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Kanageŋ mombo koro ama mera eja moŋ meŋ qaa kokaeŋ jero: “Lonanoŋ melaada jopagoŋ nono Poŋnoŋ ii moma mera koi kaaŋagadeeŋ nonja.” Kaeŋ jeŋ qata iikawaa so Simeon qaro. (Simeon = Gejianoŋ moro.) ");
INSERT INTO ksr_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Kawaa gematanoŋ mombo koro ama mera eja moŋ meŋ qaa kokaeŋ jero: “Nii merauruta karooŋ lonaajoŋ oŋonjeŋiwaajoŋ iinoŋ mono kanaiŋ uuta niwo somoŋgowaa.” Kaeŋ jeŋ qata iikawaa so Liwai qaro. (Liwai = Uuta somoŋgowaa.) ");
INSERT INTO ksr_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Kawaa gematanoŋ duŋanoŋ mombo koro ama mera eja moŋ meŋ qaa kokaeŋ jero: “Nii kambaŋ kokaamba Poŋ mepeseejeŋ.” Kawaajoŋ qata iikawaa so Juuda (mepemepesee) qaro. Kawaa gematanoŋ mera mombo mende mero. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Reizelnoŋ aruŋa laligoŋ Jeikobwaajoŋ merabora moŋ mende meŋ iyaŋaa kania kaeŋ iima data Lea gema qeŋ uutanoŋ motoqoto moma Jeikobwaajoŋ qaa kokaeŋ jero: “Gii mono mera mokoloowa. Ii mende mokoloona niinoŋ mono laligomambaajoŋ amamaaŋ komumaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Kaeŋ jero Jeikobnoŋ iriŋa soono uuduuduu moma muŋ kokaeŋ ijoro: “Nii mono mera nomaeŋ mokoloowenaga? Anutunoŋ gii mera mewagatiwaajoŋ somoŋgoŋ goma laligojanto, niinoŋ Anutuga qaago.” ");
INSERT INTO ksr_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Kaeŋ jero Reizelnoŋ kokaeŋ ijoro: “Noo weleŋ embana Bilha ii koi. Saanoŋ iwo ena noo mera moŋ mewaa. Iinoŋ nemuŋ kono niinoŋ kaaŋagadeeŋ iwaanoŋga merabora mokolooŋ oŋoma nemuŋgia kolooŋ laligomaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Kaeŋ jeŋ weleŋ embia Bilha muro embiaga meŋ iwo ero. ");
INSERT INTO ksr_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ero Bilhanoŋ koro ama Jeikobwaa meria mero. ");
INSERT INTO ksr_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Meria mero Reizelnoŋ kokaeŋ jero: “Anutunoŋ gosiŋ nono sokombe qamakooli qaana moma mera ejaga nonja.” Kawaajoŋ qata Dan qaro. (Dan = Gosiŋ nono sokonjeŋ.) ");
INSERT INTO ksr_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Reizelwaa weleŋ embia Bilhanoŋ mombo koro ama Jeikobwaa meria moŋ mero woi kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Kaeŋ mero Reizelnoŋ kokaeŋ jero: “Danawo mamaga aoŋoroŋ haamo anjeŋ.” Kaeŋ jeŋ iikawaa so mera qata Naftali (Aoŋorowe) qaro. ");
INSERT INTO ksr_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leanoŋ mombo koro mende ama ii iima kawaajoŋ iyaŋaa weleŋ embia qata Zilpa meŋ Jeikob muro embiaga kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Embiaga kolooŋ Jeikobwaa mera ejaga mero. ");
INSERT INTO ksr_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Mero Leanoŋ “Simbawoŋawo!” jeŋ qata Gad (simbawoŋawo) qaro. ");
INSERT INTO ksr_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilpa, Leawaa weleŋ embia kanoŋ Jeikobwaa meria moŋ mombo mero woi kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Kaeŋ kolooro Leanoŋ qaa kokaeŋ jero: “Niinoŋ keraqeeaŋgo somata mojeŋ. Emba yoŋonoŋ mono noojoŋ oyaŋboyaŋ qama laligowuya.” Kaeŋ jeŋ iikawaa so mera qata Aser qaro. (Aser = Oyaŋboyaŋ qabu.) ");
INSERT INTO ksr_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Wiitnoŋ masu qero kooto kambaŋanoŋ somaŋa moŋnoŋ Ruubenoŋ seleeŋgeŋ kema baloŋ korianoŋ asagbaleŋ hamo mokolooro. Hamo ii mokolooŋ meŋ kaŋ nemuŋa Lea muro. Muro Reizelnoŋ data kokaeŋ ijoro: “Goo meraganoŋ hamo meŋ kaji, iikawaa tosaaŋa mono nona nemaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Kaeŋ ijoro Leanoŋ kokaeŋ jero: “Giinoŋ lona nuana sokombaatiwaajoŋ romoŋgoweto, gii mono meranaanoŋ asagbaleŋ hamo koi ii kaaŋiadeeŋ nuamambaajoŋ mojaŋ. Ii mende sokonja.” Kaeŋ jero Reizelnoŋ kokaeŋ ijoro: “Saanoŋ! Meragaanoŋ hamo ii nombaati eeŋ, mono saanoŋ Jeikobwo gomantiiŋa koi ewao.” ");
INSERT INTO ksr_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Kaeŋ jero Jeikobnoŋ mare iikanoŋ gawoŋ mesaoŋ karo Leanoŋ kema mokolooŋ muŋ kokaeŋ ijoro: “Niinoŋ meranaanoŋ asagbaleŋ hamo kanoŋ mono goo sewaŋga mejeŋa. Kawaajoŋ mono niwo ewota.” Kaeŋ ijoro Jeikobnoŋ gomantiiŋa iikanoŋ iwo eri. ");
INSERT INTO ksr_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Iwo eri Anutunoŋ Leawaanoŋ qaa qamakoolia moro koro ama Jeikobwaa meria 5:ya mero. ");
INSERT INTO ksr_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ii meŋ qaa kokaeŋ jero: “Niinoŋ weleŋ embana ii lona muwetiwaajoŋ Anutunoŋ iikawaa tawaya koi nonja.” Kaeŋ jeŋ iikawaa so qata Aiskar (tawa) qaro. ");
INSERT INTO ksr_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Kawaa gematanoŋ Leanoŋ mombo koro ama Jeikobwaa meria 6:ya mero. ");
INSERT INTO ksr_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ii meŋ qaa kokaeŋ jero: “Anutunoŋ kaleŋ awaa soro nonja. Lona Jeikobwaa merauruta 6 mewetiwaajoŋ iinoŋ mono pondaŋ niwo laligoŋ qabuŋa noma laligowaa.” Kaeŋ jeŋ iikawaa so mera qata Zebulun qaro. (Zebulun = qabuŋa) ");
INSERT INTO ksr_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Kambaŋ tosia tegoro Leanoŋ bora meŋ qata Daina qaro. ");
INSERT INTO ksr_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Anutunoŋ mombo Reizel kaaŋagadeeŋ romoŋgoŋ muŋ qaa qamakoolia moma koro ambiwaajoŋ ilaaŋ muro. ");
INSERT INTO ksr_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ilaaŋ muro koro ama mera moŋ meŋ qaa kokaeŋ jero: “Anutunoŋ gamuna metogoja.” ");
INSERT INTO ksr_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Kaeŋ jeŋ toroqeŋ kokaeŋ jero: “Poŋnoŋ mono merana moŋ toroqeŋ nombaa.” Kaeŋ jeŋ iikawaa so mera qata Joosef (= Toroqeŋ nombaa.) qaro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Reizelnoŋ meria Joosef mero iikawaa gematanoŋ Jeikobnoŋ Laban kokaeŋ ijoro: “Nii neenaa gomaŋ mirinanoŋ kemambaajoŋ mojeŋ. Kawaajoŋ saanoŋ wasiŋ nona eleema kemaŋa. ");
INSERT INTO ksr_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Emba meraaŋuruna koi yoŋoojoŋ ama goo weleŋga qeŋ laligoweti, mono ii nona motooŋ kemboŋa. Nii gawoŋ somata totooŋ meŋ laligoweti, ii geeŋgo saanoŋ mojaŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Kaeŋ ijoro Labanoŋ kokaeŋ jero: “Gii moma qeaŋgoŋ nonjaŋi eeŋ, mono saanoŋ koi laligowa. Poŋnoŋ goojoŋ ama nii kotuegoŋ noma laligoroti, nii unju qewe qaa kaeŋ kolooro mojeŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Kaeŋ jeŋ toroqeŋ kokaeŋ jero: “Mono gawoŋgaa tawayaa jaŋgoya jena sewaŋa ii saanoŋ gomaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Kaeŋ jero Jeikobnoŋ kokaeŋ ijoro: “Nii goo weleŋ nomaeŋ qeŋ laligoŋ goo gomanoŋ miriwaa oro tuuŋa tuuŋa galeŋ koma oŋombe somariigiti, ii geeŋgo saanoŋ mojaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Wala nii koi mende kawe iikanoŋ oro iwoiga mamaga mende eŋ gonoto, iikanoŋ mono nii kawe kambaŋ kanoŋ seiŋ jaasooŋgo kolooju. Nii daeŋgeŋ daeŋgeŋ kema kaweti, iikanoŋ Poŋnoŋ kotuegoŋ gono laligona. Kaeŋ laligonato, nii mono naa kambanoŋ saanoŋ neenaa kanagesouruna naŋgoŋ oŋomambaajoŋ ama gawoŋ iwoi kanaiŋ mewenaga?” ");
INSERT INTO ksr_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Kaeŋ ijoro Labanoŋ kokaeŋ qisiro: “Nii mono naama gombenaga?” Kaeŋ qisiro Jeikobnoŋ meleema kokaeŋ jero: “Iwoi moŋ mende nombato, iwoi motooŋgo koigadeeŋ noojoŋ ambagati eeŋ, nii saanoŋ toroqeŋ goonoŋ lama tuuŋa tuuŋa ii kalaŋ koma jaagaleŋ meŋ oŋoma laligomaŋa. ");
INSERT INTO ksr_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Nii saanoŋ goonoŋ lama ano meme tuuŋga kuuya ii kete iŋiima gosimaŋa. Ii gosiŋ lama meria baroŋ kuuya ano meme (noniŋ) doŋa titogiawo ano teregia diriweŋ, soŋojinjiri me koromboŋgi ii kuuya mendeema iyaŋgia meŋ kululuuŋ oŋomba. Iyoŋonoŋ saanoŋ gawoŋ meŋ laligowetiwaa tawana koloowu. ");
INSERT INTO ksr_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Kanageŋ gawonaa tawana, lama ano meme ii iŋiima gosimambaajoŋ kawagati, kambaŋ iikanoŋ uuna dindiŋaa kania ii afaaŋgoŋ kokaeŋ mokoloowa: Meme (noniŋ) titogia qaa ano diriweŋ, soŋojinjiri me koromboŋgia qaa ii kuuya ano lama baroŋa qaago kuuya noo tuuŋanoŋ nambuti, ii niinoŋ yoŋgoro mejeŋ, kaeŋ moma kotowa.” ");
INSERT INTO ksr_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Kaeŋ jero Labanoŋ kokaeŋ meleeno: “Nii saanoŋ uumotooŋgo anjeŋ. Qaa jejaŋi iikaaŋ kana ii ewaa.” ");
INSERT INTO ksr_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Kaeŋ meleema weemboria iikanondeeŋ Labanoŋ meme (noniŋ) ejia teregia jiriŋjooroŋ ano diriweŋ soŋojinjiri me koromboŋgia ano meme embia kuuya teregia titogiawo ano diriweŋ soŋojinjiri me koromboŋgi me sele jugianoŋ iwoi taaŋa raroti, ii kuuya ano lama meria baroŋ kuuya ii gosiŋ metogoŋ oŋoma aŋaa merauruta yoŋoo borogianoŋ ama oŋoono. ");
INSERT INTO ksr_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Labanoŋ ii ama oŋooma yoŋowo Jeikobwaanoŋ lama ano meme tuuŋ ii uŋuama weemboria karooŋ kekembaa so kema kanoŋ laligogi. Koriganoŋ kaeŋ laligogi Jeikobnoŋ toroqeŋ Labambaanoŋ lama ano meme tuuŋa tuuŋa ii galeŋ koma oŋoma laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Kaeŋ laligoŋ komoŋ, wakato ano gou gere iikawaa boria gbiligbili kotoŋ meŋ selegia jinjororoŋ kombolatiro biiwianoŋ taaliro jiriŋjooroŋ kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Kaeŋ kolooro gere borogia koombolatia ii meŋ oro yoŋoo apu juugia kuuya kanoŋ ano apu newombaajoŋ kagi wosogianondeeŋ ero. Kaeŋ ero lama ano meme tuuŋ yoŋonoŋ ejianoŋ uŋualeembutiwaa aiŋ geriawo moma apu newombaajoŋ kaŋ mokolooŋ iigi. ");
INSERT INTO ksr_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Kaeŋ iima meme ejia yoŋonoŋ gere boria iikawaa kosogianoŋ embia uŋualeeŋgi. Kaeŋ uŋualeeŋgi koro ama laligogitiwaajoŋ meraboraurugia kaweŋtetere, titogiawo ano diriweŋ, soŋojinjiri me koromboŋgi ii oŋoma laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Kaeŋ laligogi Jeikobnoŋ lama ano meme (noniŋ) meria kaaŋia ii gosiŋ mendeema oŋoma aŋa aŋa tuuŋgia so oŋonoto, oro somata ii areŋgoŋ oŋono jaagia Labambaanoŋ oro baroŋ ano teregia titogiawo yoŋoonoŋ baageŋ uuŋ naŋgi. Kaeŋ ama aŋaajoŋ lama ano meme (noniŋ) tuuŋa tuuŋa metogoŋ mokolooŋ oŋono. Ii mokolooŋ somoŋgoŋ oŋono Labambaa lama tuuŋanoŋ mende kema toroqeŋ oŋoŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Oro embia kotakota yoŋonoŋ ejianoŋ uŋualeembutiwaa aiŋ geriawo mogi Jeikobnoŋ kambaŋ so iikanoŋ gere boria ii apu juunoŋ ano. Kawaajoŋ oro ejia yoŋonoŋ kaŋ ii wosogianoŋ mokolooŋ iima kosianoŋ kanoŋ embia ii uŋualeema laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Kaeŋ laligogito, oro embianoŋ esuŋgia kamaaŋqeqeta koloogiti eeŋ, iinoŋ gere boria ii iyoŋoo wosogianoŋ mende ama laligoro. Kaeŋ ama laligoro oro esuŋgia kamakamaata yoŋonoŋ Labambaa tuuŋanoŋ toroqegi esuŋgia kotakota yoŋonoŋ Jeikobwaa tuuŋanoŋ kema toroqegi. ");
INSERT INTO ksr_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Jeikobnoŋ kaeŋ ama kindiŋbiri eja qaqabuŋayawo kolooŋ toomoriaŋ mokolooro. Lama ano meme tuuŋ mamaga buŋa qeŋ aoŋ weleŋqeqe ejemba uŋuano kamel ano doŋgi tuuŋa tuuŋa asugiŋ seigi togia kolooro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Labambaa meraurutanoŋ qaa kokaeŋ jegi Jeikobwaa gejianoŋ kemero moro: “Maŋnananoŋ iwoi buŋa qeŋ laligoroti, Jeikobnoŋ ii kuuya kalugoŋ konjoratiŋ aŋgoŋ kono. Maŋnanaa esuhinaya galeŋ koma iikawanoŋa hinaya kuuya ii iyaŋaajoŋ mokolooŋ kindiŋbiri kolooja.” ");
INSERT INTO ksr_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Qaa ii moro ano looyaa jaasewaŋa iima kokaeŋ moma asariro: “Labanoŋ wala ala awaa kolooŋ noma laligoŋ kouroto, kaaŋa mende toroqeŋ ama laligoja.” ");
INSERT INTO ksr_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Kaeŋ moma asariro Poŋnoŋ Jeikob kokaeŋ ijoro: “Gii mono eleema maŋasauruga yoŋoo balonoŋ kema tinitosauruga yoŋowo laligowa. Kema laligona niinoŋ giwo nama laligomaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jeikobnoŋ qaa ii moma Reizel ano Lea yoroojoŋ qaa ano keno baloŋ korianoŋ lama tuuŋa tuuŋa galeŋ koma oŋonoti, iikanoŋ kari. ");
INSERT INTO ksr_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Kari kokaeŋ irijoro: “Niinoŋ maŋgaraa jaasewaŋa iima kokaeŋ moma asarijeŋ: Iinoŋ wala ala awaa ama noma laligoŋ kouroto, iikaaŋa mombo mende ama laligoja. Maŋnaa Anutuyanoŋ mono kileŋ niwo nama laligoŋ kouro. ");
INSERT INTO ksr_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Nii ku-usuna kuuya kululuuŋ iikawaa so maŋgara weleŋ qeŋ muŋ laligoŋ koubeti, oro ii saanoŋ mojao. ");
INSERT INTO ksr_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","“Kaeŋ laligoweto, iinoŋ aŋgomokoloŋ qaganoŋ ama noma laligoŋ gawonaa tawaya ii somaŋa 10:baa so utequte ama laligoro. Kaeŋ ama noma laligoroto, Poŋnoŋ aŋgoŋ koma muro tiwitiwilaa moŋ mende ama nono laligowe. ");
INSERT INTO ksr_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Kambaŋ moŋnoŋ kokaeŋ jero, ‘Lama ano meme (noniŋ) titogiawo koloowuti, ii mono goo gawoŋ tawaga koloowu.’ Kaeŋ jero oro tuuŋ kuuya yoŋonoŋ meraboraaŋgia titogiawo oŋoŋgi. Kambaŋ moŋnoŋ kokaeŋ jero, ‘Lama ano meme (noniŋ) kaweŋtetere koloowuti, ii mono goo gawoŋ tawaga koloowu.’ Kaeŋ jero oro tuuŋ kuuya yoŋonoŋ meraboraaŋgia kaweŋtetere oŋoŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Anutunoŋ kaeŋ ano asugiro maŋgaraa tuuŋanoŋga oro konjoratiŋ uŋuama nono seigi. ");
INSERT INTO ksr_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Oro ejianoŋ embia uŋualeema laligogiti, kambaŋ iikanoŋ gaoŋ iima jaana uuŋ waama iibe meme (noniŋ) ejianoŋ embia uŋualeema naŋgiti, iyoŋoo selegia ii kaweŋtetere, titogiawo ano diriweŋ, soŋojinjiri me koromboŋgi kuuya koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Nii gaoŋ iibe kanoŋ Anutuwaa gajoba moŋnoŋ noojoŋ ‘Jeikob!’ qaro. Kaeŋ qaro ‘Koi nanjeŋ,’ jeŋ meleembe. ");
INSERT INTO ksr_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Meleembe kokaeŋ toroqeŋ nijoro: ‘Labanoŋ iwoi kuuya ama gomakeji, niinoŋ ii iima mojeŋ. Kawaajoŋ saanoŋ jaaga otaama uuŋ iiba: Meme (noniŋ) ejia kuuya embia uŋualeema nanjuti, iyoŋoo selegianoŋ kaweŋtetere, titogiawo ano diriweŋ, soŋojinjiri me koromboŋgi kolooja. ");
INSERT INTO ksr_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Niinoŋ Betel kanoŋ asugiŋ gombe jamo daŋgunu moŋ kuuŋ kele moriŋ niwo qaa somoŋgoŋ jojopaŋ qaanoŋ jeŋ kotiina. Niinoŋ Anutu ii ano goojoŋ qaa kokaeŋ jejeŋ: Gii mono keteda koi waama kantri koi mesaoŋ geeŋgaa kolokoloo gomaŋganoŋ mombo eleema kemba.’” ");
INSERT INTO ksr_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Jeikobnoŋ qaaya kaeŋ jero Reizel ano Lea yoronoŋ kokaeŋ meleema muŋ ijori: “Maŋnaraa mirinoŋ borosamowaa bakaya moŋ ii noroonoŋ mende toroqeŋ raja. ");
INSERT INTO ksr_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Iinoŋ eja norono sewanaranoŋ karo ii aŋaajoŋgadeeŋ meŋ gilidabororo. Kawaajoŋ noro mono waba tani ama norono laligoŋ kouri. ");
INSERT INTO ksr_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Kawaajoŋ Anutunoŋ maŋnaraa tuuŋanoŋa esuhina ilawoila konjoratiŋ wano seiroti, ii kuuya mono oŋanoŋ anana ano meraboraurunana ananaa buŋaga kolooja. Kawaajoŋ Anutunoŋ jeŋ kotoŋ gonoti, giinoŋ mono ii kuuya teŋ koma otaawa.” ");
INSERT INTO ksr_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Kaeŋ ijori waama meŋ mozozoŋgoŋ meŋ embamerauruta kobibiiŋ oŋono kamel qagianoŋ ugi. ");
INSERT INTO ksr_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Miriwaa oro tuuŋa kuuya konjoma oŋono wala keŋgi. Esuhina iwoiya kuuya Mesopotemia (Padan Aram) balonoŋ laligoŋ mokolooro seiroti, ii korebore kololooŋ maŋa Aisakwaanoŋ kembombaajoŋ Keinan balonoŋ baageŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Kambaŋ kanoŋ Labanoŋ lama jugia motomambaajoŋ keno Reizelnoŋ maŋaa mirinoŋ doŋlopioŋ bubuga yoŋgoro mero. ");
INSERT INTO ksr_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yoŋgoro mero Jeikobnoŋ toroqeŋ looya Aram eja Laban ii kokaeŋ tiligoŋ muro: Kembombaa qaaya ii mende jero moroto, mono oloŋ mesaoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Kaeŋ oloŋ keŋgi kamel yoŋonoŋ ilawoilaya kuuya meŋ bosiŋgi. Kema Yufreitis apu gowoya kotoŋ Gilead baloŋ baaŋawo iikanoŋ baageŋ keŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Keŋgito, weemboria karooŋa kolooro kanoŋ qaa kokaeŋ jegi Labanoŋ moro, “Jeikobnoŋ mono togoŋ oloŋ koma keno.” ");
INSERT INTO ksr_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ii moma waama tinitosa ejauruta uŋuama weemboria 7:baa so oŋotaaŋ kema kema Gilead baloŋ baaŋawo kanoŋ mokolooŋ oŋoŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Oŋoŋgiti, gomantiiŋa iikanoŋa Anutunoŋ Aram eja Laban ii gaonoŋ asugiŋ qaa kokaeŋ ijoro: “Gii Jeikobwaajoŋ kotumotue me qasumasuaa qaa moŋ jewabotiwaajoŋ mono moma kotoŋ galeŋ meŋ aowa.” ");
INSERT INTO ksr_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Uŋuaŋgi Jeikobnoŋ opo sel kuuŋa Gilead baloŋ baaŋawonoŋ mororoŋgoŋ kuuro Laban ano ejauruta yoŋonoŋ kaaŋagadeeŋ opo sel kuuŋgia iikanoŋ kuuŋ egi. ");
INSERT INTO ksr_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Eŋ waama qegia Jeikobwaanoŋ kema kokaeŋ jero moro: “Gii mono naa terega ama nona? Gii tiligoŋ nonjaŋ. Kere yoŋonoŋ manja qeŋ emba yoŋgoro horoŋkejuti, mono iikawaa tani noo borawoina oloŋ uruama koi kana. ");
INSERT INTO ksr_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Gii naambaajoŋ aŋgomokoloŋ ama noma uulaŋawo oloŋ koma nomesaoŋ kana? Gii mono naambaajoŋ qaa moŋ mende jena mobe laŋ kana? Ii mobenagati eeŋ, nii saanoŋ rii gbawe ambe komaŋ koma gita kulele qegi korisoro qaganoŋ oŋoombe kawuyaga. ");
INSERT INTO ksr_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","“Ii mobenagati eeŋ, mono saanoŋ esauruna ano borawoina buugia kitoŋ neŋ yeizozogia jewenaga. Gii mono uuga qaawaa tere kaaŋa anjaŋa. ");
INSERT INTO ksr_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Niinoŋ ku-usunawo kaŋ saanoŋ tiwilaaŋ gombenagato, gomantiiŋa ewe maŋgaa Anutuyanoŋ qaa kokaeŋ nijojaa: ‘Gii Jeikobwaajoŋ kotumotue me qasumasuaa qaa moŋ jewabotiwaajoŋ mono moma kotoŋ galeŋ meŋ aowa.’ ");
INSERT INTO ksr_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Kawaajoŋ mesaowa, geeŋgaa maŋgaa gomaŋ mirinoŋ eleemambaa uuaiŋga somata moma laligoŋgo mesaodaboroŋ kananoŋ kaŋ laligojaŋ. Kawaajoŋ saanoŋ kembato, noonoŋ doŋlopioŋuruna ii mono naambaajoŋ yoŋgoro meŋ kana?” ");
INSERT INTO ksr_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Labanoŋ kaeŋ ijoro Jeikobnoŋ kokaeŋ meleema muro: “Giinoŋ borawoiga manjaqeqe ku-usuŋ qaganoŋ nuambabotiwaajoŋ romoŋgoŋ keena moma oloŋ koma kaniŋ. ");
INSERT INTO ksr_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Kaninto, moŋnoŋ doŋlopioŋ bubuga mero mokoloowagi, ii saanoŋ qena komuwaa. Ilawoila kuuya meŋ laligojeŋi, ii saanoŋ tinitosaurunara yoŋoo jaanoŋ iima gosiŋ nama goonoŋ iwoiga moŋ mokolooŋ iima ii saanoŋ mewa.” Jeikobnoŋ kaeŋ ijoroto, embia Reizelnoŋ doŋlopioŋ ii yoŋgoro meroti, loyanoŋ ii mende morotiwaajoŋ ii haŋqaŋ qeŋ jero. ");
INSERT INTO ksr_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Kaeŋ jero qegia Jeikobwaa opo sel kuuŋanoŋ uma qeŋgama moŋgama Leawaa opo sel kuuŋanoŋ uma toroqeŋ weleŋ embawoi yoroo opo sel kuuŋgaranoŋ uma qeŋgama moŋgama iwoi moŋ mende mokolooro. Leawaanoŋ kuuŋ mesaoŋ kawaa gematanoŋ Reizelwaa kuuŋanoŋ uro. ");
INSERT INTO ksr_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Uroto, Reizelnoŋ doŋlopioŋ bubuga ii meŋ gesonoŋ mouma kamel qaganoŋ duŋ rarawaa uutanoŋ ama qaganoŋ uma qelanjiŋ raro. Kaeŋ raro maŋanoŋ opo kuuŋaa uuta kuuya qeŋganoto, ii mende mokolooro. ");
INSERT INTO ksr_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Reizelnoŋ maŋa kokaeŋ ijoro: “Somatana, nii koinoŋ niiro rajeŋiwaajoŋ ama goo jaasewaŋganoŋ saanoŋ mende waamaŋa. Kawaajoŋ uuduuduu mende moma nomba.” Kaeŋ ijoro miriwaa doŋlopioŋ bubuga iikawaajoŋ moŋganoto, ii mende mokolooro. ");
INSERT INTO ksr_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Mende mokolooro nama Jeikobnoŋ iriŋa soono temboma Laban kokaeŋ jeŋ qisiŋ muro: “Niinoŋ naa kanaga ama soŋgiwe? Mono naa sili bologa ama gombetiwaajoŋ kakasililinoŋ tiwowasanoŋ tigoŋ nonjaŋ? ");
INSERT INTO ksr_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Noo esuhinana kuuya qeŋgan daboroŋgo mono naa iwoiga moŋ mokoloona goo miri uutaa buŋaga koloonaga? Ii saanoŋ meŋ koi kaŋ tinitosaurunara yoŋoo jaagianoŋ ana iigi batunaranoŋ qaa lombo enagati, ii gosiŋ jeŋ tegoŋ mindiŋgoŋ norombuya. ");
INSERT INTO ksr_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Niinoŋ giwo yambu 20 laligoŋ waabe. Kambaŋ iikawaa uutanoŋ gawoŋga mewe goonoŋ lama ano meme (noniŋ) yoŋonoŋ mende jaŋgoŋ qaoŋgito, awaagadeeŋ kolooŋ seisei ama laligogi. Kaaŋagadeeŋ lama ejia moŋ goo oro tuuŋnoŋa mende qeŋ newe. ");
INSERT INTO ksr_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Kambaŋ tosaaŋanoŋ oro kawalianoŋ lama qeŋ kitomitooroti, ii mende meŋ kaŋ goma laligoweto, iikawaa kitia ii neenaa tuuŋnoŋga meŋ kitianoŋ ama laligowe. Lamaga gomantiiŋanoŋ me asasaganoŋ yoŋgoro meŋ laligowuyagati, kileŋ iikawaa kitia amambaajoŋ jeŋkooto ana ii otaaŋ laligowe. ");
INSERT INTO ksr_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","“Weeŋ biiwianoŋ gomaŋ gerianoŋ nooro gomantiiŋanoŋ memetotoŋanoŋ nuro saŋgoŋa moma laligowe. Kambaŋ mamaga gaoŋ gbiligbili laligowe. ");
INSERT INTO ksr_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Yambu 20:waa so iikaaŋ goo gomanoŋ laligoŋ waabe tegoja. Yambu 14 ii borawoiga oromambaajoŋ weleŋ qeŋ goma laligowe. Iikawaa gematanoŋ yambu 6 ii lama bulmakao mokoloomambaajoŋ goonoŋ gawoŋ meŋ laligowe. Kaeŋ laligoweto, giinoŋ gawoŋ memewaa tawana ii somaŋa 10:baa so utequte ama laligona. ");
INSERT INTO ksr_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","“Asana Aabrahambaa Anutuya amana Aisaknoŋ waeya meŋ mepeseeŋkeji, iinoŋ gemananoŋ aworo kolooŋ mende kotiŋgoŋ nonagi eeŋ, giinoŋ mono bobora wasiŋ nona kawenaga. Kaeŋ ama nonagato, Anutunoŋ noonoŋ siimbobolo kakasililiŋ iiro gawoŋ boronanoŋ seleqeqe ama meŋ laligoweti, ii iima kete gomantiiŋanoŋ noo qaana gosiŋ jeŋ tegoro mojaŋ.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Jeikobnoŋ kaeŋ jero Labanoŋ kokaeŋ meleema muro: “Emba woi koi mono noo borawoinaga. Yoroo meraboraurugara ii noonoŋa. Lama bulmakao tuuŋa tuuŋa koi ii noonoŋa. Iwoi kuuya koi iijaŋi, ii kuuya noo buŋagadeeŋ kolooja. Kaento, mesaowa niinoŋ kete borawoina koi ano meraboraurugara oŋoniti, yoŋonoŋ kembutiwaa qaagia jegi ii qewagomambaajoŋ moma bimoojeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Kawaajoŋ saanoŋ kaŋ gou koma aoŋ batunaranoŋ soomoŋgo ambo. Ii qendeembotiwaajoŋ romoŋgoŋ noroma daŋgunu kaaŋa batunaranoŋ ewaa.” ");
INSERT INTO ksr_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Kaeŋ jero Jeikobnoŋ jamo moŋ meŋ kuuro moroalimbaŋ daŋgunu kaaŋa sodogara kolooŋ nano. ");
INSERT INTO ksr_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Iikanoŋ nano Jeikobnoŋ tinitosauruta yoŋoojoŋ jamo meŋ kululuuwutiwaajoŋ jero. Kaeŋ jero jamo meŋ qanoŋ qanoŋ ama kululuugi uro iikawaa kosianoŋ nene lombaŋ ooŋ negi. ");
INSERT INTO ksr_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labanoŋ jamo tuuŋ kawaa qata Jegar Sahaduta qaro Jeikobnoŋ qata Galed qaro. ");
INSERT INTO ksr_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Kaeŋ qama looyanoŋ qegia Jeikob kokaeŋ ijoro: “Jamo tuuŋ koi mono kete anaraa batunaranoŋ moroalimbaŋ daŋgununaraga ewaa.” Kawaajoŋ Jeikobnoŋ iikawaa qata Galed qaro. ");
INSERT INTO ksr_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Labanoŋ qaa toroqeŋ kokaeŋ jero: “Poŋnoŋ deema laligowoti, kambaŋ iikanoŋ batunaranoŋ jaayanoŋ niriima riiŋ galeŋ meŋ noroma laligowaa.” Kawaa so baloŋ iikawaa qata moŋ Mizpa qaro. (Mizpa = Galeŋ meme miri koriga.) ");
INSERT INTO ksr_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Labanoŋ qaa ii toroqeŋ kokaeŋ ijoro: “Giinoŋ borawoina horoŋ ureeŋ aoŋ ama oromba me toroqeŋ emba tosaaŋa oŋombagati eeŋ, mono qaa koi moma laligowa: Baloŋ eja moŋnoŋ kosonaranoŋ mende laligoŋ niriiro Anutunoŋ mono kileŋ saanoŋ niriima batunaranoŋ soomoŋgo ejiwaa qaaya ii naŋgoŋ jeŋ laligowaa.” ");
INSERT INTO ksr_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Kaeŋ ijoŋ mombo toroqeŋ kokaeŋ jero: “Qegana moba, jamo tuuŋ koi ano tooŋ koi kuujeŋi, iikanoŋ mono anaraa batunaranoŋ daŋgunu kaaŋa rama ubao. ");
INSERT INTO ksr_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Jamo tuuŋ koi mono daŋgununara kolooŋ rama ubaa ano tooŋ koi ii kaaŋagadeeŋ daŋgununara kolooŋ rama ubaa. Iikanoŋ soomoŋgonaraajoŋ kokaeŋ romoŋgoŋ noroma rama ubao: Niinoŋ meŋ boliŋ gomambaajoŋ moma jamo tuuŋ koi mende uuguŋ goonoŋ kamaŋa. Giinoŋ kaaŋiadeeŋ meŋ boliŋ nomambaajoŋ moma jamo tuuŋ ano tooŋ koi mende uruuguŋ noonoŋ kawa. ");
INSERT INTO ksr_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Aabraham, Naahor ano yoroo maŋgaraa beŋgia Anutu iinoŋ mono qaa batunaranoŋ kolooro ii gosiŋ jeŋ tegoŋ norombaa.” Labanoŋ kaeŋ ijoro Jeikobnoŋ qaa ii somoŋgoŋ Anutuwaa qanoŋ jojopaŋ qaanoŋ jeŋ kotiiro. Maŋa Aisaknoŋ Anutu iikawaa waeya meŋ mepeseeŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Jeikobnoŋ kaeŋ ama baloŋ baaŋanoŋ oro qeŋ iikanoŋ siimoloŋ ooŋ tinitosauruta horoŋ oŋono lombanoŋ kagi. Kaŋ nene neŋ gomantiiŋanoŋ rii oroŋ baaŋanoŋ kanoŋ egi. ");
INSERT INTO ksr_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Egi gomaŋ asariro Labanoŋ umugawodeeŋ waama esauruta ano borawoita buugia kitoŋ neŋ kotuegoŋ oŋoma yeizozogia jero. Ii jeŋ oŋomesaoŋ eleema gomaŋanoŋ keno. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Looyanoŋ keno Jeikobnoŋ kaaŋagadeeŋ kananoŋ keno Anutuwaa gajobauruta tosianoŋ mokolooŋ mugi. ");
INSERT INTO ksr_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Mokolooŋ mugi iŋiima kokaeŋ jero: “Ii Anutuwaanoŋ manjaqeqe tuuŋ kolooju.” Kawaa so gomaŋ iikawaa qata Mahanaim (manjaqeqe tuuŋ woi) qaro. ");
INSERT INTO ksr_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jeikobnoŋ kananoŋ kema laligoŋ qele ejauruta tosaaŋa wala wasiŋ oŋono Edom kantrinoŋ baloŋ qata Seir kanoŋ data Iisoo iibombaajoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Wasiŋ oŋoma kokaeŋ jeŋ kotoŋ oŋono: “Oŋo mono kema da poŋna Iisoo kokaeŋ jegi moba: ‘Somatana moba, nii weleŋ ejaga Jeikob. Nii owanara Labambo laligoŋ kouma laligodaboroŋ kambaŋ kokaamba ii mesaoŋ kajeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Iikanoŋ laligoŋ bulmakao, doŋgi, lama, meme (noniŋ) tuuŋa tuuŋa ano weleŋqeqe ejemba mokolooŋ uŋuama kananoŋ kajeŋ. Oo eja poŋna, niinoŋ goo jaanoŋ kiaŋkoomu mokoloomambaajoŋ moma qaa buzuna koi wala ambe goonoŋ kaja.’” ");
INSERT INTO ksr_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Kaeŋ jeŋ kotoŋ oŋono kema eleema kaŋ kokaeŋ jegi moro: “Nono daga Iisoowaanoŋ keniŋ. Iinoŋ mono ejauruta 400 uŋuama kananoŋ kaŋ giwo aitoŋgowombaajoŋ jojoriŋ laligoju.” ");
INSERT INTO ksr_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Kaeŋ jegi moma awawaliŋ konjiliŋ somata moro. Kaeŋ moma nama kanagesouruta iwo kagiti, ii ano lama meme tuuŋa tuuŋa, bulmakao tuuŋa tuuŋa ano kameluruta ii mendeema oŋono tuuŋ woi koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Kokaeŋ romoŋgoŋ kaeŋ ano: “Iisoonoŋ kaŋ manja qeŋ tuuŋ moŋ uŋuŋ tiwilaawaati eeŋ, tuuŋ moŋ yoŋonoŋ mono saanoŋ oloŋ koma kembuyaga.” ");
INSERT INTO ksr_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Kaeŋ romoŋgoŋ kokaeŋ jeŋ qama kooliro: “Oo Anutu, asana Aabraham ano maŋna Aisak yoroo beŋgara, gii saanoŋ moma nomba. Poŋ, gii geeŋgo qaa kokaeŋ nijona mobe: ‘Gii mono waama geeŋgaa balonoŋ eleema geeŋgaa tinitosauruga yoŋoonoŋ kemba. Endu kena niinoŋ toomoriaŋ gombe laligowa.’ Kaeŋ nijona mobe. ");
INSERT INTO ksr_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Wala eeŋanoŋ neenaa taa gbarunanondeeŋ meŋ Jordan apu gowoya koi kotoŋ kembeto, saanoŋ kolooŋ seiŋ kete eleema tuuŋ woi kolooŋ koi kajeŋ. Nii weleŋ ejaga kamaaŋqeqeta kolooŋ laligoweto, giinoŋ kileŋ qaaga pondaŋ otaaŋ kiaŋkoomuga kuuya qendeema noma laligona. Nii kamakamaata kolooŋ uujopaga ii buŋa qeŋ aomambaa so mende kolooŋ laligowe. ");
INSERT INTO ksr_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","“Dana Iisoonoŋ kananoŋ kaŋ neena, nemuŋ ano meraboraurunana nono nunuŋ tiwilaaŋ nonombabotiwaajoŋ nii keena mojeŋ. Kawaajoŋ giinoŋ mono ilaaŋ nonoma iwaa borianoŋga metogoŋ nonomba. ");
INSERT INTO ksr_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Gii geeŋgo qaa kokaeŋ nijona: ‘Niinoŋ toomoriaŋ goma gbiliuruga kolooŋseisei oŋombe jaŋgogianoŋ somariiro kowewaa sakasiŋa ejiwaa so koloowu. Ii kelemaleleŋ ewaatiwaajoŋ ama weeŋweeŋgoyaa so qaago. Qaa ii oŋanoŋ.’” ");
INSERT INTO ksr_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Kaeŋ qama kooliŋ gomantiiŋa ii baloŋ iikanoŋ ero. Eŋgo oro tuuŋa tuuŋa yoŋoonoŋga data Iisoo kaleŋ mumambaajoŋ oro kokaeŋ gosiŋ mendeema oŋoma aŋatitiga oŋoono: ");
INSERT INTO ksr_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Meme (noniŋ) embia 200, ejia 20, lama embia 200, ejia 20, ");
INSERT INTO ksr_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","kamel 30 meraboraurugia ajunoŋ, bulmakao embia 40, ejia 10, doŋgi embia 20, ejia 10. ");
INSERT INTO ksr_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Tuuŋ kaeŋ kaeŋ gosiŋ mendeema tuuŋ aŋa aŋa ii weleŋqeqeuruta yoŋoo borogianoŋ ama oŋoma kokaeŋ iŋijoro: “Oŋo saanoŋ wala kema oro tuuŋa tuuŋa koi yoŋoo batugianoŋ tiriŋ kotoŋ uŋuama awaŋaoŋ kembu.” ");
INSERT INTO ksr_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Kaeŋ iŋijoŋ tuuŋ mutuya kembutiwaa galeŋa kokaeŋ jeŋ kotoŋ muro: “Kananoŋ keŋgi dana Iisoonoŋ mokolooŋ oŋoma kokaeŋ qisiŋ gombaa: ‘Gii morowaa weleŋqeqe ejaga koloojaŋ? Gii dakanoŋ kemaŋ jeŋ kajaŋ? Oro baganoŋ kajuti, ii morowaanoŋa?’ ");
INSERT INTO ksr_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Kaeŋ qisiŋ gono kokaeŋ jewa: ‘Ii weleŋ ejaga Jeikobwaanoŋga. Ii somataya Iisoo kaleŋ mumambaajoŋ ano kaju. Aŋo mono gemanananoŋ kananoŋ kaja.’” ");
INSERT INTO ksr_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Kaeŋ jeŋ kotoŋ muŋ oro tuuŋ 2:ya, tuuŋ 3:ŋa ano oro tuuŋ tosia kuuya yoŋoo galeŋgia gemagianoŋ kagiti, ii kaaŋagadeeŋ jeŋ kotoŋ oŋono mogi: “Oŋo dana Iisoo mokoloowuti, mono qaa tania iikayadeeŋ jegi mobaa.” ");
INSERT INTO ksr_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kaeŋ jeŋ kotoŋ oŋoma kokaeŋ romoŋgoro: “Niinoŋ batogoŋ uuta meŋ kamaaŋ ala kaleŋ mumambaajoŋ oro tuuŋa tuuŋa wasiŋ oŋombe wala kembu. Dananoŋ ii iŋiima uuta bonjoŋ kono olomoonaga. Uuta olomooro saanoŋ neeno iwaa jaasewaŋanoŋ osoŋ keube siŋgisoŋgona mesaoŋ ala meŋ nonaga.” Kaeŋ romoŋgoŋ toroqeŋ kokaeŋ jegi mobaatiwaajoŋ jero: “Goo weleŋ ejaga Jeikobnoŋ mono gemanananoŋ sosooda kaja.” ");
INSERT INTO ksr_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Kaeŋ jeŋ kaleŋa oŋono wala kananoŋ keŋgito, aŋo gomantiiŋa ii opo kuuŋnoŋ ramaŋa jeŋ iikanoŋ raro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Gomantiiŋa kanoŋ Jeikobnoŋ waama embawoita, weleŋ embawoita ano merauruta 11 ii uŋuano kema Jabok apu sakasiŋa qeleqeleeya ii kotowombaajoŋ aŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Uŋuano apu kotoŋ kema esuhina iwoiya kuuya buŋaya eroti, ii kaaŋagadeeŋ meŋ kendaborogi. ");
INSERT INTO ksr_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Kendaborogito, Jeikobnoŋ aŋodeeŋ apu leegeŋ kanoŋ mombo raro. Aŋodeeŋ raro eja moŋnoŋ karo iwo gomantiiŋanoŋ aoŋ oroŋ nani gomaŋ ano. ");
INSERT INTO ksr_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Eja iikanoŋ haamo ama mumambaajoŋ amamaaŋ iima kawaajoŋ Jeikob ii kupu siitanoŋ qero. Qero motooŋ aoŋ oroŋ laligori iikanoŋ Jeikobwaa kupu siitanoŋ suno. ");
INSERT INTO ksr_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Siitanoŋ suno eja iikanoŋ kokaeŋ ijoro: “Gomaŋ amambaajoŋ anjiwaajoŋ mono saanoŋ nomesaona kemaŋa.” Kaeŋ ijoroto, Jeikobnoŋ kokaeŋ meleema muro: “Nii mende kotuegoŋ nombagi eeŋ, nii mono mende gomesaowe kembaga.” ");
INSERT INTO ksr_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Kaeŋ meleema muro “Gii qaga moro?” jeŋ qisiŋ muro “Jeikob,” jero. ");
INSERT INTO ksr_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Kaeŋ jero qaa kokaeŋ ijoro: “Gii Anutu ano ejemba nonowo aoŋ oroŋ laligoŋ haamo ama nonona. Kawaajoŋ goo qaga mono toroqeŋ Jeikob qaagoto, Israel qabu.” (Israel = Anutuwo aoŋororo.) ");
INSERT INTO ksr_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Kaeŋ ijoro kokaeŋ jero: “Gii saanoŋ qaga qana momaŋa.” Kaeŋ jeroto, gajobanoŋ kokaeŋ meleema muro: “Gii nomaembaajoŋ noo qanaajoŋ qisijaŋ?” Kaeŋ meleema muŋ iikanoŋ nama kotuegoŋ muro. ");
INSERT INTO ksr_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Kotuegoŋ muro Jeikobnoŋ kokaeŋ jero: “Nii Anutuwo jaasewaŋ qeŋ aoŋ jaaya tororo iijento, kileŋ niima kobooro jaawo laligojeŋ.” Kaeŋ jeŋ kawaajoŋ baloŋ iikawaa qata Penuel qaro. (Penuel = Anutuwaa jaasewaŋa) ");
INSERT INTO ksr_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Weeŋ jaayanoŋ kouro Jeikobnoŋ Penuel gomaŋ ii mesaoŋ uuguŋ kaŋ kupu siita sunotiwaajoŋ ama riiŋ koriŋkoriŋ keno. ");
INSERT INTO ksr_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Eja kanoŋ Jeikobwaa kupu sii toroqeqetaa tokotokoyanoŋ qerotiwaajoŋ ama Israel kanatuuru yoŋonoŋ kambaŋ kokaamba kaaŋagadeeŋ oro neŋ kanoŋ kupu sii toroqeqetaa tokotokoya ii togoŋ mende neŋkeju. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jeikobnoŋ jaaya uuŋ waama Iisoonoŋ ejauruta 400 yoŋowo motooŋ kananoŋ kagiti, ii iŋiiro. Kawaajoŋ meraborauruta mendeema oŋoma Lea, Reizel ano weleŋ embawoita yoŋoo borogianoŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Kaeŋ ama oŋoma kokaeŋ areŋgoŋ oŋono: Weleŋ embawoita yoronoŋ meraboraurugara uŋuama wala keŋgi. Yoŋoo gemagianoŋ Leanoŋ meraborauruta yoŋowo keŋgi Reizel ano meria Joosef yoronoŋ daandaaŋ keni. ");
INSERT INTO ksr_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Sumaŋa kaeŋ areŋgoŋ oŋoma aŋo yoŋoo wosogianoŋ wala kema simiŋ kuma namonoŋ usugoŋ waaro indiŋa 7 kolooro kema dataa jaasewaŋanoŋ keuro. ");
INSERT INTO ksr_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Keuroto, Iisoonoŋ koga iimambaajoŋ uulaŋawo bobogariŋ kaŋ suuŋgoŋ muŋ borianoŋ aroyanoŋ giliro kemero buuta kitoŋ nero urusaaŋ aori. ");
INSERT INTO ksr_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Iisoonoŋ jaaya uuŋ waama Jeikobwaa embamerauruta iŋiima koga qisiŋ muro: “Koi daeŋ yoŋonoŋ giwo kaju?” Qisiŋ muro kokaeŋ meleeno: “Anutunoŋ kaleŋ moriaŋa qaganoŋ merabora koi weleŋ ejaga nii nonota kajoŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Kaeŋ meleeno weleŋ embawoita yoronoŋ meraboraurugara yoŋowo kosere kouma simiŋ kuma namonoŋ usugogi. ");
INSERT INTO ksr_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Kawaa gematanoŋ Lea ano meraborauruta yoŋonoŋ kaaŋiadeeŋ kosere kouma simiŋ kuma namonoŋ usugogi. Tetegoyanoŋ Joosef ano Reizel yoronoŋ kosere kouma simiŋ kuma namonoŋ usugori. ");
INSERT INTO ksr_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Kaeŋ aŋgi Iisoonoŋ kokaeŋ qisiŋ muro: “Eja ano oro tuuŋ kuuya kananoŋ mokolooŋ oŋonjeŋi, ii kania naata wasiŋ oŋona kajuya?” Kaeŋ qisiŋ muro kokaeŋ ijoro: “Oo eja poŋna, niinoŋ ii goo jaaganoŋ kiaŋkoomu mokoloomambaajoŋ ama wasiŋ oŋombe.” ");
INSERT INTO ksr_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Kaeŋ jeroto, Iisoonoŋ qaa kokaeŋ ijoro: “Oo kona, ii noonoŋ mamaga sonanoŋ raju. Kawaajoŋ ii saanoŋ toroqeŋ geeŋgaa buŋa kolooŋ ewaa.” ");
INSERT INTO ksr_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Kaeŋ ijoro Jeikobnoŋ kokaeŋ jero: “Kaeŋ qaago. Giinoŋ niimanaaŋ ama ala awaa meŋ nona goo jaasewaŋga iibe Anutuwaa jaasewaŋa kaaŋa kolooja. Kawaajoŋ nii goo jaaganoŋ kiaŋkoomu mokoloojeŋi eeŋ, mono kalena koi saanoŋ buŋa qeŋ aowa. ");
INSERT INTO ksr_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Anutunoŋ kaleŋ moriaŋ qendeema nono laligoŋ koube iwoi kuuya amamaaŋkejeŋi, ii kuuya saanoŋ eŋ nonja. Kawaajoŋ keraqeeaŋgo kalena meŋ kagiti, ii saanoŋ mewa.” Kaeŋ ijoŋ kaparaŋ koma nanotiwaajoŋ Iisoonoŋ keraqeeaŋgo kaleŋa ii buŋa qeŋ aoro. ");
INSERT INTO ksr_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Buŋa qeŋ aoŋ kokaeŋ jero: “Mono saanoŋ toroqeŋ kemboŋa. Niinoŋ koipugia koloowe oŋo saanoŋ niwo kagi kemboŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Kaeŋ jeroto, Jeikobnoŋ kokaeŋ ijoro: “Eja poŋna, moba. Meraborauruna yoŋonoŋ esuŋgia kamakamaata kolooju ano lama nemuŋa ano bulmakao nemuŋa meraboragia aju oŋomakejuti, niinoŋ ii kalaŋ koma oŋomakejeŋ. Kaeŋ kolooro ii kana kembuwaajoŋ weemboria motooŋgowaa so molaŋkota oŋotaawonagati eeŋ, yoŋonoŋ mono esuŋgia kamaaro korebore komuwuyaga. ");
INSERT INTO ksr_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Kawaajoŋ eja poŋna, gii saanoŋ wala kena weleŋ ejaga niinoŋ sosooda gemaganoŋ gotaaŋ kamaŋa. Oro oŋotaawe wosonanoŋ wala kembuti ano meraborauruna esuŋgiaa so osoŋosoŋ kaŋ kaŋ era Seir gomanoŋ somatana goonoŋ kouboŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Kaeŋ ijoro Iisoonoŋ kokaeŋ jero: “Kaeŋ kolooro nii saanoŋ ejauruna tosaaŋa oŋomesaowe giwo osoŋ kawu.” Kaeŋ jero Jeikobnoŋ kokaeŋ qisiro: “Gii mono naambaajoŋ kaeŋ anaga? Oo eja poŋna, nii goo jaanoŋ kiaŋkoomu mokoloowe mono sokoma nono tegoja.” ");
INSERT INTO ksr_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Kaeŋ jero Iisoonoŋ weemboria iikanoŋadeeŋ eleema kema Seir gomaŋanoŋ keuro. ");
INSERT INTO ksr_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jeikobnoŋ Sukot gomanoŋ kema iikanoŋ aŋaa miria osoŋ orouruta yoŋoojoŋ kuuŋa kuuŋa mero. Kawaajoŋ gomaŋ miri iikawaa qata Sukot (Halihali) qamakeju. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jeikobnoŋ tani kaaŋanoŋ Mesopotemia (Padan Aram) baloŋ mesaoro. Mesaoŋ kaŋ Keinan balombaa taoŋ qata Sekem kanoŋ awaagadeeŋ kouro. Kouma opo sel kuuŋa taoŋ kosianoŋ baloŋ korianoŋ mororoŋgoŋ kuuŋ ragi. ");
INSERT INTO ksr_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Opo sel kuuŋa baloŋ korianoŋ kuuroti, iinoŋ gomaŋ kitia ii Sekembaa maŋa Hamor iwaa merauruta yoŋoonoŋga silwa kota 100 kanoŋ sewaŋa mero. ");
INSERT INTO ksr_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Sewaŋa meŋ kanoŋ jiwowoŋ alata moŋ meŋ qata “El, Israelwaa beŋ Anutuya,” kaeŋ qaro. (El = beŋ) ");
INSERT INTO ksr_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Leanoŋ Jeikobwaa borata Daina meroti, iinoŋ kambaŋ moŋnoŋ Keinan emba saraŋ iŋiimambaajoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Keno baloŋ iikawaa eja poŋa Hamor iinoŋ Hiwi kanagesowaa ejaga laligoro. Iwaa meria Sekem iinoŋ Daina iima iikanondeeŋ iimanaaŋnaaŋ moma horoŋ meŋ kileeŋ muro. ");
INSERT INTO ksr_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sekemnoŋ wombota Jeikobwaa borata Dainawaajoŋ pororogoŋ somoŋgoŋ uukaleŋanoŋ jopagoŋ muŋ kele qaayanoŋ jeŋ tutugoŋ muŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Tutugoŋ muŋ laligoŋ maŋa Hamor kokaeŋ ijoro: “Ama, gii saanoŋ emba saraŋ koi noo embanaga koloowaatiwaajoŋ qaa gawoŋ mewa.” ");
INSERT INTO ksr_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Kambaŋ kanoŋ Jeikobwaa meraaŋuruta yoŋonoŋ baloŋ korianoŋ kema miriwaa orourugia galeŋ koma oŋoma laligogi Sekemnoŋ Daina meŋ kileero maŋa Jeikobnoŋ borataa buzu qaa ii kaeŋ moro. Ii moroto, ii mesaŋgoŋ merauruta mirinoŋ koubutiwaajoŋ qaaya bogoro mamboma raro. ");
INSERT INTO ksr_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Mamboma raro Sekembaa maŋa Hamor iinoŋ qaa gawoŋ memambaajoŋ Jeikobwaanoŋ karo. ");
INSERT INTO ksr_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Kaŋ raro Jeikobwaa meraurutanoŋ baloŋ korianoŋga kougi. Kouma iikanondeeŋ iwoi asugirotiwaa sunduya ii kokaeŋ mogi: Sekemnoŋ Jeikobwaa borata meŋ kileero Israel kanatuuru batugianoŋ sili gamuyawo kolooro. Sili ii mende aaŋaa so kolooro. Ii moma uugianoŋ kobooro wosobiri moma goroŋooso aŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Goroŋooso mokoloogito, Hamornoŋ kokaeŋ iŋijoro: “Merana Sekembaa uuwombotaa naaŋa ii oŋoo naamboragiaajoŋ mokotaaŋ raja. Kawaajoŋ saanoŋ jeŋ tegogi Dainanoŋ iwaa embia koloonaga. ");
INSERT INTO ksr_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Saanoŋ nonowo naamboraurunana utequte ama aoniŋ kema karo laligowoŋa. Kaeŋ saanoŋ qenaqena kolooŋ laligowoŋa. ");
INSERT INTO ksr_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Kaeŋ ama saanoŋ nonoo batunananoŋ rama laligowu. Nono balonana koi ii mende aŋgoŋ komboŋato, oŋo saanoŋ iikanoŋ laŋ kema kaŋ aiŋgiaa so baloŋ kitia kitia buŋa qeŋ aoŋ mirigia meŋ nonowo aŋguneŋ-qaŋguneŋ ama laligowoŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Kaeŋ jero Sekemnoŋ Dainawaa maŋnaaŋuruta ii kokaeŋ iŋijoro: “Niinoŋ oŋoo jaanoŋ kiaŋkoomu mokoloomambaajoŋ moma qisiŋ oŋonjeŋ. Kawaajoŋ ii me woiwaa qisiŋ nombuti, nii saanoŋ ii oŋomaŋa. ");
INSERT INTO ksr_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Emba sewaŋa ano kaleŋ meŋ kaŋ oŋomaŋati, iikawaa jaŋgoya ii saanoŋ aiŋgiaa so meŋ ubu. Ii me woiwaa qisiŋ nombuyagati, niinoŋ ii saanoŋ oŋomaŋa. Qaana kota koi: Oŋonoŋ mono jeŋ tegoŋ naamboragia noŋgi noo embanaga koloowaa.” ");
INSERT INTO ksr_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Sekemnoŋ naaŋgia Daina meŋ kileerotiwaajoŋ ama Jeikobwaa merauruta yoŋonoŋ osoŋkakale qaganoŋ Sekem ano maŋa Hamor meleema oroma ");
INSERT INTO ksr_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","qaa kokaeŋ jegi mori: “Eja mombaa selianoŋ Anutuwaa aiweseya mende kotogiti, nono naamboranana eja iikaaŋa saanoŋ mende muboŋa. Kaeŋ aniŋ gamugamu qanananoŋ ubabo. Kawaajoŋ nono ii mubombaajoŋ amamaajoŋ. ");
INSERT INTO ksr_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Oŋo sili motooŋgo kokaeŋ aŋgi nono uumotooŋgo amboŋa: Wala Anutuwaa aiweseya ii ejaurugia kuuya oŋoo selegianoŋ kotogi tegoro nono laligojoŋi kaaŋa koloowuti eeŋ, mono naamboranana saanoŋ oŋomboŋa. ");
INSERT INTO ksr_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Kaeŋ aŋgi saanoŋ oŋowo naamboraurunana utequte ama aoniŋ kema karo laligowoŋa. Kaeŋ saanoŋ oŋoo batugianoŋ rama kanageso tuuŋ motooŋgo kolooŋ laligowoŋa. ");
INSERT INTO ksr_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Kaeŋ laligowoŋato, Anutuwaa aiweseya selegianoŋ kotowombaajoŋ uumotooŋgo mende ambuti eeŋ, nono mono naamboranana wama moŋgeŋ kemboŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Qaa kaeŋ jegi Hamor ano meria Sekem yoronoŋ qaa kaaŋa kawaajoŋ mori sokono. ");
INSERT INTO ksr_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Kaeŋ mori eja gbaworo Sekemnoŋ maŋaa sumaŋuruta yoŋoo batugianoŋ tosaaŋa uŋuuguŋ qabuŋa somata meŋ laligoro. Iwaa uunaaŋanoŋ Jeikobwaa borataajoŋ mamaga erotiwaajoŋ ama qaa jegiti, ii otaamambaajoŋ isinabisina mende ama kambaŋ mende qeŋ koriro uro. ");
INSERT INTO ksr_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Kaeŋ kolooro Hamor ano meria Sekem yoronoŋ Sekem taombaa eja alauruta yoŋowo qaa jewombaajoŋ taombaa nagu kosianoŋ ajoajoroo sombeŋgianoŋ kema kokaeŋ jeri: ");
INSERT INTO ksr_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Eja koi yoŋonoŋ ananawo ala awaa meŋ aoŋkeju. Kawaajoŋ anana saanoŋ jeŋ tegoniŋ yoŋonoŋ ananaa balonoŋ rama lansaŋ kema kaŋ mirigia meŋ ananawo aŋguneŋ-qaŋguneŋ ama laligowoŋa. Yoŋonoŋ baloŋ kitia mewuwaajoŋ titiŋa mamaga eja. Anana saanoŋ yoŋowo naamboraurunana utequte ama aoniŋ kema karo laligowoŋa. ");
INSERT INTO ksr_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Anana sili motooŋgo kokaeŋ aniŋ eja yoŋonoŋ ananawo laligowombaajoŋ uumotooŋgo ambu: Anutuwaa aiweseya ii eja iyoŋoo selegianoŋ kotogi eji, iikawaa so ii wala kuuya ananaa selenananoŋ kaaŋagadeeŋ kotoniŋ tegoro anana saanoŋ yoŋowo kanageso tuuŋ motooŋgo kolooŋ laligowoŋa. ");
INSERT INTO ksr_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","“Kaeŋ aniŋ yoŋoonoŋ miriwaa oro tuuŋgia ano esuhina iwoigia kuuya ii mono ananaa buŋa koloowuya. Kawaajoŋ qaa ninijogiti, ii saanoŋ moma wambelaaniŋ yoŋonoŋ ananaa batunananoŋ rara dunduŋgia mokolooŋ laligowu.” ");
INSERT INTO ksr_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Kaeŋ iŋijori taombaa kiropo naguyanoŋ kaŋ ajoroogiti, iyoŋonoŋ kuuya Hamor ano meria Sekem yoroo qaawaajoŋ uumotooŋgo ama jegi Anutuwaa aiweseya ii Sekem taombaa eja kuuya yoŋoo selegianoŋ kotodaborogi. ");
INSERT INTO ksr_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Kotodaborogi weemboria 3:a kolooro kanoŋ wijigiaa siimboboloya ii kaaŋiadeeŋ toroqeŋ moma ragi Jeikobwaa merawoita woi Simeon ano Liwai, Dainawaa naaŋwoita yoronoŋ manjawaa soogara somata meŋ taoŋ iikanoŋ saŋgabaŋga kema toogia mende moma ragi alanzaŋ manja qeŋ eja kuuya japaleleŋ uŋuri komudaborogi. ");
INSERT INTO ksr_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamor ano meria Sekem ii kaaŋiadeeŋ manjawaa soo somatanoŋ ururi komuri. Komuri Sekembaa mirinoŋga naaŋgara Daina ii horoŋ kamaaŋ wama keni. ");
INSERT INTO ksr_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Kaeŋ ani Jeikobwaa meraurutanoŋ Sekemnoŋ naaŋgia meŋ kileeŋ murotiwaajoŋ ama taonoŋ sararagoŋ kema eja qamogia iŋiima taombaa esuhina iwoiya luluuma qeŋ yoŋgoro megi. ");
INSERT INTO ksr_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Lama, meme, bulmakao ano doŋgi tuuŋa tuuŋa ano ilawoilagia kuuya taoŋ uutanoŋ ano baloŋ korianoŋ egiti, ii kuuya kalugoŋ medaborogi. ");
INSERT INTO ksr_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Esuhina iwoigia kuuya korama emba meraboraurugia kuuya uŋuama mirigianoŋ iwoigia tosaaŋa eroti, ii kololooŋ luluuma qeŋ yoŋgoro meŋ togoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Kaeŋ aŋgi Jeikobnoŋ Simeon ano Liwai kokaeŋ irijoro: “Oro kaeŋ ani kakasililiŋ somataa qaayanoŋ mono noo qananoŋ uro laligomaŋa. Baloŋ kokawaa toya Keinan kanageso ano Periz kanageso yoŋonoŋ mono kazi moma noma laligowu. Nii oŋoo kanatuuruna nono afaaŋanoŋ laligojoŋ. Kawaajoŋ yoŋonoŋ manjaqeqe ejaurugia kululuuŋ oŋoma qotogoŋ nonoma manja qeŋ nombuti eeŋ, yoŋonoŋ mono saanoŋ japaleleŋ nuŋ nii ano kanatuuruna tiwilaaŋ nonombuya.” ");
INSERT INTO ksr_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Jeikobnoŋ kaeŋ irijoroto, iyoronoŋ qaa kokaeŋ ijori: “Moŋnoŋ nonoo naaŋnana kana somata emba tani ama muroti, nono mono iikawaa iroŋa meleema oŋoniŋ sokonja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Anutunoŋ Jeikob qaa kokaeŋ ijoro: “Gii mono waama Betel gomanoŋ kema rara dunduŋga mokolooŋ kanoŋ Anutuwaajoŋ siimoloŋ alata moŋ mewa. Daga Iisoowaajoŋ oloŋ koma kena Anutunoŋ kambaŋ iikanoŋ asugiŋ gonoti, mono iwaajoŋ alata ii mewa.” ");
INSERT INTO ksr_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Kaeŋ ijoro Jeikobnoŋ sumaŋa ano ejemba kuuya iwo laligogiti, ii kokaeŋ jeŋ kotoŋ oŋono: “Beŋ doŋlopioŋ iwoi towoya batugianoŋ ejuti, ii mono qetegoŋ giligi keno koma konjoratiŋ meŋ aoŋ selegia soŋgbama opo malekugia utegowu. ");
INSERT INTO ksr_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Nii koŋajiliŋ uutanoŋ laligoŋ Anutu qama kooliwe meleema nono ano daeŋ daeŋ kema kaŋ laligoweti, iinoŋ iikanoŋ niwo laligoŋ kouro. Kawaajoŋ oŋo mono kagi Betel gomanoŋ kemboŋa. Nii iikanoŋ Anutuwaajoŋ siimoloŋ alata moŋ memaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Kaeŋ jeŋ kotoŋ oŋono borogianoŋ doŋlopioŋ iwoi towoya kuuya egiti ano gejagianoŋ maŋgu sulugiti, ii qetegoŋ kololooŋ Jeikob mugi. Mugi kema jujuu gere moŋ Sekem gomanoŋ nanoti, iikawaa kanianoŋ namonoŋ osoŋ roŋ kono. ");
INSERT INTO ksr_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Kaeŋ ama waama keŋgi taoŋa taoŋa liligoŋ ragiti, Anutunoŋ kanatuurugia iyoŋoo uugia kuuro sombugia kanjaŋawo moma eleŋgia kamaaro Jeikob ano merauruta ii mende oŋotaagi. ");
INSERT INTO ksr_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Kaeŋ kema laligoŋ Jeikobnoŋ ano kanatuuruya kuuya iwo laligogiti, ii uŋuama Luz gomanoŋ keugi. Luz qata moŋ Betel ii Keinan balonoŋ eja. ");
INSERT INTO ksr_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Kanoŋ keuma Jeikobnoŋ siimoloŋ alata moŋ mero. Dataajoŋ oloŋ koma kenoti, kambaŋ iikanoŋ Anutunoŋ baloŋ iikanoŋ asugiŋ muro. Kawaajoŋ Jeikobnoŋ gomaŋ miri iikawaa qata El Betel qaro. (El Betel = Betelwaa Beŋa) ");
INSERT INTO ksr_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Betel kanoŋ laligogi Rebekawaa weleŋ embia Debora ii komuro. Komuro Betel gomaŋ baatanoŋ jujuu gere mombaa kanianoŋ roŋ koŋgi. Jiŋgeŋ qama saagitiwaajoŋ ama jujuu gere iikawaa qata ‘Jiŋgeŋ saawaa jujuu’ kaeŋ qagi. ");
INSERT INTO ksr_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Jeikobnoŋ Mesopotemia (Padan Aram) balonoŋa eleema karo Anutunoŋ mombo asugiŋ muŋ kotuegoŋ muro. ");
INSERT INTO ksr_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Kotuegoŋ muŋ kokaeŋ jero moro: “Goo qaga Jeikob (tiliqili eja) qamakejuto, iikaaŋa toroqeŋ mende qama laligowu. Kete kanaiŋ uma qaga mono Israel ewaa.” Poŋnoŋ kaeŋ jeŋ qata Israel qaro. (Israel = Anutuwo aoŋ orori.) ");
INSERT INTO ksr_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Qata kaeŋ qama toroqeŋ Jeikob kokaeŋ ijoro: “Nii Anutu ku-usuŋ kuuyaa Toya koloojeŋ. Gii saanoŋ kolooŋ seisei ana gbiliuruga yoŋoo jaŋgogianoŋ somariiŋ ubaa. Goonoŋga kanatuuru mamaga kolooŋ kanageso tuuŋa tuuŋa asugiwu. Gii kiŋa kiŋa yoŋoo bemunjalegiaga koloowaga. ");
INSERT INTO ksr_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Niinoŋ baloŋ Aabraham ano Aisak buŋa qeŋ orombeti, ii mono goo buŋa qemaŋa ano goo gemaganoŋ gbiliuruga yoŋoo buŋagia kaaŋagadeeŋ koloowaatiwaajoŋ ii qemaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Anutunoŋ qaa kaeŋ ijoŋ Jeikob mesaoŋ gomaŋ miri iikanoŋa kanakeewaŋ uro. ");
INSERT INTO ksr_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Anutunoŋ qaaya ijoro moroti, Jeikobnoŋ baloŋ iikanoŋ jamo moŋ meŋ waama tooŋ kuuŋ ii wain ooyanoŋ mamatewooya meŋ moriŋ iikawaa qaganoŋ oil gerewaa kelega maaro kemero. ");
INSERT INTO ksr_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Anutunoŋ qaa ijoroti, Jeikobnoŋ gomaŋ miri iikawaa qata Betel (Anutuwaa miri) qaro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Kawaa gematanoŋ Jeikobnoŋ sumaŋuruta uŋuama Betel gomaŋ mesaoŋ kema laligoŋ Efrata gomaŋ dodowigi Reizelnoŋ mera meme kambaŋanoŋ kaŋ kuuro masu jekania booroŋgia qero. ");
INSERT INTO ksr_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Masu qenjeŋ-mamjeŋawo somata qeroti, kambaŋ iikanoŋ koipu embanoŋ qaa kokaeŋ jero moro: “Oo Reizel, toroko mende moba. Gii mono kambaŋ kokaamba kaaŋagadeeŋ mera ejaga moŋ mombo mewaga.” ");
INSERT INTO ksr_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Kaeŋ jero mera meŋ komumambaajoŋ ama tomoya meŋ kuuro eŋ qata iikawaajoŋ Benoni qaro. (Benoni = siimbobolonaa merana) Kaeŋ qaroto, maŋanoŋ qata Benjamin qaro. (Benjamin = Simbawoŋ merana) ");
INSERT INTO ksr_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Reizelnoŋ kaeŋ komuro Efrata kana goraayanoŋ Betlehem kanoŋ roŋ koŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Roŋ koŋgi Jeikobnoŋ tooŋ jamo moŋ meŋ Reizelwaa qasirinoŋ kuuro. Reizelwaanoŋ tooŋ jamo ii kambaŋ kokaamba kaaŋagadeeŋ toroqeŋ nanja. ");
INSERT INTO ksr_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Kaeŋ kolooro Israelnoŋ gomaŋ ii mesaoŋ toroqeŋ kema laligoŋ Eder miri korigaa teegeŋ keuma opo sel kuuŋa iikanoŋ mororoŋgoŋ kuuro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Jeikobwaa sumaŋuruta yoŋonoŋ baloŋ iikanoŋ rama laligoŋ mutu meria Ruuben iinoŋ maŋaa embia sewaŋa mende memeta Bilha iwaanoŋ kema motooŋ eri maŋa Israelnoŋ iikawaa buzuya moro. ");
INSERT INTO ksr_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Jeikobwaa merauruta 12 ii kokaeŋ: Leawaa merauruta Ruuben ii Jeikobwaa meria mutuya. Iwaa gematanoŋ Simeon, Liwai, Juuda, Aiskar ano Sebulun. ");
INSERT INTO ksr_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Reizelwaa merawoita qagara Joosef ano Benjamin. ");
INSERT INTO ksr_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bilha Reizelwaa weleŋ embawaa merawoita ii Dan ano Naftali. ");
INSERT INTO ksr_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Zilpa Leawaa weleŋ embawaa merawoita ii Gad ano Aser. Jeikobwaa merauruta kaaŋa ii Mesopotemia (Padan Aram) balonoŋ koloogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jeikobnoŋ kema laligoŋ Kiriat Arba (qata moŋ Hebron) kawaa kosianoŋ Mamre gomanoŋ maŋa Aisakwaanoŋ keuro. Asia Aabraham ano maŋa Aisak yoronoŋ wala baloŋ iikanoŋ waba kolooŋ laligori. ");
INSERT INTO ksr_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Maŋa Aisakwaa laaligo kambaŋa ii yambu 180 kolooro komuro. ");
INSERT INTO ksr_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Eja waŋa kolooro yambuyanoŋ momogoro goroŋ qeŋ komuŋ ambosakoŋuruta yoŋoonoŋ toroqero. Merawoita Iisoo (Eesau) ano Jeikob yoronoŋ qamoya ii roŋ koni. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Iisoo qata moŋ Edom iwaa gbiliuruta yoŋoo qa areŋgia ii kokaeŋ: ");
INSERT INTO ksr_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iisoonoŋ Keinan emba karooŋ oŋonoti, iyoŋoo qagia ii kokaeŋ: Ada ii Hit eja Elon iwaa borataga, Oholibama ii Hiwi eja Zibeombaa meria Ana iwaa borataga. ");
INSERT INTO ksr_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Basemat ii Ismaelwaa borata Nebaiotwaa naaŋa. ");
INSERT INTO ksr_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adanoŋ Iisoowaa meria Elifaz mero Basematnoŋ iwaa meria Reuel mero. ");
INSERT INTO ksr_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibamanoŋ Jeus, Jalam ano Kora oŋono. Iisoowaa merauruta kaeŋ ii Keinan balonoŋ koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","7","Jeikob ano Iisoo yoroonoŋ miriwaa oro tuuŋa tuuŋa mamaga egitiwaajoŋ baloŋ wabaga laligoriti, iikanoŋ mende sokono. Esuhinagaranoŋ somata totooŋ kolooro motooŋ rama laligowombaajoŋ amamaagi. (6) Kawaajoŋ Iisoonoŋ embauruta, meraborauruta ano kanagesouruta kuuya iwaa mirinoŋ laligogiti, ii uŋuano. Ii uŋuama lama bulmakao tuuŋa tuuŋa, doŋgi kameluruta ano esuhina iwoiya kuuya Keinan balonoŋ laligoŋ mokolooroti, ii meŋ koga Jeikob mesaoŋ baloŋ moŋnoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Iisoo qata moŋ Edom iinoŋ kaeŋ ama Seir baloŋ baaŋayawo kanoŋ kema laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Iisoonoŋ Seir baloŋ baaŋayawo kanoŋ laligoŋ Edom kanageso yoŋoo bemunjalegia kolooroti, iwaa gbiliuruta yoŋoo qa areŋgia ii kokaeŋ: ");
INSERT INTO ksr_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Iisoowaa merauruta yoŋoo qagia ii kokaeŋ: Embia Ada iwaa meria qata Elifaz. Embia Basemat iwaa meria qata Reuel. ");
INSERT INTO ksr_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifazwaa merauruta 5 ii Teman, Omar, Zefo, Gatam ano Kenaz. ");
INSERT INTO ksr_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Iisoowaa meria Elifaz iwaa embia sewaŋa mende memeta qata Timna iinoŋ Elifazwaa meria Amalek mero. Iisoowaa embia Ada iwaa esa ejauruta ii kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuelwaa merauruta 4 ii Nahat, Zera, Sama ano Miza. Iisoowaa embia Basematwaa esauruta eja ii kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Iisoowaa embia Oholibama iinoŋ Iisoowaa merauruta karooŋ oŋonoti, ii qagia Jeus, Jalamano Kora qagi. Oholibama ii Zibeombaa meria Ana iwaa borata kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Iisoowaa gbiliuruta tuuŋa tuuŋa yoŋoo eja poŋgia ii kokaeŋ: Iisoowaa meria mutuya Elifaz iwaa merauruta eja poŋ koloogiti, ii qagia Teman, Omar, Zefo, Kenaz, ");
INSERT INTO ksr_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam ano Amalek. Elifazwaa gbiliuruta eja poŋ Edom balonoŋ koloogiti, ii kiaŋ. Ii Iisoowaa embia Ada iwaa esaurutaga koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Iisoowaa meria Reuel iwaa merauruta eja poŋ koloogiti, ii qagia kokaeŋ: Nahat, Zera, Sama ano Miza. Reuelwaa gbiliuruta eja poŋ Edom balonoŋ koloogiti, ii kiaŋ. Ii Iisoowaa embia Basemat iwaa esaurutaga koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Iisoowaa embia Oholibama iwaa merauruta eja poŋ koloogiti, ii qagia kokaeŋ: Jeus, Jalamano Kora. Eja poŋ ii Iisoowaa embia Oholibama, Anawaa borata iwaa merauruta koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Iisoo (Esau) qata moŋ Edom iwaa merauruta kiaŋ ano yoŋoo kanagesourugia ano eja poŋgia ii kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Hoor kanagesowaa eja Seir iwaa merauruta wala Edom balonoŋ laligogiti, iyoŋoo qagia ii kokaeŋ: Lotan, Sobal, Zibeon, Ana, ");
INSERT INTO ksr_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Ezer ano Disan. Seirwaa merauruta ii wala Edom balonoŋ Hoor kanageso yoŋoo eja poŋgiaga laligogi Iisoonoŋ kanageŋ karo. ");
INSERT INTO ksr_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotambaa merawoita woi ii qagara Hori ano Heman. Lotambaa naaŋa qata Timna. ");
INSERT INTO ksr_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobalwaa merauruta qagia ii kokaeŋ: Alwan, Manahat, Ebal, Sefo ano Onam. ");
INSERT INTO ksr_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeon iwaa merawoita woi qagara Aiya ano Ana. Anawaa sunduya ii kokaeŋ: Iinoŋ maŋa Zibeombaa doŋgia baloŋ qararaŋkoŋkoŋanoŋ galeŋ koma oŋono nene moŋgama negi iikanoŋ apu jaaya jaaya geriawo mokolooro. ");
INSERT INTO ksr_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anawaa meraborawoita woi ii meria Dison ano borata Oholibama. ");
INSERT INTO ksr_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disombaa merauruta qagia ii kokaeŋ: Hemdan, Esban, Itran ano Keran. ");
INSERT INTO ksr_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezerwaa merauruta qagia ii kokaeŋ: Bilhan, Zaawan ano Akan. ");
INSERT INTO ksr_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disambaa merawoita woi ii qagara Uuz ano Aran. ");
INSERT INTO ksr_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hoor kanagesoya kanagesoya yoŋoo eja poŋurugia yoŋoo qagia ii Lotan, Sobal, Zibeon, Ana, ");
INSERT INTO ksr_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Ezer ano Diisan. Hoor kanagesoya kanagesoya yoŋoo eja poŋurugia ii areŋgiaa so Seir balonoŋ kaeŋ laligogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Israel kanageso yoŋoonoŋ kiŋ poŋ moŋ mende galeŋ koma oŋono walawala kambaŋ kanoŋ kiŋ poŋ kokaeŋanoŋ Edom baloŋ kanoŋ galeŋ koma oŋoma laligogi: ");
INSERT INTO ksr_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beorwaa meria Bela iinoŋ Edom yoŋoo kiŋ poŋgia kolooro. Iwaa sitiaa qata Dinhaba. ");
INSERT INTO ksr_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Belanoŋ komuro Bozra gomambaa eja qata Jobab, Zerawaa meria iinoŋ Belawaa duŋanoŋ kiŋ kolooŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobabnoŋ komuro Teman balombaa eja qata Husam iinoŋ duŋanoŋ kiŋ kolooŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam komuro Hadad, Bedadwaa meria iinoŋ duŋanoŋ kiŋ kolooŋ laligoro. Hadadnoŋ Moab balonoŋ kema Midian eja yoŋowo manja qeŋ uŋuŋ haamo ano. Iwaa sitiaa qata ii Awit. ");
INSERT INTO ksr_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadnoŋ komuro Masreka gomambaa eja qata Samla iinoŋ duŋanoŋ kiŋ kolooŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samlanoŋ komuro Saul iinoŋ kitianoŋ kiŋ kolooŋ laligoro. Iwaanoŋ gomaŋ miri Rehobot ii Yufreitis apu gowoyaa kosianoŋ ero. ");
INSERT INTO ksr_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saulnoŋ komuro Baalhanan, Akborwaa meria iinoŋ Saulwaa kitianoŋ kiŋ kolooŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akborwaa meria Baalhanan komuro Hadarnoŋ kitianoŋ kiŋ kolooŋ laligoro. Iwaa sitiaa qata ii Pau. Embiaa qata Mehetabel. Ii Matredwaa borata ano Mezahabwaa esiaga laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Iisoowaa gbiliuruta yoŋoo eja poŋ qa areŋgia ii isigiaa so ano gomaŋ miri baloŋgiaa so kokaeŋ kolooro: Timna, Alwa, Jetet, ");
INSERT INTO ksr_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinon, ");
INSERT INTO ksr_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibsar, ");
INSERT INTO ksr_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel ano Iram. Eja ii Edom kanagesowaa eja poŋurugiaga laligogi qagiaa so gomaŋ miri baloŋgiaa qagia qagi. Edom qata moŋ Iisoo iinoŋ wala baloŋ meŋ rama laligoŋ Edom kanagesowaa bemunjaleya kolooro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Aisaknoŋ Keinan balonoŋ waba kolooŋ laligoro meria Jeikobnoŋ iikanoŋ toroqeŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Jeikobwaa gbiliuruta iyoŋoo sundugia kokaeŋ: Joosefnoŋ eja gbaworo yambuya 17 kolooro daremuŋuruta, maŋaa embawoita sewaŋgara mende memeta Bilha ano Zilpa yoroo merauruta yoŋowo lama ano meme (noniŋ) tuuŋa tuuŋa galeŋ koma oŋoma laligogi. Kaeŋ laligoŋ daremuŋurutanoŋ sili aŋgiti, iikawaa sunduya bologa bologa ii maŋa ijoro moma laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Jeikobnoŋ eja waŋa kolooro meria Joosefnoŋ kolooroti, iikawaajoŋ maŋanoŋ ii merauruta tosaaŋa kuuya uŋuuguŋ uutanoŋ jopagoŋ muŋ laligoro. Kambaŋ moŋnoŋ maleku koriga iima-aiŋaiŋawo boria koriga ii meŋ Joosef muro. ");
INSERT INTO ksr_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Maŋanoŋ ii daremuŋuruta kuuya uŋuuguŋ uutanoŋ jopagoŋ muŋ laligoroti, iwaa daremuŋurutanoŋ ii iima kanaiŋ kazi ama muŋ iwo ala-alawaa qaaya moŋ mende amiŋ moma laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Gomantiiŋa moŋnoŋ Joosefnoŋ gaoŋ moŋ iima iikawaa sunduya ii daremuŋuruta iŋijoro mogi. Ii mogi uugianoŋ waaro kazi mamaga moma muŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Sunduya ii kokaeŋ jero mogi: “Mobu, nii gaoŋ moŋ iijeŋi, ii kokaeŋ: ");
INSERT INTO ksr_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Anana gawonoŋ laligoŋ wiit padi boranana somoŋgowombaa tani anjoŋ. Kaeŋ aniŋ noonoŋ wiit padi borana iikanoŋ waama koŋa nano oŋoonoŋ boraŋ kanoŋ mono noonoŋ boraŋ liligoŋ sigoŋ nanjuya.” ");
INSERT INTO ksr_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Kaeŋ iŋijoro moma daremuŋurutanoŋ Joosef kokaeŋ ijogi: “Gii nonoonoŋ kiŋ poŋga koloonaga me? Gii oŋanoŋ galeŋ koma nonomambaajoŋ mojaŋ me?” Joosefnoŋ gaoŋa iima kawaa sunduya iŋijoroti, iikawaajoŋ yoŋoo uugianoŋ mombo toroqeŋ waaro kazi somata totooŋ moma muŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Kawaa gematanoŋ gaoŋ moŋ mombo iima iikawaa sunduya daremuŋuruta kokaeŋ iŋijoro mogi: “Niinoŋ gaoŋ moŋ iibe iikanoŋ weeŋ, koiŋ ano seŋgelao 11 kanoŋ noonoŋ usugogi.” ");
INSERT INTO ksr_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Sunduya ii maŋa ano daremuŋuruta iŋijoro mogi maŋanoŋ temboma kokaeŋ jeŋ muro: “Gii gaoŋ tania kaaŋa ii nomaembaajoŋ iijaŋa? Nii, nemuŋga ano daremuŋuruga nono mono nomaeŋanoŋ goonoŋ kaŋ jaasewaŋganoŋ simiŋ kuma namonoŋ usugowonaga?” ");
INSERT INTO ksr_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Kaeŋ kolooro daremuŋurutanoŋ uugianoŋ motoqoto moma muŋ laligogito, maŋanoŋ qaa ii uu konoŋanoŋ ano ero romoŋgoŋ laligoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Kambaŋ moŋnoŋ Joosefwaa daremuŋuruta yoŋonoŋ maŋgiaanoŋ lama tuuŋuruta galeŋ koma oŋombombaajoŋ Sekem gomaŋ kosianoŋ kema laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Iikanoŋ laligogi Israelnoŋ Joosef kokaeŋ ijoro: “Merana, goo daremuŋuruganoŋ Sekem kosianoŋ lama tuuŋnana galeŋ koma oŋoma laligojuti, ii mojaŋ. Saanoŋ koi kana wasiŋ gombe yoŋoonoŋ kemba.” Kaeŋ ijoro “Saanoŋ kemaŋa,” jero. ");
INSERT INTO ksr_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Jero kokaeŋ ijoro: “Gii mono kema daremuŋuruga ano lama tuunana iŋiima nomaeŋ laligojuti, iikawaa qaa sunduya ii meŋ eleema kaŋ jena momaŋa.” Kaeŋ jero moro Hebron dondooŋanoŋga wasiŋ muro kema kema Sekem balonoŋ keuro. ");
INSERT INTO ksr_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Sekem balonoŋ keuma baloŋ korianoŋ kana moŋgama laŋ kema laligoro eja moŋnoŋ mokolooŋ iima kokaeŋ qisiŋ muro: “Gii naa iwoiga moŋgama laligojaŋ?” ");
INSERT INTO ksr_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Qisiŋ muro kokaeŋ meleeno: “Nii daremuŋuruna yoŋoojoŋ moŋganjeŋ. Yoŋonoŋ dakanoŋ liligoŋ lamaurugia galeŋ koma oŋonjuti, ii saanoŋ jena momaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Kaeŋ meleeno kokaeŋ jero: “Yoŋonoŋ mono gomaŋ koi mesaoŋ keŋgi. Dotan gomanoŋ kembombaajoŋ jegi mobe.” Kaeŋ jero moma daremuŋuruta yoŋoo kanagianoŋ oŋotaaŋ kema Dotan gomaŋ kosianoŋ kema mokolooŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Mokolooŋ oŋoma kosogianoŋ mende keuroto, sigeŋsigeŋ endu karo daremuŋanoŋ ii iima ajorooŋ Joosef qewombaajoŋ aŋgonaŋ aŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Aŋgonaŋ ama iyaŋgiodeeŋ kokaeŋ amiŋ mogi: “Iibu, gaoŋ ii-ii eja iikanoŋ mono endu kaja. ");
INSERT INTO ksr_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ayo, mono kagi kema qeniŋ komuro qamoya apu roŋa moŋnoŋ giliniŋ kemero kokaeŋ jewoŋa: ‘Oro kawalianoŋ mono ii qero komuro.’ Gaoŋaa hoŋanoŋ nomaeŋ koloowaati, ii mono iikawaa gematanoŋ iiboŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Kaeŋ amiŋ mogi Ruubenoŋ ii moma Joosef borogianoŋga metogoŋ laaligoya somoŋgomambaajoŋ moma kokaeŋ jero: “Ii mono mende qeniŋ komuwaa.” ");
INSERT INTO ksr_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Toroqeŋ kokaeŋ jero mogi: “Saya mono mende maabu. Baloŋ qararaŋkoŋkoŋanoŋ apu roŋ koi nanji, ii saanoŋ iikanoŋ giligi kemewaato, borogianoŋ mono iwaa selianoŋ mende oosiriŋ qewu.” Ruubenoŋ Joosef borogianoŋga metogoŋ aŋgoŋ koma wama maŋaanoŋ eleema kembojoŋ moma qaa kaeŋ jero. ");
INSERT INTO ksr_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Kaeŋ jero moma naŋgi Joosefnoŋ daremuŋuruta yoŋoonoŋ kouro. Kouro malekuya koriga iima-aiŋaiŋawo boria koriga mouma karoti, ii laŋ horoŋ menjuqenjuraŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ii menjurama kogia qelanjiŋ meŋ kema apu roŋnoŋ giligi kemero. Apu roŋ ii apuya qaa gbameŋaga nano. ");
INSERT INTO ksr_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Kaeŋ ama nene newombaajoŋ kamaaŋ ragi. Kamaaŋ rama jaagia uugi keno Ismael kanagesowaa komahooro eja tosianoŋ Gilead gomaŋ mesaoŋ kamelgia donoŋ donoŋ kuuŋ oŋoma awaŋao kagi iŋiigi. Yoŋonoŋ kamel qagianoŋ daŋe rombo, sele morimoriwaa kelega ano marasiŋ gere tokoya qata mor bala ii aŋgi bosima Iijipt kantrinoŋ kembombaajoŋ kagi. ");
INSERT INTO ksr_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Kaeŋ iŋiima Juudanoŋ daremuŋuruta kokaeŋ iŋijoro: “Anana konana qeniŋ komuro sayaa qaaya kolatiŋ asaŋgowoŋati eeŋ, iikanoŋ mono nomaeŋ ilaaŋ nononaga? ");
INSERT INTO ksr_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Iinoŋ ananaa konana kolooŋ ananaa sakitinana koloojiwaajoŋ mono boronananoŋ selianoŋ mende oosiriŋ qewoŋato, saanoŋ kagi kema Ismael eja yoŋonoŋ ii sewaŋa mewutiwaajoŋ oŋomboŋa.” Kaeŋ iŋijoro daremuŋurutanoŋ ii moma uumotooŋgo ama wambelaagi. ");
INSERT INTO ksr_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Kaeŋ aŋgi Midian balombaa Ismael kanagesowaa komahooro eja yoŋonoŋ kaŋ kouma uŋuuguwombaajoŋ aŋgi. Kaeŋ aŋgi kogia Joosef ii apu roŋnoŋga horogi kouro silwa kota 20:noŋ sewaŋa mewutiwaajoŋ oŋoŋgi. Oŋoŋgi Ismael eja yoŋonoŋ ii sewaŋa meŋ wama Iijipt kantrinoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Keŋgi Ruubenoŋ moŋgeŋga eleema apu roŋnoŋ karo Joosef iikanoŋ mombo mende nano iima wosoya juno wosobiria qendeema malekuya menjurano. ");
INSERT INTO ksr_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Malekuya menjurama kouruta yoŋoonoŋ eleema kaŋ kokaeŋ iŋijoro: “Mera gbaworonoŋ mono daeŋgeŋ aliŋ sooja? Yei, maŋgaa siita! Iikawaa qaaya ananaa qananoŋ uro mono nomaeŋ ambenaga?” ");
INSERT INTO ksr_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Kaeŋ iŋijoro meme (noniŋ) ejia moŋ meŋ qegi komuro Joosefwaanoŋ maleku meŋ meme iikawaa sayanoŋ qenduŋgoŋ meŋ boligi. ");
INSERT INTO ksr_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Meŋ boliŋ malekuya koriga iima-aiŋaiŋawo boria koriga ii meŋ mirinoŋ kema maŋa qendeema kokaeŋ ijogi: “Nono koi mokoloojoŋ. Ii meraga Joosefwaanoŋga me qaago, ii saanoŋ iima gosiwa.” ");
INSERT INTO ksr_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Kaeŋ jegi iima gosiŋ kokaeŋ jero: “Koi ii meranaanoŋ malekuga. Oro kawalia moŋnoŋ mono japaleleŋ qero komuro gogoro. Oŋanoŋ, Joosef ii kitomitoro borombooroŋ kolooro.” ");
INSERT INTO ksr_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Kaeŋ jeŋ amburereŋ ama wosobiria qendeema malekuya menjurama selia namonoŋ meŋ boliŋ meriaajoŋ kambaŋ koriga jiŋgeŋ qama saama laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Kaeŋ laligoro meraborauruta kuuya yoŋonoŋ kaŋ uluŋkoleŋ meŋ mubombaajoŋ aŋgito, iinoŋ ii qetama togoŋ uukonduŋgadeeŋ moma kokaeŋ jero: “Qaago! Niinoŋ mono jiŋgeŋ qama saama laligoŋ komuŋ koomu gomanoŋ meranaanoŋ kememaŋa.” Kaeŋ jeŋ Joosefwaajoŋ saama laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Kaeŋ laligoro kambaŋ kanoŋ Midian balombaa komahooro eja yoŋonoŋ Joosef wama Iijipt kantrinoŋ keuma sewaŋa mewutiwaajoŋ aŋgi Faarao kimbaa jawiŋa moŋ qata Potifar, kimbaa laaligoyaa sikiriti yoŋoo kawali galeŋgiaga laligoroti, iinoŋ ii sewaŋa mero weleŋqeqeya omaya kolooro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Kambaŋ kanoŋ Juudanoŋ daremuŋuruta oŋomesaoŋ yagomaŋanoŋ Adulam gomanoŋ kemeŋ eja moŋ qata Hira iwo rama laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Kanoŋ laligoŋ Juudanoŋ Keinan eja moŋ qata Sua iwaa borata iima embiaga mero motooŋ eri. ");
INSERT INTO ksr_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Motooŋ eri embianoŋ koro ama mera meŋ qata Er qaro. ");
INSERT INTO ksr_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Kaeŋ qama mombo koro ama mera moŋ meŋ qata Oonan qaro. ");
INSERT INTO ksr_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Kawaa baatanoŋ mombo toroqeŋ mera moŋ meŋ iwaa qata Sela qaro. Mera ii Kezib gomanoŋ laligoŋ kanoŋ mero. ");
INSERT INTO ksr_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Kaeŋ laligogi Juudanoŋ meria mutuya Er iwaajoŋ emba moŋ qata Taamar muro embiaga kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Embiaga kolooroto, Juudawaa meria mutuya Er iinoŋ Pombaa jaanoŋ kilega meme kolooŋ laligoroti, iikawaajoŋ Poŋnoŋ jeŋ tegoŋ muro komuro. ");
INSERT INTO ksr_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Komuro Juudanoŋ meria Oonambaajoŋ kokaeŋ jero: “Gii saanoŋ dagaanoŋ malo meŋ qambota koloojaŋiwaa kana qaaya otaaŋ iwo eŋ dagaajoŋ gbili mekoloowa.” ");
INSERT INTO ksr_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Kaeŋ jeroto, Oonanoŋ gbili ii iwaa buŋa mende koloowaati, kaeŋ moma sili kokaeŋ ama laligoro: Dataajoŋ gbili mekoloowabotiwaajoŋ iwaa emba maloyawo eŋ laligoriti, kambaŋ iikanoŋ kambaŋ so mera mekomekoloowaa sele apuya ii eeŋ namonoŋ maama laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Sili kaaŋ ama laligoroti, ii Pombaa jaanoŋ kilegamoŋ kolooro. Kawaajoŋ Poŋnoŋ ii kaaŋagadeeŋ jeŋ tegoŋ muro komuro. ");
INSERT INTO ksr_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Komuro Juudanoŋ eŋaroya Taamar kokaeŋ ijoro: “Gii mono maŋgaa miri gomanoŋ eleema kema maloya laaligo laligona merana Selanoŋ somariiŋ somata kolooŋgo gii gombaa.” Keeta kokaeŋ romoŋgoŋ kaeŋ ijoro: Selawaa dawoita komuri iinoŋ iikawaa so laligoŋ kaaŋagadeeŋ komuwabo. Kaeŋ romoŋgoŋ Taamar ijoro maŋaa gomanoŋ eleema kema kanoŋ rama laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Kanoŋ rama laligoro kambaŋ koriga tegoro Suawaa borata, Juudawaa embia iinoŋ komuro. Komuro jiŋgeŋ qama saama laligoro tegoro Juudanoŋ gomaŋ baloŋ qata Timna kanoŋ eja tosianoŋ iyaŋaa lamauruta yoŋoo jugia motogiti, ii iŋiimambaajoŋ uro. Adulam gomambaa eja alia Hira iwo motooŋ iikanoŋ uri. ");
INSERT INTO ksr_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Uri Taamar buzu qaa kokaeŋ jegi moro: “Moba, goo eja eŋaroganoŋ mono lamauruta yoŋoo jugia motomambaajoŋ ama Timna gomaŋ balonoŋ kenja.” ");
INSERT INTO ksr_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Kaeŋ jegi moro. Juudawaa meria Selanoŋ mono somariiŋ somata kolooro kileŋ ii embia koloowaatiwaajoŋ mende muro. Kawaajoŋ Taamarnoŋ malo laligomambaa malekuya qetegoŋ waŋ kawosesenoŋ waŋ jaaya esuuŋ turuŋ aoro. Kaeŋ ama Timna kekembaa kananoŋ kema taoŋ qata Enaim kanoŋ keuma kiropo nagu kosianoŋ raro. ");
INSERT INTO ksr_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Raro Juudanoŋ kaŋ iima jaasewaŋa esuurotiwaajoŋ ii mende iima kotoŋ ii kana somata embaga kaeŋ romoŋgoro. ");
INSERT INTO ksr_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Eŋaroyaga raroti, ii mende moma kotorotiwaajoŋ ama kana goraayanoŋ iwaanoŋ kema kokaeŋ ijoro: “Saanoŋ kana niinoŋ giwo ewota.” Kaeŋ ijoro moma kokaeŋ qisiro: “Niwo ewagatiwaa tawaya mono naa iwoiga nomba?” ");
INSERT INTO ksr_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Kaeŋ qisiro kokaeŋ ijoro: “Nii neenaa tuuŋnoŋa meme meria gbaworoya moŋ ambe goonoŋ kawaa.” Kaeŋ ijoro kokaeŋ qisiro: “Ii wala mende kaŋ kouro qaagaa hoŋa koloowaatiwaa iwoi moŋ ii nomba me qaago?” ");
INSERT INTO ksr_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Kaeŋ qisiro kokaeŋ jero: “Noo qaanaa hoŋa koloowaatiwaa iwoi moŋ ii mono naa iwoiga gombenaga?” Kaeŋ jero kokaeŋ meleeno: “Muŋgeŋ aasoganoŋ qaga mokotaaŋkejaŋi, ii ano iikawaa kasa wota ano gbaruga boroganoŋ meŋ nanjaŋi, mono ii nomba.” Kaeŋ meleeno iwoi ii muŋ iwo ero koro ano. ");
INSERT INTO ksr_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Iwo eŋ waama mirianoŋ kema waŋ kawoseseŋa luluuma qetegoŋ malo laligomambaa malekuya ii mombo mouma laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Kaeŋ laligoro Juudanoŋ kambaŋ moŋnoŋ Adulam gomambaa eja alia Hira wasiŋ kokaeŋ ijoro: “Gii mono meme (noniŋ) meria gbaworoya meŋ kema emba ii muna noo qaanaa hoŋa koloowaatiwaa iwoi ii meleema gono meŋ kawa.” Gawoŋ kaeŋ mewaatiwaajoŋ Hira wasiro kenoto, Hiranoŋ emba ii mende mokolooro. ");
INSERT INTO ksr_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Mende mokolooŋ Enaim eja tosaaŋa kokaeŋ qisiŋ oŋoma jero: “Siimoloŋ jigowaa kana somata embanoŋ Enaim kokaamba kana goraayanoŋ raroti, ii dakanoŋ?” Kaeŋ jero kokaeŋ meleema ijogi: “Emba kaaŋa moŋ ii kokanoŋ mende laligoro.” ");
INSERT INTO ksr_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Kaeŋ jegi Hiranoŋ eeŋ eleema Juudawaanoŋ kaŋ ijoro: “Niinoŋ kema emba ii mende iibe. Gomaŋ iikawaa toya yoŋonoŋ kaaŋagadeeŋ qaa kokaeŋ jegi mobe: ‘Siimoloŋ jigowaa kana somata embia moŋ ii kokanoŋ mende laligoro.’” ");
INSERT INTO ksr_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Kaeŋ ijoro Juudanoŋ kokaeŋ jero: “Oo alana, mesaowa! Iinoŋ iwoi ii saanoŋ meŋ laligowaa. Iwoi moŋ amboraga, mono jomoma noroŋgi gamunoŋ turuŋ norombabo. Niinoŋ meme meria gbaworoya koi ii saanoŋ ambe kenoto, giinoŋ emba ii mende mokoloona.” ");
INSERT INTO ksr_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Kaeŋ jero koiŋ karoombaa so tegoro tosianoŋ Juuda buzu qaa kokaeŋ ijogi moro: “Goo eŋaroga Taamarnoŋ mono serowiliŋ ama koro ama laligoja.” Kaeŋ ijogi Juudanoŋ ii moma Mooseswaa kana qaawaa so jeŋkooto kokaeŋ ano: “Ii mono wama ororaaŋ gerenoŋ giligi kemeŋ jewaa.” ");
INSERT INTO ksr_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ii wama ororaaŋ keŋgi eŋaroyanoŋ Juudawaajoŋ qaa kokaeŋ ano keno: “Oo eŋarona, iwoi kokawaa toyanoŋ mono nono koro ama laligojeŋ. Kawaajoŋ muŋgeŋ aaso koi, iikawaa kasa wota ano gbaru koi mono iima gosiŋ toya mokoloowa.” ");
INSERT INTO ksr_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Qaa kaeŋ ano keno moma aŋaa iwoiya ii iima gosiŋ kokaeŋ jero: “Iinoŋ qaa ii oŋia jeja. Niinoŋ ii merana Selawaa embia koloowaatiwaajoŋ mende mube. Kawaajoŋ iinoŋ mono nii nuuguŋ emba dindiŋa kolooŋ qaa ii jeja.” Kaeŋ jeŋ emba iikawo mombo mende ero. ");
INSERT INTO ksr_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Kanageŋ merabora memambaa kambaŋanoŋ kaŋ kuuro mera gesoyaa uutanoŋ sunesune eja meria woi rari. ");
INSERT INTO ksr_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Rari mera memambaajoŋ ano moŋnoŋ boria suluro kamaaro. Kamaaro koipu embanoŋ ii iima moma kasa oso popolaŋ meŋ borianoŋ somoŋgoŋ kokaeŋ jero: “Iinoŋ wala asugija.” ");
INSERT INTO ksr_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Kaeŋ jeroto, mera kanoŋ boria mombo hororo uro alianoŋ wala asugiro. Iinoŋ asugiro koipu embanoŋ kokaeŋ jero: “Oo mono iikaaŋa ama kanaga menjurama asugijaŋ.” Kaeŋ jero qata Perez qagi. (Perez = Kania menjuranja.) ");
INSERT INTO ksr_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Kawaa gematanoŋ aliaa borianoŋ beweso kasa oso popolaŋ eroti, iinoŋ asugiro qata Zera qagi. (Zera = oso popolaŋ) Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Kambaŋ batuya kanoŋ Ismael kanagesowaa komahooro eja yoŋonoŋ Joosef wama Iijipt kantrinoŋ keuma sewaŋa mewutiwaajoŋ aŋgi. Aŋgi Iijipt eja moŋ qata Potifar, Faarao kimbaa jawiŋa moŋ ano laaligoyaa sikiriti yoŋoo kawali galeŋgiaga laligoroti, iinoŋ ii sewaŋa mero weleŋqeqeya omaya kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Kaeŋ ama laligoro Poŋnoŋ Joosefwo nano iwoi kuuya ama meŋ laligoroti, iikanoŋ toomoriaŋ mokolooro. Iinoŋ toya Iijipt eja iwaa mirinoŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Kaeŋ laligoro Poŋnoŋ Joosefwo nama kondooŋ muro iwoi kuuya borianoŋ meŋ laligoroti, iikanoŋ toomoriaŋawo kolooro. Kaeŋ kolooro toyanoŋ ii iiro. ");
INSERT INTO ksr_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Toyanoŋ ii iiro awaa sokono iwaa jaanoŋ iima-aiŋ mokolooro ijoro aŋaa laaligoyaa galeŋa kolooro. Potifarnoŋ Joosef kuuŋ muro miriaa iwoi kuuya galeŋ kono esuhina buŋaya kuuya iwaa boronoŋ ano kalaŋ koma laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Miriaa iwoiya ano esuhina buŋaya ii kuuya Joosefnoŋ galeŋ kombaatiwaajoŋ borianoŋ ano laligoroti, Poŋnoŋ kambaŋ iikanoŋadeeŋ kanaiŋ Iijipt eja iwaanoŋ miri iwoiya ii Joosefwaajoŋ ama kotuegoŋ laligoro. Potifarwaa mirianoŋ ano gawoŋanoŋ ilawoilaya kuuya eroti, ii kotumotue qaganoŋ ero. ");
INSERT INTO ksr_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Kaeŋ ero Potifarnoŋ ilawoilaya eŋ muroti, ii kuuya Joosefwaa borianoŋ andaboroŋ nama aŋo ii me woi iikawaa majakakaya moŋ mende moro. Iinoŋ nene nemambaajoŋ kaaŋgadeeŋ motoqoto mende moma siiseweweya qaa laligoro. Joosefwaa selia onjonbonjoŋ somariiro kaitanianoŋ iima-aiŋaiŋawo ero laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Kaeŋ laligoro kambaŋ tosia tegoro Potifarwaa embianoŋ Joosef iima iimanaaŋa moma kokaeŋ ijoro: “Gii mono kana niwo ewo.” ");
INSERT INTO ksr_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Kaeŋ ijoroto, iinoŋ ii togoŋ toyaa embia kokaeŋ ijoro: “Qaago! Moba, tona aŋo mirianoŋ ilawoila ejiwaa majakakaya mende momakejato, esuhina buŋaya kuuya ii mono niinoŋ galeŋ koma laligomambaajoŋ noo boronanoŋ andabororota eja. ");
INSERT INTO ksr_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Kaeŋ ero miri kokawaa uutanoŋ ii ano nii noroo ku-usunaranoŋ mono ororoŋ eja. Giinoŋ iwaa embia koloojaŋiwaajoŋ gii aŋgoŋ koma nonoto, iwoi tosia moŋ ii noojoŋ mende aŋgoŋ kono. Kawaajoŋ nii nomaembaajoŋ ama nanamemeŋ bologa totooŋ kaaŋa ii ama iikanoŋ Anutu qotogoŋ siŋgisoŋgo ambenaga? Awawi totooŋ” ");
INSERT INTO ksr_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Kaeŋ ijoro moma qaa kaaŋa ii weemboria so Joosef ijoŋ laligoroto, iinoŋ kileŋ ii qotogoŋ kema iwaa duŋ eenoŋ kema iwo ewotiwaajoŋ mende wambelaaro. Kaeŋ iwo motooŋ laligowotiwaajoŋ kaaŋagadeeŋ togoro. ");
INSERT INTO ksr_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Kaeŋ togoŋ laligoro weemboria moŋnoŋ miriwaa weleŋqeqeuruta yoŋoonoŋga moŋnoŋ miri uutanoŋ mende laligoro Joosefnoŋ gawoŋa jejeta memambaajoŋ miri uutanoŋ uro. ");
INSERT INTO ksr_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Uro emba iikanoŋ Joosefwaa malekuyanoŋ qelanjiŋ meŋ kokaeŋ ijoro: “Gii mono kana niwo ewo.” Kaeŋ ijoroto, Joosefnoŋ malekuya ii iwaa borianoŋ mesaoŋ oloŋ koma qiqigoŋ kema sombenoŋ seleeŋgeŋ kamaaro. ");
INSERT INTO ksr_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Malekuya iwaa borianoŋ mesaoŋ oloŋ koma sombenoŋ kamaaroti, emba iikanoŋ ii iiro. ");
INSERT INTO ksr_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Ii iima miriwaa weleŋqeqeuruta oŋoono kagi ii kokaeŋ iŋijoro: “Mobu, lonanoŋ Hibruu eja ii wama mirinananoŋ karoti, iinoŋ mono goŋgiso goŋgegee ama nonoma laligoja. Iinoŋ niwo ewojoŋ noonoŋ koujato, niinoŋ qama gigilaajeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Qama gigilaawe moma malekuya noo wosonanoŋ mesaoŋ oloŋ koma qiqigoŋ kema seleeŋgeŋ kemeja.” ");
INSERT INTO ksr_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Kaeŋ iŋijoŋ Joosefwaanoŋ maleku kosianoŋ ano ero Joosefwaa toyanoŋ eleema kawaatiwaajoŋ mamboma raro karo. ");
INSERT INTO ksr_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Karo sundu ii kaaŋagadeeŋ ijoro: “Hibruu weleŋqeqe eja ii wana ananaa mirinoŋ karoti, iinoŋ mono niwo goŋaaŋgole amambaajoŋ noonoŋ koujaa. ");
INSERT INTO ksr_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Koujaato, niinoŋ qa gigilaawe malekuya noo wosonanoŋ mesaoŋ oloŋ koma qiqigoŋ kema seleeŋgeŋ kemejaa.” ");
INSERT INTO ksr_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Kaeŋ ijoro Joosefwaa toya ii embianoŋ sundu kaeŋ jero moro kokaeŋ ijoro: “Goo weleŋqeqeganoŋ mono kaeŋ ama nonja.” Kaeŋ ijoro iriŋa soono uuta gere jero. ");
INSERT INTO ksr_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Uuta gere jero jeŋ kotoro Joosef meŋ Faarao kimbaa kapuare mirinoŋ eja galeŋ koma oŋoma laligogiti, mono kapuare miri iikanoŋ ooŋgi kemeŋ eŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Joosefnoŋ kapuare miri iikanoŋ laligoroto, Poŋnoŋ Joosefwo nama kotuegoŋ kiaŋkoomu muŋ laligoro kapuare miriwaa galeŋ waŋanoŋ ii iima iwaajoŋ iima-aiŋaiŋ moro. ");
INSERT INTO ksr_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Iima-aiŋaiŋ morotiwaajoŋ eja kuuya kapuare mirinoŋ ragiti, ii Joosefnoŋ galeŋ koma oŋombaatiwaajoŋ iwaa boronoŋ oŋoono. Iwoi kuuya kanoŋ ama meŋ laligogiti, ii Joosefnoŋ jeŋ kotoŋ oŋonotiwaa so otaaŋ ama meŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Poŋnoŋ Joosefwo nama kotuegoŋ muŋ kondooro iwoi kuuya ama meŋ laligoroti, ii toomoriaŋawo asugiŋ ero. Kawaajoŋ kapuare miriwaa galeŋ waŋanoŋ Joosef iwoi kuuya nomaeŋ galeŋ koma jeŋ kotoŋ oŋoma laligoroti, iikawaa majakakaya moŋ mende totooŋ moma laligoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Kambaŋ tosia tegoro Iijiptwaa kiŋ poŋaa wain apu qambiwaa galeŋa ano bered ooŋoombaa galeŋa yoronoŋ somatagara Iijiptwaa kiŋa qotogoŋ kana soŋgiri. ");
INSERT INTO ksr_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Kaeŋ ani Faarao kiŋnoŋ jawiŋa woi, wain oo qambiwaa galeŋa waŋa ano bered ooŋoombaa galeŋa waŋa iyoroojoŋ iriŋa soono. ");
INSERT INTO ksr_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Iriŋa soono jeŋ kotoro uruama kimbaa laaligoyaa sikiriti yoŋoo kawali galeŋgiaa kapuare mirinoŋ iwaa borianoŋ orooŋgi kemeri. Joosefnoŋ kapuare miri iikanoŋadeeŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Sikiriti yoŋoo kawali galeŋgianoŋ Joosef jeŋ kotoŋ muro ii weleŋ qeŋ oroma laligoro. Kaeŋ laligoro kambaŋ tosaaŋa toroqeŋ kapuare mirinoŋ eŋ waama laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Kaeŋ eŋ waama laligogi Iijipt kimbaa wain apu qambiwaa galeŋa ano bered ooŋoombaa galeŋa yoronoŋ gomantiiŋa motooŋgo iikanoŋadeeŋ gaoŋgara iyaŋa iyaŋa iiri. Gaoŋgaraa kania ii aŋa aŋa. ");
INSERT INTO ksr_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ii iiri Joosefnoŋ umugawodeeŋ yoroonoŋ uma iriiro uukamakamaa ama bosoleeŋ rari. ");
INSERT INTO ksr_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Kaeŋ rari Faarao kimbaa jawiŋwoita iyoronoŋ Joosefwaa somatayaa kapuare mirinoŋ iwo motooŋ rariti, ii kokaeŋ qisiŋ orono: “Oro kete nomaembaajoŋ jaasewaŋgara wosobiri jaajaa uuŋ rajao?” ");
INSERT INTO ksr_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Qisiŋ orono kokaeŋ meleema ijori: “Noro gaoŋnara aŋa aŋa iijotato, iikawaa kanagara ii moronoŋ jero moboraga?” Kaeŋ ijori Joosefnoŋ kokaeŋ jero: “Anutunoŋ mono gaoŋ kanagia jejetaa Toya koloojato, saanoŋ kileŋ gaoŋgara nijori momaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Kaeŋ jero wain apu qambiwaa galeŋ waŋanoŋ gaoŋa iiroti, iikawaa sunduya ii Joosef kokaeŋ qero moro: “Nii gaonaa uutanoŋ wain apu gere moŋ ii noo wosonanoŋ nano iijeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Wain apu gerewaa boria karooŋ naŋgi kanaiŋ sota juma kouma kuuji, kambaŋ iikanoŋadeeŋ juraya kouma tuno kaŋgeŋa kaŋgeŋa asugiŋ momogogi hoŋaa kota osaajuya. ");
INSERT INTO ksr_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Osaagi nii Faarao kimbaa qambia boronanoŋ meŋ nama hoŋaa kota meŋ mejejaawe apuya Faarao kimbaa qambinoŋ kemero kimbaa borianoŋ anjeŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Kaeŋ qero moma Joosefnoŋ kokaeŋ ijoro: “Gaoŋgaa kania ii kokaeŋ: Gere boria karooŋ ii mono weemboria karoombaa sareya kolooja. ");
INSERT INTO ksr_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Weemboria karooŋ tegoro Faarao kiŋnoŋ goo waŋga metaama isama goma mombo gawoŋganoŋ goombaa. Gii wala iwaanoŋ wain apu qambiwaa galeŋaga laligoŋ qambi Faarao kimbaa borianoŋ ama laligonati, iikawaa so mono mombo ama laligowaga. ");
INSERT INTO ksr_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Kaeŋ laligowagato, siiseweweya qaa laligowagati, kambaŋ iikanoŋ mono nii romoŋgoŋ kiaŋkoomu noma sunduna Faarao kiŋ ijona moba. Kaeŋ ama ilaaŋ nona kapuare miri koi mesaoŋ kamaabenaga. ");
INSERT INTO ksr_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Moba, nii Hibruu kanagesowaa balonoŋga esuŋmumu qaganoŋ yoŋgoro nuaŋgi kaŋ kokaamba kaaŋagadeeŋ iwoi bologa moŋ kapuare miri koikawaa dutanoŋ nooŋgitiwaa so ii mende ambe.” ");
INSERT INTO ksr_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Joosefnoŋ kaeŋ jero moro bered ooŋoombaa galeŋ waŋanoŋ aliaa gaoŋaa kania awaa jeŋ asariroti, ii iima kokaeŋ jero moro: “Niinoŋ kaaŋagadeeŋ gaoŋ iibe iikanoŋ bered konde karooŋ noo waŋnanoŋ qindiiŋ kajeŋa. ");
INSERT INTO ksr_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Niinoŋ kawe konde qaganoŋ eu raji, iikanoŋ bered iwoi naaŋgiawo kania kania Faarao kimbaajoŋ ejato, kooŋa kooŋa yoŋonoŋ kouma konde qindiiŋ kajeŋati, iikanoŋadeeŋ ii nedaborojuya.” ");
INSERT INTO ksr_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Kaeŋ jero moma Joosefnoŋ kokaeŋ meleema ijoro: “Gaoŋgaa kania ii kokaeŋ: Konde karooŋ ii weemboria karoombaa sareyaga. ");
INSERT INTO ksr_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Weemboria karooŋ tegoro Faarao kiŋnoŋ jeŋ kotoro wasanoŋ guuŋ qetooŋ goma waŋga ano qamoga metaama gere taloŋawonoŋ mondoŋgi kooŋa kooŋa yoŋonoŋ kouma busuga nedaborowuya.” ");
INSERT INTO ksr_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Kaeŋ meleema jero weemboria karooŋ tegoro Faarao kimbaa kolokoloo kambaŋanoŋ kaŋ kuuro jawiŋuruta kuuya ii nene lombaŋ ooŋ oŋoono. Ii ooŋ oŋooma wain apu qambiwaa galeŋ waŋa ano bered ooŋoombaa galeŋ waŋa iyoroo waŋgara ii jawiŋuruta yoŋoo jaanoŋ metaano. ");
INSERT INTO ksr_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Wain apu qambiwaa galeŋanoŋ wala gawoŋa meŋ laligoroti, ii toroqeŋ mewaatiwaajoŋ kuuŋ muro mombo toroqeŋ qambi ii Faarao kimbaa borianoŋ ama laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Kaeŋ laligoroto, kiŋnoŋ bered ooŋoombaa galeŋ waŋaa qaaya jeŋ tegoro Joosefnoŋ gaoŋgaraa kania jero moritiwaa so ii wasanoŋ uuŋ qetooŋ waŋa ano qamoya ii metaama mondoŋgi nano. ");
INSERT INTO ksr_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Iikawaa gematanoŋ wain apu qambiwaa galeŋ waŋa iinoŋ Joosef mende romoŋgoŋ muroto, ii duduuŋ qemasologeŋ laligoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Yambu woi tegoro Faarao kiŋnoŋ gaoŋ moŋ kokaeŋ iiro: Iinoŋ Nail apu gowoyaa goraayanoŋ nano ");
INSERT INTO ksr_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","bulmakao doŋa 7 awaa soroya kele busugiawo ii apu gowoya iikanoŋa kouma bowololoo batugianoŋ nama tembaŋ kegbaŋ negi. ");
INSERT INTO ksr_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Iyoŋoo gemagianoŋ bulmakao tosaaŋa 7 sii gbaraŋgiagadeeŋ kaitanigia kaapiroŋa ii apu gowoya iikanoŋa kouma bulmakao mutuya iyoŋoo kosogianoŋ kema apu gowoyaa goraayanoŋ naŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Bulmakao kaapiroŋa sii gbaraŋgiagadeeŋ iyoŋonoŋ bulmakao doŋa awaa soroya kele busugiawo 7 ii gogoŋ oŋoŋgi. Faarao kiŋnoŋ gaoŋ ii iima iikanondeeŋ uuta tooro moma waaro. ");
INSERT INTO ksr_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Waama gaoŋaajoŋ mombo moma kemeŋ kema eŋ gaoŋ moŋ kokaeŋ iiro: Wiit dumuŋ kota gowoya motooŋgowaa batuyanoŋ hoŋa kota somasomata kaŋgeŋgiawo 7 awaa totooŋ ii toŋgbama giliro kamaaŋ naŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Iyoŋoo gemagianoŋ hoŋa kaŋgeŋgiawo 7 ii mombo toŋgbama giliro kamaaŋ naŋgi baloŋ qararaŋkoŋkoŋaa haamo gerianoŋ oŋooro sooliŋ gipeya (auta) koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Hoŋa boloboolo kaŋgeŋgiawo yoŋonoŋ hoŋa kaŋgeŋgiawo kogia somasomata kuukuuya ii gogoŋ oŋoŋgi. Faarao kiŋnoŋ iikanondeeŋ uuta tooro moma poraŋ ama waama moro hoŋa qaagoto, ii gaoŋga kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Gomaŋ asariro Faarao kiŋnoŋ gaoŋaajoŋ motoqoto moma Iijipt kantriwaa tiriqoonjoŋ ano momakooto eja kuuya horoŋ oŋono iwaa jaasewaŋanoŋ kougi. Kougi gaoŋ iirotiwaa sunduya ii jero mogito, kuuya yoŋonoŋ gaoŋaa kanagara ii Faarao kimbaajoŋ jeŋ asariwombaajoŋ amamaagi. ");
INSERT INTO ksr_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Amamaagi wain apu qambiwaa galeŋ waŋanoŋ nama Faarao kiŋ kokaeŋ ijoro: “Oo kiŋ, nii kana soŋgiweti, iikawaa qaayanoŋ keteda koi uunanoŋ kouro romoŋgojeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Kambaŋ moŋnoŋ Faarao kiŋnoŋ jawiŋwoita noroojoŋ ama iriŋa soono noma laaligoyaa sikiriti yoŋoo kawali galeŋaa kapuare mirinoŋ noono rabe. Nii ano bered ooŋoombaa galeŋ waŋa ii niwo iyaŋaa kapuare mirianoŋ noroono rari. ");
INSERT INTO ksr_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","“Iikanoŋ rama laligoŋ noronoŋ gomantiiŋa motooŋgo iikanoŋadeeŋ gaoŋnara aŋa aŋa iiri. Gaonaraa kania ii iyaŋa iyaŋa. ");
INSERT INTO ksr_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Gaonara iiri Hibruu eja gbaworo moŋnoŋ iikanoŋ norowo laligoro. Iinoŋ sikiriti yoŋoo kawali galeŋaa weleŋqeqeya laligoro noro gaonara ii ijori. Iinoŋ gaonaraa kanagara ii iyaŋa iyaŋa jeŋ asariŋ norono. ");
INSERT INTO ksr_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Kanagara jero moritiwaa so hoŋa mono tororo kokaeŋ asugiro: Niinoŋ gawona wala meŋ laligoweti, Faarao kiŋnoŋ nii gawoŋ iikanoŋ mombo noonoto, alana bered ooŋoombaa galeŋaa qaaya jeŋ tegoro wasanoŋ idoŋ qetooŋ waŋa ano qamoya ii metaama mondoŋgi nano.” ");
INSERT INTO ksr_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Kaeŋ jero Faarao kiŋnoŋ moma Joosefnoŋ jaasewaŋanoŋ koubaatiwaajoŋ jeŋ kotoŋ tosaaŋa wasiŋ oŋono kema kapuare miriwaa dutanoŋga uulaŋawo wama kagi. Kagi jero waŋ juya motogi opoqiisi malekuya utegoŋ Faarao kimbaa jaasewaŋanoŋ kouro. ");
INSERT INTO ksr_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Kouro Faarao kiŋnoŋ Joosef kokaeŋ ijoro: “Niinoŋ gaoŋ moŋ iibe kuuyanoŋ iikawaa kania jewombaajoŋ amamaajuto, moŋnoŋ goo kanaga kokaeŋ nijoro mojeŋ: ‘Moŋnoŋ gaoŋa gijoro moma giinoŋ iikawaa kania saanoŋ jeŋ asariŋkejaŋ.’” ");
INSERT INTO ksr_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Kaeŋ jero Joosefnoŋ Faarao kiŋ kokaeŋ meleema muro: “Oo Faarao kiŋ, niinoŋ qaagoto, Anutunoŋ mono gaoŋgaa kania jeŋ asariŋ qaa awaa gono uuganoŋ qeaŋgowaa.” ");
INSERT INTO ksr_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Kaeŋ meleema muro Faarao kiŋnoŋ kokaeŋ jero: “Nii gaoŋ iijeŋi, iikawaa uutanoŋ neeno Nail apu gowoyaa goraayanoŋ nanjeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Kanoŋ nambe bulmakao doŋa 7 awaa soroya busugia omakelegagiawo ii apu gowoya iikanoŋa kouma bowololoo batugianoŋ nama tembaŋ kegbaŋ nejuya. ");
INSERT INTO ksr_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Iyoŋoo gemagianoŋ bulmakao tosaaŋa 7 sii gbaraŋgiagadeeŋ kaitanigia kaapiroŋa totooŋ ii apu gowoya iikanoŋa koujuya. Niinoŋ bulmakao bologa totooŋ kaaŋa ii kambaŋ moŋnoŋ Iijipt baloŋ kuuya kokanoŋ mende iŋiibe. ");
INSERT INTO ksr_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Bulmakao sii gbaraŋgiagadeeŋ kaitanigia kaapiroŋa iyoŋonoŋ bulmakao doŋa busugia omakelegagiawo 7 wala koujuti, ii gogoŋ oŋonju. ");
INSERT INTO ksr_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","“Ii gogoŋ oŋonjuto, ii kileŋ kaitanigianoŋ gogoŋ oŋonjutiwaa so utequte mende kolooro iŋiijento, wala kaitanigianoŋ kaapiroŋa totooŋ kouma nanjuyati, iyoŋonoŋ kaaŋiadeeŋ toroqeŋ nanjuya. Nii gaoŋ kaeŋ iima uuna tooro poraŋ ama waajeŋa. ");
INSERT INTO ksr_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Waama mombo eŋ gaoŋ moŋ kokaeŋ iijeŋa: Wiit dumuŋ kota gowoya motooŋgowaa batuyanoŋ hoŋa kota somasomata kaŋgeŋgiawo 7 awaa totooŋ ii toŋgbama giliro kamaaŋ nanjuya. ");
INSERT INTO ksr_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","“Iyoŋoo gemagianoŋ hoŋa kaŋgeŋgiawo tosaaŋa 7 ii unjuta juma kouma toŋgbama giliro kamaaŋ naŋgi namo qararaŋkoŋkoŋaa haamo gerianoŋ ii oŋooro sooliŋ melaada ano gipeya (auta) koloojuya. ");
INSERT INTO ksr_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Hoŋa boloboolo gipeya kaŋgeŋgiawo ii hoŋa kaŋgeŋgiawo awaa soroya ii gogoŋ oŋonjuya. Niinoŋ gaoŋ woi ii iima tiriqoonjoŋ ejauruna iŋijojento, kuuya yoŋonoŋ iikawaa kanagara jeŋ asariŋ nombombaa amamaaju.” ");
INSERT INTO ksr_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Faarao kiŋnoŋ kaeŋ jero Joosefnoŋ qaa kokaeŋ ijoro: “Oo Faarao kiŋ, goonoŋ gaoŋwoi iikawaa kanagara ii motooŋgo koloojao. Anutunoŋ iwoi kanageŋ amambaajoŋ moji, iinoŋ ii Faarao kiŋ gii gisaanja. ");
INSERT INTO ksr_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bulmakao doŋa 7 awaa soroya ii yambu 7:baa sareya kolooju. Wiit dumuŋ kota hoŋa kaŋgeŋgiawo awaa totooŋ 7 ii kaaŋagadeeŋ yambu 7:baa sareyaga. Kanagara ii ororoŋ ano motooŋgo koloojao. ");
INSERT INTO ksr_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","“Bulmakao sii gbaraŋgiagadeeŋ kaitanigia kaapiroŋa 7 kanageŋ koujuti, ii yambu 7:baa sareyaga kolooju. Wiit dumuŋ kota hoŋa kaŋgeŋgiawo 7 baloŋ qararaŋkoŋkoŋaa haamo gerianoŋ oŋooro sooliŋ gipeya (auta) koloojuti, ii bodi laaligowaa yambu 7 iikawaa sareyaga kolooju. ");
INSERT INTO ksr_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Anutunoŋ iwoi kanageŋ amambaajoŋ moji, iinoŋ ii gi gisaama qendeenja. Faarao kimbaajoŋ qaa keteda koi kaeŋ jejeŋi, ii mono iikawaajoŋ ama jejeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Oo kiŋ, yambu 7:baa so nene moriaŋ somata qatawo asugiŋ Iijipt baloŋ kuuya sokoma ewaa. ");
INSERT INTO ksr_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","“Ii ewaato, yambu 7 iikawaa gemagianoŋ bodiwaa yambu 7 kolooŋ tiwitiwilaa somata kondooro Iijipt kantrinoŋ boliwaa. Iikanoŋ asugiro nene moriaŋ wala Iijipt balonoŋ eroti, ii baloŋ so yoŋonoŋ duduudaborowuya. ");
INSERT INTO ksr_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Bodi ii kotakota totooŋ ewaatiwaajoŋ ama gomaŋ so ejemba yoŋonoŋ nene moriambaa yambuya 7 wala Iijipt balonoŋ eroti, iikawaa qaaya ii mombo mende romoŋgoŋ laligowuya. ");
INSERT INTO ksr_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Anutunoŋ gaoŋ kania motooŋgo ii ambeŋa woi gono iijaŋi, ii kania kokaembaajoŋ: Anutunoŋ qaa ii mono somoŋgoŋ jeŋ kotiiŋ anota raja. Ii jeŋ kotiiŋ anoti, kawaajoŋ iikanoŋ mono uulaŋawo asugiwaa. ");
INSERT INTO ksr_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Kawaajoŋ Faarao kiŋ gii saanoŋ momakooto eja moŋ qaa tororo gosiŋkeji, ii meweeŋgoŋ kuuna Iijipt kantri koi galeŋ koma laligowaa. ");
INSERT INTO ksr_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Kaaŋiadeeŋ kia waŋa waŋa kuuŋ oŋona gomaŋ sokoma galeŋgiaga laligowu. Yoŋonoŋ nene moriambaa yambuya 7 iikaaŋaa uugianoŋ nene hoŋgiawo Iijipt balonoŋ asugiwuti, iikawaajoŋ jero mendeeŋgi bakagia 5 koloogi yoŋoonoŋga motooŋgo motooŋgo meŋ gawmambaa kowinoŋ meŋ kululuuŋ laligowu. ");
INSERT INTO ksr_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","“Yoŋonoŋ nama mono jeŋkooto aŋgi yambu awaa 7 koloowuti, iikaaŋaa uugianoŋ nene hoŋgia korebore meŋ kululuuŋ gosiŋ laligowu. Kaeŋ ama wiit dumuŋ kota ii Faarao kimbaa kowi miria miria kanoŋ meŋ kululuuŋ laligowu. Ii taoŋ so gawmambaa kowi miria miria kanoŋ meŋ kululuuŋ galeŋ koma laligogi kanagembaa neneyaga ewaa. ");
INSERT INTO ksr_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Nene kaeŋ meŋ kululuuŋ laligowuti, ii mono gawmambaa kowi miri so galeŋ koŋgi mawosusunoŋ ero kanageŋ bodiwaa yambu 7 Iijipt baloŋ so koloowaati, kambaŋ iikanoŋ ii saanoŋ meŋ mendeema neŋ laligowuya. Kaeŋ aŋgi kantriwaa kanatuuru nononoŋ bodi iikawaa kambaŋanoŋ nenewaa mende komuŋ gororoŋgowoŋa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Joosefnoŋ qaa kaeŋ jero Faarao kiŋ ano jawiŋuruta kuuya yoŋonoŋ areŋ iikawaajoŋ mogi sokono aiŋa mogi. ");
INSERT INTO ksr_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Kaeŋ mogi Faarao kiŋnoŋ jawiŋuruta kokaeŋ iŋijoro: “Eja kokawaa uutanoŋ beŋ yoŋoo uŋayanoŋ nano laligoji, nono ii kaaŋa eja moŋ saanoŋ mende mokoloowoŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Kaeŋ iŋijoro mogi Joosef kokaeŋ ijoro: “Anutunoŋ qaa areŋ kuuya koi gisaanji, iikawaajoŋ gii kaaŋa momakooto eja qaa tororo gosinagati, ii moŋ mende laligoja. ");
INSERT INTO ksr_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Kawaajoŋ gii mono naa jiŋkaroŋ mirinaa galeŋa waŋa kolooŋ laligowa. Giinoŋ noo kanagesouruna kuuya jeŋ kotoŋ oŋona yoŋonoŋ mono goonoŋ qaa teŋ koma qaagaa baatanoŋ laligowu. Niinoŋ jiŋkaroŋ duŋ raranoŋ ramakejeŋi, iikayadeeŋ romoŋgoŋ kawaajoŋ ama gii guuguŋ somataga kolooŋ laligomaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Kaeŋ ijoŋ toroqeŋ kokaeŋ ijoro: “Moba, niinoŋ gii Iijipt kantri kuuya kokawaa eja poŋgia laligowagatiwaajoŋ kuuŋ gonjeŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Kaeŋ ijoŋ boro susuyaa jeŋjeŋ kanoŋ aaso muŋgeŋ kaaŋa qata mokotaaŋ laligoroti, ii qetegoŋ Joosefwaa boro susuyanoŋ mouro. Opoqiisi maleku iima-aiŋaiŋawo opo taaŋanoŋ memeta ii mouma muŋ soroŋ goulnoŋ memeta moŋ ii meŋ Joosefwaa aroyanoŋ kono kemero. ");
INSERT INTO ksr_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Kaeŋ ama hoos kare qabo soroya aŋaa kareyaa qereweŋa ii iwaajoŋ jeŋ tegoro iikanoŋ uro hoosnoŋ horogi kema kaŋ laligoro. Kaeŋ kema laligoro kimbaa sikiriti manjaqeqe eja moŋnoŋ wala qele kema goda qeŋ mubombaajoŋ kokaeŋ qaro qagi laligoro: “Geja! Mono kesaambu!” Kaeŋ ama muŋ Iijipt kantri kuuyaa eja poŋga kuuŋ muro. ");
INSERT INTO ksr_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Faarao kiŋnoŋ Joosef kokaeŋ ijoro: “Niinoŋ Faarao kiŋ koloojento, Iijipt kantri kuuya kokaamba moŋnoŋ moŋ mono goo jega qotogoŋ boria me kania mende metaambaa.” ");
INSERT INTO ksr_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Kaeŋ ijoŋ Joosefwaa qata gbilia (Iijipt qaanoŋ) Zafenat-Panea qaro. Kaeŋ qama Heliopolis taombaa jigo gawoŋ galeŋ qata Potifera iwaa borata Asenat ii embiaga koloowaatiwaajoŋ muro. Kaeŋ kantriwaa eja poŋga kolooŋ Iijipt kantri iimambaajoŋ kema liligoro. ");
INSERT INTO ksr_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Joosefnoŋ yambuya 30 kolooro kanoŋ Faarao Iijiptwaa kiŋa iwaa jiŋkaroŋ gawoŋa kanaiŋ mero. Ii meŋ Faarao kimbaa sitia mesaoŋ Iijipt uutanoŋ sokoma liligoŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Nene moriambaa yambuya 7 iikawaa kambaŋanoŋ baloŋgianoŋ nene honombonoŋa qaa asugiŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Nene moriambaa yambuya 7 kaŋ kuugiti, iikawaa kambaŋanoŋ Joosefnoŋ jeŋ kotoro nene kania kania Iijipt balonoŋ asugigiti, ii meŋ kululuuŋ taoŋgia so kema gawmambaajoŋ aŋgi. Namo koria taoŋ so liligoŋ rama keŋgiti, iikanoŋ nene hoŋa asugigi ii meŋ taoŋgia so kema qenjaaro kowi mirigianoŋ aŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Joosefnoŋ jeŋ kotoro wiit padia ano dumuŋ kota tosia ii qenjaaro kowi mirigianoŋ honoŋa qaa meŋ kululuuŋ aŋgi. Ii sakasiŋ kowe goraayanoŋ ejiwaa so uma nano. Nene moriaŋ kelemaleleŋ asugiŋ toroqeŋ erotiwaajoŋ nene tarugia ii toroqeŋ weeŋgoŋ bimbimgogi bimooro amamaaŋ mesaogi. ");
INSERT INTO ksr_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Bodi kambaŋanoŋ mende kaŋ kuuro walawala kanoŋ embia Asenatnoŋ Joosefwaa merawoita woi orono. Asenat ii Heliopolis taombaa jigo gawoŋ galeŋ qata Potifera iwaa borataga. ");
INSERT INTO ksr_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Meria mutuya kolooro Joosefnoŋ qaa kokaeŋ jero: “Anutunoŋ ilaaŋ nono kakasililiŋ majakakana kuuya ano amanaa gomambaa iwoiya kuuya ii duduuŋ laligojeŋi, iikawaajoŋ.” Kaeŋ jeŋ meriaa qata Manase (Duduujeŋ.) qaro. ");
INSERT INTO ksr_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Meria kanageŋa kolooro Joosefnoŋ qaa kokaeŋ jero: “Nii siimbobolonaa baloŋanoŋ laligowe Anutunoŋ kolooŋseisei nonji, iikawaajoŋ.” Kaeŋ jeŋ qata Efraim qaro. (Efraim = Kolooŋseisei nonja.) ");
INSERT INTO ksr_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Nene moriaŋ somataa yambuya 7 Iijipt baloŋ sokoma kaŋ kuugiti, ii eŋ kougi tegoro. ");
INSERT INTO ksr_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Yambu 7 ii tegoro Joosefnoŋ qaa jerotiwaa so bodiwaa yambuya 7 ii kanaiŋ kaŋ kuugi. Bodi ii baloŋ tosia kuuya sokoma kolooŋ eroto, Iijipt balonoŋ nene ii gomaŋ so kowigianoŋ ero. ");
INSERT INTO ksr_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Iijipt kanageso korebore yoŋonoŋ kanaiŋ bodi moma Faarao kimbaa qama nene oŋombaatiwaajoŋ weleŋgi. Weleŋgi moma Faarao kiŋnoŋ ii kuuya kokaeŋ iŋijoro: “Oŋo mono Joosefwaanoŋ keŋgi iwoi ii me ii ambutiwaa jeŋ kotoŋ oŋombaati, ii mono teŋ koma otaaŋ amakebu.” ");
INSERT INTO ksr_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Bodinoŋ kantri kuuya sokoma eŋ Iijiptwaa gomaŋa gomaŋa kuuya kanoŋ toroqeŋ mamaga bimooro. Kaeŋ kolooro Joosefnoŋ jeŋ kotoro qenjaaro kowi miria miria iyoŋoo nagugia horoŋ nene ii Iijipt yoŋonoŋ sewaŋa mewutiwaajoŋ aŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Bodi ii baloŋ kuuya sokoma bimooŋ erotiwaajoŋ ejembanoŋ gomaŋ so kanoŋa Iijipt kaŋ Joosefwaanoŋ kouma nene sewaŋa meŋ laligogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Iijipt kanoŋ nene eroti, qaa ii Keinan baloŋ kanoŋ jegi tuno Jeikobnoŋ moma merauruta kokaeŋ iŋijoro: “Oŋo mono naambaajoŋ silemale ama kuru jaa aima laligoju? ");
INSERT INTO ksr_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Iijipt kanoŋ wiit dumuŋ kota eji, niinoŋ qaa kaeŋ mobe. Anana mende komuŋ laaligo toroqeŋ laligowombaa oŋo mono waama Iijipt kemeŋ kanoŋ nene tosia sewaŋa meŋ kagi neŋ laligowoŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Kaeŋ iŋijoro moma Joosefwaa dauruta 10 ii mirigia mesaoŋ nene sewaŋa mewombaajoŋ Iijipt balonoŋ kembombaa aŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Maŋgia Jeikobnoŋ Joosefwaa koga Benjamimbaa qaganoŋ tiwitiwilaa moŋ ubabotiwaajoŋ toroko moro. Kawaajoŋ ii dauruta yoŋowo mende wasiŋ muro keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Keinan balonoŋ bodi ii kaaŋiadeeŋ erotiwaajoŋ Israelwaa merauruta yoŋonoŋ Keinan eja tosianoŋ keŋgiti, iyoŋoo batugianoŋ wiit dumuŋ kota sewaŋa mewombaajoŋ motooŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Keŋgito, Joosefnoŋ Iijipt kantriwaa eja poŋgia rama laligoro. Iinoŋ wiit dumuŋ kota ii kanagesoya kuuya yoŋonoŋ sewaŋa mewutiwaajoŋ ano iwaanoŋ kouma laligogi. Kawaajoŋ dauruta kagiti, iyoŋonoŋ kouma iikanoŋadeeŋ iwaa batanoŋ simiŋ kuma namonoŋ usugogi. ");
INSERT INTO ksr_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Kaeŋ usugogi Joosefnoŋ dauruta iŋiima moma kotoŋ oŋonoto, iyaŋaa kania kolatiŋ oŋoma waba eja tani ama oŋoma horoŋ ureeŋ oŋoma qaa geriawo jeŋ kokaeŋ qisiŋ oŋono: “Oŋo mono dakaya naambaajoŋa kajuya?” Qisiŋ oŋono kokaeŋ meleeŋgi: “Nono Keinan balonoŋga nene sewaŋa mewombaajoŋ kajoŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Kaeŋ meleeŋgi Joosefnoŋ dauruta iŋiima moma kotoŋ oŋonoto, yoŋonoŋ ii mende moma kotoŋ mugi. ");
INSERT INTO ksr_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Mende moma kotoŋ mugi Joosefnoŋ eeŋanoŋ gaoŋa yoŋoojoŋ iiroti, ii momoyanoŋ kouro romoŋgoŋ soŋ jaa susugia motoŋ kokaeŋ iŋijoro: “Yei, maŋgaa siita! Oŋo kike kakasililiŋ ejaga kolooju. Nono kantrinana dakanoŋ baageŋ loolooria ero aworo (defence) ama manja qewombaajoŋ bimoojoŋi, oŋonoŋ ii iima gosiŋ mobombaajoŋ koi kajuya!” ");
INSERT INTO ksr_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Kaeŋ iŋijoro kokaeŋ meleeŋgi: “Oo eja poŋnana, kaeŋ qaago. Weleŋqeqeuruga nono nene sewaŋa mewombaajoŋ kajoŋa. ");
INSERT INTO ksr_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nono kore eja motooŋgowaa merauruta koloojoŋ. Nono eja dindiŋa laligoŋ qolomoloŋ mende jeŋkejoŋ. Goo weleŋqeqeuruga nononoŋ baloŋ iimagoosiwaa manjaqeqe ejaga mende koloojoŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Kaeŋ meleeŋgi totoroŋkota “Qaago totooŋ!” qama kokaeŋ toroqero: “Nono kantrinana dakanoŋ baageŋ aworo (defence) ama manja qewombaa bimoojoŋi, oŋo ii iima gosiŋ mobombaajoŋ koi kajuya!” ");
INSERT INTO ksr_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ii moma kokaeŋ meleeŋgi: “Weleŋqeqeuruga nono Keinan balombaa eja motooŋgowaa meraurutaga, daremuŋ 12 koloojoŋ. Konana konoganoŋ kambaŋ kokaamba maŋnanawo mirinoŋ raro moŋnoŋ mende toroqeŋ laligoja.” ");
INSERT INTO ksr_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Kaeŋ meleeŋgi kokaeŋ jeŋ oŋono: “Kaeŋ koloorogo oŋo oŋanoŋ gomaŋ iimagoosiwaa manjaqeqe ejaga koloojuti, ii mono iŋijodaborowe tegoja. ");
INSERT INTO ksr_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Kaeŋ laligojutiwaajoŋ niinoŋ kokaeŋ aŋgotete meŋ oŋomaŋa: Faarao kiŋnoŋ jaawo laligoji, niinoŋ qaa hoŋ toontooŋa iikawaa so jojopaŋ qaa kokaeŋ jeŋ kotiijeŋ: Kogia konoganoŋ koi mende kawaati eeŋ, oŋo mono baloŋ koi mende mesaoŋ kembuya. ");
INSERT INTO ksr_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Oŋo qaa hoŋa jeju me qaago, niinoŋ ii aŋgotete memambaajoŋ kokaeŋ jejeŋ: Oŋo mono batugianoŋga moŋ wasigi kema kogia konoga wano koi kawao. Tosaaŋa oŋo mono koi mamboma kapuare mirinoŋ rama laligowu. Kaeŋ mende ambuti eeŋ, oŋo oŋanoŋ baloŋ iimagoosiwaa manjaqeqe ejaga kolooju. Faarao kiŋnoŋ jaawo laligoji eeŋ, niinoŋ qaa hoŋa tooŋ iikawaa so jojopaŋ qaa ii jeŋ kotiijeŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Kaeŋ jeŋ oŋoma jero kapuare mirianoŋ oŋooŋgi weemboria karoombaa so ragi. ");
INSERT INTO ksr_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Weemboria karooŋ koloorogo Joosefnoŋ kaŋ qaa kokaeŋ iŋijoro: “Jaagiawo toroqeŋ laligowombaajoŋ mobuti eeŋ, oŋo mono iwoi jemaŋati, ii aŋgi niinoŋ saanoŋ laaligogia somoŋgomaŋa. Niinoŋ kaaŋagadeeŋ oŋo kaaŋa Anutuwaa jeta uugumambotiwaajoŋ keena momakejeŋ. Kawaajoŋ oŋo mono kokaeŋ ambu: ");
INSERT INTO ksr_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Oŋo eja dindiŋa qolomoloŋgia qaa laligojuti eeŋ, daremuŋ oŋoonoŋga mono moŋnoŋ kapuare mirinoŋ toroqeŋ raro tosaaŋa oŋo saanoŋ wiit dumuŋ kota meŋ gomaŋgianoŋ eleema kembu. Iikanoŋ kema mirigianoŋ kanagesourugia bodi qaganoŋ laligojuti, ii nene oŋombu. ");
INSERT INTO ksr_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Oŋo mono kaeŋ kema kogia konoga wama noonoŋ kawu. Kagi qaagiaa hoŋanoŋ kaeŋ asugiro iima moma kotoŋ mende uŋuwe komuwuya.” Qaa kaeŋ iŋijoro mono iikawaa so aŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Yoŋonoŋ Hibruu qaagianoŋ batugianoŋ qaa kokaeŋ amiŋ mogi: “Nono konana sili ama muniŋi, iikawaa iroŋa kileganoŋ mono oŋanoŋ qanananoŋ uja. Iinoŋ laaligoya somoŋgoŋ kiaŋkoomu mubombaajoŋ welema kuuŋ nonono kakasililiŋa somata iininto, iwaa qaaya moma ii tondu mende otaaniŋ. Kawaajoŋ kakasililiŋ lombotawo koi kanoŋ ananaa qanananoŋ uja.” ");
INSERT INTO ksr_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Kaeŋ amiŋ mogi Ruubenoŋ kokaeŋ jero: “Nii kambaŋ kanoŋ kokaeŋ iŋijowe: ‘Oŋo eja gbaworo ii mono sili bologa mende ama mubu.’ Kaeŋ iŋijoweto, oŋo noonoŋ qaa ii qewagoŋ silemale aŋgi. Mobu, kambaŋ kokaamba iwaa sayaa iroŋanoŋ mono qanananoŋ uro kakasililiŋ mojoŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Kaeŋ amiŋ mogi Joosefnoŋ yoŋowo Iijipt qaanoŋ qaa jero moŋnoŋ meleeno. Kawaajoŋ yoŋonoŋ qaagia jegi saanoŋ moma asariroti, ii daurutanoŋ mende moma kotogi. ");
INSERT INTO ksr_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Joosefnoŋ qaagia moma asariŋ eleema saaro. Saama mombo eleema iŋiima yoŋowo qaa jero. Yoŋowo qaa jeŋgo Simeon batugianoŋga meŋ jero yoŋoo jaagianoŋ somoŋgogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Joosefnoŋ jeŋkooto kokaeŋ ano: “Weleŋqeqe oŋo mono eja iyoŋoo taru gesogianoŋ wiit padi mougi qaa ootanoŋ kouro motomotooŋ yoŋoonoŋ moneŋ esugia ii totogianoŋ aŋa aŋa tarugianoŋ moubu ano kana kekembaa nene samoŋa ii kaaŋiadeeŋ oŋombu.” Kaeŋ jeŋ kotoŋ oŋono iikawaa so otaaŋ aŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Kaeŋ otaaŋ aŋgi wiit padi tarugia ii doŋgi qagianoŋ somoŋgoŋ mesaoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Kema kema gaoŋ ewombaajoŋ miri moŋnoŋ keuma daremuŋ yoŋoonoŋga moŋnoŋ doŋgia wagimambaajoŋ ama taru kasia isama moneŋ esuya ii taru qaa ootanoŋ nene qaganoŋ raro iiro. ");
INSERT INTO ksr_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ii iima daremuŋa kokaeŋ iŋijoro: “Hei! Iibu, noonoŋ moneŋ koi mono meleema tarunanoŋ mougi rajaa.” Kaeŋ moma wosogia juno aaruŋ tililiŋgoŋ aima aoŋ kokaeŋ jegi: “Anutunoŋ koi mono naa iwoiga ama nononja aaŋ?” ");
INSERT INTO ksr_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kema kema Keinan balonoŋ maŋgia Jeikobwaanoŋ keuma iwoi kolooŋ oŋonoti, iikawaa sunduya ii kuuya kokaeŋ ijogi moro: ");
INSERT INTO ksr_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Kantri iikawaa eja poŋa iinoŋ horoŋ ureeŋ qaa molaŋkota jeŋ gomaŋ iimagoosiwaa manjaqeqe ejaga koloowonagati, iikawaa tani kaaŋa ama nonono. ");
INSERT INTO ksr_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","“Kaeŋ ama nononoto, nono ii kokaeŋ ijoniŋ: ‘Nono eja dindiŋa qolomolonana qaa laligoŋ baloŋ iima gosiwombaajoŋ ama mende kajoŋ. Qaago totooŋ! ");
INSERT INTO ksr_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nono eja motooŋgowaa meraurutaga, daremuŋ 12 kolooŋ laligojoŋ. Moŋnoŋ mende toroqeŋ laligoro konana konoganoŋ kambaŋ kokaamba Keinan balonoŋ maŋnanawo mirinoŋ raja.’ ");
INSERT INTO ksr_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Kaeŋ ijoniŋ baloŋ iikawaa eja poŋanoŋ nonoojoŋ qaa kokaeŋ jero: ‘Oŋo eja dindiŋa me qoloŋmoloŋgoya laligojuti, ii kokaeŋ gosiŋ oŋoma momaŋa: Oŋoonoŋga daremuŋgia moŋ ii mono mesaogi niwo koi raro tosaaŋa oŋo saanoŋ wiit padi meŋ eleema kembu. Kema mirigianoŋ kanagesourugia bodi laligojuti, ii nene oŋombu. ");
INSERT INTO ksr_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Oŋo gomaŋ iimagoosiwaa manjaqeqe ejaga qaagoto, eja dindiŋa qolomoloŋgia qaa laligojuti, ii kokaeŋ gosiŋ oŋoma momaŋa: Oŋo mono kema kogia beju ii wama noonoŋ kawu. Kaeŋ kagi daremuŋgia meleema oŋombe saanoŋ baloŋ kokanoŋ aŋguneŋ-qaŋguneŋ ama laligowu.’” ");
INSERT INTO ksr_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Kaeŋ jeŋ taru gesogianoŋga nene kowigianoŋ maagi moneŋ esugia moneŋgiawo ii tarugianoŋ motomotooŋ totogianoŋ raro mokoloogi. Moneŋ esugia mokolooŋ iima ii ano maŋgia motooŋ aaruŋ lalaŋaniŋ toroko mogi. ");
INSERT INTO ksr_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Kaeŋ mogi maŋgia Jeikobnoŋ kokaeŋ iŋijoro: “Oŋo merauruna korebore nuambombaajoŋ moju: Joosefnoŋ mende laligoja. Simeon ananawo mende laligoja. Benjamin ii kaaŋiadeeŋ nuama wama kembombaajoŋ jeju. Siimbobolo kuuya kanoŋ mono noo qananoŋ uja.” ");
INSERT INTO ksr_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Kaeŋ iŋijoro moma Ruubenoŋ maŋa qaa kokaeŋ ijoro: “Nii Benjamin mende wama eleema kaŋ gomaŋati eeŋ, gii saanoŋ neenaa merawoina woi ii uruna komuwao. Benjamin ii saanoŋ noo boronanoŋ ana ii mono galeŋ koma kema laligoŋ wama eleema kaŋ gomaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Kaeŋ ijoroto, Jeikobnoŋ meleema jero: “Merawoina konoga woi iyoroonoŋga datanoŋ komuro koganoŋ motooŋgo laligoja. Oŋo kananoŋ kembombaajoŋ mobuti, iikanoŋ tiwitiwilaa moŋnoŋ iwaa qaganoŋ ubaati eeŋ, oŋo mono kondoogi wosobiri uutanoŋ mono noo qananoŋ uro komuŋ waŋ juna laŋgoŋawonoŋ koomu gomanoŋ kememaŋa. Kawaajoŋ noo merananoŋ mono nomesaoŋ oŋowo mende kembaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Keinan balonoŋ bodi lombotawo ii toroqeŋ ero. ");
INSERT INTO ksr_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Jeikobwaa kanagesourutanoŋ wiit padi Iijipt kantrinoŋa meŋ kagiti, ii kuuya nedaborogi qaono maŋgianoŋ merauruta kokaeŋ iŋijoro: “Oŋo mono mombo eleema kema nenenana tosaaŋa sewaŋa mewu.” ");
INSERT INTO ksr_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Kaeŋ iŋijoro Juudanoŋ kokaeŋ jero: “Eja poŋ iinoŋ kaparaŋ koma nonoo galeŋ meme qaa kotakota kokaeŋ jero: ‘Kogianoŋ oŋowo mende kawaati eeŋ, oŋo mono noo jaasewananoŋ mombo koubombaajoŋ amamaawu.’ ");
INSERT INTO ksr_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kawaajoŋ giinoŋ konana wasina nonowo kawaati eeŋ, nononoŋ saanoŋ gomesaoŋ nenenana sewaŋa mewombaajoŋ kemboŋa. ");
INSERT INTO ksr_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Eja iikanoŋ qaa kokaeŋ ninijoro: ‘Kogianoŋ oŋowo mende kawaati eeŋ, oŋo mono noo jaasewananoŋ mombo koubombaajoŋ amamaawuya.’ Kawaajoŋ giinoŋ Benjamin aŋgoŋ kombagati eeŋ, nono mende kemboŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Juudanoŋ kaeŋ jero Israelnoŋ kokaeŋ jero: “Oŋo mono naambaajoŋ kogia moŋ laligojiwaa qaaya eja ii ijogi morotiwaajoŋ nii uulombo somata nonju?” ");
INSERT INTO ksr_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Kaeŋ jero kokaeŋ meleema jegi: “Eja iikanoŋ anana ano kanagesourunana ananaajoŋ tororo qiqisi kania kania nonoma kokaeŋ ninijoro, ‘Maŋgianoŋ jaawo laligoja me qaago? Daremuŋgia moŋ laligoja me qaago?’ Kaeŋ jerotiwaajoŋ qiqisiya ii nononoŋ oŋanondeeŋ jeŋ meleeniŋ. Iinoŋ kanageŋ konana wama kawutiwaajoŋ jenagati, ii mono walawala kambaŋ kanoŋ nomaeŋ mobonaga?” ");
INSERT INTO ksr_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Kaeŋ jegi Juudanoŋ maŋa Israel kokaeŋ ijoro: “Kawaajoŋ eja gbaworo ii mono noo boronanoŋ ama wasina motooŋ kemboŋa. Kaeŋ ana afaaŋgoŋ uulaŋawo gomesaoŋ kananoŋ keniŋ nono, gii ano embameraurunana anana mende komuŋ gororoŋgowoŋa. ");
INSERT INTO ksr_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Benjamimbaa laaligoyaa doweya iikawaa qaaya mono noo boronoŋ ero eleema kaŋ gomambaajoŋ jeŋ kotiijeŋ. Niinoŋ ii mende wama eleema koi kaŋ goo jaasewaŋganoŋ mende oomaŋati eeŋ, iikawaa iroŋanoŋ mono noo qananoŋ uro goo jaanoŋ bosima laligowe namonoŋ laaligona tegowaa. ");
INSERT INTO ksr_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kambaŋ koriga ezelobezelo ama mende mambombonagati eeŋ, nononoŋ mono endu kema eleema koi kaniŋ ambeŋa woi koloonaga.” ");
INSERT INTO ksr_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Kaeŋ jero amagia Israelnoŋ kokaeŋ jero mogi: “Kaeŋ kolooji eeŋ, oŋo mono kokaeŋ ambu: Gomaŋ kokawaa toomoriaŋa awaa totooŋ tosia koi kaaŋa ii meŋ taru gesogianoŋ mouma kema eja ii kaleŋ mubu: Sele morimoriwaa kelega tosia, moroŋ apuya, daŋe riki, marasiŋ gere tokoya qata mor gipi, komoŋ, gou ano seu wakato iikawaa hoŋgia. ");
INSERT INTO ksr_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Silwa moneŋ walaga taru gesogiaa qaa oogianoŋ mougi meŋ kagiti, ii ano iikawaa so qaganoŋ toroqeŋ ama mindirigi jaŋgoyanoŋ somariiŋ 2:waa so kolooro ii meŋ eleema kema mubu. Tosianoŋ koposo ama ii gesogianoŋ aŋgi me nomaeŋ? ");
INSERT INTO ksr_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Kogia kaaŋagadeeŋ wama uulaŋawo waama eja iikanoŋ mombo eleema keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Anutu ku-usuŋ kuuyaa Toyanoŋ mono eja iikawaa jaanoŋ kiaŋkoomuya oŋono iinoŋ daremuŋgia moŋ ano Benjamin ii oŋowo mirinoŋ koi eleema kawutiwaajoŋ wambelaawaa. Noo meraurunanoŋ komuntiwilaa ambuti eeŋ, niinoŋ mono eeŋ totooŋ laligomaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Kaeŋ iŋijoro kaleŋ iwoi ii meŋ silwa moneŋ meŋ kagiti, iikawaa so qaganoŋ toroqeŋ ama mindirigi jaŋgoyanoŋ somariiŋ 2:waa so kolooro. Ii meŋ Benjamin motooŋ wama waama uulaŋawo Iijipt kema Joosefwaa jaanoŋ keugi. ");
INSERT INTO ksr_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Keugi Joosefnoŋ Benjamin ii yoŋoo batugianoŋ iima iikanondeeŋ miriaa galeŋa kokaeŋ jeŋ kotoŋ muro: “Gii mono eja koi uŋuama neenaa mirinoŋ kema oŋoona rabu. Ragi kema oro moŋ qeŋ ooŋ weembaa neneya mozozoŋgona yoŋonoŋ saanoŋ niwo motooŋ nene newoŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Joosefwaa miriaa galeŋanoŋ jeŋ kotoŋ murotiwaa so eja ii uŋuano Joosefwaa mirianoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Uŋuano Joosefwaa mirianoŋ kema jeneŋgia ororo toroko moma kokaeŋ romoŋgoŋ batugianoŋ jegi: “Wala kaniŋ monenana meleema taru gesonananoŋ mougi meŋ keniŋi, iikawaajoŋ yoŋonoŋ mono nunuama kaŋ koi nonooŋgi rajoŋ. Yoŋonoŋ mono qelanjiŋ nunuŋ ureeŋ haamo ama nonoma nonooŋgi weleŋqeqeuruta omaya kolooniŋ doŋgiurunana kalugoŋ aŋgoŋ koma oŋombubo.” ");
INSERT INTO ksr_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Kaeŋ jeŋ nama Joosefwaa miriwaa galeŋa iwaanoŋ uma keŋgi miri naguyanoŋ nano iwaajoŋ qaa kokaeŋ jegi: ");
INSERT INTO ksr_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Oo somatanana, nono kambaŋ mutuya nene sewaŋa mewombaajoŋ koi kaniŋ. ");
INSERT INTO ksr_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Kaŋ nene sewaŋa meŋ mombo eleema kema kananoŋ miri moŋnoŋ kema ewombaajoŋ rama taru gesonanaa kasia isama monenana totonananoŋ ii kore gesonana aŋa aŋa qaa oogianoŋ nene qaganoŋ raro iiniŋ. Kawaajoŋ moneŋ ii kete mombo meleema meŋ kajoŋ. ");
INSERT INTO ksr_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Silwa moneŋ ii moronoŋ taru gesonananoŋ meleema mombo anoti, ii nono mende mojoŋ. Nononoŋ ii ano silwa moneŋ tosaaŋa ii qaganoŋ torokuuŋ nene sewaŋa mombo mewombaajoŋ gesonananoŋ mouma meŋ kajoŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Kaeŋ jegi miri galeŋanoŋ kokaeŋ jero: “Majakaka mende mobu. Oŋoaŋgiaa ano maŋgiaa Anutugianoŋ mono mombaa uuta kuuro silwa moneŋ ii taru gesogianoŋ mouro mokoloogi. Niinoŋ oŋoonoŋ silwa moneŋ ii medaborowe. Kawaajoŋ keegia mende moma mono uubonjoŋ rabu.” Kaeŋ jeŋ Simeon wama yoŋoonoŋ kari. ");
INSERT INTO ksr_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Kari motooŋ uŋuama Joosefwaa mirinoŋ ugi kanagia soŋgbambutiwaajoŋ apu oŋono ano doŋgigia loloo gbojoja nenegia uŋuagiro. ");
INSERT INTO ksr_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Yoŋonoŋ weembaa neneya Joosefwaa mirinoŋ motooŋ newutiwaa qaaya mogi. Kawaajoŋ Joosefnoŋ weeŋ biiwianoŋ mirianoŋ koubaatiwaajoŋ mamboma kaleŋ iwoigia ii asuganoŋ areŋgoŋ ragi. ");
INSERT INTO ksr_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ragi Joosefnoŋ mirinoŋ karo kaleŋ iwoigia meŋ kaŋ mirianoŋ ugiti, ii muŋ batanoŋ simiŋ kuma namonoŋ usugogi. ");
INSERT INTO ksr_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Usugoŋ waagi joloŋgia iŋijoŋ nomaeŋ laligojuti, qisiŋ oŋoma kokaeŋ iŋijoro: “Maŋgia eja waŋaajoŋ nijogiti, iinoŋ nomaeŋ laligoja? Toroqeŋ jaawo laligoja me qaago?” ");
INSERT INTO ksr_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Kaeŋ jero kokaeŋ meleeŋgi: “Goo weleŋqeqega, nonoo amanananoŋ saanoŋ laligoja. Mono toroqeŋ jaawo laligoja.” Kaeŋ meleema goda qeŋ muŋ simiŋ kuma namonoŋ usugogi. ");
INSERT INTO ksr_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Kaeŋ aŋgi jaaya uuro kema karo koga Benjamin, iyaŋaa nemuŋaa meria ii iima kokaeŋ qisiŋ oŋono: “Kogia konogaajoŋ nijogiti, iinoŋ koi kolooja me nomaeŋ?” Qisiŋ oŋoma toroqeŋ kokaeŋ ijoro: “Merana, Anutunoŋ mono kiaŋkoomu gono laligowa.” ");
INSERT INTO ksr_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Kaeŋ ijoŋ koga iima wosoya pororogoro jaaya kaliliŋgoro saamambaajoŋ moma iikanondeeŋ alanzaŋ eleema oŋomesaoŋ uulaŋawo miri uuta oloŋa moŋnoŋ uma aŋodeeŋ rama saaro. ");
INSERT INTO ksr_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Saadaboroŋ jaauŋa soŋgbama miri uuta oloŋa ii mesaoŋ kaŋ tororo mokosiŋgoŋ nama iyaŋa galeŋ koma aoŋ nembanene kombutiwaajoŋ jero. ");
INSERT INTO ksr_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Iijipt yoŋonoŋ Hibruu ejemba yoŋowo motooŋ nene newombaajoŋ mogi arokuukuuyawo koloojiwaajoŋ ii amamaaŋkeju. Kawaajoŋ Joosefwaa neneya ii iyaŋa koma mugi raro daremuŋuruta yoŋoo ii iyaŋa koma oŋoŋgi ragi Iijipt ejemba iwo nene newombaajoŋ kaŋ ragiti, iyoŋoo nenegia ii iyaŋa koŋgi ragi. ");
INSERT INTO ksr_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Joosefnoŋ jero daremuŋuruta ii koloogitiwaa so areŋgoŋ oŋoŋgi mutuyanoŋ jaaqeqeyanoŋ raro bejugianoŋ konoganoŋ raro Joosefnoŋ jaasewaŋ qeŋ oŋoma raro. Kaeŋ rama iyaŋgia aima kotoŋ aoŋ waliŋgoŋ ragi. ");
INSERT INTO ksr_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Kaeŋ ragi Joosefnoŋ jero iyaŋaa nene duŋnoŋa nene tosaaŋa mendeema meŋ kaŋ koma oŋoŋgi koga Benjamimbaajoŋ ambeŋa 5:waa so toroqeŋ koŋgi nero. Kaeŋ neŋ Joosefwo jejelombaŋ ama afaaŋkota apu kotiga neŋ korisoro qaganoŋ ragi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Kawaa gematanoŋ Joosefnoŋ miriaa galeŋa jeŋ kotoŋ muŋ kokaeŋ jero: “Gii mono eja iyoŋoo taru gesogianoŋ wiit padi ii elaawutiwaa so mouna qaa oogianoŋ koubu. Kaaŋiadeeŋ motomotooŋ yoŋoonoŋ moneŋ esugia ii aŋa aŋa toto qeŋ taru gesogiaa qaa oogianoŋ amba. ");
INSERT INTO ksr_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Kogia konoga iwaa taru gesoyaa qaa ootanoŋ neenaanoŋ qambi silwanoŋ memeta ii mono wiit padiwaa moneŋa meŋ karoti, iikawo amba.” Kaeŋ jeŋ kotoŋ muro iikawaa so ano. ");
INSERT INTO ksr_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Gomaŋ asariro umugawodeeŋ eja ii wasiŋ oŋoŋgi doŋgigia uŋuama kananoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Kema siti mesaoŋ koriganoŋ mende keŋgi Joosefnoŋ miriaa galeŋa kokaeŋ jeŋ kotoŋ muro: “Gii mono uulaŋawo waama eja ii oŋotaaŋ kema mokolooŋ iŋiima kokaeŋ qisiŋ oŋomba: ‘Eja Poŋnoŋ awaa ama oŋono oŋo mono naambaajoŋ iikawaa kitia kilegamoŋ meleema muŋ kaju? ");
INSERT INTO ksr_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Noo somatananoŋ qambia qaaŋ neŋkeji ano qambia iikanoŋ unju qeŋ qaa aasaŋgoyaa kania mokolooŋkeji, oŋo qambi ii mono naambaajoŋ yoŋgoro meŋ kaju? Oŋo mono sili ii bologa totooŋ anju!’” ");
INSERT INTO ksr_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Joosefnoŋ miriaa galeŋa kaeŋ jeŋ kotoŋ muro kema mokolooŋ oŋoma qaaya ii jerotiwaa so ijoro. ");
INSERT INTO ksr_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Iŋijoro moma kokaeŋ meleeŋgi: “Somatanananoŋ qaa tania kaaŋa ii mono naambaajoŋ jeja? Goo weleŋqeqeuruga nononoŋ sili bologa kaaŋa ii mende totooŋ anjoŋ. Ii yamageŋ! ");
INSERT INTO ksr_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Moba, nono taru gesonanaa qaa oogianoŋ silwa moneŋ esu mokolooniŋi, ii kaaŋagadeeŋ Keinan balonoŋa meŋ kaŋ goniŋ. Nono mono naambaajoŋ silwa me goul ii somatagaa mirinoŋga yoŋgoro mewonaga? ");
INSERT INTO ksr_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Weleŋqeqeuruga nonoonoŋga mombaa taru gesoyanoŋ silwa qambi ii mokoloowagati eeŋ, iinoŋ mono koomuwaa buŋaga kolooro tosaaŋa nononoŋ somatanana, goo weleŋqeqe omaya kolooŋ laligowoŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Kaeŋ meleeŋgi kokaeŋ jero: “Iikaaŋa kanoŋ awaa. Jejutiwaa so ii saanoŋ amboŋa. Mombaa taru gesonoŋa silwa qambi ii mokoloomaŋati, iinoŋ mono noo weleŋqeqena omaya koloowaato, tosaaŋa oŋoo selegianoŋ qaa moŋ mende ero saanoŋ oŋoaŋgiodeeŋ mirigianoŋ kembu.” ");
INSERT INTO ksr_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Kaeŋ jero moma kuuyanoŋ gesogia aŋa aŋa uulaŋawo qetegoŋ meŋ kamaaŋ namonoŋ ama qaa oogiaa kasia isaŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Aisŋgi Joosefwaa miriaa galeŋanoŋ dagia mutuyaa taru gesoyanoŋga kanaiŋ qeŋgama moŋgama kema kema ko bejugia Benjamimbaa taru gesoyanoŋ tetegoyanoŋ iima qambi ii iikanoŋ mokolooro. ");
INSERT INTO ksr_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ii mokolooro yoŋonoŋ uugia kouma eligoro wosobirigia qendeema malekugia menjuqenjuraŋgi. Kaeŋ ama esuhinagia doŋgi qagianoŋ ama mombo eleema sitinoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Juuda ano daremuŋuruta yoŋonoŋ eleema Joosefwaa mirinoŋ keŋgi iinoŋ kaaŋiadeeŋ mirianoŋ raro. Raro batanoŋ keuma simiŋ kuma namonoŋ usugogi. ");
INSERT INTO ksr_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Usugogi Joosefnoŋ kokaeŋ iŋijoro: “Oŋo mono naa siliga anjuya? Eja nii kaaŋanoŋ mono saanoŋ unju meŋ iwoi yoŋgoro megi ii mokolooŋkejeŋi, oŋo ii mende moju me?” ");
INSERT INTO ksr_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Kaeŋ jero Juudanoŋ kokaeŋ meleeno: “Oo somatanana, nono mono naa qaaga gijowonaga? Nono qaawaajoŋ moŋganjoŋ. Nononoŋ iwoi bologa mende aniŋi, ii qendeema gomboŋatiwaa so qaago. Anutunoŋ mono weleŋqeqeuruga, nonoo koposowaa qaaya iŋisaanota asuganoŋ eja. Kawaajoŋ mombaa taru gesoyanoŋga qambi ii mokolooji ano tosaaŋa nononoŋ kaaŋagadeeŋ eja poŋnanaa weleŋqeqeuruta omaya kolooŋ laligowoŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Kaeŋ meleenoto, Joosefnoŋ kokaeŋ jero: “Niinoŋ iwoi kaaŋa ii mende ama oŋomaŋa. Ii awawi totooŋ! Eja morowaa taru gesoyanoŋ qambi ii mokolooji, iinondeeŋ mono noo weleŋqeqena kolooŋ laligowaato, tosaaŋa oŋo saanoŋ luaenoŋ eleema maŋgiaanoŋ kembu.” ");
INSERT INTO ksr_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Kaeŋ jero Juudanoŋ Joosefwaa batanoŋ kema qaa kokaeŋ jero: “Oo eja poŋna, saanoŋ wambelaana weleŋqeqega niinoŋ qaa tosia eja poŋna goojoŋ jewenaga. Giinoŋ Faarao kiŋ aŋawo ororoŋ koloojanto, kileŋ weleŋqeqega nii kazi mende ama nomba. ");
INSERT INTO ksr_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Eja poŋna giinoŋ weleŋqeqeuruga nono wala kaniŋ kokaeŋ qisiŋ nonona: ‘Oŋoo maŋgia ano daremuŋgia moŋ laligojao me qaago?’ ");
INSERT INTO ksr_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","“Kaeŋ qisiŋ nonona nononoŋ eja poŋna goojoŋ kokaeŋ meleeniŋ: ‘Nonoo maŋnana eja waŋa kolooŋ konana eja gbaworoga moŋ mirinoŋ rajao. Konana kanoŋ maŋnananoŋ eja waŋa kolooro kambaŋ kanoŋ kolooro. Nemuŋanoŋ mera woi orono datanoŋ komuro aŋodeeŋ laligoja. Iinoŋ mono maŋaa wombo (komunjua) meriaga kolooja.’ ");
INSERT INTO ksr_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Kaeŋ meleeniŋ giinoŋ weleŋqeqeuruga qaa kokaeŋ ninijona, ‘Oŋo mono kogia wama noonoŋ koi kagi ii saanoŋ neenaa jaanoŋ uuŋ iimaŋa.’ ");
INSERT INTO ksr_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","“Kaeŋ ninijona nononoŋ eja poŋnana goojoŋ kokaeŋ meleeniŋ: ‘Eja gbaworo ii maŋa mesaomambaajoŋ amamaawaa. Maŋa mesaonagi eeŋ, maŋanoŋ mono komunaga.’ ");
INSERT INTO ksr_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Kaeŋ meleeninto, giinoŋ weleŋqeqeuruga nonoojoŋ qaa kokaeŋ jeŋ kotona: ‘Kogia konoganoŋ oŋowo koi mende kawaati eeŋ, oŋo mono noo jaasewananoŋ mombo mende asugiwuya.’ ");
INSERT INTO ksr_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Kaeŋ jeŋ kotona mirinananoŋ eleema kema noo maŋna, goo weleŋqeqega eja poŋna goonoŋ qaa ii ijoniŋ. ");
INSERT INTO ksr_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ii ijoniŋ moma maŋnananoŋ kanageŋ kokaeŋ jero: ‘Oŋo mono mombo Iijipt kema ananaajoŋ nene tosaaŋa sewaŋa meŋ kawu.’ ");
INSERT INTO ksr_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","“Kaeŋ jeroto, nono kokaeŋ jeniŋ, ‘Nononoŋ nononanodeeŋ kembombaajoŋ amamaawoŋa. Konana konoganoŋ nonowo motooŋ kembaatiwaajoŋ jewagi eeŋ, mono saanoŋ kemboŋa. Konana bejuya mende wama kemboŋati eeŋ, nononoŋ mono eja poŋ iikawaa jaasewaŋanoŋ asugiwombaajoŋ amamaawoŋa.’ ");
INSERT INTO ksr_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Kaeŋ jeniŋ noo maŋna goo weleŋqeqega iinoŋ kokaeŋ jero: ‘Embana Reizelnoŋ merawoina woi orono. Ii oŋoaŋgia saanoŋ moju. ");
INSERT INTO ksr_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Datanoŋ nomesaoŋ kema sooro kokaeŋ jewe, “Oro kawalianoŋ mono kitoqitoro komuro me nomaeŋ?” Kambaŋ iikanondeeŋ kanaiŋ ii mende iibe. ");
INSERT INTO ksr_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Kete koga koi kaaŋagadeeŋ nuama keŋgi kananoŋ tiwitiwilaa moŋnoŋ iwaa qaganoŋ unagati eeŋ, oŋo mono kondoogi wosobiri uutanoŋ noo qananoŋ uro koŋajiliŋ moma komuŋ waŋ juna laŋgoŋawonoŋ koomu gomanoŋ kememaŋa.’” ");
INSERT INTO ksr_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Juudanoŋ toroqeŋ qaa kokaeŋ jero: “Oo eja poŋnana, niinoŋ konana eja gbaworo ii mende wama kema maŋna, goo weleŋqeqega iwaa mirinoŋ keubenagi eeŋ, amanananoŋ mono tiwilaawabo. Iinoŋ mono uuta kuuya meria bejuya iwaanoŋ somoŋgoro laaligogara motoondeeŋ laligoŋkejao. ");
INSERT INTO ksr_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Kawaajoŋ eja gbaworo ii mende wama keniŋ maŋnananoŋ ii iima mono koomu mokoloowabo. Goo weleŋqeqeuruga nonoonoŋ kaeŋ asugiro nono mono kondooniŋ wosobiri uutanoŋ amanana, goo weleŋqeqega iwaa qaganoŋ uro komuŋ waŋ juya laŋgoŋawonoŋ koomu gomanoŋ kemebaa. ");
INSERT INTO ksr_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Goo weleŋqeqega niinoŋ eja gbaworonoŋ mende tiwilaawaatiwaa qaaya ii maŋnaajoŋ jeŋ somoŋgoŋ kokaeŋ ijowe: ‘Ii mende wama goonoŋ eleema kamaŋati eeŋ, iikawaa qaa lombotanoŋ mono goo jaanoŋ noo qananoŋ uma ero namonoŋ laaligona kaeŋ laligoŋ umaŋa.’ ");
INSERT INTO ksr_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Kawaajoŋ gii saanoŋ jeŋ tegona niinoŋ eja gbaworo iwaa kitianoŋ eja poŋna goo weleŋqeqega omaya kolooŋ koi laligowe iinoŋ dauruta yoŋowo eleema mirigianoŋ kembu. ");
INSERT INTO ksr_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","“Eja gbaworo kanoŋ niwo mende kawaati eeŋ, niinoŋ mono nomaeŋ ama maŋnaanoŋ kembenaga? Wosobiri uutanoŋ maŋnaa qaganoŋ unagati, niinoŋ mono ii iimambaajoŋ togoŋ kotiijeŋ. Kawaajoŋ ii mono mende somoŋgowa.” ");
INSERT INTO ksr_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Juudanoŋ kaeŋ jero ejemba liligoŋ oŋoma nama iŋiigiti, Joosefnoŋ kuuya iyoŋoo jaagianoŋ toroqeŋ kania kolatiŋ aŋa galeŋ koma aomambaajoŋ bimooŋ amamaaro. Kawaajoŋ Joosefnoŋ kokaeŋ silama qaro: “Oŋo mono kore nomesaoŋ deembu.” Kaeŋ qaro deeŋgi Iijipt eja moŋnoŋ kosogianoŋ mende nano Joosefnoŋ iyaŋaa kania ii daremuŋuruta ii kokaeŋ iŋisaano: ");
INSERT INTO ksr_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Iinoŋ amburereŋ meŋ otombeeŋ qama saaro Iijipt ejemba seleeŋgeŋ laligogiti, iyoŋonoŋ ii moma Faarao kimbaa jiŋkaroŋ mirianoŋ kema buzu qaaya ii jegi mogi. ");
INSERT INTO ksr_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Joosefnoŋ saama nama daremuŋuruta ii kokaeŋ iŋijoro: “Nii Joosef! Amananoŋ kaaŋiadeeŋ jaawo laligoja me qaago?” Kaeŋ iŋijoro mogito, daremuŋurutanoŋ uugia kouma gojono aaruŋ tililiŋgoŋ jaayanoŋ eeŋ nama qaa moŋ mende romoŋgoŋ meleema mubombaajoŋ amamaagi. ");
INSERT INTO ksr_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Amamaaŋ naŋgi Joosefnoŋ kokaeŋ iŋijoro: “Oŋo mono noo kosonanoŋ koi kawu.” Kaeŋ iŋijoro kagi kokaeŋ iŋijoro: “Nii Joosef, oŋoo daremuŋgia sewana mewutiwaajoŋ aŋgi Iijipt kaweti, ii mono niinoŋ. ");
INSERT INTO ksr_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","“Mono uunoŋ koŋajiliŋ mende mobu. Anutunoŋ oŋo komuwubotiwaajoŋ nii wala wasiŋ nono walawala koi kaweta oŋonoŋ kaju. Nii sewana mewutiwaajoŋ ama noŋgi koi kaweti, iikawaajoŋ mono oŋoaŋgiaajoŋ iriŋsooŋsooŋ mende moma aowu. ");
INSERT INTO ksr_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Bodi koi kanoŋ mono yambu woiwaa so namo sokoma eja. Ii toroqeŋ mombo yambu 5:waa so ewaa. Kambaŋ iikawaa uutanoŋ baloŋ qeŋ koomo mende ama nene hoŋa mende mokolooŋ meŋ kululuuŋ laligowoŋa. ");
INSERT INTO ksr_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","“Anutunoŋ mono kana damubiribiriawo otaaŋ oŋoo laaligogiaa sewaŋa somoŋgoro toroqeŋ jaawo laligoŋ gbili mokolooŋ oŋoma namo qaganoŋ laligowutiwaajoŋ moja. Kawaajoŋ ama nii wala wasiŋ nono walawala koi kaweta oŋo kaju. ");
INSERT INTO ksr_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Kawaajoŋ oŋonoŋ mende wasiŋ noŋgi tanitani koloojato, Anutunoŋ mono oŋanoŋ wasiŋ nono koi kawe. Iinoŋ kuuŋ nono Faarao kimbaa jawiŋa mutuya kolooŋ jiŋkaroŋ mirianoŋ naa gawoŋ meŋkejuti, kuuya iyoŋoo somatagiaga koloojeŋ. Kaeŋ koloowe Anutunoŋ Iijipt kantri kuuya koi ii noo boronanoŋ anota eja poŋgiaga koloojeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Oŋo mono kete koi waama uulaŋawo amanaanoŋ eleema kema qaa kokaeŋ jegi mobaa: ‘Goo meraga Joosefnoŋ qaa kokaeŋ jeja: Anutunoŋ nii kuuŋ noma Iijipt kantri kuuya ii noo boronoŋ anota eja poŋgiaga koloojeŋ. Kawaajoŋ giinoŋ mono kambaŋ mende qeŋ koriwato, uulaŋawo noonoŋ kawa. ");
INSERT INTO ksr_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Koi kaŋ saanoŋ rara dunduŋga Goosen balonoŋ meagoŋ neenaa kosonanoŋ laligowaga. Gii ano esameraaŋuruga, goonoŋ lama bulmakao tuuŋa tuuŋa ano ilawoila kuuya buŋaga eji, ii mono meŋ kololooŋ kawu. ");
INSERT INTO ksr_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","“Bodi koi kanoŋ mono mombo toroqeŋ yambu 5:waa so eŋ ubaa. Kambaŋ iikawaa uutanoŋ gii, mirigaa sumaŋuruga me tinitosauruga tosaaŋa yoŋoonoŋga moŋnoŋ bodi laligoŋ nenewaa mojoqojoroŋ ama komuŋ gororoŋgowabo. Kawaajoŋ mono Goosen balonoŋ kaŋ laligoŋ naa iwoiwaajoŋ amamaawuti, niinoŋ ii oŋoma laligomaŋa.’ Amananaajoŋ qaa ii mono kaeŋ jegi mobaa. ");
INSERT INTO ksr_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Nii neeno oŋanoŋ koi nama oŋoojoŋ qaa jejeŋi, ii saanoŋ oŋoaŋgiaa jaagianoŋ niima kotoju ano kona Benjamin aŋo kaaŋagadeeŋ niima kotoja. ");
INSERT INTO ksr_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Kawaajoŋ oŋo mono maŋnaanoŋ kema Iijipt kantrinoŋ qabuŋa somata kuuya noŋgita laligojeŋi ano iwoi kuuya iigiti, iikawaa sunduya ii amana jegi mobaa. Ii moro mono uulaŋawo wama kamaaŋ koi kawu.” ");
INSERT INTO ksr_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Kaeŋ iŋijoŋ boria koga Benjamimbaa aroyanoŋ giliro kemero saaro Benjaminoŋ kaaŋiadeeŋ aŋgoŋ muŋ saaro. ");
INSERT INTO ksr_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Toroqeŋ boria dauruta kuuya yoŋoo arogianoŋ giliro kemero saama buugia kitoŋ nero. Iikawaa gematanoŋ daremuŋurutanoŋ iwo qaa amiŋ mogi. ");
INSERT INTO ksr_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Joosefwaa daremuŋurutanoŋ kagiti, iikawaa buzuyanoŋ Faarao kimbaa jiŋkaroŋ mirinoŋ keno Faarao kiŋ ano jawiŋuruta kuuya yoŋonoŋ ii moma keraqeeaŋgo mogi. ");
INSERT INTO ksr_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Kaeŋ moma Faarao kiŋnoŋ Joosef kokaeŋ ijoro: “Daremuŋuruga mono jena kokaeŋ ambu: ‘Esuhinagia mono doŋgi qagianoŋ ama mombo eleema gomaŋgianoŋ Keinan balonoŋ kembu. ");
INSERT INTO ksr_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Kema maŋgia ano sumaŋurugia uŋuama eleema noonoŋ kawu. Koi kagi niinoŋ baloŋ awaa totooŋ Iijipt kantri uutanoŋga meweeŋgoŋ oŋombe saanoŋ iikawaa kelega mokolooŋ neŋ korisoro ama laligowuya.’ ");
INSERT INTO ksr_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Kaaŋagadeeŋ kokaeŋ jeŋ kotoŋ oŋona ambu: ‘Iijipt kokanoŋga mono hooswaa kareya kareya tosia meŋ kema embameraurugia iikanoŋ oŋooma maŋgia wama motooŋ koi kawu. ");
INSERT INTO ksr_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Mirigiaa iwoiya tosia Keinan balonoŋ mesaowuti, iikawaa majakakaya mende ambu. Niinoŋ iikawaa kitianoŋ Iijipt kantri kuuya kokawaa iwoiya awaa totooŋ ii oŋombe buŋagia koloowaa.’” ");
INSERT INTO ksr_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Faarao kiŋnoŋ kaeŋ jero Israelwaa meraurutanoŋ iikawaa so otaaŋ aŋgi. Joosefnoŋ Faarao kimbaa jeŋkooto qaaya otaaŋ hooswaa kareya tosia oŋono. Kaaŋagadeeŋ kana kekembaa nene samoŋ tosaaŋa oŋono. ");
INSERT INTO ksr_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ii oŋomago dauruta motomotooŋ yoŋoo opo malekugia dologa totogianoŋ oŋonoto, koga Benjamimbaajoŋ opo maleku dologa boro moŋ (faiw) muŋ moneŋ silwa kota 300 muro. ");
INSERT INTO ksr_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Maŋaajoŋ Iijipt kantriwaa iwoi awaa soroya jaasooŋgo meŋ doŋgi ten yoŋoo qagianoŋ ano keŋgi. Kaaŋiadeeŋ doŋgi embia ten yoŋoo qagianoŋ wiit dumuŋ kota, bered ano nene tosia maŋaa kana samoŋa ano bosima keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Keŋgi Joosefnoŋ daremuŋuruta wasiŋ oŋono kembombaajoŋ aŋgi qaa kokaeŋ iŋijoro: “Oŋo kananoŋ kema aŋgowowo mono mende ambu.” ");
INSERT INTO ksr_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Kaeŋ iŋijoro Iijipt mesaoŋ kema Keinan balonoŋ maŋgia Jeikobwaanoŋ keugi. ");
INSERT INTO ksr_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Keuma maŋgia qaa sundu kokaeŋ ijogi: “Joosefnoŋ toroqeŋ jaawo laligoja. Iijipt kantri kuuya ii iwaa borianoŋ ero eja poŋgiaga kolooŋ laligoja.” Kaeŋ ijogi qaa ii mende moma laarirotiwaajoŋ uuta toroqeŋ olomooro raro. ");
INSERT INTO ksr_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Kaeŋ raroto, Joosefnoŋ qaa kuuya jeroti, ii jegi moro ano hooswaa kare tosia ii wama Iijipt kembaatiwaajoŋ ano karoti, maŋgia Jeikobnoŋ ii iima nama uu selianoŋ qeleeno geregere ano. ");
INSERT INTO ksr_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Geregere ama kokaeŋ jero: “Oo, ii oŋanoŋ! Ii moma kotiijeŋ. Merana Joosefnoŋ mono toroqeŋ jaawo laligoja. Niinoŋ mono kema ii iimago kanageŋ saanoŋ komumaŋa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israelnoŋ esuhina iwoiya kuuya kopepereeŋ meŋ waama keno. Kema Beerseba gomanoŋ keuma nama kanoŋ maŋa Aisakwaa Poŋ Anutuyaajoŋ siimoloŋ ooro. ");
INSERT INTO ksr_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ii ooŋ gomantiiŋa ero jaaya meleeno uŋa iima iikanoŋ Anutunoŋ Israel qaa ijoŋ qata “Jeikob, Jeikob!” qaro “Nii koi,” jeŋ meleeno. ");
INSERT INTO ksr_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Meleeno kokaeŋ ijoro: “Nii Anutu, goo maŋgaa beŋsakoŋa. Gii Iijipt kememambaajoŋ toroko mende moba. Niinoŋ iikanoŋ kotuegoŋ gombe kanagesoga tuuŋlelembe somata koloowuya. ");
INSERT INTO ksr_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Niinoŋ giwo Iijipt kememaŋa ano kaaŋagadeeŋ gbiliuruga iikanoŋa uŋuambe mombo eleema koi kawuya. Giinoŋ komuna Joosef iyaŋaa borianoŋ mono goo jaa juga kuno kamaawaa.” ");
INSERT INTO ksr_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Kawaa gematanoŋ Jeikobnoŋ Beerseba gomaŋ mesaowoŋa jero Israelwaa meraurutanoŋ maŋgia ano embameraurugia ii kojojooŋ oŋoŋgi hoos karenoŋ ugi. Faarao kiŋnoŋ hoos kare iikanoŋ uŋuama kawutiwaajoŋ jeŋ tegoŋ anota meŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Esuhinagia ano miri orogia kuuya Keinan balonoŋ laligoŋ buŋa qeŋ meŋ laligogiti, ii kaaŋiadeeŋ motooŋ meŋ keŋgi. Jeikob ano gbiliuruta kuuya yoŋonoŋ kaeŋ Iijipt keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Gbiliuruta kuuya, esameraaŋuruta eja ano emba ii kuuya uŋuama Iijipt keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Israel qata moŋ Jeikob ano iwaa gbiliuruta Iijipt keŋgiti, iyoŋoo qagia ii kokaeŋ: Jeikobwaa meria mutuya Ruuben. ");
INSERT INTO ksr_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruubembaa merauruta qagia Hanok, Palu, Hezron ano Karmi. ");
INSERT INTO ksr_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeombaa merauruta qagia Jemuel, Jamin, Ohad, Jakin, Zohar ano Saul. Saulwaa nemuŋa ii Keinan emba moŋ. ");
INSERT INTO ksr_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Liwaiwaa merauruta qagia Gerson, Kohat ano Merari. ");
INSERT INTO ksr_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Juudawaa merauruta qagia Er, Onan, Sela, Perez ano Zera. (Er ano Oonan yoronoŋ Keinan balonoŋ komuri.) Perezwaa merawoita ii Hezron ano Eer. ");
INSERT INTO ksr_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Aiskarwaa merauruta qagia Tola, Puwa, Jasub ano Simron. ");
INSERT INTO ksr_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulumbaa merauruta qagia Sered, Elon ano Jalel. ");
INSERT INTO ksr_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Jeikobwaa merauruta embia Leanoŋ Mesopotemia (Padan Aram) balonoŋ oŋonoti, iyoŋoo qagia kiaŋ. Boragara Daina ii kaaŋagadeeŋ mero. Jeikob ano Lea yoroo esameraaŋurugara ii kaeŋ weeŋgoŋ mindirigi 33 kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gadwaa merauruta qagia Zefon, Hagi, Suni, Ezbon, Eeri, Arodi ano Areli. ");
INSERT INTO ksr_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aserwaa merauruta qagia Imna, Iswa, Iswi ano Beria. Naaŋgiaa qata Sera. Beriawaa merawoita qagara ii Heber ano Malkiel. ");
INSERT INTO ksr_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Labanoŋ emba qata Zilpa borata Leawaa weleŋ embaga laligowaawaajoŋ muroti, iinoŋ Jeikobwaa merauruta kaeŋ oŋono. Jeikob ano Zilpa yoroo esameraaŋurugara ii kaeŋ weeŋgoŋ mindirigi 16 kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Jeikobwaa embia Reizelwaa merawoita ii Joosef ano Benjamin. ");
INSERT INTO ksr_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Joosefwaa merawoita Iijipt kantrinoŋ kolooriti, ii qagara Manase ano Efraim. Nemuŋgaraa qata Asenat ii Heliopolis (On) taombaa jigo gawoŋ galeŋ qata Potifera iwaa borataga. ");
INSERT INTO ksr_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamimbaa merauruta qagia Bela, Beker, Asbel, Geera, Naaman, Eehi, Ros, Mupim, Hupim ano Ard. ");
INSERT INTO ksr_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Jeikobwaa merawoita Reizelnoŋ oronoti, iyoroo qagara kiaŋ. Jeikob ano Reizel yoroo esameraaŋurugara kaeŋ weeŋgoŋ mindirigi korebore 14 kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dambaa meria qata Husim. ");
INSERT INTO ksr_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftaliwaa merauruta qagia Jaziel, Guni, Jezer ano Silem. ");
INSERT INTO ksr_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Labanoŋ emba qata Bilha borata Reizelwaa weleŋ embaga laligowaatiwaajoŋ muroti, iinoŋ Jeikobwaa merauruta kaeŋ oŋono. Jeikob ano Bilha yoroo esameraaŋurugara ii kaeŋ weeŋgoŋ mindirigi korebore 7 kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Jeikobwaa esameraaŋuruta dindiŋa tooŋ iwo Iijipt keŋgiti, iyoŋoo jaŋgogia weeŋgoŋ mindirigi korebore kanatuuru 66 koloogi. Meraaŋuruta yoŋoo embagia ii jaŋgo iikanoŋ mende toroqegi. ");
INSERT INTO ksr_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Joosefwaa merawoita Iijipt kantrinoŋ kolooriti, ii woi. Jeikobwaa kanatuuruuruta Iijipt keŋgiti, iyoŋoo jaŋgogia ii kaeŋ weeŋgoŋ mindirigi 70 kolooro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Kananoŋ kema laligoŋ Jeikobnoŋ Juuda wala wasiŋ kokaeŋ ijoro: “Gii mono Joosefwaanoŋ kema Goosen balonoŋ kekembaa kaniaajoŋ qisiŋ muba.” Kaeŋ ijoro kema karo Goosen prowinsnoŋ keugi. ");
INSERT INTO ksr_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Joosefnoŋ keugitiwaa buzuya moma jero hoos karenoŋ somoŋgoŋ mozozoŋgogi qaganoŋ uma maŋa Israelwo aitoŋgowowaajoŋ Goosen balonoŋ keno. Kema iima iwaa jaanoŋ keuma boria aroyanoŋ giliro kemero aŋgoŋ muŋ kambaŋ koriga qaqateteya meŋ urusaaŋ qero. ");
INSERT INTO ksr_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israelnoŋ Joosef kokaeŋ ijoro: “Giinoŋ toroqeŋ jaawo laligojaŋi, ii neeno giijeŋa kambaŋ kokaamba saanoŋ jojoriŋ komumaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Kaeŋ ijoro Joosefnoŋ daremuŋuruta ano maŋaa kanagesoya kokaeŋ iŋijoro mogi: “Niinoŋ mono Faarao kimbaanoŋ uma qaa kokaeŋ ijomaŋa: ‘Daremuŋuruna ano maŋnaa kanagesoya Keinan balonoŋ laligogiti, iyoŋonoŋ mono noonoŋ kajuya. ");
INSERT INTO ksr_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Daremuŋuruna yoŋonoŋ lama bulmakao galeŋgia kolooŋ ii galeŋ koma oŋoma laligojutiwaa kawombaajoŋ ama lama tuuŋgia, bulmakao tuuŋgia ano esuhina ilawoilagia kuuya ii uŋuama kajuya.’ ");
INSERT INTO ksr_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Kawaajoŋ Faarao kiŋnoŋ oŋoono jaasewaŋanoŋ keugi kokaeŋ qisiŋ oŋombaa: ‘Oŋo naa gawoŋga meŋkeju?’ ");
INSERT INTO ksr_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","“Kaeŋ qisiŋ oŋono oŋo kokaeŋ meleema mubu: ‘Weleŋqeqeuruga nononoŋ mono au asaurunana wala meŋ laligogitiwaa so meraanananoŋga lama bulmakao galeŋkoŋkoŋ gawoŋa meŋ laligoŋ kouma laligojoŋ.’ Kaeŋ meleema mugi iinoŋ saanoŋ Goosen prowinsnoŋ rara dunduŋgia meagowutiwaajoŋ “Ooŋ!” jero laligowuya. Iijipt ejemba yoŋonoŋ lama bulmakao galeŋ koŋkoŋ ejemba kuuya yoŋoojoŋ mogi arokuukuugiawo kolooŋkeju.” Joosefnoŋ qaaya kaeŋ iŋijoro. ");
INSERT INTO ksr_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Joosefnoŋ kema Faarao kiŋ kokaeŋ ijoro: “Noo maŋ daremuŋuruna yoŋonoŋ lama bulmakao tuuŋgia ano esuhina ilawoilagia kuuya meŋ Keinan baloŋ mesaoŋ kaŋ kaŋ kete koi Goosen balonoŋ kouma laligoju.” ");
INSERT INTO ksr_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Iinoŋ daremuŋuruta yoŋoonoŋga eja 5 uŋuama Faarao kimbaa jaanoŋ uma naŋgi iŋiiro. ");
INSERT INTO ksr_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Iŋiima kokaeŋ qisiŋ oŋono: “Oŋo naa gawoŋga meŋkeju?” Kaeŋ qisiŋ oŋono kokaeŋ meleema ijogi: “Weleŋqeqeuruga nono maŋurunananoŋ wala laligogitiwaa so lama bulmakao galeŋkoŋkoŋ gawoŋa meŋ laligoŋ kouma laligojoŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Kaeŋ ijoŋ toroqeŋ kokaeŋ jegi: “Keinan balonoŋ bodi lombotawo ejiwaajoŋ weleŋqeqeuruga nono lama bulmakao tuuŋnana yoŋoojoŋ nene mende mokolooniŋ. Kawaajoŋ nono baloŋ kokanoŋ tatawaga laligowombaajoŋ kajoŋ. Kaeŋ kolooro weleŋqeqeuruga saanoŋ ‘Ooŋ!’ jeŋgo jeŋ tegoŋ nonona nono Goosen prowins kanoŋ rara dundunana meagowoŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Kaeŋ jegi Faarao kiŋnoŋ Joosef kokaeŋ ijoro: “Maŋ daremuŋuruganoŋ goonoŋ kaju. ");
INSERT INTO ksr_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Iijipt kantri koi asuganoŋ goo jaanoŋ ejiwaajoŋ saanoŋ maŋ daremuŋuruga baloŋ bakaya kelega awaa iikanoŋ oŋoona laligowu. Saanoŋ Goosen prowinsnoŋ laligowu. Batugianoŋ gawoŋ awaa soro meme eja tosaaŋa laligojuti, ii moma oŋombagati eeŋ, saanoŋ noo miriwaa oro tuuŋna ii iyoŋoo borogianoŋ ama oŋona galeŋ koma oŋoma laligowu.” ");
INSERT INTO ksr_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Kaeŋ ijoro Joosefnoŋ maŋa Jeikob Faarao kimbaa jaanoŋ wama karo iiro Faarao kiŋ ii kotuegoŋ muro. ");
INSERT INTO ksr_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Kotuegoŋ muro kokaeŋ qisiŋ muro: “Goo yambuga dawi kolooja?” ");
INSERT INTO ksr_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Qisiŋ muro kokaeŋ meleeno: “Noo yambuna 130:waa so namonoŋ liligoŋ laligoŋ kouma laligojeŋ. Noo laaligonaa yambuya kuuya ii afaaŋgoya ano osiqosigiawo kolooro. Maŋurunanoŋ yambu seiseiya namonoŋ liligoŋ laligogiti, noo yambu jaŋgonanoŋ yoŋoonoŋ kawo so motooŋgo mende kolooja.” ");
INSERT INTO ksr_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Kaeŋ jeŋ Faarao kiŋ ii mombo kotuegoŋ muŋ jaasewaŋanoŋga kamaaŋ keno. ");
INSERT INTO ksr_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Joosefnoŋ maŋ daremuŋa ii Faarao kiŋnoŋ jeŋ kotorotiwaa so Iijipt kantrinoŋ oŋoma Iijiptwaa baloŋ bakaya kelega awaa moŋ ii Rameses prowins (Goosen) kanoŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Joosefnoŋ kaaŋagadeeŋ maŋ daremuŋuruta ano maŋaa kanagesouruta kuuya ii nenegia embameraurugia laligogiti, jaŋgogiaa so sogianoŋ oŋoma laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Bodi somata ii lombotawo ero nenenoŋ baloŋ so qaono Iijipt ano Keinan kantri iyoroo kanagesogaranoŋ mono nenewaa komuŋ jambedeŋgoŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Kaeŋ laligoŋ Joosefwaanoŋ kaŋ wiit dumuŋ kota sewaŋa megi iinoŋ moneŋ kuuya Iijipt ano Keinan kantri uutanoŋ eroti, ii meŋ kululuuŋ Faarao kimbaa jiŋkaroŋ miriwaa kowianoŋ ano. ");
INSERT INTO ksr_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Iijipt kanageso ano Keinan kanageso yoŋoonoŋ moneŋ qaondabororo Iijipt kuuya yoŋonoŋ Joosefwaanoŋ kaŋ kokaeŋ ijogi: “Monenananoŋ qaondaborojiwaajoŋ giinoŋ mono nene nonomba. Nene mende nonombagati eeŋ, nono goo jaasewaŋganoŋ komuwoŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Kaeŋ ijogi Joosefnoŋ kokaeŋ jero: “Moneŋgianoŋ qaonjiwaajoŋ oŋoonoŋ lama ano bulmakao ejuti, ii mono meŋ kaŋ noŋgi niinoŋ nene oŋomaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Kaeŋ jero kema lama bulmakaogia uŋuama kaŋ Joosef mugi. Yoŋonoŋ hoosgia, lamagia, memegia, bulmakaogia ano doŋgigia ii uŋuama kaŋ nenewaa sewaŋaga Joosef muŋ nene meŋ laligogi. Lama bulmakaogia kuuya ii Joosef mugi iinoŋ nene oŋoma iikaaŋa kanoŋ yambu motooŋgowaa uutanoŋ laaligogia naŋgoro mende komugi. ");
INSERT INTO ksr_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mende komugi yambu kanoŋ tegoro. Tegoro yambu gbilianoŋ duŋanoŋ mombo iwaanoŋ kaŋ kokaeŋ jegi: “Eja poŋnana, monenana qaonjiwaajoŋ kanianana hoŋa ii goo jaaganoŋ saanoŋ mende kolatiwoŋa. Nonoonoŋ lama bulmakaonana ii kaaŋagadeeŋ goniŋ goo buŋaga koloodaboroja. Nono ii kuuya eja poŋnana gii gondaboroniŋiwaajoŋ nononana ano balonana iikayadeeŋ eŋ nononja. Kawaajoŋ mono naa iwoi moŋ gombonaga? ");
INSERT INTO ksr_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nono mono kania naambaajoŋ goo jaanoŋ tondu komuwonaga? Nono komuniŋ balonananoŋ mono naambaajoŋ eeŋ eŋ gbaŋgbarasiŋ bolinaga? Kawaajoŋ mono nononana ano balonana sewanana meŋ iikanoŋ nembanene nonona nono saanoŋ Faarao kimbaa weleŋqeqe omaya kolooniŋ balonananoŋ kaaŋagadeeŋ iwaa buŋaga koloowaa. Nono toroqeŋ jaawo laligoŋ komuwombotiwaajoŋ mono nene kota nonomba. Nonona baloŋ gawoŋ muniŋ eeŋ mende eŋ qanda kotiga koloowaa.” ");
INSERT INTO ksr_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Bodi kotiga totooŋ iikanoŋ Iijipt kanatuuru yoŋowo erotiwaajoŋ yoŋonoŋ kuuya motomotooŋ gawoŋ baloŋgia koria ii sewaŋaajoŋ aŋgi Joosefnoŋ Iijipt baloŋ kuuya ii sewaŋa mero Faarao kimbaa buŋaga koloodabororo. ");
INSERT INTO ksr_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Joosefnoŋ Iijipt kanatuuru gomaŋ so kantriwaa jawo tetegoya uutanoŋ laligogiti, ii kuuya uŋuano gawmambaa weleŋqeqe omaya kolooŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Faarao kiŋnoŋ jigo gawoŋ galeŋ yoŋoo footnait tawagia oŋono meŋ iikanoŋ laaligogia naŋgoŋ laligogi. Kaeŋ kolooro nenegiaajoŋ mende bimooro baloŋgia Joosefnoŋ sewaŋa mewaatiwaajoŋ mende aŋgi. Kawaajoŋ jigo gawoŋ galeŋ yoŋoonoŋ baloŋ iikanoŋ motooŋgo kiŋ Faaraowaa buŋa mende koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Joosefnoŋ kanageso kokaeŋ iŋijoro: “Mobu, niinoŋ oŋoaŋgia ano baloŋgia sewaŋgia mewe tegoro Faarao kimbaa buŋaga kolooja. Kawaajoŋ niinoŋ nene kota oŋombe ii saanoŋ meŋ namonoŋ komowu. ");
INSERT INTO ksr_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Komogi hoŋa kolooro ii mono gosigi tuuŋ 5 koloogi kanoŋga motomotooŋ ii Faarao kimbaajoŋ ama muŋ laligowuto, tuuŋ 4 ii mombo namonoŋ komowutiwaajoŋ ano nenegiaajoŋ ewaa. Ii oŋoaŋgia, embameraurugia ano tosaaŋa mirigianoŋ laligojuti, mono oŋoo nenega ewaa.” ");
INSERT INTO ksr_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Kaeŋ iŋijoro kokaeŋ jegi: “Giinoŋ nonoo laaligonana bodinoŋga metogona. Kawaajoŋ eja poŋnanaa jaanoŋ kiaŋkoomu mokoloowoŋati eeŋ, nono saanoŋ Faarao kimbaa weleŋqeqe omaya kolooŋ laligowoŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Joosefnoŋ Iijipt yoŋoo balombaajoŋ jeŋkooto ano eŋ waama koi oojeŋi, kambaŋ kokaamba kaaŋagadeeŋ toroqeŋ eja. Jeŋkooto ii kokaeŋ: Nene gawombaa hoŋgia ii mono mendeeŋgi tuuŋ 5 kolooro iikanoŋa motomotooŋ ii Faarao kimbaa buŋaga koloowaatiwaajoŋ ama laligowu. Jigo gawoŋ galeŋ yoŋoonoŋ baloŋ iikanoŋ motooŋgo Faarao kimbaa buŋa mende koloogi. ");
INSERT INTO ksr_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israel yoŋonoŋ Iijipt balombaa prowins qata Goosen kanoŋ rara dunduŋgia meŋ baloŋ aŋgoŋ koma laligogi. Kanoŋ laligoŋ kolooŋ seisei aŋgi jaŋgogianoŋ mamaga somariiro. ");
INSERT INTO ksr_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jeikobnoŋ laaligoya yambu 17 ii Iijipt balonoŋ laligoro. Laaligoya kuuyaa yambuya ii mindiriŋ 147 kolooro. ");
INSERT INTO ksr_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Israelwaa koomu kambaŋanoŋ dodowiro meria Joosef jero karo kokaeŋ ijoro: “Niinoŋ goo jaanoŋ kewooŋgo mokoloojeŋi eeŋ, giinoŋ mono keteda koi uukaleŋ qendeema qaa kokaeŋ pondaŋ otaaŋ meŋ yagomambaajoŋ jeŋ boroga noo tawonaa baatanoŋ ama kokaeŋ jeŋ somoŋgowa: Niinoŋ komuwe qamona ii Iijipt baloŋ kokanoŋ mende roŋ komba. ");
INSERT INTO ksr_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Niinoŋ komuŋ maŋ asaaŋuruna yoŋowo haamo meŋ emaŋati, kambaŋ iikanoŋ noo qamona ii mono Iijipt kantrinoŋa meŋ kema maŋ asaana roŋ koma oŋoŋgiti, iyoŋoo qasirigianoŋ osoŋ roŋ komba.” Kaeŋ jero kokaeŋ ijoro: “Jejaŋiwaa so ii saanoŋ otaaŋ amaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Kaeŋ ijoro maŋanoŋ kokaeŋ jero: “Qaa ii mono jojopaŋ qaanoŋ jeŋ kotiiŋ nomba.” Kaeŋ jero Joosefnoŋ ii jojopaŋ qaanoŋ jeŋ kotiiro Jeikobnoŋ ii moma ligoŋ waŋa meŋ kemeŋ gbaruyaa kitianoŋ ama laariŋ Anutuwaa waeya meŋ mepeseero. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Kambaŋ tosia tegoro Jeikobnoŋ ji mokolooro qaa ii Joosef ijogi moro. Ii moma merawoita woi Manase ano Efraim ii uruama maŋaanoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Keno tosianoŋ Jeikob kokaeŋ ijogi, “Meraga Joosefnoŋ giimambaajoŋ kaja.” Israelnoŋ qaa ii moma ku-usuŋa eroti, ii kululuuŋ ee duŋayanoŋa waama raro. ");
INSERT INTO ksr_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Waama rama Joosef kokaeŋ ijoro: “Anutu ku-usuŋ kuuyaa Toya iinoŋ Keinan balombaa Luz gomaŋ kanoŋ noonoŋ asugiŋ kotuegoŋ nono. ");
INSERT INTO ksr_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ii noma kokaeŋ nijoro: ‘Niinoŋ kolooŋseisei gombe gbiliuruga yoŋoo jaŋgogianoŋ mono somariiŋ somariiŋ uro giinoŋ kanageso tuuŋa tuuŋa mamaga yoŋoo bemunjalegiaga koloowaga. Gbiliuruga kanageŋ kolooŋ ubuti, niinoŋ baloŋ koi ii buŋa qeŋ oŋombe iyoŋoo buŋagiaga tetegoya qaa eŋ ubaa.’ ");
INSERT INTO ksr_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Anutunoŋ kaeŋ nijoro. Wala nii Iijipt balonoŋ goonoŋ mende kaweti, kambaŋ iikanoŋ embaganoŋ merawoiga woi Iijipt kokanoŋ oronoti, iyoronoŋ mono noo buŋa koloowao. Manase ano Efraim yoronoŋ mono Ruuben ano Simeon kaaŋa noo buŋa koloowao. ");
INSERT INTO ksr_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Kaeŋ koloori kanageŋ baloŋ mosoma yoroojoŋ distrik woi orombu. Efraim ano Manase yoroo bagaranoŋ meraborauruga tosaaŋa koloogiti, iyoŋonoŋ mono geeŋgaa buŋaga koloowuya. Yoŋonoŋ baloŋ bakaya buŋa qeŋ aowuti, ii mono Efraim ano Manase yoroonoŋ distrik woi iikawaa uutanoŋ egi yoronoŋ waŋgia koloori dawoigara yoroo newo baogaranoŋ laligowuya. ");
INSERT INTO ksr_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Niinoŋ Mesopotemia (Padan Aram) mesaoŋ eleema Keinan balonoŋ kaŋ Efrata taoŋ dodowiwe embana Reizelnoŋ komuro wosobiri somata kolooŋ nono. Komuro qamoya ii Efrat kekembaa kana goraayanoŋ roŋ kombe. Efrat gomambaa qata moŋ ii Betlehem.” ");
INSERT INTO ksr_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israelnoŋ kaeŋ jeŋ Joosefwaa merawoita iriima kokaeŋ qisiŋ muro: “Mera woi koi ii moronoŋ moronoŋ?” ");
INSERT INTO ksr_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Qisiŋ muro Joosefnoŋ maŋa kokaeŋ ijoro: “Noo merawoina Anutunoŋ Iijipt kokanoŋ nonoti, mono ii.” Kaeŋ ijoro Israelnoŋ jero: “Niinoŋ kotuegoŋ oromambaajoŋ ii saanoŋ uruana noo kosonanoŋ kawao.” ");
INSERT INTO ksr_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Kaeŋ ijoro Joosefnoŋ merawoita uruama kosianoŋ kagi boria giliro arogaranoŋ kemero buugara kitoŋ nero. Israelnoŋ eja waŋa kolooro jaaya umuŋ kono iwoi moŋ iima kotomambaajoŋ haŋqaŋ qeŋ amamaaro. ");
INSERT INTO ksr_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Buugara kitoŋ neŋ Joosef kokaeŋ ijoro: “Niinoŋ wala goo jaasewaŋga mombo giimambaajoŋ mende mamboma laligoweto, Anutunoŋ kana meleuro kete koi geeŋga ano merawoiga kaaŋagadeeŋ iŋiijeŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Kaeŋ ijoro Joosefnoŋ merawoita maŋaa tawoyanoŋga uruama simiŋ kuma usugoŋ kemero. ");
INSERT INTO ksr_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Usugoŋ kemeŋ waama merawoita borogaranoŋ meŋ uruano aŋaa maŋaa batanoŋ kari. Efraim ii boria dindiŋanoŋ meŋ Israelwaa boria qanianoŋ ama Manase ii boria qanianoŋ meŋ Israelwaa boria dindiŋanoŋ ano. ");
INSERT INTO ksr_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Kaeŋ ama oronoto, Efraim koga kolooro asianoŋ kileŋ boria dindiŋanoŋ boraama iwaa waŋanoŋ ano. Manasenoŋ Joosefwaa meria mutuya kolooroto, asianoŋ kileŋ boria qanianoŋ iwaa waŋanoŋ ano. Kaeŋ ama boria maripooŋ kaaŋa ama kotoŋ waŋgaranoŋ ano. ");
INSERT INTO ksr_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Kaeŋ ama rama Joosef kotuegoŋ muŋ kokaeŋ jero: “Asana Aabraham ano maŋna Aisak yoronoŋ Anutuwaa jaanoŋ kema kaŋ ama meŋ laligori. Niinoŋ kolooŋ laligoŋ koubeti, Anutunoŋ mono kambaŋ iikanoŋ pondaŋ kalaŋ koma noma laligoŋ kouro. ");
INSERT INTO ksr_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Siwe gajobanoŋ nii bologa kuuya iikanoŋa metogoŋ aŋgoŋ koma noma laligoroti, iinoŋ mono eja gbaworo woi koi kotuegoŋ oroma laligowa. Ejembanoŋ yoroo qagara qagi iikanoŋ mono nii ano maŋ asana Aisak ano Aabraham nonoo qabuŋanana bosima laligowao. Yoroo kanagesogaranoŋ mono namo qaganoŋ honoŋa qaa seiŋ laligowuya.” ");
INSERT INTO ksr_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Kaeŋ jeroto, Joosefnoŋ maŋanoŋ boria dindiŋanoŋ Efraimbaa waŋanoŋ ano ii iiro mende sokono kawaajoŋ moma boliŋ maŋaa boria dindiŋanoŋ meŋ Efraimbaa waŋanoŋga metogoŋ Manasewaa waŋanoŋ amambaajoŋ ano. ");
INSERT INTO ksr_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Kaeŋ ama maŋa kokaeŋ ijoro: “Amana, kaaŋ mende mewa. Mera koi kanoŋ mutu merana kolooja. Kawaajoŋ boroga dindiŋanoŋ mono iwaa waŋanoŋ amba.” ");
INSERT INTO ksr_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Kaeŋ ijoroto, maŋanoŋ ii amambaajoŋ qetama Joosef kokaeŋ ijoro: “Merana, ii saanoŋ mojeŋ. Niinoŋ ii mojeŋ. Manasenoŋ kaaŋagadeeŋ waaŋawo kolooro iwaa gbiliurutanoŋ kaaŋagadeeŋ kolooŋ seisei ama kanageso somata koloowuyato, Efraimbaa qaqabuŋayanoŋ mono Manasewaanoŋ qabuŋa uuguŋ ewaa. Iwaa gbiliurutanoŋ mono kolooŋ seisei somata ama kanageso tuuŋa tuuŋa mamaga kolooŋ laligowuya.” ");
INSERT INTO ksr_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Kaeŋ ijoro moro weemboria iikanoŋadeeŋ kotuegoŋ oroma kokaeŋ jero: “Israel yoŋonoŋ mono oroo qagara qama kanagesogia kotuegoŋ oŋoma kokaeŋ jewuya: Anutunoŋ mono oyaŋboyaŋ ama oŋonota oŋonoŋ Efraim ano Manase kaaŋa koloowu.” Kaeŋ jeŋ Manase ii Efraimbaa newo baatanoŋ ano. ");
INSERT INTO ksr_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Israelnoŋ kotuegoŋ oŋono tegoro Joosefwaa qaa kokaeŋ jero: “Moba, niinoŋ komumambaajoŋ anjento, Anutunoŋ oŋowo laligoŋ ubaa. Iinoŋ mono uŋuano maŋ asaurugia yoŋoo balonoŋ eleema kembuya. ");
INSERT INTO ksr_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Iikanoŋ kema batugianoŋ baloŋ mosoŋgi niinoŋ goonoŋ baloŋ toroqeŋ Sekem baloŋ kelegawo ii gonjeŋ. Niinoŋ baloŋ bambaaŋa ii Amor kanageso yoŋowo manja qeŋ neenaa tiwo ano manjawaa soo somata iikanoŋ yoŋoonoŋga mewe. Joosef gii daremuŋuruga yoŋoo waŋgia koloojaŋiwaajoŋ ii daremuŋuruga yoŋoojoŋ qaagoto, goo buŋaga jeŋ tegoweta ewaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Kawaa gematanoŋ Jeikobnoŋ merauruta oŋoono kagi qaa kokaeŋ jero: “Oŋo mono horoŋ ajoroogi niinoŋ laaligogianoŋ kanageŋ nomaeŋ koloowaati, iikawaa gejatootoo qaaya iŋisaama jewe mobu: ");
INSERT INTO ksr_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Jeikobwaa merauruta, oŋo mono kaŋ ajorooŋ amagia Israelwaanoŋ qaa geja ama mobu. ");
INSERT INTO ksr_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Oo Ruuben, giinoŋ neenaa mutu meranaga koloojaŋ. Giinoŋ noo ku-usuna ano emba mewe esuŋmumunaa hoŋa mutuya koloona. Qabuŋagaa akadamuya ano ku-usuŋa kanoŋ kouruga yoŋoonoŋ uŋuuguja. ");
INSERT INTO ksr_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Haamonoŋ kowe siri qindiiro kalumalu kema kaŋkeji, goo uuganoŋ mono iikawaa so waaro kalugoŋ laŋ kema kaŋkejaŋ. Giinoŋ maŋga noo duŋ eenanoŋ uma qembonanoŋ qeŋ embanawo ena duŋ kanoŋ mono aŋgonjorayawo kolooŋ tilooro. Kawaajoŋ goo qabuŋagaa akadamuyanoŋ mono kouruga mende toroqeŋ uŋuuguŋ ewaa. ");
INSERT INTO ksr_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeon ano Liwai yoronoŋ daremuŋwoiga koloojao. Yoroo tiwo wasa gawoŋgaranoŋ mono kike kakasililiŋ kondooŋkeja. ");
INSERT INTO ksr_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Yoronoŋ iriŋsooŋsooŋ qaganoŋ eja uŋuri komugi eeŋ totooŋ aiŋaajoŋ bulmakao ejia iyoŋoo kana boro iwoigia laŋ uŋuŋ kotori meendaŋgoya koloogi. Kawaajoŋ yoronoŋ qaa areŋ somoŋgoŋkebaoti, niinoŋ iikawo uumotooŋgo mende amakemaŋa. Ajoajoroo ambaoti, niinoŋ iikanoŋ iyorowo mende toroqeŋ ramaŋa. ");
INSERT INTO ksr_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Uukazigaranoŋ geriawo koloojiwaajoŋ ii jeŋ qasuaaŋ oronjeŋ. Uuduuduugaranoŋ kanjaŋawo koloojiwaajoŋ ii jeŋ jororaaŋ oronjeŋ. Niinoŋ kanagesogara kondeema oŋombe yoŋonoŋ Jeikobwaa baloŋ sokoma kembu. Niinoŋ mendeema oŋombe yoŋonoŋ Israel batugianoŋ laŋ gooŋpora ama laligowu. ");
INSERT INTO ksr_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Oo Juuda, goo daremuŋuruganoŋ gii mepeseeŋ goma laligowuya. Goo boroganoŋ mono kereuruga yoŋoo aro kokoŋgianoŋ rabaa. Maŋgaa merauruta yoŋonoŋ mono goojoŋ usugoŋ simiŋ kuma laligowu. ");
INSERT INTO ksr_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Oo Juuda, giinoŋ laion gbaworoya kaaŋa laligojaŋ. Oo merana, gii borojaŋ meŋ oro qeŋ neŋ laligoŋ iikanoŋadeeŋ eleema kajaŋ. Iinoŋ laion kaaŋa selia ama qetetereeŋ laion embia kaaŋa kamaaŋ koma eŋkeja. Kuuyanoŋ ii kawali kolooŋ utuŋ mondowombaajoŋ keegia momakeju. ");
INSERT INTO ksr_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ku-usumbaa aiweseya ii moŋnoŋ Juuda yoŋoo borogianoŋga mende uŋuambaa. Eja pombaa gbaruyanoŋ kania batugaranoŋ nano moŋnoŋ ii mende qetegowaa. Qaago! Iyaŋa ano gbiliuruta jiŋkaroŋ duŋanoŋ rama laligoŋ ugi kanageŋ moŋnoŋ asugiro kanageso tuuŋa tuuŋa yoŋonoŋ iwaa jeta teŋ koma laligowu. ");
INSERT INTO ksr_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Iinoŋ doŋgia wain apu gere batuyanoŋ somoŋgoro nambaa. Doŋgia meria ii wain apu kasa batugaranoŋ gbadooro ewaa. Iinoŋ opoya ii wain ooyanoŋ soŋgbambaa. Malekuya ii wain kotaa oo sayanoŋ qesaama qejaambaa. ");
INSERT INTO ksr_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Wain oo nero jaayanoŋ wain oo apu kaaŋa osaaŋ injaŋ kombaa. Aju tokoya nero jetanoŋ aju ooya kaaŋa taaliwaa. ");
INSERT INTO ksr_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zebulun kanageso yoŋonoŋ kowe goraayanoŋ laligowu. Yoŋoo gomanoŋ waŋgoya waŋgoya suluŋkebu. Baloŋgiaa jawoya iikanoŋ mono Saidon taoŋ baageŋ kema ewaa. ");
INSERT INTO ksr_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Aiskar ii doŋgi siita koukouya iikawaa so kolooja. Doŋgi qaganoŋ duŋ rarawaa gesoya woi iikawaa batugaranoŋ ama qetetereeŋ lokoliŋ sologoŋ eŋkebaa. ");
INSERT INTO ksr_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Lokoliŋ sologoŋ haamo meŋ ero duŋ miria ii saanoŋ sokono gomaŋanoŋ naaŋ totooŋ koloowaa. Ii iima gemata iwoi lombotawo aŋgomambaajoŋ usugoŋ kemero tosianoŋ weleŋqeqe gawoŋ mewaatiwaajoŋ kuuŋ somoŋgoŋ muŋkebuya. ");
INSERT INTO ksr_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Tosianoŋ Dambaa kanagesouruta menduŋgoŋ oŋoŋgi Dan iinoŋ mono aworo (defence) nama qaa dindiŋaajoŋ manja qeŋ laligowaa. Dan tuuŋ yoŋonoŋ Israelwaa tuuŋ tosaaŋa iikaaŋa kolooŋ laligowuya. ");
INSERT INTO ksr_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan iinoŋ qato mokoleŋ kaaŋa kananoŋ eŋ hooswaa gbakotanoŋ kiro aaruŋ lalaŋaniŋ giliro qaganoŋ rabaati, iinoŋ mono tama gemagema namonoŋ kemebaa. ");
INSERT INTO ksr_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Oo Poŋ, giinoŋ nii kasa gbadonoŋga metogoŋ aŋgoŋ koma nombaatiwaajoŋ jaa riŋ mambomakemaŋa. ");
INSERT INTO ksr_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Kike kakasililiŋ tuuŋ yoŋonoŋ Gad kanageso uŋuŋ oŋooŋ laligowuto, Gad yoŋonoŋ mono meleema kanagianoŋ oŋotaaŋ iyaŋgia uŋuŋ oŋooŋ laligowuya. ");
INSERT INTO ksr_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Aserwaa balonoŋ nene moriaŋ mamaga asugiŋkebaa. Kiŋ yoŋonoŋ nene naaŋgiawo neŋkejuti, iinoŋ mono nene kaaŋa ii baloŋanoŋ komoro seiŋ iikanoŋ tosaaŋa ilaaŋ oŋoma laligowaa. ");
INSERT INTO ksr_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Nembaronoŋ aŋaa jaajaa naaŋaajoŋ uulaŋawo lansaŋ gooŋpora amakeji, Naftalinoŋ mono iikawaa so kolooŋ meraboraaŋuruta iŋiima-aiŋaiŋgiawo ii oŋoma laligowaa. ");
INSERT INTO ksr_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Wain gere apu jaayaa kosianoŋ komogi kota mamaga kuuŋ boria giliro kema sopa qisigoŋ seleeŋgeŋ kemakeji, Joosefnoŋ mono iikawaa so kolooja. ");
INSERT INTO ksr_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Iwaa kereurutanoŋ tiwo jaŋgbeŋgia meŋ uugere qaganoŋ Joosefwaa tuuŋ ii oŋotaaŋ iŋidoŋ uŋuŋ oŋooŋ laligowu. ");
INSERT INTO ksr_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Kaeŋ laligowuto, Jeikobwaa beŋa Anutu ku-usuŋawo iwaa borianoŋ mono meŋ kotiiŋ muro iinoŋ tiwo tokoya mende mesaoŋ boro siita sombaŋa qaa qero laligowaa. Anutunoŋ mono uuwaa lama galeŋa kolooŋ Israelwaa aŋgoŋkoŋkoŋ Toya kolooja. ");
INSERT INTO ksr_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Maŋgaa Anutuyanoŋ mono ilaaŋ goma laligowaa. Beŋ ku-usuŋ kuuyaa Toyanoŋ mono kokaeŋ kotuegoŋ gono laligowa: Kombaa kotumotueyanoŋ mono kanakeewaŋga goonoŋ kamaaro namo dusiita emuyaa apuyanoŋ mono goonoŋ kouro merabora ano oro mamaga mokolooŋ oŋoma laligowa. ");
INSERT INTO ksr_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Baaŋa baaŋa iyoŋoo kotumotuegianoŋ kambaŋa kambaŋa ejemba sokoma oŋono laligoŋ kougi. Baaŋaa soroganoŋ yambu so nene gawoŋgia meŋ laligogi nene moriaŋ asugiro laligoŋ kougito, goo amagaa kotumotueyanoŋ mono ii kuuya uuguwaa. Kotumotue kaaŋa kaaŋanoŋ mono Joosefwaa waŋaa qaganoŋ ubu. Daremuŋ batugianoŋ poŋ qereweŋa jawiŋ tak-kootoya koloojiwaa laaligoyanoŋ ii kuuya mono eŋ ubu. ");
INSERT INTO ksr_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamin ii kasu kawalia kaaŋa kolooja. Gomaamba so tiwojuŋ tigoŋ oro uŋuŋ neŋ gogoŋ oŋomakeja. Weeŋ asaganoŋ iwoi luluuma qeŋkeji, ii gomantiiŋa so mendeemakeja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Israelwaa tuuŋ kuuya jaŋgogia 12 ii kiaŋ. Maŋgianoŋ kotuegoŋ oŋoma qaa kaaŋa kaaŋa jero mogi. Kotumotuegia morota morota ii aŋa aŋa mendeema kuuya kotuegoŋ oŋono. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Kotuegoŋ oŋoma nama qaa kokaeŋ jeŋ kotoŋ oŋono: “Anutunoŋ mono nuano niinoŋ isi alauruna komugiti, iyoŋowo toroqemambaa anjeŋ. Noo qamona ii mono maŋuruna yoŋoo kooroŋgianoŋ kobaa Hit eja Efrombaa baloŋ korianoŋ eji, iikanoŋ roŋ koma nombu. ");
INSERT INTO ksr_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Kobaa ii Keinan balonoŋ Makpela baloŋ korianoŋ Mamre kosianoŋ eja. Aabrahamnoŋ baloŋ koria kobaayawo ii isinanaa qasiria ewaatiwaajoŋ Hit eja qata Efron iwaanoŋga sewaŋa mero. ");
INSERT INTO ksr_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Aabraham ano embia Saara ii kobaa iikanoŋ roŋ koma oroŋgi. Kaaŋagadeeŋ Aisak ano embia Rebeka ii iikanoŋ roŋ koma oroŋgi. Niinoŋ toroqeŋ Lea iikanoŋ roŋ kombe. ");
INSERT INTO ksr_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Aabrahamnoŋ namo koria kobaayawo ii wala Hit yoŋoonoŋga sewaŋa merota eja.” ");
INSERT INTO ksr_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Jeikobnoŋ merauruta qaa kaeŋ jeŋ kotoŋ oŋono tegoro kanawoita hororo duŋ eeyanoŋ uro goroŋ qeŋ komuro Anutunoŋ wano isi alauruta yoŋoonoŋ toroqero. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Jeikobnoŋ komuro Joosefnoŋ luguŋ maŋa kepelaaŋ muŋ ligoŋ kema aroyanoŋ giliro kemero buuta kitoŋ nero. ");
INSERT INTO ksr_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Kawaa gematanoŋ Joosefnoŋ doktauruta jeŋkootoyaa baatanoŋ laligogiti, ii maŋaa qamoya sele meŋ kotikotii keleganoŋ moriwutiwaajoŋ jeŋ kotoŋ oŋono. Jeŋ kotoŋ oŋono yoŋonoŋ Israelwaa qamoya kaeŋ ama mugi. ");
INSERT INTO ksr_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Gawoŋ ii meŋ laligogi weemboria 40 kuuya tegoro. Qamogia kelenoŋ moriŋkegi, iikawaa gawoŋa ii kambaŋ koriga kaeŋ meŋ laligoŋkegi. Iijipt kanatuuru yoŋonoŋ Jeikobwaajoŋ weemboria 70:waa so jiŋgeŋ qama saama laligogi. ");
INSERT INTO ksr_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Saama jiŋgeŋ koma wosobiri laligogitiwaa kambaŋa iikanoŋ tegoro Joosefnoŋ Faarao kimbaa jiŋkaroŋ mirinoŋ gawoŋ meŋ laligogiti, ii qaa kokaeŋ iŋijoro: “Niinoŋ oŋoo jaagianoŋ kiaŋkoomu mokolooweti eeŋ, oŋo mono noo jenanoŋ meŋ Faarao kiŋ qaa kokaeŋ jegi mobaa: ");
INSERT INTO ksr_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Maŋnanoŋ jaawo laligoŋ qaa kokaeŋ somoŋgoŋ jojopaŋ qaanoŋ jeŋ kotiimambaajoŋ jeŋ kotoŋ nono: ‘Niinoŋ komumambaajoŋ anjeŋ. Nii neenaajoŋ jamo kobaa Keinan balonoŋ osoweta nanji, noo qamona ii mono iikanoŋ kema roŋ komba.’ Kawaajoŋ saanoŋ kete jeŋ kotona nii iikanoŋ kema maŋnaa qamoya roŋ komago mombo eleema kamaŋa.” ");
INSERT INTO ksr_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Kaeŋ iŋijoro jegi Faarao kiŋnoŋ ii moma kokaeŋ jero, “Gii maŋgaajoŋ qaa somoŋgoŋ jojopaŋ qaanoŋ jeŋ kotiinati, iikawaa so saanoŋ kema maŋgaa qamoya roŋ komba.” ");
INSERT INTO ksr_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Kaeŋ jero Joosefnoŋ maŋaa qamoya roŋ komambaajoŋ uro. Faarao kimbaa jawiŋuruta qabuŋagiawo kuuya, jiŋkaroŋ miriaa ano Iijipt kantriwaa jotamemeuruta qabuŋagiawo ii kuuya iwo motooŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Joosefwaa miriwaa sumaŋuruta korebore, iwaa daremuŋuruta ano maŋaa kanagesouruta yoŋonoŋ kaaŋagadeeŋ motooŋ keŋgi. Embameraurugia, lama, meme ano bulmakao tuuŋa tuuŋa iigadeeŋ mono oŋomesaogi Goosen gomanoŋ ragi. ");
INSERT INTO ksr_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Hooswaa kareya kareya ano eja hoos qagianoŋ ragiti, ii kaaŋagadeeŋ keŋgi. Kaeŋ mindiriŋ tuuŋ somata totooŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Kema kema Jordan apu gowoya kotoŋ leegeŋ toroqeŋ kema Atad gomanoŋ wiit dumuŋ kotawaa hoŋa ano kaawoya mendeema gosigiti, miri baloŋ iikanoŋ keuma jiŋgeŋ aro metaama qama silama saama boliŋ laligogi. Joosefnoŋ maŋaajoŋ weemboria 7:baa so jiŋgeŋ qama saama laligoro. ");
INSERT INTO ksr_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Atad gomanoŋ jiŋgeŋ qama saagi baloŋ toya Keinan kanageso yoŋonoŋ ii iima moma kokaeŋ jegi, “Iijipt yoŋonoŋ mono jiŋgeŋ saawaa areŋa uuta anju.” Kaeŋ jegi miri baloŋ iikawaa qata ii kanaiŋ Aabel Mizraim qagi. Ii Jordan apu gowoyaa weeŋ koukoutaageŋ eja. ");
INSERT INTO ksr_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Jeikobnoŋ merauruta jeŋ kotoŋ oŋonoti, yoŋonoŋ iikawaa so otaaŋ ama mugi. ");
INSERT INTO ksr_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Yoŋonoŋ qamoya aŋgoŋ Keinan balonoŋ kema Mamre kosianoŋ Makpela baloŋ korianoŋ kobaa eji, iikanoŋ kema roŋ koŋgi. Aabrahamnoŋ waladeeŋ baloŋ koria kobaayawo ii qasirigia ewaatiwaajoŋ Hit eja Efron iwaanoŋga sewaŋa mero. ");
INSERT INTO ksr_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Joosefnoŋ maŋaa qamoya roŋ kono tegoro aŋa, daremuŋuruta ano tosaaŋa kuuya iwo maŋaa qamoya roŋ kombombaajoŋ keŋgiti, iyoŋonoŋ mombo Iijipt balonoŋ eleema kagi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Joosefwaa daremuŋurutanoŋ maŋgia komuro rama iima kotoŋ kokaeŋ romoŋgoŋ jegi: “Joosef sili bologa kuuya ama muniŋi, iinoŋ iikawaajoŋ uuduuduu moma nonoma kambaŋ kokaamba kanaiŋ iroŋa meleema nonombabo.” ");
INSERT INTO ksr_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Kaeŋ jeŋ Joosefwaa qaa kokaeŋ aŋgi keno, “Maŋganoŋ komumambaa ama nonoojoŋ qaa kokaeŋ jeŋ kotoro: ");
INSERT INTO ksr_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Oŋo mono Joosefwaajoŋ qaa kokaeŋ jegi mobaa: Daremuŋuruganoŋ sili bologa ama tiwilaaŋ gombombaajoŋ aŋgiti, giinoŋ mono iyoŋoo siŋgisoŋgogia ano kakasililiŋgia ii mesaowa. Kawaajoŋ giinoŋ saanoŋ maŋgaa Anutuyaa weleŋqeqeuruta nonoo siŋgisoŋgonana mesaowa.” Yoŋonoŋ qaa ii aŋgi Joosefwaanoŋ karo moma mono qama saaro. ");
INSERT INTO ksr_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Kawaa gematanoŋ Joosefwaa daremuŋuruta iyaŋgio kaŋ balonoŋ tama batanoŋ usugoŋ kamaaŋ kokaeŋ ijogi: “Moba, nono goo weleŋqeqeuruga omaya koloojoŋ.” ");
INSERT INTO ksr_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Kaeŋ ijogito, Joosefnoŋ meleema kokaeŋ jero: “Mono keegia mende mobu. Niinoŋ Anutuwaa kitianoŋ mende nanjeŋ. ");
INSERT INTO ksr_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Oŋanoŋ, oŋo sili bologanoŋ tiwilaaŋ nombombaajoŋ kaparaŋ koma aŋgito, Anutunoŋ ii meleeno kitianoŋ iwoi awaa asugiwaatiwaajoŋ kaparaŋ koma ano. Kaeŋ ama kondooŋ kuuŋ nono kanatuuru mamaga oŋoo laaligogia somoŋgowe iikawaa hoŋanoŋ kambaŋ kokaamba asuganoŋ kolooro iima kotojoŋ. ");
INSERT INTO ksr_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Kawaajoŋ mono keegia mende mobu. Niinoŋ mono oŋoaŋgia ano embameraurugia oŋoo laaligogia kuuya naŋgoŋ oŋoma laligomaŋa.” Kaeŋ jeŋ kileŋagiaa iroŋa ii mende meleemambaajoŋ mombo jeŋ kotiiŋ gumbonjonjoŋ ama oŋono. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Joosefnoŋ maŋaa kanagesouruta yoŋowo toroqeŋ Iijipt balonoŋ laligogi. Joosefnoŋ laligoŋ uro yambuya 110 kolooro komuro. ");
INSERT INTO ksr_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Joosefnoŋ esa amboaaŋa Efraimbaanoŋga koloogi ii iŋiiro. Kaaŋagadeeŋ Manasewaa meria Makir iwaa meraboraaŋa koloogi Joosefwaa tawoyanoŋ oŋooŋgi dooŋgoŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Kawaa gematanoŋ Joosefnoŋ daremuŋuruta yoŋoojoŋ qaa kokaeŋ iŋijoro, “Nii komumambaajoŋ anjento, Anutunoŋ mono kalaŋ koma oŋono laligowuya. Iinoŋ oŋo baloŋ kokainoŋga uŋuama baloŋ Aabraham, Aisak ano Jeikob yoŋoo buŋaga koloowaatiwaajoŋ jeŋ tegoŋ jojopaŋ qaanoŋ jeŋ kotiiroti, mono iikanoŋ kema laligowu.” ");
INSERT INTO ksr_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Kaeŋ iŋijoro Israelwaa meraurutanoŋ qaa jeŋ somoŋgoŋ jojopaŋ qaanoŋ kokaeŋ jeŋ kotiiwutiwaajoŋ jeŋ kotoŋ oŋono: “Anutunoŋ kalaŋ koma oŋono laligogi niinoŋ komuwe noo siina ii mono baloŋ kokainoŋga aŋgoŋ Keinan balonoŋ kembu.” ");
INSERT INTO ksr_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Kaeŋ jeŋ yambuya 110 kolooro komuro. Komuro Iijipt kanoŋ qamoya ii sele meŋ kotikotiiwaa keleganoŋ moriŋ qamo bokisnoŋ aŋgi ero. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Kerugeŋ Israel uutanoŋ kiŋ moŋ mende laligoro eja poŋ yoŋonoŋ kanatuuru galeŋ koma oŋoma laligogi. Kambaŋ kanoŋ bodi kolooŋ baloŋ kuuya sokoma ero. Bodi kambaŋ kanoŋ Juuda eja moŋnoŋ embia ano merawoita uŋuama taoŋgia Betlehem mesaoŋ kantri qata Moab kanoŋ kema raraŋ dunduŋgia meagoŋ waba laligogi. ");
INSERT INTO ksr_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Eja qata Elimelek, embia qata Naomi ano merawoigara qagara Malon ano Kilion baloŋgia qata Efrata. Yoŋonoŋ taoŋgia Betlehem mesaoŋ Moab balonoŋ kema kanoŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Iikanoŋ laligogi Naomiwaa loya Elimelek komuro. Komuro Naominoŋ emba maloya kolooŋ merawoita yorowo laligogi. ");
INSERT INTO ksr_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Merawoita yoronoŋ laligoŋ somariiŋ Moabga emba woi qagara Orpa ano Ruut agimiŋ aogi. Agimiŋ aogi toroqeŋ Moab balonoŋ yambu 10:baa so laligoŋ kougi. ");
INSERT INTO ksr_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Laligoŋ kouma merawoita woi Malon ano Kilion yoronoŋ kaaŋagadeeŋ komuri. Komuri nemuŋgara Naomi iinoŋ lomeria qaa aŋodeeŋ laligoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Naominoŋ aŋodeeŋ Moab kantrinoŋ laligoŋ kambaŋ moŋnoŋ qaa kokaeŋ jegi moro: ‘Poŋnoŋ kanatuuruya ilaaŋ oŋoma Israel kanoŋ nembanene sogianoŋ mokolooŋ oŋomakeja.’ Kaeŋ moma Moab mesaoŋ Israel balonoŋ eleema kemambaajoŋ joroŋqoroŋ ama eŋarowoita yorowo waagi. ");
INSERT INTO ksr_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Waama gomaŋ baloŋ laligoroti, ii mesaoŋ Juuda balonoŋ eleema kemambaajoŋ ano eŋarowoita yorowo motooŋ kananoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Kananoŋ kema Naominoŋ eŋarowoita kokaeŋ irijoro: “Emba woi, oro mono eleema nemuŋwoigara yoroo gomanoŋ kema laligowao. Oro noo lomeraana komugiti ano nii nono awaagadeeŋ kalaŋ koma noma laligori Poŋnoŋ mono kawaa so tawaya meleema awaagadeeŋ kiaŋkoomu orono laligowao. ");
INSERT INTO ksr_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Poŋnoŋ saanoŋ kana mero oro eja mombo agimiŋ aoŋ laaligo raraŋgara yoroo mirinoŋ mokolooŋ uukorisoro qaganoŋ laligowao.” Kaeŋ irijoŋ buugara kitoŋ neroto, yoronoŋ amburereŋ ama silama saari. ");
INSERT INTO ksr_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Saama kokaeŋ ijori: “Qaago! Noro mono giwo eleema goo kanageso tuuŋga yoŋoonoŋ kemboŋa.” ");
INSERT INTO ksr_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Kaeŋ ijori meleema kokaeŋ irijoro: “Oo eŋarowoina, mono naambaajoŋ niwo kawowaajoŋ anjao? Nii mombo eja merawoina mewe somariiri ii orombaoraga me? Kaeŋ romoŋgowaoragati eeŋ, iikanoŋ mende sokonja. Qaago totooŋ! Mono keteda koi eleema kembao. ");
INSERT INTO ksr_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Nii emba waŋa koloojeŋiwaajoŋ eja moŋnoŋ nii mende nombaa. Oo eŋarowoina, oro mono eleema mirigaranoŋ kembao. Nii mombo eja memambaajoŋ romoŋgoŋ kete gomantiiŋa eja mombo eŋ korowo kolooŋ merawoina qokolooŋ orombenagati eeŋ, ii mono kileŋ bimobimooyawo. ");
INSERT INTO ksr_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","Mera ii somariiri lowoigara oromambaajoŋ mamboma laligowaoraga me qaago? Yoroojoŋ ama eja memegaraa kania somoŋgoŋ aoŋ kambaŋ batuya koriga ii eeŋ laligowaobo. Ii mende sokonja. Oo eŋarowoina, iikaaŋ qaago. Poŋnoŋ boria boraama lona nuano komurotiwaajoŋ laaligonananoŋ bimooro nii oroojoŋ wosojinjina mojeŋ.” ");
INSERT INTO ksr_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Kaeŋ irijoro mombo toroqeŋ silama saari. Saari tegoro Orpanoŋ eŋaroyaa yeizozoya jeŋ buuta kitoŋ neŋ eleema mirianoŋ keno. Orpanoŋ kenoto, Ruutnoŋ kaparaŋ koma sele kopaya kaaŋa qokotaaro. ");
INSERT INTO ksr_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Kaaŋa qokotaaro Naominoŋ kokaeŋ ijoro: “Moba, alaganoŋ kenja. Iinoŋ aŋaa beŋsakoŋ ano aŋaa ejemba tuuŋ yoŋoonoŋ kenja. Gii mono kaaŋgadeeŋ eleema miriganoŋ kemba.” ");
INSERT INTO ksr_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Kaeŋ ijoroto, Ruutnoŋ kileŋ kokaeŋ meleeno: “Nii mono gii gomesaomaŋatiwaajoŋ kaparaŋ mende koma jewa. Saanoŋ jena giwo kembo. Gii noma nomaeeŋ kembagati, nii mono kaaŋagadeeŋ giwo iikanoŋ kemaŋa. Gii dakanoŋ dakanoŋ laligowagati, nii mono kaaŋagadeeŋ iikanoŋ laligomaŋa. Goonoŋ ejemba tuuŋ ii noo ejemba tuuŋnaga koloogi goonoŋ Anutu ii noo Anutuga kolooro laligomaŋa. ");
INSERT INTO ksr_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Gii dakanoŋ komuwagati, nii mono kaaŋagadeeŋ iikanoŋ komuwe roŋ koma nombutiwaajoŋ mojeŋ. Qaa ii kokaeŋ jeŋ kotiijeŋ: Koomu motooŋgonoŋ mono mendeema norombaa. Iwoi morota moŋnoŋ mendeema norombaati eeŋ, Poŋnoŋ saanoŋ iikawaa iroŋa meleeno noo qananoŋ uba.” ");
INSERT INTO ksr_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Kaeŋ jeŋ iwo kemambaajoŋ kotakotagadeeŋ kaparaŋ kono iima moma kotoŋ kawaa qaaya mombo mende ijoro. ");
INSERT INTO ksr_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Mende ijoroto, motooŋgara kema kema Betlehem taonoŋ keuri. Keuri taonoŋ ejemba kuuyanoŋ ii iriima korisoro somata moma ajoroogi. Emba yoŋonoŋ qama Naomi koma horoŋ joloŋa kokaeŋ jegi: “Ei! Ii oŋanoŋ, Naomi yaŋo me nomaeŋ? Oowe oowe oowe!” ");
INSERT INTO ksr_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Kaeŋ jegi Naominoŋ kokaeŋ iŋijoro: “Noo qana Naomi ii eeŋ mende qabu. Nii uukorisoro embaga qaago. Anutu ku-usuŋ Toyanoŋ mono kondooŋ nono uukonduŋ moma laligojeŋ. Kawaajoŋ noo qana Mara qagi sokombaa. ");
INSERT INTO ksr_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Noonoŋ iwoi mamaga wala ero taoŋ koi mesaoŋ kembeto, kete Poŋnoŋ nuano bobora eleema eeŋ omaya kajeŋ. Poŋ ku-usuŋ Toyanoŋ qaana gosiŋ meŋ boliŋ nono koŋajiliŋ qaganoŋ laligojeŋ. Kawaajoŋ qana Naomi ii mono eeŋ qabubo.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Naomi ano eŋaroya Ruut, Moab emba kanoŋ Moab mesaoŋ Betlehem taonoŋ kariti, kambaŋ iikanoŋ ejembanoŋ kanaiŋ padiwaa alia baali ii gawoŋgianoŋ kema borogianoŋ kuŋgi. ");
INSERT INTO ksr_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Naomiwaa loya Elimelekwaa isi uutanoŋ tinitosaya, eja qabuŋayawo moŋ qata Boaz laligoro. ");
INSERT INTO ksr_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Kambaŋ moŋnoŋ Moab emba Ruut iinoŋ eŋaroya Naomi kokaeŋ ijoro: “Saanoŋ jeŋ tegona nii gawoŋ moŋnoŋ kema ejemba baali gowia kuma reremoŋa mesaoŋkejuti, ii otama meŋ kululuumaŋa. Nii saanoŋ eja mombaa jaanoŋ iima-aiŋ mokoloowe nisosorooŋ ‘Ooŋ!’ jero saanoŋ iwaa gematanoŋ kema ii meŋ kululuumaŋa.” Kaeŋ jero Naominoŋ ijoro: “Oo eŋarona, saanoŋ kemba.” ");
INSERT INTO ksr_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Kaeŋ ijoro mesaoŋ gawoŋ moŋ morowaanoŋ gawoŋa, ii mende moma kileŋ tondu kema nama baali kuŋgi yoŋoo gemagianoŋ kema gowia motomotooŋ qeqelala kamaaŋ egiti, ii otama otama keno. Gawoŋ korianoŋ kenoti, ii Boazwaanoŋ gawoŋga. Boaz ii eŋaroya Elimelekwaa isinoŋga moŋ. ");
INSERT INTO ksr_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Boaznoŋ ketego koi Betlehemga kouma gawoŋ ejembauruta iŋiima joloŋgia kokaeŋ jero: “Bonjoŋ! Poŋnoŋ mono oŋowo laligowa.” Kaeŋ jero meleema kokaeŋ qagi: “Poŋnoŋ mono kotuegoŋ gomba.” ");
INSERT INTO ksr_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Kaeŋ qagi Boaznoŋ gawoŋ galeŋaajoŋ kokaeŋ qisiro: “Emba ii moronoŋ?” ");
INSERT INTO ksr_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Kaeŋ qisiro kokaeŋ meleeno: “Emba ii koriganoŋga. Ii Naomiwo Moab kantrinoŋga kari. ");
INSERT INTO ksr_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Iinoŋ gomaamba amandiiŋanoŋ kaŋ qisiŋ nono ‘Ooŋ!’ jewe gawoŋ ejemba yoŋoo kanagianoŋ oŋotaaŋ baali gowia otama meŋ kululuuja. Gawoŋ pondaŋ meŋ laligoŋ ketada koi kuuŋnoŋ endu kema haamo meŋ raja.” ");
INSERT INTO ksr_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Kaeŋ meleeno Boaznoŋ Ruut kokaeŋ ijoro: “Borana moba, nii qaa goroga moŋ gomaŋa: Gii gawoŋ koi mende mesaoŋ tosaaŋa yoŋoo gawonoŋ mende kema baali meŋ kululuuwa. Mono noo weleŋqeqe embauruna yoŋowo motooŋ koikanoŋ otama laligowa. ");
INSERT INTO ksr_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Nii gawoŋ ejauruna goosiriwubotiwaa soŋgo anjeŋ. Gawoŋ noma nomaeeŋ kema dumuŋ kota kumbuti, gii mono iikawaa jaagaleŋ ano yoŋoo gemagianoŋ kema emba yoŋowo laligowa. Apugaajoŋ mobagati eeŋ, weleŋqeqe yoŋonoŋ apu koworaŋenoŋ kosojuti, saanoŋ iikanoŋ kema apu newa.” ");
INSERT INTO ksr_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Kaeŋ ijoro Ruutnoŋ moma balonoŋ kemeŋ usugoŋ Boaz kokaeŋ ijoro: “Nii nomaembaajoŋ waba laligoŋ kileŋ goo jaanoŋ kiaŋkoomu mokoloowe iikaaŋa kalaŋ koma nonjaŋ?” ");
INSERT INTO ksr_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Kaeŋ ijoro kokaeŋ meleeno: “Nii goo nanamemeŋgaa sunduya ii kuuya jegi mojeŋ. Gii loganoŋ komuro eŋaroga awaagadeeŋ galeŋ koma laligoŋ kouna. Gii nemuŋmaŋga ano kolokoloo kantriga mesaoŋ ejemba wala mende moma nononati, kileŋ nonoo batunananoŋ kaŋ laligojaŋ. ");
INSERT INTO ksr_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Gii sumaŋuruga sili awaa qendeema oŋona Anutu Israel nonoo Poŋnananoŋ mono iikawaa tawaya gomba. Kurunoŋ eŋgaŋanoŋ meraaŋa reeŋreeŋ koma oŋomakeji, iikawaa so gii Anutuwaa umuganoŋ laligomambaajoŋ koi kana.” ");
INSERT INTO ksr_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Kaeŋ ijoro Ruutnoŋ kokaeŋ meleeno: “Somatana, nii goo gawoŋ meme embauruga yoŋoo tani qaagoto, giinoŋ kileŋ sili awaa qendeema nonjaŋ. Giinoŋ qaa nuna selena tunja.” Kaeŋ meleeno. ");
INSERT INTO ksr_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Nembanene kambaŋanoŋ karo Boaznoŋ Ruut kokaeŋ ijoro: “Saanoŋ koi kaŋ bered kitia meŋ wain apu aasoŋawonoŋ qenduŋgoŋ newa.” Kaeŋ ijoro gawoŋ ejemba yoŋowo raro Boaznoŋ baali hoŋa ooŋkootoya tosia muro. Ii muro neŋ tomeŋa juno nene tosia mesaoro raro. ");
INSERT INTO ksr_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Rama waama kema toroqeŋ baali gowia otano Boaznoŋ gawoŋ ejauruta kokaeŋ jeŋ kotoŋ oŋono: “Iinoŋ baali gowia boraŋawo iikawaa batugianoŋga kaaŋagadeeŋ otama meŋ kululuuwaati eeŋ, oŋo mono qaa tokoroŋkota mende jeŋ mubu. ");
INSERT INTO ksr_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Kaeŋ qaagoto, baali gowia tosia ii boraŋgianoŋga kaaŋagadeeŋ horogi kamaaro aŋgi kaŋ iyaŋaajoŋ meŋ kululuuwaa. Oŋo mono ii mende jeŋ mubu.” ");
INSERT INTO ksr_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Kaeŋ jeŋ kotoŋ oŋono Ruutnoŋ baali gowia korama meŋ kululuuro uro hoŋa ano kaawoya mendeema oromambaa sapa sarayawonoŋ kosoŋ korereŋgoŋ gosiro hoŋa geso karoombaa so (36 liita) kolooro gomaŋ siŋsiŋgoŋ karo. ");
INSERT INTO ksr_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Kaeŋ kolooro baali hoŋa ii meŋ taonoŋ eleema kaŋ dawi koranoti, ii eŋaroya qendeema muro. Kawaa gematanoŋ nene neŋ timbiriiŋgoŋ tosia mesaoroti, ii kaaŋagadeeŋ unjuma muro. ");
INSERT INTO ksr_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Ii muro kokaeŋ qisiro: “Gii kete dakanoŋ kema baali otama meŋ laligojaŋa? Morowaa gawonoŋ kema gawoŋ meŋ laligojaŋa? Eja galeŋ koma gonjaati, Anutunoŋ mono ii kotuegoŋ muba.” Kaeŋ qisiro morowaa gawonoŋ kema gawoŋ meŋ laligoroti, iwaa sunduya Naomi ijoro: “Nii kete eja mombo gawoŋ mejeŋati, iwaa qata ii Boaz.” ");
INSERT INTO ksr_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Kaeŋ ijoro Naomiwaa eleŋa kamaaro kokaeŋ ijoro: “Poŋnoŋ mono Boaz kotuegoŋ muba. Poŋnoŋ kiaŋkoomu nonomambaa qaa somoŋgoroti, iikawaa so mono pondaŋ lomeraaŋurunanoŋ komugiti ano anana kete koi laligojoŋi, nonoojoŋ kiaŋkoomuya mende aŋgoŋ koma laligoja.” Toroqeŋ qaa kokaeŋ jero: “Eja ii nonoo tinitosananaga ano isinanaa doweya meme ejaga. Kawaajoŋ iinoŋ mono saanoŋ galeŋ koma nonombaa.” ");
INSERT INTO ksr_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Kaeŋ jero moma Moab emba Ruutnoŋ kokaeŋ jero: “Qaa moŋ toroqeŋ kokaeŋ nijojaa: ‘Gii mono noo gawoŋ meme ejemba yoŋowo boŋ qeŋ laligona noonoŋ baali kuuya ii kundaborowuya.’” ");
INSERT INTO ksr_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Kaeŋ jero Naominoŋ kokaeŋ ijoro: “Oo eŋarona, ii awaa. Gii tosia yoŋoo gawoŋ korianoŋ kena sili bologa ama gombubo. Kawaajoŋ gii saanoŋ Boazwaa gawoŋ meme emba yoŋowo kema gawoŋ meŋ laligowa.” ");
INSERT INTO ksr_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Kaeŋ jero Ruutnoŋ Boazwaa gawoŋ meme emba yoŋoo kosogianoŋ boŋ qeŋ laligoŋ hoŋa otama meŋ kululuuŋ laligoro baali ano wiit kuŋkuŋ kambaŋanoŋ tegoro. Tegoro toroqeŋ eŋaroya Naomiwo laligori. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Kambaŋ tosia tegoro Naominoŋ eŋaroya Ruut kokaeŋ ijoro: “Oo eŋarona, nii saanoŋ eja moŋ batogoŋ mokoloowe galeŋ koma gono iwo keraqeeaŋgo qaganoŋ geeŋgo miriga kalaŋ koma raba. ");
INSERT INTO ksr_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Gii gawoŋ meme emba yoŋowo mokotaaŋ laligonati, iyoŋoo galeŋgia Boaznoŋ mono nonoo tinitosananaga. Moba, iinoŋ kete gomantiiŋa baaliqeqe sombenoŋ kemeŋ baali hoŋa ano kaawoya mendeema oromambaajoŋ sapa sarayawonoŋ kosoŋ korereŋgoŋ gosiwaa. ");
INSERT INTO ksr_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Kawaajoŋ gii mono keteda koi apu ariŋ selega kele uŋkoowayawonoŋ moriŋ opo suruga mouma baaliqeqe sombenoŋ kemeba. Emu kemebato, wala sigeŋsigeŋ laligona nembaneneya ano apu kizaŋa nedabororo kawaa gematanoŋ saanoŋ iwaa jaanoŋ asugina giibaa. ");
INSERT INTO ksr_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Gaombaajoŋ moma kamaaŋ dakanoŋ hoŋ koma ewaati, mono ii iima kanoŋ kemba. Kokojiji gombaatiwaajoŋ qisiwagati, iikawaa kaisareya mono kokaeŋ amba: Gii iwaa kooroŋanoŋ kema kaniaageŋ esu kitia mena waaro kemeŋ ewa. Kaeŋ ena mokolooŋ goma nomaeŋ ambagati, ii gijoro moba.” ");
INSERT INTO ksr_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Eŋaroyanoŋ kaeŋ ijoro Ruutnoŋ kokaeŋ meleeno: “Qaa kuuya nijojaŋi, ii saanoŋ andaboromaŋa.” ");
INSERT INTO ksr_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Kaeŋ meleema baaliqeqe sombenoŋ kemeŋ eŋaroyanoŋ jeŋ kotoŋ murotiwaa so otaaŋ andabororo: ");
INSERT INTO ksr_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boaznoŋ gomantiiŋaa nembaneneya ano apu kizaŋa nedabororo selia meŋ looriro waama baali tuuŋ mombaa goraayanoŋ kemeŋ gaoŋ ero. Kanoŋ ero Ruutnoŋ oloŋ jaŋjaŋ qeŋ kema kaniaageŋ esu kitia metaama iikanoŋ kemeŋ ero. ");
INSERT INTO ksr_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Ero gomaŋ ruuŋanoŋ iwoi mombaajoŋ aaruŋ lalaŋaniro uuta tooro moma eleema emba moŋ kanianoŋ eroti, ii mokolooŋ iiro. ");
INSERT INTO ksr_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Iima qisiŋ muro: “Gii moronoŋ?” Qisiŋ muro kokaeŋ meleeno: “Oo somatana, nii Ruut, goo weleŋqeqe embaga. Giinoŋ geeŋgaa isigaa doweya meme ejaga koloojaŋ. Kawaajoŋ Juuda oŋoo nanamemeŋgia otaaŋ nii saanoŋ galeŋ koma noma esuganoŋ turuŋ nomba.” ");
INSERT INTO ksr_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Kaeŋ meleeno kokaeŋ ijoro: “Oo borana, Poŋnoŋ mono kotuegoŋ gomba! Gii saanoŋ eja wanaya me qaqabuŋa esuhinagiawo yoŋoo gemagianoŋ kenagato, iikaaŋa mende anjaŋ. Gii eeŋanoŋ isiuruna awaa naŋgoŋ oŋoma laligonago kete ii uuguŋ sili awaa soroya anjaŋ. ");
INSERT INTO ksr_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Oo borana, gii mono toroko mende moba! Bonjoŋ laligowa! Gii emba awaa soroya koloojaŋi, ii taombaa ejemba kuuyanoŋ moju. Kawaajoŋ gii ii me woiwaajoŋ qisiŋ nombagi, nii ii saanoŋ ama gomaŋa. ");
INSERT INTO ksr_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Nii goo tinitosaga kolooŋ galeŋ koma gomaŋatiwaa so koloojeŋ. Qaa ii oŋiato, eja moŋnoŋ nuuguŋ isinaa doweya meme eja mutuya kolooja. Nii iwaa qereweŋaga laligojeŋ. ");
INSERT INTO ksr_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Kawaajoŋ gii saanoŋ gomantiiŋa koi kokaeŋ ewa. Dowe meme eja mutuyanoŋ woraŋ sewaŋga memambaajoŋ jenagi eeŋ, ii awaato, sewaŋga mende memambaajoŋ mobaati eeŋ, niinoŋ saanoŋ sewaŋga memaŋa. Qaa ii somoŋgoŋ Pombaa qatanoŋ jojopaŋ qaanoŋ jeŋ kotiijeŋ. Kawaajoŋ saanoŋ bonjoŋ ena gomaŋ ambaa.” ");
INSERT INTO ksr_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Boaznoŋ kaeŋ ijoŋ emba moŋnoŋ baaliqeqe sombenoŋ iwaanoŋ kamaaroti, moŋnoŋ ii mobabotiwaajoŋ moro. Kawaajoŋ Ruutnoŋ Boazwaa kanianoŋ kamaaŋ eroto, weŋgeraŋ suluro kambaŋ iikanoŋadeeŋ moŋnoŋ ii mende iima kotoro oloŋ kembaatiwaajoŋ waaro. ");
INSERT INTO ksr_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Waaro Boaznoŋ kokaeŋ ijoro: “Mono malekuga seleganoŋga metogoŋ qerereeŋ meŋ namba.” Kaeŋ ijoro metogoŋ meŋ nano baali hoŋa 25 kilogrambaa so gosiŋ maaro kemero. Kemero meŋ kobibiiŋ Ruutwaa sawiŋanoŋ ano aŋgoŋ eleema taonoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Ruutnoŋ taonoŋ kema eŋaroyaanoŋ keuro qisiro: “Oo eŋarona, nomaeŋ eŋ kajaŋ?” Kaeŋ qisiro Boaznoŋ iwaa iwoi kuuya anoti, iikawaa sunduya ijoro moro. ");
INSERT INTO ksr_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Moro kokaeŋ toroqeŋ ijoro: “‘Gii eŋarogaajoŋ bobora mende kemba,’ kaeŋ nijoŋ baali koi nonja.” ");
INSERT INTO ksr_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Kaeŋ ijoro Naominoŋ kokaeŋ jero: “Oo eŋarona, eja iikanoŋ kete eeŋ haamo mende mewaato, qaaga galeŋ koma laligoro ii mindiŋgogi tegorogo kawaa gematanoŋ rama haamo mewaa. Kawaajoŋ gii mono sosoo mamboma rama qaaga nomaeŋ jegi asugiwaati, ii moba.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Boaznoŋ taombaa kiropo naguyanoŋ kema qenjaaro sombenoŋ kamaaŋ raro. Raro isiaa dowe meme ejawaa qaa jeroti, iinoŋ kaŋ uugumambaa ano iwaajoŋ kokaeŋ qaro: “Oo alana, gii saanoŋ koi kaŋ kamaaŋ rabaga.” Kaeŋ qaro kaŋ kamaaŋ raro. ");
INSERT INTO ksr_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Raro Boaznoŋ taonoŋga jota meme eja boro woi (10) oŋoono kagi rabutiwaa iŋijoro motooŋ kamaaŋ ragi. ");
INSERT INTO ksr_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Ragi Boaznoŋ isiaa dowe meme eja ii kokaeŋ ijoro: “Kambaŋ kokaamba Naominoŋ Moab kantri mesaoŋ eleema karoti, iinoŋ danana Elimelekwaanoŋ baloŋ kitia ii sewaŋa mewutiwaa eja. ");
INSERT INTO ksr_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Kawaajoŋ niinoŋ kokaeŋ romoŋgojeŋ: Gii qaa ii mobagatiwaa gijojeŋ. Gii isinaraa dowe meme ejaga koloona niinoŋ goo qereweŋga koloojeŋ. Dowe meme eja moŋ mende laligoja. Kawaajoŋ giinoŋ ii sewaŋa mewagatiwaajoŋ kuuŋ gonjeŋ. Gii ii sewaŋa memambaa aiŋa mobagati eeŋ, ii saanoŋ sewaŋa mewato, ii togowagati eeŋ, saanoŋ ii kaaŋagadeeŋ jena momaŋa. Ii saanoŋ eja koi rajuti, iyoŋoo jaanoŋ jewa. Ii kanatuuru tuuŋnaa jotameme koi yoŋoo jaagianoŋ jewa.” Boaznoŋ kaeŋ ijoro eja alianoŋ kokaeŋ ijoro: “Nii ii saanoŋ sewaŋa memaŋa.” ");
INSERT INTO ksr_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Kaeŋ ijoro Boaznoŋ jero: “Gii Naomiwaanoŋ baloŋ koria sewaŋa mewagati, kambaŋ iikanoŋ mono Moab emba Ruut, eja komurotiwaa maloya ii kaaŋgadeeŋ sewaŋa mewa. Kaeŋ ana eja komurotiwaa qatanoŋ mono borosamo baloŋ kanoŋ ewaatiwaajoŋ ii galeŋ koma laligowa.” ");
INSERT INTO ksr_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Kaeŋ jero dowe meme eja mutuyanoŋ meleeno: “Kaeŋ kolooro niinoŋ ii sewaŋa memambaajoŋ amamaajeŋ. Ruutnoŋ neenaa meraboraana yoŋowo motooŋ borosamona mendeeŋgi motomotooŋ yoŋonoŋ baloŋ kitia melamelaa iikayadeeŋ buŋa qeŋ aowubo. Nii kaeŋ amambaajoŋ amamaajeŋ. Kawaajoŋ giinoŋ saanoŋ ii sewaŋa mena geeŋgaa buŋaga koloowaa.” Kaeŋ meleeno. ");
INSERT INTO ksr_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Kerugeŋ Israel uutanoŋ moŋnoŋ baloŋ iwoi sewaŋa mero buŋaya kolooro iikawaa qaaya kotiiwaatiwaajoŋ yoŋonoŋ sili kokaeŋ ama laligogi: Qaa jeŋ tegoŋ soomoŋgo aŋgi tegoro iyoroonoŋga moŋnoŋ kana esuya qetegoŋ alia muŋkero. Israel yoŋonoŋ iwoi sewaŋa memewaa qaaya tegoroti, ii sili iikaaŋa kanoŋ qendeema laligogi ");
INSERT INTO ksr_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Kawaajoŋ eja kanoŋ Boaz kokaeŋ ijoro: “Giinoŋ ii saanoŋ sewaŋa mena buŋaga koloowaa.” Kaeŋ jeŋ kana esuya qetegoŋ Boaz muro. ");
INSERT INTO ksr_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Ii muro Boaznoŋ jotameme eja ano kanageso kuuya kokaeŋ iŋijoro: “Niinoŋ Elimelek, Kilion ano Malon yoŋoonoŋ iwoi kuuya ii Naomiwaanoŋga sewaŋa mejeŋ. Oŋo ii kete jaasewaŋ qeŋ naŋgoŋ jewutiwaa so kolooju. ");
INSERT INTO ksr_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Nii Moab emba Ruut, Malombaanoŋ malo ii kaaŋiadeeŋ sewaŋa mewe noo embanaga koloowaa. Kaeŋ ama eja komurotiwaa qatanoŋ borosamo baloŋ kanoŋ ewaatiwaajoŋ ii galeŋ koma laligomaŋa. Qata kaeŋ mende aliwaato, gbiliurutanoŋ Elimelekwaa qata duduuwubotiwaajoŋ ii gawmambaa buknoŋ oogi eŋ ubaa. Oŋo ii kete jaasewaŋ qeŋ naŋgoŋ jewutiwaa so kolooju.” ");
INSERT INTO ksr_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Boaznoŋ kaeŋ jero jotameme eja ano kanatuuru taombaa kiropo naguyanoŋ sombenoŋ ragiti, iyoŋonoŋ kuuya kokaeŋ jegi: “Nono ii jaasewaŋ qeŋ naŋgowoŋa. Poŋnoŋ embaga goo mirinoŋ kawaati, ii saanoŋ kotuegoŋ muro iinoŋ mono Reizel ano Lea yoroo so koloowaa. Yoronoŋ Jeikobwaanoŋ meraboraaŋa mamaga qokoloori Israel kanatuurunananoŋ kolooro. Gii saanoŋ Efrata balonoŋ jotameme eja esuhinawo kolooŋ Betlehem taonoŋ qabuŋagawo laligowa. ");
INSERT INTO ksr_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Poŋnoŋ emba malo saraŋ iwaanoŋa gbili gombaati, goonoŋ kanageso yoŋonoŋ mono Juuda ano Taamar yoroo meragara Perezwaanoŋ sumaŋ yoŋoo so kolooŋ laligowu.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Kaeŋ ama Boaznoŋ Ruut wama mirianoŋ kema embiaga mero Poŋnoŋ kotuegoŋ muro koro ama meraga mero. ");
INSERT INTO ksr_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Meraga mero emba yoŋonoŋ Naomiwaa kokaeŋ jegi: “Nono Poŋ mepeseejoŋ. Iinoŋ kete isigaa dowe meme ejaga gonja. Iinoŋ saanoŋ galeŋ koma goma laligowaa. Mera kanoŋ Israel uutanoŋ qaqabuŋayawo koloowaa. ");
INSERT INTO ksr_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Goo eŋaroganoŋ jopagoŋ gomakeja. Goo merauruga 7 laligowuyagati eeŋ, iinoŋ mono ii kuuya uŋuuguŋ ilaaŋ goma laligoja. Iinoŋ kete esaga gono iinoŋ mono laaligoga tililuaaŋ keraqeeaŋgo qeŋ goma laligowaa. Kanageŋ emba waŋa koloona iinoŋ saanoŋ galeŋ koma gono laligowaga.” ");
INSERT INTO ksr_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Kaeŋ jegi Naominoŋ mera ii meŋ dooŋgoŋ galeŋ koma muŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Emba kosianoŋ laligogiti, iyoŋonoŋ kokaeŋ jegi: “Naomiwaanoŋga esia meraga kolooja.” Kaeŋ jeŋ qata Obed qagi. Obedwaa meria Jesi, esia kiŋ Deiwid. ");
INSERT INTO ksr_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Qa areŋ koi ii Perezwaanoŋga kanaiŋ nama Deiwidwaanoŋ uja: Perezwaa meria Hezron, ");
INSERT INTO ksr_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hezrombaa meria Raam. Raambaa meria Aminadab. ");
INSERT INTO ksr_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadabwaa meria Naason. Naasombaa meria Salmon. ");
INSERT INTO ksr_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmombaa meria Boaz. Boazwaa meria Obed. ");
INSERT INTO ksr_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obedwaa meria Jesi. Jesiwaa meria kiŋ Deiwid. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Israel kanoŋ Pombaanoŋ qaa ii Amitai iwaa meria Joonawaanoŋ kokaeŋ kolooro: ");
INSERT INTO ksr_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Assiria kantriwaa siti somata Niiniwe ii weeŋ koukoutanoŋ eja. Yoŋonoŋ bao jaagoo kaaŋa kolooŋ kileŋagia lansaŋ nama meŋ tintuaŋ laligoŋkeju. Iikawaa qaaya ii noo jaasewananoŋ kouro mojeŋ. Kawaajoŋ gii mono waama eu kema noo buŋa qaana iŋijoŋ uugia kuuwa.” ");
INSERT INTO ksr_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Kaeŋ ijoroto, Joonanoŋ Pombaa jaasewaŋanoŋga oloŋ kok koma weeŋ kemekemetanoŋ baageŋ kemambaajoŋ keno. Kema gomaŋ qata Jopa (Jaffa) kanoŋ kemeŋ waŋgo moŋ mokolooŋ jero, “Yoŋowo saanoŋ Tarsis gomanoŋ Spein kantrinoŋ kemaŋa.” Kaeŋ jeŋ kana sewaŋa meŋ waŋgonoŋ uro. Kaeŋ uma Pombaa jaasewaŋanoŋga kokomomola meŋ keno. ");
INSERT INTO ksr_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Kenoto, Poŋnoŋ haamo kotakota wasiro kowenoŋ kemeŋ kuuro siri dimboŋ somata waama waŋgo qero jaŋgomambaajoŋ ano. ");
INSERT INTO ksr_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Kaeŋ kolooro waŋgo gawoŋ eja yoŋonoŋ toroko moma iyaŋgiaa beŋurugiaa so aŋa aŋa qama kooliŋ oŋoŋgi. Kaeŋ ama waŋgonoŋ afaaŋgowaatiwaajoŋ kawaa hina iwoi kuuya meŋ borogi kowenoŋ kemeroto, Joonanoŋ waŋgo dutaa uutanoŋ kemeŋ iikanoŋ oloŋ koma gaoŋ komunagbiili ero. ");
INSERT INTO ksr_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Iikanoŋ ero waŋgo galeŋanoŋ iwaanoŋ kaŋ kokaeŋ jeŋ muro: “Gii mono naambaajoŋ koi gaoŋ ejaŋ? Mono waama geeŋgaa beŋga qama koolina iinoŋ ilaaŋ nonono mende tiwilaawonaga.” ");
INSERT INTO ksr_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Kaeŋ jeŋ muŋ batugianoŋ amiŋ moma jegi: “Ayo, mono kawu! Mono unju kuuwoŋa. Eja morowaa siŋgisoŋgoyaajoŋ ama iimaleiŋ koi qanananoŋ uji, iikawaa kania mokoloowoŋa.” Kaeŋ jeŋ unju kuugi Joona asugiro. ");
INSERT INTO ksr_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Asugiro jegi karo kokaeŋ qisiŋ mugi: “Iimaleiŋ tiwitiwilaa koi ii morowaa siŋgisoŋgoyaajoŋ ama qanananoŋ uji, gii mono iikawaa kania ninijowa. Gii naa gawoŋa meŋkejaŋ? Gii daaŋkaya kajaŋa? Goonoŋ kantri ii daeŋ? Goo kanagesouruga ii dakanoŋ laligoju?” ");
INSERT INTO ksr_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Kaeŋ qisiŋ mugi kokaeŋ meleeno: “Nii Israelga. Hibruu ejaga koloojeŋ. Nii Poŋ, Siwewaa Anutuya waeya meŋ mepeseeŋkejeŋ. Iinoŋ kowe ano namo toboga mokolooŋ orono. ");
INSERT INTO ksr_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Iinoŋ gawoŋ osiqosiawo nono togoŋ Pombaa jaasewaŋanoŋa oloŋ kok koma kajeŋ.” Kaeŋ meleeno moma aaruŋ lalaŋaniŋ kokaeŋ ijoŋ jeŋ mugi: “Yei! Gii mono naambaajoŋ ama kaeŋ anjaŋa?” ");
INSERT INTO ksr_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Kowenoŋ toroqeŋ boliŋ kotiiŋ qindiiŋ ero. Kawaajoŋ kokaeŋ qisiŋ mugi: “Nono mono iwoi nomaeŋ ama goniŋ iroŋa mena kowenoŋ goroŋ qenaga?” ");
INSERT INTO ksr_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Kaeŋ qisiŋ mugi kokaeŋ meleema iŋijoro: “Siri dimboŋ koi mono noojoŋ ama qanananoŋ uma qeji, niinoŋ ii moma kotojeŋ. Kawaajoŋ mono nii noma kowenoŋ borogi kemebe goroŋ qewaa.” ");
INSERT INTO ksr_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Kaeŋ meleeno gawoŋ eja yoŋonoŋ kileŋ waŋgo mombo namo goraayanoŋ keubaatiwaajoŋ loqanoŋ naŋgoŋ qeŋ bimbiŋgogito, kowenoŋ bolidaborotiwaajoŋ ama amamaagi. ");
INSERT INTO ksr_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Amamaaŋ Israel Poŋnanaa qata kokaeŋ qama kooligi: “Oo Poŋ, mono geeŋgaa qaa joga otaaŋ iwoi koi anjaŋ. Kawaajoŋ Poŋ, eja koi komuwaatiwaajoŋ ama mono mende tiwilaaŋ nonomba. Sayaa qaaya ii mono nonoo qanananoŋ mende ana uba. Qaa ii oŋanoŋ.” ");
INSERT INTO ksr_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Kaeŋ qama kooliŋ kema Joona meŋ borogi kowenoŋ kemero. Kemero kowewaa usuŋanoŋ iikanoŋadeeŋ kamaaro boŋ qero. ");
INSERT INTO ksr_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Boŋ qero eja yoŋonoŋ Anutuwaajoŋ aaruŋ lalaŋaniŋ nanduŋ somata ama Poŋ siimoloŋ ooŋ muŋ qaagia kokaeŋ somoŋgogi: “Anana mono Pombaanoŋ qaa apaŋa teŋ koma laligowoŋa.” ");
INSERT INTO ksr_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Joonanoŋ kowenoŋ kemero Poŋnoŋ sara somata moŋ wasiro kema Joona gogoro. Gogoro sara iikawaa uutanoŋ weemboria karooŋ eŋ laligoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Joonanoŋ sara uutanoŋ eŋ Poŋ Anutuya qama kooliŋ muŋ ");
INSERT INTO ksr_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","kokaeŋ ijoro: “Oo Poŋ, nii kokojinjiŋ uutanoŋ qama kooliŋ gombe gii qaana moma leeya meleemba. Nii koomuwaa senjoŋ dusiitanoŋ eŋ komuŋ tagoŋ welema gombe gii geja ama jejewelenwelena mojaŋ. ");
INSERT INTO ksr_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Gii monago kowe biiwi jabiriŋanoŋ (jauŋanoŋ) hagoŋ noŋgi kamaaŋ ejeŋ. Geeŋgo riiwagoŋ nona gomaŋ siŋsiŋgoyaa dutanoŋ kamaabe gboulu somatanoŋ esuuŋ nonja. Goo apu kokopa kuuya ii musuluŋgoŋ nonja. Goo kowe siriga ii turuŋ neŋ olaaŋ nonja. ");
INSERT INTO ksr_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Nii kokaeŋ romoŋgojeŋ: Gii geeŋgaa jaasewaŋganoŋa konjoma nona sooŋ tintuaŋ ejeŋ. Ii kileŋ nii mombo jaananoŋ goo jiwowoŋ jigo kowogaageŋ uuwe keno jejeromoŋromoŋ anjeŋ. ");
INSERT INTO ksr_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Apu ano omanjareya ii qananoŋ uma turuŋ nondaboroja. Kowe biiwi jauŋagadeeŋ liligoŋ nondaboroja. Kowewaa tokoleya ii jamojuju kaaŋa waŋna momosiiŋ esuuja. ");
INSERT INTO ksr_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Nii kowe biiwi jauŋaa dusiitanoŋ koi kanoŋ uluŋgoŋ kamaajeŋ. Kowe biiwi jauŋaa jaa unuŋa ii koŋgi pondaŋ qananoŋ eu somoŋgoŋ nonja. Oo Poŋ Anutuna, nii koi laligojento, gii mono koomuwaa senjoŋ dusiita koi kanoŋa gou koma nona saanoŋ mombo laaligonoŋ koumaŋ. ");
INSERT INTO ksr_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","“Noo laaligonanoŋ qaomambaajoŋ ano kambaŋ koi kanoŋ oo Poŋ, nii romoŋgoŋ gombe qamakoolinanoŋ keuma goo Siwe jigo kowoganoŋ eu uma gejaganoŋ kemebaati, ii mojeŋ. ");
INSERT INTO ksr_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","“Ejemba gadokopa beŋ lopioŋ omaya goda qeŋ usugoŋ oŋomakejuti, iyoŋonoŋ kaeŋ ama kaleŋmoriaŋ Toya gii gema guŋkejuto, ");
INSERT INTO ksr_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","nii mono mepemepesee ooŋsaa qama mamatewoo ama siimoloŋ ooŋ gomambaajoŋ mojeŋ. Nii iwoi amambaa qaa jeŋ somoŋgobeti, iikawaa so mono ama sorogoŋkemaŋa. Oo Poŋ, gii gou koŋkoŋ Tona koloojaŋ. Qaa ii oŋanoŋ.” ");
INSERT INTO ksr_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Kaeŋ qama kooliro Poŋnoŋ sara ii jeŋ kotoŋ muro kaŋ kouma Joona lono namo toboganoŋ kamaaro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Namo toboganoŋ kamaaro Pombaanoŋ qaa koi ii mombo Joonawaanoŋ kolooro: ");
INSERT INTO ksr_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Giinoŋ mono waama siti somata Niiniwe kanoŋ kema Buŋa qaa gomaŋati, ii iŋijoŋ uugia kuuwa.” ");
INSERT INTO ksr_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Qaa kaaŋa kolooro Joonanoŋ waama Pombaa qaa jeta teŋ koma Niiniwe keno. Niiniwe sitiwaa soya ii kokaeŋ: Gii goraayanoŋa kanaiŋ kema laligona weeŋ karooŋ tegoro teegeŋ endu keubaga. ");
INSERT INTO ksr_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Joonanoŋ kanaiŋ siti uutanoŋ kema laligoro weeŋ motooŋgo tegoro buŋa qaa qama kokaeŋ iŋijoro: “Weemboria 40 mombo eja. Ii tegoro Niiniwe siti koi mono meleeno kemebaa.” ");
INSERT INTO ksr_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Qaa kaeŋ qama iŋijoŋ keno Niiniwe kanatuuru yoŋonoŋ Anutuwaanoŋ buzu qaa ii moma laariŋ uugia meleema nene siŋgi laligowombaa kambaŋ koma jeŋ kotiigi. Ii jeŋ kotiiŋ ejemba somata melaa korebore yoŋonoŋ uumeleembaa samo megi selegianoŋ uro too arigi. ");
INSERT INTO ksr_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Kaeŋ aŋgi iikawaa buzu qaaya ii Niiniwewaa kiŋ (praim minista) iwaanoŋ keuro. Keuro moma jiŋkaroŋ duŋ rarayanoŋga kamaaŋ malekuya kotogoŋ samo meŋ aturaaŋ too utuŋ ariŋ raro. ");
INSERT INTO ksr_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Rama jeŋkooto kokaeŋ ano Niiniwe siti sokondaboroŋ keno: “Oŋo mono kiŋ ano jawiŋuruta nonoonoŋ jeŋkooto koi mobu: Moŋnoŋ mono nene qaaŋ mende newa. Ejemba me bao kuru, lama bulmakao, oŋonoŋ nene qaaŋ newombaajoŋ mende moma oŋombu. ");
INSERT INTO ksr_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Nene siŋgi kaeŋ laligoŋ samo medaboroŋ Anutu kotakotagadeeŋ saama qama kooliŋ muŋ aŋa aŋa kaniagia bologa ii mesaowu! Ejemba uŋuŋ tiwilaaŋ oŋoŋgi sagianoŋ borogia tilooŋ eji, sili ii mono gema qedaborowu. ");
INSERT INTO ksr_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Kaeŋ aniŋ Anutunoŋ iriŋsooŋsooŋaa uugeria qelanjiŋ siŋgisoŋgonana mesaonaga. Ii mesaoro mende tiwilaawonaga. Kaeŋ jejoŋ.” ");
INSERT INTO ksr_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Ii moma asariŋ kaniagia bologa gema qeŋ uugia meleeŋgi Anutunoŋ nanamemeŋgia ii iima wosoya moma oŋoma roromoŋgoya eleeno siŋgisoŋgogiaa iroŋa meleema oŋomambaajoŋ moroti, ii mesaoro. Uutanoŋ kaeŋ kamaaro mende meŋ kileeŋ oŋono. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Kaeŋ kolooroto, Joonanoŋ iikawaajoŋ uubooli somata moma iriŋa soono. ");
INSERT INTO ksr_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Iriŋa soono Poŋ welema muŋ kokaeŋ ijoro: “Ae! Poŋ, gii kiaŋkoomuwaa beŋa laligoŋ saanoŋ niniima kobooŋkejaŋ. Goo kaleŋmoriaŋga ii honoŋa qaa ero iriŋga ii uulaŋawo mende sooŋkeja. Kaeŋ uuga uulaŋawo olomooro wosomomo ama kanageso moŋ meŋ kileeŋ oŋomambaajoŋ mende momakejaŋ. Ii neenaa gomanoŋ laligoŋ moma yagoŋ gijoweti, ii duduujaŋ me qaago? Kania kawaajoŋ ama kambaŋ kanoŋ “Tarsis kemaŋa,” jeŋ uulaŋawo kokomomola meŋ kema laligowe. ");
INSERT INTO ksr_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Kete jaawo laligomambaajoŋ togoŋ koomunaajoŋ uuguŋ mobe awaa kolooja. Kawaajoŋ Poŋ, gii mono laaligona doloda koi nuamba. Qaa ii oŋanoŋ.” ");
INSERT INTO ksr_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Kaeŋ welenoto, Poŋnoŋ kokaeŋ meleema ijoro: “Joona, gii kiaŋkoomuwaajoŋ iriŋsooŋsooŋ mojaŋi, ii sokonja me qaago?” ");
INSERT INTO ksr_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Kaeŋ ijoro Joonanoŋ siti mesaoŋ kamaaŋ weeŋ koukoutanoŋ baageŋ kema kana goraayanoŋ endu kuuŋ qeŋ iikawaa umuganoŋ raro. Rama sitiwaajoŋ kaeŋ me kaeŋ koloowaati, ii iimambaajoŋ uuŋ uuŋ raro. ");
INSERT INTO ksr_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Kaeŋ raroto, Poŋ Anutunoŋ Joona keraqeeaŋgo qeŋ mumambaajoŋ moma jero aloŋaloŋ moŋ asugiŋ koriŋ kouma Joonawaa waŋa aoŋ koma muro. Aoŋ koma muro aloŋalombaajoŋ keraqeeaŋgo somata moma raro. ");
INSERT INTO ksr_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Rama gomantiiŋa moŋ ero gomaŋ ano kanoŋ Anutunoŋ taroŋ moŋ wasiro kaŋ aloŋaloŋ ii kiririiro seŋa sooliro. ");
INSERT INTO ksr_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Weeŋnoŋ kouro Anutunoŋ jero haamo geriawo totooŋ ii gomaŋ jaaya koukoutanoŋga qero weeŋ jaayanoŋ waŋanoŋ kuuro kuuro iriŋa soono komumambaajoŋ moma moŋgandaboroŋ qama kooliŋ kokaeŋ jero: “Nii laligomambaajoŋ togoŋ komumambaajoŋ mobe afaaŋa kolooja. Qaa ii oŋanoŋ.” ");
INSERT INTO ksr_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Kaeŋ jeroto, Anutunoŋ Joona kokaeŋ ijoro: “Gii aloŋalombaajoŋ iriŋga soonji, ii sokonja me qaago?” Kaeŋ ijoro kokaeŋ meleeno: “Irina soonji, ii mono sokonjaa. Noo iriŋsooŋsoona ii somata kolooro uunanoŋ mende olomoowaa. Kawaajoŋ saanoŋ komumaŋa. Qaa ii oŋanoŋ.” ");
INSERT INTO ksr_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Joonanoŋ kaeŋ meleeno Poŋnoŋ kokaeŋ ijoro: “Gii aloŋalombaa gawoŋa moŋ mende meŋ ii mende galeŋ kona koriro. Ii gomantiiŋa motooŋgowaa uutanoŋ asugiro ano gomantiiŋa motooŋgowaa uutanoŋ sooliŋ komuro. Kileŋ geeŋgo iwoi omaya kaaŋa iikawaajoŋ ama saama majakaka mojaŋ. ");
INSERT INTO ksr_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Kaeŋ kolooro nii mono nomaembaajoŋ siti somata kokawaa kanatuuruya yoŋoojoŋ majakaka mende mobenaga? Iikawaa uutanoŋ ejemba 120.000 (handet twenti tauseŋ) jaŋgo ii uuguŋ laligojuti, ii awagaa ano bologaa kanagara mende moma gosiŋ oromakejuti ano bao kuru iwoi ii kaaŋiadeeŋ keleŋmaleleŋ laligoju. Ii ejemba yoŋowo kaaŋgadeeŋ meŋ kileeŋ oŋomambotiwaajoŋ ama mono uuaiŋnanoŋ Niiniwe iŋiima koboojeŋ.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jiisas Kraistwaa ambosakoŋa yoŋoo qa areŋgia ii kokaeŋ: Aabrahambaa gbili moŋ Deiwid. Deiwidwaa gbili moŋ Jiisas. ");
INSERT INTO ksr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aabrahambaa meria Aisak. Aisakwaa meria Jeikob. Jeikobwaa merauruta Juuda ano iwaa daremuŋuruta. ");
INSERT INTO ksr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juudawaa merawoita Perez ano Zera, nemuŋgara Taamar. Perezwaa meria Hezron. Hezrombaa meria Ram. ");
INSERT INTO ksr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rambaa meria Aminadab. Aminadabwaa meria Naason. Naasombaa meria Salmon. ");
INSERT INTO ksr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmombaa meria Boaz, nemuŋa kantri mombaa embiaga Raahab. Boazwaa meria Oobed, nemuŋa kantri mombaa embiaga Ruut. Oobedwaa meria Jesi. ");
INSERT INTO ksr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesiwaa meria kiŋ Deiwid. Deiwidwaa meria Solomon, nemuŋa wala Uriawaa embiaga laligoro. Juuda kiŋ kuuya ii Deiwidwaa gbiliuruta kolooŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomombaa meria Rehoboam. Rehoboambaa meria Abija. Abijawaa meria Asa. ");
INSERT INTO ksr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asawaa meria Jehosafat. Jehosafatwaa meria Jehoram. Jehorambaa meria Usia. ");
INSERT INTO ksr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiawaa meria Jootam. Jootambaa meria Aahaz. Aahazwaa meria Hezekia. ");
INSERT INTO ksr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiawaa meria Manase. Manasewaa meria Aamon. Aamombaa meria Joosia. ");
INSERT INTO ksr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Joosiawaa merauruta Jekonia ano iwaa daremuŋuruta. Kambaŋ iikanoŋ Babilon yoŋonoŋ Israel kanageso uŋuaŋgi Babilon kema kapuare miri laaligo tani kaaŋa weleŋqeqegiaga laligogi. ");
INSERT INTO ksr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babilon kapuare miri laaligo tani kaaŋa laligoŋ iikanoŋ Jekoniawaa meria Sealtiel kolooro. Sealtielwaa meria Jerubaabel. ");
INSERT INTO ksr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jerubaabelwaa meria Abiud. Abiudwaa meria Eliakim. Eliakimbaa meria Azor. ");
INSERT INTO ksr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorwaa meria Jaadok. Jaadokwaa meria Akim. Akimbaa meria Eliud. ");
INSERT INTO ksr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudwaa meria Eleazar. Eleazarwaa meria Matan. Matambaa meria Jeikob. ");
INSERT INTO ksr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jeikobwaa meria Joosef, Mariawaa loya. Marianoŋ Jiisas merota qata Kraist Hamoqeqe Toya jeŋkejoŋ. ");
INSERT INTO ksr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kambaŋ Aabrahambaanoŋga kanaiŋ laligoŋ kougi kiŋ Deiwid kolooroti, isi iyoŋoo jaŋgo areŋgia ii 14. Mombo kiŋ Deiwidwaanoŋga kanaiŋ laligoŋ kougi Israel kanageso uŋuaŋgi Babilon kema kapuare miri laaligo tani kaaŋa laligogiti, isi iyoŋoo jaŋgo areŋgia ii kaaŋagadeeŋ 14. Babilon kapuare miri laaligo tani kaaŋa laligogiti, kambaŋ iikanondeeŋ kanaiŋ laligoŋ kougi Kraist kolooroti, isi iyoŋoo jaŋgo areŋgia ii kaaŋagadeeŋ 14. ");
INSERT INTO ksr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jiisas Kraist koloorotiwaa sunduya ii kokaeŋ: Iwaa nemuŋa Maria ii Joosefwaa buŋaga laligoŋ mende mindiriŋ aoŋ laligori kambaŋ iikanoŋ Uŋa Toroyanoŋ meŋ letoma muro korowo laligoro kania mokoloogi. ");
INSERT INTO ksr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kaeŋ mokoloogi eja buŋaya Joosef iinoŋ laaligo dindiŋa laligorotiwaajoŋ Mariawaa kanianoŋ asuganoŋ asugiro gamuyawo koloowaatiwaajoŋ togoro. Kaeŋ togoŋ uutanoŋ ii oloŋ mesaomambaa momo areŋa ano. ");
INSERT INTO ksr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kaeŋ romoŋgoŋ ero Pombaa gajoba moŋnoŋ gaonoŋ asugiŋ muŋ kokaeŋ ijoro, “Joosef Deiwidwaa gbili, Uŋa Toroyanoŋ mono Maria meŋ letoma muro koroyawo laligoja. Kawaajoŋ gii mono ii wama miriganoŋ kaŋ embaga koloowaatiwaajoŋ toroko mende moba. ");
INSERT INTO ksr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Marianoŋ koko meraga mewaa. Eja iikanoŋ kanagesoya siŋgisoŋgogianoŋga hamo qeŋ oŋono solaŋaniwuya. Kawaajoŋ giinoŋ mono qata Jiisas qaba.” Kaeŋ ijoro. ");
INSERT INTO ksr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Poŋnoŋ gejatootoo eja moŋ sololooro qaa moŋ jeroti, iikanoŋ hoŋawo koloowaatiwaajoŋ iwoi kuuya ii kolooro. Gejatootoo qaa ii kokaeŋ, ");
INSERT INTO ksr_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Emba saraŋ jumuŋa moŋnoŋ koroyawo kolooŋ mera ejaga mero qata Imanuel qabuya.” Qa iikawaa kania ii kokaeŋ, “Anutunoŋ ananawo laligoja.” ");
INSERT INTO ksr_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joosefnoŋ uuta tooro waama Pombaa gajobanoŋ jeŋ kotoŋ muroti, iikawaa so ama Maria embia koloowaatiwaajoŋ wama mirianoŋ keni. ");
INSERT INTO ksr_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kema laligorito, kambaŋ biiwianoŋ iikanoŋ motooŋ mende eri kema meria mero Joosefnoŋ qata Jiisas qaro. Mera mero iikawaa gematanoŋ loemba laligori. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jiisasnoŋ eja poŋ Herodwaa kambanoŋ Judia prowinswaa taoŋa moŋ qata Betlehem kanoŋ kolooro. Kolooroti, kambaŋ kanoŋ seŋgelaowaa momo eja weeŋ koukoutanoŋga Jerusalem sitinoŋ kagi. ");
INSERT INTO ksr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Kaŋ kokaeŋ qisigi, “Juuda oŋoonoŋ eja poŋ koloowaati, mera ii kolooŋ dakanoŋ eja? Nono weeŋ koukoutanoŋ laligoŋ iwaanoŋ widi asugiro iima kania kaeŋ moma waeya meŋ mepeseewombaajoŋ kajoŋ.” ");
INSERT INTO ksr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kaeŋ qisigi eja poŋ Herod ano Jerusalem kanageso iwo laligogiti, iyoŋonoŋ korebore qaa ii moma aarugi. ");
INSERT INTO ksr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Aarugi kiŋ Herodnoŋ qaa ama kanagesowaa jigo gawoŋ galeŋ waŋa ano Kana qaawaa boi kuuya koma horoŋ oŋono kagi. Kaŋ ajoroogi kokaeŋ qisiŋ oŋono, “Hamoqeqe Toya Kraistnoŋ mono dakanoŋ koloowaatiwaajoŋ jegita eja?” ");
INSERT INTO ksr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Qisiŋ oŋono kokaeŋ meleema mugi, “Iinoŋ Judia prowinswaa taoŋ qata Betlehem iikanoŋ koloowaa. Iikawaa qaaya ii gejatootoo eja Maikanoŋ kokaeŋ oorota eja, ");
INSERT INTO ksr_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Oo Betlehem kanageso Juuda gomanoŋ laligojuti, oŋoo batugianoŋga poŋ somata kolooŋ neenaa Israel kanageso mindiŋgoŋ kalaŋ koma nonombaa. Kawaajoŋ oŋo Juuda gomambaa jotamemeya yoŋoo batugianoŋ laligogi qabuŋagianoŋ kamaaŋqeqeta mende toontooŋ koloowaa.’” ");
INSERT INTO ksr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kaeŋ meleema mugi momakooto eja ii oloŋ oŋoono kagi kokaeŋ qisiŋ oŋono, “Widia ii naa kambanoŋ asugiro kanaiŋ iigi?” Iikawaa kania tororo momambaajoŋ moma kaeŋ qisiŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Iikawaa qaaya moma wasiŋ kokaeŋ jeŋ kotoŋ oŋono, “Oŋo mono Betlehem kema mera ii tororo qisiŋ mokolooŋ iikanondeeŋ buju qaa aŋgi noonoŋ kawa. Niinoŋ ii moma kaaŋiadeeŋ kema ii waeya meŋ mepeseeŋ mumaŋa.” ");
INSERT INTO ksr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kiŋnoŋ kaeŋ iŋiijoŋgoŋ jeŋ kotoŋ oŋono moma kananoŋ keŋgi. Kema widi weeŋ koukoutanoŋ laligoŋ iigiti, iikanoŋ waŋgianoŋ waladeeŋ keno kosiŋ otaaŋ Betlehem kema miri koko mera eroti, iikanoŋ nano. ");
INSERT INTO ksr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Widi ii nano iima korisoro somata qatawo mogi. ");
INSERT INTO ksr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Korisoro moma miri uutanoŋ uma mera ano nemuŋa Maria iriigi. Ii iriima simiŋ kuma usugoŋ waeya meŋ mepeseeŋ mugi. Mepeseeŋ muŋ wayaŋgesogia qeŋgama iikanoŋga goul, jiniŋ paora ano sanda qata mor ii unjuma kaleŋ mugi. ");
INSERT INTO ksr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Gomantiiŋa moŋ egi Anutunoŋ gaonoŋ asugiŋ kiŋ Herodwaanoŋ mombo mende kembutiwaajoŋ qotogoŋ oŋono. Kawaajoŋ kana moŋgeŋ iyaŋgiaa gomaŋ baloŋgianoŋ eleema keŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Momakooto eja yoŋonoŋ keŋgi Joosefnoŋ gaoŋ iiro Pombaanoŋ gajoba moŋnoŋ asugiŋ muŋ kokaeŋ ijoro, “Herodnoŋ mera qero komuwaatiwaajoŋ moŋgama mubaa. Kawaajoŋ mono waama mera ano nemuŋa uruama oloŋ koma Iijipt kantrinoŋ kembu. Iikanoŋ kema laligogi kanageŋ niinoŋ kawutiwaa kambaŋ jemaŋati, iikanoŋ mono eleema kawu.” ");
INSERT INTO ksr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kaeŋ ijoro waama gomantiiŋa iikanondeeŋ koko mera ano nemuŋa uruama Iijipt keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Iijipt kema laligogi kiŋ Herodnoŋ komuro kambaŋ iikanondeeŋ eleema kagi. Wala Poŋnoŋ gejatootoo eja Hoosea sololooro qaa kokaeŋ jerota eja, “Niinoŋ merana oombe Iijipt gomaŋ mesaoŋ karo.” Gejatootoo qaa iikanoŋ mono kaeŋ asugiro hoŋawo kolooro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Momakooto eja yoŋonoŋ Juuda gomaŋ oloŋ mesaoŋ keŋgi Herodnoŋ iikawaa kania iima “Tiligoŋ noŋgi,” jeŋ iriŋa mamaga soono jeŋkooto kokaeŋ ano, “Manjaqeqe eja, oŋo Betlehem ano gomaŋ kuuya ii liligoŋ raji, iikanoŋ kema mera gbanigia woi ano iikawaa baatanoŋ koloojuti, ii mono kuuya uŋugi komuwu.” Momakooto eja widi asugirotiwaa kambaŋaajoŋ tororo qisiŋ oŋono ijogiti, iikawaa so mera gbanigiaajoŋ jeŋkooto ii ano. ");
INSERT INTO ksr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Gejatootoo eja Jeremaianoŋ qaa moŋ jerota eji, iikanoŋ mono kaeŋ asugiro hoŋawo kolooro. Qaa ii kokaeŋ, ");
INSERT INTO ksr_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Betlehem kosianoŋ gomaŋ moŋ qata Rama iikanoŋga saagujugia mogi qama silama amburereŋ somata meju. Reizel embawaa gbiliuruta yoŋonoŋ gbiliurugia qaoŋgi saaju. Kawaajoŋ saagi uluŋkoleŋ meŋ oŋombombaajoŋ aŋgi uukonduŋkonduŋgadeeŋ momakeju.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Joosefnoŋ Iijipt laligoro kiŋ Herodnoŋ komuro iikanondeeŋ Pombaanoŋ gajoba moŋnoŋ gaonoŋ asugiŋ muŋ ");
INSERT INTO ksr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","kokaeŋ ijoro, “Mera qegi komuwaatiwaajoŋ emboŋgiti, iyoŋonoŋ mono komudaborogi. Kawaajoŋ mono waama mera nemuŋawo uruama eleema Israel gomanoŋ kembu.” ");
INSERT INTO ksr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kaeŋ ijoro Joosefnoŋ waama mera nemuŋawo uruama eleema Israel gomanoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kananoŋ kema qaa kokaeŋ moro, “Herodwaa meria Arkelausnoŋ maŋaa kitianoŋ Judia prowins galeŋ koma laligoja.” Kaeŋ moma iikanoŋ kemambaajoŋ toroko moro. Moma laligoro Anutunoŋ gaonoŋ Galili prowinsnoŋ kembutiwaajoŋ jeŋ kotoŋ muro waama iikanoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galili prowinsnoŋ keuma taoŋ qata Nazaret iikanoŋ laligogi. Kaeŋ laligogi gejatootoo eja yoŋonoŋ Hamoqeqe Toyaajoŋ qaa jegiti, iikanoŋ hoŋawo kolooro. Qaa ii kokaeŋ, “Iwaa qata ii Nazaret ejaga qama laligowuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Gbani tosia tegoro Jon Oomulu ejanoŋ kaŋ Judia prowinswaa baloŋ qararaŋkoŋkoŋanoŋ liligoŋ ejemba uugia Buŋa qaanoŋ kuuŋ kokaeŋ iŋijoŋ laligoro, ");
INSERT INTO ksr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Siwe Toyanoŋ bentotoŋa ambaatiwaa kambaŋanoŋ mono kaŋ kuuja. Kawaajoŋ mono uugia meleema iikanoŋ keubu.” ");
INSERT INTO ksr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jombaajoŋ gejatootoo eja Aisaianoŋ qaa moŋ kokaeŋ jeŋ ooro, “Qele gajoba moŋnoŋ baloŋ qararaŋkoŋkoŋanoŋ qama laligoro kema qaa otoŋa kokaeŋ mobuya, ‘Poŋnoŋ kawa-oo! Kawaajoŋ mono jojoriŋ kania meleuwu. Mono uugia mindiŋgoŋ kania qeleleewu.’” ");
INSERT INTO ksr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jombaanoŋ selekopaa ii kamel juyanoŋ memetaga ano batuyanoŋ iiŋkasa oro selianoŋ memetaga ii somoŋgoŋ laligoro. Nembaneneya ii ŋaagiso borotaaŋ ano duuyaa moroŋ apuya. Ii kuuya gejatootoo eja Elaija iwaa soga. ");
INSERT INTO ksr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jonoŋ gawoŋa mero ejemba tuuŋlelembe yoŋonoŋ Jerusalem siti ano Judia prowinswaa gomaŋ tosaaŋa kuuya yoŋoonoŋga iwaanoŋ horoŋ kagi. Kaaŋiadeeŋ Jordan apu leelee gomaŋ kuuya rama keŋgiti, iikanoŋa kagi. ");
INSERT INTO ksr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kaŋ kouma siŋgisoŋgogia jokoloogi Jonoŋ ii Jordan apu bereŋanoŋ oomulu meŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Meŋ oŋonoto, Farisii (Kana qaawaa kaparaŋkoŋkoŋ) ano Sadusii (Jigo gawombaa kaparaŋkoŋkoŋ) ejemba tuuŋlelembe yoŋonoŋ oomulu meŋ oŋombaatiwaajoŋ kagi iŋiima kokaeŋ iŋijoro, “Oo qato mokolembaa gbiliuruta, oŋo uugia mende meleeŋgi Anutuwaa iriŋanoŋ mono soono iroŋa meleema oŋomambaajoŋ anja. Ii oloŋ kombombaa gejanono qaaya ii mono moronoŋ iŋijoro sombugia moma koi kaju? ");
INSERT INTO ksr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kawaajoŋ mono oŋanoŋ uugia meleembu. Kileŋagia mesaoŋ uugia meleeŋgi hoŋa kolooro ii mono nanamemeŋgianoŋ asuganoŋ qendeema laligowu. ");
INSERT INTO ksr_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Uugianoŋ mondomondo qaa kokaeŋ jewombaajoŋ mende romoŋgowu, ‘Nononoŋ Aabrahambaa gbiliga laligoniŋ Anutunoŋ mende tiwilaaŋ nonombaa.’ Kaeŋ jeŋ totogianoŋ qeŋkejuto, hoŋa ii mende kolooŋkeja. Niinoŋ iikawaajoŋ kokaeŋ iŋijomaŋa, Anutunoŋ jamo koi saanoŋ jeŋ kotoŋ oŋono letoma Aabrahambaa gbiliuruta kolooŋ Anutu mepeseeŋkebuto, oŋo nomaeŋ? ");
INSERT INTO ksr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Uugia mende meleembuti eeŋ, Anutunoŋ mono oŋo gere kaaŋa kono kamaawombaajoŋ anju. Gere kuuya hoŋa awaa mende kuuŋkejuti, ii mono kono kamaagi gere gagirinoŋ giliro kemebuya. Gere kaaŋa komambaa weŋa ii jeta suŋa ama gere kanianoŋ ano jojoriŋ eja. Anutunoŋ mono kileŋagiaa iroŋa meleema oŋombaa. ");
INSERT INTO ksr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Niinoŋ oŋo uugia meleembutiwaajoŋ apu tooŋnoŋ mulu meŋ oŋonjento, noo gemananoŋ eja ku-usuŋa kotakota moŋ kawaa. Iwaa ku-usuŋa uutaga ii mono noonoŋ uuguwaa. Iinoŋ eja uuta koloowaatiwaajoŋ niinoŋ iwaanoŋ kana esuya ilaaŋ muŋ gesonoŋ mouma besaamambaajoŋ amamaamaŋa. Iinoŋ mono Uŋa Toroya uugianoŋ ano gere bolaŋanoŋ koma konjoratiŋ oŋono iikaaŋa kanoŋ mulu meŋ oŋombaa. ");
INSERT INTO ksr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Iinoŋ hoŋa ano kaawoya mendeema oromambaa saraya meŋ kouma kosoŋ korereŋgoŋ gosiwaa. Gosiŋ wiit kota meŋ kululuuŋ kowianoŋ ambaato, kaawoya ano bulaaya ii mono usuno gere gagirinoŋ kemeŋ gere tetegoya qaa kanoŋ jewaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kambaŋ kanoŋ Jiisasnoŋ Galili prowins mesaoŋ Jordan apu bereŋanoŋ Jombaanoŋ kaŋ oomulu meŋ mubaatiwaajoŋ qisiro. ");
INSERT INTO ksr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Qisiroto, Jonoŋ qotogoŋ muŋ kokaeŋ ijoro, “Giinoŋ saanoŋ nii oomulu meŋ nonagato, giinoŋ siŋgisoŋgo mende ama mono nomaembaajoŋ noonoŋ kajaŋ?” ");
INSERT INTO ksr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kaeŋ ijoro Jiisasnoŋ kokaeŋ meleeno, “Kambaŋ kokaamba ii saanoŋ amba. Kaeŋ anjoti, iikanoŋ Anutunoŋ nanamemeŋ dindiŋa otaawombaa qaa jeroti, iikawaa hoŋa kolooro sokombaa.” Kaeŋ meleeno Jonoŋ moro sokono uumotooŋ ano. ");
INSERT INTO ksr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Uumotooŋ ama oomulu meŋ muro tegoro iikanondeeŋ apunoŋga kouro kokaeŋ asugiro: Sombinoŋ aantano Jiisasnoŋ uuŋ iiro Anutuwaa Uŋa Toroyanoŋ meleema kewo kooŋ kaaŋa kolooŋ Jiisaswaa waŋanoŋ kamaaŋ mero. ");
INSERT INTO ksr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kamaaŋ mero Siwenoŋga aro moŋ kokaeŋ kolooro, “Iinoŋ mono neenaa komunjua meranaga koloojiwaajoŋ kerana qeaŋgoro iimasiiŋa mojeŋ.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kawaa gematanoŋ Uŋa Toroyanoŋ Jiisas kuuŋ wasiŋ muro baloŋ qararaŋkoŋkoŋanoŋ Kileŋaa Toyanoŋ aŋgobato meŋ mubaatiwaajoŋ ama keno. ");
INSERT INTO ksr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kanoŋ kema gomantiiŋa asaga 40 Anutuwaajoŋ nene siŋgi laligoŋ nenewaa komuro. ");
INSERT INTO ksr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nenewaa komuro omejiilaŋ waŋgia qata aŋgobato Toya iinoŋ asugiŋ kokaeŋ ijoro, “Gii Anutuwaa Meria koloojaŋi eeŋ, gii mono esuŋga qendeema jamo koi jeŋ kotona letoma bered kolooro newa.” ");
INSERT INTO ksr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kaeŋ ijoroto, Jiisasnoŋ qaa kokaeŋ meleeno, “Qaago! Buŋa Terenoŋ qaa moŋ kokaeŋ oogita eja, ‘Nenenondeeŋ ejemba laaligo mende nonomakejato, Anutuwaa jetanoŋga qaa kaŋkeji, ii kuuya teŋ koniŋ iikanoŋ mono nunuagiro kotiiŋ laligowoŋa’.” ");
INSERT INTO ksr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kaeŋ ijoro Kileŋaa Toyanoŋ Jiisas wama Jerusalem siti toroya kanoŋ kema jiwowoŋ jigowaa waareŋanoŋ eu uma ano nano. ");
INSERT INTO ksr_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Kaeŋ nano kokaeŋ ijoro, “Gii Anutuwaa Meria koloojaŋi eeŋ, mono kokanoŋga luguŋ emu kemeba. Buŋa Terenoŋ qaa moŋ kokaeŋ oogita eja, ‘Anutunoŋ goojoŋ ama gajobauruta jeŋ kotoŋ oŋono saanoŋ kobibiigi kemeŋ jamonoŋ kanaga mende guŋ mijimiji ambaa.’ Kawaajoŋ kemeŋ mende tiwilaaŋ gombaa.” ");
INSERT INTO ksr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Kaeŋ ijoro kokaeŋ meleeno, “Qaago! Buŋa Terenoŋ qaa moŋ kaaŋagadeeŋ kokaeŋ eja, ‘Gii mono Poŋ Anutuga mende aŋgobato meŋ muba.” ’ ");
INSERT INTO ksr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kaeŋ meleeno Kileŋaa Toyanoŋ mombo wama baaŋa koriga paloŋpaloŋ moŋnoŋ uma namo kuuya yoŋoo kantri totoŋa totoŋa ano yoŋoo esuhina iwoigia damugiawo kuuya qendeema muro. ");
INSERT INTO ksr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Qendeema muŋ kokaeŋ ijoro, “Giinoŋ simiŋ kuma noma waena meŋ mepeseeŋ nombagati eeŋ, niinoŋ ilawoila kuuya koi mono togoŋ gombe buŋa qeŋ aoŋ galeŋ koma oŋomba.” ");
INSERT INTO ksr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kaeŋ ijoro Jiisasnoŋ kokaeŋ meleeno, “Qaago! Satan gii mono togowa. Buŋa Terenoŋ qaa moŋ kokaeŋ oogita eja, ‘Gii mono Poŋ Anutuga, ii motooŋgo simiŋ kuma muŋ waeya meŋ mepeseewa.” ’ ");
INSERT INTO ksr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kaeŋ meleeno Kileŋaa Toyanoŋ iikanondeeŋ Jiisas mesaoŋ togoro. Kaeŋ kolooro gajoba yoŋonoŋ kaŋ Jiisas ilaaŋ mugi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kawaa gematanoŋ Jon Oomulu eja kapuare mirinoŋ aŋgi raro Jiisasnoŋ ii moma Judia prowins mesaoŋ Galili keno. ");
INSERT INTO ksr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kema prowins iikanoŋ keuma gomaŋa Nazaret mesaoŋ Kaperneam kema laligoro. Kaperneam taoŋ ii Zebulun ano Naftali gomanoŋ Galili apu aŋgoŋ kooroŋanoŋ eja. ");
INSERT INTO ksr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iikanoŋ laligoŋ gawoŋa mero Anutunoŋ qaa moŋ gejatootoo eja Aisaia sololooro jeroti, iikanoŋ hoŋawo kolooro. Qaa ii kokaeŋ, ");
INSERT INTO ksr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ejemba Zebulun ano Naftali gomanoŋ Jordan leegeŋanoŋ laligogi batugianoŋ kana somata kowe waageŋ kema nanji, ii Juuda qaagoto, tuuŋ tosianoŋ Galili prowinsnoŋ laligojuti, ");
INSERT INTO ksr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","kanageso yoŋonoŋ paŋgamanoŋ laligoŋ asasaga somata iibuya. Koomunoŋ ejemba ii aŋgoŋ koma oŋono paŋgamaŋ gomanoŋ laligojuti, iyoŋoojoŋ mono gomaŋ weŋgeraŋ suluwaa.” ");
INSERT INTO ksr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jiisasnoŋ Kaperneam laligoŋ kambaŋ iikanondeeŋ kanaiŋ Buŋa qaa jeŋ asariŋ ejemba uugia kuuŋ kokaeŋ jeŋ laligoro, “Siwe Toyanoŋ bentotoŋa ambaatiwaa kambaŋa mono kaŋ kuuja. Kawaajoŋ mono siŋgisoŋgo laaligogia mesaoŋ uugia meleembu.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kaeŋ jeŋ liligoŋ laligoŋ Galili apu aŋgoŋ goraayanoŋ metetereeŋ kema daremuŋ woi Saimon qata moŋ Piito ano koga Andruu iriiro. Yoronoŋ sora hooro ejaga laligoŋ misagara apu aŋgonoŋ sora horowowaajoŋ giliŋ laligori. ");
INSERT INTO ksr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jiisasnoŋ iriima kokaeŋ irijoro, “Ejawoi, oro mono nii notaaŋ kari kuma orombe ejemba sora kaaŋa horoŋ oŋombao.” ");
INSERT INTO ksr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kaeŋ irijoro iikanondeeŋ misagara mesaoŋ kanaiŋ Jiisas otaaŋ keni. ");
INSERT INTO ksr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jiisasnoŋ yorowo boroŋa moŋ toroqeŋ kema mombo daremuŋ woi Zebediwaa merawoita Jeims ano Jon iriiro. Yoronoŋ maŋgara Zebediwo waŋgonoŋ rama misagia meagoŋ somoŋgoŋ laligogi iŋiima oroono. ");
INSERT INTO ksr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kaeŋ iŋiima oroono iikanondeeŋ waama waŋgo ano maŋgara mesaoŋ kanaiŋ Jiisas otaaŋ gematanoŋ keni. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jiisasnoŋ kema Galili prowins uutanoŋ kuuya liligoŋ qamakooli mirigianoŋ uma bentotombaa Oligaa Buŋaya jeŋ asariŋ uugia kuuŋ kuma oŋoma laligoro. Kaeŋ ama batugianoŋ ejemba ji ano jepajerepa kania kania iŋiro laligogiti, ii meŋ qeaŋgoŋ oŋoma laligoro. ");
INSERT INTO ksr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kaeŋ meŋ laligoro Jiisaswaa Buŋayanoŋ seiŋ Siria kantri uutanoŋ sokoma tuma keno. Kaeŋ tuma keno ii moma ji ejemba kuuya uŋuama iwaanoŋ kagi. Tosianoŋ ji wiji ano jepajerepa kania kania iŋiro laligogi. Tosianoŋ omejiilanoŋ uugianoŋ kemero qaamuuŋ me kokojinjimbo laligogi. Tosianoŋ tama kamaaŋ uŋuro pipinjo motoŋ sembeŋ aoŋ laligogi. Tosianoŋ selegiaa bakaya koomuya laligogi. Kaaŋa kaaŋa yoŋonoŋ Jiisaswaanoŋ kagi meŋ qeaŋgoŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kaeŋ ama oŋono iigitiwaajoŋ ejemba kanageso somata yoŋonoŋ Jiisaswaa gematanoŋ otaaŋ kagi. Tuuŋlelembe ii Galili prowins ano Ten-Taoŋ distriknoŋga kagi. Tuuŋ tosianoŋ Jerusalem siti ano Judia prowinswaa gomaŋ tosianoŋga kagi. Tuuŋ tosianoŋ Jordan apu leegeŋga kagi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jiisasnoŋ ejemba tuuŋ somata iŋiima baaŋanoŋ uma raro gowokourutanoŋ kouma liligoŋ mugi. ");
INSERT INTO ksr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Liligoŋ mugi kanaiŋ ejemba tuuŋa tuuŋa kuma oŋoma kokaeŋ jero: ");
INSERT INTO ksr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Daeŋ yoŋonoŋ iyaŋgiaajoŋ Anutuwaa jaanoŋ kamaaŋqeqeta kaaŋa mojuti, iyoŋonoŋ Siwewaa bentotoŋa buŋa qeŋ aowutiwaajoŋ mono simbawoŋawo kolooju. ");
INSERT INTO ksr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Daeŋ yoŋonoŋ jiŋgeŋ qama saajuti, Anutunoŋ ii uluŋkoleŋ oŋombaatiwaajoŋ mono simbawoŋawo kolooju. ");
INSERT INTO ksr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Daeŋ yoŋonoŋ gumbonjonjoŋ laligoŋkejuti, Anutunoŋ namo koi ii yoŋoo buŋa qeŋ oŋombaatiwaajoŋ mono simbawoŋawo kolooju. ");
INSERT INTO ksr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Daeŋ yoŋonoŋ Anutuwaa jaanoŋ solaŋaniwombaajoŋ kaparaŋ koma ii nene ano apuwaa kaaŋa komuŋ qenjeŋ qeŋ laligojuti, Anutunoŋ mono siiŋgia ii uŋuagiwaa. Kawaajoŋ yoŋonoŋ mono simbawoŋawo kolooju. ");
INSERT INTO ksr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Daeŋ yoŋonoŋ tosaaŋa kiaŋkomuŋ oŋomakejuti, Anutunoŋ ii kiaŋkomuŋ oŋombaatiwaajoŋ iyoŋonoŋ mono simbawoŋawo kolooju. ");
INSERT INTO ksr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Daeŋ yoŋoo uugianoŋ soraaya kolooji, iyoŋonoŋ saanoŋ Anutu iibuya. Kawaajoŋ iyoŋonoŋ mono simbawoŋawo kolooju. ");
INSERT INTO ksr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Daeŋ yoŋonoŋ luae qeŋkejuti, iyoŋoo qagia ii Anutuwaa meraboraaŋa qabuya. Kawaajoŋ iyoŋonoŋ mono simbawoŋawo kolooju. ");
INSERT INTO ksr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Anutunoŋ qaagia jeŋ tegoro solaŋanijutiwaajoŋ sisiwerowero ama oŋomakejuti, iyoŋonoŋ Siwewaa bentotoŋa buŋa qeŋ aowuya. Kawaajoŋ iyoŋonoŋ mono simbawoŋawo kolooju. ");
INSERT INTO ksr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ejembanoŋ oŋo noojoŋ ama uuqeqe qaa tokoroŋkota jeŋ oŋoma sisiwerowero ama qaa bologa kania kania selegianoŋ kuuŋ qoloŋmoloŋgoŋkejuti, oŋonoŋ mono simbawoŋawo kolooju. ");
INSERT INTO ksr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mobu, Anutunoŋ tawagia uuta Siwe gomanoŋ ano ejiwaajoŋ mono otokoriaŋ maama korisoro qaganoŋ laligowu. Ii kokaembaajoŋ: Gejatootoo ejemba wala laligogiti, ii sisiwerowero tania kaaŋiadeeŋ ama oŋoŋgi oŋonoŋ iyoŋoo gemagianoŋ asugiŋ iyoŋowo ororoŋ laligoju.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jiisasnoŋ jero, “Oŋo baloŋ ejemba yoŋoo sii tani koloojuto, sii naaŋanoŋ titiikota koloowaati eeŋ, ii mono nomaeŋ meagoniŋ mombo aiŋawo koloonaga? Iikawaa kania moŋ qaago. Toroqeŋ iwoi moŋ aniŋ mende sokombaato, ii kikisi kaaŋa giligi kemero ejembanoŋ ii kanagianoŋ riimemelaawuya. ");
INSERT INTO ksr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Oŋo baloŋa baloŋa yoŋoo kiwa kaaŋa kolooŋ laligoju. Siti moŋ baaŋanoŋ uma megi raji, iikanoŋ aasaŋgoyanoŋ ramambaajoŋ amamaaŋkeja. ");
INSERT INTO ksr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Moŋnoŋ kiwa ootiriŋ monjoŋ baatanoŋ mende ambaato, kiwawaa duŋ rarayanoŋ ano rabaa. Kaeŋ rama asariro ejemba miri uutanoŋ rajuti, mono kuuya iyoŋoo jaagia kuuro asasaga iimakebuya. ");
INSERT INTO ksr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","“Kaaŋiadeeŋ mono oŋoo asasagagia qendeeŋgi ejemba batugianoŋ asariro iimakebu. Ejembanoŋ nanamemeŋgia awaa iima kawaajoŋ Maŋgia Siwe gomanoŋ laligoji, mono ii mepeseeŋ muŋ laligowuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Niinoŋ Mooseswaanoŋ Kana qaa ano gejatootoo ejemba yoŋoonoŋ Buju Tere ii qewagomambaajoŋ ama mende kaŋ laligojeŋ. Iikaeŋ tondu mende romoŋgowu. Niinoŋ qewagomambaajoŋ qaagoto, qaa ii teŋ kondaborowe iikawaa hoŋanoŋ pondaŋ koloowaatiwaajoŋ ama kaŋ laligojeŋ. ");
INSERT INTO ksr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu, Mooseswaa Kana qaanoŋ tere melaaziliŋ moŋ me kirifi ooŋ-oombaa jimbolaŋa motooŋgo ii mende totooŋ aliwaato, qaa kuuya ii wala hoŋgiawo kolooro Siwe namo yoronoŋ goroŋ qewaota. ");
INSERT INTO ksr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","“Kawaajoŋ moŋnoŋ Kana qaawaa jeŋkooto melaada iikawanoŋga qaa moŋ koloŋaniŋ ejemba kaeŋ kuma oŋomakeji, iinoŋ Siwewaa bentotoŋanoŋ keuro qata melaada daaburuya qabuya. Kaeŋ qabuto, moŋnoŋ ii teŋ koma otaaŋ ejemba kaeŋ kuma oŋomakeji, iinoŋ Siwewaa bentotoŋ uutanoŋ keuro qata Somatanana qabuya. ");
INSERT INTO ksr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","“Niinoŋ iikawaa so kokaeŋ iŋijowe mobu: Oŋoo nanamemeŋgia solaŋa kanoŋ mono Kana qaawaa boi ano Farisii (Kana qaawaa kaparaŋkoŋkoŋ) yoŋoo siligia kaaŋa ororoŋ koloowabo. Siligianoŋ yoŋoo sili mamaga mende uuguwaati eeŋ, oŋonoŋ mono Siwewaa bentotoŋ uutanoŋ mende keubuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jiisasnoŋ toroqeŋ jero, “Oŋonoŋ wala eeŋanoŋ qaa moŋ kokaeŋ iŋijoŋkegi, ‘Ejemba moŋ mende qegi komuwa,’ ano ‘Moŋnoŋ kazia qero komuwaati, ii mono distrikwaa qaa jakeyanoŋ ooŋgi qaaya jeŋ tegowuya.’ ");
INSERT INTO ksr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","“Kaeŋ iŋijogito, niinoŋ qaa ii kokaeŋ jeŋ asariwe mobu: Moŋnoŋ aliawo aŋgowowo ama iriŋa soono yoŋ kazi anji, ii mono kaaŋagadeeŋ distrikwaa qaa jakeyanoŋ ooŋgi qaaya jeŋ tegowutiwaa so kolooja. Kaaŋiadeeŋ moŋnoŋ alia jejewili qaanoŋ jeŋ boliŋ ‘Gii nekoŋa uuga qaa koloojaŋ,’ jeji, ii mono kantriwaa jigo kaunsol yoŋoo jaagianoŋ ooŋgi qaaya jeŋ tegowutiwaa so kolooja. Moŋnoŋ alia qaa saganoŋ jeŋ boliŋ ‘Gii aŋgonjoragawo koloojaŋ,’ jeji, iinoŋ mono gere sianoŋ kemebaatiwaa so koloowaa. ");
INSERT INTO ksr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Kawaajoŋ giinoŋ mamatewoo nanduŋga meŋ kaŋ alatanoŋ amambaajoŋ ana iikanoŋ qaa kokaaŋanoŋ momoganoŋ kounaga: Alagaa uutanoŋ qaa ero iinoŋ kazi ama gomambaajoŋ moja. Qaa kaaŋa romoŋgowagati eeŋ, ");
INSERT INTO ksr_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","kaleŋga ii mono alata baatanoŋ ama wala alagaanoŋ kema iwo qaagara jeŋ solaŋaniŋ uumotooŋ ama iikawaa gematanoŋ mombo kaŋ mamatewoo nanduŋga Anutuwaajoŋ amba. ");
INSERT INTO ksr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kereganoŋ seleganoŋ kuuŋ qaa jakeyanoŋ horoŋ gomambaajoŋ ano komitiwaanoŋ kema kana somatanoŋ iikanoŋ mono kaparaŋ koma uumotooŋ ama qaagara jeŋ solaŋaniwao. Kaeŋ mende ambaoti eeŋ, kereganoŋ saanoŋ oroŋ gono (jas, majistreit) jenteego toyaa jaanoŋ keuna moma jero opotorowaa boronoŋ kena kapuare mirinoŋ goombabo. ");
INSERT INTO ksr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Gii iikanoŋ wantaaga kuuya ambaatiwaa so osiŋ rabaga. Toiyaga konoga kaaŋagadeeŋ andoboroŋgo mono wantaaga meŋ kamaawaga.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Qaa moŋ kokaeŋ iŋijoŋkegi, ‘Serowiliŋ mono mende amba.’ ");
INSERT INTO ksr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kaeŋ iŋijogito, niinoŋ qaa ii kokaeŋ jeŋ asariwe mobu: Moŋnoŋ serowaa siiŋ kombombaŋaa qaganoŋ emba uuŋ iiji, iinoŋ mono uutanoŋ iwo serowiliŋ anja. ");
INSERT INTO ksr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Jaaga dindiŋganoŋ siŋgisoŋgo ambaatiwaa koŋgoro ama gombaati eeŋ, ii mono qonjoma gilina kemba. Sele kitiga moŋnoŋ tiwilaaro kaaŋanoŋ Siwenoŋ una sokombaato, sele busuga jumuŋa laligona hagogi gere sianoŋ kemeŋ tiwilaawabo. ");
INSERT INTO ksr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Boro dindiŋganoŋ siŋgisoŋgo ambaatiwaa koŋgoro ama gombaati eeŋ, ii mono kotoŋ gilina kemba. Sele kitiga moŋnoŋ tiwilaaro Siwenoŋ una sokombaato, sele busuga jumuŋa laligoŋ gere sianoŋ kemeŋ tiwilaawabo.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Qaa moŋ kokaeŋ jegita eja, ‘Moŋnoŋ embia mesaowaati, iinoŋ mono mesaoŋ aoaowaa papiaya ooŋ embia muba.’ ");
INSERT INTO ksr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kaeŋ jegita ejato, niinoŋ kokaeŋ iŋijowe mobu: Moŋnoŋ embia oloŋkalu ano mesaonagato, kania mombaajoŋ embia mesaowaati, iikaaŋa kanoŋ mono embianoŋ oloŋkalu ambaatiwaajoŋ kondooŋ siŋgisoŋgowaa qaayawo koloonaga. Kaeŋ kolooro eja mombo mero eja dologa iikanoŋ mono kaaŋagadeeŋ oloŋkalu ambaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Qaa moŋ ii kaaŋagadeeŋ wala eeŋanoŋ kokaeŋ iŋijoŋkegi, ‘Qaagia jojopaŋ qaanoŋ jeŋ kotiigiti, ii mono mende uuguwu. Pombaajoŋ iwoi amboŋatiwaa qaaya jojopaŋ qaanoŋ jeŋ somoŋgogiti, ii mono otaagi hoŋawo koloowa.’ ");
INSERT INTO ksr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","“Kaeŋ iŋijogito, niinoŋ qaa ii kokaeŋ jeŋ asariwe mobu: Qaagia mono jojopaŋ qaanoŋ mende totooŋ jeŋ kotiiwu. Siwe ii Anutuwaa jiŋkaroŋ duŋa koloojiwaajoŋ ama qaa kokaeŋ mende jewu, ‘Qaa hoŋa mende jemaŋati eeŋ, Siwe Toyanoŋ saanoŋ iroŋa meleeno qananoŋ ubaa.’ ");
INSERT INTO ksr_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","“Namo ii Anutuwaa kaniaa doya koloojiwaajoŋ ama qaa kokaeŋ mende jewu, ‘Qaa hoŋa mende jemaŋati eeŋ, namonoŋ saanoŋ qeŋ turuŋ nomba.’ Jerusalem ii Kiŋ Tak-kootoyaa sitia koloojiwaajoŋ ama qaa koi kaaŋa ii kaaŋagadeeŋ mende jewu, ‘Qaa hoŋa mende jemaŋati eeŋ, Kiŋ Somata iinoŋ saanoŋ qemasologenaa iroŋa meleeno qananoŋ ubaa.’ ");
INSERT INTO ksr_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Gii waŋ juga injaŋa mena taaŋa koloowaatiwaajoŋ amamaawaga ano waŋ juga taaŋa mena injaŋa koloowaatiwaajoŋ amamaawaga. Kawaajoŋ qaa kokaeŋ mende jewa, ‘Qaa hoŋa mende jemaŋati eeŋ, Anutunoŋ saanoŋ waŋnaa juya mundanoŋ qero utegowaa.’ ");
INSERT INTO ksr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jojopaŋ qaa mende jewuto, ooŋ-qaawaajoŋ mono ‘Ooŋ!’ jewu ano qaagowaajoŋ ‘Qaago!’ jewu. Qaa dindiŋa iikanoŋ qaa iwoi toroqewuti, ii mono Kileŋaa Toyanoŋ sololooŋ oŋono koloowaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Qaa moŋ kokaeŋ iŋijoŋkegi, ‘Moŋnoŋ jaaga qisigowaati, gii mono iroŋa meleema iwaa jaaya qisigowa. Moŋnoŋ jega qemburatiwaati, gii mono iroŋa meleema iwaa jeta qemburatiwa.’ ");
INSERT INTO ksr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","“Kaeŋ iŋijogito, niinoŋ qaa ii kokaeŋ jeŋ asariwe mobu: Moŋnoŋ bologa ama oŋombaati, ii mono mende qetegoŋ tuarenjeŋ ama mubu. Kaeŋ qaagoto, uruŋga dindiŋa qetaaliwaati eeŋ, mono uruŋga lee kaaŋagadeeŋ qetaaliwaatiwaajoŋ meleemba. ");
INSERT INTO ksr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Moŋnoŋ ‘Selekopaaga memaŋa,’ jeŋ qaanoŋ goomambaajoŋ moji eeŋ, mono mesaoŋ malekuga qaga kaaŋagadeeŋ muna buŋa qeŋ aowa. ");
INSERT INTO ksr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","“Kaaŋagadeeŋ moŋnoŋ gesoya kilomiita motooŋgowaa so elaaŋ kembagatiwaajoŋ kuuŋ gombaati eeŋ, mono saanoŋ teŋ koma kilomiita woiwaa so elaaŋ iwo kemba. ");
INSERT INTO ksr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Moŋnoŋ goonoŋ iwoi mombaajoŋ qisiŋ gombaati, ii mono muba. Moŋnoŋ ‘Iwoi nona kitia era meleemaŋa,’ jeŋ qisiŋ gombaati, ii mono gema mende qeŋ muba. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Qaa moŋ kokaeŋ iŋijoŋkegi, ‘Ejemba kosogianoŋ laligoŋ alaurugia koloojuti, ii jopagoŋ oŋomakebuto, kaziurugia mono meleema kazi ama oŋoma laligowu.’ ");
INSERT INTO ksr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","“Kaeŋ iŋijogito, niinoŋ qaa ii kokaeŋ jeŋ asariwe mobu: Oŋo mono kaziurugia jopagoŋ oŋoma nama sisiwerowero ama oŋomakejuti, iyoŋoojoŋ mono qama kooliŋ laligowu. ");
INSERT INTO ksr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kaeŋ amakebuti eeŋ, iikaaŋa kanoŋ Maŋgia Siwe gomanoŋ laligoji, mono iwaa kania qendeema meraboraaŋa kolooŋ laligowuya. Iwaa kania ii kokaeŋ: Iinoŋ weeŋa mende aŋgoŋ kono kouma ejemba awaa ano bologa kaaŋagadeeŋ meŋ asariŋ oŋomakeja ano koŋ anota ejemba dindiŋa ano doogoya yoŋoo nene gawoŋgia kaaŋagadeeŋ bedu meŋkeja. ");
INSERT INTO ksr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Oŋonoŋ mono nona gomambaa tania uuguŋ Anutuwaa kania qendeema aoŋkebu. Takis tiliqiligiawo megi sisigia meŋkejuti, iyoŋonoŋ alaurugianoŋ jopagoŋ oŋoŋgi ii meleema jopagoŋ oŋomakeju. Ii uumeleembaa silia qaago. Oŋo yoŋoo sili iikayadeeŋ otaaŋ aoŋkebuti eeŋ, Anutuwaanoŋ tosa moŋ mende kolooro iinoŋ siligiaa tosaya mende oŋono tawa moŋ mende buŋa qeŋ aowuya. Kawaajoŋ mono ejemba korebore jopagoŋ oŋoma laligowu. ");
INSERT INTO ksr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","“Uumeleembaa gadokopa ejembanoŋ kaaŋagadeeŋ batugianoŋ joloŋgia jeŋ aoŋ laligojuto, ii uumeleembaa aiweseya qaago. Oŋo yoŋoo so alaurugia oŋoo batugianoŋga joloŋgia jeŋ aoŋkebuti eeŋ, iikanoŋ mono gadokopa ejemba kaaŋa kolooju. Gadokopa ejemba yoŋoo siligia mono uuguŋ awaa soro kolooŋ laligowu? ");
INSERT INTO ksr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Oŋoo Siwe Maŋgianoŋ akadamu soro kolooji, oŋonoŋ mono iikawaa so akadamu sorogiawo kolooŋ laligowu.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jiisasnoŋ kokaeŋ kuma oŋono, “Mono kokaembaajoŋ galeŋ meŋ aoŋ laligowu: Nanamemeŋgia solaŋa dindiŋa ii ejembanoŋ iima oŋoojoŋ mogi ubaatiwaajoŋ ama mende amakebu. Kaeŋ amakebuti eeŋ, oŋoo Maŋgia Siwenoŋ laligoji, iinoŋ mono siligiaa tosaya mende oŋono tawa mende buŋa qeŋ aowuya. ");
INSERT INTO ksr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Kawaajoŋ memeqemeaŋ ejemba kaleŋ oŋomanjeŋ ii qenjaaronoŋ komaŋ romombo uuŋ qele ambutiwaajoŋ mende amba. Uumeleembaa ejemba seleseleya yoŋonoŋ ejembanoŋ meŋ biwiiŋ oŋombutiwaajoŋ moma qamakooli mirinoŋ ano kana somatanoŋ kema ejemba iŋiima kaeŋ amakeju. Niinoŋ qaa hoŋa tooŋ moŋ kokaeŋ iŋijowe mobu, Yoŋonoŋ mono siligiaa tawaya kuuya buŋa qeŋ aodaborogi Siwe Toyanoŋ ii mende toroqewaa. ");
INSERT INTO ksr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","“Giinoŋ kaeŋ mende ambato, memeqemeaŋ ejemba kaleŋ oŋomanjeŋ boro dindiŋganoŋ nomaeŋ anji, boro qaniganoŋ ii mende moba. ");
INSERT INTO ksr_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kaleŋga iikanoŋ aasaŋgoyanoŋ ero Maŋganoŋ nanamemeŋ aasaŋgoya iimakeji, iinoŋ mono tawa gombaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Kawaajoŋ Anutuwaa qama kooliwuti, ii mono uumeleembaa ejemba seleseleya yoŋoo so mende ambu. Yoŋonoŋ ejembanoŋ iŋiibutiwaajoŋ moma siiŋgianoŋ qamakooli mirinoŋ ano kana sosoonoŋ nama qama kooliŋkeju. Niinoŋ qaa hoŋa tooŋ moŋ kokaeŋ iŋijowe mobu, Yoŋonoŋ mono siligiaa tawaya kuuya buŋa qeŋ aodaborogi Siwe Toyanoŋ ii mende toroqewaa. ");
INSERT INTO ksr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","“Giinoŋ kaeŋ mende ambato, Anutuwaa qama koolimanjeŋ mono geeŋgaa miri uuta melaanoŋ uma nagu koma Maŋga aasaŋgoyanoŋ laligoji, ii qama kooliŋ muba. Kaeŋ ana Maŋganoŋ nanamemeŋ aasaŋgoya iimakeji, iinoŋ mono tawa gombaa. ");
INSERT INTO ksr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Qama kooliwuti, iikanoŋ mono uumeleembaa gadokopa ejemba yoŋoo tani kaaŋa qaa julujulu ii mende jeŋ laligowu. Yoŋonoŋ qaa je seiseiya jegi Anutunoŋ iikawaajoŋ ama geja ama moma oŋombaatiwaajoŋ romoŋgoŋkeju. ");
INSERT INTO ksr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mono kokaembaajoŋ yoŋoo so mende kolooŋ laligowu: Oŋo naa iwoiwaajoŋ amamaaŋ mozoqozoroŋ anjuti, Maŋgianoŋ ii mende qama kooligi waladeeŋ modaboroŋkeja. ");
INSERT INTO ksr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Mono kokaeŋ qama kooliŋkebu: Nonoo Maŋnana, gii Siwenoŋ laligojaŋ. Goo qaga mono toroya ewa. ");
INSERT INTO ksr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mono galeŋ koma nonona bentotoŋgaa hoŋa koloowa. Goo uusiiŋga Siwenoŋ teŋ komakejuti, ii mono namonoŋ kaaŋiadeeŋ koloowa. ");
INSERT INTO ksr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ketewaa nenenana ii mono sonananoŋ nonomba. ");
INSERT INTO ksr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tosia yoŋoonoŋ tosa nonoonoŋ eji, nono ii mesaoŋ oŋonjoŋi eeŋ, gii mono iikawaa so nonoonoŋ tosa soŋgbama nonomba. ");
INSERT INTO ksr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Aŋgobatonoŋ kamaaŋ nunuwabotiwaajoŋ mono aŋgoŋ koma nonoma Kileŋaa Toyaa borianoŋga metogoŋ nonomba. (Gii geeŋgo bentotoŋ Toya, ku-usuŋ Toya ano asamararaŋ Toya ii kambaŋa kambaŋa laligoŋ kouma laligona ano tetegoya qaa laligoŋ ubaga. Ii oŋanoŋ.) ");
INSERT INTO ksr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Oŋo ejemba yoŋoo siŋgisoŋgogia mesaowuti eeŋ, Siwe Maŋgianoŋ mono kaaŋagadeeŋ oŋoo siŋgisoŋgogia mesaowaa. ");
INSERT INTO ksr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mesaowaato, ejemba yoŋoo siŋgisoŋgogia mende mesaowuti eeŋ, Maŋgianoŋ mono kaaŋagadeeŋ oŋoo siŋgisoŋgogia mende mesaowaa. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nene siŋgi laligowuti, iikanoŋ mono uumeleembaa ejemba seleseleya kaaŋa kubosobosole mende ama laligowu. Yoŋonoŋ Anutuwaajoŋ nene siŋgi laligoŋkejuti, ejembanoŋ ii iibutiwaajoŋ ama ziliŋzoloŋ ama jaasewaŋgianoŋ saabesaabe kolooŋkeja. Niinoŋ qaa hoŋa tooŋ moŋ kokaeŋ iŋijowe mobu, Yoŋonoŋ mono siligiaa tawaya kuuya buŋa qeŋ aodaborogi Siwe Toyanoŋ ii mende toroqewaa. ");
INSERT INTO ksr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","“Giinoŋ kaeŋ mende ambato, Anutuwaajoŋ nenewaa siŋgi laligoŋ kanoŋ mono tonoŋ gbabulunoŋ me saifenoŋ jaasewaŋga soŋgbama waŋ juga qeŋ laligowa. ");
INSERT INTO ksr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Kaeŋ ama nenewaa siŋgi laligona ejembanoŋ qaagoto, Maŋga aasaŋgoyanoŋ laligoji, iinoŋ ii iibaa. Kaeŋ ana Maŋganoŋ nanamemeŋ aasaŋgoya iimakeji, iinoŋ mono tawa gombaa. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Moneŋ hina iwoi ii mono namonoŋ eŋ oŋombaatiwaajoŋ mende meŋ kululuuwu. Kaeŋ meŋ kululuugi kanoŋ dumunjaŋ gejalolonoŋ ii kitogi kasukerajuju rost (kufeŋ) meŋ boliro kikekakasililiŋ yoŋonoŋ miri qosoma uma yoŋgoro meŋkeju. ");
INSERT INTO ksr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","“Namonoŋ qaagoto, Anutuwaa uusiiŋa teŋ koŋgi qabuŋagianoŋ somariiwaatiwaajoŋ mono kaparaŋ komakebu. Kaeŋ aŋgi maa suaŋgia qaita moŋ ii Siwe gomanoŋ ero gureŋ dumunjanoŋ ii mende kitogi kasukerajuju rost (kufeŋ) ii mende meŋ boliwuya. Kikekakasililiŋ yoŋonoŋ eu uma miri qosoma iwoi yoŋgoro mende mewuya. ");
INSERT INTO ksr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Iwoiwaajoŋ akadamuya meŋ mona uji, iikanoŋ miri moŋgeŋ ero giinoŋ mono uuga kaaŋagadeeŋ iikanoŋ qokotaaŋ laligowaga. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Goo jaaga ii uu selegaa kiwaya kolooja. Kawaajoŋ ji moŋnoŋ jaaga mende meŋ boliji eeŋ, iikanoŋ mono tooŋ asaridabororo Anutuwaa asasaganoŋ saanoŋ uuganoŋ meŋ asariro laaligoga kuuya asasaganoŋ laligowaga. ");
INSERT INTO ksr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","“Asasaganoŋ laligowaato, siiŋ kombombaŋa bologanoŋ me iwoi moŋnoŋ jaaga meŋ boliŋ asasaga kojaŋgiji eeŋ, iikanoŋ selewaa laaligoga kuuya kaaŋagadeeŋ meŋ tiiro paŋgamaŋ uutanoŋ umbuqumbiaŋ laligowaga. Kaeŋ kolooro paŋgamanoŋ uugaa asasaga kojaŋgiro tiiji eeŋ, geeŋgaa paŋgamanoŋ mono ‘Yei!’ damubiribiriawo kolooja. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Moŋnoŋ poŋ woi weleŋ qeŋ oromambaajoŋ amamaaŋkeja. Moŋnoŋ kaeŋ amambaajoŋ moji, iinoŋ mono moŋ kazi ama muŋ moŋ uutanoŋ jopagowaa. Mombaanoŋ qokotaaŋ moŋ jejewili ama mubaa. Kawaajoŋ oŋonoŋ Anutu ano moneŋ hina ii mindiriŋ weleŋ qeŋ orombombaajoŋ amamaawuya. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Kaeŋ kolooro niinoŋ kokaeŋ iŋijowe mobu: Oŋo namonoŋ laligowutiwaa majakakaya ii kokaeŋ jeŋ mende mobu, ‘Mono naa iwoiga aŋguŋ aoŋ newonaga ano naa iwoinoŋ selenana esuuwonaga?’ Jaagiawo laligojuti, iikanoŋ iwoi hoŋa kolooro nenenoŋ iikawaa qereweŋa kolooja. Selegiawo laligojuti, iikanoŋ iwoi hoŋa kolooro opo surunoŋ iikawaa qereweŋa kolooja. Mono ii romoŋgowu. ");
INSERT INTO ksr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","“Kanakeewaŋ kooŋa kooŋa ii mono iŋiibu. Yoŋonoŋ nene kota mende qosoma kororooŋkeju. Dumuŋ hoŋa ii mende kotoŋ kowi mirigianoŋ mende meŋ kululuuŋkeju. Ii qaago totooŋ ano oŋoo Siwe Maŋgianoŋ mono kileŋ ii uŋuagiŋkeja. Oŋo kooŋ yoŋoo so qaagoto, oŋoo sewaŋgianoŋ mono kooŋ sewaŋgia uŋuuguŋ uuta kolooja me qaago? Mono ii romoŋgogi kemba. ");
INSERT INTO ksr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","“Oŋoonoŋga moŋnoŋ majakaka moma iikaaŋa kanoŋ namonoŋ laligowaatiwaa kambaŋa ii weeŋ motooŋgowaa so meŋ toroqewaa me qaago? Ii qaago totooŋ! ");
INSERT INTO ksr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Opo surugiaajoŋ mono nomaembaajoŋ majakaka moju? Ii mende sokonja. Sombembaa japu jariŋ juraya somariiŋkejuti, mono ii uuŋ iŋiibu. Yoŋonoŋ opo surugiaajoŋ beweso mende loŋgbamakeju ano gawoŋ tosaaŋa mende meŋkeju. ");
INSERT INTO ksr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","“Ii kileŋ niinoŋ kokaeŋ iŋijowe mobu, Kiŋ Solomonoŋ goul silwaya qeragoŋ asombilibiliawo laligoroto, iwaa malekuya ii leiŋ firindua me jura mombaa so iimasiiŋsiiŋawo mende kolooro. ");
INSERT INTO ksr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Sombembaa japu jariŋ juraya tooŋ kete kosonananoŋ ero woraŋ koŋgi kamaaro meŋ kululuuŋ giliŋ oogi jewaato, ii kileŋ Anutunoŋ ii awaagadeeŋ menjereŋgoŋkeja. Kawaajoŋ iinoŋ oŋo kaaŋagadeeŋ saanoŋ esuuŋ oŋombaa. Oŋonoŋ japu jariŋ jurayaa so qaago. Anutunoŋ kalaŋ koma oŋomambaajoŋ moma iikawaajoŋ siiŋa uuta momakeja. Oo ejemba, momalaarigianoŋ mono naambaajoŋ eeŋ toontooŋ melaada kolooja? ");
INSERT INTO ksr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Kaeŋ kolooro oŋo mono laaligogiaa majakaka ano motoqoto mende momakebu. Ii moma bimooŋ kokaeŋ jewubo, ‘Nono mono naa nene apuga newonaga?’ ano ‘Naa iwoinoŋ selenana esuuwonaga?’ ");
INSERT INTO ksr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","“Ii kokaembaajoŋ: Uumeleembaa gadokopa yoŋonoŋ iwoi kuuya ii buŋa qeŋ aowombaajoŋ kaparaŋ koma uugere momakeju. Oŋonoŋ iwoi kuuyaajoŋ memeqemeaŋ meŋ osiŋkejuti, oŋoo Siwe Maŋgianoŋ mono ii modaboroja. ");
INSERT INTO ksr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Iikawaa uugereya mende mobuto, wala mono Anutuwaa bentotonoŋ keuma iwaa jaanoŋ solaŋaniwombaajoŋ kaparaŋ komakebu. Uugia iikanoŋ aŋgi ero iinoŋ mono galeŋ koma oŋoma iwoi iikaaŋa kuuya ii kaaŋiadeeŋ oŋombaa. ");
INSERT INTO ksr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Kaeŋ ama oŋonoŋ mono woraŋ laligowutiwaa majakakaya ii mende momakebu. Worambaa majakakaya ii worambaajoŋ. Weeŋ motomotoombaa majakakagia mono aŋa aŋa bosiniŋ sogianoŋ koloowaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jiisasnoŋ toroqeŋ kokaeŋ iŋijoro, “Anutunoŋ qaagia gosiŋ jeŋ tegoro kamaawubotiwaajoŋ mono tosaaŋa yoŋoo qaagia mende gosiŋ jeŋ tegowu. ");
INSERT INTO ksr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kawaa kania ii kokaeŋ: Oŋonoŋ tosaaŋa yoŋoo qaagia gosiŋ jeŋ tegowuti, Anutunoŋ mono keda motooŋgonondeeŋ oŋoaŋgiaa qaagia gosiŋ jeŋ tegowaa. Oŋonoŋ tosaaŋa yoŋoojoŋ jeŋkooto ama meŋ uma kamaaŋ gosiŋ oŋomakejuti, Anutunoŋ mono iikawaa so oŋoaŋgia ama oŋono uma kamaaŋkebuya. ");
INSERT INTO ksr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Gii alagaa jaanoŋ godomaruru melaada iijanto, geeŋgaa jaaganoŋ gere tapia somata eji, ii mono naambaajoŋ mende iima kotojaŋ? ");
INSERT INTO ksr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Me nomaembaajoŋ ama afaaŋgoŋ alaga kokaeŋ ijojaŋ, ‘Alana moba, nii saanoŋ jaaganoŋga godomaruru itagowe kamaawa?’ Kaeŋ afaaŋgoŋ jejanto, gere tapia somata ii geeŋgaa jaaganoŋ eja. ");
INSERT INTO ksr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","“Oo gii uumeleembaa selesele ejaga, gii mono wala geeŋgaa jaaganoŋga gere tapia somata meŋ giliwa. Ii meŋ giliŋgo tororo iima kotoŋ alagaa jaanoŋga godomaruru melaada ii saanoŋ itagona kamaawaa. ");
INSERT INTO ksr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Iwoiwaajoŋ mogi tak-kootoya qaita moŋ kolooji, ii mono kasu mende oŋombu. Maa damandaŋ qeqeta ii mono bao bagianoŋ mende giligi kemba. Kaeŋ ambuti eeŋ, iyoŋonoŋ mono ii kanagianoŋ tilalaaŋ oŋoma mombo meleema oŋoaŋgia iŋiŋ kitomitoŋ oŋombubo. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mono Anutu qama kooliŋkebu. Qama kooligi gosiŋ iwoi oŋombaa. Mono iwoiwaa Anutuwaanoŋ borojaŋ meŋ moŋgamakebu. Ii moŋgaŋgi qendeeno iwoi mokoloowuya. Mono nama nagunoŋ qeŋkebu. Qegi nagu horoŋ oŋombaa. ");
INSERT INTO ksr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Moŋnoŋ Anutu qama kooliŋkeji, Anutunoŋ mono iwaa kitia meleeno buŋa qeŋ aowaa. Iwoiwaa moŋgamakeji, iinoŋ mono iwoi mokoloowaa. Nagunoŋ qeŋkejiwaajoŋ mono nagu horoŋ mubaa. ");
INSERT INTO ksr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Mobu, ejemba oŋoonoŋga moronoŋ kokaeŋ anaga: Merianoŋ bisketwaajoŋ qisiro jamo mubaa? ");
INSERT INTO ksr_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Me merianoŋ sorawaajoŋ qisiro qato mubaa? ");
INSERT INTO ksr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","“Kaeŋ kolooro oŋo ejemba bologa kolooŋ kileŋ kaleŋ awaa awaa meraboraurugia oŋombombaa so koloojuti eeŋ, oŋoo Maŋgia Siwe gomanoŋ laligoji, iinoŋ mono kaleŋa nomaeŋ aŋgoŋ konaga? Iwaa uutaa nanamemeŋa ii nunuuguŋ qaita moŋ kolooja. Kawaajoŋ oŋo iwoi awaawaajoŋ qama kooliŋ qisiŋ mubuti eeŋ, iinoŋ mono siiŋanoŋ ii oŋombaa. ");
INSERT INTO ksr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Kawaajoŋ ejembanoŋ oŋo iwoi kuuya ama oŋombutiwaajoŋ momakejuti, iikawaa so mono ii kaaŋagadeeŋ ama oŋomakebu. Kaeŋ aŋgi Mooseswaa Kana qaa ano gejatootoo ejemba yoŋoo Buju Tere qaagia iikanoŋ mono hoŋgiawo kolooro mindimindiri kanianoŋ asuganoŋ koloowaa. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Gere sianoŋ kemebombaa kania ii afaaŋgoya ano naguya ii laaŋania. Ejemba seiseiyanoŋ nagu ii kotoŋ kana ii metetereeŋ kembuya. Kawaajoŋ oŋo mono kiropo nagu goŋgoŋa kotoŋ iikawaa uutanoŋ kembu. ");
INSERT INTO ksr_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","“Laaligo kombombaŋanoŋ keukeutaa kania ii opopoŋgoya osiqosiawo ano naguya ii goŋgoŋa. Ejemba afaaŋgoyanoŋ nagu ii mokoloowuya. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Gejatootoo ejemba takapolakaya yoŋonoŋ lamawaa sele esuya mouma oŋoonoŋ kaŋkejuto, uugianoŋ kasu kawalia kaaŋa kolooju. Kawaajoŋ oŋo mono yoŋoojoŋ ama toogia moma galeŋ meŋ aoŋ laligowu. ");
INSERT INTO ksr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Gawoŋgiaa hoŋa iigi kanagia qendeeno saanoŋ moma kotowu. Nejoŋ hoŋa ii kasuneselanoŋ kolooŋkeja me qaago? Waruŋ hoŋa ii kowororonoŋ kolooro meŋ kululuuŋkejoŋ me qaago? Qaago! ");
INSERT INTO ksr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","“Kawaa so gere awaa kuuya yoŋonoŋ hoŋgia awaa kuuŋkejato, gere bologanoŋ mono hoŋgia bologa kuuŋkeja. ");
INSERT INTO ksr_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Gere awaanoŋ hoŋa bologa kuumambaajoŋ amamaaŋkeja ano gere bologanoŋ hoŋa awaa kuumambaajoŋ amamaaŋkeja. ");
INSERT INTO ksr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","“Gere kuuya hoŋa awaa mende kuuŋkejuti, ii mono galeŋanoŋ kotoŋ meŋ gerenoŋ giliro kemebuya. ");
INSERT INTO ksr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Iikawaa so ejemba yoŋoo gawoŋgiaa hoŋa iigi kanagia qendeeno saanoŋ moma kotowuya. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Noo Siwe maŋnaa uusiiŋa teŋ komakeji, iinoŋ mono iwaa bentotonoŋ keubaa. Mamaga yoŋonoŋ noojoŋ ‘Poŋ, Poŋ!’ eeŋ qama jeŋkejuto, kuuya yoŋonoŋ Siwewaa bentotonoŋ mende keubuya. ");
INSERT INTO ksr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","“Jenteegowaa kambaŋ somata iikanoŋ mamaga yoŋonoŋ kaŋ noojoŋ kokaeŋ nijowuya, ‘Oo Poŋ Poŋ, nononoŋ mono goo qaganoŋ iwoi koloowaatiwaa gejatootoo qaa waladeeŋ jeŋ laligoniŋ. Nononoŋ mono goo qagaa esuŋanoŋ omeya omeya oŋotaaŋ laligoniŋ. Goo qaganoŋ mono nemuŋ koma nonono aŋgoleto esuŋmumugiawo mamaga meŋ laligoniŋ. Ii duduujaŋ me?’ ");
INSERT INTO ksr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kaeŋ nijogi kambaŋ kanoŋ kaniagia asuganoŋ kokaeŋ iŋijowe mobuya, ‘Niinoŋ kambaŋ moŋnoŋ oŋo mende moma oŋombe. Ejemba jeulalaŋ aaŋa, oŋo mono nomesaoŋ togowu.’ Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Kaeŋ koloojiwaajoŋ daeŋ yoŋonoŋ noo qaa jena jejeŋi, ii moma iikawaa so teŋ koma meŋkejuti, niinoŋ kuuya iyoŋoo kaniagia qendeema momakooto ejawaa so ama kokaeŋ jemaŋa: Iinoŋ miria jamo kowonjiŋ qaganoŋ mero. ");
INSERT INTO ksr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kaeŋ mero koŋuru kambanoŋ koŋ rombuŋ giliŋ kamaaro apu luguro musu somata qero apu gboulu somata waama miri sopayanoŋ kuuroto, miri ii jamo kowonjiŋ qaganoŋ mero nanotiwaajoŋ ama mende kuno. ");
INSERT INTO ksr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Daeŋ yoŋonoŋ noo qaa jena jejeŋi, ii moma iikawaa so mende teŋ koma meŋkejuti, niinoŋ kuuya iyoŋoo kaniagia qendeema eja nekoŋaa so ama kokaeŋ jemaŋa: Iinoŋ miria sakasiŋ baŋare qaganoŋ mero. ");
INSERT INTO ksr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kaeŋ mero koŋuru kambanoŋ koŋ rombuŋ giliŋ kamaaro apu luguro musu somata qero apu gboulu somata waama miri sopayanoŋ kuuro gororoŋgoŋ kamaaro.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jiisasnoŋ qaa ii jedabororo ejemba tuuŋa tuuŋa yoŋonoŋ mogi kuma oŋonoti, tani iikawaajoŋ aaruŋ waliŋgogi. ");
INSERT INTO ksr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Iinoŋ yoŋoo Kana qaawaa boiurugiaa tani mende kuma oŋonoto, ku-usuŋ Toya koloojiwaa so ejemba kuma oŋono moma tani kawaajoŋ waliŋgogi newogia tegoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jiisasnoŋ baaŋa ii mesaoŋ kamaaro kanageso tuuŋlelembe somatanoŋ gematanoŋ otaagi. ");
INSERT INTO ksr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kaeŋ kagi kanoŋ eja manimbayawo moŋnoŋ kaŋ simiŋ kuma Jiisaswaa wosoyanoŋ kemeŋ kokaeŋ ijoro, “Oo Poŋ, giinoŋ siiŋganoŋ meŋ qeaŋgoŋ nomambaajoŋ mojaŋi eeŋ, mono nii saanoŋ meŋ solaŋaniŋ nomba.” ");
INSERT INTO ksr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kaeŋ ijoro boria boraama selia oosiriŋ ijoro, “Niinoŋ ii amambaajoŋ mojeŋ. Gii mono solaŋaniwa.” Kaeŋ ijoro manimbaya ii iikanondeeŋ solaŋaniro awaa kolooro. ");
INSERT INTO ksr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Solaŋaniro kokaeŋ jeŋ kotoŋ muro, “Moba, kokawaa buju qaaya ii moŋ mende jena moba. Qaagoto, mono jigo gawoŋ galembaanoŋ kema selega qendeema muba ano Mooseswaanoŋ jeŋkootoya otaaŋ solaŋanijaŋiwaa daŋgiseŋ nanduŋa ama siimoloŋ oowa. Ii oona iiro ejembanoŋ kaniaga moma kotowu.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jiisasnoŋ Kaperneam taonoŋ kouro Room kawali galeŋ moŋnoŋ iwaanoŋ kaŋ qama kooliŋ kokaeŋ ijoro, ");
INSERT INTO ksr_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Oo Poŋ, noo gawoŋ ejanaa seliaa bakayanoŋ koomuya kolooro siimbobolo kanjaŋawo moma mirinoŋ eja.” ");
INSERT INTO ksr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Kaeŋ ijoro kokaeŋ jero moro, “Niinoŋ mono kema ii meŋ qeaŋgomaŋa.” ");
INSERT INTO ksr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ii moma kokaeŋ meleema ijoro, “Oo Poŋ, nii kaandiaga laligowe noo miri waareŋanoŋ gualeembaatiwaajoŋ gamuna mojeŋ. Kawaajoŋ qaa jeganondeeŋ jena weleŋ ejananoŋ qeaŋgowaa. ");
INSERT INTO ksr_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ii kokaembaajoŋa: Nii neeno kaaŋagadeeŋ galenaa ku-usuŋ baatanoŋ ama noŋgi laligojeŋ. Noo baananoŋ manjaqeqe eja laligogi ii jeŋ kotoŋ oŋomakejeŋ. Yoŋoonoŋga mombaajoŋ ‘Kemba,’ jeŋ kotowe iinoŋ kembaa. Mombaajoŋ ‘Kawa,’ jeŋ kotowe iinoŋ kawaa ano weleŋ ejana mombaajoŋ ‘Gawoŋ koi mewa,’ jewe iinoŋ ii mewaa.” ");
INSERT INTO ksr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jiisasnoŋ qaa ii moma waliŋgoŋ ejemba otaaŋ kagiti, iyoŋoonoŋ eleema kokaeŋ iŋijoro, “Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Israel kanageso batugianoŋ kaaŋagadeeŋ momalaari somata kaaŋa ii mombaa uutanoŋ mende mokoloowe. ");
INSERT INTO ksr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Niinoŋ qaa kokaeŋ iŋijowe mobu: Ejemba tuuŋ somasomatanoŋ mono weeŋ koukoutanoŋga ano weeŋ kemekemetanoŋga kaŋ Siwewaa bentotoŋ uutanoŋ kouma Aabraham, Aisak ano Jeikob yoŋowo nembanene neŋ korisoro ama laligowuya. ");
INSERT INTO ksr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Yoŋonoŋ kaeŋ laligowuto, bentotombaa meraboraaŋa ii mono oŋomesaoŋ hagoŋ oŋoŋgi paŋgamanoŋ seleeŋgeŋ kemebu. Iikanoŋ laligowuti, iyoŋonoŋ mono saama gigilaaŋ gobugia kigi qaro laligowuya.” ");
INSERT INTO ksr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kaeŋ iŋijoŋ kawali galeŋ kokaeŋ ijoro, “Gii mono miriganoŋ kemba. Momalaarigaa hoŋa mono kolooŋ gomba.” Kaeŋ ijoro weleŋ ejianoŋ mono aua iikanondeeŋ qeaŋgoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jiisasnoŋ Piitowaa mirinoŋ kema Piitowaa seuŋanoŋ selegere ji kiro ero iiro. ");
INSERT INTO ksr_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ii iima borianoŋ oosiriro selegereya mesaoro waama kanaiŋ Jiisas nene ooŋ wagiro. ");
INSERT INTO ksr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kaeŋ laligogi gomaŋ tiiro kanoŋ ejembanoŋ alaurugia omegiawo ii mamaga uŋuama iwaanoŋ kagi. Kagi ome ii qaayanoŋ jeŋ konjoma oŋono kouma keŋgi ano ji ejemba kuuya ii meŋ qeaŋgoŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Iikaaŋ ano Anutunoŋ qaaya gejatootoo eja Aisaiawaa uutanoŋ ano jerota eji, iikanoŋ hoŋawo kolooro. Qaa ii kokaeŋ, “Iinoŋ ananaanoŋ ji wijinana mero qaganoŋ uro bosino.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jiisasnoŋ ejemba tuuŋ somata liligoŋ mugi iŋiima kambaŋ kanoŋ gowokouruta yoŋowo apu aŋgoŋ kotoŋ leegeŋ keubombaajoŋ jeŋ kotoro. ");
INSERT INTO ksr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kana qaawaa boi moŋnoŋ Jiisaswaanoŋ kaŋ kokaeŋ ijoro, “Boi, gii daeŋ daeŋ kembagati, niinoŋ mono iikanoŋ gii gotaaŋ kamaŋa.” ");
INSERT INTO ksr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ii moma Jiisasnoŋ kokaeŋ ijoro, “Duuyaa kasuya yoŋonoŋ jamo kobaagianoŋ egi kanakeewambaa kooŋa yoŋonoŋ saraŋ bambaŋgianoŋ laligoŋkejuto, Siwe gomambaa Eja hoŋanoŋ mono dakanoŋ kema waŋa naa qembonoŋ qeŋ laariŋ haamo menaga?” ");
INSERT INTO ksr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kaeŋ ijoro gowoko yoŋoonoŋga moŋnoŋ kokaeŋ ijoro, “Ii saanonto, maŋnanoŋ komumambaa anjiwaajoŋ mono jena wala kema galeŋ kombe komuro roŋ kombego.” ");
INSERT INTO ksr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kaeŋ jeroto, Jiisasnoŋ meleema ijoro, “Mono mesaowa, koomuya yoŋonoŋ qamogia koomuya ii saanoŋ roŋ kombuto, giinoŋ mono kaŋ nii notaawa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jiisasnoŋ kema waŋgo uutanoŋ uro gowokouruta yoŋonoŋ otaaŋ iwo motooŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Keŋgi raidimboŋ somatanoŋ obabaŋkota apu aŋgonoŋ kolooŋ giliro. Giliro sirinoŋ waŋgo uutanoŋ kemeŋ saa qemambaajoŋ anoto, Jiisasnoŋ gaoŋ ero. ");
INSERT INTO ksr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Gaoŋ ero gowokouruta yoŋonoŋ kema mindiiŋ ijogi, “Hei Poŋ, mono ilaaŋ nonomba. Nono aŋgonoŋ tiwilaawombaajoŋ anjoŋ.” ");
INSERT INTO ksr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kaeŋ ijogi meleema kokaeŋ iŋijoro, “Oo oŋo momalaarigia melaada, mono naambaajoŋ toroko momo eja kolooju?” Kaeŋ iŋijoŋ waama musu ano siri jeŋ kotoŋ orono sirinoŋ goroŋ qeŋ ero. ");
INSERT INTO ksr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kaeŋ kolooro awawaliŋ qisiŋ aoŋ jegi, “Yei, maŋgaa siita! Eja koi naa ejaga laligoja? Iinoŋ musu ano kowe jeŋ kotoŋ orono jeta teŋ konjao.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kaeŋ kolooro apu aŋgoŋ kotoŋ leegeŋ Gadara yoŋoo gomanoŋ keuro. Iikanoŋ keuma eja omegarawo woi yoronoŋ qasirinoŋga kaŋ Jiisas mokoloori. Yoronoŋ iriŋsoŋsooŋ eja uugeregarawo koloori kuuyanoŋ kana iikanoŋ kembombaajoŋ amamaagi. ");
INSERT INTO ksr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yoronoŋ Jiisas mokolooŋ silama kokaeŋ qama gigilaari, “Ae! Gii Anutuwaa Meria koloojaŋ. Gii mono nomaeŋ ama nonomambaajoŋ kajaŋ? Siimbobolo momo kambaŋanoŋ mende kaŋ kuuro waladeeŋ ii geriawo ama nonomambaajoŋ koi kajaŋ me?” ");
INSERT INTO ksr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Iikanondeeŋ koriganoŋ qaagoto, kosogianoŋ kanoŋ bao tuuŋ somata moŋ gbojoja uutanoŋ kuluuma laligogi. ");
INSERT INTO ksr_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kawaajoŋ ome yoŋonoŋ kokaeŋ jeŋ Jiisas welema mugi, “Giinoŋ nono konjoma nonombagati eeŋ, mono wasiŋ nonona saanoŋ bao tuuŋ yoŋoo uugianoŋ kemeboŋa.” ");
INSERT INTO ksr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Welema mugi Jiisasnoŋ “Mono kema kemebu,” jeŋ jeŋ kotoŋ oŋono. Kaeŋ jeŋ kotoŋ oŋono iikanondeeŋ eja uugaranoŋga kouma kema bao uugianoŋ kemegi. Kemegi bao tuuŋ jumuŋa yoŋonoŋ mono luguŋ newonewoyanoŋ (siasiayanoŋ) kema jororoŋgoŋ apu aŋgonoŋ kemeŋ nemotoŋ komudaborogi. ");
INSERT INTO ksr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Komudaborogi bao galeŋ yoŋonoŋ koko koma unjurama taonoŋ kema qaa bujugia kuuya jegi. Eja omegarawo yoroonoŋ iwoi kolooroti, iikawaa bujuya kaaŋagadeeŋ iŋijogi. ");
INSERT INTO ksr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Iŋijogi moma taoŋ ejemba jaasooŋgo yoŋonoŋ mesaoŋ Jiisas mokolooŋ iibombaajoŋ kagi. Kaŋ iima Jiisasnoŋ yoŋoo mindimindiri sopa gomaŋ mesaoŋ kembaatiwaajoŋ welema mugi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jiisasnoŋ waŋgo uutanoŋ uma mombo apu aŋgoŋ kotoŋ leegeŋ keuma iyaŋaa taonoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kambaŋ kanoŋ eja tosianoŋ alagia sele bakaya koomuya tambomaeenoŋ eroti, ii demberunoŋ ama aŋgoŋ kagi. Kaeŋ kaŋ Anutu moma laariŋ mugiti, Jiisasnoŋ iyoŋoo tanigia iiro sokono ji eja ii kokaeŋ ijoro, “Merana, niinoŋ goo siŋgisoŋgoga mesaojeŋ. Kawaajoŋ mono kotiiŋ qaqabuŋabuŋagawo satiiŋ laligowa.” ");
INSERT INTO ksr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kaeŋ ijoro Kana qaawaa boi tosianoŋ nama uugianoŋ kokaeŋ romoŋgogi, “Eja koi kanoŋ mono Anutu mepaqepae ama muja.” ");
INSERT INTO ksr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kaeŋ romoŋgogito, Jiisasnoŋ roromoŋgogia ii moma kotoŋ kokaeŋ iŋijoro, “Oŋo mono naambaajoŋ qaa bologa uugianoŋ romoŋgoju? ");
INSERT INTO ksr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Niinoŋ ‘Siŋgisoŋgoga mesaojeŋ,’ jejeŋi, qaa ii mono afaaŋagadeeŋ jejetaga. Moŋnoŋ kaeŋ jero tosianoŋ qaa iikawaa hoŋa mende iibu. Kawaajoŋ qaa ii afaaŋaa so. Niinoŋ qaa moŋ kokaeŋ ijomambaajoŋ mojeŋ, ‘Mono waama kemba.’ Qaa ii lombotawo jejetaga kolooja. Kaeŋ jewe hoŋa koloowaa me qaagoti, ii mono asuganoŋ asugiro iibu. ");
INSERT INTO ksr_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mobu, balonoŋ siŋgisoŋgo mesamesaowaa ku-usuŋa ii Siwe gomambaa Eja hoŋaajoŋ eji, oŋo iikawaa kaniaajoŋ umbuqumbuyaŋ laligowubo. Kawaajoŋ qaa lombotawo ii eja koi ijowe hoŋa iibu.” Kaeŋ jeŋ eja sele bakaya koomuyaa jaayanoŋ iima ijoro, “Gii mono waama tambomaeega meŋ miriganoŋ kemba. Qaa biŋawo ii hoŋawo koloowaati eeŋ, qaa afaaŋa ii mono kaaŋagadeeŋ nomaembaajoŋ omaya koloonaga?” ");
INSERT INTO ksr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kaeŋ ijoro iikanondeeŋ waama mirianoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kaeŋ kolooro ejemba tuuŋ yoŋonoŋ ii iima waliŋgoŋ Anutu mepeseeŋ mugi. Baloŋ ejawaajoŋ ku-usuŋ kaaŋa murotiwaajoŋ Anutu mepeseegi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jiisasnoŋ iikanondeeŋ kema takis ofis uugumambaajoŋ ano iikanoŋ eja qata Matyuu raro iima ijoro, “Gii mono noo gemananoŋ kawa.” Kaeŋ ijoro waama takis gawoŋ mesaoŋ Jiisaswaa gematanoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kema Matyuuwaa mirinoŋ kema nene neŋ ragiti, kambaŋ iikanoŋ takis meme eja tiliqiligiawo ano siŋgisoŋgo eja mamaganoŋ kaŋ Jiisas ano iwaa gowokouruta yoŋowo rama nene motooŋ negi. ");
INSERT INTO ksr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kaeŋ negi Farisii (Kana qaawaa kaparaŋkoŋkoŋ) yoŋonoŋ ii iima Jiisaswaa gowokouruta kokaeŋ jeŋ oŋoŋgi, “Ae! Oŋoo boigianoŋ mono naambaajoŋ takis meme tiliqiligiawo ano siŋgisoŋgo ejemba yoŋowo rama nene neja? Ii mende sokonja.” ");
INSERT INTO ksr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Kaeŋ jeŋ oŋoŋgi Jiisasnoŋ kitia kokaeŋ iŋijoro, “Ejemba jigia qaa yoŋonoŋ doktawaa siiŋ mende amakejuto, ji ejembanoŋ mono doktawaanoŋ kemakeju. ");
INSERT INTO ksr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Niinoŋ siŋgisoŋgo ejemba oŋoomambaajoŋ kaŋ laligojento, ejemba iyaŋgiaajoŋ mogi solaŋa koloojuti, ii qaago. Kawaajoŋ qaa kokawaa kania mono kema kuma aoŋ mobu, ‘Niinoŋ siimoloŋ oowombaajoŋ qaagoto, kiaŋkomuŋ aowombaa siiŋa mojeŋ.” ’ Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kambaŋ kanoŋ Jon Oomulu ejawaa gowokouruta yoŋonoŋ Jiisaswaanoŋ kaŋ kokaeŋ qisigi, “Nononoŋ ano Farisii (Kana qaawaa kaparaŋkoŋkoŋ) yoŋonoŋ Anutuwaajoŋ nene siŋgi mamaga laligoŋkejoŋ. Geeŋgaa gowokouruganoŋ mono naambaajoŋ nene siŋgi mende laligoju?” ");
INSERT INTO ksr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Kaeŋ qisigi kokaeŋ meleeno, “Oŋanoŋ, nono naa kambanoŋ nene siŋgi laligoŋkejoŋ? Emba meme kambaŋanoŋ ejawaa gemakootaŋurutanoŋ gereya aŋgi embawaa sakitiurutanoŋ iwoi ii togoŋkeju me qaago? Niinoŋ neenaa gowokouruna yoŋoo eja buŋagia kolooŋ yoŋoo batugianoŋ ainjoloŋ ramakejeŋ. Rabe yoŋonoŋ kawaajoŋ ainjoloŋ aisooŋ rama nene siŋgi laligowombaajoŋ amamaaŋkeju. Amamaaŋkejuto, Anutunoŋ laaligona nuano komuwe yoŋonoŋ mono kambaŋ iikanoŋ saanoŋ nene siŋgi laligoŋkebuya. ");
INSERT INTO ksr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","(Oŋo laaligo walaga ano korisoro Buŋa gbilia ii mindiriŋ orombombaajoŋ amamaawuya. Kawaa qaa gemata ii kokaeŋ iŋijomaŋa:) Moumou walaga jurano moŋnoŋ opo gbilia mende sooŋgbaŋa motoŋ iikanoŋ opo jakaŋa mende ama uumbinaaŋkeja. Opo jakaŋa gbilia kaaŋanoŋ mono waziiŋ moumou walaga hororo mombo riiro ootanoŋ somariiŋ boliqoliwabo. ");
INSERT INTO ksr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kaaŋiadeeŋ moŋnoŋ wain apu gbilia ii bokoŋ me taru walaga lama selianoŋ memeta kanoŋ mende kosoro kemeŋkeja. Kaeŋ anagati eeŋ, wain apu gbilianoŋ mono somariiŋ taru qenjumenjurama molaaro namonoŋ kamaaŋ sooro taruyanoŋ kileqileewubo. Kawaajoŋ wain apu gbilia ii taru gbilianondeeŋ molaaniŋ kemero sokombaa. Kaeŋ aniŋ yoronoŋ awaa koloowao. (Kaaŋiadeeŋ apu awaa ii konoŋ qamoganoŋ mende kosoŋkejoŋ. Kaeŋ kosowonagati eeŋ, iikanoŋ mono juma siisororo kamaaro neŋ ji niniwabo. Kaeŋ koloowabotiwaajoŋ apu awaa ii konoŋ awaanoŋ kosoŋkejoŋ. Oŋo kaaŋiadeeŋ laaligo walaga ano Oligaa Buŋa gbilia ii mindiriŋ orombombaajoŋ amamaawuya.) Kiaŋ.” ");
INSERT INTO ksr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jiisasnoŋ qaa ii iŋijoro qaa galeŋ moŋnoŋ kouma Jiisaswaa batanoŋ kemeŋ simiŋ kuma kokaeŋ qama kooliŋ muro, “Noo borana keteda koi komujato, mono kaŋ boroganoŋ selianoŋ oosirina gbiliŋ toroqeŋ laligowa.” ");
INSERT INTO ksr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Qama kooliŋ muro waama gowokouruta yoŋowo ii otaaŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Keŋgi kambaŋ iikanoŋ batugianoŋ emba moŋ laligoro. Iinoŋ koiŋsa gbani 12:waa so iima ji kiro laligoro. Emba iikanoŋ Jiisaswaa gematanoŋ kaŋ malekuyaa kiti susuya oosiriro. ");
INSERT INTO ksr_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ii oosiriŋ iyaŋaajoŋ kokaeŋ jero, “Niinoŋ ii oosirimambaajoŋ moma bimooŋ malekuyanondeeŋ boroŋa moŋ oosiriwenagati eeŋ, mono saanoŋ qeaŋgomaŋa.” ");
INSERT INTO ksr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kaeŋ jeŋ oosiriro Jiisasnoŋ iikanondeeŋ eleema ii iima kokaeŋ ijoro, “Borana, momalaariganoŋ mono meŋ qeaŋgoŋ gonja. Mono kotiiŋ qaqabuŋabuŋagawo satiiŋ laligowa.” Kaeŋ ijoro moma aua iikanondeeŋ qeaŋgoro. ");
INSERT INTO ksr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Toroqeŋ keŋgi Jiisasnoŋ qaa galembaa mirinoŋ uma ejemba jiŋgeŋ qama awelo uugiti ano ejemba tuuŋ guju giligiti, ii iŋiima kokaeŋ jeŋ kotoŋ oŋono, ");
INSERT INTO ksr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Mono seleeŋgeŋ kembu. Emba melaanoŋ mende komujaato, gaoŋga eja.” Kaeŋ jeŋ kotoŋ oŋono mogi jonoŋsisi kaaŋa kolooro jomoma mugi. ");
INSERT INTO ksr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jomoma mugito, ejemba tuuŋ somata ii iŋijoro seleeŋgeŋ keŋgi emba melaa iikawaa ee miri uutanoŋ uma borianoŋ mero waaro. ");
INSERT INTO ksr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Waaro iikawaa buju qaayanoŋ seiŋ mindimindiri sopa gomaŋ ii kuuya sokoma keno. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jiisasnoŋ gomaŋ baloŋ ii mesaoŋ kemambaajoŋ keno eja jaagoo woiyanoŋ otaaŋ gematanoŋ kaŋ kokaeŋ qari, “Deiwidwaa gbilia, gii mono kiaŋkomuŋ noromba.” ");
INSERT INTO ksr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kaeŋ qari miri mombaa uutanoŋ uro jaagoo eja yoronoŋ Jiisaswaanoŋ kari kokaeŋ qisiŋ orono, “Jaagara meŋ toomambaa ku-usuŋa noonoŋ eji, ii moma laarijao me qaago?” Qisiŋ orono kokaeŋ meleema muri, “Poŋnara, ii saanoŋ moma laarijo.” ");
INSERT INTO ksr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kaeŋ meleema muri jaa dawogaranoŋ oosiriŋ irijoro, “Momalaarigaraa so mono koloowa.” ");
INSERT INTO ksr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kaeŋ irijoro jaagaranoŋ tooro. Kaeŋ kolooro galeŋ meme qaa kotakota oroma kokaeŋ irijoro, “Mobao, kokawaa bujuya ii mono moŋ mende jeri mobu.” ");
INSERT INTO ksr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kaeŋ irijoroto, yoronoŋ mesaoŋ kema iikawaa bujuya jeŋ seiri mindimindiri sopa gomaŋ ii kuuya sokoma keno. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jaagara tooro keni qaamuuŋ eja moŋ ii wama Jiisaswaanoŋ kagi. ");
INSERT INTO ksr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kagi Jiisasnoŋ omeya konjono eja qaamuuŋ iinoŋ qaa jero ejemba tuuŋ yoŋonoŋ ii iima waliŋgoŋ jegi, “Tani koi kaaŋa ii Israel uutanoŋ wala eeŋanoŋ kambaŋ moŋgeŋ mende iiniŋ. Qaago. Keteda koi jaa morotaga iijoŋ.” ");
INSERT INTO ksr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kaeŋ jegito, Farisii (Kana qaawaa kaparaŋkoŋkoŋ) yoŋonoŋ jegi, “Iinoŋ mono omejiilaŋ yoŋoo poŋgiaa esuŋanoŋ ome oŋotaaŋkeja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jiisasnoŋ kema gomaŋ ano taoŋ so liligoŋ ejemba qamakooli mirigianoŋ kuma oŋoma bentotombaa Oligaa Buŋa jeŋ asariŋ iikanoŋ uugia kuuŋ ji wiji ano jepajerepa kania kania meŋ qeaŋgoŋ oŋoma laligoro. ");
INSERT INTO ksr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kaeŋ laligoŋ ejemba tuuŋa tuuŋa iŋiiro lama galeŋgia qaa taniŋaeŋ deeŋqeema iliŋwaliŋ qeŋ qeqelala laligogi yoŋoojoŋ wosoya moro. ");
INSERT INTO ksr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kaeŋ iŋiima gowokouruta kokaeŋ iŋijoro, “Anutuwaa gawonoŋ nene hoŋa mamaga osasaaŋ momogoŋ ejato, ii meŋ kululuuyaa gawoŋ meme ejembanoŋ mono afaaŋgia laligoju. ");
INSERT INTO ksr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kawaajoŋ nene hoŋa masuqeqetaa Poŋanoŋ gawoŋ meme ejemba wasiŋ oŋombaatiwaajoŋ mono qama kooliŋ laligowu. Qama kooliŋ mugi gawoŋ ejemba asugiŋ hoŋa ii meŋ kululuuwu.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jiisasnoŋ gowokouruta 12 oŋoono iwaanoŋ kagi omejiilaŋ konjoma oŋombutiwaa ku-usuŋa oŋono. Kaaŋagadeeŋ ji wiji qenjeŋmanjeŋ kania kania meŋ qeaŋgowutiwaa ku-usuŋa oŋono. ");
INSERT INTO ksr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Wasiwasi eja aposol 12 yoŋoo qagia ii kokaeŋ: Mutuya ii Saimon, qata moŋ Piito qagi ano iwaa koga Andruu. Kawaa gematanoŋ Jeims ano koga Jon, maŋgara qata Zebedi. ");
INSERT INTO ksr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip ano Bartolomyuu, Tomas ano Matyuu takis meme eja, Jeims Alfiuswaa meria ano Lebeus qata moŋ Tadius, ");
INSERT INTO ksr_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon Zelot-politik ejaga ano Juudas Iskariot. Kariot eja kanoŋ kanageŋ Jiisas memelolo meŋ muro. ");
INSERT INTO ksr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jiisasnoŋ eja 12 ii wasiŋ oŋoma kokaeŋ jeŋ kotoŋ oŋoma iŋijoro, “Oŋo waba kantriwaa ejemba yoŋoonoŋ mende kembu. Kaaŋagadeeŋ Samaria prowins yoŋoo taoŋgia moŋnoŋ mende kembu. ");
INSERT INTO ksr_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Iikanoŋ mende kembuto, Israel kanagesowaa lama soogiti, mono iyoŋoonoŋ kembu. Ii gawoŋgia mutuya. ");
INSERT INTO ksr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Daeŋ daeŋ kembuti, iikanoŋ mono Buŋa qaa kokaeŋ iŋijoŋ jeŋ asariwu, ‘Siwewaa bentotonoŋ mono kosere kaja. Mono iikawaa uutanoŋ keubu.’ ");
INSERT INTO ksr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","“Ejemba jigiawo mono meŋ qeaŋgoŋ oŋoma koomuya ii meŋ gbiliŋ oŋoma laligowu. Ejemba manimbagiawo ii mono meŋ solaŋaniŋ oŋoma omejiilaŋ ii konjoma oŋoma laligowu. Anutunoŋ iwoi kaleŋ oŋonoti, ii mono toroqeŋ kaleŋ oŋoma laligowu. ");
INSERT INTO ksr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Kana kembutiwaajoŋ soojaakota goul me silwa me aeŋ kopanoŋ memeta ii mono irimuŋ kasagianoŋ mende somoŋgowu. ");
INSERT INTO ksr_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ejembanoŋ gawoŋ meme ejemba oŋoo laaligogia naŋgowutiwaa so kolooju. Kawaajoŋ kana kembuti, iwoi koi mende meŋ kembu: geso mende, maleku samoŋa mendeto, motooŋgo mewu, kana esu mende ano taa gbaru mende mewu. ");
INSERT INTO ksr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Kema taoŋ me gomaŋ dakanoŋ keubuti, iikanoŋ mono moronoŋ eja geria qabuŋayawo kolooji, iikawaajoŋ qisigi miri oŋombuti, mono iikanondeeŋ laligoŋ gawoŋ meŋ taoŋ ii mesaoŋ kana kembu. ");
INSERT INTO ksr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Miri moŋnoŋ uma luaenoŋ yoŋowo ewaatiwaa jewu. ");
INSERT INTO ksr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kaeŋ jegi luaegia aŋgoŋ kombutiwaa so koloojuti eeŋ, luaegianoŋ mono iyoŋoo qagianoŋ ubaato, ii aŋgoŋ kombutiwaa so mende koloojuti eeŋ, luaegianoŋ mono eleema oŋoaŋgiaanoŋ kawaa. ");
INSERT INTO ksr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Kema laligoŋ miri moŋnoŋ keugi mende koma horoŋ oŋoma qaagia mende mogi telambelaŋgia mono kokaeŋ jeŋ qendeema oŋombu, ‘Nono oŋoo gomanoŋ kaniŋ sububuŋ kana tambonananoŋ mokotaaji, ii mono riiŋ konjoratiniŋ oŋoaŋgiaanoŋ eleema kemebaa.’ Kaeŋ jeŋ saanoŋ gomaŋ me taoŋ ii mesaoŋ toroqeŋ kembu. ");
INSERT INTO ksr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Anutunoŋ kambaŋ somatanoŋ qemasologeŋgiaa iroŋa meleeno taoŋ iikawaa qaganoŋ ubaati, so iikanoŋ mono Sodom ano Gomora gomaŋ yoŋoo so uuguŋ toroqeŋ oŋombaa. (Sodom Gomora yoŋonoŋ bologa kanjaŋawo meŋ uugia mende meleeŋgi Anutunoŋ gerenoŋ kondeema oŋooro.) Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Mobu, lama yoŋonoŋ duuyaa kasu kawalia yoŋoo batugianoŋ kemegi luguŋ iŋiwubo, niinoŋ oŋo iikawaa tani kaaŋa wasiŋ oŋombe kembu. Kawaajoŋ mono mokoleŋ kaaŋa momakooto qaganoŋ galeŋ meŋ aoŋ laligoŋ kewo kaaŋa ejemba bonjoŋa koposowaa qaagia qaa laligowu. ");
INSERT INTO ksr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ejembanoŋ oŋo horoŋ qaa jakegianoŋ ama oŋoma qamakooli mirigianoŋ qaa gawoŋgia meŋ ooli waayawonoŋ oŋootiwuya. Kawaajoŋ ejemba kaaŋa yoŋoojoŋ mono galeŋ meŋ aoŋ laligowu. ");
INSERT INTO ksr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","“Tosianoŋ noojoŋa ama uŋuaŋgi kantria kantria yoŋoo eja poŋ ano gawana yoŋoo jaasewaŋgianoŋ nambuya. Kaeŋ nama noo kaniana naŋgoŋ jegi eja geria ii ano waba kantri kanageso yoŋonoŋ ii mobuya. ");
INSERT INTO ksr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ii mobuto, qaa jakeyanoŋ ama oŋoŋgi nambuti, kambaŋ kanoŋ naa qaaga nomaeŋ jewonaga, iikawaa majakaka mende mobu. Qaa jewuyati, ii Uŋa Toroyanoŋ aua iikanondeeŋ oŋombaa. ");
INSERT INTO ksr_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Oŋoaŋgiaa uugiaajoŋga qaa mende jewuyato, Amagiaa Uŋa Toroyanoŋ mono uugia sololooro qaa jewuya. ");
INSERT INTO ksr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Uumeleembaa gadokopa moŋnoŋ daremuŋanoŋ uuta meleenotiwaajoŋ ama ii memelolo mero qaa jakeyanoŋ aŋgi qegi komuwaa. Kaaŋagadeeŋ maŋ moŋnoŋ meraborata memelolo mero komuwaa ano merabora yoŋonoŋ nemuŋmaŋurugia qetama oŋoma jegi uŋugi komuwuya. ");
INSERT INTO ksr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Noo qanaajoŋ ama kantria kantria yoŋonoŋ kuuya kazi ama oŋoŋgi laligowuto, moŋnoŋ kaparaŋ koma kambaŋ tegowaatiwaa so kotiiŋ boŋ qeŋ nambaati, iinoŋ mono oyaŋboyaŋ buŋa qeŋ aowaa. ");
INSERT INTO ksr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“Taoŋ moŋnoŋ sisiwerowero ama oŋombuti, ii mono kok koma taoŋ moŋgeŋ kembu. Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Oŋo Israel taoŋa taoŋa mende liligodaborogi Siwe gomambaa Eja hoŋanoŋ eleema kawaa. ");
INSERT INTO ksr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Gowoko moŋnoŋ boiya uuguŋ momoyawo mende kolooja ano weleŋqeqe moŋnoŋ somataya uuguŋ gawombaa momo mende meŋ laligoja. ");
INSERT INTO ksr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","“Gowokonoŋ boiya kaaŋa momoyawo kolooro sokombaa ano weleŋqeqenoŋ somataya kaaŋa gawombaa momo meŋ laligoro sokombaa. Miri uuta mombaa eja jeŋ boliŋ qata Iimolaŋ qajuti eeŋ, iwaa embameraaŋuruta yoŋoo qagia mono afaaŋagadeeŋ iikaaŋ qamakebuya. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ejembanoŋ iwoi unuŋ megi eji, ii kuuya mono kotuŋgi asuganoŋ koloowaa. Kaaŋiadeeŋ qaa aasaŋgoya eji, ii kuuya mono iŋisaaŋgi moma kotowuya. Kawaajoŋ ejemba yoŋoojoŋ toroko mende moma laligowu. ");
INSERT INTO ksr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Niinoŋ qaa paŋgamanoŋ oloŋ jemaŋati, ii mono asasaganoŋ jewu. Qaa saŋe aŋgi gejagianoŋ kemero mobuti, ii mono sombenoŋ asuganoŋ jewu. Kawaajoŋ mono qaagiaajoŋ galeŋ meŋ laligowu. ");
INSERT INTO ksr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Tosianoŋ selegia qeŋ komuwuyagato, uŋagia qeŋ komuwombaajoŋ amamaawuyati, iyoŋoojoŋ toroko mende moma laligowu. Ii qaagoto, iwoi jegeŋa koi: Moŋnoŋ ku-usuŋ meŋ uŋa ano sele kaaŋgadeeŋ tiwilaaŋ orono gere sianoŋ kemebaoti, iwaajoŋ mono toroko moma laligowu. ");
INSERT INTO ksr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tosianoŋ arioŋ (me wilisi) woi moneŋ kota motooŋgodanoŋ sewaŋa mewutiwaajoŋ amakejuto, iridogi Maŋgianoŋ ‘Ooŋ!’ mende jero iyoroonoŋga motooŋgonoŋ balonoŋ mende kamaawaa. ");
INSERT INTO ksr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","“Anutunoŋ kalaŋ koma oŋoma waŋ jugia kuuya kaaŋagadeeŋ weeŋgodaboroŋ jaŋgogia moja. ");
INSERT INTO ksr_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ejemba oŋoo sewaŋgia ii arioŋ wilisi mamaga uŋuuguŋ uuta kolooja. Kawaajoŋ mono toroko mende moma laligowu. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Kaeŋ kolooro moŋnoŋ nii ejemba jaagianoŋ jokolooŋ nombaati, niinoŋ mono kaaŋiadeeŋ ii Maŋna Siwe gomanoŋ laligojiwaa jaanoŋ jokoloomaŋa. ");
INSERT INTO ksr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kaento, moŋnoŋ nii ejemba jaagianoŋ qakooma nombaati, niinoŋ mono kaaŋiadeeŋ ii Maŋna Siwe gomanoŋ laligojiwaa jaanoŋ qakoomaŋa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jiisasnoŋ toroqeŋ kokaeŋ iŋijoro, “Kokaeŋ mende romoŋgowu: Jiisasnoŋ luae qemambaajoŋ ama namonoŋ kamaaro. Niinoŋ luae qemambaajoŋ qaagoto, noojoŋ ama juma deeŋgi manjawaa soo somatanoŋ aowuya. ");
INSERT INTO ksr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","“Ii kokaembaajoŋ jejeŋ: Noo Buŋa qaananoŋ ejemba uugia kuuro meleeŋgitiwaajoŋ ama kokaeŋ koloowaa: ‘Maŋ mera yoronoŋ juma kerekere ani nemuŋ bora yoronoŋ riitama aori eŋaronoŋ eŋaroya qetama aoŋ deembaota. ");
INSERT INTO ksr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ejemba iyaŋgiaa sumaŋurugianoŋ mono kereurugia koloowuya.’ ");
INSERT INTO ksr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Moŋnoŋ nii gogoraageŋ ama noma nemuŋa me maŋa jegeŋa ama jopagowaati, ii noonoŋ mende sokombaa. Moŋnoŋ nii gogoraageŋ ama noma meria me borata jegeŋa ama jopagowaati, ii noonoŋ mende sokombaa. ");
INSERT INTO ksr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Sisigia megi moŋnoŋ nii notaaŋ siimbobolo moma maripoonoŋ komumambaajoŋ mende jojoriwaati, ii noonoŋ mende sokombaa. ");
INSERT INTO ksr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","“Moŋnoŋ iyaŋaa laaligo siiseweweya qaa ii mokoloowaati, iwaa laaligoyanoŋ mono soowaa. Moŋnoŋ noojoŋ ama laaligoya qeleeno soowaati, iinoŋ mono oyaŋboyaŋ laaligo mokoloowaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jiisasnoŋ jero, “Moŋnoŋ oŋo mirianoŋ koma horoŋ kalaŋ koma oŋombaati, iinoŋ mono nii koma horoŋ nombaa. Moŋnoŋ nii koma horoŋ nombaati, iinoŋ wasiŋ nonoti, mono ii mirianoŋ koma horoŋ mubaa. ");
INSERT INTO ksr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Moŋnoŋ gejatootoo ejemba moŋ gejatootoo gawoŋaajoŋ ama mirianoŋ koma horoŋ kalaŋ kombaati, iinoŋ mono gejatootoo ejembawaa tawaya buŋa qeŋ aowaa. Moŋnoŋ ejemba solaŋa moŋ solaŋa koloojiwaajoŋ ama mirianoŋ koma horoŋ kalaŋ kombaati, iinoŋ mono ejemba solaŋaa tawaya buŋa qeŋ aowaa. ");
INSERT INTO ksr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","“Moŋnoŋ merabora koi yoŋoonoŋga mombaajoŋ noo gowokona koloojiwaajoŋ ama apu saŋgoŋa qambiawo newaatiwaajoŋ mubaati, Anutunoŋ mono iikawaa tawaya meleema mubaa. Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Naŋgoŋ oŋombuti, iyoŋonoŋ mono tawa mewuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jiisasnoŋ jeŋkooto qaaya kaaŋ gowokouruta 12 oŋono tegoro gomaŋ ii mesaoŋ toroqeŋ Galili prowinswaa taoŋ tosianoŋ kema Buŋa qaa kuma oŋoma iikanoŋ uugia kuuŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kambaŋ kanoŋ Jon Oomulu ejanoŋ kapuare mirinoŋ rama Kraistnoŋ gawoŋ kaeŋ meroti, ii moma gowokowoita woi wasiŋ orono Jiisaswaanoŋ keni. ");
INSERT INTO ksr_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Kokaeŋ qisiŋ mubaotiwaajoŋ wasiŋ orono kema jeri, “Meŋqeeaŋgo eja kawaatiwaajoŋ mamboniŋ giinoŋ ii koloojaŋ me eja moŋ kanageŋ kawaatiwaajoŋ mambomboŋa?” ");
INSERT INTO ksr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Kaeŋ qisiŋ muri kokaeŋ meleeno, “Iwoi iima mojaoti, iikawaa sunduya mono kema Jon kokaeŋ ijori moba: ");
INSERT INTO ksr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Jaagoo yoŋonoŋ jaagia uuŋ iigi meendaŋgoya yoŋonoŋ kana kema kagi manimbagiawo yoŋonoŋ solaŋanigi gejaduu yoŋonoŋ qaa mogi koomugiti yoŋonoŋ gbiliŋ waagi kamaaŋqeqeta yoŋoojoŋ Oligaa Buŋa jeŋ asariwe momakeju. ");
INSERT INTO ksr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kaeŋ kolooro iigi mombaa uutanoŋ mende boliro gema nuwaati, iinoŋ mono simbawoŋawo kolooja.” ");
INSERT INTO ksr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kaeŋ meleeno Jombaa gowoko yoronoŋ keni Jiisasnoŋ kanaiŋ Jombaa kania ejemba tuuŋ yoŋoojoŋ kokaeŋ jeŋ asariro, “Oŋo baloŋ qararaŋkoŋkoŋanoŋ naama iibombaajoŋ keŋgi? Haamonoŋ bowo utugoŋ metano waŋsaŋ-waŋsaŋ amakeji, oŋo eja iikaaŋa kaya iibombaajoŋ keŋgi me? ");
INSERT INTO ksr_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Me naa iwoiga iibombaajoŋ keŋgi? Eja malekuya akadamuyawo mouma laligoroti, ii iibombaajoŋ me? Mobu, ejemba malekugia iimasiiŋsiiŋawo moumakejuti, iyoŋonoŋ mono kiŋ yoŋoo jiŋkaroŋ mirigianoŋ laligoju. Ii baloŋ qararaŋkoŋkoŋanoŋ qaago. ");
INSERT INTO ksr_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","“Me naa iwoiga iibombaajoŋ keŋgi? Gejatootoo eja moŋ iibombaajoŋ me? Oŋanoŋ, niinoŋ kokaeŋ iŋijowe mobu: Eja iigiti, iinoŋ mono gejatootoo ejemba tosaaŋa uŋuuguŋ qaita moŋ kolooja. ");
INSERT INTO ksr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Iwaa kania ii wala eeŋanondeeŋ kokaeŋ oogita eja, ‘Moba, niinoŋ qelena gajoba moŋ wasiwe waladeeŋ kema ejemba uugia mindiŋgoŋ goo kana meleuro giinoŋ mono iwaa gematanoŋ namonoŋ emu kemebaga.’ ");
INSERT INTO ksr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Qaa kaeŋ ejato, niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Embanoŋga merabora koloogiti, kuuya iyoŋoo batugianoŋ Jonoŋ mono kuuya uŋuuguŋ qabuŋayawo nanja. Nanjato, Siwewaa bentotoŋ uutanoŋ keuma Anutuwaa qabuŋaya mokolooŋkejuti, iyoŋoo batugianoŋ kamaaŋqeqeta konoga iinoŋ mono Jon uuguja. ");
INSERT INTO ksr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Jon Oomulu ejanoŋ Buŋa qaa jero kambaŋ iikanondeeŋ kanaiŋ Siwewaa bentotoŋa geriawo tuarenjeŋ ama manja qeŋkejuto, kileŋ uulaŋawo kema somariiŋkeja. Manja geregiawo qeŋkejuti, iyoŋonoŋ mono bentotoŋ ii iyaŋgiaajoŋ horoŋ buŋa qeŋ aoŋkeju. ");
INSERT INTO ksr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Bentotombaa kania ii Mooseswaa Kana qaanoŋ ano gejatootoo ejemba kuuya yoŋoo Buju Terenoŋ oogi weeŋgoŋ laligoŋ kouniŋ Jonoŋ kolooŋ hoŋa asuganoŋ iŋisaano. ");
INSERT INTO ksr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Qaa koi moma aŋaliŋ aŋgoŋ kombombaajoŋ mojuti eeŋ, Elaija koloowaatiwaa so anoti, Jonoŋ mono ii kolooja. ");
INSERT INTO ksr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Moŋnoŋ uugejiawo laligoji, iinoŋ mono qaa ii geja ama moma kotowa. ");
INSERT INTO ksr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ejemba kete namonoŋ laligojuti, ii mono naa iwoiwo so ama oŋombenaga? Yoŋonoŋ naamade kaaŋa kolooju. Yoŋonoŋ maaket sombenoŋ rama qaa jomo meŋ tondu qama kokaeŋ jeŋkeju, ");
INSERT INTO ksr_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nono rii gbawe meŋ awelo uuniŋ oŋo mende orogi. Nono jiŋgeŋ qaniŋ oŋo mende saagi.’ ");
INSERT INTO ksr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Iikawaa kania ii kokaeŋ: Jon Oomulu ejanoŋ kaŋ nene siŋgi laligoŋ wain apu mende nero iwaajoŋ jeŋkeju, ‘Ome moŋnoŋ uutanoŋ kemero laligoja.’ ");
INSERT INTO ksr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","“Siwe gomambaa Eja hoŋanoŋ kaŋ nembanene neŋ korisoro ano iwaajoŋ kokaeŋ jeŋkeju, ‘Mobu, iinoŋ baonoŋ newageeŋ nene qozozoŋgoŋ neŋ wain apu suulaŋ neŋ takis eja tiliqiligiawo ano bologa meme yoŋoo alagiaga laligoja.’ Anutuwaa momakooto koma gbiliŋkejuti, iyoŋoo nanamemeŋgiaa hoŋanoŋ mono momakootogianoŋ sokonji, ii qendeemakeja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kawaa gematanoŋ Jiisasnoŋ kanaiŋ taoŋ tosaaŋa temboma oŋono. Taoŋ tosaaŋa iikanoŋ aŋgoletoya ku-usuŋawo seiseiya mero kolooroto, kileŋ uugia mende meleeŋgi. Kawaajoŋ ii temboma kokaeŋ jeŋ oŋono, ");
INSERT INTO ksr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Oo Korazin toya, niinoŋ oŋoojoŋ ‘Yei!’ jeŋ saajeŋ ano Betsaida toya, oŋoojoŋ kaaŋagadeeŋ ‘Yei!’ jeŋ saajeŋ. Niinoŋ yoŋoonoŋ kema qaana jewe sosoniro aŋgoletona ku-usuŋawo kolooroto, uugia kileŋ mende meleeŋgi. Aŋgoleto ii waba gomanoŋ Taia ano Saidon sitinoŋ koloonagati eeŋ, iyoŋonoŋ mono kambaŋ koriga uugia meleembombaa kaisareya qendeema resa ano too ariŋ saabuyaga. ");
INSERT INTO ksr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","“Saabuyagato, niinoŋ kokaeŋ iŋijowe mobu: Anutunoŋ kanageŋ Korazin ano Betsaida yoŋoo qaagia jeŋ tegoŋ iroŋa meleeno siimbobolo mobuti, kambaŋ somata kanoŋ ii mono Taia ano Saidon iyoŋoo siimbobolo soya uuguŋ mobuya. ");
INSERT INTO ksr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Ano Kaperneam toya, Anutunoŋ oŋo saanoŋ metaama oŋono Siwe gomanoŋ ubuyaga me qaago? Qaago totooŋ! Oŋo mono koomuwaa senjoŋ gomanoŋ kemebuya. Niinoŋ yoŋoonoŋ kema qaana jewe sosoniro aŋgoletona ku-usuŋawo mewe kolooroto, uugia kileŋ mende meleeŋgi. Aŋgoleto ii Sodom taonoŋ koloonagati eeŋ, taoŋ iikanoŋ mono kambaŋ kokaamba kaaŋagadeeŋ toroqeŋ nanaga. ");
INSERT INTO ksr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","“Nanagato, niinoŋ kokaeŋ iŋijowe mobu: Anutunoŋ kanageŋ Kaperneam oŋoo qaagia jeŋ tegoŋ iroŋa meleeno siimbobolo mobuti, kambaŋ somata kanoŋ mono Sodom yoŋonoŋ siimbobolo iikawaa soya uuguŋ mobuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kambaŋ kanoŋ Jiisasnoŋ qaa kokaeŋ jero, “Oo Amana, giinoŋ Buŋa qaaga momakooto ejemba momo somata megiti, iyoŋoonoŋ mesaŋgonato, ejemba iyaŋgiaajoŋ moma kamaaŋ merabora kaaŋa poumapou laligojuti, ii mono iyoŋoonoŋ iŋisaana moma asariju. Kawaajoŋ niinoŋ Siwe namowaa Poŋa gii mepeseeŋ gonjeŋ. ");
INSERT INTO ksr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Oo Amana, gii geeŋgo kaeŋ koloowaatiwaajoŋ mona sokono awaa kolooro. ");
INSERT INTO ksr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Amananoŋ mono iwoi kuuya jeŋ kotoro noo buŋa kolooro. Amananoŋ Meriaa kania aŋodeeŋ moma yagoro moŋnoŋ ii mende moja. Kaaŋagadeeŋ Merianoŋ Amayaa kania moma yagoro moŋnoŋ ii mende moja. Kaaŋagadeeŋ moŋnoŋ Amanaa kania mende moma yagoro Merianondeeŋ ii moja ano ejemba meweeŋgoŋ oŋoma yoŋoojoŋ ii iŋisaambaati, iyoŋonoŋ mono Ama moma mubuya. ");
INSERT INTO ksr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Gawoŋ meŋ uulombogiawo laligojuti, oŋo kuuya mono noonoŋ kagi uugia meŋ afaaŋgoŋ oŋombe haamo mewu. ");
INSERT INTO ksr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Noonoŋ qaqaŋ ii mono sawiŋgianoŋ ama aŋgowu ano niinoŋ nanamemena kuma oŋombe ii mono moma sororogoŋ laligowu. Niinoŋ uuna meŋ kamaaŋ ama gumbonjonjoŋ ejaga koloojeŋiwaajoŋ mono saanoŋ uugia meŋ afaaŋgoŋ oŋombe haamo mokoloowuya. ");
INSERT INTO ksr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Noonoŋ qaqaŋ meŋ aŋgogi sogianoŋ kolooja ano lombo oŋombe bosimbuti, iikanoŋ mono afaaŋa kolooja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kawaa gematanoŋ Sabat kendoŋ moŋnoŋ Jiisasnoŋ wiit dumuŋ gawoŋ koria somata kotoŋ keno. Keno gowokourutanoŋ wosogia iŋiro wiit hoŋa motomotooŋ kanaiŋ borogianoŋ kuma negi. ");
INSERT INTO ksr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Negito, Farisii (Kana qaawaa kaparaŋkoŋkoŋ) tosianoŋ ii iima Jiisas kokaeŋ ijogi, “Moba, goo gowokouruganoŋ mono Sabat kendombaa gawoŋ meme soŋgoya uuguju?” ");
INSERT INTO ksr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kaeŋ ijogi kokaeŋ meleeno, “Kiŋ Deiwidnoŋ manjaqeqe ejauruta yoŋowo liligoŋ wosogia iŋiro iwoi aŋgiti, ii weeŋgogi me qaago? ");
INSERT INTO ksr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Iinoŋ Anutuwaa opo sel jigonoŋ uma bered kowoga Anutuwaa jaasewaŋanoŋ alatanoŋ aŋgi raro esuŋanoŋ tururo qetegogiti, ii mero negi. Bered kowoga mesamesaoya ii jigo gawoŋ galeŋ yoŋonondeeŋ neŋ laligogi. Iinoŋ ano iwaa kerasuru-urutanoŋ ii newubotiwaa soŋgo eroto, ii kileŋ negi. ");
INSERT INTO ksr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kaaŋiadeeŋ jigo gawoŋ galeŋ yoŋonoŋ Sabat kendonoŋ jiwowoŋ jigonoŋ nama gawoŋ meŋ gawoŋ mewutiwaa soŋgo uuguŋ kileŋ qaagiawo mende kolooŋkeju. Qaa ii Kana qaanoŋ weeŋgogi me qaago? ");
INSERT INTO ksr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","“Ii weeŋgogi, kaeŋ mojento, niinoŋ kokaeŋ iŋijomaŋa: Koi nanji, iinoŋ mono jiwowoŋ jigo uuguŋ uuta kolooja. ");
INSERT INTO ksr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Buŋa Terewaa qaa moŋ kokaeŋ eja, “Niinoŋ siimoloŋ oowutiwaajoŋ qaagoto, batugianoŋ kiaŋkomuŋ aowutiwaajoŋ mojeŋ.” Oŋo qaa iikawaa kania mobuyagati eeŋ, ejemba koposowaa qaanana qaa nonoo qaanana mono tondu mende jeŋ tegowuyaga. ");
INSERT INTO ksr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","“Ii kokaembaajoŋ jejeŋ: Siwe gomambaa Eja hoŋanoŋ mono Sabat kendombaa Poŋa kolooja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jiisasnoŋ gomaŋ ii mesaoŋ qamakooli mirigianoŋ uro. ");
INSERT INTO ksr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Iikanoŋ eja boria soosoolia moŋ raro. Ejembanoŋ Jiisas qaa jakeyanoŋ ama mubombaajoŋ kokaeŋ qisiŋ mugi, “Eja Sabat kendonoŋ meagoŋ Kana qaa uuguwoŋa me qaago?” ");
INSERT INTO ksr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Qisiŋ mugi kokaeŋ meleeno, “Oŋoonoŋga moronoŋ kokaeŋ kolooja: Eja mombaanoŋ lama motooŋgonoŋ Sabat kendonoŋ roŋnoŋ kemebaati eeŋ, iinoŋ ii mende meŋ hororo koubaa? ");
INSERT INTO ksr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ejawaa sewaŋanoŋ mono lamawaa sewaŋa mamaga uuguji, mono ii romoŋgowu. Kawaajoŋ Sabat kendonoŋ gawoŋ awaa meŋ kaaŋanoŋ Kana qaa mende uuguwoŋa.” ");
INSERT INTO ksr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kaeŋ meleema eja ii ijoro, “Gii mono boroga qetetereewa.” Kaeŋ ijoro qetetereero wala anoti, iikawaa so awaa kolooŋ boria alia kaaŋa kolooro. ");
INSERT INTO ksr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kaeŋ kolooro Farisii (Kana qaawaa kaparaŋkoŋkoŋ) yoŋonoŋ seleeŋgeŋ kema ajoajoroo ama Jiisas nomaeŋ ama qeniŋ komuwaatiwaa qaa jeŋ moŋgaŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jiisasnoŋ qaagia ii iima kotoŋ iikanondeeŋ gomaŋ ii mesaoŋ moŋgeŋ keno. Keno mamaganoŋ iwaa gematanoŋ otaaŋ keŋgi yoŋoo batugianoŋ ji ejemba kuuya meŋ qeaŋgoŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ii meŋ qeaŋgoŋ oŋoma kania asuganoŋ jewubotiwaajoŋ kotakota qotogoŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kaeŋ kolooro Anutunoŋ gejatootoo eja Aisaia sololooro qaa moŋ jeroti, iikanoŋ mono hoŋawo kolooro. Qaa ii kokaeŋ jerota eja, ");
INSERT INTO ksr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Iibu, koi mono noo gawoŋ ejana kolooro ii meweeŋgoŋ mube. Niinoŋ wombo alana iwaajoŋ mobe kerana qeaŋgoro uunanoŋ iwaajoŋ aisooŋkejeŋ. Niinoŋ Uŋana Toroya iwaa uuta sokombaatiwaajoŋ wasiwe kemero iinoŋ qaa dindiŋagadeeŋ jeŋ tegoŋkejeŋiwaa Buŋa qaaya iŋisaama jeŋ seiro kantria kantria yoŋoonoŋ kembaa. ");
INSERT INTO ksr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Iinoŋ aŋgowowo mende ama qaa tokoroŋkota mende qamakebaa. Ejemba moŋnoŋ iwaa qa otoŋa ii rooŋqeqe kananoŋ mende mobaa. ");
INSERT INTO ksr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Bowo ologogiti, iinoŋ ii mende qosombaa. Lambewaa wikyanoŋ jeŋ kotoŋ sokoya kolooro bolaŋanoŋ jeŋ bobo amakeji, iinoŋ ii mende qebugowaa. Gawoŋa kaeŋ meŋ ejembanoŋ qaa dindiŋa otaawutiwaajoŋ manja qeŋ laligoro qaa iikanoŋ haamo ano otokoriaŋ ambuya. ");
INSERT INTO ksr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kantria kantria yoŋonoŋ mono iinoŋ ilaaŋ oŋombaatiwaajoŋ mamboma joroŋqoroŋgia iwaa qatanoŋ ama laligowuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Omenoŋ eja moŋ qaamuuŋ meŋ muro jaaya gooro moto laligoroti, ii wama Jiisaswaanoŋ kagi. Jiisasnoŋ ii meŋ qeaŋgoro omeya kouma keno neselaŋa lolooro mombo qaa jeŋ uuŋ iiro. ");
INSERT INTO ksr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Uuŋ iiro ejemba tuuŋ kuuya yoŋonoŋ ii iima aaruŋ jegi, “Eja koi kanoŋ mono Deiwidwaa gbilia kolooja me?” ");
INSERT INTO ksr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kaeŋ jegito, Farisii (Kana qaawaa kaparaŋkoŋkoŋ) yoŋonoŋ ii moma kokaeŋ jegi, “Eja koi kanoŋ mombaa ku-usunoŋ qaagoto, omejiilaŋ yoŋoo Poŋgia Iimolaŋ iwaa esuŋnoŋ ome oŋotaaŋkeja.” ");
INSERT INTO ksr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kaeŋ jegito, Jiisasnoŋ uuroromoŋgogia modaboroŋ kokaeŋ iŋijoro, “Kantri daeŋ yoŋoo galeŋurugianoŋ batugianoŋ aŋgowowo ama jumbuti, iyoŋonoŋ mono tiwilaaŋ aogi kantrigianoŋ boliŋ saoyagadeeŋ kolooŋ qeqelalaŋ ewaa. Kaaŋagadeeŋ siti me gomaŋ mombaa kanageso yoŋonoŋ batugianoŋ aŋgowowo ama jumbuti, iyoŋonoŋ mono galeŋkoŋkoŋ gawoŋgia meŋ nambombaajoŋ amamaawuya. ");
INSERT INTO ksr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","“Mobu, Satanoŋ mono alia Satan moŋ otaanagati eeŋ, iyoŋonoŋ mono batugianoŋ aŋgowowo ama jumbuyaga. Kaeŋ kolooro galeŋkoŋkoŋ gawoŋgia mewombaajoŋ amamaagi ometotoŋgianoŋ mono nomaeŋ nanaga? ");
INSERT INTO ksr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Mobu, niinoŋ Iimolambaa esuŋnoŋ omejiilaŋ konjoma oŋombenagati eeŋ, oŋoo alaurugianoŋ mono morowaa esuŋnoŋ ii konjoma oŋombuyaga? Kawaajoŋ yoŋonoŋ mono qaagia hoŋa me qaagoti, ii gosiŋ jeŋ tegowu. ");
INSERT INTO ksr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ii jeŋ tegowuto, Anutuwaa ku-usunoŋ noo boro susuna sololooro omejiilaŋ oŋotaaŋkejeŋi eeŋ, Anutuwaa bentotonoŋ mono oŋoonoŋ kaŋ kuuja. ");
INSERT INTO ksr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Moŋnoŋ eja kotiga Iimolambaa kana boria waladeeŋ mende somoŋgowaati eeŋ, iinoŋ mono nomaeŋ mirianoŋ uma qeŋgama esuhinaya menaga? Waladeeŋ ii somoŋgoro rarogo mono saanoŋ mirianoŋga ilawoilaya kuuya tagoŋ meŋ kembaa. (Iikawaa so niinoŋ kaaŋagadeeŋ Satan somoŋgoŋ gematanoŋ omeya oŋotaaŋkejeŋ.) ");
INSERT INTO ksr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Moŋnoŋ niwo mende laligoji, iinoŋ mono qetegoŋ nomakeja. Moŋnoŋ ejemba noo qanoŋ ajoroowutiwaajoŋ mende horoŋ oŋomakeji, iinoŋ mono mendeema oŋomakeja. ");
INSERT INTO ksr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kawaajoŋ niinoŋ qaa moŋ kokaeŋ iŋijomaŋa: Ejemba siŋgisoŋgo ama mepaqepae kuuya amakejuti, ii Anutunoŋ saanoŋ mesaoŋkejato, moŋnoŋ Uŋa Toroya mepaegowaati, iikawaa siŋgisoŋgoya Anutunoŋ mono kambaŋ moŋnoŋ mende mesaowaa. Qaago totooŋ! ");
INSERT INTO ksr_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","“Moŋnoŋ Siwe gomambaa Eja hoŋa mepaegoŋ qaa jewaati eeŋ, Anutunoŋ ii saanoŋ mesaowaato, moŋnoŋ Uŋa Toroya mepaegoŋ qaa iwoi jewaati, iwaa siŋgisoŋgoya ii Anutunoŋ namonoŋ laligowaatiwaa so me koomu gematanoŋ kanoŋ mende mesaowaa. ");
INSERT INTO ksr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Gerewaa kania ii hoŋa iima gosiŋ mojoŋ. Kawaajoŋ mono gere galeŋ koŋgi awaa kolooro hoŋa awaa kolooŋkebaa me gere meŋ boligi hoŋa bologa kolooŋkebaa. ");
INSERT INTO ksr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Eja uutanoŋ iwoi saa qeŋ eji, ii mono buutanoŋ asuganoŋ jeŋkeja. Kawaajoŋ oŋoaŋgio qatowaa merauruta kolooju. Bologa kaaŋ kolooŋ mono nomaeŋ qaa awaa jewuyaga? ");
INSERT INTO ksr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Eja awaawaa uu kowianoŋ iwoi awaawaa moriaŋa eji, iinoŋ mono awaa ii asuganondeeŋ jeŋkeja. Eja bologaa uu kowianoŋ iwoi bologaa moriaŋa eji, iinoŋ mono bologa ii asuganoŋ jeŋkeja. ");
INSERT INTO ksr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Kaeŋ jeŋkejato, niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Ejembanoŋ soŋgo waleema qaa je omaya omaya jewuti, iyoŋonoŋ mono qaa jegia kuuyaa kania ii jenteegowaa kambaŋ somatanoŋ Anutuwaajoŋ jeŋ asarigi gosiwaa. ");
INSERT INTO ksr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Iikawaa kania ii kokaeŋ: Anutunoŋ mono qaa jega gosiŋ iikawaa so qaaga jeŋ tegoro solaŋaniwaga me qaagawo kolooŋ lombo mokoloowaga. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kambaŋ kanoŋ Farisii (Kana qaawaa kaparaŋkoŋkoŋ) ano Kana qaawaa boi tosianoŋ Jiisaswaajoŋ kokaeŋ ijogi, “Boi, gii saanoŋ aŋgoleto moŋ mena ii iibombaajoŋ mojoŋ.” ");
INSERT INTO ksr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kaeŋ ijogi kokaeŋ meleema oŋono, “Ejemba kete namonoŋ laligojuti, ii tuuŋ somata bologa kolooŋ serowiliŋ amakeju. Yoŋonoŋ Anutuwaa aiweseyaajoŋ kaparaŋ komakejuto, aiwese moŋ gejatootoo eja Joonawaanoŋ mono koloodabororo. Anutunoŋ aiwese morota moŋ mende ama oŋombaa. ");
INSERT INTO ksr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Joonanoŋ gomamboria karooŋ kowe osombaa (gajugaju) tomeŋanoŋ laligoroti, kawaa so Siwe gomambaa Eja hoŋanoŋ kaaŋagadeeŋ gomamboria karoombaa so baloŋ uutanoŋ ewaa. ");
INSERT INTO ksr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Joonanoŋ Niiniwe ejemba batugianoŋ kema Anutuwaa qaanoŋ uugia kuuro moma iikanondeeŋ uugia meleeŋgito, mobu, niinoŋ batugianoŋ asugiŋ nama Joonawaa nanamemeŋa uuguŋ amakejeŋ. Kaeŋ amakejento, oŋo kileŋ telambelaŋ ama nomakeju. Kawaajoŋ Niiniwe ejembanoŋ jenteegowaa kambaŋ somatanoŋ ejemba tuuŋ somata koi nanjuti, oŋowo ororoŋ koomunoŋga waama oŋoo kooroŋgianoŋ motooŋ nambu. Motooŋ nama Niiniwe yoŋonoŋ qaa kokaeŋ oŋoo selegianoŋ kuuwuya, ‘Oŋo Siwe gomambaa Eja hoŋa telambelaŋ ama mugi Anutunoŋ iroŋa meleema oŋono siimbobolo uuta mobuya.’ Niiniwe yoŋonoŋ kaeŋ jegi nanamemeŋgianoŋ oŋoaŋgiaa kaniagia iŋisaaŋgi gamugia mobuya. ");
INSERT INTO ksr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Kaniagiaa kaisareya moŋ ii kokaeŋ: Anutunoŋ kerugeŋ momakooto uuta somata ii kiŋ Solomon muro Saut waageŋga kantri mombaa kwiin embanoŋ Solomombaa momakootoya momambaajoŋ siiŋa moro. Siiŋa moma gomaŋ goraayanoŋga waama kana koriga tintiŋ kaŋ laligoŋ Solomombaa momoya moro. “Ii moroto, mobu, kambaŋ kokaamba niinoŋ batugianoŋ kolooŋ nama Anutuwaanoŋ momakooto uuta meŋ kajeŋi, ii Solomombaa momakootoya uuguja. Uugujato, oŋo kileŋ telambelaŋ ama noma tompiŋ laligogi mende sokonja. Kawaajoŋ Anutunoŋ kanageŋ ejemba korebore horoŋ oŋoma qaagia jeŋ tegowaatiwaajoŋ jaayanoŋ keubuti, kambaŋ iikanoŋ Saut kantriwaa kwiin emba iikanoŋ mono kaaŋagadeeŋ keubaa. Iinoŋ ejemba tuuŋ somata koi nanjuti, oŋowo ororoŋ koomunoŋga waama oŋoo kooroŋgianoŋ motooŋ nambaa. Motooŋ nama qaa kokaeŋ oŋoo selegianoŋ kuuwaa, ‘Oŋo Jiisas telambelaŋ ama mugi Anutunoŋ iroŋa meleema oŋono siimbobolo uuta mobuya.’ Iinoŋ kaeŋ jero oŋonoŋ siligia gosiŋ oŋoaŋgiaajoŋ gamugia mobuya. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Omenoŋ eja uutanoŋga kouma baloŋ qararaŋkoŋkoŋanoŋ kema laŋ liligoŋ laligoŋ haamo memambaajoŋ miri moŋgama moŋ mende mokoloowaa. ");
INSERT INTO ksr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ii mende mokolooŋ mojoya tiiro kokaeŋ jewaa, ‘Mirina mesaoŋ kaweti, iikanoŋ mono mombo eleemaŋa.’ Kaeŋ jeŋ eleema miria usuma menjereŋgoro eroti, ii gbameŋa ero mokoloowaa. ");
INSERT INTO ksr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","“Kaeŋ mokolooŋ kema omejiilaŋ tosaaŋa 7 uŋuambaa. Omejiilaŋ 7 ii iyaŋa uuguŋ bologa totooŋ kolooju. Iinoŋ ii uŋuano kaŋ miri ii uma iikawaa uutanoŋ laligowuya. Kaeŋ kolooro eja iikawaa kania wala kileŋkileŋ kolooroto, kanageŋ boliqolidaborowaa. Ejemba tuuŋ somata bologa koi kete namonoŋ laligojuti, oŋoonoŋ kaaŋagadeeŋ kaeŋ koloowaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jiisasnoŋ toroqeŋ ejemba tuuŋ qaa iŋijoŋ laligoro nemuŋkoganoŋ kaŋ seleeŋgeŋ nama iwo qaa jewombaajoŋ mogi. ");
INSERT INTO ksr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mogi moŋnoŋ kokaeŋ ijoro, “Moba, goo nemuŋkoganoŋ mono seleeŋgeŋ nama giwo qaa jewombaajoŋ moju.” ");
INSERT INTO ksr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Qaa ii ijoroto, iwaajoŋ meleema kokaeŋ jero, “Noo nemuna ii moronoŋ? Noo kouruna ii moronoŋ?” ");
INSERT INTO ksr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kaeŋ jeŋ boria gowokouruta yoŋoonoŋ baageŋ boraama jero, “Iibu, noo nemuna ano kouruna hoŋa mono koi. ");
INSERT INTO ksr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Daeŋ yoŋonoŋ noo Siwe Maŋnaa uusiiŋa teŋ komakejuti, kuuya iyoŋonoŋ mono noo nemuna ano naaŋkouruna kolooju.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kambaŋ iikanondeeŋ Jiisasnoŋ gomaŋ ii mesaoŋ apu aŋgoŋ goraayanoŋ kemeŋ raro. ");
INSERT INTO ksr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Raro ejemba tuuŋlelembenoŋ iwaanoŋ kema ajoroogi waŋgonoŋ uma raro. Raro ejemba tuuŋ kuuya yoŋonoŋ aŋgoŋ goraayanoŋ sakasinoŋ ajoroogi. ");
INSERT INTO ksr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kaeŋ ajoroogi sareqaa mamaga jeŋ kokaeŋ jero, “Mobu! Eja moŋnoŋ nene kota qosoma kororoomambaajoŋ gawonoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kema qosoma kororooro kota tosianoŋ kana goraayanoŋ kemeŋ koŋgi. Kemeŋ koŋgi (waraweŋ) kooŋa kooŋa kouma ii nedaborogi. ");
INSERT INTO ksr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","“Kota tosianoŋ jamo kowonjinoŋ kemeŋ koŋgi. Kemeŋ koma kanoŋ namo mamaga mende mokoloogi. Namo dusiita qaa erotiwaajoŋ kuragagia uulaŋawo kougi. ");
INSERT INTO ksr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kougito, weeŋnoŋ kouma iŋiima jeŋ kotoŋ oŋono tiigia qaagotiwaajoŋ sooliŋ gororoŋgogi. ");
INSERT INTO ksr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","“Kota tosianoŋ kumuntiri waayawonoŋ kemeŋ koŋgi. Kemeŋ koŋgi iikanoŋ kouma qeŋ turuŋ bibiloko meŋ oŋoŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kaeŋ jaŋgoŋ qaonoto, kota tosianoŋ namo awaanoŋ kemeŋ koŋgi. Kemeŋ koma tosaaŋa kogia 100 koloogi. Tosia kogia 60, tosia 30 iikawaa so kolooŋ seigi. ");
INSERT INTO ksr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Moŋnoŋ uugejiawo laligoji eeŋ, iinoŋ mono sareqaa koi geja ama moma kotowa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kaeŋ jero gowokourutanoŋ kaŋ Jiisas kokaeŋ qisiŋ mugi, “Gii mono naambaajoŋ ejemba yoŋoo qaa jemanjeŋ sareqaanoŋ ama jeŋkejaŋ?” ");
INSERT INTO ksr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Qisiŋ mugi kokaeŋ meleema iŋijoro, “Ii kokaembaajoŋ: Siwewaa bentotonoŋ keuma laligowoŋatiwaa qaa aasaŋgoya ii oŋo asuganoŋ iŋijowe moma kotojuto, iyoŋoonoŋ ii kaeŋ qaago. ");
INSERT INTO ksr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","“Kawaa kania ii kokaeŋ: Moŋnoŋ momakootoyawo laligoji, Anutunoŋ mono ii toroqeŋ muro koma gbiliŋ moriaŋawo laligowaato, moŋnoŋ momakootoya qaa laligoji, Anutunoŋ mono momoya melaa eji, ii kaaŋagadeeŋ qetegoŋ wambaa. ");
INSERT INTO ksr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","“Ejemba yoŋoo qaa jemanjeŋ kokaembaajoŋ sareqaanoŋ ama jeŋkejeŋ: Yoŋonoŋ iyaŋgiaa jaagianoŋ iwoi iimago kania kileŋ mende iima kotowuya. Iyaŋgiaa gejagianoŋ qaa tororo momago kania kileŋ mende moma asariwuya. ");
INSERT INTO ksr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Gejatootoo eja Aisaianoŋ waladeeŋ qaa moŋ jeŋ ooroti, iikanoŋ ejemba kaaŋa yoŋoojoŋ hoŋawo kolooŋkeja. Qaa ii kokaeŋ, ‘Qaa moma bimbimgoŋgo kania kileŋ mende moma asariwuya. Iwoi iima bimbimgoŋgo kania kileŋ mende iima kotowuya. ");
INSERT INTO ksr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ejemba tuuŋ somata koi yoŋoo uugianoŋ mono kotakota gojoma eja. Gejagianoŋ qaa moma bimbimgoŋgo jaagia komujulaaŋ laligoju. Kaeŋ mende ambuyagati eeŋ, mono jaagianoŋ iwoi iima kotoŋ gejagianoŋ qaa moma uugianoŋ kania moma asariŋ uugia meleeŋgi niinoŋ ii saanoŋ meŋ qeaŋgoŋ oŋombenaga.’ ");
INSERT INTO ksr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Qaa kaeŋ ejato, oŋoo jaagianoŋ iwoi iima kotojiwaajoŋ mono simbawoŋawo kolooju. Gejagianoŋ qaa moma kotojiwaajoŋ mono simbawoŋawo kolooju. ");
INSERT INTO ksr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Niinoŋ qaa hoŋa tooŋ moŋ kokaeŋ iŋijomaŋa: Gejatootoo ejemba ano Anutuwaanoŋ ejemba solaŋa mamaganoŋ oŋo iwoi koi iijuti, ii iibombaajoŋ awelegoŋ laligogito, ii mende iigi. Oŋo qaa koi mojuti, yoŋonoŋ ii mobombaajoŋ uuqeeaŋgo somata moma laligogito, ii mende mogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Qosomakororoo ejawaa sareqaa jejeŋi, iikawaa kania ii mono geja ama mobu. ");
INSERT INTO ksr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nene kota qosoma kororooro kana goraayanoŋ kemeŋ konoti, ii kokaeŋ: Moŋnoŋ bentotombaa Buŋa qaaya moma kania mende moma asariro Kileŋaa Toyanoŋ kaŋ uutanoŋ kota komogiti, ii qetegowaa. ");
INSERT INTO ksr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nene kota qosono jamo kowonjinoŋ kemeŋ konoti, ii ejemba sareya moŋ. Yoŋonoŋ Buŋa qaa moma ii iikanondeeŋ uuqeeaŋgo qaganoŋ moma aŋgoŋ komakeju. ");
INSERT INTO ksr_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","“Kaeŋ amakejuto, uugianoŋ tiita mende eŋ oŋombaato, kambaŋ torodaamoŋgadeeŋ nama kotiiŋ laligowuya. Buŋa qaawaajoŋ ama kakasililiŋ me sisiwerowero kolooro kambaŋ iikanondeeŋ mono tama uŋuwaa. ");
INSERT INTO ksr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nene kota qosono kumuntiri waayawonoŋ kemeŋ koŋgiti, ii kokaeŋ: Yoŋonoŋ Buŋa qaa mogi uugianoŋ kemejato, balonoŋ laaligowaa majakakaya ano moneŋ hina memewaa uugereya kolooŋ bimooŋ oŋomakeja. Qabuŋagiawo koloowombaajoŋ koposoŋgogi siiŋ kombombaŋa bologa tosianoŋ kaaŋagadeeŋ uugianoŋ duŋguŋ Buŋa qaa bibiloko meŋ muŋkeja. Kaeŋ kolooro hoŋgia qaa auta (gipeya) koloowuya. ");
INSERT INTO ksr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Nene kota namo awaanoŋ qosono kemeŋ koŋgiti, ii ejemba koi kaaŋa: Yoŋonoŋ Buŋa qaa geja ama moma moma asariŋ pondaŋ nama hoŋgia mokolooŋkeju. Tosianoŋ qaa je motooŋgonoŋga kota 30 mokolooŋkeju. Tosianoŋ hoŋgia 60, tosianoŋ qaa kota motomotooŋ yoŋoo hoŋgia 100 meŋ seiŋ mokolooŋkeju.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jiisasnoŋ sareqaa moŋ kokaeŋ jero, “Siwewaa bentotoŋaa kania ii eja kokaaŋaa so ama jemaŋa. Iinoŋ gawoŋanoŋ kema nene kota awaa qosoma kororooro. ");
INSERT INTO ksr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Qosoma kororooroto, gomantiiŋanoŋ egi kanoŋ kere ejanoŋ kaŋ wiit dumuŋ batugianoŋ kanoŋ qiŋqiliwaa kota qosoma kororooŋ mesaoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wiit dumuŋ kotanoŋ juma waama uma hoŋa asugiroti, kambaŋ iikanoŋ qiŋqilinoŋ kaaŋagadeeŋ asuganoŋ asugiro. ");
INSERT INTO ksr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Asuganoŋ asugiro weleŋqeqeurutanoŋ ii iima gawoŋ toyaanoŋ kaŋ kokaeŋ ijogi, ‘Somatanana, gawoŋganoŋ nene kota awaa qosoma kororoona me qaago? Qiŋqiliwaa kota ii mono daaŋkaya iikanoŋ asugija?’ ");
INSERT INTO ksr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Kaeŋ ijogi kokaeŋ iŋijoro, ‘Kere ejanoŋ ii qosoma kororooro.’ Kaeŋ iŋijoro weleŋqeqe yoŋonoŋ kokaeŋ jegi, ‘Nono saanoŋ kema qiŋqili ii qonjoma meŋ kululuuwoŋatiwaajoŋ mojaŋ me qaago?’ ");
INSERT INTO ksr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Kaeŋ jegito, kokaeŋ iŋijoro, ‘Qaago! Oŋo qiŋqili qonjoma meŋ kululuuŋ iikanoŋ dumuŋ tosaaŋa ii kaaŋagadeeŋ qonjombubo. ");
INSERT INTO ksr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","“Mono mesaogi motooŋ somariiŋ hoŋa memeyaa kambaŋa kaŋ kuuro niinoŋ kambaŋ iikanoŋ dumuŋ kuŋkuŋ ejemba ii kokaeŋ iŋijomaŋa: Mono wala qiŋqili meŋ kululuuŋ aŋgi jewaatiwaajoŋ boraŋgoŋ kasanoŋ somoŋgowu. Ii somoŋgoŋgo mono wiit dumuŋ hoŋa ii meŋ kululuuŋ meŋ kaŋ noo kowi mirinoŋ ambu.” ’ Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jiisasnoŋ sareqaa moŋ kokaeŋ toroqeŋ iŋijoro, “Siwewaa bentotoŋa ii kokaeŋ: Eja moŋnoŋ nejoŋ kota meŋ aŋaa gawoŋ namoyanoŋ kema ano. ");
INSERT INTO ksr_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kota ii melaa kazupuleenda. Ii nene kota kuuya iyoŋoo kamaaŋqeqetagia koloojato, juma waama logoya kuuya uŋuuguŋ somariiŋ gere koloowaa. Kaeŋ kolooŋ nano kanakeewambaa kooŋa kooŋa kouma haigia gere iikawaa borianoŋ amakeju.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jiisasnoŋ duŋanoŋ mombo sareqaa moŋ kokaeŋ jero: “Siwewaa bentotoŋa ii yiist me flaua meŋ somasomariiwaa so kokaeŋ kolooja: Emba moŋnoŋ bered oomanjeŋ yiist meŋ flaua konde karooŋ kanoŋ mindiriŋ meleŋqeleeŋ ama kema raro korebore somariiro.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jiisasnoŋ qaa kuuya ii kanageso yoŋoojoŋ sareqaanoŋ jero. Sareqaaya qaa kaeŋ qaa moŋ mende iŋijoro. ");
INSERT INTO ksr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kaeŋ kolooro Anutunoŋ gejatootoo eja moŋ sololooro qaa moŋ jeroti, iikanoŋ hoŋawo kolooro. Iinoŋ qaa ii kokaeŋ jero eja, “Noo buunanoŋ mono afaaŋgoro sareqaaya qaaya jemaŋa. Anutunoŋ namo mokolooro asugiroti, kambaŋ iikanondeeŋ qaa aasaŋgoyanoŋ ero laligoŋ kouniŋi, niinoŋ mono qaa ii asuganoŋ jeŋ iŋisaamaŋa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jiisasnoŋ sareqaa ii jedaboroŋ ejemba tuuŋ somata oŋomesaoŋ miri uutanoŋ uro. Uro gowokourutanoŋ iwaanoŋ kaŋ kokaeŋ qisiŋ muŋ ijogi, “Qiŋqili nene gawonoŋ asugiroti, gii mono sareqaa iikawaa kania jeŋ asariŋ nonomba.” ");
INSERT INTO ksr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kaeŋ ijogi kokaeŋ meleema iŋijoro, “Siwe gomambaa Eja hoŋanoŋ mono nene kota awaa awaa qosoma kororooŋkeja. ");
INSERT INTO ksr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nene gawoŋ ii namowaa kantri kuuya. Nene kota awaa ii bentotombaa meraboraaŋa oŋoojoŋ jejeŋ ano qiŋqili ii eja bologaa meraboraaŋa yoŋoojoŋ jejeŋ. ");
INSERT INTO ksr_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kerenoŋ ii qosoma kororooroti, ii Kileŋaa Toyaajoŋ jejeŋ. Dumuŋ kuŋkuŋ kambaŋa ii namowaa kambaŋa tegowaatiwaa kambaŋa somata ii. Dumuŋ kuŋkuŋ ejemba ii Siwe gajoba yoŋoojoŋ jejeŋ. ");
INSERT INTO ksr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Qiŋqili meŋ kululuuŋ gerenoŋ aŋgi jewaati, iikawaa so mono namowaa kambaŋa tegowaatiwaa kambaŋa somatanoŋ koloowaa. ");
INSERT INTO ksr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Siwe gomambaa Eja hoŋanoŋ mono gajobauruta wasiŋ oŋono kaŋ qaa areŋ bologa Kraistwaa bentotoŋ uutanoŋ siŋgisoŋgo ambombaajoŋ kondooŋkeji, ii qewagoŋ mindiŋgowu ano ejemba jeulalaŋa kuuya ii kululuuŋ oŋombuya. ");
INSERT INTO ksr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","“Kaeŋ mindiŋqindiŋ ama ejemba ii hagoŋ oŋoŋgi gere tombo taŋururuŋ jeŋ eji, iikanoŋ kemebuya. Iikanoŋ kemebuti, iyoŋonoŋ mono saama gigilaaŋ gobugia kigi qaro laligowuya. ");
INSERT INTO ksr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kambaŋ iikanoŋ ejemba solaŋa yoŋonoŋ mono weeŋ kaaŋa kolooŋ Maŋgiaa bentotoŋ uutanoŋ asariŋ laligoŋ ubuya. Moŋnoŋ uugejiawo laligoji, iinoŋ mono qaa ii geja ama moma kotowa. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Siwewaa bentotoŋa ii maa damandaŋ sewaŋa uuta iikawaa so kokaeŋ kolooja: Ii gawonoŋ mesaŋgogi ero eja moŋnoŋ ii mokolooŋ aŋaliŋ aŋgoŋ koma mombo namonoŋ mesaŋgoro. Mesaŋgoŋ iikawaajoŋ aisooŋ kema esuhinaya kuuya sewaŋa mewutiwaajoŋ ano moneŋ karo iikanoŋ gawoŋ baloŋ ii sewaŋa mero.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Siwewaa bentotoŋa ii stua ejawaa so ama sareqaa moŋ kokaeŋ jemaŋa: Iinoŋ soroŋ kota moŋgama laligoro. ");
INSERT INTO ksr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Moŋgama laligoŋ soroŋ kota motooŋgo sewaŋa somata ii mokolooŋ kema esuhinaya kuuya sewaŋa mewutiwaajoŋ ano moneŋ karo iikanoŋ soroŋ kota ii sewaŋa mero.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Siwewaa bentotoŋa ii misawaa so ama sareqaa moŋ kokaeŋ jemaŋa: Ii apu aŋgonoŋ giligi kemero sora tanigia kania kania kemegi oŋoma meŋ kululuuro. ");
INSERT INTO ksr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Meŋ kululuuro saa qero ejembanoŋ ii horogi goraayanoŋ kouro kamaaŋ rama sora awaa gosiŋ kondenoŋ meŋ kululuugito, soro bologa ii giligi keno. ");
INSERT INTO ksr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Qaa iikawaa so mono namowaa kambaŋa tegowaatiwaa kambaŋa somatanoŋ koloowaa. Siwe gajoba yoŋonoŋ kaŋ ejemba bologa ii solaŋa yoŋoonoŋga gosiŋ oŋombu. ");
INSERT INTO ksr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Gosiŋ oŋoma ejemba bologa ii giligi gere tombo taŋururuŋ jeŋ eji, iikanoŋ kemebuya. Kanoŋ kemebuti, iyoŋonoŋ mono saama gigilaaŋ gobugia kigi qaro laligowuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jiisasnoŋ sareqaa ii jedaboroŋ kokaeŋ qisiŋ oŋono, “Qaa kuuya jejeŋi, ii moma asariju me qaago?” Qisiŋ oŋono meleema “Ooŋ!” ijogi. ");
INSERT INTO ksr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","“Ooŋ!” ijogi kokaeŋ iŋijoro, “Miri toyanoŋ miriaa kowianoŋga hina iwoi walaga ano gbilia unjuma amakeja. Iikawaa so Kana qaawaa boi kuuya Siwe bentotombaa gowokouruta koloogiti, iyoŋonoŋ mono kaaŋagadeeŋ uugiaa kowianoŋga qaa akadamugiawo doŋgoga ano qaa awaa soro walaga unjuma jeŋkeju.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jiisasnoŋ sareqaa ii jedaboroŋ gomaŋ baloŋ ii mesaoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Kema neŋsoomari taoŋanoŋ keuma qamakooli mirigianoŋ uma Buŋa qaa kuma oŋono. Kuma oŋono aaruŋ waliŋgoŋ kokaeŋ jegi, “Yei, gejajuju! Iinoŋ momakooto koi ano aŋgoleto ku-usuŋawo ii mono daeŋkaya meja? ");
INSERT INTO ksr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Eja koi mono gomaŋ kokawaa motoŋqeqe ejawaa meriaga. Nemuŋaa qata Maria ano kouruta Jeims, Joosef, Saimon ano Juuda. Ii saanoŋ mojoŋ. ");
INSERT INTO ksr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Naaŋurutanoŋ kuuya batunananoŋ koi laligoju. Kawaajoŋ iwoi kuuya koi mono daeŋkaya meŋ kaŋ anja?” ");
INSERT INTO ksr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nazaret yoŋonoŋ kaeŋ jegi uugianoŋ boliro iikanoŋ osigi. Osigito, Jiisasnoŋ kokaeŋ iŋijoro, “Gejatootoo eja ii iyaŋaa taonoŋ ano iyaŋaa mirinoŋ jejewili ama muŋkejuto, gomaŋ tosianoŋ iikaaŋa qaago.” ");
INSERT INTO ksr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kaeŋ iŋijoro momalaarigianoŋ mende kolooro yaŋgiseŋgiaajoŋ ama aŋgoleto ku-usuŋawo ii iikanoŋ mamaga mende mero. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kambaŋ kanoŋ baloŋ bakayaa (Galili prowinswaa) kiŋ Herod iinoŋ Jiisaswaa bujuya moro. ");
INSERT INTO ksr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ii moma weleŋqeqeuruta ii kokaeŋ iŋijoro, “Ii mono Jon Oomulu ejaga. Iinoŋ mono koomunoŋga waama gawoŋ mero aŋgoleto ku-usuŋawo kolooŋkeju.” Majakaka moma kaeŋ iŋijoro. ");
INSERT INTO ksr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ii kokaembaajoŋa jero: Herodnoŋ koga Filipwaa embia Herodias oloŋ mero Jon Oomulu ejanoŋ kiŋ jeŋ muro opotoro wasiŋ oŋono kema Jon meŋ somoŋgoŋ kapuare mirinoŋ ooŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jonoŋ Herodwaajoŋ qaa kokaeŋ jero, “Gii qamboga meŋ laligoŋ Kana qaa uugujaŋ.” ");
INSERT INTO ksr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kaeŋ jero Herodnoŋ Jon qegi komuwaatiwaa moroto, kanageso yoŋonoŋ Jombaajoŋ mogi gejatootoo ejaga laligoroti, iikawaajoŋ kanageso yoŋoojoŋ toroko moro. ");
INSERT INTO ksr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Toroko moroto, Herodwaa kolokoloo kambaŋanoŋ karo somataurutanoŋ ajorooŋ ragi Herodiaswaa boratanoŋ yoŋoo jaagianoŋ danis ano Herodnoŋ iikawaa iimasiiŋa mamaga moro. ");
INSERT INTO ksr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kawaajoŋ emba saraŋ iikanoŋ naa iwoiwaajoŋ qisinaga, kiŋnoŋ ii togoŋ mumambaajoŋ qaa somoŋgoŋ qaaya ii jojopaŋ qaanoŋ jeŋ kotiiro. ");
INSERT INTO ksr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kaeŋ jeŋ kotiiro nemuŋanoŋ emba saraŋ ii kuuŋ muro kokaeŋ ijoro, “Mono qisina Jon Oomulu ejawaa aroya kotoŋ waŋa kondenoŋ ama meŋ kaŋ nomba.” ");
INSERT INTO ksr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kaeŋ ijoro kimbaa uutanoŋ kobooro wosobiri moroto, jojopaŋ qaaya jero somataurutanoŋ ii mogiti, iyoŋoo jaagianoŋ kamaaŋ qewabotiwaajoŋ ama Jombaa waŋa mubutiwaajoŋ jeŋ kotoro. ");
INSERT INTO ksr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kaeŋ jeŋ kotoŋ opotoroya moŋ wasiŋ jero, “Gii mono kapuare mirinoŋ kema Jombaa aroya kotoŋ waŋa meŋ kawa.” ");
INSERT INTO ksr_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kaeŋ jero Jombaa waŋa kondenoŋ ama meŋ kaŋ emba saraŋ ii muro meŋ kema nemuŋa muro. ");
INSERT INTO ksr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jombaa gowokourutanoŋ iikawaa bujuya moma kema qamoya meŋ qasiriwaa jamo kobaanoŋ ama roŋ koŋgi. Roŋ koma kema qaa ii Jiisas ijogi moro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jiisasnoŋ Jombaa sunduya moma gomaŋ ii mesaoŋ waŋgonoŋ uma baloŋ gbameŋa moŋnoŋ iyaŋgiodeeŋ laligowombaajoŋ keŋgi. Ejemba tuuŋ yoŋonoŋ iikawaa bujuya moma taoŋ ano gomaŋgia mesaoŋ Jiisaswaa gematanoŋ otaaŋ baloŋ kana keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Keŋgi Jiisasnoŋ waŋgonoŋga kamaaŋ ejemba tuuŋ somata iŋiima yoŋoojoŋ wosoya moro. Wosoya moma batugianoŋ ji iŋiro laligogiti, ii meŋ qeaŋgoŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kaeŋ ama laligoro mare kolooro gowokourutanoŋ Jiisaswaanoŋ kaŋ kokaeŋ jegi, “Boi, nono baloŋ gbameŋa kokanoŋ laligoniŋ weeŋ jaaya tegoŋ kememambaajoŋ anja. Kawaajoŋ gii saanoŋ ejemba tuuŋ koi wasiŋ oŋona gomaŋa gomaŋa kanoŋ kema nembanenegia sewaŋa meŋ newu.” ");
INSERT INTO ksr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kaeŋ jegito, Jiisasnoŋ kokaeŋ iŋijoro, “Yoŋonoŋ saanoŋ kokanoŋ rabu. Oŋonoŋ mono oŋoaŋgio ii nene uŋuagiwu.” ");
INSERT INTO ksr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kaeŋ iŋijoro jegi, “Nono bered 5 ano sora woi iikaaŋ meŋ laligojoŋ.” ");
INSERT INTO ksr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kaeŋ jegi iŋijoro, “Mono ii meŋ kaŋ nombu.” ");
INSERT INTO ksr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kaeŋ iŋijoŋ ejemba tuuŋ somata ii jiiro lolonoŋ kamaaŋ rabutiwaajoŋ jeŋ kotoŋ oŋono ragi. Ragi bered 5 ano sora woi ii meŋ Siwenoŋ uuro uro kotuegoŋ bered motoŋ gowokouruta oŋono ejemba tuuŋ so mendeema oŋoŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mendeema oŋoŋgi ejemba korebore neŋ neŋ timbiriŋgogi. Neŋ timbiriŋgoŋ nene kitia reremoŋa mesaogiti, ii gowoko yoŋonoŋ meŋ kululuugi konde 12 kanoŋ kemeŋ saa qero. ");
INSERT INTO ksr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Eja bered negiti, iyoŋoo jaŋgogia ii 5,000. Emba merabora yoŋoo jaŋgogia ii mende megi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Negi tegoro Jiisasnoŋ iikanondeeŋ gowokouruta jeŋ kotoŋ oŋoma kokaeŋ jero, “Oŋo mono waŋgonoŋ uma waladeeŋ apu aŋgoŋ kotoŋ leegeŋ kembu. Niinoŋ saanoŋ kambaŋ biiwianoŋ ejemba tuuŋ koi oŋoombe keŋgigo kamaŋa.” ");
INSERT INTO ksr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kaeŋ jeŋ ejemba oŋoono keŋgi baaŋanoŋ uma aŋodeeŋ laligoŋ qama kooliro. Qama kooliŋ laligoro mare kolooro baaŋanoŋ yaŋabuju raro. ");
INSERT INTO ksr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Raro waŋgogianoŋ apu aŋgoŋ biiwianoŋ koriganoŋ keno haamonoŋ keŋgiti, iikaaŋ baageŋga qeŋ karo sirinoŋ waŋgo kuuŋ giliro keqelaŋ kema karo. ");
INSERT INTO ksr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kaeŋ ano gomaŋ aworaŋgoro (3-6 kilok) iikanondeeŋ Jiisasnoŋ apu aŋgoŋ qaganoŋ riiŋ riiŋ gowokouruta yoŋoonoŋ karo. ");
INSERT INTO ksr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kaŋ apu aŋgoŋ qaganoŋ riiŋ riiŋ karo gowokourutanoŋ ii iima aaruŋ toroko moma jeneŋgia ororo “Kowe Soŋgorinoŋ kaja,” jeŋ sombugia moma qama qa gigilaagi. ");
INSERT INTO ksr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Qama qa gigilaagito, Jiisasnoŋ iikanondeeŋ qaa jeŋ kokaeŋ iŋijoro, “Alauruna, mono qaqabuŋabuŋagiawo satiiŋ laligowu. Neeno kajeŋ. Toroko mende mobu.” ");
INSERT INTO ksr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kaeŋ iŋijoro moma Piitonoŋ meleema kokaeŋ ijoro, “Giinoŋ Poŋga koloojaŋi eeŋ, mono saanoŋ jena niinoŋ apu qaganoŋ riiŋ riiŋ goonoŋ kamaŋa.” ");
INSERT INTO ksr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jiisasnoŋ ii moma “Saanoŋ kawa,” ijoro. Kaeŋ ijoro Piitonoŋ waŋgo mesaoŋ apu aŋgoŋ qaganoŋ riiŋ riiŋ kanaiŋ Jiisaswaanoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kanaiŋ kenoto, haamonoŋ mamaga qeŋ siri karo iima toroko moma jeneŋa ororo kanaiŋ apu uutanoŋ kemeŋ kokaeŋ qaro, “Poŋ, mono ilaaŋ nomba!” ");
INSERT INTO ksr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Qaro Jiisasnoŋ iikanondeeŋ boria boraama Piitowaa borianoŋ meŋ kokaeŋ ijoro, “Momalaariga ii melaada. Mono naambaajoŋ uuwoi anjaŋ?” ");
INSERT INTO ksr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kaeŋ ijoŋ ilaaŋ muro waŋgonoŋ uri haamonoŋ goroŋ qero sirinoŋ noŋ qero. ");
INSERT INTO ksr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Noŋ qero eja waŋgonoŋ ragiti, iyoŋonoŋ waeya meŋ mepeseeŋ muŋ kokaeŋ jegi, “Oŋanoŋ, gii Anutuwaa meriaga.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Apu aŋgoŋ kotoŋ leegeŋ Genesaret gomanoŋ keuma waŋgo mesaoŋ sakasinoŋ kemegi. ");
INSERT INTO ksr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Sakasinoŋ kemegi gomaŋ iikawaa ejembaya Jiisas moma kotoŋ mugi. Moma kotoŋ muŋ qaa aŋgi gomaŋ kuuya kosianoŋ ragiti, iikanoŋ keno bujuya moma ji ejemba kuuya uŋuama Jiisaswaanoŋ kagi. ");
INSERT INTO ksr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kaŋ nama Jiisaswaa maleku susuyanoŋ oosiriwombaajoŋ welema muŋ laligogi. Oosirigiti, kuuya iyoŋonoŋ mono qeaŋgodaborogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kawaa gematanoŋ Farisii (Kana qaawaa kaparaŋkoŋkoŋ) ano Kana qaawaa boi tosianoŋ Jerusalem sitinoŋa Jiisaswaanoŋ kaŋ kokaeŋ qisiŋ mugi, ");
INSERT INTO ksr_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Goo gowokouruganoŋ mono naambaajoŋ kana uuguŋ ambosakoŋurunana yoŋoonoŋ sili mende otaaju? Yoŋonoŋ mono borogia soŋgbama hamo mende qeŋ kileŋ kanaiŋ nembanene neju?” ");
INSERT INTO ksr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Kaeŋ qisiŋ mugi kokaeŋ iŋijoro, “Oŋoaŋgio mono naambaajoŋ ambosakonana yoŋoonoŋ sili otaawombaajoŋ kana uuguŋ Anutuwaanoŋ jojopaŋ qaa qeŋkeju? ");
INSERT INTO ksr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kawaa qaaya moŋ ii kokaeŋ: Anutunoŋ kokaeŋ jeŋ kotoro, ‘Nemuŋ maŋga mono goda qeŋ oromakeba,’ ano ‘Moŋnoŋ maŋa me nemuŋa qasuaaŋ orombaati, ii mono qegi komuwa.’ ");
INSERT INTO ksr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","“Kaeŋ jeŋ kotoroto, oŋo qaa ii uuguŋ kokaeŋ jeŋkeju, ‘Moŋnoŋ maŋaajoŋ me nemuŋaajoŋ kokaeŋ jewaa: Wosona mojeŋ. Noo naŋgonaŋgo iwoina buŋa qeŋ aonaga, ii mono Anutuwaa mamatewoo nandumbaajoŋ gosiŋ ambeta eja. Moŋnoŋ kaeŋ jeŋ maŋa me nemuŋa goda qeŋ mubaatiwaa so mende kolooja.’ ");
INSERT INTO ksr_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","“Kaeŋ jeŋ siligia walagaajoŋ ama Anutuwaa jojopaŋ qaaya itagogi omaya kolooŋ jaŋgoŋ qaomakeja. Ii mende sokonja. ");
INSERT INTO ksr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Oo uumeleembaa ejemba selesele, gejatootoo eja Aisaianoŋ oŋoo kaniagia tororo waladeeŋ iŋisaama kokaeŋ jerota eja, ");
INSERT INTO ksr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ejemba tuuŋ koi kanoŋ mono je buugianoŋ awaagadeeŋ goda qeŋ nomakejuto, uugianoŋ mono telambelaŋ ama noma moŋgeŋ koriganoŋ aŋgi eja. ");
INSERT INTO ksr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","“Kaeŋ ero noo waena eeŋ toontooŋ meŋ mepeseeŋ nomakeju. Kana qaa kuma oŋombonjeŋ kitianoŋ ejemba yoŋoo jeŋkootogia ii gisomaso ama melokanjiŋkeju.” ’ Kaeŋ meleema oŋono. ");
INSERT INTO ksr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jiisasnoŋ ejemba tuuŋ mombo oŋoono kagi kokaeŋ iŋijoro, “Oŋo mono qaa koi geja ama moma asariwu. ");
INSERT INTO ksr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ejanoŋ iwoi nero uutanoŋ kemeŋkeji, iikanoŋ mende tilooŋ muŋkejato, iyaŋaa wombotanoŋga qaa kouma kamaaŋkeji, iikanoŋ mono tilooŋ muŋkeja.” ");
INSERT INTO ksr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kaeŋ iŋijoro gowokourutanoŋ kaŋ kokaeŋ qisigi, “Farisii (Kana qaawaa kaparaŋkoŋkoŋ) yoŋonoŋ qaa ii mogi uŋuro uugianoŋ boliji, ii mojaŋ me qaago?” ");
INSERT INTO ksr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Qisigi kokaeŋ meleeno, “Niinoŋ waro kuuya noo Siwe Maŋnanoŋ mende komoroti, ii mono tiitawo qonjomaŋa. ");
INSERT INTO ksr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kileŋ, ii mono oŋomesaowu. Yoŋonoŋ ‘Ejemba jaagoo uŋuamboŋa,’ jeŋkejuto, iyaŋgiaa jaagianoŋ mono gooja. Jaagoo moŋnoŋ jaagoo alia moŋ borianoŋ meŋ wambaati eeŋ, iyoronoŋ mono motooŋ roŋnoŋ kemeŋ uruwaa.” ");
INSERT INTO ksr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kaeŋ meleeno Piitonoŋ ijoro, “Sareqaa iikawaa kania mono jeŋ asarina moboŋ.” ");
INSERT INTO ksr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Kaeŋ ijoro Jiisasnoŋ jero, “Oo alauruna, oŋo kaaŋagadeeŋ toroqeŋ momogia awaa mende kolooja me? ");
INSERT INTO ksr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ejanoŋ iwoi kuuya nero uutanoŋ kemeŋkeji, ii korojoŋanoŋ kemeŋ seleeŋgeŋ kamaaŋkeja. Ii moma kotoju me qaago? ");
INSERT INTO ksr_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","“Ii kamaaŋkejato, qaa uu konoŋanoŋga kouma buutanoŋga kamaaŋkeji, iikanoŋ mono tilooŋ muŋkeja. ");
INSERT INTO ksr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ejemba uu konoŋgianoŋga iwoi koi kaaŋa kolooŋ koumakeja: Qaa bologa romoŋgoŋ oweŋ jenaŋ meŋ ejemba uŋugi komuwutiwaajoŋ momakeju. Oloŋkalu ama serowiliŋ ambombaajoŋ momakeju. Iwoi yoŋgoro mewombaajoŋ momakeju. Jenoŋkuukuu qaa qoloŋmoloŋgoya jewombaajoŋ momakeju. Gemaqeqe qaa jeŋ Anutu mepaegowombaajoŋ momakeju. ");
INSERT INTO ksr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Iwoi kaaŋanoŋ mono ejemba tilooŋ oŋomakejato, borogia mende soŋgbama nembanene neŋkejuti, iikanoŋ eja moŋ mende tilooŋkeja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jiisasnoŋ Genesaret gomaŋ mesaoŋ siti qagara Taia ano Saidon yoroo distrik qata Fonisia iikawaa uutanoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Keno Keinan emba, baloŋ iikawaa toya moŋnoŋ kaŋ Jiisas welema kokaeŋ qama ijoro, “Poŋ, Deiwidwaa gbili, mono kiaŋkomuŋ nomba! Omenoŋ borana kokojinjiŋ ama muro siimbobolo somata momakeja.” ");
INSERT INTO ksr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Qama ijoroto, Jiisasnoŋ qaa moŋ mende meleeno. Kaeŋ kolooro gowokourutanoŋ kaŋ kokaeŋ kuuŋ muŋ ijogi, “Emba ii saama qama kananananoŋ kajiwaajoŋ mono ilaaŋ muna kemba.” ");
INSERT INTO ksr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kaeŋ ijogi meleeno, “Amananoŋ Israel kanagesowaa lama soosooya iikayadeeŋ hamo qeŋ oŋomambaajoŋ ama wasiŋ nonota kajeŋ.” ");
INSERT INTO ksr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kaeŋ meleeno emba iikanoŋ kosianoŋ kaŋ simiŋ kuma muŋ ijoro, “Poŋ, mono ilaaŋ nomba!” ");
INSERT INTO ksr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kaeŋ ijoroto, Jiisasnoŋ kokaeŋ meleema muro, “Qaago, merabora yoŋoo mirigianoŋga bered meŋ kasu oŋoniŋ mende sokombabo. Juuda nono wabaurunana oŋoo qagia kasu qamakejoŋ. Niinoŋ waladeeŋ Juuda ejemba ilaaŋ oŋombe kantri tosaaŋa oŋonoŋ mono kasu kaaŋa mamboma laligowu.” ");
INSERT INTO ksr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Meleema muroto, embanoŋ ijoro, “Poŋ, ii saanoŋ mojento, kasu meria yoŋonoŋ mono kaaŋagadeeŋ togiaa nene duŋnoŋga nene reemoŋa kamaaro neŋkeju.” ");
INSERT INTO ksr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kaeŋ ijoro Jiisasnoŋ kokaeŋ ijoro, “Oo emba, goo momalaariga ii somata. Kawaajoŋ welema nonjaŋiwaa hoŋa mono koloowaa.” Kaeŋ ijoro moma boratanoŋ aua iikanondeeŋ qeaŋgoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jiisasnoŋ gomaŋ ii mesaoŋ kaŋ Galili apu aŋgombaa goraayanoŋ kouma baaŋanoŋ uma kamaaŋ raro. ");
INSERT INTO ksr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Raro ejemba tuuŋlelembeyanoŋ iwaanoŋ kaŋ ejemba koi kaaŋa uŋuaŋgi: Lokoŋ ano ejemba jaagia googa, tosaaŋa kana borogia eraqeeraŋgoya, tosaaŋa qaamuuŋ ano tosaaŋa ji mamaga iŋiro laligogiti, ii uŋuama Jiisaswaa kana banoŋ oŋooŋgi meŋ qeaŋgoŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Meŋ qeaŋgoŋ oŋono qaamuuŋ ejemba yoŋonoŋ qaa jegi kana borogia eraqeeraŋgoya yoŋonoŋ qeaŋgoŋ diŋgogi lokoŋ yoŋonoŋ kana riiŋ kema kagi jaagia dooŋgoya yoŋonoŋ jaa uuŋ iigi ejemba tuuŋ yoŋonoŋ ii iima waliŋgoŋ Israel ananaa Anutunana mepeseegi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jiisasnoŋ gowokouruta oŋoono iwaanoŋ kagi kokaeŋ iŋijoro, “Niinoŋ ejemba tuuŋlelembe somata koi yoŋoojoŋ wosona mojeŋ. Yoŋonoŋ noonoŋ kaŋ weeŋ karooŋ laligoŋ waagi nenegia qaondabororo iijeŋ. Kananoŋ kema laligoŋ batuyanoŋ jaagia giliro tiwitiwilaa mokoloowubotiwaajoŋ ii eeŋ wasiŋ oŋomambaajoŋ togojeŋ. Kawaajoŋ ii nene uŋuagimambaajoŋ mojeŋ.” ");
INSERT INTO ksr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kaeŋ iŋijoro gowokourutanoŋ meleema kokaeŋ ijogi, “Baloŋ qararaŋkoŋkoŋanoŋ kokanoŋ nononoŋ mono daeŋkayaga nembanene mamaga mokolooŋ ejemba tuuŋlelembe koi uŋuagiwonaga?” ");
INSERT INTO ksr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ii moma Jiisasnoŋ kokaeŋ qisiŋ oŋono, “Oŋoonoŋ bered dawi raja?” Qisiŋ oŋono “Bered 7 ano sora melaa tosaaŋa raja,” jeŋ ijogi. ");
INSERT INTO ksr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ijogi Jiisasnoŋ ejemba tuuŋlelembe ii namonoŋ kemeŋ rabutiwaajoŋ jeŋ kotoŋ oŋono kemeŋ ragi. ");
INSERT INTO ksr_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kemeŋ ragi bered 7 ano sora ii meŋ Anutu qama kooliŋ daŋgiseŋ jeŋ motoŋ gowokouruta oŋono yoŋonoŋ ii ejemba tuuŋ so toto qeŋ oŋoŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Toto qeŋ oŋoŋgi neŋ neŋ timbiriŋgogi. Neŋ timbiriŋgoŋ nene kitia mesaogi kemeroti, ii konde 7 kanoŋ meŋ kululuugi saa qero. ");
INSERT INTO ksr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Eja nene negiti, yoŋoo jaŋgogia ii 4,000. Emba merabora yoŋoo jaŋgogia ii mende megi. ");
INSERT INTO ksr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jiisasnoŋ ejemba tuuŋlelembe oŋoono keŋgi iyaŋa waŋgonoŋ uma Magadan gomanoŋ keno. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisii (Kana qaawaa kaparaŋkoŋkoŋ) ano Sadusii (Jigo gawombaa kaparaŋkoŋkoŋ) tosianoŋ Jiisaswaanoŋ kaŋ qaawaa timbinoŋ horowaatiwaajoŋ aŋgobato meŋ muŋ kokaeŋ qisigi, “Mono jena Siwenoŋga aŋgoleto moŋ asugiro iiboŋa.” ");
INSERT INTO ksr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kaeŋ qisigi kokaeŋ meleeno, “Oŋo weeŋ kememambaajoŋ ano iikanoŋ kokaeŋ jeŋkeju, ‘Sombinoŋ ososaajiwaajoŋ woraŋ weeŋ awaa koloowaa.’ ");
INSERT INTO ksr_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","“Kaaŋagadeeŋ umugawodeeŋ kokaeŋ jeŋkeju, ‘Sombinoŋ ososaaro koosunoŋ totowijiwaajoŋ mono koŋ musu giliwaa.’ Kaeŋ kaeŋ jeŋ sombimbaa tania iima koŋ weembaa kania saanoŋ gosiŋkejuto, kambaŋ laligojoŋi, iikawaa aiweseya gosiwombaajoŋ mende moju. Ii mende sokonja. ");
INSERT INTO ksr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ejemba tuuŋ bologa namonoŋ laligoŋ oloŋkalu amakejuti, iyoŋonoŋ Anutuwaa aiweseya asugiwaatiwaajoŋ kaparaŋ komakejuto, Anutunoŋ gejatootoo eja Joonawaa aiweseya oŋondabororo aiwese tosia mende toroqeŋ qendeema oŋombaa.” Kaeŋ meleema oŋomesaoŋ moŋgeŋ keno. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jiisasnoŋ gowokouruta yoŋowo apu aŋgoŋ kotoŋ leegeŋ keuma samoŋ mewombaajoŋ duduugiti, ii iigi. ");
INSERT INTO ksr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ii iigi Jiisasnoŋ kokaeŋ iŋijoro, “Oŋo Farisii ano Sadusii paati woi yoŋoo wosokonduŋgia ano riki sombaŋgia iikawaajoŋ mono galeŋgia meŋ laligowu. Ii awaagadeeŋ mende gosiŋ gema qegi yoŋonoŋ mono yiist kaaŋa somariiŋ meŋ boliŋ oŋombuya.” ");
INSERT INTO ksr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Iŋijoro qaa gemata ii mende moma asariŋ batugianoŋ kokaeŋ amiŋ mogi, “Nono bered mende meŋ kajoŋ. Kawaajoŋ jeja me nomaeŋ?” ");
INSERT INTO ksr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ii amiŋ mogi gejianoŋ kemero kokaeŋ iŋijoro, “Oo oŋo momalaarigia melaada, naambaajoŋ ‘Bered mende mejoŋ,’ jeŋ oŋoaŋgia amiŋ moju? ");
INSERT INTO ksr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Noo kaniana ii naambaajoŋ mende moma kotoju? Niinoŋ bered 5 ii 5,000 yoŋoojoŋ motowe iikawaa kitia meŋ kululuugi konde dawinoŋ kemeŋ saa qero? Ii duduuju me qaago? ");
INSERT INTO ksr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","“Kaaŋagadeeŋ bered 7 ii 4,000 yoŋoojoŋ motowe iikawaa kitia meŋ kululuugi konde dawinoŋ kemeŋ saa qero? Ii duduuju me qaago? ");
INSERT INTO ksr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nii beredwaajoŋ qaa mende jejeŋi, ii nomaeŋ ama mende moma kotoju? Niinoŋ beredwaajoŋ qaagoto, Farisii ano Sadusii paati yoŋoo wosokonduŋgia ano riki sombaŋgia gosiŋ gema qewutiwaajoŋ jejeŋ.” ");
INSERT INTO ksr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kaeŋ iŋijoro iikanondeeŋ qaayaa kania kokaeŋ moma asarigi, “Ahaa! Flaua meŋ somasomarii yiistwaa galeŋ meŋ aowombaajoŋ mende jejato, Farisii paati ano Sadusii paati yoŋoonoŋ qaa melokanjiŋ gema qewombaajoŋ jeja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jiisasnoŋ Sisaria Filipai taombaa kosianoŋ kema kanoŋ gowokouruta kokaeŋ qisiŋ oŋono, “Ejembanoŋ Siwe gomambaa Eja hoŋa noojoŋ nomaeŋ jeŋkeju? Nii moroga koloojeŋ?” ");
INSERT INTO ksr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Qisiŋ oŋono meleema kokaeŋ ijogi, “Tosianoŋ ‘Gii Jon Oomulu ejaga koloojaŋ,’ jeŋkejuto, tosianoŋ ‘Gii Elaija koloojaŋ,’ jeŋkeju ano tosianoŋ toroqeŋ kokaeŋ jeŋkeju, ‘Gii Jeremaia me gejatootoo eja walaga yoŋoonoŋga moŋ koloojaŋ.” ’ ");
INSERT INTO ksr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Kaeŋ ijogi kokaeŋ qisiŋ oŋono, “Ano oŋoaŋgio noojoŋ nomaeŋ jeŋkeju? Nii moroga koloojeŋ?” ");
INSERT INTO ksr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Qisiŋ oŋono Saimon Piitonoŋ meleema ijoro, “Gii Hamoqeqe Toya Kraist ano laaligo Toya Anutuwaa Meria koloojaŋ.” ");
INSERT INTO ksr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kaeŋ ijoro Jiisasnoŋ meleema kokaeŋ ijoro, “Oo Saimon Joonawaa meria, baloŋ eja sa busuyawo moŋnoŋ qaagoto, noo Amana Siwe gomanoŋ laligoji, iinoŋ mono qaa ii gii gisaano. Kawaajoŋ giinoŋ mono simbawoŋawo koloojaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Niinoŋ kokaeŋ gijowe moba: Gii Piito (ananaa qaanoŋ karanjaŋ) koloona niinoŋ karanjaŋ iikawaa qaganoŋ uumeleeŋ kanagesonaa tandoya ambe naŋgoŋ oŋona uugia meagoŋ kotiiŋ nambu. Giinoŋ ii galeŋ koma oŋona koomu Toyanoŋ ii senjoŋ gomambaa kiropo naguyanoŋ horoŋ oŋomambaajoŋ amamaawaa. Omejiilaŋ tosaaŋa yoŋoo ku-usuŋgianoŋ kaaŋagadeeŋ ii kondeema haamo ama oŋombombaajoŋ amamaawuya. ");
INSERT INTO ksr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","“Niinoŋ Siwe bentotoŋaa kii meria woi gomaŋa. Gii namonoŋ siŋgisoŋgo somoŋgona iikanoŋ mono Siwe gomanoŋ kaaŋagadeeŋ soomoŋgoya ewaa. Gii namonoŋ siŋgisoŋgo mesaoŋ isana iikanoŋ mono Siwe gomanoŋ kaaŋagadeeŋ iisaŋa ewaa.” ");
INSERT INTO ksr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kaeŋ jeŋ Hamoqeqe Toya Kraist kolooroti, ii asuganoŋ jegi moŋnoŋ mobubotiwaajoŋ gowokouruta yoŋoojoŋ soŋgo kotakota ama oŋono. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kambaŋ kanoŋa Jiisasnoŋ kanaiŋ gowokouruta ii qaa kokaeŋ iŋisaama jero, “Niinoŋ Jerusalem kema siimbobolo mamaga momaŋa. Kantriwaa jotamemeya, jigo gawoŋ galeŋ ano Kana qaawaa boi yoŋonoŋ nugi komumaŋa. Komuwe weeŋ karooŋ kolooro koomunoŋga waamaŋa.” ");
INSERT INTO ksr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jiisasnoŋ kaeŋ jero Piitonoŋ horoŋ muŋ goraayanoŋ kema kanaiŋ qotogoŋ kokaeŋ jeŋ muro, “Oo Poŋ, ii kambaŋ moŋnoŋ kolooŋ gombabotiwaajoŋ Anutunoŋ mono sopa somoŋgoŋ gomba.” ");
INSERT INTO ksr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Qotogoŋ muro eleema Piito kokaeŋ jeŋ muro, “Gii qaa romoŋgojaŋi, ii Anutuwaanoŋ qaaga qaagoto, baloŋ ejemba ano Satan siiŋgiaga. Gii noo kana utumambaajoŋ mona uunanoŋ bolija. Kawaajoŋ Satan, gii mono keteda koi noo jaasewananoŋga togowa!” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kambaŋ kanoŋ Jiisasnoŋ gowokouruta qaa kokaeŋ iŋijoro, “Moŋnoŋ noo gemananoŋ kamambaajoŋ moji, iinoŋ mono iyaŋaa uuseliaa siiŋ kombombaŋa bologa gema qero ‘Buŋa gbilia meŋ kaja,’ jeŋ sisia megi siimbobolo ii bosimakeba. Ii maripoonoŋ komuwaatiwaa so mokosiŋgoŋ nii notaaŋ kawa. ");
INSERT INTO ksr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Moŋnoŋ laaligoya iyaŋaajoŋ aŋaliŋ aŋgoŋ koma aŋaa jaajaa laligoji, iinoŋ mono laaligoya hoŋa somoŋgoro soowaa. Soowaato, moŋnoŋ balombaa laaligoya noojoŋ ama qeleema togoŋ nombaati, iinoŋ mono laaligo hoŋaa kania mokolooŋ kotiiŋ laligowaa. ");
INSERT INTO ksr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","“Moŋnoŋ gomaŋa gomaŋa yoŋoo ilawoilaya kuuya koma hororo buŋaya kendabororo uutaa laaligoya meŋ sooŋ silemale laligoŋ komuro Anutunoŋ qaaya jeŋ tegoro uŋayanoŋ tiwilaaro mende sokombaa. Esuhinaya iikanoŋ mono uukoisoro mende ama mubaa. Qaago totooŋ! Kuuya anana mono waŋnana somoŋgoŋ aowombaajoŋ amamaawoŋa. ");
INSERT INTO ksr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Siwe gomambaa Eja hoŋanoŋ kanageŋ Siwe gajoba toroya yoŋowo koi kamaagi Maŋaa asamararaŋa iima aaruwuya. Kambaŋ iikanoŋ motomotooŋ ananaa nanamemenana gosiŋ iroŋa me tawaya iikawaa so nonombaa. ");
INSERT INTO ksr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Koi nanjuti, oŋoo batugianoŋga tosianoŋ Siwe gomambaa Eja hoŋanoŋ kiŋ poŋ kolooŋ asugiwaati, ii iima kotowuya. Jaawo laligoŋ koomuwaa siimboboloya mende mogi asugiro ii iibuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Weeŋ 6 tegoro Jiisasnoŋ Piito, Jeims ano Jeimswaa koga Jon uŋuama iyaŋgia siri baaŋa koriga moŋnoŋ uma gbameŋanoŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Laligogi jaasewaŋgianoŋ nano Jiisaswaa sele tanianoŋ letoma qaita moŋ kolooro. Jaasewaŋanoŋ weeŋ jaaya kaaŋa asariro malekuyanoŋ tualalakota kolooŋ asasagawo kolooro. ");
INSERT INTO ksr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kaeŋ kolooro iigi Mooses ano Elaija yoronoŋ asugiŋ oŋoma Jiisaswo qaa qaa amigi. ");
INSERT INTO ksr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Amigi Piitonoŋ kanaiŋ qaa jeŋ Jiisas kokaeŋ ijoro, “Poŋ, nononoŋ kokanoŋ uukorisoro mojoŋ. Kawaajoŋ siiŋganoŋ mojaŋi eeŋ, niinoŋ saanoŋ kuuŋ karooŋ memaŋa. Goojoŋ moŋ, Mooseswaajoŋ moŋ ano Elaijawaajoŋ moŋ.” ");
INSERT INTO ksr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kaeŋ ijoŋ nano kokolo tualalakota asamararaŋawo moŋnoŋ kamaaŋ aoŋanoŋ esuuŋ oŋono iikawaa uutanoŋga qa aro moŋ kokaeŋ kamaaro mogi, “Eja koi ii neenaa wombo meranaga. Noo uusiiŋna somatanoŋ mono iwaanoŋ eja. Mono iwaa qaaya moma laligowu.” ");
INSERT INTO ksr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Gowoko yoŋonoŋ qaa ii moma jeneŋgia ororo usugoŋ namonoŋ kamaaŋ keegia mamaga mogi. ");
INSERT INTO ksr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kaeŋ mogi Jiisasnoŋ yoŋoonoŋ kaŋ selegia oosiriŋ kokaeŋ iŋijoro, “Mono waabu. Keegia mende mobu.” ");
INSERT INTO ksr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Qaa ii moma uuŋ waama woi ii mende iriigito, Jiisasnondeeŋ nano iigi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Baaŋanoŋga roganoŋ kamaaŋ Jiisasnoŋ kokaeŋ jeŋ kotoŋ oŋono, “Oŋo iwoi iijuti, iikawaa bujuya ii ejemba moŋ mende iŋijowu. Siwe gomambaa Eja hoŋanoŋ koomunoŋga waaro iikawaa gematanoŋ ii saanoŋ jeŋ asariŋ laligowu.” ");
INSERT INTO ksr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kaeŋ jeŋ kotoŋ oŋono gowokouruta karooŋ yoŋonoŋ Jiisas kokaeŋ qisiŋ mugi, “Kana qaawaa boi yoŋonoŋ qaa kokaeŋ ii naambaajoŋ jeŋkeju, ‘Eja Elaijanoŋ mono waladeeŋ Siwenoŋga kamaaro Hamoqeqe Toyanoŋ iikawaa gematanoŋ asugiwaa?” ’ ");
INSERT INTO ksr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Qisiŋ mugi meleema kokaeŋ iŋijoro, “Elaijanoŋ waladeeŋ kamaaŋ asugiŋ laaligo kuuya meagowaa. Qaa ii hoŋagato, ");
INSERT INTO ksr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","niinoŋ kokaeŋ iŋijomaŋa: Elaijanoŋ kamaaŋ asugiroto, ii iima kania mende moma kotogito, ejembanoŋ ii aŋgiaa siiŋgia otaaŋ laŋ ama mugi. Kaaŋiadeeŋ Siwe gomambaa Eja hoŋa kaaŋagadeeŋ laŋ ama mugi Juuda jotamemeya sisiwerowerogiawo yoŋoo borogianoŋ kemeŋ siimbobolo mobaa.” ");
INSERT INTO ksr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Elaijawaajoŋ kaeŋ jeŋ hoŋa Jon Oomulu ejawaajoŋ qaa iŋijoroti, gowoko yoŋonoŋ ii kaeŋ moma asarigi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jiisas ano gowoko karooŋ yoŋonoŋ baaŋanoŋga kamaaŋ ejemba tuuŋ yoŋoonoŋ kagi eja moŋnoŋ Jiisaswaa kosianoŋ kaŋ simiŋ kuma muŋ kokaeŋ ijoro, ");
INSERT INTO ksr_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Poŋ, giinoŋ mono merana kiaŋkomuŋ muba. Ji kiro tama kamaaŋ qero sembeŋ aoŋ siimbobolo mamaga momakeja. Kambaŋ mamaga tama gerenoŋ me apunoŋ kemeŋkeja. ");
INSERT INTO ksr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Niinoŋ ii wama gowokouruga yoŋoonoŋ kajento, yoŋonoŋ ii meŋ qeaŋgoŋ mubombaajoŋ amamaajuya.” ");
INSERT INTO ksr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kaeŋ ijoro meleema muŋ jero, “Yei! Balombaa ejemba yaŋgiseŋ ano iriŋqiriŋgiawo, mono kambaŋ dawi oŋowo laligoŋ qato uŋuwe Anutu mende moma laarigi siimbobolo momakemaŋa? Ii mono wama noonoŋ koi kawu.” ");
INSERT INTO ksr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Wama kagi Jiisasnoŋ ome ii jeŋ muro mesaoŋ keno meranoŋ kambaŋ iikanondeeŋ qeaŋgoro. ");
INSERT INTO ksr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Qeaŋgoro gowokourutanoŋ ii iima aŋgiodeeŋ Jiisaswaanoŋ kaŋ rama kokaeŋ qisiŋ mugi, “Nononoŋ mono naambaajoŋ ii nononanodeeŋ otaawombaajoŋ amamaajoŋ?” ");
INSERT INTO ksr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Qisiŋ mugi kokaeŋ iŋijoro, “Momalaarigianoŋ melaada koloojiwaajoŋ ii otaawombaajoŋ amamaaju. Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Momalaarigiaa hoŋa ii nejoŋ kotaa so enagati eeŋ, oŋonoŋ saanoŋ baaŋa kokawaa Toyaajoŋ kokaeŋ jeŋ kotowuyaga, ‘Gii mono baaŋa ii metogoŋ waama kema leegeŋ endu amba.’ Kaeŋ jeŋ moma laarigi iikawaa so kolooro endu kembaa. Anutu moma laarigi inaaŋ oŋono iwoi mombaajoŋ mende osiwuyaga.” ");
INSERT INTO ksr_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Ome tania kaaŋa ii mono qama kooliŋ nene siŋgi laligoŋ otaawoŋa. Iwoi morota moŋ aniŋ mende kouma kembaa. Kiaŋ.) ");
INSERT INTO ksr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jiisasnoŋ gowokouruta yoŋowo motooŋ Galili prowins uutanoŋ liligoŋ kananoŋ keŋgi Jiisasnoŋ qaa kota kokaeŋ iŋijoro, “Anutunoŋ Siwe gomambaa Eja hoŋa ii baloŋ ejemba yoŋoo borogianoŋ ama muro kemebaa. ");
INSERT INTO ksr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Kemero ii qegi komuwaa. Komuro weeŋ karooŋ kolooro mono koomunoŋga waabaa.” Gowokourutanoŋ ii moma uugianoŋ bimooro wosobiri mogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jiisasnoŋ gowokouruta yoŋowo Kaperneam taonoŋ kougi jiwowoŋ jigowaa takis meme eja yoŋonoŋ Piitowaanoŋ kaŋ kokaeŋ qisiŋ mugi, “Oŋoo boigianoŋ jiwowoŋ jigowaa takisya ambaa me qaago?” ");
INSERT INTO ksr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Qisiŋ mugi “Ooŋ!” jero. Kawaa gematanoŋ Piitonoŋ miri uutanoŋ uro Jiisasnoŋ qaa mutuya kokaeŋ qisiŋ muro, “Saimon, gii nomaeŋ romoŋgojaŋ? Daeŋ yoŋonoŋ koŋkororowaa takis ano takis tosaaŋa (custom, revenue) ii balombaa kiŋ eja poŋ yoŋoojoŋ amakeju? Kantri toya anana me wabaya yoŋonoŋ ii aŋgi meŋ kululuuŋkeju?” ");
INSERT INTO ksr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Kaeŋ qisiŋ muro meleema “Wabaya yoŋonoŋ,” jero. Kaeŋ jero Jiisasnoŋ kokaeŋ ijoro, “Kaeŋ amakejutiwaajoŋ kantri toya anana ii ambombaa so mende koloojoŋ. ");
INSERT INTO ksr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kaeŋ koloojonto, takis mende aniŋ eja iyoŋoo uugianoŋ boliwabotiwaajoŋ mono kema kasa uupaŋga apu aŋgonoŋ giliwa. Giliŋ sora mutuya horoŋ mewaati, mono iikawaa qaa oota mesagoŋ moneŋ kota iikanoŋ mokoloowaga. Moneŋ kota ii eja woi anaraa takisnaraa so. Mono ii meŋ oŋoma iikanoŋ noojoŋ ano geeŋgaajoŋ takis amba.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kambaŋ kanoŋ gowoko yoŋonoŋ Jiisaswaanoŋ kaŋ kokaeŋ ijogi, “Siwewaa bentotoŋ uutanoŋ moronoŋ uuta kolooja?” ");
INSERT INTO ksr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kaeŋ ijogi merabora melaa moŋ qaro karo batugianoŋ ano nano. ");
INSERT INTO ksr_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nano kokaeŋ jero, “Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Uugia mende meleema merabora kaaŋa mende koloowuti eeŋ, oŋo mono kambaŋ moŋnoŋ Siwewaa bentotonoŋ mende keubuya. ");
INSERT INTO ksr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","“Kawaajoŋ moŋnoŋ iyaŋa meŋ kamaaŋ aoŋ merabora kokaaŋa koloowaati, iinoŋ mono Siwewaa bentotoŋ uutanoŋ uuta kolooja. ");
INSERT INTO ksr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Moŋnoŋ merabora koi kaaŋa moŋ noo qananoŋ koma horoŋ kalaŋ kombaati, iinoŋ mono nii koma horoŋ nombaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jiisasnoŋ toroqeŋ kokaeŋ jero, “Merabora koi kaaŋa moma laariŋ nonjuti, moŋnoŋ iyoŋoonoŋga moŋ koŋgoro ama muro siŋgisoŋgo ambaati, eja iikanoŋ mono lombo uuta mokoloowaa. Anutunoŋ lombo iikawaa iroŋa nomaeŋ muro soyanoŋ koloonaga? Kemuŋ kowonjiŋ aroyanoŋ somoŋgoŋ kowe biiwianoŋ giligi kemenagati, iikanoŋ mono afaaŋkota koloonaga. ");
INSERT INTO ksr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Siŋgisoŋgowaa siipatitianoŋ mono afaaŋagadeeŋ kolooŋkeja. Kawaajoŋ baloŋ ejemba oŋoojoŋ ‘Yei!’ wosobiri mojeŋ. Moŋnoŋ siipatiti aŋgoŋ komambaajoŋ amamaaŋkejato, moŋ moronoŋ tosaaŋa koŋgoro ama oŋono siŋgisoŋgo ambuti, iwaajoŋ mono ‘Yei!’ qama wanjinjiŋgoŋ saajeŋ. Siimbobolo uutanoŋ mono iwaa qaganoŋ ubaa. ");
INSERT INTO ksr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Boroganoŋ me kanaganoŋ siŋgisoŋgo ambaatiwaa koŋgoro ama gombaati eeŋ, ii mono kotoŋ giliwa. Kotoŋ giliŋgo borodomoŋ me kanadomoŋ laligoŋ laaligo kombombaŋa mokolooŋ oompeleleŋ mokoloowagato, kana boroga woiwo laligona kanageŋ gere sianoŋ giligi kemebabo. Sia gereya ii tetegoya qaa jewaa. ");
INSERT INTO ksr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“Kaaŋiadeeŋ jaaganoŋ siŋgisoŋgo ambaatiwaa koŋgoro ama gombaati eeŋ, ii mono qonjoma giliwa. Qonjoma giliŋgo jaakoga motooŋgowo laligoŋ laaligo kombombaŋanoŋ keuma oompeleleŋ mokoloowagato, jaaga woiwo laligona gere siawaa gerenoŋ giligi kemebabo. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ejemba melaa koi yoŋoonoŋga moŋ meŋ kamaaŋ mububotiwaajoŋ mono galeŋgia mewu. Niinoŋ qaa kokaeŋ iŋijowe mobu: Yoŋoo kokojiji gajobaurugianoŋ Siwe gomaŋ iikanoŋ noo Siwe Amanaa kosianoŋ laligoŋ jaasewaŋa suulaŋ iimakeju. Kawaajoŋ jejewili mono mende ama oŋombu. ");
INSERT INTO ksr_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Siwe gomambaa Eja hoŋanoŋ mono ejemba soogiti, ii meŋ letoma oŋono oyaŋboyaŋ koloowutiwaajoŋ kamaaro.) ");
INSERT INTO ksr_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Oŋo qaa koi kawaajoŋ nomaeŋ romoŋgoju? Eja mombaa lamauruta 100 laligogi yoŋoonoŋga moŋnoŋ sooŋ jiŋjauŋ keno toyanoŋ nomaeŋ ambaa? Iinoŋ mono 99 ii baaŋanoŋ oŋomesaoŋ kema motooŋgo jiŋjauŋ kenoti, iikawaajoŋ moŋgama kembaa. ");
INSERT INTO ksr_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Moŋgama kema laligoŋ mokoloowaati eeŋ, niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Iinoŋ 99 jiŋjauŋ mende keŋgiti, iyoŋoojoŋa kambaŋ iikanoŋ mamaga mende aisoowaato, motooŋgo iikawaajoŋ honombonoŋaga mende aisooŋ laligowaa. ");
INSERT INTO ksr_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Iikawaa so oŋoo Maŋgia Siwe gomanoŋ laligoji, iinoŋ mono ejemba melaa koi yoŋoonoŋga moŋnoŋ sooŋ gere sianoŋ mende kemebaatiwaajoŋ momakeja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Uumeleeŋ alaganoŋ siŋgisoŋgo ama gombaati eeŋ, gii mono iwaanoŋ kema jaasewaŋ qeŋ muŋ kana soŋgiroti, ii qendeema muba. Kaeŋ ana qaaga moma baatanoŋ kembaati eeŋ, giinoŋ mono alaga haamo ama muna mombo uumotooŋgo ama laligowao. ");
INSERT INTO ksr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kaeŋ ana qaaga moma iikawaa baatanoŋ mende kembaati eeŋ, giinoŋ mono toroqeŋ ala motooŋgo me woi uruama iwaanoŋ kembu. Buŋa Terewaa qaa kokawaa so mono kaeŋ amba, ‘Qaa kuuya ii ejemba woi karoonoŋ naŋgoŋ jegi kotiiwaa.’ ");
INSERT INTO ksr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","“Kaeŋ aŋgi qaagia moma iikawaa baatanoŋ mende kembaati eeŋ, giinoŋ mono uumeleeŋ kanagesowaa jotamemeya ii iŋijona iwo amiŋ mobu. Amiŋ mobuto, iyoŋoo qaa baatanoŋ kaaŋagadeeŋ mende kembaati eeŋ, ii mono asuganoŋ jegi jawo kolooro uumeleembaa gadokopa kaaŋa ama muŋ laligowa. Takis tiliqiligiawo megi sisigia meŋkejuti, iikawaa tani kaaŋa ii mono mesaona seleeŋgeŋ laligowaa. ");
INSERT INTO ksr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Niinoŋ qaa hoŋa tooŋ moŋ kokaeŋ iŋijowe mobu: Oŋonoŋ siŋgisoŋgo namonoŋ somoŋgowuti, ii kuuya mono Siwe gomanoŋ kaaŋagadeeŋ soomoŋgoya ewaa ano siŋgisoŋgo balonoŋ mesaoŋ isambuti, ii kuuya mono Anutunoŋ mesaoro Siwe gomanoŋ kaaŋagadeeŋ ewaa. ");
INSERT INTO ksr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Toroqeŋ qaa kokaeŋ iŋijowe mobu: Namonoŋ oŋoonoŋga woiyanoŋ qaa ii me ii kawaajoŋ uumotooŋ ama qama kooliwaotiwaa qaa somoŋgowaoti, noo Maŋna Siwe gomanoŋ laligoji, iinoŋ mono ii orono buŋa qeŋ aowaota. ");
INSERT INTO ksr_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ii kokaembaajoŋ: Ejemba woi me karoonoŋ noo qananoŋ iikanoŋ me kanoŋ ajoroowuti, niinoŋ mono iikanoŋ yoŋoo batugianoŋ laligomaŋa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kambaŋ kanoŋ Piitonoŋ Jiisaswaanoŋ kaŋ qaa kokaeŋ ijoro, “Poŋ, alananoŋ siŋgisoŋgo ama nomakeji, niinoŋ ii indiŋ dawiwaa so mesaowe sokombaa? Indiŋa 7 ii mamaga. Iikawaa so mesaowe sokombaa me qaago?” ");
INSERT INTO ksr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jiisasnoŋ ii moma kokaeŋ meleema muro, “Indiŋa 7 qaagoto, 70 taims 7 ii mesaona sokombaa. Niinoŋ kaeŋ gijojeŋ. ");
INSERT INTO ksr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Iikawaa kania ii kokaeŋ jeŋ asarimaŋa. Siwewaa bentotoŋa ii kiŋ eja pombaa so ambe kokaeŋ kolooja: Kiŋnoŋ weleŋqeqeuruta oŋoono moneŋgia galeŋ koŋgiti, iikawaa areŋ papiaya qendeeŋgi mindiŋgowaatiwaajoŋ kaparaŋ kono. ");
INSERT INTO ksr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","“Kaeŋ kanaiŋ moneŋa iikawaa sunduya gosiŋ mindiŋgogi kanoŋ eja moŋ wama kagi iwaa jaanoŋ nano. Tosaya ii 10 milyon Kina iwaanoŋ ero. ");
INSERT INTO ksr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ii eroto, tosaya ii kumambaajoŋ moneŋa mende sokono amamaarotiwaajoŋ ama somatayanoŋ nama kokaeŋ jeŋ kotoro, ‘Esuhinaya eji, ii kuuya mono sewaŋa mewutiwaajoŋ ambu. Ii ano embameraaŋa ii kaaŋagadeeŋ mono sewaŋgia mewutiwaajoŋ aŋgi moneŋ karo iikanoŋ tosaya ii kumbu. ");
INSERT INTO ksr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Kaeŋ jeŋ kotoro weleŋqeqeyanoŋ batanoŋ kamaaŋ simiŋ kuma usugoŋ kokaeŋ welema muro, ‘Gii mono uugere mende ama mokosiŋgoŋ mamboma nona goonoŋ tosaga kuuya ii saanoŋ kuma gomaŋa.’ ");
INSERT INTO ksr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kaeŋ welema muro somatayanoŋ weleŋqeqeyaajoŋ wosomomo ama tosaya ii kotoŋ mesaoŋ isano kamaaro. ");
INSERT INTO ksr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kamaaroto, seleeŋgeŋ kema kanoŋ weleŋqeqe alia moŋ mokolooŋ iiro. Iwaa tosaya ii weeŋ 100:waa tawaya (Kina 2,000) kawaa so iwaanoŋ ero. Ii iima aroya kotakota meŋ mosoma kokaeŋ ijoro, ‘Noonoŋ tosa goonoŋ eji, ii mono kuma nombaga me?’ ");
INSERT INTO ksr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Kaeŋ ijoro weleŋqeqe alianoŋ batanoŋ kamaaŋ simiŋ kuma usugoŋ kokaeŋ welema muro, ‘Gii mono uugere mende ama mokosiŋgoŋ mamboma nona goonoŋ tosaga ii saanoŋ kuma gomaŋa.’ ");
INSERT INTO ksr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Kaeŋ ijoroto, iinoŋ ii togoŋ kema jenteego eja majistreit ijoro meŋ somoŋgoŋ kapuare mirinoŋ ooŋgi raro tosaya kundaborogi kamaawaa. ");
INSERT INTO ksr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Iwoi ii kolooro weleŋqeqe alaurutanoŋ tani ii iima uugia kobooro wosobiri moma kema iikawaa sunduya kuuya ii somatagia ijogi moro. ");
INSERT INTO ksr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Ii moma somatagianoŋ weleŋqeqe mutuya ii qaro jaayanoŋ karo kokaeŋ ijoro, ‘Gii gawoŋ meme eja bologa! Gii tosaga kotoŋ mesaomambaajoŋ qisiŋ nona niinoŋ ii kuuya mesaoŋ gonjeŋ. ");
INSERT INTO ksr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Niinoŋ giima kobooŋ kiaŋkomuŋ gombe giinoŋ kaaŋagadeeŋ iikawaa so weleŋqeqe alaga kiaŋkomuŋ muna sokonaga.’ ");
INSERT INTO ksr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Somatayanoŋ kaeŋ ijoro iriŋa soono weleŋqeqe iikawaa qaaya jeŋ tegoŋ kasa miriwaa galeŋ yoŋoo boronoŋ ama muro siimbobolo mamaga moma rabaa. Iikanoŋ rama tosaya kiŋ pombaanoŋ eroti, ii kuuya kundabororo kamaawaa. ");
INSERT INTO ksr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Sareqaa kokawaa hoŋa ii kokaeŋ: Oŋo motomotooŋ alagiaa siŋgisoŋgoya uugianoŋ mende mesaowuti eeŋ, noo Siwe Maŋnanoŋ mono kaaŋagadeeŋ qaa iikawaa so ama oŋombaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jiisasnoŋ qaa ii jedaboroŋgo Galili prowins mesaoŋ Jordan apu kotoŋ leegeŋ kema metetereeŋ kamaaŋ mombo apu ii kotoŋ Judia prowinsnoŋ karo. ");
INSERT INTO ksr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Karo ejemba tuuŋlelembenoŋ otaaŋ kagi iikanoŋ meŋ qeaŋgoŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Meŋ qeaŋgoŋ oŋono Farisii (Kana qaawaa kaparaŋkoŋkoŋ) tosianoŋ iwaanoŋ kaŋ qaawaa timbinoŋ horowaatiwaa aŋgobato meŋ muŋ kokaeŋ qisiŋ mugi, “Ejanoŋ kania ii me woiwaajoŋ embia mesaowaati, ii Kana qaa uuguwaa me qaago?” ");
INSERT INTO ksr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Qisiŋ mugi meleema kokaeŋ iŋijoro, “Mokomokoloo Toyanoŋ mono kanakanaiyanoŋa ii ‘Eja ano emba laligowutiwaajoŋ mokolooŋ oŋono.’ Buŋa qaa ii weeŋgogi me qaago? ");
INSERT INTO ksr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Mokolooŋ kokaeŋ jero, ‘Kawaajoŋ ejanoŋ mono nemuŋmaŋa oromesaoŋ embiaanoŋ kema qokotaaro yoronoŋ sele motooŋgo kolooŋ laligowao.’ Qaa ii weeŋgogi me qaago? ");
INSERT INTO ksr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kaeŋ ama toroqeŋ woi mende koloojaoto, sele motooŋgo kolooŋ laligowao. Anutunoŋ eja ano emba mindiriŋ oronoti, ejemba moŋnoŋ mono ii mende mendeema oromba.” ");
INSERT INTO ksr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kaeŋ iŋijoro kokaeŋ ijogi, “Ejanoŋ mesaoŋ aoao papia ooŋ embia saanoŋ mesaowaa. Moosesnoŋ mono naambaajoŋ qaa kaeŋ jeŋ kotoŋ nononota eja?” ");
INSERT INTO ksr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Kaeŋ ijogi kokaeŋ jeŋ oŋono, “Moosesnoŋ mono uugia kotiga koloorotiwaajoŋ ama embia mesaowaatiwaa qaa kaeŋ jeŋ kotoroto, kanakanaiyanoŋ kaeŋ mende ero. ");
INSERT INTO ksr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Niinoŋ kokaeŋ iŋijowe mobu: Embianoŋ oloŋkalu mende ano kileŋ otaaŋ emba moŋ mewaati, iinoŋ mono serowiliŋ ambaa. Moŋnoŋ emba mesamesaoya mewaati, iinoŋ mono serowiliŋ ambaa.” ");
INSERT INTO ksr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jiisasnoŋ kaeŋ iŋijoro gowoko yoŋonoŋ ijogi, “Loemba batugaranoŋ mesaoŋ aoaoawaa soŋgo kaeŋ eji eeŋ, mono loemba mende kolooniŋ sokombaa.” ");
INSERT INTO ksr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Kaeŋ jegito, Jiisasnoŋ kokaeŋ meleeno, “Iikawaa qaaya kuma oŋonjeŋi, ejemba kuuyanoŋ ii iyaŋgiaajoŋ aŋgoŋ koma iikawaa so saanoŋ mende ambuto, Anutunoŋ qaa ii ejemba tosaaŋa yoŋoojoŋ oŋonoti, iyoŋonondeeŋ mono iikawaa so ambu. ");
INSERT INTO ksr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kawaa kania ii kokaeŋ: Tosianoŋ nemuŋ goroŋ uutanoŋ kolooŋ iikanoŋa kanaiŋ loemba koloowombaajoŋ mende moju. Tosianoŋ ejembanoŋ selegia kotoŋ kondooŋ oŋoŋgi loemba koloowombaa so mende kolooju. Tosianoŋ Siwe bentotoŋaajoŋ ama loemba mende koloowombaa qaaya jeŋ somoŋgoŋ qaagia ii otaaŋkeju. Moŋnoŋ qaa ii me ii moma aŋgoŋ koma otaamambaa so kolooji, iinoŋ mono iikawaa so amba.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kambaŋ kanoŋ tosianoŋ merabora busubuusu uŋuama Jiisasnoŋ boria waŋgianoŋ ama qama kooliwaatiwaajoŋ iwaanoŋ kagito, gowoko yoŋonoŋ ejemba ii jeŋ qewagoŋ oŋoŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kaeŋ aŋgi Jiisasnoŋ kokaeŋ jero, “Merabora melaa ii saanoŋ oŋomesaogi noonoŋ kawu. Siwewaa Toyanoŋ ejemba kaaŋa ii bentotoŋa buŋa qeŋ oŋombaa. Kawaajoŋ ii mende somoŋgoŋ oŋombu.” ");
INSERT INTO ksr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kaeŋ jeŋ boria waŋgianoŋ ama oŋomesaoŋ moŋgeŋ keno. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kambaŋ moŋnoŋ eja moŋnoŋ Jiisaswaanoŋ kaŋ kokaeŋ qisiŋ muro, “Boi, niinoŋ nanamemeŋ awaa nomaeŋ ama laaligo kombombaŋa buŋa qeŋ aowenaga?” ");
INSERT INTO ksr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Qisiŋ muro kokaeŋ ijoro, “Nanamemeŋ awaa nomaeŋ, naambaajoŋ iikaeŋ qisiŋ nonjaŋ? Motooŋgoyanoŋ mono awaa kolooja. Laaligo kombombaŋanoŋ keumambaajoŋ mobaati eeŋ, gii mono jojopaŋ qaa teŋ koma laligowa.” ");
INSERT INTO ksr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kaeŋ ijoro moma kokaeŋ jero, “Naa jojopaŋ qaawaajoŋ jejaŋ?” Jero Jiisasnoŋ ii moma ijoro, “Mono koi: ‘Moŋ mende qena komuwa. Serowiliŋ mono mende amba. Iwoi moŋ mono yoŋgoro mende mewa. Jenoŋkuukuu mono mende ama muba. ");
INSERT INTO ksr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nemuŋmaŋga mono goda qeŋ oromakeba,’ ano ‘Geeŋga jopagoŋ aoŋkejaŋi, iikawaa so mono ejemba kuuya jopagoŋ oŋomakeba.” ’ ");
INSERT INTO ksr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kaeŋ ijoro eja gbaworonoŋ kokaeŋ jero, “Ii kuuya mono teŋ koma laligoŋ waabe. Naambaajoŋ mombo amamaajeŋ?” ");
INSERT INTO ksr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Kaeŋ jero Jiisasnoŋ ijoro, “Gii akadamuwo laligomambaajoŋ mobagati eeŋ, mono kema esuhinaga sewaŋa mewutiwaajoŋ ana moneŋ karo ejemba wanaya oŋomba. Kaeŋ ana esuhinaga somata (maa suaŋ, milyon Kina kaaŋa) ii Siwe gomanoŋ eŋ gombaa. Kaeŋ ama nii notaaŋ kawa.” ");
INSERT INTO ksr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kaeŋ jeroto, gbaworonoŋ qaa ii moma esuhinaya mamaga erotiwaajoŋ ama wosobiri moma jaaya bosoleero eeŋ mesaoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Mesaoŋ keno Jiisasnoŋ gowokouruta kokaeŋ iŋijoro, “Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: ‘Yei!’ Ejemba qabuŋagiawo yoŋonoŋ mono Siwewaa bentotonoŋ keubombaajoŋ bimooŋ kupukapa ambuya. ");
INSERT INTO ksr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ii kokaeŋ jeŋ asarimaŋa: oro somata kamel ii sosoro ootanoŋ saanoŋ mende keubaa. Iikawaa so ejemba qabuŋagiawo yoŋonoŋ Anutuwaa bentotoŋ uutanoŋ keubombaajoŋ bimooŋ osiwuya.” ");
INSERT INTO ksr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kaeŋ iŋijoro gowoko yoŋonoŋ aaruŋ tililiŋgoŋ kokaeŋ jegi, “Oopopooŋ! Ejemba moronoŋ mono Siwewaa buŋa koloonaga?” ");
INSERT INTO ksr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Kaeŋ jegi Jiisasnoŋ uuŋ iŋiima kokaeŋ jero, “Ejembanoŋ ii aŋgobato meŋ amamaaŋ osiŋkejuto, Anutunoŋ mono iwoi kuuya saanoŋ amakeja. Iinoŋ iwoi moŋ ama memambaajoŋ mende amamaaŋ osiŋkeja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Piitonoŋ qaa ii moma meleema kokaeŋ ijoro, “Moba, nononoŋ mono iwoinana kuuya mesaoŋ gii gotaaŋ kaniŋ. Iikawaa tawaya mono naa iwoiga mewoŋa?” ");
INSERT INTO ksr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kaeŋ ijoro Jiisasnoŋ kokaeŋ iŋijoro, “Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Iwoi kuuya gbilia kolooro Siwe gomambaa Eja hoŋanoŋ jiŋkaroŋ duŋanoŋ raro asamararaŋanoŋ asariwaati, kambaŋ qaita moŋ iikanoŋ nii notaaŋ kagiti, oŋonoŋ mono kaaŋagadeeŋ jiŋkaroŋ duŋ 12 kanoŋ rama Israel tuuŋ 12 yoŋoo qaagia gosiŋ jeŋ tegowuya. ");
INSERT INTO ksr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","“Moŋnoŋ noo qanaajoŋ ama iwoi moŋ mesaoroti, ii jigo miria, daremuŋa, naambeeta, nemuŋmaŋa, meraboraaŋa me gawoŋ molaleŋa ii oŋomesaoro Anutunoŋ mono iikawaa iroŋa uuguŋ meleema muro seiwaa. Kaeŋ seiro laaligo kombombaŋa tetegoya qaa buŋa qeŋ aowaa. ");
INSERT INTO ksr_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kaeŋ koloowaato, mutuya oŋoonoŋga mamaganoŋ daaburuya koloogi daaburuya yoŋoonoŋga mamaganoŋ mutuya koloowuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jiisasnoŋ jero, “Siwewaa bentotoŋa ii kokaeŋ: Baloŋ toya moŋnoŋ umugawodeeŋ waama seleeŋgeŋ kema eja tosaaŋa iŋiima wain gawoŋanoŋ moneŋ gawoŋ mewutiwaajoŋ qisiŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Qisiŋ oŋono ‘Saanoŋ,’ jegi weeŋ motooŋgowaa tawaya (Kina 20) oŋombaatiwaajoŋ uumotooŋ aŋgi wasiŋ oŋono wain gawoŋanoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Keŋgi 9 kilok kawaa so kolooro mombo toroqeŋ kema eja tosaaŋa maaket sombeŋanoŋ eeŋ naŋgi iŋiiro. ");
INSERT INTO ksr_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Iŋiima kokaeŋ iŋijoro, ‘Oŋo mono kaaŋagadeeŋ noo wain gawonanoŋ kema gawoŋ megi tawagia soyanondeeŋ oŋomaŋa.’ ");
INSERT INTO ksr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Kaeŋ iŋijoro wain gawonoŋ keŋgi. Keŋgi 12 kilok kolooro mombo keno ano mare 3 kilok kawaa so duŋanoŋ mombo seleeŋgeŋ kema kaaŋadeeŋ ano. ");
INSERT INTO ksr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kaeŋ kolooŋ mare 5 kilok kawaa so seleeŋgeŋ keno eja tosaaŋa duŋanoŋ mombo eeŋ laŋ naŋgi iŋiiro. Iŋiima kokaeŋ qisiŋ oŋono, ‘Oŋo mono naambaajoŋ weeŋ koriga koi eeŋ laligoju?” ");
INSERT INTO ksr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Kaeŋ qisiŋ oŋono kokaeŋ meleeŋgi, ‘Moŋnoŋ moneŋ gawoŋ mewombaajoŋ mende qisiŋ nononja. Kawaajoŋ eeŋ koi nanjoŋ.’ Meleeŋgi kokaeŋ iŋijoro, ‘Oŋo mono kaaŋagadeeŋ noo wain gawonanoŋ kema gawoŋ mewu.’ ");
INSERT INTO ksr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Gawoŋ megi mare kolooro wain gawoŋ toyanoŋ gawoŋ galeŋa horoŋ kokaeŋ ijoro, ‘Gii mono gawoŋ meme eja oŋooma tawagia oŋomba. Tetegoya mare kolooro kajuyati, iyoŋoonoŋga kanaiŋ tawagia oŋoma kena gomaambadeeŋ kajuyati, iyoŋoonoŋ tegowa.’ ");
INSERT INTO ksr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Kaeŋ iŋijoro mare 5 kilok gawonoŋ kagiti, iyoŋonoŋ kougi weeŋ motooŋgowaa tawaya (Kina 20) ii motomotooŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Wala gawonoŋ kagiti, iyoŋonoŋ kouma tawagia uuguŋ mewutiwaajoŋ romoŋgogito, ii motomotooŋ kaaŋagadeeŋ weeŋ motooŋgowaa tawaya oŋono. ");
INSERT INTO ksr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tawa motooŋgo iikayadeeŋ meŋ kanaiŋ baloŋ toyaajoŋ uugianoŋ ŋindiŋ-ŋunduru jeŋ jeŋ muŋ kokaeŋ jegi, ");
INSERT INTO ksr_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Nono weeŋ geriawonoŋ nogo ariŋ gawombaa lombota bosinjoŋato, eja ii dologo kaŋ gawoŋ mewutiwaajoŋ qisiŋ oŋonjaŋa. Yoŋonoŋ aua motooŋgowaa so gawoŋ mejuyato, giinoŋ kileŋ yoŋoojoŋ moma oŋona nonowo ororoŋ kolooju. Ii mende sokonja.’ ");
INSERT INTO ksr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Kaeŋ jegito, yoŋoonoŋga mombaajoŋ kokaeŋ meleema jero, ‘Alana, nii giwo qaa jeŋ weeŋ motooŋgowaa tawa (Kina 20) gomambaajoŋ uumotooŋ anjota. Kawaa so tawa iikayadeeŋ gombe sokonja. Mono ii romoŋgowa. ");
INSERT INTO ksr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Uuga iikawaajoŋ boliwaati eeŋ, mono geeŋgaa tawaga meŋ kemba. Eja dologo gawoŋ mewutiwaajoŋ qisiŋ oŋonjeŋi, iyoŋoojoŋ kaaŋagadeeŋ tawa gonjeŋi, mono iikayadeeŋ oŋomambaajoŋ mojeŋ. ");
INSERT INTO ksr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","‘Neenaa moneŋnoŋ neenaa aiŋnaa so ambe sokonja me qaago? Niinoŋ loloogendeeŋ oŋonjeŋiwaajoŋ uuganoŋ baagoŋ jaaga bosoleeja me?” ’ ");
INSERT INTO ksr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jiisasnoŋ qaa ii jedaboroŋ kokaeŋ jero, “Iikawaa so konoga yoŋonoŋ mutuya koloogi mutuya yoŋonoŋ konoga koloowuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jiisasnoŋ Jerusalem sitinoŋ ubombaajoŋ baloŋ kana keŋgi gowokouruta 12 ii horoŋ oŋoma goraayanoŋ kema kokaeŋ iŋijoro, ");
INSERT INTO ksr_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Mobu, anana Jerusalem uboŋa. Iikanoŋ moŋnoŋ Siwe gomambaa Eja hoŋa memelolo meŋ muro jigo gawoŋ galeŋ ano Kana qaawaa boi yoŋoo borogianoŋ kembaa. Yoŋonoŋ komuwaatiwaa qaaya jedaboroŋ ");
INSERT INTO ksr_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","waba gawman yoŋoo borogianoŋ ama mubuya. Ama mugi mepaegoŋ ooli waayawonoŋ qetaaliŋ taluŋgowuya. Qetaaliŋ taluŋgoŋ maripoonoŋ qegi komuwaa. Komuŋ weeŋ karooŋ kolooro koomunoŋga waabaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kambaŋ kanoŋ Zebediwaa merawoita yoroo nemuŋgaranoŋ merawoita yorowo Jiisaswaanoŋ kaŋ simiŋ kuma muŋ iwoi qaita mombaa welemambaajoŋ jero. ");
INSERT INTO ksr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kaeŋ jero qisiŋ muro, “Gii naa iwoiwaajoŋa mojaŋ?” Qisiŋ muro kokaeŋ ijoro, “Giinoŋ saanoŋ jeŋ kotona noo merawoina koi yoronoŋ mono goo bentotonoŋ eu uma moŋnoŋ boro dindiŋganoŋ ano moŋnoŋ boro qaniganoŋ rama iwoi kuuya galeŋ kombuyaga.” ");
INSERT INTO ksr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kaeŋ ijoroto, Jiisasnoŋ meleema kokaeŋ jero, “Oŋo iikawaa kania mende moma yagoŋ welenju. Niinoŋ qambi aasoŋawo nemaŋati, oro ii saanoŋ neŋ siimbobolo mobaota me qaago?” Kaeŋ jero moma “Saanoŋ newota,” ijori. ");
INSERT INTO ksr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ijori kokaeŋ irijoro, “Ii oŋanoŋ! Niinoŋ qambi aasoŋawo nemaŋati, oro ii kaaŋiadeeŋ newaoto, noo boro dindinanoŋ me qaninanoŋ moronoŋ rabaati, niinoŋ qaa ii jeŋ kotomaŋatiwaa so qaago. Noo Maŋnanoŋ duŋ woi ii daeŋ yoroojoŋ mozozoŋgoroti, ii mono yoroojoŋ orono niwo rama iwoi kuuya galeŋ komakeboŋa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Daremuŋ woi yoronoŋ kaeŋ welema muri alaurugara 10 yoŋonoŋ ii moma uugia boliro. ");
INSERT INTO ksr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kaeŋ boliroto, Jiisasnoŋ oŋoono kagi kokaeŋ iŋijoro, “Namowaa kantria kantria yoŋoo jawiŋurugianoŋ mono eja poŋ kaaŋa ama oŋomakeju. Yoŋoo somatagianoŋ mono qaa jeŋ kotoŋ ejemba mindiŋgoŋ oŋoma ku-usuŋgia qendeemakeju. Oŋo yoŋoo kaniagia ii saanoŋ moju. ");
INSERT INTO ksr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Oŋoo batugianoŋ sili iikaaŋa ewaboto, moŋnoŋ oŋoo batugianoŋ somatagia koloomambaajoŋ moji, iinoŋ mono weleŋ qeŋ oŋoma laligowa. ");
INSERT INTO ksr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","“Kaaŋagadeeŋ moŋnoŋ oŋoo batugianoŋ jetamemeya mutuya laligomambaajoŋ moji, iinoŋ mono oŋoo newo baagianoŋ laligoŋ weleŋqeqegia omaya koloowa. ");
INSERT INTO ksr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Siwe gomambaa Eja hoŋanoŋ mono kaaŋagadeeŋ sili kaaŋa qendeema iyaŋa weleŋ qeŋ mubutiwaajoŋ ama mende karoto, mono weleŋ qeŋ oŋoma ejemba kuuya oŋoo dowegia memambaajoŋ ama kamaaŋ laaligoya qeleema mesaowaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jiisasnoŋ gowokouruta yoŋowo Jeriko siti mesaowombaajoŋ aŋgi ejemba tuuŋlelembenoŋ oŋotaaŋ gemagianoŋ kagi. ");
INSERT INTO ksr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kaeŋ kagi eja jaagoo woi kana goraayanoŋ rari. Rari “Jiisasnoŋ uruugumambaajoŋ anja,” jegi moma kokaeŋ qari, “Poŋ Deiwidwaa gbili, mono kiaŋkomuŋ noromba!” ");
INSERT INTO ksr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kaeŋ qari ejemba tuuŋ somata yoŋonoŋ bo rabaotiwaajoŋ qotogoŋ oroŋgito, iyoronoŋ mono kaparaŋ koma kokaeŋ qari, “Poŋ Deiwidwaa gbili, mono kiaŋkomuŋ noromba!” ");
INSERT INTO ksr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kaeŋ qari Jiisasnoŋ doroŋ ama iwaanoŋ kawaotiwaajoŋ qaro kari kokaeŋ qisiŋ orono, “Alawoina, niinoŋ naa iwoi ama oromambaajoŋ mojao?” ");
INSERT INTO ksr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kaeŋ qisiŋ orono kokaeŋ ijori, “Poŋ, noro jaanara mombo uuwobaajoŋ mojo.” ");
INSERT INTO ksr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kaeŋ ijori Jiisasnoŋ yoroojoŋ wosoya moma jaagara oosiriro iikanondeeŋ tooro uuŋ Jiisas otaaŋ gematanoŋ keni. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jiisasnoŋ gowokouruta yoŋowo Jerusalem siti dodowiŋ Oil gere baaŋanoŋ Betfage gomanoŋ kagi. Kaŋ gowokowoita woi wasiŋ oromambaajoŋ ama ");
INSERT INTO ksr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kokaeŋ irijoro, “Gomaŋ jaasewaŋsewaŋ raji, mono iikanoŋ kembao. Kema iikanoŋ keuma doŋgi embia kasanoŋ somoŋgogi nanji ano doŋgi melaa ii iikanondeeŋ mokolooŋ orombaota. Ii mono isama oroma meŋ noonoŋ kawao. ");
INSERT INTO ksr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","“Aisni moŋnoŋ qaa moŋ jero kokaeŋ ijowao, ‘Poŋnaranoŋ mono iikawaajoŋ amamaaja.’ Kaeŋ ijori doŋgi ii uulaŋawo orono koi kawao.” ");
INSERT INTO ksr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Anutunoŋ qaa moŋ gejatootoo eja mombaa uutanoŋ anota jeroti, iikanoŋ hoŋawo koloowaatiwaajoŋ kaeŋ kolooro. Qaa ii kokaeŋ, ");
INSERT INTO ksr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Oo Jerusalem ejemba Zaion baaŋa liligoŋ laligojuti, iyoŋoojoŋ mono kokaeŋ iŋijogi mobu, ‘Mobu, oŋoo kiŋ poŋgianoŋ mono oŋoonoŋ asugiwaa. Iinoŋ gumbonjonjoŋ ama doŋgi qaganoŋ rama kawaa. Doŋgi lombo bosimakejiwaa meriaa qaganoŋ rama kawaa.” ’ ");
INSERT INTO ksr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jiisasnoŋ gowokowoita wasiŋ orono kema qaa irijorotiwaa so ani. ");
INSERT INTO ksr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Yoronoŋ doŋgi nemuŋmera uruama kari. Kari malekugia qetegoŋ doŋgi qagaranoŋ aŋgi Jiisasnoŋ meriaa qaganoŋ uma raro. ");
INSERT INTO ksr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kaeŋ rama keno ejemba tuuŋlelembenoŋ goda qeŋ malekugia qetegoŋ kana somatanoŋ tamboŋgi tosianoŋ gere uutanoŋ kema boria memburatiŋ kana somatanoŋ tamboŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tamboŋgi ejemba tuuŋlelembe somata wala koma horoŋ keŋgiti ano gematanoŋ otaaŋ kagiti, iyoŋonoŋ kokaeŋ jeŋ qagi, “Hoosana! Anutu mepeseejoŋ. Deiwidwaa gbili oowe oowe! Pombaa qatanoŋ kawaati, Anutunoŋ mono ii kotuegowa. Hoosana! Qabuŋaga mepeseeniŋ eukanoŋ uja! Oowe oowe!” ");
INSERT INTO ksr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kaeŋ qagi Jerusalem sitinoŋ uma sitiwaa ejemba kuuyanoŋ aaruŋ gujumaju ama kokaeŋ qisigi, “Eja koi mono moroga?” ");
INSERT INTO ksr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Qisigi ejemba tuuŋlelembe yoŋonoŋ kokaeŋ meleeŋgi, “Iinoŋ mono gejatootoo eja Jiisas, Galili prowinswaa gomaŋa Nazaretga.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jiisasnoŋ jiwowoŋ jigowaa totoŋ uutanoŋ keno. Iikanoŋ ejemba iŋiiro hina sewaŋa mewutiwaajoŋ aŋgi sewaŋa megiti, iinoŋ ii kuuya konjoma oŋono kamaagi. Moneŋ utekute ejemba yoŋoo jakegia metaama meleeno keŋgi. Kaaŋagadeeŋ kewo sewaŋgia mewutiwaajoŋ aŋgiti, iyoŋoo duŋ raragia ii kaaŋiadeeŋ riitano keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kaeŋ ama kokaeŋ iŋijoro, “Aisaianoŋ qaa moŋ kokaeŋ oorota eja, ‘Noo jigonanoŋ mono qamakooli miri koloowaatiwaajoŋ qabu.’ Qaa ii ejato, oŋo ii utegogi kikekakasililiŋ yoŋoo kobaa kaaŋa kolooja.” ");
INSERT INTO ksr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kaeŋ kolooro jaagoo ama lokoŋ ejemba ii jiwowoŋ jigonoŋ iwaanoŋ kagi meŋ qeaŋgoŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kaeŋ kolooroto, jigo gawoŋ galeŋ ano Kana qaawaa boi yoŋonoŋ aŋgoleto meroti, ii iigi ano merabora jiwowoŋ jigonoŋ qama “Hoosana! Deiwidwaa gbili oowe oowe!” jegiti, ii iŋiima uubologa mogi. ");
INSERT INTO ksr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Uu bologa moma kokaeŋ jeŋ mugi, “Merabora qaa qajuti, ii mojaŋ me qaago?” Jeŋ mugi kokaeŋ meleema oŋono, “Saanoŋ mojeŋ. Oŋo kambaŋ moŋgeŋ Buŋa qaa koi weeŋgogi me qaago, ‘Giinoŋ mono merabora ano mera sayawo aju neŋkejuti, ii kuma oŋona geeŋga tororo mepeseeŋ gomakeju.” ’ ");
INSERT INTO ksr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kaeŋ meleema oŋoma oŋomesaoŋ mare kolooro siti mesaoŋ Betani kema ero. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Eŋ umugawodeeŋ waama mombo sitinoŋ kema nenewaajoŋ komuro. ");
INSERT INTO ksr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nembanenewaa komuŋ kana goraayanoŋ fig gere moŋ iima kawaa kanianoŋ keno. Kenoto, hoŋa mende mokolooroto, qaseŋagadeeŋ iiro. Kaeŋ iima gere ii kokaeŋ jeŋ muro, “Giinoŋ mono kambaŋ moŋnoŋ hoŋga mombo mende ewa.” Kaeŋ jeŋ tegoŋ muro fig gere iikanoŋ mono iikanondeeŋ gororoŋgoro. ");
INSERT INTO ksr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Gororoŋgoro gowokourutanoŋ ii iima aaruŋ kokaeŋ jegi, “Fig gerenoŋ mono nomaeŋ ama alanzaŋ pilitiknoŋ gororoŋgoja?” ");
INSERT INTO ksr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jegi Jiisasnoŋ kokaeŋ meleeno, “Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Momalaari pondaŋ meŋ uuwoi mende ambuyati eeŋ, fig gerewaanoŋ iwoi kolooji, oŋonoŋ iikayadeeŋ mende ambuyato, koi mono kaaŋagadeeŋ saanoŋ ambuyaga: Baaŋa kokawaa toyaajoŋ kokaeŋ jeŋ kotowuyaga, ‘Mono baaŋa koi qetegoŋ wama waama kema kowenoŋ amba.’ Kaeŋ jeŋ kotoŋ Anutu moma laariro mono iikawaa so koloowaa. ");
INSERT INTO ksr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Naa iwoiwaajoŋ qisiŋ qama kooliwuti, ii kuuya buŋa qeŋ aowombaajoŋ moma laarigi mono buŋagia koloowaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jiisasnoŋ jiwowoŋ jigowaa totoŋ uutanoŋ kema ejemba kuma oŋono jigo gawoŋ galeŋ ano kantriwaa jotamemeya tosaaŋa yoŋonoŋ iwaanoŋ kougi. Kouma kokaeŋ qisiŋ mugi, “Gii kokanoŋ iwoi anjaŋi, ii mono moronoŋ jeŋ kotoŋ gono amakejaŋ? Iikawaa ku-usuŋa ii mono moronoŋ gono?” ");
INSERT INTO ksr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Qisiŋ mugi kokaeŋ meleema oŋono, “Niinoŋ kaaŋagadeeŋ qaa moŋ qisiŋ oŋomaŋa. Ii meleema nombuti eeŋ, niinoŋ kaaŋagadeeŋ moronoŋ ku-usuŋ nono iwoi koi amakejeŋi, ii iŋijomaŋa. ");
INSERT INTO ksr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jonoŋ ejemba oomulu meŋ oŋoma laligoroti, iinoŋ iikawaa ku-usuŋa ii daeŋkaya mero? Siwe Toyanoŋ muro me baloŋ toyanoŋ mugi?” Kaeŋ meleema oŋono batugianoŋ amiŋ moma kokaeŋ jegi, “‘Ku-usuŋanoŋ Siwenoŋga asugiro,’ kaeŋ jewoŋati eeŋ, iinoŋ mono kokaeŋ jewaa, ‘Oŋo mono naambaajoŋ Jon mende moma laariŋ mugi?’ Ii mende sokonja. ");
INSERT INTO ksr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Me ‘Baloŋ ejembanoŋga asugiro,’ jewoŋati eeŋ, nononoŋ mono ejemba tuuŋ yoŋoojoŋ toroko moma amamaawoŋa. Kanageso kuuya yoŋonoŋ Jombaajoŋ ‘Gejatootoo ejaga kolooja,’ jeŋ laligoju.” ");
INSERT INTO ksr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Qaa kaeŋ gosiŋ Jiisaswaajoŋ kokaeŋ meleeŋgi, “Ii mende mojoŋ.” Kaeŋ meleeŋgi Jiisasnoŋ kokaeŋ iŋijoro, “Kaeŋ kolooro niinoŋ kaaŋagadeeŋ iwoi koi amakejeŋiwaa ku-usuŋa moronoŋ nonoti, ii mende iŋijomaŋa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jiisasnoŋ sareqaa moŋ kokaeŋ jero, “Oŋo qaa koi kawaajoŋ nomaeŋ romoŋgoju? Eja moŋ merawoita woi laligogi. Kambaŋ moŋnoŋ maŋgaranoŋ meria mombaanoŋ kema kokaeŋ ijoro, ‘Merana, gii saanoŋ kete noo wain kasa gawonoŋ kema gawoŋ mewa.’ ");
INSERT INTO ksr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Kaeŋ ijoro kokaeŋ meleeno, ‘Nii togojeŋ.’ Kaeŋ ijoroto, kanageŋ qaaya iikawaajoŋ moma boliŋ eleema kema gawoŋ mero. ");
INSERT INTO ksr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kawaa gematanoŋ maŋgaranoŋ meria mombaanoŋ kema mutu meriaajoŋ ijoroti, qaa iikayadeeŋ ijoro. Ii ijoro qaa kokaeŋ meleema jero, ‘Somatana, saanoŋ kemaŋa.’ Kaeŋ jeroto, kileŋ mende keno.” ");
INSERT INTO ksr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jiisasnoŋ kaeŋ jeŋ qisiŋ oŋono, “Woi yoroonoŋga moronoŋ maŋgaraa jeta teŋ kono?” Kaeŋ qisiŋ oŋono kokaeŋ meleeŋgi, “Meria mutuya iinoŋ.” Kaeŋ meleeŋgi kokaeŋ iŋijoro, “Niinoŋ qaa hoŋa tooŋ moŋ kokaeŋ iŋijowe mobu: Takis meme ejemba tiliqiligiawo ano kana somata emba yoŋonoŋ mono oŋo uŋuuguŋ wala Anutuwaa bentotoŋ uutanoŋ ubuya. ");
INSERT INTO ksr_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","“Qaa iikawaa kania ii kokaeŋ: Jon Oomulu ejanoŋ oŋoonoŋ kaŋ Anutuwaa jaanoŋ solaŋaniwoŋatiwaa kania qendeeno oŋo iwaa qaaya ii mende moma laarigito, takis meme ejemba tiliqiligiawo ano kana somata emba yoŋonoŋ mono ii moma laariŋ mugi. Yoŋonoŋ ii moma laariŋ mugiti, oŋo ii iima kileŋ kanageŋ kaaŋagadeeŋ oŋoaŋgia mende moma boliŋ aoŋ eleema ii mende moma laariŋ mugi.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jiisasnoŋ jero, “Sareqaa moŋ ii kokaeŋ mobu: Baloŋ toya moŋnoŋ wain kasa gawoŋ moŋ koma komoro. Koma komoma sopaya meŋ liligoro. Meŋ liligoŋ wain juu somata jamonoŋ mero. Iikanoŋ waimbaa hoŋa ama kananoŋ rijijaagi apuyanoŋ lalanoŋ kemero. Wain juu somata ii jamonoŋ meŋ wain yoŋgoro mewubotiwaajoŋ galeŋ meme jake koriga kowiawo mero. Iwoi kuuya medaboroŋ wain gawoŋ galeŋ tosaaŋa mokolooŋ oŋoma kokaeŋ iŋijoro, ‘Mono gawoŋ meŋ hoŋaa bakaya oŋoaŋgia meŋ bakaya toya nii nombu.’ Kaeŋ jeŋ gawoŋ ii borogianoŋ ama oŋomesaoŋ kantri moŋnoŋ kema laligoro. ");
INSERT INTO ksr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Laligoŋ laligoro hoŋa momogorotiwaa kambaŋa gbani 5 toriro kanoŋ weleŋqeqeuruta tosia wasiŋ oŋono galeŋ yoŋoonoŋ kema wain gawoŋ hoŋaa bakaya mubutiwaajoŋ jero. ");
INSERT INTO ksr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Jeroto, galeŋ yoŋonoŋ ii uŋuama somoŋgoŋ tosia koobinoŋ sagorogoro uŋuŋ tosia uŋugi komugi tosia jamonoŋ giliŋ uŋugi komugi. ");
INSERT INTO ksr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kawaa gematanoŋ weleŋ eja tosaaŋa toroqeŋ wasiŋ oŋono mamaga koloogito, ii kaaŋiadeeŋ horoŋ ureeŋ meŋ oŋoŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Kaeŋ aŋgi wain gawoŋ toyanoŋ qaa moŋgama jero, ‘Neenaa merana mono goda qeŋ mubuya me nomaeŋ?’ Kaeŋ jeŋ konoga ii aŋaa meria wasiro yoŋoonoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kenoto, wain gawoŋ galeŋ yoŋonoŋ meria iima batugianoŋ kokaeŋ amiŋ moma jegi, ‘Iinoŋ mono borosamoyaa toya kolooja. Ayo, mono meŋ qeniŋ komuro wain kasa gawoŋanoŋ mono ananaa buŋaga koloowaa.’ ");
INSERT INTO ksr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","“Kaeŋ jeŋ qelanjiŋ meŋ somoŋgoŋ giligi gawoŋ seleeŋgeŋ kemero qegi komuro. ");
INSERT INTO ksr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Wain gawoŋ toyanoŋ ii moma kaŋ gawoŋ galeŋ ii mono nomaeŋ ama oŋombaa?” ");
INSERT INTO ksr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jiisasnoŋ kaeŋ qisiŋ oŋono kokaeŋ ijogi, “Galeŋ bologa ii mono kondeema japaleleŋ meŋ oŋombaa ano gawoŋ galeŋ dologa mokolooŋ oŋoma wain kasa gawoŋa yoŋoo boronoŋ ambaa. Yoŋonoŋ hoŋa momogowaatiwaa kambaŋanoŋ bakaya tororo muŋkebuya.” ");
INSERT INTO ksr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jiisasnoŋ ii moma kokaeŋ iŋijoro, “Buŋa Terewaa qaa koi kambaŋ moŋgeŋ weeŋgogi me qaago, ‘Miri meme yoŋonoŋ jamo tando moŋ gema qeŋ eeŋ mesaogi raroti, iikanoŋ mono tando kombombaŋa kolooro mokoloogi. Iikanoŋ riiro mirinoŋ mono gororoŋgoŋ kamaaŋ kombaa. Poŋnoŋ tando ii kuuro jaanananoŋ iiniŋ qabuŋayawo kolooro waliŋgoŋkejoŋ?’ ");
INSERT INTO ksr_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Kawaajoŋ kokaeŋ iŋijowe mobu, Anutunoŋ mono bentotoŋa ii uŋuama ejemba tuuŋ moŋ oŋono yoŋonoŋ iikawaa gawoŋa megi hoŋa saanoŋ kolooŋkebaa. ");
INSERT INTO ksr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Moŋnoŋ tando waŋa iikanoŋ ritataŋgoŋ kamaaŋ qewaati, ii mono selia kotomotowaato, aeŋ tando iikanoŋ joloma tama mombaa qaganoŋ kamaaŋ kombaati, ii mono kuuya qenjaŋmenjaŋgowaa.” ");
INSERT INTO ksr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jiisasnoŋ kaeŋ jero moma jigo gawoŋ galeŋ ano Farisii (Kana qaawaa kaparaŋkoŋkoŋ) yoŋonoŋ sareqaaya ii moma kania moma asariŋ kokaeŋ jegi, “Ii mono nonoojoŋa jeja.” ");
INSERT INTO ksr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kawaajoŋ ii meŋ somoŋgowombaajoŋ mogito, ejemba tuuŋ somata yoŋoojoŋ toroko moma amamaagi. Ejemba tuuŋ somata yoŋonoŋ Jiisaswaajoŋ mogi gejatootoo ejaga kolooro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jiisasnoŋ mombo kanaiŋ sareqaanoŋ qaa kokaeŋ jero, ");
INSERT INTO ksr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Siwewaa bentotoŋa ii kokawaa so kolooja: Kiŋ eja Poŋnoŋ meriaajoŋ maraŋ (agomiŋ aoao) lombaŋ areŋgoŋ mozozoŋgoro. ");
INSERT INTO ksr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mozozoŋgoŋ weleŋqeqeuruta wasiŋ oŋoma kokaeŋ jero, ‘Niinoŋ ejemba tosaaŋa maraŋ lombanoŋ kawutiwaajoŋ mojeŋ. Oŋo mono yoŋoonoŋ qele kema kawutiwaajoŋ iŋijowu.’ Kaeŋ jero kema iŋijogito, ejemba yoŋonoŋ ii moma kawombaajoŋ togoŋ silemale aŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Kawaa gematanoŋ weleŋqeqeuruta tosaaŋa mombo wasiŋ oŋoma kokaeŋ jero, ‘Ejemba kawutiwaajoŋ jeweti, mono iyoŋoonoŋ kema kokaeŋ iŋijowu: Mobu, niinoŋ lombambaa nenena mozozoŋgodaborojeŋa raja. Noo bulmakao ejia ano bulmakao tosaaŋa uŋuaginiŋ kelegiawo koloogiti, ii uŋuŋ ooŋ qeragoniŋ iwoi kuuya mono jojoriŋ eja. Oŋo mono maraŋ lombanoŋ kawu.’ ");
INSERT INTO ksr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Kaeŋ jero keŋgi ejemba yoŋonoŋ qaa iikawaa geja mende aŋgito, lolomoniŋ tondu keŋgi. Tosianoŋ nene gawoŋgianoŋ keŋgi tosianoŋ koŋkororo gawoŋgianoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tosianoŋ kiŋ pombaa weleŋqeqeuruta qelanjiŋ uŋuama horoŋ ureeŋ oŋoma uŋugi komugi. ");
INSERT INTO ksr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Komugi kiŋ pombaa iriŋa soono manjaqeqe tuuŋa wasiŋ oŋono kema nama borosa meme eja ii kondeema oŋoma taoŋ mirigia ii kuugi jero. ");
INSERT INTO ksr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Kawaa gematanoŋ kiŋnoŋ weleŋqeqeuruta ii kokaeŋ iŋijoro, ‘Maraŋ lombaŋ mozozoŋgoniŋ jojoriŋ rajato, ejemba kawutiwaajoŋ jeweti, iyoŋonoŋ mono korisoronoŋ kakawaa so mende kolooju. ");
INSERT INTO ksr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kawaajoŋ oŋo mono kana aogaranoŋ ano miri sombeŋa sombeŋa kanoŋ kema ejemba ii me ii mokolooŋ oŋombuti, ii mono maraŋ lombanoŋ kawutiwaajoŋ jeŋ kaparaŋ koma kuuŋ oŋombu.’ ");
INSERT INTO ksr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Kaeŋ iŋijoro weleŋqeqeurutanoŋ mesaoŋ kana eŋ keŋgiti, iikanoŋ kema ejemba ii me ii mokolooŋ oŋoŋgiti, ii korebore horoŋ kululuuŋ oŋoma kagi. Mende gosiŋ oŋoŋgi ejemba awaa ano bologa kaaŋadeeŋ kaŋ maraŋ lombaŋ miri gojoma nene duŋ liligoŋ ragi. ");
INSERT INTO ksr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nene duŋ liligoŋ ragito, kiŋnoŋ ii iŋiimambaajoŋ kaŋ iikanoŋ eja moŋ maraŋ lombambaa maleku taaŋa mende mouroti, ii iiro. ");
INSERT INTO ksr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Eja ii iima kokaeŋ ijoro, ‘Alana, gii maraŋ lombambaa malekuya mende mouma kileŋ nomaembaajoŋ miri koi kawaa uutanoŋ kajaŋa?’ Kaeŋ ijoro eja iikanoŋ qaaya bogoro oloŋ raro. ");
INSERT INTO ksr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Kaeŋ raro kiŋ poŋnoŋ weleŋqeqeuruta kokaeŋ jeŋ kotoŋ oŋono, ‘Mono eja ii meŋ kana boria somoŋgoŋ seleeŋgeŋ giligi paŋgamanoŋ kemeba.’ Iikanoŋ laligowuti, iyoŋonoŋ mono saama gigilaaŋ gobugia kigi qaro laligowuya. ");
INSERT INTO ksr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Qaa iikawaa so Anutunoŋ ejemba seiseiyanoŋ kawutiwaajoŋ jeroto, afaaŋgoya yoŋonoŋ qaa ii aŋaliŋ moma aŋgoŋ koma kaŋ Anutunoŋ tuuŋ somata meweeŋgoŋ oŋonoti, mono iyoŋoo batugianoŋ koubuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kawaa gematanoŋ Farisii (Kana qaawaa kaparaŋkoŋkoŋ) yoŋonoŋ kema amiŋ moma Jiisas qisiŋ qaawaa timbinoŋ hororo gbadooŋ mubombaajoŋ areŋa aŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Areŋ kaeŋ ama gowokouruta ano gawana Herodwaa paati alauruta tosaaŋa wasiŋ oŋoŋgi Jiisaswaanoŋ kaŋ kokaeŋ qisiŋ jegi, “Boi, giinoŋ eja hoŋa koloojaŋi, nono ii mojoŋ. Giinoŋ ejemba tosaaŋa mende iŋisosorooŋ tosaaŋa mende sureeŋ oŋomakejanto, so motooŋgonoŋ gosiŋ nonomakejaŋ. Kawaajoŋ kuuŋ goŋgi mende dogoŋ somata mende esuuŋ oŋomakejanto, Anutuwaanoŋ kana ii qaa hoŋaa so kuma nonomakejaŋ. Giinoŋ Anutuwaanoŋ qaa dindiŋa iikanoŋ uuta ano kamaaŋqeqeta motoondeeŋ kuuya jeŋ qindiiŋ ama nonomakejaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kawaajoŋ qaa koi kawaajoŋ nomaeŋ romoŋgojaŋi, ii jena moboŋ. Nono Siisa-kimbaajoŋ takis ama iikanoŋ Mooseswaa Kana qaa soŋgiwoŋa me qaago?” ");
INSERT INTO ksr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kaeŋ qisigi areŋgia qoloŋmoloŋgoya moma kotoŋ kokaeŋ iŋijoro, “Oo uumeleembaa eja seleseleya, oŋo mono naambaajoŋ qaawaa timbinoŋ ama nombombaajoŋ aŋgobato meŋ nonju? ");
INSERT INTO ksr_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Saanoŋ takis aambaa moneŋa moŋ qendeema noŋgi iimaŋa.” Kaeŋ iŋijoro silwa moneŋ moŋ meŋ kagi. ");
INSERT INTO ksr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kagi kokaeŋ qisiŋ oŋono, “Morowaa uŋayaga ano qataga ii koi oogita eja?” ");
INSERT INTO ksr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Oo ii Siisa-kimbaanoŋa,” kaeŋ meleema jegi. Jegi kokaeŋ iŋijoro, “Kaeŋ kolooro iwoi Siisa-kimbaa uŋayawo ii mono iwaa buŋa muŋkebu. Iwoi Anutuwaa uŋayawo eji, ii mono Anutuwaa buŋa qewu.” ");
INSERT INTO ksr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kaeŋ iŋijoro iwaajoŋ mamaga waliŋgoŋ mesaoŋ seleeŋgeŋ keŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sadusii (Jigo gawombaa kaparaŋkoŋkoŋ) yoŋonoŋ ‘Komugiti, iyoŋonoŋ mende waabuya,’ jeŋ laligogi. Kambaŋ kanoŋ yoŋoonoŋga tosianoŋ Jiisaswaanoŋ kaŋ kokaeŋ qisiŋ muŋ jegi, ");
INSERT INTO ksr_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Boi, Moosesnoŋ kokaeŋ jeŋ kotoŋ nononota eja, ‘Eja moŋ emba mero merabora mende koloogi komuro koganoŋ saanoŋ maloya meŋ laligoŋ gbili mekolooŋ muro dataa qa meŋ laligowaa.’ ");
INSERT INTO ksr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Moba, kambaŋ moŋnoŋ daremuŋ 7 laligogi. Dagia mutuyanoŋ emba meŋ laligoŋ gbilia qaa eeŋ laligoŋ komuro. Komuro koganoŋ maloya ii mero. ");
INSERT INTO ksr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","“Meŋ laligoŋ komuro koga moŋnoŋ maloya ii mero. Mero kawaa gematanoŋ koga moŋnoŋ emba iikayadeeŋ mero. Kaanondeeŋ kaaŋ daremuŋ 7 kuuya yoŋonoŋ emba motooŋgo iikayadeeŋ meŋ gbilia qaa laligoŋ komudaborogi. ");
INSERT INTO ksr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Komudaborogi konoga malogia ii kaaŋagadeeŋ komuro. ");
INSERT INTO ksr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Giinoŋ ‘Komugiti, iyoŋonoŋ gbiliŋ waabuya,’ jejanto, nono ii mende moma laarijoŋ. Moba, eja 7 kuuya ii ororoŋ waabuyagati eeŋ, emba motooŋgo ii embagiaga megi laligorotiwaajoŋ ama mono morowaa embiaga koloonaga?” ");
INSERT INTO ksr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kaeŋ qisigi Jiisasnoŋ meleema kokaeŋ iŋijoro, “Oŋo qaa jeŋ sooju. Uumeleembaa Buŋa Tereya ano Anutuwaa ku-usuŋa mende moma kotojutiwaajoŋ mono jiŋjauŋ amakeju. ");
INSERT INTO ksr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Oŋanoŋ, koomunoŋga waama kambaŋ iikanoŋ loemba mende koloowuyato, gajoba yoŋonoŋ Siwe gomanoŋ laligojuti kaaŋa kolooŋ laligowuya. ");
INSERT INTO ksr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Mobu! Komugiti, iyoŋonoŋ gbiliŋ waabutiwaa qaaya Anutunoŋ oŋoojoŋ jeroti, oŋo ii mono weeŋgogi me qaago? Qaa ii kokaeŋ, ");
INSERT INTO ksr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Niinoŋ Anutu Aabrahambaa Poŋ, Aisakwaa Poŋ ano Jeikobwaa Poŋga laligoŋ waama laligojeŋ.’ Anutunoŋ koomuya yoŋoo Poŋgia qaagoto, laaligo kombombaŋa laligojuti, mono iyoŋoo Poŋgiaga laligoja.” ");
INSERT INTO ksr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jiisasnoŋ ejemba tuuŋ somata kaeŋ kuma oŋono moma waliŋgogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sadusii (Jigo gawombaa kaparaŋkoŋkoŋ) yoŋonoŋ Jiisas qisiŋ mugi meleema jeŋ sororogoro qaagia bogoroti, ii Farisii (Kana qaawaa kaparaŋkoŋkoŋ) yoŋonoŋ moma kaŋ ajoroogi. ");
INSERT INTO ksr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yoŋoonoŋga boi moŋ Kana qaa tororo moma kotoroti, iinoŋ kaŋ Jiisas timbi ama kokaeŋ qisiŋ muro, ");
INSERT INTO ksr_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Boi, Mooseswaa Kana qaa uutanoŋ naa jojopaŋ qaa ii waŋa somata kolooja?” ");
INSERT INTO ksr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Qisiŋ muro meleeno, “Waŋa somata ii kokaeŋ, ‘Gii uuga, uŋaga ano roromoŋgoga jumuŋa iikanoŋ mono Poŋ Anutuga jopagoŋ laligowa.’ ");
INSERT INTO ksr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iikanoŋ mono jojopaŋ qaa waŋa ano uuta kolooja. ");
INSERT INTO ksr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Jojopaŋ qaa iikawaa alia ii kokaeŋ, ‘Geeŋga jopagoŋ aoŋkejaŋi, iikaaŋiadeeŋ mono ejemba kuuya jopagoŋ oŋoma laligowa.’ ");
INSERT INTO ksr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Jojopaŋ qaa woi ii mono Mooseswaa Kana qaa ano gejatootoo ejemba yoŋoonoŋ Buju Tere kuuya iikawaa waŋaga kolooja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisii (Kana qaawaa kaparaŋkoŋkoŋ) yoŋonoŋ kaŋ ajoroogi Jiisasnoŋ kokaeŋ qisiŋ oŋono, ");
INSERT INTO ksr_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Oŋo Kraistwaajoŋ nomaeŋ moju? Iinoŋ mono morowaa meriaga kolooja?” Kaeŋ qisiŋ oŋono meleema ijogi, “Mono kiŋ Deiwidwaa gbiliaga kolooja.” ");
INSERT INTO ksr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ijogi moma iŋijoro, “Kaeŋ koloojato, nomaeŋ ama Uŋa Toroyanoŋ Deiwid sololooŋ muro iwaajoŋ ‘Neenaa Poŋna,’ qama kokaeŋ jero, ");
INSERT INTO ksr_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Anutunoŋ nama noo Poŋna kokaeŋ ijoro, Giinoŋ mono kaŋ noo boro dindinanoŋ rana niinoŋ kambaŋ biiwianoŋ kereuruga riiŋ riitama haamo ama oŋoma goo kana baaganoŋ oŋoomaŋa. Kambaŋ ii kaŋ kuuwaatiwaa so mono asamararanoŋ koi raba.’ ");
INSERT INTO ksr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Deiwidnoŋ aŋo kaeŋ jeŋ qata ‘Noo Poŋna’ jeja. Poŋna jeŋ mono nomaeŋ ama iwaa gbilia kaaŋgadeeŋ koloonaga?” ");
INSERT INTO ksr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kaeŋ iŋijoro iikawaa kitia moŋnoŋ moŋ meleemambaajoŋ amamaaŋ qaagia bogoro naŋgi. Somaŋa iikanondeeŋ kuuya yoŋonoŋ Jiisas mombo qaa mombaa qisiŋ mubombaajoŋ kokodunduŋ ama mesaogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kambaŋ kanoŋ Jiisasnoŋ ejemba tuuŋlelembe ano gowokouruta ii kokaeŋ iŋijoro, ");
INSERT INTO ksr_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Kana qaawaa boi ano Farisii (Kana qaawaa kaparaŋkoŋkoŋ) yoŋonoŋ Mooseswaa jiŋkaroŋ duŋ raranoŋ rama Kana qaawaa kania ku-usuŋ qaganoŋ kuma oŋomakeju. ");
INSERT INTO ksr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kawaajoŋ qaa kuuya jeŋ kotoŋ oŋomakejuti, ii mono teŋ kombuto, nanamemeŋgia ii mono mende otaawu. Yoŋonoŋ qaa jegianoŋ jeŋ asariŋkejuto, iyaŋgio ii mende otaaŋkeju. Kawaajoŋ mono ii kaaŋa mende amakebu. ");
INSERT INTO ksr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","“Yoŋonoŋ qaaya qaaya jeŋ kotoŋ iikawaa qaqaŋ biŋawo ii ejemba sawiŋgianoŋ amago aŋgi ii aŋgowombaajoŋ bimooro jarambaraŋ amakejuto, iyaŋgio ii boro susugia melaa moŋnoŋ ilaaŋ oŋombombaajoŋ wosomomogia moŋ mende eŋkeja. ");
INSERT INTO ksr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Yoŋonoŋ nanamemeŋgia kuuya ejembanoŋ iŋiibutiwaajoŋ ama meŋkeju. Baibel qaa kota (memori jawo) irimuŋ kasa bokisgia meŋ somariiŋ asuganoŋ qendeema Buŋa momogiaajoŋ awelegoŋ aoŋkeju. Malekugiaa susuyanoŋ akadamuwaa goubire somasomata meŋ mondoŋkeju. ");
INSERT INTO ksr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yoŋonoŋ jejelombanoŋ duŋ rara mutuyanoŋ jegeŋjegeŋ rabombaajoŋ momakeju ano qamakooli mirinoŋ jaaqeqeyanoŋ eu rabombaajoŋ siiŋa momakeju. ");
INSERT INTO ksr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Maaketnoŋ me kananoŋ ejemba iŋiigi joloŋgia jewutiwaajoŋ moma ‘Oo somatanana,’ qagia kaaŋ qabutiwaa siiŋa momakeju. ");
INSERT INTO ksr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Yoŋonoŋ kaeŋ amakejuto, motooŋgo iinoŋ oŋoo Boigia kolooro oŋo kuuyanoŋ iwaa uumeleeŋ alauruta kolooju. Kawaajoŋ oŋoo qagia boinana qabutiwaajoŋ mende mobu. ");
INSERT INTO ksr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Motooŋgo iinoŋ Maŋgia kolooja. Iinoŋ Siwe gomanoŋ laligojiwaajoŋ baloŋ eja mombaajoŋ nonoo Maŋnana qa kaeŋ mende qabu. ");
INSERT INTO ksr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kraist motooŋgo niinoŋ oŋoo somatagia koloojeŋ. Kawaajoŋ oŋoo qagia ‘Somatanana,’ qabutiwaajoŋ mende mobu. ");
INSERT INTO ksr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","“Kaeŋ qaagoto, oŋoo batugianoŋ moŋnoŋ waŋa kolooji, iinoŋ mono weleŋ qeŋ oŋoma laligowa. ");
INSERT INTO ksr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kaeŋ laligowaato, moŋnoŋ iyaŋaa uuta meŋ ubaati, Anutunoŋ mono ii meŋ kamaaŋ mubaa. Moŋnoŋ iyaŋaa uuta meŋ kamaawaati, Anutunoŋ mono ii meŋ uma mubaa. ");
INSERT INTO ksr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Oo Kana qaawaa boi ano iikawaa kaparaŋkoŋkoŋ ejemba! Oŋo uumeleembaa ejemba seleseleya koloogi lombo qagianoŋ ubaatiwaajoŋ mono qama wanjinjiŋgoŋ ‘Yei!’ jejeŋ. Ejemba Siwewaa bentotoŋ uutanoŋ keububotiwaa naguya koma somoŋgoŋkeju. Oŋoaŋgio iikawaa uutanoŋ mende keuju ano tosianoŋ iikawaa uutanoŋ keubombaajoŋ anjuti, oŋo ii somoŋgoŋ aŋgoŋ koma oŋomakeju. ");
INSERT INTO ksr_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Oo Kana qaawaa boi ano iikawaa kaparaŋkoŋkoŋ ejemba! Oŋo uumeleembaa ejemba seleseleya koloogi lombo qagianoŋ ubaatiwaajoŋ mono qama wanjinjiŋgoŋ ‘Yei!’ jejeŋ. Oŋo malo yoŋoonoŋ miri iwoi bidaaŋ baagoŋ aŋaliŋ oŋomakeju ano qabuŋagia koloowaatiwaajoŋ ama qamakooli koriga koriga qama kooliŋ totogianoŋ qeŋkeju. Kawaajoŋ Anutunoŋ qaagia jeŋ tegoŋ iroŋa uuta meleeno oŋoo qagianoŋ ubaa. ");
INSERT INTO ksr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Oo Kana qaawaa boi ano iikawaa kaparaŋkoŋkoŋ ejemba! Oŋo uumeleembaa ejemba seleseleya koloogi lombo qagianoŋ ubaatiwaajoŋ mono qama wanjinjiŋgoŋ ‘Yei!’ jejeŋ. Oŋo moŋnoŋ Juuda ejemba moŋ koloowaatiwaajoŋ kaparaŋ koma koweya koweya kotoŋ baloŋa baloŋa liligoŋkeju. Kaeŋ aŋgi moŋnoŋ Juuda ananaa nanamemenoŋ qokotaawaati, ii mono kuma sooŋ mugi gere siawaa buŋa koloowaa. Oŋoaŋgia kaaŋa qaagoto, indiŋa woi oŋoaŋgia uŋuuguŋ kileqileewaa. ");
INSERT INTO ksr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Jaagianoŋ gooro ejemba borogianoŋ meŋ uŋuamakejuti, lombo oŋoo qagianoŋ ubaatiwaajoŋ mono qama wanjinjiŋgoŋ ‘Yei!’ jejeŋ. Oŋo qaa kokaeŋ jeŋkeju, ‘Moŋnoŋ jiwowoŋ jigowaa qatanoŋ qaaya jojopaŋ qaanoŋ jeŋ kotiiwaati eeŋ, iikanoŋ mende kotiiwaato, moŋnoŋ jiwowoŋ jigowaa iwoi goulnoŋ memeta iikawaa qatanoŋ jojopaŋ qaaya jewaati eeŋ, jojopaŋ qaa iikanoŋ mono somoŋgoŋ mubaa.’ ");
INSERT INTO ksr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","“Oo jaagoo ejemba nekoŋa! Iwoi goulnoŋ memeta ano jiwowoŋ jigo woi yoroonoŋga naa iwoinoŋ uuta kolooja? Goul yaŋo kowoga mende koloojato, jiwowoŋ jigonoŋ aŋgi iikanoŋ mono ii meŋ kobooja. ");
INSERT INTO ksr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Qaa moŋ kokaeŋ jeŋkeju, ‘Moŋnoŋ alatawaa qata qama qaaya jojopaŋ qaanoŋ jeŋ kotiiwaati eeŋ, iikanoŋ mende kotiiwaato, moŋnoŋ nanduŋ mamatewoo alatanoŋ eji, iikawaa qata qama jojopaŋ qaaya jewaati eeŋ, jojopaŋ qaa iikanoŋ mono somoŋgoŋ mubaa.’ ");
INSERT INTO ksr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","“Oo jaagoo ejemba! Nanduŋ mamatewoo ano alata yoroonoŋga naa iwoinoŋ uuta kolooja? Nanduŋ yaŋo kamaaŋqeqeta koloojato, alatanoŋ aŋgi iikanoŋ mono nanduŋ meŋ kobooja. ");
INSERT INTO ksr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kawaajoŋ moŋnoŋ alatawaa qanoŋ qaaya jojopaŋ qaanoŋ jeŋ kotiiwaati, iinoŋ alata ano iwoi kuuya alatanoŋ eji, mono iikawaa qanoŋ qaaya jeŋ kotiiwaa. ");
INSERT INTO ksr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","“Moŋnoŋ jiwowoŋ jigowaa qanoŋ qaaya jojopaŋ qaanoŋ jeŋ kotiiwaati, iinoŋ mono jigo iikawaa ano iikanoŋ kotiiŋ laligoji, iwaa qanoŋ qaaya jeŋ kotiiwaa. ");
INSERT INTO ksr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kaaŋadeeŋ moŋnoŋ Siwewaa qanoŋ qaaya jojopaŋ qaanoŋ jeŋ kotiiwaati, iinoŋ Anutuwaa jiŋkaroŋ duŋ ano iikanoŋ raji, iwaa qanoŋ qaaya jeŋ kotiiwaa. ");
INSERT INTO ksr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Oo Kana qaawaa boi ano iikawaa kaparaŋkoŋkoŋ ejemba! Oŋo uumeleembaa ejemba seleseleya koloogi lombo qagianoŋ ubaatiwaajoŋ mono qama wanjinjiŋgoŋ ‘Yei!’ jejeŋ. Oŋo nembanene kuuya mendeema bakaya 10 iikanoŋa motooŋgo Anutuwaa buŋa qeŋkeju. Daŋe, raki ano kiesopa ii kaaŋadeeŋ mendeema tenoŋga motooŋgo ii Anutuwaa buŋa qeŋkeju. Nanduŋ ii tororo amakejuto, Kana qaawaa kota waŋa koi mono uuguŋ mesaoŋkeju: Gii ejemba batugianoŋ nanamemeŋ dindiŋa otaaŋ kiaŋkomuŋ aoŋ qaa pondaŋ otaaŋ laligowa. Qaa waŋa ii mono kaparaŋ koma otaaŋ laligowu ano qaa melamelaa ii kaaŋagadeeŋ mende uuguŋ mesaowu. ");
INSERT INTO ksr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Jaagia gooro ejemba borogianoŋ meŋ uŋuamakejuti, oŋo jeŋgeraŋ apuwo newubotiwaajoŋ apugia saiyanoŋ gosiŋkejuto, oro somata kamel ii tondu gogoŋkeju. ");
INSERT INTO ksr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Oo Kana qaawaa boi ano iikawaa kaparaŋkoŋkoŋ ejemba! Oŋo uumeleembaa ejemba seleseleya koloogi lombo qagianoŋ ubaatiwaajoŋ mono qama wanjinjiŋgoŋ ‘Yei!’ jejeŋ. Oŋo hamo qeŋ aowombaajoŋ qambi ano amanenewaa selia soŋgbama yagoŋkejuto, oŋoaŋgiaa dogo otokogia mende galeŋ koma iwoi tondu goroŋgoŋ nepaqepalo aŋgi iikanoŋ uugia saa qero laligoju. ");
INSERT INTO ksr_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","“Oo jaagoo eja Kana qaawaajoŋ kaparaŋ komakejaŋi, gii mono wala qambiwaa uuta soŋgbana selianoŋ kaaŋagadeeŋ tataaŋkota koloowaa. ");
INSERT INTO ksr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Oo Kana qaawaa boi ano iikawaa kaparaŋkoŋkoŋ ejemba! Oŋo uumeleembaa ejemba seleseleya koloogi lombo qagianoŋ ubaatiwaajoŋ mono qama wanjinjiŋgoŋ ‘Yei!’ jejeŋ. Oŋo qasiriwaa maripooŋa soŋgbaŋgi taaŋa koloojuti, mono iikawaa so kolooju. Selegianoŋ iimasiiŋsiiŋgiawo kaaŋa koloojuto, qasiriwaa uutanoŋ qamo sii ano iwoi arokuukuuyawo eji, iikaaŋanoŋ mono oŋoo uugia saa qeŋ eja. ");
INSERT INTO ksr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","“Iikawaa so oŋo kaaŋagadeeŋ ejemba jaagianoŋ oŋanoŋ dindiŋa tani kolooŋkejuto, uumeleembaa selesele tani ano qewolonoŋ mono uugia saa qero laligoju. ");
INSERT INTO ksr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Oo Kana qaawaa boi ano iikawaa kaparaŋkoŋkoŋ ejemba! Oŋo uumeleembaa ejemba seleseleya koloogi lombo qagianoŋ ubaatiwaajoŋ mono qama wanjinjiŋgoŋ ‘Yei!’ jejeŋ. Oŋo gejatootoo ejemba yoŋoo qasirinoŋ simeŋ kuuŋ meŋkeju ano ejemba solaŋa yoŋoo jamo kobaagia menjereŋgoŋkeju. ");
INSERT INTO ksr_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kaeŋ ama kokaeŋ jeŋkeju, ‘Nononoŋ ambosakonana yoŋoo kambanoŋ laligowonagati eeŋ, mono yoŋowo mende toroqeniŋ gejatootoo ejemba yoŋoo sagianoŋ mono nonoo qanananoŋ mende unaga.’ ");
INSERT INTO ksr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","“Kaeŋ jeŋ iikanoŋ oŋoaŋgio gejatootoo ejemba uŋugiti, iyoŋoo esaurugia koloojuti, mono qaa ii naŋgoŋ jeŋ daŋgunu kaaŋa nanju. ");
INSERT INTO ksr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kawaajoŋ ambosakoŋgianoŋ siŋgisoŋgo kanaiŋ aŋgiti, iikawaa so oŋo mono toroqeŋ kuuya andaborowu. ");
INSERT INTO ksr_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Oo Farisii, oŋo mono qato melaa kaaŋa kolooju. Anutunoŋ qaagia jeŋ tegoro gere sianoŋ kemebubotiwaajoŋ mono nomaeŋ umburatiŋ kembuyaga? Ii mono amamaawuya. ");
INSERT INTO ksr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kawaajoŋ mono mobu, niinoŋ gejatootoo ano momakooto ejemba ano Kana qaawaa boi wasiŋ oŋombe oŋoonoŋ kawuya. Kagi yoŋoonoŋga tosaaŋa ii uŋugi komuwuya ano tosaaŋa maripoonoŋ uŋuwuya. Tosaaŋa qamakooli mirigianoŋ ororaaŋ oŋoma qaagia jeŋ tegoŋ oolinoŋ oŋootiŋ konjoma oŋoŋgi taoŋa taoŋa kanoŋ kemakebuya. ");
INSERT INTO ksr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","“Eja solaŋa Aabelwaa sayanoŋ kamaaro iikanoŋa kanaiŋ uŋuŋ kouma laligoŋ Zekaraia jiwowoŋ jigo kowoga ano siimoloŋ alata yoroo batugaranoŋ qegi saya kamaaro iikanoŋ tegoro. Ejemba solaŋa yoŋoo sagia balonoŋ molaaŋ laligogiti, sa kuuya iikawaa iroŋa mono oŋoo qagianoŋ ubaa. ");
INSERT INTO ksr_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Sagiaa iroŋa kuuya ii mono ejemba kete laligojuti, mono oŋoo qagianoŋ uro Anutunoŋ iroŋa meleema oŋono mobuya.” ");
INSERT INTO ksr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jiisasnoŋ jero, “Oo Jerusalem Jerusalem, oŋo gejatootoo ejemba uŋugi komugi Anutunoŋ ejemba wasiŋ oŋono oŋoonoŋ kaŋkejuti, ii jamonoŋ uŋugi komuŋkeju. Kuru nemuŋanoŋ meraboraaŋa eŋgaŋa baatanoŋ ama kojojooŋ oŋomakeji, niinoŋ mono iikawaa so kambaŋa kambaŋa goo kanagesouruga kotama kololooŋ oŋomambaajoŋ moma laligoweto, oŋo ii togoŋ laligoŋ kougi. ");
INSERT INTO ksr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mobu, Anutunoŋ mono jigo mirigia gema qero saoyagadeeŋ ewaa. ");
INSERT INTO ksr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","“Kaeŋ ewaato, niinoŋ kokaeŋ iŋijowe mobu, Oŋo nii mombo mende niibuya. Kanageŋ kambaŋ moŋ kaŋ kuuro iikanoŋ niima kokaeŋ jewuya, ‘Pombaa qatanoŋ kaŋ nononji, Anutunoŋ mono ii kotuegoŋ muba.’ Kiaŋ.” ");
INSERT INTO ksr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jiisasnoŋ jiwowoŋ jigo mesaoŋ kamaaro gowokourutanoŋ iwaanoŋ kaŋ jiwowoŋ jigowaa totoŋ uutanoŋ miri ragiti, ii Jiisas qendeema mugi. ");
INSERT INTO ksr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Qendeema mugi meleema kokaeŋ iŋijoro, “Miri kuuya ii saanoŋ iŋiijuto, niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Ii mono kondeeŋgi miriwaa jamo moŋ ii jamo mombaa qaganoŋ mende ewaato, qeqelala saoyagadeeŋ ewaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jiisasnoŋ Oil gere baaŋanoŋ kema raro gowokourutanoŋ iyaŋgia siri iwaanoŋ kaŋ kokaeŋ qisiŋ mugi, “Boi, qaa jejaŋi, iikawaa hoŋa mono naa kambanoŋ asugiwaa ano giinoŋ kana balombaa kambaŋa tegomambaajoŋ ambaati, iikawaa aiweseyanoŋ mono nomaeŋ asugiwaa? Ii saanoŋ ninijowa.” ");
INSERT INTO ksr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Kaeŋ qisiŋ mugi meleema kokaeŋ jero: “Moŋnoŋ aŋgomokoloŋ ano jiŋjauŋ kembubotiwaajoŋ mono galeŋgia meŋ laligowu. ");
INSERT INTO ksr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ejemba mamaganoŋ asugiŋ noo qananoŋ kokaeŋ jewuya, ‘Niinoŋ Hamoqeqe Toya Kraist koloojeŋ.’ Kaeŋ jeŋ ejemba mamaga tiligoŋ oŋombuya. ");
INSERT INTO ksr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Oŋo manjawaa bujuya ano otoŋa kolooŋ kema karo momakebuya. Ii moma jeneŋgia orowabotiwaajoŋ mono galeŋgia mewu. Iwoi kaaŋa ii waladeeŋ koloowaatiwaa jejetaga. Ii koloowaato, balombaa kambaŋanoŋ mono iikanondeeŋ uulaŋawo mende tegowaa. ");
INSERT INTO ksr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","“Kantri moŋnoŋ kantri moŋ uŋuwombaajoŋ waabuya. Ejemba tuuŋ moŋnoŋ tuuŋ moŋ yoŋowo aroŋ qeŋ aowombaajoŋ waabuya. Gomaŋa gomaŋa kanoŋ bodia bodia koloowaa ano naŋ somasomata ii qonjoma meŋ namo meleeno kemeŋkebaa. ");
INSERT INTO ksr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Iwoi kuuya ii emba korowonoŋ masu kanaiŋ uŋuŋkejiwaa so. Balombaa kambaŋanoŋ mono iikawaa so kanaiŋ tegomambaajoŋ ambaa. ");
INSERT INTO ksr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kaeŋ ambaato, kambaŋ kanoŋ tosianoŋ oŋo uugia meleeŋgitiwaajoŋ ama gawman yoŋoo boronoŋ oŋooŋgi siimbobolo ama oŋoma uŋugi komuwuya. Kantri kuuya yoŋonoŋ noojoŋa ama kazi ama oŋomakebu. ");
INSERT INTO ksr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kambaŋ kanoŋ mamaganoŋ momalaarigia mesaoŋ aŋgonaŋ meŋ kazi ama aowuya. ");
INSERT INTO ksr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Gejatootoo ejemba takapolakaya mamaganoŋ asugiŋ ejemba mamaga kilikalu meŋ oŋoŋgi jiŋjauŋ qeŋ kemakebuya. ");
INSERT INTO ksr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","“Jeulalaŋ Toyanoŋ seiŋ ejemba galeŋ koma oŋombaatiwaajoŋ ama uumeleeŋ ejemba seiseiya yoŋoo uugianoŋ olomooro uujopagianoŋ looriŋ zololoŋgowaa. ");
INSERT INTO ksr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Moŋnoŋ kaparaŋ koma kotiiŋ boŋ qeŋ nama laligoro balombaa kambaŋanoŋ tegowaati, iinoŋ mono oyaŋboyaŋ buŋa qeŋ aowaa. ");
INSERT INTO ksr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Anutuwaa bentotoŋaa Oligaa Buŋa koi mono waladeeŋ namowaa kantria kantria kuuya kanoŋ jeŋ seigi kanageso so naŋgonaŋgo qaaya mogigo balombaa kambaŋanoŋ iikawaa gematanoŋ tegowaa. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Gejatootoo eja Danielnoŋ kondemondeeŋ uuduuduyawo kawaa qaaya jerota eja. Qaa iikawaa so tosianoŋ kaŋ kondemondeeŋ ano iwoi aŋgonjorayawo ii jiwowoŋ jigo toroyanoŋ aŋgi nano iibuti, qaa koi weeŋgowagati, iinoŋ mono saanoŋ geja ama moma kotowa. ");
INSERT INTO ksr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kambaŋ iikanoŋ Judia prowinsnoŋ laligowuti, oŋonoŋ mono misiŋgoŋ horoŋ baaŋanoŋ kembu. ");
INSERT INTO ksr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Miri kosianoŋ sombenoŋ laligowaati, iinoŋ mono kamaaŋ geso iwoiya memambaajoŋ miri uutanoŋ mende uba. ");
INSERT INTO ksr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Gawonoŋ kema laligowaati, iinoŋ mono kaaŋagadeeŋ malekuya memambaajoŋ eleema mirinoŋ mende kemba. ");
INSERT INTO ksr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","“Yei! Emba korowo ano merabora ajunoŋ yoŋonoŋ kambaŋ iikanoŋ nomaeŋ uulaŋawo kembuya? ");
INSERT INTO ksr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kawaajoŋ iwoi ii koŋuru me Sabat kendombaa kambaŋanoŋ mende koloowaatiwaajoŋ mono qama kooliŋkebu. ");
INSERT INTO ksr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","“Ii kokaembaajoŋ: Kambaŋ iikanoŋ kakasililiŋ jekania booroŋgoya koloowaa. Kakasililiŋ soya kaaŋa ii wala eeŋanoŋ kambaŋ moŋgeŋ mende kolooŋ ero. Anutunoŋ iwoi kuuya mokolooroti, kambaŋ iikanondeeŋ kanaiŋ kambaŋ kokanoŋ laligoŋ kouma kambaŋ biiwianoŋ moŋ mende kolooro. Wala eeŋanoŋ mende kolooro ano kanageŋ kambaŋ moŋnoŋ mombo mende koloowaa. Kawaajoŋ mono qama kooliŋ laligowu. ");
INSERT INTO ksr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Poŋnoŋ kokojinjiŋ kambaŋ ii mende meŋ torinagati eeŋ, ejemba kuuyanoŋ mono tiwilaadaborowuyagato, ejemba iyaŋaajoŋ meweeŋgoŋ oŋonoti, iyoŋoojoŋ ama weeŋ iikawaa jaŋgoya ii meŋ toriwaa. ");
INSERT INTO ksr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Kambaŋ iikanoŋ kokaeŋ jewuya, ‘Mobu! Kraistnoŋ koi laligoja,’ me ‘Iibu! Hamoqeqe Toyanoŋ endu nanja.’ Moŋnoŋ kaeŋ jewaati eeŋ, ii mono mende moma laariwu. ");
INSERT INTO ksr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ii kokaembaajoŋ: Hamoqeqe toya qoloŋmoloŋgoya ano gejatootoo ejemba takapolakaya asugiŋ aŋgoleto ano aiwese somasomata megi letombuya. Kaeŋ letoŋgi Anutunoŋ ejemba iyaŋaajoŋ meweeŋgoŋ oŋonoti, ii kaaŋagadeeŋ eŋkaloloŋ meŋ oŋombutiwaajoŋ aŋgobato meŋ kaparaŋ koŋgi jiŋjauŋ qewubo. Oŋo galeŋgia awaagadeeŋ meŋ aoŋ laligogi ii amamaawuya. ");
INSERT INTO ksr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mobu! Niinoŋ iwoi kuuya ii mende kolooro waladeeŋ iŋijowe modaboroju. ");
INSERT INTO ksr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Kawaajoŋ ‘Hamoqeqe Toyanoŋ baloŋ qararaŋkoŋkoŋanoŋ laligoja,’ kaeŋ jegi mobuti eeŋ, iikanoŋ mono mende kembu. Me ‘Mobu! Kraistnoŋ miri kawaa uutanoŋ asugiŋ raja,’ kaeŋ iŋijogi ii mende moma laariwu. ");
INSERT INTO ksr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ii kokaembaajoŋ: Siwe gomambaa Eja hoŋanoŋ mombo kawaati, kambaŋ ii mono oobiliwaa so kokaeŋ koloowaa: Ii weeŋ koukoutanoŋga pilitik bilisik ama leegeŋ weeŋ kemekemetanoŋ sokoma asariŋ keno iijoŋi, iinoŋ mono iikawaa so asugiwaa. ");
INSERT INTO ksr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Oro gisaganoŋ moŋgeŋ ewaati, mamboŋkarara yoŋonoŋ iikanoŋ horoŋ ajorooŋkejuti, mono iikawaa so koloowaa.” Kiaŋ ");
INSERT INTO ksr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Koŋajiliŋ kambaŋ iikanoŋ tegoro iikanondeeŋ weeŋ jaayanoŋ injaŋ kono koiŋnoŋ umuŋ kombaa. Seŋgelao yoŋonoŋ sombinoŋga tegoŋ kamaawuya ano sombinoŋ utugoro iikawaa ilawoilaya ii raragia mesaoŋ eŋkaloloŋ aŋgi soowaa. ");
INSERT INTO ksr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kambaŋ iikanoŋ Siwe gomambaa Eja hoŋaa aiweseyanoŋ sombinoŋ asugiro iibuya. Kambaŋ iikanoŋ namowaa kanageso kuuya yoŋonoŋ jiŋgeŋ qama saabuya. Saama Siwe gomambaa Eja hoŋa iinoŋ sombimbaa koosu qaganoŋ karo iibuya. Ku-usuŋa somatanoŋ sakondindiŋawo asuganoŋ asugiro asamararaŋa iibuya. ");
INSERT INTO ksr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Karo iigi romoŋ qaita moŋ uugi otoŋa kotakota mogi Siwe gajobauruta wasiŋ oŋono yoŋonoŋ ejemba Anutunoŋ iyaŋaajoŋ meweeŋgoŋ oŋonoti, ii baloŋ goraaya teetee eugeŋ emugeŋ iikanoŋa kopepereeŋ oŋoma uŋuambuya. Kiaŋ ");
INSERT INTO ksr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Oŋo noroŋ gere iima tania romoŋgoŋ sareqaa koi mobu. Borianoŋ apuyawo kolooro seŋgia loŋgogi ii iima moma kokaeŋ jeŋkeju, ‘Weeŋ kambaŋa mono dodowija.’ ");
INSERT INTO ksr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Oŋonoŋ kaaŋiadeeŋ aiwese iikawaa so asugiro iima moma asariŋ kania kokaeŋ jewu, ‘Jiisasnoŋ mono nagunoŋ dodowija.’ ");
INSERT INTO ksr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","“Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Ejemba koi kete namonoŋ laligojuti, iyoŋonoŋ mende komugi iwoi kuuya jejeŋi, ii mono iyoŋoo laaligo kambaŋgianoŋ koloowaa. ");
INSERT INTO ksr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Sombiŋ namonoŋ goroŋ qewaoto, noo Buŋa qaananoŋ mono kambaŋ moŋnoŋ mende aliwaa. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Siwe gomambaa Eja hoŋanoŋ kawaato, naa kambanoŋ kaŋ kuuwaati, iikawaa weeŋa me aua kambaŋa ii moŋnoŋ moŋ mende moja. Siwe gajobanoŋ ii mende moju. Anutuwaa Merianoŋ kaaŋagadeeŋ ii mende moja. Amanoŋ aŋodeeŋ ii moja. ");
INSERT INTO ksr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Wala eeŋanoŋ Nooawaa kambaŋanoŋ ejembanoŋ laaligogia qemasologeŋ qaganoŋ laligoŋ meŋ kileegiti, iikawaa so mono Siwe gomambaa Eja hoŋanoŋ mombo kawaatiwaa kambaŋanoŋ koloowaa. ");
INSERT INTO ksr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","“Apu gboulu somatanoŋ mende karo waladeeŋ iikanoŋ ejemba nene lombaŋ ama apu kotiga neŋ embaqemba sewaŋaajoŋ aŋgi kema karo agimiŋ aoŋ laligogi. Nanamemeŋ kaeŋ ama meŋ qemasologeŋ laligogi Nooanoŋ waŋgo uutanoŋ uroti, weeŋ iikanoŋ tegoro. ");
INSERT INTO ksr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tegoro naa iwoi koloowaati, ii mende mogi apu gboulu somatanoŋ kaŋ jinoŋa qaa tiwilaaŋ oŋono. Kanageŋ Siwe gomambaa Eja hoŋanoŋ mombo kawaati, kambaŋ iikanoŋ ejembanoŋ kaaŋiadeeŋ qemasologeŋ ama laligoŋ tiwilaawuya. ");
INSERT INTO ksr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Kambaŋ iikanoŋ eja woi gawonoŋ laligori yoroonoŋga moŋ meŋ moŋ mesaowuya. ");
INSERT INTO ksr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kaaŋiadeeŋ emba woi taweŋ orasiŋ rabaoti, iyoroonoŋga moŋ meŋ moŋ mesaowuya. ");
INSERT INTO ksr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Poŋnoŋ kawaatiwaa kambaŋa me auaya mende mojutiwaajoŋ mono uugbiligbili laligowu. ");
INSERT INTO ksr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Gbili laligowombaa qaa koi mono moma kotowu: Gomantiiŋanoŋ kikekakasililiŋ ejanoŋ naa kambanoŋ me auanoŋ kawaati, miri toyanoŋ ii monagati eeŋ, iinoŋ mono gbili rama miria awaagadeeŋ galeŋ mero qosoma umambaajoŋ amamaawaa. ");
INSERT INTO ksr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Oŋo ‘Siwe gomambaa Eja hoŋanoŋ kambaŋ kokanoŋ mende koubaa,’ jeŋ romoŋgogi iinoŋ mono kambaŋ iikanondeeŋ koubaa. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Kaeŋ kolooro gawoŋ meme ejemba batugianoŋ moronoŋ tiriŋ kotoŋ tosaaŋa uŋuuguja? Tosianoŋ zololoŋgoŋ gawoŋ mesaogi moŋnoŋ momakooto awaawaa qaganoŋ kaparaŋ koma pondaŋ meŋkeji, iinoŋ mono simbawoŋawo kolooja. Miri toyanoŋ nanamemeŋa gosiŋ iima moŋgeŋ kema miriaa ilawoilaya ii borianoŋ ano galeŋa koloowaa. Galeŋa kolooŋ weleŋqeqeuruta ijorotiwaa so kalaŋ koma kambaŋ dindiŋanoŋ uŋuagiŋkebaa. ");
INSERT INTO ksr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kaeŋ kalaŋ koma oŋoma laligoro toyanoŋ eleema kaŋ iikaaŋ iima ‘Mono simbawoŋawo koloojaŋ!’ jewaa. ");
INSERT INTO ksr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","“Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Toyanoŋ ‘Mono simbawoŋawo koloojaŋ!’ jeŋ esuhinaya kuuyaa galeŋa kuuŋ mubaa. ");
INSERT INTO ksr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kuuŋ mubaato, gawoŋ meme bibilokoya iinoŋ uutanoŋ romoŋgoŋ kokaeŋ jewaati eeŋ, ‘Poŋnaa kaka kambaŋanoŋ mono koriga eja.’ ");
INSERT INTO ksr_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Kaeŋ jeŋ kanaiŋ gawoŋ meme ejembauruta uŋuŋ ureeŋ aoŋ jejelombaŋ ama aisooŋ apu kotiga neŋ uuta sooro eŋkaloloŋ silemale kolooŋ laligowaa. ");
INSERT INTO ksr_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","“Kaeŋ laligoŋ kambaŋ moŋnoŋ poŋa koubaatiwaajoŋ mende mambombaati, mono iikanondeeŋ koubaa. Kambambaajoŋ imowamo ulumbuluŋ laligoro mono aua iikanondeeŋ kouma ");
INSERT INTO ksr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","qeŋ japaleleŋ meŋ muŋ jeŋ kotoro uumeleembaa ejemba seleseleya kaaŋa gere sianoŋ kemeŋ siimbobolo mobaa. Kaeŋ moma saama gigilaaŋ gobugia kigi qaro laligowuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jiisasnoŋ jero, “Mombo kamaŋati, kambaŋ iikanoŋ Siwewaa bentotoŋa ii kokaeŋ koloowaa: Maraŋ lombaŋ kambaŋanoŋ emba saraŋ jumuŋa ten yoŋonoŋ ‘Eja buŋawo aitoŋgowoŋa,’ jeŋ kiwagia meŋ kananoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Yoŋoonoŋga 5 ii momakootogiawo koloogito, tosaaŋa 5 ii nekoŋa. ");
INSERT INTO ksr_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nekoŋa yoŋonoŋ kiwagia megito, gere (koinsare) kelega mende meŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Momakootogiawo yoŋonoŋ kiwagia ano koinsare kele kaarogia kaaŋagadeeŋ meŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Keŋgi eja buŋanoŋ uulaŋawo mende karo mamboŋgi kambaŋ korirotiwaajoŋ kuuya yoŋoo jaalologia bomboŋ mero usugoŋ gaoŋ egi. ");
INSERT INTO ksr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Gaoŋ egito, gomantiiŋa biiwianoŋ moŋnoŋ romuŋ qero qa kokaeŋ mogi, ‘Mobu, eja buŋanoŋ mono kaja-oo! Mono iwaanoŋ kema aitoŋgowu.’ ");
INSERT INTO ksr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Qa ii moma emba saraŋ ten ii kuuyanoŋ waama kiwagia meŋ meagoŋ ootirigi. ");
INSERT INTO ksr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ootirigi nekoŋa yoŋonoŋ emba momokootogiawo yoŋoonoŋ kaŋ kokaeŋ jegi, ‘Nonoonoŋ kiwa bogojiwaajoŋ oŋonoŋ mono koinsare kelega tosia nonombu.’ ");
INSERT INTO ksr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Kaeŋ jegi momakootogiawo yoŋonoŋ meleema kokaeŋ jegi, ‘Qaago! Ii oŋo ano nono mende sokoma nonombaa. Kawaajoŋ mono sii mirinoŋ kema oŋoaŋgiaa koinsare kelegia sewaŋa mewu.’ ");
INSERT INTO ksr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Kaeŋ jegito, yoŋonoŋ koinsare kelega sewaŋa mewombaajoŋ kema kananoŋ laligogi eja buŋanoŋ mono iikanondeeŋ kouro. Emba saraŋ jojoriŋ naŋgiti, iyoŋonoŋ kema iwo aitoŋgoŋ maraŋ lombaŋ miri uutanoŋ ugi nagu koŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Emba saraŋ stuanoŋ keŋgiti, iyoŋonoŋ kaaŋagadeeŋ kanageŋ kouma nagu qeŋ kokaeŋ qagi, ‘Poŋ Poŋ, mono nagu metaama nonomba!’ ");
INSERT INTO ksr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Kaeŋ qagito, kokaeŋ meleema jero, ‘Qaago! Nii oŋo mende moma oŋonjeŋ. Qaa ii hoŋaga iŋijojeŋ.’ ");
INSERT INTO ksr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jiisasnoŋ sareqaa kaeŋ jeŋ gowokouruta ii qaa kokaeŋ iŋijoro, “Oŋo nii kamambaa kambaŋa me auaya mende mojutiwaajoŋ mono uugbiligbili laligowu.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Mono sareqaa kokawaa so koloowaa: Eja moŋ gomaŋa mesaoŋ koriganoŋ kantri moŋgeŋ kemambaajoŋ moma weleŋqeqeuruta oŋoono kagi moneŋ esuhinaya galeŋ koma oŋombutiwaajoŋ jeŋ kotoŋ oŋoma borogianoŋ ano. ");
INSERT INTO ksr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Gawoŋ memegia gosiŋ hoŋa dawi koloowaatiwaa so moma gawoŋ meme eja mombaajoŋ moneŋ esu 5 (Kina 20,000) muŋ moŋ moneŋ esu woi (Kina 8,000) muŋ moŋ motooŋgo (Kina 4,000) muro. Kaeŋ galeŋ kombutiwaajoŋ mendeema oŋoma oŋomesaoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Eja esu 5 (Kina 20,000) meroti, iinoŋ iikanondeeŋ kema koŋkororo gawoŋ mero moneŋ seiro esu 5 mombo mero. ");
INSERT INTO ksr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kaaŋiadeeŋ esu woi (Kina 8,000) meroti, iinoŋ kema koŋkororo gawoŋ mero moneŋ seiro esu woi mombo mero. ");
INSERT INTO ksr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","“Kaeŋ merito, eja moneŋ esu motooŋgo (Kina 4,000) meroti, iinoŋ mono mesaoŋ kema baloŋ osoŋ eja poŋaa moneŋa roŋ koma mesaŋgoro. ");
INSERT INTO ksr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kambaŋ koriga tegoro weleŋqeqe yoŋoo eja poŋgianoŋ eleema kaŋ ‘Gawoŋ megitiwaa sundugia moma gosimaŋa,’ jeŋ koma horoŋ oŋono kagi. ");
INSERT INTO ksr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","“Kaeŋ kagi eja esu 5 (Kina 20,000) meroti, iinoŋ jaayanoŋ kouma esu 5 mombo toroqeŋ meŋ kaŋ kokaeŋ ijoro, ‘Somatana moba, giinoŋ moneŋ esu 5 nonati, niinoŋ iikawaa koŋkororoya mewe seiro esu 5 mombo kolooro meŋ kajeŋ.’ ");
INSERT INTO ksr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Kaeŋ ijoro eja poŋanoŋ kokaeŋ meleema muro, ‘Ii awaa. Gii gawoŋ meme eja awaga membiri-qembiriga qaa. Gii iwoi afaaŋa meŋ ii kaparaŋ koma galeŋ koma laligona seiro. Kawaajoŋ niinoŋ iwoi mamaga goo boroganoŋ ambe iikawaa galeŋaga laligowa. Saanoŋ kaŋ eja poŋga noo miri uutanoŋ kouma motooŋ korisoro ama laligowoŋa.’ ");
INSERT INTO ksr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Eja Kina esu woi (Kina 8,000) meroti, iinoŋ kaaŋiadeeŋ kouma kokaeŋ ijoro, ‘Somatana moba, giinoŋ moneŋ esu woi nonati, niinoŋ iikawaa koŋkororoya mewe seiro esu woi mombo kolooro meŋ kajeŋ.’ ");
INSERT INTO ksr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Kaeŋ ijoro eja poŋanoŋ kokaeŋ meleema muro, ‘Ii awaa. Gii gawoŋ meme eja awaga membiri-qembiriga qaa. Gii iwoi afaaŋa meŋ ii kaparaŋ koma galeŋ koma laligona seiro. Kawaajoŋ niinoŋ iwoi mamaga goo boroganoŋ ambe iikawaa galeŋaga laligowa. Saanoŋ kaŋ eja poŋga noo miri uutanoŋ kouma motooŋ korisoro ama laligowoŋa.’ ");
INSERT INTO ksr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Kawaa gematanoŋ eja moneŋ esu motooŋgo (Kina 4,000) meroti, iinoŋ kouma kokaeŋ ijoro, ‘Somatana moba, niinoŋ kaniaga kokaeŋ moma yagowe: Eja Poŋnanoŋ mono eja kotakota geriawo kolooja. Geeŋgo nene kota mende qosoma kororoona iikanoŋ mono kileŋ hoŋa soonoŋ kotoŋ memambaajoŋ momakejaŋ. Dumuŋ kota mende osona kemero iikanoŋ mono kileŋ hoŋa meŋ kululuumambaajoŋ momakejaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","“Kaeŋ moma yagoŋ keena moma kema goo moneŋ esuga ii namonoŋ mesaŋgowe ero. Iiba, moneŋ esu nonati, iikayadeeŋ mono tororo koi.’ ");
INSERT INTO ksr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Kaeŋ ijoŋ ii muroto, eja poŋanoŋ meleema kokaeŋ jeŋ muro, ‘Gii injarere kolooŋ weleŋqeqe bologa koloojaŋ! Gii kaniana moma yagona: Neeno nene kota mende qosoma kororoowe iikanoŋ mono kileŋ hoŋa soonoŋ kotoŋ memambaajoŋ momakejeŋ. Neeno dumuŋ kota mende osowe kemero iikanoŋ kileŋ hoŋa meŋ kululuumambaajoŋ momakejeŋ. Noo tanina kaaŋa moma yagoŋgo mono naambaajoŋ ama sooŋ laligona? ");
INSERT INTO ksr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","“Gii noonoŋ moneŋ ii benknoŋ ana sokonaga. Benknoŋ ana somariiro eleema kaweti, kambaŋ kokanoŋ ii saanoŋ susuyawo mewenaga.’ ");
INSERT INTO ksr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Toroqeŋ tosaaŋa ii iŋijoro, ‘Oŋo mono qezeŋ injarere eja kokawaa moneŋ esuya ii wama moŋ esu 10 mokolooroti, mono ii mubu.’ ");
INSERT INTO ksr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Sareqaa kokawaa kania ii kokaeŋ: Daeŋ yoŋoonoŋ iwoi eji, kuuya iyoŋoojoŋ mono toroqeŋ oŋoŋgi seiro kelemaleleŋ eŋ oŋombaa. Kaeŋ seiwaato, mombaanoŋ iwoi moŋ mende eji, iwaanoŋ iwoi ii mono kaaŋagadeeŋ waŋgi eeŋ toontooŋ laligowaa. ");
INSERT INTO ksr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ayo, weleŋqeqe eja omaya gawoŋaa hoŋa qaa ii mono seleeŋgeŋ hagogi paŋgamanoŋ kemeba. Iikanoŋ kemeŋ saama gigilaaŋ gubugia kigi qaro laligowuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Siwe gomambaa Eja hoŋanoŋ nama Siwe gajoba kuuya uŋuama motooŋ kawuti, kambaŋ iikanoŋ Siwewaa asamararaŋanoŋ asugiro iinoŋ Kiŋ Pombaa jiŋkaroŋ duŋnoŋ rabaa. ");
INSERT INTO ksr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Rama jero namowaa ejemba tuuŋ kuuya meŋ kululuuŋ oŋoŋgi iwaa jaanoŋ asugiwuya. Asugigi lama galeŋanoŋ lamauruta meme (noniŋ) yoŋoonoŋga gosiŋ mendeema oŋonji, iikawaa so ii mendeŋqendeeŋ ama oŋombaa. ");
INSERT INTO ksr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ii ama oŋoma jero lama ii boro dindiŋanoŋ ano meme (noniŋ) ii qanianoŋ ama oŋombuya. ");
INSERT INTO ksr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Kaeŋ ama oŋoŋgi Kiŋ Poŋnoŋ boro dindiŋanoŋ nambuti, ii kokaeŋ iŋijowaa, ‘Noo Amananoŋ kotuegoŋ oŋono laligogiti, oŋo mono kawu. Ama Anutunananoŋ gomaŋ kuuya mokolooŋ oŋonoti, kambaŋ iikanondeeŋ mono bentotoŋ oŋoojoŋ mozozoŋgoŋ merota jojoriŋ eŋ kouji, oŋo mono kaŋ ii buŋa qeŋ aoŋ laligowu. ");
INSERT INTO ksr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","“Ii kokaembaajoŋ jejeŋ: Niinoŋ nembanenenaa komuŋ laligowe oŋo neneya noma laligogi. Niinoŋ apuwaajoŋ qenjeŋ qeŋ laligowe oŋo apu noma laligogi. Niinoŋ waba kolooŋ laligowe oŋo koma horoŋ noŋgi mirigianoŋ uma laligowe. ");
INSERT INTO ksr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Niinoŋ sele esunaajoŋ amamaaŋ laligowe oŋo opo kereŋ noma laligogi. Niinoŋ ji niro laligowe oŋo galeŋ koma noma laligogi. Niinoŋ kapuare mirinoŋ laligowe oŋo nii niibombaajoŋ iikanoŋ kaŋ laligogi.’ ");
INSERT INTO ksr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Kaeŋ iŋijoro ejemba solaŋa yoŋonoŋ kokaeŋ meleema muŋ jewuya, ‘Poŋ, gii mono naa kambanoŋ nembanenegaajoŋ komuna giima guagiŋ laligoniŋ? Mono naa kambanoŋ apuwaajoŋ qenjeŋ qeŋ laligona giima apu goma laligoniŋ? ");
INSERT INTO ksr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Mono naa kambanoŋ wabaga laligona giima koma horoŋ goniŋ mirinananoŋ una laligoniŋ? Mono naa kambanoŋ sele esugaajoŋ amamaaŋ laligona giima opo kereŋ goma laligoniŋ? ");
INSERT INTO ksr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","“Mono naa kambanoŋ ji giro ena giima me kapuare mirinoŋ laligona moma gii giibombaajoŋ goonoŋ kaŋ laligoniŋ?’ ");
INSERT INTO ksr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kaeŋ jegi Kiŋ Poŋnoŋ meleema kokaeŋ iŋijowaa, ‘Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Oŋo neenaa uumeleeŋ alauruna kamaaŋqeqeta koi yoŋoonoŋga mombaajoŋ iwoi moŋ aŋgiti, ii kuuya mono nii ama noma laligogi.’ ");
INSERT INTO ksr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Kaeŋ jeŋ kawaa gematanoŋ boro qanianoŋ nambuti, iyoŋoonoŋ meleema kokaeŋ iŋijowaa, ‘Maŋnanoŋ qasuaaŋ oŋono laligogiti, oŋo mono nomesaoŋ togowu. Gere sia tetegoya qaa jeŋ ubaati, mono iikanoŋ kema kemebu. Anutunoŋ ii Kileŋaa Toya ano iwaa gajobauruta yoŋoojoŋ mozozoŋgoŋ merota jojoriŋ eŋ kouja. ");
INSERT INTO ksr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ii kokaembaajoŋ iŋijojeŋ: Niinoŋ nembanenenaa komuŋ laligowe oŋo neneya mende noma laligogi. Niinoŋ apuwaajoŋ qenjeŋ qeŋ laligowe oŋo apu mende noma laligogi. ");
INSERT INTO ksr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","“Niinoŋ waba kolooŋ laligowe oŋo mende koma horoŋ noŋgi mirigianoŋ mende uma laligowe. Niinoŋ sele esunaajoŋ amamaaŋ laligowe oŋo opo kereŋ mende noma laligogi. Niinoŋ ji niro ewe ano kapuare mirinoŋ laligoweto, oŋo nii niibombaajoŋ iikanoŋ mende kaŋ laligogi.’ ");
INSERT INTO ksr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Kaeŋ iŋijoro yoŋonoŋ kaaŋagadeeŋ meleema muŋ kokaeŋ jewuya, ‘Poŋ, gii mono naa kambanoŋ nembanenegaajoŋ komuna me apuwaajoŋ qenjeŋ qeŋ laligona me wabaga laligona me sele esugaajoŋ amamaaŋ laligona me ji giro ena me kapuare mirinoŋ laligona nono gii mende weleŋ qeŋ goma laligoniŋ?’ ");
INSERT INTO ksr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Kaeŋ jegi meleema kokaeŋ iŋijowaa, ‘Niinoŋ qaa hoŋa kokaeŋ iŋijowe mobu: Oŋo uumeleeŋ alauruna kamaaŋqeqeta koi yoŋoonoŋga mombaajoŋ iwoi moŋ mende aŋgiti, ii kuuya mono nii mende ama noma laligogi kolooja.’ ");
INSERT INTO ksr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Kaeŋ iŋijoro iroŋa meleema oŋono qagianoŋ uro hagoŋ oŋono kemeŋ siimbobolo kambaŋ tetegoya qaa moma laligoŋ ubuya. Kaeŋ laligoŋ ubuyato, solaŋa yoŋonoŋ oyaŋboyaŋ laaligo ii kambaŋ tetegoya qaa laligoŋ uma laligowuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jiisasnoŋ qaa kuuya ii jedaboroŋ gowokouruta kokaeŋ iŋijoro, ");
INSERT INTO ksr_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Weeŋ woi tegorogo pasowa kendoŋa kaŋ kuuwaa. Oŋo ii saanoŋ moju. Kaŋ kuuro Siwe gomambaa Eja hoŋa ii waba gawman yoŋoo borogianoŋ aŋgi maripoonoŋ qegi komuwaa.” ");
INSERT INTO ksr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kambaŋ kanoŋ jigo gawoŋ galeŋ ano kantriwaa jotamemeya yoŋonoŋ ajorooŋ jigo gawoŋ galeŋ waŋa qata Kaiafas iwaa jiŋkaroŋ mirianoŋ ragi. ");
INSERT INTO ksr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kanoŋ rama nomaeŋ mondoniŋ Jiisas oloŋ meŋ qegi komunagati, iikawaa kania moŋgama gosigi. ");
INSERT INTO ksr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Moŋgama gosiŋ kokaeŋ jegi, “Ejemba iriŋgia soono kareŋa kareŋa aowubotiwaajoŋ ii korisoro kendoŋ kambaŋanoŋ ambombaajoŋ amamaawoŋa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jiisasnoŋ Betani gomanoŋ laligoŋ Saimon moŋ manimbaya meŋ solaŋaniroti, iwaa mirinoŋ uma raro. ");
INSERT INTO ksr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Iikanoŋ nene neŋ raro emba moŋnoŋ jamo kaaro moŋ meŋ iwaanoŋ karo. Kaaro ii lalu laŋgoŋawo qata alabasta iikanoŋ memetaga. Ii apu uuŋkoowagawo iikanoŋ saa qeqetaga. Iinoŋ ii sewaŋa somatanoŋ meŋ kaŋ apuya Jiisaswaa waŋanoŋ qibibiriŋ moriro. ");
INSERT INTO ksr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Moriro gowokourutanoŋ ii iima uugia boliro kokaeŋ jegi, “Ii mono naambaajoŋ kaeŋ tiwilaaja? ");
INSERT INTO ksr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Apu kelegawo ii sewaŋa mewutiwaajoŋ ano moneŋ uuta kolooro ii ejemba wanaya oŋono sokonaga.” ");
INSERT INTO ksr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jiisasnoŋ uumomogia ii iima kotoŋ kokaeŋ iŋijoro, “Emba kokawaa uuta ii mono naambaajoŋ meŋ boliju? Iinoŋ sili awaa ama sororogoŋ nono sokonja. ");
INSERT INTO ksr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ejemba wanaya ii kambaŋa kambaŋa batugianoŋ laligowuto, niinoŋ oŋoo batugianoŋ kambaŋ so mende laligomaŋa. ");
INSERT INTO ksr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Niinoŋ komuwe roŋ koma nombutiwaajoŋ ama kelenoŋ selena nomorija. ");
INSERT INTO ksr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Oligaa Buŋa koi kantri kanoŋ me kanoŋ jeŋ seigi kembaati, iikanoŋ emba koi kanoŋ iwoi ama nonji, iikawaa bujuya kaaŋgadeeŋ jegi seiro iwaajoŋ romoŋgoŋ laligowuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kambaŋ kanoŋ gowokouruta 12 yoŋoonoŋga moŋ qata Juudas Iskariot iinoŋ jigo gawoŋ galeŋ yoŋoonoŋ kema ");
INSERT INTO ksr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","kokaeŋ qisiŋ oŋono, “Niinoŋ Jiisas memelolo meŋ muŋ borogianoŋ ambe oŋonoŋ naa tawaga nombuya?” Qisiŋ oŋono silwa moneŋ kota 30 weeŋgoŋ borianoŋ aŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Aua iikanondeeŋ kanaiŋ Jiisas kambaŋ moŋgeŋ memelolo meŋ mumambaa kana moma moŋgama kokobimbiŋ koma laligoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bered yiistya qaa iikawaa kendoŋ weeŋ mutuyanoŋ (Sikunenenoŋ) gowoko woi yoronoŋ Jiisaswaanoŋ kaŋ kokaeŋ qisiŋ muri, “Boi, nono miri dakanoŋ kema pasowa lama mozozoŋgoŋ goni newaga? Aiŋga nomaeŋ eja?” ");
INSERT INTO ksr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Qisiŋ muri kokaeŋ meleeno, “Oro Jerusalem sitinoŋ uma eja moŋ mojeŋi, ii mokolooŋ kokaeŋ ijowao, ‘Boinoŋ jeja: Noo kambananoŋ mono dodowija. Niinoŋ goo mirinoŋ kaŋ gowokouruna yoŋowo Pasowa lama newoŋa.” ’ ");
INSERT INTO ksr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Gowoko yoronoŋ Jiisasnoŋ jeŋ kotoŋ oronoti, iikawaa so otaaŋ Pasowa lama mozozoŋgori. ");
INSERT INTO ksr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mare kolooro gomaŋ tiiro Jiisasnoŋ gowokouruta 12 yoŋowo miri iikanoŋ kouma uma duŋ kosianoŋ rama nene mendeema negi. ");
INSERT INTO ksr_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nene neŋ neŋ rama Jiisasnoŋ kokaeŋ iŋijoro, “Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Oŋoonoŋga moŋnoŋ mono memelolo meŋ nombaa.” ");
INSERT INTO ksr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kaeŋ iŋijoro moma iikanondeeŋ uugianoŋ wosobiri somata kolooro kanaiŋ aŋa aŋa qisiŋ muŋ ijogi, “Poŋ, mono noojoŋa jewabo?” ");
INSERT INTO ksr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Qisiŋ mugi kokaeŋ meleeno, “Niwo bered qaaŋnoŋ qenduŋgoji, mono iinoŋ. ");
INSERT INTO ksr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Siwe gomambaa Eja hoŋanoŋ mono iwaajoŋ qaa oogita ejiwaa so oŋanoŋ namo mesaoŋ kembaato, moŋnoŋ ii memelolo meŋ mubaati, iwaajoŋ mono ‘Yei!’ jeŋ qama wanjinjiŋgojeŋ. Iikawaa iroŋa kanjaŋawonoŋ mono iwaa qaganoŋ ubaa. Eja ii nemuŋ koro uutanoŋga mende asuginagati, iikanoŋ mono afaaŋgoŋ munaga.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kaeŋ meleeno Juudas memelolo meŋ mubaati, iinoŋ kokaeŋ meleema ijoro, “Boi, ii mono noojoŋa jewabo?” Jiisasnoŋ kokaeŋ ijoro, “Jejaŋi, mono kiaŋ!” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nene neŋ rama Jiisasnoŋ bered meŋ kotuegoŋ motoŋ oŋoma kokaeŋ iŋijoro, “Koi neenaa busuna. Ii mono meŋ newu.” ");
INSERT INTO ksr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kaeŋ iŋijoŋ wain qambi meŋ qama kooliŋ daŋgiseŋ jeŋ oŋoma kokaeŋ iŋijoro, “Oŋo kuuya mono qambi kokanoŋa newu. ");
INSERT INTO ksr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Koi neenaa sana. Ii Anutunoŋ ejemba yoŋowo soomoŋgo areŋ ano kotiiwaatiwaajoŋ sana molaagi kemero ejemba mamaga yoŋoo siŋgisoŋgogia mesaowaa. ");
INSERT INTO ksr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Niinoŋ qaa moŋ kokaeŋ iŋijowe mobu: Niinoŋ wain kasawaa hoŋa koi mombo toroqeŋ mende nemaŋa. Kanageŋ Maŋnaa bentotoŋ uutanoŋ eu raniŋ jejelombaŋ ambaati, weeŋ iikanoŋ mono wain apu qaita moŋ ii oŋowo nemaŋa.” ");
INSERT INTO ksr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kaeŋ iŋijoŋ korisoro rii qama mesaoŋ kema Oil gere baaŋanoŋ ugi. ");
INSERT INTO ksr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Uma Jiisasnoŋ kokaeŋ iŋijoro, “Gejatootoo eja moŋnoŋ qaa moŋ kokaeŋ oorota eja, ‘Niinoŋ galeŋgia qewe lama tuuŋanoŋ deembuya.’ Iikawaa so oŋonoŋ kuuya kete gomantiiŋanoŋ uugia noojoŋ ama boliro nomesaoŋ boratiwuya. ");
INSERT INTO ksr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Boratigi nuwuyato, niinoŋ mono koomunoŋga waama waladeeŋ Galili prowinsnoŋ kema iikanoŋ asugiŋ oŋomaŋa ");
INSERT INTO ksr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kaeŋ iŋijoro Piitonoŋ meleema kokaeŋ jero, “Yoŋonoŋ kuuya uugia goojoŋ ama boliro gomesaoŋ boratiwuti eeŋ, niinoŋ mono kileŋ kambaŋ moŋnoŋ mende gomesaomaŋa.” ");
INSERT INTO ksr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jero Jiisasnoŋ ijoro, “Niinoŋ qaa hoŋa moŋ kokaeŋ gijomaŋa: Kurunoŋ mende qaro giinoŋ kete gomantiiŋanoŋ qakooma nona indiŋ karooŋ koloowaa.” ");
INSERT INTO ksr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Kaeŋ jeroto, Piitonoŋ kokaeŋ ijoro, “Boi, kaeŋ qaagoto, nii nugi giwo motooŋ komuworagati, ii kileŋ niinoŋ gii mende qakooma gomaŋa.” Gowoko tosaaŋa kuuya kaaŋagadeeŋ qaa iikayadeeŋ jegi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kaeŋ amiŋ moma kema yoŋowo urukisi moŋ qata Gezemane iikanoŋ keugi. Keuma Jiisasnoŋ gowokouruta kokaeŋ iŋijoro, “Niinoŋ endu kema qama kooliwe oŋo mono kambaŋ biiwianoŋ koi rabu.” ");
INSERT INTO ksr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kaeŋ iŋijoŋ Piito ano Zebediwaa merawoita woi uruama keŋgi Jiisasnoŋ kanaiŋ wosobiri moma konjiliŋ kolooro kana boria qetegoro. ");
INSERT INTO ksr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kambaŋ kanoŋ kokaeŋ iŋijoro, “Noo uunanoŋ mono konduŋkonduŋ koma koujiwaajoŋ ama wosobiri mobe koomuya ama nonja. Oŋo mono kokanoŋ rama niwo gbili laligowoŋa.” ");
INSERT INTO ksr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kaeŋ iŋijoŋ yaŋodeeŋ boroŋa moŋ toroqeŋ kema simiŋ kuma usugoŋ kokaeŋ qama kooliŋ jero, “Amana, gii iwoi moŋ mende mololombijaŋ. Kawaajoŋ siiŋga eji eeŋ, siimbobolowaa qambia koi kanoŋ mono noo qananoŋ ubabotiwaajoŋ nuamba. Nuambaa me qaagoti, ii mono geeŋgaa uusiiŋgaa so koloowa. Ii noo siimbaa so qaago!” ");
INSERT INTO ksr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kaeŋ jeŋ eleeno gowokouruta karooŋ yoŋonoŋ gaoŋ egi iŋiima Piito kokaeŋ ijoro, “Oŋo aua motooŋgoda niwo gbili laligowombaajoŋ mende kotiiju me? ");
INSERT INTO ksr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Uunananoŋ gbili laligowombaa siiŋa momakejonto, selenananoŋ loolooria kolooja. Kawaajoŋ aŋgobatonoŋ kamaaŋ uŋuwabotiwaajoŋ mono qama kooliŋ gbiligbili laligowu.” ");
INSERT INTO ksr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kaeŋ ijoro mombo oŋomesaoŋ kema indiŋ woi kolooro kokaeŋ qama kooliŋ jero, “Amana, siimbobolowaa qambi koi kanoŋ mende nuuguwaati eeŋ, ii saanoŋ nemaŋato, ii mono geeŋgaa uusiiŋgaa so koloowa.” ");
INSERT INTO ksr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Qama kooliŋ eleeno jaa lologia bomboŋ merotiwaajoŋ mombo gaoŋgadeeŋ egi iŋiiro. ");
INSERT INTO ksr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Mombo oŋomesaoŋ leegeŋ kema qaa iikayadeeŋ mombo jeŋ qama kooliro indiŋ karooŋ kolooro. ");
INSERT INTO ksr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Gowoko yoŋoonoŋ eleema kaŋ kokaeŋ iŋijoro, “Oŋo toroqeŋ haamo meŋ gaoŋgadeeŋ ewombaajoŋ moju me? Mobu! Moŋnoŋ Siwe gomambaa Eja hoŋa memelolo meŋ muro gawman eja sisiwerowerogiawo yoŋoo borogianoŋ ubaa. Iikawaa aua kambaŋanoŋ mono kaŋ kuuja. ");
INSERT INTO ksr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mono waagi kemboŋa! Memelolo meŋ nombaati, iinoŋ mono kosere koi kaja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jiisasnoŋ kaeŋ jeŋ nano iikanoŋ gowokouruta 12 yoŋoonoŋga moŋ qata Juudas iinoŋ tuuŋ somata moŋ jeta meŋ oŋono kougi. Jigo gawoŋ galeŋ ano kantriwaa jotamemeya yoŋonoŋ ii wasiŋ oŋoŋgi manjawaa soo somata ano wasagia meŋ kagi. ");
INSERT INTO ksr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Memelolo memambaajoŋ anoti, iinoŋ waladeeŋ yoŋowo aiwese qaa kokaeŋ somoŋgoŋ iŋijoro, “Niinoŋ eja buuta kitoŋ nemaŋati, iinoŋ mono ii kolooja. Mono ii meŋ somoŋgowu.” ");
INSERT INTO ksr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kaeŋ iŋijoŋ kaŋ iikanondeeŋ Jiisaswaanoŋ keuma “Kokona (Boi), uubonjoŋ!” jeŋ buuta kitoŋ nero. ");
INSERT INTO ksr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kitoŋ nero Jiisasnoŋ kokaeŋ ijoro, “Alana, gii naambaajoŋ kajaŋi, ii mono uulaŋawo amba.” Kaeŋ ijoro eja tuuŋ yoŋonoŋ Jiisaswaanoŋ kouma qelanjiŋ meŋ somoŋgogi. ");
INSERT INTO ksr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Somoŋgogi Jiisaswo laligogiti, iyoŋoonoŋga moŋnoŋ borianoŋ manjawaa soo somata horoŋ jigo gawoŋ galeŋ waŋaa weleŋqeqeya qeŋ gejia kotogoro kamaaro. ");
INSERT INTO ksr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jiisasnoŋ ii iima kokaeŋ ijoro, “Mono mesaowa! Manjawaa soo somata taaŋgeŋ mewuti, ii mono kuuya manjawaa soo somatanoŋ uŋuro komuwuya. Kawaajoŋ mono sooga kopiŋanoŋ qena kemeba! ");
INSERT INTO ksr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Niinoŋ Amana qama kooliwe saanoŋ ilaaŋ nombaati, ii mojaŋ me qaago? Qama kooliŋ mubenagati, iinoŋ mono iikanondeeŋ gajoba manjaqeqe tuuŋ 12 uuguŋ wasiŋ oŋono kaŋ ilaaŋ nombuyaga. ");
INSERT INTO ksr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ilaaŋ nombuyagati eeŋ, Buŋa Terewaa qaayanoŋ mono nomaeŋ hoŋawo koloonaga? Buŋa Tere qaawaa so iwoi koi kanoŋ mono asugiwaa jejetaga kolooja.” ");
INSERT INTO ksr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kambaŋ iikanondeeŋ Jiisasnoŋ manjaqeqe tuuŋ ii kokaeŋ iŋijoro, “Nii kikekakasililiŋ ejaga qaagoto, kileŋ noojoŋ kaeŋ moma manjawaa soo somata ano wasa meŋ noma somoŋgowombaajoŋ kouju. Niinoŋ weeŋ so jiwowoŋ jigonoŋ oŋowo rama nama Buŋa qaa kuma oŋoma laligowe mende noŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kaento, iwoi kuuya koi mono gejatootoo ejembanoŋ qaa oogiti, iikanoŋ hoŋawo koloowaatiwaajoŋ asugija.” Jiisas somoŋgogi gowoko yoŋonoŋ kuuya Jiisas mesaoŋ boratiŋ umburatiŋ keŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Manjaqeqe eja Jiisas meŋ somoŋgogiti, iyoŋonoŋ ii wama jigo gawoŋ galeŋ waŋa qata Kaiafas iwaa mirinoŋ keŋgi. Keŋgi Kana qaawaa boi ano kantriwaa jotamemeya yoŋonoŋ iikanoŋ kaŋ ajoroogi. ");
INSERT INTO ksr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Keŋgi Piitonoŋ sigeŋsigeŋ oŋotaaŋ iikanoŋ keuma jiŋkaroŋ miriwaa kiropo uutanoŋ uro. Uma tetegoyanoŋ nomaeŋ koloowaati, ii iimambaajoŋ weleŋqeqe eja yoŋoo batugianoŋ raro. ");
INSERT INTO ksr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kaeŋ raroto, jigo gawoŋ galeŋ ano jigo kaunsol tuuŋ yoŋonoŋ Jiisaswaa selenoŋ kuukuu qaa nomaeŋ mondoŋ naŋgoŋ jeniŋ qegi komuwaatiwaajoŋ moŋgaŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Moŋgama nama mamaganoŋ waama nama qaa qoloŋmoloŋgoya Jiisaswaa selianoŋ kuuŋ naŋgoŋ jegito, kileŋ kania moŋ mende mokoloogi. Mende mokoloogito, tetegoyanoŋ eja woi kouma ");
INSERT INTO ksr_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","kokaeŋ jeri, “Eja koi kanoŋ mono kokaeŋ jero mori, ‘Nii saanoŋ Anutuwaa jiwowoŋ jigoya kondeembe namonoŋ kamaaro weeŋ karoombaa uutanoŋ ii mombo metaama kuumaŋa.” ’ ");
INSERT INTO ksr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kaeŋ jeri jigo gawoŋ galeŋ waŋanoŋ waama Jiisas qisiŋ muŋ kokaeŋ ijoro, “Yoŋonoŋ goo seleganoŋ qaa kuuŋ naŋgojuti, iikawaa kitia moŋ jewaga me qaago?” ");
INSERT INTO ksr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Qisiŋ muro Jiisasnoŋ iwoi bologa moŋ mende anoto, kileŋ qaaya bogoro nano. Qaaya bogoro nano jigo gawoŋ galeŋ waŋa iinoŋ kokaeŋ ijoro, “Niinoŋ Anutu laaligo Toyaa qatanoŋ kokaeŋ qisiŋ kuuŋ gonjeŋ: Gii Anutuwaa Meria Kraist koloojaŋ me qaago, ii tororo jeŋ jojopaŋ qaanoŋ jeŋ kotiina moboŋa.” ");
INSERT INTO ksr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Kaeŋ ijoro kokaeŋ jero, “Jejaŋi, mono ii. Iito, niinoŋ kuuya oŋo kokaeŋ iŋijowe mobu: Kambaŋ kokaambadeeŋ kanaiŋ Siwe gomambaa Eja hoŋanoŋ mono ku-usuŋ Toyaa boro dindiŋanoŋ rama kanageŋ sombimbaa koosu qaganoŋ kamaaro iibuya.” ");
INSERT INTO ksr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Qaa ii jero jigo gawoŋ galeŋ waŋa iinoŋ malekuya menjurama kokaeŋ jero, “Yei, maŋgaa siita! Mono Anutu mepaegoja. Tosianoŋ qaaya naŋgowutiwaajoŋ mombo mende qisiŋ oŋomboŋa. Anutu mepaegoji, ii keteda koi oŋoaŋgio modaboroju. ");
INSERT INTO ksr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kawaajoŋ oŋo mono nomaeŋ romoŋgoju?” Kaeŋ qisiŋ oŋono kokaeŋ jeŋ tegogi, “Iinoŋ mono koomuwaa buŋa koloowa.” ");
INSERT INTO ksr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kaeŋ jeŋ tegoŋ jaayanoŋ sulaapaŋ qeŋ moriŋ borogia kuma palapaŋanoŋ qegi. Tosianoŋ uruŋanoŋ qetaaliŋ ");
INSERT INTO ksr_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","kokaeŋ ijogi, “Gii gejatootoo eja Kraist koloojaŋiwaajoŋ moronoŋ guji, mono iwaa qata qana moboŋa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kaeŋ kolooro Piitonoŋ seleeŋgeŋ kiropo uutanoŋ sombenoŋ raro. Raro weleŋqeqe emba moŋnoŋ iwaanoŋ kaŋ kokaeŋ jero, “Gii kaaŋagadeeŋ Galili eja Jiisaswo motooŋ laligona.” ");
INSERT INTO ksr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kaeŋ jeroto, kuuya yoŋoo jaagianoŋ qakooma kokaeŋ jero, “Qaa jejaŋi, ii mono kondanjeŋ.” ");
INSERT INTO ksr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kaeŋ jeŋ kiropo naguyanoŋ kemero weleŋqeqe emba moŋnoŋ ii iima eja kosianoŋ naŋgiti, ii kokaeŋ iŋijoro, “Eja koi kanoŋ mono kaaŋagadeeŋ Nazaret eja Jiisaswo laligoro.” ");
INSERT INTO ksr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kaeŋ iŋijoro mombo qakooma jojopaŋ qaanoŋ jeŋ kotiiŋ kokaeŋ jero, “Niinoŋ eja ii mende moma mujeŋ.” ");
INSERT INTO ksr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kambaŋ boroŋa moŋ tegoro eja kosianoŋ naŋgiti, iyoŋonoŋ Piitowaanoŋ kouma kokaeŋ ijogi, “Oŋanoŋ! Giinoŋ kaaŋagadeeŋ yoŋoonoŋga moŋ koloojaŋ! Galili qaa aro jejaŋi, iikanoŋ mono kaaŋagadeeŋ ii qendeeno mojoŋ.” ");
INSERT INTO ksr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ii moma kanaiŋ aŋa qasuaaŋ aoŋ jojopaŋ qaanoŋ jeŋ kotiiŋ jero, “Nii eja ii mende moma mujeŋ! Qaa qoloŋmoloŋgoya jewenagati eeŋ, Anutunoŋ mono iroŋa meleema nomba.” Kaeŋ jero iikanondeeŋ kuru qaro. ");
INSERT INTO ksr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kurunoŋ qaro moma Jiisasnoŋ qaa kokaeŋ ijoroti, ii romoŋgoro, “Giinoŋ wala indiŋ karooŋ qakooma nona kurunoŋ qabaa.” Qaa ii romoŋgoŋ wosoya jumambaajoŋ ano seleeŋgeŋ kemeŋ meduqedu meŋ saaro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Gomaŋ ano amandiinoŋ jigo gawoŋ galeŋ kuuya ano kantriwaa jota meme (70) yoŋonoŋ ajorooŋ Jiisas qegi komuwaatiwaa qaaya amiŋ mogi. ");
INSERT INTO ksr_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Amiŋ mogi tegoro Jiisas somoŋgoŋ wama Room gawana Pailotwaa boronoŋ aŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jiisas qegi komuwaatiwaa qaaya jeŋ tegogi Juudas memelolo muroti, iinoŋ ii moma moma boliŋ aoŋ silwa moneŋ kota 30 mugiti, ii meŋ jigo gawoŋ galeŋ ano kantriwaa jotamemeya yoŋoonoŋ kema meleema oŋoma kokaeŋ iŋijoro, ");
INSERT INTO ksr_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Niinoŋ siŋgisoŋgo ama eja koposoya qaa ii memelolo meŋ mube qegi komuwaa.” Kaeŋ iŋijoroto, yoŋonoŋ kokaeŋ ijogi, “Ii nonoonoŋ iwoiga qaago! Ii mono geeŋgaa majakakaga!” ");
INSERT INTO ksr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kaeŋ ijogi moma silwa moneŋ kota ii meŋ giliro jiwowoŋ jigo uutanoŋ keno. Keno aŋa mesaoŋ kema kasanoŋ jegelaaŋ aroya mosono. ");
INSERT INTO ksr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Jigo gawoŋ galeŋ waŋa yoŋonoŋ moneŋ kota ii meŋ kokaeŋ jegi, “Moneŋ koi mono eja sayaa sewaŋaga. Kawaajoŋ ii jiwowoŋ jigowaa moneŋ kowinoŋ ambombaa soya qaago. Kaeŋ ama Mooseswaa Kana qaa uuguwombo.” ");
INSERT INTO ksr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kaeŋ jeŋ amiŋ moma moneŋ iikanoŋ gbakonoŋ monjoŋ meme eja mombaanoŋ baloŋ koria moŋ sewaŋa megi waba ejemba yoŋoo qasirigiaga kolooro. ");
INSERT INTO ksr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kawaajoŋ ama baloŋ koria iikawaa qata ii kambaŋ kokaamba kaaŋagadeeŋ toroqeŋ ‘Baloŋ koria sayawo,’ qamakeju. ");
INSERT INTO ksr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Gejatootoo eja Jeremaianoŋ qaa waladeeŋ jeroti, iikanoŋ mono hoŋawo kolooro. Qaa ii kokaeŋ, “Yoŋonoŋ Israel kanagesowaa jotamemegia kolooŋ eja ii sewaŋa mewutiwaajoŋ gosiŋ aŋgi silwa moneŋ 30 kolooroti, ii megi. Ii ejawaa sewaŋaga. ");
INSERT INTO ksr_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Yoŋonoŋ ii meŋ iikanoŋ gbakonoŋ monjoŋ meme eja mombaanoŋ baloŋ koria moŋ sewaŋa megi. Ii mono Poŋnoŋ jeŋ kotoŋ nonotiwaa so iikaaŋ megi.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kambaŋ kanoŋ Jiisasnoŋ Pailotwaa jaanoŋ nano kokaeŋ qisiŋ muro, “Oŋanoŋ, gii Juuda yoŋoo kiŋ poŋgia koloojaŋ me qaago?” Qisiŋ muro Jiisasnoŋ meleema ijoro, “Mono geeŋgo jejaŋi, iikaaŋ.” ");
INSERT INTO ksr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jigo gawoŋ galeŋ ano kantriwaa jotamemeya (70) yoŋonoŋ qaa mamaga Jiisaswaa selianoŋ kuuŋ jegito, kileŋ qaa kitia moŋ mende meleeno. ");
INSERT INTO ksr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Qaaya bogoro nano Pailotnoŋ Jiisas mombo qisiŋ muŋ ijoro, “Moba! Yoŋonoŋ qaa mamaga goo seleganoŋ kuuŋ naŋgoŋ jejuti, ii mojaŋ me qaago?” ");
INSERT INTO ksr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kaeŋ ijoroto, Jiisasnoŋ bologa moŋ mende anoto, kileŋ qaa iikawaa kitia moŋ mende meleeno. Qaaya bogoro nano gawananoŋ mamaga waliŋgoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Room gawananoŋ gbani so Pasowa korisoro kambaŋanoŋ kapuare mirinoŋga eja motooŋgo siiŋgiaa so qata qama qisigiti, ii isama oŋomakero. ");
INSERT INTO ksr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kambaŋ iikanoŋ eja moŋ qata Barabas qagiti, iinoŋ kapuare mirinoŋ raro. Ii kileŋaajoŋ meŋ biwiigi laligoro. ");
INSERT INTO ksr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kaeŋ ano ajoroogi kokaeŋ qisiŋ oŋono, “Barabas me Jiisas, qata Kraist qamakejuti, iyoroonoŋga moroga isama oŋombe kamaawaatiwaajoŋ moju?” ");
INSERT INTO ksr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Galeŋ yoŋonoŋ Jiisaswaajoŋ goroŋkiki mogitiwaajoŋ ama ii gawanawaa boronoŋ aŋgi. Ii moma siiŋgiaajoŋ kaeŋ qisiŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ii moroto, jenteegowaa jiŋkaroŋ duŋ rarayanoŋ raro embianoŋ buju qaa moŋ kokaeŋ ano karo, “Nii kete gomantiiŋanoŋ gaoŋ moŋ iima iikanoŋ eja iikawaajoŋ ama siimbobolo mamaga mojeŋ. Kawaajoŋ eja solaŋa ii mono lombo mende muba.” ");
INSERT INTO ksr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Qaa kaeŋ karoto, jigo gawoŋ galeŋ ano kantriwaa jotamemeya yoŋonoŋ ejemba tuuŋ uukuukuu meŋ oŋoma kokaeŋ iŋijogi, “Mono Barabas isama Jiisas maripoonoŋ qewutiwaajoŋ jewa. Kaeŋ qisiŋ mubu.” ");
INSERT INTO ksr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kaeŋ jegi gawananoŋ meleema qisiŋ oŋono, “Eja woi yoroonoŋga mono moroga isama mube oŋoonoŋ kamaawaatiwaajoŋ moju?” Kaeŋ qisiŋ oŋono “Barabas!” jegi. ");
INSERT INTO ksr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Kaeŋ jegi Pailotnoŋ kokaeŋ qisiŋ oŋono, “Kaeŋ jejutiwaajoŋ Jiisas, qata Kraist qamakejuti, niinoŋ ii mono nomaeŋ ama mubenaga?” Kaeŋ qisiŋ oŋono yoŋonoŋ kuuya qagi, “Mono maripoonoŋ qewu jewa!” ");
INSERT INTO ksr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kaeŋ qagi gawananoŋ jero, “Ii naambaajoŋ? Iinoŋ mono naa bologa ano?” Kaeŋ jeroto, yoŋonoŋ ii moma kaparaŋ koma toroqeŋ qa gigilaaŋ kokaeŋ qagi, “Mono maripoonoŋ qewu jewa!” ");
INSERT INTO ksr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kaeŋ qagi gejajojoŋ qegi gujubajunoŋ mombo somariiro Pailotnoŋ ii iima moma manja kareŋ koloowabotiwaajoŋ apu meŋ boria ejemba tuuŋ jaagianoŋ soŋgbama kokaeŋ iŋijoro, “Eja kokawaa saya molaagi kemebaati, iikanoŋ mono noo qananoŋ qaagoto, mono oŋoaŋgiaa qagianoŋ ubaa.” ");
INSERT INTO ksr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kaeŋ jero ejemba tuuŋ korebore yoŋonoŋ kokaeŋ meleeŋgi, “Sayaa iroŋa mono nono ano meraboraurunana nonoo qanananoŋ ubaa!” ");
INSERT INTO ksr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kaeŋ meleeŋgi Pailotnoŋ Barabas isama muro yoŋoonoŋ kamaaroto, Jiisasga jero ooli waayawonoŋ qeyayagoŋ qegi. Kaeŋ qegi maripoonoŋ qewutiwaajoŋ Room manjaqeqe eja yoŋoo borogianoŋ ano. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Borogianoŋ ano Room gawanawaa manjaqeqe eja yoŋonoŋ Jiisas wama gawanawaa jiŋkaroŋ miriwaa kiropo uutanoŋ keugi. Keuma manjaqeqe tuuŋ kuuya horoŋ oŋoŋgi kaŋ ajorooŋ Jiisas liligoŋ mugi. ");
INSERT INTO ksr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Liligoŋ muŋ iyaŋaa sele esuya kotogoŋ maleku osoga nezoŋgbala moŋ mouma mugi. ");
INSERT INTO ksr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Mouma muŋ somaŋ kasa lipima ila kaaŋa waŋanoŋ koŋgi kemero. Kemero bowo moŋ boro dindiŋanoŋ ama simiŋ kuma muŋ goŋgeegee ama muŋ kokaeŋ ijogi, “Oowe oowe! Juuda yoŋoo kiŋ poŋgia, oowe!” ");
INSERT INTO ksr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Qaqatete kaaŋa ama sulaapaŋ qeŋ moriŋ bowoya tagoŋ iikanoŋ waŋanoŋ qegi. ");
INSERT INTO ksr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mepaqepae kaaŋa ama mudaboroŋ maleku osoga nezoŋgbala ii qetegoŋ iyaŋaa sele esu mombo mouma muŋ maripoonoŋ qewombaajoŋ wama keŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kema kana somatanoŋ eja moŋ qata Saimon mokoloogi. Iinoŋ Afrika siti qata Sairini iikawaa ejiaga. Mokolooŋ kuuŋ mugi Jiisaswaanoŋ maripooŋ meŋ aŋgoro. ");
INSERT INTO ksr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Jiisas kaeŋ wama baloŋ moŋ qata Golgota ii ananaa qaanoŋ Waŋsii, iikanoŋ kema keugi. ");
INSERT INTO ksr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Keuma wain apu ano marasiŋ qata mor ii mindiriŋ melokanjiŋ meŋ newaatiwaajoŋ mugito, Jiisasnoŋ ii batogoŋ neŋ moma togoro. ");
INSERT INTO ksr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Togoro nama maripoonoŋ qegi. Qegi nano Jiisaswaa sele esuyaa kiaweŋ megi jaŋgoya kolooro iikawaa so batugianoŋ mendeema megi. ");
INSERT INTO ksr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ii meŋ rama Jiisas jaagaleŋ meŋ mugi. ");
INSERT INTO ksr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Waŋanoŋ eu qegitiwaa kania ii kokaeŋ ooŋ qegi nano, ‘Juuda yoŋoo kiŋ poŋgiaga koi.’ ");
INSERT INTO ksr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kikekakasililiŋ eja woi ii iwo maripoonoŋ urugi. Moŋ boro dindiŋanoŋ, moŋ qanianoŋ leelee kaaŋ urugi. ");
INSERT INTO ksr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ejemba uuguŋ kema kaŋ kuŋgulolopo ama lukukuuŋ muŋ wambelaaŋ kokaeŋ jegi, ");
INSERT INTO ksr_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Yei! Gii mono jiwowoŋ jigo saanoŋ kondeena balonoŋ kamaaro weeŋ karoombaa uutanoŋ mombo metaama kuumambaajoŋ jena. Oo, gii eja qabo! Gii Anutuwaa Meriaga koloojaŋi eeŋ, mono saanoŋ geeŋga ilaaŋ aoŋ maripoonoŋga kamaawa.” ");
INSERT INTO ksr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jigo gawoŋ galeŋ, Kana qaawaa boi ano kantriwaa jotamemeya yoŋonoŋ kaaŋagadeeŋ mepaqepae meŋ muŋ kokaeŋ jegi, ");
INSERT INTO ksr_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Tosiaga ilaaŋ oŋoma laligoroto, iyaŋa ilaaŋ aomambaajoŋ amamaaja. Iinoŋ Israelwaa kiŋ poŋ kolooji eeŋ, mono keteda koi maripoonoŋga kamaaro iima ii moma laariwonaga. ");
INSERT INTO ksr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Iinoŋ Anutu moma laariŋ muŋ qaqabuŋabuŋayawo laligoŋ aŋaajoŋ ‘Anutuwaa meria koloojeŋ,’ jero moniŋ. Ayo, Anutunoŋ ii kambaŋ kokaamba metogoŋ mumambaajoŋ moja me qaagoti, ii saanoŋ iiboŋa.” Kaeŋ jegi. ");
INSERT INTO ksr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kikekakasililiŋ eja iwo maripoonoŋ urugiti, iyoronoŋ kaaŋiadeeŋ uuqeqe qaa tokoroŋkota jeŋ muri. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Weeŋ biiwia 12 kilok kolooro iikanondeeŋ paŋgamanoŋ kamaaŋ baloŋ kuuya sokoma ero kema aua karoombaa so ano. ");
INSERT INTO ksr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jiisasnoŋ 3 kilok iikanoŋ aŋaa qaanoŋ kokaeŋ qa somata qaro, “Eeli, eeli, lama sabaktani?” Ii ananaa qaanoŋ: Anutuna, Anutuna, mono naambaajoŋ gema nujaŋ? ");
INSERT INTO ksr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kaeŋ qaro eja kosianoŋ naŋgiti, iyoŋoonoŋga tosianoŋ ii moma jegi, “Mono Elaijawaajoŋ qaja.” ");
INSERT INTO ksr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Iikanondeeŋ yoŋoonoŋga moŋnoŋ bobogariŋ kema momondo moŋ suuŋ kaaŋa ii meŋ wain apu aasoŋawonoŋ qenduŋgoŋ gere goroŋ kitianoŋ somoŋgoŋ suluŋ Jiisaswaa buu susuyanoŋ eu ano nero. ");
INSERT INTO ksr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Neroto, tosianoŋ jegi, “Mono mesaogi aŋodeeŋ namba. Elaijanoŋ kaŋ metogoro kamaawaa me qaagoti, mono ii iiboŋa.” ");
INSERT INTO ksr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kaeŋ aŋgi Jiisasnoŋ mombo qa somata qama sewaŋ aasoŋ konoga horoŋ komuro. ");
INSERT INTO ksr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Komuro iikanondeeŋ jiwowoŋ jigowaa uutanoŋ opo nanoti, iikanoŋ eukaya biiwianoŋ jurama kamaaŋ woi kolooro. Kaeŋ kamaaro naŋ somata mero jamo somasomata mesuno. ");
INSERT INTO ksr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Qasiriwaa jamo kobaawaa qaa oota aŋgiodeeŋ aantaŋgi ejembaya soraaya komugiti, iyoŋoonoŋga mamaganoŋ gbiliŋ waagi. ");
INSERT INTO ksr_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Waama qasiriwaa jamo kobaagia mesaoŋ Jiisasnoŋ koomunoŋga waaroti, iikawaa gematanoŋ Jerusalem siti toroya iikanoŋ kaŋ ejemba mamaga asugiŋ oŋoŋgi iŋiigi. ");
INSERT INTO ksr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kawali galeŋ ano manjaqeqe eja iwo Jiisaswaa jaagaleŋ meŋ laligogiti, iyoŋonoŋ naŋ mero iwoi tosia kuuya kolooroti, ii iima aaruŋ jeneŋgia mamaga ororo toroko ama kokaeŋ jegi, “Iinoŋ mono oŋanoŋ Anutuwaa meriaga kolooja.” ");
INSERT INTO ksr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Emba mamaganoŋ sigeŋsigeŋ nama iwoi ii kaaŋagadeeŋ iigi. Yoŋonoŋ Jiisas otaaŋ Galiliga kaŋ weleŋ qeŋ muŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Yoŋoo batugianoŋ Maria Magdalaga ano Maria Jeims ano Jooses yoroo nemuŋgara ano Zebediwaa merawoita yoroo nemuŋgara. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mare kolooro Arimatia eja qabuŋayawo moŋ qata Joosef karo. Iinoŋ kaaŋagadeeŋ Jiisaswaa gowokoya moŋ kolooro. ");
INSERT INTO ksr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Iinoŋ Pailotwaanoŋ kema Jiisaswaa qamoya memambaajoŋ qisiro. Qisiro kawali ejanoŋ ii Joosef mubutiwaajoŋ jeŋ kotoŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jeŋ kotoŋ oŋono Joosefnoŋ kema Jiisaswaa qamoya meŋ kamaaŋ opo taaŋanoŋ esuuro. ");
INSERT INTO ksr_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Esuuŋ meŋ qasirinoŋ kema aŋaa kobaa dologa jamonoŋ uroroogi nanoti, qamoya ii iikanoŋ ano. Kaeŋ ama jamo somata moŋ metano jamo kobaawaa qaa oota kojaŋgiro mesaoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdalaga ano Maria alia moŋ yoronoŋ iikanoŋ jamo kobaa jaasewaŋ qeŋ rari. ");
INSERT INTO ksr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sabat kendoŋ rarawaajoŋ iwoi mozozoŋgoŋ eŋ waama iikanoŋ jigo gawoŋ galeŋ ano Farisii (Kana qaawaa kaparaŋkoŋkoŋ) yoŋonoŋ Pailotwaanoŋ kema ajorooŋ kokaeŋ jegi, ");
INSERT INTO ksr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Somatanana, eŋkalolombaa uukuukuu eja iikanoŋ jaawo laligoroti, kambaŋ iikanoŋ kokaeŋ jero moniŋ, ‘Niinoŋ weeŋ karooŋ tegoro mombo gbiliŋ waamaŋa.’ Nononoŋ qaa ii romoŋgojoŋ. ");
INSERT INTO ksr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kawaajoŋ giinoŋ saanoŋ manjaqeqe ejauruga iŋijona qasirinoŋ kema ii tororo jaagaleŋ meŋ laligogi weeŋ karooŋ tegoro mesaowu. Kaeŋ mende galeŋ mewuyati eeŋ, gowokourutanoŋ mono kema qamoya oloŋ meŋ mesaŋgoŋ ejemba kokaeŋ iŋijowuya, ‘Jiisasnoŋ mono koomunoŋga waaro.’ Kaeŋ jegi tiliqili eŋkaloloŋ qaa konoga iikanoŋ mono eŋkaloloŋ qaa mutuya uuguro kileqileewabo.” ");
INSERT INTO ksr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Kaeŋ jegi kokaeŋ iŋijoro, “Manjaqeqe eja koi mono saanoŋ uŋuama kema kuuŋ oŋoŋgi qasiri jamo kobaawaa qaa oota ii tororo galeŋ koma sororogowu.” ");
INSERT INTO ksr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kaeŋ iŋijoro qasirinoŋ kema jamo kobaawaa qaa ootanoŋ jamo somata aŋgi kojaŋgiŋ nanoti, ii aasoya ama manjaqeqe eja kuuŋ oŋoŋgi jaagaleŋ kotakota megi. ");
INSERT INTO ksr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat kendoŋ ragi tegoro Sonda umugawodeeŋ waama gomaŋ ano Maria Magdalaga ano alia Maria moŋ yoronoŋ qasiriwaa jamo kobaa iibotiwaajoŋ keni. ");
INSERT INTO ksr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Keni iikanondeeŋ naŋ somata kokaembaajoŋa mero: Pombaa gajoba moŋnoŋ Siwenoŋga kamaaŋ qasirinoŋ kaŋ qaa ootanoŋ jamo somata qetano keno qaganoŋ raro. ");
INSERT INTO ksr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Gajobawaa kaitania ii pilisik kaaŋa kolooro malekuya ii koosu kaaŋa tualalakota kolooro. ");
INSERT INTO ksr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Kaeŋ asugiro manjaqeqe eja qasiri galeŋ megiti, iyoŋonoŋ iwaajoŋ awawaliŋ jeneŋgia ororo komuŋ torigi. ");
INSERT INTO ksr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kaeŋ aŋgi gajobanoŋ emba woi ii qaa kokaeŋ irijoro, “Jiisas maripoonoŋ qegiti, oro iwaajoŋ moŋganjaoti, ii mojeŋ. Kawaajoŋ mono toroko mende mobao. ");
INSERT INTO ksr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Aŋo jerotiwaa so mono koomunoŋga waaja. Kawaajoŋ koi mende eja. Mono kaŋ duŋ eroti, ii iibao. ");
INSERT INTO ksr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ii iima uulaŋawo gowokouruta yoŋoonoŋ kema buju qaa koi iŋijowao, Jiisasnoŋ koomunoŋga waaja. Mobu, iinoŋ mono waladeeŋ Galili prowinsnoŋ kembaa. Oŋo saanoŋ iikanoŋ kema ii iibu. Mobu, niinoŋ ii mono iŋijowe mogi.” ");
INSERT INTO ksr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kaeŋ irijoro uulaŋawodeeŋ qasiri mesaoŋ toroko moma kileŋ honombonoŋa mende aisooŋ buju ii meŋ gowokouruta iŋijowaotiwaajoŋ uulaŋawo keni. ");
INSERT INTO ksr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Uulaŋawo keni Jiisasnoŋ ii kananoŋ asugiŋ oroma “Gomaambagara!” irijoro. Kaeŋ irijoro kosianoŋ kema usugoŋ kanianoŋ meragoŋ waeya meŋ mepeseeŋ muri. ");
INSERT INTO ksr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Mepeseeŋ muri kokaeŋ irijoro, “Toroko mende mobao. Mono kema kourunanoŋ Galili kembutiwaa qaa iŋijori iikanoŋ kema nii niibuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Embawoi yoronoŋ kana keni qasiriwaa jamo kobaawaa galeŋ meme manjaqeqe eja tosianoŋ sitinoŋ kaŋ jigo gawoŋ galeŋ iŋiima iwoi kuuya kolooroti, iikawaa sunduya iŋijogi. ");
INSERT INTO ksr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Yoŋonoŋ ii moma Juuda yoŋoo jotamemeurugia horoŋ oŋoŋgi motooŋ ajoajoroo ama Jiisas waawaataa qaa mesaŋgowoŋatiwaa qaa areŋ mokolooŋ moneŋ somata totooŋ ii manjaqeqe eja oŋoŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ii oŋoma kokaeŋ jeŋ kotoŋ oŋoŋgi, “Oŋo mono qaa kokaeŋ jewu: Nono gomantiiŋanoŋ gaoŋ eniŋ gowokourutanoŋ oloŋ kaŋ qamoya yoŋgoro meŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Qaa kaeŋ jegi qaa iikanoŋ gawanawaa gejianoŋ kemero mobaati eeŋ, lombo oŋoo qagianoŋ ubabotiwaajoŋ nononoŋ mono uuta meŋ looriŋ meŋ kamaaŋ aniŋ majakakaya qaa laligowu.” ");
INSERT INTO ksr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kaeŋ jeŋ kotoŋ oŋoŋgi iikawaa so otaaŋ moneŋ meŋ kema gawoŋ qaagia otaagi. Kaeŋ aŋgi Juuda yoŋonoŋ qaa ii batugianoŋ jeŋ seigi moma laligogi kema kambaŋ kokaamba kaaŋagadeeŋ ii toroqeŋ jegi momakejoŋ. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Gowokouruta 11 yoŋonoŋ Jerusalem mesaoŋ Galili prowinsnoŋ kema Jiisasnoŋ baaŋanoŋ kawutiwaajoŋ iŋijoroti, iikanoŋ ugi. ");
INSERT INTO ksr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Iikanoŋ uma Jiisas iima waeya meŋ mepeseeŋ mugito, tosianoŋ iwaajoŋ uuwoi mogi. ");
INSERT INTO ksr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mepeseeŋ mugi yoŋoonoŋ kaŋ kokaeŋ iŋijoro, “Siwewaa ano namowaa ku-usuŋ kuuya ii Anutunoŋ nonota noonoŋ eja. ");
INSERT INTO ksr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kawaajoŋ oŋo mono gomaŋ so kema ejemba tuuŋ kuuya kokaeŋ iŋijoŋ oŋoŋgi noo gowokouruna koloowu: Ii mono Maŋ, Mera ano Uŋa Toroya nonoo qanoŋ oomulu meŋ oŋombu ");
INSERT INTO ksr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ano niinoŋ qaa otaawutiwaajoŋ jeŋ kotoŋ oŋombeti, ii kuuya teŋ kombutiwaajoŋ mono kuma oŋoma laligowu. Mobu, niinoŋ mono kambaŋa kambaŋa oŋowo laligoŋ kema laligowe namowaa kambaŋanoŋ tegowaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hamoqeqe Toya Jiisas Kraist ii Anutuwaa Meria kolooja. Niinoŋ iwaa Oligaa Buŋaya kanaiŋ oojeŋ. ");
INSERT INTO ksr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Anutunoŋ Siwe uutanoŋ meriaajoŋ qaa moŋ ijoro gejatootoo eja Aisaianoŋ ii oorota iwaa Buju Terenoŋ kokaeŋ eja, “Moba. Niinoŋ qele gajobana moŋ wasiwe waladeeŋ kema ejemba uugia mindiŋgoŋ goo kanaga meleuro giinoŋ iwaa gematanoŋ namonoŋ kemeba.” ");
INSERT INTO ksr_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Qele gajoba moŋnoŋ baloŋ qararaŋkoŋkoŋanoŋ qama laligoro kema qata kokaeŋ mobu, ‘Poŋnoŋ kawa-oo! Kawaajoŋ mono jojoriŋ kania meleuwu. Mono uugia mindiŋgoŋ kania qeleleewu.’” ");
INSERT INTO ksr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Qaa iikawaa so eja moŋ qata Jon asugiro. qata moŋ Oomulu eja. Asugiŋ baloŋ qararaŋkoŋkoŋanoŋ laligoŋ nama Buŋa qaa kokaeŋ jeŋ laligoro, “Oŋonoŋ mono uugia meleeŋgi niinoŋ oomulu meŋ oŋomaŋa. Kaeŋ aŋgi Anutunoŋ siŋgisoŋgogia soŋgbama mesaowaa.” ");
INSERT INTO ksr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kaeŋ jeŋ laligoro Judia prowinswaa gomaŋa kuuya ano Jerusalem siti yoŋonoŋ tuuŋ tuuŋ koma horoŋ Jombaanoŋ kagi. Kaŋ kouma siŋgisoŋgogia jokoloogi Jonoŋ ii Jordan apu bereŋanoŋ oomulu meŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jombaanoŋ selekopaa ii kamel juyanoŋ memeta ano batuyanoŋ iiŋkasa oro selianoŋ memeta ii somoŋgoŋ laligoro. Nembaneneya ii ŋaagiso borotaaŋ ano duuyaa moroŋ apuya, ii neŋ laligoro. Ii kuuya gejatootoo eja Elaija iwaa soga. ");
INSERT INTO ksr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jonoŋ qaa kokaeŋ jeŋ asariŋ laligoro, “Noo gemananoŋ eja ku-usuŋa kotakota moŋ kawaa. Iwaa ku-usuŋa uutanoŋ mono noonoŋ uuguwaa. Iinoŋ eja uuta koloowaatiwaajoŋ niinoŋ iwaa kana esuyaa kasia ilaaŋ isamambaajoŋ gamugamu ama amamaamaŋa. ");
INSERT INTO ksr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Niinoŋ apu tooŋnoŋ mulu meŋ oŋonjento, iinoŋ mono Uŋa Toroyanoŋ mulu meŋ oŋombaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kambaŋ kanoŋ Jiisasnoŋ Galili prowinswaa gomaŋa qata Nazaret kanoŋa Jombaanoŋ karo Jordan apu bereŋanoŋ oomulu meŋ muro. ");
INSERT INTO ksr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Meŋ muro apunoŋga kouro iikanondeeŋ Siwenoŋ aantano Jiisasnoŋ uuŋ iiro Uŋa Toroyanoŋ meleema kewo kooŋ kaaŋa kolooŋ Jiisaswaa waŋanoŋ kamaaŋ mero. ");
INSERT INTO ksr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ii iiro Siwe gomanoŋga qaa moŋ kokaeŋ kolooro, “Giinoŋ mono neenaa komunjua merana koloona kerana qeaŋgoro giimasiiŋ moma gonjeŋ.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Oomulu meŋ muro iikanondeeŋ Uŋa Toroyanoŋ Jiisas kuuŋ wasiŋ muro baloŋ qararaŋkoŋkoŋanoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kema weeŋ 40 kawaa so iikanoŋ laligoro omejiilaŋ waŋgia Satan iinoŋ aŋgobato meŋ muŋ laligoro. Oro kawalia yoŋoo batugianoŋ laligoro Siwe gajoba yoŋonoŋ ilaaŋ muŋ laligogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kanageŋ Jon kapuare mirinoŋ ooŋgi raro Jiisasnoŋ kambaŋ iikanoŋ Galili prowinsnoŋ eleema keno. Kema Anutuwaa Oligaa Buŋa jeŋ asariŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jeŋ asariŋ kokaeŋ iŋijoro, “Anutunoŋ bentotoŋa ambaatiwaa kambaŋanoŋ mono dodowija. Anutunoŋ kambaŋ ano laligoŋ kougiti, ii keteda koi kolooja. Kawaajoŋ mono uugia meleema Oligaa Buŋa moma laariwu.” ");
INSERT INTO ksr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jiisasnoŋ kaeŋ iŋijoŋ liligoŋ laligoŋ Galili apu aŋgombaa goraayanoŋ metetereeŋ kema sora hooro eja woi iriiro. Qagara Saimon, koga qata Andruu. Yoronoŋ misagara apu aŋgonoŋ sora horowowaajoŋ giliŋ laligori. ");
INSERT INTO ksr_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jiisasnoŋ iriima kokaeŋ irijoro, “Ejawoi, oro mono nii notaaŋ kari kuma orombe ejemba sora kaaŋa horoŋ oŋombao.” ");
INSERT INTO ksr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kaeŋ irijoro iikanondeeŋ misagara mesaoŋ kanaiŋ Jiisas otaaŋ keni. ");
INSERT INTO ksr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jiisasnoŋ yorowo boroŋa moŋ toroqeŋ kema Zebediwaa meria Jeims ano koga Jon iriiro. Yoronoŋ kaaŋiadeeŋ waŋgonoŋ rama misagara meagoŋ somoŋgoŋ rari. ");
INSERT INTO ksr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Rari iriima iikanoŋa oroono. Oroono maŋgara Zebedi ano moneŋ gawoŋ ejauruta waŋgonoŋ oŋomesaoŋ kanaiŋ Jiisas otaaŋ gematanoŋ keni. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kaeŋ motooŋ kema Kaperneam taonoŋ keugi Sabat kendoŋ kolooro Jiisasnoŋ iikanondeeŋ qamakooli mirigianoŋ uma Buŋa qaa kuma oŋono. ");
INSERT INTO ksr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kana qaawaa boi kaaŋa qaagoto, ku-usuŋ eŋ murotiwaa so kuma oŋoma nanamemeŋaa so ambutiwaajoŋ jero. Kawaajoŋ kanageso yoŋonoŋ ii iima aaruŋ waliŋgogi. ");
INSERT INTO ksr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Qamakooli mirigia iikanoŋ kambaŋ iikanondeeŋ eja moŋ omeyawo raro ome iikanoŋ qata kokaeŋ qaro, ");
INSERT INTO ksr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Oo Jiisas, Nazaret eja! Gii naama ama nonomambaa anjaŋe? Mono meŋ kileeŋ nonomambaajoŋ kajaŋ me? Nii kaniaga moma kotojeŋ. Gii Anutuwaanoŋ eja Tak-kootoya koloojaŋ.” ");
INSERT INTO ksr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kaeŋ qaro Jiisasnoŋ temboma kokaeŋ jeŋ muro, “Gii mono qaaga bogoro eja koi mesaoŋ togowa.” ");
INSERT INTO ksr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kaeŋ jeŋ muro omenoŋ eja ii utugoŋ orogoŋ muŋ qa bobolo qama kouma mesaoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Keno kuuyanoŋ newogia tegoro waliŋgoŋ qisiŋ aoŋ kokaeŋ jegi, “Yei, maŋgaa siita! Koi mono naa iwoiga? Koi momo dologa ku-usuŋawo. Iinoŋ omejiilaŋ kaaŋagadeeŋ jeŋ kotoŋ oŋono jeta teŋ konju.” ");
INSERT INTO ksr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kaeŋ kolooro Jiisaswaa qabuŋayanoŋ uulaŋawo seiŋ gomaŋ kosianoŋ rama keŋgiti, iikanoŋ kema kema Galili prowins kuuya sokono. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jiisasnoŋ Kaperneam oŋoonoŋ qamakooli miri mesaoŋ iikanondeeŋ Jeims Jon yorowo Saimon ano Andruu yoroo mirinoŋ ugi. ");
INSERT INTO ksr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Iikanoŋ ugi Saimombaa seuŋanoŋ selegere ji kiro ero. Ero bujuya ii uulaŋawo Jiisas ijogi. ");
INSERT INTO ksr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ijogi iwaanoŋ kema borianoŋ meŋ kobibiiro waaro. Waaro selegereya mesaoro nene ooŋ uŋuagiro. ");
INSERT INTO ksr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Uŋuagiro mare kolooro weeŋ jaaya kemero kanoŋ Kaperneam toya yoŋonoŋ nama ejembaya ejembaya ji omegiawo ii kuuya uŋuama Jiisaswaanoŋ kagi. ");
INSERT INTO ksr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kaperneam taonoŋga tuuŋlelembenoŋ kaŋ Saimombaa miri naguyanoŋ ajoroogi. ");
INSERT INTO ksr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ajoroogi nama ejemba ji kania kania iŋiroti, ii mamaga meŋ qeaŋgoŋ oŋono. Kaaŋagadeeŋ omejiilaŋ yoŋonoŋ Jiisaswaa kania mogitiwaajoŋ Jiisasnoŋ buugia muuŋguŋ mamaga oŋotaaro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jiisasnoŋ gaoŋ ero gomaŋ weŋgeraŋ suluro waama gomaŋ goraayanoŋ kema yaŋasiri tiriŋ kotoŋ iikanoŋ qama kooliro. ");
INSERT INTO ksr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Qama kooliro Saimon ano alauruta iwo laligogiti, yoŋonoŋ uulaŋawo kanianoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kema mokolooŋ kokaeŋ ijogi, “Ejemba kuuyanoŋ mono goojoŋ moŋganju.” ");
INSERT INTO ksr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kaeŋ ijogi kokaeŋ iŋijoro, “Gomaŋ tosia liligoŋ rama kenjuti, ii iiju. Niinoŋ Buŋa qaa gomaŋ so jeŋ seimaŋatiwaajoŋ kamaaŋ laligojeŋ. Kawaajoŋ mono gomaŋ liligoŋ kemboŋa.” ");
INSERT INTO ksr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kaeŋ iŋijoŋ Galili prowins kuuya liligoŋ kema qamakooli mirigianoŋ Buŋa qaa jeŋ omeya omeya ii oŋotaaŋ laligoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jiisasnoŋ taoŋ moŋnoŋ laligoro manimba eja moŋnoŋ kaŋ simiŋ kuma Jiisaswaa wosoyanoŋ kemeŋ kokaeŋ qama kooliŋ muro, “Giinoŋ siiŋganoŋ meŋ qeaŋgoŋ nomambaajoŋ mojaŋi eeŋ, mono nii saanoŋ meŋ solaŋaniŋ nomba.” ");
INSERT INTO ksr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kaeŋ qama kooliŋ muro iwaajoŋ wosoya moma boria boraama selia oosiriŋ ijoro, “Niinoŋ ii anuwaatiwaajoŋ mojeŋ. Gii mono solaŋaniwa.” ");
INSERT INTO ksr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kaeŋ ijoro manimbaya ii iikanondeeŋ solaŋaniro. ");
INSERT INTO ksr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Solaŋaniro galeŋ meme qaa kotakota muŋ iikanondeeŋ “Saanoŋ kemba,” ijoro. ");
INSERT INTO ksr_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Gejanono qaa ii kokaeŋ ijoro, “Moba. Kokawaa buju qaaya ii mono moŋ mende jena mobu. Qaagoto, mono jigo gawoŋ galembaanoŋ kema selega qendeema muba ano Mooseswaanoŋ jeŋkooto otaaŋ solaŋanijaŋiwaa mamatewooya ama siimoloŋ oowa. Ii oona iiro ejembanoŋ kaniaga moma kotowu.” ");
INSERT INTO ksr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jiisasnoŋ kaeŋ ijoroto, iinoŋ kema kileŋ kanaiŋ buju qaa ii mamaga jeŋ laligoro seiro. Seiro Jiisasnoŋ taoŋa taoŋa kanoŋ asuganoŋ mombo kemambaajoŋ amamaaro. Amamaaŋ taoŋ gemagianoŋ gomaŋ gbameŋa iikanondeeŋ laligoro. Iikanoŋ laligoro gomaŋ so iikanoŋa ejembaya ejembaya iwaanoŋ kagi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kaeŋ liligoro kambaŋ tosia tegoro Jiisasnoŋ eleema mombo gomaŋanoŋ Kaperneam karo. Karo “Mirinoŋ laligoja,” jegi mogi. ");
INSERT INTO ksr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ejemba mamaganoŋ ii moma ajorooŋ iwaa miri nagu atapaŋanoŋ eligoŋ sombeŋanoŋ saa qegi. Saa qegi Jiisasnoŋ nama Buŋa qaa iŋijoro. ");
INSERT INTO ksr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Iŋijoro iikanoŋ eja moŋ sele bakaya koomuya, ii wama iwaanoŋ kagi. Eja 4:yanoŋ ii demberunoŋ ama aŋgoŋ kagi. ");
INSERT INTO ksr_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kagi eligoŋ naŋgitiwaajoŋ ama Jiisaswaa kosianoŋ kema ambombaajoŋ amamaagi. Amamaaŋ miri qaganoŋ uma Jiisaswaa waŋanoŋga waareŋ osoŋ luluuŋgi. Luluuŋgi oota kolooro iikanoŋ ji eja ii demberuyawo kasanoŋ somoŋgoŋ aŋgi kemero. ");
INSERT INTO ksr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kaeŋ kemero Anutu moma laariŋ mugiti, Jiisasnoŋ iyoŋoo tanigia ii iiro sokono ji eja ii kokaeŋ ijoro, “Merana, niinoŋ goo siŋgisoŋgoga mesaojeŋ.” ");
INSERT INTO ksr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kaeŋ ijoro Kana qaawaa boi tosianoŋ batugianoŋ rama uugianoŋ kokaeŋ romoŋgogi, ");
INSERT INTO ksr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Eja kokanoŋ mono nomaembaajoŋ kaeŋ jeja. Mono Anutu mepaegoja. Anutu motooŋgonoŋ siŋgisoŋgonana mesaoŋkejato, eja moŋnoŋ ii qaago.” ");
INSERT INTO ksr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Uugianoŋ kaeŋ romoŋgogi Jiisasnoŋ iikanondeeŋ uutanoŋ ii moma kotoŋ kokaeŋ iŋijoro, “Oŋo mono naambaajoŋ qaa kaaŋa uugianoŋ romoŋgoju? ");
INSERT INTO ksr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Niinoŋ ‘Siŋgisoŋgoga mesaojeŋ,’ ji eja kaeŋ ijojeŋi, qaa iikanoŋ mono afaaŋagadeeŋ jejeta. Moŋnoŋ kaeŋ jero tosianoŋ qaa iikawaa hoŋa mende iibu. Kawaajoŋ ii qaa afaaŋaa so. Niinoŋ qaa moŋ kokaeŋ jemambaajoŋ mojeŋ, ‘Mono waama tambomaeega meŋ kemba.’ Qaa ii mono lombotawo jejeta kolooja. Kaeŋ jewe hoŋa koloowaa me qaagoti, iikanoŋ mono asuganoŋ asugiro iibu. ");
INSERT INTO ksr_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mobu, namonoŋ siŋgisoŋgo mesamesaowaa ku-usuŋa ii mono Siwe gomambaa Eja hoŋaanoŋ eji, oŋo iikawaa kaniaajoŋ tiŋtuaŋ laligowubo. Kawaajoŋ qaa lombotawo ii eja koi ijowe hoŋa iibu,” Kaeŋ jeŋ eja sele bakaya koomuyaa jaayanoŋ iima ijoro, “Niinoŋ gijojeŋ: Gii mono waama tambomaeega meŋ miriganoŋ kemba. Qaa biŋawo ii hoŋawo koloowaati eeŋ, qaa afaaŋa ii mono kaaŋagadeeŋ nomaembaajoŋ omaya koloonaga?” ");
INSERT INTO ksr_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Kaeŋ jeŋ eja sele bakaya koomuya kokaeŋ ijoro, “Niinoŋ gijojeŋ: Gii mono waama tambomaeega meŋ miriganoŋ kemba.” ");
INSERT INTO ksr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ijoro mono waama iikanondeeŋ tambomaeeya meŋ ejemba kuuya yoŋoo jaagianoŋ seleeŋgeŋ keno. Kaeŋ keno kuuyanoŋ waliŋgoŋ Anutu mepeseeŋ kokaeŋ jegi, “Yei, maŋgaa siita! Tani koi kaaŋa ii wala eeŋanoŋ kambaŋ moŋgeŋ mende iiniŋ. Qaago! Keteda koi jaa morotaga iijoŋ.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jiisasnoŋ mombo Kaperneam mesaoŋ aŋgonoŋ kemeŋ sakasiŋ kooroŋanoŋ kema laligoro. Laligoro ejemba tuuŋlelembenoŋ iwaanoŋ kagi Buŋa qaa kuma oŋono. ");
INSERT INTO ksr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kema takis ofis uugumambaajoŋ ano iikanoŋ eja qata Liwai Alfiuswaa meria raro iima ijoro, “Gii mono noo gemananoŋ notaaŋ kawa.” Kaeŋ ijoro waama takis gawoŋ mesaoŋ Jiisaswaa gematanoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kema Liwaiwaa mirinoŋ kema nene neŋ ragiti, kambaŋ iikanoŋ takis meme eja tiliqiligiawo ano siŋgisoŋgo eja mamaga yoŋonoŋ kaŋ Jiisas ano iwaa gowokouruta yoŋowo rama nene motooŋ negi. Mamaganoŋ Jiisas otaaŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jiisasnoŋ takis meme tiliqiligiawo ano siŋgisoŋgo ejemba tosaaŋa yoŋowo rama nene negiti, ii Farisii (Kana qaawaa kaparaŋkoŋkoŋ) ano yoŋoonoŋ boi tosianoŋ iima Jiisaswaa gowokouruta kokaeŋ jeŋ oŋoŋgi, “Ae! Iinoŋ mono naambaajoŋ takis meme tiliqiligiawo ano siŋgisoŋgo ejemba yoŋowo rama nene neja? Ii mende sokonja.” ");
INSERT INTO ksr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kaeŋ jeŋ oŋoŋgi Jiisasnoŋ kitia kokaeŋ iŋijoro, “Ejemba jigia qaa yoŋonoŋ doktawaa siiŋ mende amakejuto, ji ejembanoŋ mono doktawaanoŋ kemakeju. Niinoŋ siŋgisoŋgo ejemba oŋoomambaajoŋ kaŋ laligojento, ejemba iyaŋgiaajoŋ mogi solaŋa koloojuti, ii qaago.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kambaŋ kanoŋ Jombaanoŋ gowokouruta ano Farisii (Kana qaawaa kaparaŋkoŋkoŋ) yoŋonoŋ nene siŋgi laligogi tosianoŋ Jiisaswaanoŋ kaŋ kokaeŋ qisigi, “Jon Oomulu ejawaa gowokouruta nononoŋ Anutuwaajoŋ nene siŋgi laligoŋkejoŋ. Farisii (Kana qaawaa kaparaŋkoŋkoŋ) yoŋoo gowokourugianoŋ kaaŋiadeeŋ ama laligoju. Geeŋgaa gowokouruganoŋ mono naambaajoŋ Anutuwaa nene siŋgi mende laligoju?” ");
INSERT INTO ksr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Kaeŋ qisigi kokaeŋ meleeno, “Oŋanoŋ! Nono naa kambanoŋ nene siŋgi laligoŋkejoŋ? Emba meme kambaŋanoŋ ejawaa gemakootaŋurutanoŋ gereya aŋgi embawaa sakitiurutanoŋ iwoi ii togoŋkeju me qaago? Niinoŋ neenaa gowokouruna yoŋoo eja buŋa kolooŋ yoŋoo batugianoŋ ainjoloŋ ramakejeŋ. Rabe yoŋonoŋ iikawaajoŋ aisooŋ ainjoloŋ rama siŋgi laligowombaa amamaaŋkeju. ");
INSERT INTO ksr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Amamaaŋkejuto, Anutunoŋ laaligona nuano komuwe yoŋonoŋ mono kambaŋ iikanoŋ saanoŋ nene siŋgi laligoŋkebuya. ");
INSERT INTO ksr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“(Oŋo laaligo walaga ano korisoro Buŋa gbilia ii mindiriŋ orombombaajoŋ amamaawuya. Iikawaa qaa gemata ii kokaeŋ iŋijomaŋa.) Moumou walaga jurano moŋnoŋ opo gbilia mende sooŋgbaŋa motoŋ iikanoŋ opo jakaŋa mende uuŋ meŋ uumbinaaŋkeja. Kaeŋ anagati eeŋ, opo jakaŋa gbilianoŋ mono waziiŋ moumou walaga ii hororo mombo riiro ootanoŋ somariiŋ boliqoliwabo. ");
INSERT INTO ksr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kaaŋiadeeŋ moŋnoŋ wain apu gbilia ii bokoŋ me taru walaga lama selianoŋ memeta iikanoŋ mende kosoŋ maaro kemeŋkeja. Kaeŋ anagati eeŋ, wain apu gbilianoŋ mono somariiŋ taru qosono juma maaro namonoŋ kamaaŋ sooro taruyanoŋ boliqoliwubo. Kawaajoŋ wain apu gbilia ii taru gbilianoŋ maaniŋ kemero sokombaa. (Kaaŋiadeeŋ apu awaa ii konoŋ gbamoganoŋ mende kosoŋkejoŋ. Kaeŋ kosowonagati eeŋ, iikanoŋ mono juma siisororo kamaaro neniŋ ji niniwabo. Kaeŋ koloowaatiwaajoŋ apu awaa ii konoŋ awaanoŋ kosoŋkejoŋ. Oŋo kaaŋagadeeŋ laaligo walaga ano Oligaa Buŋa gbilia ii mindiriŋ orombombaajoŋ amamaawuya.) Kiaŋ.” ");
INSERT INTO ksr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kawaa gematanoŋ Sabat kendoŋ moŋnoŋ Jiisasnoŋ wiit gawoŋ koria somata kotoŋ keno. Keno gowokourutanoŋ wosogia iŋiro wiit hoŋa motomotooŋ kanaiŋ borogianoŋ mesuma negi. ");
INSERT INTO ksr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kaeŋ negitiwaajoŋ Farisii (Kana qaawaa kaparaŋkoŋkoŋ) tosianoŋ Jiisas kokaeŋ ijogi, “Moba, yoŋonoŋ mono naambaajoŋ Sabat kendombaa gawoŋ meme soŋgoya uuguju?” ");
INSERT INTO ksr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Kaeŋ ijogi kokaeŋ meleeno, “Kiŋ Deiwidnoŋ manjaqeqe ejauruta yoŋowo liligoŋ wosogia iŋiro nenewaajoŋ amamaaŋ iwoi aŋgiti, ii kambaŋ moŋnoŋ weeŋgogi me qaago? ");
INSERT INTO ksr_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Iinoŋ mono Anutuwaa opo sel jigonoŋ uma bered kowoga Anutuwaa jaasewaŋanoŋ alatanoŋ aŋgi raro esuŋanoŋ tururo qetegogiti, ii meŋ nero. Bered kowoga mesamesaoya ii jigo gawoŋ galeŋ yoŋonondeeŋ neŋ laligogi. Tosianoŋ ii newubotiwaajoŋ soŋgo ero kileŋ nero. Neŋ ejauruta kaaŋiadeeŋ oŋono motooŋ negi. Kambaŋ kanoŋ eja qata Abiatar iinoŋ jigo gawoŋ galeŋ waŋaa gawoŋ meŋ laligoro.” ");
INSERT INTO ksr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kaeŋ meleema kokaeŋ iŋijoro, “Anutunoŋ Sabat kendoŋ ii ejemba qeaŋgowutiwaajoŋ ano eja. Ii ejembanoŋ tondu jeŋ kotowutiwaajoŋ ama qaago! ");
INSERT INTO ksr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kaeŋ ano Siwe gomambaa Eja hoŋanoŋ mono Sabat kendombaa Poŋa kaaŋagadeeŋ kolooja.” ");
INSERT INTO ksr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jiisasnoŋ mombo qamakooli mirinoŋ uro iikanoŋ eja boria soosoolia moŋ raro. ");
INSERT INTO ksr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ejembanoŋ Jiisas qaa jakeyanoŋ ama mubombaajoŋ “Eja ii Sabat kendonoŋ meagowaa me qaago?” kaeŋ jeŋ Jiisaswaa jaa galeŋ meŋ ragi. ");
INSERT INTO ksr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Megi Jiisasnoŋ eja boria soosoolia ii kokaeŋ ijoro, “Mono waama jaanananoŋ namba.” ");
INSERT INTO ksr_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kaeŋ ijoŋ kokaeŋ iŋijoro, “Kana qaa otaaŋ Sabat kendonoŋ iwoi awaa me bologa ambonaga? Saanoŋ mombaa waŋa somoŋgowoŋa me mesaoniŋ komuwaa? Moŋga me moŋga meniŋ sokombaa?” Kaeŋ jero moma qaagia bogoro ragi. ");
INSERT INTO ksr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Qaagia bogoro ragi eleema iŋiiro uugianoŋ kotakota gojonotiwaajoŋ wosobiri moma uugerenoŋ iŋiiro. Kaeŋ iŋiima eja ii kokaeŋ ijoro, “Gii mono boroga qetetereewa.” Kaeŋ ijoro boria qetetereero mombo awaa kolooro. ");
INSERT INTO ksr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Awaa kolooro Farisii (Kana qaawaa kaparaŋkoŋkoŋ) yoŋonoŋ seleeŋgeŋ kema iikanondeeŋ gawana Herodwaa paati alauruta yoŋowo ajoajoroo ama “Jiisas nomaeŋ qeniŋ komunaga?” jeŋ qaa gawoŋ megi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Kaeŋ megi Jiisasnoŋ gowokouruta uŋuano apu aŋgoŋ goraayanoŋ keŋgi. Keŋgi Noot prowins qata Galili kanoŋa ejemba tuuŋlelembe yoŋonoŋ kanianoŋ otaaŋ keŋgi. Judia prowins kanoŋa kaaŋagadeeŋ iwaanoŋ kagi. ");
INSERT INTO ksr_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Siti waŋa qata Jerusalem, Saut prowins qata Aidumia ano Jordan apu leegeŋga weeŋ koukoutanoŋ yoŋonoŋ ano weeŋ kemekemetanoŋ baageŋga taoŋ qagara Taia ano Saidon liligoŋ laligojuti, iyoŋonoŋ kaaŋagadeeŋ tuuŋlelembeyanoŋ horoŋ kagi. Jiisasnoŋ aŋgoleto somasomata meŋ laligoroti, iikawaa bujuya moma mindiriŋ kougi. ");
INSERT INTO ksr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kaeŋ kouma utama mububotiwaajoŋ Jiisasnoŋ gowokouruta kokaeŋ iŋijoro, “Ologoŋ nombutiwaajoŋ oŋo mono waŋgo moŋ mokolooŋ noojoŋ kosere aŋgi raba.” ");
INSERT INTO ksr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kaeŋ iŋijoro ejemba seiseiya meŋ qeaŋgoŋ oŋoma laligoro. Kawaajoŋ qenjeŋmanjeŋ ano sele bimobimoogiawo kuuya yoŋonoŋ selianoŋ oosiriwombaajoŋ liligoŋ mamaga aoŋ memetaŋ aŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Omeya omeya yoŋonoŋ Jiisas iima jaasewaŋanoŋ namonoŋ kemeŋ kokaeŋ qagi, “Gii mono Anutuwaa Meria koloojaŋ!” ");
INSERT INTO ksr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kaeŋ qagi Jiisasnoŋ qetegoŋ oŋoma kanianoŋ asuganoŋ asugiwabotiwaajoŋ soŋgo kotakota ama oŋono. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kanageŋ Jiisasnoŋ baaŋanoŋ uma iikanoŋ iyaŋaa siiŋa otaaŋ eja oŋoono iwaanoŋ kagi. ");
INSERT INTO ksr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kagi eja 12 iwo laligowutiwaajoŋ kuuŋ oŋoma Buŋa qaaya jeŋ seiwutiwaajoŋ wasiŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Wasiŋ oŋoma omejiilaŋ konjoma oŋombutiwaa ku-usuŋa oŋono. ");
INSERT INTO ksr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kaeŋ ama eja 12 ii kokaeŋ kuuŋ oŋono: Piito, Jiisasnoŋ qa ii Saimon muro. ");
INSERT INTO ksr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jeims ano koga Jon, maŋgara qata Zebedi. Jiisasnoŋ yoroo qagara moŋ Boanerges qaro. Ii ananaa qaanoŋ Guŋparandambaa Merawoita. ");
INSERT INTO ksr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andruu, Filip, Bartolomyuu, Matyuu, Tomas, Jeims Alfiuswaa meria, Tadius, Saimon Zelot-politik ejaga, ");
INSERT INTO ksr_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ano Juudas Iskariot. Kariot eja iikanoŋ kanageŋ Jiisas memelolo meŋ muro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jiisasnoŋ iikaaŋ ama oŋoma baaŋanoŋga kamaaŋ yaŋaa mirinoŋ karo. Mirinoŋ karo ejemba tuuŋ somatanoŋ mombo kouma ajoroogi nembanene newombaajoŋ amamaagi. ");
INSERT INTO ksr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Amamaagi sakitiurutanoŋ ii moma “Uuta soodaboroja!” jegi. Jeŋ kemeŋ wambombaajoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Keŋgi Kana qaawaa boiya Jerusalemga kagiti, iyoŋonoŋ jegi, “Satambaa Iimolanoŋ mono uutanoŋ kemero laligoja. Iinoŋ omejiilaŋ yoŋoo waŋgia iwaa ku-usuŋanoŋ ome konjoma oŋotaaŋkeja.” ");
INSERT INTO ksr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kaeŋ jegitiwaajoŋ Jiisasnoŋ oŋoono kagi sareqaanoŋ kokaeŋ iŋijoro, “Satanoŋ mono nomaeŋ alia Satan moŋ konjonaga? ");
INSERT INTO ksr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kantri mombaa galeŋurugianoŋ batugianoŋ aŋgowowo ama deembuti eeŋ, iyoŋonoŋ mono galeŋkoŋkoŋ gawoŋgia meŋ nambombaajoŋ amamaawuya. ");
INSERT INTO ksr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kaaŋagadeeŋ miri mombaa kanageso yoŋonoŋ batugianoŋ aŋgowowo ama deembuti eeŋ, mono galeŋkoŋkoŋ gawoŋgia meŋ nambombaajoŋ amamaawuya. ");
INSERT INTO ksr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kaaŋagadeeŋ Satambaa kanageso yoŋonoŋ batugianoŋ aŋgowowo ama tuarenjeŋ ama aowuyagati eeŋ, galeŋkoŋkoŋgiaa esuŋanoŋ kamaaro ometotoŋgianoŋ mono qaomambaa anja. ");
INSERT INTO ksr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Moŋnoŋ eja kotiga Iimolambaa kana boria wala mende somoŋgowaati eeŋ, iinoŋ mono mirianoŋ uma esuhinaya qeŋgama memambaajoŋ amamaawaa. Wala ii somoŋgoro rarogo mono saanoŋ mirianoŋga ilawoilaya kuuya kopepereedaboroŋ meŋ kembaa. (Iikawaa so niinoŋ kaaŋagadeeŋ Satan somoŋgoŋ gematanoŋ omeya oŋotaaŋkejeŋ.”) Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijomaŋa, “Ejemba somata melaa siŋgisoŋgo amakejuti, ii Anutunoŋ mesaoŋkeja. Lombotawo me afaaŋa mepaqepae ambuyagati eeŋ, Anutunoŋ ii saanoŋ soŋgbama oŋombaa. ");
INSERT INTO ksr_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Soŋgbama oŋombaato, moŋnoŋ Uŋa Toroya mepaegowaati, iikawaa siŋgisoŋgoya Anutunoŋ mono kambaŋ moŋnoŋ mende mesaowaa. Qaago totooŋ! Siŋgisoŋgo iikanoŋ mono qaganoŋ uro kambaŋ tetegoya qaa Anutuwaa jaanoŋ qaayawo laligowaa.” Kaeŋ iŋijoro. ");
INSERT INTO ksr_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Omenoŋ uutanoŋ kemerota laligoja,” kaeŋ jegitiwaajoŋ ama kaeŋ kuma oŋono. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kaeŋ amiŋ mogi nemuŋkoaŋuruta yoŋonoŋ kaŋ seleeŋgeŋ nama yoŋoonoŋ kamaawaatiwaa qaa aŋgi iwaanoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Keno ejemba tuuŋ yoŋonoŋ liligoŋ muŋ rama kokaeŋ ijogi, “Moba! Goo nemuŋkoaŋuruganoŋ mono seleeŋgeŋ nama goojoŋ qisiju.” ");
INSERT INTO ksr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ijogi meleema kokaeŋ iŋijoro, “Noo nemuna ii moronoŋ ano noo kouruna ii daeŋ yoŋonoŋ?” ");
INSERT INTO ksr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jiisasnoŋ kaeŋ iŋijoŋ ejemba liligoŋ muŋ ragiti, ii uuŋ iŋiima kokaeŋ jero, “Iibu! Noo nemuna ano kouruna ii mono koi. ");
INSERT INTO ksr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Anutuwaa uusiiŋa teŋ komakejuti, iyoŋonoŋ mono noo nemuna ano naaŋkoaŋuruna kolooju.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jiisasnoŋ mombo apu aŋgoŋ goraayanoŋ kemeŋ kanaiŋ kuma oŋono. Kuma oŋono ejemba tuuŋlelembenoŋ iwaanoŋ kema ajoroogi waŋgonoŋ uma apu aŋgoŋ qaganoŋ kema raro. Raro ejemba kuuya yoŋonoŋ aŋgoŋ goraayanoŋ sakasinoŋ ajoroogi. ");
INSERT INTO ksr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kaeŋ ajoroogi sareqaa mamaga jeŋ kuma oŋono. Kuma oŋoma kokaeŋ jero: ");
INSERT INTO ksr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mobu! Eja moŋnoŋ nene kota qosoma kororoomambaajoŋ gawonoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kema qosoma kororooro kota tosianoŋ kana goraayanoŋ kemeŋ koŋgi. Kemeŋ koŋgi (waraweŋ) kooŋa kooŋa kouma ii nedaborogi. ");
INSERT INTO ksr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kota tosianoŋ jamo kowonjinoŋ kemeŋ koŋgi. Kemeŋ koma iikanoŋ namo mamaga mende mokoloogi. Namo dusiita mende erotiwaajoŋ kuragagia uulaŋawo kougi. ");
INSERT INTO ksr_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kougito, weeŋnoŋ kouma oŋooŋ jeŋ kotoŋ oŋono tiigia qaagotiwaajoŋ sooliŋ gororoŋgogi. ");
INSERT INTO ksr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kota tosianoŋ kumuntiri waayawo iikanoŋ kemeŋ koŋgi. Kemeŋ koŋgi komuntirinoŋ kouma qeŋ turuŋ bibiloko meŋ oŋoŋgi. Kaeŋ kolooro hoŋa mende kuugi. ");
INSERT INTO ksr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kota tosianoŋ namo awaanoŋ kemeŋ koŋgi. Kemeŋ koma kuragagia juma waama geregiaa hoŋgia awaa asugigi. Tosianoŋ kogia 30, tosianoŋ kogia 60, tosianoŋ 100 iikawaa so kolooŋ seigi.” ");
INSERT INTO ksr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kaeŋ jeŋ jedabororo, “Moŋnoŋ uugejiawo laligoji eeŋ, iinoŋ mono sareqaa koi geja ama moma kotowa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tuuŋ somata yoŋonoŋ deema keŋgi Jiisasnoŋ yaŋodeeŋ raro. Yaŋodeeŋ raro gowokouruta 12 ano tosaaŋa liligoŋ mugiti, ii motooŋ sareqaa koi kawaa kanagiaajoŋ qisiŋ mugi. ");
INSERT INTO ksr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Qisiŋ mugi kokaeŋ meleema iŋijoro, “Anutuwaa bentotonoŋ keuma laligowoŋatiwaa qaa aasaŋgoya ii oŋo asuganoŋ iŋijowe moma kotojuto, seleeŋgeŋ laligojuti, iyoŋoojoŋ ii kuuya sareqaanondeeŋ asugiŋkeja. ");
INSERT INTO ksr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kaeŋ asugiro ‘Iyaŋgiaa jaagianoŋ iwoi iimago kania kileŋ mende moma kotowuya. Iyaŋgiaa gejagianoŋ qaa tororo momago kania kileŋ mende moma asariwuya. Ii moma asariwuyagati eeŋ, mono saanoŋ uugia meleeŋgi Anutunoŋ siŋgisoŋgogia mesaonaga.’” ");
INSERT INTO ksr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jiisasnoŋ toroqeŋ kokaeŋ iŋijoro, “Sareqaa iikawaa kania ii mende moma asarijuti eeŋ, sareqaa tosaaŋa kuuya jemaŋati, ii mono nomaeŋ moma asariwuyaga? ");
INSERT INTO ksr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Sareqaa iikawaa kania ii kokaeŋ: Qosomakororoo ejanoŋ Buŋa qaa qosoma kororooŋkeja. ");
INSERT INTO ksr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nene kota kana goraayanoŋ kemeŋ koŋgiti, ii kokaeŋ: Buŋa qaa qosoma kororoogi ejemba uugianoŋ kemeŋkejato, ii mogi Satanoŋ iikanondeeŋ kaŋ qaa uugianoŋ qosoŋgi kemeroti, ii qetegoŋ uŋuamakeja. ");
INSERT INTO ksr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nene kota qosono jamo kowonjinoŋ kemeŋ koŋgiti, ii kaaŋagadeeŋ ejemba saregia moŋ. Yoŋonoŋ Buŋa qaa moma iikanondeeŋ uuqeeaŋgo qaganoŋ moma aŋgoŋ komakeju. ");
INSERT INTO ksr_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kaeŋ amakejuto, uugianoŋ tiita mende eŋ oŋombaato, kambaŋ torodaamoŋadeeŋ nama kotiiŋ laligowuya. Buŋa qaawaajoŋ ama kakasililiŋ me sisiwerowero kolooro kambaŋ iikanondeeŋ mono tama uŋuwaa. ");
INSERT INTO ksr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nene kota qosono kumuntiri waayawonoŋ kemeŋ koŋgiti, ii kokaeŋ: Yoŋonoŋ Buŋa qaa mogi uugianoŋ kemeŋkeja. ");
INSERT INTO ksr_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Kemeŋkejato, namonoŋ laaligowaa majakakaya ano moneŋ hina hoorowaa uugereya kolooŋ bimooŋ oŋomakeja. Qabuŋagiawo koloowombaa koposoŋgogi siiŋ kombombaŋa bologa tosianoŋ kaaŋagadeeŋ uugianoŋ duŋguŋ Buŋa qaa bibiloko meŋ muŋkeju. Kaeŋ kolooro hoŋgia qaa auta (gipeya) koloowuya. ");
INSERT INTO ksr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nene kota namo awaanoŋ qosono kemeŋ koŋgiti, ii ejemba koi kaaŋa: Yoŋonoŋ Buŋa qaa geja ama moma moma aŋgoŋ koma pondaŋ nama hoŋgia mokolooŋkeju. Tosianoŋ qaa je motooŋgonoŋga kota 30 mokolooŋkeju. Tosianoŋ hoŋgia 60, tosianoŋ qaa kota motomotooŋ iikawaa hoŋgia 100 meŋ seiŋ mokolooŋkeju.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jiisasnoŋ qaa moŋ kokaeŋ jero, “Moŋnoŋ lambe me kiwa meŋ ootiriŋ monjoŋ me duŋ baatanoŋ ambaa me qaago? Ii dakanoŋ ambaa? Ii mono iikawaa duŋ rarayanoŋ asuganoŋ ambaa. ");
INSERT INTO ksr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kaaŋiadeeŋ iwoi moŋ mesaŋgogi eji, ii mono asuganoŋ asugiwaatiwaajoŋ eja. Iwoi moŋ koma turugi eji, ii mono luluuŋgi qetumbaatiwaajoŋ ama eja. ");
INSERT INTO ksr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Moŋnoŋ uugejiawo laligoji eeŋ, iinoŋ mono sareqaa koi geja ama moma kotowa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jiisasnoŋ qaa kokaeŋ iŋijoro, “Qaa mojuti, ii mono moma aŋgoŋ koma uu wombogianoŋ ama koma gbiliŋ laligowu. (Kaeŋ laligogi uugia diŋgoro roromoŋgogianoŋ somariiro moma komuwuya.) Oŋo tosaaŋa yoŋoo qaagia gosiŋ jeŋ tegowuti, Anutunoŋ mono jeŋkootogia motooŋgo iikawaa so oŋoaŋgiaa qaagia gosiŋ jeŋ tegowaa. So ii mono uuguŋ iroŋa meleema oŋombaa. ");
INSERT INTO ksr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Iikawaa kania ii kokaeŋ: Moŋnoŋ momakootoyawo laligoji, Anutunoŋ mono ii toroqeŋ muro laligowaato, moŋnoŋ momakootoya qaa laligoji, Anutunoŋ mono momoya melaa eji, ii kaaŋagadeeŋ qetegoŋ wambaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jiisasnoŋ sareqaa moŋ kokaeŋ jero, “Anutuwaanoŋ bentotoŋ ii koi kaaŋa: Eja moŋnoŋ gawonoŋ kema nene kota qosoma kororoowaa. ");
INSERT INTO ksr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Qosoma kororooŋ kema asaga gomantiiŋa eŋ waawaa ano nene kotaa kuraga juma koumakeju. Nomaeŋ juma koumakejuti, ii aŋo mende moma kotoja. ");
INSERT INTO ksr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Namo aŋodeeŋ nemuŋ kono hoŋa kolooŋkeja: Wala geria, kanageŋ hoŋa ano iikawaa gematanoŋ hoŋa iikawaa kota ii kuuya kolooŋ somariidaborowuya. ");
INSERT INTO ksr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Hoŋa somariidaboroŋ momogoro hoŋa memewaa kambaŋa kolooro weleŋqeqeuruta wasiŋ oŋono soogia kaapeŋgoya jetawo meŋ hoŋa mewombaajoŋ gawoŋanoŋ kembuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jiisasnoŋ sareqaa moŋ kokaeŋ jero, “Anutuwaa bentotoŋa ii naamombo so ambonaga me naa sareqaanoŋ jeŋ asariwonaga? ");
INSERT INTO ksr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ii nejoŋ kotaa so kokaeŋ kolooja: Kota ii kazupuleenda. Ii namowaa nene kota kuuya iyoŋoo kamaaŋqeqegia kolooja. Kaeŋ kolooro gawonoŋ komomakeju. ");
INSERT INTO ksr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Komomakejuto, juma waama logoya kuuya uŋuuguŋ somariiŋ boria somasomata bororo kema kaŋkeja. Kaeŋ boroŋ keno kanakeewambaa kooŋa kooŋa yoŋonoŋ haigia iikawaa umuganoŋ amakeju.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jiisasnoŋ sareqaa kaaŋa kaaŋa ii mamaga jeŋ laligoŋ Buŋa qaa iŋijoro. Moma kotogitiwaa so ii iŋijoro moma laligogi. ");
INSERT INTO ksr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kambaŋ so qaaya kuuya ii sareqaanoŋ jeŋ laligoro. Qaaya moŋ eeŋ mende jeroto, gowokouruta yoŋowo iyaŋgiodeeŋ laligogi kambaŋ kanoŋ qaa kuuya kawaa kanagia ii jeŋ asariŋ oŋoma laligoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Weeŋ kanoŋ mare kolooro Jiisasnoŋ gowokouruta kokaeŋ iŋijoro, “Mono mesaoŋ aŋgoŋ kotoŋ leegeŋ keuboŋa.” ");
INSERT INTO ksr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kaeŋ iŋijoro ejemba tuuŋ oŋomesaoŋ Jiisas waŋgi waŋgonoŋ uma raro keŋgi. Waŋgo tosaaŋa ii kaaŋagadeeŋ yoŋowo gemanoŋ gemanoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Keŋgi raidimboŋ somatanoŋ obabaŋkota waaro sirinoŋ waŋgo uutanoŋ kemero waŋgo saa qemambaajoŋ ano. ");
INSERT INTO ksr_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kaeŋ kolooro Jiisasnoŋ waŋgo tetegoyanoŋ rama qembonoŋ laariŋ gaoŋ ero. Gaoŋ ero gowokourutanoŋ kema mindiiŋ ijogi, “Hei boi! Nono aŋgonoŋ tiwilaawombaajoŋ anjoŋ. Iikawaa majakakaya moŋ mojaŋ me qaago?” ");
INSERT INTO ksr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kaeŋ ijogi uuta tooro moma waama musu ano siri kokaeŋ jeŋ kotoŋ orono, “Mono bogoŋ eeŋ ewao!” Kaeŋ jero haamonoŋ doŋgoro sirinoŋ goroŋ qeŋ ero. ");
INSERT INTO ksr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kaeŋ ama kokaeŋ jeŋ oŋono, “Oŋo naambaajoŋa toroko momo eja kolooju? Nomaembaajoŋ ama Anutu mende moma laariju? Sombugia mono eeŋ moju.” ");
INSERT INTO ksr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jeŋ oŋono awawaliŋ qarasombugia moma amiŋ mogi, “Yei, maŋgaa siita! Eja koi naa ejaga laligoja? Iinoŋ musu ano kowe jeŋ kotoŋ orono jeta teŋ konjao?” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kaeŋ asugiro aŋgoŋ kotoŋ leegeŋ Gerasin yoŋoo gomanoŋ keugi. ");
INSERT INTO ksr_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Keuma goraayanoŋ ugi Jiisasnoŋ waŋgo mesaoro iikanondeeŋ eja omeyawo moŋ qasirinoŋga kaŋ nama Jiisas mokolooro. ");
INSERT INTO ksr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Eja ii qasirinoŋ laligoŋ qamo jamo kobaa osoŋ uroroogi egiti, iikanoŋ eŋ laligoro. Eja kuuyanoŋ kanaboria gbado (tape):noŋ somoŋgowoŋatiwaajoŋ amamaaŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Indiŋa indiŋa kania gbadonoŋ somoŋgoŋ bineŋ qeŋ laligogito, boro bota qeŋkegiti, ii qesuma kana kasia ritoqitoŋ laligoro kuuyanoŋ ii galeŋ koma mubombaajoŋ amamaagi. ");
INSERT INTO ksr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Amamaaŋ asaga gomantiiŋa suulaŋ qasiriwaa jamo kobaanoŋ me baaŋanoŋ lansaŋ eŋ laligoro. Kaeŋ laligoŋ qama silama selia jamonoŋ qeŋ kotomotoŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jiisasnoŋ korikori karo iima bobogariŋ kaŋ balonoŋ kosianoŋ kemeŋ simiŋ kuno. ");
INSERT INTO ksr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Simiŋ kuno Jiisasnoŋ omeya ii kokaeŋ jeŋ mumambaajoŋ ano, “Ome bologa, gii mono eja koi mesaoŋ kemba!” Kaeŋ jemambaajoŋ ano qa jinjerereŋ somata qama jero, “Ae! Jiisas, gii Anutu uutaa Meria koloojaŋ. Gii nomaeŋ ama nomambaajoŋ kajaŋ? Niinoŋ Anutuwaa jaasewaŋanoŋ welema gonjeŋ: Gii qaa somoŋgoŋ jojopaŋ qaanoŋ jeŋ kotiiŋ siimbobolo geriawo mende ama nomba.” ");
INSERT INTO ksr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kaeŋ jero kokaeŋ qisiro, “Gii qaga moro?” Qisiro jegi, “Nono mamaga laligojoŋiwaajoŋ qanana Liijon jejoŋ.” Ii ananaa qaanoŋ Kere tuuŋ somata. ");
INSERT INTO ksr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kaeŋ jeŋ kaparaŋ koma kokaeŋ welema mugi, “Gii nonotaawagati eeŋ, mono baloŋ kokanoŋa mende wasiŋ nonomba.” ");
INSERT INTO ksr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kosogianoŋ maroŋa kanoŋ bao tuuŋ somata moŋ gbojoja uutanoŋ kuluuma naŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kawaajoŋ ome yoŋonoŋ kokaeŋ jeŋ Jiisas welema mugi, “Giinoŋ wasiŋ nonona nono saanoŋ bao yoŋoo uugianoŋ kemeboŋa.” ");
INSERT INTO ksr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Welema mugi “Mono kema kemebu!” jeŋ kotoŋ oŋono eja uutanoŋga kouma kema bao uugianoŋ kemegi. Kemegi iikanondeeŋ bao tuuŋ 2,000 kawaa so ii mono luguŋ newonewonoŋ kema jororoŋgoŋ apu aŋgonoŋ kemeŋ nemotoŋ komugi. ");
INSERT INTO ksr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Komugi bao galeŋ yoŋonoŋ kok koma taoŋ ano gomaŋ boleboole iikanoŋ kema buju qaa jegi. Jegi moma ejemba jaasooŋgo yoŋonoŋ iwoi kolooroti, ii iibombaajoŋ kagi. ");
INSERT INTO ksr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kaŋ Jiisaswaanoŋ kouma iigi eja ome tuuŋawonoŋ laligoroti, iinoŋ mono opo selekopaaya tororo somoŋgoŋ rama uuta tooro roromoŋgoya kuuya asugiro iima awawaliŋ naŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Naŋgi bao ii nomaeŋ kemeŋ komugiti ano eja omeyawo iwaanoŋ iwoi kolooroti, ii iigiti, iyoŋonoŋ sundu woi ii iŋijogi. ");
INSERT INTO ksr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Iŋijogi nama Jiisasnoŋ mindimindiri gomaŋ baloŋgia mesaoŋ kembaatiwaajoŋ welema mugi. ");
INSERT INTO ksr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Welema mugi mesaoŋ waŋgonoŋ umambaajoŋ nano eja omeyawo laligoroti, iinoŋ kaŋ Jiisaswo motooŋ kema laligomambaajoŋ qisiro. ");
INSERT INTO ksr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Qisiroto, Jiisasnoŋ qotogoŋ muŋ kokaeŋ ijoro, “Gii mono gomaŋganoŋ kema tinitosauruga iŋiima Poŋnoŋ aŋgoleto somata meŋ kiaŋkomuŋ gonji, iikawaa sunduya ii iŋijona mobu.” ");
INSERT INTO ksr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kaeŋ ijoro mesaoŋ kema Jiisasnoŋ aŋgoleto somasomata meŋ muroti, iikawaa qaaya kanaiŋ Ten-taoŋ distrik uutanoŋ jeŋ seiro kuuyanoŋ moma waliŋgogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jiisasnoŋ waŋgonoŋ uma eleema aŋgoŋ kotoŋ leegeŋ karo ejemba tuuŋ mamaganoŋ iwaanoŋ kaŋ ajoroogi aŋgoŋ goraayanoŋ naŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Naŋgi qamakooli miriwaa qaa galeŋ moŋ qata Jairus iinoŋ kaŋ Jiisas iima batanoŋ kemeŋ simiŋ kuma muro. ");
INSERT INTO ksr_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Simiŋ kuma muŋ kaparaŋ koma qama kooliŋ kokaeŋ ijoro, “Borana melaanoŋ komumambaajoŋ anja. Mono kaŋ boroga qaganoŋ ana qeaŋgoŋ toroqeŋ laligowa.” ");
INSERT INTO ksr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kaeŋ ijoŋ Jiisas wano motooŋ keni ejemba tuuŋlelembe yoŋonoŋ gemagaranoŋ kema oloqologoŋ liligoŋ oroma keŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Keŋgi iikanoŋ batugianoŋ emba moŋ laligoro. Iinoŋ koiŋsa gbani 12:waa so iima ji kiro laligoro. ");
INSERT INTO ksr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kaeŋ laligoŋ siimbobolo mamaga moro selegaleŋ mamaganoŋ iwaa gawoŋa megi ilailaa moŋ mende mokolooŋ laligoro. Iinoŋ selegaleŋ ejemba yoŋoo tawagiaajoŋ moneŋ hinaya kuuya giliŋ laligoroto, jia iikanoŋ mono mombo momboga meŋ boliŋ muro laligoro. ");
INSERT INTO ksr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Kaeŋ laligoŋ Jiisaswaa bujuya moma kokaeŋ jero, “Niinoŋ ii oosirimambaajoŋ moma bimooŋ malekuyagadeeŋ boroŋa moŋ oosiriwenagati eeŋ, mono saanoŋ qeaŋgomaŋa.” Kaeŋ jeŋ ejemba tuuŋ batugianoŋ Jiisaswaa gematanoŋ kema malekuyanoŋ oosiriro. ");
INSERT INTO ksr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Oosiriro saya iikanondeeŋ juguro qenjeŋmanjeŋa ii qaono selianoŋ qeaŋgoro moro. ");
INSERT INTO ksr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Qeaŋgoro Jiisasnoŋ iikanondeeŋ esuŋa moŋ kotoŋ kenoti, ii moma ejemba tuuŋ batugianoŋ eleema qisiro, “Moronoŋ malekuna oosirija?” ");
INSERT INTO ksr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kaeŋ qisiro gowokourutanoŋ kokaeŋ ijogi, “Ejemba tuuŋnoŋ ologoŋ liligoŋ goma goosiriju. Ii iima nomaeŋ ‘Moronoŋ noosirija?’ qisijaŋ?” ");
INSERT INTO ksr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kaeŋ ijogito, Jiisasnoŋ mombo “Moronoŋ ii anja?” jeŋ qisiŋ mokoloomambaajoŋ eleema uuŋ iŋiiro. ");
INSERT INTO ksr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Iŋiiro emba selianoŋ aŋgoleto kolooroti, iinoŋ ii moma iikawaajoŋ toroko moma jeneŋa ororo kaŋ Jiisaswaa batanoŋ kemeŋ simiŋ kuma kania kuuya ijoro. ");
INSERT INTO ksr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jiisasnoŋ ii moma kokaeŋ ijoro, “Borana, momalaariganoŋ mono meŋ qeaŋgoŋ gonja. Qenjeŋmanjeŋganoŋ mono qaono saanoŋ uubonjonoŋ kemba.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Qaa kaeŋ ijoŋ nano qamakooli miriwaa qaa galeŋaa mirinoŋga moŋnoŋ qele kaŋ Jairus ijoro, “Boraga komuja! Kawaajoŋ mono boiwaa qaganoŋ lombo toroqeŋ mende amba.” ");
INSERT INTO ksr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ijoro Jiisasnoŋ qaa iikawaa telambelaŋ ama qamakooli miriwaa qaa galeŋ kokaeŋ ijoro, “Toroko mende moba. Mono nii moma laariŋ nomba.” ");
INSERT INTO ksr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kaeŋ ijoŋ ejemba tosaaŋa oŋomesaoŋ Piito, Jeims ano Jeimswaa koga Jon iigadeeŋ uŋuano ii otaaŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kema qamakooli miriwaa qaa galeŋaa mirinoŋ keugi ejemba tuuŋ guju megi iŋiiro. Mamaganoŋ jiŋgeŋ qama kotakota saama amburereŋ megi. ");
INSERT INTO ksr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Iŋiima mirinoŋ uma kokaeŋ iŋijoro, “Oŋo mono naambaajoŋ guju meŋ saaju? Bora iikanoŋ mende komujato, gaoŋga eja.” ");
INSERT INTO ksr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kaeŋ iŋijoro jonoŋsisi kaaŋa kolooro jomoma mugito, iinoŋ ii kuuya oŋotaaŋ borawaa nemuŋmaŋa ano tosaaŋa iwo laligogiti, iigadeeŋ uŋuano bora eroti, iikanoŋ ugi. ");
INSERT INTO ksr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Uma Jiisasnoŋ bora ii borianoŋ meŋ ijoro, “Talita kuum.” Ii ananaa qaanoŋ Bora melaa, nii gijojeŋ: Mono waaba! ");
INSERT INTO ksr_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kaeŋ ijoro bora gbania 12 iinoŋ mono iikanondeeŋ waama nama kema karo. Kaeŋ kolooro iima kosogia kitoŋ waliŋgogi. ");
INSERT INTO ksr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Waliŋgogi iikawaa bujuya moŋ jegi mobubotiwaajoŋ jeŋ soŋgo kotakota ano. Ii ama bora melaa ii nembanene mugi newaatijoŋ iŋijoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ii kolooro Jiisasnoŋ Jairuswaa gomaŋ baloŋ mesaoro gowokourutanoŋ otaaŋ iwo kema Jiisaswaa somasomarii taoŋanoŋ keugi. ");
INSERT INTO ksr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabat kendonoŋ karo qamakooli mirinoŋ uma Buŋa qaa kanaiŋ kuma oŋono. Kuma oŋono moma ejemba mamaganoŋ aaruŋ waliŋgoŋ kokaeŋ jegi, “Yei, gejajuju! Iwoi kuuya koi mono daeŋkaya moma jeja? Momakootoya ii mono moronoŋ kuma muro jeja? Ano aŋgoleto ku-usuŋawo kaaŋa ii mono moronoŋ inaaŋ muro borianoŋ mero asugija? ");
INSERT INTO ksr_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Eja koi mono gomaŋ kokawaa motoŋqeqe ejiaga. Mariawaa meria ano Jeims, Joosef, Juuda ano Saimon yoŋoo dagiaga. Naaŋurutanoŋ batunananoŋ koi laligoju.” Nazaret yoŋonoŋ kaeŋ jegi uugianoŋ boliro iikanoŋ amamaagi. ");
INSERT INTO ksr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Amamaagi Jiisasnoŋ kokaeŋ iŋijoro, “Gejatootoo ejawaa sakiti ano tinitosaurutanoŋ mono iyaŋaa taonoŋ jejewili ama muŋkejuto, gomaŋ tosaaŋa iikanoŋ kaeŋ qaago.” ");
INSERT INTO ksr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kaeŋ aŋgitiwaajoŋ Jiisasnoŋ ji ejemba motomotooŋgo boria qagianoŋ ama meŋ qeaŋgoŋ oŋonoto, aŋgoleto ku-usuŋawo tosaaŋa memambaajoŋ amamaaro. ");
INSERT INTO ksr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kaeŋ kolooro momalaariŋgianoŋ mende asugiro yaŋgiseŋgiaajoŋ ama aaruro. Aaruŋ oŋomesaoŋ Nazaretwaa kosianoŋ gomaŋa gomaŋa liligoŋ Buŋa qaa kuma oŋoma laligoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jiisasnoŋ gowokouruta 12 ii oŋoono kagi kanaiŋ woi woi kuuya wasiŋ oŋono. Wasiŋ oŋoma omejiilaŋ konjoma oŋombutiwaa ku-usuŋa oŋono. ");
INSERT INTO ksr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ii oŋoma kokaeŋ jeŋ kotoŋ oŋono, “Kana kembutiwaajoŋ taa gbarugia meŋ kembu. Iwoi tosia moŋ mende mewu. Kana samoŋgia qaago, gesogia qaago me soojaakota ii irimuŋ kasagianoŋ mende somoŋgowu. ");
INSERT INTO ksr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kana esu saanoŋ kanagianoŋ somoŋgowu. Maleku samoŋa qaagoto, maleku motooŋgo mewu.” ");
INSERT INTO ksr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kaeŋ jeŋ kokaeŋ iŋijoro, “Kema miri daeŋ daeŋ keubuti, mono iikanondeeŋ laligoŋ gawoŋ meŋ taoŋ ii mesaoŋ kana kembu. ");
INSERT INTO ksr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kema laligoŋ miri moŋnoŋ keugi mende koma horoŋ oŋoma qaagia mende mogi telambelaŋgia mono kokaeŋ jeŋ qendeema oŋombu, ‘Nono oŋoo balonoŋ kaniŋ sububuŋ kana tambonananoŋ mokotaaji, ii mono riiŋ qesaaniŋ oŋoaŋgiaanoŋ eleema kemebaa.’ Kaeŋ jegi kaniagia solaŋa moma kotogi saanoŋ gomaŋ me taoŋ ii mesaoŋ toroqeŋ kembu.” ");
INSERT INTO ksr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kaeŋ iŋijoro mesaoŋ kema ejemba uugia meleembutiwaa Buŋa qaaya ii jeŋ seiŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Laligoŋ omejiilaŋ mamaga oŋotaaŋ ji ejemba mamaga kelenoŋ oŋomoriŋ meŋ qeaŋgoŋ oŋoŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jiisaswaa qabuŋayanoŋ seiŋ kiŋ Herodwaa gejianoŋ kemero moro. Ejembanoŋ kokaeŋ jegi, “Jon Oomulu ejanoŋ mono koomunoŋga waama gawoŋa mero aŋgoleto ku-usuŋawo asugiŋkeja.” ");
INSERT INTO ksr_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kaeŋ jegito, tosianoŋ kokaeŋ jegi, “Ii mono Elaija.” Tosianoŋ toroqeŋ jegi, “Ii gejatootoo eja walaga yoŋoonoŋga moŋ.” ");
INSERT INTO ksr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kaeŋ jegito, kiŋ Herodnoŋ ii moma kokaeŋ jero, “Jon Oomulu eja niinoŋ jewe aroya kotogiti, iinoŋ mono koomunoŋga waama laligoja.” Majakaka moma kaeŋ jero. ");
INSERT INTO ksr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ii kokaembaajoŋa jero: Herodnoŋ koga Filipwaa embia Herodias oloŋ mero Jon Oomulu ejanoŋ kiŋ poŋ jeŋ muro kawaajoŋ opotoro wasiŋ oŋono kema Jon meŋ somoŋgoŋ kapuare mirinoŋ ooŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jonoŋ Herodwaa qaa kokaeŋ jero: “Gii qamboga oloŋ meŋ laligoŋ Kana qaa uugujaŋ.” ");
INSERT INTO ksr_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kaeŋ jero Herodiasnoŋ Jon kazi ama muŋ qegi komuwaatiwaajoŋ moroto, iikawaa kania moŋ mende mokolooro. ");
INSERT INTO ksr_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Mende mokolooro Jonoŋ eja solaŋa ano soraaya toroya kolooroti, Herodnoŋ ii moma sopa somoŋgoŋ kokojinjiŋ koma reeŋreeŋ suluŋ muŋ Jombaajoŋ toroko moma laligoro. Kaeŋ laligoŋ Herodnoŋ Jombaa jetanoŋga qaa moroti, ii uuta kuugi qaa mamagaajoŋ uuwoiwoi moro. Ii kileŋ Jombaa qaaya momambaa siiŋ moro. ");
INSERT INTO ksr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kaeŋ kolooro Herodiasnoŋ Jon qemambaa kania mende mokolooŋ laligoro iikawaa kambaŋa awaa ii kokaeŋ kaŋ kuuro: Kiŋ pombaa kolokoloo kambaŋanoŋ karo jejelombaŋ ama jawiŋ ano kawali galeŋuruta ano Galili prowinswaa jotamemeya waŋa ii koma horoŋ oŋono kouma ragi. ");
INSERT INTO ksr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kouma ragi Herodiaswaa boratanoŋ miri iikawaa uutanoŋ kouma danis ano Herod ano iwo nene duŋ liligoŋ ragiti, iyoŋonoŋ iikawaa iimasiiŋa mamaga mogi. Kaeŋ mogi kiŋnoŋ emba saraŋ ii kokaeŋ ijoro, “Borana, gii naa iwoiwaajoŋ siiŋa mobagati, ii saanoŋ qisiŋ nona togoŋ gomaŋa.” ");
INSERT INTO ksr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kaeŋ ijoŋ qaa ii jojopaŋ qaanoŋ jeŋ kotiiŋ kokaeŋ ijoro, “Naa iwoiwaajoŋ qisiŋ nombagati, ii mono saanoŋ gomaŋa. Iwoi ii me ii me prowins galeŋ koma oŋomakejeŋi, ii kaaŋiadeeŋ saanoŋ mendeema bakaya moŋ gombe galeŋgia koloowa.” ");
INSERT INTO ksr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kaeŋ ijoro seleeŋgeŋ kema nemuŋa kokaeŋ qisiŋ muro, “Nemuna, nii Kiŋnoŋ naa iwoiga nombaatiwaajoŋ qisiŋ mubenaga?” Kaeŋ qisiŋ muro nemuŋanoŋ kokaeŋ meleeno, “Mono kema jena Jon Oomulu ejawaa aroya kotogi waŋa meŋ kaŋ nomba.” ");
INSERT INTO ksr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kaeŋ meleeno iikanondeeŋ miri uutanoŋ bobogariŋ kimbaanoŋ uma kokaeŋ qisiŋ ijoro, “Ama, niinoŋ siiŋ kokaeŋ mojeŋ: Giinoŋ mono jeŋ kotona Jon Oomulu ejawaa aroya kotoŋ waŋa kondenoŋ ama meŋ kaŋ ii keteda koi nomba.” ");
INSERT INTO ksr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kaeŋ ijoro kimbaa uutanoŋ kobooro wosoya moroto, jojopaŋ qaaya somoŋgoro somataurutanoŋ ii mogiti, iyoŋoo jaagianoŋ kamaaŋ qewabotiwaajoŋ qiqisiya gema qemambaajoŋ moma bimooŋ mesaoro. ");
INSERT INTO ksr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mesaoŋ iikanondeeŋ opotoroya moŋ wasiŋ ijoro, “Gii mono kema Jombaa aroya kotoŋ waŋa meŋ kawa.” ");
INSERT INTO ksr_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kaeŋ ijoŋ wasiro kapuare miri gbadeyanoŋ kema aroya kotoŋ waŋa kondenoŋ ama meŋ kaŋ emba saraŋ ii muro nemuŋa muro. ");
INSERT INTO ksr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jombaa gowokourutanoŋ iikawaa bujuya moma kema qamoya meŋ qasiriwaa jamo kobaanoŋ ama roŋ koŋgi. Kaeŋ koloorotiwaajoŋ ama kiŋ Herodnoŋ kanageŋ Jiisaswaajoŋ jero, “Jonoŋ mono koomunoŋga gbiliŋ waama laligoja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Wasiwasi eja aposol yoŋonoŋ Jiisaswaanoŋ kaŋ ajorooŋ iwoi meŋ ejemba kuma oŋoŋgiti, iikawaa sunduya kuuya ijogi. ");
INSERT INTO ksr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ijogi ejemba donoŋ donoŋ kaŋ kema aŋgi selegia tiiroto, nene newuyatiwaa kambaŋa mende kolooro. Kawaajoŋ Jiisasnoŋ gowokouruta kokaeŋ iŋijoro, “Oŋo mono niwo kagi gomaŋ gbameŋanoŋ anana siri kema laligoŋ haamo melaada mewoŋa.” ");
INSERT INTO ksr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kaeŋ iŋijoro ejemba oŋomesaoŋ waŋgonoŋ uma gomaŋ gbameŋa moŋgeŋ iyaŋgia siri laligowombaajoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Keŋgi ejembanoŋ ii iima mamaganoŋ iikawaa bujuya moma taoŋ ano gomaŋ so iikanoŋa baloŋ kana bobogariŋ waladeeŋ kema iikanoŋ keugi. ");
INSERT INTO ksr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Keugi Jiisasnoŋ waŋgonoŋga kamaaŋ ejemba tuuŋ somata iŋiiro lama galeŋgia qaa tani iliŋwaliŋ qeŋ laligogi yoŋoojoŋ wosoya moro. Wosoya moma kanaiŋ Buŋa qaa kania kania kuma oŋono. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kaeŋ ama laligoro weeŋ jaaya tegoŋ kememambaajoŋ ano gowokourutanoŋ Jiisaswaanoŋ kaŋ kokaeŋ ijogi, “Boi. Nono gomaŋ gbameŋa kokanoŋ laligoniŋ gomaŋ tiimambaa anja. ");
INSERT INTO ksr_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kawaajoŋ gii saanoŋ ejemba koi wasiŋ oŋona gomaŋ ano miri boleboole kosere rama kenjuti, iikanoŋ kema nembanenegia sewaŋa meŋ newu.” ");
INSERT INTO ksr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kaeŋ ijogito, kokaeŋ meleema iŋijoro, “Oŋonoŋ mono oŋoaŋgio ii nene uŋuagiwu.” Kaeŋ iŋijoro qisiŋ mugi, “Nononoŋ mono nomaeŋ ambonaga? Gawoŋ meme kambaŋ 200:waa sewaŋa (Kina 2,000) eja. Moneŋ ii meŋ kema nene bered sewaŋa meŋ uŋuagiwombaajoŋ jejaŋ me?” ");
INSERT INTO ksr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kaeŋ qisiŋ mugi jero, “Oŋoaŋgiaanoŋ nene bered dawi raja? Ii kema iibu.” Kaeŋ jero gesogia qeŋgama jegi, “Bered 5 ano sora woi iikaanda meŋ laligojoŋ.” ");
INSERT INTO ksr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kaeŋ jegi Jiisasnoŋ ejemba tuuŋ kokaeŋ jeŋ kotoŋ oŋono, “Ejemba kuuya, oŋo mono deema nene newombaajoŋ tuuŋ boleboole ajorooŋ lolo toŋgoŋanoŋ kemeŋ rabu.” ");
INSERT INTO ksr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kaeŋ jeŋ kotoŋ oŋono kosere tuuŋa tuuŋa deema ragi. Tuuŋ tosia 100 ano tosia 50 kaaŋ kaaŋ kululuuŋ rama keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Rama keŋgi bered 5 ano sora woi ii meŋ Siwenoŋ uuro uro kotuegoŋ bered motoŋ gowokouruta oŋono ejemba tuuŋ so mendeema batugianoŋ aŋgi. Sora woi ii kaaŋiadeeŋ tuuŋ kuuya yoŋoojoŋ mendeeno. ");
INSERT INTO ksr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mendeeno ejemba korebore neŋgo neŋ timbiriigi. ");
INSERT INTO ksr_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Neŋ timbiriigi nene kitia kitia mesaogiti, ii gowoko yoŋonoŋ meŋ kululuugi konde 12 kanoŋ kemeŋ saa qero. Kaaŋagadeeŋ sora kitia ii meŋ kululuugi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Eja bered negiti, iyoŋoo jaŋgogia ii 5,000. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Negi tegoro Jiisasnoŋ iikanondeeŋ gowokouruta jeŋ kotoŋ oŋoma kokaeŋ jero, “Oŋo mono waŋgonoŋ uma waladeeŋ apu aŋgoŋ kotoŋ leegeŋ Betsaida gomanoŋ kembu. Niinoŋ saanoŋ kambaŋ biiwianoŋ ejemba tuuŋ koi wasiŋ oŋomago kamaŋa.” ");
INSERT INTO ksr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kaeŋ jeŋ yeizozogia jeŋ oŋooma baaŋanoŋ uma qama kooliro. ");
INSERT INTO ksr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Qama kooliŋ laligoro mare kolooro iyaŋodeeŋ baaŋanoŋ laligoro waŋgogianoŋ aŋgoŋ biiwianoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Keno loqanoŋ qeŋ qeŋ bimbimgoŋ naŋgogi keno haamonoŋ keŋgiti, iikaaŋ baageŋa qeŋ karo bimooro majakaka somata mogi. Gomaŋ aaŋanoŋ (3-6 kilok) iikaaŋanoŋ Jiisasnoŋ kaeŋ iŋiima apu aŋgoŋ qaganoŋ riiŋ riiŋ gowokouruta oŋoonoŋ kaŋ uŋuugumambaa ano. ");
INSERT INTO ksr_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Apu aŋgoŋ qaganoŋ riiŋ riiŋ karo ii iima “Kowe Soŋgorinoŋ kaja!” jeŋ kanaiŋ qama silaŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Qama silama kuuyanoŋ ii iima toroko mogito, Jiisasnoŋ iikanondeeŋ qaa bonjonda jeŋ kokaeŋ iŋijoro, “Alauruna, mono qaqabuŋabuŋagiawo satiiŋ laligowu. Neeno kajeŋ. Toroko mende mobu.” ");
INSERT INTO ksr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kaeŋ jeŋ yoŋoonoŋ waŋgonoŋ uro haamonoŋ goroŋ qero. Goroŋ qero jeneŋgia ororo honoŋa mende aarugi. ");
INSERT INTO ksr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Wala bered meŋ seiŋ uŋuagiroti, iikawaa kania mende moma asarigito, uugianoŋ gojono kaaŋiadeeŋ aaruŋ ragi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Apu aŋgoŋ kotoŋ leegeŋ Genesaret gomanoŋ keuma waŋgo mesaoŋ sakasinoŋ kemegi. ");
INSERT INTO ksr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Waŋgo mesaoŋ sakasinoŋ kemegi ejembanoŋ Jiisas iikanondeeŋ moma kotoŋ mugi. ");
INSERT INTO ksr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Moma kotoŋ muŋ qaa aŋgi meŋ bobogariŋ mindimindiri sopa gomaŋgianoŋ gomaŋ so liligogi. Liligogi moma kanaiŋ ji ejemba demberunoŋ aŋgoŋ oŋoma Jiisasnoŋ gomaŋ daeŋ laligorotiwaa so uŋuama kagi. ");
INSERT INTO ksr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Gomaŋ so, taoŋ, miri me kuuŋ mombaa uutanoŋ kenotiwaa so ji ejemba uŋuama sombeŋgianoŋ ama oŋoŋgi. Ama oŋoma Jiisaswaa selianoŋ me malekuyaa susuyanoŋ oosiriwombaajoŋ welema muŋ laligogi. Oosirigiti, kuuya yoŋonoŋ mono qeaŋgodaborogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kana qaawaa kaparaŋkoŋkoŋ ano iikawaa boi tosaaŋa Jerusalem sitinoŋga kagiti, iyoŋonoŋ Jiisaswaanoŋ kaŋ ajoroogi. ");
INSERT INTO ksr_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kambaŋ iikanoŋ Jiisaswaa gowokouruta tosaaŋanoŋ borogia mende soŋgbama doŋhamo mende qeŋ nembanene negi iŋiima uugia boliro. ");
INSERT INTO ksr_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisii (Kana qaawaa kaparaŋkoŋkoŋ) ano Juuda ejemba tosaaŋa kuuya yoŋonoŋ ambosakoŋ yoŋoo siligia otaaŋ laligogi. Kawaajoŋ borogia wala soŋgbama sororogoŋgo nembanene neŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kaaŋagadeeŋ gawonoŋga me maaketnoŋga kawuti, iikanoŋ wala apu kosoŋ ariŋ konjoratiŋgo nene oosiriŋ laligogi. Kaaŋagadeeŋ qambi, monjoŋ ano komanene kuuya ii soŋgbama hamo qeŋ laligogi. Sili kaaŋa kaaŋa ii mamaga otaaŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kawaajoŋ Kana qaawaa kaparaŋkoŋkoŋ ano iikawaa boi yoŋonoŋ Jiisas kokaeŋ qisiŋ mugi, “Goo gowokouruganoŋ mono naambaajoŋa ambosakoŋurunana yoŋoonoŋ sili mende otaaŋ borogia doŋhamo mende qeŋ kileŋ nembanene meŋ neŋkeju.” ");
INSERT INTO ksr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Kaeŋ qisiŋ mugi kokaeŋ iŋijoro, “Oo uumeleembaa ejemba seleseleya, gejatootoo eja Aisaianoŋ mono oŋoo kaniagia tororo luluuma Buju Tere moŋ kokaeŋ oorota eja, ‘Ejemba tuuŋ koi kanoŋ mono je buugianoŋ awaagadeeŋ goda qeŋ nomakejuto, uugianoŋ telambelaŋ ama noma moŋgeŋ koriganoŋ aŋgi eja. ");
INSERT INTO ksr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kaeŋ ero noo waena eeŋ toontooŋ meŋ mepeseeŋ nomakeju. Kana qaa kuma oŋombonjeŋ kitianoŋ ejemba yoŋoo jeŋkootogia ii gisomaso ama melokanjiŋkeju.’ ");
INSERT INTO ksr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Aisaianoŋ kaeŋ ooro. Oŋo mono iikawaa so Anutuwaanoŋ jojopaŋ qaa gema qeŋ ambosakoŋurugia yoŋoo siligia otaaŋkeju. Ii mende sokonja.” ");
INSERT INTO ksr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kaeŋ jeŋ kokaeŋ iŋijoro, “Oŋoaŋgiaa siligia walaga otaawombaajoŋ mono awaagadeeŋ Anutuwaanoŋ jojopaŋ qaa qewagoŋkeju. ");
INSERT INTO ksr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Iikawaa qaaya moŋ ii kokaeŋ: Moosesnoŋ kokaeŋ jeŋ kotoro, ‘Nemuŋ maŋga mono goda qeŋ oromakeba,’ ano ‘Moŋnoŋ maŋa me nemuŋa qasuaaŋ mubaati, ii mono qegi komuwa.’ ");
INSERT INTO ksr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kaeŋ jeŋ kotoroto, oŋo qaa ii uuguŋ kokaeŋ jeŋkeju, ‘Moŋnoŋ nemuŋ maŋa ii kokaeŋ irijowaa: Oo wosona mojeŋ. Noo naŋgonaŋgo iwoina buŋa qeŋ aowaoragati, ii Anutuwaa taha mamatewowaajoŋ gosiŋ andaborowe buŋayaa nanduŋa koloowaa. ");
INSERT INTO ksr_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Moŋnoŋ kaeŋ irijoro sokombaa jeju.’ Kaeŋ jeŋ somoŋgoŋ mugi nemuŋ maŋa yoroojoŋ ilailaa moŋ mende toroqeŋ oromakebaa. Ii mende sokonja. ");
INSERT INTO ksr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yei! Kaeŋ ama oŋoaŋgiaa nanamemeŋgiaa siligia jeŋ kotoŋ iikanoŋ Anutuwaanoŋ jojopaŋ qaa qewagogi omaya kolooŋ jaŋgoŋ qaomakeja. Oŋo iwoi kaaŋa ii mamaga amakeju.” Kaeŋ jeŋ meleema oŋono. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jiisasnoŋ ejemba tuuŋ mombo oŋoono kagi kokaeŋ iŋijoro, “Oŋo mono kuuya qaa koi geja ama moma asariwu. ");
INSERT INTO ksr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Iwoi seleeŋgeŋga eja uutanoŋ kemeŋkeji, iikanoŋ tilooŋ mumambaajoŋ amamaaŋkejato, iyaŋaa uu wombotanoŋga qaa kouma kamaaŋkeji, iikanoŋ mono tilooŋ muŋkeja. ");
INSERT INTO ksr_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Moŋnoŋ gejiawo laligoji eeŋ, iinoŋ mono qaa koi geja ama moma kotowa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jiisasnoŋ kaeŋ jeŋ ejemba tuuŋ oŋomesaoŋ kema miri moŋnoŋ uro. Uma raro gowokourutanoŋ sareqaa iikawaa kaniaajoŋ qisigi. ");
INSERT INTO ksr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Qisigi kokaeŋ iŋijoro, “Oo alauruna, oŋo kaaŋagadeeŋ momogia awaa mende koloojamaeŋ? Nembanene iwoi seleeŋgeŋga eja uutanoŋ kemeŋkeji, ii tilooŋ mumambaajoŋ amamaaŋkeja. Ii moma kotoju me qaago? ");
INSERT INTO ksr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ii uu wombotanoŋ mende kemeŋkejato, korojoŋanoŋ kemeŋ seleeŋgeŋ kamaaŋkeja.” Jiisasnoŋ qaa kaeŋ jeŋ iikanoŋ nembanene kuuya ii meŋ soraidabororo. ");
INSERT INTO ksr_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jiisasnoŋ toroqeŋ kokaeŋ jero, “Eja uu wombotanoŋga qaa kouma kamaaŋkeji, iikanoŋ mono tilooŋ muŋkeja. ");
INSERT INTO ksr_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ejemba uu wombogianoŋga iwoi koi kaaŋa kolooŋ koumakeja: Qaa bologa romoŋgoŋ serowiliŋ ambombaajoŋ momakeju. Iwoi yoŋgoro meŋ oweŋ jenaŋ meŋ ejemba uŋugi komuwutiwaajoŋ momakeju. ");
INSERT INTO ksr_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Oloŋkalu ambombaajoŋ momakeju. Meŋgo mewombaa otoko amakeju. Bidaaŋ jembooli ano aŋgomokoloŋ ambombaajoŋ momakeju. Qaa saga jeŋ uuduuduu ambombaajoŋ momakeju. Gejajuju ama goroŋooso ambombaajoŋ momakeju. Sewaŋkiki laligoŋ gemaqeqe qaa jeŋ Anutu mepaegowombaajoŋ momakeju. Jaba-arambaraŋ ama sili uugia qaa amakeju. ");
INSERT INTO ksr_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Iwoi bologa kuuya iikanoŋ mono ejemba uu wombogianoŋga kouma tilooŋ oŋomakeja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jiisasnoŋ waama Genesaret gomaŋ mesaoŋ siti qagara Taia ano Saidon iikawaa distrik qata Fonisia kawaa uutanoŋ keno. Kema gomaŋ moŋnoŋ uma bujuya moŋnoŋ mobabotiwaajoŋ buugia mejugoroto, kileŋ aasaŋgoya laligomambaajoŋ amamaaro. ");
INSERT INTO ksr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Amamaaro iikanondeeŋ emba moŋ borata melaa ii omeyawo laligoro Jiisaswaa bujuya moma iwaanoŋ kaŋ batanoŋ kemeŋ simiŋ kuno. ");
INSERT INTO ksr_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Emba ii Juudaga qaagoto, Griik qaa jeŋ laligoro. Nemuŋ maŋa ii Fonisiaga Siria prowins kanoŋa. Iinoŋ borataa uutanoŋga ome konjombaatiwaajoŋ welema muro. ");
INSERT INTO ksr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Welema muro kokaeŋ ijoro, “Juuda nono wala nononanaa meraboraanana uŋuaginiŋ neŋ timbiriŋ ambuya. Kawaajoŋ merabora yoŋoo mirigianoŋga bered meŋ kasu oŋoniŋ mende sokombabo. Juuda anana wabaurunana oŋoo qagia kasu qamakejoŋ. Niinoŋ wala Juuda ejemba ilaaŋ oŋombe kantri tosaaŋa oŋonoŋ mono kasu kaaŋa mamboma laligowu.” ");
INSERT INTO ksr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kaeŋ ijoro moma kokaeŋ meleeno, “Poŋ, ii saanoŋ mojento, kasu meria yoŋonoŋ mono kaaŋagadeeŋ merabora yoŋoonoŋ nene reemoŋa nene duŋ baatanoŋ kamaaro neŋkeju.” ");
INSERT INTO ksr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kaeŋ meleeno Jiisasnoŋ kokaeŋ ijoro, “Qaa kaeŋ jejaŋiwaajoŋ saanoŋ moma gonjeŋ. Ome iikanoŋ mono keteda koi boraga mesaoŋ kenja. Kawaajoŋ gii saanoŋ kemba.” ");
INSERT INTO ksr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kaeŋ ijoro moma mirianoŋ keno omenoŋ borata mesaoro duŋanoŋ ero iiro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jiisasnoŋ mombo Taia siti gomaŋ mesaoŋ Saidon sitinoŋ kema uuguŋ misiŋgoŋ Ten-taoŋ gomambaa biiwia uuguŋ Galili apu aŋgoŋ kosianoŋ karo. ");
INSERT INTO ksr_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Karo gejaduu eja moŋ qaaya qaomambaajoŋ anoti, ii wama Jiisaswaanoŋ kagi. Kaŋ boria waŋanoŋ ambaatiwaajoŋ qisiŋ mugi. ");
INSERT INTO ksr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Qisiŋ mugi eja ii wama ejemba tuuŋ ii oŋomesaoŋ moŋgeŋ keni. Kema Jiisasnoŋ boro susuya gejianoŋ ama nama mombo iyaŋaa boro susuyanoŋ sulaaŋ neselaŋanoŋ oosiriro. ");
INSERT INTO ksr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Oosiriŋ Siwenoŋ uuro uro osoŋgombo qama kooliŋ iyaŋaa qaanoŋ “Efata,” ananaa qaanoŋ ‘Mono toowa,’ kaeŋ jero. ");
INSERT INTO ksr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kaeŋ jero gejawoitanoŋ toori neselaŋanoŋ lolooro qaaya awaagadeeŋ jero. ");
INSERT INTO ksr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jero Jiisasnoŋ iikawaa bujuya ejemba iŋijowubotiwaajoŋ qotogoŋ oŋono. Qotogoŋ oŋoma kaparaŋ kono yoŋonoŋ ii kaparaŋ koma jeŋ seiŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jeŋ seiŋ laligogi ejembanoŋ newogia tegoro waliŋgoŋ kokaeŋ jegi, “Iwoi kuuya awaagadeeŋ amakeja. Gejaduu gejagia metooro momakeju. Ejemba motoya yoŋoo neselaŋgia isano qaa jeŋkeju.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kambaŋ kanoŋ ejemba tuuŋ somatanoŋ mombo ajoroogi. Nembanenegia qaa laligogitiwaajoŋ Jiisasnoŋ gowokouruta oŋoono iwaanoŋ kagi kokaeŋ iŋijoro, ");
INSERT INTO ksr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Niinoŋ ejemba tuuŋ koi yoŋoojoŋ wosona mojeŋ. Yoŋonoŋ niwo kaŋ weeŋ karooŋ laligogi nembanenegia qaondabororo iijeŋ. ");
INSERT INTO ksr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Yoŋoonoŋga tosianoŋ koriganoŋga kaŋ laligogi niinoŋ ‘Saanoŋ gomaŋgianoŋ kembu,’ jemambo. Nene mende negi eeŋ wasiŋ oŋombe kana batuyanoŋ kema kema jaagia giliro tiwitiwilaa mokoloowubo.” ");
INSERT INTO ksr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kaeŋ iŋijoro gowokourutanoŋ meleema kokaeŋ ijogi. “Baloŋ qararaŋkoŋkoŋanoŋ kokanoŋ moŋnoŋ mono daeŋkaya nembanene kaaŋa mokolooŋ tuuŋlelembe koi uŋuaginaga?” ");
INSERT INTO ksr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Kaeŋ ijogi kokaeŋ qisiŋ oŋono, “Oŋoonoŋ bered dawi raja?” Qisiŋ oŋono “Bered 7 raja,” ijogi. ");
INSERT INTO ksr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ijogi Jiisasnoŋ ejemba tuuŋlelembe ii namonoŋ kemeŋ rabutiwaajoŋ jeŋ kotoŋ oŋono kemeŋ ragi. Kemeŋ ragi bered 7 ii meŋ Anutu qama kooliŋ daŋgiseŋ jeŋ motoŋ gowokouruta oŋoma ejemba tuuŋ so batugianoŋ ambutiwaajoŋ jero. Kaeŋ jero iikawaa so aŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Yoŋoonoŋ sora boleboole tosia kaaŋagadeeŋ raro. Ii kaaŋiadeeŋ meŋ kotuegoŋ ejemba tuuŋ so batugianoŋ toto qeŋ oŋombutiwaajoŋ jeŋ kotoŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Jeŋ kotoŋ oŋono oŋoŋgi neŋ neŋ timbiriŋgogi. Neŋ timbiriŋgoŋ nene kitia mesaogi raroti, ii konde 7 meŋ kululuugi saa qero. ");
INSERT INTO ksr_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Eja nene negiti, iyoŋoo jaŋgogia ii 4,000. Negi wasiŋ oŋono gomaŋgianoŋ keŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Keŋgi iikanondeeŋ gowokouruta yoŋowo waŋgonoŋ uma distrik qata Dalmanuta kanoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisii (Kana qaawaa kaparaŋkoŋkoŋ) tosianoŋ iikanoŋ kaŋ Jiisaswo kanaiŋ jenoŋkooli aŋgi. Qaawaa timbinoŋ horowombaajoŋ aŋgobato meŋ muŋ kokaeŋ kaparaŋ koma qisigi, “Mono jena Siwenoŋga aŋgoleto moŋ asugiro iiboŋa.” ");
INSERT INTO ksr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kaeŋ jegi uutanoŋ bimooro osoŋgoŋawo qero jero, “Oo ejemba kambaŋ kokaamba namonoŋ laligojuti, oŋo mono naambaajoŋ Anutuwaa aiwese asugiwaatiwaajoŋ kaparaŋ komakeju? Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Anutunoŋ aiwese kaaŋa ii mende meŋ qendeema oŋombaa. Qaago awawi!” ");
INSERT INTO ksr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kaeŋ jeŋ oŋomesaoŋ mombo gowokouruta yoŋowo waŋgonoŋ uma apu aŋgoŋ kotoŋ leegeŋ keugi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Iikanoŋ keuma samoŋ mewombaajoŋ duduugi bered motooŋgoda ii waŋgonoŋ meŋ ragi. ");
INSERT INTO ksr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ragi Jiisasnoŋ kokaeŋ jeŋ kotoŋ oŋono, “Oŋo Kana qaawaa kaparaŋkoŋkoŋ (Farisii) yoŋoo tomembouŋbouŋ qaagia ano Herodwaa riki sombaŋ iikawaajoŋ mono galeŋgia mewu. Ii awaagadeeŋ mende gosiŋ gema qewuti eeŋ, iyoronoŋ mono yiist kaaŋa somariiŋ meŋ boliŋ oŋombaota.” ");
INSERT INTO ksr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jeŋ kotoŋ oŋono qaa gemata ii mende moma asariŋ batugianoŋ kokaeŋ amiŋ mogi. “Berednana qaawaajoŋ jeja me nomaeŋ?” ");
INSERT INTO ksr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ii amiŋ mogi gejianoŋ kemero kokaeŋ iŋijoro, “Naambaajoŋ berednana qaa jeŋ amiŋ moju? Noo kaniana ii naambaajoŋ mende moma kotoju? Ii mende moma asariju me? Uugejagianoŋ gojoma raja me? ");
INSERT INTO ksr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Jaagia rajaoto, kileŋ mende iima kotoju me? Gejagia rajaoto, kileŋ mende moma asariju me? Iwoi asugiroti, ii duduuju me qaago? ");
INSERT INTO ksr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Niinoŋ bered 5 ii ejemba 5,000 yoŋoojoŋ motowe iikawaa kitia meŋ kululuugi konde dawinoŋ kemeŋ saa qero?” Qisiŋ oŋono “Konde 12,” ijogi. ");
INSERT INTO ksr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ijogi toroqero, “Niinoŋ bered 7 ii ejemba 4,000 yoŋoojoŋ motowe iikawaa kitia meŋ kululuugi konde dawinoŋ kemeŋ saa qero?” Qisiŋ oŋono “Konde 7,” ijogi. ");
INSERT INTO ksr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ijogi moma jero, “Kawaajoŋ kaniana ii mono kaaŋiadeeŋ mende moma asariju me?” Kiaŋ ");
INSERT INTO ksr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jiisasnoŋ gowokouruta yoŋowo Betsaida taonoŋ kagi. Kanoŋ kaŋ eja jaagoo moŋ wama Jiisaswaanoŋ kouma borianoŋ oosiriwaatiwaajoŋ qama kooliŋ mugi. ");
INSERT INTO ksr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Qama kooliŋ mugi Jiisasnoŋ eja jaagoo ii borianoŋ meŋ wama miri seleeŋgeŋ keni. Kema sulaaya sulaaŋ jaayanoŋ ama boria waŋanoŋ ama qisiŋ muro, “Iwoi moŋ iijaŋ me qaago?” ");
INSERT INTO ksr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Qisiŋ muro jaaya uuro uro jero, “Ejemba iŋiijento, ii gere tanitani koloogi kokoosugadeeŋ iŋiibe kema kaŋ nanju.” ");
INSERT INTO ksr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kaeŋ jero mombo borianoŋ jaawoita oosiriro toori tororo uuro asariŋ kotoro iwoi kuuya awaagadeeŋ iidabororo. ");
INSERT INTO ksr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iidabororo wasiŋ muŋ kokaeŋ ijoro, “Gii gomaŋ moŋgeŋ mende kembato, dindiŋa geeŋgaa gomaŋganoŋ kemba.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jiisasnoŋ Betsaida mesaoŋ gowokouruta yoŋowo Sisaria Filipai taombaa kosianoŋ keŋgi. Kananoŋ kema gowokouruta kokaeŋ qisiŋ oŋono, “Ejembanoŋ noojoŋ nomaeŋ jeŋkeju? Nii eja moroga koloojeŋ?” ");
INSERT INTO ksr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Qisiŋ oŋono meleema kokaeŋ jegi, “Tosianoŋ ‘Gii Jon Oomulu ejaga koloojaŋ,’ jeŋkejuto, tosianoŋ ‘Gii Elaija koloojaŋ,’ ‘jeŋkeju ano tosianoŋ toroqeŋ kokaeŋ jeŋkeju, ‘Gii gejatootoo eja walaga yoŋoonoŋga moŋ koloojaŋ.’” ");
INSERT INTO ksr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kaeŋ jegi kokaeŋ qisiŋ oŋono, “Ano oŋoaŋgio noojoŋ nomaeŋ jeju? Nii moroga koloojeŋ?” Qisiŋ oŋono Piitonoŋ kokaeŋ meleeno, “Gii Anutuwaanoŋ Hamoqeqe Toya Kraist koloojaŋ.” ");
INSERT INTO ksr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kaeŋ meleeno kania asuganoŋ jegi moŋnoŋ mobabotiwaajoŋ soŋgo kotakota ama oŋono. ");
INSERT INTO ksr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jiisasnoŋ gowokouruta kanaiŋ kokaeŋ kuma oŋono, “Siwe gomambaa Eja hoŋanoŋ mono siimbobolo mamaga mobaa. Kantriwaa jotamemeya, jigo gawoŋ galeŋ ano Kana qaawaa boi yoŋonoŋ mono gema qeŋ qegi komuwaa. Komuro weeŋ karooŋ tegoro koomunoŋga waabaa.” ");
INSERT INTO ksr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jiisasnoŋ qaa ii mende kolatiŋ asuganoŋ jero Piitonoŋ iikanondeeŋ horoŋ muŋ goraayanoŋ kema kanaiŋ qotogoŋ muro. ");
INSERT INTO ksr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Qotogoŋ muro eleema gowokouruta uuŋ iŋiima Piito qotogoŋ kokaeŋ jeŋ muro, “Gii qaa romoŋgojaŋi, ii Anutuwaanoŋ qaaga qaagoto, baloŋ ejemba ano Satan siiŋgiaga. Kawaajoŋ Satan, gii mono keteda koi noo jaasewananoŋga togowa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jiisasnoŋ ejemba tuuŋ ano gowokouruta oŋoono kagi qaa kokaeŋ iŋijoro, “Moŋnoŋ noo gemananoŋ kamambaajoŋ moji, iinoŋ mono iyaŋaa uuseliaa siiŋ kombombaŋa bologa gema qero sisia megi siimbobolo ii bisimakeba. Ii maripoonoŋ komuwaatiwaa so mokosiŋgoŋ nii notaaŋ kawa. ");
INSERT INTO ksr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Moŋnoŋ laaligoya iyaŋaajoŋ aŋgoŋ koma iyaŋaa jaajaa laligoji, iinoŋ mono laaligoya hoŋa somoŋgoro soowaa. Soowaato, moŋnoŋ balombaa laaligoya ii nii ano noo Oligaa Buŋanaajoŋ ama qeleema togoŋ nombaati, iinoŋ mono laaligo hoŋaa kania mokolooŋ kotiiŋ laligowaa. ");
INSERT INTO ksr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Moŋnoŋ gomaŋa gomaŋa yoŋoo ilawoilaya kuuya koma hororo buŋaya kendabororo uuwaa laaligoya meŋ sooŋ silemale laligoŋ komuro Anutunoŋ qaaya jeŋ tegoro uŋayanoŋ tiwilaaro mende sokombaa. Esuhinaya iikanoŋ mono uukoisoro mende meŋ mubaa. Qaago totooŋ! ");
INSERT INTO ksr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Anana kuuyanoŋ mono ananaa dowenana mewombaajoŋ amamaawoŋa. ");
INSERT INTO ksr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ejemba tuuŋa tuuŋa kambaŋ kokanoŋ balonoŋ oloŋkalu ama siŋgisoŋgo tosaaŋa ama laligoŋkeju. Moŋnoŋ iyoŋoo batugianoŋ noo qana ano noo Buŋa qaana meŋ kamaaŋ ambaati, ii Siwe gomambaa Eja hoŋanoŋ kaaŋagadeeŋ iima tiiwaa. Iinoŋ kanageŋ Siwe gajoba toroya yoŋowo koi kamaagi Maŋaa asamararaŋa iima aarugi iinoŋ eja me emba kaaŋa mono iŋiima tiiŋ oŋombaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kaeŋ iŋijoŋ kokaeŋ jero, “Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Koi nanjuti, oŋoo batugianoŋga tosianoŋ Anutunoŋ bentotoŋa kuuro ku-usuŋanoŋ asugiwaati, ii iima kotowuya. Jaawo laligoŋ koomuwaa siimboboloya mende mogi ii kolooŋ asugiro iibuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Weeŋ 6 tegoro Jiisasnoŋ Piito, Jeims ano Jon uŋuama ejemba oŋomesaoŋ iyaŋgia siri baaŋa koriga moŋnoŋ uma gbameŋanoŋ laligogi. Iikanoŋ laligogi jaasewaŋgianoŋ nano Jiisaswaa sele tanianoŋ letoma morota kolooro. ");
INSERT INTO ksr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Malekuyanoŋ tualalakota asamararaŋawo kolooro. Balonoŋ opo taaŋa gbabulunoŋ (saife, omo) soŋgbamakejuti, mono ii uuguŋ taaliro. ");
INSERT INTO ksr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kaeŋ kolooro Elaija ano Mooses yoronoŋ asugiŋ oŋoma Jiisaswo qaa amigi. ");
INSERT INTO ksr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Amigi Piitonoŋ kanaiŋ qaa jeŋ Jiisas kokaeŋ ijoro, “Somatanana, nononoŋ kokanoŋ uukorisoro mojoŋ. Kawaajoŋ nononoŋ saanoŋ kuuŋ karooŋ mewoŋa: Goojoŋ moŋ, Mooseswaajoŋ moŋ ano Elaijawaajoŋ moŋ.” ");
INSERT INTO ksr_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Gowoko yoŋonoŋ jeneŋgia mamaga ororo Piitonoŋ “Nomaeŋ jemaŋa?” jeŋ qaa moŋgano. ");
INSERT INTO ksr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Qaa moŋgama nano kokolo tualalakota asamararaŋawo moŋnoŋ kamaaŋ umugayanoŋ esuuŋ oŋono iikawaa uutanoŋga qa aro moŋ kokaeŋ kolooro mogi, “Eja koi neenaa wombo merana kolooja. Mono iwaa qaaya moma laligowu.” ");
INSERT INTO ksr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Qaa ii moma uulaŋawo eleema uuŋ moŋgama woi ii mombo mende iriigi Jiisasnondeeŋ yoŋowo nano. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Baaŋanoŋga roganoŋ kamaaŋ Jiisasnoŋ kokaeŋ jeŋ kotoŋ oŋono, “Oŋono iwoi iijuti, iikawaa bujuya ii mono ejemba moŋ mende iŋijowu. Siwe gomambaa Eja hoŋanoŋ koomunoŋga waaro iikawaa gematanoŋ ii saanoŋ jeŋ asariŋ laligowu.” ");
INSERT INTO ksr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kaeŋ jeŋ kotoŋ oŋono gowokouruta karooŋ yoŋonoŋ qaa ii uugianoŋ aŋgoŋ koma koomunoŋga waawaataa qaa iikawaa kania ii iyaŋgia qisiŋ aoŋ amiŋ mogi. ");
INSERT INTO ksr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Amiŋ moma Jiisas kokaeŋ qisiŋ mugi, “Kana qaawaa boi yoŋonoŋ qaa kokaeŋ jeŋkeju, ‘Gejatootoo eja Elaijanoŋ mono Siwenoŋga waladeeŋ kamaaŋ asugiwaa.’ Ii nomaembaajoŋ jeŋkeju?” ");
INSERT INTO ksr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Qisiŋ mugi meleema kokaeŋ iŋijoro, “Elaijanoŋ waladeeŋ kamaaŋ asugiŋ laaligo kuuya meagowaa. Qaa ii hoŋaga koloojato, qaa moŋ koi mono naambaajoŋ oogi eja: ‘Siwe gomambaa Eja hoŋanoŋ mono siimbobolo mamaga moro jejewili ama mubuya.’ ");
INSERT INTO ksr_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Qaa woi ii ejaoto, niinoŋ kokaeŋ iŋijomaŋa: Elaijanoŋ mono kamaaŋ asugiroto, iwaajoŋ Buŋa qaa oogita ejiwaa so ejembanoŋ ii iyaŋgiaa siiŋgia otaaŋ tondu ama mugi.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jiisas ano gowoko karooŋ yoŋonoŋ baaŋanoŋga kamaaŋ gowokouruta tosia yoŋoonoŋ kaŋ iwoi kokaeŋ iigi: Kana qaawaa boi tosianoŋ nama yoŋowo jenoŋkooli ano niinoŋgiinoŋ qaa jegi ejemba tuuŋlelembenoŋ liligoŋ iŋiima naŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kaeŋ nama ejemba tuuŋ kuuya yoŋonoŋ Jiisas iima iikanondeeŋ aaruŋ bobogariŋ kosianoŋ kema joloŋa jegi. ");
INSERT INTO ksr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Joloŋa jegi kokaeŋ qisiŋ oŋono, “Oŋonoŋ naambaajoŋ yoŋowo jenoŋkooli ama niinoŋgiinoŋ qaa jeju?” ");
INSERT INTO ksr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Qisiŋ oŋono tuuŋgianoŋga eja moŋnoŋ meleema kokaeŋ ijoro, “Boi, noo merana omenoŋ buuta muuŋguŋ qaamuuŋ meŋ muro wama goonoŋ kajeŋ. ");
INSERT INTO ksr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Iinoŋ kanoŋ me kanoŋ meŋ utugoŋ horoŋ giliro kamaaŋ qeŋ buutanoŋga kokopa kamaaro iriŋa kijoŋgoŋ selianoŋ mejugoŋkeja. Kaeŋ kolooro kaŋ goo gowokouruga welema oŋoma ome ii otaawutiwaajoŋ iŋijojento, yoŋonoŋ ii amamaajuya.” ");
INSERT INTO ksr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kaeŋ ijoro meleema muŋ jero, “Yei! Balombaa ejemba yaŋgiseŋgiawo. Mono kambaŋ dawi oŋowo qatoŋ uŋuŋ laligowe Anutu mende moma laarigi siimbobolo momakemaŋa. Ii mono wama noonoŋ kawu.” ");
INSERT INTO ksr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kaeŋ jero wama iwaanoŋ kagi. Kagi omenoŋ Jiisas iima iikanondeeŋ mera utugoŋ orogoŋ muro wolaza horoŋ tama namonoŋ qeŋ poraŋporaŋ itagoŋ sembeŋ aoŋ ero buutanoŋga kokopa kouma kamaaro. ");
INSERT INTO ksr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jiisasnoŋ ii iima maŋa kokaeŋ qisiŋ muro, “Kambaŋ dawiwaa so tani koi asugiŋ muŋ kouro?” Qisiŋ muro jero, “Ii mono melaayanondeeŋ kolooŋ muro. ");
INSERT INTO ksr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Ii meŋ boliŋ mumambaajoŋ indiŋa indiŋa gerenoŋ me apunoŋ metano kambaŋ mamaga kemeŋ qeŋ qeŋgadeeŋ amakeja. Kaento, iikaaŋaa ku-usuŋa moŋ goonoŋ eji eeŋ, mono kiaŋkomuŋ ilaaŋ noromba.” ");
INSERT INTO ksr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Kaeŋ jero Jiisasnoŋ ijoro, “‘Ku-usuŋa moŋ goonoŋ eji eeŋ,’ jejaŋ. Anutuwaa ku-usuŋanoŋ mono ilawoila mombaajoŋ mende amamaaŋkeja. Moŋnoŋ Anutu moma laariwaati, iwaanoŋ ilawoila kania kania saanoŋ kolooŋkebaa.” ");
INSERT INTO ksr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kaeŋ ijoro maŋanoŋ iikanondeeŋ qama jero, “Anutu moma laarijento, momalaarinanoŋ loolooria kolooja. Momalaarina mono meŋ kotiiwa.” ");
INSERT INTO ksr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jero ejemba jaasooŋgoyanoŋ bobogariŋ kagi iŋiima iikawaajoŋ ome ii kokaeŋ jeŋ muro, “Gii qaamuuŋ ano gejaduuwaa omeya, niinoŋ jeŋ kotoŋ gonjeŋ: Gii mono eja koi mesaoŋ kouma kema mombo mende eleema kawa.” ");
INSERT INTO ksr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jeŋ muro qama silama mera ii utugoŋ uulaŋawo orogoŋ muro hororo utama kouma keno. Kouma keno qamo kaaŋa kolooŋ ero mamaganoŋ ii iima “Wosoya tegoja!” jegi. ");
INSERT INTO ksr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kaeŋ jegito, Jiisasnoŋ borianoŋ meŋ kobibiiro waama nano. ");
INSERT INTO ksr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kaeŋ nano Jiisasnoŋ miri uutanoŋ uro gowokourutanoŋ aŋgiodeeŋ rama kokaeŋ qisiŋ mugi, “Nononoŋ mono naambaajoŋ ii nononanodeeŋ otaawombaajoŋ amamaajoŋa?” ");
INSERT INTO ksr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Qisiŋ mugi kokaeŋ iŋijoro, “Ome tania kaaŋa ii mono qama kooliŋ nene siŋgi laligoŋ saanoŋ otaawoŋa. Iwoi morota moŋ aniŋ mende kouma kembaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jiisasnoŋ gowokouruta yoŋowo gomaŋ baloŋ ii mesaoŋ kema Galili prowins uutanoŋ liligoŋ naa gomanoŋ laligogiti, ii moŋnoŋ mobaatiwaajoŋ togoro. ");
INSERT INTO ksr_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ii togoŋ gowokouruta kuma oŋomambaajoŋ oloŋ keŋgi. Kananoŋ kema qaa kota kokaeŋ iŋijoro, “Anutunoŋ Siwe gomambaa Eja hoŋa ii baloŋ ejemba yoŋoo borogianoŋ ano kemebaa. Kemero ii qegi komuwaa. Ii qegi komuro roŋ koŋgi weeŋ karooŋ kolooro koomunoŋga waabaa.” ");
INSERT INTO ksr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Qaa kota kaeŋ iŋijoroto, ii mende moma asarigi ano kania nomaeŋ, ii qisiwombaajoŋ kokodunduŋ aŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kaeŋ kema Kaperneam taonoŋ kougi. Kanoŋ kouma iyaŋaa miri uutanoŋ uma gowokouruta kokaeŋ qisiŋ oŋono, “Oŋo kananoŋ kaŋ naa qaaga amiŋ mojuya?” ");
INSERT INTO ksr_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yoŋonoŋ kananoŋ kaŋ ‘Moronoŋ uuta kolooja?’ jeŋ ii aŋgiodeeŋ amiŋ moma kagi. Kawaajoŋ qisiŋ oŋono qaagia bogoro ragi. ");
INSERT INTO ksr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Qaa bogoro ragi Jiisasnoŋ kemeŋ rama gowokouruta 12 oŋoono kagi kokaeŋ iŋijoro, “Moŋnoŋ uuta laligomambaajoŋ mobaati eeŋ, iinoŋ mono kuuya oŋoo newo baagianoŋ kamaaŋqeqeta kolooŋ tosaaŋa kuuya weleŋ qeŋ oŋomakeba.” ");
INSERT INTO ksr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kaeŋ iŋijoŋ naamade melaa moŋ meŋ batugianoŋ ano nano. Nano borianoŋ meŋ tawoyanoŋ ama kokaeŋ iŋijoro, ");
INSERT INTO ksr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Moŋnoŋ naamade koi kaaŋa moŋ noo qananoŋ mirianoŋ koma horoŋ kalaŋ kombaati, iinoŋ mono nii koma horoŋ nombaa. Moŋnoŋ kaeŋ ama nombaati, iinoŋ niigadeeŋ qaagoto, moŋ wasiŋ nonoti, mono ii kaaŋagadeeŋ koma horoŋ mubaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jonoŋ Jiisas kokaeŋ ijoro, “Boi, nononoŋ eja moŋ ananawo mende liligoŋkeji, iinoŋ goo qanoŋ omejiilaŋ konjoma oŋono iiniŋ. Iinoŋ nonowo mende qokotaaŋ laligoŋkejiwaajoŋ ama nono ii qotogoŋ muniŋ.” ");
INSERT INTO ksr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kaeŋ ijoro Jiisasnoŋ jero, “Ii mono mende qotogoŋ mubu. Moŋnoŋ noo qana qama aŋgoleto meji, iinoŋ mono iikawaa gematanoŋ noo gemaqeqe qaa afaaŋkota jemambaajoŋ amamaawaa. ");
INSERT INTO ksr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Moŋnoŋ mende qotogoŋ nonomakeji, iinoŋ mono ananaa areŋnoŋ laligoja. (Kawaajoŋ noo alauruna tosia ii aŋgosisiri mende meŋ oŋombu.) ");
INSERT INTO ksr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ii mono naŋgoŋ oŋoŋgi Anutunoŋ iikawaa turuŋa oŋombaa. Moŋnoŋ Kraistwaa qatanoŋ iwaa buŋa koloojutiwaajoŋ ama apu qambi newutiwaa oŋombaati, Anutunoŋ mono iikawaa turuŋa meleema mubaa. Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Naŋgoŋ oŋombuti, iyoŋonoŋ mono turuŋa mewuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jiisasnoŋ qaa kokaeŋ jero, “Merabora koi kaaŋa moma laariŋ nonjuti, moŋnoŋ iyoŋoonoŋga moŋ koŋgoroya ama muro siŋgisoŋgo ambaati, eja iikanoŋ mono lombo uuta mokoloowaa. Anutunoŋ lombo iikawaa iroŋa mono nomaeŋ muro soyanoŋ koloonaga? Kemuŋ kowonjiŋ aroyanoŋ somoŋgoŋ kowe biiwianoŋ giligi menduŋgoro kemebabo, iikanoŋ mono afaaŋa kolooŋ muro tani koloonaga. ");
INSERT INTO ksr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kawaajoŋ boroganoŋ siŋgisoŋgo ambaatiwaa koŋgoroya ama gombaati eeŋ, ii mono kotoŋ giliwa. Kotoŋ giliŋgo borodomoŋ laligoŋ laaligo kombombaŋa mokolooŋ oompeleleŋ mokoloowagato, boroga woiwo laligoŋ kanageŋ gere sianoŋ kemebabo. Sia gereya ii kambaŋ moŋnoŋ mende bogowaa. ");
INSERT INTO ksr_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Iikanoŋ ‘Doonoŋ selegia utoqutooŋ keema kougi mende komuwuya ano je geregianoŋ kambaŋ moŋnoŋ mende bogowaa.’ ");
INSERT INTO ksr_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Kaaŋagadeeŋ kanaganoŋ siŋgisoŋgo ambaatiwaa koŋgoroya ama gombaati eeŋ, ii mono kotoŋ giliwa. Kotoŋ giliŋgo kanadomoŋ laligoŋ laaligo kombombaŋa mokolooŋ oompeleleŋ mokoloowagato, kanaga woiwo laligona gere sianoŋ giligi kemebabo. ");
INSERT INTO ksr_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Iikanoŋ ‘Doonoŋ selegia utoqutooŋ keema kougi mende komuwuya ano je geregianoŋ kambaŋ moŋnoŋ mende bogowaa.’ ");
INSERT INTO ksr_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Kaaŋiadeeŋ jaaganoŋ siŋgisoŋgo ambaatiwaa koŋgoroya ama gombaati eeŋ, ii mono qonjoma giliwa. Qonjoma giliŋgo jaako motooŋgowo laligoŋ Anutuwaa bentotonoŋ keuma oompeleleŋ mokoloowagato, jaakoga woiwo laligona gere sianoŋ giligi kemebabo. ");
INSERT INTO ksr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Iikanoŋ ‘Doonoŋ selegia utoqutooŋ keema kougi mende komuwuya ano je geregianoŋ kambaŋ moŋnoŋ mende bogowaa.’ ");
INSERT INTO ksr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Gere sia iikanoŋ ejemba kuuya ii sii kaaŋa gere bolanoŋ dalasisi oŋoogi siimboboloya mobuya. ");
INSERT INTO ksr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Sii ii awaa koloojato, siinoŋ naaŋa mesaowaati eeŋ, ii mono nomaeŋ meagogi naaŋa mombo koloonaga? Oŋo kaaŋiadeeŋ uumotooŋgo laaligowaa aiŋa mesaowubo. Kawaajoŋ Siwe siigia mesaowubotiwaajoŋ mono galeŋgia meŋ batugianoŋ luae qeŋ aoŋ laligowu.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jiisasnoŋ waama Kaperneam gomaŋ mesaoŋ Jordan apu kotoŋ leegeŋ kema metetereeŋ kamaaŋ mombo apu ii kotoŋ Judia prowinsnoŋ karo. Karo ejemba tuuŋlelembenoŋ mombo iwaanoŋ ajoroogi ama laligoroti, iikawaa so mombo kuma oŋono. ");
INSERT INTO ksr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kuma oŋono Farisii (Kana qaawaa kaparaŋkoŋkoŋ) tosianoŋ iwaanoŋ kaŋ qaawaa timbinoŋ horowombaa aŋgobato meŋ muŋ kokaeŋ qisiŋ mugi, “Ejanoŋ embia mesaowaati eeŋ, iikanoŋ Kana qaa uuguwaa me qaago?” ");
INSERT INTO ksr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Qisiŋ mugi meleema kokaeŋ iŋijoro, “Moosesnoŋ iikawaa qaaya nomaeŋ jeŋ kotoŋ oŋonota eja?” ");
INSERT INTO ksr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kaeŋ iŋijoro kokaeŋ ijogi, “Ejanoŋ mesaoŋ aoao papia ooŋgo embia saanoŋ mesaowaa. Moosesnoŋ kaeŋ jeŋ kotorota eja.” ");
INSERT INTO ksr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Kaeŋ ijogi kokaeŋ jeŋ oŋono, “Iinoŋ mono uugia kotigaajoŋ ama jeŋkooto kaeŋ ooŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ooŋ oŋonoto, Anutunoŋ kanakanaiyanoŋ ilawoila kuuya mokolooroti, kambaŋ iikanondeeŋ ‘Eja ano emba laligowutiwaajoŋ mokolooŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kawaajoŋ ejanoŋ mono nemuŋmaŋa oromesaoŋ embiaanoŋ kema qokotaaro ");
INSERT INTO ksr_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","yoronoŋ sele motooŋgo kolooŋ laligowao. Kaeŋ kolooŋ toroqeŋ woi mende koloojaoto, sele motooŋgo kolooŋ laligowao. ");
INSERT INTO ksr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Anutunoŋ eja ano emba mindiriŋ oronoti, ejemba moŋnoŋ ii mono mende mendeema oromba.” ");
INSERT INTO ksr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jiisasnoŋ kaeŋ jeŋ oŋoma miri uutanoŋ uro gowokourutanoŋ qaa iikawaajoŋ mombo qisiŋ mugi. ");
INSERT INTO ksr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Qisiŋ mugi kokaeŋ iŋijoro, “Eja moŋnoŋ embia otaaŋ emba moŋ mewaati, iinoŋ mono oloŋkalu serowiliŋ ambaa. ");
INSERT INTO ksr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kaaŋagadeeŋ emba moŋnoŋ loya otaaŋ eja moŋ mewaati, iinoŋ mono oloŋkalu serowiliŋ ambaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ejemba tosianoŋ merabora boloboolo uŋuama Jiisasnoŋ oŋoosiriwaatiwaajoŋ iwaanoŋ kagito, gowoko yoŋonoŋ ejemba ii jeŋ qewagoŋ oŋoŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kaeŋ aŋgito, Jiisasnoŋ ii iima uuta boliro kokaeŋ iŋijoro, “Merabora melaa mono oŋomesaogi noonoŋ kawu. Anutunoŋ ejemba kaaŋa ii bentotoŋa buŋa qeŋ oŋombaa. Kawaajoŋ ii mende somoŋgoŋ oŋombu. ");
INSERT INTO ksr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Moŋnoŋ Anutuwaa bentotoŋa ii merabora kaaŋa buŋa mende qeŋ aowaati, iinoŋ mono iikawaa uutanoŋ keumambaa amamaawaa.” ");
INSERT INTO ksr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kaeŋ jeŋ tawoyanoŋ ama dooŋgoŋ oŋoma boria waŋgianoŋ ama kotuegoŋ oŋono. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jiisasnoŋ kanaiŋ kana kemambaa ano eja moŋnoŋ bobogariŋ iwaanoŋ karo. Kaŋ batanoŋ kemeŋ simiŋ kuma kokaeŋ qisiŋ muro, “Boi awaa, niinoŋ mono nomaeŋ ama laaligo kombombaŋa buŋa qeŋ aowenaga?” ");
INSERT INTO ksr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Qisiŋ muro kokaeŋ ijoro, “Noojoŋ ‘Boi awaa,’ ii naambaajoŋ jejaŋ? Anutu motooŋgoyanoŋ awaa kolooja. Eja moŋnoŋ ii kaaŋa awaa mende kolooja. ");
INSERT INTO ksr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Gii jojopaŋ qaa koi modaborojaŋ: ‘Moŋ mono mende qena komuwa. Serowiliŋ mono mende amba. Iwoi mono yoŋgoro mende mewa. Jenoŋkuukuu mono mende ama muba. Mono kalugoŋ yoŋgoro mende mewa. Nemuŋ maŋga mono goda qeŋ oromakeba.” ’ ");
INSERT INTO ksr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kaeŋ ijoro moma kokaeŋ jero, “Boi, ii kuuya mono gbaworonanoŋga teŋ koma laligoŋ waabe.” ");
INSERT INTO ksr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Kaeŋ jero Jiisasnoŋ uuŋ iima uuwomboyanoŋ jopagoŋ muŋ kokaeŋ ijoro, “Gii mono motooŋgonoŋ amamaajaŋ: Gii mono kema esuhinaga kuuya sewaŋa mewutiwaajoŋ ana moneŋ karo ejemba wanaya oŋomba. Kaeŋ ana esuhinaga somata totooŋ (milyon Kina kaaŋa) ii Siwe gomanoŋ eŋ gombaa. Kaeŋ ama nii notaaŋ kawa.” ");
INSERT INTO ksr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jiisasnoŋ kaeŋ ijoroto, esuhinaya mamaga erotiwaajoŋ ama qaa ii moma uuta bosoleero wosobiri moma eeŋ mesaoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Mesaoŋ keno Jiisasnoŋ uuro kema karo gowokouruta kokaeŋ iŋijoro, “Oyei! Ejemba moneŋ hinagiawo yoŋonoŋ mono Anutuwaa bentotonoŋ keubombaajoŋ bimooŋ kupukapa kombuya.” ");
INSERT INTO ksr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kaeŋ iŋijoro gowoko yoŋonoŋ ii moma waliŋgogito, Jiisasnoŋ toroqeŋ kokaeŋ iŋijoro, “Guaŋuruna, ejemba daeŋ yoŋonoŋ moneŋ hinagia moma laariŋkejuti, iyoŋonoŋ mono Anutuwaa bentotoŋ uutanoŋ keubombaajoŋ bimooŋ kupukapa kombuya. ");
INSERT INTO ksr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ii kokaeŋ jeŋ asarimaŋa: Oro somata kamel ii sosoro ootanoŋ saanoŋ mende keubaa. Iikawaa so ejemba qabuŋagiawo yoŋonoŋ Anutuwaa bentotoŋ uutanoŋ keubombaajoŋ bimooŋ amamaawuya.” ");
INSERT INTO ksr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kaeŋ iŋijoro moma aaruŋ tililiŋgoŋ iyaŋgiaajoŋ kokaeŋ jegi, “Oopopooŋ! Ejemba moronoŋ mono Siwewaa buŋa koloonaga?” ");
INSERT INTO ksr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Kaeŋ jegi Jiisasnoŋ uuŋ iŋiima kokaeŋ jero, “Ejembanoŋ ii aŋgobato meŋ osiŋ amamaaŋkejuto, Anutunoŋ kaeŋ mende amakeja. Anutunoŋ mono iwoi kuuya saanoŋ amakeja. Iinoŋ iwoi moŋ ama memambaajoŋ mende osiŋ amamaaŋkeja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Piitonoŋ qaa ii moma meleema Jiisas kokaeŋ ijoro, “Moba, nononoŋ ilawoila kuuya mesaoŋ gii gotaaŋ kaniŋ.” ");
INSERT INTO ksr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ii moma Jiisasnoŋ kokaeŋ ijoro, “Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Moŋnoŋ noo ano Oligaa Buŋawaajoŋ ama iwoi moŋ mesaoroti, ii jigo miria, dakoga, naambeeta, nemuŋmaŋa, meraborata me gawoŋ molaleŋa ii oŋomesaoro Anutunoŋ mono iikawaa tawaya uuguŋ meleema muro seiwaa. ");
INSERT INTO ksr_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Moŋnoŋ iwoi ii mesaoroti, Anutunoŋ mono tawaya ii 100:waa so toroqeŋ muro iyaŋaa buŋa koloowaa. Balombaa laaligonoŋ sisiwerowero uutanoŋ laligowaato, jigo miri, dako, naambee, nemuŋmaŋ, merabora ano gawoŋ molaleŋa ii mono kitianoŋ kolooŋ mubaa ano kambaŋ kanageŋanoŋ laaligo komboŋa tetegoya qaa buŋa qeŋ aowaa. ");
INSERT INTO ksr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kaeŋ koloowaato, uuta oŋoonoŋga mamaganoŋ kamakamaata koloowuya ano kamakamaata yoŋoonoŋga mamaganoŋ uuta koloowuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jiisasnoŋ gowokouruta yoŋowo Jerusalem sitinoŋ ubombaajoŋ baloŋ kana keŋgi. Jiisasnoŋ wala keno gowokourutanoŋ gematanoŋ kema waliŋgogi ano ejemba gemagianoŋ kagiti iyoŋonoŋ mono toroko mogi. Kaeŋ aŋgi Jiisasnoŋ gowokouruta 12 ii mombo horoŋ oŋoma kanaiŋ kuma oŋono. Iwaanoŋ iwoi koloowaati, qaa ii jeŋ asariŋ kokaeŋ iŋijoro, ");
INSERT INTO ksr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Mobu, anana mono Jerusalem uboŋa. Iikanoŋ moŋnoŋ Siwe gomambaa Eja hoŋa memelolo meŋ muro jigo gawoŋ galeŋ ano Kana qaawaa boi yoŋoo borogianoŋ kemebaa. Yoŋonoŋ komuwaatiwaa qaaya jeŋ tegoŋ waba gawman yoŋoo borogianoŋ oombuya. ");
INSERT INTO ksr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ooŋgi mepaegoŋ sulaapaŋ qeŋ ooli waayawonoŋ qetaaliŋ taluŋgowuya. Qetaaliŋ taluŋgoŋ qegi komuwaa. Komuŋ weeŋ karooŋanoŋ koomunoŋga waabaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jiisasnoŋ kaeŋ iŋijoro Zebediwaa merawoita Jeims ano Jon yoronoŋ iwaanoŋ kema kokaeŋ ijori, “Boi, noronoŋ iwoi mombaajoŋ welema gonjoti, ii norombagiwaajoŋ mojo.” ");
INSERT INTO ksr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ijori qisiŋ orono, “Oronoŋ naa iwoi ama oromaŋatiwaajoŋ mojao?” ");
INSERT INTO ksr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Qisiŋ orono kokaeŋ ijori, “Giinoŋ saanoŋ jeŋ kotona noro goo asamararanoŋ eu uma moŋnoŋ boro dindiŋganoŋ ano moŋnoŋ boro qaniganoŋ rama iwoi kuuya galeŋ kombonaga.” ");
INSERT INTO ksr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kaeŋ ijorito, Jiisasnoŋ kokaeŋ irijoro, “Oronoŋ iikawaa kania mende moma yagoŋ welenjao. Niinoŋ qambi aasoŋawo nemaŋati, oronoŋ ii saanoŋ neŋ siimbobolo mobaota me qaago? Joŋkowororo noŋgbanoŋ mulu meŋ nombuti, oronoŋ ii mewao me qaago?” ");
INSERT INTO ksr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Irijoro moma jeri, “Ii saanoŋ mewota.” Jeri kokaeŋ irijoro, “Ii oŋanoŋ. Niinoŋ qambi aasoŋawo nemaŋati, oronoŋ ii kaaŋiadeeŋ newaota ano joŋkowororo noŋgbanoŋ mulu meŋ nombuti, iikanoŋ mono oro kaaŋagadeeŋ mulu meŋ orombuya. ");
INSERT INTO ksr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Meŋ orombuto, noo boro dindinanoŋ me qaninanoŋ moronoŋ rabaati, niinoŋ qaa ii jeŋ kotomaŋatiwaa so qaago. Anutunoŋ duŋ woi ii daeŋ yoroojoŋ mozozoŋgoroti, ii mono iyoroojoŋ orono niwo rama iwoi kuuya galeŋ komakeboŋa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jeims Jon yoronoŋ kaeŋ weleni alauruta 10 yoŋonoŋ ii moma kanaiŋ uubologa mogi. ");
INSERT INTO ksr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kaeŋ mogito, Jiisasnoŋ oŋoono kagi kokaeŋ iŋijoro, “Namowaa kantria kantria yoŋoo jawiŋgianoŋ galeŋ koma oŋomboŋatiwaajoŋ jejuti, iyoŋonoŋ mono eja poŋ taniŋaeŋ ama oŋomakeju. Yoŋoo somatagianoŋ mono qaa jeŋ kotoŋ ejemba mindiŋgoŋ oŋoma ku-usuŋgia qendeemakeju. Oŋo kaniagia ii saanoŋ moju. ");
INSERT INTO ksr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Oŋoo batugianoŋ sili iikaaŋa koloowaboto, moŋnoŋ oŋoo batugianoŋ somatagia koloomambaajoŋ moji, iinoŋ mono weleŋ qeŋ oŋoma laligowa. ");
INSERT INTO ksr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kaaŋagadeeŋ moŋnoŋ oŋoo batugianoŋ uuta laligomambaa moji, iinoŋ mono kuuya oŋoo newo baagianoŋ laligoŋ weleŋqeqegia omaya koloowa. ");
INSERT INTO ksr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Siwe gomambaa Eja hoŋanoŋ mono kaaŋagadeeŋ sili kaaŋa qendeema iyaŋa weleŋ qeŋ mubutiwaajoŋ ama mende kamaaroto, weleŋ qeŋ oŋoma ejemba kuuya oŋoo dowegia memambaajoŋ ama kamaarota laaligoya qeleema mesaowaa.” ");
INSERT INTO ksr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jiisasnoŋ gowokouruta yoŋowo Jeriko sitinoŋ kagi. Kaŋ siti ii mesaowombaajoŋ aŋgi ejemba tuuŋlelembenoŋ oŋotaaŋ gemagianoŋ kagi. Kaeŋ kagi jaagoo eja qata Bartimeus, Timeuswaa meria iinoŋ moneŋ ano nene mubutiwaajoŋ welema oŋoma kana goraayanoŋ raro. ");
INSERT INTO ksr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Raro “Nazaret eja Jiisas kaja,” jegi moma kanaiŋ kokaeŋ qaro, “Jiisas Deiwidwaa gbilia, mono kiaŋkomuŋ nomba!” ");
INSERT INTO ksr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kaeŋ qaro mamaganoŋ qaa bogoro rabaatiwaajoŋ qotogoŋ mugito, iinoŋ kaparaŋ koma qaro. “Deiwidwaa gbilia, giinoŋ mono kiaŋkomuŋ nomba!” ");
INSERT INTO ksr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Qaro Jiisasnoŋ moma doroŋ ama kokaeŋ jero, “Saanoŋ qagi koi kawa.” Kaeŋ jero jaagoo eja ii qama kokaeŋ ijogi, “Goojoŋ qaja. Kawaajoŋ mono satiiŋ qena kamaaro waama kawa.” ");
INSERT INTO ksr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ii moma malekuya qetegoŋ giliŋ porasak waama nama Jiisaswaanoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Keno kokaeŋ qisiŋ muro, “Alana, niinoŋ naa iwoiga ama gomaŋatiwaajoŋ mojaŋ?” Kaeŋ qisiŋ muro jaagoo ejanoŋ jero, “Somatana, nii jaana mombo uumambaajoŋ mojeŋ.” ");
INSERT INTO ksr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kaeŋ jero Jiisasnoŋ kokaeŋ ijoro, “Momalaariganoŋ mono meŋ qeaŋgoŋ gonja. Mono saanoŋ kemba.” Kaeŋ ijoro jaa kota iikanondeeŋ tooro uuŋ gemagianoŋ Jiisas otaaŋ keno. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jiisasnoŋ gowokouruta yoŋowo Jerusalem siti dodowiŋ Betfage ano Betani gomaŋ woi kosogaranoŋ kaŋ Oil gere baaŋanoŋ uma gowokowoita woi wasiŋ oromambaajoŋ ama ");
INSERT INTO ksr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","kokaeŋ irijoro, “Gomaŋ bagiaageŋ raji, mono iikanoŋ kembao. Kema iikanoŋ keuma doŋgi melaa kasanoŋ somoŋgogi nanji, ii iikanondeeŋ mokoloowaota. Ii doŋgi sagbiliaga, eja moŋnoŋ qaganoŋ mende rarataga. Ii mono isama meŋ koi kawao. ");
INSERT INTO ksr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Aisni moŋnoŋ ‘Naambaajoŋ kaeŋ anjao?’ jeŋ qisiŋ orono kokaeŋ ijowao, ‘Poŋnaranoŋ iikawaajoŋ amamaaŋ jero kajota kambaŋ mende koriro mombo meleeno kawaa.” ’ ");
INSERT INTO ksr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kaeŋ irijoŋ wasiŋ orono kema doŋgi sagbilia kana goraayanoŋ miri mombaa nagu qaa ootanoŋ kasanoŋ somoŋgogi nano mokolooŋ isani. ");
INSERT INTO ksr_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Aisni eja tosia iikanoŋ naŋgiti, iyoŋonoŋ iriima kokaeŋ qisiŋ oroŋgi, “Hei, nomaeŋ nambojeŋ doŋgi melaa isanjao?” ");
INSERT INTO ksr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kaeŋ qisiŋ oroŋgi Jiisasnoŋ irijorotiwaa so jeri moma “Saanoŋ meŋ kembao,” jegi. ");
INSERT INTO ksr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jegi meŋ Jiisaswaanoŋ kari malekugia qetegoŋ doŋgi melaawaa qaganoŋ aŋgi uma raro. ");
INSERT INTO ksr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kaaŋ rama keno ejemba jaasooŋgoyanoŋ goda qeŋ malekugia qetegoŋ kana somatanoŋ tamboŋgi tosianoŋ baloŋ korianoŋ kema gere seŋa memburatiŋ tamboŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tamboŋgi ejemba wala koma horoŋ keŋgiti ano gematanoŋ otaaŋ kagiti, iyoŋonoŋ kokaeŋ jeŋ qagi, “Hoosana! Oowe oowe! Anutu mepeseejoŋ. Pombaa qatanoŋ kawaati, Anutunoŋ mono ii kotuegoŋ muba. ");
INSERT INTO ksr_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ambonana Kiŋ Deiwidnoŋ kantri totoŋ koma galeŋ koma oŋonoti, kambaŋ iikaaŋanoŋ mono mombo kaŋ nononja. Oo Anutu mono kantri totonana kotuegowa. Hoosana! Qabuŋaga mepeseeniŋ euwaa euyanoŋ uja. Oowe oowe!” ");
INSERT INTO ksr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kaeŋ qagi Jerusalem sitinoŋ uma jiwowoŋ jigowaa totoŋ uutanoŋ keno. Iikanoŋ liligoŋ ilawoila kuuya iiro mare kolooro kamaaŋ gowokouruta 12 yoŋowo jigo mesaoŋ Betani gomanoŋ kema egi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Eŋ umugawodeeŋ waama gowokouruta yoŋowo Betani gomaŋ mesaoŋ keŋgi Jiisasnoŋ nenewaa komuro. ");
INSERT INTO ksr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nenewaa komuŋ uuro keno fig gere moŋ seŋawo nano iiro. Iima “Seŋa uutanoŋ hoŋa raro mokolooŋ newenaga,” jeŋ fig gerewaa kanianoŋ keno. Kenoto, hoŋaa kambaŋanoŋ mende torirotiwaajoŋ seŋagadeeŋ nano iiro. ");
INSERT INTO ksr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kaeŋ iima gere ii kokaeŋ jeŋ muro, “Moŋnoŋ mono hoŋga mombo mende newa.” Kaeŋ jeŋ muro qaa ii gowokourutanoŋ mogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kema laligoŋ Jerusalem sitinoŋ ugi Jiisasnoŋ jiwowoŋ jigowaa totoŋ uutanoŋ keno. Iikanoŋ ejemba iŋiiro esuhina sewaŋa mewutiwaajoŋ aŋgi sewaŋa megiti, ii kanaiŋ konjoma oŋono kamaagi. Moneŋ utekute ejemba yoŋoo raragia metaama meleeno keŋgi. Kaaŋagadeeŋ kewo sewaŋgia mewutiwaajoŋ aŋgiti, iyoŋoo duŋ raragia ii kaaŋiadeeŋ riitano keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Sombeŋ kowoga kotoŋ iwoi elaaŋ keuma kaamawaa kania ii somoŋgoro. ");
INSERT INTO ksr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Iikaeŋ ama kuma oŋoma kokaeŋ iŋijoro, “Aisaianoŋ qaa moŋ kokaeŋ oorota eja, ‘Noo jigonanoŋ mono gomaŋa gomaŋa kuuya yoŋoo qamakooli miri koloowaatiwaajoŋ qabu.’ Qaa ii ejato, oŋonoŋ ii utegogi kikekakasililiŋ eja yoŋoo kobaa kaaŋa kolooja.” ");
INSERT INTO ksr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kaeŋ iŋijoro ejemba tuuŋ kuuya yoŋonoŋ iikawaajoŋ newogia tegoro waliŋgogi. Kawaajoŋ jigo gawoŋ galeŋ ano kana qaawaa boi yoŋonoŋ ii moma Jiisaswaajoŋ toroko moma amiŋ moma kokaeŋ jegi, “Ii mono nomaeŋ jeniŋ qegi komunaga?” ");
INSERT INTO ksr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mare kolooro Jiisasnoŋ gowokouruta yoŋowo siti mesaoŋ seleeŋgeŋ kema egi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Eŋ umugawodeeŋ waama kananoŋ kema fig gere ii uuguwombaajoŋ ama gere ii iigi tiitawo gororoŋgoŋ nano. ");
INSERT INTO ksr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nano Piitonoŋ Jiisaswaanoŋ qaa romoŋgoŋ kokaeŋ ijoro, “Somatana iiba, fig gere qasuaanati, ii mono gororoŋgoŋ nanja.” ");
INSERT INTO ksr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ijoro Jiisasnoŋ kokaeŋ meleeno, “Anutu momalaariŋ ii mono pondaŋ meŋ laligowu.” ");
INSERT INTO ksr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu, “Moŋnoŋ qaayaa hoŋa koloowaatiwaajoŋ uuwoi mende moma baaŋa kokawaa toyaajoŋ kokaeŋ jeŋ kotonaga, ‘Mono baaŋa koi qetegoŋ waama kema kowenoŋ amba.’ Kaeŋ jeŋ kotoŋ Anutu moma laariro hoŋa mono iikawaa so koloowaa. ");
INSERT INTO ksr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kawaajoŋ niinoŋ kokaeŋ iŋijowe mobu: Naa iwoiwaajoŋ qisiŋ qama kooliwuti, ii kuuya buŋa qeŋ aodaborojoŋi, iikaeŋ moma laarigi mono buŋagia koloowaa. ");
INSERT INTO ksr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Oŋo nama Anutu qama kooligi moŋnoŋ aliaa koposowaajoŋ uubologa mobaati eeŋ, koposoya ii mono mesaowu. Kaeŋ ambuti eeŋ, oŋoo Maŋgia Siwe gomanoŋ laligoji, iinoŋ mono kaaŋiadeeŋ oŋoo siŋgisoŋgogia mesaowaa. ");
INSERT INTO ksr_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(Oŋo tosaaŋa yoŋoonoŋ siŋgisoŋgo mende mesaowuti eeŋ, oŋoo Maŋgia Siwe gomanoŋ laligoji, iinoŋ mono kaaŋiadeeŋ oŋoo siŋgisoŋgogia mende mesaowaa.)” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jiisasnoŋ gowokouruta yoŋowo mombo Jerusalem sitinoŋ ugi. Uma jiwowoŋ jigowaa totoŋ uutanoŋ kema karo jigo gawoŋ galeŋ, kana qaawaa boi ano kantriwaa jotamemeya tosaaŋa yoŋonoŋ iwaanoŋ kougi. ");
INSERT INTO ksr_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Kouma kokaeŋ qisiŋ mugi, “Gii kokanoŋ iwoi anjaŋi, ii mono moronoŋ jeŋ kotoŋ gono amakejaŋ? Ii mewagiwaa ku-usuŋa ii mono moronoŋ gono?” ");
INSERT INTO ksr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Qisiŋ mugi kokaeŋ meleema oŋono, “Niinoŋ kaaŋagadeeŋ qaa moŋ qisiŋ oŋomaŋa. Ii meleema noŋgi niinoŋ kaaŋagadeeŋ moronoŋ ku-usuŋ nono ilawoila koi amakejeŋi, ii iŋijomaŋa. ");
INSERT INTO ksr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jonoŋ ejemba oomulu meŋ oŋoma laligoroti, iinoŋ iikawaa ku-usuŋa ii dakaya mero? Siwe Toyanoŋ muro me boloŋ toyanoŋ mugi? Ii mono nijowu.” ");
INSERT INTO ksr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kaeŋ meleema oŋono batugianoŋ amiŋ moma kokaeŋ jegi, “‘Ku-usuŋanoŋ Siwenoŋga asugiro,’ kaeŋ jewoŋati eeŋ, iinoŋ mono kokaeŋ jewaa: ‘Oŋonoŋ mono naambaajoŋ Jon mende moma laariŋ mugi?’ Ii mende sokonja. ");
INSERT INTO ksr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Me ‘Baloŋ ejemba yoŋoonoŋga asugiro,’ jewonaga? Ii mende sokonja.” Ejemba kuuyanoŋ Jombaajoŋ ‘Oŋanoŋ gejatootoo ejaga kolooja,’ jegitiwaajoŋ ama ejemba tuuŋ yoŋoojoŋ toroko moma ii jewombaajoŋ amamaagi. ");
INSERT INTO ksr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kawaajoŋ “Ii mende mojoŋ,” meleeŋgi. Kaeŋ meleeŋgi Jiisasnoŋ kokaeŋ iŋijoro, “Kaeŋ ano niinoŋ kaaŋagadeeŋ ilawoila koi amakejeŋiwaa ku-usuŋa moronoŋ nonoti, ii mende iŋijomaŋa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jiisasnoŋ kanaiŋ ejemba sareqaanoŋ kokaeŋ iŋijoro, “Eja moŋnoŋ wain kasa gawoŋ moŋ koma komoro. Koma komoma sopaya meŋ liligoro. Meŋ liligoŋ wain juu somata jamonoŋ mero. Iikanoŋ waimbaa hoŋa ama kananoŋ risuaagi apuyanoŋ lalanoŋ kemero. Wain juu somata ii meŋ wain yoŋgoro mewubotiwaajoŋ galeŋ meme jake koriga kowiawo mero. Iwoi kuuya medaboroŋ wain gawoŋ galeŋ tosaaŋa mokolooŋ oŋoma kokaeŋ iŋijoro, ‘Mono gawoŋ meŋ hoŋaa bakaya oŋoaŋgia meŋ bakaya toya nii nombu.’ Kaeŋ jeŋ somoŋgoŋ gawoŋ ii borogianoŋ ama oŋomesaoŋ kantri moŋnoŋ kema laligoro. ");
INSERT INTO ksr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Laligoŋ laligoro hoŋa momogorotiwaa kambaŋa (gbani 5) toriro iikanoŋ weleŋqeqeya moŋ wasiŋ muro galeŋ yoŋoonoŋ kema wain gawoŋ hoŋaa bakaya mubutiwaajoŋ jero. ");
INSERT INTO ksr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Jeroto, galeŋ yoŋonoŋ ii meŋ somoŋgoŋ koobinoŋ qeŋ otaagi bobora eleeno. ");
INSERT INTO ksr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kawaa gematanoŋ weleŋ eja moŋ wasiro yoŋoonoŋ keno waŋa qosoma gamu qeŋ mugi. ");
INSERT INTO ksr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kawaa gematanoŋ weleŋ eja moŋ mombo wasiro keno qegi komuro. Kaaŋiadeeŋ eja tosaaŋa mamaga wasiŋ oŋono tosia koobinoŋ sagorogoro uŋuŋ tosia uŋugi komugi. ");
INSERT INTO ksr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kaeŋ aŋgi wain gawoŋ toyanoŋ qaa moŋgama jero, ‘Neenaa wombo merana motooŋgo iikayadeeŋ laligoja. Ii mono goda qeŋ mubuya me nomaeŋ?’ Kaeŋ jeŋ konoga kiaŋ meria wasiro yoŋoonoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kenoto, karo iima batugianoŋ kokaeŋ jegi, ‘Iinoŋ mono borosamoya kokawaa toya koloowaa. Ayo, mono meŋ qeniŋ komuro wain kasa gawoŋ kokanoŋ mono ananaa buŋa koloowaa.’ ");
INSERT INTO ksr_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kaeŋ jeŋ qelanjiŋ meŋ somoŋgoŋ qegi komuro qamoya gawoŋ sopa seleeŋgeŋ hagogi kemero. ");
INSERT INTO ksr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Wain gawoŋ toyanoŋ ii moma mono nomaeŋ ambaa? Iinoŋ mono aŋo kaŋ gawoŋ galeŋ ii kondeema oŋombaa ano gawoŋ galeŋ dologa mokolooŋ oŋoma wain kasa gawoŋa ii yoŋoo borogianoŋ ambaa. ");
INSERT INTO ksr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Buŋa Terenoŋ qaa koi weeŋgogi me qaago? ‘Miri meme yoŋonoŋ jamo tando moŋ gema qeŋ eeŋ mesaogi raroti, iikanoŋ mono tando kombombaŋa kolooro mokoloogi. Iikanoŋ riiro mirinoŋ mono riima kamaaŋ kombaa. ");
INSERT INTO ksr_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Poŋnoŋ tando ii kuuro jaanananoŋ iiniŋ qabuŋayawo kolooro waliŋgoŋkejoŋ.” ’ ");
INSERT INTO ksr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jiisasnoŋ kaeŋ iŋijoro galeŋ yoŋonoŋ qaa iikawaa kania moma asariŋ kokaeŋ jegi. “Sareqaa ii mono nonoojoŋa jeja.” Kawaajoŋ ii meŋ somoŋgowombaajoŋ mogito, ejemba tuuŋlelembe yoŋoojoŋ toroko moma amamaaŋ mesaoŋ keŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Juuda jotamemeya yoŋonoŋ Farisii ano gawana Herodwaa paati alauruta tosia wasiŋ oŋoma kokaeŋ iŋijogi, “Oŋo mono Jiisaswaanoŋ kema qisiŋ qaawaa timbinoŋ horoŋ gbadooŋ mubu.” Kaeŋ iŋijogi Jiisaswaanoŋ kagi. ");
INSERT INTO ksr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jiisaswaanoŋ kaŋ kokaeŋ ijogi, “Boi, giinoŋ eja hoŋa koloojaŋi, nono ii mojoŋ. Giinoŋ ejemba tosia mende iŋisosorooŋ tosia mende qetama oŋomakejanto, so motooŋgonoŋ gosiŋ nonomakejaŋ. Kawaajoŋ kuuŋ goŋgi mende dogoŋ somata mende esuuŋ oŋomakejanto, Anutuwaanoŋ kana ii qaa hoŋa otaaŋ kuma nonomakejaŋ. Giinoŋ Anutuwaanoŋ qaa dindiŋa iikanoŋ uuta ano kamaaŋqeqeta motoondeeŋ kuuya jeŋ mindiŋgoŋ nonomakejaŋ. Kawaajoŋ nono siisa-kimbaajoŋ takis ama iikanoŋ Mooseswaa Kana qaa soŋgiwoŋa me qaago? Ii aniŋ sokonja me qaago?” ");
INSERT INTO ksr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kaeŋ ijogi areŋgia qoloŋmoloŋgoya ii moma kotoŋ kokaeŋ iŋijoro, “Oŋo naambaajoŋ qaawaa timbinoŋ ama nombombaajoŋ aŋgobato meŋ nonju? Saanoŋ silwa moneŋ moŋ meŋ kagi iimaŋ.” ");
INSERT INTO ksr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kaeŋ iŋijoro ii meŋ kagi kokaeŋ qisiŋ oŋono. “Morowaa uŋayaga ano qataga ii koi oogita eja?” “Ii Siisa-kimbaa.” Kaeŋ meleema jegi. ");
INSERT INTO ksr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jegi kokaeŋ iŋijoro, “Kaeŋ kolooro iwoi Siisa-kimbaa uŋayawo ii mono iwaa buŋa muŋkebu. Iwoi Anutuwaa uŋayawo eji, ii mono Anutuwaa buŋa qewu.” Kaeŋ iŋijoro iwaajoŋ mamaga waliŋgogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadusii (Jigo gawombaa kaparaŋkoŋkoŋ) yoŋonoŋ “Komugiti, iyoŋonoŋ mende waabuya,” jeŋ laligogi. Yoŋoonoŋga tosianoŋ Jiisaswaanoŋ kaŋ kokaeŋ qisiŋ mugi, ");
INSERT INTO ksr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Boi, Moosesnoŋ kokaeŋ jeŋ kotoŋ nononota eja, ‘Eja moŋ emba mero merabora mende koloogi komuŋ maloya eeŋ mesaoro koganoŋ saanoŋ maloya ii meŋ gbili mekolooŋ muro dataa qa meŋ laligowaa.’ ");
INSERT INTO ksr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Moba! Kambaŋ moŋnoŋ daremuŋ 7 laligogi. Dagia mutuyanoŋ emba meŋ laligoŋ gbilia qaa eeŋ laligoŋ komuro. ");
INSERT INTO ksr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Komuro koganoŋ maloya ii meŋ laligoŋ kaaŋagadeeŋ gbilia qaa eeŋ komuro. Komuro koga moŋ iwaa gematanoŋ iikanoŋ emba iikayadeeŋ meŋ laligoŋ eeŋ komuro. ");
INSERT INTO ksr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kaaŋadeeŋ daremuŋ 7 kuuya yoŋonoŋ emba motooŋgo iikayadeeŋ meŋ gbilia qaa laligoŋ komudaborogi. Kuuya komugi konoga malogia ii kaaŋiadeeŋ komuro. ");
INSERT INTO ksr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Giinoŋ ‘Komugiti, iyoŋonoŋ gbiliŋ waabuya,’ jejanto, nono ii mende moma laarijoŋ. Moba, eja 7 kuuya ii ororoŋ waabuyagati eeŋ, emba motooŋgo ii embagiaga megi laligorotiwaajoŋ ama mono morowaa embiaga koloonaga?” ");
INSERT INTO ksr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Kaeŋ qisigi Jiisasnoŋ meleema kokaeŋ iŋijoro, “Oŋo qaa jeŋ sooju. Uumeleembaa Buŋa Tereya ano Anutuwaa ku-usuŋa mende moma kotojutiwaajoŋ mono jiŋjauŋ amakeju. ");
INSERT INTO ksr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Oŋanoŋ, koomunoŋga waama kambaŋ iikanoŋ loemba mende koloowuyato, gajoba yoŋonoŋ Siwe gomanoŋ laligojuti kaaŋa kolooŋ laligowuya. ");
INSERT INTO ksr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mobu! Komugiti, iyoŋonoŋ gbiliŋ waabutiwaa qaaya ii Mooseswaa Buknoŋ kokaeŋ eja: Somaŋ bambanoŋ gere bolaŋ asugiŋ mende jeŋ kotoroti, oŋo sundu ii weeŋgogi me qaago? Anutunoŋ iikanoŋ Mooses kokaeŋ ijoro, ‘Niinoŋ Anutu Aabrahambaa Poŋ, Aisakwaa Poŋ ano Jeikobwaa Poŋga laligoŋ waama laligojeŋ.’ ");
INSERT INTO ksr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","“Isi wanjale karooŋ yoŋonoŋ Anutuwo laligoŋ kotiiŋ ubuya. Anutunoŋ koomuya yoŋoo Poŋgia qaagoto, laaligo kombombaŋa laligojuti, mono iyoŋoo Poŋgiaga kolooja. Oo Sadusii (Jigo gawombaa kaparaŋkoŋkoŋ paati) oŋo mono qaa mamaga moma sooŋkeju.” Kaeŋ meleeno. ");
INSERT INTO ksr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jiisasnoŋ Sadusii (Jigo gawombaa kaparaŋkoŋkoŋ) yoŋowo amiŋ moma jeŋ sororogoŋ meleema oŋonoti, ii kana qaawaa boi eja moŋnoŋ moro. Iikaaŋ moma jaasewaŋanoŋ kouma kokaeŋ qisiŋ muro, “Jojopaŋ qaa kuuya iikanoŋga waŋa somata ii nomaeŋ?” ");
INSERT INTO ksr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Qisiŋ muro meleeno, “Waŋa somata ii kokaeŋ, ‘Israel kanageso mobu! Anutunoŋ motooŋgo ananaa Poŋnana kolooja. Beŋsakoŋ iwoi moŋnoŋ qaago. ");
INSERT INTO ksr_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kawaajoŋ uugabaga, uŋaga, roromoŋgoga ano ku-usuŋga kuuya, iikanoŋ mono Poŋ Anutuga uunoŋ jopagoŋ muŋ laligowa.’ ");
INSERT INTO ksr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","“Jojopaŋ qaa iikawaa alia ii kokaeŋ, ‘Geeŋga jopagoŋ aoŋkejaŋi, iikaaŋadeeŋ mono ejemba kuuya jopagoŋ oŋoma laligowa,’ Jojopaŋ qaa moŋnoŋ mono qaa woi ii mende uruuguja.” ");
INSERT INTO ksr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jiisasnoŋ Kana qaawaa boiyaajoŋ kaeŋ meleeno ijoro, “Boi, gii qaa dindiŋa jejaŋ. Anutunoŋ motooŋgo kolooja. Beŋsakoŋ iwoi moŋnoŋ qaago. ");
INSERT INTO ksr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Gii uugabaga, momakootoga kuuya ano ku-usuŋga kuuya, iikanoŋ mono Poŋ Anutuga uujopagoŋ muŋ laligowa. Ano geeŋga jopagoŋ aoŋkejaŋi, iikaaŋadeeŋ mono ejemba kuuya jopagoŋ oŋoma laligowa. Jojopaŋ qaa woi iikanoŋ waŋa somata koloojao. Ii teŋ kombagi, iikanoŋ mono siimoloŋ kuuya ano nanduŋ mamatewoo tosia uŋuuguja.” ");
INSERT INTO ksr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kaeŋ ijoro Jiisasnoŋ uuroromoŋgoya moro sokono kokaeŋ ijoro, “Gii Anutuwaa bentotonoŋ keumambaa dodowijaŋ.” Kaeŋ amiŋ mori ejemba kuuya yoŋonoŋ Jiisas toroqeŋ qisiŋ mubombaajoŋ kokodunduŋ ama mesaogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jiisasnoŋ jiwowoŋ jigonoŋ nama Buŋa qaa kuma oŋoma kokaeŋ qisiŋ oŋono, “Kraistnoŋ kiŋ Deiwidwaa gbiliga kolooji, kana qaawaa boi yoŋonoŋ qaa ii nomaembaajoŋ jeŋkeju? ");
INSERT INTO ksr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Deiwidnoŋ aŋo Uŋa Toroyanoŋ sololooŋ muro kokaeŋ jero, ‘Anutunoŋ nama noo Poŋna kokaeŋ ijoro: Giinoŋ mono kaŋ noo boro dindinanoŋ rana niinoŋ kambaŋ biiwianoŋ kereuruga riiŋ riitama haamo ama oŋoma goo kana baaganoŋ ama oŋomaŋa. Kambaŋ ii kaŋ kuuwaatiwaa so mono asamararanoŋ koi rabaga.’ ");
INSERT INTO ksr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deiwidnoŋ aŋo kaeŋ jeŋ qata ‘noo Poŋna jeja.’ Poŋna jeŋ mono nomaeŋ ama iwaa gbiliga kaaŋagadeeŋ koloonaga?” Kaeŋ jero ejemba tuuŋlelembe yoŋonoŋ Jiisaswaa qaayaa siiŋa moma geja aŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jiisasnoŋ kuma oŋoma toroqeŋ kokaeŋ iŋijoro, “Oŋo mono kana qaawaa boiya yoŋoojoŋ galeŋ meŋ laligowu. Yoŋonoŋ maleku koriga mouma kema kaŋ qendeema oŋombombaajoŋ momakeju ano maaketnoŋ me kananoŋ ejemba iŋiigi joloŋgia jewutiwaajoŋ momakeju. ");
INSERT INTO ksr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Qamakooli miri jaaqeqeyanoŋ eu rabombaajoŋ siiŋa momakeju ano jejelombanoŋ duŋ jaaya iikanoŋ jegeŋjegeŋ rabombaajoŋ momakeju. ");
INSERT INTO ksr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Yoŋonoŋ malo yoŋoonoŋ miri iwoi bidaaŋ baagoŋ aŋaliŋ oŋomakeju ano qabuŋagia koloowaatiwaajoŋ qamakooli koriga koriga qama kooliŋ totogianoŋ qeŋkeju. Kawaajoŋ Anutunoŋ qaagia jeŋ tegoŋ iroŋa uutaga meleeno qagianoŋ ubaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jiisasnoŋ jiwowoŋ jigonoŋ nanduŋ katapa somataa gematanoŋ raro ejembanoŋ moneŋ iikanoŋ aŋgi kemero uuŋ iŋiiro. Ejemba qabuŋa ano esuhinagiawo mamaga yoŋonoŋ kouma kina moneŋ mamaga aŋgi kemero. ");
INSERT INTO ksr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Aŋgi kemero malo wanaya moŋnoŋ kouma soojaakota woi, ii toiya osoga kaaŋa ano kemero. ");
INSERT INTO ksr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jiisasnoŋ ii iima gowokouruta koma horoŋ oŋoma kokaeŋ iŋijoro, “Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Malo wanaya koi kanoŋ nanduŋ anji, ii mono tosaaŋa kuuya yoŋonoŋ iwoi katapanoŋ aŋgi kemeji, iikawaa soya uuguŋ anja. ");
INSERT INTO ksr_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kuuya yoŋonoŋ moneŋgia mamaga eŋ oŋono kitiagadeeŋ anjuto, emba koi kanoŋ mono koroboro laligojiwaa so ilawoilaya kuuya andaboroŋ eeŋ totooŋkota laligowaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jiisasnoŋ jiwowoŋ jigo mesaoŋ kamaaro gowokouruta yoŋoonoŋga moŋnoŋ kokaeŋ ijoro, “Boi iiba! Jigowaa totoŋ uutanoŋ miria miria ii mono damuyawo. Ii jamo somasomatanoŋ meŋ kaiterenoŋ menjereŋgogita awaasari nanja.” ");
INSERT INTO ksr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jiisasnoŋ ii moma qaa kokaeŋ meleeno, “Jigowaa totoŋ uutanoŋ miri somata waaŋgiawo kuuya koi iŋiijanto, ii mono kondeeŋgi miriwaa jamo moŋ ii jamo mombaa qaganoŋ mende ewaato, qeqelala qeŋ saoyagadeeŋ ewaa.” ");
INSERT INTO ksr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kaeŋ jero Oil gere baaŋanoŋ uma leegeŋ endu jiwowoŋ jigonoŋ nanoti, ii iima ragi. Iikanoŋ rama Piito, Jeims, Jon ano Andruu yoŋonoŋ Jiisas iyaŋagadeeŋ horoŋ kokaeŋ qisiŋ mugi, ");
INSERT INTO ksr_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Boi, qaa jejaŋi, iikawaa hoŋa mono naa kambanoŋ asugiwaa ano iwoi kuuya ii kanaiŋ asugidaborowaati, iikawaa aiweseyanoŋ mono nomaeŋ asugiwaa? Ii saanoŋ jena moboŋa.” ");
INSERT INTO ksr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kaeŋ qisiŋ mugi kanaiŋ kokaeŋ iŋijoro, “Moŋnoŋ aŋgomokoloŋ ano jiŋjauŋ qeŋ kembubotiwaajoŋ mono galeŋgia meŋ aoŋ laligowu. ");
INSERT INTO ksr_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","“Ejemba mamaganoŋ asugiŋ noo qananoŋ kokaeŋ jewuya, ‘Niinoŋ Kraist koloojeŋ.’ Kaeŋ jeŋ ejemba mamaga tiligoŋ oŋombuya. ");
INSERT INTO ksr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Oŋo manjawaa bujuya ano otoŋa kolooro momakebuya. Ii moma jeneŋgia mende oroŋkeba. Iwoi kaaŋa ii walagadeeŋ koloowaatiwaa jejeta. Ii koloowaato, namowaa kambaŋanoŋ mono iikanondeeŋ uulaŋawo mende tegowaa. ");
INSERT INTO ksr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kantri moŋnoŋ kantri moŋ uŋuwombaajoŋ waabuya. Ejemba tuuŋ moŋnoŋ tuuŋ moŋ yoŋowo aroŋ qeŋ aowombaajoŋ waabuya. Baloŋa baloŋa kanoŋ naŋ somasomata meŋ namo qonjoma meleeno kemeŋkebaa. Kaaŋagadeeŋ bodi gomaŋa gomaŋa asugiŋ eŋ ubaa. Iwoi kaaŋa ii emba korowonoŋ masu kanaiŋ uŋuŋkejiwaa so. Namowaa kambaŋanoŋ mono iikawaa so kanaidaboromambaajoŋ ambaa. ");
INSERT INTO ksr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kaeŋ koloowaato, oŋo galeŋgia awaagadeeŋ meŋ aoŋ laligowu. Ejembanoŋ oŋo horoŋ qaa jakeyanoŋ oŋooma qamakooli mirigianoŋ qaa gawoŋ meŋ koobinoŋ uŋuwuya. Tosianoŋ noojoŋ ama uŋuaŋgi kantria kantria yoŋoo eja poŋ ano gawana yoŋoo jaasewaŋgianoŋ nambuya. Kaeŋ nama noo kaniana naŋgoŋ jegi mobuya. ");
INSERT INTO ksr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Oligaa Buŋa koi mono waladeeŋ namonoŋ kantria kantria kuuya yoŋoojoŋ jeŋ seidaborogigo namowaa kambaŋanoŋ iikawaa gematanoŋ tegowaa. ");
INSERT INTO ksr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Horoŋ uŋuama qaa jakeyanoŋ oŋooŋgi nambuti, kambaŋ iikanoŋ qaa nomaeŋ jewonagati, iikawaa majakakaya ii waladeeŋ mende mobu. Uŋa Toroyanoŋ aua iikanondeeŋ qaa oŋombaati, mono ii jewu. Oŋoaŋgiaa uugiaajoŋ qaa mende jewuto, Uŋa Toroyanoŋ mono uugia sololooro qaa jewuya. ");
INSERT INTO ksr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Uumeleembaa motoya moŋnoŋ daremuŋa uuta meleenotiwaajoŋ ama ii memelolo mero qaa jakeyanoŋ ooŋgi qegi komuwaa. Kaaŋagadeeŋ ama moŋnoŋ meraboraaŋa memelolo mero komuwaa ano meraboraaŋa yoŋonoŋ nemuŋmaŋurugia qetama oŋoma jegi uŋugi komuwuya. ");
INSERT INTO ksr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kantria kantria yoŋonoŋ noo qanaajoŋ ama kazi ama oŋoŋgi laligowuyato, moŋnoŋ kaparaŋ koma kotiiŋ boŋ qeŋ nama laligoro namowaa kambaŋanoŋ tegowaati, iinoŋ mono oyaŋboyaŋ buŋa qeŋ aowaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Kanageŋ tosianoŋ kaŋ kondemondeeŋ ama iwoi aŋgonjorayawo jigonoŋ mende aambaa so ii alatanoŋ aŋgi nano iibuti, kambaŋ iikanoŋ Judia prowinsnoŋ laligowuti, oŋonoŋ mono misiŋgoŋ horoŋ baaŋanoŋ kembu. Qaa koi weeŋgowaati, iinoŋ mono saanoŋ geja ama moma kotowa. ");
INSERT INTO ksr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Miri kosianoŋ sombenoŋ laligowaati, iinoŋ mono kamaaŋ iwoiya memambaajoŋ miri uutanoŋ mende uba. ");
INSERT INTO ksr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Gawonoŋ kema laligowaati, iinoŋ mono kaaŋagadeeŋ malekuya memambaajoŋ eleema mirinoŋ mende kemba. ");
INSERT INTO ksr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Yei! Emba korowo ano merabora ajunoŋ yoŋonoŋ kambaŋ iikanoŋ nomaeŋ uulaŋawo kembuyaga. ");
INSERT INTO ksr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kawaajoŋ iwoi ii koŋ haamo kambaŋanoŋ mende koloowaatiwaajoŋ qama kooliŋkebu. ");
INSERT INTO ksr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kambaŋ iikanoŋ kakasililiŋ jekania booroŋgia koloowaa. Kakasililiŋ soya kaaŋa ii wala eeŋanoŋ kambaŋ moŋgeŋ mende kolooŋ ero. Anutunoŋ iwoi kuuya mokolooroti, kambaŋ iikanondeeŋ kanaiŋ kambaŋ kokaamba laligoŋ waama kambaŋ biiwianoŋ moŋ mende kolooro. Wala eeŋanoŋ mende kolooro ano kanageŋ kambaŋ moŋnoŋ mende koloowaa. Kawaajoŋ mono qama kooliŋ laligoŋkebu. ");
INSERT INTO ksr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Poŋnoŋ koŋajiliŋ kambaŋ ii mende meŋ torinagati eeŋ, ejemba kuuyanoŋ mono tiwilaadaborowuyagato, ejemba iyaŋaajoŋ meweeŋgoŋ oŋonoti, iyoŋoojoŋ ama weeŋ iikawaa jaŋgoya ii meŋ toriwaa. ");
INSERT INTO ksr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Kambaŋ iikanoŋ kokaeŋ jewuya, ‘Mobu! Kraistnoŋ koi laligoja,’ ano ‘Iibu! Hamoqeqe Toyanoŋ endu nanja.’ Moŋnoŋ kaeŋ jewaati eeŋ, ii mono mende moma laariwu. ");
INSERT INTO ksr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ii kokaembaajoŋ: Hamoqeqe toya qoloŋmoloŋgoya ano gejatootoo ejemba takapolakaya asugiŋ aŋgoleto ano aiwese jaamorota megi letombuya. Kaeŋ letoŋgi Anutunoŋ ejemba iyaŋaajoŋ meweeŋgoŋ oŋonoti, ii kaaŋagadeeŋ eŋkaloloŋ meŋ oŋombutiwaa aŋgobato meŋ kaparaŋ koŋgi jiŋjauŋ qewubo. Oŋonoŋ galeŋgia awaagadeeŋ meŋ aoŋ laligogi ii amamaawuyaga. ");
INSERT INTO ksr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Niinoŋ iwoi kuuya ii mende kolooro waladeeŋ kuuya iŋijowe moju. Ii wala jejeŋiwaajoŋ ii mono uuwombogianoŋ ama galeŋgia meŋ aoŋ laligowu.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Kakasililiŋ ii tegoro kambaŋ iikanondeeŋ weeŋ jaayanoŋ injaŋ kono koiŋnoŋ umuŋ kombaa. ");
INSERT INTO ksr_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Seŋgelao yoŋonoŋ sombinoŋga tegoŋ kamaawuya ano sombinoŋ utugoro iikawaa ilawoilaya ii raragia mesaoŋ eŋkaloloŋ aŋgi soowaa. ");
INSERT INTO ksr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kambaŋ iikanoŋ Siwe gomambaa Eja hoŋa iinoŋ koosu qaganoŋ karo iibuya. Ku-usuŋa somatanoŋ sakondindiŋawo asuganoŋ asugiro asamararaŋa iibuya. ");
INSERT INTO ksr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kaŋ Siwe gajobauruta wasiŋ oŋono yoŋonoŋ ejemba Anutunoŋ iyaŋaajoŋ meweeŋgoŋ oŋonoti, ii baloŋ goraaya leelee, eugeŋ emugeŋ iikanondeeŋ kopepereeŋ oŋombuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Oŋo mono noroŋ gere iima tania romoŋgoŋ sareqaa koi mobu. Borianoŋ apuyawo kolooro seŋgia loŋgogi ii iima moma kokaeŋ jeŋkeju, ‘Weeŋ kambaŋ dodowija.’ ");
INSERT INTO ksr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Oŋonoŋ kaaŋiadeeŋ aiwese iikawaa so kolooro iima moma asariŋ mono kania kokaeŋ jewu, ‘Jiisasnoŋ mono nagunoŋ dodowija.’ ");
INSERT INTO ksr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Ejemba koi kete namonoŋ laligojuti, iyoŋonoŋ mende komugi iwoi kuuya jejeŋi, ii mono iyoŋoo laaligo kambaŋgianoŋ koloowaa ");
INSERT INTO ksr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Sombiŋ ano namo yoronoŋ goroŋ qewaotato, noo Buŋa qaananoŋ mono mende aliwaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Siwe gomambaa Eja hoŋanoŋ naa kambanoŋ kawaati, iikawaa weeŋa me aua kambaŋa ii moŋnoŋ moŋ mende moja. Siwenoŋ gajoba yoŋonoŋ ii mende moju. Anutuwaa Merianoŋ kaaŋiadeeŋ ii mende moja. Ama aŋodeeŋ ii moja. ");
INSERT INTO ksr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Naa kambanoŋ asugiwaati, ii mende mojutiwaajoŋ oŋonoŋ mono galeŋ meŋ aoŋ uugbiligbili laligowu. ");
INSERT INTO ksr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ii sareqaa kokawaa so eja: Eja moŋnoŋ gomaŋa mesaoŋ kantri moŋgeŋ keno. Kemambaajoŋ ama galeŋuruta iwoi kuuya jeŋ kotoŋ oŋoma naguwaa kiiya meria borogianoŋ ama usuŋa oŋono. Ku-usuŋa oŋoma weleŋqeqeuruta motomotooŋ gawoŋgia oŋono. Oŋoma laligoŋ nagu galeŋa kaaŋagadeeŋ uugbiligbili laligowaatiwaajoŋ jeŋ kotoŋ muro. ");
INSERT INTO ksr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Miri toyanoŋ naa kambanoŋ eleema kawaati, ii mende moju. Mare me gomantiiŋa ruuŋanoŋ kawaa me? Weŋgeraŋ suluro kawaa me? Weeŋ kouro kawaa me? Iikawaa so oŋo ii mende mojutiwaajoŋ ama mono uugbiligbili laligowu. ");
INSERT INTO ksr_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Oŋonoŋ gaoŋ egi uulaŋawo kaŋ kaeŋ mokolooŋ oŋombabo. ");
INSERT INTO ksr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Oŋo mono uugbiligbili laligowu. Qaa ii gowokouruna oŋoojoŋ jejeŋi, ii kaaŋagadeeŋ alauruna kuuya oŋoojoŋ motooŋ jejeŋ: Oŋo mono uugbiligbili laligowu.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pasowa kendoŋ ano bered yiistya qaa iikawaa kendoŋa toriri. Weeŋ woi tegoro kanoŋ kanaiwombaa ani jigo gawoŋ galeŋ ano Kana qaawaa boi yoŋonoŋ ajoroogi. Ajorooŋ nomaeŋ mondoniŋ Jiisas oloŋ meŋ qegi komunaga, iikawaa kania moŋgama jeŋ gosigi. ");
INSERT INTO ksr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Moŋgama gosiŋ kokaeŋ jegi, “Ejemba iriŋgia soono kareŋa kareŋa koloowabotiwaajoŋ ii korisoro kendoŋ kambaŋanoŋ ambombaajoŋ amamaawoŋa.” Kaeŋ jegi. ");
INSERT INTO ksr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jiisasnoŋ Betani gomanoŋ laligoŋ Saimon moŋ manimbaya meŋ solaŋaniroti, iwaa mirinoŋ uma raro. Iikanoŋ nene neŋ raro emba moŋnoŋ jamo kaaro moŋ meŋ iwaanoŋ karo. Kaaro ii lalu laŋgoŋawo qata alabasta iikanoŋ memeta. Ii apu uŋkoowagawo hoŋa qata naad iikanoŋ saa qeŋ raro. Iinoŋ ii sewaŋa somatanoŋ meŋ kaŋ lalu aroya kotoŋ apuya Jiisaswaa waŋanoŋ qibibiriŋ moriro. ");
INSERT INTO ksr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Moriro eja ragiti, iyoŋoonoŋga tosianoŋ uugia boliro iyaŋgiodeeŋ kokaeŋ amiŋ mogi, “Naad apu ii mono naambaajoŋ kaeŋ tiwilaaja? ");
INSERT INTO ksr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Naad apu kelegawo ii sewaŋa mewutiwaajoŋ anagati eeŋ, saanoŋ weeŋ 300:waa tawaya uugunaga. Ii ejemba wanaya oŋono sokonaga.” Kaeŋ jeŋ emba ii jeŋ mugi. ");
INSERT INTO ksr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jeŋ mugi Jiisasnoŋ kokaeŋ iŋijoro, “Emba koi mono mende jeŋ mubu. Naambaajoŋ uuta meŋ boliju? Iinoŋ sili awaa ama sororogoŋ nono sokonja. ");
INSERT INTO ksr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ejemba wanaya ii kambaŋa kambaŋa batugianoŋ laligogi awaa ama oŋomboŋatiwaajoŋ moma ii saanoŋ kambaŋ so ambuyato, niinoŋ oŋoo batugianoŋ kambaŋ so mende laligomaŋa. ");
INSERT INTO ksr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Iinoŋ ii iyaŋaa nanamemeŋaa so ama nonja. Niinoŋ komuwe roŋ koma nombutiwaajoŋ saanoŋ waladeeŋ selena kelenoŋ nomorija. ");
INSERT INTO ksr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Oligaa Buŋa koi kantri kanoŋ me kanoŋ jeŋ seigi kembaati, iikanoŋ emba koi kanoŋ iwoi ama nonji, iikawaa bujuya ii kaaŋgadeeŋ jegi seiro iwaajoŋ romoŋgoŋ laligowuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Gowokouruta 12 yoŋoonoŋga moŋ qata Juudas Iskariot iinoŋ Jiisas memelolo meŋ mumambaajoŋ ama jigo gawoŋ galeŋ yoŋoonoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yoŋoonoŋ kema qaaya jero ii moma uugia qeaŋgoro sewaŋa moneŋ mubombaajoŋ qaa somoŋgogi. Qaa somoŋgogi Jiisas kambaŋ moŋgeŋ memelolo meŋ mumambaa kana moŋgama kokobimbiŋ qeŋ laligoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bered yiistya qaa iikawaa kendoŋ weeŋ mutuyanoŋ (Siikunenenoŋ) siligia otaaŋ pasowa lama moŋ qeŋ ooŋkegi. Kawaajoŋ Jiisaswaa gowokourutanoŋ ijogi, “Boi, nono miri dakanoŋ kema pasowa lama goojoŋ mozozoŋgoŋgo newoŋa? Siiŋga nomaeŋ eja?” ");
INSERT INTO ksr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kaeŋ ijogi gowokowoita woi kokaeŋ jeŋ wasiŋ orono, “Oro Jerusalem sitinoŋ uri eja moŋ apu monjoŋ qindiiŋ karo mokoloowaota. Mokolooŋ ii saanoŋ otaaŋ kembao. ");
INSERT INTO ksr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Keni mirinoŋ uro iikawaa toya kokaeŋ ijowao, ‘Boinoŋ kokaeŋ jeja: Saanoŋ miri uuta moŋ jeŋ tegoŋ nonona iikanoŋ uma gowokouruna yoŋowo pasowa lama newoŋa.’ ");
INSERT INTO ksr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kaeŋ ijori toyanoŋ miri qaganoŋ eu uma uuta somata moŋ qendeema orombaa. Iikanoŋ duŋ rara iwoi mozozoŋgogita raja. Ii qendeema orono iikanoŋ mono lama qeŋ oowao.” ");
INSERT INTO ksr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kaeŋ jero gowokowoitanoŋ mesaoŋ sitinoŋ uma Jiisasnoŋ qaa jeroti, iikawaa so mokolooŋ nama lama qeŋ ooŋ mozozoŋgori. ");
INSERT INTO ksr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Gomaŋ tiiro Jiisasnoŋ gowokouruta 12 yoŋowo miri iikanoŋ kougi. ");
INSERT INTO ksr_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kouma uma duŋnoŋ rama nene negi Jiisasnoŋ kokaeŋ iŋijoro, “Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Oŋoonoŋga moŋ niwo nene neŋ raji, iinoŋ mono memelolo meŋ nombaa.” ");
INSERT INTO ksr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kaeŋ iŋijoro moma uugianoŋ wosobiri moma kanaiŋ aŋa aŋa qisiŋ muŋ jegi, “Noojoŋa jewabo?” ");
INSERT INTO ksr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Qisiŋ mugi kokaeŋ iŋijoro, “12 oŋoonoŋga moŋ niwo bered qaaŋnoŋ qenduŋgoji, iinoŋ. ");
INSERT INTO ksr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Siwe gomambaa Eja hoŋanoŋ mono iwaajoŋ qaa oogita ejiwaa so namo mesaoŋ kembaa. Kembaato, memelolo meŋ mubaati, iwaajoŋ ‘Yei wosobiri!’ jeŋ wanjinjiŋgojeŋ. Anutunoŋ mono iroŋa uuta meleema mubaa. Eja ii nemuŋaa goroŋ uutanoŋga mende koloonagati, iikanoŋ mono afaaŋgoŋ munaga.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nene neŋ rama Jiisasnoŋ bered meŋ kotuegoŋ motoŋ oŋoma kokaeŋ jero, “Koi neenaa busuna. Ii mono meŋ newu.” ");
INSERT INTO ksr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kaeŋ jeŋ wain qambi meŋ daŋgiseŋ jeŋ oŋono kuuyanoŋ qambi iikanoŋga negi. ");
INSERT INTO ksr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Negi kokaeŋ iŋijoro, “Koi neenaa sana. Koi Anutunoŋ ejemba yoŋowo soomoŋgo areŋ ano kotiiwaatiwaajoŋ sana maagi ejemba mamaga hamo qeŋ oŋombaa. ");
INSERT INTO ksr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Niinoŋ wain kasawaa hoŋa kokanoŋ mombo toroqeŋ mende nemaŋa. Kanageŋ Anutuwaa bentotoŋ uutanoŋ eu raniŋ jejelombaŋ ambaati, weeŋ iikanoŋ mono wain apu qaita moŋ ii nemaŋa.” ");
INSERT INTO ksr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kaeŋ jero korisoro rii qama mesaoŋ kema Oil gere baaŋanoŋ ugi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Uma Jiisasnoŋ kokaeŋ iŋijoro, “Gejatootoo eja moŋnoŋ qaa moŋ kokaeŋ oorota eja, ‘Niinoŋ galeŋgia qewe lama tuuŋanoŋ deembuya.’ Iikawaa so oŋonoŋ kuuya uugia boliro nomesaoŋ boratiwuya. ");
INSERT INTO ksr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Boratigi nuwuyato, niinoŋ mono koomunoŋga waama wala Galili prowinsnoŋ kema iikanoŋ asugiŋ oŋomaŋa.” ");
INSERT INTO ksr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Kaeŋ iŋijoro Piitonoŋ kokaeŋ ijoro, “Yoŋonoŋ kuuya uugia boliro gomesaoŋ boratiwuti eeŋ, niinoŋ mono kileŋ iikaaŋ mende amaŋa.” ");
INSERT INTO ksr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ijoro Jiisasnoŋ jero, “Niinoŋ qaa hoŋa moŋ kokaeŋ gijowe moba: Kurunoŋ indiŋ woi mende qaro giinoŋ kete gomantiiŋanoŋ qakooma nona indiŋ karooŋ koloowaa.” ");
INSERT INTO ksr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kaeŋ jeroto, Piitonoŋ kaparaŋ koma kotikotii ano, “Boi, kaeŋ qaagoto, nii nugi giwo motooŋ komuworagati, ii kileŋ niinoŋ gii mende qakooma gomaŋa.” Gowoko tosaaŋa kuuyanoŋ qaa iikayadeeŋ jegi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kaeŋ amiŋ moma kema urukisi moŋ qata Gezemane iikanoŋ keugi. Keuma gowokouruta kokaeŋ iŋijoro, “Niinoŋ endu kema qama kooliwe oŋo mono kambaŋ biiwianoŋ koi rabu.” ");
INSERT INTO ksr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kaeŋ iŋijoŋ Piito, Jeims ano Jon uŋuama keŋgi. Keŋgi Jiisasnoŋ kanaiŋ konjiliŋ kanjaŋawo moro kana boria qetegoro. ");
INSERT INTO ksr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kaeŋ ama kokaeŋ iŋijoro, “Noo uunanoŋ mono konduŋkonduŋ koma waajiwaajoŋ ama wosobiri mobe komukomuyawo ama nonja. Oŋonoŋ mono kokanoŋ rama niwo gbili laligowoŋa.” ");
INSERT INTO ksr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kaeŋ iŋijoŋ aŋodeeŋ boroŋa moŋ toroqeŋ kema simiŋ kuma usugoŋ siimbobolo kambaŋa ii Maŋaa jetaa so uuguwaatiwaajoŋ qama kooliro. ");
INSERT INTO ksr_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Qama kooliŋ jero, “Aba Amana, gii iwoi moŋ mende meŋ bimbiŋgoŋkejaŋ. Kawaajoŋ siimbobolowaa qambia koi mono nuamba. Nuanagati, ii noo siimbaa so qaagoto, mono geeŋgaa uusiiŋga otaaŋ koloowa.” ");
INSERT INTO ksr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kaeŋ jeŋ eleeno gowokouruta karooŋ yoŋonoŋ gaoŋ egi iŋiima Piito kokaeŋ ijoro, “Saimon, gii gaoŋ ejaŋ me? Gii aua motooŋgoda gbili laligomambaajoŋ mende kotiijaŋ me? ");
INSERT INTO ksr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Uunananoŋ gbili laligowombaa siiŋa momakejonto, selenananoŋ loolooria kolooja. Kawaajoŋ aŋgobatonoŋ kamaaŋ uŋuwabotiwaajoŋ mono qama kooliŋ uugbiligbili laligowu.” ");
INSERT INTO ksr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kaeŋ ijoro mombo oŋomesaoŋ kema qaa iikayadeeŋ mombo jeŋ qama kooliro. ");
INSERT INTO ksr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Qama kooliŋ eleeno jaa lologia bomboŋ mero mombo gaoŋgadeeŋ egi iŋiiro. Gaonoŋga waama qaa meleembom-baajoŋ oŋopopo qegi. ");
INSERT INTO ksr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jiisasnoŋ keno indiŋ karooŋ kolooro eleema kaŋ kokaeŋ iŋijoro, “Oŋo toroqeŋ haamo meŋ gaoŋgadeeŋ ewombaajoŋ moju me? Mobu! Moŋnoŋ Siwe gomambaa Eja hoŋa memelolo meŋ muro gawman eja sisiwerowerogiawo yoŋoo borogianoŋ ubaati, iikawaa aua kambaŋanoŋ mono kaŋ kuuja. Oŋoo gaoŋ ee kambaŋgia mono tegoja. ");
INSERT INTO ksr_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mono waagi kemboŋ. Mobu! Memelolo meŋ nombaati, iinoŋ mono kosere koi kaja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jiisasnoŋ kaeŋ jeŋ nano iikanondeeŋ gowokouruta 12 yoŋoonoŋga moŋ qata Juudas iinoŋ tuuŋ moŋ jeta meŋ oŋono kougi. Jigo gawoŋ galeŋ, Kana qaawaa boi ano kantriwaa jotamemeya yoŋonoŋ ii wasiŋ oŋoŋgi manjawaa soo somata ano wasagia meŋ kagi. ");
INSERT INTO ksr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Memelolo memambaa anoti, iinoŋ wala yoŋowo aiwese qaa kokaeŋ somoŋgoŋ iŋijoro, “Niinoŋ eja buuta kitoŋ nemaŋati, ii iima ‘Mono ii!’ jeŋ meŋ somoŋgoŋ tororo galeŋ koma kembu.” ");
INSERT INTO ksr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kaeŋ jeŋ kaŋ iikanondeeŋ Jiisaswaanoŋ keuma “Oo kokona! (Boina!)” jeŋ buuta kitoŋ nero. ");
INSERT INTO ksr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kitoŋ nero iima Jiisas qelanjiŋ meŋ somoŋgogi. ");
INSERT INTO ksr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Somoŋgogi kosianoŋ naŋgiti, iyoŋoonoŋga moŋnoŋ manjawaa soo somata horoŋ jigo gawoŋ galeŋ waŋaa weleŋqeqeya qeŋ gejia kotogoro kamaaro. ");
INSERT INTO ksr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jiisas somoŋgogi qaa kokaeŋ iŋijoro, “Nii kikekakasililiŋ ejaga qaagoto, kileŋ noojoŋ kaeŋ moma manjawaa soo somata ano wasa meŋ noma somoŋgoŋ nombombaajoŋ kaju. ");
INSERT INTO ksr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Niinoŋ weeŋ so jiwowoŋ jigonoŋ oŋowo nama Buŋa qaa kuma oŋoma laligowe mende noŋgito, iwoi koi mono Buŋa Terewaa qaayanoŋ hoŋawo koloowaatiwaajoŋ kolooja. ");
INSERT INTO ksr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jiisas somoŋgogi gowoko yoŋonoŋ kuuya Jiisas mesaoŋ boratiŋ oloŋ koma keŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Eja gbaworo moŋnoŋ opoqiisia taaŋa kokosiiŋ Jiisaswaa gematanoŋ otaaŋ keno. Opoya tosia mende mouma keno ii metaqetataŋ megi. ");
INSERT INTO ksr_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Mewombaajoŋ amamaaŋ opoqiisia qetegogi lalaŋ oloŋ koma keno. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jiisas somoŋgoŋ wama jigo gawoŋ galeŋ waŋaa jiŋkaroŋ mirinoŋ keŋgi. Keŋgi jigo gawoŋ galeŋ kuuya, kantriwaa jotamemeya ano Kana qaawaa boi yoŋonoŋ iikanoŋ kema ajoroogi. ");
INSERT INTO ksr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Keŋgi Piitonoŋ sigeŋsigeŋ oŋotaaŋ jigo gawoŋ galeŋ waŋaa jiŋkaroŋ mirinoŋ keuma miriaa kiropo uutanoŋ uro. Uma weleŋqeqe eja yoŋoo batugianoŋ gere kosianoŋ rama konano. ");
INSERT INTO ksr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kaeŋ raroto, jigo gawoŋ galeŋ ano jigo kaunsol tuuŋ yoŋonoŋ Jiisaswaa selenoŋ kuukuu qaa nomaeŋ jeŋ naŋgoniŋ qegi komuwaatiwaajoŋ jeŋ moŋgaŋgito, iikawaa kania moŋ mende mokoloogi. ");
INSERT INTO ksr_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Moŋgama nama mamaganoŋ qaa qoloŋmoloŋgoya selianoŋ kuuŋ naŋgoŋ jegito, qaagianoŋ kania motooŋgo mende kolooro. ");
INSERT INTO ksr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kaeŋ aŋgi tosianoŋ waama nama qaa qoloŋmoloŋgoya selianoŋ kuuŋ naŋgoŋ kokaeŋ jegi, ");
INSERT INTO ksr_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Iinoŋ kokaeŋ jero moniŋ, ‘Niinoŋ jiwowoŋ jigo boronoŋ memeta koi kondeembe namonoŋ kamaaro weeŋ karoombaa uutanoŋ jigo qaita moŋ boronoŋ memeta qaago ii meŋ waama kuumaŋa.” ’ ");
INSERT INTO ksr_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kaeŋ jegito, kileŋ qaagianoŋ kania motooŋgo mende kolooro. ");
INSERT INTO ksr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kaeŋ mende kolooro jigo gawoŋ galeŋ waŋanoŋ waama jaasewaŋ qeŋ oŋoma nama Jiisas qisiŋ muŋ kokaeŋ ijoro, “Yoŋonoŋ goo seleganoŋ qaa kuuŋ naŋgojuti, iikawaa kitia moŋ jewaga me qaago?” ");
INSERT INTO ksr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kaeŋ ijoro iwoi bologa moŋ mende anoto, kileŋ kitia moŋ mende meleema qaaya bogoro nano. Qaaya bogoro nano jigo gawoŋ galeŋ waŋanoŋ mombo kokaeŋ qisiŋ muro, “Anutu mepeseeŋ mumakejoŋi, gii iwaa Meria Kraist koloojaŋ me qaago?” ");
INSERT INTO ksr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Qisiŋ muro “Ooŋ” jeŋ kokaeŋ iŋijoro, “Siwe gomambaa Eja hoŋanoŋ mono ku-usuŋ Toyaa boro dindiŋanoŋ rama era sombimbaa koosu qaganoŋ kamaaro iibuya.” ");
INSERT INTO ksr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Qaa ii iŋijoro jigo gawoŋ galeŋ waŋanoŋ malekuya menjurama kokaeŋ jero, “Yei, maŋgaa siita! Tosianoŋ qaaya naŋgowutiwaajoŋ mombo mende qisiŋ oŋomboŋa. ");
INSERT INTO ksr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Anutu mepaegoji, ii mono oŋoaŋgio modaboroju. Kawaajoŋ mono oŋo nomaeŋ moju?” Kaeŋ jero yoŋonoŋ kuuya Jiisas koomuwaa buŋa koloowaatiwaajoŋ jeŋ tegogi. ");
INSERT INTO ksr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kaeŋ jeŋ tegoŋ tosianoŋ kanaiŋ sulaapaŋ qeŋ jaasewaŋa esuuŋ boro kuma qeŋ kokaeŋ ijogi, “Moronoŋ guji, ii saanoŋ jena moboŋa.” Jigowaa kiropo galeŋ (sikiriti) yoŋonoŋ kaaŋagadeeŋ Jiisas meŋ uruŋanoŋ qetaaligi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kambaŋ iikanoŋ Piitonoŋ kiropo uutanoŋ sombenoŋ laligoro. Emu laligoro jigo gawoŋ galeŋ waŋaa weleŋqeqe emba moŋnoŋ iikanoŋ kouro. ");
INSERT INTO ksr_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kouma Piitonoŋ gere konama nano iigigiiŋ kokaeŋ jero, “Gii mono kaaŋagadeeŋ Nazaret eja Jiisaswo laligona.” ");
INSERT INTO ksr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kaeŋ jeroto, Piitonoŋ qakooma kokaeŋ jero, “Qaa jejaŋi, ii kondanjeŋ.” Kaeŋ jeŋ kiropo naguyanoŋ kemeŋ nano kuru qaro. ");
INSERT INTO ksr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nagunoŋ kemero weleŋqeqe emba moŋnoŋ ii iikanoŋ mombo iima eja kosianoŋ naŋgiti, ii kanaiŋ kokaeŋ iŋijoro, “Eja koi kanoŋ mono yoŋoonoŋga moŋ kolooja.” ");
INSERT INTO ksr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kaeŋ iŋijoroto, iinoŋ mombo qakoono. Qakoono kambaŋ boroŋa moŋ tegoro eja kosianoŋ naŋgiti, iyoŋonoŋ mombo Piitowaajoŋ kokaeŋ jegi, “Giinoŋ Galili ejaga moŋ koloojaŋiwaajoŋ mono hoŋanoŋ iyoŋoonoŋga moŋ koloojaŋ.” ");
INSERT INTO ksr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ii moma kanaiŋ aŋa qasuaaŋ aoŋ jopaŋgoŋ jeŋ kotiiŋ jero, “Eja qaaya jejuti, niinoŋ ii mende moma mujeŋ. Qaa qoloŋ-moloŋgoya jewenagati eeŋ, Anutunoŋ mono iroŋa meleema nomba.” ");
INSERT INTO ksr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kaeŋ jeŋ nano iikanondeeŋ kurunoŋ qaro indiŋ woi kolooro. Kurunoŋ qaro Jiisasnoŋ qaa kokaeŋ ijoroti, Piitonoŋ ii romoŋgoro, “Giinoŋ indiŋ karooŋ qakooma nona kurunoŋ qaro indiŋ woi koloowaa.” Qaa ii romoŋgoŋ wosoya jumambaajoŋ ano silama saaro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Gomaŋ ano amandiinoŋ jigo gawoŋ galeŋ, kantriwaa jotamemeya (70), ano Kana qaawaa boi ano jigo kaunsol kuuya yoŋonoŋ qaa jake uutaa ajoajoroo ama Jiisaswaa qaa jeŋ tegogi. Jeŋ tegogi Jiisas somoŋgoŋ wama kema gawana Pailotwaa boronoŋ aŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Room gawana iinoŋ Jiisas kokaeŋ qisiŋ muro, “Oŋanoŋ, gii Juuda yoŋoo kiŋgia koloojaŋ me qaago?” Qisiŋ muro Jiisasnoŋ meleema ijoro, “Mono geeŋgo jejaŋi, kaeŋ.” ");
INSERT INTO ksr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jigo gawoŋ galeŋ yoŋonoŋ qaa mamaga Jiisaswaa selianoŋ kuuŋ jegi. ");
INSERT INTO ksr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Jegi Pailotnoŋ Jiisas mombo qisiŋ muŋ ijoro, “Moba! Yoŋonoŋ qaa mamaga goo seleganoŋ kuuŋ jejuti, giinoŋ iikawaa kitia moŋ jewaga me qaago?” ");
INSERT INTO ksr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kaeŋ ijoroto, Jiisasnoŋ bologa moŋ mende anoto, kileŋ qaa kitia mombo mende meleeno. Qaaya bogoro nano gawananoŋ waliŋgoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Gbani so pasowa kendoŋ kambaŋanoŋ gawananoŋ kapuare mirinoŋga eja moŋ qata qama qisigiti, ii silia otaaŋ isama oŋomakegi. ");
INSERT INTO ksr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kambaŋ iikanoŋ eja moŋ qata Barabas ii kapuare mirinoŋ raro. Iinoŋ kikekakasililiŋ eja tosaaŋa yoŋowo kareŋ giliŋ eja moŋ qegi komuroti, iikawaajoŋ kapuare mirinoŋ oŋooŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kaeŋ aŋgi kanageso yoŋonoŋ gawanawaa jiŋkaroŋ miri sombeŋanoŋ eu uma nama kanaiŋ ama laligorotiwaa so ambaatiwaajoŋ qisiŋ mugi. ");
INSERT INTO ksr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Qisiŋ mugi meleema kokaeŋ iŋijoro, “Niinoŋ Juuda oŋoo kiŋgiaga isambe kamaawaatiwaajoŋ moju me?” ");
INSERT INTO ksr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jigo gawoŋ galeŋ yoŋonoŋ Jiisaswaajoŋ goroŋooso mogitiwaajoŋ ama ii gawanawaa boronoŋ ooŋgi. Ii moma siiŋgia momambaajoŋ kaeŋ qisiŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Qisiŋ oŋono jigo gawoŋ galeŋ yoŋonoŋ ejemba tuuŋ uukuukuu meŋ oŋoma kokaeŋ jegi, “Jiisas mesaoŋ Barabas isamba! Mono kaeŋ qisiŋ mubu.” ");
INSERT INTO ksr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kaeŋ jegi mombo meleema qisiŋ oŋono, “Kaeŋ jejutiwaajoŋ Juuda oŋoo kiŋgia qata kaeŋ qamakejuti, niinoŋ mono ii nomaeŋ ama mubenaga?” ");
INSERT INTO ksr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kaeŋ qisiŋ oŋono mombo qagi, “Mono maripoonoŋ qewu jewa!” ");
INSERT INTO ksr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kaeŋ qagi Pailotnoŋ kokaeŋ iŋijoro, “Ii naambaajoŋ? Iinoŋ mono naa bologa ano?” Kaeŋ jeroto, yoŋonoŋ ii moma kaparaŋ koma toroqeŋ qa gigilaaŋ kokaeŋ qagi, “Mono maripoonoŋ qewu jewa!” ");
INSERT INTO ksr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kaeŋ qagi Pailotnoŋ ejemba tuuŋ somata siiŋgiaa so amambaajoŋ moma Barabas isama oŋono kamaaroto, Jiisasga jero ooli waayawonoŋ qeyayagoŋ qegi. Kaeŋ qegi maripoonoŋ qewutiwaajoŋ ii Room manjaqeqe eja yoŋoo borogianoŋ ano. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Manjaqeqe eja yoŋonoŋ Jiisas wama kema gawanawaa jiŋkaroŋ miriwaa kiropo uutanoŋ keugi. Keuma manjaqeqe tuuŋ somata kuuya horoŋ oŋoŋgi iikanoŋ kagi. ");
INSERT INTO ksr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kaŋ maleku osoga nezoŋgbala ii Jiisaswaa selianoŋ mouma muŋ somaŋ kasa lipima ila kaaŋa waŋanoŋ koŋgi kemero. ");
INSERT INTO ksr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kaeŋ kemero kanaiŋ waeya meŋ joloŋa jegi, “Oowe oowe! Juuda yoŋoo kiŋ poŋgia, oowe!” ");
INSERT INTO ksr_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Qaqatete kaeŋ ama jegi bowonoŋ waŋanoŋ qeŋ sulaapaŋ qeŋ simiŋ kuma muŋ usugoŋ mepeqepesee qoloŋmoloŋgoya meŋ mugi. ");
INSERT INTO ksr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mepaqepae kaeŋ ama mudaboroŋ maleku osoga nezoŋgbala ii qetegoŋ iyaŋaa sele esu mouma muŋ maripoonoŋ qewombaajoŋ wama keŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kema kana somatanoŋ eja moŋ qata Saimon mokoloogi. Iinoŋ Afrika siti qata Sairini iikawaa ejiaga ano Aleksander ano Ruufus yoroo maŋgaraga. Iinoŋ gawonoŋga kouro kuuŋ mugi Jiisaswaanoŋ maripooŋ meŋ aŋgoro. ");
INSERT INTO ksr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jiisas kaeŋ wama gomaŋ moŋ qata Golgota ii ananaa qaanoŋ Waŋsii, iikanoŋ kema keugi. ");
INSERT INTO ksr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Keuma wain apu ano marasiŋ qata mor ii mindiriŋ melokanjiŋ mugito, Jiisasnoŋ ii togoro. ");
INSERT INTO ksr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Togoro nama maripoonoŋ qegi. Qegi nano kiaweŋ megi jaŋgoya kolooro Jiisaswaa sele esuya motomotooŋ batugianoŋ iikawaa so mendeema megi. ");
INSERT INTO ksr_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Gomaamba 9 kilok iikanoŋ maripoonoŋ qegi. ");
INSERT INTO ksr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Maripoonoŋ qeŋ waŋanoŋ eu qegitiwaa kania kokaeŋ ooŋ qegi, “Juuda yoŋoo kiŋ poŋgiaga koi.” ");
INSERT INTO ksr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kikekakasililiŋ eja woi kaaŋagadeeŋ iwo maripoonoŋ urugi. Moŋ boro dindiŋanoŋ moŋ qanianoŋ leelee kaeŋ urugi. ");
INSERT INTO ksr_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Anutuwaa Buŋa Terenoŋ qaa kokaeŋ oogita eja, “Ii gosiŋ kikekakasililiŋ eja kaaŋa romoŋgoŋ yoŋoo batugianoŋ aŋgi.” Qaa iikaeŋ kanoŋ hoŋawo kolooro.) ");
INSERT INTO ksr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ejemba uuguŋ kema kaŋ kuŋgulolopo ama lukukuuŋ muŋ wambelaaŋ kokaeŋ jegi, “Yei! Gii mono jiwowoŋ jigo saanoŋ kondeena namonoŋ kamaaro weeŋ karoombaa uutanoŋ mombo metaama kuumambaajoŋ jena. Oo, gii eja awaa soro! ");
INSERT INTO ksr_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Mono geeŋga ilaaŋ aoŋ maripoonoŋga kamaawa.” ");
INSERT INTO ksr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jigo gawoŋ galeŋ ano Kana qaawaa boi yoŋonoŋ kaaŋagadeeŋ batugianoŋ mepaqepae ama muŋ jegi, “Tosiaga ilaaŋ oŋoma laligoroto, iyaŋa ilaaŋ aomambaajoŋ amamaaja. ");
INSERT INTO ksr_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Iinoŋ Hamoqeqe Toya Kraist ano Israelwaa kiŋ kolooji eeŋ, mono keteda koi maripoonoŋga kamaaro iima ii moma laariwonaga.” Kaeŋ jegi. Eja iwo maripoonoŋ urugiti, iyoronoŋ kaaŋagadeeŋ uuqeqe qaa tokoroŋkota jeŋ muri. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Weeŋ biiwia 12 kilok kolooro iikanoŋ gomaŋ kuuya paŋgamaŋ meŋ sokoma ero kema aua karoombaa so kolooro. ");
INSERT INTO ksr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jiisasnoŋ 3 kilok iikanoŋ aŋaa qaanoŋ kokaeŋ qa somata qaro, “Eeli eeli lama sabaktani?” Ii ananaa qaanoŋ: Anutuna, Anutuna mono naambaajoŋ gema nujaŋ? ");
INSERT INTO ksr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kaeŋ qaro eja kosianoŋ naŋgiti, iyoŋoonoŋga tosianoŋ ii moma jegi, “Mobu! Mono Elaijawaajoŋ qaja.” ");
INSERT INTO ksr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Yoŋoonoŋga moŋnoŋ bobogariŋ kema momondo moŋ suuŋ taniŋeeŋ ii meŋ wain apu aasoŋawonoŋ qenduŋgoŋ gere goroŋ kitianoŋ somoŋgoŋ suluŋ Jiisaswaa buu susuyanoŋ eu ano nero jero, “Mono mesaogi aŋodeeŋ namba. Elaijanoŋ kaŋ motogoro kamaawaa me qaago, mono ii iiboŋa.” ");
INSERT INTO ksr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kaeŋ aŋgi Jiisasnoŋ qa somata qama wosoya goroŋ qero komuro. ");
INSERT INTO ksr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Komuro iikanondeeŋ jiwowoŋ jigowaa uutanoŋ opo nanoti, iikanoŋ mono eukaya biiwianoŋ jurama kamaaŋ woi kolooro. ");
INSERT INTO ksr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kawali galenoŋ maripooŋ jaasewaŋ qeŋ nama Jiisasnoŋ wosoya goroŋ qero komuroti, ii iima kokaeŋ jero, “Eja koi kanoŋ mono oŋanoŋ Anutuwaa meriaga kolooja.” ");
INSERT INTO ksr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Emba tosianoŋ kaaŋagadeeŋ sigeŋsigeŋ nama iwoi ii iigi. Yoŋoo batugianoŋ Maria Magdalaga ano Maria Jeims dubaya ano Jooses yoroo nemuŋgara ano Salome yoŋonoŋ motooŋ naŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yoŋonoŋ Jiisasnoŋ Galili prowinsnoŋ laligoro iikanoŋ ii otaaŋ weleŋ qeŋ muŋ laligogi. Kaaŋagadeeŋ emba tosaaŋa mamaga Jiisaswo Jerusalem sitinoŋ uma kagiti, iyoŋonoŋ kaaŋiadeeŋ kosianoŋ naŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sabat kendoŋ rarawaajoŋ iwoi mozozoŋgogi Sabat kendonoŋ kanaimambaajoŋ dodowiro mare kolooŋ karo. ");
INSERT INTO ksr_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Nemuŋgawoŋ iikanoŋ Arimatia toya, eja waaŋawo qata Joosef iinoŋ karo. Iinoŋ kaaŋagadeeŋ Anutu bentotombaa hoŋa koloowaatiwaajoŋ mamboma laligoro. Iinoŋ Juuda yoŋoo jigo kaunsol tuumbaa jotamemeya moŋ kolooŋ Sabat kendonoŋ kanaimambaa anotiwaajoŋ ama toroko yakariŋ Pailotwaanoŋ kema Jiisaswaa qamoya memambaajoŋ qisiro. ");
INSERT INTO ksr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Qisiro “Oŋanoŋ komuja me qaago?” jeŋ romoŋgoŋ kawali galeŋa jero karo “Jiisasnoŋ kambaŋ koriga me toroga komuja,” jeŋ qisiŋ muro. ");
INSERT INTO ksr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Qisiŋ muro buju qaaya moma Jiisaswaa qamoya Joosef jeŋ tegoŋ muro. ");
INSERT INTO ksr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jeŋ tegoŋ muro opo taaŋa sewaŋa meŋ kema qamoya maripoonoŋga qetegoŋ meŋ kamaaŋ oponoŋ esuuro. Esuuŋ meŋ qasirinoŋ kema jamo kobaa uroroogi duŋ eroti, iikanoŋ ano. Ama jamo somata moŋ metano kobaa qaa oota kojaŋgiro. ");
INSERT INTO ksr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Dakanoŋ anoti, ii Maria Magdalaga ano Maria Jooseswaa nemuŋa yoronoŋ nama iiri. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat kendoŋ ragi tegoro iikanoŋ Maria Magdalaga, Maria Jeimswaa nemuŋa ano Salome yoŋonoŋ “Jiisaswaa qamoya kema moriwoŋa,” jeŋ jiniŋ marae uŋkoowagawo sewaŋa megi. ");
INSERT INTO ksr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Meŋ eŋ Sonda umugawodeeŋ waama gomaŋ ano weeŋ jiliŋjolaŋ kouro qasirinoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kema amiŋ moma jegi, “Qasiriwaa qaa ootanoŋ jamo somata raji, ii mono moronoŋ qetambaa?” ");
INSERT INTO ksr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kaeŋ jeŋ uugi keno iigi: Jamo somata qatawo ii mono qetaŋgi kema ero. ");
INSERT INTO ksr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Qasiriwaa jamo qaa oota kaeŋ aantama nano uutanoŋ ugi. Ugi dindiŋgiaageŋ eja gbaworo moŋ malekuya koriga taaŋa raro iigi. Kaeŋ iima mamaga awawaligi. ");
INSERT INTO ksr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Awawaligito, kokaeŋ iŋijoro, “Mono toroko mende mobu. Oŋo Nazaret eja Jiisaswaajoŋ moŋganju. Ii maripoonoŋ qegito, iinoŋ mono gbiliŋ waaja. Kawaajoŋ koi mende eja. Iibu! Duŋa koi, iikanoŋ sulugi ero. ");
INSERT INTO ksr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kawaajoŋ mono kema Piito ano gowokouruta kuuya buju kokaeŋ iŋijowu, ‘Iinoŋ mono jeta meŋ oŋoma waladeeŋ Galili prowinsnoŋ kembaa. Oŋo kaaŋagadeeŋ iikanoŋ kema qaaya jerotiwaa so ii iibu.” ’ ");
INSERT INTO ksr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kaeŋ iŋijoro aaruŋ jeneŋgia ororo jamo ootanoŋga kamaaŋ bobogariŋ keŋgi. Sombugia mogitiwaajoŋ qaa moŋ mende jegito, qaagia bogoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jiisasnoŋ Maria Magdalaga iwaa uutanoŋga omejiilaŋ 7 oŋotaaro laligoro. Jiisasnoŋ koomunoŋga waama Sonda gomaamba amandiinoŋ wala Maria ii asugiŋ muro. ");
INSERT INTO ksr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Asugiŋ muro alaurutanoŋ Jiisaswo laligoŋ kouma kambaŋ iikanoŋ jiŋgeŋ qama saagiti, Marianoŋ mono iyoŋoonoŋ kema bujuya iŋijoro. ");
INSERT INTO ksr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Iŋijoroto, Jiisasnoŋ gbiliŋ laligoro Marianoŋ iiroti, ii mende moma laarigi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kawaa gematanoŋ alawoitanoŋ Jerusalem siti mesaoŋ gomaŋ moŋnoŋ kembojoŋ kananoŋ keni Jiisasnoŋ kaitania meleema asugiŋ orono. ");
INSERT INTO ksr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Yoronoŋ kaaŋagadeeŋ kema bujuya ii alauruta iŋijorito, yoŋonoŋ ii kaaŋagadeeŋ mende moma laarigi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kanageŋ gowokouruta 11 yoŋonoŋ ajorooŋ nene neŋ ragi yoŋoonoŋ kaaŋagadeeŋ asugiro. Asugiŋ uugia kotiirotiwaajoŋ temboma koomunoŋga waaro iigiti, iinoŋ bujuya iŋijogi ii mende moma laarigitiwaajoŋ ii jeŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jiisasnoŋ kokaeŋ iŋijoro, “Oŋo mono kantri so kema gomaŋa gomaŋa liligoŋ ejemba laligoŋ kenjutiwaa so Oligaa Buŋana jeŋ asarigi mobu. ");
INSERT INTO ksr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Moŋnoŋ Anutu moma laariro oomulu meŋ mugi uuta meleembaati, iinoŋ mono letoma Siwewaa buŋa koloowaa. Moŋnoŋ mende moma laariŋ yaŋgiseŋ laligowaati, Anutunoŋ mono iwaa qaa jeŋ tegoro gere siawaa buŋa koloowaa. ");
INSERT INTO ksr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Moma laariŋ noma laligowuti, ii aiwese meŋ oŋombe kaniagia kokaeŋ koloowaa: Yoŋonoŋ noo qanoŋ omejiilaŋ oŋotaawuya. Kantri tosia yoŋoonoŋ qaa jeŋ laligowuya. ");
INSERT INTO ksr_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mokoleŋ borogianoŋ meŋ metaambuya. Nombeŋ warabe apu iwoi negi iikanoŋ mono mende meŋ boliŋ oŋombaa. Borogia ji ejemba qagianoŋ aŋgi qeaŋgowuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Poŋ Jiisasnoŋ qaaya kaeŋ iŋijoro Anutunoŋ wano Siwenoŋ uma Anutuwaa boro dindiŋanoŋ rama laligoja. ");
INSERT INTO ksr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Eu laligojato, gowokourutanoŋ mesaoŋ gomaŋ baloŋ so kema Buŋa qaaya jeŋ seiŋ laligogi. Kaeŋ laligogi Poŋnoŋ yoŋowo gawoŋ meŋ inaaŋ oŋono aŋgoleto asugiro qaagianoŋ kotiiro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Gejatootoo ejembanoŋ Hamoqeqe Toya koloowaatiwaa qaa jegi iikawaa hoŋa batunananoŋ asugiroti, ejemba mamaganoŋ kawaa sunduya kanaiŋ oogi. ");
INSERT INTO ksr_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Iwoi hoŋa ii batunananoŋ asugiro tosianoŋ ii kanakanaiyanoŋga kanaiŋ kouma iyaŋgiaa jaagianoŋ iima moma yagogiti, yoŋonoŋ iikawaa so kawaa bujuya toroqeŋ jeŋ seigi gejanananoŋ kemeŋ ananaa buŋa kolooro. Ejemba kaaŋa yoŋonoŋ Buŋa ii kanaiŋ papianoŋ ooŋ areŋgogita eja. ");
INSERT INTO ksr_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Niinoŋ kaaŋagadeeŋ iwoi kuuya asugiŋ kouroti, ii tororo qisiŋ oŋombe kanianoŋga kanaiŋ jegi moma kotojeŋ. Oo Tiofilus niinoŋ goojoŋ mobe uuta koloojaŋ. Niinoŋ giwo qaa amiŋ mobotiwaajoŋ mobe awaa kolooro Jiisaswaa sunduya ii kuuyagadeeŋ areŋgoŋ oojeŋ. ");
INSERT INTO ksr_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Buŋa qaa hoŋa kuma goŋgi mojaŋi, giinoŋ iikawaa kania weeŋgoŋ korebore moma komuwa. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judia prowinswaa kiŋ qata Herod iwaa kambaŋanoŋ eja moŋ qata Zekaraia laligoro. Iinoŋ jigo gawoŋ galeŋ laligoŋ Abaiawaa gawoŋ areŋnoŋ nano. Embia qata Elisabet iinoŋ kaaŋagadeeŋ jigo gawoŋ galeŋ Aarombaa gbili moŋ kolooro. ");
INSERT INTO ksr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Yoronoŋ Anutuwaa jaanoŋ laaligo dindiŋa laligoŋ Pombaa jojopaŋ qaa ano jeŋkooto ii kuuya tororo otaaŋ koposowaa qaagara qaa laligori. ");
INSERT INTO ksr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Laligorito, Elisabetnoŋ kopimbaajoŋ gbiligara qaa laligoŋ ejemba waŋa koloori. ");
INSERT INTO ksr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kambaŋ moŋnoŋ Abaiawaa gawoŋ areŋ kambaŋanoŋ karo Zekaraianoŋ jigonoŋ galeŋ gawoŋ mewaatiwaajoŋ Anutuwaa jaasewaŋanoŋ kouro. ");
INSERT INTO ksr_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kouro jigo gawoŋ galeŋ yoŋonoŋ kaiyakagia otaaŋ batugianoŋ gawoŋ mendeema Zekaraia metogogi Pombaa alatanoŋ uma jiniŋ moroŋawo ooro. ");
INSERT INTO ksr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Jiniŋ marae ooŋooŋ kambaŋanoŋ kaŋ kuuro iinoŋ iwoi moroŋawo ii ooro ejemba tuuŋ kuuya yoŋonoŋ jiwowoŋ jigo seleeŋgeŋ mamboma Anutu qama kooliŋ ragi. ");
INSERT INTO ksr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jiniŋ ooro moroŋanoŋ pumpuŋgoŋ miri uuta sokono kanoŋ Pombaa gajoba moŋnoŋ alatanoŋ eu asugiŋ muŋ boria dindiŋaageŋ nano. ");
INSERT INTO ksr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nano Zekaraianoŋ iima aaruŋ toroko moro. ");
INSERT INTO ksr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Toroko moroto, gajobanoŋ kokaeŋ ijoro moro, “Zekaraia, gii toroko mende moba. Anutunoŋ qamakooliga modaboroja. Kawaajoŋ embaganoŋ koro ama koko meraga mewaa. Ii mero giinoŋ qata Jon qaba. ");
INSERT INTO ksr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Meraga kolooro uuganoŋ iwaajoŋ qeaŋgoro aisoona ejemba mamaganoŋ korisoro mobuya. ");
INSERT INTO ksr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ii nemuŋaa goroŋ uutanoŋ raro Uŋa Toroyanoŋ iikanondeeŋ kanaiŋ uuta saa qero somariiŋ wain me apu kotiga ii mende neŋ Pombaa kooroŋanoŋ eja uuta kolooŋ laligowaa. ");
INSERT INTO ksr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kaeŋ laligoŋ Israel ejemba mamaga uugia meleeno Poŋgia Anutuwaanoŋ eleembuya. ");
INSERT INTO ksr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Anutuwaa Uŋanoŋ gejatootoo eja Elaija inaaro ku-usuŋ qaganoŋ gawoŋ meroti, iinoŋ mono iikawaa so waladeeŋ keno Poŋnoŋ gematanoŋ kawaa. Iinoŋ kema kanageso uu kuuŋ oŋono Poŋnoŋ kawaatiwaajoŋ jojoriŋ nambuya. Maŋ ano merabora juma deeŋgi uukuukuu meŋ oŋono mombo metulaŋgoŋ aowuya ano qootogo ejemba ii dindiŋa yoŋoo momo areŋnoŋ keubuya.” ");
INSERT INTO ksr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Siwe gajobanoŋ kaeŋ ijoro Zekaraianoŋ jero, “Embanawo noronoŋ ejemba waŋa koloojotiwaajoŋ qaaganoŋ mono nomaeŋ hoŋawo koloonaga?” ");
INSERT INTO ksr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kaeŋ jero meleeno, “Nii Geibriel. Niinoŋ Anutuwaa wambu-sooŋanoŋ nambe wasiŋ nono buju awaa koi meŋ kaŋ gijowe mojaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Noo qaa jena hoŋawo koloowaati, giinoŋ ii jewe mende moma laarijaŋiwaajoŋ qaaga mono muuŋgoro nekoŋ laligowa. Kaeŋ laligona buju qaa kokawaa hoŋa koloowaatiwaa kambaŋa kaŋ kuuro iikanoŋ neselaŋga lolooro qaa mombo jewaga.” ");
INSERT INTO ksr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kambaŋ biiwianoŋ kanoŋ ejembanoŋ mamboma rama Zekaraianoŋ jiwowoŋ jigonoŋ eu kambaŋ koriga nanotiwaajoŋ uugianoŋ motoqoto mogi. ");
INSERT INTO ksr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kaeŋ ama ragi seleeŋgeŋ kamaaŋ qaa jemambaajoŋ amamaaro moma asariŋ kokaeŋ jegi, “Iinoŋ jiwowoŋ jigonoŋ nama jaaya meleeno Siwenoŋga uŋa moŋ iija.” Kaeŋ jegi borianondeeŋ kaisare ama oŋoma nekoŋ kolooŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kaeŋ laligoŋ jigo gawoŋ meme kambaŋanoŋ tegoro eleema mirianoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Weeŋ tosia tegoro Elisabetnoŋ koro ama koiŋ 5 kawaa so mirinoŋ asaŋgoŋ kokaeŋ jeŋ rama laligoro, ");
INSERT INTO ksr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Merana qaawaajoŋ ejembanoŋ meŋ kamaaŋ noŋgi Poŋnoŋ wambusooŋ qeŋ noma iikawaa lombota meŋ giliŋ kiaŋkomuŋ nonja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabetnoŋ koro anotiwaa koiŋa 6 kolooro Anutunoŋ gajobaya qata Geibriel wasiro Galili prowinswaa gomaŋa moŋ qata Nazaret kanoŋ kamaaro. ");
INSERT INTO ksr_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kamaaŋ emba saraŋ jumuŋa qata Maria iwaanoŋ keno. Iinoŋ eja qata Joosef iwaa emba buŋaga laligoro. Joosefnoŋ kiŋ Deiwidwaa gbilia moŋ kolooro. ");
INSERT INTO ksr_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gajobanoŋ Mariawaanoŋ kema kokaeŋ ijoro, “Oo Maria, weeŋga awaa. Poŋnoŋ kaleŋmoriaŋ goma giwo namba.” ");
INSERT INTO ksr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kaeŋ ijoroto, Marianoŋ joloŋ iikawaajoŋ mamaga aaruŋ kania moŋgama motoqoto moro. ");
INSERT INTO ksr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Motoqoto moro kokaeŋ ijoro, “Maria, Anutunoŋ kaleŋmoriaŋ gono iwaa jaanoŋ sokonjaŋ. Kawaajoŋ toroko mende moba. ");
INSERT INTO ksr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Moba, giinoŋ koro ama koko meraga mewaga. Meŋ qata Jiisas qaba. ");
INSERT INTO ksr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jiisas iinoŋ somariiŋ eja qabuŋayawo kolooro qata ‘Uuta somataa Meria,’ qagi laligowaa. Kaeŋ laligoro Poŋ Anutunoŋ amboya kiŋ Deiwidwaa jiŋkaroŋ duŋ muro ejemba galeŋ koma oŋoma laligowaa. ");
INSERT INTO ksr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jeikobwaa kanageso yoŋoo kiŋgia kolooŋ tetegoya qaa galeŋ koma oŋoma laligowaa. Bentotoŋa iikanoŋ mono kambaŋ moŋnoŋ mende qaombaa.” ");
INSERT INTO ksr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Gajobanoŋ kaeŋ ijoro Marianoŋ jero moro, “Yei! Nii ejawaa kania mende mojeŋ. Kawaajoŋ qaa jejaŋi, iikawaa hoŋa mono nomaeŋ koloowaa?” ");
INSERT INTO ksr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kaeŋ jero moma meleeno, “Uŋa Toroyanoŋ mono aŋgoŋ koma gono Anutu uuta somataa esuŋanoŋ sokoma turuŋ gombaa. Kawaajoŋ mera mewagati, iinoŋ toroya kolooro ejembanoŋ qata ‘Anutuwaa Meria,’ jeŋ qamakebuya. ");
INSERT INTO ksr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Moba. Tinitosaga Elisabet iinoŋ kaaŋagadeeŋ ‘Kopiŋ laligoŋ mera memambaajoŋ amamaaja,’ jegito, kileŋ emba waŋa kolooŋ kambaŋ kokaamba koko merawaa koroyawo kolooro koiŋa 6 kolooja. ");
INSERT INTO ksr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Anutunoŋ iwoi moŋ amambaajoŋ jeŋ ii mende amamaaŋkeja.” ");
INSERT INTO ksr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kaeŋ jero Marianoŋ ijoro, “Moba, niinoŋ Pombaa weleŋqeqe emba koloojeŋ. Kawaajoŋ qaa jejaŋi, iikawaa so saanoŋ kolooŋ nomba.” Kaeŋ ijoro Siwe gajobanoŋ mesaoŋ keno. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Marianoŋ ii moma kambaŋ koriga mende kolooro waama uulaŋawo jojoriŋ gomaŋ baaŋanoŋ uma Judia prowinswaa taoŋa moŋnoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kema Zekaraiawaa mirinoŋ uma embia Elisabet iima aisooŋ joloŋa jero. ");
INSERT INTO ksr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Joloŋa jero iikanondeeŋ moro koko meranoŋ goroŋ uutanoŋ luguŋ uma kamaaro Uŋa Toroyanoŋ Elisabetwaa uuta saa qero. ");
INSERT INTO ksr_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Saa qero qa somata qama kokaeŋ jero, “Oo alana, Anutunoŋ kotumotueya uuta ama gono emba batunananoŋ laligowaga ano mera mewagati, ii kaaŋiadeeŋ kotuegoŋ mubaa. ");
INSERT INTO ksr_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nomaembaajoŋ Poŋnaa nemuŋanoŋ kaŋ niiro kaeŋ kolooŋ nonja? ");
INSERT INTO ksr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Moba, gii jolona jena qaa aroga gejananoŋ kemero meranoŋ goronanoŋ kaaŋagadeeŋ korisoro qaganoŋ luguŋ uma kamaaja. ");
INSERT INTO ksr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Poŋnoŋ buju qaaya jero moma iikawaa hoŋa asugiwaati, ii moma laarijaŋiwaajoŋ goojoŋ mobe simbawoŋawo koloojaŋ.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Marianoŋ qaa ii moma kokaeŋ jero, “Ii-ia! Noo uu kononanoŋ mono jinoŋa qaa Poŋ mepeseeja. ");
INSERT INTO ksr_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Noo uŋananoŋ Anutu, Hamoqeqe Tonaajoŋ aisooŋ koriaŋ maaja. ");
INSERT INTO ksr_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Niinoŋ weleŋqeqe emba kamaaŋqeqeta laligojento, Anutunoŋ kileŋ ba koma kiaŋkomuŋ nonja. Moba, ejemba tuuŋa tuuŋa kete kanaiŋ koloowuti, yoŋonoŋ mono noojoŋa ‘Simbawoŋawo!’ jeŋ mepeseeŋ noma laligowuya. ");
INSERT INTO ksr_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ku-usuŋ Toyanoŋ mono aŋgoleto uuta meŋ nono laligojeŋ. Iwaa qata ii Toroya. ");
INSERT INTO ksr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ejemba kete namonoŋ laligojuti ano kanageŋ kolooŋ seiwuti, iyoŋoo batugianoŋ isi daeŋ yoŋonoŋ Anutuwaa jeta uuguwubotiwaa toroko mobuti, iwaa kiaŋkomuyanoŋ mono yoŋowo pondaŋ ewaa. ");
INSERT INTO ksr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Anutunoŋ borianoŋ aŋgoleto meŋ iikanoŋ usuŋa qendeema nonono iiniŋ. Ejemba iyaŋgia meŋ biwiiŋ aoŋ sewaŋpiriŋ laligojuti, Anutunoŋ mono ii kondeema oŋono simbiriŋsambaraŋ kolooŋ laligoju. ");
INSERT INTO ksr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kiŋ poŋa poŋa jiŋkaroŋ duŋgianoŋ rama ejemba galeŋ koma oŋoma laligogiti, Anutunoŋ ii iikanoŋa qetegoŋ utama oŋono kamaagi. Kamaagito, kamaaŋqeqeta iiga mono meŋ uma oŋono. ");
INSERT INTO ksr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ejemba iwoiwaa memeqemeyaŋ ama laligogiti, iyoŋoo uugia mono iwoi awaa awaanoŋ saa qeroto, ejemba qaqabuŋagiawo ii wasiŋ oŋono borogia bobora eeŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Anutunoŋ ambosakoŋurunana metogoŋ uŋuano Israel koloogi nono toroqeŋ Anutuwaa weleŋqeqeuruta laligojoŋ. Anutunoŋ wala eeŋanoŋ jojopaŋ qaaya kokaeŋ jeŋ somoŋgoŋ nonono, ‘Niinoŋ Aabram ano iwaa gbiliuruta tetegoya qaa laligoŋ uma laligowuti, ii kiaŋkomuŋ oŋoma laligomaŋa.’ Kaeŋ jeŋ qaaya ii mende duduuŋ laligoŋ kouro. Qaagoto, iinoŋ mono qaa jeta ii otaaŋ laligoŋ kete baagoŋ nonomambaajoŋ kaja.” Marianoŋ kaeŋ jero. ");
INSERT INTO ksr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Marianoŋ koiŋ karooŋ kawaa so Elisabetwo laligoŋ mombo mirianoŋ eleeno. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabetwaa mera meme kambaŋanoŋ kaŋ kuuro koko meraga mero. ");
INSERT INTO ksr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Koko meraga mero miri kosianoŋ laligogiti ano tinitosauruta yoŋonoŋ Poŋnoŋ kiaŋkomu uuta qendeema muroti, ii moma asariŋ iwo motooŋ korisoro aŋgi. ");
INSERT INTO ksr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Korisoro ama weeŋ 7 tegoro waama kema Anutuwaa aiweseya mera selianoŋ kotowutiwaajoŋ ajoroogi. Ajorooŋ maŋaa qata Zekaraia ii wase meŋ muwombaajoŋ jegi. ");
INSERT INTO ksr_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Jegito, nemuŋanoŋ jero, “Ii qaagoto, qata mono Jon qaboŋa.” ");
INSERT INTO ksr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Jero kokaeŋ ijogi moro, “Jon qajanto, goo tinitosaga yoŋoonoŋga mombaa qata kaeŋ mende eja.” ");
INSERT INTO ksr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kaeŋ ijogi nama maŋanoŋ iwaa qata qabaatiwaa qisiŋ borogianoŋ kaisare aŋgi. ");
INSERT INTO ksr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kaisare aŋgi tafewaajoŋ qisiro mugi iikanoŋ tere kokaeŋ ooro, “Qata ii Jon.” Kaeŋ ooro iikawaajoŋ kuuya aaruŋ tililiŋgogi. ");
INSERT INTO ksr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Aaruŋ tililiŋgogi iikanondeeŋ buuta afaaŋgoro neselaŋa lolooro qaa jeŋ Anutu mepeseero. ");
INSERT INTO ksr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mepeseero alaurugia kuuya yoŋonoŋ qarasombugia mamaga mogi. Mogi iwoi kolooroti, iikawaa bujuya amiŋ mogi seiŋ Judia baaŋa gomaŋ kuuya sokono. ");
INSERT INTO ksr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bujuya amiŋ mogi kuuyanoŋ ii moma uu konoŋgianoŋ ama aŋgoŋ koŋgi. Poŋnoŋ ku-usuŋa kokosaposapo qaganoŋ maaro laligoroti, iikawaa kania moma asariŋ kokaeŋ jegi, “Mera koi kanoŋ somariiŋ mono naa iwoiga moŋ nomaeŋ ama menaga?” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Kaeŋ jegi Uŋa Toroyanoŋ maŋa Zekaraiawaa uuta saa qero gejatootoo qaa kokaeŋ jero, ");
INSERT INTO ksr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Nono Israel nonoonoŋ Poŋ Anutu mepeseewoŋa. Ii-ia! Iinoŋ mono kanagesouruta ba koma nonoma dowenana memambaajoŋ jojoriŋ kawaa. ");
INSERT INTO ksr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Anutunoŋ weleŋ ejia kiŋ Deiwidwaa kanageso nonoo batunananoŋga eja ku-usuŋawo kuuro waama Hamoqeqe Tonanaga koloowaa. ");
INSERT INTO ksr_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Monowaa monoyanoŋga gejatootoo ejembauruta tak-kootoya ii sololooŋ oŋono qaa je kokaeŋ jeŋ laligogi, ");
INSERT INTO ksr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘Niinoŋ mono kereurugia yoŋoo esuŋgia qewe kamaaro oŋoo sewaŋgia somoŋgomaŋa. Daeŋ yoŋonoŋ kazi ama oŋombuti, niinoŋ mono kuuya iyoŋoo borogianoŋga metogoŋ sopa somoŋgoŋ oŋomaŋa.’ ");
INSERT INTO ksr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Qaa kaeŋ jeŋ beŋurunana kiaŋkomuŋ oŋoma yoŋowo soomoŋgo areŋ tania moŋ somoŋgoroti, ii romoŋgoŋ otaaro hamoqeqewaa hoŋa asugiwaa. ");
INSERT INTO ksr_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Soomoŋgo qaa ii beŋnana Aabrahambaajoŋ jeŋ jojopaŋ qaanoŋ jeŋ kotiirota eja. ");
INSERT INTO ksr_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Soomoŋgo qaa iikawaa hoŋa kokaeŋ: Iinoŋ nono kereurunana yoŋoo borogianoŋga metogoŋ nonono yoŋoojoŋ toroko mende moma weleŋa qeŋ muŋ laligowoŋa. ");
INSERT INTO ksr_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Iinoŋ qaanana jeŋ tegoro solaŋaniŋ iwaa jaanoŋ soraaya kolooŋ laaligonana hoŋa dindiŋa kaeŋ laligoŋ komuwoŋa. ");
INSERT INTO ksr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Oo kokona Jon, giinoŋ somariiŋ laligoŋ waladeeŋ kema ejemba uugia mindiŋgoŋ iikaaŋ ama Pombaa kania meleuna kawaa. Kawaajoŋ qaga ‘Anutu uuta somataa gejatootoo ejaga,’ kaeŋ qagi laligowaga. ");
INSERT INTO ksr_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kaeŋ laligoŋ hamoqeqe Toyaa kania ii Anutuwaa kanagesouruta kuma oŋona ii moma kotoŋ uugia meleeŋgi Anutunoŋ siŋgisoŋgogia soŋgbama mesaowaa. ");
INSERT INTO ksr_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Anutunananoŋ uutanoŋ jopagoŋ kiaŋkomuŋ nonomakeja. Kaeŋ ama ba koma nonoma widia eukanoŋa ano bilikbilik anja. Kawaajoŋa nononoŋ mono weŋgeraŋ suluro asuganoŋ asariwombaa anjoŋ. ");
INSERT INTO ksr_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nono paŋgamanoŋ tiŋtuaŋ raniŋ koomuwaa kondomondo Toyanoŋ aŋgoŋ koma nonomakejato, weeŋ jiliŋjolaŋ kouma qanananoŋ kuuŋ meŋ asariŋ nonombaa. Meŋ asariŋ nonono luaewaa kania asuganoŋ asugiro iima iikanoŋ keuma riiŋ namboŋa.” Zekaraianoŋ kaeŋ jero. ");
INSERT INTO ksr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mera Jon iinoŋ somariiŋ waaro Uŋa Toroyanoŋ inaaŋ muro Anutuwaa qele eja kotakota kolooro. Kaeŋ kolooŋ baloŋ qararaŋkoŋkoŋanoŋ laligoro kambaŋanoŋ kaŋ kuuro Israel kanageso yoŋoo jaagianoŋ asuganoŋ asugiŋ qenjaaro gawoŋa kanaiŋ mero. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jon Oomulu ejanoŋ kolooro kambaŋ kanoŋ Siisa-kiŋ Oogastus iinoŋ Room sitinoŋ gomaŋa gomaŋa galeŋ koma oŋono. Galeŋ koma oŋoma takis kanaiŋ mewutiwaajoŋ gawmambaa jeŋkooto ano gomaŋa gomaŋa kuuya yoŋonoŋ ajoroogi kuskus (sensus eja) yoŋonoŋ qagia papianoŋ ooŋ areŋgogi. ");
INSERT INTO ksr_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Areŋ gawoŋ ii kambaŋ mutuyaga megi. Megiti, kambaŋ iikanoŋ eja qata Kwirinius iinoŋ Siria prowinswaa gawana laligoŋ galeŋ koma oŋono. ");
INSERT INTO ksr_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Oogastusnoŋ jeŋkooto ano ejemba korebore horoŋ keuma qagia areŋnoŋ oowutiwaajoŋ iyaŋgiaa kolokoloo gomaŋgia waŋa so keŋgi. ");
INSERT INTO ksr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Galili prowinswaa taoŋ qata Nazaret iikanoŋ eja qata Joosef laligoro. Iwaa amboya ii kiŋ Deiwid. Kiŋ Deiwidwaanoŋ taoŋ qata Betlehem ii Judia prowinsnoŋ ero. Kawaajoŋ Joosefnoŋ Nazaret mesaoŋ uma kemeŋ Betlehem keno. ");
INSERT INTO ksr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kemaŋ jero kambaŋ kanoŋ emba buŋaya qata Maria ii koroyawo laligoro. Laligoro ii aima ŋaoŋ qagara oowutiwaajoŋ motooŋ keni. ");
INSERT INTO ksr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kema Betlehem keuri Mariawaa mera meme kambaŋanoŋ kaŋ kuuro. ");
INSERT INTO ksr_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kaŋ kuuro qenjaaro ee mirinoŋ keuma iikawaa uutanoŋ tintiŋa moŋ mende mokoloori. Kawaajoŋ bao bulmakao mirianoŋ uma rari. Rama iikanoŋ mutu meria meŋ oponoŋ esuuŋ bulmakao juuyanoŋ ano kemeŋ ero. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Betlehem taoŋ gomaŋ kanoŋ eja tosianoŋ gomantiiŋa so baloŋ koria iikanoŋ kema lama tuuŋgia galeŋ koma oŋoma laligogi. ");
INSERT INTO ksr_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kaeŋ laligogi gomantiiŋa kanoŋ Pombaa gajoba moŋnoŋ kosogianoŋ asugiŋ oŋono. Asugiŋ oŋono Pombaa asamararaŋanoŋ liligoŋ oŋoma asariro sombugia moma jeneŋgia ororo. ");
INSERT INTO ksr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Jeneŋgia ororoto, Siwe gajobanoŋ iŋijoro, “Mono geja ambu! Niinoŋ korisoro Buŋa somata ejemba korebore yoŋoojoŋ meŋ kajeŋ, ii iŋisaama oŋomaŋa. Kawaajoŋ jeneŋgia mono mende orowa. ");
INSERT INTO ksr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Buŋa ii kokaeŋ: Oŋoo Hamoqeqe Togianoŋ keteda koi kolooja. Iinoŋ kiŋ Deiwidwaa taonoŋ kolooŋ Poŋ qata Kraist kolooja. ");
INSERT INTO ksr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Qaa iikawaa aiweseya ii kokaeŋ: Oŋo mono kema mera sayawo oponoŋ esuuŋ bulmakao juuyanoŋ aŋgi eji, ii mokoloowu.” ");
INSERT INTO ksr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Gajobanoŋ kaeŋ jero iikanondeeŋ gajoba tuuŋ somatanoŋ Siwenoŋga asugiŋ iwo aitoŋgoŋ Anutuwaa mepemepesee rii qama kokaeŋ jegi, ");
INSERT INTO ksr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Anutuwaa qabuŋaya mepeseeniŋ Siwenoŋ eukanoŋ uja. Iinoŋ ejemba iyaŋaajoŋ meweeŋgoŋ oŋonoti, iyoŋoojoŋ uuqeeaŋgo moma balonoŋ luae ama oŋonja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Gajoba yoŋonoŋ oŋomesaoŋ Siwenoŋ eleema ugi lama galeŋ yoŋonoŋ aŋgio kokaeŋ jegi, “Ayo, Betlehem kanoŋ iwoi kolooro Poŋnoŋ iikawaa qaaya jero mojoŋi, nono mono ii kema iiboŋa.” ");
INSERT INTO ksr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kaeŋ jeŋ esuŋgiagadeeŋ kema Maria Joosef ano mera sayawo bulmakao juuyanoŋ eroti, mokolooŋ iigi. ");
INSERT INTO ksr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Iima nama gajobanoŋ merawaa qaa jero moma kagiti, ii iŋisaama jeŋ asarigi. ");
INSERT INTO ksr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Jeŋ asarigi mogiti, iyoŋonoŋ korebore aaruŋ waliŋgogi. ");
INSERT INTO ksr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Waliŋgogito, Marianoŋ qaa kuuya ii uu konoŋanoŋ ama duŋguŋ somoŋgoŋ kania romoŋgoŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Waliŋgogito, iwoi kuuya Siwe gajobanoŋ jerotiwaa so asugiroti, ii lama galeŋ yoŋonoŋ iima moma kawaajoŋ Anutuwaa korisoro rii qama mepeseegi. Mepeseeŋ mesaoŋ eleema keŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jiisas kolooro Sonda motooŋgo kawaa so tegoro Anutuwaa aiweseya selianoŋ kotowombaa kambaŋa karo qata Jiisas qagi. Siwe gajobanoŋ qa ii waladeeŋ qama murogo kambaŋ iikanondeeŋ nemuŋaa goroŋ uutanoŋa kolooro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mooseswaa Kana qaanoŋ qaa kokaeŋ eja, “Embanoŋ koko meria mutuya meŋ weeŋ 40 kuuŋanoŋ laligoro tegoro suru guluga koma konjoratiŋ muŋ oŋo mono jiwowoŋ jigonoŋ uma mera ii Pombaa jaanoŋ aŋgi iwaa buŋa koloowaa.” Kawaajoŋ kambaŋ ii kaŋ kuuro Joosef Maria yoronoŋ qaa ii teŋ koma Jiisas wama Pombaa buŋa koloowaatiwaajoŋ Jerusalem uri. ");
INSERT INTO ksr_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Pombaa Kana qaanoŋ qaa kokaeŋ oogita eja, “Mera mutuya kuuya ii mono qegi Pombaa buŋa soraaya koloowuya.” Yoronoŋ qaa ii otaari. ");
INSERT INTO ksr_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kaaŋagadeeŋ Pombaa Kana qaanoŋ jeŋkooto qaa ejiwaa so kewo me kewosusu kooŋ woi ii siimoloŋ oowaotiwaajoŋ Jerusalem sitinoŋ uma keni. ");
INSERT INTO ksr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kambaŋ iikanoŋ eja moŋ qata Simeon Jerusalem laligoro. Iinoŋ uuta jumuŋa Anutuwaanoŋ qokotaaŋ uumeleembaa komagbiligbili ano Uŋa Toroyanoŋ iwo nano Hamoqeqe Toyanoŋ Israel uutanoŋ asugiwaatiwaajoŋ mamboma laligoro. ");
INSERT INTO ksr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mamboma laligoro Uŋa Toroyanoŋ qaa kokaeŋ isaano, “Gii Pombaa Hamoqeqe Toya Kraist asugiro wala iimago koomuwagatiwaa siimboboloya mobaga.” ");
INSERT INTO ksr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nemuŋmaŋanoŋ Mooseswaa Kana qaa otaaŋ Jiisas wama jiwowoŋ jigonoŋ uri. Uri Uŋa Toroyanoŋ Simeon sololooro kambaŋ iikanondeeŋ kaaŋagadeeŋ jigonoŋ uro. ");
INSERT INTO ksr_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Uma mera ii iima meŋ dooŋgoŋ Anutu mepeseeŋ kokaeŋ jero, ");
INSERT INTO ksr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Oo Poŋ, kete weleŋ ejaganoŋ saanoŋ kema uuluaenoŋ laligoŋ komuwaa. ");
INSERT INTO ksr_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Goo qaaga eji so Hamoqeqe Toya wasina asugiro ii neenaa jaananoŋ iima simbawoŋawo mojeŋ. Kawaajoŋ saanoŋ kema komumaŋa. ");
INSERT INTO ksr_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Giinoŋ hamoqeqe gawombaa kania mozozoŋgoŋ kantri kuuya yoŋoojoŋ iŋisaama oŋona ii iima moma kotowu. ");
INSERT INTO ksr_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Giinoŋ Hamoqeqe Toyaa asasaga iŋisaana waba kantri yoŋoo uugia kuuro asariwu ano qabuŋaganoŋ geeŋgaa kanagesoga Israel nonoo batunananoŋ kaaŋiadeeŋ somariiwaa.” ");
INSERT INTO ksr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeonoŋ merawaajoŋ qaa kaeŋ jero nemuŋmaŋanoŋ moma kiko ama waliŋgori. ");
INSERT INTO ksr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Waliŋgori kotuegoŋ oŋoma nemuŋa Maria kokaeŋ ijoro, “Moba, Anutunoŋ mera koi kuuŋ ano Israel ejemba seiseiyanoŋ ii gema qeŋ kamaaŋ uŋuro mamaganoŋ uugia meleema qeaŋgowuya. Anutu aŋo ii ano aiwese kolooro mamaganoŋ ii toropere jeŋ mubuya. ");
INSERT INTO ksr_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Toropere jeŋ mugi uumomogia aasaŋgoya ii kaeŋ asuganoŋ asugiwaa. Geeŋgaa uuganoŋ kaaŋagadeeŋ wosobiri kolooro iikanoŋ soo sulutuk aaŋa kaaŋa uuga kuuŋ qosombaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Jerusalem kanoŋ gejatootoo emba waŋa moŋ qata Ana laligoro. Iwaa isia qata Aser, maŋa qata Fanuel. Emba kanoŋ saraŋanoŋ eja meŋ laligoro gbani 7 motooŋ laligori. ");
INSERT INTO ksr_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Laligori loya komuro malo kolooŋ laligoŋ kouro kambaŋ iikanoŋ gbania 84 kolooro. Iinoŋ kambaŋ so jiwowoŋ jigonoŋ uma ii weeŋ moŋ mende mesaoroto, gomantiiŋa asasaga Anutuwaajoŋ nene siŋgiŋ laligoŋ qama kooliŋ waeya meŋ mepeseeŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Iinoŋ kambaŋ iikanondeeŋ kouma mera ii iima Anutu mepeseero. Anutunoŋ Jerusalem ejemba dowegia mewaatiwaajoŋ mamboma laligogiti, kuuya iyoŋoojoŋ mera iikawaa kania jeŋ asariro mogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Joosef Maria yoronoŋ Poŋnoŋ areŋa jeŋ kotoro Kana qaanoŋ eji, ii kuuya ani tegoro Galili prowinsnoŋ eleema taoŋgara Nazaret kanoŋ keni. ");
INSERT INTO ksr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Meranoŋ somariiŋ waama kotiiŋ momakootoyanoŋ asugiŋ saa qero Anutuwaa kaleŋmoriaŋanoŋ turuŋ muro laligoro. ");
INSERT INTO ksr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jiisaswaa nemuŋmaŋanoŋ gbani so kiaŋkomu kendoŋ kambaŋanoŋ Jerusalem sitinoŋ uma kemakegi. ");
INSERT INTO ksr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kaeŋ laligoŋ Jiisas gbania 12 kolooro siligia amakejutiwaa so kambaŋa kaŋ kuuro kaaŋagadeeŋ uma keŋgi. ");
INSERT INTO ksr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kema laligoŋ kendoŋ kambaŋ iikanoŋ tegoro eleema mirigaranoŋ keni. Kenito, mera gbaworo Jiisasnoŋ Jerusalem raro nemuŋmaŋanoŋ ii mende moma kotori. ");
INSERT INTO ksr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","“Iinoŋ ejemba tuuŋlelembe yoŋowo kenja,” jeŋ weeŋ motooŋgowaa so kana kema sakiti ano alaurugara yoŋoo uugianoŋ qama moŋgani. ");
INSERT INTO ksr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Qama moŋganito, mende mokolooŋ mombo eleema Jerusalem kema moŋgani. ");
INSERT INTO ksr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Moŋgama laligori weeŋ karooŋ tegoro jiwowoŋ jigonoŋ uma iikanoŋ mokoloori. Mokoloori eja somata yoŋoo batugianoŋ raro. Raro kuma mugiti, ii moma qisiŋ oŋoma raro. ");
INSERT INTO ksr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Rama Buŋa qaawaa kania tororo moma asariŋ dindiŋagadeeŋ meleeno korebore yoŋonoŋ ii moma waliŋgogi. ");
INSERT INTO ksr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nemuŋmaŋanoŋ iima aaruŋ nemuŋanoŋ ijoro, “Merana, gii nomaembaajoŋ kaeŋ ama noronjaŋ? Moba, maŋgawo noro goojoŋ majakaka moma qama moŋgama laligori.” ");
INSERT INTO ksr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kaeŋ ijoro kokaeŋ meleema orono, “Oro mono naambaajoŋ nii moŋgama nonjao? Nii neenaa Amanaa mirinoŋ rabe sokonji, ii mojao me qaago?” ");
INSERT INTO ksr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kaeŋ meleema oronoto, yoronoŋ qaa jeroti, iikawaa kania ii mende moma asariri. ");
INSERT INTO ksr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Mende moma asaririto, kileŋ waama yorowo eleema Nazaret taonoŋ kema nemuŋmaŋa teŋ koma oroma laligoro. Jiisasnoŋ qaa jeroti, nemuŋanoŋ ii kuuya moma uu konoŋanoŋ ama somoŋgoŋ aŋgoŋ kono. ");
INSERT INTO ksr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jiisasnoŋ laligoŋ somariiro gbania uro momakootoya asariŋ seiro Anutunoŋ kaleŋmoriaŋa muro kotiiŋ ejemba ano Anutu yoŋoo jaagianoŋ sokoma oŋono. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Zekaraiawaa meria Jon iinoŋ gawoŋa kanairo. Kambaŋ kanoŋ Siisa-kiŋ qata Taiberius iinoŋ Room sitinoŋ laligoŋ gomaŋa gomaŋa mindiriŋ gbani 15 eja poŋ kolooŋ toroqeŋ galeŋ koma oŋono laligogi. Galeŋ koma oŋomambaajoŋ gomaŋa gomaŋa Israel liligoŋ ejuti, ii mosoŋgi bakaya 4 kolooro yoŋoo kiŋgia 4 ii kokaeŋ kuuŋ oŋoŋgi: Pontius Pailot, Herod, Filip ano Lisanias. Pontius Pailot ii Judia prowinswaa gawanagia laligoro. Kiŋ Herodnoŋ Galili prowins galeŋ koma oŋono ano data Filipnoŋ Ituria ano Trakonitis prowins woi yoŋoo poŋgiaga laligoro ano Lisanias iinoŋ Abilene gomaŋ meŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Jigo gawoŋ galeŋ waŋa woi laligori, qagara Anas ano Kaiafas. Kambaŋ kanoŋ Zekaraiawaa meria Jon iinoŋ baloŋ qararaŋkoŋ-koŋanoŋ laligoro Anutuwaanoŋ Buŋa qaa kolooro moro. ");
INSERT INTO ksr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Anutuwaa Buŋa moma kema Jordan apu bereŋaa kosianoŋ gomaŋ so liligoŋ laligoro. Liligoŋ laligoŋ Buŋa qaanoŋ uugia kuuŋ kokaeŋ jeŋ laligoro, “Oŋo mono uugia meleeŋgi niinoŋ oomulu meŋ oŋomaŋa. Kaeŋ aŋgi Anutunoŋ siŋgisoŋgogia soŋgbama mesaowaa.” ");
INSERT INTO ksr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kawaa qaaya ii gejatootoo eja Aisaianoŋ oorota iwaa Buju Terenoŋ kokaeŋ eja, “Qele gajoba moŋnoŋ baloŋ qararaŋkoŋkoŋanoŋ qama laligoro kema qata kokaeŋ mobu, ‘Poŋnoŋ kawa-oo! Kawaajoŋ mono jojoriŋ kania meleuwu. Mono uugia mindiŋgoŋ kania qeleleewu. ");
INSERT INTO ksr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kana dondooŋa kuuya mono qeŋ riigi dindiŋa koloowa. Baaŋa wanjaleya kuuya ii mono qetegoŋ koma qeleleegi koria koloowa. Kana misiqisiawo ii mono meagogi diŋgowa. Haamonoŋ kana kuno simbiriŋsambaraŋ eji, ii mono kotoŋ meleugi solaŋaniwa. ");
INSERT INTO ksr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Anutunoŋ oyaŋboyaŋ Toya wasiro karo gomaŋa gomaŋa kuuya yoŋonoŋ ii iima moma kotowuya.” ");
INSERT INTO ksr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jonoŋ kawaa so uugia kuuro ejemba tuuŋa tuuŋa yoŋonoŋ oomulu meŋ oŋombaatiwaajoŋ iwaanoŋ kagi iŋiima kokaeŋ iŋijoro, “Oo qato mokolembaa gbiliuruta, oŋo uugia mende meleeŋgi Anutuwaa iriŋa soono iroŋa meleema oŋomambaajoŋ anja. Ii oloŋ kombombaa gejanono qaaya ii mono moronoŋ iŋijoro sombugia moma koi kaju? ");
INSERT INTO ksr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","“Kawaajoŋ mono oŋanoŋ uugia meleembu. Kileŋagianoŋga eleeŋgi hoŋa kolooro ii mono nanamemeŋgianoŋ asuganoŋ qendeema laligowu. Uugianoŋ mondomondo qaa kokaeŋ mende romoŋgowu, ‘Nononoŋ Aabrambaa gbiliga laligoniŋ Anutunoŋ mende tiwilaaŋ nonombaa.’ Kaeŋ totogianoŋ qeŋkejuto, hoŋa ii mende amakeju. Niinoŋ kawaajoŋ kokaeŋ iŋijomaŋa: Anutunoŋ jamo koi saanoŋ jeŋ kotoŋ oŋono letoma Aabrambaa gbiliuruta kolooŋ Anutu mepeseeŋkebuto, oŋo mono nomaeŋ? ");
INSERT INTO ksr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","“Uugia mende meleembuti eeŋ, Anutunoŋ mono oŋo gere kaaŋa kono kamaawombaajoŋ anju. Gere kuuya hoŋa awaa mende kuuŋkejuti, ii mono kono kamaagi gere gagirinoŋ giliro kemebuya. Gere kaaŋa komambaa weŋa mono jeta suŋa ama gere kanianoŋ ano jojoriŋ eja. Anutunoŋ mono kileŋagiaa iroŋa meleema oŋombaa.” ");
INSERT INTO ksr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kaeŋ iŋijoro ejemba tuuŋa tuuŋa yoŋonoŋ kokaeŋ qisiŋ mugi, “Kawaajoŋ nono mono nomaeŋ aniŋ sokombaa?” ");
INSERT INTO ksr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Qisiŋ mugi kokaeŋ meleeno, “Moŋnoŋ maleku woi meŋ laligoji, iinoŋ mono yoroonoŋga moŋ ii malekuya qaa ii mubaa ano daeŋ yoŋonoŋ nenegiawo laligojuti, iyoŋonoŋ mono kaaŋagadeeŋ nenegia qaa yoŋoojoŋ mendeema oŋombu.” ");
INSERT INTO ksr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takis meme eja tosianoŋ kaaŋagadeeŋ oomulu meŋ oŋombaatiwaajoŋ kaŋ qisiŋ mugi, “Boi, nononoŋ mono nomaeŋ aniŋ sokombaa?” ");
INSERT INTO ksr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Qisiŋ mugi iŋijoro, “Gawmanoŋ takiswaa jaŋgoya jeŋ kotoŋ oŋonota eji, so ii mono mende uuguŋ mewu.” ");
INSERT INTO ksr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Manjaqeqe eja tosianoŋ kaaŋagadeeŋ qisiŋ mugi, “Nonoto? Nononoŋ nomaeŋ aniŋ sokombaa?” Qisiŋ mugi kokaeŋ iŋijoro, “Mombaanoŋ monembaajoŋ kuuŋ ubeqube ama luluuma mende ambuto, oŋoaŋgiaa tawagia meŋkejuti, iikawo mono uumotooŋ ama bonjoŋ laligowu.” ");
INSERT INTO ksr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ejemba kuuya yoŋonoŋ “Jonoŋ Hamoqeqe Toya Kraist koloowabo,” kaeŋ jeŋ uugianoŋ romoŋgogi. Kawaa kania mobombaajoŋ geja qeŋ qeŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kaeŋ aŋgi Jonoŋ ii kuuya kokaeŋ iŋijoro, “Niinoŋ apu tooŋnoŋ mulu meŋ oŋonjento, eja ku-usuŋa kotakota moŋ kawaa. Iwaa ku-usuŋa uutanoŋ mono noonoŋ uuguwaa. Iinoŋ eja uuta koloowaatiwaajoŋ niinoŋ iwaa kana esuyaa kasia ilaaŋ isamambaajoŋ amamaamaŋa. Iinoŋ mono Uŋa Toroya uugianoŋ ano gere bolaŋanoŋ koma konjoratiŋ oŋono iikaaŋa kanoŋ mulu meŋ oŋombaa. ");
INSERT INTO ksr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Iinoŋ hoŋa ano kaawoya mendeema oromambaa saraya meŋ kouma kosoŋ korereŋgoŋ gosiwaa. Gosiŋ wiit kota meŋ kululuuŋ kowianoŋ ambaato, kaawoya ano bulaaya ii mono usuno gere gagirinoŋ kemeŋ tetegoya qaa jewaa.” ");
INSERT INTO ksr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Qaa kaaŋa kaaŋa mamaga toroqeŋ jeŋ uugia kuuŋ Oligaa Buŋa ejemba tuuŋlelembe ii jeŋ asariŋ oŋoma laligoro. ");
INSERT INTO ksr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Laligoroto, gomaŋ bakayaa kiŋ poŋa Herodnoŋ dataa embia qata Herodias ii oloŋ mero ano bologa kania kania ama laligoroti, ii Jonoŋ iŋisaama asuganoŋ jeŋ muro. ");
INSERT INTO ksr_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jeŋ muro kileŋaya moŋ toroqeŋ ama Jombaanoŋ gawoŋa riijugoŋ kawali galeŋa jero Jon meŋ kapuare mirinoŋ aŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jonoŋ ejemba kuuya oomulu meŋ oŋoma Jiisas kaaŋagadeeŋ oomulu meŋ muro. Meŋ muro qama kooliro iikanondeeŋ sombinoŋ aantano. ");
INSERT INTO ksr_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Aantano Uŋa Toroyanoŋ meleema kewo kooŋ kaaŋa kolooŋ Jiisaswaa qaganoŋ kamaaro. Kaeŋ kamaaro Siwenoŋga qa aro moŋ kokaeŋ kolooro, “Giinoŋ neenaa komunjua meranaga koloona kerana qeaŋgoro giimasiiŋ moma gonjeŋ.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jonoŋ Jiisas oomulu meŋ muroti, ii gbania 30 kawaa so kolooro hamoqeqe gawoŋa kanaiŋ meŋ laligoro. Meŋ laligoro Joosefwaa meriaga kolooji, ejembanoŋ kaeŋ romoŋgogi. Jiisas maŋa Joosef, asaya qata Heli. ");
INSERT INTO ksr_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Jiisas amboya qata Matat, jariria qata Liwai. Liwai maŋa Melki, asia Janai, amboya Joosef, ");
INSERT INTO ksr_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","jariria Matatias. Matatias maŋa Aamos, asia Naahum, amboya Esli, jariria Nagai. ");
INSERT INTO ksr_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai maŋa Mat, asia Matatias, amboya Semen, jariria Joosek. Joosek maŋa Jooda, ");
INSERT INTO ksr_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","asia Joanan, amboya Reesa, jariria Zerubaabel. Zerubaabel maŋa Sealtiel, asia Neeri. ");
INSERT INTO ksr_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Amboya Melki, jariria Adi. Adi maŋa Koosam, asia Elmadam, amboya Eer, ");
INSERT INTO ksr_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","jariria Joosua. Joosua maŋa Eliezer, asia Joorim, amboya Matat, jariria Liwai. ");
INSERT INTO ksr_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liwai maŋa Simeon, asia Juuda, amboya Joosef, jariria Joonam. Joonam maŋa Eliakim, ");
INSERT INTO ksr_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","asia Melea, amboya Mena, jariria Matata. Matata maŋa Naatan, asia Deiwid, ");
INSERT INTO ksr_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","amboya Jesi, jariria Oobed. Oobed maŋa Boaz, asia Salmon, amboya Naason. ");
INSERT INTO ksr_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Jariria Aminadab. Aminadab maŋa Admin, asia Arni, amboya Hezron, jariria Perez. Perez maŋa Juuda, ");
INSERT INTO ksr_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","asia Jeikob, amboya Aisak, jariria Aabraham. Aabraham maŋa Teera, asia Naahor, ");
INSERT INTO ksr_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","amboya Seruk, jariria Reu. Reu maŋa Pelek, asia Eber, amboya Seela, ");
INSERT INTO ksr_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","jariria Kainan. Kainan maŋa Arpaksad, asia Siem, amboya Nooa, jariria Laamek. ");
INSERT INTO ksr_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Laamek maŋa Metusela, asia Eenok, amboya Jared, jariria Mahalalel. Mahalalel maŋa Keenan ");
INSERT INTO ksr_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","asia Enos, amboya Seet, jariria Aadam. Aadam ii Anutunoŋ mero kolooro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jonoŋ Jiisas oomulu meŋ muro Uŋa Toroyanoŋ uuta saa qero Jordan apunoŋga eleeno wama baloŋ qararaŋkoŋkoŋanoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kema kanoŋ laligoro Kileŋaa Toyanoŋ aŋgobato meŋ muŋ laligoro weeŋ 40 tegoro. Kambaŋ 40 kanoŋ nene moŋ mende neŋ laligoro tegoro neneyaajoŋ komuro. ");
INSERT INTO ksr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Neneyaa komuro Kileŋaa Toyanoŋ kokaeŋ ijoro, “Gii Anutuwaa meriaga koloojaŋi eeŋ, ii mono qendeema jamo koi jeŋ kotona letoma bered kolooro newa.” ");
INSERT INTO ksr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ijoro meleeno, “Qaago! Buŋa Terenoŋ qaa kokaeŋ oogita eja, ‘Nenenondeeŋ ejemba laaligo mende nonomakeja.’” ");
INSERT INTO ksr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Meleeno Satanoŋ wama baaŋa koriga moŋnoŋ uma namowaa kantria kantria kuuya ii uulaŋawo qendeema muro. ");
INSERT INTO ksr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Qendeema muŋ kokaeŋ ijoro, “Niinoŋ kantri kuuya ii galeŋ koma oŋomambaa ku-usuŋa ano esuhina iwoiyaa akadamuya ii noo boronanoŋ aaŋaga eja. Kawaajoŋ ii neenaa aiŋnaanoŋ moroga mumanjeŋ saanoŋ ii mumaŋa. Kawaajoŋ iwoi kuuya koi mono goo boroganoŋ amaŋa. ");
INSERT INTO ksr_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kawaajoŋ gii waena meŋ mepeseeŋ nombaati eeŋ, ii kuuya mono goo buŋaga koloodaborowaa.” ");
INSERT INTO ksr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kaeŋ ijoro kokaeŋ meleeno, “Qaago! Buŋa Terenoŋ qaa kokaeŋ oogita eja, ‘Gii mono Poŋ Anutugaa waeya meŋ mepeseeŋ ii motooŋgo weleŋ qeŋ muŋ laligowa.’” ");
INSERT INTO ksr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Meleeno Satanoŋ Jiisas mombo wama Jerusalem sitinoŋ kema jiwowoŋ jigowaa waareŋanoŋ eu uma kokaeŋ ijoro, “Gii Anutuwaa meria koloojaŋi eeŋ, mono kokainoŋga luguŋ emu kemeba. ");
INSERT INTO ksr_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Buŋa Terenoŋ qaa moŋ kokaeŋ oogita eja, ‘Anutunoŋ gajobauruta jeŋ kotoŋ oŋono saanoŋ galeŋ koma sopa somoŋgoŋ gombu,’ ");
INSERT INTO ksr_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ano qaa moŋ ii kokaeŋ, ‘Yoŋonoŋ borogianoŋ ama nonoŋgoliŋ goŋgi kemeŋ jamonoŋ kanaganoŋ guŋ mijimiji mende ambaa.’” Kawaajoŋ saanoŋ kemeŋ mende tiwilaaŋ gombaa. ");
INSERT INTO ksr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Kaeŋ ijoroto, Jiisasnoŋ kokaeŋ meleema muro, “Qaago! Anutunoŋ jeja, ‘Gii mono Poŋ Anutuga aŋgobato mende meŋ muba.’” ");
INSERT INTO ksr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kileŋaa Toyanoŋ aŋgobato kuuya ii Jiisas ama muro tegoro mesaoŋ keno. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jiisasnoŋ baloŋ qararaŋkoŋkoŋa mesaoro Uŋa Toroyaa ku-usuŋanoŋ iwo nano Galili prowinsnoŋ eleeno. Eleeno qaa bujuyanoŋ seiŋ gomaŋ miri liligoŋ rama keŋgiti, ii kuuya sokoma keno. ");
INSERT INTO ksr_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Sokono gomaŋa gomaŋa liligoŋ qamakooli mirigianoŋ uma Buŋa qaa kuma oŋono. Kuma oŋono mogiti, kuuya iyoŋonoŋ aisooŋ mepeseeŋ mugi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jiisasnoŋ eleema somasomarii taoŋa Nazaret kanoŋ keno. Sonda kendonoŋ karo amakejiwaa so qamakooli mirinoŋ uma Buŋa Tere weeŋgoŋ oŋomambaajoŋ waaro. ");
INSERT INTO ksr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Waaro gejatootoo eja Aisaiawaa Buju Tere mugi metuma qaa batuya kokaeŋ oogita eji, ii mokolooro: ");
INSERT INTO ksr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Pombaa Uŋa Toroyanoŋ noo uunanoŋ kemeŋ gawoŋ memewaajoŋ bedu meŋ noma ejemba kamaaŋqeqeta yoŋoojoŋ Oligaa Buŋa jeŋ asariŋkejeŋ. Iinoŋ wasiŋ nono qaa kokaeŋ jeŋ seiŋkejeŋ: Bologanoŋ gbadooŋ oŋono laligojuti, Anutunoŋ mono ii isama metogoŋ oŋono laligowu. Anutunoŋ jaagoo ejemba jaagia metooro mombo uuŋ iibuya. Kike taribari ama menduŋgoŋ meŋ kamaaŋ aŋgi laligojuti, Anutunoŋ mono ii metogoŋ oŋono siiseweweya qaa laligowuya. ");
INSERT INTO ksr_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Poŋnoŋ hamoqeqewaa gbani awaa ano kaŋ kuuwaati, niinoŋ iikawaa qeleyaga kaŋ ii jeŋ asariŋkejeŋ.” ");
INSERT INTO ksr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Qaa kaeŋ weeŋgoŋ tere pipipipiiya ii pipiiŋ galeŋa muŋ kamaaŋ raro. Raro qamakooli mirinoŋ ragiti, iyoŋonoŋ kuuya dorondoŋ ama jaasapo iigigiigi. ");
INSERT INTO ksr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Iigigiigi kanaiŋ kokaeŋ iŋijoro, “Buju Terewaa qaa koi weeŋgowe gejagianoŋ kemero mojuti, iikawaa hoŋa mono kete koi asugija.” ");
INSERT INTO ksr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kaeŋ iŋijoro kaleŋmoriaŋ qaaya qaaya buutanoŋga kamaaro kuuyanoŋ ii moma waliŋgoŋ jeŋ sororogoŋ muŋ qaa iikawaa jeŋkelekeleya ii kokaeŋ jegi, “Eja koi Joosefwaa meriaga me?” ");
INSERT INTO ksr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jegi kokaeŋ iŋijoro, “Oŋo kambaŋa kambaŋa gbaqoosoŋ qaa koi jeŋkeju, ‘Meŋqeeaŋgo eja gii mono geeŋga meŋ qeaŋgoŋ aowa.’ Oŋo gbaqoosoŋ qaa ii keteda koi nijowombaajoŋ mojuti, ii mojeŋ. Ii jeŋ kokaeŋ jewuyaga, ‘Gii Kaperneam taonoŋ kema aŋgoleto uuta mena bujuya moniŋi, iikawaa so mono geeŋgaa gomanoŋ koi kaaŋagadeeŋ mewa.’” ");
INSERT INTO ksr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kaeŋ jeŋ iŋijoro, “Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijomaŋa: Gejatootoo ejemba moŋ iyaŋaa somasomarii taonoŋ mende moma uma mubuya. ");
INSERT INTO ksr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Niinoŋ qaa hoŋaboŋa moŋ kokaeŋ iŋijomaŋa: Elaijawaa kambanoŋ Anutunoŋ Siwe naguya kono gbani karooŋ ano koiŋ 6 kawaa uutanoŋ koŋ mende kiro bodi somata kolooro namo kuuya sokono. Kambaŋ kanoŋ emba malo mamaga Israel uutanoŋ laligogi. ");
INSERT INTO ksr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Mamaga laligogito, Anutunoŋ Elaija yoŋoonoŋga mombaanoŋ kembaatiwaajoŋ mende wasiroto, waba baloŋ Saidombaa gomaŋ qata Sarefat iikanoŋ emba malo motooŋgoya iwaanoŋ wasiro keno. ");
INSERT INTO ksr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Gejatootoo eja Elisawaa kambanoŋ manimbanoŋ Israel eja mamaga turuŋ oŋono laligogito, iyoŋoonoŋga moŋnoŋ moŋ mende solaŋaniro. Qaagoto, waba baloŋ Siriaga eja qata Naeman ii motooŋgonoŋ mono Elisawaa qaaya moma laariŋ solaŋaniŋ qeaŋgoro.” ");
INSERT INTO ksr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jiisasnoŋ kaeŋ iŋijoro qamakooli mirinoŋ ragiti, iyoŋonoŋ kuuya qaa ii moma iriŋgia soono uuduuduu kolooŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Uuduuduu kolooŋ oŋono waama Jiisas konjoma otaagi taoŋ seleeŋgeŋ keno. Taoŋgia ii baaŋaa sia kosianoŋ megi nanoti, mono iikanoŋ hagogi kemebaatiwaajoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Keŋgito, batugianoŋ qendeema oŋomesaoŋ keno. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jiisasnoŋ Galili prowins uutanoŋ Kaperneam taonoŋ kamaaŋ keuma Sabat kendonoŋ ejemba tuuŋ kuma oŋono. ");
INSERT INTO ksr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kuma oŋono qaayanoŋ ku-usuŋawo kolooro jero. Kawaajoŋ kanageso yoŋonoŋ ii iima aaruŋ waliŋgogi. ");
INSERT INTO ksr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Qamakooli miri iikanoŋ eja moŋ omeyawo raro. Raro omeyanoŋ tereŋgoŋ silama qa kokaeŋ qaro, ");
INSERT INTO ksr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ae! Jiisas, Nazaret eja! Gii nomaeŋ ama nonomambaajoŋ anjaŋe? Mono tiwilaaŋ nonomambaajoŋ kajaŋ me? Nii kaniaga moma kotojeŋ. Gii Anutuwaanoŋ eja Tak-kootoya koloojaŋ.” ");
INSERT INTO ksr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kaeŋ qaro Jiisasnoŋ temboma kokaeŋ jeŋ muro, “Gii mono qaaga bogoro eja koi mesaoŋ togowa.” Kaeŋ jeŋ muro omenoŋ eja ii meŋ giliro tama batugianoŋ namonoŋ kemero qeŋ mizimizi mende totooŋ kolooŋ kouma mesaoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Keno kuuyanoŋ newogia tegoro waliŋgoŋ batugianoŋ amiŋ moma kokaeŋ jegi, “Yei! Qaa koi naa qaaga? Iinoŋ mono esuŋmumu qaganoŋ ome jeŋ kotoŋ oŋono teŋ koma kouma kenju.” ");
INSERT INTO ksr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kaeŋ kolooro Jiisaswaa qabuŋayanoŋ seiŋ gomaŋ kuuya kosere rama keŋgiti, iikanoŋ kema sokono. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jiisasnoŋ waama Kaperneam qamakooli miri ii mesaoŋ Saimon Piitowaa mirinoŋ uro. Uro Saimombaa seuŋanoŋ selegere ji uuta kiro ero. Ero iwaajoŋ ama Jiisas qama kooliŋ mugi. ");
INSERT INTO ksr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Qama kooliŋ mugi kema usugoŋ kemeŋ selegere jeŋ kotoŋ muro mesaoro iikanondeeŋ waama nene ooŋ uŋuagiro. ");
INSERT INTO ksr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Weeŋ jaaya tegoŋ kemero kanoŋ ejemba daeŋ yoŋonoŋ alaurugia ji kania kania kanoŋ iŋiro egiti, ii kuuya uŋuama Jiisaswaanoŋ kagi. Kagi boria kuuya yoŋoo qagianoŋ aŋa aŋa ano qeaŋgodaborogi. ");
INSERT INTO ksr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ome yoŋonoŋ kaaŋagadeeŋ ejemba mamaga yoŋoo uugianoŋga kouma silama kokaeŋ qagi, “Gii Anutuwaa meria koloojaŋ.” Jiisasnoŋ Hamoqeqe Toya Kraist kolooji, iyoŋonoŋ ii mogitiwaajoŋ Jiisasnoŋ jeŋ oŋoma buugia muuŋguŋ oŋotaaro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Jiisasnoŋ gaoŋ ero gomaŋ weŋgeraŋ suluro waama iyaŋa tiriŋ kotoŋ kemeŋ goria moŋnoŋ keno. Kenoto, ejemba yoŋonoŋ iwaaŋ muŋ kema mokolooŋ mende oŋomesaoŋ kembaatiwaajoŋ batogoŋ aŋgoŋ koma mugi. ");
INSERT INTO ksr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Aŋgoŋ koma mugito, kokaeŋ iŋijoro, “Niinoŋ Anutu bentotoŋaa Oligaa Buŋa ii taoŋ tosia yoŋoojoŋ kaaŋagadeeŋ jeŋ asariŋ oŋombe sokombaa. Anutunoŋ mono iikawaajoŋ wasiŋ nono.” ");
INSERT INTO ksr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kaeŋ jeŋ kema Galili prowins liligoŋ qamakooli mirigianoŋ Buŋa qaanoŋ uu kuuŋ oŋoma laligoro. Kaeŋ. ");
INSERT INTO ksr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kambaŋ moŋnoŋ Jiisasnoŋ Genesaret apu aŋgoŋ goraayanoŋ nano ejembanoŋ kaŋ tuuŋ tuuŋ koma Anutuwaa Buŋa qaa mobombaajoŋ oloqologoŋ liligoŋ mugi. ");
INSERT INTO ksr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Liligoŋ mugi nama waŋgo woi kowe goraayanoŋ rari iriiro. Sora hooro yoŋonoŋ waŋgo ii mesaoŋ kemeŋ misagia qeesaaŋ soŋgbaŋgi. ");
INSERT INTO ksr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Waŋgo moŋ ii Saimombaanoŋa. Jiisasnoŋ iikanoŋ uma toya kokaeŋ qisiŋ muro, “Giinoŋ mono naŋgona boroŋa moŋ nuama apunoŋ baageŋ kemba.” Qisiŋ muro naŋgoro keno waŋgonoŋ rama ejemba tuuŋlelembe kuma oŋono. ");
INSERT INTO ksr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kuma oŋono tegoro Saimon ijoro, “Giinoŋ mono waŋgo koi naŋgona apu aŋgoŋ biiwianoŋ keno alauruga yoŋowo misagia sorawaajoŋ giligi kemeba.” ");
INSERT INTO ksr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ijoro Saimonoŋ meleeno, “Somatana, nono gomantiiŋa koriga misa giliŋ bimbimgoŋ hoŋa moŋ mende mejoŋa. Qaagoto, giinoŋ jeŋ kotojaŋiwaajoŋ mono kileŋ kema giliniŋ kemebaa.” ");
INSERT INTO ksr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kaeŋ meleeno jerotiwaa so aŋgi sora ambembo misagianoŋ kemegi misanoŋ boratiwombaa aŋgi. ");
INSERT INTO ksr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kaeŋ aŋgi alaurugia waŋgo moŋnoŋ laligogiti, iyoŋoojoŋ kaŋ ilaaŋ oŋombutiwaa boro kaka koŋgi kagi. Kagi waŋgo woi ii soranoŋ saa qegi nemotoŋ tagori. ");
INSERT INTO ksr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Sora honombonoŋa mende meŋ iima iikawaajoŋ kuuyanoŋ waliŋgogi. Waliŋgoŋ Saimon Piitonoŋ ii iima Jiisaswaa batanoŋ kemeŋ simiŋ kuma ijoro, “Oo Poŋ, nii siŋgisoŋgo ejaga koloojeŋi-waajoŋ mono nomesaoŋ kemba.” ");
INSERT INTO ksr_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimombaa alawoita Jeims ano Jon Zebediwaa merawoita yoronoŋ kaaŋagadeeŋ newogara tegoro waliŋgori. Saimonoŋ qaa ii ijoroto, Jiisasnoŋ kokaeŋ meleeno, “Mono keega mende moba. Gii kokawaa gematanoŋ ejemba ii sora kaaŋa horoŋ oŋona giwo toroqegi laligowuya.” ");
INSERT INTO ksr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kaeŋ ijoro waŋgogia horoŋ kouma sakasinoŋ ama ilawoilagia kuuya mesaoŋ Jiisaswaa gematanoŋ otaaŋ keŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jiisasnoŋ taoŋ moŋnoŋ laligoro kanoŋ eja moŋ selia manimbanoŋ meŋ bolidabororo raro. Rama Jiisas iima kosianoŋ simiŋ kuma kemeŋ kokaeŋ qama kooliŋ muro, “Oo Poŋ, giinoŋ siiŋganoŋ meŋ qeaŋgoŋ nomambaajoŋ mojaŋi eeŋ, mono nii saanoŋ meŋ solaŋaniŋ nomba.” ");
INSERT INTO ksr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kaeŋ jero boria boraama selia oosiriŋ ijoro, “Niinoŋ ii amambaajoŋ mojeŋ. Gii mono solaŋaniwa.” Kaeŋ jero manimbaya ii iikanondeeŋ solaŋaniro. ");
INSERT INTO ksr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Solaŋaniro kokaeŋ jeŋ kotoŋ muro, “Moba, kokawaa buju qaaya ii moŋ mende jena mobu. Qaagoto, gii mono jigo gawoŋ galembaanoŋ kema selega qendeema muŋ Mooseswaanoŋ jeŋkootoya otaaŋ solaŋanijaŋiwaa daŋgiseŋ nanduŋa ama siimoloŋ oowa. Ii oona iiro ejembanoŋ kaniaga moma kotowu.” ");
INSERT INTO ksr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kaeŋ ijoroto, ii kileŋ Jiisaswaa qabuŋaya jeŋ seiro gomaŋ so asariŋ keno. Kenotiwaa so ejemba tuuŋa tuuŋa yoŋonoŋ qaaya mobombaajoŋ ano jigia meŋ qeaŋgowaatiwaajoŋ iwaanoŋ kaŋ ajoroogi. ");
INSERT INTO ksr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kagito, Jiisasnoŋ oŋomesaoŋ baloŋ qararaŋkoŋ-koŋanoŋ kema laligoŋ qama kooliro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jiisasnoŋ weeŋ moŋnoŋ Buŋa qaa kuma oŋono Farisii (Kana qaawaa kaparaŋkoŋkoŋ) ano Kana qaawaa boi tosianoŋ Galili ano Judia prowinswaa gomaŋa gomaŋa ano Jerusalemga kaŋ ejemba tuuŋlelembe batugianoŋ ragi. Pombaa ku-usuŋanoŋ Jiisas nemuŋ koma muro ejemba jigia mero qeaŋgogi. ");
INSERT INTO ksr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kambaŋ kanoŋ eja tosianoŋ alagia sele batuya koomuya ii demberunoŋ ama aŋgoŋ kagi. Kaŋ kotoŋ Jiisaswaa kosianoŋ miri uutanoŋ uma ambombaajoŋ batogogi. ");
INSERT INTO ksr_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Batogogito, ejemba tuuŋlelembenoŋ ologoŋ naŋgitiwaajoŋ kuuŋ papaŋgoŋ miri uutanoŋ ubombaa kana moŋ mende mokolooŋ meŋ miri qaganoŋ ugi. Uma waareŋ jamonoŋ memeta ii osoŋ luluuŋgi oota kolooro ji eja demberuyawo kasanoŋ somoŋgoŋ iikanoŋ aŋgi ejemba batugianoŋ Jiisaswaa batanoŋ kemero. ");
INSERT INTO ksr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kaaŋ kemero Anutu moma laariŋ mugiti, Jiisasnoŋ iyoŋoo tanigia ii iiro sokono ji eja kokaeŋ ijoro, “Alana, niinoŋ siŋgisoŋgoga mesaojeŋ.” ");
INSERT INTO ksr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kaeŋ ijoro Kana qaawaa boi ano Farisii yoŋonoŋ ii moma kanaiŋ kokaeŋ jeŋ romoŋgogi, “Eja koi moroga? Iinoŋ mono Anutu mepaegoŋ mepaqepae anja. Anutu motooŋgonoŋ siŋgisoŋgonana mesaoŋkejato, eja moŋnoŋ ii qaago.” ");
INSERT INTO ksr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kaeŋ romoŋgogito, Jiisasnoŋ uugia iima kotoŋ kokaeŋ iŋijoro, “Tosaaŋa oŋo uugianoŋ naambaajoŋ qaa jejeŋi, iikawaajoŋ mamaga romoŋgoju? Ii mende sokonja. ");
INSERT INTO ksr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‘Niinoŋ siŋgisoŋgoga mesaojeŋ,’ jejeŋi, qaa iikanoŋ mono afaaŋagadeeŋ jejetaga. Moŋnoŋ kaeŋ jero tosianoŋ qaa iikawaa hoŋa mende iibu. Kawaajoŋ ii qaa afaaŋaa so. Niinoŋ qaa moŋ kokaeŋ jemambaajoŋ mojeŋ, ‘Mono waama kemba.’ Qaa ii mono lombotawo jejetaga kolooja. Kaeŋ jewe hoŋa koloowaa me qaagoti, iikanoŋ mono asuganoŋ asugiro iibu. ");
INSERT INTO ksr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mobu, balonoŋ siŋgisoŋgo mesamesaowaa ku-usuŋa ii Siwe gomambaa Eja hoŋaanoŋ eji, oŋo iikawaa kaniaajoŋ tiŋtuaŋ laligowubo. Kawaajoŋ qaa lombotawo ii eja koi ijowe hoŋa iibu.” Kaeŋ jeŋ eja sele batuya koomuya ii ijoro, “Niinoŋ gijojeŋ: Gii mono waama tambomaeega meŋ miriganoŋ kemba. Qaa biŋawo ii hoŋawo koloowaati eeŋ, qaa afaaŋa ii mono kaaŋagadeeŋ nomaembaajoŋ omaya koloonaga?” ");
INSERT INTO ksr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kaeŋ ijoro iikanondeeŋ jaagianoŋ waama tambomaeeya eroti, ii meŋ Anutu mepeseeŋ mesaoŋ mirianoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kaeŋ kolooro ejemba kuuyanoŋ waliŋgoŋ sombugia moma Anutu mepeseeŋ jegi, “Yei! Kete iwoi awaa soroga iijoŋ.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kawaa gematanoŋ Jiisasnoŋ Kaperneam mesaoŋ kema takis ofis uugumambaajoŋ ano kanoŋ takis meme eja qata Liwai raro iima ijoro, “Gii mono noo gemananoŋ kawa.” ");
INSERT INTO ksr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kaeŋ ijoro gawoŋa kuuya mesaoŋ waama Jiisaswaa gematanoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kema Jiisas mirianoŋ koma horoŋ iwaajoŋ jejelombaŋ somata mozozoŋgoro. Mozozoŋgoŋ takis meme tiliqiligiawo ano alauruta tosaaŋa horoŋ oŋono tuuŋ somatanoŋ yoŋowo rama nembanene negi. ");
INSERT INTO ksr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kaeŋ negi Farisii (Kana qaawaa kaparaŋkoŋkoŋ) ano yoŋoonoŋ boi yoŋonoŋ ii iima ŋindiŋ-ŋunduru jeŋ Jiisaswaa gowokouruta kokaeŋ jeŋ oŋoŋgi, “Ae! Oŋo mono naambaajoŋ takis meme tiliqiligiawo ano siŋgisoŋgo ejemba yoŋowo rama nene apu neju? Ii mende sokonja.” ");
INSERT INTO ksr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Kaeŋ jeŋ oŋoŋgi Jiisasnoŋ kitia kokaeŋ iŋijoro, “Ejemba jigia qaa yoŋonoŋ doktawaa siiŋ mende amakejuto, ji ejembanoŋ mono doktawaanoŋ kemakeju. ");
INSERT INTO ksr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Niinoŋ siŋgisoŋgo ejemba uugia meleembuti oŋoomambaajoŋ kaŋ laligojento, ejemba iyaŋgiaajoŋ mogi solaŋa koloojuti, ii qaago.” ");
INSERT INTO ksr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ejemba tosianoŋ Jiisaswaanoŋ kaŋ qisigi, “Jon Oomulu ejawaa gowokouruta nononoŋ kambaŋ mamaga Anutuwaajoŋ nene siŋgi laligoŋ qamakooli ajoajoroo koriga amakejoŋ. Farisii (Kana qaawaa kaparaŋkoŋkoŋ) yoŋoo gowokourugianoŋ kaaŋiadeeŋ ama laligojuto, geeŋgaa gowokouruganoŋ mono pondaŋ nene apu neŋkeju.” ");
INSERT INTO ksr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Kaeŋ qisigi kokaeŋ meleeno, “Oŋanoŋ! Nono naa kambanoŋ nene siŋgi laligoŋkejoŋ? Emba meme kambaŋanoŋ ejawaa gemakootaŋurutanoŋ gereya aŋgi embawaa sakitiurutanoŋ iwoi ii togoŋkeju me qaago? Niinoŋ neenaa gowokouruna yoŋoo eja buŋa kolooŋ yoŋoo batugianoŋ ainjoloŋ ramakejeŋ. Rabe nene siŋgi laligowombaajoŋ jegi yoŋonoŋ ainjoloŋ aisooŋ rama siŋgi laligowombaajoŋ amamaaŋkeju. ");
INSERT INTO ksr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Amamaaŋkejuto, Anutunoŋ laaligona nuano komuwe yoŋonoŋ mono kambaŋ iikanoŋ saanoŋ nene siŋgi laligoŋkebuya. ");
INSERT INTO ksr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","“Oŋo laaligo walaga ano korisoro Buŋa gbilia ii mindiriŋ orombombaajoŋ amamaawuya. Iikawaa sareqaa gemata moŋ ii kokaeŋ iŋijomaŋa: Moumou walaga jurano moŋnoŋ moumou gbilia motoŋ opo jakaŋa kanoŋ mende ama uumbinaaŋkeja. Kaaŋ anagati eeŋ, opo jakaŋa gbilianoŋ mono walagawo ororoŋ mende kolooŋ ii horoŋ menjurano boliqoliwabo. ");
INSERT INTO ksr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Kaaŋiadeeŋ moŋnoŋ wain apu gbilia ii bokoŋ me taru walaga lama selianoŋ memeta iikanoŋ mende kosoŋ maaro kemeŋkeja. Kaeŋ anagati eeŋ, wain apu gbilianoŋ mono somariiŋ taru qenjumenjurama molaaro namonoŋ kamaaro taruyanoŋ kileqileewubo. ");
INSERT INTO ksr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","“Kawaajoŋ wain apu gbilia ii taru gbilianondeeŋ molaaniŋ kemero sokombaa. (Kaaŋiadeeŋ moŋnoŋ apu awaa ii konoŋ qamoganoŋ mende kosoŋkejoŋ. Kaeŋ kosowonagati eeŋ, iikanoŋ mono juma siisororo kamaaro neŋ ji niniwabo. Kaeŋ koloowaboti-waajoŋ apu awaa ii konoŋ awaanoŋ kosoŋkejoŋ. Oŋo kaaŋagadeeŋ laaligo walaga ano Oligaa Buŋa gbilia ii mindiriŋ orombombaajoŋ amamaawuya.) ");
INSERT INTO ksr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Moŋnoŋ wain apu walaga mepeseeŋ neŋ laligoŋkeji, iinoŋ wain apu gbilia nemambaajoŋ siiŋa mende moma mojotiitii amakeja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kawaa gematanoŋ Sabat kendoŋ moŋnoŋ Jiisasnoŋ wiit dumuŋ gawoŋ koria somata kotoŋ keno. Keno gowokouru-tanoŋ wosogia iŋiro wiit hoŋa motomotooŋ borogianoŋ kuma osasaaŋ negi. ");
INSERT INTO ksr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kaeŋ negitiwaajoŋ Farisii (Kana qaawaa kaparaŋ-koŋkoŋ) tosianoŋ ii iima kokaeŋ iŋijogi, “Oŋo mono naambaajoŋ Sabat kendombaa gawoŋ meme soŋgoya uuguju?” ");
INSERT INTO ksr_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Kaeŋ iŋijogito, Jiisasnoŋ kokaeŋ meleeno, “Kiŋ Deiwidnoŋ manjaqeqe ejauruta yoŋowo liligoŋ wosogia iŋiro iwoi aŋgiti, ii weeŋgogi me qaago? ");
INSERT INTO ksr_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Iinoŋ Anutuwaa opo sel jigonoŋ uma bered kowoga Anutuwaa jaasewaŋanoŋ alatanoŋ aŋgi raro esuŋanoŋ tururo qetegogiti, ii mero negi. Bered kowoga mesamesaoya ii jigo gawoŋ galeŋ yoŋonondeeŋ neŋ laligogi. Iinoŋ ano iwaa kerasuru-urutanoŋ ii newubotiwaajoŋ soŋgo eroto, ii kileŋ negi.” ");
INSERT INTO ksr_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kaeŋ jeŋ kokaeŋ iŋijoro, “Siwe gomambaa Eja hoŋanoŋ mono Sabat kendombaa Poŋa kolooja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Jiisasnoŋ Sabat kendoŋ moŋnoŋ qamakooli mirinoŋ uma Buŋa qaa kuma oŋono. Iikanoŋ eja moŋ boria dindiŋa sooliro raro. ");
INSERT INTO ksr_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kana qaawaa boi ano Farisii (Kana qaawaa kaparaŋkoŋkoŋ) yoŋonoŋ Jiisas iima qaa jakeyanoŋ ama mubombaa kania moŋgama “Eja ii Sabat kendonoŋ meagowaa me qaago?” kaeŋ jeŋ jaa galeŋ meŋ ragi. ");
INSERT INTO ksr_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ragito, Jiisasnoŋ roromoŋgogia ii moma kotoŋ eja boria soosoolia ii kokaeŋ ijoro, “Mono waama jaanananoŋ namba.” Kaeŋ ijoro waama nano. ");
INSERT INTO ksr_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nano Jiisasnoŋ kaeŋ jero, “Kana qaa otaaŋ Sabat kendonoŋ iwoi awaa me bologa amboŋa? Saanoŋ mombaa waŋa somoŋ-gowoŋa me mesaoniŋ tiwilaawaa. Nomaeŋ aniŋ sokombaa? Ii qisiŋ oŋombe jewu.” ");
INSERT INTO ksr_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Kaeŋ jeŋ eleqeleema korebore iŋiidaboroŋ eja ii ijoro, “Gii mono boroga qetetereewa.” Kaeŋ ijoro boria qetetereero mombo awaa kolooro. ");
INSERT INTO ksr_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Awaa kolooroto, galeŋ yoŋonoŋ iriŋgia mamaga soono “Jiisas nomaeŋ ama muboŋa?” jeŋ iyaŋgia amiŋ mogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kambaŋ kanoŋ Jiisasnoŋ baaŋanoŋ qama koolimambaajoŋ uma gomantiiŋa koriga ii Anutu qama kooliŋ muŋ laligoro gomaŋ ano. ");
INSERT INTO ksr_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Gomaŋ ano gowokouruta oŋooma yoŋoonoŋga 12 meweeŋgoŋ oŋoma wasiwasi eja aposol qa ii oŋono. ");
INSERT INTO ksr_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Qagia ii kokaeŋ qaro: Saimon, Jiisasnoŋ qata Piito muro, iwaa koga Andruu ano Jeims, Jon, Filip, Bartolomyuu, ");
INSERT INTO ksr_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyuu, Tomas, Jeims Alfiuswaa meria ano Saimon qata moŋ Tompe eja qagi. ");
INSERT INTO ksr_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Juudas Jeimswaa meria ano Juudas Iskariot. Kariot eja kanoŋ kanageŋ memelolo ejaga kolooro. ");
INSERT INTO ksr_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jiisasnoŋ aposoluruta yoŋowo baaŋanoŋga kamaaŋ baloŋ korianoŋ kema naŋgi. Naŋgi gowoko tuuŋ somata ano ejemba tuuŋlelembe yoŋonoŋ iwaajoŋ ajorooŋ mamboŋgi. Yoŋonoŋ “Buŋaya jero moniŋ jinana meŋ qeaŋgowaa,” jeŋ iikawaajoŋ Judia prowins kuuya, Jerusalem siti ano kowe goraayanoŋga Taia ano Saidon taoŋ iikanoŋa kaŋ ajoroogi. ");
INSERT INTO ksr_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Omejiilanoŋ kokojinjiŋ meŋ oŋonoti, iyoŋonoŋ kaaŋagadeeŋ kaŋ qeaŋgogi. ");
INSERT INTO ksr_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ku-usuŋanoŋ iwaanoŋga kotoŋ yoŋoonoŋ uro kuuya meŋ qeaŋgoŋ oŋono. Kawaajoŋ ejemba kuuyanoŋ Jiisas oosiriwombaajoŋ janjariŋ riigi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jiisasnoŋ gowokouruta otaama iŋiima kokaeŋ iŋijoro, “Anutuwaa bentotoŋ ii wanaya oŋoo buŋaga. Kawaajoŋ wanaya oŋo mono simbawoŋawo kolooju. ");
INSERT INTO ksr_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kambaŋ kokaamba nenewaa kaaŋa komuŋ qenjeŋ qeŋ laligojuti, Anutunoŋ mono siiŋgia ii uŋuagiwaa. Kawaajoŋ oŋo mono simbawoŋawo kolooju. Kambaŋ kokaamba saajuti, oŋonoŋ mono korisoro ama jomo jomowu. Kawaajoŋ wosobiri laligojuti, oŋo mono simbawoŋawo kolooju. ");
INSERT INTO ksr_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Ejembanoŋ oŋo Siwe gomambaa Eja hoŋaajoŋ ama kazi ama yakariŋ selianoŋ kuuŋ uuqeqe qaa tokoroŋkota jeŋ oŋoma kasu seibolo kaaŋa qagia kotoŋ kondeembuti, oŋo mono simbawoŋawo kolooju. ");
INSERT INTO ksr_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ambosakoŋurugianoŋ iikawaa so gejatootoo ejemba yoŋoojoŋ ama oŋoma laligogi. Mobu! Anutunoŋ tawagia uuta Siwe gomanoŋ anota eja. Kawaajoŋ kaeŋ ama oŋoŋgi kambaŋ iikanoŋ mono aisooŋ otokoriaŋ maabu. ");
INSERT INTO ksr_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Oŋo simbawoŋawo laligojuto, qabuŋa esuhinagiawo oŋo laaligo siiseweweya qaa laligojuti, ii mono tegowaa. Kawaajoŋ niinoŋ oŋoojoŋ qama wanjinjiŋgoŋ ‘Oo yei!’ jejeŋ. ");
INSERT INTO ksr_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kambaŋ kokaamba neŋ timbiriŋ ama laligojuti, oŋo mono wosogia iŋiro bodi laligowuya. Kawaajoŋ niinoŋ oŋoojoŋ qama wanjinjiŋgoŋ ‘Oo yei!’ jejeŋ. Kambaŋ kokaamba korisoro ama jomo jomojuti, oŋo mono amburereŋ meŋ saabuya. Kawaajoŋ niinoŋ oŋoojoŋ qama wanjinjiŋgoŋ ‘Oo yei!’ jejeŋ. ");
INSERT INTO ksr_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Ambosakoŋurugianoŋ gejatootoo ejemba takapolakaya jeŋ mepeseeŋ oŋoma laligogi. Ejemba kuuya iikawaa so ama oŋoŋgi niinoŋ oŋoojoŋ qama wanjinjiŋgoŋ ‘Oo yei!’ jejeŋ.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Bologa ama oŋombuyato, oŋo qaana moma laligojuti, niinoŋ oŋoojoŋ kokaeŋ iŋijowe mobu: Mono kereurugia uugianoŋ jopagoŋ oŋoma laligowu. Daeŋ yoŋonoŋ kazi ama oŋonjuti, ii mono awaagadeeŋ ama oŋoma laligowu. ");
INSERT INTO ksr_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","“Daeŋ yoŋonoŋ qasuaaŋ jiriŋgoŋ oŋonjuti, ii mono kobibiiŋ kotuegoŋ oŋombu. Horoŋ ureeŋ ama oŋonjuti, iyoŋoojoŋ mono Anutuwaa qama kooliwu. ");
INSERT INTO ksr_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Moŋnoŋ uruŋga lee qetaaliro leegeŋ kaaŋagadeeŋ meleema muba. Moŋnoŋ malekuga qaga guama opoga duta kaaŋgadeeŋ memambaajoŋ moro giinoŋ mono ii mende aŋgoŋ komba. ");
INSERT INTO ksr_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","“Iwoiwaa welema goŋgi ii mono kuuya oŋomba. Moŋnoŋ goo hina iwoiga mero ii mono meleema gombaatiwaajoŋ mende kaparaŋ koma qisiwa. ");
INSERT INTO ksr_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ejembanoŋ oŋo iwoi ama oŋombutiwaa momakejuti, iikawaa so mono yoŋoojoŋ kaaŋagadeeŋ ama oŋomakebu. ");
INSERT INTO ksr_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Namowaa siŋgisoŋgo ejembanoŋ alaurugianoŋ jopagoŋ oŋoŋgi kitia meleema jopagoŋ oŋoma mepeseeŋ aoŋkeju. Oŋo iikawaa so balombaa tania otaaŋkejuti eeŋ, Anutuwaanoŋ tosa mende kolooro mono nomaeŋ oŋo mepeseeŋ oŋonaga? Alaurugia ano kereurugia ii mono motooŋ jopagoŋ oŋoŋgi tawa oŋono oyaŋboyaŋ koloowuya. ");
INSERT INTO ksr_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","“Namowaa siŋgisoŋgo ejembanoŋ alaurugianoŋ iwoi awaa ama oŋoŋgi kitia meleema oŋoma ala meŋ aoŋ mepeseeŋ aoŋkeju. Oŋo iikawaa so ama balombaa tania otaaŋkejuti eeŋ, Anutuwaanoŋ tosa mende kolooro oŋo mende mepeseeŋ oŋombaa. ");
INSERT INTO ksr_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","“Namowaa siŋgisoŋgo ejembanoŋ moneŋ iwoi ii siŋgisoŋgo ejemba tosaaŋa yoŋoojoŋ oŋoma kitia iikayadeeŋ meleema oŋombutiwaajoŋ kaparaŋ komakeju. Ii balombaa nanamemeŋa. Oŋo tosianoŋ tosagia meleema oŋombutiwaa mamboŋgi Anutunoŋ mono nomaeŋ mepeseeŋ oŋonaga? Tosianoŋ tosagia mende meleema oŋoŋgi Anutunoŋ mono kitia ii meleema tawa oŋombaa. ");
INSERT INTO ksr_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Oŋo mono Siwe Toyaa nanamemeŋa ama meŋ laligowu. Baloŋ ejembanoŋ bologa ama daŋgiseŋ mende jeŋkejuto, Anutunoŋ kileŋ ii awaa ama oŋomakeja. Kawaajoŋ oŋo mono kereurugia uugianoŋ jopagoŋ awaagadeeŋ ama oŋoma moneŋ iwoi oŋoma iikawaa kitia moŋ meleema oŋombutiwaajoŋ mende moma mambombu. Kaeŋ ama laligogi tawagianoŋ seiŋ uuta kolooro Anutu uutaa meraboraaŋa kolooŋ laligowuya. ");
INSERT INTO ksr_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","“Siwe Maŋgianoŋ korebore kiaŋkomuŋ oŋomambaajoŋ moji, oŋo mono iikawaa so ejemba kuuya kiaŋkomuŋ oŋoma laligowu.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ejemba tosia yoŋoo qaagia ii mende gosiŋ jeŋ tegowu. Ii mende jeŋ tegoŋ oŋoŋgi Anutunoŋ mono oŋoaŋgia kaaŋagadeeŋ mende jeŋ tegoŋ oŋombaa. Oŋo tosia yoŋoo siŋgisoŋgogiaa iroŋa ii mende meleema oŋombu. Ii mende meleema oŋoŋgi Anutunoŋ mono oŋoaŋgiaa siŋgisoŋgogiaa iroŋa ii kaaŋagadeeŋ mende meleema oŋombaa. Oŋo mono tosia yoŋoo siŋgisoŋgogia mesaowu. Ii mesaogi Anutunoŋ oŋoaŋgiaa siŋgisoŋgogia kaaŋagadeeŋ soŋgbama mesaowaa. ");
INSERT INTO ksr_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","“Oŋo ejemba tosia yoŋoo iwoi ama oŋoŋgi Anutunoŋ mono iikawaa so gosiŋ iwoi ii meleema oŋo kaaŋiadeeŋ ama oŋombaa. Kawaajoŋ oŋo mono iwoi kaleŋ oŋomakebu. Kaeŋ oŋoŋgi Anutunoŋ mono kaaŋiadeeŋ kaleŋ oŋomakebaa. Oŋanoŋ, Anutunoŋ ii kalembone mende moma ilaaŋ oŋomakebaa. Anutunoŋ gosiŋ oŋo iwoi oŋoŋgiti, iikawaa soya kuuya meŋ qambinoŋ maaro qaa ootanoŋ kouro utugoro ororoŋ kolooro menduŋgoro kemero toroqeŋ qaganoŋ maaro soya uuguŋ qeqelalaŋ kamaaro ii mono gesogianoŋ mouma oŋombaa.” Anutuwaa kania ii kaaŋia. ");
INSERT INTO ksr_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jiisasnoŋ sareqaa moŋ kokaeŋ iŋijoro, “Jaagoo ejemba moŋnoŋ jaagoo alia moŋ saanoŋ borianoŋ meŋ wambaa me qaago? Kaeŋ kembaoraga mono motooŋ roŋnoŋ kemeŋ urunaga. ");
INSERT INTO ksr_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Gowokonoŋ boiya mende uuguja. Boigianoŋ momo kuuya tororo kuma oŋono moma komuwuti, kuuya iyoŋonoŋ mono boigia kaaŋa koloowuya. ");
INSERT INTO ksr_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Gii naambaajoŋ alagaa jaayanoŋ godomaruru melaada iijanto, geeŋgaa jaaganoŋ gere tapia somata eji, ii nomaeŋ mende iima kotojaŋ? ");
INSERT INTO ksr_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Geeŋgaa jaaganoŋ gere tapia somata eji, ii mende iima kotoŋ nomaembaajoŋ alagaajoŋ kokaeŋ jenaga, ‘Alana moba! Jaaganoŋ eugeŋ godomaruru kemeŋ raji, ii saanoŋ itagowe kamaawaa.’ Oo uumeleembaa selesele eja, gii mono wala geeŋgaa jaaganoŋga gere tapia somata ii meŋ giliwa. Ii meŋ giliŋgo tororo iima kotoŋ alagaa jaayanoŋ godomaruru kemeŋ raji, ii saanoŋ itagona kamaawaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Gere awaa moŋnoŋ hoŋa bologa mende kuuŋkeja. Kaaŋiadeeŋ gere bologa moŋnoŋ hoŋa awaa mende kuuŋkeja. ");
INSERT INTO ksr_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Jao kota ii kasuneselanoŋ kolooro mewombaajoŋ amamaaŋkejoŋ ano muli hoŋa ii kowororonoŋ kolooro qetegowombaajoŋ amamaaŋkejoŋ. Iikawaa so gerewaa hoŋa iima gosiŋ mono kania moma kotowu. ");
INSERT INTO ksr_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","“Eja uutanoŋ iwoi saa qero eji, ii mono buutanoŋ asuganoŋ jeŋkeja. Kawaajoŋ eja awaawaa uu kowianoŋ iwoi awaawaa moriaŋa eji, iinoŋ mono awaa ii asuganondeeŋ jeŋkeja. Eja bologaa uu kowianoŋ iwoi bologa eji, iinoŋ mono bologa ii asuganoŋ jeŋkeja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Oŋo noojoŋ ‘Poŋ Poŋ!’ qa ii mono naambaajoŋ qamakejuto, niinoŋ iwoi mewutiwaajoŋ jeŋkejeŋi, ii mende teŋ koma meŋkeju. ");
INSERT INTO ksr_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","“Daeŋ yoŋonoŋ noonoŋ kaŋ qaana moma teŋ koma mejuti, niinoŋ iyoŋoo kaniagia qendeema sareqaanoŋ jemaŋa. ");
INSERT INTO ksr_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Iinoŋ motoŋqeqe eja kokawaa so kolooja: Eja iikanoŋ miri memanjeŋ roŋ koriga osoŋ kemeŋ tandoya jamo kowonjiŋ (simeŋ) qaganoŋ kuuŋ meŋ kotiiro nano. Kaeŋ nano koŋuru kambanoŋ apu gboulu somata qeŋ miri batuyanoŋ kuuroto, awaagadeeŋ meŋ mejugoro nanotiwaajoŋ kumambaajoŋ qeŋ bimbimgoro kotiiŋ nano. ");
INSERT INTO ksr_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Qeŋ bimbimgoroto, moŋnoŋ qaana moma mende teŋ koma meji, iinoŋ mono motoŋqeqe eja kokawaa so kolooja: Iinoŋ miri memanjeŋ tandoya mende osoŋ komoma namo qaganoŋ teku manjagadeeŋ ama mero. Mero nano koŋuru kambanoŋ apu gboulu somata qeŋ miri batuyanoŋ kuuro miri ii iikanondeeŋ kuno ororoŋgoŋ kamaaro.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jiisasnoŋ ejemba tuuŋlelembe batugianoŋ laligoŋ Buŋa qaaya kuuya ii iŋijoŋ oŋomesaoŋ Kaperneam taonoŋ kouro. ");
INSERT INTO ksr_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Iikanoŋ Room kawali galeŋ mombaa gawoŋ ejianoŋ ji kiro komumambaa ano. Galeŋanoŋ iwaajoŋ moro uuta kolooro. ");
INSERT INTO ksr_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kawaajoŋ Jiisaswaa bujuya moma Juuda yoŋoo jotamemeya tosaaŋa wasiŋ oŋono Jiisaswaanoŋ kema kokaeŋ qisigi, “Mono kaŋ weleŋ ejia meŋ qeaŋgowa.” ");
INSERT INTO ksr_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kema Jiisaswaanoŋ keuma kaparaŋ koma qama kooliŋ jegi, “Somatanana, kawali galeŋ iikanoŋ mono ilaaŋ mubaatiwaa so awaa soro kolooja. Kawaajoŋ mono kawa.” ");
INSERT INTO ksr_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Moba, iinoŋ Juuda ejemba tuuŋ somata nonoojoŋ siiŋ ano ‘Qamakooli mirinana mewoŋa,’ jeniŋ waba iinoŋ moneŋ ano megi.” ");
INSERT INTO ksr_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kaeŋ jegi moma yoŋowo keno. Kenoto, kawali galembaa miria dodowiro iinoŋ alauruta wasiŋ oŋoma Jiisaswaajoŋ qaa kokaeŋ ano, “Oo Poŋ, nii kaandiaga laligowe noo miri waareŋanoŋ gualeembaatiwaajoŋ gamuna mojeŋ. Kawaajoŋ mono mende aoŋ komuŋ kawa. ");
INSERT INTO ksr_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nii neenaa mobe kamaaŋqeqeta koloojiwaajoŋ goonoŋ kamambaa so mende mojento, qaa jegagadeeŋ jena weleŋ ejananoŋ qeaŋgowaa. ");
INSERT INTO ksr_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ii kokaembaajoŋ: Nii neeno kaaŋagadeeŋ galenaa ku-usuŋ baatanoŋ ama noŋgi laligojeŋ. Noo baananoŋ manjaqeqe eja laligogi ii jeŋ kotoŋ oŋomakejeŋ. Yoŋoonoŋga mombaajoŋ ‘Kemba!’ jeŋ kotowe iinoŋ kembaa. Mombaajoŋ ‘Kawa!’ jeŋ kotowe iinoŋ kawaa ano weleŋ ejana mombaajoŋ ‘Gawoŋ koi mewa!’ jewe iinoŋ ii mewaa.” ");
INSERT INTO ksr_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jiisasnoŋ qaa ii moma kawali galembaajoŋ waliŋgoŋ ejemba tuuŋ otaaŋ kagiti, iyoŋoonoŋ eleema kokaeŋ jero, “Niinoŋ kokaeŋ iŋijowe mobu: Israel kanageso batugianoŋ kaaŋagadeeŋ momalaari somata kaaŋa ii mombaa uutanoŋ mende mokoloowe.” ");
INSERT INTO ksr_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kaeŋ jero kawali galembaa qele ejaurutanoŋ eleema mirinoŋ keuma weleŋ eja mokolooŋ iigi qeaŋgoŋ raro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kawaa gematanoŋ Jiisasnoŋ taoŋ qata Nain kanoŋ keno gowokouruta ano ejemba tuuŋlelembenoŋ otaaŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Iikanoŋ taoŋ kiropo naguya dodowiro qamo moŋ aŋgoŋ kagi. Malo mombaa meriaga motooŋgonoŋ komuro taombaa ejemba tuuŋ somatanoŋ ajorooŋ roŋ kombombaajoŋ kagi. ");
INSERT INTO ksr_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Poŋnoŋ malo ii iima wosoya moma ijoro, “Mende saaba.” ");
INSERT INTO ksr_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kaeŋ jeŋ kema bokis aŋgoŋ kagiti, ii jero doroŋ aŋgi bokis oosiriŋ kokaeŋ jero, “Eja gbaworo, mono waaba. Niinoŋ gii kaeŋ gijojeŋ.” ");
INSERT INTO ksr_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kaeŋ jero qamo kanoŋ gbiliŋ waama kanaiŋ qaa jero. Qaa jero Jiisasnoŋ ii nemuŋa muŋ kembaotiwaajoŋ jero. ");
INSERT INTO ksr_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ejemba kuuya yoŋonoŋ ii iima qarasombugia moma Anutu mepeseeŋ jegi, “Gejatootoo eja somata moŋnoŋ mono batunananoŋ asugiŋ laligoja.” Tosianoŋ jegi, “Anutunoŋ kanagesoya ba koma nonono laligojoŋ.” ");
INSERT INTO ksr_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Iwaa buju qaa ii seiŋ Judia prowins kuuya so koma gomaŋa gomaŋa leelee kanoŋ kema tegoro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon Oomulu ejanoŋ kapuare mirinoŋ raro gowokourutanoŋ iwoi kuuya ii kolooroti, iikawaa sunduya ijogi. ");
INSERT INTO ksr_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ijogi moma gowokowoita woi oroono kari Pombaanoŋ kema kokaeŋ qisiŋ mubaotiwaajoŋ wasiŋ orono, “Meŋqeeaŋgo eja kawaatiwaajoŋ mamboniŋ giinoŋ ii koloojaŋ me eja moŋ kanageŋ kawaatiwaajoŋ mambomboŋa.” ");
INSERT INTO ksr_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Wasiŋ orono Jiisaswaanoŋ keuma ijori, “Jon Oomulu ejanoŋ kokaeŋ qisiŋ gombojoŋ wasiŋ norono kajo, ‘Meŋqeeaŋgo eja kawaatiwaajoŋ mamboniŋ giinoŋ ii koloojaŋ me eja moŋ kanageŋ kawaatiwaajoŋ mambomboŋa.’” ");
INSERT INTO ksr_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jiisasnoŋ kambaŋ iikanondeeŋ ejemba mamaga ji wiji lokoŋ ano omejiilaŋgiawo (isinabisina) ii meŋ qeaŋgoŋ oŋono ano ejemba jaagia googa mamaga jaagia metooro uuŋ iigi. ");
INSERT INTO ksr_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jombaa gowokowoitanoŋ keuma qisiŋ muri kokaeŋ meleeno, “Iwoi iima mojaoti, iikawaa sunduya mono kema Jon kokaeŋ ijowao: Jaagia googa yoŋonoŋ uuŋ iiju. Meendaŋgoya yoŋonoŋ kana kema kaju. Manimbagiawo yoŋonoŋ solaŋaniju. Gejaduu yoŋonoŋ qaa moju. Koomuya yoŋonoŋ gbiliŋ waaju. Kamaaŋqeqeta yoŋoojoŋ Oligaa Buŋa jeŋ asariwe momakeju. ");
INSERT INTO ksr_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kaeŋ kolooro iigi mombaa uutanoŋ mende boliro gema mende nuwaati, iinoŋ mono simbawoŋawo kolooja.” ");
INSERT INTO ksr_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kaeŋ meleeno Jombaa gowoko yoronoŋ keni Jiisasnoŋ kanaiŋ Jombaa kania ejemba tuuŋlelembe yoŋoojoŋ kokaeŋ jeŋ asariro, “Oŋo baloŋ qararaŋkoŋkoŋanoŋ kanoŋ naa iwoiga iibombaajoŋ keŋgi? Haamonoŋ bowo utitiiŋ metano kema kaŋkeji, oŋo eja iikaaŋa iibombaajoŋ keŋgi me? ");
INSERT INTO ksr_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","“Me naa iwoiga iibombaajoŋ keŋgi? Eja malekuya akadamuyawo mouma laligoroti, ii iibombaajoŋ me? Mobu, ejemba malekugia tereya iimasiiŋsiiŋawo mouma kema kaŋ siiseweweya qaa laligojuti, iyoŋonoŋ mono kiŋ yoŋoo jiŋkaroŋ mirigianoŋ laligoju. Ii baloŋ qararaŋkoŋkoŋanoŋ qaago. ");
INSERT INTO ksr_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","“Me naa iwoiga iibombaajoŋ keŋgi? Gejatootoo eja moŋ iibombaajoŋ me? Oŋanoŋ, niinoŋ kokaeŋ iŋijowe mobu: Eja iigiti, iinoŋ mono gejatootoo ejemba tosaaŋa uŋuuguŋ qaita moŋ kolooja. ");
INSERT INTO ksr_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Iwaa kania ii waladeeŋ kokaeŋ oogita eja, ‘Moba, niinoŋ qelena gajoba moŋ wasiwe waladeeŋ kema ejemba uugia mindiŋgoŋ goo kana meleuro giinoŋ mono iwaa gematanoŋ namonoŋ emu kemeba.’ ");
INSERT INTO ksr_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Qaa kaeŋ ejato, niinoŋ kokaeŋ iŋijowe mobu: Embanoŋga meraurugia kuuya megiti, iyoŋoo batugianoŋ Jonoŋ mono kuuya uŋuuguŋ qabuŋayawo nanja. Nanjato, Anutuwaa bentotoŋ uutanoŋ keuma Anutuwaa qabuŋaya mokolooŋkejuti, iyoŋoo batugianoŋ kamaaŋqeqeta konoga iinoŋ mono Jon uuguja. ");
INSERT INTO ksr_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Ejemba kanageso kuuya ano yoŋoo batugianoŋ takis meme yoŋonoŋ kaaŋgadeeŋ Jombaa Buŋa qaaya mogi oomulu meŋ oŋonotiwaajoŋ Jiisaswaa Buŋa qaaya moma jeŋ qeleema jegi, “Ahaa! Anutuwaa kana dindiŋa jeŋ asarija.” Kaeŋ jeŋ uugia meleeŋgi. ");
INSERT INTO ksr_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kaeŋ meleeŋgito, Jonoŋ Farisii ano Kana qaawaa boi oomulu mende meŋ oŋonotiwaajoŋ yoŋonoŋ Anutuwaa areŋa mende teŋ koma Buŋaya gema qeŋ silemale aŋgi. ");
INSERT INTO ksr_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Ejemba kete namonoŋ laligojuti, ii mono naamombo so ama oŋombenaga? Yoŋoo siligia ii nomaeŋ? ");
INSERT INTO ksr_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yoŋonoŋ naamade kaaŋa kolooju. Yoŋonoŋ maaket sombenoŋ rama qaa jomo meŋ tondu qama kokaeŋ jeŋkeju, ‘Nono awelo uuniŋ oŋo rii gbawe mende orogi. Nono jiŋgeŋ qaniŋ oŋo mende toroqeŋ saagi.’ ");
INSERT INTO ksr_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Iikawaa kania ii kokaeŋ: Jon Oomulu ejanoŋ kaŋ nene siŋgiŋ laligoŋ wain apu mende nero oŋo iwaajoŋ jeŋkeju, ‘Ome moŋnoŋ uutanoŋ kemerota laligoja.’ ");
INSERT INTO ksr_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","“Siwe gomambaa Eja hoŋanoŋ kaŋ nene neŋ korisoro aŋgi oŋonoŋ jeŋkeju, ‘Mobu, iinoŋ baonoŋ newageeŋ nene qozozoŋgoŋ neŋ wain apu mamaga neŋ takis eja tiliqiligiawo ano kileŋa meme yoŋoo alagiaga laligoja.’ ");
INSERT INTO ksr_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Korebore Anutuwaa momakooto koma gbiliŋkejuti, iyoŋoo nanamemeŋgiaa hoŋanoŋ mono momakooto-gianoŋ sokonji, ii qendeemakeja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisii (Kana qaawaa kaparaŋkoŋkoŋ) eja yoŋoonoŋga moŋnoŋ Jiisas ii iyaŋaa mirianoŋ kaŋ nene newaatiwaa koma hororo. Koma hororo kema mirianoŋ uma nene duŋnoŋ raro. ");
INSERT INTO ksr_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Taoŋ kanoŋ siŋgisoŋgo emba moŋ laligoro. Iinoŋ Jiisas Farisii ejawaa mirinoŋ uma rama nene neroti, iikawaa bujuya moma kele uŋkoowayawo maaro jamo kaaro moŋ saa qeroti, ii meŋ uma karo. Kaaro ii lalu laŋgoŋawo qata alabasta iikanoŋ memetaga. ");
INSERT INTO ksr_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Uma kaŋ Jiisaswaa kanianoŋ kemeŋ rama kanaiŋ saaro jauŋanoŋ riima kemeŋ kanianoŋ moriro. Moriro waŋ juyanoŋ kereŋ, selemooto meŋ kotoro toboriro kania buutanoŋ kitoŋ neŋ kele uŋkoowayawonoŋ moriro. ");
INSERT INTO ksr_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Moriroto, Farisii ejanoŋ Jiisas koma hororoti, iinoŋ ii iima uutanoŋ kokaeŋ romoŋgoro, “Emba koi siŋgisoŋgoyawoga. Eja koi kanoŋ gejatootoo ejaga laligonagati eeŋ, iinoŋ mono emba kanianoŋ oosirijiwaa kania moma kotonaga.” ");
INSERT INTO ksr_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jiisasnoŋ ii moma kotoŋ kokaeŋ meleema jero, “Saimon, niinoŋ qaa moŋ jemambaajoŋ mojeŋ.” Jero ijoro, “Boi, saanoŋ jena momaŋa.” ");
INSERT INTO ksr_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ijoro Jiisasnoŋ kokaeŋ ijoro, “Ejemba woinoŋ benknoŋ kema kiti ambowaa moneŋ galeŋaa qisiri. Moŋnoŋ weeŋ 500:waa tawaya (Kina 5,000), moŋnoŋ weeŋ 50:waa tawaya (Kina 500) kawaa so kiti ambotiwaa qisiri. Qisiri iikawaa so orono. ");
INSERT INTO ksr_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Oroma kanageŋ kitigara kumbao jero moneŋgara qaono amamaari. Amamaari benk galeŋanoŋ kitigara qetegoŋ kotoŋ mesaoŋ orono. Mesaoŋ orono iyoroonoŋga moronoŋ ii uutanoŋ mamaga jopagoŋ muŋkeja?” ");
INSERT INTO ksr_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Kaeŋ qisiro Saimonoŋ kokaeŋ meleeno, “Noo momonoŋ kiti somata kotoŋ mesaoŋ muroti, iinoŋ.” Kaeŋ meleeno jero, “Gii qaa tororo gosiŋ jejaŋ.” ");
INSERT INTO ksr_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kaeŋ jeŋ embawaanoŋ eleema kokaeŋ ijoro, “Emba koi iiba. Niinoŋ miriganoŋ koube giinoŋ kanana soŋgbamambaajoŋ apu moŋ mende nonjanto, emba koi kanoŋ mono kanana jauŋanoŋ moriŋ waŋ juyanoŋ selemooto meŋ kotoro toborija. ");
INSERT INTO ksr_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Giinoŋ buuna mende kitoŋ nejanto, emba koi kanoŋ mono mirinoŋ koube iikanondeeŋ kaparaŋ koma kanana kitoŋ neŋ laligoja. ");
INSERT INTO ksr_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Giinoŋ waŋna kele mende morijanto, emba koi kanoŋ mono kele uŋkoowayawonoŋ kanananoŋ nomorija. ");
INSERT INTO ksr_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kawaajoŋ niinoŋ kokaeŋ jewe moba: Anutunoŋ emba kokawaa siŋgisoŋgoya mamaga ii mesaoŋ soŋgbano kawaajoŋ uutanoŋ nii mamaga jopagoŋ nonja. Moŋnoŋ siŋgisoŋgo melaada moŋ ano Anutunoŋ siŋgisoŋgoya melaada mesaoro iinoŋ uutanoŋ boroŋa moŋ iigadeeŋ jopagoŋ nomakeja.” ");
INSERT INTO ksr_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kaeŋ jeŋ emba ii kokaeŋ ijoro, “Niinoŋ goo siŋgisoŋgoga soŋgbama mesaojeŋ.” ");
INSERT INTO ksr_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kaeŋ jero eja motooŋ nene neŋ ragiti, iyoŋonoŋ kanaiŋ iyaŋgiodeeŋ kokaeŋ jegi, “Siŋgisoŋgo soŋgbama mesaoji, iinoŋ mono moro ejaga koloomambaa moja?” ");
INSERT INTO ksr_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kaeŋ jegito, Jiisasnoŋ embawaajoŋ jero, “Momalaariganoŋ mono hamo qeŋ gonja. Saanoŋ luaenoŋ kemba.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kawaa gematanoŋ Jiisasnoŋ liligoŋ taoŋa taoŋa ano gomaŋa gomaŋa kanoŋ kema Anutuwaa bentotombaa kania jeŋ asariŋ Oligaa Buŋa qaanoŋ ejemba uugia kuuŋ laligoro. Gowokouruta 12 yoŋonoŋ iwo motooŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kaaŋagadeeŋ emba tosianoŋ iwo keŋgi. Emba ii wala ji iŋiro omenoŋ kokojinjiŋ meŋ oŋono laligogi Jiisasnoŋ meŋ qeaŋgoŋ oŋono. Emba ii kokaeŋ: Magdalaga emba moŋ qata Maria qagi. Jiisasnoŋ iwaa uutanoŋga ome 7 oŋotaaro kouma keŋgi. ");
INSERT INTO ksr_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Emba moŋ qata Joana. Iwaa loya qata Kuza iinoŋ kiŋ Herodwaa jiŋkaroŋ miri kanoŋ gawmambaa moneŋ galeŋaga laligoro. Emba moŋ qata Susana. Yoŋonoŋ ano emba tosaaŋa mamaga yoŋonoŋ iyaŋgiaa moneŋ esuhinagianoŋ Jiisas ano gowokouruta kananoŋ galeŋ koma naŋgoŋ oŋoŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ejembanoŋ taoŋ so kanoŋa horoŋ Jiisaswaanoŋ kaŋ tuuŋlelembenoŋ ajoroogi Jiisasnoŋ sareqaa moŋ kokaeŋ jero: ");
INSERT INTO ksr_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Eja moŋnoŋ nene kota qosoma kororoomambaajoŋ keno. Kema qosono kota tosianoŋ kana goraayanoŋ kemeŋ koŋgi. Kemeŋ koŋgi ejembanoŋ riiŋ rikotaagi kanakeewaŋaa (waraweŋ) kooŋa kooŋa kouma ii nedaborogi. ");
INSERT INTO ksr_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kota tosianoŋ jamo kowonjinoŋ kemeŋ koŋgi. Kemeŋ koma kanoŋ namo apuyawo mende mokolooŋ kuragagia kouma sooliŋ gororoŋgogi. ");
INSERT INTO ksr_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","“Kota tosianoŋ komuntiri waayawonoŋ kemeŋ koŋgi. Kemeŋ koŋgi iikanoŋ ororoŋ kouma uŋuuguŋ qeŋ turuŋ bibiloko meŋ oŋoŋgi. ");
INSERT INTO ksr_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kota tosianoŋ namo awaanoŋ kemeŋ koŋgi. Kemeŋ koma juma waama hoŋgia awaa kolooŋ handewaa so kolooŋ seigi.” Qaa ii jedaboroŋ qa somata kokaeŋ qaro, “Moŋnoŋ uugejiawo laligoji eeŋ, iinoŋ mono sareqaa koi geja ama moma kotowa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kaeŋ jero gowokourutanoŋ sareqaa kokawaa kaniaajoŋ Jiisas qisiŋ mugi. ");
INSERT INTO ksr_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Qisiŋ mugi jero, “Anutuwaa bentotoŋanoŋ keuma laligowoŋatiwaa qaa aasaŋgoya ii oŋo asuganoŋ iŋijowe moma kotojuto, tosaaŋa yoŋoojoŋ ii sareqaanoŋ jewe momakeju. Kaeŋ moma iyaŋgiaa jaagianoŋ iwoi iimago kania kileŋ mende iima kotowuya. Iyaŋgiaa gejagianoŋ qaa tororo momago kania kileŋ mende moma asariwuya.” ");
INSERT INTO ksr_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Sareqaa iikawaa kania ii kokaeŋ: Kota qosoma kororooji, ii Anutuwaanoŋ Buŋa qaa. ");
INSERT INTO ksr_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nene kota kana goraayanoŋ kemeŋ koŋgiti, ii kokaeŋ: Ejemba tosianoŋ Buŋa qaa mojuto, ii mogi Kileŋaa Toyanoŋ kaŋ uugia meleema Siwewaa buŋa koloowubotiwaajoŋ qaa kota ii uugianoŋga qetegoŋ uŋuamakeja. ");
INSERT INTO ksr_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nene kota qosono jamo kowonjinoŋ kemeŋ koŋgiti, ii ejemba sareya moŋ. Yoŋonoŋ Buŋa qaa moma ii uuqeeaŋgo qaganoŋ moma aŋgoŋ komakejuto, uugianoŋ kemeŋ tiigia mende megitiwaajoŋ kambaŋ torodaamo-ŋadeeŋ moma laariŋ laligogi aŋgobatowaa kambaŋanoŋ mono tama uŋuwaa. ");
INSERT INTO ksr_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Nene kota qosono kumuntiri waayawonoŋ kemeŋ koŋgiti, ii kokaeŋ: Yoŋonoŋ Buŋa qaa mogi uugianoŋ kemeŋkejato, balonoŋ laaligowaa majakakaya ano moneŋ hina memewaa uugereya kolooŋ bimooŋ oŋomakeja. Qabuŋagiawo koloowombaajoŋ koposoŋgogi siiŋ kombombaŋa bologa tosianoŋ kaaŋagadeeŋ uugianoŋ duŋguŋ Buŋa qaa bibiloko meŋ muŋkeju. Kaeŋ kolooro hoŋgia qaa auta (gipeya) koloowuya. ");
INSERT INTO ksr_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kaento, nene kota namo awaanoŋ kemeŋ koŋgiti, ii ejemba koi kaaŋa: Yoŋonoŋ Buŋa qaa geja ama mogi uugia awaa gbiŋgbaoŋa qaa iikanoŋ kemero soowabotiwaajoŋ mokosiŋgoŋ kaparaŋ koma galeŋ koŋgi hoŋgia awaa awaa mokolooŋkeju.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Moŋnoŋ lambe me kiwa ootiriŋ monjonoŋ mende koma turuwaa me duŋ baatanoŋ mende ambaa. Ii qaagoto, ii iikawaa duŋ qaganoŋ ano rabaa. Rama asariro tosianoŋ miri uutanoŋ ubombaajoŋ mojuti, yoŋonoŋ iikawaa asasaga iima saanoŋ ubuya. ");
INSERT INTO ksr_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Kaaŋiadeeŋ uunananoŋ iwoi moŋ mesaŋgoniŋ aasaŋgoyanoŋ eji, ii mono asuganoŋ koloowaa. Iwoi moŋ koma turuniŋ eji, ii mono luluuŋgi asuganoŋ ewaa. ");
INSERT INTO ksr_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Kawaajoŋ Anutuwaa qaa mojuti, ii mono uu wombogianoŋ ama romoŋgoŋ koma gbiliŋ laligowu. Moŋnoŋ momakootoyawo laligoji, Anutunoŋ mono ii toroqeŋ muro somariiwaato, moŋnoŋ momakootoya qaa laligojato, ‘Kawo laligojeŋ,’ jeji, Anutunoŋ mono momoya melaa ii kaaŋagadeeŋ qetegoŋ wambaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jiisasnoŋ kaeŋ jeŋ laligoro nemuŋ kourutanoŋ ii iibombaajoŋ kagito, ejemba tuuŋ somatanoŋ ologoŋ eligogitiwaajoŋ kosianoŋ kembombaajoŋ amamaagi. ");
INSERT INTO ksr_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Amamaaŋ naŋgi moŋnoŋ kokaeŋ ijoro, “Goo nemuŋkoaŋga mono seleeŋgeŋ nama gii giibombaajoŋ moju.” ");
INSERT INTO ksr_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ijoroto, Jiisasnoŋ kokaeŋ meleema iŋijoro, “Ejemba koi Anutuwaa Buŋa qaa moma teŋ koma koma gbiliŋkejuti, iyoŋonoŋ mono noo nemuna ano kouruna kolooju.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Weeŋ moŋnoŋ Jiisasnoŋ gowokouruta kokaeŋ iŋijoro, “Mono mesaoŋ apu aŋgoŋ kotoŋ leegeŋ keuboŋa.” Kaeŋ jero waŋgonoŋ motooŋ uma apu aŋgoŋ qaganoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kema opo sel mororoŋgogi haamonoŋ naŋgoro keŋgi Jiisasnoŋ gaoŋ ero. Ero haamo raidimboŋ apu aŋgonoŋ giliŋ siri qindiiro waŋgo uutanoŋ kemero. Kemeŋ saa qemambaajoŋ ano tiwilaawombaajoŋ aŋgi. ");
INSERT INTO ksr_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tiwilaawombaajoŋ ama gowokourutanoŋ kema mindiiŋ ijogi, “Poŋ Somatanana, mono nono aŋgonoŋ tiwilaawombaajoŋ anjoŋ.” Kaeŋ ijogi uuta tooro musu ano apu aŋgombaa siria kokaeŋ jeŋ kotoŋ orono esuŋgaranoŋ kamaaro goroŋ qeŋ ero. ");
INSERT INTO ksr_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kaeŋ kolooro iŋijoro, “Oŋoo momalaarigia ii dakanoŋ?” Kaeŋ iŋijoroto, yoŋonoŋ awawaliŋ qarasombugia moma jegi, “Yei! Eja koi naa ejaga laligoja? Iinoŋ musu ano kowe siri jeŋ kotoŋ orono jeta teŋ konjao.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jiisasnoŋ gowokouruta yoŋowo toroqeŋ opo sel mororoŋgogi haamonoŋ naŋgoro kema apu aŋgoŋ kotoŋ Galili prowins leegeŋ Gerasa gomanoŋ keugi. ");
INSERT INTO ksr_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iikanoŋ keuma sakasinoŋ uro eja omeyawo moŋ taonoŋga kaŋ Jiisas mokolooro. Eja ii qasirinoŋ laligoŋ qamowaa jamo kobaa osoŋ uroroogi egiti, iikanoŋ eŋ laligoro. Kambaŋ koriga opo maleku mende mouma miri mombaa uutanoŋ mende eŋ laligoro. ");
INSERT INTO ksr_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Omenoŋ kambaŋ koriga horoŋ ureeŋ muro eja mamaganoŋ boria bota qeŋ kania gbadonoŋ (tapenoŋ) somoŋgoŋ galeŋ koma laligogito, tapeya ii hororo riiqiiro omenoŋ kuuro baloŋ qararaŋkoŋkoŋanoŋ kema laŋ laligoro. Kawaajoŋ Jiisasnoŋ omeya ii kokaeŋ jeŋ kotoŋ mumambaajoŋ ano, “Ome bologa, gii mono kouma eja koi mesaoŋ kemba.” Kaeŋ jemambaajoŋ ano Jiisas iima silama namonoŋ kosianoŋ kemeŋ qa gigilaaŋ kokaeŋ qaro, “Ae Jiisas, gii Anutu uutaa meria koloojaŋ. Gii mono nomaeŋ ama nomambaajoŋ koi kajaŋ? Niinoŋ welema gonjeŋ: Gii siimbobolo geriawo mende ama nomba.” ");
INSERT INTO ksr_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Kaeŋ qaro kokaeŋ qisiro, “Gii qaga moro?” Omejiilaŋ mamaga uutanoŋ kemeŋ laligogitiwaajoŋ “Qanana Liijon jejoŋ,” jegi. Ii ananaa qaanoŋ Kere tuuŋ somata. ");
INSERT INTO ksr_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kaeŋ jeŋ Jiisas kokaeŋ welema mugi, “Gii nonotaaŋ ome roŋ dusiita qaa iikanoŋ kemebombaajoŋ mende jeŋ kotoŋ nonomba.” ");
INSERT INTO ksr_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kosogianoŋ maroŋa kanoŋ bao tuuŋ somata moŋ gbojoja uutanoŋ kuluuma laligogi. Kawaajoŋ ome yoŋonoŋ kokaeŋ jeŋ welema mugi, “Gii saanoŋ jena nono bao yoŋoo uugianoŋ kemeboŋa.” Welema mugi “Mono kema kemebu,” jeŋ kotoŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jeŋ kotoŋ oŋono eja uutanoŋga kouma kema bao uugianoŋ kemegi. Kemegi bao tuuŋ yoŋonoŋ luguŋ newonewonoŋ kema jororoŋgoŋ apu aŋgonoŋ kemeŋ nemotoŋ komugi. ");
INSERT INTO ksr_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Iikaeŋ kolooro bao galeŋ yoŋonoŋ ii iima taoŋ ano gomaŋ boleboole kanoŋ kok koma unjurama kema buju qaa ii jegi. ");
INSERT INTO ksr_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Jegi moma ejemba jaasooŋgo yoŋonoŋ iwoi kolooroti, ii iibombaajoŋ kagi. Kaŋ Jiisaswaanoŋ kouma eja uutanoŋga omenoŋ kougiti, iinoŋ Jiisaswaa kanianoŋ raro mokoloogi. Opo selekopaaya tororo somoŋgoŋ uuta tooro roromoŋgoya kuuya asugiro iima awawaligi. ");
INSERT INTO ksr_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Eja omeyawo iinoŋ nomaeŋ qeaŋgoroti, ii iigitinoŋ iŋijogi. ");
INSERT INTO ksr_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Iŋijogi moma mamaganoŋ awawaliŋ qarasombugia mogi. Kawaajoŋ Gerasa gomambaa ejemba tuuŋ kuuya yoŋonoŋ Jiisasnoŋ oŋomesaowaatiwaajoŋ welema mugi. Welema mugi eleema kemambaajoŋ waŋgonoŋ umambaa ano. ");
INSERT INTO ksr_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Umambaa ano eja uutanoŋga ome kougiti, iinoŋ kaŋ Jiisaswo motooŋ kema laligomambaajoŋ qisiro. Kaeŋ qisiroto, Jiisasnoŋ qotogoŋ wasiŋ muŋ kokaeŋ ijoro, ");
INSERT INTO ksr_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Gii mono eleema miriganoŋ kema Anutunoŋ aŋgoleto somasomata meŋ gonoti, iikawaa sunduya jena mobu.” Kaeŋ ijoro kema Jiisasnoŋ aŋgoleto somasomata meŋ muroti, iikawaa qaaya ii taoŋ uutanoŋ liligoŋ gomaŋ so jeŋ seiro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ejemba kuuya Jiisaswaajoŋ mamboŋgi eleema karo tuuŋa tuuŋa koma aisooŋ horoŋ mugi. ");
INSERT INTO ksr_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Qamakooli miriwaa qaa galeŋ moŋ qata Jairus iinoŋ kaŋ Jiisaswaa batanoŋ kemeŋ simiŋ kuma mirianoŋ kawaatiwaajoŋ qama kooliŋ muro. ");
INSERT INTO ksr_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Merauruta qaato, borata guaŋ motooŋgo gbania 12:waa so laligoŋ komumambaajoŋ ano. Jiisas koma horoŋ mugi keno ejembanoŋ leelee ologoŋ utama mugi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Utama muŋ keŋgi kanoŋ batugianoŋ emba moŋ laligoro. Iinoŋ koiŋsa gbani 12 kawaa so iima ji kiro laligoro. Iinoŋ selegaleŋ yoŋoo tawagia moneŋ hinaya kuuya giliŋ laligoro selegaleŋ kuuyanoŋ meŋ qeaŋgowombaajoŋ amamaagi. ");
INSERT INTO ksr_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Emba kanoŋ Jiisaswaa gematanoŋ kema malekuyaa kiti susuya oosiriro iikanondeeŋ saya juguro. ");
INSERT INTO ksr_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jiisasnoŋ qisiŋ jero, “Moronoŋ noosirija?” Kaeŋ jeroto, ejemba kuuyanoŋ ii qakooŋgi Piitonoŋ ijoro, “Somatana, ejemba tuuŋnoŋ ologoŋ utama aoŋ kaŋ goosiriju.” ");
INSERT INTO ksr_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ijoro Jiisasnoŋ jero, “Qaago, moŋnoŋ noosiriro esuŋna moŋ keno mojeŋ.” ");
INSERT INTO ksr_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kaeŋ jero embanoŋ “Kaniana mokolooja,” jeŋ jeneŋa ororo kaŋ Jiisaswaa batanoŋ simiŋ kuma jiaa kania ano oosiriŋ iikanondeeŋ qeaŋgoroti, iikawaa kania asuganoŋ jero ejemba tuuŋ kuuyanoŋ mogi. ");
INSERT INTO ksr_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Mogi Jiisasnoŋ kokaeŋ ijoro, “Borana, momalaariganoŋ mono meŋ qeaŋgoŋ gonja. Saanoŋ uubonjonoŋ kemba.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Qaa kaeŋ ijoŋ nano qamakooli miriwaa qaa galeŋaa mirinoŋga moŋnoŋ weleŋ kaŋ Jairus ijoro, “Boraganoŋ komuja! Kawaajoŋ mono boiwaa qaganoŋ lombo toroqeŋ mende amba.” ");
INSERT INTO ksr_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ijoroto, Jiisasnoŋ qaa ii moma qamakooli miriwaa qaa galeŋ kokaeŋ ijoro, “Toroko mende moba. Mono uumotooŋ ama nii moma laariŋ nona boraganoŋ qeaŋgowaa.” ");
INSERT INTO ksr_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kaeŋ ijoŋ iwaa mirinoŋ kema ejemba tosaaŋa oŋomesaoŋ Piito, Jon, Jeims ano borawaa nemuŋmaŋa iigadeeŋ uŋuano iyaŋgiodeeŋ miri uutanoŋ ugi. ");
INSERT INTO ksr_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ugi ejemba kuuyanoŋ jiŋgeŋ qama saama amburereŋ megito, Jiisasnoŋ jero, “Iinoŋ mende komujato, gaoŋga eja. Kawaajoŋ mono saa mesaowu.” ");
INSERT INTO ksr_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kaeŋ jero jonoŋsisi kaaŋa kolooro “Mono komuja!” qaa ii moma jomoma mugi. ");
INSERT INTO ksr_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jomoma mugito, bora ii borianoŋ meŋ qama ijoro, “Borana, mono waaba.” ");
INSERT INTO ksr_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kaeŋ ijoro kokoosuyanoŋ eleeno iikanondeeŋ waama nano. Nano nene mugi newaatiwaajoŋ jero. ");
INSERT INTO ksr_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nemuŋmaŋanoŋ ii iima waliŋgorito, Jiisasnoŋ iwoi kolooroti, iikawaa bujuya moŋ jegi mobubotiwaajoŋ soŋgo ama oŋono. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jiisasnoŋ gowokouruta 12 ii oŋoono ajoroogi omejiilaŋ kuuya konjoma oŋombutiwaajoŋ ama ji wiji meŋ qeaŋgowutiwaajoŋ ku-usuŋa esuŋmumuyawo oŋono. ");
INSERT INTO ksr_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ku-usuŋ oŋoma kokaeŋ jeŋ wasiŋ oŋono, “Oŋo mono kema Anutuwaa bentotombaa kania ejemba jeŋ asariŋ oŋoma ji ejemba meŋ qeaŋgoŋ oŋoma laligowu.” ");
INSERT INTO ksr_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wasiŋ oŋoma iŋijoro, “Oŋo kana kembutiwaajoŋ iwoi moŋ mende meŋ kembu, taa gbaru mende, geso mende, kana samoŋ mende ano soojaakota mende. Maleku samoŋa mendeto, motooŋgo mewu. ");
INSERT INTO ksr_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“Kema mirinoŋ daeŋ daeŋ keubuti, mono iikanondeeŋ laligoŋ gawoŋ meŋ taoŋ ii mesaoŋ kana kembu. ");
INSERT INTO ksr_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kema laligoŋ miri moŋnoŋ keugi mende koma horoŋ oŋoma qaagia mende mogi telambelaŋgia mono kokaeŋ jeŋ qendeema oŋombu, ‘Nono oŋoo balonoŋ kaniŋ sububuŋ kana tambonananoŋ mokotaaji, ii mono qesaaniŋ oŋoaŋgiaanoŋ eleema kemebaa.’ Kaeŋ jegi kaniagia solaŋa moma kotogi saanoŋ taoŋ ii mesaoŋ toroqeŋ kembu.” ");
INSERT INTO ksr_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kaeŋ iŋijoro mesaoŋ kema gomaŋa gomaŋa liligoŋ miri so Oligaa Buŋa jeŋ asariŋ ji ejemba meŋ qeaŋgoŋ oŋoma laligogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Iwoi kuuya kolooroti, iikawaa qabuŋayanoŋ seiŋ baloŋ bakayaa (Galili prowinswaa) kiŋ Herodwaa gejianoŋ kemero moro. Ejemba tosianoŋ kokaeŋ jegi, “Jon Oomulu ejanoŋ mono koomunoŋga waama laligoja.” Kawaajoŋ kiŋnoŋ qaawaa moŋgama sisau ano. ");
INSERT INTO ksr_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Anoto, tosianoŋ jegi, “Elaijanoŋ mombo asugiŋ laligoja.” Tosianoŋ toroqeŋ jegi, “Gejatootoo eja walaga yoŋoonoŋga moŋnoŋ mono gbiliŋ waama laligoja.” ");
INSERT INTO ksr_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kaeŋ jegito, kiŋ Herodnoŋ kokaeŋ jero, “Jon Oomulu eja ii niinoŋ jewe aroya kotogito, mombaa qaaya kaeŋ jegi mojeŋi, ii mono moronoŋ?” Kaeŋ jeŋ Jiisas iimambaajoŋ kaparaŋ koma jejeromoŋromoŋ ano. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wasiwasi eja aposol yoŋonoŋ Jiisaswaanoŋ eleema iwoi ama megiti, iikawaa sunduya kuuya ijogi. Ijogi uŋuama ejemba qenjaaro sombeŋgia mesaoŋ taoŋ qata Betsaida kawaa kosianoŋ iyaŋgia siri gbameŋanoŋ laligowombaajoŋ keŋgi. ");
INSERT INTO ksr_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Keŋgito, ejemba tuuŋ yoŋonoŋ ii moma Jiisas gematanoŋ otaaŋ keŋgi. Kema Jiisas-waanoŋ kagi koma horoŋ oŋoma Anutu bentotombaa kania jeŋ asariŋ ji ejemba meŋ qeaŋgoŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kaeŋ ama laligoro weeŋ jaaya tegoŋ kememambaajoŋ ano. Kaeŋ kolooro gowoko 12 yoŋonoŋ kaŋ Jiisas kokaeŋ ijogi, “Nono baloŋ gbameŋa koi kanoŋ laligojoŋiwaajoŋ gii saanoŋ ejemba tuuŋ koi wasiŋ oŋona gomaŋ miri kosere kosere rama kenjuti, iikanoŋ kema eemiri ano nembanene mokoloowu.” ");
INSERT INTO ksr_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kaeŋ ijogito, kokaeŋ iŋijoro, “Oŋonoŋ mono oŋoaŋgio ii nene uŋuagiwu.” Kaeŋ iŋijoro meleeŋgi, “Nono bered 5 ano sora woi iikayadeeŋ meŋ laligojoŋ. Kawaajoŋ nomaeŋ ambonaga? Nono saanoŋ kema ejemba tuuŋ koi kuuya yoŋoojoŋ nene sewaŋa mewonaga me? ");
INSERT INTO ksr_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Yoŋonoŋ eja 5,000:baa so laligoju.)” Kaeŋ meleeŋgi gowokouruta kokaeŋ iŋijoro, “Oŋonoŋ mono ejemba iŋijoŋ mendeema oŋoŋgi tuuŋ so 50:waa so nene newombaajoŋ ajorooŋ kamaaŋ rabu.” ");
INSERT INTO ksr_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Iŋijoro iikaeŋ ama mendeema oŋoŋgi ejemba kuuyanoŋ kamaaŋ tuuŋa tuuŋa rama keŋgi. ");
INSERT INTO ksr_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Rama keŋgi bered 5 ano sora woi ii meŋ Siwenoŋ uuro uro kotuegoro. Kotuegoŋ bered motoŋ gowokouruta oŋono ejemba tuuŋ so mendeema batugianoŋ aŋgi. ");
INSERT INTO ksr_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Batugianoŋ aŋgi korebore neŋ neŋ timbiriŋgogi. Nene kitia reemoŋa mesaogiti, ii gowoko yoŋonoŋ meŋ kululuugi konde 12 kanoŋ kemeŋ saa qero. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kambaŋ moŋnoŋ Jiisasnoŋ iyaŋodeeŋ gomaŋ moŋgeŋ qama kooliro gowokourutanoŋ iwo laligogi qisiŋ oŋoma kokaeŋ iŋijoro, “Ejembanoŋ noojoŋ nomaeŋ jeŋkeju? Nii moroga koloojeŋ?” ");
INSERT INTO ksr_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Iŋijoro meleema kokaeŋ jegi, “Tosianoŋ ‘Gii Jon Oomulu ejaga koloojaŋ,’ jeŋkejuto, tosianoŋ ‘Gii Elaija koloojaŋ,’ jeŋkeju ano tosianoŋ toroqeŋ kokaeŋ jeŋkeju, ‘Gii gejatootoo eja walaga yoŋoonoŋga moŋnoŋ koomunoŋga waama laligojaŋ.’” ");
INSERT INTO ksr_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kaeŋ jegi kokaeŋ qisiŋ oŋono, “Ano oŋoaŋgio noojoŋ nomaeŋ jeju? Nii moroga koloojeŋ?” Qisiŋ oŋono Piitonoŋ meleema ijoro, “Gii Anutuwaanoŋ Hamoqeqe Toya Kraist koloojaŋ.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kaeŋ qisiŋ oŋono kania asuganoŋ jegi moŋnoŋ mobutiwaajoŋ soŋgo kotakota ama oŋono. ");
INSERT INTO ksr_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jiisasnoŋ jero, “Siwe gomambaa Eja hoŋanoŋ mono siimbobolo mamaga mobaa. Kantriwaa jotamemeya, jigo gawoŋ galeŋ ano Kana qaawaa boi yoŋonoŋ mono gema qeŋ qegi komuwaa. Komuŋ weeŋ karooŋ kolooro koomunoŋga waabaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jiisasnoŋ ejemba kuuya ii qaa kokaeŋ iŋijoro, “Moŋnoŋ noo gemananoŋ notaaŋ kamambaajoŋ moji, iinoŋ mono iyaŋaa uuseliaa siiŋ kombombaŋa bologa gema qero ‘Buŋa gbilia meŋ kaja,’ jeŋ sisia megi siimbobolo ii bisimakeba. Ii maripoonoŋ komuwaatiwaa so mokosiŋgoŋ nii notaaŋ kawa. ");
INSERT INTO ksr_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","“Moŋnoŋ laaligoya iyaŋaajoŋ aŋgoŋ koma iyaŋaa jaajaa laligoji, iinoŋ mono laaligoya hoŋa somoŋgoro soowaa. Soowaato, moŋnoŋ balombaa laaligoya noojoŋ ama qeleema togoŋ nombaati, iinoŋ mono laaligo hoŋaa kania mokolooŋ kotiiŋ laligowaa. ");
INSERT INTO ksr_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","“Moŋnoŋ baloŋa baloŋa iyoŋoo ilawoilaya kuuya koma hororo buŋaya kendabororo uutaa laaligoya meŋ sooŋ silemale laligoŋ komuro Anutunoŋ qaaya jeŋ tegoro gere sianoŋ kemeŋ uŋayanoŋ tiwilaaro mende sokombaa. Esuhinaya iikanoŋ mono uukoisoro mende ama mubaa. Qaago totooŋ! ");
INSERT INTO ksr_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Moŋnoŋ noo qana ano Buŋa qaana meŋ kamaaŋ anji, ii Siwe gomambaa Eja hoŋanoŋ kaaŋagadeeŋ iima tiiwaa. Iinoŋ kanageŋ Siwe gajoba toroya yoŋowo koi kamaagi iyoŋoonoŋ, aŋaa ano Maŋaa asamararaŋgia iima aaruwuya. Kambaŋ iikanoŋ eja me emba kaaŋa mono iima tiiŋ mubaa. ");
INSERT INTO ksr_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Koi nanjuti, oŋoo batugianoŋga tosianoŋ Anutuwaa bentotoŋaa hoŋanoŋ koloowaati, ii iima kotowuya. Jaawo laligoŋ koomuwaa siimboboloya mende mogi asugiro ii iibuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Qaa ii iŋijoro weeŋ 8:waa so tegoro Jiisasnoŋ Piito, Jon ano Jeims uŋuama baaŋanoŋ uma Anutu qama kooliro. ");
INSERT INTO ksr_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Qama kooliro iikanoŋ jaasewaŋaa kaitanianoŋ letoma qaita moŋ kolooro. Malekuyanoŋ tualalakota kolooŋ kokobilibiliawo asariro. ");
INSERT INTO ksr_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Iikanondeeŋ iigi eja woinoŋ asugiŋ Jiisaswo qaa qaa amigi. Ii Mooses ano Elaija. ");
INSERT INTO ksr_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Asamararaŋ uutanoŋ asugiŋ Jiisaswo qaa kokaeŋ amiŋ mogi, “Anutunoŋ Jiisas siimbobolo moma komuwaati-waajoŋ wasiro kamaaŋ uulaŋawo Jerusalem sitinoŋ keno areŋ iikanoŋ hoŋawo koloodaborowaa.” ");
INSERT INTO ksr_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Kaeŋ amiŋ mogito, Piitonoŋ alawoita yorowo jaagianoŋ bimooro gaoŋ egi. Egito, gaonoŋga uugia tooro jaagia uuŋ Jiisaswaa asamararaŋa ano eja woi iwo naniti, ii iŋiigi. ");
INSERT INTO ksr_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Iŋiigi nama Jiisas mesaowotiwaajoŋ ani Piitonoŋ Jiisas ijoro, “Somatanana, nononoŋ koi kanoŋ keraqeeaŋgo mojoŋ. Kawaajoŋ nononoŋ saanoŋ kuuŋ karooŋ mewoŋa: Goojoŋ moŋ, Mooseswaajoŋ moŋ ano Elaijawaajoŋ moŋ.” Piitonoŋ kaeŋ ijoroto, iyaŋaa qaayaa kania ii mende moma kotoro. ");
INSERT INTO ksr_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kaeŋ jeŋ nano kokolo moŋnoŋ kamaaŋ aoŋanoŋ esuuŋ oŋono koosu uutanoŋ laligoŋ awawaliŋ jeneŋgia ororo. ");
INSERT INTO ksr_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Jeneŋgia ororo naŋgi koosu uutanoŋga qa aro moŋ kokaeŋ kamaaro mogi, “Eja koi ii neenaa meranaga. Ii ejemba hamo qeŋ oŋomambaajoŋ meweeŋgoŋ mube. Mono iwaa qaaya moma laligowu.” ");
INSERT INTO ksr_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Qa aro iikanoŋ kamaaro moma gowoko yoŋonoŋ iikanondeeŋ uuŋ Jiisasnondeeŋ nano iigi. Baaŋanoŋ iwoi iigiti, iikawaa bujuya ii kambaŋ iikanoŋ mende jeŋ qaagia bogoro laligogi moŋnoŋ moŋ mende moro. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Eŋ waagi Jiisasnoŋ gowokouruta karooŋ yoŋowo baaŋanoŋga kamaaŋ roganoŋ ejemba tuuŋlelembe iŋiigi. ");
INSERT INTO ksr_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Iŋiigi ejemba tuuŋnoŋga eja moŋnoŋ qama kokaeŋ ijoro, “Boi, noo merana guaŋga koloojiwaajoŋ mono kaŋ ii iiba. Kawaajoŋ qama kooliŋ gonjeŋ. ");
INSERT INTO ksr_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Moba, ome moŋnoŋ ii menduŋgoro iikanondeeŋ qa gigilaaro utugoŋ muro wolaza hororo buutanoŋga kokopa kamaaŋkeja. Ome iikanoŋ horoŋ ureeŋ muŋ kambaŋ mamaga mende mesaoŋkeja. ");
INSERT INTO ksr_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kaeŋ kolooro goo gowokouruga ome ii otaawutiwaajoŋ welema oŋonjento, yoŋonoŋ ii amamaaju.” ");
INSERT INTO ksr_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kaeŋ ijoro Jiisasnoŋ meleema muŋ jero, “Yei, balombaa ejemba yaŋgiseŋ ano iriŋqiriŋgiawo, niinoŋ mono kambaŋ dawi oŋowo laligoŋ qatoŋ uŋuwe Anutu mende moma laarigi siimbobolo momakemaŋa? Meraga mono wama koi kawao.” ");
INSERT INTO ksr_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mera ii wama karo kambaŋ iikanoŋ kaaŋagadeeŋ omenoŋ mera utugoŋ orogoŋ muro wolaza hororo. Kaeŋ kolooroto, Jiisasnoŋ ome ii jeŋ muro mesaoro mera meŋ qeaŋgoŋ maŋa muro. ");
INSERT INTO ksr_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Anutuwaa ku-usuŋa somatanoŋ kaeŋ asugiro kuuyanoŋ ii iima newogia tegoro waliŋgogi. Kiaŋ. Jiisasnoŋ iwoi kuuya ii meroti, iikawaajoŋ ejemba kuuyanoŋ waliŋgogi Jiisasnoŋ kambaŋ iikanoŋ gowokouruta qaa kota kokaeŋ iŋijoro, ");
INSERT INTO ksr_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Qaa koi mono geja ama mobu: Anutunoŋ Siwe gomambaa Eja hoŋa ii baloŋ ejemba sisiwerowerogiawo yoŋoo borogianoŋ ama muro kemebaa.” ");
INSERT INTO ksr_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Qaa kota ii iŋijoroto, ii mende moma kotogi. Anutunoŋ ii koma tururo aasaŋgoyanoŋ ero ii mende moma asarigi ano kania nomaeŋ, ii qisiwombaajoŋ kokodunduŋ aŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Gowoko nonoonoŋga ‘Moronoŋ uuta kolooja?’ jeŋ qaa ii romoŋgogi. ");
INSERT INTO ksr_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ii romoŋgogito, Jiisasnoŋ uuroromoŋgogia moma kotoŋ naamade melaa moŋ meŋ kooroŋanoŋ ano nano. ");
INSERT INTO ksr_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nano kokaeŋ iŋijoro, “Kuuya oŋoonoŋga moŋnoŋ kamaaŋqeqeta konoga kolooji, iinoŋ mono uuta kolooja. Kawaajoŋ moŋnoŋ naamade koi noo qananoŋ mirianoŋ koma horoŋ kalaŋ kombaati, iinoŋ mono nii koma horoŋ nombaa. Moŋnoŋ nii koma horoŋ nombaati, iinoŋ wasiŋ nonoti, mono ii kaaŋagadeeŋ koma horoŋ mubaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Kambaŋ kanoŋ Jonoŋ kanaiŋ qaa kokaeŋ ijoro, “Somatana, eja moŋnoŋ goo qanoŋ omejiilaŋ konjoma oŋono iiniŋ. Iinoŋ nonowo mende liligoŋ laligojiwaajoŋ nono ii qotogoŋ muniŋ.” ");
INSERT INTO ksr_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kaeŋ ijoroto, Jiisasnoŋ kokaeŋ ijoro, “Ii mende qotogoŋ mubu. Moŋnoŋ mende qotogoŋ oŋomakeji, iinoŋ mono oŋoaŋgiaa areŋnoŋ laligoja. (Kawaajoŋ oŋo mono noo alauruna tosaaŋa ii aŋgosisiri meŋ oŋombubo.)” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jiisasnoŋ Siwenoŋ umambaajoŋ ano. Kawaa kambaŋa torijiwaajoŋ Jiisasnoŋ nama “Jerusalem sitinoŋ kemaŋa,” jeŋ jeŋ kotiiŋ kanaiŋ kananoŋ keno. ");
INSERT INTO ksr_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kema qele waladeeŋ ano wala keŋgi. Kananoŋ kema laligoŋ Samaria prowinswaa gomaŋ moŋnoŋ keuma “Jiisas kawaatiwaajoŋ mozoqozojoŋ amboŋatiwaajoŋ kajoŋ,” jegi. ");
INSERT INTO ksr_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jegito, Samaria yoŋonoŋ Juuda ano Jerusalem jejewili ama oŋomakegitiwaajoŋ Jiisasnoŋ “Nii Judia prowinsnoŋ Jerusalem jigo waageŋ kemaŋa,” jerotiwaajoŋ miri aŋgoŋ koma yeizozogia mende iŋijogi. ");
INSERT INTO ksr_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kaeŋ aŋgi gowokowoita Jeims ano Jon yoronoŋ ii iima jeri, “Oo Poŋ, sombinoŋga gere kamaaŋ oŋooro qaombuyaga, kaeŋ qama kooliwombaajoŋ mojaŋ me qaago?” ");
INSERT INTO ksr_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kaeŋ jerito, Jiisasnoŋ eleema temboma jeŋ orono. ");
INSERT INTO ksr_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kanoŋa toroqeŋ gomaŋ moŋnoŋ keŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kananoŋ keŋgi eja moŋnoŋ kaŋ Jiisas ijoro, “Gii daeŋ daeŋ kembaati, niinoŋ mono iikanoŋ gii gotaaŋ kamaŋa.” ");
INSERT INTO ksr_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ii moma Jiisasnoŋ kokaeŋ ijoro, “Duuyaa kasu yoŋonoŋ jamo diiŋgianoŋ egi kanakeewaŋ kooŋ yoŋonoŋ haigia meŋ laligoŋkejuto, Siwe gomambaa Eja hoŋanoŋ mono daeŋgeŋ kema waŋa naa qembonoŋ laariŋ haamo menaga?” ");
INSERT INTO ksr_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jiisasnoŋ eja mombaajoŋ ijoro, “Gii mono kaŋ nii notaawa.” Ijoroto, kokaeŋ meleeno, “Poŋ, ii saanonto, maŋnanoŋ komumambaajoŋ anja. Kawaajoŋ mono wala jena kema galeŋ kombe komuro roŋ kombego.” ");
INSERT INTO ksr_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Kaeŋ meleenoto, Jiisasnoŋ qaaya meleema ijoro, “Mesaowa! Koomuya yoŋonoŋ qamogia koomuya ii saanoŋ roŋ kombuto, giinoŋ mono kema Anutu bentotombaa kania jeŋ asariŋ oŋoma laligowa.” ");
INSERT INTO ksr_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mombo eja moŋnoŋ kouma ijoro, “Poŋ, niinoŋ gii gotaamambaa siiŋa mojento, moba, gii saanoŋ jena wala mirinoŋ kema tinitosauruna yeizozogia jewego.” ");
INSERT INTO ksr_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ijoroto, Jiisasnoŋ meleeno, “Moŋnoŋ baloŋ meenjaŋgowaa kinoŋ ii hoos gematanoŋ somoŋgoŋ borianoŋ kinoŋ maayanoŋ meŋ nano keno mombo eleema gematanoŋ uuji, iinoŋ mono Anutuwaa bentotonoŋ keuma gawoŋa mewaatiwaa so mende kolooja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kawaa gematanoŋ Poŋnoŋ gowoko tosaaŋa 72 ii meweeŋgoŋ oŋono. Aŋo “Taoŋa taoŋa gomaŋa gomaŋa kemaŋa,” jeŋ kanoŋ woi woi metogoŋ wala wasiŋ oŋono. ");
INSERT INTO ksr_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","“Wasiŋ oŋomaŋa,” jeŋ kokaeŋ iŋijoro mogi, “Anutuwaa gawonoŋ nene hoŋa mamaga momogoŋ ejato, ii meŋ kululuuwombaajoŋ gawoŋ meme ejemba anana afaaŋanoŋ laligojoŋ. Kawaajoŋ mono nene hoŋa masuqeqetaa Poŋa qama kooliŋ mugi gawoŋ meme ejemba wasiŋ oŋono hoŋa meŋ kululuuwu. ");
INSERT INTO ksr_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Oŋo mono kembu. Mobu, lama yoŋonoŋ duuyaa kasu kawalia yoŋoo batugianoŋ kemegi luguŋ iŋiwuboti, niinoŋ oŋo iikawaa tani kaaŋa wasiŋ oŋombe kembu. ");
INSERT INTO ksr_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Oŋo moneŋ irimuŋ kasa me geso moŋ me kana esu ii mende meŋ kembu. Kema kananoŋ ejemba iŋiima jeŋkelekele ama yeizozogia mende jewu. ");
INSERT INTO ksr_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Kema miri moŋnoŋ uma wala kokaeŋ iŋijowu, ‘Anutunoŋ mono miri koi kanoŋ luae qero bonjoŋ laligowu.’ ");
INSERT INTO ksr_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kaeŋ jegi moŋnoŋ luae aŋgoŋ komambaa so kolooji eeŋ, luaegianoŋ mono iwaa qaganoŋ ubaato, moŋnoŋ ii mende aŋgoŋ kombaati eeŋ, luaegianoŋ mono eleema oŋoaŋgiaa qagianoŋ ubaa. ");
INSERT INTO ksr_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Miri ubuti, mono iikanondeeŋ laligoŋ gawoŋ mewu. Ejembanoŋ gawoŋ meme ejemba laaligogia naŋgowutiwaa so kolooju. Kawaajoŋ yoŋonoŋ nene ano apu oŋombuti, ii mono newu. Miri tosianoŋ lansaŋ mende ewu. Miri sueŋ mende kema kawu. ");
INSERT INTO ksr_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Taoŋ iikanoŋ me iikanoŋ keugi koma horoŋ nene oŋombuti, ii mono newu. ");
INSERT INTO ksr_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Neŋ tosianoŋ kanoŋ ji iŋiro ewuti, ii mono meŋ qeaŋgoŋ oŋombu. Kaeŋ ama kokaeŋ jegi mobu, ‘Anutuwaa bentotoŋanoŋ mono kosere karo iikawaa uutanoŋ keubu.’ ");
INSERT INTO ksr_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kaeŋ ambuto, taoŋ moŋnoŋ keugi gema uŋuwuti, iikanoŋ mono maaketnoŋ me sombenoŋ kema kokaeŋ jegi mobu, ");
INSERT INTO ksr_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nono oŋoo taonoŋ kaniŋ sububuŋ iwoi kana tambonananoŋ mokotaaji, ii mono riiŋ konjoratiniŋ oŋoaŋgiaanoŋ eleema kemebaa. Kemebaato, qaa koi mono moma yagowu: Anutuwaa bentotoŋanoŋ mono kosogianoŋ asugija.’ ");
INSERT INTO ksr_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Niinoŋ kokaeŋ iŋijowe mobu: Anutunoŋ kambaŋ somatanoŋ qemasologeŋgiaa iroŋa meleeno taoŋ iikawaa qaganoŋ ubaati, so iikanoŋ mono Sodom yoŋoo siimbobolo soya uuguŋ toroqeŋ oŋombaa.” ");
INSERT INTO ksr_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Oo Korazin toya, niinoŋ oŋoojoŋ ‘Yei!’ jeŋ saajeŋ ano Betsaida toya, oŋoojoŋ kaaŋagadeeŋ ‘Yei!’ jeŋ saajeŋ. Niinoŋ yoŋoonoŋ kembe qaana jewe sosoniro aŋgoletona ku-usuŋawo asugiroto, uugia kileŋ mende meleeŋgi. Aŋgoleto ii waba balonoŋ Taia ano Saidon sitinoŋ asuginagati eeŋ, iyoŋonoŋ mono kambaŋ koriga uugia meleembombaajoŋ kaisareya qendeema resanoŋ lumu aoŋ too ariŋ saabuyaga. ");
INSERT INTO ksr_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","“Saabuyagato, Anutunoŋ kanageŋ Korazin ano Betsaida yoŋoo qaagia jeŋ tegoŋ iroŋa meleeno siimbobolo mobuti, kambaŋ somata iikanoŋ ii mono Taia ano Saidon yoŋoo siimbobolo soya uuguŋ mobuya. ");
INSERT INTO ksr_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ano Kaperneam toya, Anutunoŋ oŋo saanoŋ metaama oŋono Siwe gomanoŋ ubuyaga me qaago? Qaago totooŋ! Oŋo mono koomuwaa senjoŋ gomanoŋ kemebuya. ");
INSERT INTO ksr_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Moŋnoŋ qaagia mobaati, iinoŋ mono noo qaana mobaa. Moŋnoŋ gema uŋuwaati, iinoŋ mono nii gema nuwaato, moŋnoŋ nii gema nuwaati, iinoŋ wasiŋ nonoti, mono ii gema qewaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Gowoko 72 yoŋonoŋ laligoŋ eleema kaŋ aisooŋ kokaeŋ jegi, “Poŋ, nono goo qaganoŋ omejiilaŋ jeŋ kotoŋ oŋoniŋ yoŋonoŋ kaaŋagadeeŋ qaanana baatanoŋ kema togoŋ keŋgi.” ");
INSERT INTO ksr_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Kaeŋ jegi Jiisasnoŋ meleeno, “Niinoŋ Satan aagogi Siwenoŋga luguŋ oobili kaaŋa hagoŋ kemero iibe. ");
INSERT INTO ksr_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mobu, niinoŋ ku-usuŋ oŋombe oŋo saanoŋ mokoleŋ, soromaaŋ, kuaŋkuaŋ ano kerenanaa esuŋmumuya jetawo kuuya riigi kamaaro haamo ambuya. Kawaajoŋ iwoi moŋnoŋ uŋuŋ mizimizi mende mewaa. ");
INSERT INTO ksr_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","“Kawaajoŋ omejiilaŋ yoŋonoŋ qaagia baatanoŋ kenjuto, kileŋ oŋoonoŋ korisoro waŋa ii iikawaajoŋ mende aisoowu. Oŋoo qagia Siwe gomanoŋ oogi Anutuwaa buknoŋ eji, iikawaajoŋ mono honombonoŋga qaa aisoowu.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kambaŋ kanoŋ Uŋa Toroyanoŋ Jiisas inaaŋ muro aisooŋ qaa kokaeŋ jero, “Oo Amana, giinoŋ Buŋa qaaga momakooto ejemba momo somata megiti, iyoŋoonoŋ mesaŋgonato, ejemba merabora kaaŋa iyaŋgiaajoŋ mogi poumapou kolooji, ii mono ii iŋisaana moma asariju. Kawaajoŋ niinoŋ Siwe gomambaa Poŋa gii mepeseeŋ gonjeŋ. Oo Amana, gii geeŋgo kaeŋ koloowaatiwaajoŋ mona sokono awaa kolooro. ");
INSERT INTO ksr_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Amananoŋ mono iwoi kuuya jeŋ kotoro noo buŋaga kolooro. Amananoŋ meriaa kania aŋodeeŋ moma yagoro moŋnoŋ ii mende moja. Kaaŋagadeeŋ moŋnoŋ Amayaa kania mende moma yagoro Merianondeeŋ ii moja ano ejemba meweeŋgoŋ oŋoma yoŋoojoŋ ii iŋisaambaati, iyoŋonoŋ mono Ama moma mubuya.” ");
INSERT INTO ksr_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jiisasnoŋ kaeŋ jeŋ gowokouruta yoŋoonoŋ eleema iyaŋgiodeeŋ oloŋ kokaeŋ iŋijoro, “Daeŋ yoŋonoŋ oŋo iwoi iijuti, ii iima mono jaagiaajoŋ ama simbawoŋawo kolooju. ");
INSERT INTO ksr_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Iikawaa kania ii kokaeŋ: Niinoŋ qaa kokaeŋ iŋijowe mobu, Gejatootoo ejemba ano kiŋ eja poŋ mamaganoŋ oŋo iwoi koi iijuti, ii iibombaajoŋ awelegoŋ laligogito, ii mende iigi. Oŋo qaa koi mojuti, iyoŋonoŋ ii mobombaajoŋ awelegoŋ laligogito, ii mende mogi.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kana qaawaa boi moŋnoŋ waama Jiisas timbi ama kokaeŋ qisiŋ muŋ ijoro, “Boi, niinoŋ mono nomaeŋ ama laaligo kombombaŋa tetegoya qaa buŋa qeŋ aowenaga?” ");
INSERT INTO ksr_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ijoro Jiisasnoŋ kokaeŋ meleema qisiro, “Mooseswaa Kana qaanoŋ qaa nomaeŋ oogita eja? Iikawaa kania ii nomaeŋ?” ");
INSERT INTO ksr_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Qisiro meleema jero, “‘Gii uugabaga, uŋaga, ku-usuŋga ano roromoŋgoga jumuŋa iikanoŋ mono Poŋ Anutuga jopagoŋ laligowa,’ ano ‘Geeŋga jopagoŋ aoŋkejaŋi, iikaaŋiadeeŋ mono ejemba kuuya jopagoŋ oŋoma laligowa’.” ");
INSERT INTO ksr_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jero Jiisasnoŋ meleeno, “Dindiŋa meleenjaŋ. Ii teŋ koma laaligo kombombaŋaa buŋa koloowaga.” ");
INSERT INTO ksr_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kaeŋ meleenoto, Kana qaawaa boinoŋ ‘Ii teŋ koma solaŋa koloojeŋ,’ kaeŋ romoŋgoŋ kaniaya qendeemambaajoŋ moma Jiisas ijoro, “Ejemba batugianoŋ laligoŋ koubeti, iyoŋoonoŋa mono morowaajoŋ jejaŋ? Nii mono moroga mende jopagoŋ mubenaga?” ");
INSERT INTO ksr_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Kaeŋ jero Jiisasnoŋ meleema jero, “Eja moŋnoŋ Jerusalem siti mesaoŋ Jeriko gomanoŋ kemeŋ kananoŋ kikekakasililiŋ yoŋoo borogianoŋ kemero megi. Meŋ hina iwoiya wama opoya qetegoŋ gbilibuuruŋ qeŋ giliŋ keŋgi komumambaajoŋ ama ero. ");
INSERT INTO ksr_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Eŋ mambono jigo gawoŋ galeŋ moŋnoŋ kana iikayadeeŋ kema iima iima sisiriiŋ kana leegeŋga kema uuguŋ keno. ");
INSERT INTO ksr_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Keno mambono jigo gawoŋ eja (Liwait) moŋnoŋ iikanoŋ kouma iima kaaŋiadeeŋ iima sisiriiŋ uuguŋ keno. ");
INSERT INTO ksr_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kenoto, Samaria prowinswaa eja moŋnoŋ kana iikayadeeŋ kema eroti, iikanoŋ keuma iima wosoya moma iima kobooro. ");
INSERT INTO ksr_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","“Iima kobooŋ kosianoŋ kemeŋ wijia kele ano wain apuyanoŋ moriŋ esuuro. Wijia esuuŋ meŋ kobibiiŋ doŋgiya qaganoŋ ama wama qenjaaro ee mirinoŋ kema ama kalaŋ koma muro. ");
INSERT INTO ksr_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kalaŋ koma muŋ eŋ waama umugawodeeŋ weeŋ woiwaa tawaya (Kina 20) unjuma qenjaaro miriwaa toya muŋ ijoro, ‘Eja koi mono kalaŋ koma muŋ laligona moneŋ gonjeŋi, ii mende sokoma uuguwaati eeŋ, ii mono eleema kaŋ kanoŋ toroqeŋ gomaŋa.’ ");
INSERT INTO ksr_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Eja karooŋ kaniagia kaeŋ qendeeŋgi. Eja kikekakasililiŋ yoŋoo borogianoŋ kemeroti, iwaa alia moronoŋ kolooro? Yoŋoonoŋga morowaajoŋ mona, ii uukaleŋ muro?” ");
INSERT INTO ksr_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Qisiŋ muro meleeno, “Kiaŋkomuŋ muroti, iinoŋ.” Kiaŋ meleeno Jiisasnoŋ ijoro moro, “Gii mono kema kaaŋiadeeŋ ama laligowa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jiisasnoŋ gowokouruta yoŋowo kananoŋ keŋgi Poŋgianoŋ gomaŋ moŋnoŋ keuro. Keuro emba moŋ qata Marta iinoŋ koma horoŋ muro mirianoŋ uro. ");
INSERT INTO ksr_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martawaa koga qata Maria laligoro. Iinoŋ Poŋ iima kosianoŋ kamaaŋ rama Buŋa qaa jeroti, ii geja ama awutambaŋa koma moro. ");
INSERT INTO ksr_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Moroto, Martanoŋ lombaŋ gawonoŋ hororo kema kaŋ amaqamamaa ama Jiisaswaajoŋ ijoro, “Poŋ, konanoŋ nomesaoro neenodeeŋ weleŋ gawoŋ mewe mona sokonja me qaago? Kawaajoŋ mono Maria jena kaŋ ilaaŋ nomba.” ");
INSERT INTO ksr_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ijoro Poŋnoŋ meleema ijoro, “Marta Marta, gii iwoi kania kania kawaajoŋ majakaka ano motoqoto moma koroboro laligoŋ geriawo ama nanjaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kaeŋ nanjanto, majakaka motooŋgo moŋ meŋ meŋ kotiiniŋ sokombaa. Nono iwoi seiseiya kawaajoŋ mende amamaajoŋ. Marianoŋ gosiŋ uuwaa teeya meagoŋ aomambaajoŋ meweeŋgoŋ simbawoŋawo kolooja. Laaligowaa bakaya awaa ii moŋnoŋ moŋ mende wambaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jiisasnoŋ gomaŋ moŋnoŋ qama kooliŋ laligoro tegoro gowokouruta yoŋoonoŋga moŋnoŋ kokaeŋ ijoro, “Poŋ, Jon Oomulu ejanoŋ gowokouruta qamakooliwaa kania kuma oŋonoti, gii mono kaaŋiadeeŋ nono kuma nonomba.” ");
INSERT INTO ksr_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ijoro Jiisasnoŋ kokaeŋ iŋijoro, “Oŋo mono qama kooliwonjeŋ kokaeŋ jewu: Ama, geeŋgaa qaganoŋ mono toroya ewa. Mono galeŋ koma nonona bentotoŋgaa hoŋa koloowa. (Goo uusiiŋga Siwenoŋ teŋ komakejuti, ii mono namonoŋ kaaŋagadeeŋ koloowa.) ");
INSERT INTO ksr_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gii mono weeŋ so nembanene sonananoŋ nonomba. ");
INSERT INTO ksr_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tosianoŋ siŋgisoŋgo ama nonoŋgiti, nono kuuya iyoŋoo siŋgisoŋgogia ii mesaojoŋi eeŋ, gii mono iikawaa so nonoonoŋ siŋgisoŋgo soŋgbama nonomba. Aŋgobatonoŋ kamaaŋ nunuwabotiwaajoŋ mono aŋgoŋ koma nonoma Kileŋaa Toyaa borianoŋga metogoŋ nonomba.” ");
INSERT INTO ksr_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jiisasnoŋ toroqeŋ kokaeŋ iŋijoro, “Oŋoonoŋga moŋnoŋ gomantiiŋaa ruuŋanoŋ aliaa mirinoŋ kema mindiiŋ kokaeŋ ijowaa, ‘Alana, bered karooŋ nona kitia era meleema gomaŋa. ");
INSERT INTO ksr_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Alana moŋnoŋ kananoŋ laligoŋ noonoŋ kouro nenena qaagotiwaajoŋ wagimambaajoŋ moŋganjeŋ.’ ");
INSERT INTO ksr_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kaeŋ ijoro alianoŋ miri uutanoŋga kokaeŋ meleema ijowaa, ‘Gii gaoŋ gbili qeŋ nononjaŋ. Nii nagu koma qaqaŋ suluwe meraboraurunanoŋ niwo tambomaeenana tamboma gaoŋ ejoŋ. Kawaajoŋ waama ii gomambaajoŋ amamaajeŋ.’ ");
INSERT INTO ksr_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kaeŋ jewaato, niinoŋ iŋijowe mobu: Miri toyanoŋ alia koloojiwaajoŋ ama mende waama mubaato, ii kileŋ kaparaŋ koma jeŋ nanjiwaajoŋ ii saanoŋ waama qisijiwaa so kuuya mubaa. ");
INSERT INTO ksr_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Niinoŋ iikawaa bakaya ii kokaeŋ iŋijowe mobu: Mono Anutu qama kooliwu. Qama kooligi iwoi oŋombaa. Anutuwaanoŋ mono iwoiwaa borojaŋ meŋ moŋgambu. Ii moŋgaŋgi qendeeno mokoloowuya. Nama nagunoŋ qewu. Qegi nagu tama oŋombaa. ");
INSERT INTO ksr_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Moŋnoŋ Anutu qama kooliŋkeji, iinoŋ mono iikawaa kitia buŋa qeŋ aowaa. Iwoiwaa moŋgamakeji, iinoŋ mono iwoi mokoloowaa. Nagunoŋ qeŋkejiwaajoŋ mono nagu horoŋ mubaa. ");
INSERT INTO ksr_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Maŋuruna oŋoonoŋga moronoŋ kokaeŋ kolooja: Merianoŋ sorawaajoŋ qisiro kitianoŋ qato mubaa ");
INSERT INTO ksr_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","me kuru kotaajoŋ qisiro kuaŋkuaŋ mubaa? ");
INSERT INTO ksr_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kawaajoŋ oŋo ejemba bologa kolooju ano kileŋ kaleŋ awaa awaa ii meraboraurugia oŋombombaajoŋ mojuti eeŋ, Siwe Maŋnananoŋ mono kaleŋa nomaeŋ aŋgoŋ konaga? Iwaa uutaa nanamemeŋa ii nunuuguŋ qaita moŋ kolooja. Kawaajoŋ Uŋa Toroyaajoŋ qama kooliŋ qisiŋ mubuti eeŋ, iinoŋ mono siiŋanoŋ Uŋa ii wasiro uugianoŋ kemebaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Omenoŋ eja moŋ qaamuuŋ meŋ muro moto laligoro Jiisasnoŋ omeya ii otaaro kouma keno neselaŋa lolooro mombo qaa jero. Qaa jero ejemba tuuŋ yoŋonoŋ ii iima waliŋgogi. ");
INSERT INTO ksr_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Waliŋgogito, yoŋoonoŋga tosianoŋ kokaeŋ jegi, “Iinoŋ mono omejiilaŋ yoŋoo poŋgia Iimolaŋ iwaa ku-usunoŋ ome oŋotaaŋkeja.” ");
INSERT INTO ksr_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kaeŋ jegi tosianoŋ Jiisas qaawaa timbinoŋ horowombaajoŋ iijoŋgoŋ kokaeŋ qisigi, “Gii mono jeŋ kotona sombinoŋga aŋgoleto moŋ asugiro iiboŋa.” ");
INSERT INTO ksr_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Qisigito, iinoŋ uu roromoŋgogia modaboroŋ kokaeŋ iŋijoro, “Kantri daeŋ yoŋoo galeŋurugianoŋ batugianoŋ aŋgowowo ama jumbuti, iyoŋonoŋ mono tiwilaaŋ aogi kantrigianoŋ boliŋ saoyagadeeŋ ewaa. Kaaŋagadeeŋ miri mombaa kanageso yoŋonoŋ jumbuti, mirigianoŋ mono qeqelalaŋ ewaa. ");
INSERT INTO ksr_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","“Mobu! Satambaa kanageso yoŋonoŋ kaaŋagadeeŋ batugianoŋ aŋgowowo ama jumbuyagati eeŋ, iyoŋonoŋ mono galeŋkoŋkoŋ gawoŋgia mewombaajoŋ amamaagi ometotoŋgianoŋ mono nomaeŋ nanaga? Oŋo noojoŋ kokaeŋ jeju: Iinoŋ Iimolambaa esuŋnoŋ omejiilaŋ oŋotaaŋkeja. ");
INSERT INTO ksr_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kaeŋ jejuto, mobu, niinoŋ Iimolambaa esuŋnoŋ omejiilaŋ konjoma oŋombenagati eeŋ, oŋoo alaurugianoŋ mono morowaa esuŋnoŋ ii konjoma oŋombuyaga? Kawaajoŋ yoŋonoŋ mono qaagia hoŋa me qaago, ii gosiŋ jeŋ tegowu. ");
INSERT INTO ksr_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ii jeŋ tegowuto, Anutuwaa ku-usuŋanoŋ noo boro susuna sololooro ome oŋotaaŋkejeŋi eeŋ, Anutuwaa bentotoŋanoŋ mono oŋoonoŋ kaŋ kuuja. ");
INSERT INTO ksr_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Eja kotiga Iimolaŋ iinoŋ tiwo wasayawo gomaŋ miria agokayaŋ kono esuhinayanoŋ mono saanoŋ ewaa. ");
INSERT INTO ksr_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kaeŋ ewaato, eja kotakota totooŋ Uŋa Toroya iinoŋ luguŋ kaŋ qeŋ haamo ama muŋ tiwo wasaya qirinaaroti, ii kuuya tagoŋ esuhinaya qeŋgama meŋ kema alauruta mendeema oŋombaa. ");
INSERT INTO ksr_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Moŋnoŋ niwo mende laligoji, iinoŋ mono qetegoŋ nomakeja. Moŋnoŋ ejemba noo qananoŋ ajoroowutiwaajoŋ mende horoŋ oŋomakeji, iinoŋ mono mendeema oŋomakeja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Omenoŋ eja uutanoŋga kouma baloŋ qararaŋkoŋkoŋanoŋ kema laŋ liligoŋ laligoŋ haamo memambaajoŋ miri moŋgama moŋ mende mokolooŋ mojoya tiiro kokaeŋ jewaa, ‘Mirina mesaoŋ kajeŋi, iikanoŋ mono mombo eleemaŋa.’ ");
INSERT INTO ksr_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kaeŋ jeŋ eleema miria usuma menjereŋgoro eroti, ii kaaŋiadeeŋ ero mokoloowaa. ");
INSERT INTO ksr_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kaeŋ mokolooŋ kema omejiilaŋ tosaaŋa 7 uŋuambaa. Omejiilaŋ 7 ii iyaŋa uuguŋ bologa totooŋ kolooju. Iinoŋ ii uŋuano kaŋ miri ii uma iikawaa uutanoŋ laligowuya. Kaeŋ kolooro eja iikawaa kania wala kileŋkileŋ kolooroto, kanageŋ bolidaborowaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jiisasnoŋ qaa kaeŋ jeŋ laligoro ejemba tuuŋ batugianoŋga emba moŋnoŋ qama Jiisas kokaeŋ ijoro moro, “Kokona, embanoŋ koro ama meŋ goma aju guagiroti, niinoŋ iwaa mobe simbawoŋawo kolooja.” ");
INSERT INTO ksr_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kaeŋ ijoroto, Jiisasnoŋ kokaeŋ meleeno, “Ii jejanto, niinoŋ kokaeŋ jemaŋa: Ejemba Anutuwaa qaawaajoŋ geja ama moma teŋ koma koma gbiliŋkejuti, iyoŋonoŋ mono simbawoŋawo kolooju.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ejemba tuuŋnoŋ ajoroogi somariiro Jiisasnoŋ toroqeŋ qaa kokaeŋ jero, “Ejemba kete namonoŋ laligojuti, ii kanageso tuuŋ bologa. Yoŋonoŋ Anutuwaa aiweseyaajoŋ kaparaŋ komakejuto, aiwese moŋ gejatootoo eja Joonawaanoŋ koloodabororo. Anutunoŋ aiwese morota moŋ mende ama oŋombaa. ");
INSERT INTO ksr_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Qaa iikawaa kania ii kokaeŋ: Anutunoŋ wala eeŋanoŋ Joona wasiro Niiniwe yoŋoo batugianoŋ kema Anutuwaa aiweseya ano. Iikawaa so Siwe gomambaa Eja hoŋanoŋ kaaŋagadeeŋ ejemba tuuŋ kokawaa batugianoŋ asugiŋ uugia meleembutiwaajoŋ kuuŋ oŋoma aiwesegiaga koloowaa. ");
INSERT INTO ksr_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Kaniagiaa kaisareya moŋ ii kokaeŋ: Anutunoŋ wala eeŋanoŋ momakooto uuta somata ii kiŋ Solomon muro Saut waageŋga kantri mombaa kwiin embanoŋ Solomombaa momakootoya momambaajoŋ siiŋa moro. Siiŋa moma namo goraayanoŋga waama kana koriga tintiŋ kaŋ laligoŋ Solomombaa momoya moro. Ii moroto, mobu, kambaŋ kokaamba niinoŋ batugianoŋ asugiŋ nama Anutuwaanoŋ momakooto uuta meŋ kajeŋi, ii Solomombaa momakootoya uuguja. Uugujato, oŋo kileŋ telambelaŋ ama noma tompiŋ naŋgi mende sokonja. “Kawaajoŋ Anutunoŋ kanageŋ ejemba korebore horoŋ oŋono qaagia jeŋ tegowaatiwaajoŋ jaayanoŋ keubuti, kambaŋ iikanoŋ Saut kantriwaa kwiin emba iikanoŋ mono kaaŋagadeeŋ keubaa. Iinoŋ ejemba tuuŋ somata koi nanjuti, oŋowo ororoŋ koomunoŋga waama oŋoo kooroŋgianoŋ motooŋ nambaa. Motooŋ nama qaa kokaeŋ oŋoo selegianoŋ kuuwaa, ‘Oŋo Jiisas telambelaŋ ama mugi Anutunoŋ iroŋa meleema oŋono siimbobolo uuta mobuya.’ Iinoŋ kaeŋ iŋijoro silia gosiŋ oŋoaŋgiaajoŋ gamugia mobuya. ");
INSERT INTO ksr_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Joonanoŋ Niiniwe ejemba batugianoŋ kema Anutuwaa qaanoŋ uugia kuuro moma iikanondeeŋ uugia meleeŋgito, mobu, niinoŋ batugianoŋ asugiŋ nama Joonawaa nanamemeŋa uuguŋ amakejeŋ. Kaeŋ amakejento, oŋo kileŋ telambelaŋ ama nomakeju. Kawaajoŋ Niiniwe ejembanoŋ jenteegowaa kambaŋ somatanoŋ ejemba tuuŋ somata koi nanjuti, oŋowo ororoŋ koomunoŋga waama oŋoo kooroŋgianoŋ motooŋ nambu. Motooŋ nama Niiniwe yoŋonoŋ qaa kokaeŋ oŋoo selegianoŋ kuuwu, ‘Oŋo Siwe gomambaa Eja hoŋa telambelaŋ ama mugi Anutunoŋ iroŋa meleema oŋono siimbobolo uuta mobuya.’ Niiniwe yoŋonoŋ kaeŋ jegi nanamemeŋ-gianoŋ oŋoaŋgiaa kaniagia iŋisaaŋgi gamugia mobuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Moŋnoŋ lambe me kiwa ootiriŋ kowi waŋgoŋanoŋ me monjonoŋ mende ambaato, ii mono kawaa duŋ raranoŋ ambaa. Kaeŋ ano tosianoŋ miri uutanoŋ ubombaajoŋ mojuti, yoŋonoŋ iikawaa asasaga iima saanoŋ ubu. ");
INSERT INTO ksr_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Goo jaaga ii uu selegaa kiwaya kolooja. Kawaajoŋ ji moŋnoŋ jaaga mende meŋ boliji eeŋ, iikanoŋ mono tooŋ asaridabororo Anutuwaa asasaganoŋ saanoŋ uuganoŋ meŋ asariro laaligoga kuuya asasaganoŋ laligowaa. Asasaganoŋ laligowaato, siiŋ kombombaŋa bologanoŋ me iwoi moŋnoŋ jaaga meŋ boliŋ asasaga kojaŋgiji eeŋ, iikanoŋ selewaa laaligoga kaaŋagadeeŋ meŋ tiiro paŋgamaŋ uutanoŋ tiŋtuaŋ laligowaa. ");
INSERT INTO ksr_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","“Kaeŋ kolooro moba, paŋgamanoŋ uugaa asasaga kojaŋgiro tiiwabotiwaajoŋ mono tooga moma galeŋ meŋ aowa. ");
INSERT INTO ksr_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kaeŋ ana Anutuwaa asasaganoŋ uuga kuuya sokono waŋgoŋa moŋ mende tiiji eeŋ, goo seleganoŋ mono kaaŋagadeeŋ asombilibiliawo kolooŋ jaasewaŋganoŋ asarija. Kiwa somatanoŋ seleganoŋ kuuŋ kokobilibiliawo meŋ asariŋ gonji, laaligoga mono iikawaa so Anutuwaa asasaganoŋ andaboroŋ laligowaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jiisasnoŋ qaa ii jedabororo Farisii (Kana qaawaa kaparaŋ-koŋkoŋ) eja moŋnoŋ kokaeŋ jeŋ koma horoŋ muro, “Gii saanoŋ noo mirinoŋ uma rama nene newoŋa.” Kaeŋ jero kema uma nene nemambaajoŋ raro. ");
INSERT INTO ksr_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Wala boria mende soŋgbama kamaaŋ raroto, Farisii ejanoŋ sili ii iima waliŋgoro. ");
INSERT INTO ksr_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Waliŋgoro Poŋnoŋ kokaeŋ ijoro, “Oo Farisii oŋo mono oŋanoŋ hamo qeŋ aowombaajoŋ qambi ano amanenewaa selia soŋgbama yagoŋkejuto, oŋoaŋgiaa uugianoŋ mono tilooja. Ii mono dogo, otoko ano nepaqepalo iikanoŋ saa qero laligoju. ");
INSERT INTO ksr_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","“Oo oŋo, uugia qaa. Moŋnoŋ selia kuuya mokolooroti, iinoŋ mono uuta kaaŋagadeeŋ mokolooro me qaago? Oŋo mono naambaajoŋ uugiaa gawombaajoŋ ataqataŋ anju? Ii mende sokonja. ");
INSERT INTO ksr_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kawaajoŋ iwoi qambi, amanenenoŋ raji, ii mono kaleŋgia ejemba wanaya oŋombu. Kaeŋ aŋgi Anutunoŋ hamo qeŋ oŋono oŋoonoŋ iwoi kuuya mono soraaya ewaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Oo Farisii ejemba, lombo qagianoŋ ubaatiwaajoŋ mono qama wanjinjiŋgoŋ ‘Yei!’ jejeŋ. Oŋo nembanene kuuya mendeema bakaya 10:noŋga motooŋgo Anutuwaa buŋa qeŋkeju. Daŋe, supe ano logoya kania kania ii kaaŋagadeeŋ mendeema tenoŋga motooŋgo ii Anutuwaa buŋa qeŋkeju. Nanduŋ ii tororo amakejuto, Kana qaawaa kota waŋa koi mono uuguŋ mesaoŋkeju: Gii Anutu uu konoŋganoŋ jopagoŋ muŋkeba ano ejemba batugianoŋ nanamemeŋ dindiŋa otaaŋ laligowa. Qaa waŋa ii mono kaparaŋ koma otaaŋ laligowu ano qaa melamelaa ii kaaŋagadeeŋ mende uuguŋ mesaowu. ");
INSERT INTO ksr_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Oo Farisii, lombo qagianoŋ ubaatiwaajoŋ mono qama wanjinjiŋgoŋ ‘Yei!’ jejeŋ. Oŋo qamakooli mirinoŋ duŋ rara mutuyanoŋ jegeŋjegeŋ rabombaa siiŋa momakeju. Maaketnoŋ me kananoŋ ejemba iŋiigi joloŋgia jewutiwaajoŋ momakeju. ");
INSERT INTO ksr_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Oo oŋo, lombo qagianoŋ ubaatiwaajoŋ qama wanjinjiŋgoŋ ‘Yei!’ jejeŋ. Oŋo qasiri qagia qaa iikawaa so kolooju. Ejembanoŋ qamo moroŋawo dakanoŋ eji, ii mende moma qagianoŋ lansaŋ riiŋ iwoi doŋqiziziŋawo oosiriŋ tilooŋkeju.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jiisasnoŋ qaa kaeŋ jero Kana qaawaa boi yoŋoonoŋga moŋnoŋ moma meleema kokaeŋ ijoro, “Boi, gii qaa kaeŋ jeŋ nono kaaŋagadeeŋ gamu qeŋ nononjaŋ.” ");
INSERT INTO ksr_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kaeŋ jeroto, Jiisasnoŋ qaa kokaeŋ jero, “Oo Kana qaawaa boi, oŋoo qagianoŋ kaaŋagadeeŋ lombo ubaatiwaajoŋ qama wanjinjiŋgoŋ ‘Yei!’ jejeŋ. Oŋo qaawaa qaa jeŋ kotoŋ iikawaa qaqaŋ lombotawo ii ejemba qagianoŋ amago ama aŋgi ii aŋgowombaajoŋ bimooŋ oŋono aoŋoroŋkejuto, oŋoaŋgio ii boro susugianoŋ boroŋa moŋ ilaaŋ oŋombombaajoŋ wosomomogia moŋ mende eŋkeja. ");
INSERT INTO ksr_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Oo oŋo, lombo qagianoŋ ubaatiwaajoŋ mono qama wanjinjiŋgoŋ ‘Yei!’ jejeŋ. Oŋo gejatootoo ejemba yoŋoo qasirinoŋ simeŋ kuuŋ meŋ menjereŋgoŋkejuto, oŋoaŋgiaa ambosakoŋuru-gianoŋ mono ii uŋugi komugi. ");
INSERT INTO ksr_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Oŋoaŋgiaa ambosakoŋurugianoŋ gejatootoo ejemba uŋugi komugi oŋonoŋ iyoŋoo qasirigianoŋ kuuŋ meŋ simeŋ meŋkeju. Kaeŋ meŋ iikanoŋ ambosakoŋurugia yoŋoo nanamemembaajoŋ wambelaaŋ qaagia naŋgoŋ jeŋ daŋgunu kaaŋa nanju. ");
INSERT INTO ksr_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Kawaajoŋ Anutu, momakooto Toya iinoŋ kokaeŋ jeja, ‘Niinoŋ gejatootoo ejemba ano aposol wasiŋ oŋombe oŋoonoŋ kawuya. Kagi iyoŋoonoŋga tosaaŋa ii uŋugi komuwuya ano tosaaŋa sisiwerowero ama oŋombuya.’ ");
INSERT INTO ksr_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Anutunoŋ Siwe namo mokolooŋ oronoti, kambaŋ iikanoŋadeeŋ kanaiŋ gejatootoo ejemba uŋugi sagia molaagi kamaaroti, iikawaa sa iroŋa kuuya ii ejemba kete laligojuti, mono oŋoo qagianoŋ uro siimbobolo mobuya. ");
INSERT INTO ksr_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Aabelwaa sayanoŋ kamaaro iikanoŋadeeŋ kanaiŋ uŋuŋ kouma laligoŋ Zekaraia siimoloŋ alata ano jiwowoŋ jigo kowoga yoroo batugaranoŋ qegi saya kamaaro iikanoŋ tegoro. Niinoŋ qaa kokaeŋ iŋijowe mobu: Sagiaa iroŋanoŋ mono ejemba kete laligojuti, oŋoo qagianoŋ uro siimbobolo mobuya. ");
INSERT INTO ksr_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Oo Kana qaawaa boi oŋo, lombo qagianoŋ ubaatiwaajoŋ mono qama wanjinjiŋgoŋ ‘Yei!’ jejeŋ. Oŋo Anutuwaa momo mewombaa nagu kii meria ii ejemba uŋuama aŋgoŋ koma oŋomakeju. Oŋoaŋgio iikawaa uutanoŋ mende keugi ano tosianoŋ iikawaa uutanoŋ keubombaajoŋ anjuti, oŋonoŋ ii somoŋgoŋ aŋgoŋ koma oŋoma laligogi.” ");
INSERT INTO ksr_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jiisasnoŋ qaa kaeŋ jeŋ mesaoŋ keno Kana qaawaa boi ano Farisii yoŋonoŋ kanaiŋ qaa geriawo jeŋ muŋ qaa kania kania jewaatiwaajoŋ mamaga qisiŋ mugi. ");
INSERT INTO ksr_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Qisiŋ mugi buutanoŋga qaa moŋ qiwitigoro iikanoŋ kokosiiro qaawaa timbinoŋ horowombaajoŋ emboŋgi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jiisasnoŋ qaaya jero kambaŋ biiwianoŋ kanoŋ ejemba tauseŋa tauseŋa iwaanoŋ ajorooŋ oloqologoŋ utaqutama aoŋ naŋgi. Kaeŋ ama naŋgi kanaiŋ gowokouruta kokaeŋ iŋijoro, “Iwoi jegeŋa koi: Oŋo mono Farisii (Kana qaawaa kaparaŋkoŋkoŋ) yoŋoo uumeleembaa selesele nanamemeŋgiaajoŋ galeŋgia mewu. Ii wosokonduŋ kaaŋa kolooja. Ii mende mesaowuti eeŋ, iikanoŋ mono yiist kaaŋa somariiŋ meŋ boliŋ oŋombaa. ");
INSERT INTO ksr_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","“Ejembanoŋ iwoi unuŋ megi eji, ii kuuya mono kotuŋgi asuganoŋ koloowaa. Kaaŋiadeeŋ qaa mesaŋgogi eji, ii kuuya mono iŋisaaŋgi moma kotowuya. ");
INSERT INTO ksr_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kawaajoŋ oŋo mono qaagiaajoŋ galeŋ meŋ aoŋ laligowu. Oŋo qaa paŋgamanoŋ oloŋ jewuti, ii mono asasaganoŋ jegi mobu. Oŋo miri uutanoŋ waŋgoŋa moŋgeŋ saŋenoŋ gejagianoŋ jewuti, ii mono sombenoŋ asuganoŋ jeŋ asariwu.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Alauruna niinoŋ oŋo kokaeŋ iŋijowe mobu: Tosianoŋ selegia qeŋ komuŋ iikawaa gematanoŋ iwoi moŋ toroqeŋ ambombaajoŋ amamaawuti, iyoŋoojoŋ mono toroko mende moma laligowu. ");
INSERT INTO ksr_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ii qaagoto, morowaajoŋ toroko mogi sokombaati, niinoŋ ii qendeema oŋomaŋa. Moŋ moronoŋ ku-usuŋ meŋ uŋuro komugi riitama oŋono gere sianoŋ kemebuti, iwaajoŋ mono toroko moma laligowu. Oŋoojoŋ qaa ii mombo jejeŋ: Iwaajoŋ mono toroko moma laligowu. ");
INSERT INTO ksr_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Tosianoŋ (arioŋ, wilisi) 5 ii toiya woinoŋ sewaŋa mewutiwaajoŋ amakejuto, Anutunoŋ iyoŋoonoŋga motooŋgowaajoŋ mende duduuro. ");
INSERT INTO ksr_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Anutunoŋ kalaŋ koma oŋoma waŋ jugia kuuya kaaŋagadeeŋ weeŋgodaboroŋ jaŋgogia moja. Ejemba oŋoo sewaŋgia ii wilisi mamaga uŋuuguŋ uuta kolooja. Kawaajoŋ toroko mono mende moma laligowu.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Niinoŋ qaa moŋ iŋijowe mobu: Moŋnoŋ nii ejemba jaagianoŋ jokolooŋ nombaati, Siwe gomambaa Eja hoŋanoŋ mono kaaŋiadeeŋ ii Anutuwaa gajobauruta yoŋoo jaagianoŋ jokoloowaa. ");
INSERT INTO ksr_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kaento, moŋnoŋ nii ejemba jaagianoŋ qakooma nombaati, niinoŋ mono kaaŋiadeeŋ ii Anutuwaa gajobauruta yoŋoo jaagianoŋ qakoomaŋa. ");
INSERT INTO ksr_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Moŋnoŋ Siwe gomambaa Eja hoŋa qetama qaa jewaati, Anutunoŋ siŋgisoŋgoya ii saanoŋ mesaowaato, moŋnoŋ Uŋa Toroya mepaegowaati, iwaa siŋgisoŋgoya ii Anutunoŋ mende mesaowaa. ");
INSERT INTO ksr_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ejembanoŋ oŋo horoŋ qaa jakegianoŋ oŋooŋgi qamakooli mirigianoŋ me kiap gawana ano kantria kantria yoŋoo eja poŋ yoŋoo jaanoŋ nambuti, kambaŋ iikanoŋ qaagiaa kitia naa qaaga nomaeŋ meleema jewoŋati, iikawaa majakakaya mono mende mobu. ");
INSERT INTO ksr_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ii kokaembaajoŋ: Oŋo qaa jewuti, ii Uŋa Toroyanoŋ aua iikanondeeŋ kuma oŋono jewuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ejemba tuuŋ batugianoŋga eja moŋnoŋ Jiisaswaa jero, “Boi, maŋnaranoŋ komuro gii mono danaa jena maŋnaraanoŋ borosamoya mendeema nomba.” ");
INSERT INTO ksr_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Kaeŋ jeroto, Jiisasnoŋ kokaeŋ meleema muro, “Oo eja, moronoŋ oroo jenteego togara koloomambaajoŋ kuuŋ nonota baloŋgara mendeembenaga?” ");
INSERT INTO ksr_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kaeŋ jeŋ qaa kokaeŋ toroqero, “Esuhina tiwomalekugianoŋ afaaŋagadeeŋ me kelemaleleŋ enagati eeŋ, kileŋ laaligogiaa kania ii iikanoŋ mende eja. Laaligogia mende gosiŋ moneŋ esuhinanoŋ mondowuti eeŋ, mono tiwilaawu. Kawaajoŋ meŋgo mewombaa otoko (greed) kuuyawaajoŋ mono galeŋgia meŋ laligowu.” ");
INSERT INTO ksr_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kaeŋ jeŋ sareqaa moŋ kokaeŋ iŋijoro, “Eja qaqabuŋayawo moŋ laligoro. Iinoŋ baloŋanoŋ nene gawoŋa mero toomoriaŋ somata kolooro. ");
INSERT INTO ksr_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ii kolooro uutanoŋ kokaeŋ romoŋgoŋ jero, ‘Noo kowi mirina ii melaada. Kawaajoŋ dumuŋ gesoya gesoya, amu tuuŋa tuuŋa, yagoŋ boraŋa boraŋa ii mono dakanoŋ meŋ kululuuwenaga? Mono nomaeŋ amaŋamaeŋ?’ ");
INSERT INTO ksr_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kaeŋ jeŋ jero, ‘Mono kokaeŋ amaŋa: Nii kowi mirina kondeema kitianoŋ kowi miri somasomata memaŋa. Ii meŋ nene toomoriana ano esuhinana kuuya mono iikanoŋ meŋ kululuuwe rabaa. ");
INSERT INTO ksr_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kanoŋ raro neenaajoŋ kokaeŋ jemaŋa: Oo gii simbawoŋawo! Toomoriaŋga mono afaaŋa qaa eŋ gonja. Kawaajoŋ mono nene neŋ aisooŋ gbania gbania siiseweweya qaa haamo meŋ osoŋ laligowa.’ ");
INSERT INTO ksr_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kaeŋ jeroto, Anutunoŋ kokaeŋ ijoro moro, ‘Oo gii, uuga qaa! Niinoŋ kambaŋga ama jeŋ tegoŋ uŋa kokoosoga gomantiiŋa kokanoŋ guambe komuwaga. Komuna ilawoila kuuya buŋa qeŋ aoŋ laligonati, ii mono morowaa buŋaya koloowaamaeŋ?’ ");
INSERT INTO ksr_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Moŋnoŋ iyaŋaajoŋ tiwomaleku maa suaŋ iwoi meŋ kululuuŋkejato, Anutuwaa kooroŋanoŋ uuwaa toomoriaŋa mende eŋ muji, iwaajoŋ mono lombo somata kaeŋ koloowaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jiisasnoŋ gowokouruta kokaeŋ iŋijoro, “Kaeŋ koloowaato, niinoŋ oŋo kokaeŋ iŋijowe mobu: Oŋo balonoŋ laligowutiwaa majakakaya ii kokaeŋ jeŋ mende mobu: Nono mono naa iwoiga meŋ newonaga ano naa iwoinoŋ selenana esuuwonaga? ");
INSERT INTO ksr_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Selegiawo laligojuti, iikanoŋ iwoi hoŋa kolooro opo selekopaanoŋ mono iikawaa qereweŋa kolooja. Jaagiawo laligojuti, iikanoŋ iwoi hoŋa kolooro nenenoŋ mono iikawaa qereweŋa kolooja. ");
INSERT INTO ksr_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Mono aoao kooŋ iŋiibu: Yoŋonoŋ nene kota mende qosoma kororooŋkeju. Dumuŋ hoŋa mende kotoŋ kowi mirigianoŋ mende meŋ kululuuŋkeju. Sii soloŋgia ii qetegoŋ (stua) nene mirinoŋ mende amakeju ano Anutunoŋ ii kileŋ uŋuagiŋkeja. Ejemba oŋoo sewaŋgia ii kooŋ sewaŋgia uŋuuguŋ uma eja. Mono ii romoŋgogi kemba. ");
INSERT INTO ksr_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Oŋoonoŋga moŋnoŋ majakaka moma iikaaŋa kanoŋ namonoŋ laligowaatiwaa kambaŋa ii weeŋ motooŋgowaa so meŋ toroqewaa me qaago? Ii qaago totooŋ! ");
INSERT INTO ksr_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","“Iwoi melaada kaaŋa ambombaajoŋ amamaawuti eeŋ, iwoi tosaaŋa kuuyaajoŋ mono nomaembaajoŋ majakaka mobuyaga? ");
INSERT INTO ksr_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Oŋo mono japu jariŋ juraya akadamugiawo ii iŋiibu: Yoŋonoŋ opo surugiaajoŋ beweso mende loŋgbamakeju. Gawoŋ iwoi tosaaŋa mende meŋkeju ano ii kileŋ kokaeŋ iŋijowe mobu: Kiŋ Solomonoŋ goul silwaya qeragoŋ malekuya asombilibiliawo mouma laligoroto, iwaa malekuya ii taalimba leiŋ firinduawaa so iimasiiŋsiiŋawo mende kolooro. ");
INSERT INTO ksr_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","“Japu jariŋ juraya tooŋ ii kete namonoŋ kosonananoŋ raro woraŋ koŋgi kamaaro giliŋ meŋ kululuuŋ kuugi jewaa. Ii kileŋ Anutunoŋ juraya kaaŋa moŋ ii kaaŋiadeeŋ awaagadeeŋ menjereŋgoŋkeja. Kawaajoŋ iinoŋ mono oŋo kaaŋagadeeŋ saanoŋ esuuŋ oŋombaa. Oŋo japu jariŋ jurayaa so mende kolooju. Anutunoŋ kalaŋ koma oŋomambaajoŋ moji, siiŋa iikanoŋ mono iwoi kuuya uŋuuguŋ uja. Oo ejemba, momalaarigianoŋ mono naambaajoŋ melaada kolooja? ");
INSERT INTO ksr_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Kaeŋ kolooro oŋo kaaŋagadeeŋ laaligogiaajoŋ majakaka mende mobu. Ii moma bimooŋ kokaeŋ jewubo, ‘Nono mono naa nene apuga newonaga?’ Kaeŋ jeŋ uugia iikanoŋ mende ama uukamakamaa kolooŋ uugere mokoloowubo. ");
INSERT INTO ksr_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kantri so uumeleembaa gadokopa yoŋonoŋ iwoi kaaŋa kuuya buŋa qeŋ aowombaajoŋ kaparaŋ koma uugere amakeju. Ii amakejuto, oŋo nene opo iwoiwaajoŋ memeqemeaŋ meŋ amamaajuti, Maŋgianoŋ mono ii modaboroja. ");
INSERT INTO ksr_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Iikawaa uugereya mende ambuto, mono Anutuwaa bentotonoŋ keubombaajoŋ kaparaŋ komakebu. Uugia iikanoŋ aŋgi ero iinoŋ mono galeŋ koma oŋoma iwoi kaaŋa ii kaaŋiadeeŋ toroqeŋ oŋombaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Oo noonoŋ tuuŋ melaada, Maŋgianoŋ bentotoŋ oŋomambaajoŋ mojiwaajoŋ mono toroko mende moma laligowu. ");
INSERT INTO ksr_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Balombaa moneŋ hinaya ii kaparaŋ koma qeragowubo. Kawaajoŋ iwoi eŋ oŋonji, ii mono sewaŋaajoŋ ama moneŋ horoŋ bakaya ejemba wanaya kaleŋgiaajoŋ oŋombu. Kaeŋ aŋgi qabuŋagia maa suaŋ kaaŋa ii Siwe gomanoŋ eŋ seiŋ mende qaombaa. Moneŋ gesogia qaita moŋ ii Siwe gomanoŋ mende boliwu. Gureŋ dumunjaŋ ano yoŋgoro meme yoŋonoŋ mono eu uma iwoi meŋ boliwombaajoŋ amamaawuya. ");
INSERT INTO ksr_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","“Iwoiwaajoŋ akadamuya meŋ mona uji, iikanoŋ miri moŋgeŋ ero giinoŋ mono uuga kaaŋagadeeŋ iikanoŋ qokotaaŋ laligowaga.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Oŋo mono Anutuwaa gawoŋa mewombaajoŋ jojoriŋ opo surugia somoŋgoŋ yagoŋ akadamugiawo nama uugiaa kiwayanoŋ ootirigi jero laligowu. ");
INSERT INTO ksr_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ii kokawaa so: Miri toya moŋ ii ejemba maraŋ (agomiŋ aoao) lombanoŋ kaŋ aisoowombaajoŋ horoŋ mugi keno. Kanoŋ keno meraurutanoŋ mirinoŋ rama eleembaatiwaajoŋ jaagianoŋ seleeŋgeŋ uuŋ kisi-kasu jeŋ kaparaŋ koma mambonju. Mamboma laligogi iinoŋ kambaŋ kanoŋ me kanoŋ kouma nagunoŋ qenaga, yoŋonoŋ mono iikanondeeŋ nagu horogi koubaa. Oŋo mono mera iyoŋoo so kolooŋ jojoriŋ laligowu. ");
INSERT INTO ksr_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","“Poŋnoŋ eleema karo gawoŋ memeuruta tosianoŋ uugbili laligogi kaeŋ mokolooŋ oŋombaati, iyoŋonoŋ mono simbawoŋawo kolooju. Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Iinoŋ kouma ajorooŋ oŋoma nene duŋnoŋ ano ragi nene uŋuagi mambaajoŋ jojoroŋ aoŋ weleŋ qeŋ oŋombaa. ");
INSERT INTO ksr_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Iinoŋ ruuŋanoŋ me gomaŋ aworaŋgoro kanoŋ eleeno tosianoŋ uugbili laligogi mokolooŋ oŋombaati, iyoŋonoŋ mono simbawoŋawo kolooju. ");
INSERT INTO ksr_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Gbili laligowombaajoŋ qaa koi mono saanoŋ romoŋgowu: gomantiiŋa ano kikekakasililiŋ ejanoŋ naa kambanoŋ me auanoŋ kawaati, miri toyanoŋ ii monagati eeŋ, iinoŋ mono gbili laligoŋ miria saanoŋ galeŋ mero qosoma umambaajoŋ amamaawaa. ");
INSERT INTO ksr_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Oŋo ‘Siwe gomambaa Eja hoŋanoŋ kambaŋ kokaamba mende koubaa,’ jeŋ romoŋgowuti, iinoŋ mono kambaŋ iikanondeeŋ koubaa. Kawaajoŋ oŋo kaaŋagadeeŋ jojoriŋ laligowu.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jiisasnoŋ qaa kaeŋ jero Piitonoŋ qisiro, “Poŋ, gii sareqaa koi ii nonoojoŋ me ejemba tosaaŋa kuuya yoŋoojoŋ kaaŋgadeeŋ jejaŋ?” ");
INSERT INTO ksr_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kaeŋ qisiro Poŋnoŋ jero, “Gawoŋ meme ejemba batugianoŋ moronoŋ tiriŋ kotoŋ tosaaŋa uŋuuguja? Tosianoŋ zololoŋgoŋ gawoŋ mesaogi moŋnoŋ momakooto awaawaa qaganoŋ kaparaŋ koma pondaŋ meŋkeji, iinoŋ mono simbawoŋawo kolooja. Miri toyanoŋ nanamemeŋa gosiŋ iima moŋgeŋ kema miriaa ilawoilaya ii iwaa borianoŋ ano galeŋa koloowaa. Galeŋa kolooŋ weleŋqeqeuruta ijorotiwaa so kalaŋ koma kambaŋ dindiŋanoŋ uŋuagiŋkebaa. ");
INSERT INTO ksr_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kaeŋ kalaŋ koma oŋoma laligoro toyanoŋ eleema kaŋ kaaŋ iima ‘Mono simbawoŋawo koloojaŋ!’ jewaa. ");
INSERT INTO ksr_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","“Niinoŋ qaa hoŋa moŋ kokaeŋ iŋijowe mobu: Toyanoŋ simbawoŋawo ijoŋ esuhinaya kuuyaa galeŋa kuuŋ mubaa. ");
INSERT INTO ksr_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kuuŋ mubaato, gawoŋ meme bibilokoya iinoŋ uutanoŋ romoŋgoŋ kokaeŋ jewaati eeŋ, ‘Poŋnaa kaka kambaŋanoŋ koriga eja.’ Kaeŋ jeŋ kanaiŋ gawoŋ meme ejembauruta uŋuŋ ureeŋ jejelombaŋ ama aisooŋ apu kotiga neŋ uuta sooro eŋkaloloŋ silemale ama laligowaa. ");
INSERT INTO ksr_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kaeŋ laligoŋ kambaŋ moŋnoŋ Poŋa koubaatiwaajoŋ mende mambombaati, mono iikanondeeŋ koubaa. Kambaŋaajoŋ imowamo ulumbuluŋ laligoro mono aua iikanondeeŋ kouma qeŋ japaleleŋ meŋ muŋ jeŋ kotoro qaaqootogo ejemba kaaŋa gere sianoŋ kemeŋ siimbobolo mobaa. ");
INSERT INTO ksr_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Gawoŋ meme moŋnoŋ Poŋaa uusiiŋa moma yagoroto, qaa areŋa ijorotiwaa so joroŋqoroŋ mende meŋ aoŋ gawoŋa meŋ laligoroti, Poŋanoŋ iikawaa iroŋa jero somoŋgoŋ oolinoŋ indiŋ mamaga qeyayagoŋ qewuya. ");
INSERT INTO ksr_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kaeŋ qewuyato, gawoŋ meme eja moŋnoŋ Poŋaa uusiiŋa mende moma yagoŋ iwoi ama mero iroŋa saanoŋ jegi oolinoŋ qewutiwaa so kolooji, Poŋnoŋ iikawaa iroŋa jero afaaŋa qewuya. Anutunoŋ mombaajoŋ iwoi mamaga muroti, iinoŋ mono ii meŋ seiro hoŋa mamaga koloowaatiwaajoŋ mambombaa. Anutunoŋ mombaajoŋ iwoiwaa waroga seiseiya muroti, iinoŋ mono ii meŋ seiro hoŋa seiseiya kolooro meleema mubaatiwaajoŋ qisiwaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Niinoŋ namonoŋ gere ama uulaŋgowe jeŋ kema kawaatiwaajoŋ kamaawe uusiiŋna mono iikawaa bolaŋanoŋ jedaborowaatiwaajoŋ eja. ");
INSERT INTO ksr_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ejato, ii ‘Gere ama uulaŋgomaŋa,’ jewe siimbobolo mamaga joŋ kowororo kaaŋa ii noo qananoŋ uma turuŋ nomambaajoŋ ambaa. Anutunoŋ iikaaŋa kanoŋ mulu qaita moŋ meŋ nombaa. Oo nii konjiliŋ somata moma laligowe mulu meŋ nono iikanoŋ tegowaa. ");
INSERT INTO ksr_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kokaeŋ romoŋgowubo: Jiisasnoŋ luae qemambaajoŋ ama namonoŋ kamaaro. Niinoŋ kokaeŋ iŋijowe mobu: Niinoŋ luae qemambaajoŋ qaagoto, noojoŋ ama juma deeŋgi boŋ jawo koloowaa. ");
INSERT INTO ksr_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","“Ii kokaembaajoŋ jejeŋ: Noo Buŋa qaananoŋ ejemba uugia kuuro meleeŋgitiwaajoŋ kambaŋ kokaamba kanaiŋ kokaeŋ koloowaa: Miri mombaa uutanoŋ ejemba 5 yoŋonoŋ batugianoŋ aŋgowowo ama jumbuya. Leegeŋ karooŋ yoŋonoŋ woi yorowo aŋgowowo aŋgi leegeŋ woi yoronoŋ karooŋ yoŋowo deendeeŋ ama laligowuya. ");
INSERT INTO ksr_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Maŋmera yoronoŋ juma kerekere ani nemumbora yoronoŋ riitama aori eŋaroyanoŋ eŋaroya qetama aoŋ deembaota.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jiisasnoŋ toroqeŋ ejemba tuuŋ ii kokaeŋ iŋijoro, “Weeŋ kemekemetanoŋ gomaŋ bulugoŋ koosu umuŋ kono oŋo ii iima iikanondeeŋ ‘Koŋ kawaa,’ jeŋkeju. Kaeŋ jegi koŋ kawaa. ");
INSERT INTO ksr_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Saut waageŋga haamo giliro iima moma kokaeŋ jeŋkeju, ‘Gomaŋ geriawo koloowaa.’ Kaeŋ jegi iikawaa so koloowaa. ");
INSERT INTO ksr_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Oo uumeleembaa ejemba seleseleya, oŋo sombiŋ namowaa tanigara iima koŋ weembaa kanagara saanoŋ gosiŋkejuto, kambaŋ koi laligojoŋi, iikawaa kania mende gosiŋ moma kotogi mende sokonja.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Oŋo ‘Iwoi dindiŋa ii nomaeŋ amboŋa,’ jeŋ kawaa kania ii nomaembaajoŋ ama oŋoaŋgio mende gosiŋ jeŋ tegoŋkeju? Ii mende sokonja. ");
INSERT INTO ksr_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kereganoŋ seleganoŋ qaa ama qaa jakeyanoŋ horoŋ gomambaajoŋ ano jenteego galembaanoŋ kema kana nemuŋanoŋ iikanoŋ mono kaparaŋ koma uumotooŋgo ama qaagara jeŋ solaŋaniwao. Kaeŋ mende ambaoti eeŋ, kereganoŋ saanoŋ ororaaŋ gono (jas, majistreit) jenteego toyaa jaanoŋ keuna moma jero opotorowaa borianoŋ kemena kapuare mirinoŋ goombabo. ");
INSERT INTO ksr_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Niinoŋ kokaeŋ jewe moba, Gii kanoŋ tawaga kuuya ambaatiwaa so osiŋ rabaga. Toiyaga konoga kaaŋagadeeŋ andaboroŋgo mono wantaaga meŋ kamaawaga.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kambaŋ iikanondeeŋ tosianoŋ kouma Jiisas sundu kokaeŋ ijogi moro, “Galili ejemba tosianoŋ Jerusalem jigonoŋ siimoloŋ oogi gawana Pailotnoŋ jero kawali galeŋurutanoŋ kanoŋ uma uŋuŋ komugi sagia kamaaŋ lama bulmakao sagiawo melokanjiŋ ero.” ");
INSERT INTO ksr_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Kaeŋ jegi meleema kokaeŋ iŋijoro, “Oŋo iikawaajoŋ kokaeŋ romoŋgowubo: Galili ejemba yoŋonoŋ Galili ejemba tosaaŋa kuuya uŋuuguŋ siŋgisoŋgo ama laligogitiwaajoŋ siimbobolo ii mogi. ");
INSERT INTO ksr_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kaeŋ qaagoto, niinoŋ kokaeŋ iŋijowe mobu: Oŋo uugia mende meleembuti eeŋ, oŋo kuuyanoŋ mono kaaŋagadeeŋ tiwilaadaborowu. ");
INSERT INTO ksr_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Me gomaŋ qata Siloam kanoŋ miri koriga moŋnoŋ kamaaŋ koma ejemba 18 turuŋ oŋono komugiti, oŋo iyoŋoojoŋ kokaeŋ romoŋgowubo: Yoŋonoŋ Jerusalem kanageso tosaaŋa kuuya uŋuuguŋ siŋgisoŋgo ama qaagiawo laligogi. ");
INSERT INTO ksr_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Qaagoto, niinoŋ kokaeŋ iŋijowe mobu: Oŋo uugia mende meleembuti eeŋ, oŋo kuuyanoŋ mono kaaŋagadeeŋ tiwilaadaborowuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jiisasnoŋ sareqaa moŋ kokaeŋ jero, “Eja moŋnoŋ muli gere komoro gawoŋanoŋ kouma nano kawaa hoŋa moŋgamambaajoŋ kenoto, moŋ mende mokolooro. ");
INSERT INTO ksr_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mende mokolooŋ gawoŋ galeŋaajoŋ jero, ‘Moba, niinoŋ muli gere kokawaa hoŋa gbani karoombaa so kaŋ moŋgambeto, moŋ mende mokoloowe. Kawaajoŋ ii mono naambaajoŋ toroqeŋ namowaa kelega eeŋ horowabo. Kawaajoŋ ii mono koma gilina kemba.’ ");
INSERT INTO ksr_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Toyanoŋ kaeŋ jeroto, galenoŋ meleema ijoro moro, ‘Oo eja poŋna, ii saanoŋ mesaona gbani koi mombo namba. Niinoŋ kambaŋ biiwianoŋ kokaamba kanoŋ kinoŋnoŋ namo osoŋ qidigoŋ isombasoŋ ama liligowe kelegawo koloowaa. ");
INSERT INTO ksr_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Niinoŋ kaeŋ ambe gbani gematanoŋ iikawaa hoŋa saanoŋ koloonaga. Ii mende koloowaati eeŋ, ii saanoŋ komba.’” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jiisasnoŋ Sabat kendonoŋ qamakooli miri moŋnoŋ uma Buŋa qaa kuma oŋono. ");
INSERT INTO ksr_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kanoŋ emba moŋ raro. Omenoŋ gbani 18 kawaa so meŋ looriŋ muro gemata miligoro qetetereemambaajoŋ amamaaŋ rama laligoro. ");
INSERT INTO ksr_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jiisasnoŋ emba ii iima oono karo kokaeŋ ijoro, “Emba, isinabisina jiganoŋ mono gomesaoro awaa koloojaŋ.” ");
INSERT INTO ksr_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kaeŋ jeŋ boria waŋanoŋ ano iikanondeeŋ qetetereeŋ Anutu mepeseeŋ muro. ");
INSERT INTO ksr_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mepeseeŋ muroto, Jiisasnoŋ Sabat kendonoŋ emba ii meŋ qeaŋgoroti, qamakooli miriwaa galeŋanoŋ ii iima kawaajoŋ moro boliro qaa kanaiŋ ejemba tuuŋ yoŋoojoŋ jero, “Gawoŋ memewaa kambaŋ 6 eji, iikanoŋ mono kaŋ meŋ qeaŋgoŋ oŋombaatiwaajoŋ jewu. Ii Sabat kendonoŋ qaago.” ");
INSERT INTO ksr_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kaeŋ jeroto, Poŋnoŋ meleema kokaeŋ jero, “Oo uumeleembaa selesele ejemba, oŋo kuuya bulmakao ejiaga me doŋgigiaga ii Sabat kendonoŋ mirinoŋga isama uŋuaŋgi apunoŋ kema neŋkeju me qaago? Oŋoonoŋga moŋnoŋ ii mende aŋgoŋ koma oŋomakeja. ");
INSERT INTO ksr_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mobu! Emba koi kanoŋ Aabrahambaa gbiliga kolooro Satanoŋ somoŋgoŋ muro gbani 18:baa so laligoro niinoŋ kasia ii Sabat kendonoŋ isambe sokoma oŋonja me qaago?” ");
INSERT INTO ksr_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kaeŋ jero tuarenjeŋuruta kuuya yoŋonoŋ gamugia mogi ano ejemba tuuŋ kuuya yoŋonoŋ aŋgoleto damuyawo meroti, ii kuuya iima moma aisoogi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jiisasnoŋ sareqaa moŋ kokaeŋ jero, “Anutuwaa bentotoŋaa kania ii nomaeŋ? Ii naamombo so ambenaga? ");
INSERT INTO ksr_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ii nejoŋ kotaa so kokaeŋ kolooja: Eja moŋnoŋ ii meŋ gawoŋanoŋ kema komoro waama somariiŋ gere kolooro. Gere kolooro kanakeewaŋ kooŋa kooŋa yoŋonoŋ haigia gere iikawaa borianoŋ aŋgi.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jiisasnoŋ mombo sareqaa moŋ kokaeŋ jero, “Anutuwaa bentotoŋa ii naa iwoiwo so ambenaga? ");
INSERT INTO ksr_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ii yiist me flaua meŋ somasomariiwaa so kokaeŋ kolooja: Emba moŋnoŋ ‘Bered oomaŋa,’ jeŋ yiist meŋ flaua konde karooŋ kanoŋ mindiriŋ meleŋqeleeŋ ama ano rama korebore somariiro.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jiisasnoŋ kema taoŋa taoŋa ano gomaŋa gomaŋa kanoŋ Buŋa qaa kuma oŋoma kema laligoŋ Jerusalem sitinoŋ baageŋ keno. ");
INSERT INTO ksr_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Keno moŋnoŋ kokaeŋ qisiŋ muro, “Poŋ, uugia meleeŋgi Anutunoŋ hamo qeŋ oŋono letombuti, ii ejemba afaaŋgoya me nomaeŋ?” Qisiŋ muro kokaeŋ iŋijoro, ");
INSERT INTO ksr_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Oŋo mono nagu goŋgoŋanoŋ keubombaajoŋ janjariŋ riiŋ aoŋorowu. Niinoŋ kokaeŋ iŋijowe mobu: Ejemba mamaganoŋ Anutuwaa bentotoŋ uutanoŋ keubombaajoŋ batogowuto, ii amamaawuya. ");
INSERT INTO ksr_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kanageŋ miri toyanoŋ waama nagu konogo oŋo kambaŋ iikanoŋ kanaiŋ seleeŋgeŋ nama nagunoŋ qeŋ kokaeŋ jewuya, ‘Poŋ, mono nagu horoŋ nonomba.’ Kaeŋ jegi meleema kokaeŋ iŋijowaa, ‘Nii mende moma oŋonjeŋ. Oŋo daaŋkaya, ii mende mojeŋ.’ ");
INSERT INTO ksr_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kaeŋ iŋijoro oŋo iikanondeeŋ kanaiŋ kokaeŋ jewuya, ‘Nononoŋ mono giwo ainjoloŋ rama nene neniŋ. Giinoŋ mono liligoŋ nonoo sombenoŋ Buŋa kuma nonona.’ ");
INSERT INTO ksr_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kaeŋ jewuyato, iinoŋ qaa kokaeŋ iŋijowaa, ‘Oŋo mono dakaya, nii mende moma oŋonjeŋ. Kawaajoŋ kokaeŋ iŋijowe mobu: Bologa meme kuuya, oŋo mono nomesaoŋ togowu.’ ");
INSERT INTO ksr_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Togogi iikanoŋ Aabraham, Aisak, Jeikob ano gejatootoo ejemba kuuya yoŋonoŋ Anutuwaa bentotoŋ uutanoŋ naŋgi iŋiibuto, oŋoaŋgia hagoŋ oŋoŋgi seleeŋgeŋ nambuya. Kaniagia kaeŋ mokolooŋ saama gigilaaŋ gobugia kigi qaro laligowuya. ");
INSERT INTO ksr_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ejembaya ejembaya ii weeŋ koukoutanoŋga ano kemekemetanoŋga ano leelee Noot Saut iikanoŋa kaŋ Anutuwaa bentotonoŋ keuma duŋ raragia meŋ nembanene neŋ korisoro ama laligowuya. ");
INSERT INTO ksr_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kaeŋ laligowuto, mobu! Konoga yoŋoonoŋga tosianoŋ mutuya koloowuya ano mutuya yoŋoonoŋga tosianoŋ konoga koloowuya.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kambaŋ iikanondeeŋ Farisii (Kana qaawaa kaparaŋkoŋkoŋ) tosianoŋ Jiisaswaanoŋ kaŋ kokaeŋ jegi, “Kiŋ Herodnoŋ guro komuwaatiwaajoŋ moja. Kawaajoŋ mono gomaŋ koi mesaoŋ kemba.” ");
INSERT INTO ksr_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jegi kokaeŋ meleema oŋono, “Oŋo mono duuyaa kasu sooŋa ii kokaeŋ jegi moba, ‘Moba! Niinoŋ kete ano woraŋ ome oŋotaamaŋa ano ji ejemba meŋ qeaŋgoŋ oŋoma laligomaŋa. Kemaŋati, indigeŋ mono iikanoŋ keuma gawona metogomaŋa.’ ");
INSERT INTO ksr_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","“Gejatootoo ejemba seiseiya ii Jerusalem sitinoŋ uŋugi komugi. Gomaŋ tosianoŋ mende toroqeŋ uŋugi komuŋkeju, iikawaa tanitani eja iijeŋ. Kawaajoŋ niinoŋ kete ano woraŋ indigeŋ kana kema laligomaŋa. Jerusalem keube nugi komumaŋati eeŋ, mono iyoŋoonoŋ kaiyakagiaga ii toroqeŋ ambu.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jiisasnoŋ jero, “Oo Jerusalem Jerusalem, oŋo gejatootoo ejemba uŋugi komugi Anutunoŋ ejemba wasiŋ oŋono oŋoonoŋ kaŋkejuti, ii jamonoŋ uŋugi komuŋkeju. Kuru nemuŋanoŋ merauruta eŋgaŋa baatanoŋ ama kojojooŋ oŋomakeji, niinoŋ iikawaa so kambaŋa kambaŋa goo kanagesouruga suuŋgoŋ kololooŋ oŋomambaajoŋ moma laligoweto, oŋo ii togoŋ laligoŋ kougi. ");
INSERT INTO ksr_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mobu! ‘Anutunoŋ mono jigo mirigia gema qero saoyagadeeŋ ewaa.’ Kaeŋ ewaato, niinoŋ kokaeŋ iŋijowe mobu, Oŋo nii mombo mende niibuyato, kanageŋ kambaŋ moŋ kaŋ kuuro iikanoŋ niima kokaeŋ jewuya, ‘Pombaa qatanoŋ kaŋ nononji, Anutunoŋ mono ii kotuegoŋ muba.’ Kiaŋ.” ");
INSERT INTO ksr_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jiisasnoŋ Sabat kendoŋ moŋnoŋ Farisii (Kana qaawaa kaparaŋkoŋkoŋ) yoŋoo jotamemeya mombaa mirianoŋ uma nene nero. Neŋ raro tosianoŋ galeŋ meŋ itiigi. ");
INSERT INTO ksr_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Iikanoŋ iwaa jaasewaŋanoŋ ji eja moŋ kana boria apunoŋ ologoŋ somariiro raro. ");
INSERT INTO ksr_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jiisasnoŋ ii iima kanaiŋ Kana qaawaa boi ano Farisii ii qisiŋ oŋoma kokaeŋ jero, “Sabat kendonoŋ eja meŋ qeaŋgoŋ muŋ iikaaŋa kanoŋ Kana qaa uuguwoŋa me qaago?” ");
INSERT INTO ksr_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kaeŋ jeroto, yoŋonoŋ goroŋ qeŋ ragi. Ragi borianoŋ eja ii oosiriŋ meŋ qeaŋgoŋ wasiro keno. ");
INSERT INTO ksr_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Keno kokaeŋ iŋijoro, “Oŋoonoŋga mombaanoŋ mera me bulmakao ejia ii Sabat kendonoŋ apu roŋnoŋ kemebaati eeŋ, ii mono uulaŋawo horogi koubaa. Moronoŋ ii mende hororo kounaga?” ");
INSERT INTO ksr_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kaeŋ qisiŋ oŋono kawaa kitia meleembombaa bimooŋ qaagia bogoro ragi. Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Farisii (Kana qaawaa kaparaŋkoŋkoŋ) ejanoŋ ejemba nenewaajoŋ koma horoŋ oŋonoti, iyoŋonoŋ duŋ jaayanoŋ eu metogoŋ ragiti, Jiisasnoŋ ii iima kawaajoŋ sareqaa moŋ kokaeŋ iŋijoro, ");
INSERT INTO ksr_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Moŋnoŋ gii maraŋ (agomiŋ aoao) lombambaanoŋ koma horoŋ gono iikanoŋ kema duŋ jegeŋa mende meŋ raba. Kaeŋ ambagati eeŋ, tosaaŋa koma horoŋ oŋonoti, iyoŋoonoŋga moŋnoŋ gii guuguŋ qabuŋayawo koloowabo. ");
INSERT INTO ksr_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","“Iinoŋ kouro lombaŋ toyanoŋ goonoŋ kaŋ kokaeŋ jenaga, ‘Gii duŋ koi mesaona uuta iinoŋ raba.’ Kaeŋ jewaati eeŋ, gii mono waama baatanoŋ emu kamaaŋ duŋ meŋ rama gamuga senjombo mobabo. ");
INSERT INTO ksr_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kaeŋ qaagoto, moŋnoŋ koma horoŋ gombaati, gii saanoŋ duŋ simiŋanoŋ emu kema raba. Kaeŋ rana lombaŋ toyanoŋ kouma giima jewaa, ‘Alana, gii saanoŋ kaŋ duŋ jegeŋanoŋ eu kema raba’. Kaeŋ jero giinoŋ ejemba giwo rama nene nejuti, mono kuuya iyoŋoo jaagianoŋ qabuŋagawo koloowaa. ");
INSERT INTO ksr_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ii kokaembaajoŋa: Iyaŋgiaa uugia meŋ ubuti, Anutunoŋ ii kuuya meŋ kamaaŋ oŋombaa. Moŋnoŋ iyaŋa uuta meŋ kamaawaati, Anutunoŋ mono ii meŋ uma mubaa.” ");
INSERT INTO ksr_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Farisii (Kana qaawaa kaparaŋkoŋkoŋ) ejanoŋ ejemba koma horoŋ oŋono lombanoŋ ragi Jiisasnoŋ lombaŋ toya eleema iima kokaeŋ ijoro, “Gii weembaa me gomantiiŋaa lombaŋ moŋ ooŋ iikanoŋ geeŋgaa alauruga me daremuŋuruga ii mende koma horoŋ oŋomba. Tinitosauruga me miri ejemba qabuŋagiawo ii mende koma horoŋ oŋomba. Kaaŋa lombambaajoŋ koma horoŋ oŋonati, ii kaaŋiadeeŋ koma horoŋ goma tosaga ii metogoŋ goŋgi tegowaa. Kaeŋ ambaati eeŋ, Anutunoŋ mono iikawaa tawaya mende gombaa. ");
INSERT INTO ksr_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","“Kaeŋ qaagoto, lombaŋ mozozoŋgoŋ oowagati, gii mono ejemba kamaaŋqeqeta ii koma horoŋ oŋomba. Ejemba wanaya, lokoŋ ano jaagoo koloojuti, mono ii oŋoona sokombaa. ");
INSERT INTO ksr_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ii koma horoŋ oŋona yoŋonoŋ tosa metogoŋ gombombaajoŋ amamaagi gii iikawaajoŋ simbawoŋawo kolooŋ laligowaa. Tosagia ii eeŋ ero laligona solaŋa yoŋonoŋ koomunoŋga waagi kambaŋ iikanoŋ Anutunoŋ aŋo ii goojoŋ metogoŋ gombaa.” Kiaŋ. ");
INSERT INTO ksr_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jiisasnoŋ kaeŋ jero nene neŋ ragi yoŋoonoŋga moŋnoŋ ii moma kokaeŋ ijoro, “Moŋnoŋ Anutuwaa bentotoŋ uutanoŋ keuma nene neŋ rabaati, niinoŋ iwaajoŋ simbawoŋawo jejeŋ.” ");
INSERT INTO ksr_vpl VALUES ("LK14_16","072_14_16","LUK","1