﻿USE sofia;
DROP TABLE IF EXISTS sofia.ksp_vpl;
CREATE TABLE ksp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ksp_vpl WRITE;
INSERT INTO ksp_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Dɔ ndɔ te ke nje-gangeje sariya ɔnje bbe ke Ijarayel, tɔku bbo oso. Mare dingaw ke Betelehem nange Juda te aw ke dene laa, ke nganne ke dingaw joo mba kisi bbe te ke Mowabe. ");
INSERT INTO ksp_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Ri dingaw le na Elimeleke, ri dene laa na Nawomi, ri nganne ke dingaw ke joo le na Malɔn de ke Kilyɔn. N̂-toje to dewje ke nange te ke Eparata* ke isije Betelehem nange Juda te. N̂-teeje ngonn bbe te ke ria na Mowabe le a, disije bbe te le. ");
INSERT INTO ksp_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","A ta koo a, Elimeleke ngaw le Nawomije le oy ngaa Nawomi nayn ke nganne ke dingaw ke joo le. ");
INSERT INTO ksp_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","N̂-taaje deneje ke Mowabe. Ne ke dɔngɔr ria na Orpa, ri ne ke kara na Rutu. N̂-ddaje ngɔsi ke bbal dɔku. ");
INSERT INTO ksp_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Goe te a, Malɔn de ke Kilyɔn doyje ngaa dene le nayn ke kare baa turu nganne te ke joo, ke turu ngaweje te. ");
INSERT INTO ksp_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Nawomi in me bbe te ke Mowabe ke ngann mume ke joo ta tel ke Betelehem le mba noo na Nje-kisi ke ndɔ ke ndɔ dda me-maji ke dewje laa ddew ne-kusa te. ");
INSERT INTO ksp_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Nɔtu bbe te ke nisi te le, ne ke ngann mume ke joo, dosoje ddew-bô ta tel nange te ke Juda. ");
INSERT INTO ksp_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Nawomi pa are ngann mume ke joo le na: « Ya, e-telje. Na na kara tel key le kɔenje! Maji kare Nje-kisi ke ndɔ ke ndɔ dda ke se me-maji ddew kara baa toke e-ddaje ke nje ke oyje ddem, e-ddaje sem ddem. ");
INSERT INTO ksp_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Maji kare Nje-kisi ke ndɔ ke ndɔ dda bba are isije ke maje kara kara tɔyn me key te le mare dingawje ke a taajese!» N̂-to mbide ngaa duruje dɔ nɔ te. ");
INSERT INTO ksp_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Dilaeje te na: « Baann ang, Ja kaw sei ke rɔ nje ke lei te.» ");
INSERT INTO ksp_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Nawomi pa na: « Ngannem ke dene, E-telje! Mba ddi bba a kawje sem wa? Ma kase kuju ngannje ke dingaw kare taase bbay wa? ");
INSERT INTO ksp_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Ngannem e-telje, awje! M-bbuka nya, mase taa ngaw ang ngaa. Bbo le munda mem to, ma to gir ngaw te til te neenn ta kuju ne ngannje ke dingaw ka, ");
INSERT INTO ksp_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","a ngebbejede ndereng kare n̂-tɔkuje njaa wa? A mbeteje ta taa ngaw mba yeenn wa? Baann ang ngannem ke dene! Ne ke ingam neenn to ngeng nya uta engase. Mba Nje-kisi ke ndɔ ke ndɔ undam. ");
INSERT INTO ksp_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Duruje dɔ nɔ te bbay. Orpa to mbi mumeje a Rutu nayn saa. ");
INSERT INTO ksp_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Nawomi pa na: « Ya, nje-mari tel ke bbê le nje-ke laa, ke kɔrje te laa. Ɔru goe.» ");
INSERT INTO ksp_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Rutu pa na: « A kuwam ke singa bba ma tel goi te ang ddem a kuwam ke singa kare minyai ang ddem! Lo ke aw te a, ma kaw te, lo ke e-dda bbe te a, ma dda bbe te, nje ke lei a to nje ke lem, ngaa Lubba lei a to Lubba lem, ");
INSERT INTO ksp_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","lo ke oy te a ma koy te ngaa da dubbum loe teenn. Toke yo a kayn horoje ang a minyai a, maji kare Nje-kisi ke ndɔ ke ndɔ dda sem ne ke mee ndiki.» ");
INSERT INTO ksp_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Kake Nawomi oo to Rutu ndiki nya mba kaw saa a, ew rɔe pa saa tar. ");
INSERT INTO ksp_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","N̂-njaje joo keme ndereng n̂-teeje Betelehem. Kake dandeje Betelehem a, dewje tɔyn ke me bbe te le aaje lo ke tade ngaa deneje paje na: « Nawomi wase na wa?» ");
INSERT INTO ksp_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","N̂-pa narede na: «E-bbaremje Nawomi ang. E-bbaremje *Mara, mba Nje-singa-mɔngu ddam are minga wungu nya! ");
INSERT INTO ksp_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Maw ke ne-kinga a, Nje-kisi ke ndɔ ke ndɔ tel sem jim baa. Mba ddi a e-bbaremje Nawomi wa? Nje-kisi ke ndɔ ke ndɔ pa tar naji ke majang dɔm te, Nje-singa-mɔngu ddam majang.» ");
INSERT INTO ksp_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Nawomi tel ke ngonn mume Rutu ke to ngonn nje-bbe ke Mowabe toke baann. N̂-teeje Betelehem kare kunn kutu kuja teyn te. ");
INSERT INTO ksp_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Nawomi ee ke mare nuju le ngaweje. N̂-to dew ke bo ngaa ninga ne ddem. N̂-to dew ke me nuju te le Elimeleke, ria na Bowaje. ");
INSERT INTO ksp_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Rutu, dene ke Mowabe le pa are Nawomi na: «Ma kaw ndɔɔ̂ mba kaw bburu jinga teyn, go dew te ke a koom maji keme te. Nawomi le pa are na: aw ngonnum.» ");
INSERT INTO ksp_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Naw ngaa naw n̂-bburu teyn go nje-kujaje teyn te. A ne umae are to ndɔɔ le Bowaje ke to dew ke me nuju te le Elimeleke le. ");
INSERT INTO ksp_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","A ta koo a Bowaje in Betelehem tee gode te ngaa pa are nje-kujaje teyn le na: « Nje-kisi ke ndɔ ke ndɔ ee ke se!» N̂-telje ke tar dareje na: «Nje-kisi ke ndɔ ke ndɔ bbar tar ke maji dɔi te!» ");
INSERT INTO ksp_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Bowaje duju nje-kula laa ke to nje-ngem dɔ nje-kujaje teyn na: « Ngonn ke dene neenn to le na wa?» ");
INSERT INTO ksp_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Nje-kɔn dɔ nje-kujaje kande ko le paje are na: «N̂-to ngonn ke dene ke Mowabe ke Nawomi ddee saa. ");
INSERT INTO ksp_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Ngonn ke dene le pa na na bburu teyn ke ta kareje te ngaa na bburu jinga teynje ke nayn horo kareje te. Lew baa ke n̂-ddee ke esindɔɔ njaa, nar ta kula te nyɔm, naw nuwa rɔe key mba gɔju kare baa.» ");
INSERT INTO ksp_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Bowaje pa are Rutu na: «Ngonnum, aw e-bburu ne me mare ndɔɔ te dang ang ngaa, e-nayn neenn. Uwa go ngann nje-kulaje lem ke dene, oo maji wa!» ");
INSERT INTO ksp_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Unda kemi dɔ ndɔɔ te ke daw duja koo me te neenn ta uwa go nje-kulaje lem ke dene. Oo wa, m-pa mare nje-kulaje lem ke dingaw kare ta dinyai ddekeke. Bbo kunda maann a ɔin a, aa lo me joo maannje te toonn a, a kay maann ke nje-kulaje lem toje. ");
INSERT INTO ksp_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Yeenn a n̂-tee noso, n̂-debbe keme ke nangê ngaa, n̂-pa nare na: «Ema ke m-to nje-mba neenn a, ddew ddi te bba oom te dew ngaa e-ddasem me-maji neenn wa?» ");
INSERT INTO ksp_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Bowaje pa are na: « Dɔru gel neje tɔyn ke e-dda ke mumije darem. Neje ke unn kute yo te le ngawije, ddew ke toke inya ne bɔije ke kɔinje ke bbe kuji mba ddee ne ke horo dewje te ke e-gerede kete ang. ");
INSERT INTO ksp_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Maji kare Nje-kisi ke ndɔ ke ndɔ tel ke mare ari wɔju dɔ ne ke e-dda! Nje-kisi ke ndɔ ke ndɔ, Lubba le Israel ke e-ddee ta kiya rɔi kɔ gɔle te ari kuka lei.» ");
INSERT INTO ksp_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Rutu pa na: « Oom to dew kemi te ebbemje. E-wul mem. E-pa tar ke uru dɔ bbengere bbere te lei ke dene. Ta koo maji a m-mbɔbbu mbɔr nje-kulaje lei ke dene kara ang.» ");
INSERT INTO ksp_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Kare ne-kusa ase a, Bowaje pa are na: « E-ngese ke kete usa ne, ula bina lei me maann nayn te.» Nisi mbɔr nje-kujaje kande ko te. Bowaje are mare kande ko ke n̂-ndaw nusa nare mee ndann ngaa n̂-ngem kese. ");
INSERT INTO ksp_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Goe te a nin taar ta bburu a Bowaje unn ndu are nje-kulaje laa na: «Inyaje ddew areje n̂-bburu horo kare teynje te tɔ bbo ɔkeje ddew ang. ");
INSERT INTO ksp_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Inyaje mare jinga waa horo kareje te areje n̂-bburu, ta inje saa ang.» ");
INSERT INTO ksp_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","N̂-bburu ne me ndɔɔ te le ndereng lo kul ngaa nunda ne ke n̂-bburu le ngaa ninga kande ne le ngɔsi ke bay sembe kara. ");
INSERT INTO ksp_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Noto naw ne bbê ngaa n̂-tɔju mumeje ne ke n̂-bburu le. N̂-tee ke kese ne-kusa ke nayn le nare. ");
INSERT INTO ksp_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Mumeje duje na: « Lo ke dda a e-bburu ne te bbokene wa? E-dda kula dda wa? Lubba bbar tar ke maji dɔ dew te ke unda keme dɔi te neenn!» Nɔru gel neje tɔyn ke nday dɔe te nare mumeje, ngaa n̂-pa na: « Ri dew ke m-dda kula ndɔɔ̂ laa na Bowaje.» ");
INSERT INTO ksp_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Nawomi pa are ngonn mume na: « Maji kare Nje-kisi ke ndɔ ke ndɔ ke ndɔ tɔyn aw dda maji ke dewje ke isije kem baa ddem, ke dewje ke oyje ddem bbar tar ke maji dɔ dingaw te neenn! Nawomi pa are bbay na: «Dingaw le to nuju leje ke danna njaa. Ne horo dewje te ke to tar lede ta taaje to dene ndubbaje.» ");
INSERT INTO ksp_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Rutu ke to dene ke Mowabe tel pa na: « Dingaw le pa arem tɔ na: E-nayn go nje-kulaje te lem nyɔm kula kuja koo ndɔɔ lem nunga.» ");
INSERT INTO ksp_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Nawomi pa are ngonn-mume Rutu na: « Ngonnum, maji kare e-nayn ke nje-kulaje laa ke dene ngaa maji kare dew ingai me mare ndɔɔ te dang dda sei singa ang.» ");
INSERT INTO ksp_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","N̂-nayn ke nje-kulaje le Bowaje mba bburu ne ndereng ndɔ ke kula kuja teyn, ke waa tunga. N̂-nayn ke mumeje. ");
INSERT INTO ksp_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Mumeje Nawomi pa are na: «Ngonnum, maw m-sange ddew ta kare uwa rɔi ngaa ta kare isi ke maje. ");
INSERT INTO ksp_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Ke bbasine, Bowaje ke aw rɔ nje-kulaje te laa ke dene teenn le to nuju leje le maa? Ne njaa na to teyn ke to bbal te til te neenn. ");
INSERT INTO ksp_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","E-ndoko maann, e-ndeem ubbu, ula kubbu ke kura bbo aw lo to teyn te. Are nusa ne tɔyn, nay ne tɔyn bba ta e-tɔju rɔi. ");
INSERT INTO ksp_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Naw ta to nangê a, aa lo ke na to te ke maje. Goe te a, uwa ne gɔle te oo a, e-to nangê kɔ gɔle te a, ne njaa na tɔji ne ke a dda.» ");
INSERT INTO ksp_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","N̂-pa nare na: « Ma dda ne tɔyn ke e-pa arem.» ");
INSERT INTO ksp_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Nɔtu naw bbal te le ngaa n̂-dda neje tɔyn ke mumeje pa are. ");
INSERT INTO ksp_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Bowaje usa ne ke ay ne ngaa ee ke rɔ-neel. Naw n̂-to mbɔr kande ko te ke to dɔ jin te le. Rutu ngeyn jann jann ddee uwa ne gɔle te oo ngaa to nangê kɔ gɔle te. ");
INSERT INTO ksp_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Lo mɔngu nyenene ngaa Bowaje le ndebbe a turu rɔe: Na ta koo a mare dene to kɔ gɔle te. ");
INSERT INTO ksp_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","N̂-duju na: «Ei na wa?» Nila te na: «Ema Rutu nje-kula lei ke dene aann. Uwa ta kubbu lei ila dɔ nje-kula te lei mba to tar lei ta tam to dene-ndubba.» ");
INSERT INTO ksp_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","N̂-pa nare na: Ngonnum ke dene, Nje-kisi ke ndɔ ke ndɔ bbar tar ke maji dɔi te! Kula ddai ke guku neenn to ke dɔgɔle uta ye ke kete bbay, mba aw e-tubba go ngann basanje ke nje-ndooje wase nje ne-kingaje ang. ");
INSERT INTO ksp_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Bbasine, ngonnum, are bbel ddai ang. Ma dda ne tɔyn ke a dujum, mba dewje tɔyn ke bbe leje gereje to e-to dene ke maji nya. ");
INSERT INTO ksp_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Tɔkɔrɔ njaa, to tar lem ta tai to dene-ndubba, a mare dew ke kula nuju laa to ngɔsi nya ke ngawije utam to. ");
INSERT INTO ksp_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","E-to neenn. Lo are ke esin a bbo n̂-diki ta taai to dene-ndubba a na taai, a bbo n̂-ndiki ang a, ma taai ture te, Nje-kisi ke ndɔ ke ndɔ ee teenn! E-to neenn ndereng lo are. ");
INSERT INTO ksp_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Rutu to kɔ gɔl Bowaje te ndereng ta-lo-kare ngaa nin taar ke lo ke to pipi mba Bowaje ndiki kare dew gere to Rutu ddee lo to waa ke teyn te neenn ang. ");
INSERT INTO ksp_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","N̂-pa nare na: E-ddee ke kubbu ke ngal ke rɔi teenn ke ne ta uwa tae ke maje. N̂-dda to ke baann ngaa nɔju teyn ke ne gɔl misan nungu me kubbu te le nunda dɔe te a, Bowaje le tel aw bbê. ");
INSERT INTO ksp_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Ruth tel ddee rɔ mumeje te ngaa mumeje le pa na: Na baann wa ngonnum? Nɔru gel neje tɔyn ke dingaw le dda mbata laa. ");
INSERT INTO ksp_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Nunn ne nɔju ne teyn le gɔl misan narem ngaa n̂-pa narem na:« A tel jii baa rɔ mumije te ang.» ");
INSERT INTO ksp_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Nawomi pa na: «Ngonnum e-nayn rɔm te neenn oo gel ne neenn bba, mba tar neenn goto bbokone njaa bba dingaw neenn a kila wure nangê.» ");
INSERT INTO ksp_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Bowaje tee isi lo dda tar te ta ndoko te ddaka. A ta koo a dingaw ke to tar laa ta taa Rutu to dene-ndubba ke Bowaje pa tar laa le unda lo tee. Bowaje pa na: « Ei neenn, e-ddee isi nangê neenn.» ");
INSERT INTO ksp_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Bowaje bbar dingawje dɔku horo tɔku dewje te ke eeje me bbe teenn, ngaa pa na: « Isije neenn ngaa disije nangê.» ");
INSERT INTO ksp_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","N̂-pa nare dew ke ee ke ddew ta taa Rutu to dene-ndubba le na: « Nawomi ke in bbe te ke Mowabe tel le aw labbe lo le ngokɔnje Elimeleke. ");
INSERT INTO ksp_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","A ema, meje ta pa kare e-ndoko lo le kem dewje te ke isije neenn, ke kem tɔku dewje te neenn! A bbo e-ndiki ta ndoko a e-ndoko! A bbo a ta ndoko ang a, e-pa arem. Mba mare dew ke dang ke to tar laa ta ndoko lo le goto. Goi te bba to ema.» Dingaw le ila te na: «Ema njaa ma ndoko.» ");
INSERT INTO ksp_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Bowaje pa na: « Ndɔ ke a ndoko ne ndɔɔ le ji Nawomi te a to ndɔ ke a taa ne Rutu dene ke Mowabe ke to dene-ndubba, mba kare ri ngaweje ke oy mban nayn dɔ ne-kingaje te laa.» ");
INSERT INTO ksp_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Dingaw ke to tar laa ta ndoko lo le pa na: « Ma ndoko lo le ang. Bbo m-dda baann a ma tuju ne-ndubba lem. E-ndoko lo ke to tar lem ta ndoko le to lei, ddew ke ma ndoko ne goto.» ");
INSERT INTO ksp_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Lew, dɔ nange te ke Ijarayel, bbo dew a ta dda mare ne toke le, taa dene-ndubba wase toke le mbel naa mare ne a, dew ke kara ɔru ne-gɔl laa are ye ke kara. Neenn le to tar-naji horo ngann le Ijarayelje te. ");
INSERT INTO ksp_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Dew ke to tar laa ta taa dene-ndubba le pa are Bowaje na: « E-ndoko ndɔɔ le to lei!» Ngaa Buwaje ɔru ne-gɔl laa. ");
INSERT INTO ksp_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Bowaje pa are dewje ke tɔku, ke dewje tɔyn ke nange te ke Ijarayel na: « Bbokone e-toje to nje-tar najije wɔju dɔ neje le Elimeleke, ke neje le kilyɔn, ke neje le Malɔn ke m-doko ji Nawomi te. ");
INSERT INTO ksp_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Rutu dene ke Mowabe ke to dene le Malɔn le njaa kara m-tae to dene lem. Ma kunda ne ko-ri ngaweje mba kare ri ngaweje le nayn horo ngakɔenje te ddem, nayn horo dewje te ke aw isije lo dda tar te ta ndoko te ddem. E-toje to nje-tar-naji nejeenn bbokone.» ");
INSERT INTO ksp_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Dewje tɔyn ke isije ta ndoko te le, ke dewje ke tɔku paje na: «N-toje to nje-tar naje njaa. Maji kare Nje-kisi ke ndɔ ke ndɔ dda bba are dene ke ande me key te lei to toke le Rasel, ke Leya, dede joo kem ke dundaje gel ngann le Ijarayelje nangê. Maji kare e-ddee to nje-ne-kinga nange te ke Eparata ta are rii bbar me Betelehem te. ");
INSERT INTO ksp_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Maji kare ngannje ke Nje-kisi ke ndɔ ke ndɔ a kari ddew te le dene ke inga neenn ddaje are me key lei to ddew kara baa toke me key le Perese ke Tamar uje are Juda.» ");
INSERT INTO ksp_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Bowaje taa Rutu to dene laa ngaa n̂-mbɔn saa naa. Nje-kisi ke ndɔ ke ndɔ dda are Rutu uwa sem ngaa uju ngonn ke dingaw. ");
INSERT INTO ksp_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Deneje paje are Nawomi na: « Jɔsuje gaji Nje-kisi ke ndɔ ke ndɔ ke bbokone ari dew ke nje-kuka dɔi ke ria a bbar nange Ijarayel te tɔyn. ");
INSERT INTO ksp_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Ngonn le a dda kare ubba singa ngaa, na dda sei ndɔ bbuka te lei mba, ngonn mumi ke ndikii nya a uje. Ngonn mumi le uta ngannje ke dingaw siri.» ");
INSERT INTO ksp_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Nawomi taa ngonn le ote kare te ngaa n̂-ddee to nje-ngem ngonn le. ");
INSERT INTO ksp_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Nje-ninn-key-mareje undaje ri ngonn le na: «Duju ngonn dare Nawomi!» N̂-bbareje na Obede. Obede le a to bɔ Ijayije, Ijayi le a to bɔ Dabbitije. ");
INSERT INTO ksp_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Ri nje ke gel Perese te le to toke be: Perese uju Heteserɔn, ");
INSERT INTO ksp_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Heteserɔn uju Ram, Ram uju, Aminadabe, ");
INSERT INTO ksp_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadabe uju Nasɔn, Nasɔn uju Salma, ");
INSERT INTO ksp_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salma uju Bowaje, Bowaje uju Obede, ");
INSERT INTO ksp_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obede uju Ijayi, Ijayi uju Dabbiti.");
INSERT INTO ksp_vpl VALUES ("ET1_1","018_1_1","EST","1","1","1","Tar ke n̂-dda maketuru te neenn, to ne ke nday dɔ ndɔje te ke Asurusu ɔn dɔ bbeje kɔr kara ke dɔjoo gire siri. Bbeje ke unnje kute nange te ke Ende ndereng nange te ke Etiyopi. ");
INSERT INTO ksp_vpl VALUES ("ET1_2","018_1_2","EST","1","2","2","Dɔ ndɔje teenn le tɔku mbay Asurusu isi dɔ ngende-mbay te tɔku bbe te ke ria na Suje. ");
INSERT INTO ksp_vpl VALUES ("ET1_3","018_1_3","EST","1","3","3","Nɔ bbe bbal muta a, n̂-dda kusu ngaa n̂-bbar nje ke ta gɔle te, ke nje-kulaje laa, ke mbamba ke bbe te ke Perese, ke Medi, ke tɔku dewje, ke ngann-mbayje ke dɔ bbeje te le. ");
INSERT INTO ksp_vpl VALUES ("ET1_4","018_1_4","EST","1","4","4","Kusu le dda neyn misan. Asurusu tɔju ne-kingaje ke to bbal kɔn-bbe te laa ddem tɔju tɔku-mbange laa ddem. ");
INSERT INTO ksp_vpl VALUES ("ET1_5","018_1_5","EST","1","5","5","Neyn misan nunga a, tɔku mbay Asurusu tel dda mare kusu ndɔ siri bbay. N̂-dda kusu le me ndoko key-mbay te wɔju dɔ dewje ke bbe te ke Suje tɔyn, nje-ne-kingaje, ke nje-ndooje tɔyn. ");
INSERT INTO ksp_vpl VALUES ("ET1_6","018_1_6","EST","1","6","6","N̂-tɔje pal kubbuje ke ngeng ke ndange nda ddem kase ddem erje te ke ria na marbere ke dɔsu to gajije. N̂-tɔje pal kubbuje le ke kula leenje ke nda, ke kulaje ke kase. N̂-tɔje kulaje le buwa eninga nare te. Dundaje ne-kisije ke n̂-dda ke ande ddem ke nare ddem, dɔ nange te ke n̂-dda ke erje dang dang ke kura. ");
INSERT INTO ksp_vpl VALUES ("ET1_7","018_1_7","EST","1","7","7","Dɔru koto ke ngoje ke n̂-dda ke ande dare dewje ayje. Gare ngoje le to dang dang. Koto ke ria na ven ula to maann, mba mbayje aw ɔsuje ngar toke baann. ");
INSERT INTO ksp_vpl VALUES ("ET1_8","018_1_8","EST","1","8","8","Dewje ayje koto toke mede ndiki, mba tɔku mbay unn ndue ta kare nje-ngem neje ke key laa ddaje ne ke me dewje ndikije. ");
INSERT INTO ksp_vpl VALUES ("ET1_9","018_1_9","EST","1","9","9","Basti, dene le tɔku mbay njaa kara dda kusu wɔju dɔ dene mareje me key te le mbay Asurusu tɔ. ");
INSERT INTO ksp_vpl VALUES ("ET1_10","018_1_10","EST","1","10","10","Ndɔ siri laa a, koto dda tɔku mbay Asurusu ngaa rɔe neele nya. Tɔku mbay pa are *enukuje ke siri ke aw ddaje kula key laa. Ride na Mewuma, Bijita, Arbona, Bigita, Abageta, Jetar, ke Karkase. ");
INSERT INTO ksp_vpl VALUES ("ET1_11","018_1_11","EST","1","11","11","N̂-pa narede ta kare daw n̂-ddee ke dene laa Basti. Na kula ejɔku-dɔ-mbay bba da ddee saa. Tɔku mbay ndiki ta tɔju mande le Basti dewje, ke ngann mbayje, mba n̂-mande nya. ");
INSERT INTO ksp_vpl VALUES ("ET1_12","018_1_12","EST","1","12","12","Enukuje le awje ndajije kula le tɔku mbay le areje Basti. A Basti mbete ta ddee nɔ tɔku mbay te ngaa wungu ɔn tɔku mbay nya. ");
INSERT INTO ksp_vpl VALUES ("ET1_13","018_1_13","EST","1","13","13","N̂-pa tar ke nje-ne-gereje ke isije mbɔre te, mba ke ndɔ tɔyn bbo mare tar to key le mbay a, dede a daw n̂-mɔseje, mba n̂-gereje ndu ddem, n̂-gereje ne ke maji kare tɔku mbay dda ddem. ");
INSERT INTO ksp_vpl VALUES ("ET1_14","018_1_14","EST","1","14","14","Ri nje-ne-gereje le na Karsena, Setar, Admata, Tarsise, Merese, Marsena, ke Memukan. Dede siri le n̂-toje to nje ke ta-gɔl tɔku mbay te. Disije nange te ke Perse ke Medi. N̂-toje to singa-mɔngu tɔku mbay ddem n̂-toje to dewje ke bo me bbe-kɔn te laa ddem. ");
INSERT INTO ksp_vpl VALUES ("ET1_15","018_1_15","EST","1","15","15","Tɔku mbay dujude na: « Ddew ndu te, sariya ddi a maji ta gange dɔ Basti dene te le mbay Asurusu ke mbete ta dda ne ke nula enukuje nare n̂-paje dare le wa?» ");
INSERT INTO ksp_vpl VALUES ("ET1_16","018_1_16","EST","1","16","16","Memukan pa kem tɔku mbay te, ke nje ke ta-gɔl-mbay te na: « Kula ke maji ang ke Basti dda neenn, n̂-dda ke tɔku mbay ke kare baa ang. N̂-dda ke nje ke ta gɔl-mbay te tɔyn, ke dewje tɔyn ke bbeje te le tɔku mbay Asurusu. ");
INSERT INTO ksp_vpl VALUES ("ET1_17","018_1_17","EST","1","17","17","Mba deneje tɔyn a kooje tar ne ke Basti dda le. Da dabbeje ngawdede, mba da paje na « Tɔku mbay unn ndu kare n̂-ddee ke dene-mbay Basti nɔe te, a Basti mbete le se ddi wa!» ");
INSERT INTO ksp_vpl VALUES ("ET1_18","018_1_18","EST","1","18","18","Bbasine deneje le nje ke ta-gɔl mbay te ke Perse, ke Medi ke a kooje tar le Basti a ddaje ne toke baann ke de tɔ. Yeenn njaa a ddee ke dabbe naa ddem ke wungu ddem. ");
INSERT INTO ksp_vpl VALUES ("ET1_19","018_1_19","EST","1","19","19","Bbo tɔku mbay, e-ndiki a, ja kunn ndu ngaa ja kila ne mber. Ndu le a to ke ndɔ ke ndɔ. Ndu le a to horo nduje te ke Perse, ke Medi. Ndu le a kɔku ddew Basti ta kare tee nɔi te ngaa a kɔru ri ke to dene-mbay dɔ Basti te kare mare dene ke maji uta Basti. ");
INSERT INTO ksp_vpl VALUES ("ET1_20","018_1_20","EST","1","20","20","Bbo dewje ooje tar ndu neenn ke ngeng ke unn wɔju dɔ bbe-kɔn lei tɔyn a, deneje tɔyn a bbelje ngawdede, nje ke to dewje ke bo, ke nje ke to dewje ke ten.» ");
INSERT INTO ksp_vpl VALUES ("ET1_21","018_1_21","EST","1","21","21","Tar le neel tɔku mbay, ke nje ke ta-gɔle te ngaa tɔku mbay dda toke Memukan pa le. ");
INSERT INTO ksp_vpl VALUES ("ET1_22","018_1_22","EST","1","22","22","Tɔku mbay ula ke maketuru bbeje te tɔyn. N̂-dda maketuru le ke gɔl maketuru le dewje kara kara, ke ndɔn tar lede kara kara, mba kare dingawje tɔyn ɔnje dɔ me key lede ngaa kare dingawje tɔyn paje tar bbe lede. ");
INSERT INTO ksp_vpl VALUES ("ET2_1","018_2_1","EST","2","1","1","Go neje teenn le a, wungu le tɔku mbay Asurusu gayn. Nole mee dɔ Basti te ddem dɔ ne te ke Basti dda ddem, dɔ ndu te ke dunn dɔ Basti te ddem. ");
INSERT INTO ksp_vpl VALUES ("ET2_2","018_2_2","EST","2","2","2","Nje-kulaje le tɔku mbay paje na: « Maji kare n-sange ngannje ke dene ke mandeje nya ngaa gereje ngaw ang bbay jare tɔku mbay. ");
INSERT INTO ksp_vpl VALUES ("ET2_3","018_2_3","EST","2","3","3","Maji kare tɔku mbay unda nje-kulaje laa ngann bbeje te tɔyn ke me bbe-kɔn te laa kare n̂-mbɔnje ngannje ke dene ke mandeje ngaa nayn gereje ngaw ang bbay. N̂-mbɔnde lo-ngem-deneje te ke to tɔku bbe te ke Suje ngaa Ege ke enuku a koo lo dɔde te ngaa na karede ne-mandeje. ");
INSERT INTO ksp_vpl VALUES ("ET2_4","018_2_4","EST","2","4","4","Ngonn ke dene ke neel kem tɔku mbay te a, a taa turu Basti.» Tar neenn le neel tɔku mbay ngaa nare n̂-dda toke baann. ");
INSERT INTO ksp_vpl VALUES ("ET2_5","018_2_5","EST","2","5","5","Mare Jiipi ke ria na Mardose ee tɔku bbe te ke Suje le. N̂-to ngonn le Yayir, ngonn le Simeyi, ngonn le Kisi ke to dew ke gel Benjami te. ");
INSERT INTO ksp_vpl VALUES ("ET2_6","018_2_6","EST","2","6","6","Mardose le ee horo dewje te ke tɔku mbay Nebukanejar uwade Jerusalem kara baa ke Yekoniya ke to mbay ke Juda aw ke de Babilɔnn to bbereje. ");
INSERT INTO ksp_vpl VALUES ("ET2_7","018_2_7","EST","2","7","7","Adasa ke ria ke kara na Ester to ngonn le ngokɔn Mardose, nisi ke Mardose. Bɔeje, ke kɔenje doyje. Ester le mande nya. Go yo te le bɔeje, ke kɔenje a, Mardose unne ngeme. ");
INSERT INTO ksp_vpl VALUES ("ET2_8","018_2_8","EST","2","8","8","Goe te ke dila mber ke ndu ke tɔku mbay unn le a, n̂-mbɔn ngannje ke dene banya banya tɔku bbe te Suje ta kare Ege aa lo dɔde te. Yeenn a, n̂-ddee ke Ester lo-ngem deneje te kare Ege ke to nje-ngem deneje aa lo dɔe te tɔ. ");
INSERT INTO ksp_vpl VALUES ("ET2_9","018_2_9","EST","2","9","9","Ester neel kem Ege te ngaa Ege ndiki ta dda saa maji. Nare ne-mandeje, ke ne-kusaje. Nare Ester nje-kulaje ke dene siri ke n̂-mberede horo nje-kulaje te ke key-mbay te. Nare lo-to ke maji Ester, ke nje-kulaje laa ke dene me key-ngem deneje te le. ");
INSERT INTO ksp_vpl VALUES ("ET2_10","018_2_10","EST","2","10","10","Ester ɔru gel kuje ke to Jiipi le are dew kara oo ang, mba Mardose ndeje nya ta kare n̂-pa ang. ");
INSERT INTO ksp_vpl VALUES ("ET2_11","018_2_11","EST","2","11","11","Ndɔ tɔyn Mardose aw ila mbɔr key-ngem-deneje le ta gere se Ester to ke maje wase ddi a daw n̂-dda saa wa. ");
INSERT INTO ksp_vpl VALUES ("ET2_12","018_2_12","EST","2","12","12","Dunn bbal kara kare ngannje ke dene le mɔseje ne rɔde ddew kara baa ke ndu ke dunn. Dare n̂-ndemje ke wubbu ke ria na mire neyn misan ngaa n̂-ndemje ke wubbu ke ria na aromate, n̂-ddaje rɔde ke ne-mandeje dang dang neyn misan tɔ. Goe te bba ngannje ke dene le kara kara a kawje nɔ tɔku mbay te. ");
INSERT INTO ksp_vpl VALUES ("ET2_13","018_2_13","EST","2","13","13","Bbo ngonn ke dene in lo-ngem deneje te ta kaw ke rɔ tɔku mbay te a, dare neje tɔyn ke mee ndiki ta kare naw ne key-mbay te. ");
INSERT INTO ksp_vpl VALUES ("ET2_14","018_2_14","EST","2","14","14","Na kaw rɔ tɔku mbay te lo-kul te ngaa lo are a, da kaw saa ke endɔɔ mare key-ngem-deneje te ke Sasegaje aw aa lo ke dɔe te. Sasegaje le to enuku ke aw ngem dene-mɔrɔje le tɔku mbay. Ngonn ke dene le a tel rɔ tɔku mbay te ang. Bbo tɔku mbay ee ke bbo laa a, na kula kare n̂-bbare ke ria bba na kaw rɔe te. ");
INSERT INTO ksp_vpl VALUES ("ET2_15","018_2_15","EST","2","15","15","Ndɔ ke Ester a ta kaw rɔ tɔku mbay te ase. Ester le to ngonn le Abisayil ke to ngokɔn Mardose ngaa Mardose ngeme. Ester duju mare ne dang ang, a ne ke Ege ke to enuku nje-ngem deneje le tɔku mbay pa are njaa n̂-duju. Dewje tɔyn ooje Ester ke kem ke maji. ");
INSERT INTO ksp_vpl VALUES ("ET2_16","018_2_16","EST","2","16","16","Asurusu ɔn bbe bbal siri laa a, daw ke Ester dundae key-mbay te ke neyn ke ria na Tebete. ");
INSERT INTO ksp_vpl VALUES ("ET2_17","018_2_17","EST","2","17","17","Tɔku mbay ndiki Ester uta kese deneje tɔyn ngaa ndiki ta dda saa maji uta kese ngannje ke dene tɔyn ke gereje ngaw ang bbay. Nula ejɔku-dɔ-mbay dɔ Ester te ngaa nunda Ester turu Basti te. ");
INSERT INTO ksp_vpl VALUES ("ET2_18","018_2_18","EST","2","18","18","Tɔku mbay dda tɔku kusu wɔju dɔ Ester. N̂-bbar nje ke ta-gɔle te, ke nje-kulaje laa. Nɔru lambo dɔ dewje te ke eeje bbeje te ngaa n̂-kayn ne dewje, mba mbayje aw ɔsuje ngar toke baann. ");
INSERT INTO ksp_vpl VALUES ("ET2_19","018_2_19","EST","2","19","19","Gɔl joo laa ke n̂-mbɔn ngannje ke dene ke gereje ngaw ang bbay a, Mardose aw dda kula lo taa nje-mbaje te ke me key-mbay te. ");
INSERT INTO ksp_vpl VALUES ("ET2_20","018_2_20","EST","2","20","20","Ester ɔru gel kuje ke to Jiipi le are dew kara oo ang, ddew kara baa toke Mardose ndeje ne. Ester aw dda ne ke turu ndu Mardose toke naw n̂-dda kare te ke nisi ne saa. ");
INSERT INTO ksp_vpl VALUES ("ET2_21","018_2_21","EST","2","21","21","Kare te ke Mardose aw dda kula lo taa nje-mbaje te key-mbay te a, enukuje joo ke aw ddaje kula key-mbay te aw mɔseje tar ta tɔl tɔku mbay, mba wungu ɔnde dɔe te nya. Ride na Bigitan de ke Terese. ");
INSERT INTO ksp_vpl VALUES ("ET2_22","018_2_22","EST","2","22","22","Tar le oso mbi Mardose te ngaa pa are Ester oo. Ester ndaji are tɔku mbay ke ri Mardose. ");
INSERT INTO ksp_vpl VALUES ("ET2_23","018_2_23","EST","2","23","23","Duru gel tar le a, to tɔkɔrɔ. N̂-tɔ enukuje le kar kake te ngaa n̂-tɔlde. N̂-dda tar neenn kem tɔku mbay Asurusu te me maketuru te ke daw n̂-dda tarje te daw n̂-ngem. ");
INSERT INTO ksp_vpl VALUES ("ET3_1","018_3_1","EST","3","1","1","Go neje te ke ndayjeenn le a, Asurusu unn Amann undae lo kula te ke bo. Amann le to ngonn le Amedata, dew ke me nuju te le Agage nare Amann ddee dew ke bo ngaa nundae dɔ nje ke ta-gɔle te tɔyn. ");
INSERT INTO ksp_vpl VALUES ("ET3_2","018_3_2","EST","3","2","2","Nje-kulaje tɔyn ke lo taa nje-mbaje te ke me key-mbay te aw ɔsuje gɔlde nangêngaa daw dulaje dɔde nangê nɔ Amann te, mba tɔku mbay njaa unn ndue ta kare n̂-ddaje toke baann. A Mardose kara baa mbete ta kɔsu gɔle nangê ddem ta kula dɔe nangênɔ Amann te ddem. ");
INSERT INTO ksp_vpl VALUES ("ET3_3","018_3_3","EST","3","3","3","Nje-kulaje ke key-mbay te ke eeje ta ndoko te dujuje Mardose na:« Mbata ddi bba n̂-mbete ta dda ne ke turu ndu ke tɔku mbay unn wa?» ");
INSERT INTO ksp_vpl VALUES ("ET3_4","018_3_4","EST","3","4","4","N̂-dujuje tar neenn Mardose ke ndɔ tɔyn, a Mardose oo tar lede ang. Mardose le pa arede na gel ne to Jiipi. N̂-paje dare Amann ta koo se Mardose a turu ddew laa ang wa. ");
INSERT INTO ksp_vpl VALUES ("ET3_5","018_3_5","EST","3","5","5","Amann gere to Mardose aw ɔsu gɔle nangê ang ddem ula dɔe nangênɔe te ang ddem a, wungu ɔen. ");
INSERT INTO ksp_vpl VALUES ("ET3_6","018_3_6","EST","3","6","6","N̂-pa dare Amann na Mardose to Jiipi. Yeenn a, Amann ndiki ta tɔl Mardose kara baa ang. Naw n̂-sange ddew ta tɔl Jiipije tɔyn ke isije bbe-kɔn te le tɔku mbay Asurusu. ");
INSERT INTO ksp_vpl VALUES ("ET3_7","018_3_7","EST","3","7","7","Bbal dɔku gire joo ke tɔku mbay Asurusu ɔn bbe, ke neyn ke dɔngɔr ke ria na Nisan a, Amann ndɔn ne mba gere ndɔ, ke neyn ke maji boy mba dda ne ne ke naw neje le. Elemteen oso dɔ neyn te ke ria na Adar, to neyn dɔku gire joo laa. ");
INSERT INTO ksp_vpl VALUES ("ET3_8","018_3_8","EST","3","8","8","Amann pa are tɔku mbay Asurusu na: « Mare dewje ke gelde to dang saneje naa bbeje te tɔyn me bbe-kɔn te lei. Ddew ndu te lede, n̂-toje dang ke kese dewje ngaa n̂-ddaje ne ke turu ndui ang. Ase kare inyade are disije ddekeke ang. ");
INSERT INTO ksp_vpl VALUES ("ET3_9","018_3_9","EST","3","9","9","Tɔku mbay, bbo e-ndiki a, e-dda mare ndu me maketuru te are n̂-tɔl dewje neenn tɔyn. Tɔku mbay, bbo n̂-tɔlde tɔyn a, ma tura kande nare doro dɔku kare nje ke ta-gɔli te kare dilaje lo-ngem nare te lei.» ");
INSERT INTO ksp_vpl VALUES ("ET3_10","018_3_10","EST","3","10","10","Tɔku mbay ɔru eninga ke ngonn-jia te are Amann ke to nje-baan le Jiipije. Amann le to ngonn le Amedata, dew ke me nuju te le Agage. ");
INSERT INTO ksp_vpl VALUES ("ET3_11","018_3_11","EST","3","11","11","Tɔku mbay pa are Amann na: « Inya nare lei. Minya dewje le me jii te. E-dda ne tɔyn ke mei ndiki ke de.» ");
INSERT INTO ksp_vpl VALUES ("ET3_12","018_3_12","EST","3","12","12","Ndɔ dɔku gire muta le dɔngɔr neyn a, tɔku mbay bbar nje-ddaje maketuru ke me key-mbay te ngaa n̂-dda ndu ke Amann unn le me maketuru te. Dula ke maketuru le dare nje-ddaje kula turu tɔku mbay te, ke ngann mbayje ke isije bbeje te tɔyn. Dula ke maketuru le dare gel dewje kara kara tɔyn ke bbe-kɔn te le Asurusu. N̂-dda maketuru le ke gɔl maketuru, ke ndɔn tar le dewje ke isije bbeje te kara kara. N̂-dda maketuru le ke ri Asurusu ngaa dunda endaji eninga laa maketuru te le tɔ. ");
INSERT INTO ksp_vpl VALUES ("ET3_13","018_3_13","EST","3","13","13","Dare maketuru le ngann nje-kulaje awje ne bbeje te le tɔku mbay tɔyn. Maketuru le unn ddew ta kare n̂-tɔl Jiipije ngaa ta n̂-rasede tɔyn: ngann basanje, ke ngann mandeje, bbukaje, ngannje, ke deneje. Da tɔlde ndɔ kara baa, ke ndɔ dɔku gire muta le neyn ke ria na Adar ke to neyn dɔku gire joo laa. Da koto neje lede tɔ. ");
INSERT INTO ksp_vpl VALUES ("ET3_14","018_3_14","EST","3","14","14","N̂-gem mare maketuru le ta kila ne mber bbeje te kara kara, ta kare disije perere mba ngina ndɔ le. ");
INSERT INTO ksp_vpl VALUES ("ET3_15","018_3_15","EST","3","15","15","Tɔku mbay unn ndu ngaa ngann-nje-kulaje teeje ke ngɔru awje. Dila mber ke ndu le me tɔku bbe te ke Suje. Kare teenn tɔku mbay de ke Amann disije mba kay koto. A dewje ke bbe te ke Suje aw nɔje. ");
INSERT INTO ksp_vpl VALUES ("ET4_1","018_4_1","EST","4","1","1","Mardose oo tar neje ke daw n̂-dda le. N̂-tir kubbu rɔe te, nula kubbu ndoo ngaa nunda bu rɔe te ngaa n̂-tee naw me bbe te. Nuru ekii ke wungu. ");
INSERT INTO ksp_vpl VALUES ("ET4_2","018_4_2","EST","4","2","2","N̂-ddee ke kubbu ndoo le, nar nɔ key-mbay te, mba dew ase kande key-mbay te ke kubbu ndoo ang. ");
INSERT INTO ksp_vpl VALUES ("ET4_3","018_4_3","EST","4","3","3","Jiipije ke bbeje te kara kara, ke Jiipije ke isije loje te tɔyn ke dila mber ke ndu ke mbay unn le ke te, daw n̂-ndingaje ndoo. N̂-mbeteje ne-kusa, n̂-nɔje ngaa n̂-ndingaje rɔde. Mareje nya ulaje kubbu ndoo ngaa toje dɔ bu te. ");
INSERT INTO ksp_vpl VALUES ("ET4_4","018_4_4","EST","4","4","4","Nje-kulaje le Ester ke toje to ngann mandeje, ke enukuje ke aw ngemeje ddeeje paje tar le are. Me Ester tuju nyɔm. Ester ula ke kubbuje ta kare Mardose tɔru kubbu ndoo ke rɔe te a ula. A Mardose mbete ta kula kubbuje le. ");
INSERT INTO ksp_vpl VALUES ("ET4_5","018_4_5","EST","4","5","5","Ester bbar mare enuku kara ke aw ngeme ke ria na Atake. N̂-pa nare ta kare naw n̂-duju Mardose se ddi a to wa? Mbata ddi bba n̂-dda ne toke baann wa? ");
INSERT INTO ksp_vpl VALUES ("ET4_6","018_4_6","EST","4","6","6","Atake tee aw inga Mardose ndake lo te nɔ key-mbay te. ");
INSERT INTO ksp_vpl VALUES ("ET4_7","018_4_7","EST","4","7","7","Mardose ɔru gel neje tɔyn ke ingae, ke tar kɔr nare ke Amann unn ndue ta kila lo-ngem nare te le tɔku mbay, mba kare n̂-tɔl Jiipije. ");
INSERT INTO ksp_vpl VALUES ("ET4_8","018_4_8","EST","4","8","8","Nare Atake mare maketuru ke dila ne mber me bbe te ta rase ne Jiipije le. N̂-pa are Atake ta kare n̂-tɔju maketuru le Ester, ta nɔru ne gel neje tɔyn ke aw nja nare. N̂-dda kɔkɔrɔ Atake ta kare n̂-pa nare Ester aw rɔ tɔku mbay te aw duje, ta kare noo kem-to-ndoo lede ngaa ta kare n̂-dda me-maji ke ngakɔnde Jiipije. ");
INSERT INTO ksp_vpl VALUES ("ET4_9","018_4_9","EST","4","9","9","Atake ddee pa go tarje le Mardose le are Ester. ");
INSERT INTO ksp_vpl VALUES ("ET4_10","018_4_10","EST","4","10","10","Ester ula Atake bbay ta kare n̂-pa nare Mardose na: ");
INSERT INTO ksp_vpl VALUES ("ET4_11","018_4_11","EST","4","11","11","« Nje-kulaje le tɔku mbay tɔyn, ke dewje tɔyn ke ngann bbeje te ke me bbe-kɔn te le tɔku mbay gereje tar ndu ke tɔku mbay unn wɔju dɔ dewje tɔyn. Ndu le na: Dene wase dingaw ke tɔku mbay bbare ang a tee nɔ tɔku mbay te me key te laa, a kinga yo. Dew ke tɔku mbay njaa ula kake laa ke n̂-dda ke ande are bba a kinga yo ang. A ema, tɔku mbay bbarem rɔe te ang ase neyn kara ngaa.» ");
INSERT INTO ksp_vpl VALUES ("ET4_12","018_4_12","EST","4","12","12","Atake aw pa tarje le Ester le are Maredose. ");
INSERT INTO ksp_vpl VALUES ("ET4_13","018_4_13","EST","4","13","13","Ngaa Mardose tel ula are Ester bbay na: « Eje to mba kake ee me key te le mbay bba a nayn ke tebbe horo Jiipije te wa? ");
INSERT INTO ksp_vpl VALUES ("ET4_14","018_4_14","EST","4","14","14","Bbo ɔru tai e-pa tar bbasine neenn ang a, Jiipije a teeje ta yo te ke ddew ke dang. A ei, a koy ngaa kose a goto. A du ang, mba ne ke toke be a aw ne key-mbay te.» ");
INSERT INTO ksp_vpl VALUES ("ET4_15","018_4_15","EST","4","15","15","Ester tel ula are Mardose na: ");
INSERT INTO ksp_vpl VALUES ("ET4_16","018_4_16","EST","4","16","16","« Aw mbɔn Jiipije tɔyn ke me bbe te ke Suje. Inyaje ne-kusa wɔju tar dɔm. Ndɔ muta, ke til muta usaje ne ang ddem ayje maann ang ddem. Ema, ke nje-kulaje lem, ja kinya ne-kusa, ke maann ddew kara baa toke baann tɔ. Yeenn a, ma kaal dɔ ndu ke tɔku mbay unn le ngaa ma kaw rɔe te. Bbo ase kare moy a, ma koy.» ");
INSERT INTO ksp_vpl VALUES ("ET4_17","018_4_17","EST","4","17","17","Mardose aw dda ne tɔyn ke Ester are n̂-pa dare. ");
INSERT INTO ksp_vpl VALUES ("ET5_1","018_5_1","EST","5","1","1","Ndɔ muta ke Jiipije inyaje ne-kusa, ke maann le ase. Ester ungu ne-mandeje le deneje le mbayje rɔe te ngaa naw nar ndake lo te, nɔ key te le tɔku mbay. Ndake lo le aa naa ke lo-kisi le tɔku mbay. Tɔku mbay isi ngende-mbay te laa ke aa lo ke ta ndoko kande key-mbay te le. ");
INSERT INTO ksp_vpl VALUES ("ET5_2","018_5_2","EST","5","2","2","Kake tɔku mbay oo Ester ke ar ndake lo te ddaka le a, kare teenn njaa n̂-ndiki ta dda saa me-maji. Tɔku mbay ula kake laa ke uwa jia te are Ester. Kake le n̂-dda ke ande. Ester nja aw uwa ta kake le tɔku mbay le. ");
INSERT INTO ksp_vpl VALUES ("ET5_3","018_5_3","EST","5","3","3","Tɔku mbay pa are na: « Ddi wa, dene-mbay Ester? Ddi a e-ndiki wa? Ne tɔyn ke e-ndiki a, ma kari, to debbe bbe-kɔn lem njaa kara ma kari.» ");
INSERT INTO ksp_vpl VALUES ("ET5_4","018_5_4","EST","5","4","4","Ester ilae te na: « Tɔku mbay, bbo oo maji a, e-ddee ke Amann bbokone kusu te ke m-dda wɔju dɔe.» ");
INSERT INTO ksp_vpl VALUES ("ET5_5","018_5_5","EST","5","5","5","Tɔku mbay pa na: « Areje Amann tel ke tar dɔ ne-bbar te le Ester ke ngɔru.» Tɔku mbay de ke Amann n̂-ddeeje kusu te ke Ester dda le. ");
INSERT INTO ksp_vpl VALUES ("ET5_6","018_5_6","EST","5","6","6","Kare te ke daw dayje koto ke ria na ven a, tɔku mbay duju Ester na: « Ddi a e-duju wa? Ne ke e-duju a, ma kari. Ddi a e-ndiki wa? Ne tɔyn ke e-ndiki a, ma kari, to debbe bbe-kɔn lem njaa kara ma kari.» ");
INSERT INTO ksp_vpl VALUES ("ET5_7","018_5_7","EST","5","7","7","Ester ila te na: « Ne ke m-duju le wa? Ne ke m-ndiki le wa? ");
INSERT INTO ksp_vpl VALUES ("ET5_8","018_5_8","EST","5","8","8","Tɔku mbay, bbo e-ndiki ta dda sem me-maji ngaa oo maji ta karem ne ke m-duju, ke ne ke m-ndiki a, maji kare e-ddee ke Amann kusu te ke ma dda bara bbay, a ma pa ne ke m-ndiki kari.» ");
INSERT INTO ksp_vpl VALUES ("ET5_9","018_5_9","EST","5","9","9","Ndɔe teenn le Amann tee key le Ester ke rɔ-neel ngaa rɔe ndɔɔ. A ta koo a, Amann oo Mardose lo-taa-mbaje te le tɔku mbay. Amann aw ddee a, Mardose in taar ang ddem ii rɔe ang ddem. Yeenn a, wungu ɔn Amann nya dɔ Mardose te. ");
INSERT INTO ksp_vpl VALUES ("ET5_10","018_5_10","EST","5","10","10","Amann ore wure aw key laa. Nula n̂-bbar nje-buwa-kuraje laa, ke dene laa Jerese. ");
INSERT INTO ksp_vpl VALUES ("ET5_11","018_5_11","EST","5","11","11","Amann tura go neje ke maji ke ninga, ke kɔr ngannje ke nuju, ke neje ke maji tɔyn ke tɔku mbay dda saa ngaa unne undae dɔ ngann mbayje te, ke dɔ nje-kulaje te ke key-mbay te. ");
INSERT INTO ksp_vpl VALUES ("ET5_12","018_5_12","EST","5","12","12","Dɔe te, Amann pa na: « Ema ke karem baa njaa dene-mbay Ester bbarem ke tɔku mbay kusu te ke n̂-dda bbokone. Ema le bbay a n̂-bbarem ke tɔku mbay kusu te ke bara. ");
INSERT INTO ksp_vpl VALUES ("ET5_13","018_5_13","EST","5","13","13","A bbo ta kare moo Mardose ke to Jiipi aw dda kula lo-taa-mbaje te key-mbay te a, nejeenn tɔyn to mare ne kem te ang.» ");
INSERT INTO ksp_vpl VALUES ("ET5_14","018_5_14","EST","5","14","14","Jerese dene le Amann, ke nje-buwa-kuraje le Amann tɔyn n̂-paje dareje na: « Maji kare are duru kake ke ndew ase dɔ-kɔbbu-dew dɔjoo gire mi taar, ta bara ke endɔɔ a, e-pa are tɔku mbay are n̂-tɔl Mardose dɔ kake te le. Yeenn a, a kase ta kaw ke tɔku mbay kusu te le ke rɔ-neel.» Tar le neel Amann ngaa nare duru kake le taar. ");
INSERT INTO ksp_vpl VALUES ("ET6_1","018_6_1","EST","6","1","1","Tile teenn bbi ɔru kem tɔku mbay ang. Nare n̂-ddee ke maketuru ke daw n̂-dda tarje me te daw n̂-ngem. Nare n̂-tura maketuru le nɔe te. ");
INSERT INTO ksp_vpl VALUES ("ET6_2","018_6_2","EST","6","2","2","N̂-tura maketuru le a, dinga tar le enukuje ke toje to nje-ngemje ta key le tɔku mbay, Bigitan de ke Terese. Dede joo ke dunguje tar me naa te ta tɔl tɔku mbay Asurusu bba Mardose uku me tare are tɔku mbay le. ");
INSERT INTO ksp_vpl VALUES ("ET6_3","018_6_3","EST","6","3","3","Tɔku mbay pa na: « Ddi a n̂-dda dare Mardose, mba kɔsu ne gaje wa?» Nje-kulaje ke me key te le tɔku mbay paje na: «N̂-dda ne kara dare ang nyɔm.» ");
INSERT INTO ksp_vpl VALUES ("ET6_4","018_6_4","EST","6","4","4","Tɔku mbay duju tar na: « Na ee me ndoko te ddaka wa?» Kare teenn Amann in me ndoko te me key-mbay te aw ddee ta pa kare tɔku mbay kare n̂-tɔl Mardose dɔ kake te ke nare n̂-mɔse wɔju dɔe. ");
INSERT INTO ksp_vpl VALUES ("ET6_5","018_6_5","EST","6","5","5","Nje-kulaje le paje na: « Amann a ar me ndoko te ddaka.» Tɔku mbay pa na: « Areje nande key!» ");
INSERT INTO ksp_vpl VALUES ("ET6_6","018_6_6","EST","6","6","6","Amann ande key-mbay te ngaa tɔku mbay duje na: « Ddi a da dda kare dew ke tɔku mbay ndiki ta kɔsu gaje wa?» Amann eje mee te na: « Ema njaa tɔku mbay ndiki ta kɔsu gajim ma se na dang bbay wa?» ");
INSERT INTO ksp_vpl VALUES ("ET6_7","018_6_7","EST","6","7","7","Amann pa are tɔku mbay na: « Tɔku mbay ndiki ta kɔsu gaji mare dew wa? ");
INSERT INTO ksp_vpl VALUES ("ET6_8","018_6_8","EST","6","8","8","Maji kare tɔku mbay are dunn kubbu lei ke aw ula, ke sunda ke aw aal ngaa are dunda ejɔkudɔ-mbay dɔ sunda te le. ");
INSERT INTO ksp_vpl VALUES ("ET6_9","018_6_9","EST","6","9","9","Maji kare are kubbu le, ke sunda le mare dew ke ngeng horo nje ke ta-gɔli te. Na kula kubbu dew ke e-ndiki ta kɔsu gaje le. Na kundae dɔ sunda te nja saa me bbe te ke Suje ngaa na kila mber nɔe te na: Ne ke daw n̂-dda ke dew ke tɔku mbay ndiki ta kɔsu gaje a neenn bbo!» ");
INSERT INTO ksp_vpl VALUES ("ET6_10","018_6_10","EST","6","10","10","Tɔku mbay ila Amann te na: « Unn kubbu le ta uwa sunda le toke e-pa neenn njange. E-dda toke baann ke Mardose ke to Jiipi ke isi lo-taa-mbaje te. Are mbita ne tɔyn ke e-pa neenn kara oso nange ang.» ");
INSERT INTO ksp_vpl VALUES ("ET6_11","018_6_11","EST","6","11","11","Amann unn kubbu, ngaa uwa sunda le tɔku mbay. Nula Mardose kubbu le ngaa nundae dɔ sunda te n̂-nja saa me bbe te ke Suje. Nila mber nɔ Mardose te na: « Ne ke daw n̂-dda ke dew ke tɔku mbay ndiki ta kɔsu gaje neenn bbo!» ");
INSERT INTO ksp_vpl VALUES ("ET6_12","018_6_12","EST","6","12","12","Goe te a, Mardose tel aw lo kula te laa key-mbay te guku. A Amann tɔ dɔe ke kubbu ngaa tel key laa ke ngɔru toke le dew ke yo tɔle. ");
INSERT INTO ksp_vpl VALUES ("ET6_13","018_6_13","EST","6","13","13","Amann ɔru gel ne ke ingae le are dene laa Jerese, ke nje-buwa-kuraje laa. Nje-buwa-kuraje laa, ke dene laa paje areje na: « Bbo Mardose ke unn kutu ta ddee ngonn nɔe te to Jiipi a, mare ne dang ke a dda mba kutae ne goto. A tel ke guku nyɔm nɔ Mardose te.» ");
INSERT INTO ksp_vpl VALUES ("ET6_14","018_6_14","EST","6","14","14","Daw n̂-paje saa tar bbay a, enukuje le tɔku mbay ddeeje. Duwaje Amann dawje saa ke tɔku kusu te ke Ester dda. ");
INSERT INTO ksp_vpl VALUES ("ET7_1","018_7_1","EST","7","1","1","Tɔku mbay de ke Amann n̂-ddeeje mba kusa ne ke dene-mbay Ester dda. ");
INSERT INTO ksp_vpl VALUES ("ET7_2","018_7_2","EST","7","2","2","Ndɔ joo laa, tɔku mbay duju Ester bbay kare te ke daw dayje koto ke ria na ven na: « Dene-mbay Ester, ddi a e-duju wa? Ne ke e-duju a, ma kari. Ddi a e-ndiki wa? Ne tɔyn ke e-ndiki a, ma kari, to debbe bbe-kɔn lem njaa kara ma kari.» ");
INSERT INTO ksp_vpl VALUES ("ET7_3","018_7_3","EST","7","3","3","Ester ila te na: « Tɔku mbay, bbo e-ndiki ta dda sem me-maji tɔkɔrɔ, toke e-ndiki a, ne ke m-duju a neenn: Tar tebbe lem, ke le nje ke lem Jiipije. ");
INSERT INTO ksp_vpl VALUES ("ET7_4","018_7_4","EST","7","4","4","Ema, ke nje ke lem n̂-labbeje ta kare dewje tɔlje, raseje, rebbeje tɔyn. Bbo to n̂-labbeje to, bbereje ke dingaw, ke bbereje ke dene a, ma pa tar ang, mba yeenn ase ta jɔku ne mbay ang.» ");
INSERT INTO ksp_vpl VALUES ("ET7_5","018_7_5","EST","7","5","5","Tɔku mbay Asurusu duju Ester na: « Na ee ke keje ke baann mee te wa? Nee dda wa?» ");
INSERT INTO ksp_vpl VALUES ("ET7_6","018_7_6","EST","7","6","6","Ester ila te na: « Nje-baan leje le to Amann, nje-me-majang!» Me Amann unda dɔ binya nɔ tɔku mbay te, ke nɔ dene-mbay te. ");
INSERT INTO ksp_vpl VALUES ("ET7_7","018_7_7","EST","7","7","7","Wungu ɔn tɔku mbay ngaa tusu ne-kusa le inya ngaa tee ddaka aw me ndɔɔ putu kakeje te ke to me ndoko key-mbay te. Amann nayn me key te le Ester. Naw n̂-dda kɔkɔrɔ Ester, mba kare nare tɔku mbay tɔle ang, mba Amann gere to tɔku mbay a kare n̂-tɔl ne. ");
INSERT INTO ksp_vpl VALUES ("ET7_8","018_7_8","EST","7","8","8","Amann tee oso dɔ ne-kisi te ke Ester ndɔju rɔe te. Kare teenn njaa tɔku mbay in me ndɔɔ putu kakeje te ddaka ande me key te ke Ester dda kusu te le. Tɔku mbay pa ke taar na: « Dɔe teenn, n̂-tel ta kuwa dene-mbay ke singa to saa kem te me key te neenn bbay wa?» Tar nayn ke ta tɔku mbay te bbay a, n̂-tɔ kem Amann. ");
INSERT INTO ksp_vpl VALUES ("ET7_9","018_7_9","EST","7","9","9","Mare enuku ke ria na Arbona pa kem tɔku mbay te na: « Amann are duru kake taar nɔ key te laa mba tɔl ne Mardose, Mardose ke pa tar are tɔku mbay tee ne ta yo te le. Kake le ndew ase dɔ-kɔbbu dew dɔjoo gire mi.» Tɔku mbay pa na: « Aw ilaje kula gɔse te e-tɔje kake te le areje noy!» ");
INSERT INTO ksp_vpl VALUES ("ET7_10","018_7_10","EST","7","10","10","Daw n̂-tɔl Amann dɔ kake te ke Amann mɔse wɔju dɔ Mardose le. Yeenn ngaa wungu le tɔku mbay gayn. ");
INSERT INTO ksp_vpl VALUES ("ET8_1","018_8_1","EST","8","1","1","Ndɔe teenn njaa tɔku mbay are Ester key le Amann ke to nje-baan le Jiipije. Ester pa are tɔku mbay na Mardose to Jiipi ngaa tɔku mbay ula are Mardose ddee nɔe te. ");
INSERT INTO ksp_vpl VALUES ("ET8_2","018_8_2","EST","8","2","2","Tɔku mbay ɔru eninga ngonn-ji ke nare Amann bba n̂-tel n̂-taa guku le nare Mardose. Goe te a, Ester unn Mardose to nje-ngem neje ke key le Amann. ");
INSERT INTO ksp_vpl VALUES ("ET8_3","018_8_3","EST","8","3","3","Ester nayn dɔ tar teenn ang, noso nangênɔ tɔku mbay te n̂-nɔ ngaa n̂-duju tɔku mbay kare noo kem-to-ndoo le Jiipije, ta kare tɔku mbay mbete me-majang le Amann, dew ke me nuju te le Agage ke a ta tɔl ne Jiipije le. ");
INSERT INTO ksp_vpl VALUES ("ET8_4","018_8_4","EST","8","4","4","Tɔku mbay ula kake laa ke n̂-dda ke ande are Ester. Yeenn ngaa Ester in taar ar nɔ tɔku mbay te. ");
INSERT INTO ksp_vpl VALUES ("ET8_5","018_8_5","EST","8","5","5","Ester pa na: « Bbo oo maji ngaa e-ndiki ta dda sem me-maji, bbo ne ke ma duju neenn to ke dɔgɔle a, are n̂-dda maketuru n̂-tuju ne maketuru ke Amann ke to ngonn le Amedata, dew ke me nuju te le Agage dda mba kare n̂-tɔl ne Jiipije tɔyn ke isije bbeje te lei le. ");
INSERT INTO ksp_vpl VALUES ("ET8_6","018_8_6","EST","8","6","6","Ma koo ne-wungu ke a ta koso dɔ nje ke lem te ke kem toke baann wa? Ma kisi kaa nje ke lem be kare kode tunga toke baann wa?» ");
INSERT INTO ksp_vpl VALUES ("ET8_7","018_8_7","EST","8","7","7","Tɔku mbay Asurusu pa are Ester de ke Mardose ke to jiipi na: « Mare Ester key le Amann ngaa mare n̂-tɔ kula gɔsu Amann te n̂-tɔ kula gɔse te n̂-tɔ kake te dare oy wɔju dɔ Jiipije ke Amann a ta tɔlde. ");
INSERT INTO ksp_vpl VALUES ("ET8_8","018_8_8","EST","8","8","8","Maketuru ke n̂-dda ke ri tɔku mbay ngaa dunda endaji eninga le mbay dɔe te mban, da tel turu ang ngaa. Baann a, sese njaa e-ddaje tar ke maji wɔju dɔ Jiipije me mare maketuru te ke rim ngaa ta undaje endaji eninga lem maketuru te le.» ");
INSERT INTO ksp_vpl VALUES ("ET8_9","018_8_9","EST","8","9","9","Ndɔe teenn njaa, ke ndɔ dɔjoo gire muta le muta le neyn ke ria na Siban, dula n̂-bbar nje-ddaje maketuru le tɔku mbay. Mardose pa tar wɔju dɔ Jiipije ngaa n̂-ddaje tar le maketuru te. Dulaje ke maketuru le dare nje-kɔn-bbeje, ke ngann mbayje tɔyn ke ɔnje dɔ bbeje, bbeje kɔr kara ke dɔjoo gire siri ke unn kute Ende ndereng Etiyopi. N̂-dda maketuru le ke gɔl maketuru le dewje ke bbeje te ddem ke ndɔn tar le dewje ke bbeje te kara kara ddem. N̂-dda maketuru le ke gɔl maketuru ddem ke ndɔn tar le Jiipije ddem dula ne darede tɔ. ");
INSERT INTO ksp_vpl VALUES ("ET8_10","018_8_10","EST","8","10","10","N̂-dda maketuru le ke ri tɔku mbay Asurusu, dunda endaji eninga laa dɔe te ngaa dula ne nje-sundaje, sundaje le tɔku mbay ke n̂-ngemde dang. ");
INSERT INTO ksp_vpl VALUES ("ET8_11","018_8_11","EST","8","11","11","Tar ke n̂-dda maketuru te le na: « Tɔku mbay are ddew Jiipije tɔyn ke eeje bbeje te, ta kare n̂-mbɔnje naa, ta n̂-ddaje ddɔ dɔde te, ta n̂-tɔlje nje-ddɔje ke bbeje te ke a ta ddajede maji ang. Narede ddew ta tɔl ngannje ddem, deneje ddem. Narede ddew ta kare dotoje ne-kingaje lede ddem. ");
INSERT INTO ksp_vpl VALUES ("ET8_12","018_8_12","EST","8","12","12","Nare Jiipije ddew ta kare n̂-ddaje neenn le bbeje te tɔyn ke Asurusu ɔn dɔe ndɔ kara baa, ke ndɔ dɔku gire muta le neyn ke ria na Adar ke to neyn dɔku gire joo. ");
INSERT INTO ksp_vpl VALUES ("ET8_13","018_8_13","EST","8","13","13","N̂-ngem mare maketuru le ta kila ne mber kare dewje tɔyn, mba kare maketuru le ddee to ndu ke tɔku mbay unn kare Jiipije isije perere ndɔe teenn le ta kila bare lede.» ");
INSERT INTO ksp_vpl VALUES ("ET8_14","018_8_14","EST","8","14","14","Kake tɔku mbay unn ndue a, ngann-nje-kulaje aalje sundaje le tɔku mbay ke n̂-ngemde dang le. Dinje me key-mbay te n̂-teeje ngaa dawje ke ngɔru-ngal. Goe te a, dila mber ke maketuru le me tɔku bbe te ke Suje. ");
INSERT INTO ksp_vpl VALUES ("ET8_15","018_8_15","EST","8","15","15","Dula Mardose kubbu le mbayje ke kase ddem nda ddem, ke kubbu kul ke nda ddem kase ddem. Dunda ejɔkudɔ le mbayje ke n̂-dda ke ande dɔe te. Dewje ke isije tɔku bbe te ke Suje ilaje ko ngaa ddaje rɔ-neel. ");
INSERT INTO ksp_vpl VALUES ("ET8_16","018_8_16","EST","8","16","16","Rɔ Jiipije nelde nya. To toke ndɔ tete ddɔ lede. ");
INSERT INTO ksp_vpl VALUES ("ET8_17","018_8_17","EST","8","17","17","Bbeje kara kara, ke bbuka bbeje tɔyn, ke loje tɔyn ke dila mber ke ndu ke tɔku mbay unn ke te, Jiipije ddaje rɔ-neel, n̂-ddaje ne-kusa ke bo dusaje ngaa n̂-ddaje kusu. Mare dewje nya ke me bbe-kɔn te le Asurusu telje rɔde Jiipije, mba n̂-bbelje Jiipije nya. ");
INSERT INTO ksp_vpl VALUES ("ET9_1","018_9_1","EST","9","1","1","Ndɔ dɔku gire muta le neyn ke ria na Adar ke to neyn dɔku gire joo laa le ase. To ndɔ ke nje-baanje le Jiipije a ta ddaje ne ke turu ndu ke tɔku mbay unn dɔngɔr. Nje-baanje le Jiipije undaje mede ta kutade ke ddɔ. A ne turu are Jiipije a utaje nje-baanje lede ke ddɔ. ");
INSERT INTO ksp_vpl VALUES ("ET9_2","018_9_2","EST","9","2","2","Me bbeje te tɔyn ke tɔku mbay Asurusu ɔn dɔe, Jiipije mbɔnje naa mba dda ddɔ ke nje ke ndikije ta ddade maji ang. Dew kara ase kar nɔde te ang, mba dilaje bbel me dewje te tɔyn. ");
INSERT INTO ksp_vpl VALUES ("ET9_3","018_9_3","EST","9","3","3","Nje ke ta-gɔl tɔku mbay te tɔyn, ke ngann mbayje, ke nje ke tɔku mbay undade to nje-kulaje dɔ bbeje te, darje go Jiipije te, mba n̂-bbelje Mardose nya. ");
INSERT INTO ksp_vpl VALUES ("ET9_4","018_9_4","EST","9","4","4","Mardose ddee dew ke bo me key-mbay te ngaa ria bbar me bbeje te tɔyn ke Asurusu ɔn dɔe. Mardose ddee dew ke bo ke kete kete. ");
INSERT INTO ksp_vpl VALUES ("ET9_5","018_9_5","EST","9","5","5","Jiipije ddaje dewje ke mbetede toke mede ndiki. N̂-tɔlje nje-baanje lede ke tɔku kiya ngaa n̂-rasejede. ");
INSERT INTO ksp_vpl VALUES ("ET9_6","018_9_6","EST","9","6","6","Jiipije tɔlje dewje kɔr mi me tɔku bbe te ke Suje. ");
INSERT INTO ksp_vpl VALUES ("ET9_7","018_9_7","EST","9","7","10","Jiipije tɔlje ngann le Amann nje-baan le Jiipije ke to ngonn le Amedata le, a dotoje ne-kingaje lede ang. Ri ngann le Amann le na Parsanedata, Dalpɔn, Asepata, Porata, Adaliya, Aridata, Parmaseta, Arisayi, Aridayi, Bayejata. ");
INSERT INTO ksp_vpl VALUES ("ET9_11","018_9_11","EST","9","11","11","Ndɔe teenn njaa dula ke kɔr dewje ke Jiipije tɔlde me tɔku bbe te ke Suje dare tɔku mbay. ");
INSERT INTO ksp_vpl VALUES ("ET9_12","018_9_12","EST","9","12","12","Tɔku mbay pa are dene-mbay Ester na: « Me tɔku bbe te ke Suje baa bbay a Jiipije tɔlje dewje te kɔr mi ddem ngann le Amann ke dɔku ddem neenn a, baann a Jiipije tɔlje dewje kese bbeje te ke bbe-kɔn te le wa! A bbo e-ndiki ta dujum mare ne bbay a, ma kari, ma dda ne tɔyn ke mei ndiki.» ");
INSERT INTO ksp_vpl VALUES ("ET9_13","018_9_13","EST","9","13","13","Ester ila te na: « Tɔku mbay, bbo oo maji a, are ddew Jiipije ke Suje ddaje ne bara ke turu ndu mbay toke n̂-ddaje bbokone neenn. Ngaa ta n̂-na ninn ngann le Amann ke dɔku kake te taar.» ");
INSERT INTO ksp_vpl VALUES ("ET9_14","018_9_14","EST","9","14","14","Tɔku mbay unn ndue kare n̂-dda toke baann. Dila mare mber tɔku bbe te Suje ngaa n̂-na ninn ngann le Amann ke dɔku le kake te taar. ");
INSERT INTO ksp_vpl VALUES ("ET9_15","018_9_15","EST","9","15","15","Jiipije ke Suje mbɔnje naa ke ndɔ dɔku gire sɔ le neyn ke ria na Adar. N̂-tɔlje dewje kɔr muta me bbe te le. A dotoje ne-kingaje lede ang. ");
INSERT INTO ksp_vpl VALUES ("ET9_16","018_9_16","EST","9","16","16","Jiipije ke isije kese bbeje te me bbe-kɔn te le mbɔnje naa mba dda ddɔ dɔde te tɔ. N̂-tubbaje nje-baanje lede dɔde te ke ddang ngaa n̂-tɔlje nje ke ndikide ang doro dɔsiri gire mi. A dotoje ne-kingaje lede ang. ");
INSERT INTO ksp_vpl VALUES ("ET9_17","018_9_17","EST","9","17","17","Neenn le nday ke ndɔ dɔku gire muta le neyn ke ria na Adar. Ndɔ dɔku gire sɔ laa a, ddɔ gayn. Ndɔe teenn njaa n̂-ddaje ne-kusa ke bo dusaje ngaa n̂-ddaje rɔ-neel. ");
INSERT INTO ksp_vpl VALUES ("ET9_18","018_9_18","EST","9","18","18","A Jiipije ke Suje ke ilaje bare lede ke ndɔ dɔku gire muta, ke ndɔ dɔku gire sɔ uwaje rɔde ke ndɔ dɔku gire mi laa. Ndɔe le to ndɔ ke n̂-ddaje ne-kusa ke bo dusaje ngaa n̂-ddaje rɔ-neel. ");
INSERT INTO ksp_vpl VALUES ("ET9_19","018_9_19","EST","9","19","19","Gele ke neenn bba Jiipije ke isije bbeje te aw ddaje kusu ke ndɔ dɔku gire sɔ le neyn ke ria na Adar. N̂-ddaje ne-kusa ke bo dusaje, n̂-ddaje rɔ-neel ngaa dulaje ke ne dareje naa. ");
INSERT INTO ksp_vpl VALUES ("ET9_20","018_9_20","EST","9","20","20","Mardose dda tar neje ke nday le maketuru te. Goe te a, nula ke maketuru le nare Jiipije tɔyn ke isije bbe-kɔn te le tɔku mbay Asurusu. Dede ke bbeje te ke ngɔsi ddem ddew ew ddem. ");
INSERT INTO ksp_vpl VALUES ("ET9_21","018_9_21","EST","9","21","21","N̂-dujude ta kare n̂-ddaje kusu ke bbal tɔyn, ke ndɔ dɔku gire sɔ, ke ndɔ dɔku gire mi le neyn ke ria na Adar. ");
INSERT INTO ksp_vpl VALUES ("ET9_22","018_9_22","EST","9","22","22","Me ndɔje teenn le Jiipije tubbaje nje-baanje lede dɔde te ke ddang. Me neyn teenn le me-kɔn le Jiipije tel koko ngaa ndinga-ndoo lede tel kusu. To maji kare n̂-ddaje kusu ngaa n̂-ddaje rɔ-neel, to maji kare dulaje ke ne dare naa ngaa dareje ne nje-ndooje. ");
INSERT INTO ksp_vpl VALUES ("ET9_23","018_9_23","EST","9","23","23","Jiipije ooje ndu Mardose. N̂-ddaje kusu le gɔl kara ngaa kusu le tel to ne-ji-bbe lede. ");
INSERT INTO ksp_vpl VALUES ("ET9_24","018_9_24","EST","9","24","24","Mardose ole me Jiipije dɔ tar te le Amann na: Amann ngonn le Amedata, dew ke me nuju te le Agage, nje-baan le Jiipije ndiki ta tɔlde. N̂-dda elemteen mba gere ne ndɔ ke na tɔl ne Jiipije tɔyn. ");
INSERT INTO ksp_vpl VALUES ("ET9_25","018_9_25","EST","9","25","25","A Ester aw inga tɔku mbay ngaa nunn ndu, n̂-dda ndu le maketuru te ta kare n̂-dda ke Amann ne ke Amann ndiki ta dda ke Jiipije. Yeenn bba n̂-tɔ kula gɔsu Amann te n̂-tɔ kake te taar dare noy ngaa n̂-tɔl nganne n̂-naa ninnde kake te ke duru taar. ");
INSERT INTO ksp_vpl VALUES ("ET9_26","018_9_26","EST","9","26","26","Gele ke neenn bba daw n̂-bbar ne ri ndɔ kusu le na Purim, mba Purim le in me kande tar te ke to Pur. Jiipije ooje tar ke Mardose dda maketuru te le ke maje, n̂-ngemje neje ke dooje ke kemde ddem neje ke ingajede ddem. ");
INSERT INTO ksp_vpl VALUES ("ET9_27","018_9_27","EST","9","27","27","Jiipije ddaje kusu le to ne-ji-bbe lede wɔju dɔde njaa, wɔju dɔ ngande ngaa wɔju dɔ dewje tɔyn ke a ddaje rɔde Jiipije. Da ddaje kusu le ndɔ joo bbal ke bbal ddew kara baa toke Mardose pa arede maketuru te. ");
INSERT INTO ksp_vpl VALUES ("ET9_28","018_9_28","EST","9","28","28","Dewje tɔyn ke da kujude ndɔ te ke guku, dingawje, ke nje-ke lede kara kara tɔyn ke to Jiipije ke isije bbeje te kara kara tɔyn, ke bbuka bbeje te kara kara tɔyn me bbe-kɔn te le Asurusu a ddaje kusu me ndɔje teenn. Maji kare Jiipije, ke ngannde dinyaje kusu neenn le ang ddem dare mede oy dɔ ne ke nday le ang ddem. ");
INSERT INTO ksp_vpl VALUES ("ET9_29","018_9_29","EST","9","29","29","Ester dene-mbay ke to ngonn le Abiyayil de ke Mardose ke to Jiipi n̂-ddaje maketuru gɔl joo laa, mba pa ne tar ke ndu ke mɔngu dɔ maketuru te ke dɔngɔr, ke dɔ tar kusu te ke to Purim, kare Jiipije ooje to tar ndam ang. ");
INSERT INTO ksp_vpl VALUES ("ET9_30","018_9_30","EST","9","30","30","Dulaje ke maketuru dare Jiipije tɔyn ke isije bbeje te kɔr kara ke dɔjoo gire siri ke me bbe-kɔn te le tɔku mbay Asurusu. Tarje ke me maketuru te le, to tar ke ta kare disije ke me-wul-lɔm ddem kare Jiipije ddaje ne ke gate gate ddem. ");
INSERT INTO ksp_vpl VALUES ("ET9_31","018_9_31","EST","9","31","31","Maketuru le are ddew Jiipije ta kare n̂-ddaje kusu ke ria na Purim ke ndɔe ndɔe ddew kara baa toke Mardose de ke Ester n̂-ddaje maketuru te. Ndu le to wɔju dɔde, ke ngannde toke le ndu ke dunn dɔngɔr ta mbete ne-kusa, ke ta dda ndoo. ");
INSERT INTO ksp_vpl VALUES ("ET9_32","018_9_32","EST","9","32","32","Tarje le Ester tɔju to tar kusu Purim le to tar ke tɔkɔrɔ ngaa n̂-dda tare me maketuru te. ");
INSERT INTO ksp_vpl VALUES ("ET10_1","018_10_1","EST","10","1","1","Tɔku mbay Asurusu unn ndu are dewje ke me bbe-kɔn te laa, ke dewje ke isije dɔ dere maannje te ukaje lambo. ");
INSERT INTO ksp_vpl VALUES ("ET10_2","018_10_2","EST","10","2","2","Tar singa-mɔngu le tɔku mbay, tar ne-dingawje tɔyn ke n̂-dda, ke tar le Mardose ke nare ddee dew ke bo, tarjeenn tɔyn n̂-dda me maketuru te ke daw n̂-dda tarje le mbayje ke Medi, ke Perese te daw n̂-ngem. ");
INSERT INTO ksp_vpl VALUES ("ET10_3","018_10_3","EST","10","3","3","Mardose njaa to joo le dew ke bo go tɔku mbay Asurusu te me bbe-kɔn te le. Jiipije nya ndikeje ngaa bbeleje. N̂-sange kisi-maji le Jiipiji ngaa n̂-dda nare nje ke gele te isije ke me-wul-lɔm.");
INSERT INTO ksp_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Nje-kisi ke ndɔ ke ndɔ pa tar are Jonase, ngonn le Amitay na: ");
INSERT INTO ksp_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","« In taar, aw Ninibe ke to tɔku bbe, ila mber are dewje ke me bbe te le, mba me-maji ang lede tee nɔm te.» ");
INSERT INTO ksp_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Jonase in taar mba kayn kaw Tarsise ddew ew ke Nje-kisi ke ndɔ ndɔ. N̂-ddisi naw Japa ngaa ninga mare tɔku to ke aw aw ke Tarsise, nuka to le ngaa nal ke dewje ke Tarsise mba kaw ddew ew ke Nje-kisi ke ndɔ ke ndɔ. ");
INSERT INTO ksp_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","A Nje-kisi ke ndɔ ke ndɔ are tɔku lel ula dɔ ba te ngaa bamburanbo in dɔ ba te le. To le a ta tete danna. ");
INSERT INTO ksp_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Bbel dda nje-yelje-to le. Dede kara kara tɔyn daw n̂-nɔje ke rɔ kɔrje te lede ddem, n̂-tilaje ne-kotoje ke me to te le maânn mba kare tɔku to le wɔle. Jonase ddisi kete aw kutu to te le beer to nangê ngaa bbi tɔle. ");
INSERT INTO ksp_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Mbay le nje-yelje to le ddee saa ngɔsi ngaa pa are na: « Mbata ddi bba aw e-tibbi wa? In taar, e-nɔ ke rɔ kɔr te lei! A du ang, wungu laa ke dɔje te a gayn a ja koyje ang.» ");
INSERT INTO ksp_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Nje-yelje to le paje areje naa na: « E-ddeeje areje n-ddaje elemteen mba gere ne dew ke ila ndɔ dɔje te neenn.» N̂-ddaje elemteen le ngaa elemteen le oso dɔ Jonase te. ");
INSERT INTO ksp_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Yeenn a, n̂-paje dareje na: «E-pa areje joo na njaa gate a to nje-kila ndɔ dɔje te neenn wa? Aw dda kula ddi wa? In dda wa? Bbe lei dda wa? Geli in dda wa?» ");
INSERT INTO ksp_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Nilade te na: « M-to hebere, ngaa maw m-polo Nje-kisi ke ndɔ ke ndɔ, Lubba ke darâ ke nje-dda ba, ke dɔ nange.» ");
INSERT INTO ksp_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Bbel dda dewje le ngaa n̂-paje dare na: « Ne ddi a e-dda toke be wa!» Dewje le gereje to naw nayn Nje-kisi ke ndɔ ndɔ, mba Jonase ɔru gel tar le arede. ");
INSERT INTO ksp_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","N̂-dujeje na: « Ddi a ja dda sei bba ba le a kew rɔe ta lenge ke je wa?» Mbata ba le aw lenge ke singa ke kete kete. ");
INSERT INTO ksp_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Nilade te na: «Unnumje ilamje me ba te a, ba le a kew rɔe lenge ke se, mba m-gere to ema njaa m-dda bba bamburanbo neenn ingase.» ");
INSERT INTO ksp_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Dewje le ɔruje hay mba tee ta kongo te a, duma ne pin, mba ba le aw lenge ke de ke singa singa. ");
INSERT INTO ksp_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Baann a, n̂-dujuje Nje-kisi ke ndɔ ke ndɔ na: « Nje-kisi ke ndɔ ke ndɔ, n-dda rɔje to ndoo rɔi te, areje joy wɔju dɔ kula dda dingaw neenn ang, ngaa are tar yo le dew neenn ke dda ke je ne ang uwa dɔje ang! Mba ei, Nje-kisi ke ndɔ ke ndɔ, e-dda ne lei to ke mei ndiki.» ");
INSERT INTO ksp_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Yeenn a, dunnje Jonase dilaeje me ba te a, ba ke aw lenge ke singa le ew rɔe. ");
INSERT INTO ksp_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Bbel le Nje-kisi ke ndɔ ndɔ dda dewje le. Dareje ne-polo Nje-kisi ke ndɔ ke ndɔ ddem, dunnje ndude ddem. ");
INSERT INTO ksp_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Nje-kisi ke ndɔ ke ndɔ are tɔku kanji ddee uru Jonase. Jonase to ndɔ muta, ke til muta me kanji te le. ");
INSERT INTO ksp_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Jonase duju Nje-kisi ke ndɔ ke ndɔ ke to Lubba laa me kanji te: ");
INSERT INTO ksp_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","N̂-pa na: «Me ne wungu te ke ingam, m-duji ei Nje-kisi ke ndɔ ke ndɔ, a ilam te. Lo te le nje-yoje m-bbari kare umam a, oo ndum. ");
INSERT INTO ksp_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Ilam gel maann te beer dann ba te, maann ke aw ula guku dɔm, maann ke e-dda are aw kuja, maann ke e-dda are aw lenge nday dɔm te. ");
INSERT INTO ksp_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","A ema m-pa na: « E-tubbam ilam ddew ew sei! A kem a koo key lei ke maji tɔyn bbay.» ");
INSERT INTO ksp_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Maann uwam gɔsem te. Buja ubbam, mu bbiri dɔm te. ");
INSERT INTO ksp_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","M-ddisi ndereng gɔl ddingirije te. Nange utu tae dɔm te nyɔm. A, ei, Nje-kisi ke ndɔ ke ndɔ Lubba lem ɔrum kem baa me buja te! ");
INSERT INTO ksp_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Kare ke singam goto a, mole mem dɔ ei Nje-kisi ke ndɔ ke ndɔ te, ngaa tar-duju lem aw ndereng tee rɔi te me key te lei ke maji tɔyn. ");
INSERT INTO ksp_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Dewje ke undaje mede dɔ kɔrje te ke to neje ke baa daw n̂-tubbaje neje ke maji rɔde te ke ddang. ");
INSERT INTO ksp_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","A ema, ma kari ne-polo ke pa tam te ta kari ne wooyo. Ma dda ne ke munn ndum ta dda. Kaji to me ji Nje-kisi ke ndɔ ke ndɔ te.» ");
INSERT INTO ksp_vpl VALUES ("JH2_11","033_2_11","JON","2","11","11","Nje-kisi ke ndɔ ke ndɔ unn ndu are kanji le ngaa kanji le tɔmɔ Jonase ilae dɔ nange te ke tutu. ");
INSERT INTO ksp_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Nje-kisi ke ndɔ ke ndɔ tel pa tar gɔl joo laa are Jonase na: ");
INSERT INTO ksp_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","« In taar, aw Ninibe ke to tɔku bbe, ila mber-tar ke m-pa mari.» ");
INSERT INTO ksp_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Jonase in taar aw Ninibe toke Nje-kisi ke ndɔ ke ndɔ pa. Kem Lubba te, Ninibe to tɔku bbe ke dew a dda ndɔ muta bba a nja te nunga. ");
INSERT INTO ksp_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Jonase unn kutu kila mber nja ne ndɔ kara me bbe te le. N̂-pa ke taar na: « Ndɔ dɔsɔ a, bbe ke Ninibe a tuju!» ");
INSERT INTO ksp_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Dewje ke Ninibe unnje mede are Lubba. Dilaje mber n̂-mbeteje ne ne-kusa, dulaje kubbu ndoo, dewje ke bo ddem dewje ngaji ddem. ");
INSERT INTO ksp_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Toke mbay ke Ninibe oo tar le a, ubba nange nin ngende-mbay te laa, ɔru kubbu mbay laa, ula kubbu ndoo, ngaa isi dɔ bu te. ");
INSERT INTO ksp_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Nare dila mber me bbe te ke Ninibe na: « Mbay, ke nje ke ta-gɔle te dunnje ndu na, maji kare dewje, ke ne-kuulje ke bo, ke ne-kulje ke ngaji dusaje ne ang ddem, dayje maann ang ddem. ");
INSERT INTO ksp_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Maji kare dewje ddem, daje ddem, ulaje kubbu ndoo. Maji kare n̂-nɔje rɔ Lubba te ke singa, ngaa maji kare dinyaje kula-ddaje lede ke maji ang, ke ne-ddaje lede ke singa singa ke to mesede te! ");
INSERT INTO ksp_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Dew gere ang se Lubba a turu ndue, na kinya wungu laa ngaa na kare joyje ang wa?» ");
INSERT INTO ksp_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Lubba oo ne ke n̂-ddaje baann ngaa n̂-mbeteje kula-ddaje ke maji ang le. Yeenn a, Lubba turu ndue ngaa nila ne-wungu ke nila mbere ta kila dɔde te le ang. ");
INSERT INTO ksp_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Jonase oo nejeenn le a, neele ang are wungu ɔen. ");
INSERT INTO ksp_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","N̂-duju Nje-kisi ke ndɔ ke ndɔ: «Aay! Nje-kisi ke ndɔ ke ndɔ, tar ke m-nayn bbê bbay a m-pa le a neenn ang wa? Ne ke m-ndiki ta kare to ang bba mayn ke Tarsis le a neenn. Mba m-gere to e-to Lubba ke Nje-dda me-maji, ke Nje-koo kem to ndoo le dewje. Wungu ɔin ke ngɔru ang. Ngaa e-ndiki kisi-maji le dew. Aw e-turu ndui wɔju dɔ majang ke e-ndiki ta dda ke dew. ");
INSERT INTO ksp_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Bbasine, Nje-kisi ke ndɔ ke ndɔ, e-taa kewn lem. Mba koy lem maji uta kisi lem kem baa.» ");
INSERT INTO ksp_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Nje-kisi ke ndɔ ke ndɔ ila te na: «Wungu ke e-dda to ke dɔgɔle wa?» ");
INSERT INTO ksp_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Jonase tee me tɔku bbe te le isi er ke kem kare te. N̂-dda mare key-kam lo teenn nisi kɔ ndile te mba koo ne ke a ddee dɔ tɔku bbe te le. ");
INSERT INTO ksp_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Nje-kisi ke ndɔ ke ndɔ, Lubba are ka tee ale dɔ key te le Jonase, mba kare Jonase inga ndil kula dɔe ddem, mba kɔru ne kejeje ke maji ang ke aw jɔku Jonase ddem. Jonase inga koko nya ddew ka te ke ale le. ");
INSERT INTO ksp_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","A ndɔ kara goe te, ta lo-kare te a, Lubba ula mare kuur are usa ka le are ka le oy njan. ");
INSERT INTO ksp_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Kare ubba me dara te a, Lubba are lel ke tunga piti piti in kem kare te ula ngaa kare ɔsu dɔ Jonase te ndereng singa Jonase goto. N̂-ndinga yo na: « Koy lem maji uta kisi lem kem baa.» ");
INSERT INTO ksp_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","A Lubba pa are Jonase na: « Wungu ke aw dda mba ka le to ke dɔgɔle wa?» Nila te na: « To ke dɔgɔle kare m-dda wungu ndereng m-ndinga yom.» ");
INSERT INTO ksp_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Nje-kisi ke ndɔ ndɔ pa na: « Ei, oo kem to ndoo le ka ke ari kula ang, ei a e-dda are ndu ang. Ka ke tee mare til te ngaa oy mare til te tɔ. ");
INSERT INTO ksp_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","A, Ninibe ke to tɔku bbe ke dewje ke kɔrde uta doro kɔr kara ke dɔjoo isije te. Dewje le gereje dɔjide ke kɔl ke ye ke gel ang ngaa daje kara banyaje nya me te, ema, e-ndiki ta kare moo kem-to-ndoo laa ang wa?»");
INSERT INTO ksp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ri gel dewje ke ujuje Jeju-Kiriste toke be: Jeju Kiriste to dew ke gel Dabbiti te, ngaa Dabbiti to dew ke gel Abaraham te. ");
INSERT INTO ksp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abaraham uju Ijake. Ijake uju Jakobbo. Jakobbo uju Juda ke ngakɔenje. ");
INSERT INTO ksp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda de ke Tamar dujuje Pareje de ke jara. Pareje uju Eserɔm. Eserɔm uju Aram. ");
INSERT INTO ksp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram uju Aminadab. Aminadab uju Naasɔn. Naasɔn uju Salmɔ. ");
INSERT INTO ksp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmɔ de ke Rahabe dujuje Bowaje. Bowaje de ke Rutu dujuje Obede. ");
INSERT INTO ksp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Obede uju Ijayi. Ijayi uju tɔku mbay Dabbiti. Dabbiti de ke dene le Uri dujuje Salemɔ. ");
INSERT INTO ksp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salemɔ uju Robowam. Robowam uju Abiya. Abiya uju Aja. ");
INSERT INTO ksp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aja uju Jojapa. Jojapa uju Joram. Joram uju Ojiyase. ");
INSERT INTO ksp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ojiyase uju Jotam. Jotam uju Akaje. Akaje uju Ejekiyase. ");
INSERT INTO ksp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ejekiyase uju Manase. Manase uju Amɔ. Amɔ uju Jojiyase. ");
INSERT INTO ksp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jojiyase uju Jekoniyase ke ngakɔenje. Bbale teenn a daw ne ke ngann Ijarayelje to bbereje bbe te ke Babilɔnn. ");
INSERT INTO ksp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Go kuwa te ke duwade daw ne to bbereje Babilɔnn a, Jekoniyase uju Salatiyel. Salatiyel uju Jorobabel. ");
INSERT INTO ksp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jorobabel uju Abiyutu. Abiyutu uju Eliyakim. Eliyakim uju Ajɔr. ");
INSERT INTO ksp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ajɔr uju Sadoku. Sadoku uju Akim. Akim uju Eliyudu. ");
INSERT INTO ksp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyudu uju Eliyajar. Eliyajar uju Matan. Matan uju Jakobbo. ");
INSERT INTO ksp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakobbo uju Jejebbe ngaw le Marije ke to kɔn Jejuje ke daw n̂-bbare to Kiriste. ");
INSERT INTO ksp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Unn kute dɔ Abaraham te ndereng Dabbiti te, buwa kuju dewje kara kara tee dɔku gire sɔ. Unn kute dɔ Dabbiti te ndereng kare te ke daw ne kede bbe-bbere te ke Babilɔnn, buwa kuju dewje kara kara tee dɔku gire sɔ. Unn kute dɔ ndɔ bbere te lede ke Babilɔnn ndereng ndɔ te le Kiriste, buwa kuju dewje kara kara tee dɔku gire sɔ. ");
INSERT INTO ksp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Tar kuju Jeju Kiriste toke be: Jejebbe aw aw mɔrɔ le Mari kɔn Jejuje. N̂-nayn n̂-taa naa ang bbay a, Mari le uwa sem ddew te le Ndil-me-nda. ");
INSERT INTO ksp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jejebbe nje-mɔrɔ laa le to dingaw ke gate gate, ngaa ndiki ta tee ke tare ke ddaka kem dewje te ang. Yeenn a n̂-diki ta kinyae hɔy baa. ");
INSERT INTO ksp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Toke Jejebbe aw eje tar neenn le mee te bbay a, mare anji le Ebbe-dewje tee ingae me ni te ngaa pa are na: «Jejebbe dew ke gel Dabbiti te, are bbeel ddai ang bbo e-taa Mari to dene lei, mba sem le ngonn ke to mee te le ddee ddew te le Ndil-me-nda. ");
INSERT INTO ksp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Na kuju ngonn ke dingaw, ta a kunda ria na Jeju, mba ne a na kaji dewje laa me majangje te lede.» ");
INSERT INTO ksp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nejeenn tɔyn teeje mba kare tar ke Ebbe-dewje unda ta nje-kila mber-tar laa are pa ddee to tar ke tɔkɔrɔ. Tar le na: ");
INSERT INTO ksp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Ngonn mande ke gere ngaw ang a kuwa sem, na kuju ngonn ke dingaw, ngaa da kunda ria na Emanuwel.» Gel ri le na: Lubba ee ke je. ");
INSERT INTO ksp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Toke Jejebbe le ndol a dda ne ke anji le Ebbe-dewje pa are le, ngaa n̂-taa Mari to dene laa. ");
INSERT INTO ksp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","A, n̂-mbɔn saa naa ang ndereng Mari le uju ne ngonn ke dingaw, ngaa Jejebbe unda ri ngonn le na Jeju. ");
INSERT INTO ksp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Duju Jeju me bbe te ke Betelehem, dɔ nange Jude te, kare te ke Erodeto ne to tɔku-mbay. Goe te a, nje-ne-gereje inje er ke lo tee te le kare, n̂-teeje Jurusalam, ");
INSERT INTO ksp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ngaa n̂-dujuje na: «Tɔku-mbay le Jiipije ke duje le ee dda wa? Mba joo endenterenden laa er ke lo tee te le kare, are n-ddee ta poloe.» ");
INSERT INTO ksp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Toke Erodeoo tar le a, mee sange nya, ngaa dewje tɔyn ke Jurusalam kara mede sangede tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","N̂-mbɔn tɔke nje-poloje Lubba tɔyn, ke nje kɔruje gel ndu ngaa n̂-dujude se lo ke dda bba duju Kiriste te wa? ");
INSERT INTO ksp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","N̂-paje dareje na: «Duje me bbe te ke Betelehem, dɔ nange Jude te mba nje-kila mber-tar le Lubba dda tare Maketuru te na: ");
INSERT INTO ksp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Ei ke Betelehem, ke nange te le Juda, e-to ten baa horo ngann bbeje te ke nange te ke Juda ang. Mba nje-kɔn bbe a kin mei te tee ta kɔru nɔ dewje lem, ngann Ijarayelje.› » ");
INSERT INTO ksp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Erode ula bbar nje ne-gereje le lo-kiyae te dujude ta gere ndɔ ke endenterenden le tee ne. ");
INSERT INTO ksp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Goe te a, nulade Betelehem, n̂-pa narede na: «Awje aw dujuje tar dɔ ngonn te le ke maje ta bbo ingaeje a, e-ddeeje e-paje are ema kara maw m-poloe tɔ.» ");
INSERT INTO ksp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Goe te ke dooje tar le tɔku-mbay le a, dawje. A endeterenden ke dooje kete lo tee te le kare le ɔru nɔde aw ke de ndereng aw ar dɔ lo te ke ngonn le to te. ");
INSERT INTO ksp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Rɔ nje-ne-gerje le nelde nya wɔju dɔ endeterenden ke dooje le. ");
INSERT INTO ksp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Dandeje me key te ngaa dooje ngonn le, de ke kɔenje Mari. Dɔsuje gɔlde nangê ngaa n̂-poloeje. N̂-teynje ta bɔlje lede ngaa dareje neje ke toke, ande, ke yambo, ke ubbu ne ke ria na mir. ");
INSERT INTO ksp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Goe te a, Lubba ndɔru mbide me ni te kare n̂-telje rɔ Erode te ang, a dunnje ddew ke dang n̂-telje ne bbe lede. ");
INSERT INTO ksp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Go kɔte te le nje-ne-gereje le a, anji le Ebbe-dewje ddee ke ni dɔ Jejebbe te ngaa pa are na: «In taar, unn ngonn le de ke kɔenje bbo ayn aw Ejipite ta e-nayn nunn ndereng ndɔ ke ma pa kari kare e-tel, mba Erode a sange ddew ta tɔl ngonn le.» ");
INSERT INTO ksp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tile teenn njaa, Jejebbe in taar unn ngonn le de ke kɔenje ngaa dawje Ejipite. ");
INSERT INTO ksp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","N̂-nayn nunn ndereng Erode oy. Yeenn bba tar ke Ebbe-ddewje pa ddew te le nje-kila mber-tar le ddee to tar ke tɔkɔrɔ. N̂-pa na: «M-bbar ngunum kare tee nange te ke Ejipite ke ddang.» ");
INSERT INTO ksp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Toke Erode gere to nje ne-gereje le ereje a, ungu ɔen nya. Yeenn a nunn ndu kare n̂-tɔl ngannje ke dingaw ke bbalde joo wase bbalde aw ngɔsi ke bbal joo me bbe te ke Betelehem, ke me bbeje te ke mbɔre te, ase kem ndɔ ke nje ne-gereje turaje are. ");
INSERT INTO ksp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Yeenn ngaa tar ke Jeremi nje-kila mber-tar le Lubba pa ddee to tar ke tɔkɔrɔ. N̂-pa na: ");
INSERT INTO ksp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Ko bbar me bbe te ke Rama, ndu-nɔ ke ndinga-rɔ uta dɔe. Rasel a aw nɔ nganne. N̂-ndiki ta koo ndeje ang, mba nganne gotoje ngaa.» ");
INSERT INTO ksp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Go koy te le Erode a, anji le Ebbe-dewje ddee dɔ Jejebbe te ke ni me bbe te ke Egipite. ");
INSERT INTO ksp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Anji pa na: «In taar bbo unn ngonn le de ke kɔenje, ta e-tel nange Ijarayel te, mba nje ke aw sangeje ngonn neenn ta tɔle le oyje mban.» ");
INSERT INTO ksp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jejebbe in taar, unn ngonn le de ke kɔenje ngaa n̂-tel ke de nange te ke Ijarayel. ");
INSERT INTO ksp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Toke Jejebbe oo na Arekelayusu ngaa ɔn bbe nange te ke Jude turu bɔeje Erode te a, bbel ddae ta tel. A Lubba pa tar are ke ni ngaa naw nange te ke Galile. ");
INSERT INTO ksp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Naw ngaa n̂-dda bbe ke ria na Najarete. Yeenn bba kare tar ke nje-kilaje mber-tar le Lubba paje le ddee ne to tar ke tɔkɔrɔ. Da bbare to dew ke Najarete. ");
INSERT INTO ksp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Dɔ ndɔe teenn Jan Batisi tee me kɔr te ke Jude ngaa aw ila mber. ");
INSERT INTO ksp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","N̂-pa na: «E-turuje ddew lese mba Bbe-kɔn ke darâ e ngɔsi.» ");
INSERT INTO ksp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ejayi nje-kila mber-tar le Lubba pa tar le Jan neenn le lew na: «Mare dew ila mber me kɔr te na: ‹E-mɔseje ddew le Ebbe-dewje. E-ddaje ngann ddewje laa areje ndɔju njarara.› » ");
INSERT INTO ksp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jan le ula kubbu ke n̂-dda ke biin jambal, ngaa n̂-tɔ bbere ke endaar. Ne-kusa laa to ebeteje ke ubbu teje ke me kɔr te. ");
INSERT INTO ksp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Dewje ke Jurusalam, dewje ke Jude tɔyn, ke dewje ke bbeje te ke guku dɔ maann Jurden ddeeje rɔe te. ");
INSERT INTO ksp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","N̂-paje tar majangje lede ke ddaka ngaa Jan le ddade batem maann Jurden te. ");
INSERT INTO ksp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Toke Jan oo Parijiyenje ke Saduseyenje banya banya ke ddeeje kare n̂-ddade batem le a, n̂-pa narede na: «See embakanraje, na ulase kare aynje sariya le Lubba ke aw ddee wa? ");
INSERT INTO ksp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Areje kula ddase tɔju to e-turuje ddew lese mban. ");
INSERT INTO ksp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Aw ejeje mese te e-paje na Abaraham to kajeje. Yeenn njaa kara baa ase ang. Mba m-pa marese: Lubba ase ta turu erje neenn kare telje to ngannka Abaraham. ");
INSERT INTO ksp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tina to ngɔsi baa ta tuka ne kakeje ngirade te mban. Kake ke ande kande ke maji ang a da tuka kila poro. ");
INSERT INTO ksp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ema, m-ddase batem maann ta tɔju to e-turuje ddew lese. A dew ke aw ddee gom te, singae utam. Ne-gɔl laa kara mase kɔru gɔle te ang. Ne, na ddase batem Ndil-me-nda ke batem puru. ");
INSERT INTO ksp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nuwa ne to kande koo laa jia te. Na kuta ta paal laa. Na kɔru kem koo laa kungu damâ, a na ro tisa kem puru te ke a koy ndɔ kara ang.» ");
INSERT INTO ksp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Me ndɔje teenn Jeju in nange te ke Galile, ddee rɔ Jan te ta maann te ke Jurden kare ddae batem. ");
INSERT INTO ksp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","A Jan a ta mbete, ngaa pa are Jeju le na: «Ema a, a ddam batem, a ei a e-ddee rɔm te wa?» ");
INSERT INTO ksp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","A Jeju ilae te na: «Ke bbasine neenn, e-ndiki te bbo e-dda toke baann. Mba to maji kare n-ddaje ne tɔyn ke to gate gate toke baann.» Yeenn ngaa, Jan le ndiki te saa. ");
INSERT INTO ksp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kake Jeju inga batem, ngaa tee me maann te a, kare teenn njaa ta dara teyn. Ngaa noo Ndil le Lubba ddisi dɔe te toke le der jeenn. ");
INSERT INTO ksp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ndu Lubba in me dara te bbar na: «Ne neenn n̂-to ngonum ke m-ndike nya. Minga rɔ-neel ddew te laa nya.» ");
INSERT INTO ksp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Goe te a Ndil aw ke Jeju me kɔr te mba kare Esu nae. ");
INSERT INTO ksp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jeju mbete ne-kusa ndɔ dɔsɔ til dɔsɔ tɔ ngaa bbo ddae. ");
INSERT INTO ksp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Esu nje-na-dewje ddee ngɔsi saa ngaa pa na: «Toke e-to ngonn le Lubba a unn ndui are erje neenn telje ne-kusa.» ");
INSERT INTO ksp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jeju ilae te na: «Maketuru le Lubba pa na: ‹Dew a kisi ke tebbe ddew ne-kusa te kara baa ang. Na kisi ke tebbe ddew tar te tɔyn ke tee ta Lubba te.› » ");
INSERT INTO ksp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Goe te a Esu le aw saa Jurusalam ke to bbe ke maji tɔyn. Naw nilae lum dɔ key-polo-Lubba te, ");
INSERT INTO ksp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ngaa n̂-pa nare na: « Toke e-to ngonn le Lubba a, in dɔ key te neenn oso nangê mba Maketuru le Lubba pa na: ‹Lubba a kunn ndu kare anjije laa wɔju dɔi, ngaa da lai to la kare unda gɔli er te ang.› » ");
INSERT INTO ksp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jeju ilae te na: « Maketuru le Lubba pa tɔ bbay na: ‹Ebbe-dewje ke to Lubba lei le a nae ang.› » ");
INSERT INTO ksp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Esu tel aw saa dɔ ddingiri te ke ndew nya ngaa tɔje bbe-kɔnje tɔyn ke dɔ nange te ke neje ke kura ke me te, ");
INSERT INTO ksp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ngaa pa are na: «Toke ɔsu gɔli nɔm te, ngaa e-polom a, ma kari neje neenn tɔyn.» ");
INSERT INTO ksp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yeenn a Jeju pa are na: «Ɔtu ke ddang, Satan! Mba Maketurule Lubba pa na: ‹Maji kare Ebbe-dewje ke to Lubba lei njaa kara baa a ɔsu gɔli nɔe te, ta ne kara baa a e-dda saa tɔ.› » ");
INSERT INTO ksp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yeenn ngaa Esu le ɔtu inyae, a goe te a, anjije ddeeje rɔe te ngaa ddaje saa. ");
INSERT INTO ksp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Toke Jeju oo na dila Jan key kula te a, nɔru rɔe naw nange te ke Galile. ");
INSERT INTO ksp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ninya Najarete a naw nisi Kapernayum kare tɔke dange te, nange te le Jabulɔn, ke le Nepetali. ");
INSERT INTO ksp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","N-dda baann kare tar le Ejayi nje-kila mber-tar le Lubba ddee ne to tar ke tɔkɔrɔ. Tar le na: ");
INSERT INTO ksp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Nange le Jabulɔn, ke le Nepetali, ke toje ddew ba-kate te, tura maann Jurden te, ke to Galile, nange le dewje ke toje to Jiipije ang. ");
INSERT INTO ksp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Dewje ke isije me til te ooje tɔku lo-kare ke. Lo a kare dɔ dewje te ke isije dɔ nange yo te ke il biti biti.» ");
INSERT INTO ksp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Un kute kare teenn njaa, Jeju unn kutu kila mber na: «E-turuje ddew lese mba Bbe-kɔn ke darâ e ngɔsi.» ");
INSERT INTO ksp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Toke Jeju aw nja kar tɔku dange te ke Galile a, noo ngakɔn naaje joo: Simɔ ke daw n̂-bbare na Piyar de ke ngokɔen Andere. Daw dilaje ddenge tɔku dange te le mba n̂-toje to nje-ndɔn̂-maannje. ");
INSERT INTO ksp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jeju le pa arede na: «Unnje gom. Ma ddase to nje-sangeje dewje.» ");
INSERT INTO ksp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Njange baa njaa a, dinyaje ddengeje lede a dunnje goe. ");
INSERT INTO ksp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jeju aw ngaji ke kete a oo mare ngakɔn naaje joo: Jake de ke Jan ngann le Jebede. Deeje me tɔku to te ke bɔdede Jebede le, daw n̂-mɔseje ddengeje lede, ngaa Jeju le bbarde. ");
INSERT INTO ksp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Njange baa njaa a, dinyaje tɔku to lede ddem, bɔdede ddem ngaa dunnje go Jeju le. ");
INSERT INTO ksp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jeju nja nange te ke Galile tɔyn. Naw n̂-tɔju ne dewje me key-mbɔn naaje te le Jiipije ke nange teenn ngaa, nila mber Tar ke maji ke wɔju dɔ Bbe-kɔn le Lubba. Nɔru rɔ-toje tɔyn rɔ dewje te, ngaa n̂-dda nare dewje ke debbe rɔde tuju ddeeje maji. ");
INSERT INTO ksp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ri Jeju bbar dɔ nange Siri te tɔyn are dewje ddeeje ke nje-rɔ-toje dang dang rɔe te: dede ke rɔ-toje dang dang ula kemde ndoo, nje ke eeje ke ndilje ke maji ang, nje-dɔ-kilaje ke nje ke debbe rɔde oy ngaa Jeju ɔru ro-to rɔde te. ");
INSERT INTO ksp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Dewje banya banya unnje goe. Dinje nange te ke Galile, ke nange Tɔku Bbeje ke Dɔku. Mareje inje Jurusalam, ke nange te ke Jude, ke nange te ke to tura Jurden te. ");
INSERT INTO ksp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Toke Jeju oo dewje ke banya le a, aal dɔ ddingiri isi te ngaa nje-njaje goe te awje rɔe te tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nunn kutu tɔjude ne toke be: ");
INSERT INTO ksp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Rɔ-nel to mba dewje ke gereje to, n̂-toje to nje-ndooje ddew keje te lede, mba Bbe-kɔn ke darâ to lede. ");
INSERT INTO ksp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Rɔ-nel to mba dewje ke aw nɔnje, mba Lubba a wul mede. ");
INSERT INTO ksp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Rɔ-nel to mba dewje ke wulje pe, mba Lubba a karede nange neenn to lede. ");
INSERT INTO ksp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Rɔ-nel to mba dewje ke isije ke bbo nya ta dda ne ke gate gate, mba Lubba a karede ne ke mede ndiki. ");
INSERT INTO ksp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Rɔ-nel to mba dewje ke aw ooje kem-to-ndoo le nga-mardeje, mba Lubba a koo kem-to-ndoo lede tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Rɔ-nel to mba dewje ke mede nda kayn, mba da kooje Lubba. ");
INSERT INTO ksp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Rɔ-nel to mba dewje ke aw ddaje are me-wul lɔm to horo dewje te, mba Lubba a bbarde to nganne. ");
INSERT INTO ksp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Rɔ-nel to mba dewje ke daw dula kemde ndoo, wɔju dɔ kula-ddade ke to gate gate, mba Bbe-kɔn ke darâ to lede. ");
INSERT INTO ksp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Areje rɔse nelse, toke dewje aw tajise, toke daw dula kemse ndoo, toke daw n̂-paje tarje ke majang dang dang, ke to tar ngemje baa dɔse te wɔju dɔm. ");
INSERT INTO ksp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","E-ddaje rɔ-nel, isije ke koko, mba kuka lese ke darâ a bo nya. Nje-kilaje mber-tar le Lubba ke kete arese kara, n̂-ddaje singa ke de toke baann tɔ.» ");
INSERT INTO ksp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Sese a e-toje to kate ke nangê neenn. A bbo kate neel ang ngaa a, ddi bba dew a dda kare kate le tel neel bbay wa? Mare ne dang ke ta dda ne goto. To ne kungu kɔrɔ kare dewje mbɔynje ke gɔlde. ");
INSERT INTO ksp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«E-toje to lo-kare ke nangê neenn. Bbe ke n̂-dda dɔ ddingiri te a kase kiya rɔe ang. ");
INSERT INTO ksp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Dew unda puru lambe te a, a kaw kunda kɔy joo te ang. Na kunda dɔ ne te taar kare nje-keyje le tɔyn ooje ne lo. ");
INSERT INTO ksp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ddew kara baa, areje ndoko lese to kem dewje te tɔyn. Yeenn bba da kooje kula ddase ke maji, ngaa da kɔsu ne gaji Bɔsese ke isi darâ.» ");
INSERT INTO ksp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Ejeje to m-ddee ta tuju Ndu le Moyiji wase ne-tɔjuje le nje-kilaje mber-tar le Lubba wa? M-ddee ta tuju nejeenn ang. M-ddee ta dda kare dewje ooje kande tarje ke me nduje tenn le ke maje. ");
INSERT INTO ksp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tɔkɔrɔ njaa m-pa marese, kare ke dara ke nange n̂-naynje bbay a, mare ngonn gɔl maketuru wase mare mbita gɔl Maketuru-Ndu a koso nangê ang, ndereng ddutu ndɔ te. ");
INSERT INTO ksp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","«Bbo dew mbete mare ngonn tar kara ke me ndu te, ngaa tɔju dewje are mbeteje ndu le a, na ddee to dew ke ten baa uta kese dewje tɔyn me Bbe-kɔn te ke darâ. A bbo dew ngem Ndu, ngaa tɔju dewje kare ngemje tɔ a, na ddee to dew ke bo me Bbe-kɔn te ke dara. ");
INSERT INTO ksp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","M-pa marese: Bbo e-ddaje ne ke gate gate uta nje-kɔruje gel Ndu wase Parijiyenje ang a, a kandeje me Bbe-kɔn te ke darâ ang.» ");
INSERT INTO ksp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Ooje na n̂-pa dare kaseseje lew na: E-tɔl dew ang, mba da gange sariya dɔ dew te ke tɔl dew mare. ");
INSERT INTO ksp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","A ema, m-pa marese: ‹Bbo dew dda wungu ke ngokɔen a, ase kare n̂-gange sariya dɔe te. Bbo dew bbar ngokɔen mbe a, nase kare daw saa nɔ sariya te. A bbo dew bbar ngokɔen woy a, nase kare dilae kem puru te ke aw ɔn ke ndɔ ke ndɔ.› ");
INSERT INTO ksp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","«Bbo aw nɔ baann te ke ne-kare-baa lei, a bbo mei ole to ngokɔin ee sei ke tar a, ");
INSERT INTO ksp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","maji kare inya ne-kare-baa lei le nɔ baann teenn, a aw dɔngɔr rɔ ngokɔin te le e-gɔl saa tar bba goe te a, e-ddee are ne-kare-baa lei le Lubba. ");
INSERT INTO ksp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Toke dew ke ee sei ke tar aw sei ke lo gange sariya te, a e-naynje ddew-bô bbay a, maji kare e-gɔl saa tar njange. Baann ang a, na kilai ji nje-gange sariya te, ngaa nje-gange sariya a kilai ji mbambaje te kare dilai key-kula te. ");
INSERT INTO ksp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tɔkɔrɔ njaa m-pa mari, toke uka nare ke da kɔju dɔi te tɔyn tunga ang a, a tee key-kula teenn ang nyɔm.» ");
INSERT INTO ksp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Ooje na n̂-pa lew dare kaseseje na: E-dda lo-to majang ang. ");
INSERT INTO ksp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","A ema, m-pa marese: dew ke aa dene le nje-mare ngaa dda bbo laa a, dew le dda saa lo-to maji ang mee te mban. ");
INSERT INTO ksp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Toke kemi ke kɔl dda are oso majang te a, ɔru ila kɔrɔ ddew ew. Mba bbo debbe rɔi kara a goto a, maji uta kare da-rɔi tɔyn njaa aw kem puru te ke aw ɔn ke ndɔ ke ndɔ. ");
INSERT INTO ksp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","A bbo jii ke kɔl dda are oso me majang te a, e-gange ila kɔrɔ ddew ew. Mba bbo debbe rɔi kara a goto a, maji uta kare da-rɔi tɔyn njaa aw kem puru te ke aw ɔn ke ndɔ ke ndɔ.» ");
INSERT INTO ksp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«N̂-pa lew tɔ na: Toke dew tubba dene laa a, maji kare n̂-dda maketuru kinya-naa nula jia te. ");
INSERT INTO ksp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","A ema, m-pa marese: Toke dene dda lo-to-majang ang, a bbo ngaweje tubbae a, dingaw le a dda kare dene le dda lo-to-majang. Ngaa toke dingaw taa dene ke ngaweje inyae a, dingaw le dda lo-to-majang tɔ.» ");
INSERT INTO ksp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ooje na n̂-pa dare kaseseje lew na: Unda yo ang. Ne ke unda yo kem Ebbe-dewje te ta dda a, maji kare e-dda ne le. ");
INSERT INTO ksp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","A ema, m-pa marese: Dang bba undaje yo ang. Undaje yo ke ri dara ang, mba dara to ngende-mbay le Lubba. ");
INSERT INTO ksp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Undaje yo ke ri nange ang tɔ, mba nange to lo kungu gɔle. Undaje yo ke ri Jurusalam ang, mba Jurusalam to bbe le Tɔke-Mbay. ");
INSERT INTO ksp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Unn dangara dɔi unda ne yo ang, mba ase ta dda kare ben dɔi kara nda wase ndul ang. ");
INSERT INTO ksp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","A maji kare e-paje na: Ye njaa ann, ye njaa ann. Wase ye ang, ye ang. A bbo ilaje mare tar dɔe te a, to tar ke in rɔ Nje-Me-Majang te ann.» ");
INSERT INTO ksp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ooje na n̂-pa lew na: Toke e-tɔ kem dew a da tɔ kemi. Toke e-guru ngange dew a da guru ngangi. ");
INSERT INTO ksp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","«A ema, m-pa marese: Ilaje bare ang. Toke dew unda ka-mbɔri ke kɔl a, e-turu ye ke gel are nunda tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","A bbo dew aw sei sariya te ta taa dɔ-kubbu lei ke taar a, inya kubbu kul lei are tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Bbo dew uwai ke gu kare e-nja saa kula-metere kara a, e-nja saa kula-metere joo. ");
INSERT INTO ksp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Toke dew duji ne a are. Ngaa bbo dew duju ta tunai ne a ɔke ang.» ");
INSERT INTO ksp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Ooje na n̂-pa lew na: Maji kare e-ndiki nje-mari. A e-mbete nje-baan lei. ");
INSERT INTO ksp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","A ema, m-pa marese: E-ndikije nje-baanje lese, ngaa e-dujuje Lubba wɔju dɔ dewje ke aw ulaje kemse ndoo. ");
INSERT INTO ksp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Yeenn bba a toje to ngann le Bɔsese ke isi darâ. Mba naw n̂-dda nare kare laa ɔsu dɔ dewje te ke majije ang ke dɔ dewje te ke majije tɔ. Naw n̂-dda nare ndi aw ere dɔ dewje te ke pa-nja lede to ke dɔgɔle ddem, dɔ dewje te ke pa-nja lede to ke dɔgɔle ang ddem. ");
INSERT INTO ksp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Toke dewje ke ndikise dɔrɔ a, e-ndikijede a, kuka ddi bba a kingaje ji Lubba te wa? Nje-taaje nare-lambo kara ddaje toke baann tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","A bbo ngakɔnse njaa a, e-ddajede lapiya a, ddi ke dang boy a e-ddaje wa? Dewje ke gereje Lubba ang kara ddaje toke baann tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yeenn a, maji kare e-ddeeje to dewje ke maji tɔyn ddew kara baa toke Bɔsese ke isi darâ maji tɔyn.» ");
INSERT INTO ksp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«E-ngemje ddew lese ke maje: Toke e-ddaje ne ddew Ndu te le Lubba a, e-ddaje ne le kem dewje te tɔyn kare daase ang. Baann ang a, Bɔsese ke isi darâ a kukase ang. ");
INSERT INTO ksp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","«Yeenn a, toke aw are ne nje-ndoje a, maji kare uru ne ekii ang. Mba nje-ngemje aw ddaje toke baann me key-mbɔ-naa te le Jiipije, wase go ddew te mba kinga ne piti ta dewje te. Tɔkɔrɔ njaa, m-pa marese, dingaje kuka lede mban. ");
INSERT INTO ksp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","A bbo are ne nje-ndoo ke jii ke kɔl a, are jii ke gel gere ang. ");
INSERT INTO ksp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yeenn bba ne ke are le a to lo-kiyae te. Bɔije Lubba ke oo ne ke to lo-kiyae te le a kukai.» ");
INSERT INTO ksp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Toke aw dujuje Lubba a, e-ddaje toke le nje-ngemje ang. Dede n̂-ndikije nya ta kar taar bba duju Lubba me key-mbɔ-naaje te wase tɔ-ddewje te ta kare dewje tɔyn oojede. Tɔkɔrɔ njaa, m-pa marese, dingaje kuka lede mban. ");
INSERT INTO ksp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","A ei, toke a ta duju Lubba a, aw me key te lei ngaa, utu ta key bba e-duju Lubba lo kiyae te. Bɔije Lubba ke aw oo ne ke to lo-kiyae te le a kukai. ");
INSERT INTO ksp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Toke aw dujuje Lubba a, tar ke kara baa njaa e-tel dɔe te gɔl bayan nya ang mba dewje ke gereje Lubba ang aw ddaje toke baann. Dejeje to n̂-paje tar nya bba Lubba a koo. ");
INSERT INTO ksp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","E-ndajijede ang, mba Bɔsese gere ne ke e-ndikije bba e-dujeje guku baa.» ");
INSERT INTO ksp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«Maji kare e-dujuje Lubba toke be: Ei Bɔjeje ke isi me dara te, Maji kare dewje gereje to rii maji tɔyn. ");
INSERT INTO ksp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Maji kare e-ddee ɔn bbe! Maji kare dewje ddaje ne ke mei ndiki dɔ nange te, ddew kara baa toke ye ke dara. ");
INSERT INTO ksp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Areje ne-kusa taje ke bbokone. ");
INSERT INTO ksp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ɔru tar majang leje dɔje te, ddew kara baa toke jeje kara jaw jɔru tar dɔ dewje te ke ddaje majang ke je. ");
INSERT INTO ksp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Inya ddew are mare ne na meje ang. A ɔruje me ji Nje-Me-Maji ang te. Mba ei njaa kɔn-bbe, singa-mɔngu, ke piti to lei ke ndɔ ke ndɔ! Amem. ");
INSERT INTO ksp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Mba toke ɔruje tar dɔ dewje te ke ddaje maji ang ke se a, Bɔsese ke ee darâ a kɔru tar dɔse te tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","A toke bbo ɔruje tar dɔ dewje te ang a, Bɔsese a kɔru tar maji ang dɔse te ang tɔ.» ");
INSERT INTO ksp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Toke e-mbeteje ne-kusa a, e-tɔjuje to isije ke rɔ-kate ddew kara baa toke nje-ngemje aw ddajeenn ang. Daw n̂-tɔju dɔ kemde te to daw n̂-mbeteje ne-kusa. M-pa marese, to tar ke tɔkɔrɔ, dingaje kuka lede mban. ");
INSERT INTO ksp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","A ei, toke e-mbete ne-kusa a, e-toko kemi, ngaa e-ndem ubbu. ");
INSERT INTO ksp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Baann bba kare dewje gereje to aw e-mbete ne-kusa ang. A are Bɔije kara baa njaa ke ee lo te ke iya rɔe a gere. Bɔije ke aw oo ne ke to lo-kiyae te le a kukai.» ");
INSERT INTO ksp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«E-sangeje ne-kingaje ke dɔ nange te neenn nya nya ang mba esɔlɔlɔ a kɔn, a kuwa mbɔrkase ngaa, nje-bbokoje a tete ta-key mba bboko. ");
INSERT INTO ksp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","A maji kare e-sangeje ne-kingaje ke darâ, mba dara to lo ke esɔlɔlɔ a kɔn ne te ang ddem, ne a kuwa mbɔrkase te ang ddem, nje-bbokoje kara a tete ta-key mba bboko ne te ang ddem tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mba lo ke ne-kinga lei to te, mei a to te tɔ.» ");
INSERT INTO ksp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Kem dew to ddew kara baa toke lambe ke da-rɔ dew te. Yeenn a bbo kemi to ke maje a, da-rɔi tɔyn njaa a ndoko. ");
INSERT INTO ksp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","A bbo kemi to ke maje ang a, da-rɔi tɔyn a ndul. Yeenn a bbo lo-kare ke rɔi te tel to til a, til le a tel kil biti biti.» ");
INSERT INTO ksp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Dew kara ase dda bbere le ebbejedede joo ang mba, na mbete mare kara, a na ndiki mare kara. Wase na kunn rɔe kare mare kara a, na mbete mare kara. A kaseje ta dda bbere le Lubba ddem, le nare ddem ang tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Mba yeenn a, m-pa marese: E-sangeje mese wɔju dɔ tebbe lese wase da-rɔse ang ddem, wɔju dɔ ne ke a kayje wase ne ke a kusaje wase kubbu ke a kulaje ang. Tebbe lese ngeng uta ne-kusa ddem, da-rɔse ngeng uta kubbu ddem ang wa? ");
INSERT INTO ksp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ooje eelje ke darâ. N̂-dubbuje ne ang ddem, dujaje kande ko ang ddem, n̂-mbɔnje ne-kusa damâ ang ddem tɔ. A Bɔsese ke darâ aw ngemde ke ne-kusa. Gatese ngeng uta gate eelje ang wa? ");
INSERT INTO ksp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","«Na bba horose te a kase kila mare ndɔ kara dɔ ndɔ tebbe te laa ddew sange-me te laa wa? ");
INSERT INTO ksp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Yeenn a, mba ddi bba aw sangeje mese wɔju dɔ kubbuje wa? Aaje ddew ke putu-kakeje ke mû aw unjuje ne. Daw n̂-ddaje kula ang ddem, dujuje ne ang ddem. ");
INSERT INTO ksp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","A m-pa marese: Salemɔ ke da-rɔe njaa kara, dann ne-kingaje te laa tɔyn, ula kubbu ke kura ase putu-kakejeenn kara ang. ");
INSERT INTO ksp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Sese ke me-kunn lese to ngaji baa neenn! Putu-kakeje bbay ke toje bbokone neenn ngaa bara a puru a kɔn a Lubba ulade kubbu. A sese, na kulase kubbu ang toke baann wa? ");
INSERT INTO ksp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","«Yeenn a aw paje na: Ddi a ja kusa? Wase, ddi a ja kay? Wase, kubbu ddi a ja kula wa. E-sangeje mese wɔju dɔ nejeenn ang. ");
INSERT INTO ksp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Dewje ke gereje Lubba ang a aw sangeje nejeenn ke kare tɔyn. Bɔsese ke darâ gere to eeje ke bbo nejenn tɔyn. ");
INSERT INTO ksp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","E-sangeje Bbe-kɔn le Lubba, ke gate gate laa dɔngɔr, a na karese kese nejeenn tɔyn dɔ mare te. ");
INSERT INTO ksp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","«Yeenn a, e-sangeje mese wɔju dɔ ne ke bara ang. Mba bara njaa a sange ne laa bbay. Ndɔ kara kara ase kem ndoo laa.» ");
INSERT INTO ksp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Maji kare e-gangeje sariya dɔ nje-marse te ang, mba kare Lubba gange sariya dɔse te ang tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mba Lubba a gange sariya dɔse te ddew kara baa toke e-gangeje sariya dɔ nje-marse le. Ne ke unnje bba ɔjuje ne a na kunn ta kɔju ne ne lese tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mba ddi bba mu ke to kem ngokɔin te a oo a, tɔke kake ke to kemi te oo ang wa? ");
INSERT INTO ksp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","A pa kare ngokɔin pa na: ‹Are mɔre mu kemi te›, a ei njaa oo tɔke kake ke to kemi teenn ang toke baann wa? ");
INSERT INTO ksp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nje-ngem, ɔru tɔke kake ke to kemi te dɔngɔr bba a koo lo ke maje ta kɔru ne mu ke to kem ngokɔin te. ");
INSERT INTO ksp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Areje ne ke maji tɔyn bisije ang, mba da tel turu rɔde ke dɔse te ngaa da njarese. Unguje mereje lese nɔ bereje te ang. Mba da mbɔynje ke gɔlde.» ");
INSERT INTO ksp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«E-dujuje ne a da karese. E-sangeje ne a, a kingaje. Undaje ta key a, da kɔru karese. ");
INSERT INTO ksp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mba dew ke duju ne a, inga. Dew ke sange ne a, inga, ngaa dew unda ta key a, dɔru dare. ");
INSERT INTO ksp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Horose te, na bba ngonne duje ne-kusa a, a kare er wa? ");
INSERT INTO ksp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Wase na bba ngonne duje kanji a, a kare li wa? ");
INSERT INTO ksp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Sese e-majije ang, e-gereje ta kare ne ke maji ngannse. A Bɔsese ke darâ a kare ne ke maji nje ke dujeje ang wa? ");
INSERT INTO ksp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Ne tɔyn ke e-ndikije kare dewje ddaje ke se a e-ddaje ke de tɔ. Yeenn to Ndu ke Moyije ke maketuruje le nje-kilaje mber-tar le Lubba tɔjuje aann.» ");
INSERT INTO ksp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Andeje ke ta-ddew ke ngaji, mba ta-ddew ke tate to ta-ddew ke aw ke ta yo te. Ddewe ngeng ang are dewje nya andeje ne. ");
INSERT INTO ksp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","A ta-ddew ke ta kaw lo-kinga tebbe te to ngaji baa ngaa to ddew ke ngeng nya, are dewje kara kara baa a aw ingaje.» ");
INSERT INTO ksp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Aaje rɔse wɔju dɔ nje-kilaje mber-tar ke toje to nje-ngemje. Dulaje ngira bate bba n̂-ddeeje ne rɔse te. A mede te nu, n̂-toje to enjakemnjarje ke aw uwaje ne aw usaje. ");
INSERT INTO ksp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ne ke a gereje ne de a to kula-ddade. Dew a kuja kande binye dɔ kula konn te ang ddem, kande Pige dɔ kake te ke ubba konn ang ddem. ");
INSERT INTO ksp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kake ke maji, ande kandeje ke maji, a kake ke tuju, ande kandeje ke maji ang. ");
INSERT INTO ksp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kake ke maji ase ta kande kande ke maji ang ang. Ngaa kake ke tuju ase ta kande kande ke maji ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kake ke ande kande ke maji ang a, da tuka kila poro. ");
INSERT INTO ksp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yeenn a, ddew kula-dda te le nje-kilaje mber-tar ke toje to nje-ngemje a, a gereje ne de.» ");
INSERT INTO ksp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Dewje ke aw paje arem na: Ebbemje! Ebbemje! Dede tɔyn a da teeje Bbe-kɔn te ke darâ ang. Dede ke n̂-ddaje ne ke me Bɔmje ke ee darâ ndiki ke karede baa a da teeje. ");
INSERT INTO ksp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ndɔ gange sariya a, dewje nya a paje karem na: ‹Ebbejeje! Ebbejeje! Jila mber-tar, n̂-tubba ndilje ke maji ang ddem, n̂-dda ne-mɔrije nya ke rii ang wa?› ");
INSERT INTO ksp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yeenn ngaa ma pa karede na: m-gerese ndɔ kara ang ta ɔtuje mbɔrem te ddang. Awje ddew ew, ese nje-dda neje ke maji ang.» ");
INSERT INTO ksp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Yeenn a, bbo dew ke oo tarje tɔyn ke m-pa neenn ngaa dda ne kula a, na to ddew kara baa ke nje-kem-kare ke dda key laa dɔ er te. ");
INSERT INTO ksp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ndi ere, maannje sirije taaje lo tɔyn, ngaa yel ula yeke key le, a key le oso ang mba dungu gɔl key le dɔ er te. ");
INSERT INTO ksp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","A dew ke oo tarje lem ke maw m-pa neenn, a bbo dda ne kula ang a, na to ddew kara baa ke mbe-dew ke dda key laa dɔ enangara te. ");
INSERT INTO ksp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ndi ere, are ngann maannje sirije taaje lo tɔyn, ngaa yel ula yeke key le, a key le oso ngaa guru njuku njuku.» ");
INSERT INTO ksp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Toke Jeju pa tarje neenn le tɔyn nunga a, ne-tɔju laa le ɔru singa dewje ke banya ke ooje tar le. ");
INSERT INTO ksp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mba n̂-tɔju ne toke engan nje-kɔru gel-nduje le Jiipije ang. N̂-tɔju ne ke singa kɔn-mbay. ");
INSERT INTO ksp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Toke Jeju ddisi dɔ er te le a, dewje ke banya unnje goe. ");
INSERT INTO ksp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","A, a ta koo a, mare nje-banji ddee ngɔsi ke Jeju le, ɔsu mekeji-gɔle nɔe te ngaa pa are na: «Ebbemje, toke e-ndiki a, a kase dda kare m-ddee maji.» ");
INSERT INTO ksp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jeju ula jia ɔru ne nje-banji le ngaa pa na: «M-ndiki te, e-ddee maji.» Njange baa njaa a, banji le gayn rɔe te ke ddang ngaa n̂-ddee maji. ");
INSERT INTO ksp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ngaa Jeju pa are na: «Oo ke maje, e-pa tare are dew ang. A, aw tɔju rɔi are nje-polo-Lubba tenni oo bbo are ne-polo ke Moyiji unn ndu wɔju dɔe kare dewje tɔyn gereje to rɔi ddee maji ngaa.» ");
INSERT INTO ksp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kare te ke Jeju a ta tee Kapernayum a, mare nje-kɔn dɔ mbambaje ke Rɔm ddee ngɔsi saa ngaa duju kare numae. ");
INSERT INTO ksp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Nje-kɔn dɔ mbambaje le pa na: «Nje-kula******* lem to key, debbe rɔe oy are naw noo ndoo to bbeel.» ");
INSERT INTO ksp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jeju pa are na: «Ma kaw kɔru rɔ-to laa le.» ");
INSERT INTO ksp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","A nje-kɔn dɔ mbambaje le ilae te na: «Ebbemje, mase kare ande key lem ang. Tar kara njaa a e-pa a, rɔ-to le nje-kula lem le a nunga. ");
INSERT INTO ksp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","E-ma, mare dew aw ɔn dɔm, ngaa mɔn dɔ mare mbambaje tɔ. Bbo m-pa mare mare kara m-pa na: ‹Aw!› A naw. Bbo m-pa mare mare m-pa na: ‹E-ddee!› A n̂-ddee. M-pa mare nje-kula lem m-pa na: ‹E-dda ne neenn!› A n̂-dda.» ");
INSERT INTO ksp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Toke Jeju oo tar le nje-kɔn dɔ mbambaje le baann a, tar le nele to bbeel, ngaa n̂-pa nare dewje ke unnje goe na: «M-pa tar ke tɔkɔrɔ marese, nange te ke Ijarayel tɔyn, m-nayn minga mare dew ke koo me te laa bo toke be ang. ");
INSERT INTO ksp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","M-pa marese: ‹Dewje nya a kinje lo-tee te le kare, ke lo-kande te le kare ta da kisije ta tɔku ne-kusa te ke Abaraham, Ijake, ke Jakobbo me Bbe-kɔn te ke darâ. ");
INSERT INTO ksp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","A dede ke Bbe-kɔn le to lede le, da kungude ddaka lo te ke ndul ngaa lo teenn le, da nɔnje ddem da ngerje ngangede ddem.› » ");
INSERT INTO ksp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Goe te a, Jeju pa are nje-kɔn dɔ mbambaje le na: «E-tel aw bbe lei. Ne ke e-duju le, a kinga wɔju dɔ koo me te lei.» A kare teenn njaa, rɔ-to nunga rɔ nje-kula te le nje-kɔn dɔ mbambaje le. ");
INSERT INTO ksp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Toke Jeju ande key le Piyar a, noo mum Piyarje ke dene ke to key ke rɔ-to. Rɔe tunga nya. ");
INSERT INTO ksp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jeju ɔru ji dene le ngaa rɔe ke tunga le wul. Dene le in taar ngaa unn kutu dda saa. ");
INSERT INTO ksp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Lo-kul a, n̂-ddeeje ke dewje ke eeje ke rɔ-to ndilje ke maji ang toke banya rɔ Jeju te. Tar ke ta Jeju te njaa tubba ne ndilje ke maji ang le ngaa nɔru rɔ-to rɔ dewje te le tɔyn. ");
INSERT INTO ksp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","N̂-dda baann bba kare tar le Ijayi nje-kila mber-tar le Lubba ddee to tar ke tɔkɔrɔ. Tar le na: «Nɔru namaje leje ke ddang, ngaa n̂-taa rɔ-toje leje ke dɔe te.» ");
INSERT INTO ksp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Toke Jeju oo dewje ke banya banya ke gukeje le a, n̂-pa nare nje-njaje goe te kare dawje tura tɔku dange maann te. ");
INSERT INTO ksp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","A mare nje-kɔru gel ndu ddee pa are na: «Nje-ne-tɔju, lo tɔyn ke aw te a, ma kuwa goi.» ");
INSERT INTO ksp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jeju ilae te na: «Mulaje eeje ke lo-kiya rɔ lede ddem, eelje ke darâ kara eeje ke key lede ddem. A Ngonn le dew ee ke lo kara ta kula dɔe te ang. ");
INSERT INTO ksp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mare nje-nja goe te pa are na: «Nje-ne-tɔju, inya are maw m-dubbu bɔy bba.» ");
INSERT INTO ksp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jeju ilae te na: «Unn gom a inya yoje are dubbuje yoje lede.» ");
INSERT INTO ksp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jeju aal tɔku to ngaa, nje-njaje goe te danneje. ");
INSERT INTO ksp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","A ta koo a, bamburanbo in dɔ tɔku dange maann te le. Maann le aw lenge ungu me tɔku to te le are nayn ngɔsi ta ddusu, a Jeju nayn aw tibbi. ");
INSERT INTO ksp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nje-njaje-goe te awje ngɔsi saa aw ndoleje ngaa paje areje na: «Ebbe-dewje ajije! Ja ta koy!» ");
INSERT INTO ksp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jeju ilade te na: «Mba ddi bba aw bbeelje wa? Sese ke koo me te lese bo ang.» Yeenn ngaa ni taar, n̂-ndange lel le ddem maann le ddem ngaa lo tel to ddekeke. ");
INSERT INTO ksp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Dede tɔyn njaa mede unda dɔ binya ngaa n̂-paje na: «Dew ddi njaa neenn bba lel, ke maann kara ooje tae neenn wa?» ");
INSERT INTO ksp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Toke Jeju tee tura dange maann te, nange te le dewje ke Gadara a, dingawje joo inje dɔbareje te tilaje keme. Ndilje ke maji ang isije mede te. N̂-ddaje singa nya are dew kara ndiki ta nday ke ddew ke dɔbareje te le ang. ");
INSERT INTO ksp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Duruje ekii na: «Ngonn le Lubba, ddi a aw sange rɔje te wa? E-ddee ta kula kemje ndoo kete bba kare ndɔe ke Lubba wɔju le ase wa?» ");
INSERT INTO ksp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ngɔsi ke lonn le, tɔku kusu bereje aw usaje ne. ");
INSERT INTO ksp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ndilje ke maji ang le ddaje rɔde to ndoo rɔ Jeju te na: «Bbo a ta tubbaje a, ulaje me kusu bereje te tonn.» ");
INSERT INTO ksp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jeju pa arede na: «Awje!» Ndilje ke maji ang le teeje me dingawje te le ngaa aw andeje me kusu bereje te le. A, a ta koo a, kusu bereje le tɔyn inje dɔ kongo te ke ndew osoje me dange maann te le, ngaa doyje me maann te le tɔyn. ");
INSERT INTO ksp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Dingawje ke aw ngemje bereje le aynje awje me tɔku-bbe te, ngaa paje tar ne ke tee le, ke tar ne ke inga dingawje ke joo ke ndilje ke maji ang to mede te le tɔyn are dewje. ");
INSERT INTO ksp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yeenn ngaa dewje tɔyn ke me tɔku bbe te le teeje aw tilaje kem Jeju le. Toke dooeje a, n̂-ddaje rɔde to ndoo rɔe te kare nɔte ke ddang nange te lede. ");
INSERT INTO ksp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jeju aal tɔku to ngaa gange dange maann le tel aw tɔku bbe te laa. ");
INSERT INTO ksp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Dewje ddeeje rɔe te ke mare dingaw ke debbe rɔe oy ke dilae dɔ tuwa te. Toke Jeju oo koo me te lede le a, pa are dew ke rɔe oy le na: «Ngunnum, uwa are ngeng, tar majang lei ɔru dɔi te ngaa.» ");
INSERT INTO ksp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yeenn ngaa, mare nje-kɔruje gel ndu paje mede te na: «Dew neenn aw taji Lubba.» ");
INSERT INTO ksp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","A Jeju gere keje lede ngaa dujude na: «Mba ddi bba eeje ke keje ke maji ang baann wa? ");
INSERT INTO ksp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ta pa na: Tar majang lei ɔru dɔi te, wase ta pa na: In taar bbo e-nja. Yee ke dda ngeng ang wa? ");
INSERT INTO ksp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","M-ndiki kare e-gereje to Ngonn le dew ee ke singa ta kɔru tar majang dɔ dewje te ke nangê neenn.» Yeenn ngaa n̂-pa nare dew ke rɔe oy le na: «In tar, unn tuwa lei bbo aw bbê.» ");
INSERT INTO ksp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Dingaw le in taar ngaa aw bbê laa. ");
INSERT INTO ksp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Toke dewje ke banya le ooje baann a, bbeel uta dɔde ngaa dɔsuje gaji Lubba mba singa ke baann ke nare dewje le. ");
INSERT INTO ksp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jeju ɔtu lo teenn le ngaa aw nday a, noo mare dingaw ke daw n̂-bbare na Matiye isi lo kula taa nare lambo te. Jeju pa are na: «Unn gom.» Matiye le in taar ngaa unn goe. ");
INSERT INTO ksp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Goe te a, Jeju aw usa ne key le Matiye. Nje-taaje nare lambo, ke nje-ne-ddaje ke maji ang toke banya ddeeje usaje ne le ke Jeju de ke nje-njaje goe te. ");
INSERT INTO ksp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Toke Parijiyenje ooje neenn le a, n̂-paje dareje nje-njaje go Jeju te le na: «Mba ddi bba nje-ne-tɔju lese aw usa ne ke nje-taaje nare lambo, ke dewje ke toje to nje-ne-ddaje ke maji ang wa?» ");
INSERT INTO ksp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jeju oo tar lede le ngaa pa na: «Dewje ke rɔde to ke maje aw sangeje nje-kɔru rɔ-to ang. Dewje ke rɔde to de bba. ");
INSERT INTO ksp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yeenn a, maji kare aw sangeje ddew mba gere kande tar ke Lubba pa neenn: « Ndiki naa a m-ndiki bbo ne-polo ang. Mba dewje ke ooje rɔde to dewje ke gate gate a m-ddee ta bbarde ang. M-ddee mba nje ke ooje rɔde to nje-ne-ddaje ke maji ang.» ");
INSERT INTO ksp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Goe te a, nje-njaje go Jan Batisi te ddeeje ngɔsi ke Jeju ngaa dujeje na: «Mba ddi bba jeje ke Parijiyenje jaw inyaje ne-kusa taar taar mba duju Lubba a, nje-njaje goi te inyaje ne-kusa ang wa?» ");
INSERT INTO ksp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jeju ilade te na: «Ejeje to nje-buwa-kuraje le nje-dene ke siki a ndingaje ndoo kare te ke nje-taa dene le nayn ke de bbay wa? Baann ang. A kare a ddee kare dunn nje-taa dene le dɔtu ne, a da kinyaje ne kusa bbay.» ");
INSERT INTO ksp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Dew a kunn ta kubbu ke siki kila ne kem ngisi kubbu ang. Mba ta kubbu ke siki le a dda kare do ke kem ngisi kubbu te le tel tiir ke kete bbay ngaa do ke kem ngisi kubbu te le a tel bo kuta ye ke kete. ");
INSERT INTO ksp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Dew a kungu ben ke n̂-dda siki bbay me konn ku endaarje te ang. Mba kuje le a tiirje ta ben le a kula nangê ngaa kuje le kara a tujuje nyɔm tɔ. Kuje ke siki a daw dungu ben ke n̂-dda toke siki me te. Baann bba koto le ke kuje le a naynje ke maje.» ");
INSERT INTO ksp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Kare te ke Jeju aw pa tar arede toke baann a, mare tɔku dew le Jiipije ddee tee. Nɔsu mekeji gɔle nɔn Jeju te le ngaa n̂-pa na: «Ngunnum ke dene oy bbassine bbay neenn. A aw ila jii dɔe te a, na ndol.» ");
INSERT INTO ksp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jeju in taar ngaa, ne de ke nje-njaje goe te dunnje go dingaw le. ");
INSERT INTO ksp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","A mare dene ke mese aw ddee rɔe te are aw oo ndoo bbal dɔku gire joo ddee giri Jeju te ngɔsi ngaa ɔru ta kubbu laa. ");
INSERT INTO ksp_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mba n̂-pa mee te na: «Bbo le kubbu laa njaa bba minga ddew mɔru kara, rɔm a ddee maji.» ");
INSERT INTO ksp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jeju turu rɔe ooe ngaa pa na: «Uwa are ngeng, ngunnum ke dene, koo me te lei ajii mban.» A kare teenn njaa rɔ-to le nunga rɔe te. ");
INSERT INTO ksp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Toke Jeju aw key le tɔku dew le Jiipije le, ngaa oo dewje ke aw kɔlje mbula ddem, dewje ke banya ke aw nɔnje aw uruje ne ekii ddem a, ");
INSERT INTO ksp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","n̂-pa na: «E-teeje ke ddaka. Ngonn ke dene le oy ang, naw n̂-tibbi.» A dewje le kokoeje. ");
INSERT INTO ksp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Toke n̂-tubbaje dewje ke banya le dare teeje ddaka a, Jeju ande key le, uwa ji ngonn ke dene le ngaa in taar. ");
INSERT INTO ksp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tare nja dɔ nange te le tɔyn. ");
INSERT INTO ksp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Toke Jeju in lo tenn le aw nday ke kete a, nje-kem-tɔje joo unnje goe ngaa uruje ekii na: «Ngonn le Dabbiti, oo kem-to-ndoo leje!» ");
INSERT INTO ksp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Toke Jeju ande key a, nje-kem-tɔje le ddeeje ngɔsi saa ngaa Jeju le dujude na: «Ooje mese te to mase ta dda neenn wa?» Dilaeje te na: « Ebbe-dewje, ase ta dda.» ");
INSERT INTO ksp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yeenn ngaa Jeju ɔru kemde ke jia ngaa pa na: «Maji kare ne ke e-dujuje le ddee tɔkɔrɔ ase kem koo me te lese.» ");
INSERT INTO ksp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kemde le uja, ngaa Jeju ndɔre mbide nya na: «Ooje ke maje, maji kare dew kara gere tare ang.» ");
INSERT INTO ksp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","A kake nje-kem-tɔje le teeje ddaka a paje tar le Jeju dɔ nange te le tɔyn are dewje. ");
INSERT INTO ksp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Toke Jeju de ke nje-njaje goe te n̂-teeje ta kɔtu a, dewje ddeeje rɔe te ke mare dingaw ke ndil ke maji ang ddae are pa tar ang. ");
INSERT INTO ksp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jeju tubba ndil ke maji ang le ngaa dingaw le unn kutu pa tar. Ne le gange singa dewje ke banya ke eeje teenn ngaa n̂-paje na: «Joo ne ke be ndɔ kara nange Ijarayel te ang.» ");
INSERT INTO ksp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","A Parijiyenje paje na: «Mbay le ndilje ke maji ang a are Jeju singa ke ta tubba ne ndilje le.» ");
INSERT INTO ksp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jeju nja me tɔku bbeje te, ke me ngann bbeje te tɔyn. N̂-tɔju ne key-mbɔn naaje te le Jiipije, nila mber Tar ke majiwɔju dɔ kɔn-mbay le Lubba. Nɔru rɔ-toje tɔyn rɔ dewje te, ngaa n̂-dda nare rɔ dewje ke debbe rɔde tuju ddeeje maji. ");
INSERT INTO ksp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jeju oo dewje ke banya le a, ddae ndoo. Mba dewje le singade ɔru ddem, rɔde oy njururu ddem, ddew kara baa toke bateje ke nje-ngemde goto. ");
INSERT INTO ksp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yeenn ngaa, Jeju pa are nje-njaje goe te na: «Kula kuja koo le bo nya, a nje-kujaje koo le bayanje ang. ");
INSERT INTO ksp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yeenn a, e-dujuje nje-ndɔɔ le are nula mare nje-kulaje bbay ta kula te le. ");
INSERT INTO ksp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jeju bbar nje-njaje goe te dɔku gire joo. Narede singa kare n̂-tubba ne ndilje ke maji ang, kare dɔru ne rɔ-toje tɔyn, kare n̂-ddaje dare rɔ dewje ke debbe rɔde tuju ddeeje maji. ");
INSERT INTO ksp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ri nje-kayn-kulaje ke dɔku gire joo le na: Dɔngɔr dew to Simɔ ke daw n̂-bbare na Piyar, ke ngokɔen Andere. Jake ngonn le Jebbede, ke ngokɔen Jan. ");
INSERT INTO ksp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipi de ke Batalami, Toma de ke Matiye ke to nje-taa nare lambo, Jake ngonn le Alpe, ke Tade. ");
INSERT INTO ksp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simɔ dew ke ndiki bbe laa nya, ke Judase Iskariyote ke a to nje labbe Jeju. ");
INSERT INTO ksp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Kete bba kare Jeju ula nje-kayn-kulaje ke dɔku gire joo le a, n̂-ndejede na: «Dewje ke toje to Jiipije ang a, awje rɔde te ang ddem, andeje me bbe te le dewje ke Samari ang ddem. ");
INSERT INTO ksp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","A, awje rɔ dewje te ke Ijarayel ke toje toke le bateje ke naynje. ");
INSERT INTO ksp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kare kawse a, ilaje mber e-paje na: Bbe-kɔn ke darâ ee ngɔsi. ");
INSERT INTO ksp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ɔruje rɔ-to rɔ dewje te, e-ndolje dewje ke oy, areje rɔ nje-banjije ddee maji, ngaa e-tubbaje ndilje ke maji ang. Ingaje ne le baa, ta areje dewje baa njaa tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Unnje ande, wase nare, wase kande nare unguje me bbɔl te lese ang. ");
INSERT INTO ksp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Unnje bbɔl mba kaw ne nja te lese le ang. E-jinje dɔ-kubbu ke taar joo ang ddem, ne-gɔl ang ddem, unnje kake ke ta kuwa jise te ang ddem. Mba maji kare dare dew ke aw dda kula ne-kusa tae. ");
INSERT INTO ksp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Toke e-teeje mare tɔku-bbe te wase ngonn bbe te a, e-sangeje dew ke a kase mba taase ke key laa, ngaa ta isije rɔe te ndereng ɔtuje ne. ");
INSERT INTO ksp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Toke a ta kandeje me key te a, e-ddaje lapiya nje-keyje le. ");
INSERT INTO ksp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","A bbo nje-keyje le taase ke key a, maji kare lapiya lese le arede me-wul-lɔm. A toke n̂-taase ke key ang a, maji kare me-lɔm lese tel ke rɔse te. ");
INSERT INTO ksp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Toke e-teeje mare key te wase mare tɔku-bbe te a, dewje taase ke key ang a, kɔtuse a, e-tundaje bum-gɔlse. ");
INSERT INTO ksp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","M-pa tar ke tɔkɔrɔ marese. Ndɔ gange sariya a, sariya ke da gange dɔ nje-bbeje teenn a ngeng kuta sariya ke da gange dɔ dewje te ke Sɔdɔme ke Gɔmɔr.» ");
INSERT INTO ksp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Ooje, mulase toke le bateje horo enjakemjarje te. Yeenn a, maji kare aaje rɔse toke le li aw aa rɔe ddem, areje tar to dɔse te ang toke le derje. ");
INSERT INTO ksp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Aaje rɔse rɔ dewje te, mba da kaw ke se nɔn sariya te, ta da tundase ke ndey me key-mbɔn naaje te lede. ");
INSERT INTO ksp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Da kaw ke se nɔ-gɔl nje-kɔn bbeje te, ke nɔ-gɔl tɔku-mbayje te wɔju dɔm. Kare teenn a paje tar-naji lem karede ddem, kare dewje ke toje to Jiipije ang ddem. ");
INSERT INTO ksp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","A toke daw ke se lo gange sariya te a, areje mese sangese wɔju dɔ tar ke a paje wase, gusu ke a paje ne tar le ang. Kare teenn njaa, Lubba a karese tar ke a paje. ");
INSERT INTO ksp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mba, sese bba a paje tar le ang, a Ndil le Bɔsese, a a kunda tar le tase te kare e-paje. ");
INSERT INTO ksp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Dewje a kila ngakɔnde ji dewje te kare n̂-tɔlde. Bɔ-ngannje a ddaje toke baann ke ngannde tɔ. Ngannje a telje to nje-baanje le bɔdede ke le kɔndede ngaa da dda kare n̂-tɔlde. ");
INSERT INTO ksp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Dewje tɔyn a mbetejese wɔju dɔm. A dew ke uwa are ngeng ndereng ddutu ndɔ te a, a kinga kaji. ");
INSERT INTO ksp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Toke n̂-dda singa ke se mare tɔku bbe te a, aynje awje mare te. M-pa tar ke tɔkɔrɔ, a nayn njaje me tɔku bbeje te ke Ijarayel tɔyn ang bbay a, Ngonn le Dew a ddee. ");
INSERT INTO ksp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Nje-ndo-ne uta nje-ne-tɔju ang ddem, nje-kula a kuta ebbeeje ang ddem. ");
INSERT INTO ksp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Toke nje-ndo-ne ddee toke le nje-ne-tɔju laa wase, nje-kula ddee toke le ebbeeje a, yeenn ase. Toke dewje bbarje nje-key to Belejebul a, da taji ngann nje-keyje uta yeenn.» ");
INSERT INTO ksp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Arje bbeel le dew ddase ang, mba mare ne kara ke to lo-kiyae te ke a tee ke ddaka ang goto, ngaa neje tɔyn ke n̂-kusu dɔe dewje a gereje. ");
INSERT INTO ksp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tar ke m-pa marese til te a, sese, maji kare e-ndajije areje dewje kara. A bbo n̂-pa tar darese hɔy be a, maji kare ilaje ne mber nata. ");
INSERT INTO ksp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","E-bbeelje dewje ke aw tɔlje da-rɔ dewje ang, mba daseje ta tɔl kewn le dew ang. A Lubba a maji kare e-bbeeleje. Ne a nase ta dda kare kewn le dew ddem, da-rɔ dew ddem tujuje kem puru te ke ke ndɔ ke ndɔ. ");
INSERT INTO ksp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Daw n̂-labbe ngann eelje joo gusu kara ang wa? A toke Bɔsese ndiki ang a, ngonn eel kara a kase koso nangê ang. ");
INSERT INTO ksp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","A sese, ben dɔse kara Lubba tura kara kara tɔyn. ");
INSERT INTO ksp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yeenn a, areje bbeel ddase ang. Kem Lubba te e-ngengje uta ngann eelje ke banya. ");
INSERT INTO ksp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yeenn a, toke dew pa kem dewje te to n̂-to nje-nja-gom te a, ema kara ma pa nɔ gɔl Bɔy te ke ee dara to n̂-to dew lem tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","A toke dew pa kem dewje te na: «M-to dew le Jeju ang» a, ema kara ma pa nɔ gɔl Boy te ke ee dara na: « Dew neenn to dew lem ang» tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ejeje to m-ddee ta kila me-wul-lɔm dɔ nange te neenn ang. M-ddee ta kila me-wul-lɔm ang, ddɔ a m-ddee ta kila nangê. ");
INSERT INTO ksp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","M-ddee ta kila kayn-naa horo dew te ke bɔeje, horo ngonn ke dene te de ke kɔenje, ngaa horo ngonn ke dene te de ke mumeje ke dene. ");
INSERT INTO ksp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nje ke me key te le dew njaa a toje to nje-baanje laa. ");
INSERT INTO ksp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Dew ke ndiki bɔeje wase kɔenje utam, a kase ta ddee to dew lem ang. ");
INSERT INTO ksp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Dew ke oto kake-dese laa bba nja ne gom te ang, a kase ta ddee to dew lem ang. ");
INSERT INTO ksp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Dew ke ndiki ta ngem tebbe laa a, tebbe laa le a nayn ke kɔrɔ nyɔm. A dew ke are tebbe laa nayn ke kɔrɔ wɔju dɔm a, na tel kinga tebbe laa le. ");
INSERT INTO ksp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Toke dew taase ke rɔe te a, ema njaa n̂-taam. A dew ke taam ke rɔe te a, taa dew ke ulam tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Dew ke taa nje-kila mber-tar le Lubba ke rɔe te, mba dew ke n̂-taae le to nje-kila mber-tar le Lubba a, na kinga kuka ke nje-kila mber-tar le Lubba aw inga. A bbo dew taa dew ke gate gate ke rɔe te, mba dew ke n̂-taae le to dew ke gate gate a, na kinga kuka ke dew ke gate gate aw inga. ");
INSERT INTO ksp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","M-pa tar ke tɔkɔrɔ marese: «Maann ke wul ke engo te baa njaa bba dew are dew ke ngaji horo ngamareje te, mba dew ke ngaji le to nje-nja gom te a, kuka laa a koso nangê ang tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Toke Jeju ndeje nje-njaje goe te ke dɔku gire joo le nunga a, nɔtu naw me tɔku-bbeje te ke dɔ nange teenn ta tɔju ne ddem ta kila mber-tar ddem. ");
INSERT INTO ksp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Toke Jan Batisi nayn key-kula te a, oo tam kula ke Kiriste aw dda. Yeenn a, nula mare nje-njaje goe te rɔe te nare, ");
INSERT INTO ksp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","daw n̂-dujeje na: «Ei a e-to Mesi* ke a ta ddee le wase maji kare n-ngebbe mare dew dang wa?» ");
INSERT INTO ksp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jeju ilade te na: «Ne ke ooje ke mbise ddem, ke kemse ddem neenn le, aw paje areje Jan le: ");
INSERT INTO ksp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nje-kem-tɔje ooje lo, nje-meteje njaje, rɔ nje-banjije ddee maji, nje-mbikutuje ooje tar ddem, dewje ke oyje ndolje ddem, ngaa dila mber Tar ke maji dare nje-ndooje. ");
INSERT INTO ksp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Rɔ-neel to mba dew ke ema a ma to nje-dda kare koo-me te laa oso ang.» ");
INSERT INTO ksp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Toke nje-njaje-go Jan te le telje a, Jeju unn kutu pa tar ke dɔ Jan te are dewje ke banya ke eeje lo teenn le na: «Ddi a awje aw ooje me kɔr te wa? Aw ooje muje ke lel aw yeke wa? ");
INSERT INTO ksp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bbo to ye ang a, ddi a awje aw ooje wa? Aw ooje mare dingaw ke ula kubbu ke kura wa? A dewje ke ulaje kubbuje ke kura isije key-mbay te. ");
INSERT INTO ksp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yeenn a, ddi njaa awje aw ooje le wa? Mare nje-kila mber-tar le Lubba wa? Tɔkɔrɔ, m-pa marese, nuta nje-kilaje-mber-tar le Lubba bbay. ");
INSERT INTO ksp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jan le a n̂-dda tar laa me Maketurute le Lubba na: ‹Ma kula nje-kayn-kula lem nɔi te kare n̂-mɔse ddew nɔi te.› ");
INSERT INTO ksp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","«Tɔkɔrɔ m-pa marese: ‹horo dewje te tɔyn ke deneje ujude, mare dew ke bo uta Jan-Batisi goto. A dew ke to ten uta keseje me Bbe-kɔn te ke dara bo utae. ");
INSERT INTO ksp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Unn kute dɔ ndɔ te le Jan-Batisi ndereng bbasine, daw n̂-dda singa mba Bbe-kɔn ke dara. Ngaa nje-singaje a aw sangeje ddew ta taa. ");
INSERT INTO ksp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mba nje-kilaje mber-tar le Lubba, ke Ndu le Moyiji paje tar bbe-kɔn le Lubba ndereng tee ndɔ Jan te. ");
INSERT INTO ksp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","A bbo e-ndikije te sem a, ne njaa n̂-to Eli ke na a ddee le. ");
INSERT INTO ksp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Maji kare dew ke mbia to a oo tar neenn! ");
INSERT INTO ksp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Ddi a ma kunn kɔju ne dewje ke bbasine neenn wa? N̂-toje ddew kara baa toke ngannje ke isije nata ngaa paje ke taar areje ngann marde na: ");
INSERT INTO ksp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹N-kɔl mbula kare e-laje ne, a e-laje ang, jɔsu pa yo jarese a, e-nɔnje ne ang tɔ». ");
INSERT INTO ksp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mba Jan Batisi ddee a, usa ne ang ddem, ay ne ang ddem. A dewje paje na: ‹Ndil ke majang to mee te.› ");
INSERT INTO ksp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ngonn le dew ddee ngaa usa ne ddem, ay ne ddem, a dewje paje na: ‹N̂-to nje-ne-kusa, ke nje-ne kay. N̂-to nje-buwa-kura le nje-taaje nare-lambo ddem, le nje-ne-ddaje ke maji ang ddem.› A dewje ooje kem-kare ke in rɔ Lubba a, n̂-gereje to kem-kare le aw dda ne ke maji.» ");
INSERT INTO ksp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yeenn ngaa, Jeju unn kutu kɔl ke dewje ke bbeje te ke n̂-dda ne-mɔrije ke te nya uta keseje tɔyn, mba n̂-mbeteje ta turu ddew lede. ");
INSERT INTO ksp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","N̂-pa na: «See dewje ke Korajen, to ndoo nya arese! See dewje ke Betesayida, to ndoo nya arese! Ne-mɔrije ke m-dda horose te neenn, toke m-dda me bbeje te ke Tir ke Sidɔn a be a, lew baa njaa dewje ke me bbeje teenn a kulaje kubbu-ndoo ddem, da kungu bu puru dɔde te ddem ngaa da turuje ddew lede. ");
INSERT INTO ksp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mba yeenn a, m-pa marese : « Ndɔ gange sariya a, sariya ke dɔse te a ngeng kuta sariya ke dɔ Tir te ke dɔ Sidɔn te. ");
INSERT INTO ksp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","«A see dewje ke Kapernayum, ejeje to Lubba a kunn bbe lese ke taar ndereng kɔru ne dara wa? Na tel ke bbe lese ndereng lo te le dewje ke oy. Mba ne-mɔrije ke m-dda bbe lese, toke m-dda Sɔdɔm a bbe le a nayn ndereng bbokone bbay. ");
INSERT INTO ksp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mba yeenn a, m-pa marese, ndɔ gange sariya a, sariya lese a ngeng kuta sariya le dewje ke Sɔdɔm.» ");
INSERT INTO ksp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kare teenn, Jeju pa na: «Mɔsu gajii Bɔy, Ebbe-dewje ei ke ɔn dɔ dara ddem, nange ddem, mba iya neje neenn le nje-kem-kareje ddem, nje-ne-gereje ddem. A e-tɔju nejeenn le dewje ke toje to dewje ke ten baa. ");
INSERT INTO ksp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tɔkɔrɔ bɔy, mba ei njaa e-ndiki kare to toke baann. ");
INSERT INTO ksp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Bɔy arem ne tɔyn mban. Dew kara gere Ngonn le ang, Bɔ njaa kara baa. Dew kara gere Bɔ ang tɔ, Ngonn njaa kara baa. A dew ke Ngonn le njaa ndiki tɔje Bɔ le bba a gere.» ");
INSERT INTO ksp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«E-ddeeje rɔm te, sese tɔyn ke ne-koto aw ɔyse are rɔse nyase, a ma kare uwaje rɔse. ");
INSERT INTO ksp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","E-taaje juku lem otoje, ngaa areje m-tɔjuse ne, mba m-wul pee ddem, mem to me ngonn kase ddem. Yeenn bba a kuwaje rɔse. ");
INSERT INTO ksp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mba juku ke ma kunda gɔsuse te ɔɔy ang ddem, ne-koto ke marese kare otoje kara ɔle pelpel ddem. ");
INSERT INTO ksp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Dɔ ndɔe teenn, Jeju aw nday me ndɔɔ beleje te ke ndɔ-kuwa-rɔ*. Bbo dda nje-njaje goe te ngaa daw n̂-teteje jinga beleje le daw dusaje. ");
INSERT INTO ksp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Toke Parijiyenje ooje baann a, n̂-paje dareje Jeju na: «Oo, nje-njaje goi te aw ddaje ne ke ase kare dew dda ndɔ-kuwa-rɔ te ang.» ");
INSERT INTO ksp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","A Jeju ilade te na: «Ne ke Dabbiti dda dɔ ndɔ te ke bbo ddae, ne de ke dewje laa le, e-turaje tare me Maketurute ang wa? ");
INSERT INTO ksp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dabbiti de ke dewje laa le dandeje me key te le Lubba ngaa dusaje mapa ke dare Lubba to ne-polo. De ke ddew ta kusa mapa le ang mba to ne-kusa ke nje-poloje Lubba ke karede baa a aseje ta kusa. ");
INSERT INTO ksp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","N-dda me Maketuru-ndu te na: Ke ndɔ-kuwa-rɔ, nje-poloje Lubba aw ddaje kula me key-polo-Lubba te. Yeenn to daw ngem ndu ke wɔju dɔ ndɔ-kuwa-rɔ ang, a tar kara to dɔde te ang. ");
INSERT INTO ksp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","A m-pa marese, mare ne ke bo uta key-polo-Lubba to neenn. ");
INSERT INTO ksp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Maketuru le Lubba na: M-ndiki kare dewje ndiki naa bbo m-ndiki ne-polo ang a. Toke e-gereje kande tar neenn a, dewje ke tar to dɔde ang le, a kundaje tar dɔde te ang. ");
INSERT INTO ksp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Mba Ngonn le dew a to nje ndɔ-kuwa-rɔ. ");
INSERT INTO ksp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jeju ɔtu lo teenn ngaa aw ande key-mbɔn̂-naa te le Jiipije. ");
INSERT INTO ksp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mare dew ke jia oy ee teenn. A Parijiyenje ndikije ta kunda tar dɔ Jeju te ngaa dujueje na: Dew ee ke ddew ta kɔru rɔ-to ke ndɔ-kuwa-rɔ wa? ");
INSERT INTO ksp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jeju ilade te na: Na horose te neenn, bbo ee ke bate kara baa, ngaa bate le oso me buwa te ke ndɔ-kuwa-rɔ a, a kɔre ke ddaka ang wa? ");
INSERT INTO ksp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","A dew uta bate ang wa? Yeenn a, ndu are ddew ta dda maji ke ndɔ-kuwa-rɔ. ");
INSERT INTO ksp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yeenn ngaa Jeju pa are dingaw le na: «E-ndɔju jii.» A n̂-dɔju jia le ngaa, jia le ddee maji toke ye ke kara. ");
INSERT INTO ksp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","A Parijiyenje le teeje ddaka ngaa mbɔnje naa ta kuwa dɔde ta koo ddew ke ta tɔl ne Jeju le. ");
INSERT INTO ksp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Toke Jeju oo tar tɔle le a ɔtu lo teenn ke ddang. Dewje banya banya unnje goe ngaa nɔru rɔ-toje lede tɔyn. ");
INSERT INTO ksp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","A n̂-ndejede nya kare n̂-pa tar dɔe te dare dewje ang. ");
INSERT INTO ksp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yeenn bba tar ke Ijayi nje-kila mber-tar le Lubba pa ddee ne to tar ke tɔkɔrɔ. Tar le na: ");
INSERT INTO ksp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Lubba pa na: Ne neenn a n̂-to Nje-kula lem ke m-bere. Ne ke m-ndike nya, ngaa minga rɔ-neel ddew te laa. Ma kare Ndil lem isi dɔe te, kare nila mber ne-dda ke gate gate nare dewje ke toje to Jiipije ang. ");
INSERT INTO ksp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Na kɔl ke dew kara ang ddem, na kuru ekii ang ddem. Dew kara kara a koo ndue go ddew te ang. ");
INSERT INTO ksp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Na kuwa kare mu ke tete mban guru ang. Na tɔl puru ke a ta koy ang. Na dda ne toke baann ndereng kare ne ke to ke ddewe tɔy dɔ neje tɔyn, ");
INSERT INTO ksp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ngaa dewje ke toje to Jiipije ang a kundaje mede dɔe te.» ");
INSERT INTO ksp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Dewje ddeeje ke mare dew ke ndilje ke maji ang isije mee te are dew le oo lo ang ddem, oo tar ang ddem. Jeju ɔru rɔ-to le dew le are noo lo ke maje ddem noo tar ke maje ddem. ");
INSERT INTO ksp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Neenn le gange singa dewje ke banya le ngaa paje na: «Ngonn le Dabbiti le a neenn ang wa?» ");
INSERT INTO ksp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Toke Parijiyenje ooje tare a paje na: «Dingaw neenn aw tubba ndilje ke maji ang ddew singa te le Belejebul ke to mbay le ndilje ke maji ang.» ");
INSERT INTO ksp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jeju gere keje lede ngaa pa arede na: «Toke dewje ke me mare bbe-kɔn te uruje dɔ naa te ngaa tinje naa a, bbe-kɔn le a tuju. Ngaa, toke dewje ke me tɔku bbe te wase ke me key te uruje dɔ naa te ngaa tinje naa a, da kaseje ta nayn ang. ");
INSERT INTO ksp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Toke satan tubba satan a, yeenn to ne njaa naw n̂-dda ddɔ ke rɔe. A bbe-kɔn laa le a tel nayn toke baann wa? ");
INSERT INTO ksp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","A bbo e-paje na ddew singa te le Beljebul a maw m-tubba ne ndilje ke maji ang a, nje ke lese, singa le na ngaa a dede daw n̂-tubba ne de wa? Nje ke lese le njaa a tɔjuje to tar lese to ke dɔgɔle ang. ");
INSERT INTO ksp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","A toke ddew singa te le Ndil le Lubba a maw m-tubba ne ndilje ke maji ang a, yeenn tɔju to kɔn-bbe le Lubba tee dɔse te ngaa. ");
INSERT INTO ksp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Toke dew ndiki ta kande key le dew ke ubba singa nya, ta taa ne-kingaje laa a, maji kare nuwa nje-singa le n̂-tɔe kete ngaa bba goe te a, na koto neje tɔyn ke to me key te le. ");
INSERT INTO ksp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Dew ke to dew lem ang to nje-baan lem. Ngaa dew ke mbɔn ne sem ang to dew ke aw saren ne kɔrɔ. ");
INSERT INTO ksp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mba yeenn a, m-pa marese, Lubba a kɔru tar majangje tɔyn ke tar taji ke dewje aw n̂-tajeje dɔde te. A na kɔru tar dɔ dew te ke taji Ndil-me-nda ang. ");
INSERT INTO ksp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Toke dew pa tar ke mbete ngonn le dew a, Lubba a kɔru tar dɔe te. A toke dew pa tar ke mbete Ndil-me-nda a, Lubba a kɔru tare dɔe te bbokone neenn ang ddem, ndɔ te ke bara ang ddem. ");
INSERT INTO ksp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Toke kake maji a kande kara maji tɔ. Toke kake tuju a kande kara a tuju tɔ. Mba dew gere kake ddew te le kande. ");
INSERT INTO ksp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","See embakanraje. Sese ke e-majije ang le a kaseje ta pa tar ke maji toke baann wa?. Mba tarje ke ddusu me dew a aw tee tae te. ");
INSERT INTO ksp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Dew ke maji aw tee ke neje ke maji, ke toje mee te ke maji ke ddaka. A dew ke maji ang aw tee ke neje ke maji ang ke toje mee te ke maji ang ke ddaka tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","M-pa marese, tarje ke baa baa tɔyn ke dewje aw paje, da telje ke tar dɔe te ndɔ gange sariya te. ");
INSERT INTO ksp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mba Lubba a kunda tar dɔi te wase na kɔru tar dɔi te wɔju dɔ tar pa lei. ");
INSERT INTO ksp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yeenn ngaa, mare nje-kɔruje gel ndu ke mare Parijiyenje paje areje Jeju na: «Nje-ne-tɔju, e-dda mare ne-mɔri are joo.» ");
INSERT INTO ksp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nilade te na: «Dewje ke bbokone ke toje to dewje ke majije ang ddem, dewje ke toje gate gate ang ddem dujuje ne-mɔri. A bbay ne-mɔri ke da koo a to ne ke inga nje-kila mber-tar le Lubba Jonase. ");
INSERT INTO ksp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Mba ddew kara baa toke Jonase dda ndɔ mota ke til mota me tɔku kanji te, Ngonn le dew a dda ndɔ mota ke til mota me nange te tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ndɔ gange sariya a, dewje ke Ninibe a kinje ta gange sariya dɔ dewje te ke bbasine neenn. Mba dewje ke Ninibe le, Jonase ila mber-tar arede a, n̂-turuje ddew lede. A dew ke uta Jonase ee neenn. ");
INSERT INTO ksp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ndɔ gange sariya a, mbay-dene ke beer a kin ta gange sariya dɔ dewje te ke bbasine neenn. Mba lew, ni kɔyn nange te mba kaw koo tar kem-kare le salomɔ. A mare dew ke uta Salomɔ ee neenn. ");
INSERT INTO ksp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Toke ndil ke maji ang tee me dew te ke ddang a, naw n̂-sange lo me kɔr te ke ndo maann to te nungu yo, nungu ne ta kinga lo ke ta kuwa rɔe ke te a, ninga lo ang. ");
INSERT INTO ksp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Yeenn ngaa n̂-pa mee te na: «Ma tel key lem ke minya lew le.» Toke n̂-tel key le ngaa, noo a, to baa, me key le are ngate ngate ddem, toke mɔse ddem. ");
INSERT INTO ksp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Yeenn ngaa, naw n̂-jin mare ndilje ke maji ang nya utae bbay dɔde siri n̂-ddee kede ngaa, dandeje me key te le disije te. Goe te a, kisi le dew le tel maji ang nya uta ye ke kete. Ne ke a kinga dewje ke maji ang ke bbasine neenn a to ddew kara baa toke baann tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Toke Jeju nayn aw pa tar ke dewje ke banya le bbay a, kɔenje ke ngakɔenje n̂-ddeeje darje ddaka ngaa daw n̂-sangeje ddew ta pa saa tar. ");
INSERT INTO ksp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mare dew pa are na: «Kɔinje ke ngakɔinje darje ddaka ngaa, daw n̂-sangeje ddew ta pa sei tar.» ");
INSERT INTO ksp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jeju ila dew ke aw pa tar are le na: «Na bba to kɔmje wase, nje ke dda bba to ngakɔmje wa?» ");
INSERT INTO ksp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Goe te a nula jia ke rɔ nje-njaje goe te ngaa n̂-pa na: «Kɔmje ke ngakɔmje a neenn.» ");
INSERT INTO ksp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Toke dew dda ne ke me bɔmje ke darâ ndiki a, dew le to ngokɔm, to kɔnanem, wase to kɔmje.» ");
INSERT INTO ksp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ndɔe teenn njaa, Jeju tee me key te ke ddaka, aw isi kar tɔku dange te. ");
INSERT INTO ksp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Dewje banya banya mbɔnje naa rɔe te. Yeenn a, naw naal tɔku to nisi me te. A dewje le tɔyn arje ta kongo dange te le. ");
INSERT INTO ksp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","N̂-pa tar nya nya narede ddew gusu-tar te, n̂-pa na: «Mare dew aw ke ndɔɔ ta dubbu ne. ");
INSERT INTO ksp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kare ke naw n̂-dubbu ne le a, mare kande-ko le gayn dɔ ddew te. Eelje ddeeje ngaa ɔnje kande-ko le. ");
INSERT INTO ksp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mare kande ko le gayn dɔ nange te ke to er are nange ndeer dɔe te ang. Koje le teeje njange baa mba nange le ndeer ang. ");
INSERT INTO ksp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","A toke kare ɔsu nya a, puru kare le ɔn koje le are tutuje, mba ngirade ande nangê nya ang. ");
INSERT INTO ksp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mare kande ko le gaynje horo konnje te. Konnje le ngalje ngaa taa dɔ koje le. ");
INSERT INTO ksp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","A mare kande ko le gayn dɔ-nange te ke maji ngaa andeje. Mare ande dɔdɔku, mare dɔ misan, a mare ande dɔ mota. ");
INSERT INTO ksp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Dew ke ee mbi a, maji kare oo tar neenn. ");
INSERT INTO ksp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nje-njaje-go Jeju te ddeeje rɔe te ngaa dujeje na: «Mba ddi bba e-pa tar arede ddew gusu-tar te wa?» ");
INSERT INTO ksp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jeju ilade te na: «Sese, Lubba arese ddew ta gere neje ke toje lo kiyae te me Bbe-kɔn te laa ke darâ. A dede, narede ddew ang. ");
INSERT INTO ksp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mba dew ke ee ke ne a, da kila mare dɔe te kare, kare ne-kinga laa banya ne. A dew ke ne laa goto le, yee ke ten ke nee ne kara, da kɔru jia te ke ddang. ");
INSERT INTO ksp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Mba yeenn a maw m-pa ne tar marede ddew gusu-tar te mba daw daaje loo a dooje ne ang ddem, mbide aw oo tar a, dooje tar ang ddem, a n̂-gereje kande ang ddem. ");
INSERT INTO ksp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Yeenn a, tar le Lubba ke Ejayi nje-kila mber-pa laa pa wɔju dɔde le ddee ne to tar ke tɔkɔrɔ. Tar le na: «A kooje tar ke maje a, a gereje kande ang, a kaaje lo ke maje a, a kooje ne ang. ");
INSERT INTO ksp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mba dɔ dewje neenn ketere nya. Dutuje mbide ta koo tar ang, n̂-bbirije kemde ta koo lo ang, Yeenn a n̂-gereje ne kande tar ang, Ngaa n̂-turuje ddew lede ang kare mɔru rɔ-toje lede ang. ");
INSERT INTO ksp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","A sese, rɔ-neel to lese mba kemse aw oo ne ddeem, mbise aw oo tar ddem. ");
INSERT INTO ksp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mba m-pa marese tar ke tɔkɔrɔ, Nje-kilaje mber-tar le Lubba toke banya, ke dewje ke toke gate gate ke Lubba toke banya ndikije ta koo ke kemde ne ke aw ooje neenn a, dooje ang, n̂-ndikije ta koo ke mbide, a dooje ang.» ");
INSERT INTO ksp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","« Ooje gel gusu-tar ke dɔ nje ne-ddubu te le. ");
INSERT INTO ksp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Dewje ke ooje tar dɔ Bbe-kɔn te le Lubba a gereje kande tar le ang, toje ddew kara baa toke dɔ ddew ke kande koo gayn te le. Nje-baan ddee ɔru ne ke n̂-dubbu mede te le ke ddang. ");
INSERT INTO ksp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mare dewje toje ddew kara baa ke nange ke to er. Toke dooje tar le a, n̂-taaje ke rɔ-neel njange baa. ");
INSERT INTO ksp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","A tar le ungu ngira nange mede te ang, goe ew mede te ang. Bbo ne-kem-to-ndoo, wase ne-singa ddee ingade wɔju dɔ tar le Lubba a, koo me te lede oso njange baa. ");
INSERT INTO ksp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","A mare dewje toje ddew kara baa ke nange ke konnje ubbaje te le. Dooje tar le ke maje, a keje tarje wɔju dɔ neje ke nange neenn, ke bbo ne-kingaje tɔy dɔ tar le are tar le ande ang. ");
INSERT INTO ksp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","A mare dewje toje ddew kara baa ke nange ke maji ke n̂-dubbu ne te. Dooje tar le a, n̂-gereje kande ke maje ngaa dandeje kande. Mareje andeje dɔdɔku, mareje andeje dɔmisan, a mareje andeje dɔmota.» ");
INSERT INTO ksp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jeju tel pa mare gusu-tar arede na: «Bbe-kɔn ke darâ to ddew kara baa ke dew ke dubbu kande-ko ke maji me ndɔɔ te laa. ");
INSERT INTO ksp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kare ke dewje aw tibbije til te a, mare nje-baan ddee dubbu mu ke maji ang horo ko te ke maji le a ɔtu. ");
INSERT INTO ksp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kare ke koje le teeje ngaa aw andeje a, mu ke maji ang le tee tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nje-kulaje le nje-ndɔɔ le ddeeje rɔe te ngaa paje na: «Ebbejeje, kande-ko ke maji a e-dubbu ndɔɔ lei. A lo ke dda bba mu ke maji ang neenn in te wa?» ");
INSERT INTO ksp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nilade te na: «Mare nje-baan a dda neenn.» Yeenn ngaa nje-kulaje le dujeje na: E-ndiki kare jaw n̂-tɔru mu ke maji ang le ke ddang wa?» ");
INSERT INTO ksp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nilade te na: «E-tɔruje ang mba, kare aw tɔruje mu ke maji ang le a, e-tɔruje ne koo ke maji le tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Inyajede are n̂-nduje naa te ndereng ndɔ kuja ko te. A bbo ndɔ kuja ko le ase a, ma pa kare nje ke a kujaje koo le na: E-tɔruje mu ke maji ang le dɔngɔr, ngaa e-tɔje ke dɔe dɔe ta ulaje puru te.» Goe te a e-toje koo ke maji le unguje me dam te lem.» ");
INSERT INTO ksp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jeju tel pa mare gusu-tar arede bbay na: Bbe-kɔn ke darâ to ddew kara baa ke kande ko ke ria na motarde ke dew unn ngaa dubbu me ndɔɔ te laa. ");
INSERT INTO ksp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","To kande ko ke to ten uta kese kande koje tɔyn. A toke n̂-tee a, n̂-ngal nuta kese koje tɔyn ke me ndɔɔ te. N̂-ddee to kake are eelje ke darâ ddeeje ddaje key lede me barkemeje te.» ");
INSERT INTO ksp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jeju pa mare gusu-tar arede bbay na: «Bbe-kɔn ke darâ to ddew kara baa ke wum ke dene unn ngaa bɔkɔlɔ ke nduju ase sambe kara are bɔru nduju le ti.» ");
INSERT INTO ksp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ddew gusu-tarje te a Jeju aw pa ne tarje neenn tɔyn are dewje ke banya. Mare tar kara ke na pa karede baa a kinya gusu-tar goto. ");
INSERT INTO ksp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yeenn bba tar le Lubba ke nje-kila mber-tar pa le ddee ne to tar ke tɔkɔrɔ. N̂-pa na: «Ma kunn gusu-tar bba ma pa ne tar, Ma kila mber neje ke toje lo-kiyae te unn kutue dɔ ndɔ te ke m-dda ne neje tɔyn.» ");
INSERT INTO ksp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yeenn a, Jeju inya dewje ke banya le ngaa aw key. Nje-njaje-goe te awje ngɔsi saa ngaa paje areje na: « Ɔru gel gusu-tar ke dɔ tiro te le areje joo.» ");
INSERT INTO ksp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nilade te na: «Nje-dubbu ko ke maji le to Ngonn le dew. ");
INSERT INTO ksp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ndɔɔ le to dewje ke dɔ nange te. Ko ke maji le to dewje ke me Bbe-kɔn le. A mu ke maji ang le to dewje ke toje to engan Nje-baan. ");
INSERT INTO ksp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nje-baan ke dubbu mu ke maji ang le to Esu. Ndɔ kuja kande ko le to ddutu ndɔ, nje-kujaje kande ko le to anjije. ");
INSERT INTO ksp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ddutu ndɔ a, ne a to ddew kara baa toke daw n̂-tɔru mu ke maji ang ta kungu poro. ");
INSERT INTO ksp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ngonn le dew a kula anjije laa kare n̂-tɔruje dewje ke aw ddaje are koo me te le nje-marede aw oso, ke dewje ke aw ddaje neje ke maji ang me bbe-kɔn te laa, ");
INSERT INTO ksp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ta da kungude kem tɔku puru te. Lo teenn, da nɔnje ngaa da ngerje ngangede. ");
INSERT INTO ksp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","A kare teenn, dewje ke toje gate gate ke Lubba a ndɔrenje kayn kayn toke le kare me Bbe-kɔn te le Bɔdede. Dew ke ee ke mbi a oo tar neenn.» ");
INSERT INTO ksp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Bbe-kɔn ke darâ to ddew kara baa ke ne-kinga ke diya me ndɔɔ te. Mare dew tee dɔe te ngaa iya toke siki. Rɔe neele ngaa, naw n̂-labbe neje laa tɔyn, a n̂-tel n̂-ddee n̂-ndoko ndɔɔ le.» ");
INSERT INTO ksp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Bbe-kɔn ke darâ to ddew kara baa tɔ ke nje-ne-labbe ke aw sange mereje ke kura. ");
INSERT INTO ksp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Toke ninga mare mere ke gate ngeng a, naw n̂-labbe neje laa tɔyn ngaa n̂-ddee n̂-ndoko mere le.» ");
INSERT INTO ksp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Bbe-kɔn ke darâ to ddew kara baa tɔ ke ddenge ke dila bâ ngaa uwa kanjije dang dang. ");
INSERT INTO ksp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Toke kanjije ddusu ddenge le a, nje-ndɔnje-maann le ndɔruje teeje ne ta maann te ngaa isije nange ngaa ɔruje kem kanjije le. Kanjije ke maji a dunguje me kare te, a n̂-tilaje kanjije ke maji ang kɔrɔ. ");
INSERT INTO ksp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ne a to ddew kara baa toke baann ddutu ndɔ te tɔ. Anjije a ddeeje ta kɔru kem dewje ke maji ang ke dewje ke gate gate, ");
INSERT INTO ksp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ta kungude kem tɔku puru te. Lo teenn, da nɔnje ngaa da ngerje ngangede.» ");
INSERT INTO ksp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jeju duju nje-njaje goe te na: «E-gereje kande tarje neenn tɔyn njaa wa?» Dilaeje te na: «N-gere njaa.» ");
INSERT INTO ksp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","N̂-pa narede na: «Mba yeenn a, nje-kɔru gel ndu ke gere neje ke dɔ Bbe-kɔn te ke darâ to ddew kara baa ke nje-key ke oto neje ke siki ke konn neje me dam te laa tee ne.» ");
INSERT INTO ksp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Toke Jeju pa gusu-tarjeenn le nunga a, nɔtu loe teenn. ");
INSERT INTO ksp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Naw Najarete, bbe te ke n̂-tɔku kete, ngaa nunn kutu tɔju ne dewje me key-mbɔnaaje te lede. Ne-tɔjuje laa le gange singade ngaa n̂-paje na: «Ninga ne-gere neenn dda wa? Ninga singa dda ne-mɔrije neenn dda wa? ");
INSERT INTO ksp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ngonn le nje-dda kake le a neenn ang wa? Kɔenje a to Mari ngaa ngakɔenje a toje to Jake, Jejebbe, Simɔ, ke Jude ang wa? ");
INSERT INTO ksp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ngakɔnaneje tɔyn eeje horoje te neenn tɔ ang wa? Yeenn a, ninga singa dda neje neenn dda wa?» ");
INSERT INTO ksp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nejeenn dda are doo mede te ang. A Jeju pa arede na: «Dewje aw walje nje-kila mber-tar le Lubba kese loje te tɔyn, bbo bbe te ke nisi te, wase me key te laa ang.» ");
INSERT INTO ksp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jeju dda ne-mɔrije nya nya Najarete ang mba, dooje mede te ang. ");
INSERT INTO ksp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Dɔ ndɔe teenn, Erode Antipase ke to mbay ke Galile oo tam Jeju a, ");
INSERT INTO ksp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","pa are nje ke aw ddaje kula kɔye te na: «Jan Batisi ann. Ni horo dewje te ke oy! Mba yeenn a ninga singa ta dda ne-mɔrijeenn.» ");
INSERT INTO ksp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Mba kete, Erode are duwa Jan n̂-tɔe dilae key-kula te wɔju dɔ Erodiade ke to dene le ngokɔen Pilipi. ");
INSERT INTO ksp_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Mba Jan pa are na: «Ee ke ddew ta taa Erodiade to dene lei ang.» ");
INSERT INTO ksp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erode ndiki ta tɔl Jan le, a n̂-bbeel Jiipije mba dooje Jan to nje-kila mber-tar le Lubba. ");
INSERT INTO ksp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","A ndɔ kusu kuju Erode a, ngonn le Erodiade ke dene la nɔ dewje te are neel Erode nya. ");
INSERT INTO ksp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Yeenn a, Erode unda yo are ngonn ke dene le na: «Ne tɔyn ke e-duju a, ma kari.» ");
INSERT INTO ksp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kɔenje tulae are n̂-pa na: «Lo te neenn njaa, arem dɔ Jan Batisi me tɔku pambala sambe te.» ");
INSERT INTO ksp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Rɔ Erode neele ang. A nunn ndu kare dare neenn le wɔju dɔ yo ke nunda kem dewje te ke n̂-bbarde kusu te le. ");
INSERT INTO ksp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yeenn a, nula dew key-kula te nare aw gange dɔ Jan le. ");
INSERT INTO ksp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Dila dɔ Jan me tɔku pambala sambe te ngaa n̂-ddee ne dare ngonn ke dene le aw ne are kɔenje. ");
INSERT INTO ksp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nje-njaje-go Jan te le ddeeje unnje niine aw dubbuje. Goe te a, daw n̂-paje tare dareje Jeju. ");
INSERT INTO ksp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Toke Jeju oo tar neenn le a, nunn tɔku to ngaa nɔtu lo teenn naw ke kare baa lo te ke iya rɔe. A dewje ke banya ooje tare ngaa, inje me tɔku bbeje te le unnje go maann, ɔruje goe ke gɔlde. ");
INSERT INTO ksp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Toke Jeju in me tɔku to te le uru nangê ngaa oo dewje ke banya le a, ddae ndoo. Yeenn a nɔru rɔ-to rɔ nje-rɔ-toje te lede. ");
INSERT INTO ksp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Dɔ-kare a, nje-njaje-go Jeju te ddeeje paje areje na: «Lo neenn to me mu baa, ngaa kare tɔy mban tɔ. E-tubba dewje ke banya banya neenn le are dawje me bbeje te n̂-ndokoje ne dusaje.» ");
INSERT INTO ksp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","A Jeju ilade te na: «Moo a, to maji kare dawje ang. Sese njaa arejede ne dusa.» ");
INSERT INTO ksp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","A n̂-paje dareje na: «Jee ke mapa mi ke kanjije joo baa jije te neenn.» ");
INSERT INTO ksp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jeju pa arede na: «E-ddeeje ne aremje.» ");
INSERT INTO ksp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Goe te a, nare dewje ke banya le isije dɔ muje te, a n̂-taa mapa ke mi ke kanji ke joo le, ngaa nunn keme ke darâ a nare wooyo Lubba. Goe te a, n̂-tete mapa ke mi le ngaa nare nje-njaje goe te nare n̂-kayn dewje ke banya le. ");
INSERT INTO ksp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Dede tɔyn dusaje ne dare mede ndann, ngaa n̂-mbɔnje kese ke nayn ddusu kare dɔku gire joo. ");
INSERT INTO ksp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Dewje ke usaje ne le aseje ne ke doro mi. Deneje ke ngannje n̂-turade ang. ");
INSERT INTO ksp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Njange baa goe te a, Jeju are nje-njaje goe te aalje tɔku to kare daw n̂-nginaeje tura maann te kete. A ne na nayn ta tubba dewje ke banya le kare n̂-telje bbeje te lede. ");
INSERT INTO ksp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","N̂-tubba dewje ke banya le. Goe te a, naal dɔ ddingiri ta kaw duju Lubba ddew ew. Dɔ-lo-kul pe a nisi lo teenn ke kare baa. ");
INSERT INTO ksp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","To le aw ddew ew ke nange ngaa a, lel ula aw tila ne kem nje-njaje go Jeju te le are maann le aw lenge tɔku to le ke singa nya. ");
INSERT INTO ksp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ngɔsi ke ta-lo-kare a, Jeju aw nja dɔ maann te le aw ne ke rɔ nje-njaje goe te le. ");
INSERT INTO ksp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Toke nje-njaje goe te ooeje ke naw n̂-nja dɔ maann te le a, dɔde saren ngaa n̂-paje na: «Uma ann!» Ngaa bbeel ddade nya are daw duruje ekii. ");
INSERT INTO ksp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","A Jeju pa arede njange baa na: «Ema ann, e-bbeelje ang!» ");
INSERT INTO ksp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Yeenn ngaa Piyar ilae te na: «Ebbe-dewje, bbo to ei a, unn ndui are m-nja dɔ maann te maw rɔi te.» ");
INSERT INTO ksp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jeju pa na: «E-ddee!» Piyar in me tɔku to te le ddisi ngaa unn kutu nja dɔ maann te le ta kaw ke rɔ Jeju te. ");
INSERT INTO ksp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","A toke Piyar oo lel ke aw ula ke singa nya le a bbeel ddae, are nunn kutu dii maann le. Yeenn a, nuru ekii na: «Ebbe-dewje, ajim!» ");
INSERT INTO ksp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Njange baa njaa Jeju ula jia uwae ne ngaa pa are na: «Koo me te lei to ten baa nya, mba ddi bba eje tar wa?» ");
INSERT INTO ksp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Dede joo keme daalje me tɔku to te le ngaa goe te a lel le ew rɔe. ");
INSERT INTO ksp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Yeenn a, nje-njaje go Jeju te ke eeje me tɔku to te le ɔsuje mekeje gɔlde nangê nɔe te ngaa paje na: «E-to Ngonn le Lubba njaa.» ");
INSERT INTO ksp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","N̂-gangeje maann le ngaa, n̂-teeje nange te ke Jenejarete. ");
INSERT INTO ksp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Dewje ke lo teenn le gereje Jeju. Dulaje ke tar laa dɔ nange teenn le tɔyn dare dewje ngaa, n̂-ddeeje ke nje-rɔ-toje tɔyn rɔe te. ");
INSERT INTO ksp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","N̂-ddaje rɔde to ndoo rɔe te kare ninya ddew nare ta-kubbu laa njaa baa kara nje rɔ-toje le ɔruje ke jide. Yeenn a dede tɔyn ke dɔreje le rɔ-toje lede tunga. ");
INSERT INTO ksp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Parijiyenje ke nje-kɔruje-gel-ndu inje Jurusalem ddeeje rɔ Jeju te ngaa dujeje na: ");
INSERT INTO ksp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Mba ddi bba nje-njaje goi te aw mbeteje ne-ji-bbeje le kajeje wa? Mba daw ta kusa ne a, n̂-tokoje jide ang.» ");
INSERT INTO ksp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jeju ilade te na: «A sese, e-ddaje ne ke turu Ndu le Lubba ang a ne-ji-bbeje lese a aw ddaje mba ddi wa? ");
INSERT INTO ksp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mba Lubba pa na: ‹E-bbeel bɔije ke kɔinje.› N̂-pa tɔ na: ‹Dew ke ndɔɔl bɔeje wase kɔenje a maji kare n̂-tɔle.› ");
INSERT INTO ksp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","A sese e-paje na: ‹Toke dew pa are bɔeje wase kɔenje na: Ne ke meje ta kumai ne le to ne ke m-ngem mba Lubba a, ");
INSERT INTO ksp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","to tar le dew le ta bbeel bɔeje ang ngaa.› Ne-ddaje ke baann a aw ddaje are tar le Lubba ddee ne to ne ke baa wɔju dɔ ne-ji-bbeje lese. ");
INSERT INTO ksp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","See nje-ngemje, Ejayi ila mber tar le Lubba neenn dɔse te ke dɔgɔle. Tar le na: ");
INSERT INTO ksp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹Dewje neenn aw walemje tade te baa, a mede to dang sem. ");
INSERT INTO ksp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Polo ke daw n̂-polomje to polo ke ture goto, mba neje ke daw n̂-tɔjuje toje to nduje ke dewje baa a unnje.› » ");
INSERT INTO ksp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Goe te a, Jeju bbar dewje ke banya le ngaa pa arede na: «Ooje tar lem bbo e-gereje kande tar neenn ke maje! ");
INSERT INTO ksp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ne ke aw aw me dew te a aw dda are dew ddee ne to ne-yerew ang. Ne ke aw tee ta dew te a aw dda are dew ddee to ne-yerew.» ");
INSERT INTO ksp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Goe te a, nje-njaje goe te ddeeje rɔe te ngaa paje areje na: «Tar ke e-pa le oso wur Parijiyenje le e-gere njaa wa?» ");
INSERT INTO ksp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jeju ilade te na: «Kake tɔyn ke Bɔy ke ee darâ a ula ang, da kɔru ke ngirae baa. ");
INSERT INTO ksp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Inyajede. N̂-toje to nje-kem-tɔje ke aw ilaje kake ji nje-kem-tɔ mare de je te. Bbo nje-kem-tɔ ila kake ji nje-kem-tɔ te a, dede joo kem da kosoje me buwa te.» ");
INSERT INTO ksp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Yeenn ngaa, Piyar pa are Jeju na: «Ɔru gel gusu-tar ke e-pa neenn areje joo.» ");
INSERT INTO ksp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jeju ilae te na: «Sese kara e-naynje to dewje ke gere ne ang bbay wa? ");
INSERT INTO ksp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","E-gereje ang wa? Ne tɔyn ke ande ta dew te aw mee te ngaa goe te a tee ungu kɔrɔ. ");
INSERT INTO ksp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","A ne ke tee ta dew te in me dew te. Neenn a aw dda are dew tel to ne-yerew. ");
INSERT INTO ksp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mba kejeje ke majang neenn tɔyn inje me dew te: Tɔl dew, lo-to-majang, dda kaya, bboko, tar-naji ke ke dɔgɔle ang, nane ke naa. ");
INSERT INTO ksp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Neje ke baann a aw dda are dew ddee ne to ne-yerew. A toko ji ang a kusa ne ne bba aw dda are dew ddee to ne-yerew ang.» ");
INSERT INTO ksp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jeju ɔtu loteenn aw nange te ke Tir, ke Sidon. ");
INSERT INTO ksp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mare dene ke Kana ke isi nange teenn ddee rɔ Jeju te ngaa uru ekii na: «Ebbe-dewje, ngonn le Dabbiti, oo kem to ndoo lem! Ndil ke maji ang aw ula kem ngunnun ke dene ndoo nya.» ");
INSERT INTO ksp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","A Jeju le ilae tar te kara ang. Nje-njaje-goe te ddeeje rɔe te ngaa dujueje na: «E-tubba dene neenn ke ddang mba naw nuru ekii naw n̂-ndole ne goje.» ");
INSERT INTO ksp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","A Jeju ilade te na: «Ngann Ijarayelje ke toje toke ngann bateje ke naynje kɔrɔ a Lubba ulam mba de a bbaye.» ");
INSERT INTO ksp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","A dene le ddee ungu mekeje gɔle nangê nɔ Jeju te ngaa pa na: «Ebbe-dewje, umam!» ");
INSERT INTO ksp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nilae te na: «Maji ta kunn ne-kusa ke to wɔju dɔ ngannje kungu kare ngann bisije ang.» ");
INSERT INTO ksp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Dene le ilae te na: «Ye njaann, Ebbe-dewje! A ngann bisije aw usaje buru ne-kusaje ke aw gaynje nangê kɔ tabele te le ebbede tɔ.» ");
INSERT INTO ksp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yeenn ngaa Jeju pa are na: «Dene, koo me te lei bo nya. Maji kare Lubba ari ne ke aw duju le.» A kare teenn njaa rɔ ngonne ke dene le ddee maji. ");
INSERT INTO ksp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Goe te a, Jeju ɔtu keteenn ngaa aw kar tɔku dange te ke Galile. Naw naal dɔ ddingiri nisi te. ");
INSERT INTO ksp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Yeenn ngaa dewje ke banya banya ddeeje rɔe te ke nje-meteje, nje-gɔl-gotoje, nje-kem-tɔje, dewje ke mbide utu ddem, tade utu ddem, ke dewje ke eeje ke mare rɔ-toje dang dang. N̂-ddeeje ke de dungude nɔ Jeju te ngaa nɔru rɔ-to rɔde te. ");
INSERT INTO ksp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Toke dewje ke banya le ooje nje-meteje ke mete lede nunga, nje-gɔl-gotoje ke gɔlde ddee maji, nje-kem-tɔje ke ooje lo, ke dewje ke mbide utu ddem tade utu ddem aw paje tar, ke dewje ke eeje ke mare rɔ-toje dang dang ke rɔde ddee maji a, mede unda dɔ benya ngaa dɔseje gaji Lubba le Ijarayel. ");
INSERT INTO ksp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jeju bbar nje-njaje goe te ngaa pa arede na: «Dewje ke banya banya neenn ddamje ndoo. N̂-naynje sem ndɔ mota ngaa, a dingaje ne ta kusa ang. M-ndiki ta kinyade kare n̂-telje mede bbo baa ang, mba singade a kin kɔru ke ddew.» ");
INSERT INTO ksp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nje-njaje-goe te paje areje na: «Ja kinga ne-kusa dda lo te ke to me kɔr baa neenn ta kare ase dewje ke banya neenn wa?» ");
INSERT INTO ksp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jeju dujude na: «Eeje ke mapa baann wa?» Dilaeje te na: «Jee ke mapa siri, ke mare ngann kanjije tɔ.» ");
INSERT INTO ksp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yeenn ngaa Jeju duju dewje ke banya le kare isije nangê. ");
INSERT INTO ksp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","N̂-jin mapa ke siri, ke kanjije le ngaa goe te a nare wooyo Lubba a, n̂-tete ngaa nare nje-njaje goe te are dewje ke banya banya le. ");
INSERT INTO ksp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Dede tɔyn dusaje ne dare asede. A n̂-mbɔn kese ne-kusaje ke nayn le ddusu ngann kare siri. ");
INSERT INTO ksp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Dewje ke usaje ne le eeje doro sɔ. A n̂-tura deneje ke ngannje ang. ");
INSERT INTO ksp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Goe te a, Jeju tubba dewje ke banya le are ɔtuje, a naal tɔku to naw nange te ke Magadan. ");
INSERT INTO ksp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parijiyenje, ke Saduseyenje ddeeje rɔ Jeju te ta nae. N̂-dujeje na: «E-dda mare ne-mɔri ke tɔju to Lubba a ulai are joo.» ");
INSERT INTO ksp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","A Jeju ilade te na: «Dɔ-lo-kul a, e-paje na: ‹Lo a to ke maje mba me dara kase.› ");
INSERT INTO ksp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ke endɔɔ a, e-paje na: ‹Ndi a kere bbokone mba me dara kase ngaa tel tuka ndul.› Bbo aaje kem dara a e-gereje ne ke a to. A, aseje ta gere ne ke a ddee go neje te ke aw ooje bbasine neenn ang wa? ");
INSERT INTO ksp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Dewje ke bbasine ke majije ang, ngaa toje gate gate ke Lubba ang dujuje ne-mɔri. A bbay ne-mɔri ke da koo a to ne ke inga nje-kila mber-tar le Lubba Jonase.» Goe te a, Jeju inyade a ɔtu. ");
INSERT INTO ksp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kare te ke nje-njaje go Jeju te awje ta gange tɔku dange kaw turâ a, mede oy ta kaw ke mapaje. ");
INSERT INTO ksp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yeenn a Jeju pa arede na: «Aaje rɔse wɔju dɔ wum le Parijiyenje ke Saduseyenje. ");
INSERT INTO ksp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nje-njaje-goe te le aw paje tar mbi naa te na: «Kake meje oy ta ddee ke mapa le a naw n̂-pa ne tar neenn.» ");
INSERT INTO ksp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jeju gere tar ke daw n̂-paje horo naa te le ngaa dujude na: «Mba ddi bba aw paje tar horo naa te e-paje na: ‹Mba mapa ke n-ddee ne ang le ann wa›? Koo me te lese bo ang. ");
INSERT INTO ksp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nayn e-gereje ang bbay wa? Mapa ke mi ke dingawje doro mi usaje ngaa e-mbɔnje kese kare baann wa le, mese oy dɔe wa? ");
INSERT INTO ksp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Wase ye ke siri ke dingawje doro sɔ usaje ngaa e-mbɔnje kese ddusu kare baann wa le, mese oy dɔe wa? ");
INSERT INTO ksp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Toke m-pa marese m-pa na: Aaje rɔse wɔju dɔ wum le Parijiyenje ke wum le Sadusiyenje a, tar le mbɔbbu tar mapa ang. A mba ddi bba a kaseje ta gere me tar le ang wa?» ");
INSERT INTO ksp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yeenn ngaa, nje-njaje go Jeju te le gereje to tar ke Jeju aw pa wɔju dɔ ne-tɔjuje le Parijiyenje, ke Saduseyenje bbo to tar wum mapa ang. ");
INSERT INTO ksp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Toke Jeju tee nange te ke Sejare ke Pilipi a duju nje-njaje goe te na: «Dewje aw paje na m-to na wa?» ");
INSERT INTO ksp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Dilaeje te na: «Mareje paje na e-to Jan̂-Batisi, mareje paje na e-to Eli, a mareje paje na e-to Jeremi wase, a to kara le nje-kilaje mber-tar le Lubba.» ");
INSERT INTO ksp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jeju dujude na: «A sese, e-paje na m-to na wa?» ");
INSERT INTO ksp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Piyar ilae te na: «E-to Mesi, Ngonn le Lubba ke isi kem baa.» ");
INSERT INTO ksp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yeenn ngaa Jeju pa are na: «Simɔ ngonn le Jonase, rɔ-neel to lei, mba Bɔy ke darâ a pa gel ne neenn ke ddaka ari bbo dew a pa ari ang. ");
INSERT INTO ksp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","A ema, m-pa mari: E-to Piyar. Dɔ er te neenn le a ma kɔsu Egilisi*** lem ke te. Ngaa yo a kase dda mare ne ke Egilisi le ang. ");
INSERT INTO ksp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ma kari kele ta Bbe-kɔn ke darâ. Ne tɔyn ke ɔku ddewe nangê to ne ke dɔku ddewe darâ mban, ne tɔyn ke ɔru ddewe nangê neenn, Lubba ɔru ddewe darâ mban tɔ.» ");
INSERT INTO ksp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Goe te a, Jeju ndɔru mbi nje-njaje goe te na dang kara n̂-paje dare mare dew to n̂-to Mesi ang. ");
INSERT INTO ksp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Dɔ ndɔe teenn njaa, Jeju unn kutu pa ke ddaka kare nje-njaje goe te to to tar le ne ta kaw Jurusalem, ta koo ndoo ji tɔkuje te le Jiipije, ke tɔku nje-poloje Lubba, ke nje-kɔruje gel-ndu. Da kare n̂-tɔlne ta ndɔ mota goe te a, na kin horo dewje te ke oy. ");
INSERT INTO ksp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Piyar ɔre ke guku ngaa unn kutu kin saa na: «Ebbe-dewje, maji kare Lubba ɔri me te ke ddang. Neenn a kingai ndɔ kara ang.» ");
INSERT INTO ksp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","A Jeju turu rɔe ngaa pa are Piyar le na: «Esu, ɔtu ke ddang aw ddew ew sem! E-to dew ke a ta tuju ddew lem, mba keje lei to keje le Lubba ang, to keje le dewje baa.» ");
INSERT INTO ksp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yeenn a, Jeju pa are nje-njaje goe te na: «Dew ke ndiki ta kunn gom a, maji kare neje rɔe ang ngaa, maji kare noto kake-dese laa ngaa nunn gom. ");
INSERT INTO ksp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mba dew ke ndiki ta ngem tebbe laa a, a kinga tebbe laa le ang. A dew ke ila rɔe kɔrɔ wɔju dɔm a, a tel kinga tebbe laa le. ");
INSERT INTO ksp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Toke dew inga ne ke nangê neenn tɔyn ngaa tebbe laa nayn ke kɔrɔ a, ne ke maji ddi a na kinga ture te wa? Ddi a na kare ta tel kinga ne tebbe laa le wa? ");
INSERT INTO ksp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mba Ngonn le dew a ddee me piti te le Bɔeje, ke anjije laa. Ngaa na kuka dew kara kara ase kula ddae. ");
INSERT INTO ksp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tɔkɔrɔ, m-pa marese: Mare dewje ke eeje neenn a koyje ang ndereng da kooje Ngonn le dew ke a ddee ta kɔn bbe to tɔku-mbay. ");
INSERT INTO ksp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Dda ndɔ misan goe te a, Jeju jin Piyar, Jake de ke Jan ke to ngokɔn Jake ungude dɔe te ngaa aw ke de dɔ ddingiri te ddew ew. ");
INSERT INTO ksp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Rɔ Jeju turu to dang kemde te ngaa keme unn kutu ndoko toke le kare ngaa kubbu laa turu ndɔren to ndɔren. ");
INSERT INTO ksp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","A ta koo a, nje-njaje goe te le ooje Moyiji, ke Eli aw paje tar ke Jeju le. ");
INSERT INTO ksp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Piyar pa are Jeju na: «Ebbejeje, to maji kare n-naynje neenn. Bbo e-ndiki te sem a, ma dda key-kam mota lo te neenn. Kara lei, kara to le Moyiji, kara to le Eli.» ");
INSERT INTO ksp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kake n̂-nayn naw n̂-pa tar bbay a mare mum ke ndɔren ddee kiri dɔde. Ndu Lubba bbar me mum te le na: «Dew neenn to ngonn ndiki lem, ke rɔm nelem nya wɔju dɔe. Maji kare ooje tae.» ");
INSERT INTO ksp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kake nje-njaje go Jeju te le ooje ndu Lubba le a, bbel uta dɔde are n̂-tee dosoje n̂-debbeje kemde nangê. ");
INSERT INTO ksp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jeju ddee rɔde te, ɔrude ke jia ngaa pa na: «E-bbeelje ang, inje taar.» ");
INSERT INTO ksp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kare ke dunnje kemde ke taar a, Jeju ke kare baa njaa ngaa a dooeje. ");
INSERT INTO ksp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kare ke dinje dɔ dngiri te le daw n̂-ddisije a, Jeju ndɔru mbide na: «Dang bba e-paje tar dɔ ne te ke ooje neenn areje mare dew ang ndereng ndɔ ke Ngonn le dew a kin horo dewje te ke oy.» ");
INSERT INTO ksp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nje-njaje-goe te dujeje na: «Mba ddi bba nje-kɔruje gel-ndu na Eli a, a ddee dɔngɔr bba wa?» ");
INSERT INTO ksp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nilade te na: «Tɔkɔrɔ, Eli a, a ddee dɔngɔr mba mɔse neje tɔyn dɔgɔle te. ");
INSERT INTO ksp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","A ema m-pa marese to Eli ddee mban. Dewje gereje ang a ddaje saa ne ke mede ndiki. Da dda Ngonn le dew majang ddew kara baa toke baann tɔ.» ");
INSERT INTO ksp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nje-njaje-goe te gereje ke maje to, to tar le Jan-Batisi a naw n̂-pa. ");
INSERT INTO ksp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jeju de ke nje-njaje goe te n̂-teeje ngɔsi ke dewje ke banya. Mare dew ddee rɔe te ngaa ungu mekeje gɔle nangê nɔe te. ");
INSERT INTO ksp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","N̂-pa na: «Ebbemje, oo kem-to-ndoo le ngunum ke dingaw neenn. Rɔ-to ndilje ke maji ang ddae are noo ndoo nya. Noso me puru te wase me maann te gɔl banya nya. ");
INSERT INTO ksp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Maw saa rɔ nje-njaje goi te, a dumaje ne pin.» ");
INSERT INTO ksp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jeju pa na: «See dewje ke bbasine koo me te lese goto ddem, e-gereje dɔjise ang ddem. Ma nayn ke se bbay mba ndɔ baann wa? Ma tɔ wurum dɔ kula-ddase te mba ndɔ baann bbay wa? E-ddeeje ke ngonn le ke neenn aremje.» ");
INSERT INTO ksp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jeju ndange ndil ke maji ang le ngaa n̂-tee ke ddang are kare teenn njaa, rɔ ngonn le ddee maji. ");
INSERT INTO ksp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yeenn a, nje-njaje-go Jeju te le ddeeje rɔe te de saa̍ ke karede baa ngaa dujeje na: «Mba ddi bba ja ta tubba ndil ke maji ang neenn a juma ne pin wa?» ");
INSERT INTO ksp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jeju pa arede na: «Mba koo me te lese ten baa. Tɔkɔrɔ m-pa marese, bbo koo me te lese to ten baa toke le kande ko ke ria na motarde a e-paje are ddingiri neenn na: ‹E-ngese neenn aw to yonn› a, na ngese.› Mare ne kara ke a kuta singase goto. ");
INSERT INTO ksp_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Toke e-mbeteje ne-kusa ngaa e-dujuje Lubba nya bba a tubbaje ndilje ke baann.» ");
INSERT INTO ksp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Mare ndɔ, toke nje-njaje-go Jeju te ingaje naa Galile a n̂-pa narede na: «Da kula Ngonn le dew ji dewje te. ");
INSERT INTO ksp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Da tɔleje ngaa ndɔ mota laa a na kin horo dewje te ke oyje.» Toke nje-njaje go Jeju te ooje tar le a, n̂-ndingaje ndoo nya. ");
INSERT INTO ksp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Toke Jeju de ke nje-njaje goe te n̂-teeje Kaperenayum a, nje-taaje nare-lambo key-polo Lubba ddeeje rɔ Piyar te ngaa dujeje na: «Nje-ne-tɔ lese uka lambo key-polo-Lubba ang wa?» ");
INSERT INTO ksp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piyar ilade te na: «Naw nuka njaa!» Kake Piyar a ta kande key be a, Jeju ɔru tae dɔngɔr ngaa pa na: «Simɔ, keje lei dɔ tar te neenn toke baann wa? Nje ke dda a aw ukaje lambo ke mbayje ke nangê neenn wa? Ngann nje-bbeje wase nje-mbaje wa?» ");
INSERT INTO ksp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piyar ilae te na: «Nje-mbaje.» Jeju ilae te na: «Yeenn a to tar le ngann nje-bbeje ta kuka lambo ang. ");
INSERT INTO ksp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kare jula wungu mede te ang a, aw bâ aw ila kii. Dɔngɔr kanji ke a kɔre njaa a, e-teyn tae a, a kinga kande nare. Unn kande nare le aw ne arede to lambo lem ddem, lei ddem.» ");
INSERT INTO ksp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kare teenn, nje-njaje-go Jeju te ddeeje rɔe te ngaa dujeje na: «Na to dew ke bo horo dewje te ke eeje me Bbe-kɔn te ke darâ wa?» ");
INSERT INTO ksp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jeju bbar mare ngonn, undae horode te danna ");
INSERT INTO ksp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ngaa pa na: «Tar ke tɔkɔrɔ a maw m-pa marese. E-turuje ddew lese ta ddee toke ngannje ke ngaji neenn. Baann ang a, a kandeje me Bbe-kɔn te ke darâ ndɔ kara ang. ");
INSERT INTO ksp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Dew ke dda rɔe ten toke ngonn neenn to dew ke bo me Bbe-kɔn te ke darâ. ");
INSERT INTO ksp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Dew ke taa ngonn ke ngaji toke be ke rɔe te wɔju dɔm a, ema njaa a n̂-tam ke rɔe teenn.» ");
INSERT INTO ksp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Dew ke dda are mare dew horo ngannje ke ngaji ke ooje mede te sem oso me majang te a, maji ta tɔ tɔku biri er gɔse te kilae me tɔku ba te. ");
INSERT INTO ksp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","To kem-to-ndoo nya. Ne ke a dda kare dew oso me majang te banya nya. Tɔkɔrɔ, ne ke a dda kare dew oso me majang te a to ke ndɔ tɔyn. A to ndoo nya kare dew ke dda are nje mare oso. ");
INSERT INTO ksp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Toke jii wase gɔli dda are oso me majang te a, e-gangede ungude kɔrɔ. Kaw lo te ke dewje isije te ke tebbe ji kara wase gɔl kara maji uta kaw kem puru te ke aw ɔn ke ndɔ ke ndɔ jii joo kem wase gɔli joo kem. ");
INSERT INTO ksp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","A bbo kemi dda are oso me majang te a, maji kare ɔru kemi le ila kɔrɔ. Kaw lo te ke dewje isije te ke tebbe kemi kara baa maji uta kaw kem puru te ke aw ɔn ke ndɔ ke ndɔ kemi joo kem.» ");
INSERT INTO ksp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Aaje ke maje! E-yabbeje mare dew kara horo dewje te ke ten neenn ang. M-pa merese, anjije lede aw arje ke ndɔ tɔyn nɔ Bɔmje te darâ. ");
INSERT INTO ksp_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mba Ngonn le dew ddee ta kaji dewje ke naynje ke kɔrɔ. ");
INSERT INTO ksp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Tar ddi a aw ejeje dɔ gusu-tar te neenn wa? Toke mare dew ee ke bateje kɔr kara ngaa mare kara nayn a, na kinya keseje ke dɔjikara gire jikara le dɔ ddingiri te mba tel kaw sange ye ke kara le kingae bba ang wa? ");
INSERT INTO ksp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A toke ningae a, m-pa marese, rɔe a neele nya wɔju dɔ bate ke kara le uta rɔe ke a neele wɔju dɔ bateje ke dɔjikara gire jikara ke naynje ang le. ");
INSERT INTO ksp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ddew kara baa, Bɔsese ke ee darâ ndiki kare mare dew kara horo dewje te ke ten neenn nayn kɔrɔ ang.» ");
INSERT INTO ksp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Toke ngokɔin dda sei majang a, aw ingae ke kare e-pa are. Bbo noo tar lei a, nayn to tel a e-tel saa ddew te ke maji. ");
INSERT INTO ksp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Bbo noo tar lei ang a, e-bbar dew kara wase joo ungude dɔi te. Ddew kara baa toke Makuru le Lubba pa na: ‹Da gɔl tar nɔ nje-tar-najije te joo wase mota.› ");
INSERT INTO ksp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Toke n̂-mbete ta koo ndeje lede le a, e-pa tare are Egilisi. Bbo n̂-mbete ta koo ta Egilisi tɔ a, maji kare ooe to dew ke gere Lubba ang wase toke le nje-taa nare lambo. ");
INSERT INTO ksp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Tɔkɔrɔ m-pa marese, ne tɔyn ke e-mbeteje nangê neenn a, Lubba mbete darâ mban. Ne tɔyn ke e-ndikije te nangê neenn a Lubba ndiki te darâ mban. ");
INSERT INTO ksp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«M-tel m-pa marese, Bɔmje ke ee darâ a kare ne tɔyn ke dewje joo horose te ddaje me-kara mba dujue. ");
INSERT INTO ksp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mba lo ke dewje joo wase mota uwaje dɔ-naa ke te ke rim a, mee horode te.» ");
INSERT INTO ksp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yeenn ngaa Piyar ddee rɔ Jeju te ngaa duje na: «Ebbemje, toke ngokɔm dda sem ne ke maji ang a, ma kɔru tar dɔe te gɔl bann wa? Gɔl siri wa?» ");
INSERT INTO ksp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jeju pa are na: «M-pa mari, ɔru tar dɔe te gɔl siri baa ang. Ɔru tar dɔe te gɔl dɔsiri ndereng gɔl siri. ");
INSERT INTO ksp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Mba yeenn a, tar Bbe-kɔn ke darâ to toke tar le mare mbay ke ndiki ta koo go ne laa ke to dɔ nje-kulaje te laa. ");
INSERT INTO ksp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kake nunn kute a, n̂-ddee ke mare nje-kula laa ke nare laa to dɔe te kande nare doro doro. ");
INSERT INTO ksp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nje-kula laa le ee ke nare ta kuka ne bbange le ang, ngaa ebbeeje unn ndu kare n̂-labbe, ne ddem, dene laa ddem, nganne ddem, ke ne kingaje laa ddem mba kuka ne bbange ke dɔe te le. ");
INSERT INTO ksp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Kake nje-kula le oo baann a, ungu mekeje gɔle nangê nɔ ebbeeje te le ngaa pa na: ‹Ore wuri, a ma kuka bbangeje lei le tɔyn!› ");
INSERT INTO ksp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ebbeeje le oo kem-to-ndoo laa ngaa ɔru bbange ke dɔe te le a inyae are nɔtu. ");
INSERT INTO ksp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kare te ke nje-kula le tee ddaka a, oo mare nje-kula mare ke bbange laa to dɔe te kande nare dɔdɔku. Nuwa gɔse n̂-tɔ naa te ngaa n̂-pa nare na: ‹Uka bbange lem!› ");
INSERT INTO ksp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nje-mare le ungu mekeje gɔle nangê nɔe te n̂-dda rɔe to ndoo na: ‹Ore wuri, a ma kuka bbange lei le tɔyn njaa!› ");
INSERT INTO ksp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","A Nje-kula le mbete, ngaa uwae ilae key-kula te kare n̂-nayn teenn ndereng ta nuka bbange laa le tɔyn bba ta dinyae. ");
INSERT INTO ksp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kese nje-kula mare ooje baann a ddade ndoo ngaa daw dɔru gel nejeenn le tɔyn dare ebbedede le. ");
INSERT INTO ksp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Yeenn a, ebbedede le ula are daw n̂-bbare ngaa pa are na: ‹Ei, nje-kula ke maji ang! Mɔru bbange lem ke to dɔi te tɔyn mba dda ke e-dda rɔi to ndoo arem. ");
INSERT INTO ksp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","A ei, ase ta koo kem-to-ndoo le nje-mari toke moo kem-to-ndoo lei le tɔ ang wa?› ");
INSERT INTO ksp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Wungu ɔn ebbeeje le nya. Nuwae nilae key-kula te kare dula keme ndoo ndereng ta nuka bbange ke dɔe te le tɔyn bba.» ");
INSERT INTO ksp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ta kutu ne dɔe a, Jeju pa na: «Toke ɔruje tar dɔ naa te ang a, Bɔy ke ee darâ a dda ne ke se ddew kara baa toke baann tɔ.» ");
INSERT INTO ksp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Toke Jeju pa tar le nunga a, nɔtu Galile naw nange te ke Jude tura Jurden te. ");
INSERT INTO ksp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Dewje ke banya unnje goe are nɔru rɔ-to rɔde te lo teenn. ");
INSERT INTO ksp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Parijiyenje ddeeje rɔe te ta nae. Yeenn a n̂-dujeje na: «Ndu are ddew dingaw kare tubba dene laa wɔju dɔ ne tɔyn ke dene laa le dda wa?» ");
INSERT INTO ksp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nilade te na: «E-turaje tar ke n̂-dda me Maketuru te le Lubba le ang wa? Tar le na: ‹Kunn-kutu ne te, Lubba ke nje-dda neje tɔyn dda dingaw ke dene.› ");
INSERT INTO ksp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ngaa Lubba pa na: ‹Mba yeenn a, dingaw a kinya bɔeje ke kɔenje, na nayn ke dene laa ngaa dede joo kem da ddeeje to da-rɔ ke kara baa.› ");
INSERT INTO ksp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yeenn a, deeje joo ang ngaa, n̂-ddeeje to da-rɔ ke kara baa. Ne ke Lubba mbɔn naa te a, maji kare dew kayn hore ang ngaa.» ");
INSERT INTO ksp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Dilaeje te na: «Mba ddi bba Moyiji unn ndu kare bbo dingaw tubba dena laa a, maji kare nare maketuru ke a tɔju to ninyae mban wa?» ");
INSERT INTO ksp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nilade te na: «Wɔju dɔ me-ketere lese a Moyiji are ne se ddew kare e-tubbaje ne deneje lese. A kunn-kutu ne te, tare to toke baann ang. ");
INSERT INTO ksp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","M-pa marese: Toke mba tar kaya ang a bbo dew tubba dene laa ngaa taa mare dene a, n̂-dda lo-to-majang.» ");
INSERT INTO ksp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nje-njaje-goe te le paje na: «Bbo toke baann a, taa dene ang a maji.» ");
INSERT INTO ksp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jeju ilade te na: «Dewje tɔyn a kaseje ta ndiki te ke tar neenn ang, nje ke Lubba arede ddew bba. ");
INSERT INTO ksp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mare neje nya ɔku ddew dingawje ta taa dene. Mareje duju ne de toke baann, a mareje n̂-ddade to enukuje, a mareje dede njaa n̂-ddaje rɔde to enukuje wɔju dɔ Bbe-kɔn le Lubba. Dew ke ase ta ndiki te ke tar neenn a, maji kare n̂-ndiki te.» ");
INSERT INTO ksp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Dewje ddeeje ke ngannje ke mbate rɔ Jeju te kare nila jia dɔde, ta n̂-duju Lubba dɔde te. A nje-njaje-go Jeju te le inje ke de. ");
INSERT INTO ksp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jeju pa arede na: «Inyaje ngannje ke ngaji are ddeeje rɔm te bbo ɔkujede ddew ang. Mba Bbe-kɔn le Lubba to mba dewje ke toje toke ngannje ke ngaji neenn.» ");
INSERT INTO ksp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nila jia dɔde te, ngaa goe te a nɔtu lo teenn. ");
INSERT INTO ksp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mare dingaw ddee rɔ Jeju te ngaa duje na: «Nje-ne-tɔju, ddi ke maji a, maji kare m-dda bba ta kinga ne tebbe ke ke ndɔ ke ndɔ wa?» ");
INSERT INTO ksp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jeju ilae te na: «Mba ddi a e-dujum tar dɔ ne te ke maji wa? Lubba kara baa maji. Toke e-ndiki ta kinga tebbe a, e-dda ne ke turu nduje le Lubba.» ");
INSERT INTO ksp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Basan le tel duju Jeju na: «Nduje ke dda wa?» Jeju ilae te na: «E-tɔl dew ang, e-dda lo-to maji ang ang, e-bboko ang, e-pa tar-naji ngem dɔ dew te ang. ");
INSERT INTO ksp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","E-bbeel bɔije ke kɔinje. E-ndiki nje-mari toke da-rɔi njaa.» ");
INSERT INTO ksp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Basan le ilae te na: «M-dda nejeenn tɔyn mban. Ddi a nayn ta dda bbay wa?» ");
INSERT INTO ksp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jeju ilae te na: «Toke e-ndiki ta ddee maji tɔyn a, aw e-labbe neje ke ee ne, ta e-kayn nare nje-ndooje a, a kinga ne darâ. Goe te a, e-ddee unn gom!» ");
INSERT INTO ksp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kake basan le oo tar le a, rɔe neele ang ngaa ɔtu mba nee ke ne-kingaje nya. ");
INSERT INTO ksp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jeju pa are nje-njaje goe te na: «Tɔkɔrɔ, m-pa marese, a to ngeng nya ke nje-ne-kinga kare ande Bbe-kɔn te le Lubba. ");
INSERT INTO ksp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","M-tel m-pa marese bbay, kande le nje-ne-kinga me Bbe-kɔn te le Lubba a ngeng kuta kande le jambal*** buwa suwa te.» ");
INSERT INTO ksp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tar le gange singa nje-njaje-go Jeju te le ngaa paje na: «Bbo baann a, na bba a kase kinga kaji wa?» ");
INSERT INTO ksp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jeju aade ngaa pa arede na: «To ne ke nya dewje. A Lubba ase ta dda ne tɔyn.» ");
INSERT INTO ksp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Piyar pa are na: «Oo, jinya neje leje tɔyn ngaa junn goi. Tar ke dɔje te a to toke baann wa?» ");
INSERT INTO ksp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jeju pa arede na: «M-pa tar ke tɔkɔrɔ marese, ndɔ ke neje tɔyn a turuje toke siki, kare te ke Ngonn le dew a kisi ngende-mbay te ke to ne-piti a, sese ke unnje gom kara a kisije dɔ ngendeje te dɔku gire joo mba gange sariya dɔ gel-kuju ngann Ijarayelje te ke dɔku gire joo tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","A dewje tɔyn ke inyaje key lede, ngakɔnde ke dingaw, ke ngakɔnde ke dene, bɔdede ke kɔndede, ngannde wase ndɔɔje lede, wɔju dɔm a, da kinga ne gɔl dɔdɔku uta yeje ke kete ddem, da kingaje tebbe ke ke ndɔ ke ndɔ ddem. ");
INSERT INTO ksp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nya le dewje ke toje to dewje ke dɔngɔr bbasine neenn, a toje to dewje ke guku. A nya le dewje ke toje to dewje ke guku bbasine neenn, a toje to dewje ke dɔngɔr.» ");
INSERT INTO ksp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Tar Bbe-kɔn le Lubba to toke tar le mare nje-ndɔɔ ke tee ke esin baa mba sange dewje kare aw ndɔɔ binye te laa. ");
INSERT INTO ksp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Dooje taa naa kare nukade kande nare kara, mba ndɔ kara kara. Goe te a nare daw ndɔɔ binye te laa le. ");
INSERT INTO ksp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tee gɔl kare jikara te ke ke endɔɔ a, n̂-tee ddaka, a noo mare nje-kulaje ke ingaje kula ta dda nang, ngaa arje nata. ");
INSERT INTO ksp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","N̂-pa narede na: ‹Aw ddaje kula me ndɔɔ binye te lem a, ma kukase ke dɔgɔle.› ");
INSERT INTO ksp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nje-kulaje le awje ndɔɔ le. Nje-ndɔɔ le tee ddaka bbay ke gɔl kare dɔku gire joo, ngaa n̂-tel n̂-tee ke gɔl kare mota ke lo-kul te tɔ, a n̂-dda toke baann bbay. ");
INSERT INTO ksp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nje-ndɔɔ le tel tee ddaka ke gɔl kare mi ke dɔ lo-kul te bbay a, noo mare nje-kulaje arje lo teenn le bbay, ngaa n̂-pa narede na: ‹Mba ddi bba arje neenn ke ndɔɔ baa ndereng kare be neenn a, e-ddaje ne kara ang wa?› ");
INSERT INTO ksp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Dilaeje te na: ‹Jar baa mba dew kara otoje kula te ang.› N̂-pa narede na: ‹Aw ddaje kula me ndɔ binye te lem tɔ.› ");
INSERT INTO ksp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Dɔ lo-kul a, nje-ndɔɔ le bbar nje-kaa-lo dɔ neje te laa ngaa pa are na: ‹E-bbar nje-kulaje le, ta ukade kara kara tɔyn. Unn kutue dɔ dede te ke n̂-ddeeje dɔ guku bba ta e-tee ne dɔ nje te ke ddeeje dɔngɔr.› ");
INSERT INTO ksp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nje ke ddeeje ke gɔl kare mi ke dɔ-lo-kul te ddeeje ngaa ingaje kande nare kara kara tɔyn. ");
INSERT INTO ksp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Dede ke dɔngɔr, n̂-ddeeje tɔ. Dejeje to na kingaje nare uta nje ke guku a, dede njaa kara dingaje kande nare kara kara tɔyn tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kare te ke dingaje nare le a, n̂-naneje ke nje-ndɔɔ le, ");
INSERT INTO ksp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","n̂-paje na: ‹Nje-kulaje ke ddeeje dɔ guku ngaa ddaje kula kare kara baa a, ukade ase naa ke jeje ke kula uwa taaje ddem kare ɔsuje ddem toke baann wa?› ");
INSERT INTO ksp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nje-ndɔɔ le pa are mare kara horode te na: ‹Naam, mulai naa te ang. Jee sei joo taa naa mba kande nare kara, mba ndɔ kara kara ang wa? ");
INSERT INTO ksp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","E-taa nare lei bbo ɔtu tam te ke ddang. M-ndiki ta kare nje-kula ke dɔ guku inga nare ase sei naa. ");
INSERT INTO ksp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mee ke ddew ta dda ne ke mem ndiki ke nare lem ang wa? Wase aw aam ke kem ke maji ang wɔju dɔ maji lem le wa?› » ");
INSERT INTO ksp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jeju pa bbay na: «Dewje ke dɔ guku, a ddeeje to dewje ke dɔngɔr. A dewje ke dɔngɔr, a ddeeje to dewje ke dɔ guku.» ");
INSERT INTO ksp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Toke Jeju aw aw ke Jurusalem a, n̂-bbar nje-njaje goe te ke karede baa, ngaa n̂-pa narede ke ddew na: ");
INSERT INTO ksp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Ooje, jaw jawje ke Jurusalam. Nunn, da kila Ngonn le dew ji tɔku nje-poloje Lubba te, ke ji nje-kɔruje gel ndu te. Da gangeje sariya yo dɔe te, ");
INSERT INTO ksp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ngaa da kilae ji dewje te ke gereje Lubba ang kare dɔjeje n̂-kokoje ne. Da tundae ke ndey, ngaa da tɔle kake-dese te. Ndɔ mota laa a, na kin horo dewje te ke oy.» ");
INSERT INTO ksp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Goe te a, dene le Jebede aw ke nganne ke dingaw ke joo rɔ Jeju te. Nungu mekeje gɔle nangê ngaa n̂-dda rɔe to ndoo rɔ Jeju te mba duje mare ne. ");
INSERT INTO ksp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jeju duje na : «Ddi a e-ndiki wa?» Nilae te na: «Unn ndui ta bbo ndɔ ke a ta kɔn mbay a, ngannem ke joo neenn, mare kara isi dɔ ji-kɔli te, a ne ke kara nisi dɔ-ji geli te.» ");
INSERT INTO ksp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jeju ilae te na: «E-gereje ne ke aw dujuje ang. A kaseje ta kay engo-kem-to-ndoo ke ma ta kay wa?» Dilaeje ta na: «Ja kase kay.» ");
INSERT INTO ksp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jeju pa arede na: «Tɔkɔrɔ, a kaseje ta kay engo-ndoo lem le njaa. A, tar kisi dɔ-ji kɔlum te wase dɔji gelem te to tar lem ang. Lo le to wɔju dɔ nje ke Bɔmje mɔse wɔju dɔde.» ");
INSERT INTO ksp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Toke kese nje-njaje go Jeju te ke dɔku le ooje tar le a wungu ɔnde dɔ Jan de ke Jake te le. ");
INSERT INTO ksp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jeju bbarde tɔyn ngaa pa na: «E-gereje to mbayje ke aw ɔnje dɔ dewje, aw ddaje dingaw dɔde te, ngaa dewje ke bo aw nyaje dɔ dewje te. ");
INSERT INTO ksp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Maji kare ne ke baann to horose te ang. Dew ke ndiki ta ddee bo horose te a, maji kare n̂-dda rɔe to nje-kula lese. ");
INSERT INTO ksp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Bbo mare dew horose te neenn ndiki ta to dew ke dɔngɔr a, maji kare n̂-dda rɔe to bbere lese. ");
INSERT INTO ksp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ddew kara baa, Ngonn le dew ddee kare dewje ddeeje to nje-kulaje laa ang. N̂-ddee ta to nje-kula le dewje, ta kunn rɔe to ne-kuka dɔ dewje ke banya.» ");
INSERT INTO ksp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kare te ke Jeju ke nje-njaje goe te aw teeje me bbe te ke Jeriko ke ddaka a, dewje ke banya unnje goe. ");
INSERT INTO ksp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","A ta koo a, mare nje-kem-tɔje joo ke isije mbɔr ddew te ooje na Jeju a aw nday. Duruje ekii na: «Ebbejeje, Ngonn le Dabbiti, oo kem to ndoo leje.» ");
INSERT INTO ksp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Dewje ke banya le inje ke de kare dutu tade. A duruje ekii nya bbay na: «Ebbejeje, Ngonn le Dabbiti, oo kem to ndoo leje!» ");
INSERT INTO ksp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jeju are lo kara, bbarde ngaa pa na: «Ddi a e-ndikije kare m-dda marese wa?» ");
INSERT INTO ksp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Dilae te na: «Ebbejeje are joo lo.» ");
INSERT INTO ksp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jeju oo kem-to-ndoo lede ngaa ula jia ɔru ne kemde. Kem naa te neenn njaa a, dooje lo ngaa dunnje goe. ");
INSERT INTO ksp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Toke Jeju de ke nje-njaje goe te daw ddeeje ngɔsi ke Jurusalam ngaa, n̂-teeje mbɔr bbe te ke Betepaje dɔ ddingiri kake olibeje te a, Jeju ula nje-njaje goe te joo nɔe te kete. ");
INSERT INTO ksp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","N̂-pa na: «Awje me bbe te ke to nɔse tee tonn. Njange baa njaa a kooje kɔn kororo ke n̂-tɔe ngaa ngonne ar mbɔre te. E-tuteje ta e-ddeeje ke de aremje. ");
INSERT INTO ksp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Bbo mare dew pa ke se tar a, ilaeje te na: ‹Ebbejeje a ndiki kororoje le.› Njange baa njaa na kinyade karese.» ");
INSERT INTO ksp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Baann bba kare tar le Lubba ke nje-kila mber-tar laa ndaji ddee to ne ke tɔkɔrɔ. Tar le na: ");
INSERT INTO ksp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«E-paje are dewje ke Siyɔn***: Ooje, mbay lei aw ddee ke rɔi te, n̂-to dew ke wul pe, nisi dɔ kɔn kororo te, ke dɔ ngonn kororo te ke to da ke daw n̂-dda ne kula.» ");
INSERT INTO ksp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nje-njaje go Jeju te le ɔtuje awje ngaa ddaje ne ke turu ndu Jeju le. ");
INSERT INTO ksp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","N̂-ddeeje ke kɔn kororo, ke ngonn kororo. Dunguje kubbuje lede dɔ kororoje te le dare Jeju isi dɔe te. ");
INSERT INTO ksp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Dewje ke banya labbeje kubbuje lede dɔ ddew te. Mareje teteje kamje unguje ddew-bô. ");
INSERT INTO ksp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Dewje ke banya ke aw njaje nɔe te, ke dede ke daw n̂-njaje goe te daw duruje ekii na: « Ojana to le Ngonn le Dabbiti! Maji kare Lubba bbar tar ke maji dɔ dew te ke aw ddee ke ri Ebbe-dewje. Jɔsuje gaji Lubba ke isi ddutu dara te!» ");
INSERT INTO ksp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Toke Jeju ande Jurusalam a, me bbe tɔyn yeke. Dewje dujuje tar na: «Na ann wa?» ");
INSERT INTO ksp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Dewje ke banya le ilaje te na: «Jeju, nje-kila mber-tar le Lubba ann, nin Najarete nange Galile te.» ");
INSERT INTO ksp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Goe te a, Jeju ande me key-polo-Lubba te ngaa tubba dewje tɔyn ke aw labbeje ne ddem, aw ndokoje ne ddem me key te le. N̂-tuta tabele le nje-mbelje nare nungu nangê. N̂-tuta ne-kisi le nje-labbeje derje n̂-tila. ");
INSERT INTO ksp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","N̂-pa narede na: «Maketuru le Lubba na: ‹Da bbar ri key lem to key duju Lubba.› A sese aw ddaje to lo-kiya-rɔ le nje-bbokoje.» ");
INSERT INTO ksp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nje-kem-tɔje, ke nje-meteje ddeeje rɔe te me key-polo-Lubba te le ngaa n̂-dda nare rɔde ddee maji. ");
INSERT INTO ksp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Toke tɔku nje-poloje Lubba ke nje-kɔru gel nduje ooje neje ke dum-dɔde ke Jeju dda le, ke ngannje ke aw uruje ekii na: «Jɔsuje gaji Ngonn le Dabbiti» le a, wungu ɔnde. ");
INSERT INTO ksp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ngaa n̂-paje dare Jeju na: «Oo tar ke daw n̂-pajeenn wa?» Nilade te na: «Moo njaa. A tar ke n̂-dda me Maketurute le Lubba le e-turaje ndɔ kara ang wa? Tar le na: ‹E-dda ne are ngannje ke ten, ke engutayje kara ɔsuje gajii.› » ");
INSERT INTO ksp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Goe te a, Jeju inyade a ɔtu. N̂-tee me bbe te le naw Betani ngaa n̂-to ke teenn. ");
INSERT INTO ksp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Jeju in ke esindɔɔ baa tel aw ke tɔku bbe te a bbo ddae. ");
INSERT INTO ksp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Toke noo mare kake pige ke ar mbɔr ddew te ngɔsi a, naw ngɔsi ke kake le a kame dɔrɔ a noo. Yeenn a n̂-pa nare kake le na: «A kande ndɔ kara ang ngaa.» A kare teenn njaa kake le oy njan. ");
INSERT INTO ksp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nje-njaje-go Jeju te le ooje neenn le a gange singade ngaa paje na: «Dda toke baann bba njange baa njaa a, kake pige le oy wa?» ");
INSERT INTO ksp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jeju pa arede na: «M-pa tar ke tɔkɔrɔ marese. Toke koo me te lese to, ngaa ejeje tar ang a, a ddaje ne ke m-dda ke kake pige neenn. A kaseje ta pa kare ddingiri neenn na: ‹ ɔtu lo te neenn aw oso me ba te,› a neenn a ddee to ne ke tɔkɔrɔ. ");
INSERT INTO ksp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Bbo koo me te lese to, a bbo e-dujuje Lubba a, a kingaje ne tɔyn ke e-dujuje le.» ");
INSERT INTO ksp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jeju ande me key-polo-Lubba te aw tɔju ne. A tɔku nje-poloje Lubba, ke tɔkuje le Jiipije ddeeje rɔe te. N̂-paje dare na: «Ddew ddi te bba aw e-dda ne neenn wa. Wase na njaa gate a ari singa ta dda ne wa?» ");
INSERT INTO ksp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nilade te na: «Ema kara ma dujuse tar kara baa. Toke ilamje te a, ma bbar ri dew ke arem singa dda nejeenn le karese tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Na a ula Jan are dda batem dewje wa? Lubba wase dewje wa?» A n̂-paje horode te na: «Bbo jilaje te n-pa na: ‹Lubba a ulae› a, na pa na: ‹Mba ddi bba ooje mese te saa ang wa?› ");
INSERT INTO ksp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Bbo n-paje na: ‹ Dewje a, a to toke baann wa?› » Mba n̂-bbeel dewje ke banya le, mba dede tɔyn dooje Jan to nje-kila mber-tar le Lubba. ");
INSERT INTO ksp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yeenn a, dilaeje te na: «N-gere ang.» Jeju pa arede na: «Ema kara ma bbar ri dew ke arem singa dda nejeenn le karese ang tɔ.» ");
INSERT INTO ksp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jeju pa arede bbay na: «Ddi a ejeje dɔ tar te ke ma ta pa karese neenn wa? Mare dingaw ee ke ngannje ke dingaw joo. N̂-pa nare ye ke tɔku na: ‹Ngunum, aw bbokone aw dda kula me ndɔɔ binye te lem.› ");
INSERT INTO ksp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ngonn le ila bɔeje te na: ‹M-ndiki ang.› Goe te a, tar ke nila bɔeje te le tel neele ang, ngaa nɔtu naw ndɔɔ le. ");
INSERT INTO ksp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Dingaw le aw rɔ ye ke mbate te, ngaa pa tar ke kara baa le are tɔ. Ngonn le ilae te na: ‹An an Bɔy, ma kaw›. A naw ang.» ");
INSERT INTO ksp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jeju dujude na: «Horo ngannje te ke joo neenn, ye ke dda, a dda ne ke bbɔeje ndiki wa?» Dilaeje te na: «Ne ke dɔngɔr.» Jeju pa arede na: «Tɔkɔrɔ njaa, m-pa marese, nje-taaje nare lambo, ke dene nje-kayaje a kandeje me Bbe-kɔn te le Lubba dɔngɔr karese. ");
INSERT INTO ksp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Mba, lew Jan ddee rɔse te ngaa tɔjuse ddew dda ne ke gate gate, a e-ndikije te ke tar laa ang. A nje-taaje nare lambo, ke dene nje-kayaje a ndikije te ke tar laa le. A sese, ooje nejeenn ke maje a e-turuje ddew lese ang ddem, e-ndikije te ke tar laa le ang ddem.» ");
INSERT INTO ksp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Ooje mare gusu-tar neenn bbay. Mare nje-ndɔɔ dda ndɔɔ binye laa. Nila ndoko n̂-guku ne dɔe. Nuru buwa me er te kare dore maann binye le mee te. N̂-dda mare lo taar kare dew ar dɔe te mba kaa ne dɔ ndɔɔ le. Goe te a, ninya ndɔɔ le ji mare nje-ddaje kula ndɔɔ te le a nɔtu naw mba te. ");
INSERT INTO ksp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kare kuja kande binye le ase a, nula ngann nje-kulaje laa rɔ nje-ddaje kula me ndɔɔ binye te le kare dulaje ke kande binye laa dareje. ");
INSERT INTO ksp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","A nje-ddaje kula me ndɔɔ binye te le uwaje ngann nje-kulaje le. N̂-tundaje mare, n̂-tɔlje mare, ngaa n̂-tilaje mare ke er n̂-tɔleje. ");
INSERT INTO ksp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","N̂-tel nula mare ngann nje-kulaje laa le banya banya bbay. A nje-ddaje kula me ndɔɔ binye te le dda ke de ne ke n̂-ddaje ke nje ke dɔngɔr le bbay. ");
INSERT INTO ksp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Dɔbɔen a, nje-ndɔɔ le ula ngonne rɔ nje-ddaje kula me ndɔɔ te le mba neje n̂-pa na: ‹A du ang, bbo ngunum a da bbeeleje.› ");
INSERT INTO ksp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","A kake nje-ddaje kula me ndɔɔ te le ooeje a, paje na: ‹Nje-kuwa ne-ndubba le ann! Areje n̂-tɔleje are ne-ndubba le tel to leje.› ");
INSERT INTO ksp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Duwaeje n̂-teeje saa me ndɔɔ te le ke ddang ngaa n̂-tɔleje.» ");
INSERT INTO ksp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jeju tel dujude na: «Toke nje-ndɔɔ le ddee a ddi a na dda ke nje-ddaje kula me ndɔɔ binye te le wa?» ");
INSERT INTO ksp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Dilaeje te na: «Na koo kem-to-ndoo le nje-me-majangje neenn le ang ta na tɔlde. Goe te a, na kinya ndɔɔ le ji mare nje-ddaje kula te dang kare ndɔe ase a, n̂-ddeeje ke ko ndɔɔ laa dareje.» ");
INSERT INTO ksp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Goe te a, Jeju dujude na: «E-turaje tar ke Maketurute le Lubba pa neenn ndɔ kara ang bbay wa? Tar le na: ‹Er ke nje-kɔsuje key mbeteje, tel ddee to singa gɔl key ke dungu nangê. To ne ke Ebbe-dewje a dda, ngaa kura nya kemje te.› ");
INSERT INTO ksp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Mba yeenn a, m-pa marese: Lubba a kɔru Bbe-kɔn laa jise te ta kare mare gel-dewje ke a ddaje kula ke maji. ");
INSERT INTO ksp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Dew ke oso dɔ er te le a, dew le a guru rɔe. Ngaa dew ke er le oso dɔe te a, er le a nyaren.» ");
INSERT INTO ksp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kake tɔku nje-poloje Lubba ke Parijiyenje ooje tar le be a gereje to dede a Jeju aw pa tar dɔde te. ");
INSERT INTO ksp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","N̂-sangeje ddew ta kuwaeje a, n̂-bbelje kem dewje ke banya mba dewje le ooje Jeju to mare nje-kila mber-tar le Lubba. ");
INSERT INTO ksp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jeju tel pa tar arede bbay ddew gusu-tar te pa na: ");
INSERT INTO ksp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Tar Bbe-kɔn ke darâ to ddew kara baa ke tar neenn: Mare Tɔku-mbay dda kusu taa-naa le ngonne ke dingaw. ");
INSERT INTO ksp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nula nje-kulaje laa kare bbar dewje ke n̂-bbarde kusu te le. A dewje le mbeteje ta ddee. ");
INSERT INTO ksp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","N̂-tel nula mare nje-kulaje kare aw pa arede na: ‹M-dda ne-kusa mban. M-tɔl mangeje ddem, daje ke eme ddem are ne-kusa to ngɔsi ngaa, e-ddeeje kusu te le.› ");
INSERT INTO ksp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","A dewje le ooje tar laa le to mare ne ang. Mare ɔtu aw ndɔ̂ɔ, a mare aw ta labbe ne laa. ");
INSERT INTO ksp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","A mareje uwaje ngann-nje-kulaje le ddade maji ang ngaa tɔlde. ");
INSERT INTO ksp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Wungu ɔn Tɔku-mbay le ngaa, nula mbambaje laa nare tɔl nje-tɔlje nje-kulaje laa le, ngaa n̂-roje bbe lede. ");
INSERT INTO ksp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Goe te a, n̂-pa nare ngann-nje-kulaje laa le na: ‹Kare kusu-taa-naa le ase ngaa a dewje ke n̂-bbarde le to dewje ke ase ta bbarde kusu te ang. ");
INSERT INTO ksp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Aw arje tɔ-ddewje te bbo dew njaa ke ingaeje a, e-bbareje are n̂-ddee kusu-taa-naa te le.› ");
INSERT INTO ksp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ngannje-kulaje laa le unnje go ddewje ngaa bbarje dewje tɔyn ke dingade, nje ke maji ddem, nje ke maji ang ddem. Yeenn ngaa dewje ke n̂-bbarde le ddusuje me key le. ");
INSERT INTO ksp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Toke Tɔku-mbay le ande key mba koo dewje ke n̂-bbarde le a, noo mare dingaw ke ula kubbu-kusu ang. ");
INSERT INTO ksp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","N̂-pa nare na: ‹Naam, na baann bba ula kubbu-kusu ang a e-ddee ande key neenn wa?› A dingaw le ilae tar te ang. ");
INSERT INTO ksp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Yeenn a, Tɔku-mbay le pa are ngann-nje-kulaje laa na: ‹E-tɔje jia ke gɔle bbo ilaeje ddaka lo te ke ndul. Lo teenn na nɔ ngaa na ngeer ngange.› » ");
INSERT INTO ksp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ta kutu ne dɔ tar le a, Jeju pa na: «Tɔkɔrɔ, Lubba bbar dewje toke banya njaa, a nje ke n̂-mberede banya ang.» ");
INSERT INTO ksp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yeenn ngaa, Parijiyenje aw uwaje dɔ naa ta na Jeju mba kingae ddew tar te ke a tee tae te. ");
INSERT INTO ksp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Dulaje mare nje-njaje gode te, ke dewje ke unnje go Erode rɔ Jeju te le kare n̂-paje dare na: «Nje-ne-tɔju, n-gere to aw pa tar ke tɔkɔrɔ, aw tɔju ddew le Lubba ddew tar te ke tɔkɔrɔ, ngaa aw bbeel kem dew ang ddem, dew ke bo wase dew ke ten kara osoi te ang. ");
INSERT INTO ksp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","E-pa areje joo: Ndu areje ddew kare juka lambo ke Sejar wase ndu mbete wa?» ");
INSERT INTO ksp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jeju gere keje lede ke maji ang ngaa pa arede na: «Nje-ngemje, mba ddi a, aw namje wa? ");
INSERT INTO ksp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","E-tɔjumje kande-nare ke aw ukaje ne lambo.» N̂-ddeeje ke kande nare le dareje. ");
INSERT INTO ksp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jeju dujude na: «Endaji dɔ dew, ke maketuru ke n̂-dda nare te neenn toje to le na wa?» ");
INSERT INTO ksp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","N̂-paje na: «To le Sejar.» N̂-tel n̂-pa narede na: «Yeenn a, areje Sejar ne ke to le Sejar, a areje Lubba ne ke to le Lubba.» ");
INSERT INTO ksp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Dooje tar laa le a dum dɔde, ngaa dinyaeje a dɔtuje. ");
INSERT INTO ksp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ndɔe teenn njaa Saduseyenje ddeeje rɔ Jeju te. Saduseyenje to dewje ke paje na dewje ke oyje a kinje ang. N̂-dujuje tar Jeju na: ");
INSERT INTO ksp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Nje-ne-tɔju, Moyije pa na: ‹Toke dew ee ke ngonn ang a oy a, maji kare ngokɔen ta dene-ndubba le uju ne ngannje are.› ");
INSERT INTO ksp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Lew, mare ngakɔn naa siri eeje horoje te neenn. Ye ke tɔku taa dene a uju saa ngonn ang a oy. Ninya dene laa nare ye ke tee goe te. ");
INSERT INTO ksp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ne ke kara baa le a dda joo lede, mota lede, ndereng tee ne dɔ ye ke to siri lede. ");
INSERT INTO ksp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Gode te tɔyn a, dene le oy tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Yeenn a, ndɔ kin le dewje ke oy a, na horo ngakɔn naa teenn a, a to nje-dene le wa? Mba dede siri keme n̂-taaje dene le go naa te.» ");
INSERT INTO ksp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jeju ilade te na: «E-ndemje ddew, mba e-gereje Maketuru le Lubba ang ddem, singa-mɔngu le Lubba ang ddem. ");
INSERT INTO ksp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tɔkɔrɔ, ndɔ kin le dewje ke oy a, dene a taa ngaw ang ddem, dingaw a taa dene ang ddem. Dewje a tooje toke anjije ke darâ. ");
INSERT INTO ksp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","A tar ke wɔju dɔ kin le dewje ke oy le, e-turaje tare ke Lubba pa arese ang wa? N̂-pa na: ");
INSERT INTO ksp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‹M-to Lubba le Abaraham, Lubba le Ijake, Lubba le Jakobbo.› N̂-to Lubba le dewje ke isije kem baa, bbo Lubba le dewje ke oy ang.» ");
INSERT INTO ksp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ne-tɔju laa le dum dɔ dewje ke banya ke ooje tar laa le. ");
INSERT INTO ksp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Toke Parijiyenje ooje na Jeju uwa ta Saduseyenje a, Parijiyenje le uwaje dɔ naa. ");
INSERT INTO ksp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mare kara horode te ke to nje-kɔru gel ndu duju tar Jeju mba nae ne. N̂-pa na: ");
INSERT INTO ksp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Nje-ne-tɔju, ndu ke dda ngeng uta mareje wa?» ");
INSERT INTO ksp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jeju ilae te na: « ‹Maji kare e-ndiki Ebbe-dewje ke to Lubba lei ke mei tɔyn, ke kewn lei tɔyn, ke keje lei tɔyn.› ");
INSERT INTO ksp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yeenn to ndu ke ngeng uta mareje ann. ");
INSERT INTO ksp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Joo le ndu ke ngeng uta mareje na: ‹ Maji kare e-ndiki nje-mari toke da rɔi njaa.› ");
INSERT INTO ksp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ndu le Moyiji, ke ne-tɔjuje le nje-kilaje mber-tar le Lubba inje me nduje te ke joo neenn.» ");
INSERT INTO ksp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Toke Parijiyenje uwaje dɔ naa a Jeju dujude na: ");
INSERT INTO ksp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Tar ddi a aw ejeje dɔ Mesi te wa? N̂-to ngonn le na wa?» Dilaeje te na: «N̂-to ngonn le Dabbiti.» ");
INSERT INTO ksp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jeju pa arede na: «Yeenn a, toke baann bba Ndil ddusu me Dabbiti a tel bbar Mesi le to ‹Ebbeeje› wa? Dabbiti le pa na: ");
INSERT INTO ksp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‹Ebbe-dewje Lubba pa are Ebbemje na: Isi dɔ ji kɔlem te, ndereng ndɔ ke ma kungu nje-baanje lei kɔ gɔli te.› ");
INSERT INTO ksp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«A bbo Dabbiti bbar Mesi to Ebbeeje a, Mesi le a to ngonne toke baann wa?» ");
INSERT INTO ksp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Dew kara horode te ase kilae tar te ang. Ngaa unn kute dɔ ndɔe teenn, dew kara tay duje tar ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Goe te a, Jeju pa are dewje ke banya ke nje-njaje goe te na: ");
INSERT INTO ksp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","« Kula le nje-kɔruje gel-ndu ke le Parijiyenje to engan kɔru gel ndu le Moyiji kare dewje. ");
INSERT INTO ksp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yeenn a, maji kare ooje tade, ngaa e-ddaje neje tɔyn ke n̂-dujuse. A kula-ddade a ta e-ndajije ang mba kula-ddade to ddew kara ke ne-tɔju lede ang. ");
INSERT INTO ksp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ne-koto ke bo, a n̂-tɔje dundaje dɔ dewje te, a dede ngonn jide kara n̂-ndikije ta kɔru ne ne-koto le ang. ");
INSERT INTO ksp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Daw n̂-ddaje neje tɔyn mba kare dewje oojede. Yeenn a, n̂-ddaje bbɔl endarje ke daw ngemje maketuruje le Lubba me te dare bo ngaa, n̂-ddaje ta-kubbuje lede dare ngal ngal ");
INSERT INTO ksp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ndɔ kusu a, n̂-ndikije ta kisi lo te ke n̂-mɔse mba dewje ke bo. Ngaa me key-mbɔn naaje te kara, n̂-ndikije ta kisi lo te ke kete tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","N̂-ndikije kare dewje ddade lapiya nata ddem, ngaa kare dewje bbarde ‹Nje-ne-tɔju.› ");
INSERT INTO ksp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","A sese, dang bba areje dewje bbarse ‹Nje-ne-tɔju› ang. Mba sese tɔyn e-toje to ngakɔn-naa, ngaa nje-ne-tɔju lese kara baa. ");
INSERT INTO ksp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","E-bbarje mare dew ke nangê neenn ‹Bɔ› ang, mba Bɔsese kara baa ee darâ. ");
INSERT INTO ksp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Areje dewje bbarse ‹mbay› ang, mba Mesi kara baa a to Mbay lese. ");
INSERT INTO ksp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Dew ke bo horose te a, maji kare n̂-ddee to nje-kula lese. ");
INSERT INTO ksp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Dew ke dda rɔe bo a, a tel ddee to dew ke ten. A dew ke dda rɔe ten, a tel ddee to dew ke bo. ");
INSERT INTO ksp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Kem-to-ndoo to lese, see nje-kɔruje gel Ndu, ke see Parijiyenje ke e-toje to nje-ngemje. Aw utuje ta ddew areje dewje ke ndikije ta kande me Bbe-kɔn te ke darâ. Sese njaa kara andeje te ang, a inyaje dewje ke ndikije ta kande te are ande te ang.» ");
INSERT INTO ksp_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kem-to-ndoo to lese see nje-kɔruje gel Ndu ke see Parijiyenje ke e-toje to nje-ngemje. E-taaje ne-kingaje le dene-ndubbaje jide te tɔyn. A kare teenn njaa, aw dujuje Lubba kure ew mba kare dewje aase. Mba yeenn a sariya ke dɔse te a ngeng nya. ");
INSERT INTO ksp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kem-to-ndoo to lese see nje-kɔruje gel Ndu ke see Parijiyenje ke e-toje to nje-ngemje. Aw ulaje loje tɔyn bba aw ingaje dew kara ke ndiki ta ngem Ndu le Moyiji. Ngaa goe te ke ingaeje a, e-ddaeje are n̂-ddee to dew ke ase kaw kem puru te ke aw wɔn ke ndɔ ke ndɔ utase gɔl joo bbay. ");
INSERT INTO ksp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Kem-to-ndoo to lese, sese ke aw ɔruje nɔ nje-marese, ke e-toje toke le nje-kem-tɔje. E-paje na: ‹Toke dew unda yo ke ri key-polo-Lubba a, dda ne ang. A toke nunda yo ke ri ande ke me key-polo-Lubba te a, maji kare n̂-dda ne ke nunda yo ta dda le.› ");
INSERT INTO ksp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","See mbeje ke nje-kem tɔje! Key-polo-Lubba a dda are ande le ddee to ne ke dunda dang mba Lubba. Yeenn a, Key-polo Lubba le a to ne ke ngeng wase ande le wa? ");
INSERT INTO ksp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","E-paje bbay na: ‹Toke dew unda yo ke ri bann a, dda ne ang. A toke dew unda yo ke ri ne-polo ke to dɔ bann te a, maji kare n̂-dda ne ke nunda yo ta dda le. ");
INSERT INTO ksp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","See nje-kem-tɔje! Bann a dda are ne-polo ddee to ne ke dunda dang mba Lubba. Yeenn a, bann le a to ne ke ngeng wase ne-polo le wa? ");
INSERT INTO ksp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Dew ke unda yo ke ri bann, unda yo ke ri bann le ddem, unda yo ke ri ne tɔyn ke to dɔ bann te le ddem. ");
INSERT INTO ksp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Dew ke unda yo ke ri key-polo-Lubba, unda yo ke ri key-polo le ddem, ke ri Lubba ke to me key-polo te le ddem. ");
INSERT INTO ksp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Dew ke unda yo ke ri dara, unda yo ke ri ngende-mbay le Lubba ddem, ke ri Lubba ke isi dɔ ngende-mbay te le ddem. ");
INSERT INTO ksp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kem-to-ndoo to lese see nje-kɔruje gel Ndu ke see Parijiyenje ke e-toje to nje-ngemje. Sese ke aw areje dime ngann ne-ndɔɔje lese tɔyn, a aw mbeteje tarje ke ngeng nya uta keseje ke Ndu aw tɔju. Neje toke: ‹Ne-dda ke gate gate, me-maji, ke ngem tar le Lubba›. To maji ta nejeenn ke keseje tɔyn. ");
INSERT INTO ksp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Sese ke aw ɔruje nɔ nje-marese, ke e-toje to nje-kem-tɔje le, nayn to aw taaje maann-kay lese mba kɔru ngann kewnje ke ddang, a areje jambalje nday aw mese te wa! ");
INSERT INTO ksp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Kem-to-ndoo to lese see nje-kɔruje gel Ndu ke see Parijiyenje ke e-toje to nje-ngemje. Nayn to aw tokoje giri engo-ne-kayje lese ke giri sambeje lese. A, ne-bbokoje, ke neje ke ingaje ke ddewe ang a ddusu me engo-maannje, ke me sambeje lese le. ");
INSERT INTO ksp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ei Parijiyen ke e-to nje-kem-tɔ le, e-toko me engo-ne-kay bba gire a kare tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Kem-to-ndoo to lese see nje-kɔruje gel Ndu ke see Parijiyenje ke e-toje to nje-ngemje. E-toje toke le dɔbare ke dɔru pɔr gire te are nda. Gire kura kem dewje te, a singa dewje ke oy ke ne-yerewje dang dang njaa ddusu mee. ");
INSERT INTO ksp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sese kara e-toje ddew kara baa toke baann. Kem dewje te, undaje rɔ dewje ke aw bbeel Lubba. A, ngemje ke ne-ddaje ke maji ang ddusu mese. ");
INSERT INTO ksp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Kem-to-ndoo to lese see nje-kɔruje gel Ndu ke see Parijiyenje ke e-toje to nje-ngemje. Aw ddaje dɔbare nje-kilaje mber-tar le Lubba ngaa aw mɔseje dɔbare dewje ke gate gate are kura. ");
INSERT INTO ksp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ngaa aw paje na: ‹Toke jeje n-to dɔ ndɔ te le kajejeje a, ja kumade ta tɔl ne nje-kilaje mber-tar le Lubba ang.› ");
INSERT INTO ksp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yeenn pa na sese njaa e-gereje to e-toje to nje ke gel dewje te ke tɔlje nje-kilaje mber-tar le Lubba le. ");
INSERT INTO ksp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yeenn a, sese, uwaje kula le kasese le areje ngeng awje ne ke kete ma! ");
INSERT INTO ksp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","See lije, ko embakanraje, a kaseje ta tee ta sariya-puru te ke aw wɔn ke ndɔ ke ndɔ toke baann wa? ");
INSERT INTO ksp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mba yeenn a, ooje, ma kula nje-kilaje mber-tar le Lubba, nje-kem-kareje, ke nje-kɔruje gel Ndu rɔse te. A tɔlje mareje, ta a bbereje mareje dɔ kake-dese te. A tundaje mareje ke ndey me key-mbɔn naaje te lese ngaa, a tubbajede ke bbe bbe. ");
INSERT INTO ksp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yeenn bba kare tar mese dewje ke gate gate tɔyn ke e-tɔlje de dɔ nange te neenn tel dɔse te. Unn kutue tar mese Abel te ke to dew ke gate gate, ndereng dɔ tar mese Jakari te ke to ngonn le Barasi ke e-tɔleje me key-polo-Lubba te horo lo te ke maji tɔyn ke bann. ");
INSERT INTO ksp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tɔkɔrɔ m-pa marese, sariya nejeenn tɔyn a koso dɔ dewje te ke bbokone neenn. ");
INSERT INTO ksp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","See dewje ke Jurusalam, see dewje ke Jurusalam! Sese ke aw tɔlje nje-kilaje mber-tar le Lubba, ngaa aw tilaje dewje ke Lubba ulade rɔse te ke er e-tɔljede. M-ndiki nya ta mbɔnse toke kɔn kunja aw mbɔn nganne kɔ bake te a, e-ndikije ang. ");
INSERT INTO ksp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Maji! Me key lese a to baa. ");
INSERT INTO ksp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mba, m-pa marese, a koomje ang ngaa ndereng ta a paje na: ‹Maji kare Lubba bbar tar ke maji dɔ dew te ke aw ddee ke ri Ebbe-dewje.› » ");
INSERT INTO ksp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Toke Jeju tee key-polo-Lubba te aw ɔtu a, nje-njaje goe te ddeeje aw tɔjeje gusu ke dɔsu ne key-polo-Lubba le. ");
INSERT INTO ksp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yeenn a Jeju pa arede na: «Ooje neje neenn tɔyn. M-pa tar ke tɔkɔrɔ marese. Mare er kara a nayn dɔ mare te ang. Da tɔ neje neenn tɔyn.» ");
INSERT INTO ksp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Toke Jeju isi dɔ ddingiri Olibeje te a, nje-njaje goe te ddeeje ke karede baa dujeje na: «Ndɔ ddi njaa bba nejeenn le a toje ne wa? Ngaa ddi bba ja gere ne kare ddee lei ddem, ddutu ndɔ le ddem wa?» ");
INSERT INTO ksp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jeju ilade te na: «Aaje rɔse ke maje areje dew erese ang. ");
INSERT INTO ksp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mba dewje nya nya a ddeeje ke rim ngaa da paje na: ‹Ema m-to Mesi le›. Ngaa da kereje dewje nya. ");
INSERT INTO ksp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","A kooje tam ddɔje ke aw ddeeje ngɔsi ke tam ddɔje ke naynje ddew ew. A areje bbeel ddase ang. Maji kare nejeenn le toje. A, a to ddutu ndɔ ang bbay. ");
INSERT INTO ksp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mba gel-dewje a kinje ta dda ddɔ ke mare gel-dewje. Bbe-kɔn a kin ta dda ddɔ ke mare bbe-kɔn. Tɔku bbo a koso ngaa, nange a yeke loje te dang dang. ");
INSERT INTO ksp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","A nejeenn tɔyn a toje toke le kunn-kutu nduru-ndo le dene. ");
INSERT INTO ksp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Yeenn ngaa da kuwase kare dewje ula kemse ndoo ngaa da tɔlse. Gel-dewje tɔyn a mbetese wɔju dɔm. ");
INSERT INTO ksp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Koo me te le dewje nya a koso. Da kunnje dɔ naa, ngaa da mbeteje naa ke yo ke ne. ");
INSERT INTO ksp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nje-kilaje mber-tar ke toje to nje-ngemje a kundaje lo tee banya banya ngaa da kereje dewje toke banya. ");
INSERT INTO ksp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Majang a kaw ke kete kete, are ndiki naa le dewje nya a tel ke guku. ");
INSERT INTO ksp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","A dew ke uwa are ngeng ndereng tee kɔen te a, a kinga kaji. ");
INSERT INTO ksp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Da kila mber Tar ke maji ke wɔju dɔ Bbe-kɔn ke darâ dɔ nange te tɔyn kare gel-dewje tɔyn ooje. Goe te ngaa bba a to dɔbɔyn ne.» ");
INSERT INTO ksp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«A kooje ‹ne ke maji ang ke aw tuju lo› le lo te ke maji-tɔyn, ddew kara baa toke nje-kila mber-tar le Lubba Daniel ila mbere le. - Maji kare dew ke aw tura Maketuru neenn le gere kande ke maje- ");
INSERT INTO ksp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yeenn a, maji kare dewje ke a kisije nange Jude te aynje er ke dɔ ddingirije te. ");
INSERT INTO ksp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Toke dew isi dɔ key te a, maji kare n̂-ddisi ta kunn ne laa ke to me key te ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Toke dew ee ndɔɔ a, maji kare n̂-tel bbee mba kunn kubbu laa ke ngal ang tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Dɔ ndɔe teenn, a to ndoo nya kare deneje ke eeje ke sem, ke nje ke ngannde aw ilje mba. ");
INSERT INTO ksp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","E-dujuje Lubba kare ndɔ kayn lese le to dɔ nayn-kul te ang ddem, ndɔ-kuwa-rɔ te ang ddem. ");
INSERT INTO ksp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mba kare teenn, dewje a koo ndoo nya kuta ndoo ke dewje ooje kunn-kutu ne te ndereng bbokone. Goe te a, ne kem-to ndoo ke a kuta yeenn a to ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Toke Lubba tel ke ndɔ nejeenn le are nayn ngaji baa ang a, dew kara a kinga kaji ang. A na tel ke ndɔ nejeenn le kare nayn ngaji baa wɔju dɔ dewje ke n̂-mberede toke kete. ");
INSERT INTO ksp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Yeenn a, toke dew pa arese na: ‹Ya! Mesi ee neenn.› Wase ‹Nee yonn› a, e-ndikije te saa ang. ");
INSERT INTO ksp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mba mesije ke tɔkɔrɔ ang, ke nje-kilaje mber-tar ke tɔkɔrɔ ang a ddeeje. Da ddaje ne-mɔrije ke neje ke dum dɔ koo, ta bbo ddew to a, nje ke Lubba mberede kara ta kerede tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ye ann, mila mbise te kete mban. ");
INSERT INTO ksp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Yeenn a bbo, n̂-pa darese na: ‹Ya! Nee me kɔr te› a, awje ang. A bbo na: ‹Ne a niya rɔe neenn› a e-ndikije te ang. ");
INSERT INTO ksp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ngonn le dew a ddee ddew kara baa toke ndi ke teel me dara te lo tee te le kare ndereng lo kande te le kare. ");
INSERT INTO ksp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Lo ke ninn to te a, malje a mbɔnje naa kete.» ");
INSERT INTO ksp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","« Njange baa go ndɔ ne-kem-to-ndooje teenn le a, kare a tuka ndul ta neyn a nda ang ngaa. Endeterendenje a kinje darâ tosoje dɔ nange te. Singa-mɔnguje ke me dara te a yekeje. ");
INSERT INTO ksp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Yeenn ngaa ne ke a tɔju kare dewje gereje ne teel le Ngonn le dew a tee me dara te. Ngaa dewje tɔyn ke dɔ nange te a nɔnje. Da kooje Ngonn le dew ke a ddee me mum te ke singa-mɔngu ke bo nya ddem, ke piti ke bo nya ddem. ");
INSERT INTO ksp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tɔku tebbe-nare a bbar ngaa Ngonn le dew a kula anjije laa kare n̂-mbɔnje dewje ke n̂-mberede kɔyn nange te ke sɔ tɔyn, in er kara tee er kara.» ");
INSERT INTO ksp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Maji kare e-gereje ne dɔ kake Pige te: Toke maann aw nja me barkem kake Pige te a kame aw unju a, e-gereje to neyn ne-dubbu ee ngɔsi ngaa. ");
INSERT INTO ksp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ddew kara baa, bbo sese ooje nejeenn tɔyn a, maji kare e-gereje to Ngonn le dew a ta ddee ngaa. Nee ngɔsi baa ngaa. ");
INSERT INTO ksp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","M-pa marese, tɔkɔrɔ njaa, dewje ke bbokone neenn a koyje tɔyn ang bbay a, nejeenn tɔyn a teeje.» ");
INSERT INTO ksp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","«Dara, ke nange da ndayje, a tarje lem a ndayje ang.» ");
INSERT INTO ksp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Dew kara gere ndɔ wase kare tee le nejeenn le ang. Anjije ke dara wase Ngonn le kara gere ang. Bɔ ke kare baa gere. ");
INSERT INTO ksp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ndɔ tee le Ngonn le dew a to ddew kara baa ke neje ke teeje ndɔ te le Noe. ");
INSERT INTO ksp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mba kare teenn le, kete bba kare maann taa lo a, dewje aw usaje, aw ayje. Daw n̂-taaje naa, daw dare ngaw ngannde ke dene ndereng tee ndɔ te ke Noe ande me tɔku to te. ");
INSERT INTO ksp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Dejeje mare ne kara ang ndereng dɔ ndɔ te ke ndi ere are maann taa lo ngaa uwade tɔyn aw ke de. Ndɔ ddee le Ngonn le dew a to ddew kara baa toke baann tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Yeenn a, bbo dingawje joo eeje ndɔɔ a, da kunn mare kara, a da kinya ye ke kara. ");
INSERT INTO ksp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Toke deneje joo aw uruje ne birî a, da kunn mare kara, a da kinya ye ke kara. ");
INSERT INTO ksp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Yeenn a, areje dɔgɔlse te mba e-gereje ndɔ ke Ebbesese a ddee ne ang. ");
INSERT INTO ksp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Maji kare ooje tar neenn ke maje: Toke nje-key gere kare ke nje-bboko a ta ddee ne til te a, na ngem ta-lo bbo na kinya nje-bboko le kare ande key laa ang. ");
INSERT INTO ksp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mba yeenn a, sese kara isije dɔ gɔlse te mba Ngonn le dew a ddee ke kare ke e-gereje ang. ");
INSERT INTO ksp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Nje-kula ke dda ne ke dɔgɔle ddem, keme are ddem ngaa ebbeeje inya nje-kula mareje jia te kare narede ne-kusa ke kare to na wa? ");
INSERT INTO ksp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Rɔ-neel a to laa ne ke ebbeeje le ddee ingae ta kula te le. ");
INSERT INTO ksp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","M-pa marese, tɔkɔrɔ njaa, ebbeeje le a kinya ne-kingaje laa tɔyn me jia te. ");
INSERT INTO ksp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","A toke n̂-to nje-kula ke maji ang a, na keje na: ‹Ebbemje a ddee njange ang bbay.› ");
INSERT INTO ksp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ngaa na kuru dɔ nje-kula mareje te le tundade. Na kusa ne ngaa, na kayn ne ke nje-kayje koto. ");
INSERT INTO ksp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ebbeeje le a ddee ke ndɔ ke neje ang ddem, ke kare ke na gere ang ddem. ");
INSERT INTO ksp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ebbeeje le a ddae maji ang ngaa a kilae lo ke daw dila nje-ngemje ke te are aw nɔnje ddem aw ngeerje ngangede ddem.» ");
INSERT INTO ksp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Yeenn a, Bbe-kɔn ke darâ a to ddew kara baa toke tar le mare ngamandeje dɔku ke jinje lambeje lede ta kaw tila ne kem dingaw ke a ta taa dene. ");
INSERT INTO ksp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nje ke mi toje to mbeje, a keseje ke mi toje to nje-kem-kareje. ");
INSERT INTO ksp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mbeeje le jinje lambeje lede a awje ke maann-koo-lo mba kungu me lambeje te le ang. ");
INSERT INTO ksp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","A nje kem-kareje le jinje lambeje lede ke maanne me ngann kuje te. ");
INSERT INTO ksp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nje taa dene le nayn ddee njange ang bbay a, bbi ddade are n̂-tibbije tɔyn. ");
INSERT INTO ksp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","A kare ke lo mɔngu a, mare ko bbar na: ‹Nje-taa-dene le aw ddee ngaa bbo! E-teeje, e-tilaje keme! ");
INSERT INTO ksp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Yeenn ngaa, ngamandeje le tɔyn ndolje ngaa unnje kutu mɔse lambeje lede. ");
INSERT INTO ksp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mbeeje le dujuje nje ke kemde are le na: ‹Arejeje maann-koo-lo lese ten mba lambeje leje a ta koy.› ");
INSERT INTO ksp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","A nje-kem-kareje le ilade te na: Baann ang, maann-koo-lo leje a kase engaje ke engase tɔyn ang. Awje bbe le dewje ke aw labbeje e-ndokoje enganse. ");
INSERT INTO ksp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","A kare ke dawje ta ndoko a, nje-taa-dene le tee. Nje ke mɔseje rɔde kete le andeje saa me key-kusu taa-naa te, ngaa dutu ta-key le. ");
INSERT INTO ksp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Goe te ngaa bba kese ngamandeje le ddeeje ngaa uruje ekii na: ‹Dingaw, dingaw ɔru ta-key areje.› ");
INSERT INTO ksp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","A nilade te na: ‹Tɔkɔrɔ njaa m-pa marese, m-gerese ang. › » ");
INSERT INTO ksp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Go gusu tar te neenn le a, Jeju pa na: «Yeenn a, arje dɔgɔlse te, mba e-gereje ndɔe ang ddem, kare ang ddem.» ");
INSERT INTO ksp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Tar Bbe-kɔn le Lubba a to ddew kara baa ke tar le mare dingaw ke a ta kaw mba te a, bbar nje-kulaje laa ngaa inya ne-kingaje laa me jide te. ");
INSERT INTO ksp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nare mare kara kande ande-nare kɔr mi. Nare mare kɔr joo. A nare mare kɔr kara. Narede ase gude gude ngaa, naw mba te le. ");
INSERT INTO ksp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Dew ke inga kande ande-nare kɔr mi le aw labbe ne ne ngaa inga kande ande-nare kɔr mi dɔe te tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ne ke ninga kɔr joo le naw n̂-dda toke baann tɔ ngaa ninga kɔr joo dɔe te tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","A ne ke ninga kɔr kara le naw nuru buwa ngaa niya nare le ebbeeje le me te. ");
INSERT INTO ksp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ndɔ nya goe te a, ebbe-nje-kulaje le tel ddee ngaa unn kutu dujude kare n̂-tɔje ne ke n̂-ddaje ke nare laa le. ");
INSERT INTO ksp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ne ke ninga kande ande-nare kɔr mi le naw n̂-ddee ke mare kande ande-nare kɔr mi ke ninga dɔe te le ngaa n̂-pa na: ‹Ebbemje, arem kande ande-nare kɔr mi, a ye ke kɔr mi ke minga dɔe te a neenn.› ");
INSERT INTO ksp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ebbeeje pa are na: ‹Maji, e-to nje-kula ke maji ddem, e-dda ne ke dɔgɔle ddem. E-dda ne ke dɔgɔle ddew neje te ke sen baa. Yeenn a, ma kinya neje ke bo me jii te. E-ddee e-dda rɔ-neel sem.› ");
INSERT INTO ksp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ne ke dare kande ande-nare kɔr joo le n̂-ddee tɔ ngaa, n̂-pa na: ‹Ebbemje, arem kande ande-nare kɔr joo, a ye ke kɔr joo ke minga dɔe te a neenn.› ");
INSERT INTO ksp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ebbeeje pa are na: ‹Maji, e-to nje-kula ke maji ddem, e-dda ne ke dɔgɔle ddem. E-dda ne ke dda ne ke dɔgɔle ddew neje te ke sen baa. Yeenn a, ma kinya neje ke bo me jii te. E-ddee e-dda rɔ-neel sem.› ");
INSERT INTO ksp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Gode te tɔyn a, ne ke ninga kande ande-nare kɔr kara le n̂-ddee ngaa n̂-pa na: ‹Ebbemje, m-gere to e-to dew ke ketere. Lo ke e-dubbu ne te ang kara aw uja ne te. Lo ke e-tila ko te ang kara aw tɔru ne te. ");
INSERT INTO ksp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Bbeel ddam are maw miya nare lei le me buwa te. Ye a neenn, e-taa.› ");
INSERT INTO ksp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ebbeeje le ilae te na: ‹Nje-kula ke maji ang, nje-dabbe. E-gere to lo ke m-dubbu ne te ang kara maw muja ne te. Lo ke m-tila ko te ang kara maw m-tɔru ne te. ");
INSERT INTO ksp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Bbo baann a, mba ddi bba ungu nare lem le lo ngem nare te kare telem a minga nare lem le ddem, mare nare dɔe te ddem ang wa? ");
INSERT INTO ksp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","E-taaje kande ande-nare ke kɔr kara le jia te areje nje-kula ke ee ke kande ande-nare doro kara le. ");
INSERT INTO ksp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mba da kare ne dew ke ee ke ne kare ne laa bo ke kete kete. A dew ke ee ke ne kara ang, ne laa ke ten baa be kara da taa jia te. ");
INSERT INTO ksp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","A ne nje-kula ke kari baa neenn le, ilaeje ddaka lo te ke ndul lo te ke dewje aw nare n̂-nɔje ngaa aw ngeerje ngangede kete.» ");
INSERT INTO ksp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Ndɔ ke Ngonn le dew a ddee ke anjije laa tɔyn me piti te laa a, na kisi dɔ ngende-mbay te laa ke to ne-piti. ");
INSERT INTO ksp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dewje tɔyn ke dɔ nange te a mbɔnje naa nɔe te ngaa, na kayn horo dewje ddew kara baa toke nje-ngem-da aw kayn horo bateje ke benyaje. ");
INSERT INTO ksp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Na kungu bateje dɔ-ji-kɔle te a, na kungu benyaje dɔ-ji-gele te. ");
INSERT INTO ksp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Yeenn ngaa, Tɔku-mbay le a pa kare nje ke isije dɔ-ji-kɔle te na: ‹Sese ke Bɔmje bbar tar ke maji dɔse te le, e-ddeeje. E-taaje Bbe-kɔn ke Lubba mɔse mba tar lese lew baa kare te ke naw n̂-dda ne neje le to lese. ");
INSERT INTO ksp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mba bbo ddam, a aremje ne musa. Kunda ɔm, a aremje maann may. M-to nje-mba, a e-taamje ke key. ");
INSERT INTO ksp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kubbu goto rɔm te, a aremje kubbu mula. Rɔm tom, a e-ddee oomje. M-to key-kula te, a e-ddeeje oomje.› ");
INSERT INTO ksp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Yeenn ngaa dewje ke gate gate le a kilaeje te na: ‹Ebbe-dewje, ndɔ ke dda bba bbo ddai bba joi a jari ne-kusa, wase kunda wɔin bba jari maann ay wa? ");
INSERT INTO ksp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ndɔ ke dda bba e-to nje-mba bba joi a n̂-taai ke key, wase kubbu goto rɔi te bba jari kubbu ɔ wa? ");
INSERT INTO ksp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ndɔ ke dda bba rɔi toi, wase ee key-kula te bba n̂-ddee jooi wa?› ");
INSERT INTO ksp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Yeenn ngaa Tɔku-mbay le a kilade te na: ‹Tɔkɔrɔ njaa, m-pa marese, kare tɔyn ke e-ddaje nejeenn le ke kara le ngakɔm ke toje to dewje ke ten baa neenn a, yeenn to ema a e-ddaje sem.› » ");
INSERT INTO ksp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Goe te a, na pa kare nje ke eeje dɔ-ji-gele te le na: ‹ɔtuje mbɔrem te ke ddang, sese ke ndu-ndɔɔl to dɔse te. Awje dann puru te ke a kɔn ke ndɔ ke ndɔ, ke Lubba mɔse mba esu de ke anjije laa. ");
INSERT INTO ksp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mba bbo ddam, a aremje ne-kusa ang. Kunda ɔm, a aremje maann kay ang. ");
INSERT INTO ksp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","M-to nje-mba, a e-taamje ke key ang. Kubbu goto rɔm te, a aremje kubbu ang. Rɔm tom, a e-ddeeje oomje ang ddem, m-to key-kula te, a e-ddeeje oomje ang.› ");
INSERT INTO ksp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yeenn ngaa da kilaeje te na: ‹ Ebbejeje! Ndɔ ke dda bba bbo ddai, kunda wɔin, e-to nje-mba, kubbu goto rɔi te, rɔi toi wase ee key kula te bba jumai ang wa?› ");
INSERT INTO ksp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","A na kilade te na: ‹Tɔkɔrɔ njaa, m-pa marese, kare tɔyn ke e-ddaje nejeenn le ke kara le ngakɔm ke toje to dewje ke ten neenn ang a, yeenn to ema a e-ddaje sem ang.› ");
INSERT INTO ksp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Da kaw koo ndoo ke ndɔ ke ndɔ, a nje ke ddaje ne ke me Lubba ndiki le a kisi ke tebbe ke ndɔ ke ndɔ.» ");
INSERT INTO ksp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Toke Jeju pa tarje neenn le tɔyn nunga a, n̂-pa nare nje-njaje goe te na: ");
INSERT INTO ksp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«E-gereje tɔyn to kusu-Pake nayn ndɔ joo baa ngaa. Da kila Ngonn le dew ji dewje te kare n̂-tɔle dɔ kake-dese te.» ");
INSERT INTO ksp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yeenn ngaa, tɔku nje-poloje Lubba ke tɔkuje le Jiipije mbɔnje naa me ndoko te le mbay le tɔku nje-poloje Lubba ke ria na Kayipi, ");
INSERT INTO ksp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ngaa dunnje ndude ta kuwa Jeju ke gusu ta tɔle. ");
INSERT INTO ksp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","A n̂-paje na: «Areje juwae ke ndɔ kusu-Pake ang, mba a kuju bula horo dewje te.» ");
INSERT INTO ksp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jeju ee Betani key le Simɔ ke lew to nje-banji, ");
INSERT INTO ksp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","a mare dene ddee ngɔsi saa. Nuwa ku ke n̂-dda ke er ke ria na Alebatere jia te. Yambo ke gate ngeng nya ddusu mee. Kare ke Jeju nayn ta ne-kusa te bbay a, dene le ungu yambo le dɔe te. ");
INSERT INTO ksp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Toke nje-njaje-go Jeju te ooje neenn le a, neelde ang ngaa n̂-paje na: «N̂-tuju yambo neenn be mba ddi wa? ");
INSERT INTO ksp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Maji ta labbe yambo neenn ke gate ke ngeng a kayn nare nje-ndooje ang wa?» ");
INSERT INTO ksp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jeju gɔn tar ke daw n̂-pa le gere ngaa pa na: «Mba ddi bba aw jɔkuje dene neenn wa? Ne ke maji a n̂-dda sem. ");
INSERT INTO ksp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nje-ndooje aw nayn ke se ke ndɔ tɔyn. A ema, ma nayn ke se ke ndɔ tɔyn ang. ");
INSERT INTO ksp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nungu yambo le rɔm te ta mɔsem ngina ne ndɔ ke da kilam me buwa-yo te. ");
INSERT INTO ksp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tɔkɔrɔ, m-pa marese, lo tɔyn ke dɔ nange te ke da kila mber Tar ke majineenn te, da pa tar ne ke dene neenn dda ngaa da kole mede dɔe te. ");
INSERT INTO ksp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Goe te a, kara le nje-njaje-go Jeju te ke dɔku gire joo ke daw n̂-bbare na Judase Isikariyote aw inga tɔku nje-poloje Lubba, ");
INSERT INTO ksp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ngaa pa arede na: «Toke mila Jeju jise te a, ddi a, a karemje wa?» Tɔku nje-poloje Lubba areje kande nare dɔmota. ");
INSERT INTO ksp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Unn kutue kare teenn, Judase aw sange ddew ta kila Jeju jide te. ");
INSERT INTO ksp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Dɔngɔr ndɔ kusu-mapa ke n̂-dda ke wum ang le a, nje-njaje-go Jeju te ddeeje dujeje na: «E-ndiki kare n̂-mɔse ne-kusa mba kusu-Pake le jari lo te ke dda wa?» ");
INSERT INTO ksp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jeju ilade te na: «Awje tɔku bbe te rɔ mare dew te ke be. E-paje areje na: ‹Nje-ne-tɔju pa na: Kare lem ddee ngɔsi ngaa. Key lei a ema ke nje-njaje-gom te ja dda kusu-Pake ke te.› » ");
INSERT INTO ksp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nje-njaje-go Jeju te ddaje ne ke nunn ndu narede kare n̂-ddaje ngaa n̂-mɔseje neje mba kusu-Pake le. ");
INSERT INTO ksp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Lo-kul a, nisi ta ne-kusa te ke nje-njaje goe te ke dɔku gire joo le. ");
INSERT INTO ksp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kare te ke daw dusaje ne a, n̂-pa na: «Tɔkɔrɔ m-pa marese, dew kara horose te a kilam ji dewje te.» ");
INSERT INTO ksp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Rɔ nje-njaje-go Jeju te le neelde ang nyɔm ngaa dede kara kara n̂-dujeje na: «Ebbe-dewje to ema wa?» ");
INSERT INTO ksp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nilade te na: «Dew ke ula jia naa te sem me sambe te neenn, ne a na kilam ji dewje te. ");
INSERT INTO ksp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ngonn le dew a koy ddew kara baa ke tar ke makuturu le Lubba pa dɔe te. A kem to ndoo a to le dew ke a kilae ji dewje te le. Duje ang kara maji nya uta.» ");
INSERT INTO ksp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judase ke a ta kilae ji dewje te le duje na: «Nje-ne-tɔju, to ema wa?» Jeju ilae te na: «Ei njaa e-pa mban.» ");
INSERT INTO ksp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kare te ke daw dusaje ne a, Jeju unn mapa ngaa, are wooyo Lubba a, tete ngaa are nje-njaje goe te a pa na: «E-taaje usaje. Yeenn to da-rɔm ann. ");
INSERT INTO ksp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Goe te a, nunn mare engo maann binye ngaa nare wooyo Lubba a, n̂-pa na: «Sese tɔyn njaa ayje, ");
INSERT INTO ksp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","yeenn to mesem ann. To mese ke Lubba ɔsu ne dɔnɔ ke dewje ke banya are ula mba kare tar majang lede ɔru ne dɔde te. ");
INSERT INTO ksp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","M-pa marese, ma kay maann binye neenn ang ngaa ndereng ndɔ ke ma kay ne maann binye ke siki ke se me Bbe-kɔn te le Bɔmje.» ");
INSERT INTO ksp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Goe te a, dɔsuje pa wal Lubba, ngaa n̂-teeje dawje ke dɔ ddingiri Olibeje te. ");
INSERT INTO ksp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yeenn a, Jeju pa arede na: «Til te neenn, ne a kingam kare e-tusumje tɔyn inyamje, mba n̂-dda me Maketurute le Lubba na: Ma tɔl nje-ngem-bateje, ta kusu bateje le a saren.» ");
INSERT INTO ksp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","«A go kin te ke ma kin horo dewje te ke oy a, ma kaw nginase Galile.» ");
INSERT INTO ksp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piyar pa are na: «Le dewje tɔyn tusije inyaije kara, ema ma kinyai ndɔ kara ang.» ");
INSERT INTO ksp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jeju ilae te na: «Tɔkɔrɔ, m-pa mari, til te neenn njaa, kete bba kare kuran nɔ a, a mbetem ta pa na e-gerem ang gɔl mota.» ");
INSERT INTO ksp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piyar pa are na: «Le ase kare moy sei kara, ma mbiti ta pa na m-geri ang ndɔ kara ang.» Ngaa kese nje-njaje goe te tɔyn paje toke baann tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Goe te a, Jeju aw ke nje-njaje goe te le lo te ke daw n̂-bbar na Jetesemane ngaa n̂-pa narede na: «Isije lo te neenn a ema, ma kaw duju Lubba lo te ke yonn. ");
INSERT INTO ksp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","N̂-jin Piyar de ke ngann le Jebede ke joo naw ke de. Rɔe unn kutu neele ang ngaa bbeel uta dɔe tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ngaa, n̂-pa narede na: « Rɔm neelem ang nja nyɔm. E-naynje neenn, ta je ke se, jareje bbi ɔru kemje ang.» ");
INSERT INTO ksp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Goe te a, n̂-ngese ke kete ten be ngaa, n̂-tee noso ke ta mee, n̂-debbe keme nange ngaa n̂-duju Lubba n̂-pa na: «Bɔy, bbo ddew to a, uta engo kem-to-ndoo neenn ke ddang. A e-dda toke mei ndiki bbo toke mem ndiki ang.» ");
INSERT INTO ksp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","N̂-tel n̂-ddee rɔ nje-njaje goe te ke mota le a, ningade tɔyn dɔ bbi te. Yeenn ngaa n̂-pa nare Piyar na: «A kaseje ta kare bbi ɔru kemse ang sem mba kare kara ang wa?» ");
INSERT INTO ksp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Areje bbi ɔru kemse ang bbo e-dujuje Lubba na a kosoje me ne-na te. Dew ndiki ta dda ne ke maji njaa a, da-rɔ inga ddew ta dda ne le ang.» ");
INSERT INTO ksp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jeju tel aw ddew ew bbay ngaa duju Lubba na: «Bɔy, bbo engo neenn le to ta kare may njaa, mba ddew ke a kɔru ne ke ddang goto a, maji kare e-dda ne ke mei ndiki.» ");
INSERT INTO ksp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","N̂-tel n̂-ddee a ningade dɔ bbi te bbay mba bbi uta dɔde. ");
INSERT INTO ksp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ninyade a naw n̂-duju Lubba ke gɔl mota laa bbay. Neenn le njaa n̂-tel n̂-duju Lubba le bbay. ");
INSERT INTO ksp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ngaa n̂-tel n̂-ddee rɔ nje-njaje goe te a n̂-pa na: «Aw e-tibbije, aw uwaje rɔse bbay wa? Bbasine, kare ase ngaa, da kila Ngonn le dew ji nje-ne-ddaje te ke maji ang. ");
INSERT INTO ksp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Yeenn a, inje are jawje. Dew ke ilam ji dewje te le ddee ngɔsi ngaa. ");
INSERT INTO ksp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Toke Jeju nayn aw pa tar bbay a, kara le nje-njaje goe te ke dɔku gire joo ke ria na Judase le ddee ke dewje ke banya. Duwaje tɔku kiyaje ke kakeje jide te. Tɔku nje-poloje Lubba, ke tɔkuje le Jiipije a ulajede. ");
INSERT INTO ksp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judase nje-kila Jeju jide le tɔjude toke kete, mare ne ke na dda kare n̂-gere ne Jeju le. N̂-pa na: «Dew ke m-to mbiya a, to ne ann ta uwaeje.» ");
INSERT INTO ksp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Njange baa njaa a, Judase le ddee ngɔsi ke Jeju ngaa pa are na: «Lapiya, Nje-ne-tɔju!.» Ngaa n̂-to mbiya. ");
INSERT INTO ksp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jeju ilae te na: «Naam, e-dda ne ke e-ddee ta dda le.» Yeenn ngaa dewje le ddeeje ngɔsi ke Jeju le ngaa ilaeje uwaeje. ");
INSERT INTO ksp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mare nje-nja go Jeju te kara ɔru tɔku kiya laa ngaa tuka ne mbi mare nje-kula le tɔku-nje-polo Lubba ti. ");
INSERT INTO ksp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yeenn ngaa Jeju pa are nje-nja goe te le na: «E-tel ke tɔku kiya lei ture te, mba dew ke tɔl dew ke tɔku kiya a, da tɔle ke tɔku kiya tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","E-gere ang wa? Mase ta duju Bɔy kare ula ke anjije ke toje to nje-ddɔje banya banya arem. ");
INSERT INTO ksp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","A bbo m-dda toke baann a, tarje ke Maketurule Lubba pa le a ddeeje to ne ke tɔkɔrɔ toke baann wa? Maketuru le pa na maji kare neenn le to toke baann.» ");
INSERT INTO ksp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Goe te a, Jeju pa are dewje ke banya le na: «E-ddeeje ke tɔku kiyaje, ke kakeje bba ta kuwam ne toke ne ke m-to nje-bboko. Ke ndɔ tɔyn misi me key-polo-Lubba te maw m-tɔju ne, a uwamje ang. ");
INSERT INTO ksp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","A nejeenn tɔyn teeje kare tar ke nje-kilaje mber-tar le Lubba paje me Maketurute le ddeeje ne to ne ke tɔkɔrɔ.» Yeenn ngaa nje-njaje-go Jeju te le tɔyn njaa aynje inyaeje. ");
INSERT INTO ksp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nje ke uwaje Jeju le awje saa rɔ Kayipi te ke to tɔku nje-polo Lubba. Nje-kɔruje gel ndu ke tɔkuje le Jiipije mbɔnje naa lo teenn. ");
INSERT INTO ksp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piyar ɔru goe, a nja ddew ew saa ndereng tee ne me ndoko te le Kayipi le. Nande me ndoko te le ngaa nisi ke nje-ngemje ta key ta koo se ne le a kɔsu kɔyn toke baann wa? ");
INSERT INTO ksp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tɔku nje-poloje Lubba ke nje-gangeje sariya le Jiipije le tɔyn aw sangeje mare tar ngem ta kunda dɔ Jeju te bba ta gange ne sariya yo dɔe te. ");
INSERT INTO ksp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nje-tar-najije ke toje to nje-ngemje nya nya ddeeje ulaje tar tae te. A dingaje ne ke ta kunda ne tar dɔe te le ang. Dɔ bɔnye a mare dewje joo ddeeje paje na: ");
INSERT INTO ksp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Dew neenn pa na: ‹Mase ta tɔ key-polo-Lubba ta tel dda ture te me ndɔ mota te.› » ");
INSERT INTO ksp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tɔku nje-polo Lubba le in taar ngaa duje na: «Tar ke a kila te goto wa? Tar ddi a, a pa dɔ tar te ke dewje aw paje dɔi te neenn wa? ");
INSERT INTO ksp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","A Jeju pa tar ang. Yeenn ngaa tɔku nje-polo Lubba pa are na: « M-duji ke ri Lubba ke nje-kisi kem baa kare ilaje tar te neenn: ‹E-to Mesi, Ngonn le Lubba wa?› » ");
INSERT INTO ksp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jeju ilae te na: «Ei njaa e-pa mban. A m-pa marese, bbasine neenn njaa a kooje Ngonn le dew dɔ-ji kɔl Lubba te ke nje-singa-mɔngu. A kooeje kare te ke na kin darâ ta ddee me mum te tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yeenn ngaa tɔku nje-polo Lubba le tir kubbu ke rɔe te ngaa pa na: «N̂-taji Lubba. N-ndiki ta kinga nje-tar-naji bbay ang ngaa. Ooje taji ke n̂-taji Lubba neenn mban. ");
INSERT INTO ksp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Tar ddi a ejeje dɔe te wa?» Dilaeje te na: «Nase yo.» ");
INSERT INTO ksp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Yeenn ngaa, n̂-tibbije nwere keme te ngaa n̂-bbirije jide n̂-tundaeje ne. Mareje tundaje ka-mbɔre ngaa, ");
INSERT INTO ksp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","paje na: «Mesi, e-pa are joo, na a undai wa?» ");
INSERT INTO ksp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kare teenn Piyar isi ddaka me ndoko te le. Mare nje-kula ke dene ddee ngɔsi saa ngaa pa na: «Ei kara e-nja ke Jeju dew ke Galile neenn le tɔ.» ");
INSERT INTO ksp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","A Piyar mayn kem dewje te tɔyn na: «M-gere tar ke e-ndiki ta pa neenn ang.» ");
INSERT INTO ksp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nunn ddew ta kɔtu ngaa n̂-tee ta ndoko te le a, mare nje-kula ke dene dang ooe ngaa pa are nje ke isi lo teenn na: «Dew neenn nja ke Jeju dew ke Najarete le tɔ.» ");
INSERT INTO ksp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piyar unda yo ngaa mayn bbay na: «M-gere dingaw neenn ang.» ");
INSERT INTO ksp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ngaji goe te a, nje ke eeje teenn le awje ngɔsi ke Piyar le ngaa paje are na: «E-to kara le dewje neenn njaa. Tar-pa lei njaa tɔju.» ");
INSERT INTO ksp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yeenn ngaa nunn kutu kunda yo ngaa n̂-tɔn ne guma na: «M-gere dingaw neenn ang. Toke mere ngem a, maji kare Lubba undam.» Kare teenn njaa kuran nɔ. ");
INSERT INTO ksp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Piyar ole mee dɔ tar te ke Jeju pa are na: «Kete bba kare kunra nɔ a, a mbetem pa na e-gerem ang gɔl mota.» N̂-tee ddaka ngaa n̂-nɔ nya. ");
INSERT INTO ksp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ke endɔɔ baa njaa, tɔku nje-poloje Lubba, ke tɔkuje le Jiipije tɔyn unnje ndude kare n̂-tɔl Jeju. ");
INSERT INTO ksp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Duwaeje n̂-tɔeje ngaa, n̂-ddeeje saa dulaeje ji ngonn-mbay Pilate te, ke to dew ke Rɔm. ");
INSERT INTO ksp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Toke Judase ke ila Jeju ji dewje te le oo sariya yo ke n̂-ngange dɔe te le a, keje laa jɔke nya. N̂-tel ke kande nare ke dɔmota le nare tɔku nje-poloje Lubba, ke tɔkuje le Jiipije le. ");
INSERT INTO ksp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","N̂-pa narede na: «M-dda ne ke maji ang, mba mila dew ke dda ne ke maji ang kara ang ji dewje te kare n̂-tɔle.» Dilaeje te na: «Osoje te ang. Yeenn ooi.» ");
INSERT INTO ksp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judase sanre nare le me key-polo-Lubba te ngaa ɔtu aw ila kula gɔse te tɔ kake te ngaa oy. ");
INSERT INTO ksp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tɔku nje-poloje Lubba le ndekeje nare le ngaa paje na: «Ndu are ddew ta ngem nare ke be neenn lo-ngem nare te ke me key-polo-Lubba te ang, mba to nare mese. ");
INSERT INTO ksp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Duwaje dɔ naa ngaa goe te a, dunnje nare le n̂-ndokoje ne ndɔɔ le mare nje-kubba jo ta dda to lo dubbu yo le nje-mbaje. ");
INSERT INTO ksp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mba yeenn a n̂-bbar ne ndɔɔ le na « ndɔɔ-mese» ndereng bbokone. ");
INSERT INTO ksp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Yeenn ngaa tar le Lubba ke Jeremi nje-kila mber-tar laa pa le ddee ne to tar ke tɔkɔrɔ. Tar le na: «N̂-taaje kande nare dɔmota. To gate dew ke ngann Ijarayelje wɔju le ann. ");
INSERT INTO ksp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ngaa dareje mba ndoko ne ndɔɔ le nje-kubba jo ddew kara baa ke ndu ke Ebbe-dewje unn arem.» ");
INSERT INTO ksp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Daw ke Jeju nɔ ngonn-mbay Pilate te. Ngonn-mbay le duje na: «E-to tɔku-mbay le Jiipije wa?» Jeju ilae te na: «Ye njaa e-pann.» ");
INSERT INTO ksp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","A toke tɔku nje-poloje Lubba, ke tɔkuje le Jiipije aw undaje tar dɔe te a, nilade te kara ang. ");
INSERT INTO ksp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Yeenn ngaa, Pilate duje na: «Oo tarje tɔyn ke daw dundaje dɔi te neenn ang wa?» ");
INSERT INTO ksp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","A nilae mare tar te kara ang. To ne ke dum dɔ Pilate le. ");
INSERT INTO ksp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ke ndɔ kusu Pake kara kara tɔyn, ngonn-mbay le aw ɔru dew key-kula te. To dew ke dewje ke banya ndikije kare nɔre. ");
INSERT INTO ksp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","A kare teenn mare dew ke ria bbar nya ee key-kula te le. Ria na Barabase***. ");
INSERT INTO ksp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Yeenn a Pilate duju dewje ke banya ke mbɔnje naa le na: «Na bba e-ndikije kare mɔre marese wa? Barabase wase Jeju ke daw n̂-bbare to Kiriste le wa? ");
INSERT INTO ksp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Mba Pilate gere ke maje to me a ddade dɔ Jeju te a duwaeje dulae jia teenn. ");
INSERT INTO ksp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kare te ke Pilate isi lo sariya te le bbay a, dene laa ula pa are na: «Ula tai tar te le dew ke gate gate neenn ang. Mba til te neenn, moo ndoo nya me ni te wɔju dɔe.» ");
INSERT INTO ksp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","A tɔku nje-poloje Lubba, ke tɔkuje le Jiipije tulaje dewje ke banya le kare n̂-dujeje dare nɔru Barabase a ta n̂-tɔlje Jeju. ");
INSERT INTO ksp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ngonn-Mbay le tel dujude na: «Horo dewje te ke joo neenn, na bba e-ndikije kare mɔre marese wa?» A dilaeje te na: «Barabase!» ");
INSERT INTO ksp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilate dujude bbay na: «Ddi a ma dda ke Jeju ke daw n̂-bbare to Kiriste le wa?» Dede tɔyn njaa dilaeje te na: «Are n̂-tɔle dɔ kake-dese te!» ");
INSERT INTO ksp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilate dujude na: «Majang ddi a n̂-dda wa?» A dunnje kutu kuru ekii ke singa bbay na: «Are n̂-tɔle dɔ kake-dese te!» ");
INSERT INTO ksp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Toke Pilate oo to na kase dda mare ne dang ang, ngaa dewje le aw yekeje lo ke kete kete a, nunn maann ngaa n̂-toko ne jia kem dewje te ke banya le ngaa n̂-pa na: «Tar yo le dingaw neenn a kuwa dɔm ang. Oose.» ");
INSERT INTO ksp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Dewje ke banya le tɔyn ilaeje te na: «Maji kare tar yo laa le oso dɔje te ke dɔ ngannje te.» ");
INSERT INTO ksp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yeenn ngaa Pilate ɔru Barabase arede. Nare n̂-tunda Jeju ke ndey ngaa nulae jide te kare n̂-tɔle dɔ kake-dese te. ");
INSERT INTO ksp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mbambaje le Pilate awje ke Jeju lo gange sariya te laa, ngaa kese mbambaje le tɔyn mbɔnje naa dɔe te. ");
INSERT INTO ksp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","N̂-tɔruje kubbuje laa rɔe te ngaa dulaeje kubbu ke ngal ngaa kase. ");
INSERT INTO ksp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","N̂-peteje kulaje ke to konn to ejɔkudɔ, ngaa dundaje dɔe te. Dulaje kare jia te ke kɔl ngaa dɔsuje mekeji gɔlde nange nɔe te, n̂-kokeje ngaa n̂-paje na: «Lapiya, tɔku-mbay le Jiipije!» ");
INSERT INTO ksp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","N̂-tibbije weren dɔe te ngaa n̂-taaje kare le dunda ne dɔe. ");
INSERT INTO ksp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","N̂-ddae n̂-koko ne ngaa goe te a, dɔruje tɔku kubbu le ngaa n̂-tel dulae kubbuje laa. Goe te a, dawje saa ta tɔle dɔ kake-dese te. ");
INSERT INTO ksp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Toke mbambaje le inje me bbe te le aw teeje ke ddaka a, dingaje mare dingaw ke bbe te ke Sirenn, ria na Simɔ, ngaa duwaeje dare noto kake-dese le Jeju le. ");
INSERT INTO ksp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Daw n̂-teeje lo te ke daw n̂-bbar na Gologota, ke kande na: «Lo ka-dɔ dewje» a, ");
INSERT INTO ksp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","dareje Jeju le maann kande binye ke dungu maann ne ke ate me te ngaa dare kare nay. Jeju le na a, mbete ta kay. ");
INSERT INTO ksp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","N̂-bbereje dɔ kake-dese te le ngaa goe te a, n̂-ddɔje mbari n̂-kaynje ne naa kubbuje laa. ");
INSERT INTO ksp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ngaa disije lo teenn ta ngeme. ");
INSERT INTO ksp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","N̂-dda mare makeruru n̂-bbere er dɔe te ta tɔju ne gel ne ke n̂-gange ne sariya dɔe te le na: «Dew neenn to Jeju, tɔku-mbay le Jiipije.» ");
INSERT INTO ksp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","N̂-bbere nje-bbokoje joo dɔ kake-deseje te mbɔre te tɔ. Mare kara er kɔl, a mare kara er gel. ");
INSERT INTO ksp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Dewje ke aw ndayje loteenn tukaje dɔde a tajeje. ");
INSERT INTO ksp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","N̂-paje dareje na: «Ei ke e-ndiki ta tɔ key-polo-Lubba ta tel dda mare ture te me ndɔ mota te le, bbo e-to Ngonn le Lubba a, aji rɔi ei njaa bbo in dɔ kake-dese te le uru nangê.» ");
INSERT INTO ksp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tɔku nje-poloje Lubba, ke nje-kɔruje gel ndu, ke tɔkuje le Jiipije kokeje tɔ paje na: ");
INSERT INTO ksp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Naji mare dewje, a nase ta kaji rɔe njaa ang! Tɔku-mbay ke Ijarayel le ann? Bbo nin dɔ kake-dese te nuru nangê a, ja koo meje te saa. ");
INSERT INTO ksp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nunda mee dɔ Lubba te ngaa n̂-pa na n̂-to Ngonn le Lubba. Toke Lubba ndike a, maji kare naje bbasine neenn.» ");
INSERT INTO ksp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nje-bbokoje ke n̂-bberede dɔ kake-deseje te le tajeje toke baann tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Unn kute kare te ke ar dana ndereng gɔl kare mota ke lo-kul te, lo ndul dɔ nange te tɔyn. ");
INSERT INTO ksp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","A ta tee gɔl kare te ke mota a, Jeju uru ekii ke singa na: «Eli, Eli, lama sabakantani!» Kande tar le na: «Lubba lem, Lubba lem, inyam mba ddi wa?» ");
INSERT INTO ksp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mare dewje ke eeje lo teenn le ooje tar le Jeju le a paje na: «Naw n̂-bbar Eli.» ");
INSERT INTO ksp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mare dew kara horode te ayn ke ngɔru aw unn mare ta kubbu ula me maann binye te ke mase ngaa ke ta kare te a ula are Jeju kare ay. ");
INSERT INTO ksp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","A mareje paje na: «N-ngina joo se Eli a ddee kaje wa?» ");
INSERT INTO ksp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jeju tel uru ekii ke singa bbay ngaa goe te a kewn laa tee. ");
INSERT INTO ksp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kare teenn njaa, kubbu ke n̂-tɔ n̂-gange ne me key-polo-Lubba tir dana, in taar uru nangê. Nange yeke ngaa erje riyaje. ");
INSERT INTO ksp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ta buwa-yoje teyn ngaa dewje ke ooje mede te ke Lubba bba oyje ndolje. ");
INSERT INTO ksp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Dinje me buwa-yoje te le n̂-teeje ngaa, go ndol te ke Jeju ndol horo dewje te ke oy le a, dandeje Jurusalam ke to bbe ke maji tɔyn are dewje nya oojede. ");
INSERT INTO ksp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Toke nje-kɔn dɔ mbambaje ke Rɔm, ke dewje ke eeje saa lo ngem niinn Jeju le ooje nange ke aw yeke, ke neje ke teeje le a, bbeel ddade nya ngaa n̂-paje na: «Dew neenn to Ngonn le Lubba njaa.» ");
INSERT INTO ksp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Deneje ke banya ke inje Galile ngaa unnje go Jeju aw dda saa le eeje teenn tɔ. Darje ddew ew daw dooje nejeenn le. ");
INSERT INTO ksp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Horo deneje teenn le, Mari ke Magedala, ke Mari ke uju Jake de ke Jejebbe, ke kɔn ngann le Jebede deeje teenn. ");
INSERT INTO ksp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Lo-kul a, mare nje-ne-kinga ke to dew ke bbe te ke Arimate ddee tee. Ria na Jejebbe. Ne kara n̂-to nje-nja-go Jeju te tɔ. ");
INSERT INTO ksp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Naw noo Pilate ngaa n̂-duju niinn Jeju le. Yeenn ngaa Pilate unn ndu kare dare niinn le. ");
INSERT INTO ksp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nunn niinn le ngaa, n̂-ke ke kubbu ke siki ke are ngate ngate, ");
INSERT INTO ksp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ngaa nila buwa-yo te laa ne njaa ke nare duru dare toke siki bbay me er te. Goe te a, n̂-ndubbu mare tɔku er nutu ne ta buwa-yo le ngaa nɔtu. ");
INSERT INTO ksp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari ke Magedala de ke Mari ke kara deeje teenn, disije nangê, kemde ke buwa-yo te le. ");
INSERT INTO ksp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Lo-kare, ke to ndɔ ke go ndɔ mɔse neje mba ndɔ-kuwa-rɔ a, tɔku nje-poloje Lubba, ke Parijiyenje awje naate kara baa rɔ Pilate te, ");
INSERT INTO ksp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ngaa paje na: «Dew ke bo, jole meje to, dɔ ndɔ te ke nje-kere dewje neenn le nayn ne kem baa bbay le, n̂-pa na: ‹Ndɔ mota go yo te lem a, ma kin horo dewje te ke oy.› ");
INSERT INTO ksp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yeenn a, unn ndu are n̂-ngem buwa-yo le ndereng ndɔ mota. Baann ang a, nje-njaje goe te a ddee bbokoje niinne a da paje kareje dewje to ne a nin horo dewje te ke oy. Ngem ke guku neenn a ngeng kuta ye ke kete bbay. ");
INSERT INTO ksp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilate pa arede na: «Nje-ngemje ta lo a neenn. Awje areje n̂-ngemje buwa-yo le toke mese ndiki.» ");
INSERT INTO ksp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Dawje buwa-yo te le ta koo gusu ke ta ngem ne buwa-yo le. N̂-ddaje mare endaji ta buwa-yo le ngaa dundaje nje-ngemje ta lo tae te. ");
INSERT INTO ksp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Go ndɔ-kuwa-rɔ te le Jiipije a, ke ndɔ-kuwa-rɔ, Mari ke Magedala de ke Mari ke kara dawje ta koo buwa-yo le. ");
INSERT INTO ksp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","A ta koo a, nange yeke ke singa. Mare anji le Ebbe-dewje in dara ddee, ndubbu er le ke ddang ngaa isi dɔe te. ");
INSERT INTO ksp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","N̂-ndɔren toke teel le ndi ngaa kubbu laa nda toke le neyn jeenn. ");
INSERT INTO ksp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nje-ngemje buwa-yo le bbeelje nya ngaa isaje. Disije toke le dewje ke oy. ");
INSERT INTO ksp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","A anji le pa are deneje le na: «Sese, areje beel ddase ang, mba m-gere to aw e-sangeje Jeju ke n̂-tɔle dɔ kake-dese te le. ");
INSERT INTO ksp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nee neenn ang, nin horo dewje te ke oy ddew kara baa toke n̂-pa le. E-ddee ooje lo ke dilae te le. ");
INSERT INTO ksp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ta, awje njange aw e-paje are nje-njaje goe te, e-paje na: ‹Nin horo dewje te ke oy, ngaa naw ta nginase Galile. A kooeje nunn. Tar ke m-ndiki ta pa karese ann.› » ");
INSERT INTO ksp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Deneje le ɔtuje buwa-yo te le ke ngɔru. Bbeel ddade ddem, rɔde neelde nya ddem ngaa daw paje tar le dareje nje-njaje-go Jeju te. ");
INSERT INTO ksp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","A ta koo a, Jeju tee nɔde te aw tila kemde ngaa pa arede na: «Lapiya lese!» Deneje le ddeeje ngɔsi saa ngaa, dɔsuje mekeji gɔlde nɔe te ngaa duwaje gɔle n̂-waleje ne. ");
INSERT INTO ksp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yeenn ngaa Jeju pa arede na: «E-bbelje ang, aw paje areje ngakɔm are dawje Galile. Lo te ke nunn a da koom.» ");
INSERT INTO ksp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Toke deneje le naynje ddew-boo bbay a, mare dewje ke ngemje ta buwa-yo le telje awje me tɔku-bbe te ngaa ɔruje gel neje tɔyn ke tee le areje tɔku nje-poloje Lubba. ");
INSERT INTO ksp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tɔku nje-poloje Lubba le mbɔnje naa ke tɔkuje le Jiipije ngaa dooje ta naa. Goe te a, dare nje ke ngemje ta buwa-yo le tɔku nare, ");
INSERT INTO ksp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ngaa n̂-paje darede na: «Ta e-paje na: ‹Kare ke n̂-nayn jaw n̂-tibbi bbay a, nje-njaje-go Jeju te le ddeeje til te ddee bbokoje niinne.› ");
INSERT INTO ksp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Bbo Pilate oo tare a, ja gere gusu ke ta pa ne kare n̂-ndiki te. A sese a kingaje tar ang.» ");
INSERT INTO ksp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nje-ngemje ta buwa-yo le taaje nare le ngaa, ddaje ddew kara baa ke ndu ke darede le. Tar neenn le nja horo Jiipije te ndereng bbokone. ");
INSERT INTO ksp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nje-njaje-go Jeju te ke naynje dɔku gire kara le awje Galile dɔ ddingiri te ke n̂-tɔjude le. ");
INSERT INTO ksp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Toke dooeje a, dɔsuje mekeji-gɔlde nangê. A mareje, aw maynje bbay. ");
INSERT INTO ksp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jeju ddee ngɔsi ke de ngaa pa arede na: «Lubba arem singa tɔyn dara ddem, nangê ddem. ");
INSERT INTO ksp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yeenn a, awje rɔ gel-dewje te tɔyn ke dɔ nange te. E-ddajede to nje-njaje-gom te, ngaa e-ddajede batem ke ri Bɔ, ri Ngonn, ke ri Ndil-me-nda. ");
INSERT INTO ksp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","E-tɔjujede are n̂-ddaje ne ddew nduje te tɔyn ke munn marese. Ooje, ma kee ke se ke ndɔ tɔyn ndereng ddutu ndɔ te.");
INSERT INTO ksp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kunn-kutu Tar ke maji ke dɔ Jeju-Kiriste, Ngonn le Lubba te a neenn. ");
INSERT INTO ksp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Lubba pa me maketuru te le Ejayi nje-kila mber-tar laa na: « Ema Lubba, ma kula mare nje-kula lem nɔi te, kare mɔse ddew lei. ");
INSERT INTO ksp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ndu dew le aw uru ekii me kɔr te na: ‹E-mɔseje ddew le Ebbe-dewje, Areje ddewje laa ndɔjuje njarara.› » ");
INSERT INTO ksp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yeenn a, Jan Batisi unda lo tee me kɔr te ngaa ila mber batem-turu me, kare Lubba ɔru ne tar majang dɔ dewje te. ");
INSERT INTO ksp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Dewje tɔyn ke dɔ nange Jude te, ke nje ke Jurusalam awje rɔe te. N̂-paje majang lede ke ddaka are Jan ddade batem me maann Jurden te. ");
INSERT INTO ksp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jan ula kubbu ke n̂-dda ke biin jambal, ngaa n̂-tɔ endaar bbere te. Ne-kusa laa to ebeteje, ke ubbu teje. ");
INSERT INTO ksp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","N̂-pa nare dewje na: « Dew ke aw ddee gom te ngeng utam. Mase ta ddom tutu kula ne-gɔl laa ang. ");
INSERT INTO ksp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ema m-ddase batem maann, a ne, na ddase batem Ndil-me-nda.» ");
INSERT INTO ksp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kare teenn, Jeju in Najarete nange te ke Galile ddee ngaa Jan ddae batem jurden te. ");
INSERT INTO ksp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","A kare te ke Jeju in me maann te le aw tee ke ddaka a, noo kem dara ke teyn, ngaa Ndil-me-nda aw ddisi ke dɔe te toke le derjeenn. ");
INSERT INTO ksp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ngaa mare ndu bbar me dara te na: « E-to ngonnum ke m-ndikii nya. Rɔm neelem nya wɔju dɔi. ");
INSERT INTO ksp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Njange baa goe te a, Ndil-me-nda aw ke Jeju le me kɔr te. ");
INSERT INTO ksp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","N̂-nayn me kɔr te le ndɔ dɔsɔ ngaa Satan nae. Nisi horo daje te ke mû ngaa anjije aw ddaje saa***. ");
INSERT INTO ksp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Go kila te ke dila Jan key-kula te a, Jeju aw Galile aw ila mber Tar ke maji le Lubba. ");
INSERT INTO ksp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","N̂-pa na: « Kare ke Lubba ɔju le ase ngaa. Bbe-kɔn le Lubba ddee ngɔsi ngaa. E-turuje ddew lese bbo ooje mese te ke Tar ke maji.» ");
INSERT INTO ksp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Toke Jeju aw nja go tɔku-ba te ke Galile a, noo nje ndɔn-maannje joo. To Simɔ de ke ngokɔen Andere ke daw dilaje ddenge daw ddaje ne ndɔn me tɔku-ba te le. ");
INSERT INTO ksp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jeju pa arede na: « Unnje gom a ma dda kare e-ddeeje to nje-ddaje ndɔn dewje.» ");
INSERT INTO ksp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Njange baa njaa dinyaje ddengeje lede a dunnje goe. ");
INSERT INTO ksp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Toke Jeju ngese ke kete ten be a, noo Jake de ke ngokɔen Jan ngann le Jebede me tɔku to te lede, daw n̂-mɔseje ddengeje lede. ");
INSERT INTO ksp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Njange baa njaa Jeju le bbarde. Dinyaje bɔdede Jebede ke nje-kulaje me tɔku to te le a dunnje go Jeju. ");
INSERT INTO ksp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jeju de ke nje-njaje goe te dawje bbe te ke Kaperenayum. Ndɔ-kuwa-rɔ a, nande me key-mbɔn naa te le Jiipije ngaa nunn kutu tɔju ne. ");
INSERT INTO ksp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Gusu ke naw n̂-tɔju ne ne le gange singa dewje ke aw ooje ne-tɔju laa le. Mba ne, naw n̂-tɔju ne toke le dew ke ee ke singa-kɔn-mbay, bbo n̂-tɔju ne le toke le engan nje-kɔruje gel Ndu ang. ");
INSERT INTO ksp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kare teenn njaa, me key-mbɔn naa te le, mare dingaw ke ee ke ndil ke maji ang ee teenn tɔ. Dingaw le uru ekii na: ");
INSERT INTO ksp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","« Jeju ke Najarete, ddi a e-ndiki ta dda ke je wa? E-ddee ta tɔlje wa? M-geri ke maje. E-to dew ke maji-tɔyn ke Lubba ulae. ");
INSERT INTO ksp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jeju ndange ndil ke maji ang le ngaa unn ndu are na: « Utu tai bbo e-tee me dingaw te neenn ke ddang.» ");
INSERT INTO ksp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ndil le yeke dingaw le ke singa ngaa unda ekii tee ne. ");
INSERT INTO ksp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tar nya dewje le tɔyn are n̂-dujuje naa ke yo ke ne na: « Ddi a be neenn wa? Ne-tɔju ke siki ke ee ke singa ann. Dingaw neenn unn ndu are ndilje ke maji ang njaa kara ooje tae wa?» ");
INSERT INTO ksp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yeenn ngaa ri Jeju aw bbar dɔ nange Galile te tɔyn. ");
INSERT INTO ksp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jeju in key-mbɔn naa te le Jiipije le tee, ngaa de ke Jake ke Jan dawje key le Simɔ de ke Andere. ");
INSERT INTO ksp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mum Simɔje ke dene to tuwa-rɔ-to te, mba nee ke rɔ-to rɔ-tunga. A kake Jeju tee be a, n̂-pa tare dare. ");
INSERT INTO ksp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jeju ddee ngɔsi saa, uwa jia ngaa are nin taar. A rɔe ke tunga le wul ngaa nunn kutu dda ne wɔju dɔde. ");
INSERT INTO ksp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Lo-kul te ke kare ande a, dewje otoje nje rɔ-toje tɔyn ke nje ke eeje ke ndilje ke maji ang ddeeje ke de ke rɔ Jeju te. ");
INSERT INTO ksp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Dewje tɔyn ke me tɔku bbe te le mbɔnje naa ta key te le. ");
INSERT INTO ksp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jeju ɔru rɔ-toje dang dang rɔ dewje te, ngaa n̂-tubba ndilje ke maji ang rɔ mareje te. A ninya ddew nare ndilje le kare paje tar ang mba ndilje le gereje ke maje. ");
INSERT INTO ksp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Lo-kare te ke endɔɔ ke lo nayn uja ang bbay a, Jeju in ngaa tee ddaka. Ni me tɔku-bbe te le naw nisi lo te ke iya rɔe, naw duju Lubba. ");
INSERT INTO ksp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simɔ de ke nje-mareje dawje ta sange. ");
INSERT INTO ksp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Toke dingaeje a, n̂-paje dareje na: « Dewje tɔyn aw sangije.» ");
INSERT INTO ksp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","A Jeju pa arede na: « Jawje lo te ke ddang, bbeje te ke mbɔrje te neenn. Maji kare mila mber-tar neenn nunn tɔ. Mba m-ddee wɔju dɔ yeenn. ");
INSERT INTO ksp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yeenn ngaa, n̂-nja nange Galile te tɔyn. Naw nila mber-tar me key-mbɔn naaje te le Jiipipe ke nange teenn ngaa n̂-tubba ndilje ke maji ang. ");
INSERT INTO ksp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mare nje-banji ddee rɔ Jeju te, ɔsu mekeji gɔle nɔe te, ngaa nɔ nɔ gɔle te na: « Toke e-ndiki a, ase ta dda kare m-ddee maji.» ");
INSERT INTO ksp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jeju le ooe a n̂-ddae ndoo ngaa ula jia ɔre ne a pa na: « M-ndiki te, e-ddee maji.» ");
INSERT INTO ksp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Njange baa njaa a, banji le goto rɔ dingaw te le are rɔe ddee maji. ");
INSERT INTO ksp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jeju le in ke dingaw le, ngaa njange baa goe te a tubbae, a pa are na: ");
INSERT INTO ksp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","« Oo ke maje, e-pa tar neenn are dew kara ang. A aw tɔju rɔi are nje-polo-Lubba tenni oo. Goe te a, are ne-polo ke Moyiji unn ndu mbae le ta tɔju dewje tɔyn to rɔi ddee maji.» ");
INSERT INTO ksp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Dingaw le ɔtu a, aw pa go neje ke ingae le loje te tɔyn. Mba yeenn a, Jeju ase ta tɔju ne rɔe me mare tɔku bbe te ang ngaa. Nisi sayn ke bbeje, loje te ke iyaje rɔde, ngaa dewje inje loje te dang dang ddeeje rɔe te. ");
INSERT INTO ksp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ndɔ ngaji goe te a, Jeju tel ddee Kaperenayum, a dewje ooje na nee key, ");
INSERT INTO ksp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Yeenn a, n̂-ddeeje toke banya, are ta key te le ddaka njaa kara lo goto. Jeju aw tɔjude tar le Lubba. ");
INSERT INTO ksp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Dingawje sɔ otoje mare dew ke debbe rɔe oy ddeeje saa. ");
INSERT INTO ksp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","A dingaje ddew ta kaw saa nɔ Jeju te ang mba dewje le bayanji nya. Yeenn a, dɔruje kem lo dɔ key te, er lo te ke Jeju ee te. Ngaa dulaje dew ke rɔe oy le ke tuwa laa baa ke kem lo dɔ Jeju te. ");
INSERT INTO ksp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Toke Jeju oo koo-me te le dewje le a, pa are dew ke debbe rɔe oy le na: « Ngonum, tar majangje lei ɔru dɔi te.» ");
INSERT INTO ksp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mare nje-kɔruje gel Ndu ke eeje teenn le aw ejeje mede te na: ");
INSERT INTO ksp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","« Dew neenn pa tar baann mba ddi wa? Naw n̂-taji Lubba wa?. Na bba a kase kɔru tar majang dɔ dew te wa? Lubba kara baa a ase.» ");
INSERT INTO ksp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Njange baa njaa Jeju gere tar ke daw dejeje ngaa pa arede na: « Eeje ke keje ke baann mba ddi wa? ");
INSERT INTO ksp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ta pa kare dew ke debbe rɔe oy le na: ‹ Tar majang lei ɔru dɔi te,› wase: ‹ In taar unn tuwa lei bbo e-nja,› ye ke dda ngeng ang ta pa wa? ");
INSERT INTO ksp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","A m-ndiki kare e-gereje to Ngonn le dew ee ke singa dɔ nange te neenn ta kɔru tar majang le dewje.» Yeenn a, n̂-pa nare dew ke debbe rɔe oy le na: ");
INSERT INTO ksp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","« M-pa mari, in taar, unn tuwa lei bbo aw bbê lei.» ");
INSERT INTO ksp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Njange baa njaa, dingaw le ubba nange in kem dewje te le tɔyn ngaa unn tuwa laa a ɔtu. Dede tɔyn njaa tar nyade, ngaa dɔsuje gaji Lubba n̂-paje na: « Joo mare ne ke be ndɔ kara ang.» ");
INSERT INTO ksp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jeju tel aw kar tɔku ba te ke Galile. Dewje ke banya ddeeje rɔe te are naw n̂-tɔjude ne. ");
INSERT INTO ksp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Toke naw n̂-nday a, noo Lebi ngonn le Alpe ke isi lo kuka lambo te. Jeju pa are na: « Unn gom.» Lebi le in taar bbo unn goe. ");
INSERT INTO ksp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Goe te a, Jeju aw usa ne key le Lebi le. A nje-taaje nare lambo toke banya ke nje-ne-ddaje ke maji ang isije ta ne-kusa te le ke Jeju de ke nje-njaje goe te. Dede nya njaa daw dunnje go Jeju le. ");
INSERT INTO ksp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nje-kɔruje gel Ndu ke eeje mbɔn naa te le Parijiyenje ooje a, Jeju aw usa ne ke dewjeenn le tɔyn. Yeenn a, n̂-paje dareje nje-njaje-go Jeju te le na: « Mba ddi bba naw nusa ne ke nje-taaje nare-lambo ke dewje ke nje-ddaje neje ke maji ang wa?» ");
INSERT INTO ksp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jeju oo tar ke daw n̂-paje le ngaa pa arede na: « Dewje ke rɔde to ke maje ndikije ta koo nje-kare kuma ang. Dewje ke rɔde tode bba. Dewje ke ooje rɔde to dewje ke gate gate a m-ddee ta bbarde ang. M-ddee mba dewje ke gereje to n̂-toje to nje ne-ddaje ke maji ang.» ");
INSERT INTO ksp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mare ndɔ, nje-njaje-go Jan-Batisi te, ke Parijiyenje daw dinyaje ne-kusa a, dewje aw dujuje Jeju na: « Mba ddi bba nje-njaje-go Jan-Batisi te ke nje-njaje-go Parijiyenje te aw inyaje ne-kusa a, nje-njaje goi te inyaje ne-kusa ang wa?» ");
INSERT INTO ksp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","A Jeju ilade te na: « Ejeje to dewje ke n̂-bbarde kusu taa naa te a kinyaje ne-kusa kare te ke nje-dene le isi ke de wa? Baann ang. Toke n̂-nayn ke de bbay a, daseje ta kinya ne-kusa ang. ");
INSERT INTO ksp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","A kare a ddee ke da kɔru nje-dene le horode te a, da kinya ne-kusa bbay. ");
INSERT INTO ksp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Dew a kunn ta-kubbu ke siki kila ne kem konn kubbu ang. Bbo n̂-dda toke baann a, ta-kubbu ke siki le a kɔru kem konn kubbu le kare tel bo uta ye ke kete bbay. ");
INSERT INTO ksp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ddem, dew a kungu ben ke siki me konn ku-endarje te ang. Bbo n̂-dda toke baann a, ben le a dda kare kuje le tirje, ngaa ben le kara a kula kɔrɔ ddem, ku-endaarje le kara a nayje ke kɔrɔ ddem. Kuje-endaarje ke siki a maji ta kungu ben ke siki me te.» ");
INSERT INTO ksp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mare ndɔ-kuwa-rɔ, Jeju aw nday me ndɔɔ beleje te. A Nje-njaje goe te unnje kutu tije jinga beleje le ke ddew ddew. ");
INSERT INTO ksp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Yeennn ngaa Parijiyenje paje are Jeju na: « Oo, mba ddi bba nje-njaje goi te aw ddaje ne ke ndu leje mbete kare dew dda ke ndɔ-kuwa-rɔ wa?» ");
INSERT INTO ksp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jeju ilade te na: « Ndɔ kara e-turaje Maketuru dɔ ne te ke Dabbiti dda ang wa? Ndɔ mare, bbo ddae, ne de ke nje ke unnje goe a dingaje ne ta kusa ang. ");
INSERT INTO ksp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","A nande me key te le Lubba dɔ ndɔ te ke Abiatar a to ne to tɔku nje-polo-Lubba. Nusa mapaje ke dare Lubba to ne-polo ngaa nare nje ke unnje goe le tɔ. A ndu are ddew kare nje-poloje Lubba a ta usaje mapajeenn le.» ");
INSERT INTO ksp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jeju pa arede bbay na: « N̂-dda ndɔ-kuwa-rɔ wɔju dɔ dew, bbo n̂-dda dew wɔju dɔ ndɔ kuwa-rɔ ang. ");
INSERT INTO ksp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mba yeenn a, nje ndɔ-kuwa-rɔ kara Ngonn le dew aw ɔn dɔe tɔ.» ");
INSERT INTO ksp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jeju tel aw key-mbɔn naa te le Jiipije. A mare dingaw ke jia oy ee key-mbɔ-naa te le. ");
INSERT INTO ksp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","A Parijiyenje ke eeje teenn aw aaeje ta koo se na kɔru rɔ-to rɔ dingaw te le ke ndɔ-kuwa-rɔ wa? Mba n̂-ndikije ta kunda tar dɔe te. ");
INSERT INTO ksp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jeju pa are dingaw ke jia oy le na: « In taar kem dewje te neenn tɔyn.» ");
INSERT INTO ksp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Goe te a, n̂-duju dewje le na: « Ndu are ddew ta dda maji ke ndɔ-kuwa-rɔ wase ta dda maji ang wa? Ta kaji dew wase ta kinyae kare noy wa?» A dewje le ndikije ta kilae tar te le ang. ");
INSERT INTO ksp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jeju aade tɔyn ke ungu. Rɔe neele ang mba dewje are mede ketere. Yeenn ngaa n̂-pa nare dingaw le na: « E-ndɔju jii.» Dingaw le ndɔju jia ngaa jia le ddee maji. ");
INSERT INTO ksp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Parijiyenje le inje key-mbɔn naa te le teeje be a, uwaje dɔ naa ke dewje ke me mbɔn-naa te le Erode ta koo ddew ke ta tɔl ne Jeju. ");
INSERT INTO ksp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jeju de ke nje-njaje goe te ɔruje rɔde awje kar ba te ke Galile a, dewje ke banya banya ɔruje goe. Dewje le inje Galile, ke Jude, ");
INSERT INTO ksp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jurusalam, ke nange te ke Idume. Dinje nange te ke tura Jurden te ke bbeje te ke toje mbɔr Tir te ke Sidɔn tɔ. N̂-ddeeje toke banya rɔ Jeju te mba dooje tar neje tɔyn ke Jeju aw dda. ");
INSERT INTO ksp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yeenn a, Jeju duju nje-njaje goe te kare dundaje mare tɔku to ngɔsi dareje, mba kare dewje ke banya le ubbaeje ang. ");
INSERT INTO ksp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mba, Jeju aw ɔru rɔ-to rɔ dewje te nya are, dewje tɔyn ke rɔde tode aw awje ke dɔe te dɔete ta kɔre ke jide. ");
INSERT INTO ksp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Toke nje ke ndilje ke maji ang aw ddade ooeje a, n̂-teeje dosoje nangê nɔ-gɔle te ngaa duruje ekii na: « E-to ngonn le Lubba.» ");
INSERT INTO ksp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","A Jeju ndɔru mbide nya kare n̂-paje tare dare dewje ang. ");
INSERT INTO ksp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Goe te a, Jeju al mare ddingiri ngaa, bbar dewje ke mee ndikide are dawje rɔe te. ");
INSERT INTO ksp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","N̂-mbere mareje dɔku gire joo kare n̂-naynje saa ddem, kare nulade nare daw dilaje mber Tar ke maji ddem. ");
INSERT INTO ksp_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Narede singa ke ta tubba ne ndilje ke maji ang. ");
INSERT INTO ksp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Dewje ke dɔku gire joo ke n̂-mberede le to: Simɔ ke Jeju unda ria na Piyar, ");
INSERT INTO ksp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jake de ke ngɔkɔen Jan ke toje to ngann le Jebede. Jeju unda ride na Boanerejese, gele na: « Dingawje ke toje toke le ndi ke ndange.» ");
INSERT INTO ksp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andere ke Pilipi, Batalami ke Matiye, Toma ke Jake ngonn le Alpe, Tade ke Simɔ ke daw n̂-bbare to « Dew ke ndiki bbe laa nya», ");
INSERT INTO ksp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ke Judase Isikariyote nje kunn dɔ Jeju. ");
INSERT INTO ksp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jeju tel key ngaa goe te a, dewje banya banya tel mbɔnje naa are, ne-kusa njaa kara ne de ke nje-njaje goe te dingaje ddew ta kusa ang. ");
INSERT INTO ksp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nje-nujuje laa ooje tare, ngaa ddeeje ta kuwae kaw saa mba n̂-paje na: « Dɔ Jeju turu.» ");
INSERT INTO ksp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nje-kɔruje gel Ndu ke inje Jurusalam paje na:« Belejebulisi mee te.» N̂-paje bbay na: « Mbay le ndilje ke maji ang le a are singa ta tubba ne ndilje ke maji ang le.» ");
INSERT INTO ksp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yeenn ngaa, Jeju bbarde, ngaa unn mare ne-kɔju mare pa ne tar arede na: « Satan a kase tubba Satan toke baann wa? ");
INSERT INTO ksp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Toke dewje ke me bbe-kɔn te ke kara baa aw tinje naa a, bbe-kɔn le a kase nayn ang. ");
INSERT INTO ksp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ngaa bbo toke dewje ke me nuju te ke kara baa tinje naa a, nuju le a kase nayn ang. ");
INSERT INTO ksp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","A toke Satan dda ddɔ ke rɔe njaa, a bbo n̂-kayn rɔe danna joo a, na kase nayn ang, laa a goto ngaa.» ");
INSERT INTO ksp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","« Dew a kase kande me key te le nje-singa ta koto ne-kingaje laa njaa baann ang. Maji kare nuwae n̂-tɔe bba. A toke n̂-tɔ nje-singa le a, na kase ta taa neje tɔyn ke toje me key te laa. ");
INSERT INTO ksp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Tɔkɔrɔ njaa m-pa marese: Lubba a kɔru tar majangje, ke tar ne-tajije tɔyn ke dewje tajeje dɔde te. ");
INSERT INTO ksp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","A dew ke taji Ndil-me-nda, tar a kɔru dɔe te ndɔ kara ang. Mba tar majang ke ke ndɔ ke ndɔ to dɔe te mban.» ");
INSERT INTO ksp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jeju pa tar ke de toke baann mba n̂-paje na: « Ndil ke maji ang isi mee te.» ");
INSERT INTO ksp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Goe te a, kɔn Jejuje, ke ngakɔn Jejuje n̂-ddeeje darje ddaka ngaa dulaje dew kare bbare. ");
INSERT INTO ksp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Dewje toke banya isije mbɔr Jeju te le ngaa, n̂-pa dare na: « Oo, kɔinje, ke ngakɔinje ke dingaw ke nje ke dene deeje ddaka, ngaa n̂-dujije.» ");
INSERT INTO ksp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jeju ilate na: « Na a to kɔmje ngaa, nje ke dda bba toje to ngakɔmje wa? ");
INSERT INTO ksp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Goe te a, naa dewje ke isije gukueje le ngaa n̂-pa na: « Ooje, kɔmje ke ngakɔmje a isije neenn.» ");
INSERT INTO ksp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mba dew ke dda ne ke me Lubba ndiki a to ngokɔm, to kɔnanem, ngaa to kɔmje.» ");
INSERT INTO ksp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jeju tel aw tɔju ne kar tɔku ba te ke Galile a, dewje ke banya mbɔnje naa rɔe te. Yeenn a, naal mare tɔku to nisi me te. Tɔku to le to dɔ maann te, a dewje le arje taa maann te le ngɔsi. ");
INSERT INTO ksp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","N̂-tɔjude neje nya ddew gusu-tar te. N̂-pa me ne-tɔju te laa le na: ");
INSERT INTO ksp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","« Ooje, mare ndɔ, mare dew aw ndɔɔ ta dubbu ne. ");
INSERT INTO ksp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","A toke naw n̂-dubbu ne le a, mare kande ne le gayn dɔr ddew te. A eelje ddeeje ngaa ɔnje. ");
INSERT INTO ksp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mare kande neje le gaynje lo te ke to er ke nange ndeer te ang. Kande neje le teeje njange baa mba nange ke ke te ndeer ang. ");
INSERT INTO ksp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","A toke kare ɔsu nya a, puru kare le ɔn koje ke teeje le. N̂-tutuje mba ngirade ande nangê ke maje ang. ");
INSERT INTO ksp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mare kande koje le gaynje me konnje te. Konnje le ngalje ngaa taa dɔde are dandeje kande ang. ");
INSERT INTO ksp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","A mare kande koje le gaynje dɔ nange te ke maji. N̂-teeje, n̂-nduje ngaa dandeje. Mareje andeje dɔmuta, mareje dɔmisan, mareje dɔdɔku.» ");
INSERT INTO ksp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ngaa n̂-pa na: « Dew ke mbia to ta koo ne tar a, oo.» ");
INSERT INTO ksp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Toke Jeju aw ddew ew ke dewje ke banya a, nje-kayn-kulaje ke dɔku gire joo ke dewje ke aw njaje saa le dujeje tar ɔju dɔ gusu-tarje ke naw n̂-tɔju ne ne le. ");
INSERT INTO ksp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nilade te na: « Sese Lubba are e-gereje tar Bbe-kɔn laa ke to tar ke iya rɔe. A kese dewje, gusu-tar a daw pa ne tare darede. ");
INSERT INTO ksp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Baann bba, ‹Da kaaje lo ke maje, a da kooje ne ang ddem, da kooje tar ke mbide ke maje, a da gere kande ang. Baann ang a, da telje rɔ Lubba te kare ɔru tar dɔde te.› » ");
INSERT INTO ksp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Goe te a, Jeju dujude na : « E-gereje gel gusu-tar neenn ang wa? Yeenn a, a gereje kande kese gusu-tarje tɔyn toke baann wa? ");
INSERT INTO ksp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Dew ke aw dubbu kande koo le to ddew kara baa ke dew ke aw ila mber tar le Lubba. ");
INSERT INTO ksp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mare dewje toje toke le mbɔr ddew ke tar le Lubba le oso ke te. Kake dooje Tar le be a, Satan ddee ngaa ɔru tar ke n̂-dubbu le mede te ke ddang. ");
INSERT INTO ksp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mareje toje toke le loje ke to er. Dooje tar le a, n̂-taaje tar le njange baa ke rɔ-neel. ");
INSERT INTO ksp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","A dinyaje tar le dare ngirae uwa nange mede te ang. N̂-naynje ddewe te ang. Toke ne-wungu wase ne-singa ddee ingade wɔju dɔ tar le a, n̂-tusuje dinyaje njange baa. ");
INSERT INTO ksp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mareje taaje tar le toke le ko ke oso horo konnje te. Dooje tar le, ");
INSERT INTO ksp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","a keje tar wɔju dɔ neje te ke nangê neenn, kem-nda ne-kingaje ke bbo neje dang dang ke aw ere dew andeje mede te ngaa, taa dɔ tar le are ande ang. ");
INSERT INTO ksp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","A mareje taaje tar le ddew kara baa toke ko ke oso nange te ke maji. Dooje tar le, n̂-taaje tar le ngaa tar le ande. Mareje andeje dɔmuta, mareje dɔmisan, mareje dɔdɔku.» ");
INSERT INTO ksp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Goe te a, Jeju pa arede na: « Dew a kila puru lambe te kaw kunda me jo te wase kɔy tira te wa? Na kunda dɔ mare ne te taar ang wa? ");
INSERT INTO ksp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ne tɔyn ke to lo-kiyae te a tee ke ddaka kem dewje te. Ngaa ne tɔyn ke n̂-kusu dɔe a tee kem dewje te. ");
INSERT INTO ksp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Dew ke mbia to ta koo ne tar a oo.» ");
INSERT INTO ksp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jeju pa arede bbay na: « Ooje tar neenn ke maje. Ne ke unnje wɔjuje ne ne areje dew, Lubba a kunn kɔju ne ne karese tɔ. Na kila mare dɔe te karese. ");
INSERT INTO ksp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mba dew ke ee ke ne, a kare mare dɔe te. A dew ke ee ke ne ang, ne ke ten baa kara da kɔru jia te.» ");
INSERT INTO ksp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jeju pa bbay na: « Bbe-kɔn le Lubba to ddew kara baa toke dew ke dubbu ko me ndɔɔ te laa. ");
INSERT INTO ksp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Goe te a, le n̂-tibbi wase n̂-tibbi ang til ke kare njaa kara ko le aw tee ngaa ndu. A ne nje ndɔ le n̂-gere gusu ke ko le aw tee ne ang. ");
INSERT INTO ksp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nange njaa dda are ko le tee. Dɔngɔre, ko le tee, goe te a dɔe tee ngaa bba kande tee dɔe te. ");
INSERT INTO ksp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Toke kande ko le sange ke maje a, nje-ndɔɔ le unn kutu tuka mba kare kujae ase ngaa.» ");
INSERT INTO ksp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jeju tel pa na: « Ddi bba ja kunn kɔju ne Bbe-kɔn le Lubba wa? Gusu-tar ke baann bba ja kunn ta pa ne tare wa? ");
INSERT INTO ksp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Bbe-kɔn le Lubba to ddew kara baa toke le kande kake ke ria na mutarde. Kare dubbue a, to kande ko ke to ten baa uta kese kande koje tɔyn ke dɔ nange te. ");
INSERT INTO ksp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Toke n̂-dubbe a, n̂-tee n̂-ngal nuta kese koje tɔyn ke me ndɔɔ te. Barkemeje ngalje to bbeel are eelje kara aseje ta dda key lede baenje te.» ");
INSERT INTO ksp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jeju aw tɔju ne ddew gusu-tarje te nya toke baann. Naw n̂-tɔju ne le ke gusu ke ta kare n̂-gereje kande. ");
INSERT INTO ksp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Gusu-tar dɔrɔ a n̂-pa ne tar narede. A toke ne de ke nje-njaje goe te disije ke karede baa a, nɔru gel neje tɔyn narede. ");
INSERT INTO ksp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lo-kul a, Jeju pa are nje-njaje goe te na: « Jawje tura tɔku ba te.» ");
INSERT INTO ksp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yeenn ngaa dɔtuje dinyaje dewje ke banya le. Nje-njaje-go Jeju te le unneje ke tɔku to ke nisi me te le awje saa. Mare tɔku toje eeje ngɔsi saa tɔ. ");
INSERT INTO ksp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","A ta koo a, mare bamburanbo in aw ula ke singa are maann le aw lenge ngaa ungu me to te le, nayn sen baa kare ddusu. ");
INSERT INTO ksp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","A Jeju to aw tibbi kutu tɔku to te le. N̂-gete dɔe ke ne-gete-dɔ. Yeenn ngaa nje-njaje goe te uruje ekii ndoleje na: « Nje-ne-tɔju, koy ke ja ta koy neenn oo to ne ang wa?» ");
INSERT INTO ksp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Toke Jeju ndol a, n̂-ndange bamburanbo le ngaa pa are maann le na:« E-to ddekeke, ew rɔi!» Yeenn ngaa bamburanbo le ew rɔe ngaa lo ddee to yenene. ");
INSERT INTO ksp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Goe te a Jeju pa are nje-njaje goe te na: « Bbeel ddase be mba ddi wa? Koo me te lese goto bbay wa?» ");
INSERT INTO ksp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","A Bbeel ddade nya are n̂-dujuje na, na: « Dew neenn to dew ddi bba lel ke maann kara aw ooje tae wa?» ");
INSERT INTO ksp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jeju de ke nje-njaje goe te n̂-teeje tura tɔku ba te ke Galile nange te le dewje ke Gadara. ");
INSERT INTO ksp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","A toke Jeju in me tɔku to te le uru nangê a, njange baa njaa mare dingaw ke ee ke ndilje ke maji ang in dɔbareje te tee ngaa tila keme. ");
INSERT INTO ksp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Naw n̂-to dɔbareje te le are kula njamji njaa kara dew ke a kase ta tɔe ne ang. ");
INSERT INTO ksp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mba ke ndɔ tɔyn njaa bbo n̂-tɔe ke kula njamji ngaa dilae poro a, n̂-ti kula le ngaa n̂-tete ande nare ke dilae ne poro le. Dew ke ee ke singa ta kuwae kore nange kare n̂-to ddekeke goto. ");
INSERT INTO ksp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Til ke kare naw nja dɔbareje te ke dɔ ddingirije te ngaa naw nuru ekii ddem naw njare rɔe ke erje nare are do. ");
INSERT INTO ksp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Toke noo Jeju ddew ew a, nayn naw nɔsu mekeje gɔle nangê nɔe te. ");
INSERT INTO ksp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Nuru ekii ke taar na: « Jeju Ngonn le Lubba ke isi ddutu dara te nu. Ddi a e-ndiki rɔm te wa? Muwa gɔli ke ri Lubba, ula kem ndoo ang.» ");
INSERT INTO ksp_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","N̂-pa tar baann mba pa ke Jeju pa are na: « Ndil ke maji ang, e-tee me dingaw te neenn ke ddang.» ");
INSERT INTO ksp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jeju duje na: « Rii na na wa?» Nilae te na: « Rim na banya banya» mba, n-bayan nya. ");
INSERT INTO ksp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ngaa n̂-dda rɔe to ndoo nɔ-gɔl Jeju te nya kare tubbade nange teenn ke ddang ang. ");
INSERT INTO ksp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kusu bereje aw usaje ne ngɔsi ke ddingirije le. ");
INSERT INTO ksp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","A ndilje ke maji ang le uwaje gɔl Jeju na: « Ulaje me bereje te tonn, are jande mede te.» ");
INSERT INTO ksp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jeju ndiki te ke de are n̂-teeje me dingaw te le ngaa dandeje me bereje te le. Bereje le tɔyn kɔrde aw ngɔsi ke doro joo. Dinje kare ddingirije te le ke ngɔru ngaa n̂-gayje me tɔku ba te le doyje. ");
INSERT INTO ksp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nje ngemje bereje le aynje aw paje tare me tɔku bbe te le ddem, ngann bbeje te ddem ngaa dewje ddeeje ta koo ne ke tee le. ");
INSERT INTO ksp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Toke n̂-teeje rɔ Jeju te a, dooje dingaw ke ndilje ke maji ang banya banya isije mee te le. Nisi nangê. Nula kubbu rɔe ngaa keje laa tel ddee ke maje. Dede tɔyn bbeel ddade. ");
INSERT INTO ksp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Dede ke dooje neenn le dɔruje gel ne ke inga dingaw le, ke ne ke inga bereje le dare dewje le. ");
INSERT INTO ksp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Yeenn ngaa n̂-nɔnje nɔ-gɔl Jeju te kare ɔtu nange te lede ke ddang. ");
INSERT INTO ksp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kare ke Jeju aw aal tɔku to a, dingaw ke n̂-tubba ndilje ke maji ang mee te le dda rɔe to ndoo nɔ-gɔle te na:« M-ndiki ta nayn sei.» ");
INSERT INTO ksp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jeju ndiki te ang, a pa are na :« E-tel key lei, horo nujuje te lei, ta ɔru gel ne ke Ebbe-dewje dda sei ddew me maji te laa le arede.» ");
INSERT INTO ksp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Dingaw le aw ngaa pa tar neje tɔyn ke Jeju dda saa le nange te ke tɔku bbeje ke doku eeje te. Dewje tɔyn ke ooje tar le, tar le gange singade. ");
INSERT INTO ksp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Toke Jeju unn tɔku to tura maann te le teel a, dewje ke banya ddee mbɔnje naa rɔe te ta ba te. ");
INSERT INTO ksp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mare nje kɔn dɔ key-mbɔn naa le Jiipije ddee tee. Toke noo Jeju a, n̂-tee noso nɔ gɔle te ngaa, ");
INSERT INTO ksp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","n̂-nɔ nɔ-gɔle te n̂-pa na: « Ngunnum ke dene a ta koy. E-ddee ila jii dɔe te are naji, ta nisi kem baa.» ");
INSERT INTO ksp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jeju ɔtu aw saa. Dewje ke banya ɔruje goe ngaa aw ubbaeje ke yo ke ne. ");
INSERT INTO ksp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mare dene ee horo dewje teenn le. Mese aw ddee rɔe te ase bbal dɔku gire joo. ");
INSERT INTO ksp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Noo ndoo nya ji nje-kareje kuma te. Nare laa nunga tɔyn mbae. A ninga ne ke maji kara goe te ang. Rɔ-to le aw aw ke kete kete. ");
INSERT INTO ksp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Dene le oo tam Jeju. Yeenn a, n̂-ddee nande horo dewje te le er giri Jeju te ngaa nɔru kubbu laa ke jia. ");
INSERT INTO ksp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Mba n̂-pa mee te na: « Bbo ta kubbu laa baa njaa bba mɔru kara rɔm a ddee maji. ");
INSERT INTO ksp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kare teenn njaa, mese ke aw ddee rɔe te le gange ngaa n̂-gere to rɔ-to le ne le nunga. ");
INSERT INTO ksp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Njange baa njaa, Jeju gere to mare singa in rɔ ne te tee. N̂-turu rɔe dann dewje te le ngaa n̂-duju na: « Na ɔru kubbu lem wa?» ");
INSERT INTO ksp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nje-njaje-goe te ilaeje te na: « Oo dewje ke banya ke aw ubbaije ke yo ke ne neenn ke maje a, e-tel e-duju se na ɔru kubbu lei wa, toke baann wa?» ");
INSERT INTO ksp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","A Jeju aw ila keme ta koo dew ke dda neenn le. ");
INSERT INTO ksp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Dene le gere ne ke ingae le are bbeel ngaa aw isa. Yeenn ngaa n̂-ddee noso nɔ gɔl Jeju te le ngaa, n̂-pa tar ke tɔkɔrɔ nare. ");
INSERT INTO ksp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jeju pa are na: « Ngunnum, koo-me te lei ajii. Aw ke me-wul lɔm ke rɔ ke maji.» ");
INSERT INTO ksp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kare ke n̂-nayn naw n̂-pa tar bbay a, mare dewje inje key le Jayirusu le ddee paje areje na: « Ngonni le oy mban, a aw jɔku nje-ne-tɔju le bbay mba ddi wa?» ");
INSERT INTO ksp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jeju aa lo ke tar te lede le ang, ngaa pa are Jayirusu na: « Are bbeel ddai ang. Ka njaa oo mei te a, bbaye.» ");
INSERT INTO ksp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Piyar, ke Jake de ke ngokɔen Jan a nare daneje a bbaye, bbo mare dew dang ang. ");
INSERT INTO ksp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Toke n̂-teeje key le Jayirusu le a, Jeju oo dewje ke aw ddaje rɔde, aw nɔnje ngaa aw ndingaje ne rɔde nya nya. ");
INSERT INTO ksp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nande key ngaa n̂-pa narede na: « Aw ddaje rɔse ngaa aw nɔnje mba ddi wa? Ngonn le oy ang, ka a naw n̂-tibbi.» ");
INSERT INTO ksp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","A dewje le kokeje. Yeenn ngaa, nare dewje tɔyn teeje ddaka, a bɔ ngonnje le, ke kɔn ngonnje le, ke dewje ke danneje a nare dandeje saa lo te ke dila ngonn le ke te. ");
INSERT INTO ksp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nuwa ji ngonn le ngaa n̂-pa nare na: « Talita kum.» Kande tar le na: « Ngonn ke dene, m-pa mari, in taar.» ");
INSERT INTO ksp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Njange baa njaa a, ngonn ke dene le in taar aw nja. Nee ke bbal dɔku gire joo. Ne le dum dɔ dewje tɔyn ke eeje lo teenn le. ");
INSERT INTO ksp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","A Jeju ndɔru mbide nya kare n̂-paje tare dare dew oo ang. Goe te a, n̂-pa narede na: « Areje ne nusa.» ");
INSERT INTO ksp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jeju ɔtu lo teenn ngaa tel bbe te ke nisi te, ke to Najarete. Nje-njaje goe te danneje. ");
INSERT INTO ksp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ndɔ-kuwa-rɔ a, Jeju aw tɔju ne dewje me key-mbɔn naa te le Jiipije. Ne-tɔje laa le gange singa dewje ke banya ke aw ooje ne-tɔju laa le, ngaa paje na: « Ninga neje neenn tɔyn dda wa? Na are kem-kare, ke singa ta dda ne ne-mɔrije ke be wa? ");
INSERT INTO ksp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nje-dda kake le ann ang wa? N̂-to ngonn le Mari ang wa? Ngakɔenje a to Jake, ke Jojese, ke ngokɔn Jude de ke Simɔ ang wa? Ngakɔnane isije a isije ke je neenn ang wa?» Neenn dda are n̂-mbeteje ta koo mede te saa. ");
INSERT INTO ksp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yeenn ngaa, Jeju pa arede na: « Dewje aw walje nje-kila mber-tar le Lubba kese loje te tɔyn, bbo bbe te ke nisi te, horo nujuje laa, wase me key te laa ang.» ");
INSERT INTO ksp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jeju ase ta dda ne-mɔri kara lo teenn ang. Bbaye njaa to mare nje-rɔ-toje ke nila jia dɔde te nare rɔ-to lede nunga. ");
INSERT INTO ksp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","A tar nya Jeju wɔju dɔ koo ke dooje mede te ang le. Goe te a, Jeju nja me ngann bbeje te tɔyn ke mbɔr Najarete te mba tɔju ne. ");
INSERT INTO ksp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jeju bbar nje-kayn-kulaje laa ke dɔku gire joo le. Nulade joo joo. Narede singa ta tubba ne ndilje ke maji ang. ");
INSERT INTO ksp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nunn ndu narede na: « Unnje ne kara mba kaw lese ang. Unnje mapa ang ddem, bbɔl ang ddem, unnje nare ilaje me bbɔl te ke bberse te ang ddem. Kake a ta uwaje jise te. ");
INSERT INTO ksp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ulaje ne-gɔlje lese. A awje ke kubbuje ke taar joo ang.» ");
INSERT INTO ksp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jeju pa arede bbay na: « Toke e-teeje mare lo te, a bbo n̂-taase ke key a, e-naynje ke teenn ndereng ndɔ ke a kɔtuje ne. ");
INSERT INTO ksp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Toke dewje ke mare bbe te ndikije ta taase ke key ang, ngaa dooje tar lese ang, a bbo a ta kɔtuje lo teenn a, e-tundaje bum nange ke gɔlse te. Nayn to naji lese a ɔruje.» ");
INSERT INTO ksp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nje-njaje-go Jeju te le awje ngaa ilaje mber kare dewje turuje mede. ");
INSERT INTO ksp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","N̂-tubbaje ndilje ke maji ang banya banya, dilaje ubbu dɔ nje-rɔ-toje te dare rɔ-toje lede nunga. ");
INSERT INTO ksp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tɔku-mbay Erode oo tar le Jeju mba ria bbar ke lo tɔyn. Mare dewje paje na: « Jan-Batisi a in horo dewje te ke oy tee! Mba yeenn a, nee ke singa ta dda ne ne-mɔrije.» ");
INSERT INTO ksp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mareje paje na: « To Eli.» A mareje paje na : « To mare Nje-kila mber-tar le Lubba toke nje-kilaje mber-tar le Lubba ke lew ann.» ");
INSERT INTO ksp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Erode oo tarje le baann a, pa na: « Jan ke mare n̂-gange dɔe le a in horo dewje te ke oy tee.» ");
INSERT INTO ksp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Dɔ ndɔe teenn, Erode Antipase taa Erodiade dene le ngokɔen Pilipi. Yeenn a Jan-Batisi pa are Erode le na: « Ee ke ddew ta taa dene le ngokɔin ang.» Mba yeenn a, Erode unn ndu kare duwa Jan n̂-tɔe ngaa dilae key-kula te. ");
INSERT INTO ksp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Erodiyade mbete Jan ke me kara ngaa ndiki kare n̂-tɔl Jan le a, ninga ddew ang, ");
INSERT INTO ksp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","mba Erode aw bbel Jan le nya. N̂-gere to Jan to dew ke to gate gate ddem, dew ke Lubba undae dang ddem, are naw ngeme ke maje. Toke noo tar ke Jan aw pa a, n̂-gere ne ke na dda ang. A dɔ ye teenn kara, n̂-ndiki nya ta koo tarje laa. ");
INSERT INTO ksp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","A mare ndɔ, ddew ɔru are Erodiyade. To ndɔ ke Erode inga mare bbal kara dɔ mare te, are n̂-dda kusu n̂-bbar ne tɔku-dewje ke aw ddaje saa kula, tɔku mbambaje laa, ke tɔku dewje ke Galile. ");
INSERT INTO ksp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ngonn le Erodiyade ke dene ande me key te le ngaa unn kutu la. A la laa le neel Erode de ke nje ke n̂-bbarde le nya. Yeenn ngaa Erode le pa are ngonn ke dene le na: « E-dujum ne ke mei ndiki a, ma kari.» ");
INSERT INTO ksp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nunda yo nare na : « Ne tɔyn ke e-dujum a ma kari. Le to debbe bbe-kɔn lem njaa bba e-duju kara ma kari.» ");
INSERT INTO ksp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ngonn ke dene le tee aw inga kɔenje ngaa dujue na: « Ddi a ta m-duju wa?» Kɔenje ilae te na: « E-duju dɔ Jan-Batisi.» ");
INSERT INTO ksp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ngonn ke dene le tel ke ngɔru aw inga tɔku-mbay le ngaa pa are na: « M-ndiki kare arem dɔ Jan-Batisi me tɔku pambala sambe te bbasine neenn njaa.» ");
INSERT INTO ksp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Rɔ tɔku mbay le neele ang njaa nyɔm. A wɔju dɔ yo ke nunda nɔ dewje te ke n̂-bbarde le, nase ta mbete ang. ");
INSERT INTO ksp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Yeenn ngaa, njange baa njaa nunn ndu nare mare mbamba laa kara kare ddee ke dɔ Jan-Batisi le are. ");
INSERT INTO ksp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mbamba le aw key-kula te ngaa gange dɔ Jan-Batisi le. Nila dɔe le me pambala sambe te, ngaa n̂-ddee ne nare ngonn ke dene le are ngonn ke dene le are kɔenje. ");
INSERT INTO ksp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Toke nje-njaje-go Jan te le ooje tare a, daw dunn ninne n̂-dubbuje. ");
INSERT INTO ksp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nje-kayn-kulaje telje rɔ Jeju te ngaa paje go neje tɔyn ke n̂-ddaje, ke neje ke n̂-tɔjuje dewje dareje. ");
INSERT INTO ksp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Dewje banya aw ddeeje a mareje aw telje are ne-kusa kara Jeju de ke nje-kayn-kulaje laa le dingaje ddew ta kusa ang. Yeenn a Jeju pa arede na: « Sese, e-ddeeje awje sem lo te ke dewje goto ke te are uwaje rɔse sen.» ");
INSERT INTO ksp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Dunnje tɔku to ngaa dɔruje rɔde dawje ke lo te ke dewje goto te. ");
INSERT INTO ksp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","A dewje nya oode kaw de te ngaa gɔɔnjede gerede. Yeenn a, dinje tɔku bbeje te dang dang tɔyn ngaa daynje daw n̂-teeje lo teenn le kete dare Jeju de ke nje-kayn-kulaje. ");
INSERT INTO ksp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jeju in me tɔku to te le uru nangê a, oo dewje ke banya le ngaa, noo kem to ndoo lede mba n̂-toje ddew kara baa toke bateje ke nje-ngemde goto. Yeenn ngaa, nunn kutu tɔjude neje nya nya. ");
INSERT INTO ksp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kare nday nya, ngaa nje-njaje go Jeju te le awje rɔe te ngaa paje areje na: « Lo neenn to me mu baa, ngaa lo kara aw ndul ngaa. ");
INSERT INTO ksp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","E-tubba dewje neenn are dawje dɔ-ndɔɔje te, ke me ngann bbeje te ke to ngɔsi neenn are daw n̂-ndokoje ne dusaje.» ");
INSERT INTO ksp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","A Jeju ilade te na: « Sese njaa arejede ne are dusa.» Nje-kayn-kulaje le dujeje na: « Ta jaw ndoko mapa ke kande nare kɔr joo bba ta karede dusa wa?» ");
INSERT INTO ksp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jeju dujude na: « Eeje ke mapa baann wa? Aw ooje.» Daw doo ngaa, n̂-paje dare na: « Jee ke mapa mi ke kanjije joo.» ");
INSERT INTO ksp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yeenn ngaa Jeju unn ndu arede kare dare dewje le tɔyn uwaje dɔ naa ke loe loe ngaa isije dɔ muje te ke tebbe. ");
INSERT INTO ksp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Dewje le isi nangê ke kulae kulae dɔdɔku dɔdɔku, a mareje dɔmi dɔmi. ");
INSERT INTO ksp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jeju jin mapa ke mi ke kanji ke joo le ngaa, unn keme ke taar, a are wooyo Lubba. N̂-tete mapa le ngaa nare nje-nje-njaje goe te kare n̂-kaynje dewje ke banya le. Jeju kayn kanjije ke joo le dewje le tɔyn tɔ. ");
INSERT INTO ksp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Dewje le tɔyn usaje are mede ndann. ");
INSERT INTO ksp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nje-njaje go Jeju te le mbɔnje kese ke nayn ddusu ngann kare dɔku gire joo. ");
INSERT INTO ksp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Horo dewje te tɔyn ke usaje ne le dingawje eeje doro mi. ");
INSERT INTO ksp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Njange baa goe te a, Jeju ndase nje-njaje goe te kare aal tɔku to ta kaw nginae tura tɔku ba te er Betesayida. A ne, n̂-nayn ta tubba dewje ke banya le kare n̂-telje. ");
INSERT INTO ksp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Goe te a, naw dɔ mare ddingiri te ta duju Lubba. ");
INSERT INTO ksp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Lo-kul a, tɔku to le tee dann maann te ngaa, a Jeju nayn ke kare baa nangê. ");
INSERT INTO ksp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Noo a, nje-njaje goe te le aw ddaje singa nya bba aw lelje tɔku to le mba yel ula aw tila kemde. Kare te ke lo mɔngu yenene a, Jeju le nja dɔ maann te aw ke rɔde te ngaa a ta ndayde. ");
INSERT INTO ksp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Toke dooeje naw nja dɔ maann te le a, dejeje to uma ann. Yeenn a, duruje ekii. ");
INSERT INTO ksp_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Mba dede tɔyn njaa daw doeje are bbeel uta dɔde. A, njange baa njaa n̂-pa ke de tar na: « Areje wurse oso nangê, e-bbeelje ang, ema ann. ");
INSERT INTO ksp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Naal tɔku to le nisi mbɔrde te a, yel le ew rɔe. Tar nya nje-njaje go Jeju te le. ");
INSERT INTO ksp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Mba ne-mɔri ke Jeju dda ddew mapa te ke n̂-kayn dewje le tɔjude mare ne kara ang bbay. Mede nayn aw ketere. ");
INSERT INTO ksp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jeju de ke nje-njaje goe te n̂-gangeje ba le ngaa, n̂-teeje nange te ke Jenejarete ngaa duruje nange. ");
INSERT INTO ksp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kake duruje nangê be a, dewje ooje Jeju ngaa gereje. ");
INSERT INTO ksp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Yeenn a, dewje awje ke ngɔru dɔ nange te le tɔyn ngaa, lo ke doo na Jeju le ee ke te a, daw ke nje-rɔ-toje ke te dareje ke tuwaje lede baa baa. ");
INSERT INTO ksp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Lo tɔyn ke Jeju aw ke te, tɔku bbeje te wase ngann bbeje te, ke dɔ-ndɔɔje te kara, dewje ddeeje ke nje-rɔ-toje nata, ngaa waleje na: « Inyade are ta-kubbu lei baa kara dɔruje ke jide.» Yeenn ngaa dede ke dɔreje ta-kubbu laa le, rɔ-to lede nunga. ");
INSERT INTO ksp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parijiyenje, ke mare nje-kɔruje gel-ndu ke inje Jurusalem ddeeje mbɔnje naa rɔ Jeju te. ");
INSERT INTO ksp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Dooje a, mare nje-njaje goe te usaje ne ke jide ke ne-yerew ɔru. N̂-tokoje jide ang. ");
INSERT INTO ksp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mba, Parijiyenje ke kese Jiipije tɔyn, aw ngemje ne-ji-bbeje le kadedeje. N̂-tokoje jide ke maje bba dusaje ne. ");
INSERT INTO ksp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Toke dinje lo te ke dɔ dewje mbɔn naa ke te a, n̂-tokoje rɔde ta kɔru ne yerew ke ddang rɔde te bba dusaje ne. Daw ngemje mare ne-ji-bbeje le kadedeje nya toke le: Gusu toko engoje, joje, ke sambeje. ");
INSERT INTO ksp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yeenn a, Parijiyenje ke nje-kɔruje gel-Ndu dujuje Jeju na: « Mba ddi bba nje-njaje goi te aw ddaje ne ke turu nduje le kajeje ang a, aw usaje ne ke jide yerew wa?» ");
INSERT INTO ksp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jeju ilade te na : « See nje-ngemje, Ejayi ila mber dɔse te ke dɔgɔle. N̂-pa na: « Maketuru le Lubba na: ‹Dewje neenn aw walem taade te baa, a mede to dang sem. ");
INSERT INTO ksp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Polo ke daw polom to ne kara ang, mba neje ke daw n̂-tɔjuje toje to nduje ke inje ta dewje te baa.› » ");
INSERT INTO ksp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jeju pa bbay na: « Inyaje Nduje le Lubba a, nduje ke inje ta dewje te a aw bbeelje.» ");
INSERT INTO ksp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","N̂-teel n̂-pa bbay na: « E-mbeteje Nduje le Lubba tɔkɔrɔ njaa, a ne-ji-bbeje le kaseseje a aw ngemje. ");
INSERT INTO ksp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mba Moyiji pa na: « Oo ta bɔije ke kɔinje». N̂-pa tɔ na: « Dew ke ndɔɔl bɔeje wase kɔenje a, maji kare n̂-tɔle.» ");
INSERT INTO ksp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","A sese, e-paje na: « Toke dew pa are bɔeje wase kɔenje na n̂-ndiki ta kume ke mare ne, a ne le to korban, kande tar le na: ‹Ne ke dew ngem ta kare Lubba,› a, ");
INSERT INTO ksp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","sese areje ddew dew le kare ɔku ne le bɔeje wase kɔenje le. ");
INSERT INTO ksp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Gusu ke baann a aw tujuje ne tar le Lubba are ddee to ne ke baa ddew ne-ji-bbeje te ke aw tɔjuje. Aw ddaje mare neje nya toke baann tɔ.» ");
INSERT INTO ksp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Goe te a, Jeju bbar dewje ke banya le ngaa, pa arede na : « Ooje tar lem ke maje bbo e-gereje kande. ");
INSERT INTO ksp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mare ne ke in ddaka ande me dew te ke a ddae kare n̂-ddee to ne-yerow goto. Ne ke in me dew te tee ke ddaka a, a kase ddae kare n̂-ddee to ne-yerow.» ");
INSERT INTO ksp_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Dew ke mbia to ta koo ne tar a, maji kare oo tar neenn. ");
INSERT INTO ksp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Toke ninya dewje ke banya le ddew ew, ngaa naw ande me key te a, nje-njaje goe te dujeje gel gusu-tar neenn le. ");
INSERT INTO ksp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jeju ilade te na: « Sese kara e-gereje ne ang tɔ wa? Ne kara ke in ddaka ande me dew te, ke a kase dda kare n̂-ddee to ne-yerow goto. E-gereje neenn ang wa? ");
INSERT INTO ksp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mba ne le ande bbengere te ang. Aw mee te, ngaa goe te a, tee mee te ke ddang. Ddew tar te neenn, Jeju tɔju to dew a kase kusa ne tɔyn. ");
INSERT INTO ksp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","N̂-pa bbay na: « Ne ke in me dew te tee ddaka a, aw ddae are n̂-ddee to ne-yerow. ");
INSERT INTO ksp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mba kejeje ke maji ang aw inje me bbengere dew te key bba aw ddaje are dew aw dda kaya, bboko, aw tɔl dew, ");
INSERT INTO ksp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","aw dda lo-to-majang, dda bbo ne-kinga, mee aw maji ang. Naw nula dew naa te, naw dda ne ke ke dɔgɔle ang, naw nunda me ke dew, naw nane de dew, noo rɔe bo, ngaa n̂-dda ne mbe. ");
INSERT INTO ksp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Neje tɔyn ke maji ang neenn le tɔyn inje me dew te bba aw ddaeje are n̂-ddee to ne-yerew.» ");
INSERT INTO ksp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jeju ɔtu lo teenn, aw nange te ke Tir. Nande me mare key te, a n̂-ndiki kare dew gere to nee lo teenn ang, a dewje gɔnje gereje. ");
INSERT INTO ksp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mare dene ke ndil ke maji ang ee me ngonne te oo tare ngaa ddee ke tɔke oso nɔ gɔle te. ");
INSERT INTO ksp_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Dene le to Gereke, duje Penisi, nange te ke Siri. N̂-duju Jeju kare tubba ndil ke maji ang le me ngonne te le. ");
INSERT INTO ksp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jeju pa are na: «Inya are ngannje usaje ne mede ndann bba. Mba maji kunn ne-kusa le ngannje kila kare ngann bisije ang.» ");
INSERT INTO ksp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Dene le ilae te na: «Ye njaa ann, nje-ne-tɔju, a ngann bisije aw usaje baburu ne-kusaje ke nganje inyaje are aw gayn kɔ tabele te le.» ");
INSERT INTO ksp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yeenn ngaa, Jeju pa are na: « Wɔju dɔ tar lei neenn le, e-tel aw key lei, mba ndil ke majang le tee me ngonni te ke ddang mban.» ");
INSERT INTO ksp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Dene le tel key a, inga ngonne le dɔ tuwa te. A ndil ke maji ang le inyae mban. ");
INSERT INTO ksp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jeju ɔtu nange te ke Tir, ria dɔ nange ke tɔku bbeje ke dɔku eeje ke te, ngaa aw er ke tɔku ba te ke Galile, ke ddew ke Sidɔn. ");
INSERT INTO ksp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Dewje ddeeje ke mare dew ke mbia utu ngaa aw pa tar pin rɔe te. N̂-waleje Jeju le nya kare ila jia dɔe te. ");
INSERT INTO ksp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yeenn ngaa Jeju aw ke dingaw le ddew ew ke dewje ke banya le ngaa, tula ngann jia mbia te joo kem, ngaa goe te a, dda maann tae ɔru ne ndɔen. ");
INSERT INTO ksp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Goe te a, nunn keme ke taar, ngaa nila kewn a n̂-pa na: « Epata». Kande tar le na:« E-teyn rɔi.» ");
INSERT INTO ksp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Njange baa njaa a, mbi dingaw le teyn, ngaa ndɔen tutu, a nunn kutu pa tar ke maje. ");
INSERT INTO ksp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jeju ndeje dewje le kare paje tare are dew ang. A ke ndɔ tɔyn ke naw ndejede le a, daw pa tar neje ke naw dda le ke kete kete. ");
INSERT INTO ksp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tar le nya dewje ke banya le ngaa paje na: « Neje tɔyn ke n̂-dda to neje ke maji nya. N̂-dda nare nje mbi-kutuje ooje tar, ngaa nje ke ndɔnde tɔ kara paje tar tɔ.» ");
INSERT INTO ksp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Me ndɔje teenn, dewje ke banya tel mbɔnje naa bbay, a deeje ke ne-kusa ang. Yeenn ngaa Jeju bbar nje-njaje goe te ngaa pa arede na: ");
INSERT INTO ksp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","« Dewje ke banya neenn ddamje ndoo. Mba dda ndɔ muta ngaa deeje rɔm te neenn, a dingaje ne-kusa ang. ");
INSERT INTO ksp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Bbo m-tubbade mare n̂-telje bbee lede mede bbo baa, singade a kɔru ke ddew, mba mareje inje ddew ew. ");
INSERT INTO ksp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nje-njaje goe te ilaeje na: « Lo neenn to me kɔr baa, a lo ke dda ja kinga ne-kusa ke te ta kare dusaje dare mede ndann wa? ");
INSERT INTO ksp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","N-dujude na: « Eeje ke mapa baann wa?» N-paje na: « Siri» N̂-dujude na: « Eeje ke mapa baann wa?» Dilaeje te na: « Jee ne siri.» ");
INSERT INTO ksp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yeenn ngaa n̂-duju dewje ke banya le kare isije nangê. Goe te a, n̂-jin mapaje ke siri le, ngaa nare wooyo Lubba a, n̂-tete nare nje-njaje goe te are kaynje dewje ke banya le. ");
INSERT INTO ksp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nje-njaje-goe te le eeje ke mare ngann kanjije tɔ. Nare wooyo Lubba wɔju dɔ ngann kanjije le ngaa n̂-dujude kare n̂-kaynje dewje ke banya le. ");
INSERT INTO ksp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Dusaje nejeenn le mede ndann ngaa n̂-mbɔnje kese ne-kusa le ase kare siri. ");
INSERT INTO ksp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kɔr dewje ke eeje lo-teenn le ase doro sɔ. Goe te a, Jeju tubbade are n̂-telje bbê lede. ");
INSERT INTO ksp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Njange baa goe te a, naal tɔku to nisi me te de ke nje-njaje goe te ngaa dawje nange te ke Dalmanuta. ");
INSERT INTO ksp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parijiyenje ddee teeje ngaa, unnje kutu mayn tar ke Jeju. N̂-dujeje na: « E-dda mare ne-mɔri are joo, ta tɔjuje to Lubba a ulai.» Mba n̂-ndikije ta nae. ");
INSERT INTO ksp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jeju ila kewn ke singa ngaa pa na: « Mba ddi bba dewje ke bbasine neenn dujuje mare ne-mɔri wa? M-pa tar ke tɔkɔrɔ marese: Ma dda mare ne mɔri kare dooje ang.» ");
INSERT INTO ksp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Goe te a, Jeju inya Parijiyenje le a aal tɔku to aw tura tɔku ba te. ");
INSERT INTO ksp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Me nje-njaje go Jeju te oy ta kaw ke mapa toke banya. Kara baa be a deeje ne me tɔku to te le. ");
INSERT INTO ksp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jeju ndɔru mbide na: « Ooje ke maje bba! Aaje rɔse wɔju dɔ wum le Parijiyenje, ke le Erode tɔ. ");
INSERT INTO ksp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yeenn ngaa n̂-paje tar horo naa te mba deeje ke mapa ang. ");
INSERT INTO ksp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jeju gere tar lede le, ngaa pa arede na: « Mba ddi bba aw maynje naa tar horo naa te mba mapa ke eeje ne ang wa? E-gereje ne ang bbay wa? Ooje tar a e-gereje kande ang bbay wa? Mese nayn aw ketere bbay wa? ");
INSERT INTO ksp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kemse to, a ooje lo ang wa? Mbise to, a ooje tar ang wa? Mese ole ang wa? ");
INSERT INTO ksp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ndɔ ke m-tete mapa mi mba dingawje kɔr mi le, e-mbɔnje kese ddusu ngann kare baann wa? Dilaeje te na: « Ngann kare dɔku gire joo.» ");
INSERT INTO ksp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jeju dujude bbay na: «Ndɔ ke m-tete mapa siri mba dewje kɔr sɔ le, e-mbɔnje kese ddusu kare baann wa?» Dialeje te na:« Ngann kare Siri.» ");
INSERT INTO ksp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yeenn ngaa n̂-dujude na: « Yeenn kara e-gereje ang bbay wa?» ");
INSERT INTO ksp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jeju de ke nje-njaje goe te n̂-teeje Betesayida a, dewje ddeeje ke mare nje-kem-tɔ rɔ Jeju te le, ngaa waleje nya kare ɔre ke jia. ");
INSERT INTO ksp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nuwa ji nje-kem-tɔ le ngaa n̂-tee saa me bbe te le ke ddang. N̂-dda maann tae nɔru ne keme ngaa nila jia keme te. Goe te a, n̂-duje na: « Oo mare ne wa?» ");
INSERT INTO ksp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Dingaw le teyn keme ngaa pa na: « Moo dewje a n̂-toje toke le kakejeenn, a daw n̂-nja.» ");
INSERT INTO ksp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Goe te a, Jeju tel ila jia kem dingaw te le bbay, ngaa keme le uja are noo neje tɔyn ke maje. ");
INSERT INTO ksp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jeju tubbae kare n̂-tel key laa, ngaa pa are na: « Ande me tɔku bbe te le ang.» ");
INSERT INTO ksp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jeju de ke nje-njaje goe te dawje er ke ngann bbeje te ke mbɔr Sejare Pilipi te. Toke daw dawje a, n̂-duju nje-njaje goe te na: « Dewje na m-to na wa?» ");
INSERT INTO ksp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Dilaeje te na: « Mareje paje na e-to Jan-Batisi, mareje paje na e-to Eli, a mareje paje na e-to kara le Nje-kilaje mber-tar le Lubba.» ");
INSERT INTO ksp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ngaa n̂-dujude na : « A sese, e-paje na m-to na wa?» Piyar ilae te na: « E-to Mesi.» ");
INSERT INTO ksp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yeenn ngaa n̂-dɔru mbide nya kare n̂-paje tare dare dew ang. ");
INSERT INTO ksp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Goe te a, Jeju unn kutu tɔju ne nje-njaje goe te na: « Maji kare Ngonn le dew oo ndoo nya. Tɔkuje le Jiipije, ke tɔku nje-poloje Lubba, ke nje-kɔruje gel Ndu a mbeteje. Da tɔleje, ngaa ndɔ mota goe te a, na kin horo dewje te ke oy. ");
INSERT INTO ksp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","N̂-pa tar neenn le narede ke ddaka ke maje. Yeenn ngaa Piyar ɔre ke guku, a unn kutu kin saa. ");
INSERT INTO ksp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","A Jeju turu rɔe aa nje-njaje goe te le ngaa in ke Piyar pa na: « Ɔtu ke ddang gom te, Satan, mba keje lei to keje le dew bbo to keje le Lubba ang.» ");
INSERT INTO ksp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Goe te a, n̂-bbar dewje ke banya, ke nje-njaje goe te ngaa n̂-pa narede tɔyn na: « Toke dew ndiki ta kunn gom a, maji kare neje rɔe ang, ngaa noto kake-dese laa, a nunn gom. ");
INSERT INTO ksp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mba dew ke ndiki ta ngem tebbe laa a, tebbe laa le a nayn ke kɔrɔ. A dew ke tebbe laa nayn ke kɔrɔ wɔju dɔm, ke dɔ Tar ke maji a, a ngem tebbe laa le toke tɔkɔrɔ njaa. ");
INSERT INTO ksp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bbo dew inga ne tɔyn ke dɔ nange te neenn, a tebbe laa nayn ke kɔrɔ a, ddi ke maji a na kinga goe te wa? ");
INSERT INTO ksp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ddi a dew a kase ta kare ta tel kinga ne tebbe laa wa? ");
INSERT INTO ksp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Bbo dew dda rɔ-kul lem, ke rɔ-kul tar lem kem dewje te ke bbokone neenn a, Ngonn le dew a dda rɔ-kul laa ndɔ te ke na ddee ke anjije laa ke majije tɔyn me piti te le Bɔeje. Mba dewje ke bbasine neenn le toje to nje-ne-ddaje ke maji ang ddem, nje-mbeteje taa Lubba ddem. ");
INSERT INTO ksp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jeju tel pa arede bbay na: « Tɔkɔrɔ njaa m-pa marese, mare dewje horose te neenn a koyje ang ndereng, ta da koo Bbe-kɔn le Lubba ke a ddee ke singa-mɔngu. ");
INSERT INTO ksp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ndɔ misan goe te a, Jeju jin Piyar, Jake, ke Jan ngaa aw ke de dɔ ddingiri te ke karede baa. Jeju turu to dang kemde te. ");
INSERT INTO ksp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kubbu laa kara ndɔnren ngaa nda kayn kayn. Dew kara dɔ nange te neenn ke a kase dda kubbu laa kare nda toke baann goto. ");
INSERT INTO ksp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","A ta koo a, nje-njaje go Jeju te le ooje Eli de ke Moyiji ke aw paje saa tar. ");
INSERT INTO ksp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Yeenn ngaa Piyar pa are Jeju na: « Nje-ne tɔju, maji kare n-nayn neenn, jula key-kam mota: Lei kara, le Moyiji kara, le Eli kara.» ");
INSERT INTO ksp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Piyar gere tar kara ke a pa ang, mba ne de ke nje-mareje ke joo le bbeel ddade nya. ");
INSERT INTO ksp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mum ddee kiride ngaa mare ndu bbar me mum te le na: « Dew neenn to Ngunum ke m-ndikie nya. Ooje tae!» ");
INSERT INTO ksp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","A ta koo a, nje-njaje-go Jeju te le aaje lo mbɔrde te a, dooje dew kara ang ngaa. Jeju ke kare baa njaa ar ke de. ");
INSERT INTO ksp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Toke dinje dɔ ddingiri te le daw ddisije a, Jeju ndɔru mbide na: « Dang kara e-paje tar ne ke ooje le areje dew oo ang, ndereng ndɔ te ke Ngonn le dew a kin horo dewje te ke oy.» ");
INSERT INTO ksp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","N̂-ndikije go tar te le Jeju le ke maje, a daw dujuje tar horode te na: « Kin horo dewje te ke oy a to ddi wa?» ");
INSERT INTO ksp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ngaa n̂-dujuje Jeju na: « Mba ddi bba nje-kɔruje gel Ndu paje na Eli a ddee dɔngɔr bba wa?» ");
INSERT INTO ksp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jeju ilade te na: « Tɔkɔrɔ, Eli a ddee dɔngɔr bba njaa, ta tel ke neje tɔyn dɔgɔlɔ te. A mba ddi bba Maketuru le Lubba pa na: ‹Ngonn le dew a koo ndoo nya, ngaa dewje a mbeteje› wa? ");
INSERT INTO ksp_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","A m-pa marese, Eli ddee mban. A n̂-ddaje saa ne tɔyn ke mede ndiki, ddew kara baa ke tar ke Maketuru le Lubba pa dɔe te le. ");
INSERT INTO ksp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kare ke Jeju de ke nje-njaje goe te ke mota le n̂-ddeeje ngɔsi ke keseje a, dooje dewje ke banya ke guku keseje le, ke nje-kɔruje gel Ndu ke aw maynje tar ke de. ");
INSERT INTO ksp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kake dewje ke banya le ooje Jeju le a, mede unda dɔ benya, ngaa n̂-tilaje keme ke ngɔru ta ddae lapiya. ");
INSERT INTO ksp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jeju duju nje-njaje goe te na: « Aw maynje ke de tar wɔju dɔ ddi wa?» ");
INSERT INTO ksp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mare dew ke ee horo dewje te ke banya le ilae te na: « Nje-ne-tɔju, m-ddee ke ngunum ke dingaw rɔi te mba mare ndil ke maji ang aw jɔke are n̂-pa tar ang. ");
INSERT INTO ksp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Lo tɔyn njaa ndil le aw unne te ilae nangê. Jum-tae aw tee, naw ngeer ngange ngaa n̂-mɔngu. M-duju nje-njaje goi te kare n̂-tubbaje ndil ke maji ang le a, duma ne pin.» ");
INSERT INTO ksp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jeju pa arede na: «E-see dewje ke koo me te lese goto neenn, ma nayn ke se be mba ndɔ baann wa? Ma kumase mba ndɔ baann bbay wa? E-ddeeje ke ngonn le aremje.» ");
INSERT INTO ksp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Yeenn ngaa n̂-ddeeje ke ngonn le dareje. A kake ndil ke maji ang le oo Jeju a, unn kutu yeke ngonn le ke singa. Ngonn le oso nangê naw ndubbu ngaa jum-tae aw tee. ");
INSERT INTO ksp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jeju duju bɔ ngonnje le na: «Neenn aw ddae dda ndɔ baann ngaa wa?» Bɔeje le ila Jeju te na: «Ke kase baa njaa.» ");
INSERT INTO ksp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ndil le aw ilae taar taar kem puru te, ang a, me maann te ta kare noy. Bbo ase ta dda mare ne a, oo kem-to-ndoo leje bbo umaje.» ");
INSERT INTO ksp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jeju pa are na: «Mba ddi bba e-pa na: ‹Bbo ase ta dda mare ne a,› wa? Dew ke koo mee te laa to a kase dda ne tɔyn!» ");
INSERT INTO ksp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Njange baa njaa a, bɔ ngonnje le uru ekii ke taar na: «Moo mem te! A e-ddee umam mba koo me te lem goto.» ");
INSERT INTO ksp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jeju oo dewje ke banya ke aw ddeeje ke ngɔru ke rɔde te a ndange ndil ke maji ang le na: «Ei ndil ke nje-dda kare dew pa tar ang ddem, dew oo tar ang ddem, e-tee rɔ ngonn te neenn ke ddang ta e-tel ande mee te ang ngaa.» ");
INSERT INTO ksp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ndil ke maji ang le uru ekii, yeke ngonn le ke singa ngaa tee ke ddang. Ngonn le to toke dew ke oy are dewje nya paje na: «Noy mban.» ");
INSERT INTO ksp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","A Jeju uwa ji ngonn le are in ar taar. ");
INSERT INTO ksp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Toke Jeju tel aw key, ngaa nje-njaje goe te njaa naynje saa ke karede baa a, n̂-dujeje na: «Mba ddi bba jeje juma ke tubba ndil le pin wa?» ");
INSERT INTO ksp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nilade te na: «Ddew duju-Lubba te kara baa a dew a kase tubba ne ndil ke baann.» ");
INSERT INTO ksp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Dɔtuje lo teenn, n̂-ndayje ke ddew ke nangue te ke Galile a n̂-ndiki kare dew gere ang. ");
INSERT INTO ksp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Mba, naw tɔjuje ne nje-njaje goe te ngaa n̂-pa na : «Da kila Ngonn le dew ji dewje te kare n̂-tɔleje, ngaa ndɔ muta goe te a, na kin horo dewje te ke oy.» ");
INSERT INTO ksp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","A nje-njaje goe te le gereje kande tar laa le ang, a n̂-bbeelje ta duje. ");
INSERT INTO ksp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Daw n̂-teeje Kaperenayum. A toke disije me key te a, Jeju duju nje-njaje goe te na: «Ddi bba aw maynje ne naa tar horose te ddew-bô wa?» ");
INSERT INTO ksp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","A dilaje tar te ang, mba kare ke n̂-naynje ddew-bô bbay le, daw maynje naa tar ta gerese se na a to dew ke bo uta nje-mareje wa? ");
INSERT INTO ksp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yeenn ngaa Jeju isi nangê a bbar nje-njaje goe te ke dɔku gire joo le, ngaa pa arede na: « Bbo dew ndiki ta to dew ke dɔngɔr a, maji kare n̂-to dɔbɔyn dew ke go keseje te tɔyn, ngaa n̂-ddee to nje-kula lede tɔyn. ");
INSERT INTO ksp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Goe te a, Jeju unn mare ngonn ke ngaji undae dann de te. Nuwae ke kare te, a n̂-pa nare nje-njaje goe te na: ");
INSERT INTO ksp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Dew ke taa mare ngonn ke toke ne neenn ke rɔe te ke rim a, ema njaa n̂-taam. Ngaa dew ke taam ke rɔe te a, to dew ke ulam a n̂-taae, bbo to ema ke karem ang.» ");
INSERT INTO ksp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jan pa are Jeju na: «Nje-ne tɔju, joo mare dew aw tubba ndilje ke maji ang ke rii. A n-sange ddew ta kɔke ddewe, mba n̂-to dew leje ang.» ");
INSERT INTO ksp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","A Jeju ilae te na: « ɔkeje ddewe ang, mba dew kara ke a dda ne-mɔri ke rim, ngaa njange baa goe te a, a tel pa tar lem maji ang goto. ");
INSERT INTO ksp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mba dew ke mbeteje ang, to dew leje. ");
INSERT INTO ksp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tɔkɔrɔ njaa m-pa marese, toke dew arese maann-kay me engo-maann te kara are ayje mba to ke e-toj e to dewje le Kiriste a, dew le a kinga kuka laa. ");
INSERT INTO ksp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Dew ke dda are mare ngonn kara horo dede te ke dooje mede te sem neenn oso me majang te a, maji ta tɔ tɔku er gɔse te, ta kilae me baa te. ");
INSERT INTO ksp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Bbo jii aw dda are e-dda majang a, e-gange ke ddang. Mba kinga tebbe ke tɔkɔrɔ jii kara baa, maji uta ngem jii joo kem kaw ne kem puru te ke aw ɔn ke ndɔ ke ndɔ. ");
INSERT INTO ksp_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Lo teenn kore ke aw ɔn dew oy ang ddem, puru ke aw ɔn oy ang ddem. ");
INSERT INTO ksp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Bbo gɔli aw dda are e-dda majang a, e-gange ke ddang. Mba kinga tebbe ke tɔkɔrɔ gɔli kara baa maji uta ngem gɔli joo kem kare dilai ne kem puru te, ke aw ɔn ke ndɔ ke ndɔ. ");
INSERT INTO ksp_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Lo teenn, kore ke aw ɔn dew oy ang ddem, puru ke aw ɔn oy ang ddem. ");
INSERT INTO ksp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Bbo kimi aw dda are e-dda majang a, ɔru ke ddang. Mba maji ta kande Bbe-kɔn te le Lubba kimi kara baa, uta ngem kimi joo kem kare dilai ne kem puru te ke aw ɔn ke ndɔ ke ndɔ. ");
INSERT INTO ksp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Lo teenn kore ke aw ɔn dew oy ang ddem, puru ke aw ɔn oy ang ddem. ");
INSERT INTO ksp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Mba puru a kɔru dewje tɔyn toke kate ke dɔru ne te. ");
INSERT INTO ksp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kate to ne ke maji. A bbo kate tel neel ang ngaa a, ddi bba dew a dda kare kate le tel neel bbay wa? Maji kare kate to rɔse te ta isije ke me-wul-lɔm horose te. ");
INSERT INTO ksp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Goe te a, Jeju ɔtu lo teenn aw nange te ke Jude, tura Jurden te. A dewje ke banya tel mbɔnje naa rɔe te bbay, are naw n̂-tɔjude ne ddew kara baa toke naw n̂-dda ke ndɔ tɔyn. ");
INSERT INTO ksp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Parijiyenje awje rɔ Jeju ta nae, ngaa dujeje na: « Ndu are ddew dingaw ta tubba dene laa wa?» ");
INSERT INTO ksp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jeju ilade te na: « Moyiji unn ndu arese na ddi wa?» ");
INSERT INTO ksp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Dilaeje te na: « Moyiji are ddew dingaw kare dda maketuru ta tɔju to ninya dene le ne ngaa, bba ta tubba dene laa.» ");
INSERT INTO ksp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yeenn ngaa Jeju pa arede na: « Moyiji uja ndu neenn le maketuru te arese wɔju dɔ me-ketere lese. ");
INSERT INTO ksp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","A kunn kutu neje te ke Lubba dda le, n̂-dda dingaw de ke dene. ");
INSERT INTO ksp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mba yeenn a, dingaw a kinya bɔeje, ke kɔenje ta nayn ke dene laa, ");
INSERT INTO ksp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ta dede joo kem, da ddeeje to da-rɔ ke kara baa. ");
INSERT INTO ksp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ne ke Lubba mbɔn naa te a, maji kare dew kayn hore ang.» ");
INSERT INTO ksp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kare ke n̂-teeje key a, nje-njaje-go Jeju te le tel dujeje tar dɔ tar te neenn le bbay. ");
INSERT INTO ksp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nilade te na: « Dew ke tubba dene laa, ngaa taa mare, dda maji ang ke dene ke kete ke n̂-tubbae le. ");
INSERT INTO ksp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ddew kara baa, bbo dene mbete ngaweje, a tel taa mare a, dene le dda lo-to maji ang.» ");
INSERT INTO ksp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Dewje ddeeje ke ngannje kare Jeju ɔrude ke jia, a nje-njaje goe te aw inje ke dewje le. ");
INSERT INTO ksp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jeju oo neenn le, a neele ang, ngaa pa are nje-njaje goe te le na: « Inyaje ngannje are ddeeje rɔm te, ɔkuje de ddew ang. Mba Bbe-kɔn le Lubba to le dewje ke toje toke le ngannje. ");
INSERT INTO ksp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tɔkɔrɔ njaa m-pa marese, dew ke taa Bbe-kɔn le Lubba toke le ngonn ang a, a kande me te ndɔ kara ang. ");
INSERT INTO ksp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yeenn ngaa nuwa ngannje le ke kare te, nila jia dɔde te ngaa n̂-bbar tar ke maji dɔde te. ");
INSERT INTO ksp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kare ke Jeju unn ddew ta kɔtu a, mare dingaw ddee ke ngɔru ɔsu mekeji gɔle nɔe te ngaa duje na: « Nje-ne-tɔju ke maji, ddi a maji kare m-dda bba ta kinga ne tebbe ke ke ndɔ ke ndɔ wa?» ");
INSERT INTO ksp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jeju ilae te na: « Mba ddi bba e-bbarem dew ke maji wa? Dew ke maji goto, Lubba kara baa a maji. ");
INSERT INTO ksp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","E-gere nduje ke na: ‹E-tɔl dew ang, e-dda lo-to maji ang ang, e-bboko ang, e-pa tar naji ngem ang, ere dew e-taa ne laa ang, e-wal bɔije ke kɔinje.» ");
INSERT INTO ksp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Dingaw le ilae te na: « Nje-ne-tɔju, maw ngem ndujeenn ke kasem baa ndereng bbokone.» ");
INSERT INTO ksp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jeju aae, ngaa ndike, ngaa pa are na: « Ne kara ngaa dui: Aw labbe neje tɔyn ke ee ne, ta are nare nje-ndooje. A a kinga neje darâ. Goe te a, e-ddee unn gom.» ");
INSERT INTO ksp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","A toke dingaw le oo tar le a, rɔe oy njururu ngaa nɔtu ke rɔ-neel ang, mba nee ke ne-kingaje nya. ");
INSERT INTO ksp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jeju ila keme aa ne lo mbɔre te tɔyn ngaa pa are nje-njaje goe te na: « To ngeng nya ke nje-ne-kingaje ta kande me Bbe-kɔn te le Lubba.» ");
INSERT INTO ksp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tar le gange singa nje-njaje goe te le. A Jeju pa arede bbay na: « Ngannem, to ngeng nya ta kande me Bbe-kɔn te le Lubba! ");
INSERT INTO ksp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kande le nje-ne-kinga me Bbe-kɔn te le Lubba ngeng uta kande le jambal buwa suwa te.» ");
INSERT INTO ksp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tar le aw gange singa nje-njaje goe te le ke kete kete. Ngaa n̂-duju naa na: « Yeenn a, na bba ase kinga kaji wa?» ");
INSERT INTO ksp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jeju aade ngaa pa arede na: « To ne ke nya dew, bbo nya Lubba ang. Mba Lubba ase ta dda ne tɔyn.» ");
INSERT INTO ksp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Yeenn ngaa Piyar pa are na: « Oo! Jinya neje tɔyn a junn goi.» ");
INSERT INTO ksp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jeju ilae te na: « Tɔkɔrɔ m-pa marese: Dew ke inya key laa, ngakɔen ke dingaw wase nje ke dene, kɔenje wase bɔeje, nganne wase ndɔɔje laa wɔju dɔm, ke dɔ Tar ke majia, ");
INSERT INTO ksp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","a tel kinga nejeenn ase gɔl kɔr kara bbasine neenn. Na kinga key, ngakɔen ke dingaw ke nje ke dene, kɔenjedede, ngannje, ke ndɔɔje. Dewje a kula keme ndoo tɔ. A na kinga tebbe ke ke ndɔ ke ndɔ me ndɔje te ke aw ddeeje. ");
INSERT INTO ksp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nya le dewje ke toje to dewje ke dɔngɔr, a toje to dewje ke guku. Ngaa dewje ke toje to dewje ke guku, a toje to dewje ke dɔngɔr. ");
INSERT INTO ksp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jeju de ke nje-njaje goe te daw dawje ke Jurusalam a, nɔru nɔde. Keje tar tɔl nje-njaje goe te le ngaa bbeel dda dewje ke aw unnje gode le tɔ. Jeju tel ɔru nje-njaje goe te ke dɔku gire joo le er kara te, ngaa unn kutu pa tar karede dɔ ne te ke a ta kingae le na: ");
INSERT INTO ksp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","« Ooje, jaw jawje ke Jurusalam. Dewje a kilaje Ngonn le dew ji tɔku nje-poloje Lubba te, ke nje-kɔruje-gel ndu. Da gange sariya-yo dɔe te ngaa da kilae ji dewje te ke gereje Lubba ang. ");
INSERT INTO ksp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Da kokeje, da ti weren dɔe te, da tundaeje, da tɔleje ngaa ndɔ mota goe te a, na kin horo dewje te ke oy.» ");
INSERT INTO ksp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Goe te a, Jake de ke Jan ke toje to ngann le Jebede n̂-ddeeje rɔ Jeju ngaa n̂-paje dareje na: « Nje-ne tɔju, n-ndiki kare e-dda ne ke ja ta duji neenn areje.» ");
INSERT INTO ksp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jeju dujude na : « Ddi a e-ndikije kare m-dda marese wa?» ");
INSERT INTO ksp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Dilaeje te na: « Ndɔ piti lei a, jeje ke joo neenn, are kara isi dɔ ji-kɔli te, a kara isi dɔ ji-geli te.» ");
INSERT INTO ksp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jeju ilae te na: « E-gereje ne ke aw dujuje ang. A kaseje ta kay engo kem-to-ndoo ke ma ta kay wa?» A kaseje ta kinga batem kem-to-ndoo ke ma ta kinga neenn wa?» ");
INSERT INTO ksp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Dilaeje te na: « Jase.» A Jeju pa arede na: « Tɔkɔrɔ, a kayje engo kem-to-ndoo ke ma ta kay, a kingaje batem kem-to-ndoo ke ma ta kinga. ");
INSERT INTO ksp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","A tar kisi dɔ ji-kɔlem te, wase dɔ ji-gelem te to tar lem ang. Lo le to wɔju dɔ nje ke Lubba mɔse kete wɔju dɔde.» ");
INSERT INTO ksp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Keseje ke dɔku le ooje tar le a, ungu ɔnde dɔ jake de ke Jan te. ");
INSERT INTO ksp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yeenn ngaa Jeju bbarde tɔyn ngaa pa arede na: « E-gereje to nje ke dewje aw oojede to mbayje aw ddaje dingaw dɔ dewje te, ngaa dewje ke bo aw nyaje dɔde te. ");
INSERT INTO ksp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","A horose te, to toke baann ang. A toke mare dew horose te ndiki ta ddee to dew ke bo a, maji kare n̂-ddee to nje-kula lese. ");
INSERT INTO ksp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ngaa toke mare dew horose te ndiki ta ddee to dew ke dɔngɔr a, maji kare n̂-ddee to bbere lese tɔyn. ");
INSERT INTO ksp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mba Ngonn le dew ddee kare dewje ddeeje to nje-kulaje laa ang. N̂-ddee ta to nje-kula le dewje, ta kunn rɔe to ne-kuka dɔ dewje ke banya. ");
INSERT INTO ksp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jeju, ke nje-njaje goe te n̂-teeje Jeriko. Ngaa toke Jeju de ke nje-njaje goe te, ke dewje ke banya daw n̂-teeje me tɔku bbe te le ta kɔtu a, mare nje-kem-tɔ ke to ngonn le Time, ria na Bartime isi mbɔr ddew te aw kɔy ne. ");
INSERT INTO ksp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Toke noo na Jeju ke Najarete a aw nday a, nunn kutu kuru ekii na: « Jeju, Ngonn le Dabbiti oo kem-to-ndoo lem!» ");
INSERT INTO ksp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Dewje nya inje saa kare nutu tae, a nuru ekii ke taar na: « Ngonn le Dabbiti, oo kem-to-ndoo lem!» ");
INSERT INTO ksp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jeju ar lo kara ngaa pa na: « E-bbareje.» Dewje le bbareje ngaa paje areje na: « E-dda singa in taar, naw bbari!» ");
INSERT INTO ksp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nila tɔku kubbu laa nangê, nubba nange nin nar taar ngaa naw ke rɔ Jeju te. ");
INSERT INTO ksp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jeju duje na: « Ddi a e-ndiki kare m-dda mari wa?» Nje-kem-tɔ le ilae te na: « Nje-ne-tɔju, m-ndiki ta tel koo lo!» ");
INSERT INTO ksp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jeju pa are na: « Aw, koo me te lei aji!». Njange baa goe te a, n̂-tel noo lo ngaa nunn go Jeju ddew-bô. ");
INSERT INTO ksp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Toke Jeju ke nje-njaje goe te teeje ngɔsi ke Jurusalam, ngɔsi ke Betepaje, ke Betani, dɔ ddingiri kake olibeje te a, Jeju ula nje-njaje goe te joo nɔe te kete. ");
INSERT INTO ksp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ngaa pa arede na: « Awje ngonn bbe te ke nɔse te tonn. A ta teeje be a, a kooje mare ngonn kororo ke n̂-tɔe, nayn dew isi dɔe te ang bbay. E-tuteje e-ddeeje saa. ");
INSERT INTO ksp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Bbo dew dujuse na: ‹Mba ddi bba e-ddaje ne ke be wa› a, ilaeje te na: ‹Ebbe-dewje a duju, a na kare n̂-tel saa njange baa.› » ");
INSERT INTO ksp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Dawje ngaa dingaje ngonn kororo ke toke tɔe ta ndoko te ddaka mbɔr ddew te, ngɔsi ke ta key ngaa n̂-tuteje. ");
INSERT INTO ksp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mare dewje ke eeje teenn dujujede na: « Ddi a aw ddaje neenn wa? Mba ddi bba aw tutuje ngonn kororo le wa?» ");
INSERT INTO ksp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nje-njaje go Jeju te le ilaje dewje le te ddew kara baa toke Jeju pa arede le. Ngaa dewje le inyade are dawje saa. ");
INSERT INTO ksp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Dawje ke ngonn kororo le dare Jeju. N̂-labbeje kubbuje lede dɔ kororo te le, ngaa Jeju aal isi dɔe te. ");
INSERT INTO ksp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Dewje nya labbeje kubbuje lede dɔ ddew te, a mareje tukaje kamje me mu te labbeje dɔ ddew te. ");
INSERT INTO ksp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Dewje ke aw njaje nɔ Jeju te, ke nje ke aw njaje goe te aw uruje ekii na: « Ojana! Maji kare Lubba bbar tar ke maji dɔ dew te ke aw ddee ke ri Ebbe-dewje. ");
INSERT INTO ksp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Maji kare Lubba bbar tar ke maji dɔ kɔn-bbe te ke aw ddee. Kɔn-bbe le kajeje Dabbiti. Piti to le Lubba ke isi ddutu dara te nu!» ");
INSERT INTO ksp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jeju tee Jurusalam, ngaa aw ande key-polo-Lubba te. Nila keme naa ne neje tɔyn mbɔre te, ngaa goe te a, ne de ke nje-njaje goe te ke dɔku gire joo le dawje ke Betani mba lo wul mban. ");
INSERT INTO ksp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Lo-kare te a dinje Betani daw dɔtuje a, bbo dda Jeju le. ");
INSERT INTO ksp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Noo mare kake pige ke kame ee te ddew ew, ngaa naw ngɔsi ta koo se kande to wa? A kame dɔrɔ a noo. Mba to neyn kande le Pige ang. ");
INSERT INTO ksp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yeenn ngaa Jeju pa are kake Pige le na: « A kande kare dew usa ang nyɔm!» Nje-njaje go Jeju te le ooje tar le. ");
INSERT INTO ksp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","N̂-teeje Jurusalam a, Jeju ande key-polo-Lubba te. Nunn kutu tubba nje-ne-labbeje, ke nje-ndoko neje me key-polo-Lubba te le. N̂-tuta tabeleje le nje ke aw mbelje nare, ke ne-kisi le nje-labbe derje n̂-tila, ");
INSERT INTO ksp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ngaa nare dew kara oto mare ne nday ne me key-polo-Lubba te le ang. ");
INSERT INTO ksp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Goe te a, n̂-tɔjude ne na: « Lubba pa me maketuru te laa na: « Da bbar ri key lem to key-duju Lubba, ke gel-dewje tɔyn a duju Lubba me te. A sese, e-ddaje areje ddee to lo-kiya-rɔ le nje-bbokoje wa!» ");
INSERT INTO ksp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tɔku nje-poloje Lubba, ke nje-kɔruje gel-ndu ooje tar le ngaa, aw sangeje gusu ke ta tɔl Jeju. N̂-bbeleje nya, mba ne-tɔju laa aw gange singa dewje ke banya le tɔyn. ");
INSERT INTO ksp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Lo-kul a, Jeju ke nje-njaje goe te n̂-teeje me tɔku bbe te le ke ddang. ");
INSERT INTO ksp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Lo-kare ke endɔɔ a daw n̂-ndayje a, dooje kake pige le a oy taar ndereng ngirae te. ");
INSERT INTO ksp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Me Piyar ole dɔ tar teenn le, ngaa pa are Jeju na: « Nje-ne-tɔju, oo kake pige ke ɔru saa le a oy njan toonn.» ");
INSERT INTO ksp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jeju pa arede na: « Ooje mese te ke Lubba.» ");
INSERT INTO ksp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tɔkɔrɔ njaa m-pa marese: Bbo dew pa are ddingiri toonn na: ‹Ɔtu lo teenn aw oso bâ›, a bbo keje-tar to mee te ang, a Lubba a dda kare ne le ddee toke baann. ");
INSERT INTO ksp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mba yeenn a, m-pa marese: Ne tɔyn ke aw dujuje Lubba wɔju dɔe a, maji kare ooje mese te to ingaje ne le mban, a Lubba a karese. ");
INSERT INTO ksp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ngaa toke arje taar ta duju Lubba, a bbo eeje ke tar ke mare dew a, ɔruje tar le dɔe te, areje Bɔsese ke isi me dara te ɔru tar dɔse te tɔ.» ");
INSERT INTO ksp_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","A bbo ɔruje tar dɔ dewje te ang a, Bɔsese ke darâ a kɔru tar majang ke e-ddaje dɔse te ang tɔ. ");
INSERT INTO ksp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jeju ke nje-njaje goe te n̂-telje Jurusalam bbay. Kare ke Jeju aw nja me key-polo-Lubba te a, tɔku nje-poloje Lubba ke nje-kɔruje gel-ndu, ke tɔkuje le Jiipije ddeeje rɔe te. ");
INSERT INTO ksp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","N̂-dujeje na: « Na a ari ddew ta dda ne neenn wa? Wase na njaa gate a ari singa ta dda ne neenn wa? ");
INSERT INTO ksp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jeju ilade te na: « Ma dujuse tar kara baa. Toke ilamje te a, ma bbar ri dew ke arem singa dda nejeenn le karese tɔ. ");
INSERT INTO ksp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Na a ula Jan are dda batem dewje wa? Lubba wase dewje wa? Ilamje tar te.» ");
INSERT INTO ksp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","A n̂-paje horode te na: « Bbo jilaje te n-pa na: ‹ Lubba a ulae› a, na pa na: ‹ Mba ddi bba e-ndikije te ke Jan le ang wa?› ");
INSERT INTO ksp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","A bbo n-paje na: ‹ Dewje a ula Jan a...› » Tɔku nje-poloje Lubba ke nje-kɔruje gel-ndu, ke tɔkuje le Jiipije le bbeelje dewje ke banya le, mba dewje tɔyn ooje Jan to nje-kila mber-tar le Lubba. ");
INSERT INTO ksp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yeenn ngaa dilaje Jeju te na: « N-gere ang.» Ngaa Jeju pa arede na: « Ema kara ma bbar ri dew ke arem singa dda nejeenn le karese ang tɔ.» ");
INSERT INTO ksp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Goe te a, Jeju unn kutu pa tar ke nje-njaje goe te ke gusu-tar na: « Mare dingaw dda ndɔɔ binye. N̂-dda ndoko n̂-guku ne dɔe. Nuru buwa me er te mba kore ne maann binye le. Ngaa n̂-dda mare lo-kisi taar mba kaa ne lo ke dɔ ndɔɔ te le. Goe te a, ninya ndɔɔ le ji mare nje-kula ndɔ binyeje te a, naw mba te. ");
INSERT INTO ksp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tee kare kuja kande binye te le a, nula nje-kula laa rɔ nje-kula ndɔɔ binyeje te le kare dula ke engaen. ");
INSERT INTO ksp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","A nje-kulaje le uwaeje undaeje ngaa tubbaeje are n̂-tel jia baa. ");
INSERT INTO ksp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nje-ndɔɔ le ula mare nje-kula laa a, nje-kulaje le undaje dɔe ngaa tajeje. ");
INSERT INTO ksp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nje-ndɔɔ le tel ula mare bbay a, a nje-kulaje le tɔleje. N̂-tel nula mareje banya bbay a, nje-kulaje le tunda mareje, a tɔl mareje. ");
INSERT INTO ksp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ngonne ke dingaw ke n̂-ndike nya kara baa ngaa nayn. Nulae to dɔbɔyn dew rɔ nje-kulaje te le mba n̂-pa na: ‹Da bbeel ngonnum.› ");
INSERT INTO ksp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","A nje-kulaje le paje horo naa te na: ‹Nje-kuwa ne-ndubba le ann. E-ddeeje areje n̂-tɔle, ta ndɔɔ le ddee to leje!› ");
INSERT INTO ksp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Yeenn ngaa, duwaje ngonn le, n̂-tɔleje ngaa n̂-teeje ke niinne me ndɔɔ te le dilaje ddaka. ");
INSERT INTO ksp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ddi a nje-ndɔɔ le a dda wa? Na ddee tɔl nje-kulaje le ta na teel ke ndɔ le kare mare nje kula ndɔɔ binyeje te ke ddang. ");
INSERT INTO ksp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","E-turaje tar ke Maketuru le Lubba pa neenn ang wa? Maketuru le na: ‹Er ke nje-kɔsuje key mbeteje le, er lel ddee to singa gɔl key ke dungu nangê. ");
INSERT INTO ksp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","To ne ke Ebbe-dewje a dda, ngaa kura nya kemje te.› » ");
INSERT INTO ksp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Daw sangeje ddew ta kuwa Jeju le mba n̂-gereje to n̂-pa gusu-tar neenn le wɔju dɔde. A n̂-bbeelje dewje ke banya le, ngaa dinyaeje a dɔtuje. ");
INSERT INTO ksp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Dulaje mare Parijiyenje, ke mare dewje ke eeje me mbɔnaa te le Erode Atipase rɔ Jeju te ta nae ddew tar te ke tae te. ");
INSERT INTO ksp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","N̂-ddee n̂-paje dareje Jeju le na: « Nje-ne-tɔju, n-gere to aw pa tar ke tɔkɔrɔ, aw tɔju ddew le Lubba ddew tar te ke tɔkɔrɔ. Ngaa aw bbeel kem dew ang ddem, dew ke bo wase dew ke ten kara osoi te ang. E-pa areje joo: Ndu areje ddew ta kuka lambo ke tɔku mbay Sejar wase ta kuka ang wa? Ta juka wase juka ang wa?» ");
INSERT INTO ksp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","A Jeju gere to ne ke daw deje mede te to dang ke ye ke daw n̂-pa, ngaa pa arede na: « Aw namje mba ddi wa? E-ddeeje ke mare kande nare kara aremje moo.» ");
INSERT INTO ksp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","N̂-ddeeje ke mare kande nare dareje, ngaa n̂-dujude na: « Endaji dɔ dew, ke maketuru ke n̂-dda kande nare te neenn toje to le na wa?» Dilaeje te na: « To le Sejar.» ");
INSERT INTO ksp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yeenn ngaa Jeju pa arede na : « Areje Sejar ne ke to le Sejar, a areje Lubba ne ke to le Lubba.» Tar laa le nya dewje ke ddeeje ta nae le. ");
INSERT INTO ksp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mare saduseyenje ddeeje rɔ Jeju te. Saduseyenje le paje na dewje ke oy a kinje ang. N̂-dujuje Jeju na: ");
INSERT INTO ksp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","« Nje-ne-tɔju, Moyiji unn ndu areje me maketuru te na: ‹Toke dingaw uju ke dene laa ang, a oy a inyae, a bbo ngokɔn dingaw le to a, maji kare n̂-taa dene le nuju ne ngannje nare ngokɔen ke oy le. ");
INSERT INTO ksp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Lew, mare ngakɔn naaje ke dingaw eeje siri. Ne ke dɔngɔr n̂-taa dene, ngaa nuju saa ang a noy. ");
INSERT INTO ksp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Joo lede taa dene le a uju saa ang a oy tɔ. Mota lede ta dene le a toke baann bbay. ");
INSERT INTO ksp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aw ne ke goe goe are dede ke siri le dujuje ang a doyje tɔyn. Ngaa goe te a, dene le kara oy tɔ. ");
INSERT INTO ksp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ndɔ kin le dewje ke oy a, na horode te a, a to nje-dene le wa? Mba dede siri tɔyn njaa n̂-taaje dene le.» ");
INSERT INTO ksp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jeju ilade te na: « E-ndemje ddew, mba e-gereje Maketuru le Lubba ang ddem, e-gereje singa-mɔngu le Lubba ang ddem. ");
INSERT INTO ksp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ndɔ ke dewje ke oy inje a, dingaw a taa dene ang ddem, dene a taa ngaw ang ddem. Da kisije toke le anjije me dara te. ");
INSERT INTO ksp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tar ke wɔju dɔ kin le dewje ke oy le, e-turaje tar ke me maketuru te le Moyiji le ang wa? Lubba pa are Moyiji mbɔr ber-kam te ke aw ɔn puru pa na: ‹M-to Lubba le Abaraham, Lubba le Ijake, ke Lubba le Jakobbo.› ");
INSERT INTO ksp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Lubba to Lubba le dewje ke oy ang, n̂-to Lubba le dewje ke isi kem baa. Yeenn a, e-ndemje ddew njaa nyɔm.» ");
INSERT INTO ksp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mare nje-kɔru gel Ndu oo tar lede le, a gere to tar ke Jeju ilade te to ke dɔgɔle, ngaa ddee rɔ Jeju te ngɔsi duje na: « Ndu ke dda ngeng uta keseje tɔyn wa?» ");
INSERT INTO ksp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jeju ilae te na: « Ndu ke ngeng uta keseje na: ‹See ngann Ijarayelje, ooje! Ebbe-dewje ke to Lubba leje a to Ebbe-dewje kara baa. ");
INSERT INTO ksp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Maji kare e-ndiki Ebbe-dewje Lubba lei ke mei tɔyn, ke kewn lei tɔyn, ke keje lei tɔyn, ke singai tɔyn.› ");
INSERT INTO ksp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Joo le ndu a neenn: ‹E-ndiki nje-mari toke da rɔi njaa.› Mare ndu ke ngeng uta nje ke jo neenn goto.» ");
INSERT INTO ksp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nje-kɔru gel Ndu le pa are Jeju na: « Maji nya, Nje-ne-tɔju! Tar ke tɔkɔrɔ a e-pa neenn. Ebbe-dewje a to Lubba kara baa, mare Lubba dang goto. ");
INSERT INTO ksp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Maji kare dew kara kara ndiki Lubba ke mee tɔyn, ke keje laa tɔyn, ke singae tɔyn. Ngaa maji kare n̂-ndiki nje-mare toke da-rɔe njaa. Yeenn maji uta ne-poloje ke ta ro ke ne-kare-baaje dang dang.» ");
INSERT INTO ksp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jeju oo a, tar ke nje-kɔru gel Ndu le ilae te le to tar kem-kare. Yeenn ngaa n̂-pa nare na: « Ee ngɔsi baa ke Bbe-kɔn le Lubba.» Goe te a, dew tay duje tar ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jeju aw tɔju ne me key-mbɔn naa te le jiyipije a, duju tar na: « Nje-kɔruje gel ndu a kaseje ta pa na Kiriste to ngonn le Dabbiti toke baann wa? ");
INSERT INTO ksp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dabbiti njaa kara, toke Ndil-me-nda ddusu mee a, pa na: Ebbe-dewje Lubba pa are Ebbemje na: ‹E-ddee isi dɔ ji-kɔlum te, ndereng ta mungu nje-baanji lei kɔy gɔli te bba.› ");
INSERT INTO ksp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dabbiti njaa kara bbar Kiriste to Ebbeeje. Yeenn a, Kiriste le a to ngonne toke baann wa?» Dewje ke nya aw ooje tar laa le ke rɔ-nel. ");
INSERT INTO ksp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jeju pa me ne-tɔju te laa na: « Aaje rɔse wɔju dɔ nje-kɔruje gel ndu ke ndikije ta kula kubbu ke ngal bba ta kase ne lo, ngaa ndikije kare dewje ddajede lapiya nata. ");
INSERT INTO ksp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","N̂-ndikije ta kuwa lo kisi ke kete me key-mbɔ-naa te, ngaa ta kuwa dɔngɔr lo-kisi lo ne-kusa kusu te. ");
INSERT INTO ksp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Daw n̂-taaje neje le dene-ndubbaje jide te tɔyn ngaa daw dujuje Lubba kure ew ta kare dewje oojede to dewje ke maji nya. Mba yeenn a, sariya ke dɔde te a ngeng nya kuta le kese dewje.» ");
INSERT INTO ksp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Goe te a, Jeju tur keme ke ne te ke daw dila ne-kare-baa me te, ngaa naw noo ne ke dewje aw ilaje. Nje-ne-kingaje aw ilaje tɔku nare. ");
INSERT INTO ksp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mare dene-ndubba ke to nje-ndoo ddee ila ngann kande nare joo kɔre boy ang. ");
INSERT INTO ksp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yeenn ngaa Jeju bbar nje-njaje goe te ngaa pa arede na: « M-pa tar ke tɔkɔrɔ marese: Dene-ndubba ke to nje-ndoo neenn ila ne bo uta dewje tɔyn. ");
INSERT INTO ksp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mba kese dewje tɔyn, nare ke dooje ne ta dda ne ang a dilaje. A ne, bbay nare ke nayn ta kare n̂-ngem ne rɔe a nila.» ");
INSERT INTO ksp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kare ke Jeju in me key-polo-Lubba te aw tee ke ddaka a, mare nje-nja goe te pa are na: « Nje-ne tɔju, Oo erje ke kura neenn, oo tɔku key neenn!» ");
INSERT INTO ksp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jeju ilae te na: « Tɔku key ke aw oo neenn le, mare er kara a nayn dɔ mare te, lo te ke neenn ang. Da tɔ neje neenn tɔyn.» ");
INSERT INTO ksp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jeju isi nangê dɔ ddingiri olibeje te, nɔ key-polo-Lubba te. A Piyar, Jake, Jan ke Andere ke isije saa keteenn ke karede baa le dujeje na: ");
INSERT INTO ksp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","« E-pa areje: Ndɔ ke dda nejeenn a teeje wa? Ddi a, a tɔjuje kare ke neje tɔyn a tunga ne le wa?» ");
INSERT INTO ksp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yeenn ngaa Jeju pa arede na: « Aaje rɔse! Areje dew erese ang! ");
INSERT INTO ksp_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Dewje nya a ddeeje ke rim ngaa a paje na: ‹M-to Mesi le!› Da kereje dewje nya. ");
INSERT INTO ksp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Bbo ooje tar ddɔ ke aw ddeeje ngɔsi ke tar ddɔ ke nayn ddew ew a, areje bbeel ddase ang. Maji kare nejeenn le toje. A, a to ddutu ndɔ ang bbay. ");
INSERT INTO ksp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Gel-dewje a kinje ta dda ddɔ ke mare gel-dewje. Bbe-kɔn a kin ta dda ddɔ ke mare bbe-kɔn. Nange a yeke loje te dang dang, tɔku bbo a koso. A nejeenn tɔyn a toje toke le kunn-kutu nduru-ndo le dene.» ");
INSERT INTO ksp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","« A sese, undaje kemse dɔ rɔse te. Dewje a kaw ke se nɔ sariya te. Dewje a tundase me key-mbɔn naa te le Jiipije, da kaw ke se nɔ ngann mbayje te, ke nɔ tɔku-mbayje te wɔju dɔm, ngaa a toje to nje-tar-najije lem. ");
INSERT INTO ksp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mba maji kare dila mber Tar ke majidare dewje tɔyn kete bba. ");
INSERT INTO ksp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Toke daw ke se sariya te a, areje mese sangese kete wɔju dɔ tar ke a paje wase, gusu ke a paje ne tar le ang. Tar ke Lubba a karese kare teenn njaa, a ta e-paje. To tar ke sese njaa a, a paje ang. To Ndil-me-nda a, a pa tar le. ");
INSERT INTO ksp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Dewje a kilaje ngokɔnde ji dewje te kare n̂-tɔlde, ngaa bɔje a ddaje toke baann ke ngannde tɔ. Ngannje a ddeeje to nje-baanji le nje-kujude, ngaa da kare n̂-gange sariya-yo dɔde te. ");
INSERT INTO ksp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Dewje tɔyn a mbetese wɔju dɔm. A dew ke uwa are ngeng ndereng tee kɔnye te a, a kinga kaji.» ");
INSERT INTO ksp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","« A kooje ‹ne ke maji ang ke aw tuju lo› le lo-kisi te ke to wɔju dɔe ang. Maji kare dew ke aw tura maketuru neenn gere ke maje! Kare teenn, maji kare dewje ke isije nange Jude te aynje awje dɔ ddingirije te. ");
INSERT INTO ksp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Maji kare dew ke isi lo-kisi te ke dɔ key te ddisi aw me key te ta kunn mare ne ang. ");
INSERT INTO ksp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ngaa toke dew ee ndɔɔ a, maji kare n̂-tel bbee mba kunn kubbu laa ke ngal ang tɔ. ");
INSERT INTO ksp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Dɔ ndɔje teenn, a to ndoo nya kare deneje ke eeje ke sem, ke nje ke ngannde aw ilje mba. ");
INSERT INTO ksp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","E-dujuje Lubba kare neenn tee dɔ-ney-kul te ang. ");
INSERT INTO ksp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mba me ndɔje teenn, dewje a kooje ndoo nya. Unn kute dɔ ndɔ te ke Lubba dda ne nange ndereng bbokone, dewje ooje ndoo toke baann ang. Goe te kara, dewje a kooje ndoo toke baann ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Toke Ebbe-dewje tel ke ndɔ nejeenn le are nayn ngaji baa ang a, dew kara a kinga kaji ang. A n̂-tel ne njaa wɔju dɔ dewje ke n̂-mberede toke kete. ");
INSERT INTO ksp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Yeenn a, toke dew pa arese na: ‹Ya! Mesi ee neenn,› wase: ‹Nee yonn› a, e-ndikije te saa ang. ");
INSERT INTO ksp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mba mesije ke tɔkɔrɔ ang, ke nje-kilaje mber-tar ke tɔkɔrɔ ang a ddeeje. Da ddaje ne-mɔrije ke neje ke dum dɔ koo, ta bbo ddew to a, nje ke Lubba mberede kara ta kerede tɔ. ");
INSERT INTO ksp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yeenn a, sese, aaje rɔse! Mba m-pa nejeenn kete marese mban. ");
INSERT INTO ksp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","« Dɔ ndɔɔje teenn, go ndoo te ke dewje a kooje le a, kare a tuka ndul, ney a nda ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Endentenrendenje a kinje darâ gaynje nangê, ngaa singa-mɔnguje ke me dara te a yekeje. ");
INSERT INTO ksp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Yeenn ngaa, a kooje Ngonn le dew a ddee me mum te ke singa-mɔngu laa tɔyn ddem, ke piti ddem. ");
INSERT INTO ksp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Yeenn ngaa, na kula anjije kare mbɔnje dewje ke n̂-mberede dɔ nange te tɔyn, unn kute kɔyn nange te kara tee kɔyn nange te ke kara.» ");
INSERT INTO ksp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","« Ooje ne-kɔju mare dɔ kake Pige te. Toke barkem kake Pige unn kutu tewn, a kame aw unju a, e-gereje to neyn ne-dubbu ee ngɔsi ngaa. ");
INSERT INTO ksp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ddew kara baa, toke ooje nejeenn le a, maji kare e-gereje to Ngonn le dew ee ngɔsi ngaa. Nar ta key te lese. ");
INSERT INTO ksp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","M-pa tar ke tɔkɔrɔ marese: dewje ke bbokone neenn a koyje tɔyn ang bbay a, nejeenn tɔyn a teeje.» ");
INSERT INTO ksp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Dara, ke nange a ndayje, a tarje lem a ndayje ndɔ kara ang.» ");
INSERT INTO ksp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","« A ndɔ, wase kare ke nejeenn le a teeje ne le dew kara gere ang. Anjije ke darâ, wase Ngonn le kara gere ang. Bɔ ke kare a gere. ");
INSERT INTO ksp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Aaje rɔse bbo e-tibbije ang. Mba e-gereje ndɔ ke nejeenn le a teeje ne ang. ");
INSERT INTO ksp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Neennn a to ddew kara baa toke dew ke aw ke mba te. Ninya key nare nje-kulaje laa kare n̂-ngemje. Nare dew kara kara kula laa kare dda. A, nunn ndu nare nje-ngem ta key kare ta aa lo ke kete bbo tibbi ang. ");
INSERT INTO ksp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","E-tibbije ang, mba egereje ndɔ ke nje-key le a ddee ne ang, dɔ-kar te, wase dɔ bakebbe te, wase toke kunran aw nɔɔ, wase ta lo-kare te. Yeenn a, e-tibbije ang, mba e-gereje ndɔ ke nje-key le a ddee ne ang. Na ddee dɔ-kare te wase, til te ke lo to yenene wase, dɔ-bakebbe te wase, ke esindɔɔ wa kara a gereje ang. ");
INSERT INTO ksp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mba kare n̂-tel n̂-ddee busu a, ningaje dɔ bbi te ang. ");
INSERT INTO ksp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tar ke m-pa marese neenn, m-pa mare dewje tɔyn: Areje kemse ketere.» ");
INSERT INTO ksp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kusu-pake, ke kusu mapa ke n̂-dda ke wum ang naynje ndɔ joo baa. A, tɔku nje-poloje Lubba, ke nje-kɔruje gel ndu aw sangeje ddew ke ta kuwa ne Jeju ke ke gusu ta tɔle. ");
INSERT INTO ksp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mba n̂-paje na: « Maji kare juwae ndɔ kusu te ang mba a kuju bula.» ");
INSERT INTO ksp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jeju ee Betani me key te le Simɔ ke to nje-banji. Kare ke naw nusa ne a, mare dene ddee ke yambo ke gate ngeng, me ku Alebatere te. N̂-tɔ ta ku le ngaa nungu yambo le dɔ Jeju te le. ");
INSERT INTO ksp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Rɔ mare dewje ke eeje teenn neelde ang ngaa n̂-paje horode te na: « N̂-tuju yambo neenn baann mba ddi wa? ");
INSERT INTO ksp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Jase ta labbe yambo le kande nare tɔl muta a kare nje-ndooje ang wa! Ngaa n̂-paje tar le dene le maji ang. ");
INSERT INTO ksp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","A Jeju pa arede na: « Inyaeje ddekeke! Aw jɔkeje mba ddi wa? Ne ke n̂-dda sem neenn to ne ke maji. ");
INSERT INTO ksp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nje-ndooje a kee ke se neenn ke ndɔ tɔyn. Ndɔ ke mese ndiki a, a ddaje ke de maji. A ema, ma kee ke se ke ndɔ tɔyn ang. ");
INSERT INTO ksp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ne ke nase ta dda, a n̂-dda. Nungu yambo rɔm te kete ta ngina ne ndɔ ke da dubbum ne. ");
INSERT INTO ksp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","M-pa marese, tar ke tɔkɔrɔ, lo tɔyn ke dila mber Tar ke maji ke te, dɔ nange te tɔyn, da pa tar ne ke dene neenn dda, ngaa dewje a koleje mede dɔe te». ");
INSERT INTO ksp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judase Isikariyote ke to kara le nje-njaje go Jeju te ke dɔku gire joo aw rɔ tɔku nje-poloje Lubba te ta kila Jeju jide te. ");
INSERT INTO ksp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Dooje tar laa le a rɔde neelde nya, ngaa dunnje ndude ta kare nare. Yeenn ngaa Judase unn kutu sange ddew ke maji ke na kila ne Jeju jide te. ");
INSERT INTO ksp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Dɔngɔr ndɔ kusu mapa ke n̂-dda ke wum ang, ke to ndɔ ke daw n̂-tɔl ne ngann bateje mba dda ne muru Pake a, nje-njaje go Jeju te paje areje na: « Lo ke dda a e-ndiki ta kare jaw mɔse muru Pake kete jari wa?» ");
INSERT INTO ksp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yeenn ngaa Jeju ula nje-njaje goe te joo kete na: « Awje tɔku bbe te, a, a kingaje mare dingaw ke oto joo maann. A unnje goe. ");
INSERT INTO ksp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Key ke nande te a, e-paje areje nje-key le na: ‹Nje ne-tɔju duju na: Lo ke dda, ema ke nje-njaje gom te ja kɔn muru Pake kete wa? ");
INSERT INTO ksp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nje-key le a tɔjuse mare lo ke tate ke toke mɔse mban dɔ key te taar. Neje tɔyn to me te. Lo le a, a mɔseje ne-kusa leje le ke te.» ");
INSERT INTO ksp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nje-njaje goe te le ɔtuje awje tɔku bbe te le. Dingaje neje le tɔyn ddew kara baa toke n̂-pa arede le, ngaa n̂-mɔseje muru Pake le. ");
INSERT INTO ksp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Lo-kul a, Jeju de ke nje-njaje goe te ke dɔku gire joo n̂-ddee n̂-teeje. ");
INSERT INTO ksp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kare ke disije daw dusaje ne a, Jeju pa na: « Tɔkɔrɔ njaa, m-pa marese, dew kara horose te ke aw usa ne sem a kilam ji dewje te.» ");
INSERT INTO ksp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Rɔ nje-njaje goe te le neelde ang nyɔm, ngaa dunn kutu duje kara kara na: « To ema wa?» ");
INSERT INTO ksp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jeju pa arede na: « To kara lese, sese ke dɔku gire joo. Ne ke nula jia naate sem me sambe te neenn. ");
INSERT INTO ksp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ngonn le dew a koy ddew kara baa ke tar ke makuturu le Lubba pa dɔe te. A kem to ndoo a to le dew ke a kila Ngonn le dew ji dewje te. Duje ang kara maji nya uta. ");
INSERT INTO ksp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kare ke daw dusa ne a, Jeju unn mapa, ngaa are wooyo Lubba a, arede, a pa na: « E-taaje ne neenn, to da rɔm ann.» ");
INSERT INTO ksp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Goe te a, nunn engo-maann binye, ngaa nare wooyo lubba a narede nare dede tɔyn njaa dayje. ");
INSERT INTO ksp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jeju pa arede na: « Yeenn to mesem ann. To mese ke Lubba ɔsu ne dɔnɔ ke dewje ke banya are ungu nange mba kare tar majang lede ɔru ne dɔde te. ");
INSERT INTO ksp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","M-pa tar ke tɔkɔrɔ marese: Ma kay maann binye neenn ang ngaa ndereng ndɔ ke ma kay ne maann binye ke siki ke se me Bbe-kɔn te le Bɔmje. ");
INSERT INTO ksp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Dɔsuje pa wal Lubba, ngaa goe te a, n̂-teeje dawje dɔ ddingiri Olibeje te. ");
INSERT INTO ksp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jeju pa are nje njaje goe te na: « Sese tɔyn njaa a tusumje kiyamje. Mba n̂-dda me Maketuru te na: Ma tɔl nje-ngem bateje ta bateje le a sarenje naa kara kara. ");
INSERT INTO ksp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","A bbo mi horo dewje te ke oy a, ma kaw nginase Galile.» ");
INSERT INTO ksp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piyar pa are na : « Le dewje tɔyn tusije inyaije kara, ema, ma kinyai ang.» ");
INSERT INTO ksp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jeju pa are na : « Tɔkɔrɔ, m-pa mari, til te neenn njaa, kete bba kare kuran nɔ gɔl joo a, a mbetem gɔl mota pa na e-gerem ang.» ");
INSERT INTO ksp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","A Piyar tel pa are ngeng bbay na: « Le ase ta koy sei kara, ta pa na m-geri ang, ma pa baann ndɔ kara ang.» Ngaa keseje kara paje toke baann tɔ. ");
INSERT INTO ksp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jeju de ke nje-njaje goe te daw n̂-teeje lo te ke daw bbar na Jesetemane a n̂-pa narede na: « Maw ta duju Lubba, ta isije neenn.» ");
INSERT INTO ksp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","N̂-jin Piyar, Jake, de ke Jan naw ke de. Bbeel unn kutu ddae ddem, rɔe neele ang ddem. ");
INSERT INTO ksp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ngaa n̂-pa narede na: « Rɔm neelem ang toke ne ke ma ta koyjeenn. E-naynje neenn. Areje bbi ɔru kemse ang. ");
INSERT INTO ksp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Naw ddew ew ngaji, noso nangê ngaa n̂-duju Lubba kare bbo ddew to a, nuta kare ne-kem-to-ndoo te neenn ke dddang. ");
INSERT INTO ksp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","N̂-pa na: « Aba Bɔy, ei ase ta dda ne tɔyn, uta engo-kem-to-ndoo neenn mbɔrum te ke ddang. A e-dda ne ke mem ndiki ang, ne ke mei ei njaa ndiki a ta e-dda.» ");
INSERT INTO ksp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jeju tel ddee rɔ nje-njaje goe te ke mota le a, daw n̂-tibbije. N̂-pa nare Piyar na: « Simɔ, aw tibbi wa? Ase ta kisi kem baa mba gɔl kare kara be ang wa? ");
INSERT INTO ksp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Areje bbi ɔru kemse bbo e-dujuje Lubba kare osoje me ne-na te ang. Dew ee ke keje ta dda ne ke maji njaa, a da-rɔ ee ke singa ang.» ");
INSERT INTO ksp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jeju tel aw ddew ew, ngaa duju Lubba toke baann bbay. ");
INSERT INTO ksp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","N̂-tel n̂-ddee rɔ nje-njaje goe te le a, ningade dɔ bbi te bbay mba kemde kemde to bbi dɔrɔ. A n̂-gereje tar ke ta pa kare ang. ");
INSERT INTO ksp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","N̂-tel n̂-ddee ke gɔl mota laa a, n̂-dujude na: « E-naynje aw tibbije ngaa aw uwaje rɔse bbay wa? Bbaye ngaa, kare ase ngaa. Bbasine neenn, da kunn Ngonn le dew kulae ji nje-ne-ddaje te ke maji ang. ");
INSERT INTO ksp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Inje, jawje! Nje kunnum kulam jide te le ddee ngaa.» ");
INSERT INTO ksp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kare te ke Jeju nayn aw pa tar bbay a, kara le nje-njaje-goe te ke dɔku gire joo, ke ria na Judase ddee ke dewje banya banya. Duwaje tɔku kiyaje ke kakeje jide te. Tɔku nje-poloje Lubba, nje-kɔruje gel Ndu, ke tɔkuje le Jiipije a ulajede. ");
INSERT INTO ksp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judase nje kula Jeju me jide te le tɔjude gusu ke na dda ne. N̂-pa na: « Dew ke m-to mbiya a to ne ann. Uwaeje ta e-ngemeje ke maje awje saa.» ");
INSERT INTO ksp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kake n̂-ddee n̂-tee a, n̂-ngese ke rɔ Jeju te ngaa n̂-pa na: « Nje-ne-tɔju.» Ngaa n̂-to mbia. ");
INSERT INTO ksp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Yeenn ngaa, dewje le ilaeje Jeju le uwaeje. ");
INSERT INTO ksp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mare nje-nja-go Jeju te ɔru tɔku kiya ngaa tuka mbi nje-kula le tɔku nje-polo-Lubba ti. ");
INSERT INTO ksp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jeju pa arede na: « E-ddeeje ke tɔku kiyaje ke kakeje ta kuwam ne toke m-to nje kuwa ne le dewje ke singa wa? ");
INSERT INTO ksp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ke ndɔje tɔyn mee ke se key-polo-Lubba te maw m-tɔju ne a uwamje ang. A ne neenn to mba kare tar ke Maketuru le Lubba pa ddee to tar ke tɔkɔrɔ.» ");
INSERT INTO ksp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yeenn ngaa nje-njaje goe te tuseje inyaeje a aynje. ");
INSERT INTO ksp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mare basan unn go Jeju le, a bel a n̂-kiri ne rɔe. Da kuwae a, ");
INSERT INTO ksp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","n̂-tusu bel le ninya a nayn rɔe baa. ");
INSERT INTO ksp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Daw ke Jeju bbe le tɔku nje-polo-Lubba. Lo teenn, tɔku nje-poloje Lubba, tɔkuje le Jiipije, ke nje-kɔruje gel Ndu tɔyn mbɔnje naa. ");
INSERT INTO ksp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piyar inya are daw ke Jeju ddew ew a unn goe ndereng ande ne me ndoko te le tɔku nje-polo-Lubba. Nisi ke mbambaje lo teenn naw n̂-ndibbi puru. ");
INSERT INTO ksp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tɔku nje-poloje Lubba, ke dewje ke lo-sariya te le tɔyn, daw sangeje mare tar ta gange ne sariya yo dɔ Jeju te le a dingaje ang. ");
INSERT INTO ksp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Dewje nya paje tar-naji-ngemje dɔ Jeju te le, a tarje le awje go naa te ang. ");
INSERT INTO ksp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mareje inje ngaa ulaje tar ngemje ta Jeju te le paje na: ");
INSERT INTO ksp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","« Jo tae te njaa, n̂-pa na: ‹Ke-polo Lubba neenn, dewje a ddaje. Ma tuju ta dda mare ke dewje a ddaje ang me ndɔ mota te.› » ");
INSERT INTO ksp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","A dɔ tar te neenn le kara, tarje lede aw go naa te ang. ");
INSERT INTO ksp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Yeenn ngaa tɔku nje-polo-Lubba le in horo dewje te ngaa duju Jeju na: « Ila tar tar te le dewje ke aw undaje tar dɔi te neenn ang wa?» ");
INSERT INTO ksp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","A Jeju ar ddekeke, nila tar te kara ang. Tɔku nje-polo-Lubba le tel duje bbay na: « E-to Mesi, Ngonn le Lubba ke jaw jɔsu gaje le wa?» ");
INSERT INTO ksp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jeju ilae te na: « Yee njann, m-to Ngonne. A kooje Ngonn le dew ke isi dɔ ji-kɔl Lubba te. Na kin darâ me mum te ta ddee.» ");
INSERT INTO ksp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Yeenn ngaa Tɔku nje-polo-Lubba tiir kubbuje ke rɔe te ngaa pa na: « N̂-ndiki ta kinga nje-tar-najji bbay ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ooje taji ke n̂-taji Lubba neenn mban.» Tar ddi a ejeje dɔe te wa? Dede tɔyn n̂-gange sariyo yo dɔ Jeju te. ");
INSERT INTO ksp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mareje unnje kutu ti weren dɔe te. N̂-tɔje keme, n̂-bbirije jide n̂-tundae ne ngaa n̂-dujeje na: « Na undai neenn wa? E-pa are joo.» Mbambaje taaje Jeju ngaa tundaje ka mbɔre. ");
INSERT INTO ksp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kare ke Piyar nayn me ndoko te le beer bbay, a mare dene nje-kula le tɔku nje-polo-Lubba le ddee. ");
INSERT INTO ksp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kake noo Piyar ke aw ndibbi puru le a, naa keme ngaa n̂-pa na: « Ei kara e-nja ke Jeju dew ke Najarete le tɔ.» ");
INSERT INTO ksp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","A Piyar le mayn pa na: « M-gere ne ke a ta pa neenn ang, meje pin.» Goe te a, nin naw ta ndoko te, a kuran nɔ. ");
INSERT INTO ksp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","A dene nje-kula le oo Piyar le ngaa tel pa are dewje ke eeje teenn na: « Dew neenn to kara le nje-njaje go Jeju te.» ");
INSERT INTO ksp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","A Piyar tel mayn bbay. Mbɔr ang a, dewje ke eeje teenn tel paje areje Piyar bbay na: « A to kara lede njaa, mba ei kara e-to dew ke Galile tɔ.» ");
INSERT INTO ksp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","A Piyar unda yo tɔ ne guma ngaa pa na: « M-gere dingaw neenn ang.» ");
INSERT INTO ksp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kare teenn njaa, kunra nɔ ke gɔl joo laa. Yeenn ngaa me Piyar ole dɔ tar te ke Jeju pa are na: « Kete bba kare kuran nɔ gɔl joo a, a mayn gɔl mota pa na e-gerem ang.» Yeenn ngaa Piyar tee ke ngɔru ngaa uru dɔ nɔ te. ");
INSERT INTO ksp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ke esindɔ baa njaa, tɔku nje-poloje Lubba mbɔnje naa ke tɔkuje le Jiipije, nje-kɔruje gel Ndu, ke kese nje-gangeje sariya tɔyn ta koo ne ke ta dda. Dare n̂-tɔ Jeju, ngaa daw saa nɔ gɔl Pilate te. ");
INSERT INTO ksp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilate duju Jeju na :« E-to mbay le Jiipije wa?» Jeju le ilae te na: « Ye njaa e-pann.» ");
INSERT INTO ksp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tɔku nje-poloje Lubba undaje tarje nya dɔ Jeju te. ");
INSERT INTO ksp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilate tel duje bbay na: « Ila tar te kara ang wa? Oo tarje tɔyn ke dewje neenn undaje tai te neenn.» ");
INSERT INTO ksp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","A Jeju ila tar te kara ang. Are to ne ke kange singa Pilate. ");
INSERT INTO ksp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ke ndɔ kusu Pake kara kara tɔyn, ngonn-mbay le aw ɔru dew key-kula te. To dew ke dewje ke banya ndikije kare nɔre ");
INSERT INTO ksp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","A mare dew ke ria na Barabase ee key-kula te, de ke mare dewje ke tɔlje dew dɔ ndɔ te ke n̂-ddaje dɔ-ngeng ke nje-kɔn-bbeje. ");
INSERT INTO ksp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Yeenn a, dewje ke banya awje key le Pilate ngaa dujeje kare n̂-dda ne ke naw n̂-dda ke bbal kara kara narede le. ");
INSERT INTO ksp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilate ilade te na: « E-ndikije kare minya mbay le Jiipije le marese wa?» ");
INSERT INTO ksp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Mba Pilate gere ke maje to me a ddade dɔ Jeju te a duwaeje dulae jia teenn. ");
INSERT INTO ksp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","A tɔku nje-poloje Lubba ɔsuje kutu dewje ke banya kare duju Pilate are Barabase a ta nɔre narede. ");
INSERT INTO ksp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilate tel dujude bbay na: « Yeenn a, ddi a e-ndikije kare m-dda ke dew ke aw bbareje to mbay le Jiipije le wa?» ");
INSERT INTO ksp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","N̂-tel duruje ekii na: « E-tɔle dɔ kake-dese te.» ");
INSERT INTO ksp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilate dujude na: « Ddi ke maji ang a n̂-dda wa? A n̂-tel duru ekii dare ngeng na: « E-tɔle dɔ kake-dese te.» ");
INSERT INTO ksp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilate ndiki ta dda kare rɔ dewje ke banya le neelde. Yeenn ngaa nɔru Barabase key-kula te narede. Nare n̂-tunda Jeju ke ndey a nulae ji mbambaje te kare n̂-tɔle dɔ kake-dese te. ");
INSERT INTO ksp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Mbambaje awje ke Jeju me key te le ngonn mbay le ngaa bbarje kese mbambaje tɔyn. ");
INSERT INTO ksp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Dulae kubbu ke kase. Goe te a, n̂-pete kula ke to konn to ejɔkudɔ dunda dɔe te. ");
INSERT INTO ksp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Goe te a, n̂-ddaeje lapiya n̂-paje na: « Lapiya, Tɔku-mbay le Jiipije. ");
INSERT INTO ksp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","N̂-tunda dɔe ke kare, n̂-ti weren dɔe te, ngaa dɔsu mekeji gɔlde nangê a daw ke dɔde ndereng ta kɔsu ne nange. ");
INSERT INTO ksp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","N̂-kokoeje, ngaa dɔru kubbu ke kase le rɔe te a n̂-tel dulae kubbuje laa. Goe te a, n̂-tee saa daw ne ta kaw tɔle dɔ kake-dese te. ");
INSERT INTO ksp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mare dew ke Sirene ria na Simɔ, ke to bɔ Alekejandere de ke Rupusuje, in ndɔɔ aw nday a, duwae dare noto kake-dese le Jeju le. ");
INSERT INTO ksp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Daw ke Jeju le mare lo te ke daw bbar na Gologota. Kande ri le na « lo ka-dɔ dewje.» ");
INSERT INTO ksp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Dare maann binye ke dungu ne ke ria na mir me te kare nay, a n̂-mbete. ");
INSERT INTO ksp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","N̂-bbereje dɔ kake-dese te le ngaa goe te a, n̂-ddɔje mbari ta kaynje ne naa kubbuje laa ke dew kara kara a bu. ");
INSERT INTO ksp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","N̂-bbere dɔ kake-dese te ke kare ji-kara ke ke esindɔɔ. ");
INSERT INTO ksp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","N̂-dda mare makeruru n̂-bbere er dɔe te ta tɔju ne gel ne ke n̂-gange ne sariya dɔe te le na: Dew neenn to mbay le Jiipije.» ");
INSERT INTO ksp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","N̂-bbere nje-bbokoje joo dɔ kake-deseje te mbɔre te tɔ. Mare kara er kɔl, a mare kara er gel. ");
INSERT INTO ksp_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Yeenn bba, tar ke n̂-dda me Maketuru te le Lubba ddee ne to tar ke tɔkɔrɔ. Tar le na: « Dilae horo nje-tɔl dewje te.» ");
INSERT INTO ksp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Dewje ke aw ndayje loteenn tukaje dɔde a tajeje. N̂-paje dareje na: « Ei ke e-ndiki ta tɔ key-polo-Lubba ta tel dda mare ture te me ndɔ mota te le. ");
INSERT INTO ksp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ei njaa aji rɔi bbo in dɔ kake-dese te le uru nangê.» ");
INSERT INTO ksp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tɔku nje-poloje Lubba, ke nje-kɔruje gel Ndu kara aw kokoje Jeju horo naa te tɔ na: « Naji mare dewje, a nase kaji rɔe ne njaa ang wa! ");
INSERT INTO ksp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Maji kare ne ke n̂-to Mesi, Tɔku-mbay ke Ijarayel le n̂-ddisi dɔ kake-dese te nuru nangê. Yeenn bba joo a, ja koo meje te saa.» Dewje ke n̂-bberede dɔ kake-dese te mbɔre te le kara aw tajeje tɔ. ");
INSERT INTO ksp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Unn kute kare te ke ar dana ndereng gɔl kare mota ke lo-kul te, lo ndul dɔ nange te tɔyn. ");
INSERT INTO ksp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","A ta tee gɔl kare te ke mota a, Jeju uru ekii ke singa na: « Eli, Eli, lama sabakantani!» Kande tar le na: « Lubba lem, Lubba lem, e-tusum inyam mba ddi wa?» ");
INSERT INTO ksp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mare dewje eeje teenn ngaa ooje tar laa le a, paje na: « Naw n̂-bbar Eli.» ");
INSERT INTO ksp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mare dew kara horode te ayn ke ngɔru aw unn mare ta kubbu ula me maann binye te ke mase ngaa kee ta kare te a ula are Jeju kare ay, a pa na: « Inyaje, ja koo se Eli a ddee kɔre dɔ kake-dese te kilae nangê wa!» ");
INSERT INTO ksp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","A Jeju uru ekii ke singa ngaa uwa rɔe. ");
INSERT INTO ksp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kubbu ke n̂-tɔ n̂-gange ne me key-polo-Lubba tiir dana, in taar uru nangê. ");
INSERT INTO ksp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mbay le mbambaje ke Rɔm ke ar nɔ Jeju te le oo gusu ke Jeju le uwa ne rɔe le a, pa na: « Dew neenn to Ngonn le Lubba tɔkɔrɔ njaa.» ");
INSERT INTO ksp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mare deneje eeje teenn tɔ, darje ddew ew daw daaje lo. Mari ke Magadala, de ke Mari kɔn Jakeje ke Joseje, ke Salome deeje horode te. ");
INSERT INTO ksp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Lew denejeenn le njaje go Jeju te, ngaa ddaje saa kare te ke n̂-nayn ne Galile. Deneje banya banya ke awje saa Jurusalam eeje teenn tɔ. ");
INSERT INTO ksp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ndɔ mɔse rɔ ta ngina ne ndɔ-kuwa-rɔ a, lo-kul te, ");
INSERT INTO ksp_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Jejebbe ke to dew ke bbe te ke Arimate ddee tee. N̂-to kara le tɔkuje ke aw isije tɔku lo gange sariya te le Jiipije. Ne kara naw n̂-ngina kɔn-bbe le Lubba. Nuwa rɔe dingaw naw duju Pilate kare are niinn Jeju le. ");
INSERT INTO ksp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","A toke Pilate oo na Jeju le uwa rɔe mban a, tare gange singae. Yeenn ngaa nula n̂-bbar tɔku mbamba le dewje ke Rɔm ngaa n̂-duje se Jeju le uwa rɔe lew baa wa? ");
INSERT INTO ksp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tɔku mbamba ke Rɔm le pa tar yo le are. Yeenn ngaa nare ddew Jejebbe kare unn niinn le. ");
INSERT INTO ksp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jejebbe le ndoko bel-kubbu ke nda. Nɔru niinn le dɔ kake-dese te, n̂-ke ke kubbu le ngaa nila me buwa-yo te ke nare duru me er te. Goe te a, n̂-ndubbu mare er nutu ne ta buwa-yo le. ");
INSERT INTO ksp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari ke Magedala de ke Mari kɔn Joseje aw aaje lo ke dila niinn le ke te. ");
INSERT INTO ksp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Toke ndɔ-kuwa-rɔ le Jiipije nday a, Mari ke Magedala de ke Salome, ke Mari kɔ Jakeje, n̂-dokoje yamboje ta kungu dɔ ninn Jeju. ");
INSERT INTO ksp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ke esindɔɔ baa njaa, ke ndɔ-kuwa-rɔ ke kare aw tee a, dawje buwa-yo te. ");
INSERT INTO ksp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","N̂-dujuje naa na: « Na njaa bba a ndubbu tɔku er ke dutu ne ta buwa-yo le ke ddang kareje wa?» ");
INSERT INTO ksp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","A toke daaje lo a, tɔku er le toke ndubbu mban. ");
INSERT INTO ksp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Yeenn ngaa dandeje buwa-yo te le. A dooje mare basan ula kubbu ke ngal a nda, ngaa isi er kɔl, a bbeel ddade. ");
INSERT INTO ksp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","A basan le pa arede na: « Areje bbeel ddase ang. Aw sangeje Jeju ke Najarete ke n̂-tɔle dɔ kake-dese te le. N̂-ndol, nee neenn ang. Lo ke dilae ke te le a neenn. ");
INSERT INTO ksp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","A, aw paje areje Piyar, ke kese nje-njaje-goe te, e-paje na: « Na nginase Galile. Lo ke nunn a kooeje te, ddew kara baa toke n̂-pa narese.» ");
INSERT INTO ksp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Yeenn ngaa dinje buwa-yo te le n̂-teeje ddaka ngaa daynje dawje ddew ew mba disaje ngaa n̂-gereje ne ke ta dda ang. N̂-paje tar kara dare dew ang mba bbeel ddade nya. ");
INSERT INTO ksp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Go kin te ke Jeju in horo dewje te ke oy ke ndɔ-kuwa-rɔ ke esindɔɔ baa le a, n̂-tɔju rɔe dɔngɔr nare Mari ke Magedala ke n̂-tubba ndilje ke maji ang siri mee te le. ");
INSERT INTO ksp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Naw n̂-pa tare nare dewje ke aw njaje ke Jeju, kare te ke daw ndingaje ndoo ngaa daw nɔnje le. ");
INSERT INTO ksp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","A toke dooje tar le Mari ke pa na Jeju nayn kem baa, ngaa nooe le a, n̂-ndikije go tar te laa le ang. ");
INSERT INTO ksp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Goe te a, Jeju unn mare da-rɔ ke dang bba tɔju ne rɔe nare nje-njaje goe te joo ke aw awje ke ngonn bbe te. ");
INSERT INTO ksp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","N̂-tel n̂-ddee n̂-paje tare dare keseje. A dede kara n̂-ndikije te ke de ang tɔ. ");
INSERT INTO ksp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Dɔbɔyne a, n̂-tɔju rɔe nare nje-njaje goe te ke dɔku gire kara, ke aw usaje ne, ngaa n̂-kɔl ke de wɔju dɔ mede ke dunn dare Lubba ang ddem, wɔju dɔ me-ketere lede ddem. Mba, n̂-ndikije go tar te le dewje ke ooeje goe te ke nin ne horo dewje te ke oy le ang. ");
INSERT INTO ksp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ngaa n̂-pa narede na: « Awje dɔ nange te tɔyn ta ilaje mber Tar ke maji le areje dewje tɔyn. ");
INSERT INTO ksp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Dew ke oo mee te, ngaa n̂-ddae batem a, a kinga kaji. Dew ke oo mee te ang a, sariya dɔe te. ");
INSERT INTO ksp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ngaa, ne ke da gere ne dewje ke a kooje mede te a neenn: Da tubba ndilje ke maji ang ke rim, ngaa da paje ndɔn-tarje ke siki. ");
INSERT INTO ksp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Da Kuwaje lije ke jide. A bbo dayje ne ke kuma ke maji ang ee te a, ne kara a ddade ang. Da kila jide dɔ nje-rɔ-toje te, ta rɔ nje-rɔ-toje le a ddee maji.» ");
INSERT INTO ksp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Go tar te ke Ebbe-dewje Jeju pa arede toke baann a, Lubba unne aw ne dara, ngaa nisi dɔ ji-kɔle te. ");
INSERT INTO ksp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nje-njaje-go Jeju te aw ilaje mber-tar le loje te tɔyn. Ebbe-dewje umade kula teenn le are n̂-ddaje ne-mɔrije ta tɔju ne to tar ke daw dila mbere le to tar ke tɔkɔrɔ.");
INSERT INTO ksp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Dew ke bo Topil, mare neje ndayje horoje te ngaa dewje ke ooje neje le ke kemde kunn kute te njaa paje areje. Dede ke dooje neje le ke kemde le n̂-telje n̂-ddeeje to nje-paje tar le Lubba. Yeenn bba dewje nya unnje kutu ddaje maketuru, mba kɔru ne gel neje ke ndayje horoje te le. ");
INSERT INTO ksp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Goe te ke m-sange gel nejeenn le tɔyn ndereng ngirae te ke maje a, ema njaa kara moo maji ta kuja nejeenn le maketuru te kari, dew ke bo Topil, ");
INSERT INTO ksp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","mba kare e-gere to neje tɔyn ke n̂-tɔji, to neje ke tɔkɔrɔ. ");
INSERT INTO ksp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Bbal te ke *Erode to tɔku-mbay nange te ke Jude, mare *nje-polo Lubba ee teenn. Ria na Jakari, nee horo nje-poloje Lubba te ke gel Abiya te. Dene laa ria na Elijabete n̂-to dew ke gel Arɔn te. ");
INSERT INTO ksp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Dede joo kem n̂-toje gate gate kem Lubba te ngaa n̂-njaje ddew turu *ndu te le *Ebbe-dewje ddem. ");
INSERT INTO ksp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","A dujuje ngonn ang, mba Elijabete aw kate ngaa dede joo kem n̂-bbukaje nya. ");
INSERT INTO ksp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kare te ke Jakari aw dda kula nɔ gɔl Lubba te, mba to ndɔ ke kuwa-dɔ-naa* lede a dda kula a, ");
INSERT INTO ksp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ddew ne dda te le nje-poloje Lubba, *elemten oso dɔ Jakari te ta kare ande key-polo *Ebbe-dewje te, mba roo ubbu ke ete maji. ");
INSERT INTO ksp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Dewje ke banya areje ddaka aw dujuje Lubba kare te ke naw n̂-roo wubbu le. ");
INSERT INTO ksp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","A mare anji le *Ebbe-dewje tee inga Jakari, nare mbɔr *bann̂-roo-ubbu te le er kɔl. ");
INSERT INTO ksp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kake Jakari unn keme ooe a, mee sange ngaa bbel ddae nya. ");
INSERT INTO ksp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","A anji le pa are na: « Are bbel ddai ang Jakari, mba Lubba oo ndu nɔ lei. Dene lei Elijabete a kuju ngonn ke dingaw kari ngaa a kunda ria na Jan. ");
INSERT INTO ksp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","A to ne ke a kari koko ddem dewje nya a ddaje rɔ-nel ddem, mba ngonn ke da kuje le. ");
INSERT INTO ksp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mba na ddee bo nɔ *Ebbe-dewje te, koto ke to ben a kɔru tae ang ddem koto ke in a kɔru tae ang ddem, n̂-nayn me kɔenje te njaa bbay a, Ndil-me-nda a ddusu mee. ");
INSERT INTO ksp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Na dda bba kare ngann Ijarayelje telje ke rɔ *Ebbe-dewje te ke to Lubba lede. ");
INSERT INTO ksp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Na nja nɔ Lubba te ke ndil, ke singa le Eli ddem, mba turu me bɔje ke rɔ ngande te ddem na dda bba kare *nje-kal-taje telje unnje ddew kem-kare le dewje ke gate gate ngaa na mɔse dewje kare isije dɔ gɔlde te mba ngebbe *Ebbe-dewje.» ");
INSERT INTO ksp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jakari pa are anji le na: « Ddi a tɔjum to tar neenn to tɔkɔrɔ wa? Mba m-to bbuka ngaa dene lem bbale banya tɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Anji le tel ke tar are na: « Ema m-to Gabiriyel nje-kar nɔ Lubba te. Lubba ulam ta pa tar kari ngaa ta ndaji Tar ke Maji kari. ");
INSERT INTO ksp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Oo, gɔbbi a kutu ngaa a kuma ke pa tar pin ndereng ndɔ ke nejeenn le a teeje. Mba oo mei te ke tarje ke m-pa, ke mare ndɔ a ddee to tar ke tɔkɔrɔ le ang.» ");
INSERT INTO ksp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Dewje ke areje ddaka, aw ngebbeje Jakari sangeje mede, mba goe ew nya me key-polo-Lubba te. ");
INSERT INTO ksp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kake n̂-tee ddaka a, numa ke pa tar pin ngaa dewje le gereje to noo mare ne toke nin jeenn key-polo-Lubba te le. N̂-dda jia narede ngaa gɔbbe utu nyɔm. ");
INSERT INTO ksp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Toke ndɔ dda kula laa nunga a, n̂-tel naw key laa. ");
INSERT INTO ksp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Goe te ngaji a, dene laa Elijabete uwa sem. Niya rɔe ase nayn mi, n̂-pa na: ");
INSERT INTO ksp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","« Ne ke Ebbemje dda mbam kare te ke mee ndiki, ta kɔru ne ne-rɔ-kul lem kem dewje te a neenn.» ");
INSERT INTO ksp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elijabete uwa sem ke nayn misan a, Lubba tel ula anji laa Gabere mare bbe te ke ria na Najarete nange te ke Galile. ");
INSERT INTO ksp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nulae rɔ ngonn ke dene te ke gere ngaw ang bbay, ke to nje-mɔrɔ le Jejebbe, ngonn ke gel Dabbiti te. Ri ngonn ke dene ke gere ngaw ang bbay le na Mari. ");
INSERT INTO ksp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Anji le ande dɔe te ngaa pa na: « M-ddai lapiya, ei ke Lubba dda sei me maji. Ebbe-dewje ee sei.» ");
INSERT INTO ksp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Me Mari sange ngaa neje n̂-pa na: « Lapiya ddi a toke be neenn wa?» ");
INSERT INTO ksp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Anji le pa are na: « E-bbel ang Mari, mba me-maji le Lubba to dɔi te. ");
INSERT INTO ksp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Oo, a kuwa sem, a kuju ngonn ke dingaw ngaa a kunda ria na Jeju. ");
INSERT INTO ksp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ngonn le a ddee bo ngaa da bbare na Ngonn le *Ne ke ddutu dara te ngaa *Ebbe-dewje Lubba a kare ngende-mbay le bɔeje Dabbiti. ");
INSERT INTO ksp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Na kɔn dɔ nje ke gel Jakobbo te bbal ke bbal ngaa *kɔn̂-bbe laa a kɔsu kɔyn ndɔ kara ang.» ");
INSERT INTO ksp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari pa are nje-kula le na: « Neenn le a ddee toke baann wa? Mba m-gere ngaw ang bbay.» ");
INSERT INTO ksp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Anji le tel ke tar are na: « Ndil-me-nda a ddee dɔi te ngaa ndil singa-mɔngu le *Ne ke ddutu dara te a debbe dɔi te. Gele ke neenn bba Ngonn ke maji tɔyn ke a kuje le, da bbare na Ngonn le Lubba. ");
INSERT INTO ksp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Oo, nuju lei Elijabete ke bbuka nya njaa kara uwa sem are ne ke daw n̂-bbare na nje-kuju-ang le, nisi ke sem ke nayn misan ngaa. ");
INSERT INTO ksp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Mbata ne nya Lubba ndɔ kara ang.» ");
INSERT INTO ksp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mari pa na: « M-to bbere le *Ebbe-dewje. Maji kare ne tɔyn ke Lubba ndiki ta dda ddew te lem ddee dɔm te toke ndui pa.» Ngaa anji le inyae a ɔtu. ");
INSERT INTO ksp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Me ndɔje teenn Mari in taar ngaa unn ddew ke ngɔru aw ke dɔ ddingirije te mare bbe te ke Juda. ");
INSERT INTO ksp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nande key le Jakari ngaa n̂-dda lapiya Elijabete. ");
INSERT INTO ksp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kake Elijabete oo ndu Mari ke are ne lapiya le a, ngonn ke mee te in njururu. Ndil-me-nda ddusu me Elijabete, ");
INSERT INTO ksp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","a uru eki ke taar pa na: « Lubba bbar Tar ke Maji dɔi te horo deneje te tɔyn, Tar ke Maji laa to dɔ ngonn te ke a kuje le ddem! ");
INSERT INTO ksp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ema neenn m-to dew ddi bba kɔn Ebbemjeje ddee rɔm te wa? ");
INSERT INTO ksp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mbata oo, kake moo ndui ke arem ne lapiya le a, ngonn ke mem te in njururu ke rɔ-nel. ");
INSERT INTO ksp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Koko ee ke dene ke oo mee te to tar ke *Ebbe-dewje are n̂-pa dare, a ddee to tar ke tɔkɔrɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mari pa na: « Mɔsu gaji *Ebbe-dewje ");
INSERT INTO ksp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ddem, m-dda rɔ-nel wɔju dɔ Lubba ke Nje-kajim, ");
INSERT INTO ksp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","mba nunn keme noo ne bbere dene laa ke to ne ang. Tɔkɔrɔ njaa, a kunn kute bbokone, gel-dewje tɔyn a bbaremje to dene ke isi ke koko, ");
INSERT INTO ksp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","mba *Nje-singa-mɔngu dda neje ke bo nya wɔju dɔm, ria na Nje-me-nda. ");
INSERT INTO ksp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Me-maji laa to ke ndɔ ke ndɔ mba dewje tɔyn ke aw ddaje bbel laa. ");
INSERT INTO ksp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","N̂-tɔju singa-mɔngu laa ke jia. N̂-sane dewje ke isije ke keje koo-rɔ-bo kara kara. ");
INSERT INTO ksp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nunda tɔku mbayjeje nangê ngaa nuwa ji nje ke mede to me ngonn̂-kase ke taar. ");
INSERT INTO ksp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nare ne-kinga nje ke bbo ddade ngaa n̂-tubba nje-ne-kingaje jide baa. ");
INSERT INTO ksp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Numa bbereje laa ngann Ijarayelje, mba nole mee dɔ me-maji te laa, ");
INSERT INTO ksp_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","toke n̂-pa nare bɔjeje -ddew te le Abaraham ke ngann mee ke ndɔ ke ndɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari dda ase nayn muta rɔ Elijabete te bba tel aw bbê laa. ");
INSERT INTO ksp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kare kuju le Elijabete ase ngaa nuju ngonn ke dingaw. ");
INSERT INTO ksp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nje-nin̂-key mareje ke nje-nujuje laa ooje tar me-maji ke *Ebbe-dewje dda saa a, n̂-ddaje rɔ-nel saa tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ndɔ jijoo goe te ke duju ngonn le a, n̂-ddeeje ke ngonn̂-ngutay le mba kuja mɔte ngaa n̂-ndikije ta kunda ri bɔeje Jakari dɔe te. ");
INSERT INTO ksp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","A kɔenje pa na: « Baann ang, ria na Jan.» ");
INSERT INTO ksp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Dewje le paje na: « Mare dew kara ke ria toke baann goto horo nujuje te lei.» ");
INSERT INTO ksp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ngaa n̂-ddaje jide dare bɔeje, mba gere se ri ke baann a na kunda dɔ ngonn te le wa? ");
INSERT INTO ksp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jakari duju bekere maketuru ngaa uja maketuru ke te na: « Ria na Jan.» Tar nya dewje tɔyn. ");
INSERT INTO ksp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kare teenn njaa gɔbbe uja, ndɔen tutu. N̂-pa tar ngaa nɔsu gaji Lubba. ");
INSERT INTO ksp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bbel dda dewje tɔyn ke ddaje bbe mbɔrde te ddem, dewje tɔyn ke isije dɔ ddingirije te ke dɔ nange te ke Jude ddem. Daw n̂-paje tar wɔju dɔ neje ke tee le. ");
INSERT INTO ksp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Dewje tɔyn ke tar le oso mbide te, aw ejeje dɔe te ngaa paje na: « Ngonn neenn a to dew ddi a neenn wa? Toke tɔkɔrɔ njaa ji *Ebbe-dewje to dɔe te.» ");
INSERT INTO ksp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ndil-me-nda ddusu me bɔeje Jakari ngaa n̂-ndaji tar le Lubba toke be: ");
INSERT INTO ksp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","« Jɔsuje gaji *Ebbe-dewje, Lubba le Ijarayel, mba n̂-ddee numa dewje laa ddem nuka dɔde ddem. ");
INSERT INTO ksp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ngaa nareje Nje-kaji-dewje ke ngeng, ke in gel bbere te laa Dabbiti, ");
INSERT INTO ksp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","toke n̂-pa tare lew baa ddew te le nje-kilaje-mber-tar laa ke maji tɔyn, ");
INSERT INTO ksp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","tar tee leje ji nje-baanji te ddem, ji dewje te tɔyn ke mede mbeteje ddem, ");
INSERT INTO ksp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","mba n̂-dda me-maji ke bɔjeje ddem, nole mee dɔ *kɔsu-dɔnɔ te laa ke maji tɔyn ke bɔjeje ddem, ");
INSERT INTO ksp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ddew kara baa ke ndue ke nunn wɔju dɔ bɔjeje Abaraham. ");
INSERT INTO ksp_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Yeenn bba goe te ke nɔruje ji nje-baanji te a, nareje ddew ta kare n̂-dda saa ke bbel ang, ");
INSERT INTO ksp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ddew ne te ke maji tɔyn, ke ne ke to gate gate keme te, me ndɔje te leje tɔyn ke dɔ nange te. ");
INSERT INTO ksp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A ei, ngonn ke ngaji, da bbari na nje-kila mber-tar le *Nje-kisi ddutu dara te. Mba a nja nɔ *Ebbe-dewje te ta dda ddewje laa. ");
INSERT INTO ksp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ta tɔju dewje laa tar kaji ddew kɔru tar *majangje lede dɔde te. ");
INSERT INTO ksp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ddew me-maji te ke bo le Lubba leje, ddew me-maji teenn le bba, bbo kare ubba me dara te a, a kuru dɔje te, ");
INSERT INTO ksp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","mba kare nje ke isije me til te ke nje ke isije me yo te, kemde uja. Ddem mba tɔjuje ddew ke ja kinga ne *me-wul-lɔm tɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ngonn ke ngaji le aw tee ke mbi ddem, keje laa aw sange ddem. N̂-nayn me kɔr te ndereng ndɔ te ke naw n̂-tɔju rɔe nɔ ngann Ijarayelje te. ");
INSERT INTO ksp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Me bbale teenn, tɔku-mbay ke boy Sejar Ogusute unn ndu kare dewje tɔyn undaje ride maketuru te, mba gere ne kɔr dewje ke isije nange te le Romeje. ");
INSERT INTO ksp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Dɔngɔr tura kɔr dewje le, to bbal te ke Kirinusu to nje-kɔn dɔ nange ke Siri. ");
INSERT INTO ksp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Na na kara tel bbe kuje te njaa, mba kunda ria me maketuru te. ");
INSERT INTO ksp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jejebbe kara in bbe te ke ria na Najarete, nange te ke Galile, aw bbe te ke ria na Betelehem, nange te ke Jude, mba n̂-to ngonn ke key le Dabbiti ddem gele in me nuju te le Dabbiti njaa tɔ, ");
INSERT INTO ksp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","mba kare dunda ria maketuru te, de ke nje-mɔrɔ laa Mari ke uwa sem. ");
INSERT INTO ksp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Toke n̂-nayje teenn bbay a, kare kuju le Mari ase. ");
INSERT INTO ksp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nuju ngonn dere to dingaw. N̂-ke ngonn le ke kubbu ngaa nilae me *ne-kusa-ne te le daje, mba lo-to goto key-to nje-mbaje te. ");
INSERT INTO ksp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nange te ke Betelehem teenn, nje-ngem-daje isije mû aw ngemje daje lede til te. ");
INSERT INTO ksp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mare anji tee ingade, a ndoko le *Ebbe-dewje uru dɔde te. Bbel ddade nya. ");
INSERT INTO ksp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ngaa anji le pa arede na: « Areje bbel ddase ang. Mba m-ddee ta ndaji Tar ke Maji ke a kare koko dewje tɔyn. ");
INSERT INTO ksp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Bbokone duju Nje-kaji-dewje darese me bbe te le Dabbiti, n̂-to Kiriste, Ebbe-dewje. ");
INSERT INTO ksp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ne ke a gereje ne toke be. A kooje ngutay ke n̂-ke ke kubbu a dilae me *ne-kusa-ne te le daje.» ");
INSERT INTO ksp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kem naa te neenn a, *nje-ddɔje ke darâ banya banya teeje ingaje anji le, dɔsuje gaji Lubba, n̂-paje na: ");
INSERT INTO ksp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","« Piti to le Lubba me dara te nu, ke *me-wul-lɔm to dɔ nange te, horo dewje te ke mee ndikide!» ");
INSERT INTO ksp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Toke anjije inyajede mba tel ke darâ a, nje-ngem-daje le paje tar horo naa te na: « Areje jawje ndereng Betelehem, jooje ne ke tee bbe te, ne ke Lubba tɔjuje.» ");
INSERT INTO ksp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Dɔtuje ke ngɔru dawje ngaa dingaje Mari de ke Jejebbe, ke ngonn ngutay le, ke dilae me *ne-kusa-ne te le daje. ");
INSERT INTO ksp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Toke dooeje mbaan, dɔruje gel tar ke anji pa arede wɔju dɔ ngonn neenn le. ");
INSERT INTO ksp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Dewje tɔyn ke ooje tar le nje-ngem-daje ke paje le, tar nyade tɔyn. ");
INSERT INTO ksp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mari ngem nejeenn tɔyn mee te, naw neje dɔe te tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ngaa nje-ngem-daje le ɔsuje gaji Lubba, ke waleje telje ne ke mû, mba ne tɔyn ke dooje ke mbide ddem, ke kemde ddem, to ddew kara baa toke anji pa arede. ");
INSERT INTO ksp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Toke ndɔ jijoo goe te ke duju ngonn le ase mbaan, dujaje mɔte ngaa dundaje ria na Jeju, ri ke anji bbar arede kete bba kare kɔenje uwa sem laa. ");
INSERT INTO ksp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ngaa ndɔ toko yerew lede go kuju te le Mari le ase toke *ndu le Moyije pa a, dawje ke ngonn le Jurusalam mba kare *Ebbe-dewje, ");
INSERT INTO ksp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ddew kara baa, ke *ndu ke *Ebbe-dewje unn me Maketurute na: « Ngann dereje tɔyn ke dingaw da kunnde kare *Ebbe-dewje.» ");
INSERT INTO ksp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ddem dawje mba kare engɔruje joo, wase ngann derje joo to *ne-polo Lubba ddew kara baa toke *ndu le *Ebbe-dewje pa me Maketurute. ");
INSERT INTO ksp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mare dingaw kara ria na Simeyɔn isi bbe te ke Jurusalam teenn. Dingaw le to gate gate ddem n̂-ngem ddew laa ddem. Naw n̂-ngebbe dew ke a ddee wul me ngann Ijarayelje ngaa Ndil-me-nda ee saa tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ndil-me-nda pa are kete na: « Na koo Kiriste ke *Ebbe-dewje a kulae bba na koy.» ");
INSERT INTO ksp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ndil le unda mee are n̂-ddee *key-polo-Lubba te ngaa toke Jejebbe de ke Mari n̂-ddeeje ke ngonn ke to Jeju mba dda ne wɔju dɔe ddew kara baa toke *ndu pa a, ");
INSERT INTO ksp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeyɔn le tae uwae jia te ngaa ɔsu gaji Lubba pa na: ");
INSERT INTO ksp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","« Bbasine, Ebbemje, inya bbere lei are aw toke ndui pa. ");
INSERT INTO ksp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Mba kem oo kaji lei, ");
INSERT INTO ksp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ke e-gɔl lew baa mba dewje tɔyn, ");
INSERT INTO ksp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","to lo-kare ke a kɔru kem dewje ke dɔ nange te ke toje *Jiipije ang ddem, to ne ke a kɔsu gaji ngann Ijarayelje ddem.» ");
INSERT INTO ksp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tar ke dewje aw paje dɔ ngonn te le are koko bɔeje ke kɔenje. ");
INSERT INTO ksp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeyɔn bbar Tar ke Maji dɔde te ngaa pa are Mari kɔn Jejuje le na: « Oo, ddew te le ngonn neenn, mare dewje nya a kosoje ke mareje nya a kinje taar horo ngann Ijarayelje te ddem, na to ne ke a ddee ke mayn̂-naa-tar ddem, ");
INSERT INTO ksp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","bba kare ne ke dewje aw ejeje mede te, tee ke ddaka. A ei njaa kara tɔku kiya a riya dɔ bbengiri.» ");
INSERT INTO ksp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ana ke to dene nje-kila mber-tar le Lubba ee Jurusalam teenn tɔ. N̂-to ngonn le Panuwel, dew ke gel Aser te. Bbale banya. N̂-taa ngaweje n̂-dda saa bbal siri a, ngaweje le oy. ");
INSERT INTO ksp_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","N̂-tɔ wure nisi to dene-ndubba ndereng bbal kuje ase dɔjijoo gire sɔ. Ninya key-polo-Lubba ndɔ kara ang ddem naw dda ke Lubba til ke kare ddew mbete ne-kusa te ke duju Lubba te. ");
INSERT INTO ksp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kare teenn njaa ne kara n̂-tee ningade. Nɔsu gaji Lubba ngaa n̂-pa tar le Jeju nare dewje tɔyn ke aw ngebbeje tee le Jurusalam kɔ bbere te. ");
INSERT INTO ksp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Goe te ke Jejebbe de ke Mari n̂-ddaje ne tɔyn ke *ndu le *Ebbe-dewje pa le a, n̂-telje lo kiside te Najarete nange te ke Galile. ");
INSERT INTO ksp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ngonn le aw tee ke mbi ddem, aw ubba singa ddem. Keme are nya, me-maji le Lubba to dɔe te tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ke bbal kara kara tɔyn bɔ Jejuje ke kɔn Jejuje dawje *kusu *Pake te Jurusalam. ");
INSERT INTO ksp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Toke Jeju inga bbal dɔku gire joo a dawje saa *kusu te le, toke *Jiipije aw ddaje ke bbal tɔyn. ");
INSERT INTO ksp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Goe te ke ndɔ *kusu le nday mbaan, n̂-telje ke bbê ngaa, ngonn ke to Jeju le nay laa Jurusalam a, kɔenje ke bɔeje n̂-gereje ang. ");
INSERT INTO ksp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Dejeje to n̂-nay ke nje-buwa-kaw-loje lede. N̂-jaje dda ndɔ kara bba dunnje kutu sangeje horo nje-nujuje te lede ke horo dewje te ke n̂-gerejede. ");
INSERT INTO ksp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Dingaje ngonn le ang ngaa n̂-sangeje n̂-telje ne ke Jurusalam. ");
INSERT INTO ksp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Dda ndɔ muta bba dingaeje me key-polo-Lubba te, nisi danna horo *nje-kɔruje-gel-ndu te, naw noo tar lede ddem, naw n̂-dujude tar ddem. ");
INSERT INTO ksp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ne-gere laa ke tarje ke naw n̂-tel ne dda bbel dewje tɔyn ke aw ooje tar laa. ");
INSERT INTO ksp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kake kɔenje de ke bɔeje dundaje kemde dooeje a, dareje baa nding. Kɔenje duje tar na: « Ngonnum, mbata ddi njaa bba e-dda ke je ne toke be wa? Oo, ema ddem bɔije ddem jaw n̂-sangi ke me-kɔn.» ");
INSERT INTO ksp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","N̂-tel ke tar narede na: « Aw e-sangemje mba ddi wa? E-gereje to, to tar lem ta dda kula le Bɔmje ang wa?» ");
INSERT INTO ksp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","A dede n̂-gereje dɔde tar te ke n̂-pa narede le ang. ");
INSERT INTO ksp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Goe te a, n̂-tee naw ke de ke Najarete. Noo tade. Kɔenje ngem nejeenn tɔyn mee te. ");
INSERT INTO ksp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jeju aw tɔku ddew kem-kare te, naw n̂-gal ngaa, n̂-ddee maji kem Lubba te ke kem dewje te tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tibere Sejar ɔn bbe bbal dɔku gire mi. Me ddutu bbale teenn, Pɔnse Pilate to nje-kɔn̂-bbe dɔ nange te ke Jude ngaa *Erode to *ngonn̂-tɔku-mbay nange te ke Galile, Pilipi ngokɔn *Erode le to *ngonn̂-tɔku-mbay ke Iture nange te ke Tarakonite, Lijaniase to *ngonn̂-tɔku-mbay ke Abilene, ");
INSERT INTO ksp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ddem me ndɔ te ke Ana de ke Kayipi n̂-toje to tɔku nje-poloje Lubba. Tɔ ndɔe teenn a, Lubba pa tar ke Jan ngonn le Jakari me kɔr te. ");
INSERT INTO ksp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yeenn bba Jan nja ke me bbeje kara kara tɔyn ke guku dɔ ba Juruden, mba kila mber-tar batem turu me, mba kɔru tar dɔ dew te, wɔju dɔ ne-ddaje ke maji ang. ");
INSERT INTO ksp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ddew kara baa toke n̂-dda tare me maketuru te le Ejayi *nje-kila mber-tar le Lubba na: « Mare dew aw ila mber me kɔr te: E-mɔseje ddew le *Ebbe-dewje, areje ngann kila ddewje laa ndɔju, ");
INSERT INTO ksp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","wel-maannje a kutu, ddingirije ke dɔ-kubbaje kara kara tɔyn a ddom, ne ke dduku a ndɔju. Ngaa ngann ddewje ke to buwa a kaseje naa, ");
INSERT INTO ksp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","baann bba na na kara a koo kaji le Lubba.» ");
INSERT INTO ksp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jan pa tar ke dewje ke banya ke ddeeje mba kare ddade batem na: « Ko mbakaraje, na njaa bba tɔjuse ddew kayn wungu ke aw ddee wa? ");
INSERT INTO ksp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Areje kula ddase tɔju to e-turuje mese mban ngaa ewje rɔse ta pa na: Abaraham to bɔjeje! Yeenn a m-pa marese to Lubba ase ta dda kare erje neenn turuje telje to ngann le Abaraham. ");
INSERT INTO ksp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Dila tina gel kakeje te mban, da tuka kake kara kara tɔyn ke ande kande ke maji ang mba kungu kem puru te.» ");
INSERT INTO ksp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dewje ke banya le dujeje tar na: « Ddi bba to maji kareje n̂-dda ngaa neenn wa?» ");
INSERT INTO ksp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","N̂-tel ke tar narede na: « Maji kare dew ke ee ke kubbu ke taar joo a unn kara are dew ke kubbu due, a bbo dew ke ee ke ne-kusa a dda toke baann tɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nje-taaje nare *lambo ke ddeeje mba kingaje batem tɔ dujeje tar na: « Nje-ne-tɔju, ddi a to maji kareje n̂-dda wa?» ");
INSERT INTO ksp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","N̂-tel ke tar narede na: « E-dujuje ne ke uta dɔ ndu ke darese ang.» ");
INSERT INTO ksp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mbambaje kara dujeje na: « Ngaa jeje, ddi bba to maji kareje n̂-dda wa?» N̂-tel ke tar narede na: « Uwaje dew ke singa e-taaje ne laa ang ddem, ulaje tar ta dew te baa ang ddem, a maji kare ta undaje mese dɔ nare kunnse te njaa.» ");
INSERT INTO ksp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mbata dewje le isije ke me-ngebbe ddem le ngaa, daw dejeje tar mede te ta gere se Jan njaa to Kiriste wa? ");
INSERT INTO ksp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","N̂-tel ke tar narede tɔyn na: « Ema, ma ddase batem maann. A mare dew ke ngeng utam ke ma kase tutu kula endaar ke gɔle te ang aw ddee. Ne a na ddase batem Ndil-me-nda ke batem puru tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nuwa bagiri laa jia te. Na kuta bbal laa ngaa na jin waa kungu me dam te laa a, na roo tisa kem puru te ke a koy ndɔ kara ang.» ");
INSERT INTO ksp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Toke baann bba, Jan aw tɔju tar-maji dewje, ke are mare ndejeje dang dang. ");
INSERT INTO ksp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","A, *ngonn̂-tɔku-mbay *Erode ke Jan ndange wɔju dɔ Herodiyade, dene le ngokɔen ddem wɔju dɔ kulaje ke maji ang dang dang ke *Erode le dda ddem, ");
INSERT INTO ksp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","dɔe te nuwa Jan le nilae key-kula te. ");
INSERT INTO ksp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Go batem te ke Jan dda dewje tɔyn a, Jeju kara n̂-ddae batem tɔ. Kake Jeju aw duju Lubba bbay a dara teyn, ");
INSERT INTO ksp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ngaa Ndil-me-nda ke unn da rɔ toke mare le der ddisi dɔe te. Ngaa mare ndu in darâ pa na: « E-to Ngonn̂-ndiki lem! Misi ke koko nya wɔju dɔi.» ");
INSERT INTO ksp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Bbal Jeju ase ne ke bbal dɔ muta bba a unn kutu kula laa, a dewje ejeje to, n̂-to ngonn le Jejebbe, ngonn le Heli, ");
INSERT INTO ksp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ngonn le Matate, ngonn le Lebi, ngonn le Meleki, ngonn le Jannai, ngonn le Jejebbe, ");
INSERT INTO ksp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ngonn le Matatiyase, ngonn le Amose, ngonn le Nahum, ngonn le Eseli, ngonn le Nagay, ");
INSERT INTO ksp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ngonn le Maate, ngonn le Matatiyase, ngonn le Semeyinn, ngonn le Joje, ngonn le Joda, ");
INSERT INTO ksp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ngonn le Joyana, ngonn le Reja, ngonn le Jorobabel, ngonn le Kelatiyel, ngonn le Neri, ");
INSERT INTO ksp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ngonn le Meleki, ngonn le Adi, ngonn le Kosam, ngonn le Elemadam, ngonn le Er, ");
INSERT INTO ksp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ngonn le Jeju, ngonn le Eliyejer, ngonn le Jorim, ngonn le Matate, ngonn le Lebi, ");
INSERT INTO ksp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ngonn le Simeyɔn, ngonn le Juda, ngonn le Jejebbe, ngonn le Jonam, ngonn le Eliyakim, ");
INSERT INTO ksp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ngonn le Meleya, ngonn le Mena, ngonn le Matata, ngonn le Natan, ngonn le Dabbiti, ");
INSERT INTO ksp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ngonn le Ijayi, ngonn le Obede, ngonn le Bowaje, ngonn le Salmɔ, ngonn le Nasɔn, ");
INSERT INTO ksp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ngonn le Aminadabe, ngonn le Adimini, ngonn le Arini, ngonn le Heteserɔn, ngonn le Perete, ngonn le Juda, ");
INSERT INTO ksp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ngonn le Jakobbo, ngonn le Ijake, ngonn le Abaraham, ngonn le Tera, ngonn le Nahɔr, ");
INSERT INTO ksp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ngonn le Serugu, ngonn le Rehu, ngonn le Pelege, ngonn le Heber, ngonn le Kila, ");
INSERT INTO ksp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ngonn le Kayinam, ngonn le Arepakesade, ngonn le Sem, ngonn le Nowe, ngonn le Lemeke, ");
INSERT INTO ksp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ngonn le Matusalam, ngonn le Henɔku, ngonn le Jerede, ngonn le Maleleyel, ngonn le Kenam, ");
INSERT INTO ksp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ngonn le Enosu, ngonn le Sete, ngonn le Adam, ngonn le Lubba. ");
INSERT INTO ksp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Toke Ndil-me-nda ddusu me Jeju a, nin Juruden te n̂-tel. Ndil le ɔre aw saa me kɔr te. ");
INSERT INTO ksp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Esu nae nunn mba ndɔ dɔsɔ. Me ndɔje teenn tɔyn Jeju usa ne ang. Toke ndɔje le tɔyje a, bbo ddae. ");
INSERT INTO ksp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Esu pa are na: « Bbo e-to Ngonn le Lubba tɔkɔrɔ a, unn ndui are er neenn tel ne-kusa.» ");
INSERT INTO ksp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jeju tel ke tar are na: « Maketuru le Lubba pa na: Dew a kisi ke tebbe ddew ne-kusa te kara baa ang.» ");
INSERT INTO ksp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Esu aw saa dɔ ddingiri te ke ndew a, kem naa te neenn tɔje *bbe-kɔnje tɔyn ke dɔ nange te. ");
INSERT INTO ksp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Esu pa are na: « Ma kari singa-mongu ke kɔsu-gaji dɔ *bbe-kɔnje te neenn, mba darem nejeenn tɔyn, are misi ke ddew ta kare dew toke mem ndiki. ");
INSERT INTO ksp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Bbo ɔsu gɔli nɔm te a, nejeenn tɔyn a to lei.» ");
INSERT INTO ksp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jeju tel ke tar are na: « Maketuru le Lubba pa na: *Ebbe-dewje, Lubba lei kara baa a, a kɔsu gɔli nɔe te ngaa a pole.» ");
INSERT INTO ksp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Esu aw saa Jurusalam tɔ, aw undae taar dɔ key-polo-Lubba te le *Jiipije a, pa are na: « Bbo e-to Ngonn le Lubba tɔkɔrɔ a, aal uru nangê, mba Maketurule Lubba pa na: ");
INSERT INTO ksp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Lubba a kunn ndu kare anjije laa ngemi. ");
INSERT INTO ksp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Da kotoi dɔ jide te, mba kare unda gɔli er te ang.» ");
INSERT INTO ksp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jeju tel ke tar are na: « Maketuru le Lubba pa na: A na *Ebbe-dewje ke to Lubba lei ang.» ");
INSERT INTO ksp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Toke Esu nae ke ddew dang dang pin a, ɔtu inyae mba mare ndɔ. ");
INSERT INTO ksp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jeju tel aw Galile, ke singa-mɔngu le Ndil-me-nda ngaa ria bbar dɔ nange teenn tɔyn. ");
INSERT INTO ksp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Naw n̂-tɔju ne me key-mbɔn̂-naaje te lede ngaa dewje tɔyn ɔsuje gaje. ");
INSERT INTO ksp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jeju aw Najarete bbe te ke n̂-ngeme ke te. Naw key-mbɔn naa te le *Jiipije ke *ndɔ-kuwa-rɔ, toke naw n̂-dda ke *ndɔ-kuwa-rɔje tɔyn. Nin taar ta tura Maketurua, ");
INSERT INTO ksp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","dare maketuru le Ejayi nje-kila mber-tar le Lubba. N̂-teyn mee ngaa ninga lo ke Maketurule pa ke te na: ");
INSERT INTO ksp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","« Ndil le *Ebbe-dewje to dɔm te, mba nungu wubbu dɔm te kare mila mber-Tar ke Maji mare nje-ndooje. Nulam kare m-ndaji mare bbereje tar tee lede bbe bbere te ke nje-kem-tɔje to da telje kooje lo, dewje ke dulaje kemde ndoo a teeje kɔ bbere te. ");
INSERT INTO ksp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ta ndaji kare dewje, bbal ke *Ebbe-dewje a ta dda me-maji ke de.» ");
INSERT INTO ksp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Goe te a, Jeju unda Maketurule naa te, tel ne are nje-kula ke key-mbɔn̂-naa te le ngaa isi nangê. Kem dewje tɔyn ke isije me key-mbɔn̂-naa te le to ke dɔe te. ");
INSERT INTO ksp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","N̂-pa tar narede na: « Bbokone, tar ke me Maketurute ke ooje ke mbise neenn, ddee to ne ke tɔkɔrɔ ngaa.» ");
INSERT INTO ksp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Dewje tɔyn ɔsuje gaje ngaa Tar ke Maji tɔyn ke aw tee tae te arede bbel ngaa n̂-paje na: « Ngonn neenn to ngonn le Jejebbe ang wa?» ");
INSERT INTO ksp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jeju pa arede na: « A du ang, a paje kɔn̂-tar neenn karemje: Nje-kɔru rɔ-to rɔ dewje te, ei njaa ɔru rɔ-to rɔi te. Neje tɔyn ke e-dda Kapernayum a joo tare le, e-dda bbe lei neenn tɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jeju tel pa arede na: « Tɔkɔrɔ m-pa marese: Dewje isije ke koko ta kuwa *nje-kila mber-tar le Lubba ke rɔde te bbe kuje te njaa ang. ");
INSERT INTO ksp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","M-pa tar ke tɔkɔrɔ marese: Bbal ke Eli to *nje-kila mber-tar le Lubba, bba ndi ere ang bbal muta ke neyn misan, are bbo oso dɔ nange te tɔyn. Bbale teenn dene-ndubbaje bakaje nya nange te ke Ijarayel. ");
INSERT INTO ksp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Lubba ula Eli rɔ mare dene-ndubba te kara horode te ke Ijarayel ang, a mare dene-ndubba ke Sarepeta, nange te ke Sidɔn a Lubba ula Eli rɔe te. ");
INSERT INTO ksp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Bbal te le Elije, *nje-kila mber-tar le Lubba, nje-banjije bakaje nya nange te ke Ijarayel. Elije ɔru banji le dew kara horode te ang, a Nama ke to dew ke Siri a nɔru banji laa.» ");
INSERT INTO ksp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Toke dewje tɔyn ke isije me key-mbɔn̂-naa te le *Jiipije ooje tar ke Jeju pa le a, wungu ɔnde nya. ");
INSERT INTO ksp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Dinje, dutaeje n̂-teeje saa ke ddang me bbe te, dawje saa dɔ ddingiri te ke n̂-ddaje bbe ke Najarete dɔe te, ta kutae kilae nangê. ");
INSERT INTO ksp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","A n̂-tee horode te nɔtu. ");
INSERT INTO ksp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jeju aw bbe te ke ria na Kapernayum nange te ke Galile, aw tɔju ne dewje *ndɔ-kuwa-rɔ te. ");
INSERT INTO ksp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Dewje ke ooje ne-tɔju laa le isije ke bbel, mba n̂-pa tar le ke ndu ke mɔngu nya. ");
INSERT INTO ksp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mare dingaw ke ndil ke maji ang isi dɔe te ee me key-mbɔn̂-naa te le tɔ. Nuru eki ke singa n̂-pa na: ");
INSERT INTO ksp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","« Ya! Ddi bba e-ndiki ta dda ke je wa? Jeju ke Najarete! E-ddee ta tɔlje wa? M-geri, e-to Nje-me-nda ke in rɔ Lubba te.» ");
INSERT INTO ksp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jeju ndange ndil le pa na: « Utu tai, bbo e-tee rɔ dingaw te neenn ke ddang.» Ndil ke maji ang le unn dingaw le ilae nangê dann dewje te ngaa tee rɔe te, a ndil le dda saa ne ke maji ang kara ang. ");
INSERT INTO ksp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bbel dda dewje tɔyn ngaa n̂-paje tar horo naa te na: « Tar ddi bba toke be wa? N̂-pa tar ke ndu ke mɔngu ddem ke singa nare ndilje ke maji ang a n̂-teeje!» ");
INSERT INTO ksp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ri Jeju bbar dɔ nange te ke Galile tɔyn. ");
INSERT INTO ksp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jeju in key-mbɔn̂-naa te le *Jiipije le a aw key le Simɔ. Rɔ mum Simɔje ke dene toe, are rɔe uwa puru nya ngaa n̂-dujuje Jeju kare dda ne mba tar laa. ");
INSERT INTO ksp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","N̂-to nyeng ke dɔ dene te le a, n̂-ndange rɔ-to le ngaa rɔ-to le inya dene le. Kare teenn njaa, dene le in taar a, unn kutu karede ne-kusa. ");
INSERT INTO ksp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Goe te ke kare ande a, dewje tɔyn ke eeje ke nje-rɔ-toje dang dang me key te lede awje ke de areje Jeju. Nila jia dɔde te kara kara a rɔ-to lede nunga. ");
INSERT INTO ksp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ndilje ke maji ang teeje rɔ dewje te ke banya banya, ndilje le uruje eki paje na: « E-to Ngonn le Lubba!» A nin ke de ngaa narede ddew kare n̂-paje tar ang, mba ndilje le gereje to, n̂-to Kiriste. Jeju tɔju Tar ke Maji nange te ke Jude. ");
INSERT INTO ksp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kake lo are be a, Jeju tee aw mû, lo te ke dew goto ke te. Dewje banya banya unnje kutu sangeje ngaa awje sar ingaeje. N̂-ndikije ta gange, mba kare nɔtu ninyade ang. ");
INSERT INTO ksp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","A n̂-pa narede na: « To tar lem ta ndaji Tar ke Maji ke wɔju dɔ *kɔn̂-bbe le Lubba kare kese bbeje tɔ, mba Lubba ulam wɔju dɔ yeenn njaa.» ");
INSERT INTO ksp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Naw n̂-tɔju Tar ke Maji me key-mbɔn̂-naa te le *Jiipije ke Jude tɔyn. ");
INSERT INTO ksp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Dewje ke banya guku dɔ Jeju. Daw dubbaje naa mba koo tar le Lubba ke naw n̂-pa. Nar mbɔr dange te ke Genejarete ngɔsi. ");
INSERT INTO ksp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nunn keme a noo ngann toje joo mbɔr maann te ke nje-ndɔnje ddisije me te uruje nangê mba toko ddengeje lede. ");
INSERT INTO ksp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jeju aal me to te kara ke to le Simɔ. Ngaa n̂-duje nare n̂-ngese to le ddew ew sen ke ta kongo. Nisi me to te le naw tɔju ne dewje ke banya banya. ");
INSERT INTO ksp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Goe te ke new rɔe ta pa tar a, n̂-pa nare Simɔ na: « Aw ke kete lo te ke uru ta ilaje ddengeje lese e-ddaje ne ndɔn.» ");
INSERT INTO ksp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simɔ tel ke tar are na: « Ebbemje, n̂-dda ndɔn til te ndereng lo are a jinga ne kara ang. Baann a, ma kila ddengeje le toke tai pa.» ");
INSERT INTO ksp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Dilaje ddengeje le ngaa duwaje kanjije nya are ddengeje lede aw ujaje. ");
INSERT INTO ksp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","N̂-kebbeje nje-buwa-ndɔnje lede ke isije me to te ke kara, mba kare n̂-ddeeje dumajede. N̂-ddeeje ngaa dunguje kanjije le me toje te ke joo le, nayn ngaji baa ta kare toje le dii. ");
INSERT INTO ksp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kake Simɔ Piyar oo toke baann a, tee oso nɔ gɔl Jeju te pa na: « Ebbemje aw ddew ew sem mba m-to nje-ne-dda ke maji ang.» ");
INSERT INTO ksp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Bbel ddae, ne ke dewje tɔyn ke areje mbɔre te, wɔju dɔ ndɔn ke n̂-ddaje le. ");
INSERT INTO ksp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Bbel dda Jake de ke Jan, ngann le Jebede, nje-buwa-ndɔnje le Simɔ tɔ. Jeju pa are Simɔ na: « Are bbel ddai ang. A kunn kute bbokone, ndɔn lei a to enga sange dewje ngaa.» ");
INSERT INTO ksp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Goe te ke n̂-ddeeje ke toje le kar mbal te a, dinyaje neje tɔyn ngaa dunnje go Jeju. ");
INSERT INTO ksp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jeju ee me mare bbe te. Mare dingaw ke to nje-banji ooe, n̂-tee noso nɔ gɔle te n̂-debbe keme nangê ngaa n̂-duje n̂-pa na: « Ebbemje, toke e-ndiki a, are m-ddee maji.» ");
INSERT INTO ksp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jeju ula jia ɔre ne ngaa pa na: « M-ndiki, e-ddee maji.» Njange njange baa a, banji laa goto. ");
INSERT INTO ksp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Goe te a, n̂-ndeje ta kare n̂-pa tare nare dew kara oo ang. A, n̂-pa nare na: « Aw tɔju rɔi nje-polo Lubba, ta are *ne-polo wɔju dɔ ddee lei maji toke Moyije unda tare me maketuru te, mba kɔru ne naji lei to e-ddee maji.» ");
INSERT INTO ksp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ri Jeju bbar ke kete ke kete ngaa dewje banya banya mbɔn naa mba koo tar laa ddem, mba kare nɔru rɔ-to lede ddem. ");
INSERT INTO ksp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","A ne nɔru rɔe naw me kɔr te ngaa n̂-duju Lubba. ");
INSERT INTO ksp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Mare ndɔ Jeju aw tɔju ne. *Parijiyenje ke *nje-kɔruje-gel-ndu isije nangê. Dinje ngann bbeje te tɔyn ke Galile ke Jude te, ke Jurusalam ddem. Ngaa Jeju aw ɔru rɔ-to ke singa-mɔngu le *Ebbe-dewje. ");
INSERT INTO ksp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Dewje unnje mare dew ke debbe rɔe oy ke tuwa baa. Daw n̂-sangeje ddew mba kandeje saa ta kilae nɔ Jeju te. ");
INSERT INTO ksp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Dingaje ddew ke da kulaeje ne ang, mba dewje banya. Dalje saa dɔ key te taar ngaa dulaeje ke kem lo ke tuwa laa dann dewje te ke mbɔn naa nɔ Jeju te. ");
INSERT INTO ksp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jeju oo koo-me-te lede a, pa are dew le na: « Tar majangje lei ɔru dɔi te.» ");
INSERT INTO ksp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nje-kɔruje gel-ndu ke *Parijiyenje aw ejeje tar ngaa paje na: « Dew neenn to dew ddi bba aw taji ri Lubba wa? Lubba kara baa ee ke singa ta kɔru tar *majang ma se na tɔ wa?» ");
INSERT INTO ksp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jeju gere keje tar lede le a, pa arede na: « Mbata ddi bba aw ejeje tar toke baann mese te wa? ");
INSERT INTO ksp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","To ngeng ang ta pa na: Tar *majangje lei ɔru dɔi te ase in taar bbo e-nja wa? ");
INSERT INTO ksp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Maji kare e-gereje to Ngonn le dew ee ke singa ta kɔru tar *majang dɔ nange te.» N̂-pa nare dew ke debbe rɔe oy le na: « In taar, unn tuwa lei bbo aw key lei.» ");
INSERT INTO ksp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kare teenn njaa, nin taar kemde te, nunn tuwa laa ngaa nɔsu gaji Lubba naw ne ke key laa. ");
INSERT INTO ksp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Dewje tɔyn ooje to ne-bbel a, ɔsuje gaji Lubba. Bbel ddade ngaa n̂-paje na: « Joo ne-kɔbbu bbokone.» ");
INSERT INTO ksp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Goe te a, Jeju tee ngaa oo mare nje-taa nare *lambo ke ria na Lebi isi lo taa nare *lambo te. N̂-pa nare na: « Unn gom.» ");
INSERT INTO ksp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","N̂-tusu neje tɔyn ninya, nin taar ngaa nunn goe. ");
INSERT INTO ksp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lebi dda ne-kusa ke bo are Jeju me key te laa ngaa nje-taaje nare *lambo banya ke mare dewje nya isije ke de ta ne-kusa te. ");
INSERT INTO ksp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","*Parijiyenje ke *nje-kɔruje gel-ndu aw nyuruje ngaa paje are nje-njaje goe te na: « Mbata ddi bba aw usaje ne ddem aw ayje ne ke nje-taaje nare *lambo ke nje-ne-ddaje ke maji ang wa?» ");
INSERT INTO ksp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jeju pa arede na: « Dewje ke isije ke maje a aw ndikije nje-kare kuma ang, a nje-rɔ-toje bba aw ndikije nje-kare kuma. ");
INSERT INTO ksp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","M-ddee mba bbar dewje ke to gate gate ang, m-ddee mba bbar nje-ne-ddaje ke maji ang ta kare n̂-turuje ddew lede.» ");
INSERT INTO ksp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","*Parijiyenje ke *nje-kɔruje le paje areje na: « Nje-njaje go Jan te ddew kara baa ke nje-njaje go *Parijiyenje te aw inyaje ne-kusa ke ndɔ tɔyn ddem aw dujuje Lubba, a nje ke lei aw usaje ne ngaa aw ayje ne wa!» ");
INSERT INTO ksp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jeju pa arede na: « Toke nje-buwa-kuraje le nje-dene ke siki isije saa ndɔ kusu-taa-naa te a, da kase kuwade ke singa kare dinyaje ne-kusa wa? ");
INSERT INTO ksp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mare ndɔ aw ddee ke da kɔru nje-dene ke siki le horode te ke ddang. A me ndɔje teenn ngaa da kinyaje ne-kusa.» ");
INSERT INTO ksp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jeju pa gusu-tar arede bbay na: « Ndɔ kara dew a tir ta-kubbu ke siki mba kila ne kem bar-kubbu ang. A bbo n̂-dda toke baann a, na tir kubbu ke siki le ngaa ta-kubbu ke siki le kaw naa te ke bare le ang tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ddem, ndɔ kara dew a kungu koto ke siki ke to ben me ku-endaar te ke to kone ang. A bbo n̂-dda toke baann a, ben ke siki le a dda kare ku le tɔ. Ben le a kula nangê ngaa ku le a tuju nyɔm. ");
INSERT INTO ksp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","To maji ta kungu ben ke siki me ku-gaal te ke siki tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ddem ndɔ kara dew ay ben ke n̂-dda ndɔe banya mbaan a, na ndiki mba kay ye ke n̂-dda bbasine bbay ang. Mba na pa na: ye ke lew a maji.» ");
INSERT INTO ksp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jeju aw nday me ndɔɔ bleje te ke *ndɔ-kuwa-rɔ. Nje-njaje goe te teteje mare jinga ble le ngaa guruje aw usaje. ");
INSERT INTO ksp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kara kara le *Parijiyenje paje arede na: « Mbata ddi bba aw e-ddaje ne ke *ndu mbete ta dda ke *ndɔ-kuwa-rɔ wa?» ");
INSERT INTO ksp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jeju tel ke tar arede na: « E-nayje e-turaje Maketurudɔ ne te ke Dabbiti dda le ang wa? Ndɔ te ke bbo ddae, ne de ke nje-njaje goe te. ");
INSERT INTO ksp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dabbiti ande key-polo-Lubba te. Noto ne-kusaje ke dare Lubba, ke to mba nje-poloje Lubba ke karede baa nusa. Ngaa nare mare nje-njaje goe te.» ");
INSERT INTO ksp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jeju pa arede bbay na: « Ngonn le dew njaa to nje-ndɔ-kuwa-rɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mare *ndɔ-kuwa-rɔ le bbay, Jeju ande key-mbɔn̂-naa te le *Jiipije naw n̂-tɔju ne. Mare dew ke jia ke kɔl oy, ee me key teenn le tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kem mare *nje-kɔruje gel-ndu ke *Parijiyenje to dɔ Jeju te ta koo se na kɔru rɔ-to rɔ dew te *ndɔ-kuwa-rɔ te wa. Yeenn bba ta kinga ne ddew mba kunda ne tar dɔe te. ");
INSERT INTO ksp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ne kara, Jeju le gere keje lede ngaa n̂-pa nare dew ke jia oy le na: « In taar, bbo are danna neenn!» Nin ngaa nar taar. ");
INSERT INTO ksp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jeju pa arede na: « Ma dujuse tar. Ke *ndɔ-kuwa-rɔ, *ndu are ddew kare dew dda ne ke maji wase dew dda *majang wa? Ta kaji dew wase ta kinya dew kare oy wa?» ");
INSERT INTO ksp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Goe te ke naade mbetete tɔyn a n̂-pa tar ke dew le na: « E-ndɔju jii!» N̂-ndɔju jia ngaa jia le ddee maji. ");
INSERT INTO ksp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Wungu ɔnde nya ngaa daw n̂-maynje naa tar mba gere ne ke da kase dda ke Jeju. ");
INSERT INTO ksp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Me ndɔje teenn njaa Jeju aal dɔ ddingiri mba duju Lubba. N̂-duju Lubba ndereng lo are. ");
INSERT INTO ksp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kake lo are a n̂-bbar nje-njaje goe te, n̂-mbere mareje dɔku gire joo horode te ngaa nunda ride na *nje-kayn̂-kulaje: ");
INSERT INTO ksp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simɔ ke nunda ria na Piyar, ke ngokɔen Andere, Jake, Jan, Pilipi, Batalami, ");
INSERT INTO ksp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiye, Toma, Jake ngonn le Alpe, Simɔ ke daw n̂-bbare to ‹dew ke ndiki bbe laa nya›, ");
INSERT INTO ksp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jude ngonn le Jake, ke Judase Isikariyote ke tel to nje-kunn dɔ Jeju. ");
INSERT INTO ksp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jeju in dɔ ddingiri te ke *nje-kayn̂-kulaje, n̂-ddee nar lo te ke tate. Lo teenn, nje-njaje goe te banya banya ke dewje ke banya ke inje nange Jude te tɔyn, ke Jurusalam te, ke bbe ke Tir ke Sidɔn bbeje ke kar ba te. ");
INSERT INTO ksp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","N̂-ddeeje mba koo tar le Jeju ddem, mba kare nɔru rɔ-toje lede ddem. Nje ke ndilje ke maji ang aw ulaje kemde ndoo kara ddeeje maji. ");
INSERT INTO ksp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Dewje le tɔyn njaa aw sangeje ddew ta kɔreje, mba mare singa-mɔngu ke aw tee rɔe te aw ɔru rɔ-toje lede tɔyn. ");
INSERT INTO ksp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jeju unn keme aa ne nje-njaje goe te ngaa pa na: « Koko to lese, dangeteje, mba *Kɔn̂-bbe le Lubba to mba tar lese! ");
INSERT INTO ksp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Koko to lese, ese nje ke bbo aw ddase, mba mese a ndann! Koko to lese, ese nje ke aw e-nɔje bbasine, mba a kisije ke koko! ");
INSERT INTO ksp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Koko to lese, toke dewje mbetese, dewje tubbase, dewje tajise ngaa paje tar lese maji ang wɔju dɔ Ngonn le dew. ");
INSERT INTO ksp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","E-ddaje rɔ-nel ngaa e-talje e-turuje ke koko dɔ ndɔe teenn, mba kuka lese a bo nya me dara te, mba toke baann tɔ a kadede ddaje ke *nje-kilaje mber-tar le Lubba. ");
INSERT INTO ksp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","A, wungu to lese, ese nje-ne-kingaje, mba bbokone isije ke koko mban! ");
INSERT INTO ksp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Wungu to lese, ese dewje ke mese ndann bbokone, mba bbo a ddase! Wungu to lese, esese ke aw kokoje bbokone, mba ne-me-kɔn a ddase ngaa a ndeyje maann nɔ! ");
INSERT INTO ksp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Wungu to lese, toke dewje tɔyn pitijese, mba kadede ddaje ke nje-kilaje mber-tar ke to nje-ngemje toke baann tɔ!» ");
INSERT INTO ksp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","« A m-pa marese esese ke aw ooje tar lem: E-ndikije nje-baanji lese, e-ddaje maji ke nje ke mbetese. ");
INSERT INTO ksp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","E-bbarje Tar ke Maji dɔ dewje te ke aw bbarje Tar ke Maji ang dɔse te, e-dujuje Lubba mba nje ke aw ddase maji ang. ");
INSERT INTO ksp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Bbo dew unda ka-mbɔri a, e-turu debbe ke kara are tɔ. Bbo dew taa kubbu kul lei a, inya kubbu lei ke taar are tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Are ne dew ke aw duji ne ngaa e-bbange dew ke taa ne lei ang. ");
INSERT INTO ksp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ne ke e-ndikije kare dewje ddaje ke se a, e-ddaje ke de tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Bbo nje ke ndikise bba e-ndikijede tɔ a, dewje a gereje go me-maji lese toke baann wa? Nje-ne-ddaje ke maji ang kara aw ndikije nje ke ndikijede tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Bbo nje ke ddaje ke se maji dɔrɔ bba e-ddaje ke de maji a, dewje a gereje go me-maji lese toke baann wa? Nje-ne-ddaje ke maji ang kara ddaje toke baann tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Bbo dewje ke e-gereje to da kukaje bbange lese bba arejede ne n̂-tunaje a, dewje a gereje go me-maji lese toke baann wa? Nje-ne-ddaje ke maji ang kara ddaje toke baann, mba kare n̂-tel ne darede. ");
INSERT INTO ksp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","A, e-ndikije nje-baanji lese, e-ddaje maji, areje ne dew tuna a undaje mese dɔ mare ne te goe te ang. Baann bba kuka lese a bo nya ngaa a toje to ngann le Ne-ke-ddutu-dara te. Mba Ne-ke-ddutu-dara te n̂-dda maji ke dewje ke areje wooyo ndɔ kara ang ddem, nje-me-maji-angje ddem. ");
INSERT INTO ksp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ooje kem-to-ndoo le naa ddew kara baa toke Bɔsese oo kem-to-ndoo lese.» ");
INSERT INTO ksp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","« E-gangeje sariya dɔ dew te ang a, da gange sariya dɔse te ang. Undaje tar dɔ dew te ang a, da kunda tar dɔse te ang tɔ. Ɔruje tar dɔ dewje te a, da kɔru tar dɔse te. ");
INSERT INTO ksp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Areje ne a, da karese ne: Ka ke maji a da kɔju ne ne karese, a ddusu julum, da mbusu, da yeke kare gayn nangê bbere bbere ngaa bba da mbel me bbɔl-kubbu te lese. Mba ka ke unnje ɔjuje ne ne areje dew a, da kunn kɔju ne ne karese tɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jeju pa gusu-tar arede tɔ na: « Nje-kem-tɔ ase kila kake ji nje-kem-tɔ mare te wa? Da kosoje joo kem me buwa te ang wa? ");
INSERT INTO ksp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nje-nja go ebbeeje te a kutae ang a, nje-nja go ebbeeje te ke oo tae ke maje a, a kase saa naa tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Mba ddi bba mu ke oso kem ngokɔin te a oo, a oo tɔku kake ke to kemi te ang wa? ");
INSERT INTO ksp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wase, baann bba ei ke oo tɔku kake ke to kemi te ang, a kase pa kare ngokɔin na arem mɔru mu ke to kemi te wa? Nje-ngem, ɔru tɔku kake ke to kemi te dɔngɔr bba a kinga ddew ta kɔru mu ke oso kem ngokɔin te.» ");
INSERT INTO ksp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","« Kake ke maji, a kande kande-kake ke maji ngaa kake ke maji ang, a kande kande-kake ke maji ang tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mbata daw n̂-gere kake kara kara ddew kande te. Da kuja kande tungu dɔ kake konn pɔrɔ te ang, da tuja *nduu horo ger gende te ang. ");
INSERT INTO ksp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Neje ke maji in me dew te ke maji. A neje ke maji ang in me dew te ke maji ang. Mba ne ke ddusu me dew a aw tee ddew tar ke tae te.» ");
INSERT INTO ksp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","« Mba ddi bba e-bbaremje Ebbemje, Ebbemje! A e-ddaje ne ke maw m-pa marese ang wa? ");
INSERT INTO ksp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Dew ke ddee rɔm te, oo tar lem ngaa dda kula ke turu ndum unda rɔ na wa? ");
INSERT INTO ksp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","N̂-to ddew kara baa ke dew ke a ta kɔsu key a, wuru buwa are wuru peng peng bba ungu gɔl key le dɔ er te. Toke maann taa lo ngaa unda kar key le a, key le oso ang, mba dɔsu key le ke maje. ");
INSERT INTO ksp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","A dew ke oo tar lem ngaa dda ne kula ang to ddew kara baa ke dew ke ɔsu key laa dɔ nange te baa bbo ungu gɔle dɔ er te ang. Maann ula unda kar key le a, kem naa te neenn njaa key le uwa nange ngaa guru njuku njuku.» ");
INSERT INTO ksp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Goe te ke Jeju pa tarjeenn tɔyn are dewje a, naw Kapernayum. ");
INSERT INTO ksp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mare baw-ddɔ le Romeje, ee ke nje-kula laa ke n̂-ndike nya. Rɔ nje-kula laa le toe ngaa nayn ngɔsi ta koy. ");
INSERT INTO ksp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Toke noo tar le Jeju a, nula mare tɔku-dewje le Jiipije nare ta kare n̂-ddee naji nje-kula laa le. ");
INSERT INTO ksp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Dawje rɔ Jeju te ngaa n̂-nɔje nɔ gɔle te nya n̂-paje na: « Dingaw neenn ase kare e-dda ne mba tar laa, ");
INSERT INTO ksp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","mba n̂-ndikije jee *Jiipije nya. Ne a n̂-dda key-mbɔn̂-naa leje.» ");
INSERT INTO ksp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jeju aw ke de ngaa toke n̂-teeje ngɔsi ke key le baw-ddɔ le a, baw-ddɔ le ula nje-buwa-kuraje laa are Jeju na: « Ebbemje, e-jɔku rɔi baann ang, mba mase kare ande key lem ang. ");
INSERT INTO ksp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Mba yeenn tɔ a, moo to mase kaw rɔi te ke da rɔm ang. A, e-pa tar kara a nje-kula lem a kaji. ");
INSERT INTO ksp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mba ema kara mee kɔy dewje te ke bo, mee ke nganji-ddɔje kɔyem te tɔ. A bbo, mula mare m-pa na: Aw! A naw. M-pa mare mare, m-pa na: E-ddee! A n̂-ddee. M-pa mare nje-kula lem, m-pa na: E-dda ne ke be! A n̂-dda.» ");
INSERT INTO ksp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Toke Jeju oo tar le a, ninga koko ddew te le baw-ddɔ le. N̂-turu rɔe ke rɔ dewje te ke aw ooje tar laa ngaa n̂-pa na: « M-pa marese, dɔ nange Ijarayel te kara moo koo-me-te ke bo toke be ang.» ");
INSERT INTO ksp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nje ke baw-ddɔ ulade le telje awje key a, daw dingaje nje-kula le baw-ddɔ le ke rɔ ke maji. ");
INSERT INTO ksp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Goe te a Jeju aw mare bbe te ke ria na Nayn. Nje-njaje go Jeju te ke mare dewje banya banya awje saa. ");
INSERT INTO ksp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Toke n̂-tee ngɔsi ke bbe le a, noo dewje ke awje ke yo ta dubbu. Dew ke oy le to ngonn̂-kara ke dingaw le mare dene-ndubba. Dewje ke me bbe te le banya banya aw dannje dene le tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","*Ebbe-dewje le oo dene le a ddae ndoo ngaa pa are dene le na: « E-nɔ ang!» ");
INSERT INTO ksp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","N̂-ngese ke kete a nɔru tuwa ke dila ninn le ke te. Dewje ke otoje ninn le areje lo kara ngaa Jeju pa na: « Basan, m-pa mari, in taar!» ");
INSERT INTO ksp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ninn le in isi taar ngaa unn kutu pa tar. Jeju ulae ji kɔenje te. ");
INSERT INTO ksp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bbel dda dewje tɔyn. Dɔsuje gaji Lubba, n̂-paje na: « Tɔku *nje-kila mber-tar le Lubba tee horoje te ngaa Lubba ddee ta kuma dewje laa.» ");
INSERT INTO ksp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tar ne ke Jeju dda le nja dɔ nange te ke Jude tɔyn, ke me bbeje tɔyn ke guku dɔ Jude. ");
INSERT INTO ksp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nje-njaje go Jan te aw paje go nejeenn tɔyn areje. ");
INSERT INTO ksp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","N̂-bbar mareje joo horode te nulade rɔ *Ebbe-dewje te, n̂-pa na: « Ei a e-to dew ke a ta ddee le wase ja ngina mare dew ke dang wa?» ");
INSERT INTO ksp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Toke dewje le teeje rɔ Jeju te a, n̂-paje dareje na: « Jan̂-Batise ulaje ta duji se ei a e-to dew ke jaw n̂-nginae le wase ja ngina mare dew dang wa?» ");
INSERT INTO ksp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kare teenn njaa Jeju ɔru rɔ-toje, ke meteje, ke tubba ndilje ke maji ang rɔ dewje te banya banya. Ngaa n̂-dda nare dewje ke kemde tɔ kara ooje lo. ");
INSERT INTO ksp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Goe te a, n̂-tel ke tar nare nje-njaje go Jan te le na: « Awje, e-paje areje Jan ne ke ooje ke kemse ddem, ke mbise ddem. Nje-kem-tɔje ooje lo, nje-gɔl-gotoje njaje. Banji le dewje nunga rɔde te, nje-mbi-kutuje ooje tar. Dewje ke oyje ndolje ngaa nje-ndooje ooje Tar ke Maji. ");
INSERT INTO ksp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Koko isi ke dew ke a koso ddew koo-me-te wɔju dɔm ang.» ");
INSERT INTO ksp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Goe te ke nje-njaje go Jan te telje mbaan, Jeju unn kutu pa tar le Jan are dewje ke banya banya le na: « Ddi bba awje aw ooje me kɔr te wa? Mu-maann ke yel aw yeke wa? ");
INSERT INTO ksp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","A ddi bba awje aw ooje wa? Dew ke ula kubbu ke kura wa? Nje ke ulaje kubbu nare toje to nje-ne-kingaje ke isije me key te le tɔku-mbay-bbeje. ");
INSERT INTO ksp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","A ddi bba awje aw ooje wa? Mare nje-kila mber-tar le Lubba wa? Tɔkɔrɔ m-pa marese, nuta nje-kila mber-tar bbay. ");
INSERT INTO ksp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Mba tar le Jan̂-Batise a n̂-dda me Maketurute le Lubba na: Oo, mula nje-kayn̂-kula lem nɔi te, mba kare n̂-dda ddew ke a nja te. ");
INSERT INTO ksp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","M-pa marese: Horo dewje te tɔyn ke deneje ujujede, dew ke uta Jan goto. A ddutu-dew ke me *Kɔn̂-bbe te le Lubba utae. ");
INSERT INTO ksp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Dewje tɔyn ke ooje tar le Jan le, ke nje-taaje nare *lambo kara ooje to Lubba to gate gate ngaa dawje dare Jan ddade batem. ");
INSERT INTO ksp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","A *Parijiyenje ke *nje-kɔruje gel-ndu mbeteje ne ke Lubba mɔse mba tar lede ngaa n̂-mbeteje kare Jan ula dɔde maânn.» ");
INSERT INTO ksp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jeju tel pa arede na: « Nje ke dda bba ma kunnde kɔju ne dewje ke bbokone wa? Dundaje rɔ nje ke dda wa? ");
INSERT INTO ksp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","N̂-toje ddew kara baa ke ngannje ke isije nata, ke bbarje naa ngaa paje are naa na: N-kɔl mbula jarese, a e-laje ne ang, jɔsu pa-yo a e-nɔje ne ang. ");
INSERT INTO ksp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Mba Jan̂-Batise ddee le, ɔn muru ang ddem, ay koto ang ddem a e-paje na: Ndil ke maji ang isi dɔe te. ");
INSERT INTO ksp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ngonn le dew ddee, ɔn muru ngaa ay ne a e-paje na: Dew neenn to nje-ne-kusa ke nje-ne-kay, nje-buwa-kura le nje-taaje nare *lambo ke le nje-ne-ddaje ke maji ang. ");
INSERT INTO ksp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kem-kare to gate gate kem dewje te ke ndikije te.» ");
INSERT INTO ksp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mare Parijiyen bbar Jeju ta kare usa ne saa. Jeju ande key le Parijiyen le ngaa aw isi ta ne-kusa te. ");
INSERT INTO ksp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Toke mare dene nje-ne-dda ke maji ang ke isi me bbe teenn oo na Jeju ee me key te le Parijiyen le a, n̂-ddee ke ku albatere, ke wubbu ke ete maji ddusu mee. ");
INSERT INTO ksp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","N̂-ddee nar go Jeju te, mbɔr gɔle te naw n̂-nɔ nare maann̂-keme ula gɔl Jeju te ngaa n̂-bɔru gɔle le ke ben̂-dɔe. Nunda tae gɔl Jeju te le ngaa nungu wubbu ke ete maji le gɔle te. ");
INSERT INTO ksp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Parijiyen le oo baann a pa mee te na: « Bbo dingaw neenn to *nje-kila mber-tar le Lubba tɔkɔrɔ a, na gere to dene ke aw ɔre neenn to nje-ne-dda ke maji ang.» ");
INSERT INTO ksp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jeju pa are Parijiyen le na: « Simɔ, mee ke tar ta pa kari.» Simɔ tel ke tar are na: « Nje-ne-toju, e-pa tar le.» ");
INSERT INTO ksp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jeju pa na: « Mare dew ee ke bbange laa dɔ dewje te joo. Mare kara tuna *kande-nare kɔrmi a mare kara tuna *kande-nare dɔmi. ");
INSERT INTO ksp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Toke disije ke ddew ta kuka bbange le ang a, nje-nare le inya nare laa le arede. Horo dewje te ke joo le, ye ke dda bba a ndiki dew ke dda maji ke de le nya wa?» ");
INSERT INTO ksp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simɔ le tel ke tar are Jeju na: « Meje a to ne ke bbange laa bo nya.» Jeju pa are na: « E-tel ke tar ke dɔgɔle.» ");
INSERT INTO ksp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","N̂-turu rɔe ke rɔ dene te le ngaa n̂-pa nare Simɔ na: « Oo dene neenn, m-ddee key lei a arem maann toko gɔlem ang a ne a n̂-toko gɔlem ke maann̂-keme ngaa n̂-bɔru gɔlem ke ben̂-dɔe. ");
INSERT INTO ksp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ei, e-to mbim ang a ne, kake mande key beenn, new rɔe ta kunda tae gɔlem te ang. ");
INSERT INTO ksp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ungu wubbu dɔm te ang, a ne nungu wubbu ke ete maji gɔlem te. ");
INSERT INTO ksp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Mba yeenn a m-pa mari: Tar *majang laa ke banya ɔru dɔe te ngaa, mba ndiki laa bo nya. Mba dew ke dɔru tar dɔe te ten baa, ndiki laa to ten baa tɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ngaa n̂-pa nare dene le na: « Tar *majang lei ɔru dɔi te ngaa.» ");
INSERT INTO ksp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Dewje ke isije ta ne-kusa te ke Jeju le paje mede te na: « Dew neenn to na bba tar *majang le dewje kara aw ɔru dɔde te wa?» ");
INSERT INTO ksp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jeju pa are dene le na: « Koo-me-te lei aji. Aw ke *me-wul-lɔm.» ");
INSERT INTO ksp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Goe te a, Jeju unn go bbuka bbeje ke ngann bbeje, aw pa tar le Lubba ke ila mber Tar ke Maji wɔju dɔ *Kɔn̂-bbe le Lubba. Nje-kayn̂-kulaje laa ke dɔku gire joo awje saa, ");
INSERT INTO ksp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ke mare deneje ke nɔru rɔ-to ndilje ke maji ang, ke rɔ-toje rɔde te tɔ: Mari ke daw n̂-bbare na Madelena, ne ke Jeju tubba ndilje ke maji ang siri rɔe te, ");
INSERT INTO ksp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ke Jani dene le nje-ngem ne-kingaje le tɔku-mbay *Erode ke ria na Kuja, ke Sujani, ke mare deneje nya ke aw umaje Jeju ke nje-njaje goe te ke ne-kingaje lede. ");
INSERT INTO ksp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Dewje ke banya mbɔnje naa ngaa mare dewje inje bbeje te dang dang aw ddeeje rɔ Jeju te a, n̂-pa gusu-tar neenn na: ");
INSERT INTO ksp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","« Mare dew aw ta dubbu ne. Toke naw n̂-dubbu ne le a, mare kande ko le gayn dɔr ddew te, dewje mbɔynje kande-ko le ngaa eelje ke darâ ɔnje. ");
INSERT INTO ksp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mare debbe kande-ko le gayn dɔ nange te ke to er. Toke kande-ko le tee a, tutu njan, mba ninga maann ang. ");
INSERT INTO ksp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mare kande ko le gayn horo konnje te. Konnje le teeje ke de ddew kara baa ngaa konnje le orede ke nangê mben. ");
INSERT INTO ksp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","A mareje gayn dɔ nange te ke maji. N̂-teeje ngaa gɔl kake kara a ande dɔdɔku dɔdɔku.» Kake Jeju pa tar neenn ila nangê a, n̂-pa ke taar na: « Dew ke mbia to ta koo ne tar a oo!» ");
INSERT INTO ksp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nje-njaje goe te dujeje na: « Gel gusu-tar neenn na ddi wa?» ");
INSERT INTO ksp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nila te na: « Esese, Lubba are e-gereje ne ke to lo kiyae te ke wɔju dɔ *Kɔn̂-bbe laa. A keseje, n̂-pa tare darede ddew gusu-tar te, mba kare daaje lo a dooje ne ang ddem dooje tar a n̂-ngereje kande ang ddem. ");
INSERT INTO ksp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Gel gusu-tar neenn le toke be: Kande ko le to tar le Lubba. ");
INSERT INTO ksp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kande ko ke gayn mbɔr ddew te le tɔju dewje ke ooje tar le Lubba le ngaa Esu ddee ɔru tar le mede te ke ddang, mba kare dooje mede te ta dingaje kaji ang. ");
INSERT INTO ksp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kande ko ke gayn dɔ nange te ke to er le tɔju nje ke ooje tar le Lubba le a, n̂-taaje ke koko. A ne kara, tar ke dooje le ungu ngirae nangê mede te ang, dooje mede te mba gɔju kare baa, a ndɔ ke ne-na-me tee a, n̂-tusuje dinyaje. ");
INSERT INTO ksp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kande ko ke gayn horo konnje te tɔju dewje ke ooje tar le Lubba le ngaa dɔtuje a, keje-tar, ke ne-kingaje, ke rɔ-nelje ke dɔ nange te ɔkujede ddew ta kare dande ke maje. ");
INSERT INTO ksp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kande ko ke gayn dɔ nange te ke maji tɔju nje ke ooje tar le Lubba ke me ke maji, ke me ke gate gate, a n̂-ngemje tar le, duwaje dare ngeng ngaa dandeje ndɔ ke ndɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","« Ndɔ kara dew ila puru *lambe te a, unn mare ne debbe ne ang, wase dew le unn *lambe le unda kɔ tira te ang. A nunda *lambe le dɔ kake te taar, mba kare dewje ke aw andeje key le ooje ne lo. ");
INSERT INTO ksp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mbata ne tɔyn ke to lo kiyae te da tee dɔe te, ne tɔyn ke n̂-kusu dɔe a tee ke ddaka. ");
INSERT INTO ksp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Aaje rɔse ddew tar te ke aw ooje, mba dew ke ee ke ne a da kare mare dɔe te. A dew ke ee ke ne ang, ne ke neje to ninga kara da kɔru jia te.» ");
INSERT INTO ksp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kɔn Jejuje ke ngakɔenje ddeeje ke rɔe te, a dingaje ddew ta kaw ngɔsi saa ang, mba dewje bakaje nya. ");
INSERT INTO ksp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Dewje paje are Jeju na: « Kɔinje ke ngakɔinje areje ddaka. N̂-ndikije ta kooi.» ");
INSERT INTO ksp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","A n̂-tel ke tar narede na: « Kɔmje ke ngakɔmje a toje to nje ke ooje tar le Lubba a ddaje ne kula.» ");
INSERT INTO ksp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Mare ndɔ Jeju aal to ke nje-njaje goe te. N̂-pa narede na: « Jawje tura maann te.» Ngaa dawje. ");
INSERT INTO ksp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Toke daw n̂-yelje to le a, Jeju aw tibbi. Bamburabo ddee ula dɔ maann te le ngaa maann aw me to te le nayn ngɔsi ta ddusu are deeje me yo te. ");
INSERT INTO ksp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nje-njaje goe te le ddeeje ngɔsi saa ngaa n̂-ndoleje n̂-paje na: « Ebbejeje, Ebbejeje, ja koy!» N̂-ndol ngaa n̂-ndange *bamburabo ke maann ke aw lenge le nare dewje rɔde ngaa lo to nyenene. ");
INSERT INTO ksp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jeju pa are nje-njaje goe te le na: « Koo-me-te lese ee dda wa?» Bbel ddade ddem dɔde turu ddem a n̂-paje dar na na: « Dew neenn to dew ddi wa? Mba n̂-pa tar ke gɔsu ke mɔngu a, yel ke maann kara ooje tae.» ");
INSERT INTO ksp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jeju ke nje-njaje goe te n̂-teeje ta kongo te ke bbe te le dewje ke Gadara*ke aa naa ke dɔ nange Galile. ");
INSERT INTO ksp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kake Jeju uru nangê a, mare dingaw ke ee ke ndilje ke maji ang banya rɔe te in me bbe te ke dɔ nange teenn le tila keme. Lew baa njaa dingaw le ula kubbu ang ddem, n̂-to key ang ddem a horo dɔbareje a naw n̂-to ke te. ");
INSERT INTO ksp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kake dingaw le oo Jeju a uru eki, tee oso nɔ gɔle te ngaa pa ke taar na: « Ddi a e-ndiki ta dda sem wa? Jeju, Ngonn le Lubba ke ddutu dara te! Kɔkɔrɔ njaa ula kem ndoo ang.» ");
INSERT INTO ksp_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nuru eki, mba Jeju pa tar ke ndu ke mɔngu are ndilje le ta kare n̂-teeje me dingaw te le ke ddang. Ndil le unn dingaw le gɔl banya banya are n̂-tɔ gɔle ke kula njamji ngaa dilae poro bbaa daw n̂-ngeme. N̂-ti kulaje ke n̂-tɔe ne le ngaa ndilje le ɔreje awje saa ke me kɔr te. ");
INSERT INTO ksp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jeju duju dingaw le na: « Rii na na wa?» N̂-tel ke tar na: « Banya banya.» Mba ndilje ke maji ang andeje mee te nya. ");
INSERT INTO ksp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ndilje ke maji ang le uwaje gɔl Jeju ta kare narede dawje buja te ke il biti biti ang. ");
INSERT INTO ksp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kare teenn kusu bereje ke banya aw usaje ne dɔ kongo te lo teenn le. Ndilje ke maji ang le dujuje Jeju ta kare arede ddew are dandeje me bereje te le ngaa narede ddew. ");
INSERT INTO ksp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ndilje ke maji ang le teeje me dingaw te le aw andeje me kusu bereje te le ngaa kusu bereje le inje dɔ kongo te ke ngɔru gaynje maânn oyje. ");
INSERT INTO ksp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nje ke aw ngemje bereje le ooje ne ke tee le a, aynje ngaa aw paje tare tɔku bbe te ke ngann bbeje te. ");
INSERT INTO ksp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Dewje awje ooje ne ke tee le. N̂-ddeeje rɔ Jeju te ngaa dingaje dingaw ke ndilje teeje mee te le, nisi nangê kɔy gɔl Jeju te. Dingaw le ula kubbu ddem, isi ke maje ddem ngaa bbel ddade nya. ");
INSERT INTO ksp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Dede ke dooje ddew ke Jeju tubba ne ndilje ke maji ang rɔ dingaw te le, dɔruje gele dare nje ke awje le ooje. ");
INSERT INTO ksp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Dewje tɔyn ke bbe te le dewje ke *Geraja dujuje Jeju ta kare ɔtu ke ddang, mbata bbel ddade nya. Jeju aal to ta tel ke guku. ");
INSERT INTO ksp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Dingaw ke ndilje teeje mee te le duju Jeju ta nayn saa. A Jeju tubbae pa na: ");
INSERT INTO ksp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","« E-tel aw key lei ta ɔru gel ne ke Lubba dda sei!» Naw ngaa n̂-pa tar ne ke Jeju dda mba tar laa me bbe te le tɔyn. ");
INSERT INTO ksp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Toke Jeju tel tura maann te guku a, dewje ke banya uwaeje ke rɔde te, mba dede tɔyn daw n̂-ngebbeje. ");
INSERT INTO ksp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ngaa mare dingaw ke ria na Jayirusu, n̂-to nje-kɔn dɔ *key-mbɔn̂-naa le *Jiipije, n̂-ddee, n̂-tee noso nangê nɔ gɔl Jeju te, n̂-nduje ta kare naw me key te laa, ");
INSERT INTO ksp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","mba ngonne ke dene ke to ngonn̂-kara ke bbale ase dɔku gire joo a ta koy. Toke Jeju aw aw ke key le a, dewje ke banya ubbaeje njang. ");
INSERT INTO ksp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mare dene ke mese aw ddee rɔe te lew baa ase bbal dɔku gire joo ee ke teenn. Dene le tuju neje laa tɔyn ji nje-kare-kumaje te, a dew kara ase ta kɔru rɔ-to laa ang. ");
INSERT INTO ksp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","N̂-ddee go Jeju te ngɔsi, nɔru ta kubbu laa. Kare teenn njaa mese le gange. ");
INSERT INTO ksp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jeju pa na: « Na a ɔrum wa?» Toke dewje tɔyn aw ɔruje naji lede a, Piyar pa na: « Ebbemje, dewje aw guku dɔi ngaa daw dubbaije!» ");
INSERT INTO ksp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","A Jeju ila te na: « Mare dew ɔrum, mba m-gere to mare singa in rɔm te tee.» ");
INSERT INTO ksp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Dene le oo to Jeju gere a, nisa ngaa n̂-ddee noso nɔ gɔle te. N̂-pa kem dewje te tɔyn gel ne ke nɔru ne Jeju, ke ddew ke rɔ-to laa goto ne kare teenn. ");
INSERT INTO ksp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jeju pa are na: « Ngonnum ke dene, koo-me-te lei aji. Aw ke *me-wul-lɔm.» ");
INSERT INTO ksp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Toke Jeju aw pa tar bbay a, mare dew in bbe le Jayirusu le ngaa n̂-pa nare na: « Ngonni ke dene le oy mban. E-jɔku nje-ne-tɔju ang ngaa.» ");
INSERT INTO ksp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","A Jeju oo tar neenn le ngaa pa are Jayirusu le na: « Are bbel ddai ang, ka njaa oo mei te a na kinga kaji.» ");
INSERT INTO ksp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Toke Jeju tee key le a, n̂-mbete ta kare dewje andeje saa key. Piyar, ke Jan, ke Jake, ke bɔ-ngonnje ke kɔn̂-ngonnje le a ninya ddew nare dandeje saa key. ");
INSERT INTO ksp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Dewje tɔyn aw nɔje ke aw ndingaje rɔde wɔju dɔ ngonn ke dene le. Jeju pa na: « E-nɔje ang. Noy ang ka a naw n̂-tibbi.» ");
INSERT INTO ksp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ngaa dewje le aw kokoje Jeju, mba n̂-gereje to ngonn ke dene le oy. ");
INSERT INTO ksp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","A Jeju uwa ji ngonn ke dene le ngaa pa ke gɔsu ke mɔngu na: « Ngonn, in taar!» ");
INSERT INTO ksp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ndil ngonn ke dene le tel rɔe te, a kare teenn njaa nin taar ngaa Jeju pa arede ta kare dare ne nusa. ");
INSERT INTO ksp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kɔn̂-ngonnsje ke bɔ-ngonnje ke dene le ooje a dum dɔde. A Jeju ndejede ta kare n̂-paje tar ne ke nday le dare dew kara oo ang. ");
INSERT INTO ksp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jeju mbɔn *nje-kayn̂-kulaje laa ke dɔku gire joo ngaa arede singa ke ddew ta tubba ne ndilje ke maji ang ddem, narede singa ta kɔru ne rɔ-toje rɔ dewje te ddem. ");
INSERT INTO ksp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nulade ta kare dilaje mber-tar *Kɔn̂-bbe le Lubba dareje dewje ddem ta kare dɔruje rɔ-to rɔ dewje te ddem. ");
INSERT INTO ksp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","N̂-pa narede na: « Unnje ne kara mba kaw lese ang. Unnje kake, wase bbɔl, wase mapa, wase nare ang. Dew aw ke kubbu laa ke taar joo ang. ");
INSERT INTO ksp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Key ke andeje te mbaan, e-nayje te nyɔm ta ɔtuje ne. ");
INSERT INTO ksp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bbe ke e-teeje te a bbo dewje taase ke key ang, a bbo a ta kɔtuje ke kete a, e-tundaje bum nange ke gɔlse te ta kɔru ne naji lese.» ");
INSERT INTO ksp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nje-kayn̂-kulaje le Jeju le awje ngaa, n̂-njaje ke go bbe bbe, n̂-paje Tar ke Maji dareje dewje ngaa dɔruje rɔ-to rɔ dewje te tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ngonn tɔku-mbay *Erode oo tar neje tɔyn ke aw teeje a neje tar, mba mare dewje paje na: « Jan ke oy le a ndol.» ");
INSERT INTO ksp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mareje paje na: « Eli a tel ddee.» A mareje paje bbay na: « Kara le nje-kila-mber-tarje le Lubba ke oy a ndol.» ");
INSERT INTO ksp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","A *Erode pa na: « Munn ndum mare n̂-gange dɔ Jan. A dew neenn to na bba maw moo tarje dang dang dɔe te neenn wa?» Ngaa n̂-sange ddew ta koo Jeju. ");
INSERT INTO ksp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Goe te ke *nje-kayn̂-kulaje le Jeju telje a, n̂-paje go neje tɔyn ke n̂-ddaje dareje. Ngaa Jeju ɔrude ke karede aw ke de er ke tɔku bbe te ke ria na Betesayida. ");
INSERT INTO ksp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","A dewje ke banya gereje tare ngaa ɔruje goe. Jeju taade ke rɔe te ngaa pa tar *Kɔn̂-bbe le Lubba arede ddem, ɔru rɔ-to rɔ dewje te ke ndikije kare nɔru rɔ-to rɔde te ddem. ");
INSERT INTO ksp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Lo aw ndul ngaa *nje-kayn̂-kulaje le Jeju ngeseje ke rɔe te paje areje na: « E-tubba dewje ke banya neenn are dawje me bbeje te ke dɔ-ndɔɔje te ke ngɔsi neenn bba da kinga lo-to ke ne-kusa, mba lo ke jar te neenn to me mu baa.» ");
INSERT INTO ksp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","A Jeju pa arede na: « Esese njaa, arejede ne dusaje.» Nje-kayn̂-kulaje le ilaje te na: « Jee ke mapa mi ke kanjije joo baa. Ase ta kare jeje njaa jaw n̂-ndoko ne-kusa mba dewje ke banya neenn wa?» ");
INSERT INTO ksp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Dingawje eeje lo teenn ngɔsi ke doro mi. Jeju pa are nje-njaje goe te na: « Areje disije nangê, ke go kulae dɔmi dɔmi.» ");
INSERT INTO ksp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nje-njaje goe te areje dewje le isije nangê toke ndue pa. ");
INSERT INTO ksp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jeju jin mapa ke mi ke kanji ke joo le a, aa lo ke darâ ngaa bbar Tar ke Maji dɔe te. N̂-tete danna ngaa nare nje-njaje goe te kare dare dewje ke banya banya le. ");
INSERT INTO ksp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Dewje tɔyn usaje ne mede ndann, a kese ne-kusa nay ddusu kare dɔku gire joo. ");
INSERT INTO ksp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Mare ndɔ ke Jeju ɔru rɔe aw duju Lubba ngaa nje-njaje goe te isije saa a n̂-dujude na: « Dewje paje na m-to na wa?» ");
INSERT INTO ksp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","N̂-telje ke tar na: « Na e-to Jan̂-Batise, mareje paje na e-to Eli, mareje bbay paje na e-to kara le nje-kila mber-tarje le Lubba a e-ndol.» ");
INSERT INTO ksp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jeju pa arede na: « Esese e-paje na m-to na wa?» Piyar ila te na: « E-to Mesi le Lubba.» ");
INSERT INTO ksp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jeju ndejede nya na dare dew oo tar neenn le ang. ");
INSERT INTO ksp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","N̂-tel n̂-pa bbay na: « To maji kare Ngonn le dew oo ndoo nya, kare tɔku dewje le *Jiipije ke tɔku nje-poloje Lubba, ke *nje-kɔruje-gel-ndu mbeteje, kare n̂-tɔleje ngaa ndɔ muta goe te a nin me buwa-yo te.» ");
INSERT INTO ksp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","N̂-pa narede tɔyn na: « Bbo dew ke ndiki ta kuwa gom a, maji kare neje rɔe ang. Maji kare noto kake-dese laa ke ndɔ tɔyn ngaa nuwa gom. ");
INSERT INTO ksp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Dew ke ndiki ta ngem tebbe laa, a tebbe laa le a goto. A dew ke a koy mba tar lem, dew le a kinga tebbe laa. ");
INSERT INTO ksp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bbo dew inga ne ke nangê neenn tɔyn, a bbo n̂-nayn ke kɔrɔ, wase ne njaa n̂-tuju rɔe a ddi bba na kinga goe te wa? ");
INSERT INTO ksp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tɔkɔrɔ dew ke dda rɔ-kul lem ngaa dda rɔ-kul ta pa tar lem a, Ngonn le dew a dda rɔ-kul laa ndɔ te ke na ddee ke ndoko laa, ke le bɔeje, ke le nje-kulaje le Lubba ke maji tɔyn. ");
INSERT INTO ksp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","M-pa tar ke tɔkɔrɔ marese, mare dewje ke areje horose te neenn a koyje ang bbay a *Kɔn̂-bbe le Lubba a ddee. ");
INSERT INTO ksp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ndɔ jijoo go tarje teenn le a, Jeju aw ke Piyar, ke Jan, ke Jake dɔ er te mba duju Lubba. ");
INSERT INTO ksp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kare te ke naw n̂-duju Lubba a keme turu to dang ngaa kubbu laa kara turu nda toke neyn. ");
INSERT INTO ksp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","A ta koo a, dewje joo aw paje saa tar : To Moyije de ke Eli a, ");
INSERT INTO ksp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","n̂-teeje ke ndoko ngaa daw paje tar koy le Jeju Jurusalam ke a ddee ne ke tɔkɔrɔ. ");
INSERT INTO ksp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Bbi dda Piyar de ke nje-buwa-kuraje laa nya, a disije kemde baa ngaa dooje ndoko le Jeju ke dingawje joo ke areje saa le. ");
INSERT INTO ksp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kare te ke dingawje ke joo le aw inyaje Jeju ta kɔtu a, Piyar pa are Jeju na: « Ebbemje to maji kare n̂-nayje neenn. N-ddaje ngann key-kamje muta: kara to lei, kara to le Moyije, a kara to le Eli.» A Piyar gere ne ke aw pa ang. ");
INSERT INTO ksp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kake naw n̂-pa tar baann a, mum ddee kiride de ngaa bbel dda nje-njaje go Jeju te kare te ke mum le aw dibbi dɔde. ");
INSERT INTO ksp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mare ndu tee me mum te le pa na: « Dew neenn to Ngonnum ke m-ndike, ooje tar laa.» ");
INSERT INTO ksp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kare te ke kɔru ndu le aw bbar a, Jeju ar ke kare baa ngaa. Nje-njaje go Jeju te paje tar ang. Me ndɔje teenn, dɔruje gel neje ke doojeenn le kara dareje dew ang. ");
INSERT INTO ksp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Toke lo are a, Jeju ke nje-njaje goe te dinje dɔ er te le n̂-ddisije a, dewje banya banya tilaje keme. ");
INSERT INTO ksp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Horo dewje teenn le mare dew uru eki na: Nje-ne-tɔju, muwa gɔli oo ngonnum neenn, mba n̂-to ngonnum ke kara baa. ");
INSERT INTO ksp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Bbo mare ndil uwa ngonn le a kem-naa te neenn nuru eki. Ndil le ddae are nisa ke singa ddem, jum-tae tee ddem ngaa ndil le ula keme ndoo ndereng bba inyae. ");
INSERT INTO ksp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","M-duju nje-njaje goi te ta kare n̂-tubba ndil le a daseje ang.» ");
INSERT INTO ksp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jeju tel ke tar are na: « Ko-dewje ke ooje mede te ang, ke nje-ne-ddaje ke maji ang. Ma kisi ke se ta kumase be sar ndɔ baann wa? E-ddee ke ngonni le neenn.» ");
INSERT INTO ksp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kake ngonn le aw ddee ngɔsi ke Jeju a, ndil ke maji ang le unne ilae nangê ngaa ddae are naw nisa ke singa. A Jeju ndange ndil ke maji ang le, nɔru rɔ-to le ngonn le ngaa n̂-tel saa nare bɔeje. ");
INSERT INTO ksp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","A *tɔku-mbange le Lubba dum dɔ dewje tɔyn. Toke neje ke Jeju aw dda le dum dɔ dewje a, n̂-pa nare nje-njaje goe te na: ");
INSERT INTO ksp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","« Esese e-tukaje mbise ke maje ooje ne tar neenn. Da kuwa Ngonn le dew kulae ji dewje te.» ");
INSERT INTO ksp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","A nje-njaje go Jeju te le gereje dɔde tar te ke naw n̂-pa narede le ang. Tar le iya rɔe ke de bba kare ta n̂-gereje ang. A bbel ddade ta tel duje tar dɔe te. ");
INSERT INTO ksp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kare teenn, nje-nja go Jeju te aw maynje naa tar ta gere dew ke bo horode te uta mareje tɔyn. ");
INSERT INTO ksp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","A Jeju gere keje le nje-njaje goe te le ngaa, unn mare ngonn ke ten be unndae mbɔre te, ");
INSERT INTO ksp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ngaa n̂-pa narede na: « Dew ke taa ngonn neenn ke rɔe te ke rim a, ema njaa n̂-taam ke rɔe teenn. A bbo dew ke taam ke rɔe te a, taa dew ke ulam ke rɔe te tɔ. Mba dew ke to ten baa horose te tɔyn, ne a n̂-to dew ke bo.» ");
INSERT INTO ksp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","A Jan pa na: « Ebbemje, joo mare dingaw ke unn rii aw tubba ne ndilje ke maji ang a n̂-gange ddewe te, mba n̂-nja goi te ke je ang.» ");
INSERT INTO ksp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jeju pa are na: « E-gangeje ddewe te ang, mba dew ke mbetese ang a, to dew lese.» ");
INSERT INTO ksp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Toke ndɔ ke Lubba a ta kunn Jeju ta tel saa darâ ddee ngɔsi a, n̂-ndiki nya ta kaw Jurusalam. ");
INSERT INTO ksp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nula dewje nɔe te kete. Dawje ngaa dandeje me mare bbe te le dewje ke Samari ta kare n̂-mɔseje ne n̂-ngebbeje. ");
INSERT INTO ksp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","A nje-bbeje le taeje ke rɔde te ang, mba nunn ddew ke Jurusalam. ");
INSERT INTO ksp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kake nje-njaje go Jeju te, Jake, ke Jan dooje baann a, n̂-paje na: « Ebbejeje, e-ndiki ta kare n̂-dujuje jare puru in darâ ddee ɔn dewje neenn wa?» ");
INSERT INTO ksp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jeju turu rɔe ke rɔde te ngaa kɔl ke de nya. ");
INSERT INTO ksp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Dunnje ddew dawje mare bbe te ke kete. ");
INSERT INTO ksp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kare te ke daw n̂-njaje ddew-bô a mare dew pa are Jeju na: « Lo tɔyn ke a kaw te, ma kunn goi.» ");
INSERT INTO ksp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jeju ilae te na: « Mulaje eeje ke buwa tode ngaa eelje ke darâ eeje ke key tode, a Ngonn le dew ee ke key dɔe ang.» ");
INSERT INTO ksp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jeju pa are mare dew na: « Unn gom.» A dew le ilae te na: « Ebbemje are maw m-dubbu bɔmje bba.» ");
INSERT INTO ksp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","A Jeju pa are na: « Inya dewje ke oyje are n̂-dubbuje yoje lede. A ei, aw pa tar *Kɔn̂-bbe le Lubba are dewje.» ");
INSERT INTO ksp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mare dew pa are Jeju bbay na: « Ma nja goi te Ebbemje, a are maw muwa ji nje ke lem bba.» ");
INSERT INTO ksp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jeju tel ke tar are na: « Dew ke uwa kɔsu-mange a bbo kel goe a nase dda kula wɔju *Kɔn̂-bbe le Lubba ang.» ");
INSERT INTO ksp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Goe te a, *Ebbe-dewje tel tɔru nje-njaje goe te dɔsiri horo mareje te. Nulade joo joo nɔe te kete kare dawje me bbeje te kara kara, ke loje tɔyn ke ne njaa n̂-ndiki ta kaw te. ");
INSERT INTO ksp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","N̂-pa narede na: « Kula mbɔn̂-ko bo nya a nje-kulaje banya ang. Yeenn a e-dujuje nje-ndɔɔ le are nula nje-kulaje kare n̂-mbɔnje ko laa. ");
INSERT INTO ksp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Awje! Ooje wa: Mulase toke le bateje horo enjakemjarje te. ");
INSERT INTO ksp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Awje ke bbɔl-ngem-nare ang, ke bbɔl-kungu-ne ang ddem, ke ne-gɔl ang ddem ngaa e-ddaje dew lapiya ke ddew ang ddem. ");
INSERT INTO ksp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Key ke andeje te a, e-paje na: *Me-wul-lɔm to me key te neenn! ");
INSERT INTO ksp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Toke nje-me-wul-lɔm ee key teenn a, *me-wul-lɔm lese a nayn saa. A bbo, nje-me-wul-lɔm ee me key teenn ang a, *me-wul-lɔm lese a tel rɔse te. ");
INSERT INTO ksp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","E-naynje me keye teenn le, usaje ne ke ayje ne ke darese, mbata dew dda kula ta kinga kuka laa. Andeje keyje te le dewje ke tae lem lem ang. ");
INSERT INTO ksp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Me mare bbe ke a teeje te, bbo n̂-taase ke rɔ-nel a, usaje ne ke darese. ");
INSERT INTO ksp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ɔruje rɔ-to rɔ nje-rɔ-toje te ke isije me bbe teenn ngaa e-paje arejede na: *Kɔn̂-bbe le Lubba to ke se ngɔsi baa ngaa. ");
INSERT INTO ksp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","A bbo, e-teeje me mare bbe te a duwase ke rɔde te ang a, aw areje nate bbe te le bba e-paje arejede na: ");
INSERT INTO ksp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","N-tunda bum ke uwa gɔlje me bbe te lese ngaa maji kare undaje dɔse te to *Kɔn̂-bbe le Lubba to ngɔsi baa ngaa. ");
INSERT INTO ksp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","M-pa marese to ddutu ndɔ a, sariya ke Lubba a gange dɔ bbe te neenn a ngeng kuta sariya ke Lubba gange dɔ Sɔdɔm te lew.» ");
INSERT INTO ksp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jeju pa bbay na: « Kem-to-ndoo a to lei, Korajen! Kem-to-ndoo a to lei, Betesayida! Mba, horo dewje te ke Tir ke Sidɔn a m-dda ne-mɔrije ke m-dda bbe lese a, da kulaje kubbu ndoo ngaa da kisije dɔ bu te, ta tɔju to n̂-turuje ddew le neje. ");
INSERT INTO ksp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Gele ke neenn baa, ndɔ gange sariya, a sariya ke Lubba a gange dɔse te a ngeng kuta sariya ke na gange dɔ dewje te ke Tir ke Sidɔn. ");
INSERT INTO ksp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A ei Kapernayum, a ndew sar kɔru dara wa? Lubba a dda kare e-ddom ase naa ke *lo le nje-yoje. ");
INSERT INTO ksp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Dew ke oo tar lese a oo tar lem ngaa dew ke mbetese to dew ke mbetem, dew ke mbetem a mbete ne ke nulam.» ");
INSERT INTO ksp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Dewje ke kɔrde dɔsiri le telje ke rɔ-nel ngaa paje na: « Ebbejeje, n̂-pa tar ke rii a, umaje kara ooje taje.» ");
INSERT INTO ksp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jeju pa arede na: « Moo Esu in darâ oso toke mare le ndi ke teel. ");
INSERT INTO ksp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ooje: Marese ddew ta kare e-njaje dɔ lije te ddem, dɔ nyije te ddem, ta kuta singa nje-baan ddem ngaa mare ne dang a kase jɔkuse ang. ");
INSERT INTO ksp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yeenn a, e-ddaje rɔ-nel mba ndilje ke maji ang ke ooje taseenn ang. A maji kare e-ddaje rɔ-nel mba rise ke Lubba dda me Maketurute darâ.» ");
INSERT INTO ksp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Me kare teenn njaa, Jeju ee ke koko ddew te le Ndil-me-nda ngaa Jeju le pa na: « Mɔsu gaji Bɔy, *Ebbe-dewje ke darâ ke *Ebbe-dewje ke nangê, mbata iya ne neenn nje-kem-kareje ke nje-ne-gereje ngaa e-tee ke ne neenn ke ddaka are ngannje ke ngaji. Tɔkɔrɔ njaa Bɔy, mba oo maji kemi te ta dda toke baann. ");
INSERT INTO ksp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Bɔy inya neje tɔyn me jim te. Dew kara gere Ngonn le ang. Bɔ kara baa a gere. Ddem dew gere Bɔ le ang. Ngonn kara baa gere, ke dew ke Ngonn ndiki tɔje Bɔ bba a gere tɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","N̂-turu rɔe ke rɔ nje-njaje goe te ngaa n̂-pa narede ke karede na: « Koko ee ke dewje ke ooje ne ke aw ooje! ");
INSERT INTO ksp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mba m-pa marese, nje-kilaje mber-tar le Lubba ke tɔku-mbayje banya banya isije ke bbo ta koo neje ke aw ooje neenn ke kemde a dooje ang. Disije ke bbo nya ta koo neje ke aw ooje ke mbise neenn a dooje ang.» ");
INSERT INTO ksp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mare *nje-kɔru-gel-ndu in taar ngaa duju tar Jeju mba nae ne. N̂-pa na: « Nje-ne-tɔju, ddi bba ma dda bba ma kinga ne tebbe ke ke ndɔ ke ndɔ wa?» ");
INSERT INTO ksp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jeju ilae te na: « Tar ddi a n̂-dda me Maketuru*ndu te wa? Ddi a e-tura me te wa?» ");
INSERT INTO ksp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","N̂-tel ke tar nare Jeju na: « Maji kare e-ndiki *Ebbe-dewje ke to Lubba lei ke mei tɔyn, ke kewn lei tɔyn, ke singai tɔyn, ke keje lei tɔyn ngaa maji kare e-ndiki nje-mari toke da rɔi njaa.» ");
INSERT INTO ksp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jeju pa are na: « E-tel ke tar ke dɔgɔle njaa. E-dda toke baann a, a kisi ke tebbe ke ke ndɔ ke ndɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","A naw n̂-sange ddew ta kɔru naji laa ngaa n̂-nduju tar Jeju na: « Nje-marem a to na wa?» ");
INSERT INTO ksp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jeju ilae te bbay na: « Mare ndɔ mare dingaw in Jurusalam aw ke Jeriko a noso me ji nje-bbokoje te. N̂-bbokoje neje laa tɔyn ngaa n̂-tundaeje dare n̂-nayn ngɔsi ta koy bba n̂-tuseje dinyaeje a dɔtuje. ");
INSERT INTO ksp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mare nje-polo Lubba unn ddew le ngaa n̂-tuka gɔle dɔ dew te le a nuja noso kete. ");
INSERT INTO ksp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Mare dew ke gel Lebi te tee lo teenn le tɔ. Noo dew le a nuja noso kete. ");
INSERT INTO ksp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","A mare dew ke Samari ke aw ke mba te, ddee ngɔsi ke dew le ooe a ddae ndoo. ");
INSERT INTO ksp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","N̂-tel n̂-ddee ngɔsi saa bbay, nungu wubbu ke ben kem doje te laa ngaa, n̂-tɔɔ. Nunne nundae dɔ kororo te laa njaa. Naw saa key-to-nje-mbaje te ngaa n̂-dda neje dang dang mba kare n̂-ddee maji. ");
INSERT INTO ksp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ndɔ kara goe te a, n̂-tɔru *kande-nare joo nungu ji nje-key te le ngaa n̂-pa nare na: E-ngeme ke maje. Toke e-tuju nare uta ye ke mari neenn a, telem a ema njaa ma kuka.» ");
INSERT INTO ksp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Goe te a Jeju tel duje na: « Horo dewje te ke muta neenn, na bba to nje-mar dew ke oso me ji nje-bbokoje te le wa?» ");
INSERT INTO ksp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nje-kɔru gel-ndu le ilae te na: « Dew ke dda saa me-maji le.» Jeju ilae te na: « Yeenn a, ei kara, aw ta e-dda toke baann tɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Toke Jeju de ke nje-njaje goe te daw n̂-njaje ddew-bô a, n̂-gange me mare bbe te ngaa mare dene ke ria na Mate gange. ");
INSERT INTO ksp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mate le ee ke ngokɔen ke dene ke ria na Mari. Ngokɔen le ddee isi nɔ gɔl *Ebbe-dewje te aw oo tar laa. ");
INSERT INTO ksp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Keje ngann kulaje dang dang uta dɔ Mate. N̂-ddee rɔ Jeju te n̂-pa nare na: « Ebbemje, keje lei jɔki mba ngokɔm ke inyam ta kula te ke karem neenn ang wa? E-pa saa are n̂-ddee numam.» ");
INSERT INTO ksp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","*Ebbe-dewje ilae te na: « Mate, Mate, mei aw sangi ngaa aw jɔku rɔi mba neje dang dang. ");
INSERT INTO ksp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","A ne ke uta neje tɔyn to kara baa. Mari a mbere ye ke maji. Dew a kase kɔru neenn le jia te ang ngaa.» ");
INSERT INTO ksp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mare ndɔ Jeju aw duju Lubba mare lo te. Toke n̂-duju Lubba tɔyn nunga a, mare nje-nja goe te pa are na: « Ebbejeje, e-tɔjuje gusu duju Lubba toke Jan tɔju nje-njaje goe te.» ");
INSERT INTO ksp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","N̂-pa narede na: « Toke aw dujuje Lubba a, e-paje na: Bɔy! Are dewje bbelje rii. Are *Kɔn̂-bbe lei ddee! ");
INSERT INTO ksp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Areje ne-kusa taje ke ndɔ kara kara tɔyn! ");
INSERT INTO ksp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ɔru tar *majang leje dɔje te, mba jeje kara jaw jɔru tar dɔ dewje te ke ddaje *majang ke je tɔ. Inya ddew are mare ne na meje ang.» ");
INSERT INTO ksp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jeju pa arede bbay na: « Na horose te neenn ee ke mare nje-buwa-kura laa, ke na kaw bbe laa til te ke lo mɔngu, mba pa kare na: Nje-buwa-kura, arem mapa muta m-tunai, ");
INSERT INTO ksp_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","mba mare nje-buwa-kura lem in mba te tee dɔm te, a moo ne kara ta kare ang. ");
INSERT INTO ksp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","A bbo dew ke kara le nayn ke me key te nu njaa a tel ke tar na: E-jɔkum ang, ta-key utu mban, ema ke ngannem n̂-to nangê mban bbo ddew ke ma kin taar kari ne mapa goto. ");
INSERT INTO ksp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","M-pa marese, le nin taar mba kare mapa le wɔju dɔ buwa-kura lede ang kara na kin mba kare ne tɔyn ke n̂-ndiki wɔju dɔ ne-jɔku laa. ");
INSERT INTO ksp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","A ema, m-pa marese: E-dujuje a da karese. E-sangeje a, a kingaje. Undaje ta-key a da kɔru karese. ");
INSERT INTO ksp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mba dew ke duju a dare, dew ke sange a inga ngaa dew ke unda ta-key a dɔru dare. ");
INSERT INTO ksp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Bɔ-ngonnje ke dda horose te neenn bbo ngonne duje kanji a li a na kare wa? ");
INSERT INTO ksp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ase bbo n̂-duje kabbe kunja a na kare nyi wa? ");
INSERT INTO ksp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Bbo esese ke mese maji ang e-gereje ta kare neje ke maji ngannse, a Bɔy ke darâ a kare Ndil-me-nda dewje ke dujeje ang wa?» ");
INSERT INTO ksp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jeju tubba ndil ke maji ang ke dda bba are gɔbbu mare dingaw utu. Toke ndil ke maji ang le tee me dingaw te le ke ddang a, dingaw le pa tar ngaa dewje ke banya ooje a dum dɔde. ");
INSERT INTO ksp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","A mare dewje kara kara paje na: « Ddew te le Belejebul ke to tɔku-mbay le ndilje ke maji ang a naw n̂-tubba ne ndilje ke maji ang le!» ");
INSERT INTO ksp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mareje dujeje ne-tɔju-ne* ke in darâ mba nae ne. ");
INSERT INTO ksp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jeju gere keje lede a, n̂-pa narede na: « Bbe-kɔn tɔyn ke dewje ddaje ddɔ ke naa ke te a tuju ngaa keyje a guruje dɔ naa te. ");
INSERT INTO ksp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Bbo Esu tel dda ddɔ ke da rɔe njaa, a kɔn̂-bbe laa a to baa bbay toke baann wa? Bba e-paje na ddew te le Belejebul a m-tubba ne ndilje ke maji ang wa? ");
INSERT INTO ksp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","A bbo ema, maw m-tubba ndilje ke maji ang ddew te le Belejebul, a ngannse ddew te le na aw tubbaje ne ndilje ke maji ang wa? Yeenn bba dede njaa da kuja kem tar neenn karese. ");
INSERT INTO ksp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","A bbo ddew singa te le Lubba a maw m-tubba ne ndilje ke maji ang a, yeenn tɔju to *Kɔn̂-bbe le Lubba ddee ndereng horose te. ");
INSERT INTO ksp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Toke dew ke nje-singa ke ungu ne-ddɔje rɔe te aw ngem ta-key laa a, ne-kingaje laa a to mɔkɔkɔ. ");
INSERT INTO ksp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","A bbo mare dew ke ubba singa utae ddee ake a, n̂-taa ne-ddɔje laa ke naw nunda mee dɔe te ngaa n̂-kayn dewje ne-kingaje laa ke n̂-taa le. ");
INSERT INTO ksp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Dew ke to lem ang to nje-tin sem, ddem dew ke mbɔn ne sem ang to nje-sane ne.» ");
INSERT INTO ksp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","« Bbo ndil ke maji ang tee me dew te a, n̂-nja loje te ke maann goto ke te, naw n̂-sange lo ta kula dɔe ke te ngaa toke ninga lo ang a n̂-pa na: Ma tel me key te lem ke min ke te m-tee le. ");
INSERT INTO ksp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Toke n̂-tel n̂-ddee a noo to duta me key le ngaa noo to n̂-mɔse me key le. ");
INSERT INTO ksp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Goe te a, n̂-tel naw n̂-ddee ke mare ndilje siri ke maji ang utae. Dandeje ngaa disije me dew te le ngaa dew le tuju uta kisi laa ke lew.» ");
INSERT INTO ksp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kake Jeju aw pa tar baann a, mare dene ke ar horo dewje te ke banya pa are ke taar na: « Koko ee ke dene ke uji ngaa ari mba il.» ");
INSERT INTO ksp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","A Jeju ilae te na: « Ke uta tɔyn koko ee ke dewje ke ooje tar le Lubba a ngemje.» ");
INSERT INTO ksp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Toke dewje aw mbɔnje naa banya a, Jeju pa na: « Dewje ke bbasine to dewje ke maji ang. Daw n̂-dujuje *ne-mɔri ke tɔju to min darâ, a *ne-mɔri ke tɔju ne ke Lubba dda ddew te le Jonase a da kooje kara baa. ");
INSERT INTO ksp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonase to *ne-mɔri ke tɔju singa-mɔngu le Lubba dewje ke Ninibe. Ddew kara baa Ngonn le dew a to *ne-mɔri mba dewje ke bbasine tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ndɔ gange sariya a, tɔku-mbay-dene ke Dagoo a kar ddew kara baa ke dewje ke bbasine ngaa na kunda tar dɔde te, mba nin kɔyn nange te n̂-ddee, mba koo tar kem-kare le Salemɔn. A dew ke uta Salemɔn a ee neenn. ");
INSERT INTO ksp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Dewje ke Ninibe a karje ndɔ gange sariya te naa te ke dewje ke bbasine ngaa a kundaje tar dɔde te, mba dooje tar le Jonase ngaa n̂-turuje ddew lede. A dew ke uta Jonase a ee neenn. ");
INSERT INTO ksp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ndɔ kara dew ila puru lambe te mba kunda lo kiyae te ang wase mba kunda kɔ dura te ang, a nunda lambe le dɔ ne te taar, mba kare dewje ke aw andeje key ooje ne lo. ");
INSERT INTO ksp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kemi to lambe ke da-rɔi te. Bbo kemi to ke maje a da-rɔi tɔyn to dann lo-kare te. A bbo kemi to ke maje ang a da-rɔi to lo-ndul te. ");
INSERT INTO ksp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Aa ke maje, are lo-kare ke to rɔi te to lo-ndul ang. ");
INSERT INTO ksp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bbo da-rɔi tɔyn njaa to dann lo-kare te ngaa mare debbe ten to lo-ndul te ang a, da-rɔi tɔyn a to dann lo-kare te toke le lambe ke uru ndoko laa dɔi te.» ");
INSERT INTO ksp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kake Jeju aw pa tar a, mare Parijiyen bbare ta kare naw nusa ne key laa. Naw ngaa nisi ta ne-kusa te le. ");
INSERT INTO ksp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Toke Parijiyen le oo to Jeju toko jia kete bba usa ne ang a, tar nyae. ");
INSERT INTO ksp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","A Ebbe-dewje pa are na: « Esee Parijiyenje, aw tokoje giri ngo ke giri ka, a keje bboko ke me-maji ang ddusu mese. ");
INSERT INTO ksp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nje-dɔ-gotoje! Dew ke nje-dda giri ne le dda mee tɔ ang wa? ");
INSERT INTO ksp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Areje neje ke unguje ngo te ke ka te nje-ndooje to ne-kare baa a, Lubba a tokose kare ne tɔyn a ddee maji mba tar lese. ");
INSERT INTO ksp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Kem-to-ndoo a ddase esee *Parijiyenje mba aw areje kam yambo, ke kam ne-ndiri, ke kam naynje tɔyn to *ne-polo, a ooje tar to gate gate ke tar ndiki Lubba to ne ang. To tar lese ta dda neenn ddem ta kinya kese neje ang ddem. ");
INSERT INTO ksp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Kem-to-ndoo a to lese Parijiyenje, mba lo-kisi ke kete a aw ndikije me key-mbɔn̂-naaje te ngaa e-ndikije ta kare n̂-ddase lapiya nata. ");
INSERT INTO ksp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kem-to-ndoo a to lese, mba e-toje toke le dɔbareje ke tula ke dew aw nja dɔe te a gere ang.» ");
INSERT INTO ksp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mare *nje-kɔru gel-ndu pa are Jeju na: « Nje-ne-tɔju, tar ke aw pa neenn aw tajije tɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jeju tel ke tar na: « Kem-to-ndoo a ddase tɔ ese *nje-kɔruje gel-ndu, mba aw undaje ne-koto ke ɔy nya dɔ dewje te, a esese ndɔn jise kara ɔruje ne ne-koto le ang. ");
INSERT INTO ksp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kem-to-ndoo a to lese, mba aw ddaje dɔbare nje-kilaje mber-tar le Lubba, dede ke kasese njaa a tɔljede. ");
INSERT INTO ksp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","E-toje to nje-tar-naji le kasese ngaa e-ndikije go kulaje ke n̂-ddaje, mba dede n̂-tɔlje *nje-kilaje mber-tar le Lubba, a esese aw ddaje dɔ-barede. ");
INSERT INTO ksp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Mba yeenn a Lubba pa ddew kem-kare te laa na: Ma kula nje-kilaje mber-tar ke *nje-kayn̂-kulaje karede. Da kula kemde ndoo ngaa da tɔlde. ");
INSERT INTO ksp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Yeenn bba Lubba a duju ji dewje te ke bbasine mese nje-kilaje mber-tar tɔyn ke n̂-kayn nangê. Unn kute ndɔ te ke Lubba dda dara ke nange. ");
INSERT INTO ksp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","A kunn kute mese Abel te ndereng mese Jakari te ke n̂-tɔle horo *bann te ke tɔku key-polo-Lubba te le *Jiipije. Tɔkɔrɔ m-pa marese, Lubba a duju mesede ji dewje te ke bbasine. ");
INSERT INTO ksp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Kem-to-ndoo a ddase, esee *nje-kɔruje gel-ndu, mba e-tɔje ddew dɔ ne-gere te. Esese njaa kara andeje lo ne-gere te le ang ngaa ɔkuje ddew dewje ke ndikije ta kande.» ");
INSERT INTO ksp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kake Jeju in me key te le tee a, *nje-kɔruje gel-ndu ke *Parijiyenje unnje kutu kubbaeje ke singa singa ngaa dare n̂-pa tar wɔju dɔ neje dang dang. ");
INSERT INTO ksp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","N̂-ddeeje, ta sange ddew kunda tar dɔe te ddew tar te ke tae te. ");
INSERT INTO ksp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Me kare teenn njaa, dewje mbɔnje naa banya banya ngaa daw mbɔynje gɔl naa. Jeju pa tar ke nje-njaje goe te dɔngɔr na: « E-ngemje rɔse ddew *wum* Parijiyenje ke to ngem. ");
INSERT INTO ksp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ne tɔyn ke iya rɔe a tee ke ddaka. Ne ke n̂-dda lo-kiyae te a dewje a gereje. ");
INSERT INTO ksp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Mbata yeenn a, tarje tɔyn ke a paje me til te, da koo tare dann̂-kara. Ne ke e-paje mbi dew te bbengere key te a da kila ne mber lum dɔ key te. ");
INSERT INTO ksp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","M-pa marese, ese nje-buwa-kuraje lem e-bbelje dewje ke a tɔlje da-rɔse ang, mba da kaseje ta dda mare ne dang goe te ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ma tɔjuse dew ke maji kare e-bbeleje. E-bbelje dew ke bbo tɔl dew mbaan, isi ke ddew mba kilae kem puru te. Tɔkɔrɔ maw m-pa marese, ne a maji kare ta e-bbeleje. ");
INSERT INTO ksp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Daw n̂-labbe ngann eelje mi gursu joo ang wa? A me Lubba oy dɔ mare kara ang. ");
INSERT INTO ksp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Bin dɔse kara Lubba tura kɔre tɔyn. Areje bbel ddase ang! Gatese uta gate ngann eelje ke banya. ");
INSERT INTO ksp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","M-pa marese, diew ke pa tar naji lem ke ddaka nɔ gɔl dewje te a, Ngonn le dew a kɔru tar naji laa nɔ gɔl anjije te le Lubba tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","A dew ke mbetem nɔ gɔl dewje te a, ma mbete nɔ gɔl anjije te le Lubba. ");
INSERT INTO ksp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Dew ke pa tar le Ngonn le dew maji ang a, Lubba a kɔru tar dɔe te, a dew ke taji Ndil-me-nda a, Lubba a kɔru tar dɔe te ang. ");
INSERT INTO ksp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Toke daw ke se key-mbɔn̂-naa te le *Jiipije, nɔ gɔl nje-gange-sariyaje te ke nje-kɔn̂-bbeje te a, areje mese sangese dɔ ddew te ke a kɔrije ne naji lese ang. ");
INSERT INTO ksp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mba me kare teenn njaa Ndil-me-nda a tɔjuse tar ke a to maji kare ta e-paje.» ");
INSERT INTO ksp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mare dew horo dewje te ke banya pa are Jeju na: « Ebbemje, e-pa are ngokɔm are n̂-kayn naa ne-ndubba leje.» ");
INSERT INTO ksp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jeju pa are dew le na: « Na bba undam to nje-gange-tar horo se te wase to nje-kaynse ne wa?» ");
INSERT INTO ksp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","N̂-tel ke tar narede na: « E-ngemje ddew lese ke maje ddew bbo ne-kinga te, mba le dew isi dann ne-kinga te kara, na kisi ke tebbe ddew te le ne-kingajeenn ang!» ");
INSERT INTO ksp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jeju pa mare gusu-tar arede na: « Nange ndɔɔ le mare nje-ne-kinga ande ne-kusa nya. ");
INSERT INTO ksp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Neje mee te na: Ma dda toke baann wa? Mba me ke lo ke ma mbɔn ne-ndɔɔje lem ke te ang. ");
INSERT INTO ksp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Goe te a, n̂-pa na, ma dda toke be: Ma tin damje lem, ma kuru dam-nɔrɔje, ma mbɔn waa lem tɔyn ke ne-kingaje lem kungu me te. ");
INSERT INTO ksp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ngaa ma pa kare kewn lem na: Kewn lem, isi ke ne-kingaje mba bbal banya. Uwa rɔi, usa ke ay bbo ta e-dda rɔ-nel. ");
INSERT INTO ksp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","A Lubba pa are na: Mbe! Til te neenn njaa ma kɔru kewn lei, a neje ke e-gɔl le a to le na ngaa wa? ");
INSERT INTO ksp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Dew ke mbɔn ne-kingaje mba tar dɔe njaa, a nɔ gɔl Lubba te ne-kinga laa a goto. Dew le to ddew kara baa toke le mbe le tɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Goe te a, Jeju pa are nje-njaje goe te na: « Mba yeenn a maw m-pa marese, e-sangeje mese dɔ tebbe te lese wɔju dɔ ne ke a kusaje ang ddem dɔ rɔse te mba kubbu ke a kulaje ang ddem. ");
INSERT INTO ksp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mba tebbe to ne ke uta ne-kusa ngaa rɔ dew uta kubbu. ");
INSERT INTO ksp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ooje egaanji: N̂-dubbuje ne ang ddem, dujaje koo ang ddem, deeje ke lo ngem ne-kusaje lede ang ddem, deeje ke dam ang ddem, a Lubba aw ngemde ke ne-kusa. Gatese uta gate eelje ang wa? ");
INSERT INTO ksp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Na horose te, ddew sange mee te ase kila gɔju kare dɔ ndɔ kisi maji te laa wa? ");
INSERT INTO ksp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Bbo ne ke ten baa kara aseje ta dda ang a mba ddi bba aw sangeje mese mba kese neje wa? ");
INSERT INTO ksp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ooje ddew ke ndijaje ke mû aw nduje ne: N̂-ddaje kula ang ddem, dujuje ne ang ddem. M-pa marese, Salemɔn njaa, ndɔ ri-bbar te laa kara ula kubbu toke mare kara horode te ang. ");
INSERT INTO ksp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Bbo Lubba dda kura rɔ mu te ke to me ndɔɔje te bbokone ngaa ndɔ ke bara a da kungu puro a, Lubba a dda ke se kare uta ang wa? Esee dewje ke koo-me-te lese to ngaji. ");
INSERT INTO ksp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","A esese, e-sangeje ne ke a kusaje ang ddem, ne ke a kayje ang ddem ta areje mese sangese ang tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mba nejeenn tɔyn dewje ke nange ne ke gereje Lubba ang a aw sangeje: A Bɔsese gere ne ke duse. ");
INSERT INTO ksp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","E-sangeje Kɔn-bbe laa dɔngɔr, a na karese nejeenn tɔyn dɔe te. ");
INSERT INTO ksp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Areje bbel ddase ang, esee ne-kuulje ke banya ang, mba Bɔsese oo maji ta karese Kɔn̂-bbe le. ");
INSERT INTO ksp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","E-labbeje neje lese bbo areje dangeteje to ne-kare-baa. Uruje bbɔl ke a ngisi ang, mba kungu ne-kingaje lese ke a tunga ndɔ kara ang darâ, lo te ke gɔl nje-bbokoje a kɔru ang ddem sɔlɔlɔje ke nje-tuju-neje a teeje te ang ddem. ");
INSERT INTO ksp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mba lo ke ne-kinga lei to te a mei a to te tɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","« Arje perere, uwaje bberse ke endar. Areje puru lambe lese oy ang. ");
INSERT INTO ksp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Esese, maji kare e-toje toke mare le dewje ke aw ngebbeje kare ta ebbedede in lo *kusu-taa-naa te ddee a unda ta-key a, dɔruje ke ngɔru dareje. ");
INSERT INTO ksp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Koko isi ke nje-kulaje ke ebbedede a tee kingade dɔ bbi te ang. Tɔkɔrɔ m-pa marese, na kula kubbu kula laa, na kare disije ta tabele te ngaa na ddee ngɔsi mba dda ke de. ");
INSERT INTO ksp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Le n̂-tel kare teke lo mɔngu wase ke nɔ le kuran̂-ke-ta-kara a ningade toke baann! Koko ee ke de. ");
INSERT INTO ksp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Maji kare e-gereje to, toke nje-key gere kare ke nje-bboko a ddee ne a, na ngem ta lo bbo na kinya ddew kare n̂-mbutu key laa ang. ");
INSERT INTO ksp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Esese kara areje dɔ gɔlse te, mba Ngonn le dew a ddee ke kare ke a kundaje mese dɔe te ang.» ");
INSERT INTO ksp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Piyar ilae te na: « Ebbemje, jeje a e-pa gusu-tar neenn areje wase dewje tɔyn wa?» ");
INSERT INTO ksp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","*Ebbe-dewje le tel ke tar are na: « Na to *nje-ngem-ne ke to gate gate ngaa to nje-kem-kare wa? Dew ke ebbeeje a kinya nje-kulaje laa jia te kare n̂-kaynde ne-kusa ke kare ke kare. ");
INSERT INTO ksp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Koko ee ke nje-kula le ke ebbeeje tel a, a kingae dɔ kula te toke baann! ");
INSERT INTO ksp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tar ke tɔkɔrɔ m-pa marese, na kinya ne-kingaje laa tɔyn me jia te. ");
INSERT INTO ksp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","A bbo nje-kula le pa mee te na: Ebbemje a ddee njange ang bbay. Ngaa nuru dɔ nje-kulaje te ke dingaw ke nje ke dene naw n̂-tundade, nusa ne ngaa nay ne nare ddae. ");
INSERT INTO ksp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ebbe nje-kula le a ddee ndɔ te ke nje-kula le unda mee dɔe te ang ddem, ke kare ke na gere ang ddem. Na tukae jakata jakata ngaa na kare ninga kuka laa ddew kara baa ke dewje ke toje gate gate ang. ");
INSERT INTO ksp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Nje-kula ke gere ne ke me ebbeeje ndiki bba gɔl ne ang ngaa dda ne ke me ebbeeje ndiki ang a, a kinga kunda ke bo nya. ");
INSERT INTO ksp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","A nje-kula ke gere ne ke me ebbeeje ndiki ang a dda ne ke ase kunda a da kundae ngaji baa. Da duju ne bo nya ji dew te ke dare ne ke bo nya ngaa dew ke dinya ne jia te nya a da duje ne nya. ");
INSERT INTO ksp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","M-ddee ta kila puru dɔ nange te. A m-ndiki nya kare puru le ɔn ngaa. ");
INSERT INTO ksp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mare batem ke da ddam to. Mem a kar kekere ndereng ndɔ ke batem le a ddee ne ke tɔkɔrɔ. ");
INSERT INTO ksp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ejeje to m-ddee ta kare *ddekeke to horo dewje ke dɔ nange te wa? Baann ang. M-pa marese, m-ddee ke tar kayn̂-naa. ");
INSERT INTO ksp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mba unn kute bbokone, bbo dewje mi isije me key te a da kayje naa, nje ke muta a mbete nje ke joo ngaa nje ke joo a mbete nje ke muta. ");
INSERT INTO ksp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bɔ a mbete ngonne ke dingaw ngaa ngonn ke dingaw a mbete bɔeje, kɔn a mbete ngonne ke dene ngaa ngonn ke dene a mbete kɔenje, kɔn ngonnje a mbete dene le ngonne ngaa dene le ngonn a mbete mumeje ke dene.» ");
INSERT INTO ksp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jeju tel n̂-pa nare dewje ke banya na: « Bbo ndɔ ke ooje ndi il lo kande te le kare a, e-paje na: Ndi aw ddee a ndi le ddee. ");
INSERT INTO ksp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ngaa ndɔ ke ooje yel ke dagoo aw ula a, e-paje na: Lo a nunga a, tɔkɔrɔ lo nunga. ");
INSERT INTO ksp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nje-ngemje, e-gereje ne ke a ddee dɔ nange te ke me dara te a toke baann bba e-gereje neje ke me ndɔje te neenn ang wa? ");
INSERT INTO ksp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Mbata ddi bba esese ke da-rɔse njaa e-gereje ne ke to gate gate ang wa? ");
INSERT INTO ksp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Toke aw aw ke dew ke ee saa ke tar ke nɔ gɔl nje-gange-sariya te a e-nayje ddew-bô bbay a, e-gɔl saa tar are nɔru tar dɔi te, mba n̂-tee sei nɔ gɔl nje-gange-sariya te a, nje-gange-sariya a kilai me ji mbamba te ngaa mbamba a kilai key-kula te. ");
INSERT INTO ksp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","M-pa mari, a kuka ndereng kese gursu kara a nayn ang bba a tee me key-kula te le.» ");
INSERT INTO ksp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kare teenn, mare dewje ddeeje paje areje Jeju tar le dewje ke Galile ke Pilate pole mesede ke mese daje lede ke n̂-ddeeje ne ta kare to *ne-polo Lubba. ");
INSERT INTO ksp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","N̂-tel ke tar narede na: « Ejeje to dewje ke Galile ke Pilate tɔlde le a toje to nje-ne-ddaje ke maji ang utaje kese dewje ke Galile tɔyn wa? Mba yeenn a dooje ne ndoo toke baann wa? ");
INSERT INTO ksp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Toke baann ang, m-pa marese: Bbo e-turuje ddew lese ang a, a koyje tɔyn toke baann tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Wase, dewje dɔku gire jijoo ke key ke ndew ke Silowe oso dɔde te tɔlde le, dede bba n̂-ddaje maji ang dutaje kese dewje ke Jurusalam tɔyn wa? ");
INSERT INTO ksp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Toke baann ang, m-pa marese: Bbo e-turuje ddew lese ang a, a koyje tɔyn toke baann tɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","N̂-pa gusu-tar neenn narede tɔ: « Mare dingaw dubbu tungu* me ndɔɔ te laa Naw ta kuja kande tungu le a ninga ang. ");
INSERT INTO ksp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ngaa, n̂-pa nare nje-kula laa na: Dda bbal muta ngaa, a m-ddee ta kuja kande tungu* neenn a, minga ang. E-tukae ke ddang na naw taa lo baa. ");
INSERT INTO ksp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nje-kula le tel ke tar are na: Ebbemje, inyae welne bbay. Ma kuru buwa guku ne gɔle ngaa ma kungu sin daje kɔye te, ");
INSERT INTO ksp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","se kaal a na kande wa. Baann ang bba ta are m-tukae.» ");
INSERT INTO ksp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mare *ndɔ-kuwa-rɔ le *Jiipije, Jeju aw tɔju ne me mare key-mbɔn̂-naa te lede. ");
INSERT INTO ksp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mare dene ke ndil ke maji ang tuju debbe rɔe dda bbal dɔku gire jijoo ee me key teenn. Ndil le dduke are ninga ddew ngaji ta ndɔju rɔe ang. ");
INSERT INTO ksp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jeju ooe ngaa pa are na: « Dene dɔri ta rɔ-to te lei ke ddang.» ");
INSERT INTO ksp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ngaa nila jia dɔe te, a kare teenn njaa, n̂-ndɔju rɔe ke maje ngaa nɔsu gaji Lubba. ");
INSERT INTO ksp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","A dew ke ɔn dɔ key-mbɔn̂-naa le rɔe nele ang, mba Jeju ɔru rɔ-to ke *ndɔ-kuwa-rɔ. Ngaa, n̂-pa nare dewje ke banya le na: « Jisi ke ndɔ misan ta dda ne kula. E-ddeeje are dɔre rɔ-toje lese me ndɔje teenn, bbo e-ddeeje ke *ndɔ-kuwa-rɔ ang.» ");
INSERT INTO ksp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","*Ebbe-dewje tel ke tar are na: « Nje-ngemje! Esese kara kara tɔyn, *ndɔ-kuwa-rɔ a e-tutuje daje lese lo ne-kusa te awje ke de areje dayje maann ang wa? ");
INSERT INTO ksp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ngaa dene neenn ke to ngonn le Abaraham a Esu tɔe bbal dɔku gire jijoo bbokone, to maji ta tute ke *ndɔ-kuwa-rɔ ang wa?» ");
INSERT INTO ksp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kake Jeju aw pa tar baann a, nje-baanji laa tɔyn rɔde wul. A dewje ke banya le rɔde nelde ddew neje te ke bo ke Jeju aw dda. ");
INSERT INTO ksp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jeju pa na: « Kɔn̂-bbe le Lubba unda rɔ ddi wa? Ma kunne kɔju ne ddi wa? ");
INSERT INTO ksp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","To ddew kara baa ke kande kake ke ten ke ria na mutarde ke dew dubbu me ndɔɔ te laa. Tee ngaa n̂-ddee bbuka kake are eelje ke darâ ddaje key lede me bar-kemeje te.» ");
INSERT INTO ksp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","N̂-pa bbay na: « Ddi a ma kunn kɔju ne *Kɔn̂-bbe le Lubba wa? ");
INSERT INTO ksp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","To ddew kara baa ke wum ke dene unn ungu me nduju te ke dɔju ka te muta bba bɔkɔlɔ ne are in tɔyn.» ");
INSERT INTO ksp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jeju tɔy me tɔku bbeje te ke me ngann bbeje te aw tɔju ne aw ne er ke Jurusalam. ");
INSERT INTO ksp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mare dew pa are na: « Ebbemje, dewje kara kara baa a, a kingaje kaji wa?» N̂-tel ke tar narede na: ");
INSERT INTO ksp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","« E-ddaje singa, andeje ke ta-key ke ten. Mba, m-pa marese: Dewje nya a sangeje ddew ta kande. A da kaseje ang. ");
INSERT INTO ksp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Bbo nje-key in taar utu ta-key a, a naynje ddaka, a bbo unnje kutu kunda ta-key ta pa na: Ebbejeje, ɔru ta-key areje! A na tel ke tar karese na: M-gere lo ke inje te ang. ");
INSERT INTO ksp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ngaa, a kunnje kutu pa na: Jusa ngaa jay ne kemi te ddem, e-tɔju ne dewje dɔ ddewje te leje ddem. ");
INSERT INTO ksp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","A na tel ke tar karese na: M-gere lo ke inje te ang. Ɔtuje ke ddang mbɔrum te, esese tɔyn ke e-ddaje ne ke ke maje ang. ");
INSERT INTO ksp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Lo teenn, a nɔje ngaa a ngerje ngangese, kare te ke a kooje Abaraham ke Ijake, ke Jakobbo, ke nje-kilaje mber-tar tɔyn me *Bbe-kɔn te le Lubba, a dilase ddaka. ");
INSERT INTO ksp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Dewje a kinje lo kande te le nayn ke lo kande te le kare. Da kinje beer ddem, dagoo ddem ngaa da kisije ta tabele te me *Bbe-kɔn te le Lubba. ");
INSERT INTO ksp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ngaa, mare dewje ke toje to dewje ke guku, a ddeeje to dewje ke dɔngɔr. A dewje ke dɔngɔr, a ddeeje to dewje ke guku.» ");
INSERT INTO ksp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kare teenn, mare *Parijiyenje awje ngɔsi ke Jeju paje areje na: « Ɔtu lo te neenn ke ddang mba *Erode ndiki ta tɔli.» ");
INSERT INTO ksp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","N̂-tel ke tar narede na: « Aw paje areje mula le toke be: Noo, maw m-tubba ndilje ke maji ang ngaa ma kɔru rɔ-to rɔ dewje te bbokone ke bara. Ndɔ muta laa a, kula lem a nunga ngaa. ");
INSERT INTO ksp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","A maji kare m-nja bbokone, ke bara, ke nuna. Mba maji kare *nje-kila mber-tar le Lubba oy lo te ke ddang ke Jurusalam ang. ");
INSERT INTO ksp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Dewje ke Jurusalam, dewje ke Jurusalam! Esese ke aw tɔlje nje-kila mber-tarje le Lubba ngaa aw tilaje dewje ke Lubba ulade arese ke er. M-ndiki nya ta mbɔnse toke kɔn̂-kunja aw mbɔn nganne kɔy bake te, a e-ndikije ang. ");
INSERT INTO ksp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ooje: Ma kinya key lese karese. A m-pa marese: A koomje ang sar ndɔ te ke a paje na: *Ebbe-dewje bbar Tar ke Maji dɔ dew te ke ddee ke ria.» ");
INSERT INTO ksp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Mare *ndɔ-kuwa-rɔ Jeju ande me key te le mare tɔku-mbay le *Parijiyenje ta kusa ne, ");
INSERT INTO ksp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","a kemde tɔyn to ke dɔe te. A mare dingaw ke mee ti are nɔe te. ");
INSERT INTO ksp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jeju pa tar are *nje-kɔruje gel-ndu ke *Parijiyenje le na: « *Ndu are ddew dew ta kɔru rɔ-to ke *ndɔ-kuwa-rɔ wase *ndu are ddew ang wa?» ");
INSERT INTO ksp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Dilaeje te ang ngaa nuwa nje-rɔ-to le nɔru rɔ-to laa ngaa nare nɔtu. ");
INSERT INTO ksp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Goe te a, n̂-pa narede na: « Na horose te neenn bbo ngonne wase mange laa tee oso me buwa-maann te ke *ndɔ-kuwa-rɔ a na kɔre ke tɔke ndɔe teenn njaa ang wa?» ");
INSERT INTO ksp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","A dingaje ddew kara ta tel ke tar dɔe te ang. ");
INSERT INTO ksp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Goe te a, Jeju pa gusu-tar are dewje ke tɔku-mbay le *Parijiyenje bbarde, mba noo ddew ke daw duwaje ne lo-kisi ke kete ngaa, n̂-pa narede na: ");
INSERT INTO ksp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","« Toke mare dew bbari *kusu-taa-naa te a, aw uwa lo-kisi ke kete ang. Mba bbo n̂-bbar mare dew ke bo utai tɔ, ");
INSERT INTO ksp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ngaa dew ke bbarse le ddee na: Inya lo-kisi are a, rɔ-kul a ddai ta kaw kisi lo te ke guku. ");
INSERT INTO ksp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","A, toke n̂-bbari a, aw uwa lo-kisi ke guku, ta bbo nje-bbari le ddee a pa na: Nam, aw isi kete. Yeenn a to ne kɔsu gaji kem dewje te tɔyn ke a kisije ta ne-kusa te sei. ");
INSERT INTO ksp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tɔkɔrɔ, dew ke dda rɔe bo a da dda kare n̂-ddee ten baa. A dew ke dda rɔe ten, a da dda kare n̂-ddee bo.» ");
INSERT INTO ksp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jeju pa are dew ke bbare le tɔ na: « Bbo e-bbar dewje ke ne-kusa ke bo a, e-bbar nje-buwa-kuraje lei ang, ngakɔinje ang, nje-ke-lei ang, nje-ninn̂-key marije ke toje nje-ne-kingaje ang, mba da ddaje ne-kusa bbarije ne tɔ. Yeenn a tɔju to inga kuka lei mban. ");
INSERT INTO ksp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","A bbo e-dda ne-kusa ke bo a, e-bbar nje-ndooje, nje ke jide wase gɔlde tuju, nje-meteje ke nje-kem-tɔje. ");
INSERT INTO ksp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","A, a kisi ke rɔ-nel mba dingaje ne ta kukai ne ang. A kinga kuka lei ndɔ kin te le nje-yoje ke gate gate.» ");
INSERT INTO ksp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mare dew horo nje ke isije ta ne-kusa te oo tarjeenn le a, pa are Jeju na: « Koko ee ke dew ke a kinga ne-kusa laa me *Bbe-kɔn te le Lubba.» ");
INSERT INTO ksp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ngaa Jeju ilae te na: « Mare dew dda tɔku *kusu ngaa bbar dewje toke banya. ");
INSERT INTO ksp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kare ne-kusa le ase a, nula nje-kula laa nare dewje ke n̂-bbarde le na: E-ddeeje mba ne tɔyn to ngɔsi ngaa. ");
INSERT INTO ksp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","A dewje le kara kara tɔyn na nuwaje gɔle, ningaje ddew ta ddee ang. Dew ke dɔngɔr na: M-ndoko ndɔɔ a ma kaw koo bba. Muwa gɔli ɔru tar dɔm te. ");
INSERT INTO ksp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mare pa na: M-ndoko mangeje dɔku, are m-ndiki ta nade. Muwa gɔli ɔru tar dɔm te. ");
INSERT INTO ksp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mare bbay pa na: M-taa dene bbasine bbay are minga ddew ta ddee ang. ");
INSERT INTO ksp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Toke nje-kula le tel a, ndaji tarjeenn le are ebbeeje. A wungu ɔn nje-key le ngaa pa are nje-kula laa na: Aw njange lo te ke dewje banya ke te, ke dɔ ddewje te ke tɔku bbe te neenn, bbo e-ddee ke nje-ndooje, ke nje ke jide wase gɔlde tuju, nje-kem-tɔje, ke nje-meteje lo te neenn. ");
INSERT INTO ksp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nje-kula le pa na: Ebbemje, m-dda ne ke ndui pa le mban, a kese lo nayn baa bbay. ");
INSERT INTO ksp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ngaa ebbe nje-kula le pa are na: Aw go ngann ddewje te ke go ndokoje uwa dewje ke singa are dandeje key are ta me key lem ddusu. ");
INSERT INTO ksp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mba m-pa marese: Ne-kusa lem a kɔru ta dew kara horo dede te ke m-bbarde a n̂-ddeeje ang.» ");
INSERT INTO ksp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Dewje ke banya banya aw njaje ddew-bô ke Jeju ngaa n̂-turu rɔe a n̂-pa narede na: ");
INSERT INTO ksp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","« Toke dew ddee rɔm te a maji kare n̂-mbete bɔeje ke kɔenje, ke dene laa, ke nganne, ke ngakɔenje, ke ngakɔn̂-naneje, ke tebbe laa. A bbo n̂-dda baann ang a, na to nje-nja gom te ang. ");
INSERT INTO ksp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ngaa dew ke oto kake-dese laa ang ngaa unn gom ang a, a to nje-nja gom te ang. ");
INSERT INTO ksp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Mba na horose te, bbo na ta dda tɔku key a, nisi nangê kete n̂-tura kɔr ne ke na tuju noo se nisi ke ne ase ta nunga ne key le bba nunn kutu dda key ang wa? ");
INSERT INTO ksp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mba toke nungu gɔl-key le nangê a bbo nase ta nunga ang a dewje tɔyn ke a kooje key le a kokoje ngaa a paje na: ");
INSERT INTO ksp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Dew neenn unn kutu dda key a ase ta dda nunga ang! ");
INSERT INTO ksp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","A se tɔku-mbay-bbe ke dda bba bbo aw ta dda ddɔ ke dewje laa doro dɔku ke mare tɔku-mbay ke ee ke dewje laa doro dɔjoo a, a kisi nangê kuwa dɔe koo kete se nisi ke singa ta dda ddɔ le bba naw ang wa? ");
INSERT INTO ksp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Bbo noo to singa ne ase ang ngaa nje-mare le nayn ddew ew bbay a, nula dew nare ta duje ne ke daseje ta dda bba kare me-wul-lɔm tel horode te. ");
INSERT INTO ksp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yeenn a, dew ke horose te ke mbete neje laa tɔyn ang, a to nje-nja gom te ang. ");
INSERT INTO ksp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Kate to ne ke maji. A bbo kate tel neel ang ngaa a, ddi bba dew a dda ke kate le bba a teel nel bbay wa? ");
INSERT INTO ksp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","N̂-to maji mba nange ang ddem, mba ndɔɔ ang ddem tɔ. Dungu kɔrɔ. Dew ke ee ke mbi ta koo ne tar a oo!» ");
INSERT INTO ksp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nje-taaje nare *lambo tɔyn ke nje-ne-ddaje ke maji ang ddeeje ngɔsi ke Jeju ta koo tar laa. ");
INSERT INTO ksp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","*Parijiyenje ke *nje-kɔruje gel-ndu aw nyuruje ngaa n̂-paje na: « Dew neenn taa nje-ne-ddaje ke maji ang ke rɔe te ngaa usa ne ke de.» ");
INSERT INTO ksp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","A Jeju pa gusu-tar neenn arede na: ");
INSERT INTO ksp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","« Dew ke dda horose te neenn, bbo ee ke bateje dɔdɔku a mare kara nayn a inya keseje ke dɔjikara gire jikara me mu te mba ndole gɔl ne ke n̂-nayn le ndereng mba kingae bba ang wa? ");
INSERT INTO ksp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Toke ningae a nilae dɔ bake te ke koko. ");
INSERT INTO ksp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kake n̂-tel key a, n̂-bbar nje-buwa-kuraje laa ke nje-ninn̂-key mareje n̂-pa narede na: E-ddaje sem rɔ-nel, mba minga bate lem ke nayn le. ");
INSERT INTO ksp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ddew kara baa m-pa marese, rɔ-nel ke a to darâ, mba nje-ne-dda ke maji ang kara ke turu ddew laa a kuta rɔ-nel ke to mba dewje ke gate gate dɔjikara gire jikara ke mal turu ddew lede ddade ang. ");
INSERT INTO ksp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Wase: dene ke dda bba ee ke *kande nare dɔku ngaa mare kara nayn a, ila puru *lambe te ang ddem, uta me key laa ang ddem ngaa sange ke maje ndereng inga nare le bba ang wa? ");
INSERT INTO ksp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Toke ninga *kande-nare le mbaan, n̂-bbar nje-buwa-mandeje laa ke nje-ninn̂-key mareje ngaa n̂-pa na: E-ddaje sem rɔ-nel mba minga *kande-nare lem ke nayn le. ");
INSERT INTO ksp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ddew kara baa, m-pa marese, rɔ-nel to nya horo anjije te le Lubba mba nje-ne-dda ke maji ang kara ke turu ddew laa.» ");
INSERT INTO ksp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jeju pa bbay na: « Mare dingaw ee ke ngannje ke dingaw joo. ");
INSERT INTO ksp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ye ke mbate pa are bɔeje na: Bɔy, arem ne-ndubba ke to wɔju dɔm. Ngaa bɔdede kaynde ne-kinga laa. ");
INSERT INTO ksp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Dda ndɔ ngaji goe te a, ngonn ke mbate le mbɔn ne-kingaje laa tɔyn ngaa aw ne mare bbe te ke ew. Keteenn, n̂-tuju ne-kinga laa ddew kula-ddaje te ke maji ang. ");
INSERT INTO ksp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kake n̂-tuju ne-kinga laa tɔyn a, tɔku bbo oso bbe teenn le ngaa ne unn kutu ta due. ");
INSERT INTO ksp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Naw nayn ke mare ngonn nje-bbe le. Ngonn nje-bbe le ulae me ndɔɔje te kare nul bereje. ");
INSERT INTO ksp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","N̂-ndiki ta kusa ne-kusaje le bereje le kare mee ndann a dew kara are ang. ");
INSERT INTO ksp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Neje mee te ngaa n̂-pa na: Nje-kulaje banya aw usaje ne ke maje key le bɔmje a ema, maw moy yo bbo lo te ke neenn! ");
INSERT INTO ksp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ma kin kaw ke rɔ bɔy te ngaa ma pa kare na: Bɔy, m-dda ne ke Lubba mbete ke ne ke mei mbete tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mase kare e-bbarem ngonni ang ngaa. E-ddam toke le mare nje-kulaje lei.» ");
INSERT INTO ksp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nin taar ngaa naw ke rɔ bɔeje te. Kake n̂-nayn ddew ew bbay a bɔeje le ooe a to ndoo laa, bɔeje le ayn ngɔru uwae ke kare te ngaa n̂-to mbia. ");
INSERT INTO ksp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ngonn le pa are na: « Bɔy, m-dda ne ke Lubba mbete ke ne ke mei mbete tɔ, mase kare e-bbarem ngonni ang ngaa.» ");
INSERT INTO ksp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","A bɔeje pa are nje-kulaje laa na: « E-ddeeje ke kubbu ke ngal ke kura nya njange ulaeje ngaa ulaje eninga ngonn jia te ke ne-gɔl gɔle te. ");
INSERT INTO ksp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","E-ddeeje ke ngonn mange ke eme bbo e-tɔleje areje jusaje ngaa n̂-ddaje rɔ-nel. ");
INSERT INTO ksp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Mba ngonnum ke ooeje neenn oy bba ndol. N̂-nayn bba dingae. Ngaa dunnje kutu dda rɔ-nel.» ");
INSERT INTO ksp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Kare teenn, ngonne ke to dere nayn ndɔɔ̂. Kake naw n̂-tel a n̂-nayn ngɔsi ke key a noo kɔru ne-kem ke kɔru pa. ");
INSERT INTO ksp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","N̂-bbar mare nje-kula n̂-duje tar dɔ neje te ke aw toje. ");
INSERT INTO ksp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nje-kula le pa are na: « Ngokɔin tel a bɔije tɔl ngonn mange ke eme, mbata n̂-tel ke rɔ ke maji.» ");
INSERT INTO ksp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Wungu ɔen are n̂-mbete ta kande key. Bɔeje tee ngaa duje nya kare ta nande key. ");
INSERT INTO ksp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","A nila bɔeje te na: « Oo, m-dda sei kula bbal banya ngaa, m-mbete tai ndɔ kara ang. Ngonn benya be kara arem m-dda ne ne-kusa m-bbar ne nje-buwa-kuraje lem ndɔ kara ang. ");
INSERT INTO ksp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","A ngonni neenn ke tuju ne-kinga lei tɔyn dɔ dene nje-kayaje te le a ddee a, e-tɔl ngonn mange ke eme are wa!» ");
INSERT INTO ksp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Bɔeje pa are na: « Ngonnum, ei, ee rɔm te neenn ke ndɔ tɔyn, are neje lem tɔyn to neje lei. ");
INSERT INTO ksp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Are to maji ta dda rɔ-nel, mba ngokɔin neenn oy bba ndol. N̂-nayn bba dingae.» ");
INSERT INTO ksp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jeju pa are nje-njaje goe te bbay na: « Mare dew ke inga ne nya ee ke mare *nje-ngem-ne laa. Dewje paje are dew le na *nje-ngem-ne le aw tuju neje laa. ");
INSERT INTO ksp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","N̂-bbar *nje-ngem-ne le ngaa n̂-pa nare na: Tar ddi a maw moo dɔi teenn wa? E-tura go neje ke aw ngem le are moo, mba a kase ngem ne lem ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","*Nje-ngem-ne le pa mee te na: Ebbemje a ta kɔrum ta neje te laa neenn, ddi a ma dda wa? Minga singa ta ndɔɔ ang ngaa ne-kɔy to rɔ-kul lem nya. ");
INSERT INTO ksp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","M-gere ne ke ma dda, kare bbo n̂-tubbam ta neje te laa a, mare dewje taamje ke key lede. ");
INSERT INTO ksp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nare n̂-bbar dewje kara kara tɔyn ke bbange le ebbeeje to dɔde te ngaa n̂-pa nare dew ke dɔngɔr na: Baann a a tel ne kare ebbemje wa? ");
INSERT INTO ksp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nilae te na: Ma tel ke ubbu ku te ke bo dɔdɔku. Ngaa *nje-ngem-ne le pa are na: E-taa maketuru bbange bbo ta isi nangê ke tɔke e-dda kɔre to dɔmi. ");
INSERT INTO ksp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","N̂-pa nare mare bbay na: A ei, baann a a tel ne waa? Nilae te na: Ma tel ke waa bbɔl dɔdɔku. Ngaa n̂-pa nare na: E-taa maketuru bbange lei bbo ta e-dda to kɔre dɔjijoo. ");
INSERT INTO ksp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ebbe nje-ngem-neje ke to gate gate ang le ɔsu gaje, mba *nje-ngem-ne le dda ne ke kem-kare. Mbata dewje ke bbasine ddaje ne ke kem-kare ddew te le ngann maredeje uta ngann lo-kareje le Lubba ke eeje me lo-kare te.» ");
INSERT INTO ksp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","« A ema, m-pa marese: Uwaje buwa-kura ke dewje ke nare bukuru, mba kare ndɔ ke nare le goto jise te a, n̂-taase ke key ke a to ke ndɔ ke ndɔ. ");
INSERT INTO ksp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Dew ke dda ne ke ten ke dɔgɔle, dda ne ke bo ke dɔgɔle tɔ ngaa dew ke to gate gate ddew ne te ke ten ang, to gate gate ddew ne te ke bo ang tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Bbo e-ddaje ne ke dɔgɔle ke nare bukuru ang a, na a kinya ne-kinga ke tɔkɔrɔ jise te wa? ");
INSERT INTO ksp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ngaa bbo e-ddaje ne ke dɔgɔle ang ke ne-kinga ke to le dew a, na a karese ne ke to lese wa? ");
INSERT INTO ksp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nje-kula kara ase dda kula kɔ dewje te joo ang, mba na mbete mare kara a na ndiki mare kara, wase na kunn rɔe kare mare kara a na dabbe mare ke kara. Aseje ta dda ke Lubba ddem ke ne-kinga ddem ang.» ");
INSERT INTO ksp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","*Parijiyenje ke ndikije nare nya ooje tarjeenn le tɔyn a aw kokoje Jeju. ");
INSERT INTO ksp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jeju pa arede na: « Esese aw ddaje rɔse to dewje ke gate gate kem dewje te. A Lubba gere mese, mba ne ke dewje ooje bo kemde te, to ne ke maji ang nya kem Lubba te. ");
INSERT INTO ksp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","*Ndu le Moyije ke tar le nje-kilaje mber-tar le Lubba toje ndereng ndɔ te le Jan. Unn kute ndɔe teenn daw n̂-pa tar *Kɔn̂-bbe le Lubba to Tar ke Maji dare dewje, a na na kara aw dda singa mba kande ke te. ");
INSERT INTO ksp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","To ngeng ang ta kare dara ke nange ndayje, a to ngeng nya kare mbita gɔl maketuru *ndu kara oso nangê. ");
INSERT INTO ksp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Dew ke tubbae dene laa a taa mare, dda lo-to-majang ngaa dew ke taa dene ke ngaweje tubbae dda lo-to-majang tɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jeju pa bbay na: « Mare dew ke to nje-ne-kinga ngaa aw ula kubbu nare ee teenn. Ndɔ kara kara tɔyn dingaw le aw usa ne ke dɔ-bo. ");
INSERT INTO ksp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Mare nje-ndoo ke rɔe to do jamani jamani, ria na Lajar to ta-ddew-key te le nje-ne-kinga le. ");
INSERT INTO ksp_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","N̂-ndiki ta kusa buru ne-kusaje ke aw gaynje kɔ tabele te le nje-ne-kinga le, a dɔe te bbay bisije ddeeje aw tɔɔnnje doje laa. ");
INSERT INTO ksp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nje-ndoo le oy ngaa anjije unaeje awje saa dɔ ji Abaraham te. Nje-ne-kinga le oy tɔ ngaa n̂-dubbe. ");
INSERT INTO ksp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kem-to-ndoo aw ddae lo te le nje-yoje ngaa nunn keme a noo Abaraham ddew ew ngaa noo Lajar ar dɔ ji Abaraham te. ");
INSERT INTO ksp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nuru eki na: Bɔy Abaraham, oo kem-to-ndoo lem! Ula Lajar are ula ndɔn̂-jia maann te ila ndɔm te are wul, mba kem-to-ndoo aw ddam kem puru te neenn. ");
INSERT INTO ksp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abaraham ilae te na: Ngonnum ole mei to inga neje ke maji ndɔ kisi ke tebbe te lei, a Lajar inga wungu ndɔ kisi ke tebbe te laa. Bbasine Lubba bɔru maann̂-nɔ keme te lo te neenn, a ei, kem-to-ndoo aw ddai. ");
INSERT INTO ksp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Dɔe teenn tɔyn, mare tɔku buwa to horoje te ke esese, mba kare dewje ke ndikije ta kinje neenn kaw er ke rɔse te a aseje ta kaw ang ddem, ta kare dew ase kin rɔse te nu ddee er ke rɔje te ang ddem. ");
INSERT INTO ksp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Nje-ne-kinga le na: Yeenn a m-duji bɔy, kare ula Lajar key le bɔmje, ");
INSERT INTO ksp_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","mba mee ke ngakɔmje ke dingaw mi. Maji kare naw n̂-ndejede nare n̂-ddeeje lo kem-to-ndoo te neenn ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abaraham ila te na: *Ndu le Moyije ke tar le nje-kilaje mber-tar le Lubba to horode te. Maji kare dooje tar lede! ");
INSERT INTO ksp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ngaa nje-ne-kinga le pa na: Baann ang bɔy Abaraham, a bbo dew in horo nje-yoje te aw rɔde te a, da turuje ddew lede. ");
INSERT INTO ksp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ngaa Abaraham le pa are na: Bbo dooje tar *ndu le Moyije ke tar le nje-kilaje mber-tar le Lubba ang, a le mare dew in horo nje-yoje te kara da kooje tar laa ang tɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jeju pa are nje-njaje goe te na: « Ne ke a dda kare dew oso me *majang te a to ke ndɔ tɔyn, a kem-to-ndoo a dda dew ke a dda kare mare dewje osoje me *majang te. ");
INSERT INTO ksp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ta tɔ ne ke ɔy gɔse te kilae me ba te maji nya uta kare n̂-dda nare ngonn kara horo ngann mareje te oso me *majang te. ");
INSERT INTO ksp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Aaje rɔse! Toke ngokɔin dda *majang a, e-ndange a bbo n̂-turu ddew laa a ɔru tar dɔe te. ");
INSERT INTO ksp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","A bbo me ndɔ te ke kara baa njaa n̂-dda sei *majang gɔl siri ngaa n̂-tel rɔi te gɔl siri tɔ ta pa kari na: M-turu ddew lem a, ɔru tar dɔe te.» ");
INSERT INTO ksp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nje-kayn̂-kulaje paje are *Ebbe-dewje na: « E-dda are koo-me-te leje bo.» ");
INSERT INTO ksp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ngaa *Ebbe-dewje le pa na: « Bbo koo-me-te lese to ngaji toke mare le kande mutarde ke ten, a bbo e-paje areje kake neenn na: Ɔru ke ngirai bbo aw e-maa rɔi bâ a, na koo tase. ");
INSERT INTO ksp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Dew ke dda horose te, bbo ee ke nje-kula ke aw ndɔɔ̂ wase aw ngem ne-kuulje a kare te ke nin mû n̂-tel a, a pa kare nje-kula laa na: E-ddee isi ta ne-kusa te kem naa te neenn wa? ");
INSERT INTO ksp_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Baann ang, na pa kare nje-kula laa na: E-dda ne-kusa ke lo kul te arem, ula kubbu ke maji bbo e-dda sem ndereng arem musa ne ke may ne bba ta goe te a usa ne ke ay ne. ");
INSERT INTO ksp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Na tel kare wooyo nje-kula le wɔju dɔ kula ke n̂-dda ke turu ndue wa? ");
INSERT INTO ksp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Esese, ddew kara baa, toke e-ddaje ne tɔyn turu ndu te ke darese a e-paje na: N-toje to nje-kulaje ke kari baa, n̂-dda ne ke to tar leje ta dda.» ");
INSERT INTO ksp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Kaw le Jeju ke Jurusalam a, n̂-nday horo nange te ke Samari ke Galile. ");
INSERT INTO ksp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Naw nande me mare bbe te a, nje-banjije dɔku ddeeje ke rɔe te ");
INSERT INTO ksp_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ngaa areje ddew ew, n̂-paje tar ke taar na: « Jeju, Nje-ne-tɔju, oo kem-to-ndoo leje!» ");
INSERT INTO ksp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jeju oode a pa arede na: « Aw tɔjuje rɔse nje-poloje Lubba.» Ngaa, kake daw dawje a rɔde tel ddee maji. ");
INSERT INTO ksp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mare kara horode te oo to rɔe ddee maji a uru tel ngaa ɔsu gaji Lubba ke taar. ");
INSERT INTO ksp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Noso nangê, n̂-debbe keme nangê nɔ gɔl Jeju te ngaa nare wooyo. N̂-to dew ke Samari. ");
INSERT INTO ksp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jeju pa na: « Nje-banjije ke dɔku tɔyn a rɔde ddee maji ang wa? Dede ke jikara deeje dda wa? ");
INSERT INTO ksp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bbaye njaa to nje-mba neenn a tel ddee ngaa piti Lubba wa?» ");
INSERT INTO ksp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Goe te a n̂-pa nare na: « In taar, aw lo lei, koo-me-te lei aji mban!» ");
INSERT INTO ksp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","*Parijiyenje dujuje Jeju mba gere kare ke *Kɔn̂-bbe le Lubba a ddee ne a, nilade te na: « *Kɔn̂-bbe le Lubba a ddee toke mare le ne ke kem dew a koo ang. ");
INSERT INTO ksp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Dewje a paje na: Ooje nee neenn, wase nee yoonn ang: Mba ooje, *Kɔn̂-bbe le Lubba ee horose te.» ");
INSERT INTO ksp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ngaa Jeju pa are nje-njaje goe te na: « Dɔ ndɔje te ke aw ddee, a kisije ke bbo mba koo mare ndɔ kara horo ndɔje te le Ngonn le dew a, a kooje ndɔ le ang. ");
INSERT INTO ksp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Da pa karese na: Nee neenn, nee yoonn. Awje loe te ang ddem aynje ngɔru ke loe te ang ddem. ");
INSERT INTO ksp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ddew kara baa toke ndi ke teel ngaa ndoko kɔyn dara te ke kara uru er kara. Ndɔ tel le Ngonn le dew a to toke baann tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","A dɔngɔr kete maji kare noo ndoo nya ngaa dewje ke bbasine mbeteje bba. ");
INSERT INTO ksp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ne ke tee dɔ ndɔ te le Nowe a tee ddew kara baa dɔ ndɔ te le Ngonn le dew. ");
INSERT INTO ksp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Dewje aw usaje, aw ayje, aw taaje naa, aw areje naa dene ndereng ndɔ te ke Nowe ande me tɔku to te ngaa maann ndi ke bo ddee tɔlde tɔyn. ");
INSERT INTO ksp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ndɔ tel le Ngonn le dew a to ddew kara baa ke ne ke to dɔ ndɔ te le Lote. Dewje aw usaje, aw ayje, aw ndokoje ne, aw labbeje ne, aw dubbuje ne, aw ddaje keyje. ");
INSERT INTO ksp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","A ndɔ te ke Lote unda lo tee me bbe te ke Sɔdɔm ke ddang a, puru in darâ gayn nangê toke mare le kɔju* ngaa tɔlde tɔyn. ");
INSERT INTO ksp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Neenn a to ddew kara baa ndɔ te ke Ngonn le dew a tɔju rɔe ke ddaka. ");
INSERT INTO ksp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Dɔ ndɔe teenn, dew ke a kisi dɔ key te ngaa neje laa to me key te a ddisi mba koto ang. Dew ke ee me ndɔɔ te, a tel kaw bbe ang. ");
INSERT INTO ksp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Oleje mese dɔ dene te le Lote. ");
INSERT INTO ksp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Dew ke a sange ddew ta ngem tebbe laa a tebbe laa a goto. A dew ke tebbe laa a nayn a tel kinga tebbe laa. ");
INSERT INTO ksp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","M-pa marese, me tile teenn bbo dewje joo toje dɔ tira te kara baa a, da kunn mare kara a da kinya ye ke kara. ");
INSERT INTO ksp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Deneje joo ke aw uruje ne birî naa te, da kunn mare kara a da kinya ye ke kara. ");
INSERT INTO ksp_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Dingawje joo ke eeje me ndɔɔ te, da kunn mare kara a da kinya ye ke kara. ");
INSERT INTO ksp_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nje-njaje goe te paje are na: « *Ebbe-dewje, lo ke dda bba nejeenn a to ke te wa?» Jeju ilade te na: « Lo ke ninn to ke te a malje a mbɔnje naa loe te.» ");
INSERT INTO ksp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jeju pa mare gusu-tar are nje-njaje goe te ta tɔju to to maji nya ta duju Lubba ke ndɔje tɔyn, ke rɔ nya ang. ");
INSERT INTO ksp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","N̂-pa na: « Nje-gange-sariya ke bbel Lubba ang ddem, oo dewje to ne ang keme te ddem ee mare tɔku bbe te. ");
INSERT INTO ksp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mare dene-ndubba ee me bbe teenn tɔ. Dene-ndubba le ddee rɔe te gɔl banya pa are na: E-gange sariya dɔ nje-baan te lem arem. ");
INSERT INTO ksp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Lew baa njaa, n̂-mbete. A goe te a neje mee te na: Tɔkɔrɔ njaa, m-bbel Lubba ang ngaa moo dewje to ne ang kem te. ");
INSERT INTO ksp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","A mba dene-ndubba neenn ɔru urum nya, ma gange sariya laa kare ta ndɔ ke guku a n̂-tel n̂-ddee n̂-jɔkum ang ngaa.» ");
INSERT INTO ksp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","*Ebbe-dewje ila te na: « Ooje tar pa le nje-gange sariya ke gate gate ang le. ");
INSERT INTO ksp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Yeenn a Lubba a gange sariya le dewje laa ke n̂-mberede, ke aw nɔje nɔ gɔle te til ke kare ang wa? Ngaa na ngebbe nya bba na kumade wa? ");
INSERT INTO ksp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","M-pa marese, na gange sariya lede ke ngɔru baa. A ndɔ ke Ngonn le dew a tel dɔ nange te a, na kinga dewje ke undaje mede dɔ Lubba te njaa wa?» ");
INSERT INTO ksp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jeju pa gusu-tar neenn bbay mba dewje ke ooje rɔde to dewje ke gate gate a ooje kese dewje maji ang. ");
INSERT INTO ksp_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","N̂-pa na: « Dewje joo awje key-polo-Lubba te ta duju Lubba. Mare kara to Parijiyen a ye ke kara to nje-taa nare-lambo. ");
INSERT INTO ksp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parijiyen le ar taar ngaa duju Lubba wɔju dɔe njaa na: Lubba, mari wooyo mba m-to toke kese dewje ang. Keseje toje to nje-bbokoje, nje-ne-ddaje ke gate gate ang, nje-ddaje lo-to-majang wase m-to toke nje-taa nare-lambo neenn ang. ");
INSERT INTO ksp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Maw m-mbete ne-kusa gɔl joo, me ndɔje te ke siri, mare *ne-polo Lubba ddew neje te tɔyn ke minga. ");
INSERT INTO ksp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","A nje-taa nare-lambo le ar ddew ew eje gusu kaa lo ke darâ pin a, unda kare na: Lubba, are mei oso pɔn dɔm te, ema nje-ne-dda ke maji ang. ");
INSERT INTO ksp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","M-pa marese, nje-taa nare-lambo le tel to dew ke gate gate kem Lubba te ngaa tel key laa, a Parijiyen le tel to dew ke gate gate ang. Mba dew ke ndiki koo rɔe bo a Lubba a dda kare n̂-ddee ten baa ngaa dew ke oo rɔe ten baa a Lubba a dda kare n̂-ddee bo.» ");
INSERT INTO ksp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ngann ngutayje njaa kara dewje aw ddeeje kede rɔ Jeju te ta kare nɔrude. A nje-njaje goe te ooje baann a aw ndangejede. ");
INSERT INTO ksp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jeju are n̂-bbar ngannje le ngaa pa na: « Inyaje ngannje ke ngaji areje ddeeje rɔm te bbo ɔkujede ddew ang, mba *Kɔn̂-bbe le Lubba to mba dewje ke toke lede neenn. ");
INSERT INTO ksp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tar ke tɔkɔrɔ m-pa marese, dew ke taa *Kɔn̂-bbe le Lubba toke ngonn kase ang a, a kande me te ang.» ");
INSERT INTO ksp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mare tɔku-mbay duju Jeju na: « Nje-ne-tɔju ke maji, ddi a ma dda bba ma kinga ne tebbe ke ke ndɔ ke ndɔ wa?» ");
INSERT INTO ksp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jeju pa are na: « Mba ddi bba e-bbarem ne to dew ke maji wa? Dew ke maji goto, se Lubba kara baa. ");
INSERT INTO ksp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","E-gere *ndu ke na: E-dda lo-to-majang ang, e-tɔl dew ang, e-bboko ang, e-pa tar ngem dɔ dew te ang, e-bbel bɔije ke kɔinje.» ");
INSERT INTO ksp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mbay le pa na: « M-ngem *ndujeenn tɔyn ke kasem baa.» ");
INSERT INTO ksp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Goe te ke Jeju oo tar laa a pa are na: « Mare ne kara dui bbay. E-labbe ne tɔyn ke inga bbo e-kayn nare dangeteje a, a kinga ne nya me dara te. Ngaa e-ddee unn gom.» ");
INSERT INTO ksp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kake tɔku-mbay le oo tar neenn le a, rɔe nele ang mba ninga ne nya. ");
INSERT INTO ksp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jeju ooe a pa na: « To ngeng nya ke nje-ne-kingaje ta kande me *Bbe-kɔn te le Lubba. ");
INSERT INTO ksp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mba kande le jambal buwa libbi te to ne ke ngeng ang uta kande le nje-ne-kinga me *Kɔn̂-bbe te le Lubba.» ");
INSERT INTO ksp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nje ke aw ooje tar laa le paje na: « Bbo baann a na bba a kase kinga kaji wa?» ");
INSERT INTO ksp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jeju ila te na: « Ne ke nya dewje nya Lubba ang.» ");
INSERT INTO ksp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Piyar pa na: « Oo, jinya neje leje ngaa junn goi.» ");
INSERT INTO ksp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jeju pa na: « Tar ke tɔkɔrɔ, m-pa marese, dew ke inya key, ke dene, ke ngakɔenje, ke kɔenje ke bɔeje wase nganne mbata *Kɔn̂-bbe le Lubba, ");
INSERT INTO ksp_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","na kinga ne nya me ndɔje te neenn ddem ngaa na kinga tebbe ke ke ndɔ ke ndɔ dɔ ndɔ te ke guku ddem.» ");
INSERT INTO ksp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jeju bbar *nje-kayn̂-kulaje laa ke dɔku gire joo ke rɔe te ngaa n̂-pa narede na: « Ooje, jawje ke Jurusalam ngaa neje tɔyn ke nje-kilaje mber-tar le Lubba ddaje me Maketurute wɔju dɔ Ngonn le dew a ddee ne ke tɔkɔrɔ. ");
INSERT INTO ksp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Mba da kilae me ji dewje te ke mbeteje Lubba, dewje a kɔjeje koko ne, da ddae maji ang, da tibbi nweren dɔe te. ");
INSERT INTO ksp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Da tundae ke ndey ngaa da tɔle. Ndɔ muta goe te a na kin me buwa yo te.» ");
INSERT INTO ksp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nje-kayn̂-kulaje le gereje ne me tar teenn kara ang. Kande tarjeenn le iya rɔe ke de. N̂-gereje ne ke Jeju a ta pa le ang. ");
INSERT INTO ksp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Toke Jeju ddee ngɔsi ke Jeriko a, mare nje-kem-tɔ isi mbɔr ddew te aw kɔy ne. ");
INSERT INTO ksp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Noo ndu dewje ke banya ke aw ndayje a n̂-duju ta gere gele. ");
INSERT INTO ksp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","N̂-pa dare na Jeju ke Najarete a aw nday. ");
INSERT INTO ksp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ngaa nje-kem-tɔ le pa ke taar na: « Jeju, Ngonn le Dabbiti, oo kem-to-ndoo lem!» ");
INSERT INTO ksp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Dewje ke aw njaje kete aw ndangeje kare ta new rɔe, a n̂-pa ke tar nya bbay na: « Ngonn le Dabbiti, oo kem-to-ndoo lem!» ");
INSERT INTO ksp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jeju ar lo kara ngaa unn ndue kare n̂-ddee saa ngaa, toke n̂-ddee saa ngɔsi a, Jeju duje na: ");
INSERT INTO ksp_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","« Ddi a e-ndiki ta kare m-dda sei wa?» Nilae te na: « Ebbemje, arem m-tel moo lo!» ");
INSERT INTO ksp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ngaa Jeju pa are na: « E-tel oo lo, koo-me-te lei aji!» ");
INSERT INTO ksp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kare teenn njaa n̂-tel noo lo ngaa nunn go Jeju naw nɔsu ne gaji Lubba. Dewje tɔyn ke ooje neenn le pitije Lubba. ");
INSERT INTO ksp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jeju ande me bbe te ke Jeriko ngaa aw riya me bbe le. ");
INSERT INTO ksp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mare dingaw ria na Jase. N̂-to nje-kɔn dɔ nje-taaje nare-lambo ngaa n̂-to nje-ne-kinga nee me bbe teenn, ");
INSERT INTO ksp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","naw n̂-sange ddew ta koo se Jeju to dew ke baann wa? A ninga ddew ta kooe ang, wɔju dɔ dewje ke banya, mba n̂-to dew-gɔju. ");
INSERT INTO ksp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nayn ngɔru kete ngaa naal kake ke ria na sikɔmɔr ta koo Jeju le, mba Jeju a ta nday lo teenn. ");
INSERT INTO ksp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Toke Jeju tee lo teenn le a, aa lo ke taar ngaa pa are na: « Jase e-ddisi ke tɔke, mba to maji kare misi me key te lei bbokone.» ");
INSERT INTO ksp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jase ddisi ke tɔke ngaa taa Jeju ke rɔ-nel. ");
INSERT INTO ksp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Dewje tɔyn ooje baann a, n̂-nyuruje ngaa n̂-paje na: « Naw nisi me key te le nje-ne-dda ke maji ang.» ");
INSERT INTO ksp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","A Jase ar nɔ *Ebbe-dewje te pa are na: « Oo, Ebbemje, ma kayn ne-kingaje lem danna kare nje-ndooje, a bbo m-dda ne ke mare dew ddew mare ne te ke dɔgɔle ang a, ma tel ke ne le kare ase gɔl sɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jeju pa are na: « Bbokone Lubba aji dewje ke key neenn, mba Jase to ngonn le Abaraham tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mbata Ngonn le dew ddee ta sange dew, ta kaji dew ke nayn.» ");
INSERT INTO ksp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Toke dewje ke banya aw ooje tar le Jeju le a, n̂-pa mare gusu-tar, mba nee ngɔsi ke Jurusalam ngaa dewje aw ejeje to *Bbe-kɔn le Lubba a ta ddee bbasine baa. ");
INSERT INTO ksp_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yeenn a n̂-pa na: « Mare dew ke nje ke gele te to dewje ke bo, a ta kaw ke mare bbe te ke ew mba kare dula tɔku-mbay dɔe te bba ta tel. ");
INSERT INTO ksp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","N̂-bbar mare nje-kulaje laa dɔku narede *kande-nare dɔku ngaa n̂-pa narede na: E-ddaje nare neenn are uju mare ndereng ndɔ tel lem. ");
INSERT INTO ksp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","A dewje ke bbe laa ndikeje ang ngaa dulaje mare dewje goe te kare paje na: N-ndiki ta kare ne neenn nɔn dɔje ang. ");
INSERT INTO ksp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Toke dula tɔku-mbay le dɔe te a, n̂-tel bbê. Nare n̂-bbar nje-kulaje laa ke narede nare le ke rɔe te mba gere baann a dede kara kara tɔyn dingaje dɔ mare te wa? ");
INSERT INTO ksp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nje-kula ke dɔngɔr ddee ngaa pa na: Ebbemje *kande-nare lei le uju mare dɔku. ");
INSERT INTO ksp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ebbeeje pa are na: Maji, nje-kula ke maji! Mundai to *ngonn tɔku-mbay dɔ ngann bbeje te dɔku, mba e-to gate gate ddew ne te ke ten. ");
INSERT INTO ksp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Joo le nje-kula le ddee ngaa pa na: Ebbemje *kande-nare lei uju mare mi. ");
INSERT INTO ksp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ebbeeje pa are na: Ei kara mundai dɔ ngann bbeje te mi tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mare ddee ngaa pa na: Ebbemje *kande-nare lei le a neenn, m-tɔ ke ta-kubbu bba m-ngem. ");
INSERT INTO ksp_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","M-bbeli nya mba e-to dew ke ngeng. Ne ke ila ang kara unn ddem, ne ke e-dubbu ang kara uja ddem. ");
INSERT INTO ksp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ebbeeje le pa are na: Nje-kula ke maji ang, ma gange sariya dɔi te ddew tar te ke tai te. E-gere to m-to dew ke ngeng. Ne ke mila ang kara munn ddem, ne ke m-dubbu ang kara muja ddem. ");
INSERT INTO ksp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Yeenn a mbata ddi bba ila nare lem lo-ngem-nare te, ta bbo m-tel a minga ribba dɔe te ang wa? ");
INSERT INTO ksp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Goe te a n̂-pa nare dewje ke areje lo teenn na: E-taaje *kande-nare le jia te areje ne ke ninga *kande-nare dɔku. ");
INSERT INTO ksp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Dewje le paje na: Mbay, ne ninga *kande-nare dɔku mban. ");
INSERT INTO ksp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mbay le pa na: M-pa marese, dew ke ee ke ne a, da kare mare dɔe te, a dew ke ee ke ne ang, ne ke ngaji ke ninga kara da kɔru jia te. ");
INSERT INTO ksp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","A nje-baanji lem ke ndikije ta kare mɔn dɔde ang le, e-ddeeje ke de bbo ujaje gɔbbude keem te neenn.» ");
INSERT INTO ksp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Go tar te ke Jeju pa baann a, noso kete nɔ dewje te ke banya naw er ke Jurusalam. ");
INSERT INTO ksp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Toke Jeju tee ngɔsi ke bbe ke Betepaje ke Betani, er ke dɔ ddingiri te ke daw n̂-bbar na ddingiri Olibiyeje a, nula nje-njaje goe te joo, ");
INSERT INTO ksp_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","n̂-pa na: « Awje bbe te ke nɔse te. Toke andeje me bbe te le a, a kingaje mare ngonn kororo ke dew kara isi dɔe te ang bbay ke n̂-tɔe. E-tuteje e-ddeeje saa. ");
INSERT INTO ksp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Bbo dew dujuse na: Mbata ddi bba e-tuteje wa? A e-paje na: Ebbejeje ndike.» ");
INSERT INTO ksp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nje ke Jeju ulade le awje ngaa ingaje neje le ddew kara baa toke n̂-pa narede. ");
INSERT INTO ksp_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kake daw n̂-tutuje ngonn kororo le a, nje-kororoje le paje arede na: « Mbata ddi bba aw tutuje ngonn kororo le wa?» ");
INSERT INTO ksp_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Dilaje te na: « *Ebbe-dewje ndike.» ");
INSERT INTO ksp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","N̂-ddeeje ke ngonn kororo le dare Jeju. Dunguje kubbuje lede dɔ kororo te le ngaa dare Jeju aale. ");
INSERT INTO ksp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ngonn kororo le aw nja ke Jeju a dewje aw najije kubbuje lede dɔ ddew te njal njal. ");
INSERT INTO ksp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","N̂-ddee ngɔsi ke Jurusalam ke ddew ke ta ddisi ne dɔ ddingiri Olibiyeje ke nangê a, rɔ nje-njaje goe te tɔyn ke banya nelde ngaa daw pitije Lubba ke taar wɔju dɔ ne-mɔrije tɔyn ke dooje. ");
INSERT INTO ksp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","N̂-paje na: « *Ebbe-dewje bbar Tar ke Maji dɔ tɔku-mbay te ke ddee ke ria! Me-wul-lɔm to me dara te, ke piti to loje te ke taar uta tɔyn!» ");
INSERT INTO ksp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mare *Parijiyenje ke eeje horo dewje te ke banya paje are Jeju na: « Nje-ne-tɔju, e-ndange nje-njaje goi te are dutuje tade.» ");
INSERT INTO ksp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nila te na: « M-pa marese, bbo dutuje tade a erje a kuruje eki.» ");
INSERT INTO ksp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Toke Jeju ddee ngɔsi ke Jurusalam ngaa oo bbe le a nɔ mba bbe le, ");
INSERT INTO ksp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ngaa n̂-pa na: « Jurusalam bbo to, ei njaa kara e-gere ne ke a kari *me-wul-lɔm me ndɔ te neenn a! A bbasine ne le iya rɔe are oo ang. ");
INSERT INTO ksp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Me ndɔje te ke aw ddee guku a, nje-baanji lei a kila ndoko guku ne dɔi, da kiri dɔi ngaa da korei ke yoo ke ne. ");
INSERT INTO ksp_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Da guri rum, ei ke dewje lei ngaa da kinya er ke dunda dɔ mare te ang, mba e-gere go kare ke Lubba ddee ta la ne sei ang.» ");
INSERT INTO ksp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jeju ande key-polo-Lubba te ngaa aw tubba nje-ne-labbeje, ");
INSERT INTO ksp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ngaa n̂-pa narede na: « Lubba pa me Maketurute laa na: Key lem a to key duju Lubba. A esese ddaje key le to lo kiya-rɔ le nje-bbokoje.» ");
INSERT INTO ksp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Naw n̂-tɔju ne ke ndɔ tɔyn me *key-polo-Lubba te le. Ngaa tɔku nje-poloje Lubba ke *nje-kɔruje gel-ndu ke tɔku dewje aw sangeje ddew ta tɔle. ");
INSERT INTO ksp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","A n̂-gereje ne ke ta dda bba ta tɔle ne ang, mba dewje tɔyn aw ooje tar laa nya. ");
INSERT INTO ksp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mare ndɔ kara horo ndɔeje teenn, Jeju aw tɔju ne dewje ke banya me key-polo-Lubba te ddem, aw ila mber-Tar ke Maji ddem. Tɔku nje-poloje Lubba, ke nje-kɔruje gel-ndu, ke tɔku dewje le *Jiipije undaje lo teeje. ");
INSERT INTO ksp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","N̂-paje dare na: « Ddew ddi te bba aw e-dda ne ne neenn wa, wase na njaa gate a ari ddew wa?» ");
INSERT INTO ksp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","N̂-tel ke tar narede na: « Ema kara ma dujuse tar tɔ: ");
INSERT INTO ksp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","E-paje aremje moo, na a ula Jan are dda batem dewje wa? Lubba wase dewje wa?» ");
INSERT INTO ksp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","A n̂-paje tar neenn horode te na: « Bbo jilaje te na: Lubba a a ulae a, na pa na: Mbata ddi bba e-ndikije te saa ang wa? ");
INSERT INTO ksp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Bbo n̂-paje na: Dewje a, dewje tɔyn a tilaje ke er tɔlje, mbata dooje to Jan to nje-kila mber-tar le Lubba.» ");
INSERT INTO ksp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yeenn a dilaje te na n̂-gereje lo ke batem le in te ang. ");
INSERT INTO ksp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jeju pa are de na: « Ema kara ma bbar ri dew ke arem ddew ta dda ne nejeenn le karese ang tɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Goe te a nunn kutu pa gusu-tar neenn kare dewje na: « Mare dew uwa ndɔɔ *nduu* ninya kula ndɔɔ le ji nje-ddaje kula ndɔɔ *nduu te a nɔtu naw mare bbe te ta dda ndɔ banya. ");
INSERT INTO ksp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nayn kuja kande-ko ase a, nje-ndɔɔ le ula mare nje-kula laa rɔ nje-ddaje kula me ndɔɔ *nduu* te le kare dulaje ke kande-nduu le dareje. Nje-ddaje kula me ndɔɔ *nduuje te uwaje nje-kula le tundaeje ngaa tubbaeje are n̂-tel jia baa. ");
INSERT INTO ksp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","N̂-tel nula mare nje-kula ke dang bbay a, duwaeje n̂-tundaeje, n̂-tajeje ngaa n̂-tubbaeje dare n̂-tel jia baa. ");
INSERT INTO ksp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Gɔl muta laa, n̂-tel nula mare nje-kula bbay a dareje do ngaa n̂-tubbaeje. ");
INSERT INTO ksp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nje-ndɔɔ le pa na: Ma dda to ddi a neenn wa? Ma kula ngonnum ke m-ndike nya, a du ang, da bbeleje. ");
INSERT INTO ksp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","A kake nje-ddaje kula me ndɔɔ *nduu* te le ooeje a n̂-paje na: Ne a n̂-to nje-kuwa ne-ndubba, areje n̂-tɔleje mba kare ta ne-ndubba le tel to leje. ");
INSERT INTO ksp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","N̂-teeje saa ke ddang me ndɔɔ te le ngaa n̂-tɔleje. Ddi ngaa nje-ndɔɔ *nduu* le a dda ke de bbasine ngaa neenn wa? ");
INSERT INTO ksp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Na ddee tɔl nje-ddaje kula me ndɔɔ *nduu* te le ngaa na kare ndɔɔ *nduu le mare dewje ke dang.» Kake dewje ke banya ooje tar le a, n̂-paje na: « Maji kare neenn to toke baann ang!» ");
INSERT INTO ksp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jeju ɔru keme aade a pa na: « Tar ke Lubba dda me Maketurute na: Er ke nje-kɔsuje key mbeteje. Er le tel ddee to singa gɔl key ke dungu nangê. Gel tar neenn na ddi wa? ");
INSERT INTO ksp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Dew ke oso dɔ er te le a singa rɔe a guru ngaa dew ke er le oso dɔe te a, er le a nyaren dew le.» ");
INSERT INTO ksp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kare teenn njaa tɔku nje-poloje Lubba ke nje-kɔruje gel-ndu aw sangeje ddew ta kuwaeje a ne kara, n̂-bbelje kem dewje. N̂-gereje to Jeju pa gusu-tar le wɔju dɔde. ");
INSERT INTO ksp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nje-poloje Lubba ke nje-kɔruje gel-ndu undaje kemde dɔ Jeju te ngaa, dulaje dewje ke nje-gusuje ke ddaje rɔde to dewje ke maji. Dewje le awje mba kingaje Tar ke Maji ang ta Jeju te bba ta kuwaeje kinyaeje ji nje-gange sariyaje ke nje-kɔn̂-bbe te. ");
INSERT INTO ksp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Dewje le dujeje tar neenn na: « Nje-ne-tɔju, n̂-gere to tar pa lei ke ne-tɔju lei to ke dɔgɔle ngaa ɔru kem dew ang. Aw tɔju ddew le Lubba ddew tar te ke tɔkɔrɔ. ");
INSERT INTO ksp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ndu areje ddew kare juka *lambo ke Sejar wase ndu mbete wa?» ");
INSERT INTO ksp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jeju gere gusu lede a ilade te na: « E-tɔjumje mare *kande-nare kara. ");
INSERT INTO ksp_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Endaji dɔ dew ke dunda ke ne ke n̂-dda nare te neenn to le na wa?» N̂-paje na: « To le Sejar.» ");
INSERT INTO ksp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yeenn a n̂-tel n̂-pa narede na: « Areje Sejar ne ke to le Sejar, areje Lubba ne ke to le Lubba.» ");
INSERT INTO ksp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Horo tarje te tɔyn ke Jeju pa kem dewje teenn, nje-gusuje le ingaje mare ne mba kunda ne tar dɔe te ang. Dutuje tade mba tar ke n̂-tel ne uta dɔde. ");
INSERT INTO ksp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","*Sadusiyenje ddeeje rɔ Jeju te. *Sadusiyenje toje dewje ke ooje mede te to kin le nje-yoje goto. N̂-dujeje tar neenn na: ");
INSERT INTO ksp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","« Nje-ne-tɔju, oo Moyije dda me maketuru te na: Toke dew taa dene ngaa ee ke ngonn ang a oy a, maji kara ngokɔen ta dene-ndubba laa uju ne ngannje ture te. ");
INSERT INTO ksp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ngakɔnaa eeje siri. Ne ke dɔngɔr n̂-taa dene ngaa nuju saa ngonn ang a noy. ");
INSERT INTO ksp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ne ke n̂-tee go ngokɔen te ke dɔngɔr n̂-taa dene-ndubba le, nuju saa ngonn ang a noy. ");
INSERT INTO ksp_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Muta lede taa dene-ndubba le a toke baann tɔ. Dede siri keme njaa n̂-taaje dene-ndubba le a dujuje ang a doyje. ");
INSERT INTO ksp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Gode te a, dene-ndubba le oy tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ndɔ kin le nje-yoje a na gate horo nje-me-kɔnje teenn ngaa a to nje-dene le wa? Mba dede siri keme n̂-taaje dene le go naa te.» ");
INSERT INTO ksp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jeju ilade te na: « Dewje ke dɔ ndɔje te neenn aw taaje dene ke aw taaje ngaw, ");
INSERT INTO ksp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","a dewje ke Lubba oo to daseje ta kin me buwa yo te ngaa da kisije ke tebbe dɔ ndɔje te ke aw ddee, da taaje dene ang wase da taaje ngaw ang. ");
INSERT INTO ksp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Da koyje ndɔ kara ang ngaa, mba da kaseje naa ke anjije ngaa da toje to ngann le Lubba, de nje-kinje horo nje-yoje te le. ");
INSERT INTO ksp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moyije pa tar kin le nje-yoje ndɔ te ke noo ne tar ke in me ber-kam te. N̂-bbar *Ebbe-dewje to Lubba le Abaraham, Lubba le Ijake, Lubba le Jakobbo. ");
INSERT INTO ksp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Lubba to Lubba le dewje ke oy ang, a n̂-to Lubba le dewje ke isije kem baa, mba keme te dewje tɔyn isije kem baa.» ");
INSERT INTO ksp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mare *nje-kɔruje gel-ndu ilaje te na: « Nje-ne-tɔju, e-pa tar maji nya.» ");
INSERT INTO ksp_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yeenn a mal dujeje tar ddade ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jeju pa arede na: « Ddew ddi ta a kaseje ta pa na Kiriste to ngonn le Dabbiti wa? ");
INSERT INTO ksp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dabbiti njaa pa me Maketurute le *Sɔme na: *Ebbe-dewje pa are Ebbemje na: Isi dɔ ji kɔlem te ");
INSERT INTO ksp_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ndereng ndɔ te ke ma dda kare nje-baanji lei telje to lo kungu gɔli. ");
INSERT INTO ksp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","A bbo Dabbiti bbar Kiriste *Ebbe-dewje a na to ngonne toke baann wa?» ");
INSERT INTO ksp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Dewje ke banya aw ooje tar le Jeju a, Jeju pa are nje-njaje goe te na: ");
INSERT INTO ksp_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","« Aaje rɔse rɔ *nje-kɔruje gel-ndu te, mba n̂-ndikije ta kula kubbu ke ngal bba ta nja ne. N̂-ndikije kare dewje ddade lapiya nata. N̂-ndikije ne-kisije ke to kete me key-mbɔn̂-naa te le *Jiipije ke ne-kisije ke dunda ta ne-kusa te kete. ");
INSERT INTO ksp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","N̂-taaje ne-kinga le dene-ndubbaje tɔyn, n̂-dujuje Lubba dare kure ew, mba kem dewje. Sariya ke Lubba a gange dɔde te a ngeng kuta sariya le kese dewje.» ");
INSERT INTO ksp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jeju unn keme a oo nje-ne-kingaje ke aw ilaje *ne-kare-baa lede me ka te me key-polo-Lubba te. ");
INSERT INTO ksp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Noo mare dene-ndubba ke to nje-ndoo ke aw ila ngann *kand-nare joo me ka te le tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","N̂-pa na: « M-pa marese, ke tɔkɔrɔ, dene nje-ndoo neenn ila nare uta kese dewje tɔyn, ");
INSERT INTO ksp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","mba ne ke dooje ne ta dda ne ang a dede tɔyn dilaje me ka te. A ne nila ne ke to ngeng saa nya. Bbay ne ke to ta kare n̂-ngem ne rɔe a nila.» ");
INSERT INTO ksp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mare dewje aw paje tar na: « Ooje key-polo-Lubba ke dɔsu ke erje ke kura ngaa n̂-dda dare kura ke neje ke dewje ddeeje ne to *ne-kare-baa are Lubba.» A Jeju pa na: ");
INSERT INTO ksp_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","« Ne ke aw ooje neenn mare ndɔje aw ddeeje ke da guru. Mare er ke dunda dɔ mare te a nayn taar ang.» ");
INSERT INTO ksp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Dewje le dujeje na: « Nje-ne-tɔju, ndɔ ke dda neenn le a to wa? Ngaa ddi a tɔju to nejeenn le a ta ddeeje wa?» ");
INSERT INTO ksp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jeju ila te na: « Aaje rɔse, areje derese ang, mba dewje nya a ddeeje ke rim ngaa da paje na: Ema Kiriste le a mare neenn. Mareje a paje na: Ndɔ nayn ngɔsi baa ngaa. A unnje gode ang. ");
INSERT INTO ksp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Toke a kooje tar ddɔ ke tar neje ke dewje a ddaje ke dɔ ngeng a, areje bbel ddase ang, mba maji kare neenn le tee dɔngɔr bba. A njange baa goe te a to ddutu ndɔ ang bbay.» ");
INSERT INTO ksp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Goe te a n̂-pa narede na: « Dewje a ddaje ddɔ ke naa ngaa mare bbe a dda ddɔ ke mare bbe. ");
INSERT INTO ksp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nange a yeke to bbel nya ngaa bbo a koso ke rɔ-toje ke dewje a koy ne nya a koso mare loje te. Mare ne-bbelje a teeje ngaa *ne-tɔju-neje* ke ngeng a kubbaje darâ.» ");
INSERT INTO ksp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","« A dɔngɔr kete kare nejeenn teeje a, da tundase ngaa da ddase maji ang, da kilase ji dewje te key-mbɔn̂-naa te le *Jiipije, da kilase key-kula te, da kaw ke se nɔ tɔku-mbayje te ke boy ke nɔ ngann tɔku-mbayje te wɔju dɔm. ");
INSERT INTO ksp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nejeenn le a karese ddew kare e-paje tar naji lem. ");
INSERT INTO ksp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","E-sangeje mese kete wɔju dɔ tar ke a paje, mba kɔru ne naji lese ang, ");
INSERT INTO ksp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","mba ma karese tar kem-kare ke a kuta singa nje-baanji lese wase tar ke nje-baanji lese a maynje ang. ");
INSERT INTO ksp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kɔnsese ke bɔsese, ngakɔnse ke nje-nujuje lese ke nje-buwa-kuraje lese njaa kara a kilase ji nje-baanji te ngaa da tɔl mareje nya horose te. ");
INSERT INTO ksp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Dewje a mbetese wɔju dɔm. ");
INSERT INTO ksp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","A ben dɔse kara a koso nangê ang. ");
INSERT INTO ksp_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Uwaje areje ngeng a, a kisije ke tebbe.» ");
INSERT INTO ksp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","« Toke ooje nje-ddɔje gukuje dɔ bbe ke Jurusalam a, e-gereje to kare ke da tuju ne Jurusalam ddee ngɔsi. ");
INSERT INTO ksp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kare teenn maji kare dewje ke a kisije nange Jude te, aynje ke dɔ ddingirije te, maji kare nje ke a kisije dann bbe te ke Jurusalam aynje ke ddang ngaa maji kare nje ke a kisije ngann bbeje te andeje me bbe te ke Jurusalam ang. ");
INSERT INTO ksp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mba a to ndɔ ke Lubba a gange sariya dɔ dewje te, mba kare neje tɔyn ke n̂-dda me Maketurute le Lubba ddeeje to ne ke tɔkɔrɔ. ");
INSERT INTO ksp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kem-to-ndoo a dda deneje ke a kuwaje sem, ke deneje ke aw areje mba ngannde me ndɔje teenn, mba ne-wungu ke bo a to me bbe te le, ke wungu a kɔn Lubba wɔju dɔ dewje ke bbe te le tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Da tɔlde ke tɔku kiya, da kaw ke de to bbereje horo dewje te ke mare bbeje te tɔyn ngaa mare dewje ke gelde to *Jiipije ang a mbɔynje Jurusalam ke gɔlde lake lake ndereng dɔ kare lede a kase. ");
INSERT INTO ksp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ne-tɔju-ne* a ddee ddew te le kare, ddew te le neyn, ke ddew te le endeterendeje. Dɔ nange te, bbel a dda dewje, da gereje ne ke da ddaje wɔju dɔ kɔru ba kate ke aw bbar ke lenge laa ang. ");
INSERT INTO ksp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bbel a tɔl dewje kare te ke daw n̂-ngebbeje ne ke a ddee dɔ nange te, mba singa-mɔnguje ke darâ tɔyn a yekeje. ");
INSERT INTO ksp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kare teenn dewje a kooje Ngonn le dew ke a ddee me mum te ke singa, ke ndoko. ");
INSERT INTO ksp_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Toke neenn unn kute ta ddee a, areje njarara ngaa uwaje dɔse ke taar, mba ndɔ kɔruse me bbere te nayn ngɔsi.» ");
INSERT INTO ksp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Goe te a Jeju pa mare gusu-tar arede na: « Ooje *kake tungu ke kese kakeje tɔyn. ");
INSERT INTO ksp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kake daw dunjuje, a esese njaa aaje a, e-gereje to bbar ddee ngɔsi ngaa. ");
INSERT INTO ksp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Esese kara ddew kara baa tɔ, bbo ooje nejeenn ke aw ddeeje a, maji kare e-gereje to *Kɔn̂-bbe le Lubba nayn ngɔsi. ");
INSERT INTO ksp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Tɔkɔrɔ m-pa marese, dewje ke bbasine neenn a koyje tɔyn ang a nejeenn tɔyn a ddeeje. ");
INSERT INTO ksp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Dara ke nange a ndayje, a tarje lem a ndayje ang.» ");
INSERT INTO ksp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","« E-ngemje maji, areje mese to ke dɔ ne te ke ta kusa kare uta dɔse ang, wase dɔ kay koto te ang, ddem dɔ bbo neje te ke nangê ang, mba kare ndɔ neenn le ddee dɔse te hɔy ");
INSERT INTO ksp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","toke le bura ang, mba ndɔ le a ddee busu dɔ dewje te tɔyn ke dɔ nange te. ");
INSERT INTO ksp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","E-tibbije ang ngaa e-dujuje Lubba ke kare tɔyn, yeenn bba a kingaje singa, mba tee ne ta ne te ke a ta ddee, ddem mba kare ne taar nɔ Ngonn le dew te.» ");
INSERT INTO ksp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Lo are a, Jeju aw tɔju ne me key-polo-Lubba te ngaa lo ndul a naw n̂-to dɔ ddingiri Olibiye te. ");
INSERT INTO ksp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Dewje tɔyn awje rɔe te key-polo-Lubba te ke kɔ-sin̂-endɔɔ mba koo tar laa. ");
INSERT INTO ksp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ndɔ *kusu ke daw dusa mapa ke n̂-dda ke *wum ang ddee ngɔsi. Daw n̂-bbar *kusu le na *kusu *Pake. ");
INSERT INTO ksp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tɔku nje-poloje Lubba ke *nje-kɔruje gel-ndu aw sangeje gusu ke ta tɔl ne Jeju, mba n̂-bbelje dewje. ");
INSERT INTO ksp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Esu ande me Judase te ke daw n̂-bbare na Isikaryote. N̂-to kara le *nje-kayn̂-kulaje le Jeju ke dɔku gire joo. ");
INSERT INTO ksp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judase aw mɔse tar ke tɔku nje-poloje Lubba, ke nje-kɔn dɔ dewje ke aw ngemje ta key-polo-Lubba wɔju dɔ gusu ke ta kila ne Jeju me jide te. ");
INSERT INTO ksp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Rɔde nelde ngaa dunnje ndude ta kare nare. ");
INSERT INTO ksp_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judase ndiki goe ke de ngaa aw sange ddew ke maji, ke na kila ne Jeju me jide te kare dewje ke banya gereje ang. ");
INSERT INTO ksp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Horo ndɔ *kusu te ke daw dusa mapa ke n̂-dda ke wum ang le, ndɔ tɔl ngann bateje dda ne muru *Pake ase. ");
INSERT INTO ksp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jeju ula Piyar ke Jan ngaa pa arede na: « Awje aw ddaje muru *Pake areje jɔnje.» ");
INSERT INTO ksp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","N̂-paje dareje na: « Lo ke dda e-ndiki ta kare n̂-dda muru le ke te wa?» ");
INSERT INTO ksp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nilade te na: « Ooje, toke a kandeje me tɔku bbe te toonn a, mare dew ke oto joo-maann a kingase. Awje goe te me key te ke na kande te, ");
INSERT INTO ksp_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ngaa e-paje are nje-key le na: Nje-ne-tɔju ulaje ari na: Me key ke dda ma kɔn muru *Pake ke *nje-kayn̂-kulaje lem te wa? ");
INSERT INTO ksp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Na tɔjuse tɔku me key ke to taar, ke n̂-mɔse neje ke te tɔyn mban. Lo teenn le a a ddaje muru ke te.» ");
INSERT INTO ksp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Dawje dingaje neje le toke n̂-pa narede ngaa n̂-ddaje muru *Pake le. ");
INSERT INTO ksp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Dɔ kare ne-kusa le ase a, nisi ta tabele te ke *nje-kayn̂-kulaje. ");
INSERT INTO ksp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","N̂-pa narede na: « M-ndiki nya ta kusa ke se *Pake neenn kete bba ta koo ndoo. ");
INSERT INTO ksp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Tɔkɔrɔ, m-pa marese, ma kusa *Pake mare ang ngaa ndereng ndɔ ke *Pake le a ddee to ne ke tɔkɔrɔ me *Bbe-kɔn te le Lubba.» ");
INSERT INTO ksp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nunn ngo-nare ke maan nduu to me te, nare wooyo Lubba ngaa n̂-pa na: « E-taaje maann̂-nduu ke ngo-nare te neenn e-kaynje naa. ");
INSERT INTO ksp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tɔkɔrɔ, m-pa marese, unn kute bbasine, ma kay maann̂-nduu* mare ang ndereng *Bbe-kɔn le Lubba a ddee. » ");
INSERT INTO ksp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Goe te a nunn mapa, nare wooyo ngaa n̂-tete narede ngaa n̂-pa narede na: « Mapa neenn to da-rɔm ke Lubba are mba tar dɔse. E-ddaje ne neenn mba kole ne mese dɔm te.» ");
INSERT INTO ksp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ddew kara baa, go ne-kusa te a nunn maann̂-nduu ke ngo-nare te narede ngaa n̂-pa na: « Maann̂-nduu ke ngo-nare te neenn to *kɔsu-dɔnɔ ke siki ddew mesem te ke kayn nangê mba tar dɔse. ");
INSERT INTO ksp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","A dew ke a ndoko dɔm ee sem ta tabele te neenn. ");
INSERT INTO ksp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ngonn le dew a koy, mba to ne ke Lubba a ɔju. A kem-to-ndoo a dda dew ke a ndoko dɔ Ngonn le dew le.» ");
INSERT INTO ksp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Daw n̂-dujuje naa se na horode te a, a dda neenn le wa? ");
INSERT INTO ksp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nje-kayn̂-kulaje aw maynje naa ta gere se na to dew ke bo horode te uta keseje wa? ");
INSERT INTO ksp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jeju pa arede na: « Mbayje ke dɔ dewje te aw ɔnje dɔde ngaa nje ke toje to nje-kɔn̂-bbeje areje dewje aw bbarjede to nje-ddaje me-maji. ");
INSERT INTO ksp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","A lese to ddew kara baa to ke baann ang. Maji kare dew ke bo nya horose te to toke mare le ngonn. Maji kare dew ke ɔn dɔ dewje to toke mare le nje-kula lede. ");
INSERT INTO ksp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Na to dew ke bo wa? Dew ke isi ta tabele te wase dew ke aw dda ke nje-kisi ta tabele te wa? Dew ke isi ta tabele te le a to dew ke bo ang wa? A ema, mee horose te toke mare le nje-kula le dewje. ");
INSERT INTO ksp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Esese e-naynje sem me ne-wunguje te ke ddee dɔm te. ");
INSERT INTO ksp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yeenn a ma karese *bbe-kɔn ddew kara baa toke Bɔmje arem, ");
INSERT INTO ksp_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","mba kare usaje ne ke ayje ne ta tabele te lem me bbe kɔn te lem ngaa kare ta isije ngende-mbayje te, ta gange sariya dɔ gel ngann Ijarayelje te ke dɔku gire joo.» ");
INSERT INTO ksp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","*Ebbe-dewje pa na: « Simɔ, Simɔ, Esu duju ta balse toke daw n̂-bal waa ta kare are. ");
INSERT INTO ksp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","A ema, m-duju Lubba mba tar lei, ta kare koo-me-te lei enge ang ddem, ta kare bbo e-tel rɔm te a e-dda bba are ngakɔinje uwaje koo-me-te lede are ngeng.» ");
INSERT INTO ksp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piyar pa are Jeju na: « Ebbemje, m-to ngɔsi ta kaw sei key-kula te ngaa ta koy sei.» ");
INSERT INTO ksp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jeju pa na: « Piyar, m-pa mari kete bba kare kuran nɔ bbokone, a mayn tar lem na e-gerem ang gɔl muta.» ");
INSERT INTO ksp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jeju pa arede bbay na: « Ndɔ ke mulase mare awje ke bbɔl-ngem nare ang ddem ke bbɔl kungu-ne ang ddem ke ne-gɔl ang ddem le se ne duse wa?» Dilaje te na: « Ne kara duje ang.» ");
INSERT INTO ksp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","N̂-pa narede na: « A ke bbasine, dew ke ee ke bbɔl-ngem-nare a unn, ddew kara baa dew ke ee ke bbɔl-kungu-ne a unn. A bbo dew ke ee ke tɔku kiya ang a, labbe kubbu laa mba ndoko ne tɔku kiya. ");
INSERT INTO ksp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","M-pa marese: Maji kare tar ke n̂-dda me Maketurute le Lubba te na: N̂-turae horo nje-ne-ddaje te ke maji ang le ddee ne ke tɔkɔrɔ dɔm te ngaa ne ke to wɔju dɔm a kunda ngange.» ");
INSERT INTO ksp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","N̂-paje dareje na: « Ebbejeje, tɔku kiya a joo neenn.» Jeju pa arede na: « Yeenn njaa ase.» ");
INSERT INTO ksp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Goe te ke Jeju in me key te le tee a, naw dɔ ddingiri Olibiyeje te toke naw n̂-dda ke ndɔ tɔyn. Nje-kayn̂-kulaje awje goe te. ");
INSERT INTO ksp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","N̂-tee lo teenn le a, n̂-pa narede na: « E-dujuje Lubba, mba kare osoje me ne-kere te ang.» ");
INSERT INTO ksp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Goe te a, nɔru rɔe naw ddew ew ase ngal le ne-kila, nɔsu gɔle nangê ngaa n̂-duju Lubba, ");
INSERT INTO ksp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","n̂-pa na: « Bɔy, toke e-ndiki a, uta ngo-nare kem-to-ndoo neenn dɔm te ke ddang. E-dda toke mei a ndiki bbo toke mem ndiki ang.» ");
INSERT INTO ksp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kare teenn mare anji tee ingae, mba kare singa. ");
INSERT INTO ksp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Rɔe nele ang nyom ngaa n̂-duju Lubba nya. Tete ke rɔe te tel toke le kɔr mese ke aw gayn nangê. ");
INSERT INTO ksp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nin taar go duju Lubba te le ngaa n̂-ddee rɔ *nje-kayn̂-kulaje te le. Rɔ *nje-kayn̂-kulaje le nelde ang ngaa aw tibbije bba n̂-ddee ningade. ");
INSERT INTO ksp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","N̂-pa narede na: « Mbata ddi bba aw tibbije wa? Inje taar, e-dujuje Lubba, mba kare osoje me ne-kere te ang.» ");
INSERT INTO ksp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Toke Jeju aw pa tar bbay a, dewje ke banya teeje. Kara le *nje-kayn̂-kulaje laa ke dɔku gire joo ke ria na Judase unn nɔ dewje ke banya le. Judase le ddee ngɔsi ke Jeju ta to mbia. ");
INSERT INTO ksp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jeju pa are na: « Judase, ila Ngonn le dew ji dewje te ddew to mbia te wa?» ");
INSERT INTO ksp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nje-kayn̂-kulaje ooje ne ke a ta ddee le a, n̂-paje na: « Ebbejeje, ja tukade ke tɔku kiya le wa?» ");
INSERT INTO ksp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mare kara horode te tuka mbi nje-kula le tɔku nje-polo ke kɔl ti. ");
INSERT INTO ksp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","A Jeju pa na: « Ase baann! Jeju ɔru mbi dingaw le ngaa mbia le tel ddee maji.» ");
INSERT INTO ksp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Goe te a Jeju pa are tɔku nje-poloje Lubba ke nje-kɔn dɔ dewje ke aw ngemje key-polo-Lubba ke tɔku dewje ke ddeeje ta kuwaeje na: « E-ddeeje ke tɔku kiya ke kakeje toke le e-ddeeje ta kuwa nje-bboko. ");
INSERT INTO ksp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mee ke se key-polo-Lubba te ke ndɔ tɔyn a uwamje ang. A kare neenn to lese, ke to singa le lo-ndul.» ");
INSERT INTO ksp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Goe te ke dewje uwaje Jeju a, dawje saa ngaa dandeje saa key le mare tɔku nje-polo Lubba. Piyar aw unn goe ngaa nayn ddew ew. ");
INSERT INTO ksp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","N̂-yelje puru dann lo te me ndoko te le ngaa disije tae te. Piyar isi horode te tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mare nje-kula ke dene ooe ta puru te le. Naa Piyar le ngaa n̂-pa na: « Dingaw neenn nja ke Jeju tɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","A Piyar mayn na: « Dene, m-gere ang.» ");
INSERT INTO ksp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ngaji goe te a, mare dew ooe ngaa pa na: « Ei, ee horo nje-njaje go Jeju te tɔ.» Piyar pa are dew le na: « Mee horode te ang!» ");
INSERT INTO ksp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ase gɔl kare kara a, mare dingaw pa are ngeng bbay na: « Tɔkɔrɔ, dingaw neenn nja saa, mba dingaw neenn to dew ke Galile.» ");
INSERT INTO ksp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Piyar ilae te na: « Ei, m-gere tar ke a ta pa ang.» Toke Piyar aw pa tar bbay a, kare teenn njaa kuran nɔ. ");
INSERT INTO ksp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","*Ebbe-dewje turu rɔe ngaa aa Piyar. Piyar ole mee dɔ tar te ke *Ebbe-dewje pa are na: Kete bba kare kuran nɔ bbokone, a mayn tar lem gɔl muta. ");
INSERT INTO ksp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Piyar tee ddaka ngaa nɔ nya. ");
INSERT INTO ksp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Dewje ke aw ngemje Jeju le aw kokeje ngaa aw tundaeje. ");
INSERT INTO ksp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","N̂-tɔje keme ke kubbu ngaa n̂-dujeje na: « Na a undai wa? E-bbar ri dew ke undai le.» ");
INSERT INTO ksp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","N̂-tajeje nya ddew tarje te dang dang. ");
INSERT INTO ksp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Toke lo are a, kuwa-dɔ-naa le tɔku dewje le *Jiipije, ke tɔku nje-poloje Lubba, ke *nje-kɔruje gel-ndu mbɔnje naa ngaa are n̂-ddee ke Jeju lo-gange-sariya te. ");
INSERT INTO ksp_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","N̂-paje na: « Bbo e-to Kiriste a e-pa areje.» Jeju ilade te na: « Bbo m-pa marese a, a kooje ne mese te ang, ");
INSERT INTO ksp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ngaa bbo m-dujuse tar a, a kilamje te ang. ");
INSERT INTO ksp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","A kunn kote bbasine, Ngonn le dew a kisi dɔ-ji-kɔl Lubba ke nje-singa-mɔngu te.» ");
INSERT INTO ksp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Dede tɔyn n̂-paje na: « Yeenn a, e-to Ngonn le Lubba wa?» Nila te na: « Esese njaa e-paje na: M-to Ngonn le Lubba.» ");
INSERT INTO ksp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","N̂-paje na: « Ddi a ta koo tar le nje-najije dda ne bbay wa? Jeje njaa joo tar ke tae te mban.» ");
INSERT INTO ksp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Dewje ke uwaje Jeju inje taar tɔyn ngaa awje saa nɔ Pilate te. ");
INSERT INTO ksp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Dulaje tar tae te na: « Jinga dingaw neenn, naw nɔsu kutu dewje ta kare n̂-ddaje dɔ-ngeng. N̂-pa nare dewje ta kare uka *lambo ke Sejar ang ngaa n̂-pa na ne njaa n̂-to Kiriste, n̂-to Mbay.» ");
INSERT INTO ksp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilate duju tar Jeju toke be: « E-to tɔku-mbay le *Jiipije wa?» Jeju ilae te na: « Ei njaa e-pa.» ");
INSERT INTO ksp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilate pa are tɔku nje-poloje Lubba ke dewje ke banya na: « Minga mare ne ke ase kare munda ne tar dɔ dingaw te neenn kara ang.» ");
INSERT INTO ksp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","A n̂-telje n̂-paje dare ngeng nya na: « Naw n̂-tɔju dɔ-ngeng dewje ddew ne-tɔju te dɔ nange te ke Galile tɔyn. Nunn kute bbe te ke Jude ndereng lo te neenn.» ");
INSERT INTO ksp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kake Pilate oo tarjeenn le a, n̂-duju ta gere se dingaw neenn to dew ke bbe te ke Galile wa? ");
INSERT INTO ksp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","N̂-pa dare Pilate na Jeju in nange te ke tɔku-mbay *Erode a ɔn dɔe a, nulae rɔ *Erode te ke ee Jurusalam me ndɔje teenn tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Toke *Erode oo Jeju a, rɔe nele nya. Lew baa njaa naw n̂-sange ddew ta kooe, mba noo tarje nya ke dewje aw paje dɔe te ngaa n̂-ndiki ta kare Jeju dda mare ne-mɔrije are noo. ");
INSERT INTO ksp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","N̂-duju tar Jeju nya. A Jeju ilae te ang. ");
INSERT INTO ksp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tɔku nje-poloje Lubba ke *nje-kɔruje gel-ndu eeje teenn ngaa aw gangeje tar ula ta Jeju te ke singa singa. ");
INSERT INTO ksp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","*Erode ke mbambaje laa ooeje maji ang. N̂-kokeje ngaa dulaeje kubbu ke ndɔne. Goe te a, dulaeje rɔ Pilate te guku. ");
INSERT INTO ksp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ndɔe teenn njaa Pilate de ke *Erode ke n̂-toje to nje-baanji le naa, n̂-telje to nje-buwa-kuraje. ");
INSERT INTO ksp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilate bbar tɔku nje-poloje Lubba ke nje-kɔnje dɔ dewje, ke dewje, ");
INSERT INTO ksp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ngaa n̂-pa narede na: « E-ddeeje ke dingaw neenn rɔm te ngaa e-paje na: Naw n̂-tɔju dɔ ngeng dewje. Ooje: M-duje tar kemse te. A minga mare *majang ke n̂-dda bba undaje ne tar dɔe te le kara ang. ");
INSERT INTO ksp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","*Erode kara inga *majang ke n̂-dda kara ang tɔ. Mba yeenn a, nulae ne nareje guku. Ooje, dingaw neenn dda mare ne kara ke ase yo ang. ");
INSERT INTO ksp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ma kare dundae ke ndey a, ma kinyae.» ");
INSERT INTO ksp_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ndɔ *kusuje tɔyn, to tar le Pilate ta kɔru dew kara key-kula te. ");
INSERT INTO ksp_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Dewje le tɔyn paje ke taar na: « E-tɔl dingaw neenn a ɔru Barabase areje!» ");
INSERT INTO ksp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabase le duwae dilae key-kula te, mba nee horo mare dewje te ke ddaje dɔ-ngeng me bbe te ke Jurusalam ddem Barabase tɔl dew ddem. ");
INSERT INTO ksp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilate pa tar arede bbay, mba n̂-ndiki ta kinya Jeju. ");
INSERT INTO ksp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","A duruje eki na: « E-tɔle dɔ kake-dese te! E-tɔle dɔ kake-dese te!» ");
INSERT INTO ksp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilate pa arede gɔl muta laa na: « Majang ddi a n̂-dda wa? Minga mare ne ke n̂-dda ke ase yo ang. Ma kare dundae a dinyae.» ");
INSERT INTO ksp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","A dewje le uruje eki dujuje nya na n̂-tɔl Jeju dɔ kake-dese te. Eki lede uta dɔ Pilate. ");
INSERT INTO ksp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Yeenn bba Pilate unn ndu ta dda ne ke daw n̂-dujuje le. ");
INSERT INTO ksp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nɔru Barabase ke dewje le dujeje ta kare nɔre le. Barabase ke dilae key-kula te wɔju dɔ dɔ-ngeng, ke wɔju dɔ dew ke n̂-tɔle le ngaa nula Jeju jide te ta kare n̂-ddaje saa ne tɔyn ke mede ndiki. ");
INSERT INTO ksp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Toke mbambaje aw awje ke Jeju a, dingaje Simɔ ke to dew ke bbe te ke Sirene ke in ndɔɔ̂ aw tel ke bbê. Duwaeje dundaje kake-dese dɔe te ta kare noto n̂-nja ne go Jeju te. ");
INSERT INTO ksp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Dewje banya banya ke deneje aw awje go Jeju te. Deneje le aw undaje karede ngaa aw nɔje mba tar laa. ");
INSERT INTO ksp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jeju turu rɔe ke rɔde te ngaa pa na: « Deneje ke Jurusalam, e-nɔje mba tar lese ke tar le ngannse bbo e-nɔje mba tar lem ang. ");
INSERT INTO ksp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ooje, mare ndɔ aw ddee ke dewje a paje na: Koko ee ke deneje ke awje kate, ke dede ke dujuje ang bbay, ke dede ke dareje mba ngonn il ang! ");
INSERT INTO ksp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Me ndɔje teenn le dewje a paje kare ddingirije na: Osoje dɔje te! Da pa kare dɔ-kubbaje na: E-debbeje dɔje te! ");
INSERT INTO ksp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mbata bbo n̂-dda ne ke kake ke tebbe toke be a, ddi a da dda ke kake ke tutu wa?» ");
INSERT INTO ksp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kare teenn, daw daw ke dingawje joo ke to nje-ne-ddaje ke maji ang, ta tɔlde kara baa ke Jeju. ");
INSERT INTO ksp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","N̂-teeje lo te ke daw n̂-bbar na Ka-dɔ-dew a, n̂-bbereje Jeju dɔ kake-dese te ngaa n̂-bbereje nje-ne-ddaje ke maji ang ke joo le dɔ kake-deseje te. Kara dɔ ji-kɔl Jeju te a ye ke kara dɔ ji-gele te. ");
INSERT INTO ksp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jeju pa na: « Bɔy ɔru tar dɔde te, mba n̂-gereje ne ke daw n̂-ddaje ang.» N̂-ddɔje mbari bba n̂-kaynje ne naa kubbu le Jeju. ");
INSERT INTO ksp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Dewje areje keteenn aw ooje nejeenn. Nje-kɔnje dɔ dewje aw kokoje Jeju na: « Naji mare dewje. A bbo n̂-to Kiriste ke Lubba mbere a, maji kare naji da-rɔe njaa.» ");
INSERT INTO ksp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mbambaje kara kokeje. Daw ngɔsi saa ngaa dareje maann binye ke mase ke ria na benegere. ");
INSERT INTO ksp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","N̂-paje na: « Bbo e-to tɔku-mbay le *Jiipije a, ei njaa aji rɔi!» ");
INSERT INTO ksp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Dunda maketuru dɔ kake-dese te le taar na: Ne neenn n̂-to tɔku-mbay le *Jiipije. ");
INSERT INTO ksp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mare nje-ne-dda ke maji ang kara ke n̂-bbere dɔ kake-dese te taje na: « E-to Kiriste ang wa? Ei njaa aji rɔi bbo ajije!» ");
INSERT INTO ksp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","A nje-ne-dda ke maji ang ke kara ndange nje-mare le na: « E-bbel Lubba ang wa? Ei kara n̂-gange sariya dɔi te toke laa tɔ. ");
INSERT INTO ksp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Sariya leje to ke dɔgɔle, mba jinga kuka neje ke maji ang ke n̂-dda. A ne n̂-dda ne ke maji ang kara ang.» ");
INSERT INTO ksp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","N̂-pa nare Jeju na: « Ole mei dɔm te ndɔ te ke a tel ddee kɔn bbe.» ");
INSERT INTO ksp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jeju pa are na: « Tɔkɔrɔ, m-pa mari bbokone a kisi sem lo te ke maji.» ");
INSERT INTO ksp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Gɔl kare aw ngɔsi ke dɔku gire joo a, lo ndul dɔ nange te tɔyn ndereng gɔl kare muta ke lo-kul te. ");
INSERT INTO ksp_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kare ndoko ang ngaa kubbu ke n̂-tɔ n̂-gange ne me key-polo-Lubba tir danna. ");
INSERT INTO ksp_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jeju uru eki ke taar pa na: « Bɔy, minya ndilim me jii te.» Goe te ke n̂-pa tar neenn a nuwa rɔe. ");
INSERT INTO ksp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nje-kɔn dɔ mbambaje oo nejeenn le a, nɔsu gaji Lubba ngaa n̂-pa na: « Tɔkɔrɔ njaa dew neenn to gate gate.» ");
INSERT INTO ksp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Dewje ke banya banya ke areje lo neje teenn le ooje neje ke teeje le ngaa dundaje karede n̂-telje ne ke bbê. ");
INSERT INTO ksp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Dewje tɔyn ke gereje Jeju, ke deneje ke inje saa Galile te awje saa, dareje ddew ew bba daw dooje neje ke aw toje le. ");
INSERT INTO ksp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Mare dingaw ke ria na Jejebbe, n̂-to dew ke maji ke dew ke gate gate. N̂-to dew ke bbe te le *Jiipije ke ria na Arimate. Naw n̂-ngebbe *Kɔn̂-bbe le Lubba. N̂-to kara le nje-gangeje sariya. A ne n̂-mbete sariya ke nje-gangeje sariya mareje gangeje dɔ Jeju te, ke neje ke n̂-ddaje ke Jeju. ");
INSERT INTO ksp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jejebbe le aw rɔ Pilate te ngaa duju ta kunn ninn Jeju. ");
INSERT INTO ksp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nɔru ninn Jeju dɔ kake-dese te nila nangê, n̂-ke ninn le ke kubbu ngaa naw nila me buwa te ke duru me er te. Buwa le dila ninn dew me te ndɔ kara ang bbay. ");
INSERT INTO ksp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ndɔe le to ndɔ mɔse ne ngaa *ndɔ-kuwa-rɔ le *Jiipije a ta kunn kute. ");
INSERT INTO ksp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Deneje ke inje ke Jeju Galile te ddeeje saa le, awje ke Jejebbe aw ooje buwa le ke gusu ke Jejebbe ila ne ninn Jeju me buwa te le. ");
INSERT INTO ksp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","N̂-telje mba kaw mɔse wubbu ke ete maji. Goe te a, duwaje rɔde, mba to *ndɔ-kuwa-rɔ, ddew kara baa toke *ndu pa. ");
INSERT INTO ksp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ndɔ kara go *ndɔ-kuwa-rɔ te a, deneje le teeje ke ta-lo-kare baa, awje ke wubbu ke ete maji ke dede njaa n̂-ddaje ke ta buwa yo te. ");
INSERT INTO ksp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Dooje er ke dutu ne ta buwa-yo le toke ndubbu, ");
INSERT INTO ksp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","dandeje a dooje ninn *Ebbe-dewje Jeju le ang. ");
INSERT INTO ksp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Dejeje tar wɔju dɔ ne ke dooje le pin. A ta koo a, dingawje joo ke ulaje kubbu ke ndɔren teeje ingajede. ");
INSERT INTO ksp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bbel dda deneje le ngaa dulaje dɔde ke nangê. Dingawje ke joo le paje arede na: « Mbata ddi bba aw e-sangeje dew ke isi ke tebbe horo nje-yoje te wa? ");
INSERT INTO ksp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nee neenn ang, n̂-ndol mban. Oleje mese dɔ tar te ke n̂-pa narese kare te ke n̂-nayn ne Galile bbay na: ");
INSERT INTO ksp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Maji kare dula Ngonn le dew ji nje-ne-ddaje te ke maji ang, da tɔle dɔ kake-dese te ngaa ndɔ muta a na kin.» ");
INSERT INTO ksp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ngaa doleje mede dɔ tarje te le Jeju le. ");
INSERT INTO ksp_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Dinje ta buwa yo te n̂-telje mba kɔru gel nejeenn tɔyn kare *nje-kayn̂-kulaje le Jeju ke dɔku gire kara ke kese dewje tɔyn. ");
INSERT INTO ksp_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mari-Madelena, ke Jani, ke Mari kɔn Jakeje, ke mare deneje a paje tar le are *nje-kayn̂-kulaje le. ");
INSERT INTO ksp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","A dooje to tar mbe ngaa dooje mede te ke tar le deneje le ang. ");
INSERT INTO ksp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","A Piyar in ayn ngɔru aw ta buwa yo te le. Nula gɔse a ta kubbuje ke to nangê a noo ngaa naw n̂-tel ke key a tar ike sel wɔju dɔ ne ke tee le. ");
INSERT INTO ksp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Me ndɔe teenn njaa dewje joo horode te awje ke mare bbe te ke ria na Emayusu ke ew ase kula metere dɔku gire kara, ");
INSERT INTO ksp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","daw n̂-tɔnje tam dɔ neje te tɔyn ke nday le. ");
INSERT INTO ksp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kare te ke daw n̂-tɔnje tam, ke daw n̂-maynje naa tar a, Jeju ddee ngɔsi ke de ngaa aw nja ke de. ");
INSERT INTO ksp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Daw dooeje a mare ne ɔkude ddew kare n̂-gereje. ");
INSERT INTO ksp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","N̂-pa narede na: « Tar ddi bba aw paje horo naa te aw e-njaje ne neenn wa?» Darje lo kara ngaa rɔde nelde ang. ");
INSERT INTO ksp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mare kara horode te ke ria na Keleyopase ilae te na: « Neje ke ndayje me ndɔje te neenn, ei ke kari baa njaa e-to dew ke Jurusalam ke e-gere tare ang wa?» ");
INSERT INTO ksp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jeju pa arede na: « Ddi wa?» Dilaeje te na: « Ne ke ddee dɔ Jeju te ke Najarete. N̂-to nje-kila mber-tar le Lubba ke ngeng nya ddew kula te ke ddew tar te nɔ gɔl Lubba te ke nɔ gɔl dewje te tɔyn. ");
INSERT INTO ksp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tɔku nje-poloje Lubba leje ke tɔku-mbayje leje ilaeje me ji dewje te are n̂-gange sariya yo dɔe te ngaa n̂-tɔle dɔ kake-dese te. ");
INSERT INTO ksp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Junda meje to ne a na kɔru Ijarayel kɔ bbere te, a dɔ neje teenn tɔyn, dda ndɔ muta bbokone ngaa ke nejeenn teeje. ");
INSERT INTO ksp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Tɔkɔrɔ njaa, mare deneje horoje te ddaje ne ke uta dɔje. Dawje ke ta-lo-kare baa dɔ-bare te ngaa, ");
INSERT INTO ksp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","dingaje ninn Jeju le ang a, n̂-telje n̂-paje na anjije teeje ingaje neje ngaa paje na nisi ke tebbe. ");
INSERT INTO ksp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mare dewje ke eeje ke je awje ta buwa yo te le. Dooje neje le ddew kara baa toke deneje le paje, a dooeje ang.» ");
INSERT INTO ksp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jeju pa na: « Nje-ne-gere-angje! Esese ke ooje mese te ke ngɔru ke neje tɔyn ke nje-kilaje mber-tar le Lubba paje arese ang! ");
INSERT INTO ksp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Maji kare Kiriste oo ndoo toke baann kete bba ta nande me ndoko te laa!» ");
INSERT INTO ksp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jeju ɔru gel ne ke maketuruje le Lubba tɔyn paje dɔe te. Nunn kute maketuru te le Moyije ndereng maketuru te le nje-kilaje mber-tar le Lubba. ");
INSERT INTO ksp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kake n̂-teeje ngɔsi ke bbe ke daw dawje ke ke te a, Jeju dda toke na ta kɔtu kinyade a, ");
INSERT INTO ksp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","n̂-paje nya na: « E-nayn ke je, mba lo aw wul ngaa kare a ta kande.» Nande me bbe te le mba nayn ke de. ");
INSERT INTO ksp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nisi ta ne-kusa te ke de a, nunn mapa, n̂-bbar Tar ke Maji dɔe te. Goe te a n̂-tete danna ngaa narede. ");
INSERT INTO ksp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Yeenn ngaa kemde uja dɔe te are n̂-gereje. A ne kara, n̂-kiri piti a niki ndong. ");
INSERT INTO ksp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","N̂-paje tar horo naa te na: « Kare te ke naw n̂-pa tar nareje ddew-bô ngaa naw nɔru gel maketuruje nareje le meje unda dɔ benya ang wa?» ");
INSERT INTO ksp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Me kare teenn njaa, dinje n̂-telje Jurusalam ngaa dingaje *nje-kayn̂-kulaje ke dɔku gire kara ke nje-buwa-njaje lede ");
INSERT INTO ksp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ke aw paje arede na: « Tɔkɔrɔ *Ebbe-dewje ndol, mba Simɔ ooe ke keme.» ");
INSERT INTO ksp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Dɔruje gel ne ke ingade ddew-bô, ke ddew ke to ke n̂-gereje ne kare te ke naw n̂-kayn ne de mapa. ");
INSERT INTO ksp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kake daw n̂-paje tar toke baann bbay a, ne njaa n̂-tee nare dannde te ngaa n̂-pa narede na: « Me-wul-lɔm ee ke se.» ");
INSERT INTO ksp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mede unda dɔ benya ddem, bbel ddade ddem, are dejeje to nooje uma. ");
INSERT INTO ksp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","A n̂-pa narede na: « Mbata ddi bba eeje ke keje mayn̂-tar mese te wa? ");
INSERT INTO ksp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Aaje jimje ke gɔlumje ooje, ema njaa mar neenn, ɔrumje ooje, uma ee ke tal-rɔ ke singa-rɔ ang. A ema mee ne.» ");
INSERT INTO ksp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kake naw n̂-pa tar baann a, n̂-tɔjude jiaje ke gɔleje le. ");
INSERT INTO ksp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Dooje to ne ke tɔkɔrɔ ang bbay, mba rɔde nelde nya. Jeju pa arede na: « Eeje ke mare ne-kusa neenn ang wa?» ");
INSERT INTO ksp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Dareje debbe kanji ke kɔbbu kara. ");
INSERT INTO ksp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","N̂-taa ngaa nusa kemde te. ");
INSERT INTO ksp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Goe te a n̂-pa narede na: « Ne ke m-pa marese kare te ke m-nayn ke se le a neenn. Maji kare ne ke n̂-dda wɔju dɔm me maketuru *ndu te le Moyije, ke me maketuru te le nje-kilaje mber-tar le Lubba ke me Maketuru*Sɔme te ddee ne ke tɔkɔrɔ.» ");
INSERT INTO ksp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Yeenn a nɔru ddew narede kare n̂-gereje ne gel Maketurule Lubba. ");
INSERT INTO ksp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","N̂-pa narede na: « N̂-dda me Maketurute le Lubba na: Kiriste a koo ndoo ngaa, ndɔ muta a na kin horo nje-yoje te. ");
INSERT INTO ksp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Da kila mber-tar ke ri Kiriste kare dewje tɔyn turuje ne ddew lede, mba kare tar *majang lede ɔru dɔde te. Mber-tar le a kunn kute Jurusalam. ");
INSERT INTO ksp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","E-toje to nje-tar-naji neje neenn le. ");
INSERT INTO ksp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ngaa ooje, ma kare ne ke Bɔy unn ndue ta karese ddee dɔse te. A e-naynje me bbe te ke Jurusalam ndereng ndɔ ke a kingaje singa-mɔngu ke in darâ.» ");
INSERT INTO ksp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nɔrude naw ke de er ke Betani. Goe te a, nula jia ke taar ngaa n̂-bbar Tar ke Maji dɔde te. ");
INSERT INTO ksp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kare te ke naw n̂-bbar Tar ke Maji dɔde te a, ninyade ngaa Lubba unne ke darâ. ");
INSERT INTO ksp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Goe te ke dɔsuje gɔlde nɔe te a, n̂-telje Jurusalam ke koko. ");
INSERT INTO ksp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","N̂-naynje me key-polo-Lubba te ngaa n̂-pitije Lubba.");
INSERT INTO ksp_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ngokɔm Topile, me dɔngɔr maketuru te lem, m-pa tar dɔ neje te tɔyn ke Jeju unn kutu dda, ke neje ke n̂-tɔju kunn kutu kula te ke n̂-dda, ");
INSERT INTO ksp_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ndereng ndɔ te ke Lubba unne tel saa darâ. Kete bba kare Lubba tel saa darâ a, nunn ndu ddew te le Ndil-me-nda nare nje-kayn-kulaje ke n̂-mberede. ");
INSERT INTO ksp_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Go yo te laa a, n̂-tɔju rɔe narede ngaa n̂-dda neje dang dang ta tɔjude to nisi kem baa. N̂-dda toke baann ndɔ dɔsɔ ngaa n̂-pa tar dɔ kɔn̂-bbe te le Lubba narede. ");
INSERT INTO ksp_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Mare ndɔ nisi ta ne-kusa te ke de a, nunn ndu narede na: «Ɔtuje me bbe te ke Jurusalam ang ta n̂-ngebbeje ne ke Bɔ unn ndu ta karese, ne ke m-pa tare marese kete mban le. ");
INSERT INTO ksp_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jan dda dewje batem maann, a sese, a kingaje batem Ndil-me-nda me ndɔje te neenn. ");
INSERT INTO ksp_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nje-kayn̂-kulaje le mbɔnje naa rɔ Jeju te ngaa dujeje na: «Bbasine neenn njaa a tel ke kɔn̂-bbe kare ngann Ijarayelje wa?» ");
INSERT INTO ksp_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jeju pa arede na: «To tar lese ta gere ndɔe wase kare ang. Mba Bɔy wɔju ndɔe le, ke kare le ddew singa te laa njaa. ");
INSERT INTO ksp_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","A a kingaje singa-mɔngu ddew te le Ndil-me-nda ke a ddee dɔse te. Ngaa a telje to nje-tar-naji lem me bbe te ke Jurusalam, dɔ nange Jude te tɔyn, dɔ nange Samari te, ndereng kɔyn nange te tɔyn. ");
INSERT INTO ksp_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Goe te ke Jeju pa tar le a, nin kemde te ke darâ ngaa mum dibbi dɔe are dooe ang. ");
INSERT INTO ksp_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kare te ke daw daaje lo ke darâ ke go Jeju te le bbay a, a ta koo a, dingawje joo ke ulaje kubbu ke nda arje mbɔr nje-kayn-kulaje te le. ");
INSERT INTO ksp_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Dingawje le paje arejede na: «Dewje ke Galale, mba ddi bba arje neenn aw aaje lo ke darâ wa? Jeju neenn ke Lubba unne horose te aw saa ke darâ a tel ddee ddew kara baa toke kaw laa ke ooeje neenn.» ");
INSERT INTO ksp_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nje-kayn̂-kulaje le inje dɔ ddingiri te ke ddaw n̂-bbar na ddingiri olibeje le telje Jurusalam. Ddingiri le to ngɔsi baa ke bbe le ase kilo metere kara. ");
INSERT INTO ksp_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Toke n̂-teeje Jurusalam a, daalje dawje me key te ke to dɔ mare te taar ke to lo mbɔ-naa lede. Dewje ke eeje teenn to Piyar, Jan, Jake de ke Andere, Pilipi de ke Toma, Bartelemi de ke Matiye, Jake ngonn le Alpe, Simɔ ke daw n̂-bbare to Jelote, ke Jude ngonn le Jake. ");
INSERT INTO ksp_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Dede tɔyn njaa, daw dooje ta naa daw duju Lubba ke ndɔ tɔyn. Mare deneje, Mari kɔn Jejuje, ke ngakɔn Jeju eeje horode te tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Dɔ ndɔeje teenn, Piyar in taar horo nje-me-kunnje ke kɔrde ase kɔr kara ke dɔjoo ngaa pa na: ");
INSERT INTO ksp_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Ngakɔmje, ne ke Ndil-me-nda unda ta Dabbiti te are pa maketuru te le Lubba ddee to ne ke tɔkɔrɔ. Tar le na Judase a tel to nje-kunn nɔ dewje ke uwaje Jeju. ");
INSERT INTO ksp_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kete, nee horoje jee nje-kayn-kulaje te njaa ngaa dinya debbe kula ke jaw n̂-ddaje neenn jia te tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","N̂-ndoko ndɔɔ ke nare ke dukae ne mba ne ke maji ang ke n̂-dda ngaa n̂-tee noso me ndɔɔ te le ke gɔse, mee ribba ngaa kula-sien tee tɔyn ungu ddaka. ");
INSERT INTO ksp_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Dewje tɔyn ke ddaje bbe Jurusalam ooje tare ngaa undaje ri ndɔɔ le ke ndɔn tar lede na, Hakeldama, gel ri le na: ndɔɔ mese. ");
INSERT INTO ksp_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","N̂-dda tare maketuru Sɔme te na: ‹Maji kare key laa tel dɔ-ndubba ngaa, dew to te ang.› Tɔ bbay n̂-dda maketuru te le lubba na: ‹Maji kare mare dew taa ture kula te laa. ");
INSERT INTO ksp_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«Yeenn a, mare dewje ke njaje ke je dɔ ndɔje te ke Ebbejeje aw ɔru ne nɔje eeje neenn. ");
INSERT INTO ksp_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Unn kute dɔ ndɔ te ke Jan ddae ne batem ndereng ndɔ te ke Lubba unne ne horoje te tel saa ne darâ. Maji kare mare dew kara horo dewje neenn le tel to nje-tar naji ke je wɔju dɔ tar kin le Jeju Kiriste horo nje-yoje te.» ");
INSERT INTO ksp_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Yeenn ngaa n̂-tɔjuje dewje joo: Jejebbe ke mare ria to Barsabase ke daw n̂-bbare bbay na Justus, de ke Matiyase. ");
INSERT INTO ksp_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Goe te a n̂-dujuje Lubba na: «Ei Ebbejeje ke e-gere ne ke to me dewje te tɔyn, horo dewje te ke joo neenn ɔru dew ke mei ndiki, ");
INSERT INTO ksp_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","mba kare n̂-dda kula le nje-kayn-kulaje turu Juda te ke tusu kula le inya a aw lo te laa ke ase.» ");
INSERT INTO ksp_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","N̂-dda elemteen, a elemteen le oso dɔ Matiyase te ngaa kare teenn njaa dilae horo nje-kayn-kulaje ke eeje dɔku gire kara. ");
INSERT INTO ksp_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Toke ndɔ Pentekote ase a, nje-me-kunn isije dɔ naa te kara baa. ");
INSERT INTO ksp_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","A ta koo a, mare kɔru ne bbar darâ toke mare le tɔku yel ke aw ula ngaa taa me key ke disije te le tɔyn. ");
INSERT INTO ksp_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ngaa, dooje ne toke mare le ndɔn̂-puru. Ndɔn puru le saren naa ngaa isi dɔde te kara kara tɔyn. ");
INSERT INTO ksp_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ndil-me-nda ddusu mede tɔyn ngaa dunnje kutu pa tar ke ndɔn̂-tarje dang dang ke Ndil le unda tade te. ");
INSERT INTO ksp_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Mare Jiipije ke bbeelje Lubba eeje me bbe te ke Jurusalam tɔ. Dinje nangeje te dang dang tɔyn. ");
INSERT INTO ksp_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Toke dewje le ooje kɔru ne ke bbar tee mbide te le a, n̂-mbɔnje naa toke banya banya. Tar ikide sel, mba dede kara kara tɔyn daw dooje tar bbeje lede ta nje-me-kunnje te le. ");
INSERT INTO ksp_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ne le gange singade ddem, arede rɔ-neel ddem ngaa n̂-paje na: «Dewje tɔyn ke aw paje tar neenn toje to dewje ke Galile ang wa? ");
INSERT INTO ksp_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","A dda toke baann bba na na kara aw oo tar-bbe laa tade te wa? ");
INSERT INTO ksp_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Jeje ke jin nange te ke Parte, Mede, ke Elamite, dewje ke Mejopotami, dewje ke Jude, ke Kapadose, Pɔn, ke Aji, ");
INSERT INTO ksp_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","dewje ke Piriji, ke Pampili, Ejipite ke Libi ke to ngɔsi ke Siren, dewje ke Rɔm ke ddaje bbe Jurusalam, ");
INSERT INTO ksp_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","dede tɔyn, Jiipije wase dewje ke aw bbeelje Lubba le Moyije, dewje ke bbe te ke Kerete, ke dewje ke bbe te ke arabi, jaw joo tar neje ke maji ke Lubba dda ke daw n̂-paje tare ke tar bbeje leje. ");
INSERT INTO ksp_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Dewjeenn tɔyn njaa tar ikide sel, n̂-gereje ne ke da ddaje ang ngaa n̂-paje tar horo naa te na: «Ne ddi a toke be wa?» ");
INSERT INTO ksp_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","A mareje aw kokoje nje-me-kunnje le na: «Dayje koto ke to ben dare ddade.» ");
INSERT INTO ksp_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Yeenn ngaa Piyar in ar taar, ke nje-kayn-kulaje ke dɔku gire kara ngaa pa ke taar na: «See dewje ke nange te ke Jude, ke sese tɔyn ke isije bbe te ke Jurusalam, maji kare ooje neje neenn ke maje ta e-tukaje mbise ooje ne tar lem. ");
INSERT INTO ksp_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Baann ang, koto a dda dewje neenn toke aw ejejeenn ang. Lo to ke endɔɔ baa bbay mba gɔl kare to kare jikara baa bbay. ");
INSERT INTO ksp_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","A ne ke aw ooje neenn to tar ke Jowel nje-kila mber-tar le Lubba pa a ddee to ne ke tɔkɔrɔ. N̂-pa na: ");
INSERT INTO ksp_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‹Lubba pa na: ddutu ndɔ a, ma kare Ndil lem isi me dewje te tɔyn, ngannse ke dingaw, ke ngannse ke dene a telje to nje-kilaje mber-tar lem, ngann basanje lese a kooje ne toke mare le nijeenn, bbukaje lese a nije. ");
INSERT INTO ksp_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tɔkɔrɔ, dɔ ndɔeje teenn le, ma kare Ndil lem nje-kulaje lem ke dingaw, ke nje ke ndene ngaa da kilaje mber-tar lem. ");
INSERT INTO ksp_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ma dda ne ke dum dɔ koo me dara te ke ne-mɔrije nangê dɔ nange te: Mese, puru, ke tɔku sa-puru. ");
INSERT INTO ksp_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kare a tuka ndul, neyn a kase toke mese, kete bba kare ndɔ le Ebbe-dewje ke to tɔku ndɔ ke ndɔ ke maji a ddee. ");
INSERT INTO ksp_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Yeenn a, dew ke bbar ne ke ri Ebbe-dewje a, a kinga kaji.› ");
INSERT INTO ksp_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Ngann Ijarayelje, ooje tar ke ma ta pa karese neenn. Jeju ke Najarete le, to dew ke Lubba tɔjuse to ne a nulae narese. Yeenn bba Lubba are n̂-dda ne-mɔrije, neje ke dum dɔ koo, ke ne-tɔju-neje dang dang horose te. E-gereje nejeenn ke maje. ");
INSERT INTO ksp_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jeju le dunne dulae jise te ddew kara baa ke ndu ke Lubba njaa unn toke kete ddem ddew kara baa ke ne ke Lubba mɔse lew baa ddem. Uwaeje ilaeje ji dewje te ke maji ang areje n̂-tɔleje kake-dese te. ");
INSERT INTO ksp_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","A Lubba ndole ɔre me ji yo te, mba yo ee ke singa ngaji ta ngeme jia te ang. ");
INSERT INTO ksp_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dabbiti pa tar dɔ Jeju te le na: ‹Maw moo Ebbe-dewje nɔm te ke kar tɔyn, mba nee dɔ-ji kɔlum te kare ta ne yekem ang. ");
INSERT INTO ksp_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Mba yeenn a, rɔm neelem nya ngaa maw mɔsu pa rɔ-neel. Ne ke maji uta, to da-rɔm kara a kisi ke me-ngebbe ");
INSERT INTO ksp_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","mba a kinyam lo te le nje-yoje ang ngaa a kinya ema Nje-me-nda lei kare m-ndum me buwa-yo te ang. ");
INSERT INTO ksp_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","E-tɔjum ddew kinga tebbe, Ar nɔm te a, ma kinga koko.› ");
INSERT INTO ksp_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Ngakɔmje, ddew ɔru arem kare m-pa tar neenn ke maje marese: kajeje Dabbiti oy, n̂-dubbe, are dɔbare to horoje te baa bbay. ");
INSERT INTO ksp_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","N̂-to nje-kila mber-tar le Lubba ngaa n̂-gere to Lubba unda yo bba unn ne ndu kare dew ke gele te isi ngende-mbay te. ");
INSERT INTO ksp_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dabbiti le gere kete to Kiriste a kin buwa-yo te. Yeenn bba n̂-pa tar ke dɔ Kiriste te le na: Lubba a kinyae lo te le nje-yoje ang, ngaa da-rɔe a ndum buwa-yo te ang. ");
INSERT INTO ksp_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jeju neenn le, Lubba are nin buwa-yo te are jeje tɔyn n̂-toje to nje-najije. ");
INSERT INTO ksp_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Lubba unne undae dɔ ji-kɔle te darâ. Ninga Ndil-me-nda ke Bɔ unn ndu ta kare le ngaa n̂-saren Ndil le dɔje te to ke aw ooje ke kemse ddem ke mbise ddem neenn. ");
INSERT INTO ksp_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dabbiti aw darâ ang njaa, a pa na: ‹Ebbe-dewje pa are Ebbemje na: Isi dɔ ji-kɔlem te ");
INSERT INTO ksp_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ndereng ndɔ te ke ma dda kare nje-baanji lei telje to lo kungu gɔli.› ");
INSERT INTO ksp_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Maji kare dewje tɔyn ke Ijarayel gereje ke maje: Jeju ke e-tɔleje kake-dese te le, Lubba are n̂-to Kiriste ddem Ebbe-dewje ddem.» ");
INSERT INTO ksp_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Toke dewje le ooje tar le a tar le gange singade ngaa n̂-dujuje Piyar ke kese nje-kayn-kulaje le na: «Ngakɔnjeje, ddi a maji kare n̂-ddaje wa?» ");
INSERT INTO ksp_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piyar pa arede na: «E-turuje mese ngaa ta na na kara inga batem ke ri Jeju Kiriste. Baann bba Lubba a kɔru tar majangje lese dɔse te ngaa na karese Ndil-me-nda. ");
INSERT INTO ksp_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Mba ndu neenn le to wɔju dɔse, ke ngannse, dewje ke isije ddew ew, ke dewje ke banya banya ke Ebbe-dewje Lubba leje a bbarde.» ");
INSERT INTO ksp_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piyar pa tarje dang dang mba pa ne tar-naji ddem mba kɔsu ne kutude ddem. Ngaa n̂-pa na: «E-teeje horo nje-me-maji angje te ke bbasine ke ddang areje Lubba ajise.» ");
INSERT INTO ksp_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Dewje ke ndikije go tar te laa le ingaje batem. Ndɔe teenn kɔr dewje ase ne ke doro muta ddeeje unguje dɔ kɔr nje-me-kunnje te ke kete. ");
INSERT INTO ksp_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nje-me-kunnje le unnje rɔde tɔyn mba kaw koo ne-tɔju le nje-kayn-kulaje ke ndɔ tɔyn, daw dulaje nuju naa te, daw n̂-ddaje me-kara ngaa daw n̂-dujuje Lubba. ");
INSERT INTO ksp_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Bbeel dda dewje tɔyn mba Lubba dda neje ke dum dɔ koo, ke ne-mɔrije nya nya ddew te le nje-kayn-kulaje. ");
INSERT INTO ksp_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Me dewje ke ooje mede te to kara baa ngaa dunguje neje lede dɔ naa te kara baa. ");
INSERT INTO ksp_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","N̂-labbeje ndɔɔje lede, ke ne-kingaje lede ngaa n̂-kaynje naa nare ase kem ne ke dude. ");
INSERT INTO ksp_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Dooje ta naa ngaa ke ndɔ kara kara tɔyn daw dawje key-polo-Lubba te naa te. Daw dusaje ne ta key te le naa. Daw dusaje ne lede ke koko, ke me ngonn̂-kase. ");
INSERT INTO ksp_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","N̂-pitije Lubba ngaa dewje tɔyn oojede maji kemde te. Ke ndɔ kara kara tɔyn Ebbe-dewje aw ungu dewje ke naw najide dɔ mare te. ");
INSERT INTO ksp_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Mare ndɔ, Piyar de ke Jan dawje ke key-polo-Lubba te mba duju Lubba ke gɔl kare ke muta te lo-kul te. ");
INSERT INTO ksp_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Dewje awje ke mare dew ke duje to nje-mete undaeje ta key-polo-Lubba te ke daw n̂-bbar na Ta-key ke Kura. Daw dundae keteenn ke ndɔ ke ndɔ kare n̂-kɔy ne ji dewje te ke aw andeje me key-polo-Lubba te le. ");
INSERT INTO ksp_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Toke noo Piyar de ke Jan ke daw ta kande me key-polo-Lubba te le a, n̂-dujude kare dareje nare. ");
INSERT INTO ksp_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Yeenn a, kem Piyar de ke Jan to ke dɔe te ngaa Piyar pa na: «Aaje!» ");
INSERT INTO ksp_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Dew le aade mba neje to na kinga mare ne jide te. ");
INSERT INTO ksp_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","A Piyar pa are na: Mee ke ande wase nare ta kari ang. A ne ke mee ne a neeenn, mari: In taar, e-nja ke ri Jeju ke Najarete!» ");
INSERT INTO ksp_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Piyar uwa ji-kɔl dew le are nin taar. Kem naa te neenn njaa gɔleje, ke esengele gɔleje mɔnguje. ");
INSERT INTO ksp_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Naal bbate nar taar ngaa n̂-nja. Nande ke de key-polo-Lubba te naw n̂-nja, naw n̂-tal n̂-turu nɔsu ne gaji Lubba. ");
INSERT INTO ksp_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Dewje tɔyn ooeje naw n̂-nja ngaa naw nɔsu gaji Lubba le. ");
INSERT INTO ksp_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Dewje gereje ke maje to nje-ne-kɔy ke isi lew ta key-polo-Lubba te ke daw n̂-bbar na Ta-key ke Kura le aann. Bbeel dda dewje le ngaa tar ikide sel wɔju dɔ ne ke inga dingaw le. ");
INSERT INTO ksp_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Dew le inya go Piyar de ke Jan ang. A me dewje tɔyn unda dɔ benya ngaa aynje awje rɔde te kɔ baranda te ke daw n̂-bbar na Baranda le Salomɔ. ");
INSERT INTO ksp_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Toke Piyar oo ne le be a, pa arede na: «Dewje ke Ijarayel, mba ddi bba arje bbeel ddase wɔju dɔ ne ke tee horose te wa? Mba ddi bba aw aajeje toke ne ke ddew singaje te njaa wase mba ngem ke jaw n̂-ngem ndu le Lubba le bba n̂-ddae jare n̂-nja wa? Baann ang. ");
INSERT INTO ksp_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Lubba le Abaraham, Ijake, ke Jakobbo, Lubba le kajeje ɔsu gaji Nje-kula laa Jeju ke uwaeje ilaeje ji nje-kɔn̂-bbeje te, ngaa e-mbeteje nɔ Pilate te ke ndiki ta kinyae. ");
INSERT INTO ksp_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","E-mbeteje Nje-me-nda ke to dew ke gate gate ngaa e-dujuje are dɔru nje-tɔl dewje key-kula te darese. ");
INSERT INTO ksp_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Dew ke nje-dda tebbe ke e-tɔleje le, Lubba ndɔle are n̂-toje to nje-tar naji ne neenn le. ");
INSERT INTO ksp_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Dingaw ke ooeje ngaa e-gereje ke ar neenn, mbal dɔ koo ke joo meje te ke ri Jeju a, ri Jeju le are singa. Koo me te ke Jeju le a dda are rɔe ddee maji a sese tɔyn njaa aw ooje neenn. ");
INSERT INTO ksp_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","A ngakɔmje, m-gere maji to sese, ke nje-kɔn̂-dɔseje e-ddaje ne baann mba to ne ke e-gereje ang. ");
INSERT INTO ksp_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Dɔngɔr kete, Lubba njaa unda tar neenn ta nje-kilaje mber-tar te laa tɔyn na Kiriste laa a koo-ndoo are tar le a ddee ne ke tɔkɔrɔ neenn. ");
INSERT INTO ksp_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Yeenn a, e-turuje mese ta e-telje rɔ Lubba te. Baann bba na toko majangje lese, ");
INSERT INTO ksp_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ngaa Ebbe-dewje a karese mare kare ke a kisije ke me-wul-lɔm ngaa na kula ke Kiriste ke n̂-mɔse kete ta karese: Jeju. ");
INSERT INTO ksp_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Karje te neenn, Kiriste le a kisi darâ ndereng ndɔ ke Lubba a tel ke neje tɔyn dɔgɔle te, ddew kara baa toke Lubba unda tare ta nje-kilaje mber-tar te laa ke maji tɔyn are paje. ");
INSERT INTO ksp_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moyije pa kete na: ‹Ebbe-dewje Lubba lese a kula mare dew kara horo ngakɔnse te karese to nje-kila mber-tar le Lubba toke ema. A kooje tae ddew neje te tɔyn ke na pa karese. ");
INSERT INTO ksp_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Dew ke oo tar le nje-kila mber-tar le Lubba le ang a, da kɔre ke ddang horo dewje te le Lubba.› ");
INSERT INTO ksp_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Nje-kilaje mber-tar le Lubba tɔyn, unn kute dɔ Samuyel te, ke nje-kilaje mber-tar le Lubba ke ddeeje goe te paje tar kara kara tɔyn wɔju dɔ ndɔje neenn le. ");
INSERT INTO ksp_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ndu-kunn ke nje-kilaje mber-tar le Lubba ndaji neenn to wɔju dɔse tɔ. Eeje kɔ dɔnɔ te ke Lubba ɔsu ke kasese dɔ ndɔ te ke n̂-pa nare Abaraham na: ddew te le dewje ke geli te, Lubba a bbar Tar ke maji dɔ dewje te tɔyn ke dɔ nange te. ");
INSERT INTO ksp_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Sese a Lubba unn Nje-kula laa dɔngɔr ulae kare n̂-bbar Tar ke maji dɔse te kare nɔruse kara kara tɔyn me ne-ddaje te lese ke maji ang.» ");
INSERT INTO ksp_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Toke Piyar de ke Jan daw n̂-paje tar ke dewje bbay a, nje-poloje Lubba, nje-kɔnje dɔ dewje ke aw ngemje ta key polo Lubba, ke *saduseyenje teeje ingajede. ");
INSERT INTO ksp_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Wungu ɔnde mba ne ke Piyar de ke Jan daw n̂-tɔjuje dewje ddem, mba Piyar de ke Jan n̂-paje dare dewje le na Jeju in horo nje-yoje te are dewje ke oyje a kinje horo nje-yoje te tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Duwajede dilajede key-kula te ndereng lo-are, mba dɔ loo kul ngaa. ");
INSERT INTO ksp_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","A mare dewje banya banya horo dewje te ke tuka mbide ooje ne tar le Lubba le ooje mede te are kɔr nje-me-kunnje ase ne ke doro mi. ");
INSERT INTO ksp_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Lo are a, nje-kɔnje dɔ Jiipije, ke tɔkuje, ke nje-kɔruje gel-ndu ke eeje Jurusalam mbɔnje naa. ");
INSERT INTO ksp_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ann ke to tɔku nje-polo Lubba, Kayipi, Jan, Alekejandere, ke nje-nujuje le tɔku nje-poloje Lubba tɔyn eeje teenn tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Dare n̂-ddee ke Piyar, ke Jan nɔde te ngaa n̂-dujude tar na: «Ddew singa-mɔngu te le na wase ke ri na bba aw ddaje ne ne neenn wa?» ");
INSERT INTO ksp_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ndil-me-nda ddusu Piyar ngaa pa arede na: ");
INSERT INTO ksp_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","«Nje-kɔn̂-bbeje, ke tɔku dewje, n̂-dda maji ke nje-mete, a bbokone dewje aw dujuje ta gere ddew ke n̂-dda bba rɔe ddee ne maji le. ");
INSERT INTO ksp_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Sese tɔyn, ke dewje ke Ijarayel, maji kare e-gereje to, ke ri Jeju kiriste ke Najarete a dew neenn ar ne nɔse te ke rɔ ke maji neenn. Jeju ke e-tɔleje dɔ kake dese te a Lubba ndole le. ");
INSERT INTO ksp_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ne a maketuruje le Lubba pa tar laa na: ‹N̂-to er ke esee nje-kɔsuje key e-mbeteje le aann. Er le tel ddee to singa gɔl key ke dungu nangê.› ");
INSERT INTO ksp_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ne kara baa nase kajije, mba Lubba are mare ri dang dɔ nange te ke a kase kajije ang. ");
INSERT INTO ksp_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Toke nje-gangeje sariya le Jiipije ooje ddew ke Piyar de ke Jan ke n̂-toje to dewje ke baa ke dewje ke gereje maketuru ang daw n̂-paje ne tar ke bbeel ang le a, gange singade. A n̂-gɔnjede n̂-gereje tɔ to n̂-toje to nje-buwa-njaje le Jeju. ");
INSERT INTO ksp_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ngaa daaje dew ke ar mbɔrde te ke rɔe ddee maji le a, n̂-gereje tar ke da kilaje te ang. ");
INSERT INTO ksp_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Yeenn a, dunnje ndu kare Piyar de ke Jan n̂-teeje *lo dda tar te le Jiipije te le ke ddang. Ngaa duwaje dɔ naa a, n̂-paje na: ");
INSERT INTO ksp_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ddi a ja ddaje ke dewje neenn wa? Mba dede njaa n̂-ddaje ne-mɔri neenn are dewje ke Jurusalam tɔyn gereje ke maje. Ddew ke ja maynje ne tare goto. ");
INSERT INTO ksp_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Maji kare n̂-ddaje jare tare nja ke kete horo dewje te ang ngaa. Ja kin ke de kare n̂-bbar ri Jeju n̂-pa ne tar dare mare dew ang. ");
INSERT INTO ksp_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nje-gangeje sariya le bbarje Piyar de ke Jan le ngaa paje arede kare n̂-paje tar wase n̂-tɔjuje ne ke ri Jeju ang. ");
INSERT INTO ksp_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","A Piyar de ke Jan dilaje te na: «Ddi a to gate gate kem Lubba te wa? Koo tase wase koo ta Lubba wa? To tar lese kare ujaje keme! ");
INSERT INTO ksp_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ddew ke jeje neenn ja kutu ne taje dɔ ne te ke joo ke kemje ddem ke mbije ddem goto.» ");
INSERT INTO ksp_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","N̂-telje dinje ke de bbay a, dinyade mba dingaje mare tar ke a kase kunn ddew kare duwaje ne de ang. Mba dewje tɔyn aw ɔsuje gaji Lubba wɔju dɔ ne ke nday le. ");
INSERT INTO ksp_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Dew ke n̂-dda ne-mɔri dare rɔe ddee maji le bbale uta bbal dɔsɔ. ");
INSERT INTO ksp_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Toke dinya Piyar de ke Jan a, daw dingaje nje-buwa-njaje lede ngaa dɔruje gel neje ke tɔku nje-poloje Lubba, ke tɔkuje paje arejede le. ");
INSERT INTO ksp_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Goe te ke dooje tar lede le a, dede tɔyn njaa n̂-n̂-dujuje ke ndu ke kara baa: «Ebbejeje, Ei njaa e-dda dara, ke nange, ke ba, ke neje tɔyn ke toje te. ");
INSERT INTO ksp_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ei ke are Ndil-me-nda unda tar neenn ta kajeje Dabbiti te ke to nje-kula lei na: ‹Mba ddi bba dewje aw unndaje ne bula ngaa daw dunguje ne tar me naa te baa wa? ");
INSERT INTO ksp_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nje-kɔn̂-bbeje tɔyn ke nangê neenn aw ooje taa naa ngaa tɔku mbayjeje mbɔnje naa mba ddaje ddɔ ke Ebbe-dewje ddem, Mesi laa ddem.› ");
INSERT INTO ksp_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«Tɔkɔrɔ njaa, Erode de ke Ponse Pilate n̂-mbɔnje naa me bbe te neenn ke dewje ke gelde to Jiipije ang ddem ke Jiipije njaa ddem mba mbete ne Jeju ke to nje-kula lei ke maji tɔyn ke ila wubbu dɔe te ta kundae dang to Mesi. ");
INSERT INTO ksp_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Toke baann a, n̂-ddaje dare ne tɔyn ke e-mɔse kete ddew singa-mɔngu te lei, ke ddew me-ndiki te lei le ddee to ne ke tɔkɔrɔ. ");
INSERT INTO ksp_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yeenn a, ke bbasine neenn, Ebbejeje, maji kare oo singa ke daw n̂-ddaje ke je bbo areje singa jee nje-kulaje lei are n̂-pa ne tar lei ke bbeel ang. ");
INSERT INTO ksp_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Maji kare e-tɔju singa-mɔngu lei are rɔ-toje goto rɔ dewje te, are ne-mɔri, ke ne ke dum dɔ koo toje. Are nejeenn ddee toke baann ke ri Jeju ke to Nje-kula lei ke maji tɔyn.» ");
INSERT INTO ksp_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Toke n̂-dujuje Lubba n̂-tungaje a, nange yeke lo te ke n̂-mbɔnje naa teenn. Ndil-me-nda ddusude ngaa dunnje kutu pa tar le Lubba ke bbeel ang. ");
INSERT INTO ksp_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Me nje-me-kunnje ke banya le ke keje lede to kara baa. Dew kara horo de te pa na mare ne to le ne ke kare ne baa ang, mba dunguje ne-kingaje lede tɔyn dɔ naa te kara baa. ");
INSERT INTO ksp_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nje-kayn-kulaje aw paje tar naji ke singa-mɔngu nya wɔju dɔ tar kin le Ebbe-dewje Jeju horo nje-yoje te, ngaa tɔku me-maji le Lubba to dɔde te kara kara tɔyn. ");
INSERT INTO ksp_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Dew ke ne due ee horode te ang, mba dewje ke eeje ke ndɔɔ wase key labbeje, ngaa ddeeje ke nare, ");
INSERT INTO ksp_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","unguje nɔ nje-kayn-kulaje te. Ngaa n̂-kayn naa nare dare na na kara inga ase kem ne ke due. ");
INSERT INTO ksp_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Yeenn bba, mare dew ke ria na Jejebbe ke nje-kayn-kulaje aw bbareje na Barnabase ee ke teenn. Gel ri le na: «Nje-kula dingaw me dewje te». N̂-to dew ke gel Lebi te ke duje Sipere. ");
INSERT INTO ksp_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nee ke mare ndɔɔ ngaa n̂-labbe, n̂-ddee ke nare nungu nɔ nje-kayn-kulaje te. ");
INSERT INTO ksp_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mare dingaw ke ria na Ananiyase de ke dene laa Sapira n̂-labbeje ndɔɔ lede tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","A Sapira ndiki te ke ngaweje Ananiyase are ɔru debbe nare le ngem ngaa aw ke kese aw ungu nɔ nje-kayn-kulaje te. ");
INSERT INTO ksp_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","A Piyar pa na: «Ananiyase, mba ddi a inya are Satan ande mei te wa? Ere ngem are Ndil-me-nda, mba ɔru debbe nare ndɔɔ lei le e-ngem to lei. ");
INSERT INTO ksp_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kete njaa kara ndɔɔ le to lei. Goe te ke e-labbe kara nare to lei tɔ. A baann bba keje dda ne ke to ke be ddee dɔi te wa? Yeenn to Lubba a ere ngem are bbo dewje ang.» ");
INSERT INTO ksp_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Toke Ananiyase oo tarjeenn le a tee oso nangê oy. Dewje tɔyn ke ooje tar yo le Ananiyase le bbeel ddade nya. ");
INSERT INTO ksp_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ngann basanje ddeeje keje niinn Ananiyase le awje ne aw dubbuje. ");
INSERT INTO ksp_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ase ne ke kare muta goe te a, dene laa ddee ande dɔde te a, gere ne kara dɔ ne te ke tee le ang. ");
INSERT INTO ksp_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piyar duje na: «Tɔkɔrɔ njaa, kɔr nare ndɔɔ lese ke e-labbeje le njaa neenn wa? E-pa arem moo.» N̂-pa nare Piyar na: «Tɔkɔrɔ, kɔr nare njaann.» ");
INSERT INTO ksp_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Yeenn a, Piyar pa are na: «Baann bba ei ke ngawije unguje tar me naa te mba na Ndil le Ebbe-dewje wa? Oo: Dewje ke dubbuje ngawije a arje taa-key te neenn. Ei kara da kunnije kɔtu ne tɔ.» ");
INSERT INTO ksp_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kare teenn njaa, n̂-tee noso kɔy-gɔl Piyar te noy. Kake ngann basanje le andeje key a, dooje niinn dene le ngaa dunnje daw ndubbuje mbɔr ngaweje te. ");
INSERT INTO ksp_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","*Egilisi, ke dewje tɔyn ke ooje tar ne ke tee le bbeel ddade nya. ");
INSERT INTO ksp_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Nje-kayn-kulaje ddaje ne-mɔrije ke neje ke dum-dɔ-koo nya nya horo dewje te. Dewje tɔyn ke ooje mede te mbɔnje naa kɔ baranda te le Salomɔ. ");
INSERT INTO ksp_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Dewje aw paje tar lede maji njaa a, a dew kara tay mba kande horode te ang. ");
INSERT INTO ksp_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Dewje ke banya banya ke kɔrde aw ke kete ke kete horo dingawje te ddem deneje te ddem unnje mede are Ebbe-dewje ngaa dunguje dɔ nje-me-kunnje te. ");
INSERT INTO ksp_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Dewje ddeeje ke nje-rɔ-toje ddew-bô. Dilaje nje-rɔ-tɔje le dɔ tiraje te wase dɔ rakeje te. N̂-ddaje toke baann kare ta Piyar aw nday a, ndile baa njaa kara uru dɔ mare nje-rɔ-toje te le. ");
INSERT INTO ksp_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Dewje banya banya inje ke me ngann bbeje te ke toje ngɔsi ke tɔku bbe ke Jurusalam ddeeje tɔ. Dotoje nje-rɔ-toje, ke dewje ke ndilje ke majang ulaje kemde ndoo n̂-ddeeje ke de ngaa dede tɔyn rɔde ddee maji. ");
INSERT INTO ksp_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Lo teenn, me dda tɔke nje-polo Lubba, ke nje ke mbɔre te ke eeje me kuwa-dɔ-naa te le *Saduseyenje ngaa dinje, ");
INSERT INTO ksp_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","duwaje nje-kayn-kulaje le dungujede key-kula te ke n̂-dda mba dewje tɔyn. ");
INSERT INTO ksp_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","A mare anji le Ebbe-dewje ddee til te tɔru ta key-kula are n̂-teeje, ngaa pa arede na: ");
INSERT INTO ksp_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Awje aw arje me key-polo-Lubba te ta e-paje tarje tɔyn ke wɔju do tar tebbe neenn areje dewje ke banya.» ");
INSERT INTO ksp_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nje-kayn̂-kulaje le ooje tae ngaa lo a ta kare a dawje me key-polo-Lubba te ngaa n̂-tɔjuje ne. Tɔke nje-polo Lubba ke nje ke mbɔre te bbarje tɔkuje kare duwaje dɔ naa lo dda tar te le Jiipije te le Jiipije. Ngaa, dulaje key-kula te kare n̂-ddeeje ke nje-kayn-kulaje le. ");
INSERT INTO ksp_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","A dewje ke dulade le teeje key-kula te a, ingaje nje-kayn-kulaje le me sururu te le ang. Nje ke dulajede le telje aw paje arejede na: ");
INSERT INTO ksp_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Joo ta key le a to ke lo kute ke maje. Nje-ngemje ta key-kula le kara arje lo-kula te lede. A jɔru ta key le a, joo dew kara me te ang.» ");
INSERT INTO ksp_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nje-kɔn dɔ dewje ke aw ngemje ta key polo Lubba, ke tɔke nje-poloje Lubba ooje tarjeenn le a, tar ikide sel wɔju dɔ nje-kayn-kulaje le ngaa n̂-paje na: «Ddi a dda ne wa?» ");
INSERT INTO ksp_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","A mare dew ddee pa arede na: «Dewje ke ilajede key-kula te le a, arje me key-polo-Lubba te ngaa aw tɔjuje ne dewje.» ");
INSERT INTO ksp_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Yeenn a, nje-kɔn dɔ dewje ke aw ngemje ta key key-polo-Lubba le aw ke nje-kulaje laa ngaa daw n̂-ddee ke nje-kayn-kulaje le, a n̂-dda ke de singa ang. N̂-bbeelje mba dewje a tilajede ke er tɔljede. ");
INSERT INTO ksp_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Goe te ke n̂-ddee ke de a, dawje ke de lo dda tar te le Jiipije ngaa tɔku nje-polo Lubba dujude na: ");
INSERT INTO ksp_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Junn ndu ngeng nya jarese kare e-tɔju ne ke ri neenn ang. A ye a ne-tɔju lese taa me bbe ke Jurusalam tɔyn neenn ngaa aw ddaje kare tar yo le dingaw neenn uwa dɔje.» ");
INSERT INTO ksp_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Piyar de ke nje-kayn-kulaje le dilaje te na: «Koo ta Lubba maji uta koo ta dewje. ");
INSERT INTO ksp_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Lubba le kajeje are Jeju ke e-tɔeje dɔ kake-dese te ngaa e-tɔleje le in horo nje-yoje te. ");
INSERT INTO ksp_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Lubba le unne undae dɔ ji-kɔle te to tɔku mbayje ddem nje-kaji dewje ddem. Baann bba kare ngann Ijarayelje ingaje ddew ta turu ddew lede ddem, kare tar majang lede ɔru dɔde te ddem. ");
INSERT INTO ksp_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Jeje ddem, Ndil-me-nda ke Lubba are dewje ke ooje tae ddem, n̂-toje to nje-tar-naji neje ke teeje le.» ");
INSERT INTO ksp_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Toke nje ke lo dda tar te le Jiipije le ooje tar ke nje-kayn-kulaje paje le a, ungu ɔnde ngaa n̂-ndikije kare n̂-tɔlde. ");
INSERT INTO ksp_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","A mare parijiyen ke ria na Gamaleyel ke to nje-kɔru gel ndu ke dewje ndikije tar laa nya ee lo dda tar teenn le. Nin taar nunn ndu kare n̂-teeje ke nje-kayn-kulaje le ddaka ngaji. ");
INSERT INTO ksp_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ngaa n̂-pa nare nje-ddaje tarje le na: «Ngann Ijarayelje, ooje ke maje bba ta e-ddaje ne ke dewje neenn. ");
INSERT INTO ksp_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mba me ndɔje te neenn, jooje Tedase ke oo rɔe to dew ke ngeng nya unda lo tee. Ngaa dewje ase ne ke kɔr sɔ unnje goe. A n̂-tɔle ngaa nje ke unnje goe le sarenje naa are dew kara nayn ang. ");
INSERT INTO ksp_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Goe te a, Judase dew ke Galile unda lo tee, bbal te ke daw dunda ne ri dewje me maketuru te mba gere ne kɔrde. N̂-dda nare dewje unnje goe. A n̂-tɔle ngaa nje ke unnje goe sarenje naa. ");
INSERT INTO ksp_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Bbasine m-pa marese, undaje kemse dɔde te ang, inyajede areje dawje. Bbo ne ke n̂-ndikije ta dda wase ne ke daw n̂-ddaje neenn in ddew te le dewje baa a, a kunda ngange. ");
INSERT INTO ksp_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Bbo ne ke n̂-ndikije ta dda wase ne ke daw n̂-ddaje neenn in ddew te le Lubba a, a kɔkuje ddewe pin. Areje Lubba oose to dewje ke aw ddaje saa ddɔ ang.» Nje-ddaje tarje le ndikije go tar laa le ngaa, ");
INSERT INTO ksp_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","n̂-bbarje nje-kayn-kulaje le, dundajede ke ndey, darede ndu kare n̂-paje tar ke ri Jeju ang ngaa dinyade. ");
INSERT INTO ksp_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nje-kayn̂-kulaje le teeje lo dda tar te le Jiipije le ddaka ke rɔ-neel mba Lubba oode to dewje ke ase kare dula kemde ndoo wɔju dɔ ri Jeju. ");
INSERT INTO ksp_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ke ndɔ tɔyn me key-polo-Lubba te wase me keyje te kara dew rɔde tɔju tar ang ddem, dew rɔde kila mber-Tar ke maji le Jeju ke to Mesi ang ddem. ");
INSERT INTO ksp_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Dɔ ndɔe teenn, kɔr nje-njaje go Jeju te aw ke kete kete. Jiipije ke aw paje tar gereke aw ewnje rɔde ke ri dede ke n̂-toje to Ebereje njaa. Mba ke ndɔ tɔyn bbo ebereje le aw kaynje ne-kusa dene-ndubbaje a, ɔruje kem dene-ndubbaje lede. ");
INSERT INTO ksp_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nje-kayn̂-kulaje ke dɔku gire joo le bbarje nje-njaje go Jeju te ngaa paje na: «To maji kare jeje neenn n̂-tusuje tar le Lubba jinyaje a, jaw mba dda kula ne-kayn ang. ");
INSERT INTO ksp_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Be a, ngakɔmje, e-mbereje dewje siri horose te ke dewje aw paje tar lede maji, dewje ke Ndil, ke kem-kare ddusude areje jinyaje kula neenn jide te. ");
INSERT INTO ksp_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","A Jeje, ja kunn rɔje mba kula duju Lubba, ke kula tɔju tar le Lubba.» ");
INSERT INTO ksp_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Dewje ke mbɔnje naa le tɔyn ndikije go tar ke nje-kayn-kulaje paje arede le. Yeenn a, dewje ke n̂-mberede to: Etiyenn ke koo me te laa bo nya ddem, Ndil-me-nda dduse ddem, Pilipi, Porokɔr, Nikanor, Timɔ, Parmenase, ke Nikolase ke to dew ke Antiyose ke aw bbeel Lubba le Moyije. ");
INSERT INTO ksp_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","N̂-ddeeje ke dewje ke siri le nɔ nje-kayn-kulaje te le dare n̂-duju lubba dɔde te ddem, dila jide dɔde te ddem. ");
INSERT INTO ksp_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tar le Lubba nja ke kete kete ngaa kɔr nje-njaje go Jeju te aw ke kete ke kete me bbe te ke Jurusalam. Nje-poloje Lubba ooje mede te toke banya. ");
INSERT INTO ksp_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Me-maji le Lubba ke singa-mɔngu laa to dɔ Etiyenn te are n̂-dda ne-mɔrije, ke neje ke dum dɔ koo ndang ndang horo dewje te. ");
INSERT INTO ksp_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mare Jiipije ke inje Sirene, ke Alekejandiri ke aw mbɔnje naa key-mbɔn̂-naa te le Jiipije ke daw n̂-bbarde na «Nje ke teeje kɔ bbere te», ke nje ke inje nange te ke Silisi, ke nje ke Aji aw maynje tar ke Etiyenn. ");
INSERT INTO ksp_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","A tar kem-kare laa ke naw n̂-pa ddew te le Ndi-me-nda le uta dɔde. ");
INSERT INTO ksp_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Yeenn ngaa dareje nare dewje mba kare paje na: «Joo Etiyenn lo taji ri Moyije te, ke lo taji ri Lubba te.» ");
INSERT INTO ksp_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Baann bba dɔsuje kutu dewje, kutu tɔkuje, ke kutu nje-kɔruje gel ndu dare duwa Etiyenn ke singa ngaa daw saa lo dda tar te. ");
INSERT INTO ksp_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","N̂-ddeeje ke nje-tar-najije ke toje to nje-ngemje dare paje na: «Ke ndɔ tɔyn njaa dingaw neenn aw pa Tar ke maji ang dɔ key-polo-Lubba te ke maji tɔyn ddem, dɔ ndu te ke Lubba are Moyije ddem. ");
INSERT INTO ksp_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","N̂-pa na Jeju ke to dew ke Najarete a tuju key-polo-Lubba, ngaa a turu ne-ji-bbeje ke Moyije inya areje are joo ke mbije.» ");
INSERT INTO ksp_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kem nje-dda tarje tɔyn to ke dɔ Etiyenn te ngaa dooje keme a, toke kem anji. ");
INSERT INTO ksp_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tɔku nje-polo Lubba duju tar Etiyenn na: «Tar ke daw n̂-pa dɔi te neenn to tar ke tɔkɔrɔ wa?» ");
INSERT INTO ksp_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etiyenn ila te na: «Ngakɔmje, bɔydede, ooje tar neenn. Kete bba kare bɔjeje Abaraham ddee lo te ke Karan a, Lubba ke to Nje-ndoko tee ingae kare te ke nisi ne nange te ke Mejopotami, ");
INSERT INTO ksp_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ngaa n̂-pa nare na: ‹Ɔtu nange te lei, me nujuje te lei bbo aw nange te ke ma tɔji.› ");
INSERT INTO ksp_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Yeenn a, Abaraham ɔtu nange te le dewje ke Kalde ngaa aw isi lo te ke Karan. Go yo te le bɔeje a, Lubba are n̂-ddee nange te ke e-ddaje bbe te bbasine neenn. ");
INSERT INTO ksp_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Lubba are mare lo Abaraham kara nange te neenn ang, ngonn lo ke a kase kila gɔl dew njaa kara nare ang. Nee ke ngonn ang njaa, a Lubba unn ndu ta kare nange le, ke nje ke gele te. ");
INSERT INTO ksp_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Lubba pa na: ‹Nje ke geli te a ddaje bbe nange te ke dang. Da kuwade bbere te ngaa da kula kemde ndoo mba bbal kɔr dɔsɔ. ");
INSERT INTO ksp_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","A ema Lubba, ma gange sariya dɔ nje-bbeje te ke uwajede bbere te le. Goe te bba da teeje kɔ bbere te le, ta da polom lo te neenn.› ");
INSERT INTO ksp_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Lubba ɔsu saa dɔnɔ ddew kuja mɔtu te. Yeenn a, Abaraham uju Ijake ngaa ndɔ jijoo laa a, uja ganja. Ijake dda baann ke Jakobbo, ngaa Jakobbo dda ddew kara baa ke nganne ke dɔku gire joo ke toje to kajejedede. ");
INSERT INTO ksp_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Me dda kajejedede le wɔju dɔ ngokɔnde Jejebbe ngaa duwaeje n̂-labbeje dare daw saa Ejipite. A Lubba ee saa. ");
INSERT INTO ksp_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Nɔre dann ne-kem-to-ndooje te dang dang ke ddae ngaa nare kem-kare ddem n̂-dda nare Parawɔn ke to tɔku mbayje ke Ejipite ooe maji keme te ddem. Tɔku mbayje le undae to nje-kɔn dɔ nange ke Ejipite ddem, to nje-ngem neje tɔyn ke me key te laa ddem. ");
INSERT INTO ksp_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Tɔku bbo oso nange te ke Ejipite, ke nange te ke Kanaa are kem-to-ndoo dda dewje nya. Kajejedede ingaje ne ta kusa ang. ");
INSERT INTO ksp_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Toke Jakobbo ooje na ne-kusa to Ejipite a, nula kajejedede gɔl kara. ");
INSERT INTO ksp_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Gɔl joo laa ke nulade a, Jejebbe dda are ngakɔenje gereje ngaa Parawɔn gere nujuje le Jejebbe tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yeenn a, Jejebbe ula are n̂-ddee ke bɔeje Jakobbo, ke nje-nujuje laa tɔyn. Kɔrde tɔyn ase dɔsiri gire mi. ");
INSERT INTO ksp_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jakobbo aw Ejipite le ngaa oy nunn, ne ke kese kajejedede tɔyn. ");
INSERT INTO ksp_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Doto niinnde daw ne bbe te ke Sisem n̂-dubbude buwa-yo te ke Abaraham ndoko ke nare ji ngann le Emɔr te ke to dew bbe te ke Sisem. ");
INSERT INTO ksp_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Toke ndɔ ke Lubba a ta dda ne ke nunn ndue nare Abaraham ta dda ddee ngɔsi a, kɔr ngann Ijarayelje ke Egipite le aw ke kete kete, ");
INSERT INTO ksp_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ndereng ndɔ ke mare tɔku mbayje ke siki ke gere Jejebbe ang unn kutu kɔn dɔ nange ke Egipite. ");
INSERT INTO ksp_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Tɔku mbayje le ere nje ke leje ngaa n̂-dda kajeje maji ang. Nare n̂-tusuje ngann engutayje lede dinyade kare oyje. ");
INSERT INTO ksp_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Dɔ ndɔ te jeenn le a, duju Moyije. N̂-kura kem Lubba te. N̂-ngeme key le bɔeje mba nayn muta. ");
INSERT INTO ksp_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Goe te ke n̂-tuse dinyae a, ngonn le Parawɔn ke dene unne ngeme toke ngonne njaa. ");
INSERT INTO ksp_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","N̂-tɔju Moyije kem-kare le dewje ke Ejipite are naw n̂-pa tar ke ndu ke mɔngu ddem, n̂-dda ne ke singa ddem. ");
INSERT INTO ksp_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Toke ninga bbal dɔsɔ a, keje kaw koo ngakɔen Ijarayelje ddee dɔe te. ");
INSERT INTO ksp_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Naw ngaa noo ngokɔen ke mare dew ke Ejipite ddae maji ang a, nayn ngɔru-ddɔ laa ngaa nunda dew ke Ejipite le n̂-tɔle. ");
INSERT INTO ksp_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Neje to ngakɔenje a gereje to ddew te laa a Lubba a kɔru ne de kɔ bbere te. A ngakɔenje le gereje ang. ");
INSERT INTO ksp_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ndɔ kara goe te a, Moyji oo ngann Ijarayelje joo aw ddɔje naa. Ngaa n̂-ndiki ta dda kare dunguje naa te. N̂-pa narede na: ‹Ngakɔmje, e-toje to ngakɔn naa a mba ddi bba aw ddaje naa maji ang wa?› ");
INSERT INTO ksp_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","A ne ke naw n̂-dda nje-mare maji ang le nuta Moyije le ke ddang ngaa n̂-pa na: ‹Na bba undai to tɔku-mbay ddem, nje-gange sariya ddem dɔje te wa? ");
INSERT INTO ksp_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","E-ndiki ta tɔlum toke e-tɔl dew ke Ejipite takene le wa?› ");
INSERT INTO ksp_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Toke Moyije oo tar le baann a, ayn aw iya rɔe bbe-mba te nange te ke Madinya. Ngaa nuju ngannje ke dingaw joo keteenn. ");
INSERT INTO ksp_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«N̂-dda bbal dɔsɔ a, mare anji tee ingae me kɔr te dɔ er Sinay te. Anji le ee me ber-kam te ke aw ɔn puru. ");
INSERT INTO ksp_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ne ke Moyije oo le gange singae. Toke n̂-ddee ngɔsi ta tenn koo a, noo ndu Ebbe-dewje ke aw pa tar na: ");
INSERT INTO ksp_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹M-to Lubba le kaijedede, ke to Lubba le Abaraham, Lubba le Ijake, ke Lubba le Jakobbo.› Moyije isa ngaa ndiki ta kaa lo ang. ");
INSERT INTO ksp_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Yeenn a, Ebbe-dewje pa are na: ‹E-tɔru ne-gɔl ke gɔli te mba lo ke ar te neenn to lo ke maji tɔyn. ");
INSERT INTO ksp_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Tɔkɔrɔ moo ndoo le dewje lem aw ooje Ejipite ngaa moo ndu sɔm lede are m-ddee ta kɔrude kɔ bbere te. Ke bbasine neenn, aw, mba m-ndiki ta kulai Ejipite.› ");
INSERT INTO ksp_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Moyije ke ngann Ijarayelje mbeteje ngaa paje areje na: ‹Naa bba undai to tɔku-mbay ddem, nje-gange sariya ddem dɔje te wa?› Ne a Lubba ulae to tɔku-mbay ddem, nje-kɔrude kɔ bbere ddem ddew te le anji ke Moyije ooe me ber-kam te. ");
INSERT INTO ksp_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ne a nɔrude n̂-tee kede me bbe te ke Egipite ddew ne-mɔrije te, ke ne dum-dɔ-koo te me bbe te ke Egipite ddem, me tɔku ba-kate te ddem, ke me kɔr te ddem bbal dɔsɔ. ");
INSERT INTO ksp_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ne ke Moyije le a, n̂-pa nare ngann Ijarayelje na: ‹Lubba a kɔru ngokɔse horose te to mare nje-kila mber-tar le Lubba to ke ema neenn.› ");
INSERT INTO ksp_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ne a, kare te ke dewje aw uwaje ne dɔ naa me kɔr te nar horo kajejedede te ke anji ke aw pa saa tar dɔr er te ke sinay. Ne a, n̂-taa tar ke are tebbe le nareje. ");
INSERT INTO ksp_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«A kajejedede le ndikije ta kooje ta Moyije ang, n̂-mbeteje ngaa, mede ndiki ta tel kaw Ejipite. ");
INSERT INTO ksp_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","N̂-paje dareje Arɔn na «E-dda mare kɔrje ke a kɔruje nɔje areje, mba ne Moyije ke are n̂-tee ke je me bbe te ke Ejipite le, n̂-gere ne ke ingae ang. ");
INSERT INTO ksp_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Yeenn a, n̂-ddaje ngonn̂-da to kɔr lede dɔ ndɔeje teenn ngaa dareje ne-polo ddem, dɔsuje gaji ne ke n̂-ddaje ke jide le ke rɔ-neel ddem. ");
INSERT INTO ksp_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Mba yeenn a, Lubba inyade are n̂-poloje neje ke aw ndoko me dara te ddew kara baa toke n̂-dda tare me maketuru te le nje-kilaje mber-tar le Lubba na: ‹Ngann Ijarayelje, bbal dɔsɔ ke e-ddaje me kɔr te le ema a e-ddeeje ke daje ke neje ke to ne-polo aremje wa? ");
INSERT INTO ksp_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Otoje key tande kɔr ke ria na Moloke, ke endeterenden le kɔr lese ke ria na Repan, neje ke e-ddaje to kɔrje ta polode le. Mba yeenn a, ma kaw kese giri Babilɔne te.› ");
INSERT INTO ksp_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Kajeje eeje ke key tande ke maketuru dɔnɔ to te me kɔr te. Moyije dda key-tande le are to ddew kara baa ke ye ke Lubba unn ndu are kare n̂-dda. N̂-dda nare to ddew kara baa ke ye ke Lubba tɔje are noo. ");
INSERT INTO ksp_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Goe te ke nje ke go kajeje te ingaje key-tande le a Josuwe unn nɔde are dawje ne nange te ke duwaje ji dewje te ke toje to Jiipije ang n̂-taje mba Lubba tubba dewje le nɔde te. Key-tande le nayn teenn ndereng kɔn̂-bbe te le Dabbiti. ");
INSERT INTO ksp_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Lubba oo Dabbiti maji keme te ngaa Dabbiti duje kare nare ddew n̂-dda key nare Lubba le Jakobbo. ");
INSERT INTO ksp_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","A Salomɔ a dda key le are Lubba. ");
INSERT INTO ksp_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","A Nje-kisi ddutu dara te isi me key te ke ji dew dda ang. Ddew kara baa toke nje-kila mber-tar le Lubba pa na: ");
INSERT INTO ksp_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‹Ebbe-dewje na: Dara to ngende-mbay lem, nange to lo kungu gɔlum a key ddi bba a ta ddaje karem wa? Wase lo ddi bba a to lo kuwa-rɔ lem wa? ");
INSERT INTO ksp_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ema njaa m-dda nejeenn tɔyn ke jim ang wa?› ");
INSERT INTO ksp_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«See nje-dɔ ketereje, sese ke lubba bbarse a areje mese ketere ngaa ooje ne-bbar laa ang, a aw e-mbeteje tar le Ndil-me-nda ke ndɔ tɔyn. E-toje ddew kara baa ke kasese. ");
INSERT INTO ksp_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nje-kilaje mber-tar le Lubba ke dda bba kasese ddaje kede singa ang wa? Kasese tɔlje nje ke aw ilaje mber le dew ke gate gate kete bba kare n̂-ddee. A bbasine sese njaa kara e-labbeje dew ke gate gate le ngaa e-tɔleje. ");
INSERT INTO ksp_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ingaje ndu ke Lubba ula ne anjije ke maje, a e-ddaje kula ke turu ndu le ang.» ");
INSERT INTO ksp_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nje ke eeje lo-dda tar le ooje tarjeenn le a, wungu ɔnde ngaa n̂-ngerje ngangede mba wungu ɔnde dɔ Etiyenn te. ");
INSERT INTO ksp_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","A kem ne Etiyenn ke Ndil-me-nda dduse le to ke darâ. Noo ndoko le Lubba ngaa noo Jeju ke ar dɔ-ji kɔl Lubba te. ");
INSERT INTO ksp_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","N̂-pa na: «Ooje, maw maa me dara ke teeyn, ke ngonn le dew ke ar taar dɔ-ji-kɔl Lubba te.» ");
INSERT INTO ksp_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Dewje le utuje mbide uruje ne ekii ke taar. Goe te a, dede tɔyn njaa dinje naa te duruje dɔe te. ");
INSERT INTO ksp_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","N̂-ndɔreje n̂-teeje saa ke ddang me bbe te ngaa n̂-tilaeje ke er n̂-tɔle. Nje-tar najije ke undaje tar dɔe te le unguje kubbuje lede nɔ mare basan te ke ria na Sɔl kare n̂-ngem. ");
INSERT INTO ksp_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kare te ke daw n̂-tilaje Etiyenn ke er le a, Etiyenn le duju Lubba na: «Ebbemje Jeju e-taa kewn lem.» ");
INSERT INTO ksp_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Goe te a Etiyenn le ungu mekeje gɔle nangê ngaa uru ekii ke taar na: «Ebbemje, unda tar majang neenn dɔde te ang.» Go tar teenn njaa a noy. ");
INSERT INTO ksp_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sɔl to kara le dewje ke unguje tar gel nje-tɔlje Etiyenn te. Dɔ ndɔe teenn njaa, dewje ulaje kem Egilisi ke Jurusalam ndoo. Nje-me-kunnje sarenje naa dɔ nange te ke Jude, ke Samari a nje-kayn-kulaje a naynje. ");
INSERT INTO ksp_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Dewje ke aw bbeelje Lubba dubbuje Etiyenn ngaan n̂-nɔeje nya. ");
INSERT INTO ksp_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","A Sɔl unn kutu tuju Egilisi. Nande me keyje te, nuwa dingawje ke deneje ke singa ngaa nungude key-kula te. ");
INSERT INTO ksp_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Dewje ke sarenje naa le awje aw tɔjuje Tar ke maji ke lo lo. ");
INSERT INTO ksp_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Yeenn a, Pilipi tee aw mare bbe te ke Samari ngaa tɔju dewje tar le Kiriste. ");
INSERT INTO ksp_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nje-bbeje ke ddeeje toke banya le njaa tɔyn aw tukaje mbide aw ooje ne tar le Pilipi le. Mba dooje tar ne-mɔri ke naw n̂-dda ke mbide ddem dooje neje le ke kemde ddem. ");
INSERT INTO ksp_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ndilje ke maji ang banya banya teeje me dewje te ke ddang. Daw n̂-teeje a duruje ekii ke taar. Ngaa dewje nya ke rɔde oy, ke nje-meteje ddeeje maji. ");
INSERT INTO ksp_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Dewje ke me bbe teenn le isije ke koko nya. ");
INSERT INTO ksp_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mare dew ke ria na Simɔ isi me bbe teenn lew baa. N̂-to nje-kuma ke aw dda neje ke aw dum dɔ dewje tɔyn ke nange te ke Samari. N̂-dda rɔe to dew ke ngeng nya. ");
INSERT INTO ksp_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ngannje, ke nje ke tɔku, dewje tɔyn ooje tae nya. Dewje paje na: «Dew neenn to singa-mɔngu ke in rɔ Lubba te ke daw n̂-bbar na Tɔku singa-mɔngu.» ");
INSERT INTO ksp_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Dooje tae nya mba n̂-dda neje ke dum dɔde bbal banya nya ddew ne-kumaje te laa ke naw n̂-dda. ");
INSERT INTO ksp_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","A dewje tɔyn, dingawje, ke deneje ke ooje mede te ke Tar ke maji ke Pilipi tɔju dɔ bbe-kɔn te le Lubba ddem, dɔ tar te le Jeju-Kiriste ddem, ingaje batem. ");
INSERT INTO ksp_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simɔ njaa kara oo mee te tɔ ngaa n̂-ddae batem. Ninya go Pilipi ang ngaa. Noo tɔku ne-mɔrije, ke neje ke dum-dɔ-koo ke Pilipi aw dda le a gange singae. ");
INSERT INTO ksp_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Toke nje-kayn-kulaje ke naynje Jurusalam ooje na nje-bbeje ke Samari taaje tar le Lubba le a, dulaje Piyar de ke Jan nange te ke Samari le. ");
INSERT INTO ksp_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Toke n̂-teeje nange te Samari le a, n̂-dujuje Lubba wɔju dɔ dewje ke Samari kare dingaje Ndil-me-nda. ");
INSERT INTO ksp_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Mba Ndil-me-nda ddee dɔ mare dew te ke Samari kara ang bbay. Ne ke dingaje njaa a to batem ke n̂-ddade ke ri Ebbe-dewje Jeju. ");
INSERT INTO ksp_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Yeenn a, Piyar de ke Jan dilaje jide dɔde te ngaa dingaje Ndil-me-nda. ");
INSERT INTO ksp_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","A kake Simɔ oo to nje-kayn-kulaje ilaje jide dɔ dewje te a ingaje Ndil-me-nda a, n̂-ndiki ta karede nare ");
INSERT INTO ksp_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ngaa n̂-pa na: «Aremje singa neenn tɔ ta bbo dew njaa mila jim dɔe te a, inga Ndil-me-nda.» ");
INSERT INTO ksp_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","A Piyar ilae te na: «Maji kare oy ke nare lei tɔyn mba ɔju to a kase ndoko ne-kare baa le Lubba ke nare. ");
INSERT INTO ksp_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Mare ne ke to lei wase ne ke osoi te kara to neenn ang. Mba keje lei to gate gate kem Lubba te ang. ");
INSERT INTO ksp_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Inya keje lei, ke maji ang lei ta e-duju Ebbe-dewje kare ta ddew to a nɔru tar kejeje ke maji ang le dɔi te. ");
INSERT INTO ksp_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tɔkɔrɔ njaa moo a, bbo ke maji ang ke to enga kinga ne ddusu mei ngaa e-to bbere le ne-dda ke maji ang. ");
INSERT INTO ksp_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simɔ ila te na: «Sese njaa, e-dujuje Ebbe-dewje wɔju dɔm bba kare ne ke e-paje neenn ddam ang. ");
INSERT INTO ksp_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Goe te ke Piyar de ke Jan n̂-paje tar naji ngaa dilaje mber-tar le Edde-dewje a, n̂-telje ke Jurusalam ngaa dilaje mber Tar ke maji ke me bbeje te nya nange te ke Samari. ");
INSERT INTO ksp_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Mare anji le Ebbe-dewje pa are Pilipi na: «Unn ddew ke aw ke dagoo, ke in Jurusalam ke Gaja. Kare teenn dew ee dɔ ddew te le ang. ");
INSERT INTO ksp_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Pilipi le ɔtu ke ngɔru aw ngaa, ninga mare dingaw ke ddew. Dew le to *enuku, n̂-to dew ke Etiyopi. N̂-to tɔku dew ke aw ngem ne-kingaje le Kandase ke to tɔku-mbay-dene ke Etiyopi. Dingaw le ddee Jurusalam mba polo Lubba, ");
INSERT INTO ksp_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ngaa aw tel ke bbê laa. Nisi me sarete te laa naw n̂-tura maketuru le Ejayi ke to nje-kila mber-tar le Lubba. ");
INSERT INTO ksp_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ndil pa are Pilipi le na: «Aw ke ngɔru aw inga sarete toonn.» ");
INSERT INTO ksp_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pilipi ayn ngɔru aw inga sarete le ngaa oo ndu dingaw ke Etiyopi ke aw tura maketuru le Ijayi. Pilipi duju tar enuku le na: «E-gere tar ke aw e-tura me maketuru te neenn njaa wa?» ");
INSERT INTO ksp_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Dingaw le ila te na: «Toke dew umam ang a, ma gere tar le toke baann wa?» Yeenn a, n̂-bbar Pilipi le kare aal sarete le isi mbɔre te. ");
INSERT INTO ksp_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Tar ke me maketuru te ke naw n̂-tura le toke be: «N̂-to ddew kara baa ke bate ke daw saa ta kuja gɔse, n̂-to toke ngonn bate ke daw duja biien a nɔ ang. Nɔru tae n̂-pa ne tar ang. ");
INSERT INTO ksp_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","N̂-ddae dare n̂-ddee to ne ang ngaa dare naji laa ang. Na a kase kɔru gel nje ke gele te wa? Mba n̂-dda dare tebbe laa ke dɔ nange te unda ngange.» ");
INSERT INTO ksp_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Enuke le pa are Pilipi na: «M-wali nya, e-pa arem moo. Naa njaa gate a nje-kila mber-tar le Lubba le aw pa tar laa neenn wa? To tar laa njaa wase tar le mare dew ke dang wa?» ");
INSERT INTO ksp_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Yeenn a, Pilipi unn kutu pa tar dɔ tar te ke enuku le tura me maketuru te neenn le bba tɔju ne Tar ke maji le Jeju are. ");
INSERT INTO ksp_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Toke daw dawje bbay a, n̂-teeje ta mare maann te ngaa enuku le pa na: «Maann a to neenn a, ddi a ɔku ddew kare minga batem wa?» ");
INSERT INTO ksp_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pilipi pa are na: «Toke unn mei tɔyn are Jeju a, ase kinga batem». Dingaw le pa na: «Moo mem te to Jeju to Ngonn le Lubba.» ");
INSERT INTO ksp_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","N̂-duju nare Sarete le ar lo kara ngaa Pilipi de ke enuku le joo kem n̂-ddisije dawje me maann te ngaa Pilipi ddae batem. ");
INSERT INTO ksp_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Toke dinje me maann te le n̂-teeje a, Ndil le Ebbe-dewje unn Pilipi ɔtu ne are Enuku le ooe ang. A Enuku le aw lo laa ke koko. ");
INSERT INTO ksp_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","A ne Pilipi n̂-tee nange te ke Ajote ngaa n̂-tɔju Tar ke maji me bbeje te tɔyn ke ddew ddew n̂-tee ne bbe te ke Sejare. ");
INSERT INTO ksp_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kare teenn, keje dda singa, ke keje tɔl nje-njaje go Ebbe-dewje te dɔrɔ nayn me Sɔl te. Yeen a naw rɔ tɔku mbayje te le nje-poloje Lubba ");
INSERT INTO ksp_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","n̂-duju maketuruje ta kaw ne kare nje ke key-mbɔ-naaje te ke Damase. Maketuru le a kunn ddew kare ta, toke ninga mare dewje ke toje to deneje wase dingawje ke aw unnje ddew le Ebbe-dewje, n̂-tɔde n̂-ddee ke de Jurusalam. ");
INSERT INTO ksp_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Toke Sɔl le ee ddew boo ngaa tee ngɔsi ke bbe ke Damase a, kem naa te neenn njaa lo ndoko darâ uru dɔe te gukue. ");
INSERT INTO ksp_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","N̂-tee noso nangê ngaa noo mare ndu dew pa saa tar na: «Sɔl, Sɔl mba ddi bba aw e-ddasem singa wa?» ");
INSERT INTO ksp_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sɔl le ilae te na: «Ebbe-dewje, ei na wa?» Ndu dew le ilae te na: «Ema Jeju aann, ema a aw ddasem singaann. ");
INSERT INTO ksp_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","A in taar ande me bbe te neenn a da tɔji ne ke maji kare e-dda.» ");
INSERT INTO ksp_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nje-buwa-kaw-loje laa arje baa nding nding ngaa bbeel ddade. Dooje ndu dew ke aw pa tar le a dooje dew kara ang. ");
INSERT INTO ksp_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sɔl in taar, teyn keme a oo lo ang. Duwa jaa bba dande saa me bbe te ke Damase. ");
INSERT INTO ksp_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Keteenn, noo lo ang, nusa ne ang, nay maann ang ndɔ muta. ");
INSERT INTO ksp_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Mare nje-nja go Jeju te ria na Ananiyase ee me bbe te ke Damase le. Ebbe-dewje bbare ke ni na: «Ananiyase!» N̂-ndiki te na: «Me neenn Ebbemje!» ");
INSERT INTO ksp_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ebbe-dewje pa na: «Aw ddew te ke daw n̂-bbar na ddew ke ndɔju, ta ande me key te Judase dew ke bbe te ke Tarse ke ria na Sɔl. Naw n̂-duju Lubba teenn. ");
INSERT INTO ksp_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ke ni sɔl le oo mare dew ria na Ananiyase ande key ngaa ila jia dɔe te kare noo lo.» ");
INSERT INTO ksp_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiyase le ila te na: «Ebbemje, dewje nya paje tar neje ke maji ang tɔyn ke dew neenn dda ke dewje lei ke to nje-me-kunnje Jurusalam ke nageenn baa. ");
INSERT INTO ksp_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Neenn njaa kara, tɔku nje-poloje Lubba areje ddew kare nuuwa dewje tɔyn ke aw bbarje rii n̂-tɔ dewje tɔyn ke bbarje rii.» ");
INSERT INTO ksp_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","A Ebbe-dewje pa na: «Aw, mba dew neenn le to dew ke mundae dang kare n̂-dda nare dewje ke toje to Jiipije ang, ke tɔku-mbayje lede, ke ngann Ijarayelje gereje rim. ");
INSERT INTO ksp_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ema njaa ma tɔje ne-kem-to-dooje tɔyn ke a ddae wɔju dɔ rim.» ");
INSERT INTO ksp_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Yeenn a Ananiyase le aw ngaa ande key le, ila jia dɔe te nga pa na: «Sɔl, ngokɔm, Ebbe-dewje Jeju ke ingai ddew te ke aw e-ddee ne ulam rɔi te kare e-tel oo lo ddem, kare ta Ndil-me-nda ddusi ddem.» ");
INSERT INTO ksp_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kem naa te neenn njaa ne ke to ke le gondojeenn in keme te gayn nangê ngaa noo lo. Yeenn ngaa ni taar ninga batem. ");
INSERT INTO ksp_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Go ne-kusa te ke nusa a, n̂-tel ninga singa. N̂-dda ndɔ ngaji rɔ nje-njaje go Jeju te ke eeje bbe te ke Damase. ");
INSERT INTO ksp_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Njange njange baa a, Sɔl aw ila mber key mbɔn̂-naaje te le Jiipije na Jeju to Ngonn le Lubba. ");
INSERT INTO ksp_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Dewje tɔyn ke ooje tar le Sɔl le arje nding nding ngaa paje na: «Dew neenn a aw ula kem dewje ke aw bbarje ri Jeju ndoo me bbe te ke Jurusalam ang wa? N̂-ddee neenn ta kuwa nje-me-kunnje tɔde kaw ke se kare tɔke nje-polo Lubba ang wa?» ");
INSERT INTO ksp_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","A Sɔl le aw ubba ke kete kete me tarje te ke naw n̂-tɔju are Jiipije ke bbe te ke Damase ooje tar kara ta pa ang kare te ke naw n̂-tɔju ke ddaka to Jeju to Mesi njaa. ");
INSERT INTO ksp_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ndɔ nya nday ngaa gɔe te a, Jiipije le unguje tar me naa te mba tɔlje Sɔl. ");
INSERT INTO ksp_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Tar le oso mbi Sɔl te. Daw n̂-ngemje ta ndokoje ke dila n̂-guku ne dɔ bbe le til, ke kare ta tɔle. ");
INSERT INTO ksp_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","A, mare ndɔ til te, nje-njaje goe te uwaeje ilaeje me kare te ngaa ulaeje ddaka ke dɔ ndoko. ");
INSERT INTO ksp_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Toke Sɔl le tee Jurusalam a, sange ddew ta kande horo nje-njaje go Jeju te, a dede tɔyn njaa n̂-bbeeleje to bbeel mba dooje to n̂-to nje-nja go Jeju te ke tɔkɔrɔ ang. ");
INSERT INTO ksp_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Yeenn ngaa Baranabase uwa Sɔl le aw saa rɔ nje-kayn-kulaje te ngaa, nɔru gel ddew ke Sɔl oo ne Ebbe-dewje dewbô ngaa Ebbe-dewje pa saa tar, ke ddew ke Sɔl pa ne tar le Jeju ke bbeel ang are dewje me bbe te ke Damase. ");
INSERT INTO ksp_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Unn kute keteenn njaa, lo tɔyn ke nje-kayn-kulaje aw awje te me bbe te ke Jurusalam a, naw ke de naa te naa te. Naw n̂-tɔju tar ke ri Jeju ke bbeel ang. ");
INSERT INTO ksp_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Naw n̂-pa tar ke Jiipije ke aw paje tar gereke ngaa naw n̂-mayn ke de tar, a dede daw n̂-sangeje ddew ta tɔle. ");
INSERT INTO ksp_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Toke nje-me-kunnje gereje tare a, dawje saa Sejare ngaa dulaeje Tarese. ");
INSERT INTO ksp_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Dɔ ndɔje teenn, ddekeke to me Egiliseje te tɔyn ke toje nange te ke Judee ke, Galate ke Samari. Egilisi aw sange ke kete kete, nje-me-kunnje aw ddaje bbeel le Ebbe-dewje ngaa kɔrde aw ke kete kete ddew singa te le Ndil-me-nda. ");
INSERT INTO ksp_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piyar aw nja ke dɔ bbe dɔ bbe. Mare ndɔ a, n̂-tee dɔ nje-ko-meteje ke bbe te ke Lida. ");
INSERT INTO ksp_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Lo teenn, ninga mare dingaw ke rɔe oy ngaa to tuwa-rɔ-to te nangê bbal jijoo. Ria na Ene. ");
INSERT INTO ksp_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piyar pa na: «Ene, Jeju Kiriste ɔru rɔ-to rɔi te. In taar bbo ei njaa e-mɔse dɔ tuwa lei.» Kem naa te neenn njaa nin taar. ");
INSERT INTO ksp_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Dewje tɔyn ke bbe te ke Lida, ke dewje tɔyn ke ndake lo te ke Sarɔn ooje mede te ke Ebbe-dewje. ");
INSERT INTO ksp_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Me bbe te ke Jope, mare dene ke to nje-nja go Jeju te ee teenn. Ria na Tabbita wase Dɔrkase. Kande ri le na: Kɔn mbur. Kula ke maji dɔrɔ a n̂-dda ngaa naw nare ne nje-ndooje ddem. ");
INSERT INTO ksp_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Dɔ ndɔeje teenn, rɔe toe ngaa noy. N̂-toko ninne ngaa dila me key te ke to dɔ mare te taar. ");
INSERT INTO ksp_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Nje-njaje go Jeju te ke eeje bbe te ke Jope ooje na Piyar ee bbe te ke Lida ke ew ke Jope ang. Yeenn a, dulaje dingawje joo dare Piyar na: «N-wali nya, e-ddee njange rɔje te.» ");
INSERT INTO ksp_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piyar aw ke de ke ngɔru. Toke n̂-tee a, dare naw me key te ke to dɔ mare te taar le. Dene-ndubbaje nɔnje ddeeje ne rɔ piyar te. N̂-tɔjeje dɔ kubbuje ke taar, ke kubbu kulje ke Dɔrekase le uju kare te ke n̂-nayn ne ke de baa. ");
INSERT INTO ksp_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piyar are dewje tɔyn teeje ddaka, ngaa ungu mekeje gɔle nangê duju Lubba. Goe te a, n̂-turu rɔe ke rɔ ninn te le ngaa n̂-pa na: «Tabbita, in taar.» Tabbita le teyn keme. Toke noo Piyar le a, nin nisi taar. ");
INSERT INTO ksp_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piyar ula jia uwae ne ke taar. Piyar le bbar nje-me-kunnje, ke dene-ndubbaje ngaa tɔjude Dɔrekase kem baa. ");
INSERT INTO ksp_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Dewje ke Jope tɔyn ooje tar neenn ngaa dewje nya ooje mede te ke Ebbe-dewje. ");
INSERT INTO ksp_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piyar nayn ndɔ bayn nya Jope rɔ nje-dda kula endaar te ke ria na Simɔ. ");
INSERT INTO ksp_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mare dingaw ee me bbe te ke Sejare, ria na Kɔrunay, n̂-to nje-kɔn dɔ mbambaje ke dunda ride mbɔn̂-naa lede na mbɔn̂-naa ke Itali. ");
INSERT INTO ksp_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ne ke nje ke key laa tɔyn daw n̂-ddaje bbeel le Lubba, naw numa Jiipije ke toje to nje-ndooje ddem, n̂-duju Lubba ke kareje tɔyn ddem. ");
INSERT INTO ksp_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Mare ndɔ noo mare anji le Lubba toke le nijeenn ande key laa dɔ kare te ke a kase gɔl kare muta ngaa bbare na: «Kɔrunay!» ");
INSERT INTO ksp_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kɔrunay le aae ke kem bbeel ngaa pa na: «Ebbe-dewje na ddi wa?» Anji le pa are na: «Lubba oo duju lei, ke kuma ke aw uma nje-dooje. Mee oy dɔi ang. ");
INSERT INTO ksp_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Bbasine neenn njaa, ula bbe te ke Jope are mare dew ke ria na Simɔ ke dawn n̂-bbare na Piyar ddee. ");
INSERT INTO ksp_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","N̂-to key le mare dingaw ke ria na Simɔ tɔ ke to nje-dda kula endaar ke key laa to mbɔr ba te.» ");
INSERT INTO ksp_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Toke Anji ke pa tar ke Kɔrunay le ɔtu a, n̂-bbar nje-kulaje laa joo, ke mare mbamba laa kara ke ee kɔe te ke aw dda bbeel le Lubba. ");
INSERT INTO ksp_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Nɔru gel neje le tɔyn narede ngaa nulade Jope. ");
INSERT INTO ksp_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ndɔ kara goe te ngaa kare te ke daw n̂-njaje ddewbô bbay ngaa n̂-teeje ngɔsi ke bbe ke Joppe a, Piyar aal aw lo te ke n̂-dda taar, dɔ key te mba duju Lubba ke gɔl kare ke ase kare dɔku gire joo. ");
INSERT INTO ksp_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","A bbo ddae are n̂-ndiki ta kusa ne. Toke daw n̂-dda ne-kusa ta kare a, noo ne toke le nijeenn. ");
INSERT INTO ksp_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Noo kem dara ke teyn, a noo mare ne ke in me dara te le aw ddisi. Ne le toke le pal-kubbu ke tate ke duwa tae ke sɔ ddee uwa nange. ");
INSERT INTO ksp_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Daje ke gɔlde sɔ, daje tɔyn ke aw akeje nangê ke eelje tɔyn ke aw inje me dara te eeje me pal-kubbu te le. ");
INSERT INTO ksp_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Mare ndu dew pa are na: «Piyar in taar, e-tɔl ɔn.» ");
INSERT INTO ksp_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","A Piyar ilae te na: «Baann ang! Ebbemje. Mba musa ne ke ndu mbete ke ne ke maji ang ndɔ kara ang.» ");
INSERT INTO ksp_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ndu dew le tel pa are bbay na: «Maji kare oo ne ke Lubba dda are ddee maji to ne ke maji ang kemi te ang.» ");
INSERT INTO ksp_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Neenn le to toke baann gɔl muta ngaa goe te a, dunn ne le n̂-tel ne darâ. ");
INSERT INTO ksp_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piyar sange ddew ta gere gel ne ke noo ke ni le pin. A kare teenn njaa dingawje ke Kɔrunay ulade le sangeje key le Simɔ ingaje ngaa arje ta key te le. ");
INSERT INTO ksp_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","N̂-bbarje ne n̂-dujuje se Simɔ ke daw n̂-bbare na Piyar to neenn wa? ");
INSERT INTO ksp_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Toke Piyar nayn aw eje dɔ ne te ke oo le bbay a, Ndil-me-nda pa are na: «Oo, dingawje muta aw sangije. ");
INSERT INTO ksp_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","In taar e-ddisi ta aw ke de bbo are mei sangi ang, mba ema a mulade.» ");
INSERT INTO ksp_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piyar ddisi inga dingawje le ngaa pa arede na: «Ema ke aw sangemje le a mar neenn. E-ddeeje neenn mba ddi wa?» ");
INSERT INTO ksp_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Dilaje te na: «Kɔrunay, nje-kɔn dɔ mbambaje a ulaje. N̂-to dew ke gate gate ngaa naw n̂-bbeel Lubba. Jiipije tɔyn aw paje tar laa maji. Anji le Lubba pa are kare n̂-bbari me key te laa, kare noo tar ke a ta pa kare.» ");
INSERT INTO ksp_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Piyar are dande key ngaa arede lo-to. Lo-kare te njaa, nunn ddew naw ke de. Mare nje-me-kunnje ke Jope danneje. ");
INSERT INTO ksp_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Lo-kare ke goe te a, n̂-teeje Sejare. Kɔrunayn bbar nje-nujuje laa ke nje-buwa-kuraje laa ke n̂-ndikide nya naw n̂-ngebbe ne Piyar dede le. ");
INSERT INTO ksp_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kare te ke Piyar a ta tee a, Kɔrunayn tila keme ngaa oso nɔn̂-gɔle te mba wale. ");
INSERT INTO ksp_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","A Piyar uwae ke taar ngaa pa na: «In taar, mba ema kara m-to dew mari.» ");
INSERT INTO ksp_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ngaa toke piyar aw pa tar ke kɔrunayn aw ande ne ke key a, noo dewje banya banya mbɔnje naa. ");
INSERT INTO ksp_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Piyar pa arede na: «E-gereje ke maje to dare ddew Jiipije kare uwaje buwa-kura ke dewje ke gelde dang ang ddem ta tee me key te lede ang ddem. A ema Lubba tɔjum to, to maji kare moo dew to dew ke maji ang kem te ang wase m-sange dew ang. ");
INSERT INTO ksp_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Mba yeenn a e-bbarem a m-ddee bbo meje ang. Yeenn a, m-ndiki ta gere gel ne ke e-bbarem mbae.» ");
INSERT INTO ksp_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kɔrunay pa are na: «Dda ndɔ muta bbokone ngaa, mee me key te lem maw m-duju Lubba dɔ kar te ke gɔl kare muta. A ta koo a, mare dew ula kubbu ke ndɔren ar ne nɔm te, ");
INSERT INTO ksp_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ngaa pa na: ‹Kɔrunay! Lubba oo ndu nɔ lei ngaa nole mee dɔ neje te ke aw are nje-ndooje. ");
INSERT INTO ksp_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ula bbe te ke Jope e-bbar Simɔ ke daw n̂-bbare na Piyar. N̂-to bbe le Simɔ nje-dda kula endaar ke key laa to ta ba te.› ");
INSERT INTO ksp_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kare teenn njaa, mula mari a, e-ndiki te ngaa e-ddee. Bbasine, jeje tɔyn jee nɔ Lubba te ta koo tar ke Ebbe-dewje unda tai te kare e-pa areje.» ");
INSERT INTO ksp_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Piyar ila te na: «Bbasene m-gere ngaa to tɔkɔrɔ njaa Lubba ɔru kem dew ang. ");
INSERT INTO ksp_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Horo gel-dewje te tɔyn, dew ke bbeel Lubba ddem, dda ne ke gate gate ddem a ddee maji kem Lubba te. ");
INSERT INTO ksp_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nula ke tar laa nare ngann Ijarayelje, to Tar ke maji ke are me-wul-lɔm ddew te le Jeju-Kiriste, ke to Ebbe-dewje tɔyn. ");
INSERT INTO ksp_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","E sese e-gereje ne ke tee nange te ke Galile ngaa taa dɔ nange Jude tɔyn go batem te ke Jan ila mbere. ");
INSERT INTO ksp_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","E-gereje ddew ke Lubba ula ne singa-mɔngu le Ndil-me-nda dɔ Jeju te ke Najare ke maje. N̂-dda maji ke dewje tɔyn ke lo lo ddem, naji dewje tɔyn ke Esu uwade bbere te ddem mba Lubba ee saa. ");
INSERT INTO ksp_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","A jeje n̂-toje to nje-tar-naji neje tɔyn ke n̂-dda dɔ nange te le Jiipije ddem, bbe te ke Jurusalam ddem. N̂-tɔeje kake-dese te ngaa n̂-tɔleje. ");
INSERT INTO ksp_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ndɔ muta laa a, Lubba are nin buwa-yo te n̂-tee ngaa are n̂-tɔju rɔe. ");
INSERT INTO ksp_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","N̂-tɔju rɔe le dewje tɔyn ang, a nje-tar najije ke Lubba mberede kete, ke jeje ke jusa saa ke jay saa ne go kin te laa horo nje-yoje te a n̂-tɔju rɔe nareje. ");
INSERT INTO ksp_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nunn ndu nareje kare jila mber Tar ke maji jare dewje, ngaa ta n̂-pa jarede to Lubba undae to nje-gange sariya dɔ dewje ke isije kem baa ddem dɔ dewje ke oyje ddem. ");
INSERT INTO ksp_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Nje-kilaje mber-tar le Lubba tɔyn paje tar laa na: «Dew ke oo mee te ke Jeju a, Lubba ɔru tar majang laa dɔe te ke ri Jeju.» ");
INSERT INTO ksp_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Toke Piyar nayn aw ɔru gel nejeenn bbay a, Ndil-me-nda ddee isi dɔ dewje te tɔyn ke aw ooje tar le. ");
INSERT INTO ksp_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Tar iki nje-me-kunnje ke toje to Jiipije ke dannje piyar le sel mba dooje a, Lubba are Ndil-me-nda dewje ke toje to Jiipije ang tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Dooje ddew ke dewje ke toje to Jiipije aw paje tar ke ndɔn̂-tarje ke dang dang ddem, aw ɔsuje ne gaji tɔke-mbange le Lubba ddem. Yeenn a, Piyar pa na: ");
INSERT INTO ksp_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Dewje le ingaje Ndil-me-nda toke jeje tɔ a mare dew a kase kɔku ddew kare dingaje batem maann wa?» ");
INSERT INTO ksp_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Piyar le are ddew kare n̂-ddade batem ke ri Jeju ngaa dewje le dujuje Piyar le kare dda ndɔ rɔde te ngaji bbay. ");
INSERT INTO ksp_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nje-kayn-kulaje, ke nje-me-kunnje ke eeje nange te ke Jude ooje na dewje ke toje to Jiipije ang kara taaje tar le Lubba tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Toke Piyar tel ke Jurusalam a, nje-me-kunnje ke toje to Jiipije aw inje saa. ");
INSERT INTO ksp_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","N̂-paje na: «Ande key le dewje ke ujaje mɔtude ang ngaa usa ke de ne mba ddi wa?» ");
INSERT INTO ksp_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Yeenn a, Piyar unn kutu kɔru gel neje ke tee le ke goe goe arede na: ");
INSERT INTO ksp_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Misi me bbe te ke Jope maw m-duju Lubba a, moo ne toke le nin. Moo mare ne toke le pal-kubbu ke tate ke duwa tae ke sɔ, ne le in me dara te ddisi ndereng tee lo te ke mee te. ");
INSERT INTO ksp_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Kem to ke dɔe te ngaa m-teenn a, moo daje ke gɔlde sɔ ke dɔ nange te, daje ke mû, daje ke aw akeje nangê, ke eelje ke aw ilaje me dara te. ");
INSERT INTO ksp_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ngaa moo ndu dew pa arem na: ‹Piyar, in taar e-tɔl ɔn!› ");
INSERT INTO ksp_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","M-pa na: ‹Baann ang Ebbemje! Mba musa ne ke ndu mbete wase ne ke maji ang ndɔ kara ang.› ");
INSERT INTO ksp_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","M-tel moo ndu dew le me dara te na: ‹Maji kare ne ke Lubba dda are ddee maji a, oo to ne ke maji ang kemi te ang.› ");
INSERT INTO ksp_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Neenn le to toke baann gɔl muta ngaa goe te a, dunn ne le tɔyn n̂-tel ne darâ. ");
INSERT INTO ksp_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kare teenn njaa, dingawje muta ke dulade rɔm te inje bbe te ke Sejare teeje me key te ke jisi te le. ");
INSERT INTO ksp_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ndil pa arem na mɔtu maw ke de bbo meje ang. Ngakɔmje ke misan neenn danemje ngaa jande me key te le Kɔrunay le. ");
INSERT INTO ksp_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nɔru gel ddew ke anji tee ingae ne me key te laa ngaa pa are na: ‹Ula dew bbe te ke Jope are Simɔ ke daw n̂-bbare na Piyar ddee. ");
INSERT INTO ksp_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Simɔ le a pa tarje kari. Ei, ke nje ke key lei a kingaje kaji ddew tarje teenn le.› ");
INSERT INTO ksp_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Toke munn kutu pa tar a, Ndil-me-nda ddisi dɔde te ddew kara baa to ke n̂-ddisi dɔje te kunn kute te. ");
INSERT INTO ksp_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Yeenn a, mole mem dɔ tar te le Ebbe-dewje ke pa na: ‹Jan dda dewje batem maann, a sese, a kingaje batem Ndil-me-nda.› ");
INSERT INTO ksp_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Lubba arede Ndil-me-nda ddew kara baa toke nareje kare te ke junn ne meje jare Jeju-Kiriste. Yeenn a, m-to dew ddi bba ma kase kɔku ddew Lubba kare dda mare ne wa?» ");
INSERT INTO ksp_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Dewje le ooje tarjeenn le a ewje rɔde ngaa ɔsuje gaji Lubba paje na: «Lubba are ddew dewje ke toje to Jiipije ang kare n̂-turuje mede mba kinga ne kaji tɔ.» ");
INSERT INTO ksp_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nje-me-kunnje ke sarenje naa wɔju dɔ ne-singa ke ingade go yo te le Etiyenn awje ndereng teeje bbe te ke Penisi, Sipere, ke Antiyose. A me bbeje teenn le Jiipije ke karede baa a n̂-tɔjude tar le Lubba. ");
INSERT INTO ksp_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","A mareje horode te ke gelde to dewje ke Sipere, ke dewje ke Sirene teeje me bbe te ke Antiyose a paje Tar ke maji le Ebbe-deweje Jeju are dewje ke toje to Jiipije ang tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Singa-mɔngu le Ebbe-dewje to dɔde te are dewje nya ooje mede te ke Ebbe-dewje ngaa turuje ddew lede. ");
INSERT INTO ksp_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nje-me-kunnje ke Egilisi te ke Jurusalam ooje tar neenn le ngaa ulaje Barnabase Antiyose. ");
INSERT INTO ksp_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Toke Barnabase le tee ngaa oo me-maji ke Lubba dda ke nje-me-kunnje le a, nee ke koko nya ngaa n̂-ndejede kare dundaje mede tɔyn dɔ Ebbe-dewje te. ");
INSERT INTO ksp_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Mba Barnabase le to dew ke maji, ke dew ke Ndil-me-nda dduse ddem, me-kunn laa bo nya ddem are nya ddeeje to dewje le Ebbe-dewje. ");
INSERT INTO ksp_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Goe te a, Barnabase le ɔtu naw bbe te ke Tarse mba sange Sɔl. ");
INSERT INTO ksp_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Toke ningae a, n̂-ddee saa Antiyose. N̂-ddaje bbal kara Egilisi te ke Antiyose ngaa n̂-tɔjuje ne dewje ke kɔrde banya banya. Bbe te ke Antiyose a dewje unn kutu bbar ri nje-njaje go Jeju te to keretiyenje. ");
INSERT INTO ksp_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Dɔ ndɔe teenn, mare nje-kilaje mber-tar le Lubba inje Jurusalam awje bbe te ke Antiyose. ");
INSERT INTO ksp_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ndil-me-nda unda tar ta mare te kara ke ria na Agabusu. Nin taar nga n̂-pa na: «Mare ndɔ a tɔku bbo a koso dɔ nange te tɔyn.» A tɔkɔrɔ njaa bbo le oso dɔ ndɔ te ke Kolode to tɔku mbayje. ");
INSERT INTO ksp_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nje-njaje go Jeju te ooje ta naa kare dew kara kara unn ne ke ase singae mba kula ne kare duma ne nje-me-kunnje ke isije nange te ke Jude. ");
INSERT INTO ksp_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","N̂-ddaje toke baann. Dareje neje le Barnabase de ke Sɔl dare dawje ne dare ansiyenje ke nange te ke Jude. ");
INSERT INTO ksp_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Dɔ ndɔe teenn, tɔku mbayje Erɔde unn kutu dda ne ke maji ang ke mare dewje ke Egilisi te. ");
INSERT INTO ksp_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Nare n̂-tɔl Jake ngokɔn Jan ke tɔku kiya. ");
INSERT INTO ksp_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Toke noo to ne ke n̂-dda le unn koko are Jiipije a, nare duwa Piyar bbay. Kare ke duwa ne Piyar le to kare ke Jiipije aw ddaje kusu mapa ke n̂-dda ke um ang. ");
INSERT INTO ksp_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Erɔde le are duwae ngaa dilae key-kula te. Ninyae ji mbambaje te dɔku gire misan ke n̂-kayn horode sɔ sɔ kare ta n̂-ngemeje. Neje kare kusu pake ndayn bba ta gange sariya dɔe te kem dewje te. ");
INSERT INTO ksp_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Piyar ee key kula te, a nje-me-kunnje aw dujuje Lubba til ke kare wɔju dɔe. ");
INSERT INTO ksp_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Me til te ke lo-kare a, Erɔde a ta gange sariya dɔ Piyar te le a, Piyar le aw tibbi horo mbambaje te joo. N̂-tɔe ke kula njamji joo ngaa mare mbambaje aw ngemje ta key le tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","A ta koo a, mare anji le Ebbe-dewje unda lo tee ngaa me key-kula le ndoko. Anji le ɔru kar Piyar are ndol ngaa pa na: «In taar njange.» Kula njamjije ke jia te le gaynje nangê. ");
INSERT INTO ksp_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Anji le pa are na: «Uwa bberi ke endaar-kuwa-bber lei bbo ula ne-gɔl lei.» Piyar le dda toke baann. Anji le pa bbay na: «Ula kubbu-kul lei bbo unn gom!» ");
INSERT INTO ksp_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piyar tee me key-kula te le oso goe te. Neje to ne ke anji le aw dda le to ne ke tɔkɔrɔ ang, mba noo to ni a naw n̂-ni. ");
INSERT INTO ksp_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","N̂-ndayje lo ke dɔngɔr, ke ye ke joo ke mbambaje aw ngemje a, n̂-teeje ta key te ke n̂-dda ke nare. To ta key ke daw dande ne ke me bbe te le. Ta-key le teyn ke dɔe baa nɔde te. Toke n̂-teeje ddaka ngaa dunnje mare ddew a, kem naa te neenn njaa anji le tusu Piyar inyae. ");
INSERT INTO ksp_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Yeen ngaa Piyar gere rɔe ngaa pa na: «Bbasine m-gere ngaa. Tɔkɔrɔ njaa, Ebbe-dewje ula anji are ɔrum me ji Erɔde te ddem, me ne te ke maji ang ke Jiipije ndikije ta dda sem ddem.» ");
INSERT INTO ksp_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Toke n̂-gere gel ne le a, naw key le Mari kɔn Janji. Jan le daw n̂-bbare na Marke tɔ. Keteenn, nje-me-kunnje mbɔnje naa banya banya aw dujuje Lubba. ");
INSERT INTO ksp_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Toke piyar unda ta-ndoko a, mare nje-kula ke dene ke ria na Rode ddee mba koo. ");
INSERT INTO ksp_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","N̂-gere ndu Piyar le ngaa rɔe neele nya, a nɔru ta-ndoko le ang a n̂-tel ke ngɔru nande key ta kaw pa to Piyar a ar ta-ndoko teenn. ");
INSERT INTO ksp_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","N̂-paje dareje na: «Ayn wooy wa?» A Rode le tel pa bbay ang na: «Tɔkɔrɔ njaa nee teenn!» Dilaeje te na: «Yeenn a, anji laa ann.» ");
INSERT INTO ksp_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Piyar unda ta-ndoko bbay bbay ngaa kake n̂-ddeeje dɔruje ta-ndoko a, Piyar a ar neenn a, tar ikide sel. ");
INSERT INTO ksp_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","N̂-dda jia narede kare dewje rɔde ngaa nɔru gel ddew ke Ebbe-dewje ɔre ne me key-kula te. Ta kutu ne dɔ tar laa a, n̂-pa na: «Awje e-paje tar neenn areje Jake, ke kese nje-me-kunnje.» Goe te a, nɔtu ngaa nunn ddew naw ke mare lo te dang. ");
INSERT INTO ksp_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Lo are a, mbambaje le jɔkuje rɔde nya ngaa n̂-paje na ddi a inga Piyar wa? ");
INSERT INTO ksp_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Erɔde are daw n̂-sange, a dingae ang. N̂-nduju tar nje-ngemje ta Piyar le a, nunn ndu kare n̂-tɔlde. Goe te a, Piyar le in Jude aw Sejare. N̂-dda ndɔ ten keteenn. ");
INSERT INTO ksp_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erɔde ee ke tar ke dewje ke bbe te ke Tir ddem dewje ke bbe te ke Sidɔn ddem. Nje ke Tir ke nje ke Sidɔn le ooje ta naa ta ddee nɔe te. N̂-gɔlje tar ke Balasetusu ke to nje-ngem neje le tɔku mbayje dare noso gode te. N̂-ndikije kare ddekeke to horode te, mba ne-kusaje lede inje nange te le tɔku mbayje le bba aw ddee nange te lede. ");
INSERT INTO ksp_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ndɔe ke dɔju le ase a, Erɔde ula kubbu tɔku-mbay laa aw isi ngende-mbay te laa ngaa pa tar arede kem dewje te tɔyn. ");
INSERT INTO ksp_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Dewje uruje ekii na: «Tar ke ta Lubba te a neenn bbo tar ke ta dew te ang.» ");
INSERT INTO ksp_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","A kare teenn njaa, anji le Ebbe-dewje unda Erɔde, mba nare dewje ɔsu gaje turu Lubba te. Yeenn, a koreje ɔenje ngaa noy. ");
INSERT INTO ksp_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","A tar le Lubba nja ke kete kete ngaa aw taa lo. ");
INSERT INTO ksp_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Toke Barnabase de ke Sɔl n̂-tungaje kula lede Jurusalam ngaa daw n̂-telje a, dawje ke Jan ke daw n̂-bbare na Marke. ");
INSERT INTO ksp_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Nje-kilaje mber-tar le Lubba, ke nje-ne-tɔjuje eeje me Egilisi te ke Antiyose. Ride na: Barnabase, Simeyɔn ke daw n̂-bbare na Dew-ndul, Lusiyusu ke to dew ke bbe te ke Sirene, Manayen ke de ke Erɔde ke ɔn bbe ke Galile n̂-tɔkuje naa te, ke Sɔl. ");
INSERT INTO ksp_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Mare ndɔ n̂-mbɔnje naa mba polo Ebbe-dewje ngaa n̂-mbeteje ne-kusa a, Ndil-me-nda pa na: «Undaje Barnabase de ke Sɔl dang mba kula ke m-bbarde mbae.» ");
INSERT INTO ksp_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Yeenn a, goe te ke n̂-mbeteje ne-kusa, ngaa n̂-dujuje Lubba a, dilaje jide dɔde te ngaa dinyade dare dɔtuje. ");
INSERT INTO ksp_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ndil-me-nda ula Barnabase de ke Sɔl are daw dawje ke bbe te ke Selisi, ngaa dunnje to keteenn ta kaw er ke dɔ dere-maann te ke Sipere. ");
INSERT INTO ksp_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Toke n̂-teeje bbe te ke Salamine a, n̂-paje tar le Lubba dare dewje me key mbɔn̂-naa te le Jiipije. Jan̂-Marke ee teenn mba kumade. ");
INSERT INTO ksp_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Goe te ke n̂-tɔyje dɔ-dere maann te le tɔyn ngaa n̂-teeje bbe te ke Papose a, dingaje mare Jiipi ke to nje-kuma ke to nje-kila mber-tar ngem. Ria na Bar-Jeju. ");
INSERT INTO ksp_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","N̂-to dew ke ee mbɔr Sergiyusu Polusu te ke to nje-kɔn nange le. Sergiyusu Polusu le to dew ke gere ne nya, nula n̂-bbar Barnabase de ke Sɔl, mba bbo koo tar le Lubba ddae. ");
INSERT INTO ksp_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","A Elimase (Daw n̂-bbar nje-kuma ke ndɔn tar le gerekeje to Elimase) ndiki ta kɔku ddew Barnabase de ke Sɔl le, ngaa n̂-dda tɔyn kare nje-kɔn̂-bbe le oo mee te ang. ");
INSERT INTO ksp_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Yeenn a, Ndil-me-nda ddusu Sɔl ke daw n̂-bbare na Pɔl tɔ ngaa aa Elimase le, ");
INSERT INTO ksp_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ngaa pa nare na: «Ei, nje-ngem, nje-kula dewje naa te, ngonn le Esu, ei ke e-ndiki ne ke gate gate ang, ndɔ ke dda bba a kunda gange turu ddew neje ke ndɔju ke Ebbe-dewje mɔse wa? ");
INSERT INTO ksp_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Bbasine neenn njaa Ebbe-dewje a kundai, kemi a tɔ. A koo lo ang ngaa mba mare kare.» Kare teenn njaa keme il biriri, lo ndul dɔe te, nila ke lo kara baa naw n̂-sange dew kare ila kake jia te. ");
INSERT INTO ksp_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Toke nje-kɔn̂-nange le oo nejeenn baann a, oo mee te ke Lubba mba ne-tɔje ke dɔ Ebbe-dewje te le gange singae. ");
INSERT INTO ksp_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pɔl de ke nje-buwa-njaje laa dunnje to bbe te ke Papose ngaa n̂-teeje bbe te ke Perje dɔ nange te ke Pampili. A Jan tusude inyade keteenn tel bbe te ke Jurusalam. ");
INSERT INTO ksp_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pɔl de ke nje-buwa-njaje laa le dinje bbe te Perje le dawje bbe te ke Antiyose dɔ nange Pisidi te. Mare ndɔ-kuwa-rɔ le Jiipije daw dandeje key-mbɔn̂-naa te le Jiipije ngaa disije nangê. ");
INSERT INTO ksp_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Goe te ke n̂-tura maketuru me maketuru ndu te, ke me maketuru te le nje-kilaje mber-tar le Lubba a, nje-kɔnje dɔ key-mbɔn̂-naa le Jiipije le are n̂-pa darede na: «Ngakɔnjeje, bbo eeje ke mare tar ta pa kare dewje neenn kare arede singa a, e-paje.» ");
INSERT INTO ksp_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pɔl in taar, dda jia arede ngaa pa na: «See ngann Ijarayelje, ke esee dewje ke aw bbeelje Lubba, ooje tar neenn. ");
INSERT INTO ksp_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Lubba le dewje ke Ijarayelje mbere kajeje ngaa dda are gelde banya bbalje te ke disije ne nange te ke Ejipite. Goe te a, n̂-tee ke de ke ddang nange te ke Ejipite te le ddew singa mɔngu te laa. ");
INSERT INTO ksp_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","N̂-gemde ngɔsi ke bbal dɔsɔ me kɔr te ");
INSERT INTO ksp_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Goe te ke n̂-tɔl gel dewje siri nange te ke Kanaa a, nare nange le gel dewjeenn le ddee to le kajeje. ");
INSERT INTO ksp_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Go nejeenn tɔyn ew ase ne ke bbal kɔr sɔ ke dɔmi. Goe te a, nare nje-gangeje sariya ddeeje to tɔku-mbay dɔ kajeje te ndereng tee ndɔ te le Samuwel ke to nje-kila mber-tar le Lubba. ");
INSERT INTO ksp_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Goe te a, kajeje le dujuje kare Lubba unda mare tɔku mbayje dɔde ngaa Lubba arede Sawul ke to ngonn le Kise, dew ke gel Benjamen te. Sawul le ɔn bbe bbal dɔsɔ. ");
INSERT INTO ksp_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","« Goe te ke Lubba ɔru tɔku-mbay dɔ Sawul te a, nare Dabbiti ddee to tɔku-mbay lede. Lubba pa tar le Dabbiti le na: ‹Minga Dabbiti ngonn le Jese. N̂-to dew ke mem ndike. Ne a na dda neje tɔyn ke mem ndiki.› ");
INSERT INTO ksp_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Nje ke gel Dabbiti te a uju Jeju ke to Nje-kaji dewje ke Ijarayel ddew kara baa ke ndu ke Lubba unn. ");
INSERT INTO ksp_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kete bba kare Jeju unn kutu kula laa a, Jan̂-Batise ila mber-tar batem turu ddew are ngann Ijarayelje tɔyn. ");
INSERT INTO ksp_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kare ke kula le Jan̂-Batise a ta kunda ngange a, naw n̂-pa na: ‹Ejeje to m-to na wa? M-to dew ke aw e-ngebbeje le ang. Ooje, mare dew ke mase tutu kula endaar ne-gɔl laa ang aw ddee gɔm teenn.› ");
INSERT INTO ksp_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ngakɔmje, sese ke gel Abaraham te, ke esee keseje ke aw e-bbeelje Lubba, maji kare e-gereje to Lubba ula ke tar kaji neenn wɔju dɔje. ");
INSERT INTO ksp_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nje ke bbe te ke Jurusalam, ke tɔku-mbayje lede gereje Jeju ang. N̂-gereje me tar ke nje-kilaje mber-tar le Lubba paje ngaa daw n̂-turaje tare ke ndɔ kuwa-rɔ kara kara tɔyn le ang. N̂-ddaje ne ke nje-kilaje mber-tar paje le. Yeenn a, n̂-gangeje sariya yo dɔ Jeju te. ");
INSERT INTO ksp_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Dingaje mare ne mba kunda ne tar dɔe te kare n̂-tɔle ang ngaa n̂-dujuje Pilate kare are n̂-tɔle. ");
INSERT INTO ksp_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","N̂-ddaje ne tɔyn ddew kara baa ke tar ke n̂-pa dɔe te me maketuru te ngaa dɔru ninne kake-dese te dila me buwa-yo te. ");
INSERT INTO ksp_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","A Lubba are nin horo nje-yoje te, ");
INSERT INTO ksp_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ngaa n̂-tɔju rɔe ndɔ banya nare dewje ke inje saa nange te ke Galile danneje ndereng bbe te ke Jurusalam. Dede le ngaa bbasine n̂-ddeeje to nje-tar-najije laa nɔ dewje te ke Ijarayel. ");
INSERT INTO ksp_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Jeje kara, jila mber-tar neenn jarese tɔ. Tar ke maji ke Lubba unn ndue wɔju dɔe are kajeje le, ");
INSERT INTO ksp_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Lubba dda are Tar ke maji le ddee to ne ke tɔkɔrɔ horoje jee ngannde te ddew kin te ke nare Jeju in horo nje-yoje te, ddew kara baa toke n̂-dda tare me maketuru te le Sɔm 2 na: ‹E-to ngonnum, ema a muji bbokone.› ");
INSERT INTO ksp_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","«Lubba are nin horo nje-yoje te mba kare da-rɔe tel aw ndum buwa te ang ngaa. Mba ne njaa n̂-pa na: ‹Ma karese neje ke tɔkɔrɔ ke munn ndum ta kare Dabbiti.› ");
INSERT INTO ksp_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Mba yeenn a, n̂-pa tare me maketuru te le Lubba tɔ na: ‹A kinya da-rɔ dew lei ke gate gate kare tuju ang.› ");
INSERT INTO ksp_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","«A goe te ke Dabbiti le dda kula ke me Lubba ndiki dɔ ndɔ te laa tɔyn tunga a, noy, n̂-dubbe mbɔr kaejedede te ngaa da-rɔe tuju. ");
INSERT INTO ksp_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","A da-rɔ Jeju tuju me buwa-yo te ang, Lubba are nin horo nje-yoje te. ");
INSERT INTO ksp_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Yeenn a, ngakɔmje, maji kare e-gereje to ddew te le Jeju le bba daw n̂-pa darese to Lubba a kɔru tar majang lese. Ndu le Moyije ase dda kare dew ddee gate gate kem Lubba te ang. ");
INSERT INTO ksp_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Are, ddew te le Jeju bba dew ke oo mee te saa a, a ddee to dew ke gate gate. ");
INSERT INTO ksp_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Yeenn a, aaje rɔse mba ne ke n̂-dda tare me maketuru le nje-kilaje mber-tar le Lubba neenn a ddase. Tare le na: ");
INSERT INTO ksp_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‹Ooje! See nje-dabbe dewje, areje bbeel ddase bbo e-gotoje ke ddang, mba ma dda mare ne ndɔ ke isije ne kem baa, bbo dew ɔru gel ne le arese a, a ndikije te ang.›» ");
INSERT INTO ksp_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Kare te ke Pɔl de ke Barnabase daw n̂-teeje ke ddaka a, dewje le dujujede kare ndɔ-kuwa-rɔ ke guku a, n̂-telje dɔ tar teenn le bbay. ");
INSERT INTO ksp_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Toke dewje ke mbɔnje naa le sarenje naa a, mare Jiipije nya, ke dewje ke toje to Jiipije ang ke aw poloje Lubba unnje go Pɔl de ke Barnabase. Pɔl de ke Barnabase n̂-paje tar darede ngaa n̂-ndejede kare n̂-naynje ke ndɔ tɔyn ddew me-maji te ke Lubba dda ke de. ");
INSERT INTO ksp_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ndɔ-kuwa-rɔ le Jiipije ke goe te a, dewje ke me bbe te ke Antiyose ke to nange te ke Pisidi le mbɔnje naa banya banya mba koo tar le Ebbe-dewje. ");
INSERT INTO ksp_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Toke Jiipije ooje dewje ke banya banya le a, me ddade. N̂-paje tar ke tila kem tar le Pɔl ngaa n̂-tajeje. ");
INSERT INTO ksp_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pɔl de ke Barnabase n̂-paje tar ke bbeel ang darede na: ‹‹Sese a, a toje to dɔngɔr dewje ke jaa pa tar le Lubba neenn karese. A, e-mbeteje tar le ngaa sese njaa e-telje ooje rɔse to dewje ke aseje ta kinga tebbe ke ke ndɔ ke ndɔ ang. Yeenn a, n̂-turu kemje ke rɔ dewje te ke toje to Jiipije ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Mba, ndu ke jinga ta Ebbe-dewje te njaa na: ‹Mundai kare e-ndoko horo kese gel-dewje te, kare ta aw ke tar kaji neenn kɔyn nange te tɔyn.› ›› ");
INSERT INTO ksp_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Toke dewje ke toje to Jiipije ang ooje tar le a, rɔde neelde nya ngaa dɔsuje gaji tar le Ebbe-dewje. Dewje ke Lubba mberede kare dingaje kaji ke ke ndɔ ke ndɔ ddeeje to nje-me-kunnje. ");
INSERT INTO ksp_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Tar le Ebbe-dewje taa dɔ nange ke Pisidi le tɔyn. ");
INSERT INTO ksp_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","A Jiipije ɔsuje kutu deneje ke isije lo te ke bo ngaa aw bbeelje Lubba ddem, ɔsuje kutu nje-kɔn̂-bbeje ddem are dinje n̂-ddaje Pɔl de ke Barnabase maji ang ngaa n̂-tubbade dɔ nange te lede le. ");
INSERT INTO ksp_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pɔl de ke Barnabase le tundaje bum ke gɔlde arede, ngaa dawje bbe te ke Ikɔniyɔm. ");
INSERT INTO ksp_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","A nje-njaje go Ebbe-dewje te ke naynje bbe te ke Antiyose eeje ke koko nya ddem, Ndil-me-nda ddusude ddem. ");
INSERT INTO ksp_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pɔl de ke Barnabase n̂-teeje me bbe te ke Ikoniyɔm a, dandeje me key-mbɔn̂-naa te le Jiipije. N̂-tɔjuje tar are Jiipije, ke dewje nya ke toje to Jiipije ang ooje mede te. ");
INSERT INTO ksp_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","A Jiipije ke mbeteje ta koo mede te le aw tulaje dewje ke toje to Jiipije ang kare dejeje keje ke maji ang dɔ Pɔl de ke Barnabase te. ");
INSERT INTO ksp_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Dɔ neje teenn tɔyn, Pɔl de ke Barnabase n̂-naynje bbe te ke Ikoniyɔm le gode ew. N̂-paje tar le Ebbe-dewje ke bbeel ang. Ebbe-dewje le tɔju to tar me-maji laa le to ne ke tɔkɔrɔ ddew ne-mɔrije te, ke neje te ke dum dɔ koo ke nare n̂-ddaje. ");
INSERT INTO ksp_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Dewje ke me bbe te le kaynje horo naa joo. Mareje unnje go Jiipije, a mareje unnje go nje-kayn-kulaje le. ");
INSERT INTO ksp_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Jiipije ke tɔku-mbayje lede ddem, dewje ke toje to Jiipije ang ddem, n̂-ndikije ta dda Pɔl de ke Barnabase maji ang ddem, ta tilade ke er tɔlde ddem. ");
INSERT INTO ksp_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Toke Pɔl de ke Barnabase dooje tare a, daw diyaje rɔde me bbeje te ke Likawoni, Listere, ke Derbe, ke loje te ke mbɔr bbeje teenn. ");
INSERT INTO ksp_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Loje teenn, n̂-tɔjuje Tar ke maji dewje tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Me bbe te ke Listere, mare dingaw ke duje to nje-gɔl-goto ke ase kar taar ang ddem ase nja ang ddem isi nangê. ");
INSERT INTO ksp_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mare ndɔ naw noo tar ke Pɔl aw pa. A Pɔl aae a, gere to koo me te laa ase dda kare rɔe ddee maji. ");
INSERT INTO ksp_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Pɔl le pa ke singa na: «In taar ar njarara dɔ gɔli te!» Dew le in taar bbate ngaa unn kutu nja. ");
INSERT INTO ksp_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Toke dewje ooje ne ke Pɔl dda le a, duruje ekii ke ndɔn tar Likawoni na: «Ooje, lubbaje ddaje rɔde to dewje ngaa teeje horoje te.» ");
INSERT INTO ksp_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","N̂-bbarje Barnabase to Juse ngaa n̂-bbarje Pɔl to Ermese, mba ne a naw n̂-pa tar. ");
INSERT INTO ksp_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Key-polo Juse le to ta bbe te le njaa. A nje-polo Juse le ddee ke ngann mangeje ke n̂-dda neje ke kura rɔde te ta bbe te le. Ne ke dewje ke banya banya n̂-ndikije ta kare to ne-polo nje-kayn-kulaje le. ");
INSERT INTO ksp_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Toke Pɔl de ke Barnabase dooje tar le a, n̂-tirje kubbuje ke rɔde te, dɔtuje ke ngɔru dawje ke rɔ dewje te ke banya banya le ngaa n̂-paje ke singa na: ");
INSERT INTO ksp_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Mbata ddi a e-ddaje ne toke be wa? Jeje kara n̂-to dewje toke lese tɔ. Jaw n̂-pa Tar ke maji jarese kare ta e-mbeteje ne ke ture goto ta aaje lo ke rɔ Lubba te ke isi kem baa. Lubba le a dda dara, ke nange, ke ba, ke neje tɔyn ke toje te. ");
INSERT INTO ksp_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Dɔ ndɔje te ke ndayje, Lubba inya ddew are gel dewje tɔyn ddaje ne ke mede ndiki. ");
INSERT INTO ksp_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","A n̂-tɔju me-maji laa ke ndɔ tɔyn ddew ndi te, ke kande ko te ke nare ande ke maje are ujaje. Narese ne-kusa asese ngaa nare isije ke koko.» ");
INSERT INTO ksp_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Dɔ tarje te neenn tɔyn bbo kare ne-polo Pɔl de ke Barnabase aw ddade bbay. ");
INSERT INTO ksp_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Jiipije ke inje bbe te ke Antiyose, ke bbe te ke Ikoniyɔm ddaje are dewje ke banya banya le unnje gode. N̂-tilaje Pɔl ke er ta tɔle ngaa n̂-ndɔreje n̂-teeje saa me bbe te ke ddang, mba dɔjuje to noy. ");
INSERT INTO ksp_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","A kare te ke nje-njaje go Ebbe-dewje te ddeeje gukuje dɔe a, nin taar n̂-tel nande me bbe te le. Lo are a, ne de ke Barnabase dawje bbe te ke Derbe. ");
INSERT INTO ksp_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pɔl de ke Barnabase n̂-tɔjuje Tar ke maji bbe te ke Derbe. Dewje nya ddeeje to nje-njaje go Ebbe-dewje te. Goe te a, n̂-telje ke ddew ke bbe te ke Listere, Ikoniyɔm ke Antiyose. ");
INSERT INTO ksp_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Me bbeje teenn, n̂-ndejeje nje-koo me teje kare mede enge ang ddem kare duwaje koo me te lede dare ngeng ddem. N̂-paje na: «Maji kare ne-wunguje dang dang ingaje bba ja kandeje me bbe-kɔn te le Lubba.» ");
INSERT INTO ksp_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Me Egilisije te tɔyn ke n̂-teeje te a, n̂-dda mare nje-koo-me teje to ansiyenje, n̂-mbeteje ne-kusa bba n̂-dujuje Lubba dɔde te ngaa dinyajede me ji Ebbe-dewje te ke dundaje koo me te lede dɔe te le. ");
INSERT INTO ksp_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pɔl de ke Barnabase le n̂-riyaje dɔ nange ke Pisidi dosoje dɔ nange te ke Pampili. ");
INSERT INTO ksp_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Toke n̂-tɔjuje tar le Lubba me bbe te ke Perje a, dawje bbe te ke Atali. ");
INSERT INTO ksp_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Keteenn, dunnje tɔku to mba tel bbe te ke Antiyose nange Siri te. Bbe te ke Antiyose le a nje-koo-meteje inyajede me ji Lubba te kete kare Lubba dda kede me-maji kare n̂-ddaje kula ke n̂-ddaje neenn. ");
INSERT INTO ksp_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Toke Pɔl de ke Barnabase n̂-teeje bbe te ke Antiyose nange Siri te a, n̂-mbɔnje nje-me-kunnje. Dɔruje gel neje tɔyn ke Lubba dda ddew te lede, ke ddew ke Lubba ɔru ne ddew are dewje ke toje to Jiipije ang ooje mede te tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pɔl de ke Barnabase le n̂-naynje rɔ nje-me-kunnje te ke bbe te ke Antiyose le gode ew ngaji. ");
INSERT INTO ksp_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Mare dewje inje dɔ nange Jude te ddeeje bbe te ke Antiyose dɔ nange Siri te. N̂-tɔju ne nje-koo-meteje ke Antiyose le na: «Toke ujaje mɔtuse ddew kara baa toke ndu le Moyije pa ang a, a kaseje ta kingaje kaji ang.» ");
INSERT INTO ksp_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pɔl de ke Barnabase n̂-mbeteje ne-tɔju lede ngaa n̂-maynje ke de tar. Yeenn a, nje-koo-meteje unnje ndu kare Pɔl de ke Barnabase, ke mare nje-koo-meteje dawje Jurusalam daw dingaje nje-kayn-kulaje, ke ansiyenje wɔju dɔ tar neenn le. ");
INSERT INTO ksp_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Egilisi ke bbe te ke Antiyose umade ke ne mba nja lede le. N̂-ndayje ke ddew ke Penesi, ke Samari ngaa n̂-paje tar le dewje ke toje to Jiipije ang ke ooje mede te le dare nje-bbeje le. Tar le are koko nje-me-kunnje tɔyn. ");
INSERT INTO ksp_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Toke n̂-teeje Jurusalam a, Egilisi, ke nje-kayn-kulaje, ke ansiyenje taajede ke rɔ-neel. Dɔruje gel neje tɔyn ke Lubba dda ddew te lede dare dewje ke Jurusalam. ");
INSERT INTO ksp_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Mare parijiyenje ke ooje mede te paje na: «Maji kare dewje ke toje to Jiipije ang are duja mɔtude ta n̂-njaje ke turu ndu le Moyije.» ");
INSERT INTO ksp_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nje-kayn-kulaje, ke ansiyenje mbɔnje naa ta kisa me tar le. ");
INSERT INTO ksp_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","N̂-maynje naa tar dare ngeng nya ngaa Piyar in taar pa na: «Ngakɔmje, e-gereje to Lubba bbarem horose te lew baa kare m-pa Tar ke maji mare dewje ke toje to Jiipije ang kare dooje tar le ngaa dooje mede te. ");
INSERT INTO ksp_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Lubba ke gere me dewje tɔju to n̂-taa dewje ke toje to Jiipije ang ke rɔe te. Yeenn a, narede Ndil-me-nda ddew kara baa toke nareje tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nɔru-kemde dang ke jeje ang. Lubba toko mede mba dooje mede te. ");
INSERT INTO ksp_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Baann mban a, mba ddi bba aw taje naa ke Lubba ngaa aw undaje ne-koto ke kajeje wase jeje njaa kara jaseje ta koto ang dɔ nje-njaje go Ebbe-dewje te wa? ");
INSERT INTO ksp_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","A, n̂-gereje tɔ bbay to ddew me-maji te le Ebbe-dewje Jeju a Lubba aji ne je ddew kara baa toke najide.» ");
INSERT INTO ksp_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Dewje tɔyn ke mbɔnje naa le isije ddekeke ngaa tukaje mbide ooje ne tar ke Barnabase de ke Pɔl daw n̂-paje wɔju dɔ ne-mɔrije, ke neje ke dumje dɔ koo ke Lubba dda ddew te lede horo dewje te ke toje to Jiipije ang le. ");
INSERT INTO ksp_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Dewje rɔde ta pa tar a, Jake pa na: «Ngakɔmje, ooje tar lem. ");
INSERT INTO ksp_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Bbasine bbay Simɔ ole meje dɔ ddew te ke Lubba mɔse kunn kutu ne te njaa ta mbere mare dewje horo gel-dewje te ke gere Lubba ang kare n̂-ddeeje to dewje laa. ");
INSERT INTO ksp_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Tar neenn le dda me-kara ke tar le nje-kilaje mber-tar le Lubba ke n̂-dda me maketuru te na: ");
INSERT INTO ksp_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‹Goe te a, ma tel ddee dda key le Dabbiti ke oso. Ma mɔse kese neje ke nayn, ngaa ma mɔse key le kunda taar. ");
INSERT INTO ksp_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Yeenn bba kese dewje a sangeje Ebbe-dewje, ddew kara baa toke gel-dewje tɔyn ke ri Ebbe-dewje to dɔde te. Tar ke Ebbe-dewje pa le ann. ");
INSERT INTO ksp_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","N̂-dda nare dewje gereje ne ke neje ta dda le lew baa.› ");
INSERT INTO ksp_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Mba yeenn a, keje te lem m-ndiki kare n̂-ddaje neje ke a jɔku dewje ke toje to Jiipije ang ke unnje go Lubba neenn ang. ");
INSERT INTO ksp_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","N-ddaje maketuru julaje ne jarede kare dusaje ne ke n̂-polo ne kɔr ang, mba to ne-yerew, n̂-ddaje lo-to majang ang, dɔnje da ke kewn ute bba oy ang, dusaje mese ang. ");
INSERT INTO ksp_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Mba lew baa njaa dewje aw ɔruje gel ndu le Moyiji me bbeje te kara kara ngaa ndɔ-kuwa-rɔ a, daw n̂-tura maketuru-ndu le key mbɔn naa te le Jiipije.» ");
INSERT INTO ksp_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Nje-kayn-kulaje, ansiyenje, ke dewje ke Egilisi te ooje maji ta mbere mare dewje horode te kare dawje ke Pɔl de ke Barnabase Antiyose. Dewje ke n̂-mberede le to Judase ke daw n̂-bbare na Barsabase, ke Silase. N̂-toje to dewje ke dewje bbeeljede. ");
INSERT INTO ksp_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Tar ke n̂-ddaje me maketuru te darede le toke be: «Jee nje-kayn-kulaje, ansiyenje, ke ngakɔnse n̂-dda lapiya ngakɔnjeje ke toje to Jiipije ang ke eeje Antiyose dɔ nange Siri, ke Silisi te. ");
INSERT INTO ksp_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Joo na mare dewje leje ke jarede ddew ang aw paje tar ke jɔkuse ngaa tuju keje lese. ");
INSERT INTO ksp_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Mba yeenn a, jeje tɔyn njaa junn nduje mba mbere mare dewje kulade turuje te kare n̂-dannje Barnabase de ke Pɔl ke n̂-ndikijede nya. ");
INSERT INTO ksp_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","N̂-toje to dewje ke ilaje rɔde kɔrɔ mba kula le Ebbe-dewje Jeju Kiriste. ");
INSERT INTO ksp_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Yeenn a, jula Jude de ke Silase jarese kare n̂-paje tar ke me maketuru te le ke tade darese. ");
INSERT INTO ksp_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ndil-me-nda ddem, jeje ddem, n̂-ndiki ta kunda mare ne-koto dang dɔ ne te ke to maji kare e-ddaje ang ngaa. Ne ke ta dda a neenn: ");
INSERT INTO ksp_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","usaje ne ke n̂-polo ne kɔr ang, usaje mese ang, ɔnje da ke kewn ute bba oy ang, e-ddaje lo-to majang ang. Bbo e-ngemje rɔse ddew neje teenn tɔyn a, to ne ke maji. N-ddase lapiya nya.» ");
INSERT INTO ksp_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Pɔl, Barnabase, Jude, ke Silase le ɔtuje awje Antiyose ngaa n̂-mbɔnje nje-koo-meteje darede maketuru le. ");
INSERT INTO ksp_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","N̂-turaje maketuru le a, deeje ke koko nya mba tar ke me maketuru te le arede singa. ");
INSERT INTO ksp_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Jude de ke Silase ke toje to nje-kilaje mber-tar le Lubba le paje tar nya arede kare dingaje ne singa. ");
INSERT INTO ksp_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","N̂-ddaje ndɔ ngaji a, nje-me-kunnje le inyajede ngaa dujuje kare n̂-telje ke me wul lɔm rɔ dewje te ke ulajede le. ");
INSERT INTO ksp_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","A, Silase oo maji ta nayn Antiyose. ");
INSERT INTO ksp_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pɔl de ke Barnabase n̂-naynje Antiyose tɔ ngaa mare dewje osoje dɔde te, n̂-tɔjuje ne ngaa n̂-paje Tar ke maji le Ebbe-dewje dare dewje. ");
INSERT INTO ksp_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Goe te ngaji a, Pɔl pa are Barnabase na: «N-telje me bbeje te kara kara ke n̂-paje tar le Ebbe-dewje te le, jaa nje-koo-meteje joo se disije toke baann wa?» ");
INSERT INTO ksp_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabase ndiki kare Jan ke daw n̂-bbare na Marke aw ke de tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","A Pɔl mbete, mba Jan le tusude inyade ta kula te Pampili. ");
INSERT INTO ksp_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Tar lede aw naa te ang ngaa na na kara unn ddew laa. Barnabase ila Jan Marke goe te ngaa dunnje to dawje Sipere. ");
INSERT INTO ksp_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","A Pɔl unn Silase ilae goe te. Goe te a, nje-koo-meteje ilaje Pɔl ji Ebbe-dewje te kare dda saa me-maji ngaa nɔtu. ");
INSERT INTO ksp_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pɔl nday nange te ke Siri, ke Silisi, n̂-ndeje dewje ke Egilisije te kare duwaje dare ngeng. ");
INSERT INTO ksp_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pɔl tee bbe te ke Derbe, ke Listere. Mare nje-nja go Jeju te ke ria na Timote ee me bbe teenn le. Kɔenje to Jiipi ngaa oo mee te, a bɔeje to Gereke. ");
INSERT INTO ksp_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Nje-koo-meteje ke Listere, ke Ikoniyɔm paje tar le Timote le maji nya. ");
INSERT INTO ksp_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pɔl ndiki ta kaw saa. Yeenn a, nuja ganja wɔju dɔ Jiipije ke isije loje teenn le, mba n̂-gereje tɔyn to bɔ Timoteje to Gereke. ");
INSERT INTO ksp_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Me bbeje te ke Pɔl de ke Silase n̂-teeje te a, n̂-ndajije nduje ke nje-kayn-kulaje, ke ansiyenje ke Jurusalam unnje le dare dewje. N̂-walde nya kare n̂-ddaje ne ke turu nduje le. ");
INSERT INTO ksp_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Egilisije aw sangeje ddew me-kunn te ngaa ke ndɔ kara kara kɔr nje-koo-meteje aw ke kete kete. ");
INSERT INTO ksp_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pɔl de ke Silase n̂-ndayje nangeje te ke Piriji, ke Galati, mba Ndil-me-nda ɔkude ddew kare n̂-tɔjuje tar le Lubba nange te ke Aji. ");
INSERT INTO ksp_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Toke n̂-teeje ngange nange te ke Miji a, n̂-sangeje ddew ta tee nange te ke Bitini, a Ndil le Jeju ɔkude ddew. ");
INSERT INTO ksp_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","N̂-ndayje nange te ke Miji ngaa n̂-teeje bbe te ke Torowase. ");
INSERT INTO ksp_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Pɔl oo mare ne toke le nijeenn mare til te. Noo mare dew ke Masedowann ke ar taar aw duje na: «E-ddee nange te ke Masedowann umaje!» ");
INSERT INTO ksp_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Go ne te ke Pɔl oo toke mare le ni le a, kare teenn njaa n̂-sange ddew ta kaw Masedowann le mba n̂-gere to Lubba bbarje kare jaw n̂-pa Tar ke maji Masedowann le. ");
INSERT INTO ksp_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Toke junn to Torowase a, jaw njarara dɔ dere te ke Samotarase. Ndɔ kara goe te a, n̂-tee bbe te ke Neyapolise. ");
INSERT INTO ksp_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Jin teenn n̂-tee bbe te ke Pilipi ke to tɔku bbe ke Masedowann ke dewje ke Rɔm a ɔnje dɔe. N-dda ndɔ ngaji Pilipi le. ");
INSERT INTO ksp_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ke mare ndɔ-kuwa-rɔ le Jiipije, n̂-tee me bbe te le jaw kare maann te mba jeje to lo-duju Lubba le Jiipije a to keteenn. Jisi nangê ngaa n̂-pa tar jare deneje ke mbɔnje naa lo teenn le. ");
INSERT INTO ksp_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mare dene le kara to dew ke bbe te ke Tiyatir, ria na Lidi. N̂-to nje-labbe kubbu ke kase ke nare ngeng ngaa naw n̂-bbeel Lubba. Noo tarje ke jaw n̂-pa ngaa Ebbe-dewje unda mee are n̂-tuka mbia noo ne tarje ke Pɔl aw pa. ");
INSERT INTO ksp_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Toke Lidi le de ke nje ke key laa dingaje batem a, n̂-bbarje ngaa n̂-pa nareje na: «Bbo ooje to moo mem te tɔkɔrɔ ke Ebbe-dewje njaa a, e-ddeeje e-toje key lem.» Numa keje nya kare n̂-ndiki bbar ke n̂-bbarje le. ");
INSERT INTO ksp_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Mare ndɔ jaw ke lo-duju Lubba te a, mare ngonn mande ke to nje-kula le mare dew tee ingaje. Ndil ne-ndɔn isi dɔ ngonn mande te le. Ne-ndɔn laa le dda are ebbejedede ingaje ne ne nya. ");
INSERT INTO ksp_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nunn goje ngaa naw nuru ekii na: «Dewje neenn toje to nje-kulaje le Lubba ke isi ddutu dara te. Daw n̂-tɔjujese ddew kinga kaji.» ");
INSERT INTO ksp_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","N̂-tel dɔ tar teenn le ndɔ banya nya. Ase ang boy a, Pɔl turu rɔe ngaa pa are ndil le na: «Ke ri Jeju Kiriste, munn ndu mari kare e-tee me ngonn ke dene te neenn ke ddang!» Kare teenn njaa ndil le unda lo tee. ");
INSERT INTO ksp_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Toke ebbejedede ooje to ne-kinga nare lede le goto ngaa a, duwaje Pɔl de ke Silase dawje ke de nata nɔ nje-kɔn̂-bbeje te. ");
INSERT INTO ksp_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Dawje ke de nɔ nje-gangeje sariya te ke toje to dewje ke Rɔm ngaa, n̂-paje na: «Dewje neenn ilaje tar me bbe te leje. N̂-toje to Jiipije. ");
INSERT INTO ksp_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Daw n̂-tɔjuje ne-ji bbe ke jeje ke n̂-to ngann nje-bbeje ke Rɔm jee ke ddew ta ndiki te ang ddem ta n̂-nja goe te ang ddem.» ");
INSERT INTO ksp_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Dewje ke banya banya inje uruje dɔ Pɔl de ke Silase te ngaa nje-gangeje sariya le are n̂-tɔru kubbu le Pɔl de ke Silase. Dunnje ndu dare n̂-tundade ke ndey. ");
INSERT INTO ksp_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Goe te ke n̂-tundade nya a, dare dilade key-kula te ngaa dunnje ndu dare nje-ngemje ta key kula kare ngemjede ke maje. ");
INSERT INTO ksp_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Toke nje-ngemje ta key kula le inga ndu ke darede le a, dilaje Pɔl de ke Silase le suran key-kula te ngaa dilade poro. ");
INSERT INTO ksp_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Lo mɔngu nyenene a, Pɔl de ke Silase daw n̂-dujuje Lubba ngaa daw dɔsuje pa n̂-walje ne Lubba ngaa kese dewje ke duwade le aw ooje ndude. ");
INSERT INTO ksp_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","A ta koo a, nange yeke ke singa are gɔl-key-kula ke dungu nangê le yeke. Kare teenn njaa ta keyje tɔyn teynje ngaa kula njamjije ke n̂-tɔ ne dewje tɔyn ke duwade le tɔruje. ");
INSERT INTO ksp_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nje-ngem ta key kula le ndol a, oo ta keyje ke toje take baa le. Noo to dewje ke duwade le aynje ngaa nunn tɔku kiya laa ta tɔl ne rɔe. ");
INSERT INTO ksp_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","A Pɔl uru ekii ke singa na: «E-tɔl rɔi ang, jee neenn tɔyn.» ");
INSERT INTO ksp_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nje-ngem ta key kula le duju puru ta koo ne lo ngaa ande me key-kula te le ke tɔke. Noso kɔ gɔl Pɔl de ke Silase te naw nisa. ");
INSERT INTO ksp_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Goe te a, nje-ngem ta key-kula le are Pɔl de ke Silase n̂-teeje ddaka ngaa dujude na: «Ebbemjedede ddi a ma dda bba ma kinga kaji wa?» ");
INSERT INTO ksp_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","N̂-paje dare na: «Oo mei te ke Ebbe-dewje Jeju a, a kinga kaji, ei ddem nje ke key lei ddem.» ");
INSERT INTO ksp_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Pɔl de ke Silase le n̂-paje tar le Ebbe-dewje dare nje-ngem ta key kula le ddem dare dewje tɔyn ke eeje me key te laa ddem. ");
INSERT INTO ksp_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Me til teenn njaa, nje-ngem ta key kula le aw ke de aw toko doje lede. Ngaji goe te a, n̂-ddaeje batem ke nje ke key laa. ");
INSERT INTO ksp_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Goe te a, naw ke Pɔl de ke Silase key laa. Narede ne-kusa ngaa n̂-dda rɔ-neel ke nje-nujuje laa mba noo mee te ke Lubba. ");
INSERT INTO ksp_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Lo are a, tɔku nje-gangeje sariya ulaje pajaje lede rɔ nje-ngem ta key kula te le na: «Inya dewje neenn are ɔtuje!» ");
INSERT INTO ksp_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Nje-ngem ta key-kula le ndaji tar le are Pɔl na: «Nje-gangeje sariya ulajeje kare minyase. Yeenn a, e-teeje ta awje ke lapiya.» ");
INSERT INTO ksp_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","A Pɔl pa arede na: «N̂-gange sariya dɔje te ang a, n̂-tundaje kem dewje ngaa dilaje key kula te jeje ke n̂-to ngann nje-bbeje ke Rɔm tɔ. A bbasine, n̂-ndikije ta kɔruje lo kiyae te wa? Baann ang, maji kare dede njaa n̂-ddeeje dɔrujeje.» ");
INSERT INTO ksp_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Pajaje le aw ndajije tar le are nje-gangeje sariya le. Bbeel ddade mba dooje na Pɔl de ke Silase n̂-toje to ngann nje-bbeje ke Rɔm. ");
INSERT INTO ksp_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Yeenn a, nje-gangeje sariya le ddeeje uwaje gɔl Pɔl de ke Silase. Goe te a, dɔrude key kula te ngaa n̂-paje darede ta kare dɔtuje me bbe te le. ");
INSERT INTO ksp_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Toke Pɔl de ke Silase n̂-teeje key kula te le a, daw dingaje Lidi, dooje nje-koo-meteje, n̂-ndejedeje ngaa dɔtuje. ");
INSERT INTO ksp_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pɔl de ke Silase n̂-ndayje ke ddew ke bbe te ke Ampipolise, ke Apoloni, ngaa n̂-teeje bbe te ke Tesalonike, lo ke mare key-mbɔn̂-naa le Jiipije to te. ");
INSERT INTO ksp_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pɔl aw rɔ Jiipije te toke naw n̂-dda ke ndɔ tɔyn. N̂-mayn tar ke de dɔ maketuru te le Lubba me ndɔ-kuwa-rɔ te muta. ");
INSERT INTO ksp_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Nɔru gele narede ngaa n̂-tɔjude to maketuru le Lubba pa na Mesi a koo ndoo, ngaa na kin horo nje-yojeje te. N̂-pa na: «Jeju ke maw m-pa tar laa marese neenn le to Mesi le.» ");
INSERT INTO ksp_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Mare Jiipije le ndikije tar te le ngaa unnje go Pɔl de ke Silase. Gerekeje nya ke aw poloje Lubba, ke mare deneje ke isije lo te ke bo ddaje toke baann tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","A Jiipije ke me ddade mbɔnje dewje ke toje to nje-dɔ-gotoje ke aw njaje go ddew te baa, dɔsuje kutu dewje ke banya ngaa n̂-yekeje lo dare ddekeke goto me bbe te. ");
INSERT INTO ksp_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Toke dingaje Pɔl de ke Silase le ang a, duwa Jasɔn ke mare nje-koo-meteje daw ke de nɔ nje-kɔn̂-bbeje te ngaa n̂-paje ke taar na: «Dewje neenn tujuje lo tɔyn, a bbasine n̂-teeje neenn ngaa. ");
INSERT INTO ksp_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jasɔn a ngemde rɔe te. Ne ke ndu le tɔku-mbay Sejar mbete a dewje neenn le tɔyn aw ddaje. N̂-paje na mare tɔku-mbay ke dang to, ria na Jeju.» ");
INSERT INTO ksp_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Tarje neenn le oso wur dewje ke banya banya ddem nje-kɔn̂-bbeje ddem. ");
INSERT INTO ksp_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Duwaje Jasɔn, ke nje-koo-meteje le dare ukaje tɔku nare bba dinyade. ");
INSERT INTO ksp_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Toke lo ndul a, nje-koo-meteje are Pɔl de ke Silase dawje bbe te ke Bere. N̂-teeje a, dawje key-mbɔn̂-naa te le Jiipije. ");
INSERT INTO ksp_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Keje le Jiipije ke Bere maji uta keje le nje ke Tesalonike are n̂-taaje tar lede le ke ngɔru baa. Ndɔ kara kara daw disaje me maketuru le Lubba ta gere se tar ke Pɔl aw pa le to ke dɔgɔle njaa wa? ");
INSERT INTO ksp_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Dewje nya horode te ooje mede te. Dene Gerekeje ke toje to dewje ke bo, ke mare dingawje nya ooje mede te tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Toke Jiipije ke Tesalonike ooje na Pɔl aw tɔju tar le Lubba Bere tɔ a, n̂-ddeeje ta yeke lo ngaa ta kɔsu kutu dewje ke banya banya le. ");
INSERT INTO ksp_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Njange njange baa a nje-koo-meteje are Pɔl unn ddew er ke ta tɔku ba te, a Silase de ke Timote n̂-naynje teenn. ");
INSERT INTO ksp_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Dewje ke dannje Pɔl le awje ndereng teeje Atenn bba telje. Kare telde a, Pɔl ulade kare Silase de ke Timote dawje njange dingaeje Atenn le. ");
INSERT INTO ksp_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Wur Pɔl a ta ti kare te ke naw n̂-gebbe ne Silase de ke Timote mba kɔrje ddusu me bbe ke Atenn le. ");
INSERT INTO ksp_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Naw n̂-pa tar ke Jiipije, ke dewje ke aw poloje Lubba me key-mbɔn̂-naa te le Jiipije. A kese ndɔje a, naw n̂-pa tar nata ke kese dewje ke naw ningade ke ndɔ tɔyn. ");
INSERT INTO ksp_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Mare nje-ne-gereje ke daw n̂-bbarde na Epikuriyenje, ke Isitiyisiyenje njaa kara ddeeje aw paje saa tar tɔ. Mareje paje na: «Tar ddi njaa nje-kunda bula neenn ndiki ta pa wa?» A mareje paje na: «A du ang na to mare nje-kila-mber tar le mare lubbaje ke dang.» Mba Pɔl aw tɔju tar le Jeju te, ke le nje-yoje te ke a kinje. ");
INSERT INTO ksp_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Duwaje Pɔl dawje saa Ayeropaje* ngaa n̂-dujeje na: «Ja kase gere ne-tɔju ke siki ke aw tɔju neenn wa? ");
INSERT INTO ksp_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Mba tar ke joo kete ang a aw pa neenn are n̂-ndiki ta gere gele.» ");
INSERT INTO ksp_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Nje-bbeje, ke nje-mbaje ke Atenn ndikije nya ta pa tar ne ke siki wase ta koo ne ke siki ke tee bbe te. ");
INSERT INTO ksp_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Yeenn a, Pɔl ar taar dann dewje te ke Ayeropaje le ngaa pa na: «Dewje ke Atenn, moose a, e-toje to dewje ke eeje ke bbo nya ta polo lubbaje. ");
INSERT INTO ksp_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mba m-nja me bbe te lese a, moo lubbaje ke aw polojede. A m-tee dɔ mare baann te ke n̂-dda maketruru te na: ‹Bann le mare lubba ke n̂-gere ang.› Maji, ne ke aw poloje a e-gereje ang le a m-ddee maw mila mbere marese neenn. ");
INSERT INTO ksp_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Lubba ke nje-dda dara, ke nange, ke neje tɔyn ke toje te, ne ke n̂-to nje-dara, ke nange le n̂-to key-polo-lubbaje te ke dew dda ke jia ang. ");
INSERT INTO ksp_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","N̂-ndiki ta kare dew are ne mba kumae ne toke le dew ke aw ndiki mare ne ji dew te ang, ne a nare dewje tebbe, kewn, ke kese neje. ");
INSERT INTO ksp_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Dew kara baa njaa n̂-dda ne dewje tɔyn nare disije dɔ nange te tɔyn. Nɔju ngange nange lede kara kara kare disije te ngaa nɔju dɔ kare neje narede. ");
INSERT INTO ksp_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","N̂-ddaa baann bba kare dewje sangaeje. Toke n̂-mamje lo a, a du ang da kaseje ta kingaeje. A bbo ta koo a, jeje kara kara tɔyn Lubba ee ke je ngɔsi baa. ");
INSERT INTO ksp_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Mba ddew te laa bba n̂-to ne, jisi ke tebbe, jaw yeke rɔje. To ddew kara baa ke tar ke nje-paje lese paje na: ‹N-to ngann le Lubba›. ");
INSERT INTO ksp_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","‹‹Tɔkɔrɔ njaa n̂-toje to ngann le Lubba. Yeenn a, ja kaseje ta keje to Lubba unda rɔ kɔr ke n̂-dda ke ande, wase nare, wase er, wase mare ne ke dew tɔl ke gusu laa wase eje to keje bba dda toke baann wa? ");
INSERT INTO ksp_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","A kare ke dewje gereje tar ke tɔkɔrɔ ang bbay, Lubba oo to ne ang. A bbasine naw n̂-bbar dewje tɔyn ke isije loje te tɔyn kare n̂-turu ddew lede. ");
INSERT INTO ksp_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Mba nɔju ndɔ ke na kare n̂-mbere gange sariya ke gate gate dɔ dewje te tɔyn. Nare dew le in horo nje-yoje te ta tɔju kare dewje tɔyn to ne njaa n̂-mbere.›› ");
INSERT INTO ksp_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Toke dooje tar kin le nje-yoje ke Pɔl pa a, mareje kokoje ne. A mareje paje na: «Mare ndɔ bba ja koo tar lei dɔ tar te neenn bbay.» ");
INSERT INTO ksp_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Go tar teenn le a, Pɔl inyade. ");
INSERT INTO ksp_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Dɔe teenn njaa kara mareje naynje saa ngaa ooje mede te. Denisi ke to dew ke Ayeropaje, mare dene ke ria na Damarisi, ke mare dewje bbay eeje horode te. ");
INSERT INTO ksp_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Goe neje teenn a, Pɔl ɔtu bbe te ke Atenn aw Korente. ");
INSERT INTO ksp_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ninga mare Jiipi ke ria na Akilase keteenn. Duje nange te ke Pɔn. Akilase le de ke dene laa Pirisil dinje bbe te ke Itali bba n̂-ddeeje, mba Tɔku mbayje Kolode unn ndu kare Jiipije tɔyn ɔtuje me bbe te ke Rɔm. Pɔl aw rɔ Akilas de ke Pirisil te le. ");
INSERT INTO ksp_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","A kula lede, ke kula le Pɔl ke aw dda to kara baa. Kula le to kula dda tande. Yeenn a, Pɔl le nayn rɔde te are daw n̂-ddaje kula le. ");
INSERT INTO ksp_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ke ndɔ-kuwa-rɔ kara kara tɔyn Pɔl aw pa tar nya key-mbɔn̂-naa te lede ke dewje ke toje to Jiipije ddem nje ke toje to Jiipije ang ddem kare n̂-ndikije tar te laa. ");
INSERT INTO ksp_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Toke Silase de ke Timote dinje bbe te ke Masedowann n̂-teeje a, Pɔl unn rɔe tɔyn mba tɔju tar le Lubba. N̂-tɔju Jiipije to Jeju le njaa to Mesi. ");
INSERT INTO ksp_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","A Jiipije mbeteje tar laa ngaa daw n̂-tajeje. Yeenn a, Pɔl le yeke kubbu laa ngaa pa arede na: «Mesese tel ke dɔse te, tare a kuwa dɔm ang. Bbasine neenn ma kaw ke rɔ dewje te ke toje to Jiipije ang ngaa.» ");
INSERT INTO ksp_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Nɔtu ketenn naw rɔ mare dew te ke ria na Titusu-Jusutusu ke key laa to mbɔr key-mbɔn̂-naa te le Jiipije. N̂-to nje-polo Lubba. ");
INSERT INTO ksp_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kirisipusu ke to nje-kɔn dɔ key-mbɔn̂-naa le Jiipije oo mee te ke Ebbe-dewje, ne de ke nje ke key laa tɔyn. Mare dewje ke Korente nya ooje tar ke Pɔl tɔju le. Dooje mede te ngaa dingaje batem. ");
INSERT INTO ksp_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Mare ndɔ til te, Ebbe-dewje pa tar are Pɔl ddew ne te toke le ni na: «E-bbeel ang, ew rɔi pa tar ang, utu tai ang. ");
INSERT INTO ksp_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Mba mee sei, dew kara a kase kuwai ta ddai ang, mba dewje lem banya me bbe te neenn.» ");
INSERT INTO ksp_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pɔl nayn Korente tɔju tar le Lubba bbal kara ke neyn misan. ");
INSERT INTO ksp_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Bbal te ke Galiyɔn to tɔku-mbay nange te ke Akay, Jiipije ooje ta naa mbete Pɔl. Dawje saa lo gange sariya te. ");
INSERT INTO ksp_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","N̂-paje na: «Dew neenn aw dda kare dewje poloje Lubba ke ddew ke ndu mbete.» ");
INSERT INTO ksp_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Toke Pɔl a ta pa tar a, Galiyɔn ila tar Jiipije te na: «Bbo tar neenn to tar tɔl dew wase tar ne ke ngeng a, ma kungu tar gelse te. ");
INSERT INTO ksp_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","A tar le to mayn naa tar wɔju dɔ ne-tɔju, tar rije, ke ndu lese njaa are yeenn oose. M-ndiki gange sariya dɔ tarje te ke toke baann ang.» ");
INSERT INTO ksp_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Yeenn ngaa n̂-tubbade lo gange sariya te le. ");
INSERT INTO ksp_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Dede tɔyn duwaje Sostenn ke to nje-kɔn dɔ key-mbɔn̂-naa le Jiipije le, n̂-tundaeje ta key gange sariya te le. A Galiyɔn aa lo te ang. ");
INSERT INTO ksp_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pɔl nayn ndɔ banya ngaji Korente bba inya nje-me-kunnje ngaa unn to tel nange te ke Siri. Ne de ke Pirisil, ke Akilase. Kete bba ta kaw a, nare n̂-ngisa dɔe bbe te Sankere mba to ndue ke nunn. ");
INSERT INTO ksp_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Daw n̂-teeje bbe te ke Epeje. Pɔl inya Pirisil de ke Akilase lo teenn ngaa ɔtu aw key-mbɔn̂-naa te le Jiipije aw pa tar ke de. ");
INSERT INTO ksp_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","N̂-dujuje Pɔl nya kare nayn ke de ndɔ banya bbay. A Pɔl mbete. ");
INSERT INTO ksp_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Na ta kinyade a, n̂-ndejede na: «Toke Lubba ndiki a, ma tel rɔse te mare ndɔ.» Goe te a, nunn to Epeje, ");
INSERT INTO ksp_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","n̂-tee Sejare. Goe te a, naw n̂-dda lapiya nje-me-kunnje ke Jurusalam ngaa n̂-nday naw Antiyose. ");
INSERT INTO ksp_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","N̂-dda ndɔ ngaji lo teenn ngaa nin nday nange Galasi, ke Piriji te nare ndeje nje-njaje go Ebbe-dewje te tɔyn kare dingaje singa. ");
INSERT INTO ksp_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Mare Jiipi ke ria na Apolose ke duje bbe te ke Alekejandiri ddee Epeje. N̂-to dew ke gere pa tar ddem gere maketuru le Lubba nya ddem. ");
INSERT INTO ksp_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","N̂-tɔje ddew le Ebbe-dewje toke kete are ninga singa ngaa n̂-tɔju ne dɔ Jeju te ke dɔgɔle. A batem le Jan kara baa a n̂-gere. ");
INSERT INTO ksp_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Naw n̂-pa tar ke bbeel ang me key-mbɔ-naa te le Jiipije. A toke Pirisil, ke Akilase ooje tar laa le tɔyn a, bbareje ke rɔde te ngaa tɔjeje tar ke tɔkɔrɔ wɔju dɔ ddew le Lubba. ");
INSERT INTO ksp_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Goe te a, Apolose le ndiki ta kaw nange te ke Akay are nje-me-kunnje ndikije te saa ngaa ddaje maketuru are nje-me-kunnje ke Akay le kare n̂-taaeje ke maje. Toke n̂-tee nu a, Lubba dda saa me-maji are numa nje-me-kunnje nya. ");
INSERT INTO ksp_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Mba tar ke tae te ngeng are Jiipije ooje tar ta kila te ang. N̂-tɔju ke maketuru le Lubba ke ddaka to Jeju njaa to Mesi. ");
INSERT INTO ksp_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Kare te ke Apolose nayn bbe te ke Korente a, Pɔl nday ke ddew ke nange te ke Aji ke to ddingirije ngaa tee bbe te ke Epeje. Ninga mare nje-njaje go Ebbe-dewje te lo teenn, ");
INSERT INTO ksp_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ngaa n̂-dujude na: «Ndɔ ke ooje mese te le ingaje Ndil-me-nda wa?» Dilaeje te na: «Joo ri Ndil-me-nda ndɔ kara ang.» ");
INSERT INTO ksp_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pɔl tel dujude na: «Batem ddi a ingaje wa?» N̂-paje na: «Batem le Jan.» ");
INSERT INTO ksp_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pɔl ilade te na: «Jan are batem dewje ke ndikije ta turu ddew lede. Jan le duju dewje kare ta dooje mede te ke dew ke a ddee goe te. Dew le to Jeju.» ");
INSERT INTO ksp_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Dewje le ooje tar le ngaa ingaje batem ke ri Ebbe-dewje Jeju. ");
INSERT INTO ksp_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pɔl ila jia dɔde te ngaa Ndil-me-nda ddee dɔde te. N̂-paje tar ke ndɔn tar ke dang ngaa dilaje mber-tar le Lubba. ");
INSERT INTO ksp_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Kɔr dewje le tɔyn aw ngɔsi ke dɔku gire joo. ");
INSERT INTO ksp_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Me neyn te ke muta, Pɔl aw key-mbɔn̂-naa te le Jiipije ke ndɔ ke ndɔ mba pa tar ke bbeel ang wɔju dɔ tar bbe-kɔn le Lubba. N̂-dda tɔyn kare n̂-ndikije te saa. ");
INSERT INTO ksp_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","A me mareje ketere ngaa n̂-ndikije tar te le Pɔl le ang. Dar ke kem dewje te ke banya le njaa daw n̂-paje tar wɔju dɔ ddew le Ebbe-dewje daw n̂-kokoje ne. Yeenn a, Pɔl tusude inyade a mbɔn kese nje-njaje go Ebbe-dewje te aw ke de key-ne-ndo te le Tiranoso aw tɔjude tar le Lubba ndɔ ke ndɔ. ");
INSERT INTO ksp_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Neenn le to toke baann ndereng bbal joo are dewje ke nange Aji te, Jiipije, ke nje ke to Jiipije ang ooje tar le Ebbe-dewje. ");
INSERT INTO ksp_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Lubba dda tɔku ne-mɔrije ddew te le Pɔl. ");
INSERT INTO ksp_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Yeenn a bbo, dew ddee ke mbita kubbu, wase kubbu ke ɔru rɔ Pɔl ɔru ne nje-rɔ-to a, rɔ-to le goto ddem ndilje ke maji ang kara teeje ke ddang ddem. ");
INSERT INTO ksp_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Mare Jiipije ke aw tubbaje ndilje ke maji ang rɔ dewje te ke lo lo, aw unnje ri Ebbe-dewje Jeju bba aw tubbaje ne ndilje le tɔ. N̂-paje na: «Ke ri Jeju ke Pɔl aw ila mber-tar laa, e-teeje ke ddang!» ");
INSERT INTO ksp_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Seba mare Jiipi ke to tɔku nje-polo Lubba ee ke ngannje ke dingaw siri. Nganne le naje ta dda toke baann tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","A mare ndɔ ndil ke maji ang le ilade te na: «M-gere Jeju ngaa m-gere Pɔl tɔ. A sese e-toje to nje ke dda wa?» ");
INSERT INTO ksp_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Dew ke ndil ke maji ang isi mee te le aal uru dɔde te, singa utade are n̂-teeje ke ddaka ke ngɔru daynje rɔde baa ke do rɔde te. ");
INSERT INTO ksp_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Nje-bbeje tɔyn ke Epeje, ke Jiipije, ke Gerekeje, ooje tar neenn le. Bbeel ddade tɔyn are dɔsuje gaji ri Ebbe-dewje Jeju ke to ri ke bo. ");
INSERT INTO ksp_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Mare nje-me-kunnje nya ddeeje paje tar neje ke maji ang ke n̂-ddaje ke ddaka. ");
INSERT INTO ksp_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Mare nje-kumaje ke kɔrde banya unguje maketuru ne-kumanji lede dɔ naa te ngaa roje kem dewje te tɔyn. Dewje turaje gate maketurule le a, ase kem kande nare doro dɔmi. ");
INSERT INTO ksp_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Baann bba tar le Lubba aw ke kete kete ngaa ee ke singa mɔngu ddew te le Ebbe-dewje. ");
INSERT INTO ksp_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Go neje teenn a, Pɔl unn ndu ddew te le Ndil-me-nda ta kaw Jurusalam ke ddew ke Maseduwann, ke Akay. N̂-pa na: «Toke m-tee nunn a maji kare m-tee Rɔm tɔ.» ");
INSERT INTO ksp_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Yeenn a, nula Timote de ke Erasete ke toje to nje-buwa-kulaje laa ke joo Maseduwann, a ne n̂-nayn nange te ke Aji ndɔ ngaji bbay. ");
INSERT INTO ksp_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Dɔ ndɔe teenn njaa tɔku tar oso bbe te ke Epeje mba tar ddew le Ebbe-dewje le. ");
INSERT INTO ksp_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Mba mare nje-dda neje ke ande ke ria na Demeturusu unn ande aw dda ne ne ke unda rɔ key-polo-kɔr ke dene. Ri kɔr le na Artemis. Nje-kula mareje aw ingaje nare nya ddewe te. ");
INSERT INTO ksp_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","N̂-mbɔn nje-kula mareje, ke dewje ke aw ddaje mare neje dang dang ke ande ngaa n̂-pa narede na: «Namdede, e-gereje ke maje to ddew kula te neenn a jisi ne ke maje. ");
INSERT INTO ksp_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","A sese njaa ooje ke kemse ddem ooje ke mbise ddem na Pɔl mbɔn dewje pa arede na kɔrje ke n̂-ddaje ke jije to lubbaje ang are dewje banya banya ndikije te saa. Tarje neenn taa dɔ nange ke Aji tɔyn bbo Epeje kara baa ang. ");
INSERT INTO ksp_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Tar neenn a tuju ri kula leje kara baa ang. Key-polo-kɔr leje Artemis ke to tɔku kɔr ke dene ke ria aw bbar nya ngaa dewje aw poleje dɔ nange te ke Aji, ke kese loje te tɔyn le a tel to ne ang kem dewje te tɔ.» ");
INSERT INTO ksp_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Toke dewje le ooje tar le a, wungu ɔnde nya ngaa n̂-paje ke taar na: «Artemis ke Epeje bo nya!» ");
INSERT INTO ksp_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Tar le taa me bbe le tɔyn are dewje nya ɔtuje ke ngɔru awje nata. Duwaje Gayusu de ke Aristarke ke toje to nje-buwa-njaje le Pɔl jide dawje ke de tɔ. N̂-toje to dewje ke Maseduwann. ");
INSERT INTO ksp_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pɔl ndiki ta kaw nɔ dewje te ke banya banya le, a nje-me-kunnje mbeteje. ");
INSERT INTO ksp_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Mare tɔku dewje ke Aji ke toje to nje-buwa-kuraje le Pɔl kara ulaje ndejeje Pɔl kare nila gɔle nata le ang. ");
INSERT INTO ksp_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Dɔ dewje ke banya banya le turu are mareje paje mare tar uruje ne ekii ke taar a, mareje paje mare tar ke dang uruje ne ekii ke taar. Dewje nya horode te gereje gel ne ke n̂-mbɔnje ne naa le ang. ");
INSERT INTO ksp_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Mare dewje horo dewje te ke banya banya le ɔruje gel ne le are mare dew ke Jiipije utaeje ke kete ke ria na Alekejandere. Alekejandere le dda jia are dewje na n̂-ndiki ta pa tar kare dewje ke banya le. ");
INSERT INTO ksp_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","A toke dewje le gereje to n̂-to Jiipi a, n̂-paje tar ke kara baa naa te ke taar kure ew ase ke gɔl kare joo na: «Artemis ke Epeje bo nya!» ");
INSERT INTO ksp_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Nje-kuja maketuru ke me bbe te le dda nya bba gange dewje tar te ngaa pa na: «Dewje ke Epeje, e-gereje to Epeje to bbe ke aw ngem key-polo Artemis ke to tɔku kɔr ke dene ddem aw ngem etaar laa ke in darâ ddem. ");
INSERT INTO ksp_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Dew kara ase mayn tar neenn ang are maji kare isije ddekeke bbo e-ddaje ne ke tɔke baa ang. ");
INSERT INTO ksp_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Mba dewje ke e-ddeeje ke de neenn ddaje majang ang ddem tajije kɔr leje ke dene ang ddem. ");
INSERT INTO ksp_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","A bbo Demeturuse de ke nje-kula mareje a eeje ke tar ke mare dew a, lo dda tar, ke nje-gangeje sariya le Jiipije toje. Maji kare nje-tarje le awje lo gange sariya te. ");
INSERT INTO ksp_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","A bbo eeje ke mare tar dang bbay a, da dda tar le lo kuwa dɔ naa te ke nje-kɔn̂-bbeje gereje. ");
INSERT INTO ksp_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Mba mbɔn naa ke bbokone neenn a dda kare doojeje to nje-mbeteje ndu, mba ne ke a kunn ddew kare n̂-dda mbɔn naa ke be goto.» ");
INSERT INTO ksp_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Go tar teenn le a, n̂-tubba dewje le nare dɔtuje. ");
INSERT INTO ksp_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Toke tar le gayn a, Pɔl bbar nje-me-kunnje ndejede kare dingaje singa, n̂-ddade lapiya ngaa nunn ddew ke Maseduwann. ");
INSERT INTO ksp_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Goe te ke n̂-nday nange ke Maseduwann ngaa n̂-ndeje nje-me-kunnje nya kare dingaje singa a, naw Gerese. ");
INSERT INTO ksp_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","N̂-dda neyn muta keteenn. Kare te ke na ta kunn tɔku to ta kaw Siri a, noo na Jiipije unguje tar me naa te ta ddae maji ang. Yeenn a, noo maji ta tel ke ddew ke Maseduwann. ");
INSERT INTO ksp_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Dewje ke danneje toje to Sopatorose ke to ngonn le Pirusu ke bbe laa Bere, Aristarke de ke Sekundusu ke bbe lede Tesalonike, Gayusu ke bbe laa Derbe, Timote, ke Tisike de ke Toropim ke toje to dewje ke ngann bbeje te ke Aji. ");
INSERT INTO ksp_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Dewjeenn le awje nɔje te kete aw ngebbejeje Torowase. ");
INSERT INTO ksp_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","A jeje, ndɔ kusu mapa ke n̂-dda ke um ang nday a, junn tɔku to Pilipi, n̂-dda ndɔ mi a, jingade Torowase. N-nayn keteenn ndɔ siri. ");
INSERT INTO ksp_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Toke n̂-mbɔn naa ke ndɔ-kuwa-rɔ ta kɔn muru me-kara a, Pɔl pa tar are nje-koo me teje ndereng lo mɔngu, mba lo kare a, na ta kɔtu. ");
INSERT INTO ksp_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Lambeje toje nya me key te ke to dɔ mare te taar ke n̂-mbɔn naa te. ");
INSERT INTO ksp_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mare ngonn ke dingaw ke ria na Etike isi penetere te ngaa bbi tɔle. A Pɔl nayn aw pa tar bbay. Bbi uta dɔe are nin me muta te le key ke to dɔ naa te taar le noso nangê. Toke da ta kuwae ke taar a, noy mban. ");
INSERT INTO ksp_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pɔl ddisi ke ngɔru aw rɔ ngonn ke dingaw te le, n̂-ddɔm ngaa nunne nuwae jia te ngaa pa na: «Ejeje tar ang n̂-to kem baa.» ");
INSERT INTO ksp_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Goe te a, Pɔl tel aw taar. N̂-tete mapa ngaa nusa. N̂-pa tar ke dewje ndereng ta lo-kare a, nɔtu. ");
INSERT INTO ksp_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","A n̂-ddee ke ngonn ke dingaw le kem baa ngaa me dewje oso nangê. ");
INSERT INTO ksp_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Junn tɔku to jɔtu kete ta kaw bbe te ke Asos. Lo teenn a ja kunn Pɔl mba nunn ndue ta kaw engae ke gɔle. ");
INSERT INTO ksp_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Toke ningaje Asos le a, junne ngaa jaw bbe te ke Mitilenn. ");
INSERT INTO ksp_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Lo-kare a, jin teenn ke to n̂-tee ngɔsi ke bbe ke Kiyo. Ndɔ kara goe te bbay a, n̂-nday ke ddew ke Samos ngaa n̂-dda ndɔ joo a, n̂-tee Mile. ");
INSERT INTO ksp_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pɔl ndiki ta kar lo kara bbe te ke Epeje ang, mba n̂-ndiki ta kare gɔl kare laa nday baa nange te ke Aji ang. N̂-ndiki ta kaw ke ngɔru bbo ddew to a, ta tee bbe te ke Jurusalam ndɔ kusu Pantekote te. ");
INSERT INTO ksp_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pɔl nayn Mile nu njaa a, ula bbar ansiyenje ke Egilisi te ke Epeje. ");
INSERT INTO ksp_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Toke n̂-ddeeje dingaeje a, n̂-pa narede na: «E-gereje ddew ke maw m-nja ne horose te ke maje. Unn kute dɔngɔr ndɔ te ke m-tee ne horose te nange te ke Aji. ");
INSERT INTO ksp_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","M-dda ke Ebbe-dewje ke me ngonn kase, ke maann̂-nɔ, dann ne-wunguje te ke Jiipije unguje tar me naa te ngaa ddaje sem. ");
INSERT INTO ksp_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ne kara ke a ddase maji ke m-tɔjuse ang goto. M-pa neje tɔyn marese ddem m-tɔjuse ne kem dewje te ddem me keyje te lese te ddem. ");
INSERT INTO ksp_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mila mber mare Jiipije ddem dewje ke to Jiipije ang ddem kare telje rɔ Lubba te ngaa ta kare dooje mede te ke Ebbe-dewje Jeju. ");
INSERT INTO ksp_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","A bbasine Ndil-me-nda uwam ke singa kare maw Jurusalam, m-gere ne ke a kingam nu ang. ");
INSERT INTO ksp_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Uta tɔyn, me bbe te kara kara tɔyn ke m-tee te, Ndil pa arem na key-kula, kula njamji, ke ne kem-to-ndoo aw ngebbem. ");
INSERT INTO ksp_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Moo tebbe lem to ne kem te ang. Ne ke m-ndiki njaa to enga dda kula ke Ebbe-dewje Jeju inya jim te ndereng kɔsu kɔen. Kula le to kula kila mber Tar ke maji ke to me-maji le Lubba. ");
INSERT INTO ksp_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","‹‹M-nja horose te tɔyn mila mber-tar kɔn̂-bbe le Lubba. A bbasine neenn m-gere to a telje kooje kem ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Yeenn bba m-pa marese bbokone: Tar mesese a kuwa dɔm ang. Ne ke ase ta dda bba m-dda ang goto. ");
INSERT INTO ksp_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Mba miyase mare ne ang, m-tɔjuse ne tɔyn ke Lubba mɔse ta dda. ");
INSERT INTO ksp_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Undaje kemse dɔ rɔse te, ke dɔ ne-kuulje te ke Ndil-me-nda undase kare e-ngemje. E-ngemeje Egilisi ke Lubba ndoko ke mese njaa. ");
INSERT INTO ksp_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","M-gere ke maje to gom te a, dewje ke toje toke enjakemnjarje ke maji ang ke a ddeeje kandeje horose te mba ddase maji ang. ");
INSERT INTO ksp_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Mare nje-ngemje a kinje horose te njaa ta dda kare mare nje-me-kunnje unnje gode. ");
INSERT INTO ksp_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Yeenn a, undaje kemse dɔ rɔse te, oleje mese to bbal muta njaa, til te ddem kara ddem m-ndejese kara kara tɔyn ke maann̂-nɔ kem te. ");
INSERT INTO ksp_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«A bbasine minyase me ji Lubba te, ke me tar me-maji te laa ke ase ta dda kare e-sangeje ddem kare ingaje neje ke maji ke n̂-mɔse mba dewje laa ddem. ");
INSERT INTO ksp_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","M-dda bbo nare, bbo ande, wase bbo kubbu le dew ang. ");
INSERT INTO ksp_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Sese njaa kara e-gereje ke maje, ema njaa m-dda kula ke jim bba minga ne ne ke mem ndiki, ke ne ke a kuma nje-buwa njaje lem. ");
INSERT INTO ksp_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ke ndɔ tɔyn, maw m-tɔjuse to, to maji ta dda kula toke baann mba kuma ne nje-ndooje, ta kole ne mese dɔ tar te ke Ebbe-dewje Jeju njaa pa na: ‹Koko ee ke dew ke are ne uta dew ke dare ne.› » ");
INSERT INTO ksp_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Goe te ke Pɔl pa tarjeenn le a, ne de ke ansiyenje dunguje mekeje-gɔlde nangê ngaa n̂-duju Lubba. ");
INSERT INTO ksp_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Yeenn a, dewje tɔyn uruje dɔ nɔn te. Dilaje Pɔl duwaeje karde te ngaa n̂-toje mbiya. ");
INSERT INTO ksp_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ndoo ddade mba Pɔl pa arede na da telje koo kem ne ang ngaa. Goe te a, n̂-danneje ndereng ta tɔku to te. ");
INSERT INTO ksp_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Toke jinya ansiyenje Epeje a, jaw ke to njarara jaw n̂-tee Kose. Lo kare a, jaw n̂-tee Rode ngaa jin teenn jaw n̂-tee bbe te ke Patara. ");
INSERT INTO ksp_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Jinga tɔku to ke aw ke nange te ke Penisi ngaa junn tɔku to le. ");
INSERT INTO ksp_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","N-tee ngɔsi ke Sipere ngaa jaw joo dɔe a, jinya jaw ke beer er ke Siri. Jaw juru nangê bbe te ke Tir, mba nje-tɔku to le a ta kungu ne-kotoje lo teenn. ");
INSERT INTO ksp_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","N-nayn ndɔ siri mba jinga nje-me-kunnje lo teenn. Ndil-me-nda ula nje-me-kunnje le are n̂-paje dare Pɔl kare naw Jurusalam ang. ");
INSERT INTO ksp_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Toke ndɔ leje ase ngaa junn ddew ta kɔtu a, dewje tɔyn dannjeje, dede, ke deneje lede, ke ngannde ndereng tee ke je me bbe te le ddaka. Jungu mekeje-gɔlje nangê ta ba te ngaa n̂-duju Lubba. ");
INSERT INTO ksp_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Goe te a, n̂-dda naa lapiya ngaa junn tɔku to, a nje-me-kunnje le telje key lede. ");
INSERT INTO ksp_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","‹‹Jin Tir n̂-tee bbe te ke Petolemayise a, junda ngange nja leje le lo teenn. N-dda lapiya nje-me-kunnje ngaa n̂-nayn ke de ndɔ kara. ");
INSERT INTO ksp_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Lo kare a, n̂-tel junn ddew jaw n̂-tee Sejare. Lo teenn jaw key le Pilipi nje-tɔju Tar ke maji le Lubba ke to kara le dewje ke siri ke n̂-mberede Jurusalam ngaa n̂-to key laa. ");
INSERT INTO ksp_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Nee ke nganne ke dene sɔ ke gereje ngaw ang bbay ngaa aw ilaje mber-tar le Lubba. ");
INSERT INTO ksp_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","N-nayn lo teenn ndɔ banya nya le ngaa mare nje-kila mber-tar le Lubba ke nange te ke Jude ke ria na Agabusu in Jude te le ddee. ");
INSERT INTO ksp_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","N̂-ddee ningaje ngaa n̂-taa endaar kuwa-bber le Pɔl, ne njaa n̂-tɔ ne gɔle ke jia ngaa n̂-pa na: «Ndil-me-nda na Jiipije a tɔje nje-endaar kuwa bber neenn Jurusalam toke be ngaa da kulaeje ji dewje te ke gereje Lubba ang.» ");
INSERT INTO ksp_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Toke joo tar le baann a, jeje ddem nje-me-kunnje ke bbe te le ddem n̂-wal Pɔl nya kare ta naw Jurusalam ang. ");
INSERT INTO ksp_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","A nilaje te na: «Ddi bba aw nɔje ne ngaa aw ddaje are mem aw gange maann wa? Toke n̂-tɔm ke kula wase n̂-tɔlum Jurusalam wɔju dɔ ri Ebbe-dewje Jeju kara m-ndiki te.» ");
INSERT INTO ksp_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Juma saa pin n̂-ndiki ang are jew rɔje ngaa n̂-pa na: «Maji kare Ebbe-dewje dda ne ke mee ndiki.» ");
INSERT INTO ksp_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Go ndɔje te ke n̂-dda teenn le a, n̂-gɔl rɔje tɔyn ngaa junn ddew jaw Jurusalam. ");
INSERT INTO ksp_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Mare nje-koo-meteje ke Sejare ke aw dannjeje Jurusalam awje ke je are n̂-to key le Nasɔn bbe te ke Sipere. Nasɔn le to nje-me-kunn lew baa. ");
INSERT INTO ksp_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Toke n̂-tee Jurusalam a, nje-koo-meteje taajeje ke koko. ");
INSERT INTO ksp_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Lo kare a, Pɔl aw ke je rɔ Jake te. Ansinyeje tɔyn mbɔnje naa lo teenn le. ");
INSERT INTO ksp_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pɔl ddade lapiya ngaa ɔru gel ne ke Lubba dda ddew te laa horo dewje te ke toje to Jiipije ang ddekere ddekere arede. ");
INSERT INTO ksp_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Dewje ke ooje tar le Pɔl ɔsuje gaji Lubba ngaa paje are na: «Oo, ngokɔnje, Jiipije banya banya ooje mede te. Dede tɔyn tar ngemje ndu le Moyije uwa wurde nya. ");
INSERT INTO ksp_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Dooje tar ke aw nja ke rii ke maje. Na ne-tɔju lei a dda kare Jiipije tɔyn ke isije horo dewje te ke toje to Jiipije ang kara mbeteje ndu le Moyije. Na ei a e-pa arede tɔ ta kare duja mɔtu ngannde ang wase kare n̂-ddaje ne gel-bbe le Jiipije ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ddi a ja ddaje wa? A du ang da koo na ee neenn. ");
INSERT INTO ksp_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Maji kare e-dda ne ke ja ta pa kari neenn: Dewje sɔ eeje neenn ke unnje ndude. ");
INSERT INTO ksp_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Aw ke de, ei, ke de e-tokoje yerew lese naa te, uka dɔde are n̂-ngisa dɔde. Baann bba, dewje tɔyn a gereje to tarje ke dooje dɔi te le to ngem ngaa da gere to ei kara aw e-ngem ndu le Moyije tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","A tar ke wɔju dɔ dewje ke toje to Jiipije ang ngaa ooje mede te le, junn ndu me maketuru te jula ne jarede mban kare dusaje da ke n̂-polo ne kɔrje ang, dusaje mese ang, dɔnje da ke kewn ute ang, ke n̂-ddaje lo to majang ang.» ");
INSERT INTO ksp_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ndɔ kara goe te a, Pɔl aw ke dewje ke sɔ le are ne ke de n̂-toko yerew lede naa te. Naw key-polo-Lubba te ta tɔju ndɔ ke na kare ne ne-polo wɔju dɔde kara kara toke ndɔ toko yerew lede le tunga. ");
INSERT INTO ksp_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Toke ndɔ siri ke go toko yerew te le nayn ngɔsi ta kase a, Jiipije ke Aji ooje Pɔl key-polo-Lubba te. Dɔsuje kutu dewje ke banya banya dare wungu ɔnde ngaa duwaje Pɔl. ");
INSERT INTO ksp_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","N̂-paje ke taar na: ‹‹Ngann Ijarayelje, e-ddeeje bbo! Dew ke aw dda ddɔ ke dewje leje, ke ndu le Moyije ke key-polo-Lubba leje ddew ne tɔju te ke naw n̂-tɔju dewje leje tɔyn loje te tɔyn le a ar neenn. Gerekeje kara n̂-ddee ke de key-polo-Lubba te neenn nare lo neenn ke maji tɔyn le tuju.» ");
INSERT INTO ksp_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Kete, dooje Toropim ke to dew ke Epeje mbɔr Pɔl te le Jurusalam neenn are dejeje to naw saa key-polo-Lubba te. ");
INSERT INTO ksp_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Lo yeke me bbe te le tɔyn are dewje ddeeje banya, duwaje Pɔl dinje saa key-polo-Lubba te n̂-teeje saa ddaka ngaa dutu ta key le ngɔru. ");
INSERT INTO ksp_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Daw n̂-sangeje ddew ta tɔle a tare aw oso mbi tɔku mbayje te le mbambaje ke Rɔm na me bbe ke Jurusalam aw yeke. ");
INSERT INTO ksp_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Njange njange njaa n̂-bbar tɔku-mbayje le mbambaje, ke mbambaje kare dawje rɔ dewje te ke banya banya le. Toke dulaje kemde dooje tɔku-mbayje le mbambaje, ke mbambaje le a, dewje rɔde ta kunda Pɔl. ");
INSERT INTO ksp_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Yeenn a, tɔku mbayje le mbambaje le ddee saa ngɔsi uwae ngaa unn ndu kare n̂-tɔe ke kula njamdi joo. Goe te a, n̂-duju tar na n̂-to na wa? Ddi a n̂-dda wa? ");
INSERT INTO ksp_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Dewje ke banya le paje tar dang dang. Bula to nya are ddew ke na kase ta gere ne gel tar le ke maje goto. Yeenn a, nunn ndu nare daw ke Pɔl me ndoko te le mbambaje. ");
INSERT INTO ksp_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Toke Pɔl tee dɔ esekaliye te a, mbambaje le bangeje, mba dewje ke banya le aw ddaje singa. ");
INSERT INTO ksp_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Dewje le tɔyn ndoleje goe aw uruje ekii na: «E-tɔleje!» ");
INSERT INTO ksp_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kare te ke da ta kande ke Pɔl me ndoko te le mbambaje a, Pɔl pa are tɔku mbayje le mbambaje na: ‹‹Ddew pa sei tar to wa?›› Nilae te na: «E-gere tar gereke wa? ");
INSERT INTO ksp_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Dew ke Ejipite te ke bbasine bbay neenn ɔsu kutu dewje are ddaje dɔ ngeng ngaa oto dewje ke nje-tɔl dewje doro sɔ aw ke de me kɔr te le, to ei a neenn ang wa?» ");
INSERT INTO ksp_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pɔl ilate na: «Ema, m-to Jiipi ke dujum Tarese, nange Silisi te, m-to ngonn ke bbe te ke ria bbar nya. M-wali nya kare arem ddew m-pa tar mare dewje neenn.» ");
INSERT INTO ksp_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Tɔku mbayje le are ddew Pɔl kare pa tar. Pɔl le ar dɔ esekaliye te dda jia are dewje le. Lo to nyenene ngaa n̂-pa tar narede ke tar ebere na: ");
INSERT INTO ksp_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","‹‹Ngakɔmje, bɔydede, ooje naji lem ke ma ta kɔru karese.›› ");
INSERT INTO ksp_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Toke dooje to Pɔl aw pa tar arede ke tar ebere a, lo to nyenene uta ye ke dɔngɔr bbay. ");
INSERT INTO ksp_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«M-to Jiipi, dujum Tarese nange Silisi te. A n̂-ngemem Jurusalam neenn. M-ndo ne kɔ Gamaleyel te dɔ tar ngem ndu te le kajeje. Munn rɔm tɔyn mare Lubba ddew kara baa toke aw ddaje bbokone. ");
INSERT INTO ksp_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","M-dda singa ke dewje ke unnje ddew le Ebbe-dewje ndereng dingaje yo. Mare duwa dingawje, ke deneje n̂-tɔde dungude key-kula te. ");
INSERT INTO ksp_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Tɔku nje-polo Lubba, ke mbɔn̂-naa le ansiyenje a gereje to tar ke tɔkɔrɔ njaa maw m-pa neenn. Mba dede njaa darem maketuru ke ri ngakɔnje Jiipije ke isije Damase kare maw muwa nje-me-kunnje m-tɔde m-ddee ke de Jurusalam kare dula kemde ndoo.» ");
INSERT INTO ksp_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Toke maw m-jaa ddew-bô ngaa m-tee ngɔsi ke Damase a kare ee ngɔsi ta kare danna. A a ta koo a, tɔku lo-kare in darâ gukum. ");
INSERT INTO ksp_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","M-tee moso nangê a, moo mare ndu pa sem tar na: ‹Sɔl! Sɔl! Mba ta ddi bba e-dda singa sem wa?› ");
INSERT INTO ksp_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Milae te na: ‹Ebbemje, ei na wa?› Ndu le pa na: ‹Ema Jeju ke Najarete a aw dda sem singa neenn.› ");
INSERT INTO ksp_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Nje-buwa lo-kawje lem ooje lo ke ndoko le ke maje a dooje ndu dew ke aw pa sem tar le ang. ");
INSERT INTO ksp_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","M-duju tar m-pa na: ‹Ddi a ma dda wa Ebbemje?› Ebbe-dewje le pa arem na: ‹In taar aw Damase. Nunn da tɔji ne tɔyn ke to tar lei ta dda.› ");
INSERT INTO ksp_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","A lo le ndoko are moo lo ang ngaa nje-buwa-njaje lem le a uwaje jim to kuwa bba aw sem Damase.» ");
INSERT INTO ksp_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Mare dingaw ke ria na Ananiyase ee nunn, n̂-to dew ke bbeel Lubba, naw n̂-ngem ndu le Moyije, Jiipije tɔyn ke me bbe teenn aw paje tar laa maji. ");
INSERT INTO ksp_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","N̂-ddee ningam ngaa n̂-pa narem na: ‹ Ngɔkɔm, Sɔl e-tel oo lo!› Kare teenn njaa kem uja ngaa mooe. ");
INSERT INTO ksp_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ananiyase le pa arem na: ‹Lubba le kajeje bbari undai dang kare e-gere ne ke mee ndiki, kare ta oo Jeju ke to dew ke gate gate, kare ta oo ndue ke mbii. ");
INSERT INTO ksp_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Mba maji kare e-tel to nje-tar naji laa ta pa ne ke oo ke mbii ddem, ke kemi ddem nɔ dewje te tɔyn. ");
INSERT INTO ksp_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","A mbata ddi a aw e-ngebbe wa? Jaw jare inga batem, e-bbar ria are tar majang lei ɔru dɔi te.› ");
INSERT INTO ksp_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Goe te ke m-tel Jurusalam ngaa mare ndɔ maw duju Lubba me key-polo-Lubba te a, moo mare ne toke le ni jeenn. ");
INSERT INTO ksp_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Moo Ebbe-dewje ke pa sem tar na: ‹E-tee njange Jurusalam ke ddang, mba naji ke a kɔru dɔm te le dewje a ndikije te ang.› ");
INSERT INTO ksp_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","M-pa mare na: ‹Ebbemje, n̂-gereje ke maje to ema le njaa, maw mande key-mbɔn̂-naaje te mare duwa dewje ke ooje mede te sei, daw dilade key-kula te ddem, n̂-tundade ke ndey ddem.› ");
INSERT INTO ksp_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Kare te ke daw n̂-kayn ne mese Etiyenne ke to nje-tar-naji lei le mee loe te tɔ, m-ndiki te ke de ngaa m-ngem kubbuje le nje ke tɔleje le. ");
INSERT INTO ksp_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","A Ebbe-dewje le pa arem na: ‹Aw, mba ma kulai ddew ew horo dewje te ke toje to Jiipije ang.› » ");
INSERT INTO ksp_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Toke Jiipije ooje tar laa ndereng teeje dɔ tar teenn a, uruje ekii na: «E-tɔlje dingaw neenn ke ddang! Maji kare n̂-nayn ke tebbe ang!» ");
INSERT INTO ksp_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Daw duruje ekii, daw n̂-tɔruje kubbuje rɔde te ngaa daw n̂-sanreje ebaburu ke taar. ");
INSERT INTO ksp_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Yeenn a, tɔku mbayje le mbambaje le unn ndu kare dande ke Pɔl me ndoko te le mbambaje kare ta dundae dare n̂-pa tar bba ta gere gel ne ke dewje aw uruje ne ekii dɔe te le. ");
INSERT INTO ksp_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Toke daw n̂-tɔeje ta kundae a, n̂-pa nare tɔku-mbay le mbambaje ke ee teenn na: «Eeje ke ddew ta kunda ngonn nje-bbe ke Rɔm ke n̂-gange sariya dɔe te ang wa?» ");
INSERT INTO ksp_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Toke tɔku-mbay le mbambaje le oo tar neenn le a, ɔtu aw pa are tɔku mbayje le mbambaje na: «Ddi a a dda wa? Dingaw le to ngonn nje-bbe ke Rɔm.» ");
INSERT INTO ksp_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Tɔku mbayje le mbambaje le ddee duju Pɔl na: «Tɔkɔrɔ njaa e-to ngonn nje-bbe ke Rɔm wa? E-pa are moo!» Pɔl pa na: «Tɔkɔrɔ njaa.» ");
INSERT INTO ksp_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Tɔku mbayje le mbambaje le na: «Dare muka nare bo nya bba m-ddee to ngonn nje-bbe ke Rɔm.» Pɔl ilae te na: «Ema Pɔl, dujum to ngonn nje-bbe ke Rɔm njaa.» ");
INSERT INTO ksp_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Dewje ke a ta tundaeje kare n̂-pa tar ke tɔkɔrɔ le tuseje inyaeje ke ngɔru. Toke tɔku mbayje le mbambaje le gere to Pɔl to ngonn nje-bbe ke Rɔm a nare duwae n̂-tɔe a, bbeel ddae. ");
INSERT INTO ksp_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Lo are a, tɔku mbayje le mbambaje le ndiki ta gere gel ne ke Jiipije undaje ne tar dɔ Pɔl te le ke maje. Yeenn a, nare n̂-tutu kula njamji gɔle te ngaa nare tɔku nje-poloje Lubba uwaje dɔ naa ke nje-gangeje sariya ngaa nare n̂-ddee ke Pɔl nɔde te. ");
INSERT INTO ksp_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pɔl aa kem nje-gangeje sariya ke uwaje dɔ naa le ngaa pa na: «Ngakɔmje, nja lem ke maw m-nja nɔ Lubba te ndereng bbokone neenn, mare ne jɔku keje lem ndɔ kara ang.» ");
INSERT INTO ksp_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","A Ananiyase tɔku nje-polo Lubba unn ndu are nje ke arje mbɔr Pɔl te le kare dundaje tae. ");
INSERT INTO ksp_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Yeenn ngaa, Pɔl pa are na: «Ei ke e-to ddew kara baa toke kare key ke dɔru pɔr te, Lubba a kundai. Isi neenn ta gange sariya dɔm te ddew ndu te, a inya ndu le are kunda a dundam wa?» ");
INSERT INTO ksp_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Dewje ke arje ngɔsi ke Pɔl paje areje na: «Aw e-taji tɔku nje-polo Lubba wa?» ");
INSERT INTO ksp_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pɔl pa na: «Ngakɔmje, m-gere to n̂-to tɔku nje-poloje Lubba ang, mba maketuru le Lubba pa na: ‹E-pa Tar ke maji ang dɔ nje-kɔn̂-bbe te lei ang.› » ");
INSERT INTO ksp_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pɔl gere to dewje ke aw uwaje dɔ naa mba gange sariya le, mareje toje to Saduseyenje, a mare toje to Parijiyenje. Yeenn a n̂-pa tar ke taar horo nje-gangeje sariya te le na: «Ngakɔmje, m-to Parijiyen, m-to ngonn le Parijiyen. Gel ne ke da ta gange ne sariya dɔm te to mem ke munda dɔ kin te le dewje ke oy.» ");
INSERT INTO ksp_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","N̂-pa tar nila nangê ang bbay a, kɔl in horo Parijiyenje te, ke Sadusiyenje ngaa kayn̂-naa to me mbɔn naa te le. ");
INSERT INTO ksp_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Mba Sadusiyenje paje na: «Kin le nje-yoje goto, anjije gotoje, ndilje gotoje. A Parijiyenje paje na nejeenn toje tɔkɔrɔ. ");
INSERT INTO ksp_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Tɔku bula in horode te. Mare nje-kɔruje gel nduje ke toje to Parijiyenje inje taar ngaa paje tar ke singa na: «Joo mare ne kara ke ase kare jundaje ne tar dɔ dingaw te neenn ang. To mare ndil wase mare anji a pa saa tar a, n̂-gereje wa?» ");
INSERT INTO ksp_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Tar le aw ke kete kete are tɔku mbayje le mbambaje le bbeel mba kare dewje le inje uruje dɔ Pɔl te jakateje. Yeenn a, nunn ndu nare mbambaje aw ɔruje Pɔl horode te teeje saa aw saa me ndoko te le mbambaje. ");
INSERT INTO ksp_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Lo ndul a, Ebbe-dewje tee inga Pɔl ngaa pa are na: «Uwa are ngeng, e-pa tar naji lem Jurusalam mban, a maji kare e-dda toke baann Rɔm tɔ.» ");
INSERT INTO ksp_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Lo are a, mare Jiipije unguje tar me naa te ngaa undaje yo na: «Ja kusa ne ang ddem, ja kay maann ang ddem ndereng n̂-tɔl Pɔl bba.» ");
INSERT INTO ksp_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Kɔr dewje ke unguje tar me naa te le uta dɔsɔ. ");
INSERT INTO ksp_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Daw dingaje tɔku nje-poloje Lubba, ke tɔkuje n̂-paje darede na: «Junda yo kem dewje te tɔyn n̂-pa na: Ne a kɔru taje ang ndereng n̂-tɔl Pɔl bba.» ");
INSERT INTO ksp_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Yeenn a, maji kare ooje naa ke nje-gangeje sariya ta e-dujuje tɔku-mbay le mbambaje areje n̂-ddeeje ke Pɔl darese. Ereje gusu to na ddee kare uruje gel tar laa ke maje ooje. A jeje ja kiya baan mba tɔle kete bba kare n̂-tee neenn.» ");
INSERT INTO ksp_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","A ngonn nann Pɔl ke dingaw oo tar baan ke da ta kiya le ngaa aw ande me ndoko te le mbambaje pa are Pɔl le. ");
INSERT INTO ksp_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pɔl bbar mare tɔku-mbay le mbambaje pa are na: «Aw ke ngonn basan neenn nɔ tɔku mbayje le mbambaje te mba nee ke mare tar ta pa kare.» ");
INSERT INTO ksp_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mbay le mbambaje le unn ngonn basan le aw saa nɔ tɔku mbayje te le mbambaje. N̂-pa na: «Pɔl ke duwae le bbarem ngaa dujum kare m-ddee ke ngonn basan neenn rɔi te, mba nee ke mare tar ta pa kari.» ");
INSERT INTO ksp_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Tɔku mbayje le mbambaje le uwa ngonn le aw saa ngange lo te ngaa duje na: «Tar ddi a ee ne ta pa karem wa?» ");
INSERT INTO ksp_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ngonn basan le pa are na: «Mare Jiipije ooje ta naa ta duji kare bara a, are daw ke Pɔl lo gange sariya te lede. Da kereje gusu to da ta kuruje gel tar laa le ke maje koo. ");
INSERT INTO ksp_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","A dang bba oo tar lede ang, mba daseje ne ke dɔsɔ gire ngaa diyaje baan. Dundaje yo ta mbete ne-kusa, ta mbete ne-kay ndereng ta tɔl Pɔl bba. N̂-mɔseje rɔde tɔyn mban, ndui njaa daw n̂-ngebbeje.» ");
INSERT INTO ksp_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Tɔku mbayje le mbambaje le ndeje ngonn basan le na: «E-pa are mare dew kara to uku me tar neenn arem ang.» Goe te a, ninyae nare nɔtu. ");
INSERT INTO ksp_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Goe te a, tɔku mbayje le mbambaje bbar mare tɔku-mbayje le mbambaje joo ngaa pa arede na: «E-gɔlje mbambaje kɔr joo, nje-sundaje dɔsiri, nje-ningaje kɔr joo are darje perere ta dawje Sejare ke kare jikara ke til te. ");
INSERT INTO ksp_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","E-mɔseje mare sundaje kare unnje Pɔl aw saa ke rɔ ke maji nɔ tɔku-mbay Pelikese te.» ");
INSERT INTO ksp_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Goe te a, tɔku mbayje le mbambaje dda maketuru are Pelikese le na: ");
INSERT INTO ksp_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Ema Kolodiyusu Lijiyase m-dda maketuru neenn mari, ei tɔku-mbay Pelikese ke e-to dew ke bo. M-ddai lapiya! ");
INSERT INTO ksp_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Jiipije uwaje dingaw ke mulae mari neenn ta tɔle. A moo na n̂-to ngonn nje-bbe ke Rɔm are maw ke mbambaje maw mɔre ne me jide te. ");
INSERT INTO ksp_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","M-ndiki nya ta gere gel ne ke dundaje ne tar dɔe te are maw saa nɔ nje-gangeje sariya te lede. ");
INSERT INTO ksp_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Moo a, dunda tar dɔe te mba mayn naa tar dɔ nduje te lede. A minga tar ke ase kare ta n̂-tɔle ne wase dilae ne key kula te ang. ");
INSERT INTO ksp_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Moo na da ta kiya baan ta tɔl dingaw le. Yeenn a, mulae rɔi te ngaa, m-pa mare nje-kundaje tar dɔe te le kare daw ke tar la le nɔi te.» ");
INSERT INTO ksp_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Mbambaje le ooje ndu tɔku-mbay lede ngaa, unnje Pɔl til te awje saa Antipatirisi. ");
INSERT INTO ksp_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Lo are a, mbambaje ke nje-gɔlje telje me ndoko te, a nje-sundaje le awje saa. ");
INSERT INTO ksp_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Toke n̂-teeje Sejare be a, dareje maketuru le tɔku-mbay ngaa n̂-tɔjeje Pɔl le. ");
INSERT INTO ksp_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Mbay le tura maketuru le a, duju ta gere se Pɔl to dew ke nange te ke dda wa? N̂-pa dare na Pɔl to dew ke nange te ke Silisi. ");
INSERT INTO ksp_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Mbay le pa na: «Ndɔ ke dewje ke undaje tar dɔi te le ddeeje bba ma koo tar lei.» Nunn ndu kare n̂-ngem Pɔl me key-tɔku-mbay . ");
INSERT INTO ksp_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ndɔ mi goe te a, Ananiyase ke to tɔku nje-polo Lubba, tɔkuje, ke Tertulusu ke to mare nje pa tar dɔ dewje te awje Sejare. Daw n̂-sekeje Pɔl ta tɔku-mbay Pelikese te. ");
INSERT INTO ksp_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","N̂-bbar Pɔl dare ddee ngaa Tertulusu le unn kutu kunda tar dɔe te na: «Dew ke bo Pelikese, tambal dɔi a jisi ne ddekeke bbokone, ke ddew gusu te ke siki ke e-tee ne a bbe neenn maji ne. ");
INSERT INTO ksp_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ke ndɔ kara kara tɔyn, loje te tɔyn jaw jari wooyo mba neje ke maji ke jaw jinga toke be ddew te lei. ");
INSERT INTO ksp_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ma pa tar ten baa mba m-ndiki ta tuju kare lei baa ang. Yeenn a, m-wali nya kare e-dda me-maji bbo e-tuka mbii oo tar leje. ");
INSERT INTO ksp_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Joo a, dingaw neenn to dew ke maji ang nya. N̂-dda nare lo yeke horo Jiipije te tɔyn ke dɔ nange te. Ngaa n̂-to mare tɔku-mbay dɔ mbɔn̂-naa te le dewje ke Najarete ke to mbɔn̂-naa ke maji ang. ");
INSERT INTO ksp_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","N̂-sange ddew ta ddee ke ne-yerew me key-polo-Lubba te leje are juwae. N-ndiki ta gange sariya dɔe te ddew ndu te leje ");
INSERT INTO ksp_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","A Lijiyase ke to tɔku-mbay le mbambaje a ddee ɔre jije te ke singa ");
INSERT INTO ksp_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ngaa duju kare nje ke undaje tar dɔe te le ddeeje ke tar le nɔi te. Ei njaa bbo e-duje tar a, a gere to neje tɔyn ke junda ne tar dɔe te le to neje ke tɔkɔrɔ.» ");
INSERT INTO ksp_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Jiipije ndikije tar te le tɔ ngaa paje na tar le to tar ke tɔkɔrɔ. ");
INSERT INTO ksp_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Goe te a, tɔku-mbay dda jia are Pɔl kare pa tar ngaa Pɔl pa na: «M-gere to e-to nje-gange sariya le dewje me bbe te neenn bbal banya nya. Yeenn a, ma kɔru naji lem nɔi te ke me ke oso pɔn. ");
INSERT INTO ksp_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Bbo uru gele a, a gere. Dda ndɔ dɔku gire joo baa bbay a maw Jurusalam mba polo Lubba. ");
INSERT INTO ksp_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Me key-polo-Lubba te wase key-mbɔn̂-naaje te wase me bbe te, mare dew ingam maw mayn tar ke mare dew wase maw mere dewje kare yeke lo ndɔ kara ang. ");
INSERT INTO ksp_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Dewje neenn a kaseje ta tɔji ne ke dundaje ne tar dɔm te le bbasine neenn ang. ");
INSERT INTO ksp_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ne ke m-gere goe a neenn: Maw m-polo Lubba le kajeje ke ddew ke siki. A dede n̂-paje na to ddew ke maji ang. Ne tɔyn ke n̂-dda maketuru ndu te le nje-kilaje mber-tar le Lubba, m-ndiki te. ");
INSERT INTO ksp_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Munda mem to dewje ke gate gate ddem nje ke gate ang ddem ke oyje a kinje. Dede kara dunda mede toke baann tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Yeenn bba, ke ndɔ tɔyn maw m-sange ddew ta ngem keje ke maji nɔ Lubba te ddem nɔ dewje te ddem. ");
INSERT INTO ksp_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","M-tee Jurusalam ang bbal banya nya. Yeenn bba m-ddee ta kare ne kuma ne dewje ke me bbe te lem ddem ta kare ne-polo Lubba ddem. ");
INSERT INTO ksp_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Kare teenn le a m-toko yerew lem me key-polo-Lubba te m-tunga a, dingamje. Ndɔe teenn le dewje mbɔnje naa banya ang ddem bula goto ddem. ");
INSERT INTO ksp_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","A mare Jiipije ke Aji eeje teenn. Dede a bbo deeje sem ke tar a, to tar lede ta ddee nɔi te mba kunda tar dɔm te. ");
INSERT INTO ksp_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Wase dede neenn bbo dooje majang lem ndɔ te ke maw ne nɔ sariya te le a, maji kare n̂-paje. ");
INSERT INTO ksp_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Kare teenn le mar horo nje-gangeje sariya te muru ekii m-pa na: ‹Da ta gange sariya dɔm te wɔju dɔ nje-yoje ke munda mem to da kinje.› Mba tar ke kara baa neenn le njaa n̂-ddee ne sem sariya te nɔse te bbokone neenn.» ");
INSERT INTO ksp_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Pelikese gere tar dɔ ddew te ke siki ke Ebbe-dewje tɔju le ke maje ngaa nɔru ndɔ sariya le ke kete. N̂-pa na: «Ndɔ ke Lijiyase ke to tɔku mbayje le mbambaje ddee bba ma gange sariya lese le.» ");
INSERT INTO ksp_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Nunn ndu nare tɔku-mbay le mbambaje kare n̂-ngem Pɔl key kula te, a ta ninya ddew nare n̂-dda mare neje ke mee ndiki ddem ninya ddew nare nje ke laa ddee umaeje ddem. ");
INSERT INTO ksp_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Dda ndɔ ngaji goe te a, Pelikese de ke dene laa Durusile ke to Jiipi n̂-ddeeje. Pelikese le ula bbar Pɔl ngaa dooje tar ke naw n̂-tɔju dɔ kunn me te kare te Kiriste Jeju. ");
INSERT INTO ksp_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Kare te ke Pɔl aw pa tar kula-dda te ke gate gate, tar tɔ bbo ke da-rɔ te, ke tar sariya ke aw ddee a, bbeel dda Pelikese ngaa pa na: «Ase baann, ɔtu ngaa. Mare ndɔ ngaa bba ma bbari.» ");
INSERT INTO ksp_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Nare Pɔl ddee tɔn saa tam taar taar, mba neje to Pɔl a kare ne nare. ");
INSERT INTO ksp_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Bbal joo nday a, Pɔrusiyusu Pesutusu ɔn tɔku-mbay turu Pelikese te. A Pelikese le ndiki ddee maji kem Jiipije te are ninya Pɔl key-kula te. ");
INSERT INTO ksp_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Pesutusu tee nange te ke nɔn dɔe ngaa ndɔ muta goe te a, nin Sejare le naw Jurusalam. ");
INSERT INTO ksp_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Tɔku nje-poloje Lubba, ke tɔku dewje le Jiipije awje nɔe te aw sekeje Pɔl. N̂-dujeje nya kare ");
INSERT INTO ksp_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","n̂-dda ke de me-maji ta nare n̂-tel ke Pɔl Jurusalam. Daw n̂-ddaje baann ta kiya baan ddew-bô tɔlje Pɔl. ");
INSERT INTO ksp_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","A Pesutusu pa na: «Key-kula ke Sejare a dila Pɔl te. Ema njaa kara mbɔr ang a ma tel Sejare tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Maji kare mare dewje ke kemde ɔru ke eeje horose te ddeeje ingamje are jaw Sejare, a bbo dooje mare ne ke to ke dɔgɔle ang dɔ Pɔl te a, n̂-sekeje Pɔl le.» ");
INSERT INTO ksp_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Pesutusu dda ndɔ jijoo wase ndɔ dɔku baa rɔde te ngaa goe te a, n̂-tel Sejare. Lo are a, naw nisi lo gange sariya te ngaa nunn ndu kare n̂-ddee ke Pɔl. ");
INSERT INTO ksp_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Toke Pɔl le tee a, Jiipije ke inje Jurusalam ddeeje gukuje dɔe ngaa undaje tarje ke ngeng ngeng dɔe te. A ne ke a kase ta tɔju to tarje ke dunda dɔe te le to tarje ke tɔkɔrɔ goto. ");
INSERT INTO ksp_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","A Pɔl ɔru naji laa na: «M-dda ne ke majang ke mbete ndu le Jiipije ang ddem, key-polo-Lubba ang ddem, ke tɔku mbayje ke Rɔm ang ddem.» ");
INSERT INTO ksp_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Pesutusu ndiki ta ddee maji kem Jiipije te, yeenn a, n̂-duju Pɔl na: «E-ndiki tel Jurusalam kare n̂-gange sariya lei nɔm te wa?» ");
INSERT INTO ksp_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","A Pɔl pa na: «Lo ke neenn kara to lo gange sariya le tɔku mbayje ke Rɔm a mar te neenn, are lo ke neenn njaa da gange sariya lem ke te. Moo mare ne ke maji ang ke m-dda ke Jiipije ang are ei njaa kara e-gere ke maje. ");
INSERT INTO ksp_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","A bbo mare tar uwam wase m-dda mare ne ke maji ang ke ase gange sariya yo dɔm te a, m-mbete ta koy ang. A bbo tarje ke dunda dɔm te neenn to ngem baa a, dew kara ee ke ddew ta kiyam me jide te ang. Ma kaw ke tar le nɔ tɔku mbayje te ke Rɔm.» ");
INSERT INTO ksp_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Pesutusu pa tar ke nje-kareje ndeje ngaa goe te a, pa are Pɔl na: «E-ndiki ta kaw ke tar lei nɔ tɔku mbayje ke Rɔm te mban are a kaw nɔe te.» ");
INSERT INTO ksp_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Dda ndɔ ngaji goe te a, tɔku-mbay Agiripa de ke kɔnanne Berenise n̂-ddeeje Sejare ngaa dawje ta dda lapiya Pesutusu. ");
INSERT INTO ksp_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Toke daw n̂-ddaje ndɔ keteenn ngaji le a, Pesutusu ɔru gel tar ke dɔ Pɔl le are tɔku-mbay Agiripa le na: «Mare dingaw ke Pelikese inyae key-kula te ee neenn. ");
INSERT INTO ksp_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Kare te ke maw Jurusalam a, tɔku nje-poloje Lubba, ke tɔkuje le Jiipije sekeje tam te ngaa dujuje kare m-gange sariya dɔe te. ");
INSERT INTO ksp_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","A milade te na: ‹Dewje ke Rɔm aw gangeje sariya dɔ dew te baa baann ang. Maji kare nɔru naji laa kem dewje te ke undaje tar dɔe te le bba da gange sariya dɔe te.› ");
INSERT INTO ksp_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kare te ke ema jee ke de n̂-ddee Sejare neenn a, m-ngebbe ang. Lo-kare njaa maw misi lo gange sariya te ngaa munn ndu kare n̂-ddee ke dingaw le neenn. ");
INSERT INTO ksp_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Nje-tarje laa le ddeeje a, ne ke maji ang ke meje to n̂-dda bba dundaje ne tar dɔe te le moo ang. ");
INSERT INTO ksp_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Bbaye njaa to tar ke n̂-maynje naa wɔju dɔ ddew ke ta polo ne Lubba lede njaa, ke dɔ mare dingaw te ke ria na Jeju ke oy mban, a Pɔl aw pa na nisi kem baa. ");
INSERT INTO ksp_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","A m-gere ne ke ma dda wɔju dɔ tar neenn ang. Yeenn a, m-pa mare kare bbo n̂-ndiki a, naw Jurusalam bba ta n̂-gange sariya dɔ tar te laa le. ");
INSERT INTO ksp_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","A Pɔl le ndiki ta kaw ke tar laa le nɔ tɔku mbayje te ke Rɔm. Yeenn bba munn ndu kare n̂-ngeme ndereng ta mulae nɔ tɔku mbayje te ke Rɔm le.» ");
INSERT INTO ksp_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agiripa pa are Pesutusu na: «Ema njaa kara m-ndiki nya ta koo tar ke ta dingaw te neenn.» Pesutusu le pa na: «Bara njaa a, a koo tar ke tae te.» ");
INSERT INTO ksp_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Lo-kare a, Agiripa de ke Berenise n̂-ddeeje ke dewje gode te toke banya, ke tɔku-mbayje le mbambaje, ke tɔku dewje ke me bbe te dawje lo gange sariya te. Pesutusu unn ndu are n̂-ddee ke Pɔl. ");
INSERT INTO ksp_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Yeenn a, Pesutusu unn kutu pa tar na: «Mbay Agiripa, sese tɔyn ke eeje ke je neenn ooje dingaw neenn. Dewje ke toje to Jiipije tɔyn ddeeje oomje ke tar laa. Jiipije ke Jurusalam ddem nje ke neenn ddem aw uruje ekii na nase yo. ");
INSERT INTO ksp_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ema, moo mare ne ke n̂-dda ke a ase yo ang. A ne njaa n̂-duju ta koo tɔku mbayje ke Rɔm. Yeenn a, munn ndu ta kulae nɔ tɔku mbayje te ke Rɔm. ");
INSERT INTO ksp_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","A minga mare ne kara ke ma dda dɔe te me maketuru te kula ne kare tɔku mbayje ke Rɔm le ang. Mba yeenn a m-ddee saa nɔse te tɔyn, uta tɔyn, nɔ ei tɔku-mbay Agiripa te ta kisa me tar laa le. Goe te a, ma gere ne ke ma dda maketuru te kare tɔku mbayje ke Rɔm. ");
INSERT INTO ksp_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Mba ke keje te lem, kula dew Rɔm a pa gel ne ke dunda ne tar dɔe te ang to kula mbe.» ");
INSERT INTO ksp_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agiripa pa are Pɔl na: «Jari ddew kare ɔru naji lei.» Pɔl ula jia ngaa ɔru naji laa na: ");
INSERT INTO ksp_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Tɔku mbayje Agiripa, rɔm neelem bbokone nya ta kɔru naji lem nɔi te wɔju dɔ tarje tɔyn ke Jiipije undaje dɔm te. ");
INSERT INTO ksp_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Mba e-gere ne-ji-bbeje le Jiipije tɔyn maji ddem, e-gere neje tɔyn ke daw n̂-maynje naa tar dɔe te ddem. Yeenn a, m-duji kare ore wuri oo tar lem. ");
INSERT INTO ksp_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«Jiipije tɔyn gereje pa-nja lem ke kasem baa. N̂-gereje kisi lem horo dewje te ke bbe lem, ke kisi lem Jurusalam. ");
INSERT INTO ksp_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","N̂-geremje lew baa. Toke n̂-ndikije a, da kaseje ta pa kari to, m-to kara le dewje ke uwaje tar le Lubba ngeng nya ke toje to parijiyenje. ");
INSERT INTO ksp_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","A bbasine, n̂-sekemje mba munda mem dɔ ndu Lubba te ke unn are kajeje. ");
INSERT INTO ksp_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Gel-dewje leje ke dɔku gire joo undaje mede to ne ke Lubba unn ndue ta dda a ddee ne ke tɔkɔrɔ. Yeenn bba daw n̂-poloje Lubba til, ke kare ke me ke enge ang. Tɔku mbayje, ema kara munda mem dɔ ne teenn le tɔ. Ne ke Jiipije undaje ne tar dɔm te le ann. ");
INSERT INTO ksp_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","See Jiipije, ooje to Lubba ase ta ndol dewje ke oyje ang mba ddi wa? ");
INSERT INTO ksp_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«Ema kara meje lew m-pa na to maji kare m-dda singa nya mba koo ri Jeju ke Najarete neenn mbim te ang. ");
INSERT INTO ksp_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","M-dda neenn Jurusalam. Tɔku nje-poloje Lubba aremje ddew are ema ke da-rɔm njaa mungu nje-me-kunnje nya key-kula te ngaa bbo da ta tɔlde a, m-ndiki te tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Maw mande key-mbɔn naa te lede ke ndɔ ndɔ maw mula kemde ndoo. Maw muwade ke singa mare n̂-tajije ri Jeju. Bbo wungu ɔm boy a, m-ndole gode ndereng dɔ bbe te ke ddang.» ");
INSERT INTO ksp_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Mare ndɔ tɔku nje-poloje Lubba aremje ddew kare maw Damase ke ride maw muwa nje-me-kunnje. ");
INSERT INTO ksp_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Tɔku mbayje, mee ddew-bô maw maw ngaa kare ar danna a, moo mare lo-kare in darâ uru dɔm te ke nje-buwa lo-kawje lem. Lo-kare le uta ndoko le kare. ");
INSERT INTO ksp_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Toke jeje tɔyn n̂-tee joso nangê a, moo mare ndu dew pa tar arem ke tar arameyen na: ‹Sɔl! Sɔl! Mba ddi bba e-dda sem singa wa? A to ngeng sei nya ta dda singa toke da ke ebbeeje ɔse ke kake a, aw dda dingaw.› ");
INSERT INTO ksp_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Milae te na: ‹Ei na wa? Ebbe-dewje.› Ebbe-dewje pa na: ‹Ema Jeju a aw dda sem singa ann. ");
INSERT INTO ksp_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","A in ar taar. Gel ne ke m-tee mingai ne toke be: M-tee mingai kare e-tel to nje-kula lem ddem, kare e-pa tar koo ke oom neenn are dewje ddem, ngaa ta kare ila mber neje ke ma tɔji bbay. ");
INSERT INTO ksp_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ma kɔri me ji Jiipije te, ke me ji dewje te ke toje to Jiipije ang ke mulai ke rɔde te. ");
INSERT INTO ksp_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Mulai rɔde te kare e-teyn kemde ta ɔrude lo-ndul te e-tee ke de lo-kare te. Kare ɔrude ji Satan te ke ɔn dɔde e-ddee ke de rɔ Lubba te. Yeenn bba Lubba a kɔru tar majang lede dɔde te ngaa da kingaje lo horo dewje te ke ooje mede te sem ngaa majije tɔyn.› » ");
INSERT INTO ksp_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Tɔku mbayje Agiripa, mba yeenn a, m-tusu ne ke in darâ ke moo toke le nijeenn le minya m-dda ne ke dang ang. ");
INSERT INTO ksp_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","A dewje ke Damase, ke Jurusalam a mila mber-tar neenn marede dɔngɔr. Goe te a, mila mbere mare dewje ke Jude te, ke dewje ke toje to Jiipije ang. M-pa marede kare n̂-turuje mede ta daaje lo ke rɔ Lubba te ngaa ta n̂-ddaje ne ke tɔju to n̂-turuje mede mban. ");
INSERT INTO ksp_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Mba tar neenn le a Jiipije uwamje ne kare te ke me ne key-polo-Lubba te ngaa n̂-sangeje ddew ta tɔlemje. ");
INSERT INTO ksp_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","A Lubba njaa ngemem ndereng bbokone, are nɔ dewje te tɔyn, nje ke ten, wase nje ke bo kara m-nayn maw m-pa tar-naji laa bbay. Ne ke a ta ddee ke nje-kilaje mber-tar le Lubba, ke Moyije paje tare le njaa maw m-pa. Mila mare ne dɔe te ang. ");
INSERT INTO ksp_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","N̂-paje na Kiriste a koo ndoo. Na to dɔngɔr dew ke a kin horo nje-yoje te ngaa na kila mber lo-kare kare Jiipije ke dewje ke toje to Jiipije ang.» ");
INSERT INTO ksp_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pɔl nayn aw ɔru naji laa baann a, Pesutusu uru ekii na: «Pɔl, e-to nje-wooy! Neje ke e-ndo nya le ilai wooy te!» ");
INSERT INTO ksp_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","A Pɔl pa na: «Pesutusu, dew ke bo, mayn wooy ang. Tar ke tɔkɔrɔ, ke tar kem-kare a maw m-pa. ");
INSERT INTO ksp_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Tɔku mbayje Agiripa oo tarje neenn kete mban are ma kase pa tar neenn nɔe te ke bbeel ang. M-gere to n̂-gere nejeenn tɔyn, mba nejeenn le teeje lo kiyae te ang. ");
INSERT INTO ksp_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Tɔku mbayje Agiripa, tar ke nje-kilaje mber-tar le Lubba paje le e-ndiki te wa? M-gere to e-ndiki te njaa.» ");
INSERT INTO ksp_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agiripa pa are Pɔl na: «Oo to a dda kare m-to nje-koo-mete ke ngɔru baa be wa?» ");
INSERT INTO ksp_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pɔl pa are na: «Ke bbasine neenn wase ke lew kara, ma duju Lubba kare ei ddem, esee dewje tɔyn ke aw ooje tar lem bbokone neenn ddem e-ddeeje toke lem. A ta kula njamji a n̂-tɔ ne se ke toke be ang.» ");
INSERT INTO ksp_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Tɔku mbayje Agiripa ddem, tɔku-mbay Pesetusu ddem, Berenise ddem, ke dewje ke isije ke de inje taar. ");
INSERT INTO ksp_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Dɔruje rɔde ke guku ngaa n̂-paje tar horode te na: «Dingaw neenn dda mare ne ke ase yo wase mare ne ke ase kilae ne key-kula te kara ang.» ");
INSERT INTO ksp_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agiripa pa are Pesutusu na: «Bbo dingaw neenn duju ta kaw nɔ tɔku mbayje te ke Rɔm ang a, ja kinyae.» ");
INSERT INTO ksp_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Toke dunn ndu kare junn tɔku to jaw Itali a, dinya Pɔl, ke mare dewje ke duwade me ji tɔku-mbay te le mbambaje ke Rɔm ke ria na Juliyusu. Dunda ri mbambaje le na « mbambaje le tɔku mbayje.» ");
INSERT INTO ksp_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Junn tɔku to ke Adaramiti ke a ta kaw bbeje te ke Aji ke tɔku toje aw arje te ngaa jaw. Aristarke ke to dew ke Tesalonike nange te ke maseduwann aw ke je. ");
INSERT INTO ksp_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ndɔ kara goe te a, n̂-tee Sidɔn. A Juliyusu ke aw dda Pɔl maji le, inyae are naw rɔ nje-buwa-kuraje te laa mba kare dareje mare neje ke due. ");
INSERT INTO ksp_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Jin keteenn a, junn ddew ke tee giri Sipere te, mba yel aw tila kemje. ");
INSERT INTO ksp_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","N-gange ba-kate ke to mbɔr Silisi, ke Pampili te ngaa n̂-tee Mira nange te ke Lisi. ");
INSERT INTO ksp_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Keteenn, tɔku-mbay le mbambaje le oo mare tɔku to ke Alekejandiri ke aw ke Itali ngaa, areje jaal. ");
INSERT INTO ksp_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Jaw jann jann baa ndɔ banya ngaji are n̂-dda to kula ddaje bba n̂-tee Kinide. A yel ɔkuje ddew kare n̂-nday ke ddew ke junn le. Yeenn a, n̂-nday mbɔr Kerete te er ke Salemɔnne. ");
INSERT INTO ksp_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","N-dda to dda bba n̂-nday mbɔr dɔ dere ba te le ngaa n̂-tee lo te ke daw n̂-bbar na « lo ke maji ke tɔku toje aw arje te». Lo le to ngɔsi ke Laje. ");
INSERT INTO ksp_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","A ndɔ nday nya ngaa are nja dɔ maann te to ne-bbeel nya, mba ndɔ mbete ne-kusa ke dɔ neyn te nday mban. Yeenn a, Pɔl ndeje nje-yelje tɔku to le na: ");
INSERT INTO ksp_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Ngakɔmje, moo a, lo-kaw leje neenn a maji ang. Tɔku to le ddem ne-kotoje ddem a tujuje nya. Jeje njaa kara jeeje ta yo te tɔ.» ");
INSERT INTO ksp_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","A, tɔku-mbay le mbambaje le ndiki ta koo tar le nje-yel tɔku to le, ke tar le nje-tɔku to le uta ndeje le Pɔl. ");
INSERT INTO ksp_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Tɔ bbay, lo-kar le tɔku tojeenn le to lo ke maji kare dew isi te neyn kul te ang. Mba yeenn a, nya le dewje ke me tɔku to te le ndikije ta kɔtu lo teenn le. N̂-ndiki kare ddew to a, n̂-teeje Penikese, ke to lo-kar le tɔku toje ke Kerete. Lo le aa lo ke dagoo ddem beer ddem er ke lo kande te le kare, ta kisi teenn kare neyn̂-kul nday dɔde te. ");
INSERT INTO ksp_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Mare yel ke ula ke singa ang in dagoo a dewje ke me tɔku to te le ejeje to da kaw teeje lo te ke dundaje mede ta tee te le. Yeenn bba dɔruje tɔku ande ke daw dila maânn kare to le nja ang ngaa n̂-sangeje ddew mba kuwa kare ba ke Kerete. ");
INSERT INTO ksp_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","A njange njange baa, mare bamburanbo ke dunda ria na «Erakilɔn» in er dɔ dere ba te le ingade. ");
INSERT INTO ksp_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Bamburabo le unn tɔku to le ta kaw ne are ddew ke ja nar ne to le goto ngaa dinya jare to le aw ke je. ");
INSERT INTO ksp_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","N-nday giri ngonn dɔ-dere ba te ke ria na Koda. N-dda to kula ddaje bba juwa ngonn to ke n̂-tɔ mbɔr tɔku to te le mba kaji ne nje ke maann a ta kuwade. ");
INSERT INTO ksp_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Nje-yelje tɔku to le unnje ngonn to ilaje me tɔku to te le ngaa tɔje tɔku to le ke kula. N̂-bbeelje mba kare tɔku to le aw ar ke de dɔ enangara te ke Libi. Yeenn a, dunnje mare ne ke ɔɔy ke n̂-tɔ tɔku to te le dilaje maânn ngaa dinyaje dare tɔku to le aw ke de. ");
INSERT INTO ksp_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Bamburabo le yekeje ke singa nya. Yeenn bba lo are a, dunnje kutu tila ne-kotoje maânn. ");
INSERT INTO ksp_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ndɔ muta laa a, dede njaa dotoje ne-kulaje ke me tɔku to te le ke jide n̂-tilaje maânn. ");
INSERT INTO ksp_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ndɔ banya nya dew oo kem kare ang ddem, oo endenterendenje ang ddem. Bamburabo le aw yeke lo to bbeel nya. Jeje to ja kaji ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Dewje ke me tɔku to te le usaje ne ang ndɔ banya. Yeenn ngaa Pɔl ar taar nɔ dewje te le tɔyn ngaa pa na: «Namdede, bbo ooje tar lem ngaa areje naynje Kerete a, neje a tujuje be ang ddem, neje a naynje be ang ddem. ");
INSERT INTO ksp_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","A ke bbasine neenn, m-pa marese: E-bbeelje ang, mba dew kara horose te a koy ang. Tɔku to le kara baa njaa a tuju. ");
INSERT INTO ksp_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Til te neenn, Lubba ke m-to dew laa ngaa maw dda saa are mare anji laa tee ingam, ");
INSERT INTO ksp_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ngaa pa arem na: ‹E-bbeel ang Pɔl. Maji kare ar nɔ tɔku mbayje te ke Rɔm are gange sariya lei. Lubba a ngem dewje tɔyn ke eeje sei me tɔku to te neenn wɔju dɔi.› ");
INSERT INTO ksp_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Yeenn a, uwaje are ngeng, nje-buwa-kuraje lem! Munda mem dɔ Lubba te. Na dda ne ddew kara baa toke n̂-pa narem. ");
INSERT INTO ksp_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Tɔku to le a kaw kar ke je ta mare dɔ-dere ba te.» ");
INSERT INTO ksp_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","To til dɔku gire sɔ laa a bamburanbo le aw yekeje dɔ tɔku ba kate te ke Mediterane teenn. Lo aw to mɔngu yenene a, nje-yelje to le ooje toke ne ke jaw n̂-tee ngɔsi ke nange. ");
INSERT INTO ksp_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Dilaje kula ke n̂-tɔ ande ke ɔɔy gele te maânn mba gere ne kuru laa ngaa dingaje kilometere dɔmuta gire siri. Daw ngaji ngaa n̂-telje dilaje bbay a, dingaje kilometere dɔjoo gire jijoo. ");
INSERT INTO ksp_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","N̂-bbeelje kare tɔku to le unda er ang. Yeenn a, dunguje ande-nareje ke ɔɔy sɔ maânn kutu tɔku to te le kare nja ang ngaa n̂-ndingaje kare lo are ke tɔke. ");
INSERT INTO ksp_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Kare teenn, nje-yelje tɔku to le sangeje ddew ta tee me to te le kaynje. Dunnje ngonn to dilaje maânn ngaa dereje gusu to na ta tilaje ne ande-nareje ke ɔɔy nɔ tɔku to te le. ");
INSERT INTO ksp_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Yeenn a, Pɔl pa are tɔku-mbay le mbambaje, ke mbambaje le na: «Bbo dingawje neenn naynje me tɔku to te neenn ang a, a kajije ang.» ");
INSERT INTO ksp_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Yeenn a, mbambaje le gangeje kulaje ke n̂-tɔ ne ngonn to le ngaa dinyaje dare aw. ");
INSERT INTO ksp_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Kete bba kare lo are a, Pɔl ndeje dewje tɔyn kare usaje ne. N̂-pa na: «Ndɔ dɔku gire sɔ bbokone ke aw ngebbeje kare dɔ maann to ddekeke ngaa usaje ne ang. ");
INSERT INTO ksp_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Yeenn a, m-dujuse kare usaje ne mba kisi ne ke tebbe. M-pa marese bbay to ben dɔ mare dew kara horose te a koso nangê ang.» ");
INSERT INTO ksp_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Go tarje teenn a, nunn mapa, nare wooyo Lubba kem dewje te tɔyn, n̂-tete ngaa nunn kutu kusa. ");
INSERT INTO ksp_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Yeenn ngaa dewje tɔyn ingaje singa ngaa usaje ne tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Kɔrje tɔyn ke jisi me tɔku to te le to kɔr joo ke dɔsiri gire misan. ");
INSERT INTO ksp_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Goe te ke jusa ne jare meje ndann a, n̂-tila bbɔl beleje maânn jare tɔku to le ɔle. ");
INSERT INTO ksp_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Toke lo are a, nje-yelje to le ooje dɔ nange a gereje ang. Dooje ta maann ke to enangara. Yeenn ngaa, n̂-ndikije ta bbo ddew to a, kaw ke tɔku to le tae te. ");
INSERT INTO ksp_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Mba yeenn a, n̂-tutuje kula ke n̂-tɔ ne ande-nareje ke ɔɔy le dare osoje me maann te. Kare teenn njaa tɔ a n̂-tutuje kula neje ke aw tɔjuje ddew tɔku to le. Goe te a, n̂-tɔje kubbu nɔ tɔku to te le kare ta yel uta ne tɔku to le ngaa dunnje ddew er ke dɔ enangara te le. ");
INSERT INTO ksp_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Daw n̂-teeje dɔ enangara te ke tee dann maann te ke uru ngaa uwa tɔku to le ar ne lo kara. Nɔ tɔku to le ande me enangara te are ddew ke na ngese ne goto. Maann lenge ngaa unda kutu to le ke singa are tete. ");
INSERT INTO ksp_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Mbambaje ndikije ta tɔlje dewje ke duwade le na kare mare kara ale maann tee ayn. ");
INSERT INTO ksp_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","A tɔku-mbay le mbambaje le ndiki ta kaji Pɔl are nɔkude ddew kare n̂-ddaje ne toke baann. Nare ddew dewje ke gereje maann kare gaynje maânn dɔngɔr ta aleje teeje ddaka. ");
INSERT INTO ksp_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Kese dewje a naaje kare kakeje te, ke gaji tɔku to ke guru le mba kɔru gode. N-dda toke baann ngaa jeje tɔyn n̂-tee ddaka ke rɔ ke maji. ");
INSERT INTO ksp_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Go yo te ke n̂-tee tae te bba n̂-pa dareje na ri dɔ dere ba le to Malte. ");
INSERT INTO ksp_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Nje-bbeje le taaje ke maje nya. N̂-yelje tɔku puru ngaa n̂-bbarje dare n̂-ndibbi mba ndi unn kutu ta kere are kul ɔn nya. ");
INSERT INTO ksp_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pɔl oto ngann ngew ungu puro. A li tee me te mba puru le ɔbbe ngaa n̂-tɔn ji Pɔl n̂-tinya te. ");
INSERT INTO ksp_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Toke nje-bbeje le ooje li ke naa ji Pɔl te le a, n̂-paje tar horo naa te na: «A du ang dingaw neenn to nje-tɔl dewje. Maann a ta kuwae bba tee tae te. A ne ke gate gate a kinyae kare n̂-nayn kem ang.» ");
INSERT INTO ksp_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Pɔl tusu li le are oso puro. A ne kara njaa dda Pɔl ang. ");
INSERT INTO ksp_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Nje-bbeje le aw ngebbeje ta koo rɔe ke a ti wase koso ke na koso wate koy. A n̂-ngebbeje pin dooje mare ne kara ke dda Pɔl ang. Yeenn a, n̂-telje n̂-turuje ndude na: «N̂-to mare lubba.» ");
INSERT INTO ksp_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ngɔsi baa keteenn, lo le mare tɔku dew ke dɔ dere ba te le ke ria na Pubiliyusu ee teenn. Nuwaje ke rɔe te ke maje ngaa n̂-to rɔe te ndɔ muta. ");
INSERT INTO ksp_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Bɔ Pubiliyusuje le to tuwa rɔ-tɔ te. Rɔe tunga nya ddem n̂-ndenge mese ddem. Pɔl aw ooe, duju Lubba dɔe te, ila jia dɔe te ngaa naji. ");
INSERT INTO ksp_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Goe te a, mare nje-bbeje ke Malte ke rɔde tode ddee ooeje ngaa rɔde ddee maji tɔ. ");
INSERT INTO ksp_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Nje-bbeje le waljeje nya ngaa kare te ke ja ta kunn tɔku to a, dareje neje ke a kumaje ddew-bô. ");
INSERT INTO ksp_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Go neyn muta te ke n̂-dda a, junn tɔku to ke in Alekejandiri. Ri tɔku to te le na « lubbaje ke toje to ndungaje». Tɔku to le ar teenn kare neyn kul nday bba ta kɔtu. ");
INSERT INTO ksp_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","N-tee Sirakusu a, n̂-dda ndɔ muta. ");
INSERT INTO ksp_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Jin teenn a, juwa kare mbal n̂-tee Rejiyo. Lo are a, yel ke dagoo ula nya ngaa ndɔ joo a, n̂-tee Pujɔl. ");
INSERT INTO ksp_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Jinga mare ngakɔnje me bbe teenn ngaa n̂-dujuje kare n̂-dda ndɔ siri rɔde te. N-dda toke baann bann a jaw ne Rɔm. ");
INSERT INTO ksp_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Ngakɔnje ke Rɔm ooje tar leje ngaa tilaje kemje ndereng ingajeje lo ne-labbe te ke Apiyusu, ke bbe ke to key-to-mbaje te ke muta. Toke Pɔl oode a, are wooyo Lubba ngaa tel inga singa. ");
INSERT INTO ksp_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Toke n̂-tee Rɔm a, dare ddew Pɔl kare uwa key laa dang. Dunn mare mbamba kara kare ngeme. ");
INSERT INTO ksp_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ndɔ muta goe te a, Pɔl bbar tɔku dewje le Jiipije ke isije me bbe te ke Rɔm ta key te laa. Toke n̂-mbɔnje naa a, n̂-pa narede na: «Ngakɔmje, m-dda mare ne ke maji ang ke dewje leje ang ddem m-mbete ne-ji-bbe le kajeje ang ddem. A duwam Jurusalam ngaa dinyam me ji dewje te ke Rɔm. ");
INSERT INTO ksp_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Go tar te ke nje ke Rɔm dujumje ooje tɔyn a, n̂-ndikije ta kinyamje mba dooje mare tar dɔm te ke a kase kare n̂-tɔlumje ne ang. ");
INSERT INTO ksp_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","A Jiipije mbeteje. Mba yeenn a, m-duju ta ddee ke tar lem nɔ tɔku mbayje te ke Rɔm, bbo to tar a m-ndiki ta kunda dɔ dewje te ke bbê lem te. ");
INSERT INTO ksp_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Wɔju dɔ tar neenn njaa m-duju ta koose, ta tɔn ke se tam. Ma kerese ang, n̂-tɔm ke kula njamjije neenn wɔju dɔ tar ne ke dewje ke Ijarayel undaje mede dɔe te.» ");
INSERT INTO ksp_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Dilaeje te na: «Jinga mare maketuru ke in nange Jude te dɔi te ang ddem, mare ngakɔnje kara ddee pa tar dɔi te areje ang ddem wase pa tar lei maji ang areje ang ddem. ");
INSERT INTO ksp_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","A jaw n̂-duji kare ei njaa ɔru gel ne ke aw eje areje, mba n̂-gere to loje te tɔyn dewje aw mbeteje kuwa-dɔ-naa ke ee me te neenn to mbete dɔrɔ.» ");
INSERT INTO ksp_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Dɔjuje ndɔ dareje ngaa ndɔe le ase a, n̂-ddeeje toke banya dingaeje lo toe te. Ke endɔɔ ndereng lo-kul Pɔl pa tar arede. N̂-pa tar kɔn̂-bbe le Lubba narede. Nunn tar ndu le Mɔyiji, ke tar le nje-kilaje mber-tar le Lubba n̂-pa ne tar le Jeju kare n̂-ndikije te. ");
INSERT INTO ksp_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Mareje ndikije te saa, a mareje mbeteje. ");
INSERT INTO ksp_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Horode te tar lede aw naa te ang ngaa kare te ke da ta kɔtuje a, Pɔl pa tar kara na: «Tar ke Ndil-me-nda pa are kajeje ddew te le Nje-kila mber-tar le Lubba Ijayi neenn to tar ke tɔkɔrɔ. Ndil-me-nda pa na: ");
INSERT INTO ksp_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‹Aw inga dewje neenn e-pa arede e-pa na: a kooje tar ke maje, a a gereje kande tar le ang, a kooje loo ke maje, a a kooje ne ang. ");
INSERT INTO ksp_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Mba me dewje le ketere, dutuje mbide, n̂-bbirije kemde baann bba ta kare kemde oo lo ang ddem, ta kare mbide oo tar ang ddem, ta gere ne ang ddem mba n̂-ndikije ta telje rɔm te kare majide ang.› » ");
INSERT INTO ksp_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pɔl pa arede bbay na: «Maji kare e-gereje. Lubba ula ke tar kaji neenn are dewje ke toje to Jiipije ang. Dede da ndikije tar te le.» ");
INSERT INTO ksp_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Go tar te ke Pɔl pa le a, Jiipije maynje naa tar ɔtuje ne. ");
INSERT INTO ksp_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pɔl dda bbal joo kakara key te ke nuka ke nare laa njaa. Naw taa dewje tɔyn ke ddeeje aw ooeje ke rɔe. ");
INSERT INTO ksp_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","N̂-tɔju tar kɔn̂-bbe le Lubba ngaa n̂-tɔju ne dɔ Ebbe-dewje Jeju Kiriste te ke bbeel ang. Mare dew ɔke ddew ang. ");
INSERT INTO ksp_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","Ema Pɔl ke Lubba ke Nje-dekajije, ke Jeju Kiriste ke jundaje meje dɔe te a daremje ddew kare m-to nje-kayn-kula le Jeju Kiriste, m-dda maketuru neenn mari. ");
INSERT INTO ksp_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","M-dda maketuru neenn mari ei Timote ke e-to ngonnum ke tɔkɔrɔ, mba oo mei te ke Kiriste. Maji kare Lubba ke Bɔ, de ke Jeju Kiriste ke to Ebbejeje n̂-ddaje sei me-maji, dooje kem-to-ndoo lei ngaa darije me-wul-lɔm. ");
INSERT INTO ksp_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","Maji kare e-nayn bbe te ke Epeje ddew kara baa ke ndu ke munn mari kare te ke maw ne ke Maseduwane. Me bbe te ke Epeje le, mare dewje aw tɔjuje ne ke dɔgɔle ang. Maji kare ta e-gangede ddewe te. ");
INSERT INTO ksp_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","E-pa are nje-ne-tɔjuje ke ke dɔgɔle ang le are dɔru keje lede dɔ gel neje te ke lew ke to ke ddewe ang, ke tar kɔru gel kadede ke ngal nya ngaa kɔen goto. Nejeenn aw ddeeje ke mayn naa tar baa bbo dda me-kara ke ne ke Lubba mɔse wɔju dɔje ang. Dew a gere ne ke Lubba mɔse le ddew me-kunn te. ");
INSERT INTO ksp_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","Ne ke maw m-sange ddew ndu te ke munn neenn to kare e-ndikije naa ke me ke nda, kare eeje ke keje ke maji, kare ooje mese te tɔkɔrɔ ke Lubba. ");
INSERT INTO ksp_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","Mare dewje ke inyaje ddew nejeenn le ndeemje ddew ngaa aw undaje bula baa. ");
INSERT INTO ksp_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","N̂-ddaje rɔde to nje-tɔjuje ndu le Lubba ke are Moyije, a n̂-gereje gel tar ke daw n̂-paje le ang. Tar ke darje dɔe te le kara n̂-gereje gele ang ddem. ");
INSERT INTO ksp_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","N-gere to ndu to ne ke maji toke dew dda kula ke turu ndu le. ");
INSERT INTO ksp_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","N-gereje to dew ke gate gate a ndu to wɔju dɔe ang. A ndu to wɔju dɔ nje ke mbeteje ndu, nje-dɔ-ketereje, ke nje ke mbeteje Lubba, nje-ne-ddaje ke maji ang, ke nje ke bbelje Lubba ang ddem bbelje ne le Lubba ang ddem, nje-tɔlje bɔdede wase kɔndede, ke nje-tɔlje ngamaredeje, ");
INSERT INTO ksp_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","nje-ddaje lo-to majang, ke dingawje ke aw ddaje lo-to ke dingaw maredeje, ke nje-labbeje dewje to bbereje, ke nje-ngemje, ke nje ke aw undaje-yo baa wase dewje ke ddaje ne tɔyn ke to dang ke ne-tɔju ke tɔkɔrɔ. ");
INSERT INTO ksp_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","Ne-tɔju ke tɔkɔrɔ le to me Tar te ke Maji ke areje ddew ta kare n̂-gereje Lubba ke ase kare dewje ɔsuje gaje. Lubba ke ndiki ta kare jisije maji le njaa inya Tar ke maji le me jim te. ");
INSERT INTO ksp_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","Mare wooyo nya Ebbejeje Jeju Kiriste ke arem singa: Noom to mare dew ke na kase ta kunda mee dɔe te ngaa n̂-bbarem kula te laa. ");
INSERT INTO ksp_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","A ema ke lew m-to nje-tuju ria, nje-dda singa ke dewje laa, nje-dda saa ddɔ. Lubba oo kem-to-ndoo lem, mbata kete moo mem te saa ang are m-gere dɔm ne te ke m-dda le ang. ");
INSERT INTO ksp_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","Ebbejeje Lubba dda sem me-maji ke bo nya. Nare moo mem te ngaa nare m-ndiki ngamaremje ddew me-kara te ke m-dda ke Jeju Kiriste. ");
INSERT INTO ksp_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","Tar neenn to tar ke tɔkɔrɔ, maji kare dewje tɔyn taaje tar neenn ngemje mede te: Jeju kiriste ddee dɔ nange te mba kaji nje-ddaje majang. Ma njaa m-to dew ke dda majang uta kese dewje tɔyn. ");
INSERT INTO ksp_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","A bbo Lubba oo kem-to-ndoo lem a, n̂-ndiki ta tɔju to n̂-tɔ wure wɔju dɔm, ema ke m-to dew ke dda majang uta kese dewje tɔyn le. N̂-dda baann mba kare dewje ke a ta kooje mede te saa ta kinga ne tebbe ke ke ndɔ ke ndɔ oomje to ne-kɔju mare. ");
INSERT INTO ksp_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","Ase kare dewje tɔyn ndɔyje ri Lubba ngaa ɔsuje gaji Lubba ke bbal ke bbal! Lubba ke nje-kisi ke ndɔ ke ndɔ, Lubba ke kem dew ooe ang, Lubba ke kara baa, Amem. ");
INSERT INTO ksp_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","Ngonnum Timote, ndu ke maw minya me jii te neenn to ddew kara baa ke tar ke *nje-kilaje-mber-tar le Lubba paje wɔju dɔi lew. Maji kare tarje neenn ari singa are e-dda ne ddɔ ke maji, ");
INSERT INTO ksp_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","ddew kunda mei dɔ Lubba te, ke ddew ngem keje ke maji te. Mare dewje ke ooje mede te mban ngaa eeje ke keje ke maji le telje inyaje keje ke maji le ngaa dosoje ddew me-kunn te lede. ");
INSERT INTO ksp_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","Imene de ke Alekejandere deeje horo dewje teenn le. Minyade me ji Esu te kare ta n̂-ndoje ta tel taji Lubba ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","Yeenn a, ne ke m-ndejese ta kare e-ddaje dɔngɔr a to kare dewje dujuje ne ji Lubba te, paje tar ke Lubba, ddaje rɔde to ndoo nɔ Lubba te ngaa telje ke wooyo are Lubba wɔju dɔ dewje tɔyn. ");
INSERT INTO ksp_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","Maji kare e-dujuje Lubba wɔju dɔ tɔku-mbayje, ke nje-kɔn̂-bbeje. Baann bba ja kisije ddekeke, ja kisije ke me-wul-lɔm ddew bbel Lubba te ddem ta wal Lubba ddem. ");
INSERT INTO ksp_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","Yeenn a to ne ke kura ngaa maji nya kem Lubba te ke Nje-kajije, ");
INSERT INTO ksp_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","Lubba ke ndiki kare dewje tɔyn ingaje kaji ddem, ndiki kare dewje tɔyn gereje ne ke tɔkɔrɔ ddem. ");
INSERT INTO ksp_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","Mba Lubba kara baa, *nje-gɔl tar horo Lubba te ke dewje kara baa tɔ. N̂-to dew, Jeju-Kiriste, ");
INSERT INTO ksp_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","ke unn rɔe uka ne dɔ dewje tɔyn. Kare ase a, Kiriste pa tar naji le toke baann. ");
INSERT INTO ksp_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","Mba yeenn a, Lubba undam to nje-kila mber, ke nje-kayn-kula kare m-tɔju tar me-kunn, ke tar ke tɔkɔrɔ dewje ke toje to Jiipije ang. Tar ke tɔkɔrɔ a maw pa neenn bbo maw mere ngem ang. ");
INSERT INTO ksp_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","Yeenn a, m-ndiki ta kare dingawje dujuje Lubba ke lo tɔyn, dulaje jide ke darâ ke me ke nda kayn, ke wungu ang ddem ke mayn̂-tar ang ddem. ");
INSERT INTO ksp_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","Ddew kara baa, m-ndiki kare deneje ulaje kubbu ke maje, dulaje kubbu dare kem dewje to ke dɔde te ang, n̂-ddaje mande ke boro ang: N̂-ddaje dɔde ke dɔgɔle, dulaje ne-mandeje ke n̂-dda ke ande ang wase mere wase kubbu ke nare ngeng nya ang. ");
INSERT INTO ksp_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","A maji kare kulaje ke maji a deneje ulaje to kubbu. Ne ke baann a ase kare deneje ke unnje ndude ta bbel Lubba ddaje. ");
INSERT INTO ksp_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","Kare ne-tɔju a, maji kare deneje isije ddekeke ngaa ta dooje tar. ");
INSERT INTO ksp_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","Mare ddew dene ta kare tɔju ne wase ɔn dɔ dingaw ang. Maji kare dene utu tae. ");
INSERT INTO ksp_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","Mba Adam a Lubba ddae dɔngɔr bba goe te a n̂-dda Ebe. ");
INSERT INTO ksp_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","Adam a are Esu ere ang. A dene a inya are Esu ere ngaa oso me majang te. ");
INSERT INTO ksp_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","A Lubba a kaji dene ddew kuju ngonn te, toke noo mee te ke Lubba, toke n̂-ndiki dewje, toke n̂-ngem rɔe ngaa n̂-dda rɔe ngaji. ");
INSERT INTO ksp_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","Tar neenn to tar ke tɔkɔrɔ. Toke bbo mare dew ndiki ta ddee to nje-kula le Lubba a, to kula ke maji nya njaa a n̂-ndiki ta dda. ");
INSERT INTO ksp_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","Baann a, maji kare n̂-to dew ke tar to dɔe te ang, n̂-to nje-dene ke kara, n̂-to dew ke ngem rɔe, n̂-to dew ke gere dɔ jia, n̂-to dew ke dda ne ke ddewe, dew ke gere ngem nje-mbaje, dew ke gere ta tɔju ne. ");
INSERT INTO ksp_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","Maji kare n̂-to bbere le koto ang, n̂-to nje-kunda dew ang, n̂-to dew ke wul pee, n̂-to dew ke ndiki kɔl ang, n̂-to dew ke ndiki nare nya ang. ");
INSERT INTO ksp_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","Maji kare n̂-to dew ke gere ta tɔju ddew ke maji nje ke me key te laa, n̂-to dew ke dda are nganne ooje tae ngaa bbeleje. ");
INSERT INTO ksp_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","A bbo dew gere ta kɔn dɔ nje ke me key te laa ang a, na ngem Egilise toke baann wa? ");
INSERT INTO ksp_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","Maji kare nje-kula le lubba to dew ke oo mee te ke Jeju goe ew bba. Baann ang a, na koo rɔe bo nya ngaa Lubba a gange sariya dɔe te ddew kara baa toke n̂-gange sariya dɔ Esu te. ");
INSERT INTO ksp_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","Maji kare dewje ke toje to nje-me-kunnje ang paje tar laa maji. Baann bba na koso me bande te le Esu kare ta rɔ-kul ddae ang. ");
INSERT INTO ksp_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","Ddew kara baa, maji kare diyakereje toje to dewje ke ulaje gel rɔde naa te ang, dewje ke ndude joo ang, n̂-toje to nje-kayje koto nya ang, maji kare n̂-toje dewje ke aw sangeje ta kinga nare-bukuru ang. ");
INSERT INTO ksp_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","Maji kare n̂-ngemje tar me-kunn ke Lubba tee ne ke ddaka le ke keje ke maji. ");
INSERT INTO ksp_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","Maji kare n̂-nade doo kete bba ngaa goe te bbo mare tar to dɔde te ang a, da kaseje ta ddaje kula le. ");
INSERT INTO ksp_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","Maji kare dene njeeje kara ulaje gel rɔde naa te ang, n̂-toje to nje-naneje ang, n̂-ngemje rɔde. N̂-to deneje ke toje gate gate ddew neje te tɔyn. ");
INSERT INTO ksp_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","Maji kare diyakereje le toje to nje-deneje ke kara. Maji kare n̂-gereje ta tɔju ddew ke maji ngannde, ke dewje tɔyn ke me key te lede. ");
INSERT INTO ksp_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","Mba diyakereje ke aw ddaje kula lede ke maje a kingaje piti ta dewje te tɔyn ngaa da paje tar me-kunn lede ke to ke dɔ Jeju te ke bbel ang. ");
INSERT INTO ksp_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","Kare te ke maw m-dda ne maketuru mari neenn, munda mem ta kaw kingai mbɔr ang baa. ");
INSERT INTO ksp_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","A bbo m-ddee ke tɔke ang a, ndejeje ke mari neenn a kari ddew kare e-gere ddew ke a nja ne horo dewje te le Lubba. Dewje le Lubba le to Egilise le Lubba ke Nje-kisi kem baa. Nje-me-kunnje le toje to nje-kuwaje tar ke tɔkɔrɔ kare ngeng. ");
INSERT INTO ksp_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","Tɔkɔrɔ njaa, tar me-kunn ke iya rɔe ngaa n̂-tee ne ke ddaka le to ne ke ngeng nya. Tare le toke be: Kiriste unn da rɔ dew, Ndil me-nda pa tar naji laa na n̂-to gate gate, anjije ooeje, dewje pa tar laa horo dewje te ke toje to Jiipije ang, dewje ke dɔ nange te unnje mede are, Lubba unne aw saa lo piti te laa darâ. ");
INSERT INTO ksp_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","Ndil-me-nda pa tɔkɔrɔ na, ddutu ndɔɔje a, mare dewje a kinyaje ddew me-kunn mba naynje go ndilje te ke nje-ngemje ngaa da kunnje go ne-tɔju le umaje. ");
INSERT INTO ksp_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","Dewjeenn le ndemje ddew wɔju dɔ tar le nje-ngemje. Nje-ngemje le ndil ne-gere lede oy toke mare le kake ke tebbe ke puru wae. ");
INSERT INTO ksp_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","Nje-ngemje le tɔjuje ne na: taa-naa wase kusa mare ne-kusaje to kula ke maji ang. A Lubba dda ne-kusajeenn mba nje-me-kunnje ke gereje ne-tɔju ke tɔkɔrɔ. Maji kare dareje wooyo Lubba mban a dusaje. ");
INSERT INTO ksp_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","Mba neje tɔyn ke Lubba dda maji to maji dɔrɔ. Ne ke ta mbete me te goto toke dew usa ke wooyo. ");
INSERT INTO ksp_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","Mba tar le Lubba, ke duju Lubba leje ddaje are ne-kusa le tel ne-kusa ke maji kem Lubba te. ");
INSERT INTO ksp_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","Toke e-tɔju neje ke m-pa mari neenn nje-me-kunnje a, a to nje-kula le Kiriste ke tɔkɔrɔ. Baann bba, a tɔju to e-to dew ke tar le Lubba ande ddew ne-tɔju te ke tɔkɔrɔ ke e-ndo ke rɔ-nel. ");
INSERT INTO ksp_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","Maji kare e-mbete esu ngemje ke dewje aw ɔruje ke to dang ke ne-tɔju le nje-me-kunnje. E-sange ddew ta to gate gate kem Lubba te. ");
INSERT INTO ksp_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","Ndam toke kayn̂-ngɔru to ne ke dda maji ke da-rɔ dew. A kunn rɔ kare Lubba to ne ke dda maji ke dew ddew neje te nya. Ddew kunn rɔ kare Lubba te, dew a kase kinga tebbe ke to ke ndɔ ke ndɔ. ");
INSERT INTO ksp_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","Tar neenn to tar ke tɔkɔrɔ, maji kare dewje tɔyn taaje ngemje mede te ke maje. ");
INSERT INTO ksp_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","Bbo jaw jooje ndoo wase jaw n̂-ddaje ddɔ a, mba kake jundaje meje dɔ Lubba te ke Nje-kisi kem baa. Lubba ke to Nje-kaji dewje tɔyn, ke uta tɔyn n̂-to Nje-kaji nje-koo-meteje. ");
INSERT INTO ksp_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","Neenn a, maji kare unn ndu dɔe te ngaa e-tɔjude. ");
INSERT INTO ksp_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","Maji kare dew dabbi mba kake e-to ngonn baa ang. A maji kare nje-koo-meteje ooije to ne-kɔju mare ddew tar te ke tai te, ddew kula ddai te, ddew ndiki te ke e-ndiki dewje, ddew mei te ke unn are Jeju, ke ddew rɔi te ke aw e-ngem ke maje. ");
INSERT INTO ksp_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","E-tura maketuru nya are dewje lo mbɔn̂-naa te e-ngina ne ndɔ ddee lem. Arede ndeje ngaa e-tɔjude ne. ");
INSERT INTO ksp_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","Lubba ari ne-kare baa. E-dda ngar ke ne-kare baa le ang. Lubba ari ne-kare baa le go tarje te ke nje-kilaje mber-tar le Lubba paje ngaa ansiyenje mbɔnje naa ilaje jide dɔi te. ");
INSERT INTO ksp_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","Neenn a, maji kare unda mei dɔe te. Maji kare unn rɔi ila kula te lei. Yeenn bba dewje tɔyn a kooje to kula lei aw ke kete kete. ");
INSERT INTO ksp_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","E-ngem rɔi ke maje, unda kemi dɔ ne-tɔju te lei. E-nayn ddewe te ke ndɔ tɔyn, mba bbo e-dda toke baann a, ei njaa a kaji rɔi ddem a kaji dewje ke aw ooje tar lei ddem. ");
INSERT INTO ksp_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","Maji kare e-ndeje dingaw ke bbuka toke le bɔije njaa bbo e-ndange ang. E-ndeje basanje toke le ngakɔinje. ");
INSERT INTO ksp_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","Maji kare e-ndeje kɔdeneje toke le kɔinjedede. E-ndeje deneje ke naynje ke singade bbay ke me-nda kayn ddew kara baa toke ngakɔnani. ");
INSERT INTO ksp_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","E-wal dene-ndubbaje ke isije ke karede. ");
INSERT INTO ksp_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","A bbo mare dene-ndubba ee ke nganne wase ngannkae a, dɔngɔr ne ke ta dda a to kare n̂-tɔjuje kula me-kunn lede horo nujuje te ngaa n̂-telje ke ne ke nje-kujudeje ngem ne de darede guku. Lubba ndiki ne ke baann nya. ");
INSERT INTO ksp_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","Dene-ndubba ke isi ke kare baa ngaa nje kaa lo ke dɔe te goto, unda mee ke dɔ Lubba te. New ta dda rɔe to ndoo rɔ Lubba te ang, n̂-duju ne ji Lubba te til, ke kare. ");
INSERT INTO ksp_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","A dene-ndubba ke unn rɔe mba rɔ-nel ke nange neenn isi kem baa ddew da-rɔ te, a ddew ndil te noy mban. ");
INSERT INTO ksp_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","Mare ne ke ta kare e-ndejede wɔju dɔe mba kare tar to dɔde te ang a neenn. ");
INSERT INTO ksp_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","Toke mare nje-me-kunn aa lo ke dɔ nje-nujuje te laa ang, uta tɔyn bbo naa lo ke dɔ dewje te ke me key te laa ang a, ninya me-kunn laa, ngaa n̂-maji ang nuta dew ke oo mee te ang. ");
INSERT INTO ksp_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","Dene-ndubba ke to nje-ngaw ke kara ke bbale uta bbal dɔ-misan bba ta e-dda ria horo mareje te. ");
INSERT INTO ksp_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","Maji kare ria bbar wɔju dɔ kula-ddaje ke maji: Maji kare n̂-to dew ke ngem nganne, dew ke ngem nje-mbaje, nje-toko gɔl nje-me-ndaje. Maji kare n̂-to dew ke aa dewje ke ne wungu oso dɔde te oo. Maji kare n̂-to dew ke dda mare kulaje ke maji dang dang. ");
INSERT INTO ksp_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","Maji kare e-dda ri dene-ndubba ke nayn ke singae bbay horo mareje te ang. Mba ndɔ ke bbo ke da-rɔ te ddade a, da kinya go Jeju kiriste ta taa ngaw. ");
INSERT INTO ksp_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","Kula-dda ke baann tɔju to dinyaje ndu ke dunnje dɔngɔr le. ");
INSERT INTO ksp_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","Tɔ bbay, mba dingaje kula ta dda ang le a, n̂-ndoje ta kase lo ke ta key ta key. Dɔe te, n̂-telje to nje-kundaje bula. Tar ke osode te ang kara dilaje tade te baa baa. Tar ke ase ta pa ang kara daw n̂-paje. ");
INSERT INTO ksp_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","Yeenn a, m-ndiki kare dene-ndubbaje ke naynje ke singade bbay taaje ngaw, maji kare dujuje ngannje. N̂-tɔjuje ddew ke maji nje ke me key te lede. Baann bba nje-baanji a kingaje ddew ta nane ke je ang. ");
INSERT INTO ksp_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","Mba mare dene-ndubbaje unnje go Esu ngaa n̂-ndemje ddew mban. ");
INSERT INTO ksp_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","Toke mare dene ke oo mee te ee ke dene-ndubbaje horo nujuje te laa a, maji kare numade. Baann bba dene-ndubbaje le a toje to ne-koto ke aw ɔy Egilise ang. Baann bba Egilise le a kinga ddew ta kuma dene-ndubbaje ke isije ke karede. ");
INSERT INTO ksp_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","Ase kare ansiyenje ke tɔjuje ddew ke maji ingaje kuka ke bo. Ke uta tɔyn dede ke kula pa tar le Lubba, ke kula ne-tɔju ɔyde nya. ");
INSERT INTO ksp_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","Maketuru le Lubba pa na: Mange ke aw mbɔyn jinga waa ke to dɔ jin te kare kande gayn. Maji kare e-tɔ tae ang. Maketuru le pa bbay na: Ase kare nje-kula inga kuka laa. ");
INSERT INTO ksp_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","Toke mare dew unda tar dɔ mare ansiyenje te a, aa lo te ang. E-ngina ta mare dewje joo wase muta telje undaje tar dɔe te bbay bba ta e-ndiki te. ");
INSERT INTO ksp_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","A bbo dew dda majang a, e-ndange kem dewje te tɔyn. Baann bba kese dewje a bbelje ta dda majang. ");
INSERT INTO ksp_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","M-duji nya kem Lubba te, ke kem Jeju Kiriste te, ke kem anjije te ke maji tɔyn kare e-dda ne ke turu nduje ke munn mari. Ɔru kem dew ang, e-dda ke dewje tɔyn ddew kara baa. ");
INSERT INTO ksp_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","Ila jii dɔ dew te kare dda kula le Lubba ke ngɔru baa ang. Ula rɔi me majang te le dew ang. Are mei nda kayn nɔ Lubba te lei. ");
INSERT INTO ksp_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","Maann dɔrɔ a ay ang. Maji kare ay koto ke ria na ven ngaji mba wuri ke aw toi, ke rɔ-to ke aw jɔki nya. ");
INSERT INTO ksp_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","Majangje le mare dewje teeje ke ddaka kem dewje te kete bba n̂-ngange sariya dɔe te. A manjangje le mareje teeje ke ddaka kem dewje te dɔ guku baa. ");
INSERT INTO ksp_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","Ddew kara baa, kulaje ke maji ke mare dew aw dda, kem dewje aw ooje. Kulaje ke maji ke n̂-dda ngaa kem dewje ooje ang kara a nayn lo kiyae te ang. ");
INSERT INTO ksp_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","Maji kare bbereje tɔyn ooje ebbedede to dewje ke aseje kare n̂-bbeljede. Yeenn a dda kare dewje a kaseje ta taji ne-tɔje leje ang ddem ri Lubba ang ddem. ");
INSERT INTO ksp_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","Bbereje ke ebbedede toje to nje-kometeje, maji kare n̂-dabbejede ang mba ebbedede le to toje to ngakɔnde ke me Kiriste te ngaa ebbedede le toje to dewje ke ndikide nya a daw n̂-ddaje kula ke de. Ne ke maji kare e-tɔju dewje ngaa unn ndu wɔju dɔe a neenn. Ne ke maji kare e-tɔju dewje ddem unn ndu dɔe te ddem a neenn. ");
INSERT INTO ksp_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","Bbo toke dew tɔju neje ke ke dɔgɔle ang, ngaa nja ke turu ndu tarje ke maji le Ebbejeje Jeju Krist ang ddem, ke turu ndu ne-tɔju wɔju dɔ bbel Lubba ang a, ");
INSERT INTO ksp_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","n̂-to dew ke oo rɔe bo ngaa gere ne kara ang, n̂-to dew ke rɔ-to mayn tar ee rɔe te ngaa n̂-to dew ke aw kɔl wɔju dɔ mare tarje. Neje ke baann aw ddee ke kunda-me ke naa, mayn tar, ne-taji, koo naa ke kem ke maji ang, ");
INSERT INTO ksp_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","mayn̂-tar ke kɔen goto ngaa, tar ke tɔkɔrɔ goto tade te. Dewje le ooje bbel Lubba to gusu ne-kinga lede. ");
INSERT INTO ksp_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","Tɔkɔrɔ, kunn me kare Lubba to ne-kinga ke bo toke dew unda mee ke dɔ ne te ke nee ne njaa. ");
INSERT INTO ksp_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","Mba, n̂-ddeeje ke ne kara dɔ nange te ang, ddew kara baa ja telje ke ne kara ang. ");
INSERT INTO ksp_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","Yeenn a, toke jingaje ne-kusa ke taje te, ke kubbu ke rɔje te a, yeenn njaa ase. ");
INSERT INTO ksp_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","A dewje ke ndikije ta ddee to nje-ne-kingaje osoje me ne-kere te, bbo neje ke maji ang dang dang ddade are dosoje me bande te ngaa dosoje me bbo neje te ke maji ang dang dang ke aw tuju dewje ngaa aw unda dewje ta yo te. ");
INSERT INTO ksp_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","Mba bbo nare a to gel neje te ke maji ang tɔyn. Mare dewje ke isije ke bbo nare inyaje ddew ko-me-te lede ddew ew. Yeenn a, dede njaa n̂-darje dɔde ne-wunguje te dang dang. ");
INSERT INTO ksp_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","A ei dew le Lubba, e-mbete nejeenn ddew ew, ngaa e-sange ddew ta to gate gate, ta bbel Lubba, ta kuwa koo-mete kare ngeng, ta ndiki ngamarije, ta tɔ wuri ngaa e-ddee to dew ke wul pe ke dewje. ");
INSERT INTO ksp_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","E-ngem me-kunn lei toke dew ke aw dda ddɔ. Uwa tebbe ke ke ndɔ ke ndɔ ke Lubba bbari ari dɔ ndɔ te ke e-pa ke tai nɔ dewje te ke banya banya to unn mei are Jeju kiriste. ");
INSERT INTO ksp_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","Munn ndu neenn mari nɔ-gɔl Lubba te ke are tebbe neje tɔyn ddem nɔ-gɔl Jeju-Kiriste te ke pa tar-naji ke tɔkɔrɔ nɔ-gɔl Pɔnse Pilate te. ");
INSERT INTO ksp_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","E-ngem ndu le are ne-yerew ɔri ang. Are tar to dɔi te ang ndereng ndɔ tel le Ebbejeje Jeju-Kiriste. ");
INSERT INTO ksp_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","Na tel ke ndɔ ke Lubba ɔju. Lubba ke to nje-kare dewje isije ke koko, ne ke nɔn dɔ neje tɔyn, ne ke n̂-to Mbay-dɔ-tɔku-mbayje, ke Ebbe-dewje ke uta ebbe-dewje tɔyn. ");
INSERT INTO ksp_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","Lubba ke nje-kisi ke ndɔ ke ndɔ, nisi lo te ke ndoko ke dew tee te ang. Dew kara ooe ang ddem, dew kara ase ta kooe ang ddem. Maji kare dewje waleje, ngaa maji kare n̂-to nje-singa-mɔngu ke to ke ndɔ ke ndɔ. Amem. ");
INSERT INTO ksp_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","Unn ndu are nje-ne-kingaje ke bbokone neenn are dɔsuje gaji rɔde baa ang. Maji kare dundaje mede dɔ ne-kingaje te ang, mba to neje ke a ndayje. A maji kare dundaje mede dɔ Lubba te ke aw areje ne tɔyn toke bo kare jumaje ne rɔje. ");
INSERT INTO ksp_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","E-pa are n̂-ddaje maji, n̂-ddaje kula ke maji nya, are dɔsuje ngar ke me kara ngaa n̂-kaynje debbe ne-kingaje lede dewje. ");
INSERT INTO ksp_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","Baann bba da mɔseje ne dam lede ke kura ddem ngeng ddem mba ndɔ ke bara, yeenn tɔ bba da kingaje ne tebbe ke tɔkɔrɔ. ");
INSERT INTO ksp_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","Timote, aa lo ke kula te ke Lubba ari ta kare e-dda. E-mbete bulaje ke baa baa ke aw tila kem tar le Lubba. Nejeenn le inje ddew ne-gere te ke dewje ooje to ne-gere ke tɔkɔrɔ. ");
INSERT INTO ksp_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","Mare dewje ke njaje go ne-gereje te ke baann le, osoje ddew me-kunn lede. Maji kare me-maji le Lubba nayn kese!");
INSERT INTO ksp_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","Ema Pɔl ke m-to nje-kayn-kula le Jeju Kiriste mba Lubba njaa ndiki te, ngaa bbarem kare mila mber-tar tebbe ke nunn ndue ta kare dewje ddew te le Jeju Kiriste, ");
INSERT INTO ksp_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","M-dda maketuru neenn mari ei ngonnum Timote ke m-ndikii nya. Maji kare Lubba ke Bɔ, de ke Jeju Kiriste ke to Ebbejeje n̂-ddaje sei me-maji, dooje kem-to-ndoo lei ngaa darije me-wul-lɔm. ");
INSERT INTO ksp_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","Mare wooyo nya Lubba ke maw m-dda saa ke keje ke maji tɔyn turu kamjedede te til, ke kare. Kare tɔyn ke maw m-duju Lubba a, maw m-pa saa tar wɔju dɔi. ");
INSERT INTO ksp_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","Meje dɔ nɔn te ke e-nɔn a, mee ke bbo nya ta tel kooi, baann bba ma kisi ke koko. ");
INSERT INTO ksp_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","Maw mole mem dɔ mei te ke unn toke tɔkɔrɔ. Me-kunn le Loyise ke to kaije ke dene, ke kɔinje Enise ke dunnje kete. Meje toke ei njaa kara unn mei toke baann tɔ. ");
INSERT INTO ksp_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","Yeenn le bba maw mole mei ta kare are ne-kare baa ke Lubba ari go jim te ke mila dɔi te nayn ke singa ke ndɔ tɔyn. ");
INSERT INTO ksp_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","Mba Ndil ke dda are n̂-bbel a Lubba areje ang. A Ndil le to Ndil ke areje singa, dda are n̂-ndikije ngamarejeje ngaa dda are n̂-gere dɔjije. ");
INSERT INTO ksp_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","E-dda rɔ-kul ta pa tar-naji le Ebbe-dewje kare dewje ang ddem e-dda rɔ-kul lem, ema ke dilam key-kula te wɔju dɔe ang. A oo sem ndoo wɔju dɔ Tar ke maji ddew singa te ke Lubba areje. ");
INSERT INTO ksp_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","Lubba ke ajije njaa bbarje kare n̂-ddeeje to dewje laa. Wɔju dɔ kula ke maji ke n̂-ddaje bba n̂-bbar ne je ang. A n̂-bbarje wɔju dɔ ne ke n̂-mɔse ta dda ddem wɔju dɔ me-maji laa ddem. ");
INSERT INTO ksp_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","N̂-tɔju me-maji laa le bbasine ddew te le Nje-kajije Jeju Kiriste ke ddee. Jeju njaa guru singa yo ngaa n̂-tɔju tebbe ke to ke ndɔ ke ndɔ ke ddaka ddew te le Tar ke maji. ");
INSERT INTO ksp_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","Mba yeenn bba Lubba unnum to nje-ne-tɔju ddem, to nje-kayn-kula ddem kare mila mber Tar ke maji le. ");
INSERT INTO ksp_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","Gele ke neenn le bba maw moo ne ndoo. A rɔ-kule ddam ang, mba m-gere dew ke munn mem mare le ke maje, ngaa m-gere ke maje to nee ke singa ta ngem ne ke ninya me jim te ndereng ddutu ndɔ a kase. ");
INSERT INTO ksp_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","E-nja turu ndu te ke tɔkɔrɔ ke m-pa mari ddew me-kunn te, ddew ndiki te ke e-ndikije naa ddew te le Jeju Kiriste. ");
INSERT INTO ksp_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","E-ngem ne-tɔju ke maji ke n̂-tɔji ddew singa te le Ndil-me-nda ke isi meje te. ");
INSERT INTO ksp_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","E-gere maji to dewje tɔyn ke nange te ke Aji tusumje inyamje. Pijel de ke Emojenn deeje horode te. ");
INSERT INTO ksp_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","Maji kare Ebbe-dewje oo kem-to-ndoo le nje ke key le Onejipɔr, mba n̂-dda nare minga singa ke ndɔ tɔyn ngaa n̂-dda rɔ-kul wɔju dɔ kila ke dilam key-kula te ang. ");
INSERT INTO ksp_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","Kake n̂-tee bbe te ke Rɔm be a, n̂-sangem ke ngɔru ningam. ");
INSERT INTO ksp_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","Maji kare Ebbe-dewje oo kem-to-ndoo laa ndɔ te ke Ebbe-dewje a gange sariya. E-gere neje ke maji tɔyn ke n̂-dda sem bbe te ke Epeje ke maje. ");
INSERT INTO ksp_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","Ei ngonnum, maji kare inga singa ddew me-maji te ke Lubba dda ke je ddew te le Jeju Kiriste. ");
INSERT INTO ksp_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","Tar ke tee tam te kem nje-tar-najije te ke banya banya le, e-pa are nje-me-kunnje ke unda mei dɔde te kare dede njaa kara daseje ta pa kare mare dewje ke kete tɔ. ");
INSERT INTO ksp_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","Oo sem ndoo toke le nje-ddɔ le Jeju Kiriste ke tɔkɔrɔ. ");
INSERT INTO ksp_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","Dew ke unn rɔe to nje-ddɔ ngaa ndiki ta dda kare rɔ dew ke ɔn dɔe neele a, aa lo ke neje te le siwilje ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","Ddew kara baa, dewje ke aw taje naa ddew mare neje te toke le kayn̂-ngɔru, dew ke ayn ngɔru le ke ddewe bba a kinga kuka laa. ");
INSERT INTO ksp_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","Nje-ndɔɔ ke oo ndoo ddew kula ndɔɔ te laa njaa a kinga ko-ndɔɔ laa le dɔngɔr bba kese dewje a kingaje. ");
INSERT INTO ksp_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","Maji kare e-gere me tar ke maw m-pa neenn, mba Ebbe-dewje a dda kare e-gere kande tarje le tɔyn. ");
INSERT INTO ksp_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","Ole mei dɔ Jeju Kiriste te ke Lubba are nin horo nje-yoje te. N̂-to dew ke gel Dabbiti te ddew kara baa toke Tar ke maji ke maw mila mbere le pa. ");
INSERT INTO ksp_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","Wɔju dɔ Tar ke maji le a moo ne ndoo ndereng n̂-tɔm dilam key-kula te toke le nje-ne-dda ke maji ang. A tar le Lubba a n̂-tɔ ang. ");
INSERT INTO ksp_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","Mba yeenn bba maw m-tɔ wurum neje te tɔyn wɔju dɔ dewje ke Lubba mberede, mba kare dede njaa kara dingaje kaji ke Jeju Kiriste aw are dewje. Baann bba da kingaje piti ke a to ke ndɔ ke ndɔ. ");
INSERT INTO ksp_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","Tar neenn to tar ke tɔkɔrɔ: Toke joyje saa kara baa a, ja kisi ke tebbe saa kara baa tɔ. ");
INSERT INTO ksp_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","Toke juwaje jare ngeng a, ja kɔnje tɔku-mbay saa. Toke n̂-mbeteje a, ne njaa kara na mbeteje tɔ. ");
INSERT INTO ksp_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","Toke n̂-toje gate gate saa ke ndɔ tɔyn ang a, ne n̂-to gate gate ke je ke ndɔ tɔyn, mba na kase ta tel mbete tar ke tee tae te ang. ");
INSERT INTO ksp_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","Ole me dewje dɔ neje teenn tɔyn. E-dujude kem Lubba te kare n̂-mbeteje ta kɔl naa wɔju dɔ mare tarje. Kɔl le dda mare ne kara are dew ang, kɔl le aw tuju dewje ke aw tukaje mbide aw ooje. ");
INSERT INTO ksp_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","Maji kare Lubba ooi to dew ke uwa are ngeng me ne-kereje te, maji kare e-to dew ke dda kula laa ke rɔ-kul ang, a e-to dew ke aw tɔju tar ke tɔkɔrɔ ke ddewe. ");
INSERT INTO ksp_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","E-mbete ta kunda bula ke baa, mba dewje ke aw undaje bula baa le aw inyaje Lubba jann jann. ");
INSERT INTO ksp_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","Tar pa lede to ddew kara baa toke ngɔ-bayn ke usa dew ngaa aw ke kete kete. Imene de ke Pilete n̂-toje toke baann. ");
INSERT INTO ksp_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","Dinyaje tar ke tɔkɔrɔ. N̂-paje na dewje ke oyje inje mban ngaa n̂-turuje me-kunn le mare dewje ddew tar te neenn le. ");
INSERT INTO ksp_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","A gɔl key ke Lubba unda nangê to ke lo toe. Tar ke n̂-dda gɔl key te le na: «Ebbe-dewje gere nje ke toje to dewje laa», ngaa «Maji kare dew ke bbar ri Ebbe-dewje mban a, mbete majang.» ");
INSERT INTO ksp_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","Jo ke n̂-dda ke ande, ke nare dɔrɔ a to me tɔke key te ang. Jo ke n̂-dda ke kake, ke anji to me key te le tɔ. Mare joje to mba ndɔ kusu, a keseje to mba dda ne kula ke baa. ");
INSERT INTO ksp_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","Dew ke inya ne-ddaje ke maji ang ke m-pa tare neenn a, na to jo ke daw ngem mba ndɔ kusu, da kundae dang mba kula le Lubba. Ebbe-dewje a kunne mba dda ne kula, na to ngɔsi mba dda kulaje tɔyn ke maji. ");
INSERT INTO ksp_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","Ayn neje ke maji ang ke aw nel basanje. E-sange ddew ta to gate gate, uwa me-kunn lei are ngeng, e-ndiki dewje, are me-wul-lɔm to hori te ke dewje ke aw dujuje Ebbe-dewje ke me-nda. ");
INSERT INTO ksp_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","A e-mbete mayn̂-tar ke baa, ke mayn̂-tar mbe. E-gere to mayn̂-tar ke baann aw uju kɔl. ");
INSERT INTO ksp_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","Maji kare nje-kula le Ebbe-dewje kɔl ke dew ang. A maji kare dewje tɔyn ndikeje, maji kare nase ta tɔju ne ngaa daw n̂-pa saa a, n̂-tɔ wure. ");
INSERT INTO ksp_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","Maji kare n̂-tɔju ddew dewje ke aw maynje saa tar ke gɔsu ke wul pe. A du ang Lubba a dda kare n̂-turuje ddew lede mba gere tar ke tɔkɔrɔ. ");
INSERT INTO ksp_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","Da telje kingaje keje ke maji guku ngaa, da teeje me bande te le Esu ke uwade are daw n̂-ddaje ne ke mee ndiki. ");
INSERT INTO ksp_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","Maji kare e-gere ne neenn ke maje: ddutu ndɔ a, lo a ngeng. ");
INSERT INTO ksp_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","Yeenn a, dewje a toje to nje-ne-ndikije, da ndikije nare nya, da boroje ngaa da kooje rɔde bo, da tajije ri Lubba, da ddaje dɔ-ngeng ke nje-kujujede, da gereje go maji ke n̂-dda ke de ang, da bbelje ne le Lubba ang, ");
INSERT INTO ksp_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","mede a ketere, da kooje kem-to-ndoo le dew ang, da tujuje ri dewje, da ddaje ne ke dɔgɔle ang, da keeje ke bbo dda dew maji ang, da toje to nje-baanji le nje-ne-ddaje ke maji, ");
INSERT INTO ksp_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","da toje to nje-teeje ke gel dewje, da ddaje singa ke dewje, koo-rɔ-bo a dda kare dooje lo ang, rɔ-nel ke nangê neenn a da ndikije bbo da ndikije Lubba ang, ");
INSERT INTO ksp_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","da ddaje rɔde to nje-bbelje Lubba, a da mbeteje singa-mɔngu ke dew inga ddew bbel Lubba te. Maji kare e-turu girii are dewjeenn le tɔ. ");
INSERT INTO ksp_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","Mareje horode te aw andeje me keyje te ngaa aw ereje deneje ke keje lede ngaji baa ungude me bande te lede. Deneje le toje to nje-ne-ddaje ke maji ang ngaa bbo neje ke maji ang dang dang to mede te. ");
INSERT INTO ksp_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","Deneje le aw ndoje ne ke ndɔ tɔyn, a ddew ke da kaseje ta gere ne tar ke tɔkɔrɔ goto. ");
INSERT INTO ksp_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","Lew Janese de ke Jamberese n̂-taje naa ke Moyije, ddew kara baa dewje neenn aw mbeteje tar ke tɔkɔrɔ toke baann tɔ. N̂-toje to dewje ke keje lede tuju ngaa me-kunn lede to ne kara ang. ");
INSERT INTO ksp_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","A da kawje ddew ew ang, mba dewje tɔyn a gereje woy lede toke lew dewje gereje woy le Janese de ke Jamberese. ");
INSERT INTO ksp_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","A ei oo ne-tɔju ke m-tɔju, oo pa-nja ke m-nja, e-gere neje ke mee ke bbo ta dda, oo me-kunn lem ke munn, kore wur ke more wurum, oo ndiki ke m-ndiki dewje, ngaa oo kuwa ke muwa mare ngeng. ");
INSERT INTO ksp_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","Oo dda ke n̂-ddam, oo ndoo ke moo bbe te ke Antiyose, bbe te ke Ikoniyɔm, ke bbe te ke Listere. Dda ke doso n̂-ddam. A Ebbe-dewje ɔrum me neje teenn tɔyn. ");
INSERT INTO ksp_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","Dewje ke ndikije ta nja gate gate ddew te le Jeju Kiriste a, da ddade. ");
INSERT INTO ksp_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","A dewje ke mede maji ang, ke dewje ke toje to nje-kuwaje lo le dewje taaje, da ddaje majang ke kete kete, da kereje dewje ngaa dede njaa kara da kerede tɔ. ");
INSERT INTO ksp_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","Ei, maji kare ne ke n̂-tɔji ngaa oo a, to tɔkɔrɔ bba e-ndiki te le uwa are ngeng, mba e-gere dewje ke tɔjije ne le ke maje. ");
INSERT INTO ksp_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","Kare ke e-nayn ngonn bbay njaa e-gere Maketuru ke Maji tɔyn. Maketuru le ee ke singa mba tɔji kem-kare. Kem-kare le a kaw sei kare inga kaji ke Jeju Kiriste aw are dewje ke unnje mede areje. ");
INSERT INTO ksp_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","Tar tɔyn ke n̂-dda Maketuru te le in rɔ Lubba te, ngaa Maketuru le to mba tɔju tar ke tɔkɔrɔ dewje, mba kare dew gere majang laa, mba mɔse pa-nja le dew kare to ke danna, mba tɔju ddew ke gate gate dew. ");
INSERT INTO ksp_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","Baann bba kare dew le Lubba ubba singa ke maje, kare n̂-mɔse rɔe ke maje mba dda ne kulaje tɔyn ke maji. ");
INSERT INTO ksp_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","Maw m-duji kem Lubba te, ke kem Jeju Kiriste te ke a gange sariya dɔ dewje te ke isije kem baa, ke dɔ dewje te ke oyje. Maw m-duji ke ri Kiriste ke a tel ddee, ke ri tɔku-mbay laa ke na kɔn, ");
INSERT INTO ksp_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","ta kare ila mber tar le Lubba, e-tel dɔe te ke kare tɔyn, ke kare ke maji ddem ke kare ke maji ang ddem. Maji kare e-tɔjude majang lede, e-ndangede, e-tɔ wuri e-ndejede ngaa ee ke bbo ne-tɔju. ");
INSERT INTO ksp_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","Mba mare kare aw ddee, kare teenn le ne-tɔju ke maji tɔyn a nel dewje ang ngaa. A da kaaje lo ke bbo ke da-rɔde te, bbo koo tar ke mede ndiki ta koo a ddade ke ndɔ tɔyn ngaa da bbarje nje-ne-tɔjuje ke dɔ naa te dɔ naa te. ");
INSERT INTO ksp_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","Da kutu mbide kare tar ke tɔkɔrɔ ngaa da tukaje mbide ta koo ne esuje ke lew ke to tar ke tɔkɔrɔ ang. ");
INSERT INTO ksp_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","A ei, maji kare e-gere dɔ-jii ddew neje te tɔyn, e-tɔ wuri me ne-wunguje te, ila mber Tar ke maji. E-dda kula le Lubba ke maje. ");
INSERT INTO ksp_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","Ema, dunnum to ne ke dunn ta polo ne ne ngaa kare koy lem ase mban. ");
INSERT INTO ksp_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","M-dda ddɔ ke maji, mayn ngɔru m-tee mban, m-ngem me-kunn lem. ");
INSERT INTO ksp_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","Bbasine Lubba ngem ejɔkudɔ wɔju dɔm, ejɔkudɔ ke to wɔju dɔ dewje ke gate gate. Ebbe-dewje ke to nje-gange sariya ke gate gate a karem ejɔkudɔ le ndɔ gange sariya te. Na karem ke karem baa ang, na kare dewje tɔyn ke aw ngebbeje ndɔ ddee laa tɔ. ");
INSERT INTO ksp_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","E-dda gan e-ddee ingam ke ngɔru. ");
INSERT INTO ksp_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","Mba Demase tusum inyam wɔju dɔ bbo neje ke nangê ke bbokone neenn. Naw bbe te ke Tesalonike. Keresanse aw nange te ke Galasi ngaa Tite aw nange te ke Dalmasi. ");
INSERT INTO ksp_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","Luku ke kare baa a nayn sem. E-ddee ke Marke jii te, mba n̂-to dew ke ta kulae kare dda kula le Lubba. ");
INSERT INTO ksp_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","Mula Tisike bbe te ke Epeje. ");
INSERT INTO ksp_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","Bbo a ta ddee a, e-ddee ke kubbu kul ke minya rɔ Karpusu te bbe te ke Torowase. E-ddee ke maketuruje tɔ, uta tɔyn maketuru ke n̂-dda endaar te. ");
INSERT INTO ksp_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","Alekejandre ke to nje-kɔru ddam maji ang nya. Ebbe-dewje a tel ke kuka laa kare ase kula-ddaje laa. ");
INSERT INTO ksp_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","Ei kara aa rɔi rɔe te, mba n̂-mbete tarje leje ke n̂-pa ke me-kara. ");
INSERT INTO ksp_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","Dɔngɔr tar-naji ke mɔru dɔm te ndɔ sariya te, dew kara umam ang. Dede tɔyn n̂-tusumje dinyamje. Maji kare Lubba aa lo ke ne te ke n̂-ddajeenn ang. ");
INSERT INTO ksp_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","A Ebbe-dewje njaa umam ngaa arem singa, mba kare mila mber-tar laa nya mare dewje ngaa ta kare dewje ke toje to Jiipije ang kara tar laa oso mbide te tɔ. Ngaa nɔrum ta tebeyn te. ");
INSERT INTO ksp_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","Ebbe-dewje a kɔrum ta neje te ke maji ang tɔyn ngaa na kajim kare mande me bbe-kɔn te laa darâ. Maji kare piti to laa bbal ke bbal. Amem. ");
INSERT INTO ksp_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","E-dda lapiya Pirisika de ke Akilase arem, e-dda lapiya nje ke key le Onejipɔr arem tɔ. ");
INSERT INTO ksp_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","Erasete nayn bbe te ke Korente. Minya Toropim ke rɔ-to bbe te ke Mile. ");
INSERT INTO ksp_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","E-dda gan e-ddee kete bba kare neyn kul tee. Ebul, ke Pudenn, ke Linn, ke Kolodiya, ke ngakɔnjeje tɔyn ddaije lapiya. ");
INSERT INTO ksp_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","Maji kare Ebbe-dewje ngemi! Maji kare Ebbe-dewje dda ke se me-maji! Amem.");
INSERT INTO ksp_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","Ema Pɔl, m-to nje-kula le Lubba ddem nje-kayn-kula le Jeju Kiriste ddem. Lubba unnum to nje-dda kare dewje ke Lubba mberede unnje mede ngaa kare n̂-gereje tar ke tɔkɔrɔ bba ta n̂-ngemje rɔde mba Lubba. ");
INSERT INTO ksp_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","Yeenn bba da kundaje mede to dingaje tebbe ke ke ndɔ ke ndɔ. Lubba ke ere ngem ndɔ kara ang unn ndue lew baa ta kareje tebbe ke ke ndɔ ke ndɔ le. ");
INSERT INTO ksp_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","Kare ase a, Lubba tee ke tar laa le ke ddaka ddew tar te ke n̂-pa narem. Lubba ke nje-kajije le inya tar le me jim te ngaa nunn ndu narem ta kare mila mber-tar le. ");
INSERT INTO ksp_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","Mula ke maketuru neenn mari, ei Tite ke e-to ngonnum ke tɔkɔrɔ ddew me-kunn te ke mbɔnje. Maji kare Lubba ke Bɔ, ke Nje-kajije Jeju Kiriste ddaje sei me-maji ngaa dareje mei wul lɔm. ");
INSERT INTO ksp_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","Minyai dɔ dere maann te, bbe te ke Kerete kare e-mɔse gɔl neje ke nayn bbay e-tunga ngaa ta kare unda ansiyenje me bbeje te kara kara toke m-pa mari. ");
INSERT INTO ksp_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","Maji kare ansiyenje to dew ke tar to dɔe te kara ang, n̂-to nje-dene ke kara, maji kare nganne unnje mede ngaa dewje undaje tar dɔde te wɔju dɔ pa-nja lede wase dɔ-ngeng lede ang. ");
INSERT INTO ksp_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","Dew ke dɔ Egilisi te to nje-ngem ne le Lubba are maji kare tar to dɔe te kara ang. Maji kare noo rɔe bo ang, n̂-to nje-wungu ang, n̂-to bbere le koto ang, n̂-to nje-kunda dew ang, maji kare bbo kinga nare hɔy hɔy baa ddae ang. ");
INSERT INTO ksp_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","A maji kare n̂-gere ta ngem nje-mbaje ngaa keje dda ne ke maji dɔrɔ a to mee te. Maji kare n̂-to dew ke gere dɔ jia, n̂-to gate gate, n̂-to dew ke ndiki ne-yerew ang ngaa n̂-gere ta tɔ bbo ke da-rɔ te. ");
INSERT INTO ksp_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","Maji kare nuwa tar ke tɔkɔrɔ ke to ddew kara baa ke ne ke n̂-tɔje le nare ngeng. Yeenn bba na kase kɔsu kutu dewje ke kete ddew ne-tɔju te ke maji tɔyn ngaa na kase tɔju dewje ke aw maynje saa tar ne ke ulade naa te. ");
INSERT INTO ksp_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","Tɔkɔrɔ nje-dɔ-ngengje, nje-kundaje bula baa, ke nje-kereje dewje banyaje nya, uta tɔyn, n̂-banyaje nya horo Jiipije te ke ooje mede te. ");
INSERT INTO ksp_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","Maji kare uwa tade, mba daw n̂-tujuje keje le dewje tɔyn ke eeje me nujuje te kara kara. Daw n̂-tɔjuje ne ke ase kare dew tɔju ang mba kinga ne nare hɔy hɔy baa. ");
INSERT INTO ksp_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","Mare kara horode te ke to nje-kila mber-tar lede pa na: « Nje ke dɔ dere maann te ke Kerete to nje-ngemje lew baa, n̂-toje to daje ke ddaje dingaw nya, n̂-toje to nje-dabbeje, keje ne-kusa dɔrɔ a to dɔde te.» ");
INSERT INTO ksp_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","Tar laa le to tar ke tɔkɔrɔ njaa. Yeenn a, maji kare e-ndagede ke singa, mba kare me-kunn lede to gate gate. ");
INSERT INTO ksp_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","E-ndangede are daaje lo ke tar ngemje te ke lew ke Jiipije aw turaje ang ddem, daaje lo ke nduje te le dewje ke turuje giride are tar ke tɔkɔrɔ ang ddem. ");
INSERT INTO ksp_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","Ne tɔyn to maji wɔju dɔ dewje ke mede nda kayn. A dewje ke ne-yerew to mede te ngaa mbeteje ta kunn mede, ne kara to maji wɔju dɔde ang, mba ne-yerew tuju ne-gere lede ddem keje lede ddem. ");
INSERT INTO ksp_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","N̂-paje na n̂-gereje Lubba, a kula ddade tɔju to n̂-gereje Lubba ang. N̂-majije ang, n̂-toje to nje-dɔ-ngengje, daseje ta dda kula ke maji kara ang. ");
INSERT INTO ksp_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","A ei Tite, maji kare e-tɔju ne ke to ddew kara baa ke ne-tɔju ke maji tɔyn. ");
INSERT INTO ksp_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","E-pa are bbukaje ngemje rɔde, n̂-ddaje dare dewje bbeelde ngaa dare keje lede to ke maje. Are darje dɔ me-kunn te lede ke tɔkɔrɔ, are n̂-ndikije naa ngaa duwaje dare ngeng. ");
INSERT INTO ksp_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","Ddew kara baa, e-pa are deneje ke tɔku ngemje pa-nja lede to dewje ke unnje rɔde dang mba dda kula le Lubba. Maji kare n̂-toje to nje-naneje ang ddem n̂-toje to bbereje le koto ang ddem. Maji kare ne ke maji a n̂-tɔjuje. ");
INSERT INTO ksp_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","Maji kare n̂-tɔjuje deneje ke naynje mande bbay dare n̂-ndikije ngawdede, ke ngannde, ");
INSERT INTO ksp_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","dare keje lede to ke maje, n̂-ngemje rɔde, n̂-ddaje kula ngaw lede, dare mede maji ngaa dooje ta ngawdede. Baann bba dewje a paje Tar ke maji ang dɔ tar te le Lubba ang. ");
INSERT INTO ksp_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","Ddew kara baa e-ndeje basanje are keje lede to ke maje ");
INSERT INTO ksp_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","me neje te tɔyn. Ei njaa kara maji kare e-to ne-kɔju mare ddew kula ddai te ke maji. E-tɔju ne ke dɔgɔle ddem, e-ndam ne ang ddem. ");
INSERT INTO ksp_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","Maji kare tar-pa lei to ke ddewe bba kare dew ase mayn sei tar le ang. Baann bba kare rɔ-kul dda nje-baanji lei mba dingaje mare ne ke maji ang ten ta pa dɔje te ang. ");
INSERT INTO ksp_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","Maji kare e-pa are bbereje ooje ta ebbedede me neje te tɔyn. Maji kare n̂-sangeje ddew mba maji kem ebbedede te, n̂-maynje ke de tar ang, ");
INSERT INTO ksp_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","ngaa n̂-bbokoje mare ne lede ang. Maji kare n̂-toje gate gate kem ebbedede te ke ndɔ tɔyn. Baann bba da dda kare dewje bbeelje ne-tɔju le Lubba ke to Nje-kajije. ");
INSERT INTO ksp_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","Mba Lubba tɔju me-maji laa ke to ddew ke dewje tɔyn aseje ta kingaje ne kaji. ");
INSERT INTO ksp_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","Me-maji laa le tɔjuje kare jinyaje pa-nja leje ke maji ang, ke bbo neje ke nangê neenn, mba kare pa-nja leje to ke dɔgɔle ddem to ke danna ngaa to gate gate ddem nɔ Lubba te. ");
INSERT INTO ksp_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","N-ddaje toke baann ta ngina ne ndɔ kisi ke koko leje ke jundaje meje dɔe te. To ndɔ ke tɔku Lubba leje ke to Nje-kajije Jeju Kiriste a ddee ke ndoko laa. ");
INSERT INTO ksp_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","Nunn rɔe njaa nare yo wɔju dɔje mba kɔruje me majang te ngaa ta toko yerew leje kare n̂-toje to dewje laa njaa ddem, kare n̂-toje to dewje ke eeje ke bbo nya mba dda kulaje ke maji ddem. ");
INSERT INTO ksp_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","Maji kare e-pa tar toke baann, are ndeje ngaa e-ndange ne ke singa. E-dda are dew kara dabbi ang. ");
INSERT INTO ksp_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","Ole me nje-me-kunnje tɔyn are n̂-bbeel tɔku-mbayje, ke nje-kɔn bbeje. Maji kare dooje tade ta n̂-toje ngɔsi mba dda ne tɔyn ke maji. ");
INSERT INTO ksp_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","Maji kare n̂-tajije dew ang, n̂-toje to nje-ddɔje ke dew ang, maji kare n̂-toje to nje-me-majije. Maji kare n̂-toje to dewje ke wul pee ke dewje tɔyn ke ndɔ tɔyn. ");
INSERT INTO ksp_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","Mba jeje njaa kara lew n̂-toje to mbeje, n̂-toje to nje-kalje ta, n̂-ndeemje ddew, bbo neje ke maji ang, ke rɔ-neel dang dang uta dɔje. Pa-nja leje maji ang ngaa me ddaje, dewje mbetejeje ngaa n̂-mbeteje naa tɔ. ");
INSERT INTO ksp_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","A kare ke Lubba ke to Nje-kajije tɔju me-maji laa, ke ndiki ke n̂-ndiki dewje a, ");
INSERT INTO ksp_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","najije. Najije wɔju dɔ ne ke gate gate ke n̂-ddaje ang. A najije mba noo kem-to-ndoo leje nare n̂-ddee to dewje ke siki ddew toko ke n̂-tokoje ddem ddew te le Ndil-me-nda ddem. ");
INSERT INTO ksp_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","Lubba are Ndil le ddee dɔje te ke me-kara ddew te le Jeju-Kiriste ke to Nje-kajije. ");
INSERT INTO ksp_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","Yeenn a, ddew me-maji te laa le n̂-dda nare n̂-ddeeje gate gate keme te ngaa kare jingaje tebbe ke ke ndɔ ke ndɔ ke jundaje meje dɔe te le. ");
INSERT INTO ksp_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","Tar neenn to tar ke ase kare dew unda mee dɔe te. M-ndiki ta kare ar dɔe te nya, mba kare dewje tɔyn ke undaje mede dɔ Lubba te unnje rɔde mba dda kulaje ke maji uta. Yeenn to ne ke kura ngaa aw dda maji ke dewje. ");
INSERT INTO ksp_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","A e-mbete kuru gel neje ke baa baa, gel kajeje, ke mayn naa tarje ke baa, ke koo ta naa ang wɔju dɔ ndu: to neje ke dda maji ke dew ang ddem to neje ke baa ddem. ");
INSERT INTO ksp_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","E-ndɔru mbi dew ke aw tin nje-me-kunnje gɔl kara, gɔl joo, a bbo goe te a, ilae ddaka. ");
INSERT INTO ksp_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","E-gere to dew ke baann ndeem ddew. Ne njaa naw n̂-gange sariya dɔ rɔe te ddew majang te ke n̂-nayn ddewe te naw n̂-dda. ");
INSERT INTO ksp_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","Bbo mula Aretemase wase Tisike rɔi te a, e-dda gan e-ddee ingam bbe te ke Nikopolisi, mba lo ke m-ndiki ta kaw kisi te dɔ neyn kul te ann. ");
INSERT INTO ksp_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","Unda mei ta kuma Jenase ke to nje-gere ndu nya, de ke Apolose lo-kaw te lede are mare ne dude ang. ");
INSERT INTO ksp_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","Maji kare kese nje-me-kunnje kara unnje rɔde tɔyn ddaje kulaje ke maji. Yeenn bba da kingaje neje ke mede ndiki ta kinga njange baa ngaa da toje to dewje ke kari baa ang. ");
INSERT INTO ksp_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","Dewje tɔyn ke eeje sem neenn ddaije lapiya. E-dda lapiya nje ke ndikijeje ke toje to nje-me-kunnje tɔ areje. Maji kare Lubba dda me-maji kese tɔyn!");
INSERT INTO ksp_vpl VALUES ("RV1_1","096_1_1","REV","1","1","1","Maketuru neenn pa tar dɔ neje te ke Lubba are Jeju-Kiriste tɔju Jan, kare n̂-tɔju nje-kulaje laa, kare n̂-gereje ne ke nayn ngɔsi baa ta ddee. Kiriste ula anji laa are nje-kula laa Jan kare tɔje nejeenn le kare n̂-gere. ");
INSERT INTO ksp_vpl VALUES ("RV1_2","096_1_2","REV","1","2","2","Jan pa tar-naji neje tɔyn ke noo le. N̂-pa na, ne ke noo le to tar le Lubba njaa a Jeju-Kiriste tee ne ke ddaka. ");
INSERT INTO ksp_vpl VALUES ("RV1_3","096_1_3","REV","1","3","3","Rɔ-neel to le dew ke tura maketuru neenn. Rɔ-neel to le dewje ke ooje tarje ke Lubba tee ne ke ddaka neenn, ngaa ngemje tarje ke n̂-dda maketuru te le. Mba kare ke nejeenn le a teeje ne le nayn ngɔsi. ");
INSERT INTO ksp_vpl VALUES ("RV1_4","096_1_4","REV","1","4","4","Ema Jan, mula ke maketuru neenn mare dewje ke Egilisije te siri ke nange te ke Aji. Maji kare Lubba ke to bbokone neenn, ke n̂-to lew baa, ngaa naw ddee, n̂-dda ke se me-maji, ngaa narese me-wul-lɔm. Maji kare ndilje ke siri ke arje nɔ ngende-mbay te laa ddaje ke se toke baann. ");
INSERT INTO ksp_vpl VALUES ("RV1_5","096_1_5","REV","1","5","5","Maji kare Jeju-Kiriste ke to nje tar-naji ke gate gate, ne ke n̂-to dɔngɔr dew ke ndol horo dewje te ke oy ddem, n̂-to mbay dɔ mbayje te ke nangê neenn ddem, n̂-dda ke se me-maji, ngaa narese me wul-lɔm tɔ. N̂-ndikije ngaa nɔruje me majangje te leje ddew mese te. ");
INSERT INTO ksp_vpl VALUES ("RV1_6","096_1_6","REV","1","6","6","N̂-ddaje to dewje ke ne a n̂-to tɔku-mbay lede ddem, toje to nje-poloje Bɔeje Lubba ddem. Maji kare piti, ke singa-mɔngu to laa, bbal ke bbal. Amem. ");
INSERT INTO ksp_vpl VALUES ("RV1_7","096_1_7","REV","1","7","7","Ooje, naw n̂-ddee me mum te! Dewje tɔyn a kooeje. Nje ke ɔseje ke ninga njaa kara a kooeje tɔ. Gel-dewje tɔyn a nɔnje wɔju dɔe. A to toke baann njaa! Amem. ");
INSERT INTO ksp_vpl VALUES ("RV1_8","096_1_8","REV","1","8","8","Ebbe-dewje Lubba pa na: «M-to Alpa ke Omega. M-to ne ke n̂-to bbokone, ne ke n̂-to lew, ke ne ke naw n̂-ddee. M-to nje-singa-mɔngu.» ");
INSERT INTO ksp_vpl VALUES ("RV1_9","096_1_9","REV","1","9","9","Ema ngokɔnse Jan, moo ndoo ke se kara baa. Je ke se tɔyn n-ddee to dewje ke me Bbe-kɔn te le Jeju ngaa jaw juwa jare ngeng ddew te laa. Duwam dulam dɔ dere-ba te ke ria na Patemoso wɔju dɔ tar le Lubba ke mila mbere ddem, wɔju dɔ tar-naji le Jeju ke maw m-pa ddem. ");
INSERT INTO ksp_vpl VALUES ("RV1_10","096_1_10","REV","1","10","10","Ke ndɔ le Ebbe-dewje, Ndil-me-nda uwam a, moo mare ndu bbar ke singa gom te guku. Ndu le bbar toke le tebbe ke dew aw to. ");
INSERT INTO ksp_vpl VALUES ("RV1_11","096_1_11","REV","1","11","11","Ndu le pa na: «Ne ke aw oo neeenn, e-dda maketuru te ta ula ne are Egilisije ke siri neenn: Ula ne are Egilisi ke Epeje, Isimirni, Pergam, Tiyatir, Sarde, Piladelpi, ke Lawodise.» ");
INSERT INTO ksp_vpl VALUES ("RV1_12","096_1_12","REV","1","12","12","M-turu rɔm ta koo dew ke aw pa sem tar le a, moo ne-kunda lambeje siri ke n̂-dda ke ande. ");
INSERT INTO ksp_vpl VALUES ("RV1_13","096_1_13","REV","1","13","13","Horo ne-kunda lambeje te le, moo mare ne ke unda rɔ dew. Nula kubbu ke ngal ngaa n̂-tɔ kare ke ne-kuwa-bbere ke n̂-dda ke ande. ");
INSERT INTO ksp_vpl VALUES ("RV1_14","096_1_14","REV","1","14","14","Biin-dɔe nda bal bal toke le bin, ang a, toke le eel ke ria na ekew. Kande keme to toke le puru ke aw ɔn. ");
INSERT INTO ksp_vpl VALUES ("RV1_15","096_1_15","REV","1","15","15","Gɔle toke le nare ke dula poro dare ndɔren, ngaa ndue bbar toke le tɔku ba ke aw ula. ");
INSERT INTO ksp_vpl VALUES ("RV1_16","096_1_16","REV","1","16","16","Nuwa endeterendeje siri jia te ke kɔl. Tɔku kiya ke tae joo kem ate tee tae te, ngaa keme ndoko toke le kare ke ɔsu nya. ");
INSERT INTO ksp_vpl VALUES ("RV1_17","096_1_17","REV","1","17","17","Kake mooe a, m-tee moso kɔ gɔle te toke dew ke oy. A, nila jia ke kɔl dɔm te ngaa n̂-pa na: «E-bbeel ang, m-to dɔngɔr ne ddem, dɔbɔyn ne ddem. ");
INSERT INTO ksp_vpl VALUES ("RV1_18","096_1_18","REV","1","18","18","M-to nje-kisi kem baa. Moy lew, a bbasine misi kem baa ke ndɔ ke ndɔ. Mee ke singa dɔ yo te ddem, dɔ lo te le dewje ke oy ddem. ");
INSERT INTO ksp_vpl VALUES ("RV1_19","096_1_19","REV","1","19","19","Mba yeenn a, e-dda ne ke oo neenn maketuru te, ne ke aw to neenn, ke ne ke a ddee goe te. ");
INSERT INTO ksp_vpl VALUES ("RV1_20","096_1_20","REV","1","20","20","Ne ke iya rɔe ke wɔju dɔ endeterendeje siri ke oo jim te ke kɔl, ke ne-kunda lambeje siri ke n̂-dda ke ande le gele toke be: Endeterendeje ke siri le tɔju anjije ke Egilisije te ke siri le, a ne-kunda lambeje ke siri le toje to Egilisije ke siri le tɔ. ");
INSERT INTO ksp_vpl VALUES ("RV2_1","096_2_1","REV","2","1","1","«E-dda maketuru ula ne are anji ke Egilisi te ke Epeje e-pa na: ‹Tar ke dew ke uwa endeterendeje siri jia te ke kɔl ngaa aw nja horo ne-kunda lambeje te siri ke n̂-dda ke ande pa a neenn: ");
INSERT INTO ksp_vpl VALUES ("RV2_2","096_2_2","REV","2","2","2","M-gere kula-ddai, ndoo ke aw oo, ke wuri ke aw tɔ. M-gere to a kase ta tɔ wuri dɔ nje-me-majangje te ang. E-na dewje ke aw ddaje rɔde to nje-kayn-kulaje, a n̂-toje to nje-kayn-kulaje ang, ngaa e-tee ke gel ngem lede ke ddaka. ");
INSERT INTO ksp_vpl VALUES ("RV2_3","096_2_3","REV","2","3","3","E-tɔ wuri nya, ngaa oo ndoo wɔju dɔ rim, a rɔi nyai ddewe te ang. ");
INSERT INTO ksp_vpl VALUES ("RV2_4","096_2_4","REV","2","4","4","A ne ke m-mbete sei a neenn: ‹E-ndikim toke ye ke dɔngɔr ang. ");
INSERT INTO ksp_vpl VALUES ("RV2_5","096_2_5","REV","2","5","5","Ole mei dɔ pa-nja te lei ke dɔngɔr. E-turu ddew lei bbo e-tel kula-ddai te ke dɔngɔr le. Bbo baann ang a, ma ddee rɔi te, ta ma kɔru ne-kunda lambe lei lo te ke to te ke ddang. ");
INSERT INTO ksp_vpl VALUES ("RV2_6","096_2_6","REV","2","6","6","A ne ke maji ke e-dda a neenn: ‹ E-mbete kula-ddaje le dewje ke unnje go Nikola, ddew kara baa toke ema tɔ. ");
INSERT INTO ksp_vpl VALUES ("RV2_7","096_2_7","REV","2","7","7","Dew ke mbia to a, maji kare oo tar ke Ndil-me-nda pa are Egilisije. Dew ke tete ddɔ a, ma kare kande kake ke aw are dew tebbe kare nusa. Kake le to me Paradisi te le Lubba. ");
INSERT INTO ksp_vpl VALUES ("RV2_8","096_2_8","REV","2","8","8","E-dda maketuru ula ne are anji ke Egilisi te ke Smirni: ‹Tar ke dew ke to dɔngɔr dew ddem, dɔbɔyn dew ddem, ne ke noy, ngaa n̂-tel nisi kem baa n̂-pa a neenn: ");
INSERT INTO ksp_vpl VALUES ("RV2_9","096_2_9","REV","2","9","9","M-gere ne-singaje ke aw ingai, ke ndoo ke aw ndoo. A ke tɔkɔrɔ te, e-to nje-ne-kinga. M-gere tarje ke maji ang maji ang ke dewje ke toje to Jiipije ang, a aw ddaje rɔde to Jiipije aw paje dɔi te. N̂-toje to dewje le Satan. ");
INSERT INTO ksp_vpl VALUES ("RV2_10","096_2_10","REV","2","10","10","A koo ndoo, a, are bbeele ddai ang. Esu a kila mare dewje lese key-kula te mba na ne se. Da dda singa ke se ndɔ dɔku. Uwa are ngeng ndereng oy ne. A ma kari tebbe ke ke ndɔ ndɔ to ejɔkudɔ. ");
INSERT INTO ksp_vpl VALUES ("RV2_11","096_2_11","REV","2","11","11","Dew ke mbia to a, maji kare oo tar ke Ndil-me-nda pa are Egilisije. Dew ke tete ddɔ a koy yo ke gɔl joo laa ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("RV2_12","096_2_12","REV","2","12","12","«E-dda maketuru ula ne are anji ke Egilisi te ke Pergam e-pa na: ‹Tar ke dew ke uwa tɔku kiya ke tae joo ngaa ate pa a neenn: ");
INSERT INTO ksp_vpl VALUES ("RV2_13","096_2_13","REV","2","13","13","M-gere lo ke e-dda bbe te ke maje: Ngende-mbay le Satan to teenn. A e-nayn gom te nyɔm bbo e-tusu mei ke unn arem le inya ang. Dɔ ndɔ te ke n̂-tɔl ne Antipase ke to nje-tar-naji lem ke ke dɔgɔle bbe lese, ke to lo-kisi le Satan le njaa kara, inya ddew me̠-kunn lei le ang. ");
INSERT INTO ksp_vpl VALUES ("RV2_14","096_2_14","REV","2","14","14","A mare neje ke m-bete sei a neenn: Mare dewje ke unnje go ne-tɔju le Balam eeje rɔi teenn. Lew, Balam le tula Balak kare ta ere ngann Ijarayelje are usaje da ke n̂-polo ne kɔrje, ngaa kare n̂-ddaje ne kayaje. ");
INSERT INTO ksp_vpl VALUES ("RV2_15","096_2_15","REV","2","15","15","Ddew kara baa, dewje ke unnje go ne-tɔju le Nikola eeje rɔi teenn tɔ. ");
INSERT INTO ksp_vpl VALUES ("RV2_16","096_2_16","REV","2","16","16","E-turu ddew lei. Baann ang a, ma ddee rɔi te njange baa, ta ddɔ ke dewjeenn le ke tɔku kiya ke tee tam te neenn. ");
INSERT INTO ksp_vpl VALUES ("RV2_17","096_2_17","REV","2","17","17","Dew ke mbia to a, maji kare oo tar ke Ndil-me-nda pa are Egilisije. Dew ke tete ddɔ a, ma kare maann ke to lo-kiyae te, ngaa ma kare er-nda ke n̂-dda mare ri ke siki dɔe te. To ri ke dew kara gere ang. Dew ke dunda ri le dɔe te a, a gere ri le. ");
INSERT INTO ksp_vpl VALUES ("RV2_18","096_2_18","REV","2","18","18","E-dda maketuru ula ne are anji ke Egilisi te ke Tiyatir: ‹Tar ke Ngonn le Lubba, ne ke keme aw ndoko toke le puru, ngaa gɔle ndɔnren to ndɔren toke le ande pa a neenn: ");
INSERT INTO ksp_vpl VALUES ("RV2_19","096_2_19","REV","2","19","19","M-gere kula-ddai, ndiki lei, me-kunn lei, maji ke aw dda ke dewje, ke wuri ke aw tɔ. Kulaje ke aw dda guku neenn uta yeje ke kete. ");
INSERT INTO ksp_vpl VALUES ("RV2_20","096_2_20","REV","2","20","20","A ne ke m-mbete sei a to kake inya Jejabel ke oo rɔe to nje-kila mber-tar le Lubba are tɔju ddew ke maji ang nje-kulaje lem. Nerede nare n̂-ddaje kaya, ngaa dusaje da ke n̂-polo ne kɔrje. ");
INSERT INTO ksp_vpl VALUES ("RV2_21","096_2_21","REV","2","21","21","Minya mare kare mare kare n̂-turu ddew laa. A n̂-ndiki ta kinya ddew kaya laa le ang. ");
INSERT INTO ksp_vpl VALUES ("RV2_22","096_2_22","REV","2","22","22","Mba yeenn a, ma kunne kila tuwa-rɔ-to te kare noo ndoo nya, ne de ke nje ke aw ddaje kaya saa. Toke dinyaje ne-ddaje laa ang a, neenn le a kingade. ");
INSERT INTO ksp_vpl VALUES ("RV2_23","096_2_23","REV","2","23","23","Ma tɔl nganne. Yeenn bba Egilisije tɔyn a gereje to m-to dew ke aw gere kejeje le dewje ddem, bbo neje ke to me dewje te ddem. Ma dda ke se kara kara tɔyn ase kem kula-ddase. ");
INSERT INTO ksp_vpl VALUES ("RV2_24","096_2_24","REV","2","24","24","A see kese dewje ke Tiyatir, sese ke e-mbeteje ta kunn go ne-tɔju ke maji ang le, ngaa e-mbeteje ta ndoo ne ke dewje le aw bbarje na ‹neje le Satan ke iyaje rɔde› le, ma kunda mare ne-koto dɔse te ang. ");
INSERT INTO ksp_vpl VALUES ("RV2_25","096_2_25","REV","2","25","25","A maji kare uwaje are ngeng ndereng ndɔ ke ma ddee ne. ");
INSERT INTO ksp_vpl VALUES ("RV2_26","096_2_26","REV","2","26","26","Dew ke tete ddɔ, ngaa dda kulaje lem ndereng ɔsu kɔen a, ma kare nɔ dɔ gel-dewje. ");
INSERT INTO ksp_vpl VALUES ("RV2_27","096_2_27","REV","2","27","27","Na kɔn dɔde ngeng nya, ngaa na gurude toke le dew aw guru jo ke dubba ke anji. ");
INSERT INTO ksp_vpl VALUES ("RV2_28","096_2_28","REV","2","28","28","Ma kare singa le ddew kara baa toke bɔmje arem le, ngaa ma kare endeterenden ke ta-lo-kare te. ");
INSERT INTO ksp_vpl VALUES ("RV2_29","096_2_29","REV","2","29","29","Dew ke mbia to a, maji kare oo tar ke Ndil-me-nda pa are Egilisije. ");
INSERT INTO ksp_vpl VALUES ("RV3_1","096_3_1","REV","3","1","1","«E-dda maketuru ula ne are anji ke Egilisi te ke Sarde e-pa na: ‹Tar ke dew ke ee ke ndilje le Lubba ke siri, ke endeterendeje siri pa a neenn: M-gere kulaje ke aw dda, dewje ooje to isi kem baa, a oy mban. ");
INSERT INTO ksp_vpl VALUES ("RV3_2","096_3_2","REV","3","2","2","Are kemi ngeng, e-dda are kese bbo kulaje ke nayn rɔi te le nayn ke singa, mba a ta koy to koy. Moo a, ne-ddaje lei maji tɔyn kem Lubba te lem ang. ");
INSERT INTO ksp_vpl VALUES ("RV3_3","096_3_3","REV","3","3","3","Ole mei dɔ tar te ke n̂-pa darese, ke gusu ke ooje ne tar le. E-ngem tar le, ngaa e-turu ddew lei. Bbo e-ndol ang a, ma ddee kuwai dɔ jii te toke le nje-bboko. A gere gɔl kare ke ma ddee kɔsi ne busu ang. ");
INSERT INTO ksp_vpl VALUES ("RV3_4","096_3_4","REV","3","4","4","A mare dewje ke eeje horose te Sarde le ngemje rɔde are ne-yerew ɔru kubbu lede ang. Da kulaje kubbu ke nda bba da njaje ne sem, mba daseje njaa. ");
INSERT INTO ksp_vpl VALUES ("RV3_5","096_3_5","REV","3","5","5","Yeenn a, dewje ke teteje ddɔ a, da kula kubbuje ke nda, ma tuju ride maketuru-tebbe te ndɔ kara ang. Ma pa nɔ bɔmje te, ke nɔ anjije te laa to n̂-toje to dewje lem. ");
INSERT INTO ksp_vpl VALUES ("RV3_6","096_3_6","REV","3","6","6","«Dew ke mbia to a, maji kare oo tar ke Ndil-me-nda pa are Egilisije. ");
INSERT INTO ksp_vpl VALUES ("RV3_7","096_3_7","REV","3","7","7","«E-dda maketuru ula ne are anji ke Egilisi te ke Piladelpi e-pa na: ‹Tar ke Dew ke maji tɔyn, ne ke n̂-pa tar ngem ang, ne ke nee ke ngaw kele le Dabbiti, ne ke n̂-teyn ta ne a, dew kara ase ta kutu ang, ne ke nutu ta ne a, dew kara ase ta teyn ang n̂-pa na: ");
INSERT INTO ksp_vpl VALUES ("RV3_8","096_3_8","REV","3","8","8","M-gere kula-ddai. M-gere to ee ke singa nya ang njaa. A e-ngem tar lem bbo e-mbetem ang. Mba yeenn a oo, mɔru ta key nɔi te, a dew kara a kase kutu ta key le ang. ");
INSERT INTO ksp_vpl VALUES ("RV3_9","096_3_9","REV","3","9","9","Dewje ke eeje me key-mbɔn-naa te le Satan aw ddaje rɔde to Jiipije, a n̂-toje to Jiipije ang. N̂-toje to nje-ngemje. Ma kungude me jii te, ngaa ma dda kare n̂-ddee dɔsuje mekeji gɔlde nɔi te. Bann bba da gere to m-ndikii. ");
INSERT INTO ksp_vpl VALUES ("RV3_10","096_3_10","REV","3","10","10","E-ngem ndeje lem ke mari kare uwa are ngeng le. Yeenn a, ema njaa kara ma ngemi kare te ke ne-naje a ddeeje mba na me dewje tɔyn ke dɔ nange te. ");
INSERT INTO ksp_vpl VALUES ("RV3_11","096_3_11","REV","3","11","11","Maw m-ddee bbasine baa. Uwa ne ke ee ne le are ngeng na kare mare dew taa ejɔku-dɔ lei jii te. ");
INSERT INTO ksp_vpl VALUES ("RV3_12","096_3_12","REV","3","12","12","Dew ke tete ddɔ a, ma ddae to kake gaji me key-key-polo Lubba te lem, ngaa na tee ddaka ndɔ kara ang ngaa. Ma dda ri Lubba lem, ke ri bbe le Lubba lem dɔe te. Ri bbe le Lubba lem le na «Jerusalam ke siki» ke in rɔ Lubba te lem darâ ddisi ke nangê. Ma kunda rim ke siki dɔe te tɔ. ");
INSERT INTO ksp_vpl VALUES ("RV3_13","096_3_13","REV","3","13","13","Dew ke ee ke mbi a, oo tar ke Ndil-me-nda pa are Egilisije. ");
INSERT INTO ksp_vpl VALUES ("RV3_14","096_3_14","REV","3","14","14","«E-dda maketuru ula ne are anji ke ee Egilisi te ke Lawodise e-pa na: ‹Tar ke Dew ke ria na Amem, ne ke n̂-to nje-tar-naji ke gate gate ddem, ke tɔkɔrɔ ddem, ne ke nee kunn-kutu neje te ke Lubba dda n̂-pa a neenn: ");
INSERT INTO ksp_vpl VALUES ("RV3_15","096_3_15","REV","3","15","15","M-gere kula-ddai, m-gere to e-wul ang ddem, e-tunga ang ddem. Bbo e-wul wase, e-tunga jeenn a, a maji. ");
INSERT INTO ksp_vpl VALUES ("RV3_16","096_3_16","REV","3","16","16","A e-wul ang ddem, e-tunga ang ddem. E-tunga ro baa be, are ma tɔmi ke tam kilai nangê. ");
INSERT INTO ksp_vpl VALUES ("RV3_17","096_3_17","REV","3","17","17","E-pa na: ‹M-to nje-ne-kinga, minga ne nya, mare ne kara dum ang› a e-gere ang. E-to ndoo ddem, ee ke mare ne kara ang ddem. E-to nje-ndoo ddem, nje-kem-tɔ ddem, ngaa kubbu goto rɔi te. ");
INSERT INTO ksp_vpl VALUES ("RV3_18","096_3_18","REV","3","18","18","Mba yeenn a, m-pa mari kare e-ndoko ande ke n̂-leke poro dare yerew goto te jim te, kare e-ddee to nje-ne-kinga ke tɔkɔrɔ. E-ndoko kubbuje ke nda ula, mba bbo rɔi to baa a, rɔi a wul. E-ndoko kuma ungu kemi te are ta e-tel oo lo. ");
INSERT INTO ksp_vpl VALUES ("RV3_19","096_3_19","REV","3","19","19","Dewje tɔyn ke m-ndikide, maw m-tel ke de ddew te ke maji ddem, maw mundade ddem. Yeenn a, e-dda kula le ke me-kara bbo e-turu ddew lei. ");
INSERT INTO ksp_vpl VALUES ("RV3_20","096_3_20","REV","3","20","20","Oo, mar ta key te, maw munda. Bbo dew oo ndum ngaa ɔru ta key le a, ma kande key laa, ngaa ja kusa ne ke naa. ");
INSERT INTO ksp_vpl VALUES ("RV3_21","096_3_21","REV","3","21","21","Dew ke tete ddɔ a, ma kare ddew kare nisi sem dɔ ngende-mbay te lem, ddew kara baa toke m-tete ddɔ, ngaa maw misi ke Bɔmje dɔ ngende-mbay te laa. ");
INSERT INTO ksp_vpl VALUES ("RV3_22","096_3_22","REV","3","22","22","Dew ke mbia to a, maji kare oo tar ke Ndil-me-nda pa are Egilisije. ");
INSERT INTO ksp_vpl VALUES ("RV4_1","096_4_1","REV","4","1","1","Goe te a, moo ta key ke toke kɔru me dara te. Ndu ke pa sem tar kete, ngaa bbar toke le tebbejeenn le, pa na: «Aal ke neenn, ma tɔji ne ke a ddee goe te.» ");
INSERT INTO ksp_vpl VALUES ("RV4_2","096_4_2","REV","4","2","2","Njange baa njaa a, Ndil-me-nda uwam, a moo mare ngende-mbay me dara te. Mare dew isi dɔe te. ");
INSERT INTO ksp_vpl VALUES ("RV4_3","096_4_3","REV","4","3","3","Dew le ndɔren toke erje ke gate ngeng nya, ke ria na jasepe, ke sarduwann. Ngaburandi ke ndɔren toke le er ke ria na emerode guku dɔ ngende-mbay le. ");
INSERT INTO ksp_vpl VALUES ("RV4_4","096_4_4","REV","4","4","4","Mare ngende-mbayje dɔjoo gire sɔ gukuje dɔ ngende-mbay le, ngaa tɔkuje dɔjoo gire sɔ isije dɔe te kara kara tɔyn. Dulaje kubbu ke nda, ngaa dundaje ejɔkudɔ ke n̂-dda ke ande dɔde te. ");
INSERT INTO ksp_vpl VALUES ("RV4_5","096_4_5","REV","4","5","5","Teelje le ndi, kɔru neje, ke ndangeje le ndi inje ngende-mbay te ke to dana le aw teeje. Puru ngelje siri ke aw ɔnje ke singa toje nɔ ngende-mbay te le. Puru ngeljeenn le toje to ndilje le Lubba ke siri le ann. ");
INSERT INTO ksp_vpl VALUES ("RV4_6","096_4_6","REV","4","6","6","Mare ne toke le bajeenn, keme are yerere toke er ke dew unda keme te a oo ne lo to nɔ ngende-mbay te le. Mare neje ke toje kem baa sɔ, kemde to rɔde te tɔyn kete ddem guku ddem gukuje ngende-mbay ke to dana le. ");
INSERT INTO ksp_vpl VALUES ("RV4_7","096_4_7","REV","4","7","7","Dɔngɔr ne ke to kem baa le unda rɔ tebeyn, joo laa unda rɔ ngonn mange, muta la unda kem dew, a sɔ laa unda rɔ tende ke aw in. ");
INSERT INTO ksp_vpl VALUES ("RV4_8","096_4_8","REV","4","8","8","Bake neje ke sɔ ke toje kem baa le ee misan misan. Kemdeje to dɔ bakedeje te le ddem, kɔy bakedeje te le ddem. Daw dɔsuje pa til ke kare, n̂-paje na: «Ebbe-dewje Lubba ke Nje-singa-mɔngu maji tɔyn, maji tɔyn, maji tɔyn Ne ke n̂-to lew, n̂-to bbasine neenn ngaa naw n̂-ddee.» ");
INSERT INTO ksp_vpl VALUES ("RV4_9","096_4_9","REV","4","9","9","Ke kare tɔyn, toke neje ke sɔ le aw ɔsuje pa ta wal ne, ta piti ne, ta kare ne wooyo ne ke nisi dɔ ngende-mbay te le ngaa nisi kem baa ke ndɔ ke ndɔ le a, ");
INSERT INTO ksp_vpl VALUES ("RV4_10","096_4_10","REV","4","10","10","tɔkuje ke dɔjoo gire sɔ le unguje mekeji gɔlde nɔe te, ne ke nisi ngende-mbay te le, n̂-waleje ne, ne ke nisi ke ndɔ ke ndɔ le. Dunguje ejɔkedɔje lede nɔ ngende-mbay te le ngaa n̂-paje na: ");
INSERT INTO ksp_vpl VALUES ("RV4_11","096_4_11","REV","4","11","11","Ebbe-dewje Lubba leje, ase ta kare dewje pitije, kare dewje walije, ase ta kinga singa-mɔngu, mba ei njaa e-dda neje tɔyn, ei njaa e-ndiki bba neje le toje. ");
INSERT INTO ksp_vpl VALUES ("RV5_1","096_5_1","REV","5","1","1","Goe te a, dew ke isi ngende-mbay te le, moo maketuru ke n̂-ke to jia te ke kɔl. Duja maketuru me te ddem, gire te ddem. N̂-lete tae, loe siri. ");
INSERT INTO ksp_vpl VALUES ("RV5_2","096_5_2","REV","5","2","2","Moo mare anji ke nje singa-mɔngu aw ila mber ke singa na: «Na ase ta kɔru ne ke n̂-lete ne ta maketuru neenn ngaa ta teyn wa?» ");
INSERT INTO ksp_vpl VALUES ("RV5_3","096_5_3","REV","5","3","3","A me dara te, wase dɔ nange te, wase gel nange te, dew kara ke ase teyn maketuru le ta kaa mee koo goto. ");
INSERT INTO ksp_vpl VALUES ("RV5_4","096_5_4","REV","5","4","4","M-nɔ nya, mba dew ke ase ta teyn maketuru le ta kaa koo goto. ");
INSERT INTO ksp_vpl VALUES ("RV5_5","096_5_5","REV","5","5","5","A kara le tɔkuje le pa arem na: «E-nɔ ang. Oo, tebeyn ke gel Juda te, ne ke n̂-to dew ke gel Dabbiti te n̂-tete ddɔ, nase ta kɔru ta maketuru ke toke lete loe siri le ddem, ta teyn maketuru le ddem. ");
INSERT INTO ksp_vpl VALUES ("RV5_6","096_5_6","REV","5","6","6","Maa lo, ngaa moo mare Ngonn bate ar danna mbɔr ngende-mbay te le, horo neje te sɔ ke toje kem baa le, ke horo tɔkuje te le. Ngonn bate le ar toke bate ke n̂-tɔle to ne-polo. Gaje ee siri, ngaa keme ee siri tɔ. Keme ke siri le toje to ndilje le Lubba ke siri ke Lubba ulade dɔ nange te tɔyn le. ");
INSERT INTO ksp_vpl VALUES ("RV5_7","096_5_7","REV","5","7","7","Ngonn bate le nja ke kete aw taa maketuru le ji dew te ke isi ngende-mbay te le, jia te ke kɔl. ");
INSERT INTO ksp_vpl VALUES ("RV5_8","096_5_8","REV","5","8","8","Kake n̂-taa maketuru le a, neje sɔ ke toje kem baa le, ke tɔkuje ke dɔjoo gire sɔ le ɔsuje mekeji gɔlde nangê nɔe te. Konde, ke engo-nareje ke yambo ddusu toje jide te kara kara tɔyn. Yambo le to duju le dewje le Lubba. ");
INSERT INTO ksp_vpl VALUES ("RV5_9","096_5_9","REV","5","9","9","Daw dɔsuje pa ke siki na: Ase ta taa maketuru le, ta kɔru ne ke n̂-lete ne tae. Mba n̂-toli to ne-polo. Are e-ndoko dɔ dewje tɔyn ke mesi are Lubba, dewje ke gelde to dang dang tɔyn, nje ke ndɔn-tarje lede to dang dang tɔyn, ke nje ke isije nangeje te lede kara kara tɔyn. ");
INSERT INTO ksp_vpl VALUES ("RV5_10","096_5_10","REV","5","10","10","E-ddade to dewje ke me Bbe-kɔn te le Lubba, ke nje-poleje, kare n̂-ddaje kula laa. Da kɔn mbay dɔ nange te. ");
INSERT INTO ksp_vpl VALUES ("RV5_11","096_5_11","REV","5","11","11","Maa lo bbay a, moo ndu anjije banya banya. Kɔrde ase doro doro ase tura ang. N̂-gukuje dɔ ngende-mbay le, ke dɔ neje sɔ ke toje kem baa le, ke dɔ tɔkuje le. ");
INSERT INTO ksp_vpl VALUES ("RV5_12","096_5_12","REV","5","12","12","Dɔsuje pa ke singa na: Ngonn bate ke n̂-tɔle le, ase ta kinga singa-mɔngu, ne-kinga, ke kem-kare, nase ta kinga singa, piti, kɔsu gaji, nase kare dewje waleje. ");
INSERT INTO ksp_vpl VALUES ("RV5_13","096_5_13","REV","5","13","13","Moo ndu neje tɔyn ke Lubba ddade ngaa toje me dara te, dɔ nange te, gel nange te, dɔ ba-kate te, ke me ba-kate te. Dɔsuje pa na: «Maji kare piti, wal, kɔsu-gaji, ke singa-mɔngu, toje to le ne ke nisi ngende-mbay te le ddem, le Ngonn bate le ddem, ke ndɔ ke ndɔ.» ");
INSERT INTO ksp_vpl VALUES ("RV5_14","096_5_14","REV","5","14","14","Neje ke sɔ ke toje kem baa le paje na: «Amem!» A tɔkuje le ɔsuje mekeji gɔlde nangê ngaa poloje ne ke nisi ngende-mbay te le ddem, Ngonn bate le ddem. ");
INSERT INTO ksp_vpl VALUES ("RV6_1","096_6_1","REV","6","1","1","Goe te a, moo Ngonn bate le ɔru dɔngɔr ne ke n̂-lete ne ta maketuru loe siri le. A neje ke toje kem baa le, moo ekii le mare kara bbar toke ndange le ndi na: «E-ddee!» ");
INSERT INTO ksp_vpl VALUES ("RV6_2","096_6_2","REV","6","2","2","Ma koo a, moo sunda ke nda. Dew ke aal sunda le uwa giri-kɔndɔrɔ jia te. Dare ejɔkudɔ, ngaa naw to nje-tete-ddɔ njaa ta tete ddɔ. ");
INSERT INTO ksp_vpl VALUES ("RV6_3","096_6_3","REV","6","3","3","Kake Ngonn bate le ɔru joo le ne ke n̂-lete ne ta maketuru le a, neje ke toje kem baa le, moo ekii le joo lede na: «E-ddee!» ");
INSERT INTO ksp_vpl VALUES ("RV6_4","096_6_4","REV","6","4","4","A mare sunda ke kase toke le purujeenn tee. Dew ke aal sunda le, dare singa kare nɔru kisi ddekeke ke ddang dɔ nange te, are ta dewje tɔlje naa. Dare tɔku kiya ke ngal tɔ. ");
INSERT INTO ksp_vpl VALUES ("RV6_5","096_6_5","REV","6","5","5","Kake Ngonn bate le ɔru muta le ne ke n̂-lete ne ta maketuru le a, neje ke toje kem baa le, moo ekii le mota lede na: «E-ddee!» A moo mare sunda ke ndul. Dew ke aal sunda le uwa kilo jia te. ");
INSERT INTO ksp_vpl VALUES ("RV6_6","096_6_6","REV","6","6","6","Moo kɔru ne toke ndu dew horo neje te ke sɔ ke toje kem baa le na: «Nare kula le dew ke ndɔ kara ase ndoko Kilo bele kara baa, a ase ndoko kilo ɔrje muta. A inyan wubbu, ke ben ke lo toe.» ");
INSERT INTO ksp_vpl VALUES ("RV6_7","096_6_7","REV","6","7","7","Kake Ngonn bate le ɔru sɔ le ne ke n̂-lete ne ta maketuru le a, neje ke toje kem baa le, moo ekii le sɔ lede na: «E-ddee!» ");
INSERT INTO ksp_vpl VALUES ("RV6_8","096_6_8","REV","6","8","8","A moo mare sunda ke rɔe toke le kamjeenn. Ri dew ke aal sunda le na Yo. Ngaa lo le dewje ke oy aw unn goe. Toke n̂-kayn dɔ nange loe sɔ a, darede singa kare n̂-tɔlje dewje ke debbe te kara. Da tɔl dewje le ke tɔku kiya, ke bbo, ke rɔ-to ke maji ang, ngaa da kare daje ke mû ke dɔ nange te tɔlde tɔ. ");
INSERT INTO ksp_vpl VALUES ("RV6_9","096_6_9","REV","6","9","9","Kake Ngonn bate le ɔru mi le ne ke n̂-lete ne ta maketuru le a, moo kɔy bann te, ndil dewje ke n̂-tɔlde wɔju dɔ tar le Lubba, ke tar-naji ke n̂-paje wɔju dɔ tar le. ");
INSERT INTO ksp_vpl VALUES ("RV6_10","096_6_10","REV","6","10","10","Daw duruje ekii ke taar na: «Ebbe-dewje, ei ke e-maji tɔyn, ngaa e-to dew ke tɔkɔrɔ, a ngina ndereng ndɔ ke dda bba a gange sariya dɔ dewje te ke dɔ nange te neenn, ta kila bare leje wɔju dɔ tɔl ke n̂-tɔlje le wa? ");
INSERT INTO ksp_vpl VALUES ("RV6_11","096_6_11","REV","6","11","11","Yeenn ngaa, darede, dede kara kara tɔyn tɔku kubbu ke nda, ke ngal. Ngaa, n̂-pa darede kare n̂-nginaje ngaji, kare kɔr nje-kula maredeje, ke kɔr ngakɔndeje utu naa bba. Mba dede kara da tɔlde toke lede tɔ. ");
INSERT INTO ksp_vpl VALUES ("RV6_12","096_6_12","REV","6","12","12","Maa lo, ngaa moo Ngonn bate le ddee ɔru misan le ne ke n̂-lete ne ta maketuru le. A nange yeke ke singa. Kare tuka ndul toke kubbu kuwa ndoo, a neyn ddee toke le mese. ");
INSERT INTO ksp_vpl VALUES ("RV6_13","096_6_13","REV","6","13","13","Endeterendeje inje darâ gaynje nangê toke kande Pige ke nayn sangeje ang bbay, ngaa tɔku yel aw yeke kake are aw gaynje. ");
INSERT INTO ksp_vpl VALUES ("RV6_14","096_6_14","REV","6","14","14","Dara nday toke rake ke daw n̂-ke. Ddingirije, ke dɔ-dere-maannje gotoje loje te lede. ");
INSERT INTO ksp_vpl VALUES ("RV6_15","096_6_15","REV","6","15","15","Tɔku mbayje ke dɔ nange te, nje-kɔn-bbeje, nje-kɔn dɔ mbambaje, nje-ne-kingaje, nje-singa-mɔnguje, bbereje, ke dewje ke toje to bbereje ang, diyaje rɔde bolo ddingirije te, ke horo erje te. ");
INSERT INTO ksp_vpl VALUES ("RV6_16","096_6_16","REV","6","16","16","N̂-paje dare ddingirije, ke erje na: «Osoje dɔje te, ɔnnje dɔje areje ne ke nisi dɔ ngende-mbay te nooje ang, are n-tee ne ta wungu te le Ngonn bate le.» ");
INSERT INTO ksp_vpl VALUES ("RV6_17","096_6_17","REV","6","17","17","Mba tɔku ndɔ wungu lede ase ngaa. Na a nayn wa? ");
INSERT INTO ksp_vpl VALUES ("RV7_1","096_7_1","REV","7","1","1","Goe te a, moo anjije sɔ. Darje kekel nange te ke sɔ. Duwaje lelje ke sɔ ke aw ulaje dɔ nange te, dare kara kara ula dɔ nange te ang ddem, dɔ ba-kate te ang ddem, dɔ kakeje te ang ddem. ");
INSERT INTO ksp_vpl VALUES ("RV7_2","096_7_2","REV","7","2","2","Moo mare anji dang in er lo tee te le kare, ngaa uwa ne-kuja endaji le Lubba ke nje-kisi kem baa jia te. Nila ko nare anjije sɔ ke darede ddew kare n̂-tujuje nange ddem, ba-kate ddem. N̂-pa na: ");
INSERT INTO ksp_vpl VALUES ("RV7_3","096_7_3","REV","7","3","3","«E-tujuje nange ang ddem, ba-kate ang ddem, kakeje ang ddem. E-nginaje are juja endaji engo-nɔ nje-kulaje te le Lubba leje bba.» ");
INSERT INTO ksp_vpl VALUES ("RV7_4","096_7_4","REV","7","4","4","Moo kɔr dewje ke duja endaji engo-nɔde te le. Deeje doro kɔr kara, ke dɔsɔ gire sɔ (144 000). To dewje ke inje horo gel-dewje te tɔyn ke Ijarayel. ");
INSERT INTO ksp_vpl VALUES ("RV7_5","096_7_5","REV","7","5","5","Nje ke gel Juda te eeje doro dɔku gire joo (12 000), nje ke gel Rubenn te doro dɔku gire joo (12 000), nje ke gel Gade te doro dɔku gire joo (12 000), ");
INSERT INTO ksp_vpl VALUES ("RV7_6","096_7_6","REV","7","6","6","nje ke gel Aser te doro dɔku gire joo (12 000), nje ke gel Nepetali te doro dɔku gire joo (12 000), nje ke gel Manase te doro dɔku gire joo (12 000), ");
INSERT INTO ksp_vpl VALUES ("RV7_7","096_7_7","REV","7","7","7","Nje ke gel Simeyɔn te doro dɔku gire joo (12 000), nje ke gel Lebi te doro dɔku gire joo (12 000), nje ke gel Isakar te 12 000, ");
INSERT INTO ksp_vpl VALUES ("RV7_8","096_7_8","REV","7","8","8","nje ke gel Jabulɔn te doro dɔku gire joo (12 000), nje ke gel Jejebbe te doro dɔku gire joo (12 000), nje ke gel Benjamen te doro dɔku gire joo (12 000). ");
INSERT INTO ksp_vpl VALUES ("RV7_9","096_7_9","REV","7","9","9","Goe te maa lo bbaya a, moo dewje banya banya. Dew ase turade ang. Dinje horo dewje te ke gelde dang dang tɔyn, horo nje ke bbeje te dang dang, horo nje ke nangeje te dang dang, ke horo nje te ke ndɔn-tarje lede to dang dang. Darje nɔ ngende-mbay te, nɔ Ngonn bate te le. Dulaje tɔku kubbu ke nda, ngaa duwaje kam mburu jide te. ");
INSERT INTO ksp_vpl VALUES ("RV7_10","096_7_10","REV","7","10","10","Daw duruje ekii na: «Lubba leje ke isi ngende-mbay te, de ke Ngonn bate a dajije.» ");
INSERT INTO ksp_vpl VALUES ("RV7_11","096_7_11","REV","7","11","11","Yeenn ngaa, anjije tɔyn ke gukuje dɔ ngende-mbay le ddem, dɔ tɔkuje le ddem, dɔ neje ke toje kem baa ke sɔ le ddem, dosoje nangê nɔ ngende-mbay te le, n̂-debbeje kemde nangê, ngaa n̂-poloje Lubba. ");
INSERT INTO ksp_vpl VALUES ("RV7_12","096_7_12","REV","7","12","12","N̂-paje na: «Amem! Piti, kɔsu gaji, kem-kare, wooyo, wal, singa-mɔngu, ke singa toje to le Lubba leje ke ndɔ ke ndɔ. Amem!» ");
INSERT INTO ksp_vpl VALUES ("RV7_13","096_7_13","REV","7","13","13","Yeenn ngaa, mare kara le tɔkuje le dujum na: «Dewje ke ulaje kubbu ke nda neenn toje to na wa? Dinje dda wa?» ");
INSERT INTO ksp_vpl VALUES ("RV7_14","096_7_14","REV","7","14","14","Milae te m-pa na: «Ebbemje, ei a e-gere.» Yeenn ngaa n̂-pa narem na: «To dewje ke inje me tɔku ne-singaje te baa teeje ann. N̂-tokoje kubbuje lede ke mese ngonn bate dare nda. ");
INSERT INTO ksp_vpl VALUES ("RV7_15","096_7_15","REV","7","15","15","Mba yeenn a, darje nɔ ngende-mbay te le Lubba daw n̂-poleje, til ke kare me key te ke daw n̂-pole te. Ne ke nisi ngende-mbay te le, na ngemde. ");
INSERT INTO ksp_vpl VALUES ("RV7_16","096_7_16","REV","7","16","16","Bbo a ddade ang ngaa ddem, kunda a kɔnde ang ngaa ddem. Kare a kɔsude ang ngaa ddem, lo a nungade ang ngaa ddem. ");
INSERT INTO ksp_vpl VALUES ("RV7_17","096_7_17","REV","7","17","17","Mba ngonn bate ke ar dann ngende-mbay te le a ngemde toke le ne-kuulje, ngaa na kaw ke de loje te ke maannje ke aw are tebbe inje ke te bba aw teeje. Ngaa Lubba a bɔru maann-nɔ kemde te tɔyn. ");
INSERT INTO ksp_vpl VALUES ("RV8_1","096_8_1","REV","8","1","1","Kare ke Ngonn bate le ɔru siri le ne ke n̂-lete ne ta maketuru le a, lo to nyenene me dara te ngɔsi ke gɔju gɔl kare kara. ");
INSERT INTO ksp_vpl VALUES ("RV8_2","096_8_2","REV","8","2","2","Moo anjije ke siri ke arje nɔ Lubba te le. Darede tebbeje siri. ");
INSERT INTO ksp_vpl VALUES ("RV8_3","096_8_3","REV","8","3","3","Mare anji dang bbay ddee ar mbɔr bann te le. Nuwa mare ngonn jo ro yambo ke n̂-dda ke ande jia te. Dare yamboje toke banya kare n̂-ro dɔ bann te ke n̂-dda ke ande ke to nɔ ngende-mbay te le ddem, kare n̂-ddee ke duju le dewje le Lubba tɔyn nɔ Lubba te le ddem. ");
INSERT INTO ksp_vpl VALUES ("RV8_4","096_8_4","REV","8","4","4","Sa yamboje le, ke dujuje le dewje le Lubba le inje ji anji te le ubba nɔ Lubba te. ");
INSERT INTO ksp_vpl VALUES ("RV8_5","096_8_5","REV","8","5","5","Anji le unn ngonn jo ro yambo le ungu puru ke dɔ bann te le me te ddusu, ngaa bi ila dɔ nange te. Njange baa a, ndi ndange, kɔru ndu neje bbar, ndi teel, ngaa nange yeke. ");
INSERT INTO ksp_vpl VALUES ("RV8_6","096_8_6","REV","8","6","6","Anjije siri ke uwaje tebbeje siri jide te le aw mɔseje rɔde ta to. ");
INSERT INTO ksp_vpl VALUES ("RV8_7","096_8_7","REV","8","7","7","Anji ke dɔngɔr to tebbe laa. A kɔju, ke puru, poleje naa ke mese ngaa gaynje dɔ nange te. Toke n̂-kayn nange, ke kakeje ke dɔ nange te loe mota a, puru ɔn debbe nange le kara, ɔn debbe kakeje le kara, ngaa ɔn kamje ke muje ke tebbe tɔyn. ");
INSERT INTO ksp_vpl VALUES ("RV8_8","096_8_8","REV","8","8","8","Anji ke to joo laa to tebbe laa. A mare ne toke tɔku ddingiri ke aw ɔn puru tee oso me ba-kate te. Debbe ba-kate le tel to mese. ");
INSERT INTO ksp_vpl VALUES ("RV8_9","096_8_9","REV","8","9","9","Toke n̂-kayn horo neje ke Lubba dda ke toje me maannje te loe mota a, debbe ke kara oy, ngaa debbe tɔku toje ke kara tuju. ");
INSERT INTO ksp_vpl VALUES ("RV8_10","096_8_10","REV","8","10","10","Anji ke to mota laa to tebbe laa. A mare tɔku endeterenden ke aw ɔn puru toke puru ngel in darâ oso. Toke n̂-kayn horo baje ke dɔ nange te loe mota a, endenterenden le oso dɔ debbe ba te le kara, ke dɔ loje te ke maannje aw inje ke te aw teeje. ");
INSERT INTO ksp_vpl VALUES ("RV8_11","096_8_11","REV","8","11","11","Ri endeterenden le na «Ne ke ate.» Debbe maannje ke noso dɔe te le ate, ngaa dewje nya ke ayje maannje ke ate le oyje. ");
INSERT INTO ksp_vpl VALUES ("RV8_12","096_8_12","REV","8","12","12","Anji ke to sɔ laa le to tebbe laa. Toke n̂-kayn me kare, me neyn, ke me endeterendenje loe mota mota a, dunda debbe kare le kara, debbe neyn kara, ke debbe endeterendenje kara kare n̂-ndokoje ang. Yeenn a, kara wase til te kara, lo a ndoko tɔyn ang. ");
INSERT INTO ksp_vpl VALUES ("RV8_13","096_8_13","REV","8","13","13","Maa lo bbay a, moo kɔru mare tende ke aw in me dara te taar nu. Eel le uru ekii ke singa na: «Ne-wungu, ne-wungu, ne-wungu a to le dewje ke dɔ nange te, toke kese anjije ke mota toje tebbeje lede.» ");
INSERT INTO ksp_vpl VALUES ("RV9_1","096_9_1","REV","9","1","1","Anji ke to mi laa to tebbe, a moo mare endeterenden in darâ oso nangê. Dare ngaw kele ta tɔku buwa ke suren goto. ");
INSERT INTO ksp_vpl VALUES ("RV9_2","096_9_2","REV","9","2","2","Endeterenden le ɔru ta tɔku buwa ke suren goto le. Sa ubba te toke sa tɔku puru. Sa ke ubba buwa te le dda are kare, ke kem dara tuka ndul biti biti. ");
INSERT INTO ksp_vpl VALUES ("RV9_3","096_9_3","REV","9","3","3","Ebeteje inje me sa te le teeje, ngaa gaynje nangê. Darede singa kuta dewje toke engan nyije ke dɔ nange te. ");
INSERT INTO ksp_vpl VALUES ("RV9_4","096_9_4","REV","9","4","4","Darede ndu kare n̂-tujuje muje, ke kamje, ke kakeje ang. A dewje ke endaji le Lubba goto engo-nɔde te a ta n̂-ddajede maji ang. ");
INSERT INTO ksp_vpl VALUES ("RV9_5","096_9_5","REV","9","5","5","Dare ddew ebeteje le kare n̂-tɔlje dewje le ang, a ta kare dulaje kemde ndoo neyn mi. Da tɔsu dewje le kare tode toke le to le nyi. ");
INSERT INTO ksp_vpl VALUES ("RV9_6","096_9_6","REV","9","6","6","Kare teenn, dewje a sangeje yo, a da kingaeje ang nyɔm. Da ndikije ta koy, a yo a kaynde kaw ddew ew. ");
INSERT INTO ksp_vpl VALUES ("RV9_7","096_9_7","REV","9","7","7","Ebeteje le undaje rɔ sundaje ke n̂-mɔsede ta dda ne ddɔ. Mare ne to dɔde te toke le ejɔkudɔ ke n̂-dda ke ande, ngaa kemde unda kem dew. ");
INSERT INTO ksp_vpl VALUES ("RV9_8","096_9_8","REV","9","8","8","Biin-dɔde toke le biin-dɔ dene, ngaa ngangede toke le ngange tebeyn. ");
INSERT INTO ksp_vpl VALUES ("RV9_9","096_9_9","REV","9","9","9","Nɔ-gu ebeteje le toke le dɔ-kubbu ddɔ ke n̂-dda ke ande-nare a dula ke te. Kɔru bakede bbar toke kɔru sarete ddɔ ke sundaje banya banya aw ndɔruje awje ne ke ta ddɔ te. ");
INSERT INTO ksp_vpl VALUES ("RV9_10","096_9_10","REV","9","10","10","Bbɔngude toke bbɔngu nyi, ngawe to te. Singa kula kem dewje ndoo mba neyn mi le to bbɔngude te le. ");
INSERT INTO ksp_vpl VALUES ("RV9_11","096_9_11","REV","9","11","11","Tɔku mbay lede to anji ke tɔku buwa te ke suren goto. Ria ke ndɔn-tar le Ebereje na Abadɔn, a ke ndɔn-tar le Gerekeje na Apoliyɔn. Kande ri le na «Nje-ne-tuju». ");
INSERT INTO ksp_vpl VALUES ("RV9_12","096_9_12","REV","9","12","12","Dɔngɔr ne-wungu le nday mban. A mare ne-wunguje joo aw ddeeje goe te bbay. ");
INSERT INTO ksp_vpl VALUES ("RV9_13","096_9_13","REV","9","13","13","Misan le anji le to tebbe laa. A, baann ke n̂-dda ke ande, ngaa to nɔ Lubba te le, moo mare ndu bbar, er kekeleje te sɔ kem. ");
INSERT INTO ksp_vpl VALUES ("RV9_14","096_9_14","REV","9","14","14","Ndu le pa are misan le anji ke uwa tebbe jia te le na: «E-tutu anjije ke sɔ ke n̂-tɔde mbɔr tɔku ba te ke ria na Eparate le.» ");
INSERT INTO ksp_vpl VALUES ("RV9_15","096_9_15","REV","9","15","15","N̂-tutu anjije ke sɔ le. Toke n̂-kayn horo dewje ke dɔ nange te loe mota a, n̂-toje ngɔsi ta tɔl debbe dewje ke debbe te kara, kare teenn, ndɔe teenn, me neyn teenn, ke bbale teenn. ");
INSERT INTO ksp_vpl VALUES ("RV9_16","096_9_16","REV","9","16","16","Kɔr nje-ddɔje ke toje to nje-sundaje ke n̂-bbar dare moo to million kɔr joo. ");
INSERT INTO ksp_vpl VALUES ("RV9_17","096_9_17","REV","9","17","17","Me ni te lem le, moo sundaje, ke nje ke aw aalje sundaje le a, n̂-toje toke be: Dulaje dɔ-kubbu-ddɔje ke kase toke le purujeenn ddem, ndul toke le kem dara ddem, ngaa to bu mate toke le ne ke daw n̂-bbar na supere ddem nɔ-gude te. Dɔ sundaje le toke le dɔ tebeyn. Puru, ke sa, ke supere in tade aw tee. ");
INSERT INTO ksp_vpl VALUES ("RV9_18","096_9_18","REV","9","18","18","Ne-kem-to-ndooje ke muta neenn le: Puru, sa, ke supere ke aw teeje ta sundaje te le tɔlje debbe dewje kara horo debbe dewje te ke mota. ");
INSERT INTO ksp_vpl VALUES ("RV9_19","096_9_19","REV","9","19","19","Mba singa sundaje le to me kilde te ddem, bbɔngude te ddem. Bbɔngude undaje rɔ li. Bbɔngude le dɔe to are ye a daw n̂-ddaje ne dewje maji ang. ");
INSERT INTO ksp_vpl VALUES ("RV9_20","096_9_20","REV","9","20","20","A kese dewje ke ne-kem-to-ndooje neenn le tɔljede ang le inyaje ddew polo kɔrje ke n̂-ddaje ke jide le ang. N̂-naynje daw n̂-poloje ndilje ke maji ang, daw n̂-poloje kɔrje ke n̂-ddaje ke ande, ke nare, ke tungu, ke er, ke kake. Kɔrje ke aw ooje lo ang ddem, aw ooje tar ang ddem, aw njaje ang ddem le. ");
INSERT INTO ksp_vpl VALUES ("RV9_21","096_9_21","REV","9","21","21","Dinyaje ddew tɔl dew ang ddem, ddew kumaje lede ang ddem, ddew lo-to-majang ang ddem, ddew bbokoje lede ang ddem. ");
INSERT INTO ksp_vpl VALUES ("RV10_1","096_10_1","REV","10","1","1","Goe te a, m-tel moo mare anji nje-singa-mɔngu in darâ aw ddisi. Mum taa rɔe tɔyn toke le kubbu, ngaa ngabburandi guku dangara dɔe. Keme ndoko toke le kare, ngaa gɔle kase toke le ndɔn puru. ");
INSERT INTO ksp_vpl VALUES ("RV10_2","096_10_2","REV","10","2","2","Nuwa mare ngonn maketuru ke toke teyn jia te. Nila gɔle ke kɔl dɔ ba-kate te, a nila gɔle ke gel dɔ nange te. ");
INSERT INTO ksp_vpl VALUES ("RV10_3","096_10_3","REV","10","3","3","Nuru ekii ke taar toke le tebeyn ke aw nɔ. Goe te a, ndi ndange tae siri. ");
INSERT INTO ksp_vpl VALUES ("RV10_4","096_10_4","REV","10","4","4","Kare te ke ndi le ndange tae siri le a, m-ndiki ta kuja tar ke ndije le paje le maketuru te a, moo mare ndu ke in darâ na: «E-ngem mei te bbo uja maketuru te ang.» ");
INSERT INTO ksp_vpl VALUES ("RV10_5","096_10_5","REV","10","5","5","Anji ke mooe ar dɔ ba-kate te ddem, dɔ nange te ddem le ula jia ke kɔl ke darâ, ");
INSERT INTO ksp_vpl VALUES ("RV10_6","096_10_6","REV","10","6","6","ngaa unda yo ke ri Lubba ke isi ke ndɔ ke ndɔ, ne ke n̂-dda dara ke neje tɔyn ke toje me, nange ke neje tɔyn ke toje te, ba-kate ke neje tɔyn ke toje te. Anji le pa na: «Kare ase ngaa. ");
INSERT INTO ksp_vpl VALUES ("RV10_7","096_10_7","REV","10","7","7","Kare te ke anji ke to siri laa to tebbe a, a to ndɔ ke ne le Lubba ke iya rɔe a ddee to ne ke tɔkɔrɔ, ddew kara baa toke Lubba pa tare are bbere-kulaje laa ke toje to nje-kilaje mber-tar laa.» ");
INSERT INTO ksp_vpl VALUES ("RV10_8","096_10_8","REV","10","8","8","Ndu ke bbar darâ ke moo le tel pa tar arem bbay na: «Aw taa ngonn maketuru ke toke teyn ke to ji anji te ke ar dɔ ba-kate ddem, dɔ nange te ddem le.» ");
INSERT INTO ksp_vpl VALUES ("RV10_9","096_10_9","REV","10","9","9","Maw ngɔsi ke rɔ anji te le, ngaa m-duje kare narem ngonn maketuru le. Nilam te na: «E-taa usa. A kate kang kang mei te. A, a neel tai te toke le keme teje.» ");
INSERT INTO ksp_vpl VALUES ("RV10_10","096_10_10","REV","10","10","10","M-taa ngonn maketuru le ji anji te le, ngaa musa, a neel tam te toke keme teje. A kake muru a, ate mem te nu kang kang. ");
INSERT INTO ksp_vpl VALUES ("RV10_11","096_10_11","REV","10","11","11","Ngaa n̂-pa darem na: «Maji kare e-tel ila mber-tar ke Lubba pa dɔ dewje te ke banya bbay: Dewje ke bbeje te, dewje ke gelde dang dang, nje ke ndɔn-tarje lede to dang dang, ke tɔku mbayje. ");
INSERT INTO ksp_vpl VALUES ("RV11_1","096_11_1","REV","11","1","1","Darem mare kabbara ke to toke kake kɔju ne, ngaa n̂-pa darem na: «In taar bbo ɔju key-polo-Lubba, ke bann ke to me te. E-tura kɔr dewje ke aw poloje Lubba me te. ");
INSERT INTO ksp_vpl VALUES ("RV11_2","096_11_2","REV","11","2","2","A inya ndake lo ke ddaka, bbo ɔju ang. Mba dare ndake lo le gel-dewje ke gereje Lubba ang. Da mbɔynje bbe ke maji tɔyn le ke gɔlde neyn dɔsɔ gire joo. ");
INSERT INTO ksp_vpl VALUES ("RV11_3","096_11_3","REV","11","3","3","Ma kare nje-tar-najije lem ke joo ilaje mber tar lem, ke kubbu ndoo rɔde te ndɔ doro kara, kɔr joo, ke dɔ misan (1 260). ");
INSERT INTO ksp_vpl VALUES ("RV11_4","096_11_4","REV","11","4","4","Nje-tar-najije lem ke joo le toje to kake olibeje ke joo, ke ne kunda lambeje ke joo ke toje nɔm te, ema Ebbe-dewje ke dɔ nange te. ");
INSERT INTO ksp_vpl VALUES ("RV11_5","096_11_5","REV","11","5","5","Bbo dew ndiki ta ddade maji ang a, puru tee tade te ro nje-baanje lede le. Tɔkɔrɔ njaa, bbo dew ndiki ta ddade maji ang a, maji kare dew le oy toke baann. ");
INSERT INTO ksp_vpl VALUES ("RV11_6","096_11_6","REV","11","6","6","Deeje ke singa ta kutu kem dara kare ndi ere ang me ndɔje te ke daw dilaje ne mber-tar le Lubba. Deeje ke singa ta dda kare maannje telje to mese, ngaa ta dda kare ne-kem-to-ndooje dang dang osoje dɔ nange te toke mede ndiki. ");
INSERT INTO ksp_vpl VALUES ("RV11_7","096_11_7","REV","11","7","7","Toke n̂-paje tar naji le n̂-tungaje a, da ke a kin me tɔku buwa te ke suren goto le a dda ddɔ ke de, singae a kutade, ngaa na tɔlde. ");
INSERT INTO ksp_vpl VALUES ("RV11_8","096_11_8","REV","11","8","8","Ninnde a nayn dɔ nange te nata, me tɔku bbe te ke n̂-tɔl Ebbedede te, dɔ kake-dese te le. Ddew Ndil te, dewje undaje ri tɔku bbe le na Sɔdɔm, Gɔmɔr ddem. ");
INSERT INTO ksp_vpl VALUES ("RV11_9","096_11_9","REV","11","9","9","Dewje ke me bbeje te dang dang, gel-kujude dang dang, nje ndɔn-tarje lede to dang dang, dewje ke gelde dang dang a ddeeje ta koo ninnde mba ndɔ muta ke gaen. Da kinyaje ddew kare n̂-dubbu ninnde le ang. ");
INSERT INTO ksp_vpl VALUES ("RV11_10","096_11_10","REV","11","10","10","Dewje ke dɔ nange te a ddaje rɔ-neel wɔju dɔ koy lede le. Da ddaje kusu, da kulaje ke neje baa kare naa, mba nje-kilaje mber-tar ke joo neenn le ddaje are dewje ooje ndoo nya. ");
INSERT INTO ksp_vpl VALUES ("RV11_11","096_11_11","REV","11","11","11","A go ndɔ te ke muta ke gaen le a, mare yel ke aw are tebbe in rɔ Lubba te ddee ande ninnde le, ngaa dinje darje taar. Yeenn a bbeel dda dewje ke aw oojede le nya. ");
INSERT INTO ksp_vpl VALUES ("RV11_12","096_11_12","REV","11","12","12","Nje-kilaje mber-tar le Lubba le ooje mare ndu ke in dara, ngaa pa arede ke singa na: «Inje ke taar neenn.» Dinje ke darâ me mum te kem nje-baanje te lede le. ");
INSERT INTO ksp_vpl VALUES ("RV11_13","096_11_13","REV","11","13","13","Kare teenn njaa, nange yeke ke singa. Are bbo e-kayn me tɔku bbe le dɔku a, debbe kara njaa guru are dewje doro siri (7 000) oyje mba nange ke yeke le. Bbeel dda kese dewje ke naynje kem baa, ngaa dɔsuje gaji Lubba ke darâ. ");
INSERT INTO ksp_vpl VALUES ("RV11_14","096_11_14","REV","11","14","14","Joo le ne-wungu le nday mban. A mota le ne-wungu aw ddee mbɔr ang baa. ");
INSERT INTO ksp_vpl VALUES ("RV11_15","096_11_15","REV","11","15","15","Goe te a, anji ke to siri laa to tebbe. Nduje bbarje ke singa darâ na: «Bbasine, kɔn-mbay dɔ nange te neenn tel me ji Ebbejeje te, ke me ji Mesi te laa. Na kɔn-mbay ke ndɔ ke ndɔ.» ");
INSERT INTO ksp_vpl VALUES ("RV11_16","096_11_16","REV","11","16","16","Tɔkuje dɔjoo gire sɔ ke isije ngende-mbay te lede nɔ Lubba te le teeje osoje nangê, debbeje kemde nangê nɔ Lubba te, ngaa walje Lubba, ");
INSERT INTO ksp_vpl VALUES ("RV11_17","096_11_17","REV","11","17","17","n̂-paje na: «Ebbejeje Lubba ke nje singa-mɔngu, ei ke e-to bbasine neenn ddem, e-to lew baa, jari wooyo, mba ddew tɔku singa-mɔngu te lei, e-dda are kɔn-mbay to lei ngaa. ");
INSERT INTO ksp_vpl VALUES ("RV11_18","096_11_18","REV","11","18","18","Gel-dewje ke toje to lei ang ddaje wungu, a bbasene, kare wungu lei ase ngaa. Kare gange sariya dɔ dewje te ke oy ase ngaa. To kare ke a kuka ne nje-kulaje lei ke toje to nje-kilaje mber-tar lei, nje ke toje to dewje lei, ke nje ke aw bbelje rii, dede ke n̂-toje to dewje ke ngaji, ke dede ke n̂-toje to dewje ke bo. To kare ke a tuju ne dewje ke aw tujuje nange.» ");
INSERT INTO ksp_vpl VALUES ("RV11_19","096_11_19","REV","11","19","19","Ta key-polo-Lubba ke to me dara te ɔru, ngaa sanduku dɔnɔ ubba me key-polo te laa le. Ndi teel, nduje bbarje, ndi ndange, nange yeke ngaa kɔju gayn ke singa. ");
INSERT INTO ksp_vpl VALUES ("RV12_1","096_12_1","REV","12","1","1","Mare tɔku ne ubba me dara te. Mare dene ula kare rɔe te toke kubbu, neyn to kɔ gɔle te, ngaa endeterendeje dɔku gire joo toje dɔe te to ejɔkudɔ. ");
INSERT INTO ksp_vpl VALUES ("RV12_2","096_12_2","REV","12","2","2","Nuwa sem, naw nduru ndo, are naw nuru ekii mba aw toe nya. ");
INSERT INTO ksp_vpl VALUES ("RV12_3","096_12_3","REV","12","3","3","Mare ne dang tel ubba me dara te. Mare tɔku da ke toke le mar, rɔe kase toke le puru, dɔe siri, a gaje dɔku. Ejɔkudɔje siri toje dɔeje te ke siri le. ");
INSERT INTO ksp_vpl VALUES ("RV12_4","096_12_4","REV","12","4","4","Toke n̂-kayn endeterendeje ke darâ me mota a, bbɔnge tɔku da le saa debbe endeterendeje kara tilade nangê. Tɔku da le ddee ar nɔ dene te ke aw nduru ndo le aw ngina, ta bbo nuju taar a, kunn ngonn le kuse ke loe baa. ");
INSERT INTO ksp_vpl VALUES ("RV12_5","096_12_5","REV","12","5","5","Dene le uju ngonn ke dingaw. Ngonn le a, a kɔnn gel-dewje tɔyn ke singa ke ngeng nya. Dunn ngonn le daw saa mbɔr Lubba te, mbɔr ngende-mbay te laa. ");
INSERT INTO ksp_vpl VALUES ("RV12_6","096_12_6","REV","12","6","6","A dene le ayn aw me kɔr te, lo te ke Lubba mɔse are, kare n̂-ngeme ke ne-kusa ke te mba ndɔ doro kara, kɔr joo gire dɔmisan (1 260). ");
INSERT INTO ksp_vpl VALUES ("RV12_7","096_12_7","REV","12","7","7","Ddɔ in me dara te. Misel* de ke anjije laa n̂-ddɔje ke tɔku da ke unda rɔ mar le. A da le, ke anjije laa n̂-ddɔje ke de tɔ. ");
INSERT INTO ksp_vpl VALUES ("RV12_8","096_12_8","REV","12","8","8","A singa da le uta le Misel le ang. Yeenn a, da le ke anjije laa, deeje ke ddew ta nayn me dara te ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("RV12_9","096_12_9","REV","12","9","9","Yeenn ngaa dunn tɔku da le, ne li ke lew baa ke daw n̂-bbare to Esu, to Satan, ne nje-kere dewje ke dɔ nange te tɔyn le dilae dɔ nange te, de ke anjije laa. ");
INSERT INTO ksp_vpl VALUES ("RV12_10","096_12_10","REV","12","10","10","Moo mare ndu bbar ke singa me dara te na: «Bbasine Lubba ajije ngaa, n̂-tɔju singa-mɔngu, ke kɔn-bbe laa ngaa. Mesi laa tɔju singa laa ngaa. Mba duta ne nje-kunda tar dɔ ngakɔnje te le, ne ke naw nunda tar dɔde te nɔ Lubba te, til, ke kare le dilae nangê mban. ");
INSERT INTO ksp_vpl VALUES ("RV12_11","096_12_11","REV","12","11","11","A ngakɔnje le teteje ddɔ dɔe te, wɔju dɔ mese Ngonn Bate ddem, wɔju dɔ tar le Lubba ke n̂-paje tar-naje ddem. Dooje tebbe lede njaa to ne ke baa ddem, n̂-bbeelje yo ang ddem. ");
INSERT INTO ksp_vpl VALUES ("RV12_12","096_12_12","REV","12","12","12","Mba yeenn a, see daraje, ke see dewje ke isije darâ ddem, e-ddaje rɔ-neel. A see nange, ke ba-kate, kem-to ndoo a ddase. Mba Esu ddisi ke dɔse te ke wungu ke bo nya, mba n̂-gere to ndɔ laa nayn nya ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("RV12_13","096_12_13","REV","12","13","13","Toke tɔku da le oo to duta ne dilane dɔ nange te mban a, unn kutu tubba dene ke uju ngonn ke dingaw le. ");
INSERT INTO ksp_vpl VALUES ("RV12_14","096_12_14","REV","12","14","14","A dare dene le ubba bake joo toke le bake tɔku tende kare nin ne naw ne me kɔr te, lo te ke n̂-mɔse wɔju dɔe, kare dare ne-kusa ke te n̂-geme ne ddew ew ke li le. Na nayn baann lo teenn mba bbal muta ke gaen. ");
INSERT INTO ksp_vpl VALUES ("RV12_15","096_12_15","REV","12","15","15","Yeenn ngaa li le tɔmɔ maann toke le ba go dene te le kare maann le uwae ɔtu saa. ");
INSERT INTO ksp_vpl VALUES ("RV12_16","096_12_16","REV","12","16","16","A nange ddee uma dene le. Nange teyn tae uru ne ba ke tɔku da le tɔmɔ le. ");
INSERT INTO ksp_vpl VALUES ("RV12_17","096_12_17","REV","12","17","17","Wungu ɔn da le dɔ dene te le, ngaa tel ke dɔ kese dewje te ke gel dene te le, aw dda ddɔ ke de. To dede ke daw n̂-ngemje nduje le Lubba, ke tar-najije le Jeju. ");
INSERT INTO ksp_vpl VALUES ("RV12_18","096_12_18","REV","12","18","18","Goe te a, tɔku da le aw ar dɔ enangara ba-kate te. ");
INSERT INTO ksp_vpl VALUES ("RV13_1","096_13_1","REV","13","1","1","Goe te a, moo mare da in me ba-kate te tee. Gaje ee dɔku, a dɔe ee siri. Ejɔkudɔ dɔku toje dɔ gajeje te le kara kara, ngaa n̂-dda rije ke toje to ri taji Lubba dɔeje te le kara kara tɔyn. ");
INSERT INTO ksp_vpl VALUES ("RV13_2","096_13_2","REV","13","2","2","Da ke mooe le unda rɔ kake. Gɔle toke le gɔl enjakemnjar, a tae toke ta tebeyn. Tɔku da ke unda rɔ mare le are singa-mɔngu laa, ke ngende-mbay laa, ke singa ke ngeng nya. ");
INSERT INTO ksp_vpl VALUES ("RV13_3","096_13_3","REV","13","3","3","Mare dɔe le kara toke ne ke dare do ke ase kare noy ne. A do ke ase kare noy ne le ere. Dewje ke dɔ nange te tɔyn ooje neenn le a gange singade, ngaa unnje go da le. ");
INSERT INTO ksp_vpl VALUES ("RV13_4","096_13_4","REV","13","4","4","Dewje tɔyn ɔsuje mekeji gɔlde nangê nɔ da te ke unda rɔ mar te le, mba singa ke nare da ke in me ba-kate te tee le. Dede tɔyn dɔsuje mekeji gɔlde nangê nɔ da te ke in me ba-kate te tee le, ngaa n̂-paje na: «Na ase naa ke da le wa? Na ase ta ddɔ saa wa?» ");
INSERT INTO ksp_vpl VALUES ("RV13_5","096_13_5","REV","13","5","5","Dare ddew da le kare pa tar-boroje ddem, kare taji Lubba ddem. Dare singa kare n̂-dda nejeenn mba neyn dɔsɔ gire joo. ");
INSERT INTO ksp_vpl VALUES ("RV13_6","096_13_6","REV","13","6","6","Nunn kutu taji Lubba, taji ria, taji lo-kisi laa, taji dewje tɔyn ke isije darâ. ");
INSERT INTO ksp_vpl VALUES ("RV13_7","096_13_7","REV","13","7","7","Dare ddew kare n̂-dda ddɔ ke dewje le Lubba, ngaa ta kutade ke singa. Dare singa dɔ dewje te ke gel-kujude dang dang tɔyn, dɔ dewje ke bbeje te tɔyn, ke dɔ dewje te ke ndɔn-tarje lede toje dang dang tɔyn, ke dɔ dewje te ke gelde dang dang tɔyn. ");
INSERT INTO ksp_vpl VALUES ("RV13_8","096_13_8","REV","13","8","8","Dewje tɔyn ke dɔ nange te a poloje da ke in me ba-kate te tee le. To nje ke lew baa ke Lubba dda neje, ride goto maketuru tebbe te le Ngonn Bate ke n̂-tɔle to ne-polo le. ");
INSERT INTO ksp_vpl VALUES ("RV13_9","096_13_9","REV","13","9","9","Dew ke mbia to a, maji kare oo tar neenn! ");
INSERT INTO ksp_vpl VALUES ("RV13_10","096_13_10","REV","13","10","10","Dew ke Lubba wɔju kare duwae to bbere a, da kuwae to bbere. Dew ke Lubba wɔju kare n̂-tɔle ke tɔku kiya a, da tɔle ke tɔku kiya. Kare neenn to kare ke ta kare dewje le Lubba tɔje wurde, ngaa uwaje koo me te lede are ngeng. ");
INSERT INTO ksp_vpl VALUES ("RV13_11","096_13_11","REV","13","11","11","Goe te a, moo mare da dang unda lo me nange te tee. Gaje ee joo toke gaji ngonn bate. A naw n̂-pa tar toke tɔku da ke unda rɔ marjeenn. ");
INSERT INTO ksp_vpl VALUES ("RV13_12","096_13_12","REV","13","12","12","Naw n̂-dda kula ke singa ke da ke in me maann te tee ee ne le dɔ-keme te njaa. N̂-dda nare nange, ke dewje ke isije dɔ nange te aw ɔsuje mekeji gɔlde nɔ da te ke in me maann te tee, ke do laa ase kare noy ne bba do le ere le. ");
INSERT INTO ksp_vpl VALUES ("RV13_13","096_13_13","REV","13","13","13","N̂-dda tɔku ne-mɔrije ndereng, nare puru in darâ oso dɔ nange te kem dewje te. ");
INSERT INTO ksp_vpl VALUES ("RV13_14","096_13_14","REV","13","14","14","Nere dewje ke dɔ nange te, ddew ne-mɔrije te ke dare singa kare n̂-dda dɔ-kem da te ke in me maann te tee le, nare n̂-ddaje mare kɔr ke unda rɔ da ke inga do tɔku kiya, a oy ang le. ");
INSERT INTO ksp_vpl VALUES ("RV13_15","096_13_15","REV","13","15","15","Dare singa kare nula kewn me kɔr te ke unda rɔ da ke in me maann te tee le. Kɔr le a pa tar, ngaa a dda kar n̂-tɔl dewje tɔyn ke a mbeteje ta kɔsu mekeji gɔlde nange nɔ kɔr te le. ");
INSERT INTO ksp_vpl VALUES ("RV13_16","096_13_16","REV","13","16","16","Da le uwa dewje tɔyn njaa ke singa are n̂-dda mare endaji me jide te ke kɔl, wase engo-nɔde te: Nje ke bo, ke nje ke ngaji, nje-ne-kingaje, ke nje-ndooje, bbereje, ke nje ke toje to bbereje ang. ");
INSERT INTO ksp_vpl VALUES ("RV13_17","096_13_17","REV","13","17","17","Dew ke endaji le to rɔe te ang a, a kase ndoko ne ang ddem, a kase labbe ne ang ddem. Endaji le to ri da le wase nimɔrɔ ria. ");
INSERT INTO ksp_vpl VALUES ("RV13_18","096_13_18","REV","13","18","18","Kare te neenn, maji kare kem dew are. Dew ke to nje-ne-gere a, a gere kande nimɔrɔ le da le, mba to nimɔrɔ le mare dew. Nimɔrɔ le to kɔr misan, ke dɔmisan gire misan. ");
INSERT INTO ksp_vpl VALUES ("RV14_1","096_14_1","REV","14","1","1","Maa lo bbay a, moo Ngonn bate le ar dɔ ddingiri te ke Siyɔn*. Dewje doro kɔr kara, ke dɔsɔ gire sɔ (144 000) eeje mbɔre te. N̂-dda ri Ngonn bate le, ke ri bɔeje engo-nɔde te. ");
INSERT INTO ksp_vpl VALUES ("RV14_2","096_14_2","REV","14","2","2","Moo mare ndu bbar me dara te toke kɔru tɔku ba ke aw ula ddem, toke ndi ke aw ndange ke singa ddem. Ndu ke moo le bbar toke kɔru konde ke dewje aw em. ");
INSERT INTO ksp_vpl VALUES ("RV14_3","096_14_3","REV","14","3","3","Dewje le aw ɔsuje pa ke siki nɔ ngende-mbay te le, nɔ neje te ke toje kem baa ke sɔ le, ke nɔ tɔkuje te le. Dew kara ke a kase ndo pa le goto. Bbaye njaa to dede ke doro kɔr kara ke dɔsɔ gire sɔ (144 000) ke Ngonn bate uka dɔde dɔ nange te le. ");
INSERT INTO ksp_vpl VALUES ("RV14_4","096_14_4","REV","14","4","4","Dede le dulaje rɔde ne-yerew te ddew te le deneje ang, mba n̂-gereje dene ang. Daw dunnje go Ngonn bate le loje te tɔyn ke naw naw te. Lubba uka dɔde horo dewje te, kare n̂-ddeeje to dɔngɔr dewje laa ddem, le Ngonn bate le ddem. ");
INSERT INTO ksp_vpl VALUES ("RV14_5","096_14_5","REV","14","5","5","Dereje ngem ndɔ kara ang. Tar kara to dɔde te ang. ");
INSERT INTO ksp_vpl VALUES ("RV14_6","096_14_6","REV","14","6","6","Goe ta a, moo mare anji dang ke aw ila me dara te taar nu. Nee ke Tar ke maji ke to ke ndɔ ke ndɔ ta pa kare dewje ke dɔ nange te: Dewje ke gelde dang dang tɔyn, dewje ke gel-kujude dang dang, dewje ke ndɔ-tarje lede dang dang, ke dewje ke bbeje te dang dang tɔyn. ");
INSERT INTO ksp_vpl VALUES ("RV14_7","096_14_7","REV","14","7","7","Anji le pa tar ke singa na: «E-bbeelje Lubba, ngaa ɔsuje gaje. Mba kare ke na gange ne sariya dɔ dewje te ase ngaa. E-poloje nje-dda dara ke nange, ke tɔku-ba, ke loje ke maannje aw inje ke te aw teeje.» ");
INSERT INTO ksp_vpl VALUES ("RV14_8","096_14_8","REV","14","8","8","Mare anji ke to joo laa ddee go ye te ke dɔngɔr le ngaa pa na: «Babilɔnn bbe-bo le oso mban, noso mban. Ne a nare dewje ke gelde dang dang tɔyn ayje ben kaya laa ke wɔn to puru le.» ");
INSERT INTO ksp_vpl VALUES ("RV14_9","096_14_9","REV","14","9","9","Mare anji ke dang ke to muta laa ddee go nje ke joo te le, ngaa pa ke singa na: «Bbo dew ɔsu mekeji gɔle nange nɔ da te le, ke nɔ kɔr te ke unda rɔ da le, ngaa dɔsu endaji da le engo-nɔe te, wase me jia te a, ");
INSERT INTO ksp_vpl VALUES ("RV14_10","096_14_10","REV","14","10","10","ne kara na kay ben tɔku wungu le Lubba, ke n̂-pole ang a dungu me engo wungu te laa. Ngaa na koo ndoo kem puru te, ke kem supere te, kem anjije te ke maji tɔyn ddem, kem Ngonn bate te ddem. ");
INSERT INTO ksp_vpl VALUES ("RV14_11","096_14_11","REV","14","11","11","Puru ke aw ula kemde ndoo le sae a kubba bbal ke bbal. Ngaa dewje ke aw poloje da le, ke kɔr ke unda rɔ da le, ke dede ke dɔsu endaji ri da le rɔde te, til ke kare, da kuwaje rɔde ang. ");
INSERT INTO ksp_vpl VALUES ("RV14_12","096_14_12","REV","14","12","12","Kare neenn to kare ke dewje le Lubba ke aw ngemje nduje laa, ngaa naynje ddew koo me te te ke Jeju a kuwaje kare ngeng ann. ");
INSERT INTO ksp_vpl VALUES ("RV14_13","096_14_13","REV","14","13","13","Moo mare ndu ke in darâ, ngaa pa arem na: «Uja tar neenn maketuru te: ‹Rɔ-neel to le dewje ke naynje ddew te le Ebbe-dewje ndereng oyje ne, bbasene neenn. Ndil-me-nda pa na: Tɔkɔrɔ njaa, maji kare duwaje rɔde go kula te ke ngeng ke n̂-ddaje, mba kulaje ke n̂-ddaje a kunnje gode.› » ");
INSERT INTO ksp_vpl VALUES ("RV14_14","096_14_14","REV","14","14","14","Maa lo bbay a, moo mare mum ke nda to nda. Mare ne ke unda rɔ dew isi dɔ mum te le. Nunda ejɔkedɔ ke n̂-dda ke ande dɔe te, ngaa nuwa kiya ke ate jia te. ");
INSERT INTO ksp_vpl VALUES ("RV14_15","096_14_15","REV","14","15","15","Mare anji dang in key-polo-Lubba te tee, ngaa uru ekii ke singa are dew ke isi dɔ mum te le na: «Ula kiya lei bbo uja ko le, mba kare kuja ko le ase ngaa. Kande ko ke dɔ nange te sange ngaa.» ");
INSERT INTO ksp_vpl VALUES ("RV14_16","096_14_16","REV","14","16","16","Yeenn ngaa, dew ke isi dɔ mum te le ula kiya laa le dɔ nange te, ngaa uja ko ke dɔ nange te tɔyn. ");
INSERT INTO ksp_vpl VALUES ("RV14_17","096_14_17","REV","14","17","17","Goe te a, mare anji dang in key-polo-Lubba te darâ tee. Ne njaa kara nuwa kiya ke ate jia te tɔ. ");
INSERT INTO ksp_vpl VALUES ("RV14_18","096_14_18","REV","14","18","18","Mare anji dang bbay in er bann te tee. Nee ke singa kunn ndu kare puru dda ne ne. Nuru ekii ke singa nare anji ke uwa kiya ke ate le na: «Ula kiya lei ke ate le bbo uja ne jinga binye ke dɔ nange te, mba kande binye le oy mban. ");
INSERT INTO ksp_vpl VALUES ("RV14_19","096_14_19","REV","14","19","19","Anji le ula kiya laa le dɔ nange te, ngaa tuja jinga binye ke dɔ nange te le ungu me ne-kore maann binye te ke tɔju tɔku wungu le Lubba. ");
INSERT INTO ksp_vpl VALUES ("RV14_20","096_14_20","REV","14","20","20","Dore binye me ne-kore maann binye te le giri bbe te ddaka. Mese in me ne-kore maann binye te le tee, ngaa siri ke taar ndereng taa lo ase kilometere kɔr mota (300). Bbo sunda uru me mese te le a, mese le a kuwae ka-tae te taar. ");
INSERT INTO ksp_vpl VALUES ("RV15_1","096_15_1","REV","15","1","1","Goe te a, moo mare ne ke bo ddem, ke kura laa dum dɔ dewje ddem me dara te: Anjije siri uwaje ne-kem-to ndooje siri jide te. To dɔbɔyn ne-kem-to-ndooje, mba ddew te lede a, wungu le Lubba ddee dɔ dewje te. ");
INSERT INTO ksp_vpl VALUES ("RV15_2","096_15_2","REV","15","2","2","Moo mare ne toke bajeenn, keme are yerere toke er ke dew unda keme te a oo ne lo, pole naa ke puru. Dewje ke teteje ddɔ dɔ da te le, ke dɔ kɔr ke unda rɔ da te le, ke dɔ nimɔrɔ ria te le arje dɔ ba-kate te le. Duwaje kondeje le Lubba jide te. ");
INSERT INTO ksp_vpl VALUES ("RV15_3","096_15_3","REV","15","3","3","Daw dɔsuje pa le Mɔyije ke to nje-kula le Lubba ddem, pa le Ngonn bate ddem na: « Ebbe-dewje Lubba ke Nje-singa-mɔngu, neje ke e-dda boje nya ddem, kuraje lede dum dɔ dewje ddem! Tɔku mbay le gel-dewje, Aw dda neje ke dɔgɔle ddem, aw dda ne ke tɔkɔrɔ ddem. ");
INSERT INTO ksp_vpl VALUES ("RV15_4","096_15_4","REV","15","4","4","Ebbe-dewje, na a bbeel rii ang, ngaa a kɔsu gaji rii ang wa? Mba ei kara baa a, e-maji tɔyn. Gel-dewje tɔyn a ddee kɔsuje gɔlde nangê nɔi te, mba dede tɔyn dooje ne-ddaje lei ke gate gate. ");
INSERT INTO ksp_vpl VALUES ("RV15_5","096_15_5","REV","15","5","5","Goe te a, moo key-polo-Lubba me dara te, tae toke teyn. Key tande ke Lubba de ke dewje laa daw dingaje naa me te, to me te. ");
INSERT INTO ksp_vpl VALUES ("RV15_6","096_15_6","REV","15","6","6","Anjije ke siri ke uwaje ne-kem-to ndooje siri jide te le inje key-polo-Lubba te le teeje. Dulaje kubbu ke nda ngaa ndɔren. N̂-tɔje endaar-kuwa-bber ke n̂-dda ke ande karde te. ");
INSERT INTO ksp_vpl VALUES ("RV15_7","096_15_7","REV","15","7","7","Kara le neje ke toje kem baa ke sɔ le are engoje ke n̂-dda ke ande anjije ke siri le kara kara. Wungu le Lubba ke Nje-kisi ke ndɔ ke ndɔ ddusu engoje le. ");
INSERT INTO ksp_vpl VALUES ("RV15_8","096_15_8","REV","15","8","8","Sa ke tɔju piti le Lubba, ke singa-mɔngu laa taa me key-polo-Lubba le tɔyn. Dew kara ase ta kande key-polo-Lubba te le ang ndereng ta ne-kem-to-ndooje ke siri ke ji anjije te ke siri le tunga bba. ");
INSERT INTO ksp_vpl VALUES ("RV16_1","096_16_1","REV","16","1","1","Moo mare ndu bbar toke bo key-polo-Lubba te le, ngaa pa are anjije ke siri le na: « Awje e-mbelje engo wunguje le Lubba ke siri le dɔ nange te!» ");
INSERT INTO ksp_vpl VALUES ("RV16_2","096_16_2","REV","16","2","2","Anji ke to dɔngɔre aw mbel wungu ke me engo te laa dɔ nange te. Do ke maji ang ddem, aw to nya ddem oso rɔ dewje te ke endaji le da le to rɔde te, ngaa aw poloje kɔr ke unda rɔ da le. ");
INSERT INTO ksp_vpl VALUES ("RV16_3","096_16_3","REV","16","3","3","Joo le anji mbel wungu ke me engo te laa le me ba-kate te. Ba-kate le tel toke le mese dew ke oy, are neje ke kem tɔyn ke eeje me ba-kate te le oyje. ");
INSERT INTO ksp_vpl VALUES ("RV16_4","096_16_4","REV","16","4","4","Mota le anji le mbel wungu ke me engo te laa me baje te, ke loje te ke maannje inje te bba aw aynje are mannje le turuje to mese. ");
INSERT INTO ksp_vpl VALUES ("RV16_5","096_16_5","REV","16","5","5","Moo ndu anji ke ɔn dɔ maannje pa na: « Ei ke e-to bbokone ddem, e-to lew ddem, e-maji tɔyn ddem, e-to gate gate wɔju dɔ sariyaje ke e-gange neenn. ");
INSERT INTO ksp_vpl VALUES ("RV16_6","096_16_6","REV","16","6","6","N̂-kaynje mese dewje lei ddem, mese nje-kilaje mber-tar lei ddem. Mba yeenn a arede mese kare dayje. Ne ke ase ta dda ke de ann. ");
INSERT INTO ksp_vpl VALUES ("RV16_7","096_16_7","REV","16","7","7","Goe te a, moo mare ndu ke bbar bann te le na: « Tɔkɔrɔ njaa, Ebbe-dewje Lubba ke nje-singa-mɔngu, sariyaje lei to sariyaje ke tɔkɔrɔ ddem, gate gate ddem. ");
INSERT INTO ksp_vpl VALUES ("RV16_8","096_16_8","REV","16","8","8","Sɔ le anji le mbel wungu ke engo te laa dɔ kare te. Dare ddew kare le kare puru laa ɔn dewje. ");
INSERT INTO ksp_vpl VALUES ("RV16_9","096_16_9","REV","16","9","9","Puru kare ke tunga nya le ɔn dewje le. N̂-tajije ri Lubba ke ee ke singa dɔ ne-kem-to-ndooje te neenn tɔyn le. A n̂-turuje ddew lede mba kɔsu gaje ang. ");
INSERT INTO ksp_vpl VALUES ("RV16_10","096_16_10","REV","16","10","10","Mi le anji le mbel wungu ke me engo te laa dɔ ngende-mbay te le da le. Yeenn ngaa, lo tuka ndul dɔ bbe-kɔn te le da le. Kem-to-ndoo uta dɔ dewje are dewje ngerje ngangede. ");
INSERT INTO ksp_vpl VALUES ("RV16_11","096_16_11","REV","16","11","11","N̂-tajije ri Lubba ke darâ mba ndoo ke daw dooje ddem, mba do ke maji ang ke oso rɔde te le ddem. A n̂-tusuje kula-ddadeje ke maji ang dinyaje ang. ");
INSERT INTO ksp_vpl VALUES ("RV16_12","096_16_12","REV","16","12","12","Misan le anji le mbel wungu ke me engo te laa me tɔku ba te ke ria na Eparate. Maann le ii mba kinya ddew kare tɔku mbayje ke inje er lo tee te le kare aw ddeeje. ");
INSERT INTO ksp_vpl VALUES ("RV16_13","096_16_13","REV","16","13","13","Ngaa, moo ndilje ke maji ang mota, kare in me kil da te ke unda rɔ mar le tee, kara in me kil da te le, kara in me kil nje-kila mber-tar te ke to nje-ngem le aw teeje. Ndilje ke maji ang ke mota le undaje rɔ enginaynje. ");
INSERT INTO ksp_vpl VALUES ("RV16_14","096_16_14","REV","16","14","14","To ndilje ke maji ang ke aw ddaje ne-mɔrije. Dawje ta kinga tɔku mbayje ke dɔ nange te tɔyn ta mbɔnde ngina ne ddɔ ke tɔku ndɔ te le Lubba ke nje-singa-mɔngu. ");
INSERT INTO ksp_vpl VALUES ("RV16_15","096_16_15","REV","16","15","15","Ebbe-dewje pa na: « Oo, maw m-ddee toke nje-bboko. Rɔ-neel to le dew ke isi kem baa bbo tibbi ang, ngaa ngem kubbu rɔe te. Baann bba na nja rɔe baa kare dew ooe a to ne-rɔ-kul ang.» ");
INSERT INTO ksp_vpl VALUES ("RV16_16","096_16_16","REV","16","16","16","Ndilje ke maji ang le mbɔnje mbayje le lo te ke daw n̂-bbar ke tar Ebere na Armagedɔn. ");
INSERT INTO ksp_vpl VALUES ("RV16_17","096_16_17","REV","16","17","17","Anji ke to siri laa mbel wungu ke me engo te laa me yel te. Mare ndu bbar ke singa ngende-mbay te ke key-polo-Lubba te le na: « Bbaye ngaa!» ");
INSERT INTO ksp_vpl VALUES ("RV16_18","096_16_18","REV","16","18","18","Ndi teel nya nya, nduje bbar, ndi ndange nya nya, ngaa nange yeke ke singa. Lew baa ke dewje toje dɔ nange te, ndɔ kara nange nayn yeke toke baann ang bbay. ");
INSERT INTO ksp_vpl VALUES ("RV16_19","096_16_19","REV","16","19","19","Babylɔnn, tɔku bbe le kayn loe mota, ngaa tɔku bbeje le gel-dewje osoje. Yeenn ngaa Lubba ole mee dɔ Babilɔnn bbe-bo te le, ngaa are ben ke to wungu laa ke aw wɔn to puru me engo te dewje ke me bbe te le ayje. ");
INSERT INTO ksp_vpl VALUES ("RV16_20","096_16_20","REV","16","20","20","Dɔ-dere-maannje tɔyn aynje ngaa ddingirije gotoje. ");
INSERT INTO ksp_vpl VALUES ("RV16_21","096_16_21","REV","16","21","21","Kɔjuje ke boje nya, ngaa ɔyje ase ne ke kilo dɔsɔ inje darâ gaynje dɔ dewje te, ngaa dewje le tajije ri Lubba mba ne ndoo ke kɔju le dda ke de le, mba to ndoo ke to bbeel nya. ");
INSERT INTO ksp_vpl VALUES ("RV17_1","096_17_1","REV","17","1","1","Goe te a, mare anji kara horo anjije te ke siri ke uwaje engoje siri jide te le, ddee ngaa pa arem na: «E-ddee, ma tɔji sariya ke da gange dɔ dene te ke to tɔku nje-kaya ke isi mbɔr tɔku baje te le. ");
INSERT INTO ksp_vpl VALUES ("RV17_2","096_17_2","REV","17","2","2","Ne a tɔku mbayje ke dɔ nange te ddaje ne-kaya dɔe te, ngaa dewje ke dɔ nange te ayje ben kaya laa are ddade.» ");
INSERT INTO ksp_vpl VALUES ("RV17_3","096_17_3","REV","17","3","3","Goe te a, Ndil uwam, ngaa anji le unnum aw sem me kɔr te, a moo mare dene isi dɔ mare da te ke kase to kase. Rɔe tɔyn to ri ne-tajije ke ta taji ne Lubba dɔrɔ. Dɔe ee siri ngaa gaje dɔku. ");
INSERT INTO ksp_vpl VALUES ("RV17_4","096_17_4","REV","17","4","4","Dene le ula kubbu ke kase, ke kura, ngaa ndɔren to ndɔren. Nula ne-mandeje ke n̂-dda ke ande, ke kɔr erje ke gate ngeng, ke mereje. Nuwa engo ande jia te. Ne-yerewje, ke ne-kayaje laa ke ase koo ke kem ang ddusuje me engo le. ");
INSERT INTO ksp_vpl VALUES ("RV17_5","096_17_5","REV","17","5","5","N̂-dda mare ri engo-nɔe te, to ri ke dew gere kande ang. Ri le na: « Babilɔnn bbe-bo, kɔn dene nje-kayaje, kɔn neje ke dɔ nange te ke ase ta koo ke kem ang.» ");
INSERT INTO ksp_vpl VALUES ("RV17_6","096_17_6","REV","17","6","6","Moo dene le a, mese dewje le Lubba, ke mese nje-tar-najije le Jeju ke nay le aw ddae toke le koto. Koo ke mooe a, mem unda dɔ binya nya. ");
INSERT INTO ksp_vpl VALUES ("RV17_7","096_17_7","REV","17","7","7","Yeenn ngaa anji le pa arem na: « Mei aw unda dɔ binya mba ddi wa? Ma pa ne ke iya rɔe ke dɔ dene te neenn, ke ye ke dɔ da te ke dɔe ee siri, ngaa gaje ee dɔku ke nisi dɔe te neenn kari. ");
INSERT INTO ksp_vpl VALUES ("RV17_8","096_17_8","REV","17","8","8","Da ke ooe le to lew, a n̂-to ang ngaa. Na kin buwa te ke suren goto le tee, ta kaw nayn ke kɔrɔ nyɔm. Bbo dewje ke dɔ nange te, ke kunn kutu neje te nu duja ride maketuru tebbe te ang, ooje da le a, mede a kunda dɔ binya. Mba n̂-to lew, a n̂-to ang ngaa, a na tel kunda lo tee bbay. ");
INSERT INTO ksp_vpl VALUES ("RV17_9","096_17_9","REV","17","9","9","Kare te neenn, maji kare nje-ne-gere ee ke kem-kare tɔ bba: Dɔ da ke siri le toje to ddingirije siri ke dene le isi dɔe te, n̂-toje to tɔku mbayje siri tɔ. ");
INSERT INTO ksp_vpl VALUES ("RV17_10","096_17_10","REV","17","10","10","Nje ke mi osoje mban. Misan lede aw ɔn mbay, a siri lede nayn ddee ang bbay. A bbo n̂-ddee a, na kisi mba gɔju kare baa. ");
INSERT INTO ksp_vpl VALUES ("RV17_11","096_17_11","REV","17","11","11","Da ke to lew, a goto ngaa le, ne njaa n̂-to jijoo le tɔku mbayje le. N̂-to kara le nje ke siri le tɔ. Naw ta nayn ke kɔrɔ baa nyɔm. ");
INSERT INTO ksp_vpl VALUES ("RV17_12","096_17_12","REV","17","12","12","Gaji da ke dɔku ke oo le to tɔku mbayje dɔku ke nayn ɔnje mbay ang bbay. A da kinga singa ke ta kɔn ne mbay mba gɔl kare kara ke da le. ");
INSERT INTO ksp_vpl VALUES ("RV17_13","096_17_13","REV","17","13","13","Dede dɔku tɔyn keje lede kara baa: Ta kare da le singa-mɔngu lede, ke singa lede. ");
INSERT INTO ksp_vpl VALUES ("RV17_14","096_17_14","REV","17","14","14","Da ddaje ddɔ ke Ngonn bate le, a Ngonn bate le a kutade ke singa, mba n̂-to Ebbe ebbe-dewje ddem, n̂-to Mbay dɔ mbayje ddem. Nje ke Lubba bbarde, ke nje ke n̂-mberede, ke dewje laa ke eeje saa, a kutade ke singa tɔ. ");
INSERT INTO ksp_vpl VALUES ("RV17_15","096_17_15","REV","17","15","15","Goe te a, anji le pa arem bbay na: Maannje ke dene nje-kaya le isi mbɔre te, ke oo le to dewje dang dang, to dewje ke banya, nje ke gelde dang dang, ke dewje ke ndɔn-tarje lede to dang dang. ");
INSERT INTO ksp_vpl VALUES ("RV17_16","096_17_16","REV","17","16","16","Gaji da ke dɔku ke oo le, ke da le, da mbeteje dene nje-kaya le, da taa neje laa tɔyn, ngaa da kinyaeje rɔe baa. Da kusaje taal rɔe ngaa da roeje ke puru. ");
INSERT INTO ksp_vpl VALUES ("RV17_17","096_17_17","REV","17","17","17","Mba Lubba ula keje laa mede te kare n̂-ddaje ne ke mee ndiki. Da ddaje ne ke kara baa. Da kinya singa kɔn mbay lede ji da te le ndereng ta kare tarje le Lubba ddeeje to ne ke tɔkɔrɔ. ");
INSERT INTO ksp_vpl VALUES ("RV17_18","096_17_18","REV","17","18","18","Dɔbɔnye, dene ke ooe le to tɔku bbe ke ɔn dɔ tɔku mbayje ke dɔ nange te. ");
INSERT INTO ksp_vpl VALUES ("RV18_1","096_18_1","REV","18","1","1","Goe te a, moo mare anji dang in darâ aw ddisi. Nee ke singa ke ngeng, ngaa ndoko laa uru dɔ nange te. ");
INSERT INTO ksp_vpl VALUES ("RV18_2","096_18_2","REV","18","2","2","Nuru ekii ke singa na: «Noso mban, noso mban, Babilɔnn bbe-bo le! N̂-ddee to lo dda bbe, ke lo kiya rɔ le ndilje ke maji ang dang dang tɔyn, le eelje ke maji ang dang dang tɔyn ke dewje ndikije ang. ");
INSERT INTO ksp_vpl VALUES ("RV18_3","096_18_3","REV","18","3","3","Mba gel-dewje tɔyn ayje ben kaya laa ke wɔn to puru le. Tɔku mbayje ke dɔ nange te ddaje ne-kaya dɔe te. Ngaa nje-ne-labbeje ke dɔ nange te ingaje ne nya wɔju dɔ ne-kingaje ke gate ngeng ke n̂-dda bboe nya le.» ");
INSERT INTO ksp_vpl VALUES ("RV18_4","096_18_4","REV","18","4","4","Goe te a, moo mare ndu me dara te na: « See dewje lem, e-teeje me tɔku bbe te neenn ke ddang, mba kare e-ddaje saa majang laa ang, bba kare ne kem-to-ndoo oso dɔse te saa tɔ ang. ");
INSERT INTO ksp_vpl VALUES ("RV18_5","096_18_5","REV","18","5","5","Mba majangje laa bayanje ke dɔ naa te dɔ naa te ndereng ɔru dara, are Lubba ole mee dɔ ne-ddaje te laa ke toje gate gate ang le. ");
INSERT INTO ksp_vpl VALUES ("RV18_6","096_18_6","REV","18","6","6","E-ddaje saa ne ddew kara baa toke ye ke n̂-dda ke nje-mareje. Ne ke n̂-dda ke dew gɔl kara a, e-ddaje saa gɔl joo. Engo ke nungu ben me te a, unguje te gɔl joo areje. ");
INSERT INTO ksp_vpl VALUES ("RV18_7","096_18_7","REV","18","7","7","N̂-ndiki kɔsu gaji rɔe nya ddem, n̂-ndiki ne-kinga nya ddem. Yeenn a, ulaje keme ndoo, areje nuwa ndoo ddew kara baa toke baann tɔ. Mba n̂-pa mee te na: ‹Misi to dene-mbay, m-to dene-ndubba ang, ngaa ma kuwa ndoo ndɔ kara ang.› ");
INSERT INTO ksp_vpl VALUES ("RV18_8","096_18_8","REV","18","8","8","Mba yeenn a, ne-kem-to-ndooje ke toje wɔju dɔe a kosoje dɔe te ndɔ kara baa njaa. Neje le toje to: Yo, ndoo, ke tɔku bbo, ngaa puru a kɔen. Mba Ebbe-dewje Lubba ke gange sariya dɔe te le to nje singa-mɔngu.» ");
INSERT INTO ksp_vpl VALUES ("RV18_9","096_18_9","REV","18","9","9","Yeenn ngaa, tɔku mbayje tɔyn ke dɔ nange te, ke ddaje ne-kaya dɔe te ddem, ddaje saa bbo ne-kingaje ddem le a nɔnje, ngaa da ndinga rɔde kare te ke da kooje sa puru ke aw ɔen le. ");
INSERT INTO ksp_vpl VALUES ("RV18_10","096_18_10","REV","18","10","10","Ndoo ke naw noo le a ddade bbeel, ngaa da karje ddew ew bba da paje na: « Ne kem-to-ndoo bbo!, Ne kem-to-ndoo ke baann bba be wa! Tɔku bbe, Babilɔnn, tɔku bbe ke ngeng! Me gɔl kare te kara baa njaa sariya ddee dɔi te toke be wa!» ");
INSERT INTO ksp_vpl VALUES ("RV18_11","096_18_11","REV","18","11","11","Nje-ne-labbeje ke dɔ nange te nɔnje ngaa uwaje ndoo mbae, mba nje-ndoko neje lede goto ngaa. ");
INSERT INTO ksp_vpl VALUES ("RV18_12","096_18_12","REV","18","12","12","Neje toke ande, ande-nare, kɔr erje ke gate ngeng, mereje, kubbuje ke n̂-dda ke len, ke kase, ke ndɔren, ke yeje ke n̂-dda ke sowa, kakeje tɔyn ke eteje maji, neje ke n̂-dda ke ngange kere, neje tɔyn ke n̂-dda ke kake ke gate ngeng, neje ke n̂-dda ke tungu, ke ande-nare wase, ke er ke kura ke ria na marebere. ");
INSERT INTO ksp_vpl VALUES ("RV18_13","096_18_13","REV","18","13","13","Neje ke maji dang dang ke daw njiri ne ne, yamboje, ne ke ria na mir, nɔn kakeje ke ete maji, ben, ubbu, nduju, bele, mangeje, bateje, sundaje ke sareteje, bbereje, ke dewje ke duwade ta ddɔ te to bbereje.› ");
INSERT INTO ksp_vpl VALUES ("RV18_14","096_18_14","REV","18","14","14","Nje-ne-labbeje le paje na: « Neje ke aw dda bboe nya lew le aynje awje ddew ew sei ngaa. Ne-kingaje lei ke maji wase ndɔren le gotoje tɔyn jii te ngaa. Da tel kinga ture te ang ngaa.» ");
INSERT INTO ksp_vpl VALUES ("RV18_15","096_18_15","REV","18","15","15","Nje-ne-labbje ke ingaje ne wɔju dɔe le a kooje ndoo ke naw noo le a, bbeel a ddade, ngaa da karje ddew ew a da nɔnje ddem, da kuwaje ndoo ddem. ");
INSERT INTO ksp_vpl VALUES ("RV18_16","096_18_16","REV","18","16","16","Da paje na: «Ne kem-to-ndoo bbo! Ne kem-to-ndoo bbo! Dɔngɔr, tɔku bbe neenn aw ula kubbuje ke kura, ke kase, ke ndɔren. Naw nula ne-mbije, ke ne-jije ke n̂-dda ke ande, ke kɔr erje ke gate ngeng, ke mereje le! ");
INSERT INTO ksp_vpl VALUES ("RV18_17","096_18_17","REV","18","17","17","A me gɔl kare te kara baa njaa ne-kingaje laa ke banya le tɔyn tujuje ne wa?» Ngaa nje-kuwa tɔku toje tɔyn, ke dewje ke aw ddaje kula dɔ ba-kate te, ke nje ke aw njaje dɔ ba-kate te ke tɔku to, ke dewje ke aw ingaje ne-kusa tade ddew kula te ke dɔ ba-kate te, areje ddew ew, ");
INSERT INTO ksp_vpl VALUES ("RV18_18","096_18_18","REV","18","18","18","ngaa ooje sa puru ke aw ɔen le a, uruje ekii na: «Tɔku bbe ke dda bba ase naa ke bbe-bo wa?» ");
INSERT INTO ksp_vpl VALUES ("RV18_19","096_18_19","REV","18","19","19","Daw n̂-jinje ebaburu nange dunguje dɔde te, n̂-nɔnje, n̂-ndingaje ndoo n̂-paje na: «Ne kem-to-ndoo bbo! Ne kem-to-ndoo bbo! Bbe-bo, bbe ke ddew ne-kinga te laa ke banya, nje tɔku toje tɔyn ingaje ne ne le, me gɔl kare te kara baa njaa n̂-tel to dɔ-ndubba wa!» ");
INSERT INTO ksp_vpl VALUES ("RV18_20","096_18_20","REV","18","20","20","Dewje ke darâ, e-ddaje rɔ-neel mba koso le Babilɔnn le. See dewje le Lubba, see nje-kayn-kulaje, ke nje-kilaje mber-tar le Lubba, e-ddaje rɔ-neel tɔ, mba Lubba gange sariya dɔe te wɔju dɔ ne ke n̂-dda ke se le. ");
INSERT INTO ksp_vpl VALUES ("RV18_21","096_18_21","REV","18","21","21","Mare anji ke nje-singa-mɔngu unn mare tɔku biri er ke ɔɔy, ila me ba-kate te, ngaa pa na: «Da kila Babilɔnn bbe-bo ke singa toke be tɔ: Da tel kingae ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("RV18_22","096_18_22","REV","18","22","22","Dew a koo kɔru ne-kem le nje-kondeje bbe lei ang ngaa ddem, ndu nje-nɔ paje ang ngaa ddem, kɔru ne-to le nje-kɔlje mbula, ke nje-toje tebbe ang ddem. Dew a kinga nje-gusu ke aw dda mare kula kara bbe lei ang ngaa ddem, dew a koo kɔru ne ke daw duru biri-er te bbe lei ang ngaa ddem. ");
INSERT INTO ksp_vpl VALUES ("RV18_23","096_18_23","REV","18","23","23","Puru lambe a ndoko me bbe te lei ang ngaa ddem, dew a koo ndu basan de ke ngonn mande ke n̂-taaje naa toke siki bbe lei ang ngaa ddem, mba nje-ne-labbeje ke bbe lei toje to dewje ke ngeng ke dɔ nange te, ngaa ne-kumaje lei ke aw dda ereje gel-dewje tɔyn. ");
INSERT INTO ksp_vpl VALUES ("RV18_24","096_18_24","REV","18","24","24","Mba bbê lei a n̂-kayn mese dewje tɔyn ke n̂-tɔlde dɔ nange te, ke mese nje-kilaje mber-tar le Lubba, ke le dewje le Lubba.» ");
INSERT INTO ksp_vpl VALUES ("RV19_1","096_19_1","REV","19","1","1","Goe te a, moo mare ndu bbar bo toke ndu dewje ke banya me dara te na: «Aleluya! Kaji, piti, ke singa-mɔngu toje to le Lubba leje. ");
INSERT INTO ksp_vpl VALUES ("RV19_2","096_19_2","REV","19","2","2","Mba sariyaje laa ke naw n̂-gange toje ke dɔgɔle ddem, toje gate gate ddem. N̂-gange sariya dɔ tɔku dene nje-kaya te ke tuju dɔ nange ke kaya laa, ngaa nila bare mese nje-kulaje laa ke n̂-tɔlde le dɔe te.» ");
INSERT INTO ksp_vpl VALUES ("RV19_3","096_19_3","REV","19","3","3","Ngaa n̂-tel n̂-paje bbay na: «Aleluya! Sa puru ke ɔn tɔku bbe le aw tu ke ndɔ ke ndɔ.» ");
INSERT INTO ksp_vpl VALUES ("RV19_4","096_19_4","REV","19","4","4","Tɔkuje ke dɔjoo gire sɔ le, ke neje ke toje kem baa ke sɔ le ɔsuje mekeji gɔlde nangê ngaa poloje Lubba ke isi ngende-mbay te laa. N̂-paje na: « Amem! Aleluya!» ");
INSERT INTO ksp_vpl VALUES ("RV19_5","096_19_5","REV","19","5","5","Ngaa, mare ndu bbar ngende-mbay te le na: «Ɔsuje gaji Lubba leje, see nje-kulaje laa tɔyn, sese ke ngaji, ke nje ke bo ke aw bbeeleje!» ");
INSERT INTO ksp_vpl VALUES ("RV19_6","096_19_6","REV","19","6","6","Moo mare ndu toke ndu dewje ke banya ddem, toke kɔru tɔku maann ddem, toke kɔru ndi ke ndange ke singa ddem. Ndu le na: «Aleluya! Mba Ebbe-dewje Lubba, Nje-singa-mɔngu aw ɔn bbe ngaa. ");
INSERT INTO ksp_vpl VALUES ("RV19_7","096_19_7","REV","19","7","7","N-ddaje rɔ-neel, jareje rɔje neelje, n-piteje, mba kare kusu taa-naa le Ngonn bate le ase ngaa, ngaa dene laa le mɔse rɔe mban. ");
INSERT INTO ksp_vpl VALUES ("RV19_8","096_19_8","REV","19","8","8","Dare nula kubbu len ke ndɔren ngaa ne-yerew ɔru ang.» Mba kubbu len le to kula-ddaje ke gate gate ke dewje le Lubba ddaje. ");
INSERT INTO ksp_vpl VALUES ("RV19_9","096_19_9","REV","19","9","9","Anji le pa arem na: «Uja tar neenn maketuru te: ‹Rɔ-neel to le dewje ke n̂-bbarde kusu taa-naa te le Ngonn bate!› » Goe te a, n̂-pa narem na: «To tarje le Lubba njaa.» ");
INSERT INTO ksp_vpl VALUES ("RV19_10","096_19_10","REV","19","10","10","M-tee moso kɔ gɔle te ta poloe, a n̂-pa narem na: « E-dda neenn ang! M-to nje-kula mari ddem, nje-kula mare ngakɔinje ke aw ngemje tar-najije le Jeju ddem. Lubba a maji kare e-poloe!» Tar-najije le Jeju toje to tarje ke ddeeje dɔ nje-kilaje mber-tarje te le Lubba bba aw paje. ");
INSERT INTO ksp_vpl VALUES ("RV19_11","096_19_11","REV","19","11","11","Goe te a, moo dara teyn, a moo sunda ke nda. Dew ke aal sunda le ria na Dew ke aw dda ne ke dɔgɔle, Dew ke tɔkɔrɔ. Naw n̂-gange sariya, ngaa naw n̂-dda ddɔ ddew ne te ke gate gate. ");
INSERT INTO ksp_vpl VALUES ("RV19_12","096_19_12","REV","19","12","12","Keme to toke puru ke aw ɔn. Ejɔkudɔ banya banya toje dɔe te. N̂-dda mare ri rɔe te, a ne ke kare baa njaa n̂-gere ri le. ");
INSERT INTO ksp_vpl VALUES ("RV19_13","096_19_13","REV","19","13","13","Ngaa nula kubbu ke ngal ke to mese tɔyn. Ria na Tar le Lubba. ");
INSERT INTO ksp_vpl VALUES ("RV19_14","096_19_14","REV","19","14","14","Nje-ddɔje ke darâ isije dɔ sundaje te ke nda, ngaa aw ɔruje goe. Dulaje kubbu len ke kura, ke nda, ngaa ne-yerew ɔru ang. ");
INSERT INTO ksp_vpl VALUES ("RV19_15","096_19_15","REV","19","15","15","Mare tɔku kiya ke ate in ta dew te ke aal sunda le tee ta tuka ne gel-dewje. Na kɔn dɔde ngeng nya. Na tɔju wungu le Lubba ke nje singa-mɔngu, wungu laa ke aw wɔn to puru ddew mbɔyn te ke na mbɔyde ke gɔle toke le kande binye me ne kore maann binye te. ");
INSERT INTO ksp_vpl VALUES ("RV19_16","096_19_16","REV","19","16","16","N̂-dda mare ri kubbu te laa ke ngal le ddem, benge te ddem na: «Mbay-dɔ-mbayje, ke Ebbe ebbe-dewjeje.» ");
INSERT INTO ksp_vpl VALUES ("RV19_17","096_19_17","REV","19","17","17","Goe te a, moo mare anji ar taar me kare te. Nuru ekii ke singa nare eelje tɔyn ke aw ilaje me dara te na: «E-ddee e-mbɔnje naa mba tɔku kusu le Lubba, ");
INSERT INTO ksp_vpl VALUES ("RV19_18","096_19_18","REV","19","18","18","mba kɔn tal tɔku mbayje, tal mbayje le mbambaje, ke tal nje-singa-mɔnguje. Tal sundaje, ke tal nje-kaalje sundaje le, tal dewje tɔyn, dewje ke toje to bbereje, ke dewje ke toje to bbereje ang, tal dewje ke ngaji, ke dewje ke bo. ");
INSERT INTO ksp_vpl VALUES ("RV19_19","096_19_19","REV","19","19","19","Goe te a, moo da le, ke tɔku mbayje ke dɔ nange te, ke mbambaje lede. N̂-mbɔnje naa ta ddɔ ke dew ke isi dɔ sunda te le, ne ke mbambaje laa. ");
INSERT INTO ksp_vpl VALUES ("RV19_20","096_19_20","REV","19","20","20","Duwa da le, ke nje-kila mber-tar ke to nje-ngem ke dda ne-mɔrije nɔe te bba ere ne nje ke endaji da laa to engo-nɔde te, ngaa aw poloje kɔr ke unda rɔ da le. Dungude joo kem ndake puru supere te ke aw ɔn. ");
INSERT INTO ksp_vpl VALUES ("RV19_21","096_19_21","REV","19","21","21","N̂-tɔl keseje ke tɔku kiya ke in ta dew te ke isi dɔ sunda te tee le, ngaa eelje tɔyn ɔnje talde are mede ndann. ");
INSERT INTO ksp_vpl VALUES ("RV20_1","096_20_1","REV","20","1","1","Goe te a, moo mare anji in darâ aw ddisi. Nuwa ngaw kele ta tɔku buwa ke suren goto le, ke kula njamji ke ɔɔy jia te. ");
INSERT INTO ksp_vpl VALUES ("RV20_2","096_20_2","REV","20","2","2","Nuwa da ke unda rɔ mar, ke to li ke lew, ke to esu, ke to Satan le, ngaa n̂-tɔe ke kula njamji mba bbal doro kara (1 000). ");
INSERT INTO ksp_vpl VALUES ("RV20_3","096_20_3","REV","20","3","3","Nilae tɔku buwa te ke suren goto le, ngaa nutu ta buwa le n̂-lete dɔe te, mba kare nere gel-dewje ang ngaa, ndereng mba bbal doro kara le. Goe te a, da tute mba mare kare ngaji. ");
INSERT INTO ksp_vpl VALUES ("RV20_4","096_20_4","REV","20","4","4","Goe te a, moo ngende-mbayje. Dare singa dewje ke isije dɔe te kare n̂-gangeje sariya. Moo ndil dewje ke n̂-tɔlde mba tar-naji le Jeju ke n̂-paje ddem, mba tar le Lubba ddem. Moo ndil dede ke n̂-mbeteje ta kɔsuje mekeje gɔlde nɔ da te le, ke nɔ kɔr te ke unda rɔ da le, are dɔsu endaji engo-nɔde te ang ddem, me jide te ang ddem le tɔ. N̂-ndolje ngaa dɔnje mbay ke Kiriste ase bbal doro kara (1 000). ");
INSERT INTO ksp_vpl VALUES ("RV20_5","096_20_5","REV","20","5","5","Kese dewje ke oyje ndolje ang, ndereng bbal doro kara le ase. Yeenn to dɔngɔr ndol le dewje ke oy. ");
INSERT INTO ksp_vpl VALUES ("RV20_6","096_20_6","REV","20","6","6","Rɔ-neel to le dewje ke eeje horo dewje te ke ndolje dɔngɔr ndol te le dewje ke oy. N̂-toje to dewje le Lubba njaa! Yo ke gɔl joo laa ee ke singa dɔde te ang. Da toje to nje-poloje le Lubba ddem, le Kiriste ddem, ngaa da kɔnje saa mbay bbal doro kara le. ");
INSERT INTO ksp_vpl VALUES ("RV20_7","096_20_7","REV","20","7","7","Toke bbal doro kara le tunga a, da kɔru Satan key-kula te, ");
INSERT INTO ksp_vpl VALUES ("RV20_8","096_20_8","REV","20","8","8","ngaa na kaw kere gel dewje kɔyn nange te ke sɔ tɔyn, yeenn pa na Goge, ke Magoge**. Na mbɔn dewje le mba dda ne ddɔ. Kɔrde banya toke enangara ta ba-kate. ");
INSERT INTO ksp_vpl VALUES ("RV20_9","096_20_9","REV","20","9","9","N̂-taaje dɔ nange tɔyn, ngaa n̂-gukuje dɔ gɔng le dewje le Lubba, ke dɔ tɔku bbe ke Lubba ndiki nya. A puru in darâ ddisi, ngaa ɔnde. ");
INSERT INTO ksp_vpl VALUES ("RV20_10","096_20_10","REV","20","10","10","Ngaa dila esu ke nje-kerede le me ndake puru te ke supere to me te, lo te ke da le, ke nje-kila mber-tar ke to nje-ngem le eeje te. Da koo ndoo nya, kare, ke til, bbal ke bbal. ");
INSERT INTO ksp_vpl VALUES ("RV20_11","096_20_11","REV","20","11","11","Goe te a, moo tɔku ngende-mbay ke nda, ke dew ke isi te. Nange, ke dara ɔtuje aynje nɔe te ke ddang, are dew tel oode ang ngaa. ");
INSERT INTO ksp_vpl VALUES ("RV20_12","096_20_12","REV","20","12","12","Ngaa moo dewje ke oy, nje ke ngaji, ke nje ke bo, darje taar nɔ ngende-mbay te le. N̂-teyn maketuruje, a n̂-tel n̂-teyn mare maketuru bbay, to maketuru tebbe. Ngaa n̂-gange sariya dɔ dewje te ke oy ase kem kula ddade, ddew kara baa toke ye ke n̂-dda maketuruje te le. ");
INSERT INTO ksp_vpl VALUES ("RV20_13","096_20_13","REV","20","13","13","Ba-kate tee ke ninn dewje ke naynje mee te. Ngaa yo, ke lo le dewje ke oy teeje ke ninn dewje ke toje mee te, are n̂-gange sariya dɔde te kara kare ase kem kula ddade. ");
INSERT INTO ksp_vpl VALUES ("RV20_14","096_20_14","REV","20","14","14","Goe te a, dungu yo, ke lo le dewje ke oy me ndake puru te. Ndake puru le to yo ke gɔl joo laa. ");
INSERT INTO ksp_vpl VALUES ("RV20_15","096_20_15","REV","20","15","15","Dew ke dinga ria maketuru tebbe te le ang a, dilae ndake puru te le. ");
INSERT INTO ksp_vpl VALUES ("RV21_1","096_21_1","REV","21","1","1","Goe te a, moo dara ke siki, ke nange ke siki. Mba dara ke dɔngɔr, ke nange ke dɔngɔr ikije, ngaa ba-kate goto ngaa. ");
INSERT INTO ksp_vpl VALUES ("RV21_2","096_21_2","REV","21","2","2","Ngaa moo tɔku bbe ke maji tɔyn, ke to Jurusalam ke siki ke in rɔ Lubba te darâ aw ddisi. Tɔku bbe le to toke le dene ke dda mande ngaa ar dɔ gɔle te aw ngina ngaweje. ");
INSERT INTO ksp_vpl VALUES ("RV21_3","096_21_3","REV","21","3","3","Moo ndu bbar ke singa ngende-mbay te le na: « Bbasine, key le Lubba to horo dewje te ngaa. Na dda bbe ke de, ngaa da toje to dewje laa. Ne Lubba njaa na kisi ke de, ngaa na to Lubba lede. ");
INSERT INTO ksp_vpl VALUES ("RV21_4","096_21_4","REV","21","4","4","Na bɔru maann-nɔ tɔyn kemde te. Yo a goto ngaa. Ndoo, ekii, ke ne-wungu a gotoje, mba konn neje ndayje mban.» ");
INSERT INTO ksp_vpl VALUES ("RV21_5","096_21_5","REV","21","5","5","Ngaa dew ke isi ngende-mbay te le pa na: «Oo! M-dda neje tɔyn toke siki ngaa.» N̂-pa na: «Uja tarje neenn maketuru te. Mba tarje lem to tarje ke tɔkɔrɔ, ngaa aseje kare dew unda mee dɔe te.» ");
INSERT INTO ksp_vpl VALUES ("RV21_6","096_21_6","REV","21","6","6","Ngaa n̂-pa narem na: «Bbaye ngaa! M-to Alpa, ke Omega, m-to kunn kutu ne ddem, dɔbɔyn ne ddem. Dew ke kunda ɔen a, ema, ma kare maann ke aw are tebbe nay baa. To maann ke aw in me nange te aw tee. ");
INSERT INTO ksp_vpl VALUES ("RV21_7","096_21_7","REV","21","7","7","Dew ke tete ddɔ a, ma kare nejeenn le ddeeje to laa. Ma to Lubba laa, ngaa na to ngonnum. ");
INSERT INTO ksp_vpl VALUES ("RV21_8","096_21_8","REV","21","8","8","A nje-bbeelje, nje ke tusuje me-kunn inyaje, nje-ne-ddaje ke maji ang, nje-tɔl dewje, nje-ddaje lo-to-majang, nje-kumaje, nje-poloje kɔr, ke nje-ngemje tɔyn, lo lede to me ndake puru ke supere to me te. Yeenn to yo ke gɔl joo laa. ");
INSERT INTO ksp_vpl VALUES ("RV21_9","096_21_9","REV","21","9","9","Goe te a, anji kara horo nje ke siri te ke uwaje engo ne-wunguje ke siri jide te le ddee pa arem na: «E-ddee are m-tɔji nje-ngaw le, dene le Ngonn bate le.» ");
INSERT INTO ksp_vpl VALUES ("RV21_10","096_21_10","REV","21","10","10","Ndil uwam, ngaa anji le unnum aw sem dɔ ddingiri te ke bo, ngaa ndew. N̂-tɔjum Jurusalam, tɔku bbe ke maji tɔyn ke in darâ rɔ Lubba te aw ddisi le. ");
INSERT INTO ksp_vpl VALUES ("RV21_11","096_21_11","REV","21","11","11","Ndoko le Lubba dda are Jurusalam le ndɔren. Ndɔnre laa le toke ndɔren le kɔr er ke gate ngeng, ke le kɔr er ke ria na jasepe ke are yerere. ");
INSERT INTO ksp_vpl VALUES ("RV21_12","096_21_12","REV","21","12","12","Ndoko ke dila n̂-guku ne dɔ tɔku bbe le ndeer ddem, ndew ddem. Ta ndoko le dɔku gire joo. Anjije dɔku gire joo arje ta ndokoje te le kara kara. N̂-dda rije ta ndokoje te le. To ri gel ngann Ijarayelje ke dɔku gire joo. ");
INSERT INTO ksp_vpl VALUES ("RV21_13","096_21_13","REV","21","13","13","Ta ndokoje le mota toje er lo tee te le kare, mota toje er kande te le kare, mota er dagoo, mota er beer. ");
INSERT INTO ksp_vpl VALUES ("RV21_14","096_21_14","REV","21","14","14","Dɔsu ndoko le dɔ erje te dɔku gire joo ke dungu ne gɔle, ngaa n̂-dda ri nje-kayn-kulaje le Ngonn bate ke dɔku gire joo kare erje te ke dɔku gire joo le kara kara. ");
INSERT INTO ksp_vpl VALUES ("RV21_15","096_21_15","REV","21","15","15","Anji ke aw pa sem tar le uwa mare ne ke daw dɔju ne ne jia te. Ne le toke le kare waa. N̂-dda ke ande. Nuwa ne le ta kɔju ne tɔku bbe le, ta ndokoje le, ke ndoko le. ");
INSERT INTO ksp_vpl VALUES ("RV21_16","096_21_16","REV","21","16","16","Mbo-kare bbe le ee sɔ. Ngal laa, ke tate laa ase naa. Anji le ɔju bbe le ke ne-kɔju ne ke jia te le, a ngal laa, tate laa, ke ndew laa ase kilometere doro joo gire kɔr sɔ (2 400). ");
INSERT INTO ksp_vpl VALUES ("RV21_17","096_21_17","REV","21","17","17","Nɔju ndoko le ddew kara baa toke gusu ke dewje aw ɔju ne ne a, ngal ase meren ji dew dɔ-siri gire joo. ");
INSERT INTO ksp_vpl VALUES ("RV21_18","096_21_18","REV","21","18","18","Dɔsu ndoko le ke er ke ria na jasepe, a n̂-dda tɔku bbe le ke ande ke yerew ɔru ang ngaa keme are yerere. ");
INSERT INTO ksp_vpl VALUES ("RV21_19","096_21_19","REV","21","19","19","N̂-dda kare er ke dɔsu ne gɔl ndoko le ke erje dang dang ke gate ngeng dare kura. N̂-dda kar dɔngɔr er ke dɔsu ne gɔl ndoko le ke er ke ria na jasepe, joo laa ke sapir, mota laa ke kalseduwann, sɔ laa ke emerode, ");
INSERT INTO ksp_vpl VALUES ("RV21_20","096_21_20","REV","21","20","20","mi laa ke saredonikisi, misan laa ke sarduwann, siri laa ke kirijolite, jijoo laa ke beril, jikara laa ke topaje, dɔku laa ke kirijoparaje, dɔku gire kara laa ke yasente, dɔku gire joo laa ke ametisite. ");
INSERT INTO ksp_vpl VALUES ("RV21_21","096_21_21","REV","21","21","21","Ta ndokoje ke dɔku gire joo le toje to mereje dɔku gire joo. Ta ndoko kara a, n̂-dda ke mere kara baa. N̂-dda nate tɔku bbe le ke ande ke yerew ɔru ang, ngaa keme are yerere. ");
INSERT INTO ksp_vpl VALUES ("RV21_22","096_21_22","REV","21","22","22","A moo key-polo-Lubba me tɔku bbe te le ang. Mba, Ebbe-dewje Lubba ke Nje-singa-mɔngu njaa, de ke Ngonn bate a n̂-toje to key-polo-Lubba ke me tɔku bbe te le. ");
INSERT INTO ksp_vpl VALUES ("RV21_23","096_21_23","REV","21","23","23","Duju kare, kare ɔsu, wase kare neyn nda, bba kare me tɔku bbe le ndoko ang. Mba ndoko le Lubba a aw dda are mee aw ndoko, ngaa Ngonn bate le a to puru ngel me tɔku bbe te le. ");
INSERT INTO ksp_vpl VALUES ("RV21_24","096_21_24","REV","21","24","24","Gel-dewje a njaje lo-kare te le tɔku bbe le, ngaa tɔku mbayje ke dɔ nange te a ddeeje ke ne-pitije lede me te. ");
INSERT INTO ksp_vpl VALUES ("RV21_25","096_21_25","REV","21","25","25","Ta ndokoje le a kutuje ndɔ kara ang, mba lo teenn til a goto ngaa. ");
INSERT INTO ksp_vpl VALUES ("RV21_26","096_21_26","REV","21","26","26","Dewje a ddeeje ke ne-pitije, ke ne-kingaje le gel dewje me bbe te le. ");
INSERT INTO ksp_vpl VALUES ("RV21_27","096_21_27","REV","21","27","27","Ne-yerew kara a kande me bbe te le ang nyɔm. Dew ke nje-dda ne ke ase koo ke kem ang, wase nje-ngem a kande me bbe te le ang tɔ. Nje ke n̂-dda ride maketutu tebbe te le Ngonn bate njaa ke karede baa a, a kandeje me bbe te le. ");
INSERT INTO ksp_vpl VALUES ("RV22_1","096_22_1","REV","22","1","1","Goe te a, anji le tɔjum ba ke maanne aw are tebbe dew, keme are yerere. Maann le ubba ngende-mbay te le Lubba de ke Ngonn bate le aw tee, ");
INSERT INTO ksp_vpl VALUES ("RV22_2","096_22_2","REV","22","2","2","ngaa aw ula dann nate tɔku bbe te le. Mbɔr maann te le er joo kem, kake ke aw are tebbe dew to te. Me bbal te kara a, kake le ande gɔl dɔku gire joo. Neyn kara a, nande gɔl kara kara. Kame to kuma kaji gel-dewje. ");
INSERT INTO ksp_vpl VALUES ("RV22_3","096_22_3","REV","22","3","3","Mare ne ke ndu-ndɔɔl le Lubba a to dɔe te a to ang ngaa. Ngende-mbay le Lubba, ke le Ngonn bate a toje me bbe te le. Nje-kulaje le Lubba a poleje. ");
INSERT INTO ksp_vpl VALUES ("RV22_4","096_22_4","REV","22","4","4","Da kooje keme ngaa ria a to engo-nɔde te. ");
INSERT INTO ksp_vpl VALUES ("RV22_5","096_22_5","REV","22","5","5","Til a goto ngaa. Dew a duju puru lambe, wase a ngina kɔsu le kare bba ta koo ne lo ang. Mba ndoko le Ebbe-dewje Lubba njaa a kuru dɔde te, ngaa da kɔnje mbay bbal ke bbal. ");
INSERT INTO ksp_vpl VALUES ("RV22_6","096_22_6","REV","22","6","6","Goe te a, anji le pa arem na: «Tarje neenn to tarje ke tɔkɔrɔ, ngaa ase kare dew unda mee dɔe te. Ebbe-dewje Lubba ke are Ndil laa ddee dɔ nje-kilaje mber-tar te laa, ula anji laa kare tɔju nje-kulaje laa ne ke nayn ngɔsi baa ta ddee. ");
INSERT INTO ksp_vpl VALUES ("RV22_7","096_22_7","REV","22","7","7","Jeju pa na: Oo, maw m-ddee ngɔsi baa ngaa. Rɔ-neel to le dewje ke aw ngemje tarje ke dila mbere me maketuru te neenn! ");
INSERT INTO ksp_vpl VALUES ("RV22_8","096_22_8","REV","22","8","8","Ema Jan njaa, moo neje neenn ke mbim ddem, ke kem ddem. Ngaa, goe te ke moo neje le ke mbim ddem, ke kem ddem le a, m-tee moso nɔ gɔl anji te ke aw tɔjum neje le ta poloe. ");
INSERT INTO ksp_vpl VALUES ("RV22_9","096_22_9","REV","22","9","9","A n̂-pa narem na: «E-dda neenn ang! M-to nje-kula mari, ke nje-kula mare ngakɔinje ke toje to nje-kilaje mber-tar le Lubba, ke nje-kula mare dewje ke ngemje tarje ke maketuru te neenn. Lubba a maji kare e-pole.» ");
INSERT INTO ksp_vpl VALUES ("RV22_10","096_22_10","REV","22","10","10","Goe te a, n̂-pa narem na: « E-kusu tarje le Lubba ke dila mbere me maketuru te neenn ang. Mba kare nayn ngɔsi baa ngaa. ");
INSERT INTO ksp_vpl VALUES ("RV22_11","096_22_11","REV","22","11","11","Maji kare dew ke to gate gate ang, to gate gate ang ke kete kete bbay. Ngaa, nje-ne-yerew ddee to nje-ne-yerew ke kete kete bbay. A maji kare dew ke to gate gate, dda ne ke gate gate ke kete kete bbay. Ngaa maji kare dew ke sange rɔe mba Lubba a, sange rɔe ke kete kete bbay.» ");
INSERT INTO ksp_vpl VALUES ("RV22_12","096_22_12","REV","22","12","12","Jeju pa na: « Oo, maw m-ddee ngɔsi baa. Maw m-ddee ke kuka le dew kara kara ase kula-ddae. ");
INSERT INTO ksp_vpl VALUES ("RV22_13","096_22_13","REV","22","13","13","M-to Alpa, ke Omega. M-to dew ke dɔngɔr ddem, dɔbɔyn dew ddem. M-to kunn kutu ne ddem, dɔbɔyn ne ddem. ");
INSERT INTO ksp_vpl VALUES ("RV22_14","096_22_14","REV","22","14","14","Rɔ-neel to le dewje ke aw tokoje kubbuje lede, ta kee ke ddew kusa kande kake ke aw are tebbe dew ddem, ta kande ke ta-ndoko me bbe te le ddem. ");
INSERT INTO ksp_vpl VALUES ("RV22_15","096_22_15","REV","22","15","15","See dewje ke e-toje toke le bisije, nje-kumaje, ke nje-ddaje lo-to majang, nje-tɔlje dewje, nje-poloje kɔr, nje ke ndikije ngem ddem, aw ereje ngem ddem, e-naynje ddaka nunn. ");
INSERT INTO ksp_vpl VALUES ("RV22_16","096_22_16","REV","22","16","16","« Ema Jeju, mula anji lem kare pa tar najije neenn tɔyn arese me Egilisije te. M-to dew ke gel nuju te le Dabbiti. M-to endeterende ke ta lo-kare te ke ndoko nya.» ");
INSERT INTO ksp_vpl VALUES ("RV22_17","096_22_17","REV","22","17","17","Ndil de ke dene ke nje-ngaw le, n̂-paje na: «E-ddee!» Maji kare dew ke oo tar neenn pa tɔ na: «E-ddee!» Maji kare dew ke kunda ɔen ddee. Dew ke ndiki a, taa maann ke aw are tebbe dew le baa njaa ay! ");
INSERT INTO ksp_vpl VALUES ("RV22_18","096_22_18","REV","22","18","18","Ema Jan, m-pa mare dew tɔyn ke oo tarje le Lubba ke dila mbere me maketuru te neennn: Bbo dew ila mare tar dɔe te a, Lubba a kare ne-kem-to-ndooje ke n̂-pa tare maketuru te neenn oso dɔe te. ");
INSERT INTO ksp_vpl VALUES ("RV22_19","096_22_19","REV","22","19","19","A bbo dew ɔru mare tarje ke dila mbere me maketuru te neenn ke ddang a, Lubba a kɔru kande kake ke aw are tebbe, ke tɔku bbe ke maji tɔyn ke n̂-mɔse wɔju dɔe, ngaa n̂-dda tare maketuru te neenn jia te ke ddang. ");
INSERT INTO ksp_vpl VALUES ("RV22_20","096_22_20","REV","22","20","20","Dew ke pa tar-naji neje neenn le, pa na: «Tɔkɔrɔ, maw m-ddee ngɔsi baa.» Amem! E-ddee, Ebbe-dewje Jeju! ");
INSERT INTO ksp_vpl VALUES ("RV22_21","096_22_21","REV","22","21","21","Maji kare Ebbe-dewje Jeju dda ke se me-maji tɔyn.");
ALTER TABLE ksp_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
