﻿USE sofia;
DROP TABLE IF EXISTS sofia.ksj_vpl;
CREATE TABLE ksj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ksj_vpl WRITE;
INSERT INTO ksj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iesu Keriso vouḡa nizeꞌe ꞌahi eꞌe. Aniꞌe Aberahamo mariga ebu Davida mariga. ");
INSERT INTO ksj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aberahamoꞌe Isako moga, Isakoꞌe Iakobo moga, Iakoboꞌe Iuda zu ani negoḡa duḡuru moze. ");
INSERT INTO ksj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Iudaꞌe Pereze zu Zera moze ebu Tamaraꞌe zeḡe vize. Perezeꞌe Hezarona moga, Hezaronaꞌe Ramo moga. ");
INSERT INTO ksj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramoꞌe Aminadaba moga, Aminadabaꞌe Nasona moga, Nasonaꞌe Salamona moga. ");
INSERT INTO ksj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamonaꞌe Boazi moga ebu Rahabaꞌe Boazi viꞌa. Boaziꞌe Obeda moga ebu Rutaꞌe Obeda viꞌa. Obedaꞌe Iese moga. ");
INSERT INTO ksj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ieseꞌe kini Davida moga. Davidaꞌe Solomona moga ebu Basebaꞌe Solomona viꞌa. Basebaꞌe ibite Uria inuga. ");
INSERT INTO ksj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomonaꞌe Rehoboama moga, Rehoboamaꞌe Abia moga, Abiaꞌe Asa moga. ");
INSERT INTO ksj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaꞌe Iehosafata moga, Iehosafataꞌe Iehorama moga, Iehoramaꞌe Uzia moga. ");
INSERT INTO ksj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziaꞌe Iotama moga, Iotamaꞌe Ahasi moga, Ahasiꞌe Hezekia moga. ");
INSERT INTO ksj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiaꞌe Manase moga, Manaseꞌe Amona moga, Amonaꞌe Iosia moga. ");
INSERT INTO ksj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Iosiaꞌe Iekonia zu ani negoḡa duḡuru moze. Eꞌe madaḡano Babulonia azaḡaniꞌa Isaraela azaḡa teite utitadu Isaraela azaḡa Babulonia habaꞌano obozi onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babulonia habaꞌano obozi onamiroteꞌe ḡarugano, Iekoniaꞌe Sealetiele moga, Sealetieleꞌe Zerubabele moga. ");
INSERT INTO ksj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabeleꞌe Abiuda moga, Abiudaꞌe Eliakimi moga, Eliakimiꞌe Azora moga. ");
INSERT INTO ksj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoraꞌe Zadoka moga, Zadokaꞌe Akimi moga, Akimiꞌe Eliuda moga. ");
INSERT INTO ksj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudaꞌe Eleazara moga, Eleazaraꞌe Matana moga, Matanaꞌe Iakobo moga. ");
INSERT INTO ksj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Iakoboꞌe Iosefa moga ebu Iosefa inugaꞌe Maria. Mariaonoꞌo Keriso rae huneꞌeteꞌe vazeḡa, Iesuꞌa fureraro. ");
INSERT INTO ksj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Eꞌanoꞌo Aberahamonoꞌo onao Davida madaḡano zeḡe ega niduꞌaꞌe 14, zu Davidaonoꞌo onao Isaraela azaḡa Babulonia habaꞌano obozi onamiroteꞌe madaḡano zeḡe ega niduꞌaꞌe 14, ebu Babulonia habaꞌano obozi onamiroteꞌe madaḡanonoꞌo onao Keriso madaḡano zeḡe ega niduꞌaꞌe 14. ");
INSERT INTO ksj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iesu Kerisoꞌe ꞌahige fureraro. Ani viꞌa Mariaꞌe Iosefa iraꞌauḡa. Anianine ꞌizema hahurogano Mariaꞌe Vine Zaḡoḡanonoꞌo ahiꞌeta reiroteꞌe ederiro. ");
INSERT INTO ksj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Maria iꞌa Iosefaꞌe Badiꞌa ubumao duduḡa vazeḡa, eꞌanoꞌo hunihunio Maria mene mae mazagaronifine ani sifu tuḡune modiꞌuma rae zamariro. ");
INSERT INTO ksj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ani ꞌouge rae zamarirotene, Zuhiꞌa Boro tuḡure viga ꞌahoganiꞌa iḡunao fureranadu ꞌahige rae niro, “Davida mariga Iosefa, Maria teite hahuroga ago rihanoꞌi. Mazaḡa Mariaꞌe Vine Zaḡoḡanonoꞌo ahiꞌeta. ");
INSERT INTO ksj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Aniꞌe ubuga ꞌahoga furenoꞌidene, niḡaꞌe Iesu rae turahoꞌi, mazaḡa aniꞌe ane mone azaḡa haḡaize sauꞌanonoꞌo ḡaboziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ꞌOugadu Zuhiꞌa Boroꞌa peroveta vazeḡanonoꞌo rae fureniroteꞌe ḡoeꞌaniꞌa hudaro, ");
INSERT INTO ksj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ḡianoꞌi, ohoze ꞌize mene edereꞌeteꞌe nogobaḡaniꞌa ahiꞌeta reꞌuma, ebu ubuga ꞌahoga fureniꞌuma. Ubuga niḡaꞌe Imanuela rae huniꞌuma.” Imanuela hugaꞌe, “Badiꞌaꞌe emeḡe teite radiuꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Iosefaꞌa bazunanoꞌo evatirotene, Zuhiꞌa Boro tuḡure viganiꞌa niroteꞌe idunaḡano haḡairo, ebu Mariaꞌe ani inuga radu zamaharo. ");
INSERT INTO ksj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Rehano Iosefaꞌe Maria teite tibano mene baziro, onamo ubuga fureniro, ebu ubuga niḡaꞌe Iesu rae turahiro. ");
INSERT INTO ksj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herodaꞌe Iudea habaꞌa kiniḡa reiroteꞌe madaḡano Iesuꞌe Iudea habaꞌano ne ꞌahoga, Betelehemao fureraro. Eꞌe enogano edeḡa azaḡa nuꞌe madaꞌa iteꞌeteꞌe moneonoꞌo Ierusalemao feuri ariro. ");
INSERT INTO ksj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ebu ze vaze ḡadiziro, “Iuda azaḡa kini raꞌeteꞌe vazeḡaꞌe nouma fureraneha? Mazaḡa eme madaꞌa iteꞌeteꞌe moneo ani buzuva horoniro ebu ani mazao kuranoga veize areha.” ");
INSERT INTO ksj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kini Herodaꞌa ḡoereze igirotene, zamaḡaniꞌa adudaro ebu Ierusalema azaḡa niduꞌa zuni zamazeꞌa adudaro. ");
INSERT INTO ksj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Eꞌanoꞌo Herodaꞌa dibuꞌo vazeḡa ḡihiꞌaḡa zu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa niduꞌa nuꞌozadu ḡadiziro, “Kerisoꞌe nouma fureraꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Zeꞌa naenaeniro, “Aniꞌe Iudea habaꞌano Betelehema neḡano fureraꞌuma. Mazaḡa peroveta vazeḡaꞌe ꞌahige rae mirihiro, ");
INSERT INTO ksj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","'O Iudea habaꞌano ne ꞌahoga Betelehema, ḡaꞌe Iudea habaꞌano ne boroboro boꞌaḡano mene zuhuꞌa. Mazaḡa ḡae mazaonoꞌo vaze niduꞌa zuhiꞌaziteꞌe vazeḡa ꞌahoganiꞌa ariꞌuma. Aniꞌe mamoe taufeꞌeteꞌe vazeḡa teige, eḡe none azaḡa, Isaraela azaḡa taufiꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Eꞌanoꞌo Herodaꞌa edeḡa azaḡa sifu huzadu zeḡe mazaonoꞌo noꞌe madaḡano buzuva eꞌeꞌa agararotaꞌaꞌe ederiro. ");
INSERT INTO ksj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ebu edeḡa azaḡa Betelehema neḡano tuḡuzeꞌenaꞌa, ꞌahige rae ziro, “Onamadu ene guraḡa eꞌe faine vaḡoꞌi ebu horonoꞌidene ihohoꞌi. Eḡe zuni ani vaḡe onamadu ani mazao kuraꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ze Heroda ḡoere igi hauḡirotene, ibionoꞌo onamiro. Ze ibio onameꞌenogano, ibite madaꞌa iteꞌeteꞌe habaꞌano horoniroteꞌe buzuvaḡaniꞌa bare fureraro. Ze eꞌe horonadu matuꞌe rudaro. Ebu buzuva eꞌeꞌa ze ibitozeadu ene guraḡaniꞌa radiuꞌeteꞌe habaꞌa ragano tue radiro. ");
INSERT INTO ksj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ze ne zamaḡa diuḡadu ene guraḡaꞌe viꞌa Maria teite radiuꞌenoga horoniro. ꞌOugirotene, ze ani mazao ḡuḡuradu kuraro. Ebu ꞌumiroteꞌe ḡauḡa naeḡa boroboro fuhiꞌadu ḡahuno haro. Aꞌe golo zu ꞌuvahu hohoḡa manoḡa ebu murava hohoḡa manoḡa. ");
INSERT INTO ksj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ebu Badiꞌaꞌa iḡunao edeḡa azaḡa ihoziro, “Heroda vaḡe ago bare onamoꞌi.” ꞌOugadu zeꞌe ibi ꞌahoganonoꞌo zeḡe haba bare onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Edeḡa azaḡaniꞌa iḡuniroteꞌe enogano, Zuhiꞌa Boro tuḡure viganiꞌa iḡunao Iosefa mazao fureranadu niro, “Herodaꞌa ene guraḡa vaḡadu matihi raꞌohe. Eꞌanoꞌo iḡunoꞌi ebu ene guraḡa viꞌeta zamazadu Izipi habaꞌa ferau onamoꞌi. Ebu eꞌea radoꞌi onamo eḡeꞌa ḡeꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ꞌOugadu Iosefaꞌe ene guraḡa viꞌeta zamazadu ohere ferau Izipi habaꞌa onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ebu ze eꞌea radiro onamo Herodaꞌa rudaro. ꞌOugadu Zuhiꞌa Boroꞌa peroveta vazeḡanonoꞌo reiroteꞌe ḡoeꞌaniꞌa hudaro, “Eḡeꞌa Izipi habaꞌanonoꞌo ubudehe hune ariro.” ");
INSERT INTO ksj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodaꞌe edeḡa azaḡaniꞌa soꞌoniroteꞌe ederirotene, maḡune rudaro. Aniꞌe edeḡa azaḡaniꞌa ihoniroteꞌe madaḡa idunaḡano mada meꞌodadu ene aꞌe muri aheu heuḡa rae zamariro. Eꞌanoꞌo ane uti azaḡa tuḡuzadu Betelehema neḡa zu uhiḡa neḡa niduꞌa zamaḡano ohoze komeꞌa muri aheuonoꞌo onamo ene guraḡa ḡonaga niduꞌa zimi hauḡiro. ");
INSERT INTO ksj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ꞌOugadu Badiꞌaꞌa peroveta vazeḡa Ieremiaonoꞌo reiroteꞌe ḡoeꞌaniꞌa hudaro, ");
INSERT INTO ksj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama neḡano roḡae ꞌahoganiꞌa kuau niauꞌeteꞌe agoḡa igiro. Rahelaꞌa ubugaubuga uꞌano niaro, ebu ani vazeꞌa naminoga hezahoziniro, mazaḡa ubugaubuganiꞌa rudaro.” ");
INSERT INTO ksj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodaꞌa rudaroteꞌe enogano, Zuhiꞌa Boro tuḡure viga ꞌahoganiꞌa Izipi habaꞌano Iosefa mazao iḡunao fureraro ebu niro, ");
INSERT INTO ksj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Iḡunoꞌi ebu ene guraḡa viꞌeta Isaraela habaꞌa tutuze onamoꞌi. Mazaḡa ene guraḡa matihi reiroteꞌe azaḡa ꞌai rudau hauḡeha.” ");
INSERT INTO ksj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Eꞌanoꞌo Iosefaꞌa iḡunadu ene guraḡa viꞌeta Isaraela habaꞌa tutuze onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Rehano ani Akelaoꞌe moga Heroda iḡuri madu Iudea habaꞌa kiniḡa reiroteꞌe igirotene, Iudea habaꞌa onamogaꞌe riharo. Eꞌanoꞌo tuḡure viganiꞌa iḡunao ihoniroteꞌe idunaḡano, ze Galilea habaꞌa onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ebu ne ꞌahoga, niḡa Nazaretao radiro. ꞌOugadu Badiꞌaꞌa peroveta azaḡanonoꞌo reiroteꞌe ḡoeꞌaniꞌa hudaro, “Aniꞌe Nazareta vazeḡa rae huniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Eꞌe madaḡano Ioane Babatisoꞌa Iudea habaꞌano haba bohaꞌa aradu ꞌahige haramiro, ");
INSERT INTO ksj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Haḡaize sauꞌanonoꞌo ḡihuroꞌi, mazaḡa Badiꞌaꞌa zuhiꞌaziꞌeteꞌe madaḡa ꞌai haniteha.” ");
INSERT INTO ksj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Peroveta vazeḡa Isaiaꞌa Ioane Babatiso moneo ꞌahige rae reiro, “Vaze ꞌahoganiꞌa haba bohaꞌano huau ḡoereꞌohe, raenaꞌa, 'Zuhiꞌa Boro veize ibi ruhiboꞌi, ebu ani veize ibi mae dudunoꞌi.'” ");
INSERT INTO ksj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ioaneꞌa kamelo iguḡa hina haḡairoteꞌe dabuaḡa vidaro, zu mani ogaḡa miniḡa hina gabaꞌiḡano autiro, ebu fihore zu butu ꞌavoreḡa godaga aro. ");
INSERT INTO ksj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Eꞌe madaḡano Ierusalemaonoꞌo, zu Iudea habaꞌa niduꞌaonoꞌo, zu Ioridana vuḡa habaꞌa niduꞌaonoꞌo vaze ḡehaḡaniꞌa Ioane vaḡe onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ebu ze haḡaize sauꞌa rae furenadu Ioaneꞌa Ioridana vuḡano babatisoziro. ");
INSERT INTO ksj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Farisea azaḡa zu Sadukea azaḡa ḡehaḡaniꞌa babatiso mouga radu Ioane vaḡe ariro. Ebu aneꞌa ze horozadu ziro, “Zaꞌe Zarama ubugaubuga! Iniuꞌa zae mazao, 'Badiꞌa zama ḡugiꞌanonoꞌo ferau muhinoꞌi,' rae reiro? Aꞌe mene idaḡa! ");
INSERT INTO ksj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Rehano ibite haḡaize sau'anono'o ḡihuniroteꞌe haḡaiḡa izidi furenoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ebu ꞌahige rae ago zamaroꞌi, 'Emeꞌe Aberahamo mariga, eꞌanoꞌo Badiꞌaꞌa mene maḡunofiꞌuma.' Eḡeꞌa ziꞌohe, Badi'a'a hadi ꞌadi hina Aberahamo mariga haḡaoga zuni idaḡa. ");
INSERT INTO ksj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ḡiro 'ai ire taigano amahi tiro. Eꞌanoꞌo huga manoḡa mene iniꞌeteꞌe ireḡa niduꞌa'e udi higonadu ire rogao feuniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Zaeꞌa haḡaize sauꞌanonoꞌo ḡihuroga veize eḡeꞌa vu hina babatisoziꞌohe. Rehano eḡe ḡaruna ariteꞌe vazeḡa gigiꞌaḡaꞌe ufeta ḡihiꞌaḡa zu eḡe vitihoga. Eḡe'a ani tamaka odoheꞌeteꞌe tuḡureḡa vazeḡa rae rouga zuni mene idaḡa. Aniꞌe Vine Zaḡoḡa zu ire roga hina babatisoziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Maho hiriveꞌeteꞌe madaḡano, vazeꞌa kari hina rouḡa tenadu maho huꞌiꞌohe, ebu iguḡa manoneꞌohe zu meba hare deheneꞌohe. Ebu hugaꞌe nuꞌonadu suaba zamaḡano tiꞌohe, rehano iguḡaꞌe mene vidauꞌeteꞌe ire rogao hufi haoneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Eꞌe madaḡano Iesuꞌa Ioaneonoꞌo babatiso mouga radu Galilea habaꞌanonoꞌo Ioane vaḡe Ioridana vuḡa ariro. ");
INSERT INTO ksj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Rehano Ioaneꞌa Iesu garariro zu niro, “Ḡaeꞌa eḡe babatisohifo. Nougaꞌahi ḡaꞌe eḡe vaḡe areha?” ");
INSERT INTO ksj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Iesuꞌa naenaeniro, “Izidiꞌe ꞌahige haḡaoꞌi. Eme Badiꞌaꞌa urateꞌeteꞌe haḡaiḡa duduḡa niduꞌa haḡae huniꞌuma.” ꞌOugadu Ioaneꞌa Iesu babatisoniro. ");
INSERT INTO ksj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Iesuꞌa babatiso meiroteꞌe enogano vuonoꞌo gaba tiri onamiro. ꞌOugirotene, adureꞌa bohatanadu Iesuꞌe Vine Zaḡoḡaniꞌa Tubugo niniḡa teige ane mazao ovairoteꞌe horoniro. ");
INSERT INTO ksj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ebu ago ꞌahoganiꞌa adureonoꞌo ꞌahige rae reiro, “ꞌAdiꞌe eḡe zamarone ubude. Eꞌa ani mazao matu'e rudau'ohe.” ");
INSERT INTO ksj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Eꞌe ḡarugano Diaboloꞌa Iesu tuhune nuroga veize Vine Zaḡoḡaniꞌa Iesu tutune haba bohaꞌa onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Eꞌea mada 40 zamaḡano ohere zu madai ogomu mene aro. Eꞌanoꞌo aniꞌe vinine runiro. ");
INSERT INTO ksj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ebu Diaboloꞌa tuhunoga radu ani vaḡe ariro ebu niro, “Ḡaꞌe Badiꞌa Ubuga roꞌidene, hadi ꞌadi ninaꞌa, 'Ḡihuradu ꞌuvahu odogano roꞌi,' rae noꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Iesuꞌa naenaeniro, “Mene, Buka Zaḡoḡano ꞌahige rae mirihiro, 'Vaze'e ꞌuvahu odogano da'o mene ḡabode radi'uma, rehano Badiꞌa hebeonoꞌo buauꞌeteꞌe ḡoeꞌa niduꞌa hina ḡabode radiꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ebu Diaboloꞌa Iesu ne zaḡoḡa, Ierusalema tutune onamiro zu kuru neḡa hitaga huneo ohonadu niro, ");
INSERT INTO ksj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Ḡaꞌe Badiꞌa Ubuga roꞌidene, rafatoꞌi. Mazaḡa Buka Zaḡoḡano ꞌahige rae mirihiro, 'Badi'aꞌa ḡaꞌe duguoga veize ane tuḡure vigaviga ḡae vaḡe tuḡuziꞌuma. Ze'a ꞌevoreze hina mae ḡihi'i'uma ꞌahine, odaḡoꞌe hadio mene tutuhaꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iesu'a naenaeniro, “Mene, Buka Zaḡoḡano ꞌahige rae mirihiro, 'Zuhiꞌa Boro ḡae Badiꞌa ago tuhuno'i.'” ");
INSERT INTO ksj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ebu Diaboloꞌa Iesu maḡa hitaga hune tutune itadu kini'a zuhiꞌaziꞌeteꞌe haba'a niduꞌa zu zeḡe ḡau naeḡa boro niduꞌa ihoniro. ");
INSERT INTO ksj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ebu aneꞌa Iesu niro, “Ḡaeꞌa eḡe zamao ḡuḡuradu kuraune, eꞌe niduꞌa ḡae ḡaniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Iesuꞌa niro, “Mene, eḡe mazaonoꞌo vaḡinoꞌi. Buka Zaḡoḡano ꞌahige rae mirihiro, 'Zuhiꞌa Boro ḡae Badiꞌa mazao da'o kurano'i zu ane veize daꞌo gauoꞌi.'” ");
INSERT INTO ksj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ꞌOugadu Diaboloꞌa Iesu mazaonoꞌo vaḡine onamiro. Ebu tuḡure vigaviganiꞌa aradu Iesu taufiro. ");
INSERT INTO ksj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Iesuꞌa Ioaneꞌe ḡuꞌa neḡano ohoniroteꞌe egadu Galilea habaꞌa bare onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Galilea habaꞌano ani Nazareta neḡano radiro. Ebu neḡa eꞌe modadu Kaperanauma onamiro, ebu eꞌea radiunu. Kaperanaumaꞌe Zebulono zu Nafatali habaꞌano ebu Galilea duꞌuraḡa genaḡano ne boro ꞌahoga. ");
INSERT INTO ksj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ibite Badiꞌaꞌa peroveta vazeḡa Isaiaonoꞌo reiroteꞌe ḡoeꞌaniꞌa hudaro, ");
INSERT INTO ksj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zebulono zu Nafatali habaꞌaꞌe Galilea duꞌuraḡa ibiḡano zu Ioridana vuḡa moneafao. Galileaꞌe Iuda mene azaḡa haba. ");
INSERT INTO ksj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Uzabo zamaḡano radiuꞌeteꞌe azaḡaniꞌa agaḡa boro horoneha. Rune zauhaḡa habaꞌano radiuꞌeteꞌe azaḡa rana agaḡaniꞌa agazeha.” ");
INSERT INTO ksj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Eꞌe madaḡanonoꞌo Iesuꞌa ḡadahe haramiro, “Ḡihuroꞌi, mazaḡa Badiꞌaꞌa zuhiꞌaziꞌeteꞌe madaḡa ꞌai haniteha.” ");
INSERT INTO ksj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iesuꞌa Galilea duꞌuraḡa genaḡano onameꞌeteꞌea, vaze aheuꞌa reꞌeva feune radiunuteꞌe horoziro. Zeꞌe Simona, niḡa ꞌahogaꞌe Petero ebu negoḡa Anderea. Zeꞌe ḡozone mauꞌeteꞌe azaḡa. ");
INSERT INTO ksj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ebu Iesuꞌa ziro, “Eḡe ḡaruna hegotoꞌi. Zaꞌe vaze reꞌevaziꞌeteꞌe azaḡa rouga veize ohoziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ꞌOugirotene, ze zogone reꞌevaze modadu ani hegote onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Iesuꞌa eꞌeanoꞌo tahiꞌa faḡa onamirotene, vaze ꞌahoga negoḡeta horoziro. Zeꞌe Zebedeo ubuga aheu, Iakobo zu negoḡa Ioane. Zeꞌe moze teite ḡasi zamaḡano reꞌeva zigoga faine radiunu. Ebu Iesuꞌa ze huziro, “Eḡe hegotoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ꞌOugirotene, zeꞌe zogone ḡasize zu moze modadu ani hegote onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesuꞌe Galilea habaꞌa niduꞌa zamaḡano ragaveꞌenaꞌa, Iuda azaḡa nuꞌonuꞌo neḡano ihoziro zu Badiꞌaꞌa zuhiꞌaziꞌeteꞌe moneo hari manoḡa haramiro. Ebu vaze ḡehaḡa boꞌaḡano ugi zu gigiꞌa niduꞌa fainiro. ");
INSERT INTO ksj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ebu Iesu hariḡaniꞌa bororanadu Siria habaꞌa azaḡa niduꞌa igiro. Zeꞌa ugi azaḡa niduꞌa tutuze ani vaḡe ariro. Ugi nunu uꞌano ahirizeꞌa gigize ruzeꞌeteꞌe azaḡa, vine sauꞌaniꞌa ragano reiroteꞌe azaḡa, ketoketeꞌeteꞌe azaḡa zu ahirize haganoga mene idaḡa azaḡa tutuze arirotene, Iesuꞌa ze faiziro. ");
INSERT INTO ksj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galilea habaꞌa, Dekapoli, Ierusalema, Iudea habaꞌa zu Ioridana vuḡa moneafa habaꞌanonoꞌo vaze ḡuḡuvaḡaniꞌa aradu Iesu hegotiro. ");
INSERT INTO ksj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iesuꞌa vaze ḡuḡuvaḡa horozirotene, maḡa komeꞌa itadu eꞌea ehoriro. Ebu ane tahiꞌatahiꞌaꞌa ane vaḡe ariro. ");
INSERT INTO ksj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ebu Iesuꞌa ḡadahe ihoziro, ");
INSERT INTO ksj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Zamaze zaharaḡa azaḡaꞌe matuꞌeꞌohe, mazaḡa Badiꞌaꞌa zuhiꞌaziꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Zamaze areꞌenaꞌa, niauꞌeteꞌe azaḡaꞌe matuꞌeꞌohe, mazaḡa zeꞌe Badiꞌaꞌa namiziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Zamaze roḡeḡa azaḡaꞌe matuꞌeꞌohe, mazaḡa ze Badiꞌa mazaonoꞌo haba meꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Badiꞌa urao haḡai duduḡa haḡaihi rae inareꞌeteꞌe azaḡaꞌe matuꞌeꞌohe, mazaḡa Badiꞌaꞌa zeḡe ura niduꞌa ziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Vaze vetuḡaziꞌeteꞌe azaḡaꞌe matuꞌeꞌohe, mazaḡa Badiꞌaꞌa ze vetuḡaziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Zamaze deheḡa azaḡaꞌe matuꞌeꞌohe, mazaḡa zeꞌe Badiꞌa horoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Uniho manoḡa veize gaueꞌeteꞌe azaḡaꞌe matuꞌeꞌohe, mazaḡa Badiꞌaꞌa zeꞌe ane ubugaubuga rae huziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Badiꞌa ura haḡaeꞌeteꞌe uꞌano, vazeꞌa sausauzeꞌeteꞌe azaḡaꞌe matuꞌeꞌohe, mazaḡa zeꞌe Badiꞌaꞌa zuhiꞌaziꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Eḡe uꞌano, vazeꞌa za rae sausauziꞌetene, aduga boro ziniꞌetene, ebu ḡurireꞌenaꞌa ḡoere sauꞌa nunu hina ziꞌetene, zaꞌe matuꞌeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Zaꞌe matuꞌe rudanoꞌi, mazaḡa Badiꞌaꞌa adureo naeḡa boro bagaḡa ziniꞌuma. Zeḡe vouḡaniꞌa peroveta ibiꞌa azaḡa zuni deꞌuge sausauzido.” ");
INSERT INTO ksj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Zaꞌe raha ꞌadaoꞌe dama heuḡa. Rehano dama iniganiꞌa dauḡine, nougenouge bare inidaꞌuma? Dama mene inigaꞌe ḡauni ꞌahoga veize zuni mene manoḡa ꞌahine, mae modadu vazeꞌa edene oname onaeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Zaꞌe raha ꞌada aganeꞌeteꞌe agaḡa. Maḡa hitagano ogoraroteꞌe neḡa boroꞌe uꞌuranoga mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Vaze ꞌahoganiꞌa ihure hofadu siuva ꞌuꞌuḡano mene tiꞌohe, rehano ihure odaḡa rana teadu ne zamaḡano radiuꞌeteꞌe azaḡa niduꞌa agazeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Eꞌe teige, zae agaḡa hina vaze agazoꞌi. ꞌOugine, zeꞌa zae haḡai manoḡa horonadu Moze adureo niguniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Zaꞌe eḡeꞌa Mose goro ḡoeꞌa zu peroveta azaḡa ḡoere fahoga radu ariro rae ago zamaroꞌi. E zeḡe ḡoere fahihi radu mene ariro, rehano zeḡe ḡoereꞌa hudanoga veize ariro. ");
INSERT INTO ksj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Eḡeꞌa hube hune ziꞌohe, adure zu raha ꞌizema dauḡogano Mose goro ḡoeꞌa niduꞌa boꞌaḡano komeꞌa ꞌahoga zuni mene hune dauḡiꞌuma, rehano Mose goro ḡoeꞌa niduꞌaꞌe hudaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Eꞌanoꞌo iniuꞌa Mose goro ḡoeꞌa komeꞌa ꞌahoga variꞌine ebu vaze ꞌouge ihozine, aniꞌe Badiꞌaꞌa zuhiꞌaziꞌeteꞌe azaḡa boꞌaḡano vaze ḡonaga rae huniꞌuma. U iniuꞌa Mose goro ḡoeꞌa tihitihinine ebu vaze ꞌouge ihozine, aniꞌe Badiꞌaꞌa zuhiꞌaziꞌeteꞌe azaḡa boꞌaḡano vaze ḡihiꞌaḡa rae huniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Eḡeꞌa ziꞌohe, zaeꞌa Badiꞌa ubumao haḡai duduḡa haḡaeꞌeteꞌeꞌa Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zu Farisea azaḡa mene vitizine, zaꞌe Badiꞌaꞌa zihiꞌaziꞌeteꞌe azaḡa mene reꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ibite azaḡa mazao reiroteꞌe goro ḡoeꞌa ꞌadi zaeꞌa igiro, 'Vaze ago gorunoꞌi. Iniuꞌa vaze ꞌahoga gorunine, kotaniꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Rehano eḡeꞌa ziꞌohe, iniuꞌa ane nego nabudi mazao maḡunine, kotaniꞌuma. Iniuꞌa ane nego nabudi mazao, 'Kauriḡa,' rae nine, Iuda azaḡa nuꞌonuꞌo boro zamaḡano kotaniꞌuma. Ebu iniuꞌa ane nego nabudi mazao, 'Baboḡa,' rae reine, ire roga radiu tuḡutuḡu zamaḡano mae feuniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Eꞌanoꞌo ḡaeꞌa dibuꞌo fataḡano ḡahunoneḡo hauꞌeteꞌe madaḡano negoḡo ꞌahoganiꞌa ḡae mazao maḡuneꞌeteꞌe zamaroꞌidene, ");
INSERT INTO ksj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ḡahunoneḡoꞌe fata genaḡano modoꞌi, ebu negoḡo vaḡe onamadu ane teite uniho manofoꞌi. Eꞌe enogano bare aradu ḡahunoneḡo hanoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ḡaꞌe vaze ꞌahoganiꞌa kotao ohoꞌihi radu ani teite onamoꞌidene, ibio ḡanine ḡarihe uniho manofoꞌi. Mene ꞌougine, aniꞌa oboꞌe teadu kota vazeḡa ꞌevoreo ohoꞌiꞌuma, ebu hena kota vazeḡaniꞌa ḡuꞌa neḡa taufeꞌeteꞌe vazeḡa ꞌevoreo ohoꞌadu ḡuꞌa neḡano ohoꞌiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Eḡeꞌa hube hune ziꞌohe, za ḡuꞌa neḡanonoꞌo mene buaꞌuma, onamo zaeꞌa ani hadi niduꞌaꞌe baroniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Zaꞌe edeḡa, Mose goro ḡoeꞌano ꞌahige rae reiro, 'Ubuma ago ḡezanoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Rehano eḡeꞌa ziꞌohe, iniuꞌa roḡae ꞌahoga ḡianadu roḡae ꞌomo teite bazihi reine, aniꞌe zamaḡano ubuma ḡezaneha. ");
INSERT INTO ksj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ḡae edaꞌe ubumaḡaniꞌa haḡai sauꞌa haḡaoꞌidene, eꞌe ubumaḡa ḡude modoꞌi. Mazaḡa ahiriḡo tahiḡa modeꞌetaꞌaꞌe manoḡa, aꞌe ahiriḡo niduꞌa ire roga radiu tuḡutuḡu zamaḡano mae feuneꞌeteꞌe ufeta vitinoga. ");
INSERT INTO ksj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ebu ḡae edaꞌe ꞌevoreꞌa haḡai sauꞌa haḡaoꞌidene, eꞌe ꞌevoꞌa variꞌe modoꞌi. Mazaḡa ahiriḡo tahiḡa modeꞌetaꞌaꞌe manoḡa, aꞌe ahiriḡo niduꞌa ire roga radiu tuḡutuḡu zamaḡano mae feuneꞌeteꞌe ufeta vitinoga.” ");
INSERT INTO ksj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Mose goro ḡoeꞌano ꞌahige rae reiro, 'Iniuꞌa inuga modoꞌidene, aneꞌa ihore soꞌaḡa mirihadu inuga hanoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Rehano eḡeꞌa ziꞌohe, iniu inugaꞌe ubuma mene ḡezaro rehano, inuga modine, iꞌaniꞌa ubuma ḡezo ibiḡano inuga tuḡuneꞌeteꞌe heuḡa. Ebu iꞌaniꞌa modiroteꞌe roḡaeḡa teite hahuriroteꞌe vazeḡa zuni ubuma ḡezauꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ibite azaḡa mazao reiroteꞌe ḡoeꞌa ꞌadi zaeꞌa igiro, 'Nagi ḡoeꞌa rinede toꞌidene, ago variꞌoꞌi. Badiꞌa mazao ḡoere rinede toꞌidene, huga haḡaoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Rehano eḡeꞌa ziꞌohe, ḡoereni ꞌahoga ago rinede toꞌi. Adure niḡano ḡoere ago rinede toꞌi, mazaḡa adureꞌe Badiꞌaꞌa ehoreꞌeteꞌe habaꞌa. ");
INSERT INTO ksj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Raha niḡano ḡoere ꞌahoga ago rinede toꞌi, mazaḡa rahaꞌe Badiꞌaꞌa odaḡa tiꞌeteꞌe habaꞌa. Ierusalema niḡano ḡoere ꞌahoga ago rinede toꞌi, mazaḡa Ierusalemaꞌe Kini Ḡihiꞌaḡa ane ne boro. ");
INSERT INTO ksj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ḡoere rinede tiroteꞌe mene haḡaine rudaꞌuma rae ago ḡoitoroꞌi, mazaḡa ḡabonezeꞌe zaeꞌa mene haḡairo. Zaꞌe vadinize iguze tiba zuni mae ꞌurunoga zu mae ḡuḡunoga mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Zaeꞌa nagini haḡaiꞌuma rae roꞌidene, 'Oꞌe,' rae tauḡoꞌi. Ga mene haḡaiꞌuma rae roꞌidene, 'Mene,' rae tauḡoꞌi. Ḡoere ꞌahogaꞌahoga ragate tiꞌetaꞌaꞌe sauꞌa ḡauḡa, Satanionoꞌo fureruꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Zaꞌe Mose goro ḡoeꞌa ꞌahi igiro, 'Vaze ꞌahoganiꞌa ḡae ubuma sausaunoꞌidene, ḡae zuni ane ubuma sausaunoꞌi. Ebu aneꞌa ḡae ḡonone vahegoꞌidene, ḡae zuni ane ḡonone vahegoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Rehano eḡeꞌa ziꞌohe, vaze sauꞌa mazao ago naenaetitoꞌi. Iniuꞌa zae edaꞌe ḡanineḡa faꞌonoꞌidene, zae kauri ḡanineḡa zuni notonohanoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Iniuꞌa zae zizuni dabuaḡa mouga rae kotazihi roꞌidene, raga dabuaḡa zuni hanoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Iniu zaeꞌa ane ḡau odohadu tiba kilomita onamoga tuḡutuḡuzoꞌidene, aheu kilomita onamoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Iniuꞌa nagini umizoꞌidene hau tauḡoꞌi, zu ḡauze ꞌahoga umizadu vesuꞌu baroniꞌuma rae roꞌidene, ago hezahohanoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Zaꞌe edeḡa, Mose goro ḡoeꞌano ꞌahige rae reiro, 'Ḡae nabudi zamare borofoꞌi, ebu ḡae agire vazeḡa heꞌeheꞌenoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Rehano eḡeꞌa ziꞌohe, zae agire azaḡa zamare borofoꞌi ebu zae sausauzeꞌeteꞌe azaḡa veize kuranoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ꞌOugine, zaꞌe Moze adureo ubuga rae reꞌuma. Mazaḡa Mozeꞌe vaze manoḡa zu vaze sauꞌa veize idane mada aganoziniꞌohe, ebu vaze duduḡa zu vaze veꞌoḡa veize idane irugu tuḡuneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Zaeꞌa zae zamare borofeꞌeteꞌe azaḡa daꞌo zamare borofine, Badiꞌaꞌa eꞌe naeḡa mene ziniꞌuma. Takesi azaḡaꞌe haḡai sauꞌa azaḡa rehano, zeḡe zuni zeḡe zamare borofeꞌeteꞌe azaḡa zamare borofeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Zaeꞌa zae nego nabudi teite daꞌo obotitine, vaze nunu mene vitiziꞌuma. Badiꞌa aḡuꞌa azaḡa zuni ꞌouge haḡaeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Eꞌanoꞌo zae Badiꞌa adureo mazaoꞌe veꞌoḡa oꞌoꞌa teige, zae zuni veꞌoḡani ꞌahoga ago haḡaoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Zaꞌe vazeꞌa ḡiazoga veize vaze zamao haḡai duduḡa mene haḡaifine tohutohoꞌi. Mene tohutohine, adureo radiuꞌeteꞌe Mozeꞌa naeḡa manoḡa mene ziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Eꞌanoꞌo ḡau ꞌahoga zahara vazeḡa haune, zama guhi azaḡa teige ago hirihiroꞌi. Zama guhi azaḡaꞌe vazeꞌa niguzoga veize nuꞌonuꞌo neḡano zu ibio haḡae fureneꞌohe. Eḡeꞌa hube hune ziꞌohe, zeꞌe naeze niduꞌa mae hauḡiro. ");
INSERT INTO ksj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ḡau ꞌahoga zahara vazeḡa haune, zae nabudi uhiḡa vazeḡa zu ago ihonoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Vaze ꞌahoganiꞌa mene ederoga veize sifu hanoꞌi. ꞌOugine, Mozeꞌa haḡaize sifu horonadu naeḡa manoḡa ziniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Zaꞌe kuranoꞌidene, zama guhi azaḡa teige ago kuranoꞌi. Mazaḡa zeꞌe vazeꞌa horozoga veize nuꞌonuꞌo neḡano zu ibi boro genaḡano edauꞌenaꞌa, kuranoga urateꞌohe. Eḡeꞌa hube hune ziꞌohe, ze naeze niduꞌa mae hauḡiro. ");
INSERT INTO ksj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Zaꞌe kuranoꞌidene, bazuni habaꞌa diuḡadu ibiheta haranoꞌi, ebu mene horoneꞌeteꞌe Badiꞌaḡa, Moze mazao kuranoꞌi. ꞌOugine, Mozeꞌa zae haḡai sifu horonadu naeḡa manoḡa ziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ebu za kuranoꞌidene, Badiꞌa aḡuꞌa azaḡa teige, huga oꞌoꞌa ḡoeꞌa hina ago barebare roꞌi. Mazaḡa zeꞌe ḡoere ḡehaḡa hina kuraune, Badiꞌaꞌa igiꞌuma rae zamareꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ze ago hegotoꞌi, mazaḡa Mozeꞌe zaeꞌa ꞌizema umidogano nagini urateꞌetaꞌaꞌe edeḡa. ");
INSERT INTO ksj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Eꞌanoꞌo zaꞌe ꞌahige kuranoꞌi: 'Emeḡe Mama adureo, eme umiꞌeꞌohe, ḡa niḡoꞌe zaḡoḡa reꞌuma, ");
INSERT INTO ksj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ḡaeꞌa ḡau niduꞌa zuhiꞌaziꞌuma, zu adureo ḡae uraꞌe hudauꞌeteꞌe teige, raha ꞌadao zuni hudaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Izidi emeḡeꞌa atiteꞌe ogomuḡa rifiꞌenoꞌi, ");
INSERT INTO ksj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ebu emeꞌa emeḡe mazao sauꞌa haḡairoteꞌe azaḡa haḡaize sauꞌa rae modiroteꞌe teige, emeḡe haḡai sauꞌa rae modoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ebu eme haḡai sauꞌa haḡaihi raꞌeteꞌe zamaroneḡanonoꞌo tutufe vaḡifoꞌi, ebu Satani mazaonoꞌo mae ḡabofoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Zaeꞌa vaze haḡai sauꞌa rae modine, Moze adureo radiuꞌeteꞌeꞌa zae haḡai sauꞌa zuni rae modiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Rehano zaeꞌa vaze haḡai sauꞌa mene rae modine, Mozeꞌa zuni zae haḡai sauꞌa mene rae modiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Zaeꞌa ogomu moneo zaḡozaḡoꞌidene, zama guhi azaḡa teige, ago vetuḡarau radoꞌi. Zeꞌe vazeꞌa horozadu zeḡeꞌa ogomu moneo zaḡozaḡeꞌeteꞌe ederoga veize, mene vireꞌohe zu iguze mene siꞌeꞌohe. Eḡeꞌa hube hune ziꞌohe, zeꞌe naeze niduꞌa mae hauḡiro. ");
INSERT INTO ksj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Rehano zaeꞌa ogomu moneo zaḡozaḡoꞌidene, viradu iguze siꞌoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ꞌOugine, vazeꞌa zaꞌe zaḡozaḡeꞌeteꞌe mene ederiꞌuma, rehano mene horoneꞌeteꞌe Badiꞌaḡa, Moze daꞌo ederiꞌuma. Ebu Mozeꞌa zaꞌa sifu haḡairoteꞌe haḡaiḡa horonadu naeze ziniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Zae veize raha ꞌadao ḡauze naeḡa boroboro ago nuꞌone toꞌi. Raha ꞌadaoꞌe zuhiꞌa sausauneꞌohe, zu atenarauꞌohe, ebu ḡonoreꞌa varade diuḡadu ḡonotuꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Eꞌanoꞌo zae veize ḡauze naeḡa boroꞌe adureo nuꞌone toꞌi. Eꞌea zuhiꞌa mene sausauneꞌohe, zu mene atenarauꞌohe, ebu ḡonoreꞌa varade diuḡadu mene ḡonotuꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mazaḡa za ḡauze naeḡa boro nouma tine, zamaze zuni eꞌea tiꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Za ubumaꞌe ahiri ihureḡa. Ubumazeꞌe manoḡa reine, ahirizeꞌe agaḡaniꞌa iriꞌavoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Rehano ubumazeꞌe sauꞌa reine, ahirizeꞌe uzaboꞌa iriꞌavoniꞌuma. Eꞌanoꞌo zae zamao agaḡaꞌe uzaboraune, zaꞌe uzabo ḡiḡiꞌaḡa hune zamaḡano radiꞌuma!” ");
INSERT INTO ksj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Vaze ꞌahoganiꞌa zuhiꞌa aheu veize gauoga mene idaḡa. Ani ꞌahogaꞌe heꞌeheꞌeniꞌuma, u ꞌahogaꞌe zamare borofiꞌuma. Ebu ꞌahoga veize faine gauiꞌuma, u ꞌahogaꞌe turuniꞌuma. Eꞌe teige, zaꞌe Badiꞌa ebu hadi, aheu veize gauogaꞌe mene idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Eꞌanoꞌo eḡeꞌa ziꞌohe. Zae ḡabone veize nagi ogomu aꞌuma ga nagini gagiꞌuma ebu ahirize veize nagi dabua vidaꞌuma rae ago zamare adudanoꞌi. Mazaḡa ḡaboneꞌe ogomu vitinoga, zu ahiriꞌe dabua vitinoga. ");
INSERT INTO ksj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Hitanao rafiuꞌeteꞌe niniḡa ḡiazoꞌi. Ze ezone mene ḡorauꞌohe, mene hiriveꞌohe, zu ogomuze godoḡo neḡano mene nuꞌone tiꞌohe. Rehano Moze adureo radiuꞌeteꞌeꞌa ḡubuzeꞌohe. Zaꞌe nini vitize hunoga. ");
INSERT INTO ksj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Zae boꞌaḡano iniuꞌa zamare adudu radiune, ḡaboneḡaꞌe tahiḡa nu faraꞌumahe? ");
INSERT INTO ksj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Za nougaꞌahi dabua uꞌano zamare aduduꞌohe? Butu kakaḡaꞌe nougenouge ḡuhureꞌeteꞌe ḡianoꞌi. Ze mene gaueꞌohe ga dabuaze mene turineꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Rehano eḡeꞌa ziꞌohe, butu kakaḡani ꞌahoga zuni maꞌora vazeḡa kini Solomonaꞌa haḡairoteꞌe dabuaḡa manomano vitine hunoga. ");
INSERT INTO ksj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Butu veḡaꞌe izidi ḡaboga, u ohoḡoreꞌe masinadu ireo hufi haoniꞌuma, rehano Badiꞌaꞌa dabua vidohauꞌohe. Zaꞌe ve vitinoga, eꞌanoꞌo Badiꞌaꞌa dabua manoḡa ufeta vidoziniꞌuma. Rehano zaꞌa Badiꞌa mazao fieꞌetaꞌaꞌe tahiḡa fase! ");
INSERT INTO ksj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Eꞌanoꞌo zaꞌe nagini aꞌuma ga nagini gagiꞌuma ga nagi dabua vidaꞌuma rae ago zamare adudanoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Badiꞌa aḡuꞌa azaḡaniꞌa eꞌeguḡa niduꞌa vaḡe inareꞌohe, rehano Moze adureo radiuꞌetaꞌaꞌe zaeꞌa eꞌeguḡa niduꞌa urateꞌeteꞌe edereꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ibite geno Badiꞌaꞌa zuhiꞌazoga zu ane ura haḡaoga vaḡoꞌi, ꞌougine eꞌeguḡa niduꞌa zuni ziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Eꞌanoꞌo za ohoḡore moneo ago zamare adudanoꞌi. Mazaḡa ohoḡore adugaꞌe ohoḡoruꞌu zamariꞌuma. Izidiꞌe izidi aduga daꞌo zamariꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Vaze mazao sauꞌa rae ago roꞌi. ꞌOugine, Badiꞌaꞌa zuni zae mazao sauꞌa rae mene ziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mazaḡa zaeꞌa vaze mazao sauꞌa rae reine, eꞌe moneo Badiꞌaꞌa zuni zae mazao sauꞌa rae reꞌuma. Zaeꞌa vaze nagini hauꞌeteꞌe idunaḡano Badiꞌaꞌa ꞌouge zae ziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Zaꞌe nabudize ubuma beꞌa dinunuḡa ḡianeꞌohe. Rehano nougadu zae ubuma beꞌa gado ireḡa mene horoneꞌohe? ");
INSERT INTO ksj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Zaꞌe zae ubuma beꞌa gado ireḡa mene horoneꞌe rehano, nabudize mazao ꞌahige raꞌohe, 'Eḡe nabudi, eḡeꞌa ubumaḡo beꞌa dinunu eꞌe mae vaḡinihi.' ");
INSERT INTO ksj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Zama guhi azaḡa, ibite geno zae ubuma beꞌa gado ireḡa eꞌe mae vaḡinoꞌi. ꞌOugine, zaeꞌa faine ehamanadu nabudize ubuma beꞌa dinunuḡa mae vaḡiniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ḡau zaḡoḡa ḡuni ago hanoꞌi, ebu zae hadi naeḡa boro aba zamao ago feunoꞌi. Zeꞌe oda hina edene ḡuzuhiꞌuma zu vaetadu zae vihoziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Uminoꞌi, ꞌougine ziniꞌuma. Vaḡoꞌi, ꞌougine horoniꞌuma. Ibiheta toketokeroꞌi, ꞌougine ibiheta vavaoziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Umineꞌeteꞌe azaḡa niduꞌa ziniꞌuma, zu vaḡeꞌeteꞌe azaḡa niduꞌa horoniꞌuma, ebu ibiheta toketokereꞌeteꞌe azaḡa niduꞌa ibiheta vavaoziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Zae boꞌaḡano iniu ubuganiꞌa ꞌuvahu odoga umidine, moganiꞌa hadi haꞌumahe? ");
INSERT INTO ksj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ga ubuganiꞌa ḡozone umidine, moganiꞌa mohe haꞌumahe? ");
INSERT INTO ksj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Zaꞌe sauꞌa azaḡa rehano, ḡahunone manoḡa ubudeze zenoga urateꞌohe. Eꞌe teige, Moze adureo radiuꞌetaꞌaꞌe ane mazao umideꞌeteꞌe azaḡa hube hune ḡahunone manoḡa ziniꞌuma! ");
INSERT INTO ksj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Eꞌanoꞌo ḡau niduꞌa moneo vazeꞌa zae mazao manoḡa haḡaeꞌeteꞌe uratoꞌidene, zae zuni zeḡe mazao manoḡa haḡaoꞌi. ꞌAdiꞌe Mose goro ḡoeꞌa zu peroveta azaḡaniꞌa ihoziroteꞌe ḡoeꞌa.” ");
INSERT INTO ksj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ibiheta kokosiḡa diuḡoꞌi. Mazaḡa runeo diuḡeꞌeteꞌe ibiḡa ibihetaḡaꞌe rafaḡa zu boro ꞌahine, eꞌe ibiḡano diuḡeꞌeteꞌe azaḡaꞌe ḡehaḡa. ");
INSERT INTO ksj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","U ḡabone tuḡutuḡu diuḡeꞌeteꞌe ibiḡa ibihetaḡaꞌe kokosiḡa zu eꞌe ibiḡano onamogaꞌe riḡa. Eꞌanoꞌo eꞌe ibihetaḡa vaḡeꞌeteꞌe azaḡaꞌe tahiḡa daꞌo.” ");
INSERT INTO ksj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ḡuriro peroveta azaḡa ḡiazoꞌi. Ze mamoe roḡeḡa teige ariꞌuma, rehano zeḡe zamaꞌe butu ḡuniḡa vihovihoḡa heuḡa. ");
INSERT INTO ksj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ireꞌe maḡa horonadu nagi ireḡa ederiꞌuma. Vaini maḡaꞌe ire renoganonoꞌo mene iniꞌohe, zu figi maḡaꞌe ḡunu renoganonoꞌo mene iniꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Eꞌe teige, ire manoḡa niduꞌaꞌe maḡa manoḡa iniꞌohe, u ire sauꞌaꞌe maḡa sauꞌa iniꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ire manoḡaꞌe maḡa sauꞌa mene iniꞌohe, u ire sauꞌaꞌe maḡa manoḡa mene iniꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Maḡa manoḡa mene iniꞌeteꞌe ireḡa niduꞌaꞌe udi modeꞌohe ebu ire rogao hufi haoneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Eꞌanoꞌo zeḡe haḡai horonadu zeꞌe vaze nagiga ederiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Eḡe mazao, 'Zuhiꞌa Boro, Zuhiꞌa Boro,' rae huheꞌeteꞌe azaḡa boꞌaḡano mene niduꞌaꞌe Badiꞌaꞌa zuhiꞌaziꞌeteꞌe zamaḡano diuḡiꞌuma. Rehano eḡe Mama adureo radiuꞌeteꞌe, ane ura haḡaeꞌeteꞌe vazeḡaniꞌa daꞌo diuḡiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Badiꞌa kota madaḡano vaze ḡehaḡaniꞌa ꞌahige ihiꞌuma, 'Zuhiꞌa Boro, Zuhiꞌa Boro, emeꞌe ḡae niḡano Badiꞌa ḡoere rae furenido, zu ḡae niḡano vine sauꞌa hegoze buzido, zu ḡae niḡano gigiꞌa haḡaiḡa ḡehaḡa haḡaido.' ");
INSERT INTO ksj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ꞌOugine, eḡeꞌa dehene ziꞌuma, 'E zaꞌe mene hune ederiro. Haḡai sauꞌa azaḡa, eḡe mazaonoꞌo vaḡinoꞌi.'” ");
INSERT INTO ksj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Eꞌanoꞌo eḡe ḡoere egadu ꞌouge haḡaeꞌeteꞌe vazeḡaꞌe huhuzaḡa. Aniꞌe vatava rana neḡa ogoraroteꞌe vazeḡa heuḡa. ");
INSERT INTO ksj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Iruguꞌa ruꞌanadu zobozoboꞌa bororarotene, ebu zavara boroꞌa feuradu neḡa beirotene, ne aꞌe mene higaro, mazaḡa vatava rana ogoraro. ");
INSERT INTO ksj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Rehano eḡe ḡoere egadu ꞌouge mene haḡaeꞌeteꞌe vazeḡaꞌe kauriḡa. Aniꞌe niꞌuri rana neḡa ogoraroteꞌe vazeḡa heuḡa. ");
INSERT INTO ksj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Iruguꞌa ruꞌanadu zobozoboꞌa bororarotene, zu zavara boroꞌa feuradu neḡa beirotene, eꞌe neḡaꞌe higau bauradu fahau ḡuzuhiro.” ");
INSERT INTO ksj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iesuꞌa eꞌe ḡoeꞌa niduꞌa hauḡirotene, vaze ḡuḡuvaḡaniꞌa ane ihore uꞌano zaguzagaro. ");
INSERT INTO ksj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mazaḡa Iesuꞌe Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa teige mene ihoziro, rehano Badiꞌa gigiꞌaḡa hina ihoziro. ");
INSERT INTO ksj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iesuꞌa maḡanonoꞌo ovairotene, vaze ḡuḡuvaḡaniꞌa ane hegote onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ebu refera vazeḡa ꞌahoganiꞌa ani vaḡe aradu ane zamao obenaḡa hina tuḡadu niro, “Zuhiꞌa Boro, ḡa uratine, eḡe faihogaꞌe idaraꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iesuꞌa ꞌevoꞌa einadu vaze eꞌe oboniro ebu niro, “E urateꞌohe. Ḡaꞌe deheru manoroꞌi!” ꞌOugadu refera eꞌeꞌa zogone manoriro. ");
INSERT INTO ksj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ebu Iesuꞌa niro, “Vazeni ꞌahoga ago noꞌi. Rehano dibuꞌo vazeḡa vaḡe onamadu ahiriḡo ihonoꞌi. Ebu ḡaeꞌa manorateꞌe vazeꞌa ederifine, Moseꞌa reiroteꞌe ḡahunoneḡa mae onamadu Badiꞌa dibuꞌohanoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Iesuꞌa Kaperanauma diuḡirotene, uti vazeḡa boro ꞌahoganiꞌa Iesu vaḡe aradu dananoga uminiro, ");
INSERT INTO ksj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ebu ꞌahige rae niro, “Zuhiꞌa Boro, eḡe tuḡure vazeḡa ꞌahogaꞌe ahiꞌa haganoga mene idaḡa radu neo bazeꞌohe zu ufeta giginadu ḡaniḡanauꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Iesuꞌa niro, “Eḡeꞌa onamadu fainiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Rehano uti vazeḡa boroꞌa naenaeniro, “Zuhiꞌa Boro, eꞌe mene vaze manoḡa, eꞌanoꞌo ḡaeꞌa eḡe ne diuḡogaꞌe mene idaḡa. Rehano ḡae ḡoere daꞌo roꞌi, ꞌougine eḡe tuḡure vazeḡaniꞌa manoriꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mazaḡa eḡe zuni vaze ꞌahoga ꞌuꞌuḡano gaueꞌohe, ebu uti azaḡa zuni eḡe ꞌuꞌuḡano gaueꞌohe. Eḡeꞌa uti vazeḡa ꞌahi ninaꞌa, 'Onamoꞌi,' raꞌetene aniꞌe onameꞌohe, ebu ꞌahoga ꞌomo ninaꞌa, 'Aroꞌi,' raꞌetene aniꞌe areꞌohe. Eḡeꞌa eḡe tuḡure vazeḡa ꞌahoga ninaꞌa, 'ꞌAdi haḡaoꞌi,' raꞌetene aniꞌe haḡaeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Iesuꞌa eꞌe ḡoeꞌa igirotene zaguzagaro ebu ane hegoteꞌeteꞌe azaḡa ziro, “Eḡeꞌa hube hune ziꞌohe, Isaraela azaḡa boꞌaḡano ꞌahige fie gigaruꞌeteꞌe vazeḡaꞌe e ꞌize mene horoneha. ");
INSERT INTO ksj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Eḡeꞌa ziꞌohe, vaze ḡehaḡaniꞌa madaꞌa iteꞌeteꞌe moneonoꞌo zu madaꞌa zubureꞌeteꞌe moneonoꞌo aradu adureo Badiꞌaꞌa zuhiꞌaziꞌeteꞌe habaꞌano Aberahamo, Isako zu Iakobo teite ogau tiburaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Rehano Iuda azaḡaꞌe Badiꞌaꞌa ze zuhiꞌaziꞌohe rae zamareꞌe rehano, enona mae feuzadu uzabo zamaḡano radiꞌuma, ebu eꞌea niaꞌuma zu ḡononeze atitiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ebu Iesuꞌa uti vazeḡa boro niro, “Onamoꞌi. Ḡaꞌe eḡe mazao fieꞌeteꞌe uꞌano, ḡae tuḡure vazeḡaꞌe manoriꞌuma.” Aniꞌa ꞌouge reiroteꞌe madaḡano tuḡure vazeḡa aꞌe manoriro. ");
INSERT INTO ksj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ebu Iesuꞌa Petero ne diuḡirotene, Petero emoḡa roḡaeḡa ahiꞌaniꞌa gigine runadu evane rana baze radoga horoniro. ");
INSERT INTO ksj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Iesuꞌa roḡae eꞌe ꞌevoꞌa obonirotene, ahiꞌa gigiꞌa ꞌai dauḡiro. Ebu ani iḡunadu Iesu veize ogomu ruhibiro. ");
INSERT INTO ksj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ḡoravararotene, vaze ḡehaḡaniꞌa vine sauꞌaniꞌa ragano reiroteꞌe azaḡa ḡehaḡa Iesu vaḡe tutuze ariro. Aniꞌe ḡoere hina vine sauꞌa hegoze buziro ebu ugi azaḡa niduꞌa faiziro. ");
INSERT INTO ksj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ꞌOugadu Badiꞌaꞌa peroveta vazeḡa Isaiaonoꞌo reiroteꞌe ḡoeꞌaniꞌa hudaro, “Aniꞌe emeḡe gigiꞌa meiro ebu emeḡe ugi odohiro.” ");
INSERT INTO ksj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Iesuꞌa ane uhiḡano vaze ḡuḡuvaḡa horozirotene, ane tahiꞌatahiꞌa ziro, “Duꞌura moneafa fare onamihi.” ");
INSERT INTO ksj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Eꞌe madaḡano Mose goro ḡoeꞌa ihozeꞌeteꞌe vazeḡa ꞌahoganiꞌa Iesu vaḡe aradu niro, “Ihore vazeḡa, ḡaꞌa noꞌe onamine eḡeꞌa ḡae hegotiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Iesuꞌa naenaeniro, “Butu ḡuniḡaꞌe bazuni habaꞌazeta ebu hitana niniḡaꞌe nezeta. Rehano Vaze Ubugaꞌe bazuni habaꞌa oꞌoꞌa.” ");
INSERT INTO ksj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ebu Iesu tahiꞌa ꞌahoganiꞌa niro, “Zuhiꞌa Boro, e ibite geno mamahe guri onamihi.” ");
INSERT INTO ksj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Rehano Iesuꞌa niro, “Ḡaꞌe eḡe hegotoꞌi. Rune azaḡaniꞌa rune azaḡa guriꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ebu Iesuꞌa ḡasio tirirotene, ane tahiꞌatahiꞌaꞌa ani hegote tiriro. ");
INSERT INTO ksj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ebu zavara boroꞌa duꞌurao feuriro ebu saꞌuꞌa ḡasio kafere diuḡiro. Rehano Iesuꞌe baze radiro. ");
INSERT INTO ksj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Eꞌanoꞌo ze ane vaḡe onamadu evaniro, “Zuhiꞌa Boro, eme ḡabofoꞌi! Eme hunuhuneꞌohe!” ");
INSERT INTO ksj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Iesuꞌa naenaeziro, “Za nougadu rihauꞌohe? Zaꞌa eḡe mazao fieꞌetaꞌaꞌe komeꞌa!” Ebu ani iḡunadu zavara zu saꞌu roziro. ꞌOugirotene, zavara zu saꞌuꞌe roḡeru hauḡiro. ");
INSERT INTO ksj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ebu zeꞌa zaguzagauꞌenaꞌa, ḡadimutitiro, “Vaze ꞌahiꞌe nagi vaze? Zavara zu saꞌuꞌa zuni ani ḡoere egohuꞌohe!” ");
INSERT INTO ksj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Iesuꞌa duꞌura moneafa, Gadara azaḡa habao feurirotene, vine sauꞌazeta azaḡa aheuꞌa idu habaꞌanonoꞌo areꞌenogano Iesu hidiro. Zamazeꞌe ufeta ḡugiziro ꞌahine, eꞌe ibiḡano vazeꞌa onamoga mene idararo. ");
INSERT INTO ksj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ebu ze Iesu ḡihau ḡoreniro, “Badiꞌa Ubuga, ḡaꞌe emeḡe mazao nagini urateꞌohe? Ḡaꞌe, kota madaḡa ḡonaga ꞌizema mougano, aduga rifoga veize emeḡe vaḡe arahe?” ");
INSERT INTO ksj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Zeḡe mazaonoꞌo faḡano aba ḡehaḡaniꞌa ogau radiunu. ");
INSERT INTO ksj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ebu vine sauꞌasauꞌaniꞌa Iesu uminiro, “Ḡaeꞌa eme hegofe bufoꞌidene, aba ḡuḡuvaḡa ꞌomo mazao tuḡufoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ebu aniꞌa vine sauꞌasauꞌa ziro, “Onamoꞌi!” ꞌOuge reirotene, ze vaze aheu mazaonoꞌo buanadu aba ḡuḡuvaḡa zamaḡano diuḡiro. Ebu aba ḡuḡuvaḡa niduꞌaꞌe maḡa komeꞌa gagaḡanonoꞌo dure ovoradu duꞌurao hunuhune rudaro. ");
INSERT INTO ksj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ꞌOugirotene, aba taufeꞌeteꞌe azaḡaniꞌa neze ferau manahadu vine sauꞌasauꞌaniꞌa ragano reiroteꞌe azaḡa mazao naginiꞌa fureraroteꞌe hariḡa niduꞌa meꞌodoziniro. ");
INSERT INTO ksj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ebu ne azaḡa niduꞌa buanadu Iesu hidoga veize ariro. Ze Iesu horonirotene, aniꞌe zeḡe habaꞌanonoꞌo vaḡinoga uminiro. ");
INSERT INTO ksj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iesuꞌa ḡasio tiradu duꞌura moneafa fariro ebu aneꞌa radiunuteꞌe neḡa boro, Kaperanauma bare onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ebu vaze nuꞌa ahiꞌa mene haganeꞌeteꞌe vazeḡa ꞌahoga faratao bazune teadu ani vaḡe herate ariro. Zeḡeꞌa Iesu mazao fieꞌeteꞌe Iesuꞌa horonirotene, ahiꞌa mene haganeꞌeteꞌe vazeḡa niro, “Ubude, zamaḡo rinedoꞌi. Ḡae haḡai sauꞌa ꞌai aḡutu modeha.” ");
INSERT INTO ksj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ꞌOugirotene, Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa nuꞌe ꞌahige zamariro, “Vaze ꞌadiꞌe Badiꞌa rae sausauneꞌohe!” ");
INSERT INTO ksj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Iesuꞌe zeḡeꞌa nagini zamareꞌetaꞌaꞌe ederadu ziro, “Nougadu za zamarone sauꞌa zamareꞌohe? ");
INSERT INTO ksj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ugi vazeḡa mazao nagi ḡoeꞌa nine, ufiḡa? 'Ḡae haḡai sauꞌa ꞌai rae modeha,' rae niꞌeteꞌe ḡoeꞌa ga, 'Iḡunadu onamoꞌi,' rae niꞌeteꞌe ḡoeꞌa? ");
INSERT INTO ksj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Rehano Vaze Ubugaꞌe raha ꞌadao haḡai sauꞌa rae modeꞌeteꞌe gigiꞌaḡa meirotaꞌaꞌe zaeꞌa ederiꞌuma.” Ebu Iesuꞌa ahiꞌa mene haganeꞌeteꞌe vazeḡa niro, “Iḡunoꞌi ebu farataḡo madu neḡo onamoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ebu ugi vazeḡa ꞌai iḡunadu neḡa onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Vaze ḡuḡuvaḡaꞌe eꞌe horonirotene rihau rudaro ebu Badiꞌaꞌa ꞌuguḡa gigiꞌaḡa vaze ziniroteꞌe uꞌano, Badiꞌa niguniro. ");
INSERT INTO ksj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Iesuꞌa eꞌeanoꞌo iḡunadu onamirotene, vaze ꞌahoga, niḡa Mataioꞌa takesi fataḡa uhiḡano ehore radiroteꞌe horoniro. Ebu Iesuꞌa niro, “Eḡe hegotoꞌi.” Ebu Mataioꞌa iḡunadu Iesu hegotiro. ");
INSERT INTO ksj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Iesuꞌa Mataio neo ḡorava ogomu aroteꞌe zamaḡano, takesi azaḡa zu haḡai sauꞌa azaḡa ḡehaḡaniꞌa Iesu zu ane tahiꞌatahiꞌa teite ogau tiburaro. ");
INSERT INTO ksj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisea azaḡaniꞌa eꞌe horonirotene, Iesu tahiꞌatahiꞌa ḡadiziro, “Nougadu zae ihore vazeḡaꞌe takesi azaḡa zu haḡai sauꞌa azaḡa teite ogau tiburuꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Iesuꞌa eꞌe egadu ziro, “Ugi oꞌoꞌa azaḡaꞌe gohe vazeḡa mene vaḡeꞌohe, rehano ugi azaḡaꞌe gohe vazeḡa vaḡeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Zaꞌe onamadu Badiꞌa ḡoere ꞌahi huga ederoꞌi, 'Eꞌe dibuꞌo mene urateꞌohe, rehano zaeꞌa vaze vetuḡazoga urateꞌohe.' E iniu zeḡeꞌa bare duduḡa azaḡa rae zamareꞌeteꞌe azaḡa huzoga radu mene ariro, rehano iniu zeḡeꞌa bare haḡai sauꞌa azaḡa rae zamareꞌeteꞌe azaḡa huzoga radu ariro.” ");
INSERT INTO ksj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ebu Ioane tahiꞌatahiꞌaꞌa Iesu vaḡe aradu ḡadiniro, “Eme zu Farisea azaḡaꞌe ḡae ḡehaḡa ogomu moneo zaḡozaḡeꞌohe. Rehano ḡae tahiꞌatahiꞌaꞌe nougadu ogomu moneo mene zaḡozaḡeꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ebu Iesuꞌa ziro, “Hahu muiḡa madaḡano hahu ohozeḡa iziganiꞌa huziroteꞌe azaḡaꞌe, hahu ohozeḡa iziga teite radiuꞌeteꞌe zamaḡano zamazeꞌa aradu niaꞌumahe? Rehano zeḡe mazaonoꞌo hahu ohozeḡa izigaꞌe mae vaḡiniteꞌe madaḡaniꞌa ariꞌuma. Eꞌe madaḡano ze ogomu moneo zaḡozaḡiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Vaze ꞌahoganiꞌa dabua iziga variꞌe madu dabua amahiḡa mene banineꞌohe, mazaḡa dabuaḡa vuzuꞌine, dabua siꞌiga izigaꞌe ḡuanadu amahiḡa hutubiꞌuma zu borofe zigiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ebu vazeni ꞌahoganiꞌa vaini vuḡa fuse amahiḡa zamaḡano vaini vuḡa iziga mene beꞌune ufiꞌohe. Beꞌune ufine, vaini vuḡa iziganiꞌa bare busure bororanadu vaini vuḡa fuse amahiḡaniꞌa zigaꞌuma, ebu vaini vuḡaꞌe sore rururaꞌuma zu vaini vuḡa fuse amahiḡa sausauniꞌuma. Eꞌanoꞌo vaini vuḡa izigaꞌe vaini vuḡa fuse izigano beune ufine, aheuni manoḡa radiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iesuꞌa eꞌe ḡoeꞌa ziꞌeteꞌea, nuꞌonuꞌo neḡa vazeḡa ḡihiꞌaḡa ꞌahoganiꞌa Iesu vaḡe ariro. Ebu Iesu zamao obenaḡa hina tuḡadu niro, “Eḡe aboeꞌe iziduꞌu rudaneha. Rehano ḡaeꞌa aradu ani rana ꞌevoꞌo toꞌi, ꞌougine ani ḡabodiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ebu Iesuꞌa iḡunadu ani teite onamiro ebu Iesu tahiꞌatahiꞌa zuni ani teite onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Eꞌe ibiḡano roḡae ugi madu muri gaubanana aheu fare adugano radiunuteꞌe roḡaeḡa ꞌahoganiꞌa Iesu ḡaruna aradu ani dabua ꞌariḡa tahiḡa oboniro. ");
INSERT INTO ksj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mazaḡa aniꞌe ꞌahige zamariro, “E ani dabua tahiḡa obonine, manoriꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ebu Iesuꞌa tehadu ani ḡianadu niro, “Aboe, zamaḡo rinedoꞌi. Ḡaeꞌa eḡe mazao fieꞌeteꞌe uꞌano, ugiḡoꞌa manoreha.” ꞌOuge reirotene, ani manoriro. ");
INSERT INTO ksj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Iesuꞌa nuꞌonuꞌo neḡa vazeḡa ḡihiꞌaḡa neo feurirotene, rune vazeḡa veize suraꞌi hodiꞌeteꞌe azaḡa zu borofe haraeꞌeteꞌe vazeḡa ḡuḡuvaḡa horoziro. ");
INSERT INTO ksj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ebu aneꞌa ziro, “Zae niduꞌa buanoꞌi. Roḡae komeꞌa aꞌe mene rudaneha, rehano bazeꞌohe.” Rehano zeꞌe Iesu eḡofoharo. ");
INSERT INTO ksj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Iesuꞌa vaze ḡuḡuvaḡa enoneo tuḡuze buziroteꞌe ḡarugano, ne zamaḡa diuḡadu roḡae komeꞌa ꞌevoꞌa oboniro. ꞌOugadu ani iḡuniro. ");
INSERT INTO ksj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ebu eꞌe hariḡaꞌe eꞌe habaꞌa niduꞌa zamaḡano bororaro. ");
INSERT INTO ksj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iesuꞌa eꞌea mode onamirotene, ubumaze kuruḡa azaḡa aheuꞌa ani hegotiro. Zeꞌa ḡihau huaro, “Davida mariga, eme vetuḡafoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Iesuꞌa ne diuḡirotene, ubuma kuruḡa azaḡaniꞌa ane vaḡe ariro. Iesuꞌa ḡadiziro, “Zaꞌe eḡeꞌa faizoga idaḡa rae mae ḡihiheꞌehe?” Zeḡeꞌa naenaeniro, “Oꞌe, Zuhiꞌa Boro.” ");
INSERT INTO ksj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ebu aniꞌa ubumaze obonadu ziro, “Zaeꞌa eḡe mazao fieꞌeteꞌe idunaḡano ubumazeꞌa manoriꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ꞌOugirotene, ubumazeꞌa raꞌaro. Ebu Iesuꞌa riḡa ziro, “Zae mazao naginiꞌa fureranateꞌe vazeni ꞌahoga ago noꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Rehano ze onamadu eꞌe habaꞌa niduꞌa zamaḡano ani hari rae ḡehaniro. ");
INSERT INTO ksj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ebu ze neonoꞌo buau onamirotene, vaze nuꞌa vaze ꞌahoga Iesu vaḡe tutune ariro. Vine sauꞌaniꞌa vaze eꞌe ragano radu aniꞌe ḡoeroga mene idararo. ");
INSERT INTO ksj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ebu Iesuꞌa vine sauꞌa vaze eꞌe mazaonoꞌo hegone bunirotene, mumutafa vazeḡaniꞌa ḡoeriro. Ebu vaze ḡuḡuvaḡaniꞌa zaguzaganadu reiro, “Ibite Isaraela habaꞌano ꞌahiguḡaniꞌa mene fureraro.” ");
INSERT INTO ksj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Rehano Farisea azaḡaniꞌa reiro, “Iesuꞌe vine sauꞌa zuhiꞌaḡa gigiꞌaḡa hina vine sauꞌasauꞌa hegoze buzeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iesuꞌe ne boro nunu zu ne komeꞌa nunu ragave onamadu Iuda azaḡa nuꞌonuꞌo neḡano ihoziro, zu Badiꞌaꞌa zuhiꞌaziꞌeteꞌe moneo hari manoḡa haramiro. Ebu ugi zu gigiꞌa niduꞌa fainiro. ");
INSERT INTO ksj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Iesuꞌa vaze ḡuḡuvaḡa horozadu vetuḡaziro, mazaḡa zeꞌe vazeꞌa mene taufeꞌeteꞌe mamoeḡa teige ufeta taoraro zu dana ꞌahoga mene hidiro. ");
INSERT INTO ksj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ꞌOugadu ani ane tahiꞌatahiꞌa ziro, “Hiriviteꞌe ḡauḡaꞌe ḡehaḡa bagaḡa, rehano gau azaḡaꞌe tahiḡa. ");
INSERT INTO ksj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Eꞌanoꞌo hiriveꞌeteꞌe Zuhiꞌaḡa Boro mazao gau azaḡa ane mebao tuḡuzoga veize uminoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesuꞌa ane tahiꞌa gaubanana aheu fare huze nuꞌoziro, ebu vine sauꞌa hegoze buzeꞌeteꞌe zu ugi nunu faineꞌeteꞌe gigiꞌaḡa ziniro. ");
INSERT INTO ksj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Iesu apostolo gaubanana aheu fare nizeꞌe ꞌahi eꞌe: Ibiꞌaꞌe Simona (niḡa ꞌahogaꞌe Petero), ani negoḡa Anderea, Zebedeo ubuga Iakobo zu ane negoḡa Ioane, ");
INSERT INTO ksj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipi, Batolomeo, Tomasi, takesi vazeḡa Mataio, Alefeo ubuga Iakobo, Tadeo, ");
INSERT INTO ksj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Zelota vazeḡa Simona ebu Iesu revoharoteꞌe vazeḡa, Isakariota vazeḡa Iuda. ");
INSERT INTO ksj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iesuꞌa ane tahiꞌa gaubanana aheu fare tuḡuzeꞌenaꞌa, ꞌahige ihoziro, “Iuda mene azaḡa haba ago onamoꞌi, ebu Samaria azaḡa ne zuni ago diuḡoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Rehano Isaraela habaꞌano dauḡiroteꞌe mamoeḡa vaḡe onamoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ebu neḡaneḡa ragave onamoꞌidene, 'Badiꞌaꞌa zuhiꞌaziꞌeteꞌe madaḡa ꞌai haniteha,' rae haramozenoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ugi azaḡa faizoꞌi, rune azaḡa ḡabozoꞌi, refera azaḡa faizoꞌi ebu vine sauꞌa hegoze buzoꞌi. Zaeꞌa naeḡa oꞌoꞌa ḡauḡa hidiro ꞌahine, naeḡa ago maꞌenaꞌa, ḡahugoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Niharazeo hadi boro ga komeꞌa zuni ago odohoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Zae ragavo veize nihara ga dabua ꞌahoga ga tamaka ga tuḡu ago odohoꞌi, mazaḡa gau azaḡaꞌe nagini urateꞌeteꞌe ḡauḡaꞌe hideꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Noꞌe ne boro ga ne komeꞌa diuḡoꞌidene, zae mae ḡihiziteꞌe vazeḡa vaḡadu ane neo radoꞌi onamo ne eꞌe mode iḡunoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ane ne diuḡoꞌidene, ibite geno ꞌahige unihoꞌi, 'Badiꞌaꞌa zama roḡeḡa zenoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ebu eꞌe neo radiuꞌeteꞌe azaḡaꞌe zama roḡeḡa urateꞌeteꞌe azaḡa reine, zaeꞌa rateꞌe zama roḡeḡaꞌe zeḡe rana radiꞌuma. U mene reine, zaeꞌa rateꞌe zama roḡeḡa eꞌeꞌa zae bare vaḡiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ne azaḡaniꞌa zae mene mae zouzoꞌidene, ga ḡoereze mene egozenoꞌidene, odaze huꞌuruḡa zauhe mode manahadu eꞌe habaꞌa ga neḡa mode iḡunoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Eḡeꞌa hube hune ziꞌohe, Badiꞌa kota madaḡano za mene mae ḡihiziroteꞌe azaḡaꞌe Sodoma zu Gomora azaḡa ufeta vitize aduga boro hidiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ḡianoꞌi. Butu ḡuniḡa boꞌaḡano mamoe tuḡuzeꞌeteꞌe teige, e za agire azaḡa boꞌaḡano tuḡuzeꞌohe. Eꞌanoꞌo mohe teige zamarone huhuzaḡa moꞌi, zu Tubugo niniḡa teige sauꞌa ago haḡaoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Rehano vaze ḡiazoꞌi. Ze zae oboze teadu kotao ohoziꞌuma ebu zeḡe nuꞌonuꞌo neḡano masiziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Eḡe uꞌano, gavana azaḡa zu kini mazao zae tutuze onamiꞌuma, ebu zaeꞌa eḡe hari manoḡa zeḡe zu Iuda mene azaḡa zamao rae fureniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Rehano zeꞌa kotao za oboze toꞌidene, nougenouge zae bare biriteꞌe ga nagini rae ḡoeriteꞌe moneo zamaze ago adudanoꞌi, mazaḡa eꞌe madaḡano zaeꞌa nagini rae ḡoeriteꞌe moneo ihoziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ḡoere aꞌe mene zae mazaonoꞌo, rehano Moze Viganiꞌa zae mazaonoꞌo ḡoeriꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Negoḡaniꞌa negoḡa revohanadu runeo tuḡuniꞌuma. Ebu moganiꞌa ubuga revohanadu runeo tuḡuniꞌuma. Ebu ubudezeꞌa vize moze agirozeadu runeo tuḡuziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Eḡe uꞌano, vaze niduꞌa za heꞌeheꞌeziꞌuma. Rehano iniu edau gigaru onamo ḡonaga meiteꞌe vazeḡaꞌe ḡabone hidiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ne ꞌahogano za sausauzoꞌidene, feranadu ne ꞌahoga onamoꞌi. Eḡeꞌa hube hune ziꞌohe, zaeꞌa Isaraela habaꞌa niduꞌa ꞌizema harame oname hauḡogano Vaze Ubuganiꞌa ariꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Tahiꞌaꞌe ane ihore vazeḡa mene vitinoga, ebu tuḡure vazeḡaꞌe ane zuhiꞌa mene vitinoga. ");
INSERT INTO ksj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tahiꞌaꞌe ane ihore vazeḡa teigeꞌohe rae reine, aꞌe idaḡa, ebu tuḡure vazeḡaꞌe ane zuhiꞌa teigeꞌohe rae reine, aꞌe idaḡa. Zaꞌe eḡe teite ne tibano tiburu radiuꞌeteꞌe azaḡa heuḡa. Vazeꞌa eꞌe Belezebulo rae huhiro. Eꞌanoꞌo eḡe teite tiburu radiuꞌeteꞌe azaḡa, zaꞌe ufeta sauꞌano huziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Eꞌanoꞌo vazeꞌa sausauzoꞌidene, ago rihozoꞌi. Uꞌuru radiuꞌeteꞌe ḡauḡa niduꞌa fureraꞌuma, ebu ogone ḡahineꞌeteꞌe ḡauḡa zuni ederiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Eḡeꞌa uzabo zamaḡano zae daꞌo ziꞌeteꞌe ḡoeꞌaꞌe za mada agaḡano vaze niduꞌa zoꞌi. Ebu eḡeꞌa nagini sifu gumude ziꞌeteꞌe ḡoeꞌaꞌe ne binuḡa hitaganonoꞌo rae furenoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Vazeꞌe ahiri manogaꞌe idaḡa rehano, vine manogaꞌe mene idaḡa. Eꞌanoꞌo ze ago rihozoꞌi. Rehano Badiꞌa daꞌo rihonoꞌi, mazaḡa aniꞌe vine zu ahiriꞌe ire roga radiu tuḡutuḡu zamaḡano ruizoga idaḡa. ");
INSERT INTO ksj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tiburi niniḡa aheuꞌe hadi komeꞌa hina seroneꞌohe. Rehano Badiꞌa, zae Mamaꞌa mene uratine, zeḡe boꞌaḡano tiba zuni rahao mene uitiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Badiꞌaꞌa zae zamare borofadu vadinize iguḡa niduꞌaꞌe nugu zuni edereꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Eꞌanoꞌo ago rihanoꞌi, mazaḡa zaꞌe Badiꞌa ubumao Tiburi niniḡa ḡehaḡa ufeta vitizoga. ");
INSERT INTO ksj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Iniuꞌa vaze ubumao eḡe moneo edaune, eḡe zuni adureo Mamahe ubumao ane moneo edaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Rehano iniuꞌa vaze ubumao eḡe oꞌohine, eḡe zuni adureo Mamahe ubumao ani oꞌoniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Eḡeꞌa uniho manoḡa rahao ꞌada mae ariro rae ago zamaroꞌi. Eꞌe uniho manoḡa mene mae ariro, rehano benisi mae ariro. ");
INSERT INTO ksj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Eꞌa ubugaꞌe moga teite agirotitoga, avoḡaꞌe viꞌa teite agirotitoga, roḡaeꞌe ani hadoga roḡaeḡa teite agirotitoga veize ariro. ");
INSERT INTO ksj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Za agire azaḡaꞌe zae teite ne tibano radiuꞌeteꞌe azaḡa reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Iniuꞌa moga ga viꞌa eḡe ufeta vitihe zamare borofine, aniꞌe eḡe mene tahiꞌa reꞌuma, ebu iniuꞌa ubuga ga aboḡa eḡe ufeta vitihe zamare borofine, aniꞌe eḡe mene tahiꞌa reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Iniuꞌa ane satauro odoheꞌenaꞌa eḡe ḡaruna mene hegotine, aniꞌe eḡe mene tahiꞌa reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Iniu ani ḡabone obone giganine, ani ḡabone tuḡutuḡu mene hidiꞌuma. Rehano iniuꞌa ane ḡabone eḡe veize ahetine, ḡabone tuḡutuḡu hidiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Zae mae ḡihizeꞌeteꞌe vazeḡaꞌe eḡe mae ḡihiheꞌohe. Ebu eḡe mae ḡihiheꞌeteꞌe vazeḡaꞌe eḡe tuḡuhiroteꞌe Badiꞌaḡa mae ḡihineꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Iniuꞌa peroveta vazeḡaꞌe Badiꞌa ḡoere rae fureneꞌeteꞌe vazeḡa rae mae ḡihinine, aniꞌe peroveta vazeḡaniꞌa hiditeꞌe naeḡa hidiꞌuma. Iniuꞌa duduḡa vazeḡaꞌe vaze duduḡa rae mae ḡihinine, aniꞌe vaze duduḡaniꞌa hiditeꞌe naeḡa hidiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Eḡeꞌa hube hune ziꞌohe, iniuꞌa nize komeꞌa azaḡa ꞌadi boꞌaḡano ꞌahogaꞌe eḡe tahiꞌa radu vu nahuga bioḡa tiba haune, aniꞌe aneꞌa meiteꞌe naeḡa mene hune dauniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iesuꞌa ane tahiꞌa gaubanana aheu fare ihoze hauḡirotene, eꞌeanoꞌo iḡunadu ne uhiḡauhiḡano ihozifine zu haramifine onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ioane Babatisoꞌa ḡuꞌa neḡano radiunuteꞌe zamaḡano Kerisoꞌa nagini haḡairoteꞌe hariḡa igiro. ꞌOugadu aniꞌe Iesu ḡadinoga veize ane tahiꞌatahiꞌa Iesu vaḡe tuḡuziro. ");
INSERT INTO ksj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ebu zeḡeꞌa Iesu ḡadiniro, “Ariꞌuma rae reiroteꞌe vazeḡaꞌe ḡahe? Mene reine, eme vaze ꞌahoga guhiniꞌumahe?” ");
INSERT INTO ksj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Iesuꞌa naenaeziro, “Bare onamadu zaeꞌa igiꞌeteꞌe zu horoneꞌeteꞌe Ioane ihonoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ubuma kuru azaḡaꞌe ehamuꞌohe, oda sauꞌa azaḡaꞌe edau ragaveꞌohe, refera azaḡaꞌe manoreꞌohe, teḡaze uhuḡa azaḡaꞌe igiꞌohe, rune azaḡaꞌe bare ḡabodeꞌohe ebu zahara azaḡaniꞌa hari manoḡa igiꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Eḡe mazao fieꞌetaꞌaꞌe mene modeꞌeteꞌe vazeḡaꞌe matuꞌe rudauꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ioane tahiꞌatahiꞌaꞌa iḡunirotene, Iesuꞌa Ioane moneo vaze ḡuḡuvaḡa ḡadahe ziro, “Za nagini horonoga veize haba bohaꞌa onamiro? Zavaraꞌa imi hudi naeninaeniꞌeteꞌe horonoga radu onamirohe? ");
INSERT INTO ksj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mene reine, za nagini horonoga veize onamiro? Dabua manomano vidaroteꞌe vazeḡa horonoga veize onamirohe? Mene, dabua manomano vidaroteꞌe vazeḡaꞌe kini neo radiuꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tena nagini horonoga veize onamiro? Peroveta vazeḡahe? Oꞌe, eḡeꞌa ziꞌohe, peroveta azaḡa vitizeꞌeteꞌe vazeḡaꞌe Ioane. ");
INSERT INTO ksj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ioane moneo Buka Zaḡoḡano ꞌahige rae mirihiro, 'Ḡianoꞌi, eḡeꞌa ḡae zamao vaze ꞌahoga ibite tuḡuniꞌuma. Aniꞌe ḡae zamao ḡae ibi ruhibiꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Eꞌanoꞌo eḡeꞌa hube hune ziꞌohe, Ioaneꞌe rahao ꞌada fureraroteꞌe azaḡa niduꞌa vitizoga. Rehano Badiꞌaꞌa zuhiꞌaziꞌeteꞌe zamaḡanoꞌe ḡonaga vazeḡa zuni Ioane vitinoga. ");
INSERT INTO ksj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ioane Babatisoꞌa haramiroteꞌe madaḡanonoꞌo onao izidi, Badiꞌaꞌa zuhiꞌaziꞌeteꞌe hariḡaꞌe riḡa harame onameꞌohe. Ebu vaze inaraḡaꞌe Badiꞌaꞌa zuhiꞌaziꞌeteꞌe zamaḡano diuḡeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ioaneꞌa ꞌizema ariroteꞌe madaḡanoꞌe peroveta azaḡa zu Mose goro ḡoeꞌaniꞌa Badiꞌaꞌa zuhiꞌaziꞌeteꞌe moneo rae fureniro. ");
INSERT INTO ksj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Zeḡeꞌa rae fureniroteꞌe ḡoeꞌa zaeꞌa mae ḡihinihi rae reine, zaꞌe ederiꞌuma, Ioaneꞌe ariꞌuma rae reiroteꞌe vazeḡa, Elia. ");
INSERT INTO ksj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Teḡaḡeta vazeḡaꞌe faifaine egadu huga ederoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Izidi azaḡaꞌe naginio idaziꞌuma? Zeꞌe tahiꞌa komeꞌakomeꞌaniꞌa ne hunio ehoradu araheꞌeteꞌe heuḡa. Ze rovozadu none tahiꞌaḡaniꞌa mone tahiꞌaḡa mazao ꞌahige huauꞌohe, ");
INSERT INTO ksj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","'Eme muio suraꞌi hodeha, rehano za mene zavoneha. Ebu eme rune habaꞌano niau ḡoinaheha, rehano za mene nianeha.' ");
INSERT INTO ksj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ioane Babatisoꞌa aradu ogomu mene audo zu vaini vuḡa mene gagido. ꞌOugadu ze ꞌahige rae reiro, 'Ioaneꞌe vine sauꞌaḡeta.' ");
INSERT INTO ksj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","U Vaze Ubugaꞌe aradu ogomu auꞌohe ebu vaini vuḡa gageꞌohe. ꞌOugeꞌetene, ze ꞌahige raꞌohe, 'Ḡianoꞌi, aniꞌe ogomu fuꞌa zu vaini vuḡa fuꞌa. Ebu ani takesi azaḡa zu haḡai sauꞌa azaḡa teite tiburuꞌohe.' Rehano iniu Badiꞌa zamarone huhuzaḡa hegotiroteꞌe azaḡaꞌe Badiꞌazamarone huhuzaḡaꞌe duduḡa rae fureneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Eꞌe madaḡano Iesuꞌe aneꞌa haḡai gigiꞌa ḡehaḡa haḡairoteꞌe habaꞌahabaꞌa azaḡa roziro, mazaḡa zeꞌe haḡaize sauꞌanonoꞌo mene ḡihuriro. ");
INSERT INTO ksj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Aneꞌa ziro, “Korasini azaḡa, za aduga boro hidiꞌuma! Betesaida azaḡa, za aduga boro hidiꞌuma! Eḡeꞌa zae mazao haḡairoteꞌe haḡaiḡa gigiꞌaꞌe Turo zu Sidono azaḡa mazao haḡaifone, ze dabuaze ḡuꞌa vidanadu vega vadinizeo ase ḡuzuheꞌenaꞌa, haḡaize sauꞌanonoꞌo ḡihurifo. ");
INSERT INTO ksj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Eḡeꞌa ziꞌohe, Badiꞌa kota madaḡano zaꞌe Turo zu Sidono azaḡa ufeta vitize aduga boro hidiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kaperanauma azaḡa, zaꞌe adureo Badiꞌa haba tutuze itiꞌuma rae zamareꞌehe? Mene! Zaꞌe rune habaꞌano mae feuziꞌuma. Eḡeꞌa zae mazao haḡairoteꞌe haḡai gigiꞌaḡa Sodoma azaḡa mazao haḡaifone, zeꞌe haḡaize sauꞌanonoꞌo ḡihuradu izidi ꞌize radiuꞌefo. ");
INSERT INTO ksj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Eḡeꞌa ziꞌohe, Badiꞌa kota madaḡano zaꞌe Sodoma azaḡa ufeta vitize aduga boro hidiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Eꞌe madaḡano Iesuꞌa ꞌahige rae reiro, “Mama, ḡaꞌe adure zu raha Zuhiꞌaḡa. E niguꞌeꞌohe, mazaḡa ḡaeꞌa vaze huhuzaḡa zu edeḡa boro azaḡa mazaoꞌe ḡoere huga ꞌahiguḡa ꞌuꞌuru tiro, rehano tahiꞌa komeꞌa teigeꞌeteꞌe azaḡa mazaoꞌe rae fureniro. ");
INSERT INTO ksj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mama, a hube, ꞌouge haḡairotaꞌaꞌe ḡae ura. ");
INSERT INTO ksj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Eḡe Mamaꞌa ḡau niduꞌa eḡe iniro. Vazeni ꞌahoga Ubuga aḡuꞌa, rehano Moga ane daꞌo edeḡa. Ebu vazeni ꞌahoga Moga aḡuꞌa, rehano ane Ubuga daꞌo zu Ubuganiꞌa Moga moneo ihozoga veize ohotiroteꞌe azaḡa daꞌo Moga edeḡa. ");
INSERT INTO ksj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Taoḡa zu aduga odoheꞌeteꞌe azaḡa, eḡe vaḡe aroꞌi, ꞌougine eḡeꞌa ahirize ohoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Eꞌe namiḡa zu roḡeḡa ꞌahine, eḡe ihore mae ḡihinadu eḡe mazaonoꞌo edeḡa moꞌi. ꞌOugine, zamaze roḡeraꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mazaḡa eḡe ihoreꞌe mene riḡa zu eꞌe hegotogaꞌe mene aduga.” ");
INSERT INTO ksj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Eꞌe madaḡano, Iesuꞌa Bana Madaḡano vuidi mebaḡa zamaḡano onamiro. Ebu ani tahiꞌatahiꞌaꞌe viniziroteꞌe uꞌano, vuidi maḡa ririꞌe madu ḡadahe aro. ");
INSERT INTO ksj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farisea azaḡaniꞌa eꞌe horonadu Iesu niro, “Ḡianoꞌi! Ḡae tahiꞌatahiꞌaꞌa Bana Madaḡa goroḡa varadeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Iesuꞌa naenaeziro, “Zaꞌe Buka Zaḡoḡa mene meꞌodirohe? Davida zu ani ḡatiniroteꞌe azaḡaꞌe vinize ruzirotene, Davidaꞌa nougiro? ");
INSERT INTO ksj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Aniꞌe Badiꞌa ne diuḡadu dibuꞌo azaḡaniꞌa daꞌo auꞌeteꞌe dibuꞌo ꞌuvahuḡa odoga aro, ebu ani ḡatiniroteꞌe azaḡa zuni aro. Aꞌe ze anogaꞌe mene idaḡa rae reiroteꞌe ḡauḡa. ");
INSERT INTO ksj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ebu Mose goro ḡoeꞌano ꞌahige rae reiro, 'Bana Madaḡano dibuꞌo azaḡaniꞌa kuru neḡano gaueꞌetaꞌaꞌe mene veꞌoḡa.' Za ꞌahi mene meꞌodirohe? ");
INSERT INTO ksj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Eḡeꞌa ziꞌohe, kuru neḡa ufeta vitineꞌeteꞌe vazeḡa ḡihiꞌaḡaꞌe ꞌahi eꞌe. ");
INSERT INTO ksj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Badiꞌaꞌa ꞌahige rae reiro, 'E dibuꞌo mene urateꞌohe, rehano zaꞌe vaze vetuḡazoga urateꞌohe.' Zaeꞌa ḡoere eꞌe huga ederifone, veꞌoḡa oꞌoꞌa azaḡa mazao veꞌoḡa rae mene zifo. ");
INSERT INTO ksj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Vaze Ubugaꞌe Bana Madaḡa Zuhiꞌaḡa.” ");
INSERT INTO ksj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ebu Iesuꞌa eꞌe habaꞌa modadu Iuda azaḡa nuꞌonuꞌo neḡa diuḡiro. ");
INSERT INTO ksj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Eꞌea naeḡa ꞌevoꞌa hoega vazeḡa ꞌahoganiꞌa radiunu. Farisea azaḡaꞌe Iesuꞌa vaze eꞌe fainine, kotao ohonihi radu ḡadiniro, “Bana Madaḡano ugi azaḡa faizogaꞌe idaḡahe?” ");
INSERT INTO ksj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Aniꞌa ziro, “Zae boꞌaḡano iniu mamoe tibuhugaḡeta radu Bana Madaḡano mamoeḡaniꞌa iduo uite ovoine, iduonoꞌo mene mae vaḡiniꞌumahe? ");
INSERT INTO ksj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Vazeꞌe mamoe ufeta vitizoga zu ḡihiꞌaḡa. Eꞌanoꞌo Bana Madaḡano manoḡa haḡaeꞌetaꞌaꞌe idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ebu aniꞌa ꞌevoꞌa hoega vazeḡa niro, “ꞌEvoꞌo ꞌeinoꞌi.” Aniꞌa ꞌevoꞌa ꞌeinirotene, naeḡa ꞌevoꞌa teige ꞌevoꞌaniꞌa manoriro. ");
INSERT INTO ksj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Rehano Farisea azaḡaniꞌa nuꞌonuꞌo neḡanonoꞌo buanadu nougenouge Iesu matiteꞌe moneo ḡoꞌaniro. ");
INSERT INTO ksj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Iesuꞌe Farisea azaḡaniꞌa ani matihi raꞌeteꞌe ederirotene, eꞌe habaꞌa mode vaḡiniro. Rehano vaze ḡuḡuvaḡaniꞌa ani hegotiro ebu aneꞌa ugi azaḡa niduꞌa faiziro. ");
INSERT INTO ksj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ebu ani riḡa ḡoreziro, “Eꞌe iniu rae vaze ago ihozoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ꞌOugadu Badiꞌaꞌa peroveta vazeḡa Isaiaonoꞌo reiroteꞌe ḡoeꞌaniꞌa hudaro, ");
INSERT INTO ksj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“ꞌAhiꞌe eḡeꞌa ohotiroteꞌe vazeḡa zu eḡe tuḡure vazeḡa. Aniꞌe eḡe zamarone vazeḡa zu eḡe matuꞌoniꞌeteꞌe vazeḡa. Eḡeꞌa Vinehe ane rana ohoniꞌuma, aniꞌa habaꞌahabaꞌano Badiꞌa kota moneo haramiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Aniꞌe mene rotetiꞌuma ga mene hounaꞌiꞌuma, aniꞌa ne hunio mene hounaꞌe ḡoeriꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Roratiteꞌe veḡa mene mae vaḡineꞌeteꞌe ga vidatiteꞌe ihureḡa mene hudi vineꞌeteꞌe teige, aniꞌa zoreḡa azaḡa mene mae vaḡiziꞌuma, onamo ḡau veꞌoḡa niduꞌa mae vaḡinadu zuhiꞌaziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ebu Badiꞌa aḡuꞌa azaḡaniꞌa ani niḡano ḡabone hiditeꞌe madaḡa guhiniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ebu vaze nuꞌe vine sauꞌaniꞌa agatoharoteꞌe vazeḡa ꞌahoga Iesu vaḡe tutune ariro. Aniꞌe ubumaḡa kuruḡa zu mumutafa. Ebu Iesuꞌa ani fainadu aniꞌe ḡoeriro zu ehamaro. ");
INSERT INTO ksj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ebu vaze niduꞌa zaguzaganadu ꞌahige rae reiro, “ꞌAhiꞌe Davida mariga, Keriso gaogi!” ");
INSERT INTO ksj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Rehano Farisea azaḡaniꞌa ḡoereze igirotene, ꞌahige rae reiro, “Aniꞌe vine sauꞌa zuhiꞌaḡa, Belezebulo inaraḡa hina vine sauꞌasauꞌa hegoze buzeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Rehano Iesuꞌa ze nouge rae zamareꞌeteꞌe ederadu ziro, “Haba tiba zamaḡano zeḡeꞌa rovotadu utitine, eꞌe habaꞌaꞌe aneꞌa bare ruiniꞌuma. Ebu ne boro ꞌahoga ga ne tiba zamaḡano zeḡeꞌa rovotadu utitine, ze mene edau gigaraꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sataniꞌa Satani hegone bunine, ani aneꞌa bare rovotadu utitiꞌuma. ꞌOugine, aneꞌa zuhiꞌaziꞌeteꞌe habaꞌaꞌe nougenouge edau gigaraꞌuma? ");
INSERT INTO ksj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Eḡeꞌa Belezebulo inaraḡa hina vine sauꞌa hegoze buzine, zae tahiꞌatahiꞌaꞌe iniu inaraḡa hina vine sauꞌa hegoziꞌuma? Zae tahiꞌatahiꞌaꞌe zeḡeꞌa bare zaꞌe veꞌoḡa rae reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Rehano eḡeꞌa vine sauꞌaꞌe Badiꞌa Viga hina hegoze buzeꞌohe. Aꞌe Badiꞌaꞌa amahi zae zuhiꞌazirotaꞌaꞌe ihozeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Vaze ꞌahoganiꞌa inara vazeḡa ꞌahoga mene batune tine, nougenouge ani ne diuḡadu ane tohe ḡonotu buau tauḡiꞌuma? Ani ibite inara vazeḡa batune teadu ane ne toheḡa ḡonotaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Iniu eḡe teite mene reine, aniꞌe eḡe agirohiꞌeteꞌe vazeḡa. Ebu iniu Badiꞌa veize eḡe teite vaze mene nuꞌozine, ani Badiꞌa mazaonoꞌo vaze rovozeꞌeteꞌe vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Eꞌanoꞌo eḡeꞌa ziꞌohe, vaze haḡai sauꞌa niduꞌa ebu Badiꞌa rae sausauneꞌeteꞌe ḡoeꞌa niduꞌaꞌe Badiꞌaꞌa rae modiꞌuma. Rehano iniuꞌa Vine Zaḡoḡa rae sausaunine, ani haḡai sauꞌaꞌe mene rae modiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Iniuꞌa Vaze Ubuga agirohauꞌenaꞌa rae sausaunine, Badiꞌaꞌa ani haḡai sauꞌa rae modiꞌuma, rehano iniuꞌa Vine Zaḡoḡa agirohauꞌenaꞌa rae sausaunine, ane haḡai sauꞌaꞌe izidi ebu zazore madaḡano zuni mene rae modiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ire manoḡaꞌe maḡa manoḡa iniꞌuma zu ire sauꞌaꞌe maḡa sauꞌa iniꞌuma. Ireꞌe maḡa horonadu nagi ireḡa rae edereꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Zaꞌe Zarama mariga! Zaꞌe sauꞌa azaḡa uꞌano, ḡoere manoḡa ꞌahoga mene raꞌohe. Naginiꞌa ane zamao iriꞌave radiuꞌetaꞌaꞌe hebeꞌanonoꞌo buauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Vaze manoḡaꞌe ani zamao manoḡa nuꞌonadu manoḡa fureneꞌohe, ebu sauꞌa vazeḡaꞌe ane zamao sauꞌa nuꞌonadu sauꞌa fureneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Eḡeꞌa ziꞌohe, Badiꞌa kota madaḡano vaze niduꞌa zeḡeꞌa bare ibite reiroteꞌe huga oꞌoꞌa ḡoeꞌa niduꞌa moneo Badiꞌaꞌa kotaziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Zaeꞌa reiroteꞌe ḡoeꞌa idunaḡano Badiꞌaꞌa zaꞌe duduḡa ga veꞌoḡa rae kotaziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Eꞌe madaḡano Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zu Farisea azaḡa boꞌaḡano nuꞌa Iesu niro, “Ihore vazeḡa, eme ḡaeꞌa haḡai nu badeḡa haḡaeꞌeteꞌe ḡianihi raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Iesuꞌa naenaeziro, “Sauꞌa zu ubuma ḡezo azaḡaniꞌa haḡai nu badeḡa umideꞌohe. Rehano peroveta vazeḡa Iona mazao fureraroteꞌe haḡai nu badeḡa daꞌo ihoziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ionaꞌe mada uḡidu zu ohere uḡidu ḡozone boro isio radiro. Eꞌe teige, Vaze Ubuganiꞌa zuni mada uḡidu zu ohere uḡidu raha zamaḡano radiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Badiꞌa kota madaḡano Nineva azaḡaniꞌa izidi ega azaḡa teite iḡune edanadu izidi ega azaḡaꞌe veꞌoḡa rae roziꞌuma. Mazaḡa ibite madaḡano Nineva azaḡaꞌe Iona haramo abitadu haḡaize sauꞌanonoꞌo ḡihure ḡouriro. Izidi Iona vitinoga vazeḡaꞌe ꞌahi eꞌe, rehano ze ani ḡoere mene abitadu mene ḡihureꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Badiꞌa kota madaḡano Siba habaꞌa kini roḡaeḡaniꞌa izidi ega azaḡa teite iḡune edanadu izidi ega azaḡaꞌe veꞌoḡa rae roziꞌuma. Mazaḡa ibite madaḡano Siba habaꞌa kini roḡaeḡaniꞌa haba ḡonaga faḡa huneonoꞌo kini Solomona zamarone huhuzaḡa abitoga veize onamiro. U izidi Solomona vitinoga vazeḡaꞌe ꞌahi eꞌe, rehano ze ani ḡoere abitoga mene urateꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Vine sauꞌa ꞌahoganiꞌa vaze ꞌahoga mazaonoꞌo buauꞌetene, ahiꞌa ohonoga radu vu oꞌoꞌa habaꞌa vaḡe ragaveꞌohe. Rehano mene horonadu, ");
INSERT INTO ksj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ꞌahige raꞌohe, 'E eḡeꞌa vaḡinateꞌe vazeḡa vaḡe bare onamihi.' Ebu ani baradu vaze eꞌe horoneꞌetene, aniꞌe neḡa bohaꞌa, deheḡa hune zu idaidane touga heuḡa. ");
INSERT INTO ksj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ebu vine sauꞌa eꞌeꞌa onamadu vine sauꞌa niduꞌa fuꞌo aheu fare, ufeta hune sauꞌa zamaze areꞌohe ebu ze vaze eꞌe zamao diuḡe radiuꞌohe. ꞌOugadu vaze eꞌeꞌa ibiꞌa vitine ufeta sautuꞌohe. Eꞌeguḡaꞌe izidi ega sauꞌa mazao fureraꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iesuꞌa ꞌize vaze ḡuḡuvaḡa ḡoreziroteꞌe zamaḡano viꞌa zu negoḡa duḡuruꞌa feuradu ani teite ḡoeroga veize enona edaro. ");
INSERT INTO ksj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ebu vaze ꞌahoganiꞌa Iesu niro, “Viꞌu zu negoḡo duḡuruꞌa ḡae teite ḡoerihi radu enona edau radiuꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Aniꞌa naenaeniro, “Iniuꞌe eḡe nanu? Iniuꞌe eḡe nego duḡuru?” ");
INSERT INTO ksj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ebu aniꞌa ane tahiꞌatahiꞌa surizeꞌenaꞌa, ꞌahige rae reiro, “Eḡe nanu zu eḡe nego duḡuruꞌe ꞌahi eꞌe. ");
INSERT INTO ksj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Iniuꞌa eḡe Mama adureo ura haḡaeꞌeteꞌe vazeḡaꞌe eḡe nego, eze ebu nanu.” ");
INSERT INTO ksj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Eꞌe madaḡano Iesuꞌa neonoꞌo iḡunadu duꞌura genaḡano ehoriro. ");
INSERT INTO ksj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Vaze ḡuḡuvaḡaniꞌa ani babaḡano nuꞌorarotene, aniꞌe ḡasio tiradu ehoriro ebu vaze niduꞌaꞌe duꞌura genaḡano edaro. ");
INSERT INTO ksj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ebu Iesuꞌa hari idaidaḡa hina ḡau ḡehaḡa ihoziro, “Egoꞌi. Hihi vazeḡa ꞌahoganiꞌa mebaḡano ezone ḡora onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ani ezone feune ḡorarotene, nuꞌe ibio rururaro ebu nini'a aradu au hauḡiro. ");
INSERT INTO ksj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ezone nuꞌe hadi habaꞌano rururaro ebu rahaḡaꞌe mene baruḡa. Rahaḡaꞌe mene baruḡa radu ezoneꞌe ḡarihe ḡuhuriro. ");
INSERT INTO ksj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Rehano madaꞌa hiarotene, ane gigiꞌaḡaniꞌa ḡuhuḡa manadu roraro, mazaḡa taiga oꞌoꞌa. ");
INSERT INTO ksj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ezone nuꞌe ve renogano rururaro. Ebu ve renoganiꞌa ḡuhure bororanadu ezone ḡuhuḡa simariniro. ");
INSERT INTO ksj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","U ezone nuꞌe raha manoḡano rururanadu faine ḡuhure bororaro. ꞌOugadu nuꞌe huga ḡae 100, nuꞌe huga ḡae 60 ebu nuꞌe huga ḡae 30 hudaro. ");
INSERT INTO ksj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Teḡaḡeta vazeḡaꞌe faifaine egadu huga ederoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ebu Iesu tahiꞌatahiꞌaꞌa ane vaḡe aradu ḡadiniro, “Ḡa nougadu vaze mazaoꞌe hari idaidaḡa hina ḡoereꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ebu Iesuꞌa naenaeziro, “Badiꞌaꞌa zuhiꞌaziꞌeteꞌe moneo ꞌuꞌuru tirotaꞌaꞌe zae mazao fureniro, rehano vaze nunu mazaoꞌe mene fureniro. ");
INSERT INTO ksj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Faifaine zamare igiꞌeteꞌe azaḡaꞌe Badiꞌaꞌa edeḡa boro zenadu ze edeḡaꞌe ufeta bororaꞌuma. U mene faine zamare igiꞌeteꞌe azaḡaꞌe ze edeḡa zuni mae vaḡiniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Eꞌanoꞌo eḡeꞌa hari idaidaḡa hina ze ḡorezeꞌohe. Buka zaḡoḡano ꞌahige rae reiro, 'Zeꞌe horoneꞌe rehano, hugaꞌe mene horoneꞌohe. Zeꞌe igiꞌe rehano, hugaꞌe mene igiꞌohe ga mene edereꞌohe.' ");
INSERT INTO ksj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ꞌOugadu Badiꞌaꞌa peroveta vazeḡa Isaiaonoꞌo rae fureniroteꞌe ḡoeꞌaniꞌa zeḡe mazao hugano fureraro, 'Zeꞌe igiꞌe rehano, hugaꞌe mene ederiꞌuma. Zeꞌe horoneꞌe rehano, hugaꞌe mene horoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ꞌAhi duḡuru zamaꞌe tuḡa, teḡazeꞌe uhuḡa zu ubumazeꞌe kuruḡa. Ze mene ꞌougifone, ubumaze hina horonifo, teḡaze hina igifo zu zamazeo ederifo. Ebu ḡihuradu eḡeꞌa ze faizifo.' ");
INSERT INTO ksj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Rehano zaꞌe matuꞌeꞌohe, mazaḡa naginiꞌa fureruꞌeteꞌe ubumaze hina horoneꞌohe zu teḡaze hina igiꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Eḡeꞌa hube hune ziꞌohe, peroveta azaḡa zu duduḡa azaḡa ḡehaḡaniꞌa zaeꞌa izidi nagini horoneꞌeteꞌe horonihi rae reiro, rehano mene horoniro, ebu zaeꞌa izidi nagini igiꞌeteꞌe igihi rae reiro, rehano mene igiro.” ");
INSERT INTO ksj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ezone feune ḡorauꞌeteꞌe hariḡa idaidaḡa huga egoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Vaze nuꞌe ibio rururaroteꞌe ezoga heuḡa. Zeꞌe Badiꞌaꞌa zuhiꞌaziꞌeteꞌe ḡoeꞌa igiꞌe rehano, huga mene edereꞌeteꞌe uꞌano Sataniꞌa aradu zamazeo ḡoraroteꞌe ḡoeꞌa mae vaḡineꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Vaze nuꞌe hadi habaꞌano rururaroteꞌe ezoga heuḡa. Zeꞌe Badiꞌa ḡoere igiꞌetene matuꞌeꞌenaꞌa, zogone mae ḡihineꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Rehano zeꞌa fieꞌetaꞌaꞌe taiga oꞌoꞌa radu mada tahiḡa daꞌo fieꞌohe. Ebu Badiꞌa ḡoere mae ḡihineꞌeteꞌe uꞌano, aduga zu sauꞌa hideꞌetene, zogone uiteꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Vaze nuꞌe ve renogano rururaroteꞌe ezoga heuḡa. Zeꞌe Badiꞌa ḡoere igiꞌe rehano, ḡaboneze zamaḡano zamaze aduga borofeꞌohe zu haba toheḡa barebare mouga veize ufeta zamareꞌohe. ꞌUguḡaniꞌa Badiꞌa ḡoere ꞌuadu zeꞌe mene iniꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","U vaze nuꞌe raha manoḡano rururaroteꞌe ezoga heuḡa. Zeꞌa Badiꞌa ḡoere igiꞌohe zu eꞌe huga edereꞌohe. Ebu ḡae 100, ḡae 60 ga ḡae 30 hudauꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iesu'a hari idaidaḡa ꞌahoga ziro, “Badiꞌaꞌa zuhiꞌaziꞌetaꞌaꞌe vaze ꞌahoganiꞌa ani mebao ezone manoḡa ḡoraroteꞌe heuḡa. ");
INSERT INTO ksj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Rehano vaze niduꞌa bazeꞌeteꞌe zamaḡano ane agire vazeḡaniꞌa aradu vuidi boꞌaḡano ve ḡoraro ebu vaḡiniro. ");
INSERT INTO ksj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Vuidiꞌa ḡuhuradu maḡa haḡairotene ve zuni ḡuhuriro. ");
INSERT INTO ksj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Eꞌanoꞌo meba vazeḡa tuḡure azaḡaniꞌa aradu niro, ꞌZuhiꞌa, ḡaꞌa ḡae mebao vuidi ezone manoḡa ḡoraro. Rehano ve aꞌe noumanoꞌo?' ");
INSERT INTO ksj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Aneꞌa naenaeziro, 'Agire vazeḡa ꞌahoganiꞌa ꞌougiro.' Tuḡure azaḡaniꞌa ḡadiniro, 'Ḡaꞌe emeꞌa onamadu ve eꞌe ḡoroga urateꞌehe?' ");
INSERT INTO ksj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Aneꞌa naenaeziro, 'Mene, zaꞌa ve ḡurine vuidi zuni ḡuriꞌuma gaogi. ");
INSERT INTO ksj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Aheuꞌa tibano ḡuhuroga modoꞌi, onamo hiriviteꞌe madaḡa meꞌuma. Hiriveꞌeteꞌe madaḡano eḡeꞌa hiriveꞌeteꞌe azaḡa zeadu zeꞌa ibite geno ve ḡoraꞌuma ebu tibano utadu hufiꞌuma. Hena vuidiꞌe tibano nuꞌonadu eḡe suabao zounoꞌi.'” ");
INSERT INTO ksj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Aniꞌa hari idaidaḡa ꞌahoga ziro, “Badiꞌaꞌa zuhiꞌaziꞌetaꞌaꞌe Kuava maḡa tiba vaze ꞌahoganiꞌa madu mebaḡano ḡoraroteꞌe heuḡa. ");
INSERT INTO ksj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","kuava maḡaꞌe maḡa niduꞌa boꞌaḡano komeꞌa fase, rehano ḡuhurine meba ḡauḡa niduꞌa boꞌaḡano ufeta bororanadu ire boro raꞌohe. Ebu hitagano nini'a rafiu aradu ezagano neze ogoruꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Aniꞌa hari idaidaḡa ꞌahoga bare ziro, “Badiꞌaꞌa zuhiꞌazitaꞌaꞌe isiti heuḡa. Roḡae ꞌahoganiꞌa isiti tahiḡa madu ꞌuvahu ḡehaḡa teite mirune tibunirotene, ꞌuvahu niduꞌaꞌe ubaruꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesuꞌa hari idaidaḡa hina ḡoere niduꞌa vaze ḡuḡuvaḡa ziro. Aniꞌe hari idaidaḡa hina daꞌo vaze ḡoreziro. ");
INSERT INTO ksj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ꞌOugadu Badiꞌaꞌa peroveta vazeḡanonoꞌo reiroteꞌe ḡoeꞌaniꞌa hudaro, “Eḡeꞌa ḡorezine, hari idaidaḡa hina ziꞌuma. Raha ꞌadi haḡairoteꞌe madaḡanonoꞌo onao izidi ꞌuꞌuru tirotaꞌaꞌe eḡeꞌa rae fureniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ebu aniꞌa vaze ḡuḡuvaḡa muhizadu ne zamaḡa diuḡiro. Ane tahiꞌatahiꞌaꞌa hegote diuḡadu niro, “Mebao ḡoraroteꞌe ve hari idaidaḡa huga ihofoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Aneꞌa naenaeziro, “Ezone manoḡa ḡoraroteꞌe vazeḡaꞌe Vaze Ubuga. ");
INSERT INTO ksj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mebaꞌe raha ꞌadi. Ezone manoḡaꞌe Badiꞌaꞌa zuhiꞌaziꞌeteꞌe azaḡa, u veꞌe Diabolo mone azaḡa. ");
INSERT INTO ksj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ve ḡoraroteꞌe agire vazeḡaꞌe Diabolo. Hiriveꞌeteꞌe madaḡaꞌe mada ḡonaga, ebu hiriveꞌeteꞌe azaḡaꞌe tuḡure vigaviga. ");
INSERT INTO ksj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mada ḡonagaꞌe ve niduꞌa nuꞌonadu ire rogao hufi haoneꞌeteꞌe teigiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Vaze Ubuganiꞌa ane tuḡure vigaviga tuḡuziꞌuma, ebu zeꞌe Badiꞌaꞌa zuhiꞌaziꞌeteꞌe azaḡa mazaonoꞌo vaze ibi sauꞌano tutuzeꞌeteꞌe azaḡa niduꞌa zu haḡai sauꞌa azaḡa niduꞌa rovoze nuꞌoziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ebu zeḡe niduꞌaꞌe ire roga gigiꞌaḡano mae feuzadu ze eꞌea niaꞌuma zu ḡononeze atitiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ebu duduḡa azaḡaꞌe Mozeꞌa ibitoziꞌeteꞌe zamaḡano mada teige hiaꞌuma. Teḡaḡeta vazeḡaꞌe faifaine egadu huga ederoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Badiꞌaꞌa zuhiꞌaziꞌetaꞌaꞌe mebao ꞌuꞌuru tiroteꞌe ḡauḡa naeḡa boroboro heuḡa. Vaze ꞌahoganiꞌa horonirotene bare uꞌuranadu matuꞌuḡeta ne onamiro. Ebu ane ḡau niduꞌa seronadu meba eꞌe hoitiro. ");
INSERT INTO ksj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ebu Badiꞌaꞌa zuhiꞌaziꞌetaꞌaꞌe hadi naeḡa boroboro vaḡeꞌeteꞌe sero vazeḡa heuḡa. ");
INSERT INTO ksj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Aniꞌa hadi naeḡa boro tiba horonirotene, ne onamadu ane ḡau niduꞌa seronadu eꞌe hoitiro.” ");
INSERT INTO ksj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ebu Badiꞌaꞌa zuhiꞌaziꞌetaꞌaꞌe reꞌeva heuḡa. Davarao reꞌeva feunadu ḡozone nunu niduꞌa oḡaro. ");
INSERT INTO ksj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Reꞌevaꞌa iri'avirotene, vazeꞌa mae hesao rehaniro, ebu zeꞌa ehoradu ḡozone manoḡaꞌe inahe tunahuo mae ufiro, ebu ḡozone sauꞌaꞌe mae modiro. ");
INSERT INTO ksj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mada ḡonaga zuni ꞌahiguḡa reꞌuma. Tuḡure vigaviganiꞌa aradu duduḡa azaḡa mazaonoꞌo sauꞌa azaḡa mae rovoziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ebu ze ire roga gigiꞌaḡano mae feuzadu eꞌea niaꞌuma zu ḡononeze atitiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ebu Iesuꞌa ḡadiziro, “Zaꞌe eḡe ḡoere huga niduꞌa ederahe?” Zeꞌa naenaeniro, “Oꞌe.” ");
INSERT INTO ksj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Aniꞌa ziro, “Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa niduꞌaꞌe Badiꞌaꞌa zuhiꞌaziꞌeteꞌe moneo ederifone, zeꞌe ne vazeḡa heuḡa reifo. Ne vazeḡaꞌe ane godoḡo neḡanonoꞌo ḡau iziga zu ḡau amahiḡa mae buneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iesuꞌa hari idaidaḡa eꞌeguḡa hauḡirotene, eꞌeanoꞌo vaḡiniro. ");
INSERT INTO ksj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Iesuꞌa ane haba, Nazareta neḡa onamadu Iuda azaḡa nuꞌonuꞌo neḡano ihoze ḡadahiro. Ze ani ḡoere egadu zaguzagaro ebu ḡadimutitiro, “Vaze ꞌadiꞌe noumanoꞌo zamarone huhuzaḡa zu haḡai gigiꞌa inaraḡa ꞌahi meiro? ");
INSERT INTO ksj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Vaze ꞌahiꞌe ne ogoruꞌeteꞌe vazeḡa ubuga, oꞌehe? Ani viꞌaꞌe Maria, ani negoḡa duḡuruꞌe Iakobo, Iosefa, Simona zu Iuda. ");
INSERT INTO ksj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ani ezeḡa niduꞌaꞌe ꞌaha emeḡe teite radiuꞌohe. Aniꞌa ꞌahiguḡa niduꞌa nouma meiro?” ");
INSERT INTO ksj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ebu zeꞌa ani hezahoharo. ꞌOugadu Iesuꞌa ziro, “Peroveta vazeḡaꞌe haba nunu zamaḡano vazeꞌa gubaneꞌohe, rehano ane haba azaḡa zu ane ne azaḡaniꞌa daꞌo mene gubaneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ebu aniꞌe eꞌe neḡano haḡai gigiꞌa ḡehaḡa mene haḡairo, mazaḡa zeꞌa ani mazao mene firo. ");
INSERT INTO ksj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Eꞌe madaḡano Galilea habaꞌa kiniḡa, Herodaꞌa Iesu hariḡa igiro. ");
INSERT INTO ksj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ebu aniꞌa ane gau azaḡa ziro, “Iesuꞌe Ioane Babatiso. Aneꞌa rune azaḡa boꞌaḡano bare ḡabodeha. ꞌOugadu aneꞌa haḡai gigiꞌa inaraḡa hina gaueꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ibite Herodaꞌa negoḡa Filipi inuga, niḡa Herodia uꞌano, Ioane obone teadu ḡuꞌa neḡano ohoniro. ");
INSERT INTO ksj_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Mazaḡa Ioaneꞌa Heroda mazao ꞌahige barebare niro, “Ḡaꞌa negoḡo inuga meirotaꞌaꞌe mene idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodaꞌa Ioane matihi reiro, rehano aniꞌe vaze ḡuḡuvaḡa rihoziro, mazaḡa zeꞌe Ioaneꞌe peroveta vazeḡa rae mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herodaꞌa fureraroteꞌe madaḡa meirotene, Heroda aboḡaniꞌa vaze ḡehaḡa zamao zavonadu Heroda zama ufeta matuꞌoharo. ");
INSERT INTO ksj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Eꞌanoꞌo Herodaꞌa ani teite ꞌahige ḡoitoradu ane ḡoere rinede tiro, “Ḡaeꞌa nagini umidine zuni, eḡeꞌa ḡaniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ebu aniꞌa viꞌa ḡoere egadu Heroda niro, “Ioane Babatiso vadiniꞌe siuva rana teadu izidi ꞌada enoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ꞌOugadu Heroda zamaḡaniꞌa adudaro. Rehano ani aneꞌa huziroteꞌe azaḡa zamao ane ḡoere rinede tiro ꞌahine, ani uti azaḡa mazao aboḡaniꞌa urateꞌeteꞌe ḡauḡa hanoꞌi rae ziro. ");
INSERT INTO ksj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Eꞌanoꞌo aniꞌa uti azaḡa tuḡuzadu ḡuꞌa neḡano Ioane Babatiso ꞌunu variꞌe riꞌiro. ");
INSERT INTO ksj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ebu vadigaꞌe siuva rana teadu odohe ariro ebu roḡae tahiꞌaḡa hanadu aneꞌa viꞌa haro. ");
INSERT INTO ksj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ebu Ioane tahiꞌatahiꞌaꞌa aradu ane ahiri meiro ebu guriro. Eꞌe enogano zeꞌe Iesu vaḡe onamadu Ioane rune hariḡa meꞌodoharo. ");
INSERT INTO ksj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iesuꞌa Ioane hariḡa igirotene, eꞌe habaꞌa modadu ḡasi hina vaze oꞌoꞌa habaꞌa sifu ruhau onamiro. Rehano vaze ḡuḡuvaḡaniꞌa eꞌe egadu nezeonoꞌo odao Iesu hegote onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iesuꞌa ḡasionoꞌo buanadu vaze ḡuḡuvaḡa horozirotene, vetuḡazeadu ugi azaḡa faiziro. ");
INSERT INTO ksj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ḡoravararotene, ane tahiꞌatahiꞌaꞌa Iesu vaḡe aradu niro, “ꞌAhiꞌe haba bohaꞌa ebu mada ꞌai zubureha. Eꞌanoꞌo vaze ḡuḡuvaḡa ꞌadi tuḡuze vaḡizoꞌi. ꞌOugine, ze neḡaneḡa onamadu ogomuze hoitiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Rehano aniꞌa naenaeziro, “Ze mene onamiꞌuma, rehano zaeꞌa ogomu nu zenoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Zeꞌa niro, “Eme mazaoꞌe ꞌuvahu odoga fuꞌo zu ḡozone aheu daꞌo.” ");
INSERT INTO ksj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Aniꞌa ziro, “Eḡe vaḡe mae aroꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ebu aniꞌa vaze ḡuḡuvaḡa ve rana ehoroga radu ane tahiꞌatahiꞌa ziro. Ebu aniꞌa ꞌuvahu odoga fuꞌo zu ḡozone aheu madu adure ite ḡianeꞌenaꞌa, Badiꞌa mazao manoḡa tauḡi reiro. Ebu vahege tahitahadu ane tahiꞌatahiꞌa ziniro, ebu zeḡeꞌa vaze niduꞌa ḡahugo ziniro. ");
INSERT INTO ksj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ꞌOugadu zeḡe niduꞌa au ubararo, ebu Iesu tahiꞌatahiꞌaꞌa ogomu ḡahaꞌaḡahaꞌaꞌe nuꞌonadu tunahu niduꞌa gaubanana aheu fare iriꞌavoniro. ");
INSERT INTO ksj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Eꞌea ogaroteꞌe azaḡa boꞌaḡano ohoze niduꞌa daꞌoꞌe 5,000, ebu roḡaeroḡae zu tahiꞌa komeꞌakomeꞌa ḡehaḡa zuni aro. ");
INSERT INTO ksj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Iesuꞌa zogone ane tahiꞌatahiꞌa tuḡuze ḡasio tiriro ebu ziro, “Eḡe vitihe duꞌura moneafa fare onamoꞌi.” U Iesuꞌe vaze ḡuḡuvaḡa tuḡuziro. ");
INSERT INTO ksj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Iesuꞌe vaze ḡuḡuvaḡa tuḡuze hauḡiroteꞌe enogano, ane daꞌo maḡa komeꞌa itadu kuraro. Ḡoravararotene, eꞌea ane daꞌo radiunu. ");
INSERT INTO ksj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Eꞌe madaḡano ḡasizeꞌe hesaonoꞌo fararo ebu zavara boroboroꞌa ariro ꞌahine, saꞌu boroꞌa ragatadu ḡasize ḡihuḡihuniro. ");
INSERT INTO ksj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Iraranae reirotene, Iesuꞌa vu rana ragaveꞌenaꞌa, ane tahiꞌatahiꞌa vaḡe onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ane tahiꞌatahiꞌaꞌe Iesuꞌa vu rana edau ariroteꞌe horonirotene, rihau rudanadu huau ḡaniḡanaro, “Aꞌe vine!” ");
INSERT INTO ksj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Rehano Iesuꞌa zogone ziro, “Zamaze rinedoꞌi! ꞌAdiꞌe eḡe. Ago rihanoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Peteroꞌa niro, “Zuhiꞌa Boro, a hube hune ḡa roꞌidene, eḡe zuni vu rana ḡae vaḡe amoga veize huhoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Iesuꞌa niro, “Aroꞌi.” Ebu Peteroꞌa ḡasionoꞌo buanadu vu rana Iesu vaḡe edau onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Rehano aniꞌa zavara boro horonirotene, rihanadu vu zamaḡa zubure ovoiro ebu ḡaniḡanaro, “Zuhiꞌa Boro, e ḡabohoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Iesuꞌa zogone ꞌevoꞌa ꞌeinadu ani abine ḡihiniro ebu niro, “Ḡaꞌe mene gigaru fieꞌeteꞌe vazeḡa! Nougadu ꞌadaꞌadeha?” ");
INSERT INTO ksj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Anianine ḡasio tirirotene, zavara ꞌai dauḡiro. ");
INSERT INTO ksj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ebu ḡasi zamaḡa azaḡaꞌe Iesu mazao kuraro ebu niro, “Hube hune ḡaꞌe Badiꞌa Ubuga.” ");
INSERT INTO ksj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Zeꞌa duꞌura faradu Genesareta habaꞌano hebetiro. ");
INSERT INTO ksj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Haba eꞌe azaḡaniꞌa Iesuꞌa ariroteꞌe ederadu ne uhiḡauhiḡa azaḡa niduꞌa veize ḡoere tuḡuriro. Ebu ze ugi azaḡa niduꞌa Iesu vaḡe tutuze ariro. ");
INSERT INTO ksj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ebu ugi azaḡaꞌe Iesu dabuaḡa ꞌariḡa tahiḡano daꞌo obonoga veize Iesu uminiro. ꞌOugadu oboniroteꞌe azaḡa niduꞌaꞌe ugizeꞌa manoriro. ");
INSERT INTO ksj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Eꞌe madaḡano Farisea azaḡa zu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa nuꞌa Ierusalemaonoꞌo Iesu vaḡe aradu ḡadiniro, ");
INSERT INTO ksj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ḡae tahiꞌatahiꞌaꞌe ꞌizema oganogano ꞌevoreze mene vuzuꞌeꞌohe. Nougadu zeꞌa emeḡe vouḡa haḡai variꞌeꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iesuꞌa naenaeziro, “Zaꞌe nougadu vouḡaze haḡai hegotoga veize Badiꞌa goro ḡoeꞌaꞌe variꞌeꞌohe? ");
INSERT INTO ksj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Badiꞌaꞌa ꞌahige rae reiro, 'Viꞌu mogo gubazoꞌi,' ebu 'Iniuꞌa ane viꞌa moga rae sausauzine, ani mau runiꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Rehano zaꞌe vize moze mazao ꞌahige raꞌohe, 'Fase, e zae danazoga mene idaḡa, mazaḡa eḡeꞌa danaziteꞌe ḡauḡa ꞌahiꞌe Badiꞌa hatiteꞌe ḡahunoneḡa raha.' Zaeꞌa ꞌouge radu, ");
INSERT INTO ksj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","vize moze mene gubazoga zuni idaḡa raꞌohe. Zaeꞌa vouḡaze haḡai hegotoga veize, Badiꞌa goro ḡoeꞌa mae vaḡineꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Zaꞌe zama guhi azaḡa! Peroveta vazeḡa Isaiaꞌa zae moneo Badiꞌa ḡoere rae furenirotaꞌaꞌe duduḡa, ");
INSERT INTO ksj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","'Vaze ꞌahiguḡaꞌe hebeze hina eḡe gubaheꞌohe, rehano zamazeꞌe eḡe mazaonoꞌo faḡa hune. ");
INSERT INTO ksj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Zeḡeꞌa Badiꞌa mazao kurauꞌetaꞌaꞌe huga oꞌoꞌa. Zeꞌe vazeꞌa tiroteꞌe goro ḡoeꞌa ihozeꞌohe.'” ");
INSERT INTO ksj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iesuꞌa vaze ḡuḡuvaḡa ane vaḡe huze onamadu ziro, “Eḡe ḡoere egadu huga ederoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Hebeo diuḡeꞌeteꞌe ḡauḡaꞌe vaze mene toratoraneꞌohe. Rehano hebeonoꞌo buauꞌeteꞌe ḡauḡaniꞌa vaze toratoraneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ebu Iesu tahiꞌatahiꞌaꞌa ane vaḡe aradu niro, “Ḡa Farisea azaḡaniꞌa ḡae ḡoere egadu maḡuneꞌetaꞌaꞌe edeḡahe?” ");
INSERT INTO ksj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Iesuꞌa naenaeziro, “Eḡe Mama adureo radiuꞌeteꞌeꞌa mene ḡoraroteꞌe ḡauḡa niduꞌaꞌe taiganonoꞌo ḡuri modiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ze mode tauḡoꞌi. Zeꞌe ubuma kuruḡa azaḡa rehano, ubuma kuruḡa azaḡa ibitoziꞌohe. Ubuma kuruḡa vazeḡaniꞌa ubuma kuruḡa vazeḡa ibitohaune, anianine hoꞌona uite ovoiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peteroꞌa niro, “Hari idaidaḡa eꞌe huga ihofoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Iesuꞌa ziro, “Zaꞌe ꞌize mene edeḡahe? ");
INSERT INTO ksj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ogomuꞌe vaze hebeonoꞌo diuḡadu isi zamaḡa ovoeꞌohe ebu vesuꞌu ahirionoꞌo buauꞌohe. Za eꞌe aḡuꞌahe? ");
INSERT INTO ksj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Rehano hebeonoꞌo buauꞌetaꞌaꞌe zamaonoꞌo buanadu vaze toratoraneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Vaze zamaonoꞌo buauꞌetaꞌaꞌe zamarone sauꞌa. Aꞌe gorugoru, ubuma ḡezo, daro fuꞌa, ḡonore, vaze moneo ḡurireꞌeteꞌe zu vaze rae sausauzeꞌeteꞌe raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Eꞌeguḡaniꞌa vaze toratoraneꞌohe. Rehano ꞌevore mene vuzuꞌadu ogomu auꞌeteꞌeꞌa vaze mene toraneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iesuꞌa Galilea habaꞌa modadu Turo zu Sidono habaꞌa onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ebu eꞌe habaꞌano Kanana roḡaeḡa ꞌahoganiꞌa ani vaḡe aradu ḡihau huniro, “Zuhiꞌa Boro, Davida mariga, eḡe vetuḡahoꞌi! Vine sauꞌaniꞌa eḡe aboe ragano radu ani ufeta aduga hideꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Rehano Iesuꞌa ḡoere ꞌahoga mene naenaeniro. Ebu ane tahiꞌatahiꞌaꞌa aradu uminiro, “Aniꞌa eme hegoteꞌenaꞌa, barebare huau ḡunuḡunufeꞌohe. Ani tuḡune vaḡinoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ꞌOugadu Iesuꞌa naenaeniro, “Isaraela azaḡa boꞌaḡano dauḡiroteꞌe mamoeḡa veize daꞌo eḡe tuḡuhiro.” ");
INSERT INTO ksj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Rehano roḡaeḡaniꞌa aradu ani zamao ḡuḡuriro, “Zuhiꞌa Boro, danahoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iesuꞌa naenaeniro, “Tahiꞌatahiꞌa ogomu madu ḡuni hanogaꞌe mene duduḡa.” ");
INSERT INTO ksj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Roḡaeḡaniꞌa niro, “A hube, Zuhiꞌa Boro. Rehano ḡuni zuni ane zuhiꞌa fataḡanonoꞌo buauꞌeteꞌe ogomuḡa mumuḡa auꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ꞌOugadu Iesuꞌa naenaeniro, “Roḡae, ḡaeꞌa eḡe mazao fieꞌetaꞌaꞌe boro hune! Ḡaeꞌa urateꞌeteꞌe hidiꞌuma.” Eꞌe madaḡano ani aboḡaniꞌa manoriro. ");
INSERT INTO ksj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iesuꞌa haba eꞌe modadu Galilea duꞌuraḡa onamiro. Ebu maḡa komeꞌa itadu eꞌea ehoriro. ");
INSERT INTO ksj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ꞌOugadu vaze ḡuḡuvaḡaniꞌa mene edauꞌeteꞌe azaḡa, ubuma kuruḡa azaḡa, oda sauꞌa azaḡa, mumutafa azaḡa zu ugi azaḡa nunu ḡehaḡa tutuze ane vaḡe ariro. Ebu zeꞌe ane oda babaḡano ugi azaḡa bazuze teadu aneꞌa faiziro. ");
INSERT INTO ksj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Vaze ḡuḡuvaḡaꞌe mumutafa azaḡaniꞌa ḡoereꞌeteꞌe, oda sauꞌa azaḡaniꞌa manorateꞌe, mene edauꞌeteꞌe azaḡaniꞌa ragaveꞌeteꞌe zu ubuma kuruḡa azaḡaniꞌa ehamuꞌeteꞌe horozirotene, zaguzagaro ebu Isaraela azaḡa Badiꞌaḡa niguniro. ");
INSERT INTO ksj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ebu Iesuꞌa ane tahiꞌatahiꞌa ane uhiḡano huze onamadu ziro, “Eꞌe ꞌahi duḡuru vetuḡaziꞌohe, mazaḡa ze ꞌaha mada uḡidu eḡe teite radiuꞌohe zu ogomuze oꞌoꞌa. Eꞌe ze vinini tare nezeo tuḡuzoga mene urateꞌohe, mazaḡa ze ibio higau bauriꞌuma gaogi.” ");
INSERT INTO ksj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ane tahiꞌatahiꞌaꞌa niro, “Haba bohaꞌano ꞌahi eme nouma ogomu ḡehaḡa horonadu vaze ḡuḡuvaḡa ꞌahi ḡubuziꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Iesuꞌa ḡadiziro, “Za mazao ꞌuvahu odogaꞌe nugu?” Zeꞌa naenaeniro, “ꞌUvahu odogaꞌe fuꞌo aheu fare zu ḡozone komeꞌaꞌe tahiḡa.” ");
INSERT INTO ksj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ebu aniꞌa vaze ḡuḡuvaḡa rahao ehoroga radu ziro. ");
INSERT INTO ksj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ebu hena ꞌuvahu odoga fuꞌo aheu fare zu ḡozone nu madu Badiꞌa mazao kuraro. Ebu vahegadu tahiꞌaḡa ziniro ebu zeꞌa vaze ḡuḡuvaḡa ḡahugiro. ");
INSERT INTO ksj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ꞌOugadu zeḡe niduꞌa au idararo. Ebu ane tahiꞌatahiꞌaꞌa ogomu ḡahaꞌaḡahaꞌa mae ofadu tunahu fuꞌo aheu fare iri'avoniro. ");
INSERT INTO ksj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ogaroteꞌe azaḡa boꞌaḡano ohoze daꞌo niduꞌaꞌe 4,000. Roḡaeroḡae zu tahiꞌa komeꞌakomeꞌaꞌe mene meꞌodiro. ");
INSERT INTO ksj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Iesuꞌa vaze ḡuḡuvaḡa tuḡuze vaḡiziroteꞌe ḡarugano ḡasio tiradu Magadana habaꞌa onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisea zu Sadukea azaḡaniꞌa Iesu tuhune nuroga veize ani vaḡe aradu niro, “Ḡaeꞌa Badiꞌa gigiꞌaḡa hina haḡai nu badeḡa haḡaeꞌeteꞌe ihofoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Aniꞌa naenaeziro, “Za ꞌahige raꞌohe, 'Ḡorava madaꞌa kanaru zuburine, ohoḡore mada manoḡa reꞌuma,' ");
INSERT INTO ksj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ebu 'Oherebau adureꞌa ḡutanoga horonine, iruguꞌa ruꞌaꞌuma.' Zaꞌe adure iraḡa horonadu naginiꞌa fureratitaꞌaꞌe edereꞌohe. Rehano izidi madaḡano naginiꞌa fureru radiuꞌeteꞌe moneo hugaꞌe aḡuꞌa. ");
INSERT INTO ksj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Sauꞌa zu ubuma ḡezo azaḡaꞌe haḡai nu badeḡa vaḡeꞌohe. Rehano Iona mazao fureraroteꞌe haḡai nu badeḡa daꞌo ihoziꞌuma.” Ebu aneꞌa ze muhize onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Iesu tahiꞌatahiꞌaꞌe duꞌura moneafa farirotene ꞌuvahu odoga mae odohoga aḡutaro. ");
INSERT INTO ksj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Iesuꞌa ziro, “Farisea zu Sadukea azaḡa ḡiazoꞌi, mazaḡa zeꞌe isiti heuḡa.” ");
INSERT INTO ksj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ꞌOugadu ze zeḡeꞌa bare ḡadimutitiro, “Emeꞌa ꞌuvahu odoga mene mae aradu ani ꞌouge raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Iesuꞌa ze nagini reirotaꞌaꞌe ederadu ziro, “Zaꞌa Badiꞌa mazao fieꞌetaꞌaꞌe komeꞌa! Nougadu zae mazao ꞌuvahu odoga oꞌoꞌa radu ḡadimutiteꞌohe? ");
INSERT INTO ksj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Zaꞌe ꞌize mene edeḡahe? Eḡeꞌa ꞌuvahu odoga fuꞌo hina vaze 5,000 ḡubuzirotaꞌaꞌe mene zamareꞌehe? Ogomu ḡahaꞌaḡahaꞌaꞌe tunahu nugu iriꞌavoniro? ");
INSERT INTO ksj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ebu ꞌuvahu odoga fuꞌo aheu fare hina vaze 4,000 ḡubuzirotaꞌaꞌe mene zamareꞌehe? Ogomu ḡahaꞌaḡahaꞌaꞌe tunahu nugu iriꞌavoniro? ");
INSERT INTO ksj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Eḡeꞌa ꞌuvahu odoga moneo mene zeataꞌaꞌe nougadu zaꞌe mene edereꞌohe? Farisea zu Sadukea azaḡa isiti ḡianoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ꞌOuge reirotene, zeꞌe ederiro, aniꞌe ꞌuvahu odoga isitiḡa moneo mene ziro, rehano Farisea zu Sadukea azaḡa ihoreḡa ḡianoga veize ziro. ");
INSERT INTO ksj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iesuꞌa Kaisarea Filipo habaꞌa onamirotene, ani ane tahiꞌatahiꞌa ḡadiziro, “Vazeꞌa Vaze Ubugaꞌe iniu rae raꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Zeḡeꞌa naenaeniro, “Nuꞌe Ioane babatiso, nuꞌe Elia ebu nuꞌe Ieremia ga amahi peroveta vazeḡa ꞌahoga rae raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ebu Iesuꞌa ḡadiziro, “U zaꞌe eꞌe iniu rae raꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simona Peteroꞌa naenaeniro, “Ḡaꞌe Keriso, ḡabode radiuꞌeteꞌe Badiꞌa Ubuga.” ");
INSERT INTO ksj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Iesuꞌa naenaeniro, “Iona ubuga Simona, matuꞌoꞌi, mazaḡa vazeꞌa ḡae mazao ꞌadi mene ihoꞌeha, rehano adureo eḡe Mamaꞌa ihoꞌeha. ");
INSERT INTO ksj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Eḡeꞌa ḡaꞌohe, ḡaꞌe Petero, hugaꞌe vatava. Eḡeꞌa vatava eꞌe rana ekalesia ohoziꞌuma ebu rune gigiꞌaniꞌa ze mene raharahaziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","E Badiꞌaꞌa zuhiꞌaziꞌeteꞌe zamaḡano diuḡeꞌeteꞌe ibihetaḡa kiḡa ḡaniꞌuma. Eꞌanoꞌo ḡaꞌe nagini rahao gararine, Badiꞌaꞌa adureo zuni garariꞌuma, ebu ḡaꞌa nagini rahao ahetine, Badiꞌaꞌa adureo zuni ahetiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ebu Iesuꞌa ḡoere riḡa ziro, “Eꞌe Keriso rae vazeni ꞌahoga ago noꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Eꞌe madaḡano onamo, Iesuꞌa ane rune moneo ane tahiꞌatahiꞌa ḡadahe ihoziro, “Eḡeꞌa Ierusalema oname huniꞌuma, ebu vaze boroboro, dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa mazaonoꞌo aduga ḡehaḡa hidiꞌuma. Zeꞌa uḡuhiꞌuma, rehano eḡeꞌa mada uḡiduḡano bare ḡabodiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ebu Peteroꞌa Iesu ane genaḡano zamahu onamadu ḡadahe roniro, “Mene, Zuhiꞌa Boro! ꞌUguḡaniꞌa ḡae mazao mene hune fureraꞌuma!” ");
INSERT INTO ksj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Rehano Iesuꞌa tehadu Petero niro, “Satani, eḡe mazaonoꞌo vaḡinoꞌi! Ḡaꞌe hadi feꞌoḡa teige eḡeꞌa uitoga veize ḡoereꞌohe, mazaḡa zamaroneḡoꞌe mene Badiꞌa mazaonoꞌo, rehano vaze mazaonoꞌo areha.” ");
INSERT INTO ksj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ebu hena Iesuꞌa ane tahiꞌatahiꞌa ziro, “Iniuꞌa eḡe ḡaruna hegotihi rae roꞌidene, ani ura niduꞌa modadu ane satauro odoheꞌenaꞌa, eḡe hegotoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mazaḡa iniu ane ḡabone obone giganine, ḡabone tuḡutuḡu mene hidiꞌuma. Rehano iniu ane ḡabone eḡe veize ahetine, ḡabone tuḡutuḡu hidiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Vaze ꞌahoganiꞌa haba niduꞌa meiroteꞌe ḡarugano ḡaboneḡa daunine, nagi manoḡa hidiꞌuma? Ḡau ꞌahoga hanadu ḡaboneḡa bare mouga idaḡahe? ");
INSERT INTO ksj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Vaze Ubuganiꞌa Moga agaḡa zamaḡano tuḡure viga niduꞌa teite ariꞌuma, ebu hena vazeꞌa nagini haḡairoteꞌe idunaḡano aneane naeḡa ziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Eḡeꞌa hube hune ziꞌohe, izidi ꞌada edau radiuꞌeteꞌe azaḡa boꞌaḡano vaze nuꞌe mene rudaꞌuma, onamo Vaze Ubuganiꞌa aradu zuhiꞌaziꞌeteꞌe horoniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mada fuꞌo tiba fare ḡarugano Iesuꞌa Petero, Iakobo zu Iakobo negoḡa Ioane zamazadu zeḡe daꞌo maḡa boro itiro. ");
INSERT INTO ksj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Eꞌea ani iraḡaniꞌa zeḡe ubumao nufiro. Iraḡaniꞌa mada teige agararo ebu dabuaḡaniꞌa agaḡa teige ꞌuraro. ");
INSERT INTO ksj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Eꞌe madaḡano zeḡe zamao Mose zu Eliaꞌa fureranadu Iesu teite ḡoeriro. ");
INSERT INTO ksj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ebu Peteroꞌa Iesu niro, “Zuhiꞌa Boro, eme ꞌaha radiuꞌetaꞌaꞌe manoḡa. Ḡa uratine e taruha uḡidu ogoraꞌuma. Tibaꞌe ḡae veize, tibaꞌe Mose veize ebu tibaꞌe Elia veize ogoraꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Aniꞌa ꞌize ḡoereꞌeteꞌea, ḡoze vazavazahoganiꞌa ovadu ze ogoziro. Ebu ḡozeonoꞌo ago ꞌahoganiꞌa ziro, “ꞌAhiꞌe eḡe zamarone Ubude. Ani uꞌano, e matuꞌe rudauꞌohe. Zaꞌe ani ḡoere egohanoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Iesu tahiꞌatahiꞌaꞌa ago eꞌe igirotene, rihau rudanadu rahao ḡuḡuriro. ");
INSERT INTO ksj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Rehano Iesuꞌa aradu oboziro ebu ziro, “Iḡunoꞌi. Ago rihanoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Zeḡeꞌa dude ehamarotene, vaze ꞌahoga mene horoniro, rehano Iesu daꞌo horoniro. ");
INSERT INTO ksj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ze maḡanonoꞌo ovairoteꞌea, Iesuꞌa riḡa ziro, “Zaeꞌa horonataꞌaꞌe vaze ꞌahoga ago noꞌi, onamo Vaze Ubuganiꞌa runeonoꞌo bare ḡabode iḡuniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ane tahiꞌatahiꞌaꞌa ḡadiniro, “Nougadu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡaniꞌa, ꞌKerisoꞌa ꞌizema arogano Eliaꞌa ibite ariꞌuma,' rae raꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Iesuꞌa naenaeziro, “Hube hune Eliaꞌa aradu ḡau niduꞌa ruhibiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Eḡeꞌa ziꞌohe, Elia ꞌai amahi ariro. Rehano vazeꞌa ani mene ederadu ani mazao zeḡeꞌa uratiroteꞌe haḡaiḡa haḡairo. Eꞌe teige, Vaze Ubuga zuni zeḡe mazaonoꞌo aduga hidiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ꞌOuge reirotene, ane tahiꞌatahiꞌaꞌe Iesuꞌa Ioane Babatisoꞌe Elia rae reirotaꞌaꞌe ederiro. ");
INSERT INTO ksj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Iesu zu ane tahiꞌa uḡiduꞌa maḡanonoꞌo vaze ḡuḡuvaḡa vaḡe ovairotene, vaze ꞌahoganiꞌa Iesu vaḡe aradu ane zamao obenaḡa hina tuḡiro ebu niro, ");
INSERT INTO ksj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Zuhiꞌa Boro, eḡe ubude vetuḡanoꞌi. Aniꞌe ketoketeꞌohe ebu ahiꞌaꞌe gigiꞌa boro maꞌohe. Aniꞌe ḡae ḡehaḡa ire rogao ga vuo higauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Eꞌa ani tutune ḡae tahiꞌatahiꞌa vaḡe areha, rehano zeꞌe ani manonoga mene idaraneha.” ");
INSERT INTO ksj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Iesuꞌa eꞌea radiuꞌeteꞌe azaḡa ziro, “Zaꞌe Badiꞌa mazao mene fiꞌeꞌeteꞌe zu veꞌoḡa haḡaeꞌeteꞌe azaḡa! E zae teite noꞌe faḡa radiꞌuma? E noꞌe faḡa zae mazao zamahe obone tiꞌuma? Tahiꞌa komeꞌa eꞌe eḡe vaḡe tutune aroꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ebu Iesuꞌa vine sauꞌa ronadu vine sauꞌaniꞌa tahiꞌa komeꞌa eꞌe mazaonoꞌo buaro. ꞌOugadu tahiꞌa komeꞌa eꞌeꞌa zogone manoriro. ");
INSERT INTO ksj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ebu ani tahiꞌatahiꞌaꞌa zeḡe daꞌo Iesu vaḡe aradu ḡadiniro, “Emeꞌa nougadu vine sauꞌa hegone bunoga mene idaraneha?” ");
INSERT INTO ksj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Aneꞌa naenaeziro, “Mazaḡa zaeꞌa fieꞌetaꞌaꞌe tahiḡa fase. Eḡeꞌa hube hune ziꞌohe, zaꞌa eḡe mazao fieꞌetaꞌaꞌe fufu maḡa komeꞌa tiba heuḡa radu maḡa ꞌahi mazao ninaꞌa, 'ꞌAdanoꞌo vaḡinadu ꞌomo onamoꞌi,' rae reine, maḡa eꞌeꞌa ꞌouge haḡaiꞌuma. Zaeꞌa eḡe mazao fine, ḡau niduꞌa haḡaogaꞌe idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Zeꞌa Galilea habaꞌano nuꞌorarotene, Iesuꞌa ziro, “Vaze Ubugaꞌe agireḡa ꞌevoreo riꞌiniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Zeꞌa ani maꞌuma ebu aniꞌa mada uḡiduḡano bare ḡabodiꞌuma.” ꞌOugadu Iesu tahiꞌatahiꞌaꞌe zamaze are rudaro. ");
INSERT INTO ksj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Zeꞌa Kaperanaumao feurirotene, kuru neḡa takesi azaḡaniꞌa Petero vaḡe aradu ḡadiniro, “Zae ihore vazeḡaꞌe kuru neḡa takesi mene hauꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Aniꞌa naenaeniro, “Mene, aniꞌe takesiḡa hauꞌohe.” Peteroꞌa ne diuḡirotene, Iesuꞌa ibite ḡadiniro, “Petero, ḡa nouge rae zamareꞌohe? Haba kiniḡaꞌe iniu mazao takesi ufeꞌohe, ani haba azaḡa mazao ga avoꞌa azaḡa mazao?” ");
INSERT INTO ksj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Aniꞌa naenaeniro, “Avoꞌa azaḡa mazao ufeꞌohe.” Ebu Iesuꞌa niro, “Oꞌe, ani haba azaḡaꞌe takesi mene hauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Rehano emeꞌa takesi azaḡa mene maḡunozinifine takesi ziniꞌuma. Ḡaꞌe duꞌura ovoadu kimai feunoꞌi. Ebu ibite manateꞌe ḡozoneḡa hebeꞌa mae nahanine, siliva hadiḡa tiba horoniꞌuma. Eꞌe madu emenane veize zenoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Eꞌe madaḡano Iesu tahiꞌatahiꞌaꞌa Iesu vaḡe aradu ḡadiniro, “Badiꞌaꞌa zuhiꞌaziꞌeteꞌe zamaḡano iniuꞌe ḡihiꞌa hune?” ");
INSERT INTO ksj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iesuꞌa tahiꞌa komeꞌa ꞌahoga hunadu zeḡe boꞌaḡano mae ohoniro, ");
INSERT INTO ksj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ebu ziro, “Eḡeꞌa hube hune ziꞌohe, zaeꞌa ḡihuradu tahiꞌa komeꞌa ꞌahi mene teigine, Badiꞌaꞌa zuhiꞌaziꞌeteꞌe zamaḡano mene hune diuḡiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Iniu tahiꞌa komeꞌa ꞌadi teige aneꞌa bare ovoeꞌeteꞌe vazeḡaꞌe Badiꞌaꞌa zuhiꞌaziꞌeteꞌe zamaḡano ḡihiꞌa hune rae raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ebu iniu eḡe niḡano tahiꞌa komeꞌa ꞌahiguḡa mae ḡihineꞌeteꞌe vazeḡaꞌe eḡe mae ḡihiheꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Eḡe mazao fieꞌeteꞌe tahiꞌaḡa komeꞌakomeꞌa ꞌahiguḡa boꞌaḡano ꞌahoga zuni haḡai sauꞌano tutune veꞌoneꞌeteꞌe vazeḡaꞌe hadi horeḡa ꞌunuḡano autadu davara guniḡano mae feunineꞌe ufeta manoḡa. ");
INSERT INTO ksj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Vaze ibi sauꞌano tutuzeꞌeteꞌe ḡauḡaꞌe ḡehaḡa uꞌano, raha ꞌadi azaḡaniꞌa aduga boro hidiꞌuma. Eꞌeguḡaꞌe mada niduꞌa fureruꞌohe rehano, vaze haḡai sauꞌano tutuzeꞌeteꞌe vazeḡaꞌe aduga boro hidiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ꞌEvoꞌo naeḡa ga odaḡo naeḡaniꞌa haḡai sauꞌano tutuꞌe veꞌoꞌoꞌidene, variꞌe modoꞌi. ꞌEvo'o tiba ga odaḡo tiba hina ḡabone tuḡutuḡu hidogaꞌe ufeta manoḡa. Aꞌe ꞌevoꞌo aheu ga odaḡo aheu hina ire roga mene hauḡeꞌeteꞌe zamaḡano mae feuꞌoga vitineꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ubumaḡo naeḡaniꞌa haḡai sauꞌano tutuꞌe veꞌoꞌoꞌidene, ḡude modoꞌi. Ubumaḡo tiba hina ḡabone tuḡutuḡu hidogaꞌe ufeta manoḡa. Aꞌe ubumaḡo aheu hina ire roga radiu tuḡutuḡu zamaḡano mae feuꞌoga vitineꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Nize komeꞌa ꞌahiguḡa boꞌaḡano tiba zuni mene ovoe ḡianoga veize tohutohoꞌi. Eḡeꞌa ziꞌohe, zeḡe taufeꞌeteꞌe tuḡure vigavigaꞌe eḡe Mama adureo radiuꞌeteꞌe teite iḡaiḡa radiuꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Zaꞌe nouge rae zamareꞌohe? Vaze ꞌahoga mazao mamoeḡaꞌe 100. Rehano tibaniꞌa dauḡine, ani nougiꞌuma? Aniꞌe mamoeḡa 99 maḡa habaꞌano modadu mamoeḡa dauḡoga vaḡe ragaviꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Eḡeꞌa hube hune ziꞌohe, aneꞌa mamoe dauḡoga horone meine, mamoe tiba eꞌe uꞌano matuꞌe rudaꞌuma. Aniꞌe mamoe 99 mene dauḡoḡa ufeta vitize matuꞌiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Eꞌe teige, nize komeꞌa ꞌahiguḡa boꞌaḡano tiba zuni dauḡogaꞌe zae Moze adureo radiuꞌeteꞌeꞌa mene urateꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ekalesia boꞌaḡano negoḡo ꞌahoganiꞌa ḡae mazao haḡai sauꞌa haḡaoꞌidene, ane vaḡe onamadu ḡanine daꞌo radiuꞌenaꞌa haḡaiḡa sauꞌa ihonoꞌi. Aniꞌa egoḡanadu ḡihurine, ḡaꞌe nabugota bare tiburaneha. ");
INSERT INTO ksj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","U aniꞌa mene egoḡanoꞌidene, vaze tiba ga aheu zamazadu ane vaḡe bare onamoꞌi, mazaḡa ḡanine nagini raꞌetaꞌaꞌe vaze aheu ga uḡiduꞌa zuni ederiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aniꞌa zeḡe ḡoere mene egozenoꞌidene, ekalesia zamaḡano rae furenoꞌi. Aniꞌa ekalesia zuni mene egozenoꞌidene, aniꞌe Badiꞌa aḡuꞌa vazeḡa ga takesi vazeḡa sauꞌa heuḡa rae zamaroꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Eḡeꞌa hube hune ziꞌohe, zaeꞌa nagini rahao gararine, Badiꞌaꞌa adureo zuni garariꞌuma, ebu zaeꞌa nagini rahao ahetine, Badiꞌaꞌa adureo zuni ahetiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Eḡeꞌa bare hube hune ziꞌohe, rahao ꞌada zae boꞌaḡano vaze aheuꞌa zamaze tibano nagini umidine, eḡe Mama adureo radiuꞌeteꞌeꞌa zae umido haḡaoziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mazaḡa eḡe niḡano aheu ga uḡiduꞌa nuꞌoraune, eḡeꞌa zeḡe boꞌaḡano radiuꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ebu Peteroꞌa Iesu vaḡe aradu ḡadiniro, “Zuhiꞌa Boro, eḡe ekalesia negoḡaniꞌa eḡe mazao haḡai sauꞌa haḡaine, ḡae nugu eḡeꞌa haḡaiḡa sauꞌa rae modiꞌuma? Ḡae fuꞌo aheu fare ga?” ");
INSERT INTO ksj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iesuꞌa naenaeniro, “Eḡeꞌa ḡaꞌohe, mene ḡae fuꞌo aheu fare daꞌo, rehano barebare rae modoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Eꞌanoꞌo Badiꞌaꞌa zuhiꞌaziꞌetaꞌaꞌe hari idaidaḡa ꞌahi heuḡa. Kini ꞌahoganiꞌa ane mazaonoꞌo hadi meiroteꞌe tuḡure azaḡa huzadu ani hadi bare meihi rae reiro. ");
INSERT INTO ksj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ꞌOugirotene, hadi borofe meiroteꞌe vazeḡa ꞌahoganiꞌa ani vaḡe tutune ariro. ");
INSERT INTO ksj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Aniꞌe hadi baronoga mene idararo ꞌahine, kiniꞌa riḡa ḡoreniro, 'Ḡa ḡae bare, inugo, ubugo zu ḡae mazao ḡau niduꞌa seronadu eḡe hadi baronoꞌi!' ");
INSERT INTO ksj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ꞌOugadu tuḡure vazeḡaniꞌa ani zamao obenaḡa hina tuḡadu uminiro, 'Geno mada nu enoꞌi, ꞌougine e hadiḡo niduꞌa baroniꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ꞌOuge reirotene, zuhiꞌaḡaniꞌa vetuḡaniro ebu hadiḡa baronogaꞌe ahiḡa radu ani tuḡuniro. ");
INSERT INTO ksj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Eꞌe ḡarugano tuḡure vazeḡaniꞌa ani teite tiburu gaueꞌeteꞌe tuḡureḡa vazeḡa ꞌahoga hidiro. Tuḡure vazeḡa ꞌahoganiꞌa ani mazaonoꞌo hadi nu meiroteꞌe uꞌano, aneꞌa ani matanadu oḡorabiḡa harinoharo ebu riḡa niro, 'Eḡe hadi baronoꞌi!' ");
INSERT INTO ksj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ꞌOugirotene, ane vaze, tuḡure vazeḡaniꞌa obenaḡa hina tuḡadu uminiro, 'Geno mada nu enoꞌi, ꞌougine hadiḡo baroniꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Rehano aniꞌe ane vaze hezahoharo ebu onamadu ḡuꞌa neḡano mae ohoniro, onamo aniꞌa hadi eꞌe baroniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tuḡure azaḡa nuꞌa naginiꞌa fureraroteꞌe horonirotene, ze maḡune rudanadu zeḡe zuhiꞌa vaḡe onamiro ebu hariḡa niduꞌa ihoniro. ");
INSERT INTO ksj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ꞌOugadu zuhiꞌaḡaniꞌa tuḡure vazeḡa ibiꞌa hunadu niro, 'Ḡaꞌe tuḡure vazeḡa sauꞌa! Ḡaꞌa umihadu ḡa eḡe mazaonoꞌo meiroteꞌe hadiḡa niduꞌa baronogaꞌe eḡeꞌa ahiḡa rae reiro. ");
INSERT INTO ksj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Eḡeꞌa ḡae vetuḡaḡadateꞌe teige, ḡae zuni ḡae vaze, tuḡure vazeḡa eꞌe vetuḡanifo!' ");
INSERT INTO ksj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Zuhiꞌaḡaniꞌa zama ḡugiꞌano ani aduga hanoga veize ḡuꞌa neḡano ohoniro, onamo ane hadi niduꞌa barone hauḡiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Eꞌe teige, zaeꞌa zamaze niduꞌa hina zae nego nabudi haḡaize sauꞌa mene rae modine, eḡe Mama adureo zuni zae mazao ꞌouge haḡaiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesuꞌa eꞌe ḡoeꞌa hauḡirotene Galilea habaꞌa modadu Ioridana vuḡa moneafa Iudea habaꞌa onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Vaze ḡuḡuvaḡaniꞌa ani hegotiro ebu aniꞌa eꞌea ugi azaḡa faiziro. ");
INSERT INTO ksj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisea azaḡa nuꞌa Iesu tuhune nurifine ani vaḡe aradu ḡadiniro, “Ohoze ꞌahoganiꞌa inuga mazao mene matuꞌine, inuga modogaꞌe idaḡahe?” ");
INSERT INTO ksj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Aniꞌa naenaeziro, “Za Buka Zaḡoḡa mene meꞌodirohe? Ḡadaheḡano Badiꞌaꞌa vaze haḡairotene, ohoze zu roḡae haḡairo. ");
INSERT INTO ksj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ebu Badiꞌaꞌa ꞌahige rae reiro, 'Eꞌanoꞌo ohozeꞌe viꞌa moga modadu inuga teite tiburaꞌuma ebu anianine ahiri tiba reꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Eꞌe uꞌano, zeꞌe mene aheu, rehano ahiri tiba. Eꞌanoꞌo Badiꞌaꞌa tibuzirotaꞌaꞌe vazeꞌa mene rovoniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Zeꞌa ḡadiniro, “ꞌOugine, nougadu Moseꞌa ḡoere riḡa ꞌadi ziro, 'Ohozeꞌa inuga modoꞌidene, ihore soꞌaḡa mirihadu inuga hanoꞌi ebu ani modoꞌi.'” ");
INSERT INTO ksj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Iesuꞌa naenaeziro, “Zamaze riḡa ꞌahine, Moseꞌa inudeze modogaꞌe idaḡa rae reiro. Rehano ḡadaheḡanoꞌe mene idararo. ");
INSERT INTO ksj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Eḡeꞌa ziꞌohe, iniuꞌa inugaꞌe mene ubuma ḡezaro rehano, inuga modadu roḡae ꞌahoga teite hahurine, aniꞌe ubuma ḡezauꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Iesu tahiꞌatahiꞌaꞌa Iesu niro, “ꞌAhiguḡaniꞌa iꞌa inuga mazao fureraune, guruvorau radiuꞌetaꞌaꞌe ufeta manoḡa.” ");
INSERT INTO ksj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Iesuꞌa naenaeziro, “Vaze niduꞌa ḡoere ꞌahi mae ḡihinogaꞌe mene idaḡa. Rehano Badiꞌaꞌa danazeꞌeteꞌe azaḡa daꞌo idaḡa. ");
INSERT INTO ksj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Vaze nuꞌe fureraroteꞌe madaḡanonoꞌo ahiri ugiḡeta radu mene hahureꞌohe. Nuꞌe vazeꞌa ahiri ariro. Nuꞌe Badiꞌaꞌa zuhiꞌazoga veize gauihi radu zeḡeꞌa bare mene hahuriro. Iniuꞌa ꞌahi ḡoeꞌa mae ḡihinoga idaḡa roꞌidene, mae ḡihinoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Eꞌe madaḡano vaze nuꞌe tahiꞌa komeꞌakomeꞌa tutuze Iesu vaḡe ariro, mazaḡa aniꞌa ze rana ꞌevoꞌa teadu kuranoga uratiro. Rehano ane tahiꞌatahiꞌaꞌa tahiꞌa komeꞌakomeꞌa tutuze ariroteꞌe azaḡa roziro. ");
INSERT INTO ksj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ꞌOugirotene, Iesuꞌa ziro, “Tahiꞌa komeꞌakomeꞌa eḡe vaḡe tuḡuzoꞌi zu ze ago gararoꞌi. Mazaḡa Badiꞌaꞌa zuhiꞌaziꞌeteꞌe azaḡaꞌe tahiꞌa komeꞌakomeꞌa teigeꞌeteꞌe azaḡa.” ");
INSERT INTO ksj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ebu aniꞌa zeḡe rana ꞌevoꞌa teadu kuraroteꞌe ḡarugano eꞌea iḡune onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Vaze ꞌahoganiꞌa Iesu vaḡe aradu ḡadiniro, “Ihore vazeḡa, e nagi manoḡa haḡaine, ḡabone tuḡutuḡu hidiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Iesuꞌa naenaeniro, “Ḡaꞌe nougadu eḡe mazao naginiꞌe manoḡa rae ḡadimuꞌohe? Manoḡaꞌe Badiꞌa tibuhuga daꞌo. Ḡaꞌa ḡabone tuḡutuḡu hidihi roꞌidene, Badiꞌa goro ḡoeꞌa hegotoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Vaze eꞌeꞌa ḡadiniro, “Noꞌe goro ḡoeꞌa hegotiꞌuma?” Iesuꞌa naenaeniro, “'Vaze ago gorunoꞌi, ubuma ago ḡezanoꞌi, ago ḡonotanoꞌi, vaze moneo ago ḡuriroꞌi, ");
INSERT INTO ksj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","viꞌu mogo gubazoꞌi ebu ḡaeꞌa bare zamare borofeꞌeteꞌe teige nabugo zuni zamare borofoꞌi.'” ");
INSERT INTO ksj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tahiꞌa iziganiꞌa niro, “E goro ḡoeꞌa eꞌe niduꞌa hegote ariro. Hena nagini bare haḡaiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iesuꞌa niro, “Ḡaꞌe Badiꞌa ubumao veꞌoḡa oꞌoꞌa reihi roꞌidene, onamadu ḡauḡo niduꞌa seronoꞌi ebu zahara azaḡa zenoꞌi. ꞌOugine, ḡa adureo ḡau naeḡa boroboro hidiꞌuma. Ebu aradu eḡe hegotoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tahiꞌa iziganiꞌa Iesu ḡoere igirotene, zamaḡaniꞌa adudu bororuꞌenaꞌa iḡuniro, mazaḡa aniꞌe ufeta maꞌora vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Iesuꞌa ane tahiꞌatahiꞌa ziro, “Eḡeꞌa hube hune ziꞌohe, maꞌora vazeḡaꞌe Badiꞌaꞌa zuhiꞌaziꞌeteꞌe vazeḡa rougaꞌe riḡa bagaḡa. ");
INSERT INTO ksj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Eḡeꞌa bare ziꞌohe, kameroꞌa niduru hoꞌoga diuḡogaꞌe riḡa. Rehano maꞌora vazeḡaniꞌa Badiꞌaꞌa zuhiꞌaniꞌeteꞌe vazeḡano rougaꞌe ufeta riḡa.” ");
INSERT INTO ksj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Iesu tahiꞌatahiꞌaꞌa eꞌe igirotene, zaguzagau rudaro ebu ḡadiniro, “ꞌOugine, iniuꞌa ḡabone hidiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Iesuꞌa ḡiazadu ziro, “Vaze aneꞌa bare ḡabone hidogaꞌe mene idaḡa, rehano Badiꞌaꞌe ḡau niduꞌa haḡaoga idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ebu Peteroꞌa niro, “Eme emeḡe ḡau niduꞌa modadu ḡa hegotiro. ꞌOugadu emeꞌe nagini hidiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Iesuꞌa ziro, “Eḡeꞌa hube hune ziꞌohe. Raha ꞌahi niduꞌaꞌe bare izidatiteꞌe madaḡano Vaze Ubuganiꞌa kini ehoro habaꞌa ḡihiꞌaḡa hune rana ehorine, eḡe hegotiroteꞌe azaḡa, zae zuni kini ehoro habaꞌa gaubanana aheu fare rana ehoradu Isaraela azaḡa, urabo niduꞌa gaubanana aheu fare kotaziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ebu iniuꞌa eḡe uꞌano neḡa, negoḡa, ezeḡa, viꞌa, moga, tahiꞌaḡa ga ane haba modine, aniꞌe naeḡa ḡae 100 hidiꞌuma ebu Moga mazaonoꞌo ḡabone tuḡutuḡu hidiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Rehano vaze ibiꞌa ḡehaḡaꞌe ḡonaga reꞌuma, u vaze ḡonaga ḡehaḡaꞌe ibiꞌa reꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Iesuꞌa hari idaidaḡa ꞌahoga ziro, “Badiꞌaꞌa zuhiꞌaziꞌetaꞌaꞌe hari ꞌadi heuḡa. Haba vazeḡa ꞌahoganiꞌa ane vaini meba veize gaueꞌeteꞌe azaḡa vaḡihi radu oherebau uzeuze onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ebu aneꞌa vaze nu horozadu ziro, 'Eḡe meba onamadu gauoꞌi. Mada tiba gauḡa hadiḡa ziniꞌuma.' ꞌOugadu aniꞌa ze mebaḡano tuḡuze onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ebu oherebau mada fuꞌo ḡazaḡa fare meirotene ani bare onamiro. Ebu maketi habaꞌano mene gaueꞌeteꞌe azaḡa nuꞌe edau radiuꞌeteꞌe horoziro. ");
INSERT INTO ksj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ebu aniꞌa ziro, 'Za zu eḡe vaini mebaḡa onamoꞌi ebu gauḡa hadiḡa idane ziniꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ꞌOugadu ze ane meba onamiro. Aniꞌa madai zu mada uḡidu ḡoravaḡano bare onamadu ꞌouge haḡairo. ");
INSERT INTO ksj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mada fuꞌo ḡoravaḡano ani onamirotene, vaze nuꞌe edau ragaveꞌeteꞌe horozadu ḡadiziro, 'Za nougadu mada niduga mene gaueꞌenaꞌa edau tauḡeꞌohe?' ");
INSERT INTO ksj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Zeꞌa naenaeniro, 'Mazaḡa vazeni ꞌahoganiꞌa eme gau ꞌahoga mene refeha.' ꞌOugadu aneꞌa ziro, 'Zae zuni eḡe vaini mebaḡa onamadu gauoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Madaꞌa ovorirotene, vaini mebaḡa vazeḡaniꞌa meba taufeꞌeteꞌe vazeḡa niro, 'Gau azaḡa huzadu ḡonaga vazeḡanonoꞌo ibite vazeḡa gau hadiḡa zenoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mada fuꞌo ḡoravaḡano huziroteꞌe azaḡaniꞌa aradu aneane mada tiba gau hadiḡa meiro. ");
INSERT INTO ksj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ꞌOugadu ibite ariroteꞌe azaḡaꞌe ze hadi ufeta boro meꞌuma rae zamariro. Rehano zeḡe zuni aneane mada tiba gau hadiḡa idane meiro. ");
INSERT INTO ksj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Zeꞌa eꞌe hadiḡa madu haba vazeḡa mazao maḡuniro ebu tururuꞌenaꞌa niro, ");
INSERT INTO ksj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","'Ḡonagano arateꞌe azaḡaꞌe mada tahiḡa daꞌo gauꞌeha. U emeꞌa mada gigiꞌa zamaḡano mada niduga gau boro haḡaeha. Rehano ḡaꞌe zeḡe hadiꞌe emeḡe teite idane zeneha.' ");
INSERT INTO ksj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Haba vazeḡaniꞌa zeḡe boꞌaḡano ꞌahoga naenaeniro, 'Eḡe vaze, eꞌe mene nae daꞌo badareha. Ḡaꞌe eḡe teite ḡoere idane teadu mada tiba gau hadiḡa meꞌuma rae raha. ");
INSERT INTO ksj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Eꞌanoꞌo hadiḡo madu onamoꞌi. E ḡonagano arateꞌe vazeḡa gau hadiꞌe ḡae hadi teite idane hatihi raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Eḡeꞌa eḡe hadi hina eḡe edeḡano haḡaine, veꞌoḡahe? Eḡeꞌa vaze ufeta danazadu ḡaeꞌa ahiahiheꞌehe?'” ");
INSERT INTO ksj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ebu Iesuꞌa ziro, “Eꞌanoꞌo vaze ḡonagaꞌe ibiꞌa reꞌuma ebu vaze ibiꞌaꞌe ḡonaga reꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Iesuꞌa Ierusalema iteꞌeteꞌea, ane tahiꞌa gaubanana aheu fare ane uhiḡano huzadu ibio ziro, ");
INSERT INTO ksj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Eme Ierusalema iteꞌohe. Ebu Vaze Ubugaꞌe dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa ꞌevoreo riꞌiniꞌuma zu runeo tuḡuniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ebu Iuda mene azaḡa ꞌevoreo riꞌinadu zeꞌa ḡirihohaꞌuma, masiniꞌuma zu satauroniꞌuma. Rehano mada uḡiduḡano aneꞌa bare ḡabodiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Eꞌe madaḡano Zebedeo ubugaubuga, Iakobo zu Ioane, ze vizeꞌa zeḡe teite Iesu vaḡe aradu obena hina tuḡiro ebu ḡau ꞌahoga uminiro. ");
INSERT INTO ksj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Iesuꞌa ḡadiniro, “Ḡaꞌe nagini urateꞌohe?” Aniꞌa naenaeniro, “Ḡaeꞌa zuhiꞌaziꞌeteꞌe madaḡa moꞌidene, eḡe ubude aheu ohozadu tibaꞌe ḡae edaꞌe mone zu ꞌahogaꞌe ḡae kauri mone iḡuꞌa ḡihiꞌaḡano ehoroga urateꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Iesuꞌa ziro, “Za zaeꞌa nagini umiheꞌetaꞌaꞌe aḡuꞌa. Eḡeꞌa gagiteꞌe bioḡa aduga zaeꞌa gagoga idaḡahe?” Zeꞌa naenaeniro, “Oꞌe, eme idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Iesuꞌa ziro, “Hube hune eḡe bio zae zuni gagiꞌuma. Rehano eḡe edaꞌe mone zu kauri mone iḡuꞌa ḡihiꞌaḡaꞌe eḡeꞌa mene ziniꞌuma, rehano eḡe Mamaꞌa ohoziroteꞌe azaḡaniꞌa daꞌo iḡuꞌa eꞌe meꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Iesu tahiꞌa gaubananaꞌa eꞌe igirotene, Iakobo zu Ioane mazao maḡuniro. ");
INSERT INTO ksj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Rehano Iesuꞌa huze nuꞌozadu ziro, “Za edeḡa, Badiꞌa aḡuꞌa azaḡa habaꞌano zuhiꞌa niduꞌaꞌe zeḡe haba azaḡa riḡa zuhiꞌaziꞌohe, ebu gavana vazeḡa boroboroꞌe inaraze hina zeḡe haba azaḡa rana edauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Rehano zaꞌe ze ago teigoꞌi. Zae boꞌaḡano iniuꞌe ḡihiꞌa hune reihi reine, aniꞌe zae tuḡure vazeḡa reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ebu iniuꞌe zae boꞌaḡano vaze ibiꞌa reihi reine, aniꞌe zae tuḡure vazeḡa rae reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mazaḡa Vaze Ubugaꞌe vazeꞌe ane tuḡure azaḡa rouga radu mene ariro, rehano aniꞌe vaze tuḡure vazeḡa rouga radu ariro. Ebu vaze ḡehaḡa veize ane ḡabone hina dibuꞌohafine ariro.” ");
INSERT INTO ksj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Iesuꞌa ane tahiꞌatahiꞌa teite Ieriko mode iḡunirotene, vaze ḡuḡuvaḡaniꞌa ani hegotiro. ");
INSERT INTO ksj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ebu ubuma kuruḡa vazeḡa aheuꞌe ibi genaḡano ehore radiunu. Ze Iesuꞌa vitau onameꞌeteꞌe egadu ḡihau huaro, “Zuhiꞌa Boro, Davida mariga, eme vetuḡafoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Vaze ḡuḡuvaḡaniꞌa horozadu roziro, “Za sifu radoꞌi!” Rehano zeꞌe ufeta ḡihau huaro, “Zuhiꞌa Boro, Davida mariga, eme vetuḡafoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ebu Iesuꞌa tue edanadu huziro ebu ḡadiziro, “Eḡeꞌa zae veize nagini haḡaoga urateꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Zeꞌa naenaeniro, “Zuhiꞌa Boro, eme ehamatihi.” ");
INSERT INTO ksj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ebu Iesuꞌa vetuḡazeadu ubumaze oboniro. ꞌOugirotene, ubumazeꞌa zogone manoradu ze ehamaro ebu Iesu hegotiro. ");
INSERT INTO ksj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Iesuꞌa ane tahiꞌatahiꞌa teite Ierusalema hanitadu Olivi Maḡano Betefage neḡano feuriro. Ebu ane tahiꞌa aheu tuḡuzeꞌenaꞌa, ziro, ");
INSERT INTO ksj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Zama ḡoha neḡa onamoꞌi. Eꞌe neḡa diuḡine, doniki ꞌahoga batune touga ubugeta horoziꞌuma. Ebu fuhiꞌadu eḡe vaḡe zamaze aroꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Vaze ꞌahoganiꞌa ḡoere nu zoꞌidene, 'Zuhiꞌa Boroꞌa urateꞌohe,' rae noꞌi. ꞌOugine ani zogone tuḡuziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ꞌOugadu Badiꞌaꞌa peroveta vazeḡanonoꞌo reiroteꞌe ḡoeꞌaniꞌa hudaro, ");
INSERT INTO ksj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ierusalema azaḡa mazao ꞌahige zoꞌi, 'Ḡianoꞌi, zae Kiniꞌe zae vaḡe areꞌohe. Aniꞌe vaḡuꞌa ebu doniki rana ehoreha. Doniki ubuga rana ehoradu areꞌohe.'” ");
INSERT INTO ksj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ebu Iesu tahiꞌa aheuꞌa onamadu Iesuꞌa nagini ziroteꞌe idunaḡano haḡairo. ");
INSERT INTO ksj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ze doniki ubugeta tutuze Iesu vaḡe aradu dabuaze doniki ubuga ḡarunio zahariro, ebu Iesuꞌa eꞌe rana tire ehoriro. ");
INSERT INTO ksj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Vaze ḡuḡuvaḡaniꞌa dabuaze ibio hirau tiro, u vaze nuꞌe ire ezaga variꞌe madu ibi rana hiraro. ");
INSERT INTO ksj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ebu Iesu zamao onameꞌeteꞌe azaḡa zu ḡaruna hegoteꞌeteꞌe azaḡaniꞌa huaro, “Hosana, Davida mariga nigunihi! Zuhiꞌa Boro niḡano areꞌeteꞌe vazeḡaꞌe ḡihiꞌa hune! Hosana, hitana huneo nigunihi!” ");
INSERT INTO ksj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Iesuꞌa Ierusalema diuḡirotene, ne azaḡa niduꞌa haraeꞌenaꞌa, ḡadimutitiro, “Vaze ꞌadiꞌe iniu?” ");
INSERT INTO ksj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Vaze ḡuḡuvaḡaniꞌa naenaeziro, “ꞌAdiꞌe peroveta vazeḡa Iesu, Galilea habaꞌano Nazareta neḡa vazeḡa.” ");
INSERT INTO ksj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ebu Iesuꞌa kuru neḡa habaꞌa diuḡadu hoiteꞌeteꞌe azaḡa zu seroneꞌeteꞌe azaḡa hegoze buziro. Ebu hadi seniso ziniꞌeteꞌe azaḡa fata zu Tubugo niniḡa seroneꞌeteꞌe azaḡa ehoro habaꞌa mae ḡihuniro. ");
INSERT INTO ksj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ebu aniꞌa ziro, “Buka Zaḡoḡano ꞌahige rae mirihiro, 'Badiꞌa neꞌe kuru neḡa reꞌuma.' Rehano zaeꞌa kuru neḡaꞌe ḡonore azaḡa neḡano ḡihuniro.” ");
INSERT INTO ksj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ubuma kuruḡa azaḡa ebu oda sauꞌa azaḡaniꞌa ani vaḡe kuru neḡa habaꞌa aradu aniꞌa faiziro. ");
INSERT INTO ksj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡaꞌe Iesuꞌa haḡai gigiꞌa nunu haḡairoteꞌe horoniro. Ebu tahiꞌa komeꞌakomeꞌaꞌa kuru neḡa habaꞌano huauꞌenaꞌa, “Hosana, Davida mariga!” rae reiroteꞌe igiro. ꞌOugadu ze maḡune rudaro. ");
INSERT INTO ksj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ebu ze Iesu ḡadiniro, “Ḡa tahiꞌa komeꞌakomeꞌaꞌa nagini raꞌeteꞌe igiꞌehe? Ze gararoꞌi!” Aniꞌa naenaeziro, “E igiꞌohe. Rehano zaꞌe Buka Zaḡoḡa mene meꞌodirohe? 'Badiꞌaꞌa tahiꞌa komeꞌakomeꞌa zu ene guraḡaguraḡaniꞌa ani nigunoga ihoziro.'” ");
INSERT INTO ksj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Eꞌe enogano ani ze muhizadu Ierusalema ḡutuꞌaḡa onamiro ebu Betania neḡa onamadu ohere eꞌea baziro. ");
INSERT INTO ksj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Irarirotene, Iesuꞌa Ierusalema bare onamiro. Eꞌe ibiḡano ani vininiro. ");
INSERT INTO ksj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ebu figi ireḡa ibi genaḡano horonadu huga vaḡe onamiro. Rehano ire huga oꞌoꞌa zu rouḡa daꞌo horonadu ire eꞌe niro, “Ḡa mene bare hudaꞌuma!” ꞌOugadu ire eꞌeꞌa zogone roraro. ");
INSERT INTO ksj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ane tahiꞌatahiꞌaꞌa eꞌe horonadu zaguzagaro ebu ḡadiniro, “Nougenouge figi ireḡaniꞌa ḡarihe roraneha?” ");
INSERT INTO ksj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iesuꞌa naenaeziro, “Eḡeꞌa hube hune ziꞌohe, za Badiꞌa mazao fine zu mene ꞌadaꞌadazine, eḡeꞌa figi ireḡa ꞌahi mazao haḡataꞌaꞌe zaeꞌa zuni haḡaiꞌuma. Ebu maḡa ꞌahi ninaꞌa, 'Ḡihitadu davara zamaḡano buanoꞌi,' rae reine, ꞌouge fureraꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Zaeꞌa kurauꞌeteꞌe zamaḡano nagini umineꞌeteꞌeꞌa hugano fureraꞌuma. Zaeꞌa eꞌe mae ḡihinine, zae umino niduꞌa hidiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ebu Iesuꞌa kuru neḡa diuḡadu vaze ihozirotene, dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu vaze boroboroꞌa ani vaḡe aradu ḡadiniro, “Ḡa noꞌe gigiꞌaḡa hina ꞌahiguḡa haḡaeꞌohe? Iniuꞌa ꞌahi gigiꞌaḡa ḡaniro?” ");
INSERT INTO ksj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Iesuꞌa naenaeziro, “Eḡe zuni ḡadimu ꞌahoga zinihi. Zaeꞌa naenaehine, eḡe zuni noꞌe gigiꞌaḡa hina ꞌahiguḡa haḡaeꞌeteꞌe ihoziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ioaneꞌa babatiso zinirotaꞌaꞌe noumanoꞌo? Badiꞌa mazaonoꞌo ga vaze mazaonoꞌo?” Ze zeḡeꞌa bare ḡoꞌaneꞌenaꞌa, ḡadimutitiro, “Badiꞌa mazaonoꞌo reine, 'Za nougadu Ioane ḡoere mene mae ḡihiniro?' rae ifiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Rehano vaze mazaonoꞌo reine, eme vaze rihozeꞌohe, mazaḡa zeḡe niduꞌa Ioaneꞌe hube hune peroveta vazeḡa rae mae ḡihineꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Eꞌanoꞌo ze ꞌahige naenaeniro, “Emeꞌe aḡuꞌa.” Ebu Iesuꞌa ziro, “Eḡe zuni noꞌe gigiꞌaḡa hina haḡai ꞌahiguḡa haḡaeꞌeteꞌe mene ihoziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Iesuꞌa dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu vaze boroboro mazao hari idaidaḡa ꞌahoga ziro, “Za hari idaidaḡa ꞌahi zamaroꞌi. Vaze ꞌahoganiꞌa ubuga aheu teite radiunu. Aniꞌa ubuga ibiꞌa vaḡe onamadu niro, 'Eḡe tahiꞌa, ḡa izidi vaini mebaḡano gaui onamoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ebu ubuganiꞌa naenaeniro, 'E mene onamiꞌuma.' Rehano ani vesuꞌu zamaḡa ḡihunadu onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ebu moganiꞌa ubuga veḡa vaḡe onamadu ubuga ibiꞌa niroteꞌe ḡoeꞌa idaḡa niro. Aniꞌa Moga niro, 'E onamiꞌuma.' Rehano ani mene onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Zaꞌa zamareꞌetene, ubuga aheu boꞌaḡano iniuꞌa moga ura haḡairo?” Zeḡeꞌa naenaeniro, “Ubuga ibiꞌa.” Ebu Iesuꞌa ziro, “Eḡeꞌa hube hune ziꞌohe, takesi azaḡa zu daro fuꞌa roḡaeḡaroḡaeḡaꞌe Badiꞌaꞌa zuhiꞌaziꞌeteꞌe zamaḡano ibite diuḡiꞌuma. Zeḡeꞌa zae vitiziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ioane Babatisoꞌe ibi duduḡa ihozoga radu zae vaḡe ariro, rehano za mene mae ḡihiniro. U takesi azaḡa zu daro fuꞌa roḡaeḡaroḡaeḡaꞌe ani ḡoere mae ḡihiniro. Za zeḡeꞌa ꞌouge haḡairoteꞌe horoniro rehano, mene ḡihuradu ani mene mae ḡihiniro.” ");
INSERT INTO ksj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Iesuꞌa bare ziro, “Hari idaidaḡa ꞌahoga egoꞌi. Haba vazeḡa ꞌahoganiꞌa radiunu. Aniꞌa vaini mebaḡa ḡoranadu ḡabiꞌa merau varahiro, ebu vaini maḡa vuḡa gigeꞌeteꞌe veize iduḡa ꞌahoga huꞌiro, zu ehamuꞌeteꞌe neḡa hitaga haḡairo. Hena vaini mebaḡa eꞌe hihi azaḡa nu ꞌevoreo tiro, ebu aniꞌe haba ꞌahoga onamadu mada faḡa ragavinu. ");
INSERT INTO ksj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Hiriveꞌeteꞌe madaḡaniꞌa hanitirotene, vaini maḡa nu mouga radu aniꞌa ane tuḡure azaḡaꞌe hihi azaḡa vaḡe tuḡuze onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Rehano zeḡeꞌa tuḡure azaḡa oboze teadu tibaꞌe bouniro, ꞌahogaꞌe maro ebu ꞌahogaꞌe hadi hina mau bohiniro. ");
INSERT INTO ksj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Hena haba vazeḡaniꞌa tuḡureḡa azaḡa ibiꞌa vitine ufeta ḡehaḡa zeḡe vaḡe bare tuḡuziro, rehano ze tuḡure azaḡa eꞌe mazao haḡai tiba eꞌe bare haḡairo. ");
INSERT INTO ksj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ḡonagano aniꞌa ubuga zeḡe vaḡe tuḡunadu ꞌahige rae reiro, 'Ze eḡe ubude gubaniꞌuma gaogi.' ");
INSERT INTO ksj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Rehano hihi azaḡaniꞌa ubuga horonirotene, zeḡeꞌa neneḡaniro, 'Aniꞌe moga mazaonoꞌo vaini mebaḡa ꞌadi meiteꞌe vazeḡa. Eme ani matihi ebu vaini mebaḡa ꞌadi emeḡeꞌa meihi.' ");
INSERT INTO ksj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Eꞌanoꞌo zeꞌa ani obone teadu vaini mebaḡanonoꞌo ani uhine bunadu mau runiro.” ");
INSERT INTO ksj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ebu Iesuꞌa dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu vaze boroboro ḡadiziro, “ꞌOugadu vaini mebaḡa vazeḡaꞌe hihi azaḡa eꞌe vaḡe arine, zeḡe mazao nougiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Zeḡeꞌa naenaeniro, “Aniꞌa hihi azaḡa eꞌe mau ruziꞌuma. Ebu vaini mebaḡaꞌe hihi azaḡa ꞌahoga nu ziniꞌuma. ꞌOugine, hiriveꞌeteꞌe madaḡano zeḡeꞌa ani huga nu haꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iesuꞌa ziro, “Zaꞌe Buka Zaḡoḡano ḡoere ꞌahi mene meꞌodirohe? 'Vazeꞌa hadi hina ne ogorarotene, zeꞌa mae modiroteꞌe hadiḡaꞌe ne duꞌe rinedeꞌeteꞌe hadiḡa reiro. Aꞌe Zuhiꞌa Boroꞌa haḡairoteꞌe haḡaiḡa. Emeḡeꞌa ḡianadu zaguzagauꞌohe.' ");
INSERT INTO ksj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Eꞌanoꞌo eḡeꞌa ziꞌohe, Badiꞌaꞌa za, Isaraela azaḡa mene bare zuhiꞌaziꞌuma, rehano haba ꞌahoga azaḡa ane ura haḡaeꞌetaꞌaꞌe zuhiꞌaziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Iniuꞌa hadi eꞌe rana higaune, ani varadu tahitahiꞌuma zu hadi eꞌeꞌa iniu rana higaune, aniꞌe seꞌetiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Dibuꞌo vazeḡa ḡihiꞌaḡihiꞌaḡa zu Farisea azaḡaniꞌa Iesu hari idaidaḡa igirotene, Iesuꞌa zeḡe moneo reirotaꞌaꞌe ederiro. ");
INSERT INTO ksj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ꞌOugadu zeꞌe Iesu obone tihi reiro. Rehano vaze ḡuḡuvaḡaniꞌa zeḡe mazao maḡuniꞌuma radu rihoziro, mazaḡa vaze ḡuḡuvaḡaniꞌa Iesuꞌe peroveta vazeḡa rae mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesuꞌa hari idaidaḡa nu hina bare ḡoreziro, ");
INSERT INTO ksj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Badiꞌaꞌa zuhiꞌaziꞌetaꞌaꞌe kini ꞌahoga heuḡa. Aniꞌa ubuga veize hahu muiḡa haḡairo. ");
INSERT INTO ksj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ebu huziroteꞌe azaḡaniꞌa mui aroga veize tuḡure azaḡa zeḡe vaḡe tuḡuziro. Rehano zeꞌe aroga hezahiro. ");
INSERT INTO ksj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ebu aniꞌa tuḡure azaḡa ꞌahoga nu bare tuḡuzeꞌenaꞌa, ziro, 'Eḡeꞌa huzateꞌe azaḡaꞌe ꞌahige rae zoꞌi: Eḡeꞌa zae veize mui ruhibeha. Boromakau zu mani iga manadu ogomu niduꞌa ꞌai ruhibeha. Hahu muiḡa uꞌa aroꞌi.' ");
INSERT INTO ksj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Rehano ze teḡa riraro ebu zeḡe edeḡano onamiro. ꞌAhogaꞌe mebaḡa onamiro ebu ꞌahogaꞌe hadi vaḡi onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ebu nuꞌe tuḡure azaḡa oboze teadu sausauziro ebu zimi ruziro. ");
INSERT INTO ksj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kiniꞌa eꞌe igirotene, ani maḡune rudaro. Ebu ani uti azaḡa tuḡuzadu gorugoru azaḡa eꞌe zimi hauḡiro zu neze zuni hufi haoniro. ");
INSERT INTO ksj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ebu ane tuḡure azaḡa huzadu ziro, 'E hahu muiḡa ꞌai ruhibe idaneha, rehano eḡeꞌa huziroteꞌe azaḡaꞌe arogaꞌe mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Eꞌanoꞌo ibi boroboro onamadu horoziteꞌe azaḡa niduꞌa mui aroga veize huzoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ebu ane tuḡure azaḡaniꞌa ibi boroboro onamadu hidiroteꞌe azaḡa niduꞌa, manoḡa zu sauꞌa azaḡa niduꞌa nuꞌoziro ebu zamaze onamadu huziroteꞌe azaḡaniꞌa mui neḡa iri'avoniro. ");
INSERT INTO ksj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ebu kiniꞌa iꞌudo azaḡa ḡiazihi radu diuḡirotene, vaze ꞌahoganiꞌa hahu mui dabuaḡa mene vidaroteꞌe horoniro. ");
INSERT INTO ksj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ꞌOugadu aneꞌa ḡadiniro, ꞌEḡe nabudi, ḡaꞌe hahu dabuaḡa mene vidaneha. Nougenouge ꞌadi diuḡi areha?' Rehano ani ḡoere ꞌahoga mene reiro. ");
INSERT INTO ksj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ꞌOugadu kiniꞌa ane gau azaḡa ziro, 'Ani ꞌevoꞌa zu odaḡa batunadu enone uzaboḡano feune bunoꞌi. Ane eꞌea niaꞌuma zu ḡononeḡa atitiꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ḡonagano Iesuꞌa ziro, “Badiꞌaꞌa huziroteꞌe azaḡaꞌe ḡehaḡa, rehano ohotiroteꞌe azaḡaꞌe tahiḡa daꞌo.” ");
INSERT INTO ksj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Eꞌe madaḡano Farisea azaḡaniꞌa onamadu, “Iesuꞌa ḡoere veꞌoḡa ꞌahoga reine obone tiꞌuma,” rae ḡoꞌaniro. ");
INSERT INTO ksj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ebu zeꞌa zeḡe tahiꞌatahiꞌa zu kini Heroda mone azaḡaꞌe Iesu mazao tuḡuzadu niro, “Ihore vazeḡa, emeꞌe edeḡa, ḡaꞌe huga daꞌo ḡoereꞌohe zu Badiꞌa mone ibiḡa hugano ihozeꞌohe ebu vaze niduꞌa mazao mene inaheꞌenaꞌa, vaze uꞌano zamaḡo mene haganeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Eꞌanoꞌo ḡaꞌe nouge rae zamareꞌohe? Emeꞌe Roma kiniḡa mazao takesi haune, duduḡa ga mene?” ");
INSERT INTO ksj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Iesuꞌe zeḡe zamarone sauꞌa ederadu ziro, “Zaꞌe zama guhi azaḡa, nougadu eḡe tuhuheꞌohe? ");
INSERT INTO ksj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takesi hadiḡa ihohoꞌi.” Ze Roma hadiḡa tiba mae harotene, ");
INSERT INTO ksj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","aneꞌa ḡadiziro, “Iniu viga zu iniu niḡaꞌe eꞌe rana mirihiro?” ");
INSERT INTO ksj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Zeḡeꞌa naenaeniro, “Aꞌe Roma kiniḡa viga zu niḡa.” Ebu aneꞌa ziro, “Tena Roma kiniḡa ḡauꞌe Roma kiniḡa hanoꞌi, u Badiꞌa ḡauꞌe Badiꞌa hanoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ze ani ḡoere igirotene zaguzagaro ebu ani muhinadu oname ḡouriro. ");
INSERT INTO ksj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Eꞌe madaḡano Sadukea azaḡa nuꞌa Iesu vaḡe ariro. Sadukea azaḡaꞌe vazeꞌa runeonoꞌo mene bare ḡabodiꞌuma rae reiro. Zeḡeꞌa Iesu ḡadiniro, ");
INSERT INTO ksj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ihore vazeḡa, Moseꞌa goro ḡoeꞌa ꞌahoga ꞌahige rae mirihiro, 'Ohoze ꞌahoganiꞌa rudanadu ani inugaꞌe ubuga ꞌoꞌoꞌa reine, ohoze negoḡaniꞌa ḡozobaḡa teite hahuriꞌuma, ebu ubuga furenadu ubuganiꞌa rune negoḡa ehaꞌa meꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tena hari ꞌahi zamaroꞌi. Negoḡa niduꞌa fuꞌo aheu fareꞌa radiunu. Ibiꞌaniꞌa hahuriro ebu ubuga oꞌoꞌa rudaro. ꞌOugadu negoḡa aheuḡaniꞌa ḡozobaḡa teite hahuriro. ");
INSERT INTO ksj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Rehano ane zuni ubuga oꞌoꞌa rudaro, ebu negoḡa uḡiduḡa onamo fuꞌo aheu fare mazao ꞌuguḡaniꞌa idane fureraro. ");
INSERT INTO ksj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ḡonagano ḡozoba eꞌe zuni rudaro. ");
INSERT INTO ksj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tena runeonoꞌo bare ḡaboditeꞌe madaḡano roḡae aꞌe iniu inuga reꞌuma? Mazaḡa ohoze niduꞌa fuꞌo aheu fareꞌa ani teite hahuriro.” ");
INSERT INTO ksj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Iesuꞌa naenaeziro, “Zaꞌa zamareꞌetaꞌaꞌe veꞌoḡa, mazaḡa zaꞌe Buka Zaḡoḡa ga Badiꞌa gigiꞌaḡa moneo aḡuꞌa. ");
INSERT INTO ksj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Runeonoꞌo bare ḡaboditeꞌe madaḡanoꞌe ohoze zu roḡaeꞌe mene hahuriꞌuma. Zeꞌe tuḡure viga adureo teigiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Rune azaḡaniꞌa bare ḡabodeꞌeteꞌe moneo, Badiꞌaꞌa reiroteꞌe ḡoeꞌa zaeꞌa mene meꞌodirohe? Aneꞌa ꞌahige rae reiro, ");
INSERT INTO ksj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","'Eꞌe Aberahamo Badiꞌa, Isako Badiꞌa zu Iakobo Badiꞌa.' Badiꞌaꞌe mene rune azaḡa Badiꞌa, rehano ḡabone azaḡa Badiꞌa.” ");
INSERT INTO ksj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Vaze ḡuḡuvaḡaniꞌa Iesu ihoreḡa ḡoeꞌa igirotene, zaguzagaro. ");
INSERT INTO ksj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ebu Farisea azaḡaniꞌa Iesuꞌa Sadukea azaḡa ḡadimu naenaenadu hebeze ꞌuiroteꞌe hariḡa igirotene, tibano nuꞌoraro. ");
INSERT INTO ksj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ebu zeḡe boꞌaḡano Mose goro ḡoeꞌa ihozeꞌeteꞌe vazeḡa ꞌahoganiꞌa Iesu tuhune nurihi radu ḡadiniro, ");
INSERT INTO ksj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ihore vazeḡa, Mose goro ḡoeꞌa niduꞌa zamaḡano noꞌe goro ḡoeꞌaꞌe ḡihiꞌa hune?” ");
INSERT INTO ksj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Iesuꞌa naenaeniro, “Goro ḡoeꞌa ḡihiꞌa huneꞌe ꞌahi eꞌe: 'Zuhiꞌa Boro ḡae Badiꞌa zamaḡo niduꞌa hina, vineḡo niduꞌa hina zu zamaroneḡo niduꞌa hina zamare borofoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Aꞌe goro ḡoeꞌa ibiꞌa zu ḡihiꞌa hune. ");
INSERT INTO ksj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Goro ḡoeꞌa ḡihiꞌa hune aheuḡa zuni eꞌe heuḡa: 'Ḡa ḡae bare zamare borofeꞌeteꞌe teige, nabugo zuni zamare borofoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mose goro ḡoeꞌa niduꞌa ebu peroveta azaḡaniꞌa ihoziroteꞌe ḡoeꞌa niduꞌaꞌe goro ḡoeꞌa aheu eꞌe rana ohoniro.” ");
INSERT INTO ksj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisea azaḡaniꞌa nuꞌoraroteꞌe zamaḡano Iesuꞌa ḡadiziro, ");
INSERT INTO ksj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Zaꞌe Keriso moneo nouge rae zamareꞌohe? Aniꞌe iniu mariga?” Zeḡeꞌa naenaeniro, “Aniꞌe Davida mariga.” ");
INSERT INTO ksj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Iesuꞌa ziro, “Tena nougadu Davidaꞌe Vine Zaḡoḡaniꞌa ihonadu Keriso mazao Zuhiꞌa Boro rae huniro? Aniꞌe ꞌahige rae reiro, ");
INSERT INTO ksj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","'Badiꞌaꞌa eḡe Zuhiꞌa Boro niro, “Eḡe edaꞌe moneo ehoroꞌi, onamo eḡeꞌa agireḡo niduꞌa madu odaḡo ꞌuꞌuḡano raharahaziꞌuma.”' ");
INSERT INTO ksj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Davidaꞌa Keriso mazao Zuhiꞌa Boro rae huniro. Tena Kerisoꞌe nougenouge Davida mariga reꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ebu vazeni ꞌahoga zuni Iesu mene naenaeniro. Eꞌe enogano vazeni ꞌahoganiꞌa Iesu mene bare ḡadiniro. ");
INSERT INTO ksj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ebu Iesuꞌa vaze ḡuḡuvaḡa zu ane tahiꞌatahiꞌa ziro, ");
INSERT INTO ksj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zu Farisea azaḡaꞌe Mose goro ḡoeꞌa ihozeꞌeteꞌe iḡuꞌa meiroteꞌe azaḡa. ");
INSERT INTO ksj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Eꞌanoꞌo zeꞌa nagini raꞌeteꞌe egozenadu haḡaoꞌi. Rehano zeḡe haḡaiꞌe ago hegotoꞌi, mazaḡa zeꞌe zeḡeꞌa bare zae ihozeꞌeteꞌe idunaḡano mene haḡaeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ze ihoreꞌe riga hune radu vazeꞌa eꞌe hegotoga mene idaḡa. Zeꞌe vaze daꞌo aduga boro ziniꞌohe, rehano zeḡe ꞌevore huduꞌa tiba hina zu mene hune danazeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ze vazeꞌa horozoga veize haḡai niduꞌa haḡaeꞌohe. Ze Badiꞌa ḡoere soꞌaḡa ufeꞌeteꞌe umaḡa ufeta rafane haḡadu amusize rana tatuhe uteꞌohe zu dabuaze faḡafeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Muioꞌe nize boro azaḡaniꞌa ehoreꞌeteꞌe habaꞌano ehoroga urateꞌohe, zu nuꞌonuꞌo neḡanoꞌe vaze boroboroꞌa ehoreꞌeteꞌe habaꞌano ehoroga urateꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ebu vaze ḡehaḡa habaꞌanoꞌe vazeꞌa gubazeꞌenaꞌa, zeḡe mazao unihoga zu 'Ihore Vazeḡa,' rae huzoga urateꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Rehano vaze ꞌahoganiꞌa zae mazao 'Ihore Vazeḡa' rae huzoga gararoꞌi, mazaḡa za ihore vazeḡaꞌe tiba daꞌo. Zae niduꞌaꞌe idaḡa daꞌo, negoze zu ezeze. ");
INSERT INTO ksj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ebu rahao ꞌada vaze ꞌahoga 'Mama,' rae ago hunoꞌi, mazaḡa adureo radiuꞌeteꞌe Badiꞌaḡa daꞌoꞌe zae Mama. ");
INSERT INTO ksj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ebu vaze ꞌahoganiꞌa zae mazao 'Ibitoziꞌeteꞌe Vazeḡa' rae huzoga gararo'i, mazaḡa zae ibitoziꞌeteꞌe vazeḡaꞌe Keriso daꞌo. ");
INSERT INTO ksj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Zae boꞌaḡano iniuꞌe vaze ḡihiꞌa hune reine, aniꞌe zae tuḡure azaḡa reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Iniu vaze aneꞌa bare niḡa mae itine, Badiꞌaꞌa niḡa mae ovoiꞌuma, u iniu vaze aneꞌa bare niḡa mae ovoine, Badiꞌaꞌa niḡa mae itiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zu Farisea azaḡa, zaꞌe zama guhi azaḡa! Aduga boro hidiꞌuma! Mazaḡa zaꞌe Badiꞌaꞌa zuhiꞌazoga urateꞌeteꞌe azaḡa ibize ꞌueꞌohe. Zaꞌe zaeꞌa bare eꞌe mene urateꞌohe ebu urateꞌeteꞌe azaḡa zuni ꞌueꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zu Farisea azaḡa, zaꞌe zama guhi azaḡa! Aduga boro hidiꞌuma! Vaze tibaniꞌa ḡihuradu zae ihore hegotoga veize zaeꞌa davara zu haba ragave onameꞌohe. Ebu vaze ꞌahoga matene, ani ihonadu aniꞌa haḡai sauꞌa zae vitize ufeta haḡaeꞌohe. Ebu aniꞌe ire roga radiu tuḡutuḡu diuḡadu adugaꞌe zae vitize ḡae aheu hideꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Zaꞌe vaze ibitoziꞌeteꞌe azaḡa, rehano ubuma kuruḡa azaḡa! Aduga boro hidiꞌuma! Zaeꞌa ꞌahige raꞌohe, 'Iniuꞌa kuru neḡa niḡano ḡoitorine, aꞌe huga oꞌoꞌa. Rehano iniuꞌa kuru neḡa zamaḡano golo hina ḡoitorine, aꞌe riḡa radu aniꞌa ane ḡoitore tihitihiniꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Zaꞌe ubuma kuruḡa kauriḡa azaḡa! Noꞌe ufeta ḡihiꞌaḡa? Golo ga kuru neḡa? Kuru neḡaꞌe ufeta ḡihiꞌaḡa, mazaḡa goloꞌe kuru neḡa zamaḡano tiroteꞌe uꞌano aꞌe zaḡoḡa raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ebu za ꞌahige raꞌohe, 'Iniuꞌa dibuꞌo fataḡa niḡano ḡoitorine, aꞌe huga oꞌoꞌa. Rehano iniuꞌa dibuꞌo fataḡano ḡahunoneḡa hina ḡoitorine, aꞌe riḡa radu aniꞌa ane ḡoitore tihitihiniꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Zaꞌe ubuma kuruḡa azaḡa! Noꞌe ufeta ḡihiꞌaḡa? Ḡahunoneḡa ga dibuꞌo fataḡa? Dibuꞌo fataḡaꞌe ufeta ḡihiꞌaḡa, mazaḡa ḡahunoneḡaꞌe dibuꞌo fataḡa rana tiroteꞌe uꞌano aꞌe zaḡoḡa raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Iniuꞌa dibuꞌo fataḡa niḡano ḡoitoreꞌetene, dibuꞌo fataḡa ebu eꞌe rana ḡau niduꞌa hina ḡoitoreꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ebu iniuꞌa kuru neḡano ḡoitoreꞌetene, kuru neḡa niḡano ebu eꞌea ḡabode radiuꞌeteꞌe Badiꞌaḡa niḡano ḡoitoreꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Zu iniuꞌa adure niḡano ḡoitoreꞌetene, Badiꞌa ehoro habaꞌa hina zu eꞌe rana ehoreꞌeteꞌe Badiꞌaḡa niḡano ḡoitoreꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zu Farisea azaḡa, zaꞌe zama guhi azaḡa! Aduga boro hidiꞌuma! Mazaḡa zaꞌe tirara mebaḡano eḡa zu murari teige komeꞌa fase ogomuḡa niduꞌaonoꞌo sinu gaubananao rovonadu sinu tiba mone ḡauḡa Badiꞌa hauꞌohe. Rehano Mose goro ḡoeꞌano ḡau ufeta boroboroꞌe igi modeꞌohe. Aꞌe haḡai duduḡa haḡaeꞌeteꞌe, vaze vetuḡaziꞌeteꞌe zu zama niduꞌa hina haḡaeꞌeteꞌe raꞌohe. Za ḡau boro ꞌadiꞌe haḡaifo ebu komeꞌakomeꞌa zuni mene igi modifo. ");
INSERT INTO ksj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Zaꞌe vaze ibitoziꞌeteꞌe azaḡa, rehano ubuma kuruḡa azaḡa! Zaꞌe vu zamaḡano ofene horoneꞌetene beuꞌe modadu gageꞌohe, rehano kameloꞌe une tauḡeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zu Farisea azaḡa, zaꞌe zama guhi azaḡa! Aduga boro hidiꞌuma! Zaꞌe bioze zu siuvaze enoga daꞌo vuzuꞌe deheneꞌohe, mazaḡa zamazeo matuꞌu veize daꞌo radiu tauḡitauḡeꞌohe zu ununuꞌa iriꞌaveꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ubuma kuruḡa Farisea azaḡa! Bio zu siuva zamaḡa ibite geno vuzuꞌe dehenoꞌi, ꞌougine enoga zuni deheraꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zu Farisea azaḡa, zaꞌe zama guhi azaḡa! Aduga boro hidiꞌuma! Zaꞌe ꞌuruḡa hina asiroteꞌe rune iduḡa heuḡa. Rune iduḡa enoga ḡianine manoḡa tauḡi, rehano zamaḡaꞌe rune azaḡa isine zu torare niduꞌa iriꞌaveꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Eꞌe teige, vazeꞌa zae enone daꞌo ḡiazadu zaꞌe duduḡa azaḡa rae raꞌohe, rehano zamazeꞌe zama guhi zu haḡai sauꞌaniꞌa iriꞌaveꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zu Farisea azaḡa, zaꞌe zama guhi azaḡa! Aduga boro hidiꞌuma! Zaꞌe vouḡazeꞌa ibite zimiroteꞌe peroveta azaḡa rune iduḡa ogoruꞌohe, ebu haḡai duduḡa azaḡa rune iduḡa rohorohoneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ebu zaꞌe ꞌahige raꞌohe, 'Emeꞌa vouḡafe madaḡano radifone, zeḡeꞌa peroveta azaḡa goruzihi rae reirotene zeḡe teite mene tiburafo.' ");
INSERT INTO ksj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ꞌOugadu za zaeꞌa bare peroveta azaḡa goruziroteꞌe azaḡa mariga rae fureneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Eꞌanoꞌo zae zuni vouḡaze teige haḡaoꞌi. Zeḡeꞌa ḡadahiroteꞌe gauḡa zaeꞌa haḡae hauḡoꞌi! ");
INSERT INTO ksj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Zaꞌe mohe! Zarama ubugaubuga! Badiꞌaꞌa kotazadu zaꞌe ire roga radiu tuḡutuḡu zamaḡano mae feuziꞌuma ebu eꞌeanoꞌo feranogaꞌe mene idaraꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Eꞌanoꞌo eḡeꞌa peroveta azaḡa, huhuzaḡa azaḡa zu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zae vaḡe tuḡuzeꞌohe. Rehano nuꞌe zaeꞌa goruziꞌuma, nuꞌe satauroziꞌuma ebu nuꞌe zae nuꞌonuꞌo neḡano masiziꞌuma zu haba ꞌahoganonoꞌo haba ꞌahoga ze hegotadu sausauziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Zaeꞌa raha ꞌada duduḡa azaḡa niduꞌa goruziro. Ze ibite duduḡa vazeḡa Abela mau runiroteꞌeanoꞌo onao ḡonagano Berekia ubuga Zekaria maro. Zekariaꞌe kuru neḡa zu dibuꞌo fataḡa boꞌaḡano mau runiro. ꞌOugadu eꞌe naeḡa niduꞌaꞌe zaeꞌa odohiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Eḡeꞌa hube hune ziꞌohe, eꞌe aduga niduꞌaꞌe izidi eganiꞌa odohiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O, Ierusalema, Ierusalema, zaꞌa peroveta azaḡa zimiro zu Badiꞌaꞌa tuḡuziroteꞌe azaḡa hadi hina zimi ruziro. Kokorokuꞌa isaḡa zamaḡano ubuga gugubeꞌeteꞌe teige, eḡeꞌa ḡae ḡehaḡa zae taufihi reiro, rehano zaꞌe mene uratinu! ");
INSERT INTO ksj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ḡianoꞌi, neze fahadu haba bohaꞌa teigiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Eḡeꞌa ziꞌohe, za e mene bare horohiꞌuma, onamo zaeꞌa raenaꞌa, 'Zuhiꞌa Boro niḡano areꞌeteꞌe vazeḡaꞌe ḡihiꞌa hune,' rae reiteꞌe madaḡaniꞌa meꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesuꞌa kuru neḡanonoꞌo buau onamirotene, ane tahiꞌatahiꞌaꞌa ani vaḡe aradu kuru neḡa habaꞌano ne iraḡa nunu ihoniro. ");
INSERT INTO ksj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ꞌOugadu aniꞌa ziro, “Za ḡau ꞌadi niduꞌa horoneꞌehe? Eḡeꞌa hube hune ziꞌohe, kuru neḡa ꞌadi fahe ḡuzuhadu hadini ꞌahoganiꞌa hadi ꞌahoga ranao mene radiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Iesuꞌa Olivi Maḡano ehorirotene, ane tahiꞌatahiꞌaꞌe zeḡe daꞌo ani vaḡe sifu onamadu ḡadiniro, “Eꞌeguḡaniꞌa naniꞌa fureraꞌuma? Mada ḡonagano zu ḡaeꞌa bare ariteꞌe madaḡanoꞌe nagi haḡai nu badeḡaniꞌa ibite fureraꞌuma? Eme efoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iesuꞌa naenaeziro, “Vaze ꞌahoganiꞌa za mene soꞌosoꞌozifine tohutohoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Vaze ḡehaḡaniꞌa eḡe niḡano aradu 'Eꞌe Keriso,' rae reꞌuma ebu vaze ḡehaḡa soꞌosoꞌoziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Zaꞌe utiutiꞌa fureraroteꞌe hariḡa zu fureraꞌuma rae raꞌeteꞌe ḡoeꞌa nunu igiꞌuma, rehano zamazeꞌa ago ꞌadaꞌadazoꞌi. Eꞌeguḡaniꞌa hube hune ibite fureraꞌuma, rehano ꞌize mene mada ḡonaga. ");
INSERT INTO ksj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Haba ꞌahoganiꞌa haba ꞌahoga teite utitiꞌuma, zu gavamani ꞌahoganiꞌa gavamani ꞌahoga teite utitiꞌuma. Haba nunu zamaḡano zagaꞌa hiaꞌuma, zu habaꞌa borofe hagariꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Eꞌeguḡa niduꞌaꞌe ene ꞌizema fureranogano gigiꞌaniꞌa ḡadahe fureruꞌeteꞌe heuḡa. ");
INSERT INTO ksj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ebu vazeꞌa za riꞌizadu sausauziꞌuma zu zimiꞌuma. Eḡe uꞌano, haba azaḡa niduꞌa zae heꞌeheꞌeziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Eꞌe madaḡano vaze ḡehaḡaniꞌa eḡe mazao fieꞌeteꞌeꞌa dauḡiꞌuma, revotitiꞌuma zu heꞌeheꞌetitiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ebu ḡuriro peroveta azaḡa ḡehaḡaniꞌa fureranadu vaze ḡehaḡa soꞌoziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Vaze sauꞌaniꞌa ufeta bororuꞌeteꞌe uꞌano, vaze ḡehaḡaniꞌa zeḡe negoze nabudize mene zamare borofiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Rehano iniu edau gigaru onamo ḡonaga meiteꞌe vazeḡaꞌe ḡabone hidiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ebu Badiꞌaꞌa zuhiꞌaziꞌeteꞌe hariḡa manoḡaꞌe raha ꞌadi niduꞌa zamaḡano haramadu habaꞌahabaꞌa azaḡa niduꞌa mazao rae fureniꞌuma. Ebu hena mada ḡonaganiꞌa ariꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ibite peroveta vazeḡa, Danielaꞌa ḡoeriroteꞌe teige, haba sausauneꞌeteꞌe ḡauḡa sauꞌa bagaḡaniꞌa haba zaḡoḡano edauꞌeteꞌe zaꞌa horoniteꞌe madaḡaniꞌa ariꞌuma (ꞌadi meꞌodeꞌeteꞌe vazeḡa, ḡoere huga ꞌadi faine ederoꞌi). ");
INSERT INTO ksj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Eꞌe madaḡano Iudea habaꞌano radiuꞌeteꞌe azaḡaꞌe maḡa ferau itoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Iniuꞌa ne enogano radiuꞌeteꞌe vazeḡaꞌe ḡauḡa mouga veize ne zamaḡa ago diuḡoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mebao hiheꞌeteꞌe vazeḡa zuni dabua mouga veize ago bare onamoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Eꞌe madaḡano ahiꞌeta roḡaeḡa ebu nune hina ene guraḡa ḡubuzeꞌeteꞌe roḡaeḡaꞌe feranoga mene idaḡa radu aduga boro hidiꞌuma! ");
INSERT INTO ksj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ꞌUguḡaniꞌa irugu madaḡano ga Bana Madaḡano mene fureranoga veize kuranoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mazaḡa eꞌe madaḡano vaze niduꞌa aduga boro hune hidiꞌuma. Badiꞌaꞌa ḡadaheḡano ḡau niduꞌa haḡairoteꞌeanoꞌo onao izidi aduga ꞌuguḡaniꞌa mene fureraro, ebu vesuꞌu zuni mene bare fureraꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Zuhiꞌa Boroꞌa eꞌe madaḡa mene futufine, vazeni ꞌahoga zuni mene ḡabode radiꞌuma. Rehano ani aneꞌa ohotiroteꞌe azaḡa veize eꞌe madaḡa futufiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Eꞌe madaḡano vaze ꞌahoganiꞌa zinaꞌa, 'Ḡianoꞌi, Kerisoꞌe ꞌahi eꞌe!' ga 'Aniꞌe ꞌomo eꞌe!' rae zoꞌidene, ze ḡoere ago mae ḡihinoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mazaḡa ḡuriro kerisoḡa zu ḡuriro perovetaḡa azaḡaniꞌa fureranadu haḡai nu badeḡa boro bagaḡa zu haḡai gigiꞌa haḡaeꞌenaꞌa, vaze soꞌoziꞌuma. Ze idaḡa reine, Badiꞌaꞌa ohotiroteꞌe azaḡa zuni soꞌoziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tohutohe radoꞌi. Eꞌe madaḡaniꞌa ꞌizema fureranogano eḡeꞌa ibite zae ihozeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Eꞌanoꞌo vaze ꞌahoganiꞌa zinaꞌa, 'Ḡianoꞌi, Kerisoꞌe haba bohaꞌano,' rae roꞌidene, ḡianihi radu ago onamoꞌi. Ga, 'Ḡianoꞌi, aniꞌe ne zamaḡano,' rae roꞌidene, eꞌe ḡoeꞌaꞌe ago mae ḡihinoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Vaze Ubuganiꞌa bare arine, vaze niduꞌa huneꞌa horoniꞌuma. Aꞌe viriꞌa vazahadu madaꞌa iteꞌeteꞌe moneonoꞌo ovoeꞌeteꞌe moneo aganadu vaze niduꞌa tabara horoneꞌeteꞌe heuḡa. ");
INSERT INTO ksj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Naginiꞌa rudaroteꞌe habaꞌano gaozaꞌa nuꞌoraꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Aduga madaḡaniꞌa hauḡine, 'Zogone madaꞌa uzaboraꞌuma, batoꞌa mene agaraꞌuma, buzuvaꞌa adureonoꞌo rururu buaꞌuma, ebu adure gigiꞌaḡaniꞌa hagahagariꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Eꞌe madaḡano Vaze Ubuganiꞌa ariteꞌe ihozeꞌeteꞌe haḡaiḡa nu badeḡaniꞌa adureo fureraꞌuma, ebu raha ꞌadao habaꞌahabaꞌa azaḡa niduꞌa niau ḡouriꞌuma. Ebu ze Vaze Ubuganiꞌa gigiꞌaḡa boro zu agaḡa boro hune madu adureo ḡoze hina areꞌeteꞌe horoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ebu bigoro ago boro zamaḡano aniꞌa ane tuḡure viga ḡehaḡa tuḡuziꞌuma, ebu zeḡeꞌa adure ḡonaga ꞌahaonoꞌo onamo adure ḡonaga ꞌomo, haba niduꞌa zamaḡano Badiꞌaꞌa ohotiroteꞌe azaḡa nuꞌoziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Figi ireḡa ḡianadu ꞌahi ederoꞌi. Ezaganiꞌa butiru itadu rouḡaniꞌa udufaꞌoga horoneꞌetene, zaꞌe edeḡa, irugu madaḡaniꞌa haniteha. ");
INSERT INTO ksj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Eꞌe teige, ꞌahiguḡaniꞌa fureranoga horonoꞌidene, Vaze Ubuganiꞌa zae ibihetao haniteha rae ederoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Eḡeꞌa hube hune ziꞌohe, izidi egaꞌe mene hauḡiꞌuma, onamo ꞌahiguḡa niduꞌa fureraꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Adure zu rahaꞌe hauḡiꞌuma, rehano eḡe ḡoereꞌe mene hune hauḡiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Rehano vazeni ꞌahoga zuni ꞌuguḡaniꞌa fureratiteꞌe madaḡaꞌe aḡuꞌa. Adureo tuḡure viga ebu Badiꞌa Ubuga zuni aḡuꞌa, rehano Moga daꞌo edeḡa. ");
INSERT INTO ksj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Vaze Ubuganiꞌa bare ariteꞌe madaḡaꞌe Noa madaḡa teigiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Zobo boroꞌa ꞌizema zubuzogano, vaze niduꞌa iḡaiḡa haḡainuteꞌe teige ogaunu, gaginu zu hahurinu, onamo Noaꞌa ḡasi boro diuḡiro. ");
INSERT INTO ksj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Rehano ze naginiꞌa fureraꞌuma mene ederiro, onamo zobo boroꞌa zubuzadu hunuhune ḡouriro. Vaze Ubuganiꞌa bare ariteꞌe madaḡaꞌe eꞌe madaḡa teigiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Eꞌe madaḡano vaze aheuꞌa mebao gaue radiuꞌeteꞌea, ꞌahogaꞌe zamahanadu onamiꞌuma, u ꞌahogaꞌe muhine iḡuniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Roḡae aheuꞌe ꞌuvahu mirune radiuꞌeteꞌea, ꞌahogaꞌe zamahanadu onamiꞌuma, u ꞌahogaꞌe muhine iḡuniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Eꞌanoꞌo tohutohoꞌi, mazaḡa zaꞌe aḡuꞌa, noꞌe madaḡano zae Zuhiꞌa Boroꞌa ariꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ꞌAdi zamaroꞌi. Ḡonore vazeḡaniꞌa ohere noꞌe madaḡano aritaꞌaꞌe ne vazeḡaniꞌa ederifone, aniꞌe evate radiuꞌenaꞌa neḡa faine taufadu ḡonore vazeḡaniꞌa diuḡogaꞌe mene idarafo. ");
INSERT INTO ksj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Eꞌanoꞌo zae zuni ruhibe radoꞌi, mazaḡa Vaze Ubugaꞌe zaeꞌa mene zamareꞌeteꞌe madaḡano ariꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Iniuꞌe vaze huhuzaḡa zu zamaḡa niduꞌa hina gaueꞌeteꞌe vazeḡa? Tuḡure vazeḡa ꞌahogaꞌe vaze ꞌuguḡa reine, zuhiꞌaḡaniꞌa aniꞌe tuḡure vazeḡa ḡihiꞌaḡano mae ohonadu ꞌahige rae niꞌuma, 'Tuḡure azaḡa niduꞌa taufoꞌi. Ogomuze zuni mada idunane zenoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ebu tuḡure vazeḡa eꞌeꞌa ꞌouge gauine ebu zuhiꞌaḡaniꞌa bare feuradu horonine, tuḡure vazeḡa aꞌe matuꞌe rudaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Eḡeꞌa hube hune ziꞌohe, aniꞌe zuhiꞌaḡaniꞌa ane tohe niduꞌa taufeꞌeteꞌe vazeḡano ohoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Rehano tuḡure vazeḡa aꞌe sauꞌa reine, ani aneꞌa bare ꞌahige zamariꞌuma, 'Eḡe zuhiꞌaꞌe vesuꞌu faḡanobuꞌu ariꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ebu tuḡure azaḡa niduꞌa bouziꞌuma zu gagone azaḡa teite ufeta ogau gage sautaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ebu aniꞌa mene zamareꞌeteꞌe zu mene edereꞌeteꞌe madaḡano zuhiꞌaḡaniꞌa bare aradu, ");
INSERT INTO ksj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ani ahiri variꞌe tahitahiꞌuma ebu zama niduꞌa hina mene gaueꞌeteꞌe azaḡa habaꞌano ohonadu aduga boro haꞌuma. Eꞌea ani niaꞌuma zu ḡononeḡa atitiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Iesuꞌa bare reiro, “Eꞌe madaḡano Badiꞌaꞌa zuhiꞌaziꞌetaꞌaꞌe nogoba gaubanana teigiꞌuma. Ze ihureze madu hahu ohoze iziga hidoga veize onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Zeḡe boꞌaḡano fuꞌoꞌe kauriḡa ebu fuꞌoꞌe huhuzaḡa. ");
INSERT INTO ksj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nogoba kauriḡa fuꞌoꞌe ihureze odohiro, rehano ihure vuḡaꞌe mene meiro. ");
INSERT INTO ksj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","U nogoba huhuzaḡa fuꞌoꞌe ihurezeta ihure vuḡa biozeo abe odohiro. ");
INSERT INTO ksj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ebu hahu ohoze iziganiꞌa mene ḡarihe arirotene, ze ubumaze anozadu bazubazu uhiro. ");
INSERT INTO ksj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ohere nemanema ze ago ꞌahoga igiro, 'Hahu ohoze iziganiꞌa feureha! Buanadu ani hidoꞌi!' ");
INSERT INTO ksj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ꞌOugirotene nogoba niduꞌa evatadu ihureze ruhibiro. ");
INSERT INTO ksj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ebu nogoba kauriḡa fuꞌoꞌa nogoba huhuzaḡa fuꞌo umiziro, 'Za ihure vuḡa nuḡo eme rifoꞌi, mazaḡa eme ihureꞌe vidauꞌohe.' ");
INSERT INTO ksj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Zeḡeꞌa naenaeziro, 'Mene, 'ahiꞌe za zu emeḡe niduꞌa veize mene idaḡa. Ihure vuḡa seroneꞌeteꞌe vazeḡa vaḡe onamadu zae veize nu hoitoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Rehano ze ihureze vuḡa hoitoga uꞌa onamiroteꞌea, hahu ohoze iziganiꞌa feuriro. Ebu ihureze zu ihureze vuḡa ruhibiroteꞌe nogobaḡa fuꞌoꞌa ani teite mui habaꞌa diuḡiro ebu ibihetaḡaꞌe hararo. ");
INSERT INTO ksj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Vesuꞌu nogoba kauriḡa fuꞌoꞌa feuradu reiro, 'Vaze boro! Vaze boro! Ibiheta vavaofoꞌi!' ");
INSERT INTO ksj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Rehano aneꞌa naenaeziro, 'Eḡeꞌa hube hune ziꞌohe, e za aḡuꞌa.' ");
INSERT INTO ksj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Eꞌanoꞌo tohutohe radoꞌi, mazaḡa eḡeꞌa bare ariteꞌe madaḡaꞌe zaꞌe aḡuꞌa.” ");
INSERT INTO ksj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Badiꞌaꞌa zuhiꞌaziꞌetaꞌaꞌe haba faḡa ragaveꞌeteꞌe vazeḡa ꞌahoga heuḡa. Aniꞌa iḡunirotene, tuḡureḡa azaḡa ane ḡau niduꞌa zenadu faine taufoꞌi rae reiro. ");
INSERT INTO ksj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Zeḡe tibatiba inaraze idunaḡano, ꞌahogaꞌe hadi silivaḡa fuse fuꞌo, ꞌahogaꞌe fuse aheu ebu ꞌahogaꞌe fuse tiba ziniro. Ebu aniꞌa haba faḡa ragaviro. ");
INSERT INTO ksj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Hadi silivaḡa fuseḡa fuꞌo meiroteꞌe vazeḡaꞌe zogone onamadu eꞌe hadiḡa hina gauiro, ebu hadi silivaḡa fuseḡa fuꞌo ragate hidiro. ");
INSERT INTO ksj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Hadi silivaḡa fuseḡa aheu meiroteꞌe vazeḡa zuni ꞌouge haḡadu hadi silivaḡa fuseḡa aheu ragate hidiro. ");
INSERT INTO ksj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Rehano hadi silivaḡa fuseḡa tiba meiroteꞌe vazeḡaꞌe onamadu rahao idu huꞌiro, ebu zuhiꞌaḡa hadi eꞌea gure ꞌuꞌuru tiro. ");
INSERT INTO ksj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Mada faḡa ḡarugano tuḡure azaḡa zuhiꞌazeꞌa bariro. Ebu zeḡeꞌa ane hadi hina nougenouge gauiroteꞌe ederifine huziro. ");
INSERT INTO ksj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Hadi silivaḡa fuseḡa fuꞌo meiroteꞌe vazeḡaniꞌa hadi fuseḡa fuꞌo bare ragate hidirotaꞌaꞌe odohe aradu niro, 'Zuhiꞌa, ḡaꞌa hadi silivaḡa fuseḡa fuꞌo iniro. Ḡianoꞌi, eḡeꞌa hadi eꞌe hina gauadu hadi fuseḡa fuꞌo ragate hidiro.' ");
INSERT INTO ksj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Zuhiꞌaḡaniꞌa niro, 'Manoḡa tauḡi, ḡaꞌe tuḡure vazeḡa manoḡa zu zamaḡo niduꞌa hina gaueꞌeteꞌe vazeḡa! Ḡaeꞌa gau komeꞌa zamaḡo niduꞌa hina faine odohe gauiro ꞌahine, eḡeꞌa ḡau ḡehaḡa taufeꞌeteꞌe vazeḡano ohoꞌiꞌuma. Aroꞌi, zuhiꞌaḡo teite matuꞌihi.' ");
INSERT INTO ksj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ebu hadi silivaḡa fuseḡa aheu meiroteꞌe vazeḡaniꞌa aradu niro, 'Zuhiꞌa, ḡaꞌa hadi silivaḡa fuseḡa aheu iniro. Ḡianoꞌi, eḡeꞌa hadi eꞌe hina gauadu hadi fuseḡa aheu ragate hidiro.' ");
INSERT INTO ksj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Zuhiꞌaḡaniꞌa niro, 'Manoḡa tauḡi, ḡaꞌe tuḡure vazeḡa manoḡa zu zamaḡo niduꞌa hina gaueꞌeteꞌe vazeḡa! Ḡaeꞌa gau komeꞌa zamaḡo niduꞌa hina faine odohe gauiro ꞌahine, eḡeꞌa ḡau ḡehaḡa taufeꞌeteꞌe vazeḡano ohoꞌiꞌuma. Aroꞌi, zuhiꞌaḡo teite matuꞌihi.' ");
INSERT INTO ksj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Rehano hadi siliva fuseḡa tiba meiroteꞌe vazeḡaniꞌa aradu niro, 'Zuhiꞌa, ḡaꞌe vaze riḡa. E ederiro, vazeꞌa ḡoraroteꞌe ḡauḡa ḡaeꞌa hiriveꞌohe, ebu vazeꞌa feune ḡoraroteꞌe ezoneḡa ḡaeꞌa hirive nuꞌoneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Eꞌanoꞌo e ḡa rihoꞌadu rahao gure tiro. Ḡae hadi ꞌahi bare moꞌi.' ");
INSERT INTO ksj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Zuhiꞌaḡaniꞌa naenaeniro, 'Ḡaꞌe tuḡure vazeḡa sauꞌa ebu tubuḡa! Ḡaꞌe vazeꞌa ḡoraroteꞌe ḡauḡa eḡeꞌa hiriveꞌohe ebu vazeꞌa feune ḡoraroteꞌe ezoneḡa eḡeꞌa hirive nuꞌoneꞌohe rae ederirohe? ");
INSERT INTO ksj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ꞌOugirotene, ḡa nougadu hadi tiꞌeteꞌe neḡano eḡe hadi mene tiro? ꞌOugifone, e bare aradu eḡe hadi ufeta ragate meifo.' ");
INSERT INTO ksj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Hena zuhiꞌaḡaniꞌa tuḡure azaḡa ziro, 'Hadi silivaḡa fuseḡa tiba ani mazaonoꞌo bare madu hadi silivaḡa fuseḡa gaubanana meiroteꞌe vazeḡa hanoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Iniuꞌa nagini hidiroteꞌe faine odohe gauine, ani bare ufeta borofe hidiꞌuma. Rehano iniuꞌa nagini hidiroteꞌe mene faine odohe gauine, ani mazao nagini komeꞌa zuni meiniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ebu tuḡure vazeḡa ꞌadiꞌe eḡe veize mene faine gaueꞌeteꞌe vazeḡa ꞌahine, enona uzabo zamaḡano mae feunoꞌi. Eꞌea ani niaꞌuma ebu ḡonoga atitiꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ebu Iesuꞌa reiro, “Vaze Ubuganiꞌa niḡa mae ḡihineꞌenaꞌa, tuḡure viga niduꞌa teite arine, aniꞌe ane ehoro habaꞌa, kini ehoro habaꞌa ḡihiꞌaḡano ehoriꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Aniꞌa habaꞌahabaꞌa azaḡa niduꞌa ane zamao nuꞌozadu mamoe taufeꞌeteꞌe vazeḡaniꞌa mamoeꞌe gouti mazaonoꞌo rovozeꞌeteꞌe teige, ze rovoziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ebu iniu vaze mamoe heuḡaꞌe ane edaꞌe moneo zu iniu vaze gouti heuḡaꞌe ane kauri moneo ohoziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ebu hena kinizeꞌa edaꞌe mone azaḡa ziꞌuma, 'Zaꞌe eḡe Mama mazaonoꞌo manohuga meiroteꞌe azaḡa. Aroꞌi ebu eḡeꞌa zuhiꞌaziꞌeteꞌe habaꞌano radoꞌi. Eꞌe habaꞌaꞌe Badiꞌaꞌa ḡau niduꞌa haḡairoteꞌe madaḡanonoꞌo ruhiniro. ");
INSERT INTO ksj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mazaḡa e vinihirotene zaeꞌa ogomu inido, zu e irinehe moꞌohirotene zaeꞌa vu inido, ebu e iꞌudo vazeḡa reirotene zaeꞌa zae neo huhe zouhido. ");
INSERT INTO ksj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Dabuahe oꞌoꞌa reirotene zaeꞌa dabua inido, zu e ugihirotene zaeꞌa eḡe taufido, ebu e ḡuꞌa neḡano radirotene zaeꞌa ḡiahi ariro.' ");
INSERT INTO ksj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ebu duduḡa azaḡaniꞌa naenaeniꞌuma, 'Zuhiꞌa Boro, eme naniꞌa ḡaꞌe viniꞌiroteꞌe horo'adu ogomu ḡanido? Naniꞌa eme ḡaꞌe irigo moꞌoꞌiroteꞌe horoꞌadu vu ḡanido? ");
INSERT INTO ksj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Naniꞌa eme ḡaꞌe iꞌudo vazeḡa reiroteꞌe horoꞌadu neo huḡade zouꞌido? Naniꞌa eme dabuaḡo ꞌoꞌoꞌa reiroteꞌe horoꞌadu dabua ḡanido? ");
INSERT INTO ksj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Naniꞌa eme ḡa ugiꞌiroteꞌe ga ḡuꞌa neḡano radiroteꞌe horoꞌadu ḡa ḡiaꞌi amido?' ");
INSERT INTO ksj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ebu kinizeꞌa naenaeziꞌuma, 'Eḡeꞌa hube hune ziꞌohe, zaeꞌa eḡe nego nabudi ꞌahi boꞌaḡano ḡonaga vazeḡa ꞌahoga veize ꞌouge haḡairotaꞌaꞌe eḡe veize haḡairoteꞌe heuḡa.' ");
INSERT INTO ksj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ebu kinizeꞌa vaetadu kauri mone azaḡa ziꞌuma, 'Zaꞌe aduga tuḡutuḡu meiroteꞌe azaḡa, eḡe mazaonoꞌo vaḡinoꞌi, ebu Satani zu ane tuḡure viga niduꞌa veize ruhiniroteꞌe ire rogaḡa radiu tuḡutuḡu zamaḡa diuḡoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mazaḡa e vinihirotene zaeꞌa ogomu mene inido, zu e irinehe moꞌohirotene zaeꞌa vu mene inido. ");
INSERT INTO ksj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","E iꞌudo vazeḡa reirotene zaeꞌa neo mene huhe zouhido, zu e dabuahe oꞌoꞌa reirotene zaeꞌa dabua mene inido, ebu e ugihirotene zu ḡuꞌa neḡano radirotene, zaeꞌa e mene taufido.' ");
INSERT INTO ksj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ꞌOugadu zeꞌa naenaeniꞌuma, 'Zuhiꞌa Boro, naniꞌa eme ḡaꞌe viniꞌiroteꞌe ga irigo moꞌoꞌiroteꞌe ga iꞌudo vazeḡa reiroteꞌe ga dabuaḡo ꞌoꞌoꞌa reiroteꞌe ga ugiꞌiroteꞌe ga ḡuꞌa neḡano radiroteꞌe horoꞌadu mene danaꞌido?' ");
INSERT INTO ksj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ebu kinizeꞌa naenaeziꞌuma, 'Eḡeꞌa hube hune ziꞌohe, ꞌahi azaḡa boꞌaḡano ḡonaga vazeḡa ꞌahoga veize mene haḡairotaꞌaꞌe eḡe veize mene haḡairoteꞌe heuḡa.' ");
INSERT INTO ksj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Eꞌanoꞌo kauri mone azaḡaꞌe aduga tuḡutuḡu hidiꞌuma, u duduḡa azaḡaꞌe ḡabone tuḡutuḡu hidiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iesuꞌa ḡoere eꞌe niduꞌa rae hauḡirotene, ane tahiꞌatahiꞌa ziro, ");
INSERT INTO ksj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Zaꞌe edeḡa, mada aheu enogano Iḡine Modiroteꞌe Muiḡa meꞌuma ebu Vaze Ubugaꞌe satauronoga veize agire ꞌevora riꞌiniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Eꞌe madaḡano dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu vaze boroboroꞌa dibuꞌo vazeḡa ḡihiꞌaḡa, niḡa Kaiafa neo nuꞌoraro. ");
INSERT INTO ksj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ebu ze Iesu soꞌonadu obone teadu manoga veize ibiḡa ḡoꞌane vaḡiro. ");
INSERT INTO ksj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Rehano ze zeḡeꞌa bare reiro, “Iḡine Modiroteꞌe Muiḡa madaḡanoꞌe mene idaḡa, mazaḡa vaze ḡuḡuvaḡaniꞌa utitofiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iesuꞌe Betania neḡano ibite referaꞌa meiroteꞌe vazeḡa, niḡa Simona neo radiunu. ");
INSERT INTO ksj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Aniꞌa ogomu fataḡa zamao tave ehoreꞌenaꞌa ogauꞌeteꞌe zamaḡano, roḡae ꞌahoganiꞌa dehoro hohoḡa manoḡa naeḡa boroꞌe bioḡa komeꞌa manohuga iriꞌavonadu mae ariro, ebu Iesu vadinio beuꞌiro. ");
INSERT INTO ksj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Iesu tahiꞌatahiꞌaꞌa eꞌe horonirotene, ze maḡune rudaro ebu niro, “Nougadu dehoro hohoḡa ꞌahiꞌe mode hauḡeha? ");
INSERT INTO ksj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aꞌe hadi boro hina seronadu zahara azaḡa zinifo.” ");
INSERT INTO ksj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Iesuꞌa eꞌe horonadu ziro, “Za nougadu roḡae ꞌadi aduga hauꞌohe? Aniꞌe eḡe veize manohuga haḡaeha. ");
INSERT INTO ksj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Zahara azaḡaꞌe iḡaiḡa zae teite radiꞌuma, u eꞌe iḡaiḡa zae teite mene radiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Aniꞌe eḡeꞌa rudanadu guriteꞌe madaḡa ruhiboga veize dehoro hohoḡa eḡe ahiri rana beuꞌeha. ");
INSERT INTO ksj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Eḡeꞌa hube hune ziꞌohe, raha niduꞌa zamaḡano noꞌe habaꞌano hari manoḡa haramine, aniꞌa haḡateꞌe haḡaiḡa ꞌahi meꞌodadu ani zamariꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Eꞌe enogano Iesu tahiꞌaḡa gaubanana aheu fare boꞌaḡano tahiꞌa ꞌahoga, Isakariota vazeḡa Iudaꞌa dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa vaḡe onamiro, ");
INSERT INTO ksj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ebu ḡadiziro, “E Iesu zae ꞌevoreo riꞌinine, za nagini iniꞌuma?” ꞌOugirotene ze hadi silivaḡa 30 meꞌodadu haro. ");
INSERT INTO ksj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Eꞌe madaḡanonoꞌo aniꞌa Iesu zeḡe ꞌevoreo riꞌinoga veize mada manoḡa ꞌahoga vaḡiro. ");
INSERT INTO ksj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Isiti Oꞌoꞌa ꞌUvahuḡa Odoga Muiḡa zamaḡano mada ibiꞌaꞌe Iḡine Modiroteꞌe Muiḡa. Eꞌe madaḡa meirotene, Iesu tahiꞌatahiꞌaꞌa ane vaḡe aradu ḡadiniro, “Ḡa urao eme Iḡine Modiroteꞌe Muiḡa ogomuḡaꞌe nouma ruhibe tiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Aniꞌa naenaeziro, “Ne boro diuḡadu vaze ꞌahoga vaḡoꞌi ebu noꞌi, 'Ihore vazeḡaniꞌa ꞌahige raꞌohe: Eḡe mada ꞌai haniteha. E eḡe tahiꞌatahiꞌa teite ḡae neo Iḡine Modiroteꞌe Muiḡa ogomuḡa au tiburaꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Eꞌanoꞌo Iesu tahiꞌatahiꞌaꞌe Iesuꞌa ziroteꞌe idunaḡano Iḡine Modiroteꞌe Muiḡa ruhibe tiro. ");
INSERT INTO ksj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ḡoravararotene, Iesuꞌa ane tahiꞌa gaubanana aheu fare teite ogomu fataḡa babaḡano ehoriro. ");
INSERT INTO ksj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ebu ze ogauꞌeteꞌea Iesuꞌa ziro, “Eḡeꞌa hube hune ziꞌohe, zae boꞌaḡano vaze ꞌahoganiꞌa eḡe revoniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ebu ze zamaze adudanadu zeḡezeḡeꞌa Iesu ḡadiniro, “Zuhiꞌa Boro, eꞌe mene, ineo?” ");
INSERT INTO ksj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Aneꞌa naenaeziro, “Eḡe teite idaḡa siuvao ꞌevoꞌa tare auꞌeteꞌe vazeḡaniꞌa revoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Vaze Ubuga moneo Buka Zaḡoḡano mirihiroteꞌe idunaḡano Vaze Ubuganiꞌa rudaꞌuma. Rehano ani revohatiteꞌe vazeḡaꞌe aduga boro hidiꞌuma. Aniꞌe mene furerafone ufeta manoḡa reifo.” ");
INSERT INTO ksj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ebu ani revohatiteꞌe vazeḡa, Iudaꞌa niro, “Ihore vazeḡa, eꞌe mene, ineo?” Iesuꞌa naenaeniro, “Aꞌe ḡae.” ");
INSERT INTO ksj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ze ogauꞌeteꞌe zamaḡano, Iesuꞌa ꞌuvahu odoga madu kuraro ebu vahegadu ane tahiꞌatahiꞌa ziniro. Ebu aniꞌa ziro, “ꞌAdi madu anoꞌi. ꞌAdiꞌe eḡe ahiri.” ");
INSERT INTO ksj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ebu aniꞌa vaini vuḡa bioḡa madu kuraroteꞌe ḡarugano ziniro. Ebu aniꞌa ziro, “Zae niduꞌa, ꞌahi gagoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Vaini vuḡa bioḡa ꞌadiꞌe eḡe ru. Aꞌe eḡeꞌa vaze ḡehaḡa haḡaize sauꞌa rae modoga veize ruhe beꞌunadu ohoneꞌeteꞌe ḡoitore ḡoeꞌa. ");
INSERT INTO ksj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Eḡeꞌa ziꞌohe, eꞌe vaini vuḡa mene bare gagiꞌuma, onamo eḡe Mamaꞌa zuhiꞌaziꞌeteꞌe madaḡano zae teite vaini vuḡa iziga gagiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ebu ze bada ꞌahoga mae hauḡadu Olivi Maḡa onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ebu Iesuꞌa ane tahiꞌatahiꞌa ziro, “Izidi ohere zae niduꞌa eḡe muhihe feraꞌuma. Mazaḡa Buka Zaḡoḡano ꞌahige rae mirihiro, 'Badiꞌaꞌa mamoe taufeꞌeteꞌe vazeḡa mau runiꞌuma, ebu mamoeḡaꞌe ferau ḡouriꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Rehano eḡeꞌa runeonoꞌo bare ḡaboditeꞌe enogano zae zamao Galilea habaꞌa onamiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peteroꞌa Iesu niro, “Vaze niduꞌa ferau muhiꞌiꞌuma rehano, eꞌe mene hune ferau muhiꞌiꞌuma!” ");
INSERT INTO ksj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iesuꞌa naenaeniro, “Eḡeꞌa hube hune ḡaꞌohe, izidi ohere ꞌizema kokorokuꞌa uganogano ḡaeꞌa ḡae uḡidu eḡe oꞌohiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Rehano Peteroꞌa niro, “E mene oꞌoꞌiꞌuma. Ḡae teite rudaune zuni idaḡa!” Ebu ane tahiꞌaḡa niduꞌa zuni ꞌouge reiro. ");
INSERT INTO ksj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ebu Iesuꞌa ane tahiꞌatahiꞌa teite haba ꞌahoga, niḡa Getesemane onamadu ziro, “ꞌAda ehore radoꞌi, u eꞌe kuranoga veize ꞌomo onamiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ebu aniꞌe Petero ebu Zebedeo ubuga aheu, Iakobo zu Ioane tutuze onamiro. Ani zamaḡa ḡadahe ariro zu adudaro. ");
INSERT INTO ksj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ꞌOugadu aniꞌa ziro, “Zamahe are rudauꞌohe. Zaꞌe ꞌada radadu eḡe teite evate radoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ebu ani tahiḡa faḡa onamiro zu rahao ḡuḡuradu kuraro, “Eḡe Mama, ḡa idaḡa roꞌidene, eḡe mazaonoꞌo bio aduga ꞌadi mae vaḡinoꞌi. Rehano eḡe mene urao, ḡae urao daꞌo haḡaoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ebu Iesuꞌa ane tahiꞌatahiꞌa vaḡe bare arirotene, ze bazeꞌeteꞌe horoziro. Ebu aniꞌa Petero niro, “Za mada tahiḡa zuni eḡe teite evate radoga mene idaḡahe? ");
INSERT INTO ksj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Sataniꞌa tuhuzadu zaeꞌa mene uitifine tohutohoꞌi zu kuranoꞌi. Zamazeꞌe urateꞌohe, rehano ahirizeꞌe taoḡa.” ");
INSERT INTO ksj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ebu Iesuꞌa bare onamadu ḡae aheuḡano kuraro, “Eḡe Mama, e bio ꞌahi hube hune gage huniꞌuma roꞌidene, ḡae ura haḡaoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Aniꞌa bare arirotene, ze bare bazeꞌeteꞌe horoziro, mazaḡa ubumazeꞌa ufeta anoziro. ");
INSERT INTO ksj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Aniꞌa ze muhizadu bare onamiro ebu ibite kuraroteꞌe teige ḡae uḡiduḡano bare kuraro. ");
INSERT INTO ksj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ebu Iesuꞌa ane tahiꞌatahiꞌa vaḡe bare aradu ziro, “Za ꞌize bazeꞌehe zu ahirize ohoneꞌehe? Ḡiꞌanoꞌi, madaḡa ꞌai maha, ebu Vaze Ubugaꞌe haḡai sauꞌa azaḡa ꞌevoreo riꞌiniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Iḡunadu onamihi. Ḡianoꞌi, eḡe revoniteꞌe vazeḡa ꞌai feureha.” ");
INSERT INTO ksj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iesuꞌa ꞌize ḡoereꞌeteꞌea, Iesu tahiꞌa gaubanana aheu fare boꞌaḡano ꞌahoga, Iudaꞌa feuriro. Dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu vaze boroboroꞌa tuḡuziroteꞌe azaḡa ḡuḡuvaḡaniꞌa benisi zu somori boro madu Iuda teite ariro. ");
INSERT INTO ksj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ebu Iesu revoharoteꞌe vazeḡaꞌe aneꞌa nougenouge haḡaiteꞌe moneo ibite ihoziro, “Eḡeꞌa furaꞌiniteꞌe vazeḡaꞌe Iesu. Ani obone toꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ebu aniꞌa zogone Iesu vaḡe onamadu niro, “Ihore vazeḡa! Manoḡahe?” Ebu aniꞌa furaꞌiniro. ");
INSERT INTO ksj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iesuꞌa niro, “Eḡe vaze, ḡa ꞌahao nagini haḡaiteꞌe haḡaiḡa haḡaoꞌi.” Ebu Iuda teite ariroteꞌe azaḡaniꞌa onamadu Iesu obone tiro. ");
INSERT INTO ksj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Eꞌe madaḡano Iesu ḡati vazeḡa ꞌahoganiꞌa benisiḡa ahase bunadu dibuꞌo vazeḡa ḡihiꞌaḡa tuḡure vazeḡa udirotene teḡaḡa variꞌe butiro. ");
INSERT INTO ksj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ꞌOugadu Iesuꞌa niro, “Benisiḡo bare iḡuꞌano ofoꞌi! Benisi hina vaze matihi raꞌeteꞌe azaḡaꞌe zeḡe zuni benisi uꞌano rudaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Eḡeꞌa Mamahe uminine, aneꞌa tuḡure viga ḡehaḡa bagaḡa zogone tuḡuzadu emeḡe biriꞌuma. Za eḡeꞌa ꞌouge uminoga idaḡa rae mene zamareꞌehe? ");
INSERT INTO ksj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Rehano e ꞌougine, Buka Zaḡoḡano eḡe mazao ꞌahiguḡaniꞌa fureraꞌuma rae reiroteꞌe ḡoeꞌaniꞌa mene hudaꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ebu Iesuꞌa vaze ḡuḡuvaḡa ziro, “Zaꞌe ḡonore vazeḡa obone tiꞌeteꞌe teige, benisi ebu somori boro madu eḡe obohe touga veize arahe? Mada niduꞌa eꞌe kuru neḡa habaꞌano ihore radiunu. Eꞌe madaḡano zaꞌe mene obohe tiro. ");
INSERT INTO ksj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Rehano peroveta azaḡaniꞌa mirihiroteꞌe ḡoeꞌaniꞌa hudafine ꞌahiguḡaniꞌa fureraneha.” ꞌOugirotene ane tahiꞌatahiꞌa niduꞌaꞌe Iesu muhine feraro. ");
INSERT INTO ksj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ebu Iesu obone tiroteꞌe azaḡaniꞌa dibuꞌo vazeḡa ḡihiꞌaḡa Kaiafa vaḡe tutune onamiro. Eꞌea Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zu vaze boroboroꞌa nuꞌoranadu radiunu. ");
INSERT INTO ksj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","U Peteroꞌe faḡanonoꞌo Iesu hegotadu dibuꞌo vazeḡa ḡihiꞌaḡa ne habaꞌano feuriro. Ebu naginiꞌa fureratiteꞌe ḡianoga veize ne habaꞌa diuḡadu eꞌe neḡa ḡianeꞌeteꞌe azaḡa teite ehoriro. ");
INSERT INTO ksj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu Iuda azaḡa nuꞌonuꞌo boro azaḡaniꞌa Iesu manoga veize ani moneo ḡuriro ḡoeꞌaḡoeꞌa vaḡiro. ");
INSERT INTO ksj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ebu vaze ḡehaḡaniꞌa aradu Iesu moneo ḡuriro ḡoeꞌa rae fureniro, rehano ze ani veꞌoḡaꞌe mene horoniro. Ḡonagano vaze aheuꞌa iḡune edaro. ");
INSERT INTO ksj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ebu ze ꞌahige rae fureniro, “Vaze ꞌadaꞌa raenaꞌa, 'Eḡeꞌa Badiꞌa kuru neḡa fahadu mada uḡidu zamaḡano bare ogoranogaꞌe idaḡa,' rae reiro.” ");
INSERT INTO ksj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ꞌOuge reirotene, dibuꞌo vazeḡa ḡihiꞌaḡaniꞌa edau iḡunadu Iesu niro, “Zeꞌa ḡaꞌe veꞌoḡa rae fureneꞌohe. Ḡa zeḡe ḡoere mene naenaeniꞌumahe?” ");
INSERT INTO ksj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Rehano Iesuꞌe sifu radiro. Dibuꞌo vazeḡa ḡihiꞌaḡaniꞌa niro, “E ḡabode radiuꞌeteꞌe Badiꞌaḡa niḡano riḡa ḡadimuꞌohe. Ḡaꞌe Keriso, Badiꞌa Ubuga ga mene? Efoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Iesuꞌa naenaeniro, “Oꞌe, ḡaeꞌa eꞌe Keriso rae raha. Rehano eḡeꞌa zae niduꞌa ziꞌohe, zama moneo Vaze Ubugaꞌe Gigiꞌa Boro Badiꞌaḡa edaꞌe moneo ehoradu zuhiꞌaziteꞌe zu adureo ḡoze hina ariteꞌe horoniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ꞌOuge reirotene, dibuꞌo vazeḡa ḡihiꞌaḡaniꞌa dabuaḡa zegadu ziro, “Vaze ꞌadiꞌe Badiꞌa rae sausauneha! Eme aniꞌe veꞌoḡa rae raꞌeteꞌe vazeḡa bare vaḡiꞌumahe? Izidi aniꞌa Badiꞌa rae sausaunateꞌe zae niduꞌa egeha. ");
INSERT INTO ksj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Zaꞌe nouge rae zamareꞌohe?” Zeꞌa naenaeniro, “Ani runeo tuḡuniꞌuma!” ");
INSERT INTO ksj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ebu zeꞌa Iesu iraḡa rana soꞌabide vaniro zu ꞌevoreze hina bouniro. Vaze nuꞌa ubumaḡa dabua hina ꞌuadu faꞌone arahiro, ");
INSERT INTO ksj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Keriso, efoꞌi. Iniuꞌa faꞌoꞌeha?” ");
INSERT INTO ksj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ebu Peteroꞌa dibuꞌo vazeḡa ḡihiꞌaḡa ne habaꞌano ehore radiroteꞌea, tuḡure roḡaeḡa ꞌahoganiꞌa ane uꞌa aradu niro, “Ḡae zuni Galilea vazeḡa Iesu teite radiunu.” ");
INSERT INTO ksj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Rehano Peteroꞌa zeḡe niduꞌa zamao oꞌoniro, “E ḡaꞌa nagini raꞌetaꞌaꞌe aḡuꞌa.” ");
INSERT INTO ksj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ebu Peteroꞌa ne ḡabiriḡa ibihetaḡa uꞌa onamirotene, tuḡure roḡaeḡa ꞌahoganiꞌa horonadu eꞌea radiunuteꞌe azaḡa ziro, “ꞌAdiꞌe Nazareta vazeḡa Iesu teite radiunu.” ");
INSERT INTO ksj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ebu Peteroꞌa bare oꞌonadu ḡoere rinede tiro, “Eꞌe vaze aꞌaꞌe aḡuꞌa!” ");
INSERT INTO ksj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mada tahiḡa enogano eꞌea edau radiunuteꞌe azaḡaniꞌa Petero vaḡe aradu niro, “Hube hune ḡa zu Iesu duḡuru boꞌaḡano ꞌahoga, mazaḡa ḡae ago iraḡaꞌe Galilea habaꞌa ago iraḡa.” ");
INSERT INTO ksj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ebu ani ḡoere rinede teadu reiro, “E ḡuririne aduga hidiꞌuma! E vaze aꞌe aḡuꞌa!” Ani Ꞌouge reirotene, kokorokuꞌa ugaro. ");
INSERT INTO ksj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ebu Peteroꞌe Iesuꞌa ꞌahige rae niroteꞌe zamariro, “Kokorokuꞌa ꞌizema uganogano ḡaeꞌa eḡe ḡae uḡidu oꞌohiꞌuma.” Ebu aniꞌa ne enogano buanadu niau rudaro. ");
INSERT INTO ksj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Oherebau uzeuze dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu vaze boroboroꞌa nuꞌoranadu Iesu manoga veize ḡoere idaniro. ");
INSERT INTO ksj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ze ani autadu Roma gavana vazeḡa Pilato vaḡe tutune onamiro ebu ane ꞌevora riꞌiniro. ");
INSERT INTO ksj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Iesu revoharoteꞌe vazeḡa Iudaꞌa Iesuꞌe runeo tuḡuniꞌuma rae reiroteꞌe ḡoeꞌa igirotene, ani haḡaiḡa sauꞌa uꞌano aneꞌa bare zamaḡaniꞌa adudaro. Eꞌanoꞌo siliva hadiḡa 30 madu dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu vaze boroboro bare ziniro. ");
INSERT INTO ksj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ebu aneꞌa ziro, “E haḡai sauꞌa haḡaeha, mazaḡa eḡeꞌa haḡai sauꞌa oꞌoꞌa vazeḡa revohanadu ani runeo tuḡuneha.” ꞌOugadu zeḡeꞌa niro, “Aꞌe emeḡeꞌa mene haḡaeha, rehano ḡaeꞌa bare haḡaeha. Ḡae edeḡano haḡaoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ꞌOugirotene, Iudaꞌa kuru neḡa zamaḡano hadiḡa feuniro ebu onamadu aneꞌa bare bodane runiro. ");
INSERT INTO ksj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡaniꞌa hadiḡa madu reiro, “Hadi ꞌadiꞌe vaze matihi radu haroteꞌe hadiḡa ꞌahine, kuru neḡa hadiḡa teite tibune tougaꞌe mene idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Zeḡeꞌa ꞌouge ḡoꞌaniroteꞌe enogano, eꞌe hadiḡa hina ḡoḡore haḡaeꞌeteꞌe vazeḡa haba ꞌahoga hoitadu eꞌe habaꞌano avoꞌa azaḡa guriꞌuma rae reiro. ");
INSERT INTO ksj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Eꞌanoꞌo haba aꞌe Ru Habaꞌa rae hunadu izidi zuni deꞌuge rae huneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ꞌOugadu Badiꞌaꞌa peroveta vazeḡa Ieremiaonoꞌo reiroteꞌe ḡoeꞌaniꞌa hudaro, “Zeḡeꞌa siliva hadiḡa 30 meiro. Aꞌe Isaraela azaḡaniꞌa vaze eꞌe naeḡa rae ohoniroteꞌe hadiḡa. ");
INSERT INTO ksj_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ebu Zuhiꞌa Boroꞌa ihiroteꞌe teige, zeꞌa hadi eꞌe hina ḡoḡore haḡaeꞌeteꞌe vazeḡa haba hoitiro.” ");
INSERT INTO ksj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ebu Iesuꞌe Roma gavana vazeḡa Pilato zamao edau radiro. Ebu Pilatoꞌa Iesu ḡadiniro, “Ḡaꞌe Iuda azaḡa kinihe?” Iesuꞌa naenaeniro, “Oꞌe, ḡa ḡaeꞌa bare eꞌe kini rae raha.” ");
INSERT INTO ksj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Rehano dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu vaze boroboroꞌa Iesuꞌe veꞌoḡa rae riḡa ḡoerirotene, Iesuꞌe mene naenaeziro. ");
INSERT INTO ksj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Hena Pilatoꞌa ḡadiniro, “Zeꞌa ḡaꞌe veꞌoḡa rae raꞌeteꞌe ḡoeꞌa ḡehaḡa rae fureneꞌohe. Ḡa mene igiꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Rehano Iesuꞌa zeḡe ḡoere tiba zuni mene naenaeziro. ꞌOugadu Pilatoꞌa zaguzagau huniro. ");
INSERT INTO ksj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Iḡine Modiroteꞌe Muiḡa madaḡano Roma gavana vazeḡaꞌe Iuda azaḡaniꞌa urateꞌeteꞌe ḡuꞌa vazeḡa ꞌahoga tuḡune bunido. ");
INSERT INTO ksj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Eꞌe madaḡano ḡuꞌa neḡano vaze ꞌahoga, niḡa Barabasiꞌa radiunu. Vaze niduꞌa ani ederiro. ");
INSERT INTO ksj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Vaze ḡuḡuvaḡaniꞌa nuꞌorarotene, Pilatoꞌa ḡadiziro, “Za uraꞌe eḡeꞌa iniu tuḡune buniꞌuma, Barabasi ga Keriso raꞌeteꞌe vazeḡa Iesu?” ");
INSERT INTO ksj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Mazaḡa Pilatoꞌe zeꞌa Iesu ahiahiniroteꞌe uꞌano, ani riꞌinirotaꞌaꞌe ederiro. ");
INSERT INTO ksj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatoꞌa kota habaꞌano ehorinuteꞌe zamaḡano inuganiꞌa ani veize ḡoere tuḡuriro, “Ḡa veꞌoḡa oꞌoꞌa vazeḡa eꞌe mazao haḡai sauꞌa ꞌahoga ago haḡaoꞌi. Eꞌe ohoḡore ohere iḡunao ani uꞌano zamaheꞌa ufeta adudaneha.” ");
INSERT INTO ksj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Rehano dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu vaze boroboroꞌa Barabasi tuḡune bunadu Iesu manoga veize vaze ḡuḡuvaḡaniꞌa Pilato uminoga tuḡutuḡuziro. ");
INSERT INTO ksj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilatoꞌa ḡadiziro, “Vaze aheu boꞌaḡano zaꞌe eḡeꞌa iniu tuḡune bunoga urateꞌohe?” Zeḡeꞌa naenaeniro, “Barabasi!” ");
INSERT INTO ksj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ebu Pilatoꞌa ḡadiziro, “Tena e Keriso raꞌeteꞌe vazeḡa Iesu mazaoꞌe nougiꞌuma?” Zeḡe niduꞌa niro, “Aniꞌe Satauronoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatoꞌa ḡadiziro, “Nougadu? Ani haḡai sauꞌa nagiga haḡairo?” Rehano zeḡeꞌa ufeta ḡihau huaro, “Satauronoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatoꞌe Iesu veize gauni ꞌahoga haḡaogaꞌe mene idaḡa reirotaꞌaꞌe ederiro. Ebu vaze ḡuḡuvaḡaniꞌa ufeta maḡune haraeꞌeteꞌe horonirotene, zeḡe ubumao vu tahiḡa madu ꞌevoꞌa vuzuꞌiro ebu ziro, “E vaze ꞌahaꞌa rudatiteꞌe moneo veꞌoḡa ꞌahoga mene haḡaeha. Zae daꞌo eꞌe naeḡa moꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ꞌOugadu vaze niduꞌa naenaeniro, “Ani rudaune, eꞌe naeḡaꞌe emeḡe zu marigafeꞌa meꞌuma!” ");
INSERT INTO ksj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Eꞌanoꞌo aniꞌe zeḡe veize Barabasi ḡuꞌa neḡanonoꞌo tuḡune buniro, rehano Iesuꞌe masiniroteꞌe enogano satauronoga veize uti azaḡa ꞌevoreo riꞌiniro. ");
INSERT INTO ksj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gavana uti azaḡa nuꞌa Iesuꞌe gavana ne zamaḡa tutune onamiro, ebu uti azaḡa niduꞌa ani zamao huze nuꞌoziro. ");
INSERT INTO ksj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ebu ze Iesu dabua fuhiꞌohanadu dabua kanaḡa duhuḡa hune vidoharo. ");
INSERT INTO ksj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ebu ire ezaga meigameiga ḡurunadu kini vadiga adiriḡa teige vadigano redoharo, zu Gubu somoriḡa edaꞌe ꞌevoꞌano obonoharo. Ebu obenaze hina ani mazao ḡuḡureꞌenaꞌa ḡirihoharo, “Iuda azaḡa kini, nigunihi!” ");
INSERT INTO ksj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ebu ze ani rana soꞌabide vaniro zu Gubu somoriḡa eꞌe madu vadiga rana barebare bouniro. ");
INSERT INTO ksj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ḡirihohau hauḡirotene, ani vidoharoteꞌe dabuaḡa fuhiꞌadu ane dabua bare vidoharo. Ebu satauronoga radu tutune onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Uti azaḡaniꞌa Iesu tutune onamiroteꞌe zamaḡano Kurene vazeḡa ꞌahoga, niḡa Simona hidiro, ebu aniꞌa Iesu satauro herate onamoga veize tuḡutuḡuniro. ");
INSERT INTO ksj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ebu ze Gologota rae huneꞌeteꞌe habaꞌano feuriro (Gologota hugaꞌe Vadini Isiga Haba'a). ");
INSERT INTO ksj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Eꞌea ze vaini vuḡa ḡau ꞌahoga ḡiḡiꞌa bagaḡa teite mirunadu gagoharo. Rehano aneꞌa tahiḡa gage nuradu gagoga mene uratiro. ");
INSERT INTO ksj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Zeḡeꞌa Iesu satauroniroteꞌe ḡarugano kaḡusi arahoḡa arahadu Iesu dabua ḡahugotitiro. ");
INSERT INTO ksj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ebu eꞌea ze ehoradu Iesu ḡiane radiro. ");
INSERT INTO ksj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ze Iesu haḡai sauꞌaꞌe nagini rae ihozifine ane satauro hitagano ꞌahige mirihadu tiro, “ꞌADIꞌE IESU, IUDA AZAḠ KINI.” ");
INSERT INTO ksj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ebu ḡonore azaḡa aheu zuni ani teite satauroziro. ꞌAhogaꞌe ane edaꞌe moneo zu ꞌahogaꞌe ane kauri moneo ikokoziro. ");
INSERT INTO ksj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ebu uhiḡano vitau onamiroteꞌe azaḡaniꞌa vadinize miruneꞌenaꞌa, Iesu rae sausauniro, ");
INSERT INTO ksj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ḡaꞌe kuru neḡa fahadu mada uḡidu zamaḡano bare ohoniꞌuma rae reiroteꞌe vazeḡa. Ḡa ḡaeꞌa bare ḡaboꞌoꞌi! Ḡa Badiꞌa Ubuga roꞌidene, satauronoꞌo buau ovaoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Eꞌe teige, dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa, Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zu vaze boroboroꞌa zuni ḡirihohauꞌenaꞌa ḡoeriro, ");
INSERT INTO ksj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Aniꞌa vaze nunu ḡaboziro, rehano ani aneꞌa bare ḡabonogaꞌe mene idaḡa! Aniꞌe Iuda azaḡa kini, eꞌanoꞌo izidi hune satauronoꞌo bua ovaoꞌi, ꞌougine eme ani mazao fiꞌuma! ");
INSERT INTO ksj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Aniꞌe Badiꞌa mazao fieꞌohe. Eꞌanoꞌo Badiꞌaꞌa uratine izidi ani ḡaboniꞌuma, mazaḡa aneꞌa raenaꞌa, 'E Badiꞌa Ubuga,' rae reiro.” ");
INSERT INTO ksj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Zeḡe teige, Iesu teite idaḡa satauroziroteꞌe ḡonore azaḡaniꞌa zuni ani rae sausauniro. ");
INSERT INTO ksj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Madai kirikiri meirotene, haba niduꞌa uzaboꞌa ꞌuiro, onamo ḡorava mone mada uḡidu. ");
INSERT INTO ksj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ḡorava madaḡa uḡidu meirotene, Iesuꞌa ḡihau huaro, “Eli, Eli, lama sabatani?” Ḡoere eꞌe hugaꞌe, “Eḡe Badiꞌa, eḡe Badiꞌa, ḡa nougadu eḡe modeha?” ");
INSERT INTO ksj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Eꞌea edau radiroteꞌe azaḡa boꞌaḡano nuꞌe ḡoere eꞌe egadu reiro, “Aniꞌa Elia huneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ebu zeḡe boꞌaḡano ꞌahoganiꞌa zogone dure onamadu vu romane zouneꞌeteꞌe ḡauḡa meiro, ebu vaini vuḡa ḡiḡiꞌa iriꞌavonadu Gubu somoriḡa rana tiro, ebu Iesu gagoharo. ");
INSERT INTO ksj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Rehano vaze nuꞌe reiro, “Ani modoꞌi. Eliaꞌa ovadu ḡaboniꞌuma ga mene, ḡianihi.” ");
INSERT INTO ksj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ebu Iesuꞌa agoḡa boro hina bare ḡihau huanadu iriga riꞌiro. ");
INSERT INTO ksj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Eꞌe madaḡano kuru neḡano Haba Zaḡoḡa Hune ꞌueꞌeteꞌe dabuaḡaniꞌa hitaganonoꞌo ꞌuꞌuḡa ḡuzu zigau ꞌaꞌadaro. Ebu rahaꞌa hagariro zu vatavaꞌa ꞌaꞌadanadu bohatu ḡouriro. ");
INSERT INTO ksj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ebu rune iduḡa ꞌaꞌadanadu Badiꞌa mone azaḡa ḡehaḡa ahirizeꞌa ḡabode iḡune ḡouriro. ");
INSERT INTO ksj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ze iduzeonoꞌo buaro, ebu Iesuꞌa bare ḡabodiroteꞌe enogano Ierusalema onamadu vaze ḡehaḡa zamao fureraro. ");
INSERT INTO ksj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Uti vazeḡa boro zu ane teite Iesu ḡiane radiroteꞌe uti azaḡaꞌe rahaꞌa hagariroteꞌe zu naginiꞌa fureraroteꞌe horonirotene, rihau rudanadu reiro, “Vaze ꞌadiꞌe hube hune Badiꞌa Ubuga!” ");
INSERT INTO ksj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Eꞌea roḡae ḡehaḡaniꞌa zuni faḡanonoꞌo ehamu radiro. Zeꞌe Iesu dananoga veize Galilea habaꞌanonoꞌo hegote ariro. ");
INSERT INTO ksj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Zeḡe boꞌaḡano Magadala roḡaeḡa Maria, ebu Iakobo zu Iosefa vize Maria, ebu Zebedeo ubugaubuga Iakobo zu Ioane vizeꞌa radiunu. ");
INSERT INTO ksj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ḡoravararotene, maꞌora vazeḡa, niḡa Iosefaꞌa ariro. Aniꞌe Arimate vazeḡa zu Iesu tahiꞌa ꞌahoga. ");
INSERT INTO ksj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Aniꞌa Pilato vaḡe onamadu Iesu ahiri mouga veize uminiro, ebu Pilatoꞌa ḡoere tuḡuradu Iesu ahiri haro. ");
INSERT INTO ksj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ꞌOugadu Iosefaꞌa Iesu ahiri madu dabua deheḡa manoḡa hina ꞌumiro. ");
INSERT INTO ksj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ebu vatava huꞌiroteꞌe iduḡa, Iosefa ane rune iduḡa iziga zamaḡano Iesu ahiri tiro. Ebu hadi boro hina ibihetaḡano kiune ꞌuadu mode onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","U Magadala roḡaeḡa Maria zu Maria ꞌahogaꞌe iduḡa zama ḡoha ehore radiro. ");
INSERT INTO ksj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Irarirotene, aꞌe Bana Madaḡa. Dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu Farisea azaḡaniꞌa Pilato vaḡe onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ebu ze Pilato niro, “Vaze boro, ḡuriro vazeḡa eꞌeꞌa ꞌize ḡabode radiroteꞌe zamaḡano reiroteꞌe ḡoeꞌa emeꞌa zamareꞌohe. Aniꞌa ꞌahige rae reiro, 'E mada uḡiduḡano bare ḡabode iḡuniꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Eꞌanoꞌo mada uḡidu zamaḡano uti azaḡaniꞌa ani idu faine ḡianoga veize eme umiꞌeꞌohe. Mene ꞌougine, ane tahiꞌatahiꞌaꞌa aradu ani ahiri ḡonotaꞌuma ebu vaze zinaꞌa, 'Aniꞌe bare ḡabode iḡuneha,' rae reꞌuma. ꞌOugine zeꞌa vaze ufeta soꞌoziꞌuma. Aꞌe ibite soꞌozirotaꞌaꞌe vitiniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatoꞌa naenaeziro, “Uti azaḡa nu tutuze onamadu zae edeḡano iduḡa faine ḡiane radoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ꞌOugirotene, ze uti azaḡa teite onamadu iduḡa ibiheta hadiḡa boro faifaine hararo, ebu vazeꞌa mene vavaꞌifine gudune ꞌahoga tiro, ebu uti azaḡaꞌe iduḡa ḡiane radiro. ");
INSERT INTO ksj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Bana Madaḡa ḡarugano fura oherebau uzeuze Magadala roḡaeḡa Maria zu Maria ꞌahoganiꞌa Iesu idu ḡianoga radu onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Eꞌe madaḡano tabara habaꞌa borofe hagariro, ebu Zuhiꞌa Boro tuḡure viganiꞌa adureonoꞌo ovadu idu uhiḡa onamiro, ebu hadiḡa boro kiune vaḡinadu eꞌe rana ehoriro. ");
INSERT INTO ksj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ani iraḡaꞌe viriꞌa fuꞌuradu vazavazaheꞌeteꞌe teigiro ebu dabuaḡaꞌe ḡoze teige ꞌuraro. ");
INSERT INTO ksj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Idu ḡianeꞌeteꞌe azaḡaꞌe ani horonadu rihau rudaro ꞌahine, rereraro ebu rune azaḡa teigiro. ");
INSERT INTO ksj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ebu tuḡure viganiꞌa roḡae aheu ziro, “Ago rihanoꞌi. Eḡe edeḡa, zaꞌe satauroniroteꞌe vazeḡa Iesu vaḡeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Aniꞌe ꞌahao oꞌoꞌa, rehano aniꞌa reiroteꞌe teige bare ḡabodeha. Aroꞌi ebu aniꞌa bazateꞌe habaꞌa ḡianoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ebu za ḡarihe onamadu ane tahiꞌatahiꞌa ꞌahige zoꞌi, 'Aniꞌe rune azaḡa boꞌaḡano bare ḡabodeha. Aniꞌe zae zamao Galilea habaꞌa ibite onamiꞌuma ebu eꞌea za ani horoniꞌuma.' Eḡeꞌa zeateꞌe ḡoeꞌa faine ihozoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Eꞌanoꞌo roḡaeroḡaeꞌe rihozeta zu matuꞌuzeta iduonoꞌo ḡarihe iḡunadu Iesu tahiꞌatahiꞌa zouga veize zeḡe vaḡe dure onamiro. ");
INSERT INTO ksj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Eꞌe madaḡano Iesuꞌa tabara zeḡe mazao fureranadu ziro, “Zaꞌe manoḡahe?” ꞌOuge reirotene, ze ani uhiḡa onamiro zu odaḡa obonadu ani mazao kuraro. ");
INSERT INTO ksj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ebu Iesuꞌa ziro, “Ago rihanoꞌi. Onamadu eḡe tahiꞌatahiꞌa ꞌahige rae zoꞌi, 'Galilea habaꞌa onamoꞌi.' Eꞌea ze eḡe horohiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Roḡaeroḡaeꞌa onamiroteꞌea, Iesu idu ḡiane radiroteꞌe uti azaḡa boꞌaḡano nuꞌa ne boro diuḡadu naginiꞌa fureraroteꞌe hariḡa dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa meꞌodoziniro. ");
INSERT INTO ksj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡaniꞌa vaze boroboro teite nuꞌoranadu ḡoꞌaniro, ebu iduḡa ḡiane radiroteꞌe uti azaḡa hadi boro zenadu, ");
INSERT INTO ksj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ꞌahige rae ziro, “Zaꞌe ꞌahige rae roꞌi, 'Iesu tahiꞌatahiꞌaꞌa ohere aradu eme bazuꞌenona ani ahiri ḡonotu feraneha.' ");
INSERT INTO ksj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ꞌAhi hariḡa gavana vazeḡaniꞌa igine, emeḡeꞌa zae veize ani mazao faine ḡoeriꞌuma ebu zaꞌe aduga ꞌahoga mene hidiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Eꞌanoꞌo iduḡa ḡiane radiroteꞌe uti azaḡaniꞌa hadi madu zeḡeꞌa ziroteꞌe idunaḡano ḡoeriro. Ebu eꞌe hariḡaniꞌa Iuda azaḡa mazao bororaro zu izidi madaḡano zuni vazeꞌa ꞌouge raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ebu Iesu tahiꞌa gaubanana tiba fareꞌa Galilea habaꞌa onamadu aniꞌa ihoziroteꞌe maḡano feuriro. ");
INSERT INTO ksj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Feurirotene, ze ani horonadu ani mazao kuraro. Rehano nuꞌe zamaze ꞌadaꞌadaziro. ");
INSERT INTO ksj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ebu Iesuꞌa zeḡe vaḡe aradu ziro, “Adure zu raha gigiꞌaḡa niduꞌaꞌe eḡe iniro. ");
INSERT INTO ksj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Eꞌanoꞌo zaꞌe onamadu habaꞌahabaꞌa azaḡa niduꞌa eḡe tahiꞌatahiꞌa rouga veize zamazoꞌi. Moga, Ubuga zu Vine Zaḡoḡa niḡano babatisozoꞌi, ");
INSERT INTO ksj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ebu eḡeꞌa haḡaoꞌi rae ziroteꞌe ḡoeꞌa niduꞌa zeḡeꞌa hegotoga veize ihozoꞌi. Ḡianoꞌi, eḡeꞌa iḡaiḡa zae teite radiuꞌohe zu radiꞌuma onamo mada ḡonaga.” ");
INSERT INTO ksj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Badiꞌa Ubuga, Iesu Keriso hari manoḡaꞌe ꞌahige ḡadahiro. ");
INSERT INTO ksj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Peroveta vazeḡa Isaiaꞌa Buka Zaḡoḡano ꞌahige rae mirihiro, “Ḡianoꞌi, eḡeꞌa eḡe ḡoere odohe onamiteꞌe vazeḡa ꞌahoga ḡae zamao ibite tuḡuniꞌuma. Aniꞌe ḡae veize ibiḡo ruhibiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Vaze ꞌahoganiꞌa haba bohaꞌano huauꞌohe, 'Zuhiꞌa Boro veize ibi ruhiboꞌi, ebu ani veize ibi mae dudunoꞌi.'” ");
INSERT INTO ksj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ebu Ioane Babatisoꞌa haba bohaꞌano aradu ꞌahige haramiro, “Haḡaize sauꞌanonoꞌo ḡihuradu babatiso moꞌi! ꞌOugine, Badi'a'a haḡaize sau'a rae modiꞌuma!” ");
INSERT INTO ksj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ebu Iudea habaꞌa azaḡa niduꞌa zu Ierusalema azaḡa niduꞌa ani vaḡe onamiro. Ebu haḡaize sauꞌa rae furenadu Ioaneꞌa Ioridana vuḡano babatisoziro. ");
INSERT INTO ksj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ioaneꞌe kamelo iguḡa hina haḡairoteꞌe dabuaḡa vidaro, zu mani ogaḡa miniḡa hina gabaꞌiḡano utiro, ebu fihore zu butu ꞌavoreḡa godaga aro. ");
INSERT INTO ksj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ebu aniꞌa ꞌahige haramoziro, “Eḡe ḡaruna ariteꞌe vazeḡa inaraḡaꞌe ufeta ḡihiꞌaḡa zu eḡe vitihoga. Eḡe'a ḡuḡuradu ani tamaka miniḡa fuhiꞌeꞌeteꞌe tuḡureḡa vazeḡano rouga zuni mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Eꞌe vu hina babatisoziꞌohe, rehano aniꞌe Vine Zaḡoḡa hina babatisoziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Eꞌe madaḡano Iesuꞌa Galilea habaꞌa Nazareta neḡanonoꞌo aradu Ioaneꞌa Ioridana vuḡano Iesu babatisoniro. ");
INSERT INTO ksj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Iesuꞌa vuonoꞌo gaba tire onamirotene, adureꞌa ꞌaꞌadaroteꞌe zu Vine Zaḡoḡaniꞌa Tubugo niniḡa teige ani vaḡe ovairoteꞌe horoniro. ");
INSERT INTO ksj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ebu adureonoꞌo ago ꞌahoganiꞌa ꞌahige rae reiro, “Ḡa'e eḡe zamarone ubude. Eḡeꞌa ḡae uꞌano, matu'e rudau'ohe.” ");
INSERT INTO ksj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ebu hena zogone Vine Zaḡoḡaniꞌa Iesu tutune haba bohaꞌa onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ebu haba bohaꞌano mada 40 zamaḡano Sataniꞌa Iesu tuhuniro. Ani butu maniḡa teite radiro zu tuḡure vigaviganiꞌa ani taufiro. ");
INSERT INTO ksj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ioaneꞌe ḡuꞌa neḡano ohoniroteꞌe enogano Iesuꞌa Galilea habaꞌa onamadu Badiꞌa hari manoḡa harame ragaviro. ");
INSERT INTO ksj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Aniꞌa ꞌahige haramiro, “Madaꞌe areha. Badiꞌaꞌa zuhiꞌaziꞌeteꞌe madaḡaniꞌa haniteha. Ḡihuroꞌi ebu hari manoḡa mae ḡihinoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Iesuꞌa Galilea duꞌuraḡa genaḡano onameꞌenogano, Simona ebu negoḡa Andereaꞌa duꞌurao reꞌeva feuneꞌeteꞌe horoziro. Zeꞌe ḡozone mauꞌeteꞌe azaḡa. ");
INSERT INTO ksj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ebu Iesuꞌa ziro, “Eḡe ḡaruna hegotoꞌi. Eḡeꞌa zae huzadu zaꞌe vaze reꞌevaziꞌeteꞌe azaḡano reꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ꞌOuge reirotene, ze zogone reꞌevaze modadu ane hegote onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Iesuꞌa eꞌeanoꞌo tahiḡa faḡa onamirotene, Zebedeo ubuga aheu, Iakobo zu negoḡa Ioaneꞌa ḡasi zamaḡano zeḡe reꞌeva zigoga faine radiunuteꞌe horoziro. ");
INSERT INTO ksj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ꞌOugadu aniꞌa zogone ze huziro, ebu zeꞌa moze Zebedeoꞌe gau azaḡa teite ḡasio modadu ani hegote onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iesu ebu ane tahiꞌatahiꞌaꞌa Kaperanauma onamiro. Ebu Bana Madaḡa meirotene, Iesuꞌa nuꞌonuꞌo neḡa diuḡadu ihore ḡadaheniro. ");
INSERT INTO ksj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Vaze ḡuḡuvaḡaniꞌa ane ihore uꞌano zaguzagaro. Mazaḡa Iesuꞌe Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa teige mene ihoziro, rehano Badiꞌa gigiꞌaḡa hina ihoziro. ");
INSERT INTO ksj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Eꞌe madaḡano vine sau'aḡeta vazeḡa ꞌahoganiꞌa nu'onu'o neḡano radiunu. Aniꞌa agoḡa boro hina ꞌahige huaro, ");
INSERT INTO ksj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Nazareta vazeḡa Iesu! Ḡa emeḡe mazao nougihi raꞌohe? Ḡa eme ruifoga radu arahe? E edeḡa, ḡaꞌe iniu. Ḡa'e Badiꞌa mazaonoꞌo ariroteꞌe Vazeḡa Zaḡoḡa!” ");
INSERT INTO ksj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iesuꞌa vine sauꞌa roniro, “Hezo'a! Vaze e'e mazaonoꞌo buanoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ebu vine sauꞌaniꞌa vaze eꞌe mae ketoketonadu ḡihau ḡaniḡanauꞌenaꞌa ani mazaonoꞌo buaro. ");
INSERT INTO ksj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ebu vaze niduꞌa zaguzaganadu zeḡeꞌa bare ḡadimutitiro, “ꞌAdiꞌe nagini? Ihore iziga ꞌahoga gigiꞌaḡeta! Aniꞌa vine sauꞌa riḡa ziꞌetene, ze ani egohauꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ebu Iesu hariḡaꞌe ḡarihe Galilea habaꞌa niduꞌa zamaḡano bororaro. ");
INSERT INTO ksj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ze nuꞌonuꞌo neḡa modadu Iakobo zu Ioane teite Simona zu Anderea neze onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simona emoḡa roḡaeḡaꞌe ahiꞌaniꞌa gigine runadu evane rana baze radiro, ebu ze ani moneo Iesu niro. ");
INSERT INTO ksj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ebu Iesuꞌa ani uhiḡa onamadu ꞌevoꞌa oboniro ebu ani abine ḡihiniro. ꞌOugirotene, ane ahiꞌa gigiꞌa ꞌai dauḡiro ebu aniꞌa zeḡe veize ogomu ruhibiro. ");
INSERT INTO ksj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Madaꞌa zuburadu ḡoravararotene, vaze ḡuḡuvaḡaniꞌa ugi azaḡa zu vine sauꞌazeta azaḡa niduꞌa Iesu vaḡe tutuze ariro. ");
INSERT INTO ksj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ebu ne azaḡa niduꞌa ibihetao nuꞌoraro. ");
INSERT INTO ksj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ꞌOugadu Iesuꞌa ugi nunu azaḡa ḡehaḡa faiziro ebu vine sauꞌa ḡehaḡa zuni hegoze buziro. Rehano ani vine sauꞌasauꞌaniꞌa ḡoerogaꞌe ꞌuiro, mazaḡa ze ederiro, Iesuꞌe iniu. ");
INSERT INTO ksj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Oherebau uzeuze, ꞌizema agaranogano, Iesuꞌa iḡunadu haba bohaꞌa ꞌahoga onamiro ebu eꞌea kuraro. ");
INSERT INTO ksj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ebu Simona zu ane ḡatiniroteꞌe azaḡaniꞌa ani vaḡe onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ze ani horonadu niro, “Vaze niduꞌa ḡa vaḡeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Iesuꞌa naenaeziro, “Eme ne uhiḡauhiḡa onamihi. Eꞌea zuni eḡeꞌa haramiꞌuma. Gau ꞌahi veize eḡeꞌa ariro.” ");
INSERT INTO ksj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Eꞌanoꞌo aniꞌe Galilea habaꞌa niduꞌa zamaḡano ragaveꞌenaꞌa, Iuda azaḡa nuꞌonuꞌo neḡano haramiro zu vine sauꞌasauꞌa hegoze buziro. ");
INSERT INTO ksj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Refera vazeḡa ꞌahoganiꞌa Iesu vaḡe ariro, ebu ane obena hina tuḡadu uminiro, “Zuhiꞌa Boro, ḡa uratine, eḡe faihogaꞌe idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesuꞌa vetuḡaniro ꞌahine, ane ꞌevore einadu vaze eꞌe oboniro ebu niro, “E urateꞌohe. Ḡaꞌe deheru manoroꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ꞌOugirotene, referaꞌa zogone dauḡiro ebu aniꞌa manoriro. ");
INSERT INTO ksj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ebu Iesuꞌa ḡoere riḡa neadu zogone ani tuḡune vaḡiniro. Iesuꞌa ꞌahige rae niro, ");
INSERT INTO ksj_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Vazeni ꞌahoga ago noꞌi, rehano dibuꞌo vazeḡa vaḡe onamadu ahiriḡo ihonoꞌi. Ebu ḡaeꞌa deheru manorataꞌaꞌe vazeꞌa ederifine, Moseꞌa reiroteꞌe dibuꞌoḡa mae onamadu Badiꞌa dibuꞌohanoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Rehano ani onamadu eꞌe hariḡa hunio ḡadahe rae fureniro ebu hariḡaꞌe bororaro. Eꞌe uꞌano, Iesuꞌe ne hunio diuḡoga mene idaranadu enona vaze oꞌoꞌa habaꞌano radiro. Rehano vaze ḡehaḡaniꞌa ꞌize haba nunuonoꞌo ani vaḡe ariro. ");
INSERT INTO ksj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mada nu ḡarugano Iesuꞌa Kaperanauma bare ariro ebu aniꞌa ne ariroteꞌe hariḡaniꞌa bororaro. ");
INSERT INTO ksj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Eꞌanoꞌo vaze ḡehaḡaniꞌa nuꞌoranadu ibiheta enogano zuni iriꞌaviro. Ebu Iesuꞌa haramoziro. ");
INSERT INTO ksj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Eꞌe madaḡano ahiꞌa mene haganeꞌeteꞌe vazeḡa ꞌahogaꞌe vaze ḡazaḡaniꞌa herate ariro. ");
INSERT INTO ksj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Rehano vaze ḡuḡuvaḡa ꞌahine, ze ani Iesu vaḡe odohe onamoga mene idararo. Eꞌanoꞌo zeꞌa Iesu hitaga binuḡa mae bohaniro, ebu binu bohaꞌanonoꞌo ahiꞌa mene haganeꞌeteꞌe vazeḡaniꞌa baze radiuꞌeteꞌe farata miniḡeta hina ovoe dabanadu Iesu zamao bazune tiro. ");
INSERT INTO ksj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Zeḡeꞌa Iesu mazao fieꞌeteꞌe Iesuꞌa horonadu ahiꞌa mene haganeꞌeteꞌe vazeḡa niro, “Ubude, ḡae haḡai sauꞌa ꞌai rae modeha.” ");
INSERT INTO ksj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Eꞌe madaḡano Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa nuꞌa eꞌea ehoriro ebu zeḡeꞌa bare ꞌahige rae zamariro, ");
INSERT INTO ksj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nougadu vaze ꞌahiꞌe ꞌouge raꞌohe? Aniꞌa Badiꞌa rae sausauneꞌohe. Badiꞌaꞌa daꞌo vaze haḡai sauꞌa rae modeꞌohe!” ");
INSERT INTO ksj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Iesuꞌe zeḡeꞌa zamazeo nagini zamareꞌetaꞌaꞌe zogone ederadu ziro, “Zaꞌe nougadu eꞌeguḡa zamareꞌohe? ");
INSERT INTO ksj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ahiꞌa mene haganeꞌeteꞌe vazeḡa mazao noꞌe ḡoeꞌa nine, ufiḡa? 'Ḡae haḡai sauꞌa ꞌai rae modeha,' rae niꞌeteꞌe ḡoeꞌa ga 'Iḡunoꞌi ebu farataḡo madu onamoꞌi,' rae niꞌeteꞌe ḡoeꞌa? ");
INSERT INTO ksj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Rehano Vaze Ubuganiꞌa raha ꞌadao haḡai sauꞌa rae modeꞌeteꞌe gigiꞌaḡa meirotaꞌaꞌe zaeꞌa ederiꞌuma.” Ebu Iesuꞌa ahiꞌa mene haganeꞌeteꞌe vazeḡa niro, ");
INSERT INTO ksj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Eḡeꞌa ḡaꞌohe, iḡunoꞌi ebu farataḡo madu neḡo onamoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ꞌOuge reirotene, ani iḡunadu farataḡa meiro ebu vaze niduꞌa zamao buau vaḡiniro. Vaze niduꞌaꞌe zaguzaganadu ꞌahige Badiꞌa niguniro, “Eme ꞌahiguḡa mene hune horoniro!” ");
INSERT INTO ksj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesuꞌa bare Galilea duꞌuraḡa genaḡa onamiro. Vaze ḡuḡuvaḡa niduꞌa ani vaḡe ariro ebu aniꞌa ze ḡadahe ihoziro. ");
INSERT INTO ksj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Iesuꞌa onameꞌeteꞌea, Alefeo ubuga, niḡa Leviꞌe takesi fataḡa uhiḡano ehore radiroteꞌe horoniro. ꞌOugadu Iesuꞌa niro, “Eḡe hegotoꞌi.” Ebu Leviꞌa iḡunadu Iesu hegotiro. ");
INSERT INTO ksj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Iesuꞌa Levi neo ḡorava ogomu auꞌeteꞌe zamaḡano takesi azaḡa zu haḡai sauꞌa azaḡa ḡehaḡaniꞌa Iesu zu ane tahiꞌatahiꞌa teite ogau tiburaro. Mazaḡa Iesu hegotiroteꞌe azaḡaꞌe ḡehaḡa. ");
INSERT INTO ksj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mose goro ḡoeꞌa ihozeꞌeteꞌe Farisea azaḡaniꞌa Iesuꞌe takesi azaḡa zu haḡai sauꞌa azaḡa teite ogauꞌeteꞌe horozirotene, ane tahiꞌatahiꞌa ḡadiziro, “Ani nougadu takesi azaḡa zu haḡai sauꞌa azaḡa teite ogau tiburuꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Iesuꞌa eꞌe egadu ziro, “Ugi oꞌoꞌa azaḡaꞌe gohe vazeḡa mene vaḡeꞌohe, rehano ugi azaḡaniꞌa gohe vazeḡa vaḡeꞌohe. Eꞌe teige, e iniu zeḡeꞌa bare duduḡa azaḡa rae zamareꞌeteꞌe azaḡa huzoga radu mene ariro, rehano iniu zeḡeꞌa bare haḡai sauꞌa azaḡa rae zamareꞌeteꞌe azaḡa huzoga radu ariro.” ");
INSERT INTO ksj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mada ꞌahogano Ioane tahiꞌatahiꞌa zu Farisea azaḡaniꞌa ogomu moneo zaḡozaḡe radiunu. Ebu vaze nuꞌa aradu Iesu ḡadiniro, “Ioane tahiꞌatahiꞌa ebu Farisea azaḡa tahiꞌatahiꞌaꞌe ogomu moneo zaḡozaḡeꞌohe. Rehano ḡae tahiꞌatahiꞌaꞌe nougadu ogomu moneo mene zaḡozaḡeꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ebu Iesuꞌa naenaeziro, “Hahu muiḡa madaḡano hahu ohozeḡa iziganiꞌa huziroteꞌe azaḡaniꞌa hahu ohozeḡa iziga teite radiuꞌeteꞌe zamaḡano ze ogomu moneo zaḡozaḡiꞌumahe? Ze ane teite radiuꞌeteꞌe zamaḡanoꞌe ogomu moneo mene zaḡozaḡiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Rehano zeḡe mazaonoꞌo hahu ohozeḡa izigaꞌe mae vaḡiniteꞌe madaḡaniꞌa arine, ze ogomu moneo zaḡozaḡiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Vaze ꞌahoganiꞌa dabua iziga variꞌe madu dabua amahiḡa mene banineꞌohe, mazaḡa dabuaḡa vuzuꞌine, dabua siꞌiga izigaꞌe ḡuanadu amahiḡa hutubiꞌuma zu borofe zigiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ebu vazeni ꞌahoganiꞌa vaini vuḡa fuseḡa amahiḡa zamaḡano vaini vuḡa iziga mene beꞌune ufiꞌohe. Beꞌune ufine, vaini vuḡa iziganiꞌa bare busure bororanadu vaini vuḡa fuseḡa amahiḡaniꞌa zigaꞌuma, ebu vaini vuḡa zu vaini vuḡa fuseḡa sausauniꞌuma. Eꞌanoꞌo vaini vuḡa izigaꞌe vaini vuḡa fuseḡa izigano beuꞌe ufiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Bana Madaḡa ꞌahogano Iesuꞌa vuidi mebaḡa zamaḡano onamiro. Ebu ane tahiꞌatahiꞌaꞌa onameꞌeteꞌea, vuidi maḡa nu ririꞌe ḡadahe meiro. ");
INSERT INTO ksj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ebu Farisea azaḡaniꞌa Iesu niro, “Ḡianoꞌi! Ḡae tahiꞌatahiꞌaꞌe nougadu Bana Madaḡa goroḡa varadeꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Aniꞌa naenaeziro, “Zaꞌe Buka Zaḡoḡa mene meꞌodirohe? Davida zu ani ḡatiniroteꞌe azaḡaꞌe ogomu oꞌoꞌa radu vinize ruzirotene, Davidaꞌa nougiro? ");
INSERT INTO ksj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiataꞌe dibuꞌo vazeḡa ḡihiꞌaḡa madaḡano, Davidaꞌa Badiꞌa ne diuḡadu dibuꞌo azaḡaniꞌa daꞌo auꞌeteꞌe dibuꞌo ꞌuvahuḡa odoga aro, ebu ani ḡatiniroteꞌe azaḡa zuni ziniro.” ");
INSERT INTO ksj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ebu Iesuꞌa ziro, “Vazeꞌe Bana Madaḡa veize mene haḡairo, rehano Bana Madaḡaꞌe vaze veize haḡairo. ");
INSERT INTO ksj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Eꞌanoꞌo Vaze Ubugaꞌe Bana Madaḡa Zuhiꞌaḡa.” ");
INSERT INTO ksj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Bana Madaḡa ꞌahogano Iesuꞌa nuꞌonuꞌo neḡa bare diuḡiro. Eꞌea nae ꞌevoꞌa hoega vazeḡa ꞌahoganiꞌa radiunu. ");
INSERT INTO ksj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Farisea azaḡa nuꞌe Iesuꞌa Bana Madaḡano vaze eꞌe fainiꞌuma ga meneꞌe ḡianihi radu ehamu radiro. Aniꞌa vaze eꞌe fainine, kotao ohoniꞌuma rae reiro. ");
INSERT INTO ksj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ebu Iesuꞌa ꞌevoꞌa hoega vazeḡa niro, “Iḡunadu vaze niduꞌa zamao aroꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ebu Iesuꞌa ziro, “Bana Madaḡano nagini haḡaineꞌe duduḡa? Manoḡa haḡaiꞌuma ga sauꞌa haḡaiꞌuma? Vaze ḡaboziꞌuma ga zimiꞌuma?” ꞌOuge reirotene, ze mene naenaeniro. ");
INSERT INTO ksj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ebu aniꞌa zeḡe mazao maḡunadu zeḡe niduꞌa ḡiaziro, ebu zamaze rinedirotaꞌaꞌe ederadu zamaḡaniꞌa adudaro. Ebu vaze eꞌe niro, “ꞌEvoꞌo ꞌeinoꞌi.” Aniꞌa ꞌevoꞌa ꞌeinirotene, ꞌevoꞌaniꞌa manoriro. ");
INSERT INTO ksj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ebu Farisea azaḡaniꞌa nuꞌonuꞌo neḡanonoꞌo buau ḡouriro, ebu Heroda mone azaḡa teite nuꞌoranadu nougenouge Iesu matiteꞌe moneo ḡadahe ḡoꞌane tiburaro. ");
INSERT INTO ksj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesuꞌe ane tahiꞌatahiꞌa teite vaḡinadu duꞌura onamiro, ebu Galilea habaꞌanonoꞌo vaze ḡuḡuvaḡaniꞌa ani hegotiro. ");
INSERT INTO ksj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ebu Iudea habaꞌa, Ierusalema, Idumea habaꞌa zu Ioridana moneafa habaꞌa, Turo zu Sidono uhiḡa neḡaneḡanonoꞌo vaze ḡehaḡaniꞌa Iesuꞌa haḡairoteꞌe haḡaiḡa niduꞌa egadu ani vaḡe ariro. ");
INSERT INTO ksj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Vaze ufeta ḡehaḡaniꞌa Iesu vaḡe ariroteꞌe uꞌano, aniꞌa ane tahiꞌatahiꞌa ziro, “Vaze ḡuḡuvaḡaniꞌa mene tuꞌihifine, ḡasi komeꞌa ꞌahoga ruhiboꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Aniꞌa vaze ḡehaḡa faiziro ꞌahine, ugi nunu azaḡaniꞌa Iesu ahiꞌa obonoga veize bibititiro. ");
INSERT INTO ksj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Vine sauꞌasauꞌaꞌe nouma ani horonirotene, ani zamao higau bauriro ebu ḡihau huaro, “Ḡaꞌe Badiꞌa Ubuga!” ");
INSERT INTO ksj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Rehano Iesuꞌe riḡa ḡoreziro, “Eꞌe iniu rae vaze ago ihozoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iesuꞌa maḡa ꞌahoga itadu iniu aniꞌa urateꞌeteꞌe azaḡa huze nuꞌozirotene, ze ani vaḡe ariro. ");
INSERT INTO ksj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ebu aniꞌe tahiꞌa gaubanana aheu fare ohotadu zeꞌe apostolo azaḡa rae huziro. ꞌOugadu ze Iesu teite radiro ebu zeꞌa haramifine tuḡuziro, ");
INSERT INTO ksj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ebu vine sauꞌa hegoze buzeꞌeteꞌe gigiꞌaḡa ziniro. ");
INSERT INTO ksj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Aniꞌa ohotiroteꞌe apostolo azaḡa gaubanana aheu fare nizeꞌe ꞌahi eꞌe: Simona (niḡa ꞌahogaꞌe Petero), ");
INSERT INTO ksj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedeo ubuga Iakobo zu negoḡa Ioane (Iesuꞌa ze nize ꞌahogaꞌe Boanere rae turahiro. Eꞌe hugaꞌe Viri Ubugaubuga), ");
INSERT INTO ksj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anderea, Filipi, Batolomeo, Mataio, Tomasi, Alefeo ubuga Iakobo, Tadeo, Zelota vazeḡa Simona, ");
INSERT INTO ksj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ebu Iesu revoharoteꞌe vazeḡa, Isakariota vazeḡa Iuda. ");
INSERT INTO ksj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ebu Iesuꞌa ne diuḡirotene, vaze ḡuḡuvaḡaniꞌa bare nuꞌoraro, eꞌanoꞌo ani zu ane tahiꞌatahiꞌaꞌe oganoga mene idararo. ");
INSERT INTO ksj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Iesu viꞌa zu negoḡa duḡuruꞌa ane hari egadu ani zamahanoga veize onamiro, mazaḡa vaze ḡehaḡaniꞌa, “Iesu vadiganiꞌa sautaro,” rae reiro. ");
INSERT INTO ksj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ebu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡaniꞌa Ierusalemaonoꞌo ovadu ꞌahige rae reiro, “Aniꞌe Belezebuloꞌa ragano reiro. Aniꞌe vine sauꞌasauꞌa zuhiꞌaḡa inaraḡa hina vine sauꞌasauꞌa hegoze buzeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ebu Iesuꞌa ze huzadu hari idaidaḡa hina ziro, “Nougenouge Sataniꞌa Satani hegone buniꞌuma? ");
INSERT INTO ksj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Haba tiba zamaḡano zeḡeꞌa rovotadu utitine, haba aꞌe mene edau gigaraꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ebu ne tiba zamaḡano zeḡeꞌa rovotadu utitine, ne aꞌe mene edau gigaraꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ebu Sataniꞌa ane bare agirohaune zu rovotine, aniꞌe edau gigaranogaꞌe mene idaḡa ebu ane ḡonaganiꞌa ariꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Hube hune, ibite inara vazeḡa mene batune tine, ane ne diuḡadu ane tohe ḡonotu buau tauḡogaꞌe mene idaḡa. Ibite inara vazeḡa batune tine, ane ne toheḡa ḡonotanogaꞌe idaraꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Eḡeꞌa hube hune ziꞌohe, vaze haḡai sauꞌa niduꞌa ebu Badiꞌa rae sausauneꞌeteꞌe ḡoeꞌa niduꞌaꞌe Badiꞌaꞌa rae modiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Rehano iniuꞌa Vine Zaḡoḡa rae sausaunine, ane haḡai sauꞌaꞌe mene rae modiꞌuma ebu aniꞌa haḡai sauꞌa barebare haḡaiꞌuma, onamo tuḡutuḡu.” ");
INSERT INTO ksj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesuꞌa ꞌouge reirotaꞌaꞌe mazaḡa zeꞌa, “Iesuꞌe vine sauꞌaḡeta,” rae reiro. ");
INSERT INTO ksj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ebu Iesu viꞌa zu negoḡa duḡuruꞌa ani vaḡe ariro. Ze ne enogano edauꞌenaꞌa, ani hunoga veize vaze ꞌahoga tuḡune diuḡiro. ");
INSERT INTO ksj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Vaze ḡuḡuvaḡaniꞌa ani gabakekene ehoriro ebu zeḡeꞌa Iesu niro, “Viꞌu zu negoḡo duḡuruꞌa enoneo ḡa vaḡeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Iesuꞌa naenaeziro, “Iniuꞌe eḡe nanu zu eḡe nego duḡuru?” ");
INSERT INTO ksj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ebu aniꞌa ane gabakekene ehore radiroteꞌe azaḡa ḡiazadu ziro, “Eḡe nanu zu eḡe nego duḡuruꞌe ꞌahi eꞌe! ");
INSERT INTO ksj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","IniuꞋa Badiꞌa ura haḡaeꞌeteꞌe vazeḡaꞌe eḡe nego, eze ebu nanu.” ");
INSERT INTO ksj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iesuꞌa duꞌura genaḡano ḡadahe ihoziro. Ebu vaze ḡuḡuvaḡaniꞌa ani babaḡano nuꞌorarotene, aniꞌe ḡasio tiradu duꞌura mone ehoriro ebu vaze niduꞌaꞌe duꞌura genaḡano edaro. ");
INSERT INTO ksj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ebu Iesuꞌa hari idaidaḡa hina ḡau ḡehaḡa ihoziro. Aniꞌa ihoziroteꞌe zamaḡano ꞌahige rae ziro, ");
INSERT INTO ksj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Abitoꞌi! Hihi vazeḡa ꞌahoganiꞌa mebaḡano ezone ḡora onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ani ezone feune ḡorarotene, nuꞌe ibio rururaro ebu niniꞌa aradu au hauḡiro. ");
INSERT INTO ksj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ezone nuꞌe hadi habaꞌano rururaro ebu rahaḡaꞌe mene baruḡa. Rahaḡaꞌe mene baruḡa radu ezoneꞌe ḡarihe ḡuhuriro. ");
INSERT INTO ksj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Rehano madaꞌa hiarotene, gigiꞌaḡaniꞌa ḡuhuḡa manadu roraro, mazaḡa taiga oꞌoꞌa. ");
INSERT INTO ksj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ezone nuꞌe ve renogano rururaro ebu ve renoganiꞌa ezone ḡuhuḡa simarinadu ezoneꞌe mene iniro. ");
INSERT INTO ksj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","U ezone nuꞌe raha manoḡano rururanadu faine ḡuhure bororaro. Ebu nuꞌe huga ḡae 30, nuꞌe huga ḡae 60 ebu nuꞌe huga ḡae 100 hudaro.” ");
INSERT INTO ksj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ebu Iesuꞌa bare ḡoeriro, “Teḡaḡeta vazeḡaꞌe faifaine egadu huga ederoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ebu Iesuꞌa ane daꞌo radirotene, ane uhiḡano radiuꞌeteꞌe azaḡaniꞌa ane tahiꞌatahiꞌa teite hari idaidaḡa eꞌe moneo ḡadiniro. ");
INSERT INTO ksj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ebu Iesuꞌa ziro, “Badiꞌaꞌa zuhiꞌaziꞌeteꞌe moneo ꞌuꞌuru tirotaꞌaꞌe zae mazao fureniro, rehano enone azaḡa mazaoꞌe ḡau niduꞌa hari idaidaḡa hina ḡoreziro. ");
INSERT INTO ksj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Buka Zaḡoḡano ꞌahige rae reiro, 'Ze horoneꞌe rehano, hugaꞌe mene horoniꞌuma. Ze igiꞌe rehano, hugaꞌe mene ederiꞌuma. Ze mene ꞌougifone, ḡihuradu Badiꞌaꞌa haḡaize sauꞌa rae modifo.'” ");
INSERT INTO ksj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ebu Iesuꞌa ziro, “Za hari idaidaḡa ꞌahi aḡuꞌahe? Tena za nougenouge hari idaidaḡa ꞌahogaꞌahoga huga ederiꞌuma? ");
INSERT INTO ksj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Hihi vazeḡaꞌe Badiꞌa ḡoere ḡorauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Vaze nuꞌe ibio rururaroteꞌe ezoga zu Badiꞌa ḡoereꞌe zamazeo ḡoraroteꞌe heuḡa. Ze ḡoere eꞌe igiꞌetene, Sataniꞌa aradu zamazeo ḡoraroteꞌe ḡoeꞌa mae vaḡineꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Vaze nuꞌe hadi habaꞌano rururaroteꞌe ezoga heuḡa. Zeꞌe Badiꞌa ḡoere igiꞌetene matuꞌeꞌenaꞌa, zogone mae ḡihineꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Rehano zeꞌa fieꞌetaꞌaꞌe taiga oꞌoꞌa radu mada tahiḡa daꞌo fieꞌohe. Ebu Badiꞌa ḡoere mae ḡihiniroteꞌe uꞌano, aduga zu sauꞌa hideꞌetene, zogone uiteꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Vaze nuꞌe ve renogano rururaroteꞌe ezoga heuḡa. Zeꞌe Badiꞌa ḡoere igiꞌe rehano, ");
INSERT INTO ksj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ḡaboneze zamaḡano zamaze aduga borofeꞌohe, haba toheḡa barebare mouga veize ufeta zamareꞌohe zu ḡau nunu meihi rae ufeta inareꞌohe. ꞌUguḡaniꞌa Badiꞌa ḡoere ꞌuadu zeꞌe mene iniꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","U vaze nuꞌe raha manoḡano rururaroteꞌe ezoga heuḡa. Zeꞌe Badiꞌa ḡoere igiꞌohe zu mae ḡihineꞌohe, ebu ḡae 30, ḡae 60 ga ḡae 100 hudauꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iesuꞌa ziro, “Za ihure madu siuva ga bazuni fataḡa ꞌuꞌuḡano tiꞌehe? Mene, ihure odaḡa rana tiꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mazaḡa ꞌuꞌuru radiuꞌeteꞌe ḡauḡa niduꞌa fureraꞌuma, ebu ogone ḡahineꞌeteꞌe ḡauḡa zuni horoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Teḡaḡeta vazeḡaꞌe faifaine egadu huga ederoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Iesuꞌa bare ziro, “Nagini zaeꞌa igiꞌeteꞌe faifaine egoꞌi. Zaeꞌa vaze nagini hauꞌeteꞌe idunaḡano Badiꞌaꞌa ꞌouge zae ziniꞌuma ebu ufeta ragate ziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Faifaine zamare igiꞌeteꞌe azaḡaꞌe Badiꞌaꞌa edeḡa ufeta boro ziniꞌuma. U mene faine zamare igiꞌeteꞌe azaḡaꞌe zeḡe edeḡa zuni mae vaḡiniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Iesuꞌa bare ziro, “Badiꞌaꞌa zuhiꞌaziꞌetaꞌaꞌe ꞌahiguḡa. Vaze ꞌahoganiꞌa rahao ezone feune ḡorauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ohere zu madai ani bazeꞌeteꞌe zu evateꞌeteꞌe zamaḡano ezoneꞌa ḡuhureꞌohe zu farauꞌohe, rehano ani ꞌuguḡaniꞌa nougenouge fureruꞌetaꞌaꞌe aḡuꞌa. ");
INSERT INTO ksj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Rahaꞌe aneꞌa bare ezone ḡuhunadu huga iniꞌohe: Ibite geno gabaḡa haḡaeꞌohe, ebu hena rouḡa haḡaeꞌohe, ebu ḡonagano iniꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Huganiꞌa hiḡudeꞌetene, ani kari hina variꞌeꞌohe, mazaḡa hiriveꞌeteꞌe madaḡaniꞌa feureha.” ");
INSERT INTO ksj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iesuꞌa bare ziro, “Eme Badiꞌaꞌa zuhiꞌaziꞌetaꞌaꞌe nagini heuḡa rae reꞌuma? Naginio idaniꞌuma? ");
INSERT INTO ksj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Aꞌe Kuava maḡa komeꞌa tiba heuḡa. Maḡa eꞌe madu rahao ḡorauꞌeteꞌe madaḡanoꞌe aꞌe komeꞌa fase. ");
INSERT INTO ksj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Rehano ḡorarotene, aꞌe ḡuhure farauꞌohe, ebu mebao ḡuhureꞌeteꞌe ḡauḡa niduꞌa vitize bororanadu ezaga boroboro raꞌohe. Ebu hitagano niniꞌa aradu ezaga boroboro zauhaḡano neze ogoruꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ze faine ederifine, Iesuꞌa hari idaidaḡa ꞌuguḡa ḡehaḡa hina ḡoreziro. ");
INSERT INTO ksj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Aniꞌe hari idaidaḡa hina daꞌo ḡoreziro, rehano ane tahiꞌatahiꞌa teite daꞌo radiroteꞌe zamaḡanoꞌe ḡau niduꞌa huga ihoziro. ");
INSERT INTO ksj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Eꞌe madaḡa ḡoravararotene, Iesuꞌa ane tahiꞌatahiꞌa ziro, “Eme duꞌura moneafa fare onamihi.” ");
INSERT INTO ksj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ebu Iesu tahiꞌatahiꞌaꞌa vaze ḡuḡuvaḡa muhiziro ebu Iesuꞌa ehore radiroteꞌe ḡasiḡano tiradu fare onamiro. Ebu ḡasi ꞌahogaꞌahoga zuni Iesu teite onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ebu zavara boroꞌa feuradu saꞌuꞌa ḡasio kafere diuḡiro ebu vuꞌa ḡasi nariga iri'avoniro. ");
INSERT INTO ksj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Rehano Iesuꞌe ḡasi avaḡa ḡuzuḡano vadini zahareꞌeteꞌe hina ḡatite baze radiro. ꞌOugirotene, Iesu tahiꞌatahiꞌaꞌa ani evanadu niro, “Ihore vazeḡa, eme nariga rudauꞌeteꞌe ḡa mene zamareꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ebu Iesuꞌa evatadu zavara riḡa roniro ebu saꞌu niro, “Roḡeranoꞌi! Ago hagaroꞌi!” Ebu zavaraꞌa dauḡiro zu roḡeraro. ");
INSERT INTO ksj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ebu aniꞌa ane tahiꞌatahiꞌa ziro, “Za nougadu rihau rudauꞌohe? Zaꞌa eḡe mazao fieꞌetaꞌaꞌe ꞌize oꞌoꞌahe?” ");
INSERT INTO ksj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Zeꞌe rihau rudaro ebu ḡadimutitiro, “Vaze ꞌahiꞌe iniu? Zavara zu saꞌuꞌa zuni ani ḡoere egohuꞌohe!” ");
INSERT INTO ksj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iesu zu ane tahiꞌatahiꞌaꞌa Galilea duꞌuraḡa moneafa ruhau faradu Gerasa azaḡa habao hebetiro. ");
INSERT INTO ksj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Iesuꞌa ḡasionoꞌo buarotene, vine sauꞌaḡeta vazeḡa ꞌahoganiꞌa idu habaꞌanonoꞌo aradu Iesu hidiro. ");
INSERT INTO ksj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Aniꞌe idu habaꞌano radiunu ebu vazeni ꞌahoganiꞌa ani auri adiriḡa hina zuni batunoga mene idararo. ");
INSERT INTO ksj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mazaḡa ḡae ḡehaḡa auri adiriḡa hina odaḡa zu ꞌevoꞌa batuniro rehano, ani auri adiriḡa riꞌi tahitahiro. Vazeni ꞌahoganiꞌa ani obone touga mene idararo. ");
INSERT INTO ksj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ohere zu madai ani idu habaꞌano ebu maḡano radiuꞌenaꞌa, niau ḡaniḡanaunu ebu hadi hina aneꞌa bare sausauninu. ");
INSERT INTO ksj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ani faḡanonoꞌo Iesu horonirotene, ani uꞌa dure onamadu obenaḡa hina ane zamao tuḡiro. ");
INSERT INTO ksj_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ebu agoḡa boro hina ḡihau niro, “Iesu, Ḡihiꞌa Hune Badiꞌaḡa Ubuga! Ḡaꞌe eḡe mazaonoꞌo nagini urateꞌohe? Badiꞌa niḡano e umiꞌeꞌohe, aduga ago enoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Aniꞌa ꞌouge reirotaꞌaꞌe mazaḡa Iesuꞌa vine sauꞌa ꞌahige riḡa ḡoreniro, “Vine sauꞌa, ani mazaonoꞌo buanoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ebu Iesuꞌa ḡadiniro, “Ḡa niḡo iniu?” Aniꞌa naenaeniro, “E niꞌe Legioni, mazaḡa emeꞌe ḡehaḡa.” ");
INSERT INTO ksj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ebu vine sauꞌaꞌe Iesuꞌa ze eꞌe habaꞌanonoꞌo mene tuḡuze buzoga barebare uminiro. ");
INSERT INTO ksj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Eꞌe madaḡano maḡa komeꞌa ꞌahogano aba ḡuḡuvaḡaniꞌa ogau radiunu. ");
INSERT INTO ksj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ꞌOugadu vine sauꞌasauꞌaniꞌa Iesu uminiro, “Eme aba ḡuḡuvaḡa zamaḡano diuḡoga tuḡufoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Iesuꞌa naenaeziro, “Idaḡa, buꞌanadu onamoꞌi.” Ebu vine sauꞌasauꞌa ꞌai vaze eꞌe mazaonoꞌo buanadu aba ḡuḡuvaḡa mazao diuḡe ḡouriro. Ebu aba ḡuḡuvaḡa niduꞌa 2,000 heuḡaniꞌa maḡa komeꞌa gagaḡanonoꞌo dure ovoradu duꞌurao hunuhune rudaro. ");
INSERT INTO ksj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Aba taufeꞌeteꞌe azaḡaniꞌa ferau manahadu hari ꞌahi ne boroboro zu ne komeꞌakomeꞌa azaḡa meꞌodoziniro. Ebu vaze niduꞌa naginiꞌa fureraroteꞌe ḡianoga radu onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ze Iesu vaḡe arirotene, Legioni vineḡa sauꞌasauꞌaḡaniꞌa ragano reiroteꞌe vazeḡaniꞌa dabua vidanadu zamarone manoḡano ehore radiuꞌeteꞌe horoniro. ꞌOugadu zeꞌe rihau ḡouriro. ");
INSERT INTO ksj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ebu naginiꞌa fureraroteꞌe niduꞌa horoniroteꞌe azaḡaniꞌa vine sauꞌaḡeta vazeḡa zu aba ḡuḡuvaḡa mazao naginiꞌa fureraroteꞌe meꞌodoziniro. ");
INSERT INTO ksj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ꞌOugadu ze Iesuꞌa zeḡe habaonoꞌo vaḡinoga umidiro. ");
INSERT INTO ksj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Iesuꞌa ḡasi zamaḡa diuḡirotene, vine sauꞌaniꞌa ragano reiroteꞌe vazeḡaniꞌa ani teite onamoga uminiro. ");
INSERT INTO ksj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Rehano Iesuꞌa mene uratadu ꞌahige rae niro, “Neḡo onamadu ḡae teite ne tibano radiuꞌeteꞌe azaḡa mazao Zuhiꞌa Boroꞌa ḡae mazao manoḡa borofe haḡateꞌe zu ḡae borofe vetuḡaḡadateꞌe ihozoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Eꞌanoꞌo aniꞌa onamadu Dekapoli zamaḡano Iesuꞌa ani mazao manoḡa borofe haḡairoteꞌe ḡadahe ziro. ꞌOugirotene vaze niduꞌa zaguzagaro. ");
INSERT INTO ksj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iesuꞌa bare ḡasi hina duꞌura moneafa fare onamirotene, vaze ḡuḡuvaḡaniꞌa ani gabaḡeḡeniro ebu aniꞌe duꞌura eꞌe genaḡano radiro. ");
INSERT INTO ksj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ebu nuꞌonuꞌo neḡa vazeḡa ḡihiꞌaḡa ꞌahoga, niḡa Iairoꞌa ariro. Ani Iesu horonirotene Iesu oda babaḡano ḡuḡuriro, ");
INSERT INTO ksj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ebu ḡihau uminiro, “Eḡe aboe komeꞌaꞌe rudauꞌohe. Ḡaeꞌa aradu ane rana ꞌevoꞌo toꞌi, ꞌougine ani manoriꞌuma zu ḡabodiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ꞌOugadu Iesuꞌa ane teite onamiro. Ebu vaze ḡuḡuvaḡaniꞌa Iesu hegotadu ani bibine varahe onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ebu roḡae ugi madu muri gaubanana aheu fare adugano radiunuteꞌe roḡaeḡa ꞌahoganiꞌa radiunu. ");
INSERT INTO ksj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Aniꞌe gohe azaḡa ḡehaḡaniꞌa ḡianiroteꞌe zamaḡano aduga boro hidiro ebu toheḡa niduꞌa mode hauḡiro. Rehano ani ugiꞌe mene manoriro zu ufeta bororaro. ");
INSERT INTO ksj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Aniꞌa Iesu hari igirotene, vaze ḡuḡuvaḡa zamaḡano Iesu ḡaruna aradu ani dabua tahiḡa oboniro. ");
INSERT INTO ksj_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Mazaḡa aniꞌe ꞌahige zamariro, “Eꞌa ane dabua tahiḡa obone tauḡine, e manoriꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ꞌOugirotene, ugiḡaniꞌa hauḡiro ebu aniꞌe ane ahirio ugiḡaniꞌa manorirotaꞌaꞌe ederiro. ");
INSERT INTO ksj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ꞌOugadu Iesuꞌa zogone ederiro, ani mazaonoꞌo gigiꞌaḡaniꞌa buau vaḡiniro. Ebu Iesuꞌa vaze ḡuḡuvaḡa zamaḡano ḡihure tehadu ḡadiziro, “Iniuꞌa eḡe dabua oboneha?” ");
INSERT INTO ksj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ane tahiꞌatahiꞌaꞌa naenaeniro, “Ḡa vaze ḡuḡuvaḡaniꞌa ḡae bibiꞌe varaheꞌeteꞌe horoneꞌohe. Nougadu, 'Iniuꞌa eḡe oboheha?' rae ḡadimuꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Rehano Iesuꞌe iniuꞌa ani dabua oboniroteꞌe ḡianihi radu ꞌize tehe vaḡovaḡiro. ");
INSERT INTO ksj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ebu roḡae aꞌe ane mazao naginiꞌa fureraroteꞌe ederiro ꞌahine, rihauꞌenaꞌa rereraro ebu Iesu vaḡe aradu ani oda babaḡano ḡuḡuriro. Ebu ane mazao naginiꞌa fureraroteꞌe moneo huga niduꞌa niro. ");
INSERT INTO ksj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ebu Iesuꞌa niro, “Aboe, ḡaeꞌa eḡe mazao fieꞌeteꞌe uꞌano, ugiḡoꞌa manoreha. Zama roḡeḡota onamoꞌi ebu ugiḡonoꞌo manoroꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iesuꞌa ꞌize ḡoereꞌeteꞌea, nuꞌonuꞌo neḡa vazeḡa ḡihiꞌaḡa, Iairo neonoꞌo vaze nuꞌa aradu Iairo niro, “Aboḡoꞌe rudaneha. Nougadu ihore vazeḡa barebare umineꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iesuꞌa zeḡe ḡoere egadu Iairo niro, “Ago rihanoꞌi, rehano fie tauḡoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Iesuꞌe vazeni ꞌahoganiꞌa ani hegotoga garariro, rehano Petero, Iakobo ebu Iakobo negoḡa Ioane daꞌo zamaziro. ");
INSERT INTO ksj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ze nuꞌonuꞌo neḡa vazeḡa ḡihiꞌaḡa neo feurirotene, Iesuꞌe vaze ḡehaḡaniꞌa ḡihau harae ḡunuḡuneꞌeteꞌe zu niauꞌeteꞌe horoziro. ");
INSERT INTO ksj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Aniꞌa ne zamaḡa diuḡadu ziro, “Nougadu za harae ḡunuḡuneꞌohe zu niauꞌohe? Roḡae komeꞌa aꞌe mene rudaneha, rehano bazeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Rehano ze ani eḡofoharo. Aniꞌa zeḡe niduꞌa enone tuḡuze buziroteꞌe enogano, roḡae komeꞌa moga zu viꞌa ebu ane teite ariroteꞌe tahiꞌaḡa uḡidu zamazadu roḡae komeꞌaniꞌa radiuꞌeteꞌe habaꞌa diuḡiro. ");
INSERT INTO ksj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ebu Iesuꞌa roḡae komeꞌa ꞌevoꞌano abinadu niro, “Talita komi!” Ḡoere eꞌe hugaꞌe, “Roḡae komeꞌa, eḡeꞌa ḡaꞌohe, iḡunoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ꞌOuge reirotene, roḡae komeꞌaniꞌa zogone iḡune edanadu ragaviro. Ani muriꞌe gaubanana aheu fare. ꞌOugadu ze ufeta zaguzagaro. ");
INSERT INTO ksj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ebu Iesuꞌa hari eꞌe moneo vazeni ꞌahoga ago noꞌi rae riḡa ziro, ebu tahiꞌa komeꞌa eꞌeꞌa ogafine ogomu nu hanoꞌi rae ziro. ");
INSERT INTO ksj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesuꞌa eꞌe habaꞌa modadu ane haba onamiro. Ane tahiꞌatahiꞌaꞌa zuni ḡatiniro. ");
INSERT INTO ksj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Bana Madaḡa meirotene, ani nuꞌonuꞌo neḡano ihore ḡadahiro, ebu iniuꞌa eꞌe igiroteꞌe azaḡa ḡehaḡaniꞌa zaguzagaro. Ze ꞌahige ḡadimutitiro, “Vaze ꞌahiꞌe noumaonoꞌo ꞌahiguḡa niduꞌa meiro? Aniꞌa meiroteꞌe zamaroneḡa huhuzaḡaꞌe nagini? Ani haḡai gigiꞌa nougenouge haḡaeꞌohe? ");
INSERT INTO ksj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Vaze ahiꞌe ne ogoruꞌeteꞌe vazeḡa zu Maria ubuga, oꞌehe? Ani negoḡa duḡuruꞌe Iakobo, Iosefa, Iuda ebu Simona. Ane ezeḡa niduꞌaꞌe ꞌahao emeḡe teite radiuꞌohe.” Ebu zeꞌa ani hezahoharo. ");
INSERT INTO ksj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ebu Iesuꞌa ziro, “Peroveta vazeḡaꞌe haba nunu zamaḡano vazeꞌa gubaneꞌohe, rehano ane haba azaḡa, ane nabuga ebu ane ne azaḡaniꞌa daꞌo mene gubaneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Aniꞌa eꞌea haḡai gigiꞌa ꞌahoga zuni mene haḡairo, rehano ane ꞌevore ugi azaḡa nu rana teadu faiziro. ");
INSERT INTO ksj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ebu Iesuꞌe zeḡeꞌa ani mazao mene firoteꞌe uꞌano zaguzagaro. Ebu Iesuꞌa neḡaneḡa ragaveꞌenaꞌa, ihoziro. ");
INSERT INTO ksj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Aniꞌa ane tahiꞌa gaubanana aheu fare huze nuꞌoziro. Ebu ze aheuaheu tuḡuzadu vine sauꞌasauꞌa hegoze buziꞌeteꞌe gigiꞌaḡa ziniro. ");
INSERT INTO ksj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ebu aniꞌa ihoziro, “Zae ragavo zamaḡano ḡau ꞌahoga ago moꞌi, rehano tuḡuze daꞌo moꞌi. Ogomu ga fuse ago odohoꞌi, ebu niharazeo hadi zuni ago odohoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tamakaze haḡaoꞌi, rehano dabua ꞌahoga ago odohoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Noꞌe neḡa diuḡoꞌidene eꞌea daꞌo radoꞌi, onamo ne eꞌe mode iḡunoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Noꞌe habaꞌa azaḡaniꞌa zae mene mae zouzoꞌidene, ga ḡoereze mene egozenoꞌidene, odaze huꞌuruḡa zauhe mode manahadu eꞌe habaꞌa mode iḡunoꞌi. ꞌOuge haḡadu zeḡeꞌa zae mazao sauꞌa haḡairoteꞌe ihozoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Eꞌanoꞌo ze onamadu vazeꞌa ḡihuroga veize haramiro. ");
INSERT INTO ksj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Zeꞌe vine sauꞌa ḡehaḡa hegoze buziro ebu ugi azaḡa ḡehaḡa mazao dehoro asozenadu faiziro. ");
INSERT INTO ksj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Iesu niꞌe haba niduꞌa zamaḡano bororanadu vaze niduꞌa ederiro ꞌahine, Galilea habaꞌa kiniḡa, Heroda zuni Iesu moneo igiro. Vaze nuꞌe ꞌahige rae reiro, “Ioane Babatisoꞌa rune azaḡa boꞌaḡano bare ḡabodiro. Eꞌanoꞌo aneꞌa haḡai gigiꞌa inaraḡa hina gaueꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ebu vaze nuꞌe raenaꞌa, “Aniꞌe Elia,” ebu vaze nuꞌe raenaꞌa, “Aniꞌe amahi peroveta azaḡa boꞌaḡano vaze ꞌahoga.” ");
INSERT INTO ksj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Rehano Herodaꞌa eꞌe igirotene, ꞌahige rae reiro, “Eḡeꞌa ꞌunuḡa variꞌe riꞌiroteꞌe vazeḡa, Ioaneꞌa runeonoꞌo ḡabodeha!” ");
INSERT INTO ksj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ibite Herodaꞌa negoḡa Filipi inuga Herodia meiro ꞌahine, Ioaneꞌa roniro. Eꞌanoꞌo Herodaꞌa uti azaḡa tuḡuzadu Ioane obone tiro ebu ḡuꞌa neḡano ohoniro. ");
INSERT INTO ksj_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Mazaḡa Ioaneꞌa Heroda mazao barebare niro, “Ḡaꞌa negoḡo inuga meirotaꞌaꞌe mene duduḡa.” ");
INSERT INTO ksj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Eꞌanoꞌo Herodiaꞌa Ioane agirohanadu matihi reiro, rehano mene idararo. ");
INSERT INTO ksj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Mazaḡa Ioaneꞌe duduḡa zu zaḡoḡa vazeḡa rae Herodaꞌa ederadu aniꞌe Ioane rihoniro ebu ani biriro. Ebu ani Ioane ḡoere igirotene, zamazeꞌa ufeta ꞌadaꞌadaziro, rehano Ioane ḡoere egoga uratiro. ");
INSERT INTO ksj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Rehano mada manoḡa ꞌahoganiꞌa ariro. Herodaꞌa fureraroteꞌe madaḡa meirotene, aniꞌa vaze boroboro zu uti vazeḡa ḡihiꞌaḡaḡihiꞌaḡa ebu Galilea habaꞌa azaḡa boroboro huzadu mui boro haḡairo. ");
INSERT INTO ksj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ebu Heroda aboḡaniꞌa diuḡi aradu zavonirotene, aniꞌa Heroda ebu ane iꞌudo azaḡa matuꞌoziro. ꞌOugadu kini Herodaꞌa aboḡa niro, “Ḡa urani ꞌahoga umihoꞌi, ꞌougine eḡeꞌa ḡaniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ebu Herodaꞌa ani teite ḡoitoradu ane ḡoere rinede tiro, “Ḡa nagini umihine, ḡaniꞌuma. Ḡaeꞌa uratoꞌidene, eḡe haba niduꞌaonoꞌo ḡahaꞌa zuni ḡaniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ꞌOugadu roḡae eꞌea bua onamadu viꞌa niro, “E nagini uminiꞌuma?” Viꞌaniꞌa naenaeniro, “Ioane Babatiso vadini uminoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Roḡae eꞌeꞌa zogone kini vaḡe bare onamadu uminiro, “Izidi ꞌada Ioane Babatiso vadini siuva rana teadu eḡe enoga urateꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodaꞌe zamaḡaniꞌa ufeta adudaro, rehano ani aneꞌa huziroteꞌe azaḡa zamao ane ḡoere rinede tiro ꞌahine, aboḡaniꞌa uminiroteꞌe ḡauḡa hezahohanoga mene uratiro. ");
INSERT INTO ksj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Eꞌanoꞌo aniꞌa zogone ane uti vazeḡa ꞌahoga riḡa ḡorenadu Ioane vadini variꞌe riꞌioga veize tuḡuniro. Ebu uti vazeḡaniꞌa onamadu ḡuꞌa neḡano Ioane vadini variꞌe riꞌiro. ");
INSERT INTO ksj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ebu vadigaꞌe siuva rana teadu bare odohe ariro ebu roḡae tahiꞌaḡa hanadu aneꞌa viꞌa haro. ");
INSERT INTO ksj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ioane tahiꞌatahiꞌaꞌa ꞌahi igirotene, onamadu Ioane ahiri meiro ebu idu zamaḡano guriro. ");
INSERT INTO ksj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apostolo azaḡaniꞌa Iesu varahe nuꞌoraro. Ebu zeḡeꞌa haḡairoteꞌe zu ihoziroteꞌe niduꞌa ani mazao meꞌodiro. ");
INSERT INTO ksj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Eꞌea vaze ḡehaḡaniꞌa oname onainu ꞌahine, ze ogatiteꞌe madaḡani ꞌahoga oꞌoꞌa. ꞌOugadu Iesuꞌa ziro, “Vaze oꞌoꞌa habaꞌa ꞌahoga onamihi ebu ahirife tahiḡa ohonihi.” ");
INSERT INTO ksj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ebu ze zeḡe daꞌo ḡasi hina vaze oꞌoꞌa habaꞌa onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Rehano vaze ḡehaḡaniꞌa ze horozadu zeꞌa onameꞌetaꞌaꞌe ederiro. Ebu neḡaneḡa niduꞌaonoꞌo odao ze zamao dure ibitiro. ");
INSERT INTO ksj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Iesuꞌa ḡasionoꞌo buanadu vaze ḡuḡuvaḡa horozirotene vetuḡaziro, mazaḡa zeꞌe vazeꞌa mene taufeꞌeteꞌe mamoeḡa teigiro. Eꞌanoꞌo ani ḡau ḡehaḡa moneo ze ḡadahe ihoziro. ");
INSERT INTO ksj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ḡoravararotene, Iesu tahiꞌatahiꞌaꞌa ani vaḡe aradu niro, “ꞌAhiꞌe haba bohaꞌa zu mada ꞌai zubureha. ");
INSERT INTO ksj_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ogomuze hoite afine, vaze niduꞌa ne uhiḡauhiḡano tuḡuze vaḡizoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Rehano ani naenaeziro, “Zaeꞌa ogomu nu zenoꞌi.” Rehano zeḡeꞌa niro, “Zeḡe niduꞌa veize bato fuꞌo uḡidu fare gauḡa hadiḡa meine, idaḡa! Emeꞌa eꞌe hadiḡa ufeta boro hina ꞌuvahu odoga hoitadu zeḡe ḡubuziꞌumahe?” ");
INSERT INTO ksj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Iesuꞌa ḡadiziro, “Zae mazao ꞌuvahu odoga nugu eꞌe? Onamadu ḡianoꞌi.” Zeꞌa ḡianadu niro, “Emeḡe mazaoꞌe ꞌuvahu odoga fuꞌo zu ḡozone aheu.” ");
INSERT INTO ksj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ebu Iesuꞌa vaze niduꞌa ve ḡabodoraḡa rana rovonerovone ehorifine ane tahiꞌatahiꞌa ziro. ");
INSERT INTO ksj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ebu ze vaze 100 ga 50 rovonerovone ehoriro. ");
INSERT INTO ksj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ebu Iesuꞌa ꞌuvahu odoga fuꞌo zu ḡozone aheu madu adure ite ḡianeꞌenaꞌa, Badiꞌa mazao manoḡa tauḡi reiro. Ebu ꞌuvahu odoga vahege tahitahadu ane tahiꞌatahiꞌa ziniro, ebu ze vaze niduꞌa ḡahuge ziniro. Aniꞌa ḡozone aheu zuni zeḡe niduꞌa ḡahuge ziniro. ");
INSERT INTO ksj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ꞌOugadu zeḡe niduꞌa au ubararo. ");
INSERT INTO ksj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ebu Iesu tahiꞌatahiꞌaꞌa ꞌuvahu odoga zu ḡozone ḡahaꞌaḡahaꞌa nuꞌonadu tunahu niduꞌa gaubanana aheu fare iriꞌavoniro. ");
INSERT INTO ksj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ogaroteꞌe azaḡa ohoze daꞌoꞌe niduꞌa 5,000. ");
INSERT INTO ksj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Iesuꞌa zogone ane tahiꞌatahiꞌa tuḡuzeꞌenaꞌa ziro, “Ḡasio tiradu eḡe vitihe duꞌura moneafa faradu Betesaida onamoꞌi.” U Iesuꞌe vaze ḡuḡuvaḡa tuḡuziro. ");
INSERT INTO ksj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Aniꞌa ze muhiziroteꞌe enogano kuranoga radu maḡa komeꞌa itiro. ");
INSERT INTO ksj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ḡoravararotene, ḡasizeꞌe duꞌura nemao radiro ebu Iesuꞌe ane daꞌo gabao radiro. ");
INSERT INTO ksj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Aniꞌe ane tahiꞌatahiꞌaꞌa ḡurizabuo reve inaroga horoziro, mazaḡa zavara boroꞌa zeḡe vaḡe gudau ariro. Iraranae reirotene, aniꞌa duꞌura rana edanadu zeḡe vaḡe onamiro. Ani zeḡe vitizihi reiro. ");
INSERT INTO ksj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Rehano ze aniꞌa duꞌura rana ariroteꞌe horonirotene, aniꞌe vine rae zamariro. Ebu ze huau ḡaniḡanaro, ");
INSERT INTO ksj_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","mazaḡa zeḡe niduꞌa ani horonadu rihau rudaro. Rehano Iesuꞌa zogone ziro, “Zamaze rinedoꞌi! ꞌAdiꞌe eḡe. Ago rihanoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ebu ani zeḡe teite ḡasio tiriro ebu zavaraꞌa dauḡiro. ꞌOugadu zeꞌe zaguzagau rudaro, ");
INSERT INTO ksj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","mazaḡa ze Iesuꞌa ꞌuvahu odoga hina vaze ḡehaḡa ḡubuziroteꞌe moneo huga mene ederiro zu zamazeꞌe turaro. ");
INSERT INTO ksj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ze duꞌura faradu Genesareta neḡano hebetiro ebu ḡasi eꞌea ute tiro. ");
INSERT INTO ksj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ze ḡasionoꞌo buarotene, haba eꞌe azaḡaniꞌa Iesuꞌa arirotaꞌaꞌe ederiro. ");
INSERT INTO ksj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ze eꞌe habaꞌa neḡaneḡa niduꞌa dure ragaviro ebu Iesuꞌa noꞌe habaꞌano radiuꞌeteꞌe igirotene, ugi azaḡa farata rana heratadu Iesu vaḡe tutuze onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ebu ani noꞌe neḡa zamaḡa, ne boro ga ne komeꞌa onamirotene, ze ugi azaḡa maketi habaꞌano bazune tiro. Ebu ugi azaḡaniꞌa ani dabua ꞌariḡa tahiḡa daꞌo obonoga veize uminiro. ꞌOugadu oboniroteꞌe azaḡa niduꞌaꞌe ugizeꞌa manoriro. ");
INSERT INTO ksj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisea azaḡa zu Ierusalemaonoꞌo ariroteꞌe goro ḡoeꞌa ihozeꞌeteꞌe azaḡa nuꞌa Iesu varahe nuꞌoraro. ");
INSERT INTO ksj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ze Iesu tahiꞌatahiꞌa nuꞌa ꞌevoreze mene vuzuꞌadu ꞌevoreze toraga hina ogomu auꞌeteꞌe horoziro. ");
INSERT INTO ksj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisea azaḡa zu Iuda azaḡa niduꞌaꞌe vouḡaze haḡai idunaḡano ꞌevoreze vuzuꞌadu ogomu aro. ");
INSERT INTO ksj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ze maketi habaꞌanonoꞌo onaeꞌetene, ꞌevoreze vuzuꞌadu ogomu aro. Ebu vouḡazeꞌa ihoziroteꞌe haḡaiḡa ꞌahogaꞌahogaꞌe ḡehaḡa. Ze bio, ḡoḡore ebu siuva vuzuꞌeꞌeteꞌe moneo zuni ihoziro. ");
INSERT INTO ksj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Eꞌanoꞌo Farisea azaḡa zu goro ḡoeꞌa ihozeꞌeteꞌe azaḡaniꞌa Iesu ḡadiniro, “Nougadu ḡae tahiꞌatahiꞌaꞌe emeḡe vaze boroboro haḡai idunaḡano mene radiuꞌenaꞌa, ꞌevoreze mene vuzuꞌadu ogomu auꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iesuꞌa naenaeziro, “Peroveta vazeḡa Isaiaꞌa zama guhi azaḡa, zae moneo Badiꞌa ḡoere rae furenirotaꞌaꞌe duduḡa. Aniꞌa ꞌahige rae mirihiro, 'ꞌAhi azaḡaꞌe hebeze hina eḡe gubaheꞌohe, rehano zamazeꞌe eḡe mazaonoꞌo faḡa hune. ");
INSERT INTO ksj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Zeꞌa Badiꞌa mazao kurauꞌetaꞌaꞌe huga oꞌoꞌa. Zeꞌe vazeꞌa tiroteꞌe goro ḡoeꞌa ihozeꞌohe.' ");
INSERT INTO ksj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Zaꞌe Badiꞌa goro ḡoere riḡa enonadu vouḡaze haḡai obone giganeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ebu aniꞌa ziro, “Zaꞌe vouḡaze haḡai hegotoga veize Badiꞌa goro ḡoeꞌa ḡarihe fase mae vaḡineꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moseꞌa ꞌahige rae reiro, 'Viꞌu mogo gubazoꞌi,' ebu 'Iniuꞌa ane viꞌa moga rae sausauzine, ani mau runiꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Rehano zaꞌe vize moze mazao ꞌahige raꞌohe, 'Fase, e zae danazoga mene idaḡa, mazaḡa eḡeꞌa danaziteꞌe ḡauḡa ꞌahiꞌe Badiꞌa hatiteꞌe ḡahunoneḡa raha.' ");
INSERT INTO ksj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Zaꞌe ꞌouge raꞌenaꞌa, vize moze veize gau ꞌahoga mene haḡaoga ihozeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Eꞌe ibiḡano zaeꞌa vouḡaze mazaonoꞌo meiroteꞌe haḡaiḡa nunu hegotoga veize, Badiꞌa goro ḡoeꞌa mae vaḡineꞌohe. Zaꞌe ꞌuguḡa haḡai ḡehaḡa haḡaeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ebu hena Iesuꞌa vaze ḡuḡuvaḡa ane vaḡe bare huzadu ziro, “Zae niduꞌa eḡe ḡoere egadu huga eꞌe ederoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Vaze enoneonoꞌo zamaḡa diuḡeꞌeteꞌe ḡauḡaꞌe vaze mene toratoraneꞌohe. Rehano vaze zamaḡanonoꞌo buauꞌeteꞌe ḡauḡaꞌe vaze toratoraneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iesuꞌa vaze ḡuḡuvaḡa muhizadu ne diuḡirotene, ane tahiꞌatahiꞌaꞌa hari idaidaḡa moneo ḡadiniro. ");
INSERT INTO ksj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Aniꞌa ḡadiziro, “Zaꞌe ꞌize mene edeḡahe? Vaze enoneonoꞌo vaze zamaḡa diuḡeꞌeteꞌe ḡauḡaꞌe vaze mene toratoraneꞌohe. Za eꞌe aḡuꞌahe? ");
INSERT INTO ksj_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mazaḡa aꞌe vaze zama mene diuḡeꞌohe, rehano isiḡa zamaḡa diuḡadu ahirionoꞌo buauꞌohe.” Iesuꞌa ꞌouge raꞌenaꞌa, ogomu niduꞌaꞌe deheḡa rae ihoziro. ");
INSERT INTO ksj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ebu aniꞌa bare ziro, “Naginiꞌa vaze zamaonoꞌo buauꞌetaꞌaꞌe vaze toratoraneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mazaḡa vaze zamaonoꞌo zamarone sauꞌaniꞌa buauꞌohe. Aꞌe daro fuꞌa, ḡonore, gorugoru, ");
INSERT INTO ksj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ubuma ḡezo, ununu, vaze sausaunihi raꞌeteꞌe zamaroneḡa, soꞌosoꞌo haḡaiḡa, matuꞌu veize radiu tauḡitauḡeꞌeteꞌe, ahiahi, vaze rae sausauzeꞌeteꞌe, nize mae iteꞌeteꞌe ebu zamarone kauriḡa raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Eꞌeguḡa sauꞌa niduꞌa vaze zamaonoꞌo buanadu vaze toratoraneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iesuꞌa eꞌe habaꞌa modadu Turo onamiro ebu ne ꞌahoga diuḡiro. Aniꞌe vazeni ꞌahoganiꞌa mene ederoga uratiro. Rehano ani ꞌuꞌuru radogaꞌe mene idararo. ");
INSERT INTO ksj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Eꞌea roḡae ꞌahoganiꞌa radiunu ebu ane aboḡaꞌe vine sauꞌaniꞌa ragano reiro. Roḡae aꞌe Iesu hariḡa egadu ani vaḡe ariro ebu odaḡa babaḡano ḡuḡuriro. ");
INSERT INTO ksj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Roḡae aꞌe mene Iuda roḡaeḡa, rehano Siria habaꞌano Fonikiao fureraro. Ani ane aboḡa mazaonoꞌo vine sauꞌa hegone bunifine Iesu uminiro. ");
INSERT INTO ksj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Rehano Iesuꞌa roḡae eꞌe niro, “Ibite geno tahiꞌatahiꞌa ḡubuziꞌuma, mazaḡa tahiꞌatahiꞌa ogomu madu ḡuni hanogaꞌe mene idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Roḡae eꞌeꞌa naenaeniro, “A hube, Zuhiꞌa Boro. Rehano fata ꞌuꞌuḡano ḡuniꞌe zuni tahiꞌatahiꞌaꞌa mae modeꞌeteꞌe ogomuḡa mumuḡa auꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ꞌOugadu Iesuꞌa niro, “Ḡae naenaeꞌe manoḡa. Eꞌanoꞌo ḡa neḡo onamoꞌi. Vine sauꞌaꞌe aboḡa mazaonoꞌo vaḡineha.” ");
INSERT INTO ksj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Roḡae eꞌeꞌa ne onamirotene, ane aboḡaꞌe evane rana bazoga zu vine sauꞌaꞌe ani mazaonoꞌo vaḡinoga horoniro. ");
INSERT INTO ksj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Hena Iesuꞌa Turo modadu Sidono vitiniro. Ebu Dekapoli habaꞌa onamadu Galilea duꞌuraḡa ovoiro. ");
INSERT INTO ksj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Eꞌea vaze nuꞌa teḡa kuru zu mumutafa vazeḡa ꞌahoga Iesu vaḡe tutune aradu aniꞌa ꞌevoꞌa vaze eꞌe rana touga uminiro. ");
INSERT INTO ksj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Iesuꞌa vaze ḡuḡuvaḡaonoꞌo vaze eꞌe genaḡa zamahu onamadu ane ꞌevore huduꞌa vaze eꞌe teḡa zamaḡano zouniro, ebu ane ꞌevoreo soꞌabidadu vaze eꞌe mazane oboniro. ");
INSERT INTO ksj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ebu adure ite ḡianadu heriro ebu vaze eꞌe niro, “Efata!” Ḡoere eꞌe hugaꞌe, “Raꞌanoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ꞌOugirotene, zogone vaze eꞌe teḡaḡaniꞌa raꞌaro zu ane mazaneꞌe ufiraro ebu ani faine ḡoere ḡadahiro. ");
INSERT INTO ksj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iesuꞌa vazeni ꞌahoga ago noꞌi rae riḡa ziro. Aniꞌa barebare ꞌouge ziro rehano, ze barebare ani hari rae fureniro. ");
INSERT INTO ksj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Vaze ḡehaḡaniꞌa ufeta zaguzaganadu ꞌahige rae reiro, “Ani ḡau niduꞌa faifaine haḡaeꞌohe! Teḡa kuru azaḡa faizadu ze igiꞌohe, ebu mumutafa azaḡa faizadu ze ḡoereꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Eꞌe madaḡano vaze ḡuḡuvaḡa ꞌahoganiꞌa nuꞌoraro. Ze anoga ogomuḡa oꞌoꞌa radu Iesuꞌa ane tahiꞌatahiꞌa ane uhiḡa huze aradu ziro, ");
INSERT INTO ksj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“E ꞌahi duḡuru vetuḡaziꞌohe, mazaḡa ze ꞌahao mada uḡidu eḡe teite radiuꞌohe zu ogomuze oꞌoꞌa. ");
INSERT INTO ksj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Eḡeꞌa ze vinini nezeo tuḡuzine, ze ibio higau bauriꞌuma, mazaḡa zeḡe boꞌaḡano nuꞌe haba faḡanonoꞌo areha.” ");
INSERT INTO ksj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ane tahiꞌatahiꞌaꞌa naenaeniro, “Haba bohaꞌano ꞌada iniuꞌa ogomu ḡehaḡa madu vaze ḡuḡuvaḡa ꞌahi ḡubuziꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Iesuꞌa ḡadiziro, “Zae mazao ꞌuvahu odogaꞌe nugu?” Zeḡeꞌa naenaeniro, “ꞌUvahu odogaꞌe fuꞌo aheu fare zu ḡozone komeꞌaꞌe tahiḡa.” ");
INSERT INTO ksj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ebu aniꞌa vaze ḡuḡuvaḡa rahao ehoroga radu ziro. Ebu hena ꞌuvahu odoga fuꞌo aheu fare zu ḡozone nu madu Badiꞌa mazao kuraro. Ebu vahegadu vaze ḡahuge zenoga veize ane tahiꞌatahiꞌa ziniro, ebu zeꞌa vaze ḡuḡuvaḡa ḡahugiro. ");
INSERT INTO ksj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Zeḡe mazao ḡozone komeꞌa nu zuni eꞌe. Iesuꞌa eꞌe madu kuraro ebu ane tahiꞌatahiꞌa zeadu zeꞌa ḡahugiro. ");
INSERT INTO ksj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Vaze niduꞌa au idararo. Ebu ane tahiꞌatahiꞌaꞌa ogomu ḡahaꞌaḡahaꞌa mae ufadu tunahu niduꞌa fuꞌo aheu fare iri'avoniro. ");
INSERT INTO ksj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Eꞌea ogaroteꞌe azaḡa boꞌaḡano ohoze daꞌo niduꞌa 4,000. Iesuꞌa ze tuḡuze vaḡiziro. ");
INSERT INTO ksj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ebu ani zogone ane tahiꞌatahiꞌa teite ḡasio tiradu Dalumanuta habaꞌa onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisea azaḡaniꞌa Iesu vaḡe aradu ani teite ḡadahe taꞌirotitiro. Ze ani tuhune nurihi radu uminiro, “Badiꞌa gigiꞌaḡa hina haḡai nu badeḡa haḡaoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iesuꞌa hereꞌenaꞌa zamaḡaniꞌa adudanadu ꞌahige rae ziro, “Nogadu izidi egaꞌe haḡai nu badeḡa umideꞌohe? Eḡeꞌa hube hune ziꞌohe, haḡai nu badeḡani ꞌahoga zuni mene furenoziniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ebu hena aniꞌa ze muhizadu ḡasio bare tiriro ebu duꞌura moneafa fare onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Iesu tahiꞌatahiꞌaꞌa ꞌuvahu odoga mae odohoga aḡutaro ebu zeḡe ḡasi zamaḡanoꞌe ꞌuvahu odoga tiba daꞌo horoniro. ");
INSERT INTO ksj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ꞌOugadu Iesuꞌa riḡa iraduguziro, “Tohutohoꞌi. Farisea azaḡa zu Heroda ḡiazoꞌi, mazaḡa zeꞌe isiti heuḡa.” ");
INSERT INTO ksj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ꞌOugadu ze zeḡeꞌa bare ḡoꞌaniro, “Emeḡe mazaoꞌe ꞌuvahu odoga oꞌoꞌa radu ani ꞌouge raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iesuꞌa ze nagini ḡoꞌanirotaꞌaꞌe ederadu ḡadiziro, “Nougadu zae mazao ꞌuvahu odoga oꞌoꞌa radu ḡoꞌaneꞌohe? Za ꞌize mene horoneꞌehe ga mene edeḡahe? Za zamaze tuḡahe? ");
INSERT INTO ksj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Zaꞌe ubumazeta, rehano ehamanoga mene idaḡahe? Ebu teḡazeta, rehano abitoga mene idaḡahe? Za mene zamareꞌehe? ");
INSERT INTO ksj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Eḡeꞌa ꞌuvahu odoga fuꞌo hina vaze 5,000 ḡubuzirotene, ḡahaꞌaḡahaꞌaꞌe tunahu nugu iriꞌavoniro?” Zeꞌa naenaeniro, “Tunahu gaubanana aheu fare.” ");
INSERT INTO ksj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ebu Iesuꞌa ḡadiziro, “Eḡeꞌa ꞌuvahu odoga fuꞌo aheu fare hina vaze 4,000 ḡubuzirotene, ḡahaꞌaḡahaꞌaꞌe tunahu nugu iriꞌavoniro?” Zeꞌa naenaeniro, “Tunahu fuꞌo aheu fare.” ");
INSERT INTO ksj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ebu Iesuꞌa ziro, “Za ꞌize mene edeḡahe?” ");
INSERT INTO ksj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Zeꞌe Betesaida neḡa ariro. Ebu vaze nuꞌa ubuma kuruḡa vazeḡa ꞌahoga tutune aradu Iesuꞌa ani obonifine uminiro. ");
INSERT INTO ksj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Iesuꞌa ubuma kuruḡa vazeḡa ꞌevoꞌano abinadu ani tutune neonoꞌo vaḡiniro. Aniꞌa vaze eꞌe ubuma rana soꞌabidiro ebu ane ꞌevore ani rana teadu ḡadiniro, “Ḡa ḡau ꞌahoga horoneꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ani dude ehamanadu niro, “E vaze horozeꞌohe. Ze horozogaꞌe ireꞌa edau ragaveꞌeteꞌe heuḡa.” ");
INSERT INTO ksj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ebu Iesuꞌa bare ane ꞌevore vaze eꞌe ubuma rana tiro. ꞌOugirotene, ane ubumaꞌa raꞌanadu bare ehamaro ebu ḡau niduꞌa faine horoniro. ");
INSERT INTO ksj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iesuꞌa ani ane ne tuḡuneꞌenaꞌa niro, “Betesaida neḡa ago diuḡoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Iesu zu ane tahiꞌatahiꞌaꞌa Kaisarea Filipo habaꞌano neḡaneḡa ragave onamiro. Eꞌe ibiḡano Iesuꞌa ane tahiꞌatahiꞌa ḡadiziro, “Vazeꞌa eꞌe iniu rae raꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Zeḡeꞌa naenaeniro, “Nuꞌe ḡaꞌe Ioane babatiso, nuꞌe Elia, ebu nuꞌe amahi peroveta vazeḡa ꞌahoga rae raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ebu Iesuꞌa ḡadiziro, “U zaꞌe eꞌe iniu rae raꞌohe?” Peteroꞌa naenaeniro, “Ḡaꞌe Keriso.” ");
INSERT INTO ksj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ebu Iesuꞌa ḡoere riḡa ziro, “Eḡe moneo vazeni ꞌahoga zuni ago noꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ebu hena Iesuꞌa ane rune moneo ane tahiꞌatahiꞌa ḡadahe ihoziro, “Vaze Ubuganiꞌa aduga ḡehaḡa hidiꞌuma. Ebu vaze boroboro, dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡaniꞌa hezahohaꞌuma zu goruniꞌuma. Ebu ani mada uḡidu enogano bare ḡabodiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Aniꞌa eꞌe moneo deheru ḡoerirotene, Peteroꞌa Iesu ane genaḡano zamahu onamadu ḡadahe roniro. ");
INSERT INTO ksj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Rehano Iesuꞌa tehadu ane tahiꞌatahiꞌa ḡiazeꞌenaꞌa, Petero roniro, “Satani, eḡe mazaonoꞌo vaḡinoꞌi! Ḡaꞌe Badiꞌa gau mene zamareꞌohe, rehano vaze gau zamareꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ebu hena Iesuꞌa vaze ḡuḡuvaḡa zu ane tahiꞌatahiꞌa ane vaḡe huze nuꞌozadu ziro, “Iniuꞌa eḡe hegotihi rae roꞌidene, ane ura niduꞌa modadu ane satauro odoheꞌenaꞌa, eḡe hegotoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mazaḡa iniu ane ḡabone obone giganeꞌeteꞌe vazeḡaꞌe ḡabone tuḡutuḡu mene hidiꞌuma. Rehano iniuꞌa eḡe zu hari manoḡa veize ane ḡabone ahetine, ḡabone tuḡutuḡu hidiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Vaze ꞌahoganiꞌa haba niduꞌa meiteꞌe ḡarugano ḡaboneḡa daunine, nagi manoḡa hidiꞌuma? ");
INSERT INTO ksj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ḡau ꞌahoga hanadu ḡaboneḡa bare mouga idaḡahe? ");
INSERT INTO ksj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Izidi madaḡa azaḡaꞌe daro zu haḡai sauꞌa futauꞌohe. Eꞌe zamaḡano iniuꞌa eḡe zu eḡe ḡoere uꞌano mazagaronine, Vaze Ubuga zuni Moga agaḡano ebu tuḡure viga zaḡoḡa niduꞌa agaḡano ariteꞌe madaḡano vaze eꞌe uꞌano mazagaroniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ebu Iesuꞌa ziro, “Eḡeꞌa hube hune ziꞌohe, izidi ꞌada edau radiuꞌeteꞌe azaḡa boꞌaḡano vaze nuꞌa ꞌizema rudanogano Badiꞌaꞌa gigiꞌaḡa hina aradu zuhiꞌaziꞌeteꞌe horoniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Mada fuꞌo tiba fare enogano Iesuꞌa Petero, Iakobo ebu Ioane zamazadu zeḡe daꞌo maḡa boro itiro. Eꞌea ani iraḡaniꞌa zeḡe zamao nufiro. ");
INSERT INTO ksj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Dabuaḡaꞌe ꞌurau vazavazahiro. Haba niduꞌa zamaḡano vazeni ꞌahoga zuni vuzuꞌe dehenadu ꞌouge ꞌuranogaꞌe mene idararo. ");
INSERT INTO ksj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ebu zeḡe zamao Elia zu Moseꞌa fureranadu Iesu teite ḡoeriro. ");
INSERT INTO ksj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ꞌOugadu Peteroꞌa Iesu niro, “Ihore vazeḡa, eme ꞌahao radiune manoḡa. Emeḡe uḡiduꞌa nugo taruha uḡidu ogoratihi. Tibaꞌe ḡae veize, tibaꞌe Mose veize ebu tibaꞌe Elia veize ogoraꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Peteroꞌe nagini raꞌetaꞌaꞌe mene ederiro, mazaḡa ze rihau rudaro. ");
INSERT INTO ksj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ebu ḡozeꞌa fureranadu ze ogoziro ebu ḡozeonoꞌo ago ꞌahoganiꞌa ziro, “ꞌAhiꞌe eḡe zamarone Ubude. Za ani ḡoere egohanoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ḡarihe fase zeꞌa ehamu vaḡirotene, vazeni ꞌahoga mene horoniro, rehano Iesu daꞌo horoniro. ");
INSERT INTO ksj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ze maḡanonoꞌo ovairoteꞌea, Iesuꞌa riḡa ziro, “Zaꞌa horonataꞌaꞌe vazeni ꞌahoga ago noꞌi, onamo Vaze Ubuganiꞌa rune azaḡa boꞌaḡano bare ḡabodiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ꞌOugadu ze nagini horoniroteꞌe zeḡe daꞌo zamariro, rehano runeonoꞌo ḡabodiꞌuma rae reiroteꞌe ḡoeꞌa huga moneo ḡadimutitiro. ");
INSERT INTO ksj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ane tahiꞌatahiꞌaꞌa Iesu ḡadiniro, “Nougadu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡaniꞌa, ꞌEliaꞌe ibite ariꞌuma,' rae raꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Iesuꞌa naenaeziro, “Hube hune Eliaꞌa ibite aradu ḡau niduꞌa ruhibiꞌuma. Buka Zaḡoḡano ꞌahige rae mirihiro, 'Vaze Ubugaꞌe aduga boro hidiꞌuma ebu vazeꞌa ani hezahohaꞌuma.' Aꞌe nougadu mirihiro? ");
INSERT INTO ksj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Eḡeꞌa ziꞌohe, Elia ꞌai amahi ariro. Rehano vazeꞌa ani mene ederadu Buka Zaḡoḡano ane moneo mirihiroteꞌe teige, ani mazao zeḡe ura haḡaiḡa haḡairo.” ");
INSERT INTO ksj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Iesu zu ane tahiꞌa uḡiduꞌa ane tahiꞌa ꞌahogaꞌahoga vaḡe ovairotene, vaze ḡuḡuvaḡaniꞌa Iesu tahiꞌatahiꞌa edau ḡeḡezeꞌeteꞌe, zu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡaniꞌa zeḡe teite taꞌirotiteꞌeteꞌe horoziro. ");
INSERT INTO ksj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Vaze niduꞌa Iesu horonadu ḡihau zaguzagaro, ebu ani uꞌa dure onamadu ani mazao, “Manoḡahe?” rae unihiro. ");
INSERT INTO ksj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ebu Iesuꞌa ane tahiꞌatahiꞌa ḡadiziro, “Zaꞌe zeḡe teite nagini moneo taꞌirotiteꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Vaze ḡuḡuvaḡa boꞌaḡano vaze ꞌahoganiꞌa naenaeniro, “Ihore vazeḡa, e eḡe ubude ḡae vaḡe tutune areha. Aniꞌe vine sauꞌaniꞌa agatohanadu ḡoerogaꞌe mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Vine sauꞌaniꞌa noumao ani agatohauꞌetene, ani rahao mae feuneꞌohe. ꞌOugadu ani hebeꞌano busureꞌohe, ḡonoga atiteꞌohe ebu ahiꞌaniꞌa taiduꞌohe. E ḡae tahiꞌatahiꞌa mazao vine sauꞌa hegone bunoga veize umizeha, rehano ze mene idaraneha.” ");
INSERT INTO ksj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iesuꞌa naenaeziro, “Zaꞌe mene fieꞌeteꞌe azaḡa! E zae teite noꞌe faḡa radiꞌuma? E zae mazao noꞌe faḡa zamahe obone tiꞌuma? Tahiꞌa komeꞌa eꞌe eḡe vaḡe tutune aroꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Eꞌanoꞌo ze ani tutune ariro. Vine sauꞌaniꞌa Iesu horonirotene, zogone tahiꞌa komeꞌa aꞌe mae ketoketonadu aniꞌe rahao higau bauriro ebu hebeꞌano busureꞌenaꞌa, kiure ragaviro. ");
INSERT INTO ksj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ebu Iesuꞌa tahiꞌa komeꞌa moga ḡadiniro, “Ani noꞌe madaḡanonoꞌo ugi ꞌahi meiro?” Moganiꞌa naenaeniro, “Ani komeꞌa madaḡanonoꞌo meiro. ");
INSERT INTO ksj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Vine sauꞌaniꞌa ḡae ḡehaḡa ani manoga veize ire rogao ga vuo ani mae feuniro. Rehano ḡaeꞌa ḡauni ꞌahoga haḡaogaꞌe idaḡa roꞌidene, emeḡe vetuḡafoꞌi zu danafoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iesuꞌa niro, “'Idaḡa roꞌidene,' rae ago roꞌi. Iniu fieꞌeteꞌe azaḡaꞌe ḡau niduꞌa haḡaogaꞌe idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tahiꞌa komeꞌa moganiꞌa zogone agoḡa boro hina ḡihau niro, “E fieꞌohe. Eḡeꞌa fieꞌetaꞌaꞌe zoreḡa ꞌahine, eḡe danahoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iesuꞌa vaze ḡuḡuvaḡaniꞌa dure areꞌeteꞌe horozirotene, vine sauꞌa roniro, “Vaze mae teḡa kuru zu mumutafa azaḡano sausauzeꞌeteꞌe viga, eḡeꞌa riḡa ḡaꞌohe, ani mazaonoꞌo buanoꞌi ebu ani mazao ago bare diuḡoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ꞌOugirotene, vine sauꞌaniꞌa ḡihau ḡaniḡanaro ebu tahiꞌa komeꞌa mae ketoketonadu buau vaḡiniro. Tahiꞌa aꞌe rune vazeḡa teigiro ꞌahine, zeḡeꞌa, “Ani rudaneha,” rae reiro. ");
INSERT INTO ksj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Rehano Iesuꞌa ꞌevoꞌano ani obonadu abine ḡihinirotene, ani edau iḡuniro. ");
INSERT INTO ksj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Iesuꞌa ne ꞌahoga diuḡirotene, ane tahiꞌatahiꞌaꞌa sifu ḡadiniro, “Emeꞌa nougadu vine sauꞌa hegone bunoga mene idaraneha?” ");
INSERT INTO ksj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Iesuꞌa naenaeziro, “ꞌAhiguḡa vine sauꞌaꞌe kuru hina daꞌo mae buzeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ze eꞌe habaꞌa modadu Galilea habaꞌa vitau onamiro. Iesuꞌe vazeni ꞌahoganiꞌa ze noumao radiuꞌetaꞌaꞌe ederoga mene uratiro, ");
INSERT INTO ksj_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","mazaḡa aniꞌe ane tahiꞌatahiꞌa ihozinu. Aniꞌa ꞌahige rae ziro, “Vaze Ubugaꞌe agireḡa ꞌevoreo riꞌiniꞌuma. Ze ani maꞌuma ebu mada uḡidu enogano aniꞌa bare ḡabodiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Rehano Iesu tahiꞌatahiꞌaꞌe ane ḡoere huga mene ederiro ebu eꞌe moneo bare ḡadimanoga zuni riharo. ");
INSERT INTO ksj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ze Kaperanauma neḡa onamiro. Iesuꞌa neo radirotene, ane tahiꞌatahiꞌa ḡadiziro, “Za ibio nagi moneo roteteha?” ");
INSERT INTO ksj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Rehano ze sifu radiro, mazaḡa ze ibio iniuꞌe ḡihiꞌa hune moneo rotetiro. ");
INSERT INTO ksj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iesuꞌa ehoriroteꞌe enogano ane tahiꞌa gaubanana aheu fare huzadu ziro, “Iniuꞌe vaze ibiꞌa reihi reine, aniꞌe vaze ḡonaga rae radu vaze niduꞌa tuḡure vazeḡano reꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aniꞌa tahiꞌa komeꞌa ꞌahoga zamahanadu zeḡe boꞌaḡano ohoniro ebu ane ꞌevore hina ohanadu ziro, ");
INSERT INTO ksj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Iniuꞌa eḡe niḡano tahiꞌa komeꞌa ꞌahiguḡa mae ḡihinine, aniꞌe eḡe mae ḡihiheꞌohe. Ebu iniuꞌa eḡe mae ḡihihine, aniꞌe eḡe daꞌo mene mae ḡihiheꞌohe, rehano eḡe tuḡuhiroteꞌe Badiꞌaḡa mae ḡihineꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ioaneꞌa Iesu niro, “Ihore vazeḡa, eme vaze ꞌahoganiꞌa ḡae niḡano vine sauꞌasauꞌa hegoze buziroteꞌe horoniro. ꞌOugadu emeḡeꞌa ani garariro, mazaḡa aniꞌe mene emeḡe none vazeḡa.” ");
INSERT INTO ksj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Iesuꞌa niro, “Ani ago gararoꞌi. Iniuꞌa eḡe niḡano haḡai gigiꞌa haḡairoteꞌe ḡarugano eḡe rae sausauheꞌeteꞌe vazeḡaꞌe oꞌoꞌa. ");
INSERT INTO ksj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Eme mene agirofiꞌeteꞌe vazeḡaꞌe emeḡe none vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Eḡeꞌa hube hune ziꞌohe, iniuꞌa zaꞌe Keriso mone azaḡa radu vu bioḡa tiba ziniꞌeteꞌe vazeḡaꞌe aniꞌa meiteꞌe naeḡa mene hune dauniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ebu eḡe mazao fieꞌeteꞌe azaḡa komeꞌakomeꞌa ꞌahiguḡa boꞌaḡano tiba zuni haḡai sauꞌano tutune veꞌoneꞌeteꞌe vazeḡaꞌe hadi horeḡa ane ꞌunuo autadu davarao mae feunineꞌe ufeta manoḡa. ");
INSERT INTO ksj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ꞌEvoreḡo naeḡaniꞌa haḡai sauꞌano tutuꞌe veꞌoꞌoꞌidene, variꞌe modoꞌi. ꞌEvo'o tiba hina ḡabone tuḡutuḡu hidogaꞌe ufeta manoḡa. Aꞌe ꞌevoreḡo aheu hina ire roga mene hauḡeꞌeteꞌe zamaḡano mae feuꞌoga vitineꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Odaḡo naeḡaniꞌa haḡai sauꞌano tutuꞌe veꞌoꞌoꞌidene, variꞌe modoꞌi. Odaḡo tiba hina ḡabone tuḡutuḡu hidogaꞌe ufeta manoḡa. Aꞌe odaḡo aheu hina ire roga radiu tuḡutuḡu zamaḡano mae feuꞌoga vitineꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ubumaḡo naeḡaniꞌa haḡai sauꞌano tutuꞌe veꞌoꞌoꞌidene, ḡude modoꞌi. Ubumaḡo tiba hina Badiꞌaꞌa zihiꞌaziꞌeteꞌe habaꞌa diuḡogaꞌe ufeta manoḡa. Aꞌe ubumaḡo aheu hina ire roga radiu tuḡutuḡu zamaḡano mae feuꞌoga vitineꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ire rogao radiu tuḡutuḡeꞌeteꞌe idiḡa ḡehaḡaniꞌa ahirize aꞌuma ebu ire rogaꞌe mene hune vidaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Dibuꞌo rana dama teadu deheneꞌeteꞌe teige, vaze niduꞌaꞌe ire roga hina deheziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Damaꞌe manoḡa, rehano iniganiꞌa hauḡine, nougenouge bare inidaꞌuma? Zae boꞌaḡano dama teadu unihotitoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iesuꞌa eꞌe habaꞌa modadu Iudea habaꞌa onamiro ebu hena Ioridana vuḡa moneafa onamiro. Vaze ḡuḡuvaḡaniꞌa ani vaḡe bare ariro ebu aneꞌa iḡaiḡa haḡainuteꞌe teige ze ihoziro. ");
INSERT INTO ksj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ebu Farisea azaḡa nuꞌa Iesu tuhune nurifine ani vaḡe aradu ḡadiniro, “Ohozeꞌa inuga modogaꞌe idaḡahe?” ");
INSERT INTO ksj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Iesuꞌa naenaeziro, “Moseꞌa nagi goro ḡoeꞌa ziro?” ");
INSERT INTO ksj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Zeꞌa niro, “Moseꞌe ohozeꞌa inuga modoꞌidene, aniꞌa ihore soꞌaḡa mirihadu inuga hauꞌeteꞌe enogano inuga modogaꞌe idaḡa rae reiro.” ");
INSERT INTO ksj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iesuꞌa naenaeziro, “Zamaze riḡa ꞌahine, Moseꞌa goro ḡoeꞌa eꞌe mirihadu ziniro. ");
INSERT INTO ksj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Rehano ḡadaheḡano Badiꞌaꞌa ḡau niduꞌa haḡairotene, vaze haḡadu zeꞌe ohoze zu roḡae reiro. ");
INSERT INTO ksj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Eꞌanoꞌo ohozeꞌe viꞌa moga modadu inuga teite tiburaꞌuma, ");
INSERT INTO ksj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ebu anianine ahiri tiba reꞌuma. ꞌOugadu zeꞌe mene aheu, rehano ahiri tiba. ");
INSERT INTO ksj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Eꞌanoꞌo Badiꞌaꞌa tibuzirotaꞌaꞌe vazeꞌa mene rovoniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ze bare ne diuḡirotene, Iesu tahiꞌatahiꞌaꞌa eꞌe moneo ḡadiniro. ");
INSERT INTO ksj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ebu aniꞌa naenaeziro, “Iniuꞌa inuga modadu roḡae ꞌahoga teite hahurine, aniꞌe inuga agirohanadu ubuma ḡezauꞌeteꞌe heuḡa. ");
INSERT INTO ksj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ebu roḡaeꞌa iꞌa modadu ohoze ꞌahoga teite hahurine, aniꞌe ubuma ḡezauꞌeteꞌe heuḡa.” ");
INSERT INTO ksj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Vaze nuꞌa tahiꞌa komeꞌakomeꞌa tutuze Iesu vaḡe ariro, mazaḡa Iesuꞌa ꞌevoꞌa zeḡe rana touga uratiro. Rehano ane tahiꞌatahiꞌaꞌa ze roziro. ");
INSERT INTO ksj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iesuꞌa eꞌe horonirotene, ani zamaḡa ḡuginadu ziro, “Tahiꞌa komeꞌakomeꞌa eḡe vaḡe arogaꞌe idaḡa roꞌi zu ago gararoꞌi. Mazaḡa Badiꞌaꞌa zuhiꞌaziꞌeteꞌe azaḡaꞌe tahiꞌa komeꞌakomeꞌa teigeꞌeteꞌe azaḡa. ");
INSERT INTO ksj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Eḡeꞌa hube hune ziꞌohe, iniuꞌa tahiꞌa komeꞌa teige Badiꞌaꞌa zuhiꞌaziꞌeteꞌe mene mae ḡihinine, aniꞌe Badiꞌaꞌa zuhiꞌaniꞌeteꞌe vazeḡa mene reꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ebu Iesuꞌa tahiꞌa komeꞌakomeꞌa ane ꞌevore hina ohaziro, ebu ꞌevoꞌa zeḡe rana teadu ze manohuga hidifine kuraro. ");
INSERT INTO ksj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iesuꞌa ane ibiḡano ḡadahe onamirotene, vaze ꞌahoganiꞌa ane vaḡe dure aradu Iesu zamao obenaḡa hina tuḡiro ebu ḡadiniro, “Ihore vazeḡa manoḡa, e nougine, ḡabone tuḡutuḡu hidiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iesuꞌa naenaeniro, “Ḡa nougadu eꞌe manoḡa rae raꞌohe? Vazeni ꞌahoga zuni mene manoḡa, rehano Badiꞌa ane daꞌo manoḡa. ");
INSERT INTO ksj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ḡaꞌe Mose goro ḡoeꞌa edeḡa: 'Ago gorugoroꞌi, ubuma ago ḡezanoꞌi, ago ḡonotanoꞌi, vaze moneo ago ḡuriroꞌi, vaze ago soꞌosoꞌozoꞌi ebu viꞌu mogo gubazoꞌi.'” ");
INSERT INTO ksj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Aniꞌa Iesu naenaeniro, “Ihore vazeḡa, eꞌe komeꞌanonoꞌo ḡoere ꞌahi niduꞌa hegote ariro.” ");
INSERT INTO ksj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iesuꞌa ani ḡiaḡianadu ani zamare borofiro. Ebu aniꞌa niro, “Ḡa ḡau ꞌahoga ꞌize mene haḡaeha. Onamadu ḡauḡo niduꞌa seronoꞌi ebu zahara azaḡa zenoꞌi. ꞌOugine, ḡa adureo ḡau naeḡa boroboro hidiꞌuma. Ebu aradu eḡe hegotoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Aniꞌa Iesu ḡoere egadu zaguzagaro ebu zamaḡaniꞌa adudu bororuꞌenaꞌa iḡuniro, mazaḡa aniꞌe ufeta maꞌora vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iesuꞌa ehamu varahiro ebu ane tahiꞌatahiꞌa ziro, “Maꞌora azaḡaꞌe Badiꞌaꞌa zuhiꞌaziꞌeteꞌe azaḡa rougaꞌe riḡa bagaḡa.” ");
INSERT INTO ksj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Iesu tahiꞌatahiꞌaꞌe Iesu ḡoere egadu zaguzagaro. Ebu Iesuꞌa bare ziro, “Eḡe tahiꞌatahiꞌa, vazeꞌe Badiꞌaꞌa zuhiꞌaziꞌeteꞌe azaḡa rougaꞌe riḡa bagaḡa. ");
INSERT INTO ksj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kameroꞌa niduru hoꞌoga diuḡogaꞌe riḡa. Rehano maꞌora vazeḡaꞌe Badiꞌaꞌa zuhiꞌaniꞌeteꞌe vazeḡa rougaꞌe ufeta riḡa.” ");
INSERT INTO ksj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Iesu tahiꞌatahiꞌaꞌe ufeta hune zaguzagaro ebu zeḡeꞌa bare ḡadimutitiro, “ꞌOugine, iniuꞌa ḡabone hidiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesuꞌa ḡiazadu ziro, “Vaze aneꞌa bare ḡabone hidogaꞌe mene idaḡa, rehano Badiꞌaꞌe idaḡa. Badiꞌaꞌa ḡau niduꞌa haḡaogaꞌe idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ebu Peteroꞌa niro, “Eme emeḡe ḡau niduꞌa modadu ḡa hegotiro.” ");
INSERT INTO ksj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iesuꞌa naenaeziro, “Eḡeꞌa hube hune ziꞌohe, iniuꞌa eḡe zu hari manoḡa veize neḡa, negoḡa, ezeḡa, viꞌa, moga, tahiꞌaḡa ga mebaḡa modine, ");
INSERT INTO ksj_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","aniꞌe izidi madaḡano aduga hidiꞌuma rehano, naeḡa ḡae 100 hidiꞌuma—neḡa, negoḡa, ezeḡa, viꞌa, tahiꞌaḡa ebu mebaḡa bare hidiꞌuma. Ebu zama moneo ḡabone tuḡutuḡu hidiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Rehano vaze ibiꞌa ḡehaḡaꞌe ḡonaga reꞌuma, u vaze ḡonaga ḡehaḡaꞌe ibiꞌa reꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Iesu zu ane tahiꞌatahiꞌaꞌe Ierusalema iteꞌeteꞌea, Iesuꞌa ibitiro ebu ane tahiꞌatahiꞌaꞌe zaguzagaro zu ani hegotiroteꞌe azaḡaꞌe riharo. Ebu Iesuꞌa ane tahiꞌa gaubanana aheu fare ane uhiḡa huze aradu naginiꞌa ani mazao fureratiteꞌe ihoziro, ");
INSERT INTO ksj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Emeꞌe Ierusalema iteꞌohe. Ebu Vaze Ubugaꞌe dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa ꞌevoreo riꞌiniꞌuma. Ze ani runeo tuḡuniꞌuma zu Iuda mene azaḡa ꞌevoreo riꞌiniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ebu Iuda mene azaḡaꞌe ḡirihohaꞌuma, ani rana soꞌabidiꞌuma, masiniꞌuma zu goruniꞌuma. Rehano mada uḡidu ḡarugano aneꞌa bare ḡabodi'uma.” ");
INSERT INTO ksj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ebu Zebedeo ubugaubuga, Iakobo zu Ioaneꞌa Iesu vaḡe aradu niro, “Ihore vazeḡa, emeꞌa nagini umideꞌeteꞌe ḡaeꞌa emeḡe veize haḡaoga urateꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Iesuꞌa ḡadiziro, “Zaꞌe eḡeꞌa zae veize nagini haḡaoga urateꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Zeꞌa naenaeniro, “Ḡaeꞌa niḡo mae ḡihiniteꞌe madaḡano emeḡe boꞌaḡano tibaꞌe ḡae edaꞌe mone zu ꞌahogaꞌe ḡae kauri mone iḡuꞌa ḡihiꞌaḡano ehoroga urateꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Iesuꞌa ziro, “Za zaeꞌa nagini umiheꞌetaꞌaꞌe aḡuꞌa. Eḡeꞌa gageꞌeteꞌe bioḡa aduga zaeꞌa gagoga idaḡahe, zu eḡeꞌa meiroteꞌe babatisoḡa hina zaeꞌa babatisozoga idaḡahe?” ");
INSERT INTO ksj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Zeꞌa naenaeniro, “Oꞌe, eme idaḡa.” Iesuꞌa ziro, “Zaꞌe eḡeꞌa gageꞌeteꞌe bioḡa gagiꞌuma ebu eḡeꞌa meiroteꞌe babatisoḡa meꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Rehano eḡe edaꞌe mone zu kauri mone iḡuꞌa ḡihiꞌaḡaꞌe eḡeꞌa mene ziniꞌuma, rehano Badiꞌaꞌa ohoziroteꞌe azaḡaniꞌa daꞌo iḡuri eꞌe meꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Iesu tahiꞌa gaubananaꞌa eꞌe igirotene, Iakobo zu Ioane mazao maḡuniro. ");
INSERT INTO ksj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ꞌOugadu Iesuꞌa ze huze nuꞌozadu ziro, “Za edeḡa, Badiꞌa aḡuꞌa azaḡa zuhiꞌaziꞌohe rae zamareꞌeteꞌe azaḡaꞌe zeḡe haba azaḡa riḡa zuhiꞌaziꞌohe, ebu gavana vazeḡa boroboroꞌe zeḡe haba azaḡa rana edauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Rehano zaꞌe ze ago teigoꞌi. Zae boꞌaḡano iniuꞌe ḡihiꞌa hune reihi reine, aniꞌe zae tuḡure vazeḡano reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ebu iniuꞌe zae boꞌaḡano vaze ibiꞌa reihi reine, aniꞌe vaze niduꞌa tuḡure vazeḡano reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mazaḡa Vaze Ubugaꞌe vazevazeꞌa ane tuḡure azaḡano rouga radu mene ariro, rehano aniꞌe vaze tuḡure vazeḡano rouga radu ariro. Ebu vaze ḡehaḡa veize ane ḡabone hina dibuꞌifine ariro.” ");
INSERT INTO ksj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ebu hena ze Ieriko ariro. Iesuꞌa ane tahiꞌatahiꞌa zu vaze ḡuḡuvaḡa teite Ieriko mode iḡunirotene, ubuma kuruḡa vazeḡa ꞌahoga, Timeo ubuga Batamioꞌa ibi genaḡano hadi umineꞌenaꞌa, ehore radiro. ");
INSERT INTO ksj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ani Nazareta vazeḡa Iesuꞌa vitauꞌeteꞌe igirotene, ḡihau huaro, “Iesu, Davida mariga, eḡe vetuḡahoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ꞌOugirotene, vaze ḡehaḡaniꞌa ani roniro, “Ḡa sifu radoꞌi!” Rehano ani ufeta ḡihau huaro, “Davida mariga, eḡe vetuḡahoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ebu Iesuꞌa tue edanadu ziro, “Ani hunoꞌi.” Ebu ze ubuma kuruḡa vazeḡa hunadu niro, “Inaroꞌi zu edau iḡunoꞌi. Iesuꞌa ḡa huḡadeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ebu aniꞌe ane raga dabuaḡa genaḡano feune modadu rafate iḡuniro ebu Iesu vaḡe onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iesuꞌa ḡadiniro, “Ḡa eḡeꞌa ḡae veize nagini haḡaoga urateꞌohe?” Ubuma kuruḡa vazeḡaniꞌa niro, “Ihore vazeḡa, e ehamatihi.” ");
INSERT INTO ksj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ebu Iesuꞌa niro, “Onamoꞌi. Ḡaeꞌa eḡe mazao fieꞌeteꞌeꞌa ḡae manoꞌeha.” ꞌOugirotene, aniꞌa zogone bare ehamaro ebu ibio Iesu hegotiro. ");
INSERT INTO ksj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ze Ierusalema hanitadu Olivi Maḡano Betefage zu Betania neḡano feurirotene, Iesuꞌa ane tahiꞌa aheu tuḡuzeꞌenaꞌa ziro, ");
INSERT INTO ksj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Zama ḡoha neḡa onamoꞌi. Eꞌe neḡa diuḡine, vazeni ꞌahoganiꞌa mene ehoriroteꞌe donikiḡa ubuga batune touga horoniꞌuma. Doniki eꞌe fuhiꞌadu ꞌahi zamahu aroꞌi. ");
INSERT INTO ksj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Vaze ꞌahoganiꞌa, 'Za nougadu ꞌahigeꞌohe?' rae ḡadizoꞌidene, 'Zuhiꞌa Boroꞌa urateꞌohe ebu ḡarihe ꞌahi bare tuḡune ariꞌuma,' rae noꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ze onamadu doniki ubuga ꞌahoga ibi enogano ibiheta ꞌahogano batune touga horoniro ebu doniki ubuga eꞌe fuhiꞌiro. ");
INSERT INTO ksj_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Eꞌe madaḡano eꞌea edau radiroteꞌe azaḡa nuꞌa ḡadiziro, “Za nougadu doniki ubuga eꞌe fuhiꞌeꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Iesu tahiꞌatahiꞌaꞌe Iesuꞌa ziroteꞌe teige naenaeziro. ꞌOugirotene, ze idaḡa radu Iesu tahiꞌatahiꞌa tuḡuze onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ze doniki ubuga tutune Iesu vaḡe aradu dabuaze doniki ubuga ḡarunio zahariro ebu Iesuꞌa eꞌe rana tire ehoriro. ");
INSERT INTO ksj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ebu vaze ḡehaḡaniꞌa dabuaze ibi rana hiraro, u vaze nuꞌe ire ezaga rouḡeta butuo variꞌe madu hiraro. ");
INSERT INTO ksj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ebu Iesu zamao onamiroteꞌe azaḡa zu ḡaruna hegotiroteꞌe azaḡaniꞌa huaro, “Hosana! Zuhiꞌa Boro niḡano areꞌeteꞌe vazeḡaꞌe ḡihiꞌa hune! ");
INSERT INTO ksj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nigunihi! Emeḡe mama Davidaꞌa zuhiꞌaziteꞌe madaḡaniꞌa areꞌohe!” “Hosana, hitana huneo niḡa nigunihi!” ");
INSERT INTO ksj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iesuꞌa Ierusalema diuḡadu kuru neḡa onamiro ebu eꞌea ḡau niduꞌa ḡiane ragaviro. Ḡoravararo ꞌahine, ane tahiꞌa gaubanana aheu fare teite Betania neḡa onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Irarirotene, ze Betania neḡa mode iḡuneꞌeteꞌea Iesuꞌe vininiro. ");
INSERT INTO ksj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Aniꞌa faḡanonoꞌo ehamarotene figi ireḡa rouḡeta horoniro ebu aꞌe maḡaḡeta ga oꞌoꞌaꞌe udahoga veize onamiro. Aniꞌa eꞌe uhiḡa onamadu ḡianirotene, maḡaꞌe oꞌoꞌa, rehano rouḡa daꞌo horoniro, mazaḡa aꞌe mene figi ireḡaniꞌa hudauꞌeteꞌe madaḡa. ");
INSERT INTO ksj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ꞌOugadu Iesuꞌa ire eꞌe niro, “Vaze ꞌahoganiꞌa ḡae mazaonoꞌo maḡa ꞌahoga mene hune aꞌuma.” Ebu ane tahiꞌatahiꞌaꞌe aniꞌa ꞌouge reiroteꞌe igiro. ");
INSERT INTO ksj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ebu ze Ierusalemao feunirotene, Iesuꞌa kuru neḡa habaꞌano diuḡadu hoiteꞌeteꞌe azaḡa zu seroneꞌeteꞌe azaḡa hegoze buziro. Ebu hadi seniso ziniꞌeteꞌe azaḡa fata zu Tubugo niniḡa seroneꞌeteꞌe azaḡa ehoro habaꞌa mae ḡihuniro, ");
INSERT INTO ksj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ebu iniuꞌa toheze kuru neḡa habaꞌano odohe vitau oname onaeꞌeteꞌe azaḡa garariro. ");
INSERT INTO ksj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ebu aniꞌa ze ihoziro, “Buka zaḡoḡano ꞌahige rae mirihiro, 'Eḡe neꞌe kuru neḡa rae huniꞌuma.' Rehano zaeꞌa kuru neḡaꞌe ḡonore azaḡa neḡano ḡihuniro.” ");
INSERT INTO ksj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡaniꞌa Iesu ḡoere igirotene, Iesu manoga radu ibi ꞌahoga ḡadahe vaḡiro. Mazaḡa vaze ḡuḡuvaḡa niduꞌa ane ihore moneo zaguzagaro ꞌahine, ze ani rihoniro. ");
INSERT INTO ksj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ḡoravararotene, Iesu ebu ane tahiꞌatahiꞌaꞌe Ierusalema ḡutuꞌaḡa onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Oherebau uzeuze, ze ibio onameꞌeteꞌea, figi ireḡaꞌe moꞌaḡanonoꞌo rorau taiga ḡuzu ovoroga horoniro. ");
INSERT INTO ksj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ꞌOugirotene, Peteroꞌa zamaradu Iesu niro, “Ihore vazeḡa, ḡianoꞌi! Ḡaeꞌa, 'Rudanoꞌi,' rae niroteꞌe figi ireḡaꞌe roraneha.” ");
INSERT INTO ksj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ebu Iesuꞌa naenaeziro, “Badiꞌa mazao fioꞌi. ");
INSERT INTO ksj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Eḡeꞌa hube hune ziꞌohe, iniuꞌa maḡa ꞌahi ninaꞌa, 'Ḡihitadu davara zamaḡano buanoꞌi,' rae reine ebu ani zamaḡa mene ꞌadaꞌadaneꞌenaꞌa, aniꞌa nagini rateꞌeꞌa hudaꞌuma rae mae ḡihinine, ꞌuguḡaniꞌa fureraꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Eꞌanoꞌo eḡeꞌa ziꞌohe, zaeꞌa kurauꞌeteꞌe zamaḡano nagini umineꞌetaꞌaꞌe hideha rae mae ḡihinine, zaeꞌa hidiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Zaꞌa edanadu kurauꞌeteꞌe madaḡano, zaeꞌa vaze ꞌahoga teite agirotitoꞌidene, ane haḡai sauꞌa rae modoꞌi. ꞌOugine, Moze adureo zuni zae haḡai sauꞌa rae modiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ze Ierusalemao bare feuriro. Ebu Iesuꞌa kuru neḡa habaꞌano ragaviroteꞌea, dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa, Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zu vaze boroboroꞌa ani vaḡe ariro. ");
INSERT INTO ksj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ebu zeꞌa ḡadiniro, “Ḡa noꞌe gigiꞌaḡa hina ꞌahiguḡa haḡaeꞌohe? Iniuꞌa ꞌahiguḡa haḡaeꞌeteꞌe gigiꞌaḡa ḡaniro?” ");
INSERT INTO ksj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iesuꞌa naenaeziro, “Eḡe zuni ḡadimu ꞌahoga zinihi. Eḡe naenaehoꞌi, ꞌougine e noꞌe gigiꞌaḡa hina ꞌahiguḡa haḡaeꞌeteꞌe ihoziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ioaneꞌa babatiso zinirotaꞌaꞌe Badiꞌa mazaonoꞌo ga vaze mazaonoꞌo? Ehoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ze zeḡe daꞌo ḡoꞌaneꞌenaꞌa ꞌahige rae reiro, “Badiꞌa mazaonoꞌo reine, 'Za nougadu Ioane ḡoere mene mae ḡihiniro?' rae ifiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","U vaze mazaonoꞌo reine zuni mene idaḡa.” Ze vaze ḡehaḡa rihoziro, mazaḡa zeḡe niduꞌa Ioaneꞌe hube hune peroveta vazeḡa rae mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Eꞌanoꞌo ze ꞌahige naenaeniro, “Eme aḡuꞌa.” Ebu Iesuꞌa ziro, “Eḡe zuni noꞌe gigiꞌaḡa hina haḡai ꞌahiguḡa haḡaeꞌeteꞌe mene ihoziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Hena Iesuꞌa hari idaidaḡa hina ze ḡadahe ziro, “Vaze ꞌahoganiꞌa vaini mebaḡa ꞌahoga ḡoraro. Aniꞌa vaini mebaḡa ḡoranadu ḡabiꞌa merau varahiro, ebu vaini maḡa vuḡa gigeꞌeteꞌe veize iduḡa ꞌahoga huꞌiro, zu ehamuꞌeteꞌe neḡa hitaga haḡairo. Hena vaini mebaḡa eꞌe hihi azaḡa nu ꞌevoreo tiro, ebu haba ꞌahoga onamadu mada faḡa ragaviro. ");
INSERT INTO ksj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Vaini maḡa hiriveꞌeteꞌe madaḡaniꞌa feurirotene, vaini mebaḡa vazeḡaniꞌa hihi azaḡa mazaonoꞌo vaini maḡa nu mouga radu ane tuḡure vazeḡa ꞌahoga zeḡe vaḡe tuḡune onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Rehano ze ani obone teadu bouniro ebu ꞌevoꞌa isoḡa tuḡune baroniro. ");
INSERT INTO ksj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Hena ani tuḡure vazeḡa ꞌahoga zeḡe vaḡe bare tuḡuniro, rehano ze ani vadigano maro ebu ani mae mazagarone runiro. ");
INSERT INTO ksj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ebu ani tuḡure vazeḡa ꞌahoga zeḡe vaḡe bare tuḡuniro, rehano zeꞌa ani mau runiro. Ebu aniꞌa tuḡure azaḡa ḡehaḡa bare tuḡuziro, rehano ze nuꞌe bouziro ebu nuꞌe zimi ruziro. ");
INSERT INTO ksj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ebu ani mazao tuḡuniteꞌe vazeḡaꞌe tiba daꞌo eꞌe, aꞌe ane zamarone ubuga. Ḡonagano ani ubuga tuḡuniro ebu ꞌahige rae reiro, 'Ze eḡe ubude gubaniꞌuma gaogi.' ");
INSERT INTO ksj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Rehano hihi azaḡaniꞌa neneḡaniro, 'ꞌAhiꞌe moga mazaonoꞌo vaini mebaḡa ꞌahi meiteꞌe vazeḡa. Eme ani matihi, ꞌougine vaini mebaḡa ꞌadiꞌe emeḡeꞌa meꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Eꞌanoꞌo ze ubuga obone teadu mau runiro, ebu ani vaini mebaḡa enonao mae feuniro. ");
INSERT INTO ksj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ꞌOugadu vaini mebaḡa vazeḡaꞌe zeḡe mazao nougiꞌuma? Ani aradu hihi azaḡa mau ruziꞌuma ebu vaini mebaḡaꞌe vaze nu ziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Zaꞌe Buka Zaḡoḡano ḡoere ꞌahi mene meꞌodirohe? 'Vazeꞌa hadi hina ne ogorarotene, zeꞌa mae modiroteꞌe hadiḡaꞌe ne duꞌe rinedeꞌeteꞌe hadiḡa reiro. ");
INSERT INTO ksj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Aꞌe Zuhiꞌa Boroꞌa haḡairoteꞌe haḡaiḡa. Emeḡeꞌa ḡianeꞌetene, zaguzagauꞌohe.'” ");
INSERT INTO ksj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ebu hena dibuꞌo azaḡa ḡihiꞌaḡaḡihiꞌaḡa, Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa ebu vaze boroboroꞌe Iesuꞌa zeḡe moneo hari idaidaḡa reiroteꞌe ederirotene, Iesu obone tihi reiro. Rehano ze vaze ḡuḡuvaḡaniꞌa zeḡe mazao maḡuniꞌuma radu rihoziro ꞌahine, Iesu muhinadu oname ḡouriro. ");
INSERT INTO ksj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Vesu ze Iesuꞌa ḡoere rae veꞌonine obone touga veize Farisea azaḡa zu Heroda mone azaḡa nuꞌe Iesu vaḡe tuḡuziro. ");
INSERT INTO ksj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ze ani vaḡe aradu niro, “Ihore vazeḡa, eme edeḡa, ḡaꞌe huga daꞌo ḡoereꞌohe, vaze uꞌano zamaḡo mene haganeꞌohe, vaze niduꞌa mazao mene inaheꞌohe zu Badiꞌa mone ibiḡa hugano ihozeꞌohe. Emeꞌe Roma kiniḡa mazao takesi haune, idaḡa ga mene? ");
INSERT INTO ksj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Eme takesi ani haꞌuma ga mene?” Rehano Iesuꞌa ze ani soꞌonihi rae raꞌetaꞌaꞌe ederadu ziro, “Nougadu zaꞌe eḡe soꞌohihi radu tuhuheꞌohe? Roma hadiḡa tiba odohe aradu ihohoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Zeꞌa Roma hadiḡa tiba odohe arirotene Iesuꞌa ḡadiziro, “Iniu viga zu iniu niḡaꞌe hadi eꞌe rana mirihiro?” Zeꞌa naenaeniro, “Aꞌe Roma kiniḡa viga zu niḡa.” ");
INSERT INTO ksj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ebu Iesuꞌa ziro, “Roma kiniḡa ḡauꞌe Roma kiniḡa hanoꞌi, u Badiꞌa ḡauꞌe Badiꞌa hanoꞌi.” Ebu zeꞌe ani ḡoere egadu zaguzagaro. ");
INSERT INTO ksj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ebu hena Sadukea azaḡa nuꞌa Iesu vaḡe ariro. Zeꞌe vazeꞌa runeonoꞌo mene bare ḡabodiꞌuma rae raꞌeteꞌe azaḡa. ");
INSERT INTO ksj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Zeḡeꞌa Iesu ḡadiniro, “Ihore vazeḡa, Moseꞌa goro ḡoeꞌa ꞌahoga ꞌahige rae mirihiro, 'Ohoze ꞌahoganiꞌa rudanadu ane inugaꞌe ubuga ꞌoꞌoꞌa reine, ohoze negoḡaniꞌa ḡozobaḡa teite hahuriꞌuma, ebu ubuga furenadu ubuganiꞌa rune negoḡa ehaꞌa meꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Hari ꞌahi zamaroꞌi. Negoḡa niduꞌa fuꞌo aheu fareꞌa radiunu. Ibiꞌaniꞌa hahuriro ebu ubuga oꞌoꞌa rudaro. ");
INSERT INTO ksj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ebu negoḡa aheuḡaniꞌa ḡozobaḡa teite hahuriro, rehano ane zuni ubuga oꞌoꞌa rudaro. Ebu negoḡa uḡiduḡa mazao zuni ꞌuguḡaniꞌa idane fureraro. ");
INSERT INTO ksj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ebu negoḡa niduꞌa fuꞌo aheu fareꞌa ubudeze oꞌoꞌa rudaro. Ḡonagano ḡozoba eꞌe zuni rudaro. ");
INSERT INTO ksj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ꞌOugadu runeonoꞌo bare ḡaboditeꞌe madaḡano roḡae aꞌe iniu inuga reꞌuma? Mazaḡa ohoze niduꞌa fuꞌo aheu fareꞌa ani teite hahuriro.” ");
INSERT INTO ksj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iesuꞌa naenaeziro, “Zaꞌa zamareꞌetaꞌaꞌe veꞌoḡa, mazaḡa za Buka Zaḡoḡa ga Badiꞌa gigiꞌaḡa moneo aḡuꞌa. ");
INSERT INTO ksj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Rune azaḡaniꞌa bare ḡaboditeꞌe madaḡano ohoze zu roḡaeꞌe mene hahuriꞌuma. Zeꞌe tuḡure viga adureo teigiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Rune azaḡaniꞌa bare ḡabodeꞌeteꞌe moneoꞌe za Mose Bukaḡano ire renoga hariḡa mene meꞌodirohe? Hari eꞌe zamaḡano Badiꞌaꞌa Mose ꞌahige rae niro, 'Eꞌe Aberahamo Badiꞌa, Isako Badiꞌa zu Iakobo Badiꞌa.' Za eꞌe aḡuꞌahe? ");
INSERT INTO ksj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Badiꞌaꞌe mene rune azaḡa Badiꞌa, rehano ḡabone azaḡa Badiꞌa. Zae zamaroneꞌe veꞌoḡa hune!” ");
INSERT INTO ksj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mose goro ḡoeꞌa ihozeꞌeteꞌe boꞌaḡano ꞌahoganiꞌa aradu zeḡeꞌa taꞌirotiteꞌeteꞌe igiro. Ebu aniꞌe Iesuꞌa faine naenaeziroteꞌe horonadu ḡadiniro, “Goro ḡoeꞌa niduꞌa zamaḡano noꞌe goro ḡoeꞌaꞌe ḡihiꞌa hune?” ");
INSERT INTO ksj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iesuꞌa naenaeniro, “Goro ḡoeꞌa ḡihiꞌa huneꞌe ꞌahi eꞌe: 'Isaraela azaḡa, egoꞌi. Zuhiꞌa Boro emeḡe Badiꞌaꞌe Zuhiꞌa Boro tibuhuga. ");
INSERT INTO ksj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Zamaze niduꞌa hina, vineze niduꞌa hina, zamaroneze niduꞌa hina zu inaraze niduꞌa hina Zuhiꞌa Boro zae Badiꞌa zamare borofoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Goro ḡoeꞌa ḡihiꞌa hune aheuḡaꞌe ꞌahi eꞌe: 'Za zae bare zamare borofeꞌeteꞌe teige, nabudize zamare borofoꞌi. Goro ḡoeꞌani ꞌahoga goro ḡoeꞌa ꞌahiguḡa mene vitinoga.'” ");
INSERT INTO ksj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ebu Mose goro ḡoeꞌa ihozeꞌeteꞌe vazeḡaniꞌa Iesu niro, “Ihore vazeḡa, ḡae ḡoere ꞌahiꞌe duduḡa: Badiꞌaꞌe tibuhuga. Badiꞌani ꞌahogaꞌe oꞌoꞌa. ");
INSERT INTO ksj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Zamaze niduꞌa hina, zamaroneze niduꞌa hina zu inaraze niduꞌa hina Badiꞌa zamare borofeꞌetaꞌaꞌe, ebu za zae bare zamare borofeꞌeteꞌe teige nabudize zamare borofeꞌetaꞌaꞌe hufi haoneꞌeteꞌe dibuꞌoḡa zu ḡahunone niduꞌa vitinoga.” ");
INSERT INTO ksj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iesuꞌa ani fairu doḡoꞌani naenaeniroteꞌe horonirotene, ani niro, “Badiꞌaꞌa zuhiꞌaḡaniteꞌe madaḡaꞌe mene faḡa.” Eꞌe enogano vazeni ꞌahoganiꞌa Iesu mene bare ḡadiniro. ");
INSERT INTO ksj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iesuꞌa kuru neḡa habaꞌano ihoziroteꞌea, vaze ḡadiziro, “Nougadu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡaniꞌa Kerisoꞌe Davida mariga rae raꞌohe? ");
INSERT INTO ksj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Davidaꞌe Vine Zaḡoḡaniꞌa ihonadu ꞌahige rae reiro, 'Badiꞌaꞌa eḡe Zuhiꞌa Boro niro, “Eḡe edaꞌe moneo ehoroꞌi, onamo eḡeꞌa agireḡo niduꞌa madu odaḡo ꞌuꞌuḡano raharahaziꞌuma.”' ");
INSERT INTO ksj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davida aneꞌa bare Keriso mazao, 'Zuhiꞌa Boro,' rae huniro. Tena Kerisoꞌe nougenouge Davida mariga reꞌuma?” Vaze ḡuḡuvaḡa huneꞌa matuꞌeꞌenaꞌa, Iesu ḡoere igiro. ");
INSERT INTO ksj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iesuꞌa vaze ihozeꞌenaꞌa, ꞌahige rae ziro, “Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa ḡiazoꞌi. Ze dabua manoḡa faḡa vidau ragavoga zu vaze ḡehaḡa habaꞌano vazeꞌa ze gubazeꞌenaꞌa, zeḡe mazao unihoga, ");
INSERT INTO ksj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ebu nuꞌonuꞌo neḡano vaze boroboroꞌa ehoreꞌeteꞌe habaꞌano ehoroga urateꞌohe zu muio nize boro azaḡaniꞌa ehoreꞌeteꞌe habaꞌano ehoroga urateꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ebu zeꞌe ḡozoba soꞌozadu toheze niduꞌa meizeꞌohe zu vaze ihozifine faḡafe ḡurire kurauꞌohe. ꞌUguḡa azaḡaꞌe aduga boro bagaḡa hidiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesuꞌa kuru neḡano ḡahunone mauḡaḡa moneḡudune ehoradu vaze ḡuḡuvaḡaniꞌa ḡahunone mauḡa zamaḡano hadize ufiꞌeteꞌe muririro. Ebu maꞌora azaḡa ḡehaḡaniꞌa hadi boro ufiro. ");
INSERT INTO ksj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Rehano zahara ḡozoba ꞌahoganiꞌa aradu kopa hadiḡa komeꞌa aheu ufiro. Aꞌe hadi komeꞌa fase. ");
INSERT INTO ksj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iesuꞌa ane tahiꞌatahiꞌa huze nuꞌozadu ziro, “Eḡeꞌa hube hune ziꞌohe, zahara ḡozobaḡa ꞌadaꞌa vaze niduꞌa vitize ḡahunone mauḡa zamaḡano hadi boro ofeha. ");
INSERT INTO ksj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Zeḡe niduꞌaꞌe hadize ḡehaḡa rehano, tahiḡa daꞌo ofeha. U ḡozoba ꞌadiꞌe zahara roḡaeḡa, rehano ane hadi niduꞌa ebu ane ogomu hadiḡa niduꞌa ofeha.” ");
INSERT INTO ksj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iesuꞌa kuru neḡa mode buarotene, ane tahiꞌa ꞌahoganiꞌa niro, “Ihore vazeḡa, ḡianoꞌi. Ne hadiḡa niduꞌaꞌe horeḡa hune! Ne iraḡa niduꞌaꞌe manoḡa tauḡi!” ");
INSERT INTO ksj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Iesuꞌa naenaeniro, “Ḡa ne boro ꞌahi niduꞌa horoneꞌehe? Ne ꞌahi niduꞌa fahe ḡuzuhiteꞌe madaḡaniꞌa aradu hadini ꞌahoganiꞌa hadi ꞌahoga rana mene radiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Iesuꞌa kuru neḡa moneḡudune Olivi Maḡano ehoreꞌeteꞌea, Petero, Iakobo, Ioane ebu Andereaꞌa sifu ḡadiniro, ");
INSERT INTO ksj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Eme efoꞌi. Eꞌeguḡaꞌe naniꞌa fureraꞌuma? Ebu eꞌeguḡaniꞌa nariga fureranateꞌe madaḡanoꞌe nagi haḡai nu badeḡaniꞌa ibite fureraꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iesuꞌa naenaeziro, “Vaze ꞌahoganiꞌa zae mene soꞌosoꞌozifine tohutohoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Vaze ḡehaḡaniꞌa eḡe niḡano aradu 'Eꞌe Keriso,' rae raꞌenaꞌa, vaze ḡehaḡa soꞌosoꞌoziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Zaꞌe utiꞌa fureraroteꞌe hariḡa zu fureraꞌuma rae raꞌeteꞌe ḡoeꞌa nunu egoꞌidene, zamazeꞌa ago ꞌadaꞌadazoꞌi. Eꞌeguḡaniꞌa hube hune ibite fureraꞌuma, rehano mada ḡonagaꞌe ꞌize mene ariꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Haba ꞌahoganiꞌa haba ꞌahoga teite utitiꞌuma zu gavamani ꞌahoganiꞌa gavamani ꞌahoga teite utitiꞌuma. Haba nunu zamaḡano habaꞌa borofe hagariꞌuma zu zagaꞌa hiaꞌuma. Eꞌeguḡa niduꞌaꞌe ene ꞌizema fureranogano gigiꞌaniꞌa ḡadahe fureruꞌeteꞌe heuḡa. ");
INSERT INTO ksj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Zaꞌe tohutohoꞌi. Vazeꞌa zae oboze teadu kotao ohoziꞌuma ebu zeḡe nuꞌonuꞌo neḡano masiziꞌuma. Eḡe uꞌano, zaꞌe gavamani azaḡa zu kini azaḡa mazao tutuze onamadu edauꞌenaꞌa, eḡe hari manoḡa zeḡe zamao rae fureniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ebu hari manoḡaꞌe habaꞌahabaꞌa azaḡa niduꞌa mazao ibite harame huniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Vazeꞌa kotao za oboze toꞌidene, nagini rae ḡoeriteꞌe moneo zamaze ago ibite adudanoꞌi. Eꞌe madaḡano za nougenouge rae ḡoeriteꞌe moneo ihoziꞌuma ebu ihoziteꞌe ḡoeꞌa idunaḡano reꞌuma, mazaḡa ḡoere aꞌe mene zae mazaonoꞌo, rehano Vine Zaḡoḡaniꞌa reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Negoḡaniꞌa negoḡa revohanadu runeo tuḡuniꞌuma, moganiꞌa ubuga revohanadu runeo tuḡuniꞌuma ebu ubudezeꞌa vize moze agirozeadu runeo tuḡuziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Eḡe uꞌano vaze niduꞌa za heꞌeheꞌeziꞌuma. Rehano iniu edau gigaru onamo ḡonaga meiteꞌe vazeḡaꞌe ḡabone hidiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Haba sausauneꞌeteꞌe ḡauḡa sauꞌa bagaḡaniꞌa mene edatiteꞌe habaꞌano edauꞌeteꞌe zaeꞌa horoniteꞌe madaḡaniꞌa ariꞌuma (ꞌadi meꞌodeꞌeteꞌe vazeḡa, ḡoere huga ꞌadi faine ederoꞌi). Eꞌe madaḡano Iudea habaꞌano radiuꞌeteꞌe azaḡaꞌe maḡa ferau itoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ne enogano radiuꞌeteꞌe vazeḡaꞌe ḡauḡa mouga veize ne zamaḡa ago diuḡoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mebao hiheꞌeteꞌe vazeḡaꞌe dabua mouga veize ago bare onamoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Eꞌe madaḡano ahiꞌeta roḡaeḡa zu nune hina ene guraḡa ḡubuzeꞌeteꞌe roḡaeḡaꞌe feranoga mene idaḡa radu aduga boro hidiꞌuma! ");
INSERT INTO ksj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ꞌUguḡaniꞌa irugu madaḡano mene fureranoga veize kuranoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mazaḡa eꞌe madaḡano vaze niduꞌa aduga boro hune hidiꞌuma. Badiꞌaꞌa ḡadaheḡano ḡau niduꞌa haḡairoteꞌeanoꞌo onao izidi, aduga ꞌuguḡaniꞌa mene fureraro ebu vesuꞌu zuni mene bare fureraꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Zuhiꞌa Boroꞌa eꞌe madaḡa mene futufine, vaze tiba zuni mene ḡabode radiꞌuma. Rehano ani aneꞌa ohozadu zamaziroteꞌe azaḡa veize eꞌe madaḡa futufiro. ");
INSERT INTO ksj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Eꞌe madaḡano vaze ꞌahoganiꞌa zinaꞌa, 'Ḡianoꞌi, Kerisoꞌe ꞌahi eꞌe!' ga 'Ḡianoꞌi, aniꞌe ꞌomo eꞌe!' rae zoꞌidene, eꞌe ḡoeꞌa ago mae ḡihinoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mazaḡa ḡuriro kerisoḡa zu ḡuriro peroveta azaḡaniꞌa fureranadu haḡai nu badeḡa zu haḡai gigiꞌa haḡaeꞌenaꞌa, vaze soꞌoziꞌuma. Ze idaḡa reine, Badiꞌaꞌa ohotiroteꞌe azaḡa zuni soꞌoziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Eꞌanoꞌo za tohutohoꞌi. Eꞌe madaḡaniꞌa ꞌizema fureranogano eḡeꞌa ḡau niduꞌa zae ibite ihozeha.” ");
INSERT INTO ksj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Rehano aduga madaḡaniꞌa hauḡine, 'Madaꞌa uzaboraꞌuma, batoꞌa mene agaraꞌuma, ");
INSERT INTO ksj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","buzuvaꞌa adureonoꞌo rururu buaꞌuma, ebu adure gigiꞌaḡaniꞌa hagahagariꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Eꞌe madaḡano ze Vaze Ubuganiꞌa gigiꞌaḡa boro zu agaḡa boro hune madu ḡoze hina areꞌeteꞌe horoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ebu aniꞌa ane tuḡure viga ḡehaḡa tuḡuziꞌuma, ebu zeḡeꞌa haba ḡonaganonoꞌo adure ḡonagano, haba niduꞌa zamaḡano Badiꞌaꞌa ohotiroteꞌe azaḡa nuꞌoziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Figi ireḡa ḡianadu ꞌahi ederoꞌi. Ezaganiꞌa butiru itadu rouḡaniꞌa udufaꞌoga horoneꞌetene, zaꞌe irugu madaḡaniꞌa haniteha rae edereꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Eꞌe teige, ꞌahiguḡaniꞌa fureranoga horonoꞌidene, Vaze Ubugaꞌe zae ibiheta uhiḡano rae ederoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Eḡeꞌa hube hune ziꞌohe, izidi egaꞌe mene hauḡiꞌuma, onamo ꞌahiguḡa niduꞌa fureraꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Adure zu rahaꞌe hauḡiꞌuma, rehano eḡe ḡoereꞌe mene hune hauḡiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Rehano vazeni ꞌahoga zuni ꞌuguḡaniꞌa fureratiteꞌe madaḡaꞌe aḡuꞌa. Adureo tuḡure viga ebu Badiꞌa Ubuga zuni aḡuꞌa, rehano Moga daꞌo edeḡa. ");
INSERT INTO ksj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tohutohe radoꞌi, mazaḡa zaꞌe aḡuꞌa, eꞌe madaḡaniꞌa naniꞌa ariꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Aꞌe vaze ꞌahoganiꞌa haba faḡa onameꞌeteꞌe hariḡa ꞌahoga heuḡa. Ani iḡuneꞌetene, tuḡureḡa azaḡa huzadu ane ḡau niduꞌa faine taufoꞌi rae raꞌohe, zeḡe tibatiba gau tibatiba ziniꞌohe, ebu ibiheta taufeꞌeteꞌe vazeḡaꞌe faine ḡianoꞌi rae raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Eꞌanoꞌo tohutohoꞌi, mazaḡa za aḡuꞌa, ne Zuhiꞌaḡaniꞌa noꞌe madaḡano naniꞌa bare ariꞌuma. Aꞌe ḡorava oheꞌano, ga ohere nemanema, ga irara oheꞌano kokorokuꞌa ugauꞌeteꞌe madaḡano, ga oheredauꞌe za aḡuꞌa. ");
INSERT INTO ksj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Aniꞌa tabara aradu za bazuna mene horozifine zaꞌe evatoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Eḡeꞌa za ziꞌeteꞌe ḡoeꞌaꞌe vaze niduꞌa ziꞌeteꞌe ḡoeꞌa: Evate radoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mada aheu enoganoꞌe Iḡine Modiroteꞌe Muiḡa ebu Isiti Oꞌoꞌa ꞌUvahu Odoga Muiḡa meꞌuma rae reirotene, dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu goro ḡoeꞌa ihozeꞌeteꞌe azaḡaniꞌa Iesu soꞌonadu obone teadu manoga veize ibiḡa ḡoꞌane vaḡiro. ");
INSERT INTO ksj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Rehano ze zeḡeꞌa bare ꞌahige rae reiro, “Iḡine Modiroteꞌe Muiḡa madaḡanoꞌe mene idaḡa. ꞌOugine, vaze ḡuḡuvaḡaniꞌa utitofiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iesuꞌe Betania neḡano ibite referaꞌa meiroteꞌe vazeḡa Simona neo ogau radiro. Eꞌe madaḡano roḡae ꞌahoganiꞌa dehoro huga hohoḡa manoḡa naeḡa boro, niḡa Nadoꞌe bioḡa komeꞌa manohuga iriꞌavonadu mae ariro. Ebu bioḡa komeꞌa eꞌe varadadu Iesu vadinio dehoro hohoḡa beuꞌiro. ");
INSERT INTO ksj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Rehano eꞌea vaze nuꞌe zeḡeꞌa bare maḡune ḡadimutitiro, “Nougadu dehoro hohoḡa ꞌadi mode hauḡeha? ");
INSERT INTO ksj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Aꞌe seronifone, muri tiba gau hadiḡa vitinifo ebu eꞌe hadiḡaꞌe zahara azaḡa zinifo.” ꞌOugadu ze roḡae eꞌe roniro. ");
INSERT INTO ksj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Rehano Iesuꞌa ziro, “Roḡae ꞌahi ago gararoꞌi. Za nougadu ani aduga hauꞌohe? Aniꞌe eḡe mazao manoḡa hune haḡaeha. ");
INSERT INTO ksj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Zahara azaḡaꞌe iḡaiḡa zae teite radiꞌuma radu zaeꞌa urateꞌeteꞌe madaḡa niduꞌa ze danazogaꞌe idaḡa. Rehano eꞌe iḡaiḡa zae teite mene radiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Aniꞌe aneꞌa nagini haḡaoga idaḡa raꞌeteꞌe haḡaiḡa haḡaeha. Eḡeꞌa rudanadu guriteꞌe madaḡa ibite ruhiboga veize dehoro hohoḡa eḡe ahiri rana beuꞌeha. ");
INSERT INTO ksj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Eḡeꞌa hube hune ziꞌohe, raha niduꞌa zamaḡano noꞌe habaꞌano hari manoḡa haramine, aniꞌa haḡateꞌe haḡaiḡa ꞌahi meꞌodadu ani zamariꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Iesu tahiꞌa gaubanana aheu fare boꞌaḡano tahiꞌa ꞌahoga, Isakariota vazeḡa Iudaꞌa dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa ꞌevoreo Iesu riꞌinoga veize zeḡe vaḡe onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Zeꞌe Iuda ḡoere egadu matuꞌe rudaro ebu hadi silivaḡa nu haꞌuma rae ḡoere tiro. ꞌOugadu Iudaꞌa Iesu zeḡe ꞌevoreo riꞌinoga veize mada manoḡa ꞌahoga vaḡiro. ");
INSERT INTO ksj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Isiti Oꞌoꞌa ꞌUvahuḡa Odoga Muiḡa zamaḡano mada ibiꞌaꞌe Iḡine Modiroteꞌe Muiḡa. Eꞌe madaḡano dibuꞌo mamoeḡa ubuga maro. Eꞌe madaḡa meirotene, Iesu tahiꞌatahiꞌaꞌa ḡadiniro, “Ḡa urao eme nouma Iḡine Modiroteꞌe Muiḡa ogomuḡa ruhibe tiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Iesuꞌa ane tahiꞌa aheu tuḡuzeꞌenaꞌa, ziro, “Ne boro diuḡine, ohoze ꞌahoganiꞌa vu ḡoḡoreḡa odohe onameꞌeteꞌe horoniꞌuma. Ebu ani hegotadu aneꞌa diuḡeꞌeteꞌe neḡa diuḡoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Diuḡadu ne eꞌe vazeḡa noꞌi, 'Ihore vazeḡaniꞌa ꞌahige raꞌohe: E eḡe tahiꞌatahiꞌa teite Iḡine Modiroteꞌe Muiḡa ogomuḡa atihi. Iꞌudo azaḡa veize ruhibiroteꞌe habaꞌaꞌe noumao?' ");
INSERT INTO ksj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ꞌOugine, aniꞌa ne hitagano bazuni neḡa boro ꞌahoga ihoziꞌuma zu zaꞌe ehoro habaꞌa ruhibe teateꞌe horoniꞌuma. Eꞌea ogomufe ruhibe toꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Iesu tahiꞌa aheuꞌa iḡunadu ne boro diuḡiro ebu Iesuꞌa ziroteꞌe idunane niduꞌa horoniro. ꞌOugadu ze Iḡine Modiroteꞌe muiḡa ruhibe tiro. ");
INSERT INTO ksj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ḡoravararotene, Iesuꞌa ane tahiꞌa gaubanana aheu fare teite feuri ariro. ");
INSERT INTO ksj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ze ogomu fataḡa babaḡano ehoradu ogauꞌeteꞌea, Iesuꞌa ziro, “Eḡeꞌa hube hune ziꞌohe, zae boꞌaḡano vaze ꞌahoganiꞌa eḡe revoniꞌuma. Aniꞌe eḡe teite ogauꞌeteꞌe vazeḡa.” ");
INSERT INTO ksj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ze zamazeꞌa adudanadu zeḡe tibatibaniꞌa Iesu ḡadiniro, “Eꞌe mene, ineo?” ");
INSERT INTO ksj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Iesuꞌa naenaeziro, “Aniꞌe zae, gaubanana aheu fare boꞌaḡano ꞌahoga. Eḡe teite siuva zamaḡano idaḡa ꞌuvahu odoga tare auꞌeteꞌe vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Vaze Ubuga moneo Buka Zaḡoḡano mirihiroteꞌe idunaḡano Vaze Ubuganiꞌa rudaꞌuma. Rehano ani revohatiteꞌe vazeḡaꞌe aduga boro hidiꞌuma. Aniꞌe mene furerafone, ufeta manoḡa reifo.” ");
INSERT INTO ksj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ze ogauꞌeteꞌe zamaḡano, Iesuꞌa ꞌuvahu odoga madu kuraro, ebu vahegadu ane tahiꞌatahiꞌa ziniro. Ebu aniꞌa ziro, “ꞌAdi madu anoꞌi. ꞌAdiꞌe eḡe ahiri.” ");
INSERT INTO ksj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ebu hena ani vaini vuḡa bioḡa madu kuraro, ebu zenadu zeḡe niduꞌa eꞌe gagiro. ");
INSERT INTO ksj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ebu Iesuꞌa ziro, “ꞌAhiꞌe eḡeꞌa vaze ḡehaḡa veize beꞌuneꞌeteꞌe ruhe hina ohoneꞌeteꞌe ḡoitore ḡoeꞌa. ");
INSERT INTO ksj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Eḡeꞌa hube hune ziꞌohe, eꞌe vaini vuḡa mene bare gagiꞌuma, onamo Badiꞌaꞌa zuhiꞌaziꞌeteꞌe madaḡano vaini vuḡa iziga gagiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ebu ze bada ꞌahoga mae hauḡadu Olivi Maḡa onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iesuꞌa ziro, “Zae niduꞌa muhihe feraꞌuma. Buka Zaḡoḡano ꞌahige rae mirihiro, 'Badiꞌaꞌa mamoe taufeꞌeteꞌe vazeḡa mau runiꞌuma ebu mamoeḡaꞌe ferau ḡouriꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Rehano eḡeꞌa runeonoꞌo bare ḡaboditeꞌe enogano zae zamao Galilea habaꞌa ibite onamiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peteroꞌa Iesu niro, “Vaze niduꞌa ḡae uꞌano ferau muhiꞌiꞌuma rehano, eꞌe mene hune ferau muhiꞌiꞌuma!” ");
INSERT INTO ksj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Iesuꞌa niro, “Eḡeꞌa hube hune ḡaꞌohe, izidi ohere kokorokuꞌa ꞌizema ḡae aheu uganogano ḡaeꞌa ḡae uḡidu eḡe oꞌohiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Rehano Peteroꞌa ḡihau niro, “E mene oꞌoꞌiꞌuma. Ḡae teite rudaune zuni idaḡa!” Ebu ane tahiꞌa niduꞌa zuni ꞌouge reiro. ");
INSERT INTO ksj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ebu zeḡe niduꞌa haba ꞌahoga niḡa Getesemane onamadu Iesuꞌa ane tahiꞌatahiꞌa ziro, “E kurauꞌeteꞌea, zaꞌe ꞌaha ehore radoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ebu aniꞌe Petero, Iakobo zu Ioane tutuze onamiro. Ani zamaḡa ḡadahe ariro zu adudaro. ");
INSERT INTO ksj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ꞌOugadu aniꞌa ziro, “Zamahe are rudauꞌohe. Zaꞌe ꞌadao radadu evate radoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ani tahiḡa faḡa onamiro ebu rahao ḡuḡuradu kuraro, “Ḡa idaḡa roꞌidene, eḡe mazaonoꞌo mada aduga ꞌahi mae vaḡinoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Aniꞌa uminiro, “Mama, eḡe Mama, ḡaꞌe ḡau niduꞌa haḡaogaꞌe edeḡa. Eḡe mazaonoꞌo bio aduga ꞌahi mae vaḡinoꞌi. Rehano eḡe mene urao, ḡae urao daꞌo haḡaoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ebu aniꞌa ane tahiꞌatahiꞌa vaḡe bare onamirotene, ze bazeꞌeteꞌe horoziro. Ebu aniꞌa Petero niro, “Simona, ḡa bazeꞌehe? Ḡa mada tahiḡa zuni evate radogaꞌe mene idaḡahe? ");
INSERT INTO ksj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Sataniꞌa tuhuzadu zaeꞌa mene uitifine, tohutohoꞌi zu kuranoꞌi. Zamazeꞌe urateꞌohe, rehano ahirizeꞌe taoḡa.” ");
INSERT INTO ksj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ebu ani bare onamadu ibite kuraroteꞌe teige kuraro. ");
INSERT INTO ksj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Aniꞌa bare arirotene, ze bazeꞌeteꞌe bare horoziro, mazaḡa ubumazeꞌa ufeta anoziro. Zeꞌe ani mazao nagini reiteꞌe mene ederiro. ");
INSERT INTO ksj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Iesuꞌa ḡae uḡiduḡano bare aradu ziro, “Za ꞌize bazeꞌehe zu ahirize ohoneꞌehe? Eꞌe daꞌo! Madaḡa ꞌai maha. Ḡianoꞌi, Vaze Ubugaꞌe haḡai sauꞌa azaḡa ꞌevoreo riꞌiniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Iḡunoꞌi, eme onamihi! Ḡianoꞌi, eḡe revoniꞌeteꞌe vazeḡa ꞌai feureha.” ");
INSERT INTO ksj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesuꞌa ꞌize ḡoereꞌeteꞌea, Iesu tahiꞌa gaubanana aheu fare boꞌaḡano ꞌahoga Iudaꞌa feuriro. Dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa, Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zu vaze boroboroꞌa tuḡuziroteꞌe azaḡa ḡuḡuvaḡaniꞌa benisi zu somori boro madu Iuda teite ariro. ");
INSERT INTO ksj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ebu Iesu revohauꞌeteꞌe vazeḡaꞌe aneꞌa nougenouge haḡaiteꞌe moneo ibite ihoziro, “Eḡeꞌa furaꞌiniteꞌe vazeḡaꞌe Iesu. Ani obone teadu zamahu onamoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ebu aniꞌa zogone Iesu vaḡe onamadu niro, “Ihore vazeḡa!” Ebu aniꞌa furaꞌiniro. ");
INSERT INTO ksj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ebu ze ꞌevoreze hina Iesu obone tiro. ");
INSERT INTO ksj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Eꞌe madaḡano Iesu uhiḡano edau radiroteꞌe azaḡa boꞌaḡano ꞌahoganiꞌa benisiḡa ahase bunadu dibuꞌo vazeḡa ḡihiꞌaḡa tuḡure vazeḡa udirotene, teḡaḡa variꞌe butiro. ");
INSERT INTO ksj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iesuꞌa ziro, “Zaꞌe ḡonore vazeḡa obone tiꞌeteꞌe teige, benisi ebu somori boro madu eḡe obohe touga veize arahe? ");
INSERT INTO ksj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mada niduꞌa eꞌe zae teite kuru neḡa habaꞌano ihore radiunu. Eꞌe madaḡano zaꞌe mene obohe tiro. Rehano Buka Zaḡoḡano mirihiroteꞌe ḡoeꞌaniꞌa hudafine, ꞌahiguḡaniꞌa fureraneha.” ");
INSERT INTO ksj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ꞌOugirotene, ane tahiꞌa niduꞌaꞌe Iesu muhine feraro. ");
INSERT INTO ksj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tahiꞌa iziga ꞌahogaꞌe ahiꞌa isoḡa rana dabua rafaḡa vidanadu Iesu hegotiro. Rehano Iesu obone tirotene, ");
INSERT INTO ksj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ani dabuaḡa mae modadu ani firina feraro. ");
INSERT INTO ksj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Zeꞌa Iesu obone teadu dibuꞌo vazeḡa ḡihiꞌaḡa vaḡe tutune onamiro. Ebu dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa, vaze boroboro zu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡaniꞌa tiburu nuꞌoraro. ");
INSERT INTO ksj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","U Peteroꞌe faḡanonoꞌo Iesu hegotadu dibuꞌo vazeḡa ḡihiꞌaḡa ne habaꞌano feuriro. Ebu eꞌe neḡa ḡianeꞌeteꞌe azaḡa teite ehoradu aneꞌa bare ire roga idiro. ");
INSERT INTO ksj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu Iuda azaḡa nuꞌonuꞌo boro auḡeꞌeteꞌe azaḡaniꞌa Iesu manoga veize ani moneo ḡuriro ḡoeꞌa nunu vaḡiro, rehano ze mene horoniro. ");
INSERT INTO ksj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Vaze ḡehaḡaniꞌa Iesu mazao ḡuriro ḡoeꞌa nunu rae fureniro, rehano zeḡe ḡoereꞌe mene tiba reiro. ");
INSERT INTO ksj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ebu vaze nuꞌa edau iḡunadu ani mazao ḡuriro ḡoeꞌa rae fureniro, ");
INSERT INTO ksj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Eme aniꞌa reiroteꞌe ḡoeꞌa igiro. Aniꞌa raenaꞌa, 'Eꞌe vazeꞌa ꞌevoreze hina ogoraroteꞌe kuruḡa neḡa ꞌahi fahiꞌuma, ebu vaze ꞌevore hina mene haḡairoteꞌe kuruḡa neḡa mada uḡiduḡa zamaḡano bare ogoraꞌuma,' rae reiro.” ");
INSERT INTO ksj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Rehano zeḡe ḡoereꞌe mene idaḡa reiro. ");
INSERT INTO ksj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ꞌOuge reirotene, dibuꞌo vazeḡa ḡihiꞌaḡaniꞌa zeḡe zamao edau iḡunadu Iesu ḡadiniro, “Zeꞌa ḡaꞌe veꞌoḡa rae fureneꞌohe. Ḡa zeḡe ḡoere mene naenaeniꞌumahe?” ");
INSERT INTO ksj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Rehano Iesuꞌe sifu radiro ebu mene naenaeniro. Dibuꞌo vazeḡa ḡihiꞌaḡaniꞌa bare ḡadiniro, “Ḡaꞌe Keriso, Ḡihiꞌa Hune Badiꞌaḡa Ubugahe?” ");
INSERT INTO ksj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iesuꞌa niro, “Oꞌe, eꞌe Keriso. Zaꞌe Vaze Ubuganiꞌa Gigiꞌa Boro Badiꞌaḡa edaꞌe moneo ehoradu zuhiꞌaziꞌeteꞌe zu adureo ḡoze hina areꞌeteꞌe horoniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ꞌOugadu dibuꞌo vazeḡa ḡihiꞌaḡaniꞌa ane dabua zigiro ebu ḡadiziro, “Emeꞌa aniꞌe veꞌoḡa rae raꞌeteꞌe vazeḡa bare vaḡiꞌumahe? ");
INSERT INTO ksj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Izidi aniꞌa Badiꞌa rae sausaunateꞌe zae niduꞌa egeha. Za nouge rae zamareꞌohe?” Zeḡe niduꞌa naenaeniro, “Aniꞌe veꞌoḡa radu runeo tuḡuniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ebu vaze nuꞌa ani rana soꞌabide vaniro, ebu ani ubuma ꞌuadu ꞌevoreze hina faꞌoneꞌenaꞌa niro, “Peroveta Vazeḡa, efoꞌi. Iniuꞌa faꞌoꞌeha?” Ebu kota neḡa ḡiane radiuꞌeteꞌe uti azaḡaniꞌa ani zamahanadu bouniro. ");
INSERT INTO ksj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peteroꞌa kota neḡa habaꞌa ꞌuꞌuḡano radiuꞌeteꞌea, dibuꞌo vazeḡa ḡihiꞌaḡa tuḡure roḡaeḡa ꞌahoganiꞌa ariro. ");
INSERT INTO ksj_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Aniꞌe Peteroꞌa ire roga genaḡano ideꞌeteꞌe horonirotene, Petero ḡiane runeꞌenaꞌa niro, “Ḡa zuni Nazareta vazeḡa Iesu teite radiudo.” ");
INSERT INTO ksj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Rehano Peteroꞌa oꞌonadu niro, “E ḡaeꞌa nagini raꞌetaꞌaꞌe mene edereꞌohe zu mene zamare huneꞌohe.” Ebu Peteroꞌe ḡabiri ibihetaḡano buau onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tuḡure roḡaeḡaniꞌa Petero eꞌea horonirotene, edau varahiroteꞌe azaḡa bare ziro, “Vaze ꞌahiꞌe Iesu duḡuru boꞌaḡano ꞌahoga.” ");
INSERT INTO ksj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Rehano Peteroꞌa bare oꞌoniro. Mada tahiḡa ḡarugano ani uhiḡano edau radiuꞌeteꞌe azaḡaniꞌa niro, “Hube hune ḡa Iesu hegoteꞌeteꞌe azaḡa boꞌaḡano ꞌahoga, mazaḡa ḡae zuni Galilea vazeḡa.” ");
INSERT INTO ksj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ebu ani ḡoere rinede teadu ziro, “E ḡuririne, aduga hidiꞌuma. E zaeꞌa raꞌeteꞌe vazeḡa aꞌe aḡuꞌa!” ");
INSERT INTO ksj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Aniꞌa ꞌouge reirotene, kokorokuꞌa ḡae aheuḡa ugaro. ꞌOugadu Peteroꞌe Iesuꞌa ani niroteꞌe ḡoeꞌa zamariro, “Kokorokuꞌa ḡae aheu ꞌizema uganogano, ḡaꞌe ḡae uḡidu eḡe oꞌohiꞌuma.” Ebu ani rahao ḡuḡuradu niaro. ");
INSERT INTO ksj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Oherebau uzeuze, dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡaniꞌa vaze boroboro zu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa teite ḡoꞌaniro. Aꞌe Iuda azaḡa nuꞌonuꞌo boro. Ebu ze Iesu autadu Pilato vaḡe tutune onamiro ebu ane ꞌevora riꞌiniro. ");
INSERT INTO ksj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatoꞌa Iesu ḡadiniro, “Ḡaꞌe Iuda azaḡa kinihe?” Iesuꞌa naenaeniro, “Oꞌe, ḡa ḡaeꞌa bare eꞌe kini raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡaniꞌa ḡau ḡehaḡa moneo Iesuꞌe veꞌoḡa rae niro. ");
INSERT INTO ksj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatoꞌa bare Iesu ḡadiniro, “Ḡa mene naenaeziꞌumahe? Ḡianoꞌi, zeꞌa ḡaꞌe veꞌoḡa rae raꞌeteꞌe ḡoeꞌa ḡehaḡa rae fureneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Rehano Iesuꞌe ꞌize mene bare naenaeziro ebu Pilatoꞌa zaguzagau huniro. ");
INSERT INTO ksj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Iḡine Modiroteꞌe Muiḡa madaḡano Roma gavana vazeḡaꞌe Iuda azaḡaniꞌa urateꞌeteꞌe ḡuꞌa vazeḡa ꞌahoga tuḡune bunido. ");
INSERT INTO ksj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Eꞌe madaḡano vaze ꞌahoga, niḡa Barabasiꞌe Roma gavana utitoziniroteꞌe madaḡano vaze zimiroteꞌe azaḡa teite ḡuꞌa neḡano ohoniro. ");
INSERT INTO ksj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Vaze ḡuḡuvaḡaniꞌa Pilato vaḡe onamadu aniꞌa zeḡe veize haḡaidoteꞌe teige ꞌouge haḡaoga uminiro. ");
INSERT INTO ksj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatoꞌa ḡadiziro, “Za eḡeꞌa Iuda azaḡa kini tuḡune bunoga urateꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Mazaḡa Pilatoꞌe dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡaniꞌa Iesu ahiahiniroteꞌe uꞌano, ani riꞌinirotaꞌaꞌe ederiro. ");
INSERT INTO ksj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Rehano dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡaniꞌa Barabasi tuḡune bunoga veize vaze ḡuḡuvaḡaniꞌa Pilato uminoga tuḡutuḡuziro. ");
INSERT INTO ksj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ebu Pilatoꞌa ḡadiziro, “Tena e zaeꞌa Iuda azaḡa kini rae huneꞌeteꞌe vazeḡa mazao nougiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ze ḡihau huaro, “Aniꞌe satauronoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatoꞌa ḡadiziro, “Nougadu? Ani nagi haḡai sauꞌa haḡairo?” Rehano ze ḡihau bagaḡa hounaꞌiro, “Ani satauronoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatoꞌa vaze ḡuḡuvaḡa matuꞌozenoga veize Barabasi zeḡe mazao mae bohane buniro. Ebu Iesuꞌe masiniroteꞌe enogano satauronoga veize uti azaḡa ꞌevoreo riꞌiniro. ");
INSERT INTO ksj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Uti azaḡa nuꞌa Iesuꞌe gavana vazeḡa ne zamaḡa tutune diuḡiro ebu uti azaḡa niduꞌa huze nuꞌoziro. ");
INSERT INTO ksj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ebu ze Iesu dabua kanaḡa duhuḡa hune vidoharo, zu ire ezaga meigameiga ḡurunadu kini vadiga adiriḡa teige vadinigano redoharo. ");
INSERT INTO ksj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ebu Iesu ḡirihoharo, “Iuda azaḡa kini, nigunihi!” ");
INSERT INTO ksj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ze Gubu somoriḡa ꞌahoga hina ane vadini rana barebare bouniro ebu soꞌabide vaniro. Ze obenaze hina tuḡadu ani mazao soꞌone ḡuḡuriro. ");
INSERT INTO ksj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ḡirihohau hauḡirotene, ani vidoharoteꞌe dabuaḡa kanaḡa fuiꞌadu ane dabua bare vidoharo. Ebu satauronoga radu tutune onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kurene vazeḡa ꞌahoga, Alesana zu Rufo moze, niḡa Simonaꞌa guniꞌa neḡanonoꞌo vitau onaminu. Ebu uti azaḡaꞌe aniꞌa Iesu satauro herate onamoga veize tuḡutuḡuniro. ");
INSERT INTO ksj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ze Iesuꞌe Gologota rae huneꞌeteꞌe habaꞌa tutune onamiro. Gologota hugaꞌe Vadini Isiga Habaꞌa. ");
INSERT INTO ksj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ebu ze murava ꞌahoga vaini vuḡa teite mirunadu Iesu haro, rehano ani mene meiro. ");
INSERT INTO ksj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ebu ze Iesu satauroniroteꞌe enogano Iesu dabuaꞌe iniuꞌa meꞌuma radu kaḡusi arahoḡa arahiro ebu ḡahugotitiro. ");
INSERT INTO ksj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ze ani satauroniroteꞌe madaḡaꞌe oherebau mone mada fuꞌo ḡazaḡa fare. ");
INSERT INTO ksj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Iesu haḡai sauꞌaꞌe nagini rae ihozifine ane satauro hitagano ꞌahige rae mirihiro, “IUDA AZAḠ KINI.” ");
INSERT INTO ksj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ebu ḡonore azaḡa aheu zuni ani teite satauroziro. ꞌAhogaꞌe ane edaꞌe moneo zu ꞌahogaꞌe ane kauri moneo ikokoziro. ");
INSERT INTO ksj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ebu uhiḡano vitau onameꞌeteꞌe azaḡaniꞌa vadinize miruneꞌenaꞌa, Iesu rae sausauniro, “Uuu! Ḡaꞌe kuru neḡa fahadu mada uḡidu zamaḡano bare ogoraꞌuma rae reiroteꞌe vazeḡa! ");
INSERT INTO ksj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ḡa satauronoꞌo buau ovadu ḡae bare ḡaboꞌoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Eꞌe teige, dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa ebu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡaniꞌa ḡirihohauꞌenaꞌa ḡoeriro, “Aniꞌa vaze nunu ḡaboziro, rehano ani ane bare ḡabonogaꞌe mene idaḡa! ");
INSERT INTO ksj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Aniꞌe Iuda azaḡa kini, Keriso. Eꞌanoꞌo izidi hune satauronoꞌo bua ovaoꞌi, ꞌougine emeꞌa horonadu ani mazao fiꞌuma!” Iesu teite idaḡa satauroziroteꞌe azaḡaniꞌa zuni ani rae sausauniro. ");
INSERT INTO ksj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Madai kirikiri meirotene, haba niduꞌa uzaboꞌa ꞌuiro, onamo ḡorava mone mada uḡidu. ");
INSERT INTO ksj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ḡorava madaḡa uḡidu meirotene, Iesuꞌa ḡihau huaro, “Eli, Eli, lama sabatani?” Ḡoere eꞌe hugaꞌe, “Eḡe Badiꞌa, eḡe Badiꞌa, ḡa nougadu eḡe modeha?” ");
INSERT INTO ksj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Eꞌea edau radiroteꞌe azaḡa boꞌaḡano nuꞌa ḡoere eꞌe egadu ꞌahige rae reiro, “Egoꞌi, aniꞌa Elia huneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Vaze ꞌahoganiꞌa dure onamadu vu romane zouneꞌeteꞌe ḡauḡa meiro, ebu vaini vuḡa ḡiḡiꞌa iriꞌavonadu Gubu somoriḡa rana tiro, ebu Iesu gagoharo. Ebu aniꞌa ꞌahige rae reiro, “Ani modoꞌi. Eliaꞌa ovadu ḡaboniꞌuma ga mene, ḡianihi.” ");
INSERT INTO ksj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ebu Iesuꞌa agoḡa boro hina huanadu iriga riꞌiro. ");
INSERT INTO ksj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Eꞌe madaḡano kuru neḡano Haba Zaḡoḡa Hune ꞌueꞌeteꞌe dabuaḡaniꞌa hitaganonoꞌo ꞌuꞌuḡa ḡuzu zigau ꞌaꞌadaro. ");
INSERT INTO ksj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ebu uti vazeḡa boro Iesu zamao edau radiroteꞌeꞌa Iesuꞌe nougenouge rudaroteꞌe horonirotene, ꞌahige rae reiro, “Vaze ꞌahiꞌe hube hune Badiꞌa Ubuga!” ");
INSERT INTO ksj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Roḡae nu zuni faḡanonoꞌo ehamu radiro. Zeḡe boꞌaḡanoꞌe Magadala roḡaeḡa Maria, ebu Iakobo zuhuꞌa zu Iose vize Maria, ebu roḡae ꞌahoga Salome zuni eꞌea edau radiro. ");
INSERT INTO ksj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Zeꞌe Galilea habaꞌano Iesu hegoteꞌenaꞌa ani dananido. Ebu Iesu teite Ierusalema eriroteꞌe roḡaeḡaroḡaeḡa zuni ḡehaḡa. ");
INSERT INTO ksj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Aꞌe Bana Madaḡa ꞌizema mougano, Bana Madaḡa ruhibeꞌeteꞌe ḡoravaḡa. ");
INSERT INTO ksj_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimate vazeḡa, niḡa Iosefaꞌa ariro. Aniꞌe vaze manoḡa zu Iuda azaḡa nuꞌonuꞌo ibitohauꞌeteꞌe vazeḡa boro ꞌahoga. Aniꞌe Badiꞌaꞌa zuhiꞌaziꞌeteꞌe guhine radiunu. Ani mene rihauꞌenaꞌa, Pilato vaḡe onamadu Iesu ahiri mouga veize uminiro. ");
INSERT INTO ksj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatoꞌe Iesuꞌa rudaroteꞌe igirotene zaguzagaro. Ani hube hune rudana ga meneꞌe ederihi radu, uti vazeḡa boro ꞌahoga huniro ebu ḡadiniro. ");
INSERT INTO ksj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilatoꞌa uti vazeḡa boro mazaonoꞌo Iesu rune igirotene, ani Iesu ahiri Iosefa ꞌevora riꞌiniro. ");
INSERT INTO ksj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ꞌOugadu Iosefaꞌa dabua manoḡa hoitiro ebu Iesu satauronoꞌo mae bunadu dabua eꞌe hina ꞌumiro. Ebu vatava huꞌiroteꞌe iduḡa zamaḡano Iesu ahiri teadu hadi boro hina ibihetaḡano kiune ꞌuiro. ");
INSERT INTO ksj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magadala roḡaeḡa Maria zu Iose viꞌa Mariaꞌe Iesu ahiriꞌe nouma gureꞌeteꞌe murire radiro. ");
INSERT INTO ksj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Bana Madaḡa enogano, Magadala roḡaeḡa Maria zu Iakobo viꞌa Maria ebu roḡae ꞌahoga Salome, ze Iesu ahiri asifine murava hohoḡa hoitiro. ");
INSERT INTO ksj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Fura oherebau uzeuze, madaꞌa itiroteꞌe madaḡano zeꞌe idu onamiro. ");
INSERT INTO ksj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ebu ze zeḡeꞌa bare ḡadimutitiro, “Iniuꞌa idu ꞌuiroteꞌe hadiḡa boro iduonoꞌo kiune vaḡiniꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Rehano zeꞌa dude ehamarotene, hadiḡa boro bagaḡa aꞌe kiune vaḡine touga horoniro. ");
INSERT INTO ksj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ze idu zamaḡa diuḡirotene, ohoze iziga ꞌahogaꞌe dabua ꞌuruḡa vidanadu edaꞌe moneo ehoreꞌeteꞌe horoniro. ꞌOugadu ze ḡihau zaguzagaro. ");
INSERT INTO ksj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Aniꞌa ziro, “Ago rihanoꞌi. Zaꞌe satauroniroteꞌe Nazareta vazeḡa Iesu vaḡeꞌohe. Aniꞌe bare ḡabodeha. Aniꞌe ꞌahao oꞌoꞌa. Ane bazune tiroteꞌe habaꞌa ḡianoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Izidi zaeꞌa onamadu ane tahiꞌatahiꞌa ebu Petero ꞌahige rae zoꞌi, 'Aniꞌe zae zamao Galilea habaꞌa ibite onamiꞌuma. Aniꞌa zae ziroteꞌe teige, eꞌea za ani horoniꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ze ahirizeꞌa rereruꞌenaꞌa zu rihau rudauꞌenaꞌa, idu zamaḡanonoꞌo buanadu ferau onamiro. Ze vazeni ꞌahoga mene niro, mazaḡa zeꞌe rihau rudaro. ");
INSERT INTO ksj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Fura oherebau uzeuze Iesuꞌa bare ḡabodirotene, ibite geno Magadala roḡaeḡa Maria mazao fureraro. Mariaꞌe ane mazaonoꞌo vine sauꞌa fuꞌo aheu fare Iesuꞌa hegoze buziroteꞌe roḡaeḡa. ");
INSERT INTO ksj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ani Iesu teite radiudoteꞌe azaḡaniꞌa zamaze areꞌeteꞌe zu niauꞌeteꞌe habaꞌa onamadu Iesu hariḡa ziro. ");
INSERT INTO ksj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Rehano ze Iesuꞌa ḡabodiroteꞌe ebu Mariaꞌa Iesu horoniroteꞌe igirotene, aꞌe mene mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Eꞌe enogano Iesu tahiꞌatahiꞌa boꞌaḡano aheuꞌa guniꞌa neḡa onamiroteꞌea, Iesuꞌe iraḡa nufadu ze mazao fureraro. ");
INSERT INTO ksj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ebu ze baradu Iesu tahiꞌatahiꞌa ziro, rehano zeḡe zuni vaze aheu eꞌe ḡoere mene mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Vesuꞌu Iesu tahiꞌatahiꞌa gaubanana tiba fareꞌa ogauꞌeteꞌea, Iesuꞌa ze mazao fureraro. Ebu ani zeꞌa fieꞌetaꞌaꞌe taoḡa zu zamaze tuḡa uꞌano roziro, mazaḡa ze aniꞌa bare ḡabodirotaꞌaꞌe horoniroteꞌe azaḡa ḡoere mene mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Aniꞌa ziro, “Zaꞌe habaꞌahabaꞌa niduꞌa onamadu hari manoḡa vaze niduꞌa mazao haramoꞌi. ");
INSERT INTO ksj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Iniuꞌa eḡe mazao fiadu babatiso maꞌeteꞌe vazeḡaꞌe ḡabone hidiꞌuma. U iniu mene fieꞌeteꞌe vazeḡaꞌe veꞌoḡa radu kotaniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ebu iniu eḡe mazao fieꞌeteꞌe vazeḡaꞌe ꞌahiguḡa haḡai nu badeḡa haḡaiꞌuma: Ze eḡe niḡano vine sauꞌa hegoze buziꞌuma, mazane ḡoeꞌano ḡoeriꞌuma, ");
INSERT INTO ksj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ꞌevoreze hina mohe mae ḡihiniꞌuma, ze rune muravaḡa gagine zuni sauꞌani ꞌahoga mene hune hidiꞌuma, ebu ꞌevoreze ugi azaḡa rana tine manoriꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Zuhiꞌa Boro Iesuꞌa ze ḡoreziroteꞌe enogano, ani adure ḡoha mae ḡihine itiro ebu Badiꞌa ꞌevore edaꞌe moneo ehoriro. ");
INSERT INTO ksj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ebu ane tahiꞌatahiꞌaꞌa habaꞌahabaꞌa onamadu haramiro. Ebu Zuhiꞌa Boroꞌe zeḡe teite gauiro, zu aniꞌa haḡai nu badeḡa haḡadu zeḡe haramoꞌe huga rae ihoziro. ");
INSERT INTO ksj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Vaze boro Teofilo, emeḡe boꞌaḡano naginiꞌa fureraroteꞌe moneo vaze ḡehaḡaniꞌa mirihozinihi radu inare huniro. ");
INSERT INTO ksj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Vaze nuꞌe Iesu hariḡa ḡadaheḡanonoꞌo onamo ḡonagano ubumaze hina horonadu ane ḡoere rae fureniro zu emeḡe ihofiro. Ebu zeḡeꞌa ihofiroteꞌe idunaḡano vaze ḡehaḡaniꞌa Iesu hari mirihiro. ");
INSERT INTO ksj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Vaze boro Teofilo, eḡe zuni eꞌe hariḡa niduꞌaꞌe ḡadaheḡanonoꞌo onao izidi faifaine udahiro. Ebu eḡeꞌa ḡae veize hari ꞌadi ḡadaheḡanonoꞌo onamo ḡonaga mirihine, manoḡa rae zamariro. ");
INSERT INTO ksj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Aꞌe ibite vazeꞌa ihoꞌirotaꞌaꞌe huga rae ḡaeꞌa ederifine raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Iudea habaꞌano Herodaꞌe kini reiroteꞌe madaḡano dibuꞌo vazeḡa ꞌahoga, niḡa Zekariaꞌa radiunu. Aniꞌe dibuꞌo azaḡa duḡuru ꞌahoga, Abia duḡuru mone dibuꞌo vazeḡa. Ebu inuga, niḡa Elizabetaꞌe Aroni mariga. ");
INSERT INTO ksj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zekaria zu Elizabetaꞌe Zuhiꞌa Boro goro ḡoeꞌa niduꞌa hegoteꞌenaꞌa, mene veꞌore radiunu ebu Badiꞌa ubumao duduḡa rae reiro. ");
INSERT INTO ksj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Rehano ze ubudeze oꞌoꞌa, mazaḡa Elizabetaꞌe gabani, zu anianineꞌe ufeta vouriro. ");
INSERT INTO ksj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Mada ꞌahogano Abia duḡuru dibuꞌo azaḡaniꞌa gaueꞌeteꞌe madaḡa meiro. Eꞌanoꞌo Zekaria zuni Badiꞌa kuru neḡano dibuꞌo vazeḡa gauḡa haḡairo. ");
INSERT INTO ksj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Eꞌe madaḡano dibuꞌo azaḡa haḡai idunaḡano ze kaḡusi arahoḡa arahiro, ebu Zuhiꞌa Boro kuru neḡano diuḡadu ꞌuvahu hohoḡa hufiteꞌe vazeḡa ꞌahoga ohoniro. Kaḡusi arahirotene, Zekaria meiro. ");
INSERT INTO ksj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ebu Zekariaꞌa kuru neḡano ꞌuvahu hohoḡa hufiꞌeteꞌe zamaḡano vaze ḡuḡuvaḡaꞌe kuru neḡa enogano kurau radiunu. ");
INSERT INTO ksj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Eꞌe madaḡano Zuhiꞌa Boro tuḡure viga ꞌahoganiꞌa Zekaria mazao fureraro. Aniꞌe ꞌuvahu hohoḡa hufiꞌeteꞌe fataḡa edaꞌe moneo edau radiro. ");
INSERT INTO ksj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zekariaꞌa tuḡure viga eꞌe horonirotene, ufeta zaguzagaro zu rihau rudaro. ");
INSERT INTO ksj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Rehano tuḡure viga eꞌeꞌa ꞌahige rae niro, “Zekaria, ago rihanoꞌi. Badiꞌaꞌa ḡae kuru igiro ꞌahine, inugo Elizabetaꞌe ubugo ꞌahoga fureniꞌuma. Ebu niḡaꞌe Ioane rae turahoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ḡaꞌe ani uꞌano matuꞌe rudaꞌuma, ebu vaze ḡehaḡa zuni aneꞌa fureraroteꞌe moneo matuꞌiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mazaḡa aniꞌe Zuhiꞌa Boro zamao niḡa boro reꞌuma. Aniꞌe vaini vuḡa zu vu sauꞌa mene gagiꞌuma, ebu viꞌa isi zamaḡanonoꞌo Vine Zaḡoḡaniꞌa ani ibitohaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Aniꞌe Isaraela azaḡa ḡehaḡa Zuhiꞌa Boro zeḡe Badiꞌa vaḡe tutuze ariꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ani viga zu gigiꞌaḡaꞌe peroveta vazeḡa Elia teigiꞌuma. Aniꞌe Zuhiꞌa Boro ꞌizema arogano ariꞌuma, ebu moze zu ubudeze zamaze mae tibuzifine danaziꞌuma. Zu Badiꞌa mene egohauꞌeteꞌe azaḡaꞌe duduḡa azaḡa zamarone huhuzaḡa ibiḡano tutuziꞌuma, ebu vazeꞌa Zuhiꞌa Boro veize ruhibifine ihoziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zekariaꞌa tuḡure viga niro, “Ḡae ḡoere eꞌeꞌa fureratitaꞌaꞌe e nougenouge ederiꞌuma? E vaze vouḡa ebu inudehe zuni voureha.” ");
INSERT INTO ksj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ebu tuḡure viganiꞌa naenaeniro, “Eꞌe Gabiriela. Eꞌe Badiꞌa zamao edanadu ane gau haḡaeꞌohe. Badiꞌaꞌa hari manoḡa ꞌadi ḡae ihoꞌifine eḡe tuḡuheha. ");
INSERT INTO ksj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ḡianoꞌi. Madaḡaniꞌa arine, eḡeꞌa rateꞌe ḡoeꞌaniꞌa hugano fureraꞌuma. Ḡaꞌe eḡe ḡoere ꞌadi mene mae ḡihinateꞌe uꞌano, ḡaꞌe ḡoeroga mene idaraꞌuma, onamo eꞌeguḡaniꞌa fureratiteꞌe madaḡa meꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","U vaze ḡuḡuvaḡaꞌe enogano Zekaria guhine radiunu ebu ꞌahige zamarinu, “Aniꞌa kuru neḡa zamaḡano nougadu faḡa hune radiuꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ebu Zekariaꞌa kuru neḡanonoꞌo buarotene, ani ḡorezoga mene idararo. Ani ꞌevoꞌa hina daꞌo ḡoreziro zu ḡoerogaꞌe mene idararo. Eꞌanoꞌo zeꞌe aniꞌa kuru neḡa zamaḡano ahiri raꞌaga iḡunaḡa horoniroteꞌe ederiro. ");
INSERT INTO ksj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ebu Zekariaꞌa kuru neḡano dibuꞌo gauḡa hauḡirotene, neḡa onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Eꞌe enogano ani inuga Elizabetaꞌe ene tiro ebu bato fuꞌo ani neo radiunu. ");
INSERT INTO ksj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Aniꞌa ꞌahige rae reiro, “Zuhiꞌa Boroꞌa eḡe veize ꞌahiguḡa haḡairo. Izidi Zuhiꞌa Boroꞌa vaze boꞌaḡano eḡe mazagaro mae vaḡiniro.” ");
INSERT INTO ksj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabetaꞌa ene tiroteꞌe enogano bato fuꞌo tiba fare reirotene, Badiꞌaꞌa tuḡure viga Gabiriela Galilea habaꞌa Nazareta neḡano tuḡuniro. ");
INSERT INTO ksj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ꞌOugadu ani roḡae ꞌahoga, niḡa Maria vaḡe onamiro. Mariaꞌe ohoze teite ꞌize mene baziroteꞌe nogobaḡa. Aniꞌe Davida mariga ꞌahoga, niḡa Iosefa teite iraꞌauniro. ");
INSERT INTO ksj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabirielaꞌa Maria vaḡe aradu niro, “Badiꞌaꞌa manoḡa haroteꞌe roḡaeḡa, matuꞌoꞌi. Zuhiꞌa Boroꞌa ḡae teite radiuꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mariaꞌa ḡoere eꞌe igirotene, zaguzagaro zu ꞌadaꞌadaniro, ebu “Ḡoere ꞌadi hugaꞌe nagini?” rae zamariro. ");
INSERT INTO ksj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ebu tuḡure viganiꞌa Maria niro, “Maria, ago rihanoꞌi, mazaḡa Badiꞌaꞌa ḡae mazao manoḡa fureniro. ");
INSERT INTO ksj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ḡianoꞌi! Ḡaꞌe ene teadu ubugo ꞌahoga fureniꞌuma ebu niḡaꞌe Iesu rae turahiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Aniꞌe niḡa boro reꞌuma, ebu vazeꞌa aniꞌe Badiꞌa Hitaga Hune Ubuga rae huniꞌuma. Ebu ane vouḡa Davida teige, Zuhiꞌa Boro Badiꞌaꞌa aniꞌe kini iḡuri haꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Aniꞌa Isaraela azaḡa zuhiꞌaziꞌuma onamo tuḡutuḡu, ebu aniꞌa zuhiꞌaziꞌetaꞌaꞌe mene hauḡiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ebu Mariaꞌa tuḡure viga niro, “Eꞌe ohoze teite bazoga ꞌize aḡuꞌa. Nougenouge ꞌuguḡaniꞌa fureraꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ebu tuḡure viganiꞌa naenaeniro, “Vine Zaḡoḡaniꞌa ḡae vaḡe ovaiꞌuma, zu Badiꞌa Hitaga Hune inaraḡaniꞌa ḡae zauhaḡadiꞌuma. Eꞌanoꞌo fureratiteꞌe tahiꞌaḡaꞌe zaḡoḡa reꞌuma zu Badiꞌa Ubuga rae huniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ḡianoꞌi, ḡae nabugo Elizabeta zuni vouḡa ebu gabani rae huniro, rehano ene ohozeḡa teadu izidi bato fuꞌo tiba fare maha. ");
INSERT INTO ksj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Badiꞌaꞌe gau niduꞌa haḡaogaꞌe idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ebu Mariaꞌa naenaeniro, “Eꞌe Zuhiꞌa Boro tuḡure roḡaeḡa. Ḡaeꞌa rateꞌeꞌa eḡe mazao fureranoꞌi.” Ebu tuḡure viganiꞌa ani muhiniro. ");
INSERT INTO ksj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Eꞌe ḡarugano Mariaꞌa iḡunadu Iudea habaꞌano guniꞌa neḡa ꞌahoga ḡarihe onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ebu aniꞌa feurirotene, Zekaria ne diuḡadu Elizabeta niro, “Manoḡahe?” ");
INSERT INTO ksj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabetaꞌa Maria ago igirotene, ubugaꞌe isi zamaḡano hagariro, ebu Vine Zaḡoḡaniꞌa Elizabeta mazao iriꞌaviro. ");
INSERT INTO ksj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ebu Elizabetaꞌa Maria ḡihau niro, “Ḡaeꞌa roḡae niduꞌa boꞌaḡano manohuga ufeta hidiro. Ḡaꞌa fureniteꞌe tahiꞌaḡa zuni manohuga hidiro. ");
INSERT INTO ksj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Eḡe Zuhiꞌa Boro viꞌaꞌe eḡe vaḡe areha. Badiꞌaꞌa eḡe mazao manoḡa fureneha! ");
INSERT INTO ksj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Eḡeꞌa ḡae ago egatene, eḡe isi zamaḡano tahiꞌa komeꞌaꞌe matuꞌeꞌenaꞌa, hagareha. ");
INSERT INTO ksj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ḡa matuꞌe rudauꞌohe, mazaḡa ḡa Zuhiꞌa Boroꞌa ḡaniroteꞌe ḡoeꞌaniꞌa hudaꞌuma rae mae ḡihiniro.” ");
INSERT INTO ksj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ebu Mariaꞌa ꞌahige rae reiro, “E Zuhiꞌa Boro niguneꞌohe, ");
INSERT INTO ksj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ebu vineheꞌe eḡe ḡaboheꞌeteꞌe Badiꞌaḡa uꞌano matuꞌe rudauꞌohe, ");
INSERT INTO ksj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","mazaḡa eꞌe tuḡure roḡaeḡa zu nihe zuhuꞌa rehano, Badiꞌaꞌa eḡe zamariro. Izidionoꞌo onamo mada niduꞌa, vaze niduꞌa ꞌahige rae reꞌuma, 'Gaꞌe Badiꞌaꞌa matuꞌoḡaniro.' ");
INSERT INTO ksj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Mazaḡa Badiꞌa Gigiꞌaḡaniꞌa eḡe veize gau boro haḡairo. Ani niꞌe zaḡoḡa. ");
INSERT INTO ksj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Aniꞌe ani gubaneꞌeteꞌe azaḡa vetuḡaziꞌohe, zu zeḡe mariga niduꞌa vetuḡaziꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Aniꞌe ꞌevoꞌa hina haḡai gigiꞌaḡa haḡairo, ebu iniu zeḡeꞌa bare nize mae iteꞌeteꞌe azaḡa hegoze ḡururuziro. ");
INSERT INTO ksj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Aniꞌe kini niduꞌa zeḡe ehoro habaꞌanonoꞌo hegoze vaḡiziro, u iniu zeḡeꞌa bare nize mae ovoeꞌeteꞌe azaḡa mae ḡihiziro. ");
INSERT INTO ksj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Aniꞌa vinizeꞌeteꞌe azaḡa mazao ḡau manoḡa iriꞌavoniro, u maꞌora azaḡaꞌe ꞌevoreze isoḡa tuḡuze buziro. ");
INSERT INTO ksj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Aniꞌa ane mone azaḡa vetuḡaziꞌuma rae ḡoitorirotaꞌaꞌe zamaradu ane tuḡure azaḡa, Isaraela azaḡa danaziro. ");
INSERT INTO ksj_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Badiꞌaꞌa emeḡe vouḡa ziroteꞌe idunaḡano, Aberahamo zu ane mariga vetuḡaziro ebu vetuḡaziꞌuma onamo tuḡutuḡu.” ");
INSERT INTO ksj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ebu Mariaꞌe Elizabeta teite bato uḡidu heuḡa radadu neḡa bare onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabetaꞌa ene fureniteꞌe madaḡa meirotene, ubuga fureniro. ");
INSERT INTO ksj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ebu neḡa azaḡa zu nabuga duḡuruꞌa Elizabeta mazao Badiꞌaꞌa manoḡa fureniroteꞌe egadu ane teite matuꞌiro. ");
INSERT INTO ksj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Eꞌe enogano mada fuꞌo uḡidu fare meirotene, ze tahiꞌa ahiꞌa rana iḡuri haḡaihi radu ariro, ebu tahiꞌa niḡaꞌe moga Zekaria ni turahihi reiro. ");
INSERT INTO ksj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Rehano viꞌaniꞌa ziro, “Mene, ani niꞌe Ioane rae turahiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ebu zeꞌa naenaeniro, “Ḡae nabugo niduꞌa boꞌaḡano eꞌeguḡa niḡaꞌe oꞌoꞌa.” ");
INSERT INTO ksj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ebu ze ꞌevore hina moga ḡoreniro, “Ḡa niḡa iniu turahihi raꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ebu Zekariaꞌa ire rafaḡa umizadu eꞌe rana ꞌahige rae mirihiro, “Niḡaꞌe Ioane.” Ze eꞌe horonirotene, zeḡe niduꞌa zaguzagaro. ");
INSERT INTO ksj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Eꞌe madaḡano Zekaria hebeꞌa ꞌai zogone nahanadu ḡoerirotene agoḡaniꞌa buaro, ebu Badiꞌa niguniro. ");
INSERT INTO ksj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ne azaḡa niduꞌa eꞌe horonadu riharo. Ebu Iudea habaꞌano guniꞌa neḡa azaḡa niduꞌa zuni eꞌe hariḡa niduꞌa igiro. ");
INSERT INTO ksj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Eꞌe igiroteꞌe azaḡa niduꞌaꞌe eꞌe moneo zamaradu ꞌahige rae ḡadimutitiro, “Tahiꞌa ꞌadiꞌe zama moneo vaze nagiga reꞌuma?” Mazaḡa Zuhiꞌa Boro gigiꞌaḡaniꞌa hube hune ane mazao radiunu. ");
INSERT INTO ksj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Eꞌe enogano Vine Zaḡoḡaniꞌa Ioane moga Zekaria zamao iriꞌavadu Zekariaꞌa Badiꞌa ḡoere rae fureniro, ");
INSERT INTO ksj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Zuhiꞌa Boro Isaraela azaḡa Badiꞌa nigunihi. Mazaḡa aniꞌe Isaraela azaḡa vaḡe aradu haḡaize sauꞌanonoꞌo bohaze buziro. ");
INSERT INTO ksj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Badiꞌaꞌe ane tuḡure vazeḡa Davida marigaonoꞌo emeḡe ḡabofiteꞌe vazeḡa inaraḡa tuḡuniro. ");
INSERT INTO ksj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ibite madaḡano Badiꞌaꞌa ane peroveta azaḡa zaḡoḡaonoꞌo reiroteꞌe ḡoeꞌaniꞌa hudaroteꞌe teige, ");
INSERT INTO ksj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","aniꞌe emeḡe agire azaḡa mazaonoꞌo, ebu emeḡe heꞌeheꞌefeꞌeteꞌe azaḡa niduꞌa ꞌevoreonoꞌo ḡabofiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Aniꞌe vouḡafe vetuḡaziro, ebu zeḡe teite ḡoitoriroteꞌe ḡoeꞌa zaḡoḡa zamariro. ");
INSERT INTO ksj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Aꞌe vouḡafe Aberahamo mazao ḡoere rinede tiroteꞌe ḡoeꞌa. ");
INSERT INTO ksj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ꞌOugadu aniꞌe emeḡe agire azaḡa ꞌevoreonoꞌo ḡabofiro, ebu emeꞌa mene rihauꞌenaꞌa, ane veize gauifine danafiro. ");
INSERT INTO ksj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Eꞌanoꞌo emeḡe ḡabone niduꞌa zamaḡano emeꞌe Badiꞌa ubumao zaḡozaḡiꞌuma, ebu duduḡano radiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ebu Zekariaꞌa ubuga niro, “Eḡe ubude, ḡaꞌe Badiꞌa Hitaga Hune veize gaueꞌeteꞌe peroveta vazeḡa rae huḡadiꞌuma. Mazaḡa ḡaꞌe Zuhiꞌa Boro ibi ruhiboga veize ane zamao onamiꞌuma, ");
INSERT INTO ksj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ebu vaze haḡai sauꞌanonoꞌo ḡabone ziniꞌeteꞌe ibiḡa Badiꞌa mone azaḡa ihoziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Emeḡe Badiꞌaꞌe vetuḡafiꞌohe zu emeḡe zamare borofeꞌohe. Adureonoꞌo madaꞌa iteꞌeteꞌe teige, aniꞌa emeḡe mazao vaze ꞌahoga tuḡuniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Vaze ꞌahoganiꞌa uzabo zu rune zauhaḡa zamaḡano radiuꞌeteꞌe azaḡa agaḡa ziniꞌuma, ebu uniho manoḡa ibiḡano odafe ibitofiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ene aꞌe bororaro ebu vine moneo inariro. Aniꞌe haba bohaꞌano radiro, onamo hunio Isaraela azaḡa mazao fureraro. ");
INSERT INTO ksj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Eꞌe madaḡano Roma kiniḡa niḡaꞌe Augusto. Aniꞌe ane gau azaḡa mazao ḡoere ꞌahi tuḡuriro, “Roma habaꞌa niduꞌa zamaḡano radiuꞌeteꞌe azaḡa niduꞌa nize moꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nize maꞌeteꞌe gauḡa ꞌahiꞌe Kurenioꞌe Siria habaꞌa gavana vazeḡa reiroteꞌe madaḡano ḡae ibiꞌano haḡairo. ");
INSERT INTO ksj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Eꞌanoꞌo vaze niduꞌaꞌe nize zounifine, zeḡezeḡe haba onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Iosefaꞌe Galilea habaꞌano Nazareta neḡano radiunu. Aniꞌe Davida mariga. Betelehema neḡaꞌe Davida neḡa ꞌahine, aniꞌe Iudea habaꞌano Betelehema neḡa onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Iosefaꞌe Maria teite iraꞌauniro, eꞌanoꞌo Maria teite nize zounoga veize onamiro. Mariaꞌe ahiꞌeta. ");
INSERT INTO ksj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ze eꞌea radiuꞌeteꞌe zamaḡano, ene fureniteꞌe madaḡa meiro. ");
INSERT INTO ksj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ebu Mariaꞌe ubuga ibiꞌa fureniro zu dabua hina ꞌumadu boromakau ḡubuneꞌeteꞌe siuvaḡa zamaḡano ufi tiro, mazaḡa iꞌudo ne zamaḡano zeḡe bazuni habaꞌaꞌe oꞌoꞌa. ");
INSERT INTO ksj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Eꞌe oheꞌano mamoe taufeꞌeteꞌe azaḡaꞌe Betelehema neḡa uhiḡano haba bohaꞌano radiuꞌenaꞌa, mamoe taufinu. ");
INSERT INTO ksj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ebu Zuhiꞌa Boro tuḡure viga ꞌahoganiꞌa zeḡe mazao fureraro. Ebu Zuhiꞌa Boro agaḡaniꞌa agazirotene, zeꞌe rihau rudaro. ");
INSERT INTO ksj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Rehano tuḡure viganiꞌa ziro, “Ago rihanoꞌi. E hari manoḡa zae ihozoga radu areha. Vaze niduꞌa eꞌe igine matuꞌiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Izidi Davida neḡano zae ḡaboziteꞌe vazeḡaniꞌa zae veize fureraro. Aniꞌe Zuhiꞌa Boro Keriso. ");
INSERT INTO ksj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Za ene guraḡa dabua hina ꞌumadu boromakau ḡubuneꞌeteꞌe siuvaḡa zamaḡano bazunoga horonine, aniꞌe Keriso rae ederiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tabara adureonoꞌo tuḡure viga ḡuḡuvaḡaniꞌa fureranadu tuḡure viga eꞌe teite Badiꞌa niguneꞌenaꞌa, ꞌahige rae reiro, ");
INSERT INTO ksj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Hitana huneoꞌe Badiꞌa ni mae ḡihineꞌohe, ebu rahaoꞌe Badiꞌa matuꞌohauꞌeteꞌe azaḡa boꞌaḡano uniho manofeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tuḡure viga niduꞌa mamoe taufeꞌeteꞌe azaḡa muhizadu adure itirotene, mamoe taufeꞌeteꞌe azaḡaꞌe zeḡeꞌa bare neneḡaniro, “Eme Betelehema neḡa onamadu Zuhiꞌa Boroꞌa edemafeateꞌe ḡoeꞌaniꞌa hudanateꞌe ḡianihi.” ");
INSERT INTO ksj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Eꞌanoꞌo ze ḡarihe Betelehema neḡa onamiro. ꞌOugadu ze Maria zu Iosefa ohoziro, ebu boromakau ḡubuneꞌeteꞌe siuvaḡa zamaḡano bazeꞌeteꞌe tahiꞌaḡa komeꞌa zuni horoniro. ");
INSERT INTO ksj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ze tahiꞌa komeꞌa horonirotene, ani moneo tuḡure viganiꞌa ḡoeriroteꞌe ḡoeꞌa ihoziro. ");
INSERT INTO ksj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ḡoere eꞌe igiroteꞌe azaḡa niduꞌaꞌe mamoe taufeꞌeteꞌe azaḡaniꞌa reiroteꞌe ḡoeꞌa uꞌano zaguzagau ḡouriro. ");
INSERT INTO ksj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Rehano Mariaꞌe eꞌe hariḡa niduꞌa mae zamao ofadu zamare radiunu. ");
INSERT INTO ksj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mamoe taufeꞌeteꞌe azaḡaꞌe tuḡure viganiꞌa ziroteꞌe ḡoeꞌa niduꞌa fureraroteꞌe horoniro zu igiro. Eꞌanoꞌo ze Badiꞌa ni mae ḡihineꞌenaꞌa zu niguneꞌenaꞌa, bare oname ḡouriro. ");
INSERT INTO ksj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mada fuꞌo uḡidu fare meirotene, tahiꞌa ꞌadiꞌe ahiꞌa rana iḡuri haḡairo, ebu niḡaꞌe Iesu rae turahiro. Aꞌe, viꞌa ꞌizema ene tougano tuḡure viganiꞌa haroteꞌe niḡa. ");
INSERT INTO ksj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mariaꞌa Iesu fureniroteꞌe enogano, Mose goro ḡoeꞌa idunaḡano Iosefa zu Mariaꞌe ahirize deheneꞌeteꞌe madaḡa meiro. ꞌOugirotene, ze Iesu Zuhiꞌa Boro zamao ohonifine, Ierusalema zamahu itiro. ");
INSERT INTO ksj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Mazaḡa Zuhiꞌa Boro goro ḡoeꞌano ꞌahige rae mirihiro, “Ene ohozeḡa ibiꞌa niduꞌaꞌe Zuhiꞌa Boro veize zaḡozaḡoziꞌuma zu ḡaboneze Zuhiꞌa Boro haꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ebu Zuhiꞌa Boro goro ḡoeꞌano, “Tubugo niniḡa aheu ga nini komeḡa aheu Badiꞌa dibuꞌohaꞌuma,” rae reiroteꞌe idunaḡano haḡaifine, ze Iesu zamahanadu Ierusalema itiro. ");
INSERT INTO ksj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Eꞌe madaḡano Ierusalemao vaze ꞌahoga, niḡa Simeonaꞌa radiunu. Aniꞌe haḡaiḡa duduḡa zu Badiꞌa ḡoere hegoteꞌeteꞌe vazeḡa. Aniꞌe Isaraela azaḡa ḡaboziteꞌe vazeḡa guhine radiunu, ebu Vine Zaḡoḡaꞌe ani teite radiunu. ");
INSERT INTO ksj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Vine Zaḡoḡaniꞌa Simeona ibite ꞌahige rae ihoniro, “Ḡaꞌe mene rudaꞌuma, onamo Keriso horoniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ebu Simeonaꞌe Vine Zaḡoḡaniꞌa ibitohanadu kuru neḡa diuḡiro. ꞌOugirotene, Iesu viꞌa moganiꞌa Mose goro ḡoeꞌa idunaḡano haḡaoga veize eneze Iesuꞌe zamahu diuḡiro. ");
INSERT INTO ksj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ebu Simeonaꞌa ꞌevoꞌa hina Iesu mae ohanadu Badiꞌa niguniro, ");
INSERT INTO ksj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Zuhiꞌa Boro, ḡaꞌa ibite ḡoitoriroteꞌe ḡoeꞌa idunaḡano, izidi ḡaeꞌa eḡe, ḡae tuḡure vazeḡaꞌe zama roḡeḡaheta runeo tuḡuhe onamiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Mazaḡa e ubumahe hina ḡaeꞌa tuḡunadu vaze ḡaboziteꞌe vazeḡa horoniro. ");
INSERT INTO ksj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Aniꞌe ḡaeꞌa vaze niduꞌa zamao ruhibiro, ");
INSERT INTO ksj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","zu aniꞌe Iuda mene azaḡa Badiꞌa ihoziteꞌe agaḡa. Ani uꞌano, ḡae mone azaḡa, Isaraela azaḡa nize mae ḡihiniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Iesu viꞌa mogaꞌe Simeonaꞌa Iesu moneo reiroteꞌe ḡoeꞌa igirotene zaguzagaro. ");
INSERT INTO ksj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ebu Simeonaꞌa ze manohuga hidifine kuraro, ebu viꞌa Maria niro, “Tahiꞌa ꞌadiꞌe Badiꞌaꞌa ohoniro. Isaraela azaḡa boꞌaḡano vaze ḡehaḡaniꞌa ani mene mae ḡihiniro ꞌahine, ḡabone ibiḡanonoꞌo buaꞌuma. U vaze ḡehaḡaniꞌa ani mae ḡihinadu ḡabone ibiḡano edaꞌuma. Ebu vazeꞌa ani uꞌano Badiꞌaꞌa gaueꞌeteꞌe horoniꞌuma, rehano vaze ḡehaḡaniꞌa ani rae sausauniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Eꞌe uꞌano, vaze zamaroneze sauꞌa niduꞌa fureraꞌuma. Ebu tahiꞌa ꞌahi uꞌano, benisiꞌa ḡouꞌiꞌeteꞌe teige, zamaḡoꞌe adudaꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Peroveta roḡaeḡa ꞌahoga, niḡa Ana zuni Ierusalemao radiunu. Aniꞌe Fanuela aboḡa ebu Asere urabo roḡaeḡa. Aniꞌe roḡae ufeta vouḡa. Ani hahuradu muri fuꞌo aheu fare enogano iꞌaniꞌa rudaro. ");
INSERT INTO ksj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ebu ḡozoba radiu onamo izidi muriḡa 84 ꞌai meiro. Aniꞌe iḡaiḡa kuru neḡa onaminu, ebu ohere zu madai ogomu moneo zaḡozaḡeꞌenaꞌa, Badiꞌa mazao kuraunu. ");
INSERT INTO ksj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeonaꞌe Maria zu Iosefa teite ḡoereꞌeteꞌe zamaḡano, Anaꞌa zeḡe vaḡe aradu Badiꞌa mazao manoḡa tauḡi rae reiro. Ebu Badiꞌaꞌa Ierusalemaꞌe agire azaḡa mazaonoꞌo bohane buniteꞌe madaḡa guhineꞌeteꞌe azaḡa mazao tahiꞌa ꞌadi moneo ihoziro. ");
INSERT INTO ksj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Iosefa zu Mariaꞌe Zuhiꞌa Boro goro goeꞌa idunaḡano Ierusalemao gau niduꞌa hauḡirotene, ze Galilea habaꞌa onamadu zeḡe ne Nazaretao bare feuriro. ");
INSERT INTO ksj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tahiꞌa Iesu ꞌai bororaro zu inariro. Ebu aniꞌe tahiꞌa huhuzaḡa reiro, zu Badiꞌaꞌa ani mazao manoḡa fureniro. ");
INSERT INTO ksj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Muri iḡaiḡa Iḡine Modiroteꞌe Muiḡa madaḡano Iesu viꞌa mogaꞌe Ierusalema itido. ");
INSERT INTO ksj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Iesuꞌe muri gaubanana aheu fare meirotene, ze ꞌouge haḡaidoteꞌe teige, Mui eꞌe auḡifine Ierusalema itiro. ");
INSERT INTO ksj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ebu Mui hauḡadu Iesu viꞌa mogaꞌe neze onamirotene, Iesuꞌe Ierusalemao radiro, rehano viꞌa mogaꞌe mene ederiro. ");
INSERT INTO ksj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Zeꞌe ꞌahige rae zamariro, “Iesuꞌe vaze ḡunuḡano onameꞌohe.” Ze ibio onameꞌenaꞌa mada tiba vitinirotene, zeḡe nego nabudi boꞌaḡano Iesu vaḡiro. ");
INSERT INTO ksj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Rehano ze ani mene horonadu ani vaḡeꞌenaꞌa Ierusalema bare itiro. ");
INSERT INTO ksj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ebu mada uḡidu enogano kuru neḡano Iesu horoniro. Aniꞌe Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa teite ehoradu zeḡe ḡoere iginu zu ḡadimuzininu. ");
INSERT INTO ksj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ani ḡoere igiroteꞌe azaḡa niduꞌaꞌe ane edeḡa zu aniꞌa naenaeziroteꞌe ḡoeꞌa uꞌano zaguzagaro. ");
INSERT INTO ksj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Viꞌa moganiꞌa ani horonadu zeḡe zuni zaguzagaro. Viꞌaniꞌa niro, “Ubude, nougadu ꞌougeha? Mogo zu eḡeꞌa zamafe aduduꞌenaꞌa, ḡa vaḡeha.” ");
INSERT INTO ksj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ebu Iesuꞌa naenaeziro, “Za nougadu e vaḡeha? E eḡe Mama neo raditaꞌaꞌe za mene ederirohe?” ");
INSERT INTO ksj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Rehano viꞌa mogaꞌe aniꞌa nagini reirotaꞌaꞌe mene ederiro. ");
INSERT INTO ksj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Eꞌe enogano Iesuꞌe zeḡe teite Nazareta neḡa ovoiro ebu zeḡe ḡoere egoziniro. Viꞌaꞌe Iesu mazao fureraroteꞌe ḡauḡa niduꞌa ane zamao zamare radiunu. ");
INSERT INTO ksj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iesu zamarone huhuzaḡa zu ahiꞌaniꞌa bororaro, ebu Badiꞌa zu vazeꞌa ani zamare borofiro. ");
INSERT INTO ksj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Roma kiniḡa Tiberioꞌe Roma habaꞌa niduꞌa kiniḡa radu muri 15 zuhiꞌazinu. Eꞌe madaḡano Pontio Pilato'e Iudea habaꞌa gavanaḡa, Heroda'e Galilea habaꞌa kiniḡa negoḡa Filipi'e Iturea zu Tarakonito habaꞌa kiniḡa, ebu Rusaniaꞌe Abilene habaꞌa kiniḡa reiro. ");
INSERT INTO ksj_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","U Anasi zu Kaiafaꞌe dibuꞌo vazeḡa ḡihi'aḡaḡihiꞌaḡa reiro. E'e madaḡano Zekaria ubuga Ioane'a haba boha'ano radiunu, ebu Badiꞌa ḡoere'a ane mazao buaro. ");
INSERT INTO ksj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ani'e Ioridana vuḡa uhiḡano haba'ahaba'a nidu'a onamadu ꞌahige rae haramiro, “Haḡaize sauꞌanonoꞌo ḡihuradu babatiso moꞌi! ꞌOugine, Badi'a'a haḡaize sau'a rae modiꞌuma!” ");
INSERT INTO ksj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Peroveta vazeḡa Isaiaꞌa rae fureniroteꞌe ḡoeꞌa mirihiroteꞌe bukaḡano ꞌahige rae reiro, “Vaze ꞌahoganiꞌa haba boha'ano ḡihau ḡoere'ohe, raenaꞌa, 'Zuhiꞌa Boro veize ibi ruhiboꞌi, ani veize ibi mae dudunoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Do'oḡa nidu'a tuniꞌuma, ebu maḡa boro zu maḡa zuhu'a nidu'a mae sebaniꞌuma. Ibi beꞌoḡabeꞌoḡa duduniꞌuma, ebu ibi sauꞌasauꞌa fainiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ebu vaze nidu'a Badiꞌa'a zeḡe ḡaboze'ete'e horoni'uma.'” ");
INSERT INTO ksj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Vaze ḡuḡuvaḡaniꞌa Ioane mazaonoꞌo babatiso mouga radu Ioane vaḡe arirotene, aniꞌa ziro, “Zaꞌe Zarama ubugaubuga! Iniuꞌa zae mazao, 'Badiꞌa zama ḡugiꞌanonoꞌo ferau muhinoꞌi,' rae reiro? Aꞌe mene idaḡa! ");
INSERT INTO ksj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Rehano ibite haḡaize sau'anono'o ḡihuniroteꞌe haḡaiḡa izidi furenoꞌi. Ebu ꞌahige ago zamaroꞌi, 'Emeꞌe Aberahamo mariga, eꞌanoꞌo Badiꞌaꞌa emeḡe mazao mene maḡuniꞌuma.' Eḡeꞌa ziꞌohe, Badi'a'a hadi ꞌadi hina Aberahamo mariga haḡaoga zuni idaḡa. ");
INSERT INTO ksj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ḡiro 'ai ire taigano amahi tiro. Eꞌanoꞌo huga manoḡa mene iniꞌeteꞌe ireḡa niduꞌa'e udi higonadu ire rogao feuniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Vaze ḡuḡuvaḡani'a Ioane ḡadiniro, “Eme nougine manoḡa?” ");
INSERT INTO ksj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Aniꞌa naenaeziro, “Iniu dabuaḡa aheu ro'idene tibaꞌe dabuaḡa o'o'a vazeḡa hano'i. Ebu iniu ogomuḡeta roꞌidene vinineꞌeteꞌe vazeḡa teite ḡahugotito'i.” ");
INSERT INTO ksj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takesi azaḡa zuni babatiso mouga veize aradu Ioane ḡadiniro, “Ihore vazeḡa, eme nougine manoḡa?” ");
INSERT INTO ksj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Aniꞌa naenaeziro, “Takesi ufoꞌidene, gavamaniꞌa reiroteꞌe idunaḡano daꞌo ufo'i. Ago vitau ufoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ebu uti azaḡani'a zuni ḡadiniro, “Eme nougine manoḡa?” Ani'a naenaeziro, “Vaze hadi ago meize tauḡo'i, ebu veꞌoḡa oꞌoꞌa vazeḡa kotao ago ohonoꞌi. Zae gau hadiḡa daꞌo madu matu'o'i.” ");
INSERT INTO ksj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Vaze ḡehaḡaꞌe Kerisoꞌa ariteꞌe guhininu, eꞌanoꞌo zeꞌe, “Ioaneꞌe Keriso gaogi,” rae zamariro. ");
INSERT INTO ksj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Eꞌanoꞌo Ioane'a zeḡe nidu'a naenaeziro, “E'e vu hina babatisoziꞌohe. Rehano ariteꞌe vazeḡa'e gigi'aḡa boro hune. Aniꞌe eḡe vitihoga, zu eḡe'a ani tamaka miniḡa fuhiꞌeꞌeteꞌe tuḡureḡa vazeḡa rae rouga zuni mene idaḡa. Ani'e Vine Zaḡoḡa zu ire roga hina babatisozi'uma. ");
INSERT INTO ksj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Maho hiriveꞌeteꞌe madaḡano vazeꞌa kari hina rouḡa tenadu maho huꞌiꞌohe. Ebu iguḡa manoneꞌohe ebu meba hare deheneꞌohe. Ebu hugaꞌe nuꞌonadu suaba zamaḡano tiꞌohe, rehano iguḡaꞌe mene vidauꞌeteꞌe ire rogao hufi haoneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ebu Ioane'a ḡoere ḡehaḡa nunu hina iraduguzeꞌenaꞌa, hari manoḡa haramoziro. ");
INSERT INTO ksj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Rehano Ioane'a Galilea habaꞌa kiniḡa Heroda roniro, mazaḡa Herodaꞌe negoḡa inuga Herodia meiro zu haḡai sau'a nunu haḡairo. ");
INSERT INTO ksj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ebu Heroda'e haḡaiḡa sauꞌa eꞌe nidu'a ranao ꞌahoga ragatiro, mazaḡa Ioane ḡu'a neḡano mae ohoniro. ");
INSERT INTO ksj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ioaneꞌe ꞌizema ḡuꞌa neḡano mae ohonogano, ani vaze nidu'a babatisoziro ebu Iesu zuni babatisoniro. Ebu Iesuꞌa kurau'eteꞌe zamaḡano adure'a bohataro, ");
INSERT INTO ksj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ebu Vine Zaḡoḡani'a Tubugo niniḡa teige ane rana kami ovairo. Ebu ago ꞌahoganiꞌa adureonoꞌo ꞌahige rae reiro, “Ḡa'e eḡe zamarone ubude. Eḡeꞌa ḡae mazao matu'e rudau'ohe.” ");
INSERT INTO ksj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Iesu muriꞌe 30 reirotene, ani gauḡa ḡadaheniro. Vazeꞌa ani'e Iosefa ubuga rae zamariro. Iosefa'e Heli ubuga, ");
INSERT INTO ksj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli'e Matata ubuga, Matata'e Levi ubuga, Levi'e Meleki ubuga, Meleki'e Ianai ubuga, Ianai'e Iosefa ubuga, ");
INSERT INTO ksj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Iosefa'e Matataia ubuga, Matataiaꞌe Amosa ubuga, Amosaꞌe Nahumu ubuga, Nahumuꞌe Eseli ubuga, Eseliꞌe Nagai ubuga, ");
INSERT INTO ksj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaiꞌe Mahata ubuga, Mahataꞌe Matataia ubuga, Matataiaꞌe Semeina ubuga, Semeinaꞌe Ioseka ubuga, Iosekaꞌe Ioda ubuga, ");
INSERT INTO ksj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Iodaꞌe Ioanana ubuga, Ioananaꞌe Resa ubuga, Resaꞌe Zerubabele ubuga, Zerubabeleꞌe Sealetiele ubuga, Sealetieleꞌe Neri ubuga, ");
INSERT INTO ksj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neriꞌe Meleki ubuga, Melekiꞌe Adi ubuga, Adiꞌe Kosama ubuga, Kosamaꞌe Elamadama ubuga, Elamadamaꞌe Ere ubuga, ");
INSERT INTO ksj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ereꞌe Iosua ubuga, Iosuaꞌe Eliezere ubuga, Eliezereꞌe Iorima ubuga, Iorimaꞌe Matata ubuga, Matataꞌe Levi ubuga, ");
INSERT INTO ksj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leviꞌe Simeona ubuga, Simeonaꞌe Iuda ubuga, Iudaꞌe Iosefa ubuga, Iosefaꞌe Ionama ubuga, Ionamaꞌe Eliakimi ubuga, ");
INSERT INTO ksj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakimiꞌe Melea ubuga, Meleaꞌe Mena ubuga, Menaꞌe Matata ubuga, Matataꞌe Natana ubuga, Natanaꞌe Davida ubuga, ");
INSERT INTO ksj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davidaꞌe Iese ubuga, Ieseꞌe Obeda ubuga, Obedaꞌe Boazi ubuga, Boaziꞌe Salamona ubuga, Salamonaꞌe Nasona ubuga, ");
INSERT INTO ksj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasonaꞌe Aminadaba ubuga, Aminadabaꞌe Adamina ubuga, Adaminaꞌe Areni ubuga, Areniꞌe Hezarona ubuga, Hezaronaꞌe Pereze ubuga, Perezeꞌe Iuda ubuga, ");
INSERT INTO ksj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Iudaꞌe Iakobo ubuga, Iakoboꞌe Isako ubuga, Isakoꞌe Aberahamo ubuga, Aberahamoꞌe Tera ubuga, Teraꞌe Nahoro ubuga, ");
INSERT INTO ksj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahoroꞌe Seruga ubuga, Serugaꞌe Reu ubuga, Reuꞌe Pelega ubuga, Pelegaꞌe Ebere ubuga, Ebereꞌe Sela ubuga, ");
INSERT INTO ksj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Selaꞌe Kainana ubuga, Kainanaꞌe Afasada ubuga, Afasadaꞌe Semu ubuga, Semuꞌe Noa ubuga, Noaꞌe Lameka ubuga, ");
INSERT INTO ksj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamekaꞌe Metusela ubuga, Metuselaꞌe Enoka ubuga, Enokaꞌe Iareda ubuga, Iaredaꞌe Mahalalela ubuga, Mahalalelaꞌe Kainana ubuga, ");
INSERT INTO ksj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainanaꞌe Enosi ubuga, Enosiꞌe Seta ubuga, Setaꞌe Adamu ubuga, Adamuꞌe Badiꞌa ubuga. ");
INSERT INTO ksj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iesuꞌe Ioridana vuḡa mode iḡunirotene, Vine Zaḡoḡani'a ane rana iriꞌavadu Iesu tutune haba boha'a onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","E'ea mada 40 zamaḡano Diaboloꞌa Iesu tuhune nuriro. E'e madaḡano ani ogomu 'ahoga mene aro, eꞌanoꞌo mada ḡonagano ani vinine runiro. ");
INSERT INTO ksj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ebu Diaboloꞌa Iesu niro, “Ḡaꞌe Badiꞌa Ubuga roꞌidene, hadi ꞌadi mazao ꞌahige noꞌi, 'Ḡihuradu ꞌuvahu odogano roꞌi.'” ");
INSERT INTO ksj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Iesu'a naenaeniro, “Mene, Buka Zaḡoḡano ꞌahige rae mirihiro, 'Vaze'e ꞌuvahu odogano da'o mene ḡabode radi'uma.'” ");
INSERT INTO ksj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ebu Diaboloꞌa Iesu hitaga haba'a tutune itadu zogone kini'a zuhiꞌaziꞌeteꞌe habaꞌahabaꞌa niduꞌa ihoniro. ");
INSERT INTO ksj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ebu aniꞌa Iesu niro, “Eḡeꞌa haba niduꞌa zuhiꞌaziꞌeteꞌe gigi'aḡa zu ḡau naeḡa boroboro niduꞌa ḡae ḡani'uma. Aꞌe eḡe iniroteꞌe ḡauḡa 'ahine, eḡe'a urateꞌeteꞌe vazeḡa ꞌahoga hau tauḡogaꞌe idaḡa. ");
INSERT INTO ksj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","E'ano'o ḡaeꞌa eḡe mazao kuraune, eꞌe nidu'a ḡaniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Iesu'a naenaeniro, “Mene, Buka Zaḡoḡano ꞌahige rae mirihiro, 'Zuhiꞌa Boro ḡae Badiꞌa mazao da'o kurano'i, zu ane veize daꞌo gauoꞌi.'” ");
INSERT INTO ksj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ebu Diabolo'a Iesu Ierusalema tutune onamiro ebu kuru neḡa hitaga huneo ohonadu niro, “Ḡaꞌe Badiꞌa Ubuga ro'idene, ꞌadaono'o rafato'i. ");
INSERT INTO ksj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Mazaḡa Buka Zaḡoḡano ꞌahige rae mirihiro, 'Badi'aꞌa ḡaꞌe faine duguoga veize ane tuḡure vigaviga ḡae vaḡe tuḡuziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ze'a ꞌevoreze hina ḡae mae ḡihi'i'uma ꞌahine, odaḡoꞌe hadio mene tutuhaꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Rehano Iesu'a naenaeniro, “Mene, Buka Zaḡoḡano ꞌahige rae mirihiro, 'Zuhiꞌa Boro ḡae Badiꞌa ago tuhuno'i.'” ");
INSERT INTO ksj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Diaboloꞌa Iesu tuhunoga niduꞌa hauḡirotene, mada manoḡa 'ahogano bare tuhuniꞌuma radu muhine iḡuniro. ");
INSERT INTO ksj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iesuꞌe Vine Zaḡoḡa gigi'aḡani'a iri'avonadu Galilea habaꞌa bare onamiro. Ebu ane hariꞌe haba nidu'a zamaḡano bororaro. ");
INSERT INTO ksj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Aniꞌe Iuda azaḡa nuꞌonuꞌo neḡano ihoziro, ebu vaze niduꞌaꞌe ani niguniro. ");
INSERT INTO ksj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ebu Iesuꞌe Nazareta neḡa onamiro. Eꞌe neḡaꞌe ane'a bororarote'e neḡa. Bana Madaḡano ane'a iḡaiḡa haḡainute teige, nuꞌonuꞌo neḡano diuḡi onamiro. Ebu Buka Zaḡoḡa meꞌodoga radu iḡune edaro. ");
INSERT INTO ksj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ebu vaze ꞌahoganiꞌa peroveta vazeḡa Isaiaꞌa mirihiroteꞌe soꞌa ḡuaḡa mae haro. Ebu Iesuꞌa eꞌe vavaꞌadu meꞌoditeꞌe ḡoeꞌa horoniro. Aꞌe ꞌahige rae mirihiro, ");
INSERT INTO ksj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Zuhiꞌa Boro Vigaꞌe eḡe vaḡe ovairo. Zahara azaḡa mazao hari manoḡa haramoga veize aniꞌa eḡe ohohiro. Zuhiꞌa Boroꞌa tuḡuhadu eḡeꞌa ꞌahige rae fureneꞌohe, 'Agire ḡauḡaniꞌa batuziroteꞌe azaḡa fuhiꞌe ahetiꞌuma, ebu ubuma kuruḡa azaḡa raꞌanoziniꞌuma, ebu aduganiꞌa ḡahiziroteꞌe azaḡa adugazeonoꞌo mae bohaziꞌuma, ");
INSERT INTO ksj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ebu izidi muriḡaꞌe Zuhiꞌa Boroꞌa ane mone azaḡa ḡaboziteꞌe madaḡa reꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Iesuꞌa soꞌa ḡuaḡa eꞌe ꞌuadu nuꞌonuꞌo neḡa taufeꞌeteꞌe vazeḡa bare haro ebu ehoriro. Nu'onu'o neḡa zamaḡano vaze niduꞌa ani ḡiaḡianiro. ");
INSERT INTO ksj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ebu Iesuꞌa ḡadahe ziro, “Zaꞌa egateꞌe Buka Zaḡoḡano ḡoeꞌa ꞌai izidi ꞌada hudaneha.” ");
INSERT INTO ksj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Zeḡe niduꞌa ani hebeonoꞌo buaroteꞌe ḡoeꞌa manoḡa egadu zaguzagaro. Rehano ze ꞌahige rae reiro, “Aniꞌe Iosefa ubuga, oꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ebu Iesuꞌa ziro, “E edeḡa, zaꞌe eḡe mazao iradugu ḡoeꞌa ꞌahi reꞌuma, 'Gohe vazeḡa, ibite geno ḡae bare fainoꞌi.' Ebu eḡe bare ihiꞌuma, 'Emeꞌa igiroteꞌe teige, ḡaeꞌa Kaperanauma neḡano haḡairoteꞌe haḡai gigiꞌaḡa ḡae haba ꞌadao zuni haḡaoꞌi.'” ");
INSERT INTO ksj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ebu aniꞌa bare ziro, “Eḡeꞌa hube hune ziꞌohe, peroveta vazeḡaꞌe ane haba azaḡaniꞌa mene mae ḡihineꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Rehano eḡeꞌa hube hune ziꞌohe. Elia madaḡano muri uḡidu zu ḡahaꞌa zamaḡano adure ꞌuadu iruguꞌa mene ruꞌaro, eꞌanoꞌo Isaraela habaꞌa niduꞌa zamaḡano zahara boroꞌa buaro. Eꞌe madaḡano ḡozoba ḡehaḡaniꞌa radiunu. ");
INSERT INTO ksj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Rehano Elia'e Badiꞌa'a Isaraela habaꞌano ḡozoba ḡehaḡa boꞌaḡano ꞌahoga mazao mene tuḡuniro, rehano Sidono haba'a uhiḡano Sarepata neḡano radiunuteꞌe ḡozobaḡa 'ahoga mazao daꞌo tuḡuniro. ");
INSERT INTO ksj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ebu peroveta vazeḡa Elisa madaḡano Isaraela habaꞌano refera azaḡa ḡehaḡaniꞌa radiunu. Rehano zeḡe boꞌaḡano ꞌahoga zuni mene fainiro, rehano Siria habaꞌa vazeḡa, niḡa Naamana da'o fainiro.” ");
INSERT INTO ksj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Iesuꞌa ꞌouge reirotene, nu'onu'o neḡa zamaḡano vaze nidu'a maḡune rudaro. ");
INSERT INTO ksj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Zeḡe nidu'a iḡunadu e'e haba'anono'o ani tuḡune vaḡiniro. Ebu dofarao duine feunoga radu neze ogorarote'e maḡa komeꞌa hitaga tutune itiro. ");
INSERT INTO ksj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Rehano Iesuꞌa vaze ḡunuḡano onamadu ane ibio onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ebu Iesuꞌa Galilea haba'ano Kaperanauma ovoadu Bana Madaḡano nu'onu'o neḡano vaze ihoziro. ");
INSERT INTO ksj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Zeꞌa ane ihoreḡa igirotene zaguzagaro, mazaḡa aniꞌa Badiꞌa gigiꞌaḡa hina ihoziro. ");
INSERT INTO ksj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Eꞌe madaḡano vine sau'aḡeta vazeḡa ꞌahogaꞌe nu'onu'o neḡano radiunu, ebu agoḡa boro hina ḡoeriro, ");
INSERT INTO ksj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“A! Nazareta vazeḡa Iesu! Ḡa emeḡe mazao nougihi raꞌohe? Ḡa eme ruifoga radu arahe? E edeḡa ḡaꞌe iniu. Ḡa'e Badiꞌa mazaonoꞌo ariroteꞌe vazeḡa zaḡoḡa!” ");
INSERT INTO ksj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iesu'a vine sau'a roniro, “Hezo'a! Vaze e'e mazaono'o buanoꞌi!” Ebu vine sau'ani'a vaze nidu'a boꞌaḡano vaze e'e mae rahao higonadu buau dauḡiro. Rehano vaze eꞌe mene sausauniro. ");
INSERT INTO ksj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Vaze nidu'a zaguzagaro ebu ze zeḡe'a bare reiro, “Ihoreḡa ꞌadiꞌe nagiga? Aniꞌa Badiꞌa inaraḡa zu gigiꞌaḡa hina vine sauꞌasauꞌa riḡa ziꞌetene, ze egohanadu buauꞌohe!” ");
INSERT INTO ksj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ebu Iesu hariḡaꞌe uhiḡauhiḡa haba'a niduꞌa bororaro. ");
INSERT INTO ksj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesu'a nu'onu'o neḡa modadu Simona ne onamiro. E'ea Simona emoḡa roḡaeḡaꞌe ahiꞌaniꞌa gigine runiro, eꞌanoꞌo ani fainoga veize ze Iesu uminiro. ");
INSERT INTO ksj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ebu Iesuꞌa ani uhiḡano edanadu ahiꞌa gigiꞌa eꞌe ḡoere riga hina hegone buniro. ꞌOugadu ugi e'e'a ani mazaonoꞌo vaḡiniro, ebu aniꞌa zogone iḡunadu zeḡe veize ogomu ruhibiro. ");
INSERT INTO ksj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mada'a ovoirotene, vaze ḡehaḡaniꞌa ugi nunu meiroteꞌe azaḡa niduꞌa Iesu vaḡe tutuze ariro. Ebu Iesuꞌa ꞌevo'a zeḡe tibatiba rana teadu faiziro. ");
INSERT INTO ksj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ebu vine sau'asau'aniꞌa vaze ḡehaḡa mazaonoꞌo buanadu ꞌahige rae huaro, “Ḡa'e Badiꞌa Ubuga!” Rehano Iesuꞌa ze roziro zu ḡoeroga garariro, mazaḡa ze aniꞌe Keriso rae ederiro. ");
INSERT INTO ksj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Oherebau uzeuze Iesuꞌa vaze oꞌoꞌa habaꞌa onamiro. ꞌOugadu vaze ḡuḡuvaḡaniꞌa Iesu vaḡiro, ebu aniꞌa radiuꞌeteꞌe habaꞌa aradu ani zeḡe mene muhize iḡunoga veize uminiro. ");
INSERT INTO ksj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Rehano Iesuꞌa ziro, “E haba nunuo zuni Badiꞌaꞌa zuhiꞌaziꞌeteꞌe moneo hari manoḡa harame huniꞌuma. Eꞌe uꞌano, eḡe tuḡuhiro.” ");
INSERT INTO ksj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ebu ani Iudea habaꞌano nu'onu'o neḡano harame ragaviro. ");
INSERT INTO ksj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Mada ꞌahogano Iesu'a Genesareta duꞌura genaḡano edanadu Badiꞌa ḡoere haraminu. Ebu vaze ḡuḡuvaḡaꞌe ani haramo abitoga veize bibitite ariro. ");
INSERT INTO ksj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Iesuꞌa duꞌura genaḡano ḡasi aheu horoniro. Ḡasi azaḡaꞌe buanadu re'evaze vuzuꞌe radiunu. ");
INSERT INTO ksj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Iesu'e ḡasi aheu boꞌaḡano Simona ḡasio tiradu uminiro, “Ḡasiḡo hesaonoꞌo tahiḡa duine buno'i.” Ebu Iesuꞌe ḡasi zamaḡano ehoradu vaze ḡuḡuvaḡa haramoziro. ");
INSERT INTO ksj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Iesuꞌa harame hauḡirotene, Simona niro, “Hoeꞌa mone onamoꞌi, ebu reꞌevaḡo feunadu ḡozone reꞌevanoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simonaꞌa naenaeniro, “Vaze boro, eme ohere faḡa gau boro haḡaeꞌenaꞌa reꞌeveha, rehano mene maneha. Rehano e ḡae ḡoere mae ḡihinadu reꞌeva feuniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ebu zeꞌa reꞌeva feunirotene, reꞌeva zamaḡanoꞌe ḡozone ḡehaḡaniꞌa oḡanadu reꞌevaꞌe zigaro. ");
INSERT INTO ksj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Eꞌanoꞌo zeḡe danazoga veize ꞌevoreze hina ḡasi ꞌahogano nabudize huze zaveziro. Ebu ze aradu ḡasi aheuꞌe ḡozone hina iriꞌavonirotene, ḡasiꞌa nariga zuburiro. ");
INSERT INTO ksj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simona Peteroꞌa eꞌe horonadu Iesu oda babaḡano ḡuḡuriro ebu niro, “Zuhiꞌa Boro, e'e haḡai sauꞌa vazeḡa. Eḡe mazaonoꞌo vaḡinoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simona zu ane teite radiroteꞌe azaḡa niduꞌaꞌe zeꞌa maroteꞌe ḡozoneḡaꞌe ḡehaḡa hune radu ufeta zaguzagaroteꞌe uꞌano, ꞌouge reiro. ");
INSERT INTO ksj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Zebedeo ubuga aheu, Iakobo zu Ioaneꞌe Petero teite gauinu ꞌahine, zeḡe zuni zaguzagaro. Ebu Iesuꞌa Simona naenaeniro, “Ago rihanoꞌi. Izidionoꞌo onamo mada niduꞌa ḡaꞌe vaze reꞌevaziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ebu ze ḡasize hesao hebenadu ḡauze niduꞌa modiro ebu ane hegote onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Iesuꞌe ne 'ahogano radiuꞌeteꞌea, ahiꞌano referaꞌa iriꞌaviroteꞌe vazeḡa 'ahoganiꞌa ani vaḡe ariro. Ani'a Iesu horonadu ane zamao rahao ḡuḡuriro ebu uminiro, “Zuhiꞌa Boro, ḡa uratine, eḡe faihogaꞌe idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ebu Iesuꞌa ꞌevoꞌa einadu vaze eꞌe oboniro ebu niro, “E urateꞌohe. Ḡaꞌe deheru manoroꞌi!” ꞌOugadu refera eꞌeꞌa zogone manoriro. ");
INSERT INTO ksj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ebu Iesuꞌa ḡoere riḡa niro, “Vazeni ꞌahoga ago noꞌi. Rehano dibuꞌo vazeḡa vaḡe onamadu ahiriḡo ihonoꞌi. Ebu ḡaeꞌa deheru manorataꞌaꞌe vazeꞌa ederifine, Moseꞌa reiroteꞌe dibuꞌoḡa mae onamadu Badiꞌa dibuꞌohanoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Rehano Iesu hariꞌe ufeta bororu onamiro. Eꞌanoꞌo vaze ḡuḡuvaḡaniꞌa Iesu ḡoere abitoga zu ugizeꞌa manoroga veize ane vaḡe ariro. ");
INSERT INTO ksj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Rehano Iesuꞌe vaze oꞌoꞌa habaꞌa onamadu eꞌea kuraro. ");
INSERT INTO ksj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Mada ꞌahogano Iesuꞌa harameꞌeteꞌea, Farisea azaḡa zu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡaniꞌa Iesu uhiḡano ehore radiunu. Zeꞌe Galilea zu Iudea habaꞌano ne nunuonoꞌo ebu Ierusalemaonoꞌo ariro. Zuhiꞌa Boro gigiꞌaḡaniꞌa Iesu rana radadu ugi azaḡa faiziro. ");
INSERT INTO ksj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Eꞌe madaḡano vaze nuꞌa ahiꞌa mene haganeꞌeteꞌe vazeḡa ꞌahogaꞌe faratao bazune teadu herate onamiro, ebu ne zamaḡa diuḡadu Iesu zamao bazune tihi reiro. ");
INSERT INTO ksj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Rehano vaze ḡuḡuvaḡa ꞌahine, ze ibihetaonoꞌo odohe diuḡoga mene idararo. Eꞌanoꞌo ze binu hitaga itadu binu mae bohaniro. Ebu binu bohaꞌanonoꞌo ugi vazeḡa farataḡa miniḡa hina ovoe dabanadu vaze ḡuḡuvaḡa boꞌaḡano Iesu zamao bazune tiro. ");
INSERT INTO ksj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Zeꞌa Iesu mazao fieꞌeteꞌe Iesuꞌa horonadu ugi vazeḡa niro, “Eḡe vaze, ḡae haḡai sauꞌa ꞌai rae modeha.” ");
INSERT INTO ksj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ꞌOugirotene, Farisea azaḡa zu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡaꞌe ꞌahige rae zamariro, “Aniꞌe vaze nagiga radu Badiꞌa rae sausauneꞌohe? Badiꞌaꞌa daꞌo vaze haḡai sauꞌa rae modeꞌohe!” ");
INSERT INTO ksj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iesuꞌe zeḡeꞌa nagini zamareꞌetaꞌaꞌe ederadu ḡadiziro, “Za nougadu zamazeo eḡe ḡoere ꞌadi zamareꞌohe? ");
INSERT INTO ksj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ugi vazeḡa mazao noꞌe ḡoeꞌa nine, ufiḡa? 'Ḡae haḡai sauꞌa ꞌai rae modeha,' rae niꞌeteꞌe ḡoeꞌa ga 'Iḡunadu onamoꞌi' rae niꞌeteꞌe ḡoeꞌa? ");
INSERT INTO ksj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Rehano Vaze Ubugaꞌe raha ꞌadao haḡai sauꞌa rae modeꞌeteꞌe gigiꞌaḡa meirotaꞌaꞌe zaeꞌa ederiꞌuma.” Ebu Iesuꞌa ahiꞌa mene haganeꞌeteꞌe vazeḡa niro, “Eḡeꞌa ḡaꞌohe. Iḡunoꞌi ebu farataḡo madu neḡo onamoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ebu ugi vazeḡa ꞌai zogone zeḡe zamao iḡune edaro, zu aneꞌa baze radiroteꞌe farataḡa madu Badiꞌa niguneꞌenaꞌa, neḡa onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Vaze niduꞌaꞌe zaguzagaro zu Badiꞌa niguniro. Ebu ze rihau rudauꞌenaꞌa, ꞌahige rae reiro, “Eme izidi haḡai gigiꞌaḡa horoneha!” ");
INSERT INTO ksj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Eꞌe enogano Iesuꞌe haba eꞌe mode iḡuniro, ebu takesi vazeḡa ꞌahoga, niḡa Levi horoniro. Aniꞌe takesi fataḡa uhiḡano ehore radiunu. Ebu Iesuꞌa niro, “Eḡe hegotoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ebu Leviꞌa ḡauḡa niduꞌa modadu Iesu hegotiro. ");
INSERT INTO ksj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Leviꞌa ane neo Iesu veize mui boro haḡairo. Eꞌea takesi azaḡa ḡehaḡa zu vaze ḡuḡuvaḡaniꞌa Iesu zu ane tahiꞌatahiꞌa teite ogau tiburaro. ");
INSERT INTO ksj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Rehano Farisea azaḡa zu zeḡe mone Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡaniꞌa Iesu tahiꞌatahiꞌa mazao maḡunadu ziro, “Zaꞌe nougadu takesi azaḡa zu haḡai sauꞌa azaḡa teite ogau tiburuꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iesuꞌa naenaeziro, “Ugi oꞌoꞌa azaḡaꞌe gohe vazeḡa mene vaḡeꞌohe, rehano ugi azaḡaꞌe gohe vazeḡa vaḡeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Eꞌe teige, e iniu zeḡeꞌa bare duduḡa azaḡa rae zamareꞌeteꞌe azaḡa huzoga veize mene ariro, rehano iniu zeḡeꞌa bare haḡai sauꞌa azaḡa rae zamareꞌeteꞌe azaḡa huzadu zeꞌa haḡaize sauꞌanonoꞌo ḡihuroga veize ariro.” ");
INSERT INTO ksj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ebu vaze nuꞌa Iesu niro, “Ioane tahiꞌatahiꞌaꞌe ḡae ḡehaḡa ogomu moneo zaḡozaḡeꞌohe zu kurauꞌohe. Farisea azaḡa tahiꞌatahiꞌa zuni ꞌougeꞌohe. Rehano ḡae tahiꞌatahiꞌaꞌe iḡaiḡa ogauꞌohe zu gageꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ebu Iesuꞌa ziro, “Hahu muiḡa madaḡano, hahu ohozeḡa iziganiꞌa huziroteꞌe azaḡaꞌe hahu ohozeḡa iziga teite radiuꞌeteꞌea ze ogomu moneo zaḡozaḡiꞌumahe? ");
INSERT INTO ksj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Rehano zeḡe mazaonoꞌo hahu ohozeḡa izigaꞌe mae vaḡiniteꞌe madaḡaniꞌa arine, ze ogomu moneo zaḡozaḡiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ebu Iesuꞌa bare hari ꞌahoga idane ziro, “Vaze ꞌahoganiꞌa dabua iziga variꞌe madu dabua amahiḡa mene banineꞌohe. Baninine, dabua izigaꞌe mae borofe zigiꞌuma, ebu dabua izigaꞌe amahiḡa teite horone tibunoga zuni mene manoḡa reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ebu vazeni ꞌahoganiꞌa vaini vuḡa fuse amahiḡa zamaḡano vaini vuḡa iziga mene beꞌune ufiꞌohe. Beꞌune ufine, vaini vuḡa iziganiꞌa bare busure bororanadu vaini vuḡa fuse amahiḡaniꞌa zigaꞌuma, ebu vaini vuḡaꞌe sore rururaꞌuma zu vaini vuḡa fuse amahiḡa sausauniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Eꞌanoꞌo vaini vuḡa izigaꞌe vaini vuḡa fuse izigano beuꞌe ufiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Rehano vaini vuḡa amahiḡa gagidoteꞌe azaḡaꞌe vaini vuḡa iziga mene urateꞌohe, mazaḡa zeꞌe ꞌahige rae raꞌohe, 'Amahiḡaꞌe ufeta manoḡa.'” ");
INSERT INTO ksj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Bana Madaḡa ꞌahogano Iesuꞌa ane tahiꞌatahiꞌa teite vuidi mebaḡa zamaḡano onamiro. Ebu ane tahiꞌatahiꞌaꞌa vuidi maḡa ririꞌe meiro, zu ꞌevoreze hina hasiga mute vaḡinadu huga aro. ");
INSERT INTO ksj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ꞌOugirotene, Farisea azaḡa nuꞌa ḡadiziro, “Zaꞌe nougadu Bana Madaḡa goroḡa varadeꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Iesuꞌa naenaeziro, “Zaꞌe Buka Zaḡoḡa mene meꞌodirohe? Davida zu ani ḡatiniroteꞌe azaḡaꞌe vinize ruzirotene, Davidaꞌa nougiro? ");
INSERT INTO ksj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Aniꞌe Badiꞌa ne diuḡadu dibuꞌo azaḡaniꞌa daꞌo auꞌeteꞌe dibuꞌo ꞌuvahuḡa odoga aro, ebu ani ḡatiniroteꞌe azaḡa zuni ziniro.” ");
INSERT INTO ksj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ebu Iesuꞌa ziro, “Vaze Ubugaꞌe Bana Madaḡa Zuhiꞌaḡa.” ");
INSERT INTO ksj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ebu Bana Madaḡa ꞌahogano, Iesuꞌa nu'onu'o neḡa diuḡadu vaze ḡehaḡa ihozinu. Eꞌea edaꞌe nae ꞌevoꞌa hoega vazeḡa ꞌahoganiꞌa radiunu. ");
INSERT INTO ksj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zu Farisea azaḡaꞌe Iesuꞌa Bana Madaḡano vaze eꞌe fainiꞌuma ga meneꞌe ḡianifine, ehamu radiro. Mazaḡa Iesuꞌa vaze eꞌe fainine, kotao ani ohonihi reiro. ");
INSERT INTO ksj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Rehano Iesuꞌe zeꞌa nouge rae zamareꞌetaꞌaꞌe ederadu ꞌevoꞌa hoega vazeḡa niro, “Iḡunadu vaze niduꞌa zamao edanoꞌi.” Ebu ani iḡunadu edaro. ");
INSERT INTO ksj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ebu Iesuꞌa ziro, “E ḡadiziꞌohe. Bana Madaḡano nagini haḡaine duduḡa? Manoḡa haḡaiꞌuma ga sauꞌa haḡaiꞌuma? Vaze ḡaboziꞌuma ga zimiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Aniꞌa zeḡe niduꞌa ḡiaziroteꞌe enogano vaze eꞌe niro, “ꞌEvoꞌo ꞌeinoꞌi.” Aniꞌa ꞌevoꞌa ꞌeinirotene, ꞌevoꞌaniꞌa manoriro. ");
INSERT INTO ksj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Rehano ze maḡune rudanadu Iesu mazao nagini haḡaiteꞌe moneo ḡadahe ḡoꞌane tiburaro. ");
INSERT INTO ksj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Eꞌe madaḡano Iesuꞌa kuranoga veize maḡa ꞌahoga onamadu ohere faḡa Badiꞌa mazao kuraro. ");
INSERT INTO ksj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ebu irarirotene, aniꞌa ane tahiꞌatahiꞌa huze nuꞌoziro. Ebu zeḡe boꞌaḡano tahiꞌa gaubanana aheu fare ohotadu Apostolo azaḡa rae huziro. ");
INSERT INTO ksj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nizeꞌe Simona(niḡa ꞌahogaꞌe Petero), Petero negoḡa Anderea, Iakobo, Ioane, Filipi, Batolomeo, ");
INSERT INTO ksj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mataio, Tomasi, Alefeo ubuga Iakobo, Zelota vazeḡa Simona, ");
INSERT INTO ksj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Iakobo ubuga Iuda ebu Iesu revoharoteꞌe vazeḡa, Isakariota vazeḡa Iuda. ");
INSERT INTO ksj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Eꞌe enogano, Iesuꞌa ane tahiꞌatahiꞌa teite maḡanonoꞌo ovaradu haba sebaḡano edaro. Eꞌea ane hegoteꞌeteꞌe vaze ḡuḡuvaḡa ebu haba nunuonoꞌo vaze ḡehaḡaniꞌa radiunu. Zeꞌe Iudea habaꞌa, Ierusalema zu davara genaḡano ne boro Turo ebu Sidonoonoꞌo ariro. ");
INSERT INTO ksj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Zeꞌe Iesu ḡoere igifine zu ugizeonoꞌo manorifine ariro. Iesuꞌa Vine sauꞌaniꞌa diuḡadu sausauziroteꞌe azaḡa zuni faiziro. ");
INSERT INTO ksj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ebu zeḡe niduꞌa ani ahiri obonihi reiro, mazaḡa ugi faineꞌeteꞌe inaraḡaꞌe ani mazaonoꞌo buanadu zeḡe niduꞌa manoriro. ");
INSERT INTO ksj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ebu Iesuꞌa ane tahiꞌatahiꞌa ḡiazeꞌenaꞌa ziro, “Za, zahara azaḡaꞌe matuꞌeꞌohe, mazaḡa Badiꞌaꞌa zuhiꞌaziꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Za, izidi vinizeꞌeteꞌe azaḡaꞌe matuꞌeꞌohe, mazaḡa isize miniꞌuma. Za, izidi niauꞌeteꞌe azaḡaꞌe matuꞌeꞌohe, mazaḡa vesuꞌu matuꞌe eḡofiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Vaze Ubuga uꞌano, vazeꞌa zaꞌe heꞌeheꞌezine, hezahozine, ḡoere sauꞌa zine, ebu zaꞌe sauꞌa rae reine, zaꞌe matuꞌiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ꞌUguḡaniꞌa zae mazao fureranoꞌidene, matuꞌeꞌenaꞌa zavonoꞌi, mazaḡa Badiꞌaꞌa adureo naeḡa boro bagaḡa ziniꞌuma. Zeḡe vouḡaniꞌa peroveta azaḡa deꞌuge sausauzido. ");
INSERT INTO ksj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Rehano za, maꞌora azaḡaꞌe aduga hidiꞌuma, mazaḡa zaꞌe ibite ḡau manoḡa niduꞌa mae hauḡiro ꞌahine, vesuꞌu mene bare meꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Za, izidi ogau isi miniꞌeteꞌe azaḡaꞌe aduga hidiꞌuma, mazaḡa vesuꞌu viniziꞌuma. Za, izidi matuꞌe eḡofeꞌeteꞌe azaḡaꞌe aduga hidiꞌuma, mazaḡa vesuꞌu zamazeꞌa areꞌenaꞌa, niaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Vaze niduꞌa zae niguzine aduga hidiꞌuma, mazaḡa zeḡe vouḡaniꞌa ḡuriro peroveta azaḡa ꞌouge niguzido.” ");
INSERT INTO ksj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Rehano e eḡe ḡoere igiꞌeteꞌe azaḡa, za ziꞌohe. Zae agire azaḡa zamare borofoꞌi, zu zae heꞌeheꞌezeꞌeteꞋe azaḡa mazao manoḡa haḡaoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Zae mazao, 'Radiu tuḡutuḡu adugaḡa hidoꞌi,' rae zoꞌidene, ze manohuga hidoga veize uminoꞌi, zu zae mazao haḡai sauꞌa haḡaeꞌeteꞌe azaḡa veize kuranoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Iniuꞌa zae ḡanineze faꞌonoꞌidene, naeḡa zuni notonohanoꞌi, ebu iniuꞌa zae raga dabuaḡa meinadu hena bare zae zizuni dabuaḡa meihi roꞌidene, eꞌe zuni hanoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Iniuꞌa nagini umizoꞌidene hau tauḡoꞌi, ebu iniuꞌa ḡauze moꞌidene, ago bare moꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Vazeꞌa zae mazao manoḡa haḡaeꞌeteꞌe uratoꞌidene, zae zuni zeḡe mazao manoḡa haḡaoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Zaeꞌa zae zamare borofeꞌeteꞌe azaḡa daꞌo zamare borofine, Badiꞌaꞌa eꞌe naeḡa mene ziniꞌuma. Haḡai sauꞌa azaḡa zuni zeḡe zamare borofeꞌeteꞌe azaḡa zamare borofeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Zaeꞌa zae mazao manoḡa haḡaeꞌeteꞌe azaḡa mazao daꞌo manoḡa haḡaine, Badiꞌaꞌa eꞌe naeḡa mene ziniꞌuma. Haḡai sauꞌa azaḡa zuni ꞌouge haḡaeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Zaeꞌa ḡauze baroniꞌuma rae raꞌeteꞌe azaḡa daꞌo zinine, Badiꞌaꞌa eꞌe naeḡa za mene ziniꞌuma. Haḡai sauꞌa azaḡa zuni ḡauze bare meꞌuma rae zamareꞌenaꞌa, ḡauze sauꞌa azaḡa ziniꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Rehano zae agire azaḡa zamare borofoꞌi, zu zeḡe mazao manoḡa haḡaoꞌi. Ebu zeꞌa eḡe mazao bare naenaehiꞌuma rae mene zamareꞌenaꞌa, zini tauḡoꞌi. ꞌOugine, Badiꞌaꞌa naeḡa boro ziniꞌuma, ebu zaꞌe Ḡihiꞌa Hune Badiꞌaḡa ubuga reꞌuma. Mazaḡa Badiꞌa mazao manoḡa tauḡi rae mene raꞌeteꞌe azaḡa ebu sauꞌa azaḡa zuni Badiꞌaꞌa vetuḡaziꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Zae Mama, Badiꞌaꞌa vaze vetuḡaziꞌeteꞌe teige, zae zuni vaze vetuḡazoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Vaze mazao sauꞌa azaḡa rae ago zoꞌi. ꞌOugine, Badiꞌaꞌa zuni zae mazao sauꞌa azaḡa rae mene ziꞌuma. Vaze mazao veꞌoḡa rae ago zoꞌi. ꞌOugine, Badiꞌaꞌa zae mazao veꞌoḡa rae mene ziꞌuma. Vaze haḡai sauꞌa rae modoꞌi. ꞌOugine Badiꞌaꞌa zae haḡai sauꞌa rae modiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ḡauze zenoꞌi, ꞌougine Badiꞌaꞌa manohuga ziniꞌuma. Aniꞌa zaꞌe iriꞌavone fosafosanoga, taugoga, zuꞌizuꞌinoga ebu foraꞌaḡa beuꞌe ruruno ziniꞌuma. Zaeꞌa vaze nagini hauꞌeteꞌe idunaḡano Badiꞌaꞌa ꞌouge zae ziniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iesuꞌa hari ꞌahoga idane ziro, “Ubuma kuruḡa vazeḡaniꞌa ubuma kuruḡa vazeḡa ibitohanogaꞌe idaḡahe? ꞌOugine, anianine hoꞌona uite ovoiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tahiꞌaꞌe ani ihore vazeḡa mene vitinoga. Rehano tahiꞌaꞌa edeḡa niduꞌa meine, aniꞌe ane ihore vazeḡa teigiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Zaꞌe nabudize ubuma beꞌa dinunuḡa ḡianeꞌohe. Rehano nougadu zae ubuma beꞌa gado ireḡa mene horoneꞌohe? ");
INSERT INTO ksj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Zaꞌe zae ubuma beꞌa gado ireḡa mene horoneꞌe rehano, nabudize mazao ꞌahige raꞌohe, 'Eḡe nabudi, eḡeꞌa ubumaḡo beꞌa dinunu eꞌe mae vaḡinihi.' Zaꞌe zama guhi azaḡa! Ibite geno zae ubuma beꞌa gado ireḡa eꞌe mae vaḡinoꞌi, ꞌougine zaeꞌa faine ehamanadu nabudize ubuma beꞌa dinunuḡa mae vaḡiniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ire manoḡaꞌe maḡa sauꞌa mene iniꞌohe, zu ire sauꞌaꞌe maḡa manoḡa mene iniꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ireꞌe maḡa horonadu nagi ireḡa edereꞌohe. Figi maḡaꞌe ire renoganonoꞌo mene iniꞌohe, zu vaini maḡaꞌe ḡunu renoganonoꞌo mene iniꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Eꞌe teige, vaze manoḡaꞌe ani zamao manoḡa nuꞌonadu manoḡa fureneꞌohe, ebu sauꞌa vazeḡaꞌe ani zamao sauꞌa nuꞌonadu sauꞌa fureneꞌohe. Mazaḡa naginiꞌa ane zamao iriꞌave radiuꞌetaꞌaꞌe hebeꞌanonoꞌo buauꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Zaꞌe eḡe mazao, 'Zuhiꞌa Boro, Zuhiꞌa Boro,' rae huheꞌohe, rehano nougadu eḡeꞌa ḡoereꞌeteꞌe mene haḡaeꞌohe? ");
INSERT INTO ksj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Eḡe vaḡe aradu ḡoerehe igiꞌeteꞌe ebu ꞌouge haḡaeꞌeteꞌe vazeḡaꞌe iniu heuḡa rae ihoziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Aniꞌe raha vohutuna huꞌi ovoadu vatava riḡa rana neḡa ogoraroteꞌe vazeḡa heuḡa. Zobozoboꞌa feuradu ne haganirotene, ne aꞌe mene hagariro, mazaḡa haba riḡano faine ogoraro. ");
INSERT INTO ksj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Rehano eḡe ḡoere egadu ꞌouge mene haḡaeꞌeteꞌe vazeḡaꞌe, raha mene faine hoꞌadu haba zoreḡano neḡa ogoraroteꞌe vazeḡa heuḡa. Zobozoboꞌa feuradu ne eꞌe haganirotene, zogone higanadu fahau ḡuzuhiro.” ");
INSERT INTO ksj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iesuꞌa ane ḡoere niduꞌa zeḡe mazao ḡoeriroteꞌe enogano, Kaperanauma diuḡiro. ");
INSERT INTO ksj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Eꞌea uti vazeḡa boro ꞌahoganiꞌa radiunu. Aneꞌa zamare borofeꞌeteꞌe tuḡureḡa vazeḡaꞌe ugine sausaunadu nariga rudaro. ");
INSERT INTO ksj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Uti vazeḡa boroꞌe Iesu hariḡa igirotene, Iesuꞌa aradu ani tuḡure vazeḡa fainoga uratiro. Eꞌanoꞌo ani Iuda azaḡa boroboro Iesu uminoga veize tuḡuziro. ");
INSERT INTO ksj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ebu zeꞌe Iesu mazao feuradu zamaze niduꞌa hina uminiro, “Ḡa ani dananine manoḡa, ");
INSERT INTO ksj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","mazaḡa aniꞌe eme, Iuda azaḡa zamare borofeꞌohe ebu emeḡe veize nu'onu'o neḡa ogoraro.” ");
INSERT INTO ksj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Eꞌanoꞌo Iesuꞌa zeḡe teite uti vazeḡa boro ne onamiro. Ze uti vazeḡa boro ne uhiḡano feurirotene, uti vazeḡa boroꞌa ane vaze nu Iesu vaḡe tuḡuziro. Ebu zeꞌa Iesu vaḡe aradu niro, “Uti vazeḡa boroꞌa ꞌahige rae raha, 'Zuhiꞌa Boro, ago ufeta zamaroꞌi. Eꞌe mene vaze manoḡa ꞌahine, ḡaeꞌa eḡe ne diuḡogaꞌe mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Eꞌanoꞌo e ḡa vaḡe amiꞌuma rae mene zamareha. Rehano ḡa ḡoere daꞌo roꞌi, ꞌougine eḡe tuḡure vazeḡaniꞌa manoriꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mazaḡa eḡe zuni vaze ꞌahoga ꞌuꞌuḡano gaueꞌohe, ebu uti azaḡa zuni eḡe ꞌuꞌuḡano gaueꞌohe. Eḡeꞌa vaze ꞌahi ninaꞌa, “Onamoꞌi,” raꞌetene aniꞌe onameꞌohe, ebu ꞌahoga ꞌomo ninaꞌa, “Aroꞌi,” raꞌetene aniꞌe areꞌohe. Eḡeꞌa eḡe tuḡure vazeḡa ꞌahoga ninaꞌa, “ꞌAdi haḡaoꞌi,” raꞌetene aniꞌe haḡaeꞌohe.'” ");
INSERT INTO ksj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iesuꞌa ani ḡoere igirotene, ani ḡoere uꞌano zaguzagaro. Ebu vaetadu ane hegoteꞌeteꞌe azaḡa ziro, “Eḡeꞌa ziꞌohe, Isaraela azaḡa boꞌaḡano ꞌahige fie gigaruꞌeteꞌe vazeḡaꞌe ꞌize mene horoneha.” ");
INSERT INTO ksj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ebu ze bare uti vazeḡa boro ne onamirotene, tuḡure vazeḡaniꞌa manoriroteꞌe horoniro. ");
INSERT INTO ksj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Eꞌe enogano, Iesuꞌa ne ꞌahoga niḡa Naina onamiro. Ane tahiꞌatahiꞌa zu vaze ḡuḡuvaḡaniꞌa ani ḡatiniro. ");
INSERT INTO ksj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ebu Iesuꞌa ne ḡutuꞌaḡano feurirotene, ne azaḡaꞌe rune vazeḡa ꞌahoga herate buni ariro. Aniꞌe ḡozoba ꞌahoga ubuga tibuhuga. Ebu ne azaḡa ḡehaḡa zuni ḡozoba eꞌe teite ariro. ");
INSERT INTO ksj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Iesuꞌa ḡozoba eꞌe horonirotene, ani vetuḡaneadu niro, “Ago nianoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ebu hena Iesuꞌa rune ahiꞌa mauḡa herateꞌeteꞌe azaḡa vaḡe onamadu mauḡa obonirotene, ze tue edaro. Ebu aniꞌa rune vazeḡa niro, “Tahiꞌa iziga, eḡeꞌa ḡaꞌohe, iḡunoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ꞌOugirotene, rune vazeḡaniꞌa iḡune ehoradu ḡoeꞌa ḡadaheniro, ebu Iesuꞌa bare viꞌa ꞌevoreo riꞌiniro. ");
INSERT INTO ksj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ꞌOugadu zeḡe niduꞌa rihau rudaro zu Badiꞌa niguniro. Ze ꞌahige rae reiro, “Peroveta vazeḡa boroꞌa emeḡe boꞌaḡano fureraneha!” ebu “Badiꞌaꞌa ane mone azaḡa danazifine areha!” ");
INSERT INTO ksj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ebu Iesuꞌa nagini haḡairoteꞌe hariḡaniꞌa Iuda habaꞌa ebu uhiḡa habaꞌa niduꞌa zamaḡano bororaro. ");
INSERT INTO ksj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ioane Babatisoꞌe ḡuꞌa neḡano radiuꞌeteꞌe zamaḡano ane tahiꞌatahiꞌaꞌa ane vaḡe onamadu Iesuꞌa haḡairoteꞌe hariḡa niduꞌa meꞌodoharo. Ebu Ioaneꞌa ane tahiꞌa aheu huzadu ziro, ");
INSERT INTO ksj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“Zuhiꞌa Boro vaḡe onamadu ꞌahige ḡadinoꞌi, 'Ariꞌuma rae reiroteꞌe vazeḡaꞌe ḡahe? Mene reine, eme vaze ꞌahoga guhiniꞌumahe?'” ");
INSERT INTO ksj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ebu ze Iesu vaḡe onamadu ḡadiniro, “Ioane Babatisoꞌa ḡadiꞌoga veize eme tuḡufeha. 'Ariꞌuma rae reiroteꞌe vazeḡaꞌe ḡahe? Mene reine, eme vaze ꞌahoga guhiniꞌumahe?'” ");
INSERT INTO ksj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Eꞌe madaḡano Iesuꞌa ugi nunu zu vine sauꞌa meiroteꞌe azaḡa ḡehaḡa faiziro, ebu ubuma kuruḡa azaḡa ḡehaḡa faizadu ze bare ehamaro. ");
INSERT INTO ksj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Eꞌanoꞌo Iesuꞌa Ioane tahiꞌa aheu naenaeziro, “Bare onamadu zaeꞌa nagini horonateꞌe zu egateꞌe Ioane ihonoꞌi. Ubuma kuru azaḡaꞌe ehamuꞌohe, oda sauꞌa azaḡaꞌe edau ragaveꞌohe, refera azaḡaꞌe manoreꞌohe, teḡaze uhuḡa azaḡaꞌe igiꞌohe, rune azaḡaꞌe bare ḡabodeꞌohe, ebu zahara azaḡaꞌe hari manoḡa igiꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Eḡe mazao fieꞌeteꞌe mene modeꞌeteꞌe vazeḡaꞌe matuꞌiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ioaneꞌa tuḡuziroteꞌe azaḡaniꞌa iḡuniroteꞌe enogano, Iesuꞌa Ioane moneo vaze ḡuḡuvaḡa ḡadahe ziro, “Za nagini horonoga veize haba bohaꞌa onamiro? Zavaraꞌa imi veḡa hudi naeninaeniꞌeteꞌe horonoga radu onamirohe? ");
INSERT INTO ksj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mene reine, za nagini horonoga veize onamiro? Dabua manomano vidaroteꞌe vazeḡa horonoga veize onamirohe? Naeḡa boro dabuaḡa vidaroteꞌe zu ḡau manomanoḡeta radiuꞌeteꞌe vazeḡaꞌe kini neo radiuꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ꞌOugadu nagini horonoga veize onamiro? Peroveta vazeḡahe? Oꞌe, eḡeꞌa ziꞌohe, Ioaneꞌe peroveta azaḡa vitizoga. ");
INSERT INTO ksj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ioane moneo Buka Zaḡoḡano ꞌahige rae mirihiro, 'Ḡianoꞌi, eḡeꞌa ḡae zamao vaze ꞌahoga ibite tuḡuniꞌuma. Aniꞌe ḡae zamao ḡae ibi ruhibiꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Eꞌanoꞌo eḡeꞌa ziꞌohe, Ioaneꞌe rahao ꞌada fureraroteꞌe azaḡa niduꞌa vitizoga. Rehano Badiꞌaꞌa zuhiꞌaziꞌeteꞌe zamaḡanoꞌe ḡonaga vazeḡa zuni Ioane vitinoga.” ");
INSERT INTO ksj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Ebu Iesu ḡoere igiroteꞌe azaḡa niduꞌa zu takesi azaḡa zuni Ioane mazaonoꞌo babatiso meiro. Ebu zeꞌe ꞌahige rae reiro, “Badiꞌa gau ibiḡaꞌe duduḡa!” ");
INSERT INTO ksj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","U Farisea azaḡa zu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡaꞌe Ioane mazaonoꞌo babatiso mene meiro. ꞌOugadu ze zeḡe veize Badiꞌaꞌa haḡaiteꞌe haḡaiḡa hezahoharo.) ");
INSERT INTO ksj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Iesuꞌa bare ziro, “Izidi azaḡaꞌe naginio idaziꞌuma? Ze iniu heuḡa? ");
INSERT INTO ksj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Zeꞌe tahiꞌa komeꞌakomeꞌaniꞌa ne hunio ehoradu araheꞌeteꞌe heuḡa. Ze rovozadu none tahiꞌaḡaniꞌa mone tahiꞌaḡa mazao ꞌahige huauꞌohe, 'Eme muio suraꞌi hodeha, rehano za mene zavoneha. Ebu eme rune habaꞌano niau ḡoinaheha, rehano za mene nianeha.' ");
INSERT INTO ksj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ioane babatisoꞌa aradu ogomu mene audo zu vaini vuḡa mene gagido. ꞌOugadu za ꞌahige rae reiro, 'Ioaneꞌe vine sauꞌaḡeta.' ");
INSERT INTO ksj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","U Vaze Ubugaꞌe aradu ogomu auꞌohe ebu vaini vuḡa gageꞌohe. ꞌOugeꞌetene, za bare ꞌahige raꞌohe, 'Ḡianoꞌi, aniꞌe ogomu fuꞌa zu vaini vuḡa fuꞌa. Ebu ani takesi azaḡa zu haḡai sauꞌa azaḡa teite tiburuꞌohe.' ");
INSERT INTO ksj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Rehano Badiꞌa zamarone huhuzaḡa hegoteꞌeteꞌe azaḡaniꞌa ane zamarone huhuzaḡaꞌe duduḡa rae fureneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mada ꞌahogano Farisea vazeḡa ꞌahoga, Simonaꞌa Iesu teite oganoga veize Iesu huniro. Ebu Iesuꞌa Farisea vazeḡa ne onamadu ogomu fataḡa babaḡano tave ehoriro. ");
INSERT INTO ksj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Eꞌe neḡanoꞌe haḡai sauꞌa roḡaeḡa ꞌahoganiꞌa radiunu. Aniꞌe Iesuꞌa Farisea vazeḡa neo ogauꞌeteꞌe ederirotene, dehoro hohoga manoḡa naeḡa boro bio komeꞌa manohuga iriꞌavonadu mae ariro. ");
INSERT INTO ksj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ebu roḡae eꞌeꞌa ne diuḡadu Iesu ḡarugano niauꞌenaꞌa, odaḡa babaḡano ḡuḡuriro. Ebu niḡa vuḡaniꞌa Iesu oda rana sore buanadu abune vanirotene, iguḡa hina odaḡa zauhiro. Ebu gubaneꞌenaꞌa, odaḡa furaꞌinadu dehoro beuꞌiro. ");
INSERT INTO ksj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Iesu huniroteꞌe Farisea vazeḡa Simonaꞌa eꞌe horonirotene, ani aneꞌa bare ꞌahige rae reiro, “Vaze ꞌadiꞌe peroveta vazeḡa reifone, ani oboneꞌeteꞌe roḡaeḡaꞌe roḡae nagiga rae ederifo. Roḡae ꞌahiꞌe haḡai sauꞌa roḡaeḡa rae ederifo.” ");
INSERT INTO ksj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iesuꞌa niro, “Simona, e hari ꞌahoga ḡeꞌuma.” Simonaꞌa naenaeniro, “Ihore vazeḡa, ehoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ebu Iesuꞌa hari ꞌahoga meꞌodoharo, “Vaze aheuꞌa vaze ꞌahoga mazaonoꞌo hadi nu madu vesu baroniꞌuma rae reiro. ꞌAhogaꞌe hadi silivaḡa niduꞌa 500 meiro, u ꞌahogaꞌe hadi silivaḡa niduꞌa 50 meiro. ");
INSERT INTO ksj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ebu vaze aheuꞌe hadi vazeḡa mazao hadi baronoga mene idararo, eꞌanoꞌo hadi vazeḡaniꞌa ziro, 'Ahiḡa, ago baronoꞌi.' ꞌOugine, anianine boꞌaḡano iniuꞌa hadi vazeḡa ufeta zamare borofiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simonaꞌa naenaeniro, “E zamarone, hadi silivaḡa 500 meiroteꞌe vazeḡaniꞌa hadi vazeḡa ufeta zamare borofiꞌuma. Mazaḡa hadi vazeḡaniꞌa ane hadi boro ago baronoꞌi rae reiro.” Ebu Iesuꞌa niro, “Ḡae naenaeꞌe duduḡa.” ");
INSERT INTO ksj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ebu Iesuꞌa roḡae tehe ḡianadu Simona niro, “Ḡa roḡae ꞌadi horoneꞌehe? E ḡae ne diuḡatene, ḡaꞌe odahe vuzuꞌoga veize vu mene eneha. Rehano roḡae ꞌahiꞌe eḡe oda ani ni vuḡa hina abunadu iguḡa hina zauhe imineha. ");
INSERT INTO ksj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ḡaꞌe mene gubahe furaꞌiheha, rehano roḡae ꞌahiꞌe eḡeꞌa diuḡi arateꞌeanoꞌo odahe ꞌauꞌaune furaꞌineha. ");
INSERT INTO ksj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ḡaꞌe vadiniheo dehoro mene beuꞌeha, rehano aniꞌe eḡe odao dehoro hohoḡa manoḡa beuꞌeha. ");
INSERT INTO ksj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Eꞌanoꞌo eḡeꞌa ḡaꞌohe, roḡae ꞌahi haḡaiḡa sauꞌa ḡehaḡa ꞌai rae modeha, mazaḡa ani eḡe zamare borofadu eḡe mazao ꞌouge haḡaeha. U eḡeꞌa iniu haḡaiḡa sauꞌa tahiḡa daꞌo rae modine, aniꞌa eḡe tahiḡa daꞌo zamariꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ebu Iesuꞌa roḡae eꞌe niro, “Ḡae haḡai sauꞌa ꞌai rae modeha.” ");
INSERT INTO ksj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ꞌOugirotene, Iesu teite ogauꞌeteꞌe azaḡaꞌe zeḡeꞌa bare zamariro, “ꞌAhiꞌe iniu? Ani vaze haḡai sauꞌa zuni rae modeꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ebu Iesuꞌa roḡae eꞌe niro, “Ḡaeꞌa eḡe mazao fieꞌeteꞌe uꞌano ḡabone hideha. Zamaḡo roḡenadu onamoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Eꞌe enogano Iesuꞌe haba nunu zu ne nunu ragave onamadu Badiꞌaꞌa zuhiꞌaziꞌeteꞌe moneo hari manoḡa haramiro, ebu tahiꞌaḡa gaubanana aheu fare zuni ani ḡatiniro. ");
INSERT INTO ksj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ebu vine sauꞌaniꞌa ragano reiroteꞌe zu ugi nunuꞌa meiroteꞌe roḡaeḡa nuꞌe ugize manoradu Iesu ḡatiniro. Zeḡe boꞌaḡano Magadala roḡaeḡa Mariaꞌe ibite vine sauꞌa fuꞌo aheu fareꞌa ani mazaonoꞌo buaroteꞌe roḡaeḡa. ");
INSERT INTO ksj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ebu Kuza inuga, niḡa Ioana zuni Iesu ḡatiniro. Kuzaꞌe kini Heroda ne taufeꞌeteꞌe vazeḡa. Ebu roḡae ꞌahoga, niḡa Susana zu roḡae nunuꞌa Iesu ḡatiniro. Zeḡeꞌa ḡauze hina Iesu ebu ane tahiꞌatahiꞌa danaziro. ");
INSERT INTO ksj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Vaze ḡuḡuvaḡaniꞌa nuꞌoraro, ebu ne nunuonoꞌo vaze ḡehaḡaniꞌa Iesu vaḡe ariro. ꞌOugadu Iesuꞌa hari ꞌahoga idane ziro, ");
INSERT INTO ksj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Hihi vazeḡa ꞌahoganiꞌa mebaḡano ezone ḡora onamiro. Ani ezone feune ḡorarotene, nuꞌe ibio rururaro. ꞌOugadu vazeꞌa eꞌe ezoneḡa rana edau oname onairo, zu nini'a au hauḡiro. ");
INSERT INTO ksj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ezone nuꞌe hadi habaꞌano rururaro. Eꞌe ezoneḡaꞌe ḡuhuriro, rehano roraro, mazaḡa rahaꞌe mene abuꞌa. ");
INSERT INTO ksj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ezone nuꞌe ve renogano rururaro. Ebu ezone eꞌe zu ve renogaꞌe tibano ḡuhure bororanadu ve renoganiꞌa ezone ḡuhuḡa simariniro. ");
INSERT INTO ksj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","U ezone nuꞌe raha manoḡano rururanadu faine ḡuhure bororaro, ebu hugaꞌe ḡae 100 hudaro.” Iesuꞌa ḡoere hauḡirotene, ḡihau ziro, “Teḡaḡeta vazeḡaꞌe faine egadu huga ederoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Iesu tahiꞌatahiꞌaꞌa hari idaidaḡa huga ḡadiniro. ");
INSERT INTO ksj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ebu Iesuꞌa naenaeziro, “Badiꞌaꞌa zuhiꞌaziꞌeteꞌe moneo ꞌuꞌuru tirotaꞌaꞌe zae mazao fureniro, rehano vaze nunu mazaoꞌe hari idaidaḡa hina ḡoreziro. ꞌOugadu ze ḡoere huga aḡuꞌa. Buka Zaḡoḡano ꞌahige rae reiro, 'Zeꞌe horoneꞌe rehano, hugaꞌe mene horoniꞌuma. Zeꞌe igiꞌe rehano, hugaꞌe mene ederiꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Eḡeꞌa ezone feune ḡorauꞌeteꞌe hariḡa idaidaḡa huga ihoziꞌuma. Ezoneꞌe Badiꞌa ḡoere. ");
INSERT INTO ksj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Vaze nuꞌe ibio rururaroteꞌe ezoga heuḡa. Zeꞌe Badiꞌa ḡoere igiꞌe rehano, Sataniꞌa aradu zeḡe zama mazaonoꞌo Badiꞌa ḡoere mae vaḡineꞌe ꞌahine, Badiꞌa ḡoere mene mae ḡihinadu ḡabone mene hideꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Vaze nuꞌe hadi habaꞌano rururaroteꞌe ezoga heuḡa. Zeꞌe Badiꞌa ḡoere igiꞌetene matuꞌeꞌenaꞌa, mae ḡihineꞌohe. Rehano zeꞌa fieꞌetaꞌaꞌe taiga oꞌoꞌa radu mada tahiḡa daꞌo fieꞌohe. Ebu Sataniꞌa tuhuze nuriꞌetene uiteꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Vaze nuꞌe ve renogano rururaroteꞌe ezoga heuḡa. Zeꞌe Badiꞌa ḡoere igiꞌe rehano, ḡaboneze zamaḡano zamaze aduga borofeꞌohe, haba toheḡa ufeta zamareꞌohe zu haba ḡauḡa manomano hina ufeta matuꞌeꞌohe. Eꞌanoꞌo zeꞌe mene iniꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Vaze nuꞌe raha manoḡano rururaroteꞌe ezoga heuḡa. Ze zamaze manoḡa zu duduḡa hina Badiꞌa ḡoere igiꞌohe. Eꞌanoꞌo zeꞌe aduga hideꞌetene, ḡoere eꞌe oboneꞌenaꞌa zu zamaze obone giganeꞌenaꞌa, hudauꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Vaze ꞌahoganiꞌa ihure hofadu siuva hina mene ogone tiꞌe ga vazuni fataḡa ꞌuꞌuḡano mene tiꞌohe. Rehano ne diuḡeꞌeteꞌe azaḡaniꞌa agaḡa horonoga veize ihure odaḡa rana tiꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ihureꞌa ḡau niduꞌa aganeꞌeteꞌe teige, ꞌuꞌuru radiroteꞌe ḡauḡa niduꞌa fureraꞌuma, ebu ogone ḡahiniroteꞌe ḡauḡa zuni ederiꞌuma zu horoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Eꞌano'o zaeꞌa igiꞌeteꞌe ḡoeꞌa faine zamaroꞌi. Faifaine zamare igiꞌeteꞌe azaḡaꞌe Badiꞌaꞌa edeḡa ufeta boro ziniꞌuma. U mene faine zamare igiꞌeteꞌe azaḡaꞌe zeḡeꞌa tahiḡa edeḡa rae zamareꞌeteꞌe zuni mae vaḡiniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Eꞌe enogano Iesu viꞌa ebu negoḡa duḡuruꞌa ani vaḡe onamiro, rehano vaze ḡuḡuvaḡa ꞌahine ani uhiḡa onamoga mene idararo. ");
INSERT INTO ksj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ebu vaze ꞌahoganiꞌa Iesu niro, “Viꞌu zu negoḡo duḡuruꞌa ḡiaꞌihi radu ne enogano edau radiuꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Iesuꞌa naenaeziro, “Badiꞌa ḡoere egadu ꞌouge haḡaeꞌeteꞌe azaḡaꞌe eḡe nanu zu eḡe nego.” ");
INSERT INTO ksj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Mada ꞌahogano Iesuꞌa ane tahiꞌatahiꞌa teite ḡasio tiradu ziro, “Eme duꞌura moneafa fare onamihi.” Ebu ze fare onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ze ḡasio fare onameꞌeteꞌe zamaḡano Iesuꞌe baziro. Ebu zavara boroꞌa feuradu vuꞌa ḡasi kafere diuḡiro zu foꞌariro. Eꞌanoꞌo zeꞌe nariga ꞌomatiro. ");
INSERT INTO ksj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ꞌOugirotene, Iesu tahiꞌatahiꞌaꞌa ane vaḡe onamadu evaniro, “Ihore vazeḡa! Ihore vazeḡa! Eme izidi hunuhuneꞌohe!” Ebu Iesuꞌa evatadu zavara zu saꞌu riḡa roziro. ꞌOugirotene, zavara zu saꞌuꞌa hauḡiro zu niduꞌa roḡeraro. ");
INSERT INTO ksj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ebu Iesuꞌa ziro, “Za eḡe mazao mene fieꞌehe?” Ebu zeḡe niduꞌa rihauꞌenaꞌa zu zaguzagauꞌenaꞌa, ḡadimutitiro, “ꞌAhiꞌe iniu? Aniꞌa zavara zu saꞌu riḡa ḡorezeꞌetene, ane ḡoere egohauꞌohe!” ");
INSERT INTO ksj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ebu Iesu zu ane tahiꞌatahiꞌaꞌa Galilea duꞌuraḡa moneafa ruhau faradu Gerasa azaḡa habao hebetiro. ");
INSERT INTO ksj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iesuꞌa ḡasionoꞌo buarotene, eꞌe habaꞌano vine sauꞌaḡeta vazeḡa ꞌahoganiꞌa Iesu hidiro. Aniꞌe mada faḡa firina zu neḡano mene radiunu, rehano idu habaꞌano radiunu. ");
INSERT INTO ksj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ani Iesu horonirotene, ani zamao higau bauradu ḡihau ḡaniḡanaro, “Iesu, Ḡihiꞌa Hune Badiꞌaḡa Ubuga! Ḡaꞌe eḡe mazao nagini urateꞌohe? E umiꞌeꞌohe, aduga ago enoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Aniꞌa ꞌouge reirotaꞌaꞌe mazaḡa Iesuꞌa vine sauꞌa riḡa ḡoreniro, “Ani mazaonoꞌo buanoꞌi!” Vine sauꞌaniꞌa ḡae ḡehaḡa ani ragano reiroteꞌe uꞌano, haba eꞌe azaḡaniꞌa auri adiriḡa riḡa hina ꞌevoꞌa zu odaḡa batune teadu ḡiane radiudo. Rehano aniꞌa miniḡa riꞌi ḡuzuhadu vine sauꞌaniꞌa tuḡune haba bohaꞌa onamido. ");
INSERT INTO ksj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ebu Iesuꞌa ḡadiniro, “Ḡa niḡo iniu?” Aniꞌa naenaeniro, “E niꞌe Legioni,” mazaḡa vine sauꞌa ḡehaḡaniꞌa ani ragano radiunu. ");
INSERT INTO ksj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ebu vine sauꞌasauꞌaniꞌa Iesu uminiro, “Eme hoꞌone ḡonaga oꞌoꞌano ago tuḡufoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Eꞌe madaḡano aba ḡuḡuvaḡaꞌe maḡa komeꞌano ogaunu. Eꞌanoꞌo vine sauꞌasauꞌaniꞌa Iesu uminiro, “Eme aba ḡuḡuvaḡa mazao diuḡoga tuḡufoꞌi.” Iesuꞌa naenaeziro, “Idaḡa, buanadu onamoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ebu vine sauꞌasauꞌa ꞌai vaze eꞌe mazaonoꞌo buanadu aba ḡuḡuvaḡa mazao diuḡe ḡouriro. Ebu aba ḡuḡuvaḡaniꞌa maḡa komeꞌa gagaḡanonoꞌo dure ovoradu duꞌurao hunuhune rudaro. ");
INSERT INTO ksj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aba taufeꞌeteꞌe azaḡaniꞌa naginiꞌa fureraroteꞌe horonirotene, ferau manahadu ne boro zu ne komeꞌa azaḡa meꞌodoziniro. ");
INSERT INTO ksj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ebu vaze ḡehaḡaꞌe naginiꞌa fureraroteꞌe ḡianoga veize Iesu vaḡe onamiro. Ze onamirotene, vine sauꞌanonoꞌo manoriroteꞌe vazeḡaniꞌa dabua vidanadu zamarone manoḡano Iesu oda babaḡano ehoreꞌeteꞌe horoniro. Eꞌanoꞌo ze rihau ḡouriro. ");
INSERT INTO ksj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ebu naginiꞌa fureraroteꞌe niduꞌa horoniroteꞌe azaḡaniꞌa haba nunuonoꞌo ariroteꞌe azaḡa mazao vine sauꞌaḡeta vazeḡaꞌe nougenouge manoriroteꞌe meꞌodoziniro. ");
INSERT INTO ksj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ꞌOugadu Gerasa habaꞌa azaḡa niduꞌaꞌe rihau rudanadu Iesuꞌa eꞌe habaꞌanonoꞌo vaḡinoga uminiro. Eꞌanoꞌo Iesuꞌe ḡasio tiradu bare duꞌura moneafa fare onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Vine sauꞌanonoꞌo manoriroteꞌe vazeḡaꞌe Iesu teite onamoga veize uminiro. Rehano Iesuꞌa ani tuḡuneꞌenaꞌa, niro, ");
INSERT INTO ksj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ḡa bare neḡo onamoꞌi, ebu Badiꞌaꞌa ḡae mazao manoḡa borofe haḡateꞌe ne azaḡa ihozoꞌi.” Eꞌanoꞌo ani bare onamadu ne niduꞌa ragaveꞌenaꞌa, Iesuꞌa ani mazao manoḡa borofe haḡairoteꞌe hariḡa niduꞌa meꞌodoziniro. ");
INSERT INTO ksj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Iesuꞌa barirotene, vaze ḡuḡuvaḡaniꞌa ani mae zouniro, mazaḡa zeḡe niduꞌa ani guhine radiro. ");
INSERT INTO ksj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Eꞌe madaḡano vaze ꞌahoga, niḡa Iairoꞌa ariro. Aniꞌe nu'onu'o neḡa vazeḡa ḡihiꞌaḡa ꞌahoga. Aniꞌa Iesu oda babaḡano ḡuḡuradu uminiro, “Eḡe teite nehe onamihi!” ");
INSERT INTO ksj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Mazaḡa aboḡa tibuhugaꞌe uginadu nariga rudaro. Ani muriꞌe gaubanana aheu fare. Ebu Iesuꞌa Iairo teite ane ne onameꞌeteꞌe zamaḡano vaze ḡuḡuvaḡaniꞌa naenaenoꞌo bibine varahe onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Vaze ḡehaḡa boꞌaḡano roḡae ꞌahogaꞌe roḡae ugiꞌa madu muri gaubanana aheu fare adugano radiunu. Rehano gohe vazeḡa ꞌahoga zuni fainoga mene idararo. ");
INSERT INTO ksj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Aniꞌa Iesu ḡaruna aradu dabuaḡa ꞌariḡa tahiḡa oboniro. ꞌOugirotene, ugiḡaniꞌa zogone hauḡiro. ");
INSERT INTO ksj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ebu Iesuꞌa ḡadimaro, “Iniuꞌa oboheha?” Vaze niduꞌa naenaeniro, “Eme mene.” Ebu Peteroꞌa naenaeniro, “Zuhiꞌa Boro, vaze ḡuḡuvaḡaniꞌa ḡae bibiꞌe varaheꞌeteꞌe uꞌano, vaze ḡehaḡaniꞌa ḡa tuꞌiꞌeha.” ");
INSERT INTO ksj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Rehano Iesuꞌa reiro, “Vaze ꞌahoganiꞌa oboheha. E edeḡa, eḡe mazaonoꞌo gigiꞌaheꞌa buau vaḡiniro.” ");
INSERT INTO ksj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ꞌOugadu roḡae aꞌe ani mazao naginiꞌa fureraroteꞌe uꞌuranoga mene idaḡa rae zamariro. Ebu ani rihauꞌenaꞌa rereru Iesu vaḡe aradu ani oda babaḡano ḡuḡuriro. Ebu ani nougadu Iesu dabua oboniroteꞌe, zu nougenouge ugiḡaniꞌa zogone manoriroteꞌe vaze niduꞌa zamao ziro. ");
INSERT INTO ksj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ebu Iesuꞌa niro, “Aboe, ḡaeꞌa eḡe mazao fieꞌeteꞌe uꞌano, ugiḡoꞌa manoreha. Zamaḡo roḡeḡano onamoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iesuꞌa ꞌize ḡoereꞌeteꞌea, vaze ꞌahoganiꞌa Iairo neonoꞌo aradu Iairo niro, “Aboḡo ꞌai rudaneha. Ihore vazeḡa barebare ago uminoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Rehano Iesuꞌa hari eꞌe egadu Iairo niro, “Ago rihanoꞌi. Fie tauḡoꞌi, ꞌougine, aboḡoꞌe bare ḡabodiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ebu Iesuꞌa Iairo neo feurirotene, Petero, Ioane, Iakobo zu roḡae komeꞌa viꞌa moga daꞌo neo zamaze diuḡiro, u vaze ꞌahogaꞌahogaꞌe diuḡoga mene idaḡa reiro. ");
INSERT INTO ksj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ze diuḡirotene, vaze niduꞌa ne zamaḡano niau kuau radiunu. Ebu Iesuꞌa ziro, “Ago niau kuanoꞌi. Aniꞌe mene rudaneha, rehano bazeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ze ani eḡofoharo, mazaḡa zeꞌe roḡae komeꞌa aꞌe rudarotaꞌaꞌe ederiro. ");
INSERT INTO ksj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Rehano Iesuꞌa roḡae komeꞌa ꞌevoꞌa obonadu niro, “Roḡae komeꞌa, iḡunoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ꞌOugirotene, ani viganiꞌa bare aradu zogone ḡabode iḡuniro. Ebu Iesuꞌa ziro, “Ogomu nu hanoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ani viꞌa mogaꞌe ufeta zaguzagaro. Rehano Iesuꞌa riḡa ḡoreziro, “Naginiꞌa fureranateꞌe vazeni ꞌahoga ago noꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iesuꞌa ane tahiꞌa gaubanana aheu fare huze nuꞌoziro. Ebu vine sauꞌa niduꞌa hegoze buzeꞌeteꞌe zu ugi nunu faineꞌeteꞌe gigiꞌaḡa zu inaraḡa ziniro. ");
INSERT INTO ksj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ebu Badiꞌaꞌa zuhiꞌaziꞌeteꞌe moneo haramozenoga zu ugi azaḡa faizoga veize tuḡuziro. ");
INSERT INTO ksj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Aniꞌa ziro, “Zae ragavo zamaḡano ḡau ꞌahoga ago moꞌi. Tuḡu, nihara, ogomu, hadi zu dabua ꞌahoga ago odohoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Noꞌe neḡa diuḡoꞌidene, eꞌea daꞌo radoꞌi, onamo ne eꞌe mode iḡunoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ne azaḡaniꞌa zae mene mae zouzadu za ne eꞌe modoꞌidene, odaze huꞌuruḡa zauhe mode manahoꞌi. ꞌOuge haḡadu zeḡeꞌa zae mazao sauꞌa haḡairoteꞌe ihoziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ebu Iesu tahiꞌatahiꞌaꞌa iḡunadu neḡaneḡa ragave onameꞌenaꞌa, haba niduꞌa zamaḡano hari manoḡa haramiro zu ugi azaḡa faiziro. ");
INSERT INTO ksj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galilea habaꞌa kiniḡa, Herodaꞌa Iesu moneo hari niduꞌa igirotene, zamaḡaniꞌa ꞌadaꞌadaniro. Mazaḡa vaze nuꞌe ꞌahige rae reiro, “Iesuꞌe Ioane Babatiso. Aniꞌa rune azaḡa boꞌaḡano bare ḡabodeha,” ");
INSERT INTO ksj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ebu vaze nuꞌe raenaꞌa, “Aniꞌe Elia. Ani bare fureraneha,” ebu vaze nuꞌe raenaꞌa, “Amahi peroveta azaḡa boꞌaḡano vaze ꞌahoganiꞌa bare ḡabodeha.” ");
INSERT INTO ksj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Rehano Herodaꞌe ꞌahige rae reiro, “Ioaneꞌe eḡeꞌa ꞌunuḡa variꞌe riꞌadu gouniro. Ze iniu moneo ꞌouge ḡoereꞌohe?” Ebu ani Iesu ḡianihi reiro. ");
INSERT INTO ksj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Apostolo azaḡaniꞌa Iesu vaḡe bare arirotene, zeḡeꞌa nagini haḡairoteꞌe niduꞌa Iesu meꞌodoharo. Ebu Iesuꞌa zeḡe teite daꞌo vaḡinadu Betesaida onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Rehano vaze ḡuḡuvaḡaniꞌa aniꞌe noꞌe onameꞌeteꞌe ederadu ani hegotiro. Ebu Iesuꞌa ze mae ḡihizadu Badiꞌaꞌa zuhiꞌaziꞌeteꞌe moneo haramiro, zu ugize fainiteꞌe azaḡa faiziro. ");
INSERT INTO ksj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ḡoravararotene, Iesu tahiꞌa gaubanana aheu fareꞌa Iesu vaḡe aradu niro, “ꞌAhiꞌe haba bohaꞌa. Ogomu vaḡoga ebu ohere bazoga veize vaze ḡuḡuvaḡa ne uhiḡauhiḡano tuḡuze vaḡizoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Rehano Iesuꞌa ziro, “Zaeꞌa ogomu zenoꞌi.” Ebu zeḡeꞌa naenaeniro, “Eme mazaoꞌe ꞌuvahu odoga fuꞌo ebu ḡozone aheu daꞌo. Vaze ḡuḡuvaḡa ꞌahi ḡubuzoga veize, emeꞌa onamadu ogomu hoitiꞌumahe?” ");
INSERT INTO ksj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Eꞌea vaze niduꞌa boꞌaḡano ohoze niduꞌa daꞌoꞌe 5,000. Iesuꞌa ane tahiꞌatahiꞌa ziro, “Zeꞌa vaze 50 rovonerovone ehorifine ihozoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ebu ane tahiꞌatahiꞌaꞌa ihozadu vaze niduꞌa ꞌouge ehoriro. ");
INSERT INTO ksj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Eꞌe ḡarugano Iesuꞌa ꞌuvahu odoga fuꞌo zu ḡozone aheu madu adure ḡianeꞌenaꞌa, Badiꞌa mazao manoḡa tauḡi rae reiro. Ebu ꞌuvahu odoga zu ḡozone tahitahe vahegadu ane tahiꞌatahiꞌa ziniro, ebu ze vaze niduꞌa ḡahuge ziniro. ");
INSERT INTO ksj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ꞌOugadu zeḡe niduꞌa au ubararo. Ebu Iesu tahiꞌatahiꞌaꞌa ogomu ḡahaꞌaḡahaꞌaꞌe nuꞌonadu tunahu niduꞌa gaubanana aheu fare iri'avoniro. ");
INSERT INTO ksj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Mada ꞌahogano Iesuꞌe ane daꞌo kurau radiro, ebu ane tahiꞌatahiꞌaꞌe ane teite radiro. Ebu Iesuꞌa ḡadiziro, “Vazeꞌa eꞌe iniu rae raꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Zeꞌa naenaeniro, “Vaze nuꞌe ḡaꞌe Ioane Babatiso, nuꞌe Elia, ebu nuꞌe amahi peroveta azaḡa boꞌaḡano ꞌahoganiꞌa ḡabode iḡuniro rae raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ebu Iesuꞌa ḡadiziro, “U zaꞌe eꞌe iniu rae raꞌohe?” Peteroꞌa niro, “Ḡaꞌe Badiꞌaꞌa tuḡuniroteꞌe vazeḡa, Keriso.” ");
INSERT INTO ksj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ebu aniꞌa ḡoere riḡa ziro, “Ḡoere ꞌahi vazeni ꞌahoga ago noꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ebu aniꞌa ziro, “Vaze Ubuganiꞌa aduga ḡehaḡa hidiꞌuma. Ebu vaze boroboro, dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡaniꞌa hezahohaꞌuma zu goruniꞌuma. Ebu aniꞌa mada uḡiduḡano bare ḡabodiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ebu hena Iesuꞌa zeḡe niduꞌa ziro, “Iniuꞌa eḡe ḡaruna hegotihi rae roꞌidene, ane ura niduꞌa modadu mada niduꞌa ane satauro odoheꞌenaꞌa, eḡe hegotoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mazaḡa iniu ane ḡabone obone giganine, ani ḡabone tuḡutuḡu mene hidiꞌuma. Rehano iniu ane ḡabone eḡe veize ahetine, ḡabone tuḡutuḡu hidiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Vaze ꞌahoganiꞌa haba niduꞌa madu ḡaboneḡa daunine ga mae vaḡinine, nagi manoḡa hidiꞌuma? ");
INSERT INTO ksj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Iniuꞌa eḡe zu eḡe ḡoere uꞌano mazagaronine, Vaze Ubuga zuni ane agaḡano, Moga agaḡano ebu tuḡure viga zaḡoḡa niduꞌa agaḡano ariteꞌe madaḡano vaze eꞌe uꞌano mazagaroniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Eḡeꞌa hube hune ziꞌohe, izidi ꞌada edau radiuꞌeteꞌe azaḡa boꞌaḡano vaze nuꞌa ꞌizema rudanogano Badiꞌaꞌa zuhiꞌaziꞌeteꞌe horoniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Iesuꞌa ꞌouge ziroteꞌe enogano mada fuꞌo uḡidu fare meiro. Aniꞌa Petero, Ioane zu Iakobo zamazadu kuranoga veize maḡa ꞌahoga itiro. ");
INSERT INTO ksj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ani kurauꞌeteꞌe zamaḡano, iraḡaniꞌa nufiro zu dabuaḡaniꞌa ꞌuranadu vazavazahiro. ");
INSERT INTO ksj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Eꞌe madaḡano vaze aheu, Mose zu Eliaꞌa fureranadu Iesu teite ḡoeriro. ");
INSERT INTO ksj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ze agaḡa boro zamaḡano fureraro, ebu Iesuꞌa Ierusalema onamadu eꞌea haḡaiteꞌe haḡaiḡa, ane rune moneo ḡoeriro. ");
INSERT INTO ksj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petero zu Iesu tahiꞌa aheuꞌe baze rudaro. Ebu ze evatirotene Iesu agaḡa zu ani uhiḡano vaze aheuꞌa edau radiuꞌeteꞌe horoziro. ");
INSERT INTO ksj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mose ebu Eliaꞌa Iesu muhinihi reirotene, Peteroꞌa Iesu niro, “Ihore vazeḡa, eme ꞌahao radiuꞌetaꞌaꞌe manoḡa. Emeḡe uḡiduꞌa nugo taruha uḡidu ogoratihi, tibaꞌe ḡae veize, tibaꞌe Mose veize, ebu tibaꞌe Elia veize.” Peteroꞌe aniꞌa nagini raꞌeteꞌe mene ederiro. ");
INSERT INTO ksj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Aniꞌa ꞌize ḡoereꞌeteꞌea, ḡozeꞌa ovadu ogoziro ebu ze ḡoze zamaḡano diuḡadu rihau rudaro. ");
INSERT INTO ksj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ebu ḡozeonoꞌo ago ꞌahoganiꞌa buanadu ziro, “ꞌAhiꞌe eḡe Ubude, eḡeꞌa ohotiroteꞌe vazeḡa. Za ani ḡoere egohanoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ago eꞌeꞌa hauḡirotene, ze Iesu daꞌo horoniro. Ane tahiꞌa uḡiduꞌa sifu radiuꞌenaꞌa, ze nagini horoniroteꞌe vazeni ꞌahoga mazao mada nu mene rae fureniro. ");
INSERT INTO ksj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Irarirotene, Iesu zu ane tahiꞌa uḡiduꞌa maḡanonoꞌo ovairo ebu vaze ḡuḡuvaḡa hidiro. ");
INSERT INTO ksj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Vaze ḡuḡuvaḡa boꞌaḡano vaze ꞌahoganiꞌa Iesu huniro, “Ihore vazeḡa, e ḡa umiꞌeꞌohe. Eḡe ubude tibuhuga ꞌadi ḡabonoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Vine sauꞌaniꞌa ani agatohauꞌetene, aniꞌe tabara ḡaniḡanauꞌenaꞌa, beroꞌudeꞌohe zu hebeꞌanonoꞌo busureꞌohe. Vine sauꞌaniꞌa mada niduꞌa ani zamaḡano radiuꞌenaꞌa, ahiꞌa sausauneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Eḡeꞌa ḡae tahiꞌatahiꞌa mazao vine sauꞌa eꞌe hegone bunoga radu umizeha, rehano ze mene idaraneha.” ");
INSERT INTO ksj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iesuꞌa naenaeziro, “Zaꞌe Badiꞌa mazao mene fiꞌeꞌeteꞌe zu veꞌoḡa haḡaeꞌeteꞌe azaḡa! E noꞌe faḡa zae teite radiꞌuma, zu zae mazao zamahe obone tiꞌma?” Ebu tahiꞌa eꞌe moga niro, “Ubugo tutune ꞌahi aroꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ebu tahiꞌa eꞌeꞌa Iesu vaḡe areꞌeteꞌea, vine sauꞌaniꞌa ane agatohanadu ani higau bauriro zu beroꞌudiro. ꞌOugirotene, Iesuꞌa vine sauꞌa ronadu tahiꞌa eꞌe fainiro ebu ani moga bare haro. ");
INSERT INTO ksj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ebu vaze niduꞌa Badiꞌa gigiꞌaḡa boro horonadu zaguzagaro. Vaze niduꞌa Iesuꞌa haḡairoteꞌe haḡaiḡa horonadu zaguzagarotene, Iesuꞌa ane tahiꞌatahiꞌa ziro, ");
INSERT INTO ksj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ḡoere ꞌadi faifaine egoꞌi. Vaze Ubugaꞌe agireḡa ꞌevoreo riꞌiniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Rehano Iesu tahiꞌatahiꞌaꞌe ane ḡoere huga mene ederiro, mazaḡa ḡoere huga aꞌe ꞌuꞌuruḡa radu aniꞌa nagini zirotaꞌaꞌe mene ederiro. Ebu ze ane ḡoere moneo bare ḡadimanoga zuni riharo. ");
INSERT INTO ksj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Iesu tahiꞌatahiꞌa boꞌaḡano iniuꞌe ḡihiꞌa hune radu ze zeḡeꞌa bare taꞌirotitiro. ");
INSERT INTO ksj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iesuꞌa ze nagini zamareꞌeteꞌe ederadu tahiꞌa komeꞌa ꞌahoga zamaharo ebu ane babaḡano ohoniro. ");
INSERT INTO ksj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Aniꞌa ziro, “Iniuꞌa eḡe niḡano tahiꞌa komeꞌa ꞌahiguḡa mae ḡihinine, aniꞌe eḡe mae ḡihiheꞌohe. Ebu iniuꞌa eḡe mae ḡihihine, aniꞌe eḡe tuḡuhiroteꞌe Badiꞌaḡa mae ḡihineꞌohe. Zae boaḡano iniuꞌa aneꞌa bare niḡa mae ovoine, aniꞌe vaze ḡihiꞌa hune.” ");
INSERT INTO ksj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ioaneꞌa Iesu niro, “Ihore vazeḡa, eme vaze ꞌahoganiꞌa ḡae niḡano vine sauꞌasauꞌa hegoze buziroteꞌe horoniro. ꞌOugadu eme ani garariro, mazaḡa aniꞌe mene emeḡe none vazeḡa.” ");
INSERT INTO ksj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Rehano Iesuꞌa niro, “Ani ago gararoꞌi. Za mene agiroziꞌeteꞌe vazeḡaꞌe zae mone vazeḡa.” ");
INSERT INTO ksj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Iesuꞌe adure ititeꞌe madaḡaniꞌa hanitirotene, ani Ierusalema onamihi radu zamaḡa ohoniro. ");
INSERT INTO ksj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ebu ani vaze nu ibite tuḡuzadu ze ani veize ḡau nu ruhibifine Samaria azaḡa habaꞌano ne ꞌahoga diuḡiro. ");
INSERT INTO ksj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Rehano Iesuꞌe Ierusalema onamihi reiro ꞌahine, ne azaḡaniꞌa ani mene mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Iesu tahiꞌa aheu, Iakobo zu Ioaneꞌa horonadu Iesu ḡadiniro, “Zuhiꞌa Boro, ḡa emeꞌa Badiꞌa uminadu adureonoꞌo ire roga tuḡunoga zu ze hufi haozoga urateꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Rehano ani tehadu roziro. ");
INSERT INTO ksj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ebu ze ne ꞌahoga onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ze ibio onameꞌeteꞌea, vaze ꞌahoganiꞌa aradu Iesu niro, “Ḡaeꞌa noꞌe onamine, e ḡa hegotiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iesuꞌa naenaeniro, “Butu ḡuniḡaꞌe bazuni habaꞌazeta, ebu hitana niniḡaꞌe nezeta. Rehano Vaze Ubugaꞌe bazuni habaꞌa oꞌoꞌa.” ");
INSERT INTO ksj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ebu Iesuꞌa vaze ꞌahoga niro, “Eḡe hegotoꞌi.” Rehano vaze eꞌeꞌa naenaeniro, “Zuhiꞌa Boro, e ibite geno mamahe guri onamihi.” ");
INSERT INTO ksj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Rehano Iesuꞌa niro, “Rune azaḡaniꞌa rune azaḡa guriꞌuma. U ḡaꞌe onamadu Badiꞌaꞌa zuhiꞌaziꞌeteꞌe moneo rae furenoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ebu vaze ꞌahoganiꞌa niro, “Zuhiꞌa Boro, e ḡa hegotiꞌuma. Rehano e ibite geno negohe nabudihe uhizi onamihi.” ");
INSERT INTO ksj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iesuꞌa naenaeniro, “Iniuꞌa teheꞌenaꞌa mebaḡa afidaune, mene faine afidaꞌuma. Eꞌe teige, iniuꞌa teheꞌenaꞌa, gau nunu zamarine, aniꞌe Badiꞌaꞌa zuhiꞌazoga veize gauogaꞌe mene idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Eꞌe enogano, Zuhiꞌa Boroꞌa vaze ꞌahoga 72 ohozadu aneꞌa onamihi reiroteꞌe neḡa niduꞌa zu habaꞌa niduꞌa aheuaheu ibite tuḡuziro. ");
INSERT INTO ksj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ebu Iesuꞌa ziro, “Hiriviteꞌe ḡauḡaꞌe ḡehaḡa bagaḡa, rehano gau azaḡaꞌe tahiḡa. Eꞌanoꞌo hiriveꞌeteꞌe Zuhiꞌaḡa Boro mazao gau azaḡa ane mebao tuḡuzoga veize uminoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Onamoꞌi. Butu ḡuniḡa boꞌaḡano mamoe tuḡuzeꞌeteꞌe teige, e za agire azaḡa boꞌaḡano tuḡuzeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Hadi niharaḡa ga fuse ga tamaka ago odohoꞌi. Ebu ibio vaze ꞌahoga hidoꞌidene, ani teite faḡa ḡoereꞌenaꞌa, mada ago hauḡoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Vaze ꞌahoga ne diuḡoꞌidene, ibite geno ꞌahige roꞌi, 'Badiꞌaꞌa zama roḡeḡa zenoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ne eꞌe zamaḡano vaze ꞌahoganiꞌa zama roḡeḡa urateꞌeteꞌe vazeḡa reine, zaꞌa rateꞌe zama roḡeḡaꞌe ani rana radiꞌuma. U mene reine, zama roḡeḡa eꞌeꞌa zae bare vaḡiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ne tiba zamaḡano daꞌo radoꞌi, ebu zeḡeꞌa ziniꞌeteꞌe ogomuḡa anoꞌi zu gagoꞌi, mazaḡa gau azaḡaniꞌa gauze naeḡa meꞌuma. Ne ꞌahogaꞌahogano ago ragave onamoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ne ꞌahoga onamadu za mae ḡihizoꞌidene, nagi ogomu ziniꞌeteꞌe anoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ebu eꞌea ugi azaḡa faizadu ꞌahige haramozenoꞌi, 'Badiꞌaꞌa zuhiꞌaziꞌeteꞌe madaḡaniꞌa zae mazao haniteha.' ");
INSERT INTO ksj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Rehano ne ꞌahoga onamadu za mene mae ḡihizoꞌidene, ne ibi boro onamoꞌi, ");
INSERT INTO ksj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","ebu ꞌahige zoꞌi, 'Badiꞌaꞌa zae haḡai sauꞌa ederifine, eme zae haba konoḡa odafeo kadaranateꞌe ꞌada zauhe modadu iḡuneꞌohe. Rehano ederoꞌi, Badiꞌaꞌa zuhiꞌaziꞌeteꞌe madaḡaniꞌa haniteha.'” ");
INSERT INTO ksj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ebu Iesuꞌa bare ziro, “Eḡeꞌa hube hune ziꞌohe, Badiꞌa kota madaḡano za mene mae ḡihiziroteꞌe azaḡaꞌe Sodoma azaḡa ufeta vitize aduga boro hidiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korasini azaḡa, za aduga boro hidiꞌuma! Betesaida azaḡa, za aduga boro hidiꞌuma! Eḡeꞌa zae mazao haḡairoteꞌe haḡaiḡa gigiꞌaꞌe Turo zu Sidono azaḡa mazao haḡaifone, ze dabuaze ḡuꞌa vidau ehoradu vega vadinizeo ase ḡuzuheꞌenaꞌa, haḡaize sauꞌanonoꞌo ḡihurifo. ");
INSERT INTO ksj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Rehano Badiꞌa kota madaḡano zaꞌe Turo zu Sidono azaḡa ufeta vitize aduga boro hidiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kaperanauma azaḡa, zaꞌe adureo Badiꞌa habaꞌa tutuze itiꞌuma rae zamareꞌehe? Mene! Zaꞌe rune habaꞌano mae feuziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Za egoziniꞌeteꞌe vazeḡaꞌe eḡe egoniꞌohe, ebu za hezahoziniꞌeteꞌe vazeḡaꞌe eḡe hezahoniꞌohe. Ebu eḡe hezahohiꞌeteꞌe vazeḡaꞌe eḡe tuḡuhiroteꞌe Badiꞌaḡa hezahohauꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ebu Iesu tahiꞌa 72 onamadu Iesu vaḡe barirotene, matuꞌeꞌenaꞌa niro, “Zuhiꞌa Boro, eme ḡae niḡano vine sauꞌa hegoze buzirotene, ze emeḡe ḡoere egofiro.” ");
INSERT INTO ksj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ebu Iesuꞌa ziro, “Vazabu agaḡa teige, Sataniꞌa adureonoꞌo ḡarihe fase buauꞌeteꞌe horoniro. ");
INSERT INTO ksj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ḡianoꞌi, e zaeꞌa mohe zu asiasi edeze ruzeꞌeteꞌe zu emeḡe agire Satani gigiꞌaḡa raharahaneꞌeteꞌe inaraḡa ziniro. Ḡau ꞌahoganiꞌa za mene sausauziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Rehano vine sauꞌasauꞌaniꞌa zae ḡoere egoziniꞌeteꞌe uꞌano ago matuꞌoꞌi, rehano zae niꞌe adureo mirihiroteꞌe uꞌano matuꞌoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Eꞌe madaḡano Iesuꞌe Vine Zaḡoḡaniꞌa iriꞌavonadu matuꞌe rudaro, ebu ꞌahige rae reiro, “Mama, ḡaꞌe adure zu raha Zuhiꞌaḡa. E niguꞌeꞌohe, mazaḡa ḡaeꞌa vaze huhuzaḡa zu edeḡa boro azaḡa mazaoꞌe ḡoere huga ꞌahiguḡa ꞌuꞌuru tiro, rehano tahiꞌa komeꞌa teigeꞌeteꞌe azaḡa mazaoꞌe rae fureniro. Mama, a hube, ꞌouge haḡairotaꞌaꞌe ḡae ura. ");
INSERT INTO ksj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Eḡe Mamaꞌa ḡau niduꞌa eḡe iniro. Vazeni ꞌahoga Ubuga aḡuꞌa, rehano Moga daꞌo Ubuga edeḡa. Ebu vazeni ꞌahoga Moga aḡuꞌa, rehano Ubuga daꞌo zu Ubuganiꞌa Moga moneo ihozoga veize ohotiroteꞌe azaḡa daꞌo Moga edeḡa.” ");
INSERT INTO ksj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ebu Iesuꞌa ane tahiꞌatahiꞌa tehe ḡiazadu sifu ziro, “Zaꞌe matuꞌoꞌi, mazaḡa naginiꞌa fureruꞌeteꞌe ubumaze hina horoneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Eḡeꞌa ziꞌohe, peroveta azaḡa zu kini azaḡaꞌe zaeꞌa izidi nagini horoneꞌeteꞌe horonihi rae reiro, rehano mene horoniro, ebu zaeꞌa izidi nagini igiꞌeteꞌe igihi rae reiro, rehano mene igiro.” ");
INSERT INTO ksj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mada ꞌahogano Mose goro ḡoeꞌa ihozeꞌeteꞌe vazeḡa ꞌahoganiꞌa iḡunadu Iesu tuhune nuroga veize ḡadiniro, “Ihore vazeḡa, e nougine, ḡabone tuḡutuḡu hidiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Iesuꞌa niro, “Mose goro ḡoeꞌanoꞌe nouge rae mirihiro? Ḡa nougenouge meꞌode horoneꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Aniꞌa naenaeniro, “Mose goro ḡoeꞌano ꞌahige raꞌohe, 'Zamaḡo niduꞌa hina, vineḡo niduꞌa hina, inaraḡo niduꞌa hina zu zamaroneḡo niduꞌa hina ḡae Badiꞌa Zuhiꞌa Boro zamare borofoꞌi,' ebu 'Ḡa ḡae bare zamare borofeꞌeteꞌe teige, nabugo zamare borofoꞌi.'” ");
INSERT INTO ksj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ebu Iesuꞌa niro, “Ḡae naenaeꞌe duduḡa. Ḡa ꞌouge haḡaine, ḡabone tuḡutuḡu hidiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Rehano ani Iesuꞌa ani mazao duduḡa rae rouga uratadu bare ḡadiniro, “Iniuꞌe eḡe nabudi?” ");
INSERT INTO ksj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iesuꞌa ꞌahige naenaeniro, “Vaze ꞌahoganiꞌa Ierusalemaonoꞌo Ieriko ovoinu. Ebu ibio aniꞌe ḡonore azaḡa hidiro. Ze dabuaḡa fuhiꞌadu ḡauḡa niduꞌa meiro, zu bounadu nariga mau runiro, ebu eꞌea bazune mode feraro. ");
INSERT INTO ksj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Eꞌe madaḡano dibuꞌo vazeḡa ꞌahoganiꞌa eꞌe ibiḡano ovoiro. Ebu vaze eꞌe horonirotene, ibi genaḡano vitau onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Eꞌe teige, Levi mariga vazeḡa ꞌahoga zuni eꞌe ibiḡano ovoadu vaze eꞌe horoniro, rehano ane zuni ibi genaḡano vitau onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Rehano Samaria vazeḡa ꞌahogaꞌe ragave onameꞌeteꞌea, eꞌe ibiḡano ovoadu vaze eꞌe horoniro ebu vetuḡani runiro. ");
INSERT INTO ksj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ebu ane vaḡe onamadu dehoro zu vaini vuḡa hina idiriḡa rana beuꞌadu ꞌumiro. Ebu ane doniki rana mae ohonadu iꞌudo neḡa tutune onamiro, zu eꞌea ani taufe radiro. ");
INSERT INTO ksj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Irarirotene, aniꞌa hadi nu madu iꞌudo neḡa vazeḡa hanadu niro, 'Ani taufe radoꞌi. Hadi ꞌahiꞌe mene idaḡa roꞌidene, eḡeꞌa baradu bare ḡaniꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Iesuꞌa eꞌe hariḡa hauḡirotene, Mose goro ḡoeꞌa ihozeꞌeteꞌe vazeḡa ḡadiniro, “Vaze uḡidu ꞌadi boꞌaḡano ḡae zamaroneꞌe iniuꞌe ḡonore azaḡa hidiroteꞌe vazeḡa nabuga?” ");
INSERT INTO ksj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Aniꞌa naenaeniro, “Ani vetuḡaneadu dananiroteꞌe vazeḡa.” Iesuꞌa niro, “Ḡa zuni onamadu ꞌouge haḡaoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Iesu zu ane tahiꞌatahiꞌaꞌa ragave onamadu ne ꞌahogano feuriro. Ebu roḡae ꞌahoga, niḡa Maretaꞌa neḡano Iesu mae zouniro. ");
INSERT INTO ksj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Maretaꞌe negoḡeta zu niḡaꞌe Maria. Mariaꞌe Zuhiꞌa Boro oda babaḡano ehoradu nagini reiroteꞌe igi radiro. ");
INSERT INTO ksj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","U Maretaꞌe vaze ḡubuzoga veize gau ḡehaḡa haḡainuteꞌe uꞌano zamaḡaniꞌa adudaro. Eꞌanoꞌo ani Iesu vaḡe aradu niro, “Zuhiꞌa Boro, negoheꞌa eḡe daꞌo gaueꞌeteꞌe horohe tauḡeꞌohe. Ḡa eꞌe mene zamareꞌehe? Ani e danahoga veize noꞌi!” ");
INSERT INTO ksj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Zuhiꞌa Boroꞌa naenaeniro, “Mareta, Mareta, ḡaꞌe gau ḡehaḡa uꞌano zamaḡoꞌe aduduꞌohe zu maḡuneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Rehano gau boroꞌe tiba daꞌo, ebu Mariaꞌa gau eꞌe ohotiro. Eꞌanoꞌo vazeni ꞌahoga aniꞌa ꞌouge haḡaeꞌeteꞌe mene garariꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mada ꞌahogano Iesuꞌe haba ꞌahogano kurau radiro. Kuru hauḡirotene, ane tahiꞌa ꞌahoganiꞌa niro, “Zuhiꞌa Boro, Ioane Babatisoꞌa ane tahiꞌatahiꞌa kuru ihoziroteꞌe teige, emeḡe zuni kuru ihofoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Iesuꞌa ziro, “Zaꞌe kuranoꞌidene, ꞌahige kuranoꞌi: 'Mama, eme umiꞌeꞌohe, ḡae niꞌe zaḡoḡa reꞌuma, ebu ḡaeꞌa ḡau niduꞌa zuhiꞌaziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mada niduꞌa emeḡeꞌa atiteꞌe ogomuḡa rifiꞌenoꞌi, ");
INSERT INTO ksj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ebu emeꞌa emeḡe mazao sauꞌa haḡairoteꞌe azaḡa niduꞌa haḡaize sauꞌa rae modeꞌeteꞌe teige, emeḡe haḡai sauꞌa rae modoꞌi. Ebu eme haḡai sauꞌa haḡaihi raꞌeteꞌe zamaroneḡanonoꞌo mae tutufe vaḡifoꞌi.'” ");
INSERT INTO ksj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ebu Iesuꞌa ziro, “Hari idaidaḡa ꞌahi zamaroꞌi. Zae boꞌaḡano vaze ꞌahogaꞌe nabudiḡeta. Ohe nema ꞌahogano nabuganiꞌa ane vaze ne onamadu uminiro, 'Eḡe vaze, ꞌuvahu odoga uḡidu enoꞌi, ");
INSERT INTO ksj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","mazaḡa eḡe vaze ꞌahoganiꞌa ragaveꞌeteꞌea iziduꞌu eḡe vaḡe areha, rehano e hatiteꞌe ogomuḡa oꞌoꞌa.' ");
INSERT INTO ksj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ebu ne vazeḡaniꞌa naenaeniro, 'Zamahe ago adudunoꞌi. Ibiheta ꞌai bireha, ebu e eḡe tahiꞌatahiꞌa teite bazeꞌe ꞌahine, iḡunadu ḡau ꞌahoga ḡanogaꞌe mene idaḡa.'” Ebu Iesuꞌa ane tahiꞌatahiꞌa ḡadiziro, “Za zuni ꞌouge naenaeniꞌumahe? ");
INSERT INTO ksj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Eḡeꞌa ziꞌohe, aniꞌe nabuga veize daꞌoꞌe iḡunadu ꞌuvahu odoga mene haꞌuma, rehano nabuganiꞌa barebare umineꞌeteꞌe uꞌano, iḡunadu umideꞌeteꞌe ḡauḡa haꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Eꞌanoꞌo eḡeꞌa ziꞌohe, uminoꞌi, ꞌougine ziniꞌuma. Vaḡoꞌi, ꞌougine horoniꞌuma. Ibiheta toketokeroꞌi, ꞌougine ibiheta vavaoziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Umineꞌeteꞌe azaḡa niduꞌa ziniꞌuma, vaḡeꞌeteꞌe azaḡa niduꞌa horoniꞌuma, ebu ibiheta toketokereꞌeteꞌe azaḡa niduꞌa ibiheta vavaoziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Zae boꞌaḡano iniu ubuganiꞌa ḡozone umidine, moganiꞌa ḡozone mene hanadu mohe haꞌumahe? ");
INSERT INTO ksj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ebu ubuganiꞌa kokoroku maḡa umidine, moganiꞌa asiasi haꞌumahe? ");
INSERT INTO ksj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Zaꞌe sauꞌa azaḡa rehano, ḡahunone manoḡa ubudeze zenoga urateꞌohe. Eꞌe teige, zae Moze adureo radiuꞌetaꞌaꞌe ane mazao umideꞌeteꞌe azaḡa hube hune Vine Zaḡoḡa ziniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Mada ꞌahogano Iesuꞌa mumutafa vazeḡa ꞌahoga mazaonoꞌo vine sauꞌa hegone buniro. Vine sauꞌaniꞌa ani mode buarotene, mumutafa vazeḡaniꞌa bare ḡoeriro ebu vaze ḡuḡuvaḡaniꞌa zaguzagaro. ");
INSERT INTO ksj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Rehano vaze nuꞌa ꞌahige rae reiro, “Iesuꞌa vine sauꞌasauꞌa zuhiꞌaḡa, Belezebulo inaraḡa hina vine sauꞌasauꞌa hegoze buzeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","U nuꞌe Iesu tuhune nurihi radu uminiro, “Badiꞌa gigiꞌaḡa hina haḡai nu badeḡa haḡaoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Rehano Iesuꞌa ze nouge rae zamarirotaꞌaꞌe ederadu ziro, “Haba tiba zamaḡano zeḡeꞌa rovotadu utitine, eꞌe habaꞌaꞌe aneꞌa bare ruiniꞌuma. Ebu ne tiba zamaḡano zeḡeꞌa rovotadu utitine, ne eꞌe aneꞌa bare higaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Sataniꞌe aneꞌa bare rovonadu ane zamaḡano utitine, aneꞌa zuhiꞌaziꞌeteꞌe habaꞌaꞌe nougenouge edau gigaraꞌuma? Zaꞌe eḡeꞌa Belezebulo inaraḡa hina vine sauꞌa hegone buneꞌohe rae raꞌohe, rehano ꞌougine ani aneꞌa bare ruiniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Eḡeꞌa Belezebulo inaraḡa hina vine sauꞌa hegoze buzifone, zae tahiꞌatahiꞌaꞌe iniu inara hina vine sauꞌa hegoze buzifo? Zae tahiꞌatahiꞌaꞌe zeḡeꞌa bare zaꞌe veꞌoḡa rae reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Rehano eḡeꞌa vine sauꞌaꞌe Badiꞌa inaraḡa hina hegoze buzine, Badiꞌaꞌa amahi zae zuhiꞌazi radiuꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Inara vazeḡaniꞌa uti ḡauḡa nunu hina neḡa taufine, ḡauḡa niduꞌaꞌe manoḡa radiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Rehano inara ufeta boro vazeḡaniꞌa arine, inara vazeḡa utite raharahaniꞌuma. Inara vazeḡaꞌe uti ḡauḡaniꞌa ani biriꞌuma rae zamariꞌuma. Rehano inara ufeta boro vazeḡaniꞌa inara vazeḡa uti ḡauḡa meiniꞌuma ebu ani ne ḡau niduꞌa zuni meinadu ḡahuge ḡuzuhiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Iniu eḡe teite mene reine, aniꞌe eḡe agirohiꞌeteꞌe vazeḡa. Ebu iniu eḡe teite Badiꞌa veize vaze mene nuꞌozine, ani Badiꞌa mazaonoꞌo vaze rovozeꞌeteꞌe vazeḡa.” ");
INSERT INTO ksj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ebu Iesuꞌa ziro, “Vine sauꞌa ꞌahoganiꞌa vaze ꞌahoga mazaonoꞌo buauꞌetene, ahiꞌa ohonoga radu vu oꞌoꞌa habaꞌa vaḡe ragaveꞌohe. Rehano mene horoneꞌetene, ani ꞌahige rae raꞌohe, 'Eḡeꞌa ibite radiroteꞌe neḡa bare onamihi.' ");
INSERT INTO ksj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ebu ani baradu vaze eꞌe horoneꞌetene, aniꞌe neḡa deheḡa hune zu idaidane touga heuḡa. ");
INSERT INTO ksj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ebu vine sauꞌa eꞌeꞌa onamadu vine sauꞌa niduꞌa fuꞌo aheu fare, ufeta hune sauꞌa zamaze areꞌohe, ebu ze vaze eꞌe zamaḡano diuḡe radiuꞌohe. ꞌOugadu vaze eꞌeꞌa mada ibiꞌa vitine ufeta sautuꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iesuꞌa ḡoere eꞌe raꞌeteꞌea, vaze ḡuḡuvaḡa boꞌaḡano roḡae ꞌahoganiꞌa agoḡa boro hina Iesu niro, “Ḡa fureꞌiroteꞌe zu ḡubuꞌe borofiroteꞌe roḡaeḡaniꞌa matuꞌe rudauꞌohe!” ");
INSERT INTO ksj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Rehano Iesuꞌa naenaeniro, “Badiꞌa ḡoere egohauꞌeteꞌe azaḡaniꞌa matuꞌe rudauꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Iesu vaḡe ariroteꞌe azaḡaꞌe ufeta ḡehararotene, Iesuꞌa ziro, “Izidi egaꞌe sauꞌa, ebu ze haḡai nu badeḡa umideꞌohe. Rehano Iona mazao fureraroteꞌe haḡai nu badeḡa daꞌo furenoziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Iona mazao naginiꞌa furerarotaꞌaꞌe Nineva azaḡa mazao haḡai nu badeḡa reiro. Eꞌe teige, Vaze Ubuga mazao naginiꞌa fureratitaꞌaꞌe izidi ega mazao haḡai nu badeḡa reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Badiꞌa kota madaḡano Siba habaꞌa kini roḡaeḡaniꞌa izidi ega azaḡa teite iḡune edanadu zeꞌe veꞌoḡa rae roziꞌuma. Mazaḡa ibite madaḡano Siba habaꞌa kini roḡaeḡaniꞌa haba ḡonaga faḡa huneonoꞌo kini Solomona zamarone huhuzaḡa abitoga veize onamiro. U izidi Solomona vitinoga vazeḡaꞌe ꞌahi eꞌe, rehano ze ane ḡoere abitoga mene urateꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Badiꞌa kota madaḡano Nineva azaḡaniꞌa izidi ega azaḡa teite iḡune edanadu zeꞌe veꞌoḡa rae roziꞌuma. Mazaḡa ibite madaḡano Nineva azaḡaꞌe Iona haramo abitadu haḡaize sauꞌanonoꞌo ḡihure ḡouriro. Izidi Iona vitinoga vazeḡaꞌe ꞌahi eꞌe, rehano ze ane ḡoere mene abitadu mene ḡihureꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ebu Iesuꞌa ziro, “Vaze ꞌahoganiꞌa ihure hofadu mene ꞌuꞌuru tiꞌe ga siuva hina mene ogone tiꞌohe. Rehano ne diuḡeꞌeteꞌe azaḡaniꞌa agaḡa horonoga veize ihure odaḡa rana tiꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Zae ubumaꞌe ahirize ihureḡa. Ubumazeꞌe manoḡa reine, ahirizeꞌe agaḡaniꞌa iriꞌavoniꞌuma. Rehano ubumazeꞌe sauꞌa reine, ahirizeꞌe uzaboꞌa iriꞌavoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Eꞌanoꞌo zae zamao agaḡaꞌe uzabo ga meneꞌe faine ḡianoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Zae ahiriꞌe agaḡaniꞌa iriꞌavonadu uzabo ꞌahoga oꞌoꞌa reine, ihure agaḡaniꞌa zae rana agaruꞌeteꞌe teige, ahirize niduꞌaꞌe agaḡaniꞌa iriꞌavoniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iesuꞌa ḡoere hauḡirotene, Farisea vazeḡa ꞌahoganiꞌa ane teite oganoga uminiro. Ebu Iesuꞌa ani ne onamadu ogomu fataḡa uhiḡano ehoriro. ");
INSERT INTO ksj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ebu Farisea vazeḡaꞌe Iesuꞌa ꞌizema oganogano ꞌevoꞌa mene vuzuꞌiroteꞌe horonirotene zaguzagaro. ");
INSERT INTO ksj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ebu Zuhiꞌa Boroꞌa Farisea vazeḡa eꞌe niro, “Farisea azaḡa, izidi zaꞌe bioze zu siuvaze enoga daꞌo vuzuꞌe deheneꞌohe. Rehano zamazeoꞌe ununu zu sauꞌaniꞌa iriꞌaveꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Zaꞌe mene huhuzaḡa! Badiꞌaꞌa enone daꞌo mene haḡairo, rehano zama zuni haḡairo. ");
INSERT INTO ksj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Eꞌanoꞌo ḡauze zahara azaḡa zenoꞌi, ꞌougine zae enone zu zama niduꞌaꞌe Badiꞌa ubumao deheḡa hune reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Farisea azaḡa, za aduga boro hidiꞌuma! Mazaḡa zaꞌe tirara mebaḡano eḡa zu murari teige komeꞌa fase ogomuḡa niduꞌaonoꞌo sinu gaubananao rovonadu sinu tiba ḡauḡa Badiꞌa hauꞌohe. Rehano haḡai duduḡa haḡaoga zu Badiꞌa zamare borofogaꞌe igi modeꞌohe. Za ḡau boro ꞌadiꞌe haḡaifo ebu komeꞌakomeꞌa zuni mene igi modifo. ");
INSERT INTO ksj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Farisea azaḡa, zaꞌe aduga boro hidiꞌuma! Mazaḡa zaꞌe nu'onu'o neḡano vaze boroboroꞌa ehoreꞌeteꞌe habaꞌano ehoroga urateꞌohe, zu vaze ḡehaḡa habaꞌano ze zae gubazeꞌenaꞌa, zae mazao unihoga urateꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Zaꞌe aduga boro hidiꞌuma! Mazaḡa zaꞌe rune iduḡa ꞌuꞌuruḡa heuḡa. Rune ahiꞌaꞌe idu zamaḡano ruhuḡa rehano, vazeꞌa mene ederadu eꞌe rana oname onaeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mose goro ḡoeꞌa ihozeꞌeteꞌe vazeḡa ꞌahoganiꞌa Iesu niro, “Ihore vazeḡa, ḡa ꞌouge ḡoereꞌetene, emeḡe zuni rae sausaufeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Iesuꞌa naenaeniro, “Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa, zae zuni aduga boro hidiꞌuma! Mazaḡa zaꞌe ihore riga hune hina vaze aduga boro ziniꞌohe, rehano zae ꞌevore huduꞌa tiba hina zu mene hune danazeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Zaꞌe aduga boro hidiꞌuma! Mazaḡa vouḡazeꞌa ibite zimiroteꞌe peroveta azaḡa rune iduḡa zaeꞌa ogoruꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Vouḡazeꞌa peroveta azaḡa zimiro ebu zaeꞌa iduze ogoruꞌohe. ꞌOugadu za vouḡazeꞌa haḡai duduḡa haḡairo rae fureneꞌohe zu ihozeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Eꞌanoꞌo Badiꞌa huhuzaḡaniꞌa ꞌahige rae reiro, 'Eḡeꞌa peroveta azaḡa zu apostolo azaḡa nu zeḡe mazao tuḡuziꞌuma, rehano ze nuꞌe zimiꞌuma zu nuꞌe sausauziꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Badiꞌaꞌa raha ꞌadi haḡairoteꞌe madaḡanonoꞌo peroveta azaḡa zimiro. Eꞌanoꞌo eꞌe aduga niduꞌaꞌe izidi eganiꞌa odohiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ze ibite Abela mau runiroteꞌeanoꞌo onao ḡonagano Zekaria maro. Zekariaꞌe dibuꞌo fataḡa zu kuru neḡano Haba Zaḡoḡa boꞌaḡano mau runiro. Oꞌe, eḡeꞌa hube hune ziꞌohe, eꞌe aduga niduꞌaꞌe izidi eganiꞌa odohiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa, zaꞌe aduga boro hidiꞌuma! Mazaḡa Badiꞌa edereꞌeteꞌe ibiḡa ibihetaḡa vavaꞌeꞌeteꞌe kiḡaꞌe zaeꞌa meiniro. Rehano za mene diuḡiro ebu diuḡihi raꞌeteꞌe azaḡa zuni zaeꞌa garariro.” ");
INSERT INTO ksj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Iesuꞌe ḡoere hauḡadu ne beꞌanoꞌo buarotene, Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zu Farisea azaḡaniꞌa ani riḡa agiroharo ebu ḡadimu ḡehaḡa hina aduaduniro. ");
INSERT INTO ksj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Mazaḡa Iesuꞌa ḡoere nu rae veꞌonine, ani obone tihi rae reiro. ");
INSERT INTO ksj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Eꞌe madaḡano vaze ḡuḡuvaḡaniꞌa nuꞌoraro ꞌahine, nariga odaze rana edaro. Ebu Iesuꞌa ane tahiꞌatahiꞌa ibite ziro, “Zaꞌe Farisea azaḡa ḡiazoꞌi, mazaḡa zeꞌe zama guhi azaḡa ebu isiti heuḡa. ");
INSERT INTO ksj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Rehano ꞌuꞌuru radiroteꞌe ḡauḡa niduꞌa fureraꞌuma, ebu ogone ḡahiniroteꞌe ḡauḡa zuni ederiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Eꞌanoꞌo zaꞌa uzabo zamaḡano nagini sifu reiroteꞌe ḡoeꞌaꞌe vazeꞌa mada agaḡano igiꞌuma. Ebu zaꞌe bazuni neḡa zamaḡano nagini gumude reiroteꞌe ḡoeꞌa vazeꞌa ne binuḡa hitaganonoꞌo rae fureniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Eḡe nego nabudi, eḡeꞌa hube hune ziꞌohe. Ahiri mauꞌeteꞌe azaḡa ago rihozoꞌi, mazaḡa zeꞌe vine sausaunogaꞌe mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","U za iniu rihoniteꞌe eḡeꞌa ihoziꞌuma. Aniꞌe vaze manadu ire roga radiu tuḡutuḡu zamaḡano mae feuzeꞌeteꞌe gigiꞌaḡa obone tiꞌohe. Ani rihonoꞌi. Hube hune eḡeꞌa ziꞌohe, ani daꞌo rihonoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Tiburi niniḡa fuꞌo hadi komeꞌa hina seroneꞌohe. Rehano Badiꞌaꞌa zeḡe boꞌaḡano tiba zuni mene aḡutu modeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Badiꞌaꞌa zae zamare borofadu vadinize iguḡa niduꞌa nugu zuni edeḡa. Eꞌano'o ago rihanoꞌi, mazaḡa zaꞌe Badiꞌa ubumao tiburi niniḡa ḡehaḡa ufeta vitize ḡihiꞌaḡa. ");
INSERT INTO ksj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Eḡeꞌa ziꞌohe, iniuꞌa vaze ubumao eḡe moneo edaune, Vaze Ubuga zuni Badiꞌa tuḡure viga niduꞌa ubumao ani moneo edaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Rehano iniuꞌa vaze ubumao eḡe oꞌohine, eḡe zuni Badiꞌa tuḡure viga niduꞌa ubumao ani oꞌoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Iniuꞌa Vaze Ubuga agirohauꞌenaꞌa rae sausaunine, Badiꞌaꞌa ane haḡai sauꞌa rae modiꞌuma, rehano iniuꞌa Vine Zaḡoḡa agirohauꞌenaꞌa rae sausaunine, ane haḡai sauꞌaꞌe mene rae modiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Eḡe uꞌano, zaꞌe kotao tutuze onamadu nu'onu'o neḡano zuhiꞌaḡazuhiꞌaḡa zu inarazeta azaḡa zamao ohozoꞌidene, nougenouge zae bare biriteꞌe ga nagini rae ḡoeriteꞌe moneo zamaze ago adudanoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mazaḡa eꞌe madaḡano zaeꞌa nouge rae ḡoeriteꞌe moneo Vine Zaḡoḡaniꞌa ihoziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Vaze ꞌahoganiꞌa vaze ḡuḡuvaḡa boꞌaḡano Iesu niro, “Ihore vazeḡa, mamafeꞌa mode rudaroteꞌe toheḡa nu rovonadu naeḡa eḡe enoga veize negohe noꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Iesuꞌa naenaeniro, “Nego, vazeni ꞌahoganiꞌa toheze ḡahugeꞌeteꞌe gauḡa veize e mene ohohiro.” ");
INSERT INTO ksj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ebu Iesuꞌa ziro, “Za ununu haḡaiḡa mene haḡaifine, zamaze obone giganoꞌi! Mazaḡa vazeꞌa tohe ḡehaḡaonoꞌo ḡabone mene hideꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ebu hari ꞌahoga idane ziro, “Maꞌora vazeḡa ꞌahoganiꞌa mebaḡano ogomu manomano hiriviro. ");
INSERT INTO ksj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ebu ani aneꞌa bare zamariro, 'E ogomuhe godoḡo neḡaꞌe oꞌoꞌa. E nougiꞌuma?' ");
INSERT INTO ksj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ebu ani raenaꞌa, 'E ꞌahige haḡaine manoḡa! Ogomu godoḡo neḡa amahiḡaꞌe fahadu boro iziga ogoraꞌuma ebu ogomuhe zu tohehe niduꞌa eꞌea zouniꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ebu ani aneꞌa bare raenaꞌa, ꞌE muri faḡa radoga veize ogomu boro hune ruhibe teha. Eꞌanoꞌo eꞌe ogauꞌenaꞌa zu gageꞌenaꞌa matuꞌe onamiꞌuma!' ");
INSERT INTO ksj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Rehano Badiꞌaꞌa niro, 'Ḡaꞌe mene huhuzaḡa. Eḡeꞌa izidi ohere ḡae ḡabone mae vaḡinine, ḡa ruhibateꞌe toheḡa'e iniuꞌa meꞌuma?'” ");
INSERT INTO ksj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Iesuꞌa ḡonagano ḡoeriro, “ꞌUguḡa vazeḡaꞌe ane tohe daꞌo nuꞌoneꞌeteꞌe vazeḡa, rehano Badiꞌa ubumao aniꞌe mene maꞌora vazeḡa.” ");
INSERT INTO ksj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ebu Iesuꞌa ane tahiꞌatahiꞌa ziro, “Eꞌanoꞌo eḡeꞌa ziꞌohe, zae ḡabone veize nagi ogomu aꞌuma, ga ahirize veize nagi dabua vidaꞌuma rae ago zamare adudanoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mazaḡa ḡaboneꞌe ogomu vitinoga, zu ahiriꞌe dabua vitinoga. ");
INSERT INTO ksj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nugo gaoza zamaroꞌi. Ze ezone mene ḡorauꞌohe, mene hiriveꞌohe, ebu ogomu godoḡo neḡa zu oꞌoꞌa. Rehano Badiꞌaꞌa ḡubuzeꞌohe. Zaꞌe nini vitize hunoga. ");
INSERT INTO ksj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Zae boꞌaḡano iniuꞌa zamare adudu radiune, ḡaboneḡaꞌe tahiḡa nu faraꞌumahe? ");
INSERT INTO ksj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Zaꞌe ḡau komeꞌa ꞌahoga haḡaoga zuni mene idaḡa. Nougadu ḡau ꞌahogaꞌahoga veize zamare aduduꞌohe? ");
INSERT INTO ksj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Butu kakaḡaꞌe nougenouge ḡuhureꞌeteꞌe zamaroꞌi. Ze mene gaueꞌohe ga dabuaze mene turineꞌohe. Rehano eḡeꞌa ziꞌohe, butu kakaḡa ꞌahoga zuni maꞌora vazeḡa kini Solomonaꞌa haḡairoteꞌe dabuaḡa manomano vitine hunoga. ");
INSERT INTO ksj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ebu butu veḡaꞌe izidi ḡaboga, u ohoḡoreꞌe masinadu ireo hufi haoniꞌuma. Rehano Badiꞌaꞌa dabua vidohauꞌohe. Zaꞌe ve vitinoga, eꞌanoꞌo Badiꞌaꞌa dabua manoḡa ufeta vidoziniꞌuma. Rehano zaꞌa Badiꞌa mazao fieꞌetaꞌaꞌe tahiḡa fase! ");
INSERT INTO ksj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Eꞌanoꞌo zaꞌe nagini aꞌuma ga nagini gagiꞌuma rae ago ufeta zamaroꞌi, zu zamaze ago adudanoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mazaḡa Badiꞌa aḡuꞌa azaḡaniꞌa eꞌeguḡa niduꞌa vaḡe inareꞌohe, rehano Mozeꞌe zaeꞌa eꞌeguḡa urateꞌeteꞌe edereꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Badiꞌaꞌa zuhiꞌazoga vaḡoꞌi, ꞌougine eꞌeguḡa niduꞌa zuni ziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Mamoe komeꞌakomeꞌa, za ago rihanoꞌi, mazaḡa zae Mamaꞌa za zuhiꞌaziꞌeteꞌe uꞌano matuꞌe rudauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ebu toheze seronadu hadiḡaꞌe zahara azaḡa zenoꞌi. Zae veize mene zigatiteꞌe hadi fuseḡa haḡaoꞌi, zu mene hauḡiteꞌe toheḡa adureo nuꞌone toꞌi. Eꞌea ḡonoreꞌa mene areꞌohe ebu zuhiꞌa mene sausauneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mazaḡa za ḡauze naeḡa boro nouma tine, zamaroneze zuni eꞌea tiꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Iesuꞌa ziro, “Zaꞌe gau dabuaḡa haḡadu ruhibe radoꞌi, ebu ihureze agane modoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Zuhiꞌazeꞌa hahu muiḡanonoꞌo baradu ibihetao toketokerine, ibiheta ḡarihe vavaꞌoga veize guhineꞌeteꞌe azaḡa teigoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Zuhiꞌazeꞌa baradu ane tuḡure azaḡaniꞌa ani guhine radiuꞌeteꞌe horozine, ane tuḡure azaḡaniꞌa matuꞌe rudaꞌuma. Eḡeꞌa hube hune ziꞌohe, zuhiꞌazeꞌa gau dabuaḡa vidanadu ogauꞌeteꞌe fataḡa uhiḡano ane tuḡure azaḡa ohoziꞌuma, ebu zeḡe babaḡano edauꞌenaꞌa, ogomu ḡahugiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ebu zuhiꞌazeꞌa ohere ga uzeuze feuradu tuḡure azaḡaniꞌa ani guhine radiuꞌeteꞌe horozine, ani tuḡure azaḡaniꞌa matuꞌe rudaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Rehano za ꞌadi zamaroꞌi. Ne vazeḡaniꞌa ḡonore vazeḡaꞌe noꞌe madaḡano ani ne aritaꞌaꞌe ederifone, ḡonore vazeḡaniꞌa mene diuḡoga veize ani neḡa faine taufifo. ");
INSERT INTO ksj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Eꞌe teige, zae zuni ruhibe radoꞌi, mazaḡa Vaze Ubugaꞌe za mene edereꞌeteꞌe madaḡano ariꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ebu Peteroꞌa niro, “Zuhiꞌa Boro, ḡaeꞌa hari idaidaḡa ꞌadiꞌe emeḡe daꞌo veize ga vaze niduꞌa veize zuni?” ");
INSERT INTO ksj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Zuhiꞌa Boroꞌa naenaeniro, “Iniuꞌe vaze huhuzaḡa zu zamaḡa niduꞌa hina gaueꞌeteꞌe vazeḡa? Tuḡure vazeḡa ꞌahogaꞌe vaze ꞌuguḡa reine, zuhiꞌaḡaniꞌa aniꞌe tuḡure vazeḡa ḡihiꞌaḡano mae ohonadu ꞌahige niꞌuma, 'Ḡa tuḡure azaḡa niduꞌa taufoꞌi. Ogomuze zuni mada idunane zenoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ebu tuḡure vazeḡa eꞌeꞌa ꞌouge gauine ebu zuhiꞌaḡaniꞌa bare feuradu horonine, tuḡure vazeḡa aꞌe matuꞌe rudaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Eḡeꞌa hube hune ziꞌohe, aniꞌe zuhiꞌaḡaniꞌa ane tohe niduꞌa taufeꞌeteꞌe vazeḡano ohoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Rehano tuḡure vazeḡa aꞌe aneꞌa bare raenaꞌa, 'Eḡe zuhiꞌaꞌe vesuꞌu faḡanobuꞌu ariꞌuma,' rae zamaradu ohoze tuḡure azaḡa zu roḡae tuḡure azaḡa niduꞌa bouzine zu ufeta ogau gage baboraune, nougiꞌuma? ");
INSERT INTO ksj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Aniꞌa mene zamareꞌeteꞌe zu mene edereꞌeteꞌe madaḡano zuhiꞌaḡaniꞌa bare aradu ane ahiri variꞌe tahitahiꞌuma, ebu zama niduꞌa hina mene gaueꞌeteꞌe azaḡa habaꞌano ohonadu aduga boro haꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tuḡure vazeḡaꞌe ane zuhiꞌaꞌa nagini urateꞌetaꞌaꞌe edereꞌe rehano, mene ruhibine zu mene haḡaine, aniꞌe boune sausauniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","U tuḡure vazeḡaꞌe ane zuhiꞌa ura mene ederadu veꞌoḡa haḡaine, aniꞌe tahiḡa boune tauḡiꞌuma. Iniuꞌe Badiꞌa mazaonoꞌo ḡehaḡa hidine, Badiꞌaꞌe ani mazaonoꞌo ḡehaḡa mouga urateꞌohe. Ebu iniuꞌe Badiꞌaꞌa ane gau boro haune, Badiꞌaꞌe ani mazaonoꞌo ḡehaḡa umideꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Iesuꞌa bare ziro, “Eḡeꞌa raha ꞌadi hofoga radu ire roga mae ariro. Ire rogaꞌa amahi raha ꞌadi iri radiune, e matuꞌe rudaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Rehano e aduga hiditeꞌe babatisoḡa meꞌuma, zu zamaheꞌe adudaꞌuma onamo ḡonaga meꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Zaꞌe eḡeꞌa raha ꞌada uniho manoḡa mae ovairo rae zamareꞌehe? Mene. Eḡeꞌa ziꞌohe, e vaze rovoze ḡuzuhoga veize ovairo. ");
INSERT INTO ksj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Izidionoꞌo onamo zama moneo eḡe uꞌano ne azaḡaꞌe rovotiꞌuma. Ne eꞌe azaḡaꞌe fuꞌo reine, zeḡe boꞌaḡano rovotadu uḡiduꞌa aheu teite agirotitiꞌuma, ga aheuꞌa uḡidu teite agirotitiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Moganiꞌa ubuga teite agirotitiꞌuma, ga ubuganiꞌa moga teite agirotitiꞌuma. Viꞌaniꞌa aboḡa teite agirotitiꞌuma, ga aboḡaniꞌa viꞌa teite agirotitiꞌuma. Viꞌaniꞌa ubuga inuga teite agirotitiꞌuma, ga ubuga inuganiꞌa iꞌa viꞌa teite agirotitiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iesuꞌa vaze ḡuḡuvaḡa ziro, “Zaꞌe ḡozeꞌa ḡutanoga horoneꞌetene, zogone ꞌahige raꞌohe, 'Iruguꞌa ruꞌaꞌuma.' A hube, iruguꞌa ruꞌauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ebu ohere ḡozeꞌa bororanadu nahuduꞌetene, zaꞌa raenaꞌa, 'Madaꞌa hiaꞌuma.' A hube, madaꞌa hiauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Zama guhi azaḡa! Zaꞌe adure zu raha iraḡa horoneꞌetene, naginiꞌa fureratitaꞌaꞌe edereꞌohe. Rehano izidi madaḡano naginiꞌa fureru radiuꞌeteꞌe moneo huga eꞌe mene edereꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Za nougadu zaeꞌa bare naginiꞌe duduḡa rae mene edereꞌohe? ");
INSERT INTO ksj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ḡaꞌe vaze ꞌahoga hadiḡa meiroteꞌe uꞌano aniꞌa kotao ohoꞌihi radu ani teite onamoꞌidene, ibio uniho manofoga veize inare hunoꞌi. Mene ꞌougine, aniꞌa oboꞌe teadu kota vazeḡa mazao tutuꞌe onamiꞌuma, ebu hena kota vazeḡaniꞌa ḡuꞌa neḡa taufeꞌeteꞌe vazeḡa ꞌevoreo ohoꞌadu ḡuꞌa neḡano ohoꞌiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Eḡeꞌa ziꞌohe, za ḡuꞌa neḡanonoꞌo mene buaꞌuma, onamo zaeꞌa ani hadi niduꞌaꞌe baroniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Eꞌe madaḡano Iesu teite radiroteꞌe azaḡa nuꞌa Iesu niro, “Galilea azaḡa nuꞌa Badiꞌa dibuꞌohauꞌeteꞌe zamaḡano Pilatoꞌa zemeha.” ");
INSERT INTO ksj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Iesuꞌa naenaeziro, “Zae zamarone, zeḡe haḡai sauꞌaꞌe Galilea azaḡa ꞌomo haḡaize sauꞌa roꞌanoga ꞌahine, ꞌouge rudaneha rae raꞌehe? ");
INSERT INTO ksj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mene. Eḡeꞌa ziꞌohe, zae zuni zae haḡai sauꞌanonoꞌo mene ḡihurine, zeḡe teige zae niduꞌa rudaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ebu za edeḡa, Siloama habaꞌano ne hitaganiꞌa fahanadu vaze niduꞌa 18 rudaro. Zae zamarone, zeḡe haḡai sauꞌaꞌe Ierusalema azaḡa niduꞌa haḡaize sauꞌa roꞌanoga rae raꞌehe? ");
INSERT INTO ksj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mene. Eḡeꞌa ziꞌohe, zae zuni zae haḡai sauꞌanonoꞌo mene ḡihurine, zeḡe teige zae niduꞌa rudaꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ebu Iesuꞌa hari ꞌahoga idaniro, “Vaze ꞌahoganiꞌa vaini mebaḡano figi ireḡa ḡoraro. Eꞌe enogano aniꞌa huga nu reꞌoga veize onamiro, rehano huga ꞌahoga mene horoniro. ");
INSERT INTO ksj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Eꞌanoꞌo aniꞌa meba ḡianeꞌeteꞌe vazeḡa niro, 'E muri uḡidu zamaḡano huga reꞌoga veize arido, rehano hugani ꞌahoga mene horonido. Eꞌanoꞌo udi higanoꞌi! Nougaꞌahi haba daꞌo iriꞌavone tauḡiꞌohe?' ");
INSERT INTO ksj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ebu meba ḡianeꞌeteꞌe vazeḡaniꞌa naenaeniro, 'Vaze boro, ge muri tiba daꞌo bare modoꞌi. Eḡeꞌa ire varahe hoꞌadu mazaḡano busi mumuḡa teadu ḡianiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ꞌOugine, muri tiba enogano manoḡa hudaꞌuma. Mene hudanoꞌidene, udi higonoꞌi.'” ");
INSERT INTO ksj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Bana Madaḡa ꞌahogano Iesuꞌe nu'onu'o neḡano ihoze radiunu. ");
INSERT INTO ksj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ebu eꞌea roḡae ꞌahoganiꞌa radiunu. Vine sauꞌaniꞌa ani ragano radu ḡaruga mae beꞌoniro ꞌahine, aniꞌe muri 18 mene edau faraunu. ");
INSERT INTO ksj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Iesuꞌa ani horonirotene, ane vaḡe aroga veize hunadu niro, “Roḡae, ḡae ugi ꞌai manoreha.” ");
INSERT INTO ksj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ebu Iesuꞌa ꞌevoꞌa ane rana tirotene, ani zogone edau fararo zu Badiꞌa niguniro. ");
INSERT INTO ksj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Rehano nu'onu'o neḡa vazeḡa ḡihiꞌaḡaꞌe maḡuniro, mazaḡa Iesuꞌa Bana Madaḡano ugi roḡaeḡa fainiro. Aniꞌa vaze ziro, “Eme mada fuꞌo tiba fare zamaḡano gauiꞌuma. Eꞌanoꞌo ugi azaḡaꞌe eꞌe madaḡano aradu manoriꞌuma, u Bana Madaḡanoꞌe mene ꞌougiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ebu Zuhiꞌa Boroꞌa naenaeniro, “Za, zama guhi azaḡa! Zae tibatiba zuni Bana Madaḡano boromakauze ga donikize maḡuzeonoꞌo fuiꞌe bunadu tutuze onamadu vu gagoziniꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tena Aberahamo mariga raꞌeteꞌe roḡaeḡa ꞌadiꞌe nougiꞌuma? Aniꞌe Sataniꞌa muri 18 ogoru tiro. Bana Madaḡano ani fuiꞌe bunogaꞌe mene idaḡahe?” ");
INSERT INTO ksj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iesuꞌa ꞌouge reirotene, ani agiroharoteꞌe azaḡa niduꞌaꞌe mazagaroziro, u vaze ḡuḡuvaḡaꞌe aneꞌa haḡairoteꞌe haḡaiḡa manomano niduꞌa uꞌano, matuꞌiro. ");
INSERT INTO ksj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ebu Iesuꞌa ziro, “Badiꞌaꞌa zuhiꞌaziꞌetaꞌaꞌe nagini heuḡa? Naginio idaniꞌuma? ");
INSERT INTO ksj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Aꞌe Kuava maḡa komeꞌa tiba vaze ꞌahoganiꞌa madu mebaḡano ḡoraroteꞌe heuḡa. Ebu maḡa komeꞌa eꞌeꞌa ḡuhuradu ire boro reirotene, hitagano niniꞌa rafiu aradu ezagano neze ogoraro.” ");
INSERT INTO ksj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Iesuꞌa bare ziro, “Badiꞌaꞌa zuhiꞌaziꞌetaꞌaꞌe naginio idaniꞌuma? ");
INSERT INTO ksj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Aꞌe isiti heuḡa. Roḡaeꞌa isiti tahiḡa madu ꞌuvahuḡa ḡehaḡa teite mirune tibunirotene ꞌuvahu niduꞌa ubararo.” ");
INSERT INTO ksj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iesuꞌa Ierusalema onameꞌeteꞌea, habaꞌahabaꞌano zu neḡaneḡano ihoze onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ebu vaze ꞌahoganiꞌa Iesu ḡadiniro, “Zuhiꞌa Boro, Badiꞌaꞌa vaze tahiḡa daꞌo ḡaboziꞌumahe?” Iesuꞌa naenaeziro, ");
INSERT INTO ksj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ḡabone hidihi roꞌidene, ibiheta kokosiḡa diuḡoga veize inare hunoꞌi. Eḡeꞌa ziꞌohe, vaze ḡehaḡaꞌe eꞌe diuḡihi reꞌuma rehano, mene idaraꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ne vazeḡaniꞌa iḡunadu ibiheta haraune, zaꞌe enona edanadu toketokereꞌenaꞌa ꞌahige uminiꞌuma, 'Vaze boro, ibiheta vavaꞌoꞌi!' Rehano ani naenaeziꞌuma, 'E za noumanoꞌo arataꞌaꞌe aḡuꞌa.' ");
INSERT INTO ksj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ebu za ꞌahige reꞌuma, 'Eme ḡae teite ogaro zu gagiro ebu ḡaꞌe ibio ihofiro.' ");
INSERT INTO ksj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Rehano ani naenaeziꞌuma, 'Za noumanoꞌo arataꞌaꞌe e aḡuꞌa. Za, haḡai sauꞌa azaḡa, eḡe mazaonoꞌo vaḡinoꞌi!' ");
INSERT INTO ksj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ebu za Badiꞌaꞌa zuhiꞌaziꞌeteꞌe zamaḡano Aberahamo, Isako, Iakobo zu peroveta azaḡa niduꞌa radiuꞌeteꞌe zu zaꞌe enona mae feuzeꞌeteꞌe horoziꞌuma. ꞌOugadu zaꞌe niaꞌuma zu ḡononeze atitiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Iuda mene azaḡaniꞌa madaꞌa iteꞌeteꞌe moneonoꞌo zu madaꞌa zubureꞌeteꞌe moneonoꞌo zu haba niduꞌaonoꞌo aradu Badiꞌaꞌa zuhiꞌaziꞌeteꞌe zamaḡano ogau tiburaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Hube hune, vaze ibiꞌaꞌe ḡonaga reꞌuma ebu vaze ḡonagaꞌe ibiꞌa reꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Eꞌe madaḡano Farisea azaḡa nuꞌa Iesu vaḡe aradu niro, “ꞌAdanoꞌo vaḡinadu haba ꞌahoga onamoꞌi, mazaḡa kini Herodaꞌa ḡamihi raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Iesuꞌa naenaeziro, “Aniꞌe butu ḡuniḡa soꞌosoꞌoḡa. Ani vaḡe onamadu ꞌahige noꞌi, 'E mada mene faḡano vine sauꞌa hegoze buziꞌuma zu ugi azaḡa faiziꞌuma, ebu hena eḡe gau niduꞌa haḡae hauḡiꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Naginiꞌa eḡe mazao fureraune zuni, e izidi, ohoḡore, iḡano zu mada nu eḡe ibio onamiꞌuma, onamo Ierusalemao feuriꞌuma. Mazaḡa peroveta azaḡaꞌe Ierusalema habaꞌa enogano mene rudaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O, Ierusalema, Ierusalema, zaꞌa peroveta azaḡa zimiro, zu Badiꞌaꞌa tuḡuziroteꞌe azaḡa hadi hina zimi ruziro. Kokorokuꞌa isaḡa zamaḡano ubuga gugubeꞌeteꞌe teige, eḡeꞌa ḡae ḡehaḡa zae taufihi reiro, rehano zaꞌe mene uratinu! ");
INSERT INTO ksj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ḡianoꞌi, neze fahadu mae modiꞌuma. Eḡeꞌa ziꞌohe, zaꞌe e mene bare horohiꞌuma, onamo zaeꞌa raenaꞌa, 'Zuhiꞌa Boro niḡano areꞌeteꞌe vazeḡaꞌe ḡihiꞌa hune,' rae reiteꞌe madaḡaniꞌa meꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Bana Madaḡa ꞌahogano Iesuꞌa Farisea azaḡa ibitoziꞌeteꞌe vazeḡa ꞌahoga neo ogomu anoga veize onamiro. Ebu vaze nuꞌa ani uhiḡano ḡiaḡiane radiro. ");
INSERT INTO ksj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Eꞌea Iesu zamao vaze ꞌahogaꞌe uginadu ꞌevoꞌa zu odaḡaꞌe miniroteꞌeꞌa radiro. ");
INSERT INTO ksj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ebu Iesuꞌa Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zu Farisea azaḡa ḡadiziro, “Zaꞌa zamareꞌetene Bana Madaḡano ugi vazeḡa fainogaꞌe idaḡa ga mene?” ");
INSERT INTO ksj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Zeꞌa mene naenaeniro. Iesuꞌa ꞌevoꞌa hina ugi vazeḡa oboneꞌenaꞌa, fainadu tuḡune vaḡiniro. ");
INSERT INTO ksj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ebu Iesuꞌa ziro, “Zae boꞌaḡano Bana Madaḡano iniu ubuga ga boromakauꞌa idu vuḡa zamaḡano ovoine, ḡarihe mae ḡihiniꞌuma ga mene?” ");
INSERT INTO ksj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ꞌOuge reirotene, ze mene naenaeniro. ");
INSERT INTO ksj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Muio huziroteꞌe azaḡaniꞌa hitana ehoroḡano ehoroga Iesuꞌa horozirotene, hari ꞌahoga idaniro, ");
INSERT INTO ksj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Vaze ꞌahoganiꞌa hahu muiḡa auḡoga veize ḡa huḡadoꞌidene, hitana ehoroḡano ago ehoroꞌi. Mazaḡa ufeta hitaga vazeḡa zuni hunine, ");
INSERT INTO ksj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ḡanine huzateꞌe vazeḡaniꞌa ḡa vaḡe aradu ꞌahige ḡeꞌuma, 'Ḡae ehoro habaꞌa vaze ꞌadi hanoꞌi.' ꞌOugine, ḡa mazagaroꞌadu ḡonaga ehoroḡa onamiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Eꞌanoꞌo mui vazeḡaniꞌa huḡadoꞌidene, ḡonaga ehoroḡano ehoroꞌi. ꞌOugine, huḡadiroteꞌe vazeḡaniꞌa horoꞌadu ḡa vaḡe ariꞌuma, ebu ꞌahige ḡeꞌuma, 'Eḡe vaze, iḡunadu hitana ehoroḡano ehoroꞌi.' ꞌOugine, ḡae teite huziroteꞌe azaḡaniꞌa ḡa niguꞌiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Iniu vaze aneꞌa bare niḡa mae itine, Badiꞌaꞌa niḡa mae ovoiꞌuma, u iniu vaze aneꞌa bare niḡa mae ovoine, Badiꞌaꞌa niḡa mae itiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ebu Iesuꞌa ani huniroteꞌe vazeḡa niro, “Madai ogomu ga ḡorava ogomu veize vaze huzoꞌidene, vazeḡo, negoḡo, nabugo ga ḡae uhiḡano radiuꞌeteꞌe maꞌora azaḡa ago huzoꞌi. ꞌOugine zeꞌa ḡa bare naenae huḡadadu ḡaeꞌa haḡaiḡo naeḡa meꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Rehano ḡa mui madaḡano zahara azaḡa, oda sauꞌa azaḡa, edanoga mene idaḡa azaḡa ebu ubumaze kuruḡa azaḡa huzoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ꞌOugine ḡaꞌe Badiꞌaꞌa manohuga ḡaniꞌuma. Zeꞌe baronoḡanogaꞌe mene idaḡa ꞌahine, duduḡa azaḡaniꞌa bare ḡaboditeꞌe madaḡano, ḡaꞌe Badiꞌaꞌa haḡaiḡo naeḡa ḡaniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Iesu teite ogau radiroteꞌe vazeḡa ꞌahoganiꞌa Iesu ḡoere egadu Iesu niro, “Badiꞌaꞌa zuhiꞌaziꞌeteꞌe zamaḡano ogau tiburuꞌeteꞌe azaḡaꞌe matuꞌeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ebu Iesuꞌa niro, “Mada ꞌahogano vaze ꞌahoganiꞌa mui boro ruhibadu vaze ḡehaḡa huziro. ");
INSERT INTO ksj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mui madaḡa reirotene, ani tuḡure vazeḡa ꞌahoga huziroteꞌe azaḡa vaḡe tuḡunadu ꞌahige rae ziro, 'Mui boro veize ḡau niduꞌa izidi ruhibeha. Eꞌanoꞌo zae niduꞌa aroꞌi.' ");
INSERT INTO ksj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Rehano zeḡe niduꞌaꞌe ḡoere nunufiro. Ibite huniroteꞌe vazeḡaniꞌa raenaꞌa, 'E haba iziga hoiteha, eꞌanoꞌo e haba eꞌe ḡiani onamihi. E mene amateꞌe moneo ago maḡunoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ebu vaze ꞌahoganiꞌa raenaꞌa, 'E boromakau gaubanana hoiteha. Eꞌanoꞌo e ze manoga ga meneꞌe tuhune nurihi. E mene amateꞌe moneo ago maḡunoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ebu vaze ꞌahoganiꞌa raenaꞌa, 'E iziduꞌu hahureha, eꞌanoꞌo e mene amiꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tuḡure vazeḡaniꞌa bare onamadu zeꞌa reiroteꞌe ḡoeꞌa zuhiꞌaḡa ihoniro. Ihonirotene mui vazeḡaꞌe maḡune rudaro ebu tuḡure vazeḡa niro, 'Ne ibi boroboro zu ibi komeꞌakomeꞌa ḡarihe onamadu zahara azaḡa, oda sauꞌa azaḡa, ubumaze kuruḡa azaḡa zu edanoga mene idaḡa azaḡa zamaze aroꞌi.' ");
INSERT INTO ksj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ebu tuḡure vazeḡaniꞌa onamadu ꞌouge haḡairo, ebu baradu zuhiꞌaḡa niro, 'Zuhiꞌa, ḡaꞌa ehateꞌe gauḡa haḡaeha, rehano ne ꞌize mene iriꞌaveha.' ");
INSERT INTO ksj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Zuhiꞌaḡaniꞌa tuḡure vazeḡa niro, 'Ibi boro zu ibi komeꞌa onamoꞌi ebu vaze niduꞌa teꞌoteꞌozadu zamaze aroꞌi. Vazeꞌe eḡe ne iri'avonoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Eḡeꞌa ziꞌohe, ibite mui veize huziroteꞌe azaḡa niduꞌaꞌe eḡe mui tahiḡa zuni mene auḡiꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mada ꞌahogano vaze ḡuḡuvaḡaniꞌa Iesu teite ragavinu. Ebu Iesuꞌa vaetadu ziro, ");
INSERT INTO ksj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Iniuꞌa eḡe ḡaruna hegotoga uratoꞌidene, eḡe zamare borofoꞌi. Iniuꞌa moga zu viꞌa, inuga zu ubuga, negoḡa zu ezeḡa, ebu ḡaboneḡaꞌe eḡe ufeta vitihe zamare borofine, aniꞌe eḡe mene tahiꞌa reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Iniuꞌa ane satauro odohadu eḡe ḡaruna mene hegotine, aniꞌe eḡe mene tahiꞌa reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Zae boꞌaḡano vaze ꞌahoganiꞌa hitaga neḡa ogoranoga uratine, ibite geno ehoradu hadi nugu hina ogoru hauḡiꞌuma rae zamariꞌuma, zu hadiḡaꞌe ne eꞌe ogoranoga veize idaḡa ga meneꞌe ḡianiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Aniꞌa iḡite ohonadu mene ogoru hauḡine, vaze ḡehaḡaniꞌa eꞌe horonadu ḡirihohaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Zeꞌe ꞌahige reꞌuma, 'Vaze ꞌadiꞌe ne ohoniro, rehano hauḡogaꞌe mene idararo.' ");
INSERT INTO ksj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ebu kini ꞌahoganiꞌa kini ꞌahoga teite uti onamine, ani ibite geno ehoradu ꞌahige rae zamariꞌuma, 'Eḡe uti azaḡaꞌe 10,000 ebu ani uti azaḡa 20,000. E kini eꞌe teite utitine, ani vitiniꞌuma ga mene?' ");
INSERT INTO ksj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ani vitinoga mene idaḡa reine, kini eꞌe ꞌize faḡano radiuꞌeteꞌea, ani teite uniho manoḡa mouga veize hari odohe dureꞌeteꞌe vazeḡa tuḡuniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Eꞌe teige, zae boꞌaḡano iniuꞌa ane ḡau niduꞌa moditeꞌe moneo ibite mene zamarine, aniꞌe eḡe mene tahiꞌa reꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ebu Iesuꞌa ziro, “Zaꞌe dama heuḡa. Damaꞌe manoḡa, rehano iniganiꞌa dauḡine, nougenouge bare inidaꞌuma? ");
INSERT INTO ksj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Dama mene inigaꞌe raha ga ogomu ḡuhuneꞌeteꞌe busiḡa veize zuni mene manoḡa ꞌahine, mae modeꞌohe. Teḡaḡeta vazeḡaꞌe faifaine egadu huga ederoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mada ꞌahogano takesi azaḡa ebu haḡai sauꞌa azaḡaniꞌa Iesu ḡoere abitihi radu ani uhiḡano nuꞌoraro. ");
INSERT INTO ksj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Rehano Farisea azaḡa ebu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡaꞌe mene matuꞌiro ebu ufeta ḡoeriro, “Iesuꞌe haḡai sauꞌa azaḡa mae zouzadu zeḡe teite ogau tiburuꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Eꞌanoꞌo Iesuꞌa hari ꞌahoga idane ziro, ");
INSERT INTO ksj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Zae boꞌaḡano vaze ꞌahoga mazao mamoeḡaꞌe 100. Rehano tibaniꞌa dauḡine, ani nougiꞌuma? Aniꞌe mamoe 99 haba bohaꞌano modadu mamoe dauḡoga vaḡe ragaviꞌuma onamo horoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mamoe dauḡoga horone meine, ani matuꞌe rudanadu mae ane herao tiꞌuma, ");
INSERT INTO ksj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ebu ani bare ne onamiꞌuma. Ebu ane vaze, negoḡa zu nabuga huze nuꞌozadu ziꞌuma, 'Eꞌe eḡe mamoe dauḡoga horoneha. Eꞌanoꞌo eḡe teite matu'ihi.' ");
INSERT INTO ksj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Eḡeꞌa ziꞌohe, haḡai sauꞌa vazeḡa tibaniꞌa ḡihurine, adureo ani uꞌano matuꞌiꞌuma. Duduḡa azaḡaꞌe haḡaize sauꞌa oꞌoꞌa radu mene ḡihureꞌohe. Adureo duduḡa azaḡa 99 uꞌano matuꞌiꞌuma, rehano haḡai sauꞌa vazeḡa tibaniꞌa ḡihurine, ufeta matuꞌiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Iesuꞌa hari ꞌahoga idaniro, “Roḡae ꞌahoga mazao hadi niduꞌa gaubanana, rehano tibaniꞌa dauḡine, ani nougiꞌuma? Aniꞌe ihureḡa tinadu ne fodeꞌenaꞌa, haba niduꞌa faine ḡiane vaḡiꞌuma onamo horoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ebu horone meine, ane vaze, negoḡa zu nabuga huzadu ziꞌuma, 'Eꞌe eḡe hadi dauḡoga horoneha, eꞌanoꞌo eḡe teite matuꞌihi.' ");
INSERT INTO ksj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Eḡeꞌa ziꞌohe, haḡai sauꞌa vazeḡa tibaniꞌa ḡihurine, Badiꞌa tuḡure viga niduꞌaꞌe matuꞌiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ebu Iesuꞌa hari ꞌahoga bare idaniro, “Vaze ꞌahoganiꞌa ubuga aheu teite radiunu. ");
INSERT INTO ksj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mada ꞌahogano ubuga veḡaniꞌa moga niro, 'Mama, ḡae tohe zamaḡano initeꞌe toheḡa niduꞌa enoꞌi.' Eꞌanoꞌo moganiꞌa ane tohe ubuga aheu veize rovonadu ziniro. ");
INSERT INTO ksj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mada nu enogano, ubuga veḡaniꞌa ḡauḡa niduꞌa nuꞌonadu haba faḡa ꞌahoga onamiro. Ebu eꞌea ani ane matuꞌu uꞌano radiu tauḡitauḡadu hadiḡa niduꞌa modiro. ");
INSERT INTO ksj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ani hadiḡa niduꞌa mode hauḡirotene, eꞌe habaꞌano zahara boroꞌa buaro ebu ani vinine runiro. ");
INSERT INTO ksj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Eꞌanoꞌo ani gauoga veize eꞌe habaꞌa vazeḡa ꞌahoga vaḡe onamiro, ebu vaze eꞌeꞌa ani haba bohaꞌano aba taufeꞌeteꞌe gauḡa haro. ");
INSERT INTO ksj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ani eꞌea vinine runadu ani zama boroꞌe aba ogomu atihi reiro, rehano vaze ꞌahoganiꞌa ogomu ꞌahoga mene haro. ");
INSERT INTO ksj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ḡonagano zamaḡaniꞌa bohatanadu ani aneꞌa bare ꞌahige rae reiro, 'Eḡe mama veize gaueꞌeteꞌe azaḡaꞌe ogomuze ḡehaḡa bagaḡa, u eꞌe ahama vinihe ruheꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","E mama vaḡe bare onamadu ꞌahige niꞌuma, “Mama, e Badiꞌa zu ḡa mazao haḡai sauꞌa haḡairo. ");
INSERT INTO ksj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Eꞌanoꞌo e ḡae ubugo rae ago huhoꞌi, rehano ḡae veize gaueꞌeteꞌe azaḡa boꞌaḡano vaze tiba teige huhoꞌi.”' ");
INSERT INTO ksj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ebu aniꞌa iḡunadu moga vaḡe bare onamiro. Ani ꞌize faḡano ariroteꞌea, moganiꞌa horoniro. Mogaꞌe ubuga vetuḡaneadu ani ubuga uꞌa dure onamiro ebu ahainadu furaꞌiniro. ");
INSERT INTO ksj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ubuganiꞌa moga niro, 'Mama, eꞌe Badiꞌa zu ḡa mazao haḡai sauꞌa haḡairo, eꞌanoꞌo e ḡae ubugo rae ago huhoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Rehano moganiꞌa tuḡure azaḡa ziro, 'Dabua manoḡa ḡarihe odohe aradu ubudehe vidohanoꞌi. ꞌEvore adiriḡa redohanoꞌi zu tamaka redohanoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ebu boromakau modohuḡa iga odohe aradu manoꞌi. Eme matuꞌiꞌhi zu ogau tiburatihi. ");
INSERT INTO ksj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Mazaḡa eḡe ubude ꞌahiꞌe rudanadu bare ḡabodeha, ebu ani dauḡadu bare horone maha.' Eꞌanoꞌo ze mui boro haḡadu zeḡe niduꞌa matuꞌe tiburaro. ");
INSERT INTO ksj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ꞌOugiroteꞌe zamaḡano ubuga ibiꞌaniꞌa mebao gaue radiunu. Ani ne uꞌa bare onamadu ne uhiḡano feurirotene, badahe zavoneꞌeteꞌe haraoḡa igiro. ");
INSERT INTO ksj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ebu ani tuḡure vazeḡa ꞌahoga hunadu naginiꞌa fureruꞌeteꞌe ḡadiniro. ");
INSERT INTO ksj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tuḡure vazeḡaniꞌa naenaeniro, 'Negoḡoꞌa manoḡa bare feureha, eꞌanoꞌo mogoꞌa boromakau modohuḡa iga manadu mui boro haḡaeha.' ");
INSERT INTO ksj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ꞌOuge reirotene ubuga ibiꞌaniꞌa maḡune rudaro ebu ne zamaḡa diuḡoga mene uratiro. Ebu moganiꞌa buanadu ne diuḡifine ani uminiro. ");
INSERT INTO ksj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Rehano aniꞌa moga naenaeniro, 'Mama, zamaroꞌi! E muri ḡehaḡa tuḡure vazeḡa teige ḡae veize gaue areꞌohe zu ḡae ḡoere mene hezahohaunu. Rehano e eḡe nabudi teite matuꞌifine ḡaeꞌa gouti ubuga tiba zuni mene manoniro. ");
INSERT INTO ksj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","U ubugo ꞌahaꞌa daro fuꞌa roḡaeḡaroḡaeḡa teite ḡae tohe mode hauḡadu ne uꞌa bare aratene, ḡa boromakau modohuḡa iga mano haneha!' ");
INSERT INTO ksj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ebu moganiꞌa niro, 'Eḡe ubude, ḡa mada niduꞌa eḡe teite radiuꞌohe, eꞌanoꞌo eḡe ḡau niduꞌaꞌe ḡae veize raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","U negoḡoꞌe rudanadu bare ḡabodeha zu dauḡadu bare horoneha. Eꞌanoꞌo emeḡeꞌa mui haḡadu matuꞌiꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesuꞌa ane tahiꞌatahiꞌa ziro, “Maꞌora vazeḡa ꞌahoga ane ḡau niduꞌa taufeꞌeteꞌe vazeḡa ꞌahoganiꞌa radiunu. Mada ꞌahogano maꞌora vazeḡaꞌe ane ḡau taufeꞌeteꞌe vazeḡaniꞌa ani hadi au hauḡinuteꞌe igiro. ");
INSERT INTO ksj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ꞌOugirotene, maꞌora vazeḡaniꞌa ani hunadu niro, 'Ḡae moneo igiꞌeteꞌe hariḡaꞌe hubehe? Ḡaeꞌa eḡe hadi hina nougenouge gauinuteꞌe faine meꞌodonoꞌi, mazaḡa ḡaꞌe eḡe ḡau mene bare taufiꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ꞌOuge nirotene, ani aneꞌa bare reiro, 'Eḡe zuhiꞌaꞌa gauhe eḡe mazaonoꞌo mae vaḡiniꞌuma. E izidi nougiꞌuma? E ahiri gauḡa moneo inarahe ꞌoꞌoꞌa zu hadi umidoga mazagaroheꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","O, e nougitaꞌaꞌe edereha. ꞌAhige haḡaine, gau ꞌahi moditeꞌe madaḡano vazeꞌa zeḡe neo huhe zouhiꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ꞌOugadu aniꞌa ane zuhiꞌa ḡau meiroteꞌe azaḡa tibatiba huziro. Ebu zeḡe boꞌaḡano vaze ꞌahoga ḡadiniro, 'Ḡaꞌa eḡe zuhiꞌa ḡauꞌe nugu meiro?' ");
INSERT INTO ksj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Vaze eꞌeꞌa naenaeniro, 'E olivi dehoroḡa 800 gareni meiro.' Zuhiꞌaḡa ḡau taufeꞌeteꞌe vazeḡaniꞌa niro, 'Ḡae soꞌa ꞌahi moꞌi, ebu ḡarihe ehoradu 400 gareni rae bare mirihoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ebu hena vaze ꞌahoga ḡadiniro, 'Ḡa eḡe zuhiꞌa ḡauꞌe nugu meiro?' Vaze eꞌeꞌa naenaeniro, 'Vuidi fuseḡa niduꞌa 100 meiro.' Aniꞌa niro, 'Ḡae soꞌa ꞌahi madu fuse niduꞌa 80 rae bare mirihoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Zuhiꞌaḡaniꞌa ane ḡau taufeꞌeteꞌe vazeḡaniꞌa nagini haḡairoteꞌe igirotene, ani ḡuriro vazeḡa rehano, niguniro, mazaḡa haḡaiḡaꞌe huhuzaḡa. Eꞌe teige, raha ꞌadao Badiꞌa aḡuꞌa azaḡaꞌe zeḡe veize gauoga ufeta huhuzaḡa. Zeꞌe agaḡa azaḡa vitizoga. ");
INSERT INTO ksj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Eꞌanoꞌo eḡeꞌa ziꞌohe, zaꞌe raha ꞌada ḡau madu vaze danazoꞌi, ꞌougine zeꞌe zae nabudi reꞌuma. Ebu ḡauze niduꞌa hauḡadu zae zuni rudaune, zeꞌe radiu tuḡutuḡu habaꞌano za horozadu mae zouziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Iniuꞌa gau komeꞌa veize zamaḡa niduꞌa hina faine haḡaine, gau boro zuni ꞌouge haḡaiꞌuma. U iniuꞌa gau komeꞌano ḡuririne, gau boro veize zuni ḡuririꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Za raha ḡauḡa madu zamaze niduꞌa hina mene faine taufine, iniuꞌa ḡau manomano zenadu taufoꞌi rae reꞌuma? ");
INSERT INTO ksj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ebu za vaze ḡau madu zamaze niduꞌa hina mene faine taufine, iniuꞌa zaeꞌa meiteꞌe gau naeḡa ziniꞌuma? ");
INSERT INTO ksj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tuḡure vazeḡaꞌe zuhiꞌa aheu veize gauoga mene idaḡa. Ani ꞌahogaꞌe heꞌeheꞌeniꞌuma, u ꞌahogaꞌe zamare borofiꞌuma. Ebu ꞌahoga veize faine gauiꞌuma, u ꞌahogaꞌe turuniꞌuma. Eꞌe teige, zaꞌe Badiꞌa ebu hadi, aheu veize gauoga mene idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisea azaḡaꞌe hadi zamare borofeꞌeteꞌe uꞌano Iesu ḡoere igirotene, Iesu eḡofoharo. ");
INSERT INTO ksj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ꞌOugadu Iesuꞌa ziro, “Zaꞌe vaze ubumao zaeꞌa bare duduḡa raꞌohe, rehano Badiꞌaꞌe zae zama sauꞌa edeḡa. Vazeꞌa ḡau boro raꞌeteꞌe ḡauḡaꞌe Badiꞌaꞌa heꞌeheꞌeneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ioane Babatisoꞌa ꞌizema arogano Mose goro ḡoeꞌa zu peroveta azaḡa ḡoere hina vaze ibitoziro. Eꞌe enogano Badiꞌaꞌa zuhiꞌaziꞌeteꞌe moneo hari manoḡaꞌe harameꞌohe, ebu vaze ḡehaḡaꞌe Badiꞌaꞌa zuhiꞌaziꞌeteꞌe zamaḡano diuḡoga veize inareꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Adure zu rahaꞌe dauḡiꞌuma, rehano Mose goro ḡoeꞌa niduꞌa boꞌaḡano komeꞌa ꞌahoga zuni mene hune dauḡiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Mose goro ḡoeꞌa ꞌahoganiꞌa ꞌahige rae reiro, 'Iniuꞌa inuga modadu roḡae ꞌahoga teite hahurine, aniꞌe ubuma ḡezauꞌohe. Ebu iniu iꞌaniꞌa modiroteꞌe roḡaeḡa teite hahurine, ani zuni ubuma ḡezauꞌohe.'” ");
INSERT INTO ksj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Iesuꞌa hari ꞌahoga idaniro, “Maꞌora vazeḡa ꞌahoganiꞌa radiunu. Ani dabua manoḡa naeḡa boro vidaunu zu mada niduꞌa ne manoḡa huneo ogomu manoḡa au radiunu. ");
INSERT INTO ksj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","U ani ne ḡabiriḡa ibihetaḡano zahara vazeḡa, niḡa Lazaroꞌa baze radiunu. Ani ahiriꞌe idiri ḡunuḡa. ");
INSERT INTO ksj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ani maꞌora vazeḡaniꞌa fatao oganadu mumuḡaniꞌa rururaudoteꞌe ufe atihi reinu. Ḡuniꞌa zuni aradu ane idiri ubidinu. ");
INSERT INTO ksj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ebu hena Lazaroꞌa rudarotene, tuḡure viganiꞌa ovadu Aberahamo vaḡe zamahu itiro. Ebu maꞌora vazeḡa zuni rudanadu guriro. ");
INSERT INTO ksj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Maꞌora vazeḡaꞌe rune azaḡa haba onamadu gigiꞌa boro uꞌano huau ḡaniḡanaro. Ebu eꞌea ite ḡianirotene, faḡano Aberahamo horoniro zu ane babaḡano Lazaroꞌa ehore radiroteꞌe horoniro. ");
INSERT INTO ksj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ꞌOugadu aniꞌa huau niro, 'Mama Aberahamo! Eḡe vetuḡahoꞌi! Lazaro tuḡunadu ane ꞌevore huduꞌa vuo taradu mazanehe amunanoꞌi. E ire roga duhuḡa zamaḡano gigiꞌa boro hideꞌohe.' ");
INSERT INTO ksj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Rehano Aberahamoꞌa naenaeniro, 'Ubude, ḡa ꞌahi zamaroꞌi. Ḡaꞌa rahao ḡabode radiudoteꞌe madaḡano ḡau manomano hidinu, u Lazaroꞌe aduga nunu hidinu. Eꞌanoꞌo Lazaroꞌe izidi ꞌahao matuꞌe radiuꞌohe, u ḡaꞌe gigiꞌa hideꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mene eꞌe daꞌo, emeḡe zu zae boꞌaḡanoꞌe dofara boro. Vaze ꞌahoga ꞌahaonoꞌo zae mone fare amoga mene idaḡa, ebu ꞌomanoꞌo emeḡe none fare aroga zuni mene idaḡa.' ");
INSERT INTO ksj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ꞌOuge reirotene, maꞌora vazeḡaniꞌa naenaeniro, 'Mama Aberahamo, e ḡa umiꞌeꞌohe. Lazaro eḡe ne tuḡune onamoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Negohe niduꞌaꞌe fuꞌo. Lazaroꞌa zeḡe vaḡe onamadu riḡa iraduguzine, ze eḡeꞌa gigiꞌa hideꞌeteꞌe habaꞌa ꞌada mene ariꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Rehano Aberahamoꞌa niro, 'Mose zu peroveta azaḡaniꞌa mirihiroteꞌe soꞌaḡaꞌe zeḡe mazao, eꞌanoꞌo ze eꞌe meꞌodadu faine ederiꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ebu maꞌora vazeḡaniꞌa niro, 'Mene, mama Aberahamo, rune azaḡa boꞌaḡano ꞌahoganiꞌa bare ḡabodadu zeḡe vaḡe onamine, zeꞌe ḡihuriꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Rehano Aberahamoꞌa niro, 'Ze Mose zu peroveta azaḡa ḡoere mene egozinine, rune azaḡa boꞌaḡano bare ḡabode iḡuniroteꞌe vazeḡa ḡoere zuni mene hune egohaꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesuꞌa ane tahiꞌatahiꞌa ziro, “Vaze ibi sauꞌano tutuzeꞌeteꞌeꞌe ḡauḡaꞌe mada niduꞌa fureruꞌohe, rehano vaze haḡai sauꞌano tutuzeꞌeteꞌe vazeḡaꞌe aduga boro hidiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Aniꞌa vaze komeꞌakomeꞌa boꞌaḡano ꞌahoga haḡai sauꞌano tutune veꞌonine, hadi horeḡa ane ꞌunuo autadu davarao mae feunogaꞌe ufeta manoḡa. ");
INSERT INTO ksj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Eꞌanoꞌo zaeꞌa bare tohutohoꞌi! Ekalesia nabugoꞌa haḡai sauꞌa haḡaoꞌidene, ronoꞌi. Ebu aniꞌa haḡaiḡa sauꞌanonoꞌo ḡihuroꞌidene, haḡaiḡa sauꞌa rae modoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Aniꞌa mada tiba zamaḡano ḡae fuꞌo aheu fare ḡae mazao haḡai sauꞌa haḡaoꞌidene, zu ḡae fuꞌo aheu fare ḡae vaḡe bare aradu raenaꞌa, 'E ḡae mazao haḡai sauꞌa haḡaeha. E mene bare haḡaiꞌuma,' rae roꞌidene, ane haḡai sauꞌa aḡutu modoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apostolo azaḡaniꞌa Zuhiꞌa Boro niro, “Eme ḡa mazao fieꞌeteꞌe ufeta borofoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Zuhiꞌa Boroꞌa naenaeziro, “Zaꞌa eḡe mazao fieꞌetaꞌaꞌe fufu maḡa komeꞌa tiba heuḡa radu Irimo ireḡa ninaꞌa, 'Ḡaeꞌa bare taigota iḡunadu davarao ḡuhuroꞌi,' rae reine, ireḡaniꞌa zae ḡoere egoziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Zae boꞌaḡano vaze ꞌahoganiꞌa tuḡure vazeḡa ꞌahoga teite reine, tuḡure vazeḡa eꞌeꞌa mebao raha huꞌiꞌuma ga mamoe taufiꞌuma. Ebu aniꞌa gauonoꞌo bare arine, ane zuhiꞌaꞌa ninaꞌa, 'Aroꞌi, ehoradu oganoꞌi,' rae reꞌumahe? ");
INSERT INTO ksj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mene. Ane zuhiꞌaꞌa ꞌahige reꞌuma, 'Eḡe veize ḡorava ogomuḡa ḡorohadu ruhiboꞌi, ebu e ibite oganoga veize danahoꞌi. Eꞌe ḡaruganobuꞌu ḡa oganoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ebu tuḡure vazeḡaꞌe zuhiꞌaḡaniꞌa rateꞌe gauḡa haḡairoteꞌe uꞌano zuhiꞌaḡaniꞌa ani mazao manoḡa tauḡi rae niꞌumahe? Mene. ");
INSERT INTO ksj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Eꞌanoꞌo zae zuni Badiꞌaꞌa ziꞌeteꞌe gauḡa haḡae hauḡoꞌidene, ꞌahige roꞌi, 'Eme tuḡure azaḡa komeꞌa. Eme emeḡeꞌa haḡae huniteꞌe gauḡa haḡae tauḡeha.'” ");
INSERT INTO ksj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iesuꞌa Ierusalema onamiroteꞌe ibiḡano Samaria zu Galilea habaꞌa nemaḡano vitine onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ebu aniꞌa ne ꞌahoga diuḡirotene, refera azaḡa gaubanana hidiro. Ze faḡano edanadu Iesu horoniro, ");
INSERT INTO ksj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ebu ḡihau huaro, “Vaze boro Iesu, eme vetuḡafoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Iesuꞌa horozadu ziro, “Dibuꞌo azaḡa vaḡe onamadu ahirize ihozoꞌi.” Ebu ze ibio onameꞌeteꞌe zamaḡano, referazeꞌa deheru manoriro. ");
INSERT INTO ksj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Zeḡe boꞌaḡano vaze tibaꞌe referaḡaniꞌa manoroga horonirotene, agoḡa boro hina Badiꞌa niguneꞌenaꞌa, Iesu vaḡe bare ariro. ");
INSERT INTO ksj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ebu ani Iesu oda babaḡano ḡuḡuradu manoḡa tauḡi rae niro. Vaze ꞌadiꞌe Samaria vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ebu Iesuꞌa ḡadiniro, “E vaze gaubanana faizeha, rehano vaze fuꞌo ḡazaḡa fareꞌe noumao? ");
INSERT INTO ksj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Iuda mene vazeḡa, ḡaꞌa daꞌo aradu Badiꞌa niguneꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ebu Iesuꞌa niro, “Iḡunadu onamoꞌi. Ḡaeꞌa eḡe mazao fieꞌeteꞌe uꞌano, ḡaeꞌa manoreha.” ");
INSERT INTO ksj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mada ꞌahogano Farisea azaḡaniꞌa Iesu ḡadiniro, “Badiꞌaꞌa zuhiꞌaziꞌeteꞌe madaḡaꞌe naniꞌa ariꞌuma?” Iesuꞌa naenaeziro, “Badiꞌaꞌa zuhiꞌaziꞌeteꞌe madaḡaꞌe ubumaze hina ḡianoga mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","'Ḡianoꞌi, ꞌahama raꞌohe!' ga 'ꞌOmoa raꞌohe!' rae mene reꞌuma, mazaḡa Badiꞌaꞌa zae boꞌaḡano zuhiꞌaziꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ebu Iesuꞌa ane tahiꞌatahiꞌa ziro, “Zaꞌa zazore mone Vaze Ubuga rahao ḡianihi reiteꞌe madaḡaniꞌa ariꞌuma, rehano zaꞌe ani mene horoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Vazeꞌa raenaꞌa, 'Ḡianoꞌi, Iesuꞌe ꞌomo eꞌe,' ga 'Iesuꞌe ꞌahi eꞌe,' rae zoꞌidene, ago buau onamoꞌi zu ago hegotoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Vaze Ubuganiꞌa bare arine, vaze niduꞌa huneꞌa horoniꞌuma. Aꞌe viriꞌa vazahadu adure naenaenoꞌo aganadu vaze niduꞌa horoneꞌeteꞌe heuḡa. ");
INSERT INTO ksj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Rehano ibite aniꞌe aduga ḡehaḡa hidiꞌuma zu izidi eganiꞌa ani hezahohaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Vaze Ubuganiꞌa bare ariteꞌe madaḡanoꞌe Noa madaḡa teigiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Eꞌe madaḡano vaze niduꞌa iḡaiḡa haḡainuteꞌe teige ogaunu, gaginu zu hahurinu, onamo Noaꞌa ḡasi boro diuḡiro. Ebu hena zobo boroꞌa aradu zeḡe niduꞌa ruize hauḡiro. ");
INSERT INTO ksj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ꞌUguḡaniꞌa Lota madaḡano zuni fureraro. Vaze niduꞌa iḡaiḡa haḡainuteꞌe teige ogaunu, gaginu, hoitinu, seroninu, hihinu ebu neze ogoraunu. ");
INSERT INTO ksj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Rehano Lotaꞌa Sodoma mode iḡunirotene, ire roga zu sulifuꞌa adureonoꞌo irugu teige rururu ovoadu zeḡe niduꞌa hune ruize hauḡiro. ");
INSERT INTO ksj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Vaze Ubuganiꞌa bare arine, eꞌe madaḡa teigiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Eꞌe madaḡano iniu ne enogano radiuꞌeteꞌe vazeḡaꞌe ḡauḡa mouga veize ne zamaḡa mene diuḡiꞌuma. Mebao hiheꞌeteꞌe vazeḡa zuni ne bare mene onamiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lota inuga zamaroꞌi! ");
INSERT INTO ksj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Iniuꞌa ane ḡabone obone giganine, ani ḡabone tuḡutuḡu mene hidiꞌuma. Rehano iniuꞌa ane ḡabone eḡe veize ahetine, ḡabone tuḡutuḡu hidiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Eḡeꞌa ziꞌohe, e bare ariteꞌe oheꞌano vaze aheuꞌe evane tibano bazeꞌeteꞌea ꞌahogaꞌe zamahanadu onamiꞌuma, u ꞌahogaꞌe muhine iḡuniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Roḡae aheuꞌe ꞌuvahu mirune radiuꞌeteꞌe zamaḡano ꞌahogaꞌe zamahanadu iḡuniꞌuma, u ꞌahogaꞌe muhine iḡuniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ebu Iesu tahiꞌatahiꞌaꞌa ḡadiniro, “Zuhiꞌa Boro, eꞌeguḡaniꞌa noumao fureraꞌuma?” Iesuꞌa naenaeziro, “Naginiꞌa rudaroteꞌe habaꞌano gaozaꞌa nuꞌoraꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ebu Iesuꞌa ane tahiꞌatahiꞌaꞌa iḡaiḡa kuranoga zu kuru mene modoga veize hari ꞌahoga idane ziro, ");
INSERT INTO ksj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Haba ꞌahogano kota vazeḡa ꞌahoganiꞌa radiunu. Aniꞌe Badiꞌa mene rihoninu zu vaze mene gubazinu. ");
INSERT INTO ksj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Eꞌe habaꞌano ḡozoba ꞌahoganiꞌa zuni radiunu. Ani barebare kota vazeḡa vaḡe onamadu uminiro, 'Agire vazeḡaniꞌa eḡe mazao sauꞌa haḡaeꞌohe. Ḡaeꞌa ane haḡai sauꞌa naeḡa hanoꞌi!' ");
INSERT INTO ksj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kota vazeḡaꞌe faḡa hune ḡozoba eꞌe dananoga mene uratiro. Rehano vesuꞌu ani aneꞌa bare ꞌahige rae reiro, 'E Badiꞌa mene rihoneꞌohe zu vaze mene gubazeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Rehano ḡozoba ꞌadi e ufeta ḡunuḡunuheꞌe ꞌahine, e ani umido egadu dananiꞌuma. Mene ꞌougine, ani barebare aradu e fuḡofuḡohiꞌuma!'” ");
INSERT INTO ksj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ebu Zuhiꞌa Boroꞌa bare reiro, “Zaꞌe Kota vazeḡaniꞌa nagini raꞌeteꞌe egoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Badiꞌaꞌe aneꞌa ohotiroteꞌe azaḡaniꞌa ohere zu madai uminine, zeḡe umido ziniꞌuma, ebu danazogaꞌe mene sasiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Eḡeꞌa ziꞌohe, Badiꞌaꞌa nagini duduḡa raꞌeteꞌe ḡauḡa ḡarihe ziniꞌuma. Rehano Vaze Ubuganiꞌa bare ariteꞌe madaḡano, Badiꞌa mazao fieꞌeteꞌe vazeḡa nu horoziꞌuma ga mene?” ");
INSERT INTO ksj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Iesuꞌa ze zeḡeꞌa bare duduḡa rae raꞌeteꞌe zu vaze ovoe ḡiazeꞌeteꞌe azaḡa mazao hari ꞌahoga idane ziro, ");
INSERT INTO ksj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Mada ꞌahogano vaze aheuꞌa kuranoga radu kuru neḡa itiro. Vaze ꞌahogaꞌe Farisea vazeḡa zu ꞌahogaꞌe takesi vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisea vazeḡaꞌe edanadu aneꞌa bare ꞌahige kuraro, 'Badiꞌa, manoḡa tauḡi, mazaḡa eꞌe ḡonore azaḡa, haḡai sauꞌa azaḡa, ubuma ḡezo azaḡa zu ꞌuguḡa azaḡa nunu mene heuḡa, ebu takesi vazeḡa ꞌomo zu mene heuḡa. ");
INSERT INTO ksj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Fura tiba zamaḡano e ḡae aheu ogomu moneo zaḡozaḡeꞌohe, zu eḡeꞌa hidiroteꞌe ḡauḡa niduꞌaonoꞌo sinu gaubananao rovonadu sinu tiba ḡauḡa ḡaneꞌohe.' ");
INSERT INTO ksj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","U takesi vazeḡaꞌe faḡano edanadu adure ḡoha zuni mene ite ehamuꞌenaꞌa ebu ꞌuꞌuga faꞌofaꞌoneꞌenaꞌa ꞌahige kuraro, 'Badiꞌa, eꞌe haḡai sauꞌa vazeḡa. Vetuḡahoꞌi!' ");
INSERT INTO ksj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Eḡeꞌa ziꞌohe, Badiꞌa ubumao duduḡa rae radu neḡa bariroteꞌe vazeḡaꞌe mene Farisea vazeḡa, rehano takesi vazeḡa. Iniu aneꞌa bare niḡa mae itine, Badiꞌaꞌa niḡa mae ovoiꞌuma, u iniu aneꞌa bare niḡa mae ovoine, Badiꞌaꞌa niḡa mae itiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mada ꞌahogano vaze nuꞌa eneze guraḡa zuni tutuzadu Iesu vaḡe ariro, mazaḡa Iesuꞌa ꞌevoꞌa zeḡe rana touga uratiro. Rehano ani tahiꞌatahiꞌaꞌa horozadu tutuze ariroteꞌe azaḡa roziro. ");
INSERT INTO ksj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ꞌOugirotene, Iesuꞌa tahiꞌa komeꞌakomeꞌa huziro ebu vaze eꞌea ziro, “Tahiꞌa komeꞌakomeꞌa eḡe mazao tuḡuzoꞌi. Ze ago gararoꞌi. Mazaḡa Badiꞌaꞌa zuhiꞌaziꞌeteꞌe azaḡaꞌe tahiꞌa komeꞌakomeꞌa teigeꞌeteꞌe azaḡa. ");
INSERT INTO ksj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Eḡeꞌa hube hune ziꞌohe, iniuꞌa tahiꞌa komeꞌa teige Badiꞌaꞌa zuhiꞌaziꞌeteꞌe mene mae ḡihinine, ani Badiꞌaꞌa mene zuhiꞌaniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Iuda azaḡa ibitoziꞌeteꞌe vazeḡa ꞌahoganiꞌa Iesu ḡadiniro, “Ihore vazeḡa manoḡa, e nougine, ḡabone tuḡutuḡu hidiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Iesuꞌa niro, “Ḡa nougadu eꞌe manoḡa rae raꞌohe? Vazeni ꞌahoga zuni mene hune manoḡa, rehano Badiꞌa ane daꞌo manoḡa. ");
INSERT INTO ksj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ḡa Mose goro ḡoeꞌa edeḡa: 'Ubuma ago ḡezanoꞌi, vaze ago gorunoꞌi, ago ḡonotanoꞌi, vaze moneo ago ḡuriroꞌi ebu viꞌu mogo gubazoꞌi.'” ");
INSERT INTO ksj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Aniꞌa naenaeniro, “E komeꞌanonoꞌo ḡoere ꞌahi niduꞌa hegote ariro.” ");
INSERT INTO ksj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iesuꞌa ani ḡoere egadu niro, “Ḡa ḡau ꞌahoga ꞌize mene haḡaeha. Ḡauḡo niduꞌa seronadu zahara azaḡa zenoꞌi. ꞌOugine ḡa adureo ḡau naeḡa boroboro hidiꞌuma. Ebu aradu eḡe hegotoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Aniꞌa Iesu ḡoere igirotene, zamaḡaniꞌa adudaro, mazaḡa aniꞌe ufeta maꞌora vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ebu Iesuꞌa ani horonadu reiro, “Maꞌora azaḡaꞌe Badiꞌaꞌa zuhiꞌaziꞌeteꞌe azaḡa rougaꞌe riḡa bagaḡa. ");
INSERT INTO ksj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kameroꞌe niduru hoꞌoga diuḡogaꞌe riḡa. Rehano maꞌora vazeḡaꞌe Badiꞌaꞌa zuhiꞌaniꞌeteꞌe vazeḡa rougaꞌe ufeta riḡa.” ");
INSERT INTO ksj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Eꞌe igiroteꞌe azaḡaniꞌa ḡadiniro, “ꞌOugine, iniuꞌa ḡabone hidiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Iesuꞌa naenaeziro, “Vaze aneꞌa bare ḡabone hidogaꞌe mene idaḡa, rehano Badiꞌaꞌe idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ebu Peteroꞌa niro, “Eme emeḡe ḡau niduꞌa modadu ḡa hegotiro.” ");
INSERT INTO ksj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Iesuꞌa ziro, “Eḡeꞌa hube hune ziꞌohe, iniu Badiꞌaꞌa zuhiꞌaziꞌeteꞌe veize neḡa, inuga, negoḡa, viꞌa moga ga tahiꞌaḡa modine, ");
INSERT INTO ksj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","aniꞌe izidi madaḡano ane naeḡa ḡae ḡehaḡa hidiꞌuma, ebu zama moneo ḡabone tuḡutuḡu hidiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ebu Iesuꞌa ane tahiꞌa gaubanana aheu fare ani uhiḡano nuꞌozadu ziro, “Eme Ierusalema iteꞌohe. Eꞌea feurine, peroveta azaḡaniꞌa Vaze Ubuga moneo mirihiroteꞌe niduꞌa hudaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Vaze Ubugaꞌe Iuda mene azaḡa ꞌevoreo riꞌinadu zeꞌa ḡirihohaꞌuma, ani mae mazagaroniꞌuma, ani rana soꞌabidiꞌuma, ");
INSERT INTO ksj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","masiniꞌuma zu maꞌuma. Rehano mada uḡiduḡano aniꞌa bare ḡabode iḡuniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Rehano Iesu tahiꞌatahiꞌaꞌe ane ḡoere huga mene ederiro, mazaḡa ḡoere huga aꞌe ꞌuꞌuruga ꞌahine, aniꞌa nagini zirotaꞌaꞌe mene ederiro. ");
INSERT INTO ksj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Iesuꞌa Ieriko hanitirotene, ubuma kuruḡa vazeḡa ꞌahoganiꞌa ibi genaḡano ehoradu vaze mazao hadi umidinu. ");
INSERT INTO ksj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ani vaze ḡuḡuvaḡaniꞌa harae vitauꞌeteꞌe egadu naginiꞌa fureruꞌeteꞌe ḡadimaro. ");
INSERT INTO ksj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ebu zeḡeꞌa naenaeniro, “Nazareta vazeḡa Iesuꞌa vitauꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ze ꞌouge nirotene, ani ḡihau huaro, “Davida mariga Iesu, eḡe vetuḡahoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ꞌOugirotene, ibitiroteꞌe azaḡaniꞌa roniro, “Ḡa sifu radoꞌi!” Rehano ani ufeta ḡihau huaro, “Davida mariga, eḡe vetuḡahoꞌ!” ");
INSERT INTO ksj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ebu Iesuꞌa tue edanadu ziro, “Ani tutune aroꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Aniꞌa Iesu vaḡe arirotene, Iesuꞌa ḡadiniro, “Ḡa eḡeꞌa ḡae veize nagini haḡaoga urateꞌohe?” Aniꞌa naenaeniro, “Zuhiꞌa Boro, e ehamatihi.” ");
INSERT INTO ksj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Iesuꞌa niro, “Ehamanoꞌi. Ḡaeꞌa eḡe mazao fieꞌeteꞌeꞌa manoꞌeha.” ");
INSERT INTO ksj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ꞌOugirotene, ani zogone manoradu faine ehamaro, zu Badiꞌa niguneꞌenaꞌa Iesu hegotiro. Vaze niduꞌa eꞌe horonirotene, zeḡe zuni Badiꞌa niguniro. ");
INSERT INTO ksj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iesuꞌa Ieriko diuḡadu vitau onaminu. ");
INSERT INTO ksj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Eꞌea vaze ꞌahoga niḡa Zakaioꞌa radiunu. Aniꞌe takesi vazeḡa ḡihiꞌaḡa zu maꞌora vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ani Iesuꞌe iniu rae ḡianihi reiro, rehano aniꞌe vaze futuꞌa ꞌahine, vaze ḡuḡuvaḡa boꞌaḡano Iesu horonogaꞌe mene idararo. ");
INSERT INTO ksj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Eꞌanoꞌo ani Iesu ḡianoga radu dure ibitiro, ebu Hiru ireḡa ꞌahoga sibiriro, mazaḡa Iesuꞌa eꞌe ibiḡano vitaꞌuma rae reiro. ");
INSERT INTO ksj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ebu Iesuꞌa eꞌe habaꞌano feurirotene, ite ehamanadu Zakaio niro, “Zakaio, ḡarihe bua ovaoꞌi. E izidi ḡae neo radiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ꞌOugadu Zakaioꞌe ḡarihe sibire buanadu matuꞌeꞌenaꞌa, ane neo Iesu mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Vaze niduꞌa eꞌe horonadu gumude ḡoeriro, “Iesuꞌa haḡai sauꞌa vazeḡa neo diuḡadu radiuꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ebu Zakaioꞌa edanadu Zuhiꞌa Boro niro, “Zuhiꞌa Boro, ḡianoꞌi. E izidi eḡe ḡau niduꞌaonoꞌo ḡahaꞌa zahara azaḡa ziniꞌuma. Ebu eḡeꞌa vaze soꞌozadu ḡau ꞌahoga meiniro reine, ḡae ḡazaḡa bare baronoziniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ꞌOugadu Iesuꞌa naenaeniro, “Izidi ḡa zu ḡae teite ne tibano radiuꞌeteꞌe azaḡaniꞌa ḡabone hideha. Izidi Zakaio zuni Aberahamo mariga. ");
INSERT INTO ksj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Vaze Ubugaꞌe dauḡiroteꞌe azaḡa vaḡadu ḡabozoga veize ariro.” ");
INSERT INTO ksj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Iesuꞌa Ierusalema hanitirotene vaze niduꞌa ꞌahige rae zamariro, “Badiꞌaꞌa zuhiꞌaziꞌeteꞌe madaḡaniꞌa zogone fureraꞌuma.” ꞌOugadu ze Iesu ḡoere ꞌize abiteꞌeteꞌea, Iesuꞌa hari ꞌahoga idane ziro, ");
INSERT INTO ksj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Niḡa boro vazeḡa ꞌahoganiꞌa radiunu. Aniꞌa kini iḡuri mouga veize haba faḡa onamadu bare arihi rae reiro. ");
INSERT INTO ksj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Aniꞌa iḡuniroteꞌe madaḡano tuḡureḡa azaḡa gaubanana huzadu zeḡe tibatiba hadi silivaḡa tibatiba ziniro. Ebu aniꞌa ziro, 'Hadi ꞌahi hina gauadu hadi borofoꞌi, onamo eḡeꞌa bare ariꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","U ane haba azaḡaniꞌa ani heꞌeheꞌenadu ane ḡaruna hari odohe onameꞌeteꞌe vazeḡa tuḡunadu haba zuhiꞌaḡa mazao uminiro, 'Eme aniꞌe emeḡe kini rouga mene urateꞌohe.' ");
INSERT INTO ksj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Rehano haba zuhiꞌaḡaniꞌa ani kinio ohonadu bare ariro. Ebu hadi silivaḡa ziniroteꞌe tuḡure azaḡa huzadu zeꞌa nougenouge hadi borofirotaꞌaꞌe ederihi rae reiro. ");
INSERT INTO ksj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ebu tuḡure vazeḡa ibiꞌaniꞌa ane vaḡe aradu niro, 'Zuhiꞌa, ḡaeꞌa iniroteꞌe hadi silivaḡa tiba hina hadi silivaḡa gaubanana ragate haḡairo.' ");
INSERT INTO ksj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ane zuhiꞌaꞌa niro, 'Manoḡa taugi, ḡaꞌe tuḡure vazeḡa manoḡa! Ḡaeꞌa zamaḡo niduꞌa hina gau komeꞌa faine odohe gauiro ꞌahine, ne niduꞌa gaubanana ḡianeꞌeteꞌe vazeḡano ohoꞌiꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ebu tuḡure vazeḡa aheuḡaniꞌa aradu niro, 'Zuhiꞌa, ḡaeꞌa iniroteꞌe hadi silivaḡa tiba hina hadi silivaḡa fuꞌo ragate haḡairo.' ");
INSERT INTO ksj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Zuhiꞌaḡaniꞌa naenaeniro, 'Manoḡa tauḡi! Ḡa zuni ne niduꞌa fuꞌo ḡianeꞌeteꞌe vazeḡano ohoꞌiꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Rehano tuḡure vazeḡa ꞌahoganiꞌa aradu niro, 'Zuhiꞌa, ḡae hadiꞌe ꞌahi eꞌe. Eḡeꞌa mene daunoga veize dabua hina ꞌumadu ꞌuꞌuru tiro. ");
INSERT INTO ksj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ḡaꞌe vaze riḡa. Vazeꞌa tiroteꞌe ḡauḡa ḡaeꞌa maꞌohe, zu vazeꞌa ḡoraroteꞌe ḡauḡa ḡaeꞌa hiriveꞌohe. Eꞌanoꞌo e ḡa rihoꞌadu ꞌouge haḡairo.' ");
INSERT INTO ksj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Zuhiꞌaḡaniꞌa niro, 'Ḡaꞌe tuḡure vazeḡa sauꞌa! Ḡaeꞌa rateꞌe ḡoeꞌa uꞌano, e aduga ḡaniꞌuma! Ḡae zamarone, eꞌe vaze riḡa radu e vazeꞌa tiroteꞌe ḡauḡa maꞌohe zu ḡoraroteꞌe ḡauḡa hiriveꞌohe rae ederirohe? ");
INSERT INTO ksj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ꞌOugirotene, ḡa nougadu hadi tiꞌeteꞌe neḡano eḡe hadi mene tiro? ꞌOugifone, e bare aradu hadi eꞌe bare ragate meifo.' ");
INSERT INTO ksj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ebu ani vaetadu uhiḡano edaroteꞌe azaḡa ziro, 'Ani mazaonoꞌo hadi silivaḡa tiba eꞌe moꞌi, ebu hadi silivaḡa gaubanana meiroteꞌe tuḡure vazeḡa hanoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Rehano zeḡeꞌa niro, 'Zuhiꞌa, ani hadi silivaḡa gaubanana amahi meiro.' ");
INSERT INTO ksj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ani naenaeziro, 'Eḡeꞌa ziꞌohe. Iniuꞌa nagini hidiroteꞌe faine odohe gauine, ani bare borofe hidiꞌuma. Rehano iniuꞌa nagini hidiroteꞌe mene faine odohe gauine, ani mazao nagini komeꞌa zuni meiniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ebu eḡeꞌa kini rouga mene uratiroteꞌe agire azaḡa tutuze aradu eḡe zamao mau ruzoꞌi.'” ");
INSERT INTO ksj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iesuꞌa ḡoere hauḡadu ane tahiꞌatahiꞌa vitize Ierusalema uꞌa itiro. ");
INSERT INTO ksj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ebu aniꞌa Olivi Maḡano Betefage zu Betania neḡano feurirotene, ane tahiꞌa aheu tuḡuzeꞌenaꞌa ziro, ");
INSERT INTO ksj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Zama mone neḡa onamoꞌi. Eꞌe neḡa diuḡine, vazeni ꞌahoga mene ehoriroteꞌe donikiḡa ubuga batune touga horoniꞌuma. Ebu fuhiꞌadu ꞌahi zamahu aroꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Vaze ꞌahoganiꞌa, 'Nougadu fuiꞌeꞌohe?' rae ḡadizoꞌidene, 'Zuhiꞌa Boroꞌa urateꞌohe,' rae noꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ebu Iesuꞌa tuḡuziroteꞌe azaḡaniꞌa ibite ne eꞌe onamirotene, Iesuꞌa ziroteꞌe teige doniki ubuga ꞌahoga horoniro. ");
INSERT INTO ksj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ze doniki ubuga eꞌe fuhiꞌiroteꞌe zamaḡano doniki taufeꞌeteꞌe azaḡaniꞌa ḡadiziro, “Za nougadu doniki ubuga fuhiꞌeꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Zeꞌa naenaeziro, “Zuhiꞌa Boroꞌa urateꞌohe.” Ze ꞌouge reirotene doniki taufeꞌeteꞌe azaḡaniꞌa ziniro. ");
INSERT INTO ksj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ebu ze doniki ubuga tutune Iesu vaḡe aradu dabuaze doniki ubuga ḡarunio zahariro, ebu Iesuꞌa eꞌe rana tire ehoriro. ");
INSERT INTO ksj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ebu Iesuꞌa onameꞌeteꞌea, vaze ḡuḡuvaḡaniꞌa dabuaze ane ibio hiraro. ");
INSERT INTO ksj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ebu Iesuꞌa Olivi Maḡanonoꞌo ovoeꞌeteꞌe ibiḡa hanitirotene, ane hegoteꞌeteꞌe vaze ḡuḡuvaḡa niduꞌa onameꞌenaꞌa, matuꞌuzeta huaro zu Badiꞌa niguniro, mazaḡa ze Iesuꞌa haḡainuteꞌe haḡai gigiꞌaḡa niduꞌa horoniro. ");
INSERT INTO ksj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Zeꞌa ꞌahige rae reiro, “Zuhiꞌa Boro niḡano areꞌeteꞌe kiniḡaꞌe ḡihiꞌa hune! Adureo uniho manoḡa, hitana huneo Badiꞌa nigunihi!” ");
INSERT INTO ksj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Rehano vaze ḡuḡuvaḡa boꞌaḡano Farisea azaḡa nuꞌa Iesu niro, “Ihore vazeḡa, ḡa hegoteꞌeteꞌe azaḡaniꞌa ꞌouge huauꞌeteꞌe gararoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Iesuꞌa naenaeziro, “Eḡeꞌa ziꞌohe, ze sifu radiune, hadi niduꞌa ḡihau huaꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iesuꞌa Ierusalema hanitadu eꞌe horonirotene niaro. ");
INSERT INTO ksj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ebu aniꞌa reiro, “Ierusalema azaḡa, izidi zaꞌe uniho manoḡa maꞌeteꞌe ibiḡa ederifone, manoḡa reifo. Rehano izidi za eꞌe ederoga mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mada ꞌahoganiꞌa zae mazao fureraꞌuma. Eꞌe madaḡano zae agire azaḡaniꞌa raha ḡabiꞌa haḡadu merau ganaḡeḡeziꞌuma, ebu zamao haoziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Zeḡeꞌa zae haba zu haba azaḡa niduꞌa rahao zimi feuziꞌuma. Ebu zae ne ogoraroteꞌe hadiḡa niduꞌa fahe ḡuzuhadu hadini ꞌahoga hadi ꞌahoga ranao mene radiꞌuma, mazaḡa zaꞌe Badiꞌaꞌa zae vaḡe ariroteꞌe madaḡa mene ederiro.” ");
INSERT INTO ksj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ebu Iesuꞌa kuru neḡa habaꞌano diuḡadu serosero azaḡa hegoze buziro. ");
INSERT INTO ksj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ebu aniꞌa ziro, “Buka Zaḡoḡano ꞌahige rae mirihiro, 'Badiꞌa neꞌe kuru neḡa reꞌuma.' Rehano zaeꞌa kuru neḡaꞌe ḡonore azaḡa neḡano ḡihuniro.” ");
INSERT INTO ksj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ebu Iesuꞌa mada niduꞌa kuru neḡano ihoziro. Rehano dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa, Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zu vaze ibitoziꞌeteꞌe azaḡaniꞌa ani matihi reiro. ");
INSERT INTO ksj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Rehano ze ani matiteꞌe ibiḡa ꞌahoga mene horoniro, mazaḡa vaze niduꞌa Iesu ḡoere faifaine abitinu. ");
INSERT INTO ksj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mada ꞌahogano Iesuꞌa kuru neḡano ihozinu zu hari manoḡa haraminu. Eꞌe madaḡano dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa, Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zu vaze boroboroꞌa ani vaḡe onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ebu ze Iesu ḡadiniro, “Ḡa noꞌe gigiꞌaḡa hina ꞌahiguḡa haḡaeꞌohe? Iniuꞌa ꞌahi gigiꞌaḡa ḡaniro? Efoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Iesuꞌa naenaeziro, “Eḡe zuni ḡadimu ꞌahoga zinihi. ");
INSERT INTO ksj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ioaneꞌa babatiso zinirotaꞌaꞌe Badiꞌa mazaonoꞌo ga vaze mazaonoꞌo? Ehoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ze zeḡe daꞌo ḡoꞌaneꞌenaꞌa, ꞌahige rae reiro, “Badiꞌa mazaonoꞌo reine, 'Za nougadu Ioane ḡoere mene mae ḡihiniro?' rae ifiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","U vaze mazaonoꞌo reine, vaze niduꞌa hadi hina uḡufiꞌuma, mazaḡa zeḡe niduꞌa Ioaneꞌe hube hune peroveta vazeḡa rae mae ḡihineꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Eꞌanoꞌo ze ꞌahige naenaeniro, “Eme aḡuꞌa, Ioaneꞌa babatiso zinirotaꞌaꞌe iniu mazaonoꞌo ariro.” ");
INSERT INTO ksj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ebu Iesuꞌa ziro, “Eḡe zuni noꞌe gigiꞌaḡa hina haḡai ꞌahiguḡa haḡaeꞌeteꞌe mene ihoziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Iesuꞌa vaze mazao hari ꞌahi idane ziro, “Vaze ꞌahoganiꞌa vaini mebaḡa ḡoranadu hihi azaḡa nu ꞌevoreo tiro. Ebu aniꞌa haba ꞌahoga onamadu mada faḡa ragavinu. ");
INSERT INTO ksj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Vaini maḡa hiriveꞌeteꞌe madaḡaniꞌa feurirotene, vaini mebaḡa vazeḡaniꞌa vaini maḡa nu mouga radu ane tuḡure vazeḡa ꞌahoga hihi azaḡa vaḡe tuḡune onamiro. Rehano zeꞌa ani bounadu ꞌevoꞌa isoḡa tuḡune baroniro. ");
INSERT INTO ksj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Hena ani tuḡure vazeḡa ꞌahoga zeḡe vaḡe bare tuḡuniro, rehano zeꞌa ani zuni bouniro, ani mae mazagarone runiro zu ꞌevoꞌa isoḡa tuḡune baroniro. ");
INSERT INTO ksj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ebu ani tuḡure vazeḡa uḡiduḡa zeḡe vaḡe bare tuḡuniro, rehano ze ani ru hanadu uhine baroniro. ");
INSERT INTO ksj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ꞌOugadu vaini mebaḡa vazeḡaniꞌa ꞌahige rae reiro, 'E nougiꞌuma? Eḡe zamarone ubude tuḡuniꞌuma. Ze ani gubaniꞌuma gaogi.' ");
INSERT INTO ksj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Rehano hihi azaḡaniꞌa ubuga horonirotene, zeḡeꞌa ḡoꞌaneꞌenaꞌa, neneḡaniro, 'Aniꞌe moga mazaonoꞌo vaini mebaḡa ꞌadi meiteꞌe vazeḡa. Eme ani matihi, ꞌougine vaini mebaḡa ꞌadiꞌe emeḡeꞌa meꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Eꞌanoꞌo zeꞌa vaini mebaḡanonoꞌo ubuga uhine bunadu mau runiro. ꞌOugadu vaini mebaḡa vazeḡaꞌe zeḡe mazao nougiꞌuma? ");
INSERT INTO ksj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ani aradu hihi azaḡa mau ruziꞌuma ebu vaini mebaḡaꞌe vaze nu ziniꞌuma.” Vazevazeꞌa hari eꞌe egadu reiro, “Eꞌeguḡaniꞌa mene fureraune manoḡa!” ");
INSERT INTO ksj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ebu Iesuꞌa ze ḡiaḡiazadu ziro, “Tena Buka Zaḡoḡano mirihiroteꞌe ḡoeꞌa ꞌadi huga zamaroꞌi, 'Vazeꞌa hadi hina ne ogorarotene, zeꞌa mae modiroteꞌe hadiḡaꞌe ne duꞌe rinedeꞌeteꞌe hadiḡa reiro.' ");
INSERT INTO ksj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Iniuꞌa hadi eꞌe rana higaune, ani varadu tahitahiꞌuma, zu hadi eꞌeꞌa vaze ꞌahoga rana higaune, aniꞌe seꞌetiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zu dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡaꞌe Iesuꞌa zeḡe moneo hari idaidaḡa reiroteꞌe ederirotene, Iesu zogone obone tihi reiro. Rehano ze vaze ḡuḡuvaḡaniꞌa zeḡe mazao maḡuniꞌuma radu rihoziro. ");
INSERT INTO ksj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zu dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡaniꞌa Iesu obone tihi radu ḡiaḡianiro. Zeꞌe vaze duduḡa rae soꞌosoꞌozeꞌeteꞌe rihirihi azaḡa nu Iesu vaḡe tuḡuziro, mazaḡa Iesuꞌa ḡoere nu rae veꞌorine, aniꞌe Roma gavana vazeḡa ꞌevoreo riꞌinihi rae reiro. ");
INSERT INTO ksj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ebu rihirihi azaḡaniꞌa Iesu vaḡe onamadu ḡadiniro, “Ihore vazeḡa, eme edeḡa, ḡaꞌe huga daꞌo ḡoereꞌohe zu ihozeꞌohe, vaze niduꞌa mazao mene inaheꞌohe, ebu Badiꞌa mone ibiḡa hugano ihozeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Emeꞌe Roma kiniḡa mazao takesi haune, duduḡa ga mene?” ");
INSERT INTO ksj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Iesuꞌa ze ani soꞌonihi raꞌetaꞌaꞌe ederadu ziro, ");
INSERT INTO ksj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Roma hadiḡa tiba ihohoꞌi. Iniu viga zu iniu niḡa eꞌe rana mirihiro?” Zeꞌa naenaeniro, “Aꞌe Roma kiniḡa viga zu niḡa.” ");
INSERT INTO ksj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ebu aniꞌa ziro, “Tena Roma kiniḡa ḡauꞌe Roma kiniḡa hanoꞌi, u Badiꞌa ḡauꞌe Badiꞌa hanoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ꞌOugadu ze vaze zamao Iesu ḡoereꞌe veꞌoḡa rae rouga mene idararo, ebu Iesuꞌa ḡadimuze naenaeniroteꞌe uꞌano ze zaguzaganadu sifu radiro. ");
INSERT INTO ksj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadukea azaḡa nuꞌa Iesu vaḡe ariro. Zeꞌe vazeꞌa runeonoꞌo mene bare ḡabode iḡuniꞌuma rae raꞌeteꞌe azaḡa. ");
INSERT INTO ksj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ze Iesu ḡadiniro, “Ihore vazeḡa, Moseꞌa goro ḡoeꞌa ꞌahoga ꞌahige rae mirihiro, 'Ohoze ꞌahoganiꞌa rudanadu ane inugaꞌe ubuga ꞌoꞌoꞌa reine, ohoze negoḡaniꞌa ḡozobaḡa teite hahuriꞌuma, ebu ubuga furenine ubuganiꞌa rune negoḡa ehaꞌa meꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Hari ꞌahi zamaroꞌi. Nego niduꞌa fuꞌo aheu fare radiunu. Ibiꞌaniꞌa hahuriro ebu ubuga oꞌoꞌa rudaro. ");
INSERT INTO ksj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ꞌOugadu negoḡa aheuḡaniꞌa ḡozobaḡa teite hahuriro. ");
INSERT INTO ksj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ebu negoḡa uḡiduḡa zuni ani teite hahuriro. Ebu negoḡa niduꞌa fuꞌo aheu fare ḡozobaḡa teite hahuriro, rehano zeḡe niduꞌa ubudeze oꞌoꞌa rudaro. ");
INSERT INTO ksj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ḡonagano ḡozoba eꞌe zuni rudaro. ");
INSERT INTO ksj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ꞌOugadu runeonoꞌo bare ḡabode iḡuniteꞌe madaḡano roḡae aꞌe iniu inuga reꞌuma? Mazaḡa ohoze niduꞌa fuꞌo aheu fareꞌa ani teite hahuriro.” ");
INSERT INTO ksj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iesuꞌa naenaeziro, “Raha ꞌadao radiuꞌeteꞌe ohozeḡa zu roḡaeḡaꞌe hahureꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Rehano runeonoꞌo bare ḡabode iḡunadu Badiꞌa habao radoga idaḡa raꞌeteꞌe ohozeḡa zu roḡaeḡaꞌe mene hahuriꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ebu ze mene bare rudaꞌuma, mazaḡa zeꞌe tuḡure viga heuḡa. Zeꞌe runeonoꞌo ḡabodiroteꞌe azaḡa uꞌano, Badiꞌa ubuga raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Rune azaḡaniꞌa bare ḡabodeꞌeteꞌe moneo, Mose zuni ire renoga hariḡa ihoziro. Eꞌea ani Badiꞌa ꞌahige huniro, 'Aberahamo Badiꞌa, Isako Badiꞌa zu Iakobo Badiꞌa.' ");
INSERT INTO ksj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Badiꞌaꞌe mene rune azaḡa Badiꞌa, rehano ḡabone azaḡa Badiꞌa. Zeḡe niduꞌaꞌe Badiꞌa veize ḡabodeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ebu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa nuꞌa naenaeniro, “Ihore vazeḡa, ḡae naenaeꞌe manoḡa tauḡi!” ");
INSERT INTO ksj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Eꞌe enogano ze Iesu mene bare inare ḡadiniro. ");
INSERT INTO ksj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ebu Iesuꞌa ziro, “Nougadu vazeꞌa Kerisoꞌe Davida mariga raꞌohe? ");
INSERT INTO ksj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Davidaꞌa Keriso moneo Salamo bukaḡano ꞌahige rae mirihiro, 'Badiꞌaꞌa eḡe Zuhiꞌa Boro niro, “Eḡe edaꞌe moneo ehoroꞌi, ");
INSERT INTO ksj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","onamo eḡeꞌa agireḡo niduꞌa madu odaḡo ꞌuꞌuḡano raharahaziꞌuma.”' ");
INSERT INTO ksj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davidaꞌa Keriso mazao, 'Zuhiꞌa Boro,' rae huniro. Tena Kerisoꞌe nougenouge Davida mariga reꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Vaze niduꞌa Iesu ḡoere abitiroteꞌea, Iesuꞌa ane tahiꞌatahiꞌa ziro, ");
INSERT INTO ksj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa ḡiazoꞌi. Ze dabua manoḡa faḡa vidau ragavoga, vaze ḡehaḡa habaꞌano vazeꞌa ze gubazeꞌenaꞌa, zeḡe mazao unihoga, nuꞌonuꞌo neḡano vaze boroboroꞌa ehoreꞌeteꞌe habaꞌano ehoroga, zu muio nize boro azaḡaniꞌa ehoreꞌeteꞌe habaꞌano ehoroga urateꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ebu zeꞌe ḡozoba soꞌozadu toheze niduꞌa meizeꞌohe, zu vaze ihozifine faḡafe ḡurire kurauꞌohe. ꞌUguḡa azaḡaꞌe aduga boro bagaḡa hidiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iesuꞌa kuru neḡano maꞌora azaḡaniꞌa ḡahunone mauḡa zamaḡano zeḡe ḡahunone ufiꞌeteꞌe horoziro. ");
INSERT INTO ksj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ebu zahara ḡozobaḡa ꞌahoganiꞌa kopa hadiḡa komeꞌa aheu ufiroteꞌe zuni horoniro. ");
INSERT INTO ksj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ebu Iesuꞌa ziro, “Eḡeꞌa hube hune ziꞌohe, zahara ḡozobaḡa ꞌadaꞌa vaze niduꞌa ufeta vitize hadi boro ofeha. ");
INSERT INTO ksj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Zeḡe niduꞌaꞌe hadize ḡehaḡa rehano, tahiḡa daꞌo ofeha. U ḡozoba ꞌadiꞌe zahara roḡaeḡa, rehano ane hadiḡa niduꞌa ebu ane ogomu hadiḡa niduꞌa ofeha.” ");
INSERT INTO ksj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Iesu tahiꞌa nuꞌa kuru neḡa horonadu aꞌe hadi manoḡa zu Badiꞌa haroteꞌe ḡahunoneḡa hina rohorohoniroteꞌe moneo niguniro. Rehano Iesuꞌa ziro, ");
INSERT INTO ksj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Izidi zaeꞌa horoneꞌeteꞌe ḡauḡa niduꞌaꞌe fahe ḡuzuhiteꞌe madaḡaniꞌa ariꞌuma. Eꞌe madaḡano hadini ꞌahoga hadi ꞌahoga rana mene radiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ꞌOugadu ze Iesu ḡadiniro, “Ihore vazeḡa, eꞌeguḡaniꞌa naniꞌa fureraꞌuma? Ebu eꞌeguḡaniꞌa nariga fureranateꞌe madaḡanoꞌe nagi haḡai nu badeḡaniꞌa ibite fureraꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Aniꞌa naenaeziro, “Vaze ꞌahoganiꞌa zae mene soꞌosoꞌozifine tohutohoꞌi. Vaze ḡehaḡaniꞌa eḡe niḡano aradu ꞌahige reꞌuma, 'Eꞌe Keriso,' ebu 'Madaḡa ꞌai haniteha!' Rehano ze ago hegotoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Uti zu roteto hariḡa egoꞌidene, ago rihanoꞌi. Eꞌeguḡaniꞌa hube hune ibite fureraꞌuma, rehano mada ḡonagaꞌe zogone mene ariꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ebu aniꞌa ziro, “Haba ꞌahoganiꞌa haba ꞌahoga teite utitiꞌuma, zu gavamani ꞌahoganiꞌa gavamani ꞌahoga teite utitiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Haba nunuo habaꞌa borofe hagariꞌuma, zagaꞌa hiaꞌuma zu ugi boroꞌa fureraꞌuma. Ebu adureonoꞌo riho ḡauḡa zu haḡai nu badeḡa boroboroꞌa fureraꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Rehano eꞌeguḡaniꞌa ꞌizema fureranogano, vazevazeꞌa za oboze teadu sausauziꞌuma, ebu nu'onu'o neḡano zu ḡuꞌa neḡano ohoze tiꞌuma. Eḡe uꞌano, kini zu gavana azaḡa mazao zae tutuze onamiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Aꞌe zaeꞌa zeḡe mazao eḡe hari manoḡa rae fureniteꞌe madaḡa reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Eꞌanoꞌo zamaze rinedadu nougenouge zae bare biriteꞌe moneo zamaze ago ibite adudanoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mazaḡa eḡeꞌa ḡoere zu zamarone huhuzaḡa zenadu agireze ꞌahoganiꞌa zuni zae mene agatoziꞌuma ebu zae ḡoere mene hezahohaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Zae vize moze, negoze, nabudize zu zae vazeꞌa zuni za revoziniꞌuma, ebu zae boꞌaḡano nuꞌe runeo tuḡuziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Eḡe uꞌano vaze niduꞌa za heꞌeheꞌeziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Rehano iguze tiba zuni mene dauniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Zaeꞌa edau gigaraune, ḡabone hidiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ierusalemaꞌe uti azaḡaniꞌa ganaḡeḡenoga horonoꞌidene, aꞌe Ierusalema ruiniteꞌe madaḡa ꞌai haniteha rae ederiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Eꞌe madaḡano Iudea habaꞌano radiuꞌeteꞌe azaḡaꞌe maḡa ferau itoꞌi. Ierusalema zamaḡano radiuꞌeteꞌe azaḡaꞌe ferau vaḡinoꞌi, ebu guniꞌa neḡano radiuꞌeteꞌe azaḡaꞌe Ierusalema ago diuḡoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mazaḡa eꞌe madaḡaꞌe Buka Zaḡoḡano mirihiroteꞌe ḡoeꞌa niduꞌa hudanadu Ierusalema azaḡa aduga boro ziniteꞌe madaḡa reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Eꞌe madaḡano ahiꞌeta roḡaeḡa zu nune hina ene guraḡa ḡubuzeꞌeteꞌe roḡaeḡaꞌe feranoga mene idaḡa radu aduga boro hidiꞌuma! Raha ꞌahao aduga boro bagaḡaniꞌa fureraꞌuma, ebu Badiꞌa zama ḡugiꞌa vaze mazao fureraꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Zeꞌe benisi hina zimi ruziꞌuma, ebu ḡuꞌa azaḡa teige oboze teadu ꞌavoꞌa habaꞌa nunu tutuze onamiꞌuma. Iuda mene azaḡaniꞌa Ierusalema ruinadu zuhiꞌaniꞌuma, onamo zeḡe madaꞌa hauḡiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ebu mada, bato zu buzuva ragano haḡai nu badeḡa horoniꞌuma. Raha ꞌada haba nunu azaḡaniꞌa davara zu saꞌu boroboro guguḡa uꞌano, rihau rudaꞌuma ebu zamazeꞌa ꞌadaꞌadiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Vazeꞌa nagini rahao ꞌada fureratitaꞌaꞌe edereꞌe ꞌahine, rihau rudanadu higau bauriꞌuma, mazaḡa adure gigiꞌaḡaniꞌa hagahagariꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Eꞌe madaḡano ze Vaze Ubuganiꞌa gigiꞌaḡa boro zu agaḡa boro hune madu ḡoze hina areꞌeteꞌe horoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ꞌAhiguḡaniꞌa ḡadahe fureranoꞌidene, iḡunadu dude ehamanoꞌi, mazaḡa Badiꞌaꞌa zae ḡaboziteꞌe madaḡa ꞌai haniteha.” ");
INSERT INTO ksj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ebu Iesuꞌa hari ꞌahoga idane ziro, “Figi ireḡa zu ire nunu ḡianoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Za zaeꞌa bare ire rouḡaniꞌa udufaꞌoga horoneꞌetene, irugu madaḡaniꞌa haniteha rae edereꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Eꞌe teige, ꞌahiguḡaniꞌa fureranoga horonoꞌidene, Badiꞌaꞌa zuhiꞌaziꞌeteꞌe madaḡaniꞌa haniteha rae ederoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Eḡeꞌa hube hune ziꞌohe, izidi egaꞌe mene hauḡiꞌuma, onamo ꞌahiguḡa niduꞌa fureraꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Adure zu rahaꞌe hauḡiꞌuma, rehano eḡe ḡoereꞌe mene hune hauḡiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Zaꞌe ufeta reꞌoreꞌeteꞌe zu gageꞌeteꞌe ebu ḡaboneze zamare borofeꞌeteꞌe uꞌano, zamaze mene adudafine tohutohoꞌi. Ebu zaꞌe eḡeꞌa bare areꞌeteꞌe madaḡano mene zaguzagafine zae bare ḡiazoꞌi, mazaḡa eꞌe madaḡaꞌe ꞌahiri miniḡaniꞌa mani tabara ꞌahiriniꞌeteꞌe teigiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Eꞌe madaḡaniꞌa raha ꞌada vaze niduꞌa mazao fureraꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Eꞌanoꞌo aduganiꞌa fureratiteꞌe madaḡano feranoga zu Vaze Ubuga zamao edanoga veize, mada niduꞌa kurauꞌenaꞌa tohutohe radoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mada niduꞌa Iesuꞌe kuru neḡano ihozinu, u ohere niduꞌaꞌe vaḡinadu Olivi Maḡa rae huneꞌeteꞌe maḡano radiunu. ");
INSERT INTO ksj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ebu oherebau uzeuze vaze niduꞌa Iesu ḡoere abitoga veize kuru neḡa onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Isiti Oꞌoꞌa ꞌUvauḡa Odoga Muiḡa, niḡa ꞌahogaꞌe Iḡine Modiroteꞌe Muiḡa madaḡaniꞌa hanitiro. ");
INSERT INTO ksj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡaniꞌa Iesu matiteꞌe ibiḡa nu vaḡiro, mazaḡa ze vaze ḡuḡuvaḡaniꞌa maḡuniꞌuma radu rihoziro. ");
INSERT INTO ksj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Isakariota vazeḡa, niḡa Iudaꞌe Iesu tahiꞌa gaubanana aheu fare boꞌaḡano tahiꞌa ꞌahoga. Sataniꞌa ane zama diuḡiro. ");
INSERT INTO ksj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Aniꞌa dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu kuru neḡa uti vazeḡa boroboro vaḡe onamadu zeḡe ꞌevoreo Iesu riꞌiniteꞌe ibiḡa ḡoꞌane vaḡiro. ");
INSERT INTO ksj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ze matuꞌe rudanadu Iuda hadi haꞌuma rae ḡoitoriro. ");
INSERT INTO ksj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Iudaꞌa zuni, “Idaḡa,” radu vaze ḡuḡuvaḡa oꞌoꞌa madaḡano Iesu riꞌinoga veize mada manoḡa ꞌahoga vaḡiro. ");
INSERT INTO ksj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Isiti Oꞌoꞌa ꞌUvahuḡa Odoga Muiḡa zamaḡano mada ibiꞌaꞌe Iḡine Modiroteꞌe Muiḡa. Eꞌe madaḡano dibuꞌo mamoeḡa ubuga maro. ");
INSERT INTO ksj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Eꞌe madaḡa meirotene, Iesuꞌa Petero zu Ioane tuḡuzeꞌenaꞌa, ziro, “Onamadu emeḡe veize Iḡine Modiroteꞌe Muiḡa ogomuḡa ruhibe toꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ebu zeꞌa ḡadiniro, “Ḡa urao eme nouma ruhibe tiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Aniꞌa naenaeziro, “Ne boro diuḡine, ohoze ꞌahoganiꞌa vu ḡoḡoreḡa odohe onameꞌeteꞌe horoniꞌuma. Ebu ani hegotadu aneꞌa diuḡeꞌeteꞌe neḡa diuḡoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Diuḡadu eꞌe ne vazeḡa noꞌi, 'Ihore vazeḡaniꞌa ꞌahige raꞌohe: E eḡe tahiꞌatahiꞌa teite Iḡine Modiroteꞌe Muiḡa ogomuḡa atihi. Iꞌudo azaḡa veize ruhibiroteꞌe habaꞌaꞌe noumao?' ");
INSERT INTO ksj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ꞌOugine, aniꞌa ne hitagano bazuni neḡa boro ꞌahoga ihoziꞌuma, zu zaꞌe ehoro habaꞌa ruhibe teateꞌe horoniꞌuma. Eꞌea ogomufe ruhibe toꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ze iḡunadu onamiro, ebu Iesuꞌa ziroteꞌe idunane niduꞌa horoniro. ꞌOugadu Iḡine Modiroteꞌe Muiḡa ruhibe tiro. ");
INSERT INTO ksj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Madaḡaniꞌa feurirotene, Iesu apostolo azaḡa teite ogomu fataḡa uhiḡano ehoriro. ");
INSERT INTO ksj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ebu aniꞌa ziro, “E ꞌizema aduga hidogano, zae teite Iḡine Modiroteꞌe Muiḡa ogomuḡa ꞌadi anoga hube hune uratiro. ");
INSERT INTO ksj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mazaḡa eḡeꞌa ziꞌohe, eꞌe Mui ogomuḡa ꞌahiꞌe mene bare aꞌuma, onamo Badiꞌaꞌa zuhiꞌaziꞌeteꞌe madaḡano Iḡine Modiroteꞌe Muiḡaniꞌa hugano fureraꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ebu aniꞌa vaini vuḡa bioḡa madu Badiꞌa mazao kuraro ebu ziro, “Bio ꞌahi madu zaꞌe tahitahe gagoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mazaḡa eḡeꞌa ziꞌohe, eꞌe vaini vuḡa mene bare gagiꞌuma, onamo Badiꞌaꞌa zuhiꞌaziꞌeteꞌe madaḡaniꞌa ariꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ebu ani ꞌuvahu odoga meiro zu Badiꞌa mazao kuranadu vahege ziniro, ebu ziro, “ꞌUvahu odoga ꞌahiꞌe zae veize moditeꞌe ahirihe. Zaeꞌa eḡe zamarifine iḡaiḡa ꞌahi haḡaoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ebu ḡorava ogomuḡa enogano ani vaini vuḡa bioḡa madu ziro, “Vaini vuḡa bioḡa ꞌahiꞌe eḡeꞌa zae veize beꞌuneꞌeteꞌe ruhe hina ohoneꞌeteꞌe ḡoitoreḡa iziga. ");
INSERT INTO ksj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Rehano eḡe revoniteꞌe vazeḡaꞌe eḡe teite ogau tiburuꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Vaze Ubugaꞌe Badiꞌa urao rudaꞌuma. Rehano ani revohatiteꞌe vazeḡaꞌe aduga boro hidiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ꞌOugadu ze zeḡeꞌa bare ḡadimutitiro, “Emeḡe boꞌaḡano iniuꞌa ꞌougiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ebu Iesu tahiꞌatahiꞌa boꞌaḡano iniuꞌe ḡihiꞌa hune radu ze zeḡeꞌa bare taꞌirotitiro. ");
INSERT INTO ksj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Iesuꞌa ziro, “Badiꞌa aḡuꞌa azaḡa habaꞌano kini niduꞌaꞌe zeḡe haba azaḡa riḡa zuhiꞌaziꞌohe. Ebu inaraze hina zeḡe haba azaḡa rana edauꞌeteꞌe azaḡaꞌe zeḡeꞌa bare 'Duꞌu Vazeḡa' rae huzeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Rehano za ze ago teigoꞌi. Zae boꞌaḡano vaze ḡihiꞌaḡa huneꞌe tahiꞌa komeꞌa teigiꞌuma, ebu iniu zuhiꞌaziꞌeteꞌe vazeḡaꞌe tuḡure vazeḡa teigiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Iniuꞌe ufeta ḡihiꞌaḡa? Ehore ogauꞌeteꞌe vazeḡa ga tuḡure vazeḡa? Aꞌe ehore ogauꞌeteꞌe vazeḡa. Rehano eꞌe zae boꞌaḡano tuḡure vazeḡa heuḡa. ");
INSERT INTO ksj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Zaꞌe eḡeꞌa aduga hidiroteꞌe zamaḡano eḡe teite radiroteꞌe azaḡa. ");
INSERT INTO ksj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Eꞌanoꞌo eḡe Mamaꞌa ḡau niduꞌa zuhiꞌaziꞌeteꞌe gigiꞌaḡa iniroteꞌe teige, eḡeꞌa zae zuni eꞌe gigiꞌaḡa ziniꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ebu zaꞌe eḡeꞌa zuhiꞌaziꞌeteꞌe zamaḡano eḡe teite ogaꞌuma zu gagiꞌuma, ebu kini ehoro habaꞌano ehoradu Isaraela azaḡa, urabo niduꞌa gaubanana aheu fare kotaziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ebu Iesuꞌa Simona niro, “Simona, Simona, ꞌadi egoꞌi. Sataniꞌa vuidi zuizuineꞌeteꞌe teige, zae zama tuhunoga veize Badiꞌa uminiro. ");
INSERT INTO ksj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Rehano ḡaeꞌa eḡe mazao fieꞌeteꞌeꞌa mene dauḡifine, e ḡae veize kuraro. Eꞌanoꞌo ḡaeꞌa ḡihuradu eḡe vaḡe bariteꞌe madaḡano negoḡo duḡuru inarazoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peteroꞌa naenaeniro, “Zuhiꞌa Boro, eꞌe ḡae teite ḡuꞌa neḡano diuḡiꞌuma, ebu ḡae teite rudaꞌuma zuni idaḡa!” ");
INSERT INTO ksj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Iesuꞌa niro, “Petero, eḡeꞌa ḡaꞌohe, izidi ohere kokorokuꞌa ꞌizema uganogano, ḡaeꞌa ḡae uḡidu oꞌoheꞌenaꞌa, e aḡuꞌa rae reꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ebu Iesuꞌa ane tahiꞌatahiꞌa ziro, “Zaeꞌa eḡe gau haḡaoga veize tuḡuziroteꞌe madaḡano zaꞌe hadi fuseḡa, nihara ebu tamaka mene odohe onamiro. Eꞌe madaḡano ḡau ꞌahoga ferezirohe?” Zeḡeꞌa naenaeniro, “Mene.” ");
INSERT INTO ksj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Aniꞌa ziro, “Izidi zaꞌe hadi fusezeta zu niharazeta roꞌidene, eꞌe moꞌi. Ebu zaꞌe benisize oꞌoꞌa roꞌidene, dabuaze seronadu eꞌe hoitoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Buka Zaḡoḡano ꞌahige rae mirihiro, 'Vazevazeꞌa aniꞌe ḡonore azaḡa boꞌaḡano ꞌahoga rae zamariꞌuma.' Eḡeꞌa ziꞌohe, eꞌe ḡoeꞌaniꞌa eḡe mazao hudaꞌuma. Hube hune eḡe moneo mirihiroteꞌeꞌa izidi hudauꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Zeḡeꞌa naenaeniro, “Zuhiꞌa Boro, emeḡe mazaoꞌe benisi aheu.” Iesuꞌa ziro, “Ahiḡa.” ");
INSERT INTO ksj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ebu Iesuꞌe iḡaiḡa haḡainuteꞌe teige, Olivi Maḡa onamiro zu ane tahiꞌatahiꞌaꞌa ane hegotiro. ");
INSERT INTO ksj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Aniꞌa eꞌe habaꞌano feuradu ziro, “Sataniꞌa tuhuzadu zaeꞌa mene uitifine kuranoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ebu Iesuꞌa ze modadu tahiḡa mobade onamiro ebu obena hina tuḡadu kuraro, ");
INSERT INTO ksj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Mama, ḡa uratoꞌidene, eḡe mazaonoꞌo bio aduga ꞌadi mae vaḡinoꞌi. Rehano eḡe mene urao, ḡae urao daꞌo haḡaoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Eꞌe madaḡano tuḡure viga ꞌahoganiꞌa adureonoꞌo ane vaḡe ovadu inaraharo. ");
INSERT INTO ksj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ani zamaḡa ufeta adudanadu zamaḡa niduꞌa hina ufeta inare kuraro. Eꞌanoꞌo irairaḡaniꞌa ru teige rahao sore buaro. ");
INSERT INTO ksj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ebu Iesuꞌa kuru hauḡadu ane tahiꞌatahiꞌa vaḡe bare onamirotene ze bazeꞌeteꞌe horoziro, mazaḡa zamaze ufeta aradu ahirizeꞌa taoraro. ");
INSERT INTO ksj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Eꞌanoꞌo aniꞌa ziro, “Za nougadu baze radiuꞌohe? Iḡunoꞌi, ebu Sataniꞌa tuhuzadu zaeꞌa mene uitifine kuranoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iesuꞌa ꞌize ḡoereꞌeteꞌea, vaze ḡuḡuvaḡaniꞌa ani vaḡe ariro. Ebu Iesu tahiꞌa gaubanana aheu fare boꞌaḡano ꞌahoga, Iudaꞌa ibitadu Iesu furaꞌinoga veize ani uhiḡa ariro. ");
INSERT INTO ksj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Rehano Iesuꞌa niro, “Iuda, ḡaꞌe Vaze Ubuga furaꞌinadu revohatihi raꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Iesu tahiꞌatahiꞌaꞌe naginiꞌa fureruꞌeteꞌe horonadu Iesu niro, “Zuhiꞌa Boro, eme benisi hina utitoziniꞌumahe?” ");
INSERT INTO ksj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ebu zeḡe boꞌaḡano ꞌahoganiꞌa benisi ahase bunadu dibuꞌo vazeḡa ḡihiꞌaḡa tuḡure vazeḡa udirotene, edaꞌe teḡaḡa variꞌe butiro. ");
INSERT INTO ksj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Rehano Iesuꞌa niro, “Ago ꞌougoꞌi!” Ebu Iesuꞌa vaze eꞌe teḡa obonadu fainiro. ");
INSERT INTO ksj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ebu Iesuꞌa ani obone touga veize ariroteꞌe dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa, kuru neḡa vazeḡa boroboro zu vaze boroboro ziro, “Zaꞌe ḡonore vazeḡa obone tiꞌeteꞌe teige, benisi ebu somori boro madu eḡe obohe touga veize arahe? ");
INSERT INTO ksj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mada niduꞌa eꞌe zae teite kuru neḡa habaꞌano radiunu. Eꞌe madaḡano zaꞌe mene obohe tiro. Rehano izidiꞌe zae madaḡa zu uzaboꞌa zuhiꞌaziꞌeteꞌe madaḡa.” ");
INSERT INTO ksj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Zeꞌa Iesu obone teadu dibuꞌo vazeḡa ḡihiꞌaḡa ne tutune onamiro. U Peteroꞌe faḡanonoꞌo zeḡe ḡaruna hegotiro. ");
INSERT INTO ksj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Vaze nuꞌa eꞌe ne habaꞌa nemaḡano ire roga hofadu ehore ḡeḡemaḡiro. Petero zuni zeḡe teite ehoriro. ");
INSERT INTO ksj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ꞌOugirotene, tuḡure roḡaeḡa ꞌahoganiꞌa Peteroꞌe ire roga genaḡano ehoreꞌeteꞌe horoniro. Ani Petero ḡiane runeꞌenaꞌa reiro, “Vaze ꞌadi zuni Iesu teite radiudo.” ");
INSERT INTO ksj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Rehano Peteroꞌa oꞌonadu niro, “Roḡae, e ani aḡua.” ");
INSERT INTO ksj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mada tahiḡa enogano vaze ꞌahoganiꞌa horonadu niro, “Ḡa zuni Iesu hegoteꞌeteꞌe azaḡa boꞌaḡano ꞌahoga.” Rehano Peteroꞌa niro, “Ohoze, eꞌe mene!” ");
INSERT INTO ksj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mada tahiḡa ḡarugano, vaze ꞌahoganiꞌa barebare ḡoeriro, “Vaze ꞌadi hube hune Iesu teite radiudo, mazaḡa ani zuni Galilea vazeḡa.” ");
INSERT INTO ksj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Rehano Peteroꞌa naenaeniro, “Ohoze, e ḡaꞌa nagini raꞌetaꞌaꞌe aḡuꞌa!” Peteroꞌa ꞌize ḡoereꞌeteꞌea, kokorokuꞌa ugaro. ");
INSERT INTO ksj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Zuhiꞌa Boroꞌa vaetadu Petero ḡianiro. ꞌOugadu Peteroꞌe Zuhiꞌa Boroꞌa ꞌahige rae niroteꞌe zamariro, “Izidi ohere kokorokuꞌa ꞌizema uganogano, ḡaꞌa ḡae uḡidu eḡe oꞌohiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ebu aniꞌa ne enona buanadu niau rudaro. ");
INSERT INTO ksj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Iesu ḡiane radiuꞌeteꞌe azaḡaniꞌa ani ḡirihoharo zu bouniro. ");
INSERT INTO ksj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ze ani ubuma ꞌuadu ḡadiniro, “Peroveta vazeḡa, iniuꞌa ḡa bouꞌeha? Efoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ebu ze ḡoere nunu hina ani rae sausauniro. ");
INSERT INTO ksj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Irarirotene, dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡaniꞌa nuꞌoranadu vaze boroboroꞌa ibitohauꞌeteꞌe kotaḡano ḡoꞌaniro. Ebu Iesuꞌe zeḡe kotao tutune mae ohoniro. ");
INSERT INTO ksj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ebu zeꞌa niro, “Ḡaꞌe Keriso roꞌidene, efoꞌi.” Iesuꞌa naenaeziro, “Eḡeꞌa, 'Oꞌe,' rae zine zuni, zaꞌe eḡe ḡoere mene mae ḡihiniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ebu eḡeꞌa, 'E Kerisohe?' rae ḡadizine zuni, zaꞌe mene naenaehiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Rehano izidionoꞌo onamo zama mone Vaze Ubuganiꞌa Gigiꞌaḡa Boro Badiꞌaḡa edaꞌe moneo ehoriꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Zeḡe niduꞌa ḡadiniro, “Tena ḡaꞌe Badiꞌa Ubugahe?” Aniꞌa ziro, “Za zaeꞌa bare eꞌe Keriso rae raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ebu ze zeḡeꞌa bare neneḡaniro, “Eme aniꞌe veꞌoḡa rae raꞌeteꞌe vazeḡa bare vaḡiꞌumahe? Emeḡeꞌa ane hebeonoꞌo ḡoere veꞌoḡa rateꞌe egeha!” ");
INSERT INTO ksj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ebu kota azaḡa niduꞌa iḡunadu Iesu Pilato vaḡe tutune onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Zeḡeꞌa Pilato mazao Iesuꞌe veꞌoḡa rae fureniro, “Vaze ꞌadiꞌe emeḡe ne azaḡa soꞌozadu ibi veꞌoḡano tutuzeꞌohe. Roma kiniḡa mazao takesi hauꞌeteꞌe garareꞌohe, zu ani aneꞌa bare raenaꞌa, 'Eꞌe Keriso, kini,' rae raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Eꞌanoꞌo Pilatoꞌa Iesu ḡadiniro, “Ḡaꞌe Iuda azaḡa kinihe?” Iesuꞌa naenaeniro, “Oꞌe, ḡa ḡaeꞌa bare eꞌe kini rae raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ꞌOugadu Pilatoꞌa dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu vaze ḡuḡuvaḡa ziro, “E ani mazaonoꞌo veꞌoḡa ꞌahoga mene horoneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Rehano ze teꞌoteꞌau ḡoeriro, “Aniꞌe Galilea habaꞌanonoꞌo Iudea habaꞌa niduꞌa onamo Ierusalema ꞌahi zuni vaze ḡehaḡa ihozeꞌenaꞌa, ibi veꞌoḡano tutuzeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatoꞌa ḡoereze egadu ḡadiziro, “Iesuꞌe Galilea vazeḡahe?” ");
INSERT INTO ksj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ani Iesuꞌe kini Herodaꞌa ḡianeꞌeteꞌe Galilea habaꞌa vazeḡa rae ederadu ani Heroda vaḡe tuḡuniro. Eꞌe madaḡano Herodaꞌe Ierusalema zamaḡano radiunu. ");
INSERT INTO ksj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodaꞌa Iesu horonirotene, matuꞌe rudaro, mazaḡa ani amahionoꞌo Iesu ḡianihi reiro, zu Iesu hariḡa igiro ꞌahine, Iesuꞌa haḡai gigiꞌa haḡaoga horonihi reiro. ");
INSERT INTO ksj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Eꞌanoꞌo Herodaꞌe ḡadimu ḡehaḡa Iesu ḡadiniro, rehano Iesuꞌa mene naenaeniro. ");
INSERT INTO ksj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Eꞌea edau radiuꞌeteꞌe dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡaniꞌa Iesu ꞌuteꞌenaꞌa, ufeta rae sausauniro. ");
INSERT INTO ksj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heroda zu ane uti azaḡaꞌe Iesu rae sausauniro zu ḡirihoharo. Ebu dabua manoḡa vidohanadu Pilato vaḡe bare tuḡune onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ibite Heroda ebu Pilatoꞌe agirotitido, rehano eꞌe madaḡanoꞌe vazetitiro. ");
INSERT INTO ksj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatoꞌa dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa, vaze boroboro ebu haba azaḡa huze nuꞌoziro. ");
INSERT INTO ksj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ebu aniꞌa ziro, “Zaꞌe vaze ꞌadaꞌa haba azaḡa ibi veꞌoḡano ibitoziro radu tutune areha. Rehano eḡeꞌa zae zamao ani ḡadinatene, zaeꞌa ane moneo rateꞌe veꞌoḡa ꞌahogani mene horoneha. ");
INSERT INTO ksj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Heroda zuni ani mazaonoꞌo veꞌoḡani ꞌahoga mene horonadu emeḡe vaḡe bare tuḡune areha. Hube hune, ani mazaoꞌe runeo tuḡuniteꞌe veꞌoḡani ꞌahogaꞌe oꞌoꞌa. ");
INSERT INTO ksj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Eꞌanoꞌo eḡeꞌa ani masinadu tuḡune buniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Rehano vaze ḡuḡuvaḡa niduꞌa huau iḡuniro, “Vaze ꞌadiꞌe manoꞌi, u Barabasiꞌe tuḡune bunoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabasiꞌe Ierusalema zamaḡano Roma gavamani utitoziniro zu vaze zimiro ꞌahine, ḡuꞌa neḡano ohoniro. ");
INSERT INTO ksj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","U Pilatoꞌe Iesu tuḡune bunihi radu bare ziro. ");
INSERT INTO ksj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Rehano ze ḡihau huaro, “Ani satauronoꞌi! Satauronoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ebu Pilatoꞌa ḡae uḡiduḡano ziro, “Ani nagi veꞌoḡa haḡairo? E ani rune moneo tuḡuniteꞌe veꞌoḡani ꞌahoga mene horoneha. Eꞌanoꞌo e ani masinadu tuḡune buniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Rehano vaze ḡuḡuvaḡaniꞌa Iesu satauronoga veize ḡihau teꞌoteꞌau huaro. ꞌOugadu zeḡe agoꞌe ane ago ufeta vitiniro. ");
INSERT INTO ksj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Eꞌanoꞌo Pilatoꞌe zeḡe ura haḡaiꞌuma rae reiro. ");
INSERT INTO ksj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ebu ani zeḡeꞌa uminiroteꞌe teige, Roma gavamani utitoziniroteꞌe zu vaze goruziroteꞌe vazeḡa, Barabasi ḡuꞌa neḡanonoꞌo mae buniro. U zeḡe urao Iesuꞌe satauronoga veize uti azaḡa ꞌevoreo riꞌiniro. ");
INSERT INTO ksj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Uti azaḡaniꞌa Iesu tutune onamiroteꞌea, Kurene vazeḡa ꞌahoga niḡa Simona hidiro. Ze aniꞌa guniꞌa neḡanonoꞌo areꞌeteꞌe ibiḡano obonadu Iesu satauro mae heratoharo, ebu Iesu ḡaruna hegotoga veize tuḡutuḡuniro. ");
INSERT INTO ksj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Vaze ḡuḡuvaḡaniꞌa zuni Iesu hegote onamiro. Zeḡe boꞌaḡano roḡaeroḡaeꞌa Iesu vetuḡaneadu niau kuaro. ");
INSERT INTO ksj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iesuꞌa tehadu ziro, “Ierusalema aboḡaaboḡa, eḡe uꞌano ago nianoꞌi, rehano za zu ubudeze veize nianoꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mazaḡa aduga boro hiditeꞌe madaḡaniꞌa arine, vaze niduꞌa ꞌahige reꞌuma, 'Gabani roḡaeḡa, ene mene hune fureniroteꞌe roḡaeḡa, zu nune hina ene mene hune ḡubuziroteꞌe roḡaeḡaꞌe manoḡa tauḡi!' ");
INSERT INTO ksj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Eꞌe madaḡano ze maḡa niꞌuma, 'Emeḡe rana iḡau buanoꞌi!' ebu maḡa komeꞌa niꞌuma, 'Fahanadu emeḡe ḡahifoꞌi!' ");
INSERT INTO ksj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Eꞌe ire ḡaboga heuḡa, rehano zaeꞌa satauroheꞌohe. ꞌOugine za, ire roḡa azaḡa, aduga ufeta boro hidiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ḡonore azaḡa aheu zuni Iesu teite zemoga radu tutuze onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ebu zeꞌe Vadini Isiga rae huneꞌeteꞌe habaꞌano feuriro. Eꞌea Iesu zu ḡonore azaḡa aheu satauroziro. Vaze ꞌahogaꞌe Iesu edaꞌe moneo zu ꞌahogaꞌe kauri moneo ikokoziro. ");
INSERT INTO ksj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ebu Iesuꞌa satauronoꞌo reiro, “Mama, zeḡe haḡai sauꞌa aḡutu modoꞌi, mazaḡa zeꞌe nagini haḡaeꞌetaꞌaꞌe aḡuꞌa.” Ze kaḡusi arahoḡa arahadu Iesu dabua ḡahugotitiro. ");
INSERT INTO ksj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Vaze ḡuḡuvaḡaniꞌa edanadu muririnu. U vaze ibitoziꞌeteꞌe azaḡaꞌe Iesu ḡirihohauꞌenaꞌa ḡoeriro, “Ani vaze nunu ḡaboziro. Aniꞌe Keriso, Badiꞌaꞌa ohotiroteꞌe vazeḡa reine, ani aneꞌa bare ḡaboniꞌuma!” ");
INSERT INTO ksj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Uti azaḡaniꞌa zuni ani vaḡe aradu rae sausauniro ebu vaini vuḡa ḡiḡiꞌa gagoharo. ");
INSERT INTO ksj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ebu zeḡeꞌa niro, “Ḡaꞌe Iuda azaḡa kini roꞌidene, ḡa ḡaeꞌa bare ḡaboꞌoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Iesu satauro hitaganoꞌe ane haḡai sauꞌaꞌe nagini rae ihozifine ꞌahige rae mirihiro, “ꞌADIꞌE IUDA AZAḠA KINI.” ");
INSERT INTO ksj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Iesu teite satauroniroteꞌe ḡonore vazeḡa ꞌahoganiꞌa zuni ani rae sausauniro, “Ḡaꞌe mene Kerisohe? Ḡa ḡae bare zu emeḡe ḡabofoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Rehano ḡonore vazeḡa ꞌahoganiꞌa ḡonore vazeḡa ꞌomo roniro, “Ḡa Badiꞌa mene rihoneꞌehe? Ḡae zuni ane teite idaḡa runeo tuḡuzeha. ");
INSERT INTO ksj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Emetaneꞌe emeḡe haḡai sauꞌa uꞌano eꞌe naeḡa aduga hideꞌohe, rehano vaze ꞌadiꞌe haḡai sauꞌa ꞌahogani mene haḡairo.” ");
INSERT INTO ksj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ebu aneꞌa Iesu niro, “Iesu, ḡaeꞌa zuhiꞌaziꞌeteꞌe habaꞌa diuḡoꞌidene, eḡe zuni zamaroꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Iesuꞌa naenaeniro, “Eḡeꞌa hube hune ḡaꞌohe, izidi ḡaꞌe eḡe teite Badiꞌa habao radiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Madai kirikiri meirotene, haba niduꞌa uzaboꞌa ꞌuiro, onamo ḡorava mone mada uḡidu. ");
INSERT INTO ksj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Mada mene hiaro, ebu kuru neḡano Haba Zaḡoḡa Hune ꞌueꞌeteꞌe dabuaḡaniꞌa nemao zigau ꞌaꞌadaro. ");
INSERT INTO ksj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ebu Iesuꞌa agoḡa boro hina ḡihau huaro, “Mama, eḡe vineꞌe ḡae ꞌevoreo tiꞌohe.” Ani ꞌouge huaroteꞌe enogano iriga riꞌiro. ");
INSERT INTO ksj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Roma uti vazeḡa boroꞌe naginiꞌa fureraroteꞌe horonirotene, ani Badiꞌa niguniro ebu ꞌahige rae reiro, “Vaze ꞌadiꞌe hube hune vaze duduḡa reiro!” ");
INSERT INTO ksj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Vaze ḡuḡuvaḡa zuni Iesuꞌa satauro rana rudaroteꞌe muririro, ebu naginiꞌa fureraroteꞌe horonirotene zamaze ufeta areꞌenaꞌa, neze bare ḡouriro. ");
INSERT INTO ksj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Iesu edeḡa azaḡa niduꞌa zu Galilea habaꞌanonoꞌo hegote ariroteꞌe roḡaeḡaroḡaeḡaꞌe faḡano edanadu eꞌe niduꞌa muririro. ");
INSERT INTO ksj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Vaze ꞌahoga, niḡa Iosefaꞌa radiunu. Aniꞌe vaze manoḡa zu duduḡa, ebu Iuda azaḡa nuꞌonuꞌo boro ibitohauꞌeteꞌe vazeḡa ꞌahoga. ");
INSERT INTO ksj_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Aniꞌe Iudea habaꞌano Arimate neḡa vazeḡa, zu Badiꞌaꞌa zuhiꞌaziꞌeteꞌe guhine radiunu. Ebu aniꞌe nuꞌonuꞌo azaḡa boroboroꞌa Iesu matihi reirotene, ḡoereze zu haḡaize mene mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Aniꞌa Pilato vaḡe onamadu Iesu ahiꞌa mouga veize uminiro, ebu Pilatoꞌa ani ꞌevoꞌa riꞌiniro. ");
INSERT INTO ksj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ꞌOugadu Iosefaꞌa satauronoꞌo Iesu ahiri mae bunadu dabua manoḡa hina ꞌumiro. Ebu vatava huꞌiroteꞌe iduḡa zamaḡano Iesu ahiri tiro. Idu aꞌe rune vaze ꞌahoga ꞌize mene tiroteꞌe iduḡa iziga. ");
INSERT INTO ksj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Aꞌe Bana Madaḡa veize ruhibeꞌeteꞌe ḡoravaḡa, ebu Bana Madaḡa hanitiro. ");
INSERT INTO ksj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galilea habaꞌanonoꞌo Iesu hegote ariroteꞌe roḡaeḡaroḡaeḡaꞌe Iosefa hegote onamadu iduḡa horoniro, ebu Iesu ahiri nouma tiroteꞌe horoniro. ");
INSERT INTO ksj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ebu ze neze baradu Iesu ahiri asohanoga veize murava hohoḡa zu dehoro hohoḡa manoḡa ruhibiro. Ebu Mose goro ḡoeꞌa idunaḡano Bana Madaḡano ze ahirize ohone baniro. ");
INSERT INTO ksj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Fura oherebau uzeuze, roḡaeroḡaeꞌe zeꞌa ruhibiroteꞌe muravaḡa hohoḡa madu idu onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ze feurirotene, idu ꞌuiroteꞌe hadiḡa boro kiune vaḡinoga horoniro. ");
INSERT INTO ksj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ebu ze diuḡirotene, Zuhiꞌa Boro Iesu ahiri mene horoniro. ");
INSERT INTO ksj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ꞌOugadu zamare ꞌadaꞌadiroteꞌea, ohoze aheuꞌa tabara zeḡe babaḡano edaro. Zeꞌe dabua vazavazahoḡa vidaro. ");
INSERT INTO ksj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ebu roḡaeroḡaeꞌa rihau rudanadu ubumaze rahao ḡuḡuriro. Rehano ohoze aheuꞌa ziro, “Za nougadu ḡabone vazeḡa rune azaḡa boꞌaḡano vaḡeꞌohe? ");
INSERT INTO ksj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ani ꞌahao ꞌoꞌoꞌa, rehano bare ḡabode iḡuneha. Aniꞌa Galilea habaꞌano zae teite radiunutene, nagini ziroteꞌe zamaroꞌi. ");
INSERT INTO ksj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Aniꞌa ꞌahige rae reiro, 'Vaze Ubugaꞌe haḡai sauꞌa azaḡa ꞌevoreo riꞌini huniꞌuma ebu satauroniꞌuma, rehano mada uḡiduḡano bare ḡabode iḡuniꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ꞌOuge reirotene, roḡaeroḡaeꞌa Iesuꞌa reiroteꞌe ḡoeꞌa zamariro. ");
INSERT INTO ksj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ze iduonoꞌo baradu zeḡe mazao naginiꞌa fureraroteꞌe niduꞌa Iesu tahiꞌa gaubanana tiba fare zu vaze niduꞌa ziro. ");
INSERT INTO ksj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Idu onamiroteꞌe roḡaeḡaroḡaeḡaꞌe Magadala roḡaeḡa Maria, Ioana, Iakobo viꞌa Maria ebu roḡae nunu. Zeꞌe naginiꞌa fureraroteꞌe apostolo azaḡa ziro. ");
INSERT INTO ksj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Rehano apostolo azaḡaꞌe zeḡe ḡoereꞌe ḡiriho hariḡa radu mene mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","U Peteroꞌe iḡunadu idu dure onamiro. Ebu aniꞌa ḡuḡuradu idu zamaḡa ḡianirotene, Iesu ahiri ꞌumiroteꞌe dabuaḡa daꞌo deꞌea radoga horoniro. Ebu ani naginiꞌa fureraroteꞌe zamare ꞌadaꞌadeꞌenaꞌa, neḡa bare onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Eꞌe madaḡano Iesu hegoteꞌeteꞌe azaḡa boꞌaḡano vaze aheuꞌa Emausa neḡa onamiro. Eꞌe neḡa faḡaꞌe Ierusalemaonoꞌo gaubanana tiba fare kilomita. ");
INSERT INTO ksj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Zeꞌe naginiꞌa fureraroteꞌe niduꞌa moneo ḡoretitinu. ");
INSERT INTO ksj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Zeḡeꞌa ḡoꞌane onameꞌeteꞌe zamaḡano, Iesuꞌa zeḡe uhiḡa aradu zeḡe teite onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ze ani horoniro rehano, aꞌe Iesu rae mene ederiro, mazaḡa ubumaze ꞌuadu ze ani mene ederiro. ");
INSERT INTO ksj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iesuꞌa ḡadiziro, “Zaꞌe onameꞌenaꞌa, nagini ḡoꞌaneꞌohe?” Ebu zamazeꞌa areꞌenaꞌa, ze tue edaro. ");
INSERT INTO ksj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Zeḡe boꞌaḡano vaze ꞌahoga, niḡa Kuleopaꞌa niro, “Mada nu zamaḡano Ierusalemao naginiꞌa fureranataꞌaꞌe vaze niduꞌa edeḡa. Ḡaꞌe eꞌea radiunu rehano, ḡae daꞌo aḡuꞌahe?” ");
INSERT INTO ksj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Iesuꞌa ḡadiziro, “Naginiꞌa fureraneha?” Ze naenaeniro, “Aꞌe Nazareta vazeḡa Iesu hariḡa. Aniꞌe Badiꞌa zu vaze niduꞌa zamao haḡai gigiꞌaḡa haḡainuteꞌe zu ḡoere gigiꞌaḡa haraminuteꞌe peroveta vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Rehano dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu vaze ibitoziꞌeteꞌe azaḡaniꞌa Iesu runeo tuḡuniꞌuma radu satauroniro. ");
INSERT INTO ksj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Eme aniꞌe Isaraela azaḡa agireze mazaonoꞌo bohaze buziteꞌe vazeḡa rae mae ḡihiniro. Mene eꞌe daꞌo, izidi Iesu rudaroteꞌe madaḡa enogano mada uḡidu maha, ");
INSERT INTO ksj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ebu emeḡe boꞌaḡano roḡae nuꞌa emeḡe mae zaguzagufeha. Ze izidi oherebau uzeuze idu onameha, ");
INSERT INTO ksj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","rehano Iesu ahiꞌa mene horoneha. Ebu ze bare aradu ꞌahige rae raha, 'Tuḡure viga nuꞌa fureranadu Iesuꞌe bare ḡabodeha rae raha.' ");
INSERT INTO ksj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Eꞌanoꞌo emeḡe boꞌaḡano vaze nuꞌa idu onamatene, roḡaeroḡaeꞌa rateꞌe teige horoneha, ebu zeḡe zuni Iesu ahiꞌaꞌe mene horoneha.” ");
INSERT INTO ksj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Iesuꞌa ziro, “Zaꞌe kauriḡa. Za peroveta azaḡaniꞌa reiroteꞌe ḡoeꞌa niduꞌa ufeta negane mae ḡihineꞌohe. ");
INSERT INTO ksj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Peroveta azaḡaniꞌa reiroteꞌe teige, Kerisoꞌe ꞌouge aduga meꞌuma ebu hena ane haba ḡihiꞌa hune diuḡiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ebu Iesuꞌa Moseonoꞌo onamo peroveta azaḡa niduꞌa ani moneo Buka Zaḡoḡa niduꞌa zamaḡano nagini mirihiroteꞌe faine ihoziro. ");
INSERT INTO ksj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ze Emausa neḡa hanitirotene, Iesuꞌe ꞌize ibio onameꞌeteꞌe teigiro. ");
INSERT INTO ksj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ꞌOugadu ze Iesu ḡihau uminiro, “Ḡoravaraneha zu madaꞌe hauḡeha. Emeḡe ne onamadu bazihi.” Eꞌanoꞌo Iesuꞌa zeḡe neo bazi onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Aniꞌa zeḡe teite ogomu atihi radu ehorirotene, ꞌuvahu odoga madu Badiꞌa mazao kuraro ebu vahege ziniro. ");
INSERT INTO ksj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ꞌOugirotene, ubumazeꞌa bohatanadu aniꞌe Iesu rae ederiro. Rehano zeḡe mazaonoꞌo aniꞌa dauḡiro. ");
INSERT INTO ksj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ebu ze ḡoretitiro, “Aneꞌa ibio eme teite ḡoerateꞌe zu Buka Zaḡoḡa huga ihofateꞌe zamaḡano zamafeꞌa matuꞌe rudaneha!” ");
INSERT INTO ksj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ebu ze zogone iḡunadu Ierusalema bare itiro, ebu eꞌea Iesu tahiꞌa gaubanana tiba fare zu zeḡe teite radiunuteꞌe azaḡaniꞌa nuꞌoru tiburaroteꞌe horoziro. ");
INSERT INTO ksj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Zeꞌa ꞌahige rae reiro, “Hube hune Iesuꞌa bare ḡabodeha ebu Simona mazao fureraneha!” ");
INSERT INTO ksj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ꞌOugadu vaze aheu eꞌeꞌa zuni Emausa ibiḡano zeḡe mazao naginiꞌa fureraroteꞌe ihoziro, zu Iesuꞌa ꞌuvahu odoga vahegirotene aniꞌe Iesu rae ederiroteꞌe hariḡa meꞌodoziniro. ");
INSERT INTO ksj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ze harize meꞌodeꞌeteꞌea, Iesu aneꞌa bare zeḡe boꞌaḡano edaro ebu ziro, “Zama roḡeḡaꞌe zae teite radoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Rehano zeꞌe zaguzagaro zu rihau rudaro, mazaḡa ze ane vine horoneꞌohe rae zamariro. ");
INSERT INTO ksj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Iesuꞌa ziro, “Zaꞌe nougadu rihauꞌohe? Nougadu zamare doudeꞌohe? ");
INSERT INTO ksj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Eḡe ꞌevore zu oda ḡianoꞌi. ꞌAhiꞌe eḡe! Obohoꞌi zu ḡiahoꞌi. Vineꞌe modare zu isine oꞌoꞌa, rehano za horoheꞌeteꞌe teige, eꞌe modareheta zu isineheta.” ");
INSERT INTO ksj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Aniꞌa ꞌouge radu ꞌevoꞌa zu odaḡa ihoziro. ");
INSERT INTO ksj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Rehano ze matuꞌe rudaroteꞌe zu zaguzagaroteꞌe uꞌano, ꞌize Iesu ḡoere mene mae ḡihiniro. Ebu Iesuꞌa ḡadiziro, “Zae mazao ogomu nu eꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ꞌOugadu ze ḡozone kiroḡa tiba haro. ");
INSERT INTO ksj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ebu aniꞌa madu zeḡe zamao aro. ");
INSERT INTO ksj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ebu Iesuꞌa ziro, “Eḡeꞌa zae teite radiunuteꞌe madaḡano ꞌahige rae ziro, 'Mose goro ḡoeꞌa, peroveta azaḡa buka zu Salamo bukaḡa zamaḡano eḡe moneo mirihiroteꞌe ḡoeꞌa niduꞌa hube hune hudaꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ebu Iesuꞌa ze Buka Zaḡoḡa huga ederoga veize zamaze bohaniro. ");
INSERT INTO ksj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ebu aniꞌa ziro, “Buka Zaḡoḡano ꞌahige rae mirihiro, 'Kerisoꞌe aduga hidiꞌuma, ebu mada uḡiduḡano rune azaḡa boꞌaḡano bare ḡabodiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ebu Keriso niḡano vaze haḡaiḡa sauꞌa rae modeꞌeteꞌe hariḡa manoḡaꞌe Ierusalemaonoꞌo onamo habaꞌahabaꞌa niduꞌa zamaḡano haramiꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Zaꞌe eꞌeguḡa niduꞌa hudaroteꞌe horoneha, eꞌanoꞌo zaeꞌa vaze niduꞌa mazao eḡe hari manoḡa haramiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ḡiꞌanoꞌi, eḡe Mamaꞌa ḡoitoriroteꞌe Vine Zaḡoḡa eḡeꞌa zae mazao tuḡuniꞌuma. Eꞌanoꞌo Ierusalema zamaḡano guhiu radoꞌi, onamo adureonoꞌo areꞌeteꞌe gigiꞌaḡaniꞌa zae iri'avoziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ebu Iesuꞌa ze tutuzadu Betania neḡa uhiḡa onamiro. Ebu ꞌevoꞌa ḡihinadu zeḡe veize kuraro. ");
INSERT INTO ksj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Aniꞌa zeḡe veize kurauꞌenaꞌa ze muhiziro, ebu ani adure ḡoha mae ḡihine itiro. ");
INSERT INTO ksj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ebu ze Iesu mazao kuraro zu matuꞌuzeta Ierusalema bare onamiro. ");
INSERT INTO ksj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ebu ze Badiꞌa niguneꞌenaꞌa, iḡaiḡa kuru neḡano radiunu. ");
INSERT INTO ksj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ḡadaheḡano Ḡoere rae huneꞌeteꞌe vazeḡaniꞌa radiunu. Ḡoere aꞌe Badiꞌa teite radiunu ebu Ḡoere eꞌe Badiꞌa. ");
INSERT INTO ksj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Aniꞌe ꞌizema raha zu adure ꞌadi haḡaogano Badiꞌa teite radiunu. ");
INSERT INTO ksj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Badiꞌaꞌa anionoꞌo ḡau niduꞌa haḡairo. Anionoꞌo mene haḡairoteꞌe ḡauḡa ꞌahogaꞌe oꞌoꞌa. ");
INSERT INTO ksj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ani zamaḡano ḡaboneḡeta. Ḡabone eꞌeꞌa vaze agazeꞌeteꞌe agaḡa. ");
INSERT INTO ksj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Agaḡaꞌe uzabo zamaḡano agaruꞌohe, u uzaboꞌe agaḡa vinoga mene idararo. ");
INSERT INTO ksj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Badiꞌaꞌa vaze ꞌahoga tuḡuniro. Ani niꞌe Ioane. ");
INSERT INTO ksj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Aniꞌe agaḡa eꞌe moneo vaze ihozifine ebu ze ani ḡoere egadu agaḡa mazao fifine ariro. ");
INSERT INTO ksj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ioaneꞌe mene eꞌe agaḡa, rehano agaḡa eꞌe moneo ihozoga veize ariro. ");
INSERT INTO ksj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Agaḡaꞌe raha ꞌada ariro. Aniꞌe agaḡa huga ebu vaze niduꞌa agaziro. ");
INSERT INTO ksj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Aniꞌe raha ꞌahao radiro ebu raha ꞌadiꞌe ani mazaonoꞌo haḡairo. Rehano raha azaḡaniꞌa ani mene ederiro. ");
INSERT INTO ksj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Aniꞌe ane haba ariro, rehano ani haba azaḡaniꞌa mene mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","U iniuꞌa ani mae ḡihinadu ani mazao fieꞌeteꞌe azaḡa niduꞌaꞌe Badiꞌa ubugaubuga reiteꞌe gigiꞌaḡa ziniro. ");
INSERT INTO ksj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ze Badiꞌa ubugaubuga raꞌetaꞌaꞌe mene vouḡaze ruonoꞌo, ga mene vaze uraonoꞌo, ga mene vazeꞌa toganiroteꞌe uꞌano, rehano Badiꞌa urao zeꞌe ane ubugaubuga rae reiro. ");
INSERT INTO ksj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ḡoereꞌe vazeo reiro ebu emeḡe boꞌaḡano radiro. Eme aniꞌe ḡihiꞌa hune rae ederiro. Aniꞌe Badiꞌa Ubuga Tibuhuga, ḡihiꞌa hune rae reiro. Aniꞌe vaze zamare borofiro zu ḡoere huga reiro. ");
INSERT INTO ksj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ioaneꞌa ani moneo rae fureneꞌenaꞌa, ḡihau ḡoeriro, “E ibite ꞌahige rae reiro, 'Eḡe ḡaruna ariteꞌe vazeḡaꞌe eḡe vitihoga ḡihiꞌaḡa, mazaḡa e ꞌizema fureranogano aniꞌe amahi radiro.' Eḡeꞌa ꞌouge ziroteꞌe vazeḡaꞌe ꞌadi eꞌe.” ");
INSERT INTO ksj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Aniꞌe eme zamare borofeꞌe ꞌahine, emeḡe niduꞌa manohuga rifiꞌohe, ebu emeꞌa barebare manohuga hideꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Badiꞌa goro ḡoeꞌaꞌe Moseonoꞌo rifiro, u Badiꞌaꞌa Iesu Keriso uꞌano, emeḡe mazao manoḡa fureniro zu ḡoere huga ihofiro. ");
INSERT INTO ksj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Badiꞌaꞌe vaze ꞌahoganiꞌa mene horoniro. Rehano Ubuga tibuhuga, Moga uhiḡano radiuꞌeteꞌeꞌa Badiꞌa moneo vaze ihoziro. Aniꞌe Badiꞌa. ");
INSERT INTO ksj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Iuda azaḡa boroboroꞌa dibuꞌo azaḡa zu Levi urabo azaḡa Ierusalemaonoꞌo Ioane vaḡe tuḡuziro. Ebu zeḡeꞌa Ioane ḡadiniro, “Ḡaꞌe iniu?” ꞌOugadu Ioaneꞌa ꞌahige rae fureniro. ");
INSERT INTO ksj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Aniꞌe ḡau ꞌahoga zu mene ꞌuꞌuru ḡoeriro ebu huga daꞌo deheru rae fureniro, “Eꞌe mene Keriso.” ");
INSERT INTO ksj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ebu zeḡeꞌa ḡadiniro, “Tena ḡa iniu? Ḡa Eliahe?” Aniꞌa naenaeziro, “E mene.” Ze bare ḡadiniro, “Peroveta vazeḡa boro ꞌahoganiꞌa ariꞌuma rae ibite rae fureniro. Ḡaꞌe peroveta vazeḡa eꞌehe?” Aniꞌa naenaeziro, “Mene.” ");
INSERT INTO ksj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ḡonagano zeḡeꞌa niro, “Ḡaꞌe iniu? Ihofoꞌi, ꞌougine eme baradu emeḡe tuḡufateꞌe azaḡa mazao ḡaꞌe iniu rae ziꞌuma. Ḡa ḡae bare moneo nouge rae raꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ioaneꞌa peroveta vazeḡa Isaiaꞌa reiroteꞌe ḡoeꞌa hina naenaeziro, “Eꞌe haba bohaꞌano huauꞌeteꞌe vazeḡa, raenaꞌa, 'Zuhiꞌa Boro veize ibi mae dudunoꞌi.'” ");
INSERT INTO ksj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ioane ḡadiniroteꞌe azaḡa boꞌaḡano nuꞌe Farisea azaḡaniꞌa tuḡuziroteꞌe azaḡa. ");
INSERT INTO ksj_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Zeꞌa Ioane ḡadiniro, “Ḡaꞌe mene Keriso, mene Elia zu mene peroveta vazeḡa eꞌe reine, nougadu vaze babatisoziꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ioaneꞌa naenaeziro, “Eꞌe vu hina babatisoziꞌohe. Rehano zae boꞌaḡano zaeꞌa mene edereꞌeteꞌe vazeḡa ꞌahoganiꞌa edauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Aniꞌe eḡe ḡaruna areꞌeteꞌe vazeḡa zu eḡe vitihoga. Eḡe'a ani tamaka miniḡa fuhiꞌeꞌeteꞌe tuḡureḡa vazeḡa rae rouga zuni mene idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ꞌAhi niduꞌa Ioridana vuḡa moneafa Betania habaꞌano fureraro. Deꞌea Ioaneꞌa babatisozinu. ");
INSERT INTO ksj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Irarirotene, Ioaneꞌe Iesuꞌa ani vaḡe ariroteꞌe horonadu reiro, “Badiꞌa Mamoe Ubuga ḡianoꞌi! Aniꞌe raha ꞌada haḡai sauꞌa niduꞌa odohe onameꞌeteꞌe vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ibite e ani moneo ꞌahige rae reiro, 'Eḡe ḡaruna ariteꞌe vazeḡaꞌe eḡe vitihoga ḡihiꞌaḡa, mazaḡa e ꞌizema fureranogano aniꞌe amahi radiunu.' ");
INSERT INTO ksj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","E aniꞌe mene ederiro. Rehano Isaraela azaḡaniꞌa ani ederifine, e aradu vu hina babatisoziꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ebu Ioaneꞌa bare rae fureniro, “E Vine Zaḡoḡaniꞌa Tubugo niniḡa teige adureonoꞌo ovadu ani rana kame radiuꞌeteꞌe horoniro. ");
INSERT INTO ksj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","E aniꞌe mene ederiro. Rehano e vu hina babatisozoga veize tuḡuhiroteꞌe Badiꞌaḡaniꞌa ꞌahige rae ihohiro, 'Vine Zaḡoḡaniꞌa adureonoꞌo ovadu vaze ꞌahoga rana kame radoga horonoꞌidene, aniꞌe Vine Zaḡoḡa hina babatisoziteꞌe vazeḡa rae ederoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","E hube hune ꞌouge horonadu aniꞌe Badiꞌa Ubuga rae fureneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Irarirotene, Ioaneꞌe ane tahiꞌa aheu teite eꞌe habaꞌano bare edau radiunu. ");
INSERT INTO ksj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ebu Iesuꞌa eꞌea vitau onamoga horonirotene, aniꞌa reiro, “Badiꞌa Mamoe Ubuga ḡianoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ioane tahiꞌa aheuꞌa ani ḡoere egadu Iesu hegotiro. ");
INSERT INTO ksj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ebu Iesuꞌa tehadu ze ani hegoteꞌeteꞌe horozadu ziro, “Za nagini urateꞌohe?” Zeḡeꞌa naenaeniro, “Rabi, ḡa nouma radiuꞌohe?” (Rabi hugaꞌe Ihore Vazeḡa.) ");
INSERT INTO ksj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Iesuꞌa naenaeziro, “Eḡe teite onamine, horoniꞌuma.” Ebu ze onamadu Iesuꞌa radiuꞌeteꞌe habaꞌa horoniro, ebu eꞌe mada niduga eꞌea ane teite radiro. Aꞌe ḡorava mone mada ḡazaḡa reiro. ");
INSERT INTO ksj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ioane ḡoere egadu Iesu hegotiroteꞌe vazeḡa aheu boꞌaḡano ꞌahogaꞌe Anderea. Aniꞌe Simona Petero negoḡa. ");
INSERT INTO ksj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ani ibite negoḡa Simona vaḡe onamadu niro, “Eme Mesia horoneha.” (Mesia ḡoere ꞌahogaꞌe Keriso.) ");
INSERT INTO ksj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ebu Andereaꞌa Simona Iesu vaḡe zamahu onamiro. Iesuꞌa ani ḡianadu niro, “Ḡaꞌe Ioane ubuga, Simona. Rehano Kefa rae huḡadiꞌuma.” (Kefa, ni ꞌahogaꞌe Petero.) ");
INSERT INTO ksj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Irarirotene, Iesuꞌe Galilea habaꞌa onamihi reiro. Ani ꞌizema onamogano Filipi vaḡe onamadu niro, “Eḡe hegotoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipiꞌe Betesaida vazeḡa, ebu Anderea zu Petero teite ne tiba. ");
INSERT INTO ksj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ebu Filipiꞌa Natanaela vaḡe onamadu niro, “Eme Moseꞌa goro ḡoeꞌa zamaḡano mirihiroteꞌe, zu peroveta azaḡaniꞌa zeḡe buka zamaḡano mirihiroteꞌe vazeḡa horoneha. Aniꞌe Iosefa ubuga, Nazareta vazeḡa Iesu.” ");
INSERT INTO ksj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ebu Natanaelaꞌa naenaeniro, “Nazaretaꞌe ne komeꞌa! Eꞌea nagini manoḡaniꞌa fureraꞌuma?” Filipiꞌa niro, “Aradu ḡianoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ebu Iesuꞌe Natanaelaꞌa ani vaḡe areꞌeteꞌe horonirotene, Natanaela moneo ḡoeriro, “Vaze ꞌadiꞌe hube hune Isaraela vazeḡa. Ani mazaoꞌe ḡuriro ꞌahoga oꞌoꞌa.” ");
INSERT INTO ksj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaelaꞌa ḡadiniro, “Ḡaꞌe e nougenouge edereꞌohe?” Iesuꞌa naenaeniro, “Filipiꞌa ꞌizema huḡadogano, ḡa figi ireḡa ꞌuꞌuḡano radiuꞌenogano horoꞌeha.” ");
INSERT INTO ksj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ebu Natanaelaꞌa niro, “Rabi, ḡaꞌe Badiꞌa Ubuga! Isaraela azaḡa kini!” ");
INSERT INTO ksj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Iesuꞌa niro, “Eḡeꞌa ḡaꞌe figi ireḡa ꞌuꞌuḡano radateꞌea horoꞌeha rae radu ḡa eḡe mazao fieꞌehe? Rehano ḡa ꞌahi ufeta vitinoga ḡihiꞌaḡaḡihiꞌaḡa horoniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ebu Iesuꞌa ziro, “Eḡeꞌa hube hune ziꞌohe, za adureꞌa bohatanadu Badiꞌa tuḡure viganiꞌa Vaze Ubuga rana iteꞌeteꞌe zu ovoeꞌeteꞌe horoniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mada uḡiduḡano Galilea habaꞌano Kana neḡano hahu muiḡa ꞌahoga haḡairo, ebu Iesu viꞌaꞌe mui eꞌe zamaḡano radiro. ");
INSERT INTO ksj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Mui vazeḡaniꞌa Iesu zu ane tahiꞌatahiꞌa zuni huziro. ");
INSERT INTO ksj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Muio vaini vuḡaniꞌa hauḡirotene, viꞌaniꞌa Iesu niro, “Ze vaini vuḡaꞌe hauḡeha.” ");
INSERT INTO ksj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iesuꞌa naenaeniro, “Roḡae boro, ḡa nougadu eḡe mazao ꞌouge raꞌohe? Eḡe gau madaḡaꞌe ꞌize mene maha.” ");
INSERT INTO ksj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Rehano viꞌaniꞌa mui tuḡure azaḡa ziro, “Aniꞌa nouge rae zoꞌidene, ꞌouge haḡaoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ebu hadi hina haḡairoteꞌe vu ḡoḡoreḡa fuꞌo tiba fareꞌe deꞌea. Aꞌe Iuda azaḡa goro idunaḡano, ze zu ḡauze dehenoga veize tiro. Hadi vu ḡoḡoreḡa tibatibano vu 20 gareni onamo 30 gareni iriꞌavonoga idararo. ");
INSERT INTO ksj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iesuꞌa tuḡure azaḡa ziro, “Ḡoḡore niduꞌa vu iriꞌavonoꞌi.” ꞌOugadu ze vu beuꞌe ite hebeꞌano iri'avoniro. ");
INSERT INTO ksj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ebu Iesuꞌa ziro, “Vu nu iḡi vaḡinadu mui ibitohauꞌeteꞌe vazeḡa ha onamoꞌi.” Eꞌanoꞌo ze ꞌouge haḡairo. ");
INSERT INTO ksj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ebu mui ibitohauꞌeteꞌe vazeḡaniꞌa vu eꞌe vaini vuḡano reiroteꞌe gage nuriro. Aniꞌe vaini vuḡa eꞌe noumanoꞌo mae arirotaꞌaꞌe aḡuꞌa, u vu iḡi vaḡiniroteꞌe tuḡure azaḡaꞌe edeḡa. Ebu mui ibitohauꞌeteꞌe vazeḡaniꞌa hahu iziga ohozeḡa huniro. ");
INSERT INTO ksj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ebu ani matuꞌeꞌenaꞌa, hahu iziga ohozeḡa niro, “Vaze niduꞌa vaini vuḡa manoḡa tauḡi ibite oma mae fureneꞌohe. Ebu mui azaḡaniꞌa gage sautuꞌetuꞌu hena tahiḡa manoḡa mae fureneꞌohe. Rehano ḡaeꞌa onao izidi vaini vuḡa manoḡa tauḡi vazevaze veize modeha.” ");
INSERT INTO ksj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iesuꞌa haḡai nu badeḡa ibiꞌaꞌe Galilea habaꞌano Kana neḡano ꞌahige haḡairo. ꞌOugadu ani ane ni mae ḡihiniro, ebu ane tahiꞌatahiꞌaꞌa ani mazao firo. ");
INSERT INTO ksj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Mui ḡarugano Iesuꞌe viꞌa, negoḡa duḡuru zu ane tahiꞌatahiꞌa teite Kaperanauma ovoiro. Ebu eꞌea mada nu radiro. ");
INSERT INTO ksj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Iuda azaḡa Iḡine Modiroteꞌe Muiḡa madaḡaniꞌa hanitirotene, Iesuꞌe Ierusalema itiro. ");
INSERT INTO ksj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ebu ani vaze nuꞌe kuru neḡa habaꞌano boromakau, mamoe zu Tubugo niniḡa seronoga horoziro, ebu nuꞌe fataze babaḡano ehoradu hadi seniso zenoga horoziro. ");
INSERT INTO ksj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ꞌOugadu ani mini hina masizeꞌeteꞌe ḡauḡa haḡadu eꞌe hina zeḡe niduꞌa ebu mamoe zu boromakau niduꞌa kuru neḡa habaꞌanonoꞌo masize ḡururuziro. Ebu hadi seniso ziniꞌeteꞌe azaḡa hadize beuꞌe ḡuzuhiro, zu fataze mae ḡihuniro. ");
INSERT INTO ksj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ebu Tubugo niniḡa seroneꞌeteꞌe azaḡa ziro, “Ḡau ꞌahi niduꞌa ꞌadanoꞌo mae vaḡinoꞌi! Mamahe neꞌe maketi habaꞌano ago haḡaoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ane tahiꞌatahiꞌaꞌe Buka Zaḡoḡano ḡoere ꞌahi zamariro, “E Badiꞌa ne zamare borofeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ebu Iuda azaḡaniꞌa ḡadiniro, “Ḡa nagi gigiꞌaḡa hina ꞌahiguḡa haḡaeꞌohe? Ḡae gigiꞌaꞌe Badiꞌa mazaonoꞌo roꞌidene, haḡai nu badeḡa ihofoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ebu Iesuꞌa naenaeziro, “Kuru neḡa ꞌadi fahoꞌi, ꞌougine eḡeꞌa mada uḡidu zamaḡano bare ohoniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Zeḡeꞌa niro, “Kuru neḡa ꞌadi ogorarotene muri 46 madu hauḡiro. U ḡaꞌe mada uḡidu zamaḡano ohoniꞌuma rae raꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Rehano Iesuꞌa kuru neḡa reirotaꞌaꞌe ane ahiri moneo reiro. ");
INSERT INTO ksj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Iesuꞌe runeonoꞌo bare iḡuniroteꞌe ḡarugano, ane tahiꞌatahiꞌaꞌa ani ḡoere zamariro. Ebu ze Buka Zaḡoḡano mirihiroteꞌe ḡoeꞌa ebu Iesuꞌa reiroteꞌe ḡoeꞌa mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Iesuꞌe Iḡine Modiroteꞌe Muiḡa madaḡano Ierusalemao radiunu. Ebu vaze ḡehaḡaniꞌa aneꞌa haḡai nu badeḡa haḡairoteꞌe horonadu ani mazao firo. ");
INSERT INTO ksj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Rehano aniꞌe ze mene mae ḡihiziro, mazaḡa vaze niduꞌa zamaze ederiro. ");
INSERT INTO ksj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Vaze zamao naginiꞌa radiuꞌetaꞌaꞌe zuni Iesuꞌa ederiroteꞌe uꞌano, aniꞌe vaze ꞌahoganiꞌa vaze ꞌahoga moneo ani ihonoga mene uratiro. ");
INSERT INTO ksj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Farisea vazeḡa ꞌahoga, niḡa Nikodemoꞌa radiunu. Aniꞌe Iuda azaḡa ibitoziꞌeteꞌe vazeḡa ꞌahoga. ");
INSERT INTO ksj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ohere ꞌahogano ani Iesu vaḡe aradu niro, “Rabi, emeꞌe edeḡa, ḡaꞌe Badiꞌa mazaonoꞌo ariroteꞌe ihore vazeḡa. Mazaḡa iniuꞌe Badiꞌaꞌa ani teite mene radiune, ani ḡaꞌa haḡaeꞌeteꞌe haḡaiḡa nu badeḡa haḡaoga mene idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ebu Iesuꞌa naenaeniro, “Eḡeꞌa hube hune ḡaꞌohe, iniuꞌa mene bare fureraune, Badiꞌaꞌa zuhiꞌaziꞌeteꞌe horonoga mene idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ebu Nikodemoꞌa niro, “Vaze boroꞌe nougenouge bare fureranoga idaḡa? Aniꞌe viꞌa isi zamaḡano bare diuḡadu fureranoga mene idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iesuꞌa naenaeniro, “Eḡeꞌa hube hune ḡaꞌohe, iniuꞌa vu zu Vine Zaḡoḡa hina mene bare fureraune, aniꞌe Badiꞌaꞌa zuhiꞌaniꞌeteꞌe vazeḡa rouga mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Vazeꞌe nanu mama ahirionoꞌo ahirio fureruꞌohe. U vineꞌe Badiꞌa Vigaonoꞌo fureruꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Eḡeꞌa zinaꞌa, 'Zaꞌe bare fureranoꞌi,' rae rateꞌe uꞌano, ago zaguzaganoꞌi. ");
INSERT INTO ksj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Zaizaiꞌa ane edeḡano zaiduꞌohe. Ḡaꞌe zaizai igiꞌohe, rehano aniꞌa noumanoꞌo areꞌeteꞌe zu noꞌe onameꞌetaꞌaꞌe aḡuꞌa. Eꞌe teige, Vine Zaḡoḡaonoꞌo fureraroteꞌe azaḡa niduꞌa zuni ꞌouge fureruꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ebu Nikodemoꞌa ḡadiniro, “Nougenouge ꞌahiguḡaniꞌa fureruꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iesuꞌa niro, “Ḡaꞌe Isaraela azaḡa ihozeꞌeteꞌe vazeḡa, rehano nougadu ꞌahiguḡaꞌe aḡuꞌa? ");
INSERT INTO ksj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","E hube hune ḡaꞌohe. Eme nagini edere ḡauḡa ḡoereꞌohe, zu nagini horoniroteꞌe ḡauḡa rae fureneꞌohe. Rehano za emeꞌa rae fureneꞌeteꞌe ḡoeꞌaꞌe mene mae ḡihineꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Eꞌa raha ꞌadao fureruꞌeteꞌe ḡauḡa moneo ziro, rehano zaꞌe mene mae ḡihineꞌohe. ꞌOugadu adureo fureruꞌeteꞌe ḡauḡa moneo zine, nougenouge mae ḡihiniꞌuma? ");
INSERT INTO ksj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Vaze ꞌahoganiꞌa adure ꞌize mene itiro, rehano Vaze Ubuga, adureonoꞌo ovairoteꞌe vazeḡaniꞌa daꞌo itiro. ");
INSERT INTO ksj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ibite madaḡano Moseꞌa haba bohaꞌano mohe iraḡa haḡadu somori faḡa rana teadu mae ḡihiniro. Eꞌe teige, Vaze Ubuga zuni vazeꞌa satauro rana mae ḡihiniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Aꞌe ani mazao fieꞌeteꞌe azaḡa niduꞌaꞌe ḡabone tuḡutuḡu hidifine raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Badiꞌaꞌa raha ꞌadi azaḡa ufeta zamare borofeꞌeteꞌe uꞌano, ani Ubuga tibuhuga ziniro. Aꞌe, iniu ani mazao fieꞌeteꞌe azaḡa niduꞌaꞌe mene rudanadu ḡabone tuḡutuḡu hidifine raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Badiꞌaꞌa raha ꞌadi azaḡa kotazoga veize ani Ubuga mene tuḡuniro, rehano ani uꞌano ze ḡabozoga veize tuḡuniro. ");
INSERT INTO ksj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Iniu ani mazao fieꞌeteꞌe azaḡaꞌe mene kotazeꞌohe. Rehano mene fieꞌeteꞌe azaḡaꞌe amahi kotaziro, mazaḡa ze Badiꞌa Ubuga tibuhuga mazao mene firo. ");
INSERT INTO ksj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Agaḡaꞌe rahao ariro, rehano vazeꞌa agaḡa mene zamariro ebu haḡaize sauꞌa uꞌano, ze uzabo ufeta zamariro. Eꞌanoꞌo Badiꞌaꞌa kotao ohoziro. ");
INSERT INTO ksj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Haḡai sauꞌa haḡaeꞌeteꞌe azaḡa niduꞌaꞌe agaḡa heꞌeheꞌenadu agaḡa vaḡe mene areꞌohe, mazaḡa haḡaize sauꞌa rae fureniꞌuma radu rihauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Rehano ḡoere huga hegoteꞌeteꞌe azaḡaꞌe agaḡa vaḡe areꞌohe. Aꞌe, ze Badiꞌa ḡoere hegotadu haḡairoteꞌe haḡaiḡa deheru ihozifine raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Eꞌe ḡarugano Iesuꞌa ane tahiꞌatahiꞌa teite Iudea habaꞌa onamiro, ebu eꞌea zeḡe teite mada nu radiuꞌenaꞌa, vaze babatisoziro. ");
INSERT INTO ksj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ioane Babatiso zuni Salema neḡa uhiḡano Enoni neḡano babatisozinu, mazaḡa eꞌe habaꞌaꞌe vu boro. Vaze ḡehaḡaniꞌa babatiso mouga radu ani vaḡe arinu. ");
INSERT INTO ksj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Eꞌe madaḡano Ioaneꞌe ꞌizema ḡuꞌa neḡano ohoniro. ");
INSERT INTO ksj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ioane tahiꞌaḡa nuꞌa Iuda vazeḡa ꞌahoga teite ahiri ga ḡau faifaine vuzuꞌeꞌeteꞌe haḡaiḡa moneo taꞌirotitiro. ");
INSERT INTO ksj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ebu Ioane tahiꞌatahiꞌaꞌa Ioane vaḡe aradu niro, “Rabi, Ioridana vuḡa moneafa ꞌoma ḡae teite radateꞌe zu ḡaeꞌa rae furenateꞌe vazeḡaniꞌa babatisoziꞌohe, ebu vaze niduꞌa ane vaḡe onameꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ebu Ioaneꞌa naenaeziro, “Badiꞌaꞌa inaraḡa mene haune, vazeni ꞌahoga ꞌouge gauoga mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Eḡeꞌa ꞌahige rae ziro, 'Eꞌe mene Keriso, rehano e ani veize ibite tuḡuhiro.' Eꞌanoꞌo za eḡe ḡoere ꞌahi vaze niduꞌa mazao rae fureniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","E hari ꞌahoga idane ziꞌohe. Hahu roḡaeḡa izigaꞌe hahu ohozeḡa iziganiꞌa maꞌohe. U hahu ohozeḡa iziga nabugaꞌe edauꞌenaꞌa, hahu ohozeḡa iziga ḡoere igiꞌohe. Igiꞌetene, aniꞌe matuꞌe rudauꞌohe. Hari eꞌe teige, eꞌe hahu ohozeḡa iziga nabuga heuḡa. E zae mazaonoꞌo ani hari egadu matuꞌe rudauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Aniꞌe ufeta ḡihiꞌa reꞌuma, u eꞌe ufeta ovoroga reꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Hitanaonoꞌo ovaeꞌeteꞌe vazeḡaꞌe ḡihiꞌa hune. Aniꞌe ḡau niduꞌa vitinoga. U rahaonoꞌo areꞌeteꞌe vazeḡaꞌe raha ꞌadi vazeḡa, zu rahao fureruꞌeteꞌe ḡauḡa moneo ḡoereꞌohe. Adureonoꞌo ovaeꞌeteꞌe vazeḡaꞌe ḡau niduꞌa vitinoga. ");
INSERT INTO ksj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Aniꞌa horoniroteꞌe zu igiroteꞌe ḡauḡa rae fureneꞌohe, rehano vazeni ꞌahogaꞌe ani ḡoere mene mae ḡihineꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ani ḡoere mae ḡihineꞌeteꞌe vazeḡaꞌe Badiꞌa ḡoereꞌe hube hune rae raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Badiꞌaꞌa tuḡuniroteꞌe vazeḡaꞌe Badiꞌa ḡoere ziꞌohe, mazaḡa Badiꞌaꞌa Vine Zaḡoḡa hanadu Vine Zaḡoḡaniꞌa iḡaiḡa ani teite radiuꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Moganiꞌa Ubuga zamare borofadu ḡau niduꞌa ani ꞌevora riꞌiniro. ");
INSERT INTO ksj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Iniu Ubuga mazao fieꞌeteꞌe vazeḡaꞌe ḡabone tuḡutuḡu hidiro. U iniu Ubuga hezahohauꞌeteꞌe vazeḡaꞌe ḡabone mene hidiꞌuma, rehano Badiꞌa zama ḡugiꞌaniꞌa ani ragano reꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Iesuꞌa Ioane vitine ani tahiꞌatahiꞌa ufeta ḡehaḡa zamazadu babatisoziꞌeteꞌe hariḡa Farisea azaḡaniꞌa igiro. ");
INSERT INTO ksj_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Aꞌe Iesuꞌa mene babatisoziro, rehano ane tahiꞌatahiꞌaꞌa babatisoziro. ");
INSERT INTO ksj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Aniꞌe Farisea azaḡaniꞌa ani moneo ḡoereꞌeteꞌe ederirotene, Iudea habaꞌa modadu bare Galilea habaꞌa onamiro. ");
INSERT INTO ksj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galilea habaꞌa onameꞌeteꞌe ibiḡano aniꞌe Samaria habaꞌa vitine onamiro. ");
INSERT INTO ksj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ꞌOugadu Samaria habaꞌano ne boro ꞌahoga, niḡa Sukao feuriro. Eꞌe neḡaꞌe Iakoboꞌa ubuga Iosefa haroteꞌe habaꞌa uhiḡano, ");
INSERT INTO ksj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ebu Iakobo idu vuḡa zuni eꞌea. Iesuꞌa ibi faḡa aradu fuḡone runiro ꞌahine, idu vuḡa genaḡano ehore radiro. Aꞌe madai kirikiri. ");
INSERT INTO ksj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samaria roḡaeḡa ꞌahoganiꞌa vu abi ariro. Iesuꞌa ani horonadu niro, “Vu gagifine nu iniꞌumahe?” ");
INSERT INTO ksj_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Eꞌe madaḡano Iesu tahiꞌatahiꞌaꞌe ogomu hoitoga veize ne onamadu ani teite mene radiro. ");
INSERT INTO ksj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ebu Samaria roḡaeḡaniꞌa niro, “Ḡaꞌe Iuda vazeḡa, u eꞌe Samaria roḡaeḡa. Nougadu ḡa eḡe mazao vu umideꞌohe?” Iuda azaḡaꞌe Samaria azaḡa teite mene tiburuꞌeteꞌe uꞌano, ani ꞌouge rae reiro. ");
INSERT INTO ksj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ebu Iesuꞌa naenaeniro, “Ḡa Badiꞌaꞌa nagi ḡahunoneḡa ḡanihi rae ederifone zu ḡae mazao vu umiꞌeꞌeteꞌe vazeḡaꞌe iniu rae ederifone, ḡa umihadu eḡeꞌa ḡabone vuḡa ḡanifo.” ");
INSERT INTO ksj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Roḡae eꞌeꞌa niro, “Vaze boro, ḡae mazao vu abeꞌeteꞌe ḡauḡaꞌe oꞌoꞌa zu idu vuḡa ꞌahiꞌe vo hutuna. Ḡabone vuḡaꞌe nouma meꞌuma? ");
INSERT INTO ksj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Emeḡe vouḡa Iakoboꞌa idu vuḡa ꞌahi rifiro. Ani idu ꞌahi vuḡanonoꞌo vu gagiro, ebu ani ubuga duḡuru zu aneꞌa ḡubuziroteꞌe ḡauḡa zuni vu ꞌahi gagiro. Ḡaꞌe ani ufeta vitine ḡihiꞌaḡahe?” ");
INSERT INTO ksj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iesuꞌa naenaeniro, “Iniuꞌa vu ꞌadi gageꞌeteꞌe vazeḡaꞌe iriganiꞌa bare moꞌoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Rehano iniu eḡeꞌa hauꞌeteꞌe vuḡa gageꞌeteꞌe vazeḡaꞌe iriga mene bare moꞌoniꞌuma. Eḡeꞌa hauꞌeteꞌe vuḡaꞌe ane zamao sore iteꞌeteꞌe iduḡa vuḡa teigiꞌuma ebu ḡabone tuḡutuḡu haꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Roḡae eꞌeꞌa niro, “Vaze boro, eꞌe vuḡaꞌe eḡe enoꞌi. ꞌOugine, irinehe mene bare moꞌohiꞌuma zu vu aboḡa veize e ꞌahi mene bare ariꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Iesuꞌa niro, “Ḡa onamadu iꞌu hune aroꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Roḡae eꞌeꞌa naenaeniro, “E ihe oꞌoꞌa.” Iesuꞌa niro, “Ḡaꞌa iꞌu oꞌoꞌa raꞌetaꞌaꞌe hube. ");
INSERT INTO ksj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ḡaꞌe ibite iꞌu fuꞌo meiro, ebu izidi ḡae teite radiuꞌeteꞌe ohozeḡa zuni ḡae mene iꞌu. Ḡaꞌa rataꞌaꞌe hube.” ");
INSERT INTO ksj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ebu roḡae eꞌeꞌa niro, “Vaze boro, e ḡaꞌe peroveta vazeḡa rae edereha. ");
INSERT INTO ksj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Vouḡafe, Samaria azaḡaniꞌa Gerizimi maḡa ꞌada kuraro. Rehano za, Iuda azaḡaꞌe, 'Kuru habaꞌaꞌe Ierusalema daꞌo,' rae raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Iesuꞌa niro, “Roḡae, eḡe ḡoere ꞌahi mae ḡihinoꞌi. Mada ꞌahoganiꞌa arine, za Mama mazao kurauꞌeteꞌe habaꞌaꞌe mene maḡa ꞌada ga mene Ierusalemao reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Za, Samaria azaḡaꞌe iniu mazao kurauꞌetaꞌaꞌe aḡuꞌa. U eme, Iuda azaḡaꞌe iniu mazao kurauꞌetaꞌaꞌe edeḡa, mazaḡa Badiꞌaꞌa vaze ḡaboziteꞌe vazeḡaꞌe Iuda azaḡa mazaonoꞌo tuḡuniro. ");
INSERT INTO ksj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Rehano hube hune kurauꞌeteꞌe azaḡaniꞌa Badiꞌa Vine inaraḡa hina zu ḡoere huga hina Mama mazao kuratiteꞌe madaḡaniꞌa ariꞌuma, ebu izidiꞌe eꞌe madaḡa raꞌohe. Mamaꞌa ani mazao ꞌouge kurauꞌeteꞌe azaḡa vaḡeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Badiꞌaꞌe vine, eꞌanoꞌo iniuꞌa ani mazao kurauꞌeteꞌe azaḡaꞌe Badiꞌa Vine inaraḡa hina zu ḡoere huga hina kuraꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Roḡae eꞌeꞌa niro, “Eḡe edeḡa, Mesia, Keriso rae huneꞌeteꞌe vazeḡaꞌe ariꞌuma. Aniꞌa arine, ḡau niduꞌa ihofiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Iesuꞌa niro, “Izidi ḡaꞌeteꞌe vazeḡaꞌe Keriso, eḡe.” ");
INSERT INTO ksj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Iesuꞌa ꞌouge ḡoerirotene, ane tahiꞌatahiꞌaꞌa feuri ariro. Ebu ze zaguzagaro, mazaḡa aniꞌe roḡae ꞌahoga teite ḡoere radiro. Rehano vaze ꞌahoganiꞌa Iesu mazao ninaꞌa, “Ḡa nougihi raꞌohe?” ga “Ḡa nougadu ani teite ḡoereꞌohe?” rae mene ḡadiniro. ");
INSERT INTO ksj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ebu roḡae eꞌeꞌa vu ḡoḡoreḡa modadu ne onamiro, ebu ne azaḡa ziro, ");
INSERT INTO ksj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Aradu vaze ꞌadi ḡianoꞌi! Ani eḡeꞌa haḡairoteꞌe haḡaiḡa niduꞌa eheha. Aniꞌe Keriso gaogi!” ");
INSERT INTO ksj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ebu ze neze modadu Iesu vaḡe onamiro. ");
INSERT INTO ksj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Eꞌe zamaḡano Iesu tahiꞌatahiꞌaꞌa Iesu uminiro, “Rabi, ḡa ogomu nu anoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Rehano aniꞌa ziro, “Ogomuꞌe eḡe mazao eꞌe, rehano zaꞌe ogomu eꞌe moneoꞌe aḡuꞌa.” ");
INSERT INTO ksj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ebu ze zeḡeꞌa bare ḡadimutitiro, “Vaze ꞌahoganiꞌa ogomu hanahe?” ");
INSERT INTO ksj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Iesuꞌa ziro, “Eḡe ogomuꞌe eḡe tuḡuhiroteꞌe vazeḡa ura haḡaeꞌeteꞌe zu ane gau haḡae huneꞌeteꞌe raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Zaꞌe, 'Bato ḡazaḡa enogano hiriviteꞌe madaḡa meꞌuma,' rae raꞌohe. Rehano eḡeꞌa ziꞌohe, ubumaze raꞌanadu meba faine ḡianoꞌi. Meba ogomuḡaniꞌa hudanadu hiriveꞌeteꞌe madaḡa ꞌai maha. ");
INSERT INTO ksj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Hiriveꞌeteꞌe vazeḡaꞌe gauḡa naeḡa hideꞌohe, ebu ane hirivadu ḡabone tuḡutuḡu hideꞌeteꞌe huga nuꞌoneꞌohe. ꞌOugine, ḡorauꞌeteꞌe vazeḡa zu hiriveꞌeteꞌe vazeḡa, anianine matuꞌe tiburaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ḡoere ꞌahiꞌe hube, 'Vaze ꞌahogaꞌe ḡorauꞌohe ebu ꞌahogaꞌe hiriveꞌohe.' ");
INSERT INTO ksj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Zaeꞌa mene ḡoraroteꞌe ogomuḡa hirivoga veize e za tuḡuziro. Vaze ꞌahogaꞌahogaꞌe gau boro haḡairo, u zaꞌe zeḡe gauonoꞌo huga maꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ne beꞌanoꞌo Samaria azaḡa ḡehaḡaniꞌa Iesu mazao firo, mazaḡa roḡae eꞌeꞌa ꞌahige rae fureniro, “Ani eꞌa haḡairoteꞌe haḡaiḡa niduꞌa eheha.” ");
INSERT INTO ksj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ze ani vaḡe aradu uminiro, “Emeḡe teite mada nu radoꞌi.” ꞌOugadu aniꞌe zeḡe teite mada aheu eꞌea radiro. ");
INSERT INTO ksj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ebu Iesu ḡoere uꞌano, vaze ufeta ḡehaḡaniꞌa ani mazao firo. ");
INSERT INTO ksj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ebu zeḡeꞌa roḡae eꞌe niro, “Emeꞌe mene ḡae ḡoere uꞌano, rehano eme emeḡeꞌa bare ani ḡoere egateꞌe uꞌano ani mazao fieꞌohe. Mazaḡa eme edereha, vaze ꞌadiꞌe hube hune raha ꞌadi azaḡa niduꞌa ḡabozeꞌeteꞌe vazeḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mada aheu enogano Iesuꞌe eꞌea iḡunadu Galilea habaꞌa onamiro. ");
INSERT INTO ksj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Mazaḡa ani aneꞌa bare ꞌahige rae reiro, “Peroveta vazeḡaꞌe ane haba azaḡaniꞌa mene gubaneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ani Galilea habaꞌano feurirotene, Galilea azaḡaniꞌa ani mae zouniro, mazaḡa ze Iḡine Modiroteꞌe Muiḡa madaḡano Ierusalemao radiuꞌenaꞌa, Iesuꞌa Mui eꞌe zamaḡano haḡairoteꞌe haḡaiḡa niduꞌa horoniro. ");
INSERT INTO ksj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ebu Iesuꞌa Galilea habaꞌano Kana neḡa bare onamiro. Aꞌe vu ḡihune vaini vuḡano haḡairoteꞌe neḡa. Eꞌea kini gau vazeḡa ꞌahoganiꞌa radiunu, ebu ani ubugaꞌe ugiꞌa madu Kaperanauma zamaḡano radiunu. ");
INSERT INTO ksj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Aniꞌe Iesuꞌa Iudea habaꞌanonoꞌo Galilea habaꞌano feuri ariroteꞌe igirotene, ani vaḡe onamadu uminiro, “Ubudeheꞌe ugiꞌa madu nariga rudauꞌohe. Ḡa eḡe teite Kaperanauma ovoadu ani fainoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ebu Iesuꞌa niro, “Zaꞌe haḡai nu badeḡa zu zaguzagatiteꞌe haḡaiḡa mene horonine, eḡe mazao mene fiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kini gau vazeḡaniꞌa niro, “Vaze boro, ubudehe ꞌizema rudanogano, aro ovoihi.” ");
INSERT INTO ksj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Iesuꞌa naenaeniro, “Onamoꞌi. Ubugoꞌe ḡabodiꞌuma.” ꞌOuge reirotene, ani Iesu ḡoere mae ḡihiniro ebu ani ne ovoiro. ");
INSERT INTO ksj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ani ibio ovoeꞌeteꞌe zamaḡano, ane tuḡure azaḡaniꞌa ani hidadu ihoniro, “Ubugoꞌe ḡabodeha!” ");
INSERT INTO ksj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ebu aniꞌa ḡadiziro, “Ubudeheꞌe naniꞌa manoreha?” Zeḡeꞌa niro, “Ohoḡore ḡorava mone mada tiba zamaḡano gigiꞌaniꞌa hauḡeha.” ");
INSERT INTO ksj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ꞌOugadu mogaꞌe ederiro, eꞌe madaḡaꞌe Iesuꞌa, “Ubugoꞌe ḡabodiꞌuma,” rae reiroteꞌe madaḡa. Eꞌanoꞌo ani zu ane neo tiburu radiuꞌeteꞌe azaḡa niduꞌaꞌe Iesu mazao firo. ");
INSERT INTO ksj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Aꞌe Iesuꞌa Iudea habaꞌanonoꞌo Galilea habaꞌa ariroteꞌe enogano haḡairoteꞌe haḡai nu badeḡa aheuḡa. ");
INSERT INTO ksj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Eꞌe enogano Iuda azaḡa mui madaḡa ꞌahoga meirotene, Iesuꞌe Ierusalema itiro. ");
INSERT INTO ksj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ierusalema zamaḡano ibiheta ꞌahoga niḡaꞌe Mamoe Ibiheta. Ibiheta eꞌe uhiḡano Heberu ḡoeꞌano Betesaida rae huneꞌeteꞌe duꞌuraḡa komeꞌa ꞌahogaꞌe eꞌe, ebu eꞌe duꞌuraḡa genaḡano ibi zauhaḡaꞌe fuꞌo. ");
INSERT INTO ksj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ebu ugi azaḡa ḡehaḡaniꞌa mada niduꞌa eꞌea baze baninu. Zeꞌe ubuma kuruḡa azaḡa, oda sauꞌa azaḡa zu ahiꞌa mene haganeꞌeteꞌe azaḡa. ");
INSERT INTO ksj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Zeḡe boꞌaḡano muri 38 zamaḡano uginiroteꞌe vazeḡaniꞌa radiunu. ");
INSERT INTO ksj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iesuꞌa ani deꞌea baze radiuꞌeteꞌe horonadu ani faḡa hune uginirotaꞌaꞌe ederiro. ꞌOugadu aneꞌa ugi vazeḡa niro, “Ḡa manoroga urateꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ugi vazeḡaniꞌa naenaeniro, “Vaze boro, vuꞌa hagareꞌetene, vaze ꞌahoganiꞌa duꞌura zamaḡano e mene danahe ohoheꞌohe. Ebu e eḡeꞌa bare diuḡi onameꞌeteꞌe zamaḡano vaze ꞌahoganiꞌa ibite diuḡeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ebu Iesuꞌa niro, “Iḡunoꞌi, ebu farataḡo madu onamoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Eꞌebone ugi vazeḡa ꞌai zogone manoriro ebu farataḡa madu onamiro. Eꞌe madaḡaꞌe Bana Madaḡa. ");
INSERT INTO ksj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Eꞌanoꞌo Iuda azaḡa ibitoziꞌeteꞌe azaḡaniꞌa ugionoꞌo manoriroteꞌe vazeḡa niro, “Izidiꞌe Bana Madaḡa. Ḡaꞌa farataḡo odoheꞌetaꞌaꞌe Mose goro ḡoeꞌa variꞌeꞌeteꞌe haḡaiḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Rehano aniꞌa naenaeziro, “Faihateꞌe vazeḡaniꞌa, 'Farataḡo madu onamoꞌi,' rae eheha.” ");
INSERT INTO ksj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Zeḡeꞌa ḡadiniro, “Iniu vazeꞌa, 'Farataḡo madu onamoꞌi,' rae ḡaha?” ");
INSERT INTO ksj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Rehano manoriroteꞌe vazeḡaꞌe iniuꞌa ani fainirotaꞌaꞌe aḡuꞌa, mazaḡa Iesuꞌa eꞌea radiroteꞌe azaḡa ḡunuḡano dauḡiro. ");
INSERT INTO ksj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Eꞌe enogano Iesuꞌa kuru neḡa habaꞌano ani hidadu niro, “Ḡianoꞌi, ḡa ꞌai manoreha. Eꞌanoꞌo ufeta sauꞌaniꞌa ḡae mazao mene fureranoga veize, haḡai sauꞌa ago bare haḡaoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ebu vaze eꞌeꞌa onamadu Iuda azaḡa boroboro ziro, “Faihateꞌe vazeḡaꞌe Iesu.” ");
INSERT INTO ksj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Iesuꞌa ugi vazeḡa Bana Madaḡano fainiroteꞌe uꞌano, Iuda azaḡa ibitoziꞌeteꞌe azaḡaniꞌa Iesu rae sausauniro. ");
INSERT INTO ksj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Rehano Iesuꞌa ziro, “Eḡe Mamaꞌa mada niduꞌa gaueꞌohe onao izidi, eꞌanoꞌo eḡe zuni gaueꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Iesuꞌa ꞌouge reiro ꞌahine, Iuda azaḡa ibitoziꞌeteꞌe azaḡaniꞌa ani matihi radu ufeta inariro. Aꞌe mene mazaḡa Iesuꞌa Bana Madaḡa goroḡa variꞌiroteꞌe daꞌo, rehano mazaḡa ani aneꞌa bare, “Badiꞌaꞌe eḡe Mama,” radu aneꞌa bare Badiꞌa teite idaniro. ");
INSERT INTO ksj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ebu Iesuꞌa naenaeziro, “Eḡeꞌa hube hune ziꞌohe, Badiꞌa Ubugaꞌe ane daꞌo ḡau ꞌahoga haḡaogaꞌe mene idaḡa, rehano Moganiꞌa haḡaeꞌeteꞌe haḡaiḡa horonadu eꞌe hegote haḡaeꞌohe. Mazaḡa Moganiꞌa haḡaeꞌeteꞌe haḡaiḡa Badiꞌa Ubuga zuni haḡaeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mogaꞌe ani Ubuga zamare borofeꞌohe, ebu aniꞌa nagini haḡaeꞌeteꞌe haḡaiḡa niduꞌa Ubuga ihoneꞌohe. Ebu ꞌahiguḡa ufeta vitineꞌeteꞌe haḡaiḡa ḡihiꞌaḡa Ubuga ihonadu zae mae zaguzaguziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Moganiꞌa rune azaḡa mae ḡihizadu ḡabozeꞌeteꞌe teige, Ubuga zuni aneꞌa urateꞌeteꞌe azaḡa ḡabone ziniꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ebu Moganiꞌa vaze ꞌahoga mene kotazeꞌohe, rehano kota gauḡa niduꞌaꞌe Ubuga ꞌevora tiro. ");
INSERT INTO ksj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Eꞌanoꞌo vaze niduꞌaꞌe Moga gubaneꞌeteꞌe teige, Ubuga zuni gubaniꞌuma. Iniu Ubuga mene gubaneꞌeteꞌe vazeḡaꞌe ani tuḡuniroteꞌe Moga mene gubaneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Eḡeꞌa hube hune ziꞌohe, iniu eḡe ḡoere igiꞌeteꞌe zu eḡe tuḡuhiroteꞌe vazeḡa mazao fieꞌeteꞌe vazeḡaꞌe ḡabone tuḡutuḡu hidiro. Badiꞌaꞌa ani mene kotaneꞌohe ebu aniꞌe runeonoꞌo ḡabone meiro. ");
INSERT INTO ksj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Eḡeꞌa hube hune ziꞌohe, rune azaḡaniꞌa Baidꞌa Ubuga ago igiteꞌe madaḡaniꞌa ariꞌuma, ebu izidi feureha. Ani ago igiꞌeteꞌe azaḡaꞌe ḡabodiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mogaꞌe vaze ḡabozeꞌeteꞌe ḡaboneḡa meiroteꞌe teige, Ubuga zuni hanadu Ubugaꞌe ḡabozeꞌeteꞌe ḡaboneḡa meiro. ");
INSERT INTO ksj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ebu aniꞌe Vaze Ubuga radu Moganiꞌa vaze kotazeꞌeteꞌe gigiꞌaḡa haro. ");
INSERT INTO ksj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Eꞌe moneo ago zaguzaganoꞌi, mazaḡa mada ꞌahoganiꞌa arine, rune azaḡa niduꞌa iduonoꞌo Ubuga ago igiꞌuma, ");
INSERT INTO ksj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ebu ze bare ḡabodiꞌuma. Manoḡa haḡairoteꞌe azaḡaꞌe ḡabone veize bare ḡabodiꞌuma, u sauꞌa haḡairoteꞌe azaḡaꞌe kotazoga veize bare ḡabodiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","E ḡau ꞌahoga eḡeꞌa bare haḡaogaꞌe mene idaḡa. Mamaꞌa ihiꞌeteꞌe idunaḡano, e vaze kotazeꞌohe. Eḡe kotaꞌe duduḡa, mazaḡa e eḡe urao mene haḡaeꞌohe, rehano eḡe tuḡuhiroteꞌe vazeḡa urao haḡaeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“E eḡeꞌa bare eḡe moneo rae furenine, za mene mae ḡihihiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Rehano Mamaꞌa eḡe veize rae fureneꞌohe. E edeḡa, ane eḡe moneo rae fureneꞌetaꞌaꞌe hube. ");
INSERT INTO ksj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Zaꞌa vaze nu Ioane vaḡe tuḡuzirotene, ani eḡe moneo ḡoere huga rae fureniro. ");
INSERT INTO ksj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","E vazeꞌa eḡe moneo rae furenoga mene urateꞌohe. Rehano e Ioane ḡoereꞌe hube rae ziꞌetaꞌaꞌe zaꞌa ani ḡoere egadu ḡabone hidoga veize raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ioaneꞌe ihure duhuḡa teige zamaze aganiro, ebu za mada tahiḡa ani agaḡano matuꞌihi reiro. ");
INSERT INTO ksj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Rehano eḡe moneo rae fureneꞌeteꞌe ḡauḡa ꞌahogaꞌe eḡe mazao eꞌe. Aꞌe Ioaneꞌa eḡe moneo rae fureniroteꞌe ḡoeꞌa vitinoga. Mamaꞌa eḡe mazao gau nu enadu 'Haḡae hauḡoꞌi,' reiro, ebu e izidi eꞌe gauḡa niduꞌa haḡaeꞌohe. Eꞌe gauḡa niduꞌa Mamaꞌa eḡe tuḡuhiroteꞌe rae fureneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ebu Mamaꞌa eḡe tuḡuhadu ani aneꞌa bare eḡe moneo rae fureniro. Rehano za ani ago mene hune igiro zu iraḡa mene hune horoniro. ");
INSERT INTO ksj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Za aniꞌa tuḡuniroteꞌe vazeḡa mazao mene fieꞌeteꞌe uꞌano, ani ḡoereꞌe zae zamao mene radiuꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Zaꞌe Buka Zaḡoḡa faifaine ḡianeꞌohe, mazaḡa eꞌe ḡianine, ḡabone tuḡutuḡu hidiꞌuma rae zamareꞌohe. Buka Zaḡoḡaniꞌa eḡe moneo rae fureneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Rehano za eḡe vaḡe aradu ḡabone tuḡutuḡu hidoga hezahohauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","E vazeꞌa niguheꞌeteꞌe mene mae ḡihineꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","E edeḡa, za zamaze niduꞌa hina Badiꞌa mene zamareꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Eꞌe Mamahe niḡano ariro, rehano za e mene mae ḡihiheꞌohe. U vaze ꞌahoganiꞌa ane niḡano arine, za ani mae ḡihiniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Za zaeꞌa bare nigutiteꞌohe, rehano Badiꞌa tibuhuganiꞌa za niguzoga mene uratadu eꞌe veizeꞌe mene inareꞌohe. Eꞌanoꞌo zaꞌa eḡe mazao fioga zuni mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Eḡeꞌa Mama ubumao za kotao ohoziꞌuma rae ago zamaroꞌi. Za kotao ohozeꞌeteꞌe vazeḡaꞌe Mose. Zaꞌe Mose goro ḡoeꞌa hegotadu ḡabone hidiꞌuma rae zamareꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Zaeꞌa Mose mae ḡihinifone, eḡe mazao fifo, mazaḡa aniꞌe Buka Zaḡoḡano eḡe moneo mirihiro. ");
INSERT INTO ksj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Rehano za Moseꞌa mirihiroteꞌe ḡoeꞌaꞌe mene mae ḡihineꞌohe. Tena nougenouge eḡe ḡoere mae ḡihiniꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Eꞌe enogano Iesuꞌe Galilea duꞌuraḡa, niḡa ꞌahogaꞌe Tiberia, moneafa fare onamiro. ");
INSERT INTO ksj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ebu vaze ḡuḡuvaḡaniꞌa ani hegotiro, mazaḡa ze aniꞌa ugi azaḡa mazao haḡairoteꞌe haḡai nu badeḡa horoniro. ");
INSERT INTO ksj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ebu Iesuꞌa maḡa itadu ane tahiꞌatahiꞌa teite eꞌea ehoriro. ");
INSERT INTO ksj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Iuda azaḡa Iḡine Modiroteꞌe Muiḡaꞌe hanitiro. ");
INSERT INTO ksj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iesuꞌa dude ehamanadu vaze ḡuḡuvaḡaniꞌa ane vaḡe areꞌeteꞌe horonirotene, Filipi ḡadiniro, “Eme vaze ḡuḡuvaḡa ꞌadi ḡubuzoga veize ꞌuvahu odogaꞌe nouma hoitiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ani Filipi tuhune nurihi radu ꞌouge rae ḡadimaro, mazaḡa ani aneꞌa bare nagini haḡaiꞌuma rae ederiro. ");
INSERT INTO ksj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ebu Filipiꞌa naenaeniro, “Bato fuꞌo uḡidu fare gauḡa hadiḡa hina ꞌuvahu odoga hoitadu, ze tibatiba anoga veize tahitahe zinine zuni mene idaraꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ebu Iesu tahiꞌa ꞌahoga, Simona Petero negoḡa, Andereaꞌa niro, ");
INSERT INTO ksj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“ꞌAdao tahiꞌa ohozeḡa ꞌahoga mazaoꞌe ꞌuvahu odoga fuꞌo zu ḡozone aheu eꞌe, rehano vaze ufeta ḡehaḡa uꞌano mene idaraꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ebu Iesuꞌa ane tahiꞌatahiꞌa ziro, “Vaze niduꞌa ehoroꞌi rae zoꞌi.” Aꞌe ve ḡunuḡa habaꞌa uꞌano, zeḡe niduꞌa eꞌe rana ehoriro. Zeḡe boꞌaḡano ohoze niduꞌaꞌe 5,000 heuḡa. ");
INSERT INTO ksj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ebu Iesuꞌa ꞌuvahu odoga madu Badiꞌa mazao manoḡa tauḡi reiro, ebu eꞌea ehore radiuꞌeteꞌe azaḡa ḡahugiro. Ebu ḡozone zuni ꞌouge haḡadu zeḡe urao borofe aro. ");
INSERT INTO ksj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Vaze niduꞌa au ubararotene, Iesuꞌa ane tahiꞌatahiꞌa ziro, “Ogomu ḡahaꞌaḡahaꞌa ago mode tauḡoꞌi, rehano niduꞌa nuꞌonoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Eꞌanoꞌo ꞌuvahu odoga fuꞌo hina vaze niduꞌa borofe aroteꞌe enogano modiroteꞌe ogomuḡa nuꞌonirotene, tunahu niduꞌa gaubanana aheu fare iri'avoniro. ");
INSERT INTO ksj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Iesuꞌa haḡai nu badeḡa haḡairoteꞌe vaze niduꞌa horonadu ꞌahige ḡadahe ḡoeriro, “Hube hune vaze ꞌadiꞌe raha ꞌahao ariꞌuma rae reiroteꞌe peroveta vazeḡa!” ");
INSERT INTO ksj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iesuꞌe zeꞌa aradu inaraze hina ani obone kinio ohonihi rae ederiro. ꞌOugadu ane daꞌo maḡa bare itiro. ");
INSERT INTO ksj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ḡoravararotene, Iesu tahiꞌatahiꞌaꞌe Galilea duꞌuraḡa ovoiro. ");
INSERT INTO ksj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Uzaborarotene, Iesuꞌa zeḡe vaḡe mene ariroteꞌe uꞌano, ze ḡasio tiriro ebu duꞌura moneafa faradu Kaperanauma onamiro. ");
INSERT INTO ksj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ebu zavara boroꞌa feuradu saꞌuꞌa vu kafeniro. ");
INSERT INTO ksj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ze fuꞌo ga fuꞌo tiba fare kilomita reve onamirotene, Iesuꞌa vu rana onamadu ḡasize hanitiroteꞌe horoniro. ꞌOugadu ze rihau rudaro. ");
INSERT INTO ksj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Rehano aneꞌa ziro, “ꞌAdiꞌe eḡe. Ago rihanoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Eꞌebone ze ani ḡasio mae zouniro ebu ḡasiꞌe zeḡeꞌa onameꞌeteꞌe habaꞌano zogone hebetiro. ");
INSERT INTO ksj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Irarirotene, duꞌura moneafao radiuꞌeteꞌe vaze ḡuḡuvaḡaniꞌa ederiro, ohoḡoreꞌe ḡasi tiba daꞌo eꞌea radiro, ebu Iesuꞌe ane tahiꞌatahiꞌa teite ḡasio mene tiradu ane tahiꞌatahiꞌaꞌa daꞌo onamiro. ");
INSERT INTO ksj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Eꞌe madaḡano ḡasi nuꞌe Tiberiaonoꞌo ariro, ebu Zuhiꞌa Boroꞌa kuranadu vaze ḡuḡuvaḡa ꞌuvahu odoga hina ḡubuziroteꞌe habaꞌano hebetiro. ");
INSERT INTO ksj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ebu Vaze ḡuḡuvaḡaniꞌa ehamanadu Iesu zu ane tahiꞌatahiꞌaꞌe deꞌea mene horozirotene, ḡasizeo tiradu Iesu vaḡe Kaperanauma onamiro. ");
INSERT INTO ksj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ze Iesu duꞌura moneafao horonadu ḡadiniro, “Rabi, ḡa naniꞌa ꞌaha feureha?” ");
INSERT INTO ksj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iesuꞌa naenaeziro, “Eḡeꞌa hube hune ziꞌohe, za eḡe vaḡeꞌetaꞌaꞌe, mene mazaḡa eḡeꞌa haḡairoteꞌe haḡai nu badeḡa horoneha, rehano mazaḡa ꞌuvahu odoga au idaraneha. ");
INSERT INTO ksj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ruhuruꞌeteꞌe ogomuḡa veize ago gauoꞌi, rehano ḡabone tuḡutuḡu hidifine mene hauḡeꞌeteꞌe ogomuḡa veize gauoꞌi. Eꞌe ogomuḡaꞌe Vaze Ubuganiꞌa ziniꞌuma, mazaḡa aniꞌe ꞌouge haḡaoga veize Moga Badiꞌaꞌa ohoniro.” ");
INSERT INTO ksj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ebu zeḡeꞌa ḡadiniro, “Badiꞌa gauḡa haḡaifine eme nougiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Iesuꞌa naenaeziro, “Badiꞌa gauḡaꞌe aneꞌa tuḡuniroteꞌe vazeḡa mazao fieꞌeteꞌe raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Zeḡeꞌa niro, “Eme horonadu ḡae mazao fioga veize, ḡa haḡai nu badeḡa ꞌahoga haḡaoꞌi. Ḡa nagi haḡai nu badeḡa haḡaiꞌuma? ");
INSERT INTO ksj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Buka Zaḡoḡano Moseꞌa haḡairoteꞌe haḡaiḡa moneo ꞌahige rae mirihiro, 'Vaze niduꞌa anoga veize aniꞌa adureonoꞌo ogomu ziniro.' Eꞌe teige, eme vouḡaꞌe haba bohaꞌano onamiroteꞌe zamaḡano mana aro.” ");
INSERT INTO ksj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Iesuꞌa ziro, “Eḡeꞌa hube hune ziꞌohe, adureonoꞌo ogomu ziniroteꞌe vazeḡaꞌe mene Mose, rehano eḡe Mama. Aniꞌa adureonoꞌo ogomu huga ziniꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Badiꞌaꞌa ziniꞌeteꞌe ogomuḡaꞌe adureonoꞌo ovadu raha ꞌadi azaḡa ḡabone ziniꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Zeḡeꞌa niro, “Vaze boro, eꞌe ogomuḡaꞌe mada niduꞌa rifoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Iesuꞌa ziro, “Eꞌe ḡabone ziniꞌeteꞌe ogomuḡa. Iniu eḡe vaḡe areꞌeteꞌe vazeḡaꞌe mene hune vininiꞌuma, ebu iniu eḡe mazao fieꞌeteꞌe vazeḡaꞌe iriga mene hune moꞌoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Rehano e ibite ziroteꞌe teige, zaꞌe e horoheha rehano, eḡe mazao mene fieꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mamaꞌa iniꞌeteꞌe azaḡa niduꞌaꞌe eḡe vaḡe ariꞌuma, ebu iniu eḡe vaḡe areꞌeteꞌe vazaḡaꞌe eḡeꞌa mene hune hegone vaḡiniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Eḡeꞌa eḡe ura haḡaoga veize adureonoꞌo mene ovairo, rehano eḡe tuḡuhiroteꞌe vazeḡa ura haḡaoga veize ovairo. ");
INSERT INTO ksj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ebu eḡe tuḡuhiroteꞌe vazeḡa uraꞌe, aniꞌa iniroteꞌe azaḡa boꞌaḡano tiba zuni eḡeꞌa mene daunadu, mada ḡonagano zeḡe niduꞌa bare ḡabozeꞌeteꞌe raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Eḡe Mamaꞌe iniu Ubuga horonadu ane mazao fieꞌeteꞌe azaḡa niduꞌa ḡabone tuḡutuḡu hidoga urateꞌohe. E mada ḡonagano ze bare ḡaboziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ebu Iuda azaḡaniꞌa Iesu moneo gumude ḡoeriro, mazaḡa ani aneꞌa bare adureonoꞌo ovairoteꞌe ogomuḡa rae reiro. ");
INSERT INTO ksj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ebu ze ꞌahige rae reiro, “Vaze ꞌahiꞌe Iosefa ubuga Iesu. Eme ani viꞌa zu moga edeḡa. Ani nougadu, 'Eꞌe adureonoꞌo ovairo,' rae raꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iesuꞌa ziro, “Za eḡe moneo ago gumude ḡoeroꞌi. ");
INSERT INTO ksj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mamaheꞌa eḡe tuḡuhiro. Eꞌanoꞌo aniꞌa vaze mene ibitohaune, vazeni ꞌahoganiꞌa eḡe vaḡe aroga mene idaḡa. Eḡe vaḡe areꞌeteꞌe vazeḡaꞌe mada ḡonagano eḡeꞌa bare ḡaboniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Buka Zaḡoḡano peroveta azaḡaniꞌa ꞌahige rae mirihiro, 'Badiꞌaꞌa zeḡe niduꞌa ihoziꞌuma.' Iniu Mama ḡoere egohuꞌeteꞌe zu ani mazaonoꞌo edeḡa maꞌeteꞌe azaḡa niduꞌaꞌe eḡe vaḡe areꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Vazeni ꞌahoganiꞌa Mama mene horoniro, rehano Badiꞌa mazaonoꞌo ariroteꞌe vazeḡaniꞌa daꞌo Mama horoniro. ");
INSERT INTO ksj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Eḡeꞌa hube hune ziꞌohe, iniu eḡe mazao fieꞌeteꞌe vazeḡaꞌe ḡabone tuḡutuḡu hidiro. ");
INSERT INTO ksj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Eꞌe ḡabone ziniꞌeteꞌe ogomuḡa. ");
INSERT INTO ksj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Zae vouḡaꞌe haba bohaꞌano mana aro, rehano ze rudaro. ");
INSERT INTO ksj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","U ogomu ꞌadiꞌe adureonoꞌo ovadu iniuꞌa eꞌe aune, ani mene rudaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Eꞌe adureonoꞌo ovadu ḡabone ziniꞌeteꞌe ogomuḡa. Iniu ogomu ꞌahi aune, radiu tuḡutuḡiꞌuma. Eꞌe ogomuḡaꞌe eḡe ahiri. Raha ꞌadi azaḡa ḡabozifine, eḡeꞌa ahirihe ziniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ebu Iuda azaḡaniꞌa zeḡeꞌa bare taꞌirotiteꞌenaꞌa, ꞌahige rae reiro, “Vaze ꞌadiꞌe nougenouge ahiꞌa rifadu eme aꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iesuꞌa ziro, “Eḡeꞌa hube hune ziꞌohe, za Vaze Ubuga ahiri mene aune zu ruḡa mene gagine, zamazeo ḡaboneꞌe oꞌoꞌa. ");
INSERT INTO ksj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Iniu eḡe ahiri auꞌeteꞌe zu ruhe gageꞌeteꞌe vazeḡaꞌe ḡabone tuḡutuḡu hidiro, ebu mada ḡonagano eḡeꞌa ani bare ḡaboniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mazaḡa eḡe ahiriꞌe ogomu huga zu eḡe ruꞌe vu huga. ");
INSERT INTO ksj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Iniu eḡe ahiri auꞌeteꞌe zu eḡe ru gageꞌeteꞌe vazeḡaꞌe eḡe teite tiburanadu radiuꞌohe, ebu eḡe zuni ani teite tiburanadu radiuꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mama ḡabode radiuꞌeteꞌeꞌa tuḡuhiro, zu ani uꞌano eḡe zuni ḡabodeꞌohe. Eꞌe teige, iniu eḡe ahiri auꞌeteꞌe vazeḡaꞌe eḡe uꞌano ḡabodiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Eꞌe adureonoꞌo ovairoteꞌe ogomuḡa huga. Ogomu ꞌahiꞌe mene vouḡazeꞌa aroteꞌe ogomuḡa heuḡa. Ze oganadu vesuꞌu rudaro. U ogomu ꞌahi auꞌeteꞌe vazeḡaꞌe ḡabone tuḡutuḡu hidiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesuꞌa ꞌadi ḡoeꞌa Kaperanauma nu'onu'o neḡano ihoziroteꞌe zamaḡano ziro. ");
INSERT INTO ksj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Iesu tahiꞌa ḡehaḡaniꞌa ani ḡoere eꞌe egadu ꞌahige rae reiro, “Ani ihoreꞌe riḡa. Iniuꞌa eꞌe mae ḡihiniꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iesuꞌe ane tahiꞌatahiꞌaꞌa ḡoere eꞌe uꞌano gumudeꞌeteꞌe ederadu ziro, “Ḡoere eꞌe uꞌano zamaze aduduꞌehe? ");
INSERT INTO ksj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Tena za Vaze Ubuganiꞌa ibite radiroteꞌe habaꞌa bare itoga horonine, nougiꞌuma? ");
INSERT INTO ksj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Badiꞌa Vineꞌe ḡabone ziniꞌohe. Vaze inaraonoꞌo ḡabone hidoga mene idaḡa. Eḡeꞌa zeateꞌe ḡoeꞌanonoꞌo za Badiꞌa Vine maꞌohe zu ḡabone hideꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Rehano zae boꞌaḡano nuꞌe eḡe mazao mene fieꞌohe.” Iesuꞌe ḡadaheḡanonoꞌo iniuꞌa ani mazao mene firotaꞌaꞌe zu iniuꞌa revohatitaꞌaꞌe ederiro ꞌahine, ꞌouge reiro. ");
INSERT INTO ksj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ebu aniꞌa ziro, “Eꞌe uꞌano, e ibite ꞌahige rae reiro, 'Mamaꞌa iniu eḡe vaḡe aroga gararine, vazeni ꞌahoga zuni eḡe vaḡe arogaꞌe mene idaḡa.'” ");
INSERT INTO ksj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Eꞌe madaḡanonoꞌo ane tahiꞌa ḡehaḡaniꞌa ani modadu mene bare hegotiro. ");
INSERT INTO ksj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ebu Iesuꞌa ane tahiꞌa gaubanana aheu fare ḡadiziro, “Zae zuni eḡe modihi raꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simona Peteroꞌa naenaeniro, “Zuhiꞌa Boro, ḡabone tuḡutuḡu rifiꞌeteꞌe ḡoeꞌaꞌe ḡae mazao, eꞌanoꞌo eme ḡa mene modiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Eme ḡaꞌe Badiꞌa mazaonoꞌo ariroteꞌe Vazeḡa Zaḡoḡa rae fieꞌohe zu edereꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Iesuꞌa naenaeziro, “E za, gaubanana aheu fare ohoziro, rehano zae boꞌaḡano vaze tibaꞌe Diaboloꞌa ragano reiro.” ");
INSERT INTO ksj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iesuꞌa Isakariota vazeḡa Simona ubuga, Iuda moneo ꞌouge reiro. Ani zuni Iesu tahiꞌa gaubanana aheu fare boꞌaḡano tahiꞌa ꞌahoga, rehano vesuꞌu Iesu revohatiteꞌe vazeḡa reiro. ");
INSERT INTO ksj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Eꞌe enogano Iesuꞌa Galilea habaꞌano ragave onamiro. Ani Iudea habaꞌano ragavoga mene uratiro, mazaḡa eꞌea Iuda azaḡa ibitoziꞌeteꞌe azaḡaniꞌa ani matihi radu guhine radiro. ");
INSERT INTO ksj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ebu Iuda azaḡa mui ꞌahoga, Taruha Muiḡaniꞌa hanitiro. ");
INSERT INTO ksj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ꞌOugadu Iesu negoḡa duḡuruꞌa Iesu niro, “Ḡa haba ꞌahi modadu Iudea habaꞌa onamoꞌi. ꞌOugine ḡa hegoteꞌeteꞌe azaḡaniꞌa ḡaeꞌa haḡaeꞌeteꞌe haḡai gigiꞌaḡa horoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Iniu ane bare vaze mazao furenihi raꞌeteꞌe vazeḡaꞌe gau ꞌahoga mene sifu haḡaeꞌohe. Ḡa haḡai ꞌahiguḡa haḡaeꞌeteꞌe uꞌano, raha ꞌadi azaḡa niduꞌa mazao ḡaeꞌa bare fureꞌoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Iesu negoḡa duḡuruꞌa ꞌouge nirotaꞌaꞌe mazaḡa zeḡe zuni ani mene mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ebu Iesuꞌa naenaeziro, “Izidiꞌe eḡeꞌa mene onamiteꞌe madaḡa, rehano za zae ura madaḡano onamogaꞌe idaḡa. ");
INSERT INTO ksj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Raha ꞌadi azaḡaꞌe za mene heꞌeheꞌezeꞌohe, u eꞌe heꞌeheꞌeheꞌohe, mazaḡa e haḡaizeꞌe sauꞌa rae fureneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Za mui eꞌe veize onamoꞌi. E izidiꞌe mui eꞌe veize mene onamiꞌuma, mazaḡa eḡe madaꞌe ꞌize mene feureha.” ");
INSERT INTO ksj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ani ꞌouge rae zeadu Galilea habaꞌano radiro. ");
INSERT INTO ksj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Iesu negoḡa duḡuruꞌe mui eꞌe uꞌa itiroteꞌe enogano ani vazeꞌa mene ederifine vesuꞌu sifu itiro. ");
INSERT INTO ksj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ebu Iuda azaḡa ibitoziꞌeteꞌe azaḡaniꞌa mui madaḡano Iesu vaḡe ragaveꞌenaꞌa, vaze eꞌea ḡadimaro, “Vaze aꞌe noumao?” ");
INSERT INTO ksj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ebu vaze ḡuḡuvaḡaniꞌa Iesu moneo gumudiro. Nuꞌe raenaꞌa, “Aniꞌe vaze manoḡa,” ebu nuꞌe raenaꞌa, “Mene, ani vaze soꞌozeꞌohe,” rae reiro. ");
INSERT INTO ksj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Rehano ze Iuda azaḡa boroboro rihoziro ꞌahine, Iesu moneo hunio mene rae fureniro. ");
INSERT INTO ksj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mui eꞌe ḡahaꞌa hauḡirotene, Iesuꞌa kuru neḡa habaꞌa itadu vaze ḡadahe ihoziro. ");
INSERT INTO ksj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ꞌOugadu Iuda azaḡa ibitoziꞌeteꞌe azaḡaꞌe zaguzaganadu ꞌahige rae reiro, “Vaze ꞌadiꞌe mene hune mirihiro, rehano ani edeḡa ꞌahiguḡaꞌe nougenouge meiro?” ");
INSERT INTO ksj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Iesuꞌa naenaeziro, “Eḡe ihoreꞌe mene eḡe mazaonoꞌo, rehano eḡe tuḡuhiroteꞌe vazeḡa mazaonoꞌo ariro. ");
INSERT INTO ksj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Iniu Badiꞌa ura haḡaihi raꞌeteꞌe vazeḡaꞌe ederiꞌuma, eḡe ihoreꞌe Badiꞌa mazaonoꞌo ariro ga eḡe edeḡanonoꞌo ariro. ");
INSERT INTO ksj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Iniu ane edeḡano ḡoereꞌeteꞌe vazeḡaꞌe vazeꞌa ani nigunoga urateꞌohe. U ani tuḡuniroteꞌe vazeḡa nigunoga urateꞌeteꞌe vazeḡaꞌe ḡoere huga raꞌohe zu ani mazao veꞌoḡa oꞌoꞌa. ");
INSERT INTO ksj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moseꞌa goro ḡoeꞌa za ziniro, rehano zae boꞌaḡano vaze ꞌahoga zuni eꞌe mene hegoteꞌohe. Nougadu za e uḡuhe ruhihi raꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Vaze ḡuḡuvaḡaniꞌa naenaeniro, “Vine sauꞌaniꞌa ḡa ragano reiro! Ḡa ḡame nuriꞌeteꞌe vazeḡaꞌe oꞌoꞌa.” ");
INSERT INTO ksj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Iesuꞌa ziro, “Eḡeꞌa Bana Madaḡano haḡai gigiꞌa ꞌahoga haḡadu zae niduꞌa zaguzagauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moseꞌa ahiri rana iḡuri haḡaeꞌeteꞌe goroḡa ḡoeꞌa ziniro. (Ahiri rana iḡuri haḡaeꞌeteꞌe goroḡa ḡoeꞌaꞌe mene Moseonoꞌo, rehano ꞌizema Moseꞌa fureranogano vouḡazeonoꞌo ariro.) Eꞌanoꞌo za Bana Madaḡano zuni tahiꞌa komeꞌa ahiri rana iḡuri haḡaeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Za Mose goro ḡoeꞌa mene variꞌoga veize, mada tibatiba Bana Madaḡano zuni tahiꞌa komeꞌa ahiri rana iḡuri haḡaeꞌohe. Tena eḡeꞌa Bana Madaḡano vaze ꞌahoga ahiri niduꞌa fainiroteꞌe uꞌano, za nougadu eḡe mazao maḡuneꞌohe? ");
INSERT INTO ksj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Zaꞌe vaze enona daꞌo ḡianadu veꞌoḡa rae ago roꞌi. Rehano huga ḡianadu duduḡa ga veꞌoḡa rae roꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Eꞌe madaḡano Ierusalemao radiuꞌeteꞌe azaḡaniꞌa ḡadimutitiro, “Vaze ꞌadiꞌe zeꞌa matihi rae inareꞌeteꞌe vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ani hunio ḡoereꞌohe, rehano ze ani rana ḡoere ꞌahoga mene raꞌohe. Iuda azaḡa boroboroꞌa zuni aniꞌe hube hune Keriso raꞌeteꞌe mae ḡihineꞌehe? ");
INSERT INTO ksj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Rehano aniꞌe mene Keriso, mazaḡa eme vaze ꞌadi noumanoꞌo arirotaꞌaꞌe edeḡa. Kerisoꞌa arine, vazeni ꞌahoga zuni ani noumanoꞌo ariroteꞌe mene ederiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ebu Iesu ꞌize kuru neḡa habaꞌano ihozeꞌeteꞌea, ani ḡihau ḡoeriro, “Oꞌe, za e edeḡa ebu e noumanoꞌo arirotaꞌaꞌe edeḡa. Rehano e eḡe edeḡano mene ariro. Eḡe tuḡuhiroteꞌe Badiꞌaꞌe hube hune. Za ani aḡuꞌa. ");
INSERT INTO ksj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","U e ani edeḡa, mazaḡa eꞌe ani mazaonoꞌo ariro zu aniꞌa eḡe tuḡuhiro.” ");
INSERT INTO ksj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ꞌOuge reirotene, ze Iesu obone ti nuriro, rehano vaze ꞌahoga ꞌevoꞌa hina mene oboniro, mazaḡa ani madaḡaniꞌa ꞌize mene feuriro. ");
INSERT INTO ksj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Rehano vaze ḡuḡuvaḡa boꞌaḡano vaze ḡehaḡaꞌe Iesu mazao fiadu reiro, “Kerisoꞌa aradu haḡai nu badeḡa haḡaine zuni, vaze ꞌadi mene ufeta vitine haḡaiꞌuma!” ");
INSERT INTO ksj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisea azaḡaꞌe vaze ḡuḡuvaḡaniꞌa Iesu moneo ꞌouge gumude ḡoeriroteꞌe igiro. Eꞌanoꞌo dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu Farisea azaḡaniꞌa Iesu obone tihi radu kuru neḡa uti azaḡa tuḡuziro. ");
INSERT INTO ksj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ꞌOugadu Iesuꞌa ziro, “E zae teite mada tahiḡa daꞌo radadu eḡe tuḡuhiroteꞌe vazeḡa vaḡe onamiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Za eḡe vaḡiꞌuma, rehano mene horohiꞌuma. Ebu zaꞌe eḡeꞌa radiuꞌeteꞌe habaꞌa onamogaꞌe mene idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ebu Iuda azaḡa ibitoziꞌeteꞌe azaḡaꞌe zeḡeꞌa bare ḡadimutitiro, “Ani noꞌe onamiꞌuma ꞌahine, eme ani mene horoniꞌuma raꞌohe? Ani Iuda azaḡaniꞌa radiuꞌeteꞌe Giriki azaḡa haba onamadu Giriki azaḡa ihoziꞌumahe? ");
INSERT INTO ksj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Aniꞌa ꞌahige raꞌohe, 'Za eḡe vaḡiꞌuma, rehano mene horohiꞌuma, ebu eḡeꞌa radiuꞌeteꞌe habaꞌa aroga zuni mene idaḡa.' Eꞌe hugaꞌe nagini?” ");
INSERT INTO ksj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mui ḡonaga madaḡaꞌe mada boro hune. Iesuꞌa edau iḡunadu vaze ḡuḡuvaḡa huze ziro, “Iniu iriga moꞌoneꞌeteꞌe vazeḡaꞌe eḡe vaḡe aroꞌi ebu gagoꞌi. ");
INSERT INTO ksj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Buka Zaḡoḡano reiroteꞌe teige, iniu eḡe mazao fieꞌeteꞌe vazeḡaꞌe ḡabone vuḡaniꞌa vu boro teige ane zamaḡanonoꞌo sore buaꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Aneꞌa ḡabone vuḡa reirotaꞌaꞌe Vine Zaḡoḡa moneo rae radu iniu ani mazao fieꞌeteꞌe azaḡaꞌe eꞌe hidiꞌuma rae reiro. Rehano eꞌe madaḡano Vine Zaḡoḡaꞌe ze ꞌize mene hidiro, mazaḡa Iesuꞌe ꞌize satauro rana mene rudanadu ani niꞌe mene mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Vaze ḡuḡuvaḡaniꞌa ḡoere eꞌe igirotene, nuꞌe ꞌahige rae reiro, “Vaze ꞌadiꞌe hube hune peroveta vazeḡa. Aꞌe emeḡeꞌa guhineꞌeteꞌe vazeḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","U vaze nuꞌe raenaꞌa, “Aniꞌe Keriso,” ebu nuꞌe raenaꞌa, “Mene, Kerisoꞌe Galilea habaꞌanonoꞌo mene ariꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Buka Zaḡoḡano ꞌahige rae reiro, 'Kerisoꞌe kini Davida mariganonoꞌo zu Davida ne Betelehemaonoꞌo ariꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Eꞌanoꞌo vaze ḡuḡuvaḡaꞌe Iesu uꞌano aꞌadaro. ");
INSERT INTO ksj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Vaze nuꞌe ani obone tihi reiro, rehano vazeni ꞌahoganiꞌa ani rana ꞌevore mene tiro. ");
INSERT INTO ksj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ebu kuru neḡa uti azaḡaniꞌa dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu Farisea azaḡa vaḡe bare onamiro. Ebu zeꞌa uti azaḡa ḡadiziro, “Za nougadu ani mene obone teadu tutune areha?” ");
INSERT INTO ksj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Zeḡeꞌa naenaeziro, “Vaze ꞌadi teige ḡoere manoḡa ḡoeriroteꞌe vazaḡaꞌe oꞌoꞌa!” ");
INSERT INTO ksj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farisea azaḡaniꞌa ziro, “Zae zuni aniꞌa soꞌozahe? ");
INSERT INTO ksj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Vaze ibitoziꞌeteꞌe azaḡa ga Farisea azaḡa boꞌaḡano ani mazao fieꞌeteꞌe vazeḡa ꞌahoga eꞌehe? Mene! ");
INSERT INTO ksj_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Vaze ḡuḡuvaḡa ꞌahiꞌe Mose goro ḡoeꞌa aḡuꞌa ꞌahine, ani mazao fieꞌohe. Eꞌanoꞌo ze radiu tuḡutuḡu adugaḡa hidiꞌuma!” ");
INSERT INTO ksj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ibite Iesu vaḡe onamiroteꞌe vazeḡa, Nikodemo zuni Iuda azaḡa ibitoziꞌeteꞌe vazeḡa ꞌahoga. Aniꞌa ḡadiziro, ");
INSERT INTO ksj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Emeḡe goro idunaḡano, emeꞌe vaze ḡoere egadu aniꞌa nagini haḡaeꞌeteꞌe ꞌizema ederogano aniꞌe veꞌoḡa rae mene raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ꞌOugadu zeḡeꞌa naenaeniro, “Ḡae zuni Galilea vazeḡahe? Buka Zaḡoḡa bare meꞌodoꞌi, ꞌougine peroveta vazeḡani ꞌahoga Galilea habaꞌano mene fureruꞌetaꞌaꞌe ederiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ebu ze zeḡezeḡe ne oname ḡouriro. ");
INSERT INTO ksj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ebu Iesuꞌa Olivi Maḡa onamiro. ");
INSERT INTO ksj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Irarirotene, oherebau uzeuze ani kuru neḡa habaꞌa onamiro. Ebu vaze niduꞌa ani vaḡe onamirotene, ani ehoradu ihoziro. ");
INSERT INTO ksj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ebu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa zu Farisea azaḡaniꞌa ubuma ḡezo roḡaeḡa ꞌahoga obone teadu vaze ḡuḡuvaḡa zamao ohone tiro. ");
INSERT INTO ksj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ebu ze Iesu niro, “Ihore vazeḡa, roḡae ꞌadaꞌa ubuma ḡezo haḡaeꞌeteꞌe emeḡeꞌa horonadu obone teha. ");
INSERT INTO ksj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mose goro ḡoeꞌano Moseꞌa ꞌahige rae reiro, ꞌRoḡae ꞌuguḡaꞌe hadi hina mau runoꞌi.' Ḡaꞌe nouge rae zamareꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ze ani tuhune nurihi radu ꞌouge rae ḡadimaro, mazaḡa aniꞌa veꞌore naenaezine ani kotao mae ohonihi reiro. Rehano Iesuꞌa ḡuḡuradu ꞌevoꞌa hina rahao mirihiro. ");
INSERT INTO ksj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ze Iesu barebare ḡadinirotene, aniꞌa iḡune edanadu ziro, “Zae boꞌaḡano iniu mazao haḡai sauꞌa oꞌoꞌa vazeḡaniꞌa ibite geno hadi hina ani mau bohinoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ebu ani bare ḡuḡuradu ꞌevoꞌa hina rahao mirihiro. ");
INSERT INTO ksj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ze Iesu ḡoere igirotene, ze tibatiba iḡune ḡouriro. Vaze boroboroꞌa ibitiro ebu komeꞌakomeꞌaꞌe vesuꞌu iḡuniro. Ebu Iesu ane daꞌo roḡae edauꞌeteꞌe teite eꞌea radiro. ");
INSERT INTO ksj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ebu Iesuꞌa bare iḡune edanadu roḡae eꞌe ḡadiniro, “Roḡae, ze noumao? Ḡaꞌe veꞌoḡa rae raꞌeteꞌe vazeḡani ꞌahogaꞌe oꞌoꞌahe?” ");
INSERT INTO ksj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Aneꞌa naenaeniro, “Vazeni ꞌahoga oꞌoꞌa, vaze boro.” Iesuꞌa niro, “Eḡe zuni ḡaꞌe veꞌoḡa rae mene raꞌohe. Onamoꞌi, ebu izidionoꞌo zama moneo haḡai sauꞌa ago bare haḡaoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Iesuꞌa bare ḡoeriro, “Eꞌe raha ꞌadi agaḡa. Iniu eḡe hegoteꞌeteꞌe vazeḡaꞌe uzabo zamaḡano mene hune ragaviꞌuma, rehano ḡabone hideꞌeteꞌe agaḡa meꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farisea azaḡaniꞌa niro, “Ḡa ḡaeꞌa bare ḡae moneo rae fureneꞌohe. Aꞌe huga oꞌoꞌa!” ");
INSERT INTO ksj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Iesuꞌa naenaeziro, “E eḡeꞌa bare eḡe moneo rae fureneꞌohe, rehano eḡe ḡoereꞌe huga, mazaḡa e noumanoꞌo ariroteꞌe zu noꞌe onamitaꞌaꞌe edeḡa. U zaꞌe eḡeꞌa noumanoꞌo ariroteꞌe zu noꞌe onamitaꞌaꞌe aḡuꞌa. ");
INSERT INTO ksj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Za raha azaḡa zamarone idunaḡano iniuꞌe duduḡa ga veꞌoḡa rae raꞌohe. Rehano e vaze ꞌahoga mazao duduḡa ga veꞌoḡa rae mene raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Rehano eḡeꞌa vaze mazao duduḡa ga veꞌoḡa rae reine zuni, aꞌe duduga, mazaḡa mene eḡe daꞌo, rehano eḡe tuḡuhiroteꞌe Mamaheꞌa eḡe teite radiuꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Zae goro ḡoeꞌano ꞌahige rae mirihiro, 'Vaze aheuꞌe ḡoere tiba reine, aꞌe hube.' ");
INSERT INTO ksj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","E eḡeꞌa bare eḡe moneo rae fureneꞌohe, ebu eḡe tuḡuhiroteꞌe Mamahe zuni eḡe moneo rae fureneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ebu zeḡeꞌa ḡadiniro, “ꞌOugadu mogoꞌe noumao?” Iesuꞌa naenaeziro, “Za eḡe zu Mamaꞌe aḡuꞌa. Zaeꞌa eḡe ederifone, eḡe Mama zuni ederifo.” ");
INSERT INTO ksj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iesuꞌa kuru neḡa habaꞌano ḡahunone hadiḡa ufeꞌeteꞌe maḡuḡa uhiḡano ihozeꞌeteꞌea, ḡoere ꞌadi ziro. Rehano ani madaꞌe ꞌize mene feuriro ꞌahine, ze ani mene obone tiro. ");
INSERT INTO ksj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iesuꞌa bare ziro, “Eꞌe oname dauḡiꞌuma, u zaꞌe eḡe vaḡiꞌuma, rehano za haḡaize sauꞌa zamaḡano rudaꞌuma. Ebu eḡeꞌa onamiteꞌe habaꞌaꞌe zaꞌa aroga mene idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Iuda azaḡa boroboroꞌe zeḡeꞌa bare ḡadimutitiro, “Ani aneꞌa bare maꞌumahe? Mazaḡa aniꞌa onamiteꞌe habaꞌaꞌe emeḡeꞌa onamogaꞌe mene idaḡa rae raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Rehano Iesuꞌa ziro, “Zaꞌe ꞌuꞌuḡanonoꞌo ariro, u eꞌe hitanaonoꞌo ariro. Zaꞌe raha ꞌadi azaḡa, u eꞌe raha ꞌadi mene vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Eꞌanoꞌo e zeha, 'Za haḡaize sauꞌa zamaḡano rudaꞌuma.' Za eḡeꞌa eḡe moneo iniu rae raꞌeteꞌe mene mae ḡihinine, za haḡaize sauꞌa zamaḡano rudaꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Zeḡeꞌa ḡadiniro, “Tena ḡa iniu?” Iesuꞌa ziro, “E ḡadaheḡanonoꞌo eꞌe iniu rae ziꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","E zae moneo zihi raꞌeteꞌe ḡoeꞌaꞌe ḡehaḡa ebu zaꞌe veꞌoḡa raꞌeteꞌe ḡoeꞌa zuni ḡehaḡa. Rehano eḡe tuḡuhiroteꞌe vazeḡaꞌe huga radu e ani mazaonoꞌo igiroteꞌe ḡoeꞌa daꞌo raha azaḡa ziꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Rehano ze Iesuꞌa Moga moneo zirotaꞌaꞌe mene ederiro. ");
INSERT INTO ksj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Eꞌanoꞌo Iesuꞌa ziro, “Vaze Ubugaꞌe zaeꞌa satauro rana mae ḡihiniteꞌe madaḡano, za eḡeꞌa ziꞌeteꞌe vazeḡaꞌe eḡe rae ederiꞌuma. Ebu e eḡe edeḡano ḡau ꞌahoga mene haḡaeꞌeteꞌe, rehano Mamaꞌa ihohiroteꞌe ḡauḡa daꞌo ḡoereꞌetaꞌaꞌe ederiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Eḡe tuḡuhiroteꞌe vazeḡaꞌe eḡe teite radiuꞌohe. Aniꞌe eḡe daꞌo mene mode tauḡiro, mazaḡa e iḡaiḡa aniꞌa matuꞌeꞌeteꞌe haḡaiḡa daꞌo haḡaeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Iesuꞌa ꞌouge reirotene, vaze ḡehaḡaniꞌa ani mazao firo. ");
INSERT INTO ksj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ebu Iesuꞌa Iuda azaḡa ani mazao fieꞌeteꞌe ziro, “Za eḡe ihore hegotine, hube hune eḡe tahiꞌatahiꞌa reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ebu za ḡoere huga ederiꞌuma. Zaꞌe tuḡure azaḡa teigeꞌohe, rehano ḡoere huga eꞌeꞌa tuḡure azaḡanonoꞌo za bohaze buziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Zeḡeꞌa naenaeniro, “Emeꞌe Aberahamo mariga. Eme vaze ꞌahoga tuḡure azaḡa mene hune reiro. Ḡa nougadu emeꞌe tuḡure azaḡanonoꞌo bohafe bufiꞌuma raꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Iesuꞌa naenaeziro, “Eḡeꞌa hube hune ziꞌohe, iniu haḡai sauꞌa haḡaeꞌeteꞌe vazeḡaꞌe haḡai sauꞌa tuḡure vazeḡa raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ebu tuḡure vazeḡaꞌe ani teite ne tibano radiuꞌeteꞌe azaḡa teite iḡaiḡa mene radiuꞌohe. U ubugaꞌe ani teite ne tibano radiuꞌeteꞌe azaḡa teite iḡaiḡa radiuꞌohe onamo tuḡutuḡu. ");
INSERT INTO ksj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Eꞌanoꞌo Ubuganiꞌa za haḡaize sauꞌanonoꞌo bohaze buzine, zaꞌe hube hune haḡaize sauꞌanonoꞌo buau radiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","E edeḡa, zaꞌe Aberahamo mariga. Rehano eḡe ḡoereꞌe zae zamao oꞌoꞌa uꞌano, za eḡe uḡuhe ruhihi raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","E Mamaꞌa ihohiroteꞌe ḡoeꞌa ziꞌohe. Rehano zaꞌe moze mazaonoꞌo igiroteꞌe haḡaeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Zeꞌa naenaeniro, “Aberahamoꞌe emeḡe mama.” Iesuꞌa ziro, “Zaꞌe Aberahamo ubugaubuga reifone, Aberahamoꞌa haḡairoteꞌe haḡaiḡa haḡaifo. ");
INSERT INTO ksj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Eꞌe Badiꞌa mazaonoꞌo igiroteꞌe ḡoeꞌa huga ziro, rehano za e uḡuhe ruhihi raꞌohe. Aberahamoꞌe mene ꞌougiro. ");
INSERT INTO ksj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Zaꞌe zae mozeꞌa haḡaeꞌeteꞌe haḡaiḡa haḡaeꞌohe.” Ebu zeḡeꞌa niro, “Emeꞌe mene butu ega. Badiꞌa ane daꞌoꞌe emeḡe Mama.” ");
INSERT INTO ksj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Iesuꞌa ziro, “Badiꞌaꞌe Moze reifone, za e zamare borofifo, mazaḡa e Badiꞌa mazaonoꞌo aradu izidi ꞌaha radiuꞌohe. E eḡeꞌa bare mene ariro, rehano aniꞌa tuḡuhadu ariro. ");
INSERT INTO ksj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Za nougadu eḡeꞌa raꞌeteꞌe ḡoeꞌa mene edereꞌohe? Mazaḡa zaꞌe eḡe ḡoere egoga mene urateꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mozeꞌe Diabolo, ebu zaꞌe moze ura haḡaihi raꞌohe. Aniꞌe ḡadaheḡanonoꞌo vaze maro zu hugano mene haḡaeꞌohe, mazaḡa ani zamaoꞌe huga oꞌoꞌa. Aniꞌa ḡurireꞌetaꞌaꞌe ane haḡai, mazaḡa aniꞌe ḡuriro vazeḡa, zu ḡuriro niduꞌaꞌe ani mazaonoꞌo fureruꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Eḡeꞌa ḡoere huga ziꞌe ꞌahine, za eḡe mazao mene fieꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Zae boꞌaḡano iniuꞌa eḡe mazao sauꞌa ꞌahoga horonadu eꞌe veꞌoḡa rae reꞌuma? E ḡoere huga raꞌohe, rehano nougadu zaꞌe eḡe mazao mene fieꞌohe? ");
INSERT INTO ksj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Iniu Badiꞌa mone vazeḡaꞌe Badiꞌa ḡoere igiꞌohe. Zaꞌe Badiꞌa ḡoere mene igiꞌohe, mazaḡa zaꞌe Badiꞌa mene mone azaḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ebu Iuda azaḡa boroboroꞌa Iesu naenaeniro, “Ḡa Samaria vazeḡa teige veꞌore ḡoereꞌohe, zu vine sauꞌaniꞌa ḡae ragano reiro. Emeḡe ḡoere ꞌahiꞌe mene duduḡahe?” ");
INSERT INTO ksj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Iesuꞌa naenaeziro, “E mene vine sauꞌaheta, rehano Mamahe gubaneꞌohe. U zaꞌe e mene gubaheꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","E vazeꞌa nihe mae ḡihinoga mene umizeꞌohe. Rehano vazeꞌa nihe mae ḡihinoga urateꞌeteꞌe vazeḡaꞌe eḡe teite radiuꞌohe, ebu aniꞌe kota vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Rehano eḡeꞌa hube hune ziꞌohe, iniuꞌa eḡe ḡoere hegotine, aniꞌe mene hune rudaꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Iuda azaḡa boroboroꞌa niro, “Izidi eme edereha, ḡaꞌe vine sauꞌaḡota! Aberahamo zu peroveta azaḡa zuni rudaro, rehano ḡa raenaꞌa, 'Iniu eḡe ḡoere hegoteꞌeteꞌe vazeḡaꞌe mene hune rudaꞌuma,' rae raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ḡaꞌe emeḡe vouḡa Aberahamo ufeta vitinogahe? Aniꞌe rudaro ebu peroveta azaḡa zuni rudaro. Ḡa ḡaeꞌa bare iniu rae zamareꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iesuꞌa naenaeziro, “E eḡeꞌa bare nihe mae ḡihinine, aꞌe huga oꞌoꞌa. Nihe mae ḡihineꞌeteꞌe vazeḡaꞌe eḡe Mama. Aniꞌe zaeꞌa zae Badiꞌa rae huneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Zaꞌe ani aḡuꞌa, u eꞌe ani edeḡa. E ani aḡuꞌa rae reifone, e zae teige ḡuriro vazeḡa reifo. Rehano e ani edeḡa zu ani ḡoere hegoteꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Zae vouḡa Aberahamoꞌe e raha ꞌada areꞌeteꞌe madaḡa horoniꞌuma rae zamaradu matuꞌe rudaro. Ebu aniꞌe eꞌe madaḡa horonadu matuꞌiro.” ");
INSERT INTO ksj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Iuda azaḡa boroboroꞌa niro, “Ḡa muriḡo 50 ꞌize mene maha. Nougenouge hena Aberahamo horoniro?” ");
INSERT INTO ksj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iesuꞌa ziro, “Eḡeꞌa hube hune ziꞌohe, Aberahamoꞌe ꞌizema fureranogano, eꞌe radiro.” ");
INSERT INTO ksj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Eꞌebone ze hadi mae ḡihinadu Iesu mau runihi reiro. Rehano ani kuru neḡa habaꞌanonoꞌo ꞌuꞌuru buanadu dauḡiro. ");
INSERT INTO ksj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iesuꞌa onamiroteꞌea, fureraroteꞌe madaḡanonoꞌo ubuma kuruḡa vazeḡa ꞌahoga horoniro. ");
INSERT INTO ksj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ebu ane tahiꞌatahiꞌaꞌa ḡadiniro, “Rabi, aniꞌa ubumaḡa kuruḡano furerarotaꞌaꞌe ane haḡai sauꞌa uꞌano ga viꞌa moga haḡai sauꞌa uꞌano?” ");
INSERT INTO ksj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iesuꞌa naenaeziro, “Aꞌe ani mene haḡai sauꞌa ga viꞌa moga haḡai sauꞌa uꞌano, rehano ani ḡabone zamaḡano Badiꞌaꞌa nougenouge gaueꞌeteꞌe vaze ihozoga veize ani ubumaḡa kuruḡano fureraro. ");
INSERT INTO ksj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Madaꞌa agaruꞌeteꞌe zamaḡano emeḡeꞌa eḡe tuḡuhiroteꞌe vazeḡa gau haḡaiꞌuma. Ohereꞌa arine, vazeni ꞌahogaꞌe gauoga mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","E ꞌize raha ꞌada radiuꞌeteꞌe zamaḡanoꞌe eꞌe raha ꞌadi agaḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Iesuꞌa ꞌouge reiroteꞌe enogano aneꞌa rahao soꞌabidiro, ebu soꞌareḡa hina taḡora haḡadu vaze eꞌe ubuma rana ase ḡuzuhiro. ");
INSERT INTO ksj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ebu aniꞌa niro, “Siloami duꞌura komeꞌa onamadu vuzuꞌoꞌi.” (Siloami hugaꞌe Tuḡuniro.) Ebu vaze eꞌeꞌa onamadu eꞌe vuḡano vuzuꞌirotene, ubumaḡaniꞌa raꞌanadu bare ariro. ");
INSERT INTO ksj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ꞌOugadu ane nabudi zu aneꞌa umididoteꞌe ibite horoniroteꞌe azaḡaniꞌa ḡadimutitiro, “Vaze ꞌadiꞌe ehoradu umide banidoteꞌe vazeḡa, oꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Vaze nuꞌe raenaꞌa, “Oꞌe, aniꞌe vaze eꞌe,” u nuꞌe raenaꞌa, “Mene, ꞌadiꞌe ani heuḡa,” rae reiro. Rehano ani aneꞌa bare ꞌahige rae reiro, “Oꞌe, vaze aꞌe eḡe.” ");
INSERT INTO ksj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Zeḡeꞌa ḡadiniro, “Ubumaḡo nougenouge raꞌaneha?” ");
INSERT INTO ksj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Aniꞌa naenaeziro, “Iesu rae huneꞌeteꞌe vazeḡaniꞌa taḡora haḡadu ubumahe rana ase ḡuzuheha. Ebu aniꞌa, 'Siloami duꞌura komeꞌa onamadu vuzuꞌoꞌi,' rae eheha. Eꞌanoꞌo e onamadu eꞌea vuzuꞌeha ebu ehamanogaꞌe idaraneha.” ");
INSERT INTO ksj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Zeḡeꞌa ḡadiniro, “Vaze aꞌe noumao?” Aneꞌa ziro, “E aḡuꞌa.” ");
INSERT INTO ksj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ebu ze ibite ubuma kuruḡa reiroteꞌe vazeḡa zamahanadu Farisea azaḡa vaḡe onamiro. ");
INSERT INTO ksj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Iesuꞌa taḡora haḡadu vaze eꞌe ubuma fainiroteꞌe madaḡaꞌe Bana Madaḡa. ");
INSERT INTO ksj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Eꞌanoꞌo Farisea azaḡaniꞌa zu ḡadiniro, “Ḡa nougenouge ehamanogaꞌe idaraneha?” Aniꞌa naenaeziro, “Aneꞌa taḡora haḡadu ubumahe rana ase ḡuzuheha. Ebu e vuzuꞌadu izidi ehamuꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ebu Farisea azaḡa nuꞌa reiro, “Vaze aꞌe mene Badiꞌa mazaonoꞌo ariroteꞌe vazeḡa, mazaḡa ani Bana Madaḡa goro ḡoeꞌa mene hegoteꞌohe.” U nuꞌe reiro, “Aniꞌe haḡai sauꞌa vazeḡa reine, haḡai nu badeḡa ꞌahiguḡa haḡaogaꞌe mene idaḡa.” ꞌOugadu ze zeḡeꞌa bare rovotiro. ");
INSERT INTO ksj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Eꞌanoꞌo ze ubuma kuruḡa reiroteꞌe vazeḡa bare ḡadiniro, “Ani ubumaḡo faineha. Ḡaꞌe ani iniu rae zamareꞌohe?” Aniꞌa naenaeziro, “Aniꞌe peroveta vazeḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Iuda azaḡa boroboroꞌa ani ibite ubuma kuruḡa reiroteꞌe zu izidi ehamanoga idararoteꞌe mene mae ḡihiniro. Eꞌanoꞌo ze ani viꞌa moga huze zouziro. ");
INSERT INTO ksj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ebu zeḡeꞌa ḡadiziro, “ꞌAhiꞌe zae ubudehe? Aniꞌe hube ubumaḡa kuruḡano furerarohe? Ani nougadu izidiꞌe hena ehamuꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Viꞌa moganiꞌa naenaeziro, “Oꞌe, aniꞌe emeḡe ubude, ebu ani ubuma kuruḡano furerarotaꞌaꞌe emeꞌe edeḡa. ");
INSERT INTO ksj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Rehano eme aḡuꞌa, ani nougenouge izidi ehamuꞌohe zu iniuꞌa ubumaḡa faineha. Nugo ḡadinoꞌi. Ani vaze boro ꞌahine, aneꞌa bare ḡoeriꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ani viꞌa moganiꞌa Iuda azaḡa boroboro rihoziroteꞌe uꞌano, ꞌouge reiro. Mazaḡa zeḡeꞌa raenaꞌa, “Iniuꞌa Iesuꞌe Keriso rae reine, ani nu'onu'o neḡanonoꞌo mae vaḡiniꞌuma,” rae ziro. ");
INSERT INTO ksj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Eꞌanoꞌo viꞌa moganiꞌa, “Aniꞌe vaze boro, eꞌanoꞌo ani ḡadinoꞌi,” rae reiro. ");
INSERT INTO ksj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mada aheuḡano ze ibite ubuma kuruḡa reiroteꞌe vazeḡa hunadu niro, “Badiꞌa ubumao huga ḡoeroꞌi. Emeꞌe edeḡa, Iesuꞌe haḡai sauꞌa vazeḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Aneꞌa naenaeziro, “E aḡuꞌa, aniꞌe haḡai sauꞌa vazeḡa ga mene, rehano e ḡau tibaꞌe edeḡa. Ibite e ubuma kuruḡa vazeḡa, rehano izidi ehamuꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Zeḡeꞌa ḡadiniro, “Ani ḡa mazao nagini haḡaeha? Nougenouge faiꞌadu ubumaḡo raꞌaneha?” ");
INSERT INTO ksj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Aniꞌa naenaeziro, “E amahi zeha, rehano za mene egeha. Nougadu eḡe ḡoere bare igihi raꞌohe? Zae zuni ane tahiꞌatahiꞌa reihi raꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ꞌOugadu ze ani rae sausauniro ebu niro, “Ḡaꞌe ane tahiꞌa, u emeꞌe Mose tahiꞌatahiꞌa! ");
INSERT INTO ksj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Eme Badiꞌaꞌa Mose ḡorenirotaꞌaꞌe edeḡa, rehano eme vaze aꞌe noumanoꞌo arirotaꞌaꞌe aḡuꞌa.” ");
INSERT INTO ksj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Vaze eꞌeꞌa naenaeziro, “E zaguzagauꞌohe! Aniꞌa ubumahe manoneha, rehano za ani noumanoꞌo arirotaꞌaꞌe aḡuꞌa! ");
INSERT INTO ksj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Emeꞌe edeḡa, Badiꞌaꞌe haḡai sauꞌa azaḡa ḡoereꞌe mene igiꞌohe, rehano iniu ane mazao kurauꞌeteꞌe zu ane urao haḡaeꞌeteꞌe vazeḡa ḡoereꞌe igiꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Badiꞌaꞌa raha ꞌadi haḡairoteꞌe madaḡanonoꞌo onao izidi, ubuma kuruḡano fureraroteꞌe vazeḡa fainiroteꞌe hariḡa vazeni ꞌahoga mene igiro. ");
INSERT INTO ksj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Vaze ꞌadiꞌe mene Badiꞌa mazaonoꞌo reifone, ani ḡau ꞌahoga haḡaoga mene idaḡa reifo.” ");
INSERT INTO ksj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Zeḡeꞌa naenaeniro, “Ḡaꞌe fureraroteꞌe madaḡanonoꞌo haḡai sauꞌaniꞌa iriꞌaveꞌohe. Ḡaeꞌa eme ihofihi raꞌehe?” Ebu ze ani hegone buniro. ");
INSERT INTO ksj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iesuꞌa ze ubuma kuruḡa vazeḡa eꞌe hegone buniroteꞌe igiro. Eꞌanoꞌo ani vaḡadu hidirotene ḡadiniro, “Ḡa Vaze Ubuga mazao fieꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Vaze eꞌeꞌa naenaeniro, “Vaze boro, aniꞌe iniu? Ḡa ihine, e ani mazao fiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Iesuꞌa niro, “Ḡaꞌa ani horoneha zu ani izidi ḡae teite ḡoereꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Vaze eꞌeꞌa niro, “Zuhiꞌa Boro, e ḡae mazao fieꞌohe!” Ebu aneꞌa ḡuḡuradu ani mazao kuraro. ");
INSERT INTO ksj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Iesuꞌa niro, “Eḡeꞌa kotazoga veize raha ꞌadi ariro. Aꞌe ubuma kuruḡa azaḡaniꞌa ehamanoga veize, zu ehamuꞌeteꞌe azaḡa ubumaꞌa kuranoga veize raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ebu Iesu teite radiroteꞌe Farisea azaḡa nuꞌe ani ḡoere egadu niro, “Emeꞌe mene ubuma kuruḡa azaḡa!” ");
INSERT INTO ksj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iesuꞌa ziro, “Za hube hune ubuma kuruḡa azaḡa reifone, Badiꞌaꞌa haḡaize sauꞌa rae modifo. Rehano zaꞌe ehamuꞌohe rae raꞌeteꞌe uꞌano, haḡaize sauꞌaꞌe mene rae modeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Iesuꞌa reiro, “Eḡeꞌa hube hune ziꞌohe, iniu ḡabiri ibihetaḡanonoꞌo mamoe habaꞌa mene diuḡadu ibi ꞌahogano sibire diuḡeꞌeteꞌe vazeḡaꞌe ḡonore vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","U ḡabiri ibihetaḡanonoꞌo diuḡeꞌeteꞌe vazeḡaꞌe mamoe taufeꞌeteꞌe vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ḡabiri ibihetaḡa taufeꞌeteꞌe vazeḡaniꞌa ani veize ibiheta vavaꞌohauꞌohe zu mamoeḡaꞌe ane ago igiꞌohe. Ebu aniꞌa mamoeḡa nizeo huzadu ibitozi buzeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Huze buzatene aneꞌa ibitadu zeḡe niduꞌa ani hegoteꞌohe, mazaḡa ze ani agoꞌe edeḡa. ");
INSERT INTO ksj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Zeꞌe aḡuꞌa vazeḡa ḡaruna mene hegotiꞌuma zu ani mazaonoꞌo feraꞌuma, mazaḡa zeꞌe aḡuꞌa vazeḡa agoꞌe aḡuꞌa.” ");
INSERT INTO ksj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesuꞌa ḡoere ꞌouge rae idane ziro, rehano ze aniꞌa ziroteꞌe ḡoeꞌa huga mene ederiro. ");
INSERT INTO ksj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Eꞌanoꞌo Iesuꞌa bare ziro, “Eḡeꞌa hube hune ziꞌohe, e mamoe ḡabiri ibihetaḡa. ");
INSERT INTO ksj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Eḡe zamao ibite ariroteꞌe azaḡaꞌe ḡonore azaḡa. Rehano mamoeꞌe zeḡe ḡoere mene egoziniro. ");
INSERT INTO ksj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Eꞌe ibiheta. Iniuꞌa eḡe mazaonoꞌo diuḡine, aniꞌe ḡabone hidiꞌuma. Ebu aniꞌe buau diuḡiꞌuma zu ogomu manoḡa hidiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ḡonore vazeḡaꞌe ḡonotafine zu zimifine ebu ruizifine areꞌohe. U eꞌe mamoe niduꞌa ḡabone hidadu zeḡe ḡabone niduꞌa zamaḡano manoḡaniꞌa iriꞌavoga veize ariro. ");
INSERT INTO ksj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Eꞌe mamoe taufeꞌeteꞌe vazeḡa manoḡa. Mamoe taufeꞌeteꞌe vazeḡa manoḡaꞌe mamoeḡa uꞌano ḡaboneḡa aheteꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","U hadi vaḡeꞌenaꞌa, gaueꞌeteꞌe vazeḡaꞌe mamoe mene taufeꞌeteꞌe vazeḡa. Mamoeꞌe mene ani mamoe. Eꞌanoꞌo ani butu ḡuniḡaniꞌa aroga horoneꞌetene, mamoe niduꞌa mode ferauꞌohe. Ebu butu ḡuniḡaniꞌa mamoe agatozenadu niduꞌa avoavo oname ḡoureꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Aniꞌe hadi vaḡe gaueꞌeteꞌe vazeḡa radu mamoe mene faine taufeꞌe ꞌahine, ferauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Eꞌe mamoe taufeꞌeteꞌe vazeḡa manoḡa. Eꞌe mamoehe edeḡa zu zeꞌe e edeḡa. ");
INSERT INTO ksj_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Aꞌe Mamaꞌa e edeḡa zu eꞌe Mama edeḡa heuḡa. E ḡabonehe mamoe veize aheteꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mamoe ꞌahoga nuꞌe eḡe mazao, rehano zeꞌe ḡabiri ꞌahi zamaḡanoꞌe oꞌoꞌa. Zeḡe zuni eḡeꞌa zamaze ariꞌuma. Ze eḡe ḡoere igiꞌuma, ebu zeḡe niduꞌa tiburu radiꞌuma, zu vaze tibaniꞌa zeḡe taufiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Mamaheꞌe eḡe zamare borofeꞌohe, mazaḡa e ḡabonehe bare meifine ḡabonehe aheteꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Vaze ꞌahoganiꞌa eḡe ḡabone mene mae vaḡineꞌohe, rehano e eḡeꞌa bare ḡabonehe aheteꞌohe. E ḡabonehe aheteꞌeteꞌe zu bare maꞌeteꞌe gigiꞌaḡa meiro. Aꞌe Badiꞌaꞌa eḡe mazao, 'Haḡae hunoꞌi,' rae reiroteꞌe ḡoeꞌa.” ");
INSERT INTO ksj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Iesuꞌa ꞌouge reiroteꞌe uꞌano, Iuda azaḡaniꞌa zeḡe boꞌaḡano bare rovotiro. ");
INSERT INTO ksj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Zeḡe boꞌaḡano vaze ḡehaḡaniꞌa ꞌahige rae reiro, “Ani vine sauꞌaniꞌa ragano radu zamaroneḡaꞌe oꞌoꞌa. Za nougadu ani ḡoere igiꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Rehano vaze nuꞌe ꞌahige rae reiro, “Ḡoere ꞌahiꞌe mene vine sauꞌaniꞌa ragano reiroteꞌe vazeḡa ḡoeꞌa. Vine sauꞌaniꞌa ubuma kuruḡa vazeḡa fainogaꞌe mene idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ierusalemao Kuru Neḡa Giginiroteꞌe Muiḡa meiro, zu eꞌe madaḡaꞌe nahune madaḡa. ");
INSERT INTO ksj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ebu Iesuꞌa kuru neḡa habaꞌano Solomona Ibi Zauhaḡano ragavinu. ");
INSERT INTO ksj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ebu Iuda azaḡa boroboroꞌa gabaḡeḡenadu ḡadiniro, “Ḡa naniꞌa ḡoere huga ifiꞌuma? Zamafeꞌe ufeta doudeꞌohe. Ḡa Keriso roꞌidene, ḡoere rae dehenofoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ebu Iesuꞌa naenaeziro, “E ziro, rehano za eḡe ḡoereꞌe mene mae ḡihineꞌohe. E eḡe Mama niḡano haḡaeꞌeteꞌe haḡaiḡa gigiꞌaꞌa eḡe moneo rae fureneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Rehano za eḡe mene mamoe ꞌahine, eḡe mazao mene fieꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Eḡe mamoeꞌe agohe igiꞌohe. E ze edeḡa ebu ze e hegoteꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Eḡeꞌa ḡabone tuḡutuḡu zeḡe ziniꞌohe. Ze mene hune ruiziꞌuma ebu vaze ꞌahoganiꞌa eḡe ꞌevoreonoꞌo mene meiziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mamaheꞌa ze eḡe iniro. Aniꞌe ḡau niduꞌa ufeta vitine ḡihiꞌaḡa. Vazeni ꞌahoganiꞌa ze Mamahe ꞌevore mazaonoꞌo meizoga mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Eꞌe Mama teite tiba.” ");
INSERT INTO ksj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ebu Iuda azaḡa boroboroꞌa bare hadi mae ḡihinadu matihi reiro. ");
INSERT INTO ksj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Rehano Iesuꞌa ziro, “E Mama gigiꞌaḡa hina haḡai manoḡa ḡehaḡa haḡadu ihoziro. Haḡai manoḡa eꞌe boꞌaḡano noꞌe haḡaiḡa uꞌano, za uḡuhe ruhihi raꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Zeḡeꞌa naenaeniro, “Eme hadi hina ḡamihi raꞌetaꞌaꞌe mazaḡa mene ḡaeꞌa haḡai manoḡa haḡairo, rehano mazaḡa ḡa Badiꞌa rae sausauneꞌohe. Ḡaꞌe vaze tauḡi, rehano ḡa ḡaeꞌa bare Badiꞌa rae raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iesuꞌa naenaeziro, “Zae Buka Zaḡoḡano ꞌahige rae mirihiro, 'Badiꞌaꞌa raenaꞌa, “Zaꞌe badiꞌa.”' ");
INSERT INTO ksj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Badiꞌaꞌe ane ḡoere ziniroteꞌe azaḡa mazao, 'badiꞌa,' rae huziro. Ebu Buka Zaḡoḡaꞌe varadoga mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Eꞌe Mamaꞌa mae zaḡozaḡohadu raha ꞌahao tuḡuhiroteꞌe vazeḡa. E eḡeꞌa bare Badiꞌa Ubuga rae raꞌeteꞌe uꞌano, za eꞌa Badiꞌa rae sausauneꞌohe rae raꞌehe? ");
INSERT INTO ksj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","E Mamahe gau mene haḡaoꞌidene, za eḡe mazao ago fioꞌi. ");
INSERT INTO ksj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","U e Mamahe gau haḡaoꞌidene, za eḡe ḡoere mene mae ḡihineꞌe rehano, eḡeꞌa haḡaeꞌeteꞌe haḡaiḡa mae ḡihinoꞌi. ꞌOugine, Mamaꞌe eḡe teite zu eꞌe ane teite radiuꞌetaꞌaꞌe ederiꞌuma zu zamariꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ꞌOugadu ze ani bare obone nuriro, rehano ani zeḡe ꞌevoreonoꞌo feraro. ");
INSERT INTO ksj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ebu Iesuꞌa Ioridana duꞌura bare fare onamiro. Aꞌe Ioaneꞌa ibite vaze babatisozinuteꞌe habaꞌa. Iesuꞌe eꞌea radiro. ");
INSERT INTO ksj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Vaze ḡehaḡaniꞌa ani vaḡe ariro ebu zeḡeꞌa bare ꞌahige rae reiro, “Ioaneꞌe haḡai nu badeḡa mene haḡairo, rehano aneꞌa vaze ꞌadi moneo reiroteꞌe ḡoeꞌa niduꞌaꞌe hube.” ");
INSERT INTO ksj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ebu eꞌea vaze ḡehaḡaniꞌa Iesu mazao firo. ");
INSERT INTO ksj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Vaze ꞌahoga, niḡa Lazaroꞌa radiunu. Ani uginiro ebu ezeḡa aheu, Maria zu Mareta teite Betania neḡano radiunu. ");
INSERT INTO ksj_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariaꞌe Zuhiꞌa Boro oda rana dehoro hohoḡa manoḡa beꞌunadu iguḡa hina odaḡa zauhiroteꞌe roḡaeḡa. Ani ezeḡa Lazaroꞌe uginiro. ");
INSERT INTO ksj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Eꞌanoꞌo ezeḡa aheuꞌa vaze ꞌahoga Iesu vaḡe tuḡunadu niro, “Zuhiꞌa Boro, ḡaeꞌa zamare borofeꞌeteꞌe vazeḡaꞌe ugiḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Iesuꞌa hari eꞌe egadu ꞌahige rae reiro, “Ugiḡa eꞌe uꞌano, ani mene rudaꞌuma, rehano Badiꞌa ni mae ḡihinoga veize ꞌahiguḡaniꞌa fureraro. Ugi eꞌe uꞌano, Badiꞌa Ubuga ni mae ḡihiniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesuꞌe Mareta, negoḡa Maria zu ezeḡa Lazaro zamare borofiro. ");
INSERT INTO ksj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Rehano ani Lazaroꞌa uginiroteꞌe hariḡa igirotene, ani aneꞌa radiuꞌeteꞌe habaꞌano mada aheu bare radiro. ");
INSERT INTO ksj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Eꞌe enogano Iesuꞌa ane tahiꞌatahiꞌa ziro, “Aroꞌi, Iudea habaꞌa bare onamihi.” ");
INSERT INTO ksj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Zeḡeꞌa niro, “Rabi, izidi Iuda azaḡa ibitoziꞌeteꞌe azaḡaniꞌa hadi hina ḡamihi raha. Rehano ḡa eꞌe habaꞌa bare onamihi raꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iesuꞌa naenaeziro, “Oꞌe. Mada tiba zamaḡano agaḡa madaḡa niduꞌaꞌe gaubanana aheu fare. Vazeꞌa agaḡa madaḡano ragavine mene uitiꞌuma, mazaḡa raha ꞌadi agazeꞌeteꞌe agaḡa horoneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","U ohore zamaḡano ragavine, ze uitiꞌuma, mazaḡa zeḡe mazao agaḡaꞌe oꞌoꞌa.” ");
INSERT INTO ksj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Aniꞌa ꞌouge reiroteꞌe enogano, bare ziro, “Emeḡe nabudi Lazaroꞌe bazeꞌohe. Rehano e ani vaḡe onamadu evaniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ane tahiꞌatahiꞌaꞌa naenaeniro, “Zuhiꞌa Boro, ani bazeꞌohe reine, ani manoriꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Iesuꞌa Lazaro rune moneo ḡoeriro, rehano ze Iesu ḡoere egadu, “Lazaroꞌe huga bazeꞌohe,” rae zamariro. ");
INSERT INTO ksj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Eꞌanoꞌo Iesuꞌa dehene ziro, “Lazaroꞌe rudaneha. ");
INSERT INTO ksj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","E ani teite mene radiroteꞌe uꞌano, matuꞌeꞌohe. Aꞌe zae veize raꞌohe, mazaḡa eꞌe uꞌano, za eḡe mazao fiꞌuma. Rehano izidi eme ani vaḡe onamihi.” ");
INSERT INTO ksj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ebu Atoa rae huneꞌeteꞌe vazeḡa, Tomasiꞌa Iesu tahiꞌa niduꞌa ziro, “Aroꞌi, emeḡe zuni ani teite rudafine onamihi.” ");
INSERT INTO ksj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Iesuꞌa Betania neḡano hanitirotene, Lazaroꞌe amahi idu zamaḡano mada ḡazaḡa radiroteꞌe igiro. ");
INSERT INTO ksj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania neḡaꞌe Ierusalema uhiḡano, zu faḡaꞌe uḡidu kilomita mene vitinoga. ");
INSERT INTO ksj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Eꞌanoꞌo Iuda azaḡa ḡehaḡaniꞌa Mareta zu Maria vaḡe ariro, mazaḡa ezeze rune uꞌano zamaze namizihi reiro. ");
INSERT INTO ksj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Maretaꞌe Iesuꞌa areꞌeteꞌe igirotene, Iesu hidoga radu onamiro, u Mariaꞌe neo radiro. ");
INSERT INTO ksj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ebu Maretaꞌa Iesu hidadu niro, “Zuhiꞌa Boro, ḡa ꞌaha reifone, ezeheꞌe mene rudafo. ");
INSERT INTO ksj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Rehano e edeḡa, izidi zuni ḡa Badiꞌa mazao nagini umidine aneꞌa ḡaniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Iesuꞌa niro, “Ezeḡoꞌe bare ḡabodiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maretaꞌa niro, “E edeḡa, mada ḡonagano vaze niduꞌa runeonoꞌo bare iḡuneꞌeteꞌe madaḡano aniꞌe bare ḡabodiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iesuꞌa niro, “Eꞌe rune azaḡa bare ḡabozeꞌohe, zu ḡabone ziniꞌohe. Iniu eḡe mazao fieꞌeteꞌe vazeḡaꞌe rudaune zuni, bare ḡabodiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ebu iniu ḡabodeꞌeteꞌe zu eḡe mazao fieꞌeteꞌe vazeḡaꞌe mene hune rudaꞌuma. Ḡa ḡoere ꞌahi mae ḡihineꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Aneꞌa niro, “Oꞌe, Zuhiꞌa Boro, e ḡaꞌe Keriso ebu raha ꞌada ariꞌuma rae reiroteꞌe vazeḡa, Badiꞌa Ubuga rae mae ḡihineꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Maretaꞌe ꞌouge reiroteꞌe enogano bare ne onamadu negoḡa Maria genaḡa zamahu onamiro ebu niro, “Ihore vazeḡaꞌe emeḡe haba haniteha. Aniꞌe ḡa ḡiaꞌihi raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariaꞌa ani ḡoere igirotene, ḡarihe iḡunadu Iesu vaḡe onamiro. ");
INSERT INTO ksj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Iesuꞌe ꞌize zeḡe ne mene diuḡadu Maretaꞌa ani hidiroteꞌe habaꞌano radiunu. ");
INSERT INTO ksj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ne zamaḡano Maria namine radiuꞌeteꞌe Iuda azaḡaꞌe aneꞌa ḡarihe iḡunadu bua onamoga horoniro. Ebu zeḡe zuni ani hegote buaro, mazaḡa ze aniꞌa nianoga veize Lazaro idu onameꞌohe rae zamariro. ");
INSERT INTO ksj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariaꞌe Iesuꞌa radiuꞌeteꞌe habaꞌano feuradu ani horoniro. Ebu Iesu oda babaḡano ḡuḡuradu niro, “Zuhiꞌa Boro, ḡaꞌe ꞌaha reifone, eḡe ezeꞌe mene rudafo.” ");
INSERT INTO ksj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Iesuꞌa Maria zu ane teite ariroteꞌe Iuda azaḡaniꞌa niauꞌeteꞌe horonirotene, zamaḡa ariro zu adudaro. ");
INSERT INTO ksj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ebu Iesuꞌa ḡadiziro, “Za Lazaro ahiꞌa nouma tiro?” Ze naenaeniro, “Zuhiꞌa Boro, aradu ḡianoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Hena Iesuꞌa niaro. ");
INSERT INTO ksj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ꞌOugadu Iuda azaḡaniꞌa ꞌahige rae reiro, “Ḡianoꞌi, ani Lazaro ufeta zamare borofiro!” ");
INSERT INTO ksj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Rehano zeḡe boꞌaḡano nuꞌe ꞌahige reiro, “Aniꞌe ubuma kuruḡa vazeḡa ubuma raꞌaniro. Rehano Lazaroꞌa mene rudafine ḡau ꞌahoga haḡaogaꞌe mene idararohe?” ");
INSERT INTO ksj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Iesu zamaꞌe bare borofe areꞌenaꞌa, Lazaro idu onamiro. Iduḡaꞌe hoꞌoga boro zu ibihetaꞌe hadi boro ꞌahoga hina ꞌuiro. ");
INSERT INTO ksj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ebu Iesuꞌa ziro, “Hadi ꞌahi mae vaḡinoꞌi.” ꞌOugirotene rune vazeḡa ezeḡa, Maretaꞌa niro, “Zuhiꞌa Boro, ani ahiriꞌe mada ḡazaḡa idu zamaḡano radeha, eꞌanoꞌo aniꞌe ufeta ḡezoḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Iesuꞌa niro, “E ꞌahige ḡaha, 'Ḡa eḡe mazao fine, Badiꞌaꞌe ḡihiꞌa hune rae ederiꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ꞌOugadu ze hadi mae vaḡiniro. Ebu Iesuꞌa adure ḡohani ḡianadu reiro, “Mama, e ḡae mazao manoḡa tauḡi raꞌohe, mazaḡa ḡaeꞌa eḡe ḡoere abitoneha. ");
INSERT INTO ksj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","E edeḡa, ḡa iḡaiḡa eḡe ḡoere abitoniꞌohe. Rehano ꞌada edauꞌeteꞌe azaḡa veize e ꞌahige raꞌohe. Ze ḡaꞌa e tuḡuhirotaꞌaꞌe mae ḡihinoga urateꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Aneꞌa ꞌouge reiroteꞌe enogano ḡihau huaro, “Lazaro, bua aroꞌi!” ");
INSERT INTO ksj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ebu rune vazeḡa ꞌai bua ariro! ꞌEvoꞌa zu odaḡa ꞌumiroteꞌe dabuaḡa kuiḡa ebu iraḡa ꞌumiroteꞌe dabuaḡaꞌe ꞌize ahiꞌano buaro. Iesuꞌa ziro, “Ani ragavifine dabuaḡa mae vaḡinoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ebu Maria vaḡe onamiroteꞌe Iuda azaḡa ḡehaḡaniꞌa Iesuꞌa nagini haḡairoteꞌe horonadu ani mazao firo. ");
INSERT INTO ksj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Rehano zeḡe boꞌaḡano nuꞌe Farisea azaḡa vaḡe onamadu Iesuꞌa nagini haḡairoteꞌe meꞌodoziniro. ");
INSERT INTO ksj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ꞌOugadu dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu Farisea azaḡaniꞌa Iuda azaḡa boroboro huzadu nu'onu'o boro meiro, ebu ze zeḡeꞌa bare ḡadimutitiro, “Eme nougiꞌuma? Vaze ꞌadi haḡai nu badeḡa ḡehaḡa haḡaeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Eme aniꞌa ꞌahige haḡaoga ḡiane modine, vaze niduꞌa ani mazao fiꞌuma. Ebu Roma azaḡaniꞌa aradu emeḡe haba zu emeḡe haba azaḡa ruiziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ebu zeḡe boꞌaḡano vaze ꞌahoga, niḡa Kaiafaꞌe eꞌe muriḡano dibuꞌo vazeḡa ḡihiꞌaḡa reiro. Aneꞌa ziro, “Zaꞌe ḡauni ꞌahoga zuni mene edereꞌohe! ");
INSERT INTO ksj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Vaze niduꞌa veize vaze tibaniꞌa rudanogaꞌe ufeta manoḡa, ebu Roma azaḡaniꞌa Iuda azaḡa niduꞌa ruizogaꞌe ufeta sauꞌa. Za aꞌe mene zamareꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ani ane zamaroneonoꞌo mene ꞌouge reiro. Aniꞌe eꞌe muriḡano dibuꞌo vazeḡa ḡihiꞌaḡa uꞌano, Badiꞌaꞌa ihonadu Iesuꞌe Iuda azaḡa niduꞌa veize rudatiteꞌe aneꞌa rae fureniro. ");
INSERT INTO ksj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Aꞌe mene Iuda azaḡa veize daꞌo, rehano haba nunu avoavo radiuꞌeteꞌe Badiꞌa ubugaubuga nuꞌozadu tiburanoga veize rae fureniro. ");
INSERT INTO ksj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Eꞌanoꞌo eꞌe madaḡanonoꞌo ze Iesu manoga ibiḡa ḡoꞌaniro. ");
INSERT INTO ksj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Eꞌe uꞌano, Iesuꞌe Iuda azaḡa boꞌaḡano hunioꞌe mene ragavinu. Aniꞌe eꞌe habaꞌa modadu haba bohaꞌa uhiḡano ne ꞌahoga, Efaraima onamiro ebu ane tahiꞌatahiꞌa teite deꞌea radiro. ");
INSERT INTO ksj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ebu Iuda azaḡa Iḡine Modiroteꞌe Muiḡaniꞌa hanitirotene, vaze ḡehaḡaniꞌa neḡaneḡanonoꞌo Iḡine Modiroteꞌe Muiḡa ꞌizema mougano Ierusalema itiro. Mazaḡa ze ibite itadu Iuda azaḡa goro idunaḡano Badiꞌa ubumao ze zeḡeꞌa bare dehezihi reiro. ");
INSERT INTO ksj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ebu ze Iesu vaḡeꞌenaꞌa, kuru neḡa habaꞌano edanadu ḡadimutitiro, “Zaꞌe nouge rae zamareꞌohe? Aniꞌe Mui ꞌahi veize ariꞌuma ga mene?” ");
INSERT INTO ksj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Eꞌe madaḡano dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu Farisea azaḡaniꞌa Iesu obone tihi radu vaze niduꞌa riḡa ḡoreziro, “Iniuꞌa Iesuꞌe nouma radiuꞌetaꞌaꞌe ederoꞌidene, ihofoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Iḡine Modiroteꞌe Muiḡa veize mada fuꞌo tiba fare ꞌizema mougano, Iesuꞌa Betania neḡano feuriro. Aꞌe Iesuꞌa bare ḡaboniroteꞌe vazeḡa, Lazaroꞌa radiuꞌeteꞌe neḡa. ");
INSERT INTO ksj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Eꞌanoꞌo eꞌea Iesu veize ḡorava ogomuḡa ruhibiro. Maretaꞌa ogomu haḡairo ebu Lazaroꞌe Iesu teite ogomu fataḡa babaḡano tave ehoriroteꞌe azaḡa boꞌaḡano radiro. ");
INSERT INTO ksj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ebu Mariaꞌa dehoro huga hohoḡa naeḡa boro, niḡa Nado bio komeꞌa iriꞌavonadu mae ariro. Ebu dehoro hohoḡa eꞌe Iesu oda rana beuꞌiro, ebu iguḡa hina zauhiro. Eꞌanoꞌo ne zamaḡanoꞌe dehoro hohoḡaniꞌa iriꞌaviro. ");
INSERT INTO ksj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Rehano Iesu tahiꞌa ꞌahoga, vesuꞌu ani revohatiteꞌe tahiꞌaḡa ꞌahoga, Isakariota vazeḡa Iudaꞌa ꞌahige rae reiro, ");
INSERT INTO ksj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Dehoro hohoḡa ꞌadi seronadu muri tiba gau hadiḡa hidifo ebu eꞌe hadiḡaꞌe zahara azaḡa zinifo.” ");
INSERT INTO ksj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Aniꞌe mene zahara azaḡa zamariro, rehano aniꞌe ḡonore vazeḡa radu ꞌouge reiro. Aniꞌe zeḡe hadi fuseḡa taufeꞌeteꞌe vazeḡa radu fuse zamaḡano ufiroteꞌe hadiḡa ane veize ḡonotaudo. ");
INSERT INTO ksj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ebu Iesuꞌa ꞌahige rae reiro, “Roḡae ꞌahiꞌe ago gararoꞌi, mazaḡa aniꞌe e rudanadu guriteꞌe madaḡa veize dehoro ꞌadi ruhibeha. ");
INSERT INTO ksj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Zahara azaḡaꞌe iḡaiḡa zae teite radiꞌuma, u eꞌe iḡaiḡa zae teite mene radiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Iuda azaḡa ḡuḡuvaḡaniꞌa Iesuꞌa Betania neḡano radiuꞌeteꞌe igirotene, eꞌe neḡa onamiro. Aꞌe mene Iesu daꞌo ḡianoga veize, rehano aneꞌa rune azaḡa boꞌaḡano bare ḡaboniroteꞌe vazeḡa Lazaro zuni ḡianoga veize reiro. ");
INSERT INTO ksj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Eꞌanoꞌo dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡaꞌe Lazaro zuni matihi rae ḡoꞌaniro, ");
INSERT INTO ksj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","mazaḡa Lazaro uꞌano, Iuda azaḡa ḡehaḡaniꞌa ze modadu Iesu vaḡe onamiro ebu ani mazao firo. ");
INSERT INTO ksj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Irarirotene, Iḡine Modiroteꞌe Muiḡa veize Ierusalema itiroteꞌe vaze ḡuḡuvaḡaniꞌa Iesuꞌe Ierusalema aroga igiro. ");
INSERT INTO ksj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Eꞌanoꞌo ze Sigi rouga variꞌe madu ani hidoga veize onamiro. Ebu ze ḡihau huaro, “Hosana! Zuhiꞌa Boro niḡano areꞌeteꞌe vazeḡaꞌe ḡihiꞌa hune! Isaraela azaḡa kiniḡaꞌe ḡihiꞌa hune!” ");
INSERT INTO ksj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iesuꞌa doniki ubuga horonadu eꞌe rana tire ehoriro. Buka Zaḡoḡano ꞌahige rae mirihiro, ");
INSERT INTO ksj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ierusalema azaḡa, ago rihanoꞌi. Ḡianoꞌi, zae kiniꞌa doniki ubuga rana ehoradu areꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Eꞌe madaḡano Iesu tahiꞌatahiꞌaꞌe ꞌahiguḡa mene faine zamariro. Rehano Iesuꞌa runeonoꞌo bare ḡabodiroteꞌe enogano, Buka Zaḡoḡano ani moneo ꞌahiguḡa mirihiroteꞌe zu vazevazeꞌa ani mazao ꞌouge haḡairotaꞌaꞌe ederiro. ");
INSERT INTO ksj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ebu Iesuꞌa iduonoꞌo Lazaro hunadu rune azaḡa boꞌaḡano bare ḡaboniroteꞌe madaḡano, ani teite radiroteꞌe vaze ḡuḡuvaḡaniꞌa eꞌe hariḡa vaze mazao barebare rae fureniro. ");
INSERT INTO ksj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ebu vaze ḡehaḡaniꞌa Iesuꞌa haḡai nu badeḡa ꞌadi haḡairoteꞌe igiro ꞌahine, ze ani hidoga radu ane vaḡe onamiro. ");
INSERT INTO ksj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Eꞌanoꞌo Farisea azaḡaꞌe zeḡeꞌa bare neneḡaniro, “Ḡianoꞌi. ꞌAhiꞌe mene emeꞌa haḡaihi reiroteꞌe haḡaiḡa. Raha azaḡa niduꞌa ani hegote onamiro!” ");
INSERT INTO ksj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Iḡine Modiroteꞌe Muiḡano Badiꞌa mazao kuranoga veize Ierusalema onamiroteꞌe azaḡa boꞌaḡano Giriki azaḡa nuꞌa radiunu. ");
INSERT INTO ksj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Giriki azaḡa eꞌeꞌa Galilea habaꞌa Betesaida vazeḡa Filipi vaḡe onamadu uminiro, “Vaze boro, emeꞌe Iesu ḡianihi raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ebu Filipiꞌa onamadu Anderea niro, ebu anianine Iesu vaḡe onamadu ḡadiniro. ");
INSERT INTO ksj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ebu Iesuꞌa naenaeziro, “Badiꞌaꞌa Vaze Ubugaꞌe ḡihiꞌa hune rae ihoziteꞌe madaḡaꞌe maha. ");
INSERT INTO ksj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Eḡeꞌa hube hune ziꞌohe. Vuidi maḡa rahao mene gurine, aniꞌe maḡa isoḡa radiꞌuma. Rehano ani rahao gurine, ḡehaḡaniꞌa hudaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Iniuꞌa ane ḡabone zamare borofine, ḡabone tuḡutuḡu mene hidiꞌuma. Rehano iniuꞌa raha ꞌada ane ḡabone heꞌeheꞌenine, ḡabode radiꞌuma onamo radiu tuḡutuḡu. ");
INSERT INTO ksj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Iniuꞌa eḡe tuḡure vazeḡa reihi roꞌidene, eḡe hegotoꞌi. Eꞌe noꞌe habaꞌano radiune, eḡe tuḡure vazeḡa zuni eꞌea radiꞌuma. Eḡe tuḡure vazeḡaꞌe eḡe Mamaꞌa niguniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Izidi eḡe zamaꞌe aduduꞌohe. E nagini reꞌuma? 'Mama, aduga madaḡa ꞌahaonoꞌo e ḡabohoꞌi,' rae reꞌuma ga? Mene, e aduga madaḡa ꞌahi mouga veize ariro. ");
INSERT INTO ksj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mama, ḡae ni mae ḡihinoꞌi!” ꞌOugadu ago ꞌahoganiꞌa adureonoꞌo ꞌahige rae reiro, “Eḡeꞌa nihe mae ḡihineha zu bare mae ḡihiniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Vaze ḡuḡuvaḡa eꞌea ḡoere eꞌe egadu, “Viriꞌa fuꞌureꞌohe,” rae reiro. Ebu nuꞌe, “Tuḡure viganiꞌa ani mazao ḡoereha,” rae reiro. ");
INSERT INTO ksj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Iesuꞌa naenaeziro, “Ago aꞌe mene eḡe veize, rehano zae veize ḡoereha. ");
INSERT INTO ksj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Izidiꞌe Badiꞌaꞌa raha ꞌadi azaḡa kotazeꞌeteꞌe madaḡa. Izidiꞌe raha ꞌadi zuhiꞌaziꞌeteꞌe vazeḡa, Satani mae vaḡiniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Rehano vazeꞌa rahaonoꞌo eḡe mae ḡihihine, eḡeꞌa vaze niduꞌa eḡe vaḡe hutube ariꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iesuꞌe aneꞌa nougenouge rudatiteꞌe moneo ihozifine ꞌouge rae reiro. ");
INSERT INTO ksj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ebu vaze ḡuḡuvaḡaniꞌa niro, “Buka Zaḡoḡanonoꞌo eme ꞌahige edereꞌohe, 'Kerisoꞌe radiu tuḡutuḡu.' Rehano ḡaꞌe nougadu, 'Vaze Ubugaꞌe rahaonoꞌo mae ḡihiniꞌuma,' rae raꞌohe? Vaze Ubugaꞌe iniu?” ");
INSERT INTO ksj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Iesuꞌa naenaeziro, “Agaḡaꞌe mada tahiḡa bare zae teite radiꞌuma. Agaḡaꞌe zae teite radiuꞌeteꞌe zamaḡano oname onaoꞌi, ꞌougine zaꞌe uzaboꞌa mene ḡahiziꞌuma. Uzabo zamaḡano ragaveꞌeteꞌe vazeḡaꞌe ani noꞌe onameꞌetaꞌaꞌe aḡuꞌa. ");
INSERT INTO ksj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Agaḡaꞌe zae teite radiuꞌeteꞌe zamaḡano agaḡa mazao fioꞌi, ꞌougine za agaḡa ubuga reꞌuma.” Iesuꞌa ꞌouge ziroteꞌe enogano, muhize onamadu zeḡe mazaonoꞌo uꞌuraro. ");
INSERT INTO ksj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Iesuꞌa haḡai nu badeḡa ḡehaḡa vaze zamao haḡairo, rehano ze ꞌize ani mazao mene firo. ");
INSERT INTO ksj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Peroveta vazeḡa Isaiaꞌa reiroteꞌe ḡoeꞌaniꞌa hudaro, “Zuhiꞌa Boro, emeḡeꞌa haramiroteꞌe ḡoeꞌaꞌe vazeꞌa mene mae ḡihiniro. Ḡaeꞌa gigiꞌaḡo ze ihoziro, rehano ze mene mae ḡihiniro.” ");
INSERT INTO ksj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nougadu ze Iesu mazao fioga mene idararoteꞌe moneo Isaiaꞌa ꞌahige bare rae reiro, ");
INSERT INTO ksj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Badiꞌaꞌa ubumaze kuruniro zu zeḡe zama ꞌuiro. Eꞌe uꞌano, ze ubumaze hina horoneꞌe rehano, hugaꞌe mene horoniꞌuma, zu zamaze hina mene faine zamariꞌuma. Aꞌe, ze eḡe vaḡe ḡihure baradu mene manoroga veize raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiaꞌa ꞌahige rae reirotaꞌaꞌe mazaḡa ani Iesuꞌe ḡihiꞌa hune rae ederiro zu ani moneo ḡoeriro. ");
INSERT INTO ksj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","U vaze ibitoziꞌeteꞌe azaḡa boꞌaḡano vaze ḡehaḡaniꞌa Iesu mazao firo. Rehano ze ani mazao fieꞌetaꞌaꞌe vaze ꞌahoga mene niro, mazaḡa Farisea azaḡaniꞌa nu'onu'o neḡanonoꞌo ze mae buziꞌuma radu riharo. ");
INSERT INTO ksj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ze vazeꞌa ze niguzeꞌetaꞌaꞌe ufeta zamariro, rehano Badiꞌaꞌa ze niguzeꞌetaꞌaꞌe mene zamariro. ");
INSERT INTO ksj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ebu Iesuꞌa agoḡa boro hina ḡihau ḡoeriro, “Iniu eḡe mazao fieꞌeteꞌe vazeḡaꞌe eḡe mazao daꞌo mene fieꞌohe, rehano eḡe tuḡuhiroteꞌe vazeḡa mazao fieꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ebu iniu eḡe ḡiaheꞌeteꞌe vazeḡaꞌe eḡe tuḡuhiroteꞌe vazeḡa ḡianeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Agaḡa teige, e raha ꞌahi ariro. Aꞌe eḡe mazao fieꞌeteꞌe azaḡa niduꞌaꞌe uzabo zamaḡano mene radoga veize raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Iniu eḡe ḡoere egadu mene hegotine zuni, e ani mene kotaniꞌuma. Mazaḡa eꞌe raha azaḡa kotazoga veize mene ariro, rehano ḡabozoga veize ariro. ");
INSERT INTO ksj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Eḡe hezahohiꞌeteꞌe zu eḡe ḡoere mene mae ḡihineꞌeteꞌe vazeḡa kotaneꞌeteꞌe vazeḡaꞌe ꞌahoga. Mada ḡonagano eḡeꞌa rateꞌe ḡoeꞌa ꞌadi hina ani kotaniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","E eḡe edeḡano mene ḡoeriro, rehano eḡe tuḡuhiroteꞌe Mamaheꞌa e nagini rouga zu nouge rae rouga ihohiro. ");
INSERT INTO ksj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","E edeḡa, ani goro ḡoeꞌaniꞌa ḡabone tuḡutuḡu ibiḡano ibitoziꞌohe. Eꞌanoꞌo e Mamaꞌa nagini ihiroteꞌe ḡoeꞌa daꞌo raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Iḡine Modiroteꞌe Muiḡa ꞌizema mougano, Iesuꞌe aneꞌa raha ꞌadi modadu Mama vaḡe ititeꞌe madaḡa meirotaꞌaꞌe ederiro. Ebu aneꞌa raha ꞌada ane hegoteꞌeteꞌe azaḡa zamare borofiro, onamo ani rudatiteꞌe madaḡa meiro. ");
INSERT INTO ksj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ḡoravaḡano ze ogomu tiburu aunu. Diaboloꞌa Isakariota vazeḡa Simona ubuga, Iuda zamaḡa amahi tutunadu Iesu revohatihi reiro. ");
INSERT INTO ksj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iesuꞌe ederiro, Moganiꞌa ḡau niduꞌa ani ꞌevora tiro ebu aneꞌa Badiꞌa mazaonoꞌo aradu bare Badiꞌa vaḡe itiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Eꞌanoꞌo ani ogauꞌeteꞌe habaꞌanonoꞌo iḡunadu raga dabuaḡa mae vaḡine tiro, ebu ahiri zauheꞌeteꞌe dabuaḡa madu gabaꞌiḡano autiro. ");
INSERT INTO ksj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ebu siuva duꞌuḡano vu beuꞌadu ane tahiꞌatahiꞌa oda vuzuꞌiro, zu autiroteꞌe dabuaḡa hina zauhiro. ");
INSERT INTO ksj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Iesuꞌa Simona Petero vaḡirotene, Peteroꞌa niro, “Zuhiꞌa Boro, ḡa eḡe oda vuzuꞌihi raꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iesuꞌa naenaeniro, “Eḡeꞌa nagini haḡaeꞌetaꞌaꞌe ḡa izidiꞌe aḡuꞌa, rehano vesuꞌu ederiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peteroꞌa ꞌahige rae reiro, “Ḡa eḡe odaꞌe mene hune vuzuꞌiꞌuma!” Iesuꞌa naenaeniro, “Eḡeꞌa ḡae oda mene vuzuꞌine, ḡaꞌe eḡe mene tahiꞌa reꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simona Peteroꞌa niro, “Zuhiꞌa Boro, eḡe oda daꞌo mene, rehano ꞌevorehe ebu vadinihe zuni vuzuꞌoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iesuꞌa naenaeniro, “Viriroteꞌe vazeḡaꞌe odaḡa daꞌo vuzuꞌeꞌohe. Ani ahiꞌaꞌe niduꞌa deheḡa. Ebu zaꞌe deheḡa, rehano zae niduꞌa boꞌaḡano tibaꞌe mene deheḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iesuꞌe iniuꞌa ani revohatiteꞌe ederiro, eꞌanoꞌo, “Zae boꞌaḡano tibaꞌe mene deheḡa,” rae reiro. ");
INSERT INTO ksj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Iesuꞌa odaze vuzuꞌe hauḡirotene, raga dabuaḡa bare haḡadu ogomu fataḡa uhiḡano ehoriro. Ebu aneꞌa ziro, “Za eꞌa zae veize haḡateꞌe haḡaiḡa hugaꞌe edeḡahe? ");
INSERT INTO ksj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Za eḡe mazao ihore vazeḡa zu Zuhiꞌa Boro rae huheꞌohe. Zaꞌa raꞌetaꞌaꞌe hube, eꞌe ꞌuguḡa vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Eꞌe zae Zuhiꞌa Boro ebu ihore vazeḡa, rehano zae oda vuzuꞌeha. Eꞌanoꞌo zae zuni ꞌahoganiꞌa ꞌahoga oda vuzuꞌiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Eḡeꞌa zae veize haḡateꞌe teige, zae zuni haḡaifine e ꞌahige haḡadu ihozeha. ");
INSERT INTO ksj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Eḡeꞌa hube hune ziꞌohe. Tuḡure vazeḡaꞌe ane zuhiꞌa mene vitinoga, ebu iniuꞌa tuḡuniroteꞌe vazeḡaꞌe ani tuḡuniroteꞌe vazeḡa mene vitinoga. ");
INSERT INTO ksj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Za eꞌa izidi haḡataꞌaꞌe ederadu nize mae ovoeꞌenaꞌa vaze danazine, matuꞌe rudaꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“E zae niduꞌa mazao mene ḡoereꞌohe. E eḡeꞌa ohotiroteꞌe azaḡaꞌe edeḡa. Rehano Buka Zaḡoḡano ꞌahige rae mirihiroteꞌeꞌa hudaꞌuma, 'Eḡe ogomu tiburu auꞌeteꞌe vazeḡaniꞌa ḡihuradu e agirohiro.' ");
INSERT INTO ksj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ꞌUguḡaniꞌa ꞌizema fureranogano izidi eḡeꞌa ziꞌohe, mazaḡa ꞌuguḡaniꞌa fureratiteꞌe madaḡano eḡeꞌa eꞌe iniu rae ihoziroteꞌe zaeꞌa mae ḡihinifine raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Eḡeꞌa hube hune ziꞌohe, iniu eḡeꞌa tuḡuneꞌeteꞌe vazeḡa mae ḡihineꞌeteꞌe vazeḡaꞌe eḡe mae ḡihiheꞌohe. Ebu iniu eḡe mae ḡihiheꞌeteꞌe vazeḡaꞌe eḡe tuḡuhiroteꞌe vazeḡa mae ḡihineꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iesuꞌa ḡoere ꞌadi reirotene, zamaḡaniꞌa adudaro ebu ꞌahige rae fureniro, “Eḡeꞌa hube hune ziꞌohe, zae boꞌaḡano vaze ꞌahoganiꞌa eḡe revoniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ebu ane tahiꞌatahiꞌaꞌe aniꞌa iniu moneo reirotaꞌaꞌe mene ederadu ze zeḡeꞌa bare ḡiatitiro. ");
INSERT INTO ksj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Iesu zamarone tahiꞌaḡaniꞌa Iesu uhiḡano tave ehore radiro. ");
INSERT INTO ksj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Eꞌanoꞌo Simona Peteroꞌa ubumaḡa hina tahiꞌa eꞌe niro, “Ani iniu moneo raꞌeteꞌe ḡadinoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Eꞌanoꞌo ani Iesu mazao aroranadu ḡadiniro, “Zuhiꞌa Boro, aꞌe iniu?” ");
INSERT INTO ksj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Iesuꞌa naenaeniro, “Eꞌa ꞌuvahu odoga tahiḡa siuvao taradu hauꞌeteꞌe vazeḡaniꞌa revoniꞌuma.” Ebu aniꞌa ꞌuvahu odoga tahiḡa taradu Isakariota vazeḡa Simona ubuga, Iuda haro. ");
INSERT INTO ksj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ebu Iudaꞌa ꞌuvahu odoga eꞌe meirotene, Sataniꞌa zamaḡa diuḡiro. Ebu Iesuꞌa niro, “Ḡaꞌa haḡaiteꞌe haḡaiḡaꞌe ḡarihe haḡaoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Eꞌea ogau radiroteꞌe azaḡa boꞌaḡano vazeni ꞌahoga zuni Iesuꞌe nougadu Iuda mazao ꞌouge rae reiroteꞌe mene ederiro. ");
INSERT INTO ksj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Iudaꞌe hadize taufeꞌeteꞌe vazeḡa uꞌano, Iesu tahiꞌa nuꞌe ꞌahige zamariro, “Mui veize eme ura ḡauḡa nu hoitoga veize ga zahara azaḡa ḡau nu zenoga veize Iesuꞌa Iuda umineha.” ");
INSERT INTO ksj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Iudaꞌa ꞌuvahu odoga eꞌe madu zogone buaro. Aꞌe ohere zamaḡano. ");
INSERT INTO ksj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Iudaꞌa buarotene Iesuꞌa ziro, “Izidi Vaze Ubuga mae ḡihineꞌohe ebu ani uꞌano Badiꞌa mae ḡihineꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ubuga uꞌano Badiꞌa mae ḡihinine, Badiꞌaꞌe aneꞌa bare Ubuga mae ḡihiniꞌuma, ebu aneꞌa zogone ꞌougiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Eḡe tahiꞌatahiꞌa, e zae teite mada tahiḡa daꞌo radiꞌuma. Za eḡe vaḡiꞌuma, rehano ibite Iuda azaḡa boroboro ziroteꞌe teige, za idane ziꞌohe, 'Eḡeꞌa onamiteꞌe habaꞌa zaꞌe aroga mene idaḡa.' ");
INSERT INTO ksj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","E goro ḡoeꞌa iziga ziniꞌohe. Zaeꞌa zamarotitoꞌi. Eḡeꞌa za zamare borofeꞌeteꞌe teige, zae zuni zamarotitoꞌi. ");
INSERT INTO ksj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Zaeꞌa zamarotitine, vaze niduꞌa eꞌe horonadu zaꞌe eḡe tahiꞌatahiꞌa rae ederiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simona Peteroꞌa Iesu ḡadiniro, “Zuhiꞌa Boro, ḡa noꞌe onamiꞌuma?” Iesuꞌa naenaeniro, “Eḡeꞌa onamiteꞌe habaꞌaꞌe ḡaꞌa hegotoga izidi mene idaḡa. Rehano vesuꞌu eḡe hegotiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peteroꞌa niro, “Zuhiꞌa Boro, e nougadu izidi ḡa hegotogaꞌe mene idaḡa? Eḡeꞌa ḡae veize ḡabonehe zuni ahetiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Iesuꞌa naenaeniro, “Ḡa eḡe veize ḡaboneḡo ahetiꞌumahe? Eḡeꞌa hube hune ḡaꞌohe, ꞌizema kokorokuꞌa uganogano ḡa ḡae uḡidu eḡe oꞌohiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Iesuꞌa ane tahiꞌatahiꞌa ziro, “Ago zamare adudanoꞌi. Badiꞌa mazao fioꞌi ebu eḡe mazao zuni fioꞌi. ");
INSERT INTO ksj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Eḡe Mama neoꞌe radone habaꞌa ḡehaḡa. Aꞌe hube mene reifone, e ꞌahi mene reifo. E zae veize haba ꞌahoga ruhibe touga radu onamiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Onamadu zae veize haba ꞌahoga ruhibine, e bare ariꞌuma, ebu eḡe teite radifine zamazadu zaꞌe eḡe habao radiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Eꞌa onamiteꞌe habaꞌa ibiḡaꞌe zaꞌe edeḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasiꞌa Iesu niro, “Zuhiꞌa Boro, eme ḡaꞌa noꞌe onamiꞌumaꞌe aḡuꞌa. Eme nougenouge ibi eꞌe ederiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iesuꞌa naenaeniro, “Eꞌe Mama vaḡe onameꞌeteꞌe ibiḡa, zu ḡoere huga ihozeꞌeteꞌe vazeḡa, zu ḡabone tuḡutuḡu ziniꞌeteꞌe vazeḡa. Eḡe mazaonoꞌo mene reine, vaze ꞌahoganiꞌa Mama vaḡe onamogaꞌe mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Za hube hune e ederine, eḡe Mama zuni ederiꞌuma. Izidionoꞌo onamo zaꞌe ani edereꞌohe ebu ani horoniro.” ");
INSERT INTO ksj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipiꞌa niro, “Zuhiꞌa Boro, Mama ihofoꞌi. Eme eꞌe daꞌo urateꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iesuꞌa naenaeniro, “Eꞌe mada boro hune zae teite radiunu. Rehano Filipi, ḡa e aḡuꞌahe? Iniu eḡe horohiroteꞌe vazeḡaꞌe Mama zuni horoniro. Ḡa nougadu, 'Mama ihofoꞌi,' rae raꞌohe? ");
INSERT INTO ksj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ḡa eꞌe Mama teite tiburaroteꞌe zu Mamaꞌe eḡe teite tiburaroteꞌe mene mae ḡihineꞌehe? Eḡeꞌa ziꞌeteꞌe ḡoeꞌaꞌe eḡe edeḡano mene raꞌohe, rehano eḡe teite tiburanadu radiuꞌeteꞌe Mamaheꞌa ane gau haḡaeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Eḡe mazao fioꞌi. Eꞌe Mama teite tiburaroteꞌe zu Mamaꞌe eḡe teite tiburaroteꞌe mae ḡihinoꞌi. Eꞌe mae ḡihinoga mene idaḡa roꞌidene, eḡeꞌa haḡaeꞌeteꞌe haḡai gigiꞌaḡa horonadu eḡe ḡoere mae ḡihinoꞌi. ");
INSERT INTO ksj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Eḡeꞌa hube hune ziꞌohe. Iniu eḡe mazao fieꞌeteꞌe vazeḡaniꞌa eḡeꞌa haḡaeꞌeteꞌe haḡaiḡa zuni haḡaiꞌuma, ebu deꞌeguḡa ufeta vitine haḡai ḡihiꞌaḡa haḡaiꞌuma, mazaḡa e Mama vaḡe onamiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ebu za eḡe niḡano nagini umidine, eḡeꞌa ꞌouge haḡaiꞌuma. Aꞌe Ubuga uꞌano Badiꞌa ni mae ḡihinifine raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Za eḡe niḡano nagini umidine, eḡeꞌa ꞌouge haḡaiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Za eḡe zamare borofoꞌidene, eḡe goro ḡoeꞌa hegotoꞌi. ");
INSERT INTO ksj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Eḡeꞌa Mama uminadu aneꞌa za danazeꞌeteꞌe vazeḡa zae mazao tuḡuniꞌuma, zu aniꞌe zae teite radiꞌuma onamo tuḡutuḡu. ");
INSERT INTO ksj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Aniꞌe Vine Zaḡoḡa. Ani Badiꞌa moneo ḡoere huga ihozeꞌohe. Raha ꞌadi azaḡaniꞌa ani mene horoneꞌohe, zu ani mene edereꞌe ꞌahine, ani mae ḡihinogaꞌe mene idaḡa. Rehano zaꞌe ani edeḡa, mazaḡa aniꞌe zae teite radiuꞌohe zu zae teite tiburaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","E zaꞌe butu ega teige mene modiꞌuma, rehano zae vaḡe ariꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mada tahiḡa enogano raha ꞌadi azaḡaniꞌa e mene bare horohiꞌuma. Rehano zaꞌe e horohiꞌuma, mazaḡa eꞌe bare ḡabodiꞌuma ꞌahine, zae zuni ḡabodiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Eꞌe madaḡano zaꞌe ederiꞌuma, e eḡe Mama teite tiburaro, zu za eḡe teite tiburaro, ebu e zae teite tiburaro. ");
INSERT INTO ksj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Iniu eḡe goro ḡoeꞌa mae ḡihinadu eḡe hegoteꞌeteꞌe vazeḡaꞌe eḡe zamare borofeꞌeteꞌe vazeḡa. Iniu eḡe zamare borofeꞌeteꞌe vazeḡaꞌe eḡe Mamaꞌa ani zamare borofiꞌuma, ebu eḡeꞌa ani zamare borofiꞌuma, zu ani mazao eḡeꞌa fureraꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ebu mene Isakariota vazeḡa, Iuda ꞌahoganiꞌa Iesu niro, “Zuhiꞌa Boro, ḡaꞌe eme mazaoꞌe fureratihi, rehano raha azaḡa mazaoꞌe mene fureratihi raꞌohe. Nougadu ꞌouge raꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iesuꞌa naenaeniro, “Iniuꞌa eḡe zamare borofine, eḡe ḡoere hegotiꞌuma, zu eḡe Mamaꞌa ani zamare borofiꞌuma. Ebu Mamahe zu eḡeꞌa ani vaḡe onamadu ani teite ne tibano radiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Rehano iniu e mene zamare borofeꞌeteꞌe vazeḡaꞌe eḡe ḡoere mene hegoteꞌohe. Zaeꞌa eḡe mazaonoꞌo igiꞌeteꞌe ḡoeꞌa ꞌadiꞌe eḡe mene ḡoere, rehano eḡe tuḡuhiroteꞌe Mamahe ḡoere. ");
INSERT INTO ksj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","E zae teite radiuꞌeteꞌe zamaḡano ḡoere ꞌahi zeha. ");
INSERT INTO ksj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Rehano Mamaꞌa eḡe niḡano za danazeꞌeteꞌe vazeḡa, Vine Zaḡoḡa tuḡuniꞌuma, zu Vine Zaḡoḡaniꞌa ḡau niduꞌa ihoziꞌuma. Ebu aniꞌe eꞌa ziroteꞌe ḡoeꞌa niduꞌa zaeꞌa zamarifine ibitoziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","E zama roḡeḡa zae teite modeꞌohe. E eḡe zama roḡeḡa ziniꞌohe. Eḡeꞌa ziniꞌeteꞌe zama roḡeḡaꞌe mene raha azaḡaniꞌa ziniꞌeteꞌe heuḡa. Zamaze ago adudanoꞌi, zu ago rihanoꞌi. ");
INSERT INTO ksj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","E ꞌahige rae zirotaꞌaꞌe za igiro, 'Eꞌe zae muhize onamiꞌuma zu zae vaḡe bare ariꞌuma.' Zaꞌa e zamare borofifone, e Mama vaḡe onameꞌeteꞌe uꞌano zaeꞌa matuꞌifo, mazaḡa Mamaꞌe eḡe vitihe ufeta ḡihiꞌa hune. ");
INSERT INTO ksj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ꞌIzema eꞌeguḡaniꞌa fureranogano izidi eꞌa ihozeha. Aꞌe, eꞌeguḡaniꞌa fureraune, za eḡeꞌa ziroteꞌe ḡoeꞌa mae ḡihinifine raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","E zae teite mene faḡa ḡoeriꞌuma, mazaḡa raha zuhiꞌaḡa, Sataniꞌa eḡe agirohifine areꞌohe. Rehano aniꞌe eḡe raharahaheꞌeteꞌe inaraḡaꞌe oꞌoꞌa. ");
INSERT INTO ksj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","U raha azaḡaꞌe eḡeꞌa Mama zamare borofeꞌeteꞌe zu Mamaꞌa tuḡuhadu e ḡabonehe aheteꞌetaꞌaꞌe ederiꞌuma. Iḡunoꞌi, haba ꞌahi modihi.” ");
INSERT INTO ksj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Iesuꞌa ziro, “Eꞌe vaini ireḡa huga, ebu eḡe Mamaꞌe vaini mebaḡa taufeꞌeteꞌe vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Eḡe rana kamadu mene hudauꞌeteꞌe ezaga niduꞌaꞌe aneꞌa variꞌe modeꞌohe. U hudauꞌeteꞌe ezagaꞌe ufeta ḡehaḡaniꞌa hudanoga veize aneꞌa rirahe idaneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Eḡeꞌa ziroteꞌe ḡoeꞌa uꞌano, zaꞌe amahi deheraro. ");
INSERT INTO ksj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Eḡe teite tiburanadu radoꞌi, ꞌougine eḡe zuni zae teite tiburanadu radiꞌuma. Ezagaꞌe vaini ireḡano mene kamine, ani aneꞌa bare hudanogaꞌe mene idaḡa. Eꞌe teige, za eḡe teite mene tiburanadu radiune, za zaeꞌa bare hudanogaꞌe mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Eꞌe vaini ireḡa zu zaꞌe ezaga. Iniu eḡe teite tiburanadu radiune zu e ani teite tiburanadu radiune, aniꞌe ḡeharu hudaꞌuma. Mazaḡa za eḡe muhihine, ḡau ꞌahoga haḡaogaꞌe mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Iniu eḡe teite mene tiburanadu radiuꞌeteꞌe vazeḡaꞌe ezaga variꞌe modadu rorauꞌeteꞌe teigeꞌohe. Ezaga ꞌuguḡaꞌe vazeꞌa nuꞌonadu ire rogao feune hufi haoneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Zaꞌe eḡe teite tiburanadu radoꞌidene zu eḡe ḡoere hegotoꞌidene, za nagini urateꞌeteꞌe umidoꞌi, ꞌougine hidiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Zaꞌa ḡeharu hudanadu zaꞌe eḡe tahiꞌatahiꞌa rae vazevaze ihozine, zeꞌa eḡe Mama mae ḡihiniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mamaꞌa eḡe zamare borofiroteꞌe teige, eḡe zuni za zamare borofiro. Zaꞌe eḡe zamarone azaḡa rouga veize, eḡe teite tiburanadu radiuꞌenoꞌi. ");
INSERT INTO ksj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","E eḡe Mama goro ḡoeꞌa hegotadu aniꞌa e zamare borofeꞌeteꞌe teige, zaeꞌa eḡe goro ḡoeꞌa hegotine, eḡeꞌa za zamare borofiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","E ḡoere ꞌahi zeataꞌaꞌe, eḡe matuꞌuꞌe zae teite radadu zae matuꞌuꞌa iriꞌavoga veize raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Eḡe goro ḡoeꞌaꞌe ꞌahi eꞌe: Eḡeꞌa za zamare borofiroteꞌe teige, zaeꞌa zamarotitoꞌi. ");
INSERT INTO ksj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Iniuꞌa ane vaze veize ane ḡabone ahetine, aꞌe vaze zamarone ḡihiꞌa hune ebu zamarone nunu vitinoga. ");
INSERT INTO ksj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Za eꞌa ziꞌeteꞌe goro ḡoeꞌa hegotine, eḡe vaze raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","E zaꞌe tuḡure azaḡa rae mene bare huziꞌuma, mazaḡa tuḡure azaḡaꞌe zuhiꞌazeꞌa nagini haḡaeꞌeteꞌe mene edereꞌohe. Rehano zaꞌe eḡe vaze rae huzeha, mazaḡa e eḡe Mama mazaonoꞌo igiroteꞌe ḡoeꞌa niduꞌa ihoziro. ");
INSERT INTO ksj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Zaeꞌa e mene ohotiro, rehano eḡeꞌa za huzadu ohotiro. Eꞌanoꞌo zaeꞌa onamadu hudaꞌuma zu zae hugaꞌe mene hauḡiꞌuma. ꞌOugine, eḡe niḡano zaꞌa Mama mazao nagini umineꞌeteꞌe aneꞌa ziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Eḡe goro ḡoeꞌaꞌe ꞌahi eꞌe: Zaeꞌa zamarotitoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Raha azaḡaniꞌa za heꞌeheꞌezoꞌidene, zeꞌa ibite e heꞌeheꞌehirotaꞌaꞌe ederoꞌi. ");
INSERT INTO ksj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Zaꞌe raha azaḡa moneo reifone, ze zaꞌe zeḡe mone azaḡa radu za zamare borofifo. Rehano zaꞌe mene raha azaḡa moneo ꞌahine, zu eḡeꞌa za raha azaḡa mazaonoꞌo zamazadu ohotiro ꞌahine, zeꞌe za heꞌeheꞌezeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Eꞌa ziroteꞌe ḡoeꞌa ꞌahi zamaroꞌi, 'Tuḡure vazeḡaꞌe ane zuhiꞌa mene vitinoga.' Ze e sausauhine, zae zuni sausauziꞌuma. Ebu ze eḡe ihore egohaune, zae ihore zuni egohaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Zaꞌe eḡe none uꞌano zu zeꞌe eḡe tuḡuhiroteꞌe vazeḡa aḡuꞌa uꞌano, zeꞌa zae mazao ꞌouge haḡaiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Eꞌa aradu ze mene zifone, zeꞌe haḡaize sauꞌa uꞌano zamaze mene adudafo. Rehano izidiꞌe ze haḡaize sauꞌa moneo ḡoere nunu rougaꞌe mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Iniu eḡe heꞌeheꞌeheꞌeteꞌe vazeḡaꞌe eḡe Mama zuni heꞌeheꞌeneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Eꞌa zeḡe boꞌaḡano vaze ꞌahoganiꞌa mene haḡairoteꞌe haḡaiḡa mene haḡaifone, ze haḡaize sauꞌa uꞌano zamaze mene adudafo. Izidi ze eḡeꞌa haḡairoteꞌe haḡaiḡa gigiꞌa ꞌahiguḡa horoniro rehano, eḡe zu eḡe Mama heꞌeheꞌefiro. ");
INSERT INTO ksj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ꞌOugadu zeḡe Buka Zaḡoḡano mirihiroteꞌeꞌa hudaro, 'Zeꞌa mazaḡa oꞌoꞌano e heꞌeheꞌehiro.' ");
INSERT INTO ksj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Eꞌa Mama mazaonoꞌo zae mazao tuḡuniteꞌe vazeḡaꞌe zae danazeꞌeteꞌe vazeḡa, zu Mama mazaonoꞌo aradu ḡoere huga ihozeꞌeteꞌe vazeḡa. Aniꞌe Vine Zaḡoḡa. Aniꞌa arine, eḡe moneo rae fureniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ebu zae zuni eḡe moneo rae fureniꞌuma, mazaḡa zaꞌe ḡadaheḡanonoꞌo eḡe teite radiro.” ");
INSERT INTO ksj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Eꞌa ḡoere ꞌahi zeataꞌaꞌe zaeꞌa eḡe mazao fieꞌeteꞌe mene modoga veize raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ze nu'onu'o neḡanonoꞌo zae mae vaḡiziꞌuma. Ebu mada ꞌahoga meine, zae zimiꞌeteꞌe azaḡa niduꞌaꞌe zeḡeꞌa bare Badiꞌa veize gaueꞌohe rae zamariꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ze ꞌuguḡa haḡaiꞌuma, mazaḡa zeꞌe Mama zu e aḡuꞌa. ");
INSERT INTO ksj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","E ḡoere ꞌahi zeataꞌaꞌe ꞌuguḡaniꞌa fureraune, za eḡeꞌa ziroteꞌe ḡoeꞌa zamaroga veize raꞌohe. E ḡoere ꞌahi ḡadaheḡano mene ziro, mazaḡa e zae teite radiro.” ");
INSERT INTO ksj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Izidi e eḡe tuḡuhiroteꞌe vazeḡa vaḡe onamiꞌuma. Rehano zae boꞌaḡano vazeni ꞌahoganiꞌa, 'Ḡa noꞌe onamiꞌuma?' rae mene ḡadiheꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mazaḡa e ḡoere ꞌahi zeateꞌe uꞌano, zamaze are rudauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Rehano eḡeꞌa hube hune ziꞌohe, e za muhizeꞌetaꞌaꞌe zae veizeꞌe ufeta manoḡa. Mazaḡa e mene muhizine, danazeꞌeteꞌe vazeḡaniꞌa zae vaḡe mene ariꞌuma. Rehano e za muhizine, eḡeꞌa ani zae vaḡe tuḡuniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Aniꞌa arine, haḡai sauꞌa moneo, vaze duduḡa moneo ebu kota moneo raha azaḡaꞌe veꞌoḡa rae fureniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Haḡai sauꞌa moneo rae fureneꞌetaꞌaꞌe mazaḡa ze eḡe mazao mene fieꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Vaze duduḡa moneo fureneꞌetaꞌaꞌe mazaḡa eꞌe Mama vaḡe onamiꞌuma ebu za e mene bare horohiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ebu kota moneo rae fureneꞌetaꞌaꞌe mazaḡa raha ꞌadi azaḡa zuhiꞌaziꞌeteꞌe vazeḡa, Satani kotaniro. ");
INSERT INTO ksj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","E za zihi raꞌeteꞌe ḡoeꞌaꞌe ḡehaḡa, rehano izidi zaꞌe faine zamarogaꞌe mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Rehano ḡoere huga ihozeꞌeteꞌe vazeḡa, Vine Zaḡoḡaniꞌa arine, aniꞌa zae ibitozeadu zaeꞌa ḡoere huga niduꞌa ederiꞌuma. Aniꞌe ane edeḡano mene ḡoeriꞌuma, rehano Mama mazao igiꞌeteꞌe ḡoeꞌa daꞌo reꞌuma. Ebu zama moneo naginiꞌa fureratiteꞌe ziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Aniꞌa eꞌe ḡihiꞌa hune rae ihoziꞌuma, mazaḡa aniꞌe eḡe ḡoere madu ziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ḡau niduꞌaꞌe Mama mazao, ebu ani ḡau niduꞌaꞌe eḡe ḡau. Eꞌanoꞌo e ꞌahige rae zeha, 'Vine Zaḡoḡaniꞌa eḡe ḡoere madu za ihoziꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Mada tahiḡa ḡarugano za e mene bare horohiꞌuma, ebu mada tahiḡa ḡarugano e bare horohiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Iesu tahiꞌa nuꞌa neneḡaniro, “Ani ḡoere hugaꞌe nagini? Ani ꞌahige raꞌohe, 'Mada tahiḡa ḡarugano za e mene bare horohiꞌuma, ebu mada tahiḡa ḡarugano e bare horohiꞌuma,' ebu 'Mazaḡa e Mama vaḡe onamiꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ze zeḡeꞌa bare ḡadimutitiro, “'Mada tahiḡa ḡarugano,' rae rataꞌaꞌe hugaꞌe nagini? Eme aniꞌa nagini ḡoereꞌetaꞌaꞌe aḡuꞌa.” ");
INSERT INTO ksj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iesuꞌe ze ane ḡoere moneo ḡadinihi reirotaꞌaꞌe ederadu ziro, “E ꞌahige zeha, 'Mada tahiḡa ḡarugano za e mene bare horohiꞌuma, ebu mada tahiḡa ḡarugano e bare horohiꞌuma.' Zaꞌe ḡoere ꞌahi huga moneo ḡadimutiteꞌehe? ");
INSERT INTO ksj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Eḡeꞌa hube hune ziꞌohe, zaꞌe niau ḡoinahiꞌuma, u raha azaḡaꞌe matuꞌiꞌuma. Zaꞌe zamaze ariꞌuma, rehano zamaze areꞌetaꞌaꞌe ḡihuradu matuꞌiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Roḡae ꞌahoganiꞌa ene fureneꞌetene zamaze aduduꞌohe, mazaḡa gigiꞌa boro meiteꞌe madaḡaniꞌa maha. Rehano ani ene furenatene, ani gigiꞌa aḡutuꞌohe, mazaḡa eneꞌa rahao fureranadu matuꞌeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Eꞌe teige, izidi zaꞌe zamaze areꞌohe, rehano e za bare ḡiaziꞌuma ebu zaꞌe matuiꞌuma. Vaze ꞌahoganiꞌa za matuꞌu ꞌahi mene meiniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Eꞌe madaḡano zaꞌe ḡadimu ꞌahoga mene ḡadihiꞌuma. Eḡeꞌa hube hune ziꞌohe, eḡe niḡano Mama nagini uminine, aneꞌa ziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ibite onao izidi eḡe niḡano za Badiꞌa mazao ḡau ꞌahoga mene uminiro. Uminoꞌi, ꞌougine hidiꞌuma ebu za matuꞌuꞌa iriꞌaviꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","E hari idaidaḡa hina ḡoreziro. Rehano mada ꞌahoga meine, hari idaidaḡa hina mene bare ḡoreziꞌuma, ebu Mama moneo dehene ziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Eꞌe madaḡanoꞌe za eḡe niḡano Mama mazao uminiꞌuma. Eḡeꞌa zae veize Mama uminiꞌuma rae mene ziꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Zaꞌe eḡe zamare borofiroteꞌe zu za eꞌa Badiꞌa mazaonoꞌo ariroteꞌe mae ḡihiniroteꞌe uꞌano, Mamaꞌe aneꞌa bare za zamare borofeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Eꞌe Mama mazaonoꞌo raha ꞌahi ariro. Izidi e raha ꞌahi modadu Mama vaḡe bare onamiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ebu Iesu tahiꞌatahiꞌaꞌa reiro, “Izidi ḡa dehene ḡoereꞌohe ebu hari idaidaḡa mene raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Izidi eme edereha, ḡaꞌe ḡau niduꞌa edeḡa zu ḡa vaze ḡadimu ibite ederadu ze bare ḡadiꞌoga mene urateꞌohe. Eꞌe uꞌano, eme ḡaꞌa Badiꞌa mazaonoꞌo ariroteꞌe mae ḡihineꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iesuꞌa naenaeziro, “Izidi zaꞌe eḡe mazao fieꞌehe? ");
INSERT INTO ksj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Rehano mada ꞌahoganiꞌa areꞌohe, ebu izidi maha. Eꞌe madaḡano za tibatiba neze uꞌa rovote ḡouriꞌuma ebu eḡe daꞌo muhihiꞌuma. Rehano eꞌe mene eḡe daꞌo, mazaḡa eḡe Mamaꞌe eḡe teite radiuꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","E ḡoere ꞌahi zeataꞌaꞌe za eḡe teite tiburanadu zamaze roḡenoga veize raꞌohe. Raha ꞌada za aduga hideꞌohe, rehano inaroꞌi! Eḡeꞌa raha ꞌadi gigiꞌaḡa raharahaniro.” ");
INSERT INTO ksj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iesuꞌa ḡoere ꞌahi ziroteꞌe enogano, adure ḡohani ḡianadu kuraro, “Mama, madaḡaꞌe maha. Ubugoꞌa ḡaꞌe ḡihiꞌa hune rae ihozifine, ḡaeꞌa Ubugoꞌe ḡihiꞌa hune rae ihozoꞌi. ");
INSERT INTO ksj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mazaḡa ḡaeꞌa Ubuga haroteꞌe azaḡa niduꞌa ḡabone tuḡutuḡu zenoga veize, vaze niduꞌa zuhiꞌaziꞌeteꞌe gigiꞌaḡa Ubuga haro. ");
INSERT INTO ksj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ḡabone tuḡutuḡu hideꞌeteꞌe ibiḡaꞌe vazeꞌa ḡa, Badiꞌa tibuhuga ebu ḡaeꞌa tuḡuniroteꞌe vazeḡa, Iesu Keriso edereꞌeteꞌe raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ḡaeꞌa iniroteꞌe gauḡaꞌe eḡeꞌa hauḡiro. ꞌOugadu e raha ꞌada ḡaꞌe ḡihiꞌa hune rae ihoziro. ");
INSERT INTO ksj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mama, raha zu aduga ꞌizema haḡaogano niheꞌe niḡo teite mae ḡihiniroteꞌe teige, izidi zuni niheꞌe niḡo teite mae ḡihinoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“E ḡaꞌa raha ꞌadao iniroteꞌe azaḡa mazao ḡae moneo rae fureniro. Zeꞌe ḡae tahiꞌatahiꞌa rae reiro, ebu ḡaeꞌa ze iniro, zu ze ḡae ḡoere hegotiro. ");
INSERT INTO ksj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Izidi ze ḡaꞌa iniroteꞌe ḡauḡa niduꞌaꞌe ḡae mazaonoꞌo arirotaꞌaꞌe edeḡa. ");
INSERT INTO ksj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mazaḡa ḡaꞌa ihiroteꞌe ḡoeꞌa eḡeꞌa ziro ebu zeḡeꞌa mae ḡihiniro. Ze eḡeꞌa ḡae mazaonoꞌo arirotaꞌaꞌe hube hune ederiro, zu ḡaeꞌa eḡe tuḡuhiroteꞌe mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","E zeḡe veize kurauꞌohe. E raha azaḡa veize mene kurauꞌohe, rehano ḡaeꞌa iniroteꞌe azaḡa veize kurauꞌohe, mazaḡa zeꞌe ḡae tahiꞌatahiꞌa. ");
INSERT INTO ksj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Eḡe ḡau niduꞌaꞌe ḡae ḡau, ebu ḡae ḡau niduꞌaꞌe eḡe ḡau. Ze eꞌe ḡihiꞌa hune rae raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Eꞌe raha ꞌada mene bare radiꞌuma ebu ḡae vaḡe amiꞌuma. Rehano zeꞌe raha ꞌada radiꞌuma. Mama Zaḡoḡa, ḡa niḡo iniro. Ḡae niḡano ze biroꞌi ebu ḡa eḡe teite tiburaroteꞌe teige, zeḡe niduꞌa mae tibuzoꞌi. ");
INSERT INTO ksj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","E zeḡe teite radiuꞌeteꞌe zamaḡano ḡaeꞌa iniroteꞌe niḡa inaraḡa hina ze faine biriro zu taufiro, eꞌanoꞌo zeḡe niduꞌa mene dauḡiro. Rehano tiba daꞌo ruineꞌeteꞌe ibiḡa uꞌa diuḡiro. ꞌOugadu Buka Zaḡoḡano mirihiroteꞌe ḡoeꞌaniꞌa hudaro. ");
INSERT INTO ksj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Izidi e ḡae vaḡe amiꞌuma. Eꞌe raha ꞌada zeḡe veize ꞌahige kurauꞌohe, mazaḡa e matuꞌe rudauꞌeteꞌe teige, zeḡe zuni matuꞌuꞌa iriꞌavozoga veize raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","E ḡoereḡo ze ziniro, rehano raha azaḡaniꞌa ze heꞌeheꞌeziro, mazaḡa eꞌe mene raha azaḡa moneo teige, zeꞌe mene raha azaḡa moneo raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","E ḡaꞌa ze rahaonoꞌo zamaze vaḡizoga veize mene umiꞌeꞌohe, rehano Satani mazaonoꞌo ze biroga veize umiꞌeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Eꞌe mene raha azaḡa moneo teige, zeḡe zuni mene raha azaḡa moneo raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ze ḡoere huga hina zaḡozaḡozoꞌi. Ḡae ḡoereꞌe huga. ");
INSERT INTO ksj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ḡaeꞌa e raha ꞌada tuḡuhiroteꞌe teige, eḡeꞌa ze raha azaḡa mazao tuḡuziro. ");
INSERT INTO ksj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Zeḡe veize e eḡeꞌa bare zaḡozaḡoheꞌohe, mazaḡa zeḡe zuni ḡoere huga hina zaḡozaḡozoga veize raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“E eḡe tahiꞌatahiꞌa veize daꞌo mene kurauꞌohe, rehano ze ḡoere egadu eḡe mazao fiteꞌe azaḡa veize zuni kurauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mama, ḡa eḡe teite tiburaroteꞌe zu e ḡae teite tiburaroteꞌe teige, zeḡe niduꞌa tiburafine kurauꞌohe. Ebu zeḡe zuni emeḡe teite tiburanadu raha azaḡaniꞌa ḡa eḡe tuḡuhiroteꞌe mae ḡihinoga veize kurauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ḡa eꞌe ḡihiꞌa hune rae ihoziroteꞌe teige, eḡe zuni zeꞌe ḡihiꞌa hune rae ihoziro, mazaḡa emeꞌe tiburaroteꞌe teige, zeḡe zuni tiburafine raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","E zeḡe teite tiburaro zu ḡa eḡe teite tiburaro. E zeḡe niduꞌa hube hune tiburanoga veize kurauꞌohe. Mazaḡa ḡaeꞌa e tuḡuhiroteꞌe ebu e zamare borofeꞌeteꞌe teige, ḡaeꞌa zeḡe zuni zamare borofeꞌetaꞌaꞌe raha azaḡaniꞌa ederifine raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Mama, e ḡaeꞌa iniroteꞌe azaḡaꞌe eḡeꞌa radiuꞌeteꞌe habaꞌano eḡe teite radoga urateꞌohe. Ebu ꞌizema raha zu adure haḡaogano ḡaeꞌa eḡe zamare borofadu ḡa eꞌe ḡihiꞌa hune rae reirotaꞌaꞌe zeḡe zuni ederoga urateꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mama duduḡa hune, raha azaḡaꞌe ḡa aḡuꞌa, rehano e ḡaꞌe edeḡa. Ebu eḡe tahiꞌatahiꞌaꞌe ḡaeꞌa eḡe tuḡuhirotaꞌaꞌe edeḡa. ");
INSERT INTO ksj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","E zeḡe mazao ḡa ihoziro ebu barebare ihoziꞌuma. Aꞌe ḡaꞌa e zamare borofiroteꞌe teige, zeḡe zuni vaze ꞌahogaꞌahoga zamare borofoga zu e zeḡe teite tiburanoga veize raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iesuꞌa kuraroteꞌe enogano, ane tahiꞌatahiꞌa teite Kiderona doꞌoḡa moneafa onamiro. Eꞌea olivi ireḡa mebaḡa ꞌahoga eꞌe, ebu ani ane tahiꞌatahiꞌa teite eꞌe mebaḡa diuḡiro. ");
INSERT INTO ksj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Iesu revoharoteꞌe vazeḡa, Iuda zuni eꞌe habaꞌa ederiro, mazaḡa Iesuꞌa ḡae ḡehaḡa ane tahiꞌatahiꞌa teite deꞌea nuꞌoraro. ");
INSERT INTO ksj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Eꞌanoꞌo Iudaꞌa Roma uti azaḡa, ebu dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu Farisea azaḡaniꞌa tuḡuziroteꞌe kuru neḡa uti azaḡa teite ariro. Ze ihure nunu zu uti ḡauḡa madu meba eꞌe diuḡiro. ");
INSERT INTO ksj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iesuꞌe ane mazao naginiꞌa fureratiteꞌe ederadu zeḡe vaḡe onamiro ebu ḡadiziro, “Zaꞌe iniu vaḡeꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Zeḡeꞌa naenaeniro, “Nazareta vazeḡa Iesu.” Ebu aniꞌa ziro, “Aꞌe eḡe.” Ani revoharoteꞌe vazeḡa, Iudaꞌe zeḡe teite deꞌea edau radiro. ");
INSERT INTO ksj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Iesuꞌa, “Aꞌe eḡe,” rae zirotene, ze suve ḡouradu rahao higau bauriro. ");
INSERT INTO ksj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ebu Iesuꞌa bare ḡadiziro, “Zaꞌe iniu vaḡeꞌohe?” Zeꞌa niro, “Nazareta vazeḡa Iesu.” ");
INSERT INTO ksj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iesuꞌa naenaeziro, “E zeha, aꞌe eḡe. Za e vaḡoꞌidene, eḡe tahiꞌatahiꞌaꞌe ahete modoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Aniꞌa ꞌouge reirotaꞌaꞌe ibite ꞌahige kuraroteꞌeꞌa hudanoga veize reiro, “E ḡaeꞌa iniroteꞌe azaḡa boꞌaḡano tiba zuni mene dauniro.” ");
INSERT INTO ksj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Eꞌe madaḡano Simona Peteroꞌe benisiḡeta. Aneꞌa eꞌe ahase bunadu dibuꞌo vazeḡa ḡihiꞌaḡa tuḡure vazeḡa udirotene, edaꞌe teḡaḡa variꞌe butiro. Tuḡure vazeḡa niḡaꞌe Malokusi. ");
INSERT INTO ksj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ꞌOugadu Iesuꞌa Petero niro, “Benisiḡo bare iḡuꞌano ofoꞌi! Eḡe Mamaꞌa iniroteꞌe bioḡa ꞌahi eḡeꞌa gage huniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Roma uti azaḡa zu uti vazeḡa ḡihiꞌaḡa ebu kuru neḡa ḡianeꞌeteꞌe Iuda uti azaḡaniꞌa Iesu obone teadu autiro. ");
INSERT INTO ksj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ebu ze ani Anasi vaḡe ibite tutune onamiro. Anasiꞌe Kaiafa emoḡa zu Kaiafaꞌe eꞌe muriḡano dibuꞌo vazeḡa ḡihiꞌaḡa. ");
INSERT INTO ksj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiafaꞌe ibite Iuda azaḡa boroboro mazao ꞌahige iraduguziro, “Vaze niduꞌa veize vaze tibaniꞌa rudauneꞌe ufeta manoḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simona Petero zu Iesu tahiꞌa ꞌahoganiꞌa Iesu hegote onamiro. Tahiꞌa eꞌeꞌa dibuꞌo vazeḡa ḡihiꞌaḡa ederadu Iesu teite dibuꞌo vazeḡa ḡihiꞌaḡa ne habaꞌa diuḡiro. ");
INSERT INTO ksj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Rehano Peteroꞌe ibiheta enogano edau radiro. Eꞌanoꞌo dibuꞌo vazeḡa ḡihiꞌaḡa edereꞌeteꞌe tahiꞌaḡa eꞌeꞌa buanadu ibiheta taufeꞌeteꞌe roḡaeḡa ḡoreniro, ebu Petero mae zouniro. ");
INSERT INTO ksj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ꞌOugirotene, ibiheta taufeꞌeteꞌe roḡaeḡa ꞌahoganiꞌa Petero niro, “Vaze ꞌomo tahiꞌatahiꞌa boꞌaḡano ḡae zuni tahiꞌa ꞌahogahe?” Aneꞌa naenaeniro, “Eꞌe mene.” ");
INSERT INTO ksj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Eꞌe madaḡanoꞌe nahune, eꞌanoꞌo tuḡure azaḡa zu kuru neḡa uti azaḡaniꞌa ahirize giginoga radu ire roga hufiro, ebu ire roga gabaḡeḡenadu idiro. Petero zuni ahiꞌa gigineꞌenaꞌa, zeḡe teite edau radiro. ");
INSERT INTO ksj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Eꞌe madaḡano dibuꞌo vazeḡa ḡihiꞌaḡaniꞌa Iesu mazao ane tahiꞌatahiꞌa zu ane ihore moneo ḡadiniro. ");
INSERT INTO ksj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ebu Iesuꞌa naenaeniro, “E hunio vaze niduꞌa mazao ḡoeriro. Iuda azaḡa niduꞌa nuꞌoruꞌeteꞌe kuru neḡa ga nuꞌonuꞌo neḡa zamaḡano iḡaiḡa ihoziro. E ḡoere ꞌahoga mene ꞌuꞌuru reiro. ");
INSERT INTO ksj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ḡa nougadu e ḡadiheꞌohe? Eḡe ḡoere igiroteꞌe azaḡa ḡadizoꞌi. Ze eꞌa nagini reirotaꞌaꞌe edeḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Iesuꞌa ꞌouge reirotene, kuru neḡa uti vazeḡa ꞌahoganiꞌa ani uhiḡano edanadu iraḡano faꞌoniro ebu niro, “Ḡa dibuꞌo vazeḡa ḡihiꞌaḡa mene gubaneꞌohe!” ");
INSERT INTO ksj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Iesuꞌa naenaeniro, “E ḡoere ꞌahoga veꞌore roꞌidene, naginiꞌe veꞌoḡa rae furenoꞌi. Rehano e ḡoere huga roꞌidene, nougadu irahe faꞌoneha?” ");
INSERT INTO ksj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ebu Anasiꞌa Iesu ꞌevore ꞌize utoga zamaḡano dibuꞌo vazeḡa ḡihiꞌaḡa, Kaiafa vaḡe tuḡuniro. ");
INSERT INTO ksj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simona Peteroꞌa edanadu ire roga genaḡano ide radiroteꞌea, vaze nuꞌa ḡadiniro, “Ḡaꞌe Iesu tahiꞌatahiꞌa boꞌaḡano ꞌahoga, oꞌehe?” Rehano aneꞌa oꞌoniro, “Eꞌe mene.” ");
INSERT INTO ksj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Dibuꞌo vazeḡa ḡihiꞌaḡa tuḡure vazeḡa ꞌahogaꞌe Peteroꞌa teḡaḡa variꞌiroteꞌe vazeḡa nabuga. Aneꞌa niro, “Eḡeꞌa ḡa ani teite olivi ireḡa mebaḡano radiuꞌeteꞌe horoꞌeha.” ");
INSERT INTO ksj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peteroꞌa bare oꞌoniro. Aneꞌa ꞌouge reirotene, kokorokuꞌa ugaro. ");
INSERT INTO ksj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ebu Iuda azaḡa boroboroꞌa Iesu Kaiafa mazaonoꞌo Roma gavana vazeḡa neḡa tutune onamiro. Aꞌe Oherebau uzeuze reiro. Zeꞌe Roma gavana ne zamaḡa mene diuḡiro. Mazaḡa aniꞌe Badiꞌa aḡuꞌa vazeḡa radu, ane ne diuḡine ze toradanadu Iḡine Modiroteꞌe Muiḡa anoga mene idaḡa rae zamariro. ");
INSERT INTO ksj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Eꞌanoꞌo Pilatoꞌa zeḡe vaḡe bua aradu ḡoreziro, “Vaze ꞌadiꞌe nagini haḡadu za aniꞌe veꞌoḡa rae raꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ze naenaeniro, “Vaze ꞌahiꞌe mene vaze sauꞌa reifone, emeꞌa ani ḡae ꞌevoreo mene riꞌinifo.” ");
INSERT INTO ksj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatoꞌa ziro, “Zaeꞌa ani tutune onamadu zae goro hina kotanoꞌi.” Iuda azaḡa boroboroꞌa naenaeniro, “Eme, Iuda azaḡaꞌe vaze ꞌahoga runeo tuḡunogaꞌe mene idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ꞌOugadu Iesuꞌa nougenouge rudatiteꞌe moneo reiroteꞌe ḡoeꞌaniꞌa hudaro. ");
INSERT INTO ksj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatoꞌa ane ne bare diuḡadu Iesu huniro ebu ḡadiniro, “Ḡaꞌe Iuda azaḡa kinihe?” ");
INSERT INTO ksj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iesuꞌa naenaeniro, “Ḡadimu ꞌadiꞌe ḡae mazaonoꞌo ga vaze nuꞌa eḡe moneo ḡeiro?” ");
INSERT INTO ksj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatoꞌa naenaeniro, “Eꞌe mene Iuda vazeḡa. Ḡae haba azaḡa zu dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡaniꞌa eḡe ꞌevoreo riꞌiꞌeha. Ḡa nagini haḡairo?” ");
INSERT INTO ksj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iesuꞌa niro, “Eꞌe mene raha ꞌadi zuhiꞌaziꞌeteꞌe kiniḡa. Eꞌe raha ꞌadi zuhiꞌaziꞌeteꞌe kiniḡa reifone, eḡe tuḡure azaḡaniꞌa Iuda azaḡa boroboro utitozenadu zeḡe ꞌevoreo eḡe riꞌihoga gararifo. Eḡeꞌa zuhiꞌaziꞌeteꞌe habaꞌaꞌe mene raha ꞌadi, rehano haba ꞌahoga.” ");
INSERT INTO ksj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatoꞌa niro, “Tena ḡaꞌe kinihe?” Iesuꞌa naenaeniro, “Ḡa ḡaeꞌa bare eꞌe kini raꞌohe. Aꞌe hube. E ḡoere huga rae furenoga veize fureraro zu raha ꞌahi ariro. Iniu ḡoere huga hegoteꞌeteꞌe azaḡaꞌe eḡe ḡoere igiꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatoꞌa ḡadiniro, “Ḡoere hugaꞌe nagini?” Pilatoꞌa ꞌouge reiroteꞌe enogano, Iuda azaḡa boroboro vaḡe bare buanadu ziro, “E sauꞌa ꞌahoga ani mazaonoꞌo mene horoneha. ");
INSERT INTO ksj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Rehano Iuda azaḡa haḡai idunaḡano, Iḡine Modiroteꞌe Muiḡano e zae veize ḡuꞌa vazeḡa ꞌahoga tuḡune buneꞌohe. Za eꞌa Iuda azaḡa kini tuḡune bunoga urateꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ze bare ḡihau huaro, “Ani mene, rehano Barabasi mae bunoꞌi!” Barabasiꞌe ḡonore vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Eꞌanoꞌo Pilatoꞌa Iesu zamahu onamadu uti azaḡaniꞌa masiniro. ");
INSERT INTO ksj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ebu uti azaḡaniꞌa ire ezaga meigameiga mae ḡurunadu kini vadiga adiriḡa teige, vadigano redoharo ebu dabua kanaḡa vidoharo. ");
INSERT INTO ksj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ebu ze barebare ane vaḡe aradu ḡirihoharo, “Iuda azaḡa kini, nigunihi!” Ebu ze iraḡano faꞌoniro. ");
INSERT INTO ksj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatoꞌa bare buanadu Iuda azaḡa boroboro ziro, “Ḡianoꞌi. E Iesu zamahu zae mazao buniꞌuma. ꞌOugine, za eḡeꞌa ane mazaonoꞌo sauꞌani ꞌahoga mene horonataꞌaꞌe ederiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ebu Iesuꞌa ire ezaga meigameiga vadigano zu dabua kanaḡaḡeta bua ariro. Pilatoꞌa ziro, “Ḡianoꞌi, vaze aꞌe ꞌadi eꞌe!” ");
INSERT INTO ksj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu kuru neḡa uti azaḡaniꞌa Iesu horonirotene, ze ḡihau huaro, “Ani satauronoꞌi! Satauronoꞌi!” Pilatoꞌa ziro, “Zaeꞌa tutune onamadu satauronoꞌi. Eꞌe ani mazaonoꞌo veꞌoḡani ꞌahoga mene horoneha.” ");
INSERT INTO ksj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Iuda azaḡa boroboroꞌa naenaeniro, “Emeḡe goro ḡoeꞌa idunaḡano aniꞌe rudaꞌuma, mazaḡa ani aneꞌa bare Badiꞌa Ubuga rae reiro.” ");
INSERT INTO ksj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatoꞌa zeḡe ḡoere igirotene, ufeta riharo. ");
INSERT INTO ksj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ebu ane ne bare diuḡadu Iesu ḡadiniro, “Ḡaꞌe noumanoꞌo ariro?” Rehano Iesuꞌa mene naenaeniro. ");
INSERT INTO ksj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilatoꞌa niro, “Ḡa mene ḡorehiꞌumahe? Ḡa tuḡuꞌe buḡaditeꞌe ga satauroḡaditeꞌe gigiꞌaḡaꞌe eḡeꞌa meiro. Ḡa mene edereꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Iesuꞌa naenaeniro, “Badiꞌaꞌa e sausauheꞌeteꞌe gigiꞌaḡa mene ḡanifone, ḡa e sausauhoga mene idarafo. Eꞌanoꞌo ḡae ꞌevoreo riꞌihateꞌe vazeḡa sauꞌaꞌe ufeta boro, aꞌe ḡae sauꞌa vitinoga.” ");
INSERT INTO ksj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Iesu ḡoere uꞌano, Pilatoꞌa ani tuḡune bunihi rae inariro. Rehano Iuda azaḡa boroboroꞌa houhoune niro, “Ḡa vaze ꞌahi tuḡune bunine, ḡaꞌe mene Roma kiniḡa mone vazeḡa. Iniuꞌa ane bare kini rae reine, aniꞌe Roma kiniḡa agirohauꞌeteꞌe vazeḡa.” ");
INSERT INTO ksj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatoꞌa ḡoere eꞌe igirotene, Iesu zamahu bunadu kota habaꞌano ehoriro. Kota vazeḡa ehoroḡa habaꞌaꞌe Vatava hina Ruruḡiro rae huniroteꞌe habaꞌano tiro. Aꞌe Heberu ḡoeꞌano Gabata rae huniro. ");
INSERT INTO ksj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Eꞌe madaḡaꞌe Iḡine Modiroteꞌe Muiḡa ꞌizema mougano, ruhibeꞌeteꞌe madaḡa zu madai kirikiri. Pilatoꞌa Iuda azaḡa ziro, “Ḡianoꞌi, zae kiniꞌe ꞌadi eꞌe.” ");
INSERT INTO ksj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Zeḡeꞌa huaro, “Manoꞌi! Manoꞌi! Satauronoꞌi!” Pilatoꞌa ḡadiziro, “E zae kini satauroniꞌumahe?” Dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡaniꞌa naenaeniro, “Emeḡe kini ꞌahogaꞌe oꞌoꞌa, rehano Roma kiniḡa daꞌo.” ");
INSERT INTO ksj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Eꞌanoꞌo Pilatoꞌa Iesu satauronoga veize zeḡe ꞌevoreo riꞌiniro. Ebu uti azaḡaniꞌa Iesu tutune onamiro. ");
INSERT INTO ksj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Iesuꞌa ane satauro odoheꞌenaꞌa, Vadini Isiḡa rae huneꞌeteꞌe habaꞌa onamiro. Aꞌe Heberu ḡoeꞌano Gologota rae huniro. ");
INSERT INTO ksj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Eꞌea ze Iesu satauroniro. Vaze aheu zuni ane edaꞌe moneo ebu kauri moneo satauroziro, u Iesuꞌe nemao satauroniro. ");
INSERT INTO ksj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatoꞌa Iesu haḡai sauꞌaꞌe nagini rae ihozifine, ire rafaḡa rana mirihadu satauro rana tiro. Aꞌe ꞌahige rae mirihiro, “NAZARETA VAZEḠA IESU, IUDA AZAḠ KINI.” ");
INSERT INTO ksj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mirihirotaꞌaꞌe Iuda azaḡa ḡehaḡaniꞌa meꞌodiro. Mazaḡa Iesu satauroniroteꞌe habaꞌaꞌe Ierusalema uhiḡano, ebu aꞌe Heberu ḡoeꞌano, Roma ḡoeꞌano, zu Giriki ḡoeꞌano mirihiro. ");
INSERT INTO ksj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Eꞌanoꞌo dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡaniꞌa Pilato niro, “'Iuda Azaḡa Kini,' rae ago mirihoꞌi, rehano 'Eꞌe Iuda Azaḡa Kini,' rae mirihoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatoꞌa naenaeziro, “E eḡeꞌa mirihihi rae raꞌeteꞌe ḡoeꞌa miriheha.” ");
INSERT INTO ksj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ebu Iesu satauronirotene, uti azaḡaniꞌa Iesu raga dabuaḡa madu ḡazaḡano rovoniro, ebu zeḡeꞌa tibatiba meiro. Ze zizuni dabuaḡa zuni meiro. Aꞌe hitanaonoꞌo oda ḡuzu dabuaḡa tiba zu mene variꞌe turiniroteꞌe dabuaḡa. ");
INSERT INTO ksj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Eꞌanoꞌo uti azaḡaniꞌa neneḡaniro, “ꞌAdiꞌe mene zigiꞌuma. Kaḡusi arahoḡa arahadu iniuꞌa meiteꞌe ḡianiꞌuma.” ꞌOugadu Buka Zaḡoḡano mirihiroteꞌeꞌa hudaro, “Ze eḡe raga dabuaḡa ḡahugotitiro, ebu zizuni dabuaḡaꞌe kaḡusi arahoḡa arahadu meiro.” Eꞌanoꞌo uti azaḡaniꞌa ꞌouge haḡairo. ");
INSERT INTO ksj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Iesu satauro uhiḡano Iesu viꞌa, viꞌa negoḡa, Kolopasi inuga Maria, ebu Magadala roḡaeḡa Mariaꞌa edau radiro. ");
INSERT INTO ksj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Iesuꞌa viꞌa zu ane zamarone tahiꞌaḡa viꞌa uhiḡano edauꞌeteꞌe horozirotene, viꞌa niro, “Roḡae boro, aniꞌe ḡae ubugo.” ");
INSERT INTO ksj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ebu Iesuꞌa tahiꞌa eꞌe niro, “Aniꞌe ḡae viꞌu.” Eꞌe madaḡanonoꞌo tahiꞌa eꞌeꞌa Iesu viꞌa tutune ane ne onamadu taufiro. ");
INSERT INTO ksj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Eꞌe enogano, Iesuꞌe ani gauḡa niduꞌa izidi hauḡataꞌaꞌe ederiro. Ebu Buka Zaḡoḡano mirihiroteꞌeꞌa hudanoga veize ꞌahige rae reiro, “E irinehe moꞌoheha.” ");
INSERT INTO ksj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Eꞌea vaini vuḡa ḡiḡiꞌa ḡoḡoreḡa ꞌahoga eꞌe. Eꞌanoꞌo ze vu romane zouneꞌeteꞌe ḡauḡa madu vaini vuḡa ḡiḡiꞌa iriꞌavoniro, ebu Gubu somoriḡa rana teadu ani mazaneo ite tiro. ");
INSERT INTO ksj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Iesuꞌa vaini vuḡa ḡiḡiꞌaḡa gagadu ꞌahige rae reiro, “Eḡe gau niduꞌa hauḡeha.” Ebu vadiga ḡuḡuradu iriga riꞌiro. ");
INSERT INTO ksj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Eꞌe madaḡaꞌe Bana Madaḡa ruhibeꞌeteꞌe madaḡa, ebu irarirotene Iḡine Modiroteꞌe Muiḡa zamaḡano Bana Madaḡa boro reiro. Iuda azaḡaniꞌa Bana Madaḡano rune ahiꞌa satauro rana modoga mene uratiro ꞌahine, rune azaḡa odaze vahegadu ahirize satauronoꞌo mae vaḡinoga veize Pilato uminiro. ");
INSERT INTO ksj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Eꞌanoꞌo uti azaḡaniꞌa onamadu Iesu teite satauroniroteꞌe vazeḡa ibiꞌa odaḡa vahegiro, ebu vaze ꞌahoga odaḡa vahegiro. ");
INSERT INTO ksj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Rehano ze Iesu vaḡe onamirotene, ani amahi rudanoga horoniro, eꞌanoꞌo odaḡa mene vahegiro. ");
INSERT INTO ksj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Rehano uti vazeḡa ꞌahoganiꞌa garaḡota hina rebeḡano ḡounadu ru zu vuꞌa zogone sore buaro. ");
INSERT INTO ksj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Aꞌe eꞌeguḡa horoniroteꞌe vazeḡaniꞌa rae fureniroteꞌe ḡoeꞌa. Aniꞌa rae fureniroteꞌe ḡoeꞌaꞌe huga. Ani aneꞌa ḡoere huga ziꞌetaꞌaꞌe edereꞌohe, ebu zae zuni mae ḡihinifine rae fureneꞌohe.) ");
INSERT INTO ksj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ꞌAhiguḡaniꞌa Buka Zaḡoḡano mirihiroteꞌeꞌa hudanoga veize fureraro, “Isiga tiba zuni mene vahegaꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ebu Buka Zaḡoḡano ꞌahige rae reiro, “Zeḡeꞌa ḡouniroteꞌe vazeḡaꞌe zeḡeꞌa ḡianiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Eꞌe enogano Arimate vazeḡa, Iosefaꞌa Pilato vaḡe onamadu Iesu ahiri satauronoꞌo mae bunoga veize uminiro. Aniꞌe Iesu tahiꞌa ꞌahoga, rehano eꞌe moneo vaze ꞌahoga mene ihoniro, mazaḡa aniꞌe Iuda azaḡa boroboro rihoziro. Pilatoꞌa, “Idaḡa,” rae reirotene, ani onamadu Iesu ahiri mae onamiro. ");
INSERT INTO ksj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemoꞌe ibite ohere Iesu vaḡe onamiroteꞌe vazeḡa. Ani zuni Iosefa teite onamiro. Aniꞌe murava hohoḡa aloe teite mirunadu odohe ariro. Aꞌe 34 kilo heuḡa. ");
INSERT INTO ksj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ebu Iuda azaḡa rune gureꞌeteꞌe ibiḡano, ze Iesu ahiri madu miruniroteꞌe ḡauḡaꞌe dabua manoḡa kuiḡa teite ꞌumiro. ");
INSERT INTO ksj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Iesu satauroniroteꞌe habaꞌano kaka mebaḡa ꞌahoga eꞌe, ebu eꞌea vatava iduḡa ꞌahoga eꞌe. Aꞌe rune vazeḡani ꞌahoga ꞌizema tiroteꞌe iduḡa iziga. ");
INSERT INTO ksj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Eꞌe madaḡanoꞌe Iuda azaḡaniꞌa Bana Madaḡa veize ruhibeꞌeteꞌe madaḡa ebu idu aꞌe zeḡe uhiḡano ꞌahine, ze Iesu ahiriꞌe eꞌe zamaḡano tiro. ");
INSERT INTO ksj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Fura oherebau uzeuze ꞌize uzaboḡano, Magadala roḡaeḡa Mariaꞌa idu onamiro ebu idu ꞌuiroteꞌe hadiḡa boro kiune vaḡinoga horoniro. ");
INSERT INTO ksj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Eꞌanoꞌo aneꞌa Simona Petero zu Iesu zamarone tahiꞌaḡa vaḡe dure onamadu ziro, “Vaze ꞌahoganiꞌa Zuhiꞌa Boro ahiri iduonoꞌo mae vaḡineha. Ze ani noꞌe habaꞌano teataꞌaꞌe eme aḡuꞌa!” ");
INSERT INTO ksj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ebu Petero zu Iesu zamarone tahiꞌaḡaniꞌa iḡunadu idu habaꞌa uꞌa onamiro. ");
INSERT INTO ksj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Anianine dure onamirotene, tahiꞌa eꞌeꞌa ḡihau duradu Petero vitine iduo ibite feuriro. ");
INSERT INTO ksj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ani ḡuḡuradu idu zamaḡa ḡianirotene, Iesu ꞌumiroteꞌe dabuaḡa kuiḡa daꞌo deꞌea radoga horoniro, rehano aniꞌe mene diuḡiro. ");
INSERT INTO ksj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simona Petero zuni ani hegote feuri ariro. Ani idu zamaḡa diuḡirotene, Iesu ahiri ꞌumiroteꞌe dabuaḡa kuiḡaꞌe deꞌea radoga horoniro, ");
INSERT INTO ksj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ebu Iesu vadiga ꞌumiroteꞌe dabuaḡa horoniro. Rehano vadiga dabuaḡaꞌe ḡuadu ahiri ꞌumiroteꞌe dabuaḡa kuiḡanonoꞌo avo tiro. ");
INSERT INTO ksj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ebu ibite iduo feuriroteꞌe tahiꞌaḡaniꞌa diuḡiro. Ane zuni horonadu Maria ḡoere mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Rehano ze Buka Zaḡoḡano Iesuꞌa rune azaḡa boꞌaḡano bare iḡuniꞌuma rae reiroteꞌe ꞌize mene zamariro. ");
INSERT INTO ksj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ebu Iesu tahiꞌa aheuꞌa baradu neze onamiro. ");
INSERT INTO ksj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Rehano Mariaꞌa idu enogano edanadu niau radiro. Aniꞌa niauꞌenaꞌa, idu zamaḡa dire ḡianiro. ");
INSERT INTO ksj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ebu dabua ꞌuruḡa vidaroteꞌe tuḡure viga aheu horoziro. Ze Iesu ahiri bazune tiroteꞌe habaꞌano ehore radiunu. Tuḡure viga ꞌahogaꞌe vadiga ḡoha ebu ꞌahogaꞌe odaḡa ḡuzuo radiunu. ");
INSERT INTO ksj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ze Maria ḡadiniro, “Roḡae, ḡa nougadu niauꞌohe?” Aniꞌa naenaeziro, “Vazeꞌa eḡe Zuhiꞌa Boro mae vaḡineha. Ze nouma teataꞌaꞌe e aḡuꞌa.” ");
INSERT INTO ksj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ebu Mariaꞌa tehirotene, Iesuꞌa edau radoga horoniro, rehano aꞌe Iesu rae mene ederiro. ");
INSERT INTO ksj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Iesuꞌa ḡadiniro, “Roḡae, ḡa nougadu niauꞌohe? Ḡa iniu vaḡeꞌohe?” Mariaꞌa aniꞌe kaka mebaḡa ḡianeꞌeteꞌe vazeḡa rae zamaradu niro, “Vaze boro, ḡaꞌa ani ahiri mae onameha roꞌidene, nouma teateꞌe ehoꞌi, ꞌougine eḡeꞌa meꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iesuꞌa niro, “Maria.” Mariaꞌa tehadu Heberu ḡoeꞌano niro, “Raboni!” (Eꞌe ḡoeꞌa hugaꞌe Ihore vazeḡa.) ");
INSERT INTO ksj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Iesuꞌa niro, “Ago obohoꞌi, mazaḡa e ꞌize Mama vaḡe mene iteha. Ḡa eḡe tahiꞌatahiꞌa vaḡe onamadu ꞌahige ihozoꞌi, 'Eꞌe Mama vaḡe itiꞌuma. Aniꞌe eḡe Mama zuni zae Moze, eḡe Badiꞌa zuni zae Badiꞌa.'” ");
INSERT INTO ksj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Eꞌanoꞌo Magadala roḡaeḡa Mariaꞌa Iesu tahiꞌatahiꞌa vaḡe onamadu ihoziro, “E Zuhiꞌa Boro horoneha!” Ebu ani Iesuꞌa niroteꞌe ḡoeꞌa ziro. ");
INSERT INTO ksj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Eꞌe furaḡa ḡoravaḡano Iesu tahiꞌa niduꞌa nuꞌorarotene, ze ne ibihetaḡa niduꞌa hararo, mazaḡa Iuda azaḡa rihoziro. Eꞌe madaḡano Iesuꞌa diuḡi ariro ebu zeḡe boꞌaḡano edanadu ziro, “Zama roḡeḡaꞌe zae teite radoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Aneꞌa ḡoere eꞌe ziroteꞌe enogano ꞌevoꞌa zu rebeḡa ihoziro. Ebu ane tahiꞌatahiꞌaꞌa Zuhiꞌa Boro horonadu ze matuꞌe rudaro. ");
INSERT INTO ksj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ebu Iesuꞌa bare ziro, “Zama roḡeḡa zae teite radiuꞌenoꞌi. Mamaꞌa eḡe tuḡuhiroteꞌe teige, e za tuḡuzeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ebu Iesuꞌa zeḡe rana irine hodadu ziro, “Vine Zaḡoḡa moꞌi. ");
INSERT INTO ksj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Zaꞌa vaze ꞌahoga haḡai sauꞌa rae modine, Badiꞌaꞌa ane haḡai sauꞌa rae modiꞌuma. U zaꞌa vaze ꞌahoga haḡai sauꞌa mene rae modine, Badiꞌaꞌa ane haḡai sauꞌa mene rae modiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Iesu tahiꞌa gaubanana aheu fare boꞌaḡano tahiꞌa ꞌahogaꞌe Tomasi, niḡa ꞌahogaꞌe Atoꞌa. Aniꞌe Iesuꞌa ane tahiꞌatahiꞌa vaḡe arirotene, zeḡe teite mene radiro. ");
INSERT INTO ksj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Eꞌanoꞌo Iesu tahiꞌatahiꞌaꞌa niro, “Eme Zuhiꞌa Boro horoneha.” Rehano aniꞌa naenaeziro, “E ani ꞌevore ikoko iḡuꞌa horonine, ebu eḡe ꞌevore huduꞌa ane ꞌevore ikoko iḡuꞌano surubine, zu eḡe ꞌevore ane rebe iḡuꞌano surubine, zae ḡoere mae ḡihiniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Fura tiba enogano Iesu tahiꞌatahiꞌaꞌa ne zamaḡano bare radiro, ebu Tomasi zuni zeḡe teite radiro. Zeḡe ne ibihetaꞌe haranoga, rehano Iesuꞌa diuḡadu zeḡe boꞌaḡano edaro ebu ziro, “Zama roḡeḡa zae teite radoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ebu aniꞌa Tomasi niro, “ꞌEvoꞌo huduꞌa ꞌaha teadu ꞌevorehe ḡianoꞌi, ebu ꞌevoꞌo ꞌeinadu rebeheo suruboꞌi. Zamaḡo ago ꞌadaꞌadoꞌi, rehano fioꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasiꞌa naenaeniro, “Eḡe Zuhiꞌa Boro, eḡe Badiꞌa!” ");
INSERT INTO ksj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Iesuꞌa niro, “Ḡa eḡe horoheha ꞌahine, eḡe mazao fieꞌehe? E mene horohadu eḡe mazao fieꞌeteꞌe azaḡaꞌe matuꞌeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iesuꞌa ane tahiꞌatahiꞌa zamao haḡai nu badeḡa nunu haḡairo. Eꞌe niduꞌa buka ꞌahi zamaḡano mene mirihiro. ");
INSERT INTO ksj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Rehano e ꞌahige mirihirotaꞌaꞌe zaeꞌa Iesuꞌe Keriso, Badiꞌa Ubuga rae mae ḡihinifine, ebu ani mazao fiadu ani niḡano ḡabone hidifine raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Eꞌe enogano Iesuꞌa Tiberia duꞌuraḡano ane tahiꞌatahiꞌa mazao bare fureraro. Eꞌe hariḡaꞌe ꞌahiguḡa. ");
INSERT INTO ksj_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simona Petero, Atoa rae huneꞌeteꞌe vazeḡa Tomasi, Galilea habaꞌano Kana neḡa vazeḡa Natanaela, Zebedeo ubuga aheu, ebu Iesu tahiꞌa aheuꞌa deꞌea nuꞌoranadu radiro. ");
INSERT INTO ksj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simona Peteroꞌa ziro, “E reꞌevi onameꞌohe.” Zeḡeꞌa niro, “Emeḡe zuni ḡae teite onamiꞌuma.” Eꞌanoꞌo ze onamadu ḡasio tiriro. Rehano eꞌe oheꞌano ḡozoneni ꞌahoga mene maro. ");
INSERT INTO ksj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Irarirotene, oherebau uzeuze Iesuꞌa hesao edaro, rehano ane tahiꞌatahiꞌaꞌe aꞌe Iesu rae mene ederiro. ");
INSERT INTO ksj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ebu aniꞌa ḡadiziro, “Eḡe vaze, za ḡozoneni ꞌahoga mene manahe?” Zeꞌa naenaeniro, “Mene maneha.” ");
INSERT INTO ksj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ebu Iesuꞌa ziro, “Ḡasize edaꞌe naeo reꞌevaze ꞌeinoꞌi, ꞌougine za ḡozone nu maꞌuma.” Ze reꞌeva ꞌeinirotene, reꞌevaze bare hegogaꞌe mene idararo, mazaḡa reꞌevaꞌe ḡozoneꞌa ufeta iriꞌaviro. ");
INSERT INTO ksj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ebu Iesu zamarone tahiꞌaḡaniꞌa Petero niro, “Aꞌe Zuhiꞌa Boro!” Peteroꞌa dabuaḡa fuhiꞌadu reꞌevinu. Aniꞌa, “Aꞌe Zuhiꞌa Boro,” rae igirotene, raga dabuaḡa bare vidanadu vuo rafate buaro ebu hesa mone ḡemabe onamiro. ");
INSERT INTO ksj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","U tahiꞌa ꞌahogaꞌahogaꞌe ḡozoneꞌa iriꞌaviroteꞌe reꞌevaḡa obone teadu ahaseꞌenaꞌa, ḡasio hesa mone onamiro. Mazaḡa zeꞌe gabaonoꞌo mene faḡa, 90 mita daꞌo. ");
INSERT INTO ksj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ze hesao buarotene, ḡeꞌare rana ḡozone rafohoga zu ꞌuvahu odoga horoniro. ");
INSERT INTO ksj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ebu Iesuꞌa ziro, “Za iziduꞌu manateꞌe ḡozoneḡa nu mae aroꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Eꞌanoꞌo Simona Peteroꞌa ḡasio tiradu ḡozone boroboroꞌa iriꞌaviroteꞌe reꞌevaḡa ahasiro ebu gabao tiro. Ḡozone niduꞌaꞌe 153. Ḡozoneꞌe ḡehaḡa bagaḡa rehano, reꞌevaꞌe mene zigaro. ");
INSERT INTO ksj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iesuꞌa ziro, “Aradu oherebau ogomuḡa anoꞌi.” Rehano zeḡe boꞌaḡano ꞌahoga zuni ani mazao, “Ḡa iniu?” rae mene ḡadine nuriro, mazaḡa ze aniꞌe Zuhiꞌa Boro rae ederiro. ");
INSERT INTO ksj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Iesuꞌa onamadu ꞌuvahu odoga meiro ebu ze ziniro. Ḡozone zu madu ziniro. ");
INSERT INTO ksj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ꞌAdiꞌe Iesuꞌa rune azaḡa boꞌaḡano bare ḡabodiroteꞌe enogano ane tahiꞌatahiꞌa mazao ḡae uḡiduḡa fureraroteꞌe madaḡa reiro. ");
INSERT INTO ksj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ze ogau hauḡirotene, Iesuꞌa Simona Petero ḡadiniro, “Ioane ubuga Simona, ḡa e zamare borofeꞌehe? ꞌAhi duḡuruꞌa e zamare borofeꞌeteꞌe vitizogahe?” Peteroꞌa niro, “Oꞌe, Zuhiꞌa Boro, ḡa eḡeꞌa ḡa zamare borofeꞌetaꞌaꞌe edeḡa.” Iesuꞌa niro, “Eḡe mamoe ubugaubuga ḡubuzoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Iesuꞌa ḡae aheuḡa niro, “Ioane ubuga Simona, ḡa e zamare borofeꞌehe?” Peteroꞌa niro, “Oꞌe, Zuhiꞌa Boro, ḡa eꞌa ḡa zamare borofeꞌetaꞌaꞌe edeḡa.” Iesuꞌa niro, “Eḡe mamoe taufoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Iesuꞌa ḡae uḡiduḡa niro, “Ioane ubuga Simona, ḡa e zamare borofeꞌehe?” Iesuꞌa ḡae uḡiduḡa, “Ḡa e zamare borofeꞌehe?” rae ḡadiniro ꞌahine, Peteroꞌe zamaḡaniꞌa adudanadu niro, “Zuhiꞌa Boro, ḡa ḡau niduꞌa edeḡa. Eḡeꞌa ḡa zamare borofeꞌetaꞌaꞌe ḡa edeḡa.” Iesuꞌa niro, “Eḡe mamoe ḡubuzoꞌi. ");
INSERT INTO ksj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","E hube hune ḡaꞌohe. Ḡaꞌe tahiꞌa iziga madaḡanoꞌe ḡa ḡaeꞌa bare dabuaḡo vidanadu ḡaeꞌa uratiroteꞌe habaꞌa onamido. Rehano ḡa vourine, vazeꞌa ꞌevoꞌo ꞌeinadu dabua vidoḡaniꞌuma ebu ḡaeꞌa mene urateꞌeteꞌe habaꞌa tutuꞌe onamiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Iesuꞌe ꞌahi ḡoeꞌa hina Peteroꞌa nougenouge rudanadu Badiꞌa ni mae ḡihiniteꞌe moneo dehene ihoziro. Ebu Iesuꞌa Petero niro, “Eḡe hegotoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ebu Peteroꞌa tehadu Iesu zamarone tahiꞌaḡaniꞌa anianine hegoteꞌeteꞌe horoniro. Aniꞌe ibite ḡorava ogomu anogano Iesu mazao aroranadu, “Zuhiꞌa Boro, iniuꞌa revoḡaniꞌuma?” rae ḡadiniroteꞌe vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Peteroꞌa ani horonirotene, Iesu ḡadiniro, “Zuhiꞌa Boro, tahiꞌa ꞌadiꞌe nougiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Iesuꞌa naenaeniro, “Aniꞌe izidionoꞌo onamo eḡeꞌa bare ariteꞌe madaḡano ḡabode radoga e uratoꞌidene zuni, ḡa ani moneo ago zamaroꞌi. Ḡaꞌe eḡe hegotoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Eꞌanoꞌo Iesu ḡoere ꞌadiꞌe Iesu hegoteꞌeteꞌe azaḡa boꞌaḡano bororanadu ze tahiꞌa aꞌe mene rudaꞌuma rae reiro. Rehano Iesuꞌa aniꞌe mene rudaꞌuma rae mene niro, rehano ꞌahige daꞌo reiro, “Aniꞌe izidionoꞌo onamo eḡeꞌa bare ariteꞌe madaḡano ḡabode radoga e uratoꞌidene zuni, ḡa ani moneoꞌe ago zamaroꞌi.” ");
INSERT INTO ksj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Eꞌe ꞌahiguḡa horonadu rae fureneꞌeteꞌe ebu mirihiroteꞌe tahiꞌaḡa. Emeḡe niduꞌa edeḡa, eḡeꞌa rae fureneꞌeteꞌe ḡoeꞌaꞌe huga. ");
INSERT INTO ksj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iesuꞌa haḡairoteꞌe haḡaiḡa nunuꞌe ḡehaḡa. Eḡe zamarone, Iesu haḡaiḡa niduꞌa hune mirihine, buka aꞌe ufeta ḡehaḡa reꞌuma, ebu raha ꞌada buka eꞌe niduꞌa titeꞌe habaꞌaꞌe oꞌoꞌa reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Vaze boro Teofilo, e buka ibiꞌa zamaḡano Iesuꞌa gauinuteꞌe zu ihozinuteꞌe niduꞌa moneo mirihiro. ");
INSERT INTO ksj_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ebu Vine Zaḡoḡaonoꞌo aneꞌa ohotiroteꞌe apostolo azaḡa ihoziroteꞌe ḡarugano adure ḡoha mae itiroteꞌe moneo mirihiro. ");
INSERT INTO ksj_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Iesuꞌe aduga hidadu rudaroteꞌe enogano, ani ꞌize ḡaboga raꞌeteꞌe ihozoga veize haḡai nunu furenoziniro. Aniꞌe mada 40 zamaḡano apostolo azaḡa mazao fureraro ebu Badiꞌaꞌa zuhiꞌaziꞌeteꞌe moneo ḡoeriro. ");
INSERT INTO ksj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Iesuꞌa zeḡe teite nuꞌoraroteꞌe madaḡano aneꞌa ḡoere riḡa ziro, “Ierusalema ago modoꞌi, ebu eḡe Mamaꞌa ḡoitoriroteꞌe ḡahunoneḡa guhine radoꞌi. Aꞌe zaeꞌa eḡe mazaonoꞌo igiroteꞌe ḡoitore ḡoeꞌa. ");
INSERT INTO ksj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ioaneꞌe vu hina babatisoziro, rehano zaꞌe mada nu enogano Vine Zaḡoḡa hina babatiso meꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Mada ꞌahogano apostolo azaḡaniꞌa nuꞌoru tiburarotene, Iesu ḡadiniro, “Zuhiꞌa Boro, izidiꞌe ḡaeꞌa Isaraela bare madu Isaraela azaḡa baronoziniteꞌe madaḡahe?” ");
INSERT INTO ksj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Iesuꞌa ziro, “Eꞌe madaḡaꞌe Mamaꞌa ane gigiꞌaḡa hina ohoniro ꞌahine, za ederogaꞌe mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Rehano Vine Zaḡoḡaniꞌa zae vaḡe ovaiteꞌe madaḡano zaꞌe gigiꞌaḡa meꞌuma, ebu Ierusalemao zu Iudea habaꞌa niduꞌa zamaḡano ebu Samaria habaꞌano onamo haba ḡonagano eḡe hari rae fureniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Aneꞌa ꞌouge reiroteꞌe enogano, ani zeḡe ubumao adure ḡoha mae ḡihine itiro, ebu ḡozeꞌa ani ꞌuadu ze ani mene horoniro. ");
INSERT INTO ksj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Iesuꞌe adure ḡoha mae iteꞌeteꞌea, ze adure ḡohani gagau ḡiane radirotene, tabara dabua ꞌuruḡa vidaroteꞌe tuḡure viga aheuꞌa zeḡe uhiḡano edaro. ");
INSERT INTO ksj_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ebu tuḡure viga aheuꞌa ziro, “Galilea azaḡa, za nougadu ꞌahao edauꞌenaꞌa, adure ḡohani ḡianeꞌohe? Iesuꞌe zae mazaonoꞌo adure ḡohani mae ḡihine iteha. Ani ꞌouge adure ḡoha mae itateꞌe zaeꞌa horonateꞌe teige, vesuꞌu bare ꞌouge ovamiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ebu hena apostolo azaḡaꞌe Olivi Maḡa rae huniroteꞌe habaꞌanonoꞌo Ierusalema bare onamiro. Eꞌe faḡaꞌe Ierusalemaonoꞌo tiba kilomita heuḡa radu Bana Madaḡano ragavogaꞌe idararo. ");
INSERT INTO ksj_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ze Ierusalemao feurirotene, zeḡeꞌa radiuꞌeteꞌe hitaga neḡa diuḡi itiro. Zeꞌe Petero, Ioane, Iakobo, Anderea, Filipi, Tomasi, Batolomeo, Mataio, Alefeo ubuga Iakobo, Zelota vazeḡa Simona ebu Iakobo ubuga Iuda. ");
INSERT INTO ksj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Zeḡe niduꞌaꞌe roḡae nu ebu Iesu viꞌa Maria zu Iesu negoḡa duḡuru teite zamaze tibunadu iḡaiḡa kurau nuꞌoraunu. ");
INSERT INTO ksj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Eꞌe madaḡano fieꞌeteꞌe azaḡaniꞌa nuꞌoraro. Zeḡe niduꞌaꞌe 120 heuḡa. Zeḡe boꞌaḡano Peteroꞌa iḡune edaro. ");
INSERT INTO ksj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ebu aneꞌa ḡoeriro, “Nego nabudi, ibite Vine Zaḡoḡaniꞌa Davidaonoꞌo Iuda moneo Buka Zaḡoḡano mirihiroteꞌeꞌa hudaro. Aꞌe Iudaꞌa Iesu obone tiroteꞌe azaḡa ibitoziroteꞌe hariḡa. ");
INSERT INTO ksj_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Iudaꞌe emeḡe boꞌaḡano tahiꞌaḡa ꞌahoga reiro, ebu emeḡe teite gau tiba haḡainu. ");
INSERT INTO ksj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Rehano ani haḡai sauꞌa haḡadu meiroteꞌe hadiḡa hina haba ꞌahoga hoitiro. Eꞌea vadini ibine uite ovoiro, ebu ahiꞌaniꞌa fuꞌuradu isiḡaniꞌa ḡudau rururaro. ");
INSERT INTO ksj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ꞌAhi hariḡaꞌe Ierusalema azaḡa niduꞌa igiro, eꞌanoꞌo ze zeḡe ḡoereo eꞌe habaꞌaꞌe Akeledama rae huniro. Eꞌe hugaꞌe Ru Habaꞌa. ");
INSERT INTO ksj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Salamo zamaḡano ꞌahige rae mirihiro, 'Ane habaꞌe ḡahuturanoꞌi. Vazeni ꞌahoga zuni eꞌea mene radiꞌuma,' ebu 'Vaze ꞌahoganiꞌa aniꞌa ibitohauꞌeteꞌe gauḡa iḡuꞌa meꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Eꞌanoꞌo Zuhiꞌa Boro Iesuꞌa emeḡe teite ragavinuteꞌe madaḡa niduꞌa emeḡe teite raudoteꞌe azaḡa boꞌaḡano vaze ꞌahoga ohoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Aniꞌe Ioaneꞌa babatisoziroteꞌe madaḡanonoꞌo onamo Iesuꞌe emeḡe mazaonoꞌo mae adure ḡoha itiroteꞌe madaḡano, emeḡe teite radiunuteꞌe azaḡa boꞌaḡano ohoniꞌuma. Aniꞌe emeḡe teite Iesuꞌa bare ḡabodiroteꞌe rae fureneꞌeteꞌe vazeḡa reꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Eꞌanoꞌo ze vaze aheu meiro. ꞌAhogaꞌe Barasaba ga Iusito rae huneꞌeteꞌe vazeḡa Iosefa, ebu ꞌahogaꞌe Matia. ");
INSERT INTO ksj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ebu ze ꞌahige kuraro, “Zuhiꞌa Boro, ḡaꞌe vaze niduꞌa zama edeḡa. Ḡa vaze aheu ꞌahi boꞌaḡano iniu ohoteha? ");
INSERT INTO ksj_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Iudaꞌa modiroteꞌe apostolo gauḡa iḡuꞌa meiteꞌe vazeḡa ihofoꞌi. Iudaꞌe eꞌe gauḡa modadu aneꞌa raditeꞌe habaꞌa onamiro.” ");
INSERT INTO ksj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ebu ze eꞌe veize kaḡusi arahoḡa arahirotene, Matia meiro. ꞌOugadu Matiaꞌe apostolo azaḡa gaubanana tiba fare teite apostolo vazeḡa reiro. ");
INSERT INTO ksj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentikosi Muiḡa meirotene, fieꞌeteꞌe azaḡa niduꞌa haba tibano nuꞌoraro. ");
INSERT INTO ksj_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Eꞌe zamaḡano zavara boroꞌa areꞌeteꞌe teige, guguḡa boroꞌa adureonoꞌo tabara gudau ovairo. Eꞌe guguḡaniꞌa zeꞌa nuꞌoraroteꞌe neḡa iriꞌavoniro. ");
INSERT INTO ksj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ebu ire rogaꞌa duhuruꞌeteꞌe heuḡaniꞌa mazane teige rovotadu vaze tibatiba ranao duhuranoga horoniro. ");
INSERT INTO ksj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ebu Vine Zaḡoḡaniꞌa eꞌea radiunuteꞌe azaḡa niduꞌa iriꞌavoziro ebu Vine Zaḡoḡaniꞌa ibitozeadu ḡoere nunuo ḡoeriro. ");
INSERT INTO ksj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Eꞌe madaḡanoꞌe haba ꞌahogaꞌahogano radiuꞌeteꞌe Iuda azaḡaniꞌa Ierusalema aradu radiunu. Zeꞌe Badiꞌa gubaneꞌeteꞌe azaḡa. ");
INSERT INTO ksj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Fieꞌeteꞌe azaḡaniꞌa harairotene, vaze ḡuḡuvaḡaniꞌa isau ariro. Ebu zamazeꞌa ꞌadaꞌadaziro, mazaḡa vaze ḡuḡuvaḡaꞌe zeḡezeḡe ḡoereo fieꞌeteꞌe azaḡaniꞌa ḡoeroga igiro. ");
INSERT INTO ksj_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ebu ze ufeta zaguzaganadu ꞌahige rae reiro, “Ḡiazoꞌi! Izidi ḡoereꞌeteꞌe azaḡaꞌe Galilea azaḡa, oꞌehe? ");
INSERT INTO ksj_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Rehano eme zeꞌa emeḡe tibatiba ḡoereo ḡoereꞌeteꞌe igiꞌohe. ꞌAhiguḡaniꞌa nougenouge fureraneha? ");
INSERT INTO ksj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Emeḡe boꞌaḡano nuꞌe Patia azaḡa, Media azaḡa, zu Elama azaḡa. Ebu nuꞌe Mesopotamia, Iudea, Kapadokia, Ponito, Asia, ");
INSERT INTO ksj_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ferigia, Pamufulia, zu Izipi habaꞌano radiuꞌeteꞌe azaḡa, ebu Kurene uhiḡano Libia habaꞌano radiuꞌeteꞌe azaḡa. Ebu nuꞌe Ierusalema ḡianihi radu ariroteꞌe Roma azaḡa. ");
INSERT INTO ksj_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ebu nuꞌe Iuda azaḡa, zu ḡihuradu Iuda azaḡa teige Badiꞌa mazao fieꞌeteꞌe azaḡa, ebu Kerete ꞌumuḡa azaḡa, zu Arabia habaꞌa azaḡa. Eme zeḡeꞌa Badiꞌa haḡai gigiꞌaḡa emeḡe tibatiba ḡoereo raꞌeteꞌe igiꞌohe!” ");
INSERT INTO ksj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ze zaguzagauꞌenaꞌa ebu zamazeꞌa ꞌadaꞌadazeꞌenaꞌa, ḡadimutitiro, “ꞌAhi hugaꞌe nagini?” ");
INSERT INTO ksj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Rehano vaze nuꞌe ḡirihoziro, “Ze vaini vuḡa ufeta gageha.” ");
INSERT INTO ksj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ebu Peteroꞌa apostolo azaḡa gaubanana tiba fare teite iḡune edanadu vaze ḡuḡuvaḡa mazao agoḡa borofadu haramiro, “Iuda azaḡa zu Ierusalemao radiuꞌeteꞌe azaḡa niduꞌa, e haḡai ꞌadaꞌa nougenouge fureranateꞌe ihozihi. Eḡe ḡoere faine abitoꞌi. ");
INSERT INTO ksj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Zaꞌe ꞌahi duḡuruꞌe vaini vuḡa gageha rae zamareꞌe gaogi. ꞌAhi ꞌize oherebau mada fuꞌo ḡazaḡa fare, eꞌanoꞌo ze mene gageha. ");
INSERT INTO ksj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Badiꞌaꞌa peroveta vazeḡa Ioelaonoꞌo rae fureniroteꞌe ḡoeꞌaniꞌa hudaneha, ");
INSERT INTO ksj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","'Badiꞌaꞌa ꞌahige raꞌohe: Mada ḡonagano eḡeꞌa vaze niduꞌa rana eḡe Vine ovoe beꞌuniꞌuma. Ubudeze zu aboezeꞌe eḡe ḡoere rae fureniꞌuma, zae tahiꞌa izigaizigaꞌe ahiri raꞌaga iḡunaḡa horoniꞌuma, vaze vouḡavouḡaꞌe iḡunaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Eꞌe madaḡano eḡe tuḡure azaḡa ohoze zu tuḡure azaḡa roḡae rana eḡeꞌa eḡe Vine ovoe beꞌuniꞌuma, ebu zeḡe zuni eḡe ḡoere rae fureniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ebu eḡeꞌa hitanaoꞌe zaguzagatiteꞌe haḡaiḡa adureo fureniꞌuma, ebu ꞌuꞌuḡanoꞌe haḡai nu badeḡa rahao fureniꞌuma. Ru, ire roga ebu ḡisi baruḡa fureniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Zuhiꞌa Boro ḡihiꞌa hune ebu niḡa mae ḡihineꞌeteꞌe madaḡaniꞌa ꞌizema arogano, madaꞌa ḡihuradu uzaboraꞌuma, ebu batoꞌe ḡihuradu ru teige kanaraꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ebu iniu Zuhiꞌa Boro mazao ḡaniḡanauꞌeteꞌe vazeḡaꞌe ḡabone hidiꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Isaraela azaḡa, ḡoere ꞌahi egoꞌi. Za edeḡa, Nazareta vazeḡa Iesuꞌe Badiꞌaꞌa tuḡunadu gigiꞌa haḡaiḡa, zaguzagatiteꞌe haḡaiḡa, zu haḡai nu badeḡa ḡehaḡa zae boꞌaḡano haḡainu. Badiꞌaꞌa eꞌeguḡa haḡaiḡa Iesuonoꞌo haḡadu Iesuꞌe aniꞌa tuḡuniroteꞌe vazeḡa rae dehene fureniro. ");
INSERT INTO ksj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Iesuꞌe Badiꞌaꞌa amahi toganadu irina ederiroteꞌe idunaḡano zae ꞌevoreo riꞌiniro. Ebu zaꞌe Badiꞌa goro ḡoeꞌa aḡuꞌa azaḡa ꞌevoreo ani riꞌinadu satauro rana ikokoni runediro. ");
INSERT INTO ksj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Rehano Badiꞌaꞌe ani rune zamaḡano aduga hidiroteꞌeanoꞌo bohane bunadu bare ḡaboniro, mazaḡa rune gigiꞌaḡaꞌe Iesu obone touga mene idararo. ");
INSERT INTO ksj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Davidaꞌe Iesu moneo ꞌahige rae reiro, 'E iḡaiḡa eḡe zamao Zuhiꞌa Boro horoninu. Aniꞌe eḡe edaꞌe moneo radiuꞌe ꞌahine, ḡau ꞌahoganiꞌa e mene hagahiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Eꞌanoꞌo zamaheꞌa matuꞌeꞌohe, zu hebehe hina Badiꞌa niguneꞌenaꞌa, matuꞌeꞌohe. E ahirihe zuni runeonoꞌo bare ḡaboditeꞌe mae ḡihineꞌenaꞌa, guhine radiuꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Mazaḡa Zuhiꞌa Boroꞌa vinehe rune habaꞌano mene modiꞌuma, ebu Zuhiꞌa Boro veize zamaḡa niduꞌa hina gaueꞌeteꞌe vazeḡa ahiꞌaniꞌa ruhuranoga veize mene mode tauḡiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Zuhiꞌa Boroꞌa ḡabone ibiḡa ihohiro, ebu Zuhiꞌa Boro ubumao matuꞌu hina iriꞌavohiꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Nego nabudi, eḡeꞌa hube hune ziꞌohe, vouḡafe Davidaꞌe rudanadu guriro ebu ani iduꞌe izidi radiuꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Rehano aniꞌe peroveta vazeḡa ꞌahine, Badiꞌaꞌa ane mazao ꞌahige ḡoeꞌa rinede tirotaꞌaꞌe ederiro, 'Davida mariga ꞌahoganiꞌa ane iḡuri madu kini reꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Davidaꞌe zama moneo naginiꞌa fureratiteꞌe irina horonadu Kerisoꞌa bare ḡaboditeꞌe moneo ꞌahige rae fureniro, 'Kerisoꞌe rune habaꞌano mene modiꞌuma, zu ahiꞌaꞌe mene ruhuraꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ebu Iesu ꞌahiꞌe Badiꞌaꞌa bare ḡaboniro. Emeḡe niduꞌa eꞌe horonadu rae fureneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ebu aniꞌe mae ḡihinadu Badiꞌa edaꞌe moneo ohoniro. Ebu aniꞌe Moganiꞌa ḡoitoriroteꞌe Vine Zaḡoḡa madu emeḡe mazao ovoe beꞌuniro. Zaꞌe izidi ꞌada eꞌe horoneꞌohe zu igiꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","U Davidaꞌe adure ḡoha mene itiro, rehano ani ꞌahige rae reiro, 'Badiꞌaꞌa eḡe Zuhiꞌa Boro niro, “Eḡe edaꞌe moneo ehoroꞌi, ");
INSERT INTO ksj_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","onamo eḡeꞌa agireḡo madu odaḡo ꞌuꞌuḡano raharahaziꞌuma.”' ");
INSERT INTO ksj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Eꞌanoꞌo Isaraela azaḡa niduꞌa faine ederoꞌi. Zaeꞌa satauroniroteꞌe vazeḡa, Iesuꞌe Badiꞌaꞌa Zuhiꞌa Boro zu Keriso rae ohoniro.” ");
INSERT INTO ksj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ze eꞌe igirotene, zamaze tuḡano babaharo, ebu Petero zu apostolo azaḡa ḡadiziro, “Negofe duḡuru, eme nougiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peteroꞌa naenaeziro, “Zae niduꞌa, zamaze ḡihunoꞌi, ebu Iesu Keriso niḡano babatiso moꞌi. ꞌOugine, Badiꞌaꞌa zae haḡai sauꞌa rae modiꞌuma ebu Badiꞌa ḡahunoneḡa, Vine Zaḡoḡa ziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ḡoitore ḡoeꞌa ꞌadiꞌe Zuhiꞌa Boro emeḡe Badiꞌaꞌa huziroteꞌe azaḡa niduꞌa veize tiro. Aꞌe zae, ubudeze zu haba faḡafaḡa azaḡa niduꞌa raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ebu Peteroꞌa ḡoere nunu rae fureniro ebu iraduguziro, “Haḡai veꞌoḡa azaḡa ꞌahi mazaonoꞌo vaḡinadu ḡabone moꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Eꞌanoꞌo ane haramo mae ḡihiniroteꞌe azaḡaꞌe babatiso meiro. Eꞌe madaḡano vaze niduꞌa 3,000 heuḡaꞌe babatiso madu fieꞌeteꞌe azaḡa moneo ragate mae zouziro. ");
INSERT INTO ksj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ze apostolo azaḡa ihoreḡa zamaze niduꞌa hina abitoharo, ebu unihe tiburanoga, tiburu oganoga, zu kuranoga veize inariro. ");
INSERT INTO ksj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ebu apostolo azaḡaniꞌa gigiꞌa haḡaiḡa zu haḡai nu badeḡa ḡehaḡa haḡainuteꞌe uꞌano, vaze niduꞌa rihau rudaro. ");
INSERT INTO ksj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Fieꞌeteꞌe azaḡa niduꞌa tibano nuꞌoru radiunu ebu ḡauze niduꞌa ḡahugotitinu. ");
INSERT INTO ksj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ebu toheze zu ḡauze seronadu iniu hadizeꞌa ferezinuteꞌe azaḡa niduꞌa zininu. ");
INSERT INTO ksj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ebu ze mada niduꞌa kuru neḡano nuꞌoranadu kuraunu. Ebu aneane neo nuꞌoranadu matuꞌuzeta zu zamaze manoḡano ogau tiburaunu, ");
INSERT INTO ksj_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","zu Badiꞌa niguninu. ꞌOugadu vaze niduꞌa ze niguzinu. Ebu Zuhiꞌa Boroꞌa mada niduꞌa ḡabone hideꞌeteꞌe azaḡa ragate borofe tuḡuzadu fieꞌeteꞌe azaḡaniꞌa bororaro. ");
INSERT INTO ksj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Mada ꞌahogano ḡorava mone mada uḡidu zamaḡano, Petero zu Ioaneꞌa kuru madaḡano kuru neḡa itiro. ");
INSERT INTO ksj_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ebu Iraḡa Manoḡa rae huneꞌeteꞌe ibihetaḡa ꞌahoga genaḡano odaḡa sauꞌa vazeḡa ꞌahoganiꞌa ehore radiro. Aniꞌe ꞌouge fureraro ebu vazeꞌa ani mada niduꞌa herate onamadu eꞌe ibihetaḡa genaḡano ohoninu, ebu ani kuru neḡa diuḡeꞌeteꞌe azaḡa mazao hadi umidinu. ");
INSERT INTO ksj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ani Petero zu Ioaneꞌa kuru neḡa diuḡihi raꞌenogano horozadu hadi umiziro. ");
INSERT INTO ksj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Rehano Petero zu Ioaneꞌa ḡiane runadu Peteroꞌa niro, “Eme ḡiafoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Odaḡa sauꞌa vazeḡaꞌe ḡau ꞌahoga hidiꞌuma rae zamareꞌenaꞌa, ḡiaziro. ");
INSERT INTO ksj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Rehano Peteroꞌa niro, “E hadihe oꞌoꞌa rehano, eḡe mazao radiuꞌeteꞌe ḡauḡa ḡaniꞌuma. Eḡeꞌa ḡaꞌohe, Nazareta vazeḡa Iesu Keriso niḡano iḡunadu onamoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ebu Peteroꞌa ane edaꞌe ꞌevoꞌa mae ḡihinirotene, odaḡa zu kekeḡaniꞌa tabara inariro. ");
INSERT INTO ksj_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ebu ani rafate iḡune edaro zu oname onairo. Ebu ani rafate onameꞌenaꞌa zu Badiꞌa niguneꞌenaꞌa, zeḡe teite kuru neḡa diuḡiro. ");
INSERT INTO ksj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Vaze niduꞌa aniꞌa Badiꞌa niguneꞌenaꞌa, oname onaeꞌeteꞌe horoniro. ");
INSERT INTO ksj_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ebu ze aniꞌe kuru neḡa ibihetaḡa, Iraḡa Manoḡa genaḡano iḡaiḡa ehoradu vaze mazao hadi umidinuteꞌe vazeḡa rae ederiro. Ebu ane mazao naginiꞌa fureraroteꞌe uꞌano, ze zaguzagau rudaro. ");
INSERT INTO ksj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Odaḡa manoriroteꞌe vazeḡaniꞌa Petero zu Ioane hegote ragaveꞌeteꞌe zamaḡano, vaze niduꞌa zaguzaganadu kuru neḡa habaꞌano Solomona Ibi Zauhaḡano zeḡe vaḡe isau dure ariro. ");
INSERT INTO ksj_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Peteroꞌa vaze ḡehaḡaniꞌa aroga horozadu ziro, “Isaraela azaḡa, za nougaꞌahi zaguzagauꞌohe? Ebu nougaꞌahi ḡiaḡiafeꞌohe? Za emeꞌa gigiꞌafe hina vaze ꞌahi faineha ga eme hube hune Badiꞌa gubaneꞌeteꞌe uꞌano ani faineha rae zamareꞌehe? ");
INSERT INTO ksj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Aberahamo, Isako, Iakobo zu vouḡafeꞌa kuranohaunuteꞌe Badiꞌaḡaniꞌa ane tuḡure vazeḡa Iesu mae ḡihiniro. Rehano zaꞌe ani Pilato ꞌevoreo riꞌiniro. Ebu Pilatoꞌa ani tuḡune bunihi rae reirotene, zaeꞌa Pilato zamao ani hezahoharo. ");
INSERT INTO ksj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Zaꞌe Vaze Zaḡoḡa zu Duduḡa hezahoharo, u vaze runediroteꞌe vazeḡa ꞌahoga mae bunoga umidiro. ");
INSERT INTO ksj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ꞌOugadu zaꞌe ḡaboneziniꞌeteꞌe Zuhiꞌaḡa Boro maro. Rehano aniꞌe Badiꞌaꞌa rune azaḡa boꞌaḡano bare ḡaboniro. Eme eꞌe horonadu ꞌahi rae fureneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Iesu mazao fieꞌeteꞌe uꞌano, zaꞌa horoneꞌeteꞌe zu edereꞌeteꞌe vazeḡa ꞌahi faineha. Iesu ni gigiꞌaḡa zu ane mazao fieꞌeteꞌe uꞌano, vaze ꞌahaꞌa manore huneha. Zae niduꞌa ꞌahi horoneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Nego nabudi, e edeḡa, zae ibitoziꞌeteꞌe azaḡa teige zae zuni aḡuꞌa radu Iesu maro. ");
INSERT INTO ksj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Rehano Kerisoꞌa aduga hiditeꞌe moneo Badiꞌaꞌa peroveta azaḡa niduꞌaonoꞌo amahi rae fureniroteꞌeꞌa ꞌahige hudaro. ");
INSERT INTO ksj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Eꞌanoꞌo zaꞌe ḡihuradu Badiꞌa vaḡe bare aroꞌi. ꞌOugine aneꞌa haḡaize sauꞌa vuzuꞌe modiꞌuma, ");
INSERT INTO ksj_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ebu Zuhiꞌa Boroꞌa vineze izifiteꞌe madaḡaniꞌa ariꞌuma, ebu zae veize Badiꞌaꞌa amahi ohoniroteꞌe vazeḡa, Keriso tuḡuniꞌuma. Aniꞌe Iesu. ");
INSERT INTO ksj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Rehano ibite madaḡano Badiꞌaꞌa peroveta zaḡoḡa azaḡaonoꞌo rae fureniroteꞌe teige, Iesuꞌe adureo ꞌize radiꞌuma, onamo ḡau niduꞌa izifiteꞌe madaḡaniꞌa ariꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moseꞌa ꞌahige rae reiro, 'Zuhiꞌa Boro zae Badiꞌaꞌa zae ḡoere ḡumu azaḡa boꞌaḡano peroveta vazeḡa ꞌahoga eḡe heuḡa zae veize ohoniꞌuma. Aniꞌa nagini ziteꞌe ḡoeꞌa niduꞌa egohanoꞌi. ");
INSERT INTO ksj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Iniu ani ḡoere mene egohauꞌeteꞌe vazeḡaꞌe Badiꞌa mone azaḡa mazaonoꞌo mae vaḡizadu ruiziꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ebu Samuela zu ane ḡaruna ariroteꞌe peroveta azaḡa niduꞌa zuni izidi fureruꞌeteꞌe ḡauḡa moneo irina rae fureniro. ");
INSERT INTO ksj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Zaꞌe peroveta azaḡa mariga, zu Badiꞌaꞌa zae vouḡa teite tiroteꞌe ḡoitoreḡa ḡoeꞌa meiroteꞌe azaḡa. Mazaḡa Badiꞌaꞌa Aberahamo niro, 'Marigo mazaonoꞌo habaꞌahabaꞌa azaḡa niduꞌa manohuga hidiꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Badiꞌaꞌa ane tuḡure vazeḡa ohonadu zae mazao ibite tuḡuniro. Aꞌe, aniꞌa zae tibatiba sauꞌa ibiḡanonoꞌo mae vaḡizadu manohuga zinifine raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petero zu Ioaneꞌa ꞌize vaze ḡehaḡa ḡorezeꞌeteꞌea, dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa, kuru neḡa uti vazeḡa ḡihiꞌaḡa zu Sadukea azaḡaniꞌa zeḡe uꞌa ariro. ");
INSERT INTO ksj_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Zeꞌe apostolo azaḡa aheu mazao maḡune rudaro, mazaḡa apostolo azaḡaniꞌa vaze ihozeꞌenaꞌa, Iesuꞌa bare ḡabodiroteꞌe teige, vaze zuni bare ḡabodiꞌuma rae haraminu. ");
INSERT INTO ksj_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Eꞌe uꞌano, ze Petero zu Ioane oboze tiro. Ebu mada ꞌai zuburiro ꞌahine, ze ḡuꞌa neḡano ohozadu eꞌea baze irariro. ");
INSERT INTO ksj_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Rehano zeḡe haramo igiroteꞌe azaḡa boꞌaḡano vaze ḡehaḡaniꞌa ḡoereze mae ḡihiniro. Zeḡe boꞌaḡano ohoze niduꞌaꞌe 5,000 heuḡa. ");
INSERT INTO ksj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Irarirotene, Iuda azaḡa ibitoziꞌeteꞌe azaḡa, vaze boroboro zu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡaꞌe Ierusalemao nuꞌoraro. ");
INSERT INTO ksj_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Dibuꞌo vazeḡa ḡihiꞌaḡa Anasi, ebu Kaiafa, Ioane zu Alesana, ebu dibuꞌo vazeḡa ḡihiꞌaḡa nabuga duḡuru niduꞌa nuꞌoraro. ");
INSERT INTO ksj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ze Petero zu Ioaneꞌe zeḡe zamao mae ohozadu ḡadiziro, “Za noꞌe gigiꞌaḡa hina ga iniu niḡano odaḡa sauꞌa vazeḡa ꞌahi faineha?” ");
INSERT INTO ksj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ebu Vine Zaḡoḡaniꞌa Petero iriꞌavonadu Peteroꞌa ziro, “Vazevaze zuhiꞌaziꞌeteꞌe azaḡa zu vaze boroboro, ");
INSERT INTO ksj_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","za emeꞌa odaḡa sauꞌa vazeḡa mazao haḡai manoḡa haḡateꞌe zu nougenouge ani fainateꞌe moneo ḡadimuꞌehe? ");
INSERT INTO ksj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ꞌOugine, zae niduꞌa zu Isaraela azaḡa niduꞌa ꞌahi ederiꞌuma. Vaze ꞌahiꞌe Nazareta vazeḡa Iesu Keriso niḡano manoradu zae zamao edauꞌohe. Iesuꞌe zaeꞌa satauroniro rehano, Badiꞌaꞌa rune azaḡa boꞌaḡano bare ḡaboniroteꞌe vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iesu moneo Buka Zaḡoḡano ꞌahige rae mirihiro, 'Hadi hina ne ogorarotene, zaeꞌa mae modiroteꞌe hadiḡaꞌe, ne duꞌe rinedeꞌeteꞌe hadiḡa reiro.' ");
INSERT INTO ksj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Eꞌanoꞌo Iesu ane daꞌo emeḡe ḡabofeꞌohe. Haba niduꞌa zamaḡano Badiꞌaꞌa emeḡe ḡabofifine tuḡuniroteꞌe vazeḡa ꞌahogaꞌe oꞌoꞌa.” ");
INSERT INTO ksj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nuꞌonuꞌo azaḡaꞌe Petero zu Ioaneꞌa mene rihauꞌenaꞌa, inare ḡoeroga horozirotene zaguzagaro, mazaḡa ze Petero zu Ioaneꞌe edeḡa oꞌoꞌa ebu nize oꞌoꞌa azaḡa rae ederiro. ꞌOugadu ze bare ederiro, vaze aheu ꞌadiꞌe Iesu teite radiunuteꞌe azaḡa. ");
INSERT INTO ksj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Rehano ze odaḡa sauꞌa manoriroteꞌe vazeḡaniꞌa Petero zu Ioane teite edanoga horoniroteꞌe uꞌano, ze ḡoereni ꞌahoga rouga mene idararo. ");
INSERT INTO ksj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Eꞌanoꞌo ze Petero zu Ioaneꞌe nu'onu'o habaꞌanonoꞌo mae buzadu zeḡe daꞌo ḡoꞌaneꞌenaꞌa ḡadimutitiro, ");
INSERT INTO ksj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Eme vaze aheu ꞌahi mazao nougiꞌuma? Zeꞌa gigiꞌa haḡaiḡa haḡataꞌaꞌe Ierusalema azaḡa niduꞌaꞌe edeḡa ebu eme zuni eꞌe oꞌonoga mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Rehano hari ꞌahaꞌa ne azaḡa boꞌaḡano mene bororafine, ꞌahige riḡa ziꞌuma, 'Iesu niḡano vazeni ꞌahoga ago bare ḡorenoꞌi!'” ");
INSERT INTO ksj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ebu hena ze Petero zu Ioane bare huze zouzadu riḡa ziro, “Iesu niḡano ago hune ḡoeroꞌi, zu ago hune ihozoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Rehano Petero zu Ioaneꞌa naenaeziro, “Badiꞌa ubumao noꞌeꞌe duduḡa? Zae ḡoere egoziniꞌuma ga Badiꞌa ḡoere egohaꞌuma? Za zaeꞌa bare ḡadizoꞌi. ");
INSERT INTO ksj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Emeꞌe nagini horoniroteꞌe zu igiroteꞌe moneo rae furene huniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ebu nuꞌonuꞌo ibitohauꞌeteꞌe azaḡaniꞌa bare ḡoere riḡa zeadu tuḡuze buziro. Mazaḡa vaze niduꞌa naginiꞌa fureranateꞌe horonadu Badiꞌa niguniro ꞌahine, apostolo azaḡa adugano tuḡuziteꞌe ibiḡa mene horoniro. ");
INSERT INTO ksj_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Gigiꞌa haḡaiḡano manoriroteꞌe vazeḡa muriḡaꞌe 40 vitinoga. ");
INSERT INTO ksj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Petero zu Ioaneꞌe tuḡuze buzirotene, ze fieꞌeteꞌe azaḡa vaḡe onamiro ebu dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu vaze boroboroꞌa ziroteꞌe ḡoeꞌa niduꞌa meꞌodoziniro. ");
INSERT INTO ksj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ze ḡoere eꞌe igirotene, zamaze tibano teadu agoze borofeꞌenaꞌa, Badiꞌa mazao kuraro, “Zuhiꞌa Boro, ḡaeꞌa adure, raha, davara, zu eꞌe zamaḡano radiuꞌeteꞌe ḡauḡa niduꞌa haḡairo. ");
INSERT INTO ksj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ḡaeꞌa Vine Zaḡoḡa tuḡunadu ḡae tuḡure vazeḡa, vouḡafe Davidaonoꞌo ꞌahige rae reiro, 'Nougadu Iuda mene azaḡaniꞌa maḡune rudauꞌohe, zu habaꞌahabaꞌa azaḡaniꞌa huga oꞌoꞌa haḡaiḡa toganeꞌohe? ");
INSERT INTO ksj_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Raha kiniḡa azaḡaꞌe zeḡeꞌa bare uti ruhibiro, ebu raha azaḡa zuhiꞌaziꞌeteꞌe azaḡaꞌe nuꞌoranadu Zuhiꞌa Boro zu ane Keriso agatoziro.' ");
INSERT INTO ksj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Aꞌe hube hune fureraro. Heroda zu Pontio Pilatoꞌa Iuda mene azaḡa zu Isaraela azaḡa teite tiburanadu Ierusalemao nuꞌoraro ebu Iesu manoga veize toganiro. Iesuꞌe ḡae tuḡure vazeḡa zaḡoḡa zu ḡaeꞌa ohoniroteꞌe vazeḡa, Keriso. ");
INSERT INTO ksj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Zeꞌe ḡaeꞌa ḡae gigiꞌaḡo hina zu urao fureraꞌuma rae irina toganiroteꞌe haḡaiḡa haḡairo. ");
INSERT INTO ksj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Zuhiꞌa Boro, izidi zeꞌa riho ḡoeꞌa efateꞌe zamaroꞌi. Eme, ḡae tuḡure azaḡaniꞌa mene hune rihauꞌenaꞌa, ḡae ḡoere rae furenoga veize inarafoꞌi. ");
INSERT INTO ksj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ebu ꞌevoꞌo ꞌeinadu ugi azaḡa faizoꞌi, zu ḡae tuḡure vazeḡa zaḡoḡa Iesu niḡano haḡai nu badeḡa ebu zaguzagatiteꞌe haḡaiḡa haḡaoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ze kurau hauḡiroteꞌe enogano, zeḡeꞌa nuꞌoraroteꞌe habaꞌaniꞌa hagahagariro. Ebu zeḡe niduꞌa Vine Zaḡoḡaniꞌa iriꞌavozadu ze mene rihauꞌenaꞌa, Badiꞌa ḡoere inare rae fureniro. ");
INSERT INTO ksj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Fieꞌeteꞌe azaḡa niduꞌa zamaze zu zamaroneze tibano teadu vazeni ꞌahoganiꞌa, “ꞌAhiꞌe eḡe daꞌo tohe,” rae mene reiro, rehano “Vaze niduꞌa tohe,” rae raꞌenaꞌa ḡahugotitiro. ");
INSERT INTO ksj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ebu apostolo azaḡaꞌe inaraze boro hina Zuhiꞌa Boro Iesuꞌa bare ḡabodiroteꞌe moneo rae furene onamiro. Ebu Badiꞌaꞌe zeḡe mazao manoḡa borofe fureniro. ");
INSERT INTO ksj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Zeḡe boꞌaḡano ḡau ꞌahoganiꞌa fereniroteꞌe vazeḡaꞌe oꞌoꞌa. Mazaḡa habazeta azaḡa zu nezeta azaḡaniꞌa eꞌe seronadu hadiḡaꞌe apostolo azaḡa vaḡe odohe ariro, ");
INSERT INTO ksj_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ebu zeḡe zamao tiro. Ebu apostolo azaḡaniꞌa hadi eꞌe madu hadiꞌa ferezeꞌeteꞌe azaḡa ḡahugoziniro. ");
INSERT INTO ksj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Vaze ꞌahoga, niḡa Iosefaꞌe Levi urabo vazeḡa zu Kupuro ꞌumuḡa vazeḡa. Aniꞌe apostolo azaḡaniꞌa Banabasi rae huniro (ni eꞌe hugaꞌe 'Inaraziꞌeteꞌe Vazeḡa'). ");
INSERT INTO ksj_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Aniꞌe ane haba seronadu hadiḡa odohe ariro ebu apostolo azaḡa zamao tiro. ");
INSERT INTO ksj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Vaze ꞌahoga, niḡa Ananiaꞌa radiunu, ebu inuga niḡaꞌe Safira. Ze habaze boꞌaḡano tahiḡa seroniro. ");
INSERT INTO ksj_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ebu Ananiaꞌa inugeta ḡoere idanadu eꞌe hadiḡa nuꞌe ane veize obone tiro. Ebu ḡahaꞌa daꞌo apostolo azaḡa vaḡe odohe onamadu zamazeo tiro. ");
INSERT INTO ksj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ebu Peteroꞌa niro, “Anania, nougadu zamaḡoꞌe Sataniꞌa iriꞌavonadu Vine Zaḡoḡa mazao ḡurireha ebu ḡae haba seroniroteꞌe hadiḡa ḡahaꞌaꞌe ḡae veize obone teha? ");
INSERT INTO ksj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Haba aꞌe mene seroniroteꞌe madaḡano zuni ḡae haba. Ebu seroniroteꞌe enogano zuni eꞌe hadiḡaꞌe ḡae hadi radu eꞌe hina ḡae ura haḡaiḡa haḡaogaꞌe idaraneha. Rehano ḡa nougadu ḡuriro haḡaiḡa ꞌadi haḡaiꞌuma rae zamareha? Ḡa vaze mazao mene ḡurireha, rehano Badiꞌa mazao ḡurireha.” ");
INSERT INTO ksj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiaꞌa ḡoere eꞌe igirotene, higau bauradu rudaro. Ebu eꞌe hariḡa igiroteꞌe azaḡaꞌe niduꞌa rihau rudaro. ");
INSERT INTO ksj_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ebu tahiꞌa iziga nuꞌa aradu dabua hina ahiꞌa ꞌumiro ebu herate bunadu guriro. ");
INSERT INTO ksj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Mada uḡidu enogano inuganiꞌa diuḡi ariro. Ani naginiꞌa fureranataꞌaꞌe mene ederiro. ");
INSERT INTO ksj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ebu Peteroꞌa ani ḡadiniro, “Hadi ꞌadiꞌe ḡa zu iꞌuꞌa habaze seroniroteꞌe hadiḡa niduꞌahe? Ehoꞌi.” Aniꞌa naenaeniro, “Oꞌe, aꞌe seroniroteꞌe hadiḡa niduꞌa.” ");
INSERT INTO ksj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Peteroꞌa niro, “Nougadu ḡanine ḡoere idanadu Zuhiꞌa Boro Vine tuhuneha? Ḡianoꞌi! Iꞌu gurateꞌe azaḡaniꞌa ibihetao diuḡi areꞌohe ebu ze ḡae zuni herate buḡadiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ꞌOuge reirotene, ani zogone Petero oda babaḡano higau bauradu rudaro. Ebu iꞌa guriroteꞌe tahiꞌaḡa izigaiziganiꞌa diuḡi aradu inuganiꞌa rudanoga horoniro. Ebu ze ani herate bunadu iꞌa uhiḡano guriro. ");
INSERT INTO ksj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ekalesia azaḡa niduꞌa zu eꞌe hariḡa igiroteꞌe azaḡa niduꞌaꞌe rihau rudaro. ");
INSERT INTO ksj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apostolo azaḡaniꞌa gigiꞌa haḡaiḡa zu zaguzagatiteꞌe haḡaiḡa ḡehaḡa vaze ḡehaḡa boꞌaḡano haḡairo. Ebu fieꞌeteꞌe azaḡa niduꞌaꞌe Solomona Ibi Zauhaḡano nuꞌoraudo. ");
INSERT INTO ksj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Vazevazeꞌa ze niguziro, rehano mene fieꞌeteꞌe azaḡaꞌe zeḡe teite ꞌauḡoga mene idaḡa radu tibani zuni mene ꞌauḡiro. ");
INSERT INTO ksj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Rehano ohoze zu roḡae ḡehaḡaꞌe Zuhiꞌa Boro mazao fiadu fieꞌeteꞌe azaḡaꞌe ragateragate ḡeharaunu. ");
INSERT INTO ksj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ꞌOugadu Peteroꞌa ibio zeḡe uhiḡano vitauꞌeteꞌea, ze ibi genaḡano zuni ugi azaḡa tutuze aradu geda zu farata rana bazuze tiro. Mazaḡa Petero ahiri zauhaḡaniꞌa zauhazeadu ugizeꞌa manoroga uratiro. ");
INSERT INTO ksj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ebu Ierusalema uhiḡa neḡaneḡanonoꞌo vaze ḡuḡuvaḡaniꞌa ugi azaḡa ebu vine sauꞌaniꞌa ragano radu gigizeꞌeteꞌe azaḡa tutuze ariro, ebu zeḡe niduꞌaꞌe manoriro. ");
INSERT INTO ksj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ebu dibuꞌo vazeḡa ḡihiꞌaḡa zu ane mone azaḡa, Sadukea azaḡa niduꞌaꞌe apostolo azaḡa mazao ahiahi ufeta meiro. ");
INSERT INTO ksj_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Eꞌanoꞌo ze apostolo azaḡa oboze teadu ḡuꞌa neḡano ohoziro. ");
INSERT INTO ksj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Rehano Zuhiꞌa Boro tuḡure viganiꞌa eꞌe oheꞌano ḡuꞌa neḡa ibihetaḡa vavaꞌadu ze mae buziro. ");
INSERT INTO ksj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Ebu tuḡure viganiꞌa ziro, “Onamoꞌi ebu kuru neḡa habaꞌano edanadu ḡabone iziga ḡoeꞌa ꞌahi niduꞌa vazevaze meꞌodozenoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ze eꞌe igiroteꞌe enogano, oherebau uzeuze kuru neḡa habaꞌa diuḡadu vazevaze ḡadahe ihoziro. U dibuꞌo vazeḡa ḡihiꞌaḡa zu ane teite rauꞌeteꞌe azaḡaniꞌa aradu Iuda azaḡa nuꞌonuꞌo boro veize vaze boroboro niduꞌa huze nuꞌoziro. Ebu apostolo azaḡa ḡuꞌa neḡanonoꞌo tutuze aroga veize uti azaḡa nu tuḡuziro. ");
INSERT INTO ksj_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Rehano ze ḡuꞌa neḡano feurirotene, apostolo azaḡa eꞌea mene horoziro. Eꞌanoꞌo ze bare onamadu ziro, ");
INSERT INTO ksj_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Eme ḡuꞌa neḡa ibihetaḡaꞌe faine biroga zu ḡuꞌa neḡa ḡiane radiuꞌeteꞌe uti azaḡaꞌe ibihetao edauꞌenoga horozeha. Rehano eme ibiheta vavaꞌatene, zamaḡanoꞌe vaze ꞌahoga mene horoneha.” ");
INSERT INTO ksj_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kuru neḡa taufeꞌeteꞌe uti vazeḡa ḡihiꞌaḡa zu dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡaꞌe eꞌe hariḡa igirotene, naginiꞌa fureraꞌuma rae zamare ꞌadaꞌadaziro. ");
INSERT INTO ksj_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ebu hena vaze ꞌahoganiꞌa aradu ziro, “Ḡianoꞌi! Zaeꞌa ḡuꞌa neḡano ohozateꞌe azaḡaꞌe kuru neḡa habaꞌano edanadu vaze ihozeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Eꞌanoꞌo kuru neḡa ḡianeꞌeteꞌe vazeḡa ḡihiꞌaḡaꞌe ane tahiꞌatahiꞌa teite onamadu apostolo azaḡa tutuze bare ariro. Rehano ze apostolo azaḡa mene agatoziro, mazaḡa vaze ḡuḡuvaḡaniꞌa maḡunadu hadi hina ze zimi ruziꞌuma rae rihoziro. ");
INSERT INTO ksj_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ebu ze apostolo azaḡa tutuze aradu Iuda azaḡa nuꞌonuꞌo boro zamaḡano ohoziro, ebu dibuꞌo vazeḡa ḡihiꞌaḡaniꞌa ḡadiziro, ");
INSERT INTO ksj_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Eme zaꞌa vaze ꞌahi niḡano vazevaze mene ihozifine riḡa ziro. Rehano Ierusalema azaḡa niduꞌa zaeꞌa ihoze hauḡadu vaze eꞌeꞌa rudaroteꞌe adugaꞌe emeḡe rana tiꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petero zu apostolo azaḡaniꞌa naenaeziro, “Eme vaze ḡoere mene egohaꞌuma, rehano Badiꞌa ḡoere egohaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Iesuꞌe zaeꞌa satauro rana midau teadu rudaro rehano, vouḡafe Badiꞌaḡaniꞌa runeonoꞌo bare ḡaboniro. ");
INSERT INTO ksj_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Eꞌe vazeḡaꞌe vaze ibitoziꞌeteꞌe zu ḡabozeꞌeteꞌe vazeḡa radu Badiꞌaꞌa ani mae ḡihiniro ebu ane edaꞌe moneo ohoniro. Aꞌe, Isaraela azaḡaniꞌa ḡihuradu haḡaize sauꞌa rae modifine raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Emeꞌe eꞌe niduꞌa horonadu rae fureneꞌohe, ebu Vine Zaḡoḡa zuni eꞌe rae fureneꞌohe. Vine Zaḡoḡaꞌe Badiꞌaꞌa ane ḡoere egohauꞌeteꞌe azaḡa mazao tuḡuniro.” ");
INSERT INTO ksj_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nuꞌonuꞌo azaḡaniꞌa Petero ḡoere igirotene, ze maḡune rudanadu apostolo azaḡa zimi ruzihi reiro. ");
INSERT INTO ksj_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Rehano Farisea vazeḡa ꞌahoga, niḡa Gamalielaꞌa nuꞌonuꞌo azaḡa boꞌaḡano iḡune edaro. Aniꞌe Mose goro ḡoeꞌa ihozeꞌeteꞌe vazeḡa, ebu vaze niduꞌa ani gubaniro. Aniꞌa ziro, “ꞌAhi duḡuruꞌe mada tahiḡa enona tuḡuze buzoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ebu hena aniꞌa ziro, “Isaraela azaḡa, ꞌahi duḡuru mazao nagini haḡaihi raꞌetaꞌaꞌe faine zamaroꞌi. ");
INSERT INTO ksj_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ibite Teudaꞌa iḡunadu raenaꞌa, 'Eꞌe nihe boro,' radu vaze niduꞌa 400 heuḡa ani hegotiro. Rehano aniꞌe mau runiroteꞌe enoganoꞌe ani hegotiroteꞌe azaḡa niduꞌa ferefere uhiro. Ebu aneꞌa haḡainuteꞌe haḡaiḡaꞌe niduꞌa hauḡiro. ");
INSERT INTO ksj_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ani ḡarugano vaze niduꞌa nize tiroteꞌe madaḡano Galilea vazeḡa, niḡa Iudaꞌa iḡune edaro. Aniꞌe vaze ḡuḡuvaḡa zamazadu Roma gavamaniḡa teite utitiro. Rehano ane zuni mau runiro, ebu ani hegotiroteꞌe azaḡa niduꞌa ferefere uhiro. ");
INSERT INTO ksj_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Eꞌanoꞌo ꞌahi duḡuru moneo e za iraduguzeꞌohe. Zeḡe mazao ḡau ꞌahoga ago haḡaoꞌi ebu ze tuḡuze buzoꞌi. Mazaḡa zeḡe gau ga haḡai ꞌahiꞌe vaze mazaonoꞌo reine, aꞌe hauḡiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Rehano aꞌe Badiꞌa mazaonoꞌo reine, za ꞌahi duḡuru ꞌuoga mene idaraꞌuma. Zaꞌe Badiꞌa utitohauꞌeteꞌe azaḡa reꞌuma.” Eꞌanoꞌo ze Gamaliela ḡoere mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ebu apostolo azaḡa huzadu uti azaḡaniꞌa masiziro. Ebu, “Iesu niḡano ago ḡoeroꞌi,” rae riḡa zeadu tuḡuze buziro. ");
INSERT INTO ksj_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Apostolo azaḡaꞌe Iuda azaḡa nuꞌonuꞌonoꞌo matuꞌeꞌenaꞌa buaro. Mazaḡa Badiꞌaꞌa zeꞌe ane mone azaḡa rae mae ḡihizadu Iesu uꞌano nize sausauneꞌeteꞌe zamaḡano tuḡuziro ꞌahine, ze matuꞌiro. ");
INSERT INTO ksj_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ebu ze mada niduꞌa kuru neḡa habaꞌano zu ne tibatiba zamaḡano, Iesuꞌe Keriso rae raꞌeteꞌe hari manoḡa ꞌauꞌaune ihozinu zu haraminu. ");
INSERT INTO ksj_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Eꞌe madaḡano Iesu mazao fieꞌeteꞌe azaḡaniꞌa ḡeharu onamiro. Rehano Iuda azaḡa boꞌaḡano Giriki ḡoeꞌano ḡoereꞌeteꞌe azaḡaniꞌa Heberu ḡoeꞌano ḡoereꞌeteꞌe azaḡa mazao maḡuniro. Mazaḡa mada niduꞌa ogomu ḡahugirotene, Giriki ḡoeꞌano ḡoereꞌeteꞌe ḡozobaḡaꞌe iḡize modiro. ");
INSERT INTO ksj_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Eꞌanoꞌo apostolo azaḡa gaubanana aheu fareꞌa fieꞌeteꞌe azaḡa niduꞌa nuꞌozadu ziro, “Eme Badiꞌa ḡoere haramogaꞌe mene zamareꞌenaꞌa, ogomu ḡahugeꞌeteꞌe veize daꞌo ufeta inarine mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Eꞌanoꞌo, nego nabudi, zae boꞌaḡano vaze fuꞌo aheu fare ohozoꞌi. Zaeꞌa ḡiazadu zamazeo Vine Zaḡoḡaniꞌa iriꞌaveꞌeteꞌe zu faifaine zamareꞌeteꞌe azaḡa moꞌi. Eme eꞌe gauḡaꞌe zeḡe ꞌevoreo riꞌiniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","U emeꞌe kuru zu haramo gauḡa veize daꞌo inariꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Zeḡe niduꞌa eꞌe ḡoeꞌa mae ḡihiniro. Ebu ze vaze ꞌahoga, niḡa Stefano ohoniro. Aniꞌe fie gigaruꞌeteꞌe zu Vine Zaḡoḡaniꞌa iriꞌavoneꞌeteꞌe vazeḡa. Zuni Filipi, Porokoro, Nikanoro, Timona, Pamena zu Antioka vazeḡa niḡa Nikolao ohoziro. Nikolaoꞌe mene Iuda vazeḡa rehano, zamaḡa ḡihunadu Iuda azaḡa teite kurau tiburaroteꞌe vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ebu ze apostolo azaḡa zamao ohozadu apostolo azaḡaniꞌa zeḡe veize kuraro, zu ꞌevoreze zeḡe rana teadu ekalesia gau azaḡano ohoziro. ");
INSERT INTO ksj_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Badiꞌa ḡoereꞌe bororanadu fieꞌeteꞌe azaḡaniꞌa Ierusalema zamaḡano ḡehararo, zu dibuꞌo azaḡa ḡehaḡaniꞌa zuni Iesu mazao firo. ");
INSERT INTO ksj_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefanoꞌe Badiꞌaꞌa manoḡa zu gigiꞌa boro hina iriꞌavoniro ꞌahine, vaze ḡehaḡa boꞌaḡano zaguzagatiteꞌe haḡaiḡa zu gigiꞌa haḡaiḡa boroboro haḡainu. ");
INSERT INTO ksj_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Eꞌe madaḡano Tuḡure Vazeḡaonoꞌo Vaḡiniroteꞌe Azaḡa rae huzeꞌeteꞌe Iuda azaḡaniꞌa nuꞌonuꞌo neḡa ꞌahogano nuꞌoraunu. Eꞌe duḡuruꞌe Kureneonoꞌo, Alesanderiaonoꞌo, Kilikia habaꞌanonoꞌo, zu Asia habaꞌanonoꞌo ariro. Zeḡe boꞌaḡano nuꞌa Stefano teite taꞌirotitiro. ");
INSERT INTO ksj_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Rehano Stefanoꞌe Vine Zaḡoḡaniꞌa iriꞌavonadu faifaine zamareꞌenaꞌa ḡoeriro. ꞌOugadu ze ani agirohanoga mene idararo. ");
INSERT INTO ksj_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Eꞌanoꞌo ze sifu vaze nu soꞌoze tuḡuzadu ꞌahige rae fureniro, “Stefanoꞌa Mose zu Badiꞌa rae sausauzeꞌeteꞌe emeḡeꞌa egeha.” ");
INSERT INTO ksj_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Eꞌe ibiḡano ze vaze ḡuḡuvaḡa, vaze boroboro zu Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa tutuze soꞌozadu harae iḡuniro. Ebu ze Stefano obone teadu Iuda azaḡa nuꞌonuꞌo boro tutune onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ebu ze ḡuriro azaḡa nu tutuze onamadu ꞌahige rae fureniro, “Vaze ꞌahiꞌe iḡaiḡa kuru neḡa zaḡoḡa zu Mose goro ḡoeꞌa rae sausauneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Aniꞌa ꞌahige rae rougaꞌe emeḡeꞌa egeha, 'Nazareta vazeḡa Iesuꞌa kuru neḡa fahiꞌuma ebu Moseꞌa emeḡe mazao riꞌiniroteꞌe goroḡa ḡihuniꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nuꞌonuꞌo zamaḡano ehore radiroteꞌe azaḡa niduꞌa Stefano ḡiane runirotene, ani iraḡaꞌe tuḡure viga heuḡa horoniro. ");
INSERT INTO ksj_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ebu dibuꞌo vazeḡa ḡihiꞌaḡaniꞌa Stefano ḡadiniro, “Zeꞌa ḡae moneo ḡoereꞌetaꞌaꞌe hubehe?” ");
INSERT INTO ksj_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ebu Stefanoꞌa naenaeziro, “Nego nabudi ebu vaze boroboro, eḡe ḡoere egoꞌi. Emeḡe vouḡa Aberahamoꞌa Harani neḡa ꞌizema onamogano, Mesopotamia habaꞌano radiunu. Eꞌe madaḡano ḡihiꞌa hune Badiꞌaḡaniꞌa ani mazao fureranadu niro, ");
INSERT INTO ksj_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","'Ḡa ḡae haba zu negoḡo nabugo mode iḡunadu eḡeꞌa ihoꞌiteꞌe habaꞌa onamoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Eꞌanoꞌo ani Kaledea azaḡa haba modadu Harani neḡano radiro. Ebu moganiꞌa rudaroteꞌe enogano, Badiꞌaꞌa bare tuḡunadu izidi zaeꞌa radiuꞌeteꞌe habaꞌa ꞌahi ariro. ");
INSERT INTO ksj_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Rehano Badiꞌaꞌa haba ꞌahao haba tahiḡani zuni Aberahamo mene haro. Rehano Aberahamo ubugaꞌe ꞌizema furenogano, Badiꞌaꞌa Aberahamo teite ḡoitoriro, 'Ḡae zu ḡae marigo duḡuruꞌa haba ꞌahi meꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ebu Badiꞌaꞌa ꞌahige rae niro, 'Ḡae marigoꞌe avoꞌa azaḡa habao radiꞌuma ebu muri 400 zeꞌe tuḡure azaḡano radiuꞌenaꞌa, haba eꞌe azaḡaniꞌa ze sausauze ruziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Rehano marigo duḡuru tuḡutuḡuziroteꞌe azaḡaꞌe eḡeꞌa aduga ziniꞌuma. Eꞌe enogano marigo duḡuruꞌa eꞌe habaꞌa mode vaḡinadu haba ꞌaha eḡe mazao kuraꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ebu hena Badiꞌaꞌa ane ḡoitore ḡoeꞌa eꞌe rinede touga veize Aberahamo niro, 'Ahiri rana iḡuri haḡaoꞌi.' Eꞌanoꞌo Aberahamo ubuga Isakoꞌa fureranadu mada fuꞌo uḡidu fare meirotene, ahiꞌa rana iḡuri haḡairo. Ebu Isakoꞌa ubuga Iakobo ahiꞌa rana iḡuri haḡairo, ebu Iakobo zuni ane ubuga gaubanana aheu fare ahirize rana iḡuri haḡairo. Ebu Iakobo ubuga duḡuruꞌe Isaraela azaḡa vouḡaze boroboro reiro. ");
INSERT INTO ksj_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Iakobo ubuga duḡuruꞌe negoze Iosefa mazao ahiahi meiro, eꞌanoꞌo Iosefaꞌe Izipi habaꞌa azaḡa mazao seronadu tuḡure vazeḡano reiro. Rehano Badiꞌaꞌe Iosefa teite radiunu, ");
INSERT INTO ksj_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ebu aniꞌa aduga hidinuteꞌe madaḡa niduꞌa zamaḡano ḡaboninu. Ebu Iosefaꞌa Farao, Farao zamao edarotene, Badiꞌaꞌa ani mazao manoḡa fureniro zu zamarone huhuzaḡa haro. ꞌOugadu Faraoꞌa ani mazao matuꞌadu Izipi habaꞌa niduꞌa zu ane ne zuhiꞌaziꞌeteꞌe vazeḡano mae ohoniro. ");
INSERT INTO ksj_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Eꞌe madaḡano zahara boroꞌa Izipi zu Kanana habaꞌa niduꞌa zamaḡano fureranadu vaze niduꞌa aduga boro hidiro. Vouḡafe zuni ogomuzeꞌa hauḡiro. ");
INSERT INTO ksj_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ebu Iakoboꞌa Izipi habaꞌano ogomu eꞌe rae igirotene, ogomu nu hoitoga veize ubuga duḡuru tuḡuziro. Aꞌe Izipi habaꞌa onamiroteꞌe ḡadaheḡa. ");
INSERT INTO ksj_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ze ḡae aheuḡano tuḡuzirotene, Iosefaꞌa aniꞌe iniu rae negoḡa duḡuru ihoziro. ꞌOugadu Farao zuni Iosefa moga ebu negoḡa duḡuru moneo ederiro. ");
INSERT INTO ksj_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Eꞌe enogano Iosefaꞌa moga Iakobo zu nabuga niduꞌa Izipi habaꞌa aroga veize ḡoere tuḡuriro. Zeḡe niduꞌaꞌe 75. ");
INSERT INTO ksj_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ebu Iakoboꞌa Izipi habaꞌa onamiro. Ebu ane zu ane ubuga niduꞌa eꞌea radiro, onamo zeḡe niduꞌa rudaro. ");
INSERT INTO ksj_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ahirizeꞌe Sekemu habaꞌa odohe onamadu ibite Aberahamoꞌa Hamoro mariga mazaonoꞌo hadi hina hoitiroteꞌe iduḡano guriro. ");
INSERT INTO ksj_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ebu Badiꞌaꞌa irina Aberahamo mazao tiroteꞌe ḡoitore ḡoeꞌaniꞌa hudatiteꞌe madaḡaniꞌa hanitirotene, Isaraela azaḡaꞌe Izipi habaꞌano ḡehararo. ");
INSERT INTO ksj_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ebu hena Iosefa hariḡa aḡuꞌa vazeḡaniꞌa Farao reiro. ");
INSERT INTO ksj_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Aniꞌe vouḡafe soꞌosoꞌozadu sausauze ruziro, ebu eneze guraḡaniꞌa rudanoga veize mae modoꞌi rae tuḡutuḡuziro. ");
INSERT INTO ksj_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Eꞌe madaḡano Moseꞌa fureraro. Aniꞌe Badiꞌa ubumao manoḡa tauḡi. Ebu bato uḡidu viꞌa moganiꞌa ani nezeo sifu taufiro. ");
INSERT INTO ksj_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Eꞌe enogano Moseꞌe mae modirotene, Farao aboḡaniꞌa horone madu ane ubugano ḡubune borofiro. ");
INSERT INTO ksj_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ebu Moseꞌe Izipi azaḡa edeḡa niduꞌa madu inaraḡeta ḡoerinu zu gauinu. ");
INSERT INTO ksj_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moseꞌe muriḡa 40 reirotene, ane nabuga Isaraela azaḡa ḡiazi onamihi reiro. ");
INSERT INTO ksj_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ebu ani Izipi vazeḡa ꞌahoganiꞌa Isaraela vazeḡa ꞌahoga sausauneꞌeteꞌe horonirotene, ani dananihi rae onamiro ebu Izipi vazeḡa eꞌe mau runadu ane haḡai sauꞌa naeḡa baronoharo. ");
INSERT INTO ksj_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moseꞌe ꞌahige zamariro, 'Nabudihe duḡuruꞌe ederiꞌuma, Badiꞌaꞌa ze ḡabozifine e tuḡuheha.' Rehano ze ꞌouge mene zamariro. ");
INSERT INTO ksj_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Irarirotene, ani Isaraela azaḡa aheuꞌa utiteꞌeteꞌe horoziro. ꞌOugadu ze bare unihoga veize ꞌahige rae ziro, 'Za ḡanine nego. Nougaꞌahi sausautiteꞌohe?' ");
INSERT INTO ksj_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Rehano nabuga ꞌahoga sausauneꞌeteꞌe vazeḡaniꞌa Mose duine vaḡinadu ꞌahige rae niro, 'Ḡaꞌe iniuꞌa emeḡe zuhiꞌao zu kota vazeḡano ohoꞌiro? ");
INSERT INTO ksj_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ḡaꞌe ohoḡore Izipi vazeḡa mau runateꞌe teige, eḡe zuni uḡuhihi raꞌehe?' ");
INSERT INTO ksj_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moseꞌa ḡoere eꞌe igirotene, ani Midiana habaꞌa ferau onamiro ebu eꞌea iꞌudo vazeḡa teige radiuꞌenaꞌa ubuga aheu fureniro. ");
INSERT INTO ksj_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Muri 40 enogano Sinai maḡa uhiḡa, haba bohaꞌano tuḡure viga ꞌahoganiꞌa Mose mazao fureraro. Aniꞌe ire renogano ire roga duhuḡa zamaḡano fureraro. ");
INSERT INTO ksj_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moseꞌa eꞌe horonadu zaguzagaro ebu faine ḡianoga veize uhiḡa onamiro. Onamirotene, Zuhiꞌa Boro ago igiro, ");
INSERT INTO ksj_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","'Eꞌe vouḡaḡo Badiꞌa, Aberahamo, Isako zu Iakobo Badiꞌa.' Moseꞌa eꞌe igirotene rihanadu rereraro ebu ehamanoga zuni mene idararo. ");
INSERT INTO ksj_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Eꞌe madaḡano Zuhiꞌa Boroꞌa niro, 'Tamakaḡo mae vaḡinoꞌi, mazaḡa ḡaeꞌa edauꞌeteꞌe habaꞌaꞌe zaḡoḡa. ");
INSERT INTO ksj_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","E hube hune Izipi habaꞌano Isaraela azaḡa sausauzeꞌeteꞌe horoziro zu ze ḡaniḡanauꞌeteꞌe igiro. Eꞌanoꞌo e ze aduganonoꞌo bohaze buzoga veize ovaeha. Ḡa izidi onamoꞌi. E ḡaꞌe Izipi habaꞌa bare tuḡuꞌeꞌohe.' ");
INSERT INTO ksj_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Mose ꞌahiꞌe Isaraela azaḡaniꞌa hezahoharoteꞌe vazeḡa. Ze ꞌahige rae niro, 'Ḡaꞌe iniuꞌa emeḡe zuhiꞌao zu kota vazeḡano ohoꞌiro?' Rehano Moseꞌe Isaraela azaḡa ibitozifine zu aduganonoꞌo bohaze buzifine Badiꞌa aneꞌa bare tuḡuniroteꞌe vazeḡa. Aꞌe ire renogano ire roga duhuḡa zamaḡano Mose mazao fureraroteꞌe tuḡure vigaonoꞌo Badiꞌaꞌa ihoniro. ");
INSERT INTO ksj_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ebu Moseꞌa Isaraela azaḡa Izipi habaꞌanonoꞌo tutuze vaḡiziro. Eꞌe zamaḡano zaguzagatiteꞌe haḡaiḡa zu haḡai nu badeḡa haḡainu. Ebu Izipi habaꞌano, Davara Kanaḡa genaḡano, zu muri 40 haba bohaꞌano ꞌouge haḡainu. ");
INSERT INTO ksj_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mose ꞌahiꞌe Isaraela azaḡa ꞌahige rae ziro, 'Badiꞌaꞌa zae boꞌaḡano peroveta vazeḡa ꞌahoga eḡe heuḡa tuḡuniꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moseꞌe haba bohaꞌano vouḡafeꞌa nuꞌoraroteꞌe zamaḡano radiunu. Ebu Sinai maḡano tuḡure viganiꞌa ani teite ḡoerirotene, ani vouḡafe teite radiro. Aniꞌe Badiꞌa mazaonoꞌo ḡabone ḡoeꞌa madu emeḡe mazao riꞌiniroteꞌe vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Rehano vouḡafeꞌa Mose ḡoere hegotoga mene uratiro. Ebu Mose hezahohanadu zamazeo Izipi habaꞌa bare onamihi reiro. ");
INSERT INTO ksj_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Eꞌanoꞌo ze Aroni niro, 'Emeḡe ibitofoga veize badiꞌa nu haḡaofoꞌi! Moseꞌa Izipi habaꞌanonoꞌo emeḡe tutufe vaḡifiro rehano, izidi ani mazao naginiꞌa furerarotaꞌaꞌe emeꞌe aḡuꞌa.' ");
INSERT INTO ksj_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ꞌOugadu ze ḡuriro badiꞌaḡa boromakau ubuga iraḡano haḡairo. Ebu ze ani dibuꞌohanadu ꞌevoreze hina haḡairoteꞌe ḡauḡa niguneꞌenaꞌa, matuꞌe rudaro. ");
INSERT INTO ksj_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Eꞌanoꞌo Badiꞌaꞌa ze ḡaruni ziniro ebu ze mada, bato zu buzuva mazao kuranoga reꞌoreꞌoze mode tauḡiro. Peroveta azaḡaniꞌa Buka Zaḡoḡano ꞌahige rae mirihiro, 'Isaraela azaḡa, zaꞌe muri 40 haba bohaꞌano radiuꞌeteꞌea, dibuꞌo ꞌahoga ga ḡahunone ꞌahoga e mene iniro. ");
INSERT INTO ksj_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Zaꞌe ḡuriro badiꞌaḡa ꞌahoga, niḡa Moleko veize kuru neḡa taruhaḡa ogoranadu mae ḡihiniro, zu buzuva iraḡa haḡadu aꞌe zae badiꞌa Refani rae huneꞌenaꞌa mae ḡihiniro. Zaꞌe ḡuriro badiꞌaḡa ꞌuguḡa mazao kuraro. Eꞌanoꞌo zaꞌe eḡeꞌa Babulonia habaꞌa roꞌane, haba faḡano tuḡuze modiꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Vouḡafeꞌa haba bohaꞌano radiunuteꞌe madaḡano ze Mose goro ḡoeꞌa tiroteꞌe taruhaḡa haḡairo. Aꞌe Badiꞌaꞌa Mose ihonadu Moseꞌa horoniroteꞌe idunaḡano haḡairo. ");
INSERT INTO ksj_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Muri nu enogano vouḡafeꞌa moze mazaonoꞌo taruha eꞌe mae ꞌauniro. Ebu Badiꞌaꞌa haba ꞌahaonoꞌo Iuda mene azaḡa hegoze vaḡizadu Iosuaꞌa vouḡafe ibitoziꞌenaꞌa, haba ꞌahi meiro. Eꞌe madaḡano Iosuaꞌa vouḡafe teite taruha eꞌe odohe diuḡadu eꞌea ohoniro, onamo Davida madaḡaniꞌa feuriro. ");
INSERT INTO ksj_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Davida uꞌano Badiꞌaꞌa matuꞌiro ꞌahine, Badiꞌaꞌa ani mazao manoḡa fureniro. Ebu Davidaꞌe Isaraela azaḡaniꞌa kuranoga veize Badiꞌa ne ꞌahoga ogoratihi radu Badiꞌa uminiro. ");
INSERT INTO ksj_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Rehano eꞌe neḡaꞌe Davida ubuga, Solomonaꞌa Badiꞌa veize ogoraro. ");
INSERT INTO ksj_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Rehano Hitaga Hune Badiꞌaḡaꞌe vazeꞌa ogoraroteꞌe neḡano mene radiuꞌohe. Peroveta vazeḡaniꞌa ꞌahige rae reiro, ");
INSERT INTO ksj_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","'Zuhiꞌa Boroꞌa raꞌohe, “Adureꞌe eḡe ehoro habaꞌa, zu rahaꞌe eḡe oda ohone tiꞌeteꞌe habaꞌa. Eꞌanoꞌo zaꞌe eḡe ne ogoranoga mene idaḡa, zu ahirihe ohoneꞌeteꞌe habaꞌaꞌe oꞌoꞌa. ");
INSERT INTO ksj_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ḡau niduꞌa ꞌahiꞌe eḡe ꞌevore hina haḡairo.”' ");
INSERT INTO ksj_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Zaꞌe teḡaze riḡa azaḡa, ebu zamaze tuḡa zu Badiꞌa ḡoere mene egohuꞌeteꞌe azaḡa! Zaꞌe zae vouḡa azaḡa teige, Vine Zaḡoḡa iḡaiḡa hezahohauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Vouḡazeꞌa mene sausauniroteꞌe peroveta vazeḡa ꞌahoga eꞌe ga? Vaze Duduḡaniꞌa ariteꞌe hariḡa irina rae fureniroteꞌe azaḡa zeḡeꞌa zimi ruzinu. Ebu izidi zaꞌe eꞌe vazeḡa revohanadu mau runiro. ");
INSERT INTO ksj_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Zaꞌe Badiꞌaꞌa tuḡure viga tuḡunadu ziniroteꞌe goro ḡoeꞌa meiro, rehano goro ḡoeꞌa eꞌe mene hegotiro.” ");
INSERT INTO ksj_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ze Stefano ḡoere igirotene, zamaze ḡugize ruziro ebu ani mazao ḡononeze atitiro. ");
INSERT INTO ksj_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Rehano Stefanoꞌe Vine Zaḡoḡaniꞌa iriꞌavonadu adure ḡohani ḡianiro. Ebu Badiꞌa agaḡaniꞌa borofe agaraneꞌeteꞌe zu Iesuꞌa Badiꞌa edaꞌe moneo edauꞌeteꞌe horoniro. ");
INSERT INTO ksj_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Eꞌanoꞌo aniꞌa ꞌahige rae reiro, “Ḡianoꞌi! E adureꞌa bohatanoga ebu Vaze Ubuganiꞌa Badiꞌa edaꞌe moneo edanoga horoneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Rehano ze ꞌevoreze hina teḡaze ꞌuadu ḡihau huauꞌenaꞌa, zeḡe niduꞌa ani uꞌa dure onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ebu Ierusalema ḡutuꞌaḡano ahase onamadu hadi hina mau sausauniro. Kota zamaḡano ḡuriro ḡoeꞌa Stefano rana tiroteꞌe azaḡaniꞌa dabuaze mae vaḡinadu tahiꞌa iziga ꞌahoga, niḡa Saulo oda babaḡano tiro. ");
INSERT INTO ksj_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ze hadi hina Stefano mauꞌeteꞌea, ani Badiꞌa mazao kuraro, “Zuhiꞌa Boro Iesu, eḡe vine moꞌi!” ");
INSERT INTO ksj_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ebu ani obenaḡa hina tuḡadu huaro, “Zuhiꞌa Boro, haḡaize sauꞌa ꞌahi naeḡa zeḡe rana ago toꞌi!” Ani ꞌouge reiroteꞌe enogano iriga riꞌiro. ");
INSERT INTO ksj_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sauloꞌe Stefano mau runogaꞌe idaḡa rae reiro. Stefanoꞌa rudaroteꞌe madaḡano Ierusalema ekalesia azaḡa sausauze ruzeꞌeteꞌe haḡaiḡaniꞌa fureraro. Eꞌanoꞌo zeḡe niduꞌa Iudea zu Samaria habaꞌa ferau onamiro, u apostolo azaḡaꞌe Ierusalemao radiro. ");
INSERT INTO ksj_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Badiꞌa gubaneꞌeteꞌe azaḡa nuꞌe Stefano ahiri mae guriro ebu niau kuaro. ");
INSERT INTO ksj_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Rehano Sauloꞌe ekalesia ruizihi reiro. Aniꞌe neḡaneḡa onamadu ohoze zu roḡae ahase buziro ebu ḡuꞌa neḡano ohoziro. ");
INSERT INTO ksj_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ierusalemaonoꞌo ferau onamiroteꞌe azaḡaꞌe habaꞌahabaꞌa ragaveꞌenaꞌa, Badiꞌa ḡoere haramiro. ");
INSERT INTO ksj_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipiꞌa Samaria habaꞌano ne boro ꞌahoga ovoadu Keriso hari haramiro. ");
INSERT INTO ksj_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Vaze ḡuḡuvaḡaniꞌa Filipi haramo igirotene zu aniꞌa haḡairoteꞌe haḡai gigiꞌaḡa horonirotene, zeḡe niduꞌa Filipi haramo faifaine abitoharo. ");
INSERT INTO ksj_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Mazaḡa aniꞌa vaze ḡehaḡa mazaonoꞌo vine sauꞌasauꞌa hegoze buzadu vine sauꞌasauꞌaꞌe ḡihau huauꞌenaꞌa buaro. Ebu ahirize mene haganinuteꞌe azaḡa zu odaze sauꞌa azaḡa ḡehaḡaniꞌa manoriro. ");
INSERT INTO ksj_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Eꞌanoꞌo eꞌe neḡano matuꞌu boroꞌa iriꞌaviro. ");
INSERT INTO ksj_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Vaze ꞌahoga, niḡa Simonaꞌa ne boro eꞌe zamaḡano radiunu. Aniꞌe muri nu zamaḡano baidi zu naho muravaḡa haḡadu Samaria azaḡaniꞌa zaguzagaunu. Ebu ani aneꞌa bare niḡa mae itinu. ");
INSERT INTO ksj_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ꞌOugadu Samaria azaḡa, komeꞌanonoꞌo onamo boro niduꞌa, ani ḡoere faifaine abitohaunu ebu ꞌahige rae reinu, “Vaze ꞌahiꞌe Gigiꞌa Hune rae huneꞌeteꞌe Badiꞌa gigiꞌaḡa meiro.” ");
INSERT INTO ksj_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Vaze niduꞌa ani hegotiro, mazaḡa aniꞌa mada faḡa baidi zu naho muravaḡa haḡainu. ");
INSERT INTO ksj_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Rehano Filipiꞌa Badiꞌaꞌa zuhiꞌaziꞌeteꞌe moneo zu Iesu moneo hari manoḡa haramirotene, ohoze zu roḡae, zeḡe niduꞌa ani ḡoere mae ḡihiniro ebu babatiso meiro. ");
INSERT INTO ksj_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ebu Simona zuni eꞌe ḡoeꞌa mae ḡihinadu babatiso meiro ebu Filipi hegote ragaviro. Ani Filipiꞌa haḡaeꞌeteꞌe haḡaiḡa nu badeḡa zu gigiꞌa haḡaiḡa ḡihiꞌa hune horonadu zaguzagaro. ");
INSERT INTO ksj_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samaria azaḡaniꞌa Badiꞌa ḡoere mae ḡihiniroteꞌe hariḡa apostolo azaḡaniꞌa Ierusalemao egadu Petero zu Ioaneꞌe Samaria azaḡa mazao tuḡuziro. ");
INSERT INTO ksj_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ze Samaria habaꞌano feurirotene, Samaria azaḡaniꞌa Vine Zaḡoḡa meifine zeḡe veize kuraro. ");
INSERT INTO ksj_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Mazaḡa zeꞌe Zuhiꞌa Boro Iesu niḡano babatiso daꞌo meiro, rehano Vine Zaḡoḡaꞌe zeḡe mazao ꞌize mene ovairo. ");
INSERT INTO ksj_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ꞌOugadu Petero zu Ioaneꞌa ꞌevoreze zeḡe rana teadu kuraro, ebu ze Vine Zaḡoḡa meiro. ");
INSERT INTO ksj_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simonaꞌe apostolo azaḡaniꞌa ꞌevoreze vaze rana tirotene, Vine Zaḡoḡaniꞌa ovairoteꞌe horonadu apostolo azaḡa hadi ziniro, ");
INSERT INTO ksj_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ebu umiziro, “Eḡe zuni gigiꞌa eꞌe enoꞌi. ꞌOugine, e ꞌevorehe vaze rana teadu ze Vine Zaḡoḡa meꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Rehano Peteroꞌa naenaeniro, “Ḡa Badiꞌa ḡahunoneꞌe hadi hina hoitoga idaḡa rae zamarahe? Ḡa hadiḡo teite rudaꞌuma! ");
INSERT INTO ksj_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Badiꞌa gau ꞌahi zamaḡano niḡo oꞌoꞌa, mazaḡa ḡae zamaroneꞌe Badiꞌa ubumao mene duduḡa. ");
INSERT INTO ksj_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Zamaḡo sauꞌanonoꞌo ḡihuradu Zuhiꞌa Boro mazao kuranoꞌi. ꞌOugine, Zuhiꞌa Boroꞌa ḡae zamarone sauꞌa ꞌuguḡa aḡutu modiꞌuma gaogi. ");
INSERT INTO ksj_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","E horoꞌeꞌetene, ḡae zamao sauꞌaniꞌa iriꞌaveꞌohe zu haḡai sauꞌaniꞌa zamaḡo obone tiꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ebu Simonaꞌa naenaeziro, “Zaeꞌa rateꞌe ḡauḡaniꞌa eḡe mazao mene furerafine, eḡe veize Zuhiꞌa Boro mazao kuranoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Petero ebu Ioaneꞌe Zuhiꞌa Boro ḡoere rae fureniro zu haramoziro. Eꞌe enogano ze Samaria azaḡa neḡa ḡehaḡano hari manoḡa harame ragaveꞌenaꞌa, Ierusalema bare itiro. ");
INSERT INTO ksj_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ebu Zuhiꞌa Boro tuḡure viganiꞌa Filipi niro, “Iḡunadu Ierusalemaonoꞌo Gaza ovoeꞌeteꞌe ibiḡa ḡuzu ovoroꞌi. Aꞌe haba bohaꞌa ibiḡa.” ");
INSERT INTO ksj_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Eꞌanoꞌo ani iḡunadu eꞌe ibiḡano ovoiro. Ovoeꞌeteꞌe ibiḡano ani Etiopia vazeḡa boro ꞌahoga hidiro. Aniꞌe Etiopia kini roḡaeḡa veize gaueꞌenaꞌa, kini roḡaeḡa hadi niduꞌa ḡianeꞌeteꞌe gavanaḡa vazeḡa. Ani Badiꞌa mazao kuranoga veize Ierusalema itiro. ");
INSERT INTO ksj_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ebu bare ovoiroteꞌe zamaḡano, hosi kiuḡano ehoradu peroveta vazeḡa Isaia bukaḡa meꞌode radiunu. ");
INSERT INTO ksj_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Eꞌe madaḡano Vine Zaḡoḡaniꞌa Filipi niro, “Kiu ꞌomo uꞌa onamadu eꞌe uhiḡano edanoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Eꞌanoꞌo Filipiꞌa kiu uꞌa dure onamadu vaze eꞌeꞌa peroveta vazeḡa Isaia bukaḡa meꞌodeꞌenoga igiro. Ebu Filipiꞌa ḡadiniro, “Ḡa ḡaeꞌa meꞌodeꞌeteꞌe ḡoeꞌa huga edeḡahe?” ");
INSERT INTO ksj_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Aniꞌa naenaeniro, “Vazeni ꞌahoga mene ihoheꞌohe. E nougenouge ederiꞌuma?” Ebu ani Filipi ane teite kiu rana ehoroga uminiro. ");
INSERT INTO ksj_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Aniꞌa Buka Zaḡoḡano meꞌodiroteꞌe ḡoeꞌaꞌe ꞌahi eꞌe, “Aniꞌe matihi radu tutune onameꞌeteꞌe mamoeḡa teigiro, ebu iguḡa variꞌeꞌeteꞌe vazeḡa zamao sifu radiuꞌeteꞌe mamoe ubuga teigiro. Ani ḡoere ꞌahoga mene reiro. ");
INSERT INTO ksj_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Vazeꞌa ani ovoe ḡianeꞌenaꞌa, ḡuriro ḡoeꞌa hina kotaniro. Iniuꞌa ane mariga moneo ḡoeriꞌuma? Mazaḡa ḡaboneḡaꞌe raha ꞌadanoꞌo mae vaḡiniro.” ");
INSERT INTO ksj_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Etiopia vazeḡaniꞌa Filipi ḡadiniro, “Peroveta vazeḡaꞌe iniu moneo raꞌohe? Ane bare moneo raꞌe ga vaze ꞌahoga moneo raꞌohe? Eḡe ehoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ebu Filipiꞌa Buka Zaḡoḡa ḡoeꞌa ꞌahionoꞌo ḡadahe onamo Iesu hari manoḡa rae furenoharo. ");
INSERT INTO ksj_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ze ibio onameꞌeteꞌea vu horonirotene, Etiopia vazeḡaniꞌa niro, “Ḡianoꞌi, vu ꞌahi eꞌe. Ḡa eḡe babatisohine idaḡahe?” ");
INSERT INTO ksj_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ebu Etiopia vazeḡaniꞌa ane tuḡure vazeḡa neadu kiu hebeniro. Ebu anianine kiuonoꞌo buanadu vu zamaḡano ovoe edaro ebu Filipiꞌa babatisoniro. ");
INSERT INTO ksj_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ze vuonoꞌo gabao tire edarotene, Zuhiꞌa Boro Vine Zaḡoḡaniꞌa Filipi zogone mae vaḡiniro. ꞌOugadu Etiopia vazeḡaniꞌa Filipi mene bare horoniro, rehano ani matuꞌeꞌenaꞌa, ane ibio onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","U Filipiꞌe Azoto neḡano fureraro. Eꞌeanoꞌo neḡaneḡa niduꞌa ragaveꞌenaꞌa, hari manoḡa haraminu, onamo Kaisareao feuriro. ");
INSERT INTO ksj_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sauloꞌe ꞌize Zuhiꞌa Boro tahiꞌatahiꞌa zimi hunihi radu riho ḡoeꞌa furenoziniro. Ebu ani dibuꞌo vazeḡa ḡihiꞌaḡa vaḡe onamadu ");
INSERT INTO ksj_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","uminiro, “Damaseko zamaḡano nuꞌonuꞌo neḡa niduꞌa mazao tuḡuriteꞌe soꞌaḡa nu mirihe enoꞌi. ꞌOugine, eḡeꞌa onamadu iniu Iesu Ibi hegoteꞌeteꞌe azaḡa, ohoze ga roḡae horozine, ze oboze teadu Ierusalema tutuze ariꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ebu ani ibio onameꞌeteꞌea Damaseko hanitirotene, adureonoꞌo agaḡaniꞌa ani rana tabara agaru ovairo. ");
INSERT INTO ksj_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Aniꞌa rahao higau bauriro ebu ago ꞌahoga igiro, “Saulo, Saulo, ḡa nougadu e sausauheꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sauloꞌa ḡadiniro, “Zuhiꞌa Boro, ḡa iniu?” Aniꞌa naenaeniro, “Eꞌe Iesu, ḡaeꞌa sausauheꞌeteꞌe vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Iḡunoꞌi ebu Damaseko diuḡi onamoꞌi. Vaze ꞌahoganiꞌa ḡaeꞌa nagini haḡaiteꞌe ihoꞌiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saulo teite onameꞌeteꞌe azaḡaꞌe edau radiuꞌenaꞌa, mene ḡoeriro, mazaḡa ze agoꞌe igiro rehano, vaze ꞌahoga mene horoniro. ");
INSERT INTO ksj_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauloꞌe rahaonoꞌo iḡuniro, rehano ubumaḡa raꞌarotene, ḡau ꞌahoga mene horoniro. Eꞌanoꞌo ze Saulo ꞌevoꞌano abinadu Damaseko diuḡi onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sauloꞌe mada uḡidu ehamanoga mene idararo, zu ogomu ꞌahoga mene aro, zu vu mene gagiro. ");
INSERT INTO ksj_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaseko zamaḡano Zuhiꞌa Boro tahiꞌa ꞌahoga, niḡa Ananiaꞌa radiunu. Zuhiꞌa Boroꞌa ane ahiri raꞌaga iḡunaḡano ani mazao fureranadu huniro, “Anania!” Aneꞌa naenaeniro, “Zuhiꞌa Boro, e ꞌaha.” ");
INSERT INTO ksj_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Zuhiꞌa Boroꞌa niro, “Iḡunadu Ibi Duduḡa rae huneꞌeteꞌe ibiḡano onamoꞌi, ebu vaze ꞌahoga niḡa Iuda ane ne onamadu Taso vazeḡa ꞌahoga niḡa Saulo vaḡoꞌi. Aniꞌe izidi kurauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ani ahiri raꞌaga iḡunaḡano Anania rae huneꞌeteꞌe vazeḡaniꞌa diuḡe aradu ani rana ꞌevoꞌa teatene, ani bare ehamanoga horoniro.” ");
INSERT INTO ksj_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiaꞌa naenaeniro, “Zuhiꞌa Boro, aniꞌa Ierusalemao ḡae mone azaḡa sausauzinuteꞌe hariḡa niduꞌa vaze ḡehaḡaniꞌa meꞌodeꞌeteꞌe eḡeꞌa igiro. ");
INSERT INTO ksj_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ebu aniꞌa dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa mazaonoꞌo iniu ḡa mazao fieꞌeteꞌe azaḡa niduꞌa oboze titeꞌe gigiꞌaḡa madu ne ꞌadi areha.” ");
INSERT INTO ksj_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Rehano Zuhiꞌa Boroꞌa niro, “Onamoꞌi. Vaze ꞌahiꞌe gauhe haḡaifine eḡeꞌa ohotiroteꞌe vazeḡa. Aniꞌe Iuda mene azaḡa, kini azaḡa zu Isaraela azaḡa nihe ihoziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ebu eḡe uꞌano, aneꞌa aduga boro hiditeꞌe ihoniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Eꞌanoꞌo Ananiaꞌa onamadu Iuda ne diuḡiro. Ebu ꞌevoꞌa Saulo rana teadu niro, “Negohe Saulo, ḡaeꞌa ꞌahi areꞌenogano ibio hidiroteꞌe Zuhiꞌaḡa Boroꞌa eḡe tuḡuhadu areha. Aꞌe, ḡaeꞌa bare ehamanoga veize zu Vine Zaḡoḡaniꞌa ḡae iriꞌavoꞌoga veize raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ꞌOuge reirotene, ḡozone eḡoḡa heuḡaniꞌa Saulo ubumaḡanonoꞌo zogone buaro ebu ani bare ehamaro. Ebu ani iḡunadu babatiso meiro. ");
INSERT INTO ksj_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ani ogomu nu aroteꞌe enogano ahiꞌaniꞌa bare inariro. Sauloꞌe Damaseko zamaḡano mada nu Zuhiꞌa Boro mazao fieꞌeteꞌe azaḡa teite radiro. ");
INSERT INTO ksj_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ebu zogone nuꞌonuꞌo neḡaneḡa onamadu Iesuꞌe Badiꞌa Ubuga rae haramiro. ");
INSERT INTO ksj_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ani ḡoere igiroteꞌe azaḡa niduꞌaꞌe zaguzaganadu ꞌahige rae reiro, “Vaze ꞌahiꞌe Ierusalemao Iesu mazao fieꞌeteꞌe azaḡa zimiroteꞌe vazeḡa, oꞌehe? ꞌAdao zuni fieꞌeteꞌe azaḡa oboze teadu dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa vaḡe tutuze onamoga veize areha!” ");
INSERT INTO ksj_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Rehano Sauloꞌe ufeta inare Iesuꞌe Keriso rae fureniro ꞌahine, Damaseko zamaḡano radiuꞌeteꞌe Iuda azaḡaniꞌa naenaenoga mene idararo. ");
INSERT INTO ksj_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Mada ḡehaḡa enogano Iuda azaḡaniꞌa Saulo matihi radu ḡoꞌaniro. ");
INSERT INTO ksj_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Rehano Sauloꞌe zeḡeꞌa ꞌouge toganirotaꞌaꞌe ederiro. Zeꞌe ohere zu madai Damaseko ḡabiꞌa niduꞌa ibihetaḡano Saulo matihi radu ḡiane radiro. ");
INSERT INTO ksj_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Rehano Saulo tahiꞌatahiꞌaꞌa ohere ani zamahanadu foraꞌa boro zamaḡano ohoniro, ebu ne ḡabiꞌa bohaꞌanonoꞌo mini hina dabane buniro. ");
INSERT INTO ksj_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ebu Sauloꞌa Ierusalema onamadu fieꞌeteꞌe azaḡa teite ꞌauḡihi reiro. Rehano zeḡe niduꞌa Saulo rihoniro, mazaḡa ze aniꞌe hube hune Iesu tahiꞌa reiroteꞌe mene mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Rehano Banabasiꞌa Saulo zamahanadu apostolo azaḡa vaḡe tutune onamiro. Ebu Sauloꞌa Damaseko ibiḡano Zuhiꞌa Boro horoniroteꞌe, zu Zuhiꞌa Boroꞌa ḡoreniroteꞌe, ebu Damaseko zamaḡano Iesu niḡano inare haramiroteꞌe meꞌodoziniro. ");
INSERT INTO ksj_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ꞌOugadu Sauloꞌe apostolo azaḡa teite Ierusalema zamaḡano reꞌoreꞌe oname onainu ebu Zuhiꞌa Boro niḡano inare haraminu. ");
INSERT INTO ksj_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ebu aniꞌe Giriki ḡoeꞌano ḡoereꞌeteꞌe Iuda azaḡa teite ḡoeriro zu taꞌirotitiro. Rehano ze ani matihi rae reiro. ");
INSERT INTO ksj_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Rehano fieꞌeteꞌe azaḡaniꞌa eꞌe ederadu Saulo Kaisarea tutune ovoiro ebu hena Taso neḡano tuḡuniro. ");
INSERT INTO ksj_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ebu ekalesiaꞌe Iudea, Galilea zu Samaria habaꞌa niduꞌa zamaḡano uniho manoḡa madu inare gigarinu. Ebu ze Zuhiꞌa Boro gubaninu zu Vine Zaḡoḡaniꞌa inarazinu. Eꞌanoꞌo fieꞌeteꞌe azaḡaꞌe bororaunu. ");
INSERT INTO ksj_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Peteroꞌe haba nunu onameꞌeteꞌea, ne ꞌahoga niḡa Luda onamadu Badiꞌa mone azaḡa ḡiaziro. ");
INSERT INTO ksj_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ani eꞌea vaze ꞌahoga, niḡa Ainea hidiro. Aniꞌe ahiꞌa mene haganinu ebu muri fuꞌo uḡidu fare baze daꞌo radiunu. ");
INSERT INTO ksj_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ebu Peteroꞌa niro, “Ainea, Iesu Kerisoꞌa faiꞌeꞌohe. Iḡunadu evaneḡo ḡuoꞌi.” ꞌOuge reirotene, ani zogone iḡuniro. ");
INSERT INTO ksj_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Luda zu Saroni zamaḡano radiuꞌeteꞌe azaḡa niduꞌa Ainea horonadu zamaze ḡihuniro zu Zuhiꞌa Boro mazao firo. ");
INSERT INTO ksj_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","U Iopa neḡano roḡae ꞌahoga, niḡa Tabitaꞌa radiunu. Niḡaꞌe Giriki ḡoeꞌano Doreka. Aniꞌe fieꞌeteꞌe roḡaeḡa, ebu iḡaiḡa haḡai manoḡa haḡainu, zu ḡauze oꞌoꞌa azaḡa danazinu. ");
INSERT INTO ksj_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Eꞌe madaḡano Tabitaꞌa uginadu rudaro, ebu ani virohanadu hitaga neḡano bazune tiro. ");
INSERT INTO ksj_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ludaꞌe Iopa uhiḡano ꞌahine, fieꞌeteꞌe azaḡaniꞌa Peteroꞌe Iopao radiuꞌeteꞌe igiro. Ebu vaze aheu Petero vaḡe tuḡuzadu uminiro, “Ḡa ḡarihe aroꞌi!” ");
INSERT INTO ksj_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ꞌOugadu Peteroꞌa zeḡe aheu teite onamiro. Ze feurirotene, ani hitaga neḡa tutune itiro. Eꞌea ḡozoba niduꞌa Petero edau varahadu niauꞌenaꞌa, zeḡe zizuni dabuaḡa zu raga dabuaḡa nunu ihoniro. Aꞌe Dorekaꞌa ḡabogano turinadu ziniroteꞌe dabuaḡa. ");
INSERT INTO ksj_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peteroꞌa zeḡe niduꞌa tuḡuze buziro ebu obenaḡa hina tuḡadu kuraro. Ebu rune roḡaeḡa moneni ḡianadu niro, “Tabita, iḡunoꞌi!” Ebu Tabita ubumaꞌa raꞌaro ebu Petero ḡianadu iḡune ehoriro. ");
INSERT INTO ksj_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peteroꞌa ꞌevoꞌano Tabita abine mae ḡihine ohoniro. Ebu fieꞌeteꞌe azaḡa zu ḡozoba niduꞌa huzadu Tabitaꞌa ḡabodateꞌe ihoziro. ");
INSERT INTO ksj_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Eꞌe hariḡaꞌe Iopa azaḡa niduꞌa igiro ebu vaze ḡehaḡaniꞌa Zuhiꞌa Boro mazao firo. ");
INSERT INTO ksj_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ebu Peteroꞌe Iopao mada nu radiuꞌeteꞌea, vaze ꞌahoga niḡa Simona neo radiunu. Simonaꞌe boromakau ogaḡa ḡuhadu faineꞌeteꞌe gauḡa haḡainu. ");
INSERT INTO ksj_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Vaze ꞌahoga, niḡa Korunelioꞌa Kaisareao radiunu. Aniꞌe Itali Uti Azaḡa rae huzeꞌeteꞌe Roma uti azaḡa ibitoziꞌeteꞌe vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ani zu ane teite ne tibano radiuꞌeteꞌe azaḡa niduꞌaꞌe zamaze niduꞌa hina Badiꞌa mazao finu zu Badiꞌa gubaninu. Aniꞌe Iuda azaḡa boꞌaḡano tohezeꞌa ferezeꞌeteꞌe azaḡa borofe danazinu, ebu iḡaiḡa Badiꞌa mazao kuraunu. ");
INSERT INTO ksj_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ḡorava ꞌahogano mada uḡidu zamaḡano, ani ahiri raꞌaga iḡunaḡano Badiꞌa tuḡure viganiꞌa ane mazao furera ovariroteꞌe faifaine horoniro. Ebu tuḡure viganiꞌa ꞌahige rae niro, “Korunelio!” ");
INSERT INTO ksj_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Korunelioꞌa ḡiḡaroneꞌenaꞌa, ḡiane runiro ebu ḡadimaro, “Zuhiꞌa Boro, ḡa nougeꞌohe?” Tuḡure viganiꞌa naenaeniro, “Ḡae kuru zu ḡahugoneꞌe Badiꞌaꞌa horonadu ḡa zamare radiuꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Izidi ꞌaha vaze ꞌahoga niḡa Simona zamahanoga veize vaze nu Iopa tuḡuzoꞌi. Simona ni ꞌahogaꞌe Petero. ");
INSERT INTO ksj_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Aniꞌe vaze ꞌahoga, Simona neo radiuꞌohe. Simonaꞌe boromakau ogaḡa ḡuhadu faineꞌeteꞌe vazeḡa. Ani neꞌe davara genaḡano.” ");
INSERT INTO ksj_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tuḡure viganiꞌa Korunelio ḡorenadu dauḡirotene, Korunelioꞌa ane tuḡure azaḡa aheu zu ane uti vazeḡa ꞌahoga huze ariro. Uti vazeḡa aꞌe Badiꞌa mazao faine kurauꞌeteꞌe vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Korunelioꞌa ane mazao fureraroteꞌe niduꞌa ihozadu Iopa tuḡuziro. ");
INSERT INTO ksj_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Korunelioꞌa tuḡuziroteꞌe azaḡaniꞌa onamo irariro, ebu madai kirikiri reirotene Iopa hanitiro. Eꞌe madaḡano Peteroꞌa kuranoga rae ne binuḡa sebaḡa itiro. ");
INSERT INTO ksj_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ebu ani kurauꞌenogano vininadu ogatihi reiro. Ebu vazeꞌa ogomu ꞌize ruhibeꞌeteꞌea, ani ahiri raꞌaga iḡunaḡa horoniro. ");
INSERT INTO ksj_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Eꞌe zamaḡano adureꞌa bohatanoga horoniro, ebu dabua rafaḡa boro heuḡaꞌe ariḡa ḡazaḡano obonadu raha none ovoe dabaneꞌenoga horoniro. ");
INSERT INTO ksj_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Dabua eꞌe zamaḡanoꞌe odaḡa ḡazaḡa maniḡa nunu, rahao dareꞌeteꞌe ḡauḡa nunu, zu adure niniḡa nunu ḡehaḡaniꞌa radiro. ");
INSERT INTO ksj_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ebu ani ago ꞌahoga igiro, “Petero, iḡunoꞌi. Eꞌe manadu anoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Rehano Peteroꞌa naenaeniro, “Zuhiꞌa Boro, a mene hune idaḡa! Eꞌe Iuda azaḡa goro ḡoeꞌano mene deheḡa ga sauꞌa rae huneꞌeteꞌe bonariḡaꞌe mene hune aro.” ");
INSERT INTO ksj_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ꞌOugadu ago aheuḡa bare igiro, “Badiꞌaꞌa deheniroteꞌe bonariḡaꞌe mene deheḡa rae ago roꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Eꞌeguḡaniꞌa ḡae uḡidu fureraroteꞌe ḡarugano dabua rafaḡaꞌe zogone adure ḡoha bare mae itiro. ");
INSERT INTO ksj_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Peteroꞌa ahiri raꞌaga iḡunaḡa eꞌe horonadu hugaꞌe nagini rae zamare ꞌadaꞌadinu. Eꞌe zamaḡano Korunelioꞌa tuḡuziroteꞌe azaḡaniꞌa Simona ne vaḡadu ibihetaḡano edaro. ");
INSERT INTO ksj_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ebu ze huau ḡadimaro, “Vaze ꞌahoga, niḡa Simonaꞌe ꞌahama radiuꞌehe? Ani ni ꞌahogaꞌe Petero.” ");
INSERT INTO ksj_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Peteroꞌa horoniroteꞌe hugaꞌe nagini rae ꞌize zamare radiuꞌeteꞌea, Vine Zaḡoḡaniꞌa niro, “Ḡianoꞌi. Vaze uḡiduꞌa ḡa vaḡeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Iḡunadu ne zamaḡa diuḡi ovoroꞌi. Ago zamare ꞌadaꞌadoꞌi, rehano zeḡe teite onamoꞌi. Zeꞌe eḡeꞌa ḡae vaḡe tuḡuziroteꞌe azaḡa.” ");
INSERT INTO ksj_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Eꞌanoꞌo Peteroꞌa ovoadu zeḡe ziro, “Zaeꞌa vaḡeꞌeteꞌe vazeḡaꞌe eḡe. Za nougadu areha?” ");
INSERT INTO ksj_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Zeḡeꞌa naenaeniro, “Emeꞌe vaze ꞌahoga, Korunelioꞌa tuḡufadu areha. Aniꞌe uti vazeḡa boro. Aniꞌe vaze duduḡa zu Badiꞌa gubaneꞌeteꞌe vazeḡa, zu Iuda azaḡa niduꞌa ani gubaneꞌohe. Ebu tuḡure viganiꞌa Korunelio niro, 'Vaze ꞌahoga, niḡa Petero ḡae ne zamahu aradu ane ḡoere egoꞌi.'” ");
INSERT INTO ksj_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ꞌOugadu Peteroꞌa ne zamaḡano ze mae zouziro ebu ze eꞌea baziro. Irarirotene, Peteroꞌe zeḡe teite iḡuniro. Ebu Iopa zamaḡano fieꞌeteꞌe azaḡa nu zuni ane teite onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ebu onamo ohereranadu irarirotene, Kaisareao feuriro. U Korunelioꞌe nabuga zu ane uhiḡa vazeḡa nu huze nuꞌozadu guhiu radiunu. ");
INSERT INTO ksj_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ebu Peteroꞌa Korunelio neo diuḡirotene, aneꞌa Petero hidadu Petero oda babaḡano ḡuḡuriro. ");
INSERT INTO ksj_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ꞌOugadu Peteroꞌa ani abine ḡihinadu niro, “Iḡunoꞌi. Eḡe zuni vaze tauḡi.” ");
INSERT INTO ksj_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Peteroꞌa Korunelio teite ḡoereꞌenaꞌa ne zamaḡa diuḡirotene, vaze ḡehaḡaniꞌa nuꞌoranoga horoziro. ");
INSERT INTO ksj_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ebu aneꞌa ziro, “Zaꞌe edeḡa, Iuda azaḡa goro ḡoeꞌano Iuda azaḡaniꞌa Iuda mene azaḡa teite unihine ga neze onamineꞌe mene idaḡa. Rehano Badiꞌaꞌa ihoheha, 'Iniu mazao toraga ga sauꞌa rae mene huniꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Eꞌanoꞌo zaeꞌa huhatene, e mene hezahozeadu areha. E ḡadimuꞌohe, nougadu huheha?” ");
INSERT INTO ksj_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korunelioꞌa naenaeniro, “Mada ḡazaḡa modateꞌea, izidi madaḡa heuḡa ḡorava mone mada uḡidu zamaḡano, eꞌe nehe zamaḡano kurau radiro. Eꞌe madaḡano vaze ꞌahoganiꞌa eḡe zamao tabara edaro. Ani dabuaꞌe vazavazahoga. ");
INSERT INTO ksj_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ebu aniꞌa ꞌahige rae reiro, 'Badiꞌaꞌe ḡae kuru iginu zu ḡahugoneḡo zamarinu. ");
INSERT INTO ksj_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ꞌOugadu vaze nu Iopa tuḡuzoꞌi, ebu vaze ꞌahoga, niḡa Simona zamahanoꞌi. Niḡa ꞌahogaꞌe Petero. Aniꞌe vaze ꞌahoga, Simona neo radiuꞌohe. Simonaꞌe boromakau ogaḡa ḡuhadu faineꞌeteꞌe vazeḡa. Ani neꞌe davara genaḡano.' ");
INSERT INTO ksj_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Eꞌanoꞌo e ḡarihe fase tuḡure azaḡa ḡae vaḡe tuḡuzeha, ebu ḡaeꞌa aradu manoḡa tauḡi raꞌohe. Izidi emeḡe niduꞌa Zuhiꞌa Boroꞌa ḡaniroteꞌe ḡoeꞌa niduꞌa egoga veize Badiꞌa zamao ꞌada nuꞌoraneha.” ");
INSERT INTO ksj_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ebu Peteroꞌa ḡoere ḡadaheniro, “E izidi hube hune edereha, Badiꞌaꞌe vaze mazao mene inaheꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Haba niduꞌa zamaḡano Badiꞌa gubaneꞌeteꞌe zu haḡai duduḡa haḡaeꞌeteꞌe azaḡaꞌe Badiꞌaꞌa mae ḡihizeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Zaꞌe edeḡa, Badiꞌaꞌa Isaraela azaḡa mazao hari manoḡa tuḡuniro. Aꞌe Iesu Keriso mazaonoꞌo zama roḡeḡa meiteꞌe hariḡa manoḡa. Iesuꞌe vaze niduꞌa Zuhiꞌa Boro. ");
INSERT INTO ksj_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Zaꞌe edeḡa, ibite Ioaneꞌa babatiso moneo haramiroteꞌe enogano, Galilea habaꞌanonoꞌo onamo Iudea habaꞌa niduꞌa zamaḡano naginiꞌa fureraro. ");
INSERT INTO ksj_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Badiꞌaꞌa Nazareta vazeḡa Iesu Vine Zaḡoḡa zu gigiꞌa haro. Ebu ani ragaveꞌenaꞌa haḡai manoḡa haḡainu zu vine sauꞌaniꞌa ragano reiroteꞌe azaḡa niduꞌa faizinu, mazaḡa Badiꞌaꞌe ane teite radiunu. ");
INSERT INTO ksj_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Eme Iesuꞌa Iuda azaḡa haba niduꞌa zu Ierusalema zamaḡano haḡainuteꞌe haḡaiḡa niduꞌa horonadu rae fureneꞌohe. Vazeꞌa ani satauroneadu mau runiro. ");
INSERT INTO ksj_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Rehano aniꞌe Badiꞌaꞌa mada uḡiduḡano bare ḡaboniro ebu vaze zamao furenoziniro. ");
INSERT INTO ksj_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Vaze niduꞌa ani mene horoniro, rehano Badiꞌaꞌa ohotadu ane hari rae fureneꞌeteꞌe azaḡa, emeḡe mazao fureniro. Aneꞌa rune azaḡa boꞌaḡano bare ḡabode iḡuniroteꞌe enogano, emeꞌe ani teite ogaro ebu gagiro. ");
INSERT INTO ksj_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ebu aniꞌa ꞌahige ifiro, 'Badiꞌaꞌa eꞌe ḡabone azaḡa zu rune azaḡa kotazeꞌeteꞌe vazeḡano ohohirotaꞌaꞌe vaze niduꞌa mazao rae furenoꞌi zu haramoꞌi!' ");
INSERT INTO ksj_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Peroveta azaḡa niduꞌa ani moneo rae fureniro, 'Iesu mazao fieꞌeteꞌe azaḡa niduꞌa Iesu niḡano haḡaize sauꞌa aḡutu modiꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Peteroꞌa ꞌize ḡoere eꞌe harame radiuꞌeteꞌea, ane ḡoere igi radiroteꞌe azaḡa niduꞌa mazao Vine Zaḡoḡaniꞌa ovairo. ");
INSERT INTO ksj_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","U Iuda azaḡa boꞌaḡano Iesu mazao fieꞌeteꞌe azaḡa nuꞌa Petero teite aradu ehore radiunu. Ze Iuda mene azaḡa mazao zuni Badiꞌaꞌa Vine Zaḡoḡa beꞌunadu iriꞌavoziroteꞌe horonirotene, zaguzagaro. ");
INSERT INTO ksj_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Mazaḡa Iuda mene azaḡaniꞌa mazane ḡoeꞌa hina ḡoereꞌeteꞌe zu Badiꞌa niguneꞌeteꞌe igiro. Ebu Peteroꞌa ziro, ");
INSERT INTO ksj_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Emeḡe teige ze Vine Zaḡoḡa maha. Eꞌanoꞌo zeḡe zuni vu hina babatiso mougaꞌe idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ꞌOugadu Peteroꞌa Korunelio duḡuru ziro, “Iesu Keriso niḡano babatiso moꞌi.” Ebu ze Peteroꞌa zeḡe teite mada nu radoga uminiro. ");
INSERT INTO ksj_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apostolo azaḡa zu Iudea habaꞌano fieꞌeteꞌe azaḡaniꞌa Iuda mene azaḡa zuni Badiꞌa ḡoere mae ḡihiniroteꞌe igiro. ");
INSERT INTO ksj_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Eꞌanoꞌo Peteroꞌa Ierusalema itirotene, Iuda azaḡa fieꞌeteꞌeꞌa Petero roniro, ");
INSERT INTO ksj_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Ḡaꞌe Iuda mene azaḡa ne diuḡadu zeḡe teite ogau tiburaro.” ");
INSERT INTO ksj_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ꞌOugadu Peteroꞌa naginiꞌa fureraroteꞌe niduꞌa doḡoꞌani rae furenoziniro, ");
INSERT INTO ksj_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Eꞌe Iopao radadu kurauꞌeteꞌea ahiri raꞌaga iḡunaḡa horoniro. Eꞌe zamaḡano dabua rafaḡa boro heuḡa ariḡa ḡazaḡano obonadu adureonoꞌo ovoe dabaniro ebu eḡe uhiḡano ovairo. ");
INSERT INTO ksj_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Eꞌe zamaḡa faine ḡianirotene, rahao odaḡa ḡazaḡa maniḡa nunu, butu agire maniḡa nunu, dareꞌeteꞌe ḡauḡa nunu, zu adure niniḡa nunu horoziro. ");
INSERT INTO ksj_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ebu ago ꞌahoga igiro, 'Petero, iḡunoꞌi ebu manadu anoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","E naenaeniro, 'Zuhiꞌa Boro, a mene hune idaḡa! Eꞌe Iuda azaḡa goro ḡoeꞌa zamaḡano mene deheḡa ga sauꞌa rae huneꞌeteꞌe bonariḡa mene hune aro.' ");
INSERT INTO ksj_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Rehano ago eꞌe aheuḡa igiro, 'Badiꞌaꞌa deheniroteꞌe bonariḡaꞌe mene deheḡa rae ago roꞌi.' ");
INSERT INTO ksj_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Eꞌeguḡaniꞌa ḡae uḡidu fureraroteꞌe ḡarugano, dabua rafaḡa zu eꞌe rana tiroteꞌe ḡauḡa niduꞌa adure ḡoha bare mae itiro. ");
INSERT INTO ksj_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ꞌOugirotene, Kaisareaonoꞌo tuḡuziroteꞌe azaḡa uḡiduꞌa eḡeꞌa radiroteꞌe neḡano feuri ariro. ");
INSERT INTO ksj_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ebu Vine Zaḡoḡaniꞌa ihiro, 'Zeḡe teite onamoꞌi. Zeḡe uꞌano ago zamare adudanoꞌi.' Eꞌanoꞌo ekalesia nego fuꞌo tiba fare ꞌadaꞌa ḡatiheꞌenaꞌa, Kaisarea ovoadu huhiroteꞌe vazeḡa ne onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ebu vaze eꞌeꞌa ane neo tuḡure viganiꞌa fureraroteꞌe hariḡa rae furenofiro. Tuḡure viganiꞌa ꞌahige rae niro, 'Vaze nu Iopa tuḡuzadu vaze ꞌahoga niḡa Simona zamahu aroꞌi. Niḡa ꞌahogaꞌe Petero. ");
INSERT INTO ksj_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Aniꞌa ḡorezadu ḡa zu ḡae teite ne tibano radiuꞌeteꞌe azaḡa niduꞌa ane ḡoere igiꞌuma ebu ḡabone hidiꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ebu eḡeꞌa ḡoere ḡadahirotene, ibite Vine Zaḡoḡaniꞌa emeḡe vaḡe ovairoteꞌe teige, zeḡe vaḡe ovairo. ");
INSERT INTO ksj_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ꞌOugirotene, e Iesuꞌa ifiroteꞌe ḡoeꞌa zamariro, 'Ioaneꞌe vu hina babatisoziro, rehano zaꞌe Vine Zaḡoḡa hina babatiso meꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ebu emeꞌa Zuhiꞌa Boro Iesu Keriso mazao firoteꞌe madaḡano Badiꞌaꞌa ḡahunone rifiroteꞌe teige, Iuda mene azaḡa zuni ḡahunone ziniro. Eꞌanoꞌo eꞌe Badiꞌa gau ꞌuoga mene hune idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Zeḡeꞌa eꞌe igirotene, mene bare ḡoeriro. Ebu ze Badiꞌa niguneꞌenaꞌa, ꞌahige rae reiro, “Badiꞌaꞌe Iuda mene azaḡa zuni ḡihuzadu ḡabone hiditeꞌe ibiḡa ziniro.” ");
INSERT INTO ksj_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stefano maroteꞌe madaḡanonoꞌo fieꞌeteꞌe azaḡa zuni sausauzadu ze Ierusalemaonoꞌo habaꞌahabaꞌano ferau ḡouriro. Ze Fonikia habaꞌa, Kupuro ꞌumuḡa, zu Siria habaꞌano Antioka zu onamadu Iuda azaḡa mazao daꞌo hari manoḡa haramiro. ");
INSERT INTO ksj_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Rehano Kupuro zu Kurene azaḡa nuꞌa Antioka onamadu Giriki azaḡa mazao zuni Zuhiꞌa Boro Iesu hariḡa haramiro. ");
INSERT INTO ksj_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Zuhiꞌa Boro gigiꞌaḡaniꞌa zeḡe rana radiunu ꞌahine, vaze ḡehaḡaniꞌa Zuhiꞌa Boro mazao firo ebu Zuhiꞌa Boro vaḡe ariro. ");
INSERT INTO ksj_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Eꞌe hariḡaꞌe Ierusalema ekalesia azaḡaniꞌa egadu Banabasiꞌe Antioka tuḡune onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ani Antiokao feurirotene, Badiꞌaꞌa zeḡe mazao manoḡa fureniroteꞌe horonadu matuꞌe rudaro. Ebu zeḡe niduꞌa inaraziro, “Zamaze niduꞌa hina Zuhiꞌa Boro mazao fie gigaru radoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabasiꞌe vaze manoḡa zu hube hune fieꞌeteꞌe vazeḡa. Vine Zaḡoḡaniꞌa ane mazao iriꞌaviro. ꞌOugadu vaze ḡehaḡa bagaḡaniꞌa Zuhiꞌa Boro vaḡe ariro. ");
INSERT INTO ksj_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ebu Banabasiꞌa Saulo vaḡe Taso onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ebu Saulo horonirotene, zamahanadu Antioka bare onamiro. Ebu ze muri tiba eꞌea radiuꞌenaꞌa, ekalesiaḡa azaḡa teite nuꞌoranadu vaze ḡehaḡa bagaḡa ihozinu. Antioka zamaḡano fieꞌeteꞌe azaḡaꞌe Kirisiteni Azaḡa rae ḡadahe huziro. ");
INSERT INTO ksj_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Eꞌe madaḡano peroveta azaḡa nuꞌa Ierusalemaonoꞌo Antioka ovairo. ");
INSERT INTO ksj_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Zeḡe boꞌaḡano vaze ꞌahoga, niḡa Agaboꞌe Vine Zaḡoḡaniꞌa ibitohanadu nu'onu'o zamaḡano iḡune edaro, ebu ꞌahige rae fureniro, “Haba niduꞌa zamaḡano zahara boroꞌa fureraꞌuma.” Eꞌe enogano Kulaudioꞌa Roma zuhiꞌaziroteꞌe madaḡano zahara boroꞌa fureraro. ");
INSERT INTO ksj_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Eꞌanoꞌo Antioka ekalesia azaḡaꞌe aneane inarao hadi nuꞌonadu Iudea habaꞌano fieꞌeteꞌe azaḡa veize tuḡuriꞌuma rae ḡoereze idaniro. ");
INSERT INTO ksj_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ebu ze hadi nuꞌone hauḡirotene, Banabasi zu Saulo ꞌevoreo riꞌinadu Ierusalema ekalesia boroboro veize odohe onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Eꞌe madaḡano kini Heroda Aguripaꞌa Ierusalema ekalesia azaḡa nu sausauzoga rae oboze tiro. ");
INSERT INTO ksj_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ebu aneꞌa Ioane negoḡa, Iakobo benisi hina mau runiro. ");
INSERT INTO ksj_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ꞌOugiroteꞌe moneo Iuda azaḡaniꞌa matuꞌeꞌeteꞌe aneꞌa horonirotene, Petero zuni obone tihi reiro. Mada aꞌe Isiti Oꞌoꞌa ꞌUvahu Odoga Muiḡa madaḡa. ");
INSERT INTO ksj_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Aniꞌe Petero obone teadu ḡuꞌa neḡano ohoniro ebu uti azaḡa ꞌevora tiro. Petero ḡiane radiroteꞌe uti azaḡa niduꞌaꞌe 16, ebu vaze ḡazaḡaḡazaḡano ohozadu mada niduꞌa ḡiane radiunu. Heroda uraꞌe Iḡine Modiroteꞌe Muiḡa enogano ani mae bunadu hunio kotaniꞌuma reiro. ");
INSERT INTO ksj_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ꞌOugadu Peteroꞌe ḡuꞌa neḡano ohone tiro. U ekalesia azaḡaꞌe ane veize Badiꞌa mazao inare kuraunu. ");
INSERT INTO ksj_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herodaꞌa ohoḡore Petero kotaniꞌuma rae reiroteꞌe oheꞌano, Peteroꞌe auri adiriḡa aheu hina batunadu uti azaḡa aheu boꞌaḡano baze radiunu, ebu uti azaḡa nuꞌe ḡuꞌa neḡa ibihetaḡano edau radiro. ");
INSERT INTO ksj_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Eꞌe zamaḡano Zuhiꞌa Boro tuḡure viganiꞌa tabara fureraro, ebu ḡuꞌa neḡa zamaḡaꞌe agaḡaniꞌa aganiro. Tuḡure viganiꞌa Petero rebeḡa moneo faꞌofaꞌonadu evaniro ebu niro, “Ḡarihe iḡunoꞌi!” ꞌOugirotene, auri adiriḡaniꞌa ꞌevoꞌanonoꞌo butau buaro. ");
INSERT INTO ksj_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ebu tuḡure viganiꞌa niro, “Kibaꞌiḡo rinedoꞌi ebu tamakaḡo haḡaoꞌi.” Ebu ani ꞌouge haḡairo. Tuḡure viganiꞌa bare niro, “Raga dabuaḡa vidanadu eḡe hegote aroꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Peteroꞌa ḡuꞌa neḡanonoꞌo tuḡure viga hegote buaro, rehano ani tuḡure viganiꞌa haḡairotaꞌaꞌe huga rae mene ederiro. Aniꞌe ahiri raꞌaga iḡunaḡa horoneha rae zamariro. ");
INSERT INTO ksj_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Zeꞌe uti azaḡaniꞌa ḡiane radiuꞌeteꞌe ibihetaḡa aheu vitiniro. Ebu enone auri ibihetaḡano feuri arirotene, eꞌe ibihetaḡa aneꞌa bare bohataro. Ze buau onamadu mene faḡa onamirotene, tuḡure viganiꞌa tabara muhiniro. ");
INSERT INTO ksj_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ebu Peteroꞌe zamaḡaniꞌa bohatanadu ꞌahige rae reiro, “E izidi edereha, ꞌahiꞌe hube hune! Zuhiꞌa Boroꞌa ane tuḡure viga tuḡunadu Heroda ꞌevoꞌanonoꞌo zu Iuda azaḡaniꞌa toganiroteꞌe haḡaiḡa sauꞌa niduꞌaonoꞌo mae vaḡiheha!” ");
INSERT INTO ksj_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ꞌOuge ederirotene, Peteroꞌa Ioane viꞌa Maria ne onamiro. Ioane niḡa ꞌahogaꞌe Mareko. Vaze ḡehaḡaniꞌa ane neo nuꞌoranadu kurau radiunu. ");
INSERT INTO ksj_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Peteroꞌa enone ibihetaḡano toketokerirotene, tuḡure roḡaeḡa ꞌahoga, niḡa Rodaꞌa ḡianoga rae onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ani Petero ago igirotene, matuꞌe rudanadu ibihetaꞌe vavaꞌoga aḡutaro, rehano ne bare dure diuḡadu ziro, “Peteroꞌa ibihetao edauꞌohe!” ");
INSERT INTO ksj_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Rehano zeḡeꞌa niro, “Ḡa vadiniḡoꞌa sautaneha!” Ebu aniꞌa barebare ziro, “A hube!” ꞌOugadu zeḡeꞌa niro, “Aꞌe Petero tuḡure viga!” ");
INSERT INTO ksj_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Eꞌe zamaḡano Peteroꞌa barebare toketokeriro. Ebu ze iḡunadu ibiheta vavaꞌirotene, Petero horonadu zaguzagau rudaro. ");
INSERT INTO ksj_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Peteroꞌa ꞌevoꞌa hina garareꞌenaꞌa, “Ago haraoꞌi,” rae radu Zuhiꞌa Boroꞌa nougenouge ḡuꞌa neḡanonoꞌo ani mae buniroteꞌe meꞌodoziniro. Ebu aniꞌa ziro, “Hari ꞌahi Iakobo zu fieꞌeteꞌe azaḡa ihozoꞌi.” Ebu aniꞌe muhizadu haba ꞌahoga onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Irarirotene, ḡuꞌa neḡa ḡiane radiroteꞌe uti azaḡaꞌe Peteroꞌa dauḡiroteꞌe uꞌano harae iḡuniro. ");
INSERT INTO ksj_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Heroda Aguripaꞌa uti azaḡa tuḡuzadu Petero faifaine vaḡiro rehano, mene horoniro. ꞌOugadu Petero ḡiane radiroteꞌe uti azaḡa ḡadiḡadiziro ebu zimiꞌuma rae radu ḡoere riḡa ziro. Ebu Herodaꞌa Iudea habaꞌanonoꞌo iḡunadu Kaisarea ovoiro ebu eꞌea mada nu radiro. ");
INSERT INTO ksj_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Heroda Aguripaꞌe Turo zu Sidono azaḡa mazao maḡune radiunu. Eꞌanoꞌo Turo zu Sidono azaḡaꞌe tiburanadu Heroda ḡiani onamiro. Zeꞌe Heroda ne taufeꞌeteꞌe tuḡure vazeḡa boro ꞌahoga, niḡa Balasito teite vazetitadu Heroda teite bare uniho manoḡa meihi reiro. Mazaḡa ze kini Herodaꞌa zuhiꞌaziꞌeteꞌe habaꞌano radiunu ꞌahine, ogomuze zuni ani mazaonoꞌo meinu. ");
INSERT INTO ksj_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ze Heroda ḡianiteꞌe madaḡa meirotene, aniꞌa kini dabuaḡa haḡadu kini ehoro habaꞌano ehoriro, ebu zeḡe niduꞌa mazao haramiro. ");
INSERT INTO ksj_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ebu ze ḡihau bagaḡa huaro, “ꞌAhiꞌe mene vaze ḡoere, rehano badiꞌa ḡoere!” ");
INSERT INTO ksj_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ꞌOugirotene, Zuhiꞌa Boro tuḡure viganiꞌa zogone Heroda ugi boro haro. Mazaḡa aniꞌe vazevazeꞌa ani nigunirotene, Badiꞌa mene niguniro, rehano ani aneꞌa bare niguniro. Ebu idiꞌa ahiꞌa anadu rudaro. ");
INSERT INTO ksj_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","U Badiꞌa ḡoereꞌe bororu onamiro ebu vaze ḡehaḡaniꞌa egadu mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabasi zu Sauloꞌe ekalesia azaḡa hadi zini onamiroteꞌe gauḡa hauḡadu Ierusalemaonoꞌo Antioka bariro. Ze Ioane zuni zamahu onamiro. Ioane niḡa ꞌahogaꞌe Mareko. ");
INSERT INTO ksj_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioka ekalesiaḡa zamaḡano peroveta azaḡa zu ihore azaḡaꞌe eꞌe. Nizeꞌe Banabasi, Simeona (niḡa ꞌahogaꞌe Nigera), Kurene vazeḡa niḡa Lukio, ebu Manaena (aniꞌe kini Heroda Antipa teite bororaroteꞌe vazeḡa), ebu Saulo. ");
INSERT INTO ksj_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ze ogomu moneo zaḡozaḡeꞌenaꞌa, Zuhiꞌa Boro mazao kurau radiuꞌeteꞌe zamaḡano Vine Zaḡoḡaniꞌa ziro, “Banabasi zu Sauloꞌe eḡe veize avo ohozoꞌi. E zeꞌe eḡe gau haḡaifine ohotiro.” ");
INSERT INTO ksj_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Eꞌanoꞌo ze ogomu moneo zaḡozaḡeꞌenaꞌa kuraroteꞌe enogano, ꞌevoreze Banabasi zu Saulo rana teadu kuraro ebu hena tuḡuze onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Paulo zu Banabasiꞌe Vine Zaḡoḡaniꞌa tuḡuzadu Seleukia toḡatoḡa ovoiro, ebu eꞌeanoꞌo ḡasi hina Kupuro ꞌumuḡa ruhau fariro. ");
INSERT INTO ksj_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ebu Salamio feurirotene, Iuda azaḡa nuꞌonuꞌo neḡaneḡa diuḡadu Badiꞌa ḡoere haramiro. Ioane zuni zeḡe danazoga veize ḡatiziro. ");
INSERT INTO ksj_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ze eꞌe ꞌumuḡano ne niduꞌa ragave onamo Pafoo feuriro. Eꞌea Iuda vazeḡa ꞌahoga, niḡa Bari-Iesu hidiro. Aniꞌe nabone zu ḡuriro peroveta vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ani eꞌe ꞌumuḡa gavanaḡa teite vazete radiunu. Gavana vazeḡa niḡaꞌe Seregio Paulo. Ani vaze huhuzaḡa radu Badiꞌa ḡoere egoga veize Banabasi zu Saulo huze ariro. ");
INSERT INTO ksj_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Rehano Eluma rae huneꞌeteꞌe nabone vazeḡa eꞌeꞌa Banabasi zu Saulo ḡoere ꞌuihi radu ḡunuḡunuziro, mazaḡa ani gavana vazeḡaniꞌa Iesu mazao fioga mene uratiro. ");
INSERT INTO ksj_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Eꞌanoꞌo Paulo rae huneꞌeteꞌe vazeḡa, Sauloꞌe Vine Zaḡoḡaniꞌa iriꞌavonadu Eluma ḡiane runeꞌenaꞌa, ꞌahige rae reiro, ");
INSERT INTO ksj_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Ḡaꞌe Satani ubuga zu haḡai duduḡa niduꞌa agirohauꞌeteꞌe vazeḡa. Sauꞌa zu soꞌosoꞌo haḡaiḡaniꞌa ḡae zama iriꞌavoniro. Zuhiꞌa Boro ibi duduḡa beꞌoneꞌeteꞌe haḡaiḡa modoꞌi! ");
INSERT INTO ksj_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Izidi Zuhiꞌa Boroꞌa ꞌevoꞌa gigiꞌa hina aduga ḡanadu ḡaꞌe ubumaḡoꞌa kuraꞌuma, ebu mada nu agaḡa horonoga mene idaraꞌuma.” ꞌOugadu ḡoze zu uzaboꞌa ubumaḡa zogone ꞌuiro ebu tufatufeꞌenaꞌa ꞌevoꞌano abiniteꞌe vazeḡa vaḡiro. ");
INSERT INTO ksj_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ebu gavana vazeḡaꞌe naginiꞌa fureraroteꞌe horonadu Zuhiꞌa Boro mazao firo, ebu Zuhiꞌa Boro ihoreḡa ederadu zaguzagaro. ");
INSERT INTO ksj_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo zu ane ḡatiniroteꞌe azaḡaꞌe Pafoonoꞌo iḡunadu Pamufulia habaꞌano Perega toḡatoḡa ḡasi hina ruhau onamiro. Rehano Ioaneꞌe Paulo duḡuru muhizadu Ierusalema bare onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Zeꞌe Perega toḡatoḡaonoꞌo onamo Pisidia habaꞌano Antiokao feuriro, ebu Bana Madaḡano nuꞌonuꞌo neḡa diuḡadu ehoriro. ");
INSERT INTO ksj_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Nuꞌonuꞌo neḡa vaze boroboroꞌa Mose goro ḡoeꞌa zu peroveta azaḡa ḡoere meꞌodiroteꞌe enogano, Paulo duḡuru veize ḡoere tuḡuriro, “Negofe duḡuru, za emeḡe veize inara ḡoeꞌa nu eꞌe roꞌidene haramofo'i.” ");
INSERT INTO ksj_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Eꞌanoꞌo Pauloꞌa iḡunadu ze ani ḡoere egoga veize ꞌevoꞌa mae ḡihiniro ebu ḡoeꞌa ḡadahiro, “Isaraela azaḡa, zu Iuda mene azaḡa boꞌaḡano Badiꞌa gubaneꞌeteꞌe azaḡa, egoꞌi. ");
INSERT INTO ksj_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Isaraela azaḡa Badiꞌaꞌa vouḡafe duḡuru ohotiro. Ebu zeḡeꞌa Izipi habaꞌano radiunuteꞌea, Badiꞌaꞌa danazadu ze ḡehararo zu inariro, ebu ane gigiꞌa boro hina Izipi habaꞌanonoꞌo tutuze buziro. ");
INSERT INTO ksj_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ebu muri 40 haba bohaꞌano zeꞌe Badiꞌa ḡoere mene ego haunu rehano, ani zamaḡa obone tiro. ");
INSERT INTO ksj_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ebu Kanana habaꞌano haba fuꞌo aheu fare azaḡaꞌe aniꞌa zimi hauḡadu habazeꞌe Isaraela azaḡa ziniro. ");
INSERT INTO ksj_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ebu muri 450 ze haba eꞌe niduꞌa zamaḡano radiunu. Ebu Badiꞌaꞌa Isaraela azaḡa ibitoziꞌeteꞌe azaḡa tibatiba ohoze onaminu, onamo peroveta vazeḡa Samuelaꞌa fureraro. ");
INSERT INTO ksj_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ebu Isaraela azaḡaꞌe kini uratadu aniꞌa Saulo ohonadu ziniro. Sauloꞌe Kisa ubuga, Beniamini urabo vazeḡa. Ani muri 40 Isaraela azaḡa zuhiꞌaziro. ");
INSERT INTO ksj_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Rehano Badiꞌaꞌa Sauloꞌe kini iḡuꞌanonoꞌo mae vaḡinadu Davidaꞌe kini iḡuꞌano ohoniro. Ebu Davida moneo aneꞌa ꞌahige rae reiro, 'E Iese ubuga Davida horonirotene, zamaheꞌa matuꞌeꞌohe. Ani eḡeꞌa urateꞌeteꞌe gauḡa niduꞌa haḡaiꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Badiꞌaꞌa ibite ḡoitoriroteꞌe idunaḡano, Davida marigaonoꞌo vaze ḡaboziteꞌe vazeḡa ꞌahoga ohonadu Isaraela azaḡa mazao tuḡuniro, aꞌe Iesu. ");
INSERT INTO ksj_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ani ꞌizema arogano, Ioaneꞌa Isaraela azaḡa niduꞌa mazao haramiro, 'Haḡaize sauꞌanonoꞌo ḡihuradu babatiso moꞌi!' ");
INSERT INTO ksj_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ioaneꞌa ane gau nariga hauḡirotene, ꞌahige rae reiro, 'Zaeꞌa eꞌe iniu rae zamareꞌohe? Eꞌe mene Keriso. Aniꞌe eḡe ḡaruna ariteꞌe vazeḡa. Eḡe'a ani tamaka miniḡa fuhiꞌeꞌeteꞌe tuḡureḡa vazeḡa rae rouga zuni mene idaḡa. Aniꞌe eḡe vitihoga.'” ");
INSERT INTO ksj_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ebu Pauloꞌa ꞌaune ḡoeriro, “Nego nabudi, Aberahamo mariga, zu Iuda mene azaḡa boꞌaḡano Badiꞌa gubaneꞌeteꞌe azaḡa, Badiꞌaꞌa vaze ḡaboziteꞌe ḡoeꞌa emeḡe veize tuḡuriro. ");
INSERT INTO ksj_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Rehano Ierusalema azaḡa zu zeḡe ibitoziꞌeteꞌe azaḡaniꞌa Iesuꞌe Keriso rae mene ederiro. Ze Bana Madaḡa niduꞌa zamaḡano peroveta azaḡa ḡoere meꞌodinu rehano, eꞌe hugaꞌe mene ederiro. Eꞌe uꞌano, ze Iesuꞌe veꞌoḡa rae kotanadu peroveta azaḡa ḡoere hegote haḡae huniro. ");
INSERT INTO ksj_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Zeꞌe Iesu runeo tuḡuniteꞌe mazaḡa mene horoniro rehano, satauroneadu rudanoga veize Pilato uminiro. ");
INSERT INTO ksj_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ze Buka Zaḡoḡano Iesu moneo mirihiroteꞌe ḡoeꞌa niduꞌa ane mazao haḡae hauḡirotene, satauronoꞌo mae bunadu idu zamaḡano tiro. ");
INSERT INTO ksj_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Rehano Badiꞌaꞌa rune azaḡa boꞌaḡano bare ḡaboniro. ");
INSERT INTO ksj_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ebu Iesuꞌe ibite Galilea habaꞌanonoꞌo ane teite Ierusalema itiroteꞌe azaḡa mazao mada ḡehaḡa zamaḡano fureraunu. Zeꞌe izidi Isaraela azaḡa mazao eꞌe hariḡa meꞌode fureneꞌeteꞌe azaḡa. ");
INSERT INTO ksj_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Eme izidi ꞌada Badiꞌaꞌa amahi vouḡafe mazao ḡoitoriroteꞌe hariḡa manoḡa rae fureneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Aniꞌe Iesu runeonoꞌo bare ḡabonadu ane ḡoitore ḡoeꞌa vouḡafe mariga, emeḡe mazao haḡae huniro. Aꞌe Salamo aheuḡa zamaḡano ꞌahige rae mirihiro, 'Ḡaꞌe eḡe Ubude, izidi eꞌe ḡae Mogo raha.' ");
INSERT INTO ksj_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Badiꞌaꞌa rune azaḡa boꞌaḡano Iesu bare ḡaboniro zu ahiꞌaꞌe mene hune ruhuraꞌuma rae reiro. Aꞌe Buka Zaḡoḡano ꞌahige rae mirihiro, 'Eꞌe Davida mazao ḡoitoriroteꞌe manohugaḡa zaḡoḡa zae ziniꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ebu Salamo ꞌahogano zuni ꞌahige rae mirihiro, 'Zuhiꞌa Boro, ḡa ḡae Vaze Zaḡoḡa ahiꞌaniꞌa ruhuranoga radu iduo mene modiꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Davidaꞌe ane radone niduꞌa zamaḡano Badiꞌa ura haḡadu rudaro. Ebu ane zuni vouḡaḡa idu habaꞌano guradu ahiꞌaꞌe ruhuraro. ");
INSERT INTO ksj_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","U Badiꞌaꞌa bare ḡaboniroteꞌe vazeḡa ꞌahiꞌaꞌe mene ruhuraro. ");
INSERT INTO ksj_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Eꞌanoꞌo, nego nabudi, ꞌahi ederoꞌi. Iesu uꞌano, Badiꞌaꞌa zae haḡai sauꞌa aḡutu modiꞌuma rae raꞌeteꞌe hari manoḡaꞌe zae mazao rae fureneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mose goro ḡoeꞌanonoꞌo zaꞌe Badiꞌa ubumao duduḡa rouga mene idararo. Rehano Iesu mazao fieꞌeteꞌe azaḡa niduꞌaꞌe haḡaize sauꞌanonoꞌo bohaze buzadu Badiꞌa ubumao duduḡa raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Eꞌanoꞌo peroveta azaḡaniꞌa reiroteꞌe ḡauḡaniꞌa zae mazao mene fureranoga veize tohutohoꞌi. ");
INSERT INTO ksj_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ze ꞌahige rae reiro, 'Ḡianoꞌi, za, e ḡirihohiꞌeteꞌe azaḡa! Zaguzaganoꞌi, ebu rudanoꞌi! Eḡeꞌa zae radone zamaḡano haḡai ꞌahoga fureniꞌuma. Iniuꞌa haḡai eꞌe moneo zae ihozine zuni, zaꞌe mene hune mae ḡihiniꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulo zu Banabasiꞌa nuꞌonuꞌo neḡanonoꞌo buarotene, eꞌea kuraroteꞌe azaḡaniꞌa Bana Madaḡa ꞌahogano zuni ze ꞌuguḡa ḡoeꞌa bare ḡorezoga veize umiziro. ");
INSERT INTO ksj_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Vazeꞌa rururu ḡouriroteꞌe enogano, Iuda azaḡa zu Iuda mene azaḡa boꞌaḡano Badiꞌa mone ḡihuriroteꞌe azaḡa ḡehaḡaniꞌa Paulo zu Banabasi hegotiro. Ebu Paulo zu Banabasiꞌa ꞌahige rae iraduguziro, “Badiꞌaꞌa fureneꞌeteꞌe manoḡaḡa zamaḡano radiuꞌenoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Bana Madaḡa ꞌahoga bare meirotene, ne eꞌe azaḡaꞌe nariga niduꞌa Zuhiꞌa Boro ḡoere egoga veize nuꞌoraro. ");
INSERT INTO ksj_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Rehano Iuda azaḡaꞌe vaze ḡehaḡaniꞌa nuꞌoraroteꞌe horonirotene, ze ahiahiꞌa iriꞌavozadu Pauloꞌa haramiroteꞌe ḡoeꞌa moneo taꞌirotitiro zu rae sausauniro. ");
INSERT INTO ksj_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Rehano Paulo zu Banabasiꞌe mene rihauꞌenaꞌa, ḡoeriro, “Eme ibite geno za Iuda azaḡa veize Badiꞌa ḡoere rae furenifo. Rehano izidi zaꞌe Badiꞌa ḡoere hezahohanadu za zaeꞌa bare ḡabone tuḡutuḡu mene meiteꞌe azaḡa reiro. Eꞌanoꞌo eme izidi Iuda mene azaḡa veize harame onameꞌeꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Mazaḡa Zuhiꞌa Boroꞌa ḡoere riḡa ꞌahi ifiro, 'Eḡeꞌa ḡaꞌe ihure agaḡa teige, Iuda mene azaḡa veize ohoꞌiro. Aꞌe ḡaeꞌa haba niduꞌa zamaḡano vaze ḡaboziteꞌe hariḡa manoḡa ihozifine raꞌohe.'” ");
INSERT INTO ksj_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Iuda mene azaḡaniꞌa eꞌe igirotene, zeꞌe matuꞌeꞌenaꞌa, Zuhiꞌa Boro ḡoere niguniro. Ebu ḡabone tuḡutuḡu mouga veize Badiꞌaꞌa ohotiroteꞌe azaḡaꞌe Iesu mazao firo. ");
INSERT INTO ksj_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ꞌOugadu Zuhiꞌa Boro ḡoereꞌe eꞌe habaꞌa niduꞌa zamaḡano ḡehararo. ");
INSERT INTO ksj_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Rehano Iuda azaḡaꞌe Iuda roḡae boroboro Badiꞌa gubaneꞌeteꞌe, zu ne azaḡa ibitoziꞌeteꞌe azaḡa tutuzadu Paulo zu Banabasi sausauzoga rae haraharaziro, ebu eꞌe habaꞌanonoꞌo hegoze vaḡiziro. ");
INSERT INTO ksj_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Eꞌanoꞌo ze odaze huꞌuruḡa zauhe modadu Ikonio onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Fieꞌeteꞌe azaḡaꞌe matuꞌe rudaro zu Vine Zaḡoḡaniꞌa iriꞌavoziro. ");
INSERT INTO ksj_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Paulo zu Banabasiꞌa Ikonio onamiro. Ebu ze iḡaiḡa haḡainuteꞌe teige Iuda azaḡa nuꞌonuꞌo neḡano diuḡadu haramiro. Ze doḡoꞌani haramiro ꞌahine, Iuda azaḡa zu Giriki azaḡa ḡehaḡa bagaḡaniꞌa Iesu mazao firo. ");
INSERT INTO ksj_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Rehano mene fieꞌeteꞌe Iuda azaḡaniꞌa Iuda mene azaḡa zamaze ḡunuḡununadu Iuda mene azaḡa zuni Paulo duḡuru agirozifine zamaze aro. ");
INSERT INTO ksj_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Paulo zu Banabasiꞌe eꞌea faḡa hune radadu mene rihauꞌenaꞌa, Zuhiꞌa Boro veize inare haramiro. Zuhiꞌa Boroꞌa inaraḡa boro zenadu ze haḡai nu badeḡa zu zaguzagatiteꞌe haḡaiḡa haḡairo. ꞌOugadu ze Badiꞌaꞌa manoḡa fureniroteꞌe moneo haramiro, ebu Badiꞌaꞌa zeḡe haramoꞌe huga rae ihoziro. ");
INSERT INTO ksj_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Rehano eꞌe neḡa azaḡaꞌe rovotadu nuꞌe Iuda azaḡa mone reiro, u nuꞌe apostolo azaḡa mone reiro. ");
INSERT INTO ksj_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ebu Iuda mene azaḡa nu zu Iuda azaḡa nuꞌa ze ibitoziꞌeteꞌe azaḡa teite tiburanadu, Paulo zu Banabasi rae sausauzoga ebu hadi hina zimi ruzoga veize togaziro. ");
INSERT INTO ksj_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Rehano Paulo zu Banabasiꞌe eꞌe moneo ederadu Lukaonia habaꞌano ne boro aheu, Lusitera zu Derebe, ebu uhiḡauhiḡa neḡa ferau onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Eꞌea ze hari manoḡa ꞌaune haramiro. ");
INSERT INTO ksj_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lusitera zamaḡano odaḡa sauꞌa vazeḡa ꞌahoganiꞌa ehore radiunu. Ani ꞌouge fureraro ebu mene hune edau ragavinu. ");
INSERT INTO ksj_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Aniꞌe Pauloꞌa haramiroteꞌe igi radiro. Pauloꞌa ḡiane runirotene, ani Iesu mazao fieꞌe ꞌahine, odaḡa manoriꞌuma rae ederiro. ");
INSERT INTO ksj_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ꞌOugadu Pauloꞌa ḡihau ḡoreniro, “Odaḡo hina iḡune edanoꞌi!” Ebu ani zogone rafate iḡunadu edau ragaviro. ");
INSERT INTO ksj_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Vaze ḡuḡuvaḡaniꞌa Pauloꞌa haḡairoteꞌe haḡaiḡa horonirotene, ze Lukaonia ḡoeꞌano ḡihau huaro, “Badiꞌa nuꞌa vaze iraḡano emeḡe vaḡe ovaeha!” ");
INSERT INTO ksj_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ebu Banabasiꞌe Dio, u Pauloꞌe Hereme rae huziro, mazaḡa Pauloꞌa iḡaiḡa ḡoerinu. ");
INSERT INTO ksj_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Lusitera enogano Dio kuru neḡa ꞌahogaꞌe eꞌe. Eꞌe kuru neḡa taufeꞌeteꞌe dibuꞌo vazeḡaniꞌa boromakau nu zu ḡeḡene haḡairoteꞌe kakaḡa Lusitera ibihetaḡa odohe ariro. Ebu ani zu vaze ḡuḡuvaḡaꞌe Paulo zu Banabasi mazao dibuꞌihi reiro. ");
INSERT INTO ksj_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Rehano apostolo azaḡa, Banabasi zu Pauloꞌe ne azaḡaniꞌa nagini haḡaihi reiroteꞌe igirotene, dabuaze zigiro ebu vaze ḡuḡuvaḡa ḡunuḡano dure diuḡeꞌenaꞌa huau ḡoeriro, ");
INSERT INTO ksj_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Nego nabudi, za nougadu ꞌahiguḡa haḡaiḡa haḡaeꞌohe? Emeꞌe vaze tauḡi, zae teite idaḡa. Emeꞌe zae mazao hari manoḡa haramifine areha. Aꞌe, zaeꞌa huga oꞌoꞌa haḡaiḡa modadu ḡabode radiuꞌeteꞌe Badiꞌaḡa vaḡe arifine raꞌohe. Aniꞌe adure, raha, davara ebu eꞌea radiuꞌeteꞌe ḡauḡa niduꞌa haḡairoteꞌe Badiꞌaḡa. ");
INSERT INTO ksj_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ibite madaḡano habaꞌahabaꞌa azaḡa niduꞌa zeḡezeḡe edeḡano haḡae radiunutene, Badiꞌaꞌa ḡiaze modinu. ");
INSERT INTO ksj_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Rehano vazeꞌa Badiꞌa ederifine, aniꞌa haḡai manomano fureninu. Zae veize adureonoꞌo irugu tuḡuninu, ogomu madaḡa nunu fureninu, ogomu boro zininu, ebu matuꞌu hina zamaze iriꞌavoninu.” ");
INSERT INTO ksj_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Paulo zu Banabasiꞌa ꞌouge reiro rehano, ne azaḡaꞌe dibuꞌo zinihi radu teꞌoteꞌaro. Rehano ḡonaganoꞌe ze ꞌouge haḡaoga ꞌuiro. ");
INSERT INTO ksj_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Eꞌe ḡarugano Iuda azaḡa nuꞌa Antioka zu Ikonioonoꞌo aradu ne azaḡa zama aro. Eꞌanoꞌo zeꞌe Paulo hadi hina maro, ebu ze ꞌane ani rudaneha radu ne ḡutuꞌaḡano ahase buniro. ");
INSERT INTO ksj_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Rehano fieꞌeteꞌe azaḡaniꞌa gabaḡeḡene edauꞌenogano, ani iḡunadu eꞌe neḡa bare diuḡiro. Irarirotene, Paulo zu Banabasiꞌe Derebe uꞌa onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulo zu Banabasiꞌe Derebeo hari manoḡa haramadu fieꞌeteꞌe azaḡaniꞌa ḡehararo. Eꞌe enogano ze Lusitera, Ikonio, zu Pisidia habaꞌano Antioka bare onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ze eꞌea fieꞌeteꞌe azaḡa inaraziro ebu, “Iesu mazao fie gigaranoꞌi,” rae iraduguziro. Ebu ꞌahige rae ziro, “Eme Badiꞌaꞌa zuhiꞌaziꞌeteꞌe zamaḡa diuḡoga veize aduga ḡehaḡa zuni hidiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paulo zu Banabasiꞌe ekalesia tibatiba zamaḡano ekalesia ibitoziꞌeteꞌe azaḡa nu ohoziro. Ebu ogomu moneo zaḡozaḡeꞌenaꞌa, zeḡe veize kuraro ebu zeꞌa fieꞌeteꞌe Zuhiꞌaḡa Boro ꞌevorao tiro. ");
INSERT INTO ksj_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ebu Pisidia habaꞌa vitau onamadu Pamufulia habaꞌa bare onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ebu Perega neḡano Badiꞌa ḡoere harame hauḡirotene, Atalia neḡa ovoiro. ");
INSERT INTO ksj_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ebu Atalia neḡanonoꞌo ḡasi hina bare ruhau onamadu Siria habaꞌano Antiokao feuriro. Zeḡeꞌa hari manoḡa harame ragaveꞌetaꞌaꞌe Antiokaonoꞌo ḡadahiro. Antioka ekalesia azaḡaniꞌa Paulo zu Banabasi tuḡuzirotene, Badiꞌaꞌa zeḡe aheu mazao manoḡa furenoga veize umidiro. Ebu anianine eꞌe gauḡa haḡae hauḡiro. ");
INSERT INTO ksj_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ze Antiokao feurirotene, ekalesia azaḡa nuꞌoziro. Ebu Badiꞌaꞌa zeḡe teite haḡairoteꞌe haḡaiḡa niduꞌa rae fureniro, ebu Iuda mene azaḡa zuni Iesu mazao fieꞌeteꞌe ibiḡa Badiꞌaꞌa bohaniroteꞌe moneo meꞌodoziniro. ");
INSERT INTO ksj_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ebu ze fieꞌeteꞌe azaḡa teite mada ḡehaḡa eꞌea radiunu. ");
INSERT INTO ksj_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Vaze nuꞌa Iudea habaꞌanonoꞌo Antioka ovadu Iuda mene azaḡa boꞌaḡano fieꞌeteꞌe azaḡa ꞌahige ihoziro, “Moseꞌa ibite ihoziroteꞌe goroḡa ḡoeꞌa idunaḡano za ahiri rana iḡuri haḡaoꞌi. Mene haḡaine, za ḡabone mene hidiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulo zu Banabasiꞌa eꞌe ḡoeꞌa igirotene, ꞌuguḡa haḡaiḡa mene haḡaiꞌuma radu zeḡe teite taꞌirotitiro. Eꞌanoꞌo Antioka ekalesia azaḡaniꞌa Paulo zu Banabasiꞌe fieꞌeteꞌe azaḡa nu teite Ierusalema tuḡuzihi reiro. ꞌOugadu ze Ierusalemao apostolo azaḡa zu ekalesia ibitoziꞌeteꞌe azaḡa teite eꞌe moneo ḡoꞌaniꞌuma rae reiro. ");
INSERT INTO ksj_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Eꞌanoꞌo Antioka ekalesia azaḡaniꞌa Paulo duḡuru Ierusalema tuḡuze onamiro. Ze Fonikia zu Samaria habaꞌa vitau onameꞌeteꞌea, Iuda mene azaḡaniꞌa nougenouge Badiꞌa vaḡe ariroteꞌe hariḡa meꞌodoziniro. Fieꞌeteꞌe azaḡa niduꞌa eꞌe hariḡa igirotene, matuꞌe rudaro. ");
INSERT INTO ksj_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ze Ierusalemao feurirotene, ekalesia azaḡa, apostolo azaḡa zu ekalesia ibitoziꞌeteꞌe azaḡaniꞌa matuꞌeꞌenaꞌa, ze mae zouziro. Ebu Paulo duḡuruꞌe Badiꞌaꞌa zeḡe teite haḡairoteꞌe gauḡa niduꞌa meꞌodoziniro. ");
INSERT INTO ksj_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Rehano Farisea azaḡa boꞌaḡano fieꞌeteꞌe azaḡa nuꞌa iḡunadu ꞌahige rae reiro, “Iuda mene azaḡa zuni ahirize rana iḡuri haḡaiꞌuma, ebu Mose goro ḡoeꞌa hegotifine ihoziꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Eꞌanoꞌo apostolo azaḡa zu ekalesia ibitoziꞌeteꞌe azaḡaniꞌa ḡoere eꞌe moneo ḡoꞌanifine nuꞌoraro. ");
INSERT INTO ksj_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ze faḡa ḡoꞌaniroteꞌe enogano Peteroꞌa iḡunadu ziro, “Nego nabudi, zaꞌe edeḡa, Iuda mene azaḡaniꞌa hari manoḡa egadu Zuhiꞌa Boro mazao fioga veize ibite zae boꞌaḡano Badiꞌaꞌa eḡe ohotiro. ");
INSERT INTO ksj_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ebu vaze zama edereꞌeteꞌe Badiꞌaḡaniꞌa emeḡe mazao Vine Zaḡoḡa tuḡuniroteꞌe teige, Iuda mene azaḡa mazao zuni tuḡunadu ze mae zouziroteꞌe ihofiro. ");
INSERT INTO ksj_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Badiꞌa ubumao Iuda mene azaḡa zu emeꞌe mene nunu, mazaḡa Badiꞌaꞌa ze Iesu mazao fieꞌeteꞌe horozadu zamaze deheniro. ");
INSERT INTO ksj_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Mose goro ḡoeꞌaꞌe ufeta riḡa radu aꞌe eme ebu vouḡafeꞌa hegotogaꞌe mene idararoteꞌe adugaḡa. Rehano za nougadu fieꞌeteꞌe azaḡa aduga eꞌe zenadu Badiꞌa tuhune nurihi raꞌohe? ");
INSERT INTO ksj_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Mene! Eme Zuhiꞌa Boro Iesuꞌa zeḡe mazao manoḡa furenadu ze ḡabone hideꞌeteꞌe mae ḡihineꞌohe, ebu zeḡe teige, emeḡe mazao aniꞌa manoḡa furenadu emeꞌa ḡabone hideꞌeteꞌe mae ḡihineꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Eꞌea radiuꞌeteꞌe azaḡa niduꞌa Petero ḡoere igirotene, ḡoereni ꞌahoga mene reiro. Ebu ze Paulo zu Banabasi ḡoere faine abite radiro. Paulo zu Banabasiꞌe Badiꞌaꞌa zeḡe gauonoꞌo Iuda mene azaḡa boꞌaḡano haḡai nu badeḡa zu zaguzagatiteꞌe haḡaiḡa haḡainuteꞌe moneo faine meꞌodoziniro. ");
INSERT INTO ksj_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ze ḡoere hauḡirotene, Iakoboꞌa iḡunadu ḡoeriro, “Nego nabudi, eḡe ḡoere egoꞌi. ");
INSERT INTO ksj_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Badiꞌaꞌa Iuda mene azaḡa zamaradu zeꞌe ane mone azaḡa reifine, zeḡe boꞌaḡano ḡadaheḡano vaze nu ohotiroteꞌe hariḡa Simona Peteroꞌa rae fureneha. ");
INSERT INTO ksj_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Peroveta azaḡa ḡoere zuni ani ḡoere teite idaḡa. Aꞌe ꞌahige rae mirihiro, ");
INSERT INTO ksj_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","'ꞌAhi enogano eꞌe bare ariꞌuma. Ebu Davidaꞌa zuhiꞌaniroteꞌe neḡa fahanoga eḡeꞌa bare ogoraꞌuma. Ane ḡahutu neḡaꞌe bare ogoru ḡehaniꞌuma, ebu bare izifiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Haba nunu zamaḡano radiuꞌeteꞌe azaḡaniꞌa Zuhiꞌa Boro, eḡe vaḡiꞌuma, ebu Iuda mene azaḡa, eḡe none azaḡa niduꞌa eḡe vaḡiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Zuhiꞌa Boroꞌa ꞌouge raꞌohe. Aꞌe aniꞌa amahi rae fureniroteꞌe ḡoeꞌa.' ");
INSERT INTO ksj_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Eꞌanoꞌo eḡeꞌa zamareꞌetene, Iuda mene azaḡa boꞌaḡano Badiꞌa vaḡe ariroteꞌe azaḡa aduga mene ziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Rehano zeḡe veize soꞌa ꞌahoga mirihadu ꞌahige ziꞌuma, 'Zaꞌe iniuꞌa ḡuriro badiꞌaḡa dibuꞌohanadu toradaroteꞌe ogomuḡa ago anoꞌi. Ago daro futanoꞌi. ꞌUnuḡano harine runiroteꞌe maniḡa zu ruḡa ago anoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Mazaḡa Mose goro ḡoeꞌaꞌe amahionoꞌo neḡaneḡano Bana Madaḡa niduꞌa nuꞌonuꞌo neḡano meꞌode harameꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Eꞌanoꞌo apostolo azaḡa zu ekalesia ibitoziꞌeteꞌe azaḡaꞌe ekalesia azaḡa niduꞌa teite ḡoꞌaniro. Ebu zeḡe boꞌaḡano vaze nu ohotadu Paulo zu Banabasi teite Antiokao tuḡuziꞌuma rae reiro. Ohotiroteꞌe vazeḡa ꞌahoga niḡaꞌe Iuda (niḡa ꞌahogaꞌe Barasaba), zu ꞌahoga niḡaꞌe Silasi. Anianineꞌe ekalesia nego nabudi ibitoziꞌeteꞌe azaḡa. ");
INSERT INTO ksj_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ze soꞌao ꞌahige mirihadu tuḡuriro, “Eme, apostolo azaḡa zu ekalesia ibitoziꞌeteꞌe azaḡaꞌe Antioka, Siria ebu Kilikia habaꞌano Iuda mene azaḡa Iesu mazao fieꞌeteꞌe mazao uhiu tuḡureꞌohe. Emeꞌe zae negoze. ");
INSERT INTO ksj_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Emeḡe boꞌaḡano vaze nuꞌa ḡoere nunu hina zamaze mae ḡunuḡununiro ebu zamazeꞌa adudaroteꞌe emeꞌa igiro. Rehano zeꞌe emeꞌa mene tuḡuziro. ");
INSERT INTO ksj_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Eꞌanoꞌo emeḡe niduꞌa ḡoꞌane idanadu vaze nu ohoteha, ebu emeḡe zamarone negofe, Banabasi zu Paulo teite zae vaḡe tuḡuziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Banabasi zu Pauloꞌe emeḡe Zuhiꞌa Boro Iesu Keriso veize zeḡe ḡabone ahetiroteꞌe azaḡa. ");
INSERT INTO ksj_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Eme Iuda zu Silasiꞌe zae vaḡe tuḡuzeꞌohe. Ze emeꞌa soꞌao mirihateꞌe ḡoeꞌa hebeze hina zuni rae fureniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Vine Zaḡoḡaniꞌa ibitofeadu eme ꞌahige ḡoꞌane idaneha. Eme goro ḡoeꞌa nunu za zenadu aduga boro mene ziniꞌuma, rehano goro ḡoeꞌa nu ꞌahi daꞌo ziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Zaꞌe ḡuriro badiꞌaḡa dibuꞌoharoteꞌe ogomuḡa mene aꞌuma. Ru zu ꞌunuḡano harine runiroteꞌe maniḡa mene aꞌuma, ebu mene daroe futaꞌuma. Za haḡai ꞌuguḡa mene haḡaine, haḡaizeꞌa manohudaꞌuma. Eꞌe daꞌo. Zae niduꞌa bazoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ebu Paulo duḡuru Ierusalemaonoꞌo tuḡuzadu Antioka onamiro, ebu Antioka ekalesia azaḡa niduꞌa nuꞌozadu soꞌa eꞌe ziniro. ");
INSERT INTO ksj_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ebu ekalesia azaḡaniꞌa eꞌe meꞌodirotene, zeḡe iradugu ḡoeꞌa uꞌano matuꞌiro. ");
INSERT INTO ksj_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Iuda ebu Silasiꞌe peroveta azaḡa radu fieꞌeteꞌe azaḡa inaraziro zu inara ḡoeꞌa ziro. ");
INSERT INTO ksj_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ze mada nu eꞌea radiroteꞌe enogano, Antioka ekalesiaꞌe ze zama roḡeḡano onamoga veize kuranadu bare tuḡuziro. Ebu zeḡe tuḡuziroteꞌe azaḡa vaḡe Ierusalema bare onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo zu Banabasiꞌe Antiokao radadu vaze ḡehaḡa teite Zuhiꞌa Boro ḡoere ihoziro ebu haramoziro. ");
INSERT INTO ksj_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Mada nu enogano Pauloꞌa Banabasi niro, “Eme ibite Zuhiꞌa Boro ḡoere haramiroteꞌe neḡaneḡa niduꞌa bare onamadu eꞌea fieꞌeteꞌe azaḡaniꞌa nougenouge radiuꞌeteꞌe ḡiazihi.” ");
INSERT INTO ksj_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ebu Banabasiꞌa Ioane zuni zamahatihi reiro. Ani ni ꞌahogaꞌe Mareko. ");
INSERT INTO ksj_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Rehano Pauloꞌa Mareko zamahanogaꞌe mene manoḡa rae zamariro, mazaḡa Marekoꞌe ibite Pamufulia habaꞌanonoꞌo muhize baradu zeḡe teite mene gaue onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Eꞌe uꞌano, Paulo zu Banabasiꞌe ḡihau rotetadu ze rovotiro. Banabasiꞌe Mareko zamahanadu Kupuro ꞌumuḡa ruhau onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","U Pauloꞌe Silasi zamaharo. Ebu Antioka ekalesia azaḡaniꞌa Zuhiꞌa Boro manoḡaꞌe zeḡe mazao fureranoga veize kuranadu ze iḡuniro. ");
INSERT INTO ksj_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Zeꞌe Siria zu Kilikia habaꞌa onamadu ekalesia niduꞌa inaraziro. ");
INSERT INTO ksj_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Eꞌe enogano Pauloꞌa Derebe ebu Lusitera onamiro. Eꞌea Iesu mazao fieꞌeteꞌe vazeḡa ꞌahoga, niḡa Timoteoꞌa radiunu. Ani viꞌaꞌe Iuda roḡaeḡa, ebu ani Iesu mazao firo. Ebu mogaꞌe Giriki vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lusitera zu Ikonio ekalesia azaḡaꞌe Timoteo niguniro. ");
INSERT INTO ksj_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pauloꞌe Timoteoꞌa zeḡe teite onamoga uratiro. Rehano eꞌe habaꞌano Iuda azaḡa niduꞌaꞌe Timoteo mogaꞌe Giriki vazeḡa rae ederiro ꞌahine, Pauloꞌa Timoteo ahiꞌa rana iḡuri haḡairo. ");
INSERT INTO ksj_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ebu ze neḡaneḡa ragave onameꞌenaꞌa, Ierusalemao apostolo azaḡa zu ekalesia ibitoziꞌeteꞌe azaḡaniꞌa ḡoere idaniroteꞌe goroḡa ḡoeꞌa ne nunu azaḡa zuni hegotifine ihoziro. ");
INSERT INTO ksj_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Eꞌanoꞌo ekalesia azaḡaꞌe fieꞌeteꞌe moneo inarinu ebu mada niduꞌa ḡeharaunu. ");
INSERT INTO ksj_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Vine Zaḡoḡaniꞌa Paulo zu ani ḡatiniroteꞌe azaḡaniꞌa Asia habaꞌano haramoga garariro, eꞌanoꞌo ze Ferigia zu Galatia habaꞌa onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ze Musia habaꞌa hanitadu Bitunia habaꞌa onamihi reiro, rehano Iesu Vine Zaḡoḡaniꞌa garariro. ");
INSERT INTO ksj_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Eꞌanoꞌo ze Musia habaꞌa zogoradu Toroa ovoiro. ");
INSERT INTO ksj_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Eꞌe oheꞌano Pauloꞌa ahiri raꞌaga iḡunaḡa horoniro. Eꞌe zamaḡano Makedonia vazeḡa ꞌahoganiꞌa edanadu uminiro, “Makedonia habaꞌa fare aradu emeḡe danafoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pauloꞌa ahiri raꞌaga iḡunaḡa eꞌe horoniroteꞌe enogano, eme Makedonia habaꞌa onamoga veize ḡarihe ruhibiro, mazaḡa Makedonia azaḡa mazao hari manoḡa haramoga veize Badiꞌaꞌa emeḡe tuḡufeꞌohe rae zamariro. ");
INSERT INTO ksj_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Eme Toroaonoꞌo ḡasi hina roḡoroḡe Samotarake ꞌumuḡa ruhau onamiro. Ebu irarirotene, Neapoli toḡatoḡa ruhau onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ebu hena Filipo onamiro. Filipoꞌe Makedonia habaꞌa zamaḡano ne boro bagaḡa, zu Roma azaḡa ḡehaḡaniꞌa eꞌea radiunu. Eme zuni mada nu eꞌea radiro. ");
INSERT INTO ksj_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Bana Madaḡano eme Filipo neḡa ḡabiꞌa enoga buanadu vu onamiro, mazaḡa Iuda azaḡaniꞌa nuꞌoranadu kurauꞌeteꞌe habaꞌa ꞌahoga horoniꞌuma gaogi rae zamariro. Ebu eꞌea ehoradu nuꞌora ariroteꞌe roḡaeḡaroḡaeḡa ḡadahe ḡoreziro. ");
INSERT INTO ksj_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Zeḡe boꞌaḡano roḡae ꞌahoga, niḡa Ludiꞌaꞌa radiro. Aniꞌe ne boro ꞌahoga, Tuatira roḡaeḡa ebu dabua kanaḡa seroneꞌeteꞌe gauḡa boro haḡainu. Ani zuni Badiꞌa mazao kuraunuteꞌe roḡaeḡa. Zuhiꞌa Boroꞌa zamaḡa bohanadu ani Paulo ḡoere faifaine abitiro. ");
INSERT INTO ksj_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ebu Ludia zu ane teite ne tibano radiuꞌeteꞌe azaḡaniꞌa babatiso meiroteꞌe enogano, aniꞌa umifiro, “Za eꞌe Zuhiꞌa Boro mazao fieꞌeteꞌe roḡaeḡa rae zamaroꞌidene, eḡe ne aradu eꞌea radoꞌi.” Ebu ani teꞌoteꞌofadu ane ne zamafe onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Mada ꞌahogano eme kuru habaꞌa onameꞌeteꞌea, tuḡure roḡaeḡa nogobaḡa ꞌahoga hidiro. Aniꞌe vine sauꞌaniꞌa ane zamao radadu zama moneo naginiꞌa fureratiteꞌe rae fureniro. Aniꞌe ꞌouge haḡaeꞌenaꞌa, ane zuhiꞌa azaḡa veize hadi boro haḡainu. ");
INSERT INTO ksj_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Aniꞌa Paulo zu emeḡe hegoteꞌenaꞌa, ḡihau ḡoeriro, “ꞌAhi duḡuruꞌe Hitaga Hune Badiꞌaḡa tuḡure azaḡa! Zeꞌe ḡabone hideꞌeteꞌe ibiḡa moneo rae fureneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ani mada ḡehaḡa ꞌouge haḡairotene, Pauloꞌe eꞌe egoga fuḡoniro. Eꞌanoꞌo tehadu roḡae eꞌe zamao vine sauꞌa niro, “Iesu Keriso niḡano eḡeꞌa ḡaꞌohe, roḡae ꞌahi mazaonoꞌo buanoꞌi!” ꞌOuge reirotene, vine sauꞌaniꞌa roḡae eꞌe mazaonoꞌo buaro. ");
INSERT INTO ksj_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Tuḡure roḡaeḡa nogobaḡa zuhiꞌa azaḡaꞌe ani zeḡe veize hadi haḡaoga mene idararotaꞌaꞌe ederiro. Eꞌanoꞌo Paulo zu Silasi oboze teadu gavamani azaḡaniꞌa kotazoga veize ne hunio ahase onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ze Roma gavamani azaḡa vaḡe tutuze onamadu ziro, “ꞌAhi duḡuruꞌe Iuda azaḡa. Zeꞌe emeḡe ne azaḡa zamaze ḡunuḡununeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Zeḡe ihoreꞌe emeḡe goro agirohauꞌohe, eꞌanoꞌo eme, Roma azaḡaꞌe eꞌe mae ḡihinoga zu haḡaogaꞌe mene idaḡa!” ");
INSERT INTO ksj_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ebu vaze ḡuḡuvaḡaniꞌa Paulo zu Silasi agiroziꞌeteꞌe azaḡa teite ꞌauḡiro. ꞌOugirotene, gavamani azaḡaniꞌa zeḡe uti azaḡa tuḡuzadu ꞌahige rae ziro, “Paulo zu Silasi dabuaze zigi vaḡinoꞌi ebu somori hina bouzoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Uti azaḡaniꞌa zeḡe bouze sausauziroteꞌe enogano, ḡuꞌa neḡano ohoziro ebu ḡuꞌa neḡa ḡiane radiuꞌeteꞌe vazeḡa niro, “Faine ḡiaze radoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ḡuꞌa neḡa ḡiane radiuꞌeteꞌe vazeḡaꞌe eꞌe ḡoeꞌa egadu ḡuꞌa neḡa zamaḡa huneo ohoziro, ebu ire aduga hoꞌogano odaze veonadu ꞌufuze modiro. ");
INSERT INTO ksj_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ohe nema Paulo ebu Silasiꞌe kurau radiro zu bada maꞌenaꞌa, Badiꞌa niguniro. Ebu ḡuꞌa azaḡaniꞌa abitoziniꞌenaꞌa radiro. ");
INSERT INTO ksj_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Eꞌe madaḡano habaꞌa tabara ḡihau hagaradu ḡuꞌa neḡa ohoniroteꞌe habaꞌa zuni hagariro. Ebu ḡuꞌa neḡa ibihetaḡa niduꞌa bohataro, ebu ḡuꞌa azaḡa ꞌufuziroteꞌe auri adiriḡa niduꞌa butau buaro. ");
INSERT INTO ksj_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ḡuꞌa neḡa ḡiane radiuꞌeteꞌe vazeḡaniꞌa evatadu ḡuꞌa neḡa ibihetaḡaniꞌa bohatanoga horoniro. ꞌOugirotene, kariḡa hizi madu aneꞌa bare ḡounihi reiro, mazaḡa ani ḡuꞌa azaḡa niduꞌa feraneha rae zamariro. ");
INSERT INTO ksj_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Rehano Pauloꞌa ḡihau huaro, “Ḡa ḡaeꞌa bare ago sausauꞌoꞌi! Emeḡe niduꞌa ꞌada!” ");
INSERT INTO ksj_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ḡuꞌa neḡa ḡiane radiuꞌeteꞌe vazeḡaꞌe ihure umidadu meiro ebu ḡuꞌa neḡa dure diuḡiro. Ebu rereruꞌenaꞌa, Paulo zu Silasi zamao ḡuḡuriro. ");
INSERT INTO ksj_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ebu aneꞌa ze ḡuꞌa neḡanonoꞌo mae buzadu ḡadiziro, “Vaze boroboro, e nougine ḡabone hidiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Zeḡeꞌa naenaeniro, “Zuhiꞌa Boro Iesu mazao fioꞌi. ꞌOugine, ḡa zu ḡae neo radiuꞌeteꞌe azaḡaꞌe ḡabone hidiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ebu ze ḡuꞌa neḡa ḡiane radiuꞌeteꞌe vazeḡa zu ane neo radiuꞌeteꞌe azaḡa niduꞌa mazao Zuhiꞌa Boro ḡoere rae fureniro. ");
INSERT INTO ksj_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ebu eꞌe oheꞌano ḡuꞌa neḡa ḡiane radiuꞌeteꞌe vazeḡaniꞌa Paulo zu Silasi tutuze onamadu bouziroteꞌe iḡuꞌa vuzuꞌoziniro. Ebu ani zu ane neo radiuꞌeteꞌe azaḡa niduꞌa zogone babatiso meiro. ");
INSERT INTO ksj_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ebu ḡuꞌa neḡa ḡiane radiuꞌeteꞌe vazeḡaniꞌa ane ne tutuze onamadu ogomu ziniro. Ani ebu ane teite ne tibano radiuꞌeteꞌe azaḡa niduꞌa Badiꞌa mazao firoteꞌe uꞌano, ze matuꞌe rudaro. ");
INSERT INTO ksj_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Irarirotene, gavamani azaḡaniꞌa zeḡe gau azaḡaꞌe ḡuꞌa neḡa ḡiane radiuꞌeteꞌe vazeḡa vaḡe tuḡuzadu niro, “Eꞌe azaḡa tuḡuze buzoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ebu ḡuꞌa neḡa ḡiane radiuꞌeteꞌe uti vazeḡaniꞌa Paulo niro, “Gavamani azaḡaniꞌa zae tuḡuze buzoga veize ḡoere tuḡureha. Eꞌanoꞌo izidi buanadu zama roḡeḡano onamoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Rehano Pauloꞌa gavamani gau azaḡa ziro, “Emeꞌe Roma mone azaḡa. Rehano ze emeꞌe kotao mene ohofadu hunio boufeha ebu ḡuꞌa neḡano ohofeha. Ebu izidi zeꞌe eme sifu tuḡufe bufihi raꞌohe. Aꞌe mene idaḡa! Zeḡe huneꞌa aradu tuḡufe bufiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Gavamani gau azaḡaniꞌa onamadu Paulo ḡoere gavamani azaḡa ihozirotene, ze Paulo zu Silasiꞌe Roma mone azaḡa rae ederadu rihau rudaro. ");
INSERT INTO ksj_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Eꞌanoꞌo gavamani azaḡaꞌe zeḡe vaḡe onamadu zeḡe haḡai sauꞌa rae modoga veize umiziro. Ebu gavamani azaḡaniꞌa ḡuꞌa neḡanonoꞌo zamaze buzadu ze Filipo mode iḡunoga umiziro. ");
INSERT INTO ksj_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ebu Paulo zu Silasiꞌe ḡuꞌa neḡanonoꞌo buarotene, Ludia ne onamiro. Eꞌea fieꞌeteꞌe azaḡa hidadu inara ḡoeꞌa ziro ebu Filipo mode iḡuniro. ");
INSERT INTO ksj_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulo zu Silasiꞌe Amefipoli zu Apolonia neḡa vitau onamadu Tesalonikao feuriro. Eꞌea Iuda azaḡa nuꞌonuꞌo neḡaꞌe eꞌe. ");
INSERT INTO ksj_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pauloꞌe iḡaiḡa haḡainuteꞌe teige, Bana Madaḡano nuꞌonuꞌo neḡa diuḡadu Buka Zaḡoḡa meꞌodeꞌenaꞌa Iuda azaḡa teite ḡoꞌaninu. ꞌOugeꞌenaꞌa Bana Madaḡa uḡidu meiro. ");
INSERT INTO ksj_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Aniꞌe Buka Zaḡoḡano Kerisoꞌa aduga boro hidadu runeonoꞌo bare ḡaboditeꞌe moneo mirihiroteꞌe faifairu rae fureniro zu ihoziro. Ebu aniꞌa ꞌahige rae ziro, “Eḡeꞌa zae mazao rae fureneꞌeteꞌe vazeḡaꞌe Iesu, aꞌe Keriso.” ");
INSERT INTO ksj_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ebu Iuda azaḡa nuꞌe zamazeꞌa bohatanadu Paulo ḡoere mae ḡihiniro ebu Paulo zu Silasi teite ꞌauḡiro. Ebu Giriki azaḡa ḡehaḡa Badiꞌa gubaneꞌeteꞌe zu roḡae boroboro ḡehaḡa zuni ꞌauḡiro. ");
INSERT INTO ksj_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Rehano Iuda azaḡa nuꞌe eꞌe horonirotene, Paulo zu Silasi mazao ahiahi meiro. Eꞌanoꞌo ḡonore azaḡa maketi habaꞌano rau tauḡeꞌeteꞌe mae nuꞌozadu Tesalonika zamaḡano uti ḡadaheniro ebu ne azaḡa ḡunuḡunuziro. Ebu vaze ḡuḡuvaḡa ubumao Paulo zu Silasi mae buzoga veize Iasoni ne dure onamadu Paulo zu Silasi vaḡiro. ");
INSERT INTO ksj_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Rehano ze mene horozirotene, Iasoni zu fieꞌeteꞌe azaḡa nu ahase buzadu neze gavamani azaḡa zamao ohoziro, ebu ḡihau ḡoeriro, “Paulo zu Silasiꞌe haba niduꞌa zamaḡano vaze mae ḡunuḡunuze areha. Ebu ze emeḡe ne zuni diuḡeha. ");
INSERT INTO ksj_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Rehano Iasoniꞌa ane neo mae zouziro. Zeꞌe Roma kiniḡa goro ḡoeꞌa variꞌeꞌohe, mazaḡa zeḡe niduꞌaꞌe vaze ꞌahoga, niḡa Iesuꞌe kini raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Vaze ḡuḡuvaḡa zu ne gavamani azaḡaniꞌa eꞌe igirotene, zamazeꞌa adudu ḡouriro. ");
INSERT INTO ksj_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Rehano zeꞌe Iasoni duḡuru mazaonoꞌo hadi nu madu tuḡuze buziro. ");
INSERT INTO ksj_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Eꞌe oheꞌano fieꞌeteꞌe azaḡaꞌe Paulo zu Silasi zogone tuḡuzadu Berea neḡa onamiro. Ze Berea neḡano feurirotene, nuꞌonuꞌo neḡa diuḡiro. ");
INSERT INTO ksj_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Berea azaḡaꞌe zamaze manoḡa zu mene riḡa. Ze Tesalonika azaḡa mene heuḡa. Eꞌanoꞌo Paulo duḡuru ḡoere faifairu igiro, zu zeḡe ḡoereꞌe huga ga meneꞌe ederihi radu mada niduꞌa Buka Zaḡoḡa meꞌode udahinu. ");
INSERT INTO ksj_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ꞌOugadu Iuda azaḡa ḡehaḡaniꞌa Iesu mazao firo, ebu Giriki roḡae boroboro zu Giriki ohoze ḡehaḡaniꞌa Iesu mazao firo. ");
INSERT INTO ksj_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Rehano Tesalonika Iuda azaḡaꞌe Pauloꞌa Berea neḡano zuni Badiꞌa ḡoere haramiroteꞌe igirotene, ze Berea neḡa onamadu Berea azaḡa zamaze ḡunuḡunuziro zu harairo. ");
INSERT INTO ksj_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Eꞌanoꞌo fieꞌeteꞌe azaḡaniꞌa Paulo zogone tuḡune davara habaꞌa onamiro. U Silasi zu Timoteoꞌe Berea neḡano radiro. ");
INSERT INTO ksj_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Paulo ḡatiniroteꞌe azaḡaniꞌa ani Atena tutune onamiro. Ebu Pauloꞌa zeḡe mazao Silasi zu Timoteo veize ḡoere tuḡuriro, “Eḡe vaḡe ḡarihe aroꞌi.” Ebu ze ḡoere odohe Berea neḡa bare onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pauloꞌa Atenao Silasi zu Timoteo guhize radiuꞌeteꞌea, ḡuriro badiꞌaḡa ḡehaḡaniꞌa eꞌea iriꞌaviroteꞌe horonirotene, zamaḡaniꞌa adudaro. ");
INSERT INTO ksj_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Eꞌanoꞌo ani nuꞌonuꞌo neḡa diuḡadu Iuda azaḡa zu Giriki azaḡa Badiꞌa mazao kurauꞌeteꞌe teite taꞌirotitiro. Ebu mada niduꞌa ne hunio hidiroteꞌe azaḡa teite ḡoꞌaniro. ");
INSERT INTO ksj_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ebu edeḡa azaḡa nu, Epikuro duḡuru zu Sitoa duḡuru teite taꞌirotitiro. Zeḡe boꞌaḡano nuꞌe Pauloꞌa Iesu hariḡa zu Iesuꞌa rudanadu bare ḡabodiroteꞌe hariḡa haramirotene, ꞌahige rae reiro, “Ḡoeꞌa fuꞌa vazeḡa ꞌahi nagini reihi raꞌohe?” Ebu nuꞌe raenaꞌa, “Ani avoꞌa azaḡa badiꞌaze nu moneo rae fureneꞌe gaogi.” ");
INSERT INTO ksj_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ebu ze Paulo tutunadu Areopago maḡa komeꞌa onamadu zeḡe nuꞌonuꞌo zamaḡano ohoniro. Ebu zeḡeꞌa niro, “Eme ḡaeꞌa rae fureneꞌeteꞌe ihoreḡa iziga moneo ederihi raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ḡae ihoreꞌe emeḡe teḡao ibite mene hune igiroteꞌe ḡoeꞌa. Eꞌe hugaꞌe nagini?” ");
INSERT INTO ksj_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atena azaḡa zu avoꞌa azaḡa eꞌea radiuꞌeteꞌe haḡaiꞌe ꞌahiguḡa. Zeḡe niduꞌa ḡau iziga ḡoꞌanoga zu egoga veize daꞌo madaze hauḡiro. ");
INSERT INTO ksj_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ebu Pauloꞌa Areopago kota azaḡa zamao edanadu ḡoeriro, “Atena azaḡa, e za horozatene, zaꞌe badiꞌa ḡehaḡa mazao faine kuratihi raꞌeteꞌe azaḡa. ");
INSERT INTO ksj_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Eḡeꞌa zae neo ragaveꞌenaꞌa, zaeꞌa kuranohauꞌeteꞌe ḡauḡa ḡehaḡa horoneha. Eꞌe zamaḡano dibuꞌo fataḡano ḡoere ꞌahoga ꞌahige mirihiroteꞌe horoneha, 'Aḡuꞌa Badiꞌaḡa Veize'. Eꞌanoꞌo e zaeꞌa mene edereꞌenaꞌa, kuranohauꞌeteꞌe badiꞌaḡa moneo rae furenihi raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Badiꞌaꞌe raha zu eꞌe zamaḡano radiuꞌeteꞌe ḡauḡa niduꞌa haḡairo. Aniꞌe adure zu raha zuhiꞌaziꞌeteꞌe Zuhiꞌaḡa Boro radu vazeꞌa ꞌevore hina ogoraroteꞌe kuru neḡa zamaḡano mene radiuꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Aniꞌe ḡabone, ḡabone iriga ebu ḡau niduꞌa vaze niduꞌa ziniꞌeteꞌe Badiꞌaḡa. Eꞌanoꞌo ani mazaoꞌe fereneꞌeteꞌe ḡauḡani ꞌahoga oꞌoꞌa radu vazeꞌa ani veize ḡau ꞌahoga mene haḡaohaꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Vazeꞌa haba niduꞌa zamaḡano radoga veize, Badiꞌaꞌa vaze tibuhuga haḡadu ani mazaonoꞌo haba nunu azaḡa niduꞌa haḡairo. Ebu zeḡeꞌa raditeꞌe madaḡa zu raditeꞌe habaꞌa ḡonaga ohoniro. ");
INSERT INTO ksj_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Vazeꞌa Badiꞌa vaḡoga veize Badiꞌaꞌa ꞌouge haḡairo. Ze Badiꞌa inare vaḡine, ani hidiꞌuma. Hugaꞌe, ani emeḡe niduꞌa mazaonoꞌo mene faḡa radiuꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Mazaḡa eme Badiꞌa teige tiburanadu radiuꞌohe, hagareꞌohe zu ḡabode radiuꞌohe. Zae boꞌaḡano bada garaheꞌeteꞌe vazeḡa ꞌahoganiꞌa ꞌahige rae mirihiro, 'Emeḡe zuni ane ubugaubuga.' ");
INSERT INTO ksj_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Eꞌanoꞌo emeꞌe Badiꞌa ubugaubuga radu Badiꞌaꞌe vazeꞌa ꞌevoreze hina haḡairoteꞌe ḡuriro Badiꞌaḡa teigeꞌohe rae mene zamariꞌuma. Ze zeḡeꞌa bare zamaradu Badiꞌaꞌe golo ga siliva ga hadi hina haḡairoteꞌe ḡauḡa teite idaḡa raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ibite madaḡanoꞌe ze aḡuꞌa radu ꞌuguḡa haḡaiḡa haḡainuteꞌe Badiꞌaꞌa ḡiaze modinu. Rehano izidiꞌe haba niduꞌa zamaḡano vaze niduꞌa mazao aneꞌa ziꞌohe, 'Zamaze ḡihunoꞌi!' ");
INSERT INTO ksj_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Mazaḡa aniꞌe haba niduꞌa azaḡa ibi duduḡano kotaziteꞌe madaḡa ohoniro. Ebu kota ibitohatiteꞌe vazeḡa zuni ohoniro. Eꞌe vazeḡaꞌe aniꞌa runeonoꞌo bare ḡaboniro. ꞌOuge haḡadu vaze aꞌe hube hune vaze niduꞌa kotaziteꞌe vazeḡa rae deheru ihoziro.” ");
INSERT INTO ksj_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Atena azaḡaꞌe rune vazeḡaniꞌa bare ḡabodiroteꞌe igirotene, vaze nuꞌe Paulo eḡofoharo, u nuꞌe ꞌahige rae reiro, “Eme eꞌe hariḡaꞌe vesuꞌu bare igihi.” ");
INSERT INTO ksj_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ꞌOugadu Pauloꞌa nuꞌonuꞌo eꞌe mode iḡuniro. ");
INSERT INTO ksj_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Rehano vaze nuꞌe Paulo hegotadu Iesu mazao firo. Zeḡe boꞌaḡanoꞌe Areopago kota vazeḡa ꞌahoga niḡa Dionusio, ebu roḡae ꞌahoga niḡa Damari zu vaze nunu zuni eꞌea. ");
INSERT INTO ksj_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Eꞌe enogano Pauloꞌa Atena modadu Korinto onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Eꞌea Iuda vazeḡa ꞌahoga, niḡa Akula hidiro. Aniꞌe Ponito habaꞌa vazeḡa, ebu Itali habaꞌanonoꞌo inuga Pirisikila teite Korinto aradu mada nu meiro. Ze Roma kiniḡa, niḡa Kulaudioꞌa Iuda azaḡa niduꞌa Roma habaꞌanonoꞌo vaḡinoꞌi rae ḡoere riḡa zenadu Korinto ariro. Ebu Pauloꞌa ze ḡiazi onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Paulo zu zeꞌe hadi gauḡa haḡainutaꞌaꞌe tiba. Ze taruha ogoneꞌeteꞌe faraiḡa rafaḡa turininu. Eꞌanoꞌo Pauloꞌe zeḡe teite radadu gauinu. ");
INSERT INTO ksj_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pauloꞌe Bana Madaḡa niduꞌa nuꞌonuꞌo neḡa onamadu, Iuda azaḡa zu Giriki azaḡa zuni Iesu mazao fioga veize haramoziro zu zeḡe teite taꞌirotitiro. ");
INSERT INTO ksj_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silasi zu Timoteoꞌa Makedonia habaꞌanonoꞌo ariroteꞌe enogano, Pauloꞌa mada niduꞌa haramoga veize daꞌo gaue huninu, ebu Iuda azaḡa mazao Iesuꞌe Keriso rae doḡoꞌani fureninu. ");
INSERT INTO ksj_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Rehano ze Paulo haramo hezahoharo zu rae sausauniro. ꞌOugirotene, ani dabuaḡa huꞌuruḡa zauhe mode manahadu ziro, “Zaꞌe Badiꞌaꞌa ruizoꞌidene, eꞌe adugaꞌe za zaeꞌa bare moꞌi, rehano eḡe mazaoꞌe oꞌoꞌa. E izidionoꞌo zama moneo Iuda mene azaḡa vaḡe onamiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ebu ani nuꞌonuꞌo neḡa modadu Iuda mene vazeḡa ꞌahoga, niḡa Titio Iusito ne onamiro. Aniꞌe Badiꞌa mazao kuraunuteꞌe vazeḡa, ebu ani neꞌe nuꞌonuꞌo neḡa genaḡano. ");
INSERT INTO ksj_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Nuꞌonuꞌo neḡa vazeḡa ḡihiꞌaḡa, niḡaꞌe Kirisipo. Ani zu ane neo radiuꞌeteꞌe azaḡa niduꞌa Zuhiꞌa Boro mazao firo. Ebu Korinto azaḡa ḡehaḡa zuni Paulo haramo egadu Zuhiꞌa Boro mazao firo ebu babatiso meiro. ");
INSERT INTO ksj_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ohere ꞌahogano Zuhiꞌa Boroꞌa ahiri raꞌaga iḡunaḡano Paulo niro, “Ago rihanoꞌi. Hebeꞌo ago ꞌue radoꞌi, ꞌize harame onamoꞌi. ");
INSERT INTO ksj_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Eꞌe ḡae teite radiuꞌohe. Vaze ꞌahoganiꞌa zuni ḡa mene sausauꞌiꞌuma zu mene agatoḡaniꞌuma, mazaḡa ne boro ꞌadaoꞌe eḡe none azaḡa ḡehaḡaniꞌa radiuꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Eꞌanoꞌo Pauloꞌe Korinto zamaḡano muri tiba zu bato fuꞌo tiba fare radiuꞌenaꞌa, Badiꞌa ḡoere ihozinu. ");
INSERT INTO ksj_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galioꞌa Akaia habaꞌa gavana vazeḡa reiroteꞌea, Iuda azaḡaniꞌa tiburanadu Paulo obone tiro ebu kota habaꞌa tutune onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ebu ze ꞌahige rae reiro, “Vaze ꞌahiꞌe ne azaḡaniꞌa Badiꞌa mazao kuranoga veize zamaze auꞌohe. Aꞌe Iuda azaḡa goro ḡoeꞌa variꞌeꞌeteꞌe haḡaiḡa!” ");
INSERT INTO ksj_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ebu Pauloꞌa ḡoerihi reirotene, Galioꞌa Iuda azaḡa ziro, “Iuda azaḡa, vaze ꞌahoganiꞌa haḡai sauꞌa ga veꞌoḡa haḡaifone, eḡeꞌa zae ḡoere egozinifo. ");
INSERT INTO ksj_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Rehano zaꞌa Iuda azaḡa ḡoere ga nize ga goro ḡoeꞌa nunu moneo taꞌirotite ḡoꞌanoꞌidene, za zaeꞌa bare ḡoꞌane fainoꞌi. Eꞌe ꞌuguḡa moneo kota mene haḡaiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ꞌOugadu Galioꞌa kota habaꞌanonoꞌo zeḡe tuḡuze buziro. ");
INSERT INTO ksj_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ꞌOugadu zeḡe niduꞌa nuꞌonuꞌo neḡa vazeḡa ḡihiꞌaḡa, niḡa Sositene obone tiro ebu kota habaꞌa ꞌusiḡano bouniro. Rehano Galioꞌe ehamu reꞌoreꞌiro. ");
INSERT INTO ksj_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pauloꞌa Korinto zamaḡano mada ḡehaḡa radiroteꞌe enogano, eꞌea fieꞌeteꞌe azaḡa muhizadu Siria habaꞌa ruhau onamiro. Pirisikila zu Akulaꞌa ḡatine onamiro. Pauloꞌe ꞌizema ruhanogano Kenkerea toḡatoḡaḡano iguḡa variꞌiro, mazaḡa ani ibite Badiꞌa mazao ꞌougiꞌuma rae ḡoere rinede tiro. ");
INSERT INTO ksj_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ebu ze Efesoo feurirotene, Pirisikila zu Akulaꞌe eꞌea ohoze modiro. U Pauloꞌe nuꞌonuꞌo neḡa diuḡadu Iuda azaḡa teite taꞌirotitiro. ");
INSERT INTO ksj_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Zeꞌe Pauloꞌa zeḡe teite eꞌea faḡa radoga uminiro, rehano aniꞌa mene mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ani ze muhize iḡuneꞌenaꞌa, ꞌahige rae reiro, “Badiꞌaꞌa uratine, e zae vaḡe bare ariꞌuma.” Ebu ani Efesoonoꞌo ruhau onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ebu aniꞌa Kaisareao feurirotene, Ierusalema itadu ekalesia azaḡa teite mada tahiḡa unihiro, ebu bare Antioka ovoiro. ");
INSERT INTO ksj_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pauloꞌa mada nu Antiokao radiroteꞌe enogano, eꞌeanoꞌo iḡunadu Galatia zu Ferigia habaꞌano ragaveꞌenaꞌa, fieꞌeteꞌe azaḡa niduꞌa inaraziro. ");
INSERT INTO ksj_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","U Iuda vazeḡa ꞌahoga, niḡa Apoloꞌa Efeso ariro. Aniꞌe Alesanderia vazeḡa. Ani faifairu ḡoereꞌeteꞌe vazeḡa, zu Buka Zaḡoḡa moneo zuni edeḡa boro meiro. ");
INSERT INTO ksj_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Aniꞌe Zuhiꞌa Boro Ibi moneo ihoreḡa meiro, ebu Iesu hariḡa zamaḡa niduꞌa hina inare ḡoeriro zu ihoziro. Rehano ani Ioane babatiso daꞌo ederiro. ");
INSERT INTO ksj_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apoloꞌa nuꞌonuꞌo neḡano mene rihauꞌenaꞌa ḡadahe ḡoerirotene, Pirisikila zu Akulaꞌa ane ḡoere egadu neze tutune onamiro ebu Badiꞌa Ibi moneo faifairu ihoniro. ");
INSERT INTO ksj_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ebu Apoloꞌa Akaia habaꞌa onamihi reiro. ꞌOugadu fieꞌeteꞌe azaḡaniꞌa inara ḡoeꞌa haro ebu Akaia habaꞌano fieꞌeteꞌe azaḡaniꞌa ani mae ḡihinifine, zeḡe veize soꞌa mirihe tuḡuriro. Akaia ekalesia azaḡaꞌe Badiꞌaꞌa zeḡe mazao manoḡa furenadu amahi Iesu mazao finu. Ebu Apoloꞌa eꞌea feuradu ze borofe danaziro. ");
INSERT INTO ksj_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Mazaḡa aniꞌa Buka Zaḡoḡa hina Iesuꞌe Keriso rae ihozeꞌenaꞌa, Iuda azaḡa teite hunio ḡihau taꞌirotitiro. ");
INSERT INTO ksj_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apoloꞌa Korinto zamaḡano radiuꞌeteꞌe madaḡano Pauloꞌe maḡa habaꞌa tihitihine onamadu Efesoo feuriro. Eꞌea fieꞌeteꞌe azaḡa nu hidiro, ");
INSERT INTO ksj_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ebu ḡadiziro, “Za Iesu mazao firotene, Vine Zaḡoḡa meirohe?” Zeꞌa naenaeniro, “Mene, eme Vine Zaḡoḡa raꞌeteꞌe zuni mene hune igiro.” ");
INSERT INTO ksj_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Eꞌanoꞌo Pauloꞌa ḡadiziro, “Tena za nagi babatiso meiro?” Zeꞌa naenaeniro, “Eme Ioane babatiso meiro.” ");
INSERT INTO ksj_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pauloꞌa ziro, “Ioaneꞌe vazevazeꞌa zamaze ḡihunoga veize babatisoziro ebu ꞌahige rae reiro, 'Eḡe ḡaruna ariteꞌe vazeḡa mazao fioꞌi. Aꞌe Iesu.'” ");
INSERT INTO ksj_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ze Paulo ḡoere egadu Zuhiꞌa Boro Iesu niḡano babatiso meiro. ");
INSERT INTO ksj_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ebu Pauloꞌa ꞌevoꞌa zeḡe rana tirotene, Vine Zaḡoḡaniꞌa zeḡe vaḡe ovairo, ebu ze mazane ḡoeꞌano ḡoeriro, ebu Badiꞌaꞌa ihoziroteꞌe ḡoeꞌa rae fureniro. ");
INSERT INTO ksj_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Zeḡe niduꞌaꞌe gaubanana aheu fare heuḡa. ");
INSERT INTO ksj_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ebu Pauloꞌa nuꞌonuꞌo neḡa diuḡadu eꞌea bato uḡidu inare haraminu. Ebu ze Badiꞌaꞌa zuhiꞌaziꞌeteꞌe moneo mae ḡihinoga veize zeḡe teite ḡihau ḡoꞌaniro. ");
INSERT INTO ksj_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Rehano Iuda azaḡa nuꞌe teḡa riranadu Paulo ḡoere hezahoharo, ebu vaze ḡehaḡa ubumao Zuhiꞌa Boro Ibi rae sausauniro. Eꞌanoꞌo Pauloꞌe nuꞌonuꞌo neḡa mode buanadu fieꞌeteꞌe azaḡa daꞌo zamaze onamiro. Ebu vaze ꞌahoga niḡa Turanu, aneꞌa ihozeꞌeteꞌe neḡa onamadu mada niduꞌa ḡoꞌane ihozinu. ");
INSERT INTO ksj_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ꞌOuge haḡae onamo muri aheu meiro. Eꞌanoꞌo Iuda azaḡa zu Giriki azaḡa Asia habaꞌano radiuꞌeteꞌe niduꞌa Zuhiꞌa Boro ḡoere igiro. ");
INSERT INTO ksj_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Badiꞌaꞌa Paulo gauonoꞌo haḡai nu badeḡa gigiꞌaḡa haḡainu. ");
INSERT INTO ksj_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Vaze nuꞌe Pauloꞌa odohe raunuteꞌe mukoḡa zu vidau gauinuteꞌe dabuaḡa afaꞌa madu ugi azaḡa ranao tinutene, ugizeꞌa manorinu zu vine sauꞌaniꞌa buaunu. ");
INSERT INTO ksj_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","U Iuda azaḡa nuꞌe haba nunu ragaveꞌenaꞌa, vazevaze mazaonoꞌo vine sauꞌa hegoze buzinu. Zeḡe zuni Zuhiꞌa Boro Iesu niḡano vine sauꞌa hegoze buzihi radu ꞌahige rae reiro, “Pauloꞌa harameꞌeteꞌe vazeḡa, Iesu niḡano e riḡa ḡaꞌohe, vaze mazaonoꞌo buanoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Dibuꞌo vazeḡa ḡihiꞌaḡa ꞌahoga, niḡa Sikeva, ane ubuga fuꞌo aheu fare duḡuruꞌa zuni ꞌouge haḡairo. ");
INSERT INTO ksj_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ꞌOugirotene, vine sauꞌaniꞌa naenaeziro, “E Iesu edeḡa ebu Paulo edeḡa. U zaꞌe iniu?” ");
INSERT INTO ksj_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ebu vine sauꞌaḡeta vazeḡaniꞌa zeḡe rana rafatadu ani inaraꞌe zeḡe inara ufeta vitiniro ꞌahine, zeḡe niduꞌa raharahaziro. Eꞌanoꞌo ze firina zu ahirize ruauꞌenaꞌa, vine sauꞌaḡeta vazeḡa neonoꞌo ferau buaro. ");
INSERT INTO ksj_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Efeso zamaḡano Iuda azaḡa zu Giriki azaḡaniꞌa eꞌe hariḡa igirotene, zeḡe niduꞌa ḡiḡaroziro ebu Zuhiꞌa Boro Iesu ni niguniro. ");
INSERT INTO ksj_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ebu fieꞌeteꞌe azaḡa ḡehaḡaniꞌa aradu aneane haḡai sauꞌa rae fureniro. ");
INSERT INTO ksj_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ebu murava azaḡa ḡehaḡaꞌe zeḡe murava bukaḡa odohe aradu vaze niduꞌa zamao hufi haoniro. Hufi haoniroteꞌe bukaḡa naeḡa niduꞌa meꞌode nuꞌonirotene, siliva hadiḡa 50,000 reiro. ");
INSERT INTO ksj_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ꞌOugeꞌenaꞌa, Zuhiꞌa Boro ḡoereꞌe ḡuhure bororaunu zu inarinu. ");
INSERT INTO ksj_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ꞌUguḡaniꞌa fureraroteꞌe ḡarugano, Pauloꞌe Makedonia zu Akaia habaꞌa vitau onamadu Ierusalema onamiꞌuma rae zamariro, ebu ꞌahige rae reiro, “E Ierusalema onamiroteꞌe enogano Roma zuni onamiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Eꞌanoꞌo Pauloꞌe ane dana vazeḡa aheu, Timoteo zu Erasito Makedonia habaꞌano ibite tuḡuziro, u aniꞌe mada nu Asia habaꞌano radiro. ");
INSERT INTO ksj_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Eꞌe madaḡano Zuhiꞌa Boro Ibi mae ḡihineꞌeteꞌe azaḡa uꞌano, hara boroꞌa fureraro. ");
INSERT INTO ksj_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Vaze ꞌahoga, niḡa Demetirioꞌa radiunu. Aniꞌe siliva hina Efeso roḡae badiꞌaḡa, Atemisi kuru neḡa komefe idane haḡaeꞌeteꞌe gauḡa odohe durinu, ebu gau azaḡa ḡehaḡaniꞌa ani ꞌuꞌuḡano gauadu hadi boro meinu. ");
INSERT INTO ksj_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetirioꞌa ane gau azaḡa zu ane gau heuḡa haḡaeꞌeteꞌe azaḡa nuꞌozadu ziro, “Eḡe nego niduꞌa, za edeḡa, emeꞌe gau ꞌahi haḡadu hadi boro maꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Za vaze ꞌahi, Pauloꞌa mene Efeso zamaḡano daꞌo, rehano Asia habaꞌa niduꞌa zamaḡano vaze ḡehaḡa zamaze anadu tutuze veꞌoziroteꞌe horoniro zu igiro. Aniꞌa ꞌahige ziꞌohe, 'Vaze ꞌevore hina haḡairoteꞌe badiꞌaḡaꞌe mene badiꞌa.' ");
INSERT INTO ksj_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ani ꞌaune ꞌougine, emeḡe gau niḡaniꞌa sautaꞌuma, zu Atemisi roḡae badiꞌaḡa boro kuru neḡa zuni reꞌoreꞌoniꞌuma. Asia habaꞌa zu haba niduꞌa zamaḡano vaze niduꞌa kuranohauꞌeteꞌe badiꞌaḡa roḡaeḡa, ani ni ḡihiꞌaḡaniꞌa zuni dauḡiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nuꞌoraroteꞌe azaḡaniꞌa eꞌe igirotene, maḡune rudaro ebu ḡihau hounaꞌeꞌenaꞌa, ḡoeriro, “Efeso azaḡa roḡae badiꞌaḡa, Atemisiꞌe ḡihiꞌa hune!” ");
INSERT INTO ksj_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ebu Efeso azaḡa niduꞌa hounadu harae ḡuzuhiro, ebu Makedonia habaꞌanonoꞌo Paulo ḡatine ariroteꞌe azaḡa, Gaio zu Arisitako oboze teadu zeḡe niduꞌa zeḡe nu'onu'o habaꞌa ꞌidaꞌida dure diuḡiro. ");
INSERT INTO ksj_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pauloꞌa vaze ḡuḡuvaḡa ḡorezoga veize zeḡe ḡunuḡano diuḡihi reiro, rehano fieꞌeteꞌe azaḡaniꞌa garariro. ");
INSERT INTO ksj_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Asia habaꞌa gavamani azaḡa nuꞌe Paulo vaze. Ze zuni uminone ḡoeꞌa tuḡuradu niro, “Zeḡe nu'onu'o habaꞌa ago diuḡoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ebu Efeso nu'onu'o habaꞌano vaze ḡuḡuvaḡa niduꞌa harae ḡuzuhiro. Vaze nuꞌe ꞌahige hounaꞌiro zu nuꞌe deꞌuge hounaꞌiro ꞌahine, eꞌe zamaḡano vaze ḡehaḡaꞌe nagini uꞌano nuꞌorarotaꞌaꞌe mene ederiro. ");
INSERT INTO ksj_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Iuda azaḡa nuꞌa vaze ꞌahoga, niḡa Alesana vaze ḡuḡuvaḡa zamao duine monenirotene, vaze ḡuḡuvaḡa boꞌaḡano vaze nuꞌa nougiꞌuma rae ḡihau ḡadiḡadiniro. Alesanaꞌe haraꞌa zuhutanoga veize ꞌevoꞌa ḡihinadu vaze ḡuḡuvaḡa ḡorezihi reiro. ");
INSERT INTO ksj_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Rehano vaze ḡuḡuvaḡaniꞌa Alesanaꞌe Iuda vazeḡa rae ederirotene, ze niduꞌa ago tibano huau ḡoeriro, “Efeso azaḡa roḡae badiꞌaḡa, Atemisiꞌe ḡihiꞌa hune!” Ḡoere tiba eꞌe daꞌo barebare rae harae onamo mada aheu meiro. ");
INSERT INTO ksj_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ḡonagano ne boro gavamani azaḡa veize miriheꞌeteꞌe gauḡa haḡaeꞌeteꞌe vazeḡa ꞌahoganiꞌa vaze ḡuḡuvaḡa hara garariro. Ebu zeḡe niduꞌa sifu radirotene, aniꞌa ziro, “Efeso azaḡa, vaze niduꞌa edeḡa, Efesoꞌe roḡae badiꞌaḡa boro Atemisi kuru neḡa taufeꞌohe, zu Atemisi iraḡa hadiḡa adureonoꞌo ovairoteꞌe taufeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Aꞌe ḡoere huga. Vaze ꞌahoganiꞌa ḡuriro ḡoeꞌa rae mene reꞌuma. Eꞌanoꞌo za ago haraoꞌi zu ḡurizabuo ḡau ꞌahoga ago haḡae tauḡoꞌi. ");
INSERT INTO ksj_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Zaꞌe vaze aheu ꞌahi zamaze areha rehano, ze emeḡe kuru neḡano ḡau ꞌahoga mene ḡonotaneha zu emeḡe roḡae badiꞌaḡa mene sausauneha. ");
INSERT INTO ksj_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demetirio zu ane gau tiba azaḡaniꞌa vaze ꞌahoga kotao ohonihi reineꞌe, kota habaꞌa onamine manoḡa. Kota habaꞌaꞌe bohaꞌa zu eꞌea gavana azaḡaniꞌa radiuꞌe ꞌahine, eꞌe habaꞌano iniuꞌe veꞌoḡa ga duduḡa, eꞌe veize ḡoretitiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Za zae mazao ḡoere ꞌahoga eꞌe reine, Efeso gavamani goroḡano ne azaḡaniꞌa nuꞌoruꞌeteꞌe zamaḡano ḡoꞌanine manoḡa. ");
INSERT INTO ksj_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Emeꞌe izidi ꞌaha harae ḡuzuhateꞌe uꞌano, gavamani azaḡaniꞌa emeḡe rana aduga tiꞌuma gaogi. Emeꞌa harataꞌaꞌe mazaḡa huga oꞌoꞌa ꞌahine, eme emeḡe moneo ḡoeroga mene idaraꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ani ꞌouge ḡoeradu vaze ḡuḡuvaḡa tuḡuze ḡouriro. ");
INSERT INTO ksj_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Efeso zamaḡano hara boroꞌa hauḡirotene, Pauloꞌa fieꞌeteꞌe azaḡa huze nuꞌozadu inaraziro, ebu uhiu ḡoeꞌa zenadu Makedonia habaꞌa onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ani eꞌe habaꞌano ragaveꞌenaꞌa, fieꞌeteꞌe azaḡa inara ḡoeꞌa nunu hina inaraziro ebu Giriki habaꞌano feuriro. ");
INSERT INTO ksj_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Eꞌea ani bato uḡidu radiro. Eꞌe enogano Siria habaꞌa ḡasi hina onamihi rae reiro. Rehano Iuda azaḡaniꞌa Paulo manoga veize ḡoꞌaniro ꞌahine, ani Makedonia habaꞌa vitau onamadu Siria bariꞌuma rae zamaḡa ohoniro. ");
INSERT INTO ksj_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ane teite onamiroteꞌe azaḡaꞌe Berea vazeḡa, Puro ubuga niḡa Sapatero, ebu Tesalonika azaḡa aheu, nize Arisitako zu Sekundo, ebu Derebe vazeḡa niḡa Gaio, ebu Timoteo, ebu Asia azaḡa, nize Tukiko zu Torofimo. ");
INSERT INTO ksj_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Zeꞌe ibite iḡunadu Toroao guhifiro. ");
INSERT INTO ksj_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","U emeꞌe Isiti Oꞌoꞌa ꞌUvahuḡa Odoga Muiḡa enogano Filipoonoꞌo ḡasio ruhau onamiro, ebu mada fuꞌo enogano Toroao ze hidadu eꞌea mada fuꞌo aheu fare radiro. ");
INSERT INTO ksj_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Fura ḡoravaḡa uḡano eme ogomu au tiburanoga veize nuꞌoraro. Pauloꞌe irarine muhize iḡuniꞌuma radu haramiro, onamo ohe nema reiro. ");
INSERT INTO ksj_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Eme hitaga neḡano nuꞌoru radiro. Eꞌe zamaḡanoꞌe ihure ḡehaḡa agane tiro. ");
INSERT INTO ksj_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","U ohoze iziga ꞌahoga, niḡa Iutukoꞌa marama rana ehore radiunu. Pauloꞌa ꞌauꞌaune harame onamirotene, ani baze rudaro. Baze rudaroteꞌe zamaḡano ani ne hitaga uḡiduḡanonoꞌo uitadu rahao bua ovoiro ebu ze ani mae ḡihinirotene, rudanoga horoniro. ");
INSERT INTO ksj_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Rehano Pauloꞌa ovoradu ane rana ḡuḡuriro ebu afunadu ziro, “Ago zamare borofoꞌi. Ani ꞌize ḡaboga!” ");
INSERT INTO ksj_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ebu Pauloꞌa hitaga neḡa bare itadu ꞌuvahu odoga zeḡe teite au tiburaro, ebu ḡoere onamo irarirotene iḡuniro. ");
INSERT INTO ksj_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Nu'onu'o azaḡaꞌe ḡabodiroteꞌe ohozeḡa iziga eꞌe zamahanadu neḡa onamiro, ebu ani uꞌano borofe inariro. ");
INSERT INTO ksj_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pauloꞌa odao onamihi radu Aso neḡa uꞌa gabao onamiro. U emeꞌe aniꞌa efadu ḡasi hina ibite eꞌe neḡa onamiro, ebu eꞌea eme ani ḡasio mae ufiꞌuma reiro. ");
INSERT INTO ksj_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ebu Pauloꞌa Aso neḡano emeḡe teite ꞌauḡirotene, ḡasio ofadu Mitulene neḡa ruhau onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Eꞌeanoꞌo bare ruhau onamo irarirotene, Kiosi ꞌumuḡa uhiḡano vitaro. Ebu mada eꞌe enoganoꞌe ruhau onamo Samosi ꞌumuḡano feuriro. Ebu eꞌe madaḡa enoganoꞌe Mileto neḡano feuriro. ");
INSERT INTO ksj_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ꞌOuge ruhau onamirotaꞌaꞌe mazaḡa Pauloꞌe Asia habaꞌano mada hauḡoga mene uratadu Efesoꞌe ruhau vitiniꞌuma reiro. Ani uraꞌe Pentikosi madaḡa ꞌizema mougano Ierusalemao feuroga radu ḡariheḡarihiro. ");
INSERT INTO ksj_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pauloꞌa Mileto neḡano feurirotene, vaze ꞌahoga Efeso tuḡunadu Efeso ekalesia ibitoziꞌeteꞌe azaḡaniꞌa ane vaḡe aroga veize huziro. ");
INSERT INTO ksj_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ze arirotene Pauloꞌa ḡoreziro, “Zaꞌe edeḡa, eḡeꞌa Asia habaꞌa diuḡiroteꞌe madaḡa ibiꞌaonoꞌo onao izidi mada niduꞌa zae teite nougenouge radiunu. ");
INSERT INTO ksj_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","E Zuhiꞌa Boro veize gaueꞌeteꞌe zamaḡano iḡaiḡa nihe mae ovoeꞌenaꞌa zu nihe vuḡa ḡehaḡa soroneꞌenaꞌa gauiro. ꞌOuge gaueꞌeteꞌea, Iuda azaḡa nuꞌa uḡuhihi radu e sausauhiro ꞌahine, aduga boro hidiunu. ");
INSERT INTO ksj_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ebu mene rihauꞌenaꞌa, za danaziteꞌe ḡoeꞌa niduꞌa haramiro zu hunio ga zae neo ihoziro. ");
INSERT INTO ksj_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ebu Iuda azaḡa zu Iuda mene azaḡa mazao hari tiba hina daꞌo ꞌahige harame huniro, 'Haḡaize sauꞌanonoꞌo ḡihuradu Badiꞌa vaḡe aroꞌi, ebu Zuhiꞌa Boro Iesu mazao fioꞌi!' ");
INSERT INTO ksj_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ebu izidi e Vine Zaḡoḡaniꞌa tuḡutuḡuhadu Ierusalema onameꞌohe. Rehano e aḡuꞌa, eꞌea naginiꞌa eḡe mazao fureraꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","E Vine Zaḡoḡaniꞌa ihohiroteꞌe daꞌo edeḡa. Eḡeꞌa ragaveꞌeteꞌe neḡa niduꞌa zamaḡano eꞌe ḡuꞌa neḡano ohohiꞌuma ebu aduga hidiꞌuma rae aniꞌa ihiro. ");
INSERT INTO ksj_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","E ꞌouge ḡabonehe modine zuni idaḡa, mazaḡa e Zuhiꞌa Boro Iesuꞌa iniroteꞌe ibiḡa oname hauḡoga zu gauḡa haḡae hauḡogaꞌe ufeta manoḡa. Eḡe gauꞌe Badiꞌaꞌa vaze mazao manoḡa furenadu ziniroteꞌe hariḡa manoḡa rae fureneꞌeteꞌe raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","E zae boꞌaḡano Badiꞌaꞌa zuhiꞌaziꞌeteꞌe moneo haramiro. Izidi e edeḡa, zae niduꞌa irahe mene bare horoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Eꞌanoꞌo e izidi ꞌaha deheru rae fureneꞌohe. Zae boꞌaḡano iniuꞌa ḡabone ibiḡa daunine zuni, e mene debahiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Mazaḡa e mene saseꞌenaꞌa, Badiꞌa ura niduꞌa zae mazao rae fureniro. ");
INSERT INTO ksj_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Eꞌanoꞌo za zaeꞌa bare duguzeꞌenoꞌi ebu zae mamoe niduꞌa taufoꞌi. Vine Zaḡoḡaniꞌa zaꞌe zae mamoe boꞌaḡano ohozadu Badiꞌa ekalesia mamoeḡa taufoꞌi rae reiro. Zeꞌe Badiꞌaꞌa ubuga ru hina hoitiroteꞌe azaḡa. ");
INSERT INTO ksj_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","E edeḡa, eḡeꞌa muhiziteꞌe enogano ḡuriro azaḡaniꞌa agire ḡuniḡa teige zae boꞌaḡano diuḡadu zae mamoe sausauze ruziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Zae boꞌaḡano zuni vaze nuꞌa iḡunadu huga ḡoeꞌa veꞌone ihoziꞌuma, ebu zeḡe hegotoga veize fieꞌeteꞌe azaḡa zamaze aꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Eꞌanoꞌo duguzeꞌenoꞌi! Eḡeꞌa muri uḡidu zamaḡano ohere zu madai niduꞌa nihe vuḡa soroneꞌenaꞌa, iḡaiḡa zaezae ihozinuteꞌe zamareꞌenoꞌi! ");
INSERT INTO ksj_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","E izidi zaꞌe Badiꞌa ꞌevoreo tiꞌohe, ebu Badiꞌaꞌa fureniroteꞌe manoḡaḡa moneo ihozeꞌeteꞌe ḡoeꞌa zae mazao modeꞌohe. Eꞌe ḡoeꞌaniꞌa za inaraziꞌuma, ebu zaeꞌa Badiꞌa mone azaḡa niduꞌa meiteꞌe manohugaḡa Moze mazaonoꞌo mouga veize ibitoziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","E iniu vaze hadize ga dabuaze veize mene kanaunu. ");
INSERT INTO ksj_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Za zaeꞌa bare edeḡa, e ꞌevorehe aheu ꞌahi hina gauadu eḡe zu eḡe ḡatihiroteꞌe azaḡa veize naginiꞌa ferefiroteꞌe hoitiro. ");
INSERT INTO ksj_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","E ḡabonehe niduꞌa zamaḡano zaeꞌa tuhutuhuhoga veize inare gauadu ḡauꞌa ferezeꞌeteꞌe azaḡa danaziroteꞌe teige, zae zuni ꞌougiꞌuma. Ebu Zuhiꞌa Boro Iesu aneꞌa bare ꞌahige rae reiro, 'Ḡahugeꞌeteꞌe vazeḡaꞌe maꞌeteꞌe vazeḡa vitinadu ufeta matuꞌiꞌuma.' Za eꞌe ḡoeꞌa zamareꞌenoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pauloꞌa ḡoere hauḡirotene, obenaḡa hina tuḡadu zeḡe niduꞌa teite Badiꞌa mazao kuraro. ");
INSERT INTO ksj_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ebu zeḡe niduꞌa nianadu ahainiꞌenaꞌa furaꞌiniro. ");
INSERT INTO ksj_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ze zamaze are rudaro, mazaḡa Pauloꞌa ꞌahige rae ziro, “Zaꞌe irahe mene bare horoniꞌuma.” Ebu Paulo ḡatine ḡasio ohoni onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Eme Efeso ekalesia ibitoziꞌeteꞌe azaḡa teite uhiu hauḡirotene, ḡasio tiradu Koso ꞌumuḡa roḡoroḡe onamiro. Ebu baze irarirotene Rodo ꞌumuḡa ruhau onamiro, ebu hena Patara ruhau onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ebu eꞌea Fonikia habaꞌa onameꞌeteꞌe ḡasiḡa horonirotene, eꞌe ḡasiḡano tiradu iḡuniro. ");
INSERT INTO ksj_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ebu onamo Kupuro ꞌumuḡa hanitirotene, edaꞌe moneonoꞌo ruhau vitanadu Siria habaꞌa uꞌa ruhau onamiro ebu Turoo hebetiro, mazaḡa ḡasiꞌe eꞌea tohe rurunihi reiro. ");
INSERT INTO ksj_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Emeḡeꞌa Turo zamaḡano fieꞌeteꞌe azaḡa vaḡadu fura tiba zeḡe teite radiro. Zeꞌe Vine Zaḡoḡaniꞌa ihozadu Pauloꞌa Ierusalema itoga barebare garariro. ");
INSERT INTO ksj_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Rehano iḡuniteꞌe madaḡa meirotene, eme iḡunadu bare ꞌaune onamiro. Fieꞌeteꞌe azaḡa niduꞌaꞌe inudeze zu tahiꞌatahiꞌazeta ḡatife ne ḡutuꞌaḡano tuḡufi ovoiro. Ebu eꞌea emeḡe niduꞌa hesao obenafe hina tuḡadu kuraro. ");
INSERT INTO ksj_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ebu eme zeḡe teite uhiu hauḡirotene ḡasio tiriro, u zeꞌe neze bare onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Eme Turoonoꞌo ꞌaune ruhau onamo Tolemaiao hebetiro. Aꞌe emeꞌa ruharoteꞌe ḡonaga. Eꞌea eme fieꞌeteꞌe azaḡa teite unihadu mada tiba zeḡe teite radiro. ");
INSERT INTO ksj_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Irarirotene, eme iḡunadu Kaisarea onamiro. Ebu hari manoḡa harameꞌeteꞌe vazeḡa, Filipi neo radiro. Aniꞌe Ierusalema ekalesia azaḡaniꞌa ohoziroteꞌe gau azaḡa fuꞌo aheu fare boꞌaḡano vaze ꞌahoga. ");
INSERT INTO ksj_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ani aboḡa nogobaḡaꞌe ḡazaḡa. Ze Badiꞌaꞌa ihozadu Badiꞌa ḡoere rae fureninu. ");
INSERT INTO ksj_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Eme Kaisareao mada ḡehaḡa radiuꞌeteꞌea, Iudea habaꞌanonoꞌo peroveta vazeḡa ꞌahoga, niḡa Agaboꞌa feuri ovairo. ");
INSERT INTO ksj_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ani emeḡe vaḡe aradu Paulo kibaꞌi meiro, ebu eꞌe hina aneꞌa bare ꞌevoꞌa zu odaḡa ogoranadu ifiro, “Vine Zaḡoḡaniꞌa ꞌahige raꞌohe, 'Ierusalema zamaḡano Iuda azaḡa ibitoziꞌeteꞌe azaḡaniꞌa kibaꞌi ꞌahi vazeḡaꞌe ꞌahige ogoru tiꞌuma ebu Iuda mene azaḡa ꞌevoreo riꞌiniꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Eꞌe igirotene, eme zu eꞌea radiuꞌeteꞌe azaḡaniꞌa Paulo uminiro, “Ierusalema ago itoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Rehano Pauloꞌa naenaefiro, “Za nougadu niauꞌenaꞌa, zamahe mae aduduneꞌohe? Zuhiꞌa Boro Iesu uꞌano, eꞌe Ierusalemao obohe touga idaḡa ebu rudanoga zuni idaḡa.” ");
INSERT INTO ksj_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Pauloꞌa emeḡe umido mene mae ḡihiniro ꞌahine, eme ꞌahige rae tauḡiro, “Zuhiꞌa Boroꞌa ane urao haḡaiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ꞌOuge mada nu radiroteꞌe enogano emeꞌe tohefe ruhinadu Ierusalema itiro. ");
INSERT INTO ksj_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Kaisareaonoꞌo fieꞌeteꞌe azaḡa nu zuni emeḡe teite itiro. Ze eme Nasona ne tutufe onamadu emeꞌe ane neo radiro. Nasonaꞌe Kupuro vazeḡa, zu amahi Iesu mazao firoteꞌe vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Eme Ierusalemao feurirotene, fieꞌeteꞌe azaḡaniꞌa matuꞌeꞌenaꞌa mae ḡihifiro. ");
INSERT INTO ksj_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Irarirotene, Paulo ebu emeḡe niduꞌa Iakobo ḡiani onamiro. Ierusalema ekalesia ibitoziꞌeteꞌe azaḡa niduꞌa zuni eꞌea radiro. ");
INSERT INTO ksj_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pauloꞌa zeḡe teite unihe ḡoretitiroteꞌe enogano, ane gau zamaḡano Badiꞌaꞌa Iuda mene azaḡa mazao haḡairoteꞌe haḡaiḡa niduꞌa faine doḡoꞌani rae furenoziniro. ");
INSERT INTO ksj_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ze eꞌe igirotene, Badiꞌa niguniro ebu Paulo niro, “Nego, ḡa edeḡa, Iuda azaḡa boꞌaḡano ḡehaḡa bagaḡaniꞌa Iesu mazao fieꞌohe, rehano zeḡe niduꞌa ꞌize Mose goro ḡoeꞌa zuni inare hegoteꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ze ḡaeꞌa Iuda mene azaḡa boꞌaḡano radiuꞌeteꞌe Iuda azaḡa niduꞌa mazao nagini ihozeꞌeteꞌe igiro. Zeḡe zamarone, ḡaeꞌa ꞌahige rae ziro, 'Mose goro ḡoeꞌaꞌe modoꞌi. Eneze guraḡa ahiri rana iḡuri ago haḡaoꞌi. Iuda azaḡa vouḡa haḡaiḡa niduꞌa ago hegotoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Eme nougine manoḡa? Ze ḡaꞌa arateꞌe deheru igiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Eꞌanoꞌo ḡaꞌe emeꞌa ḡeiteꞌe ḡoeꞌa hegotoꞌi. Emeḡe boꞌaḡano Badiꞌa ubumao ḡoere rinede tiroteꞌe ohozeḡa ḡazaḡaꞌe ꞌada. ");
INSERT INTO ksj_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ꞌAhi duḡuru kuru neḡa zamaze onamadu Badiꞌa ubumao deheratiteꞌe haḡaiḡa zeḡe teite haḡaoꞌi. Ebu vadinize ꞌohaniteꞌe naeḡa ḡaeꞌa zenoꞌi. ꞌOugine, vaze niduꞌaꞌe zeḡeꞌa hariḡo igirotaꞌaꞌe mene huga, rehano ḡae zuni Mose goro ḡoeꞌa hegote radiuꞌetaꞌaꞌe ederiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","U Iuda mene azaḡa Iesu mazao fieꞌeteꞌe veizeꞌe eme soꞌao ꞌahige mirihadu tuḡuroziniro, 'Ḡuriro badiꞌaḡa dibuꞌoharoteꞌe ogomuḡa ago anoꞌi. ꞌUnuḡano harine runediroteꞌe maniḡa zu ruḡaꞌe ago anoꞌi. Daro fuꞌa haḡaiḡa ago haḡaoꞌi.'” ");
INSERT INTO ksj_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Eꞌanoꞌo irarirotene, Pauloꞌa vaze ḡazaḡa zamazadu deheratiteꞌe haḡaiḡa zeḡe teite haḡairo. Ebu kuru neḡa diuḡadu ze Badiꞌa ubumao deheratiteꞌe haḡaiḡa hauḡiteꞌe madaḡa zu zeḡe tibatiba veize naniꞌa Badiꞌa dibuꞌohatiteꞌe madaḡa ihoziro. ");
INSERT INTO ksj_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Badiꞌa ubumao deheratiteꞌe haḡaiḡa haḡaeꞌeteꞌe furaḡa nariga hauḡirotene, Iuda azaḡa Asia habaꞌanonoꞌo ariroteꞌeꞌa kuru neḡano Paulo horoniro. Ze vaze ḡuḡuvaḡa niduꞌa tutuze harae iḡunadu Paulo obone tiro. ");
INSERT INTO ksj_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ebu ḡihau ḡoereꞌenaꞌa, “Isaraela azaḡa, danafoꞌi! Vaze ꞌahiꞌe Isaraela azaḡa haḡai zu Mose goro ḡoeꞌa zu kuru neḡa ꞌahi rae sausauneꞌenaꞌa, habaꞌahabaꞌano vaze niduꞌa ihozeꞌohe. Ebu kuru neḡano Giriki azaḡa tutuze zouzadu haba zaḡoḡa ꞌahi toraneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ze ꞌouge reirotaꞌaꞌe, mazaḡa ibite Efeso vazeḡa Torofimoꞌa Paulo teite Ierusalemao raunuteꞌe horonadu Pauloꞌa Torofimo zuni kuru neḡa zamaḡano tutune zouniro rae zamariro. ");
INSERT INTO ksj_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ꞌOugadu Ierusalema azaḡa niduꞌa harae ḡunuḡuniro, ebu vaze niduꞌa naenaenoꞌo duduꞌohadu Paulo obone tiro, ebu kuru neḡanonoꞌo ahase buniro. Ebu kuru neḡa ibihetaḡa niduꞌa zogone hararo. ");
INSERT INTO ksj_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Paulo nariga mau runiroteꞌe zamaḡano, Ierusalema niduꞌa haraꞌa iriꞌaviroteꞌe hariḡaniꞌa Roma uti vazeḡa ḡihiꞌaḡa mazao buau onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ebu aniꞌe zogone uti vazeḡa boroboro zu uti azaḡa zamazadu vaze ḡuḡuvaḡa uꞌa dure ovoiro. Harairoteꞌe azaḡaniꞌa uti vazeḡa ḡihiꞌaḡa zu uti azaḡa horozirotene, Paulo bounoga tuꞌiro. ");
INSERT INTO ksj_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Uti vazeḡa ḡihiꞌaḡaniꞌa aradu Paulo obone tiro, ebu uti azaḡa tuḡuzadu auri adiriḡa aheu hina batuniro. Ebu aneꞌa ḡadimaro, “Vaze ꞌahiꞌe iniu? Ani nagini haḡaeha?” ");
INSERT INTO ksj_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ebu vaze ḡuḡuvaḡa boꞌaḡano aneane edeḡano ḡihau ḡoere iḡuniro. Uti vazeḡa ḡihiꞌaḡaꞌe hara ufeta boro ꞌahine, nagini uꞌano ꞌougiroteꞌe ederoga mene idararo. Eꞌanoꞌo uti azaḡa ziro, “Vaze ꞌahi uti azaḡa radone neḡa tutune onamoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ze Paulo tutune onamadu ne ḡoraꞌaḡano feurirotene, vaze ḡuḡuvaḡaniꞌa naenaenoꞌo bounihi rae reiro ꞌahine, ani herate ḡihinadu onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Vaze ḡuḡuvaḡaniꞌa ani hegoteꞌenaꞌa ḡihau huaro, “Mau runoꞌi! Mau runoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Pauloꞌe uti azaḡa radone neḡano nariga tutune zounirotene, ani uti vazeḡa ḡihiꞌaḡa uminiro, “E ḡoere nu ḡeine idaḡahe?” Ebu uti vazeḡa ḡihiꞌaḡaniꞌa naenaeniro, “Ḡa Giriki ḡoeꞌa edeḡahe? ");
INSERT INTO ksj_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ibite Izipi vazeḡa ꞌahoganiꞌa Roma gavamani teite utitadu gorugoru azaḡa 4,000 haba bohaꞌa tutuze onamiro. Ḡaꞌe eꞌe vazeḡahe?” ");
INSERT INTO ksj_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pauloꞌa naenaeniro, “Mene. Eꞌe Iuda vazeḡa ebu nehe niḡaꞌe Taso, aꞌe Kilikia habaꞌano ne boro ꞌahoga. E vaze ḡuḡuvaḡa ꞌahi ḡorezihi rae umiꞌeꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ebu uti vazeḡa ḡihiꞌaḡaniꞌa ḡoeꞌa mae ḡihinirotene, Pauloꞌa ḡoraꞌao edanadu vazeꞌa mene haraoga veize ꞌevoꞌa mae ḡihiniro. Ebu haraꞌa dauḡirotene, Pauloꞌa Heberu ḡoeꞌano ḡoreziro. ");
INSERT INTO ksj_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Pauloꞌa vaze ḡuḡuvaḡa ziro, “Nego nabudi, eḡeꞌa izidi ꞌada eḡe bare biroga veize zae mazao ḡoereꞌeteꞌe egoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ze aniꞌa Heberu ḡoeꞌano zeḡe mazao ḡoereꞌeteꞌe egadu sifu fase radiro. Ebu Pauloꞌa ḡoreziro, ");
INSERT INTO ksj_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Eꞌe Iuda vazeḡa. E Kilikia habaꞌano Tasoo fureraro ebu Ierusalemao bororaro. Ebu Gamalielaꞌa ihohadu ani ꞌuꞌuḡano radiuꞌenaꞌa, vouḡafe goro ḡoeꞌa riḡa huneo mirihiro, ebu izidi zae niduꞌa haḡaeꞌeteꞌe teige, Badiꞌa veize gaue inarinu. ");
INSERT INTO ksj_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","E Iesu Ibi hegoteꞌeteꞌe azaḡa sausauzinu, zu nuꞌe zimi ruzinu, ebu ohoze zu roḡae batuzadu ḡuꞌa neḡano ohozinu. ");
INSERT INTO ksj_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu Iuda azaḡa boroboro zuni eḡeꞌa ꞌada raꞌetaꞌaꞌe hube rae reꞌuma. Mazaḡa zeḡe mazaonoꞌo e Iuda azaḡa Damaseko zamaḡano radiuꞌeteꞌe veize mirihiroteꞌe soꞌaḡa meiro ebu Damaseko onamiro. E onamadu eꞌea fieꞌeteꞌe azaḡa oboze tihi ebu Ierusalema tutuze aradu aduga zinihi reiro.” ");
INSERT INTO ksj_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Damaseko hanitadu madai kirikiri reirotene, agaḡa bagaḡaniꞌa adureonoꞌo tabara eḡe rana agara ovairo. ");
INSERT INTO ksj_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ꞌOugadu e rahao higau bauriro zu ago ꞌahoga igiro, 'Saulo, Saulo, ḡa nougadu eḡe sausauheꞌohe?' ");
INSERT INTO ksj_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Eḡeꞌa ḡadiniro, 'Zuhiꞌa Boro, ḡa iniu?' Aniꞌa naenaehiro, 'Eꞌe Nazareta vazeḡa Iesu zu ḡaeꞌa sausauheꞌeteꞌe vazeḡa.' ");
INSERT INTO ksj_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","U ḡatihe onameꞌeteꞌe azaḡaꞌe agaḡa horoniro rehano, ḡoreheꞌeteꞌe agoḡa mene igiro. ");
INSERT INTO ksj_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ebu e ḡadiniro, 'Zuhiꞌa Boro, e nougiꞌuma?' Aneꞌa ihiro, 'Iḡunadu Damaseko onamoꞌi. Eꞌea vaze ꞌahoganiꞌa ḡa nagini haḡaiteꞌe niduꞌa ihoꞌiꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Eꞌe agaḡa huneꞌa ubumahe ꞌuiro ꞌahine, ehamanoga mene idararo. Eꞌanoꞌo ḡatihiroteꞌe azaḡaniꞌa tutuhe abiheꞌenaꞌa, Damaseko onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Eꞌea vaze ꞌahoga, niḡa Ananiaꞌa radiunu. Aniꞌe Mose goro ḡoeꞌa hegoteꞌenaꞌa, zamaḡa niduꞌa hina gaueꞌeteꞌe vazeḡa. Eꞌanoꞌo Iuda azaḡa niduꞌa Damaseko zamaḡano radiuꞌeteꞌeꞌa ani gubane runiro. ");
INSERT INTO ksj_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ani eḡe vaḡe aradu eḡe genaḡano edaro ebu ꞌahige rae reiro, 'Saulo, negohe, bare faine ehamanoꞌi.' ꞌOuge reirotene, e zogone bare ehamanadu Anania horoniro. ");
INSERT INTO ksj_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ebu Ananiaꞌa ihiro, 'Vouḡafe Badiꞌaꞌa ḡa Badiꞌa ura ederoga, zu duduḡa vazeḡa Iesu horonoga, ebu Iesu hebeonoꞌo agoḡa egoga veize ḡa ohotiro. ");
INSERT INTO ksj_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ḡaꞌe ani veize ḡaeꞌa horoniroteꞌe zu igiroteꞌe ḡauḡa vaze niduꞌa mazao rae fureniteꞌe vazeḡa reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Eꞌanoꞌo ḡa ago zamare ꞌadaꞌadoꞌi. Iḡunadu Iesu mazao fioꞌi zu babatiso moꞌi. ꞌOugine, Badiꞌaꞌa haḡaiḡo sauꞌa vuzuꞌe modiꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Ebu e Ierusalema baradu kuru neḡano kuraroteꞌe zamaḡano, ahiri raꞌaga iḡunaḡa horoniro. ");
INSERT INTO ksj_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ebu Zuhiꞌa Boroꞌa ḡorehoga horoniro. Ani ꞌahige rae ihiro, 'Ḡarihoꞌi. Ierusalemaonoꞌo zogone iḡunoꞌi, mazaḡa ḡaeꞌa eḡe hari rae fureneꞌetaꞌaꞌe Ierusalema azaḡaniꞌa mene mae ḡihiniꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ebu e naenaeniro, 'Zuhiꞌa Boro, ze edeḡa, eḡeꞌa nuꞌonuꞌo neḡa niduꞌa onamadu ḡae mazao fieꞌeteꞌe azaḡa oboze tiro zu ḡuꞌa neḡano ohoziro ebu bouziro. ");
INSERT INTO ksj_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ebu ḡae hari rae fureninuteꞌe vazeḡa, Stefano mau runiroteꞌe madaḡano eḡe zuni zeḡe teite ḡoere idanadu eꞌea edau radiro. Ebu Stefano mau runiroteꞌe azaḡaniꞌa fuiꞌe tiroteꞌe dabuaḡaꞌe eḡeꞌa taufe radiro.' ");
INSERT INTO ksj_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Rehano Zuhiꞌa Boroꞌa ihiro, 'Onamoꞌi. Eḡeꞌa haba faḡano Iuda mene azaḡa mazao tuḡuꞌiꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Vaze ḡuḡuvaḡaniꞌa abite onamo Pauloꞌa eꞌe ḡoeꞌa reiroteꞌe igirotene, ze harae iḡuneꞌenaꞌa, ḡihau ḡoeriro, “Vaze ꞌahiguḡaꞌe mau runoꞌi! Aniꞌe ḡabode radoga mene idaḡa!” ");
INSERT INTO ksj_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ze dabuaze hitana feune ḡihineꞌenaꞌa, konoḡa itine ḡuzuhiro. ");
INSERT INTO ksj_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ꞌOugirotene, Roma uti vazeḡa ḡihiꞌaḡaniꞌa uti azaḡa zeadu Paulo uti azaḡa radone neḡano mae zouniro. Ebu vaze ḡuḡuvaḡaniꞌa nougadu Paulo mazao maḡune haraeꞌeteꞌe ederihi radu, “Ani masineꞌenaꞌa ḡadinoꞌi,” rae ziro. ");
INSERT INTO ksj_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Uti azaḡaniꞌa Paulo masinoga veize ꞌevoꞌa hutube ꞌeine utirotene, Pauloꞌa uti vazeḡa boro eꞌea edauꞌeteꞌe niro, “Eꞌe Roma mone vazeḡa. Rehano kotao ꞌize mene ohohogano masihihi raꞌehe? Aꞌe Roma goroḡanoꞌe idaḡahe?” ");
INSERT INTO ksj_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Uti vazeḡa boroꞌa eꞌe igirotene, uti vazeḡa ḡihiꞌaḡa vaḡe onamadu niro, “Vaze ꞌahiꞌe Roma mone vazeḡa. Ḡa nougiꞌuma?” ");
INSERT INTO ksj_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ebu uti vazeḡa ḡihiꞌaḡaniꞌa Paulo vaḡe onamadu ḡadiniro, “Ḡa Roma mone vazeḡahe? Ehoꞌi.” Pauloꞌa naenaeniro, “Oꞌe.” ");
INSERT INTO ksj_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ebu uti vazeḡa ḡihiꞌaḡaniꞌa niro, “E hadi boro modadu Roma mone vazeḡa reiro.” Pauloꞌa naenaeniro, “Eꞌe fureraroteꞌe madaḡanonoꞌo Roma mone vazeḡa.” ");
INSERT INTO ksj_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ꞌOuge rae reirotene, Paulo masinadu ḡadimu vaḡihi reiroteꞌe azaḡaꞌe ane mazaonoꞌo zogone vaḡiniro. Ebu uti vazeḡa ḡihiꞌaḡa zuni Pauloꞌe Roma mone vazeḡa raꞌeteꞌe igirotene, riharo, mazaḡa aniꞌa Roma mone vazeḡa obone tiro. ");
INSERT INTO ksj_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Irarirotene, uti vazeḡa ḡihiꞌaḡaniꞌa Iuda azaḡaꞌe nougadu Paulo kotao ohonihi raꞌeteꞌe deheru ederihi reiro. Eꞌanoꞌo Pauloꞌe mae buniro ebu dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu nuꞌonuꞌo azaḡa niduꞌa nuꞌoziro. Ebu Paulo tutune aradu zeḡe zamao ohoniro. ");
INSERT INTO ksj_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pauloꞌa nuꞌonuꞌo azaḡa boroboro ḡiaze ruzeꞌenaꞌa, ḡoeriro, “Nego nabudi, eꞌe ibiteonoꞌo onao izidi Badiꞌa ubumao zamarone duduḡano faine radiu arinu.” ");
INSERT INTO ksj_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ꞌOuge reirotene, dibuꞌo vazeḡa ḡihiꞌaḡa, Ananiaꞌa Paulo babaḡano edauꞌeteꞌe azaḡa ziro, “Ani hebe ꞌue faꞌonoꞌi!” ");
INSERT INTO ksj_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ꞌOugadu Pauloꞌa niro, “Ḡaꞌe toraga ꞌuꞌuru touga radu ꞌuruḡa hina asiroteꞌe biriḡa heuḡa! Badiꞌaꞌa faꞌoꞌiꞌuma! Ḡa eꞌea ehoradu Mose goro ḡoeꞌa idunaḡano kotahiꞌuma raꞌohe. Rehano ḡaꞌe Mose goro ḡoeꞌa variꞌeꞌenaꞌa, e faꞌohoꞌi rae riḡa ziꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ebu Paulo uhiḡano edaroteꞌe azaḡaniꞌa Paulo niro, “Ḡa dibuꞌo vazeḡa ḡihiꞌaḡa rae sausauneꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pauloꞌa naenaeniro, “Nego nabudi, e aniꞌe dibuꞌo vazeḡa ḡihiꞌaḡa rae mene edereha. E veꞌoreha, mazaḡa Buka Zaḡoḡano ꞌahige rae mirihiro, 'Ḡae mone azaḡa zuhiꞌaziꞌeteꞌe vazeḡa ago rae sausaunoꞌi.'” ");
INSERT INTO ksj_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ebu Pauloꞌa nuꞌoraroteꞌe azaḡa boꞌaḡano nuꞌe Sadukea azaḡa zu nuꞌe Farisea azaḡa rae ederadu nuꞌonuꞌo zamaḡano ḡihau ḡoeriro, “Nego nabudi, eꞌe Farisea vazeḡa zu Farisea vazeḡa ubuga. Eꞌe rune vazeḡaniꞌa bare ḡaboditeꞌe zamare guhineꞌeteꞌe uꞌano, kota ꞌada edauꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ꞌOuge reirotene, Farisea azaḡa zu Sadukea azaḡaniꞌa taꞌirotitiro, ebu nu'onu'o azaḡa niduꞌa rovote edaro. ");
INSERT INTO ksj_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Mazaḡa Sadukea azaḡaꞌe ꞌahige rae reiro, “Rune vazeḡaꞌe mene bare ḡabodiꞌuma. Vazeꞌe viga oꞌoꞌa ebu tuḡure viga zuni oꞌoꞌa.” U Farisea azaḡaꞌe eꞌe niduꞌa mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ꞌOugadu haraꞌa ufeta hune bororaro. Ebu Farisea azaḡa boꞌaḡano Mose goro ḡoeꞌa ihozeꞌeteꞌe azaḡa nuꞌa edanadu Paulo bireꞌenaꞌa, ꞌahige rae reiro, “Vaze ꞌahi mazaonoꞌo veꞌoḡa ꞌahoga mene horoneꞌohe. Vine ꞌahoga ga tuḡure viga ꞌahoganiꞌa ani ḡoreniro gaogi!” ");
INSERT INTO ksj_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Taꞌirozeꞌa ufeta bororarotene, Pauloꞌe Iuda azaḡaniꞌa hutube oname onainu. Eꞌanoꞌo uti vazeḡa ḡihiꞌaḡaniꞌa ze Paulo sausauniꞌuma rae rihanadu uti azaḡa ziro, “Ovoradu nu'onu'o azaḡa mazaonoꞌo Paulo riḡa mae vaḡinoꞌi ebu uti azaḡa radone neḡa tutune onamoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Eꞌe oheꞌano Zuhiꞌa Boroꞌa Paulo uhiḡano edanadu niro, “Inare radoꞌi. Ḡaeꞌa Ierusalemao eḡe hari rae fureniroteꞌe teige Roma habaꞌano zuni rae fureniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Irarirotene, Iuda azaḡa nuꞌa nuꞌoranadu Paulo matihi rae sifu ḡoꞌaniro. Zeꞌe Paulo ꞌizema manogano mene ogaꞌuma ga gagiꞌuma rae ḡoereze rinede tiro. ");
INSERT INTO ksj_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ꞌOuge ḡoereze tiroteꞌe azaḡa niduꞌaꞌe 40 vitinoga. ");
INSERT INTO ksj_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ze dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu vaze boroboro vaḡe aradu ziro, “Eme Paulo ꞌizema manogano ogomuni ꞌahoga mene aꞌuma rae ḡoerefe rinede teha. ");
INSERT INTO ksj_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Eꞌanoꞌo zae mazao Paulo bare tuḡunoga veize, za zu nuꞌonuꞌo azaḡaniꞌa uti vazeḡa ḡihiꞌaḡa uminine idaḡahe? Zaeꞌa Paulo faifaine bare ḡadiniꞌuma rae noꞌi. ꞌOugine, Pauloꞌa ꞌizema ꞌada feurogano emeꞌa ibio manoga veize ruhibadu radiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Rehano Paulo ezeḡa ubuganiꞌa zeḡeꞌa toganoga igiro. Ebu Roma uti azaḡa radone neḡa onamadu Paulo niro. ");
INSERT INTO ksj_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ebu Pauloꞌa uti vazeḡa boro ꞌahoga hune aradu niro, “Tahiꞌa iziga ꞌadi uti vazeḡa ḡihiꞌaḡa vaḡe tutune onamoꞌi. Ani hari ꞌahoga rae furenohatihi raꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ebu uti vazeḡa boroꞌa tahiꞌa iziga eꞌe uti vazeḡa ḡihiꞌaḡa vaḡe tutune onamiro. Ebu ani uti vazeḡa ḡihiꞌaḡa niro, “Ḡuꞌa vazeḡa Pauloꞌa huhadu ꞌahige umiheha, 'Tahiꞌa iziga ꞌahi uti vazeḡa ḡihiꞌaḡa vaḡe tutune onamoꞌi. Aniꞌe hari ꞌahoga rae furenohatihi raꞌohe.'” ");
INSERT INTO ksj_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Uti vazeḡa ḡihiꞌaḡaniꞌa tahiꞌa iziga eꞌe genaḡa abine onamadu ḡadiniro, “Ḡa nagini ihihi raꞌohe?” ");
INSERT INTO ksj_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Aneꞌa niro, “Iuda azaḡaniꞌa ḡoere idanadu ohoḡore Pauloꞌe zeḡe nuꞌonuꞌo boro habaꞌa tutune onamoga rae umiꞌiꞌuma. Ze soꞌe Paulo faifaine bare ḡadinihi rae ḡeꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Eꞌanoꞌo ḡa ḡoereze ago egoꞌi. Mazaḡa vaze niduꞌa 40 vitinoga ibio Paulo matihi radu ganate radiꞌuma. Zeꞌe ꞌizema Paulo manogano mene ogaꞌuma ga mene gagiꞌuma rae ḡoereze rinede teha. Izidi zeꞌe ani manoga veize ruhibadu radiuꞌohe zu ḡae ḡoere daꞌo guhineꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Uti vazeḡa ḡihiꞌaḡaniꞌa niro, “Ḡa eꞌe hariḡa ihohataꞌaꞌe vazeni ꞌahoga ago noꞌi.” Ebu ani tuḡune onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ebu uti vazeḡa ḡihiꞌaḡaniꞌa uti vazeḡa boro aheu huze aradu ziro, “Uti azaḡa 200 huze nuꞌozoꞌi. Ebu uti azaḡa 200 garaḡotazeta zu hosi rana ehoradu utiteꞌeteꞌe azaḡa 70 huze nuꞌozoꞌi. Ebu izidi ohere mada fuꞌo ḡazaḡa fare zamaḡano iḡunadu Kaisarea ovoroꞌi. ");
INSERT INTO ksj_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ebu Paulo veize hosi nu moꞌi, ebu gavana vazeḡa Feliki vaḡe faine tutune onamoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ebu aniꞌa gavana vazeḡa veize soꞌa ꞌahoga mirihiro, ");
INSERT INTO ksj_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Eḡe, Kulaudio Lusiaꞌa gavana vazeḡa ḡihiꞌaḡa Feliki mazao uhiu ḡoeꞌa tuḡureꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Vaze ꞌahiꞌe Iuda azaḡaniꞌa obone teadu matihi reiro. Rehano eḡeꞌa uti azaḡa nu teite onamadu Iuda azaḡa mazaonoꞌo mae vaḡiniro, mazaḡa ani Roma mone vazeḡa rae ederiro. ");
INSERT INTO ksj_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ebu eꞌe nagini uꞌano Iuda azaḡaniꞌa maḡuniroteꞌe ederihi radu Iuda azaḡa nu'onu'o boro zamaḡano ani ohoniro. ");
INSERT INTO ksj_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ebu eḡeꞌa ederiro, aniꞌa Iuda azaḡa goro ḡoeꞌa variꞌiroteꞌe uꞌano kotao ohoniro, zu ani mazao haḡai sauꞌa ꞌahoga mene horonadu ḡuꞌa neḡano ohonoga ga runeo tuḡunogaꞌe mene idaḡa. ");
INSERT INTO ksj_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Rehano e Iuda azaḡaniꞌa ani matihi rae ḡoꞌaniroteꞌe igiro ꞌahine, aniꞌe ḡae vaḡe zogone tuḡuneꞌohe. Ebu Iuda azaḡa zuni ani kotao ohonihi reine, ḡae zamao ze zeḡeꞌa bare ani veꞌoḡa rae fureniꞌuma rae ziro.” ");
INSERT INTO ksj_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Eꞌanoꞌo eꞌe oheꞌano uti azaḡaꞌe zeꞌa igiroteꞌe idunaḡano Paulo tutune ovoadu Antipatiri onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Irarirotene, hosi rana ehoradu utiteꞌeteꞌe azaḡaniꞌa Paulo tutune Kaisarea ovoiro. U uti azaḡa odao onamirotaꞌaꞌe Ierusalema bare itiro. ");
INSERT INTO ksj_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Uti azaḡa hosi rana ehoradu utiteꞌeteꞌeꞌa Kaisareao feurirotene, gavana vazeḡa soꞌa eꞌe haro ebu Paulo ani ꞌevoreo tiro. ");
INSERT INTO ksj_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ebu gavana vazeḡaniꞌa soꞌa eꞌe meꞌodadu Paulo ḡadiniro, “Ḡa noꞌe habaꞌa vazeḡa?” Pauloꞌa naenaeniro, “E Kilikia habaꞌa vazeḡa.” ");
INSERT INTO ksj_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Ebu gavana vazeḡaniꞌa niro, “Ḡa kotao ohoꞌihi raꞌeteꞌe azaḡaniꞌa feurine, e ḡae ḡoere igiꞌuma.” Ebu uti azaḡa ziro, “Pauloꞌe kini Heroda ne zamaḡano obone toꞌi zu faine ḡiane radoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Mada fuꞌo enogano dibuꞌo vazeḡa ḡihiꞌaḡa Ananiaꞌa vaze boroboro ebu Roma goroḡa edeḡa vazeḡa, niḡa Teretulo teite Kaisarea ovairo. Ze gavana vazeḡaniꞌa Paulo kotanoga veize ani ꞌutihi reiro. ");
INSERT INTO ksj_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ebu Paulo hune zounirotene, Teretuloꞌa gavana vazeḡa mazao Paulo ꞌuteꞌenaꞌa niro, “Vaze ḡihiꞌaḡa Feliki, ḡa uꞌano eme uniho manoḡa faḡa maha, zu ḡae edeḡa uꞌano habafe zamaḡano ḡau ḡehaḡaniꞌa manoreha. ");
INSERT INTO ksj_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ḡae haḡai manoḡa niduꞌa uꞌano, eme haba niduꞌa zamaḡano matuꞌe rudauꞌenaꞌa, ḡae mazao manoḡa tauḡi raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Madaḡoꞌa mene ufeta hauḡoga veize, ḡa zamaḡo manoḡano emeḡe ḡoere tahiḡa geno egoga umiꞌeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Vaze ꞌahiꞌe emeḡeꞌa ḡianeꞌetene, haḡai sauꞌa haḡaeꞌeteꞌe vazeḡa. Aniꞌe haba niduꞌa zamaḡano Iuda azaḡa tutuzadu harae ḡunuḡuneꞌohe, ebu Nazareta azaḡa duḡuru ibitoziꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Aniꞌe kuru neḡa zuni sausaunihi radu emeḡeꞌa obone tiro. ");
INSERT INTO ksj_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ḡae huneꞌa ane ḡadinine, emeḡeꞌa ani moneo rae fureneꞌeteꞌe ḡoeꞌa niduꞌaꞌe huga rae ederiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ebu Iuda azaḡa zuni Teretulo ḡoere atoneꞌenaꞌa, ani ḡoereꞌe huga rae reiro. ");
INSERT INTO ksj_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ebu gavana vazeḡaniꞌa Pauloꞌa ḡoeroga veize vadiga hina taꞌoro harotene, Pauloꞌa ḡoere iḡuniro, “E edeḡa, ḡaꞌa muri ḡehaḡa Iuda azaḡa kotazeꞌohe. Eꞌanoꞌo eꞌe matuꞌuheta ḡae ubumao eḡe bireꞌeteꞌe ḡoeꞌa rae fureneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","E kuranoga veize Ierusalema itiroteꞌeanoꞌo mada gaubanana aheu fare daꞌo maha. Ḡa eḡe ḡoereꞌe huga rae zogone ederiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","E kotao ohohateꞌe azaḡaꞌe eḡeꞌa kuru neḡa zamaḡano vaze teite taꞌirotitoga mene horoniro. Ebu eḡeꞌa nuꞌonuꞌo neḡa zamaḡano ga Ierusalema zamaḡano vaze ḡuḡuvaḡa tutuze harae tauḡitauḡoga mene horoniro. ");
INSERT INTO ksj_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Izidi zeḡeꞌa eḡe moneo rae fureneꞌeteꞌe ḡoeꞌaꞌe huga rae ihoꞌeꞌeteꞌe vazeḡaꞌe oꞌoꞌa. ");
INSERT INTO ksj_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Rehano e ḡae mazao ꞌahi rae fureneꞌohe. E zeḡeꞌa veꞌoḡa rae raꞌeteꞌe ibiḡa, Iesu Ibiḡano emeḡe vouḡa Badiꞌa mazao kurauꞌohe, ebu Mose goro ḡoeꞌa zu peroveta azaḡaniꞌa mirihiroteꞌe ḡoeꞌa niduꞌa mae ḡihineꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Zeꞌe Badiꞌaꞌa vaze manoḡa zu vaze sauꞌa niduꞌa runeonoꞌo bare ḡaboziteꞌe madaḡa mae ḡihineꞌenaꞌa, guhineꞌohe. Eḡe zuni zeḡe teige, eꞌe guhineꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Eꞌanoꞌo e iḡaiḡa Badiꞌa zu vaze ubumao zamahe deheḡano radoga veize inareꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","E muri nu haba ꞌahogaꞌahogano radiunuteꞌe enogano Iuda azaḡa danaze hadi zenoga veize, zu Badiꞌa dibuꞌohanoga veize bare Ierusalema ariro. ");
INSERT INTO ksj_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","E deheheꞌeteꞌe haḡaiḡa hauḡadu kuru neḡa habaꞌano radiuꞌenogano, Iuda azaḡaniꞌa horohiro. Eꞌe zamaḡano eḡe uhiḡanoꞌe vaze ḡuḡuvaḡa oꞌoꞌa, ebu harae ḡunuḡunoga zuni oꞌoꞌa. ");
INSERT INTO ksj_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Eꞌe madaḡano Iuda azaḡa Asia habaꞌanonoꞌo ariroteꞌeꞌa eꞌea radiro. Eḡeꞌa haḡai sauꞌa haḡairo rae reifone, zeḡeꞌa aradu ḡae mazao eꞌe rae furenifo. ");
INSERT INTO ksj_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ga Iuda azaḡa nuꞌonuꞌo boro zamaḡano eḡe mae ohohadu ḡadihiroteꞌe madaḡano, Iuda azaḡa ꞌahaꞌa nagi haḡai sauꞌa eḡe mazao horoniroteꞌe rae furenine manoḡa. ");
INSERT INTO ksj_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Eḡeꞌa zeḡe boꞌaḡano edanadu ḡihau ḡoeriroteꞌe ḡoeꞌaꞌe ꞌahi daꞌo, 'Vazeꞌe runeonoꞌo bare ḡabodiꞌuma rae raꞌeteꞌe ḡoeꞌa mae ḡihineꞌeteꞌe uꞌano, zae ubumao e kotaheꞌohe.'” ");
INSERT INTO ksj_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felikiꞌe Iesu Ibiḡa moneo faine ederiro ꞌahine, kotaḡa ꞌuadu ꞌahige rae ḡoeriro, “Uti vazeḡa ḡihiꞌaḡa, Lusiaꞌa ovaine ḡoere ḡonaga reꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ebu Felikiꞌa uti vazeḡa boro niro, “Pauloꞌe ḡuꞌa neḡa taufeꞌeteꞌe azaḡa ꞌevora toꞌi. Rehano ibihetaḡaꞌe ago ꞌufunoꞌi ebu nabuganiꞌa dananihi roꞌidene, ago gararoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Mada nu ḡarugano Felikiꞌa inugeta ariro. Inugaꞌe Iuda roḡaeḡa ebu niḡaꞌe Dunisila. Ze Paulo hune aradu Keriso Iesu mazao fieꞌeteꞌe moneo Pauloꞌa ihozeꞌeteꞌe igiro. ");
INSERT INTO ksj_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pauloꞌa vazeꞌa haḡai duduḡa haḡae huniteꞌe, zu ze zeḡeꞌa bare haḡai sauꞌa hezahohauꞌeteꞌe, zu Badiꞌaꞌa vaze kotaziteꞌe moneo ḡoerirotene, Felikiꞌa ḡiḡaronadu niro, “Izidiꞌe eꞌe daꞌo! Ḡa onamine manoḡa. Mada manoḡa ꞌahoga horonine, bare huḡadiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Felikiꞌa ꞌougirotaꞌaꞌe mazaḡa Paulo mazaonoꞌo hadi nu meꞌuma rae zamariro. Eꞌanoꞌo ḡae ḡehaḡa Paulo hune aradu ane teite ḡoerinu. ");
INSERT INTO ksj_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Muri aheu meirotene, Porokio Fesitoꞌa Feliki iḡuꞌa meiro. Rehano Felikiꞌa Iuda azaḡa zamaꞌa manoroga veize Pauloꞌe ḡuꞌa neḡano modiro. ");
INSERT INTO ksj_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fesitoꞌa Kaisarea gavana vazeḡa reiroteꞌe ḡarugano mada uḡidu meirotene, Ierusalema itiro. ");
INSERT INTO ksj_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Eꞌea dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu Iuda azaḡa ibitoziꞌeteꞌe azaḡaniꞌa ane vaḡe aradu Paulo kotao ohonoga veize uminiro. ");
INSERT INTO ksj_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Zeꞌe Paulo Ierusalema bare tutune eroga veize barebare uminiro, mazaḡa ibio ganatadu Paulo matihi rae ḡoꞌaniro. ");
INSERT INTO ksj_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Rehano Fesitoꞌa naenaeziro, “Pauloꞌe Kaisarea ḡuꞌa neḡano obone ti radiuꞌohe, ebu eḡe zuni nariga eꞌe bare ovoeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Eꞌanoꞌo zae boꞌaḡano vaze boroboro nu zuni eḡe teite ovoadu Pauloꞌa haḡai sauꞌa ꞌahoga haḡairo rae roꞌidene, eꞌea ani haḡai sauꞌa rae furenoꞌi.” ");
INSERT INTO ksj_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fesitoꞌa Ierusalemao mada fuꞌo uḡidu fare ga gaubanana zeḡe teite radiroteꞌe enogano, Kaisarea ovoiro. Irarirotene, aniꞌe kota habaꞌano ehoradu Paulo zamahu zounifine ḡoere tuḡuriro. ");
INSERT INTO ksj_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pauloꞌa diuḡirotene, Iuda azaḡa Ierusalemaonoꞌo ovairoteꞌeꞌa ani ḡeḡemaḡe edanadu Paulo ꞌuteꞌeteꞌe ḡoeꞌa aduga ḡehaḡa rae fureniro. Rehano Pauloꞌa haḡai veꞌoḡa haḡairoteꞌe horoniroteꞌe vazeḡaꞌe oꞌoꞌa radu eꞌe hariḡaꞌe huga rae rougaꞌe mene idararo. ");
INSERT INTO ksj_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ebu Pauloꞌa ane bare bireꞌeteꞌe ḡoeꞌa rae fureniro, “Eꞌe Iuda azaḡa goro ḡoeꞌa ga kuru neḡa ga Roma kiniḡa agirohauꞌeteꞌe ḡoeꞌaꞌe mene reiro.” ");
INSERT INTO ksj_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ebu Fesitoꞌa Iuda azaḡa zamaꞌa manoroga veize Paulo ḡadiniro, “Ḡaꞌe Ierusalema itadu eꞌea eḡeꞌa kotaꞌoga urateꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pauloꞌa naenaeniro, “Eꞌe Roma kiniḡa kotao edauꞌohe. Eꞌanoꞌo kota ꞌada kotahiꞌuma. Ḡaꞌe hube hune edeḡa, eḡeꞌa Iuda azaḡa mazao haḡai sauꞌa mene haḡairo. ");
INSERT INTO ksj_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Eḡeꞌa haḡai sauꞌa haḡadu uḡuhiꞌuma rae roꞌidene, eꞌe rudanoga zuni idaḡa. Rehano Iuda azaḡa ꞌadaꞌa rae fureneꞌeteꞌe ḡoeꞌaꞌe mene huga roꞌidene, vaze ꞌahoganiꞌa e zeḡe ꞌevoreo riꞌihogaꞌe mene idaḡa. Eꞌe Roma kiniḡaniꞌa kotahoga urateꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fesitoꞌa ane dananeꞌeteꞌe azaḡa ḡadiziroteꞌe enogano, Paulo niro, “Ḡaꞌe Roma kiniḡaniꞌa kotaꞌoga urateꞌe ꞌahine, Roma kiniḡa vaḡe onamiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Mada nu enogano, kini Agiripa zu Berenikeꞌa Fesito teite unihoga veize Kaisarea ariro. ");
INSERT INTO ksj_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ze Fesito teite mada ḡehaḡa radiuꞌeteꞌe zamaḡano, Fesitoꞌa Paulo hariḡa Agiripa meꞌodoharo, “Felikiꞌa ꞌahao vaze ꞌahoga ḡuꞌa neḡano mae ohoniro. ");
INSERT INTO ksj_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","E Ierusalema itirotene, dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa zu Iuda azaḡa boroboroꞌa aradu Paulo kotao ohoniꞌuma rae reiro, ebu runeo tuḡunoga veize eḡeꞌa kota ḡonaga ḡoeꞌa rouga umihiro. ");
INSERT INTO ksj_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Eꞌanoꞌo e ꞌahige rae ziro, 'Roma goroḡaꞌe ꞌahiguḡa. Kota zamaḡanoꞌe vaze ꞌahoga ꞌutine, vaze aꞌaꞌe ibite geno ꞌuteꞌeteꞌe azaḡa zamao edanadu aneꞌa bare bireꞌeteꞌe ḡoeꞌa rae fureniꞌuma. Eꞌe ḡarugano ḡonaga ḡoeꞌa rae furenadu zeḡe ꞌevoreo riꞌiniꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Eꞌanoꞌo zeḡeꞌa eḡe teite Kaisarea ovairotene, madaḡa mene fanediro. Irarirotene, e kota habaꞌano ehoradu vaze eꞌe zamahu zounifine ḡoere tuḡuriro. ");
INSERT INTO ksj_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ani ꞌutiroteꞌe azaḡaniꞌa ani moneo ḡoere nunu rae fureniro rehano, eḡeꞌa zamariroteꞌe haḡaiḡa sauꞌani ꞌahogaꞌe oꞌoꞌa. ");
INSERT INTO ksj_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Rehano zeꞌe zeḡe Badiꞌa mazao kurauꞌeteꞌe moneo zu rudaroteꞌe vazeḡa ꞌahoga, niḡa Iesu moneo Paulo teite taꞌirotitiro. Pauloꞌa Iesuꞌe ꞌize ḡabodeꞌohe rae fureneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Eꞌe moneo e nougenouge kotanogaꞌe mene ederiro. Eꞌanoꞌo Pauloꞌa Ierusalema itadu eꞌea kotanoga urateꞌe ga meneꞌe ḡadiniro. ");
INSERT INTO ksj_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Rehano Pauloꞌe Kaisarea ḡuꞌa neḡano radoga uratiro, onamo Roma kiniḡaniꞌa kotaniꞌuma. Eꞌanoꞌo uti azaḡa ḡorezadu ani ḡuꞌa neḡano obone tiro, onamo Roma kiniḡa vaḡe tuḡuniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ebu Agiripaꞌa Fesito niro, “Eḡe huneꞌa ani ḡoere igihi.” Fesitoꞌa niro, “Ḡa ohoḡore ani ḡoere igiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Irarirotene, Agiripa zu Berenikeꞌa dabua manoḡa rohorohoḡeta haḡadu uti azaḡa ḡihiꞌaḡaḡihiꞌaḡa zu Kaisarea azaḡa boroboro teite kota diuḡiro. Ebu Fesitoꞌa uti azaḡa zeadu Paulo zamahu zouniro. ");
INSERT INTO ksj_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ebu Fesitoꞌa ḡoeriro, “Kini Agiripa zu emeḡe teite ꞌahi arateꞌe azaḡa niduꞌa, za vaze ꞌahi ḡianeꞌohe. Ierusalemao zu ꞌahao Iuda azaḡaniꞌa aniꞌe ḡabode radoga mene idaḡa rae huauꞌenaꞌa, eḡe mazao ani ꞌuteꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","E ani runeo tuḡuniteꞌe haḡaiḡa ꞌahoga mene horoniro. Rehano aniꞌe Roma kiniḡaniꞌa kotanoga urateꞌe ꞌahine, ani Roma kiniḡa vaḡe tuḡuniꞌuma raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Rehano eꞌe Roma kiniḡa veize nouge rae mirihiꞌuma? Mazaḡa e ani haḡai sauꞌa ꞌahoga mene horoniro. Eꞌanoꞌo zaeꞌa ani ḡadinadu eḡeꞌa mirihiteꞌe ḡoeꞌa ederoga veize, kini Agiripa ane hune zamao zu zae niduꞌa zamao tutune areha. ");
INSERT INTO ksj_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Mazaḡa eḡeꞌa zamareꞌetene, ḡuꞌa vazeḡa ꞌahoga Roma kiniḡa mazao tuḡunine, ane veꞌoḡa mirihadu tuḡuniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Ebu Agiripaꞌa Paulo niro, “Ḡae veize ḡoerogaꞌe idaḡa.” Eꞌanoꞌo Pauloꞌa ꞌevoꞌa mae ḡihinadu ḡoere ḡadahiro, ");
INSERT INTO ksj_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Kini Agiripa, eꞌe izidi matuꞌeꞌohe, mazaḡa Iuda azaḡaniꞌa ḡoere aduga niduꞌa eḡe rana riꞌineꞌeteꞌe uꞌano, e ḡae zamao eḡeꞌa bare birifine ḡoereꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ḡaꞌe Iuda azaḡa haḡai zu zeḡeꞌa taꞌirotiteꞌeteꞌe ḡoeꞌaꞌe faine edereꞌohe. Eꞌanoꞌo e umiꞌeꞌohe, eḡe ḡoere ꞌahi faine egoꞌi onamo ḡonaga. ");
INSERT INTO ksj_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Eḡeꞌa komeꞌanonoꞌo nouge radiunutaꞌaꞌe Iuda azaḡa niduꞌaꞌe edeḡa. Ze eḡeꞌa Iuda azaḡa boꞌaḡano ebu Ierusalema zamaḡano nouge radiunutaꞌaꞌe edeḡa. ");
INSERT INTO ksj_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ze ḡabonehe ḡadaheḡanonoꞌo edeḡa ꞌahine, zeꞌa uratine, eꞌe Farisea vazeḡa ibiḡano radiu areꞌeteꞌe moneo zeḡeꞌa rae furenoga zuni idaḡa. Farisea azaḡaꞌe Iuda azaḡa niduꞌa boꞌaḡano Mose goro ḡoeꞌa inare hegoteꞌeteꞌe azaḡa. ");
INSERT INTO ksj_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ebu izidi eꞌe Badiꞌaꞌa emeḡe vouḡa mazao ḡoitoriroteꞌe ḡoeꞌaniꞌa hudanoga guhineꞌeteꞌe uꞌano, kotao edauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Emeḡe urabo gaubanana aheu fareꞌe eꞌe ḡoeꞌaniꞌa hudanoga radu guhineꞌohe, ebu ohere zu madai Badiꞌa veize inare gaueꞌohe. Kini Agiripa, e eꞌe ḡoitore ḡoeꞌa guhineꞌeteꞌe uꞌano, Iuda azaḡaniꞌa eḡe ꞌuteꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Zaꞌe nougadu Badiꞌaꞌa rune azaḡa bare ḡabozeꞌeteꞌe mene mae ḡihineꞌohe? ");
INSERT INTO ksj_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Eḡe zuni ibite Nazareta vazeḡa Iesu ni ꞌuoga veize inarahe niduꞌa hina gauiꞌuma rae zamariro. ");
INSERT INTO ksj_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","E ꞌuguḡa haḡaiḡa Ierusalemao haḡairo. Ebu dibuꞌo vazeḡa ḡihiꞌaḡaḡihiꞌaḡa niḡano Zuhiꞌa Boro mone azaḡa ḡehaḡa ḡuꞌa neḡano ohoziro, zu ze zimi ruzihi rae reiroteꞌe ḡoeꞌa eḡeꞌa mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ebu nuꞌonuꞌo neḡa niduꞌa diuḡadu ḡae ḡehaḡa aduga ziniro, ebu ze Iesu niḡa rae sausaunoga veize teꞌoteꞌoziro. Ebu e maḡune rudaroteꞌe uꞌano, haba faḡano ne ꞌahogaꞌahoga onamadu Zuhiꞌa Boro mone azaḡa sausauziro.” ");
INSERT INTO ksj_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Mada ꞌahogano eꞌe ꞌougihi radu dibuꞌo azaḡa ḡihiꞌaḡaḡihiꞌaḡa niḡano ḡoereze odohadu Damaseko onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Kini Agiripa, e madai kirikiri Damaseko ibiḡano onameꞌeteꞌea, adureonoꞌo agaḡa boroꞌa agaranoga horoniro. Eꞌe agaḡaꞌe mada agaḡa vitinoga. Eḡe zu eḡe teite onameꞌeteꞌe azaḡa agafi ovairo. ");
INSERT INTO ksj_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Emeḡe niduꞌa rahao higau bauriro. Ebu e Heberu ḡoeꞌano ihiꞌeteꞌe agoḡa ꞌahoga igiro, 'Saulo, Saulo, ḡa nougadu eḡe sausauheꞌohe? Ḡa ire meigameiga futunine, ḡa ḡaeꞌa bare sausauꞌeꞌohe.' ");
INSERT INTO ksj_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ebu eḡeꞌa ḡadiniro, 'Zuhiꞌa Boro, ḡa iniu?' Zuhiꞌa Boroꞌa naenaehiro, 'Eꞌe Iesu, ḡaeꞌa sausauneꞌeteꞌe vazeḡa. ");
INSERT INTO ksj_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Iḡunadu edanoꞌi. Ḡaꞌe eḡe tuḡure vazeḡano ohoꞌifine, zu ḡaeꞌa horonateꞌe hariḡa vaze mazao meꞌodifine, ebu eḡeꞌa ihoꞌiteꞌe ḡoeꞌa rae furenifine, eḡeꞌa ḡae mazao fureraro. ");
INSERT INTO ksj_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","E Iuda azaḡa zu Iuda mene azaḡa mazaonoꞌo ḡa ḡaboꞌadu Iuda mene azaḡa mazao tuḡuꞌiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Aꞌe, ubumaze raꞌanozenadu ze uzabonoꞌo agaḡa moneo mae ḡihuzoga veize, zu Satani ꞌuꞌuḡanonoꞌo mae vaḡizadu Badiꞌa mone rouga veize raꞌohe. ꞌOugine, haḡaize sauꞌa eḡeꞌa rae modiꞌuma, zu zeꞌe eḡe mazao fiadu Badiꞌa mone azaḡa teite ꞌauḡiꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Eꞌanoꞌo kini Agiripa, eꞌe adureonoꞌo fureranadu ihohiroteꞌe ḡoeꞌa daꞌo hegoteꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","E ibite Damaseko azaḡa mazao, Ierusalema azaḡa mazao, Iudea haba azaḡa niduꞌa mazao, ebu Iuda mene azaḡa mazao zuni ꞌahige rae haramiro, 'Zamaze ḡihunadu Badiꞌa vaḡe aroꞌi. Ebu haḡai manoḡa haḡaeꞌenaꞌa, zamaze ḡihunateꞌe furenoꞌi.' ");
INSERT INTO ksj_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Eḡeꞌa ꞌougiroteꞌe uꞌano, Iuda azaḡaniꞌa kuru neḡano obohe teadu uḡuhe ruhihi reiro. ");
INSERT INTO ksj_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Rehano Badiꞌaꞌa danahe onao izidi, e ꞌada edauꞌohe, ebu vaze komeꞌanonoꞌo boro ḡonaga zeḡe niduꞌa mazao hari tiba hina rae fureneꞌohe. Eꞌe ḡoeꞌaꞌe peroveta azaḡa zu Moseꞌa vesuꞌu naginiꞌa fureraꞌuma rae reiroteꞌe ḡoeꞌa. ");
INSERT INTO ksj_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ze ꞌahige rae fureniro, 'Kerisoꞌa aduga hidiꞌuma, ebu rune azaḡa boꞌaḡano ibite bare ḡabodiꞌuma, ebu aneꞌa Iuda azaḡa zu Iuda mene azaḡa mazao ḡabone hiditeꞌe agaḡaḡa haramiꞌuma.'” ");
INSERT INTO ksj_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pauloꞌe ꞌouge reirotene, Fesitoꞌa ḡihau ḡoeriro, “Paulo! Ḡa baboraneha! Ḡae edeḡa ufeta boroꞌa ḡa mae baboꞌeha.” ");
INSERT INTO ksj_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Rehano Pauloꞌa naenaeniro, “Ḡihiꞌa vazeḡa Fesito, eꞌe mene baboraneha. Eḡeꞌa raꞌeteꞌe ḡoeꞌaꞌe hube zu edaꞌeḡa. ");
INSERT INTO ksj_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kini Agiripaꞌe ꞌahi niduꞌa edeḡa ꞌahine, eꞌe mene rihauꞌenaꞌa huga ḡoereꞌohe. Eꞌe edeḡa, kini Agiripaꞌe ꞌahi niduꞌa igi hauḡiro, mazaḡa eꞌeguḡaniꞌa guniꞌa neḡano mene fureraro. ");
INSERT INTO ksj_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kini Agiripa, ḡa peroveta azaḡa ḡoere mae ḡihineꞌehe? E edeḡa, ḡa mae ḡihineꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ebu Agiripaꞌa Paulo niro, “Ḡa mada futuꞌano ḡoere tahiḡa rae furenadu eḡeꞌa Keriso mazao fieꞌeteꞌe vazeḡa reꞌuma rae raꞌehe?” ");
INSERT INTO ksj_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pauloꞌa naenaeniro, “Mada futuꞌa ga faḡaꞌe ago zamaroꞌi. E ḡa zu ꞌada igiꞌeteꞌe azaḡa niduꞌa eḡe teigoga veize Badiꞌa mazao kurauꞌohe. E ḡuꞌa neḡano ohohirotaꞌaꞌe ahiḡa.” ");
INSERT INTO ksj_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ꞌOugadu kini Agiripa, gavana vazeḡa Fesito, zu Berenike, ebu eꞌea ehore radiuꞌeteꞌe azaḡa niduꞌa iḡune edaro. ");
INSERT INTO ksj_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Ze nu'onu'o neḡanonoꞌo buanadu ḡoretitiro, “Vaze ꞌahiꞌe runeo tuḡuniteꞌe ga ḡuꞌa neḡano ohoniteꞌe haḡaiḡa sauꞌa mene haḡairo.” ");
INSERT INTO ksj_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ebu kini Agiripaꞌa Fesito niro, “Vaze ꞌahiꞌe Roma kiniḡaniꞌa kotanoga mene uratifone, ani ḡuꞌa neḡanonoꞌo mae bunifo.” ");
INSERT INTO ksj_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Fesitoꞌa eme Itali habaꞌa onamiꞌuma rae reirotene, Paulo zu ḡuꞌa azaḡa nuꞌe uti vazeḡa ꞌahoga, niḡa Iulio ꞌevoreo riꞌiziro. Iulioꞌe Roma kiniḡa uti azaḡa ibitoziꞌeteꞌe vazeḡa boro ꞌahoga. ");
INSERT INTO ksj_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ebu emeꞌe Adaramateno ne ḡasiḡano tiriro. Ḡasi aꞌaꞌe Asia habaꞌa toḡatoḡaḡano tuetue ragaviro. Eme eꞌe hina ruhau onamiro. Makedonia habaꞌano Tesalonika vazeḡa ꞌahoga, niḡa Arisitako zuni emeḡe teite onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Irarirotene, eme Sidonoo feuriro. Iulioꞌe Paulo mazao manoḡa haḡaeꞌenaꞌa, Pauloꞌa ane edeḡa azaḡa vaḡadu naginiꞌa fereneꞌeteꞌe mougaꞌe idaḡa reiro. ");
INSERT INTO ksj_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ebu eꞌeanoꞌo hena bare ruhanadu Kupuro ꞌumuḡa genaḡano ꞌafe ruhau onamiro, mazaḡa zavaraꞌe emeḡe haohaofe arinu. ");
INSERT INTO ksj_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ebu Kilikia zu Pamufulia habaꞌa davaraḡa bohaꞌano ruhau onamo Lukia habaꞌano Murao hebetiro. ");
INSERT INTO ksj_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ebu eꞌe habaꞌano uti vazeḡa boroꞌa Itali habaꞌa onameꞌeteꞌe ḡasiḡa horoniro. Aꞌe Alesanderia ḡasiḡa. Aniꞌe eme eꞌe ḡasiḡano tutufe tiriro. ");
INSERT INTO ksj_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ebu mada ḡehaḡa teꞌoteꞌauꞌenaꞌa, negane ruhau onamo Kenido davaraḡa bohaꞌano feuriro. Zavaraꞌe ꞌize haohaofe arinu ꞌahine, eꞌe moneo ruhau onamoga mene idararo. Eꞌanoꞌo eme Salomone moneḡudune onamadu Kerete ꞌumuḡano ꞌafe ruhau onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ebu teꞌoteꞌauꞌenaꞌa, zavara haone eꞌe ꞌumuḡa genaḡa uni ruhau onamo Lasea neḡa uhiḡano Toḡatoḡa Manoḡa rae huneꞌeteꞌe toḡatoḡaḡano hebetiro. ");
INSERT INTO ksj_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ꞌOugeꞌenaꞌa, mada ḡehaḡa hauḡiro ꞌahine, ḡasio ruhau onamogaꞌe riḡa zu ḡiḡaroḡa. Mazaḡa Iuda azaḡaniꞌa ogomu moneo zaḡozaḡeꞌeteꞌe madaḡaꞌe vitaro. Eꞌe enoganoꞌe zavara madaḡaniꞌa feuriro ebu ruhauꞌeteꞌe batoḡa ꞌai hauḡiro. Eꞌanoꞌo Pauloꞌa ꞌahige iraduguziro, ");
INSERT INTO ksj_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Zae niduꞌa, eḡeꞌa ḡianeꞌetene, eme ruhau onamine sauꞌa hidiꞌuma. Ḡasi zu tohefe niduꞌaꞌe davarao hunuhuniꞌuma ebu ḡabonefe zuni sautaꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Rehano uti vazeḡa boroꞌe Paulo ḡoere mene mae ḡihinadu ḡasi miruneꞌeteꞌe vazeḡa zu ḡasi vazeḡa ḡoere daꞌo mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Hebetiroteꞌe toḡatoḡaḡaꞌe zavara zu nahune madaḡanoꞌe mene manoḡa uꞌano, vaze niduꞌaꞌe eꞌe habaꞌanonoꞌo ruhau buaro. Ebu Foinike toḡatoḡa onamadu eꞌea zavara zu nahune madaḡa meihi rae reiro. Foinike toḡatoḡaꞌe Kerete ꞌumuḡano toḡatoḡa ꞌahoga, aꞌe madaꞌa zubureꞌeteꞌe moneꞌe bohaꞌa. ");
INSERT INTO ksj_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ebu zavaraꞌa kauri moneonoꞌo tahitahe aradu ze ꞌane mada manoḡaniꞌa areha reiro. Eꞌanoꞌo ḡasi miniḡa hutube zounadu Kerete ꞌumuḡa genaḡa daꞌo uni ruhau onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Rehano mene faḡa onamirotene, zavara boro bagaḡaniꞌa ꞌumu raganonoꞌo gudau ovairo. Aꞌe Iurakulono rae huneꞌeteꞌe zavaraḡa boro. ");
INSERT INTO ksj_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ebu ḡasio ragati aradu zavara roḡoroḡe onamoga mene idaḡa ꞌahine, zavara daꞌo magananiro. ");
INSERT INTO ksj_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ebu Kauda ꞌumuḡa komeꞌa genaḡa ꞌafe diuḡirotuꞌu ḡasi komeꞌa ḡaruna ahasinuteꞌe riḡa hutube zouniro. ");
INSERT INTO ksj_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ebu ḡasi gau azaḡaniꞌa ḡasi ahase zounirotene, mini hina ḡasi boro tatuhe ogoru tiro. Zeꞌe iḡite ḡasiꞌa ruhau onamadu Surutiso habaꞌa hetaꞌano rameruꞌutiꞌuma rae riharo. Eꞌanoꞌo ḡasi faraiḡa zuni hutube bunadu zavara maganani ruhau oname tauḡiro. ");
INSERT INTO ksj_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Rehano zavaraꞌe ꞌize ufeta boro. Eꞌanoꞌo irarirotene, ḡasi gau azaḡaniꞌa ḡasi ufinoga radu odohiroteꞌe toheḡa davarao maemae modiro. ");
INSERT INTO ksj_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ebu mada uḡiduḡa meirotene, ḡasio odohe gaueꞌeteꞌe ḡauḡa zuni maemae modiro. ");
INSERT INTO ksj_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Eme mada ḡehaḡa mada zu buzuva mene horoniro, zu zavaraꞌe ufeta hune sautu radiro. Eꞌanoꞌo emeꞌe mene ḡabodiꞌuma rae zamariro. ");
INSERT INTO ksj_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ze mada ḡehaḡa oganoga mene idararotene, Pauloꞌa zeḡe zamao iḡune edanadu ziro, “Zae niduꞌa, eḡe ḡoere mae ḡihinadu Kerete ꞌumuḡanonoꞌo mene ruhau buafone, ꞌahige aduga mene hidifo zu toheze mene maemae modifo. ");
INSERT INTO ksj_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Rehano e izidi ꞌaha ziꞌohe. Inaroꞌi, mazaḡa vazeni ꞌahoga mene dauḡiꞌuma, u ḡasi daꞌoꞌe dauniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Badiꞌaꞌe eḡe Zuhiꞌa Boro ebu e ani veize gaueꞌohe. Badiꞌa tuḡure viganiꞌa ohoḡore ohere eḡe uhiḡano edaneha, ");
INSERT INTO ksj_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ebu ꞌahige ḡoreheha, 'Paulo, ago rihanoꞌi. Ḡaꞌe Roma kiniḡa zamao edau huniꞌma. Badiꞌaꞌa ḡae mazao manoḡa furenadu ḡae teite idaḡa ruhauꞌeteꞌe azaḡa niduꞌaꞌe Badiꞌaꞌa ḡaboziꞌuma.' ");
INSERT INTO ksj_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Eꞌanoꞌo zae niduꞌa inaroꞌi! E Badiꞌa tuḡure viganiꞌa ehateꞌe ḡoeꞌa niduꞌa hudaꞌuma rae mae ḡihineꞌohe, zu Badiꞌa mazao fieꞌohe. ");
INSERT INTO ksj_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Rehano emeꞌe zavaraꞌa hudi onamadu ꞌumu ꞌahoga hetaꞌano ḡasiꞌa ehoriꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ohere gaubanana ḡazaḡa fare meirotene, Adaria Davaraḡano zavaraꞌa ꞌize hudi vaevaefinu. Ebu eꞌe oheꞌa nemaḡano ḡasio gaueꞌeteꞌe azaḡaꞌe gaba ruhau haniteꞌeteꞌe ederiro. ");
INSERT INTO ksj_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Eꞌanoꞌo ze davara hoeꞌa idanirotene, aꞌe 40 mita heuḡa. Ebu mada tahiḡa enogano bare idanirotene, aꞌe 30 mita reiro. ");
INSERT INTO ksj_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ꞌOugadu eme riharo, mazaḡa ḡasiꞌa vatava rana rameruꞌutiꞌuma reiro. Eꞌanoꞌo eme ḡasi miniḡa ḡazaḡa ḡasi ariḡa ḡuzuḡanonoꞌo mae davarao feuniro, ebu ḡarihe iraroga veize guhiu radiro. ");
INSERT INTO ksj_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Eꞌe zamaḡano ḡasi gau azaḡaniꞌa miniḡa ovoe buneꞌohe rae ḡurireꞌenaꞌa, ḡasi komeꞌa fuiꞌadu zazoꞌano ovoe buniro. ");
INSERT INTO ksj_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Rehano Pauloꞌa uti vazeḡa boro zu uti azaḡa ziro, “Ḡasi gau azaḡaniꞌa ḡasi ꞌahaonoꞌo vaḡinine, zaꞌe mene ḡabodiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Eꞌanoꞌo uti azaḡaniꞌa ḡasi komeꞌa ovoe dabanateꞌe miniḡa tene reꞌadu ruhune modiro. ");
INSERT INTO ksj_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ebu iraraꞌa hanitirotene, Pauloꞌa zeḡe niduꞌa ziro, “Ogomu anoꞌi. Za mada gaubanana ḡazaḡa fare zamaze aduduꞌenaꞌa guhiu areha. Ebu ogomuni ꞌahoga zu mene aneha. ");
INSERT INTO ksj_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Eꞌanoꞌo e umizeꞌohe. Ahirizeꞌa inaradu ḡabone hidoga veize izidi ogomu nu anoꞌi. Zae vadinionoꞌo igu tibani zuni mene dauḡiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Pauloꞌa ꞌouge ziroteꞌe ḡarugano ꞌuvahu odoga madu vaze niduꞌa ubumao Badiꞌa mazao ite kuraro ebu vahegadu aro. ");
INSERT INTO ksj_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ꞌOugadu zeḡe niduꞌa inaradu ogomu mae aro. ");
INSERT INTO ksj_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ḡasi eꞌe zamaḡanoꞌe emeḡe niduꞌa 276ꞌa ehore radiro. ");
INSERT INTO ksj_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Zeḡe niduꞌa ogomu au idararotene, ḡasiꞌa ufiranoga veize ogomu niduꞌa davarao mae modiro. ");
INSERT INTO ksj_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Oheredaꞌo madaꞌa agaru feurirotene, ze noꞌe habaꞌano ruhaunutaꞌaꞌe aḡuꞌa. Rehano zeꞌe haba guniḡa hesaḡeta moneni horoniro. Eꞌanoꞌo ze idaraune eꞌe hesaḡa ranao ḡasi odohe tiriꞌuma rae zamariro. ");
INSERT INTO ksj_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ze ḡasi miniḡa davara zamaḡano tene riꞌi modiro, ebu reva ogoru tiroteꞌe miniḡa fuiꞌiro. Ebu zavara veize farai hutube ḡihinadu hesa mone reve onamiro. ");
INSERT INTO ksj_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Rehano ḡasiꞌe hetaꞌano tutuhanadu zazoꞌa ḡohaꞌe eꞌea teadu mene hune hagariro. Ebu avaḡa ḡuzuꞌe saꞌu boroboroꞌa kafene vahegadu faharo. ");
INSERT INTO ksj_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ebu uti azaḡaniꞌa ḡuꞌa azaḡaꞌe zimi hauḡiꞌuma rae togaziro, mazaḡa zeꞌa ḡemabe onamadu ferau ḡouriꞌuma rae zamariro. ");
INSERT INTO ksj_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Rehano uti vazeḡa boroꞌe Paulo ḡabonihi radu uti azaḡa garariro. Ebu ḡoere riḡa ziro, “Ḡema edeḡa azaḡaꞌe ibite rafatadu ḡemabe onamoꞌi ebu gabao tiroꞌi! ");
INSERT INTO ksj_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","U ḡema aḡuꞌa azaḡaꞌe ḡasi ireḡa rugaruga hina kame ḡemabe onamoꞌi!” ꞌOuge haḡadu zeḡe niduꞌa gabao ḡemabe tiriro zu ḡabode ḡouriro. ");
INSERT INTO ksj_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Emeḡe niduꞌa ḡaboga gabao tirirotene, aꞌe Melite ꞌumuḡa rae ederiro. ");
INSERT INTO ksj_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ꞌUmu eꞌe azaḡaniꞌa eme faifaine danafiro. Iruguꞌa ruꞌaro ebu nahuneꞌa biaro ꞌahine, ze mae ḡihifeꞌenaꞌa, ire rabibofiro. ");
INSERT INTO ksj_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","U Pauloꞌe ire sinuḡa ḡuraꞌe madu ire roga rana mae tiꞌenogano, Zarama ire gigiꞌaniꞌa giginadu ire sinuḡanonoꞌo veore buaro ebu Paulo ꞌevoꞌano vihone giganiro. ");
INSERT INTO ksj_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ebu ꞌumu eꞌe azaḡaniꞌa mohe eꞌe Paulo ꞌevoreo ḡiruḡiranoga horonirotene, ze neneḡaniro, “Vaze ꞌahiꞌe hezoꞌe gorugoru vazeḡa. Ani davarao mene hunuhuneha rehano, eꞌe naeḡa hauꞌeteꞌe badiꞌaḡaꞌe aneꞌa ḡabode radoga mene urateha.” ");
INSERT INTO ksj_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Rehano Pauloꞌa mohe ire roga rana itine modiro ebu sauꞌani ꞌahoga mene hidiro. ");
INSERT INTO ksj_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Zeꞌa Pauloꞌe ꞌahiꞌaniꞌa miniꞌuma ga zogone higau bauradu rudaꞌuma rae zamareꞌenaꞌa, ḡiane radiro. Ze faḡa hune ꞌouge ḡiane radiro, rehano ḡauni ꞌahoga ani mazao mene furerarotene, ze nufe zamaradu ꞌahige rae reiro, “Aniꞌe badiꞌa ꞌahoga!” ");
INSERT INTO ksj_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ꞌUmu eꞌe zuhiꞌaḡa, niḡa Pobelio, ane habaꞌe uhiḡano eꞌe. Aniꞌa eme hufadu neḡano tutufe zoufiro ebu mada uḡidu taufiro. ");
INSERT INTO ksj_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","U Pobelio mogaꞌe uginadu evaneo baze radiunu. Ani ahiriꞌe gigiꞌa bagaḡa zu ru sororinu. Eꞌanoꞌo Pauloꞌa diuḡe ḡianadu kuraro ebu ꞌevoꞌa ane rana teadu fainiro. ");
INSERT INTO ksj_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ꞌUguḡaniꞌa furerarotene, ugi azaḡa ꞌumu eꞌea radiunuteꞌe niduꞌa Paulo vaḡe aradu aneꞌa faiziro. ");
INSERT INTO ksj_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ebu ze nigufeꞌenaꞌa, ḡahunone ḡehaḡa rifiro. Ebu eꞌe ꞌumuḡanonoꞌo ruhau vaḡinihi reirotene, ze emeḡe ragavo veize ferefeꞌeteꞌe toheḡa ḡehaḡa rifiro. ");
INSERT INTO ksj_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Eme bato uḡidu eꞌe ꞌumuḡano radiroteꞌe enogano, ḡasi ꞌahogano tiradu eꞌe habaꞌa mode iḡuniro. Eꞌe ḡasiḡaꞌe nahune madaḡaniꞌa hauḡoga veize Melite ꞌumuḡano guhiu radiro. Aꞌe Alesanderia ne ḡasiḡa, niḡaꞌe Badiꞌa Atoꞌa. ");
INSERT INTO ksj_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Eme ruhau onamo Surakusao hebetadu mada uḡidu eꞌea radiro. ");
INSERT INTO ksj_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ebu hena onamo Regionio hebetiro. Ebu mada tiba radirotene, ariroteꞌe ibiḡa ḡaruganonoꞌo zavaraꞌa ariro ꞌahine, eme ruhau onamadu mada aheuḡano Puteoli toḡatoḡao feuriro. ");
INSERT INTO ksj_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Eꞌea fieꞌeteꞌe azaḡa nu hidirotene ze emeḡe hufadu zeḡe teite fura tiba radiro. Eꞌe enogano, eme gabao onamadu Roma habaꞌano feuriro. ");
INSERT INTO ksj_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Roma zamaḡano fieꞌeteꞌe azaḡaꞌe emeḡe hariḡa igiro. Ebu haofe aradu vaze nuꞌe Apia serosero habaꞌano zu nuꞌe Iꞌudo Neḡa Uḡidu rae huneꞌeteꞌe neḡano hidititiro. Pauloꞌa horozirotene, Badiꞌa mazao manoḡa tauḡi rae reiro ebu zamaḡaniꞌa inariro. ");
INSERT INTO ksj_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Eme Romao feurirotene, Pauloꞌe tuḡunadu ane daꞌo ne ꞌahogano radiro. Ebu uti vazeḡa ꞌahoganiꞌa daꞌo Paulo ḡiane radiro. ");
INSERT INTO ksj_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ebu mada uḡidu enogano, Pauloꞌa Iuda azaḡa ibitoziꞌeteꞌe azaḡa ane neo huze nuꞌoziro. Zeḡeꞌa nuꞌorarotene, Pauloꞌa ziro, “Nego nabudi, e emeḡe nabudi mene sausauzinu zu vouḡafe haḡai mene heꞌeheꞌeninu. Rehano Iuda azaḡaniꞌa Ierusalemao obohe teadu Roma azaḡa ꞌevoreo riꞌihiro. ");
INSERT INTO ksj_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Roma azaḡaniꞌa ḡadihiro rehano, ze ura tuḡuhe buhihi reiro, mazaḡa runeo tuḡuhiꞌuma haḡaiḡa sauꞌa mene horoniro. ");
INSERT INTO ksj_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Rehano Iuda azaḡaniꞌa mene uratiro ꞌahine, eꞌe ibi ꞌahoga oꞌoꞌa radu Roma kiniḡaniꞌa kotahoga veize umidiro. Rehano e eḡe ḡoere ḡumu azaḡa ꞌutihi rae mene reiro. ");
INSERT INTO ksj_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Eꞌe uꞌano, e za ḡiazadu ḡorezoga veize huzeha. Isaraela azaḡaniꞌa guhine arinuteꞌe vazeḡa uꞌano, eꞌe ḡuꞌa neḡano radiuꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ebu ze naenaeniro, “Emeꞌe Iudea habaꞌanonoꞌo ḡae moneo soꞌani ꞌahoga mene meiro. Ebu vazeni ꞌahoga Iudea habaꞌanonoꞌo feuri ariroteꞌeꞌa ḡae moneo sauꞌani ꞌahoga mene rae fureniro zu mene meꞌodiro. ");
INSERT INTO ksj_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Rehano eme ḡaꞌa nouge reihi raꞌeteꞌe igihi raꞌohe. Mazaḡa eme edeḡa, haba niduꞌa zamaḡano vaze niduꞌa ḡae mone azaḡa hezahoziniꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ebu ze Paulo teite bare nuꞌoranoga veize mada ꞌahoga ohoniro. Eꞌe madaḡa meirotene, Iuda azaḡa ufeta ḡehaḡaniꞌa aradu bare ane radone habaꞌano nuꞌoraro. Pauloꞌe oherebauonoꞌo onamo ḡorava, Badiꞌaꞌa zuhiꞌaziꞌeteꞌe moneo rae furenoziniro. Ebu Mose goro ḡoeꞌa zu peroveta azaḡa buka zamaḡanonoꞌo Iesu hariḡa harameꞌenaꞌa, ze Iesu mae ḡihinoga veize inare ḡoreziro. ");
INSERT INTO ksj_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Vaze nuꞌe Paulo ḡoere mae ḡihiniro, u nuꞌe mene mae ḡihiniro. ");
INSERT INTO ksj_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ze zeḡe boꞌaḡano zamaze mene tiba radu iḡunihi reirotene, Pauloꞌa ꞌahige rae ziro, “Vine Zaḡoḡaniꞌa peroveta vazeḡa Isaiaonoꞌo vouḡaze ziroteꞌe ḡoeꞌaꞌe huga. Aniꞌa ꞌahige rae reiro, ");
INSERT INTO ksj_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","'Iuda azaḡa vaḡe onamadu ꞌahige zoꞌi, “Zaꞌe igiꞌe rehano, hugaꞌe mene ederiꞌuma. Zaꞌe horoneꞌe rehano, hugaꞌe mene horoniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Mazaḡa ꞌadi duḡuru zamaꞌe tuḡa zu teḡazeꞌe uhuḡa zu ubumazeꞌe kuruḡa. Ze mene ꞌougifone, ubumaze hina horonifo, teḡaze hina igifo, zamazeo ederifo. Ebu ḡihuradu e ze faizifo.”' ");
INSERT INTO ksj_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Eꞌanoꞌo zaeꞌa ederoga veize ḡoere ꞌahi ziꞌohe. Badiꞌaꞌa ḡabone ziniꞌeteꞌe hariḡaꞌe Iuda mene azaḡa mazao zuni rae fureniro, ebu ze eꞌe hariḡa mae ḡihiniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pauloꞌe muri aheu niduga ꞌize ḡuꞌa neḡano radiunu. Ḡuꞌa neḡa aꞌe aneꞌa naeḡa haḡaeꞌeteꞌe neḡa, ebu iniu ane vaḡe areꞌeteꞌe azaḡa niduꞌa mae ḡihizinu. ");
INSERT INTO ksj_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Pauloꞌe mene rihauꞌenaꞌa, Badiꞌaꞌa zuhiꞌaziꞌeteꞌe moneo haraminu, zu Zuhiꞌa Boro Iesu Keriso moneo ihozinu. Ebu vazeni ꞌahoganiꞌa zuni mene gararoharo. ");
INSERT INTO ksj_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Eḡe, Pauloꞌe Keriso Iesu tuḡure vazeḡa. Badiꞌaꞌa eḡe huhadu apostolo vazeḡano reiro, ebu Badiꞌa hari manoḡa haramoga veize avo mae ohohiro. ");
INSERT INTO ksj_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Hari manoḡa ꞌadiꞌe Badiꞌaꞌa ane peroveta azaḡa mazaonoꞌo Buka Zaḡoḡano mirihiro. Aꞌe Badiꞌaꞌa irina ḡoitoriroteꞌe ḡoeꞌa. ");
INSERT INTO ksj_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Hari manoḡa ꞌadiꞌe ane Ubuga moneo ḡoeriro. Aniꞌe ahirio fureranadu Davida marigano reiro, ");
INSERT INTO ksj_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ebu Vine Zaḡoḡaonoꞌo rune azaḡa boꞌaḡano bare ḡabodadu Badiꞌaꞌa aniꞌe Badiꞌa ubuga inaraḡa rae fureniro. Aniꞌe emeḡe Zuhiꞌa Boro, Iesu Keriso. ");
INSERT INTO ksj_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ani uꞌano Badiꞌaꞌa emeḡe mazao manoḡa furenadu emeꞌa apostolo gauḡa meiro. Aꞌe, emeꞌa Iesu Keriso veize Iuda mene azaḡa niduꞌa tutuzadu zeḡe zuni ani mazao fifine zu ani hegotifine raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Zae zuni Iuda mene azaḡa boꞌaḡano Iesu Keriso mone azaḡa rae rouga veize huziroteꞌe azaḡano reiro. ");
INSERT INTO ksj_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","E Roma ekalesia azaḡa niduꞌa veize soꞌa ꞌahi miriheꞌohe. Badiꞌaꞌa zae zamareꞌohe ebu zaꞌe ane mone azaḡa reifine huziro. Badiꞌa emeḡe Mama zu Zuhiꞌa Boro Iesu Kerisoꞌa zae mazao manoḡa zu zama roḡeḡa ziniꞌenoꞌi. ");
INSERT INTO ksj_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ibite geno, e Iesu keriso uꞌano zae niduꞌa moneo eḡe Badiꞌa mazao manoḡa tauḡi raꞌohe, mazaḡa zaeꞌa fieꞌeteꞌe hariḡaniꞌa haba niduꞌa zamaḡano bororu onameꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","E Badiꞌa Ubuga hari manoḡa harameꞌenaꞌa, zamahe niduꞌa hina Badiꞌa veize gaueꞌohe. Badiꞌaꞌa e eḡe kuruo iḡaiḡa zae zamareꞌetaꞌaꞌe huga rae fureneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Badiꞌa urao eḡeꞌa zae vaḡe amiteꞌe ibiḡa ꞌahoga izidi aniꞌa bohanoga veize e kurauꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","E zae vaḡe amoga urate huneꞌetaꞌaꞌe vine ḡahunoneḡa nu zae teite ḡahugadu inarazifine raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Aꞌe, eꞌa zae teite radiuꞌenaꞌa, zae zu eḡeꞌa fieꞌeteꞌeanoꞌo inaratitifine raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Nego nabudi, e ḡae ḡehaḡa zae vaḡe amihi rae toganiro rehano, ḡau nunuꞌa eꞌe ibiḡa ꞌuido onao izidi. Zaꞌe eꞌe moneo ederoga e urateꞌohe. E Iuda mene azaḡa nunu boꞌaḡano gauadu huga nu hiriviroteꞌe teige, zae boꞌaḡano zuni huga hirivoga veize zae vaḡe amihi rae reiro. ");
INSERT INTO ksj_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Eꞌe edeḡa azaḡa ga guniꞌa azaḡa, ebu huhuzaḡa ga kauriḡa azaḡa, zeḡe niduꞌa mazao hari manoḡa harame huniteꞌe gauḡa meiro. ");
INSERT INTO ksj_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Eꞌanoꞌo e Romao radiuꞌeteꞌe azaḡa, zae mazao zuni hari manoḡa haramoga urate huneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","E hari manoḡa moneo mene mazagaroheꞌohe, mazaḡa hari manoḡa ꞌahiꞌe fieꞌeteꞌe azaḡa niduꞌa ḡabozeꞌeteꞌe Badiꞌaḡa gigiꞌaḡa raꞌohe. Ibite geno Iuda azaḡa ebu hena Iuda mene azaḡa ḡabozeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Hari manoḡaꞌe Badiꞌaꞌa nougenouge emeꞌe ane ubumao duduḡa rae raꞌeteꞌe moneo rae fureneꞌohe. Ḡadaheḡanonoꞌo onamo ḡonagano, emeḡeꞌa fieꞌeteꞌe uꞌano ani emeꞌe duduḡa rae raꞌohe. Buka Zaḡoḡano ꞌahige rae mirihiro, “Badiꞌa ubumao duduḡa rae raꞌeteꞌe azaḡaꞌe fieꞌeteꞌe uꞌano radiꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Haḡai duduḡa mene haḡadu ḡoere huga ꞌueꞌeteꞌe azaḡaniꞌa Badiꞌa mene gubaneꞌohe zu haḡai sauꞌa haḡaeꞌohe. Badiꞌaꞌa haḡaize ꞌuguḡa niduꞌa agirohauꞌohe zu adureonoꞌo zamaḡa ḡugiꞌa fureneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Badiꞌaꞌa ze maḡunoziꞌuma, mazaḡa Badiꞌa moneo edemaziꞌeteꞌe ḡauḡaniꞌa zeḡe mazao deheru fureraro. Badiꞌaꞌa zeꞌe ane moneo ederifine dehene ihoziro. ");
INSERT INTO ksj_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Badiꞌaꞌa adure zu raha haḡairoteꞌe madaḡanonoꞌo onao izidi, Badiꞌa moneo mene horoneꞌeteꞌe ḡauḡaniꞌa deheru fureraro. Emeꞌe ane gigiꞌaḡa radiu tuḡutuḡu zu ane daꞌo Badiꞌa huga rae raꞌeteꞌe mene horoneꞌohe, rehano eꞌe moneoꞌe aniꞌa haḡairoteꞌe ḡauḡa horoneꞌetene deheru edereꞌohe. Eꞌanoꞌo vaze ꞌahoganiꞌa, “E Badiꞌa mene ederiro,” rae mene reꞌuma. ");
INSERT INTO ksj_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Zeꞌe Badiꞌa edeḡa rehano, aniꞌe zeḡe Badiꞌa rae mene gubaniro ebu ani mazao manoḡa tauḡi rae zuni mene reiro. Ebu zamaronezeꞌe huga oꞌoꞌa reiro ebu zamaze kauriḡaꞌe uzaboraro. ");
INSERT INTO ksj_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ze zeḡeꞌa bare huhuzaḡa rae reiro rehano, zeꞌe kauriḡa reiro. ");
INSERT INTO ksj_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Ze radiu tuḡutuḡu Badiꞌaḡa ḡihiꞌa hune mazao mene kuraro, rehano ꞌevoreze hina rudatiteꞌe vazeḡa iraḡa ebu nini, mani, ga dareꞌeteꞌe ḡauḡa iraze haḡadu eꞌe mazao kuraro. ");
INSERT INTO ksj_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Eꞌanoꞌo Badiꞌaꞌe zeḡeꞌa haḡai sauꞌa haḡaihi rae zamareꞌeteꞌe idunaḡano haḡai toraga haḡaifine ze mode tauḡadu ze zeḡeꞌa bare ahirize mae mazagarotitiro. ");
INSERT INTO ksj_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Zeꞌe Badiꞌa ḡoere huga hezahohanadu ḡuriro ḡauḡa mae ḡihiniro. Ebu adure zu raha haḡairoteꞌe Badiꞌaḡa modadu aneꞌa haḡairoteꞌe ḡauḡa mazao kuraro zu eꞌe veize gauiro. Badiꞌaꞌe emeꞌa niguniteꞌe Badiꞌaḡa onamo tuḡutuḡu. Amen. ");
INSERT INTO ksj_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Eꞌe uꞌano, Badiꞌaꞌa ze ahiri urao mazagaro haḡaiḡa haḡaihi rae raꞌeteꞌe zamaroneḡano ze mode tauḡiro. Roḡaeꞌe ohoze teite bazeꞌeteꞌe ibiḡa duduḡa modadu roḡae teite baziro. ");
INSERT INTO ksj_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Eꞌe teige, ohoze zuni roḡae teite bazeꞌeteꞌe ibiḡa duduḡa modadu ohozeꞌa ohoze teite bazihi rae zamareꞌeteꞌeꞌa iriꞌavoziro. Ohozeꞌe ohoze teite mazagaro haḡaiḡa haḡadu haḡaize veꞌoḡa uꞌano hiditeꞌe adugaḡa zeḡeꞌa bare hidiro. ");
INSERT INTO ksj_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Zeꞌe Badiꞌa mae ḡihinoga mene uratiroteꞌe uꞌano, zamaronezeꞌa sautaroteꞌe zamaḡano Badiꞌaꞌa ze modiro, ebu ze mene haḡaiteꞌe haḡaiḡa haḡaifine mode tauḡiro. ");
INSERT INTO ksj_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Zeꞌe haḡai veꞌoḡa nunu, haḡai sauꞌa, ununu, hadi ubumaḡa, zamarone sauꞌa, ahiahi, gorugoru, uti, soꞌosoꞌo, zu agireꞌa iriꞌavozeꞌohe. Zeꞌe dudititeꞌohe, ");
INSERT INTO ksj_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","vaze rae sausauzeꞌohe, Badiꞌa heꞌeheꞌeneꞌohe, vaze ovoe ḡiazeꞌohe, nize mae iteꞌohe, zeḡeꞌa bare niguzeꞌohe, haḡai sauꞌa haḡaeꞌeteꞌe ibiḡa vaḡeꞌohe, vize moze ḡoere mene hegoteꞌohe, ");
INSERT INTO ksj_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","zamaronezeꞌe kauriḡa raꞌohe, zamaze niduꞌa hina mene gaueꞌohe, vaze mene zamareꞌohe zu mene vetuḡaziꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Badiꞌa goro ḡoeꞌa duduḡaniꞌa haḡai nunu ꞌuguḡa haḡaeꞌeteꞌe azaḡaꞌe hube hune rudaꞌuma rae raꞌohe. Ze goro ḡoeꞌa aꞌe edeḡa rehano, zeḡe daꞌo haḡai sauꞌa eꞌe mene haḡaeꞌohe, rehano ꞌouge haḡaeꞌeteꞌe azaḡa zuni niguzeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Eꞌanoꞌo, iniu vaze mazao veꞌoḡa rae raꞌeteꞌe vazeḡa, ḡaꞌe ꞌahige rae mene reꞌuma, “Eḡe mazao veꞌoḡa oꞌoꞌa.” Ḡaeꞌa vaze mazao veꞌoḡa rae raꞌetene, aꞌe ḡa ḡaeꞌa bare veꞌoḡa rae raꞌeteꞌe heuḡa, mazaḡa vaze mazao veꞌoḡa rae raꞌeteꞌe vazeḡa, ḡae zuni zeḡe teige haḡai veꞌoḡa idane haḡaeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Eme edeḡa, ꞌouge haḡaeꞌeteꞌe azaḡaꞌe Badiꞌaꞌa ibi hugano kotaziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ḡaꞌe haḡai veꞌoḡa haḡaeꞌeteꞌe azaḡa mazao veꞌoḡa rae raꞌohe, rehano ḡaeꞌa bare zeḡe teige haḡai tiba idane haḡaeꞌohe. Ḡa Badiꞌa kotaonoꞌo feranogaꞌe idaḡa rae zamareꞌehe? ");
INSERT INTO ksj_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ga ḡa Badiꞌaꞌa ḡae mazao manoḡa borofe fureneꞌeteꞌe, zu mene ḡarihe fase aduga ḡaneꞌeteꞌe, zu zamaḡa obone tiꞌetaꞌaꞌe sauꞌa rae ovoe ḡianeꞌehe? Badiꞌaꞌa ḡae mazao manoḡa haḡadu ḡaeꞌa haḡai sauꞌanonoꞌo ḡihurifine ibitoḡaneꞌetaꞌaꞌe ḡa mene edeḡahe? ");
INSERT INTO ksj_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ḡaꞌe teḡaḡo riḡa zu ḡihurihi rae raꞌeteꞌe zamaroneḡa oꞌoꞌa. Eꞌanoꞌo Badiꞌa kota duduḡaniꞌa fureranadu aniꞌa ḡae mazao zamaḡa ḡuginiteꞌe madaḡano ḡaꞌe aduga hidiꞌuma. Eꞌe madaḡa veize ḡa ḡaeꞌa bare ane zama ḡugiꞌa ḡae rana ufeta ragate nuꞌoneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","“Vazeꞌa nagini haḡairoteꞌe idunaḡano Badiꞌaꞌa eꞌe naeḡa zeḡe tibatiba baronoziniꞌuma.” ");
INSERT INTO ksj_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Vaze nuꞌe aduga zamaḡano zamaze obone tiꞌenaꞌa, manoḡa haḡaeꞌohe. Ze Badiꞌaꞌa nize mae ḡihinoga zu niguzoga ebu mene rudauꞌeteꞌe ḡaboneḡa zenoga urateꞌohe. Zeḡe mazao Badiꞌaꞌa ḡabone tuḡutuḡu ziniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Rehano iniu inaheꞌeteꞌe zu ḡoere huga hezahohanadu haḡai veꞌoḡa hegoteꞌeteꞌe azaḡaꞌe Badiꞌaꞌa zamaḡa ḡugiꞌano maḡunoziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Haḡai sauꞌa haḡaeꞌeteꞌe azaḡa niduꞌaꞌe Badiꞌaꞌa aduga zu gigiꞌa ziniꞌuma. Ibite geno Iuda azaḡa, vesuꞌu hena Iuda mene azaḡa mazao ꞌougiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Rehano haḡai manoḡa haḡaeꞌeteꞌe azaḡa niduꞌaꞌe Badiꞌaꞌa nize mae ḡihiniꞌuma, nize boro rae reꞌuma, zu zama roḡeḡa ziniꞌuma. Ibite geno Iuda azaḡa, vesuꞌu hena Iuda mene azaḡa mazao ꞌougiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Mazaḡa Badiꞌaꞌe vaze mazao mene inaheꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Mose goro ḡoeꞌa aḡuꞌa azaḡaniꞌa haḡai sauꞌa haḡaine, Badiꞌaꞌa Mose goro ḡoeꞌa idunaḡano mene ruiziꞌuma. U Mose goro ḡoeꞌa edeḡa azaḡaniꞌa haḡai sauꞌa haḡaine, Mose goro ḡoeꞌa idunaḡano kotaziꞌuma. ");
INSERT INTO ksj_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Mazaḡa Mose goro ḡoeꞌa igi tauḡeꞌeteꞌe azaḡaꞌe Badiꞌa ubumao duduḡa rae mene raꞌohe, rehano Mose goro ḡoeꞌa hegoteꞌeteꞌe azaḡaꞌe Badiꞌa ubumao duduḡa rae raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Iuda mene azaḡaniꞌa Mose goro ḡoeꞌaꞌe mene meiro. Rehano zeḡe zamaꞌa uratadu Mose goro ḡoeꞌaniꞌa haḡaoꞌi rae raꞌeteꞌe haḡaiḡa haḡaeꞌetene, Mose goro ḡoeꞌaꞌe zeḡe mazao oꞌoꞌa rehano, zamaronezeꞌe zeḡe veize goro ḡoeꞌa raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ze Mose goro ḡoeꞌano haḡaoꞌi rae raꞌeteꞌe ḡoeꞌaꞌe Badiꞌaꞌa zeḡe zamao mirihiroteꞌe ihozeꞌohe. Zamaze zuni aꞌe hube rae fureneꞌohe, eꞌanoꞌo mada nuꞌe ze zeḡeꞌa bare zamaradu zeḡeꞌa bare veꞌoḡa rae raꞌohe, ebu mada nuꞌe zeḡeꞌa bare duduḡa rae bireꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ꞌUguḡaꞌe, eḡeꞌa haramoziniꞌeteꞌe hariḡa manoḡa idunaḡano, Badiꞌaꞌa Iesu Kerisoonoꞌo vaze niduꞌa kotaziteꞌe madaḡano fureraꞌuma. Eꞌe madaḡano aniꞌe vazeꞌa ꞌuꞌuru zamariroteꞌe kotaniꞌuma. ");
INSERT INTO ksj_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Iuda vazeḡa, e ḡae moneo ḡaꞌohe. Ḡa ḡaeꞌa bare Iuda vazeḡa rae raꞌohe. Ḡa Mose goro ḡoeꞌa hegoteꞌenaꞌa radiuꞌohe zu Badiꞌa niguneꞌohe rae raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ḡaꞌe raenaꞌa, “Eꞌe Badiꞌa ura edeḡa, zu Mose goro ḡoeꞌaniꞌa ihohadu naginiꞌe haḡai duduḡa huneꞌe edeḡa,” rae raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Ḡa ḡaeꞌa bare ubumaze kuruḡa azaḡa ibitoziꞌohe, zu uzabo zamaḡano radiuꞌeteꞌe azaḡa agazeꞌohe rae zamare huneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Ebu ḡaꞌe kauriḡa ibitoziꞌeteꞌe vazeḡa zu tahiꞌa komeꞌakomeꞌa ihozeꞌeteꞌe vazeḡa rae zamareꞌohe, mazaḡa ḡaꞌa Mose goro ḡoeꞌanonoꞌo edeḡa huga niduꞌa zu ḡoere huga niduꞌa meiro rae raꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Tena, ḡaꞌe Mose goro ḡoeꞌa ihozeꞌeteꞌe vazeḡa rehano, nougadu ḡa ḡaeꞌa bare mene ihoꞌeꞌohe? Ḡaꞌa, “Ago ḡonotanoꞌi,” rae haramoziniꞌenaꞌa, nougadu ḡaꞌe ḡonotuꞌohe? ");
INSERT INTO ksj_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","“Ubuma ḡezo ago haḡaoꞌi,” rae ziꞌenaꞌa, nougadu ḡaꞌe ubuma ḡezo haḡaeꞌohe? Ḡaꞌa ḡuriro badiꞌaḡa heꞌeheꞌeneꞌenaꞌa, nougadu ḡuriro badiꞌaḡa kuru neḡano ḡonotuꞌohe? ");
INSERT INTO ksj_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ḡaꞌa Mose goro ḡoeꞌa niguneꞌohe. Rehano nougadu eꞌe varadeꞌenaꞌa, Badiꞌa mae mazagaroneꞌohe? ");
INSERT INTO ksj_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Buka Zaḡoḡano ꞌahige rae mirihiro, “Zae uꞌano, Iuda mene azaḡaniꞌa Badiꞌa ni rae sausauneꞌohe.” ");
INSERT INTO ksj_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ḡaeꞌa Mose goro ḡoeꞌa hegotine, ḡa ahiri rana iḡuri haḡairotaꞌaꞌe huḡeta. Rehano Mose goro ḡoeꞌa varadine, ḡaeꞌa ahiri rana iḡuri haḡairotaꞌaꞌe huga oꞌoꞌa radu ahiri rana iḡuri mene haḡairoteꞌe teigiꞌuma. ");
INSERT INTO ksj_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Rehano ahiri rana iḡuri mene haḡairoteꞌe vazeḡaniꞌa Mose goro ḡoeꞌa hegotine, Badiꞌaꞌa aniꞌe ahiri rana iḡuri haḡairoteꞌe vazeḡa heuḡa rae zamariꞌuma. ");
INSERT INTO ksj_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ahiri rana iḡuri mene haḡairo rehano, Mose goro ḡoeꞌa hegoteꞌeteꞌe vazeḡaniꞌa ḡae mazao veꞌoḡa rae ḡeꞌuma, mazaḡa ḡa Moseꞌa mirihiroteꞌe goroḡa ḡoeꞌa meiro zu ahiri rana iḡuri zuni haḡairo rehano, Mose goro ḡoeꞌa varadeꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Enone daꞌo Iuda vazeḡa rae raꞌeteꞌe vazeḡaꞌe mene hube hune Iuda vazeḡa. Ebu enone daꞌo ahiri rana iḡuri haḡairotaꞌaꞌe mene hube hune ahiri rana iḡuri haḡairo. ");
INSERT INTO ksj_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","U zamaonoꞌo Iuda vazeḡaꞌe hube hune Iuda vazeḡa. Ebu Moseꞌa mirihiroteꞌe goroḡa ḡoeꞌa idunaḡano ahiri rana iḡuri haḡaeꞌetaꞌaꞌe mene huga, rehano Vine Zaḡoḡa hina zamao iḡuri haḡaeꞌetaꞌaꞌe hube hune. Vaze ꞌuguḡaꞌe vazeꞌa mene niguneꞌohe, rehano Badiꞌaꞌa niguneꞌohe. ");
INSERT INTO ksj_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Tena, Iuda vazeḡa moneo naginiꞌe manoḡa? Ahiri rana iḡuri haḡaeꞌeteꞌe moneo manoḡaꞌe nagini? ");
INSERT INTO ksj_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ḡau niduꞌa moneo manoḡaꞌe ḡehaḡa. Ibite geno Badiꞌaꞌa ane ḡoere Iuda azaḡa ziniro. ");
INSERT INTO ksj_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Vaze nuꞌa Badiꞌa ḡoere mene mae ḡihinine, naginiꞌa fureraꞌuma? Ze Badiꞌa ḡoere mene mae ḡihineꞌeteꞌe uꞌano, Badiꞌaꞌa ane ḡoitore ḡoeꞌa mene haḡaiꞌumahe? ");
INSERT INTO ksj_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Mene hune zu! Badiꞌaꞌe ane ḡoitore ḡoeꞌa haḡae huniꞌuma! Vaze niduꞌaꞌe ḡu