﻿USE sofia;
DROP TABLE IF EXISTS sofia.ksd_vpl;
CREATE TABLE ksd_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ksd_vpl WRITE;
INSERT INTO ksd_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ta ra vunapaina God i ga vaki ra bala na bakut ma ra rakarakan a gunagunan. ");
INSERT INTO ksd_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ma ra rakarakan a gunagunan i ga purpuruan, ma i kapakapana ka, ma ra lamanana i ga bobotoi; ma ra Tulungea i God i ga bebe ta ra ul a polo. ");
INSERT INTO ksd_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ma God i ga biti: A kapa na vana rikai! Ma ra kapa i ga vana rikai. ");
INSERT INTO ksd_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ma God i ga gire ra kapa i boina; ma God i ga tibe varbaiane vue ra kapa kan ra bobotoi. ");
INSERT INTO ksd_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ma God i ga vatang ra kapa ba a Bung na Keake, ma ra bobotoi ba a Bung na Marum. Ma i ga ravian ma i ga malana, a luaina bung. ");
INSERT INTO ksd_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ma God i ga biti: A ngala na maup na vana rikai livuan ta ra lavur polo, ma na tibe varbaiane ra lavur polo! ");
INSERT INTO ksd_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ma God i ga vaki ra maup ma i ga tibe varbaiane vue ra tava ta ra vavai na maup kan ra tava ta ra ul a maup; ma i ga damana ka. ");
INSERT INTO ksd_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ma God i ga vatang ra ul a maup ba a Bala na Bakut. Ma i ga ravian ma i ga malana, a vauruana bung. ");
INSERT INTO ksd_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ma God i ga biti: A lavur polo ta ra vavai na bala na bakut diat a vana guvai tai ta kopono kiki upi ra pia i ge na vana rikai; ma i ga damana ka. ");
INSERT INTO ksd_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ma God i ga vatang ra pia i ge ba a Gunan, ma ra kiki guvai na lavur polo ba a Ta; ma God i ga gire ba i boina. ");
INSERT INTO ksd_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ma God i ga biti: A vura na gol rikai ta ra pia, ma ra davai ba na vuai ra patina, ma ra davai ba na vuai ra vuaina, tikatikai da kana mangamangana iat; ma diat a tavua tana ta ra gunagunan! Ma i ga damana ka. ");
INSERT INTO ksd_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ma ra vura i ga gol rikai ta ra pia, ma ra davai ba i vuai ra patina da kana mangamangana iat, ma ra umana davai ba diat a vuai ra vuai diat, nina ba diat a tavua tana mulai da kadia mangamangana; ma God i ga gire ba i boina. ");
INSERT INTO ksd_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ma i ga ravian ma i ga malana, a vautulana bung. ");
INSERT INTO ksd_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ma God i ga biti: A umana kapa diat a vana rikai ta ra maup arama liu, upi diat a tibe varbaiane vue ra bung na keake ma ra bung na marum; boina ba diat a umana vakilang ure ra umana e, ma ra umana bung, ma ra umana kilala; ");
INSERT INTO ksd_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ma ra umana kapa diat a ki arama liu upi diat a vakapa ra rakarakan a gunagunan; ma i ga damana ka. ");
INSERT INTO ksd_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ma God i ga vaki a ura ngala na kapa, nina i ngala ta dir i kure ra bung na keake, ma ra ikilik i kure ra bung na marum; ma ra lavur tagul bula. ");
INSERT INTO ksd_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ma God i ga vaki diat arama liu upi diat a vakapa ra gunagunan, ");
INSERT INTO ksd_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ma upi diat a kure ra bung na keake ma ra bung na marum, ma upi diat a tibe varbaiane vue ra kapa ma ra bobotoi. Ma God i ga gire ba i boina ka. ");
INSERT INTO ksd_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ma i ga ravian ma i ga malana, a vaivatina bung. ");
INSERT INTO ksd_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ma God i ga biti: A lavur polo diat a kor ma ra lavur mangana i laun, ma ra umana beo diat a purpururung arama liu ra maup! ");
INSERT INTO ksd_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ma God i ga pait ra lavur konakonom ma ra lavur mangana i laun ma i peal ta ra polo, tikatikai da kana mangamangana iat, ma ra lavur beo i purpururung da kana mangamangana iat; ma God i ga gire ba i boina. ");
INSERT INTO ksd_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ma God i ga tata vadoane diat ma i ga biti: Avat a kakava mulamulai ma avat a vapealane avat, ma avat a kor ta ra polo na ta, ma ra umana beo diat a peal ta ra gunagunan. ");
INSERT INTO ksd_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ma i ga ravian ma i ga malana, a vailimana bung. ");
INSERT INTO ksd_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ma God i ga biti: A lavur mangana i laun na vana rikai ta ra pia, tikatikai da kana mangamangana iat, a umana vavaguai ma ra umana mangana dia kakao ma ra umana leing ta ra pui da kadia mangamangana! Ma i ga damana. ");
INSERT INTO ksd_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ma God i ga pait ra leing ta ra pui da kana mangamangana ma ra umana vavaguai da kadia mangamangana ma ra lavur mangana dia kakao ra pia da kadia mangamangana; ma God i ga gire ba i boina. ");
INSERT INTO ksd_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ma God i ga biti: Dat a pait ra tarai varogop ma dat ma ta ra malalar i dat; ma diat a kure ra en ara na ta ma ra umana beo dia purpururung arama liu ta ra maup, Ta ra umana vavaguai, ma ra rakarakan a gunagunan par, damana bula ra lavur mangana i kakao ra pia. ");
INSERT INTO ksd_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ma God i ga.pait ra tarai ta ra malalarina; ta ra malalar i God i ga pait ia; i ga vaki dir a tutana ma ra vavina. ");
INSERT INTO ksd_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ma God i ga tata vadoane dir ma i ga biti ta dir: Amur a vakubur ra tarai, ma amur a vapealane amur, ma avat a kor ta ra rakarakan a gunagunan, ma avat a uvia pa ia, pi avat a kure ra en na ta ma ra lavur beo liuliu, ma ra lavur mangana i laun ma i kakao ra pia. ");
INSERT INTO ksd_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ma God i ga biti: Gire, iau tar tul tar ta mumur a lavur mangana davai dia vuai ra pat i diat ta ra rakarakan a gunagunan, ma ra lavur davai par dia vuai ra vuai diat, nina diat a tavua mulai tana; amumur magit na nian; ");
INSERT INTO ksd_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ma iau tar tul tar ra lavur davai i lubalubang ta ra lavur mangana vavaguai ma ra lavur beo liuliu, ma ra lavur mangana i kakao ra pia ma i laun, upi adia nian. Ma i ga damana. ");
INSERT INTO ksd_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ma God i ga gire ra lavur magit par i ga pait ia, ma gire, i vakak tuna. Ma i ga ravian ma i ga malana, a valaptikaina bung. ");
INSERT INTO ksd_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Damana i ga pait vapar ra bala na bakut ma ra rakarakan a gunagunan ma ra pepeal magit tana. ");
INSERT INTO ksd_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ma ta ra valavuruana bung God i ga tar pait ot pa kana papalum, nina i ga ongor tana, ma i ga ngo ta ra valavuruana bung kan ra lavur papalum i ga tar pait ia. ");
INSERT INTO ksd_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ma God i ga vadoane ra valavuruana bung ma i ga vagomgom ia, tago i ga ngo kan ra lavur papalum tana, nina i ga vaki ia, ma i ga tar pait ia. ");
INSERT INTO ksd_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Go ia ra vunapai ra bala na bakut ma ra vunapai ra rakarakan a gunagunan ta nam ra e ba di ga vaki dir ma ba ra Luluai God i ga pait ra rakarakan a gunagunan ma ra bala na bakut. ");
INSERT INTO ksd_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Ma pa ta davai na pui i ga gol boko ta ra rakarakan a gunagunan ma pa ta lubang na magit kai ra gunan i ga tar tavua, tago a Luluai God pa i ga tul tar boko ra bata ta ra gunagunan, ma pa ta tutana boko upi na palum ra pia; ");
INSERT INTO ksd_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ia kaka a vual i ga tubang rikai ta ia gunan ma i ga vabilim ra mata i ra rakarakan a gunagunan. ");
INSERT INTO ksd_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ma ra Luluai God i ga pait ra tutana ma ra tobon na pia, ma i ga vu tar ra ubar na nilaun ta ra bilauna; ma ra tutana i ga laun tana. ");
INSERT INTO ksd_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ma ra Luluai God i ga pait tika na uma na davai ta ra papar a taur, ma i ga vaki ra tutana tana, nina. i ga mal ia. ");
INSERT INTO ksd_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ma ra Luluai God i ga vatavua ra lavur davai, ba di manane diat, ma dia topa ra nian; ma ra davai na nilaun bula, i ga tur livuan ta ra, uma, ma ra davai ba da nunure tana ra boina ma ra kaina. ");
INSERT INTO ksd_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ma tika na tava alir i ga vana rikai maro Eden, upi na vabilim ra uma; ma abara i vana varbaiai upi na ivat na tava alir. ");
INSERT INTO ksd_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","A luaina, a iangina Pison, ma i ga alir kikil ra gunan Kavila, nina ba di ga gire ra goled tana; ");
INSERT INTO ksd_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ma ra goled kai nam ra gunan i ga boina; a bulit na davai, a iangina bedolak, i tur bula tana, ma ra bo na vat, a iangina onik. ");
INSERT INTO ksd_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","A vauruana tava alir di vatang ia ba Gion, nina ba i vana kikil ra gunan Kus parika. ");
INSERT INTO ksd_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ma ra iang i ra vautuluna tava alir ba Kidekel, nina i alir upi ra matana taur ta ra gunan Asiria. Ma ra vaivatina tava alir ia ra Oiparat. ");
INSERT INTO ksd_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ma ra Luluai God i ga agure ra tutana ma i ga vaki ia ta ra uma Eden upi na papalum tana ma upi na balaure. ");
INSERT INTO ksd_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ma ra Luluai God i ga vartuluai pire ra tutana, ma i ga biti: Una ian ta ra lavur davai dia tur ta ra uma; ");
INSERT INTO ksd_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ma koko una ian ta ra davai di nunure tana ra boina ma ra kaina, tago nam ra bung u ian tana, a dovotina una virua. ");
INSERT INTO ksd_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ma ra Luluai God i ga biti: Pa i boina ba ra tutana na ki varkolono; ina vaki kapi kana ta tika na tena maramaravut. ");
INSERT INTO ksd_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ma ra Luluai God i ga pait ra lavur vavaguai, ma ra lavur leing kai ra pui, ma ra lavur beo dia vana liu; i ga pait diat ma ra pia, ma i ga agure diat tadav ra tutana, upi na gire ba na vatang diat ma ra ava; ma ra lavur magit i laun na kap nam ra iangina ba ra tutana na vaiang tar ia. ");
INSERT INTO ksd_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ma ra tutana i ga vaiang tar ra iang i ra lavur vavaguai ma ra lavur beo dia vana liu, ma ra lavur leing par kai ra pui; ma pa ta tena maramaravut boko kai ra tutana. ");
INSERT INTO ksd_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ma ra Luluai God i ga tulue ra mamat na nidiop tadav ra tutana; ma ba i tarurungai, i ga tak vue tika na ur na pal a virvirina tana, ma i ga vabonot ra mata ma ra viono. ");
INSERT INTO ksd_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ma ra Luluai God i ga mal pa tika na vavina ma ra ur na pal a virvirina, ma i ga agure pirana. ");
INSERT INTO ksd_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ma ra tutana i ga biti: A uruna tai ra urugu ma a viono tai ra viogu. Da vatang ia ba Vavina, tago di ga pait vaarike tai ra Tutana. ");
INSERT INTO ksd_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Kari a tutana na vana kan tamana ma nana ma na ki pire kana vavina, upi dir tikai ka. ");
INSERT INTO ksd_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ma dir par pa dir ga mal boko, a tutana ma kana vavina, ma pa dir ga vavirvir. ");
INSERT INTO ksd_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ma ta ra lavur leing par ba ra Luluai God i ga pait diat, a vui i lia ma ra kabinana ure ra vavagu. Ma i ga biti tai ra vavina dari: A dovotina vang, God i ga tigal amur, ba koko amur a ian ta ra lavur davadavai ta ra uma? ");
INSERT INTO ksd_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ma ra vavina i ga biti tai ra vui: Amir a ian ta ra vuai ra lavur davai ta ra uma; ");
INSERT INTO ksd_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ia kaka ure ra vuai ra davai livuan ta ra uma God i ga biti dari: Koko amur a ian tana ma koko amur a bili ia, kan amur a mat. ");
INSERT INTO ksd_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ma ra vui i ga biti tai ra vavina: Vakir amur a mat, pata tuna; ");
INSERT INTO ksd_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ma God i nunure ba ta nam ra bung amur a ian tana, na tapala ra mata i mumur, ma amur a vardada ma God ma amur a matoto ta ra magit i boina ma ta ra magit i kaina. ");
INSERT INTO ksd_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ma ba ra vavina i ga gire ba ra davai i topa ra nian, ma ba a magit na varmananai ta ra matana, ma ba ra davai i boina, tago i varvamatoto, i ga takan pa ta vuaina tana ma i ga en ia, ma i ga tabar bula kana tutana me, ma i ga ian. ");
INSERT INTO ksd_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Io, a mata i dir i ga tapala muka, ma dir ga nunure ba pa dir mal; ma dir ga ingit guve ra umana mapina lovo, ma dir ga mal me. ");
INSERT INTO ksd_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ma dir ga valongore ra nilai ra Luluai God, ba i vanavana ta ra uma ta ra vuvu ravian; ma ra tutana ma kana taulai dir ga parau kan ra mata i ra Luluai God, ta ra davadavai na uma. ");
INSERT INTO ksd_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ma ra Luluai God i ga oro pa ra tutana ma i ga biti tana: U ki ave? ");
INSERT INTO ksd_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ma i ga biti: Iau tar valongore ra nilaim ta ra uma, ma iau ga burut, tago pa kaugu ta mal; ma iau ga parau. ");
INSERT INTO ksd_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ma i ga biti: To ia i tar ve u ba pa kaum ta mal? Dave, u tar ian vang ta ra davai, nina iau ga tigal u tana pi koko una ian tana? ");
INSERT INTO ksd_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ma ra tutana i ga biti: Nam ra vavina. u ga vaki ia piragu, ia nam i ga tabar iau ma ra vuai ra davai, ma iau ga ian. ");
INSERT INTO ksd_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ma ra Luluai God i ga biti tai ra vavina: Ava go u tar pait ia? Ma ra vavina i ga biti: A vui i ga vagu pa iau ma iau ga ian. ");
INSERT INTO ksd_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ma ra Luluai God i ga biti tai ra vui dari: Una manga kakaina ta ra lavur vavaguai, ma ra lavur leing ara ra pui, tago u tar pait nam ra magit; una kakao ta ra balam uka, ma una en ra tobon ta kaum nilaun par; ");
INSERT INTO ksd_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ma ina vatur ra kini na ebar pire mumur ma ra vavina, upi amur a ki na ebar vargil, ma damana bula ra umana bul mur tam ma ra umana bul mur tai ra vavina; na nuk upi na rua vadala ra ulum ma una nuk upi una karat vadala ra inabut na kauna. ");
INSERT INTO ksd_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ma i ga biti tai ra vavina: Ina vangala ra lavur kinadik piram, ba una kakava; una kava vaarike ra umana bul ma na tup u ra kinadik tana; kaum mamainga na tur pire kaum tutana, ma na kure u. ");
INSERT INTO ksd_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ma i ga biti tai Adam: Tago u tar torom ta ra nilai kaum vavina, ma u tar ian ta ra vuai na davai nina iau ga tigal u tana dari, Koko una ian tana, a pia na kakaina ure u; na monong u ra papalum, upi una ian tana ta kaum nilaun par. ");
INSERT INTO ksd_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","A kait ma ra kara na tavua tana upi kaum; ma una ian ta ra magit i tavua ta ra uma. ");
INSERT INTO ksd_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Una en ra am magit ta ra mangamangon i ra matam tuk ta nam ra bung, ba una lilikun mulai tadav ra pia, tago di ga pait u mame; tago u a tobon ika, ma una lilikun mulai tadav ra tobon. ");
INSERT INTO ksd_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ma ra tutana i ga vatang kana vavina ba Eva, tago a na i diat par dia lalaun. ");
INSERT INTO ksd_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ma ra Luluai God i ga pait ra mal ure dir ma ra pal a vavaguai, ma i ga vamal dir me. ");
INSERT INTO ksd_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ma ra Luluai God i ga biti: Gire, ra tutana i papait na varogop ma tikai ta dat, tago i nunure ra magit i boina ma ra magit i kaina; ma go upi koko na tulue ra limana ma na tatak pa bula ta ra davai na nilaun, ma na ian, ma na laun vatikai, ");
INSERT INTO ksd_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","ra Luluai God i ga tul vaire vue kan ra uma Eden upi na palum ra pia, nina di ga pait ia me. ");
INSERT INTO ksd_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Damana i ga korot vairop vue ra tutana; ma i ga vaki ra umana angelo ta ra uma Eden, ta ra papar a taur tana, ma dia ga vatur ra pakat na vinarubu i birao ma i tavurvuru, upi diat a balaure ra nga tadav ra davai na nilaun. ");
INSERT INTO ksd_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ma ra tutana i ga la pire Eva kana taulai; ma i ga lalau pa ra bul, ma i ga kava Kain. Ma i ga biti: A Luluai i ga maravut iau, ma iau tar vatur vake tika na tutana! ");
INSERT INTO ksd_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ma i ga kava mule turana Abel. Ma Abel i ga tena balabalaure sip, ma Kain i ga tena vinauma. ");
INSERT INTO ksd_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ma ba i ga par vanavana. ta umana kilala, Kain i ga kap tabar ra Luluai ma ra lavur vuai na davai ra pia. ");
INSERT INTO ksd_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ma Abel bula i ga kap tabar ia ma ra nat na kakava kalama ta kana kikil na sip ma ra bira bula tana. Ma ra Luluai i ga mainge Abel ma kana tinabar, ");
INSERT INTO ksd_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ma pa. i ga mainge Kain ma kana tinabar. Ma Kain i ga kankan tuna ma i ga mata bibian. ");
INSERT INTO ksd_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ma ra Luluai i ga biti tai Kain: Ta ra ava u kankan ma ta ra ava u mata bibian? ");
INSERT INTO ksd_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Pa i damana vang, ba ona u pait ra boina, ra matam na kapa; ma ona pa u pait ra boina, a varpiam i kiki ivai ta ra matakilalat, ma kana mamainga i tur tadav u; ma i boina ba una kure ke. ");
INSERT INTO ksd_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ma Kain i ga ve turana Abel: Dor a vana ra pupui. Ma tika na bung ba dir ki ra pupui Kain i ga tut ure turana Abel, ma i ga ubu doka. ");
INSERT INTO ksd_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ma ra Luluai i ga biti tai Kain: Akave Abel, a turam? Ma i ga biti: Pa iau nunure; dave bar, iau a tena varbalaurai ure turagu? ");
INSERT INTO ksd_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ma i ga biti: Ava u ga pait ia? A nilai ra gapu i turam i kukula upi iau mara ra pia. ");
INSERT INTO ksd_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ma go ina kure vabilak vue u kan ra pia, nina i ga panganga upi na mome ra gapu i turam ta ra limam; ");
INSERT INTO ksd_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","ona u palum ra pia, pa na vuai tar ra vuaina tam mulai. Una puiap ma una tenten vurvurbit ta ra gunagunan. ");
INSERT INTO ksd_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ma Kain i ga biti tai ra Luluai: A balbali piragu i manga ngala, ma i dekdek upi ina puak pa ia. ");
INSERT INTO ksd_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Gire, gori u tar korot vue iau kan ra gunan, ma ina ki ivai ta ra matam; ma iau a puiap ma a tenten vurvurbit ta ra gunagunan, ma ba ta tikai na gire tadav iau, na ubu doko iau. ");
INSERT INTO ksd_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ma ra Luluai i ga biti tana: A dovotina, ba ta tikai na ubu doko Kain, da obo pa ia tana ma ra lavlavurua na pakana. Ma ra Luluai i ga tul tar ta vakilang tai Kain, kan ta tikai na gire tadav ia, ma na ubu doka. ");
INSERT INTO ksd_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ma Kain i ga vana balakane ra mata i ra Luluai, ma i ga ki ta ra gunan Nod, ta ra papar a taur tai ra uma Eden. ");
INSERT INTO ksd_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ma Kain i ga la pire kana vavina; ma i ga kap bala, ma i ga kava Enok; ma i ga pait ra pia na pal, ma i vaiang tar ra iang i natuna tana, ba Enok. ");
INSERT INTO ksd_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ma Enok i ga vangala Irad; ma Irad i ga vangala Makuiael; ma Makuiael i ga vangala Metusael; ma Metusael i ga vangala Lamek. ");
INSERT INTO ksd_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Ma Lamek i ga taule ra ura vavina, tikai a iangina Ada, ma ta ra tikai a iangina Sila. ");
INSERT INTO ksd_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ma Ada i ga kava labal; ia ra tama i diat dia ki ta ra umana pal na mal, ma dia vague ra lavur vavaguai. ");
INSERT INTO ksd_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ma ra iang i turana ba Iubal; ia ra tama i ra umana tena ubu pagol ma ra umana tena vuvu tataru. ");
INSERT INTO ksd_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ma Sila bula i ga kakava, ma i ga kava Tubal-Kain, a tena madaka ta ra lavur magit di pait ia ma ra palariam gobol ma ra palariam tuna. Ma Tubal-Kain dir taina ma Nama. ");
INSERT INTO ksd_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ma Lamek i ga biti ta kana ura vavina dari: Ada ma Sila, amur a valongore ra nilaigu: A ura vavina kai Lamek, amur a valongore kaugu tinata: Iau ga ubu doko tika na tutana, tago i ga kita vakinkin iau; Ma a barmana, tago i ga kita vadala iau; ");
INSERT INTO ksd_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ona da valavurua ma ra varobo ure Kain, A dovotina, da valavurua na vinun ma lavurua ure Lamek. ");
INSERT INTO ksd_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ma Adam i ga la mulai pire kana vavina, ma i ga kava ra bul tutana, ma i ga vatang ra iangina ba Set; tago God i tibe tar ta tika na bul mur tagu ure Abel, nina ba Kain i ga ubu doka. ");
INSERT INTO ksd_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ma Set i ga vangala bula ra bul tutana; ma i ga vatang ra iangina ba Enos; ta nam ra e a tarai dia ga kail tavuna upi ra iang i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Go ia ra buk ure ra lavur taun tarai kai Adam: Ta nam ra e ba God i ga vaki ra tutana, i ga vaki ia varogop ma ra malalar i God; ");
INSERT INTO ksd_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","i ga vaki dir a tutana ma ra vavina; ma i ga tata vadoane dir, ma i ga vatang ra iang i dir ba Adam, ta nam ra bung ba i ga pait dir. ");
INSERT INTO ksd_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ma Adam i ga laun vue tika na mar ma a utul a vinun na kilala, ma i ga vangala tika na bul tutana varogop ma ra malalarina; ma i ga vatang ra iangina ba Set. ");
INSERT INTO ksd_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ma ba i ga tar vangala Set, Adam i ga laun pa lavutul na mar na kilala mulai, ma i ga vangala ra umana bul tutana ma ra umana bul vavina. ");
INSERT INTO ksd_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ma ra lavur bung Adam i ga laun vue, i ga varogop ma lavuvat na mar na kilala ma a utul a vinun; ma i ga mat. ");
INSERT INTO ksd_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ma Set i ga laun vue tika na mar ma a ilima na kilala, ma i ga vangala Enos; ");
INSERT INTO ksd_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ma ba Set i ga tar vangala Enos, i ga laun pa lavutul na mar ma lavurua na kilala mulai, ma i ga vangala ra umana bul tutana ma ra umana bul vavina. ");
INSERT INTO ksd_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ma ra lavur bung na nilaun kai Set i ga varogop ma lavuvat na mar ma a vinun ma a urua na kilala; ma i ga mat. ");
INSERT INTO ksd_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ma Enos i ga laun pa lavuvat na vinun na kilala, ma i ga vangala Kenan; ");
INSERT INTO ksd_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ma ba i ga tar vangala Kenan, Enos i ga laun pa mule lavutul na mar ma a vinun ma a ilima na kilala, ma i ga vangala ra umana bul tutana ma ra umana bul vavina; ");
INSERT INTO ksd_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ma ra lavur bung na nilaun kai Enos dia ga varogop ma lavuvat na mar ma a ilima na kilala; ma i ga mat. ");
INSERT INTO ksd_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ma Kenan i ga laun vue lavurua na vinun na kilala, ma i ga vangala Malalel; ");
INSERT INTO ksd_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","ma ba Kenan i ga tar vangala Malalel, i ga laun pa lavutul na mar ma a ivat na vinun na kilala mulai, ma i ga vangala ra umana bul tutana ma ra umana bul vavina; ");
INSERT INTO ksd_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ma ra lavur bung na nilaun kai Kenan dia ga varogop ma lavuvat na mar ma a vinun na kilala; ma i ga mat. ");
INSERT INTO ksd_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ma Malalel i ga laun vue laptikai na vinun ma a ilima na kilala, ma i ga vangala Iared. ");
INSERT INTO ksd_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ma ba Malalel i ga tar vangala Iared, i ga laun pa lavutul na mar ma a utul a vinun na kilala mulai; ma i ga vangala ra umana bul tutana ma ra umana bul vavina. ");
INSERT INTO ksd_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ma ra lavur bung na nilaun kai Malalel dia ga varogop ma lavutul na mar ma lavuvat na vinun ma a ilima na kilala; ma i ga mat. ");
INSERT INTO ksd_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ma Iared i ga laun vue tika na mar ma laptikai na vinun ma a urua na kilala, ma i ga vangala Enok; ");
INSERT INTO ksd_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ma ba Iared i ga tar vangala Enok, i ga laun pa lavutul na mar na kilala mulai, ma i ga vangala ra umana bul tutana ma ra umana bul vavina. ");
INSERT INTO ksd_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ma ra lavur bung na.nilaun kai Iared dia ga varogop ma lavuvat na mar ma laptikai na vinun ma a urua na kilala; ma i ga mat. ");
INSERT INTO ksd_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ma Enok i ga laun vue laptikai na vinun ma a ilima na kilala, ma i ga vangala Metusela. ");
INSERT INTO ksd_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ma ba Enok i ga tar vangala Metusela, dir ga varagur ma God a utul a mar na kilala, ma i ga vangala ra umana bul tutana ma ra umana bul vavina. ");
INSERT INTO ksd_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ma ra lavur bung na nilaun kai Enok dia ga varogop ma a utul a mar ma laptikai na vinun ma a ilima na kilala. ");
INSERT INTO ksd_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ma Enok dir ga varagur ma God; ma pa di ga gire mule, tago God i ga tak vakari pa ia. ");
INSERT INTO ksd_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ma Metusela i ga laun vue tika na mar ma lavutul na vinun ma lavurua na kilala, ma i ga vangala Lamek. ");
INSERT INTO ksd_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ma ba Metusela i ga tar vangala Lamek, i ga laun pa lavurua na mar ma lavutul na vinun ma a urua na kilala, ma i ga vangala ra umana bul tutana ma ra umana bul vavina. ");
INSERT INTO ksd_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ma ra lavur bung na nilaun kai Metusela dia ga varogop ma lavuvat na mar ma laptikai na vinun ma lavuvat na kilala; ma i ga mat. ");
INSERT INTO ksd_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ma Lamek i ga laun vue tika na mar ma lavutul na vinun ma a urua na kilala ma i ga vangala tika na bul tutana; ");
INSERT INTO ksd_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ma i ga vaiang tar ra iangina ba Noa, ma i ga biti: Go na vamaram dat ure ra varvakai ma ra papalum na lima i dat, nina i vuna ta ra pia, a Luluai i ga tata vakaina. ");
INSERT INTO ksd_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ma ba Lamek i ga tar vangala Noa, i ga laun pa a ilima na mar ma lavuvat na vinun ma a ilima na kilala mulai, ma i ga vangala ra umana bul tutana ma ra umana bul vavina. ");
INSERT INTO ksd_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ma ra lavur bung na nilaun kai Lamek dia ga varogop ma lavurua na mar ma lavurua na vinun ma lavurua na kilala; ma i ga mat. ");
INSERT INTO ksd_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ma Noa i ga laun vue a ilima na mar na kilala. Ma Noa i ga vangala pa Sem, Kam ma Iapet. ");
INSERT INTO ksd_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ma ba i pepeal vanavana ra tarai ta ra rakarakan a gunagunan, ma ba dia vangala ra umana bul vavina, ");
INSERT INTO ksd_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","a umana natu i God, a umana tutana, dia ga gire ra umana natu i ra tarai, a umana vavina, ba ra umana potar, ma dia ga taulai ma nina diat dia ga mainge. ");
INSERT INTO ksd_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ma ra Luluai i ga biti: A tulungeagu pa na vartoto vatikai ma ra tarai, tago dia rara ta ra pal a paka i diat; kadia umana bung na nilaun diat a varogop uka ma tika na mar ma a ura vinun na kilala. ");
INSERT INTO ksd_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ta nam ra tataun a umana lolovina tutana tuna dia ga ki ta ra gunagunan, ma namur ba ra umana natu i God dia ga ruk tadav ra umana natu i ra tarai, dia ga vangala ra umana bul; go diat a umana livuana tutana, nina dia ga rangrang papa ania iat. ");
INSERT INTO ksd_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ma ra Luluai i ga gire ra mangamangana bilak kai ra tarai i ngala tuna ta ra gunagunan ma ra lavur nuknuk i ra bala i diat i ga kaina vatikai. ");
INSERT INTO ksd_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ma ra Luluai i ga nukpuku, tago i ga tar pait ra tarai ati ra pia, ma i ga manga tabun ra balana tana. ");
INSERT INTO ksd_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ma ra Luluai i ga biti: Ina nila vue ra tarai ta ra gunagunan, nina iau ga vaki diat, a tarai ma ra umana vavaguai, ma ra lavur mangana i kakao ra pia ma ra lavur beo liuliu; ma iau nukpuku tago iau ga pait diat. ");
INSERT INTO ksd_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ma ra Luluai i ga mari ka Noa. ");
INSERT INTO ksd_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Go ia ra varvai ure ra taun tarai kai Noa: Noa a takodo na tutana ma i ga ko kakit ta kana tataun; ma Noa dir ga varagur ma God. ");
INSERT INTO ksd_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ma Noa i ga vangala ra utul a bul tutana: Sem, Kam ma Iapet. ");
INSERT INTO ksd_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ma ra rakarakan a gunagunan i ga kaina tuna ta ra luaina mata i God, ma i ga buka ma ra lavur mangamangana bilak. ");
INSERT INTO ksd_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ma God i ga gire ra rakarakan a gunagunan ba i kaina tuna; tago a lavur tarai dia ga vabilak tuna kadia kini ra pia. ");
INSERT INTO ksd_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ma God i ga biti tai Noa dari: A mutuai ra lavur tarai i tar vana rikai piragu, tago dia tar vabuka ra rakarakan a gunagunan ma ra mangamangana bilak; ma gire, ina nila vue diat ma ra rakarakan a gunagunan. ");
INSERT INTO ksd_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Una pait kaum tika na parau ma ra davai, a iangina goper, una tibe ra umana pakana pal tana, ma una vabulit ia ma ra bulit ta ra balana ma ra muruna. ");
INSERT INTO ksd_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ma una pait ia dari: Kana lolovina na varogop ma ra lavurua na vinun ma a ilima na pokono, ma ra tababana a vinun ma a urua ma ngungu na pokono, ma ra tuluaina lavurua ma ngungu na pokono. ");
INSERT INTO ksd_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Una pait tika na mata na kalangar ta ra parau, ma na tur pit ika tika na malmalikun urama ra ul a pal; ma una pait ra matakilalat ta ra papar a parau; una pait ra parau i vartaun, a utul a pakana una pait.ia tana, tikai ra pia, ta ra tikai livuan ma ta ra tikai arama. ");
INSERT INTO ksd_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Tago iau, ina tulue ra ngala na lovon ta ta ra rakarakan a gunagunan upi ina nila vue ra lavur mangana ba ra ubar na nilaun i ki tana ta ra vavai na bakut; a lavur magit ta ra rakarakan a gunagunan na virua. ");
INSERT INTO ksd_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ma ina vatur kaugu kunubu piram, ma una ruk ta ra parau, avat ma ra utul a natum, a utul a tutana, ma kaum taulai ma ra utul a vavina kai ra utul a natum. ");
INSERT INTO ksd_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ma una varuk ia ta ra parau a uraura mangana ta ra lavur magit i laun, upi da valaun diat varurung ma avat, tika na tutana ma tika na tana. ");
INSERT INTO ksd_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ta ra lavur mangana beo, ma ra lavur mangana vavaguai, ta ra lavur mangana i kakao ra pia, a urua ta ra lavur mangana diat a tadav u, upi diat a laun. ");
INSERT INTO ksd_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ma una varurue ra lavur magit di en ia, ma una vung ia, am magit ma adiat bula. ");
INSERT INTO ksd_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ma Noa i ga pait ia damana; i ga pait tuna nam ra lavur magit God i ga tul tar ia tana. ");
INSERT INTO ksd_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ma ra Luluai i ga biti tai Noa: Avat par ta ra kubam, avat a ruk ta ra parau, tago iau tar gire ba u a tena takodo livuan ta go ra taun tarai. ");
INSERT INTO ksd_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ta ra lavur mangana vavaguai dia gomgom una varuk lavlavurua piram, lavurua na tutana ma lavurua na tana; ma ta ra lavur mangana leing ba pa dia gomgom a urua ka, tika na tutana ma tika na tana; ");
INSERT INTO ksd_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ta ra umana beo arama liu lavlavurua, lavurua na tutana ma lavurua na tana; upi ra umana natu i diat diat a laun ta ra rakarakan a gunagunan. ");
INSERT INTO ksd_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Tago a lavurua na bung boko, ma ina tulue ra bata ta ra gunagunan, ma na bata a ivat na vinun na bung na keake ma a ivat na vinun na bung na marum, ma ina vapanie vue ta ra gunagunan ra lavur launa mangana tana, nina iau ga vaki ia. ");
INSERT INTO ksd_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ma Noa i ga pait ra lavur magit da ra Luluai i ga tul tar ia tana. ");
INSERT INTO ksd_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ma Noa i ga tar laun vue laptikai na mar na kilakilala ba ra ngala na lovon ta i ga vana rikai ta ra gunagunan. ");
INSERT INTO ksd_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ma i ga ruk ta ra parau, diat ma ra utul a natuna, a utul a tutana, ma kana taulai, ma ra utul a taulai kai ra utul a natuna, tago ra lovon ta. ");
INSERT INTO ksd_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ma ta ra lavur vavaguai i gomgom, ma ta ra lavur beo liuliu, ma ta ra lavur mangana i kakao ra pia, ");
INSERT INTO ksd_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","a ururua dia ga ruk ta ra parau tadav Noa, tika na tutana ma tika na tana, da God i vartuluai pire Noa. ");
INSERT INTO ksd_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ma ba i ga par lavurua na bung, a ngala na lovon ta i ga vana rikai ta ra gunagunan. ");
INSERT INTO ksd_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ba Noa i ga laptikai na mar na kilala, ta ra vauruana gai ma ra vavinun ma lavurua na bung a umana mata na tava ta ra lamanana dia ga puongo, ma di ga papa are ra umana mata na kalangar ta ra bakut. ");
INSERT INTO ksd_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ma i ga bata ta ra gunagunan a ivat na vinun na bung na keake ma a ivat na vinun na bung na marum. ");
INSERT INTO ksd_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ta nam ra bung iat Noa i ga ruk ta ra parau, diat ma Sem, Kam ma Iapet, a utul a natu i Noa, ma ra taulai kai Noa, ma ra utul a vavina kai ra utul a natuna; ");
INSERT INTO ksd_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","diat ma ra. lavur mangana leing, ma ra lavur mangana vavaguai, ma ra lavur mangana i kakao ra pia, ma ra lavur mangana beo liuliu, ma ra lavur mangana beo di vague diat. ");
INSERT INTO ksd_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ma dia ga ruk ta ra parau tadav Noa, a ururua ta ra lavur mangana dia laun. ");
INSERT INTO ksd_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ma diat dia ga ruk, dia ga ruk a ururua, a tutana ma a tana ta diat par, da God i vartuluai. Ma ra Luluai i ga banu bat ra matakilalat namur tana. ");
INSERT INTO ksd_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ma ra lovon ta i ga alir tar ta ra gunagunan a ivat na vinun na bung, ma ra tava i ga ngala vanavana, ma i ga puak pa ra parau upi na ki rikai ta ra gunagunan. ");
INSERT INTO ksd_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ma ra tava i ga pepeal ma i ga lubu tuna, ma ra parau i ga vanavana ta ra ul a tava. ");
INSERT INTO ksd_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ma ra lovon ta i ga tutua na kaia ta ra gunagunan, ma ra umana ngala na luana par ta ra vavai na bakut dia ga dudu. ");
INSERT INTO ksd_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ma ra tava i ga tutua rikai taun diat a vinun ma a ilima na malmalikun ma i ga tuba ra umana luana. ");
INSERT INTO ksd_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ma ra lavur mangana dia ga laun ta ra rakarakan a gunagunan dia ga virua; a umana beo ma ra umana vavaguai, ma ra lavur leing ma ra lavur mangana par i kakao ra pia, ma ra tarai par bula; ");
INSERT INTO ksd_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","a lavur mangana par ba a vuvu na nilaun i tur ta ra bilauna ma i ga ki ta ra pia i matetek, i ga virua. ");
INSERT INTO ksd_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ma i ga nila vue ra lavur mangana par i ga laun ta ra gunagunan, a tarai ma ra vavaguai, ma ra lavur mangana dia ga kakao ra pia ma ra lavur beo arama liu; ma dia ga panie ta ra gunagunan; ia kaka Noa i ga mat valili, ma diat dia ga ki varurung me ta ra parau. ");
INSERT INTO ksd_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ma ra lovon ta i ga lubu ta ra gunagunan a mar ma a ilima na vinun na bung. ");
INSERT INTO ksd_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ma God i ga nuk pa Noa ma ra lavur magit dia ga laun, ma ra lavur vavaguai dia ga ki pirana ta ra bala na parau; ma God i ga vatut pa ra vuvu upi na vuvu ta ra gunagunan, ma ra lovon ta i ga mama vanavana. ");
INSERT INTO ksd_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ma i ga ang bat bula ra umana mata na tava ta ra lamanana ma ra umana mata na kalangar arama ra bakut, ma i ga tigal ra bata marama. ");
INSERT INTO ksd_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ma ra tava ta ra gunagunan i ga ikilik vanavana, ma ba i ga par tika na mar ma a ilima na vinun na bung, i ga papait na mama. ");
INSERT INTO ksd_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ma ra parau i ga ki pukai ta ra ul a luana, a iangina Ararat. ta ra gai lavurua, a bung a vinun ma lavurua. ");
INSERT INTO ksd_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ma ra tava i ga mama vanavana ma i ga tuk ta ra vavinun na, gai. Ma ta ra luaina bung ta ra vavinun na gai di ga gire ra ul a lualuana. ");
INSERT INTO ksd_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ma ba i ga par a ivat na vinun na bung, Noa i ga papa are ra mata na kalangar ta ra parau, nina i ga pait ia; ");
INSERT INTO ksd_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ma i ga tul vue ra kotkot; go i ga vatapiloi ka tuk ta nam ra bung ba i ga mama tuna ra tava ta ra gunagunan. ");
INSERT INTO ksd_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ma i ga tul vue ra uka upi na nunure tana ba i ga mama ra tava ta ra pia ba pata; ");
INSERT INTO ksd_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ma ra uka pa i ga gire tadav ta pakana ba na rakan tana, ma i ga talil mulai pirana ta ra parau, tago a tava i ga ki boko ta ra mata i ra rakarakan a gunagunan, ma i ga tulue vairop ra limana, ma i ga vatur vake, ma i ga varuk mule pirana ta ra pal na parau. ");
INSERT INTO ksd_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ma i ga ki pa mule lavurua na bung; ma i ga tulue mule ra uka kan ra parau; ");
INSERT INTO ksd_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ma ta ra ravian a uka i ga lilikun pirana, ma gire, i ga kap ra kalamana mapina oliva ta ra ngiene; io, Noa i ga nunure tana, ba i ga tar mama ra tava ta ra gunagunan. ");
INSERT INTO ksd_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ma i ga ki pa ta ra lavurua na bung ma i ga tul vue ra uka; ma pa i ga lilikun mulai pirana. ");
INSERT INTO ksd_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ma ta ra kilala laptikai na mar ma tikai, ta ra luaina gai ma ra luaina bung ta ra gai a tava i ga mama kakit ta ra gunagunan; ma Noa i ga tak vue ra tubatuba ta ra pal na parau, ma i ga gigira, ma ra mata i ra pia i ga mage. ");
INSERT INTO ksd_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ma ta ra vauruana gai, ta ra bung a ura vinun ma lavurua i ga mage ra pia. ");
INSERT INTO ksd_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ma God i ga biti tai Noa dari: ");
INSERT INTO ksd_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Una irop ta ra parau, avat ma kaum taulai, ma ra utul a natum ma ra utul a vavina kai ra utul a natum. ");
INSERT INTO ksd_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Una agure vairop diat bula a lavur mangana i laun piram, a umana beo, ma ra umana vavaguai, ma ra lavur mangana i kakao ra pia, upi diat a manga kakava ta ra gunagunan, ma upi diat a tavua, ma diat a peal ta ra gunagunan. ");
INSERT INTO ksd_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ma Noa i ga irop ma ra utul a natuna, ma kana taulai, ma ra utul a vavina kai ra utul a natuna; ");
INSERT INTO ksd_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","a lavur leing ma ra lavur vavaguai, a lavur mangana par i kakao ra pia ma ra lavur beo, a lavur mangana par i laun ta ra gunagunan i ga irop ta ra parau da kadia vuvuna iat. ");
INSERT INTO ksd_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ma Noa i ga pait ra uguugu na vartabar upi kai ra Luluai, ma i ga tatak ta ra lavur vavaguai dia gomgom, ma ra lavur beo i gomgom,. ma i ga vartabar ma ra tinabar di tuntun tar ia. ");
INSERT INTO ksd_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ma ra Luluai i ga angine ra vuvuluna i kalami, ma ra Luluai i ga biti ta ra balana dari: Pa ina tata vakaina ra pia mulai ure ra tarai, tago ra nuknuk i ra bala i diat i kaina papa ra bung dia bul tana, ma pa ina ubu mule ra lavur mangana i laun, da iau tar pait ia. ");
INSERT INTO ksd_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ta ra lavur tataun, ba a rakarakan a gunagunan na tur tana, a e na vinauma ma ra e na minatuka, a madoldol ma ra malamalapang, a kilala na taubar ma ra kilala na labur, a bung na keake ma ra bung na marum pa na panie mulai. ");
INSERT INTO ksd_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ma God i ga tata vadoane Noa ma ra utul a natuna, a utul a tutana, ma i ga biti ta diat: Avat a vangala ra umana natu i vavat ma avat a vapealane avat, ma avat a kor ta ra rakarakan a gunagunan. ");
INSERT INTO ksd_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ma ra bunurut ure avat ma ra nidadar ure avat na tup ra lavur leing ma ra lavur vavaguai, ma ra lavur beo liuliu ma ra lavur mangana i kakao ra pia, ma ra lavur en ara na ta; di tul tar diat ta ra lima i vavat. ");
INSERT INTO ksd_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Avat a ian ta ra lavur magit i vanavana ma i laun; da ra davai i lubalubang, damana iau tul tar ia ta vavat a lavur mangana parika. ");
INSERT INTO ksd_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","la kaka koko avat a en ra kanomong i ra mangana, ona kana nilaun, a gapuna, i ki boko tana. ");
INSERT INTO ksd_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ma ina bali ra gapu i vavat, kavava nilaun, pire diat ra lavur mangana i laun, ma pire ra lavur tarai, maia, pire ra tura i ra tutana ina ga bali ra gapuna. ");
INSERT INTO ksd_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Nina i ubu doko ta tutana, a tarai diat a ubu doko bula nam; tago God i ga pait ra tarai varogop ma ia mulai. ");
INSERT INTO ksd_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ma avat, boina avat a vangala ra mangoro na natu i vavat, ma avat a vapealane avat; avat a kakava mulamulai upi avat a pepeal tana. ");
INSERT INTO ksd_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ma God i ga biti tai Noa ma ra utul a natuna dari: ");
INSERT INTO ksd_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Ma iau, gire, iau ina vatur kaugu kunubu pire vavat ma pire kavava lavur bul mur; ");
INSERT INTO ksd_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ma pire ra lavur magit i laun pire vavat, ra beo liuliu, ra vavaguai ma ra leing par ta ra rakarakan a gunagunan pire vavat, ta diat par dia irop ta ra parau; maia, a lavur mangamangana i laun ta ra gunagunan. ");
INSERT INTO ksd_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ma ina vatur kaugu kunubu pire vavat; ma pa da nila vue mule ra lavur mangana i laun ma ra lovon ta; ma pa ta lovon ta mulai upi na vakaina vue ra gunagunan. ");
INSERT INTO ksd_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ma God i ga biti: Go ia ra vakilang ure ra kunubu, nina ina pait ia pire vavat, ma ra lavur mangana i laun pire vavat, upi na tur vatikai: ");
INSERT INTO ksd_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ina vaki kaugu gogol ta ra bakut, ma na da ra vakilang ure ra kunubu pire mimir ma ra rakarakan a gunagunan. ");
INSERT INTO ksd_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ma ba ina tulue vaarike ra bakut ta ra gunagunan, ra gogol na vana rikai ta ra bakut, ");
INSERT INTO ksd_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ma ina nuk pa kaugu kunubu pire dat ma ra lavur mangana i laun; ma ra umana tava pa diat a lovon mulai upi ra lavur mangana na virua tana. ");
INSERT INTO ksd_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ma ra gogol na kiki ta ra bakut; ma ina gire ung ia, ma ina nuk pa ra kunubu tukum pire God ma ra lavur mangana i laun ra pia. ");
INSERT INTO ksd_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ma God i ga biti tai Noa: Go ia ra vakilang ure ra kunubu, nina iau tar vatur ia pire dat ma ra lavur mangana i laun ra pia. ");
INSERT INTO ksd_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Ma go ra utul a natu i Noa dital ga irop kan ra pal na parau: Sem, Kam ma Iapet; ma Kam dir tamana ma Kanaan. ");
INSERT INTO ksd_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Dital go a utul a natu i Noa; ta go dital a tarai dia tavua ta ra rakarakan a gunagunan. ");
INSERT INTO ksd_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Ma Noa a tena vinauma, ma i ga pait tika na uma na vain; ");
INSERT INTO ksd_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","ma i ga mome ra polo na vain ma i ga longlong tana; ma i ga pala vue kana mal ta kana pal na mal. ");
INSERT INTO ksd_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ma Kam, tama i Kanaan, i ga gire ra paka i tamana, ma i ga ve ra ura turana tana ara ra pia. ");
INSERT INTO ksd_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ma Sem ma Iapet dir ga tak pa tika na mal ma dir ga vung ia ta ra ul a vara i dir, ma dir ga vana murmur, ma dir ga tuba ra paka i ra tama i dir, ma dir ga lingan kan ia; ma pa dir ga gire ra paka i tama i dir. ");
INSERT INTO ksd_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ma Noa i ga minana mulai kan ra vain, ma i ga matoto ta ra magit nina natuna a muruna i ga tar pait ia pirana. ");
INSERT INTO ksd_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ma i ga biti: Kanaan na kakaina ka; Na ki na vilavilau tuna pire ra ura turana. ");
INSERT INTO ksd_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ma i ga biti: Da pite pa ra Luluai God kai Sem; Ma Kanaan kana tultul uka. ");
INSERT INTO ksd_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","God na vangala pa Iapet; Na ki boko ta ra umana pal kai Sem; Ma Kanaan kana tultul uka. ");
INSERT INTO ksd_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ma ba i ga par ra lovon ta, Noa i ga laun boko a utul a mar ma a ilima na vinun na kilala. ");
INSERT INTO ksd_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ma ra bung na nilaun par kai Noa i ga varogop ma lavuvat na mar ma a ilima na vinun na kilala; ma i ga mat. ");
INSERT INTO ksd_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ma go diat ra lavur taun tarai kai ra utul a bul tutana kai Noa: Sem, Kam ma Iapet; ma ba i ga tar par ra lovon ta, dital ga vangala ra umana natu i dital. ");
INSERT INTO ksd_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","A umana natu i Iapet, a umana tutana, go diat: Gomer, ma Magog, ma Madai, ma Iavan, ma Tubal, ma Mesek, ma Tiras. ");
INSERT INTO ksd_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ma ra umana natu i Gomer, a umana tutana go dital: Askenas, ma Ripat, ma Togarma. ");
INSERT INTO ksd_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ma ra umana natu i Iavan, a umana bul tutana: Elisa ma Tarsis, Kitim ma Dodanim. ");
INSERT INTO ksd_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Go diat dia ga vana varbaiai, ma dia ga ki ta ra valvalian kai ra umana Tematana ta kadia gunan, tikatikai da kana tinata; ma da kadia vuna tarai ma kadia taun tarai. ");
INSERT INTO ksd_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ma ra umana natu i Kam: Kus. ma Misraim, ma Put, ma Kanaan. ");
INSERT INTO ksd_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ma ra umana natu i Kus: Seba, ma Kavila, ma Sabta, ma Rama, ma Sabteka. Ma ra ura natu i Rama: Seba ma Dedan. ");
INSERT INTO ksd_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Ma Kus i ga vangala Nimrod: go i ga luluai tavuna. ta ra gunagunan. ");
INSERT INTO ksd_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","A ngala na tena nirovoi ta ra mata i ra Luluai; kari a vatavatang dari: A ngala na tena nirovoi ta ra mata i ra Luluai da Nimrod. ");
INSERT INTO ksd_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ma kana varkurai i ga tur pa ia aro Babel, ma Erek, ma Akat, ma Kalene, ta ra gunan Sinar. ");
INSERT INTO ksd_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ma i ga irop ta nam ra gunan, ma i ga vana uro Asiria, ma i ga pait ra pia na pal Nineve ma Rekobot-Ir, ma Kala ");
INSERT INTO ksd_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ma Resen. nina i tur livuan ta dir Nineve ma Kala; ia ra ngala na pia na pal. ");
INSERT INTO ksd_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ma Misraim i vangala ra tarai Ludim ma Anamim, ma Leabim ma Naptukim; ");
INSERT INTO ksd_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","damana bula ra tarai Patrusim ma Kaslukim, (nina ra tarai Pilistia dia ga vana rikai tana), ma ra tarai Kaptor. ");
INSERT INTO ksd_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ma Kanaan i ga vangala Sidon, kana luaina, ma Ket; ");
INSERT INTO ksd_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","damana bula ra tarai Iebus, ma ra tarai Amor, ma ra tarai Girgas; ");
INSERT INTO ksd_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ma ra tarai Kivi ma ra tarai Ark, ma ra tarai Sin; ");
INSERT INTO ksd_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ma ra tarai Arvad, ma Semar, ma Kamat; ma namur a umana vuna tarai Kanaan dia ga peal vanavana. ");
INSERT INTO ksd_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ma ra langun kai ra tarai Kanaan i ga tur pa ia aro Sidon, ma i tuk ta ra gunan Gerar ma Gasa; damana bula tuk ta ra langun Sodom, Adma ma Seboim. tuk ta ra gunan Lasa. ");
INSERT INTO ksd_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Go diat ra umana natu i Kam, varogop ma kadia umana vuna tarai ma kadia umana vuna tinata, ta kadia umana gunan ma kadia taun tarai. ");
INSERT INTO ksd_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Ma Sem.bula i ga vangala ra umana bul; Sem nam ia ra tama i ra tarai Eber, ma dir turana ma Iapet, ma i ga lua ta dir. ");
INSERT INTO ksd_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Go ra umana natu i Sem: Elam, Asur, Arpaksad, Lud ma Aram. ");
INSERT INTO ksd_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ma ra umana natu i Aram: Us ma Kul, ma Geter ma Mas. ");
INSERT INTO ksd_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Ma Arpaksad i ga vangala Sela, ma Sela i ga vangala Eber. ");
INSERT INTO ksd_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ma Eber i ga vangala a ura natuna; tikai, a iangina Peleg, tago ta kana e di ga tibe varbaiane ra gunagunan; ma turana, a iangina Ioktan. ");
INSERT INTO ksd_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ma Ioktan i ga vangala Almodad, ma Selep, ma Kasarmavet, ma Iera; ");
INSERT INTO ksd_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ma Adoram, ma Usal, ma Dikla; ");
INSERT INTO ksd_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ma Obal, ma Abimael, ma Seba; ");
INSERT INTO ksd_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ma Opir, ma Kavila, ma Iobab; go diat par ra umana natu i Ioktan. ");
INSERT INTO ksd_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ma ra langun u ra gunan dia ga ki tana, i ga tur pa ia aro Mesa ma i tuk ta ra langun Separ, ra lualuana ta ra papar a taur. ");
INSERT INTO ksd_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Go diat ra umana natu i Sem da kadia vuna tarai ma kadia vuna tinata, ta kadia gunagunan ma da kadia lavur taun tarai. ");
INSERT INTO ksd_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Go diat ra umana vuna tarai kai ra umana natu i Noa, varogop di ga vangala diat ta kadia lavur taun tarai; ma ta go diat ra lavur vuna tarai ta ra rakarakan a gunagunan dia ga tavua varbabaiai ba i ga par ra lovon ta. ");
INSERT INTO ksd_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ma ra tinata ma ra pirpir ta ra rakarakan a gunagunan i ga kopono ko. ");
INSERT INTO ksd_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ma ba dia ga vana uro ta ra papar a taur, dia ga gire tadav tika na ngala na pia i tamataman ta ra gunan Sinar; ma, dia ga ki abara. ");
INSERT INTO ksd_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ma dia ga vargat vargiliane diat dari: Io, dat a pait ra umana vat na pia ma dat a tun bulu diat. Ma dia ga papait pal ma ra vat na pia, da ma ra vat tuna, ma ra pia i bulit kadia kabang. ");
INSERT INTO ksd_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ma dia ga biti: Io, dat a pait tika na pia na pal, ma ra ngala na bur na pal i manga tuluai urama; a lamiana na tuk ta ra bakut, upi na rararang ra iang i dat, kan dat a ki varbabaiai boko ta ra rakarakan a gunagunan par. ");
INSERT INTO ksd_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ma ra Luluai i ga irop upi na gire ra pia na pal ma ra ngala na bur na pal, nina ba ra umana natu i ra tarai dia ga pait ia. ");
INSERT INTO ksd_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ma ra Luluai i ga biti: Gire, go ra tarai i kopono ko ma kadiat par ta kopono tinata ka; ma go ra magit dia pait vatavuna; ma go ona dia nuk pa ta magit upi diat a pait ia, pa na tabu mulai pire diat. ");
INSERT INTO ksd_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Io, dat a irop, ma dat a vapurpuruan kadia pirpir abara upi koko diat a valongore ilam mule kadia tinata vargil. ");
INSERT INTO ksd_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Damana ra Luluai i ga okokole varbabaiane diat ta ra rakarakan a gunagunan par, ma dia ga ngo ma ra papait pia na pal. ");
INSERT INTO ksd_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Kari di ga vatang ra iangina Babel, tago a Luluai i ga vapurpuruan ra tinata kai ra tarai par, ma i ga tulue varbabaiane diat ta ra rakarakan a gunagunan. ");
INSERT INTO ksd_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ma go ra umana vuna tarai kai Sem. Sem i ga laun vue tika na mar na kilala ma i ga vangala Arpaksad, a ura kilala i taun ra lovon ta. ");
INSERT INTO ksd_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ma ba i ga tar vangala Arpaksad, Sem i ga laun a ilima na mar na kilala mulai, ma i ga vangala ra umana bul tutana ma ra umana bul vavina. ");
INSERT INTO ksd_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpaksad i ga utul a vinun ma a ilima kana kilala, ma i ga vangala Selak; ");
INSERT INTO ksd_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ma ba i ga tar vangala Selak i ga laun a ivat na mar ma a utul a kilala mulai, ma i ga vangala ra umana bul tutana ma ra umana bul vavina. ");
INSERT INTO ksd_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Selak i ga laun a utul a vinun na kilala, ma i ga vangala Eber; ");
INSERT INTO ksd_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ma ba i ga tar vangala Eber, Selak i ga laun a ivat na mar ma a utul a kilala mulai, ma i ga vangala ra umana bul tutana ma ra umana bul vavina. ");
INSERT INTO ksd_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ma Eber i ga laun a utul a vinun ma a ivat na kilala, ma i ga vangala Peleg; ");
INSERT INTO ksd_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ma ba i ga tar vangala Peleg, Eber i ga laun a ivat na mar ma a utul a vinun na kilala mulai, ma i ga vangala ra umana bul tutana ma ra umana bul vavina. ");
INSERT INTO ksd_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ma Peleg i ga laun a utul a vinun na kilala, ma i ga vangala Reu; ");
INSERT INTO ksd_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ma ba i ga tar vangala Reu, Peleg i ga laun a ura mar ma lavuvat na kilala mulai, ma i ga vangala ra umana bul tutana ma ra umana bul vavina. ");
INSERT INTO ksd_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ma Reu i ga laun a utul a vinun ma a ura kilala, ma i ga vangala Serug; ");
INSERT INTO ksd_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ma ba i ga tar vangala Serug, Reu i ga laun a ura mar ma lavurua na kilala mulai, ma i ga vangala ra umana bul tutana ma ra umana bul vavina. ");
INSERT INTO ksd_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ma Serug i ga laun a utul a vinun na kilala, ma i ga vangala Nakor; ");
INSERT INTO ksd_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ma ba i ga tar vangala Nakor, Serug i ga laun a ura mar na kilala mulai, ma i ga vangala ra umana bul tutana ma ra umana bul vavina. ");
INSERT INTO ksd_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ma Nakor i ga laun a ura vinun ma lavuvat na kilala, ma i ga vangala Tera; ");
INSERT INTO ksd_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","ma ba i ga tar vangala Tera, Nakor i ga laun tika na mar ma lavuvat na kilala mulai, ma i ga vangala ra umana bul tutana ma ra umana bul vavina. ");
INSERT INTO ksd_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ma Tera i ga laun lavurua na vinun na kilala, ma i ga vangala Abaram, Nakor ma Karan. ");
INSERT INTO ksd_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Io, go ia ra varvai ure ra umana bul mur tai Tera. Tera i ga vangala Abaram, Nakor ma Karan; ma Karan i ga vangala Lot. ");
INSERT INTO ksd_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ma Karan i ga mat ta ra luaina mata i tamana Tera ta nam ra gunan di ga tar kava ie, aro Ur ta ra langun Kaldea. ");
INSERT INTO ksd_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ma Abaram ma Nakor dir ga taulai; ma ra iang i ra taulai kai Abaram ba Sarai; ma ra iang i ra taulai kai Nakor ba Milka, natu i Karan, a tama i dir Milka ma Iska. ");
INSERT INTO ksd_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ma Sarai i ga biu, pa ta natuna. ");
INSERT INTO ksd_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ma Tera diat ma natuna Abaram, ma tubuna Lot natu i Karan, ma Sarai bula, a nimuna, a taulai kai Abaram natuna, dia ga vana kan ra gunan Ur ta ra langun Kaldea, upi diat a vana ta ra gunan Kanaan; ma dia ga pot aro Karan, ma dia ga ki ie. ");
INSERT INTO ksd_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ma ra lavur bung kai Tera dia ga varogop ma a ura mar ma a ilima na kilala; ma Tera i ga mat aro Karan. ");
INSERT INTO ksd_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ma ra Luluai i ga biti tai Abaram: Una vana kan kaum gunan, ma balakane ra tara na niurum, ma kan ra kuba i tamam, ma una vana ta nam ra gunan ba ina vateten u boko tana; ");
INSERT INTO ksd_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","ma ina pait vaarike ra ngala na tarai tam; ma ina vadoane u, ma ina vangala pa ra iangim; ma una varvadoan. ");
INSERT INTO ksd_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ma ina tata vadoane diat dia vadoane u, ma ina tata vakakaina nina ba na tata vakakaina u; ma ra lavur vuna tarai ta ra rakarakan a gunagunan diat a ti doan boko tam. ");
INSERT INTO ksd_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Io, Abaram i ga vana da ra Luluai i ga ve; ma dir ga varagur ma Lot; ma Abaram i ga lavurua na vinun ma a ilima na kilala, ba i ga vana irop ta ra gunan Karan. ");
INSERT INTO ksd_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ma Abaram i ga agur pa Sarai kana taulai, ma Lot natu i turana, ma ra tabarikik dia ga vung ia, ma kadia tarai par, nina dia ga ki pire diat aro Karan; ma dia ga vana upi ra gunan Kanaan; ma dia ga pot aro ta ra gunan Kanaan. ");
INSERT INTO ksd_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ma Abaram i ga vana alalu tuk ta ra pakana gunan Sikem, ma tuk ta ra davai, a iangina a iban, aro More. Ma ta nam ra bung a tarai Kanaan dia ga ki ta nam ra gunan. ");
INSERT INTO ksd_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ma ra Luluai i ga tur kapet rikai pire Abaram ma i ga biti: Ina tul tar go ra gunan tai ra umana natum. Ma i ga pait tika na uguugu ba kai ra Luluai, nina i ga tur kapet rikai pirana. ");
INSERT INTO ksd_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ma i ga vana kariu uro iat ta ra lualuana, ta ra papar a taur maravai Betel, ma i ga vatur kana pal na mal dari, ba Betel i ga ki ta ra papar a taoai, ma Ai ta ra papar a taur. Ma i ga pait ra uguugu upi kai ra Luluai abara, ma i ga kail tadav ra iang i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ma Abaram i ga tut, ma i ga kakari vanavana upi ra gunan ta ra papar a taubar. ");
INSERT INTO ksd_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ma ra mulmulum i ga tup ra gunan; ma Abaram i ga vana ur ta ra gunan Aigipto, upi na ki boko tana, tago ra mulmulum i ga tup ra gunan. ");
INSERT INTO ksd_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ma ba i ga maravai vanavana upi na olo ta ra gunan Aigipto, i ga biti tai Sarai kana taulai, dari: Gire, iau nunure.ba u a metek na vavina; ");
INSERT INTO ksd_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ma ba ra umana te Aigipto diat a gire u, diat a biti bar, Go kana taulai; ma kan diat a ubu doko iau, ma u kaka, una laun uka. ");
INSERT INTO ksd_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","I boina ba una biti ba dor taina, upi ina ki boina tam ma upi ina laun ure u. ");
INSERT INTO ksd_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ma ba Abaram i ga pot aro Aigipto, a umana te Aigipto dia ga gire ra vavina, ba a potar na vavina tuna. ");
INSERT INTO ksd_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ma ba ra umana luluai kai Parao dia ga gire, dia ga pite pa ia pire Parao, ma dia ga agur pa ra vavina tar ta ra kuba i Parao. ");
INSERT INTO ksd_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ma Abaram i ga ki mamal ure, ma dia ga tabar ia ma ra umana sip, a umana bulumakau, a umana as a umana tomotoina, a umana tultul na tutana ma ra umana tultul na vavina, ma ra umana as a umana tana, ma ra umana kamel bula. ");
INSERT INTO ksd_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ma ra Luluai i ga vakadik Parao ma diat ta ra kubana ma ra lavur ngala na kinadik ure Sarai, ra taulai kai Abaram. ");
INSERT INTO ksd_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ma Parao i ga oro pa Abaram ma i ga biti tana: Ava go ra magit u tar pait ia piragu? Ta ra ava pa u ga ve iau ba go kaum taulai? ");
INSERT INTO ksd_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ta ra ava u ga biti ba taim? Damana amir ga taulai me; io, go kaum taulai, una agur pa ia, ma amur a vana. ");
INSERT INTO ksd_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ma Parao i ga tulue ra tarai ure, upi diat a vartulai me, diat ma kana taulai ma kana lavur tabarikik. ");
INSERT INTO ksd_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ma Abaram ma kana taulai dir ga irop kan ra gunan Aigipto, ma dir ga vana urama Kanaan ta ra langun na taubar, ma i ga kap kana vurvur magit; dital ma Lot. ");
INSERT INTO ksd_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ma Abaram i ga manga uviana ma ra vavaguai, a silva ma ra goled. ");
INSERT INTO ksd_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ma kana lavur vinavana i ga tur pa ia aro ra langun na taubar, ma i tuk tar ta ra gunan Betel, nam ra pakana gunan kana pal na mal i ga tur tavuna tana, livuan ta ra ura gunan Betel ma Ai, ");
INSERT INTO ksd_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ta ra pakana gunan kai ra uguugu, nina i ga pait vatavuna; ma ta nam ra gunan Abaram i ga kail tadav ra iang i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ma Lot, nina dir ga varagur ma Abaram, kana bula ra lavur sip, ma ra bulumakau, ma ra umana pal na mal. ");
INSERT INTO ksd_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ma pa i ga tale ra gunan upi dir par dir ki rangup tana, tago kadir tabarikik i ga ngala, ma i ga dekdek upi dir a ki varurung. ");
INSERT INTO ksd_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ma ra umana tena balabalaure vavaguai kai Abaram ma ra umana tena balabalaure vavaguai kai Lot dia ga varvarngangar. Ma ra tarai Kanaan ma ra tarai Peres dia ga ki ta ra gunan ta nam ra kilala. ");
INSERT INTO ksd_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ma Abaram i ga biti tai Lot: Koko ra varngangar pire dor ma pire kador umana tena balabalaure vavaguai, tago dor tamana. ");
INSERT INTO ksd_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Pa i langalanga vang ra gunan parika ta ra luaina matam? Boina, dor a vana varbaiai. Ona u mainge ra papar a maira ina vana ta ra papar a lima tuna, ma ona u mainge ra papar a lima tuna, ina vana ta ra papar a maira. ");
INSERT INTO ksd_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ma Lot i ga idaidok, ma i ga gire ra gunan kikil ra Iordan, ma lua a umana tava tana ta ra lavur pakapakana, ta nam ra bung ba ra Luluai pa i ga kamare vue boko Sodom ma Gomora, ma i ga da ra uma kai ra Luluai, da ra gunan Aigipto, ma i tuk tar uro Soar. ");
INSERT INTO ksd_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Io, Lot i ga pilak pa ra gunan kikil ra Iordan upi kana; ma Lot i ga vana ta ra papar a taur; ma dir ga vana varbaiai. ");
INSERT INTO ksd_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ma Abaram i ga ki ta ra gunan Kanaan, ma Lot i ga ki ta ra lavur pia na pal ta ra gunan i tamataman, ma i ga kari kana pal na mal vanavana tuk ta ra gunan Sodom. ");
INSERT INTO ksd_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ma ra tarai Sodom dia ga manga kaina, ma dia ga pait ra varpiam tuna tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ma ra Luluai i ga biti tai Abaram, ba dir ga vana varbaiai ma Lot, dari: Una idaidok go, ta go ra gunan u tur tana, ma una gigira upi ra matana labur, ma ra matana taubar, ma ra matana taur, ma ra matana taoai; ");
INSERT INTO ksd_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","tago go ra gunagunan parika ba u gire ina tul tar ia tam ma ta ra lavur bul mur tam upi kavavat vatikai. ");
INSERT INTO ksd_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ma ina vapeal ra umana bul mur tam, upi diat a varogop ma ra tobon ta ra rakarakan a gunagunan; ma ona tikai na luk puput pa ra tobon ta ra rakarakan a gunagunan, na luk puput pa bula ra lavur bul mur tam. ");
INSERT INTO ksd_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Una tut, ma una valivute ra gunagunan par, ra lolovinana ma ra tababana tana, tago ina tabar u me. ");
INSERT INTO ksd_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ma Abaram i ga kari pa kana pal na mal, ma i ga vana, ma i ga ki ta ra makur a iban kai Mamre, maravai Kebron, ma i ga pait tika na uguugu kai ra Luluai abara. ");
INSERT INTO ksd_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ma ta nam ra kilala ba Amrapel i ga king aro Sinar, ma Ariok i ga king aro Elasar, ma Kedorlaomer i ga king aro Elam, ma Tidal a king kai ra Goim, ");
INSERT INTO ksd_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","dia ga varubu ma Bera a king aro Sodom, ma Birsa a king aro Gomora, ma Sinab a king aro Adma, ma Semeber a king aro Seboim, ma ra king aro Bela, nina di vatang ia bula ba Soar. ");
INSERT INTO ksd_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Go diat par dia ga tur rangup ta ra male, a iangina Sidim, nina ba gori a Ta Mat i tur tana. ");
INSERT INTO ksd_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","A vinun ma a ivu kilala dia ga torom tai Kedorlaomer, ma ta ra vavinununa ma a utul dia ga tut ma ra vinarubu na varpiam. ");
INSERT INTO ksd_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ma ra vavinun ma a ivat na kilala Kedorlaomer ma ra lavur king dia ga talaina me dia ga pot, ma dia ga ubu ra tarai Repaim aro Astarot-Kanaim, ma ra tarai Susi aro Am, ma ra tarai Em aro Kiriataim, a gunan i tamataman, ");
INSERT INTO ksd_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ma ra tarai Kori ta kadia gunan, a lualuana Seir, ma i ga tuk tar uro El-Paran, maravai ra pupui. ");
INSERT INTO ksd_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ma dia ga lilikun, ma dia ga tadav En-Mispat, di vatang ia bula ba Kades, ma dia ga ubu ra gunagunan par kai ra tarai Amalek ma Amor, nina dia ga ki aro Kaseson-Tamar. ");
INSERT INTO ksd_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ma ra king Sodom, ma ra king Gomora, ma ra king Adma, ma ra king Seboim, ma ra king Bela, di vatang ia bula ba Soar, dia ga vana rikai, ma dia ga vaninara upi diat a varubu ma diat ta ra male Sidim; ");
INSERT INTO ksd_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","upi diat a varubu ma Kedorlaomer a king Elam, ma Tidal a king kai ra Goim, ma Amrapel a king Sinar, ma Ariok a king Elasar, a ivat na king ure a ilima. ");
INSERT INTO ksd_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Io, mangoro na tung ta ra male Sidim, ma tika na mangana bulit i ga tur ta diat; ma ra king Sodom dir ma ra king Gomora dir ga takap, ma dir ga bura tana, ma diat dia ga bura valili dia ga vilau upi ra luana. ");
INSERT INTO ksd_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ma dia ga ra pa ra tabarikik aro Sodom ma Gomora, ma ra adia magit na nian, ma dia ga vana ka. ");
INSERT INTO ksd_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ma dia ga kinim Lot bula, dir tamana ma Abaram, nina i ga ki Sodom, ma kana tabarikik, ma dia ga vana. ");
INSERT INTO ksd_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ma tikai ta diat dia ga takap, i ga vana ma i ga ve Abaram ra te Ebraio, nina i ga ki ta ra makur a iban kai Mamre, ra te Amor, tura i dir Eskol ma Aner; ma go diat dia ga tur na bartalaina ma Abaram ta ra vinarubu. ");
INSERT INTO ksd_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ma ba Abaram i ga valongore ba di ga tar kinim pa natu i turana, i ga agure kana dovot na tarai, nina di ga kava diat ta kana gunan, a utul a mar ma a vinun ma a lavutul diat, ma i ga korot mur diat tuk tar aro Dan. ");
INSERT INTO ksd_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ma i ga tibe varbaiane kana tarai ure diat ta ra marum, ma i ga ubu diat, ma i ga korot mur diat tuk tar aro Koba, nina i maravai Damasko, ta ra papar a maira. ");
INSERT INTO ksd_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ma i ga kap valilikun ra tabarikik par, ma i ga agure valilikun Lot bula, natu i turana, ma kana tabarikik, ma ra vaden bula ma ra tarai. ");
INSERT INTO ksd_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ma ra king Sodom i ga totongo upi ia, ba i ga lilikun ta ra vinarubu ma Kedorlaomer ma ra umana king dia ga varagur me, ta ra male Save, di vatang ia bula ba a Male kai ra King. ");
INSERT INTO ksd_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ma Melkisedek, a king Salem, i ga kap vaarike ra gem ma ra vain; ma ia ra tena tinabar kai God, a Ngala Kakit. ");
INSERT INTO ksd_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ma i ga tata vadoane ma i ga biti: Abaram na ti doan tai God, a Ngala Kakit, nina ba kana ra bala na bakut ma ra rakarakan a gunagunan. ");
INSERT INTO ksd_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","A pite varpa tadav God, a Ngala Kakit, nina i ga ongo tar kaum umana ebar ta ra limam. Ma i tul tar ia ra vavinununa ta ra lavur magit. ");
INSERT INTO ksd_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ma ra king Sodom i ga biti tai Abaram: Una tul tar ra tarai ka tagu, ma una vatur vake ra tabarikik. ");
INSERT INTO ksd_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ma Abaram i ga biti tai ra king Sodom: Iau tar vatur ra limagu urama tadav ra Luluai God, a Ngala Kakit, kana ra bala na bakut ma ra rakarakan a gunagunan, ");
INSERT INTO ksd_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ba koko ina vatur vake ta vup na kuara, ba ta vivi ik ure ta pal a kau, ba ta enana magit ta kaum tabarikik; kan una biti: Iau ga vauviana Abaram; ");
INSERT INTO ksd_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","ia kaka nam ra magit ra umana barmana dia ga en ia, ma ra tiniba kai ra tarai ave varagur, Aner, Eskol ma Mamre, boina ba dital a vatur vake kadital tiniba. ");
INSERT INTO ksd_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ma i par go ra lavur magit, ma namur a tinata kai God i ga tadav Abaram ta ra ninana, ma i ga biti dari: Abaram, koko una burut; iau kaum bakbakit, ma kaum vapuak na ngala tuna. ");
INSERT INTO ksd_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ma Abaram i ga biti: Luluai God, ava una tar ia tagu? Tago ina mat boko, ma pa ta natugu; ma go Elieser maro Damasko na tur kia iau ta ra kubagu. ");
INSERT INTO ksd_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ma Abaram i ga biti: Gire, pa u ga tul tar ta bul tagu, ma gire, tikai ba di tar kava ta ra kubagu na tur kia iau. ");
INSERT INTO ksd_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ma ra tinata kai ra Luluai i ga tadav ia dari: Go ra tutana pa na tur kia u, pata; ma ga nina ba na vana rikai tam na tur kia u, ");
INSERT INTO ksd_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ma i ga agure vairop ia, ma i ga biti tana: Una tadarake ra bakut, ma una luk guve ra lavur tagul, ona i tale u upi una luk guve diat; ma i ga biti tana: Damana boko ra lavur bul mur tam. ");
INSERT INTO ksd_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ma Abaram i ga kapupi ra Luluai, ma ra Luluai i ga luk tar ia tana da ra mangamangana takodo. ");
INSERT INTO ksd_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ma i ga biti tana: Iau ra Luluai, iau ga agure vairop u aro Ur, ta ra gunan Kaldea, ma ina tabar u ma go ra gunan upi una kale. ");
INSERT INTO ksd_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ma i ga biti: Luluai God, ava ra vakilang ba ina nunure tana, ba ina kale pa ia boko. ");
INSERT INTO ksd_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ma i ga biti tana: Una pilak pa tika na nat na bulumakau ba i utul kana kilala, ma tika na me, a tana ba i utul kana kilala, ma tika na sip, a tomotoina ba i utul kana kilala, ma tika na uka, ma tika na nat na balu, upi kaugu. ");
INSERT INTO ksd_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ma i ga kap go diat par, ma i ga poko kutu diat livuan, ma i ga vung ra umana papar vartalai; ia kaka ra ura beo pa i ga kutu varbaiane dir. ");
INSERT INTO ksd_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ma ra umana beo, a umana lup virua, dia ga pukai ki ta ra virua i diat; ma Abaram i ga korot vue diat. ");
INSERT INTO ksd_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ma ba i ga kuba ra keake, Abaram i ga manga tarurungai, ma a ngala na bunurut ma ra ngala na bobotoi dir ga tadav ia. ");
INSERT INTO ksd_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ma ra Luluai i ga biti tai Abaram dari: Una nunure ba a dovotina, ra umana bul mur tam diat a ki na vaira tai ta tika na gunan ba vakir kadiat, ma diat a ki na vilavilau tana, ma na tup diat a ivat na mar na kilakilala. ");
INSERT INTO ksd_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ma nam ra tarai, ba diat a torom ta diat, ina kure bula, ma namur diat a irop tana ma ra ngala na tabarikik. ");
INSERT INTO ksd_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ma u, una vana pire ra umana tamam ma ra malmal, ma ba i do kaum lavur kilala, diat a punang u. ");
INSERT INTO ksd_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ma ta ra vaivat na taun tarai diat a lilikun uti mulai, tago ra valavalar i ra varpiam kai ra tarai Amor pa i ot boko. ");
INSERT INTO ksd_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ma ba ra keake i ga tar vana ba ma i ga marum, gire, tika na ubu i mi, ma a biro na iap i ga bolabolo livuan ta ra lavur pakapakana virua. ");
INSERT INTO ksd_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ta nam ra bung ra Luluai i ga pait ra kunubu ma Abaram, ma i ga biti: Iau tul tar go ra gunan ta ra lavur bul mur tam; na tur pa ia aro ta ra Tava Alir Aigipto ma na tuk tar ta ra ngala na tava alir Oiparat: ");
INSERT INTO ksd_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","diat ra tarai Ken, ma ra tarai Kenis, ma ra tarai Kadmon, ");
INSERT INTO ksd_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ma ra tarai Ket, ma ra tarai Peres, ma ra tarai Repaim, ");
INSERT INTO ksd_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ma ra tarai Amor, ma ra tarai Kanaan, ma ra tarai Girgas, ma ra tarai Iebus. ");
INSERT INTO ksd_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ma Sarai, a taulai kai Abaram, pa i ga kava tar ta natuna; ma kana tika na tultul a vavina, a te Aigipto, ma ra iangina ba Agar. ");
INSERT INTO ksd_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ma Sarai i ga biti tai Abaram: Ea, ra Luluai i tar kure bat iau, upi koko ina kavava; i boina ba una vana pire kaugu tultul na vavina, kan ina vatur vake ta umana bul tana. Ma Abaram i ga torom ta ra tinata kai Sarai. ");
INSERT INTO ksd_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ma Sarai, a taulai kai Abaram, i ga tul tar Agar a te Aigipto tai Abaram kana tutana, upi dir a taulai me; ma Abaram i ga tar ki a vinun na kilala ta ra gunan Kanaan. ");
INSERT INTO ksd_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ma i ga ruk tadav Agar, ma Agar i ga lalau pa ra bul; ma ba i ga nunure ba i kap bala, i ga pidimuane kana tadar vavina. ");
INSERT INTO ksd_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ma Sarai i ga biti tai Abaram: Boina ba nam ra mangamangana di vakaina iau me, na ki tam; iau ga tul tar kaugu tultul na vavina tam, pi na va piram, ma ba i kap bala, i pidimuane iau. A Luluai na pait ra varkurai ta dor. ");
INSERT INTO ksd_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ma Abaram i ga biti tai Sarai: Gire, u iat una kure kaum tultul, una pait nam ra magit tana ba u mainge. Ma ba Sarai i ga kure vadekdek ia, i ga lop uka kan ia. ");
INSERT INTO ksd_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ma ra angelo kai ra Luluai i ga gire tadav ia pire ra kivu na tava ra papar a nga, nina ba uro Sur. ");
INSERT INTO ksd_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ma i ga biti: Agar a tultul kai Sarai, u mamave ma una vana uve? Ma i ga biti: Iau tar lop balakane kaugu tadar vavina Sarai. ");
INSERT INTO ksd_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ma ra angelo kai ra Luluai i ga biti tana: Una lilikun mulai tadav ia, ma una vamolo tar u ta ra vavai na limana. ");
INSERT INTO ksd_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ma ra angelo kai ra Luluai i ga biti tana: Gire, ina manga vapeal ra umana bul mur tam, ma na dekdek upi da luk guve valar pa diat, tago a ngala na kor. ");
INSERT INTO ksd_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ma ra angelo i ga biti bula tana: Gire, u tar kap bala, ma una kava boko ta bul tutana, una vaiang tar ra iangina ba Ismael, tago ra Luluai i tar valongore kaum tinangi. ");
INSERT INTO ksd_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ma na varogop ma ra kuabar na as livuan ta ra tarai ma i tut na vinarubu ure ra tarai par, ma ra tarai diat a varubu me. Ma na ki ta ra luaina mata i ra lavur turana par. ");
INSERT INTO ksd_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ma i ga vatang ra iang i ra Luluai, nina dir tata me ba: U a God na ginigira. Tago i ga biti: Dave iau laun boko, ma a dovotina iau tar gire? ");
INSERT INTO ksd_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Kari di vatang nam ra kivu ba a kivu na nilaun ta ra ginigira; ea, i tur livuan ta ra ura gunan Kades ma Bared. ");
INSERT INTO ksd_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ma Agar i ga kava tar ra bul tutana tai Abaram; ma Abaram i ga vaiang tar ra iang i nam natuna Agar i ga kava ba Ismael. ");
INSERT INTO ksd_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ma Abaram i ga tar laun pa lavutul na vinun ma laptikai na kilala ba Agar i ga kava tar Ismael tai Abaram. ");
INSERT INTO ksd_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ma ba Abaram i ga laun pa lavuvat na vinun ma lavuvat na kilala, a Luluai i ga tur kapet pa pirana ma i ga biti tana: Iau God Dekdek Muka; una vanavana ta ra luaina matagu, ma una ko kakit. ");
INSERT INTO ksd_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ma ina vatur kaugu kunubu pire dor, ma ina vapeal na kaia ra umana natum. ");
INSERT INTO ksd_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ma Abaram i ga bura timtibum, ma God dir pirpir me, ma i ga biti: ");
INSERT INTO ksd_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Ma iau, gire, kaugu kunubu i tur pire dor, ma una vangala boko mangoro na vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ma pa da vatang mule ra iangim ba Abaram, da vatang ra iangim boko Abaraam, tago iau tar vakai u pi una painavuna boko ure ra mangoro na vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ma ina tul tar ia tam upi una vangala mangoro na natum, ma ina vaki ra umana ngala na vuna tarai tam, ma ra umana king bula diat a vana rikai tam. ");
INSERT INTO ksd_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ma ina vatur kaugu kunubu pire dor, ma pire ra umana bul mur tam, ma kadia lavur taun tarai, upi ra kunubu pa na mutu, dari: Ba iau kaum God ma kai ra lavur bul mur tam. ");
INSERT INTO ksd_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ma Ina tabar u, ma ra umana bul mur tam, ma ra gunan nina u ki na vaira tana, ra gunan Kanaan par, upi kavavat vatikai, ma iau kadia God. ");
INSERT INTO ksd_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ma God i ga biti tai Abaraam dari: Ma u, una torom ta kaugu kunubu, u ma ra umana bul mur tam ta kadia lavur taun tarai. ");
INSERT INTO ksd_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ma go kaugu kunubu, nina ba avat a toratorom tana, pire dor ma u, dat ma ra umana bul mur tam: diat par kavava umana tutana avat a poko kikil diat. ");
INSERT INTO ksd_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Avat a poko kikil ra pal i ra paka i ra tutana. la ra vakilang i ra kunubu pire dat. ");
INSERT INTO ksd_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ba tikai i lavutul kana bung pire vavat, avat a poko kikil ia, a lavur tutana ta kavava lavur taun tarai, nina di ga kava diat ta ra kuba i vavat, ma nina di ga kul pa ia tai ra vaira, ba pa i vana rikai ta ra umana bul mur tam. ");
INSERT INTO ksd_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Nina di ga kava ta ra kubam, ma nina di ga kul pa ia ma kaum mani, avat a poko kikil diat; ma kaugu kunubu na tur ta ra pal i ra paka i vavat ma na tur vatikai. ");
INSERT INTO ksd_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ma ona pa di poko kikil tika na bul tutana ta ra pal i ra pakana, da okole vue nam kan ra taraina, tago i tar piam vue kaugu kunubu. ");
INSERT INTO ksd_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ma God i ga biti tai Abaraam: Ma Sarai, kaum taulai, koko una vatang ra iangina ba Sarai; da vatang ia ba Sara. ");
INSERT INTO ksd_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ma ina vadoane boko, ma ina tabar u ma tika na bul tutana tana. Ina vadoane, ma na vakubur mangoro na vuna tarai; a umana king kai ta umana vuna gunan diat a vana rikai tana. ");
INSERT INTO ksd_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ma Abaraam i ga bura timtibum ta ra matana, ma i ga nonganongon ta ra balana ma i ga biti: Dave, ina vangala ta bul mulai ba iau a mar na kilala, ma Sara na kakava bar ba i lavuvat na vinum na kilala? ");
INSERT INTO ksd_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ma Abaraam i ga biti tai God: Boina ba Ismael na laun ta ra luaina matam! ");
INSERT INTO ksd_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ma God ga biti dari: Pata, Sara ka, kaum taulai, na kava tar ia tam tika na bul tutana, ma una vaiang tar ra iangina ba Isak. Ma ina vatur kaugu kunubu pire mimir, a kunubu ba na tur pa na mutu ure ra umana bul mur tana. ");
INSERT INTO ksd_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ma ure Ismael, iau tar valongore u ure nam bula. Gire, iau tar vadoane, ma ina maravut ia upi na vangala mangoro na natuna, ma diat a peal na kaia; na vangala a vinun ma a urua na luluai, ma ina vaki ia upi ra ngala na vuna gunan. ");
INSERT INTO ksd_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ma ga kaugu kunubu ina vatur ia pire mimir ma Isak, nina ba Sara na kava tar ia tam ta ra e iau ga kure, ta ra kilala namur. ");
INSERT INTO ksd_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ma God i ga ngo ma ra tinata pire Abaraam ma i ga tutua kan ia. ");
INSERT INTO ksd_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ma Abaraam i ga poko kikil ra pal i ra paka i Ismael natuna, ma ra pal i ra paka i diat par di ga kava diat ta kana gunan, ma diat dia ga kul pa diat ma kana mani, a lavur tutana par ta ra tarai ta ra. kuba i Abaraam, ta nam ra bung iat God i ga ve tar ia. ");
INSERT INTO ksd_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ma Abaraam i ga laun vue lavuvat na vinun ma lavuvat na kilala ba di ga poko kikil ra pal i ra pakana. ");
INSERT INTO ksd_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ma Ismael natuna i ga vinun ma a utul kana kilala ba di ga poko kikil ia ta ra.pal i ra pakana. ");
INSERT INTO ksd_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ta ra kopono bung di.ga poko kikil Abaraam ma Ismael natuna. ");
INSERT INTO ksd_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ma ra tarai par ta kana gunan, diat di ga kava diat i tana, ma diat di ga kul pa diat ma ra mani tai ra umana vaira, di ga poko kikil diat varurung ma Abaraam. ");
INSERT INTO ksd_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ma God i ga tur kapet pa pirana ta ra makur a iban kai Mamre, ba i ga ki ta ra mataniolo kai ra pal na mal; ma i ga tup ia ra lapap i ra keake. ");
INSERT INTO ksd_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ma i ga idok, ma i ga gigira; ma ea, a utul a tutana dital ga tur abara ta ra luaina matana; ma ba i ga gire dital, i ga tut kan ra mataniolo kai ra pal na mal, ma i ga vutvut barat dital, ma i ga va timtibum ra pia, ma i ga biti: ");
INSERT INTO ksd_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Luluai, ona u tar mari iau, koko una vana pakit kaum tultul. ");
INSERT INTO ksd_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ina vartuluai upi ta ik a tava, upi amutal a puk ra kau i mumutal, ma amutal a ngo papa boko ta ra malur na davai. ");
INSERT INTO ksd_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ma ina vila pa ta ik a pakana gem, ma amutal a lagar tana; namur amutal a vana mulai, tago kari go amutal tar tadav kamumutal tultul. Ma dital ga biti tana: Una pait nam u tar vatang ia. ");
INSERT INTO ksd_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ma Abaraam i ga pampam ta ra pal na mal pire Sara, ma i ga biti tana: Una vaninare lulut a utul a valavalar na bo na plaua, una bing ia ma una pait gem. ");
INSERT INTO ksd_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ma Abaraam i ga kavie ra vinavana tadav ra kikil na vavaguai, ma i ga vila pa tika na nat na bulumakau, i ga guma ma i ga boina ra viono, ma i ga tul tar ia tai ra tultul, ma ra tultul i ga vaninare lulut. ");
INSERT INTO ksd_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ma i ga kap ra bira na polo na u, ma ra polo na u i mek, ma ra nat na bulumakau, nina i ga vaninare, ma i ga vung ia pire dital; ma i ga tur pire dital ta ra vavai na davai, ma dital ga ian. ");
INSERT INTO ksd_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ma dital ga tir ia: Akave Sara, kaum taulai? Ma i ga biti: Akamana ta ra pal na mal. ");
INSERT INTO ksd_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ma i ga biti: A dovotina, ta ra e damana ta ra kilala namur ina lilikun mulai, ma Sara, kaum taulai, na kava ra bul tutana. Ma Sara i ga tur ta ra matakilalat na pal na mal ta ra tamuruna, ma i ga valongore. ");
INSERT INTO ksd_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ma Abaraam ma Sara dir ga patuana, ma i ga peal kadir kilala; ma ra mangamangana kai ra vaden i ga ngo pire Sara. ");
INSERT INTO ksd_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ma Sara i ga nongon ta ra balana, ma i ga biti: Dave go iau a tubuan, ma ina gugu mulai vang? Ma kaugu luluai bula i tar manga patuana. ");
INSERT INTO ksd_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ma ra Luluai i ga biti tai Abaraam: Ta ra ava Sara i nonganongon tana, ma ta ra ava i biti, Ina kava mule ta bul dave, tago iau a tubuan na vavina? ");
INSERT INTO ksd_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ava ra magit na dekdek bar pire ra Luluai? Ina lilikun mulai ta ra kilala namur, ta ra e di ga tibe, ma Sara na vatur vake natuna, a bul tutana. ");
INSERT INTO ksd_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ma Sara i ga varpuai, i ga biti: Pa iau nongon; tago i ga burut. Ma i ga biti: A dovotina u tar nongon. ");
INSERT INTO ksd_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ma ra utul a tutana dital ga tut, ma dital ga vana upi Sodom; ma Abaraam i ga varagur ma dital upi na tule dital. ");
INSERT INTO ksd_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ma ra Luluai i ga biti: Ina ive davatane kan Abaraam a magit ba ina pait ia boko, ");
INSERT INTO ksd_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","tago Abaraam, na varogop boko ma ra ngala na vuna gunan tuna ma a dekdek bula, ma a lavur vuna tarai ta ra rakarakan a gunagunan diat a ti doan tana. ");
INSERT INTO ksd_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Tago iau tar pilak pa ia, upi na tul tar ia tai ra umana natuna ma ra kubana namur tana, ba diat a mur ra nga i ra Luluai, upi diat a pait ra magit i takodo ma i dovot, upi a Luluai na tul tar nam ra magit tai Abaraam, nina i ga vatading ia me. ");
INSERT INTO ksd_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ma ra Luluai i ga biti: A lavur varvai na vartakun ure Sodom ma Gomora i kaina tuna, ma kadia varpiam i mamat i tuna. ");
INSERT INTO ksd_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Kari ina vana ur go, ma ina gire ba i dovot di tar pait ot pa nam ra lavur magit varogop ma ra varvai, nina i vana rikai piragu, ba pata; ma ona pata, ina nunure ke. ");
INSERT INTO ksd_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ma a ura tutana dir ga, tur tapuku ma dir ga vana uro Sodom; ma Abaraam i ga tur boko ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ma Abaraam i ga kakari pirana, ma i ga biti: Dave, una vapanie varurungane vue dir par ra tena takodo ma ra tena varpiam? ");
INSERT INTO ksd_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kan a ilima na vinun na tena takodo dia ki ta ra pia na pal; una kamare vue bar ra pia na pal, ma pa una mari ia ure ra ilima na vinun na tena takodo dia ki tana? ");
INSERT INTO ksd_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Koko muka una ubu ra tena takodo varurung ma ra tena varpiam, upi damana ra tena takodo na vardada ka ma ra tena varpiam. Koko muka. Dave, ra tena varkurai kai ra rakarakan a gunagunan pa na varkurai bar ma ra mangamangana takodo? ");
INSERT INTO ksd_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ma ra Luluai i ga biti: Ona ina gire a ilima na vinun na tena takodo aro Sodom, ina mari ra gunan parika ure diat. ");
INSERT INTO ksd_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ma Abaraam i ga tata balbali, ma i ga biti: Gire, iau tar valar ia upi amir a tata ma ra Luluai, ma a dovot, iau a tobon ika ma iau da ra kabu ka. ");
INSERT INTO ksd_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Kan na iba ra ilima upi na ilima na vinun na tena takodo. Dave bar, una kamare vue ra pia na pal parika, tago i iba nam ra ilima? Ma i ga biti: Pata, pa ina kamare vue, ba ina gire tadav ra ivat na vinun ma a ilima. ");
INSERT INTO ksd_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ma i ga tata mulai, ma i biti: Kan una gire tadav a ivat na vinun uka. Ma i ga biti: Pa ina pait ia ure ra ivat na vinun tana. ");
INSERT INTO ksd_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ma i ga biti: Koko una kankan, Luluai, ba ina tata mulai. Kan una gire tadav ra utul a vinun uka tana. Ma i ga biti: Pa ina pait ia, ona iau gire tadav ra utul a vinun tana. ");
INSERT INTO ksd_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ma i ga biti: Gire, iau tar valar ia upi amir a tata ma ra Luluai. Kan una na tadav ra ura vinun uka tana. Ma i ga biti: Pa ina nila vue ure ra ura vinun. ");
INSERT INTO ksd_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ma i ga biti: Koko una kankan, Luluai, ma ina valar ta kopono tinata mulai: Kan una gire tadav tika na vinun uka tana. Ma i ga biti: Pa ina nila vue ure ra vinun. ");
INSERT INTO ksd_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ma ba i ga par kadir tinata ma Abaraam, a Luluai i ga vana; ma Abaraam i ga lilikun upi kana gunan. ");
INSERT INTO ksd_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ma ra ura angelo dir ga pot aro Sodom ta ra ravian. Ma Lot i ga ki ta ra mataniolo aro Sodom. Ma Lot i ga gire dir, ma i ga tut upi na barat dir; ma i ga tur ruru ma ra matana ra pia; ");
INSERT INTO ksd_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ma i ga biti: A ura luluai, boina amur a ruk ra kuba i kamumur tultul, amur a ki tana ra marum, ma da puk ra kau i mumur; ma ta ra kavunvun amur a tut mulai, ma amur a vana! Ma dir ga biti: Pata, amir a ki ke ta ra nga i ra pia na pal go ra marum par. ");
INSERT INTO ksd_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ma i ga manga vo pa dir, ma dir ga ruk ta ra kubana. Ma i ga lapir dir, ma i ga pait ra gem ba pa ta leven tana, ma dir ga ian. ");
INSERT INTO ksd_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ma ba pa dir ga va boko, a tarai na pia na pal, a tarai Sodom, dia ga tur kikil ra pal, a umana barmana ma ra umana patuana, a tarai kai ra pia na pal parika; ");
INSERT INTO ksd_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ma dia ga oro Lot ma dia ga biti tana: Akave ra ura tutana dir ruk piram go ra marum? Una agure vairop dir, upi avet a la ma dir. ");
INSERT INTO ksd_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ma Lot i ga.irop tadav diat, ma i ga banu bat ra matakilalat, ");
INSERT INTO ksd_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ma i ga biti: A umana turagu, koko avat a pait ra mangamangana kaina damana. ");
INSERT INTO ksd_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Gire, a ura natugu, a ura inip na vavina, go kari, ma pa dir ga la boko tai ta tutana; ina agure vairop dir, ma avat a pait nam ra magit ta dir ba ava mainge; ma ga koko avat a vakaina go ra ura tutana; tago dir tar ki bakit ta ra kubagu. ");
INSERT INTO ksd_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ma dia ga biti ke: Una tur ar. Ma dia ga biti: Go ra kopono tutana i tar pot, ma i ki na vaira ait, ma i mainge ba na tena varkurai. Go avet a manga vakaina u ma dir pata. Ma dia ga manga tutulan varara upi nam ra tutana Lot, ma dia.ga vana maravai upi diat a pamar ra banbanu. ");
INSERT INTO ksd_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ma ra ura tutana dir ga tulue ra lima i dir, ma dir ga al varuk Lot pire dir ta ra bala na pal, ma dir ga banu bat ia. ");
INSERT INTO ksd_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ma dir ga vapula bat ra tarai ta ra banbanu kai ra pal, ra umana ngala ma ra umana ikilik; damana dia ga vatalanguane mule diat ma ra tinikan upi ra banbanu. ");
INSERT INTO ksd_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ma ra ura tutana dir ga biti tai Lot: Dave ta umana niurum ati boko, ta nimum bar, ba ta umana bul tutana, ba ta umana bul vavina? Boina una agure vairop ra umana niurum par ta go ra pia na pal kan go ra gunan; ");
INSERT INTO ksd_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","tago amir a vakaina boko go ra gunan, tago a varvai na vartakun ure i tar mamat pire ra Luluai, ma ra Luluai i tulue amir upi amir a vakaina vue. ");
INSERT INTO ksd_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ma Lot i ga irop ma dia ga tata ma ra umana tutana, a umana nimuna, nina ba diat a taulai boko ma ra umana natuna, ma i ga biti: Avat a tut, avat a irop kan go ra gunan, tago a Luluai na kamare vue go ra pia na pal. Ma ra umana nimuna dia ga biti ba i varvaula ka. ");
INSERT INTO ksd_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ma ta ra kavunvun dir ga vargat Lot upi na pampam, dir ga biti: Una tut, una agure kaum taulai ma a ura natum, a ura vavina, dir bula; kan una virua ta ra balbali ure go ra pia na pal. ");
INSERT INTO ksd_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ma i ga vavuan ika; ma ra ura tutana dir ga vatur vake ra limana, ma ra lima i kana taulai, ma ra lima i ra ura bul vavina, tago a Luluai i ga mari ia, ma dir ga agure vairop ia ma dir ga nur vue abara. ");
INSERT INTO ksd_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ma ba dir ga tar agure vairop diat, i ga biti: Una lop upi una laun; koko una lingan namur tam; ma koko una tur pit ika ta go ra gunagunan parika. Una lop tar ta ra luana, kan una virua. ");
INSERT INTO ksd_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ma Lot i ga biti ta dir: Ea, Luluai, koko damana; ");
INSERT INTO ksd_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","gire, u ga mari kaum tultul ma u ga vangala kaum varmari pirana, nina u ga vaarike tagu, tago u tar valaun iau; ma i dekdek upi ina lop tar ta ra luana, kan ta kaina magit na tadav iau ma ina virua ka. ");
INSERT INTO ksd_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Gire, go ra pia na pal i maravai, upi ina lop tar tana; ma i ikilik ika; boina una tul tar iau upi ina lop tatar tana, tago a pede ik, ma a tulungeagu na laun: ");
INSERT INTO ksd_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ma i ga biti tana: Io, iau tar torom tam ta go ra magit bula, ma pa ina kamare vue nam ra pia na pal, nina u vatang ia. ");
INSERT INTO ksd_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Una kavie ra nilop ubara; tago i dekdek upi ina pait ta magit ona pa u olo boko tana. Kari di vatang nam ra pia na pal ba Soar. ");
INSERT INTO ksd_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ma ra keake i ga kuma rikai ba Lot i ga pot aro Soar. ");
INSERT INTO ksd_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ma ra Luluai i ga tulue ra bata i da ra pakar ma ra iap tai ra Luluai marama ra bakut, ");
INSERT INTO ksd_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ma i ga vue pukue vue nam ra ura pia na pal ma ra gunan kikil dir bula, ma ra tarai dia ga ki tana, ma ra lavur magit i ga tavua ta ra pia. ");
INSERT INTO ksd_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ma ra taulai kai Lot i ga lingan namur, ma i ga da ra vat na solt muka. ");
INSERT INTO ksd_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ma Abaraam i ga tut ra kavunvun, ma i ga vana ta nam ra gunan i ga tur ta ra luaina mata i ra Luluai tana. ");
INSERT INTO ksd_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ma i ga gire upi Sodom ma Gomora, ma upi ra gunan i tur kikil dir, ma i ga bobobe; ma gire, a mi i ga tubang rikai ta ra gunan, da ra mi ta ra ubu ta. ");
INSERT INTO ksd_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ma ba God i ga kamare vue ra umana pia na pal ta ra gunan i tamataman, God i ga nuk pa Abaraam, ma i ga tul vairop vue Lot, upi koko na virua ta nam ra bung ba i ga vue pukue vue ra umana pia na pal Lot i ga ki tana. ");
INSERT INTO ksd_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ma Lot i ga irop ta ra gunan Soar, ma i ga ki ta ra luana, dital ma ra ura natuna, a ura vavina, tago i ga burut ba na ki aro Soar; ma i ga ki tai tika na babang, dital ma ra ura natuna, a ura vavina. ");
INSERT INTO ksd_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ma ra luaina ta dir i ga biti ta ra vauruana: Tama i dor i patuana, ma pa ta tutana ta ra gunagunan, upi na ruk pire dor, varogop ma ra mangamangana kai ra tarai ta ra rakarakan a gunagunan par. ");
INSERT INTO ksd_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Una mai, dor a vamomo tama i dor ma ra vain, ma dor a va pirana, pi dor a vakubur ta tarai tai tama i dor. ");
INSERT INTO ksd_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ma dir ga vamomo tama i dir ma ra vain ta nam ra marum, ma ra luaina i ga ruk ma i ga va pire tamana; ma tamana iat pa i ga nunure ba i ga va ma ba i ga tut mulai. ");
INSERT INTO ksd_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ma ra malana i ga ve ra muruna dari: Gire, iau tar va pire tamagu ra marum; boina dor a vamoma bula go ra marum, upi una ruk ma una va pirana, pi dor a vakubur ta tarai tai tama i dor. ");
INSERT INTO ksd_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ma dir ga vamomo tama i dir ma ra vain nam ra marum bula, ma ra muruna i ga vana ma i ga va pirana; ma tamana iat pa i ga nunure ba i ga va ma ba i ga tut mulai. ");
INSERT INTO ksd_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Damana ra ura natu i Lot dir ga kap bala tai tama i dir. ");
INSERT INTO ksd_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ma ra luaina i ga kava ra bul tutana, ma i ga vaiang tar ra iangina ba Moab, tama i ra tarai Moab gori. ");
INSERT INTO ksd_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ma ra muruna i ga kava ta bul tutana bula, ma i ga vaiang tar ra iangina ba Ben-Ami; ma go a tama i ra tarai Amon gori. ");
INSERT INTO ksd_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ma Abaraam i ga vana papa kan nam ra gunan upi ra langun ta ra matana taubar, ma i ga ki livuan ta ra gunan Kades ma Sur; ma i ga ki na vaira aro Gerar. ");
INSERT INTO ksd_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ma Abaraam i ga biti ure Sara, kana taulai, ba: Amir taina. Ma Abimelek, a king Gerar, i ga vartuluai upi ia ma di ga agur pa Sara. ");
INSERT INTO ksd_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ma God i ga tadav Abimelek ta ra ririvon ra marum, ma i ga biti tana: U tar virua ure ra vavina u ga ben ia, tago dir tar taulai ma tika na tutana. ");
INSERT INTO ksd_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ma Abimelek pa i ga maravai boko pirana, ma i ga biti: Dave Luluai, una ubu vue bula ra takodo na tarai? ");
INSERT INTO ksd_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","la iat, pa i ga ve iau vang ba: Amir taina? Ma ra vavina iat bula i ga biti ba: Amir taina? Iau ga pait go ra magit ma ra dovot na balagu ma ra limagu i tuptup tana. ");
INSERT INTO ksd_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ma God i ga biti tana ta ra ririvon: Maia, iau nunure ba u ga pait go ma ra dovot na balam, ma iau ga tur bat i u, pi koko una pait ra kaina piragu; kari pa iau ga tul tar ia tam ba una bili ia. ");
INSERT INTO ksd_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Io, una vamule ra taulai kai nam ra tutana, tago ia ra propet, ma na araring ure u, ma una laun; ma ona, pa u vamule, una nunure ba una virua, avat ma kaum tarai par. ");
INSERT INTO ksd_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ma Abimelek i ga tut ta ra kavunvun, ma i ga oro pa kana lavur tultul par, ma i ga varvai ta go ra lavur magit ta ra talinga i diat, ma ra tarai dia ga manga burut. ");
INSERT INTO ksd_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ma Abimelek i ga oro pa Abaraam ma i ga biti tana: Ava ra magit go u tar pait ia ta vevet, ma ava vang ra kaina magit ba iau ga pait ia piram, tago u vuna ta ra ngala na mangamangana kaina piragu ma ta kaugu gunan? U ga pait ra mangamangana piragu, ba pa i topa ia upi da pait ia. ");
INSERT INTO ksd_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ma Abimelek i ga biti tai Abaraam dari: U ga pait go ra magit upi ra ava? ");
INSERT INTO ksd_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ma Abaraam i ga biti: Tago iau ga nuk ia dari: A dovotina, a bunurut ure God pa i ki ta go ra gunan; ma diat a ubu iau ure kaugu taulai. ");
INSERT INTO ksd_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ma tikai bula: A dovot, taigu, tago natu i tamagu, ma vakir natu i nagu; ma amir tar taulai. ");
INSERT INTO ksd_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ma ba God i ga tul vue iau kan ra kuba i tamagu, iau ga biti tana: Go ra varmari una pait ia tagu, ta ra lavur gunan ba dor a vana tana, una vatang iau ba taim. ");
INSERT INTO ksd_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ma Abimelek i ga vaninare ra sip ma ra bulumakau, ma ra umana tultul na tutana ma ra umana tultul na vavina, ma i ga tabar Abaraam me, ma i ga vamule Sara, kana taulai, tana. ");
INSERT INTO ksd_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ma Abimelek i ga biti: Gire go kaugu gunan ta ra luaina matam i langalanga, una ki ta nam ra pakana u mainge. ");
INSERT INTO ksd_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ma i ga biti: Gire, iau tar tabar taim ma ra arip na marmar na pakana silva; gire, i da ra mal. na tubatuba ta ra matam pire diat par ava varagur ma diat ure ra lavur magit i ga tadav u; ma go iau tar pait ra magit i takodo tana ta ra mata i diat par. ");
INSERT INTO ksd_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ma Abaraam i ga araring pire God, ma God i ga valagar Abimelek ma kana taulai ma kana umana tultul na vavina, ma dia kakava. ");
INSERT INTO ksd_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Tago a Luluai i ga kure vadekdek bat ra tatal na bul kai ra umana vavina ta ra kuba i Abimelek ure Sara, ra taulai kai Abaraam. ");
INSERT INTO ksd_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ma ra Luluai i ga tadav Sara da i ga tar biti, ma ra Luluai i ga pait ia tai Sara da i ga tar vatang ia. ");
INSERT INTO ksd_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ma Sara i ga lalau pa ra bul, ma i ga kava tar ra bul tutana tai Abaraam ba i ga patuana, ta nam ra pakana kilala God i ga tar vaarike tar ia tana. ");
INSERT INTO ksd_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ma Abaraam i ga vatang ra iang i natuna a tutana, nina Sara i ga kava tar ia, ba Isak. ");
INSERT INTO ksd_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ma Abaraam i ga poko kikil natuna Isak ba i ga lavutul kana bung, da God i ga tar vartuluai pirana. ");
INSERT INTO ksd_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ma Abaraam i ga laun vue tika na mar na kilala ba di ga kava tar Isak natuna. ");
INSERT INTO ksd_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ma Sara i ga biti: God i tar vaninare ra ninongon ure iau; diat par dia valongore diat a nongon maravut iau. ");
INSERT INTO ksd_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ma i ga biti: To ia na ve Abaraam ba Sara na vau ra umana bul? Tago iau tar kava tar natuna ta ra kilala i manga patuana tana. ");
INSERT INTO ksd_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ma ra bul i ga taiak ma i ga vung vue ra u; ma Abaraam i ga pait ra ngala na lukara ta nam ra bung Isak i ga vung vue ra u tana. ");
INSERT INTO ksd_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ma natu i Agar, ra vavina Aigipto, nina i ga kava tar ia tai Abaraam, i ga varvaula; ma Sara i ga gire. ");
INSERT INTO ksd_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Kari i ga biti tai Abaraam: Una okole vairop vue go ra vavina, a vilavilau, dir ma natuna; tago ra natu i go ra vilavilau pa na kakalai varurung ma natugu, varurung ma Isak. ");
INSERT INTO ksd_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ma go ia ra magit na tinabun tuna pire Abaraam ure natuna. ");
INSERT INTO ksd_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ma God i ga biti tai Abaraam: Koko na tabun ra balam ure ra barmana ma ure kaum vilavilau, a vavina. Una torom ta ra nilai Sara ta ra lavur magit i ve u tana; tago tai Isak iat a umana bul mur tam diat a vana rikai. ");
INSERT INTO ksd_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ma ina pait vaarike ra ngala na vuna tarai tai ra natu i ra vilavilau a vavina bula, tago ia ra bul mur tam. ");
INSERT INTO ksd_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ma Abaraam i ga tut ra kavunvun, ma i ga vaninare ra gem, ma ra paura na tava, ma i ga tul tar ia tai Agar, ma i ga vung ia ta ra ul a varana, ma i ga tul tar ra bul bula, ma i ga tul vue. Ma i ga vana, ma i ga tenten vurvurbit ta ra bil, a iangina Ber-Seba. ");
INSERT INTO ksd_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ma ra paura i ga mama, ma i ga nur vue ra bul ta ra vavai tika na davai ik. ");
INSERT INTO ksd_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ma i ga vana, ma i ga ki aro vailik a ik, i vardada ma ra vinavana na pu di pu me; tago i ga biti: Koko ina gire ra minat kai ra bul. Ma i ga ki abara ma i ga kukula ma i ga tangi. ");
INSERT INTO ksd_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ma God i ga valongore ra nilai ra bul, ma ra angelo kai God i ga oro pa Agar marama ra bala na bakut, ma i ga biti tana: U diva, Agar? Koko u burut, tago God i tar valongore ra nilai ra bul ta nam ra pakana i va tana. ");
INSERT INTO ksd_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Una tut, ma una vatut ra bul, ma una vatur vake ma ra limam, tago ina pait vaarike ra ngala na vuna tarai tana. ");
INSERT INTO ksd_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ma God i ga vanana pa ra kiau na matana, ma i ga gire tika na kivu na tava, ma i ga vana, ma i ga vabuka ra paura ma ra tava, ma i ga vamomo ra barmana. ");
INSERT INTO ksd_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ma God i ga maravut ra bul, ma i ga tavua, ma i ga ki ra bil, ma i ga tena pinanak. ");
INSERT INTO ksd_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ma i ga ki ta ra bil, a iangina Paran, ma nana i ga tul tar tika na vavina maro Aigipto pirana. ");
INSERT INTO ksd_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ma ta nam ra kilala Abimelek ma Pikol ra luluai i kana tarai na vinarubu dital ga tata ma Abaraam, ma dir ga biti dari tana: God i maravut u ta ra lavur magit u pait ia. ");
INSERT INTO ksd_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Io, koko una tuam vakaina iau ba ra umana natugu, ba ra umana bul mur tagu; una bali ke piragu nam ra varmari iau ga pait ia piram, ma una mari bula ra gunan u ga ki na vaira tana. Ma una pait ra vavalima ure tai God. ");
INSERT INTO ksd_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ma Abaraam i ga biti: Ina vavalima. ");
INSERT INTO ksd_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ma Abaraam i ga pit Abimelek ure ra kivu na tava, nina ba ra umana tultul kai Abimelek dia ga varane. ");
INSERT INTO ksd_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ma Abimelek i ga biti: Pa iau nunure go ra magit; to ia bar i ga pait ia? Ma pa u ga vaarike tagu, ma pa iau ga valongore ta tinata ure tuk tar ta ra bung gori. ");
INSERT INTO ksd_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ma Abaraam i ga vaninare ra sip ma ra bulumakau, ma i ga tabar Abimelek me, ma dir ga pait ra kunubu. ");
INSERT INTO ksd_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ma Abaraam i ga vaki vaire ra lavurua na sip, a umana tana. ");
INSERT INTO ksd_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ma Abimelek i ga biti tai Abaraam: Ava ra kukurai ra lavurua na sip, nina u vatur vaire diat? ");
INSERT INTO ksd_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ma i ga biti dari: Go ra lavurua na sip, a tana, una vatur diat ta ra limagu, upi ra vakilang tagu ba iau ga kal go ra kivu na tava. ");
INSERT INTO ksd_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ia ra vuna, tago di ga vatang nam ra pakana ba Ber-Seba, tago dir par dir ga vavalima tana. ");
INSERT INTO ksd_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Damana dir ga pait ra kunubu aro Ber-Seba; ma Abimelek i ga tut, dir ma Pikol ra luluai i kana tarai na vinarubu, ma dir ga lilikun ta ra gunan kai ra tarai Pilistia. ");
INSERT INTO ksd_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ma Abaraam i ga vaume tika na davai, a iangina Tamariska, aro Ber-Seba ma abara i ga kail tadav ra iang i ra Luluai God Tukum. ");
INSERT INTO ksd_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ma Abaraam i ga ki na vaira ta ra gunan kai ra tarai Pilistia mangoro na bung. ");
INSERT INTO ksd_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ma ba i ga par go ra lavur magit, God i ga valar Abaraam ma i ga biti tana: Abaraam! Ma i ga biti: Iau go kari. ");
INSERT INTO ksd_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ma i ga biti tana dari: Una agure natum, a tutana, kaum kavakake, nina u mari ia, Isak iat, ma una vana ta ra gunan Moria, ma una pait ra tinabar me, nina ba di tuntun tar ia, ta ra ul a luana ba ina vaarike boko tam. ");
INSERT INTO ksd_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ma Abaraam i ga tut ra kavunvun iat, ma i ga vaninare kana as, ma i ga agure a ura barmana ta kana tarai, ma Isak natuna; Ma i ga kita ra davai ure ra tinabar di tuntun tar ia, ma i ga tut papa, ma i ga vana ta nam ra gunan God i ga tar vateten tar ia. ");
INSERT INTO ksd_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ta ra vautuluna bung Abaraam i ga idok, ma i ga gire ra gunan aro vailik. ");
INSERT INTO ksd_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ma Abaraam i ga biti tai kana a ura barmana dari: Amur a ki ati ma ra as, ma amir ma ra bul, amir a vana uro, ma amir a lotu; ma namur amir a tadav mule amur. ");
INSERT INTO ksd_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ma Abaraam i ga takan pa ra davai ure ra tinabar di tuntun tar ia, ma i ga vung ia ta ra ul a vara i Isak ma ia iat i ga kap ra iap ma ra banam; ma dir par dir ga vana. ");
INSERT INTO ksd_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ma Isak i ga biti tai tamana Abaraam dari: Tamagu! Ma i ga biti: Iau go kari, natugu. Ma i ga biti mulai: Gire ra iap ma ra davai go kari, ma akave ra lam ure ra tinabar? ");
INSERT INTO ksd_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ma Abaraam i ga biti dari: God iat na tikan tadav ta lam ure ra tinabar, natugu. Ma dir par dir ga vana damana ka. ");
INSERT INTO ksd_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ma dir ga tadav nam ra pakana God i ga tar vatang tar ia; ma Abaraam i ga pait tika na uguugu ie; ma i ga vung mal ra davai tana, ma i ga vi Isak natuna, ma i ga vung ia ta ra uguugu, ta ra ul a davai. ");
INSERT INTO ksd_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ma Abaraam i ga tulue ra limana, ma i ga vatur ra banam upi na doko natuna. ");
INSERT INTO ksd_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ma ra angelo kai ra Luluai i ga ora marama ra bala na bakut, ma i ga biti dari: Abaraam, Abaraam! Ma i ga biti: Iau go kari. ");
INSERT INTO ksd_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ma i ga biti: Koko una bili ra barmana, ma koko una vakaina; tago go iau nunure ba u ru God, tago pa u muie vake natum, kaum kavakake, tagu. ");
INSERT INTO ksd_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ma Abaraam i ga idok, ma i ga gire ara namur tana tika na sip, a tomotoina, i vavakai ma ra ramuna ta ra lokor. Ma Abaraam i ga vana, ma i ga vila pa ra sip, a tomotoina, ma i ga pait ra tinabar di tuntun tar ia me, upi na kia vue natuna. ");
INSERT INTO ksd_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ma Abaraam i ga vatang ra iang i nam ra gunan ba: A Luluai-Ire; da di vatang ia boko gori: Ta ra luana kai ra Luluai da gire. ");
INSERT INTO ksd_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ma ra angelo kai ra Luluai i ga oro mule Abaraam marama ra bala na bakut, ma i ga biti: ");
INSERT INTO ksd_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Iau ga vavalima ta ra iangigu mulai, a Luluai i biti, tago u ga pait go ra magit, ma pa u ga muie vake natum, a kavakake: ");
INSERT INTO ksd_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ina manga vadoane u ma ra varvadoan, ma ina vapeal na kaia ra umana bul mur tam; diat a da ra umana tagul arama liu, ma diat a varogop ra veo ara ra valian, ma ra umana bul mur tam diat a kale ra mataniolo kai kadia lavur ebar. ");
INSERT INTO ksd_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ma ra lavur tarai par ta ra rakarakan a gunagunan diat a ti doan ta ra umana bul mur tam, tago u ga torom ta ra nilaigu. ");
INSERT INTO ksd_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Damana Abaraam i ga lilikun tadav kana a ura barmana; ma dia ga tut, ma dia ga varagur uro Ber-Seba. ");
INSERT INTO ksd_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ma ba i ga par go ra lavur magit, dia ga ve Abaraam dari: Ea, Milka i tar kava tar bula ra umana bul tai turam Nakor: ");
INSERT INTO ksd_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Us, ra luaina, ma Bus turana, ma Kemuel, ra tama i Aram; ");
INSERT INTO ksd_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ma Kesed, ma Kaso, ma Pildas, ma Iedlap, ma Betuel. ");
INSERT INTO ksd_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Ma Betuel i ga vangala Rebeka; go ra lavutul Milka i ga kava tar diat tai Nakor, tura i Abaraam. ");
INSERT INTO ksd_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ma kana tultul na vavina a iangina Reuma, i kakava bula, i kava go diat: Tebak, Gakam, Takas ma Maka. ");
INSERT INTO ksd_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Ma Sara i ga laun pa tika na mar a ura vinun ma lavurua na kilala; la go ra lavur kilala i ra nilaun kai Sara. ");
INSERT INTO ksd_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ma Sara i ga mat aro Kiriat-Arba, di vatang ia bula ba Kebron, ta ra gunan Kanaan. Ma Abaraam i ga vana upi na korkor ure Sara, ma upi na tangie. ");
INSERT INTO ksd_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ma namur Abaraam i ga tut kan ra minatina, ma dia ga tata ma ra umana natu i Ket, i ga biti dari: ");
INSERT INTO ksd_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Iau a enana, ma iau ki na vaira pire vavat; avat a tul tar tagu ta pakana pia na pupunang pire vavat, upi ina punang kaugu minat tana kan ra matagu. ");
INSERT INTO ksd_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ma ra umana natu i Ket dia ga bali Abaraam ma ra tinata dari: ");
INSERT INTO ksd_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Luluai, una valongore avet; u a ngala na luluai kai God pire vevet, una punang kaum minat ta nam ra babang na minat i boina kakit; pa ta na ta vevet na muie kana babang na minat, upi koko una punang kaum minat tana. ");
INSERT INTO ksd_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ma Abaraam i ga tut, ma i ga tur ruru ta ra luaina mata i ra tarai ta nam ra gunan, ra umana natu i Ket. ");
INSERT INTO ksd_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ma dia ga pirpir me, ma i ga biti: Ona ra nuknuk i vavat damana, pi ina punang kaugu minat kan ra matagu, i boina ba avat a valongore iau, ma avat a lul Epron, natu i Sokar, ure iau, ");
INSERT INTO ksd_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","upi na tul tar kana babang Makpela tagu, nina i maravai ta ra langun i kana uma; ina tul tar ra mataina par tana, ma na tul tar ia tagu livuan ta vavat, upi kaugu babang na pupunang. ");
INSERT INTO ksd_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ma Epron i ga ki livuan ta ra umana natu i Ket; ma Epron, a te Ket, i ga tata bali Abaraam ta ra luaina mata i ra umana natu i Ket, ma ta ra luaina mata i diat par dia olaolo ta ra mataniolo kai ra pia na pal, dari: ");
INSERT INTO ksd_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Pata, luluai, una valongore iau: Ina tul tar ra pia na uma tam ma ra babang tana, ina tabar u me; ta ra luaina mata i diat par kaugu tarai ina tabar u me; una punang kaum minat. ");
INSERT INTO ksd_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ma Abaraam i ga tur ruru ta ra luaina mata i ra tarai ta nam ra gunan. ");
INSERT INTO ksd_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ma i ga biti tai Epron ta ra luaina mata i ra tarai ta nam ra gunan dari: Io, ona u mainge, una valongore iau; ina tul tar ra matai ra gunan tam; una alube pa ia tagu; ma ina punang kaugu minat tana. ");
INSERT INTO ksd_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ma Epron i ga tata bali Abaraam dari: ");
INSERT INTO ksd_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Luluai, una valongore iau: A matai ra gunan i varogop ma ra ivat na mar na mamat na silva; ma i dave go ra magit pire dor? Una punang ke kaum minat tana. ");
INSERT INTO ksd_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ma Abaraam i ga torom tai Epron; ma i ga valar tar ra silva tai Epron, nina i ga vatang ia, ma ra tarai Ket dia ga valongore, a ivat na mar na mamat na silva, nina ba ra tena kunukul i kukul me. ");
INSERT INTO ksd_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Damana dia ga vadovot tar ra gunan kai Epron aro Makpela, maravai Mamre, tai Abaraam upi kana, ra gunan ma ra babang tana, ma ra davadavai par ta ra gunan ma ta kana langun par, ");
INSERT INTO ksd_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ta ra luaina mata i ra umana natu i Ket, ta ra luaina mata i diat par dia olaolo ta ra mataniolo ta nam ra pia na pal. ");
INSERT INTO ksd_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ma ba i ga par go, Abaraam i ga punang Sara, kana taulai, ta ra babang ta ra gunan Makpela maravai Mamre, Kebron nam, ta ra gunan Kanaan. ");
INSERT INTO ksd_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ma ra tarai Ket dia ga vadovot tar ra gunan ma ra babang tana tai Abaraam, upi kana pia na pupunang. ");
INSERT INTO ksd_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ma Abaraam i ga patuana, ma i ga laun vao, ma ra Luluai i ga maravut Abaraam ta ra lavur magit. ");
INSERT INTO ksd_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ma Abaraam i ga biti tai kana tultul, nina i lualua ta ra kubana ma i kure kana tabarikik par: Una vung ra limam ta ra kelakelegi na kaugu, ");
INSERT INTO ksd_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ma una vavalima tai ra Luluai, ra God kai ra bala na bakut ma ra God kai ra rakarakan a gunagunan, ba koko una vataule natugu ma ta vavina ta ra vaden Kanaan, nina iau ki livuan ta diat; ");
INSERT INTO ksd_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","una vana ta kaugu gunan iat, ma pire ra umana niurugu, ma una pilak pa ta vavina ure natugu Isak. ");
INSERT INTO ksd_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ma ra tultul i ga biti tana: Kan ra vavina na ole upi na mur iau ta go ra gunan; dave, ina tule mule natum ta nam ra gunan u ga irop tana? ");
INSERT INTO ksd_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ma Abaraam i ga biti tana: pata, koko una agure mule natugu uro. ");
INSERT INTO ksd_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","A Luluai God kai ra bala na bakut, nina i ga agure vairop iau kan ra kuba i tamagu, ma kan ra gunan di ga kava iau tana, nina i ga biti tagu ma ra vavalima: Ina tul tar go ra gunan ta ra umana bul mur tam, ia iat na tulue kana angelo na lua tam, ma una pilak pa ta vavina mabara ure natugu. ");
INSERT INTO ksd_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ma ona ra vavina pa na ga upi na mur u, u ti langalanga ta go kaum vavalima; ia kaka koko una agure mule natugu uro. ");
INSERT INTO ksd_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ma ra tultul i ga vung ra limana ta ra kelakelegi na kau i Abaraam, kana luluai, ma i ga vavalima tana. ");
INSERT INTO ksd_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ma ra tultul i ga pilak kapi ta vinun na kamel ta ra lavur kamel kai kana luluai, ma i ga vana papa; ma i ga kap ra lavur mangana tabarikik kai kana luluai ta ra limana, ma i ga tut, ma i ga vana uro Mesopotamia, ta ra pia na pal kai Nakor. ");
INSERT INTO ksd_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ma i ga kure ba koko ra umana kamel diat a olo ta ra pia na pal; ba diat a va ka maravai pire ra kivu na tava ta ra ravian, ta ra pakana bung ba ra vaden dia irairop tana, upi diat a kulup a tava. ");
INSERT INTO ksd_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ma i ga biti: U, Luluai God kai kaugu luluai Abaraam, iau lul u, ba una maravut iau go gori, ma una mari Abaraam, kaugu luluai. ");
INSERT INTO ksd_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Gire, iau tur pire ra kivu na tava; ma ra umana natu i ra tarai kai ra pia na pal, a umana vavina, diat a irairop, upi diat a kulup a tava; ");
INSERT INTO ksd_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","boina ba na dari: nina ra inip na vavina, ba ina biti tana, Una vung vatagogo kaum kulkulup, pi ina momo, ma na biti, Una momo, ma ina vamomo bula kaum kamel, boina ba ia nam iat ba u ga tibe tar ia tai kaum tultul Isak; ma ina nunure tana ba u mari kaugu luluai. ");
INSERT INTO ksd_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ma ba i ga tata boko, gire, Rebeka i ga irop, natu i Betuel, nina ba Milka i ga kava tar ia tai Nakor, tura i Abaraam, ma i ga kap ra kulkulup ta ra ul a varana. ");
INSERT INTO ksd_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ma a vakak na vavina tuna, a inip, ma pa ta tutana i ga la tana boko; ma i ga vana ur ta ra kivu, ma i ga vabuka kana kulkulup, ma i ga tutua rikai. ");
INSERT INTO ksd_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ma ra tultul i ga vutvut upi na barat ia, ma i ga biti: Una vamomo iau ma ta ik a tava ta kaum kulkulup. ");
INSERT INTO ksd_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ma i ga biti: Una momo, luluai. Ma i ga lulut, i ga vairop ra kulkulup ta ra limana, ma i ga vamoma. ");
INSERT INTO ksd_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ma ba i ga tar vamoma, i ga biti: Ina kulup ure kaum umana kamel bula, upi diat a momo ma diat a maur. ");
INSERT INTO ksd_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ma i ga pampam, i ga lolonge ra tava ma ra kulkulup ta ra turtur na tava, ma i ga vutvut mulai ta ra kivu, upi na kulup, ma i ga kulup ure kana umana kamel par. ");
INSERT INTO ksd_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ma ra tutana i ga bobe ung ia, ma i ga ki mut uka upi na nunure value, ba a Luluai i ga maravut kana vinavana ba pata. ");
INSERT INTO ksd_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ma ba ra umana kamel dia ga tar momo par, a tutana i ga tak pa ra domol di pait ia ma ra goled i mamat a ik, ma a ura mul ure ra limana, dir ga varogop ma a vinun na mamat na goled, ");
INSERT INTO ksd_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ma i ga biti: U natu i to ia? Una ve iau. Dave, ta maup abara ta ra kuba i tamam, upi avet a ki tana? ");
INSERT INTO ksd_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ma i ga biti tana: Iau natu i Betuel, nina Milka i ga kava tar ia tai Nakor. ");
INSERT INTO ksd_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ma i ga biti bula tana: Ave vung ra kunai ma ra magit bula ure ra kamel, ma a maup bula pire vevet, upi avat a va tana. ");
INSERT INTO ksd_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ma ra tutana i ga bura rururu, ma i ga lotu tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ma i ga biti: Da pite pa ra Luluai ra God kai kaugu luluai Abaraam, tago pa i vung vue kana varmari ma kana dovotina tadav kaugu luluai, ma i ga vateten iau ta ra nga uti, ta ra kuba i ra umana tura i kaugu luluai. ");
INSERT INTO ksd_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ma ra inip na vavina i ga vutvut, ma i ga varvai ta go ra lavur magit ta ra kuba i nana. ");
INSERT INTO ksd_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ma Rebeka dir taina ma tika na tutana, a iangina Laban; ma Laban i ga kavie ra vinavana, upi na tadav ra tutana ta ra kivu. ");
INSERT INTO ksd_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Ma ba i ga gire ra domol ma ra mul ta ra lima i taina, ma ba i ga valongore ra tinata kai Rebeka, taina, ba i ga biti, A tutana i ga ve iau ra dari, i ga tadav ra tutana; ma gire, i ga tur pire ra umana kamel ta ra kivu. ");
INSERT INTO ksd_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ma i ga biti tana: Una ruk, u nina a Luluai i ga vadoane, ta ra ava u turtur ra pia? Iau tar vaninare ra pal, ma iau tar mal are ra pakana bula ure ra umana kamel. ");
INSERT INTO ksd_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ma ra tutana i ga ruk ra pal, ma i ga pala vue ra tabarikik ta ra umana kamel. Ma i ga tul tar ra kunai tana ma ra magit na nian ure ra umana kamel ma ra tava bula, pi na puk ra kauna me, ma ra kau i ra tarai dia varagur me. ");
INSERT INTO ksd_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ma di ga vung ra magit na nian pirana, upi na ian; ma i ga biti: Pa ina ian boko,, ina varvai lua ure kaugu vinavana. Ma i ga biti: Una varvai ka. ");
INSERT INTO ksd_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ma i ga biti: Iau a tultul kai Abaraam. ");
INSERT INTO ksd_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ma ra Luluai i ga manga maravut kaugu luluai, ma i tar ngala; ma i ga tabar ia ma ra do na sip ma mangoro na bulumakau, ma ra silva ma ra goled, ma ra umana tultul na tutana ma ra umana tultul na vavina, ma ra umana kamel ma ra umana as. ");
INSERT INTO ksd_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ma Sara, a taulai kai kaugu luluai, i ga kava tar tika na bul tutana tai kaugu luluai, ba i ga tubuan na vavina; ma Abaraam i tul tar kana lavur tabarikik par ta nam ra bul. ");
INSERT INTO ksd_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ma kaugu luluai i ga kure ba ina vavalima, ma i ga biti dari: Koko una pilak pa ta vavina ure natugu pire ra vaden ta ra gunan Kanaan, nina iau ki tana; ");
INSERT INTO ksd_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","una vana ka tadav ra kuba i tamagu, ma pire ra umana niurugu, ma una pilak pa tika na taulai kai natugu. ");
INSERT INTO ksd_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ma iau ga biti tai kaugu luluai: Kan ra vavina na ole ra vinavana mur iau uti. ");
INSERT INTO ksd_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ma i ga biti tagu: A Luluai, nina iau vanavana ta ra luaina matana, na tulue amur ma kana angelo, ma na maravut u ta kaum vinavana, ma una pilak pa tika na vavina ure natugu ta ra umana niurugu ta ra kuba i tamagu; ");
INSERT INTO ksd_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ma damana una langalanga ta kaugu vavalima, ba u tadav ra umana niurugu; ma ona pa di nur tar ia piram, u ti langalanga ta kaugu vavalima. ");
INSERT INTO ksd_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ma gori iau tar pot ta ra kivu, ma iau biti: Luluai, a God kai kaugu luluai Abaraam, boina una maravut iau ta kaugu vinavana; ");
INSERT INTO ksd_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","gire, iau tur ta ra kivu na tava; boina una tul tar ia, ba nam ra vavina, nina i irop upi na kulup, ma ina biti tana, Una tabar iau ma ta ik a tava ta kaum kulkulup, ");
INSERT INTO ksd_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ma na biti tagu, Una momo, ma ina kulup bula ure kaum umana kamel, boina ba ia nam ra vavina iat, nina ba ra Luluai i ga tibe, upi na taule ra natu i kaugu luluai. ");
INSERT INTO ksd_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ma ba pa i par boko ra tinata ta ra balagu, gire, Rebeka i vana rikai ma kana kulkulup ta ra ul a varana, ma i vana ur upi ra kivu, ma i kulup; ma iau biti tana: Boina una vamomo iau. ");
INSERT INTO ksd_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ma i rurut, ma i vairop ra kulkulup marama ra ul a varana, ma i biti: Una momo, ma ina vamomo kaum umana kamel bula; io, iau momo, ma i vamomo ra umana kamel bula. ");
INSERT INTO ksd_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ma iau tir ia: U natu i to ia? Ma i biti: Natu i Betuel, natu i Nakor nina ba Milka i ga kava tar ia. Ma iau vung tar ra marmar ta ra bilauna, ma ra mul ta ra limana. ");
INSERT INTO ksd_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Iau bura rururu ma iau lotu tadav ra Luluai, ma iau pite pa ra Luluai, a God kai kaugu luluai Abaraam,, nina i ga lue rap iau ta ra takodo na nga, upi ina pilak pa natu i ra tura i kaugu luluai, upi na taule natuna. ");
INSERT INTO ksd_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ma ona avat a pait ra varmari ma ra dovot na mangamangana pire kaugu luluai, avat a ve iau; ona pata, avat a ve iau bula, upi ina vana ta ra papar a lima tuna, ba ta ra maira. ");
INSERT INTO ksd_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Io, Laban ma Betuel dir ga tata bali ia dari: Go ra magit i vuna tai ra Luluai, i dekdek upi amir a tatike ta magit i boina ba ta magit i kaina tam. ");
INSERT INTO ksd_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Gire, Rebeka i tur ta ra luaina matam, una agur pa ia, ma amur a vana, ma na taule natu i kaum luluai, da ra Luluai i tar biti. ");
INSERT INTO ksd_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ma ba ra tultul kai Abaraam i ga valongore kadir tinata, i ga va timtibum ta ra mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ma i ga tak vaarike ra lavur ngatngat na magit, di ga pait diat ma ra silva ma ra goled, ma ra umana mal, ma i ga tabar Rebeka me, ma taina bula ma nana, i ga tabar dir ma ra umana ngatngat na magit. ");
INSERT INTO ksd_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ma dia ga iaian ma dia ga momamomo, diat ma ra tarai dia ga varagur me; ma nam ra marum dia ga ki boko; ma dia ga tut ta ra kavunvun, ma i ga biti: Avat a tul vue iau tadav kaugu luluai. ");
INSERT INTO ksd_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ma tai ra vavina ma nana dir ga biti: Boina ba ra vavina na ki ati boko pire vevet ta umana bung, ta vinun bar, ma namur na vana. ");
INSERT INTO ksd_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ma i ga biti ta dir: Koko amur a tur bat iau, tago a Luluai i ga maravut iau ta kaugu vinavana, avat a nur vue ke iau, upi ina talil tadav kaugu luluai. ");
INSERT INTO ksd_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ma dir ga biti: Dat a oro pa boko ra vavina, ma dat a tir ia, ba ava ra nuknukina. ");
INSERT INTO ksd_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ma dia ga oro Rebeka, ma dia ga tir ia dari: Dave, amur a varagur ma go ra tutana? Ma i ga biti: Amir a varagur. ");
INSERT INTO ksd_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ma dia ga tul vue Rebeka, tai diat, ma kana tultul na vavina, diat ma ra tultul kai Abaraam, ma kana tarai. ");
INSERT INTO ksd_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ma dia ga tata vadoane Rebeka, ma dia biti tana: Tai vevet, boina ba ra arip na mar na vinun na arip na marmar diat a vana rikai tam, ma i boina ba ra umana bul mur tam diat a kale ra mataniolo kadiat nina dia milikuane diat. ");
INSERT INTO ksd_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ma Rebeka i ga tut, diat ma kana umana tultul na vavina, ma dia ga ki ra umana kamel, ma dia ga mur ra tutana. Ma ra tultul i ga lue rap Rebeka, ma i ga vana ka. ");
INSERT INTO ksd_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ma Isak i ga lilikun maro ra kivu Lakaroi, tago i ga ki ra gunan ta ra papar a taubar. ");
INSERT INTO ksd_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ma ba i ga ravian, i ga vana ta ra uma, upi na nununuk; ma i ga idok, ma i ga gire ra umana kamel dia ga poapot. ");
INSERT INTO ksd_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ma Rebeka i ga tak vatut ra kiau na matana ma ba i ga gire Isak, i ga irop kan ra kamel. ");
INSERT INTO ksd_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Ma i ga biti tai ra tultul: To ia nam ra tutana i bolabolo abara ta ra uma, upi na totongo upi dat? Ma ra tultul i ga biti: Kaugu luluai nam. Ma i ga tak pa kana mal na turturup, ma i ga turup mule ra matana. ");
INSERT INTO ksd_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ma ra tultul i ga ve Isak ta ra lavur magit i ga tar pait ia. ");
INSERT INTO ksd_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ma Isak i ga agure ta ra pal na mal kai nana Sara, ma i ga ben pa Rebeka ma dir ga taulai muka, ma i ga mari ia; ma Isak i ga ngo ma ra tinabun ure ra minat i tinana. ");
INSERT INTO ksd_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ma Abaraam i ga taule mule tika na vavina, a iangina Ketura. ");
INSERT INTO ksd_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ma i ga kava tar Simran, ma Ioksan, ma Medan, ma Midian, ma Isbak, ma Sua tana. ");
INSERT INTO ksd_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Ma Ioksan i ga vangala Seba ma Dedan. Ma ra utul a natu i Dedan: Asurim, ma Letusim, ma Leumim. ");
INSERT INTO ksd_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ma ra umana natu i Midian: Epa, ma Eper, ma Kanok, ma Abida, ma Elda. Go diat par a umana natu i Ketura. ");
INSERT INTO ksd_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ma Abaraam i ga tul tar kana tabarikik par tai Isak. ");
INSERT INTO ksd_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ma Abaraam i ga pait ra vartabar pire ra lavur natu i kana umana enana vavina; ma ba i ga laun boko, i ga tul vue diat balakane natuna Isak ta ra gunan uro ta ra papar a taur. ");
INSERT INTO ksd_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ma ga a niluluk ure ra lavur kilala kai Abaraam: kana lavur kilala i ga varogop ma tika na mar lavurua na vinun ma a ilima. ");
INSERT INTO ksd_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ma Abaraam i ga vung vue ra tulungeana, ma i ga mat ba i ga laun vao, a patuana tutana, ma i ga mangoro kana kilala; ma i ga ki varurung ma ra taraina. ");
INSERT INTO ksd_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ma Isak ma Ismael, a ura natuna, dir ga punang ia ta ra babang Makpela, ta ra pakana pia kai Epron, natu i Sokar, a te Ket, maravai Mamre; ");
INSERT INTO ksd_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","nina ra pakana pia Abaraam i ga kul pa ia tai ra umana natu i Ket; di ga punang kapi Abaraam tana ma kana taulai Sara. ");
INSERT INTO ksd_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ma ba Abaraam i ga mat, God i ga vadoane Isak natuna, ma Isak i ga ki pire ra kivu Lakaroi. ");
INSERT INTO ksd_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ma go ra umana bul mur tai Ismael, natu i Abaraam, nina Agar, a te Aigipto, a tultul na vavina kai Sara, i ga kava tar ia; ");
INSERT INTO ksd_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ma go ra iang i ra umana natu i Ismael da kadia varmur na kinakava. A luaina kai Ismael, Nebaiot; namur Kedar, ma Abdel, ma Mibsam, ");
INSERT INTO ksd_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ma Misma, ma Duma, ma Masa; ");
INSERT INTO ksd_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Adad ma Tema, Ietur, Napis ma Kedema; ");
INSERT INTO ksd_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","go diat a umana natu i Ismael, a iang i diat da kadia lavur pia na pal, ma kadia lavur gunan di ga liplip bat ia, a vinun ma a urua na luluai, varogop ma kadia vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ma go ra niluluk ure ra lavur kilala na nilaun kai Ismael: tika na mar ma a utul a vinun ma lavurua na kilala; ma i ga vung vue ra tulungeana, ma i ga mat; ma i ga ki varurung ma kana tarai. ");
INSERT INTO ksd_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ma dia ga ki ta ra gunan i tur pa ia Kavila, ma i langun aro Sur dir varmatam ma Aigipto, ma i vatale uro Asiria; i ga ki ta ra luaina mata i ra umana turana. ");
INSERT INTO ksd_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ma go ra varvai ure Isak, natu i Abaraam: Abaraam i ga vangala Isak, ");
INSERT INTO ksd_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ma Isak, ba a ivat na vinun kana kilala, dir ga taulai ma Rebeka, natu i Betuel a te Siria maro Padan-Aram, dir taina ma Laban a te Siria. ");
INSERT INTO ksd_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ma Isak i ga lul ra Luluai ure kana taulai, tago i biu; ma ra Luluai i ga torom tana, ma kana taulai i ga lalau pa ra bul. ");
INSERT INTO ksd_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ma ra ura bul dir ga varubu ta ra balana; ma i ga biti: Ona i damana, ta ra ava iau laun? Ma i ga vana upi na tir ra Luluai tana. ");
INSERT INTO ksd_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ma ra Luluai i ga biti tana: A ura vuna tarai ta ra balam, Ma a ura vuna tarai dir vana rikai tam dir a tur vartibai; Ma tika na vuna tarai ta dir na ongor; Ma ra luaina na kudakudar ta ra muruna. ");
INSERT INTO ksd_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ma ba i ga ot ra bung ba na kakava tana, a kanga i ga ki ta ra tatal na bul. ");
INSERT INTO ksd_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ma ra luaina i ga vana rikai ma i ga ivivuna ra pakana da ra mal i ivivuna, ma i ga kubar; ma di ga vaiang tar ra iangina ba Esau. ");
INSERT INTO ksd_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ma namur turana i ga vana rikai; ma ra limana i ga vatur vake ra inabut i Esau; ma di ga vaiang tar ra iangina ba Iakob. Ma Isak i ga laptikai na vinun kana kilala, ba Rebeka i ga kava dir. ");
INSERT INTO ksd_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ma ra ura bul tutana dir ga taiak; ma Esau a tena nirovoi tuna, ma i ga vanavana ta ra pupui; ma Iakob a tena ki vovovon, i ga ki vatikai ta ra umana pal na mal. ");
INSERT INTO ksd_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ma Isak i ga mainge Esau, tago i ga iaian ra kanomong i ra leing Esau i ub ia. Ma Rebeka i ga mainge Iakob. ");
INSERT INTO ksd_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ma Iakob i ga tun tika na magit na nian; ma Esau i ga lilikun maro ra pupui, ma i ga bel ika; ");
INSERT INTO ksd_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ma Esau i ga biti tai Iakob: Una tabar iau ma nam ra nian i meme, tago iau bel ika; kari di ga vatang ra iangina ba Edom. ");
INSERT INTO ksd_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ma Iakob i ga biti: Una ivure kaum kini na lua tagu. ");
INSERT INTO ksd_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ma Esau i ga biti: Gire, iau to na mat, ma ina boina dave ure go ra kini na lua? ");
INSERT INTO ksd_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ma Iakob i ga biti: Boina una vavalima piragu; ma i ga vavalima tana, ma i ga ivure tar kana kini na lua pire Iakob. ");
INSERT INTO ksd_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ma Iakob i ga tul tar ra gem tai Esau, ma ra magit i ga pait ia ma ra pat na davai; ma i ga iaian, ma i ga momo, ma i ga tut, ma i ga vana. Damana Esau i ga pidimuane kana kini na lua. ");
INSERT INTO ksd_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ma tika na mulmulum mulai i ga tup ra gunan da nam ra luaina mulmulum ta ra e kai Abaraam. Ma Isak i ga vana uro Gerar, pire Abimelek ra king kai ra tarai Pilistia. ");
INSERT INTO ksd_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ma ra Luluai i tur kapet pa pirana, ma i ga biti: Koko una vana ba Aigipto; una ki ke ta nam ra gunan ba ina vateten tar ia tam; ");
INSERT INTO ksd_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","una ki na vaira ta go ra gunan, ma ina ki maravut u, ma ina vadoane u; tago ina tul tar tam go ra gunan par, ma ta ra lavur bul mur tam; ma ina vatur vadovot nam ra vavalima, iau ga pait tar ia tai tamam Abaraam. ");
INSERT INTO ksd_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ma ina vapeal ra umana bul mur tam da ra umana tagul arama liu, ma ina tul tar go ra gunan par ta ra umana bul mur tam; ma ra lavur vuna gunan par ta ra rakarakan a gunagunan diat a ti doan ure ra umana bul mur tam, ");
INSERT INTO ksd_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","tago Abaraam i ga torom ta ra nilaigu, ma i ga mur kaugu togotogo, ma kaugu vartuluai, ma kaugu mangamangana, ma kaugu varkurai. ");
INSERT INTO ksd_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ma damana Isak i ga ki Gerar. ");
INSERT INTO ksd_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ma ra tarai ta nam ra gunan dia ga tir ia ure kana taulai; ma i ga biti: Amir taina; tago i ga burut upi na biti dari ba, Kaugu taulai, kan a tarai ta nam ra gunan diat a ub ia ure Rebeka, tago a potar na vavina. ");
INSERT INTO ksd_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ma ba i ga tar ki vavuan abara, Abimelek, a king kai ra tarai Pilistia, i ga tur ta ra mata na kalangar, ma i ga gire Isak dir ma Rebeka kana taulai, dir ga varpalum. ");
INSERT INTO ksd_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ma Abimelek i ga oro pa Isak, ma i ga biti tana: A dovotina nam ra vavina kaum taulai, ma u ga vatang davatane ba amur taina? Ma Isak i ga biti: Tago iau ga nuk ia ba ina virua ure. ");
INSERT INTO ksd_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ma Abimelek i ga biti: Ava go u ga pait ia ta vevet? Gala pa i dekdek upi ta tikai ta ra tarai na va pire kaum taulai, ma damana a ngala na mangamangana kaina na gala ki ta vevet ure u. ");
INSERT INTO ksd_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ma Abimelek i ga varkurai pire ra tarai par dari: Nina i bili go ra tutana ba kana vavina, na virua ka. ");
INSERT INTO ksd_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ma Isak i ga vavauma ta nam ra gunan, ma a marmar i ga vana rikai tana ta nam ra e; ma ra Luluai i ga vadoane. ");
INSERT INTO ksd_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ma go ra tutana i ga uviana vanavana, ma i ga tamtavua tuk i ga manga uviana. ");
INSERT INTO ksd_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ma i ga vatur vake ra umana kikil na sip, ma ra umana.kikil na bulumakau, ma ra kor na tultul; ma ra tarai Pilistia dia ga ngu ia. ");
INSERT INTO ksd_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Io, a tarai Pilistia dia ga tar punang mule ra umana kivu na tava, nina diat ba ra umana tultul kai tamana di ga tar kal diat ta ra e kai Abaraam; ma dia ga tar vabuka diat ma ra pia. ");
INSERT INTO ksd_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ma Abimelek i ga biti tai Isak: Una vana balakane avet, tago u manga ongor ta dat. ");
INSERT INTO ksd_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ma Isak i ga vana balakane nam ra gunan, ma i ga pait kana pal na mal aro Gerar, ma i ga ki tana. ");
INSERT INTO ksd_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ma Isak i ga kal are mule ra umana kivu na tava, nina dia ga tar kal diat ta ra e kai tamana Abaraam, tago ra umana Pilistia dia ga tar punang vakaina diat ba Abaraam i ga tar mat; ma i ga vatang mule diat ma ra iang i diat, nina tamana i ga vaiang diat me. ");
INSERT INTO ksd_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ma ra umana tultul kai Isak dia ga kakal ta ra male, ma dia ga tadav ra tava tana, i ga ninim rikai. ");
INSERT INTO ksd_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ma ra umana tena balabalaure vavaguai maro Gerar dia ga varngangar ma ra umana tena balabalaure kai Isak; dia ga biti dari: Kavevet go ra tava; ma i ga vaiang ra kivu ba Esek, tago dia ga vartoto me. ");
INSERT INTO ksd_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ma dia ga kal ta ra kivu, ma dia ga varngangar ure nam bula, ma i ga vaiang ia ba Sitna. ");
INSERT INTO ksd_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ma i ga kakari kan nam ra gunan, ma i ga kal ta ra kivu; ma pa dia ga varngangar ure nam; ma i ga vaiang ia ba Rekobot; tago i ga biti: Ra Luluai i tar tul tar ta maup ure dat, ma dat a tavua ta go ra gunan. ");
INSERT INTO ksd_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ma i ga vana kairu urama Ber-Seba. ");
INSERT INTO ksd_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ma ra Luluai i ga tur kapet pa pirana ta nam ra marum, ma i ga biti: Iau ra God kai Abaraam, tamam; koko una burut, tago ina ki maravut u, ma ina vadoane u. ma ina vapeal ra umana bul mur tam ure kaugu tultul Abaraam. ");
INSERT INTO ksd_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ma i ga pait tika na uguugu na vartabar ie ma i ga kail pa ra iang i ra Luluai, ma i ga page kana pal na mal tana; ma ra umana tultul kai Isak dia ga kal tika na kivu ie. ");
INSERT INTO ksd_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Namur Abimelek i ga vana pirana maro Gerar, ma Akusat talaina, ma Pikol ra luluai kai kana loko na tarai na vinarubu. ");
INSERT INTO ksd_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ma Isak i ga biti ta dital: Ta ra ava amutal vana piragu, tago amutal milikuane iau, ma amutal ga tul vue iau kan avat. ");
INSERT INTO ksd_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ma dital ga biti: Amital gire bulu ia, ba ra Luluai i maravut u; ma amital biti ba: Boina ba ta vavalima na tur pire dat, piram ma pire mimital, ma dat a pait ra kunubu dari: ");
INSERT INTO ksd_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Koko una vakaina avet, da avet bula pa ave ga bili vakaina u, ma ave ga pait ika ra bo na magit piram, ma ave ga tul vue u ma ra malmal ika; ma u, go u ti doan tai ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ma i ga lapir dital, ma dital ga ian ma dital ga momo. ");
INSERT INTO ksd_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ma dital ga tut ta ra kavunvun, ma dia ga varvalima vargil; ma Isak i ga tul vue dital, ma dital ga vana kan ia ma ra malmal. ");
INSERT INTO ksd_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ma ta nam ra bung iat a umana tultul kai Isak dia ga vana pirana, ma dia ga ve ta ra kivu dia ga tar kal ia, ma dia ga biti: Ave tar tadav ra tava tana. ");
INSERT INTO ksd_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ma i ga vaiang ia ba Seba. Kari di vatang ra iang i ra pia na pal ba Ber-Seba, tuk tar ta ra bung gori. ");
INSERT INTO ksd_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ma Esau, ba i ga laun a ivat na vinun na kilala, dir ga taulai ma Iudit natu i Beri a te Ket, ma Basemat natu i Elon a te Ket. ");
INSERT INTO ksd_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ma ra bala i dir Isak ma Rebeka i ga manga takunuan ure dir. ");
INSERT INTO ksd_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ma ba Isak i ga manga patuana, ma ra matana i ga gavul, ma pa i ga nana kapa mulai, i ga oro pa Esau, a luaina natuna, ma i ga biti tana: Natugu! Ma i ga biti tana: Iau go kari. ");
INSERT INTO ksd_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ma i ga biti: Gire, iau tar patuana ma pa iau nunure kaugu bung na minat. ");
INSERT INTO ksd_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Una takan pa kaum vargal na nirovoi, a popopoi na pu ma ra panak, ma una vana ra pui, upi una rovoi upi ta mangana, ");
INSERT INTO ksd_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","una mal pa agu ta magit i kalami nina iau manga mainge, ma una kap ia piragu upi ina ian, ma a tulungeagu na tata vadoane u ba pa iau mat boko. ");
INSERT INTO ksd_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ma Rebeka i ga valongore ra tinata Isak i ga tatike pire Esau natuna. Ma Esau i ga vana ra pui, upi na rovoi upi ta magit ma upi na kap ia. ");
INSERT INTO ksd_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ma Rebeka i ga ve Iakob natuna, ma i ga biti: Gire, iau tar valongore tamam i ve Esau turam, ma i biti: ");
INSERT INTO ksd_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Una kap ta mangana leing piragu, ma una pait agu ta magit i kalami, upi ina en ia, ma ina tata vadoane u ta ra mata i ra Luluai, ba pa iau mat boko. ");
INSERT INTO ksd_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Io, natugu, una torom ta ra nilaigu, da iau kure tar ia tam. ");
INSERT INTO ksd_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Io, go una vana tadav ra kikil na me, ma una vila tar ta ura bo na nat na me tagu, ma ina mal pa dir upi ta kalami na magit ai tamam, nina ra mangana iat ba i mainge; ");
INSERT INTO ksd_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ma una kap ia pire tamam, upi na tata vadoane u ba pa i ti mat boko. ");
INSERT INTO ksd_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ma Iakob i ga biti tai nana Rebeka dari: Gire, a paka i Esau turagu i papait na ivivuna, ma iau, i kulkul ke ra pakagu. ");
INSERT INTO ksd_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Kan tamagu na bili iau, ma ina da ra tena vartuam pirana, ma a varvabilak na ki tagu ma pa ta varvadoan. ");
INSERT INTO ksd_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ma nana i ga biti tana: A varvabilak na ki tagu; una torom uka ta ra nilaigu, ma una vana, ma una vila tar dir tagu. ");
INSERT INTO ksd_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ma i ga vana, i ga vila tar dir, ma i ga kap dir pire nana; ma nana i ga mal pa ta kalami na magit na nian, da tamana i ga mainge. ");
INSERT INTO ksd_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ma Rebeka i ga takan pa ra umana mal kumau kai Esau, ra luaina natuna, dia va ta ra kubana, ma i ga vavauluve tar ia tai natuna Iakob, a muruna; ");
INSERT INTO ksd_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ma i ga vung ra pal i ra nat na me ta ra limana ma ta ra inoana i kulkul; ");
INSERT INTO ksd_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ma i ga tul tar ra kalami na nian ma ra gem, nina i ga tar vaninare, ta ra lima i natuna Iakob. ");
INSERT INTO ksd_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ma i ga ruk tadav tamana, ma i ga biti dari: Tamagu! Ma i ga biti: Iau go kari; u to ia, natugu? ");
INSERT INTO ksd_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ma Iakob i ga biti tai Isak dari: Iau Esau, a luaina natum, iau tar pait nam ra magit u ga tul tar ia tagu; una tut, una ki, ma una ian ta ra kanomong i ra mangana kuabar iau kap ia, upi ra tulungeam na tata vadoane iau. ");
INSERT INTO ksd_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ma Isak i ga biti tai natuna: U ga tikan lulut davatane tadav ia, natugu? Ma i ga biti: Tago a Luluai kaum God i tar maravut iau. ");
INSERT INTO ksd_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ma Isak i ga biti tai Iakob: Una tur maravai, upi ina bili u, natugu, upi ina nunure, ba i dovot u natugu Esau ba pata. ");
INSERT INTO ksd_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ma Iakob i ga kakari maravai pire Isak tamana, ma i ga palum ia, ma i ga biti: A nilaina i da ra nilai Iakob, ma ra limana da ra lima i Esau. ");
INSERT INTO ksd_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ma pa i ga nunure ilam ia, tago ra ura limana dir ivivuna da ra ura lima i Esau turana; ma i tata vadoane. ");
INSERT INTO ksd_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ma i ga biti tana: Dave u Esau, natugu tuna? Ma i ga biti tana: Iau ia tuna. ");
INSERT INTO ksd_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ma i ga biti: Una kap ia piragu, ma ina ian ta ra mangana kuabar kai natugu, upi ra tulungeagu na tata vadoane u. Ma i ga kap ia maravai pirana, ma i ga ian; ma i ga vila pa ra vain, ma i ga mome. ");
INSERT INTO ksd_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ma tamana Isak i ga biti tana: Una mai, ma una galum iau, natugu. ");
INSERT INTO ksd_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ma i ga vana maravai, ma i ga galum ia; ma i ga angine kana mal, ma i ga tata vadoane, ma i ga biti: Gire, ra angina i natugu I da ra ang na uma, nina ba ra Luluai i ga vadoane; ");
INSERT INTO ksd_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ma God na tul tar tam ra mavoko marama ra bala na bakut, Ma ra bira kai ra pia. Ma ra peal na kon ma ra vain; ");
INSERT INTO ksd_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Na boina ba ra lavur tarai diat a torom tam, Ma ra umana vuna tarai diat a va timtibum piram; Una kure ra umana turam. Ma ra umana natu i nam diat a va timtibum piram; Diat par dia tata vabilak u, diat a kakaina boko, Ma diat par dia tata vadoane u, diat a ti doan boko. ");
INSERT INTO ksd_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ma ba Isak i ga ngo ma ra tinata na varvadoan pire Iakob, ma ba Iakob i ga kabur irop uka kan ra mata i tamana Isak, turana Esau i ga lilikun mara ta ra nirovoi, ");
INSERT INTO ksd_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ma i ga vaninare ta kalami na magit bula, ma i ga kap ia pire tamana; ma i ga biti tai tamana: Boina ba tamagu na tut ma na ian ta ra mangana magit na kuabar kai natuna; upi ra tulungeam na tata vadoane iau. ");
INSERT INTO ksd_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ma Isak tamana i ga biti tana: U to ia? Ma i ga biti: Iau natum, kaum luaina, Esau. ");
INSERT INTO ksd_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ma Isak i ga dadadar na kaia, ma i ga biti: Ma to ia nam i kinim kapi ra mangana kuabar, ma i kap ia piragu, ma iau ian ta ra lavur magit, ba pa u ti vut boko, ma iau tar tata vadoane? Maia, ma ra varvadoan na ki vatikai tana. ");
INSERT INTO ksd_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ba Esau i ga valongore ra tinata kai tamana i ga tangi na kaia, ma i ga takunuan ra balana, ma i ga biti tai tamana: Tamagu, una ti vadoane bula iau. ");
INSERT INTO ksd_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ma i ga biti: Turam i tar pot ma ra vartuam, ma i tar long kaum nidoan. ");
INSERT INTO ksd_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ma i ga biti: I dovot ra iangina ba Iakob, tago a ura pakana i tar ki ur vue iau: i ga long pa kaugu kini na lua, ma gire, go i tar long pa kaugu nidoan. Ma i ga biti: Pa u vung vake vang ta varvadoan mulai ure iau? ");
INSERT INTO ksd_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ma Isak i ga bali Esau ma ra tinata dari: Gire, iau tar vaki ia upi kaum luluai, ma ra lavur turana iau tar tul tar diat i tana upi kana umana tultul, ma iau tar kure tar ia tana ra kon ma ra vain, ma ava mulai ina pait ia ure u, natugu? ");
INSERT INTO ksd_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ma Esau i ga biti tai tamana: Tamagu, dave, i kopono ko kaum varvadoan? Una ti vadoane iau bula, ioi, iau bula tamagu. Ma Esau i ga kukula, ma i ga tangi. ");
INSERT INTO ksd_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ma Isak tamana i ga bali ia, ma i ga biti dari: Gire, a gunan ba una ki tana, pa na bira Ma ra mavoko marama ra bala na bakut pa na vana rikai tana; ");
INSERT INTO ksd_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ma una laun ta kaum pakat na vinarubu iat, ma una kudakudar pire turam; Ma ta nam ra bung ba una langalanga, Una vue pakate kana kip kan ra inoam. ");
INSERT INTO ksd_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ma Esau i ga milikuane Iakob ure ra varvadoan nina tamana i ga tar vadoane me; ma Esau i ga nuknuk ia dari: A kilala na tinabun ure tamagu i maravai; namur ina ubu turagu Iakob. ");
INSERT INTO ksd_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ma Rebeka i ga valongore ure ra tinata kai Esau, ra luaina natuna; ma i ga vartuluai upi Iakob natuna, a muruna, ma i ga biti tana dari: Gire, turam Esau i tar ki ra uruna ure u, tago i vaninara upi na ub u. ");
INSERT INTO ksd_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Kari i boina, natugu, ba una torom ta ra nilaigu; una tut, ma una takap pire taigu Laban aro Karan, ");
INSERT INTO ksd_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ma una ki ka boko pirana, tuk tar namana, ba i tar ngo ra karangap i ra kankan kai turam; ");
INSERT INTO ksd_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","tuk tar namana ba ra kankan kai turam na ngo kan u, ma na valubane ra magit u ga pait ia pirana; ma ina vartuluai upi u, upi una vana mamaro uti; upi ra ava ina tangie amur par tai ta kopono bung? ");
INSERT INTO ksd_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ma Rebeka i ga biti tai Isak: Iau talanguan ta kaugu kini, tago ra ura vavina Ket; ona Iakob na taule tika na vavina Ket da nam dir, ta ra vaden ta go ra gunan, kaugu kini na boina mulai dave? ");
INSERT INTO ksd_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ma Isak i ga oro pa Iakob, ma i ga tata vadoane, ma i ga vartuluai pirana, dari: Koko amur a taulai ma ta tikai ta ra vaden Kanaan. ");
INSERT INTO ksd_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Una tut, ma una vana uro Padan-Aram, tadav ra kuba i tubum Betuel; ma una pilak pa kaum ta vavina mabara ta ra umana natu i Laban, dir taina ma nam. ");
INSERT INTO ksd_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ma God Dekdek Muka na vadoane u, ma na vapeal ra umana tut mur, ma na vangala ra umana tut mur, upi avat a kor na tarai boko; ");
INSERT INTO ksd_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ma na tul tar ra nidoan kai Abaraam tam ma avat ma ra lavur bul mur tam, upi una kale ra gunan u ki na vaira tana, nina ba God i ga tul tar ia tai Abaraam. ");
INSERT INTO ksd_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ma Isak i ga tul vue Iakob, ma i ga vana uro Padan-Aram tadav Laban, natu i Betuel, a te Siria, dir taina ma Rebeka, na i Iakob ma Esau. ");
INSERT INTO ksd_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Io, Esau i ga gire ba Isak i ga tata vadoane Iakob ma i ga tul vue uro Padan-Aram upi na taulai ma tika na vavina mabara; ma i ga gire ba i ga tata vadoane, i ga vartuluai bula pirana dari: Koko amur a taulai ma ta tika na vavina Kanaan; ");
INSERT INTO ksd_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ma go bula, ba Iakob i ga torom ta ra tinata kai tamana ma nana, ma i ga vana uro Padan-Aram; ");
INSERT INTO ksd_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ma Esau i ga gire ba tamana pa i manane ra vaden Kanaan; ");
INSERT INTO ksd_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ma Esau i ga vana pire Ismael, ma i ga taule tikai mulai maravut kana ura vavina, Makalat, dir taina ma Nebaiot, natu i Ismael, nina dir tamana ma Abaraam. ");
INSERT INTO ksd_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ma Iakob i ga irop kan Ber-Seba, ma i ga vana uro Karan. ");
INSERT INTO ksd_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ma i ga tadav tika na gunan, ma i ga ki tana ra marum, tago ra keake i tar kuba, ma i ga tak pa tika na vat ta nam ra gunan, ma i ga ulalang tana, ma i ga va ta nam ra pakana upi na diop. ");
INSERT INTO ksd_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ma i ga ririvon, ma gire, tika na kakao i tur ra pia ma ra turuna i tuk tar urama ra bakut, ma ra umana angelo kai God dia ga tututua ma dia ga vanavana ba tana. ");
INSERT INTO ksd_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ma gire, a Luluai i ga tur arama tana ma i ga biti: Iau a Luluai, a God kai Abaraam tamam, ma ra God kai Isak; a gunan go u va tana ina tul tar ia tam, ma ta ra umana bul mur tam; ");
INSERT INTO ksd_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","ma ra umana bul mur tam diat a pepeal boko da ra tobon ra pia, ma una ki ta ra papar a labur, ma ta ra papar a taubar, ma ta ra papar a taoai, ma ta ra papar a taur, ma ra lavur vuna tarai par ta ra rakarakan a gunagunan diat a ti doan ure ra umana bul mur tam. ");
INSERT INTO ksd_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ma gire, iau ki maravut u, ma ina balaure u ta ra lavur pakapakana gunan ba u vanavana tana, ma ina agur pa mule u ta go ra gunan ma pa ina vana balakane u tuk tar namana, ba iau ga pait ot pa ra lavur magit iau ga tatike ure u. ");
INSERT INTO ksd_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ma Iakob i ga tavangun kan ra nidiop, ma i ga biti: A dovot a Luluai i bang ta go ra gunan, ma pa iau ga nunure. ");
INSERT INTO ksd_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ma i ga burut, ma i ga biti: A pia i gomgom go! A kuba i God go, ma ra mataniolo kai ra bala na bakut. ");
INSERT INTO ksd_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ma Iakob i ga tut ra kavunvun ma i ga tak pa ra vat nina i ga tar ulalang tana, ma i ga vatur ia upi ra vat na im, ma i ga lolonge ra dangi urama tana. ");
INSERT INTO ksd_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ma i ga vatang ra iang i nam ra pia ba Betel, ma lua di ga vatang ia ba Lus. ");
INSERT INTO ksd_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ma Iakob i ga vavalima, ma i ga biti: Ona God na maravut iau, ma na balaure iau ta go ra nga iau mur ia, ma ba na tabar iau ma ra magit na nian, ma ra mal, upi ina mal me, ");
INSERT INTO ksd_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ma ina tadav mule ra kuba i tamagu ma ra malmal, io, ina vatur vake ra Luluai upi kaugu God. ");
INSERT INTO ksd_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ma go ra vat ba iau vatur ia upi ra im, ia ra kuba i God, ma ta ra lavur magit ba una tabar iau me, ina tul tar ra vavinununa tam. ");
INSERT INTO ksd_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ma Iakob i ga tur pa mule kana vinavana, ma i ga tadav ra gunan kai ra tarai ta ra papar a taur. ");
INSERT INTO ksd_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ma i ga gigira, ma i ga na tadav tika na kivu ta nam ra gunan, ma a utul a kikil na sip dia ga va maravai tana, tago dia ga vavamomo ra umana kikil na sip ma ra tava ta go ra kivu, ma a ngir na vat i ga va bat ra mata na kivu. ");
INSERT INTO ksd_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ma dia ga vala varurue ra lavur kikil na sip abara, ma dia ga pul vue ra vat kan ra mata na kivu, ma dia ga vamomo ra umana sip, ma namur dia ga pul tar mule ra vat ta kana kiki ta ra mata na kivu. ");
INSERT INTO ksd_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ma Iakob i ga tir diat dari: A umana turagu, avat mamave? Ma dia ga biti: Avet mamaro Karan. ");
INSERT INTO ksd_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ma i ga biti ta diat: Dave, ava nunure Laban, natu i Nakor? ");
INSERT INTO ksd_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ma dia ga biti: Ave nunure. Ma i ga tir diat: Dave, i laun boina? Dia ga biti: Maia, i laun boina; ma go Rakel natuna, i pot ma ra umana Sip. ");
INSERT INTO ksd_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ma i ga biti: Gire, a keake i ki tur boko, ma vakir ia ra pakana bung upi diat a varurue boko ra umana vavaguai; avat a vamomo ra umana sip, ma avat a vana ma avat a tabar diat. ");
INSERT INTO ksd_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ma dia ga biti: I dekdek boko; da agure varurue value ra lavur kikil na vavaguai, ma di pul vue ra vat kan ra mata na kivu, ma namur avet a vamomo ra umana sip. ");
INSERT INTO ksd_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ba i ga tatata boko pire diat, Rakel i ga pot ma ra umana sip kai tamana, tago i ga balabalaure diat. ");
INSERT INTO ksd_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ma ba Iakob i ga gire Rakel, natu i matuana Laban, ma ra umana sip kai matuana Laban, i ga vana maravai, ma i ga pul vue ra vat kan ra mata na kivu, ma i ga vamomo ra kikil na sip kai matuana. ");
INSERT INTO ksd_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ma Iakob i ga galum Rakel, ma i ga kukula ma ra tinangi. ");
INSERT INTO ksd_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ma Iakob i ga ve Rakel ba dir matuana ma tamana, ma ba ia natu i Rebeka; ma Rakel i ga rurut, ma i ga ve tamana. ");
INSERT INTO ksd_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ma ba Laban i ga valongore ra tinata ure Iakob, a matuana, i ga vutvut upi na barat ia, ma i ga tal ia ma i ga galum ia, ma i ga agure ta ra kubana. Ma Iakob i ga ve Laban ta go ra lavur magit par. ");
INSERT INTO ksd_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ma Laban i ga biti tana: A dovotina, u a urugu ma ra viogu. Ma i ga ki pirana tika na gai. ");
INSERT INTO ksd_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ma Laban i ga biti tai Iakob: A dovotina, dor matuana, ma pa i ko upi una papalum vakuku piragu; una ve ke iau, ba ava ra magit na topa ia, upi ina vapuak u me. ");
INSERT INTO ksd_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ma Laban a ura natuna, a ura vavina; a iang i ra luaina ba Lea, ma ra muruna Rakel. ");
INSERT INTO ksd_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Ma ra kiau na mata i Lea i bilua, ma Rakel a metek na vavina, ma i vakak. ");
INSERT INTO ksd_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ma Iakob i ga manane Rakel; ma i ga biti: Ina papalum lavurua na kilala piram ure Rakel, natum, a muruna. ");
INSERT INTO ksd_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ma Laban i ga biti: I boina ba ina tul tar ia tam, ma koko ina tul tar ia tai ta enana tutana; una ki piragu. ");
INSERT INTO ksd_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ma Iakob i ga kudakudar lavurua na kilala ure Rakel; ma dia ga varogop pirana ma ta umana bung uka, tago i ga ngala kana varmari pirana. ");
INSERT INTO ksd_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ma Iakob i ga biti tai Laban: Una tul tar kaugu taulai tagu, tago i tar ot kaugu lavur bung, upi ina ki pirana. ");
INSERT INTO ksd_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ma Laban i ga ting varurue ra tarai par ta nam ra gunan, ma i ga pait ra lukara. ");
INSERT INTO ksd_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ma ta ra mata na ravian i ga vana, ma i ga agur pa Lea natuna pirana: ma i ga ruk pirana. ");
INSERT INTO ksd_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ma Laban i ga tul tar Silpa, kana tultul na vavina, tai natuna Lea, upi na tultul na vavina pirana. ");
INSERT INTO ksd_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ma ba i ga malana, Iakob i ga gire ba Lea; ma i ga biti tai Laban: Ava go ra magit u tar pait ia tagu? Pa iau ga papalum piram ure Rakel laka? Ta ra ava u tar tuam pa iau? ");
INSERT INTO ksd_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ma Laban i ga biti: Vakir a mangamangana ta go kaveve gunan, ba da tul value tar ra muruna, ma namur ra luaina. ");
INSERT INTO ksd_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Una pait ot pa ra lavurua na bung ure go, ma avet a tul tar nam bula tam ma una papalum pa mule lavurua na kilala piragu. ");
INSERT INTO ksd_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ma Iakob i ga pait ia damana, ma i ga pait ot pa kana lavurua na bung; ma Laban i ga tul tar natuna Rakel pirana, upi dir a taulai. ");
INSERT INTO ksd_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ma Laban i ga tul tar Bila, kana tultul na vavina, pire natuna Rakel, upi na tultul na vavina pirana. ");
INSERT INTO ksd_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ma i ga ruk bula tadav Rakel, ma i ga manga mari Rakel ta dir ma Lea, ma i ga kudakudar lavurua na kilala mulai pire Laban. ");
INSERT INTO ksd_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ma ba ra Luluai i ga gire Iakob i ga milmilikuane Lea, i ga tul tar ia tana pi na kakava: ma Rakel i ga biu ka. ");
INSERT INTO ksd_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Ma Lea i ga lalau pa, ma i ga kava tika na bul tutana, ma i ga vaiang tar ra iangina ba Ruben; tago i ga biti: A Luluai i nuk pa ra magit i monong iau; ma go kaugu tutana na mari iau. ");
INSERT INTO ksd_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ma i ga lalau pa mulai, ma i ga kava ra bul tutana; ma i ga biti: Tago a Luluai i valongore ba di milikuane iau, i tar tabar iau ma go ra bul tutana bula, ma i ga vatang ra iangina ba Simeon. ");
INSERT INTO ksd_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ma i ga lalau pa mulai, ma i ga kava ta ra bul tutana; ma i ga biti: Io, go kaugu tutana na ki piragu tago iau tar kava tar a utul a bul tutana tana; kari di ga vatang ra iangina ba Levi. ");
INSERT INTO ksd_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ma i ga lalau pa mulai, ma i ga kava tika na bul tutana, ma i ga biti: Go ina pite pa ra Luluai; kari i ga vatang ra iangina ba Iuda; ma i ga ngo ma ra kinakava. ");
INSERT INTO ksd_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ma ba Rakel i ga gire ba pa i kap bala tai Iakob, Rakel i ga pin tana vavina, ma i ga biti tai Iakob: Una tul tar ta umana bul tagu, ona pata, ina mat ika. ");
INSERT INTO ksd_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ma ra kankan kai Iakob i ga tut ure Rakel, ma i ga biti: Dave, iau a tur kia kai God vang, nina i muie tam ra vuai ra balam? ");
INSERT INTO ksd_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ma i ga biti: Go kaugu tultul na vavina Bila, una ruk pirana, upi na kakava piragu, ma iau bula ina vatur vake ta umana bul tana. ");
INSERT INTO ksd_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ma i ga tul tar Bila, kana tultul na vavina, upi dir a taulai, ma Iakob i ga ruk pirana. ");
INSERT INTO ksd_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ma Bila i ga lalau pa, ma i ga kava tar ra bul tutana tai Iakob. ");
INSERT INTO ksd_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ma Rakel i ga biti: God i tar kure iau, ma i tar valongore ra nilaigu bula, ma i tar tabar iau ma tika na bul tutana; kari i ga tar ra iangina ba Dan. ");
INSERT INTO ksd_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Ma Bila, ra tultul na vavina kai Rakel, i ga lalau pa mulai, ma i ga kava tar ra vauruana bul tai Iakob. ");
INSERT INTO ksd_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ma Rakel i ga biti: Amir tar manga varubu ma tana vavigu, ma iau tar uvia pa ia; ma i ga tar ra iangina ba Naptali. ");
INSERT INTO ksd_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ma ba Lea i ga gire ba i tar ngo ma ra kinakava, i ga tul tar Silpa, kana tultul na vavina, tai Iakob, upi dir a taulai. ");
INSERT INTO ksd_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Silpa, a tultul na vavina kai Lea, i ga kava tar ra bul tutana tai Iakob. ");
INSERT INTO ksd_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ma Lea i ga biti: Iau ti kedek! Ma i ga tar ra iangina ba Gad. ");
INSERT INTO ksd_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ma Silpa, a tultul na vavina kai Lea, i ga kava tar ra vauruana bul tai Iakob. ");
INSERT INTO ksd_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ma Lea i ga biti: Iau ti doan! Tago ra vaden diat a vatang iau boko ba iau ti doan; ma i ga tar ra iangina ba Aser. ");
INSERT INTO ksd_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ma Ruben i ga vana ta ra uma ta ra e na nidodoko na vit, ma i ga na tadav ta vuai na davai, a pepe, ma i ga kap ia pire nana Lea. Ma Rakel i ga biti tai Lea: Boina una tabar iau ma ta ik ta nam ra pepe kai natum. ");
INSERT INTO ksd_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ma i ga biti tana: Dave, a ikilik na magit go ba u tar tak vue kaugu tutana? Ma go u mainge bula ba una tak vue ra pepe kai natugu? Ma Rakel i ga biti: Io, na va piram go ra marum ure ra pepe kai natum. ");
INSERT INTO ksd_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ma Iakob i ga lilikun maro na uma ta ra ravian, ma Lea i ga irop upi na totongo upi ia, ma i ga biti tana: Una ruk piragu; tago iau tar tokom u ma ra pepe kai natugu. Ma i ga va pirana nam ra marum. ");
INSERT INTO ksd_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ma God i ga valongore Lea, ma i ga lalau pa, ma i ga kava tar ra vailimana bul tutana tai Iakob. ");
INSERT INTO ksd_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ma Lea i ga biti: God i tar tul tar tagu kaugu totokom, tago iau ga tul tar kaugu tultul na vavina ta kaugu tutana; ma i ga tar ra iangina ba Isakar. ");
INSERT INTO ksd_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ma Lea i ga lalau pa mulai, ma i ga kava tar ra valaptikaina bul tutana tai Iakob. ");
INSERT INTO ksd_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ma Lea i ga biti: God i tar tabar iau ma ra bo na vartabar! Kaugu tutana na ki piragu go, tago iau tar kava tar laptikai na bul tutana. Ma i ga tar ra iangina ba Sebulun. ");
INSERT INTO ksd_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ma namur i ga kava tika na bul vavina, ma i ga tar ra iangina ba Dina. ");
INSERT INTO ksd_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ma God i ga nuk pa Rakel, ma God i ga valongore, ma i ga papa are ra tatal na bul tana. ");
INSERT INTO ksd_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ma i ga lalau pa, ma i ga kava ra bul tutana; ma i ga biti: God i tar tak vue ra magit na vavirvir kan iau; ");
INSERT INTO ksd_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ma i ga tar ra iangina ba Iosep, ma i ga biti: A Luluai na maravut iau ma ta tika na bul tutana mulai! ");
INSERT INTO ksd_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ma ba Rakel i ga kava Iosep, Iakob i ga biti tai Laban: Una pala vue iau, upi ina lilikun ta ra kubagu ma ta kaugu gunan iat. ");
INSERT INTO ksd_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Una tul tar tagu kaugu ura taulai, ma ra umana natugu, nina iau ga kudakudar piram ure diat, ma una pala vue iau, tago u nunure kaugu kini na kunudar piram. ");
INSERT INTO ksd_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ma Laban i ga biti tana: Ona u mari iau go, boina una ki boko, tago iau tar matote ba ra Luluai i ga maravut iau tam. ");
INSERT INTO ksd_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ma i ga biti: Una vatang tar kaum vapuak tagu, ma ina tul tar ia. ");
INSERT INTO ksd_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ma i ga biti tana: U nunure kaugu mangamangana kunudar piram, ma ra mangana kini kai kaum lavur vavaguai ta kaugu varbalaurai. ");
INSERT INTO ksd_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Tago ta nam ra kilala, ba pa iau ga ki boko piram, dia ga ikilik, ma go dia tar tavua ma dia manga peal; ma ra Luluai i tar maravut u ta ra lavur magit iau ga bili ia; ma go vingai ina mal guve ta magit ure ra kubagu iat? ");
INSERT INTO ksd_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ma i ga biti: Ava ina tabar u me? Ma Iakob i ga biti dari: Koko una tabar iau ma ta magit: una pait ika nam ra magit ba ina ve u tana go; ma ina tabar mule kaum kikil na vavaguai ma ina balaure diat. ");
INSERT INTO ksd_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ieri ina vana livuan ta ra kikil na vavaguai par, ma ina pilak vue kan diat ra lavur sip i palapalatabu, ma i tuntun pitipit, ma i korong ra paka i diat, ma damana bula ra umana me ba i palapalatabu, ma i tuntun pitipit ra paka i diat; ma nam uka kaugu vapuak. ");
INSERT INTO ksd_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Damana kaugu mangamangana takodo na varvai maravut iau namur ta ra luaina matam ta nam ra bung, ba una pot ure kaugu vapuak: a lavur me ba pa i palapalatabu, ma pa i tuntun pitipit ra paka i diat, ma ra lavur sip pa i korong ra paka i diat u tadav diat piragu, da biti ka ba iau tar long diat. ");
INSERT INTO ksd_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ma Laban i ga biti: Iau mainge ba na da kaum tinata. ");
INSERT INTO ksd_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ma ta nam ra bung i ga pilak vue ra umana me, ra umana tomotoina i tuntun pitipit ra paka i diat, ma ra lavur me, ra lavur tana i palapalatabu ma i tuntun pitipit ra paka i diat, diat par dia papait na pua, ma ra umana korong na sip, ma i ga tul tar diat tai ra umana natuna; ");
INSERT INTO ksd_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ma i ga kure, ba Iakob na ki vailik kan ia, da ra vinavana di pait ia ta ra utul a bung, ma dir ma Iakob dir ga ki varbaiai; ma Iakob i ga tabatabar ra umana kikil na vavaguai dia ga ki valili. ");
INSERT INTO ksd_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Ma Iakob i ga tak pa ra umana kalamana davai ik, a utul a mangana, ma i ga kulit vuvurkutu tana, upi ra pua ta ra davai na vana rikai. ");
INSERT INTO ksd_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ma i ga vung nam ra umana davai ik, nina i ga kulit diat, ta ra luaina mata i ra umana vavaguai ta ra turtur na tava, ba ra umana vavaguai dia ga momo tana; ma dia ga vartadav ba dia ga pot upi ra nimomo. ");
INSERT INTO ksd_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ma dia ga. vartadav ba ra umana davai dia tur ta ra luaina mata i diat, ma dia ga kava ra umana natu i diat, ma i ga palapalatabu ma i ga tuntun pitipit ra paka i diat. ");
INSERT INTO ksd_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ma Iakob i ga varbaiane ra umana nat na vavaguai, ma i ga vung ra mata i ra umana vavaguai tadav diat, dia palapalatabu, ma i korong ra paka i diat ta ra kikil na vavaguai kai Laban; ma i ga agure vaire kana kikil na vavaguai iat, upi koko diat a tur varurung ma ra kikil na vavaguai kai Laban. ");
INSERT INTO ksd_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ma ta nam ra e, ba ra umana ongor na vavaguai dia ga vartadav, Iakob i ga vung nam ra davai ik ta ra luaina mata i diat ta ra turtur na tava, upi diat a vartadav pire ra umana davai; ");
INSERT INTO ksd_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ma ta nam ra e ba ra umana bilua na vavaguai dia ga vartadav, pa i ga vung ia; damana ra umana bilua kai Laban ma ra umana ongor kai Iakob. ");
INSERT INTO ksd_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ma go ra tutana i ga manga uviana vanavana, ma kana kikil na vavaguai i ga ngala, ma mangoro kana tultul na tutana ma kana tultul na vavina, ma kana lavur kamel ma ra lavur as. ");
INSERT INTO ksd_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ma Iakob i ga valongore ra tinata kai ra umana natu i Laban dari: Iakob i tar vatur vake ra magit par kai tama i dat, ma kana ngala na tabarikik i vuna ta ra lavur magit kai tama i dat. ");
INSERT INTO ksd_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ma Iakob i ga gire ra mata i Laban, ma pa i varogop mulai pirana da lua. ");
INSERT INTO ksd_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ma ra Luluai i ga biti tai Iakob: Una lilikun mulai tadav ra gunan kai ra umana tamam, ma tadav ra umana niurum; ma ina ki piram. ");
INSERT INTO ksd_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ma Iakob i ga vartuluai upi Rakel ma Lea uro ra pupui tadav ra kikil na sip; ");
INSERT INTO ksd_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ma i ga biti ta dir: Iau gire ra mata i tama i mumur pa i varogop mulai piragu da lua; ia kaka ra God kai tamagu i ga ki piragu. ");
INSERT INTO ksd_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ma amur nunure ba iau ga kudakudar tai tama i mumur ma ra dekdekigu par. ");
INSERT INTO ksd_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ma tama i mumur i tuam pa iau, ma i vala pukpukue kaugu vabongon; ma God pa i nur tar ia tana pi na vakaina iau. ");
INSERT INTO ksd_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ari i biti, Nina diat i tuntun pitipit ra paka i diat kaum vapuak diat, io, ra kikil na vavaguai par i kava ra tuntun pitipit; ma ona i biti dari, A palapalatabu kaum vapuak, io, ra kikil na vavaguai par dia kava ra palapalatabu. ");
INSERT INTO ksd_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Damana God i ga tak vue ra umana vavaguai kai tama i mumur, ma i ga tul tar diat tagu. ");
INSERT INTO ksd_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ma ta nam ra e, ba ra umana vavaguai dia vartadav, iau idok, ma iau gire ta ra ririvon, ma ra umana tomotoina dia pil tar tai ra umana tana, i palapalatabu, ma i tuntun pitipit, ma i ivivuna ra paka i diat. ");
INSERT INTO ksd_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ma ra angelo kai God i biti tagu ta ra ririvon: Iakob! Ma iau biti: Iau go kari. ");
INSERT INTO ksd_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ma i biti dari: una idok ma una gire, a umana tomotoina par, nina dia pil tar ta ra umana tana, i palapalatabu ra paka i diat, ma i tuntun pitipit, ma i ivivuna; tago iau tar gire ra lavur magit Laban i papait ia tam. ");
INSERT INTO ksd_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Iau a God kai Betel, a gunan u ga lolonge ra dangi ta ra vat ie, ma u ga pait ra vavalima tana piragu; go una tut, ma una irop kan go ra gunan, ma una talil ta nam ra gunan di ga kava u tana. ");
INSERT INTO ksd_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ma Rakel ma Lea dir ga bali ia ma ra tinata dari: Dave, kamimir ta tiniba ba ta ngungu tabarikik boko ta ra kuba i tama i mimir? ");
INSERT INTO ksd_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Amir da ra ura vaira pirana; tago i tar vapar vue kamimir mani bula. ");
INSERT INTO ksd_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Tago ra ngala na tabarikik God i tar tak vue kan tama i mimir kamimir nam ma kai ra umana natu i mimir; io, a lavur magit God i vaarike piram, una pait diat. ");
INSERT INTO ksd_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ma Iakob i ga tut, ma i ga vaki kana umana bul tutana ma kana ura taulai ta ra umana kamel; ");
INSERT INTO ksd_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ma i ga agure vue kana lavur vavaguai par, ma i ga kap kana lavur tabarikik, nina i ga vung varurue aro Padan-Aram, ma ra lavur vavaguai i ga vague diat, upi na vana tadav Isak tamana, ta ra gunan Kanaan. ");
INSERT INTO ksd_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Io, Laban i ga vana, upi na kut ra Ivuna sip; ma Rakel i ga long ra umana tabataba kai tamana. ");
INSERT INTO ksd_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ma Iakob i ga vana ivai pa kan Laban ra te Siria, tago pa i ga ve ure kana vinilau. ");
INSERT INTO ksd_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Damana i ga takap ma kana lavur tabarikik; ma i ga tut, ma i ga bolo ta ra tava alir, ma i ga vanavana upi ra luana Gilead. ");
INSERT INTO ksd_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ma dia ga ve Laban ta ra vautuluna bung taun ia, ba Iakob i ga tar takap. ");
INSERT INTO ksd_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ma i ga ting pa ra umana turana upi diat a varagur me, ma dia ga korot mur ia lavurua na bung, ma i ga tadav ia ta ra luana Gilead. ");
INSERT INTO ksd_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ma God i ga vana rikai pire Laban, a te Siria, ta ra ririvon ra marum, ma i ga biti tana: Una balaure ba koko una vatang ta pakana tinata pire Iakob, a boina ba ra kaina tinata. ");
INSERT INTO ksd_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ma Laban i ga tadav Iakob. Ma Iakob i ga page kana pal na mal ta ra ul a luana; ma Laban ma ra umana turana dia ga page kadia pal na mal ta ra luana Gilead bula. ");
INSERT INTO ksd_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ma Laban i ga biti tai Iakob; Ava u tar pait ia, tago u tar vana ivai pa kan iau, ma u tar agure vaire pa ra ura natugu, da dir a ura vavina di kinim dir ta ra vinarubu? ");
INSERT INTO ksd_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Ta ra ava u tar vana ivai pa, ma u tar tuam pa iau, ma pa u tar vaarike tagu, upi da ga vartulai ma ra gugu, ma ra kakailai, ma ra kudu, ma ra pagol; ");
INSERT INTO ksd_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ma pa u tar tul tar iau upi avet a vargalum ma ra umana natugu, a umana tutana ma ra umana vavina? U tar papait ra magit na papaua. ");
INSERT INTO ksd_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Pa i dekdek upi ina vakaina avat ma ra limagu; ia kaka ra God kai tamam i tar tata piragu ta ra marum, ma i biti: Una balaure ba koko una vatang ta pakana tinata pire Iakob, a boina ba ra kaina tinata. ");
INSERT INTO ksd_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ma go a dovotina, u tar vana tago u ga manga anan upi ra kuba i tamam, ia kaka upi ra ava u tar long kaugu umana god? ");
INSERT INTO ksd_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Ma Iakob i ga bali ia ma i ga biti dari tai Laban: Tago iau ga burut, ma iau ga biti: Kan na al vake ra ura natuna kan iau. ");
INSERT INTO ksd_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Nina ba una tikan tadav kaum umana god tana, koko na laun mulai; ta ra luaina mata i ra umana tura i dat una vakilang nina iau vatur vake ba kaum, una kap ia ka. Tago Iakob pa i ga nunure ba Rakel i ga tar long diat. ");
INSERT INTO ksd_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ma Laban i ga ruk ta ra pal na mal kai Iakob, ma ta ra pal na mal kai Lea, ma ta ra pal na mal kai ra ura tultul na vavina; ma pa i ga na tadav diat. Ma i ga irop mulai kan ra pal na mal kai Lea, ma i ga ruk ta ra pal na mal kai Rakel. ");
INSERT INTO ksd_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ma Rakel i ga tak pa ra umana tabataba, ma i ga vung diat ta ra kiki na kamel. ma i ga ki taun diat. Ma Laban i ga peng upi ia ta ra pal na mal parika, ma pa i ga peng pa ia. ");
INSERT INTO ksd_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ma i ga biti tai tamana: Luluai, koko u kankan, tago iau mama tut ta ra luaina matam; tago iau kakap ta ra gai. Ma i ga pepeng, ma pa i ga peng pa ra umana tabataba. ");
INSERT INTO ksd_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ma Iakob i ga kulot, ma i ga takun Laban; Iakob i ga tata bali ia ma i ga biti tai Laban: Iau tar rara ta ra ava, ma ava kaugu mangamangana kaina, tago u korot mur iau dari? ");
INSERT INTO ksd_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Go u tar pepeng ta kaugu tabarikik par, ma ava ra magit u tar na tadav ia ba kaum? Una vatur ia ati livuan ta ra umana turagu ma ra umana turam, upi diat a varkurai pire dor. ");
INSERT INTO ksd_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Go ra ura vinun na kilala iau tar ki piram; kaum umana sip ma kaum umana me pa dia ga kava vakaina ra natu i diat, ma pa iau ga en ra umana tomotoina ta kaum kikil na vavaguai. ");
INSERT INTO ksd_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Nina ba ra umana leing dia ga karat lavur ia, pa iau ga kap ia piram; i ga tukum piragu; u ga tir pa nina tagu ba di ga long ia ta ra marum ba ta ra keake. ");
INSERT INTO ksd_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","I ga dari piragu: ta ra bung na keake i ga tup iau ra malamalapang, ma ta ra marum a mudian; ma ra nidiop i ga paine kan ra kiau na matagu. ");
INSERT INTO ksd_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Go ra ura vinun na kilala iau tar ki ta ra kubam; iau tar kudar piram a vinun ma a ivat na kilala ure ra ura natum, ma laptikai na kilala ure kaum vavaguai; ma u tar vala pukpukue kaugu vapuak. ");
INSERT INTO ksd_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Gala ra God kai tamagu, a God kai Abaraam, ma nam Isak i ru ia, pa i ga ki piragu, gala u ga tul vakuku vue iau. God i tar gire ra magit i monong iau, ma ra papalum iau tar pait ia ma ra limagu, ma i tar bor bat u ta ra marum. ");
INSERT INTO ksd_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ma Laban i ga tata bali ia, ma i ga biti tai Iakob: A ura vavina a ura natugu, ma ra umana bul a umana natugu bula, ma ra lavur vavaguai kaugu umana vavaguai, ma ra lavur magit u gire, kaugu; ma ina pait ra ava gori ta dir, ra ura natugu, ma ra umana bul dir tar kava? ");
INSERT INTO ksd_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Boina dor a pait tika na kubunu; ma na tur da ra vakilang livuan ta dor. ");
INSERT INTO ksd_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ma Iakob i ga tak pa tika na vat, ma i ga vatur ia upi ra vat na vakilang. ");
INSERT INTO ksd_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ma Iakob i ga biti ta ra umana turana: Avat a varurue ra umana vat; ma dia ga varurue ra umana vat, ma dia ga vung guve diat; ma dia ga iaian pire ra anguvai vat. ");
INSERT INTO ksd_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Ma Laban i ga vaiang ia ba Iegar-Sakaduta, ma ga Iakob ia ga vaiang ia ba Galed. ");
INSERT INTO ksd_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Ma Laban i ga biti: Go ra anguvai vat ia ra vakilang livuan ta dor gori. Kari di vaiang ia ba Galed ");
INSERT INTO ksd_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ma Mispa, tago i ga biti: Ra Luluai na makmakile dor, ba dor a ki varbaiai. ");
INSERT INTO ksd_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ona u vakadik ra ura natugu, ma ari u ben pa ta umana vavina mulai maravut ra ura natugu, a dovotina, pa ta tutana i ki pire dor, God iat i varvai dovot ta dor. ");
INSERT INTO ksd_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ma Laban i ga biti tai Iakob: Gire go ra anguvai vat, ma una gire ra vat na vakilang, nina iau tar vatur ia livuan ta dor. ");
INSERT INTO ksd_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Go ra anguvai vat na da ra vakilang, ma ra pagapaga na vat na da ra vakilang, ba pa ina bolo lake go ra anguvai vat, upi ina tadav u, ma ba koko una bolo lake go ra anguvai vat ma go ra pagapaga na vat, upi una tadav iau ma ra vakikiu. ");
INSERT INTO ksd_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","A God kai Abaraam, ma ra God kai Nakor, a God kai tama i dir, na varkurai pire dor. Ma Iakob i ga vavalima tai nina Isak tamana i ga ru ia. ");
INSERT INTO ksd_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ma Iakob i ga pait ra tinabar ta ra ul a luana, ma i ga ting pa ra umana turana upi diat a en ra gem; ma dia ga en ra gem, ma dia ga ki ra marum par ta ra luana. ");
INSERT INTO ksd_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ma ta ra kavunvun Laban i ga tut, ma i ga galum ra umana natuna, a umana tutana ma ra umana vavina, ma i ga tata vadoane diat; ma Laban i ga tut ma i ga talil. ");
INSERT INTO ksd_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ma Iakob i ga vana ta kana nga, ma dia ga varkuvo ma ra umana angelo kai God. ");
INSERT INTO ksd_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ma ba i ga gire diat, Iakob i ga biti: A kor kai God go; ma i ga vaiang nam ra gunan ba Makanaim. ");
INSERT INTO ksd_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ma Iakob i ga tulue ra umana tultul pire turana Esau, dia ga lua tana, ta ra gunan Seir, ma ra langun Edom. ");
INSERT INTO ksd_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ma i ga vartuluai pire diat dari: Avat a ve kaugu luluai Esau dari: Kaum tultul Iakob i biti dari: Iau tar ki na vaira pire Laban, ma iau tar ki tuk ta ra bung gori. ");
INSERT INTO ksd_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ma kaugu a umana bulumakau, ma ra umana as, ma ra umana kikil na sip, ma ra umana tultul na tutana, ma ra umana tultul na vavina; ma iau tar tulue ra varvai ure tadav kaugu luluai, upi una mari iau. ");
INSERT INTO ksd_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ma ra umana tultul dia ga lilikun tadav Iakob, ma dia ga biti: Ave tar tadav turam Esau; ma go bula i totongo up u, dia varagur ma ra ivat na mar na tarai. ");
INSERT INTO ksd_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Io, Iakob i ga burut na kaia, ma i ga manga ngarangarao, ma i ga tibe ra tarai dia varagur me, ma ra umana kikil na sip, ma ra umana kikil na bulumakau, ma ra umana kamel, upi a ura loko. ");
INSERT INTO ksd_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ma i ga biti: Ari Esau i tadav tika na loko, nina i ubu valili ia na laun. ");
INSERT INTO ksd_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ma Iakob i ga biti: God kai tamagu Abaraam, ma God kai tamagu Isak, Luluai, u ga biti tagu: Una lilikun tadav kaum gunan ma tadav ra umana niurum,, ma ina pait ra boina tam: ");
INSERT INTO ksd_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","pa iau ko upi ina vatur vake nina i ikilik ta kaum lavur varmari, ma ra lavur dovotina u ga vaarike ta kaum tultul; tago ma go ko kaugu buka iau tar bolo lake me ta go ra Iordan; ma iau tar ura loko. ");
INSERT INTO ksd_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Boina una valaun iau kan ra lima i turagu Esau; tago iau burutue, kan na pot ma na ubu iau, ra vavina ma ra umana bul bula. ");
INSERT INTO ksd_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ma u ga biti: A dovotina, ina pait ra boina tam, ma ina vapeal ra umana bul mur tam da ra veo ra valian, nina pa da luk valar pa ia, tago dia peal mat. ");
INSERT INTO ksd_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ma i ga ki ie nam ra marum; ma i ga pilak pa ta umana magit ta nina i ga ki pirana, upi ra vartabar pire turana Esau; ");
INSERT INTO ksd_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","a ura mar na me, a tana, ma a ura vinun na tomotoina, a ura mar na sip, a tana, ma a ura vinun na tomotoina, ");
INSERT INTO ksd_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","a utul a vinun na kamel, i ung ra u i diat ma ra polo na u, ma ra natu i diat, a ivat na vinun na bulumakau, a tana, ma a vinun na tomotoina, a ura vinun na as, a tana, ma a vinun na tomotoina. ");
INSERT INTO ksd_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ma i ga tul tar diat ta ra lima i kana umana tultul, tikatikai kana ta kopono kikil; ma i ga biti ta kana umana tultul: Avat a bolo lake lua tagu, ma avat a vatur lalao ra umana kikil na vavaguai. ");
INSERT INTO ksd_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ma i ga vartuluai pire nina i ga lua ta diat dari: Ba turagu Esau i barat i u, ma na tir u: U kai to ia, ma u vana uve, ma kai ia go diat ta ra luaina matam? ");
INSERT INTO ksd_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Io, una biti tana dari: Kai kaum tultul Iakob; a vartabar nina di tulue pire kaugu luluai Esau; ma gire, ia iat i murmur ta vevet. ");
INSERT INTO ksd_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ma i ga vartuluai damana bula pire ra vauruana ma ra vautuluna, ma pire diat par dia murmur ra umana kikil na vavaguai, ma i ga biti: Avat a ve Esau damana ba ava tadav ia, ");
INSERT INTO ksd_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ma avat a biti: Tikai bula, gire, kaum tultul Iakob i murmur ta vevet. Tago i ga biti: Ina vamaram pa ia ma ra vartabar nina i lua tagu, ma namur ina gire ra matana ma kan na mari iau. ");
INSERT INTO ksd_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Damana ra vartabar i ga bolo lake lua tana; ma ia iat i ga ki pire ra tarai ta nam ra marum. ");
INSERT INTO ksd_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ma i ga tut ta nam ra marum, ma i ga agure kana ura taulai, ma kana ura tultul na vavina, ma kana vinun ma tika na bul, ma dia ga bolo ta ra tava Iabok. ");
INSERT INTO ksd_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ma i ga agure pa diat, ma i ga tulue diat, upi diat a bolo ra tava alir, ma kana tabarikik par bula i ga bolo. ");
INSERT INTO ksd_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ma Iakob i ga ki varkolono; ma tika na tutana dir ga varubu me tuk ta ra lar. ");
INSERT INTO ksd_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ma ba i ga gire ba pa i ga pait valar pa ia upi na uvia pa ia, i ga bili ra urat i ra varpakan i ra kelakelegina, ma ra varpakan i ra kelakeleg i Iakob i ga takari, ba dir ga varvarubu. ");
INSERT INTO ksd_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ma i ga biti tana: Una nur vue iau, tago i papait na lar. Ma i ga biti: Pata, pa ina nur vue u tuk tar ba una tata vadoane iau. ");
INSERT INTO ksd_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ma i ga tir ia: To ia ra iangim? Ma i ga biti: Iakob. ");
INSERT INTO ksd_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ma i ga biti: Koko da vatang mule ra iangim ba Iakob, da vatang ia ba Israel; tago u tar kudakudar ma God ma ra tarai bula, ma u tar uvia pa diat. ");
INSERT INTO ksd_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ma Iakob i ga tir ia ma i ga biti: Una vatang tar ra iangim tagu. Ma i ga biti: Ta ra ava u tir upi ra iangigu? Ma i ga tata vadoane abara. ");
INSERT INTO ksd_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ma Iakob i ga vaiang nam ra pakana pia ba Peniel, tago i ga biti: Amir tar varboboi ma God, ma ra tulungeagu i laun boko. ");
INSERT INTO ksd_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ma ra keake i ga vana rikai ba i ga bolo aro Peniel, ma i ga vana bukabukal ika ure ra kelakelegina. ");
INSERT INTO ksd_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Kari a tarai Israel pa dia en ra urat na vo na keke tuk ta ra bung gori, tago i ga bili ra urat i ra varpakan i ra kelakelegina. ");
INSERT INTO ksd_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Ma Iakob i ga idok ma i ga gigira, ma ea, Esau i ga vut, diat ma ra ivat na mar na tutana. Ma i ga tibe ra umana bul pire Lea ma Rakel, ma pire ra ura tultul na vavina. ");
INSERT INTO ksd_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ma i ga tulue ra ura tultul na vavina ma ra umana natu i dir upi diat a lua, ma Lea ma ra umana natuna namur, ma Rakel ma Iosep dir mur kakit. ");
INSERT INTO ksd_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ma ia iat i ga bolo lake lua ta diat, ma i ga va timtibum lavurua na pakana, tuk tar ba i ga maravai pire turana. ");
INSERT INTO ksd_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ma Esau i ga vutvut upi dir a varkuvo me, ma i ga tal pa ia, ma i ga galum ia; ma dir ga tangi. ");
INSERT INTO ksd_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ma i ga idok, ma i ga gire ra vaden ma ra umana bul; ma i ga biti: la diat go ava varagur ma diat? Ma i ga biti: A umana bul, nina God, ta kana varmari, i ga tabar kaum tultul me. ");
INSERT INTO ksd_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ma ra ura tultul na vavina dir ga vana maravai, diat ma ra umana natu i dir, ma dia ga va timtibum. ");
INSERT INTO ksd_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ma Lea bula ma ra umana natuna dia ga vana maravai, ma dia ga va timtibum; ma namur Iosep dir ma Rakel dir ga vana maravai, ma dir ga va timtibum. ");
INSERT INTO ksd_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ma i ga biti: Ava ra kukurai go ra kor ave varkuvo ma diat? Ma i ga biti: Upi ina gire tadav ra varmari pire kaugu luluai. ");
INSERT INTO ksd_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ma Esau i ga biti: Kaugu tabarikik i topa iau, turagu, una vatur uka nam ba kaum. ");
INSERT INTO ksd_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ma Iakob i ga biti: Pata, iau lul u ba ona u mari iau go, boina una alube vake kaugu vartabar ta ra limagu, tago iau tar gire ra matam, da tikai i gire ra mata i God, ma u ga gugu tagu. ");
INSERT INTO ksd_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Boina ba una alube vake kaugu vartabar di tar kap ia piram; tago God i ga pait ra varmari piragu, ma tago kaugu tabarikik i topa iau. Ma i ga vo pa ia, ma i ga alube pa ia. ");
INSERT INTO ksd_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ma Esau ga biti: Boina dor a tut ma dor a vana ma ina lua tam. ");
INSERT INTO ksd_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ma Iakob i ga biti tana: Kaugu luluai i nunure ba ra umana bul pa i dekdek ra paka i diat, ma ta umana vavaguai go kari piragu dia vau ra natu i diat, ma ba dia manga valit diat ta tika na bung, diat par diat a mat ika. ");
INSERT INTO ksd_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Boina ba kaugu luluai na bolo lake lua ta kana tultul, ma ina murmur vovovon ika, varogop ma ra dekdek i ra umana vavaguai ta ra luaina matagu, ma varogop ma ra dekdek i ra umana bul, tuk tar ba ina tadav kaugu luluai aro Seir. ");
INSERT INTO ksd_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ma Esau i ga biti: Boina ba ta umana ta kaugu tarai diat a ki piram. Ma i ga biti: Upi ra ava? Boina una mari ka iau. ");
INSERT INTO ksd_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Damana Esau i ga talil ta nam ra bung uro Seir. ");
INSERT INTO ksd_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ma Iakob i ga vana uro Sukot, ma i ga pait kana ta pal, ma i ga pait ra umana pal na turturup ure kana umana vavaguai; kari di vatang ra iang i ra gunan ba Sukot. ");
INSERT INTO ksd_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ma Iakob i ga tadav ra pia na pal Sekem, ta ra gunan Kanaan, ma pa ta magit i ga vakaina kana vinavana, ba i ga vana maro Padan-Aram, ma i ga ki boko ta ra luaina mata i ra pia na pal. ");
INSERT INTO ksd_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ma i ga kul nam ra pakana gunan i ga pala kana pal na mal tana, i ga kul ia ta ra tarai Kamor, tama i Sekem, ma tika na mar na pakana silva. ");
INSERT INTO ksd_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ma i ga pait ra uguugu abara, ma i ga vatang ia Eleloe-Israel. ");
INSERT INTO ksd_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ma Dina, natu i Lea, nina i ga kava tar ia tai Iakob, i ga vana pi na gire ra vaden ta nam ra gunan. ");
INSERT INTO ksd_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ma Sekem, natu i Kamor, a te Kivi, ma a luluai ta nam ra gunan, i ga gire; ma i ga vo pa ia. ma i ga va pirana, ma i ga vakaina. ");
INSERT INTO ksd_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ma i ga manga mainge Dina, natu i Iakob, ma i ga mari ia, ma i ga tata pa ia. ");
INSERT INTO ksd_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ma Sekem i ga biti tai tamana Kamor dari: Una kul nam ra vavina upi amir a taulai. ");
INSERT INTO ksd_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Io, Iakob i ga valongore ba i ga tar vakaina natuna Dina; ma kana umana bul tutana dia ga ki ra pupui pire ra umana vavaguai; ma Iakob pa i ga tata tuk ta ra bung ba dia pot. ");
INSERT INTO ksd_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ma Kamor, tama i Sekem, i ga vana pire Iakob upi dir a pirpir me. ");
INSERT INTO ksd_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ma ra umana natu i Iakob dia ga pot maro ra pupui ba dia valongore; ma go ra umana tutana i ga tabun ra bala i diat, ma i ga tup diat ra kankan, tago i ga pait ra magit i papaua pire Israel, ma i ga va pire natu i Iakob, tago pa i topa ia tuna upi da pait ra magit dari. ");
INSERT INTO ksd_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ma Kamor i ga pirpir ma diat, ma i ga biti: I kaina tuna ra bala i Sekem natugu upi natum a vavina; iau lul u, boina ba una tul tar ia tana, upi dir a taulai. ");
INSERT INTO ksd_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ma i boina ba avat a varbean pire vevet; avat a tul tar kavava umana bul vavina ta vevet, ma avet a ben kaveve umana bul vavina pire vavat. ");
INSERT INTO ksd_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ma avat a ki pire vevet, ma ra gunan na langalanga upi kavavat; avat a ki tana, ma avat a kukul, ma avat a kale pa ra umana pakana pia tana. ");
INSERT INTO ksd_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ma Sekem i ga biti tai tama i Dina ma ta ra umana taina dari: Boina avat a mari iau, ma a magit par ava Vatang upi ia, ina tul tar ia ta vavat. ");
INSERT INTO ksd_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Avat a vatang upi ra ngala na magit na varkukul, ba ta ngala na magit na tinabar, ma ina tul tar ia ta vavat, varogop ma kavava tinata; ia kaka i boina ba avat a tul tar ra vavina tagu, upi amir a taulai. ");
INSERT INTO ksd_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ma ra umana natu i Iakob dia ga tata bali Sekem ma tamana Kamor, dia ga tuam pa dir, tago i ga vakaina tai diat Dina, ma dia ga biti: ");
INSERT INTO ksd_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","I dekdek upi avet a pait go ra magit, ma upi avet a tul tar ra tai vevet tai ta tikai ba pa i pokakikil, a magit na vavirvir pire vevet; ");
INSERT INTO ksd_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ma ure go ra magit avet a mulaot i tana: ba dat a varogop dari, ba ra lavur tutana pire vavat diat a pokakikil, ");
INSERT INTO ksd_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","io, avet a tul tar kaveve umana bul vavina ta vavat, ma avet a ben pa kavava umana bul vavina, ma avet a ki pire vavat, ma dat a kopono tarai ka. ");
INSERT INTO ksd_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ma ona pa ava torom ta vevet, upi avat a pokakikil, avet a vatur kaveve bul vavina, ma avet a ga vana. ");
INSERT INTO ksd_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ma Kamor ma Sekem natuna dir ga manane kadia tinata. ");
INSERT INTO ksd_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ma ra barmana i ga mulaot upi na pait nam ra magit, tago i ga manga gugu tai natu i Iakob; ma dia ga manga ru ia ta diat par ta ra kuba i tamana. ");
INSERT INTO ksd_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ma Kamor ma natuna Sekem dir ga tadav ra mataniolo ta kadir pia na pal, ma dia ga pirpir ma ra tarai ta kadir pia na pal, dir ga biti dari: ");
INSERT INTO ksd_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Go ra tarai dia ki pire dat ma ra bo na nuknuk i diat; kari i boina ba da tul tar diat upi diat a ki ta ra gunan, ma diat a kukukul, tago ra gunan i ngala, ma i topa diat; dat a taulai ma kadia umana bul vavina, ma dat a tul tar kada umana bul vavina ta diat. ");
INSERT INTO ksd_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ma ure go ra magit ika diat a mulaot i tana,, upi diat a ki pire dat, upi dat a kopono tarai: ba ra lavur tutana pire dat diat a pokakikil, da dia tar pokakikil. ");
INSERT INTO ksd_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Dat a vatur vake kadia lavur vavaguai ma kadia tabarikik; boina dat a mulaot ika ta diat, ma diat a ki maravut dat. ");
INSERT INTO ksd_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ma diat par dia ga irairop ta ra mataniolo kai ra pia na pal, dia ga torom tai Kamor ma tai Sekem natuna; ma dia ga poko kikil ra umana tutana par, diat par dia ga irairop ta ra mataniolo kai kadir pia na pal. ");
INSERT INTO ksd_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ma ta ra vautuluna bung, ba i ga makmaki, a ura natu i Iakob, Simeon ma Levi, a ura tai Dina, dir ga kap ra pakat na vinarubu ma dir ga vut vakaian ta ra pia na pal, ma dir ga ubu doko ra tarai par. ");
INSERT INTO ksd_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Dir ga ubu Kamor ma Sekem natuna ma ra mangmangi na pakat, ma dir ga agure vairop Dina ta ra kuba i Sekem, ma dital ga vana. ");
INSERT INTO ksd_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","A umana natu i Iakob dia ga tadav ra umana virua, ma dia ga varane ra tabarikik ta ra pia na pal, tago dia ga tar vabilak tai diat. ");
INSERT INTO ksd_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Dia ga ra pa kadia kikil na sip, ma kadia kikil na bulumakau, ma kadia as, a lavur magit ta ra pia na pal, ma ra lavur magit ta ra gunan; ");
INSERT INTO ksd_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","dia ga ra pa kadia tabarikik par, ma dia ga kap vavilavilau ra umana natu i diat, ma kadia umana vavina, maia pa, a lavur magit ara na pal. ");
INSERT INTO ksd_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ma Iakob i ga biti tai Simeon ma Levi: Amur tar vakadik iau, tago a tarai ta go ra gunan, a umana te Kanaan ma ra umana te Peres, diat a milikuane iau; ma tago dat a paupau ka, diat a vana varurung, ona diat a tut ure iau, ma diat a ubu iau; ma ina virua, avet ma diat ta ra kubagu. ");
INSERT INTO ksd_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ma dir ga biti: Dave vang, tai mimir i da ra paiga na vavina pirana? ");
INSERT INTO ksd_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ma God i ga biti tai Iakob: Una tut, ma una vana urama Betel, ma una ki ie; ma una pait ra uguugu abara upi kai God, nina i tur kapet pa piram ba u ga takap kan ra mata i turam Esau. ");
INSERT INTO ksd_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ma Iakob i ga biti ta diat ta ra kubana ma ta diat par dia ga ki pirana: Avat a vung vue ta umana tabataba kan avat, ma avat a vagomgom avat, ma avat a kia vue kavava mal; ");
INSERT INTO ksd_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","dat a tut, ma dat a vana urama Betel; ma ina pait tika na uguugu abara ure God, nina i ga torom tagu ta ra bung iau ga ki kaina tana, ma amir ga varagur me ta ra nga iau ga vana tana. ");
INSERT INTO ksd_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ma dia ga tul tar ra lavur tabataba par dia vatur vake, ma ra magit na marmar ta ra talinga i diat; ma Iakob i ga ive diat ta ra vavai na iban, maravai Sekem. ");
INSERT INTO ksd_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ma dia ga vana; ma a ngala na bunurut i ga monong ra umana pia na pal dia tur kikil diat, ma pa dia ga korot mur ra umana natu i Iakob. ");
INSERT INTO ksd_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Damana Iakob i ga pot aro Lus, ta ra gunan Kanaan, (Betel nam), diat ma ra tarai par pirana. ");
INSERT INTO ksd_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ma i ga pait ra uguugu abara, ma i ga vatang nam ra pakana gunan ba El-Betel; tago God i ga vaarike mule pirana abara, ba i ga vilau kan ra mata i turana. ");
INSERT INTO ksd_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ma Debora, a tultul na vavina kai Rebeka, i ga mat, ma di ga punang ia maravai Betel, ta ra vavai na iban; ma dia ga vatang ra iangina ba Alon-Bakut. ");
INSERT INTO ksd_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ma God i ga tur kapet pa mulai pire Iakob ba i ga vana maro Padan-Aram, ma i ga tata vadoane. ");
INSERT INTO ksd_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ma God i ga biti tana: A iangim Iakob; ma pa da vatang u mulai ba Iakob, da vatang ra iangim ba Israel. ");
INSERT INTO ksd_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ma God i ga biti tana: Iau God Dekdek Muka; una vangala mangoro na natum, ma avat a pepeal; tika na vuna gunan ma ra ngala na kor na tarai diat a vuna tam, ma ra umana king diat a vana rikai ta ra livuam, ");
INSERT INTO ksd_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ma ra gunan nina iau ga tabar Abaraam ma Isak me, ina tul tar ia tam, ma tai ra umana bul mur tam. ");
INSERT INTO ksd_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ma God i ga tutua urama kan ia ta nam ra gunan dir ga tata me. ");
INSERT INTO ksd_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ma Iakob i ga vatur tika na vakilang ta nam ra gunan dir ga pirpir tana, a pagapaga na vat, ma i ga lolonge ra tinabar na nimomo tana, ma ra dangi bula. ");
INSERT INTO ksd_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ma Iakob i ga vatang ra iang i ra gunan, nina dir ga tata ma God tana, ba Betel. ");
INSERT INTO ksd_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ma dia ga tut ma dia ga vana, ma a ik a vinavana boko upi diat a pot aro Eprata, ma Rakel i ga kakava, ma i ga tup ia kana kinadik. ");
INSERT INTO ksd_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ma ba i ga manga kadik, a vavina i varkakava i ga biti tana: Koko una burut, tago go natum a bul tutana mulai. ");
INSERT INTO ksd_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ma ba ra tulungeana i ga vana, tago i ga to na mat, i ga vatang ra iangina ba Benoni; ma ga tamana i ga vaiang tar a iangina ba Beniamin. ");
INSERT INTO ksd_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ma Rakel i ga mat, ma dia ga punang ia ta ra papar a nga uro Eprata, nina ba Beteleem. ");
INSERT INTO ksd_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ma Iakob i ga vatur tika na vat ta kana tung na minat; ia nam ra vakilang na vat ta ra tung na minat kai Rakel tuk ta ra bung gori. ");
INSERT INTO ksd_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ma Israel i ga vana, ma i ga page kana pal na mal ura iat Eder, a pal na minakila. ");
INSERT INTO ksd_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ma ba Israel i ga ki ta nam ra gunan, Ruben i ga vana ma i ga va pire Bila, a vavina kai tamana; ma Israel i ga valongore. Ma ra umana bul tutana kai Iakob i ga a vinun ma a urua; ");
INSERT INTO ksd_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","a umana natu i Lea go diat: Ruben, a luaina bul kai Iakob, ma Simeon, ma Levi, ma Iuda, ma Isakar, ma Sebulun; ");
INSERT INTO ksd_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","a ura natu i Rakel: Iosep ma Beniamin; ");
INSERT INTO ksd_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","ma ra ura natu i Bila, a tultul na vavina kai Rakel: Dan ma Naptali; ");
INSERT INTO ksd_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","ma ra ura natu i Silpa, a tultul na vavina kai Lea: Gad ma Aser; go diat ra umana natu i Iakob nina di ga kava tar diat aro Padan-Aram. ");
INSERT INTO ksd_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ma Iakob i ga tadav Isak tamana aro Mamre, aro Kiriat-Arba nina ba Kebron; Abaraam ma Isak dir ga ki na vaira tana. ");
INSERT INTO ksd_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ma Isak i ga laun vue tika na mar ma lavutul na vinun ot na kilala. ");
INSERT INTO ksd_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Ma Isak i ga vung vue ra tulungeana, ma i ga mat, ma i ga ki rangup ma kana tarai; i ga ngeo, ma i ga laun vao. Ma Esau ma Iakob, a ura natuna, dir ga punang ia. ");
INSERT INTO ksd_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ma go ra vuna tarai kai Esau, nina di ga vatang ia bula ba Edom: ");
INSERT INTO ksd_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau dia ga taulai ma ra umana vavina ta ra vaden Kanaan: Ada natu i Elon ra te Ket, ma Olibama natu i Ana natu i Sibeon ra te Kivi, ");
INSERT INTO ksd_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ma Basemat natu i Ismael, dir taina ma Nebaiot. ");
INSERT INTO ksd_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ma Ada i ga kava tar Elipas tai Esau, ma Basemat i ga kava Reuel; ");
INSERT INTO ksd_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ma Olibama i ga kava Ieus, ma Ialam, ma Kora; go diat ra umana natu i Esau, di ga kava diat ta ra gunan Kanaan. ");
INSERT INTO ksd_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ma Esau diat ma kana umana vavina, ma ra umana natuna, a umana tutana ma ra umana vavina, ma diat par ta ra kubana, ma kana lavur vavaguai, ma kana lavur tabarikik, nina i ga vung guve ta ra gunan Kanaan, dia ga vana ta ra enana gunan, upi dir a ki varbaiai ma turana Iakob. ");
INSERT INTO ksd_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Tago kadir lavur vavaguai i ga manga ngala, ma i ga dekdek upi dir a ki varurung mulai; ma pa i ga tale mule nam ra gunan dir ga ki na vaira tana, tago i ga mangoro kadir vavaguai. ");
INSERT INTO ksd_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ma Esau i ga ki ta ra lualuana Seir; Esau ia nam Edom. ");
INSERT INTO ksd_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ma go diat a lavur vuna tarai kai Esau, tama i ra tarai Edom, ta ra lualuana Seir. ");
INSERT INTO ksd_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Go ra iang i diat ra umana natu i Esau: Elipas, natu i Ada a taulai kai Esau; Reuel, natu i Basemat a taulai kai Esau. ");
INSERT INTO ksd_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ma ra umana natu i Elipas go: Teman, Omar, Sepo, Gatam ma Kenas. ");
INSERT INTO ksd_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ma Timna, tika na vavina kai Elipas natu i Esau; ma i ga kava Amalek tai Elipas; go diat ra umana natu i Ada, a taulai kai Esau. ");
INSERT INTO ksd_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ma go diat a umana natu i Reuel: Nakat, Sera, Sama ma Misa; go ra umana natu i Basemat, a vavina kai Esau. ");
INSERT INTO ksd_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ma go diat a umana natu i Olibama natu i Ana natu i Sibeon, a taulai kai Esau, i ga kava tar diat tai Esau: Ieus, ma Ialam ma Kora. ");
INSERT INTO ksd_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Go diat ra umana luluai ta ra umana natu i Elipas nina ra luaina bul kai Esau: a luluai Teman, a luluai Omar, a luluai Sepo, a luluai Kenas, ");
INSERT INTO ksd_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","a luluai Kora, a luluai Gatam, a luluai Amalek; go diat ra umana luluai dia vana rikai tai Elipas ta ra gunan Edom; go diat ra umana natu i Ada. ");
INSERT INTO ksd_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ma go diat ra umana natu i Reuel natu i Esau: a luluai Nakat, a luluai Sera, a luluai Sama, a luluai Misa; go diat ra umana luluai dia ga vana rikai tai Reuel ta ra gunan Edom; go diat ra umana natu i Basemat a vavina kai Esau. ");
INSERT INTO ksd_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ma go diat ra umana natu i Olibama, a taulai kai Esau: a luluai Ieus, a luluai Ialam, a luluai Kora; go diat ra umana luluai dia ga vana rikai tai Olibama natu i Ana, a taulai kai Esau. ");
INSERT INTO ksd_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Go ra lavur natu i Esau nina ba Edom, ma kadia lavur luluai. ");
INSERT INTO ksd_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Go diat ra umana natu i Seir, a te Kori, a tarai ta nam ra gunan: Lotan, ma Sobal, ma Sibeon, ma Ana, ");
INSERT INTO ksd_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ma Dison, ma Eser, ma Disan; go diat ra umana luluai dia ga vana rikai tai ra umana te Kori, a umana natu i Seir, ta ra gunan Edom. ");
INSERT INTO ksd_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ma ra umana natu i Lotan: Kori ma Keman; ma Lotan dir taina ma Timna. ");
INSERT INTO ksd_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ma go ra umana natu i Sobal: Alvan, ma Manakat, ma Ebal, Sepo ma Onam. ");
INSERT INTO ksd_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ma go ra ura natu i Sibeon: Aia ma Ana; nina ra Ana ba i ga tadav ra mata na tava i malamalapang ara ra pupui, ba i ga tabatabar ra umana as kai tamana Sibeon. ");
INSERT INTO ksd_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ma go ra ura natu i Ana: Dison ma Olibama, natu i Ana. ");
INSERT INTO ksd_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ma go ra umana natu i Dison: Kemdan, ma Esban, ma Itran, ma Keran. ");
INSERT INTO ksd_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ma go ra utul a natu i Eser: Bilan, ma Savan, ma Akan. ");
INSERT INTO ksd_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Go ra ura natu i Disan: Us ma Aran. ");
INSERT INTO ksd_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Go ra umana luluai kai ra umana te Kori: a luluai Lotan, a luluai Sobal, a luluai Sibeon, a luluai Ana, ");
INSERT INTO ksd_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","a luluai Dison, a luluai Eser, a luluai Disan; go diat ra umana luluai kai ra umana Kori, varogop ma kadia kini ta ra gunan Seir. ");
INSERT INTO ksd_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ma go diat a umana king nina dia ga varkurai ta ra gunan Edom, ma pata boko ra king i ga kure ra tarai Israel: ");
INSERT INTO ksd_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela natu i Beor i ga varkurai aro Edom; ma ra iang i kana pia na pal Dinaba. ");
INSERT INTO ksd_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ma Bela i ga mat, ma Iobab natu i Sera maro Bosra i ga kia vue. ");
INSERT INTO ksd_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Ma Iobab i ga mat, ma Kusam maro ra gunan kai ra tarai Teman i ga kia vue. ");
INSERT INTO ksd_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ma Kusam i ga mat, ma Kadad natu i Bedad i ga kia vue, nina i ga kita Midian ta ra gunan kai Moab; a iang i kana pia na pal ba Avit. ");
INSERT INTO ksd_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Ma Kadad i ga mat, ma Samla maro Masreka i ga kia vue. ");
INSERT INTO ksd_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Ma Samla i ga mat, ma Saul maro Rekobot pire ra tava alir i ga kia vue. ");
INSERT INTO ksd_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ma Saul i ga mat, ma Baal-Kanan natu i Akbor i ga kia vue. ");
INSERT INTO ksd_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ma Baal-Kanan natu i Akbor i ga mat, ma Kadar i ga kia vue; ma ra iang i kana pia na pal Pau; ma ra iang i kana taulai Metabel natu i Matred natu i Mesakab. ");
INSERT INTO ksd_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ma go ra iang i ra umana luluai tai Esau, kadia vuna tarai, ma kadia gunan, ma ra iang i diat: a luluai Timna, a luluai Alva, a luluai Ietet; ");
INSERT INTO ksd_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","a luluai Olibama, a luluai Ela, a luluai Pinon; ");
INSERT INTO ksd_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","a luluai Kenas, a luluai Teman, a luluai Mibsar; ");
INSERT INTO ksd_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","a luluai Magdiel, a luluai Iram; go ra umana luluai Edom, da kadia kiki ta ra gunan kadiat. Ma go Esau tama i ra tarai Edom. ");
INSERT INTO ksd_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ma Iakob i ga ki ta ra gunan ba tamana i ga ki na vaira tana, ta ra gunan Kanaan. ");
INSERT INTO ksd_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ma go ra umana magit dia ga vana rikai ta ra kuba i Iakob: Iosep, ba i ga a vinun ma lavurua na kilala, diat ma ra umana turana dia ga tabatabar ra umana vavaguai; ma ba i ga bul boko, i ga ki varurung ma ra umana natu i Bila ma Silpa, a ura vavina kai tamana; ma Iosep i ga kap ra umana kaina tinata ure diat pire tamana. ");
INSERT INTO ksd_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ma Israel i ga manga mari Iosep, ma ta ra umana natuna par i ga mari diat a ikilik, tago ia ra bul i ga vangala ba i ga patuana, ma i ga mal tar tika na lolovina kolot. ");
INSERT INTO ksd_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ma ra umana turana dia ga gire ba tama i diat i ga manga mari Iosep, ma diat par ra umana turana i ga mari diat a ikilik ika; ma dia ga milikuane, ma pa dia ga tata pa ia mulai. ");
INSERT INTO ksd_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ma Iosep i ga ririvon, ma i ga ve ra umana turana ta kana ririvon; ma dia ga milikuane mule. ");
INSERT INTO ksd_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ma i ga biti ta diat: Boina, avat a valongore ra ririvon nina iau ririvone: ");
INSERT INTO ksd_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","gire, da vi ra umana vinvin vit ta ra uma, ma kaugu vinvin i tut, ma i tur uka, ma kavava umana vinvin dia tur kikil, ma dia va timtibum pire kaugu vinvin. ");
INSERT INTO ksd_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ma ra umana turana dia ga biti tana: Dave, kan una kure avet boko? Ba kan una luluai boko pire vevet? Ma i ga ngala mulai kadia milmilikuan tadav ia, ta go kana ririvon ma kana tinata bula. ");
INSERT INTO ksd_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ma i ga ririvone ta ra ririvon bula, ma i ga ve ra umana turana tana, ma i ga biti: Gire, iau tar ririvone ta tika na ririvon, ma i dari: a keake ma ra gai ma ra vinun ma tika na tagul dia va timtibum tadav iau. ");
INSERT INTO ksd_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ma i ga ve tamana ma ra umana turana tana; ma tamana i ga pit ia, ma i ga biti: Ava go ra ririvon u tar ririvone? A dovotina bar, ba amir ma nam ma ra umana turam, avet a tadav u boko pi avet a va timtibum piram? ");
INSERT INTO ksd_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ma ra umana turana dia ga pin ia; ia kaka tamana i ga kodop vake go ra tinata. ");
INSERT INTO ksd_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ma ra umana turana dia ga vana upi diat a tabatabar ra kikil na sip kai tama i diat aro Sekem. ");
INSERT INTO ksd_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ma Israel i ga biti tai Iosep: A umana turam dia tabatabar ra umana sip aro Sekem; una mai, ina tulue u tadav diat. Ma i ga biti tana: Iau go kari. ");
INSERT INTO ksd_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ma i ga biti tana: Boina, una vana, ma una gire ra umana turam ma ra kikil na sip ba dia dave, ma una vakapa iau. Damana i ga tulue Iosep kan ra male Kebron, ma i ga vana uro Sekem. ");
INSERT INTO ksd_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ma dir ga varkuvo ma tika na tutana, ba i ga vanavana vurvurbit ta ra pupui; ma ra tutana i ga tir ia: U nuk upi ra ava? ");
INSERT INTO ksd_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ma i ga biti: Iau tikatikan upi ra umana turagu; boina una vakapa iau ta ra gunan dia balabalaure ra kikil na sip tana. ");
INSERT INTO ksd_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ma ra tutana i ga biti: Dia tar vana kariu; tago iau tar valongore dia biti, Boina dat a vana uro Dotan. Ma Iosep i ga mur ra umana turana ma i ga tadav diat aro Dotan. ");
INSERT INTO ksd_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ma ba i ga vailik boko dia ga gire, ma ba pa i ga maravai boko dia ga varpit ure, upi diat a ub ia. ");
INSERT INTO ksd_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ma dia ga biti vargil: Gire, ra tena ririvon i pot. ");
INSERT INTO ksd_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Io, dat a ub ia, ma dat a vue vaba ia tai tika na tung, ma dat a varvai ka dari ba, A kaina leing i tar en pa ia; ma dat a gire ba i dave kana ririvon. ");
INSERT INTO ksd_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ma Ruben i ga valongore, ma i ga valaun pa ia kan ra lima i diat, tago i ga biti: Koko dat a doka. ");
INSERT INTO ksd_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ma Ruben i ga biti bula ta diat: Koko avat a lingire ra gap; avat a vue vaba ia ka ta go ra tung ta ra pupui, ma koko avat a bili vakaina. I ga mainge ba na valaun ia kan ra lima i diat, upi na vamule tai tamana. ");
INSERT INTO ksd_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ma ba Iosep i ga tadav ra umana turana, dia ga pala vue kana kolot kan ia, nam ra lolovina, ba i ga mal me. ");
INSERT INTO ksd_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ma dia ga vatur ia, ma dia ga vue vaba ia ta ra tung; ma ra tung i ga mama ka, pa ta tava tana. ");
INSERT INTO ksd_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ma dia ga ki, upi diat a ian; ma dia ga idok, ma dia ga gigira vurvurbit; ma ra umana tena kunukul ta ra vuna tarai Ismael dia ga vana ba marama Gilead; ma kadia kamel dia ga kapkal a utul a mangana bulit na davai, ma dia ga vana me uro Aigipto. ");
INSERT INTO ksd_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ma Iuda i ga biti ta ra umana turana: Na topa ra ava, ona dat a ubu doko tura i dat, ma ba dat a ive ra gapuna? ");
INSERT INTO ksd_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Avat a mai, dat a ivure ta ra tarai Ismael, ma koko dat a bili vakaina; tago tura i dat, ma i kopono ko ra paka i dat. Ma ra umana turana dia ga mulaot i tana. ");
INSERT INTO ksd_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ma ta umana tarai Midian dia ga bolo, a umana tena kunukul; ma dia ga al vairop Iosep ta ra tung, ma dia ga ivure Iosep ta ra tarai Ismael ure ra ura vinun na pakana silva. Ma dia ga agur pa Iosep uro Aigipto. ");
INSERT INTO ksd_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ma Ruben i ga lilikun tadav ra tung; ma gire, Iosep pa i ga bang mulai ta ra tung, ma i ga rada kana mal. ");
INSERT INTO ksd_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ma i ga tadav ra umana turana, ma i ga biti: A bul i tar panie; ma iau, ina vana uve? ");
INSERT INTO ksd_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ma dia ga takan pa ra kolot kai Iosep, ma dia ga doko ra me, ma dia ga puk ra kolot ma ra gapuna; ");
INSERT INTO ksd_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ma dia ga tulue ra kolot, a lolovina, pire tama i diat, ma dia ga biti: Ave tar tikan tadav go, una gire ba ra kolot kai natum ba pata. ");
INSERT INTO ksd_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ma i ga gire ilam ia, ma i ga biti: A kolot kai natugu; a kaina leing i tar en ia, a dovotina i tar kadakadal varbaiane Iosep. ");
INSERT INTO ksd_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ma Iakob i ga rada kana mal, ma i ga ule tar ra mal na tabun ta ra livuana, ma mangoro na bung i ga korkor ure. ");
INSERT INTO ksd_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ma ra umana natuna, a umana tutana ma ra umana vavina par, dia ga tut ma dia ga vamaram ia; ma pata, i ga ole ke upi na maram, ma i ga biti: Pa ina ngo ma ra tinabun tuk tar ta ra bung ba ina vana ur ta ra ruarua na tulungen tadav natugu. Ma tamana i ga tangie. ");
INSERT INTO ksd_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ma aro Aigipto ra tarai Midian dia ga ivure tar ia tai Potipar, a tultul kai Parao, ma a luluai kai ra tarai na monamono. ");
INSERT INTO ksd_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ma ta nam ra e Iuda i ga vana kan ra umana turana, ma i ga ruk pire tika na tutana Adulam, a iangina Kira. ");
INSERT INTO ksd_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ma Iuda i ga gire ra vavina ie, natu i tika na tutana Kanaan, a iangina Sua; ma i ga ben ia, ma i ga ruk pirana. ");
INSERT INTO ksd_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ma i ga lalau pa, ma i ga kava tika na bul tutana, ma i ga vaiang tar ra iangina ba Er. ");
INSERT INTO ksd_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ma i ga lalau pa mulai, ma i ga kava tika na bul tutana, ma i ga vaiang tar ra iangina ba Onan. ");
INSERT INTO ksd_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ma i ga kava ta ra bul tutana mulai, ma i ga vaiang tar ra iangina ba Sela; ma i ga ki aro Kesib, ba i ga kava. ");
INSERT INTO ksd_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ma Iuda i ga tul tar tika na vavina tai Er, kana luaina bul, ma a iangina Tamar. ");
INSERT INTO ksd_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ma Er, a luaina bul kai Iuda, i ga kaina ta ra mata i ra Luluai, ma ra Luluai i ga ubu doka. ");
INSERT INTO ksd_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ma Iuda i ga biti tai Onan: Una ruk tadav ra taulai kai turam ma amur a taulai me, da i topa ra tura i kana tutana, upi una vangala ra umana bul mur kai turam. ");
INSERT INTO ksd_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ma Onan i ga nunure ba vakir kana iat nam ra bul mur; io, ba i ga ruk pire ra taulai kai turana, i ga vabura vue ra pia, kan na vangala ta bul mur tai turana. ");
INSERT INTO ksd_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ma nam ra magit i ga pait ia, i ga kaina ta ra mata i ra Luluai, ma i ga virua bula. ");
INSERT INTO ksd_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ma Iuda i ga biti tai Tamar kakuna: Una ki ka boko a ua na vavina ta ra kuba i tamam, tuk ta ra bung ba Sela natugu i tar ngala; tago i ga biti: Kan na mat bula da ra ura turana. Ma Tamar i ga vana, ma i ga ki ta ra kuba i tamana. ");
INSERT INTO ksd_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ma tuka boko natu i Sua, a taulai kai Iuda, i ga mat; ma Iuda i ga maram mulai, ma i ga vana oai tadav kana umana kutkut ivuna sip aro Timna, dir ma talaina Kira, a tutana Adulam. ");
INSERT INTO ksd_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ma di ga ve Tamar dari: Gire, kakum i vana urama Timna pi na kukut kana umana sip. ");
INSERT INTO ksd_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ma i ga vung vue kana mal na ua na vavina kan ia, ma i ga vung ra mal na turturup, ma i ga pulu ia mulai, ma i ga ki ta ra mataniolo aro Enaim, ta ra nga uro Timna; tago i ga gire ba Sela i ga tar ngala, ma pa di ga tul tar ia tana upi dir a taulai me. ");
INSERT INTO ksd_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ma ba Iuda i ga gire, i ga nuk ia ba a paiga na vavina, tago i ga tar turup ra matana. ");
INSERT INTO ksd_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ma i ga vana pirana ta ra papar a nga, ma i ga biti tana: Ina ruk boko piram; tago pa i ga nunure ba kakuna. Ma ra vavina i ga biti: Ava una tar ia tagu, ba ina tul tar ia tam upi una ruk piragu? ");
INSERT INTO ksd_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ma i ga biti: Ina tulue tika na nat na me piram. Ma i ga biti: Dave, una tul tar ta vuvung varirap tagu, tuk ta nam ra bung ba una tulue? ");
INSERT INTO ksd_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ma i ga biti: A vuvung varirap ava ina tul tar ia tam? Ma i ga biti: Kaum domol, ma kaum vinau, ma kaum buka, nina ta ra limam. Ma i ga tul tar ia tana, ma i ga ruk pirana, ma i ga lalau pa ra bul tana. ");
INSERT INTO ksd_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ma i ga tut, ma i ga vana kariu, ma i ga vung vue kana mal na turturup, ma i ga ule tar mule kana mal na ua na vavina. ");
INSERT INTO ksd_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ma Iuda i ga tulue ra nat na me ta ra lima i talaina, a tutana Adulam, upi na vung ur pa ra vuvung varirap ta ra lima i ra vavina; ma pa i ga gire tadav ia. ");
INSERT INTO ksd_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Io, i ga tir ra tarai ta nam ra gunan dari: Akave ra igoro na vavina, nina i ki ati Enaim ta ra papar a nga? Ma dia ga biti: Pa ta paiga na vavina i ki ati. ");
INSERT INTO ksd_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ma i ga lilikun tadav Iuda, ma i ga biti: Pa iau gire tadav ia; ma ra tarai ta nam ra gunan bula dia biti, Pa ta paiga na vavina i ki ati. ");
INSERT INTO ksd_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ma Iuda i ga biti: Boina ba na vatur vake ra vuvung varirap kan dat a vavirvir tana; gire, iau tar tulue go ra nat na me, ma u mama tikan upi ia. ");
INSERT INTO ksd_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ma ba a utul a gai bar i ga taun ia, di ga ve Iuda dari: Tamar kakum i ga pait ra kaina, ma go i tanan ta kana mangamangana kuabar. Ma Iuda i ga biti: Avat a agure vairop ia, ma da tun vue. ");
INSERT INTO ksd_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ma ba dia ga agure vairop ia, i ga tulue ra tinata pire kakuna dari: Iau kap bala tai nina ra tutana ba kana go ra magit. Ma i ga biti: Una ilam go ba kai ia, ra domol, ra vinau, ma ra buka. ");
INSERT INTO ksd_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ma Iuda i ga gire ilam ia, ma i ga biti: Ia iat i takodo ta mimir, tago pa iau ga tul tar ia tai Sela natugu. Ma pa i ga la mulai pirana. ");
INSERT INTO ksd_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ma ba i ga kakava, gire a kanga ta kana tatal na bul. ");
INSERT INTO ksd_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ma ba i ga kakava, tikai ta dir i ga tulue ra limana lua, ma ra vavina i varkakava i ga tak pa ra kuara, a meme, ma i ga kun tar ia ta ra limana, ma i ga biti: Go i tar lua. ");
INSERT INTO ksd_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ma ba i ga valilikun mule ra limana, turana i ga vana rikai; ma i ga biti: U rada dave? Kari di ga vatang ra iangina ba Peres. ");
INSERT INTO ksd_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ma namur turana i ga vana rikai, nina ba a meme na kuara ta ra limana, ma di ga vaiang tar ra iangina ba Sera. ");
INSERT INTO ksd_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ma dia ga kap Iosep uro Aigipto; ma Potipar, a tultul kai Parao, a luluai kai ra tarai na monamono, a te Aigipto, i ga kul ia tai ra tarai Ismael, nina dia ga kap ia ura. ");
INSERT INTO ksd_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ma ra Luluai i ga maravut Iosep, ma i ga kedek ta kana papalum, ma i ga ki ta ra kuba i kana luluai, a te Aigipto. ");
INSERT INTO ksd_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ma kana luluai i ga gire ba ra Luluai i ga ki pirana, ma ba ra Luluai i ga vatavua ra lavur magit i ga bili ia ma ra limana. ");
INSERT INTO ksd_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Ma ra luluai i ga mari Iosep, ma i ga tul tar ia tana upi na kudakudar tana; ma i ga vaki ia upi na tena varbalaurai ta ra kubana, ma i ga nur tar kana lavur tabarikik par ta ra limana. ");
INSERT INTO ksd_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ma papa nam ra bung ba i ga vaki ia upi na tena varbalaurai ta ra kubana, ma i ga nur tar kana lavur tabarikik tana, a Luluai i ga vadoane ra kuba i ra te Aigipto ure Iosep; ma ra varvadoan kai ra Luluai i ga ki ta kana lavur magit, ta ra kubana ma ta ra uma bula. ");
INSERT INTO ksd_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ma i ga nur tar kana lavur tabarikik ta ra lima i Iosep, ma pa i ga nuk pa ta magit mulai, ia kaka ra magit na nian i ga en ia. Ma Iosep a potar na tutana, ma i ga vakak ra pakana. ");
INSERT INTO ksd_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ma ba i ga par go ra lavur magit, a taulai kai kana luluai i ga manane Iosep; ma i ga biti tana: Una va piragu. ");
INSERT INTO ksd_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ma i ga ole ke, ma i ga biti tai ra taulai kai kana luluai dari: Gire, kaugu luluai pa i balaguan mulai ure ta magit ta ra pal, i ga nur tar ra lavur magit ta ra limagu; ");
INSERT INTO ksd_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","pa ta i lia ta mimir ta go ra pal, ma pa i ga tigal bat iau tai ta magit, ia kaka tam, tago u kana taulai; ina pait davatane go ra bilak na mangamangana, ma ina pait davatane ra varpiam tadav God? ");
INSERT INTO ksd_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ma a dovotina, i ga tingting pa Iosep a bungbung par, ma pa i ga torom tana upi na va pirana, ba upi na ki pirana. ");
INSERT INTO ksd_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ma ta tika na bung i ga ruk ta ra pal, upi na pait kana papalum, ma pa ta tarai na tultul ara ra bala na pal. ");
INSERT INTO ksd_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ma ra vavina i ga kinim vake kana mal, ma i ga biti: Una va piragu; ma i ga nur vue ke kana mal ta ra limana, ma i ga takap, ma i ga irop. ");
INSERT INTO ksd_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ma ba i ga gire i ga tar nur vue kana mal ta ra limana, ma i ga tar lop irop kan ra pal, ");
INSERT INTO ksd_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","i ga oro pa ra tarai ta kana pal, i ga tata ta diat, ma i ga biti: Gire, i tar vaki go ra bul Ebraio pire dat upi na valunga dat; i tar ruk piragu upi na va piragu, ma iau tar manga kukula; ");
INSERT INTO ksd_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ma ba iau manga kukula, i vung vue kana mal piragu, ma i lop irop. ");
INSERT INTO ksd_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ma i ga vung vake kana mal pirana iat tuk tar ta ra bung ba kana luluai i ga pot mulai ta ra kubana. ");
INSERT INTO ksd_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ma i ga ve ta go ra lavur tinata dari: Nam ra tultul, a bul Ebraio, nina u ga vaki ia pire dat, i ruk piragu upi na vakaina iau; ");
INSERT INTO ksd_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ma ba iau manga kukula, i nur vue kana mal piragu, ma i lop irop. ");
INSERT INTO ksd_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ma ba kana luluai i ga valongore ra tinata kana taulai i ga tatike, dari, Kaum tultul i pait go ra mangamangana tagu, i ga tut papa kana kankan. ");
INSERT INTO ksd_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ma ra luluai kai Iosep i ga kure, ma i ga varuk ia ta ra pal na banubat, ta nam ra pakana ba di ga vake ra tarai tana ba ra king i ga vi diat; ma i ga ki aina ra pal na banubat. ");
INSERT INTO ksd_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ma ra Luluai i ga maravut Iosep ma i ga mari ia, ma ra monamono ure ra pal na banubat i ga manamanane. ");
INSERT INTO ksd_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ma ra monamono ta ra pal na banubat i ga nur tar ia tai Iosep a tarai par di ga varuk diat ta ra pal na banubat; ma i ga pait ra lavur papalum tana. ");
INSERT INTO ksd_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","A monamono ure ra pal na banubat pa i ga balaguan mulai ma ra lavur magit i ga tul tar ia tana, tago a Luluai i maravut ia; ma ra lavur magit i ga pait ia, a Luluai i ga vatavua. ");
INSERT INTO ksd_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ma ba i ga par go ra lavur magit, a tena varbalaurai ure ra lavur tava na nimomo kai ra king Aigipto, ma kana tena tuntun gem bula dir ga vakankan kadir luluai, ra king Aigipto. ");
INSERT INTO ksd_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Ma Parao i ga kulot ure kana ura tultul, ure nina i ga lualua ta diat dia varvakai ma ra tava na nimomo, ma ure nina i ga lualua ta ra umana tena tunutun. ");
INSERT INTO ksd_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Ma i ga varuk dir ta ra pal kai ra luluai i ra tarai na monamono, ta nam ra pal na banubat di ga varuk Iosep tana. ");
INSERT INTO ksd_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ma ra luluai i ra tarai na monamono i ga tul tar Iosep upi na balaure dir, ma i ga toratorom ta dir; ma i ga vavuan a ik kadir kini ta ra pal na banubat. ");
INSERT INTO ksd_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ma dir par dir ga ririvone tika na ririvon, tikatikai i ga ririvon ta ra kopono marum, ma kadir ririvon tikatikai a kukuraina iat, kai ra tena varbalaurai ure ra tava na nimomo ma kai ra tena tunutun na gem kai ra king Aigipto, nina dir ga ki ra pal na banubat. ");
INSERT INTO ksd_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ma Iosep i ga ruk pire dir ra malana, ma i ga gire ba i tabun ra bala i dir. ");
INSERT INTO ksd_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ma i ga tir ra ura tultul kai Parao, nina dital ga ki rangup me ta ra pakana pal na banubat ta ra kuba i kana luluai, dari: Ta ra ava i tabun ra bala i mumur gori? ");
INSERT INTO ksd_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ma dir ga biti tana: Amir ga ririvone tika na ririvon, ma pa ta na akari ba na pala ia. Ma Iosep i ga biti ta dir: Dave, pata ra tinata na papapala pire God? Boina amur a ve iau tana. ");
INSERT INTO ksd_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ma nina i ga lulua ta ra tarai dia ga balaguan ta ra tava na nimomo i ga ve Iosep ta kana ririvon, ma i ga biti tana: Iau gire ta kaugu ririvon a davai na vain, i tur ta ra luaina matagu; ");
INSERT INTO ksd_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ma a utul a ingarina, ma i da i gol mulai ma ra gogono i vung ra vuai na vain i matuka; ");
INSERT INTO ksd_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ma iau vatur ra momamomo kai Parao ta ra limagu, ma iau tak pa ra vuai na vain ma iau bing tar ia ta ra momamomo kai Parao, ma iau tul tar ra momamomo tai Parao. ");
INSERT INTO ksd_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ma Iosep i ga biti tana: A kukuraina dari: nam ra utul a ingarina dital a utul a bung. ");
INSERT INTO ksd_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Na par a utul a bung ma Parao na vairop u, ma na tibe tar kaum papalum mulai tam; ma una tul tar mule ra momamomo tai Parao, da lua u ga pait ia, ba u ga lualue ra tarai dia balaguan ma kana tava na nimomo. ");
INSERT INTO ksd_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ma i boina ba una nuk pa iau ba u ki bulu, ma una mari iau, ma una vatang tar iau tai Parao, upi na vairop iau kan go ra pal; ");
INSERT INTO ksd_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","tago a dovotina, di tar long kapi iau ta ra gunan kai ra umana Ebraio, ma ati bula pa iau ga pait ta magit ba na topa ra pal na banubat. ");
INSERT INTO ksd_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ma ba ra lualua kai ra umana tena tuntun gem i ga valongore ra bo na kukuraina, i ga biti tai Iosep: Iau bula iau ga ririvon, ma i dari: a utul a rat dital ki ta ra ulugu, ma a gem pua i tur tana; ");
INSERT INTO ksd_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ma ta ra rat arama liu iat a lavur mangana magit na nian ai Parao i tur tana; ma ra umana beo dia en ia ta ra rat i ki ta ra ulugu. ");
INSERT INTO ksd_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ma Iosep i ga tata bali ia ma i ga biti: Go ia ra kukuraina: ra utul a rat dital varogop ma a utul a bung; ");
INSERT INTO ksd_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","a utul a bung boko ma Parao na ub u, ma na al vatokobe u tai tika na davai, ma ra umana beo diat a en ra kanomong i ra pakam. ");
INSERT INTO ksd_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ma ta ra vautuluna bung, a bung na kinakava kai Parao, i ga pait ra lukara ure kana lavur tultul; ma i ga vairop dir, a lualua kadiat dia ga balaure ra tava na nimomo ma ra lualua kai ra umana tena tuntun gem pire kana lavur tultul. ");
INSERT INTO ksd_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ma i ga vaki mule ra lualua kadiat dia ga balaure kana tava na nimomo ta kana kiki; ma i ga tul tar mule ra momamomo ta ra lima i Parao; ");
INSERT INTO ksd_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ma i ga al vatokobe nina i ga lue diat dia tuntun gem; da Iosep i ga pala ia pire dir. ");
INSERT INTO ksd_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ma ra lualua kadiat dia ga balaure ra tava na nimomo pa i ga nuk pa mule Iosep, i ga valubane ke. ");
INSERT INTO ksd_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ma ba i ga da a ura kilala i ga taun ia, Parao i ga ririvon; ma i ga dari: i ga tur pire ra tava alir. ");
INSERT INTO ksd_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ma gire, lavurua na bo na bulumakau, a umana monomonoina, dia ga tut rikai ta ra tava alir, ma dia ga iaian ta ra titiparar. ");
INSERT INTO ksd_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ma gire, ta ra lavurua na bulumakau dia ga tut rikai ta ra tava alir, dia ga bilak ma dia ga palaur, ma dia ga tur pire ra umana bulumakau dia ga tut rikai lua, ta ra papar a tava alir. ");
INSERT INTO ksd_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ma ra lavurua na bulumakau dia ga bilak ma dia ga palaur dia ga en pa ra lavurua na bulumakau i ga kat ma i ga tubu ra paka i diat. ");
INSERT INTO ksd_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Io, Parao i ga tavangun. Ma i ga va mat mulai, ma i ga ririvon mulai; ma gire, lavurua na tur a kon dia ga vana rikai ma a kopono ko ra livua i diat, dia ga tubu ma dia ga vakak. ");
INSERT INTO ksd_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ma gire, ta ra lavurua na tur a kon dia ga vana rikai namur ta diat, dia ga palavever ma ra vuvu na taubar i ga rang diat. ");
INSERT INTO ksd_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ma ra lavurua na tur a kon dia ga palavever dia ga konom pa ra lavurua na tur a kon dia ga tubu ma dia ga mamat. Ma Parao i ga tavangun, ma gire, a ririvon ika. ");
INSERT INTO ksd_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ma ta ra malana i ga purpuruan ra tulungeana; ma i ga vartuluai upi ra umana tena papait aro Aigipto, ma ra umana tena kabinana tana bula; ma Parao i ga ve tar kana ririvon ta diat; ma pa i ga tale ta tikai upi na pala tar ia tai Parao. ");
INSERT INTO ksd_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Io, a lualua ta diat dia ga balaure ra tava na nimomo i ga biti tai Parao dari: Gori iau nuk pa kaugu bilak na mangamangana; ");
INSERT INTO ksd_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Parao i ga kankan ure kana umana tultul, ma i ga vue varuk iau ta ra pal na banubat kai ra luluai i ra loko na tarai na monamono, amir ma nina i ga lualua ta ra umana tena tuntun gem; ");
INSERT INTO ksd_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ma tika na marum amir par amir ga ririvon; kamimir ririvon tikatikai a kukuraina iat. ");
INSERT INTO ksd_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ma tika na barmana avet, a bul Ebraio, a tultul kai ra luluai i ra loko na tarai na monamono, ma amir ga ve tana, ma i ga pala tar ra kukurai kamimir ririvon ta mimir, tikatikai da kana ririvon iat. ");
INSERT INTO ksd_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ma varogop i ga pala ia ta mimir, damana di tar pait ia; iau, u ga vaki iau mulai ta kaugu kini, ma nam u ga al vatokobe. ");
INSERT INTO ksd_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ma Parao i ga vartuluai upi Iosep, ma dia ga agur pa ia lulut kan ra pal na banubat, ma i ga varkaka, ma i ga kia vue kana mal, ma i ga ruk pire Parao. ");
INSERT INTO ksd_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ma Parao i ga biti tai Iosep: Iau ga ririvone tika na ririvon, ma pa ta na akari ba na tale upi na pala ra kukuraina; ma iau valongore ba ona di ve u tai ta ririvon, i tale u pi una pala ia. ");
INSERT INTO ksd_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ma Iosep i ga tata bali Parao, ma i ga biti tana: Vakir i tur tagu, God iat na tul tar ra tinata na malmal tam. ");
INSERT INTO ksd_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ma Parao i ga biti tai Iosep dari: Ba iau ga ririvon, iau ga tur ta ra papar a tava alir; ");
INSERT INTO ksd_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ma gire, lavurua na bulumakau dia ga tut rikai ta ra tava, a umana monomonoina ma a umana vakak, ma dia ga iaian ta ra titiparar; ");
INSERT INTO ksd_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ma gire, ta ra lavurua na bulumakau dia ga tut rikai namur ta diat, dia ga kaina ma dia ga bilak ma dia ga palaur uka; ma pa iau ga gire ra umana dari ta ra gunagunan Aigipto parika. ");
INSERT INTO ksd_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ma ra umana palaur ma ra umana bilak dia ga en vue ra lavurua na monomonoina dia ga lua; ");
INSERT INTO ksd_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ma ba dia ga tar en pa diat, pa dia ga enana tana, tago dia ga bilak ika da lua. Ma iau ga tavangun. ");
INSERT INTO ksd_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ma iau ga gire ta kaugu ririvon lavurua na tur a kon dia ga vana rikai, ma i ga kopono ko ra livua i diat, dia ga tubu ma dia ga vakak; ");
INSERT INTO ksd_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ma gire, lavurua na tur a kon dia ga tavua rikai mur diat; ma dia ga makuk, dia ga palavever, ma ra vuvu na taubar i ga rang diat; ");
INSERT INTO ksd_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ma ra umana tur a kon dia ga palavever dia ga konom ra lavurua na tur a kon dia ga vakak; ma iau ga ve ra umana tena papait tana, ma pa i tale ta tikai upi na pala ia tagu. ");
INSERT INTO ksd_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ma Iosep i ga biti tai Parao: A ririvon kai Parao i tikai ka; nam ra lavur magit ba God i to na pait ia, i tar vaarike pire Parao. ");
INSERT INTO ksd_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Nam ra lavurua na bo na bulumakau a lavurua na kilala, ma ra lavurua na bo na tur a kon a lavurua na kilala; a kopono ririvon ika. ");
INSERT INTO ksd_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ma ra lavurua na bulumakau dia ga bilak ma dia ga palaur, nina dia ga tut rikai mur diat. lavurua na kilala, ma damana bula ra lavurua na tur a kon i ga palavever ma ba a vuvu na taubar i ga rang diat, go diat a lavurua na kilala na mulmulum. ");
INSERT INTO ksd_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ia go ra magit iau tar tatike tai Parao dari: God i tar vaarike pire Parao ra magit i vaninara tana upi na pait ia. ");
INSERT INTO ksd_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Gire, lavurua na kilala na minaur tuna diat a pot ta ra gunagunan Aigipto parika; ");
INSERT INTO ksd_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ma namur ta diat lavurua na kilala na mulmulum diat a vana rikai, ma da valubane ra minaur ta ra gunan Aigipto, ma ra mulmulum na tup ra gunan; ");
INSERT INTO ksd_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ma pa diat a nunure mule ra minaur ure ra mulmulum nina ba na mur, tago na mamat tuna. ");
INSERT INTO ksd_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ma Parao i tar vaurua ma ra ririvon, a vuna tago a dovot ba God na pait ia, ma na pait lulut pa ia. ");
INSERT INTO ksd_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Io, boina ba Parao na tikan upi ta tutana i kabatau ma i minana, ma na tul tar ia tana ra varkurai ure ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Boina ba Parao na pait go, ma na tibe ra umana monamono ure ra gunagunan, ma na vatur vake ra vailimana pakana ta ra gunan Aigipto ta ra lavurua na kilala na minaur. ");
INSERT INTO ksd_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ma diat a varurue ra magit na nian ta go ra lavur bo na kilala ba dia pot, ma diat a vung vake ra kon ta ra varkurai kai Parao, upi na topa ra nian ure ra umana pia na pal, ma diat a balaure. ");
INSERT INTO ksd_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ma go na varogop ma ra magit na vuvuvung kai ra gunan ure ra lavurua na kilala na mulmulum, nina ba diat a vana rikai boko ta ra gunan Aigipto, upi koko ra tarai diat a virua ta ra mulmulum. ");
INSERT INTO ksd_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ma Parao ma kana lavur tultul par dia ga manane go ra magit. ");
INSERT INTO ksd_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ma Parao i ga biti tai kana umana tultul: Akave mule ta tikai ba dir varogop ma go ra tutana, a tutana ba ra tulungen kai God i ki tana? ");
INSERT INTO ksd_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ma Parao i ga biti tai Iosep: Tago God i tar vaarike go ra lavur magit piram, pa ta mulai i kabatau ma i minana da u; ");
INSERT INTO ksd_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","una kure ra kubagu, ma kaugu tarai par diat a toratorom ta kaum lavur vartuluai; ia kaka ure ra kiki na king ina lia ta dor. ");
INSERT INTO ksd_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ma Parao i ga biti tai Iosep: Gire, iau tar vaki u pi una kure ra gunan Aigipto parika. ");
INSERT INTO ksd_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ma Parao i ga ule vue kana domol kan ra limana, ma i ga ule tar ia ta ra lima i Iosep, ma i ga vauluve ma ra kolot i kumau, ma i ga vakurue ma ra kurkurua na goled; ");
INSERT INTO ksd_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ma i ga vaki ia ta kana vauruana kiki na vinavana; ma dia ga lua tana ma dia ga oraoro dari: Avat a ki bul keke! Ma i ga tul tar ia tana ra varkurai ure ra gunan Aigipto parika. ");
INSERT INTO ksd_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ma Parao i ga biti tai Iosep: Iau Parao. ma pa ta tikai ta ra gunan Aigipto na tulue ra limana ma na puak pa ra kauna, ona pa i tir pa ia tam. ");
INSERT INTO ksd_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ma Parao i ga vatang ra iang i Iosep ba Sapnat Panea; ma i ga tul tar Asenat tana, natu i Potipera a tena tinabar aro On. Ma Iosep i ga kotokotop ra gunagunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Ma Iosep i ga utul a vinun na kilakilala ba i ga tur ta ra luaina mata i Parao ra king Aigipto. Ma Iosep i ga irop kan ra kuba i Parao, ma i ga kotokotop ra gunagunan Aigipto parika. ");
INSERT INTO ksd_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ma ta ra lavurua na kilala na minaur a gunagunan i ga vuai na kaia. ");
INSERT INTO ksd_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ma i ga varurue ra lavur magit na nian ta ra lavurua na kilala ta ra gunan Aigipto, ma dia ga vungvung ia ta ra umana pia na pal; ma ra magit i ra lavur uma kikil ra lavur pia na pal tikatikai i ga vung vake ta diat. ");
INSERT INTO ksd_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Ma Iosep i ga vung vake ra kon da ra veo ara ra valian, a peal tuna, ma pa i ga luk valar pa ia mulai, tago i ga pepeal tuna. ");
INSERT INTO ksd_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ma Iosep i ga vangala a ura natuna, ba pata ra kilala na mulmulum boko; Asenat, natu i Potipera ra tena tinabar aro On, i ga kava tar dir. ");
INSERT INTO ksd_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ma Iosep i ga vatang ra iang i ra luaina ba Manase, tago i ga biti: God i tul tar iau pi ina valubane ra lavur magit i ga monong iau ma ra kuba i tamagu par. ");
INSERT INTO ksd_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ma ra vauruana i ga vatang ia ba Epraim, tago i ga biti: God i tar vatavua iau ta ra gunan iau ga kadik tana. ");
INSERT INTO ksd_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ma ra lavurua na kilala na minaur ta ra gunan Aigipto dia ga par. ");
INSERT INTO ksd_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Ma ra lavurua na kilala na mulmulum dia ga vura na pot, da Iosep i ga biti, ma ra mulmulum i ga tup ra gunagunan par; ma ia kaka ta ra gunan Aigipto par a magit na nian i ga tur tana. ");
INSERT INTO ksd_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ma ba ra gunan Aigipto par i ga mulmulum, a tarai dia ga manga tangi tadav Parao upi ta magit na nian;. ma Parao i ga biti ta ra tarai Aigipto par: Avat a vana pire Iosep; a magit par ba i ve avat, avat a pait ia. ");
INSERT INTO ksd_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ma ra mulmulum i ga tur ta ra rakarakan a gunagunan par; ma Iosep i ga papa are ra lavur pal na vuvuvung, ma i ga ivure ra kon ta ra tarai Aigipto; ma ra mulmulum i ga manga tup ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ma ra lavur gunan par dia ga vana uro Aigipto tadav Iosep, upi diat a kul kon; tago ra mulmulum i ga manga tup ra rakarakan a gunagunan par. ");
INSERT INTO ksd_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ma Iakob i ga gire ba a kon aro Aigipto, ma i ga biti tai ra umana natuna, a umana bul tutana, dari: Ta ra ava ava bobe vargiliane ke avat? ");
INSERT INTO ksd_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Gire, iau valongore ba a kon aro Aigipto; avat a vana, ma avat a kukul tana ure dat, upi dat a laun, ma koko dat a mat. ");
INSERT INTO ksd_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ma ra vinun na tura i Iosep dia ga vana ur upi diat a kul kon aro Aigipto. ");
INSERT INTO ksd_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ma Iakob pa i ga tulue Beniamin, tura i Iosep, upi diat a varagur ma ra umana turana, tago i ga biti: Kan ta kaina magit na tadav ia. ");
INSERT INTO ksd_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ma ra umana natu i Israel diat ma ta ra umana enana dia ga vana uro Aigipto upi diat a kukul, tago ra mulmulum i ga tup ra gunan Kanaan. ");
INSERT INTO ksd_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ma Iosep i ga luluai ta ra gunan, ma i ga ivivura ta ra tarai ta ra gunagunan; ma ra umana tura i Iosep dia ga vut, ma dia ga va timtibum pirana, a mata i diat ra pia. ");
INSERT INTO ksd_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ma Iosep i ga gire ra umana turana, ma i ga nunure ilam diat, ma i ga tibuna vaenana pa kana mangamangana pire diat, ma i ga dekdek kana tinata pire diat; ma i ga biti ta diat: Avat mamave? Ma dia ga biti: Maro ra gunan Kanaan, upi avet a kul magit. ");
INSERT INTO ksd_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ma Iosep i ga nunure ilam ra umana turana, ia kaka diat pa dia ga nunure ilam ia. ");
INSERT INTO ksd_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ma Iosep i ga nuk pa mule ra ura ririvon i ga ririvone ure diat, ma i ga biti ta diat: Avat a umana kilao; ava vana uti upi avat a gire ke ra gunan i tur vakuku. ");
INSERT INTO ksd_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ma dia ga biti tana dari: Pata, luluai; kaum umana tultul dia pot upi diat a kul magit. ");
INSERT INTO ksd_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Avet par a umana natu i tika na tutana; a umana dovot na tutana avet, vakir a umana kilao. ");
INSERT INTO ksd_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ma i ga biti ta diat: Pata; ava vana uti upi avat a gire ke ra gunan i tur vakuku. ");
INSERT INTO ksd_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ma dia ga biti: Avet kaum umana tultul, a vinun ma a ivu barturana. a umana natu i ra kopono tutana ta ra gunan Kanaan; ma nina i mur kakit i ki pire tama i vevet gori; ma ta ra tikai i tar panie. ");
INSERT INTO ksd_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ma Iosep i ga biti ta diat: I dovot nam ra magit iau ga vatang ia pire vavat dari: ");
INSERT INTO ksd_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Avat a umana kilao; go ra magit ina valar avat i tana; ta ra nilaun kai Parao iau ve avat ba pa avat a vana kariu mulai. ona tura i vavat nina i mur kakit pa i vana uti. ");
INSERT INTO ksd_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Avat a tulue tikai ta vavat. ma na agure tura i vavat, ma avat, ina vi vake avat, upi ina valar ot pa kavava tinata, ba i dovot ba pata; ona pata, ta ra nilaun kai Parao, avat a umana kilao. ");
INSERT INTO ksd_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ma i ga varuk vake diat par ta ra pal na banubat a utul a bung. ");
INSERT INTO ksd_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ma Iosep i ga biti ta diat ta ra vautuluna bung dari: Avat a pait go, ma avat a laun, tago iau ru God: ");
INSERT INTO ksd_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ari ava dovot, boina da vi ta tikai ta vavat, ma na ki ta ra pal na banubat ati; ma avat a vana, ma avat a kap kon ure ra mulmulum ta ra kuba i vavat, ");
INSERT INTO ksd_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ma avat a agur pa tura i vavat a muruna piragu; ona damana, ina nurnur ta kavava tinata, ma pa avat a virua. Ma dia ga pait ia damana. ");
INSERT INTO ksd_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ma dia ga biti vargil ta diat dari: A dovot da ga pait ra kaina tai tura i dat, tago da ga gire ra ngala na bunurut ta ra balana, nam i ga lulul dat i tana ma pa da ga torom tana; kari go ra bunurut i ki ta dat! ");
INSERT INTO ksd_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ma Ruben i ga tata bali diat ma i ga biti dari: Ma pa iau ga tigal avat bar dari, Koko avat a pait ta kaina magit ure ra bul? Ma pa ava ga nuk pa ia; io, ava gire, a balbali ure ra gapuna. ");
INSERT INTO ksd_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ma pa dia ga nunure ba Iosep i ga valongore ilam kadia tinata; tago ta tikai i ga pukpukue kadia tinata pirana. ");
INSERT INTO ksd_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ma i ga tur irai kan diat, ma i ga tangi; ma i ga lilikun mulai pire diat, ma i ga tata pire diat, ma i ga pilak pa Simeon ta diat, ma i ga vi ia ta ra luaina mata i diat. ");
INSERT INTO ksd_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Namur Iosep i ga vartuluai upi da vabuka kadia lavur kakakap ma ra kon, ma upi da vung mule kadia mani ta kadia kakakap tikatikai, ma a magit bula ba na topa diat na nga; ma dia ga pait ia damana ta diat. ");
INSERT INTO ksd_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ma dia ga vako kadia kon ta kadia umana as, ma dia ga vana. ");
INSERT INTO ksd_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ma ba tikai ta diat i ga pala kana kakakap ta ra pal na vava gil, upi na tabar kana as ma ra magit, i ga na tadav kana mani, ma gire, i ga va arama liu ta ra ngovo na kakakap. ");
INSERT INTO ksd_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ma i ga biti tai ra umana turana: Di tar vamule kaugu mani, ma gire, i va ta kaugu kakakap; ma i ga bilua ra nuknuk i diat, ma dia ga dadadar, ma dia biti vargil ta diat dari: Ava go God i tar pait ia ta dat? ");
INSERT INTO ksd_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ma dia ga pot pire Iakob tama i diat ta ra gunan Kanaan, ma dia ga vaarike ra lavur magit i ga tadav diat; ");
INSERT INTO ksd_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","dia ga biti: I ga dekdek ra tinata kai nam ra tutana, ra luluai i ra gunan, tadav avet, ma i ga vatang avet ba a umana kilao ure ra gunan. ");
INSERT INTO ksd_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ma ave ga biti tana: Avet a umana dovot na tutana, vakir avet ra umana kilao; ");
INSERT INTO ksd_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","a vinun ma a ivu barturana avet, a umana natu i tama i vevet; tikai i tar panie, ma ra muruna gori i ki pire tama i vevet ta ra gunan Kanaan. ");
INSERT INTO ksd_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ma nam ra tutana, ra luluai ta ra gunan. i ga biti ta vevet: Go ina nunure tana ba avat a dovot na tarai: avat a nur vue ta tika na tura i vavat ba na ki piragu. ma avat a kap ra kon ure ra mulmulum ta ra kuba i vavat. ma avat a vana; ");
INSERT INTO ksd_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ma avat a agur pa tura i vavat piragu, a muruna kakit, ma ina nunure tana ba avat a dovot na tarai, ma vakir a umana kilao; ma ina tul tar mule tura i vavat ta vavat, ma avat a vanavana ta go ra gunan. ");
INSERT INTO ksd_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ma ba dia ga lolonge kadia umana kakakap, gire, ra popopoi na mani kai tikatikai i ga va ta kana kakakap; ma ba diat ma tama i diat dia ga na tadav kadia popopoi na mani, dia ga burut. ");
INSERT INTO ksd_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ma tama i diat Iakob i ga biti: Ava ga ra vue ra ura natugu kan iau; Iosep i ga tar panie, Simeon i tar panie, ma ava mainge upi avat a tak vue Beniamin; go ra lavur magit dia tup iau. ");
INSERT INTO ksd_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ma Ruben i ga biti tai tamana dari: Una ubu vamat ra ura natugu, a ura tutana, ona pa ina agur pa mule piram; una nur tar ia ta ra limagu, ma ina agure mule piram. ");
INSERT INTO ksd_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ma i ga biti: Koko natugu na varagur ma avat ura; tago turana i ga mat, ma go ko i laun; ba ta kaina magit na tadav ia ta ra nga avat a vana tana, ina kuba ma ra mi na tagal a ulugu ta ra ruarua na tulungen ure ra tinabun. ");
INSERT INTO ksd_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ma ra mulmulum i ga manga tup ra gunan. ");
INSERT INTO ksd_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ma ba dia ga tar en vapar ra kon nina di ga vila pa ia aro Aigipto, tama i diat i ga biti ta diat: Avat a vana mulai, ma avat a kul ada ta ik a magit. ");
INSERT INTO ksd_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ma Iuda i ga biti tana: Nam ra tutana i ga manga tigal avet, ma i ga biti dari: Koko avat a gire mule ra matagu, ona pa ava varagur ma tura i vavat. ");
INSERT INTO ksd_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ona una tulue tura i vevet upi avet a varagur, io, avet a vana ma avet a kul am ta magit; ");
INSERT INTO ksd_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ma ona pa una tulue, pa avet a vana ur; tago ra tutana i ga biti ta vevet: Koko avat a gire ra matagu ona pa ava varagur ma tura i vavat. ");
INSERT INTO ksd_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ma Israel i ga biti: Ta ra ava ava ga vakaina iau dari, tago ava ga ve nam ra tutana ba tika na tura i vavat boko? ");
INSERT INTO ksd_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ma dia ga biti: A tutana i ga tir bulu avet ure avet ma ra umana niuru i vevet, ma i ga biti: Dave tama i vavat i laun boko? Ma dave, ta tika na tura i vavat mulai? Ma ave ga ve varogop ma ra kukurai kana tinir; ma avet a nunure davatane ba na biti: Avat a agur pa tura i vavat uti? ");
INSERT INTO ksd_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ma Iuda i ga biti tai Israel tamana: Una tul tar ra barmana tagu, ma avet a tut ma avet a vana, upi avet a laun ma koko avet a virua, dat ma u ma ra umana natu i vevet. ");
INSERT INTO ksd_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Iau iat ina kul kia ia, ma una tir pa ia ta ra limagu; ona pa ina agur pa ia mulai upi ina vatur ia ta ra luaina matam, io, una takun vatikene pa iau; ");
INSERT INTO ksd_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","tago gala pa ave ga vabing ma ra kini, gala avet a vaurua ma ra lilikun mulai. ");
INSERT INTO ksd_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ma tamana Israel i ga biti ta diat: Ona i damana, boina avat a pait go: avat a vung ra bo na vuai na davai i tavua ta go ra gunan ta kavava kakakap, ma avat a kap tabar nam ra tutana me, ta ik a polo na pupu na davai i kalami, ta ik a bulit na davai, ma a varku, ma ra magit i ang na katkat, ma ra pao, ma ra galip; ");
INSERT INTO ksd_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","ma avat a kap a ura popopoi na mani, nam ra mani di ga vamule ta ra mata i kavava kakakap avat a kap mule ta ra lima i vavat, kan di ga pait varara ke; ");
INSERT INTO ksd_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","avat a agur pa bula tura i vavat ma avat a tut, ma avat a vana mulai tadav nam ra tutana; ");
INSERT INTO ksd_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","ma God Dekdek Muka na mari avat ta ra mata i nam ra tutana, upi na pala tar tura i vavat ta vavat, ma Beniamin bula. Ma ona di ra pa ra umana natugu kan iau, io, damana. ");
INSERT INTO ksd_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ma ra tarai dia ga kap ra vartabar. ma dia ga kap a ura popopoi na mani ta ra lima i diat, ma Beniamin bula; ma dia ga tut ma dia ga vana ur Aigipto, ma dia ga tur rikai ta ra mata i Iosep. ");
INSERT INTO ksd_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ma ba Iosep i ga gire dia ga varagur ma Beniamin, i ga biti tai ra tena varbalaurai ta ra kubana dari: Una agur pa go ra tarai ta ra pal, ma una dodoko ma una vaninara, tago go ra tarai diat a ian boko piragu ba ra keake i ki tur. ");
INSERT INTO ksd_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ma ra tutana i ga mur ra vartuluai kai Iosep; ma ra tutana i ga agure ra tarai ta ra pal kai Iosep. ");
INSERT INTO ksd_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ma ra tarai dia ga burut, tago di ga agure diat ta ra kuba i Iosep, ma dia ga biti: Ure ra mani bar. nina di ga vamule ta kada kakakap ta ra vinavana lua, di agure varuk dat upi na takun dat ma na kinim vavilavilau dat ma kada as bula. ");
INSERT INTO ksd_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ma dia ga tadav ra tutana, a tena varbalaurai ta ra kuba i Iosep, ma dia ga tata pirana ta ra matakilalat i ra pal, ma dia ga biti: ");
INSERT INTO ksd_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Luluai, a dovotina ta kaveve vinavana tavuna uti ave ga mainge upi avet a kul magit; ");
INSERT INTO ksd_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ma ba ave ga tadav ra pal na vava gil ave ga pala kaveve umana kakakap, ma gire, ra mani kavevet par i ga va ta ra ngovo na kakakap kai tikatikai, kaveve mani parika da kana mamat; ma go ave tar kap mule ma ra lima i vevet. ");
INSERT INTO ksd_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ma ave kap ta ra mani bula upi avet a kul magit; ma pa ave nunure ba to ia bar i ga vung kaveve mani ta kaveve kakakap. ");
INSERT INTO ksd_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ma i ga biti: A malmal na tadav avat, koko avat a burut; kavava God ma ra God kai ra umana tama i vavat i ga vung ra ngatngat na magit ta kavava kakakap; iau tar vatur vake kavava mani. Ma i ga agure vairop Simeon tadav diat. ");
INSERT INTO ksd_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ma ra tutana i ga agure varuk ra tarai ta ra kuba i Iosep, ma i ga tul tar ra tava ta diat, ma dia ga puk ra kau i diat, ma i ga tabar kadia umana as ma ra magit. ");
INSERT INTO ksd_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ma dia ga vaninare ra vartabar ure Iosep ba na vut ta ra keake i ki tur, tago dia ga valongore ba diat a ian abara. ");
INSERT INTO ksd_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ma ba Iosep i ga pot ta ra kubana, dia ga kap ra vartabar ta ra kubana, di ga vatur ia ma ra lima i diat, ma dia ga va timtibum pirana. ");
INSERT INTO ksd_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ma i ga tir diat ba dia laun boina ba pata, ma i ga biti: Dave tama i vavat, nam ra patuana tutana ava ga varvai ure, i laun boina boko? ");
INSERT INTO ksd_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ma dia ga biti: Kaum tultul tama i vevet i laun, pa i ti mat boko. Ma ra ulu i diat i ga va ruru ma dia ga va timtibum. ");
INSERT INTO ksd_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ma i ga idok, ma i ga gire Beniamin turana, natu i tinana, ma i ga biti: Dave, tura i vavat nam, a muruna, nam ava ga ve iau ure? Ma i ga biti dari: God na mari u, natugu. ");
INSERT INTO ksd_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ma Iosep i ga lulut, tago ra balana i ga kaina upi turana, ma i ga tikan upi ta pakana pal ba na tangi tana; ma i ga ruk ta kana pakana pal iat, ma i ga tangi tana. ");
INSERT INTO ksd_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ma i ga puk ra matana, ma i ga irop, ma i ga tibuna kure bat ia mulai, ma i ga biti: Avat a vung ra magit na nian. ");
INSERT INTO ksd_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ma dia ga vung varbaiane ana magit ma adiat, ma ai ra tarai Aigipto bula, nina dia ga ian varurung me; tago ra tarai Aigipto pa dia ga ian varurung ma ra tarai Ebraio, tago a bilak na magit nam pire ra tarai Aigipto. ");
INSERT INTO ksd_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ma dia ga ki ta ra luaina matana, a luaina arama da di ga kava, ma ra muruna ara iat, tago pa i ga do kana kilala; ma ra tarai dia ga kaian vargil. ");
INSERT INTO ksd_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ma di ga tak pa ra magit i ga tur ta ra luaina matana, ma di ga tibe diat me. Ma Beniamin di ga vavailima pa ia ma ra tiniba, ma diat par pata. Ma dia ga momo varurung ma dia ga gugu. ");
INSERT INTO ksd_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ma i ga vartuluai pire ra tena varbalaurai ta ra kubana, i ga biti: Una vabuka ra umana kakakap kai ra tarai ma ra magit da i topa ra kinakap, ma una vung ra mani kai tikatikai arama ta ra ngovo na kinakap tana. ");
INSERT INTO ksd_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ma una vung kaugu momamomo, nina di ga pait ia ma ra silva, ta ra ngovo na kakakap kai ra muruna kakit, ma kana mani ure ra kon bula. Ma i ga pait ia varogop ma ra tinata Iosep i ga tatike. ");
INSERT INTO ksd_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ma ba i ga keke are diat, di ga tul vue ra tarai, diat ma kadia umana as. ");
INSERT INTO ksd_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ma ba dia ga tar irop ta ra pia na pal, ma pa dia ga vana vailik boko, Iosep i ga biti ta kana tultul: Una tut, ma una korot mur nam ra tarai, ma ba una tadav diat, una biti ta diat: Ta ra ava ava bali ra boina ma ra kaina? ");
INSERT INTO ksd_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Dave, vakir nam ba kaugu luluai i momamomo me, ma i na tana ra magit i tur ivai? Ava kaina tago ava pait ra dari. ");
INSERT INTO ksd_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ma i ga tadav diat, ma i ga tatike go ra tinata ta diat. ");
INSERT INTO ksd_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ma dia ga biti tana: Luluai, ta ra ava u tatike ra tinata damana? Koko muka ba kaum umana tultul diat a pait ra dari. ");
INSERT INTO ksd_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Gire, nam ra mani ave ga na tadav ia ta kaveve kakakap, ave tar kap mule piram maro ra gunan Kanaan, ma ave long davatane ra silva ba ra goled ta ra kuba i kaum luluai? ");
INSERT INTO ksd_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Nina ta vevet kaum umana tultul ba da gire go ra magit pirana, na virua, ma avet bula avet a umana vilavilau kai ra luluai. ");
INSERT INTO ksd_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ma i ga biti: Boina ba na da kavava tinata; nina ba da tikan tadav ia pirana, kaugu vilavilau nam; ma avat ta ra umana, pa da takun avat. ");
INSERT INTO ksd_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ma dia ga lulut, dia ga vung vairop tikatikai kana kakakap ra pia, ma diat par dia ga pala ia. ");
INSERT INTO ksd_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ma i ga pepeng, ma i ga tur pa ia ta ra luaina ma i ga tuk ta ra muruna. Ma di ga peng pa ra momamomo ta ra kakakap kai Beniamin. ");
INSERT INTO ksd_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ma dia ga rada kadia umana mal, ma dia ga vako mule tikatikai kadia tabarikik ta ra as ma dia ga talil upi ra pia na pal. ");
INSERT INTO ksd_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ma Iuda ma ra umana turana dia ga ruk ra kuba i Iosep; ma i ga ki boko tana; ma dia ga bura timtibum pirana. ");
INSERT INTO ksd_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ma Iosep i ga biti ta diat: A mangamangana ava go ava tar pait ia? Pa ava nunure vang ba na tale ra tutana da iau upi na nuk tadav ia? ");
INSERT INTO ksd_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ma Iuda i ga biti: Ava mulai avet a tatike ta kaugu luluai, ma avet a tata mulai dave? Ba avet a tata davatane bat avet? God i tar gire ra mangamangana kaina kai kaum umana tultul; gire, avet go a umana vilavilau kai kaugu luluai, avet ma nam bula di ga tikan tadav ra momamomo pirana. ");
INSERT INTO ksd_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ma i ga biti: Koko muka ina pait go ra magit, pata; nina iat di ga tikan tadav ra momamomo pirana, kaugu vilavilau nam; ma avat, i boina avat a vana tadav tama i vavat ma ra malmal. ");
INSERT INTO ksd_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ma Iuda i ga maravai pirana ma i ga biti: Boina, luluai, una tul tar ia ta kaum tultul upi na vatang ta ik a tinata ta ra talingam, ma koko i ngangal kaum kankan ure kaum tultul, tago amur vardada ma Parao. ");
INSERT INTO ksd_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Kaugu luluai, u ga tir kaum umana tultul dari: Tama i vavat abara, ba ta tura i vavat? ");
INSERT INTO ksd_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ma ave ga ve u, luluai, dari: Tama i vevet abara, a patuana, ma tika na natuna, i ga vangala ba i patuana, go i barmana, ma turana i tar mat, ma ia kaka i tur valili ta dir ra ura natu i nana, ma tamana i mari ia. ");
INSERT INTO ksd_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ma u ga biti ta kaum umana tultul: Avat a agur pa ia uti, upi ina gire ma ra matagu. ");
INSERT INTO ksd_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ma luluai, ave ga biti tam dari: I dekdek upi ra barmana na vana balakane tamana, tago ona i vana kan ia, tamana na mat ika. ");
INSERT INTO ksd_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ma u ga biti ta kaum umana tultul: Ona pa ava varagur ma tura i vavat, koko avat a vana rikai mulai ta ra luaina matagu. ");
INSERT INTO ksd_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ma ba ave tadav kaum tultul tama i vevet, ave ga vateten tar kaum tinata tana. ");
INSERT INTO ksd_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ma tama i vevet i biti dari: Avat a vana, avat a kul ta ik a magit adat. ");
INSERT INTO ksd_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ma ave biti tana: I dekdek upi avet a vana ur; ona avet a varagur ma tura i vevet a muruna kakit, io, avet a vana ur; tago i dekdek upi avet a gire ra mata i ra tutana ona pa ave varagur ma tura i vevet a muruna. ");
INSERT INTO ksd_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ma kaum tultul tamagu i biti ta vevet: Ava nunure ba kaugu taulai i kava tar ra ura bul tagu. ");
INSERT INTO ksd_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ma tikai i vana kan iau, ma iau biti, A kaina leing i karat kadakadal ia, ma pa iau gire mule, ");
INSERT INTO ksd_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ma ona ava agur pa go bula kan iau, ma ra kaina magit na tadav ia, ina kuba ta ra ruarua na tulungen ma ra mi na tagal a ulugu ure ra tinabun. ");
INSERT INTO ksd_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Io, ba ina pot pire kaum tultul tama i vevet, ma ra barmana pa na ki pire vevet, na mat ika, ");
INSERT INTO ksd_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","tago kana nilaun dir taviviai ma nam kai ra barmana; ma kaum umana tultul diat ra vuna, ba kaum tultul tama i vevet na kuba ta ra ruarua na tulungen ma ra mi na tagal a uluna ure ra niligur. ");
INSERT INTO ksd_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Tago kaum tultul i ga vavalima, ba na vamule ra barmana, ma i biti bula dari: Ona pa ina agure mule piram, tamagu na takun vatikene pa iau. ");
INSERT INTO ksd_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Io, iau lul u go, boina ba kaum tultul na kia vue ra barmana piram, ma ina ki da ra vilavilau piram; ma boina ba ra barmana na lilikun, diat ma ra umana barturana. ");
INSERT INTO ksd_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Tago ina vana urama dave, ona pa amir a varagur ma ra barmana; kan ina gire ra niligur ba na tadav tamagu tana. ");
INSERT INTO ksd_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ma Iosep i ga mama kure bat mule ta ra luaina mata i diat par dia ga tur pirana; ma i ga biti ma ra ngala na nilaina: A tarai par diat a irop boko kan iau. Ma pa ta tikai i ga tur mulai pirana, ba Iosep i ga tibuna vaarike mule ta ra umana turana. ");
INSERT INTO ksd_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ma i ga kukukula, ma ra tarai Aigipto dia ga valongore, ma diat ta ra kuba i Parao dia ga valongore. ");
INSERT INTO ksd_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ma Iosep i ga biti tai ra umana turana dari: Iau Iosep; dave, tamagu i laun boko ba pata? Ma i ga dekdek upi ra umana turana diat a bali kana tinata, tago i ga purpuruan ra bala i diat ta ra luaina matana. ");
INSERT INTO ksd_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ma Iosep i ga biti tai ra umana turana dari: Avat a vana maravai piragu. Ma dia ga kakari maravai. Ma i ga biti: Iau Iosep, tura i vavat, nina ava ga ivure uro Aigipto. ");
INSERT INTO ksd_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ma go koko ava ligur, ma koko ava kankanuane avat mulai tago ava ga ivure iau uti. Tago God i ga tulue iau na lua ta vavat upi ra varvalaun. ");
INSERT INTO ksd_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Tago a ura kilala i taun ra mulmulum ta go ra gunan, ma a ilima na kilala boko upi na par, ma pa da ipipuk, ma pa da varurue ta magit tana. ");
INSERT INTO ksd_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ma God i ga tulue iau na lua ta vavat, upi avat a mat valili ta ra rakarakan a gunagunan, ma upi ina valaun avat ma ra ngala na varvalaun. ");
INSERT INTO ksd_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Damana vakir avat ava ga tulue iau, God iat; “i ga vaki iau da iau tama i Parao, a luluai ta ra kubana, ma a luluai ta ra gunagunan Aigipto par. ");
INSERT INTO ksd_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Avat a rurut, ma avat a vana tadav tamagu, ma avat a biti tana: Natum Iosep i biti dari, God i ga vaki iau upi ina luluai ta ra gunan Aigipto parika; una vana ur piragu, ma koko una vabing ma ra vinavana. ");
INSERT INTO ksd_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ma una ki ta ra gunan Gosen, ma una ki maravai piragu, avat ma ra umana natum, ma ra umana natu i diat, ma kaum lavur kikil na vavaguai, ma kaum lavur bulumakau, ma kaum lavur tabarikik; ");
INSERT INTO ksd_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ma ina vamel u ie, tago a ilima na kilala na mulmulum boko, kan avat a tadav ra kini na luveana, avat ma diat ta ra kubam, ma kaum tarai par. ");
INSERT INTO ksd_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ea, go ava gire ma ra mata i vavat, ma Beniamin turagu i gire ma ra matana, ba iau tata ma ra ngiegu iat. ");
INSERT INTO ksd_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ma avat a ve tamagu ure kaugu lavur minamar ava gire, ma avat a kavie ra vinavana, ma avat a agure tamagu uti. ");
INSERT INTO ksd_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ma i ga tal pa ra inoa i turana Beniamin. ma i ga tangi, ma Beniamin i ga tangi ta ra inoana. ");
INSERT INTO ksd_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ma i ga galum ra umana turana par, ma i ga tangi pire diat, ma namur a umana turana dia ga tata me. ");
INSERT INTO ksd_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ma ra tinata i ga rararang ta ra kuba i Parao dari: A umana tura i Iosep dia tar pot; ma Parao ma kana lavur tultul dia ga gugu. ");
INSERT INTO ksd_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ma Parao i ga biti tai Iosep: Una ve ra tara na turam dari: Avat a pait go. avat a vako tar ra kinakap ta kavava vavaguai, ma avat a vana ta ra gunan Kanaan; ");
INSERT INTO ksd_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ma avat a agur pa tama i vavat, ma diat ta ra lavur kuba i vavat, ma avat a vana piragu, ma ina tul tar ia ta vavat nam ra langun i boina kakit ta ra gunan Aigipto, ma avat a en ra bira tana. ");
INSERT INTO ksd_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ma u, una vartuluai dari: Avat a pait go: avat a vana ma ra umana kiki na vinavana mamati Aigipto, ure ra umana natu i vavat ma kavava umana taulai, ma avat a agur pa tama i vavat, ma avat a vana uti. ");
INSERT INTO ksd_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ma koko ava manga varvakai ma kavava tabarikik, tago da tul tar ia ta vavat ra langun i boina kakit ta ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ma ra umana natu i Israel dia ga pait ia damana. Ma Iosep i ga tul tar ra umana kiki na vinavana ta diat, varogop ma ra vartuluai kai Parao; ma i ga tul tar ra magit ta diat upi na topa diat ta ra vinavana; ");
INSERT INTO ksd_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","ma i ga tabar diat par tikatikai ma ra umana mal kumau; ma i ga tabar Beniamin ma ra utul a marmar na pakana silva, ma ra ilima na mal kumau. ");
INSERT INTO ksd_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ma i ga tulue go ra lavur magit tadav tamana: a vinun na as dia ga kapkap ra bo na tabarikik maro Aigipto, ma ra vinun na as, a umana tana, dia ga mulue ra kon ma ra gem ma ra magit na nian upi kai tamana ure ra vinavana. ");
INSERT INTO ksd_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Damana i ga tul vue ra tara na turana, ma dia ga vana; ma i ga biti ta diat dari: Koko ava purpuruan na nga. ");
INSERT INTO ksd_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ma dia ga irop ta ra gunan Aigipto, dia ga vana urama Kanaan tadav Iakob tama i diat. ");
INSERT INTO ksd_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ma dia ga biti tana: Iosep i laun boko, ma i luluai ure ra gunan Aigipto parika. Ma i ga bilua ra nuknukina, tago pa i ga kapupi diat. ");
INSERT INTO ksd_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ma dia ga ve ra lavur tinata Iosep i ga tatike, ma ba i ga gire ra umana kiki na vinavana, nina Iosep i ga tulue diat upi na ki tana, i ga lagar ra tulungea i tama i diat Iakob. ");
INSERT INTO ksd_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ma Israel i ga biti: Iau tar ngo, tago natugu Iosep i laun boko! Ina vana, ma ina gire, ba pa iau tapula boko. ");
INSERT INTO ksd_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ma Israel i ga varurue kana tabarikik par ma i ga vana; ma i, ga pot aro Ber-Seba; ma i ga tul tar ra umana magit na tinabar tai ra God kai tamana Isak. ");
INSERT INTO ksd_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ma God i ga tata pire Iakob ta ra marum ma ra lavur ninana, ma i ga biti: Iakob, Iakob! ");
INSERT INTO ksd_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ma i ga biti: Iau go kari! Ma i ga biti: Iau God, a God kai tamam; koko u burut ure ra vinavana uro Aigipto, tago aina ina vaki vaarike ra ngala na vuna tarai tam. ");
INSERT INTO ksd_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Dor a varagur uro Aigipto, ma a dovotina ina agure vairop u mulai, ma Iosep na vung ra limana ta ra kiau na matam. ");
INSERT INTO ksd_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ma Iakob i ga tut maro Ber-Seba, ma ra umana natu i Israel dia ga agur pa tama i diat Iakob, ma ra umana natu i diat, ma kadia umana taulai, ta ra kiki na vinavana nina Parao i ga tulue upi na ki tana. ");
INSERT INTO ksd_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ma dia ga varurue kadia umana vavaguai ma kadia tabarikik, nina dia ga vatur vake ta ra gunan Kanaan, ma dia ga vana Aigipto, Iakob diat ma ra umana bul mur par tana: ");
INSERT INTO ksd_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","a lavur natuna, a umana tutana ma ra umana vavina, ma ra umana tubuna, a umana tutana ma ra umana vavina; kana lavur bul mur par i ga agur pa diat uro Aigipto. ");
INSERT INTO ksd_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ma go ra iang i diat ra umana natu i Israel, nina dia ga vana uro Aigipto, Iakob ma ra lavur natuna: Ruben, ra luaina kai Iakob. ");
INSERT INTO ksd_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ma ra umana natu i Ruben: Kanok ma Palu ma Kesron ma Karmi. ");
INSERT INTO ksd_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ma ra umana natu i Simeon: Iemuel ma Iamin ma Oad ma Iakin ma Sokar ma Saul natu i ra vavina Kanaan. ");
INSERT INTO ksd_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ma ra umana natu i Levi: Gerson, Koat ma Merari. ");
INSERT INTO ksd_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ma ra umana natu i Iuda: Er ma Onan ma Sela ma Peres ma Sera; ma Er ma Onan dir ga mat ta ra gunan Kanaan. Ma ra umana natu i Peres: Kesron ma Kamul. ");
INSERT INTO ksd_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ma ra umana natu i Isakar: Tola ma Puva ma Iob ma Simron. ");
INSERT INTO ksd_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ma ra utul a natu i Sebulun: Sered ma Elon ma Ialel. ");
INSERT INTO ksd_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Go ra umana natu i Lea, ma i ga kava tar diat tai Iakob aro Padan-Aram, ma tikai bula, Dina, a vavina. Ma di ga luk guve ra umana natuna, a umana tutana ma ra umana vavina, ba a utul a vinun ma a utul. ");
INSERT INTO ksd_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ma ra umana natu i Gad: Sipion ma Kagi ma Suni ma Esbon ma Eri ma Arodi ma Areli. ");
INSERT INTO ksd_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ma ra umana natu i Aser: Imna ma Isva ma Isvi ma Beria ma Sera, a vavina, tai dital; ma a ura natu i Beria: Keber ma Malkiel. ");
INSERT INTO ksd_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","A umana natu i Silpa go, nina Laban i ga tul tar ia tai Lea natuna, ma i ga kava tar diat tai Iakob, a vinun ma laptikai diat. ");
INSERT INTO ksd_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","A ura natu i Rakel, a taulai kai Iakob: Iosep ma Beniamin. ");
INSERT INTO ksd_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ma a ura natu i Iosep: Manase ma Epraim; Asenat, natu i Potipera, a tena tinabar aro On, i ga kava tar dir tana. ");
INSERT INTO ksd_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ma ra umana natu i Beniamin: Bela, Beker, Asbel, Gera, Naman, Eki, Ros, Mupim, Kupim ma Ared. ");
INSERT INTO ksd_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Go ra umana bul Rakel i ga kava tar ia tai Iakob; diat par a vinun ma a ivat. ");
INSERT INTO ksd_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Tika na natu i Dan: Kusin. ");
INSERT INTO ksd_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ma ra umana natu i Naptali: Iasel, ma Guni, ma Ieser, ma Silem. ");
INSERT INTO ksd_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Go ra umana natu i Bila, nina Laban i ga tul tar ia tai Rakel natuna, ma go i ga kava tar diat tai Iakob; lavurua diat par. ");
INSERT INTO ksd_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ma ra tarai, nina i ga vangala diat ma dia ga varagur ma Iakob uro Aigipto, laptikai na vinun ma laptikai diat par; ");
INSERT INTO ksd_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","ma ra natu i Iosep, di ga kava tar ia aro Aigipto, a urua dir; damana di luk guve diat par ta ra kuba i Iakob nina dia ga vana uro Aigipto, ba lavurua na vinun. ");
INSERT INTO ksd_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ma i ga tulue Iuda upi na lua pire Iosep, upi na matoto pa ta ra nga uro Gosen, ma dia ga vut ta ra gunan Gosen. ");
INSERT INTO ksd_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Ma Iosep i ga vaninare kana kiki na vinavana, ma i ga vana urama Gosen, upi dir a varkuvo ma tamana, ma i ga tur rikai pirana, ma i ga tal pa ra inoana, ma i ga tangi vavao a ik ta ra inoana. ");
INSERT INTO ksd_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ma Israel i ga biti tai Iosep: Iau ga upi ina mat, tago iau tar gire ra matam, ba u laun boko. ");
INSERT INTO ksd_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ma Iosep i ga biti tai ra tara na turana, ma ta diat ta ra kuba i tamana: Ina vana, ma ina ve Parao, ma ina biti tana: A umana turagu ma diat par ta ra kuba i tamagu, nina dia ga ki aro Kanaan, dia tar pot piragu. ");
INSERT INTO ksd_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ma nam ra tarai a umana tena balabalaure sip, ma dia vangvague ra bulumakau; ma dia tar agur pa kadia kikil na sip, ma kadia kuvur na bulumakau, ma kadia tabarikik par. ");
INSERT INTO ksd_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ma ba Parao na oro pa avat ma na tir avat, Ava kavava papalum? ");
INSERT INTO ksd_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","avat a biti, Kaum umana tultul dia ga vague ra umana bulumakau papa ra bung ave ga bul tana, tuk tar ta ra bung gori, avet ma ra umana tama i vevet; upi na tul tar avat ba avat a ki ta ra gunan Gosen, tago ra umana tena balabalaure vavaguai par dia da ra magit na milmilikuan pire ra tarai Aigipto. Ma Iosep i ga ruk ma i ga ve ");
INSERT INTO ksd_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Parao, i ga biti: Tamagu ma ra umana turagu, ma kadia kikil na sip, ma kadia kuvur na vavaguai, ma kadia tabarikik par i tar pot marama ra gunan Kanaan, ma gire, dia ki ta ra gunan Gosen. ");
INSERT INTO ksd_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ma i ga pilak pa ta ilima ta ra umana turana, ma i ga vaarike tar diat tai Parao. ");
INSERT INTO ksd_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ma Parao i ga tir ra umana turana: Ava kavava papalum? Ma dia ga biti tai Parao: Kaum umana tultul a umana tena balabalaure sip, avet ma ra umana tama i vevet. ");
INSERT INTO ksd_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ma dia ga biti tai Parao: Ave pot upi avet a ki na vaira ta ra gunan; tago pa ta magit ure ra umana kikil na vavaguai kai kaum umana tultul, tago ra mulmulum i tup ra gunan Kanaan; kari go ave lul u, ba una tul tar avet kaum umana tultul ba avet a ki ta ra gunan Gosen. ");
INSERT INTO ksd_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ma Parao i ga biti tai Iosep dari: Tamam ma ra tara na turam dia tar pot piram; ");
INSERT INTO ksd_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","a gunan Aigipto i langalanga piram, una vaki tamam ma ra umana turam ta ra langun i boina kakit; boina diat a ki ta ra gunan Gosen; ma ona u nunure ta umana tena tuna pire diat, una vaki diat upi diat a monamono ure kaugu lavur vavaguai. ");
INSERT INTO ksd_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ma Iosep i ga agure varuk Iakob tamana; ma Iakob i ga tata vadoane Parao. ");
INSERT INTO ksd_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Ma Parao i ga biti tai Iakob: Aivia ra kilala u tar laun vue? ");
INSERT INTO ksd_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ma Iakob i ga biti tai Parao: A kilala ure kaugu kini ra pia i varogop ma tika na mar ma a utul a vinun ot; a paupau ka ra umana bung i kaugu nilaun, ma i ga tup iau; ma pa dia varogop ma ra umana kilala kai ra umana tamagu ta kadia kini ra pia. ");
INSERT INTO ksd_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ma Iakob i ga tata vadoane Parao, ma i ga irop mulai kan ra luaina mata i Parao. ");
INSERT INTO ksd_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ma Iosep i ga vaki tamana ma ra umana turana, ma i ga tul tar ra umana kiki na gunan ta diat aro Aigipto, ta ra langun i boina kakit, ta ra gunan kai Rameses, da Parao i ga vartuluai tana. ");
INSERT INTO ksd_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ma Iosep i ga tabatabar tamana ma ra umana turana ma diat par ta ra kuba i tamana ma ra magit, varogop ma ra umana natu i diat. ");
INSERT INTO ksd_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ma pa ta magit na nian ta ra gunagunan parika, tago ra mulmulum i ga manga tup diat; damana ra gunan Aigipto ma ra gunan Kanaan dir ga bilua na kaia ure ra mulmulum. ");
INSERT INTO ksd_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ma Iosep i ga varurue ra mani parika ta ra gunan Aigipto, ma ta ra gunan Kanaan, ure ra kon dia ga kul ia me; ma Iosep i ga vung ra mani ta ra kuba i Parao. ");
INSERT INTO ksd_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ma ba dia ga tar vapar vue ra mani ta ra gunan Aigipto ma ta ra gunan Kanaan, a tarai Aigipto par dia ga vana pire Iosep, ma dia ga biti: Una tul tar ra magit na nian ta vevet, tago avet a mat ta ra luaina matam upi ra ava, tago kaveve mani i tar tukum? ");
INSERT INTO ksd_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ma Iosep i ga biti: Avat a tul tar kavava vavaguai tagu, ma ina tabatabar kia avat ure kavava vavaguai, ona pa kavava ta mani mulai. ");
INSERT INTO ksd_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ma dia ga agure kadia lavur vavaguai pire Iosep; ma Iosep i ga tul tar ra magit na nian ta diat ma i ga vatur vake ra umana os, ma ra umana sip, ma ra umana bulumakau, ma ra umana as; ma i ga tabar kia diat ma ra magit, ma i ga kale kadia lavur vavaguai ta nam ra kilala. ");
INSERT INTO ksd_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ma ba i ga par nam ra kilala, dia ga pot mulai pirana ta ra vauruana, ma dia ga biti tana: Luluai, kaveve mani i tar tukum; pa ave vapidik mule go ra magit kan ra luluai; u tar vatur vake kaveve kuvur na vavaguai; ma pa ta magit i tur valili mulai tara luaina mata i kaveve luluai; ia kaka ra pal a paka i vevet, ma kaveve pia; ");
INSERT INTO ksd_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ma ta ra ava avet a virua ta ra luaina matam, avet ma kaveve gunan? Una kul avet, ma kaveve pia ma ra magit, ma avet ma kaveve pia avet a ki na tultul pire Parao; ma una tul tar ra pat i ra kon ta vevet, upi avet a laun ma koko avet a virua, ma koko ra gunan na bil ika. ");
INSERT INTO ksd_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Io, Iosep i ga kul pa ra gunan Aigipto par upi kai Parao; tago ra tarai Aigipto par dia ga ivure kadia pia na uma, tago ra mulmulum i ga tup diat; ma Parao i ga vatur vake ra pia. ");
INSERT INTO ksd_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ma ra tarai, i ga kul vavilavilau diat par, i ga tur pa ia tai tika na langun Aigipto, ma i ga tuk tar tai ta ra tikai. ");
INSERT INTO ksd_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ma ia kaka ra pia kai ra umana tena tinabar pa i ga kul ia, tago ra umana tena tinabar dia ga kale kadia tiniba tai Parao, ma dia ga en ra tiniba Parao i ga tul tar ia ta diat; kari pa dia ga ivure kadia pia. ");
INSERT INTO ksd_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ma Iosep i ga biti tai ra tarai: Gire, iau tar kul pa avat go ieri, ma kavava pia bula, upi kai Parao, io, a pat na davai go kari, ma avat a vavaume ta ra pia. ");
INSERT INTO ksd_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ma ba ava dodoko, avat a tul tar ra vailimana pakana tai Parao, ma a ivat na pakana kavavat ure ra vinauma mulai, ma ure avava magit ma adiat ta ra kuba i vavat. ma ai ra umana natu i vavat. ");
INSERT INTO ksd_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ma dia ga biti tana: U tar valaun avet, boina una mari avet, ma avet a ki na tultul pire Parao. ");
INSERT INTO ksd_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ma Iosep i ga pait ra varkurai dari ure ra gunan Aigipto, ma i tuk tar gori, ba di tul tar ia tai Parao ra vailimana pakana magit na uma; ia kaka ra pia kai ra umana tena tinabar Parao pa i ga vatur vake. ");
INSERT INTO ksd_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ma ra tarai Israel dia ga ki ta ra gunan Aigipto, ta ra gunan Gosen, ma dia ga kale vanavana, ma dia ga tavua, ma dia ga vapeal ra umana natu i diat. ");
INSERT INTO ksd_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Ma Iakob i ga ki ta ra gunan Aigipto a vinun ma lavurua na kilala; damana Iakob i ga laun vue tika na mar ma a ivat na vinun ma lavurua na kilala. ");
INSERT INTO ksd_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ma i ga papait na maravai ra bung ba Iakob na mat i tana, ma i ga oro pa natuna Iosep, ma i ga biti tana: Ona u mari iau go, boina una vung ra limam ta ra kelakelegigu, ma una mari iau, ma una dovot piragu; koko una punang iau ta ra gunan Aigipto; ");
INSERT INTO ksd_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","dari ka: ba di tar vadiop iau varurung ma ra umana tamagu, una kari vairop iau kan ra gunan Aigipto, ma una punang iau ta kadia pia na pupunang. Ma i ga biti tana: Ina pait nam u tatike. ");
INSERT INTO ksd_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ma i ga biti tana: Una vavalima tagu; ma i ga vavalima tana. Ma Israel i ga va timtibum ta ra ul a vava. ");
INSERT INTO ksd_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ma ba i ga par go ra lavur magit, ta tikai i ga ve Iosep dari: Tamam i mait; ma dital ga varagur ma Manase ma Epraim. ");
INSERT INTO ksd_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ma tikai i ga ve Iakob dari: Gire, natum Iosep i pot piram; ma Israel i ga vaongor pa ia mulai, ma i ga ki ta ra vava. ");
INSERT INTO ksd_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ma Iakob i ga biti tai Iosep: God Dekdek Muka i ga tur kapet pa piragu aro Lus ta ra gunan Kanaan, ma i ga tata vadoane iau, ");
INSERT INTO ksd_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ma i ga biti tagu dari: Ina vapeal u, ma ina vangala u, ma ina vaki vaarike tam ra kor na tarai; ma ina tabar kaum lavur bul mur ma go ra gunan, upi kadiat vatvatikai. ");
INSERT INTO ksd_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ma go ra ura natum, nam di ga kava tar dir tam ba pa iau ga pot boko ati Aigipto, kaugu dir; Epraim ma Manase, da Ruben ma Simeon, dir kaugu. ");
INSERT INTO ksd_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ma ra umana bul ba una vangala vamur diat, kaum diat; ma diat a kap ra iang i ra ura tura i diat ta kadia tiniba. ");
INSERT INTO ksd_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ma iau, ba iau ga pot maro Padan, iau ga ligur tago Rakel i ga mat na nga, ta ra gunan Kanaan, ba ave ga vana pit ika uro Eprata, ma iau ga punang ia ta ra papar a nga uro Eprata (nina ba Beteleem). ");
INSERT INTO ksd_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ma Israel i ga gire ra ura natu i Iosep, ma i ga biti: To ia nam dir? ");
INSERT INTO ksd_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ma Iosep i ga biti tai tamana: A ura natugu go, nina God i ga tul tar dir tagu ati. Ma i ga biti. Una ben dir uti piragu, upi ina tata vadoane dir. ");
INSERT INTO ksd_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ma ra mata i Israel i ga gavul, tago a patuana, ma pa i ga nana bulu mulai; ma i ga ben dir maravai pirana; ma i ga galum dir, ma i ga tal pa dir. ");
INSERT INTO ksd_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ma Iakob i ga biti tai Iosep: Pa iau ga nuk ia ba ina gire mule ra matam, ma go God i tul tar ia tagu upi ina gire ra ura natum bula. ");
INSERT INTO ksd_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ma Iosep i ga tulue vaarike dir kan ra malmalikun na kauna, ma i ga va timtibum. ");
INSERT INTO ksd_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ma Iosep i ga vatur vake dir par, Epraim ma ra limana tuna upi na tur ta ra maira i Iakob, ma Manase ma ra mairana upi na tur ta ra lime tuna Israel, ma i ga ben dir maravai pirana. ");
INSERT INTO ksd_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ma Israel i ga tulue kodo ra limana tuna, ma i ga palagur ra ulu i Epraim ra muruna, ma ra mairana i ga vung ia ta ra ulu i Manase, ma i ga vung vabolabolo ra ura limana, tago Manase ra luaina. ");
INSERT INTO ksd_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ma i ga tata vadoane Iosep, ma i ga biti: God, nina ra ura tamagu Abaraam ma Isak dir ga vanavana ta ra luaina matana, God nina i tabatabar vamaur iau a bungbung par ta kaugu nilaun tuk tar gori, ");
INSERT INTO ksd_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ra angelo nina i ga valaun iau kan ra lavur kaina magit, na maravut go ra ura barmana; boina ba dir a kap ra iangigu ma ra iang i ra ura tamagu Abaraam ma Isak, ma na tul tar ia ta dir upi dir a kor na tarai boko ta ra rakarakan a gunagunan. ");
INSERT INTO ksd_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ma ba Iosep i ga gire ba tamana i palagur ra ulu i Epraim ma ra limana tuna, pa i ga manane, ma i ga vatur ra lima i tamana urama upi na kari vue kan ra ulu i Epraim tar ta ra ulu i Manase. ");
INSERT INTO ksd_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ma Iosep i ga biti tai tamana: Koko damana tamagu, tago go ia ra luaina; una vung ra limam tuna ta ra uluna. ");
INSERT INTO ksd_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ma tamana i ga ole, ma i ga biti: Iau nunure, natugu, iau nunure; ia bula a vuna tarai boko, ina na ngala bula. Ia kaka a muruna na ngala ta dir, ma ra umana bul mur tana diat a peal da mangoro na vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ma i ga tata vadoane dir dari: Israel na varvadoan tam dari, God na maravut u da i ga maravut Epraim ma Manase. Ma i ga vaki Epraim upi na lua ta dir ma Manase. ");
INSERT INTO ksd_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ma Israel i ga biti tai Iosep: Gire, ina mat, ma God na ki pire vavat, ma na agur pa mule avat ta ra gunan kai ra umana tama i vavat. ");
INSERT INTO ksd_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Go bula, iau tibe vangala u ma tika na gunan na lualuana, kaum iat ma vakir kai ra umana turam; nina iau ga ra pa ia ta ra tarai Amor ma kaugu pakat na vinarubu ma kaugu panak. ");
INSERT INTO ksd_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ma Iakob i ga oro pa ra umana natuna, ma i ga biti: Avat a vana varurung, upi ina ve avat ta ra magit ba na tadav avat ta ra umana bung namur: ");
INSERT INTO ksd_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Avat a ki rangup ma avat a valongore, avat a umana natu i Iakob; Ma avat a nuk pa ra tinata kai Israel tama i vavat. ");
INSERT INTO ksd_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, u kaugu luaina, kaugu niongor, ma ra turpai kaugu dekdek; I boina tuna kaum kini, ma i ngala kakit ra dekdekim. ");
INSERT INTO ksd_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","U varogop ma ra tava i buabuai, ma pa una vatur vake ra kini lua; Tago u tar ko rikai ta ra vava kai tamam Ma u vadur pa ia; i ga tutua ta kaugu vava. ");
INSERT INTO ksd_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon ma Levi dir turana, Kadir pakat i da ra vargal na vinarubu. ");
INSERT INTO ksd_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","A tulungeagu, koko una ruk ta kadir kivung, Ma koko dital a ki varurung ma kaugu variru; Tago ta kadir kulot dir ga ubu doko ra tarai, Ma ta ra dekdek na nuknuk i dir, dir ga kita vakaina ra umana bulumakau. ");
INSERT INTO ksd_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Na kaina kadir kankan, tago i ga ngangal, Ma kadir kulot, tago i ga bilak; Ina tibe varbaiane dir ta ra gunan kai Iakob, Ma ina vue imimire dir ta ra gunan kai Israel. ");
INSERT INTO ksd_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Iuda, a tara na turam diat a pite pa u, A limam na va ta ra inoa i kaum lavur ebar; A lavur natu i tamam diat a va timtibum piram. ");
INSERT INTO ksd_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Iuda ia ra nat na leon; Natugu, u tar ko rikai, ma u kap ra magit u ga ub ia; I tar ki bul keke, ma i tar diop da ra leon, Ma da ra kon, a tana; to ia na vangun ia? ");
INSERT INTO ksd_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","A buka na king pa na takari kan Iuda, Ma ra buka na varkurai pa na takari kan ra ura kauna, Tuk tar ta nam ra bung ba Silo na pot, Ma ra umana vuna tarai diat a toratorom tana. ");
INSERT INTO ksd_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Na veve kana nat na os ta ra davai na vain, Ma kana nat na as ta ra davai na vain i ngatngat; I tar puk vagomgom kana kolot ta ra polo na vain, Ma kana mal na minong ta ra gapu i ra vuai ra vain. ");
INSERT INTO ksd_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","A kiau na matana na meme ma ra tava na vain, Ma ra pal a ngiene na pua ta ra polo na u. ");
INSERT INTO ksd_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulun na ki ra valvalian, Ma ra umana parau diat a pukapukai tana, Ma kana langun na tuk tar uro Sidon. ");
INSERT INTO ksd_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakar a ongor na as, I va livuan ta ra umana kikil na sip. ");
INSERT INTO ksd_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ma i gire ra vava i boina, ma ra gunan i vakak; Ma i tul tar ra ul a varana upi na pupuak, Ma i ki na vilavilau ma ra papalum. ");
INSERT INTO ksd_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan na kure ra taraina da tikai ta ra umana vuna tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan na da ra vui ta ra nga, a kaina vui ta ra pal a nga, Nina i karat ra inabut i ra umana os; Upi nina i ki tana na bura murmur. ");
INSERT INTO ksd_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Luluai, iau tar ki ung upi kaum valavalaun. ");
INSERT INTO ksd_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad, a loko na tarai na vinarubu dia varkamkamir pirana, Ma ia iat na rua kamkamir ra inabut na kau i diat. ");
INSERT INTO ksd_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser, ana gem na bira, Ma na vuai ra kalami na magit na nian ba na topa ra king. ");
INSERT INTO ksd_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naptali i da ra me di tar pala vue. I vakak kana tinata. ");
INSERT INTO ksd_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Iosep a nat na davai i manga vuai, A nat na davai i tur pire ra kivu na tava, Ma ra ingaingarina dia ko lake ra liplip. ");
INSERT INTO ksd_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","A umana tena panak dia tar manga vakaina, Dia tut ia, ma dia korot mur ia; ");
INSERT INTO ksd_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ma kana panak i ongor vatikai, Ma di ga vadekdek ra limana, Ta ra lima i ra Tena Ongor kai Iakob; Ta ra iang i ra tena balabalaure, ra vat ki kai Israel; ");
INSERT INTO ksd_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Maia, ta ra God kai tamam, nina ba na maravut u, Ma tai ra Dekdek Muka, nina ba na vadoane u; Ma ra nidoan marama ra bala na bakut, A lavur nidoan mara ra tung ta ra bala na pia, A labur nidoan ta ra u na vavina ma ra tatal na bul, ");
INSERT INTO ksd_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","A umana nidoan kai tamam Dia tar lia ta ra umana nidoan kai kaugu umana lualua, Di tuk tar ta ra langun aro iat kai ra umana lualuana i tur tukum; Diat a ki ta ra ulu i Iosep, Ma ta ra tunurot na ulu i nina i luluai pire ra tara na turana. ");
INSERT INTO ksd_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Beniamin, a leing na pap, a tena varkarat; Ta ra malana na konakonom ra magit i ga ub ia, Ma ta ra ravian na tibe ra magit i ga ra pa ia. ");
INSERT INTO ksd_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Diat par go a vinun ma a ivu vuna tarai Israel, ma go ra tinata tama i diat i ga tatike ta diat ma i ga tata vadoane diat me, tikatikai varogop ma kana varvadoan iat. ");
INSERT INTO ksd_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ma i ga tul tar ia ta diat ma i ga biti ta diat: Iau ina ki varurung boko ma ra umana tamagu; avat a punang iau pire ra umana tamagu ta ra niiga nina ta ra pia na uma kai Epron a te Ket; ");
INSERT INTO ksd_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ta ra niiga ta ra pia na uma kai Makpela, maravai Mamre ta ra gunan Kanaan, nina Abaraam i ga kul kapi ia varurung ma ra pia na uma tai Epron a te Ket, upi na vatur vake ta pia na pupunang tana; ");
INSERT INTO ksd_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","di ga punang Abaraam tana, dir ma Sara kana taulai, ma di ga punang Isak tana, dir ma Rebeka kana taulai, ma iau ga punang Lea tana; ");
INSERT INTO ksd_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","a pia na uma ma ra niiga tana, nina di ga kul kapi ia ta ra umana natu i Ket. ");
INSERT INTO ksd_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ma ba Iakob i ga ngo ma ra vartuluai pire ra umana natuna, i ga vung ra kauna mulai ta ra vava, ma i ga vung vue ra tulungeana, ma i ga ki varurung ma ra umana tamana. ");
INSERT INTO ksd_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Ma Iosep i ga bura taun ra mata i tamana, ma i ga tangi, ma i ga galgalum ia. ");
INSERT INTO ksd_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ma Iosep i ga vartuluai pire kana umana tultul, ra umana tena punupuk, upi diat a kolo bat ra minat i tamana; ma ra umana tena punupuk dia ga kolo bat Israel. ");
INSERT INTO ksd_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ma dia ga varvakai tana a ivat na vinun na bung, tago ta ra ivat na vinun na bung di pait ot pa ra kinokolo bat na minat; ma ra tarai Aigipto dia ga tangie lavurua na vinun na bung ot. ");
INSERT INTO ksd_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ma ba i ga tar par ra e na korkor ure, Iosep i ga biti tai ra kuba i Parao dari: Ari ona ava mari iau, avat a ve Parao dari: ");
INSERT INTO ksd_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Tamagu i vo ra vavalima tagu ma i biti: Gire, ina mat go; una punang iau ta kaugu babang na minat nina iau ga kal ia ta ra gunan Kanaan. Io, una tul tar iau ba ina vana urama, upi ina punang tamagu, ma ina lilikun mulai. ");
INSERT INTO ksd_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ma Parao i ga biti: Una vana, ma una punang tamam, da ra vavalima i ga vo tar ia tam. ");
INSERT INTO ksd_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ma Iosep i ga vana upi na punang tamana, diat ma ra umana tultul kai Parao par, a lavur patuana ta ra kubana, ma ra lavur patuana ta ra gunan Aigipto, ");
INSERT INTO ksd_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ma diat par ta ra kuba i Iosep, ma ra tara na turana, ma diat ta ra kuba i tamana; ia kaka ra umana natu i diat, ma kadia kuvur na sip, ma kadia kikil na bulumakau i ga ki ta ra gunan Gosen. ");
INSERT INTO ksd_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ma ra umana kiki na vinavana, ma ra tarai dia ki ra os, dia ga tule Iosep; damana a ngala na kor diat. ");
INSERT INTO ksd_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ma dia ga tadav Atad, a pia di ruarua rama vue ra pat i ra kon tana, ta ra papar a Iordan, ma dia ga tangtangie ma ra ngala na tinangi, ma i ga tup diat; ma dia ga korkor ure tamana lavurua na bung. ");
INSERT INTO ksd_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ma ba ra tarai ta nam ra gunan, a umana te Kanaan, dia ga gire ra tinangi ta ra gunan Atad, dia ga biti: Go ra tinangi i tup ra tarai Aigipto; kari di ga vatang ra iangina ba Abel-Misraim, ma i tur ta ra papar a Iordan. ");
INSERT INTO ksd_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ma ra umana natuna dia ga pait nam ra magit i ga vartuluai ta diat me, ");
INSERT INTO ksd_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","tago ra umana natuna dia ga puak pa ia ta ra gunan Kanaan, ma dia ga punang ia ta ra babang ta ra pia na uma kai Makpela, nina Abaraam i ga kul pa ia, dir ma ra pia na uma, upi na vatur vake ta gunan na pupunang, tai Epron a te Ket, maravai Mamre. ");
INSERT INTO ksd_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ma Iosep i ga lilikun mulai uro Aigipto, diat ma ra tara na turana, ma diat par dia ga varagur me urama upi diat a punang tamana, ba di ga pait ot pa ra pupunang. ");
INSERT INTO ksd_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ma ba ra tara na tura i Iosep dia ga gire ba tama i diat i ga tar mat, dia ga biti: Kan Iosep na milikuane dat ma na bali vapar ra lavur kaina magit da ga pait ia pirana. ");
INSERT INTO ksd_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ma dia ga tulue ra tinata tadav Iosep dari: Tamam i vartuluai pire vevet ba pa i ga mat boko dari: ");
INSERT INTO ksd_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Avat a biti tai Iosep: Boina una nuk vue ra umana nirara kai ra umana turam ma kadia kaina mangamangana, tago dia ga pait ra kaina piram. Ma go i boina ba una pun vue ra nirara kai ra umana tultul kai ra God kai tamam. Ma Iosep i ga tangi ba dia ga tata me. ");
INSERT INTO ksd_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ma ra umana turana dia ga vana, ma dia ga bura timtibum pirana, ma dia ga biti: Gire, avet kaum tarai na tultul. ");
INSERT INTO ksd_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ma Iosep i ga biti ta diat: Koko avat a burut; dave, iau ki ta ra kiki kai God vang? ");
INSERT INTO ksd_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","A dovotina a nuknuk i vavat upi avat a pait ra kaina tagu, ma a nuknuk i God upi na boina, upi na pait kapi ra magit da gire gori, a valavalaun ure mangoro na tarai. ");
INSERT INTO ksd_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Io, koko avat a burburut; ina mataure avat ma ra umana natu i vavat. Ma i vango diat, ma i ga tata na varmari ta diat. ");
INSERT INTO ksd_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Ma Iosep i ga ki Aigipto, diat ma ra tarai ta ra kuba i tamana; ma Iosep i ga laun pa tika na mar ma a vinun na kilala. ");
INSERT INTO ksd_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ma Iosep i ga gire ra umana natu i tubu i Epraim, ma ra umana natu i Makir, natu i Manase, dia ga ki bula ta ra kauna. ");
INSERT INTO ksd_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ma Iosep i ga biti tai ra tara na turana: Ina mat, ma a tuna, God na laume kapi avat ma na agure vairop avat kan go ra gunan tadav nam ra gunan i ga vavalima tar ia tai Abaraam, Isak ma Iakob. ");
INSERT INTO ksd_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ma Iosep i ga vatur vake ra vavalima ta ra umana natu i Israel, ma i ga biti: God na laume kapi avat, ma avat a kap vakariu ra lavur urugu. ");
INSERT INTO ksd_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Damana Iosep i ga mat, ba i ga laun vue tika na mar ma a vinun na kilala ot; ma di ga kolo bat ra minatina, ma dia ga vung ia ta ra bok na minat aro Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Go ra iang i diat ra umana natu i Israel, diat ba dia ga vana uro Aigipto; diat par ma ra tarai ta ra kuba i diat dia ga varagur ma Iakob: ");
INSERT INTO ksd_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Levi, ma Iuda; ");
INSERT INTO ksd_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakar, Sebulun ma Beniamin; ");
INSERT INTO ksd_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan ma Naptali, Gad ma Aser. ");
INSERT INTO ksd_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Ma ra lavur natu i Iakob lavurua na vinun diat; ma Iosep i ga tar ki lua aro Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ma Iosep i ga mat ma ra umana turana par, ma nam ra taun tarai par bula. ");
INSERT INTO ksd_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ma ra tarai Israel dia ga vangala mangoro na natu i diat, ma dia ga tavua na kaia, ma dia ga peal, ma dia ga ongor tuna; ma ra gunan i ga kor ma diat. ");
INSERT INTO ksd_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Io, ma tika na kalamana king i ga kure Aigipto, ma pa i ga nunure Iosep. ");
INSERT INTO ksd_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ma i ga biti tai kana tarai: Gire, i peal ra tarai Israel ma dia ongor, ma dat pata; ");
INSERT INTO ksd_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","boina dat a varkurai ma ra kabinana ure diat, kan diat a vapeal.diat mulai, ma ona ta vinarubu na vana rikai, diat a tur guvai ma kada umana ebar, ma diat a varubu ma dat, ma diat a vana oai kan ra gunan. ");
INSERT INTO ksd_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Kari di ga tibe ra umana lualua na papalum ta diat, upi diat a vakadik diat ma ra mamat na papalum. Ma dia ga pait ra ivu pia na pal na vuvuvung, Pitom ma Rameses, upi kai Parao. ");
INSERT INTO ksd_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ma ba dia ga manga vakadik diat, dia ga manga tavua ka, ma dia ga pepeal. Ma dia ga milikuane ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Ma ra tarai Aigipto dia ga tul tar ra dekdek na papalum pire ra tarai Israel; ");
INSERT INTO ksd_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ma dia ga valigur kadia kini ma ra mamat na papalum ta ra pia bulit, ma ta ra tuntun vat na pia ma ta ra lavur mangana papalum ta ra umauma; dia ga vovo tar ra lavur papalum ta diat ma ra umana dekdek na varkurai. ");
INSERT INTO ksd_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ma ra king Aigipto i ga tata pire ra ura vavina Ebraio, a ura rena varkakava, tikai a iangina Sipra, ma ta ra tikai Pua; ");
INSERT INTO ksd_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","ma i biti dari: Ona amur a varkakava pire ra vaden Ebraio, ma amur gire diat ta ra kiki na kinakava ma dia kava ta bul tutana, io, amur a doka, ma ona ra bul vavina, na laun uka. ");
INSERT INTO ksd_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ma ra umana tena varkakava dia ga ru God ma pa dia ga torom ta ra vartuluai kai ra king Aigipto, ma dia ga nur vue ra umana bul tutana upi diat a laun. ");
INSERT INTO ksd_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ma ra king Aigipto i ga vartuluai upi ra umana tena varkakava, ma i ga biti ta diat: Ta ra ava ava nur vue ra umana bul tutana, upi diat a laun uka? ");
INSERT INTO ksd_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ma ra umana tena varkakava dia ga biti tai Parao: Tago ra vaden Ebraio pa dia vardada ma ra vaden Aigipto; tago dia lulut, ma dia kava vue ra bul ba pa ta tena varkakava i vut boko pire diat. ");
INSERT INTO ksd_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Ma God i ga maravut ra umana tena varkakava; ma ra tarai dia ga pepeal ma dia ga ongor tuna. ");
INSERT INTO ksd_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Ma tago ra umana tena varkakava dia ga ru God, i ga vapealane ra umana natu i diat. ");
INSERT INTO ksd_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ma Parao i ga vartuluai pire kana tarai par dari: A umana bul tutana par ba di kava diat, avat a vue diat ta ra tava alir, ma ra umana bul vavina par diat a laun. ");
INSERT INTO ksd_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ma tika na tutana ta ra kuba i Levi i ga vana ma i ga taule tika na vavina, a bul mur tai Levi. ");
INSERT INTO ksd_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ma ra vavina i ga lalau pa, ma i ga kava tika na bul tutana; ma ba i ga gire ba a vakak na bul ik, io, i ga ive a utul a gai. ");
INSERT INTO ksd_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ma ba i ga mama ive mule i ga pait kana ta oaga ik ma ra vuvur, ma i ga vabulit bat ia ma ra pia i bulit ma namur a bulit na davai, ma i ga vadiop ra bul tana, ma i ga vung ia ta ra titiparar i ga tavua ta ra papar a tava alir. ");
INSERT INTO ksd_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ma taina i ga turtur aro vailik a ik upi na giragire ure ba na dave bar. ");
INSERT INTO ksd_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ma natu i Parao, a vavina, i ga vana ur upi na gumu ta ra tava alir; ma kana umana tultul na vavina dia ga val ta ra papar a tava; ma ia iat i ga gire ra oaga ik ta ra titiparar, ma i ga tulue tika na tultul na vavina upi na vila pa ia. ");
INSERT INTO ksd_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ma i ga papa ia, ma i ga gire ra bul; ma ra kuramana i ga tangi. Ma i ga mari ia, ma i ga biti: Go tikai ta diat ra umana bul kai ra tarai Ebraio. ");
INSERT INTO ksd_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ma taina i ga biti tai natu i Parao: Dave, kan ina vana ma ina oro pa tika na vavina Ebraio upi na vamel ra bul upi kaum. ");
INSERT INTO ksd_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ma natu i Parao i ga biti tana: Una vana. Ma ra inip na vavina i ga vana ma i ga oro pa na i ra bul. ");
INSERT INTO ksd_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Ma natu i Parao i ga biti tana: Una kap vue go ra bul, ma una vamel ia upi kaugu, ma ina vapuak u. Ma ra vavina i ga puak pa ra bul, ma i ga vamel ia. ");
INSERT INTO ksd_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ma ra bul i ga taiak, ma i ga agure tadav natu i Parao, ma i ga da natuna. Ma i ga vaiang tar ra iangina ba Moses, ma i ga biti: Tago iau tar al valaun pa ia kan ra tava. ");
INSERT INTO ksd_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ma ba Moses i ga ngala, i ga irop tadav ra umana turana, ma i ga gire kadia mamat na papalum; ma i ga gire tika na te Aigipto i ga kita tika na tutana Ebraio, tikai ta diat ra umana turana. ");
INSERT INTO ksd_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Ma i ga lingalingan vurvurbit, ma ba i ga gire ba pa ta tutana abara, io, i ga ubu ra te Aigipto ma i ga punang ia ta ra veo. ");
INSERT INTO ksd_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ma ta ra vauruana bung i ga irop bula, ma gire, ta ura tutana Ebraio dir ga varngangar; ma i ga biti tai nina i ga rara: Ta ra ava u kita talaim? ");
INSERT INTO ksd_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ma i ga biti: To ia i ga vaki u, upi una luluai ba tena varkurai pire vevet? U mainge vang upi una ubu iau, da u ga ubu ra te Aigipto? Ma Moses i ga burut, ma i ga biti: A dovotina, nam ra magit i tar po rikai. ");
INSERT INTO ksd_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ma ba Parao i ga valongore go ra magit, i ga mainge upi na doko Moses. Ma Moses i ga takap kan ra mata i Parao, ma i ga ki ra gunan Midian; ma i ga ki pire tika na kivu. ");
INSERT INTO ksd_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ma ra tena tinabar ta ra gunan Midian i ga tar vangala lavurua na natuna, lavurua na vavina; ma dia ga vut upi diat a kulup na tava, ma dia ga vabuka ra umana turtur na tava upi diat a vamomo ra kikil na sip kai tama i diat. ");
INSERT INTO ksd_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ma ra umana tena balabalaure sip dia ga vut, ma dia ga korot vue diat. Ma Moses i ga tur ma i ga maravut diat, ma i ga vamomo kadia kikil na sip. ");
INSERT INTO ksd_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ma ba dia ga lilikun tadav Reuel tama i diat, i ga tir diat: I dave, tago ava tar pot lolalolo gori? ");
INSERT INTO ksd_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ma dia ga biti: Tika na te Aigipto i valaun kapi avet kan ra lima i ra umana tena balabalaure sip, ma i kulup ra tava bula ure avet, ma i vamomo ra kiki na sip. ");
INSERT INTO ksd_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ma i gat tir ra umana natuna dari: Ma akave? Ta ra ava ava ga vana balakane? Avat a oro pa ia upi na ian. ");
INSERT INTO ksd_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Ma Moses ia ga mulaot upi na ki pire nam ra tutana; ma i ga tul tar natuna tai Moses, a vavina, a iangina Sipora. ");
INSERT INTO ksd_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ma i ga kava tika na bul tutana, ma i ga vaiang tar ra iangina ba Gersom, tago i ga biti: Iau tar ki na vaira ta ra gunan na vaira. ");
INSERT INTO ksd_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ma ba i ga par mangoro na bung, a king Aigipto i ga mat; ma ra tarai Israel dia ga riri ure kadia kini na vilavilau, ma dia ga tangi, ma kadia tinangi ure kadia kini na vilavilau i ga tutua rikai urama tadav God. ");
INSERT INTO ksd_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Ma God i ga valongore kadia tinangi, ma God i ga nuk pa kana kunubu pire Abaraam, Isak ma Iakob. ");
INSERT INTO ksd_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Ma God i ga gire ung ra tarai Israel, ma God i ga matoto ta diat. ");
INSERT INTO ksd_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ma Moses i ga balaure ra umana sip kai Ietro, nimuna, a tena tinabar aro Midian, ma i ga agure ra kikil na sip uro iat ta ra bil, ma i ga tadav ra luana kai God, a iangina Koreb. ");
INSERT INTO ksd_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ma ra angelo kai ra Luluai i ga tur kapet pa pirana ta ra biro na iap, livuan ta ra ingar i tika na davai na kait; ma i ga bobe, ma gire, a davai i ga birabirao ma ra davai pa i ga panie. ");
INSERT INTO ksd_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ma Moses i ga biti: Ina vana maravai boko upi ina gire go ra ngala na ninana ma ra magit i vuna tana, tago ra davai pa i panie. ");
INSERT INTO ksd_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ma ba ra Luluai i ga gire ba i ga vana maravai upi na gire pa ia, God i ga tata pirana maro livuan ta ra davai, ma i ga biti: Moses, Moses! ");
INSERT INTO ksd_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ma i ga biti: Iau go kari. Ma i ga biti: Koko una vana maravai uti; una pala vue ra pal a kaum, tago ra pakana u tur tana a pia i gomgom. ");
INSERT INTO ksd_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ma i ga biti bula: Iau a God kai tamam, a God kai Abaraam, a God kai Isak ma a God kai Iakob. Ma Moses i ga ive ra matana, tago i ga burutue ra mata i God. ");
INSERT INTO ksd_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ma ra Luluai i ga biti: A dovot iau tar gire ra lavur magit na varmonong i tup kaugu tarai aro Aigipto, ma iau tar valongore kadia tinangi i vuna ta diat dia vamamat tar ra papalum ta diat, tago iau nunure kadia niligur; ");
INSERT INTO ksd_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ma iau tar vana ba upi ina valaun diat kan ra lima i ra tarai Aigipto, ma upi ina agure vairop diat ta nam ra gunan, tadav ra gunan i boina ma i ngala, tadav ra gunan ba na alir tana a polo na u ma ra polo na livur i kalami, tadav ra gunan kai ra tarai Kanaan, ma ra tarai Ket, ma ra tarai Amor, ma ra tarai Peres, ma ra tarai Kivi, ma ra tarai Iebus. ");
INSERT INTO ksd_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ma go, gire, a tinangi kai ra tarai Israel i tar tadav iau, ma iau tar gire bula ra mangamangana ra tarai Aigipto dia ki taun diat me. ");
INSERT INTO ksd_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Io, una mai, ina tulue u tadav Parao, upi una agure vairop kaugu tarai, a umana natu i Israel, kan ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ma Moses i ga biti ta God: Iau to ia, upi ina tadav Parao, ma upi ina agure vairop ra tarai Israel kan ra gunan Aigipto? ");
INSERT INTO ksd_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ma i ga biti: Ina ki piram, ma go ia ra vakilang piram ba iau tulue u: ba u tar agure vairop ra tarai, avat a lotu tadav God ta go ra luana. ");
INSERT INTO ksd_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ma Moses i ga biti tai God: Gire, ba ina pot pire ra tarai Israel, ma ina ve diat dari, A God kai ra lavur tama i vavat i tar tulue iau, ma dia tir iau dari, To ia ra iangina? ina biti dave ta diat? ");
INSERT INTO ksd_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ma God i ga biti tai Moses: Iau Iat; ma i ga biti: Una ve ra tarai Israel dari, Iau Iat i tar tulue iau tadav avat. ");
INSERT INTO ksd_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ma God i ga biti bula tai Moses: Una ve ra tarai Israel a Luluai, a God kai ra umana tama i vavat, a God kai Abaraam, a God kai Isak, ma a God kai Iakob, i tar tulue iau pire vavat; go ra iangigu vatikai, ma go kaugu vakilang pire ra lavur taun tarai. ");
INSERT INTO ksd_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Una vana, una oro guve ra umana patuana kai rat tarai Israel, ma una biti ta diat: Ra Luluai, a God kai ra umana tama i vavat, a God kai Abaraam, ma kai Isak ma kai Iakob, i tar tur kapet pa piragu, ma i biti: Iau tar laume kapi avat ma iau tar gire ra lavur magit di pait ia ta vavat aro Aigipto; ");
INSERT INTO ksd_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ma iau tar biti: Ina valaun avat kan ra lavur magit na varmonong aro Aigipto, ma ina agur pa avat ta ra gunan kai ra tarai Kanaan, ma ra tarai Ket, ma ra tarai Amor, ma ra tarai Peres, ma ra tarai Kivi, ma ra tarai Iebus, a gunan ba i peal ra polo na u tana ma ra polo na livur i kalami. ");
INSERT INTO ksd_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ma diat a torom ta ra nilaim; ma u, avat ma ra umana patuana kai ra tarai Israel, avat a vana tadav ra king Aigipto, ma avat a biti tana dari: Ra Luluai, a God kai ra tarai Ebraio, i tar tur kapet pa pire vevet; ma go i boina ba una pala vue avet, upi avet a vana ta ra bil, ma na varogop ma ra vinavana di pait ia ta ra utul a bung, upi avet a pait ra tinabar tadav ra Luluai kaveve God. ");
INSERT INTO ksd_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ma iau nunure ba ra king Aigipto pa na mulaot upi avat a vana, ona pa na kairane ra dekdek na limagu. ");
INSERT INTO ksd_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ma ina tulue ra limagu, ma ina kita Aigipto ma ra lavur papalum na padapada varvo, nina ba ina pait ia livuan ta diat, ma namur na pala vue avat. ");
INSERT INTO ksd_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Ma ra tarai Aigipto diat a mari boko go ra tarai; ma ta nam ra bung ba ava vana, vakir avat a vana vakuku; ");
INSERT INTO ksd_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","na dari ka: a vaden par diat a lul ra umana talai diat tikatikai, ma diat dia ki me ta ra kuba i diat, upi ra umana ngatngat na marmar di pait ia ma ra silva ma ra goled, ma upi ra umana mal; ma avat a mar ra umana natu i vavat me, a umana tutana ma ra umana vavina; ma avat a vatur varane diat tai ra tarai Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ma Moses i ga tata bali ia, ma i ga biti: Ma gire, pa diat a kapupi iau, ma pa diat a torom ta ra nilaigu; tago diat a biti ke: Ra Luluai pa i ga tur kapet pa piram. ");
INSERT INTO ksd_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ma ra Luluai i ga biti tana: Ava nam ta ra limam? Ma i ga biti: A buka. ");
INSERT INTO ksd_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ma i ga biti: Una vue tar ia ura ra pia. Ma i ga vue tar ia ura ra pia, ma i ga vui ka; ma Moses i ga vilau kan ia ka. ");
INSERT INTO ksd_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ma ra Luluai i ga biti tai Moses: Una tulue ra limam, ma una vatur vake ta ra taukuna; ma i ga tulue ra limana ma i ga kinim vake, ma a buka mulai ta ra limana; ");
INSERT INTO ksd_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","upi diat a kapupi ia ba ra Luluai, a God kai ra lavur tama i diat, a God kai Abaraam, a God kai Isak ma ra God kai Iakob i ga tur kapet pa piram. ");
INSERT INTO ksd_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ma ra Luluai i ga biti bula tana: Io, una vung ra limam ta ra bongobongom. Ma i ga vung ra limana ta ra bongobongono; ma ba i tak vue mule, io, ra limana i ga vukavuka, i ga pua da ra kabang. ");
INSERT INTO ksd_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ma i ga biti: Una vung ra limam ta ra bongobongom mulai. Ma i ga vung ra limana ta ra bongobongono mulai, ma ba i tak vue mule kan ra bongobongono, io, i ga varogop mulai ma ra pal a pakana parika. ");
INSERT INTO ksd_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ma ari ona pa dia nurnur tam, ma ona pa dia valongore ra nilai ra luaina vakilang, diat a nurnur boko ta ra nilai ra vauruana. ");
INSERT INTO ksd_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ma ona pa dia kapupi go ra ura vakilang, ma ona pa dia torom ta ra nilaim, una kulupe ra tava ta ra tava alir, ma una lingire tar ia ta ra pia i ge; ma ra tava nina una ga kulupe kan ra tava alir na da ra gap ta ra pia i ge. ");
INSERT INTO ksd_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ma Moses i ga biti tai ra Luluai: Luluai, vakir iau a tena tinata amana, ma go bula papa ra bung ba u ga tata pire kaum tultul, pata; tago kaugu tinata i vovovon ika, ma ra karameagu i mamat. ");
INSERT INTO ksd_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ma ra Luluai i ga biti tana: To ia i ga pait ra ngie i ra tarai, ma to ia i vaki ra bombom, ba ra vaut, ba nina i nana kapa, ba ra pula? Vakir iau iat ra Luluai? ");
INSERT INTO ksd_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Io, go una vana, ma ina maravut ra ngiem, ma ina vateten tar ra magit tam ba una tatike. ");
INSERT INTO ksd_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ma i ga biti: Luluai, una tulue ta enana tutana nina ba u mainge. ");
INSERT INTO ksd_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ma ra kankan kai ra Luluai i ga tut ure Moses, ma i ga biti: Vakir turam Aron go kari, a tutana ta ra vuna tarai Levi? Iau nunure ba a tena tinata. Ma gire, i vana rikai ma i totongo up u; ma ona na gire u na gugu ra balana. ");
INSERT INTO ksd_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ma una tata pirana, ma una vung ra tinata ta ra ngiene; ma ina maravut ra ngiem ma ra ngiene bula, ma ina vateten tar nam ra tinata ta mumur ba amur a tatike. ");
INSERT INTO ksd_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ma Aron na ve ra tarai ta kaum tinata, ma na dari, ba ia na da ra ngiem, ma u, una da God pirana. ");
INSERT INTO ksd_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ma una vatur vake go ra buka ta ra limam, upi una pait ra umana vakilang me. ");
INSERT INTO ksd_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Ma Moses i ga vana, ma i ga lilikun tadav nimuna Ietro, ma i ga biti tana: Una pala vue iau, upi ina lilikun tadav ra umana turagu ta ra gunan Aigipto, upi ina gire boko ba dia laun ba pata. Ma Ietro i ga biti tai Moses: Una vana ma ra malmal. ");
INSERT INTO ksd_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ma ra Luluai i ga biti ta Moses aro Midian: Una vana, una lilikun uro Aigipto, tago nam ra tarai dia ga mainge ba diat a doko u, dia tar mat par. ");
INSERT INTO ksd_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ma Moses i ga vako kana taulai ma ra ura natuna, a ura tutana, tai tika na as, ma i ga talil tadav ra gunan Aigipto; ma Moses i ga vatur vake ra buka ta ra limana. ");
INSERT INTO ksd_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Ma ra Luluai i ga biti tai Moses: Ba u tar pot mulai aro Aigipto, boina una pait nam ra lavur vakilang na kinaian ta ra luaina mata i Parao, ba iau ga tul tar diat i tam; ma ina valeo ra balana, ma pa na pala vue ra tarai. ");
INSERT INTO ksd_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ma una biti tai Parao: Ra Luluai i biti dari, Israel natugu, a luaina; ");
INSERT INTO ksd_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ma iau tar ve u, Una pala vue natugu upi na lotu piragu; ma u tar ole upi na vana, gire, ina ubu ra luaina natum. ");
INSERT INTO ksd_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ma na nga, ta ra pal na vavagil, ra Luluai i barat ia, ma i mainge ba na ub ia. ");
INSERT INTO ksd_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Ma Sipora i ga tak pa tika na pakana koto, ma i ga poko kikil natuna, ma i ga vung tar ra palina ta ra kauna, ma i ga biti: U, u da ra taulai kalama na gap piragu. ");
INSERT INTO ksd_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Damana i ga nur vue. Ma namur i ga biti, A taulai kalama na gap, ure ra pokakikil. ");
INSERT INTO ksd_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ma ra Luluai i ga biti tai Aron: Una vana ta ra bil, una totongo upi Moses. Ma i ga vana, ma dir ga varkuvo ta ra luana kai God, ma dir ga vargalum. ");
INSERT INTO ksd_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ma Moses i ga vateten tar ra lavur tinata kai ra Luluai tai Aron, nina i ga tulue me, ma ra lavur vakilang bula ba i ga tul tar ia. ");
INSERT INTO ksd_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ma Moses ma Aron dir ga vana, ma dir ga ting varurue ra lavur patuana kai ra tarai Israel; ");
INSERT INTO ksd_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","ma Aron i ga vatang nam ra lavur tinata ba ra Luluai i ga tatike tar ia tai Moses; ma i ga pait ra umana vakilang ta ra mata i ra tarai. ");
INSERT INTO ksd_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Ma ra tarai dia ga kapupi ia; ma ba dia ga valongore ba ra Luluai i ga laume kapi ra tarai Israel, ma ba i ga tar gire kadia kini ta ra magit na varmonong, dia ga tur rururu ma dia ga lotu. ");
INSERT INTO ksd_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ma namur Moses ma Aron dir ga pot ma dir ga biti tai Parao: Ra Luluai, a God kai ra tarai Israel, i ga biti dari: Una pala vue kaugu tarai, upi diat a vana ma diat a pait ra lukara na lotu piragu ta ra bil. ");
INSERT INTO ksd_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ma Parao i ga biti: To ia ra Luluai, upi ina torom ta ra nilaina, ma upi ina pala vue Israel? Pa iau nunure ra Luluai, ma tikai bula, pa ina pala vue Israel. ");
INSERT INTO ksd_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ma dir ga biti: A God kai ra tarai Ebraio i tur na vevei pire vevet; i boina una pala vue avet, upi avet a vana ta ra bil, da ra vinavana na utul a bung, upi avet a pait ra tinabar tadav ra Luluai, kaveve God. kan na tadav avet ma ra kaina minait, ba ma ra pakat na vinarubu. ");
INSERT INTO ksd_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ma ra king Aigipto i ga biti ta dir: Moses amur ma Aron, ta ra ava amur tur bat ra tarai ta kadia papalum? Avat a vana muka ta ra papalum di tar kure tar ia ta vavat. ");
INSERT INTO ksd_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Ma Parao i ga biti: Gire, go i tar peal ra tarai ta ra gunan, ma amur pala vue diat ta kadia papalum. ");
INSERT INTO ksd_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ma ta nam ra bung iat Parao i ga vartuluai pire ra umana lualua na papalum kai ra tarai ma tadav kadia umana monamono ma i ga biti: ");
INSERT INTO ksd_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Koko avat a tul tar mule ra kunai ta ra tarai upi diat a pait ra umana vat na pia me, da ava ga pait ia tuk tar ta ra bung gori; boina ba diat iat, diat a vana ma diat a varurue. ");
INSERT INTO ksd_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ma nam ra umana vat na pia par di ga tibe tar ia ta diat, upi diat a pait ia, tuk tar ta ra bung gori, avat a kure tar ia mulai ta diat; koko avat a nur vue ta ik tana, tago dia libur uka. Kari dia manga lulul ma dia biti: Una pala vue avet, upi avet a vana ma avet a pait ra tinabar tadav kaveve God. ");
INSERT INTO ksd_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Da vakakap tar ra mamat na papalum ta ra tarai upi na tup diat, ma koko diat a nuk pa mule ra lavur tinata vavaongo. ");
INSERT INTO ksd_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ma ra umana lualua na papalum kai ra tarai, ma kadia umana monamono bula, dia ga vana pire diat, ma dia ga biti tai ra tarai: Parao i biti dari, Pa ina tul tar ta kunai mulai ta vavat. ");
INSERT INTO ksd_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Avat iat, avat a vana, ma avat a vila pa ra kunai ta nam ra gunan ba ava gire tadav ia tana; tago pa da vaikilik muka kavava papalum. ");
INSERT INTO ksd_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Damana ra tarai dia ga vana vurvurbit ta ra gunagunan Aigipto par, upi diat a varurue ta kunai. ");
INSERT INTO ksd_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Ma ra umana lualua na papalum dia ga varvargat diat dari: Avat a pait ot pa kavava papalum, da di ga tibe tar ia ta vavat ure ra bungbung par, varogop lua ba di ga tul tar ra kunai ta vavat. ");
INSERT INTO ksd_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ma dia ga kita ra umana monamono kai ra tarai Israel, nina ba ra umana lualua na papalum kai Parao dia ga tibe tar ia ta diat, ma dia ga tir diat dari: Ta ra ava pa ava ga pait ot pa ra papalum di ga kure tar ia ta vavat gori ma nabung, da ava ga pait ia lua? ");
INSERT INTO ksd_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ma ra umana monamono kai ra tarai Israel dia ga vana ma dia ga tangi tadav Parao dari: Ta ra ava u pait ra dari pire kaum umana tultul? ");
INSERT INTO ksd_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Pa dia tul tar mule ta kunai ta kaum umana tultul, ma dia biti ta vevet: Avat a pait ra vat na pia; ma gire, dia kita kaum umana tultul, ma u vakaina kaum tarai. ");
INSERT INTO ksd_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ma i ga biti ka dari: Avat a umana tabauma, a umana tabauma avat; kari ava biti, Una pala vue avet, upi avet a lotu ma ra tinabar tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Avat a vana, ma avat a ongor, tago pa da tul tar ta kunai mulai ta vavat, ma avat a vung kapi nina ra vat na pia par di ga kure tar ia ta vavat. ");
INSERT INTO ksd_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ma ra umana monamono kai ra tarai Israel dia ga gire ba na kaina kadia kini, tago di biti: Koko ava vaikilik ra tiniba ure ra vat na pia, nina di ga kure tar ia ta vavat ure ra bungbung par. ");
INSERT INTO ksd_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ma ba dia ga vana kan ra luaina mata i Parao, dia ga varkuvo ma Moses ma Aron, tago dir ga tur na nga. ");
INSERT INTO ksd_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ma dia ga biti ta dir: Ra Luluai na nuk pa amur ma na kure, tago amur vuna ba ave ang na bubu ta ra luaina mata i Parao ma ta ra luaina mata i kana umana tultul, ma dia tar vatur ra pakat na vinarubu ma ra lima i diat, upi diat a ubu avet me. ");
INSERT INTO ksd_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Ma Moses i ga lilikun tadav ra Luluai ma i ga biti: Luluai, ta ra ava pa u mari go ra tarai ma ta ra ava u ga tulue iau uti? ");
INSERT INTO ksd_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Tago papa nam ra bung iau ga vana pire Parao, upi ina tata ta ra iangim, i vakaina go ra tarai; ma u, pa u ga valaun tuna kaum tarai. ");
INSERT INTO ksd_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ma ra Luluai i ga biti tai Moses: Go una gire ra magit ina pait ia tai Parao, tago na pala vue diat ure ra dekdek na limagu, ma ure ra dekdek na limagu na korot vue diat kan kana gunan. ");
INSERT INTO ksd_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ma God dir ga tata ma Moses ma i ga biti tana: Iau ra Luluai; ");
INSERT INTO ksd_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ma iau ga tur kapet pa pire Abaraam, Isak ma Iakob, da ra God Dekdek Muka, ma ga ra iangigu ra Luluai pa dital ga nunure. ");
INSERT INTO ksd_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ma iau ga vatur bula kaugu kunubu pire dital upi ina tabar dital ma ra gunan Kanaan, a gunan dital ga vana vurvurbit tana, ma dital ga ki na vaira tana. ");
INSERT INTO ksd_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ma tikai bula, iau ga valongore ra niriri kai ra tarai Israel, nina ba ra tarai Aigipto dia vatur vavilavilau diat, ma iau tar nuk pa kaugu kunubu. ");
INSERT INTO ksd_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Kari una ve ra tarai Israel dari: Iau ra Luluai, ma ina agure vairop avat kan ra lavur mamat na papalum kai ra tarai Aigipto, ma ina valangalanga avat kan ra kini na vilavilau, ma ina valaun avat ma ra limagu ba ina tulue ma ra umana ngala na varkurai; ");
INSERT INTO ksd_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","ma ina vatur vake avat, upi avat kaugu tarai ma iau kavava God; ma avat a nunure ba iau ra Luluai kavava God, nina ba na agure vairop avat kan ra lavur mamat na papalum kai ra tarai Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ma ina agure vaolo avat ta nam ra gunan ba iau ga vavalima ure, upi ina tul tar ia tai Abaraam, Isak ma Iakob; ma ina tabar avat me upi kavavat vatikai; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ma Moses i ga tatike go ra tinata pire ra tarai Israel, ma pa dia ga torom tai Moses, tago i ga ngarao ra bala i diat ma i ga mamat kadia papalum. ");
INSERT INTO ksd_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ma ra Luluai i ga biti tai Moses dari: ");
INSERT INTO ksd_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Una vana, ma una ve Parao ra king Aigipto ba na pala vue ra tarai Israel upi diat a irop kan go ra gunan. ");
INSERT INTO ksd_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ma Moses i ga tata ta ra luaina mata i ra Luluai ma i ga biti: Gire, ra tarai Israel pa dia ga torom tagu; ma Parao na torom dave tagu, tago a bul na ngiegu pa i gomgom. ");
INSERT INTO ksd_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ma ra Luluai i ga tata ta dir Moses ma Aron ma i ga tul tar ra vartuluai ta dir tadav ra tarai Israel ma tadav Parao, ra king Aigipto, upi dir a agure vairop ra tarai Israel kan ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Go ra umana lualua ta ra kubakuba i ra umana tama i diat: A umana natu i Ruben, a luaina kai Israel, Kanok ma Palu ma Kesron ma Karmi; go diat ra umana apik na tarai kai Ruben. ");
INSERT INTO ksd_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ma ra umana natu i Simeon, Iemuel ma Iamin ma Oad ma Iakin ma Sokar, ma Saul natu i tika na vavina Kanaan; go diat ra umana apik na tarai kai Simeon. ");
INSERT INTO ksd_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ma go ra iang i dital ra utul a natu i Levi, da di ga kava dital, Gerson ma Koat ma Merari; ma Levi i ga laun vue tika na mar ma a utul a vinun ma lavurua na kilala. ");
INSERT INTO ksd_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","A ura natu i Gerson, Libni ma Simei varogop ma kadir apik na tarai. ");
INSERT INTO ksd_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ma ra umana natu i Koat, Amram ma Isar ma Kebron ma Usiel; ma Koat i ga laun vue tika na mar ma a utul a vinun ma a utul a kilala. ");
INSERT INTO ksd_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ma a ura natu i Merari, Mali ma Musi. Go ra umana apik na tarai ta ra vuna tarai Levi varogop di ga kava diat. ");
INSERT INTO ksd_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Ma Amram i ga taule Iokebed, tai tamana; ma i ga kava Aron ma Moses; ma Amram i ga laun vue tika na mar ma a utul a vinun ma lavurua na kilala. ");
INSERT INTO ksd_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ma ra utul a natu i Isar, Kora ma Nepeg ma Sikri. ");
INSERT INTO ksd_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ma ra utul a natu i Usiel, Misael ma Elsapan ma Sitri. ");
INSERT INTO ksd_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Ma Aron i ga taule Eliseba, natu i Aminadab, dir taina ma Nason, ma i ga kava Nadab ma Abiu, Eleasar ma Itamar. ");
INSERT INTO ksd_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ma ra utul a natu i Kora, Asir ma Elkana ma Abiasap; go ra utul a apik na tarai kai Kora. ");
INSERT INTO ksd_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ma Eleasar, natu i Aron, i ga taule tika na natu i Putiel, ma i ga kava Pinekas. Go diat a umana lualua pire ra umana tama i ra tarai Levi, da kadia apik na tarai. ");
INSERT INTO ksd_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Go dir Aron ma Moses nina ra Luluai i ga biti ta dir: Amur a agure vairop ra kor na tarai Israel kan ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Go dir, dital ga pirpir ma Parao upi dir a agure vairop ra tarai Israel; go dir Moses ma Aron. ");
INSERT INTO ksd_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ma ta nam ra bung ba ra Luluai dir ma Moses dir ga tata ta ra gunan Aigipto, ");
INSERT INTO ksd_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ra Luluai i biti tai Moses dari: Iau ra Luluai; una ve Parao ra king Aigipto ta nam ra lavur magit ba ina tatike piram. ");
INSERT INTO ksd_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ma Moses i ga tatike ta ra luaina mata i ra Luluai: Gire, a bul na ngiegu pa i gomgom, ma Parao na torom dave tagu? ");
INSERT INTO ksd_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ma ra Luluai i ga biti tai Moses: Gire, iau tar vaki u da u tika na god pire Parao; ma turam Aron kaum propet. ");
INSERT INTO ksd_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Una tatike nam ra lavur magit ba ina tul tar ia tam; ma turam Aron dir a pirpir ma Parao upi na pala vue ra tarai Israel, upi diat a irop kan go ra gunan. ");
INSERT INTO ksd_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ma ina valeo ra bala i Parao, ma ina vapeal kaugu lavur vakilang ma kaugu lavur papalum na padapada varvo ta ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Ma Parao pa na torom ta mumur, ma ina vung ra limagu taun ra gunan Aigipto, ma ina agure vairop kaugu loko na tarai, a umana natu i Israel, kan ra gunan Aigipto ma ra umana ngala na varkurai. ");
INSERT INTO ksd_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Ma ra tarai Aigipto diat a matoto boko ba iau ra Luluai, ba ina tulue vaarike ra limagu taun ra gunan Aigipto, ma ina agure vairop ra tarai Israel kan diat. ");
INSERT INTO ksd_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Ma Moses ma Aron dir ga pait ia damana; da ra Luluai i ga vartuluai pire dir, damana dir ga papait ia. ");
INSERT INTO ksd_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ma Moses i ga laun pa lavutul na vinun na kilala, ma Aron i lavutul na vinun ma a utul a kilala, ba dital ga pirpir ma Parao. ");
INSERT INTO ksd_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ma ra Luluai i ga biti tai Moses ma Aron dari: ");
INSERT INTO ksd_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Ari Parao na biti ta mumur, Amur a pait ta vakilang ure amur, io, una biti tai Aron, Una tak pa kaum buka ma una vue tar ia ura ra pia ta ra luaina mata i Parao upi na vui. ");
INSERT INTO ksd_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ma Moses ma Aron dir ga ruk pire Parao, ma dir ga pait nam ra magit ra Luluai i ga vartuluai tana; ma Aron i ga vue tar kana buka ura ra pia ta ra mata i Parao ma kana umana tultul, ma i ga vui ka. ");
INSERT INTO ksd_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ma Parao bula i ga oro pa ra umana tena kabinana ma ra umana tena agagar; ma diat bula ra umana tena papait Aigipto dia ga papait ra magit damana ma kadia lavur mangana malira. ");
INSERT INTO ksd_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Tago diat par tikatikai, dia ga vue tar kadia umana buka ura ra pia, ma dia ga vui ka. Ma ra buka kai Aron i ga konom pa kadia umana buka. ");
INSERT INTO ksd_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ma ra bala i Parao i ga leo ko, ma pa i ga torom ta dir, da ra Luluai i ga tatike. ");
INSERT INTO ksd_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ma ra Luluai i ga biti tai Moses: A bala i Parao i ole, ma pa i pala vue ra tarai. ");
INSERT INTO ksd_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Una tadav Parao ta ra malana; gire, i irop tadav ra tava; ma una tur ta ra papar a tava upi amur a varkuvo me, ma una tak pa ra buka, nina i ga vui. ");
INSERT INTO ksd_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ma una biti tana: Ra Luluai, a God kai ra umana Ebraio, i tulue iau piram, ma i biti, Una pala vue kaugu tarai, upi diat a lotu piragu ta ra bil; ma gire, tuk tar ta ra bung gori pa u torom. ");
INSERT INTO ksd_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ra Luluai i biti dari: Una matoto ta go ba iau ra Luluai: gire, ina kita ra tava ta ra tava alir ma ra buka ta ra limagu, ma na gap uka. ");
INSERT INTO ksd_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ma ra en ta ra tava alir na mat, ma ra tava na angina; ma ra tarai Aigipto pa diat a mainge mulai upi diat a mome ra tava ta ra tava alir. ");
INSERT INTO ksd_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ma ra Luluai i ga biti tai Moses: Una ve Aron dari, Una vatur kaum buka, ma una tulue ra limam tadav ra lavur tava Aigipto, tadav ra lavur tava alir, tadav ra lavur nga na tava, ma ra lavur lum na tava, ma ta ra lavur tava kikil par, upi diat a gap uka; ma ra gap na tur ta ra lavur pal a tava di pait ia ma ra davai ba ma ra vat. ");
INSERT INTO ksd_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Ma Moses ma Aron dir ga pait ra lavur magit ra Luluai i ga vartuluai tana, ma i ga vatur ra buka urama, ma i ga kita ra tava ta ra tava alir, ta ra luaina mata i Parao ma kana umana tultul, ma ra tava ta ra tava alir i ga gap uka. ");
INSERT INTO ksd_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ma ra en ta ra tava alir i ga mat; ma ra tava i ga angina, ma i ga dekdek pire ra tarai Aigipto upi diat a mome ra tava ta ra tava alir. Ma ra gap i ga tur ta ra gunagunan Aigipto par. ");
INSERT INTO ksd_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ma ra umana tena papait Aigipto dia ga pait bula ra mangamangana damana ma kadia lavur malira; ma ra bala i Parao i ga leo ko, ma pa i ga torom ta dir; da ra Luluai i ga biti. ");
INSERT INTO ksd_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Ma Parao i ga lilikun ma i ga ruk na pal, ma pa i ga nuk pa go ra magit. ");
INSERT INTO ksd_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ma ra tarai Aigipto par dia ga kakal upi ta tava na nimomo maravai pire ra tava alir; tago i ga dekdek upi diat a mome ta tava ta ra tava alir. ");
INSERT INTO ksd_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ma ba ra Luluai i tar kita ra tava alir, i ga kaina lavurua na bung. ");
INSERT INTO ksd_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ma ra Luluai i ga ve Moses: Una ruk tadav Parao, ma una biti tana: Ra Luluai i biti dari, Una pala vue kaugu tarai upi diat a lotu piragu. ");
INSERT INTO ksd_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ma ona u ole, ma pa u pala vue diat, gire, ina kita kaum gunan parika, ma ra lavur rokrok diat a vana rikai tana; ");
INSERT INTO ksd_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","ma ra tava alir na kor ma ra rokrok, ma diat a irop tana, ma diat a ruk ra kubam, ma kaum pal na vava, ma diat a pil ta kaum vava iat, ma diat a ruk ra kuba i kaum umana tultul, ma diat a vana rikai pire kaum tarai, ma diat a ki ta kaum lavur ubu, ma kaum lavur la di bing ra plaua tana; ");
INSERT INTO ksd_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ma ra umana rokrok diat a pot piram ma pire kaum tarai, ma pire kaum lavur tultul parika. ");
INSERT INTO ksd_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ma ra Luluai i ga biti tai Moses: Una ve Aron dari, Una tulue vaarike ra limam ma ra buka tana tadav ra lavur tava alir, ma ra lavur nga na tava, ma tadav ra lavur lum na tava, upi ra umana rokrok diat a vana rikai ma diat a ki ta ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ma Aron i ga tulue vaarike ra limana tadav ra lavur tava Aigipto; ma ra rokrok i ga vana rikai, ma i ga tup ia ta ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ma ra umana tena papait dia ga pait ra dari bula ma kadia malira, ma ra rokrok i ga vana rikai ta ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ma Parao i ga oro pa Moses ma Aron, ma i biti: Amur a lul ra Luluai upi na tak vue ra umana rokrok kan iau ma kan kaugu tarai; ma ina pala vue ra tarai upi diat a pait ra lotu na tinabar tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ma Moses i ga biti tai Parao: Una vatur vake go ra variru tagu, ma una tibe ra pakana bung ba ina araring tana ure u, ma ure kaum umana tultul, ma ure kaum tarai, upi ra umana rokrok diat a virua kan u, ma kan kaum umana pal, ma diat a ki ke ta ra tava alir. ");
INSERT INTO ksd_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ma i ga biti: Ningene. Ma i ga biti: Da pait ia, da u tar biti, upi una nunure ba vakir mulai ta tikai dir varogop ma ra Luluai kaveve God. ");
INSERT INTO ksd_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ma ra umana rokrok diat a vana kan u, ma kan kaum umana pal, ma kan kaum umana tultul. ma kan kaum tarai; diat a ki ke ta ra tava alir. ");
INSERT INTO ksd_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ma Moses ma Aron dir ga irop kan Parao; ma Moses i ga kail tadav ra Luluai ure ra umana rokrok. nina i ga kure tar ia tai Parao. ");
INSERT INTO ksd_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ma ra Luluai i ga torom ta ra tinata kai Moses, ma ra umana rokrok dia ga virua ta ra palpal, ma ra umana bala na gunan. ma ta ra umauma. ");
INSERT INTO ksd_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ma di ga kari varurue diat upi ra umana vuvungaina; ma ra gunan i angina. ");
INSERT INTO ksd_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ma ba Parao i ga gire ba i ga langalanga, i ga valeo ra balana, ma pa i ga torom ta dir, da ra Luluai i ga biti. ");
INSERT INTO ksd_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ma ra Luluai i ga biti tai Moses: Una ve Aron dari, Una tulue vaarike kaum buka, ma una kita ra tobon i ra pia, upi ra lavur ngatingat diat a tavua rikai tana ta ra gunagunan Aigipto parika. ");
INSERT INTO ksd_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ma dir ga pait ia; ma Aron i ga tulue ra limana ma ra buka, ma i ga kita ra tobon i ra pia, ma ra ngatingat i ga ki ta ra tarai ma ta ra umana vavaguai; ma di ga pukue ra tobon par ta ra gunan Aigipto parika upi na ngatingat parika. ");
INSERT INTO ksd_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ma ra umana tena papait dia ga papait ma kadia malira upi ra ngatingat na vana rikai tana, ma pata, pa dia ga pait valar pa ia; ma ra ngatingat i ga ki ta ra tarai ma ta ra vavaguai. ");
INSERT INTO ksd_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ma ra umana tena papait dia ga biti tai Parao: A lima i God go; ma ra bala i Parao i ga leo ko, ma pa i ga torom ta dir; da ra Luluai i ga biti. ");
INSERT INTO ksd_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ma ra Luluai i ga biti tai Moses: Una tut ningene na kavunvun, ma una tur ta ra luaina mata i Parao; gire, na irop tadav ra tava; ma una biti tana: Ra Luluai i biti dari, Una pala vue kaugu tarai upi diat a lotu piragu. ");
INSERT INTO ksd_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Kan, ona pa una pala vue kaugu tarai, ina tulue ra livur na langa na pap piram, ma pire kaum umana tultul ma pire kaum tarai, ma diat a ruk kaum palpal; ma ra kubakuba i ra umana te Aigipto diat a kor ma ra livur na langa na pap, ma ra pia bula ba dia ki tana. ");
INSERT INTO ksd_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ma ta nam ra bung na enana ta ra gunan Gosen, nam ba kaugu tarai dia ki tana, tago pa ta livur na langa na pap na ki tana; upi una nunure ba iau ra Luluai, iau ki ta ra rakarakan a gunagunan. ");
INSERT INTO ksd_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ma ina pait ra vakilang na varvalaun upi na tibe varbaiane kaugu tarai ma kaum; ningene ina pait ra vakilang. ");
INSERT INTO ksd_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ma ra Luluai i ga pait ia damana; ma i ga tup ia ra livur na langa na pap ta ra kuba i Parao, ma ta ra kuba i kana umana tultul; ma ta ra gunan Aigipto parika; ma ra gunan i ga kaina ure ra umana langa na pap. ");
INSERT INTO ksd_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Ma Parao i ga oro pa Moses ma Aron, ma i ga biti: Avat a vana, ma avat a vartabar tadav kavava God ta go ra gunan. ");
INSERT INTO ksd_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ma Moses i ga biti: Pata, pa i topa ia, upi avet a pait ia damana; tago avet a vartabar ma ra magit i bilak ta ra mata i ra umana te Aigipto, ma kan diat a tupar doko avet. ");
INSERT INTO ksd_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Avet a vana urima ra bil, da ra vinavana na utul a bung, ma avet a pait ra tinabar tadav ra Luluai kaveve God, varogop ma kana vartuluai. ");
INSERT INTO ksd_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ma Parao i ga biti: Io, ina nur vue avat, upi avat a vana ma avat a vartabar tadav ra Luluai kavava God ta ra bil; ia kaka, koko avat a vana vailik; amur a araring ure iau. ");
INSERT INTO ksd_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Ma Moses i ga biti: Gire, ina irop kan u, ma ina lul God upi ra livur na langa na pap na panie ningene kan Parao, kan kana umana tultul, ma kana tarai; ia kaka, koko Parao na tuam mule avet, ma koko na tigal vake ra tarai, upi koko diat a vana ma diat a vartabar tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Ma Moses i ga irop kan Parao, ma i ga lulul ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ma ra Luluai i ga torom ta ra tinata kai Moses; ma i ga tak vue ra livur na langa na pap kan Parao, ma kan kana tarai; ma pa ta tikai i ga ki mulai. ");
INSERT INTO ksd_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ma ta go mulai Parao i ga valeo ra balana, ma pa i ga pala vue ra tarai. ");
INSERT INTO ksd_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ma ra Luluai i ga biti tai Moses: Una vana tadav Parao, ma una ve, ba ra Luluai, a God kai ra tarai Ebraio, i biti dari, Una pala vue kaugu tarai upi diat a lotu tadav iau. ");
INSERT INTO ksd_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Tago ona u ole, ma pa u pala vue diat, ma u tigal vake diat mulai, ");
INSERT INTO ksd_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","gire, ra lima i ra Luluai na bili kaum lavur vavaguai ta ra gunan, ra lavur os, ma ra lavur as, ma ra lavur kamel, ma ra kikil na bulumakau ma ra kikil na sip; a kaina minait na tup diat. ");
INSERT INTO ksd_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ma ra Luluai na tibe varbaiane ra umana vavaguai kai ra tarai Israel ma ra vavaguai kai ra tarai Aigipto; ma pa ta na kai ra tarai Israel na virua. ");
INSERT INTO ksd_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ma ra Luluai i ga kubu ra bung, ma i ga biti: Ningene ra Luluai na pait go ra magit ta ra gunan. ");
INSERT INTO ksd_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ma ra Luluai i ga pait ot pa nam ra magit ta ra bung namur, ma ra lavur vavaguai kai ra tarai Aigipto dia ga virua; ma pa ta kopono vavaguai kai ra tarai Israel i ga virua. ");
INSERT INTO ksd_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Ma Parao i ga vartuluai ma i ga titir tana, ma gire, pa ta tikai ta diat ra umana vavaguai kai ra tarai Israel i ga virua. Ma ga ra bala i Parao i ga leo, ma pa i ga pala vue ra tarai. ");
INSERT INTO ksd_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ma ra Luluai i ga biti tai Moses dir ma Aron: Amur a tak pa ra ivat na ginagu na kabu na iap ta ra ubu, ma Moses na imimire urama liu tadav ra bala na bakut ta ra luaina mata i Parao. ");
INSERT INTO ksd_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ma na da ra tobon ta ra gunagunan Aigipto parika, ma ra pal a paka i ra tarai ma ra paka i ra umana vavaguai bula na manmanua ma ra todol, ta ra gunagunan Aigipto parika. ");
INSERT INTO ksd_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ma dir ga tak pa ra kabu na iap ta ra ubu; ma dir ga tur ta ra luaina mata i Parao; ma Moses i ga vue imimire urama liu tadav ra bala na bakut; ma ra pal a paka i ra tarai ma ra paka i ra umana vavaguai i ga manmanua ma ra todol. ");
INSERT INTO ksd_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ma ra umana tena papait dia ga mama tur ta ra luaina mata i Moses ta ra umana manua, tago ra umana tena papait dia ga manua, diat ma ra tarai Aigipto par. ");
INSERT INTO ksd_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ma ra Luluai i ga valeo ra bala i Parao, ma pa i ga torom ta dir; da ra Luluai i ga biti tai Moses. ");
INSERT INTO ksd_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Ma ra Luluai i ga biti tai Moses: Una tut ningene na kavunvun, ma una tur ta ra luaina mata i Parao, ma una biti tana, Ra Luluai, a God kai ra tarai Ebraio, i biti dari: Una pala vue kaugu tarai upi diat a lotu piragu. ");
INSERT INTO ksd_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Tago go ina tulue kaugu lavur kinadik ta ra balam, ma tadav kaum lavur tultul, ma tadav kaum tarai; upi una nunure ba pa ta tikai mulai da iau i ki ta ra rakarakan a gunagunan. ");
INSERT INTO ksd_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Tago gala pata, gala ina ga tulue vaarike ra limagu upi ina ub u ma kaum tarai ma ra kaina minait, ma gala una ga panie kan ra rakarakan a gunagunan; ");
INSERT INTO ksd_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ma ga ure go ra magit iau ga balaure vake u, upi ina vaarike ra dekdekigu, ma upi da varvarvai ta ra iangigu ta ra rakarakan a gunagunan. ");
INSERT INTO ksd_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ma i dave, tago u vangala mule u, ma u tur bat kaugu tarai, ma pa u pala vue diat? ");
INSERT INTO ksd_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Gire ningene, ta ra pakana bung dari bar, ina tulue ra bata na vatvat ma na tup ia, ma pa i ga bata damana boko ta ra gunan Aigipto papa ra bung di ga vaki ia tana tuk tar gori. ");
INSERT INTO ksd_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Io, go una lulut ma una agure varuk kaum lavur vavaguai ta ra pal, ma una varuk ra lavur magit ta ra umauma bula; tago ra lavur tarai ma ra vavaguai ta ra umauma ba pa di agure varuk diat, a bata na vatvat na bura taun diat, ma diat a virua. ");
INSERT INTO ksd_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Nina ra tultul kai Parao ba i ga burut tai ra Luluai, i ga vaale kana umana vilavilau, upi diat a lop ta ra pal, ma i ga agure varuk kana vavaguai; ");
INSERT INTO ksd_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ma nina ba pa i ga nuk pa ra tinata kai ra Luluai, i ga nur vue kana umana vilavilau ma kana umana vavaguai ta ra umauma. ");
INSERT INTO ksd_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ma ra Luluai i ga biti tai Moses: Una tulue vaarike ra limam tadav ra bala na bakut, upi na bata na vatvat ta ra gunagunan Aigipto; na bura taun ra tarai, ma taun ra vavaguai, ma taun ra lavur davai ta ra uma, ta ra gunagunan Aigipto parika. ");
INSERT INTO ksd_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Ma Moses i ga tulue vaarike kana buka urama tadav ra bala na bakut; ma ra Luluai i ga tulue ra pipi ma ra bata na vatvat, ma i ga pala vabura ra meme ura ra pia; ma ra Luluai i ga tulue ra bata na vatvat taun ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Damana i ga bata na vatvat, ma i ga palapala ra meme vatikai maravut ra bata na vatvat, ma i ga tup ia, a gunan Aigipto pa i ga nunure ra damana papa ra bung di vatur ra varkurai na king tana. ");
INSERT INTO ksd_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ma ra bata na vatvat i ga vakaina ra lavur magit ta ra gunan Aigipto par, a lavur magit ta ra umauma, dir par a tarai ma ra vavaguai; ma ra bata na vatvat i ga ta ra lavur davai ikilik ta ra uma, ma i ga bubur ra lavur ngala na davai ta ra gunan. ");
INSERT INTO ksd_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","la kaka ta ra gunan Gosen, nina ra tarai Israel dia ga ki tana, pa i ga bata na vatvat. ");
INSERT INTO ksd_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ma Parao i ga vartuluai ma i ga oro pa Moses ma Aron, ma i ga biti ta dir. Iau tar rara go; ra Luluai i takodo, ma iau, avet ma kaugu tarai ave manga kaina. ");
INSERT INTO ksd_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Amur a lul ra Luluai, tago i tar peal go ra pipi kai God ma ra bata na vatvat; ina pala vue avat, koko avat a ki mulai ati. ");
INSERT INTO ksd_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Ma Moses i ga biti tana: Ba iau tar irop kan ra pia na pal, ina tulue muka ra ura limagu tadav ra Luluai; ma na ngo ra lavur pipi ma pa na bata na vatvat mulai; upi una nunure ba ra Luluai i kure ra rakarakan a gunagunan. ");
INSERT INTO ksd_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ma avat ma kaum umana tultul, iau nunure ba pa avat a burut tai ra Luluai God. ");
INSERT INTO ksd_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Ma i ga kaina ra katen ma ra barli, tago ra barli i ga vung ra patina ma ra katen i ga pupu. ");
INSERT INTO ksd_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ma ra vit ma ra kon pa dir ga kaina; tago pa dir ga manga gol boko. ");
INSERT INTO ksd_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Ma Moses i ga irop kan ra pia na pal ma kan ra mata i Parao, ma i ga tulue ra limana tadav ra Luluai; ma ra pipi ma ra bata na vatvat dir ga ngo, ma pa i ga manga bata mulai. ");
INSERT INTO ksd_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ma ba Parao i ga gire ba i ga ngo ra bata, ma ra bata na vatvat ma ra pipi bula, i ga kaina mulai, ma i ga valeo ra balana, diat ma kana umana tultul. ");
INSERT INTO ksd_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ma i ga leo ra bala i Parao, ma pa i ga pala vue ra tarai Israel; da ra Luluai i ga biti tai Moses. ");
INSERT INTO ksd_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ma ra Luluai i ga biti tai Moses: Una vana tadav Parao, tago iau tar valeo ra balana, ma ra bala i kana umana tultul upi ina pait vaarike go kaugu lavur vakilang livuan ta diat; ");
INSERT INTO ksd_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ma upi una varvarvai ta ra talinga i natum, a tutana, ma ra tubum ure ra lavur magit iau ga pait diat aro Aigipto, ma ra lavur vakilang iau ga pait ia livuan ta diat, upi avat a nunure ba iau iat ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ma Moses ma Aron dir ga ruk tadav Parao, ma dir ga biti tana: Ra Luluai, a God kai ra tarai Ebraio, i biti dari, Aivia ra bung boko upi una vaikilik pa mule u ta ra luaina matagu? Una pala vue kaugu tarai upi diat a lotu tadav iau. ");
INSERT INTO ksd_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ona pata, ma u ole upi una pala vue kaugu tarai, gire, ningene ina tulue ra lavur kubau ta kaum gunagunan; ");
INSERT INTO ksd_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ma na tup ia ta ra mata i ra pia, pa ta tikai na gire mule ra pia; ma diat a en vue ra magit i tur valili ta ra bata na vatvat, ma diat a en vue ra lavur davai i tavua ure avat ta ra gunan; ");
INSERT INTO ksd_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ma diat a kor ta kaum umana pal, ma ta ra palpal kai kaum umana tultul, ma ra palpal kai ra tarai Aigipto par. Ma i ga tur tapuku ma i ga irop kan Parao. ");
INSERT INTO ksd_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ma ra umana tultul kai Parao dia ga biti tana: Aivia ra bung boko go ra tutana na da ra kun ure dat? Una pala vue go ra tarai, upi diat a lotu tadav ra Luluai kadia God; pa u nunure boko vang ba Aigipto i tar virua? ");
INSERT INTO ksd_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ma Moses ma Aron dir ga vana mulai tadav Parao; ma i ga biti ta dir: Avat a vana, ma avat a lotu tadav ra Luluai kavava God; ma to ia diat, ba diat a vana? ");
INSERT INTO ksd_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Ma Moses i ga biti: Avet a vana ma kaveve lavur barmana ma ra umana patuana, avet ma ra umana natu i vevet, a umana tutana ma ra umana vavina, ma avet a agure kaveve lavur kikil na sip, ma ra lavur kikil na bulumakau, tago avet a pait ra lukara kai ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Ma i ga biti ta dir: Ra Luluai na ki pire vavat, ona ina pala vue avat ma ra umana natu i vavat! Ea, ava nuk upi ra kaina ka! ");
INSERT INTO ksd_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Koko na damana; avat ika ra umana tutana, avat a vana, ma avat a lotu tadav ra Luluai; tago nam kavava mamainga. Ma di ga korot vue dir kan ra luaina mata i Parao. ");
INSERT INTO ksd_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ma ra Luluai i ga biti tai Moses: Una tulue ra limam tadav ra gunan Aigipto upi ra lavur kubau, ma diat a vana rikai ta ra gunan Aigipto, ma upi diat a en ra lavur davai par ta ra gunan, nam par ba i tur valili ta ra bata na vatvat. ");
INSERT INTO ksd_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ma Moses i ga tulue kana buka taun ra gunan Aigipto, ma ra Luluai i ga tulue ra vuvu na taubar tadav ra gunan ma i ga vuvu ta nam ra bung parika ma ra marum par bula; ma ta ra malana ra taubar i ga kapkap ra kubau. ");
INSERT INTO ksd_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ma ra umana kubau dia ga vana rikai ta ra gunan Aigipto parika, ma dia ga ki ta ra langlangun Aigipto par; i ga tup ia tuna; lua boko pa ta kubau dari, ma namur bula pata. ");
INSERT INTO ksd_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Tago dia ga kor ta ra mata i ra gunagunan, ma i ga bobotoi ka ra gunan tana; ma dia ga en vue ra lavur davai ta ra gunan ma ra lavur davai ba dia vuai ra vuai diat, nina ba dia ga tur valili ta ra bata na vatvat; ma pa ta magit ba i ga lubalubang, pa ta ikilik na davai ba ta ngala na davai, i ga ki mulai ta ra gunan Aigipto par. ");
INSERT INTO ksd_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Io, Parao i ga oro lolole pa Moses ma Aron, ma i ga biti: Iau tar pait ra kaina tadav ra Luluai kavava God ma tadav avat bula. ");
INSERT INTO ksd_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Kari i boina ba una nur vue kaugu varpiam ta go ra bung, ma una lul ra Luluai kavava God upi na tak vue ke go ra minat kan iau. ");
INSERT INTO ksd_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Ma Moses i ga irop kan Parao, ma i ga lul ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ma ra Luluai i ga pukue ra vuvu upi ra ngala na labur, ma i ga kap vue ra kubau, ma i ga vue tar diat ta ra Ta Meme; ma pa ta kopono kubau mulai i ga ki ta ra langlangun Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ma ra Luluai i ga valeo ra bala i Parao, ma pa i ga pala vue ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ma ra Luluai i ga biti tai Moses: Una tulue ra limam urama tadav ra bala na bakut, upi ra gunan Aigipto na bobotoi ma ra tarai diat a pepepere ke. ");
INSERT INTO ksd_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ma Moses i ga tulue ra limana urama tadav ra bala na bakut; ma a utul a bung a ngala na bingnimuna i ga ki ta ra gunan Aigipto par; ");
INSERT INTO ksd_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ma pa dia ga gire vargiliane diat, ma pa ta na i ga tut kan kana kiki ta ra utul a bung; ma i ga kapa ka ra lavur kuba i ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ma Parao i ga oro pa Moses, ma i ga biti: Avat a vana, avat a lotu tadav ra Luluai, ia kaka kavava kikil na sip ma kavava lavur bulumakau diat a ki, avat a vana ma ra lavur natu i vavat bula. ");
INSERT INTO ksd_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ma Moses i ga biti: Una tabar bula avet ma ra magit na tinabar ma ra tinabar di tuntun tar ia, upi avet a vartabar tadav ra Luluai kaveve God. ");
INSERT INTO ksd_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Avet a varagur bula ma kaveve lavur vavaguai; pa avet a nur vue ta pal a kau i diat ba na ki ati; tago avet a tak ta na ta diat upi avet a vartabar me tadav ra Luluai kaveve God; ma pa ave nunure boko ra magit ba avet a vartabar me tadav ra Luluai, tuk tar ta ra bung avet a pot aro. ");
INSERT INTO ksd_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ma ra Luluai i ga valeo ra bala i Parao, ma pa i ga pala vue diat. ");
INSERT INTO ksd_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Ma Parao i ga biti tana: Una vana kan iau, ma koko una gire mule ra matagu, tago nam ra bung ba u vana mulai piragu, una virua ka. ");
INSERT INTO ksd_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Ma Moses i ga biti: I boina kaum tinata; pa ina vana mulai piram. ");
INSERT INTO ksd_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ma ra Luluai i ga biti tai Moses; Tika na kinadik mulai ina tulue pire Parao ma pire Aigipto; ta kopono ko; namur na pala vue avat; ma ba i pala vue avat par, na okole vue tuna avat kan go ra gunan. ");
INSERT INTO ksd_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Io, una ve ra tarai upi diat a valongore, ma ra tarai par ma ra vaden par, diat a vatang upi ra lavur marmar di pait ia ma ra silva, ma ra lavur marmar di pait ia ma ra goled, tai ra umana talai diat. ");
INSERT INTO ksd_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ma ra Luluai i ga maravut ra tarai ma ra umana te Aigipto dia ga mari diat. Ma tikai bula, ra tutana Moses i ga ngala kakit ta ra gunan Aigipto, ta ra luaina mata i ra umana tultul kai Parao, ma ta ra luaina mata i ra tarai. ");
INSERT INTO ksd_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ma Moses i ga biti: Ra Luluai i biti dari, Ta ra mutumut ina vana rikai livuan ta ra gunan Aigipto; ");
INSERT INTO ksd_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ma ra lavur luaina natu i ra tarai ta ra gunan Aigipto diat a mat; na tur pa. ia ma ra luaina bul kai Parao, nina i ki ta ra kiki na king, ma na tuk tar ta ra luaina bul kai ra tultul na vavina i tur ta ra vat na uduudu; ma ra luaina nat na vavaguai bula. ");
INSERT INTO ksd_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ma na tup ia ra tinangi ta ra gunan Aigipto par, pata boko i ga varogop me lua, ma namur pata na mulai damana. ");
INSERT INTO ksd_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ma pa ta pap na loalor ta diat ra tarai Israel, vakir ta diat ra tarai ba ta ra vavaguai; upi avat a nunure ba ra Luluai i kure vaenana pa ra tarai Israel ta dir ma ra tarai Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ma diat par go kaum umana tultul diat a vana ur piragu, ma diat a va timtibum tadav iau, diat a biti: Una irop ma ra tarai par ba diat a mur u; ma na par go, ma ina irop. Ma i ga vana balakane Parao, ma i ga karangap kana kankan. ");
INSERT INTO ksd_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ma ra Luluai i ga biti tai Moses: Parao pa na torom tam; upi na peal kaugu lavur vakilang na kinaian ta ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ma Moses ma Aron dir ga pait go ra lavur vakilang na kinaian ta ra luaina mata i Parao; ma ra Luluai i ga valeo ra bala i Parao, ma pa i ga mulaot ba ra tarai Israel diat a irop kan kana gunan. ");
INSERT INTO ksd_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Ma ra Luluai i ga biti tai Moses ma Aron ta ra gunan Aigipto dari: ");
INSERT INTO ksd_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Go ra gai ra luaina gai pire vavat; ia ra luaina gai ta ra kilala pire vavat. ");
INSERT INTO ksd_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Amur a ve ra kor na tarai Israel ma amur a biti dari: ta ra bung a vinun ta go ra gai, tikatika na tutana na pilak pa ta nat na sip ure ra lavur kubakuba i diat, tika na nat na sip ure tika na pal; ");
INSERT INTO ksd_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ma ona a paupau ke dia ki tai ta pal, ma pa i tale diat upi diat a en ra nat na sip, boina ba diat ma ra umana talai diat tai ta ra pal i maravai diat a pilak pa ta kopono ure diat par, ma avat a luk ra tarai; ma avat a nuk pa ra tiniba ta ra nat na sip ba na topa tikatikai ba na en ia. ");
INSERT INTO ksd_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Kavava nat na sip na ko kakit, a tomotoina, ba i kopono ko kana kilala; avat a pilak pa ia ta ra kikil na sip ba ta ra kikil na Me; ");
INSERT INTO ksd_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","ma avat a balaure vake tuk tar ta ra bung a vinun ma a ivat ta nam ra gai; ma ra lavur tarai Israel par diat a doka ta ra ravian. ");
INSERT INTO ksd_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ma diat a tak pa ra gapuna, ma diat a kolo ra ura tukal i ra matakilalat me, ma ra davai i va bolabolo arama bula, ta nam ra pal dia iaian tana. ");
INSERT INTO ksd_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ma diat a en ra viono ta nam ra marum, diat a rang ia ta.ra iap, ma diat a maravut ia ma ra gem ba pa i leven; diat a en ia, ma ra vurigir i mapak. ");
INSERT INTO ksd_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Koko avat a en ia ba i kalamana boko, ma koko avat a kabalane, avat a rang ia ta ra iap. ra uluna ma ra kakene ma ra balana bula. ");
INSERT INTO ksd_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ma koko ta ik na tur valili upi ra kubakene; ma ona ta na i tur valili upi ra kubakene, avat a tun vue ta ra iap. ");
INSERT INTO ksd_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Avat a en ia dari: avat a vi pit ra livua i vavat, a pal a kau ta ra kau i vavat, a buka ta ra lima i vavat; ma avat a en lolole pa ia; a bolo lake kai ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Tago ta nam ra marum ina bolo ta ra gunan Aigipto, ma ina ubu doko ra umana luaina natu i ra tarai ma ra umana luaina nat na vavaguai ta ra gunan Aigipto; ma ina pait ra balbali pire ra umana god Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ma ra gap ia ra vakilang pire vavat ta nam ra umana pal ava ki tana; ma ona iau. gire ra gap ina bolo lake avat, ma pa ta kinadik na tadav avat upi avat a virua tana, ba ina ubu ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ma go ra bung na varogop ma ra vakilang na kodakodop pire vavat, ma avat a vagomgom ia upi avat a pait ra lukara tadav ra Luluai tana ta kavava lavur taun tarai, da ra mangamangana ba na tur tukum. ");
INSERT INTO ksd_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Lavurua na bung avat a en ra gem ba pa i leven; ma ta ra luaina bung iat avat a vairop vue ra leven kan ra kubakuba i vavat, tago diat par dia en ra gem i leven papa ra luaina bung tuk tar ta ra valavuruana, da okole vue diat kan ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ma ta ra luaina bung avat a pait ra kivung na lotu, ma ta ra valavuruana bung damana bula, a kivung na lotu; koko avat a pait ta mangana papalum ta dir, ia kaka a nian ure ra tarai, nam uka avat a varvakai me. ");
INSERT INTO ksd_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Ma avat a nuk pa ra lukara na gem ba pa i leven, tago ta nam ra bung iat iau ga agure vairop kavava kor na tarai kan ra gunan Aigipto; kari avat a nuk pa go ra bung ta kavava taun tarai par da ra mangamangana ba na tur tukum. ");
INSERT INTO ksd_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Ta ra luaina gai ma ta ra vavinun ma a ivat na bung tana, ta ra ravian, avat a en ra gem ba pa i leven, ma na tuk tar ta ra bung a ura vinun ma tikai ta ra gai, ba i ravian. ");
INSERT INTO ksd_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Lavurua na bung koko ra leven na bang ta ra kubakuba i vavat; tago diat par dia en ra magit i leven, da okole vue diat kan ra tarai Israel, ba ta vaira ba ta gunan tuna. ");
INSERT INTO ksd_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Koko avat a en ta magit ba i leven, avat a en ra gem ba pa i leven ta kavava pia na pal par. ");
INSERT INTO ksd_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ma Moses i ga oro pa ra umana patuana kai ra tarai Israel ma i ga biti ta diat: Avat a pilak pa ra umana nat na sip, ma avat a takan pa diat varogop ma ra tarai ta ra kubakuba i vavat ma avat a doko ra bolo lake. ");
INSERT INTO ksd_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ma avat a takan pa ra vinvin na isop ma avat a puk ia ta ra gap ta ra la, ma avat a kolo ra davai i va bolo ma ra ura tukal i ra matakilalat ma ra gap i ki ta ra la; ma koko ta tikai ta vavat na irop ta ra matakilalat i ra kubana tuk tar ta ra malana. ");
INSERT INTO ksd_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Tago ra Luluai na bolo upi na ubu ra umana te Aigipto; ma ona na gire ra gap ta ra davai i va bolo ma ta ra ura tukal, a Luluai na bolo lake, ma pa na tul tar ra tena vardodoko upi na ruk ma upi na ubu avat. ");
INSERT INTO ksd_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Ma avat a pait go ra magit; a mangamangana piram ma ra umana natum pa na mutu. ");
INSERT INTO ksd_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ma ba ava tar pot ta nam ra gunan ba ra Luluai na tabar avat me varogop ma kana varvatading, avat a pait go ra mangamangana. ");
INSERT INTO ksd_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ma ba ra umana natu i vavat dia tir avat dari: Ava ra kukurai go ra mangamangana? ");
INSERT INTO ksd_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","avat a biti: Go ia ra tinabar ure ra bolo lake kai ra Luluai, tago i ga bolo lake ra kubakuba i ra tarai Israel aro Aigipto ta nam ra bung i ga ubu ra tarai Aigipto tana, ma i ga valaun diat ta ra kubakuba i diat. Ma ra tarai dia ga tur rururu ma dia ga lotu. ");
INSERT INTO ksd_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ma ra tarai Israel dia ga vana ma dia ga pait ia damana; da ra Luluai i ga vartuluai tana pire Moses ma Aron, damana dia ga pait ia. ");
INSERT INTO ksd_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ma ta ra mutumut a Luluai i ga ubu ra lavur luaina natu i ra tarai ta ra gunan Aigipto, i tur pa ia ma ra luaina bul kai Parao ta ra kiki na king ma i ga tuk tar ta ra luaina bul kai ra tutana di ga varuk ia ta ra pal na banubat; ma diat par bula ra lavur nat na vavaguai, a umana luaina. ");
INSERT INTO ksd_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Ma Parao i ga tut ra marum, ma diat par kana lavur tultul, ma ra tarai Aigipto par; ma i ga tup ia ra kunukula aro Aigipto, tago vakir ta tika na pal ba pa ta minat i tana. ");
INSERT INTO ksd_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ma i ga oro pa Moses ma Aron ra marum ma i ga biti: Avat a tut, avat a irop balakane kaugu tarai, avat par ma ra tarai Israel; ma avat a vana, ma avat a lotu tadav ra Luluai, da ava ga vatang ia. ");
INSERT INTO ksd_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Avat a agure kavava lavur kikil na sip ma ra kikil na bulumakau, da ava ga biti, ma avat a ga vana; ma avat a tata vadoane iau bula. ");
INSERT INTO ksd_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ma ra tarai Aigipto dia ga vargat ra tarai Israel ba diat a tul vue lulut diat kan kadia gunan; tago dia ga biti: Avet a virua par. ");
INSERT INTO ksd_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ma ra tarai dia ga kap ra plaua ba pa i leven boko, ma kadia la ba di bing ra plaua tana, di ga pulu diat ma kadia umana mal na tubatuba, ma dia ga kap ia ta ra ul a vara i diat. ");
INSERT INTO ksd_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ma ra tarai Israel dia ga torom ta ra tinata kai Moses; ma dia ga titir upi ra lavur ngatngat na marmar di ga pait ia ma ra silva, ma ra ngatngat na marmar di ga pait ia ma ra goled, ma upi ra mal bula, ta diat ra umana te Aigipto; ");
INSERT INTO ksd_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","ma ra Luluai i ga maravut ra tarai, ma ra umana te Aigipto dia ga mari diat ma dia ga tabar diat ma ra magit dia ga tir diat upi ia. Ma dia ga vatur vake ra tabarikik kai ra umana te Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Ma ra tarai Israel dia ga tur pa ra vinavana maro Rameses ma dia ga tuk uro Sukot, laptikai na mar na arip na tarai bar diat dia ga vana, ma ra lavur natu i diat bula. ");
INSERT INTO ksd_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ma a peal enana tarai dia ga varagur ma diat urama; ma ra sip ma ra bulumakau ma mangoro na vavaguai. ");
INSERT INTO ksd_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ma dia ga tun ra gem ba pa i leven ma nam ra plaua ba di ga kap vairop ia maro Aigipto tago pa i ga leven; tago di ga korot vue diat aro Aigipto, ma i ga dekdek upi diat a vavuan, ma pa dia ga vaninare ta magit na nian ure diat iat. ");
INSERT INTO ksd_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Io, ra tarai Israel dia ga ki na vaira aro Aigipto a ivat na mar ma a utul a vinun na kilakilala. ");
INSERT INTO ksd_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ma ba i ga par a ivat na mar ma a utul a vinun na kilakilala, ta nam ra bung iat a kor na tarai kai ra Luluai dia ga irop kan ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Nam ra marum a Luluai i ga monamono tana, tago i ga agure vairop diat kan ra gunan Aigipto. A lavur tarai Israel par ta kadia lavur taun tarai diat a manga nuk pa go ra marum kai ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ma ra Luluai i ga biti tai Moses ma Aron: A varkurai ure ra bolo lake go: pa ta tematana na ian maravut tana; ");
INSERT INTO ksd_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ma ra lavur tultul di ga kul diat ma ra mani diat a ian tana, ona di ga poko kikil diat. ");
INSERT INTO ksd_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","A vaira ma ra tultul di vapuak ia, koko dir a ian tana. ");
INSERT INTO ksd_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Diat a en ia tai tika na pal; ma koko una kap vairop ta ik kan ra pal; ma koko avat a bubur ta uruna. ");
INSERT INTO ksd_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","A tarai Israel par diat a pait ia. ");
INSERT INTO ksd_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Ma ba ta vaira i ki piram ma i mainge ba na pait ra bolo lake tadav ra Luluai, boina ba na poko kikil kana tarai par, ma na vana maravai ma na pait ia; ma na varogop ma ra gunan tuna; ma koko ta tikai na en ia ba i iba upi ra pokakikil. ");
INSERT INTO ksd_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Tikai ka ra varkurai ure ra gunan tuna ma ure ra vaira i ki pire vavat. ");
INSERT INTO ksd_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Ma ra tarai Israel par dia ga pait go ra magit; da ra Luluai i ga vartuluai pire Moses ma Aron, damana dia ga pait ia. ");
INSERT INTO ksd_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ma ta nam ra bung iat a Luluai i ga agure vairop ra lavur kor na tarai Israel kan ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Ma ra Luluai i ga biti tai Moses dari: Avat a tibe tar diat par tagu di kava value diat, ");
INSERT INTO ksd_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","nina i vana rikai lua ta ra tatal na bul pire ra tarai Israel, ta diat ra tarai ma ra vavaguai bula; kaugu ka diat. ");
INSERT INTO ksd_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ma Moses i ga biti tai ra tarai: Avat a nuk pa go ra bung, a bung ava ga irop tana kan Aigipto, kan ra kuba i ra umana vilavilau; tago ra Luluai i ga. agure vairop avat kan nam ra gunan ma ra dekdek na limana; koko avat a en ra gem i leven. ");
INSERT INTO ksd_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ta go ra bung ta ra gai Abib ava vana rikai. ");
INSERT INTO ksd_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Ma ba ra Luluai i agure vaolo u ta ra gunan kai ra tarai Kanaan, ma ra tarai Ket, ma ra tarai Amor, ma ra tarai Kivi, ma ra tarai Iebus, nina ra gunan i ga vavalima tar ia tai ra umana tamam, a gunan ba i alalir a polo na u ma ra polo na livur i kalakalami tana, i boina ba una pait go ra lotu ta go ra gai. ");
INSERT INTO ksd_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Lavurua na bung una en ra gem ba pa i leven, ma ta ra valavuruana bung una pait ra lukara kai ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Avat a en ra gem ba pa i leven ta nam ra lavurua na bung par; ma koko ta gem i leven na bang piram, ma koko ta leven na bang piram ta kaum langlangun parika. ");
INSERT INTO ksd_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ma una vateten natum ta nam ra bung dari: Di pait ia ure nam ra magit ra Luluai i ga pait ia ure iau, ba iau ga vana rikai kan ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ma na varogop ma ra vakilang piram ta ra limam, ma na varogop ma ra vakilang na kodakodop ta ra pal a matam, upi ra varkurai kai ra Luluai na ki ta ra ngiem; tago ra Luluai i ga agure vairop u ma ra dekdek na limana kan ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Kari una pait go ra mangamangana ta kana e ta ra kilakilala. ");
INSERT INTO ksd_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Ma ba ra Luluai i agure vaolo u ta ra gunan kai ra tarai Kanaan, da i ga vavalima tam ma tai ra umana tamam, ma ba i tabar u me, ");
INSERT INTO ksd_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","una tibe vaire upi kai ra Luluai diat par dia vana rikai lua ta ra tatal na bul, ma ra luaina nat na vavaguai piram; a umana tutana una tul tar diat tai ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Ma ra lavur nat na as par una kia valaun diat ma ra nat na me; ma ona pa u mainge upi una kia valaun diat, una bubur ra inoa i diat; ma diat par a umana luaina natu i ra tarai una kia valaun diat. ");
INSERT INTO ksd_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Ma ba natum a tutana i tir u ta ra kilala namur dari, Ava go? una biti tana, A Luluai i ga agure vairop avet ma ra ongor na limana kan Aigipto, kan ra kuba i ra umana vilavilau; ");
INSERT INTO ksd_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ma ba Parao i ga papait na ole upi na pala vue avet, ra Luluai i ga ubu doko ra lavur luaina bul ta ra gunan Aigipto, a umana luaina natu i ra tarai ma ra umana luaina nat na vavaguai; kari iau tul tar tai ra Luluai nam par ba i vana rikai lua ta ra tatal na bul ma i tutana; ma ra lavur luaina ta ra umana natugu iau kia valaun diat. ");
INSERT INTO ksd_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ma na da ra vakilang ta ra limam ma ra vipuar ta ra pal a matam; tago ra Luluai i ga agure vairop dat ma ra dekdek na limana kan ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ma ba Parao i tar pala vue ra tarai, God, pa i ga agure diat ta ra nga i ga alalu ta ra gunan kai ra tarai Pilistia, ma a dovot nam ra nga pa i ga lolovina; tago God i ga biti: Kan ba ra tarai diat a gire ta vinarubu diat a nukpuku ma diat a lilikun uro Aigipto; ");
INSERT INTO ksd_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ma God i ga agure diat ta ra nga i ga alalu ta ra bil pire ra Ta Meme; ma ra tarai dia ga kapkap ra vargal ma dia ga vana urama kan ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Ma Moses i ga kap ra ur i Iosep; tago i ga vatur vake ra vavalima kai ra tarai Israel dari: God na lalaume kapi avat, ma avat a kap ra urugu urama kan go ra gunan. ");
INSERT INTO ksd_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ma dia ga tur pa kadia vinavana maro Sukot, ma dia ga ki pit aro Etam, ta ra langun na bil. ");
INSERT INTO ksd_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ma ra Luluai i ga lua ta diat ma ra bakut ta ra bung na keake upi na lue rap diat ta ra nga; ma ta ra bung na marum i ga lua ta diat ma ra ngala na biro na iap upi na vakapa are diat; upi diat a pait ra vinavana ta ra keake ma ta ra marum; ");
INSERT INTO ksd_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","a bakut ta ra keake ma ra ngala na biro na iap ta ra marum pa dir ga vana balakane ra tarai. ");
INSERT INTO ksd_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ma ra Luluai i ga biti tai Moses dari: ");
INSERT INTO ksd_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Una ve ra tarai Israel upi diat a talil ma diat a ki boko pire Pikairot, livuan ta dir Mikdol ma ra ta, pire Baal-Sepon; avat a ki ta ra luaina matana, abara ta ra valian. ");
INSERT INTO ksd_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Ma Parao na biti ure ra tarai Israel: Dia tar vana rara ta nam ra gunan, a bil i tur kikil bat diat. ");
INSERT INTO ksd_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ma ina valeo ra bala i Parao, ma na korot mur diat; ma ina vatur vake ra minamar tai Parao ma tai kana loko na tarai na vinarubu; ma ra tarai Aigipto diat a nunure boko ba iau ra Luluai. Ma dia ga pait ia damana. ");
INSERT INTO ksd_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ma di ga ve ra king Aigipto ba ra tarai dia ga takap; ma ra bala i Parao ma ra bala i kana umana tultul i ga enana tadav ra tarai, ma dia ga biti: Ava go da tar pait ia, tago da tar pala vue ra tarai Israel kan ra papalum pire dat. ");
INSERT INTO ksd_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Ma i ga vaninare kana kiki na vinavana ma i ga agure kana tarai; ");
INSERT INTO ksd_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ma i ga pilak pa laptikai na mar na kiki na vinavana, a umana vakak, ma ra lavur kiki na vinavana mutu maro Aigipto ma ra umana luluai ta diat par. ");
INSERT INTO ksd_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Ma ra Luluai i ga valeo ra bala i Parao, ra king Aigipto, ma i ga korot mur ra tarai Israel; ma ra tarai Israel dia ga irop ma ra dekdek na lima. ");
INSERT INTO ksd_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Ma ra tarai Aigipto dia ga korot mur diat, a umana os ma ra umana kiki na vinavana par kai Parao ma kana tarai na os par ma kana lavur loko na tarai na vinarubu, ma i ga tadav diat abara pire ra ta, pire Pikairot, ta ra luaina mata i Baal-Sepon. ");
INSERT INTO ksd_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Ma ba Parao i ga vana maravai, ra tarai Israel dia ga idok, ma gire, ra tarai Aigipto ba dia ga korot mur diat; ma dia ga burut na kaia; ma ra tarai Israel dia ga tangi tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ma dia ga biti tai Moses: Dave, pa ta tung na minat aro Aigipto vang, tago u tar agure vairop avet upi avet a virua ta ra bil? Ta ra ava u pait go ra magit ta vevet ma u agure vairop avet kan Aigipto? ");
INSERT INTO ksd_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Pa ave ga ve u aro Aigipto ba una nur vue avet, upi avet a torom ta ra tarai Aigipto? Tago gala avet a torom ta ra tarai Aigipto, gala na boina, ma go i kaina, tago avet a virua ka ta ra bil. ");
INSERT INTO ksd_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Ma Moses i ga biti tai ra tarai: Koko avat a burut, avat a tur uka, ma avat a gire ra varvalaun kai ra Luluai, nina ba na pait ia ure avat go gori; tago ra tarai Aigipto, nina ava gire diat gori, pa avat a gire vatukum mule diat. ");
INSERT INTO ksd_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","A Luluai na varubu maravut avat, ma avat a ki mut uka. ");
INSERT INTO ksd_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ma ra Luluai i ga biti tai Moses: Ta ra ava u tangi tadav iau? Una ve ra tarai Israel ba diat a vana ka. ");
INSERT INTO ksd_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ma una vatur kaum buka urama, ma una tulue ra limam taun ra ta, ma una tibe varbaiane, ma ra tarai Israel diat a vurbolo livuan ta ra ta, ta ra pia i ge. ");
INSERT INTO ksd_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ma iau, gire ina valeo ra bala i Parao, ma diat a vana vurbolo mur diat; ma ina vatur vake ra minamar tai Parao, ma tai kana loko na tarai na vinarubu, ma tai kana lavur kiki na vinavana ma tai kana tarai na os. ");
INSERT INTO ksd_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ma ra tarai Aigipto diat a nunure ba iau ra Luluai ta nam ra bung ba iau vatur vake ra minamar tai Parao, ma tai kana lavur kiki na vinavana, ma tai kana tarai na os. ");
INSERT INTO ksd_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ma ra angelo kai God nina i ga lue rap ra kor na tarai Israel, i ga kakari mara na lua, ma i ga vana namur bat diat, ma ra bakut i ga kakari mara na lua, ma i ga tur namur bat diat. ");
INSERT INTO ksd_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Ma i ga tur livuan ta dir ra kor na tarai Israel ma ra kor na tarai Aigipto; ma a dovotina, a bakut ma ra bobotoi abara, ma i ga vakapa ka ra marum; ma go diat ma nam diat pa dia ga maravai vargil ta ra marum par. ");
INSERT INTO ksd_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ma Moses i ga tulue ra limana taun ra ta; ma ra Luluai i ga tulue ra ngala na taubar, ma i ga vuvu ta nam ra marum par, ma ra bala na ta i ga ge tana da ra pia, ma ra ta i ga tur varbaiai. ");
INSERT INTO ksd_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Ma ra, tarai Israel dia ga vana vurbolo livuan ta ra ta, da ta ra pia i ge, ma ra ta i ga tur da ra ura liplip na vat ta ra papar a lima tuna ma ta ra papar a maira. ");
INSERT INTO ksd_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ma ra tarai Aigipto dia ga korot mur diat, ma dia ga vana vurbolo mur diat ta ra ta, a lavur os kai Parao, ma kana lavur kiki na vinavana ma kana tarai na os. ");
INSERT INTO ksd_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ma ta ra varkia na monamono ta ra malana ra Luluai i ga bobe taun ra loko na tarai na vinarubu kai Aigipto marama ta ra biro na iap ta ra bakut, ma i ga ubu vapurpuruan ra loko na tarai na vinarubu Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ma i ga vakaina vue ra umana vil ta kadia lavur kiki na vinavana, ma pa dia ga vana bulu mulai; ma ra tarai Aigipto dia ga biti: Boina dat a vilau kan ra mata i ra tarai Israel; tago ra Luluai i varubu maravut diat ure ra tarai Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ma ra Luluai i ga biti tai Moses: Una tulue ra limam taun ra ta, upi ra ta na alir taun ra tarai Aigipto, ma taun kadia lavur kiki na vinavana, ma taun kadia tarai na os. ");
INSERT INTO ksd_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Ma Moses i ga tulue ra limana taun ra ta, ma ra ta i ga lilikun ma i ga lubu mulai ta ra malana; ma ra tarai Aigipto dia ga vilau tana; ma ra Luluai i ga vue pukue vue ra tarai Aigipto ta ra bala na ta. ");
INSERT INTO ksd_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Ma ra ta i ga lilikun mulai, ma i ga vue taun ra umana kiki na vinavana, ma ra tarai na os, maia, ra loko na tarai na vinarubu par kai Parao, diat dia ga vana mur diat ta ra bala na ta; pa ta tikai ta diat i ga virua valili. ");
INSERT INTO ksd_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ma ra tarai Israel dia ga vana ta ra pia i ge ta ra bala na ta, ma ra ta i ga da ra liplip na vat pire diat ta ra papar a lima tuna ma ta ra papar a maira. ");
INSERT INTO ksd_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Damana ra Luluai i ga valaun ra tarai Israel kan ra lima i ra tarai Aigipto ta nam ra bung; ma ra tarai Israel dia ga gire ra tarai Aigipto, a umana minatina, ta ra valian. ");
INSERT INTO ksd_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ma ra tarai Israel dia ga gire ra ngala na magit ra Luluai i ga pait ia ta ra tarai Aigipto, ma ra tarai dia ga burut tai ra Luluai ma dia ga nurnur tai ra Luluai ma ta kana tultul Moses. ");
INSERT INTO ksd_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ma Moses ma ra tarai Israel dia ga kakaile go ra kakailai tadav ra Luluai, ma dia ga biti dari: Ina kakailai tadav ra Luluai, tago i tar tut ma kana minamar; I tar vue tar ra os ma ra tena ki os ta ra ta. ");
INSERT INTO ksd_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","A Luluai kaugu kakailai ma ra dekdekigu, Ma ia ra varvalaun piragu; Kaugu dekdek na God ma ina pite pa ia; A God kai tamagu, ma ina vangala pa ia. ");
INSERT INTO ksd_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","A Luluai a tena vinarubu; A iangina — ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","A kiki na vinavana kai Parao ma kana loko na tarai na vinarubu i tar vue tar diat ta ra ta; Ma kana lavur vakak na luluai na vinarubu dia tar dudu ta ra Ta Meme. ");
INSERT INTO ksd_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","A luluruna i tuba diat; Dia tar dudu ta ra marumian da ra vat. ");
INSERT INTO ksd_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Luluai, a limam tuna i mong ma ra ongor, Luluai, a limam tuna i pamar gigi ra ebar. ");
INSERT INTO ksd_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ma ta kaum peal minamar u vue pukue vue diat dia tut na vinarubu ure u. U tar vaarike kaum kankan, ma i en vue diat da ra timul i ra kunai. ");
INSERT INTO ksd_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","A ngala na vuvu na bilaum i vatut ra tava, Ma ra lovon ta i tur da ra buana. A lamanana i dekdek ta ra bala na ta. ");
INSERT INTO ksd_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","A ebar i ga biti: Ina korot mur diat, ina tadav diat, ina tibe ra tabarikik di ga ra pa ia. A balagu na gugu ta diat, Ina ele pa kaugu pakat na vinarubu, ma ra limagu na kamare vue diat. ");
INSERT INTO ksd_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","U ga vuvu ma kaum ubar, ma ra ta i taun diat; Dia ga dudu da ra bol ta ra ngala na ta. ");
INSERT INTO ksd_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Luluai, ia ta diat ra umana god ba amur a vardada me? To ia amur a varogop me ta ra minamar i ra mangamangana gomgom, I enana ra maukuam, dia pite pa ia ma ra kakailai, ma u pait ra papalum na padapada varvo? ");
INSERT INTO ksd_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","U ga tulue ra limam tuna, Ma ra pia i konom pa diat. ");
INSERT INTO ksd_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","U tar rap lue kaum tarai ma ra varmari, nina diat u tar valaun diat. U tar agure diat ma ra dekdekim tadav ra lia na kubam. ");
INSERT INTO ksd_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","A tarai dia ga valongore, ma dia ga ururian; A kinadik i tar tadav ra tarai ta ra gunan Pilistia. ");
INSERT INTO ksd_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","I bilua ra nuknuk i ra umana luluai kai Edom. A dadadar i kinim vake ra umana luluai Moab, Ma ra tarai par dia ki Kanaan panie ra dekdek i diat. ");
INSERT INTO ksd_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","A ngala na bunurut ma ra dadadar i tadav diat; Ure ra dekdek na limam dia ki mut da ra vat, Tuk tar ta nam ra bung ba kaum tarai, Luluai, dia tar vana alu, Tuk tar ta nam ra bung ba kaum tarai dia tar vana alu, nina u tar kul kapi diat upi kaum. ");
INSERT INTO ksd_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Una agure vaolo boko diat ma una vaki diat ta ra luana ta kaum gunan, Nam ra gunan, Luluai, u ga pait ia upi una ki tana, Ra pal i gomgom, Luluai, nina a limam i ga vatur ia. ");
INSERT INTO ksd_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","A Luluai na varkurai pa na mutu. ");
INSERT INTO ksd_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Tago ra lavur os kai Parao dia ga vana ta ra ta ma kana lavur kiki na vinavana, ma kana lavur tarai na os, ma ra Luluai i ga valilikun ra ta taun diat, ma ra tarai Israel dia ga vana ta ra pia i ge, ta ra bala na ta. ");
INSERT INTO ksd_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ma Miriam, a propet, tai Aron, i ga vatur tika na kudu ta ra limana; ma ra vaden par dia ga mur ia ma ra umana kudu ma ra umana malagene. ");
INSERT INTO ksd_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ma Miriam i ga kakailai pire diat dari; Avat a kakailai tadav ra Luluai, tago i tar tut ma ra minamar. A os ma nina i ki tana, i vue tar dir ta ra ta. ");
INSERT INTO ksd_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ma Moses i ga agure pa ra tarai Israel kan ra Ta Meme, ma dia ga vana ta ra bil, a iangina Sur; ma dia ga vana a utul a bung ta ra bil, ma pa dia ga tikan tadav ta tava. ");
INSERT INTO ksd_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ma ba dia ga tadav Mara, i ga dekdek upi diat a momo ta ra tava Mara, tago i ga mapak; kari di ga vatang ra iangina Mara. ");
INSERT INTO ksd_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ma ra tarai dia ga tata na urur ure Moses, dia ga biti: Ava avet a mome? ");
INSERT INTO ksd_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Ma i ga kail tadav ra Luluai, ma ra Luluai i ga vateten tar tika na davai tana, ma i ga vue tar ia ta ra tava, ma ra tava i ga kalami. Ma ra Luluai i ga tul tar tika na varkurai ma tika na vartuluai ta diat, ma i ga valar diat ie; ");
INSERT INTO ksd_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","ma i ga biti: Ona u valongore bulu ra nilai ra Luluai kaum God ma ona u pait nam i takodo ta ra luaina matana, ma una torom ta kana lavur vartuluai, ma una mur kana lavur varkurai, pa ina tulue nam ra lavur minait piram ba iau ga tulue pire ra tarai Aigipto; pata, tago iau ra Luluai, nina iau valagar u. ");
INSERT INTO ksd_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ma dia ga pot aro Elim, nina a vinun ma a ura mata na tava tana, ma lavurua na vinun na inaina lama; ma dia ga ki abara pire ra tava. ");
INSERT INTO ksd_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Ma dia ga vana kan Elim, ma ra tarai Israel par dia ga tadav ra bil Sin, nina i ga tur livuan ta dir Elim ma Sinai, ta ra vauruana gai, a bung a vinun ma a ilima, taun kadia niirop kan ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ma ra tarai Israel par dia ga tata mukumuk ure Moses ma ure Aron ta ra bil; ");
INSERT INTO ksd_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ma ra tarai Israel dia ga biti ta dir: Gala ave virua ta ra lima i ra Luluai ta ra gunan Aigipto ba avet a ki pire ra umana kabala dia buka ma ra kirip, ma ba avet a maur ma ra bo na nian, gala na boina; ma go amur ga agure pa avet ta go ra bil, upi go ra tarai par diat a virua ma ra mulmulum. ");
INSERT INTO ksd_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ma ra Luluai i ga biti tai Moses: Gire, ina tulue ra gem marama ra bala na bakut, na da ra bata pire vavat; ma ra tarai diat a irop a bungbung par, ma diat a varurue ra tiniba ba na topa ta kopono bung, upi ina valar diat, ba diat a mur kaugu vartuluai ba pata. ");
INSERT INTO ksd_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ma ta ra valaptikaina bung diat a mal pa nina ba dia kap varurue, ma na varogop ma ra tiniba ure ra ura bung. ");
INSERT INTO ksd_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Ma Moses ma Aron dir ga biti tai ra tarai Israel par dari: Ta ra ravian avat a nunure ba ra Luluai i ga agure vairop avat kan ra gunan Aigipto, ");
INSERT INTO ksd_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ma ta ra malana avat a gire ra minamar i ra Luluai; tago i tar valongore kavava tinata na urur ure; ma to ia amir, upi avat a tata mukumuk ure amir? ");
INSERT INTO ksd_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Ma Moses i ga biti: Na damana, ra Luluai na tul tar ra kirip ta vavat ta ra ravian, upi avat a en ia, ma a peal gem ta ra malana; tago ra Luluai i ga valongore kavava tinata na urur ava urur me ure; ma to ia amir? Kavava tinata na urur ure ra Luluai, vakir ure amir. ");
INSERT INTO ksd_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ma Moses i ga biti tai Aron: Una biti tai ra tarai Israel par dari, Avat a vana maravai ta ra luaina mata i ra Luluai, tago i tar valongore kavava tinata mukumuk. ");
INSERT INTO ksd_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ma ba Aron i ga tatike ra tinata ta ra tarai Israel par, dia ga lingan upi ra bil, ma io, ra minamar kai ra Luluai i ga vana rikai ta ra bakut. ");
INSERT INTO ksd_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ma ra Luluai i ga biti tai Moses dari: ");
INSERT INTO ksd_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Iau tar valongore ra tinata na urur kai ra tarai Israel; una tata ta diat dari: Ta ra ravian avat a en ra kirip, ma ta ra malana avat a maur ma ra gem; ma avat a nunure ba iau ra Luluai kavava God. ");
INSERT INTO ksd_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ma ta ra ravian a voro i ga vana rikai, ma i ga kor ta ra gunan dia ga ki tana; ma ta ra malana a mavoko i ga va kikil ra gunan dia ga ki tana. ");
INSERT INTO ksd_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ma ba ra mavoko i ga panie, gire, tika na magit i ga va ra pia ta ra bil, i ga vulu ma i ga ikilik, a peda ik, ma i ga pua da ra mavoko i madoldol ta ra pia. ");
INSERT INTO ksd_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ma ba ra tarai Israel dia ga gire, dia ga biti vargil dari: Ava nam? Tago pa dia ga nunure ba ava. Ma Moses i ga ve diat ba: A gem go, nina ba ra Luluai i tabar avat me upi avat a en ia. ");
INSERT INTO ksd_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ia go ra magit ra Luluai i ga vartuluai ure dari: Avat a varurue, tikatikai kana tiniba ure ra nian; a kopono valavalar ure tikatikai ta vavat par; ma ra umana tutana par diat a tak pa ia ure diat ta kadia lavur pal na mal. ");
INSERT INTO ksd_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Ma ra tarai Israel dia ga pait ia damana, ma dia ga varurue, ta umana a ngala ma ta umana a ikilik. ");
INSERT INTO ksd_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ma ba dia ga valar ia ma ra valavalar, nina ba i ga varurue ra ngala, pa ta i ga tur valili pirana, ma nina i ga varurue ra ikilik, pa i ga iba upi ta na; dia ga varurue, tikatikai varogop ma nam ba na topa ia, ");
INSERT INTO ksd_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ma Moses i biti ta diat: Koko ta tikai na en valili tana upi na va boko tuk tar ta ra malana. ");
INSERT INTO ksd_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ma pa dia ga torom tai Moses; ma ga ta umana dia ga en valili ia upi urai na malana, ma ra umana kariuriu dia ga vana rikai tana, ma i ga angina; ma Moses i ga kulot ure diat. ");
INSERT INTO ksd_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ma dia ga varvarurue ta ra malamalana ta ra bungbung par, tikatikai varogop ma nam ba na topa ia; ma ba ra keake i ga papait na dekdek vanavana, i ga polo ko. ");
INSERT INTO ksd_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ma ta ra valaptikaina bung dia ga varvarurue a uraura tiniba na gem, a ura valavalar ure tikatikai; ma ra lavur luluai kai ra tarai dia ga pot, ma dia ga ve Moses. ");
INSERT INTO ksd_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ma i ga biti ta diat: la go ba ra Luluai i ga tatike dari: Ningene a ngala na bung na ningo, a Bung Sabat i gomgom tuna kai ra Luluai; avat a tun nam ava mainge, ma avat a kabalane ta nam ava mainge; ma nam par i tur valili avat a vung vake upi na topa ra bung ningene. ");
INSERT INTO ksd_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ma dia ga vung vake upi urai ga ningene da Moses i ga vartuluai tana, ma pa i ga angina, ma pa ta kariuriu tana. ");
INSERT INTO ksd_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Ma Moses i ga biti: Avat a en nam go ieri; tago ieri a Bung Sabat kai ra Luluai; gori ava mama tikan upi ta na ta ra pupui. ");
INSERT INTO ksd_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Laptikai na bung avat a varvarurue; ma a valavuruana bung, a Sabat, pa avat a gire tadav ta na. ");
INSERT INTO ksd_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ma ta ra valavuruana bung ta umana ta diat ra tarai dia ga irop, upi diat a varuruai, ma pa dia ga gire ta na. ");
INSERT INTO ksd_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ma ra Luluai i ga biti tai Moses: Aivia bung boko avat a ole kaugu lavur vartuluai tana ma kaugu lavur varkurai? ");
INSERT INTO ksd_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Gire, ra Luluai i ga tar tul tar ra Bung Sabat ta vavat, kari i ga tabar avat ta ra valaptikaina bung ma ra gem ure ra ura bung; avat par tikatikai avat a ki ta kavava gunan, koko ta tikai na irop kan kana gunan ta ra valavuruana bung. ");
INSERT INTO ksd_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Damana ra tarai dia ga ngo ta ra valavuruana bung. ");
INSERT INTO ksd_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ma ra tarai Israel dia ga vatang ra iangina ma ra Mana; ma i ga da ra pat na davai ik, i pua; ma ba di ga en kilang ia, i ga da ra gem palar ik di pait ia ma ra polo na livur i kalakalami. ");
INSERT INTO ksd_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Ma Moses i biti: Ia go ra magit ra Luluai i ga vartuluai ure dari: Avat a vung vake tika na valavalar tana ure kavava tarai namur, upi diat a gire ra gem, nina iau ga tabar avat me ta ra pupui, ba iau agure vairop avat kan ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ma Moses i ga biti tai Aron: Una tak pa ta pal a tava na vat, ma una vabuka ma tika na valavalar na Mana, ma una vung ia ta ra luaina mata i ra Luluai, ma da balaure vake upi kai kavava lavur taun tarai namur. ");
INSERT INTO ksd_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Da ra Luluai i ga vartuluai pire Moses, damana Aron i ga vung ia ta ra luaina mata i ra Tinata na Varveai upi da balaure vake. ");
INSERT INTO ksd_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Ma ra tarai Israel dia ga en ra Mana a ivat na vinun na kilala tuk tar ta nam ra bung dia ga tadav ra gunan a tarai dia ga ki tana; dia ga en ra Mana tuk tar ta nam ba dia ga tadav ra umana langun Kanaan. ");
INSERT INTO ksd_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Ma tika na valavalar i ra vavinun na pakana ta ra epa. ");
INSERT INTO ksd_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Ma ra tarai Israel par dia ga tut kan ra bil Sin, ma dia ga ki pit vanavana ta kadia vinavana varogop ma ra vartuluai kai ra Luluai, ma dia ga ki boko aro Repidim; ma pa ta tava abara upi ra tarai diat a mome. ");
INSERT INTO ksd_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Kari ra tarai dia ga vartoto ma Moses, ma dia ga biti: Una tul tar ra tava ta vevet upi avet a mome. Ma Moses i ga biti ta diat: Ta ra ava ava takun iau? Ta ra ava ava valar ra Luluai? ");
INSERT INTO ksd_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ma ra tarai dia ga kaina upi ta tava; ma ra tarai dia ga tata mukumuk ure Moses, ma dia ga biti: Ta ra ava u ga agure vairop avet kan Aigipto, upi avet a virua ma ra nimar, avet ma ra umana natu i vevet ma kaveve lavur vavaguai bula? ");
INSERT INTO ksd_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ma Moses i ga kail tadav ra Luluai, i ga biti: Ava ina pait ia pire go ra tarai? Tago dia to na tupar iau ma ra vat. ");
INSERT INTO ksd_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ma ra Luluai i ga biti tai Moses: Una vana pakit ra tarai, ma avat a varagur ma ra umana patuana kai ra tarai Israel; ma una vatur vake kaum buka, nina u ga kita ra tava alir me, ma una vana. ");
INSERT INTO ksd_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Gire, ina tur ta ra luaina matam abara ta ra ul a vat ki aro Koreb; ma una kita ra vat ki, ma ra tava na alir rikai tana upi ra tarai diat a momo. Ma Moses i ga pait ia ta ra luaina mata i ra umana patuana kai ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ma i ga vatang ra iang i ra gunan ba Masa ma Meriba, ure ra vartoto kai ra tarai Israel, ma tago dia ga valar ra Luluai ma dia ga biti: Dave, ra Luluai i ki livuan ta dat ba pata? ");
INSERT INTO ksd_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Ma ra tarai Amalek dia ga vut, ma dia ga varubu ma ra tarai Israel aro Repidim. ");
INSERT INTO ksd_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Ma Moses i ga biti tai Iosua: Una pilak pa ta umana tutana ure dat, ma una vana, una varubu ma ra tarai Amalek; ningene ina tur ta ra ul a luana ma ina vatur vake ra buka kai God ta ra limagu. ");
INSERT INTO ksd_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Io, Iosua i ga pait ra magit Moses i ga tatike tana, ma dia ga varubu ma Amalek; ma Moses ma Aron ma Kur dital ga tutua urama ta ra ul a luana. ");
INSERT INTO ksd_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ma ba Moses i ga tulue ra limana urama, Israel i ga ongor, ma ba i ga vabura ra limana, Amalek i ga ongor. ");
INSERT INTO ksd_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ma ra ura lima i Moses dir ka malmalu; ma dir tak pa ra vat, dir ga vung ia ta ra vavaina, ma i ga ki tana; ma Aron ma Kur dir tukatukal ra ura limana, tikai tai tika na papar, ma ta ra tikai tai ta ra papar; ma ra ura limana dir ga ongor, ma i ga tuk tar ta ra keake i ga kuba. ");
INSERT INTO ksd_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ma Iosua i ga uvia pa Amalek ma kana tarai ma ra pakat na vinarubu. ");
INSERT INTO ksd_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ma ra Luluai i ga biti tai Moses: Una tumu go tai ta tika na buk upi na tur na im, ma una manga vateten Iosua tana, tago ina pun vakakit vue ra iang i Amalek ta ra vavai na bakut. ");
INSERT INTO ksd_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ma Moses i ga pait tika na uguugu na vartabar, ma i ga vatang ra iangina ba Luluai-Nisi; ");
INSERT INTO ksd_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","tago i ga biti dari: Da vatur ra vakilang kai ra Luluai. A Luluai na varvarubu vatikai ma Amalek ta ra lavur taun tarai par namur. ");
INSERT INTO ksd_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ma Ietro, a tena tinabar aro Midian, nimu i Moses, i ga valongore ra tinata ure ra lavur magit God i ga pait ia ure Moses ma ure Israel kana tarai, ma ba ra Luluai i ga agure vairop ra tarai Israel kan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Ma Ietro, nimu i Moses, i ga agure Sipora, a taulai, ai Moses, nina i ga tulue valilikun mule, ma a ura natuna, a ura tutana; ");
INSERT INTO ksd_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","tikai ta dir a iangina Gersom, tago i ga biti: Iau ga ki na vaira ta ra gunan na vaira. ");
INSERT INTO ksd_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ma ra iang i ta ra tikai Elieser, tago i ga biti: A God kai tamagu i ga maravut iau. ma i tar valaun iau kan ra pakat na vinarubu kai Parao. ");
INSERT INTO ksd_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Ma Ietro, nimu i Moses, diat ma ra ura natuna ma kana taulai, dia ga vana tadav Moses ta ra bil nina i ga ki tana pire ra luana kai God. ");
INSERT INTO ksd_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Ma i ga biti tai Moses: Iau Ietro, nimum, iau vana piram, avet ma kaum taulai ma kana ura bul tutana. ");
INSERT INTO ksd_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Ma Moses i ga totongo upi nimuna, ma i ga va timtibum ma i ga galum ia; ma dir ga tir vargiliane dir ure kadir kini; ma dir ga ruk ta ra pal na mal. ");
INSERT INTO ksd_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ma Moses i ga ve nimuna ta ra lavur magit ba ra Luluai i ga pait ia tai Parao ma tai ra tarai Aigipto ure ra tarai Israel, ma i ga ve ta ra lavur magit na varmonong i ga tadav diat ta ra nga, ma ba ra Luluai i ga valaun diat i tana. ");
INSERT INTO ksd_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Ma Ietro i ga gugu ure ra varmari kai ra Luluai tadav ra tarai Israel, tago i ga tar valaun diat kan ra lima i ra tarai Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Ma Ietro i ga biti: A pite varpa tadav ra Luluai, nina i tar valaun avat kan ra lima i ra tarai Aigipto ma kan ra lima i Parao. ");
INSERT INTO ksd_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Go iau nunure ba ra Luluai i lia ta diat ra lavur god, maia, ta nam ra magit iat ba dia ga arung bat diat i tana. ");
INSERT INTO ksd_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Ma Ietro, nimu i Moses, i ga kapkap ra tinabar di tuntun ia, ma ra umana vartabar pire God; ma Aron i ga vut ma ra umana patuana kai ra tarai Israel, upi diat a ian varurung ma nimu i Moses ta ra luaina mata i God. ");
INSERT INTO ksd_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ma ta ra kubak tana, Moses i ga ki upi na varkurai pire ra tarai; ma ra tarai dia ga tur kikil Moses; i ga tur pa ia ta ra malana ma i ga tuk tar ta ra ravian. ");
INSERT INTO ksd_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ma ba nimu i Moses i ga gire ra lavur magit ba i ga varvakai me pire ra tarai, i ga biti: Ava go ra magit u varvakai me pire ra tarai? Ta ra ava u ki varkolono ma ra tarai dia tur kikil u, i tur pa ia ra malana ma i tuk tar ta ra ravian? ");
INSERT INTO ksd_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Ma Moses i ga biti tai nimuna: Tago ra tarai dia tadav iau, upi diat a titir pire God; ");
INSERT INTO ksd_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","ba ta magit pire diat, dia tadav iau, ma iau varkurai pire ra tarai ma ra umana talai diat, ma iau vaarike ra lavur varkurai kai God ma kana lavur vartuluai ta diat. ");
INSERT INTO ksd_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Ma nimu i Moses i ga biti tana: Go ra magit u pait ia pa i boina. ");
INSERT INTO ksd_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Tuka boko una bilua, avat par ma ra tarai dia ki piram; tago go ra papalum i mamat piram, pa i tale u pi una pait varkolono pa ia. ");
INSERT INTO ksd_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Boina ba una valongore kaugu tinata, ma ina vateten u, ma God na maravut u. Una tur ta ra luaina mata i God ure ra tarai, ma una kap ra umana mamat na magit na varkurai tadav God. ");
INSERT INTO ksd_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ma una tovo diat ta ra lavur varkurai ma ra lavur vartuluai, ma una vateten diat ta ra nga ba diat a vana tana ma ra papalum ba diat a pait ia. ");
INSERT INTO ksd_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ma tikai bula: una pilak pa ra umana tena kabinana ta diat ra tarai, a umana tutana ba dia ru God ma dia dovot na dia milikuane ra vapuak ba pa i takodo; ma una tibe diat upi diat a lualua ure ra arip na marmar, ma ure ra umana marmar, ma ure ra ilima na vinvinun, ma ure ra vinvinun; ma diat a kure ra tarai ta ra lavur bungbung par; ");
INSERT INTO ksd_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","ma ra lavur ngala na magit boina ba diat a kap diat piram, ma ra lavur ikilik na magit diat iat diat a kure; damana pa na manga mamat mulai piram, ma diat a pupuak maravut u. ");
INSERT INTO ksd_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ona u pait go ra magit ma God bula i vartuluai damana piram, na tale u ra papalum, ma ra tarai diat a lilikun ta ra kubakuba i diat ma ra malmal. ");
INSERT INTO ksd_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Ma Moses i ga torom ta ra tinata kai nimuna, ma i ga pait ra lavur magit i ga tatike. ");
INSERT INTO ksd_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Ma Moses i ga pilak pa ra umana bo na tutana ta diat ra tarai Israel par, ma i ga tibe diat upi diat a lualua ure ra umana arip na marmar, ma ure ra umana marmar, ma ure ra umana ilima na vinvinun, ma ure ra umana vinvinun. ");
INSERT INTO ksd_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ma dia ga kure ra tarai ta ra lavur bungbung par; ma ra lavur mamat na magit na varkurai dia ga kap diat tadav Moses, ma ra lavur magit i ikilik diat iat dia ga kure. ");
INSERT INTO ksd_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Ma Moses i ga nur vue nimuna upi na vana mulai kan ia; ma i ga vana mulai ta kana gunan iat. ");
INSERT INTO ksd_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Ma ba a utul a gai i ga taun ra niirop kai ra tarai Israel kan ra gunan Aigipto, ta nam ra bung iat dia ga tadav ta bil Sinai. ");
INSERT INTO ksd_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Ma ba dia ga vana mulai kan Repidim, ma dia ga tadav ra bil Sinai, dia ga ki boko ta ra bil; ma ra tarai Israel dia ga ki pit ta ra luaina mata i ra luana. ");
INSERT INTO ksd_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ma Moses i ga tutua urama tadav God, ma ra Luluai i ga oro pa ia marama ra luana, ma i ga biti: Go ra magit una tatike tai ra kuba i Iakob, ma una ve ra tarai Israel dari: ");
INSERT INTO ksd_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Ava tar gire ra lavur magit iau tar pait ia ta ra tarai Aigipto, ma ba iau tar puak pa avat da ma ra bebea i ra taragau, ma iau tar agur pa avat piragu. ");
INSERT INTO ksd_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Io, ona avat a torom tuna ta ra nilaigu, ma avat a mur kaugu kunubu, ina pilak pa avat ta ra lavur vuna tarai upi avat kaugu enana tarai iat; tago kaugu ka ra rakarakan a gunagunan; ");
INSERT INTO ksd_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ma avat a da ra vuna tena tinabar piragu ma ra gomgom na vuna tarai! Go ra lavur tinata una tatike ta ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ma Moses i ga pot, ma i ga oro pa ra umana patuana kai ra tarai Israel, ma i ga tul tar go ra lavur tinata ta diat ba ra Luluai i ga ve tar ia tana. ");
INSERT INTO ksd_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ma ra tarai par dia ga tata bali ia, ma dia ga biti: Avet a pait ra lavur magit ra Luluai i tar tatike. Ma Moses i ga kap ra varvai ure ra tinata kai ra tarai tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ma ra Luluai i ga biti tai Moses: Gire, ina vana piram ta ra marut na bakut upi ra tarai diat a valongore ba ina tata piram, upi diat a nurnur vatikai tam bula. ");
INSERT INTO ksd_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ma ra Luluai i ga biti tai Moses: Una vana tadav ra tarai, ma una vagomgom diat; ");
INSERT INTO ksd_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","diat a puk vagomgom kadia lavur mal ma diat a vaninara upi ra vautuluna bung, tago ta ra vautuluna bung ra Luluai na vana ur ta ra luaina mata i ra tarai ma na ki ta ra ul a luana Sinai. ");
INSERT INTO ksd_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ma una pait ra poro kikil ia ure ra tarai, ma una biti: Avat a balaure avat, upi koko avat a tutua ta ra luana, ma koko avat a tur ta kana langun; diat par dia rua ra luana diat a virua muka; ");
INSERT INTO ksd_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ba ta lima i tikai na bili ia, da tupar ia ka ma ra vat, ba da tut ia, ba ta vavaguai ba ta tutana; ba dia valongore ra tavur, io, diat a tutua ta ra luana. ");
INSERT INTO ksd_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ma Moses i ga vana ba marama ra luana tadav ra tarai ma i ga vagomgom ra tarai; ma dia ga puk vagomgom kadia lavur mal. ");
INSERT INTO ksd_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ma i ga biti tai ra tarai: Avat a vaninara upi ra vautuluna bung; i tabu ra vaden pire vavat. ");
INSERT INTO ksd_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ma ta ra vautuluna bung, ta ra malana, i ga pipi, ma i ga pala ra meme, ma a ivarat i ga ki taun ra luana, ma tika na tavur i ga tangi; ma ra tarai par ta ra gunan dia ga dadadar. ");
INSERT INTO ksd_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Ma Moses i ga agur pa ra tarai upi diat a varkuvo ma God; ma dia ga tur ta ra bit a luana. ");
INSERT INTO ksd_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ma ra luana Sinai par i ga mi, tago ra Luluai i ga vana ba tana ma ra iap; ma ra miina i ga tubang da ra mi kai ra ubu, ma ra luana par i ga guria na kaia. ");
INSERT INTO ksd_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ma ba ra nilai ra tavur i ga ngala vanavana, Moses i ga tata, ma God i ga tata bali ia ma ra nilaina. ");
INSERT INTO ksd_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ma ra Luluai i ga vana ba ta ra ul a luana Sinai, ma ra Luluai i ga oro pa Moses pi na vana urama ta ra ul a luana; ma Moses i ga tutua urama. ");
INSERT INTO ksd_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Ma ra Luluai i ga biti tai Moses: Una kuba, una tigal ra tarai, kan diat a rada ra poro upi diat a tadav ra Luluai ma diat a bobo, ma mangoro ta diat diat a virua. ");
INSERT INTO ksd_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ma ra umana tena tinabar bula, diat dia maravai pire ra Luluai, diat a vagomgom diat mulai, kan ra Luluai na pait ra kamara pire diat. ");
INSERT INTO ksd_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Ma Moses i ga biti tai ra Luluai: I dekdek upi ra tarai diat a tutua urama ta ra luana Sinai, tago u ga vartuluai dari: Una pore bat ra luana ma una vatabue. ");
INSERT INTO ksd_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ma ra Luluai i ga biti tana: Una vana ur; ma namur amur ma Aron, amur a tutua urama; ma una tigal ra umana tena tinabar ma ra tarai upi koko diat a rada ia upi diat a tutua tadav ra Luluai kan na pait ta kamara pire diat. ");
INSERT INTO ksd_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ma Moses i ga irop, ma i ga tadav ra tarai, ma i ga ve diat. ");
INSERT INTO ksd_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ma God i ga tatike go ra lavur tinata, ma i ga biti: ");
INSERT INTO ksd_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Iau ra Luluai kaum God, nina i ga agure vairop u kan ra gunan Aigipto, kan ra kuba i ra kini na vilavilau. ");
INSERT INTO ksd_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Koko una torom tai ta ra umana god bula. ");
INSERT INTO ksd_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Koko una poko kaum ta tabataba, ba ta malalar i tika na magit arama ra bala na bakut, ba tika na magit ra pia, ba tika na magit ta ra tava ta ra bala na pia. ");
INSERT INTO ksd_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Koko una va timtibum tadav diat ma koko una torom ta diat; tago iau ra Luluai kaum God, iau a God a tena ongor, ma ina bali ra varpiam kai ra tarai tadav ra umana natu i diat ma na tuk tar ta ra vautuluna ma ra vaivatina taun tarai pire diat dia milikuane iau; ");
INSERT INTO ksd_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ma ina mari ra vinvinun na marmar na taun tarai ta diat dia mari iau, ma dia torom ta kaugu lavur vartuluai. ");
INSERT INTO ksd_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Koko una vatang vakuku ra iang i ra Luluai kaum God, tago ra Luluai pa na nuk vue ra balbali pire nina i vatang vakuku ra iangina. ");
INSERT INTO ksd_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Una kodop ra Bung Sabat upi una ru ia. ");
INSERT INTO ksd_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Laptikai na bung una ongaongor, ma una pait vapar kaum papalum tana; ");
INSERT INTO ksd_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ma ra valavuruana bung ia ra Sabat kai ra Luluai kaum God; koko avat a papalum tana, u, ba natum a tutana, ba natum a vavina, ba kaum tultul a tutana, ba kaum tultul a vavina, ba kaum vavaguai, ba ra vaira i ki ta kaum gunan; ");
INSERT INTO ksd_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","tago laptikai na bung ra Luluai i ga vaki ra bala na bakut ma ra rakarakan a gunagunan tana, ma ra ta, ma ra magit par i ki ta dital, ma i ga ngo ta ra valavuruana bung; ia ra vuna tago ra Luluai i ga vadoane tana ra Sabat, ma i vagomgom ia. ");
INSERT INTO ksd_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Una ru tamam ma nam, upi na lolovina kaum nilaun ta nam ra gunan ba ra Luluai kaum God na tabar u me. ");
INSERT INTO ksd_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Koko una doko ta tikai. ");
INSERT INTO ksd_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Koko una po. ");
INSERT INTO ksd_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Koko una long. ");
INSERT INTO ksd_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Koko una varvai vavaongo ure ta tikai. ");
INSERT INTO ksd_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Koko i puruai ra balam upi ra pal kai ta tikai, koko i puruai ra balam upi ra vavina kai ta tikai, ba upi kana tultul a tutana, ba kana tultul a vavina, ba kana bulumakau, ba kana as, ba upi ta magit kai ta tikai. ");
INSERT INTO ksd_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ma ra tarai par dia ga gire ra pipi, ma ra meme, ma ra nilai ra tavur, ma ra mi ta ra luana; ma ba ra tarai dia ga gire, dia ga dadadar, ma dia ga tur aro vailik * ");
INSERT INTO ksd_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ma dia ga biti tai Moses: U iat una tata ta vevet, ma avet a valongore; ma koko God iat na tata ta vevet, kan avet a virua. ");
INSERT INTO ksd_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Ma Moses i biti tai ra tarai: Koko avat a burut, tago God i tar vut upi na valar avat ma upi ra bunurut pirana na tur ta ra luaina mata i vavat upi koko ava pait ra varpiam. ");
INSERT INTO ksd_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Ma ra tarai dia ga tur aro vailik, ma Moses i ga kakari maravai tadav ra bingnimuna, nina ba God i ga ki tana. ");
INSERT INTO ksd_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ma ra Luluai i ga biti tai Moses: Una ve ra tarai Israel dari: Avat iat ava valongore ba iau ga tatata ta vavat marama ra bala na bakut. ");
INSERT INTO ksd_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Koko avat a pait kavava ta god upi amir a tur varurung me; ta god na silva, ba ta god na goled, koko avat a pait ia upi kavavat. ");
INSERT INTO ksd_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Una pait kaugu ta uguugu na vartabar, ma una vartabar tana ma kaum lavur tinabar di tuntun tar diat, ma kaum tinabar na varmaram, kaum sip ma kaum bulumakau; ta ra lavur pakana gunan ba ina vaarike tar ra iangigu tana, ina tadav u, ma ina vadoane u. ");
INSERT INTO ksd_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ma ba u pait ta uguugu na vartabar ma ra vat, koko una pait ia ma ra vat di mut mal ia, tago ona u palum ia ma kaum mumumut u tar vakaina. ");
INSERT INTO ksd_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Go bula: koko una vana urama ta kaugu uguugu na vartabar ta ra koko rikai, upi koko diat a gire ra pakam tuna. ");
INSERT INTO ksd_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Ma go ra umana varkurai una tul tar ia ta diat: ");
INSERT INTO ksd_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Ona u kul ta tika na tultul, a tutana Ebraio, na kudakudar laptikai na kilala piram, ma ta ra valavuruana una pala vakuku vue. ");
INSERT INTO ksd_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ona i tar pot a inip na tutana, na irop mulai a inip na tutana; ma ona i taulai, dir ma kana taulai dir a irop. ");
INSERT INTO ksd_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ba kana lualua i tul tar ta vavina tana, ma i kava ra umana bul tutana ba ra umana bul vavina, kana lualua na kale nam ra vavina ma ra umana natuna, ma ra tutana ka na irop. ");
INSERT INTO ksd_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ma ari ona ra tultul i tata kapa ma i biti dari: Iau mari kaugu lualua, ma iau mari kaugu taulai ma ra umana natugu bula; pa iau mainge ba na pala vue iau, ");
INSERT INTO ksd_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","io, kana lualua na agur pa ia tadav God, ma na vatur ia ta ra matakilalat, ba ta ra tukal i ra matakilalat, ma kana lualua na ing ra talingana ma ra barbar; ma na kudakudar pirana vatikai. ");
INSERT INTO ksd_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Ma ba ta tutana na ivure kana bul vavina upi na ki na tultul, koko una pala vue nam da ra tultul na tutana. ");
INSERT INTO ksd_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ma ona kana lualua, nina i ga vakilang bat ia, pa i gugu tana, io, da kul are mule; i dekdek upi na ivure tai ra umana tematana, tago i ga tuam pa ia. ");
INSERT INTO ksd_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ma ona i vakilang bat ia upi kai natuna a tutana, na pait ra magit i takodo tana, da tai natuna a vavina. ");
INSERT INTO ksd_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ma ona na taule ta ra tikai, koko na muie ra ana kirip, ma kana mal ma ra kini na bartaulai. ");
INSERT INTO ksd_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ma ona pa i tul tar ia tana go ra utul a magit, io, na irop vakuku ka, ma koko ra varkul tana. ");
INSERT INTO ksd_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Nina i kita tika na tutana upi na mat, na virua muka. ");
INSERT INTO ksd_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ma ona pa i parau upi ia, ma God i tul tar ia upi na ubu vatuptup ia ka, io, ina kure tar ta pakana gunan tam, ba na vilau tana. ");
INSERT INTO ksd_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ma ona ta tutana i kankan ure ta tikai ma i ub ia ka ta ra vartuam, una ben vaire kan kaugu uguugu na vartabar upi na virua. ");
INSERT INTO ksd_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Ma nina i kita tamana ma nana na virua muka. ");
INSERT INTO ksd_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Ma nina i long ta tikai, ma i ivure, ba ona i ki ka pirana, nam na virua muka. ");
INSERT INTO ksd_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Ma nina i tata kakaina ure tamana ba nana na virua muka. ");
INSERT INTO ksd_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Ma ona ra tarai dia varngangar, ma tikai i tupar ta ra tikai ma ra vat, ba i tibul ia ma ra limana, ma pa i mat tana, i vava ka, ");
INSERT INTO ksd_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ona i tut mulai, ma i vanavana ma ra buka, io, nina i ga ub ia na langalanga; ia kaka na porong ia ure kana kini vakuku ma na maravut ia upi na lagar bulu mulai. ");
INSERT INTO ksd_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Ma ba ta tikai i kita kana tultul a tutana ba kana tultul a vavina ma ra davai, ma i mat lulut, da kure bali ia. ");
INSERT INTO ksd_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ma ona na laun boko ta urua ba ta utul a bung, koko da kure bali ia, tago i da i rara kana mani. ");
INSERT INTO ksd_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Ma ona ra tarai dia varngangar vargil, ma dia vakaina tika na vavina i kap bala, ma i kava pit ra bul, ma pa i kaina tai ta magit mulai namur, nam ra tutana na varkul tana, varogop ma ra varkul ra tutana kai nam ra vavina i vatang upi ia; na tul tar ia ba ra umana tena varkurai dia mulaot i tana. ");
INSERT INTO ksd_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Ma ona ta kaina magit boko i tadav ra vavina, io, una bali ia, a nilaun ma ra nilaun, ");
INSERT INTO ksd_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","a kiau na mata ma ra kiau na mata, a pal a ngia ma ra pal a ngia, a lima ma ra lima, a keke ma ra keke, ");
INSERT INTO ksd_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","a baba na iap ma ra baba na iap, a kinkin ma ra kinkin, a pal a vidiraen ma ra pal a vidiraen. ");
INSERT INTO ksd_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Ma ba tikai i tibul ra kiau na mata i kana tultul a tutana, ba ra kiau na mata i kana tultul a vavina, na pala vakuku vue ra tultul ure ra kiau na matana. ");
INSERT INTO ksd_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ma ona i tumak rubat vue ra pal a ngie i kana tultul a tutana, ba kana tultul a vavina, na pala vakuku vue ure ra pal a ngiene. ");
INSERT INTO ksd_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Ma ona ta bulumakau i go tika na tutana, ba tika na vavina, ma dir mat, da tupar doko nam ra bulumakau, ma koko di en ra viono; ma nina ba kana ra bulumakau na langalanga. ");
INSERT INTO ksd_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ma ona damana iat ra mangamangana kai nam ra bulumakau, ma ba i ga varubu lua, ma ba di ga ve nam ra tutana ba kana, ma pa i ga veva, ma i ga doko ta tutana ba ta vavina: da tupar doko nam ra bulumakau, ma nam ra tutana ba kana na virua bula. ");
INSERT INTO ksd_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ma ona di kure tar ta varkul tana, na tul tar ia da ra varporong ure kana nilaun, a magit par ba di kure tar ia. ");
INSERT INTO ksd_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ba i ga go ta bul tutana ba ta bul vavina i varogop, da pait go ra varkurai tana. ");
INSERT INTO ksd_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ba ra bulumakau i go ta tultul a tutana, ba ta tultul a vavina, na tul tar ia ta kadir lualua a utul a vinun na pakana silva, ma da tupar doko ra bulumakau. ");
INSERT INTO ksd_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Ma ona ta tikai i papa are ta tung, ba ona ta tikai i kal ta tung, ma pa i tuba, ");
INSERT INTO ksd_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ma tika na bulumakau ba ta as i bura tana, nina ba kana ra tung na bali pa ia ma ra mani, ma ra viruana kana ka. ");
INSERT INTO ksd_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Ma ona ra bulumakau kai ta tikai i ubu vakaina ra bulumakau kai ta ra tikai, ma i mat, io, dir a ivure ra bulumakau i laun, ma dir a tibe ra mataina ta dir par; ma dir a tibe bula ra viruana. ");
INSERT INTO ksd_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ma ona di nunure ba lua bula ra mangamangana iat kai nam ra bulumakau upi na varubu, ma nina ba kana pa i ga veva, na bali ra bulumakau ma ra bulumakau, ma na vatur vake ra viruana. ");
INSERT INTO ksd_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Ba tikai i long tika na bulumakau, ba tika na sip, ma i doka, na bali ra kopono bulumakau ma ra ilima na bulumakau, ma ra kopono sip ma ra ivat na sip. ");
INSERT INTO ksd_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","A tena nilong na varkul, ma ona pa i vung ta magit boina ba da ivure ure kana nilong. Ma ona nam ra magit i long ia na laun boko pirana, ba ta bulumakau, ba ta as, ba ta sip, na vaura bali ia. Ona di babare ra tena kinakinau ba i lolobong, ma dia ubu doka, koko ra vartakun ure ra gapuna. Ona ra keake i tar vana rikai, da vartakun ure ra gapuna. ");
INSERT INTO ksd_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Ba tikai i vague kana umana vavaguai ta kana uma ba ra uma na vain, ma pa i balaure diat, ma dia vana lake ta ra uma kai ta ra tikai, na bali ia ma ra magit i boina kakit ta kana uma iat, ma ra magit i boina kakit ta kana uma na vain. ");
INSERT INTO ksd_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Ba ra iap i vana pangai ma i vautunge ra kait ma i imur bula ra vinvin na kon, ba ra kon i tur boko, ba ta enana magit ta ra uma, nina ba i ga vautunge ra iap na bali ia. ");
INSERT INTO ksd_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Ba tikai i vung kapi ta mani ba ta tabarikik pire talaina upi na balaure, ma di long ia ta ra kuba i ra tutana, a tena nilong, ona dia tikan tadav ia, na vaura bali ia. ");
INSERT INTO ksd_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ona pa di tikan tadav ra tena nilong, a lualua na pal na tadav God ma da titir ba ia iat bar i ga tak pa ra tabarikik kai talaina ba pata. ");
INSERT INTO ksd_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ta ra lavur vartakun, ba ure ta bulumakau, ba ta as, ba ta sip, ba ta mal ba ta enana magit i rara, nina tikai i biti tana: Go, ia ra magit! da kap kadir tinata par tadav God; ma nina ba God na kure tar ia na vaura bali ia tadav talaina. ");
INSERT INTO ksd_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Ona tikai i vatur kapi tika na as, ba tika na bulumakau, ba ta sip, ba ta enana vavaguai pire talaina upi na mataure, ma i mat ika, ba i kaina tai tika na magit, ba ona di ra pa ia, ma pa ta na i gire; ");
INSERT INTO ksd_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","a vavalima kai ra Luluai na tur livuan ta dir par ba pa i vatur vake ra tabarikik kai talaina, ma nina kana ra tabarikik na kapupi ia; ma koko na alube pa ta varkul. ");
INSERT INTO ksd_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ma ona di tar long ia na bali ia pire nina ba kana. ");
INSERT INTO ksd_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ma ba ta kaina leing i tar ubu kadakadal ia, boina na kap ia upi da nunure ra dovotina; koko na kul bali nina di ga ubu kadakadal ia. ");
INSERT INTO ksd_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Ma ba tikai na kail ta vavaguai tai talaina, ma i kaina tai ta magit ba ona i mat, ma nina ba kana pa i ki pirana, na kul bali ia ka. ");
INSERT INTO ksd_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ari nina ba kana i ki pirana, koko na varkul ure; ma ona ia ra magit ba di tokom ia, io, kana totokom na topa ia. ");
INSERT INTO ksd_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Ba tikai i vo pa ra inip na vavina ba pa di vakilang bat ia, ma dir po me, na pait ra varkukul ure upi na taulai me. ");
INSERT INTO ksd_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ona tama i ra inip na vavina i ole upi na tul tar ia tana, na kul ia ka ma ra magit i topa ra varkul ure ra inip na vavina. ");
INSERT INTO ksd_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Koko una mulaot ba ra tena agagar, a vavina, na laun piram. ");
INSERT INTO ksd_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Nina dir pait ra kaina ma ra vavaguai na virua muka. ");
INSERT INTO ksd_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Nina ba i pait ra tinabar tadav ta enana god ma vakir tadav ra Luluai kaka, nam na virua muka. ");
INSERT INTO ksd_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Ma koko una pait ta magit i rara tai ta vaira, ma koko una arung bat ia, tago ava ga ki na vaira ta ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Koko ava vakadik ta ua na vavina ba ta nat na ling. ");
INSERT INTO ksd_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ona u vakadik dir ma ta mangamangana ma dir tangi tadav iau, ina valongore muka kadir tinangi; ");
INSERT INTO ksd_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ma kaugu kankan na ngala, ma ina ubu doko u ma ra pakat na vinarubu; ma kavava umana taulai diat a ua na vavina boko, ma ra umana natu i vavat diat a ki na nat na ling ika. ");
INSERT INTO ksd_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Ona tikai a luveana ta kaugu tarai piram i kail pa ra mani tam, koko una da ra tena piapie mani pirana, ma koko una kure tar ta vavatur tana. ");
INSERT INTO ksd_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ba u vatur vake ra mal kai ta tikai da ra vuvung varirap, una vamule tana ba ra keake i vana ba; ");
INSERT INTO ksd_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","tago nam uka kana tubatuba, kana olovoi ure ra pal a pakana; na va ma ra ava? Ma ona i tangi tadav iau, ina valongore, tago iau a tena varmari. ");
INSERT INTO ksd_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Koko una vul God, ma koko una tata vakaina ra lualua kai kaum tarai. ");
INSERT INTO ksd_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Koko una muie vake ra vartabar ta ra peal vuai kaum uma ma ra polo i ra vuai ra vain. A luaina ta diat ra umana natum, a umana tutana, una tabar iau me. ");
INSERT INTO ksd_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Damana una pait ia bula ma kaum nat na bulumakau ma kaum nat na sip; lavurua na bung na ki pire tinana, ma ta ra valavutuluna una tabar iau me. ");
INSERT INTO ksd_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Ma avat kaugu tarai, avat a gomgom; kari koko avat a en ra kanomong i ta vavaguai di ubu kadakadal ia ara ra pui; avat a tabar ika ra umana pap me. ");
INSERT INTO ksd_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Koko una vatang vanavana ra varvai vavaongo, ma koko una maravut nina i rara ma ra varvai i gegagege. ");
INSERT INTO ksd_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Koko una mur ra nuknuk i ra kor upi ra kaina; ma koko una varvai maravut ta ra magit na vartakun vardada ma ra nuknuk i ra kor ika upi una pukue varara ra varkurai; ");
INSERT INTO ksd_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ma koko una maravut vakuku ra luveana ta kana vavaarikai. ");
INSERT INTO ksd_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Ari u varkuvo ma ra bulumakau ba ra as kai kaum ebar, ba i vana rara, una agure vatalil ia pirana. ");
INSERT INTO ksd_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ma ona u gire ra as kai kaum ebar, ma i tup ia ra kinakap, koko una nur vue, una maravut ia ka. ");
INSERT INTO ksd_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Koko una pukue vakaina ra varkurai ure kaum luveana ta kana vavaarikai. ");
INSERT INTO ksd_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Una tur irai kan ra vartakun vavaongo, ma koko nina i tuptup ma i takodo na virua; tago pa ina varkurai maravut ta tena varpiam. ");
INSERT INTO ksd_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Ma koko una alube pa ta vartabar, tago ra vartabar i vapula bat nina i kapa ra matana, ma i pukue vakaina ra magit kai ra tena takodo. ");
INSERT INTO ksd_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Ma koko una ki taun ra vaira, tago ava nunure ra nuknuk ta ra bala i ra vaira, tago ava ga ki na vaira ta ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Ma laptikai na kilala una vavauma ta kaum gunan ma una varurue ra vuaina, ");
INSERT INTO ksd_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ma ra valavuruana kilala una nur vue upi na ngo ma na tur vakuku; upi ra umana luveana ta kaum tarai diat a ian; ma nam ba dia en valili ia, a umana leing ta ra gunan diat a en ia. Damana bula una pait ia ure kaum uma na vain ma ure kaum uma na oliva. ");
INSERT INTO ksd_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Laptikai na bung una papalum tana, ma ta ra valavuruana una ngo, upi kaum bulumakau ma kaum as dir a ngo, ma ra natu i kaum tultul a vavina ma ra vaira dir a ongor mulai. ");
INSERT INTO ksd_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Ma ra lavur magit iau tar tatike ta vavat, avat a nuk pa diat, ma koko avat a nuk pa ra iang i ra umana enana god, koko avat a vatang diat ma ra ngie i vavat. ");
INSERT INTO ksd_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Una vautul ma ra pait lukara ure iau ta ra kilakilala. ");
INSERT INTO ksd_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Una pait ra lukara na gem ba pa i leven; lavurua na bung una en ra gem ba pa i leven, da iau ga vartuluai piram, ta ra bung iau ga tibe ta ra gai Abib, tago ta nam ra gai u ga irop kan ra gunan Aigipto; ma koko ta tikai na vana rikai vakuku piragu; ");
INSERT INTO ksd_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","ma una pait ra lukara na nidodoko ma ra luaina vuai kaum papalum, a vuai nam iat ba u vavaume ta ra uma; ma ra lukara ure ra ngala na varurue magit ta ra mutuai ra kilala, ba u varurue ra vuai kaum lavur papalum ta ra umauma. ");
INSERT INTO ksd_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Kaum lavur tutana diat a vautul a tur rikai ta ra luaina mata i ra Luluai God. ");
INSERT INTO ksd_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Koko una tul tar ra gapu i kaugu tinabar ma ra gem i leven, ma koko ava vung ra bira ure kaugu lukara upi na va ra marum par tuk tar ta ra malana. ");
INSERT INTO ksd_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Ra luaina ta ra luaina vuai kaum uma una kap ia ta ra kuba i ra Luluai, kaum God. Koko una kabalane ra nat na me ta ra polo na u i tinana. ");
INSERT INTO ksd_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Gire iau tulue tika na angelo na lua tam upi na mataure u ta ra nga, ma upi na agure pa u tadav nam ra gunan iau ga vaninare. ");
INSERT INTO ksd_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Una kapupi ia, ma una torom ta ra nilaina; koko una piam vue, tago pa na nur vue kaum varpiam; tago ra iangigu i tur tana. ");
INSERT INTO ksd_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ma ona u torom ta ra nilaina, ma una pait vapar ra lavur magit ba ina tatike, iau a ebar tadav kaum lavur ebar, ma a tena tur varbat pire diat dia tur bat u. ");
INSERT INTO ksd_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Tago kaugu angelo na lualua tam, ma na agure u pire ra tarai Amor, ma ra tarai Ket, ma ra tarai Peres, ma ra tarai Kanaan, ma ra tarai Kivi, ma ra tarai Iebus; ma ina li vue diat. ");
INSERT INTO ksd_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Koko una va timtibum tadav kadia umana god, ma koko una torom ta diat, ma koko una mur kadia lavur mangamangana; ma una vue pukue vue diat, ma una pamar gigi ra lavur vat dia ga vatur ia. ");
INSERT INTO ksd_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ma avat a torom tadav ra Luluai kavava God, ma na vadoane kaum nian ma kaum nimomo; ma ina tak vue ra minait livuan kan u. ");
INSERT INTO ksd_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Pa ta vavina na kakava kakaina ma pa ta na na biu ta kaum gunan; ina pait ot pa ra lavur bung mutu ure kaum nilaun. ");
INSERT INTO ksd_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ina tulue kaugu varvadadar na lua tam, ma ina vapurpuruan ra lavur tarai nina ba una tadav diat, ma ina kure kaum lavur ebar upi diat a takap kan u. ");
INSERT INTO ksd_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ma ina tulue ra varubu kakap na lua tam, ma diat a korot vue ra tarai Kivi, ma ra tarai Kanaan, ma ra tarai Ket kan ra luaina matam. ");
INSERT INTO ksd_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Pa ina korot vue diat kan ra luaina matam ta ra kopono kilala, kan ra gunan na pui ka ma ra umana leing ta ra pui diat a pepeal ma diat a vakaina u. ");
INSERT INTO ksd_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ina korot vue diat vanavana ta ra luaina matam tuk tar ta ra bung una pepeal tana, ma una kale pa ra gunan. ");
INSERT INTO ksd_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Ma ina pait kaum langun pi na tur pa ia ta ra Ta Meme ma na tuk tar ta ra ta kai ra tarai Pilistia, ma mara ra bil tuk tar ta ra Tava Alir; tago ina tul tar ra tarai ta nam ra gunan ta ra limam, ma una korot vairop vue diat ta ra luaina matam. ");
INSERT INTO ksd_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Koko ava pait ta kunubu ma diat, ba kadia lavur god. ");
INSERT INTO ksd_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Koko diat a ki ta kaum gunan, kan diat a varirap u ta ra varpiam tadav iau; tago ona u toratorom ta kadia lavur god, na varogop uka ma ra kun piram. ");
INSERT INTO ksd_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ma i ga biti tai Moses: Avat a tutua tadav ra Luluai, avat ma Aron ma Nadab ma Abiu, ma lavurua na vinun na patuana kai ra tarai Israel, ma avat a lotu maro vailik. ");
INSERT INTO ksd_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ia kaka Moses na vana maravai pire ra Luluai, ma koko diat a kakari maravai, ma koko ra tarai diat a tutua varurung me. ");
INSERT INTO ksd_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Ma Moses i ga tadav ra tarai, ma i ga ve diat ta ra lavur tinata par kai ra Luluai, ma ra lavur varkurai; ma ra tarai par dia tata balbali ma ra kopono nilai diat, ma dia biti: A lavur tinata ra Luluai i ga tatike, avet a pait diat, ");
INSERT INTO ksd_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ma Moses i ga tumu vake ra lavur tinata kai ra Luluai, ma i ga tut ra malana ikilik, ma i ga pait ra uguugu na vartabar ta ra bit a luana, ma i ga vatur a vinun ma a ura vat varogop ma ra vinun ma a ura vuna tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ma i ga tulue ra umana barmana kai ra tarai Israel, ma dia ga tul tar ra umana tinabar di ga tuntun tar diat tai ra Luluai, ma dia ga vartabar tar ra umana bulumakau bula upi ra tinabar na varmaram tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Ma Moses i ga tak pa ra ngungu ta ra gap, ma i ga lolonge tar ia ta ra umana la, ma ta ra ngungu i ga apur ra uguugu na vartabar me. ");
INSERT INTO ksd_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ma i ga tak pa ra buk na kunubu, ma i lululuk ta ra mata i ra tarai. Ma dia ga biti: Nam ra lavur magit ra Luluai i tar tatike, avet a pait ia, ma avet a toratorom. ");
INSERT INTO ksd_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ma Moses i tak pa ra gap, ma i apur ra tarai me, ma i biti: Gire ra gapu i ra kunubu, nina ra Luluai i ga pait ia pire vavat ure go ra lavur tinata. ");
INSERT INTO ksd_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Ma Moses ma Aron, Nadab ma Abiu dia ga tutua urama ma lavurua na vinun na patuana kai ra tarai Israel; ");
INSERT INTO ksd_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ma dia gire ra God kai Israel; ma ta ra vavai na kauna i da ra tamataman di mal ia ma ra vat na sapir, ma i ga kadenger da ra lao arama liu. ");
INSERT INTO ksd_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ma pa i ga bili vakaina ra umana lualua kai ra tarai Israel; ma dia gire God ma dia ga ian ma dia ga momo. ");
INSERT INTO ksd_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ma ra Luluai i ga biti tai Moses: Una tutua tadav iau ta ra luana ma una ki ie; ma ina tul tar ta umana pal a vat tam ma ra tinata na varkurai ma ra umana vartuluai, nina iau ga tumu ia, upi una tovo tar ia ta diat. ");
INSERT INTO ksd_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ma Moses i ga tut, dir ma kana tultul Iosua; ma Moses i ga tutua urama ra luana kai God. ");
INSERT INTO ksd_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ma i ga biti tai ra umana patuana dari: Avat a ki ung pa amir ati tuk tar ta nam ba amir a tadav mule avat; ma Aron ma Kur dir a ki pire vavat; ba tikai i mainge ta varkurai ure ta magit, boina ba na tadav dir. ");
INSERT INTO ksd_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ma Moses i tutua urama ra luana, ma ra bakut i ga pulu bat ra luana. ");
INSERT INTO ksd_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Ma ra minamar i ra Luluai i ga ki ta ra ul a luana, ma ra bakut i turup bat ia laptikai na bung; ma ta ra valavuruana bung i ga oro pa Moses marima ra bala na bakut. ");
INSERT INTO ksd_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ma di ga gire ra minamar kai ra Luluai, i ga da ra ngangap na iap ta ra ul a luana ta ra mata i ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ma Moses i ga ruk ta ra bala na bakut, ma i ga tutua urama ta ra ul a luana; ma Moses i ki a ivat na vinun na bung na keake ma a ivat na vinun na bung na marum ta ra ul a luana. ");
INSERT INTO ksd_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Ma ra Luluai i ga tatike ra tinata tai Moses dari: Una ve ra tarai Israel, ba diat a tak tar ra tinabar tagu; ");
INSERT INTO ksd_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","avat a alube pa ia ta diat par ba ra bala i diat i mariga tana. ");
INSERT INTO ksd_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Ma go ia ra tinabar ba avat a vatur vake ta diat: a goled ma ra silva, ma ra palariam gobol; ");
INSERT INTO ksd_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","a mal i blu marut, ma i meme marut, ma i meme tuna, ma ra mal kumau, ma ra ivuna me; ");
INSERT INTO ksd_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ma ra pal a sip di puk vameme pa ia, ma ra pal a me, ma ra davai akasia; ");
INSERT INTO ksd_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","a dangi ure ra lamp, a lavur magit i ang na vuvuvul ure ra dangi na varku ma ure ra mi na lotu i ang na katkat; ");
INSERT INTO ksd_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","a vat na onik ma ra vat na marmar ure ra mal na bongobongo ma ure ra popopoi. ");
INSERT INTO ksd_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Ma diat a pait kaugu ta gomgom na pal upi ina kiki livuan ta diat. ");
INSERT INTO ksd_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Avat a pait ia upi na varogop tuna ma ra lavur magit ina vaarike tam, varogop ma ra valavalar ure ra Pal ma ra valavalar ure ra lavur tabarikik tana. ");
INSERT INTO ksd_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Ma diat a pait tika na bok ma ra davai akasia; kana lolovina na varogop ma a ura malmalikun ma ra ngungu ma ra tababana varogop ma tika na malmalikun ma ra ngungu, ma tika na malmalikun ma ra ngungu a tuluaina. ");
INSERT INTO ksd_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ma una vung vapetep tar ra goled tuna tana, ta ra balana ma ta ra tamuruna, ma una mar kikil ra ul a bok ma ra goled. ");
INSERT INTO ksd_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ma una mal a ivat na ngovo ure, ma una pait vake diat ta ra ivat na kakene; a ura ngovo dir a tur tai tika na paparaina, ma ta ra urua tai ta ra tikai. ");
INSERT INTO ksd_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ma una pait ra ivu kip ma ra davai akasia, ma una vung vapetep tar ra goled tana. ");
INSERT INTO ksd_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ma una ule tar ra ura kip ta ra ngovo ta ra papar a bok, upi da kip ia me. ");
INSERT INTO ksd_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Ra ura kip dir a tur vatikai ta ra ngovo na kip, koko da ule vue dir kan ia. ");
INSERT INTO ksd_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ma una poe ra tinata, ba ina tul tar ia tam boko, ta ra bala na bok. ");
INSERT INTO ksd_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Ma una mal tika na tubatuba ma ra goled tuna; kana lolovina na varogop ma a ura malmalikun ma ra ngungu, ma a tababana na da ra malmalikun ma ra ngungu. ");
INSERT INTO ksd_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ma una mal a ura angelo ma ra goled ba di tutut ia, ma dir a ki ta ra ura ngungu na tubatuba. ");
INSERT INTO ksd_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Ma una pait tika na angelo tai tika na nguna, ma tika na angelo tai ta ra nguna; dir a kidoloina ka ma ra tubatuba ta ra ura nguna. ");
INSERT INTO ksd_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Ma ra ura angelo dir a pala ra bebea i dir urama ma dir a turup ra tubatuba me, ma dir a bobo varkuvo; ra mata i ra ivu angelo na lingan tadav ra tubatuba. ");
INSERT INTO ksd_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ma una vaki ra tubatuba urama ta ra ul a bok, ma una poe ra tinata, ba ina tul tar ia tam, ta ra bala na bok. ");
INSERT INTO ksd_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ma dor a varkuvo ie; ina ki arama ra tubatuba livuan ta ra ura angelo ta ra ul a bok na tinata, ma dor a pirpir ure ra lavur magit, ba ina vartuluai me piram upi kai ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Ma una pait tika na vuvuvung na nian ma ra davai akasia; kana lolovina na varogop ma tika na papar, ma ra tababana na varogop ma tika na malmalikun, ma ra tuluaina tika na malmalikun ra ma ngungu. ");
INSERT INTO ksd_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ma una vung vapetep tar ra goled tuna tana, ma una mar kikil ia ma ra goled. ");
INSERT INTO ksd_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Ma una pait tika na pal a davai kikil ia, a tababana na varogop ma ra tababa na lima, ma una mar kikil ra pal a davai arama. ");
INSERT INTO ksd_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ma una mal a ivat na ngovo ure ma ra goled, ma una vung ra ngovo ta ra ivat na nguna ta ra ivat na kakene. ");
INSERT INTO ksd_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ra ivat na ngovo diat a tur maravai pire ra pal a davai i vana kikil ia, ma da ule tar ra kip tana, upi da kip ra vuvuvung me. ");
INSERT INTO ksd_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ma una pait ra kip ma ra davai akasia, ma una vung vapetep tar ra goled tana, upi da kip ra vuvuvung me. ");
INSERT INTO ksd_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ma una mal pa kana umana la, ma ra umana momamomo, ma ra umana pal a tava ma ra umana la upi da lolongoi me; una pait diat ma ra goled tuna. ");
INSERT INTO ksd_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ma una vung vatikene pa ra gem na ginigira ta ra luaina matagu. ");
INSERT INTO ksd_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Ma una pait ra turtur na birao ma ra goled tuna; una tutut mal ra turtur na birao, a bitina ma ra livuana; a matana pupuna, ma ra pupuluna, ma ra mapina pupuna diat a kidoloina me; ");
INSERT INTO ksd_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","ma laptikai na ingarina ta ra ura paparaina; a utul a ingar i ra turtur na birao tai tika na paparaina ma a utul a ingarina tai ta ra paparaina; ");
INSERT INTO ksd_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","a utul a matana pupuna da ra pupuna i papala tai tika na ingarina, a pupuluna ma ra pupuna; ma a utul a matana pupuna da ra pupuna i papala tai ta ra ingarina, a pupuluna ma ra pupuna; damana ure ra laptikai na ingarina ba dia vana rikai ta ra turtur na birao; ");
INSERT INTO ksd_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","ma ta ra turtur na birao a ivat na matana pupu na davai da ra pupuna i papala, a pupuluna ma ra mapina pupuna; ");
INSERT INTO ksd_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","tika na pupuluna ta ra vavai ra ura ingarina, na kidoloina me, ure ra laptikai na ingaingarina dia vana rikai ta ra turtur na birao. ");
INSERT INTO ksd_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","A umana pupulu i diat ma ra umana ingar i diat diat a kidoloina ka me; una pait vapar ia ka ma ra goled tuna ma una tutut mal ia. ");
INSERT INTO ksd_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Ma una pait lavurua na matana lamp tana; ma diat a valiting ra umana lamp upi diat a vakapa ra maup ta ra luaina mata i diat. ");
INSERT INTO ksd_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Una pait kana kia ma ra goled tuna, ma damana bula kana la. ");
INSERT INTO ksd_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Una pait ia ma tika na talant na goled tuna, damana go ra lavur tabarikik bula. ");
INSERT INTO ksd_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Ma una nuk pa ia, upi una pait tuna diat varogop ma ra valavalar u ga gire ta ra ul a luana. ");
INSERT INTO ksd_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Ma tikai bula: Una pait ra Pal ma ra vinun na mal, a mal kumau di ga viri ia, a mal i blu marut, ma i meme marut, ma i meme tuna; una tul tar ra tena viri mal tututumu upi na viri tar ra umana angelo tana. ");
INSERT INTO ksd_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Ra lolovina kai tikatika na mal na varogop ma lavurua na pokono, ma tikatikai a tababana na varogop ma tika na pokono; ma ra valavalar kai ra umana mal par na varogop uka. ");
INSERT INTO ksd_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Da kubu guve ta ilima na mal ma ta ra ilima bula. ");
INSERT INTO ksd_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ma una pait ra umana pipidikol ma ra blu marut ta ra luaina vuna mal ta nam ra nguna ba da kubu guve dir tana ma ta ra tikai; ma una pait ia damana bula ta ra ngu i ra vauruana vuna mal. ");
INSERT INTO ksd_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","A ilima na vinun na pipidikol una pait ia ta ra luaina vuna mal, ma a ilima na vinun una pait ia ta ra ngu na mal ta ra vauruana vuna mal; a lavur pipidikol diat a tur vartalai. ");
INSERT INTO ksd_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ma una pait a ilima na vinun na al vakai ma ra goled, ma una al varpakane guve ra lavur mal ma ra al vakai; ma ra Pal na kidoloina ka. ");
INSERT INTO ksd_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Ma una pait ra umana mal ma ra ivuna me ure ra mal na tubatuba ta ra Pal; a vinun ma tika na mal una pait ia. ");
INSERT INTO ksd_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Ma tikatika na mal a lolovinana na varogop ma lavurua na pokono ma tika na papar, ma ra tababana na varogop ma tika na pokono; ma ra valavalar ure nam ra vinun ma tika na mal na varogop uka. ");
INSERT INTO ksd_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ma una pakan guve a ilima na mal upi diat a tikai, ma damana laptikai na mal upi diat a tikai, ma ra valaptikaina una pin likun ia ta ra luaina pal na mal. ");
INSERT INTO ksd_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ma una pait a ilima na vinun na pipidikol ta ra ngu na mal ta ra luaina vuna ma a ilima na vinun ta ra ngu na mal ta ra vauruana vuna. ");
INSERT INTO ksd_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ma una pait a ilima na vinun na al vakai ma ra palariam gobol, ma una vung ra al vakai ta ra pipidikol, ma una pakan guve ra pal na tubatuba upi na kidoloina. ");
INSERT INTO ksd_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ma nam ra pakana i tur valili ta ra mal na tubatuba, nam ra papar a mal i tur valili na taba rikai taun ra tamuru i ra Pal. ");
INSERT INTO ksd_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Tai tika na papar na taba rikai taun ia tika na malmalikun, ma tai ta ra papar tika na malmalikun bula ta nam ba i ki valili ta ra lolovina i ra mal, upi na tuba ra ura papar a Pal. ");
INSERT INTO ksd_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ma una pait tika na tubatuba ure ra pal na mal ma ra pal i ra sip, ba da puk vamema, ma tika na tubatuba mulai arama tana ma ra pal a me. ");
INSERT INTO ksd_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Ma una mal pa ra umana pal a davai, a akasia, ure ra Pal, ma una vatur diat. ");
INSERT INTO ksd_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Kadia lolovina na varogop ma a ura pokono ma a papar, ma a tababa i diat na varogop ma tika na malmalikun ma ra ngungu. ");
INSERT INTO ksd_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","A ura ot dir a tur ta ra pal a davai tikatikai, ma da pakan guve dir; damana una pait ia ta ra lavur pal a davai ure ra Pal. ");
INSERT INTO ksd_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ma una pait ra lavur pal a davai ure ra Pal, a ura vinun ure ra papar a taubar. ");
INSERT INTO ksd_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Ma una mal pa a ivat na vinun na kiki ma ra ngovo tana; una pait diat ma ra silva ma diat a tur na vavai ra ura vinun na pal a davai; a ura kiki ma ra ngovo tana ta ra vavai tika na pal a davai ure kana ura ot, ma a ura kiki ma ra ngovo tana na vavai tai ta ra pal a davai ure kana ura ot. ");
INSERT INTO ksd_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ma ure ra vauruana papar a Pal, ta ra papar a labur a ura vinun na pal a davai; ");
INSERT INTO ksd_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ma kadiat a ivat na vinun na kiki ba di pait ia ma ra silva; a ura kiki ta ra vavai tika na pal a davai, ma a ura kiki na vavai tai ta ra tikai. ");
INSERT INTO ksd_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ma ure ra vabuman na pal ta ra papar a taoai una pait laptikai na pal a davai. ");
INSERT INTO ksd_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Ma una mal pa a ura pal a davai ure ra ura ngu na pal ta ra vabuman. ");
INSERT INTO ksd_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Dir a tur vartalai ra pia ma na tuk urama ta ra luaina lok; na damana ure dir; dir ure ra ura ngu na pal. ");
INSERT INTO ksd_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ma a lavutul na pal a davai ma kadia lavur kiki na silva, a vinun ma laptikai na kiki; a uraura kiki ure tikatika na pal a davai. ");
INSERT INTO ksd_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Ma una mal pa ra umana davai, a akasia, ma diat a va bolabolo ta ra pal a davai i tur; a ilima ure ra pal a davai tai tika na papar a Pal, ma a ilima ure ta ra tika na papar a Pal, ");
INSERT INTO ksd_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ma a ilima ure ra pal a davai ta ra vabuman i ra Pal ta ra papar a taoai. ");
INSERT INTO ksd_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ma ra davai, nina i va bolo ra pal a davai, ma i tur livuan, a kidoloina ka, na tur pa ia tai ta tika na ngu na pal ma na tuk tai ta ra tikai. ");
INSERT INTO ksd_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ma una vung vapetep tar ra goled ta ra pal a davai, ma una mal pa kadia lavur ngovo ma ra goled ure ra umana vabolo. ");
INSERT INTO ksd_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Ma una vatur ra pal vardada ma ra valavalar u ga gire ta ra ul a luana. ");
INSERT INTO ksd_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Ma una pait ra mal na rurua kutu i blu marut, ma i meme marut ma i meme tuna, ma ra mal kumau di ga viri ia; a tena viri mal tututumu na pait ra umana angelo tana; ");
INSERT INTO ksd_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ma una vakaite tar ia ta ra ivat na tukal na davai akasia, ba una vung vapetep tar ra goled ta diat; kadia ot likun da pait ia ma ra goled, ma diat a tur ta ra ivat na kiki na silva. ");
INSERT INTO ksd_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ma una vakaite ra mal na rurua kutu ta ra vavai ra al vakai, ma una vung vabakite ra bok na tinata ta ra mal na rurua kutu, ma ra mal na rurua kutu na tibe varbaiane dir a pakana pal i gomgom ma ra pakana i tabu kakit. ");
INSERT INTO ksd_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ma una vung ra tubatuba ta ra ul a bok na tinata ta ra pakana pal i tabu kakit. ");
INSERT INTO ksd_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ma una vung vaarike ra vuvuvung na nian ta ra pakana pal i gomgom ma ra turtur na birao ta ra papar a taubar ta ra Pal, dir a tur vartalai ma ra vuvuvung na nian; ma una vung ra vuvuvung na nian ta ra papar a labur. ");
INSERT INTO ksd_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Ma una pait ra mal na poraporo ure ra matakilalat i ra pal na mal, una pait ia ma ra blu marut, ma ra meme marut, ma ra meme tuna ma ma ra mal kumau di ga viri ia, a tena niingit guvai na mal tututumu na pait ia. ");
INSERT INTO ksd_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Ma una pait a ilima na tukal ma ra davai akasia, ma una vung vapetep tar ra goled ta diat; una pait kadia ot likun ma ra goled; ma una mal pa a ilima na kiki ure diat ma ra palariam gobol. ");
INSERT INTO ksd_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Ma una pait ra uguugu na vartabar ma ra davai akasia; kana lolovina a ilima na malmalikun ma ra tababana a ilima na malmalikun; ma ra ivat na paparaina diat a varogop uka; ma ra tuluaina a utul a malmalikun. ");
INSERT INTO ksd_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ma una mal tar ra ivat na ramuna ta ra ulu i ra ivat na bukuna; a uguugu ma ra ivat na ramuna diat a kidoloina ka, ma una vung vapetep tar ra palariam gobol tana. ");
INSERT INTO ksd_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ma una pait kana umana la na kabu, ma kana umana kulkulup ma kana umana la na tava, ma kana umana kono ure ra kanomong, ma kana umana la na lakit. Kana lavur tabarikik una pait ia ma ra palariam gobol. ");
INSERT INTO ksd_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ma una pait tika na liplip na ubene tana ma ra palariam gobol, ma una mal ra ivat na ngovo ta ra liplip na ubene ta ra ivat na nguna. ");
INSERT INTO ksd_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Ma una vung ia ta ra vavai ra vanavana kikil ta ra uguugu na vartabar, ma koko na tuk urama kakit, na ki pit ika. ");
INSERT INTO ksd_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ma una pait ta ura kip ma ra davai akasia, ma una vung vapetep tar ra palariam gobol tana. ");
INSERT INTO ksd_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Ma da ule tar ra ura kip ta ra umana ngovo, ma ra ura kip dir a tur ta ra ura papar a uguugu na vartabar upi da kip ia me. ");
INSERT INTO ksd_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Una pait ia ma ra pal a davai, ma ra balana na pobono ko; varogop u tar gire ta ra ul a luana, damana una pait ia. ");
INSERT INTO ksd_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Ma una liplip bat ra bala na gunan ure ra Pal; una vakaite ra umana mal ta ra papar a taubar tana, a mal kumau ure ra bala na gunan, ma kana lolovina na varogop ma a ura vinun ma a ilima na pokono ure tika na papar; ");
INSERT INTO ksd_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ma a ura vinun na tukal tana, ma a ura vinun na kiki ure, da pait ia ma ra palariam gobol; da pait ra ot likun ure ma ra silva, ma damana bula ra umana vipuar tana. ");
INSERT INTO ksd_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ma damana bula ta ra papar a labur, una vakaite ra umana mal, ma kana lolovina na varogop ma a ura vinun ma a ilima na pokono, ma a ura vinun na tukal tana, ma a ura vinun na kiki ure, da pait ia ma ra palariam gobol; da pait ra ot likun ure ma ra silva, ma damana bula ra umana vipuar tana. ");
INSERT INTO ksd_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ma ta ra papar a taoai a mal ure ra bala na gunan na varogop ma a vinun ma a ura pokono ma a papar, ma a vinun na tukal ma a vinun na kiki. ");
INSERT INTO ksd_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ma ra tababa i ra bala na gunan ta ra papar a taur na varogop ma ra vinun ma a ura pokono ma a papar. ");
INSERT INTO ksd_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","A mal ure tika na papar ta ra mataniolo na varogop ma a utul a pokono ma a utul a malmalikun; a utul a tukal ma a utul a kiki tana. ");
INSERT INTO ksd_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Ma ure ta ra papar a mal na varogop ma a utul a pokono ma a utul a malmalikun bula; a utul a tukal ma a utul a kiki tana. ");
INSERT INTO ksd_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ma ure ra mataniolo ta ra bala na gunan da pait tika na mal na poraporo ma na varogop ma a ilima na pokono; da pait ia ma ra blu marut, ma ra meme marut, ma ra meme tuna, ma ra mal kumau, a tena niingit guvai na mal na mal kapi ia; a ivat na tukal ma a ivat na kiki tana. ");
INSERT INTO ksd_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Ma da vi puar ra lavur tukal ai ra bala na gunan ma ra silva; kadia lavur ot likun a silva, ma kadia lavur kiki a palariam gobol. ");
INSERT INTO ksd_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ra lolovina kai ra bala na gunan na varogop ma a ura vinun ma a ilima na pokono, ma ra tababana na varogop ma a vinun ma a ura pokono ma a papar, ma a tuluaina na varogop ma tika na pokono ma tika na malmalikun, da pait ia ma ra mal kumau di ga viri ia, ma kadia kiki a palariam gobol. ");
INSERT INTO ksd_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Ma ra lavur tabarikik na papalum kai ra Pal, ma kana lavur ot, ma ra lavur ot ure ra liplip na bala na gunan, da pait diat ma ra palariam gobol. ");
INSERT INTO ksd_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Ma una vartuluai pire ra tarai Israel upi diat a kap ra bo na dangi na oliva tuna piram ure ra kapa upi ra lamp na birao vatikai. ");
INSERT INTO ksd_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aron ma ra umana natuna diat a vung bulu ia ta ra varbarat, ta ra ravian ma na tuk tar ta ra malana, ta ra luaina mata i ra Luluai, ma diat a tur ta ra pakana pal mamati ta ra mal na rurua kutu, nina ba ra Tinata i bakit tana; ma ra tarai Israel diat a mur go ra vartuluai vatikai ta kadia lavur taun tarai mutu. ");
INSERT INTO ksd_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Ma ta diat ra tarai Israel una agur pa turam Aron ma ra umana natuna piram upi diat a kudakudar piragu ma ra papalum na tena tinabar, Aron, Nadab ma Abiu, Eleasar ma Itamar, a umana natu i Aron. ");
INSERT INTO ksd_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ma una pait ra umana gomgom na mal upi kai turam Aron ure ra minamar ma ra minong. ");
INSERT INTO ksd_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ma una ve diat par, a umana melem na tutana nina iau ga vabuka diat ma ra kabinana, upi diat a pait ra umana mal kai Aron upi da tibe vaire ure ra kunudar piragu ma ra papalum na tena tinabar. ");
INSERT INTO ksd_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ma diat a pait go ra umana mal: a popopoi, a kolot ure ra bongobongono, a kolot lolovina ma tika na olovoi, a mal na rarau ma a vipit; ma diat a pait ra umana gomgom na mal ure turam Aron ma ra umana natuna upi diat a kudakudar piragu ma ra papalum na tena tinabar. ");
INSERT INTO ksd_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Ma diat a vatur vake ra goled, ma ra mal i blu marut, ma i meme marut, ma i meme tuna, ma ra mal kumau. ");
INSERT INTO ksd_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Ma diat a pait ra kolot ure ra bongobongono ma ra goled, ma ra mal i blu marut, ma i meme marut, ma i meme tuna, ma ra mal kumau, a tena viri mal tututumu na viri ia. ");
INSERT INTO ksd_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","A ura al vakai ure ra ul a varana dir a tur ta ra ura nguna, upi da pakan guve me. ");
INSERT INTO ksd_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ma tika na vivi tana upi na vi ia me, da viri mal ia tuna, a papalum na varogop uka tana, ma a kidoloina pakana ka; diat a pait ra mal ma ra goled, ma ra blu marut ma ra meme marut, ma ra meme tuna, ma ra mal kumau. ");
INSERT INTO ksd_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Ma una tak pa a ura vat na onik, ma una tumu tar ra iang i ra tarai Israel tana; ");
INSERT INTO ksd_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","laptikai ra iang i diat tai tika na vat, ma ta ra laptikai dia tur valili tai ta ra tika na vat, diat a varmur varogop ma kadia kilala na nilaun. ");
INSERT INTO ksd_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","A tena tutumu ta ra vat na pait ia, ma na varogop ma ra tutumu ta ra vat ik ba di taun bat ra bulit me; una tutumu ta ra ura vat ma na varogop ma ra lavur iang i ra tarai Israel; ma una vake diat ma ra goled, ba na tur kikil diat. ");
INSERT INTO ksd_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ma una ingit vake ra ura vat ta ra ura al vakai ai ra kolot ure ra bongobongono, upi dir a ura vat na kodakodop ure ra tarai Israel; ma Aron na kap vaarike ra iang i diat ta ra luaina mata i ra Luluai ta ra ura ul a varana upi na matamatanai upi diat. ");
INSERT INTO ksd_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ma una pait a ura al vakai ma ra goled, ");
INSERT INTO ksd_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ma a ura vinau ma ra goled tuna; una kulalang dir da ra kuara, ma una vung dir ta ra ura al vakai. ");
INSERT INTO ksd_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Ma una mal pa tika na popopoi na varkurai, a tena viri mal tututumu na pait ia; a papalum tana na varogop ma ra papalum ta ra kolot na bongobongono; una pait ia ma ra goled, ma ra mal i blu marut, ma i meme marut, ma i meme tuna, ma ra mal kumau. ");
INSERT INTO ksd_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ra ivat na paparaina diat a varogop uka, ma da pin ia; kana lolovina na varogop ma tika na vartuk, ma ra tababana damana bula. ");
INSERT INTO ksd_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ma una vaki ra umana vat tana, a ivat na nga na vat; tika na ngaina: a sardia, a topas ma a kristal dital ta ra luaina rina; ");
INSERT INTO ksd_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ma ta ra vauruana rina: a emeraled, a sapir ma ra daimon; ");
INSERT INTO ksd_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ma ta ra vautuluna rina: a amber, a agat ma ra ametist; ");
INSERT INTO ksd_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ma, ta ra vaivatina rina: a beril, a onik ma ra iasper; a kiki na goled na vake diat. ");
INSERT INTO ksd_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Ma a vinun ma a ura vat varogop ma ra lavur iang i ra tarai Israel; da ra tutumu ta ra vat ik di taun bat ra bulit me, damana na tur ta diat ra iang i diat ra vinun ma a ura vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Ma una kubu vake a ura vinau ta ra popopoi, una kulalang dir ma ra goled da ra kuara. ");
INSERT INTO ksd_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Ma una pait a ura mata na goled ta ra popopoi, ma una mal vake ra ivu mata ta ra ngu na popopoi. ");
INSERT INTO ksd_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ma una kubu vake ra ura vinau na goled, di ga kulalang ia, ta ra ura mata ta ra ngu na popopoi. ");
INSERT INTO ksd_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ma nam ta ra ivu ngu i ra ura vinau una kun tar dir ta ra ura al vakai, ma una ingit tar dir ta ra ura al vakai ure ra kolot na bongobongono, dir a tur ta ra papar maro na lua. ");
INSERT INTO ksd_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ma una mal pa a ura mata ma ra goled, ma una ingit vake dir ta ra ura ngu na popopoi ara ra balana maravai ra kolot ure ra bongobongono. ");
INSERT INTO ksd_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ma una pait a ura mata ma ra goled ma una ingit vake dir ta ra vavai ra ura al vakai ta ra kolot ure ra bongobongono, ta ra papar maro na lua, ta ra varpakan tana, ma na ki arama ta ra vivi na kolot di viri mal ia tuna. ");
INSERT INTO ksd_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Ma diat a kubu guve ra umana mata na popopoi ma ra umana mata na kolot ure ra bongobongono ma ra vinau i blu marut, upi na tur ta ra vivi ai ra kolot na bongobongono nina di ga viri mal ia tuna, upi koko ra popopoi na tapala kan ra kolot ure ra bongobongono. ");
INSERT INTO ksd_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Ma Aron na kap vaarike ra lavur iang i ra tarai Israel ta ra popopoi na varkurai ta ra bongobongono ba i ruk ta ra pakana i tabu, upi na tur na im pire ra Luluai vatikai. ");
INSERT INTO ksd_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ma una poe ta ra Urim ma Tumim ta ra popopoi na varkurai; diat a ki ta ra bongobongo i Aron ba i ruk tadav ra Luluai; ma Aron na kap vatikene pa ra varkurai kai ra tarai Israel taun ra bongobongono ta ra mata i ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Ma una pait ra olovoi ure ra kolot na bongobongono; una viri vapar ia ma ra kuara i von marut. ");
INSERT INTO ksd_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ma tika na ngovo na tur arama livuan tana ure ra ula; ma una viri lok ra ngovono, da ra ngovo na ongaongoi, upi koko na tarada. ");
INSERT INTO ksd_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Ma una pait ra umana pupulu da ra goava ta ra ngu na mal ra pia, una mal pa diat ma ra mal i blu marut, ma i meme marut, ma i meme tuna, diat a tur kikil ra ngu na mal parika; ma ra umana taratarenge ba di pait ia ma ra goled livuan ta diat, kikil ra ngu na mal. ");
INSERT INTO ksd_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","A taratarenge ma ra goava dir a varpopoto, a taratarenge ma ra goava kikil ra ngu na mal parika. ");
INSERT INTO ksd_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Ma Aron na mal me upi na kudakudar me ta ra lotu; ma diat a valongore ra varterengei ba i ruk ta ra pakana pal i tabu pire ra Luluai, ma ba i rop mulai, upi koko na mat. ");
INSERT INTO ksd_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Ma una mal pa ta ik a pal a kapa ma ra goled, ma una tutumu tana, da di tutumu ta ra vat ik di taun bat ra bulit me, ra tinata dari: Di tar ribe vaire pi kai ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ma una kubu tar ia ta ra vinau i blu marut, ma na tur ta ra mal na rarau, na tur ta ra papar uro na lua. ");
INSERT INTO ksd_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Ma na tur ta ra pal a matai i Aron, ma Aron na puak pa ra varpiam ta ra lavur gomgom na magit, nina ba ra tarai Israel dia tul tar ia tana ta kadia lavur vartabar na lotu; ma na tur vatikai ta ra pal a matana upi ra Luluai na manane diat. ");
INSERT INTO ksd_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Ma una viri ra lolovina kolot ma ra mal kumau, ma una pait ra mal na rarau, ma una pait ra vipit, a tena niingit guvai na mal tututumu na pait ia. ");
INSERT INTO ksd_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Ma una pait ra umana kolot kai ra umana natu i Aron, ma una pait ra umana vipit ure diat, ma una pait ra umana mal na rarau kadiat, ure ra minamar ma ure ra minong. ");
INSERT INTO ksd_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Ma una ule tar diat tai turam Aron ma tai ra umana natuna bula; ma una ku ra ulu i diat ma ra dangi, ma una vaninare diat ma una tibe vaire diat upi diat a kudakudar piragu ma ra papalum na tena tinabar. ");
INSERT INTO ksd_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Ma una pait kadia ta mal na tutana upi na tuba ra paka i diat, na tur pa ia ta ra livua i diat ma na tuk tar ta ra parkabin; ");
INSERT INTO ksd_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","ma Aron ma ra umana natuna diat a mal me, ba dia ruk ta ra pal na varbarat, ba ona dia vana tadav ra uguugu na vartabar, upi diat a kudakudar ta ra gomgom na pal, upi koko diat a pait ra magit i rara, ma diat a mat; ma go ra mangamangana na tur vatikai pirana ma pire ra lavur bul mur tana. ");
INSERT INTO ksd_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Ma go ia ra magit ba una pait ia ta diat, upi una mal vaire diat ure ra kunudar tagu ta ra papalum na tena tinabar; una pilak pa tika na bulumakau i gorop ma a ura sip, a ura tomotoina, ba pa ta magit i kaina tana, ");
INSERT INTO ksd_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ma ra gem ba pa i leven, ma ra gem ik ba pa i leven ma di pota ma ra dangi, ma ra gem maleplep ba pa i leven, di lolonge ra dangi tana; una pait go diat ma ra bo na plaua na Vit. ");
INSERT INTO ksd_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Ma una poe tar diat tai tika na rat, ma una kap diat ma ra rat, ma una ben ra bulumakau ma ra ura sip, a ura tomotoina, bula. ");
INSERT INTO ksd_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Ma una agure Aron ma ra umana natuna tadav ra matakilalat i ra pal na varbarat, ma una puk diat ma ra tava. ");
INSERT INTO ksd_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ma una tak pa ra umana mal, ma una ule tar ra lolovina kolot tai Aron, ma ra olovoi ure ra kolot na bongobongono, ma ra kolot na bongobongono, ma ra popopoi, ma una vi pit ia ma ra vivi di ga viri mal ia kai ra kolot ure ra bongobongono; ");
INSERT INTO ksd_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","ma una vung ra mal na rarau ta ra uluna, ma una vi tar ra vipuar i gomgom ta ra mal na rarau. ");
INSERT INTO ksd_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Namur una tak pa ra dangi na varku, ma una lolonge tar ia ta ra uluna, ma una ku ia. ");
INSERT INTO ksd_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Ma una agure ra umana natuna, ma una ule tar ra umana kolot ta diat. ");
INSERT INTO ksd_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Ma una vi pit diat ma ra umana vipit, Aron ma ra umana natuna, ma una vung ra umana kere ta ra ulu i diat; ma diat a vatur vake ra tiniba na tena tinabar vatikai, ma una mal tar diat, Aron ma ra umana natuna. ");
INSERT INTO ksd_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Ma una ben ra bulumakau ta ra luaina mata i ra pal na varbarat; ma Aron ma ra umana natuna diat a vung ra lima i diat ta ra ulu i ra bulumakau. ");
INSERT INTO ksd_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ma una doko ra bulumakau ta ra luaina mata i ra Luluai pire ra matakilalat i ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ma una tak pa ra gapu i ra bulumakau, ma una kolo ra ram u ra uguugu na vartabar me ma ra kaka na limam; ma una lolonge tar ra gap ta ra bit a uguugu na vartabar. ");
INSERT INTO ksd_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ma una tak pa ra bira na bala par ma ra mal i ra kat, ma ra ura ela ma ra bira tana, ma una tun ia ta ra uguugu na vartabar. ");
INSERT INTO ksd_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ma ra vio i ra bulumakau ma ra palina ma ra lavur puta tana, una tun vue ta ra iap ta ra papar a gunan irai, tago a varporong ure ra varpiam. ");
INSERT INTO ksd_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Ma una tak pa tika na sip bula, a tomotoina; ma Aron ma ra umana natuna diat a palagur ra uluna ma ra lima i diat. ");
INSERT INTO ksd_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Ma una doko ra sip, a tomotoina, ma una tak pa ra gapuna, ma una vue tar ia kikil ra uguugu na vartabar par. ");
INSERT INTO ksd_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ma una poko kaba ra umana pakapakana, ma una puk ra balana ma ra kakene, ma una vung guve ma ra lavur pakana ma ra uluna. ");
INSERT INTO ksd_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ma una tun ra sip parika ta ra ul a uguugu na vartabar; ia ra tinabar di tuntun tar ia tai ra Luluai; i ang na katkat, a tinabar ba di tun tar ia ta ra iap tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Ma una tak pa ta ra sip, a tomotoina; ma Aron ma ra umana natuna diat a palagur ra ulu i ra sip. ");
INSERT INTO ksd_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ma una doka, ma una tak pa ra gapuna ma una kolo ra tabataba na mar talinga ta ra talinga i Aron me ta ra papar a lima tuna, ma ra tabataba na mar talinga ta ra talinga i ra umana natuna ta ra papar a lima tuna, ma ra kaka ngala ta ra lima i diat tuna, ma ta ra kaka ngala ta ra kak i diat tuna, ma una vue tar ra gap kikil ra uguugu na vartabar. ");
INSERT INTO ksd_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ma una tak pa ta ik ta ra gap ta ra uguugu na vartabar, ma ta ra dangi na varku, ma una pikire tar ia tai Aron, ma kana lavur mal, ma ta ra umana natuna ma kadia lavur mal varurung me, ma ia iat na gomgom, ma kana lavur mal, ma damana ra umana natuna ma ra lavur mal kai ra umana natuna varurung me. ");
INSERT INTO ksd_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Ma una tak pa ra bira i ra sip, a tomotoina, bula, ma ra taukuna i bira ma ra bira na bala, ma ra mal i ra kat ma ra ura ela ma ra bira tana, ma ra kelakelegi ta ra papar a lima tuna; tago ia ra sip ure ra vaninara; ");
INSERT INTO ksd_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","ma tika na pakana gem, ma tika na gem ik di pait ia ma ra dangi, ma tika na gem ik i maleplep kan ra rat na gem ba pa i leven, nina i tur ta ra mata i ra Luluai; ");
INSERT INTO ksd_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ma una vung vapar ia ta ra lima i Aron ma ra lima i ra umana natuna; ma una tulue vaarike diat ma ra limam da ra tinabar na tutuluai ta ra mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ma una tak pa diat kan ra lima i diat, ma una tun diat ta ra uguugu na vartabar taun ra tinabar di tuntun tar ia upi ra magit i ang na katkat ta ra mata i ra Luluai; a tinabar nam ba di tun tar ia ta ra iap upi kai ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Ma una tak pa ra bongobongo i ra sip na vaninara, ma una tulue vaarike da ra tinabar na tutuluai ta ra mata i ra Luluai; kaum tiniba nam. ");
INSERT INTO ksd_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Ma una mal vaire ra bongobongo i ra tinabar na tutuluai ma ra kelakelegi na vartabar, nina dia tulue vaarike ma nina dia vatur vake ta ra sip na vaninara, ta nina ba kai Aron ma ra umana natuna; ");
INSERT INTO ksd_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ma Aron ma ra umana natuna diat a vatur vake vatikai da ra totokom ta ra tarai Israel, tago a tinabar na totokom; ma na da ra tinabar na totokom ta ra tarai Israel, da tak pa ia ta kadia tinabar na varporong upi ra tinabar na totokom kai ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Ma ra lavur gomgom na mal kai Aron kadiat boko ra umana bul mur tana, upi da ku diat i tana ma da vaninare diat i tana. ");
INSERT INTO ksd_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Nina ra natuna ba na kia vue ta ra papalum na tena tinabar na ule tar diat lavurua na bung ba i olo ta ra pal na varbarat upi na kudakudar ta ra pakana pal i tabu. ");
INSERT INTO ksd_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Ma una tak pa ra sip ure ra vaninara ma una kabalane ra viono ta ra pakana i gomgom. ");
INSERT INTO ksd_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Ma Aron diat ma ra umana natuna diat a en ra vio i ra sip ma ra gem ta ra rat pire ra matakilalat i ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ma diat a en nam ra lavur magit ba di ga pait ra varmaram guvai me, upi da vaninare diat, ma da mal tar diat; koko ta vaira na ian tana, tago a gomgom na magit. ");
INSERT INTO ksd_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ma ona ta pakana viono ure ra vaninara, ba ta ra gem i tur valili upi ra malana, una tun vue nina i tur valili ta ra iap, tago a gomgom na magit. ");
INSERT INTO ksd_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Damana una pait ia pire Aron ma ra umana natuna varogop ma ra lavur magit par iau ga vartuluai me piram; lavurua na bung una varvakai ma ra vaninare diat. ");
INSERT INTO ksd_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ma ta ra bungbung par una tul tar ra bulumakau na tinabar ure ra varpiam upi ra varmaram guvai; ma ona u pait ra tinabar na varporong a uguugu na vartabar na langalanga kan ra varpiam, ma una vadangi ia, upi una mal tar ia. ");
INSERT INTO ksd_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Lavurua na bung una pait ra varporong ure ra uguugu na vartabar, ma una mal tar ia; ma ra uguugu na vartabar na gomgom kakit; ma nina i bili ia na gomgom bula. ");
INSERT INTO ksd_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Ma go ra lavur magit una tul tar ia ta ra ul a uguugu na vartabar: a ura nat na sip ba i kopono ko kadir kilala una tul tar dir vatikai ta ra bungbung par. ");
INSERT INTO ksd_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Tika na nat na sip una tul tar ia ta ra malana, ma ta ra tika na nat na sip ta ra ravian; ");
INSERT INTO ksd_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","varurung ma tika na nat na sip una tul tar ra vavinun na pakana epa na bo na plaua, ma da pota ma ra vaivatina pakana valavalar na bo na dangi tuna, ma ra vaivatina pakana valavalar na vain ure ra tinabar na nimomo. ");
INSERT INTO ksd_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ma ta ra nat na sip una tul tar ia ta ra ravian, ma una pait ra lavur magit tana da ta ra malana, a tinabar na nian ma ra tinabar na nimomo, upi ra magit i ang na katkat, a tinabar di tuntun tar ia tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Go ra tinabar di tun tar ia na tur vatikai pire kavava lavur taun tarai namur, diat a pait ia ta ra matakilalat i ra pal na varbarat ta ra luaina mata i ra Luluai; dor a varkuvo ma u abara upi ina tata piram. ");
INSERT INTO ksd_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ma avet a varkuvo ma ra tarai Israel ie; ma ra pal na mal i gomgom ure kaugu minamar. ");
INSERT INTO ksd_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ma ina vagomgom ra pal na varbarat ma ra uguugu na vartabar; Aron bula ma ra umana natuna ina vagomgom diat upi diat a kudakudar tagu ta ra papalum na tena tinabar. ");
INSERT INTO ksd_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ma ina ki livuan pire ra tarai Israel ma iau kadia God. ");
INSERT INTO ksd_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ma diat a nunure ba iau ra Luluai kadia God, nina iau ga agure vairop diat kan ra gunan Aigipto, upi ina ki livuan ta diat; iau ra Luluai kadia God. ");
INSERT INTO ksd_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Ma una pait ra uguugu na vartabar upi una tun tar ra magit ure ra mi na lotu tana; una pait ia ma ra davai akasia. ");
INSERT INTO ksd_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Kana lolovina tika na malmalikun ma ra tababana bula tika na malmalikun, ra ivat na paparaina diat a varogop par; ma ra tuluaina na varogop ma ra papar; a uguugu na vartabar ma ra ramuna a kidoloina davai. ");
INSERT INTO ksd_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ma una vung vapetep tar ra goled tuna tana; ta ra ul a uguugu na vartabar ma ra umana paparaina par ma ra umana ramuna; ma una mar kikil ia ma ra goled tuna. ");
INSERT INTO ksd_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ma una mal tar ra ivu ngovo na goled ta ra ura nguna, ta ra ura paparaina, ta ra vavai ra mamar kikil, upi da ule tar ta kip tana ba da kip ia me. ");
INSERT INTO ksd_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ma una mal ra kip, a davai akasia, ma una vung vapetep tar ra goled tana. ");
INSERT INTO ksd_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ma una vatur ia ta ra luaina mata i ra mal na rurua kutu pire ra bok na tinata, ta ra luaina mata i ra tubatuba, nina i ki ta ra ul a tinata, abara ba dor a varkuvo ie. ");
INSERT INTO ksd_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Ma Aron na tun tar ra magit i ang na katkat tana, ta ra malana ta ra bungbung par; ba i mal ra lamp na tun tar ia. ");
INSERT INTO ksd_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Ma ba Aron na valiting ra lamp ta ra ravian, na tun tar ia, a tinabar na mi ta ra luaina mata i ra Luluai; damana vatikai ta kavava lavur taun tarai namur. ");
INSERT INTO ksd_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Koko avat a tul tar ta enana tinabar na mi, ba ta enana tinabar di tuntun tar ia, ba ta enana tinabar na nian; ma koko ava lolonge tar ta tinabar na nimomo tana. ");
INSERT INTO ksd_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Ma Aron na vakopono pait ra varporong ta ra kilala; ta ra kilakilala na vakopono pait ra varporong ure ta ra ramuna ma ra gapu i ra tinabar ure ra varpiam; ma na damana pire kavava lavur taun tarai namur; i gomgom kakit ure ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Ma ra Luluai i ga tata tai Moses dari: ");
INSERT INTO ksd_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Ba u luk guve ra tarai Israel ba aivia diat, tikatika na tutana na varkul pire ra Luluai ure kana nilaun ba u luk diat, upi koko ra kaina minait na monong diat, ba u luk diat. ");
INSERT INTO ksd_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Tikatikai ta diat dia bolo pire diat di luk diat, na vartabar ma ra ngungu mamat na silva, varogop ma ra mamat kai ra gomgom na pal; a mamat i varogop ma ra vinun ma laptikai na gram (a ngungu auns); a ngungu mamat na silva ia ra tinabar upi kai ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Diat par dia bolo pire diat di luk diat, ma i ura vinun kadia kilala, ba i bolo ra ura vinun, diat a tabar ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Koko ra uviana na vangala pa ra vartabar, ma koko ra luveana na vaikilik pa ia, ia kaka a ngungu mamat na silva diat a vartabar me pire ra Luluai upi ra varporong ure kadia nilaun. ");
INSERT INTO ksd_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ma una alube pa ra mani na varporong, ma una tibe tar ia ure ra papalum ta ra pal na varbarat, upi na tur na im ta ra luaina mata i Luluai, a varporong ure kavava nilaun. ");
INSERT INTO ksd_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Ma ra Luluai i ga biti tai Moses dari: ");
INSERT INTO ksd_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Una pait tika na la ma ra palariam gobol ure ra vargi, ma a bitina na palariam gobol bula; ma una vatur ia ta ra bala na gunan, livuan ta ra pal na varbarat ma ra uguugu na vartabar, ma una lingire ra tava tana. ");
INSERT INTO ksd_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Ma Aron ma ra umana natuna diat a puk ra lima i diat ma ra kak i diat tana; ");
INSERT INTO ksd_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ba dia ruk ra pal na varbarat diat a iu pi koko diat a virua; ba ona diat a maravai ta ra uguugu na vartabar, upi diat a kudakudar ma diat a tuntun tar ra tinabar ta ra iap tadav ra Luluai, ");
INSERT INTO ksd_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","diat a gi ra lima i diat ma diat a puk ra kau i diat upi koko diat a virua; ma go ra mangamangana na tur vatikai pire diat, pirana ma pire ra lavur bul mur tana ta kadia lavur taun tarai. ");
INSERT INTO ksd_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Ma ra Luluai i ga biti mulai tai Moses dari: ");
INSERT INTO ksd_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Una tak pa bula ra lavur magit i ang na katkat ma i vakak kakit, a ilima na mar na mamat na bulit na davai, ma a ura mar ma a ilima na vinun na mamat na sinamon i ang na vuvuvul, ma a ura mar ma a ilima na vinun na mamat na vuvur i ang na vuvuvul, ");
INSERT INTO ksd_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ma a ilima na mar na mamat na kasia, varogop ma ra mamat kai ra gomgom na pal, ma tika na valavalar na dangi na oliva; ");
INSERT INTO ksd_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","ma una pait ra dangi na varku i gomgom me, a dangi ba na ang na vuvuvul, varogop diat dia melem tana dia pait ia; a dangi na varku i gomgom tuna. ");
INSERT INTO ksd_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Ma una kolo ra pal na varbarat me, ");
INSERT INTO ksd_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ma ra bok na tinata, ma ra vuvuvung na nian ma kana lavur tabarikik, ma ra turtur na kapa ma ra lavur tabarikik ure, ra uguugu ure ra mi na lotu, ");
INSERT INTO ksd_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ma ra uguugu na vartabar ure ra tinabar di tun tar ia, ma ra la na vargi ma kana kiki. ");
INSERT INTO ksd_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ma una vagomgom diat, upi diat a gomgom kakit; ma nina i bili diat na gomgom bula. ");
INSERT INTO ksd_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Ma una ku Aron ma ra umana natuna, ma una vagomgom diat, upi diat a kudakudar piragu ta ra papalum na tena tinabar. ");
INSERT INTO ksd_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ma una biti tai ra tarai Israel dari: Go ia ra dangi na varku piragu ta kavava lavur taun tarai. ");
INSERT INTO ksd_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Koko avat a lolonge tar ia ta ra paka i ra tarai, ma koko avat a pait ta dangi damana mulai varogop ma ra lavur magit tana; i gomgom, ma na tabu pire vavat. ");
INSERT INTO ksd_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Nina i papait ra dangi dari, ba nina i tap tika na vaira ma ta na, na virua kan ra taraina. ");
INSERT INTO ksd_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Ma ra Luluai i ga biti tai Moses dari: Una tak pa ra umana magit i ang na katkat, a dangi na davai, ma a onika, ma a bulit na davai; a umana magit i ang na katkat, ma a bulit na davai i barabara; a valavalar ure tikatika na mangana na varogop uka; ");
INSERT INTO ksd_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","ma una pait ra magit ure ra mi na lotu me, a magit i ang na katkat, varogop diat dia melem tana dia pait ia, una pota ma ra solt, a dovot na magit ma na gomgom. ");
INSERT INTO ksd_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ma una rigi ta ik tana upi na da ra tobon, ma una vung ia ta ra luaina mata i ra Tinata ta ra pal na varbarat, nam ba dor a varkuvo ie; ma na gomgom tuna piram. ");
INSERT INTO ksd_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Ma ra magit ure ra mi na lotu ba una pait ia, varogop ma ra varkurai tana, koko avat a pait ia ure avat; i tabu pire vavat; kai ra Luluai ka. ");
INSERT INTO ksd_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Diat par dia pait ra damana upi diat a lulung tana, diat a virua kan kadia tarai. ");
INSERT INTO ksd_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Ma ra Luluai i ga biti tai Moses dari: ");
INSERT INTO ksd_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Gire, iau tar pilak pa Besalel iat, natu i Uri, natu i Kur, ta ra vuna tarai Iuda; ");
INSERT INTO ksd_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ma iau tar vabuka ia ma ra Tulungea i God upi na kabinana, ma na matoto, ma na melem, ma na madaka ta ra lavur mangamangana papalum, ");
INSERT INTO ksd_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Upi na nuk tadav ra umana enana papalum, ma na pait ot pa diat ma ra goled, ma ra silva, ma ra palariam gobol; ");
INSERT INTO ksd_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","na poko mal ra lavur vat na marmar, ma na mut mal ra davai, ma na pait ra lavur mangamangana papalum par. ");
INSERT INTO ksd_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ma gire, iau tar tibe dir varurung ma Oliab, natu, i Akisamak, ta ra vuna tarai Dan; ma iau tar vaki ra kabinana ta ra bala i diat par dia matoto upi diat a pait valar pa ra lavur magit iau ga vartuluai ure piram: ");
INSERT INTO ksd_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","a pal na varbarat, ma ra bok na tinata, ma ra tubatuba i ki taun ia; ma ra lavur tabarikik ure ra pal na mal; ");
INSERT INTO ksd_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ma ra vuvuvung na nian ma kana lavur tabarikik, ma ra uguugu na vartabar ure ra mi na lotu; ");
INSERT INTO ksd_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ma ra uguugu ure ra tinabar di tun tar ia ma kana lavur tabarikik, ma ra la na vargi ma kana kiki; ");
INSERT INTO ksd_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ma ra lavur mal na kunudar ma ra lavur gomgom na mal ure Aron ra tena tinabar, ma ra lavur mal ure ra umana natuna, upi diat a kudakudar ma ra papalum kai ra tena tinabar; ");
INSERT INTO ksd_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ma ra dangi na varku, ma ra lavur magit i ang na katkat ure ra pakana pal i tabu; da kaugu vartuluai piram ure ra lavur magit, damana diat a pait ia. ");
INSERT INTO ksd_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Ma ra Luluai i ga biti tai Moses dari: Go bula una ve ra tarai Israel ma una biti dari: ");
INSERT INTO ksd_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Avat a nuk pa tuna kaugu lavur Bung Sabat, tago nam ia ra vakilang pire dat ma kaum lavur taun tarai namur; upi ra tarai diat a nunure ba iau ra Luluai nina ba iau mal vaire avat. ");
INSERT INTO ksd_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Kari avat a ru ra Bung Sabat, tago i gomgom pire vavat; diat par dia vakaina, i dovot da ubu doko diat; tago ba tikai i papalum taun ia, nam ra tutana na panie kan ra taraina. ");
INSERT INTO ksd_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Laptikai na bung avat a papalum tana; ma ra valavuruana bung, a Bung Sabat ure ra bo na ningo, kai ra Luluai iat; nina ba na pait ta mangana papalum ta ra Bung Sabat, i dovot nam na virua. ");
INSERT INTO ksd_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Kari ra tarai Israel diat a nuk pa ra Bung Sabat, upi diat a ru ia ta kadia lavur taun tarai, a kunubu pa na mutu. ");
INSERT INTO ksd_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ia ra vakilang pa na mutu piragu ma pire ra tarai Israel; tago laptikai na bung ra Luluai i ga vaki ra bala na bakut ma ra rakarakan a gunagunan tana, ma ta ra valavuruana bung i ga ngo, ma i ga lagar mulai. ");
INSERT INTO ksd_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ma ba i ga par kadir pirpir ma Moses ta ra ul a luana Sinai, i ga tul tar ra ura pal a vat tana ma ra tinata tana, a ura pal a vat, ma ra kaka na lima i God i ga tutumu tana. ");
INSERT INTO ksd_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ma ba ra tarai dia ga gire ba Moses i ga vavuan ma ra vinavana ur marama ra luana, dia ga vana rangup tadav Aron, ma dia ga biti tana: Ioi, una mal tar ta god ta vevet, upi na lua ta vevet; tago pa ave nunure ba ava vang i tadav Moses, nina ra tutana i ga agure vairop avet kan ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ma Aron i ga biti ta diat: Avat a kutu vue ra lavur marmar talinga na goled ta ra talinga i kavava umana taulai, ma ra talinga i ra lavur natu i vavat, a umana tutana ma ra umana vavina, ma avat a kap diat piragu. ");
INSERT INTO ksd_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ma ra tarai par dia ga kutu vue ra marmar ta ra talinga i diat, ma dai ga vung kapi diat pire Aron. ");
INSERT INTO ksd_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ma i ga vatur vake ta ra lima i diat, ma i ga taba ma ra banam, ma i ga pait ra nat na bulumakau me; ma dia ga biti: U Israel, go kaum God, nina i ga agure vairop u kan ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ma ba Aron i ga gire go, i ga pait tika na uguugu na vartabar ta ra luaina matana; ma Aron i ga tulue ra tinata vurvurbit dari: Ningene da pait tika na lukara kai ra Luluai! ");
INSERT INTO ksd_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ma dia ga tut ta ra malana ikilik, ma dia ga tul tar ra tinabar di ga tun ia, ma dia ga kap ra tinabar na varporong; ma ra tarai dia ga ki ra pia upi diat a ian ma diat a momo, ma dia ga tut mulai upi diat a libur. ");
INSERT INTO ksd_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ma ra Luluai i ga biti tai Moses dari: Una vana, una irop; tago kaum tarai, nina u ga agure vairop diat kan ra gunan Aigipto, dia tar tibuna vakaina diat mulai; ");
INSERT INTO ksd_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","dia tar lulut ma ra vinavana kan nam ra nga iau ga tulue diat i tana; dia tar pait kadia tika na nat na bulumakau ma dia tar lotu tadav ia, ma dia tar pait ra tinabar tadav ia, ma dia biti: U Israel, go kaum God, nina i ga agure vairop u kan ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ma ra Luluai i ga biti tai Moses dari: Iau tar gire go ra tarai, ma gire, a umana karduk diat: ");
INSERT INTO ksd_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Io, una nur vue iau, upi ra karangap i kaugu karvuvu na vana rikai tadav diat, ma ina li vue diat; ma ina vaki ra ngala na tarai tam. ");
INSERT INTO ksd_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ma Moses i ga lul ra Luluai kana God ma i ga biti: Luluai, ta ra ava u manga kulot ure kaum tarai, nina u ga agure vairop diat kan ra gunan Aigipto ma ra ngala na niongor ma ra dekdek na limam? ");
INSERT INTO ksd_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ta ra ava ra tarai Aigipto diat a biti boko dari: I ga agure vairop diat upi ra vinirua, upi na ubu doko diat ara ra pupui ma upi na kamare vue diat kan ra mata i ra rakarakan a gunagunan? Una ngo kan kaum ngala na kankan ma una nukpuku kan go ra kaina magit ba una pait ia ta kaum tarai. ");
INSERT INTO ksd_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Una nuk pa Abaraam, Isak ma Israel, kaum a utul a tultul, nina dital u ga vavalima pire dital ma ra iangim iat, ma u ga biti ta dital: Ina vapeal ra umana bul mur ta mumutal, diat a do da ra lavur tagul arama liu ra maup, ma go ra gunan par, ba iau ga varvai ure, ina tul tar ia ta ra lavur bul mur ta mumutal, ma diat a kale pa ia vatikai. ");
INSERT INTO ksd_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ma ra Luluai i ga pukue ra nuknukina ure ra lavur kaina magit, nina i ga biti ba na pait ia ta ra taraina. ");
INSERT INTO ksd_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ma Moses i ga lilikun, ma i ga irop ta ra luana, ma i ga kap ra ura pal a vat na tinata ta ra limana; ma a tutumu i tur ta ra ura paparai dir; tika na papar a tutumu tana ma tai ta ra tikai bula. ");
INSERT INTO ksd_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ma ra ivu pal a vat God iat i ga pait dir, ma ra tutumu tana a tutumu kai God, i ga ka tar ia ta ra pal a vat. ");
INSERT INTO ksd_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ma ba Iosua i ga valongore ra ururung kai ra tarai ba dia ga ngenge, i ga biti tai Moses: A ururung na vinarubu ta ra gunan kai ra tarai. ");
INSERT INTO ksd_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ma i ga biti: Vakir a nilai diat ba dia kukula tago dia ga uvuvia, ma vakir a nilai diat dia tangi tago dia virua; iau valongore ke ra nilai diat ba dia kakakailai. ");
INSERT INTO ksd_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ma ba dia ga maravai ta ra gunan kai ra tarai, i ga gire ra nat na bulumakau ma ra malagene; ma Moses i ga manga kankan, ma i ga vue pamar gigi ra ura pal a vat ta ra bit a luana. ");
INSERT INTO ksd_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ma i ga tak pa ra nat na bulumakau, nina dia ga pait ia, ma i ga tun ia ta ra iap, ma i ga gigi ia upi na tobon. ma i ga vue imire tar ia ta ra tava, ma i ga vamomo ra tarai Israel me. ");
INSERT INTO ksd_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ma Moses i ga biti tai Aron: Ava vang go ra tarai dia ga pait ia tam upi una rap diat ta ra ngala na varpiam damana? ");
INSERT INTO ksd_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ma Aron i ga biti: Koko ra kulot kai kaugu lualua na manga ngala; u nunure ra tarai dia nuknuk upi ra varpiam. ");
INSERT INTO ksd_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Tago dia ga biti tagu dari: Una pait kaveve ta god upi na rap lue avet; tago Moses, nina ra tutana i ga agure vairop avet kan ra gunan Aigipto, pa ave nunure ba i dave. ");
INSERT INTO ksd_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ma iau ga biti ta diat: Diat par dia vung ra goled boina diat a kutu vue; io, dia ga tul tar ia tagu; ma iau ga vue tar ia ta ra iap, ma go ra nat na bulumakau i vana rikai tana. ");
INSERT INTO ksd_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Ma ba Moses i ga gire ba ra tarai dia papait na kuabar, tago Aron i ga pala vue diat, ma kadia lavur ebar dia ga varmaianao ure diat, ");
INSERT INTO ksd_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","io, Moses i ga tur ta ra mataniolo i ra gunan kai ra tarai, ma i ga biti: To ia i tur maravut ra Luluai? Uti piragu nam! Ma ra lavur tarai Levi par dia ga vana varurung pirana. ");
INSERT INTO ksd_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ma i ga biti ta diat: A Luluai, ra God kai Israel, i biti dari, Avat par avat a vi pit, tikatikai ma kana pakat na vinarubu, ma avat a vana ta ra lavur mataniolo ta ra gunan kai ra tarai par, ma tikatikai na ubu turana, ma tikatikai na ubu talaina ma nina dir ki varurung me. ");
INSERT INTO ksd_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Ma ra tarai Levi dia ga torom ta ra tinata kai Moses; ma a utul a arip na marmar na tarai dia ga virua ta nam ra bung. ");
INSERT INTO ksd_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ma Moses i ga biti: Avat a vaninare tar avat tai ra Luluai gori, tago avat par ava ga tut na vinarubu tikatikai ure natuna ma ure turana; upi na tul tar ra varvadoan ta vavat go ieri. ");
INSERT INTO ksd_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ma ta ra kubak tana, Moses i ga biti tai ra tarai: Ava ga pait ra varpiam tuna, ma go ina tutua urama pire ra Luluai, kan ina pait valar pa ra varporong ure kavava varpiam. ");
INSERT INTO ksd_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ma Moses i ga lilikun tadav ra Luluai, ma i ga biti: Go ra tarai dia tar pait ra varpiam tuna ma dia pait kadia tika na god ma ra goled. ");
INSERT INTO ksd_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ma go i boina una nur vue kadia varpiam; ma ari ona pata, una pun vue ra iangigu ta kaum buk, nina u ga tumu ia. ");
INSERT INTO ksd_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ma ra Luluai i ga biti tai Moses: Diat par dia ga pait ra varpiam tagu, ina pun vue diat ta kaugu buk. ");
INSERT INTO ksd_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ma go una vana, ma una agure ra tarai tadav nam ra gunan ina ga ve u tana; gire kaugu angelo na lua tam, ia kaka ta ra bung na balbali ina bali kadia mangamangana pire diat. ");
INSERT INTO ksd_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ma ra Luluai i ga vakadik ra tarai ure ra nat na bulumakau, nina diat ma Aron dia ga pait ia. ");
INSERT INTO ksd_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Ma ra Luluai i ga biti tai Moses: Una vana, una vana oai, avat ma ra tarai nina u. ga agure vairop diat kan ra gunan Aigipto, avat a tadav nam ra gunan iau ga vavalima ure pire Abaraam ma Isak ma Iakob, ma iau ga biti dari: Ina tul tar ia ta ra lavur bul mur tam; ");
INSERT INTO ksd_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","ma ina tul vue tika na angelo pi na lua tam, ma ina korot vue ra tarai Kanaan, ma ra tarai Amor, ma ra tarai Ket, ma ra tarai Peres, ma ra tarai Kivi ma ra tarai Iebus; ");
INSERT INTO ksd_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","tadav ra gunan a polo na u ma ra polo na livur i kalakalami i alalir tana; tago iau, pa dat a varagur uro, tago avat a umana pue ngangar, kan ina kamare vue avat na nga. ");
INSERT INTO ksd_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ma ba ra tarai dia ga valongore go ra dekdek na tinata, dia ga korkor ma pa ta tikai i ga mong ma ra magit na marmar. ");
INSERT INTO ksd_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Ma ra Luluai i ga biti tai Moses: Una ve ra tarai Israel dari: Avat a umana pue ngangar, ona dat a varagur ma avat a ik ika, ina kamare vue avat, kari una vung vue ra lavur marmar kan u, upi ina nunure ba ava vang ina pait ia piram. ");
INSERT INTO ksd_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ma ra tarai Israel dia ga tak vue ra lavur marmar kan ra paka i diat ta ra bung dia ki ra luana Koreb, ma namur bula. ");
INSERT INTO ksd_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Ma Moses i ga vala tak pa ra pal na mal, ma i ga vatvatur ia irai kan ra gunan kai ra tarai, ma i ga vatang ia ba a pal na varbarat. Ma diat par dia ga tikan upi ra Luluai dia ga tadav ra pal na varbarat, nina i ga tur ta ra papar irai kan ra gunan kai ra tarai. ");
INSERT INTO ksd_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ma ba Moses i ga irop upi na vana tadav ra pal na mal, a tarai par dia ga tut, ma dia ga tur tikatikai ta ra matakilalat i kana pal na mal, ma dia ga gire mur ia tuk tar ta kana niruk ta ra pal na mal. ");
INSERT INTO ksd_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ma ba Moses i ga ruk ta ra pal na mal, ra ngala na bakut i ga kuba ma i ga tur ta ra matakilalatina; ma ra Luluai dir ga tata ma Moses. ");
INSERT INTO ksd_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Ma ra tarai par dia ga gire ra ngala na bakut i ga turtur ta ra matakilalat i ra pal na mal, ma ra tarai par dia ga tut, ma dia ga lotu, tikatikai ta ra matakilalat i kana pal na mal. ");
INSERT INTO ksd_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ma ra Luluai dir ga pirpir ma Moses, da tika na tutana dir pirpir ma talaina. Ma i ga lilikun mulai upi ra gunan kai ra tarai; ma kana tultul Iosua, natu i Nun, a barmana, pa i ga vana kan ra pal na mal. ");
INSERT INTO ksd_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Ma Moses i ga biti tai ra Luluai dari: Gire, u biti tagu dari, Una agure go ra tarai urama, ma pa u vaarike boko tagu nina ba amir a varagur me. Ma a dovotina u ga biti, Iau nunure ra iangim, ma iau tar mari u. ");
INSERT INTO ksd_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Kari iau lul u, ba u tar mari iau, una vateten tar kaum lavur mangamangana tagu, upi ina nunure u, ma ba u tar mari iau, ma una nuk pa ia ba go ra tarai kaum vuna tarai iat. ");
INSERT INTO ksd_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ma i ga biti tana: Dor a varagur ma u, ma ina vango u. ");
INSERT INTO ksd_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Ma i ga biti tana: Ona pa dor a varagur ma u, koko una agur pa avet urama. ");
INSERT INTO ksd_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Tago ava ra vakilang da nunure tana ba u tar mari avet ma kaum tarai? Vakir nam uka ba dat a varagur ma u, upi avet a enana, avet ma kaum tarai, ta ra lavur tarai ta ra rakarakan a gunagunan? ");
INSERT INTO ksd_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ma ra Luluai i ga biti tai Moses: Go ra magit u tar tatike, ina pait ia bula, tago iau tar mari u, ma iau tar nunure ra iangim. ");
INSERT INTO ksd_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Ma i ga biti tana: Iau lul u, boina una vaarike kaum minamar tagu. ");
INSERT INTO ksd_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ma i ga biti: Kaugu lavur minamar par na bolo ta ra luaina matam, ma ina vatavatang ra iang i ra Luluai na lua tam; ma iau mari nina ba iau mainge upi ina mari ia, ma iau maravut nina ba iau mainge upi ina maravut ia. ");
INSERT INTO ksd_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ma i ga biti: I dekdek upi una gire ra matagu, tago ona ba ta tutana i gire iau, pa na laun mulai. ");
INSERT INTO ksd_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ma ra Luluai i ga biti: Gire, ta pakana gunan go kari piragu, ma una tur ta ra ul a vat ki; ");
INSERT INTO ksd_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ma ba kaugu minamar i bolo, ina vatur u ta ra niiga ta ra vat ki, ma ina tuba u ma ra limagu tuk tar ta nam ba iau tar vana pakit; ");
INSERT INTO ksd_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ma ina tak vue ra limagu, ma una gire ra tamurugu; ma i dekdek muka upi una gire ra matagu. ");
INSERT INTO ksd_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ma ra Luluai i ga biti tai Moses: Una mut kaum ta ura pal a vat varogop ma ra luaina, ma ina tutumu ta ra ura pal a vat ra lavur tinata dia ga tur ta ra ura luaina, nina u ga pamar gigi dir. ");
INSERT INTO ksd_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ma una ki na vaninara ta ra malana, ma una tutua urama ta ra luana Sinai, ma una tur rikai piragu ta ra ul a luana. ");
INSERT INTO ksd_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ma koko amur a varagur ma ta tikai, ma koko da gire ta tikai ta ra luana parika; ma koko ra kikil na sip ba ra kikil na bulumakau na iaian maravai ta ra luana. ");
INSERT INTO ksd_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ma i ga mut ra ura pal a vat varogop ma ra ura luaina. Ma Moses i ga tut ta ra kavunvun, ma i ga vana tutua ta ra luana Sinai, da ra Luluai i ga vartuluai pirana, ma i ga vatur ra ura pal a vat ta ra limana. ");
INSERT INTO ksd_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ma ra Luluai i ga kuba ta ra bakut, ma Moses i ga tur pirana, ma i ga vatang upi ra iang i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ma ra Luluai i ga vana pakit ta ra luaina matana, ma i ga oraoro dari: A Luluai, a Luluai, a God i buka ma ra varmari ma i madu ra maukuana, i vavabing ma ra kankan, ma i kor ma ra varmari ma ra dovot; ");
INSERT INTO ksd_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","i pait ra varmari tadav ra umana arip na marmar, ma i pun vue ra nirara ma ra varpiam ma ra kaina mangamangana; ma pa na valangalanga ra tena varpiam; na bali ka ra nirara kai ra tarai pire ra umana natu i diat ma pire ra umana bul mur ta diat tuk tar ta ra vautuluna ma ra vaivatina taun tarai. ");
INSERT INTO ksd_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Ma Moses i ga lulut, ma i ga ruru ma ra uluna ura ra pia, ma i ga lotu. ");
INSERT INTO ksd_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ma i ga biti: Lu luai, ona u tar mari iau go, boina ba dat a varagur ma ra Luluai ta ra vinavana, tago go ra tarai a umana karduk diat, ma una pun vue kaveve nirara ma kaveve varpiam, ma una kale avet upi avet kaum tarai. ");
INSERT INTO ksd_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ma i ga biti: Gire, ina pait tika na kunubu, ina pait ra umana magit na kinaian ta ra luaina mata i kaum tarai par, ma pa di ga pait boko ra umana dari ta ra rakarakan a gunagunan, ba pire ta vuna tarai; ma ra tarai par ba u ki pire diat, diat a gire ra papalum kai ra Luluai; tago ina pait ta enana magit piram. ");
INSERT INTO ksd_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Una nuk pa nam ba ina tul.tar ia tam ieri: Gire, ina korot vairop vue ra tarai Amor, ma ra tarai Kanaan, ma ra tarai Ket, ma ra tarai Kivi ma ra tarai Iebus ta ra luaina matam. ");
INSERT INTO ksd_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Una balaure u, kan una pait ta kunubu ma ra tarai ta nam ra gunan ba u vana tana, kan na varogop ma ra kun livuan tam; ");
INSERT INTO ksd_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","avat a kal kopo kadia lavur uguugu na vartabar ma avat a pamar gigi kadia lavur vat dia ga vatur ia, ma avat a mut vue kadia lavur tabataba i Asera. ");
INSERT INTO ksd_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Tago koko una lotu tadav tika na enana god, tago ra Luluai nina ba ra iangina a Tena Ongor, ia ra ongor na God; ");
INSERT INTO ksd_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","kan una pait ta kunubu ma ra tarai dia ki ta nam ra gunan; ma ba dia mur kadia lavur god ma dia pait ra tinabar tadav kadia lavur god, kan ta tikai na ting pa u ma una ian maravut ta kana tinabar; ");
INSERT INTO ksd_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","ma kan una kul kadia umana bul vavina upi kaum umana barmana diat a taule diat, ma kadia vaden diat a mur kadia lavur god ma diat a ting valar pa ra umana natum, a umana tutana, upi diat a mur kadia lavur god. ");
INSERT INTO ksd_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Koko una pait kaum ta tabalar. ");
INSERT INTO ksd_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Una pait ra lukara na gem ba pa i leven. Lavurua na bung una en ra gem ba pa i leven, da iau ga vartuluai piram, ta nam ra bung ba iau ga tibe ta ra gai Abib, tago ta ra gai Abib u ga irop kan ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Nam parika a luaina kinakava, kaugu nam; damana bula a lavur nat na vavaguai, a umana tutana, a luaina ta ra bulumakau ma ta ra Sip. ");
INSERT INTO ksd_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ma ra luaina nat na as una kia valaun ia ma tika na nat na sip; ma ona pa u mainge pi una kia ia, una bubur ra inoana. Ma kaum lavur luaina bul tutana una kia valaun diat. Ma koko ta tikai na vana rikai vakuku piragu. ");
INSERT INTO ksd_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Laptikai na bung una papalum, ma ta ra valavuruana una ngo, ta ra kilala na niipuk ma ta ra kilala na nidodoko una ngo ta ra valavuruana bung. ");
INSERT INTO ksd_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Ma una pait ra lukara na vikvik ure ra luaina vuai ra vit, ma ra lukara na varuruai ta ra mutuai ra kilala. ");
INSERT INTO ksd_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","A umana tutana par piram diat a vautul ma ra vinavana rikai ta ra mata i ra Luluai God, a God kai Israel. ");
INSERT INTO ksd_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Tago ina korot vue ra umana vuna tarai ta ra luaina matam, ma ina vangala kaum langlangun; ma damana bula pa ta na na kaina upi kaum gunan ba u vana urama pi una vautul a tur rikai ta ra mata i ra Luluai kaum God, ta ra kilakilala. ");
INSERT INTO ksd_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Koko una tul tar ra gapu i kaugu tinabar varurung ma ra gem i leven; ma koko ra tinabar ure ra lukara na bolo lake na tur ra marum tuk tar ta ra malana. ");
INSERT INTO ksd_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","A luaina ta ra vuai e ta kaum pia una kap ia ta ra pal kai ra Luluai kaum God. Koko una kabalane ra nat na me ta ra polo na u i nana. ");
INSERT INTO ksd_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ma ra Luluai i ga biti tai Moses: Una tumu go ra lavur tinata, tago ma ra mangana tinata dari iau ga pait ra kunubu piram ma ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Ma i ga ki ie varurung ma ra Luluai a ivat na vinun na bung na keake ma a ivat na vinun na bung na marum; pa i ga ian ma pa i ga momo. Ma i ga tumu tar ra lavur tinata ure ra kunubu ta ra ura pal a vat, a vinun na tinata na vartuluai. ");
INSERT INTO ksd_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ma ba Moses i ga vana ba marama ra luana Sinai, ma i ga vatur ra ura pal a vat ta ra limana, ba i ga irop ta ra luana, Moses pa i ga nunure ba ra pal a matana i ga bagabagele, tago dir ga tata ma God. ");
INSERT INTO ksd_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ma ba Aron ma ra tarai Israel par dia ga gire Moses, ea, a pal a matana i ga bagabagele, ma dia ga burut upi diat a tadav ia. ");
INSERT INTO ksd_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ma Moses i ga oro pa diat, ma Aron ma ra umana lualua kai ra tarai dia ga vana pirana, ma Moses i ga tatata ta diat. ");
INSERT INTO ksd_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ma namur a tarai Israel par dia ga maravai pirana, ma i ga tul tar ra lavur magit par ta diat ba ra Luluai i ga varve tar ia tana ta ra luana Sinai. ");
INSERT INTO ksd_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ma ba i ga par ra tinata kai Moses, i ga tuba ra matana ma ra mal na turturup. ");
INSERT INTO ksd_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ma ba Moses i ga rukruk tadav ra Luluai upi dir a tatata me, i ga tak vue ra mal na turturup tuk tar ta nam ba i ga irop mulai, ma i ga irairop ma i ga ve tar ra lavur magit di ga tul tar ia tana ta ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Ma ra tarai Israel dia ga giragire ra mata i Moses, ba ra pal a matana i ga bagabagele; ma Moses i ga tuba mule ra matana ma ra mal na turturup tuk tar ta nam ba i ga ruk mulai upi dir a tata ma ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Ma Moses i ga oro varurue ra tarai Israel par, ma i ga biti ta diat: Go ra lavur tinata ra Luluai i vartuluai me, upi avat a toratorom tana. ");
INSERT INTO ksd_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Laptikai na bung avat a papalum, ma ra valavuruana bung a Bung Sabat pire vavat, a bung na bo na ningo, a bung kai ra Luluai, diat par dia papalum tana da doko diat. ");
INSERT INTO ksd_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Koko avat a voto ra iap ta kavava lavur gunan par ta ra Bung Sabat. ");
INSERT INTO ksd_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Ma Moses i ga biti ta ra tarai Israel par dari: Go ra magit ra Luluai i vartuluai me dari: ");
INSERT INTO ksd_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Avat a vartabar tadav ra Luluai ma ra magit i ki pire vavat; diat par ba a bala i diat i ga upi ia, diat a kap ia, a vartabar kai ra Luluai, a goled, a silva ma ra palariam gobol; ");
INSERT INTO ksd_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","a mal i blu marut ma i meme marut, ma i meme tuna, ma ra mal kumau, ma ra ivuna me; ");
INSERT INTO ksd_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ma ra umana pal a sip di ga puk vamema, ma ra pal a me, ma ra davai akasia; ");
INSERT INTO ksd_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ma ra dangi ure ra kapa, ma ra magit i ang na katkat ure ra dangi na varku ma ure ra bo na mi na lotu; ");
INSERT INTO ksd_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ma ra vat na onik, ma ra vat ba da mal ra kolot kai ra tena tinabar me ma ure ra popopoi. ");
INSERT INTO ksd_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Ma diat par ra umana tena kabinana pire vavat diat a vana uti ma diat a pait ra lavur magit ra Luluai i ga vartuluai tana: ");
INSERT INTO ksd_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ra Pal, kana pal na mal, ma kana tubatuba, kana al vakai, ma kana lavur pal a davai, kana davai, a vabolo, kana tukatukal, ma kana lavur kiki i ngovo; ");
INSERT INTO ksd_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ra bok ma ra kip ure, ma ra tubatuba tana, ma ra mal na rurua kutu; ");
INSERT INTO ksd_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ra vuvuvung na nian ma ra kip ure, ma ra lavur tabarikik ure, ma ra gem na ginigira; ");
INSERT INTO ksd_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","damana bula ra turtur na birao ure ra kapa ma ra lavur tabarikik ma ra lavur lamp ure, ma ra dangi ure ra kapa; ");
INSERT INTO ksd_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ma ra uguugu ure ra mi na lotu, ma kana kip, ma ra dangi na varku, ma ra magit i ang na katkat ure ra mi na lotu, ma ra mal na poraporo ure ra matakilalat, ta ra matakilalat i ra Pal; ");
INSERT INTO ksd_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","a uguugu na vartabar ure ra tinabar di tun tar ia, ma ra liplip na ubene tana di pait ia ma ra palariam gobol, kana kip ma ra lavur tabarikik ure, a la na vargi ma kana kiki; ");
INSERT INTO ksd_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","a umana mal na liplip ure ra bala na gunan, kana lavur tukal ma kadia kiki i ngovo, ma ra mal na poraporo ure ra matakilalat i ra bala na gunan; ");
INSERT INTO ksd_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","a lavur ot ure ra Pal, ma ra ot ure ra bala na gunan ma kadia lavur vinau; ");
INSERT INTO ksd_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","a lavur mal di ga viri mal ia ure ra kunudar ta ra pakana pal i gomgom, ra lavur gomgom na mal kai Aron ra tena tinabar, ma ra lavur mal kai ra umana natuna upi diat a kudakudar me ta ra papalum na tena tinabar. ");
INSERT INTO ksd_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ma ra kor na tarai Israel par dia ga vana kan ra mata i Moses. ");
INSERT INTO ksd_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Ma dia ga vut, diat par ba i ga malamalapang ra bala i diat, ma diat par dia ga upi ia, ma dia ga kapkap ra vartabar kai ra Luluai ure ra papalum ta ra pal na varbarat, ma ure ra lavur varvakai tana, ma ure ra lavur gomgom na mal. ");
INSERT INTO ksd_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Ma dia ga vut, a tarai ma ra vaden, diat par dia ga upi ia, ma dia ga kap ra lavur mamar bibilau ma ra marmar talinga ma ra domol, ma ra kurkurua ma ra lavur ngatngat na magit par di ga pait ia ma ra goled; diat par dia ga vartabar pire ra Luluai ma ra goled, dia ga kap tar ia. ");
INSERT INTO ksd_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ma ra tarai par dia ga vung ra mal i blu marut, ma i meme marut ma i meme tuna, ma ra mal kumau, ma ra ivuna me, ma ra pal a sip di ga puk vamema, ma ra pal a me, dia kap tar ia. ");
INSERT INTO ksd_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ma diat par dia ga tul tar ra tinabar, a silva ma ra palariam gobol, dia kap tabar ra Luluai me; ma diat par dia ga vung ra davai akasia ba na topa ta mangana tabarikik ure ra papalum, dia ga kap tar ia. ");
INSERT INTO ksd_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ma ra vaden par dia ga kabinana, dia vir mal ma ra lima i diat, ma dia kap nam dia ga vir ia, ra kuara i blu marut ma i meme marut, ma i meme tuna, ma ra mal kumau. ");
INSERT INTO ksd_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ma ra vaden par ba i ga malamalapang ra bala i diat upi ia, ma dia ga melem tana, dia ga vivir ma ra ivuna me. ");
INSERT INTO ksd_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Ma ra umana lualua dia ga kap ra vat na onik, ma ra lavur vat ure ra kolot kai ra tena tinabar ma ure ra popopoi bula; ");
INSERT INTO ksd_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ma ra magit i ang na katkat ma ra dangi, ure ra kapa ma ure ra dangi na varku ma ure ra bo na mi na lotu. ");
INSERT INTO ksd_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","A tarai Israel dia ga mulaot i tana, ma dia ga kap ra vartabar tuna pire ra Luluai; a tarai ma ra vaden par, ba i ga ra bala i diat upi diat a vartabar ure ra lavur papalum, nina ra. Luluai i ga vartuluai tana upi Moses na pait ia. ");
INSERT INTO ksd_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Ma Moses i ga biti ta ra tarai Israel: Gire, ra. Luluai i ga pilak pa Besalel, natu i Uri, natu i Kur, ta ra vuna tarai Iuda, ");
INSERT INTO ksd_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ma i ga vabuka ia ma ra Tulungea i God, ma na kabinana, ma na matoto, ma na melem, ma na madaka ta ra lavur mangana papalum, ");
INSERT INTO ksd_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","upi na nuk tadav ra umana enana papalum ma na pait ot pa diat ma ra goled, ma ra silva ma ra palariam gobol, ma na poko mal ra lavur vat na marmar, ");
INSERT INTO ksd_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ma na mut mal ra davai ma na pait ra lavur enana mangana papalum par. ");
INSERT INTO ksd_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ma i ga tul tar ia tana upi na varvateten, dir par ma Oliab, natu i Akisamak, ta ra vuna tarai Dan. ");
INSERT INTO ksd_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Nam dir i ga poe ra kabinana ta ra bala i dir upi dir a pait valar pa ra lavur mangana papalum kai ra tena madaka, ma ra tena vir mal tututumu, ma ra tena niingit guve mal tututumu, i blu marut, ma i meme marut ma i meme tuna, ma ra mal kumua, ma ra papalum kai ra tena vir mal tuna, maia, dir a pait ra papalum kadiat dia melem ta ra lavur mangana papalum, ma ra papalum kadiat dia nuk tadav ra lavur enana mangana papalum. ");
INSERT INTO ksd_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Ma Besalel ma Oliab dir a papalum, ma damana bula ra tarai par dia kabinana, diat ba ra Luluai i ga poe ra minatoto ma ra kabinana ta ra bala i diat upi diat a minana ma diat a pait valar pa ra lavur magit ure ra kunudar ta ra gomgom na pal varogop ma ra vartuluai kai ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Ma Moses i ga oro pa Besalel ma Oliab ma diat par dia kabinana, diat ba ra Luluai i ga poe ra kabinana ta ra bala i diat, diat par i ga malamalapang ra bala i diat upi diat a tadav ra papalum ma upi diat a pait ia; ");
INSERT INTO ksd_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","ma Moses i ga tul tar ra lavur vartabar kai ra tarai ta diat, nina ra tarai dia ga vung kapi ia ure ra papalum ta ra kunudar ta ra gomgom na pal, upi diat a pait ra lavur tabarikik me. Ma pa dia ga ngo boko ma ra kap vartabar, ta ra malana ra bungbung par dia ga kap ia. ");
INSERT INTO ksd_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Ma ra lavur tena kabinana par, diat dia ga pait ra lavur papalum ure ra gomgom na pal, dia ga vana, tikatikai kan ra papalum i ga varvakai tana, ma dia ga tadatadav Moses, ");
INSERT INTO ksd_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ma dia ga biti tana: A tarai dia ga manga vangala ra vartabar ure ra papalum kai go ra kunudar, nina ba ra Luluai i ga vartuluai tana upi da pait ia. ");
INSERT INTO ksd_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Ma Moses i ga vartuluai, ma dia ga varvarvai tana ta ra gunan par dari: Koko ra tarai ma ra vaden diat a vaninare mule ta magit upi diat a vartabar me ure ra gomgom na pal. Damana di ga tigal ra tarai upi koko diat a vartabar mulai. ");
INSERT INTO ksd_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Tago nam ra tabarikik di ga tar vung guve i ga topa ra lavur papalum, ma ta umana i tur valili bula. ");
INSERT INTO ksd_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Ma diat dia ga kabinana ta diat dia pait ra papalum, dia ga pait ra Pal ma ra vinun na mal na bakbak ure; dia ga pait ia ma ra mal kumau, ma ra blu marut ma ra meme marut, ma ra meme tuna, ma dia mal ra umana angelo tana, a papalum kai ra tena vir mal tututumu. ");
INSERT INTO ksd_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Tikatika na mal na bakbak kana lolovina i ga varogop ma lavurua na pokono, ma tikatikai a tababana i ga varogop ma tika na pokono; ma ra valavalar kai ra lavur mal na bakbak par i varogop uka. ");
INSERT INTO ksd_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ma i ga kubu guve ra ilima na mal na bakbak ma ta ra ilima bula. ");
INSERT INTO ksd_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ma i ga pait ra umana pipidikol ma ra kuara i blu marut ta ra luaina vuna mal ta nam ra pirina ba da kubu guve tana ma ta ra tikai; damana i ga pait ia bula ta ra piri ra vauruana vuna mal na bakbak. ");
INSERT INTO ksd_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","A ilima na vinun na pipidikol i ga pait ia tai tika na mal, ma ta ra ilima na vinun ta ra piri na mal na bakbak ta ra vauruana vuna mal; a umana pipidikol dia ga tur vartalai. ");
INSERT INTO ksd_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ma i ga mal a ilima na vinun na al vakai, ma i ga al pakan guve ra ra lavur mal na bakbak ma ra al vakai; damana ra Pal i ga kidoloina ka. ");
INSERT INTO ksd_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ma i ga pait ra umana mal ma ra ivuna me upi ra mal na tubatuba taun ra Pal; a vinun ma tika na mal i ga pait ia. ");
INSERT INTO ksd_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","A lolovina kai tikatika na mal i ga varogop ma lavurua na pokono ma a papar, ma ra tababana tika na pokono; tika na valavalar ika ure ra vinun ma tika na mal. ");
INSERT INTO ksd_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ma i ga pakan guve ra ilima na mal upi diat a tikai ka, ma damana laptikai na mal upi diat a tikai ka bula. ");
INSERT INTO ksd_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ma i ga pait a ilima na vinun na pipidikol ta ra piri ra luaina vuna mal, ma damana a ilima na vinun na pipidikol ta ra piri ra vauruana vuna mal. ");
INSERT INTO ksd_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ma i ga pait a ilima na vinun na al vakai ma ra palariam gobol upi na pakan guve ra mal na tubatuba me, upi na da ra kidoloina ka. ");
INSERT INTO ksd_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ma i ga pait ta ra tika na tubatuba ure ra pal na mal ma ra pal a sip di ga puk vamema, ma i ga pait ta ra tubatuba mulai ma ra pal a me. ");
INSERT INTO ksd_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ma i ga mal pa ra umana pal a davai akasia ure ra Pal, i ga vatur diat. ");
INSERT INTO ksd_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Tikatika na pal a davai kana lolovina i ga varogop ma ra ura pokono ma a papar, ma ra tababana i ga varogop ma tika na malmalikun ma a ngungu. ");
INSERT INTO ksd_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","A ura ot dir ga tur ta ra pal a davai tikatikai, ma di ga pakan guve dir; damana i ga pait ra lavur pal a davai ure ra Pal. ");
INSERT INTO ksd_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ma i ga pait ra pal a davai ure ra Pal, a ura vinun na pal a davai ure ra papar a taubar; ");
INSERT INTO ksd_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ma i ga pait a ivat na vinun na kiki ma ra ngovo tana; i ga pait diat ma ra silva upi diat a tur ta ra vavai ra ura vinun na pal a davai; a ura kiki ta ra vavai tika na pal a davai ure ra ura varpakan; ma ta ura kiki ta ra vavai ta ra tika na pal a davai ure ra ura varpakan. ");
INSERT INTO ksd_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ma ura ta ra papar a Pal, a papar a labur, i ga pait a ura vinun na pal a davai, ");
INSERT INTO ksd_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ma kadia ivat na vinun na kiki na silva; a ura kiki ta ra vavai tika na pal a davai, ma ta ra ura kiki ta ra vavai ta ra tikai. ");
INSERT INTO ksd_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ma ure ra papar namur ta ra matana taoai i ga pait laptikai na pal a davai. ");
INSERT INTO ksd_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Ma i ga pait a ura pal a davai ure ra ura ngu na Pal ta ra papar namur. ");
INSERT INTO ksd_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Ma dir ga tur vartalai ara ra pia, ma i ga tuk urama ta ra luaina lok; damana i ga pait dir ta ra ura ngu na pal. ");
INSERT INTO ksd_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ma damana i ga lavutul na pal a davai, ma kadia kiki na silva a vinun ma laptikai; ta ra.vavai tikatika na pal a davai a ura kiki. ");
INSERT INTO ksd_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ma i ga mal ra umana vabolo ma ra davai na akasia; a ilima ure ra pal a davai tai tika na papar a Pal, ma a ilima ure ta ra papar a Pal, ");
INSERT INTO ksd_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ma a ilima na vabolo ure ra lavur pal a davai ta ra papar namur ta ra matana taoai. ");
INSERT INTO ksd_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ma i ga mal pa ra vabolo livuan upi na tur pa ia tai tika na ngu na pal ma na tuk tai ta ra tikai, livuan ta ra umana pal a davai. ");
INSERT INTO ksd_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ma i ga vung vapetep tar ra goled ta ra pal a davai, ma i ga pait ra umana ngovo tana ma ra goled upi da ule ra umana vabolo tana, ma i ga vung vapetep tar ra goled ta ra vabolo. ");
INSERT INTO ksd_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ma i ga pait ra mal na rurua kutu ma ra kuara i blu marut, ma i meme marut ma i meme tuna, ma ra mal kumau; ma. a umana angelo dia ga tur tana, a tena vir mal tututumu i ga pait ia. ");
INSERT INTO ksd_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ma i ga pait a ivat na tukal ure, a davai akasia, ma i ga vung vapetep tar ra goled tana; kadia ot likun di ga pait ia ma ra goled, ma i ga tun mal ra ivat na kiki ure diat ma ra silva. ");
INSERT INTO ksd_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Ma i ga pait ra mal na poraporo ure ra matakilalat i ra pal na mal; i ga mal ia ma ra kuara i blu marut, ma i meme marut ma i meme tuna, ma ra mal kumau, a tena niingit guve mal tututumu i ga palum ia; ");
INSERT INTO ksd_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ma ra ilima na tukal ure, ma kadia ot likun bula; ma i ga vung vapetep tar ra goled ta ra ulu i diat ma ta kadia vipuar; ma kadia a ilima na kiki di ga pait ia ma ra palariam gobol. ");
INSERT INTO ksd_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Ma Besalel i ga mal ra bok ma ra davai akasia; kana lolovina i varogop ma a ura malmalikun ma a ngungu, ma tika na malmalikun ma a ngungu a tababana, ma tika na malmalikun ma a ngungu a tuluaina; ");
INSERT INTO ksd_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ma i ga vung vapetep tar ra, goled tuna tana, ta ra balana ma ta ra tamuruna, ma i ga mar kikil ia ma ra goled. ");
INSERT INTO ksd_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ma i ga tun mal ra ivat na ngovo ma ra goled ure, ta ra ivat na kakene; a urua tai tika na papar ma ta ra urua tai ta ra tikai. ");
INSERT INTO ksd_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ma i ga mut ra ura kip ma ra davai akasia ma i ga vung vapetep tar ra goled tana. ");
INSERT INTO ksd_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Ma i ga ule tar ra kip ta ra umana ngovo ta ra ura papar a bok, upi da kip ra bok me. ");
INSERT INTO ksd_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Ma i ga pait ra tubatuba ma ra goled tuna; kana lolovina i ga varogop ma ra ura malmalikun ma a ngungu, ma ra tababana tika na malmalikun ma a ngungu. ");
INSERT INTO ksd_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ma i a pait ra ura angelo ma ra goled di tutut ia; i ga pait dir ta ra ivu ngu i ra tubatuba, ");
INSERT INTO ksd_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","tika na angelo tai tika na nguna ma tikai tai ta ra tikai; a tubatuba ma ra ura angelo ta ra ura nguna, a kidoloina ka. ");
INSERT INTO ksd_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Ma ra ura angelo dir ga pala ra bebea i dir urama liu, ma dir ga turup ra tubatuba me, ma dir ga bobo varkuvo; ma ra mata i ra ura angelo i ga lingan tadav ra tubatuba. ");
INSERT INTO ksd_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Ma i ga pait ra vuvuvung na nian ma ra davai akasia, a papar kana lolovina, ma tika na malmalikun ra tababana, ma tika na malmalikun ma ra ngungu ra tuluaina; ");
INSERT INTO ksd_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","ma i ga vung vapetep tar ra goled tuna tana, ma i ga mar kikil ia ma ra goled. ");
INSERT INTO ksd_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Ma i ga pait tika na pal a davai kikil ia, a tababana i varogop ma ra tababa i ra lapar a lima i ra tutana, ma i ga mar kikil ia ma ra goled. ");
INSERT INTO ksd_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ma i ga tun mal ra ivat na ngovo ma ra goled, ma i ga vung ra ngovo ta ra ivat na ngu i va ivat na kakene. ");
INSERT INTO ksd_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Ra ivat na ngovo dia ga tur maravai ra pal a davai i ga vana kikil ia, upi da ule tar ra kip tana, upi da kip ra vuvuvung me. ");
INSERT INTO ksd_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ma i ga mut ra kip ta ra davai akasia, ma i ga vung vapetep tar ra goled tana upi da kip ra vuvuvung me. ");
INSERT INTO ksd_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ma i ga pait ra lavur tabarikik i ga tur ta ra ul a vuvuvung, kana lavur la, ma ra lavur momamomo ure, ma ra lavur la ure ma ra lavur pal a tava upi da lolongoi me; i ga pait ia ma ra goled tuna. ");
INSERT INTO ksd_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Ma i ga pait ra turtur na birao ma ra goled tuna, i ga pait ia ma ra goled di tutut ia, a bitina ma ra livuana; a matana pupuna, a pupuluna, ma ra mapina pupuna, a kidoloina ka; ");
INSERT INTO ksd_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","ma laptikai na ingarina dia ga vana rikai ta ra ura paparaina, a utul a ingar i ra turtur na birao tai tika na papar, ma a utul a ingar i ra turtur na birao tai ta ra papar; ");
INSERT INTO ksd_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","a utul a matana pupuna da ra pupuna i papala tai tika na ingarina, a pupuluna ma ra pupuna; ma a utul a matana pupuna da ra pupuna i papala tai ta ra ingarina, a pupuluna ma ra pupuna; damana ure ra laptikai na ingarina ba dia ga vana rikai ta ra turtur na birao. ");
INSERT INTO ksd_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ma ta ra livua i ra turtur na birao di pait ra ivat na matana pupu na davai da ra pupuna i papala, a pupuluna ma ra pupuna bula; ");
INSERT INTO ksd_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","tika na pupuluna ta ra vavai ra ura ingarina, a kidoloina. ma tika na pupuluna ta ra vavai ra ura ingarina, a kidoloina, ma tika na pupuluna ta ra vavai ra ura ingarina, a kidoloina me, damana ure ra laptikai na ingarina dia vana rikai tana. ");
INSERT INTO ksd_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","A pupulu i diat ma ra ingar i diat ma ra turtur a kidoloina parika; a turtur parika tikai ka ra papalum di ga pait ia ma ra goled di ga tutut ia. ");
INSERT INTO ksd_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Ma i ga pait ra lavurua na lamp ure, ma ra kakakarat na vinau na lamp ma kana la, a goled tuna. ");
INSERT INTO ksd_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Tika na talant na goled tuna i ga pait ia me ma ra lavur tabarikik ure bula. ");
INSERT INTO ksd_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Ma i ga pait ra uguugu ure ra vartabar na mi na lotu, i ga pait ia ma ra davai akasia; kana lolovina tika na malmalikun, ma ra tababana tika na malmalikun; a ivat na paparaina dia varogop; ma ra tuluaina a papar; a umana ramuna diat ma ra uguugu iat, a kidoloina; ");
INSERT INTO ksd_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","ma i ga vung vapetep tar ra goled tuna tana, ta ra uluna, ma ta ra paparaina, ma ta ra ramuna; ma i ga mar kikil ia ma ra goled tuna. ");
INSERT INTO ksd_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Ma i ga pait a ura ngovo ta ra vavai ra mamar kikil ta ra ura papar tana, upi da ule tar ra kip tana, ma upi da kip ia me. ");
INSERT INTO ksd_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Ma i ga. mut ra kip, a davai akasia, ma i ga vung vapetep tar ra goled tana. ");
INSERT INTO ksd_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Ma i ga pait ra gomgom na dangi ure ra varku, ma ra bo na magit i ang na katkat ure ra mi na lotu, da tikai a tena minamal polo i ang na vuvuvul. ");
INSERT INTO ksd_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ma i ga pait ra uguugu ure ra tinabar di tuntun tar ia ma ra davai akasia; kana lolovina a ilima na malmalikun, ma ra tababana a ilima na malmalikun; i ga varogop ra ivat na paparaina; ma ra tuluaina a utul a malmalikun. ");
INSERT INTO ksd_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ma i ga pait ra umana ramuna ta ra ul a uguugu na vartabar ta ra ivat na nguna; a ramuna ma ra uguugu na vartabar dia ga kidoloina ka. Ma i ga vung vapetep tar ra palariam gobol tana. ");
INSERT INTO ksd_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ma i ga pait ra lavur tabarikik ure ra uguugu na vartabar, a umana la na kabu, ma ra umana kulkulup, ma ra umana la na tava ma ra umana kono ure ra kanomong i ra vavaguai, ma ra umana la na lakit; a lavur tabarikik par tana i ga pait ia ma ra palariam gobol. ");
INSERT INTO ksd_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Ma i ga pait tika na liplip ma ra palariam gobol, da ra ubene, ma i ga vatur ia ta ra vavai ra vanavana kikil, ma i ga ki pit ika, pa i ga vana urama kakit. ");
INSERT INTO ksd_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ma i ga tun mal pa a ivat na mata ure ra ivat na ngu na liplip na ubene di ga pait ia ma ra palariam gobol, upi da ule tar ra kip tana. ");
INSERT INTO ksd_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ma i ga mut ra kip, a davai akasia, ma i ga vung vapetep ta ra palariam gobol tana. ");
INSERT INTO ksd_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Ma i ga ule tar ra kip ta ra mata ta ra ura paparai ra uguugu na vartabar, upi diat a kip ia me; ma i ga pait ia ma ra pal a davai. ma i ga pobono ko. ");
INSERT INTO ksd_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Ma i ga pait ra la na vargi ma ra palariam gobol, ma ra kakene bula a palariam gobol, i ga pait ia ma ra lavur tiroa kai ra vaden, nina dia ga kudakudar ta ra matakilalat i ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ma i ga mal bula ra bala na gunan; di ga pait ra mal na bakbak ure ra papar a taubar ma ra mal kumau, a ura vinun ma a ilima na pokono; ");
INSERT INTO ksd_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","a ura vinun na tukal ure, ma a ura vinun na kiki ure diat, di ga pait ia ma ra palariam gobol; a lavur ot likun tana ma kadia vipuar dia silva. ");
INSERT INTO ksd_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ma ure ra papar a labur a ura vinun ma a ilima na pokono a mal, a ura vinun na tukal ma a ura vinun na kiki ure, a palariam gobol; ra ot likun tana ma kadia vipuar, a silva. ");
INSERT INTO ksd_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ma ure ra papar a taoai a valavalar ure ra mal i ga varogop ma a vinun ma a ura pokono ma tika na papar, a vinun na tukal ure, ma a vinun na kiki; ra ot likun tana ma ra vipuar, a silva. ");
INSERT INTO ksd_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ma ure ra papar a taur a vinun ma a ura pokono ma tika na papar a mal. ");
INSERT INTO ksd_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","A mal na bakbak ure tika na papar ta ra mataniolo i ga varogop ma a utul a pokono ma a utul a malmalikun, a utul a tukal ma a utul a kiki tana; ");
INSERT INTO ksd_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ma damana ure ta ra papar; ta ra ura papar a mataniolo i ra bala na gunan a valavalar i ra mal na bakbak i ga utul a pokono ma a utul a malmalikun; a utul a tukal ma a utul a kiki ure. ");
INSERT INTO ksd_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","A lavur mal na bakbak par kikil ra bala na gunan di ga pait ia ma ra mal kumau. ");
INSERT INTO ksd_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ma ra kiki ure ra tukal, a palariam gobol; a ot likun ta ra tukal ma ra vipuar tana, a silva; ma di ga vung vapetep tar ra silva ta ra ul a tukal, ma ra lavur tukal i ra bala na gunan di ga vipuar diat ma ra silva. ");
INSERT INTO ksd_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Ma a tena niingit guve mal tututumu i ga pait ra mal na poraporo ure ra mataniolo i ra bala na gunan; i mal ia ma ra kuara i blu marut, ma i meme marut, ma i meme tuna, ma ra mal kumau; kana lolovina a ilima na pokono; ma ra valavalar i ra tuluaina i ga varogop ma tika na pokono ma tika na malmalikun, vardada ma ra mal na bakbak ure ra bala na gunan. ");
INSERT INTO ksd_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Ma a ivat na tukal ure, ma a ivat na kiki, a palariam gobol; a ot likun tana i ga silva, ma di ga vung vapetep tar ra silva ta ra ulu i diat, ma ra vipuar tana, a silva bula. ");
INSERT INTO ksd_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Ma ra lavur ot ure ra Pal, ma ure ra bala na gunan kikil ia, a palariam gobol. ");
INSERT INTO ksd_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Go ia ra niluluk na tabarikik ure ra Pal, a kuba i ra Tinata, da di ga luk guve diat ta ra vartuluai kai Moses; a papalum kai ta tarai Levi, ma Itamar natu i Aron ra tena tinabar, i ga lue diat i tana. ");
INSERT INTO ksd_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Ma Besalel, natu i Uri, natu i Kur, ta ra vuna tarai Iuda, i ga pait ot pa ra lavur magit ba ra Luluai i ga tul tar ia tai Moses. ");
INSERT INTO ksd_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ma dir ga varbete ma Oliab, natu i Akisamak, ta ra vuna tarai Dan, a tena madaka, a tena vir mal tututumu, ma a tena niingit guve mal tututumu, a blu marut, ma ra meme marut ma ra meme tuna ma ra mal kumau. ");
INSERT INTO ksd_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Ma ra goled nina di ga pait ra lavur tabarikik ure ra gomgom na pal me, a goled na vartabar, i ga varogop ma a ura vinun ma lavuvat na talant ma lavurua na mar ma a utul a vinun na mamat, vardada ma ra mamat kai ra gomgom na pal. ");
INSERT INTO ksd_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Ma ra silva kadiat dia ga luk diat ta ra tarai Israel i ga varogop ma ra mar na talant, ma tika na arip ma lavurua na mar, lavurua na vinun ma a ilima na mamat, varogop ma ra mamat ure ra gomgom na pal; ");
INSERT INTO ksd_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","a papar a mamat da ra mamat ure ra gomgom na pal ure diat tikatikai, ba dia tar bolo pire diat di ga luk diat; diat par ba a ura vinun kadia kilala, ba i ga bolo ra ura vinun, ure laptikai na mar ma a utul a arip, ma a ilima na mar ma a ilima na vinun na tarai. ");
INSERT INTO ksd_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Ma nam ra mar na talant na silva dia ga pait ra lavur kiki ure ra gomgom na pal me ma ra lavur kiki ure ra mal na rurua kutu; a mar na kiki di ga pait ia ma ra mar na talant, tika na talant ure ra kopono kiki. ");
INSERT INTO ksd_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ma nam ra kopono arip ma lavurua na mar, lavurua na vinun ma a ilima na mamat, di ga pait ra lavur ot likun me ure ra umana tukal, ma i ga vung vapetep tar ia ta ra ulu i diat, ma i ga pait ra vipuar ure diat me. ");
INSERT INTO ksd_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Ma ra palariam gobol, nina dia ga vartabar me, i ga varogop ma lavurua na vinun na talant, ma a ura arip ma a ivat na mar na mamat. ");
INSERT INTO ksd_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Ma i ga pait ra umana kiki me ure ra matakilalat i ra pal na varbarat, ma ra uguugu na vartabar i palariam gobol, ma ra liplip na ubene tana i palariam gobol, ma ra lavur tabarikik ure ra uguugu na vartabar, ");
INSERT INTO ksd_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ma ra lavur kiki ure ra bakbak kikil, ma ra lavur kiki ure ra mataniolo kai ra bala na gunan, ma ra lavur ot ure ra pal, ma ra lavur ot ure ra bala na gunan kikil ia. ");
INSERT INTO ksd_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Ma di ga vir ra umana bo na mal tuna ma ra kuara i blu marut, ma i meme marut ma i meme tuna, ure ra kunudar ta ra gomgom na pal; ma dia ga pait ra umana gomgom na mal ure Aron; da ra Luluai i ga vartuluai tana pire Moses. ");
INSERT INTO ksd_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Ma i ga mal pa ra kolot ure ra bongobongono ma ra goled, ma ra kuara i blu marut, ma ra meme marut ma ra meme tuna ma ra mal kumau. ");
INSERT INTO ksd_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ma dia ga tutut ra goled upi na melmel, ma dia ga poka upi na da ra kuara upi diat a vir tar ia ta ra mal i blu marut, ma ta ra meme marut ma ta ra meme tuna, ma ta ra mal kumau, a tena vir mal tututumu i ga vir ia. ");
INSERT INTO ksd_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Dia ga pait ra al vakai tana ure ra ul a varana, ta ra ura pirina di ga pakan guve me. ");
INSERT INTO ksd_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ma ra mal na vivi tana, di ga manga mal pa ia upi na ri ia me, dir ma ra kolot a kidoloina, ma a kopono mangana papalum; di ga pait ia ma ra goled ma ra kuara i blu marut ma i meme marut ma i meme tuna, ma ra mal kumau, da ra Luluai i ga ve Moses. ");
INSERT INTO ksd_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ma dia ga mal pa ra ura vat na onik, ma dia ga mar kikil vake dir ma ra goled, ma dia ga tutumu tana da ta ra vat ik di taun bat ra bulit me; dia ga tutumu tana ra lavur iang i ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ma i ga ingit tar dir ta ra al vakai ta ra kolot ure ra bongobongono, upi dir a ura vat na kodakodop ure ra tarai Israel, da ra Luluai i ga vartuluai tana pire Moses. ");
INSERT INTO ksd_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ma i ga pait ra popopoi, a tena vir mal tututumu i ga pait ia, i ga varogop ma ra papalum ta ra kolot ure ra bongobongono; di pait ia ma ra goled, ma ra kuara i blu marut, ma i meme marut, ma i meme tuna, ma ra mal kumau. ");
INSERT INTO ksd_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ra ivat na paparaina dia ga varogop, ma di pin ia; kana lolovina i varogop ma ra vartuk, ma damana bula ra tababana. ");
INSERT INTO ksd_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ma dia ga vaki a ivat na nga na vat tana. A luaina ngaina: a sardia, a topas ma ra kristal. ");
INSERT INTO ksd_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","A vauruana ngaina: a emeraled, a sapir ma ra daimon. ");
INSERT INTO ksd_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","A vautuluna ngaina: a amber, a agat ma ra ametist. ");
INSERT INTO ksd_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Ma ra vaivatina ngaina: a beril, a onik ma ra iasper. A kiki na goled.i ga mar kikil vake diat. ");
INSERT INTO ksd_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Ma ra umana vat dia ga varogop ma ra iang i ra tarai Israel, a vinun ma a ivut, varogop ma ra iang i diat, vardada ma ra tutumu ta ra vat ik di taun bat ra bulit me, tikatikai varogop ma ra iangina, ure ra vinun ma a ivu vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ma dia ga pait tar ra vinau na goled tuna da ra kuara di ga kulalang ia ta ra popopoi. ");
INSERT INTO ksd_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ma dia ga pait a ura kiki ma ra goled, ma a ura mata bula; ma dia ga mal tar ra ura mata ta ra ura ngu na popopoi. ");
INSERT INTO ksd_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ma dia ga kubu ra ura vinau na goled tar ta ra ura mata ta ra nguna popopoi. ");
INSERT INTO ksd_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Ma ta ra ivu ngu i ra ura vinau na goled dia ga pait tar ra ura kiki tana, ma dia ga ingit tar dir ta ra al vakai ure ra ul a varana ta ra kolot ure ra bongobongono, ta ra papar na lua. ");
INSERT INTO ksd_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ma dia pait ra ura mata na goled, ma dia ga kubu tar dir ta ra ura nguna popopoi ta ra pirina, nina i ga maravai pire ra kolot ure ra bongobongono. ");
INSERT INTO ksd_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ma dia ga pait a ura mata na goled, ma dia ga kubu tar dir ta ra ura al vakai ta ra kolot ure ra bongobongono, ta ra vavai dir ma ta ra papar mara na lua, maravai ra varpakan, arama ta ra mal na vivi ta ra kolot ure ra bongobongono. ");
INSERT INTO ksd_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ma dia ga kubu tar ra mata i tur ta ra popopoi ta ra mata i tur ta ra kolot ure a bongobongono, di ga kubu guve dir ma ra kuara i blu marut upi na ki taun ra mal na vivi kai ra kolot ma upi koko ra popopoi na tapala kan ra kolot, da ra Luluai i ga vartuluai tana pire Moses. ");
INSERT INTO ksd_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Ma i ga pait ra olovoi ure ra kolot na bongobongono, i ga vir vapar ia ma ra kuara i blu marut, ");
INSERT INTO ksd_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","ma i ga pait ra ngovo arama livuan tana, da ra ngovo i ra ongaongoi, ma i ga vir lok ra ngovono upi koko na tarada. ");
INSERT INTO ksd_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ma ta ra ngu na mal na olovoi dia ga pait ra umana pupulu ik tana da ra goava, di ga pait ia ma ra blu marut, ma ra meme marut, ma ra meme tuna, ma ra mal kumau. ");
INSERT INTO ksd_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ma dia ga pait ra umana taratarenge ma ra goled tuna, ma dia ga kubu tar ra umana taratarenge livuan ta ra umana pupulu dia ga da ra goava ta ra nguna mal; ");
INSERT INTO ksd_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","dari, a taratarenge ma a pupulu, a taratarenge ma a pupulu dia ga varvarpopoto kikil ra nguna mal na olovoi, upi na kudakudar me, da ra Luluai i ga vartuluai tana pire Moses. ");
INSERT INTO ksd_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ma dia ga pait ra lavut kolot lolovina kai Aron ma ra umana natuna, ");
INSERT INTO ksd_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ma ra mal na rarau, ma ra mal kumau; ma ra umana kere na minong di ga pait ia ma ra mal kumau, ma ra umana mal na tutana di ga pait ia ma ra mal kumau, ");
INSERT INTO ksd_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ma ra mal na vipit ma ra mal kumau, ma ra mal i blu marut, ma i meme marut, ma i meme tuna; a tena niingit mal tututumu i ga pait ia, da ra Luluai i ga vartuluai tana pire Moses. ");
INSERT INTO ksd_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ma dia ga mal pa ra pal a kapa na goled ure ra vipuar i gomgom, ma di ga tutumu tana varogop ra tutumu ta ra vat ik di taun bat ra bulit me, dari: Di tar tibe vaire pi kai ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ma di ga kubu tar ra vinau i blu marut tana, upi diat a vi tar ia arama ta ram al na rarau, da ra Luluai i ga vartuluai tana pire Moses. ");
INSERT INTO ksd_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Damana dia ga pait vapar ra lavur papalum ta ra pal, kai ra pal na varbarat; ma ra tarai Israel dia ga pait ra lavur magit da ra Luluai i ga vartuluai tana pire Moses, damana dia ga pait ia. ");
INSERT INTO ksd_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ma dia ga vung kapi ra Pal pire Moses, ra pal na mal ma ra ana lavur tabarikik, ra ana al vakai, ra ana pal a davai, ma ra davai i vabolo, ma ra ana tukal. ma ra ana lavur kiki i ngovo; ");
INSERT INTO ksd_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ma ra tubatuba di ga pait ia ma ra pal a sip di puk vamema, ma ra tubatuba di ga pait ia ma ra pal a me, ma ra mal na rurua kutu; ");
INSERT INTO ksd_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","a bok na tinata ma ra ana kip ma ra tubatuba ure; ");
INSERT INTO ksd_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","a vuvuvung na nian ma ra lavur tabarikik tana, ma ra gem na ginigira; ");
INSERT INTO ksd_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","a turtur na birao, ba di ga pait ia ma ra goled tuna, ma ra umana lamp tana, a umana lamp ba di ga vung bulu diat, ma ra lavur tabarikik ure, ma ra dangi ure ra kapa; ");
INSERT INTO ksd_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ra uguugu na vartabar di ga pait ia ma ra goled, ma ra dangi na varku, a magit i ga ang na katkat ure ra mi na lotu, ma ra mal na poraporo ure ra matakilalat i ra pal na mal; ");
INSERT INTO ksd_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ra uguugu na vartabar di ga pait ia ma ra palariam gobol, ma ra ana liplip i ga palariam gobol, ma ra ana kip ma ra ana lavur tabarikik, ra la na vargi ma ra ana kiki; ");
INSERT INTO ksd_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ra lavur mal na bakbak ure ra bala na gunan, ra ana lavur tukal, ma ra ana lavur kiki i ngovo, ma ra mal na poraporo ure ra matakilalat i ra bala na gunan, ma ra lavur vinau ma ra lavur ot tana, ma ra lavur tabarikik par ure ra kunudar ta ra gomgom na pal ta ra pal na varbarat; ");
INSERT INTO ksd_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ra lavur kolot ba di ga vir mal diat ure ra kunudar ta ra gomgom na pal, ma ra lavur gomgom na mal kai Aron ra tena tinabar, ma ra lavur mal kai ra umana natuna, upi diat a kudakudar me ta ra papalum kai ra tena tinabar. ");
INSERT INTO ksd_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Ma ra tarai Israel dia ga pait ra lavur papalum par varogop ma ra vartuluai par kai ra Luluai tadav Moses. ");
INSERT INTO ksd_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Ma Moses i ga gire ra lavur papalum par, ma gire, dia tar pait ot pa ia; da ra Luluai i ga vartuluai tana, damana dia ga tar pait ia; ma Moses i ga tata vadoane diat. ");
INSERT INTO ksd_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ma ra Luluai i ga tata tadav Moses, i ga biti dari: ");
INSERT INTO ksd_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Ta ra luaina bung ta ra luaina gai una vatur ra gomgom na pal ta ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ma una vung ra bok na tinata tana, ma. una vakaite ra mal na rurua kutu, upi ra bok na tur bakit tana. ");
INSERT INTO ksd_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ma una varuk ra vuvuvung na nian ma una vung mal ra lavur magit tana; ma una varuk ra turtur na birao, ma una vaninare ra umana lamp tana. ");
INSERT INTO ksd_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ma una vung ra uguugu na vartabar na goled ure ra mi na lotu na lua ta ra bok na tinata, ma una vakaite ra mal na poraporo ta ra matakilalat i ra Pal. ");
INSERT INTO ksd_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Ma una vung ra uguugu na vartabar ure ra tinabar di tuntun tar ia ta ra luaina mata i ra matakilalat i ra gomgom na pal ta ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ma una vung ra la na vargi livuan ta dir ra pal na varbarat ma ra uguugu na vartabar, ma una lingire ra tava tana. ");
INSERT INTO ksd_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ma una pait ra bala na gunan kikil ia, ma una vakaite ra mal na poraporo ure ra mataniolo ta ra bala na gunan. ");
INSERT INTO ksd_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Ma una tak pa ra dangi na varku, ma una vadangi ra pal me, ma ra lavur tabarikik tana, ma una vagomgom ia, ma ra lavur tabarikik tana, ma na gomgom. ");
INSERT INTO ksd_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ma una vadangi ra uguugu na vartabar ure ra tinabar di tuntun tar ia, ma ra ana lavur tabarikik, ma una vagomgom ra uguugu na vartabar, ma na gomgom kakit. ");
INSERT INTO ksd_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ma una vadangi ra la na vargi ma ra ana kiki, ma una vagomgom ia. ");
INSERT INTO ksd_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Ma una agure Aron ma ra umana natuna tadav ra matakilalat i ra pal na varbarat, ma una puk diat ma ra tava. ");
INSERT INTO ksd_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ma una ule tar ra lavur kolot i gomgom tai Aron; ma una ku ia, ma una vagomgom ia upi na kudakudar piragu ta ra papalum na tena tinabar. ");
INSERT INTO ksd_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ma una agure ra umana natuna,, ma una ule tar ra lavur kolot ta diat; ");
INSERT INTO ksd_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ma una ku diat, da u ga ku tama i diat, upi diat a kudakudar piragu ta ra papalum na tena tinabar; ma ta go ra varku da tibe tar ra papalum na tena tinabar ta diat ma kadia lavur taun tarai namur ta diat. ");
INSERT INTO ksd_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Damana Moses i ga pait ia; i ga pait ra lavur magit ra Luluai i ga tul tar ia tana. ");
INSERT INTO ksd_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Di ga vatut ra Pal ta ra luaina gai ta ra vauruana kilala, ta ra luaina bung. ");
INSERT INTO ksd_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Ma Moses i ga vatut ra Pal, ma i ga vung ra lavur kiki, ma i ga vatur ra lavur pal a davai tana, ma i ga vung ra lavur vabolo, ma i ga vatur ra lavur tukal. ");
INSERT INTO ksd_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ma i ga pala ra pal na mal taun ra gomgom na pal, ma i pait ra tubatuba ure ra pal na mal arama tana, da ra Luluai i ga vartuluai pire Moses tana. ");
INSERT INTO ksd_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ma i ga tak pa ra tinata ma i ga poe tar ia ta ra bok, ma i ga ule tar ra kip ta ra bok; ma i ga vung ra tubatuba taun ra bok; ");
INSERT INTO ksd_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","ma i ga varuk ra bok ta ra gomgom na pal, ma i ga vakaite ra mal na rurua kutu, upi ra bok na tinata na tur bakit, da ra Luluai i ga vartuluai pire Moses ure. ");
INSERT INTO ksd_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Ma i ga vatur ra vuvuvung na nian ta ra pal na varbarat ta ra papar a labur, mamati ta ra papar a mal na rurua kutu. ");
INSERT INTO ksd_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Ma i ga vung bulu ra gem tana ta ra luaina mata i ra Luluai, da ra Luluai i ga vartuluai pire Moses ure. ");
INSERT INTO ksd_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ma i ga vatur ra turtur na birao ta ra pal na varbarat ta ra papar a pal, ta ra papar a taubar, ma dir ga tur vartalai ma ra vuvuvung na nian. ");
INSERT INTO ksd_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ma i ga vaninare ra umana lamp ta ra luaina mata i ra Luluai, da ra Luluai i ga vartuluai pire Moses ure. ");
INSERT INTO ksd_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ma i ga vatur ra uguugu na vartabar na goled ta ra pal na varbarat ta ra luaina mata i ra mal na rurua kutu; ");
INSERT INTO ksd_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ma i ga tuntun ra magit tana ure ra mi na lotu i ang na katkat, da ra Luluai i ga vartuluai pire Moses ure. ");
INSERT INTO ksd_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ma i ga vakaite ra mal na poraporo ta ra matakilalat i ra pal. ");
INSERT INTO ksd_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ma i ga vatur ra uguugu na vartabar ure ra tinabar di tuntun tar ia pire ra matakilalat i ra gomgom na pal ta ra pal na varbarat, ma i ga vartabar ma ra tinabar di tuntun tar ia ma ra tinabar na nian tana, da ra Luluai i ga vartuluai pire Moses ure. ");
INSERT INTO ksd_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ma i ga vaki ra la na vargi livuan ta dir ra pal na varbarat ma ra uguugu na vartabar, ma i ga lolonge ra tava tana ure ra vargi. ");
INSERT INTO ksd_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Ma Moses ma Aron ma ra umana natuna dia ga puk ra lima i diat ma ra kak i diat tana; ");
INSERT INTO ksd_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ba dia ga ruk ta ra pal na varbarat,, ma ba dia ga vana maravai pire ra uguugu na vartabar dia ga vargi, da ra Luluai i ga vartuluai pire Moses. ");
INSERT INTO ksd_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ma i ga pait ra bala na gunan kikil ra pal ma ra uguugu na vartabar, ma i ga vakaite ra mal na poraporo ta ra matakilalat i ra bala na gunan. Damana Moses i pait rit ra lavur papalum. ");
INSERT INTO ksd_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ma ra bakut i ga ki taun ra pal na mal, ma ra minamar i ra Luluai i ga vabuka ra pal. ");
INSERT INTO ksd_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ma Moses pa i ga pait valar pa ra niruk ta ra pal na mal, tago ra bakut i ga ki taun ia, ma ra minamar i ra Luluai i ga vabuka ra pal. ");
INSERT INTO ksd_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ma ba ra bakut i ga tutua kan ra Pal, a tarai Israel dia ga vanavana, damana di ga pait ia ta kadia lavur vinavana; ");
INSERT INTO ksd_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ma ona ra bakut pa i ga tutua, io, pa dia ga vanavana, ma i ga tuk tar ta nam ra bung ba i ga tutua. ");
INSERT INTO ksd_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Tago ra bakut kai ra Luluai i ga ki taun ra Pal a bungbung par, ma ra iap i ga ki tana ta ra marum, ma ra tarai Israel par dia ga giragire ma ra mata i diat ta kadia lavur vinavana. ");
INSERT INTO ksd_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Ma ra Luluai i ga oro pa Moses, ma i ga tata pirana kan ra bala na pal na varbarat, ma i biti: ");
INSERT INTO ksd_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Una tata pire ra tarai Israel, ma una biti ta diat, Ba ta tikai ta vavat i tul tar ra vartabar na nian tadav ra Luluai, na tul tar ra vartabar na nian kan kavava lavur vavaguai, kan ra kikil na bulumakau ma ra kikil na sip. ");
INSERT INTO ksd_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Gala ra tutana i kap kana vartabar na nian kan ra kikil na bulumakau upi ra tinabar di tuntun tar ia, na tul tar ra tomotoina i ko kakit; na tul tar ia ta ra matakilalat i ra pal na varbarat upi ra Luluai na manane. ");
INSERT INTO ksd_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Na vung ra limana ta ra ulu i ra tinabar di tuntun tar ia, ma da alube pa ia upi ra varporong ure. ");
INSERT INTO ksd_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Ma na doko ra bulumakau ta ra luaina mata i ra Luluai; ma ra umana natu i Aron, ra umana tena tinabar, diat a kap vamarave ra gap, ma diat a apur ra uguugu na vartabar, nina i tur maravai ta ra matakilalat i ra pal na varbarat, ma ra gap. ");
INSERT INTO ksd_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Na kulit ra tinabar di tuntun tar ia, ma na poko gigi ia. ");
INSERT INTO ksd_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Ma ra umana natu i Aron, ra umana tena tinabar, diat a vautunge ra iap, ");
INSERT INTO ksd_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","ma diat a vung bulu ra umana pakapakana ma ra ula ma ra bira taun ra davai, nina i ki ta ra iap ta ra uguugu na vartabar. ");
INSERT INTO ksd_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Ra tutana na puk ra balana ma ra kakene, ma ra tena tinabar na tun diat ma ra lavur pakapakana ta ra uguugu na vartabar ure ra tinabar di tuntun tar ia ta ra iap, i ang na katkat tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Gala ra tutana i kap kana vartabar na nian kan ra kikil na sip ba ra kikil na me, upi ra tinabar di tuntun tar ia, na tul tar ra tomotoina i ko kakit. ");
INSERT INTO ksd_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Na doka ta ra luaina mata i ra Luluai ta ra papar a labur ta ra uguugu na vartabar; ma ra umana natu i Aron, ra umana tena tinabar, diat a apur ra uguugu na vartabar ma ra gapuna. ");
INSERT INTO ksd_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Ra tutana na poko gigi ia, ma ra tena tinabar na vung bulu ra umana pakapakana ma ra ula ma ra bira taun ra davai, nina i ki ta ra iap ta ra uguugu na vartabar; ");
INSERT INTO ksd_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","ra tutana na puk ra balana ma ra kakene, ma ra tena tinabar na tul vapar tar ia ma na tun ia ta ra uguugu na vartabar, a tinabar di tuntun tar ia ta ra iap, i ang na katkat tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Gala kana vartabar na nian tadav ra Luluai, ra umana beo di tuntun tar ia, na tul tar ta uka ba ta nat na balu ure kaka vartabar na nian. ");
INSERT INTO ksd_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Ra tena tinabar na kap tar ia ta ra uguugu na vartabar, ma na liue kutu ra uluna, ma na tun ia ta ra uguugu na vartabar; da nonore ra gap tana ta ra paparai ra uguugu na vartabar; ");
INSERT INTO ksd_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","na tak vue ra entarina ma ra ivuna, ma na vue tar ia ta ra kabu na iap marave ra uguugu na vartabar ta ra papar a taur tana; ");
INSERT INTO ksd_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","na al kodo ra bebeana, ma koko na al rot ia; ma ra tena tinabar na tun ia ta ra uguugu na vartabar, ta ra davai nina i ki ta ra iap, a tinabar di tuntun tar ia ta ra iap, i ang na katkat tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Ma ba ta tikai i tul tar ra vartabar na nian, a tinabar na vuai na uma tadav ra Luluai, na tul tar ra bo na plaua ure kana vartabar na nian; na lolonge ra dangi tana, ma na vung varurungane ra bulit i ang na katkat me, ");
INSERT INTO ksd_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ma na kap ia pire ra umana natu i Aron, ra umana tena tinabar, ma na tatak pa tana tika na ginagu na plaua ma ra dangi tana, ma ra bulit i ang na katkat, ma ra tena tinabar na tun ia, a magit na im tadav ra Luluai ta ra uguugu na vartabar, a tinabar di tun ia ta ra iap, i ang na katkat tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ma nina i ki valili ta ra tinabar na vuai na uma, Aron ma ra umana natuna diat a kap ia; ia ra magit i gomgom kakit ta ra umana tinabar kai ra Luluai nina di tun ia ta ra iap. ");
INSERT INTO ksd_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Ma ba u tul tar ra vartabar na nian, a tinabar na vuai na uma nina di tun ia ta ra ubu, da tul tar ra gem nina ba pa i leven, ma di ga pait ia ma ra bo na plaua ma ra dangi, ba ra gem i maleplep ma pa i leven, di lolonge ra dangi ka tana. ");
INSERT INTO ksd_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ma gala kaum vartabar na nian, a tinabar na vuai na uma di tun ia ta ra palariam, da tul tar ra bo na plaua nina ba pa i leven, ma ra dangi tana. ");
INSERT INTO ksd_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Una tabik ia, ma una lolonge ra dangi tana, ia ra tinabar na vuai na uma. ");
INSERT INTO ksd_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Ma gala kaum vartabar na nian, a tinabar na vuai na uma di tun ia ta ra rararangai, da pait ia ma ra bo na plaua ma ra dangi. ");
INSERT INTO ksd_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Ma una kap ra tinabar na vuai na uma nina di ga pait ia ma ra dari tadav ra Luluai, ma da tul tar ia tai ra tena tinabar, ma na kap ia tadav ra uguugu na vartabar. ");
INSERT INTO ksd_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Ma ra tena tinabar na tatak pa ta ra tinabar na vuai na uma ra magit na im tana ma na tun ia ta ra uguugu na vartabar; a tinabar di tun ia ta ra iap, i ang na katkat tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ma nina i ki valili ta ra tinabar na vuai na uma, kai Aron ma ra umana natuna: ia ra magit i gomgom kakit ta ra umana tinabar kai ra Luluai nina di tun ia ta ra iap. ");
INSERT INTO ksd_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Pa ta tinabar na vuai na uma nina ba avat a tul tar ia tai ra Luluai, da pait ia ma ra leven; i tabu ba avat a tun ta leven ba ta polo na bulit na livur upi ra tinabar di tun ia ta ra iap tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Avat a tul tar go dir a vartabar na nian upi ra luaina vuaina ta ra uma tadav ra Luluai; pa dir a tutua, a magit i ang na katkat ta ra uguugu na vartabar. ");
INSERT INTO ksd_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Ma ra lavur vartabar na nian ta kaum tinabar na vuai na uma, una pota ma ra solt, ma ta ra kunubu ma kaum God koko kaum tinabar na vuai na uma na iba upi ra solt; ta kaum lavur vartabar na nian una tul tar bula ta solt. ");
INSERT INTO ksd_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Ma gala una tul tar ra tinabar na vuai na uma, nina ba ra luaina vuai na uma, tadav ra Luluai, una tul tar ra kon di tun ia ta ra iap, ma ra kalamana kon di doka. ");
INSERT INTO ksd_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Ma una lolonge ra dangi tana, ma una vung ra bulit i ang na katkat tana; ia ra tinabar na vuai na uma. ");
INSERT INTO ksd_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Ma ra tena tinabar na tun ta pakana tana ure ra magit na im, ta pakana ta ra kon di doka, ma ra pakana ta ra dangi tana, ma ra bulit i ang na katkat; ia ra tinabar di tun ia ta ra iap tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Ma gala kana vartabar na nian a tinabar na varmaram, ma i tul tar ra vavaguai, a tomotoina ba ra tana, na tul tar nina i ko kakit ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Na vung ra limana ta ra ulu i kana vartabar na nian, ma na doka ta ra matakilalat i ra pal na varbarat; ma ra umana natu i Aron, ra umana tena tinabar, diat a apur ra uguugu na vartabar ma ra gap. ");
INSERT INTO ksd_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Na tul tar ta pakana ta ra tinabar na varmaram upi ra tinabar di tun ia ta ra iap tadav ra Luluai; ra bira di pulu ra balam me ma ra bira i ki petep ta ra balana, ");
INSERT INTO ksd_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ma ra ura ela ma ra bira i ki petep ta dir ma ra mal i ra kat, da tak vue diat ma ra ura ela. ");
INSERT INTO ksd_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Ra umana natu i Aron diat a tun go ta ra uguugu na vartabar taun ra tinabar di tuntun tar ia ta ra davai i ki ta ra iap: ia ra tinabar di tun ia ta ra iap, i ang na katkat tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Gala i tul tar kana vartabar na nian kan ra kikil na sip, a tinabar na varmaram tadav ra Luluai, ta tomotoina ba ta tana, na tul tar ia a ko kakit. ");
INSERT INTO ksd_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Gala i tul tar ra nat na sip ure kana vartabar na nian, na tul tar ia ta ra luaina mata i ra Luluai; ");
INSERT INTO ksd_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","na vung ra limana ta ra ulu i kana vartabar na nian, ma na doka ta ra luaina mata i ra pal na varbarat; ma ra umana natu i Aron diat a apur ra uguugu na vartabar ma ra gapuna. ");
INSERT INTO ksd_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Na tul tar ta pakana ta ra tinabar na varmaram upi ra tinabar di tun ia ta ra iap tadav ra Luluai; ra bira parika ma ra taukuna i bira, na kutu vue ta ra bitina, ma ra bira di pulu ra balana me ma ra bira i ki petep ta ra balana, ");
INSERT INTO ksd_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ma ra ura ela ma ra bira i ki petep ta dir, ma ra mal i ra kat, na tak vue diat ma ra ura ela. ");
INSERT INTO ksd_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Ma ra tena tinabar na tun ia ta ra uguugu na vartabar; ma ia ra nian na tinabar di tun ia ta ra iap tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Ma gala i tul tar ra me ure kana vartabar na nian, na tul tar ia ta ra luaina mata i ra Luluai; ");
INSERT INTO ksd_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","na vung ra limana ta ra uluna, ma na doka ta ra luaina mata i ra pal na varbarat; ma ra umana natu i Aron diat a apur ra uguugu na vartabar ma ra gapuna. ");
INSERT INTO ksd_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Ma na tul tar ta pakana ta kana vartabar na nian, upi ra tinabar di tun ia ta ra iap tadav ra Luluai; ra bira di pulu ra balana me, ma ra bira i ki petep ta ra balana, ");
INSERT INTO ksd_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ra ura ela, ma ra bira ta dir, ma ra mal i ra kat, na tak vue diat ma ra ura ela. ");
INSERT INTO ksd_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Ma ra tena tinabar na tun diat ta ra uguugu na vartabar; ia ra nian na tinabar di tun ia ta ra iap, upi ra magit i ang na katkat; ra bira parika di ga vatabue ure ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Go ra tinata na varkurai na tur upi kavava umana taun tarai, ma ta ra lavur gunan avat a ki tana, ma na dari, koko avat a en ra bira ba ra gap. ");
INSERT INTO ksd_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Ma ra Luluai i ga tata pire Moses, ma i biti: ");
INSERT INTO ksd_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Una tata pire ra tarai Israel, ma una biti, Gala ta tikai i pait ra varpiam ma ra tuptup, ba i pait nina ra magit a Luluai i ga kure ba koko da pait ia; ");
INSERT INTO ksd_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","gala ra tena tinabar, nina di ga ku ia, na pait ra varpiam, ma ra vuaina tana na ki taun ra tarai, na tul tar ra nat na bulumakau i ko kakit pire ra Luluai upi ra varporong ure ra varpiam i ga pait ia. ");
INSERT INTO ksd_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Na ben tar ra bulumakau ta ra matakilalat i ra pal na varbarat ta ra luaina mata i ra Luluai; na vung ra limana ta ra ulu i ra bulumakau, ma na doko ra bulumakau ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Ma ra tena tinabar, nina di ga ku ia, na tak pa ra gapu i ra bulumakau, ma na kap tar ia ta ra pal na varbarat; ");
INSERT INTO ksd_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","ma ra tena tinabar na vadudu ta kaka na limana ta ra gap, ma na pikire tar ra gap lavurua na pakana ta ra luaina mata i ra Luluai, ta ra luaina mata i ra mal na rurua kutu ai ra gomgom na pal. ");
INSERT INTO ksd_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Ma ra tena tinabar na kolo ra umana ram ma ra gap ta ra uguugu na vartabar i ra magit i ang na katkat ta ra luaina mata i ra Luluai, aina ta ra bala na pal na varbarat; ma na lingire vapar vue ra gapu i ra bulumakau, nina i ki valili, ta ra bit a uguugu na vartabar, ure ra tinabar di tuntun tar ia, nina i tur ta ra matakilalat i ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Ma na tak vue ra bira parika ta ra bulumakau ure ra varporong; ra bira di pulu ra balana me, ma ra bira parika i ki petep ta ra balana, ");
INSERT INTO ksd_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ma ra ura ela, ma ra bira i ki petep ta dir, ma ra mal i ra kat, na tak vue ma ra ura ela, ");
INSERT INTO ksd_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","da di tak vue kan ra bulumakau ure ra tinabar na varmaram; ma ra tena tinabar na tun diat ta ra uguugu na vartabar ure ra tinabar di tuntun tar ia. ");
INSERT INTO ksd_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ma na kap vue ra pal i ra bulumakau, ma ra viono parika, ma ra uluna, ma ra umana kakene, ma ra balana, ma ra lavur puta tana, ");
INSERT INTO ksd_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ra bulumakau parika, na kap ia tadav ra papar a gunan irai nina ba i gomgom, ra pakana di lingire ra kabu na iap tana, ma na tun ia ma ra davai ta ra iap; da tun ia ka ta ra pakana di lingire ra kabu na iap tana. ");
INSERT INTO ksd_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Ma gala ra tarai Israel par dia vana irai, ma ra tarai dia tuptup ure ra magit di pait ia, ma dia ga pait nam ba ra Luluai i ga kure ba koko da pait ia, ma ra vuai ra varpiam i ki ta diat, ");
INSERT INTO ksd_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ba di kapa ure ra varpiam nina dia ga pait ia, ra tarai diat a tul tar ra nat na bulumakau ure ra varporong, ma diat a kap ia ta ra luaina mata i ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Ma ra umana patuana kai ra tarai diat a vung ra lima i diat ta ra ulu i ra bulumakau ta ra luaina mata i ra Luluai; ma da doko ra bulumakau ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Ma ra tena tinabar, nina di ga ku ia, na kap tar ra gap u ra bulumakau ta ra pal na varbarat, ");
INSERT INTO ksd_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ma ra tena tinabar na vadudu ra kaka na limana ta ra gap, ma na pikire tar ra gap lavurua na pakana ta ra luaina mata i ra Luluai, ta ra luaina mata i ra mal na rurua kutu. ");
INSERT INTO ksd_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Ma na kolo ra umana ram ma ra gap ta ra uguugu na vartabar ta ra luaina mata i ra Luluai aina ta ra bala na pal na varbarat; ma na lingire vapar vue ra gap nina i ki valili, ta ra bit a uguugu na vartabar ure ra tinabar di tuntun tar ia, nina i tur ta ra matakilalat i ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Ma na tak vue ra bira parika tana ma na tun ia ta ra uguugu na vartabar. ");
INSERT INTO ksd_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Na pait ra dari ure ra bulumakau, na pait nam nina i ga pait ia ure ra bulumakau ure ra varporong; ra tena tinabar na pait ra varporong ure diat, ma da nur vue kadia nirara. ");
INSERT INTO ksd_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Na kap vue ra bulumakau tadav ra papar a gunan irai, ma na tun ia da i ga tun ra luaina bulumakau; ia muka ra varporong ure ra tarai. ");
INSERT INTO ksd_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Ba ta luluai i pait ra varpiam, ma i pait ia ma ra tuptup, nina ra magit ra Luluai kana God i ga kure ba koko da pait ia, ma ra vuai ra varpiam i ki tana; ");
INSERT INTO ksd_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ba di vakapa ure ra varpiam nina i ga pait ia, na kap ra me, a tomotoina i ko kakit, ");
INSERT INTO ksd_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","ma na vung ra limana ta ra ulu i ra me, ma na doka ta ra pakana nina di doko ra tinabar di tuntun tar ia tana, ta ra luaina mata i ra Luluai: ia ra tinabar na varporong. ");
INSERT INTO ksd_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Ma ra tena tinabar na tak pa ra gap u ra tinabar na varporong ma ra kaka na limana, ma na kolo ra umana ram ta ra uguugu na vartabar ure ra tinabar di tuntun tar ia, ma ra gap nina i ki valili na lingire ta ra bit a uguugu na vartabar ure ra tinabar di tuntun tar ia. ");
INSERT INTO ksd_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Ma ra bira parika tana na tun ia ta ra uguugu na vartabar, da di pait ia ure ra tinabar na varmaram; ma ra tena tinabar na pait ra varporong ure ma ure kana varpiam, ma da nur vue. ");
INSERT INTO ksd_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Ma gala ta tikai ta ra gunan i pait ra varpiam ma ra tuptup, ba i pait nina ra magit ra Luluai i ga kure ba koko da pait ia, ma ra vuai ra varpiam i ki tana, ");
INSERT INTO ksd_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ba di vakapa ure ra varpiam nina i ga pait ia, na kap pa ta me, a tana i ko kakit, ure ra varpiam nina i ga pait ia. ");
INSERT INTO ksd_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Na vung ra limana ta ra ulu i ra tinabar na varporong, ma na doka ta ra pakana ure ra tinabar di tuntun tar ia. ");
INSERT INTO ksd_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Ma ra tena tinabar na tak pa ra gap ma ra kaka na limana, ma na kolo ra umana ram ta ra uguugu na vartabar ure ra tinabar di tuntun tar ia, ma ra gap nina i ki valili na lingire ta ra bit a uguugu na vartabar. ");
INSERT INTO ksd_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Da tak vue ra bira tana da di tak vue ta ra tinabar na varmaram, ma ra tena tinabar na tun ia ta ra uguugu na vartabar, a magit i ang na katkat tadav ra Luluai, ma ra tena tinabar na pait ra varporong ure, ma da nur vue kana varpiam. ");
INSERT INTO ksd_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Gala i kap ra nat na sip ure ra tinabar na varporong, na kap ra tana i ko kakit. ");
INSERT INTO ksd_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Na vung ra limana ta ra ulu i ra tinabar na varporong ma na doka ta ra pakana nina di doko ra tinabar di tuntun tar ia tana. ");
INSERT INTO ksd_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Ma ra tena tinabar na tak pa ra gap ma ra kaka na limana, ma na kolo ra umana ram ta ra uguugu na vartabar ure ra tinabar di tuntun tar ia, ma ra gap nina i ki valili na lingire ta ra bit a uguugu na vartabar. ");
INSERT INTO ksd_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Na tak vapar vue ra bira tana da di tak vue ra bira ta ra nat na sip ure ra tinabar na varmaram, ma na tun ia ta ra uguugu na vartabar, da ra umana tinabar di tun diat ta ra iap tadav ra Luluai. Damana ra tena tinabar na pait ra varporong bat ia ure ra varpiam i ga pait ia, ma da nur vue. ");
INSERT INTO ksd_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Gala ta tikai i pait ra varpiam ta nam iat ba i ga ki mut ure ra magit i ga gire ba i ga kapa ure, ma i kap ra vuai kana varpiam tana; ");
INSERT INTO ksd_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","ba gala i bili ta magit nina ba pa i gomgom, ta minat na leing, ba ta minat na vavaguai, ba ta minat i ta magit i kakakao nina pa i gomgom, ma i tuptup ure, nam iat kana varpiam; ");
INSERT INTO ksd_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","ba gala i bili ta mangana dur ta ra tarai, ma i tuptup ure; ba i kapa ure, nam iat kana varpiam; ");
INSERT INTO ksd_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","ba gala ta tikai i vavalima vakuku upi na pait ra kaina ba ra boina, ba i vavalima vakuku ure ava bar ra magit, ma i tuptup ure; ba i kapa ure, nam iat kana varpiam; ");
INSERT INTO ksd_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","ma na dari, ba i rara ta ra magit i ga pait ia, na varvai kapa ure nina ra magit i ga rara tana; ");
INSERT INTO ksd_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","ma na kap kana tinabar na nirara tadav ra Luluai ure ra varpiam i ga pait ia, a tana kan ra kikil na sip ba ra kikil na me ure ra tinabar na varporong, ma ra tena tinabar na pait ra varporong bat ia ure kana varpiam. ");
INSERT INTO ksd_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Ona pa i tale pi na tul tar ra nat na sip, na kap ta ivu uka, ba ta ivu nat na balu tadav ra Luluai ure kana nirara; ta tikai ure ra tinabar na varporong ma ta ra tikai ure ra tinabar di tuntun tar ia. ");
INSERT INTO ksd_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Na kap dir pire ra tena tinabar, ma na vartabar lua ma nina ba ure ra varporong; na liue kutu ra uluna, ia kaka, pa na kutu varbaiane; ");
INSERT INTO ksd_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","ma na pikire ra gapu i ra tinabar na varporong tar ta ra paparai ra uguugu na vartabar, ma ra gap nina i ki boko na nonore tar ia ta ra bit a uguugu na vartabar; ia ra tinabar na varporong. ");
INSERT INTO ksd_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Ma na vaninare ra vauruana ure ra tinabar di tuntun tar ia, da ra tinata na vartuluai; ma ra tena tinabar na pait ra varporong bat ia ure ra varpiam i ga pait ia, ma da nur vue. ");
INSERT INTO ksd_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Ona pa i tale pi na tul tar ta ivu uka, ba ta ivu balu ka, na kap tika na vavinununa ta ra epa na bo na plaua, a vartabar na nian ure ra varpiam i ga pait ia; pa na lolonge ra dangi tana, ma pa na vung bula ta bulit i ang na katkat tana, tago ia ra tinabar na varporong. ");
INSERT INTO ksd_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Na kap ia pire ra tena tinabar, ma ra tena tinabar na kap kana tika na ginagu kan ia ure ra magit na im tana, ma na tun ia ta ra uguugu na vartabar, da di tun ra umana tinabar ta ra iap tadav ra Luluai; ia ra tinabar na varporong. ");
INSERT INTO ksd_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ma ra tena tinabar na pait ra varporong bat ia ure ra varpiam. i ga pait ia ta go ra umana magit, ma da nur vue. Nam i ki valili, kai ra tena tinabar, da di pait ia ta ra tinabar na vuai na uma. ");
INSERT INTO ksd_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Ma ra Luluai i ga tata pire Moses, ma i biti: ");
INSERT INTO ksd_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Gala ta tikai i varpiam, ma i pait ra varpiam ma ra tuptup ure ra magit di ga vagomgom ia ure ra Luluai, na kap kana tinabar na varpiam tadav ra Luluai, a sip. kan ra kikil na sip, a tomotoina i ko kakit, nina. ba u valar ra mataina ma ra mamat na silva, a mamat ai ra gomgom na pal; ");
INSERT INTO ksd_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","na bali bula nam i ga kap varara ta ra magit di ga vagomgom ia ure ra Luluai, ma na vung tar bula tika na vavailimana pakana tana, ma na tul tar ia tai ra tena tinabar, ma ra tena tinabar na pait ra varporong ure ma ra sip ure ra tinabar na varpiam, ma da nur vue. ");
INSERT INTO ksd_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Ma gala ta tikai i pait ra varpiam, ma i pait ta magit ta go diat nina ba ra Luluai i ga kure ba koko da pait ia, ma gala i ga tuptup ure, i pait ra varpiam, ma na puak ra vuai kana varpiam. ");
INSERT INTO ksd_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Na kap ta sip, a tomotoina i ko kakit kan ra kikil na sip tadav ra tena tinabar ure ra tinabar na varpiam, ma ra tena tinabar na pait ra varporong bat ia ure ra magit i ga rara tana ma ra tuptup, tago pa i ga nunure; da nur vue. ");
INSERT INTO ksd_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","la ra tinabar na varpiam, tago a dovotina i ga rara ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Ma ra Luluai i ga tata pire Moses ma i biti: ");
INSERT INTO ksd_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Gala ta tikai i pait ra varpiam, ma i varpiam pire ra Luluai, ba i valunga talaina ure ra vakilang ba ra vuvung varirap, ba i ga long, ba i ga ki taun talaina, ");
INSERT INTO ksd_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ba i ga varpuai ure ra magit i ga rara nina i ga na tadav ia ma i ga vavalima vavaongo tana; ");
INSERT INTO ksd_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","gala i rara tai ta tikai ta go diat, na tul valilikun tar mule nina ba i ga long pa ia, ba i ga ra pa ia, ba ra magit na vuvung varirap, ba ra magit i ga rara nina ia iat i ga tadav ia, ");
INSERT INTO ksd_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ba ta magit nina i ga vavalima vavaongo ure, na tul valilikun vapar tar mule, ma na vung tar bula tika na vavailimana pakana tana, na tul valilikun tar mule pire nina ba kana ta ra bung ba i tul tar kana tinabar na varpiam tana. ");
INSERT INTO ksd_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Na kap kana tinabar na varpiam tadav ra Luluai, a tomotoina i ko kakit kan ra kikil na sip, nina ba u luk ra mataina, ma na tul tar ia pire ra tena tinabar, ");
INSERT INTO ksd_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ma ra tena tinabar na pait ra varporong ure ta ra luaina mata i ra Luluai, ma da nur vue ra magit i ga rara tana. ");
INSERT INTO ksd_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Ma ra Luluai i ga tata pire Moses, ma i ga biti: ");
INSERT INTO ksd_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Una vartuluai pire Aron ma ra umana natuna, ma una biti: Go iat ra varkurai ure ra tinabar di tuntun tar ia: ra tinabar di tuntun tar ia na ki taun ra davai ta ra uguugu na vartabar ta ra marum parika ma tuk tar ta ra malana, ma ra iap ta ra uguugu na vartabar na birao vatikai. ");
INSERT INTO ksd_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Ma ra tena tinabar na ule kana lolovina kolot ma kana mal na tutana ure ra livuana, ma na tak vue ra kabu i ra tinabar di tuntun tar ia nina ba ra iap i ga vaimur vue, ma na vung diat maravai ta ra papar a uguugu na vartabar. ");
INSERT INTO ksd_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Namur na kia vue kana umana mal ma ta enana, ma na kap vue ra kabu tar ta ra gomgom na pakana ta ra papar a gunan irai. ");
INSERT INTO ksd_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Ma ra iap ta ra uguugu na vartabar na birao vatikai, koko na mat; ra tena tinabar na vung ra davai tana ta ra lavur bungbung na malana; na vung mal ra tinabar di tuntun tar ia tana, ma na tun ra bira i ra tinabar na varmaram tana. ");
INSERT INTO ksd_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","A iap na birao vatikai ta ra uguugu na vartabar; koko ra iap na mat. ");
INSERT INTO ksd_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Go iat ra varkurai ure ra tinabar na vuai na uma. A umana natu i Aron diat a tul tar ia ta ra luaina mata i ra Luluai, aina ta ra luaina mata i ra uguugu na vartabar. ");
INSERT INTO ksd_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Ra tena tinabar na tak pa kana ginagu na bo na plaua kan ra tinabar na vuai na uma, ma ra dangi tana, ma ra bulit par nina i ang na katkat, ma na tun ia ta ra uguugu na vartabar upi ra magit i ang na katkat, a magit na im tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Ma nina i ki valili tana Aron ma ra umana natuna diat a en ia; da en ia ma pa ta leven tana, ta ra pakana i gomgom; diat a en ia ta ra bala na gunan ai ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Pa da tun ia ma ra leven. Iau ga tibe pire diat upi kadia tiniba kan kaugu umana tinabar di tuntun tar ia; ia ra magit i gomgom kakit, da ra tinabar na varporong ma ra tinabar na.varpiam. ");
INSERT INTO ksd_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","A umana natu i Aron, a umana tutana ka, diat a ian tana; ia kavava tiniba tuktukum, ta ra umana taun tarai, kan ra tinabar di tun ia ta ra iap tadav ra Luluai; nina i bili ra tinabar i gomgom, ia iat na gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Ma ra Luluai i ga tata pire Moses, ma i biti: ");
INSERT INTO ksd_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Go iat ra vartabar na nian nina ba Aron ma ra umana natuna diat a tul tar ia tai ra Luluai ta ra bung di ku ia tana; a lavur bungbung parika diat a tul tar tika na vavinununa ta ra epa na bo na plaua, ta ngungu tana ta ra malana, ma ta ra ngungu tana ta ra ravian. ");
INSERT INTO ksd_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Da tun varurungane ma ra dangi ta ra palariam; ba di tar pota da kap tar ia; io, da tul tar go ra tinabar na vuai na uma, a magit i ang na katkat tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Ma ra tena tinabar nina di ga pilak pa ia ta ra umana natuna na tul tar ia; ia ra varkurai tuktukum ba da tun vapar vue tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Ra lavur tinabar na vuai na uma, nina ba ra tena tinabar i tul tar ia, da vaimur vue, pa da en ia muka. ");
INSERT INTO ksd_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Ma ra Luluai i ga tata pire Moses ma i biti: ");
INSERT INTO ksd_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Una tata pire Aron ma ra umana natuna, ma una biti: Go iat ra varkurai ure ra tinabar na varporong; ta ra pakana di doko ra tinabar di tuntun tar ia tana, ta nam bula ra pakana da doko ra tinabar na varporong ta ra luaina mata i ra Luluai; ia ra magit i gomgom kakit. ");
INSERT INTO ksd_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Ra tena tinabar nina i vartabar me na en ia; ta ra pakana i gomgom da en ia, ta ra bala na gunan ai ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Nina i bili ra viono tana na gomgom; gala di lingire ta gap kan ia tai ta mal, da puk vagomgom ra mal nina ra gap i ga tadav ia ta ra pakana gunan i gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ra la na pia nina di ga tun ia tana, da nila vue, ia kaka gala di ga kabalane ta ra la na palariam gobol da vagomgom ia, ma da puk ia ta ra gomgom na tava. ");
INSERT INTO ksd_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","A umana tutana parika ta ra umana tena tinabar diat a ian tana, ia ra magit i gomgom kakit. ");
INSERT INTO ksd_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Pa da en muka ta tinabar na varporong nina ba di kap ra gapuna ta ra bala na pal na varbarat upi ra varporong; da vaimur vue ta ra iap. ");
INSERT INTO ksd_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Go iat ra varkurai ure ra tinabar na varpiam, ia ra magit i gomgom kakit. ");
INSERT INTO ksd_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Ta ra pakana di doko ra tinabar di tuntun tar ia tana, ta nam bula ra pakana da doko ra tinabar na varpiam tana, ma da apure ra gapuna ta ra umana paparai ra uguugu na vartabar. ");
INSERT INTO ksd_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ma ra tena tinabar na vartabar ma ra bira parika tana, ra taukuna nina i bira, ra bira di pulu ra balana me, ");
INSERT INTO ksd_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ra ura ela, ma ra bira i ki petep ta dir, ma ra mal i ra kat, na tak vue ma ra ura ela; ");
INSERT INTO ksd_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","ma na tun diat ta ra uguugu na vartabar, a tinabar di tuntun tar ia tadav ra Luluai; ia ra tinabar na varpiam. ");
INSERT INTO ksd_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","A umana tutana parika ta ra umana tena tinabar diat a ian tana; da en ia ta ra pakana gunan i gomgom; ia ra magit i gomgom kakit. ");
INSERT INTO ksd_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Da ra tinabar na varporong damana bula ra tinabar na varpiam, a kopono varkurai ure dir parika; ra tena tinabar nina i pait ra varporong na kap ia. ");
INSERT INTO ksd_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ra tena tinabar nina i tul tar ra tinabar di tuntun tar ia ure ra tutana, nam iat ra tena tinabar na vatur vake ra pal i ra vavaguai di tul tar ia ure ra tinabar di tuntun tar ia. ");
INSERT INTO ksd_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Ma ra umana tinabar na vuai na uma nina di tun ia ta ra ubu ma nam parika nina di vaninare ta ra rararangai ba di tun ia ta ra palariam, ra tena tinabar nina i tul tar ia tai ra Luluai na vatur vake. ");
INSERT INTO ksd_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Ia kaka da tibe pire ra umana natu i Aron ra lavur tinabar na vuai na uma nina ra dangi i ki tana, ba i ge, tikatika na tiniba na varavarogop. ");
INSERT INTO ksd_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Go iat ra varkurai ure ra tinabar na varmaram nina ba ta tikai na tul tar ia tai ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Gala i tul tar ia a magit na pite varpa, na tul varurungane tar ra umana gem me, nina ba pa i leven ma di puk ia ma ra dangi, ma ra umana gem i maleplep ma pa i leven di puk ia ma ra dangi, ma ra bo na plaua nina di ga pota ma ra dangi. ");
INSERT INTO ksd_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Na tul tar ra umana gem nina i leven varurung ma kana vartabar na nian, nina ba kana tinabar na varmaram ure ra pite varpa. ");
INSERT INTO ksd_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Tikatika na gem ta ra lavur mangana gem na pilak vue upi kai ra Luluai; ra tena tinabar nina i apure ra gapu i ra tinabar na varmaram na vatur vake diat. ");
INSERT INTO ksd_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ma ra vio i ra vavaguai nina ba kana tinabar na varmaram upi ra magit na pite varpa, da en ia ta nam iat ra bung i tul tar kana vartabar na nian tana; koko ta pakana na ki valili tuk ta ra malana. ");
INSERT INTO ksd_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Ma gala i tul tar ra vartabar na nian ure ta magit i vavalima tana ba ta tamarigat na vartabar, da en ia ta ra bung di pait ra vartabar tana, ma ta ra kubakene bula, ");
INSERT INTO ksd_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","ma nina i ki valili tar ta ra vautuluna bung da vaimur vue ta ra iap. ");
INSERT INTO ksd_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Gala di en ra vio i ra tinabar na varmaram nina i ki valili ta ra vautuluna bung, pa da manane nam ra tinabar, ma pa da luk tar ia tai nina i tul tar ia; na da ra puputa ka ma nina i en ia na da ra varpiam pirana. ");
INSERT INTO ksd_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Pa da en ra viono ona i agil ta magit nina ba pa i gomgom, da vaimur vue ke ta ra iap. Nina i gomgom na ian ta ra viono di vartabar me; ");
INSERT INTO ksd_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ba gala ta tikai i en ra vio i ra tinabar na varmaram, nina ba kai ra Luluai, ma pa i gomgom, da kutu vue nam kan kana vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Ma gala ta tikai i bili ta magit nina pa i gomgom, ta tutana, ba ta vavaguai ba ta magit i kakakao, ma namur i en ra vio i ra tinabar na varmaram, nina ba kai ra Luluai, da kutu vue nam kan kana vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Ma ra Luluai i ga tata pire Moses, ma i biti: ");
INSERT INTO ksd_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Una tata pire ra tarai Israel, ma una biti: Koko avat a en ra bira i ra bulumakau, ba ra bira i ra sip, ba ra bira i ra me. ");
INSERT INTO ksd_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ra bira i ra vavaguai i mat vakuku, ba ta leing i ga ubu kadakadal ia, i topa kavava lavur papalum, ia kaka koko muka avat a en ia; ");
INSERT INTO ksd_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","ma nina i en ra bira i ra vavaguai nina di tuntun tar ia tadav ra Luluai, nam da kutu vue kan kana vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Koko avat a en ta mangana gap, a gapu i ra beo ba a gapu i ra vavaguai ta ra lavur gunan ba ava ki tana. ");
INSERT INTO ksd_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Nina ba i en ra gap da kutu vue nam kan kana vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Ma ra Luluai i ga tata pire Moses, ma i biti: ");
INSERT INTO ksd_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Una tata pire ra tarai Israel, ma una biti, Nina i tul tar kana tinabar na varmaram, a vartabar tadav ra Luluai, na kap ta pakana ta kana tinabar tadav ra Luluai; ");
INSERT INTO ksd_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","a limana iat na kap ra tinabar di tun tar ia tadav ra Luluai ta ra iap: a bira ma ra bongobongo i ra tinabar, ma da tulue ra bongobongono tadav ra Luluai, upi ra tinabar na tutuluai. ");
INSERT INTO ksd_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Ra tena tinabar na tun ra bira ta ra uguugu na vartabar, ma ra bongobongono kai Aron ma ra umana natuna. ");
INSERT INTO ksd_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Avat a tul tar ra kelakelegi ta ra lima tuna pire ra tena tinabar upi kana tiniba kan kavava tinabar na varmaram nina ba u pait ra vartabar me. ");
INSERT INTO ksd_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Ra natu i Aron nina i tul tar ra gap u ra tinabar na varmaram ma ra birana na vatur vake ra kelakelegi ta ra lima tuna upi kana tiniba. ");
INSERT INTO ksd_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Tago iau ga tar tibe vaire vue ra bongobongo nina di tulue ma ra kelakelegi ta ra lima tuna ta ra umana tinabar na varmaram kai ra tarai Israel ure Aron ra tena tinabar ma ra umana natuna upi kadia tiniba pa na mutu kan ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Go nina ra tiniba kai Aron ma ra umana natuna kan ra umana tinabar di tuntun tar ia tadav ra Luluai, ba di ga tibe diat ra umana tena tinabar ta ra papalum kai ra Luluai, ");
INSERT INTO ksd_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","ra tiniba nina ba ra Luluai i ga kure ba ra tarai Israel diat a tul tar ia upi ra adiat pa na mutu ta ra umana taun tarai, ta ra bung ba i ga pilak pa diat. ");
INSERT INTO ksd_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Go iat ra varkurai ure ra tinabar di tuntun tar ia, ma ure ra tinabar na vuai na uma, ma ra tinabar na varporong, ma ra tinabar na varpiam, ma ure ra varku, ma ure ra tinabar na varmaram, ");
INSERT INTO ksd_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","nina ba ra Luluai i ga vartuluai tana pire Moses ta ra luana Sinai, ta ra bung ba i ga vartuluai ba ra tarai Israel diat a tul tar kadia umana vartabar na nian tadav ra Luluai ta ra bil Sinai. ");
INSERT INTO ksd_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Ma ra Luluai i ga tata pire Moses, ma i biti: ");
INSERT INTO ksd_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Una agure Aron ma ra umana natuna, ma una tak pa ra umana mal, ma ra dangi na varku, ma ra bulumakau ure ra varporong, ma ra ura sip a ura tomotoina, ma ra rat na gem nina ba pa i leven; ");
INSERT INTO ksd_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ma una vartuluai upi ra tarai ba diat a kor varurung ta ra matakilalat i ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Ma Moses i ga pait nam ba ra Luluai i ga vartuluai tana; ma ba ra tarai dia ga kor varurung ta ra matakilalat i ra pal na varbarat, ");
INSERT INTO ksd_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Moses i ga biti tai ra tarai: Go iat ra magit a Luluai i tar vartuluai ba da pait ia. ");
INSERT INTO ksd_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Ma Moses i ga agure Aron ma ra umana natuna, ma i ga puk diat ma ra tava. ");
INSERT INTO ksd_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Ma i ga ule tar ra lolovina kolot tai Aron, ma i ga vi pit ia ma ra vivi, ma i ga ule ra olovoi tana ma ra kolot na bongobongo ma i ga vi pit ia ma ra vivi di ga viri mal ia kai ra kolot na bongobongo. ");
INSERT INTO ksd_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Ma i ga ule ra popopoi na varkurai tana; ma i ga poe tar ra Urim ma ra Tumim ta ra popopoi na varkurai. ");
INSERT INTO ksd_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Ma i ga vung ra mal na rarau ta ra uluna, ma i ga vung ra marmar i goled, nina ba ra vipuar i gomgom taun ra mal na rarau; go parika ra Luluai i ga vartuluai tana pire Moses. ");
INSERT INTO ksd_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Ma Moses i ga tak pa ra dangi na varku, ma i ga vadangi ra pal na varbarat ma ra lavur magit par tana, ma i ga vagomgom diat. ");
INSERT INTO ksd_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Ma i ga apur ra uguugu na vartabar lavurua na pakana, ma i ga vadangi ra uguugu na vartabar ma ra umana la tana, ma ra la na vargi, ma ra bit a la na vargi upi na vagomgom diat. ");
INSERT INTO ksd_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Ma i ga lolonge ra dangi na varku ta ra ulu i Aron, ma i ga ku ia, upi na vakilang vaire. ");
INSERT INTO ksd_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Ma Moses i ga agure ra umana natu i Aron, ma i ga ule ra umana lolovina kolot ta diat, ma i ga vi pit diat ma ra umana vivi, ma i ga vi ra umana mal ta ra ulu i diat, da ra Luluai i ga vartuluai tana. ");
INSERT INTO ksd_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Ma i ga kap pa ra bulumakau ure ra tinabar na varporong, ma Aron ma ra umana natuna dia ga vung ra lima i diat ta ra ulu i ra bulumakau ai ra tinabar na varporong. ");
INSERT INTO ksd_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Ma Moses i ga doka; ma i ga tak pa ra gap, ma i ga kolo ra umana ram ta ra uguugu na vartabar ma ra kaka na limana, ma i ga vagomgom ra uguugu na vartabar, ma i ga lolonge ra gap tar ta ra bit a uguugu na vartabar, ma i ga vagomgom ia upi na pait ra varporong tana. ");
INSERT INTO ksd_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Ma i ga tak pa ra bira par nina i ki petep ta ra balana, ma ra mal i ra kat, ma ra ura ela ma ra bira ta dir, ma Moses i ga tun ia ta ra uguugu na vartabar. ");
INSERT INTO ksd_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ma ra bulumakau, ma ra palina, ma ra viono, ma ra puta tana, i ga vaimur vue ta ra iap ta ra papar a gunan irai, da ra Luluai i ga vartuluai tana pire Moses. ");
INSERT INTO ksd_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Ma i ga kap pa ra sip ure ra tinabar di tuntun tar ia, ma Aron ma ra umana natuna dia ga vung ra lima i diat ta ra uluna. ");
INSERT INTO ksd_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Ma Moses i ga doka; ma i ga apure ra gap ta ra uguugu na vartabar. ");
INSERT INTO ksd_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Ma i ga poko gigi ra sip, ma i ga tun ra uluna ma ra umana pakapakana, ma ra bira, ");
INSERT INTO ksd_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","ma i ga puk ra balana ma ra umana kakene ma ra tava; go parika Moses i ga tun ia upi ra tinabar di tuntun tar ia ta ra uguugu na vartabar, a magit i ang na katkat, a vartabar di pait ia ta ra iap tadav ra Luluai, da ra Luluai i ga vartuluai tana pire Moses. ");
INSERT INTO ksd_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Ma i ga kap ra vauruana sip, ra sip na varvadoan; ma ba Aron ma ra umana natuna dia ga tar vung ra lima i diat ta ra uluna, ");
INSERT INTO ksd_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Moses i ga doka; ma i ga tak pa ra gapuna ma i ga kolo ra ngu na talinga i Aron me, ta ra papar a lima tuna tana, ma ra kaka ngala ta ra limana tuna, ma ra kaka ngala ta ra kauna ta ra papar a lima tuna tana. ");
INSERT INTO ksd_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Ma Moses i ga agure ra umana natu i Aron, ma i ga kolo ra ngu na talinga i diat ma ra gap ta ra papar a lima tuna ta diat, ma ra kaka ngala ta ra lima tuna ta diat, ma ra kaka ngala ta ra kau i diat ta ra papar a lima tuna ta diat, ma i ga apur ra uguugu na vartabar ma ra gap. ");
INSERT INTO ksd_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Ma i ga tak pa ra bira, ma ra taukuna i bira, ma ra bira parika nina i ki petep ta ra balana, ma ra mal i ra kat, ma ra ura ela, ma ra bira ta dir, ma ra kelakelegi ta ra lima tuna, ");
INSERT INTO ksd_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","ma i ga tak pa tika na gem nina ba pa i leven, ma tika na gem ik di pait ia ma ra dangi, ma tika na gem ik i maleplep, kan ra rat na gem ba pa i leven nina i tur ta ra luaina mata i ra Luluai, ma i ga vung diat taun ra bira ma ra kelakelegi ta ra lima tuna, ");
INSERT INTO ksd_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","ma i ga vung vapar ia ta ra lima i Aron, ma ta ra lima i ra umana natuna, ma di ga tulue diat upi ra tinabar na tutuluai ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Ma Moses i ga tak pa diat kan ra lima i diat ma i ga tun diat ta ra uguugu na vartabar taun ra tinabar di tuntun tar ia, ure ra magit i ang na katkat ta ra luaina mata i ra Luluai; a tinabar nam ba di tun tar ia ta ra iap tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Ma Moses i ga tak pa ra bongobongo i ra sip, ma i ga tulue upi ra tinabar na tutuluai ta ra luaina mata i ra Luluai; a tiniba kai Moses nam ta ra sip na varvadoan, da ra Luluai i ga vartuluai tana pire Moses. ");
INSERT INTO ksd_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Ma Moses i ga tak pa ta ik ta ra dangi na varku ma ta ra gap ta ra uguugu na vartabar, ma i ga apur Aron ma kana lavur mal me, ma ra umana natuna ma kadia lavur mal bula me; ma i ga vakilang vaire Aron ma kana lavur mal, ma ra umana natuna ma kadia lavur mal varurung me. ");
INSERT INTO ksd_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Ma Moses i ga biti tai Aron ma ra umana natuna: Avat a kabalane ra viono ta ra matakilalat i ra pal na varbarat; avat a en ia ie varurung ma ra gem ta ra rat na varvadoan, da di ga biti tagu ba Aron ma ra umana natuna diat a en ia. ");
INSERT INTO ksd_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ma nina i ki valili ta ra viono ma ra gem avat a tun vue ta ra iap. ");
INSERT INTO ksd_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Ma koko avat a vana kan ra matakilalat i ra pal na varbarat ure lavurua na bung tuk na par ra lavur bungbung ure ra varvadoan ta vavat; lavurua na bung da varvakai ma kavava varvadoan. ");
INSERT INTO ksd_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ra magit di ga pait ia ta go ra bung di ga pait ia ta ra vartuluai kai ra Luluai upi da pait ra varporong ure avat. ");
INSERT INTO ksd_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Avat a ki ta ra matakilalat i ra pal na varbarat ta lavurua na bung na keake ma ta lavurua na bung na marum, ma avat a toratorom tai ra Luluai tana, upi koko avat a mat, tago di ga vartuluai tagu damana. ");
INSERT INTO ksd_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Ma Aron ma ra umana natuna dia ga pait vapar ra lavur magit par nina ba ra Luluai i ga vartuluai tana ta ra ngie i Moses. ");
INSERT INTO ksd_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Ma ta ra valavutuluna bung Moses i ga vartuluai upi Aron ma ra umana natuna ma ra umana patuana Israel, ");
INSERT INTO ksd_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","ma i ga biti tai Aron: Una tak pa tika na nat na bulumakau a tomotoina ure ra tinabar na varporong, ma ra sip a tomotoina ure ra tinabar di tuntun tar ia, ma dir par dir a ko kakit, ma una tul tar dir ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ma una biti tai ra tarai Israel: Avat a tak pa ta me a tomotoina ure ra tinabar na varporong, ma ta nat na bulumakau ma ta nat na sip, ba i kopono ko kadir kilala ma dir ko kakit, ure ra tinabar di tuntun tar ia, ");
INSERT INTO ksd_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ma ta bulumakau ma ta sip a tomotoina, ure ra tinabar na varmaram, upi da vartabar me ta ra luaina mata i ra Luluai; da kap bula ra tinabar na vuai na uma nina di ga pota ma ra dangi; tago ra Luluai na tur kapet pire vavat ta go ra bung. ");
INSERT INTO ksd_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ma dia ga kap nam ba Moses i ga kure tar ia ta ra matakilalat i ra pal na varbarat, ma ra tarai par dia ga kakari maravai, ma dia ga tur ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Ma Moses i ga biti: Go ra magit ra Luluai i ga vartuluai tana ba avat a pait ia; upi ra minamar kai ra Luluai na tur kapet ta ra luaina mata i vavat. ");
INSERT INTO ksd_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Ma Moses i ga biti tai Aron: Una vana maravai tar ta ra uguugu na vartabar, ma una tul tar kaum tinabar na varporong, ma kaum tinabar di tuntun tar ia, ma una pait ra varporong ure avat ma ra tarai; ma una tul tar ra vartabar na nian kai ra tarai ma una pait ra varporong ure diat, da ra Luluai i ga vartuluai tana. ");
INSERT INTO ksd_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Ma Aron i ga vana maravai tar ta ra uguugu na vartabar, ma i ga doko ra nat na bulumakau ure ra tinabar na varporong, nina ba ure ia iat, ");
INSERT INTO ksd_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","ma ra umana natu i Aron dia ga kap pa ra gap pirana, ma i ga vadudu ra kaka na limana ta ra gap, ma i ga kolo ra umana ram ta ra uguugu na vartabar, ma i ga lolonge ra gap ta ra bit a uguugu, na vartabar; ");
INSERT INTO ksd_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","ra bira, ma ra ura ela, ma ra mal i ra kat kai ra tinabar na varporong, i ga tun ia ta ra uguugu na vartabar, da ra Luluai i ga vartuluai tana pire Moses. ");
INSERT INTO ksd_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Ma ra viono ma ra palina i ga tun vue ta ra iap ta ra papar a gunan irai. ");
INSERT INTO ksd_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Ma i ga doko ra tinabar di tuntun tar ia; ma ra umana natuna dia ga kap pa ra gap tadav ia, ma i ga apur ra uguugu na vartabar me. ");
INSERT INTO ksd_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ma dia ga kap pa ra tinabar di tuntun tar ia tadav ia, a umana pakapakana ma ra uluna bula, ma i ga tun diat ta ra uguugu na vartabar. ");
INSERT INTO ksd_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Ma i ga puk ra balana ma ra umana kakene, ma i ga tun diat taun ra tinabar di tuntun tar ia ta ra uguugu na vartabar. ");
INSERT INTO ksd_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Ma i ga tul tar ra vartabar na nian kai ra tarai, ma i ga tak pa ra me ure ra tinabar na varporong, nina ba ure ra tarai, ma i ga doka, ma i ga tul tar ia ure ra varporong, da ra luaina. ");
INSERT INTO ksd_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Ma i ga kap pa ra tinabar di tuntun tar ia, ma i ga tul tar ia da ra vartuluai ure. ");
INSERT INTO ksd_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Ma i ga kap pa ra tinabar na vuai na uma, ma i ga tak pa tika na ginagu tana, ma i ga tun ia ta ra uguugu na vartabar varurung ma ra tinabar di tuntun tar ia ta ra malana. ");
INSERT INTO ksd_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","I ga doko ra bulumakau ma ra sip a tomotoina bula, nina ba ra tinabar na varmaram kai ra tarai, ma ra umana natuna dia ga kap pa ra gap tadav ia, ma i ga apur ra uguugu na vartabar me. ");
INSERT INTO ksd_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ma ra bira i ra bulumakau ma ra taukuna i bira ta ra sip, ma ra bira i pulu ra balana, ma ra ura ela, ma ra mal i ra kat, ");
INSERT INTO ksd_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","di ga vung ia taun ra bongobongo i ra virua, ma i ga tun ra bira ta ra uguugu na vartabar; ");
INSERT INTO ksd_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","ma ra bongobongo i ra virua ma ra kelakelegi ta ra lima tuna, Aron i ga tulue upi ra tinabar na tutuluai ta ra luaina mata i ra Luluai, da Moses i ga kure. ");
INSERT INTO ksd_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Ma Aron i ga tulue ra limana taun ra tarai, ma i ga tata vadoane diat, ma i ga vana ba kan ra papalum na tinabar na varporong, ma ra tinabar di tuntun tar ia, ma ra tinabar na varmaram. ");
INSERT INTO ksd_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Ma Moses ma Aron dir ga ruk ta ra pal na varbarat, ma ba dir ga irop, dir ga tata vadoane ra tarai, ma ra minamar i ra Luluai i ga tur kapet ta ra luaina mata i ra tarai. ");
INSERT INTO ksd_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Ma ra iap i ga arikai ta ra luaina mata i ra Luluai, ma i ga tun vue ra tinabar di tuntun tar ia, ma ra bira ta ra uguugu na vartabar; ma ba ra tarai dia ga gire, dia ga kukukula, ma dia ga bura timtibum. ");
INSERT INTO ksd_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Ma Nadab ma Abiu, ra ura natu i Aron, dir ga tak pa kadir la na mi tikatikai, ma dir ga vung ra iap ta dir, ma dir ga vung ra bulit i ang na katkat ta dir, ma dir ga pait ra iap vakuku ta ra luaina mata i ra Luluai, nina pa i ga vartuluai tana pire dir. ");
INSERT INTO ksd_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Ma ra iap i ga arikai kan ra mata i ra Luluai, ma i ga en vue dir, ma dir ga mat ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Ma Moses i ga biti tai Aron: Go iat nina ra Luluai i ga tatike, dari, Ina vaarike kaugu lia na kini ta diat dia kakari maravai piragu, ma ina vaarike kaugu ngala na minamar ta ra luaina mata i ra tarai parika. Ma Aron i ga ki mut uka. ");
INSERT INTO ksd_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Ma Moses i ga ting pa Misael ma Elsapan, a ura natu i Usiel, dir matuana ma Aron, ma i ga biti ta dir: Amur a mai, ma amur a puak vue ra ura niuru i mumur kan ra gomgom na pal tar ta ra papar a gunan irai. ");
INSERT INTO ksd_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ma dir ga vut, ma dir ga puak vue dir, ma ra umana mal dir mal me, tar ta ra papar a gunan irai, da Moses i ga biti. ");
INSERT INTO ksd_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Ma Moses i ga biti tai Aron, ma tai Eleaser ma tai Itamar, ra ura natuna. Koko ra pepe na ulu i vavat na purpuruan, ma koko avat a rada kavava lavur mal; upi koko avat a mat, ma koko ra Luluai na kankan ure ra tarai; avat a nur tar ia pire ra lavur niuru i vavat ra tarai Israel par upi diat a tangie go ra iap nina ba ra Luluai i ga pait ia. ");
INSERT INTO ksd_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Koko avat a vana kan ra matakilalat i ra pal na varbarat, kan avat a mat; tago ra dangi na varku kai ra Luluai i ki ta vavat. Ma dia ga pait ia da ra tinata kai Moses. ");
INSERT INTO ksd_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Ma ra Luluai i ga biti tai Aron dari: ");
INSERT INTO ksd_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Ba avat ma ra umana natum ava ruk ta ra pal na varbarat, koko avat a mome ta polo na vuai na vain ba ta tava longlong, kan avat a mat; go na tur ure ra vartuluai ta ra umana taun tarai; ");
INSERT INTO ksd_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","upi avat a tibe varbaiane ra magit i gomgom kan ra magit vakuku, ma ra magit i gomgom kan ra magit i dur, ");
INSERT INTO ksd_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","upi avat a tovo ra tarai Israel ure ra lavur vartuluai nina ba ra Luluai i ga tatike ta diat ma ra ngie i Moses. ");
INSERT INTO ksd_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Ma Moses i ga biti tai Aron ma tai ra ura natuna dir laun valili Eleaser ma Itamar: Amutal a tak pa ra tinabar na vuai na uma, nina i ki valili kan ra lavur tinabar di tun ia ta ra iap ure ra Luluai, ma amutal a en ia ma koko ra leven tana, ta ra paparai ra uguugu na vartabar; ia ra magit i gomgom kakit, ");
INSERT INTO ksd_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","ma amutal a en ia ta ra pakana gunan i gomgom; tago ia ra tiniba amumutal ma ra ura natum ta ra lavur tinabar di tun ia ta ra iap ure ra Luluai, tago di ga vartuluai damana. ");
INSERT INTO ksd_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Ma ra bongobongo di tultulue ma ra kelakelegi avat a en ia ta ra pakana gunan i gomgom, avat ma ra umana natum, ra umana tutana ma ra umana vavina, tago di tul tar ia ure kaum tiniba ma ra tiniba kai ra umana natum, ta ra lavur tinabar na varmaram kai ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","A kelakelegi ma ra bongobongo di tultulue diat a kap ia varurung ma ra bira di tun ia ta ra iap, upi da tulue, a tinabar na tutuluai ta ra luaina mata i ra Luluai; a tiniba kavavat ma ra umana natum pa na mutu; da ra Luluai i ga vartuluai tana. ");
INSERT INTO ksd_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Ma Moses i ga tikatikan upi ra me ure ra tinabar na varporong, ma ea, di tar tun vue; ma i ga kankanuane Eleaser ma Itamar, ra ura natu i Aron nina dir laun valili, ma i biti: ");
INSERT INTO ksd_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Ta ra ava pa ava ga en ra tinabar na varporong aina ta ra gomgom na pal, tago ia ra magit i gomgom kakit, ma di ga tul tar ia ta vavat upi na pun vue ra varpiam kai ra tarai, upi da pait ra varporong ure diat ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Ma pa di ga kap ra gapuna ta ra bala na pal i gomgom; gala na boina gala ava ga en ia ta ra bala na pal i gomgom, da iau ga kure. ");
INSERT INTO ksd_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Ma Aron i ga biti tai Moses: Ea, dia ga tul tar kadia tinabar na varporong ma kadia tinabar di tuntun tar ia ta ra luaina mata i ra Luluai, ma ra kaina magit dari i tar tadav iau. Gala iau ga en ra tinabar na varporong ta go ra bung, dave, na ga boina ta ra luaina mata i ra Luluai? ");
INSERT INTO ksd_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Ma ba Moses i ga valongore, i ga boina ka ta ra luaina matana. ");
INSERT INTO ksd_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Ma ra Luluai i ga tata pire Moses ma Aron, ma i biti ta dir: ");
INSERT INTO ksd_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Amur a tata pire ra tarai Israel dari: Avat a en go iat ra umana vavaguai ta diat dia laun ta ra rakarakan a gunagunan. ");
INSERT INTO ksd_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Nina ra pal a kauna a ura kaka tana, ma nina i nganga mule ra magit i ga en value, ta ra lavur vavaguai, avat a en nam. ");
INSERT INTO ksd_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Ia kaka, ta diat nina dia nganga. mule ra magit dia ga en value, ma ta diat nina ra pal a kau i diat a ura kaka tana, koko avat a en go diat: ra kamel, tago i nganga mule ra magit i ga en value ma ra kauna vakir a ura kaka tana, na tabu pire vavat. ");
INSERT INTO ksd_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Ma ra rabit, tago i nganga mule ra magit i ga en value ma ra kauna vakir a ura kaka tana, na tabu pire vavat. ");
INSERT INTO ksd_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Ma ra er, tago i nganga mule ra magit i ga en value ma ra kauna vakir a ura kaka tana, na tabu pire vavat. ");
INSERT INTO ksd_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Ma ra boroi, tago ra kauna a ura kaka tana, ma vakir i nganga mule ra magit i ga en value, na tabu pire vavat. ");
INSERT INTO ksd_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Koko avat a en ra vio i diat, ma koko avat a bili ra virua i diat; dia tabu pire vavat. ");
INSERT INTO ksd_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Ma ta ra lavur magit dia laun ta ra ta ba ta ra tava, avat a en diat nina dia vung ra bete i diat ma ra vulegi diat. ");
INSERT INTO ksd_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Ma ra lavur mangana ba pa ta bete i diat ma pa ta vulegi diat, ta diat dia peal ta ra polo, ba dia laun ta ra ta, dia milmilikuan pire vavat, ");
INSERT INTO ksd_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","diat a milmilikuan pire vavat; koko avat a en ra vio i diat, ma avat a milikuane ra virua i diat. ");
INSERT INTO ksd_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Nina ba pa ta betene ma pa ta vulegina ta ra tava, a magit na milmilikuan nam pire vavat. ");
INSERT INTO ksd_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Ma ta ra lavur beo avat a milikuane go diat, koko avat a en diat, dia da ra magit i bilak: a minigulai ma ra luar ma ra taragau; ");
INSERT INTO ksd_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ma ra vultiur, ma ra daula; ");
INSERT INTO ksd_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","a lavur mangana kotkot, ");
INSERT INTO ksd_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","a murup, ma ra kau, ma ra kanai, ma ra kavivi, ");
INSERT INTO ksd_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","a kurkur ma ra komorant ma ra kakaula; ");
INSERT INTO ksd_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ma ra kakaula i karabele, ma ra pelikan, ma ra luar i en ra virua; ");
INSERT INTO ksd_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ma ra mou, ma ra iai ma ra vianau ma ra ganau. ");
INSERT INTO ksd_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Ma ra lavur mangana dia vung ra bebea i diat ma dia kakakao diat a milmilikuan pire vavat. ");
INSERT INTO ksd_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Ia kaka, ta ra lavur mangana dia kakakao ma dia vung ra bebea i diat ma dia pipil ma ra kak i diat, ");
INSERT INTO ksd_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","avat a en go diat: a lavur mangana kubau, ma ra lavur mangana tititinga, ma ra lavur mangana itit, ma ra lavur mangana tabuta. ");
INSERT INTO ksd_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ma ra lavur mangana dia vung ra bebea i diat ma dia vung ra ivat na kau i diat, dia milmilikuan pire vavat. ");
INSERT INTO ksd_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Go diat diat a vadur avat; nina i bili ra virua i diat pa na gomgom tuk na ravian; ");
INSERT INTO ksd_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","ma nina i puak ra virua i diat na puk kana umana mal ma pa na gomgom tuk na ravian. ");
INSERT INTO ksd_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Ra lavur vavaguai i tapelegi ra kau i diat ma vakir a ura kaka tana ma pa dia nganga mule ra magit dia ga en value dia tabu pire vavat, ma nina i bili diat na dur. ");
INSERT INTO ksd_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Ta ra lavur vavaguai dia vanavana ma ra ivat na kak i diat, diat dia vanavana ma ra ivat na lapar a kak i diat, dia tabu pire vavat; nina ba i bili ra virua i diat pa na gomgom tuk na ravian. ");
INSERT INTO ksd_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Nina i puak ra virua i diat na puk kana umana mal, ma pa na gomgom tuk na ravian; dia tabu pire vavat. ");
INSERT INTO ksd_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Ta ra lavur magit dia kakakao ta ra rakarakan a gunagunan, go diat dia tabu pire vavat: a girau, ma ra galang, ma ra lavur mangana palai dia ngala, ");
INSERT INTO ksd_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ma ra kupkup, ma ra galiur, ma ra kekeu, ma ra kuku, ma ra kuku valira. ");
INSERT INTO ksd_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Go diat dia tabu pire vavat ta ra lavur magit dia kakakao; nina i bili diat ba dia mat pa na gomgom tuk na ravian. ");
INSERT INTO ksd_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Ma gala ra minat i tikai ta diat i bura taun ta magit, nam ra magit pa na gomgom, ta magit di pait ia ma ra davai, ta mal, ta pal i ta magit, ba ta kakakap, ba ta la ure ra papalum, da vung ia ta ra tava; pa na gomgom tuk na ravian, ma namur na gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Ma gala ra minat i ta tikai ta diat i bura ta ra bala na la na pia, pa na gomgom; avat a pamar gigi ia, ma ra magit i ki tana pa na gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","A nian parika nina ba ra tava i ki tana pa na gomgom, ma ra nimomo ta ra mangana la damana pa na gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Ma ra lavur magit parika nina ba ta pakana ta ra minat i diat i bura taun diat pa na gomgom; ta ubu, ba ta kabala, da pamar gigi ia; pa dia gomgom, ma diat a tabu pire vavat. ");
INSERT INTO ksd_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ia kaka ta mata na tava ba ta tung na tava nina ba a tava i ki tana na gomgom, ma ra magit nina i bili ra minatina tana pa na gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Ma gala ra minat i diat i bura taun ra umana patina upi ra vinauma, ra patina na gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ma gala ra minat i diat dia bura taun ra umana patina nina di ga vamola ta ra tava, na tabu pire vavat. ");
INSERT INTO ksd_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Ma gala tika na vavaguai nina ba i topa ra nian i mat, nina i bili ra minatina pa na gomgom tuk na ravian; ");
INSERT INTO ksd_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","nina i ian ta ra minatina na puk kana umana mal, ma pa na gomgom tuk na ravian; ma nina i puak ra minatina na puk kana umana mal, ma pa na gomgom tuk na ravian. ");
INSERT INTO ksd_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Ma ra lavur magit par nina dia kakakao ta ra rakarakan a gunagunan, ia ra magit na milmilikuan, i tabu ba da en ia. ");
INSERT INTO ksd_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Nina ba i kakakao ma ra balana ara ra pia, ba i vana ma ra ivat na kakene, ba nina i peal ra umana kakene, ra lavur magit dia kakakao ta ra rakarakan a gunagunan i tabu ba avat a en diat, tago diat ra magit i milmilikuan. ");
INSERT INTO ksd_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Koko avat a vabilak avat ma ra umana magit dia kakakao, ma koko avat a vadur avat ma diat, upi avat a vabilak avat i tana. ");
INSERT INTO ksd_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Tago iau ra Luluai kavava God; damana avat a vagomgom mule avat, ma avat a gomgom; tago iau tar gomgom; koko avat a vabilak mule avat ma ta mangana magit i kakakao ta ra rakarakan a gunagunan. ");
INSERT INTO ksd_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Tago iau ra Luluai nina iat i ga agure vairop avat kan ra gunan Aigipto, upi avat a nunure ba iau kavava God; damana avat a gomgom, tago iau tar gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Go iat ra varkurai ure ra lavur vavaguai ma ra lavur beo ma ra lavur mangana i laun ma i peal ta ra tava, ma ra lavur mangana i kakao ta ra rakarakan a gunagunan, ");
INSERT INTO ksd_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","upi da tibe varbaiane ra magit i dur kan ra magit i gomgom, ma upi da tibe varbaiane ra magit di en ia kan ra magit nina pa di en ia, ta ra lavur magit dia laun. ");
INSERT INTO ksd_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Ma ra Luluai i ga tata pire Moses, ma i ga biti: ");
INSERT INTO ksd_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Una tata pire ra tarai Israel, dari: Gala ta vavina i kap bala ma i kava vue ta bul tutana, pa na gomgom ta lavurua na bung; pa na gomgom da kana umana bung na gai. ");
INSERT INTO ksd_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Ma ta ra valavutuluna bung da poko kikil ra pal i ra bul. ");
INSERT INTO ksd_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Ma ra vavina na ki ta ra kubana ure ra utul a vinun ma utul a bung upi ra gapuna na gomgom; pa na bili ta magit i gomgom, ma pa na ruk ta ra gomgom na pal tuk na par kana umana bung na varvagomgom. ");
INSERT INTO ksd_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Gala i kava ta bul vavina, pa na gomgom ta ra ura vik da kana umana bung na gai; na ki ta ra kubana ure laptikai na vinun ma laptikai na bung upi ra gapuna na gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Ma ba na par kana umana bung na varvagomgom ure ta bul tutana ba ta bul vavina na kap ta nat na sip, i kopono ko kana kilala, ure ra tinabar di tuntun tar ia, ma ta nat na balu ba ta uka, ure ra tinabar na varporong, tar ta ra matakilalat i ra pal na varbarat, tadav ra tena tinabar, ");
INSERT INTO ksd_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","ma na kap ia ta ra luaina mata i ra Luluai, ma na pait ra varporong ure, ma na gomgom ure ra e ba i ga gapgap tana. Go iat ra varkurai ure nina i kava ta bul tutana ba ta bul vavina. ");
INSERT INTO ksd_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Ona pa i tale pi na tul tar ta nat na sip, na kap ta ivu uka, ba ta ivu nat na balu, ta tikai ure ra tinabar di tuntun tar ia, ma ta ra tikai ure ra tinabar na varporong; ma ra tena tinabar na pait ra varporong ure, ma na gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Ma ra Luluai i ga tata pire Moses ma Aron ma i biti: ");
INSERT INTO ksd_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Ba ra pal i ra paka i ta tutana i buk, ba i tuktuk, ba i babale, ma ia ra vakilang ure ra vukavuka, da ben ia tadav Aron ra tena tinabar, ba tadav tika na natuna, a tena tinabar; ");
INSERT INTO ksd_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","ra tena tinabar na gire ra vakilang ta ra pal a paka i ra tutana; ma ona ra ivuna tana i pua, ma ra vakilang iat i kamen ta ra viono, ia ra minait na vukavuka: ra tena tinabar na bobe, ma na vatang ia ba pa i gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Ma ona ra pakana i babale i mada, ma ra vakilang iat pa i kamen ta ra viono, ma ra ivuna tana pa i ga pua, ra tena tinabar na vung vaire boko ta lavurua na bung, ");
INSERT INTO ksd_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ma ta ra valavuruana bung na gire, ma ona i gire ba ra minait i tur, ma pa i kakao ta ra pal i ra pakana, na vung vaire mule ta lavurua na bung, ");
INSERT INTO ksd_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","ma ta ra valavuruana bung na gire mule, ma ona ra vakilang i to na panie ma ra minait pa i ga kakao ta ra pal i ra pakana, ra tena tinabar na vatang ia ba i gomgom, a pal a korong ika; ma ra tutana na puk kana umana mal, ma na gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ma ona ra pal a korong i kakao vanavana ta ra pal i ra pakana namur ta nam ba i ga vaarike pire ra tena tinabar upi na gomgom, na vana tadav ra tena tinabar mulai; ");
INSERT INTO ksd_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ra tena tinabar na gire, ma ona ra pal a korong i tar kakao ta ra pal i ra pakana, ra tena tinabar na vatang ia ba pa i gomgom, a vukavuka iat. ");
INSERT INTO ksd_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Ba ra vakilang na vukavuka i ki ta ra tutana, da kap ia pire ra tena tinabar; ");
INSERT INTO ksd_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","ma ra tena tinabar na gire, ma ona ta pakana i bulbuliran i pua ta ra pal i ra pakana, ma ra ivuna i pua tana, ma i manua mut, ");
INSERT INTO ksd_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ia ra vukavuka pa ania ma ra tena tinabar na vatang ia ba pa i gomgom; pa na vung vaire vue, tago nam iat pa i gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Ona ra vukavuka i kakao vanavana ta ra pal i ra pakana, ma i pulu vapar nina i vukavuka papa ta ra uluna tuk ta ra pal a kauna, da ra tena tinabar i gire; ");
INSERT INTO ksd_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ra tena tinabar na gire ilam ia, ma ona ra pal i ra pakana i vukavuka par, na vatang nina ba i tar vukavuka ba i gomgom, ra pal i ra pakana i pua parika, i gomgom iat. ");
INSERT INTO ksd_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ma ona ra manua i. arikai tana, pa na gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Ba ra tena tinabar i gire ra manua na vatang ra tutana ba pa i gomgom, ra manua pa i gomgom ia ra vakilang na vukavuka. ");
INSERT INTO ksd_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ma ona ra manua na pua mulai, ra tutana na vana tadav ra tena tinabar, ");
INSERT INTO ksd_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ma ona ra tena tinabar i gire ba ra vakilang i tar pua, na vatang ra tutana nina i mait ba i gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Ba ta buk ta ra pal i ra pakana i map, ");
INSERT INTO ksd_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ma ta bulbuliran i pua i ki boko, ba ta vakilang meme, ra tutana na vaarike pire ra tena tinabar, ");
INSERT INTO ksd_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","ma ra tena tinabar na gire, ma ona ra vakilang i da i kamen ta ra viono, ma ra ivuna tana i pua, ra tena tinabar na vatang ia ba pa i gomgom; ia ra minait na vukavuka nina i arikai ta ra niung. ");
INSERT INTO ksd_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ma ona ra tena tinabar pa i gire ta ivuna i pua ta ra vakilang, ma ra vakilang pa i kamen ta ra viono, ma i to na panie, ra tena tinabar na vung vaire pa ta lavurua na bung; ");
INSERT INTO ksd_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","ona i kakakao vanavana ta ra pal i ra pakana, ra tena tinabar na vatang ia ba pa i gomgom, ia ra vakilang na vukavuka; ");
INSERT INTO ksd_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","ma ona ra vakilang i meme i tur uka, ma pa i kakao vanavana, ia ra mada i ra niung, ma ra tena tinabar na vatang ra tutana ba i gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Ma ona ra pal i ra pakana i ga dodo, ma ra vakilang i ra manua i ga meme ba i ga pua, ");
INSERT INTO ksd_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ra tena tinabar na gire; ona ra ivuna tana i tar pua, ma i da i kamen ta ra viono, ia ra vukavuka nina i tar arikai ka ta ra nidodo, ma ra tena tinabar na vatang ia ba pa i gomgom, ia ra vakilang na vukavuka; ");
INSERT INTO ksd_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","ma ona ra tena tinabar i gire ba pa ta ivuna i pua ta ra vakilang i meme ma pa i da i kamen ta ra viono, ma i to na panie, ra tena tinabar na vung vaire pa ta lavurua na bung; ");
INSERT INTO ksd_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ta ra valavuruana bung na gire mule; ma ona i tar kakao ta ra pal i ra pakana, ra tena tinabar na vatang ia ba pa i gomgom, ia ra vakilang na vukavuka. ");
INSERT INTO ksd_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ma ona ra vakilang i meme i tur uka, ma pa i kakao vanavana, ma i to na panie, ia ra bulbuliran i vuna ta ra nidodo, ma ra tena tinabar na vatang ia ba i gomgom. Ia ra mada na nidodo ko. ");
INSERT INTO ksd_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Ba ta tutana ba ta vavina i manua ra uluna ba ra kabene, ");
INSERT INTO ksd_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ra tena tinabar na gire; ma ona i kamen ta ra viono, ma ta kopono ivuna i gobol tana, ra tena tinabar na vatang ia ba pa i gomgom, ia ra kaka, a vukavuka na ip ba a kabe. ");
INSERT INTO ksd_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Ma ona ra tena tinabar i gire ba ra kaka pa i kamen ta ra viono, ma pa ta korong na ivuna tana, ra tena tinabar na vung vaire nina i mait ure lavurua na bung. ");
INSERT INTO ksd_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Ta ra valavuruana bung ra tena tinabar na gire ra minait na kaka, ma ona ra kaka pa i ga kakao, ma pa ta ivuna i gobol tana, ma ra kaka pa i kamen ta ra Viono, ");
INSERT INTO ksd_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","da ka vue ra pepe na uluna ma ra kabene, ia kaka ra pakana nina i kaka, koko; ma ra tena tinabar na vung vaire mule ure lavurua na bung. ");
INSERT INTO ksd_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Ta ra valavuruana bung ra tena tinabar na gire mule, ma ona ra kaka pa i ga kakao ta ra pal i ra pakana, ma ona pa i kamen ta ra viono, ra tena tinabar na vatang ia ba i gomgom; na puk kana umana mal, ma na gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Ma ona ra kaka i kakao ta ra pal i ra pakana namur ba di ga vatang ia ba i gomgom, ");
INSERT INTO ksd_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ra tena tinabar na gire; ma ona ra kaka i tar kakao, ra tena tinabar pa na gire upi ta ivuna i gobol; ra tutana pa i gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ma ona ra kaka i tur da di ga gire lua ma ra ivuna i korong tana, ra kaka i boina, ra tutana i gomgom; ma ra tena tinabar na vatang ia ba i gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Ba ta umana vakilang dia pua dia arikai ta ra pal i ra paka i ta tutana ba ta vavina, ");
INSERT INTO ksd_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ra tena tinabar na gire, ma ona ra umana vakilang dia kabu, a tuktuk uka nina i arikai ta ra pal i ra pakana; i tar gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Ba ra pepe na ulu i ra tutana i panie parika, i peaka ka, ma i gomgom, ");
INSERT INTO ksd_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Ona ra pepe na uluna i panie kan ra tur lua na ula, io, i peaka ra tur lua na uluna, i gomgom uka. ");
INSERT INTO ksd_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ma ona ta vakilang i meme ta ra ula i peaka, ba ra tur lua na ula i peaka, ia ra vukavuka i arikai ta ra uluna i peaka ba ra tur lua na uluna i peaka. ");
INSERT INTO ksd_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Ra tena tinabar na gire ma ona ra bulbuliran ta ra uluna i peaka, ba ra tur lua na uluna i peaka, i meme da ra vukavuka ta ra pal i ra pakana, ");
INSERT INTO ksd_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ia ra tutana i vukavuka: ra tena tinabar na vatang ia ba pa i gomgom, ma ra vakilangina tana i ki ta ra uluna. ");
INSERT INTO ksd_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Ma ra tutana i vukavuka na rada kana mal, ma ra pepe na uluna na purpuruan, na tuba ra livuruna ma na oraoro, A duruna. ");
INSERT INTO ksd_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Ta ra lavur bungbung ba ra minait i ki pirana pa na gomgom; ia ra duruna ka; na ki varkolono ta ra papar a gunan irai. ");
INSERT INTO ksd_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Ra mal nina ra minait i ki tana, ta mal na ivuna sip ba ta mal kumau, ");
INSERT INTO ksd_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","nina di ga vir ia ba di ga ingit ia, ba ta pal i ra vavaguai ba ta magit di ga pait ia ma ra pal i ra vavaguai: ");
INSERT INTO ksd_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ona ra vakilang ta ra mal, ba ta ra pal i ra vavaguai, ba ta ra magit di vir ia, ba di ingit ia, i papait na limut ba i papait na meme, ia ra vakilang na minait ma da vung ve tar ia ta ra tena tinabar. ");
INSERT INTO ksd_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Ra tena tinabar na gire, ma na vung vaire vue ure ra lavurua na bung; ");
INSERT INTO ksd_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ta ra valavuruana bung na gire mule, ma ona ra vakilang i ga kakao vanavana ta ra mal di ga vir ia ba di ga ingit ia, ba ta ra magit par di ga pait ia ma ra pal i ra vavaguai, ia ra vakilang na minait ma ra magit pa i gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Na tun ra magit ra vakilang i tur tana, a mal di ga vir ia ba di ga ingit ia, a mal na ivuna sip ba ra mal kumau ba ta magit di ga pait ia ma ra pal i ra vavaguai: ia ra minait i dekdek, da tun ia ta ra iap. ");
INSERT INTO ksd_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Ma ba ra tena tinabar i gire, ma ra vakilang pa i ga kakao ta ra mal di ga vir ia, ba di ga ingit ia, ba ta ra magit di ga pait ia ma ra pal i ra vavaguai, ");
INSERT INTO ksd_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ra tena tinabar na kure ba da puk ra magit, nina ba ra minait i ki tana, ma da vung vaire pa ta lavurua na bung boko; ");
INSERT INTO ksd_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ma ra tena tinabar na gire ra magit di ga puk ia, ma ona ra vakilang tana pa i enana, ma i dovot pa i ga kakao vanavana, pa i gomgom, da tun ia ba ra vakilang i ki ta ra balana ba ta ra paparaina. ");
INSERT INTO ksd_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Ma ona ra tena tinabar i gire ba ra vakilang i panie vanavana tago di ga puk ia, na rada vue ra vakilang kan ra mal di vir ia ba di ingit ia ba kan ra pal i ra vavaguai; ");
INSERT INTO ksd_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ona i arikai mulai ta ra mal di vir ia, ba di ingit ia, ba ta ra magit di ga pait ia ma ra pal i ra vavaguai, i tavua mulai, ma una tun ra magit ra vakilang i ki tana. ");
INSERT INTO ksd_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Una puk mule ra mal di vir ia ba di ingit ia, ba ra pal i ra vavaguai, nina ba ra vakilang i ga panie kan ia, ma na gomgom nagam. ");
INSERT INTO ksd_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Go iat ra varkurai ure ra minait ta ra mal na ivuna sip ba ra mal kumau, a mal di vir ia, ba ra mal di ingit ia, ba ra magit di ga pait ia ma ra pal i ra vavaguai, upi da nunure ra magit i gomgom, ma ra magit nina pa i gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Ma ra Luluai i ga tata pire Moses, ma i biti: ");
INSERT INTO ksd_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Go iat ra varkurai ure ra vukavuka ta ra bung i gomgom tana: da ben pa ia pire ra tena tinabar, ");
INSERT INTO ksd_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ma ra tena tinabar, nina i ga tar vana ta ra papar a gunan irai, na gire ba ra vakilang i ra vukavuka i par kan ra vukavuka; ");
INSERT INTO ksd_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","namur ra tena tinabar na vartuluai upi ta ivu beo, a ivu launa nina dir gomgom, ma ra davai na tagatagal, ma ta isop di vi ia ma ra kuara i meme, ure nina ra tutana ba da vagomgom ia. ");
INSERT INTO ksd_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","A tena tinabar na vartuluai ba da doko tika na beo taun ta la na pia nina ba ra gomgom na tava i ki tana. ");
INSERT INTO ksd_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Na tak pa ra beo i laun varurung ma ra davai na tagatagal ma ra isop di vi ia ma ra kuara i meme, ma na puk vadudu diat ta ra gapu i ra beo, nina di ga doka taun ra gomgom na tava. ");
INSERT INTO ksd_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Nina ra tutana ba da vagomgom ia kan ra vukavuka a tena tinabar na apur ia ma ra gap lavurua na pakana, ma na vatang ia ba i gomgom, ma ra beo nina i laun na pala vue upi na pururung irai aro ta ra bala na vura. ");
INSERT INTO ksd_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Ma nina ba da vagomgom ia na puk kana umana mal, ma na ka vapar vue ra tagal a uluna ma na gumu ta ra tava, ma na gomgom. Namur na ruk ta ra gunan, ia kaka na ki ka ta ra luaina mata i kana pal na mal ure lavurua na bung. ");
INSERT INTO ksd_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Ma ta ra valavuruana bung na ka vapar vue ra pepe na uluna ma ra kabene, ma ra ivuna ta ra ul a matana, ma na puk kana umana mal, ma na gumu ta ra tava upi na gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Ta ra valavutuluna bung na kap pa ra ivu nat na sip, ra ivu tomotoina dir ko kakit, ma tika na nat na sip, a tana i kopono ko kana kilala ma i ko kakit, ma tika na vautuluna ta ra epa na bo na plaua, nina di pota ma ra dangi ma tika na la na dangi ik. ");
INSERT INTO ksd_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Ra tena tinabar nina i pait ra varvagomgom na kap go diat varurung ma ra tutana, nina ba da vagomgom ia, tar ta ra matakilalat i ra pal na varbarat ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Ma ra tena tinabar na tak pa tika na sip ta ra ivu tomotoina, ma na tul tar ia ure ra tinabar na nirara, ma ra la na dangi ik; na tulue dir upi ra tinabar na tutuluai ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Na doko ra nat na sip, ra tomotoina, ta ra pakana di doko ra tinabar na varporong ma ra tinabar di tuntun tar ia tana, ta ra bala na gunan ai ra gomgom na pal; tago ra tinabar na nirara ia ra tiniba kai ra tena tinabar da ra tinabar na varporong ia kana tiniba; ia ra magit i gomgom kakit. ");
INSERT INTO ksd_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Ma na tak pa ta gapu i ra tinabar na nirara ma ra tena tinabar na kolo ra ngu na talinga i nina ba da vagomgom ia ta ra papar a lima tuna tana, ma ra kaka ngala ta ra limana tuna, ma ra kaka ngala ta ra kauna ta ra papar a lima tuna tana; ");
INSERT INTO ksd_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","ma ra tena tinabar na tak pa ra la na dangi ik ma na lolonge ta ra lapar a limana ta ra maira, ");
INSERT INTO ksd_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ma na vadudu ra kaka na limana tuna ta ra dangi nina i ki ta ra lapar a limana, ma na pikire ra dangi lavurua na pakana ta ra luaina mata i ra Luluai; ");
INSERT INTO ksd_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ma ra tena tinabar na tak pa ra dangi nina i ki valili ta ra bala na lapar ma na kolo ra ngu na talinga i nina ba da vagomgom ia ta ra papar a lima tuna, ma ra kaka ngala ta ra limana tuna, ma ra kaka ngala ta ra kauna ta ra papar a lima tuna, taun ra gapu i ra tinabar na nirara; ");
INSERT INTO ksd_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","ma na ku ra ulu i nina ba da vagomgom ia ma ra ibaiba ta ra dangi nina i ki ta ra bala na lapar a limana; damana ra tena tinabar na pait ra varporong ure ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Ma ra tena tinabar na tul tar ra tinabar na varporong, ma na pait ra varporong ure nina ba da vagomgom ia, tago pa i gomgom; ma namur na doko ra tinabar di tuntun tar ia; ");
INSERT INTO ksd_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ma ra tena tinabar na tul tar ra tinabar di tuntun tar ia, ma ra tinabar na vuai na uma, ta ra uguugu na vartabar; ma ra tena tinabar na pait ra varporong ure, ma na gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Ona pa i tale pi na tul tar ta ngala dari, na kap pa tika na nat na sip, a tomotoina, ure ra tinabar na nirara, upi da tulue, upi da pait ra varporong ure, ma tika na vavinununa ta ra epa na bo na plaua ma ra dangi tana ure ra tinabar na vuai na uma ma tika na la na dangi ik; ");
INSERT INTO ksd_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","na kap bula ra ivu uka ba ra ivu nat na balu, nina ba na tale pi na kul ia; tikai ta dir ure ra tinabar na varporong ma ta ra tikai ure ra tinabar di tuntun tar ia. ");
INSERT INTO ksd_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Na kap go diat ta ra valavutuluna bung tadav ra tena tinabar ure kana varvagomgom, na kap diat tar ta ra matakilalat i ra pal na varbarat ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Ra tena tinabar na tak pa ra nat na sip ure ra tinabar na nirara ma ra la na dangi ik ma na tulue dir ure ra tinabar na tutuluai ta ra luaina mata i ra Luluai; ");
INSERT INTO ksd_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ma namur ra tena tinabar na doko ra nat na sip ure ra tinabar na nirara, ma na tak pa ra gapu i ra tinabar na nirara ma na kolo ra ngu na talinga i nina ba da vagomgom ia ta ra papar a lima tuna tana, ma ra kaka ngala ta ra limana tuna, ma ra kaka ngala ta ra kauna ta ra papar a lima tuna tana; ");
INSERT INTO ksd_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ma ra tena tinabar na tak pa ra la na dangi ik ma na lolonge ta ik tana ta ra lapar a limana ta ra maira, ");
INSERT INTO ksd_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ma na pikire ma ra kaka na limana tuna ta ik ta ra dangi nina i ki ta ra lapar a limana lavurua na pakana ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Ma ra tena tinabar na tak pa ra dangi i ki boko ta ra limana ma na kolo ra ngu na talinga i nina ba da vagomgom ia ta ra papar a lima tuna, ma ra kaka ngala ta ra limana tuna, ma ra kaka ngala ta ra kauna ta ra papar a lima tuna, taun ra gapu i ra tinabar na nirara, ");
INSERT INTO ksd_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","ma na ku ra ulu i nina ba da vagomgom ia ma ra dangi i ki valili boko ta ra lapar a limana, upi da pait ra varporong ure ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Na tul tar tikai ta ra ivu uka, ba ra ivu nat na balu, nina i tale ra tutana ba na kul ia; ");
INSERT INTO ksd_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ta tikai ure ra tinabar na varporong, ma ta ra tikai ure ra tinabar di tuntun tar ia varurung ma ra tinabar na vuai na uma; ma ra tena tinabar na pait ra varporong ure nina ba da vagomgom ia ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Go iat ra varkurai ure nina i vukavuka, ma pa i tale pi na kul nam di vartuluai ure ta kana varvagomgom. ");
INSERT INTO ksd_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Ma ra Luluai i ga tata pire Moses ma Aron, ma i biti: ");
INSERT INTO ksd_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Ba ava olo ra gunan Kanaan nina ba ina tul tar ia pi avat a kale upi kavavat, ma ina vung ra vakilang na kaina minait tai ta papar a pal ta ra gunan ava kale pa ia; ");
INSERT INTO ksd_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","nina ba kana ra pal na vana ma na ve ra tena tinabar dari: Iau nuk ia ba ta vakilang na minait i ki na pal; ");
INSERT INTO ksd_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","ba ra tena tinabar pa i ruk boko na pal upi na gire ra vakilang, na vartuluai ba da vairop vapar vue ra lavur magit par tana upi koko da vadur ra lavur magit par tana; ra tena tinabar na ruk ma na gire kukure muka ra pal ba i dave. ");
INSERT INTO ksd_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Na gire ra vakilang, ma ona ra vakilang i papait na limut, ba i papait na meme, ma i da i ruk muka ta ra kabang, ");
INSERT INTO ksd_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ra tena tinabar na irop kan ra pal, ma na banu bat ra pal ure lavurua na bung. ");
INSERT INTO ksd_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Ta ra valavuruana bung ra tena tinabar na lilikun mulai, ma na gire kukure ra pal ma ona ra vakilang i ga tar kakao ta ra papar a pal, ");
INSERT INTO ksd_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ra tena tinabar na vartuluai ba da tak vue ra umana vat nina ba ra vakilang i ki tana, ma na vue vapar diat ta ra pakana nina ba pa i gomgom, ta ra papar a gunan irai; ");
INSERT INTO ksd_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","na kure ba da ka ra bala na pal parika ma ra kabang nina ba di ga ka vue, da vung ia tai ta pakana nina ba pa i gomgom ta ra papar a gunan irai; ");
INSERT INTO ksd_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","ma diat a kap pa ra umana kalamana vat upi diat a kia vue nam ra umana maulana me, ma diat a kap ra kalamana kabang, ma diat a kolo ra pal me. ");
INSERT INTO ksd_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Ma ba di ga tar tak vue nam ra umana vat, ma di ga tar ka ra pal, ma di ga tar kola ma ra kabang, ona ra vakilang na arikai mulai ta ra pal, ");
INSERT INTO ksd_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ra tena tinabar na ruk ma na gire kukure ra pal; gala ra vakilang i ga tar kakao vanavana, ia ra dekdek na minait i ki ta ra pal, ma ra pal pa i gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Ra tena tinabar na vartuluai ba da re vue ra pal, ma diat a tak vue ra umana vat tana ma ra davai tana, ma ra kabang par ta ra pal, ma diat a kap vue diat tar ta ra pakana nina ba pa i gomgom, ta ra papar a gunan irai. ");
INSERT INTO ksd_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Ma nina i ruk na pal ba di banu bat ia, pa na gomgom tuk na ravian; ");
INSERT INTO ksd_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","nina i va ta ra pal na puk kana umana mal, ma nina i ian ta ra pal na puk kana umana mal. ");
INSERT INTO ksd_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Ba di tar kolo ra pal ma ra kabang, ma ra tena tinabar i ruk tana, ma i gire ba ra vakilang pa i ga kakao vanavana, ra tena tinabar na vatang ra pal ba i gomgom, tago ra vakilang i ga tar panie. ");
INSERT INTO ksd_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Na pait ra varvagomgom ure ra pal dari. na tak pa ra ivu beo ma ra davai na tagatagal, ma ra isop di vi ia ma ra kuara i meme; ");
INSERT INTO ksd_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","na doko tika na beo taun ta la na pia, nina ba ra gomgom na tava i ki tana; ");
INSERT INTO ksd_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","na tak pa ra davai na tagatagal ma ra isop nina di vi ia ma ra kuara i meme ma ra beo nina i laun, ma na puk vadudu diat ta ra gapu i ra beo di ga doka, ma ra tava, ma na apur ra pal me lavurua na pakana; ");
INSERT INTO ksd_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","ma na vagomgom ra pal ma ra gapu i ra beo ma ra tava, ma ra isop nina di vi ia ma ra kuara i meme; ");
INSERT INTO ksd_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ma ra beo nina i laun, na pala vue upi na pururung irai aro ta ra bala na vura. Damana na pait ra varporong ure ra pal, ma ra pal na gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Go iat ra varkurai ure ra lavur vakilang na vukavuka, ma ra kaka, ");
INSERT INTO ksd_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ma ure ra vakilang i ra minait ta ra mal ma ta ra pal, ");
INSERT INTO ksd_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ma ure ra niung, ma ra pal a korong, ma ra babale; ");
INSERT INTO ksd_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","upi da nunure ra magit i gomgom, ma ra magit nina ba pa i gomgom. Go iat ra varkurai ure ra vukavuka. ");
INSERT INTO ksd_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Ma ra Luluai i ga tata pire Moses ma Aron, ma i biti: ");
INSERT INTO ksd_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Amur a tata pire ra tarai Israel, ma amur a biti ta diat, Gala ta tutana i gapgap ra pal a pakana, pa i gomgom ure nam ra gap. ");
INSERT INTO ksd_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Pa na gomgom ba i gapgap; ba di nur vue ra pakana pi na gap, ba di pulu bat ia upi koko na gap; ra tutana pa i gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","A lavur vava parika nina ba ra tutana i gap i va tana, pa na gomgom, ma ra lavur magit par nina i ki tana, pa na gomgom; ");
INSERT INTO ksd_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","nina i bili ra vava kai nam ra tutana na puk kana umana mal, ma na gumu ta ra tava, ma pa na gomgom tuk na ravian; ");
INSERT INTO ksd_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","ma nina i ki ta ra magit nina ba ra tutana i gap i ga ki tana, na puk kana umana mal, ma na gumu ta ra tava, ma pa na gomgom tuk na ravian. ");
INSERT INTO ksd_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Ma nina i bili ra paka i ra tutana i gap na puk kana umana mal, ma na gumu ta ra tava, ma pa na gomgom tuk na ravian. ");
INSERT INTO ksd_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Ma gala ra tutana i gap i gami ta tutana i gomgom, nina i gomgom na puk kana umana mal, ma na gumu ta ra tava, ma pa na gomgom tuk na ravian. ");
INSERT INTO ksd_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Ta kiki na vinavana nina ba ra tutana i gap i vanavana tana, pa na gomgom; ");
INSERT INTO ksd_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","ma nina i bili ta magit ra tutana i ga ki tana ta kana vinavana, pa na gomgom tuk na ravian; ma nina i puak ta magit damana na puk kana umana mal ma na gumu ta ra tava, ma pa na gomgom tuk na ravian. ");
INSERT INTO ksd_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Ma nina ba ra tutana i gap i bili ia ba pa i gi value ra limana ta ra tava, na puk kana umana mal, ma na gumu ta ra tava, ma pa na gomgom tuk na ravian. ");
INSERT INTO ksd_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ma nina ra la na pia ra tutana i gap i bili ia, da pamar ia, ba gala ta la na davai, da puk ia ma ra tava. ");
INSERT INTO ksd_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Ba ra tutana i gap i gomgom mulai, na luk lavurua na bung papa ra bung i ga gomgom tana, ma na puk kana umana mal, ma na gumu ta ra gomgom na tava, ma na gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Ta ra valavutuluna bung na kap pa ra ivu uka ba ra ivu nat na balu, ma na vana tar ta ra matakilalat i ra pal na varbarat ta ra luaina mata i ra Luluai, ma na tul tar dir pire ra tena tinabar; ");
INSERT INTO ksd_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","ma ra tena tinabar na tul tar dir, tikai ure ra tinabar na varporong, ma ta ra tikai ure ra tinabar di tuntun tar ia, ma damana na pait ra varporong ure ta ra luaina mata i ra Luluai ure ra e i ga gap tana. ");
INSERT INTO ksd_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Ma gala ra gorgor i ra tutana i talingir vakuku, na gumu ta ra tava, ma pa na gomgom tuk na ravian; ");
INSERT INTO ksd_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","ma ra lavur mal ma ra lavur pakana pal i ra vavaguai nina ba i talingir tana, da puk diat ma ra tava, ma pa diat a gomgom tuk na ravian. ");
INSERT INTO ksd_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Ra vavina bula nina ba ra tutana i va pirana ba ra gorgorina i talingir, dir par dir a gumu ta ra tava, ma pa dir a gomgom tuk na ravian. ");
INSERT INTO ksd_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Gala ta vavina i gapgap ta ra gai, na ki irai ure lavurua na bung; nina i bili ia pa na gomgom tuk na ravian. ");
INSERT INTO ksd_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Ra umana magit nina i va tana ba nina i ki tana ba i dari, pa na gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Nina i bili kana vava na puk kana umana mal, ma na gumu ta ra tava, ma pa na gomgom tuk na ravian. ");
INSERT INTO ksd_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Nina i bili ta magit ra vavina i ki tana na puk kana umana mal, ma na gumu ta ra tava, ma pa na gomgom tuk na ravian. ");
INSERT INTO ksd_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Ma gala ta tikai i bili ta magit ta kana vava ba ta magit nina i ki tana, pa na gomgom tuk na ravian. ");
INSERT INTO ksd_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Ma gala ta tutana i va pirana ma ra duruna i tadav ia, pa na gomgom ure lavurua na bung; ma ra vava nina i va tana pa na gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Gala ta vavina i gapgap mangoro na bung, ma vakir ta kana e, ba gala i gapgap ta ra gai ure mangoro na bung, pa na gomgom ta ra lavur bungbung i gapgap tana, da pa i gomgom ba i gapgap ta ra gai. ");
INSERT INTO ksd_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ra umana vava.nina i va tana ta nam ra umana bung ba i gapgap, diat a da kana vava ta ra e i gapgap ta ra gai; ma ra lavur magit i ki tana pa diat a gomgom, diat a da nam diat i ki tana ba i gapgap ta ra gai. ");
INSERT INTO ksd_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ma nina i bili nam ra umana magit pa na gomgom; na puk kana umana mal, ma na gumu ta ra tava, ma pa na gomgom tuk na ravian. ");
INSERT INTO ksd_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Ba i tar par ra gap, na luk lavurua na bung, ma namur na gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Ta ra valavutuluna bung na tak pa ra ivu uka ba ra ivu nat na balu, ma na kap dir pire ra tena tinabar uina ra matakilalat i ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Ma ra tena tinabar na tul tar tikai ta dir ure ra tinabar na varporong, ma ta ra tikai ure ra tinabar di tuntun tar ia; damana ra tena tinabar na pait ra varporong ure, ta ra luaina mata i ra Luluai, ure ra e i ga gapgap tana. ");
INSERT INTO ksd_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Damana amur a varbaiane ra tarai Israel kan ra duru i diat, upi koko diat a virua ure ra duru i diat ba dia vabilak kaugu gomgom na pal nina i ki livuan ta diat. ");
INSERT INTO ksd_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Go iat ra varkurai ure ra tutana nina i gap, ba pa i gomgom ure ra gorgorina; ");
INSERT INTO ksd_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ma ure ra vavina i gapgap ta ra gai, ma ure ra tarai ma ra vaden nina dia gap, ma ure ra tutana nina dir va ma ra vavina ba pa i gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Ma ra Luluai i ga tata pire Moses, namur ta ra minat i nam ra ura natu i Aron nina dir ga mat ba dir ga vana maravai tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Ma ra Luluai i ga biti tai Moses: Una ve turam Aron ba koko na vana vatikai ta ra pakana i gomgom uro namur ta ra mal na rurua kutu, tar ta ra luaina mata i ra tubatuba nina i ki taun ra bok na varvai, upi koko na virua; tago ina tur kapet ta ra gobol a bakut nina i ki taun ra tubatuba. ");
INSERT INTO ksd_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Aron na ruk uka ta ra pakana i gomgom ba i kap ra nat na bulumakau ure ra tinabar na varporong, ma ra sip, a tomotoina, ure ra tinabar di tuntun tar ia. ");
INSERT INTO ksd_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Na ule ra lolovina kolot i gomgom, ma ra mal na tutana ta ra livuana, ma na vi pit ma ra vivi, ma na vung ra mal na rarau ta ra uluna: go diat ra umana gomgom na mal; na gumu ta ra tava ma na ule diat. ");
INSERT INTO ksd_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Na ruk bula ma ra ura me, ra ura tomotoina ure ra tinabar na varporong, ma tika na sip, a tomotoina, ure ra tinabar di tuntun tar ia, nina ba kai ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Ma Aron na tul tar ra bulumakau nina ba kana ure ra tinabar na varporong, upi na pait ra varporong ure ia iat, ma diat ta kana apik na tarai. ");
INSERT INTO ksd_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Na tak pa ra ura me, ma na vatur dir ta ra luaina mata i ra Luluai, uina ta ra matakilalat i ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Ma Aron na pait ra padapadailam ure ra ura me, upi tikai ba kai ra Luluai, ma ta ra tikai ta dir ba kai Asasel. ");
INSERT INTO ksd_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Ma Aron na kap pa nam ra me, nina ba di ga padapadailam pa ia ba kai ra Luluai, ma na tul tar ia upi ra tinabar na varporong. ");
INSERT INTO ksd_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ma ra me nina di ga padapadailam pa ia ba kai Asasel, da tul tar ia, a launa, ta ra luaina mata i ra Luluai, ma ba di ga tar pait ra lotu na varporong taun ia, da pala vue upi na vilau uro ta ra bil upi kai Asasel. ");
INSERT INTO ksd_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Ma Aron na kap pa ra bulumakau ure ra tinabar na varporong, nina ba kana, ma na pait ra varporong ure ia iat ma kana apik na tarai. Na doko ra bulumakau ure ra tinabar na varporong, nina ba ure ia iat, ");
INSERT INTO ksd_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ma na tak pa ra la na mi, nina i buka ma ra lakit i birao kan ra uguugu na vartabar nina i tur ta ra luaina mata i ra Luluai; na vabuka ra ura lapar a limana ma ra bulit i ang na katkat, nina ba di tar gigie, ma na kap ia uro namur ta ra mal na rurua kutu; ");
INSERT INTO ksd_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","na vung ra bulit i ang na katkat ta ra iap nina i birao ta ra luaina mata i ra Luluai, upi ra mi i ang na katkat na pulu ra tubatuba nina i ki taun ra varvai, upi koko na virua. ");
INSERT INTO ksd_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Na tak pa ta gapu i ra bulumakau ma ra kaka na limana ma na pikire ta ra papar a taur ta ra tubatuba, ma na pikire ra gap lavurua na pakana ta ra luaina mata i ra tubatuba. ");
INSERT INTO ksd_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Namur na doko ra me na tinabar na varporong, nina ba kai ra tarai, ma na kap ra gapuna uro ta ra mal na rurua kutu, ma na papait ma ra gapuna da nina i ga pait ia ma ra gapu i ra bulumakau, ma na pikire taun ra tubatuba ma ta ra luaina mata i ra tubatuba bula; ");
INSERT INTO ksd_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","damana na pait ra varporong ure ra pakana i gomgom, a vuna ta ra bilak na mangamangana kai ra tarai Israel, ma kadia lavur varpiam, maia pa, ure kadia lavur varpiam par; na pait ia damana bula ure ra pal na varbarat, nina ba i tur pire diat livuan ta kadia bilak na mangamangana. ");
INSERT INTO ksd_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Koko ta tikai na ki ta ra bala na pal na varbarat ba Aron i ruk pi na pait ra varporong ure ra pakana i gomgom, ma na tuk tar na ga irop mulai, ba i ga tar pait pa ra varporong ure ia iat ma kana apik na tarai ma ra tarai Israel par. ");
INSERT INTO ksd_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Ma namur na irop tar ta ra uguugu ure ra tinabar di tuntun tar ia ta ra luaina mata i ra Luluai, ma na pait ra varporong ure; na tak pa ra gapu i ra bulumakau ma ra gapu i ra me, ma na kolo ra umana ram ta ra uguugu me. ");
INSERT INTO ksd_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Ma na pikire ra gap ma ra kaka na limana lavurua na pakana, ma na vagomgom ia, ma na vatabue kan ra bilak na mangamangana kai ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Ba i tar pait vapar ra varporong ure ra pakana i gomgom, ma ra pal na varbarat, ma ra uguugu, Aron na kap pa ra me nina i laun; ");
INSERT INTO ksd_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","na vung ra ura limana ta ra ulu i ra me i laun ma na tata kapa ure ra lavur mangamangana i gegagege kai ra tarai Israel taun ia, ma ure kadia lavur varpiam, maia pa, ure kadia lavur varpiam par, ma ba i ga tar vung vapar diat taun ra ulu i ra me na tulue ma tika na tutana nina i ki na vavinara ure, uro ta ra bil. ");
INSERT INTO ksd_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Ma ra me na puak vapar vue kadia lavur mangamangana dia gegagege uro ta ra gunan i lingling: ma ra tutana na pala vue ra me abara ta ra bil. ");
INSERT INTO ksd_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Ma Aron na ruk ta ra pal na varbarat, ma na ule vue ra umana mal kumau, nina i ga ule pa ia ba i ga ruk ta ra pakana i gomgom, ma na vung diat abara. ");
INSERT INTO ksd_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Na gumu tai ta pakana nina i gomgom, ma na ule mule kana umana mal, ma na irop ma na tul tar kana tinabar di tuntun tar ia, ma ra tinabar di tuntun tar ia nina ba kai ra tarai, ma na pait ra varporong ure ia iat ma ure ra tarai. ");
INSERT INTO ksd_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Ma ra bira ta ra tinabar na varporong na tun ia ta ra uguugu na vartabar. ");
INSERT INTO ksd_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Ma nina i pala vue ra me ure Asasel na puk kana umana mal, ma na gumu ta ra tava, ma namur na ruk ta ra gunan. ");
INSERT INTO ksd_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ma ra bulumakau ure ra tinabar na varporong, ma ra me ure ra tinabar na varporong, nina ba di ga kap ra gapu i dir pi da pait ra varporong ta ra pakana i gomgom, da puak vue dir ta ra papar a gunan irai, ma da tun vue ra pal i dir, ma ra vio i dir, ma ra puta ta dir. ");
INSERT INTO ksd_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ma nina i tun vue dir na puk kana umana mal ma na gumu ta ra tava, ma namur na olo ta ra gunan. ");
INSERT INTO ksd_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Go tika na vartuluai nina ba na tur tukum ure avat: ta ra bung a vinun, ta ra gai lavurua, koko avat a ian, ma koko avat a papalum, avat ma ra umana vaira bula nina dia ki livuan ta vavat; ");
INSERT INTO ksd_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","tago ta go ra bung da pait ra varporong ure avat, upi da vagomgom avat kan kavava lavur varpiam, upi avat a tur gomgom ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ia ra Bung Sabat pi avat a ngo muka tana, ma upi avat a vevel. Go ra vartuluai na tur tukum. ");
INSERT INTO ksd_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Ra tena tinabar, nina di ga ku ia, ma di ga pilak vaire upi na tur kia tamana ta ra tiniba na tena tinabar, na pait ra varporong, ma na ule ra umana mal kumau, nina ba ra umana mal gomgom; ");
INSERT INTO ksd_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","ma na pait ra varporong ure ra pal i gomgom, ma ure bula ra pal na varbarat ma ure ra uguugu na varporong, ma na pait ra varporong ure ra umana tena tinabar, ma ure ra tarai par. ");
INSERT INTO ksd_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Go ra vartuluai nina ba na tur tukum ure avat, upi da pait ra varporong ure ra tarai Israel, tika na pakana ta ra kilakilala da pait ra varporong ure kadia lavur varpiam par. Ma Moses i ga pait nam nina ra Luluai i ga vartuluai tana. ");
INSERT INTO ksd_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Ma ra Luluai i ga tata pire Moses, ma i biti: ");
INSERT INTO ksd_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Una tata pire Aron ma ra umana natuna, ma ra tarai Israel par, ma una biti ta diat: Go iat ra magit a Luluai i vartuluai tana, dari, ");
INSERT INTO ksd_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","ona ta tikai tai ra tarai Israel i doko ta bulumakau, ba ta nat na sip, ba ta me, ta ra bala na gunan, ba ta ra papar a gunan irai, ");
INSERT INTO ksd_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ma pa i kap ia tar ta ra matakilalat i ra pal na varbarat, upi ra vartabar na nian tadav ra Luluai ta ra luaina mata i ra pal na varbarat, da takun ia ma ra gap, i ga lolonge ra gap; da kutu vue nam kan kana vuna tarai; ");
INSERT INTO ksd_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","da kure ra dari upi ra tarai Israel diat a kap kadia umana tinabar nina dia vartabar me aro ta ra uma, tar ta ra matakilalat i ra pal na varbarat tadav ra Luluai, tadav ra tena tinabar, ma diat a tul tar diat a tinabar na varmaram tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Ma ra tena tinabar na apure ra gap ta ra uguugu kai ra Luluai aina ta ra matakilalat i ra pal na varbarat; ma na tun ra bira upi ra magit i ang na katkat tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ma pa diat a pait ra tinabar tadav ra umana tabaran nina dia anan upi ia. Go ra vartuluai na tur tukum pire diat ma ta kadia lavur taun tarai. ");
INSERT INTO ksd_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Ma una biti ta diat: Gala ta te Israel tuna, ba ta vaira i ki varurung ma diat, i tul tar ra tinabar di tuntun tar ia, ba ra mangana tinabar, ");
INSERT INTO ksd_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ma pa i kap ia tar ta ra matakilalat i ra pal na varbarat, upi na vartabar me tadav ra Luluai, da kutu vue nam kan kana vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Gala ta te Israel tuna, ba ta vaira i ki varurung ma diat, i en ta mangana gap, ina tut ure, ma ina kutu vue kan kana vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Tago ra nilaun ai ra pal a paka i ki ta ra gap, damana iau ga pilak pa ra gap upi da pait ra varporong ure ra tulungea i vavat ta ra uguugu na vartabar, tago ra gap i pait ra varporong i vuna ka ta ra nilaun i ki tana. ");
INSERT INTO ksd_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Damana iau ga biti tai ra tarai Israel: Pa ta tikai ta vavat na en ta gap, ma ra umana vaira nina ava ki varurung bula, pata. ");
INSERT INTO ksd_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Ma gala ta te Israel, ba ta vaira nina ava ki varurung, i kap ta leing ba ta beo i rove pa ia, ma i topa ra nian, na vananoro vue ra gap tana, ma na punang ia ma ra tobon. ");
INSERT INTO ksd_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Tago ra nilaun kai ra lavur launa parikai i ki ta ra gap. Damana iau ga biti tai ra tarai Israel: Koko avat a en ta gapu i ta magit; tago ra nilaun ai ra lavur magit na pal a paka par i ki ta ra gapu i diat, ma nina ba i en ia, da okole vue. ");
INSERT INTO ksd_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Ma nina i en ra minat i ta magit, ba nina ba ta leing i ga ubu kadakadal ia, ba ta te Israel tuna, ba ta vaira, na puk kana umana mal, ma na gumu ta ra tava, ma pa na gomgom tuk na ravian, ma namur na gomgom uka. ");
INSERT INTO ksd_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ba gala pa i puk diat, ba gala pa i gumu, ia iat na puak ra balbali ure. ");
INSERT INTO ksd_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Ma ra Luluai i ga tata pire Moses, ma i biti: ");
INSERT INTO ksd_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Una tata pire ra tarai Israel, ma una biti ta diat: Iau ra Luluai kavava God. ");
INSERT INTO ksd_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Koko ava mur ra lavur mangana ai ra gunan Aigipto, nina ba ava ga ki tana, ma koko avat a mur bula ra lavur mangana ai ra gunan Kanaan nina ba ina agure tar avat boko tana, ma koko avat a mur kadia lavur vartuluai. ");
INSERT INTO ksd_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Avat a torom ta kaugu umana varkurai, ma avat a pait ot pa kaugu umana vartuluai upi avat a mur diat; iau ra Luluai kavava God. ");
INSERT INTO ksd_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Damana avat a torom ta kaugu lavur vartuluai, ma kaugu lavur varkurai, nina ba ona ta tutana i pait ia na laun tana; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Koko ta tikai ta vavat na tadav ta vavina nina amur niuruna me, pi na va me; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Koko una va ma tinam, nina ba ra taulai kai tamam tago ia tinam, koko una va me. ");
INSERT INTO ksd_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Koko una va ma ta vavina kai tamam, tago kai tamam iat. ");
INSERT INTO ksd_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Koko una va ma taim nina ba natu i tamam, ba natu i tinam, ba di ga kava ta ra gunan, ba ta ra gunan na vaira. ");
INSERT INTO ksd_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Koko una va ma tubum, a natu i natum, a tutana, ba ta natu i natum, a vavina, tago diat a umana tubum iat. ");
INSERT INTO ksd_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Koko una va ma ta natu i ta vavina kai tamam, nina ba tamam i ga vangala, tago amur taina. ");
INSERT INTO ksd_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Koko una va ma tubum nina ba tai tamam, tago dir taina. ");
INSERT INTO ksd_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Koko una va ma tana vavi tinam, tago dir tana vavina. ");
INSERT INTO ksd_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Koko una va ma ra taulai kai tamam dir turana ma nina i vangala u, tago amur tamana. ");
INSERT INTO ksd_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Koko una va ma kakum, tago ia ra taulai kai natum. ");
INSERT INTO ksd_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Koko una va ma tamaiam, tago ia ra taulai kai turam. ");
INSERT INTO ksd_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Koko una va ma ta vavina dir ma natuna, a vavina; koko una va ma ta vavina dir ma tubuna, a vavina; tago dir niuruna; tago go iat ia ra kaina. ");
INSERT INTO ksd_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Koko una ben pa tamaiam, nina ba dir tana vavina ma kaum taulai, upi una va me, ba kaum taulai i laun boko. ");
INSERT INTO ksd_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Koko una tadav ta vavina upi amur a va me, ba pa i gomgom boko ta kana gai. ");
INSERT INTO ksd_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Koko una va ma ra taulai kai talaim upi una kaina tana. ");
INSERT INTO ksd_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Koko una nur tar ra umana natum upi da tun diat ta ra iap kai Molek, ma koko una vabilak ra iang i kaum God; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Koko una va ma ta tutana da ma ra vavina, ia ra magit i bilak. ");
INSERT INTO ksd_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Koko una va ma ta vavaguai upi una bilak tana; ma koko ta vavina na tadav ta vavaguai upi na va ure; a bilak na purpuruan nam. ");
INSERT INTO ksd_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Koko avat a vabilak avat tai tikai ta go diat, tago ra umana Tematana nina ba iau korot vue diat kan ra luaina mata i vavat, dia bilingiran ma diat, ");
INSERT INTO ksd_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ma ra gunan i kaina tana; damana iau kure ra gunan, ma ra gunan i marue vue diat dia ki tana. ");
INSERT INTO ksd_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Avat a torom ta kaugu lavur vartuluai, ma kaugu lavur varkurai; koko avat a pait ta tika na kaina magit ta go diat, ta te Israel tuna, ba ta vaira nina i ki varurung ma avat. ");
INSERT INTO ksd_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Tago nina dia ga ki lua ta vavat ta go ra gunan dia ga pait go ra umana bilak na magit, ma ra gunan i kaina tana; ");
INSERT INTO ksd_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","upi koko ra gunan na marue vue bula avat da i ga marue vue ra umana Tematana nina dia ga ki lua ta vavat. ");
INSERT INTO ksd_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Tago nina i pait ta tikai ta go ra umana bilak na magit, da kutu vue nam kan kana vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Damana avat a torom ta kaugu togotogo, upi koko avat a pait ta tikai ta go ra umana bilak na mangamangana, nina di ga pait ia lua ta vavat, upi koko avat a kaina tana. Iau ra Luluai kavava God. ");
INSERT INTO ksd_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Ma ra Luluai i ga tata pire Moses, ma i biti: ");
INSERT INTO ksd_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Una tata pire ra tarai Israel par, ma una biti ta diat: Avat a gomgom, tago iau ra Luluai kavava God iau tar gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Tikatikai na ru nana ma tamana, ma na kodop vake kaugu umana Bung Sabat; iau ra Luluai kavava God. ");
INSERT INTO ksd_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Koko avat a anan upi ra umana tabataba, ma koko avat a pait ra umana tabataba di tuntun ia ta ra iap ure avat; iau ra Luluai kavava God. ");
INSERT INTO ksd_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Ba ava tul tar ta vartabar na tinabar na varmaram tadav ra Luluai, avat a tul tar ia ma ra bo na ninunuk. ");
INSERT INTO ksd_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Da en ia ta nam iat ra bung di tul tar ia, ma ta ra bung namur; ma gala ta pakana i ki valili ta ra vautuluna bung, da tun vue ta ra iap. ");
INSERT INTO ksd_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Gala di en ia ta ra vautuluna bung ia ra magit i bilak, ma pa da manane; ");
INSERT INTO ksd_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","nina i en ia na puak ra balbali tana, tago i ga vakaina ra magit i tabu kai ta Luluai ma da kutu vue nam kan kana vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Ba ava doko ra vuai kavava uma, koko avat a doko ra umana nguna tana, ma koko avat a tangatanga namur tana. ");
INSERT INTO ksd_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ma koko avat a tangatanga ta kavava uma na vain, ma koko avat a kap varurue ra vuai kavava uma na vain nina i ga bura; tago ai ra luveana ma ra vaira; iau ra Luluai kavava God. ");
INSERT INTO ksd_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Koko avat a long; koko avat a valunga ta tikai, ma koko avat a vavaongo. ");
INSERT INTO ksd_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Koko avat a vavalima vavaongo ta ra iangigu, upi avat a vabilak ra iang i kavava God; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Koko una ki taun talaim, ma koko una loalong pirana. Koko ra vapuak kai ta tultul di kul ia na ki piram ta ra marum, ma na tuk ta ra malana. ");
INSERT INTO ksd_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Koko una kulume nina i vaut, ma koko una vung bat pa ra pula ma ra tukatukai; una ru kaum God; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Koko una varkurai kakaina; koko una nuk vangala pa nina i luveana, ma koko una ru nina i ngala; una kure talaim ma ra mangamangana takodo. ");
INSERT INTO ksd_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Koko una tena kapkap tinata livuan ta kaum tarai, ma koko una tut ure ra nilaun kai talaim; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Koko ra balam na milikuane turam; una pit talaim kan una puak ra balbali ai ra varpiam ure. ");
INSERT INTO ksd_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Koko una pait ra varobo, ma koko una kankanuane vatikene ra umana natu i kaum tarai, una mari talaim da u mari mule u; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Avat a torom ta kaugu lavur vartuluai. Koko una nur tar kaum umana vavaguai upi diat a varvangala ma ta enana mangana vavaguai; koko una vaume varurungane ra ura mangana patina ta kaum uma; koko una ule ra mal nina di ga pait ia ma ra ura mangana mal. ");
INSERT INTO ksd_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Ma nina i va ma ra tultul na vavina, nina ba di ga tar vapopoe bat ia upi kai ta tutana, ma pa di ga kul valangalanga pa ia boko ma pa di ga ti pala vue boko, da kure dir; pa da doko dir tago ra vavina pa i ga langalanga. ");
INSERT INTO ksd_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Ra tutana na kap kana tinabar na nirara tadav ra Luluai, tar ta ra matakilalat i ra pal na varbarat; na kap ra sip a tomotoina, ure kana tinabar na nirara. ");
INSERT INTO ksd_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Ma ra tena tinabar na pait ra varporong ure ma ra sip, a tomotoina, ai ra tinabar na nirara, ta ra luaina mata i ra Luluai ure ra varpiam nina i ga pait ia; ma da nur vue. ");
INSERT INTO ksd_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Ba avat a tadav ra gunan, ma avat a ga vaume ra lavur mangana davai na nian, avat a nuk pa ia ba ra vuai diat pa i gomgom; na tabu pire vavat a utul a kilala; koko da en ia. ");
INSERT INTO ksd_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ma ta ra vaivatina kilala ra vuai diat par na gomgom, da pait ra pite varpa me tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Ma ta ra vailimana kilala avat a en ra vuai diat, upi ra gunan na vuai vatikai ure avat; iau ra Luluai kavava God. ");
INSERT INTO ksd_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Koko avat a en ta magit nina ba ra gap i ki tana; ma koko avat a tena papait, koko bula avat a umana tena ginigira. ");
INSERT INTO ksd_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Koko avat a gele ra ulu i vavat, ma koko avat a kut ra ngu na kabe i vavat. ");
INSERT INTO ksd_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Koko avat a poko ra pal a paka i vavat ure ra minat, ma koko avat a koto ra paka i vavat; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Koko una vakaina natum, a vavina, upi una ivure; beaka ra gunan na virua ta ra nipo ma na buka ma ra varpiam. ");
INSERT INTO ksd_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Avat a kodop vake kaugu umana Bung Sabat, ma avat a ru kaugu gomgom na pal; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Koko avat a lingan tadav ra umana tena agagar, ba ra umana tena papait; koko avat a tikan upi diat kan diat a vadur avat; iau ra Luluai kavava God. ");
INSERT INTO ksd_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Una tur ta ra luaina mata i nina i pua ra pepe na uluna, ma una ru ra mata i ra patuana, ma una ru kaum God; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Gala ta vaira i ki varurung ma u ta kaum gunan, koko una pait ta kaina pirana. ");
INSERT INTO ksd_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ra vaira nina i ki varurung ma u na da nina di ga kava livuan tam, ma una mari ia da u mari mule u; tago avat ra umana vaira ta ra gunan Aigipto; iau ra Luluai kavava God. ");
INSERT INTO ksd_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Koko avat a varkurai kakaina, ma koko na kaina kavava valavalar na davai ma ra valavalar na mamat, ma ra la na valavalar. ");
INSERT INTO ksd_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Avat a vung ra umana valavalar dia takodo, ra umana valavalar na mamat dia takodo, ra kukulvung i takodo, ma ra valavalar na polo i takodo; iau ra Luluai kavava God, nina iau ga agure vairop avat kan ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Ma avat a kodop vake kaugu lavur vartuluai ma kaugu lavur varkurai, ma avat a mur diat. Iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Ma ra Luluai i ga tata pire Moses, ma i biti: ");
INSERT INTO ksd_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Una biti bula tai ra tarai Israel dari: Gala ta te Israel ba ta vaira i ki ta ra gunan Israel i tul tar natuna pire Molek, a dovotina da doka; a tarai na gunan diat a tupar ia ma ra umana vat. ");
INSERT INTO ksd_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Ina tut ure nam ra tutana, ma ina kutu vue kan kana vuna tarai, tago i ga tul tar natuna pire Molek, upi na vabilingiran kaugu gomgom na pal, ma upi na vadur ra gomgom na iangigu. ");
INSERT INTO ksd_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Gala ra tarai na gunan dia vapula bat ra kiau na mata i diat kan nam ra tutana ba i tul tar natuna pire Molek, ma pa dia doka, ");
INSERT INTO ksd_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ina tut ure nam ra tutana, ma diat bula kana apik na tarai, ma diat dia anan upi Molek varurung me, ma iau pata, ma ina kutu vue diat kan kadia vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Ma nina i vana tadav ra umana tena papait, ma ra umana tena agagar, ma i nuk vue iau tana, ina tut ure nam ma ina kutu vue kan kana vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Damana avat a vagomgom avat upi avat a gomgom, tago iau ra Luluai kavava God. ");
INSERT INTO ksd_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Ma avat a kodop vake kaugu lavur vartuluai, ma avat a pait diat. Iau ra Luluai nina iau vagomgom vilie pa avat. ");
INSERT INTO ksd_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Nina i vul tamana ba nana, da doka; i ga tar vul tamana ba nana; ra gapuna na ki taun ia iat. ");
INSERT INTO ksd_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Ma ra tutana nina dir po ma ra vavina kai talaina, ra tutana ma ra vavina nina dir ga po, da doko dir. ");
INSERT INTO ksd_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Ma ra tutana nina dir ga va ma ra vavina kai tamana, da doko dir ma ra vavina, tago i ga varuva tamana; ra gapu i dir na ki taun dir. ");
INSERT INTO ksd_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Ma gala ta tutana dir va ma kakuna, a dovotina da doko dir, dir vuna ta ra purpuruan i bilak; ra gapu i dir na ki taun dir. ");
INSERT INTO ksd_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Ma gala ta tutana dir va ma ta tutana, da ma ra vavina, dir ga pait ta magit i bilak; a dovotina da doko dir, ma ra gapu i dir na ki taun dir. ");
INSERT INTO ksd_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Ma gala ta tutana i taule guve ra ura barnana, ia ra magit i manga kaina, da tun dital par ta ra iap, upi da vapanie vue ra magit i manga kaina livuan ta vavat. ");
INSERT INTO ksd_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Gala ta tutana dir va ma ta vavaguai, da doka; ma avat a doko bula ra vavaguai. ");
INSERT INTO ksd_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Ma gala ta vavina i tadav ta vavaguai upi dir a va me, avat a doko ra vavina dir ma ra vavaguai; a dovotina da doko dir ma ra gapu i dir na ki taun dir. ");
INSERT INTO ksd_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Ma gala ta tutana i tadav taina, natu i tamana ba natu i tinana, ma dir va me, ia ra magit na vavirvir, ma da kutu vue dir kan kadir vuna tarai; i ga ruk tadav taina, ma na puak ra balbali ure kana mangamangana kaina. ");
INSERT INTO ksd_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Ma gala ta tutana i va ma ra vavina ba i gapgap ta ra gai, da kutu vue dir kan kadir vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Koko amur a va ma tana vavi tinam, ba tai tamam; tago i tar varuva niuruna, dir a puak ra balbali ure kadir mangamangana kaina. ");
INSERT INTO ksd_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Ma gala ta tutana dir va ma ra taulai kai matuana i ga tar varuva matuana; dir a puak ra balbali ure kadir mangamangana kaina; dir a mat ma pa ta natu i dir. ");
INSERT INTO ksd_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Gala ta tutana i ben pa ra taulai kai turana, ia ra magit i dur, i ga tar varuva turana; pa dir a vangala ta bul. ");
INSERT INTO ksd_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Damana avat a kodop vake kaugu lavur vartuluai, ma kaugu lavur varkurai, ma avat a pait diat, upi koko ra gunan nina ba ina agure avat tana na marue vue avat. ");
INSERT INTO ksd_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Ma koko avat a mur ra lavur mangamangana kai ra lavur Tematana nina iau korot vue diat kan ra luaina mata i vavat; dia ga pait go ra lavur magit, damana iau ga talanguane diat. ");
INSERT INTO ksd_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Ma iau ga tar biti ta vavat: Avat a kale kadia gunan, ma ina tul tar ia ta vavat upi avat a vatur vake, a gunan nina i alir tana ra polo na u, ma ra polo na livur; iau ra Luluai kavava God, nina i ga tar tibe vaire avat kan ra umana enana vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Damana avat a tibe varbaiane ra vavaguai i gomgom ma nina ba pa i gomgom, ra gomgom na beo ma nina ba pa i gomgom; ma koko avat a vabilak ra tulungea i vavat tai ta vavaguai ma ta beo, ba ta magit i kakakao ta ra pia, nina ba iau ga tar varbaiane kan avat ba pa dia gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Ma avat a gomgom da avat kaugu, tago iau ra Luluai iau tar gomgom, ma iau ga tar tibe vaire avat kan ra umana enana vuna tarai upi avat kaugu. ");
INSERT INTO ksd_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","A tutana ba ta vavina ia ra tena papait, ba ra tena agagar, a dovotina da doka. Da tupar dir ma ra umana vat; a gapu i dir na ki taun dir. ");
INSERT INTO ksd_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Ma ra Luluai i ga biti tai Moses: Una tata pire ra umana tena tinabar, ra umana natu i Aron, ma una biti ta diat: Koko ta tikai na vakaina kana gomgom na kini ure ta minat ta kana vuna tarai, ");
INSERT INTO ksd_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","nina vakir a tutur tana (da tinana ba tamana ba natuna a tutana, ba natuna a vavina, ba turana, ");
INSERT INTO ksd_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ba taina nina pa i ga taulai). ");
INSERT INTO ksd_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Koko na da ra luluai ta kana vuna tarai upi na vakaina kana gomgom na kini da ra tutana vakuku. ");
INSERT INTO ksd_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Koko ra umana tena tinabar diat a ka ra pepe na ulu i diat, ba ra ngu na kabe i diat, ma koko diat a poko ra paka i diat. ");
INSERT INTO ksd_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Diat a gomgom ure kadia God, upi koko ra iang i kadia God na da ra magit vakuku; tago dia tul tar ra umana tinabar kai ra Luluai di tuntun tar ia ta ra iap, ma ra vartabar na nian kai kadia God; kari diat a gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Koko diat a taule ta igoro na vavina, ba nina i ga nunure ta tutana, ba ta vavina nina di ga vue; tago di ga tibe vaire ra tena tinabar upi kai kana God. ");
INSERT INTO ksd_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Damana una tibe vaire; tago i tul tar ra vartabar na nian kai kaum God; na ti enana ure u; tago iau ra Luluai, nina iau pilak vaire vue avat, iau enana kakit. ");
INSERT INTO ksd_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Ma natu i ra tena tinabar, a vavina, gala i da ra magit vakuku tago i igoro, i varuva tamana; da tun ia ta ra iap. ");
INSERT INTO ksd_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Ma koko ra tena tinabar ngalangala, nina ba di ga ku ra uluna ma ra dangi, ma di ga tata vadoane upi na ule tar ra umana mal tabu, na pala ra pepe na uluna pi na purpuruan, ba na rada kana umana mal; ");
INSERT INTO ksd_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","koko na vana maravai ta ra minat, ma koko na vakaina kana gomgom na kini ure tamana ba nana; ");
INSERT INTO ksd_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","koko na irop kan ra gomgom na pal, ma koko bula na vaikilik pa ra pal tabu kai kana God; tago ra varvadoan ai ra dangi na varku kai kana God i ki taun ia; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Na taule ta inip na vavina; ");
INSERT INTO ksd_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","pa na taule ta ua na vavina, ba tikai di ga vue, ba tikai i ga nunure ta tutana, ba ta igoro na vavina; na taule ta inip na vavina ta kana tarai iat, ");
INSERT INTO ksd_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","upi koko ra umana natuna diat a da ra magit vakuku livuan ta kana tarai; tago iau ra Luluai nina iau vagomgom ia. ");
INSERT INTO ksd_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Ma ra Luluai i ga tata pire Moses, ma i biti: ");
INSERT INTO ksd_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Una tata pire Aron, dari: Nina ba ta bul tam, ta ra lavur taun tarai, a vur tutana koko na vana maravai upi na tul tar ra vartabar na nian ai kana God. ");
INSERT INTO ksd_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Koko ta vur tutana na vana maravai, ta tutana i pula, ba i kekebau, ba a lor, ba tika na ingarina i ki ak, ");
INSERT INTO ksd_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ba ta tutana i tabubur ra kauna ba ra limana, ");
INSERT INTO ksd_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ba i potok ra muruna, ba a vu, ba i kaina ra kiau na matana, ba i kaka, ba i tirpa, ba ra kolokina i kinkin; ");
INSERT INTO ksd_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","pa ta natu i Aron, ra tena tinabar, nina ba a vur tutana, na vana maravai upi na tul tar ra tinabar di tun ia ta ra iap tadav ra Luluai; nina ba ta vur tutana pa na vana maravai upi na tul tar ra vartabar na nian kai kana God. ");
INSERT INTO ksd_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Na topa ia ba na en ra magit kai kana God, ra magit i gomgom kakit, ma nina bula i gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Ia kaka pa na ruk ta ra pakana aro ta ra mal na rurua kutu, ma pa na vana maravai ta ra uguugu, tago a vur tutana, upi koko na vakaina kaugu umana gomgom na pal; tago iau ra Luluai iau vagomgom diat. ");
INSERT INTO ksd_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Damana Moses i ga tata pire Aron, ma pire ra umana natuna, ma pire ra tarai Israel par. ");
INSERT INTO ksd_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Ma ra Luluai i ga tata pire Moses, ma i ga biti: ");
INSERT INTO ksd_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Una ve Aron ma ra umana natuna ba diat a vakilang varbaiane ra lavur gomgom na tinabar kai ra tarai Israel, nina ba dia vagomgom diat upi kaugu, ma koko bula diat a vabilak ra gomgom na iangigu; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Una biti ta diat: Nina ba ta vavat, ba tai ra umana natu i vavat ta ra lavur taun tarai, i vana maravai tadav ra umana gomgom na magit, nina ba ra tarai Israel dia ga vagomgom diat ure ra Luluai, ma pa i gomgom, da kutu vue nam ra tutana kan ra luaina matagu; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Koko ta natu i Aron i vukavuka, ba i gap, na en ta magit i gomgom tuk ia iat na gomgom. Gala ta tikai i bili ta magit nina pa i gomgom, tago i ga tadav ta minat, ba ta tutana a gorgorina i talingir vakuku, ");
INSERT INTO ksd_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ba i bili ta magit i kakakao ia ra pia nina ba pa na gomgom tana, ba ta tutana nina ba pa na gomgom tana gala i bili ia, tago pa i gomgom ta ra ava bar; ");
INSERT INTO ksd_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","nina i bili tikai ta go diat, pa na gomgom tuk na ravian, ma pa na en ra umana tinabar dia gomgom, gala pa i gumu ta ra gomgom na tava. ");
INSERT INTO ksd_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Ba ra keake i vana ba, na gomgom; ma namur na en ra umana tinabar dia gomgom, tago nam ana nian. ");
INSERT INTO ksd_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Pa na en nam nina i mat vakuku, ba ra umana leing dia ga ubu kadakadal ia; koko na vadur ia iat tana; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Diat a kodop vake kaugu lavur vartuluai, kan diat a puak pa ra vuai ra varpiam ma diat a mat tana, tago dia ga nuk vakuku pa diat. Iau ra Luluai iau vagomgom vilie pa diat. ");
INSERT INTO ksd_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Pa ta tutana vakuku na en ra tinabar i gomgom; nina i ki ka pire ra tena tinabar, ba ra tultul di vapuak ia, pa na ian ta ra tinabar i gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ia kaka ta vilavilau nina ba ra tena tinabar i ga kul ia ma kana mani na en ia; ma diat nina di ga kava diat ta ra kubana diat a en kana nian. ");
INSERT INTO ksd_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Ma natu i ra tena tinabar, nina i taule ta tutana vakuku, pa na en ra tinabar na tutuluai nina i gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Ba gala natu i ra tena tinabar i taurara, ba di vue ma pa kana ta bul, ma i tar lilikun ta ra kuba i tamana, na en ra nian kai tamana; ia kaka, pa ta tutana vakuku na en ia. ");
INSERT INTO ksd_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Gala ta tutana i ian ma ra tuptup ta ra tinabar i gomgom, na valilikun ra tinabar pire ra tena tinabar, ma na vot ia ma tika na vavailimana tana. ");
INSERT INTO ksd_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Koko ra umana tena tinabar diat a nuknuk vakuku ure ra umana tinabar nina ba ra tarai Israel dia tul tar ia tai ra Luluai, ");
INSERT INTO ksd_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","upi diat a vuna ta ra kinakap na vuai na varpiam kai nina dia en ra tinabar i gomgom; tago iau ra Luluai iau vagomgom vilie pa diat. ");
INSERT INTO ksd_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Ma ra Luluai i ga tata pire Moses, ma i ga biti: ");
INSERT INTO ksd_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Una tata pire Aron, ma ra umana natuna, ma ra tarai Israel par, ma una biti ta diat: Ba ta tikai ta ra tarai Israel, ba ta vaira nina i ki Israel, i tul tar kana vartabar na nian, ta vartabar nina i ga tar kubu tar ia ma ra vavalima, ba ta tamarigat na vartabar, upi da tuntun tar ia tadav ra Luluai, ");
INSERT INTO ksd_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","na tul tar ra tomotoina i gomgom kakit, ta bulumakau, ba ta sip, ba ta me, upi da manane. ");
INSERT INTO ksd_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Koko avat a tul tar nina ba pa i gomgom kakit, tago pa da manane. ");
INSERT INTO ksd_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Ma nina i tul tar ra tinabar na varmaram tadav ra Luluai kan ra kikil na bulumakau ba ra kikil na sip, upi na pait ot pa ra vartabar nina i ga tar kubu tar ia ma ra vavalima, ba ra tamarigat na vartabar, na tul tar nina i gomgom kakit, upi da manane. ");
INSERT INTO ksd_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Koko avat a tul tar ia tai ra Luluai nina ba i pula, ba i kinkin, ba i kakak, ba i manua, ba i kaka, ba i karakaroto ra pakana, ma koko avat a tun diat ta ra uguugu tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Na topa ia ba avat a tul tar ta bulumakau ba ta nat na sip nina ba tika na kakene i tuk ak ba i tuk pit, ure ra tamarigat na vartabar, ia kaka ure ra vartabar di ga tar kubu tar ia ma ra vavalima, pata. ");
INSERT INTO ksd_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Koko avat a tul tar ia tai ra Luluai ta vavaguai ba i kinkin ra kolokina ba di tar lap vue; koko avat a vartabar ma ra dari ta kavava gunan. ");
INSERT INTO ksd_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Ma koko avat a kap ra dari tai ta vaira upi avat a tul tar ia ure ra nian kai kavava God; dia kom pit ma pa dia ko kakit, pa da manane diat. ");
INSERT INTO ksd_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Ma ra Luluai i ga tata pire Moses, ma i ga biti: ");
INSERT INTO ksd_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Ba di kava ta bulumakau, ba ta sip, ba ta me, na ki boko pire nana lavurua na bung, ma papa ra valavutuluna bung na topa ra vartabar na nian, nina di tun ia ta ra iap tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ma gala di tul tar ta tana na bulumakau, ba ta tana na sip, koko avat a doko dir ma natuna tai ta kopono bung. ");
INSERT INTO ksd_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Ma ba ava tul tar ra tinabar na pite varpa tadav ra Luluai, avat a pait ra tinabar i takodo upi da manane. ");
INSERT INTO ksd_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Da en ia ta nam iat ra bung di tul tar ia; koko ta pakana na ki valili tuk ra malana; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Damana avat a kodop vake kaugu lavur varkurai, ma avat a pait diat; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Koko avat a nuknuk vakuku ure ra gomgom na iangigu, upi da ru iau livuan ta ra tarai Israel; iau ra Luluai nina iau pilak vaire vue avat, ");
INSERT INTO ksd_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","nina iau ga agure vairop avat kan ra gunan Aigipto, upi iau kavava God; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Ma ra Luluai i ga tata pire Moses, ma i ga biti: ");
INSERT INTO ksd_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Una tata pire ra tarai Israel, ma una biti ta diat: A umana lukara kai ra Luluai, nina ba avat a vatang vaarike diat ba ra umana kivung na lotu, go diat kaugu umana lukara. ");
INSERT INTO ksd_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Laptikai na bung avat a papalum tana, ma ra valavuruana bung ia ra bung di vagomgom ia ure ra ningo, ure ra kivung na lotu; koko avat a pait ta mangana papalum tana; ia ra Bung Sabat tadav ra Luluai ta ra lavur gunan ba avat a ki tana. ");
INSERT INTO ksd_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Go diat ra umana lukara di kubu tar ia ba kai ra Luluai, ra umana bung na lotu nina ba avat a vatang vaarike ta kadia e tikatikai. ");
INSERT INTO ksd_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Ta ra luaina gai, ta ra bung a vinun ma a ivat ta ra gai, ta ra ravian, ia ra bolo lake kai ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Ta ra bung a vinun ma a ilima ta nam iat ra gai ia ra lukara na gem nina pa i leven, tadav ra Luluai; lavurua na bung avat a en ra gem nina pa i leven. ");
INSERT INTO ksd_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ta ra luaina bung ta ra lukara avat a pait ra kivung na lotu; koko avat a papalum tana. ");
INSERT INTO ksd_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Ma avat a tul tar ra tinabar di tun ia ta ra iap tadav ra Luluai ure lavurua na bung; ra valavuruana bung ia ra kivung na lotu, koko avat a papalum tana. ");
INSERT INTO ksd_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Ma ra Luluai i ga tata pire Moses, ma i ga biti: ");
INSERT INTO ksd_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Una tata pire ra tarai Israel, ma una biti ta diat: Ba avat a pot ta ra gunan nina ba ina tul tar ia pire vavat, ma avat a doko ra vuaina tana, avat a kap ra vinvin nina di vilie pa ia ta ra vuai e ta kavava uma tadav ra tena tinabar. ");
INSERT INTO ksd_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Ma na tulue ra vinvin ta ra luaina mata i ra Luluai upi na manane; ra tena tinabar na tulue ta ra kubak na Bung Sabat. ");
INSERT INTO ksd_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Ma ta ra bung ba ava tulue ra vinvin tana, avat a tul tar ta nat na sip, a tomotoina i ko kakit, ta kana luaina kilala upi ra tinabar di tuntun tar ia tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Ma da tul tar bula tika na vavailimana pakana epa na bo na plaua di ga pota ma ra dangi, ure ra tinabar na vuai na uma di tun ia ta ra iap tadav ra Luluai, upi ra magit i ang na katkat; ma da tul tar bula ra ura lita (a utul a paint) na polo na vuai na vain ure ra tinabar na vain. ");
INSERT INTO ksd_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Ma na tabu ba avat a en ta gem, ba ta kon di tun ia, ba ta kalamana kon, tuk tar avat a ga kap ra vartabar na nian kai kavava God; go ra vartuluai na tur tukum ta kavava lavur taun tarai, ma ta ra umana gunan ba avat a ki tana. ");
INSERT INTO ksd_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Ma papa ra kubak na Bung Sabat, papa ra bung ava ga kap ra vinvin ure ta tinabar na tutuluai, avat a luk lavurua na kidoloina vik; ");
INSERT INTO ksd_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ma na tuk tar ra kubak i ra valavuruana Bung Sabat, upi avat a luk ra ilima na vinun na bung; ma avat a tul tar ra tinabar na luaina vuai ra vit tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Ma avat a kap ra ura gem na tutuluai nina di ga pait ia ma ra vavailimana pakana epa na bo na plaua, ma di ga tun ia ma ra leven, a vuai e tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Ma avat a tul varurungane tar ia ma ra gem lavurua na nat na sip dia ko kakit ma i kopono ko kadia kilala, ma tika na nat na bulumakau, ma ra ura sip, a ura tomotoina; da tul tar diat ure ra tinabar di tuntun tar ia tadav ra Luluai; da tul varurungane tar diat ma ra tinabar na vuai na uma di tun ia ta ra iap, ma ra tinabar na nimomo, upi ra magit i ang na katkat tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ma avat a tul tar tika na me, a tomotoina, upi ra tinabar na varporong, ma ra ura nat na sip, i kopono ko kadir kilala, upi ra vartabar na varmaram. ");
INSERT INTO ksd_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Ma ra tena tinabar na tulue diat ma ra gem na vuai e, ma ra ura nat na sip, upi ra tinabar na tutuluai ta ra luaina mata i ra Luluai; diat a gomgom ure ra Luluai upi kai ra tena tinabar. ");
INSERT INTO ksd_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Ma ta nam iat ra bung avat a vatang vaarike ba ra kivung na lotu ure avat; na tabu ba avat a papalum tana. Go ra vartuluai na tur tukum ta ra lavur gunan ba avat a ki tana ma ta kavava lavur taun tarai. ");
INSERT INTO ksd_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Ma ba ava doko ra vuai kavava uma, koko avat a doko ra umana nguna tana, ma koko avat a tangatanga namur tana; avat a nur vue diat ure nina i luveana ba i vaira; iau ra Luluai kavava God. ");
INSERT INTO ksd_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Ma ra Luluai i ga tata pire Moses, ma i ga biti: ");
INSERT INTO ksd_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Una tata pire ra tarai Israel ma una biti: Ta ra gai lavurua ta ra luaina bung ta ra gai, avat a vakilang vake upi ra bung na ningo tuna ure avat, a bung na im, nina avat a vu ra umana tavur tana, a bung na kivung na lotu. ");
INSERT INTO ksd_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","I tabu ba avat a papalum tana, ma avat a tul tar ra tinabar di tun ia ta ra iap tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Ma ra Luluai i ga tata pire Moses, ma i ga biti: ");
INSERT INTO ksd_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Ta ra bung a vinun ta go ra gai lavurua, avat a pait ra kivung na lotu ma avat a vevel tana, tago ia ra bung na varporong; ma avat a tul tar ra tinabar di tun ia ta ra iap tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Koko avat a pait ta mangana papalum ta nam ra bung, tago ia ra bung na varporong, upi da pait ra varporong ure avat ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Ma nina ba pa i vevel ta nam ra bung, da kutu vue kan kana vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Ma nina ba i pait ta mangana papalum ta nam ra bung, ina nila vue nam kan kana vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Koko avat a pait ta mangana papalum tana; ia ra vartuluai nina ba na tur tukum ta kavava lavur taun tarai, ma ta nam ra umana gunan nina ba avat a ki tana. ");
INSERT INTO ksd_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Na da ra Bung Sabat di ngo tuna tana, ma avat a vevel; papa ba ra keake i kuba ta ra bung lavuvat, ma na tuk tar ra keake i kuba ta ra bung a vinun, avat a ru kavava Bung Sabat. ");
INSERT INTO ksd_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Ma ra Luluai i ga tata pire Moses, ma i ga biti: ");
INSERT INTO ksd_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Una tata pire ra tarai Israel, dari: Ta ra bung a vinun ma a ilima ta ra gai lavurua da tur pa ra lukara na pal na turturup ure lavurua na bung tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Ra luaina bung ia ra kivung na lotu, koko da papalum tana. ");
INSERT INTO ksd_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Avat a tul tar ra tinabar di tun ia ta ra iap tadav ra Luluai ure lavurua na bung; ma ta ra valavutuluna bung avat a pait ra kivung na lotu tana, ma avat a tul tar ra tinabar di tun ia ta ra iap tadav ra Luluai; ia ra mutuaina bung ta ra lukara; koko avat a papalum tana. ");
INSERT INTO ksd_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Go ra umana lukara nina di ga vakilang ia ba kai ra Luluai, nina ba avat a vatang vaarike ba ra umana bung na lotu, upi avat a tul tar ra umana tinabar di tun ia ta ra iap tadav ra Luluai, ra tinabar di tuntun tar ia, ra tinabar na vuai na uma, ra vartabar, ma ra tinabar na nimomo, tikatikai ta kana bung iat; ");
INSERT INTO ksd_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","avat a pait go diat ma avat a kodop vake bula ra umana Bung Sabat kai ra Luluai, ma avat a tul tar bula kavava lavur vartabar, ma kavava lavur vartabar ava ga tar kubu ia ma ra vavalima, ma kavava lavur tamarigat na vartabar, nina ba ava tul tar ia tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Ta ra bung a vinun ma a ilima ta ra gai lavurua, ba ava ga tar kap varurue vapar ra lavur vuai na uma, avat a pait ra lukara kai ra Luluai ure lavurua na bung; ra luaina bung ta ra lukara ia ra bung na ningo tuna, ma na damana bula ra valavutuluna bung. ");
INSERT INTO ksd_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Ta ra luaina bung avat a kap ra vuai ra umana bo na davai, ra umana mapina gelep, ma ra umana ingar i ra davai dia lubalubang, ma ra umana tabun lulul maravai ra tava alir; ma avat a gugu ta ra luaina mata i ra Luluai kavava God ure lavurua na bung. ");
INSERT INTO ksd_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Ma avat a vakilang vake upi ra lukara kai ra Luluai, lavurua na bung ta ra kilakilala; ia ra vartuluai nina ba na tur tukum ta kavava lavur taun tarai, ma avat a papait ia ta ra gai lavurua. ");
INSERT INTO ksd_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Avat a ki ta ra umana pal na turturup lavurua na bung; ra umana te Israel tuna diat a ki ta ra umana pal na turturup; ");
INSERT INTO ksd_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","upi kavava taun tarai diat a nunure ba iau ga tul tar ra tarai Israel upi diat a ki ta ra umana pal na turturup, ba iau ga ben vairop vue diat kan ra gunan Aigipto; iau ra Luluai kavava God. ");
INSERT INTO ksd_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Ma Moses i ga ve ra tarai Israel ure ra umana. lukara di ga vakilang vake upi kai ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Ma ra Luluai i ga tata pire Moses, ma i ga biti: ");
INSERT INTO ksd_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Una vartuluai pire ra tarai Israel upi diat a kap ra bo na dangi na oliva tuna piram ure ra kapa, upi ra umana lamp diat a birao vatikai. ");
INSERT INTO ksd_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Ma Aron na vung bulu diat ta ra pal na varbarat ta ra ravian ma na tuk ta ra malana ta ra luaina mata i ra Luluai, ma diat a tur ura na taur ta ra mal na rurua kutu; ma go ra vartuluai na tur tukum ta kavava lavur taun tarai mutu. ");
INSERT INTO ksd_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Ta ra lavur bungbung na vung bulu ra umana lamp ta kadia kiki na goled ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Ma una tak pa ta bo na plaua, ma una tun a vinun ma ura gem me; tika na vavailimana pakana epa na bo na plaua tai tika na gem. ");
INSERT INTO ksd_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Ma una vung diat a ura vuvungaina, laptikai na ki tai tika na vuvungaina, ta ra ul a vatar na goled tuna ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Ma una vung ta bulit i ang na katkat taun ra ura vuvungaina tikatikai upi na vanuk tar ra Luluai ure ra gem, ma na da ra tinabar di tun ia ta ra iap tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Ta ra lavur Bungbung Sabat ra tena tinabar na vung bulu ia ta ra luaina mata i ra Luluai; di tul tar ia ure ra tarai Israel upi ra vakilang ure ra kunubu i tur tukum; ");
INSERT INTO ksd_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ma kai Aron ma ra umana natuna, ma diat a en ia ta ra pakana i gomgom; ia ra magit i gomgom kakit ure, ma na vatur ia vatikai kan ra lavur tinabar di tun ia ta ra iap ure ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Ma tika na natu i ra vavina Israel ma ra tutana Aigipto, i ga vana livuan pire ra tarai Israel, ma dir ga varngangar ma ra tutana Israel tuna ta ra bala na gunan; ");
INSERT INTO ksd_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ra natu i ra vavina Israel i ga kulume ra Iang ma ra varvul; ma dia ga ben pa ia pire Moses. A iang i tinana Selomit, ma ia ra natu i Dibri ta ra vuna tarai Dan. ");
INSERT INTO ksd_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Di ga vung ia ta ra pal na banubat upi diat a matoto tai ra Luluai ure. ");
INSERT INTO ksd_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Ma ra Luluai i ga tata pire Moses, ma i ga biti: ");
INSERT INTO ksd_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Una agure vairop go nina i ga varvul ta ra papar a gunan irai; diat par nina dia ga valongore, diat a vung ra lima i diat ta ra uluna, ma ra tarai par diat a tupar ia ma ra vat. ");
INSERT INTO ksd_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Ma una tata pire ra tarai Israel, dari: Nina i kulume kana God na puak ra balbali ta kana varpiam, ");
INSERT INTO ksd_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","ma nina i vul ra iang i ra Luluai, a dovotina da doka; a tarai par diat a tupar ia; da pait ia tai ra vaira, da di pait ia pire ra te Israel tuna, da doka ba i vul ra Iang. ");
INSERT INTO ksd_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Nina i doko ta tikai, da doka; ");
INSERT INTO ksd_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ma nina i doko ta vavaguai, na bali ia; a nilaun ma ra nilaun. ");
INSERT INTO ksd_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Gala ta tutana i vakaina talaina; da i ga pait ia, da pait ia pirana; ");
INSERT INTO ksd_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","a kinkin ma ra kinkin, a kiau na mata ma ra kiau na mata, a pal a ngia ma ra pal a ngia; da i ga vakaina ta tutana da vakaina bula. ");
INSERT INTO ksd_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Nina i doko ta vavaguai na bali ia; ma nina i doko ta tutana da doka. ");
INSERT INTO ksd_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Avat a vaki ta kopono varkurai, nina i varogop, ure ra vaira ma ure ra te Israel tuna; tago iau ra Luluai kavava God. ");
INSERT INTO ksd_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Ma Moses i ga tata pire ra tarai Israel, ma dia ga agure vairop ra tutana i ga varvul ta ra papar a gunan irai, ma dia ga tupar ia ma ra umana vat. Ma ra tarai Israel dia ga pait muka nam ra Luluai i ga vartuluai tana pire Moses. ");
INSERT INTO ksd_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Ma ra Luluai i ga tata pire Moses ta ra luana Sinai ma i ga biti: ");
INSERT INTO ksd_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Una tata pire ra tarai Israel ma una biti ta diat: Ba ava pot ta ra gunan nina ba ina tul tar ia pire vavat, da vango ra pia ure ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Laptikai na kilala una vavauma ta kaum uma, ma laptikai na kilala una laga kaum uma na vain ma una git ra vuaina tana. ");
INSERT INTO ksd_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Ma ra valavuruana kilala na da ra kilala na ningo upi da vango ra pia; ia ra kilala na ningo pire ra Luluai; pa una vaume kaum uma ma pa una laga kaum uma na vain. ");
INSERT INTO ksd_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Nam nina i tavua rikai vakuku ta kaum uma pa una dodoko tana, ma pa una git ra vuaina ta kaum uma na vain nina ba pa di ga laga ia; a pia na ngo muka ta nam ra kilala. ");
INSERT INTO ksd_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Di kure ra varvango na pia upi na tavua bulu ra avava nian; na topa u ma kaum vilavilau, a tutana ma ra vavina, ma kaum tultul di kul ia, ma ra vaira nina i ki piram; ");
INSERT INTO ksd_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","na topa bula kaum umana bulumakau, ma ra lavur vavaguai ta kaum gunan ba diat a ian tana. ");
INSERT INTO ksd_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Ma una luk lavurua na kilala na ningo, lavurua na lavurua na kilala upi ra lavurua na kilala na ningo, na da a ivat na vinun ma lavuvat na kilala. ");
INSERT INTO ksd_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Ma ta ra bung a vinun ta ra valavuruana gai a tavur na tangi mat ta ra gunagunan; a tavur na manga tangi ta ra lavur gunagunan ta ra bung na varporong. ");
INSERT INTO ksd_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Ma avat a ru ra vailimana vavinun na kilala, ma avat a vatang vaarike ra kini langalanga pire ra tarai par ta ra lavur gunagunan; ia ra kilala na iubili pire vavat, ma ra tarai par diat a lilikun tadav kadia pakana pia tikatikai ma tadav kadia umana apik na tarai tikatikai. ");
INSERT INTO ksd_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","A vailimana vavinun na kilala, a kilala na iubili pire vavat; koko avat a vavauma, ma koko avat a doko nam nina i tavua rikai vakuku ma koko avat a git ra vuaina ta ra uma na vain nina pa di ga laga ia. ");
INSERT INTO ksd_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Tago ia ra kilala na iubili; na gomgom pire vavat; avat a en nam i tavua vakuku ta ra pui. ");
INSERT INTO ksd_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Ta go ra kilala na iubili tikatikai na lilikun tadav kana pakana pia. ");
INSERT INTO ksd_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Ba u ivure ta pakana ta kaum pia pire talaim koko una to lake ra mataina pirana, ma ba u kul ta pakana pia pirana, koko na to lake ra mataina piram; ");
INSERT INTO ksd_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","ba u kukul pire talaim una nuk pa ra umana kilala taun ra iubili; ba i ivura na nuk pa ra umana kilala dia ki boko upi ra kilala na iubili na pot. ");
INSERT INTO ksd_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Gala ra umana kilala dia mangoro una vangala ra mataina, ma gala dia paupau ra umana kilala una vaikilik ra mataina, tago u kul uka ra umana e na nidodoko. ");
INSERT INTO ksd_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Koko avat a vakaina ta tikai ma ra mataina; una ru kaum God; tago iau ra Luluai kaum God. ");
INSERT INTO ksd_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Damana avat a pait kaugu lavur vartuluai ma avat a torom ta kaugu lavur varkurai ma avat a pait diat; ma avat a ki bulu ta ra gunan. ");
INSERT INTO ksd_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Ma ra gunan na vuai ra vuaina, ma avat a maur, ma avat a ki bulu tana. ");
INSERT INTO ksd_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Ma gala avat a biti, Ava laka avet a en ia ta ra valavuruana kilala, tago pa avet a vavauma, ma pa avet a doko ta vuaina? ");
INSERT INTO ksd_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","io, ina tulue kaugu varvadoan taun avat ta ra valaptikaina kilala ma ra gunan na vuai ra vuaina nina ba na topa ra utul a kilala. ");
INSERT INTO ksd_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Ma avat a vavauma ta ra valavutuluna kilala, ma avat a ian ta nam ava ga varurue, ma damana avat a iaian ta nam ava ga varurue ma na tuk tar ta ra uma ta ra valavuvatina kilala i matuka. ");
INSERT INTO ksd_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Koko da ivure vatukum ra pia, tago kaugu iat ra pia; tago avat ra umana vaira ma ava ki papa ka piragu. ");
INSERT INTO ksd_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Avat a tul tar ia ba da kul valilikun ra pia ta ra gunan ava kale. ");
INSERT INTO ksd_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Gala talaim na luveana, ma na ivure ta pakana ta kana pia, ra luaina ta diat a umana tutur tana na kul valilikun pa nam nina turana i ga ivure. ");
INSERT INTO ksd_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ma gala ta tutana, pa ta tikai tana pi na kul valilikun pa ia, ma namur i uviana ma i tale pi na kul valilikun pa ia, ");
INSERT INTO ksd_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","na luk ra umana kilala papa di ga ivure, ma na tul tar ia pire nina i ga kul ia nina ba na topa boko nam ra umana kilala tuk tar ta ra iubili; damana na kale mule kana pakana pia. ");
INSERT INTO ksd_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ba gala pa i tale upi na kul valilikun pa ia, io, nam nina di ga ivure na ki pire nina i ga kul ia tuk tar ta ra kilala na iubili, ma ta ra iubili ra tutana na vatur vake mule kana pia. ");
INSERT INTO ksd_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Gala ta tutana i ivure ta pal ta ra pia na pal nina ba di ga liplip bat ia, na topa ia ba na kul valilikun pa ia ure tika na kilala papa ba i ga ivure. ");
INSERT INTO ksd_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Gala pa di kul valilikun ra pal nina i ki ta ra pia na pal di liplip bat ia, ba pa i par nam ra kilala, nam nina i ga kul ia na kale vake upi kana ma kai ra umana bul mur bula tana; pa da valilikun ia ta ra kilala na iubili. ");
INSERT INTO ksd_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","la kaka, ra umana pal ta ra umana gunan nina pa di liplip bat diat, na da ra pia kai ra gunan, i topa ia ba da kul valangalanga diat ma da valilikun diat ta ra kilala na iubili. ");
INSERT INTO ksd_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Na topa ia bula ba diat ra vuna tarai Levi, diat a kul valangalanga ra umana pal nina dia ki ta nam ra umana pia na pal di ga tibe ba diat a ki tana, ma diat a kul valilikun pa ia ta nam ra kilala diat iat dia mainge. ");
INSERT INTO ksd_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Ma gala ta te Levi pa i kul valilikun kana pal, nina i ki ta ra pia na pal di ga tibe ba kai ra vuna tarai Levi, nam ra pal nina di ga ivure, da valilikun ia ta ra kilala na iubili; tago ra umana pal ta ra umana pia na pal kai ra vuna tarai Levi, di ga tibe ba kadiat iat pire ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Ia kaka, i tabu ba da ivure ra umana pakana pia ta ra pia na vura kai ra umana vavaguai ta kadia umana pia na pal, tago kai ra umana te Levi tuktukum. ");
INSERT INTO ksd_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Gala ta tikai ta kaum vuna tarai na ga luveana ma i ti ki tuna tar tana ba una maravut ia, una vatur vake pi na ki boina maravai piram. ");
INSERT INTO ksd_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Koko una vatur vake ra kubika tana; koko ra kubika na mani ma koko bula ra kubika na nian; una ru kaum God, ma una mulaot ba niurum na ki maravai piram. ");
INSERT INTO ksd_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Ma koko una vatur ra kubika ure ra mani nina u la tar ia tana, ba ure ra nian u la tar ia tana. ");
INSERT INTO ksd_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Iau ra Luluai kavava God, iau ga agure vairop avat kan ra gunan Aigipto, upi ina tul tar ra gunan Kanaan pire vavat, ma upi iau kavava God. ");
INSERT INTO ksd_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Gala ta tikai ta kaum vuna tarai na luveana, ma na ivure ia iat piram, koko na toratorom piram da ra vilavilau, ");
INSERT INTO ksd_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","na ki piram da ra tultul di vapuak ia ba da ra vaira; na papalum piram da tikai di vapuak ia tuk ta ra kilala na iubili, ");
INSERT INTO ksd_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ma namur na vana langalanga kan u, diat ma ra umana natuna, ma na lilikun tar ta kana apik na tarai ma tadav ra pia kai ra umana tamana. ");
INSERT INTO ksd_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Tago kaugu umana vilavilau diat, nina ba iau ga ben vairop pa diat kan ra gunan Aigipto; i tabu ba da ivure diat upi ra kini na vilavilau. ");
INSERT INTO ksd_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Koko una kure vadekdek ia; una ru kaum God. ");
INSERT INTO ksd_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Ma ure kaum umana vilavilau, ra umana tutana ma ra umana vavina; una kul diat pire ra umana Tematana nina dia ki kikil avat. ");
INSERT INTO ksd_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","I topa ia bula ba avat a kul diat pire ra umana vaira, nina dia ki livuan ta vavat, ma pire ra umana bul mur ta diat, nina di ga vangala diat livuan ta vavat; ma avat a kale diat. ");
INSERT INTO ksd_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Avat a vatur vake go diat, ma avat a nur tar bula diat ta ra umana bul mur ta vavat; avat a kap kavava umana vilavilau ta diat vatvatikai; ia kaka koko avat a kure vadekdek ra umana talai vavat pire ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Gala ta vaira ba nina i ki papa ka piram na uviana, ma talaim ta kaum vuna tarai na ga luveana maravai pirana, ma na ivure ia iat pire ra vaira, ba pire nina i ki papa ka piram, ba pire ra umana bul mur ta ra vaira; ");
INSERT INTO ksd_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ba i tar ivure tar mule ia iat, i topa ia ba tika na turana na kul valangalanga; ");
INSERT INTO ksd_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","matuana, ba ta nauvana, ba ta tutur tana, na kul valangalanga pa ia; ba gala na uviana mulai, io, na tia tibuna kul valangalanga pa mule. ");
INSERT INTO ksd_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Ma dir ma nina i ga kul ia, dir a luk ra umana kilala papa ta nam ra kilala i ga ivure mule tana, ma na tuk tar ta ra kilala na iubili; ma ra mataina nina di kul valangalanga pa mule me, na ti varogop ma ra vapuak kai ra tultul di kul ia ure nam ra umana kilakilala tuk ta ra iubili. ");
INSERT INTO ksd_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Gala ra umana kilala diat a mangoro, na valilikun ta pakana, nina i varogop, ta nam ra mani di ga kul ia me. ");
INSERT INTO ksd_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Ma gala na paupau ra umana kilala tuk tar ta ra iubili, dir a luk diat, ma na tul tar ta mani, nina ba na topa ia ure nam ra umana kilala dia ki na lua boko. ");
INSERT INTO ksd_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Na ki pire kana luluai da tikai di vavapuak ia a kilakilala; koko na kure vadekdek ia ta ra luaina matam. ");
INSERT INTO ksd_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Ma gala pa di kul valangalanga dari, diat ma ra umana natuna da pala valangalanga diat ta ra kilala na iubili. ");
INSERT INTO ksd_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Tago ra tarai Israel kaugu umana vilavilau; kaugu umana vilavilau iat nina iau ga agure vairop vue diat kan ra gunan Aigipto; iau ra Luluai kavava God. ");
INSERT INTO ksd_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Koko avat a pait kavava ta tabalar, ma koko avat a page ta tabataba nina di ga poka, ba ta pagapaga, ma koko avat a vung ta vat di ga poka ta kavava gunan, upi avat a va timtibum tadav ia, tago iau ra Luluai kavava God. ");
INSERT INTO ksd_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Avat a kodop vake kaugu umana Bung Sabat ma avat a ru kaugu gomgom na pal; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Gala avat a mur kaugu lavur vartuluai, ma avat a kodop vake kaugu lavur varkurai, ma avat a pait diat, ");
INSERT INTO ksd_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ina tul tar ra bata ta kana e, ma ra pia na vuai ma ra umana davai diat a vuai ra vuai diat. ");
INSERT INTO ksd_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Ra e na rarama vuai na pat na vit tana na tuk ra e na rurua na vuai na vain tana, ma ra e na rurua na vuai na vain na tuk ra e na vinauma; avat a en ra avava nian ma avat a maur tana ma avat a ki bulu ta kavava gunan. ");
INSERT INTO ksd_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Ma ina tul tar ra malmal ta ra gunan ma avat a ngo, ma pa ta na na vaburut avat; ma ina vapanie vue ra umana kaina leing kan ra gunan, ma pa ta vinarubu na olo ta kavava gunan. ");
INSERT INTO ksd_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Ma avat a korot mur kavava lavur ebar, ina diat a virua ta ra pakat na vinarubu ta ra luaina mata i vavat; ");
INSERT INTO ksd_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","a ilima ta vavat diat a korot mur tika na mar, ma tika na mar ta vavat dia a korot mur a vinun na arip na marmar, ma kavava lavur ebar diat a virua ta ra pakat na vinarubu ta ra luaina mata i vavat. ");
INSERT INTO ksd_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Ina nuk pa avat, ma ina vatavua avat, ma ina vapeal avat, ma ina vatur kaugu kunubu livuan ta vavat. ");
INSERT INTO ksd_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Avat a ian ta nam i tar vala va, ma avat a tak vue nam i vala va pi are ra kalamana: ");
INSERT INTO ksd_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ma ina page kaugu pal na varbarat livuan ta vavat, ma pa ina milikuane avat. ");
INSERT INTO ksd_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ina vanavana livuan ta vavat, ma iau kavava God ma avat kaugu tarai. ");
INSERT INTO ksd_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Iau ra Luluai kavava God, iau ga agure vairop avat kan ra gunan Aigipto upi koko avat a vilavilau pire diat; ma iau ga tar bubur kavava kip upi avat a pa tutur. ");
INSERT INTO ksd_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Gala pa ava torom tagu, ma gala pa ava pait go ra lavur togotogo par; ");
INSERT INTO ksd_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ma gala avat a milikuane kaugu lavur vartuluai, ma avat a vung vue kaugu lavur varkurai, upi avat a piam vue kaugu lavur togotogo ma kaugu kunubu; ");
INSERT INTO ksd_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ina pait ra dari pire vavat: Ina ubu avat ma ra umana magit nina ba avat a burut i tana, ra ngongo mat, ma ra malamalapang, nina ba na vapanie vue ra nilaun ma ra kiau na mata na gavul tana; avat.a vaume vakuku kavava pat na kon tago kavava umana ebar diat a en ra vuaina tana. ");
INSERT INTO ksd_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ma ina tut ure avat, ma avat a virua ta ra luaina mata i kavava umana ebar; diat dia milikuane avat diat a kure avat, ma avat a lop ba pa di korot avat. ");
INSERT INTO ksd_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Ma gala pa avat a valongore iau ta go diat, ina kita mule avat lavurua na pakana ure kavava lavur varpiam; ");
INSERT INTO ksd_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","ina vabilua ra dekdek i vavat nina ava kolakolo me; ina kure ra bakut upi na da ra palariam ure avat, ma ra pia upi na da ra palariam gobol; ");
INSERT INTO ksd_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","ma avat a vapanie vakuku ra dekdek i vavat, tago kavava umauma pa diat a vuai, ma ra umana davai ta ra gunan pa diat a vuai ra vuai diat. ");
INSERT INTO ksd_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Gala avat a pidimuane iau, ma pa avat a torom tagu, ina tul tar mule ta lavurua na kaina varmonong ta vavat, varogop ma kavava varpiam. ");
INSERT INTO ksd_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ina tulue ra umana king livuan ta vavat, ma diat a long pa ra umana natu i vavat, ma diat a doko kavava umana vavaguai, ma avat a panie vanavana tuk tar kavava lavur nga diat a lingling. ");
INSERT INTO ksd_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Gala pa ava mainge ba ina vaenana pa avat ta go ra umana magit, ma ava pidimuane boko iau, ");
INSERT INTO ksd_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","io, ina pidimuane avat, ma iau iat ina ubu avat lavurua na pakana ure kavava lavur varpiam. ");
INSERT INTO ksd_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ina tulue ra pakat na vinarubu tadav avat, upi da kure avat tago ava ga piam vue ra kunubu; ma avat a parau ta kavava lavur pia na pal, ma ina tulue ra kaina minait livuan ta vavat ma da nur tar avat ta ra lima i kavava umana ebar. ");
INSERT INTO ksd_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Ma ba iau tak vue ra gem nina ava lalaun tana, tika na ubu na topa a vinun na vavina ure ra tunutun, ma da tibatibe ra avava gem ma pa avat a maur tana. ");
INSERT INTO ksd_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Gala pa avat a torom tagu ta go parika, ma avat a pidimuane boko iau, ");
INSERT INTO ksd_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","io, ina pidimuane avat ma ra kankan, ma ina kita avat lavurua na pakana ure kavava lavur varpiam. ");
INSERT INTO ksd_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Ma avat a en ra vio i ra umana natu i vavat, a umana tutana ma ra umana vavina. ");
INSERT INTO ksd_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Ma ina nila vue kavava umana uguugu ta ra lualuana, ma ina pelegi kavava umana tabalar na keake, ma ina vung vartaurane ra lavur minat i vavat taun kavava lavur tabataba; ma ina okole vue avat. ");
INSERT INTO ksd_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Kavava umana pia na pal diat a tamtavul, ma kavava umana gomgom na pal diat a lingling ma pa ina angine kavava lavur bulit i ang na katkat. ");
INSERT INTO ksd_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ma ra gunan na lingling, ma kavava umana ebar nina dia ki tana diat a kaian ure. ");
INSERT INTO ksd_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Ma ina vue vurvurbingitane avat livuan ta ra umana Tematana, ma ina ele pa ra pakat na vinarubu ure avat, ma kavava gunan na lingling, ma na tamtavul kavava umana pia na pal. ");
INSERT INTO ksd_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Damana, ba ra gunan i lingling ma ava ki ta ra langun kai kavava lavur ebar, ra gunan na nunure kana lavur Bung Sabat, maikir, ra gunan na nunure ra ningo, ma na gugu ta kana lavur Bung Sabat. ");
INSERT INTO ksd_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Ba ra gunan i ki na lingling na nunure ra ningo, a ningo nina ba pa i ga nunure ta kavava lavur Bung Sabat ba ava ga ki tana. ");
INSERT INTO ksd_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Ma ure ra ibaiba ta vavat nina dia ki valili, ina vabilua ra bala i diat ba dia ki ta ra gunan kai kadia umana ebar, ma ba dia valongore ra maranga na mapina davai, nina ba ra vuvu i kamkavie vanavana, diat a lop uka tana, da tikai i lop kan ra pakat na vinarubu; ma diat a bura ba pa ta na i korot mur diat. ");
INSERT INTO ksd_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Ba pa ta na i korot mur diat, diat a bura vartaun da di ubu diat ma ra pakat na vinarubu; pa na tale avat upi avat a varubu ma kavava lavur ebar. ");
INSERT INTO ksd_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Avat a panie livuan ta ra umana Tematana; ma ra gunan kai kavava umana ebar na en vue avat. ");
INSERT INTO ksd_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Ma ra ibaiba dia ki valili boko ta vavat diat a tagura vanavana ta kadia varpiam ta ra gunan kai kavava umana ebar, da tama i diat dia ga tagura vanavana na damana ma diat. ");
INSERT INTO ksd_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Ba gala diat a tata kapa ure kadia varpiam, ma ra varpiam kai ra lavur tama i diat nina ba dia ga piam vue iau me, ma gala diat a tata kapa ure kadia varpidimuanai, ");
INSERT INTO ksd_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","nina ba i ga vuna ure kaugu varpidimuanai pire diat ba iau ga tulue diat ta ra langun kai kadia umana ebar; ma gala ra leo na bala i diat i madu, ma dia tul tar diat iat mulai upi ina vakadik diat ure kadia varpiam; ");
INSERT INTO ksd_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ina nuk pa kaugu kunubu ma Iakob, ma kaugu kunubu ma Isak ma kaugu kunubu ma Abaraam; ma ina nuk pa ra gunan. ");
INSERT INTO ksd_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Ma ra gunan bula na ki langalanga kan diat upi na gugu ta kana umana Bung Sabat, ba i ki na lingling upi diat; diat a vatur vake ra varvakadik ai kadia varpiam, tago pa dia ga kapupi kaugu lavur varkurai, ma dia ga vana kan kaugu lavur vartuluai. ");
INSERT INTO ksd_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ma ba dia ki ta ra langun kai kadia umana ebar, pa ina okole vue diat, ma pa ina vana kan diat ure ra dari upi da kamare vakakit vue diat, ma damana da vatamam vue kaugu kunubu ma diat; tago iau ra Luluai kadia God. ");
INSERT INTO ksd_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ma ina nuk pa ra kunubu kai kadia tarai lualua ure diat, nina ba iau ga agure vairop vue diat kan ra gunan Aigipto ta ra luaina mata i ra umana Tematana, upi iau kadia God; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Go diat ra umana vartuluai ma ra umana varkurai ma ra umana tinata na varkurai, nina ra Luluai i ga tul tar ia livuan ta diat ma ra tarai Israel, ta ra luana Sinai, ta ra ngie i Moses. ");
INSERT INTO ksd_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Ma ra Luluai i ga tata pire Moses, ma i ga biti: ");
INSERT INTO ksd_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Una tata pire ra tarai Israel, ma una biti ta diat: Ba ta tutana i kubu tar ta magit ma ra vavalima, da valar ra tarai ure ra Luluai dari: ");
INSERT INTO ksd_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Ure ta tutana ba i a ura vinun kana kilala, ma na tuk tar ta ra laptikai na vinun, na da ra ilima na vinun na mamat na silva, varogop ra mamat ai ra gomgom na pal, ");
INSERT INTO ksd_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ma ona ia ra vavina na varogop ma ra utul a vinun na mamat; ");
INSERT INTO ksd_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ma ona a ilima kana kilala ma na tuk tar a ura vinun na kilala, una luk ia varogop ma ra ura vinun na mamat ure ta tutana, ma ra vinun na mamat ure ta vavina; ");
INSERT INTO ksd_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ma ona i da tika na gai ma na tuk tar ra ilima na kilala, una luk ia varogop ma ra ilima na mamat ure ta tutana ma ra utul a mamat ure ta vavina; ");
INSERT INTO ksd_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ma ona i da laptikai na vinun ma i pirai na kilala, una luk ia varogop ma ra vinun ma a ilima na mamat ure ta tutana, ma ra vinun na mamat ure ta vavina. ");
INSERT INTO ksd_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ma gala ta tikai i luveana, ma pa i tale pi na tul tar ra toto nina u ga vatang ia, da ben pa ia ta ra luaina mata i ra tena tinabar. ma na to kukure tar ika ra toto ta ra luveana, nina i ga kubu tar ra magit ma ra vavalima. ");
INSERT INTO ksd_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Ma ure ta vavaguai, nina ba ra mangana vavaguai i topa ia ba da tul tar ia tai ra Luluai, a lavur mangana vavaguai parika nina ba ta tutana na tul tar ia tai ra Luluai na gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","I tabu ba na vaenana pa ia, ba na kia vue ma ta enana, ta boina ma ra kaina, ba ta kaina ma ra boina; gala na varkiane dir, dir parika dir a gomgom. ");
INSERT INTO ksd_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Ma gala ia ra vavaguai nina pa i gomgom, ma nina ba pa di tul tar ia ure ta vartabar na nian tadav ra Luluai, na kap ra vavaguai ta ra luaina mata i ra tena tinabar; ");
INSERT INTO ksd_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ma ra tena tinabar na to ra mataina tana, ure ra boina ina ure ra kaina; ma da u ra tena tinabar u to ra mataina. da pait ia damana. ");
INSERT INTO ksd_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ma gala ra tutana i mainge ba na kul valangalanga pa ia, na tul tar bula tika na vailimana ta ra mataina u ga toa ure. ");
INSERT INTO ksd_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Ba ta tutana i vakilang vaire kana pal upi kai ra Luluai, ra tena tinabar na gire ba a boina ba a kaina; ma ra tena tinabar na to ra mataina, ma na damana. ");
INSERT INTO ksd_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ma nina i ga vakilang vaire kana pal, gala i mainge ba na kul valangalanga mule, na tul tar bula tika na vailimana ta ra mataina u ga toa ure, ma na kale mule. ");
INSERT INTO ksd_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Ma gala ta tutana na vakilang vaire ta pakana pia ta kana pia ure ra Luluai, una to vardadane ma ra patina di mainge pi da vaume tana; damana ta pakana pia nina di mainge tika na omer na pat na barli ure, da toa ma ra ilima na vinun na mamat na silva. ");
INSERT INTO ksd_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Gala i vakilang kana pia papa ta ra kilala na iubili, kaum toto na tur, ");
INSERT INTO ksd_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","ba gala i vakilang kana pia namur ta ra iubili, ra tena tinabar na to ra mataina vardada ma ra umana kilala tuk tar ba na iubili, ma da vaikilik pa kaum toto. ");
INSERT INTO ksd_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Ma nina i ga vakilang kana pia, gala i mainge ba na kul valangalanga mule, na tul tar bula tika na vailimana ta ra mataina u ga toa ure, ma na kale mule. ");
INSERT INTO ksd_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Gala pa i mainge ba na kul valangalanga ra pia, ba gala i tar ivure pire ta tikai, pa da kul valangalanga mule; ");
INSERT INTO ksd_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","ba di valangalanga nam ra pia ta ra iubili na gomgom ure ra Luluai na da ra pia di ga tibe vaire, ma ra tena tinabar na vatur vake. ");
INSERT INTO ksd_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Gala ta tutana i vakilang vaire ta pakana pia nina i ga kul ia, ma nina ba vakir kai tamana, ure ra Luluai, ");
INSERT INTO ksd_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ra tena tinabar na luk ra umana kilala tuk tar ta ra iubili, ma na vatang kaum toto ure, ma ra tutana na tul tar ra mataina u ga toa, upi ra magit i gomgom ure ra Luluai; ");
INSERT INTO ksd_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","ma ta ra kilala na iubili ra pia na lilikun pire ra tutana nina ba di ga kul pa ia pirana, pire ra tutana nina ba kana apik na tarai dia kale value ra pia. ");
INSERT INTO ksd_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Ma ra lavur mataina parika ba u vatang diat, da vatang diat vardada ma ra mamat kai ra gomgom na pal; a mamat i varogop ma ra vinun ma laptikai na gram (a ngungu auns). ");
INSERT INTO ksd_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Pa ta na na vakilang vaire ra luaina nat na vavaguai upi kai ra Luluai, ba ta bulumakau ba ta sip, tago kai ra Luluai iat. ");
INSERT INTO ksd_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Gala ia ra luaina nat na vavaguai nina ba pa i gomgom, na kul valangalanga pa ia da u toa, ma na tul tar bula tika na vailimana ta ra mataina u ga toa ure; gala pa di ga kul valangalanga pa ia, da ivure da una toa ure. ");
INSERT INTO ksd_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Ia kaka pa da ivure ba pa da kul valangalanga nina ra magit di ga vakilang vaire ure ra Luluai, ta tutana ba ta vavaguai ba ta pakana pia kai ta apik na tarai; ra lavur magit par nina di ga tibe vaire diat, dia gomgom kakit ure ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Pa da kul valangalanga ta tikai nina ba di ga kure pi na mat; a dovotina da doka. ");
INSERT INTO ksd_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Kai ra Luluai ra vavinununa ta kaum pia, ba ra pat na vuai na uma, ba ra vuai na davai, nam parika i gomgom ure ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Ma gala ta tutana na kul valangalanga ta pakana ta kana vavinununa na tul tar bula tika na vailimana me. ");
INSERT INTO ksd_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Ra vavinununa ta ra kikil na bulumakau ba ra kikil na sip, nam kai ra Luluai; ra umana vavinununa tikatikai ta ra kikil na vavaguai ba di luk diat, diat a gomgom ure ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","A tutana pa na vuru ia ba a boina ba a kaina, ma pa na varkiane; ma gala na varkiane, dir par ma nam i ga kia vue dir a gomgom; pa da kul valangalanga mule. ");
INSERT INTO ksd_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Go diat ra lavur vartuluai nina ba ra Luluai i ga tul tar ia tai Moses ure ra tarai Israel ta ra luana Sinai. ");
INSERT INTO ksd_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Ma ra Luluai i ga tata pire Moses ta ra bil Sinai, ta ra pal na varbarat, ta ra luaina bung ta ra vauruana gai ta ra vauruana kilala taun kadia niirop kan ra gunan Aigipto, dari: ");
INSERT INTO ksd_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Avat a luk ra kor na tarai Israel, ta. kadia lavur vuna tarai, ma ta kadia lavur apik na tarai, da ra niluluk i ra iang i diat; da luk ra ulu i diat ra lavur tutana par, ");
INSERT INTO ksd_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","kadia kilala i ura vinun, ba i bolo ra ura vinun, nina dia topa ra vinarubu ta diat ra tarai Israel; amur ma Aron amur a luk diat ta kadia lavur kor. ");
INSERT INTO ksd_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Tika na tutana ta ra lavur vuna tarai tikatikai, nina i lualua ta kana apik na tarai, na maravut amur. ");
INSERT INTO ksd_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Ma go ra iang i diat ra umana tutana ba diat a tur maravut amur: ta ra vuna tarai Ruben, Elisur natu i Sedeur. ");
INSERT INTO ksd_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Ta ra vuna tarai Simeon, Selumiel natu i Surisadai. ");
INSERT INTO ksd_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Ta ra vuna tarai Iuda, Nason natu i Aminadab. ");
INSERT INTO ksd_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Ta ra vuna tarai Isakar, Netanel natu i Suar. ");
INSERT INTO ksd_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Ta ra vuna tarai Sebulun, Eliab natu i Kelon. ");
INSERT INTO ksd_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Ta ra umana bul mur tai Iosep: ta ra vuna tarai Epraim, Elisama natu i Amiud; ta ra vuna tarai Manase, Gamaliel natu i Pedasur. ");
INSERT INTO ksd_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Ta ra vuna tarai Beniamin, Abidan natu i Gideoni. ");
INSERT INTO ksd_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Ta ra vuna tarai Dan, Akieser natu i Amisadai. ");
INSERT INTO ksd_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Ta ra vuna tarai Aser, Pagiel natu i Okran. ");
INSERT INTO ksd_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Ta ra vuna tarai Gad, Eliasap natu i Deuel. ");
INSERT INTO ksd_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Ta ra vuna tarai Naptali, Akira natu i Enan. ");
INSERT INTO ksd_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Di ga oro pa go diat ta ra kor na tarai, a umana luluai ta ra lavur vuna tarai; a umana lualua ta ra lavur apik na tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Ma Moses ma Aron dir ga agur pa go ra umana tutana, nina di ga vatang ra iang i diat, ");
INSERT INTO ksd_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ma dir ga varurue ra tarai ta ra luaina bung ta ra vauruana gai, ma dia ga vatang tar ra iang i diat ta kadia lavur apik na tarai, ma ta kadia lavur kakang, da ra niluluk i ra iang i diat tikatikai, diat i ga ura vinun kadia kilala, ba i ga bolo ra ura vinun. ");
INSERT INTO ksd_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Da ra Luluai i ga vartuluai tana pire Moses, damana i ga luk diat ta ra bil Sinai. ");
INSERT INTO ksd_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Ma ra umana bul mur tai Ruben, a luaina natu i Israel, a tarai diat parika, ta kadia lavur apik na tarai, ma ta kadia lavur kakang, da ra niluluk i ra iang i diat tikatikai, a lavur tutana ba i ga ura vinun kadia kilala, ba i ga bolo ra ura vinun, nina dia ga topa ra vinarubu; ");
INSERT INTO ksd_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","di ga luk diat ta ra vuna tarai Ruben, ba a ivat na vinun ma laptikai na arip, ma a ilima na mar. ");
INSERT INTO ksd_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Ma ra umana bul mur tai Simeon, a tarai diat parika, ta kadia lavur apik na tarai, ma ta kadia lavur kakang, nina di ga luk diat, da ra niluluk i ra iang i diat tikatikai, a lavur tutana ba i ga ura vinun kadia kilala, ba i ga bolo ra ura vinun, nina dia ga topa ra vinarubu; ");
INSERT INTO ksd_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","di ga luk diat ta ra vuna tarai Simeon, ba a ilima na vinun ma lavuvat na arip, ma a utul a mar. ");
INSERT INTO ksd_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Ma ra umana bul mur tai Gad, a tarai diat parika, ta kadia lavur apik na tarai, ma ta kadia lavur kakang, da ra niluluk i ra iang i diat, diat ba i ga ura vinun kadia kilala, ba i ga bolo ra ura vinun, nina dia ga topa ra vinarubu; ");
INSERT INTO ksd_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","di ga luk diat ta ra vuna tarai Gad, ba a ivat na vinun ma a ilima na arip, ma laptikai na mar ma a ilima na vinun. ");
INSERT INTO ksd_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Ma ra umana bul mur tai Iuda, a tarai diat parika, ta kadia lavur apik na tarai, ma ta kadia lavur kakang, da ra niluluk i ra iang i diat, diat ba i ga ura vinun kadia kilala, ba i ga bolo ra ura vinun, nina dia ga topa ra vinarubu; ");
INSERT INTO ksd_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","di ga luk diat ta ra vuna tarai Iuda, ba lavurua na vinun ma a ivat na arip, ma laptikai na mar. ");
INSERT INTO ksd_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Ma ra umana bul mur tai Isakar, a tarai diat parika, ta kadia lavur apik na tarai ma ta kadia lavur kakang, da ra niluluk i ra iang i diat, diat ba i ga ura vinun kadia kilala, ba i ga bolo ra ura vinun, nina dia ga topa ra vinarubu; ");
INSERT INTO ksd_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","di ga luk diat ta ra vuna tarai Isakar, ba a ilima na vinun ma a ivat na arip, ma a ivat na mar. ");
INSERT INTO ksd_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Ma ra umana bul mur tai Sebulun, a tarai diat parika, ta kadia lavur apik na tarai, ma ta kadia lavur kakang, da ra niluluk i ra iang i diat, diat ba i ga ura vinun kadia kilala, ba i ga bolo ra ura vinun, nina dia ga topa ra vinarubu; ");
INSERT INTO ksd_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","di ga luk diat ta ra vuna tarai Sebulun, ba a ilima na vinun ma lavurua na arip, ma a ivat na mar. ");
INSERT INTO ksd_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Ma ra umana bul mur tai Iosep, a umana bul mur tai Epraim, a tarai diat parika, ta kadia lavur apik na tarai, ma ta kadia lavur kakang, da ra niluluk i ra iang i diat, diat ba i ga ura vinun kadia kilala, ba i ga bolo ra ura vinun, nina dia ga topa ra vinarubu; ");
INSERT INTO ksd_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","di ga luk diat ta ra vuna tarai Epraim, ba a ivat na vinun na arip, ma a ilima na mar. ");
INSERT INTO ksd_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Ma ra umana bul mur tai Manase, a tarai diat parika, ta kadia lavur apik na tarai, ma ta kadia lavur kakang, da ra niluluk i ra iang i diat, diat ba i ga ura vinun kadia kilala, ba i ga bolo ra ura vinun, nina dia topa ra vinarubu; ");
INSERT INTO ksd_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","di ga luk diat ta ra vuna tarai Manase, ba a utul a vinun ma a urua na arip, ma a ura mar. ");
INSERT INTO ksd_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Ma ra umana bul mur tai Beniamin, a tarai diat parika, ta kadia lavur apik na tarai, ma ta kadia lavur kakang, da ra niluluk i ra iang i diat, diat ba i ga ura vinun kadia kilala, ba i ga bolo ra ura vinun, nina dia ga topa ra vinarubu; ");
INSERT INTO ksd_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","di ga luk diat ta ra vuna tarai Beniamin, ba a utul a vinun ma a ilima na arip, ma a ivat na mar. ");
INSERT INTO ksd_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Ma ra umana bul mur tai Dan, a tarai diat parika, ta kadia lavur apik na tarai, ma ta kadia lavur kakang, da ra niluluk i ra iang i diat, diat ba i ga ura vinun kadia kilala, ba i ga bolo ra ura vinun, nina dia ga topa ra vinarubu; ");
INSERT INTO ksd_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","di ga luk diat ta ra vuna tarai Dan, ba laptikai na vinun ma a urua na arip, ma lavurua na mar. ");
INSERT INTO ksd_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Ma ra umana bul mur tai Aser, a tarai diat parika, ta kadia lavur apik na tarai, ma ta kadia lavur kakang, da ra niluluk i ra iang i diat, diat ba i ga ura vinun kadia kilala, ba i ga bolo ra ura vinun, nina dia ga topa ra vinarubu; ");
INSERT INTO ksd_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","di ga luk diat ta ra vuna tarai Aser, ba a ivat na vinun ma tika na arip, ma a ilima na mar. ");
INSERT INTO ksd_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Ma ra umana bul mur tai Naptali, a tarai diat parika, ta kadia lavur apik na tarai, ma ta kadia lavur kakang, da ra niluluk i ra iang i diat, diat ba i ga ura vinun kadia kilala, ba i ga bolo ra ura vinun, nina dia ga topa ra vinarubu; ");
INSERT INTO ksd_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","di ga luk diat ta ra vuna tarai Naptali, ba a ilima na vinun ma a utul a arip, ma a ivat na mar. ");
INSERT INTO ksd_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Go diat nina dia ga luk diat, Moses ma Aron ma ra vinun ma a urua na luluai kai ra tarai Israel, ta ra umana vuna tarai tikatikai. ");
INSERT INTO ksd_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Damana diat par di ga luk diat ta ra tarai Israel, ta kadia lavur apik na tarai, diat ba i ga ura vinun kadia kilala, ba i ga bolo ra ura vinun, nina dia ga topa ra vinarubu ta diat ra tarai Israel; ");
INSERT INTO ksd_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","diat par di ga luk diat ba laptikai na mar ma a utul a arip, ma a ilima na mar ma a ilima na vinun. ");
INSERT INTO ksd_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Ia kaka, pa di ga luk ra vuna tarai Levi varurung ma diat. ");
INSERT INTO ksd_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Tago ra Luluai i ga biti tai Moses, dari: ");
INSERT INTO ksd_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Ia kaka ra vuna tarai Levi, koko una luk diat, ma koko una kap ra niluluk i diat livuan ta ra tarai Israel; ");
INSERT INTO ksd_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ma una tibe ra tarai Levi upi diat a varvakai ta ra pal na varbarat, ma ta kana lavur tabarikik; diat a puak pa ra pal, ma ra lavur tabarikik tana; diat a pait ra lavur papalum tana, ma diat a vatur kadia umana pal na mal kikil ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Ma ta nam ra bung ba ra pal na varbarat na kakari, a tarai Levi diat a pala pa ia; ma ba da vatur ra pal na varbarat, a tarai Levi diat a vatut ia; ma gala ta tutana vakuku na vana maravai tana, da doka. ");
INSERT INTO ksd_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Ma ra tarai Israel diat a vatur kadia lavur pal na mal, tikatikai ta kana gunan, ma tikatikai ta kana vakilang, varogop ma kadia lavur kor. ");
INSERT INTO ksd_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Ma ra tarai Levi diat a vatur kadia umana pal na mal kikil ra pal na varbarat, upi koko ra kankan na vana rikai taun ra kor na tarai Israel; ma ra tarai Levi diat a balaure ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Ma ra tarai Israel dia ga pait ia damana; dia ga pait ot pa go ra lavur magit ra Luluai i ga vartuluai tana pire Moses. ");
INSERT INTO ksd_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Ma ra Luluai i ga tata pire Moses ma pire Aron, dari: ");
INSERT INTO ksd_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","A tarai Israel diat a vatur kadia lavur pal na mal tikatikai ta kana vakilang varurung ma ra umana vakilang kai kana apik na tarai: kadia lavur pal na mal diat a tur kikil ra pal na varbarat ta ra lavur papar. ");
INSERT INTO ksd_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Ma diat ta ra vakilang kai ra gunan Iuda, ta kadia lavur kor, diat a vatur kadia lavur pal na mal ta ra papar a taur, ta ra pakana ba ra keake i kuma rikai tana; ma Nason natu i Aminadab na luluai pire ra vuna tarai Iuda. ");
INSERT INTO ksd_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Diat di ga luk diat ta kana kor, lavurua na vinun ma a ivat na arip, ma laptikai na mar diat. ");
INSERT INTO ksd_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Ma diat ta ra vuna tarai Isakar diat a vatur kadia lavur pal na mal maravai pirana; ma Netanel natu i Suar na luluai pire ra vuna tarai Isakar; ");
INSERT INTO ksd_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","ma diat di ga luk diat ta kana kor, a ilima na vinun ma a ivat na arip, ma a ivat na mar diat; ");
INSERT INTO ksd_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","ma diat ta ra vuna tarai Sebulun bula; ma Eliab natu i Kelon na luluai pire ra vuna tarai Sebulun; ");
INSERT INTO ksd_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","ma diat di ga luk diat ta kana kor, a ilima na vinun ma lavurua na arip, ma a ivat na mar diat. ");
INSERT INTO ksd_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Diat par di ga luk diat ta ra gunan Iuda, tika na mar ma lavutul a vinun ma laptikai na arip, ma a ivat na mar diat, ta kadia lavur kor. Diat a lua ta ra vinavana. ");
INSERT INTO ksd_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","A vakilang kai ra gunan Ruben, ta kana lavur kor, na tur ta ra papar a taubar; ma Elisur natu i Sedeur na luluai pire ra vuna tarai Ruben; ");
INSERT INTO ksd_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","ma diat di ga luk diat ta kana kor, a ivat na vinun ma laptikai na arip, ma a ilima na mar diat. ");
INSERT INTO ksd_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Ma diat ta ra vuna tarai Simeon diat a vatur kadia lavur pal na mal maravai pirana; ma Selumiel natu i Surisadai na luluai pire ra vuna tarai Simeon; ");
INSERT INTO ksd_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","ma diat di ga luk diat ta kana kor, a ilima na vinun ma lavuvat na arip, ma a utul a mar diat; ");
INSERT INTO ksd_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","ma diat ta ra vuna tarai Gad bula; ma Eliasap natu i Reuel na luluai pire ra vuna tarai Gad; ");
INSERT INTO ksd_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","ma diat di ga luk diat ta kana kor, a ivat na vinun ma a ilima na arip, ma laptikai na mar ma a ilima na vinun diat. ");
INSERT INTO ksd_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Diat par di ga luk diat ta ra guna Ruben, tika na mar ma a ilima na vinun ma tikai na arip, ma a ivat na mar ma a ilima na vinun diat, ta kadia lavur kor. Diat a vauruana ta ra vinavana. ");
INSERT INTO ksd_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Ma ra pal na varbarat, ma diat ta ra gunan kai ra tarai Levi, diat a vanavana livuan; kadia vinavana na da kadia vavatur na pal, tikatikai na vanavana da kana vakilang ta kana pakana. ");
INSERT INTO ksd_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","A vakilang kai ra gunan Epraim, ta kana lavur kor, na tur ta ra papar a taoai; ma Elisama natu i Amiud na luluai pire ra vuna tarai Epraim; ");
INSERT INTO ksd_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ma diat di ga luk diat ta kana kor, a ivat na vinun na arip, ma a ilima na mar diat. ");
INSERT INTO ksd_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Ma diat ta ra vuna tarai Manase diat a ki maravai pirana; Gamaliel natu i Pedasur na luluai pire ra vuna tarai Manase; ");
INSERT INTO ksd_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ma diat di ga luk diat ta kana kor, a utul a vinun ma a ura arip, ma a ura mar diat; ");
INSERT INTO ksd_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","ma diat ta ra vuna tarai Beniamin bula; ma Abidan natu i Gideoni na luluai pire ra vuna tarai Beniamin; ");
INSERT INTO ksd_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","ma diat di ga luk diat ta kana kor, a utul a vinun ma a ilima na arip, ma a ivat na mar. ");
INSERT INTO ksd_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Diat par di ga luk diat ta ra gunan Epraim, tika na mar ma lavutul na arip, ma tika na mar diat, ta kadia lavur kor. Diat a vautuluna ta ra vinavana. ");
INSERT INTO ksd_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","A vakilang kai ra gunan Dan, ta kana lavur kor, na tur ta ra papar a labur; ma Akieser natu i Amisadai na luluai pire ra vuna tarai Dan; ");
INSERT INTO ksd_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ma diat di ga luk diat ta kana kor, laptikai na vinun ma a ura arip, ma lavurua na mar diat. ");
INSERT INTO ksd_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Ma diat ta ra vuna tarai Aser diat a vatur kadia lavur pal na mal maravai pirana; ma Pagiel natu i Okran na luluai pire ra vuna tarai Aser; ");
INSERT INTO ksd_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","ma diat di ga luk diat ta kana kor, a ivat na vinun ma tika na arip, ma a ilima na mar diat; ");
INSERT INTO ksd_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","ma diat ta ra vuna tarai Naptali bula; ma Akira natu i Enan na luluai pire ra vuna tarai Naptali; ");
INSERT INTO ksd_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","ma diat di ga luk diat ta kana kor, a ilima na vinun ma a utul a arip, ma a ivat na mar diat. ");
INSERT INTO ksd_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Diat par di ga luk diat ta ra gunan Dan, tika na mar ma a ilima na vinun ma lavurua na arip, ma laptikai na mar diat. Diat ma kadia lavur vakilang diat a murmur bat. ");
INSERT INTO ksd_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Go diat di ga luk diat ta ra tarai Israel ta kadia lavur apik na tarai; diat par di ga luk diat ta ra ivat na gunan ta kadia lavur kor, laptikai na mar ma a utul a arip, ma a ilima na mar ma a ilima na vinun. ");
INSERT INTO ksd_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ia kaka, pa di ga luk ra tarai Levi varurung ma ra tarai Israel; da ra Luluai i ga vartuluai tana pire Moses. ");
INSERT INTO ksd_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","A tarai Israel dia ga pait ia damana; da nam parika ra Luluai i ga vartuluai tana pire Moses, damana dia ga vatur kadia lavur vakilang, ma dia ga vanavana, tikatikai ta kana apik na tarai ma ta kana kakang. ");
INSERT INTO ksd_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Go ra umana taun tarai kai Aron ma Moses ta ra bung ba ra Luluai i ga tata pire Moses ta ra luana Sinai. ");
INSERT INTO ksd_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Ma go ra iang i diat ra umana natu i Aron. Nadab a luaina, Abiu, Eleasar, ma Itamar. ");
INSERT INTO ksd_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Go ra iang i diat ra umana natu i Aron, ra umana tena tinabar nina di ga ku diat, ma i ga vadoane diat upi diat a pait ra papalum na tena tinabar. ");
INSERT INTO ksd_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Ma Nadab ma Abiu dir ga mat ta ra luaina mata i ra Luluai, ba dir ga tul tar ra iap vakuku ta ra luaina mata i ra Luluai, ta ra bil Sinai, ba pa dir ga vangala ta natu i dir; ma Eleasar ma Itamar dir ga pait ra papalum na tena tinabar ta ra luaina mata i Aron tama i dir. ");
INSERT INTO ksd_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Ma ra Luluai i ga biti tai Moses dari. ");
INSERT INTO ksd_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Una agure pa ra vuna tarai Levi, ma una vatur diat ta ra luaina mata i Aron ra tena tinabar, upi diat a toratorom tana. ");
INSERT INTO ksd_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ma diat a varvakai pirana, ma pire ra tarai par ta ra pal na varbarat, ma diat a pait ra lavur papalum ta ra pal. ");
INSERT INTO ksd_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Ma diat a balaure ra lavur tabarikik ure ra pal na varbarat, ma diat a varvakai pire ra tarai Israel, upi diat a pait ra lavur papalum ta ra pal. ");
INSERT INTO ksd_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Ma una tul tar ra tarai Levi tai Aron ma ra umana natuna; kana tiniba diat ure ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Ma una tibe Aron ma ra umana natuna upi diat a pait ra papalum na tena tinabar; ma ona ta tutana vakuku na vana maravai, da doka. ");
INSERT INTO ksd_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Ma ra Luluai i ga biti tai Moses dari: ");
INSERT INTO ksd_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Gire, iau tar kia ra lavur luaina natu i ra tarai Israel ma ra tarai Levi; kaugu ra tarai Levi; ");
INSERT INTO ksd_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","tago kaugu ra lavur luaina bul; ta nam ra bung ba iau ga ubu ra lavur luaina ta ra gunan Aigipto, iau ga vatabue ra lavur luaina ta ra tarai Israel piragu, a tarai ma ra lavur vavaguai; ina vatur vake diat; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Ma ra Luluai i ga tata pire Moses ta ra bil Sinai, dari: ");
INSERT INTO ksd_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Una luk ra umana bul mur tai Levi ta kadia lavur apik na tarai, ma kadia lavur kakang; una luk ra lavur tutana ba dia ga laun vue tika na gai, ba i ga bolo tika na gai. ");
INSERT INTO ksd_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Ma Moses i ga luk diat da ra tinata kai ra Luluai, da i ga vartuluai pirana. ");
INSERT INTO ksd_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Ma go ra iang i dital ra utul a natu i Levi: Gerson, ma Koat, ma Merari. ");
INSERT INTO ksd_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Mago ra iang i dir ra ura natu i Gerson ta kadir apik na tarai: Libni ma Simei; ");
INSERT INTO ksd_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","ma ra umana natu i Koat ta kadia apik na tarai: Amram, Isar, Kebron, ma Usiel; ");
INSERT INTO ksd_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","ma ra ura natu i Merari ta kadir apik na tarai: Mali ma Musi. Go ra umana apik na tarai ta ra vuna tarai Levi, da kadia lavur kakang. ");
INSERT INTO ksd_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Ta ra apik na tarai Gerson, go ra ura kakang Libni ma Simei; go ra ura kakang tai Gerson. ");
INSERT INTO ksd_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Diat di ga luk diat, da ra niluluk i ra lavur tutana ba dia ga laun vue tika na gai, ba i ga bolo tika na gai, lavurua na arip, ma a ilima na mar diat. ");
INSERT INTO ksd_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Diat ta ra apik na tarai Gerson diat a vatur kadia lavur pal na mal ta ra papar a taoai ta ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Ma Eliasap natu i Lael na luluai pire ra apik na tarai Gerson. ");
INSERT INTO ksd_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Ma ra tiniba kai ra umana natu i Gerson ta ra pal na varbarat na dari: ra pal, ma ra mal na tubatuba, ma ra tubatuba arama tana, ma ra mal na poraporo ta ra pal na varbarat, ");
INSERT INTO ksd_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ma ra lavur mal na liplip, ma ra mal na poraporo ta ra bala na gunan, nina i tur kikil ra pal ma ra uguugu na vartabar, ma ra lavur vinau ure ra papalum tana. ");
INSERT INTO ksd_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Ta ra apik na tarai Koat, go ra ivat na kakang Amram, Isar, Kebron ma Usiel; go ra ivat na kakang tai Koat. ");
INSERT INTO ksd_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Diat di ga luk diat, da ra niluluk i ra lavur tutana ba dia ga laun vue tika na gai, ba i ga bolo tika na gai, lavutul na arip ma laptikai na mar diat, ma dia ga pait ra lavur papalum ta ra gomgom na pal. ");
INSERT INTO ksd_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Diat ta ra apik na tarai Koat diat a vatur kadia lavur pal na mal ta ra papar a taubar ta ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Ma Elisapan natu i Usiel na luluai pire ra apik na tarai Koat. ");
INSERT INTO ksd_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Ma kadia tiniba na dari: ra bok na kunubu, ma ra vuvuvung na nian, ma ra turtur na birao, ma ra ura uguugu na vartabar, ma ra lavur la ure ra gomgom na pal nina dia papalum me, ma ra mal na poraporo; ra lavur papalum ta go diat. ");
INSERT INTO ksd_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Ma Eleasar natu i Aron ra tena tinabar na lualua ta dital ra utul a luluai kai ra vuna tarai Levi, ma na kure diat dia balaure ra gomgom na pal. ");
INSERT INTO ksd_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Ta ra apik na tarai Merari, go ra ura kakang Mali ma Musi; go ra ura kakang tai Merari. ");
INSERT INTO ksd_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Diat di ga luk diat, da ra niluluk i ra lavur tutana ba dia ga laun vue tika na gai, ba i ga bolo tika na gai, laptikai na arip ma a ura mar diat. ");
INSERT INTO ksd_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Ma Suriel natu i Abikail i ga luluai pire diat ra apik na tarai Merari; diat a vatur kadia lavur pal na mal ta ra papar a labur ta ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Ma ra tiniba kai ra umana natu i Merari na dari: ra lavur ur na pal, ma kadia lavur davai na vabolo, ma kadia lavur tukal, ma kadia lavur kiki, ma kadia lavur magit na papalum; ra lavur papalum ta go diat; ");
INSERT INTO ksd_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ma ra lavur tukal ure ra liplip kikil ra bala na gunan, ma kadia lavur kiki, ma kadia lavur ot, ma kadia lavur vinau. ");
INSERT INTO ksd_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Ma Moses ma Aron ma ra umana natuna diat a vatur kadia lavur pal na mal ta ra papar a taur ta ra luaina mata i ra pal na varbarat ta ra pakana ba ra keake i kuma rikai tana; diat a pait ra lavur varvakai ta ra gomgom na pal ure ra tarai Israel; ma gala ta tutana vakuku na vana maravai, da doka. ");
INSERT INTO ksd_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Ma diat par ba Moses ma Aron dir ga luk diat ta ra tarai Levi, da ra vartuluai kai ra Luluai, ta kadia lavur apik na tarai, a lavur tutana ba dia ga laun vue tika na gai, ba i ga bolo tika na gai, a ura vinun ma a ura arip na marmar diat. ");
INSERT INTO ksd_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Ma ra Luluai i ga biti tai Moses: Una luk ra lavur luaina bul tutana kai ra tarai Israel, ba dia tar laun vue tika na gai, ba i tar bolo tika na gai, ma una kap ra niluluk i ra iang i diat. ");
INSERT INTO ksd_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Ma una kia ra lavur luaina natu i ra tarai Israel ma ra tarai Levi upi kaugu diat; iau ra Luluai; ma una kia ra lavur luaina nat na vavaguai ma ra lavur vavaguai kai ra tarai Levi. ");
INSERT INTO ksd_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Ma Moses i ga luk ra lavur luaina natu i ra tarai Israel, da ra Luluai i ga vartuluai pirana. ");
INSERT INTO ksd_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Ma diat di ga luk diat, ra lavur luaina bul tutana da ra niluluk i ra iang i diat, ba dia ga laun vue tika na gai, ba i ga bolo tika na gai, a ura vinun ma a ura arip, ma a ura mar ma lavurua na vinun ma a utul diat. ");
INSERT INTO ksd_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Ma ra Luluai i ga tata pire Moses, dari: ");
INSERT INTO ksd_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Una kia ra lavur luaina natu i ra tarai Israel ma ra tarai Levi, ma una kia kadia lavur vavaguai ma ra lavur vavaguai kai ra tarai Levi; ma ra tarai Levi kaugu diat; iau ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Ma upi da kul valaun pa ra ura mar ma lavurua na vinun ma a utul a luaina natu i ra tarai Israel, nina dia ki ak ta ra niluluk i ra tarai Levi, ");
INSERT INTO ksd_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","una vatur vake a ilima na pakana mani ure diat tikatikai, da ra pakana mani kai ra gomgom na pal, nina a vinun ma laptikai na gram (a ngungu auns) tana; ");
INSERT INTO ksd_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ma una tul tar ra mani nina di kul valaun diat me tai Aron ma ra umana natuna. ");
INSERT INTO ksd_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Ma Moses i ga vatur vake ra mani na varkul ta diat dia ga ki ak ta ra niluluk i diat di ga kia valaun diat ma ra tarai Levi; ");
INSERT INTO ksd_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","i ga vatur vake ra mani ta ra lavur luaina natu i ra tarai Israel, tika na arip ma a utul a mar ma laptikai na vinun ma a ilima na pakana mani, da ra pakana mani kai ra gomgom na pal. ");
INSERT INTO ksd_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Ma Moses i ga tul tar ra mani na varkul tai Aron ma ra umana natuna, da ra tinata kai ra Luluai, nina ra Luluai i ga vartuluai tana pire Moses. ");
INSERT INTO ksd_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Ma ra Luluai i ga tata pire Moses ma pire Aron, dari: ");
INSERT INTO ksd_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Amur a luk ra umana natu i Koat ta ra umana natu i Levi, ta kadia lavur apik na tarai ma ta kadia lavur kakang, ");
INSERT INTO ksd_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","diat ba kadia kilala i tur livuan papa ta ra utul a vinun tuk tar ta ra ilima na vinun, diat par dia topa ra papalum, upi diat a pait ra lavur varvakai ta ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Go ia ra papalum kai ra umana natu i Koat ta ra pal na varbarat, ta ra magit i gomgom kakit: ");
INSERT INTO ksd_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","ba di vaninara upi ra vinavana, Aron ma ra umana natuna diat a ruk, ma diat a pala ra mal na rurua kutu, ma diat a pulu ra bok na varvai me; ");
INSERT INTO ksd_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ma diat a tuba ma ra pal a me, ma diat a talare tika na mal i blu marut taun ia, ma diat a ule tar ra ura kip tana. ");
INSERT INTO ksd_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Ma diat a talare ta tika na mal i blu marut taun ra vuvuvung na Gem na Ginigira, ma diat a vung ra umana plet, ma ra umana la na mi, ma ra umana la, ma ra umana pal a tava ure ra tinabar na nimomo tana; ma ra Gem na Ginigira na ki tana; ");
INSERT INTO ksd_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ma diat a talare tika na mal meme taun diat, ma diat a tuba ma ra pal a me, ma diat a ule tar ra ura kip tana. ");
INSERT INTO ksd_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Ma diat a tak pa ra mal i blu marut, ma diat a pulu ra turtur na birao, ma kana lavur lamp, ma kana kia, ma kana lavur la, ma ra lavur la na dangi tana, nina dia papalum me; ");
INSERT INTO ksd_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","ma diat a pulu ia ma kana lavur la bula ma ra pal a me, ma diat a vung ia tai tika na kip. ");
INSERT INTO ksd_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Ma diat a talare tika na mal i blu marut taun ra uguugu na goled, ma diat a tuba ma ra pal a me, ma diat a ule tar ra ura kip tana; ");
INSERT INTO ksd_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","ma diat a vung ra lavur magit na papalum, nina dia pait ra papalum me ta ra gomgom na pal, tai tika na mal i blu marut, ma diat a pulu diat ma ra pal a me, ma diat a vung diat tai tika na kip. ");
INSERT INTO ksd_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Ma diat a tak vue ra kabu na iap kan ra uguugu na vartabar, ma diat a talare ra mal i meme marut taun ia; ");
INSERT INTO ksd_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","ma diat a vung kana lavur la tana, nina dia pait ra papalum me, a umana la na kabu, ma ra umana inging, ma ra umana kakakal ma ra umana la na tava, a lavur tabarikik ure ra uguugu; ma diat a talare ra pal a me taun ia upi da tuba, ma diat a ule tar ra ura kip tana. ");
INSERT INTO ksd_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Ma ba Aron ma ra umana natuna dia ga pulu vapar ra gomgom na pal, ma ra lavur tabarikik ure ra gomgom na pal, ba di vaninara upi ra vinavana, a umana natu i Koat diat a pot upi diat a puak ia; ma koko diat a bili ra magit i gomgom, kan diat a mat. Go ra umana magit ia ra kinakap kai ra umana natu i Koat ta ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Ma Eleasar natu i Aron ra tena tinabar na balaure ra dangi ure ra kapa, ma ra bulit i ang na katkat, ma ra plaua ure ra tinabar, ma ra dangi na varku; na balaure ra pal na mal ma ra lavur magit tana, ra gomgom na pal, ma ra ana lavur tabarikik. ");
INSERT INTO ksd_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Ma ra Luluai i ga tata pire Moses ma pire Aron, dari: ");
INSERT INTO ksd_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Koko avat a kutu vue ra apik na tarai Koat kan ra vuna tarai Levi; ");
INSERT INTO ksd_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","ma avat a pait ia dari pire diat,. upi diat a laun ma koko diat a mat, ba dia tadav ra magit i gomgom kakit: Aron ma ra umana natuna diat a ruk ma diat a tibe diat, tikatikai ta kana papalum ma ta kana kinakap; ");
INSERT INTO ksd_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","ma koko ta ik a pakana diat a ruk upi diat a bobe ra magit i gomgom, kan diat a mat. ");
INSERT INTO ksd_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Ma ra Luluai i ga tata pire Moses, dari: ");
INSERT INTO ksd_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Una luk ra umana natu i Gerson bula, ta kadia lavur apik na tarai ma ta kadia lavur kakang, ");
INSERT INTO ksd_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","diat ba kadia kilala i tur livuan papa ta ra utul a vinun tuk tar ta ra ilima na vinun, diat par dia topa ra papalum, upi diat a pait ra lavur varvakai ta ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Go ia ra tiniba na papalum kai ra apik na tarai Gerson, a papalum ma ra kinakap: ");
INSERT INTO ksd_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","diat a puak ra lavur mal ure ra pal, ma ra pal na varbarat, kana lavur mal na tubatuba, ma ra pal a me arama liu tana, ma ra mal na poraporo ta ra matakilalat i ra pal na varbarat; ");
INSERT INTO ksd_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ma ra lavur mal ure ra liplip ta ra bala na gunan, ma ra mal na poraporo ta ra matakilalat i ra bala na gunan kikil ra pal ma ra uguugu na vartabar, ma kadia lavur vinau, ma kadia lavur magit na papalum; diat a pait ra lavur papalum ta go diat. ");
INSERT INTO ksd_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Aron ma ra umana natuna diat a kure ra lavur papalum kai ra umana natu i Gerson, kadia lavur kinakap ma kadia lavur papalum; ma avat a tibe tar kadia lavur kinakap ta diat. ");
INSERT INTO ksd_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Go ia ra papalum kai ra apik na tarai Gerson ta kadia lavur kakang ta ra pal na varbarat; ma Itamar natu i Aron ra tena tinabar na kure diat. ");
INSERT INTO ksd_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Ma ure ra umana natu i Merari, una luk diat ta kadia lavur apik na tarai, ma ta kadia lavur kakang, ");
INSERT INTO ksd_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","diat ba kadia kilala i tur livuan papa ta ra utul a vinun tuk tar ta ra ilima na vinun, diat par dia topa ra papalum, upi diat a pait ra lavur varvakai ta ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Go ia kadia tiniba na kinakap da kadia lavur papalum ta ra pal na varbarat: a umana ur na pal, ma kana umana davai na vabolo, ma kana umana tukal, ma kana umana kiki; ");
INSERT INTO ksd_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ma ra umana tukal ure ra liplip kikil ra bala na gunan, ma kana umana kiki, ma kana umana ot, ma kana umana vinau, ma kana umana magit na papalum; diat a pait ra lavur papalum ta go diat; ma avat a vatang tar ra umana tiniba na kinakap ta diat. ");
INSERT INTO ksd_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Go ia ra tiniba na papalum kai ra apik na tarai Merari, da kadia lavur papalum ta ra pal na varbarat, ma Itamar natu i Aron ra tena tinabar na kure diat. ");
INSERT INTO ksd_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Ma Moses ma Aron ma ra umana luluai kai ra tarai dia ga luk ra umana natu i Koat ta kadia lavur apik na tarai ma ta kadia lavur kakang, ");
INSERT INTO ksd_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","diat ba kadia kilala i ga tur livuan papa ta ra utul a vinun tuk tar ta ra ilima na vinun, diat par dia ga topa ra papalum, upi diat a pait ra lavur varvakai ta ra pal na varbarat; ");
INSERT INTO ksd_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","diat di ga luk diat ta kadia lavur apik na tarai, a ura arip ma lavurua na mar ma a ilima na vinun diat. ");
INSERT INTO ksd_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Go ra niluluk i diat nina Moses ma Aron dir ga luk diat ta ra apik na tarai Koat, nina dia varvakai ta ra pal na varbarat, da ra vartuluai kai ra Luluai ta ra ngie i Moses. ");
INSERT INTO ksd_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Ma di ga luk ra umana natu i Gerson ta kadia lavur apik na tarai ma ta kadia lavur kakang, ");
INSERT INTO ksd_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","diat ba kadia kilala i ga tur livuan papa ta ra utul a vinun tuk tar ta ra ilima na vinun, diat par dia ga topa ra papalum, upi diat a pait ra lavur varvakai ta ra pal na varbarat; ");
INSERT INTO ksd_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","diat di ga luk diat ta kadia lavur apik na tarai, ma ta kadia lavur kakang, a ura arip ma laptikai na mar ma a utul a vinun diat. ");
INSERT INTO ksd_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Go ra niluluk i diat nina Moses ma Aron dir ga luk diat ta ra apik na tarai Gerson, nina dia ga varvakai ta ra pal na varbarat, da ra vartuluai kai ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Ma di ga luk ra umana natu i Merari ta kadia lavur apik na tarai ma ta kadia lavur kakang, ");
INSERT INTO ksd_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","diat ba kadia kilala i ga tur livuan papa ta ra utul a vinun tuk tar ta ra ilima na vinun, diat par dia ga topa ra papalum, upi diat a pait ra lavur varvakai ta ra pal na varbarat; ");
INSERT INTO ksd_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","diat di ga luk diat ta kadia lavur apik na tarai, a utul a arip ma a ura mar diat. ");
INSERT INTO ksd_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Go ra niluluk i diat nina Moses ma Aron dir ga luk diat ta ra apik na tarai Merari, da ra vartuluai kai ra Luluai ta ra ngie i Moses. ");
INSERT INTO ksd_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Moses ma Aron ma ra umana luluai kai ra tarai Israel dia ga luk ra tarai Levi, ta kadia lavur apik na tarai ma ta kadia lavur kakang, ");
INSERT INTO ksd_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","diat ba kadia kilala i ga tur livuan papa ra utul a vinun tuk tar ta ra ilima na vinun, diat par dia ga topa ra papalum, upi diat a puak ra umana kinakap ta ra pal na varbarat, ");
INSERT INTO ksd_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","diat di ga luk diat, lavutul na arip ma a ilima na mar ma lavutul na vinun diat. ");
INSERT INTO ksd_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Moses i ga luk diat da ra vartuluai kai ra Luluai, tikatikai ta kana papalum ma tikatikai ta kana kinakap: damana i ga luk diat, da ra Luluai i ga vartuluai tana pire Moses. ");
INSERT INTO ksd_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Ma ra Luluai i ga tata pire Moses dari: ");
INSERT INTO ksd_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Una vartuluai pire ra tarai Israel upi diat a vaki vaire ra lavur vukavuka, ma diat par ba dia gapgap, ma nina pa i gomgom tago i bili ta minat; ");
INSERT INTO ksd_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","avat a vaki diat, a tarai ma ra vaden, ta ra pakana gunan irai; upi koko diat a vadur kadia gunan, nina iau ki livuan tana. ");
INSERT INTO ksd_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Ma ra tarai Israel dia ga pait ia damana, ma dia ga vaki vaire diat kan ra gunan; da ra Luluai i ga vatang tar ia tai Moses, damana ra tarai Israel dia ga pait ia. ");
INSERT INTO ksd_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Ma ra Luluai i ga tata pire Moses dari: ");
INSERT INTO ksd_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Una biti tai ra tarai Israel dari: Ona ta tutana ba ta vavina na pait ta mangana varpiam kai ra tarai, ma i piam ra Luluai, ma i rara damana; ");
INSERT INTO ksd_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","na tata kapa ure ra varpiam i ga pait ia; ma na bali vapar ra magit i ga rara tana, ma na tul tar ra vavailimana pakana tana, tai nina i ga pait ra varpiam tana. ");
INSERT INTO ksd_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ma ona pa ta tutmur tana upi na vatur vake ra balbali ure ra nirara, a tena tinabar na vatur vake ra balbali ure ra nirara di tul tar ia tai ra Luluai, varurung ma ra sip ure ra tinabar na varporong, nina di pait ra varporong me ure. ");
INSERT INTO ksd_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Ma ra tena tinabar na vatur vake, ra lavur tinabar na tutuluai ta ra lavur magit i gomgom kai ra tarai Israel nina dia tul tar ia tana. ");
INSERT INTO ksd_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Ra lavur magit ba tikai i vagomgom diat, ra tena tinabar na vatur vake; na vatur vake ra lavur magit di tul tar ia tana. ");
INSERT INTO ksd_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Ma ra Luluai i ga tata pire Moses dari: ");
INSERT INTO ksd_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Una tata pire ra tarai Israel ma una biti ta diat: Ona ra taulai kai ta tutana i vana rara, ma i pait ra kaina ure kana tutana, ");
INSERT INTO ksd_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ma ari ta tutana i va pirana, ma kana tutana pa i nunure tago i pidik, ma pa i gomgom tana, ma pa ta tikai i varvai ure, ma pa di tikan tadav kana nipo; ");
INSERT INTO ksd_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ba kana tutana i kairane ra ninunuk na vartakun, ma i nuknuk takun kana taulai, ba pa i gomgom, ba i gomgom uka; ");
INSERT INTO ksd_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ra tutana na agure kana vavina tadav ra tena tinabar, ma na kap ra vartabar na nian ure, tika na vavinun na pakana epa na plaua na barli; pa na lolonge ta dangi tana, ma pa na vung ra bulit i ang na katkat tana; tago ia ra tinabar na ninunuk na vartakun, a tinabar na vuai na uma ure ra varvakapa na varpiam. ");
INSERT INTO ksd_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Ma ra tena tinabar na agure, ma na vatur ia ta ra luaina mata i ra Luluai; ");
INSERT INTO ksd_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","ma ra tena tinabar na kap ra gomgom na tava ta ra la na pia, ma na tak pa ra tobon ta ra pia ta ra pal na varbarat, ma na vung ia ta ra tava; ");
INSERT INTO ksd_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","ma ra tena tinabar na vatur ra vavina ta ra luaina mata i ra Luluai, ma na pala ra pepe na uluna, ma na vung ra tinabar na varvakapa ta ra limana nina ra tinabar na ninunuk na vartakun; ma ra tena tinabar na vatur vake ra tava mapak nina i varvabilak ta ra limana; ");
INSERT INTO ksd_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","ma ra vavina na vavalima ta ra luaina mata i ra tena tinabar, ma ra tena tinabar na biti tana: Gala pa ta tutana i ga va piram, ma pa u vana rara upi una dur, ba kaum tutana i kure u, una langalanga kan go ra tava mapak nina i varvabilak; ");
INSERT INTO ksd_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","ma gala u ga vana rara, ba kaum tutana i kure u, ma pa u gomgom tago ra tutana nina vakir kaum tutana i ga va piram; ");
INSERT INTO ksd_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","(ra vavina na vavalima ure ra varvabilak ta ra luaina mata i ra tena tinabar, ma ra tena tinabar na biti tana:) ra Luluai na vaki u da ra magit i bilak ma ra magit na varvul livuan pire kaum tarai, ba ra kelakelegim i takari ma ra balam i ung ta ra luaina mata i ra Luluai; ");
INSERT INTO ksd_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ma go ra tava na varvabilak na ruk ta ra balam, ma ra balam na ung, ma ra kelakelegim na takari; ma ra vavina na biti: Amen, Amen. ");
INSERT INTO ksd_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Ma ra tena tinabar na tumu vake go ra lavur tinata na varvabilak ta ra buk ma na timar tar ra polo na tutumu tana ta ra tava mapak; ");
INSERT INTO ksd_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ma na vamomo ra vavina ma ra tava mapak nina i varvabilak; ma ra tava na varvabilak na ruk ta ra balana ma na vakadik ia. ");
INSERT INTO ksd_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Ma ra tena tinabar na vatur vake ra tinabar na ninunuk na vartakun ta ra lima i ra vavina, ma na tulue ra tinabar ta ra luaina mata i ra Luluai, ma na kap ia tadav ra uguugu na vartabar; ");
INSERT INTO ksd_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","ma ra tena tinabar na tak pa tika na ginagu ta ra tinabar, upi na tur na im, ma na tun ia ta ra uguugu na vartabar, ma namur na vamomo ra vavina ma ra tava. ");
INSERT INTO ksd_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Ma ba i ga vamoma ma ra tava, na dari: gala pa i gomgom, tago i ga pait ra kaina ure kana tutana, ra tava na varvabilak na ruk ta ra balana ma na vakadik ia, ma ra balana na ung, ma ra kelakelegina na takari; ma ra vavina na da ra magit i bilak livuan pire kana tarai. ");
INSERT INTO ksd_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ma gala ra vavina pa i dur, ma i gomgom uka, na langalanga ma na lalau pa ra bul. ");
INSERT INTO ksd_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Go ia ra varkurai ure ra ninunuk na vartakun, va ra vavina nina kana tutana i kure i vana rara ma pa i gomgom; ");
INSERT INTO ksd_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ba ta tutana i kairane ra ninunuk na vartakun, ma i nuknuk takun kana taulai, na vatur ra vavina ta ra luaina mata i ra Luluai, ma ra tena tinabar na pait ot pa go ra varkurai tana. ");
INSERT INTO ksd_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Ma ra tutana na langalanga, ma nam ra vavina na puak pa kana varpiam. ");
INSERT INTO ksd_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Ma ra Luluai i ga tata pire Moses dari: ");
INSERT INTO ksd_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Una tata pire ra tarai Israel ma una biti ta diat: Ba ta tutana ba ta vavina na pait ra kunubu na vavalima, a vavalima na Nasir, upi na vagomgom vaire ia iat mulai tadav ra Luluai, ");
INSERT INTO ksd_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","na tur irai kan ra polo na vain ma ra tava longlong; pa na mome ra polo na vain i mapak, ba ra tava longlong, ba ra polo na vuai na vain, ma pa na en ra vuai na vain nina i kalabar ba nina i ge. ");
INSERT INTO ksd_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Ta ra lavur bungbung ta kana kini irai pa na ian ta ra davai na vain, maia pa, ra patina ma ra palina pata. ");
INSERT INTO ksd_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Ta ra lavur bungbung i ga vavalima tana ba na ki irai, koko da kut ra pepe na uluna; na gomgom tuk di pait ot pa ra lavur bung ure kana kini irai tadav ra Luluai, ma na nur vue ra pepe na uluna upi na lolovina. ");
INSERT INTO ksd_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Ta ra lavur bung ure kana kini irai tadav ra Luluai, koko na maravai pire ta minat. ");
INSERT INTO ksd_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Pa na nur vue kana kini gomgom ure tamana, ba nana, ba turana, ba taina, ona dia mat; tago kana kini irai tadav God i ki ta ra uluna. ");
INSERT INTO ksd_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Ta ra lavur bung ta kana kini irai, di tibe vaire upi kai ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Ma ona ta tikai i mat vakaian maravai pirana, ma ra uluna pa i gomgom mulai ta kana kini irai, na kut ra pepe na uluna ta ra bung ba i gomgom mulai tana, a valavuruana bung iat. ");
INSERT INTO ksd_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Ma ta ra valavutuluna bung, na kap ta ura uka ba ta ura nat na balu tadav ra tena tinabar ta ra matakilalat i ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Ma ra tena tinabar na tul tar tikai ure ra tinabar na varporong, ma ta ra tikai ure ra tinabar di tuntun tar ia; ma na pait ra varporong ure tago i ga kaina ba i ga bili ra minat, ma na vagomgom ra uluna ta nam ra bung. ");
INSERT INTO ksd_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Ma na tur pa mule ra umana bung na kini irai tadav ra Luluai, ma na kap ta nat na sip, a tomotoina ba i kopono ko kana kilala, ure ra tinabar na nirara; ma pa da luk ra umana bungbung lua, tago kana kini irai pa i ga gomgom. ");
INSERT INTO ksd_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Ma go ia ra varkurai ure ra Nasir, ba di ga pait ot pa ra lavur bung ure kana kini irai: da agure tadav ra matakilalat i ra pal na varbarat, ");
INSERT INTO ksd_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ma na tul tar kana vartabar na nian tadav ra Luluai, tika na nat na sip, a tomotoina i ko kakit, ba i kopono ko kana kilala, ure ra tinabar di tuntun tar ia, ma tika na nat na sip, a tana i ko kakit, ba i kopono ko kana kilala, ure ra tinabar na varporong, ma tika na sip, a tomotoina i ko kakit ure ra tinabar na varmaram; ");
INSERT INTO ksd_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ma tika na rat na gem ba pa i leven, ta umana gem ik di pait ia ma ra bo na plaua di pota ma ra dangi, ma ta umana gem maleplep ba pa i leven, nina di lolonge ra dangi tana, ma kadia tinabar na plaua, ma kadia tinabar na nimomo. ");
INSERT INTO ksd_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Ma ra tena tinabar na tul tar diat ta ra luaina mata i ra Luluai, ma na tul tar kana tinabar na varporong, ma kana tinabar di tuntun tar ia; ");
INSERT INTO ksd_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","ma na tul tar ra sip ure ra tinabar na varmaram tadav ra Luluai, varurung ma ra rat na gem ba pa i leven; ra tena tinabar na tul tar bula ra tinabar na plaua tana ma ra tinabar na nimomo tana. ");
INSERT INTO ksd_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Ma ra Nasir na kut vue ra pepe na uluna nina i vakilang kana kini irai, ta ra matakilalat i ra pal na varbarat, ma na tarie ta ra iap nina ra tinabar na varmaram i ki tana. ");
INSERT INTO ksd_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Ma ra tena tinabar na kap ra kelakelegi ta ra sip ba di ga kabalane, ma tika na gem ik, ma tika na gem maleplep ta ra rat na gem ba pa i leven, ma na vung diat ta ra lima i ra Nasir, ba i ga kut vue ra pepe na uluna ure kana kini irai; ");
INSERT INTO ksd_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","ma ra tena tinabar na tulue diat ta ra luaina mata i ra Luluai upi ra tinabar na tutuluai; go ia ra magit i gomgom upi kai ra tena tinabar, da ra bongobongo di tulue ma ra kelakelegi di tul tar ia; ma namur i topa ia ba ra Nasir na mome ra vain. ");
INSERT INTO ksd_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Go ia ra varkurai ure ra Nasir nina i vavalima ma ure kana vartabar na nian tadav ra Luluai ure kana kini irai; ma na tul tar ta mangana bula gala ia iat i mainge; na pait ot pa ra magit i vavalima tana, da ra varkurai ure kana kini irai. ");
INSERT INTO ksd_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Ma ra Luluai i ga tata pire Moses, dari: ");
INSERT INTO ksd_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Una tata pire Aron ma ra umana natuna, ma una biti: Avat a tata vadoane ra tarai Israel dari, ma avat a biti ta diat: ");
INSERT INTO ksd_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","A Luluai na vadoane u, ma na balaure u. ");
INSERT INTO ksd_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","A mata i ra Luluai na pupua taun u, ma ia iat na mari u. ");
INSERT INTO ksd_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","A Luluai a mataure u, ma na tul tar ra malmal tam. ");
INSERT INTO ksd_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Damana diat a vaki tar ra iangigu ta ra tarai Israel, ma ina vadoane diat. ");
INSERT INTO ksd_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Ma ta nam ra bung ba Moses i ga vatut vapar ra Pal, ma i ga vadangi ia ma i ga vakilang vaire, ma kana lavur tabarikik bula, ma ra uguugu na vartabar ma ra ana lavur magit na papalum, ma i ga vadangi diat ma i ga vakilang vaire diat; ");
INSERT INTO ksd_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","ra umana luluai kai ra tarai Israel, nina ra umana lualua ta ra umana vuna tarai, dia ga vartabar; go diat ra umana luluai ta ra umana vuna tarai, nina dia ga lualua ta diat di ga luk diat; ");
INSERT INTO ksd_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ma dia ga kap kadia vartabar na nian ta ra luaina mata i ra Luluai, laptikai na kiki na vinavana ma a vinun ma ura bulumakau; tika na kiki na vinavana ure a uraura luluai, ma tika na bulumakau ure tikatikai ta diat; ma dia ga tul tar diat ta ra luaina mata i ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Ma ra Luluai i ga tata pire Moses, dari: ");
INSERT INTO ksd_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Una vatur vake ta diat, upi diat a topa ra papalum ta ra pal na varbarat; ma una tul tar diat ta ra tarai Levi, tai tikatikai da kana papalum. ");
INSERT INTO ksd_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Ma Moses i ga vatur vake ra umana kiki na vinavana ma ra umana bulumakau, ma i ga tul tar diat ta ra tarai Levi. ");
INSERT INTO ksd_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","A ura kiki na vinavana ma a ivat na bulumakau i ga tul tar diat ta ra umana natu i Gerson, da kadia varvakai; ");
INSERT INTO ksd_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ma a ivat na kiki na vinavana ma lavutul na bulumakau i ga tul tar diat ta ra umana natu i Merari, da kadia varvakai, nina Itamar natu i Aron, ra tena tinabar, i ga kure. ");
INSERT INTO ksd_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Ma pa i ga tul tar ta na ta ra umana natu i Koat, tago dia varvakai ma ra gomgom na pal, ma dia puak ia ta ra ul a vara i diat. ");
INSERT INTO ksd_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Ma ra umana luluai dia ga vartabar ure ra varvadoan ta ra uguugu na vartabar ta ra bung ba di ga vadangi ia, maia, ra umana luluai dia ga tul tar kadia vartabar na nian ta ra luaina mata i ra uguugu na vartabar. ");
INSERT INTO ksd_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Ma ra Luluai i ga biti tai Moses: Diat a tul tar kadia vartabar na nian, tikatika na luluai ta kana bung iat, ure ra varvadoan ta ra uguugu na vartabar. ");
INSERT INTO ksd_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Ma nina i ga tul tar kana vartabar ta ra luaina bung, Nason natu i Aminadab, ta ra vuna tarai Iuda; ");
INSERT INTO ksd_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","kana vartabar i ga dari: tika na plet i silva, kana mamat a mar ma a utul a vinun na pakana mamat * ma tika na la i silva i lavurua na vinun na mamat da ra mamat kai ra gomgom na pal; dir par dir buka ma ra bo na plaua di ga pota ma ra dangi ure ra tinabar na vuai na uma; ");
INSERT INTO ksd_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","tika na la i goled, a vinun na mamat, i buka ma ra bulit i ang na katkat; ");
INSERT INTO ksd_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","tika na bulumakau, tika na sip, ma tika na nat na sip, a tomotoina ba i kopono ko kana kilala, ure ra tinabar di tun tar ia; ");
INSERT INTO ksd_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","tika na me, a tomotoina, ure ra tinabar na varporong; ");
INSERT INTO ksd_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ma ure ra tinabar na varmaram, a ura bulumakau, a ilima na sip, a ilima na me, ma a ilima na nat na sip, a umana tomotoina ba i kopono ko kadia kilala; go ia ra vartabar kai Nason natu i Aminadab. ");
INSERT INTO ksd_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Ta ra vauruana bung Netanel natu i Suar, a luluai kai ra vuna tarai Isakar, i ga vartabar; ");
INSERT INTO ksd_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","ra vartabar i ga tul tar ia, i dari: tika na plet i silva, kana mamat a mar ma a utul a vinun na pakana mamat, ma tika na la i silva i lavurua na vinun na”mamat da ra mamat kai ra gomgom na pal; dir par dir buka ma ra bo na plaua di ga pota ma ra dangi ure ra tinabar na vuai na uma; ");
INSERT INTO ksd_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","tika na la i goled, a vinun na mamat, i buka ma ra bulit i ang na katkat, ");
INSERT INTO ksd_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","tika na bulumakau, tika na sip, ma tika na nat na sip, a tomotoina ba i kopono ko kana kilala, ure ra tinabar di tun tar ia; ");
INSERT INTO ksd_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","tika na me, a tomotoina, ure ra tinabar na varporong; ");
INSERT INTO ksd_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ma ure ra tinabar na varmaram, a ura bulumakau, a ilima na sip, a ilima na me, ma a ilima na nat na sip, a umana tomotoina ba i kopono ko kadia kilala; go ia ra vartabar kai Netanel natu i Suar. ");
INSERT INTO ksd_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Ta ra vautuluna bung Eliab natu i Elon a luluai kai ra umana natu i Sebulun; ");
INSERT INTO ksd_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","kana vartabar i ga dari: tika na plet i silva, kana mamat a mar ma a utul a vinun na pakana mamat, ma tika na la i silva, i lavurua na vinun na mamat, da ra mamat kai ra gomgom na pal; dir par dir buka ma ra bo na plaua di ga pota ma ra dangi, ure ra tinabar na vuai na uma; ");
INSERT INTO ksd_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","tika na la i goled, a vinun na mamat, i buka ma ra bulit i ang na katkat; ");
INSERT INTO ksd_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","tika na bulumakau, tika na sip, ma tika na nat na sip, a tomotoina ba i kopono ko kana kilala, ure ra tinabar di tun tar ia; ");
INSERT INTO ksd_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","tika na me, a tomotoina, ure ra tinabar na varporong; ");
INSERT INTO ksd_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ma ure ra tinabar na varmaram, a ura bulumakau, a ilima na sip, a ilima na me, ma a ilima na nat na sip, a umana tomotoina ba i kopono ko kadia kilala; go ia ra vartabar kai Eliab natu i Elon. ");
INSERT INTO ksd_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Ta ra vaivatina bung Elisur natu i Sedeur a luluai kai ra umana natu i Ruben; ");
INSERT INTO ksd_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","kana vartabar i ga dari: tika na plet i silva, kana mamat a mar ma a utul a vinun na pakana mamat, ma tika na la i silva, i lavurua na vinun na mamat, da ra mamat kai ra gomgom na pal; dir par dir buka ma ra bo na plaua di ga pota ma ra dangi, ure ra tinabar na vuai na uma; ");
INSERT INTO ksd_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","tika na la i goled, a vinun na mamat, i buka ma ra bulit i ang na katkat; ");
INSERT INTO ksd_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","tika na bulumakau, tika na sip, ma tika na nat na sip, a tomotoina ba i kopono ko kana kilala, ure ra tinabar di tun tar ia; ");
INSERT INTO ksd_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","tika na me, a tomotoina, ure ra tinabar na varporong; ");
INSERT INTO ksd_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ma ure ra tinabar na varmaram, a ura bulumakau, a ilima na sip, a ilima na me, ma a ilima na nat na sip, a umana tomotoina ba i kopono ko kadia kilala; go ia ra vartabar kai Elisur natu i Sedeur. ");
INSERT INTO ksd_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Ta ra vailimana bung Selumiel natu i Surisadai, a luluai kai ra umana natu i Simeon; ");
INSERT INTO ksd_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","kana vartabar i ga dari: tika na plet i silva, kana mamat a mar ma a utul a vinun na pakana mamat, ma tika na la i silva, i lavurua na vinun na mamat, da ra mamat kai ra gomgom na pal; dir par dir buka ma ra bo na plaua di ga pota ma ra dangi ure ra tinabar na vuai na uma; ");
INSERT INTO ksd_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","tika na la i goled, a vinun na mamat, i buka ma ra bulit i ang na katkat; ");
INSERT INTO ksd_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","tika na bulumakau, tika na sip, ma tika na nat na sip, a tomotoina ba i kopono ko kana kilala, ure ra tinabar di tun tar ia; ");
INSERT INTO ksd_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","tika na me, a tomotoina, ure ra tinabar na varporong; ");
INSERT INTO ksd_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ma ure ra tinabar na varmaram, a ura bulumakau, a ilima na sip, a ilima na me, ma a ilima na nat na sip, a umana tomotoina ba i kopono ko kadia kilala; go ia ra vartabar kai Selumiel natu i Surisadai. ");
INSERT INTO ksd_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Ta ra valaptikaina bung Eliasap natu i Deuel, ra luluai kai ra umana natu i Gad; ");
INSERT INTO ksd_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","kana vartabar i ga dari: tika na plet i silva, kana mamat a mar ma a utul a vinun na pakana mamat, ma tika na la i silva, i lavurua na vinun na mamat, da ra mamat kai ra gomgom na pal, dir par dir buka ma ra bo na plaua di ga pota ma ra dangi ure ra tinabar na vuai na uma; ");
INSERT INTO ksd_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","tika na la i goled, a vinun na mamat, i buka ma ra bulit i ang na katkat; ");
INSERT INTO ksd_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","tika na bulumakau, tika na sip, ma tika na nat na sip, a tomotoina ba i kopono ko kana kilala, ure ra tinabar di tun tar ia; ");
INSERT INTO ksd_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","tika na me, a tomotoina ure ra tinabar na varporong; ");
INSERT INTO ksd_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ma ure ra tinabar na varmaram, a ura bulumakau, a ilima na sip, a ilima na me, ma a ilima na nat na sip, a umana tomotoina ba i kopono ko kadia kilala; go ia ra vartabar kai Eliasap natu i Deuel. ");
INSERT INTO ksd_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Ta ra valavuruana bung, Elisama natu i Amiud, ra luluai kai ra umana natu i Epraim; ");
INSERT INTO ksd_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","kana vartabar i ga dari: tika na plet i silva, kana mamat a mar ma a utul a vinun na pakana mamat, ma tika na la i silva i lavurua na vinun na mamat, da ra mamat kai ra gomgom na pal; dir par dir buka ma ra bo na plaua di ga pota ma ra dangi ure ra tinabar na vuai na uma; ");
INSERT INTO ksd_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","tika na la i goled, a vinun na mamat, i buka ma ra bulit i ang na katkat; ");
INSERT INTO ksd_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","tika na bulumakau, tika na sip, ma tika na nat na sip, a tomotoina ba i kopono ko kana kilala, ure ra tinabar di tun tar ia; ");
INSERT INTO ksd_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","tika na me, a tomotoina, ure ra tinabar. na varporong; ");
INSERT INTO ksd_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ma ure ra tinabar na varmaram, a ura bulumakau, a ilima na sip, a ilima na me, ma a ilima na nat na sip, a umana tomotoina ba i kopono ko kadia kilala; go ia ra vartabar kai Elisama natu i Amiud. ");
INSERT INTO ksd_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Ta ra valavutuluna bung, Gamaliel natu i Pedasur, ra luluai kai ra umana natu i Manase; ");
INSERT INTO ksd_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","kana vartabar i ga dari: tika na plet i silva, kana mamat a mar ma a utul a vinun na pakana mamat, ma tika na la i silva i lavurua na vinun na mamat, da ra mamat kai ra gomgom na pal; dir par dir buka ma ra bo na plaua di ga pota ma ra dangi ure ra tinabar na vuai na uma; ");
INSERT INTO ksd_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","tika na la i goled, a vinun na mamat, i buka ma ra bulit i ang na katkat; ");
INSERT INTO ksd_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","tika na bulumakau, tika na sip, ma tika na nat na sip, a tomotoina ba i kopono ko kana kilala, ure ra tinabar di tun tar ia; ");
INSERT INTO ksd_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","tika na me, a tomotoina, ure ra tinabar na varporong; ");
INSERT INTO ksd_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ma ure ra tinabar na varmaram, a ura bulumakau, a ilima na sip, a ilima na me, ma a ilima na nat na sip, a umana tomotoina ba i kopono ko kadia kilala; go ia ra vartabar kai Gamaliel natu i Pedasur. ");
INSERT INTO ksd_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Ta ra valavuvatuna bung, Abidan natu i Gideoni, ra luluai kai ra umana natu i Beniamin; ");
INSERT INTO ksd_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","kana vartabar i ga dari. tika na plet i silva, kana mamat a mar ma a utul a vinun na pakana mamat, ma tika na la i silva i lavurua na vinun na mamat, da ra mamat kai ra gomgom na pal, dir par dir buka ma ra bo na plaua di ga pota ma ra dangi, ure ra tinabar na vuai na uma; ");
INSERT INTO ksd_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","tika na la i goled, a vinun na mamat, i buka ma ra bulit i ang na katkat; ");
INSERT INTO ksd_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","tika na bulumakau, tika na sip, ma tika na nat na sip, a tomotoina ba i kopono ko kana kilala, ure ra tinabar di tun tar ia; ");
INSERT INTO ksd_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","tika na me, a tomotoina, ure ra tinabar na varporong; ");
INSERT INTO ksd_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ma ure ra tinabar na varmaram, a ura bulumakau, a ilima na sip, a ilima na me, ma a ilima na nat na sip, a umana tomotoina ba i kopono ko kadia kilala; go ia ra vartabar kai Abidan natu i Gideoni. ");
INSERT INTO ksd_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Ta ra vavinununa bung Akieser natu i Amisadai, ra luluai kai ra umana natu i Dan; ");
INSERT INTO ksd_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","kana vartabar i ga dari: tika na plet i silva, kana mamat a mar ma a utul a vinun na pakana mamat ma tika na la i silva, i lavurua na vinun na mamat, da ra mamat kai ra gomgom na pal, dir par dir buka ma ra bo na plaua di ga pota ma ra dangi, ure ra tinabar na vuai na uma; ");
INSERT INTO ksd_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","tika na la i goled, a vinun na mamat, i buka ma ra bulit i ang na katkat; ");
INSERT INTO ksd_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","tika na bulumakau, tika na sip, ma tika na nat na sip, a tomotoina ba i kopono ko kana kilala, ure ra tinabar di tun tar ia; ");
INSERT INTO ksd_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","tika na me, a tomotoina, ure ra tinabar na varporong; ");
INSERT INTO ksd_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ma ure ra tinabar na varmaram, a ura bulumakau, a ilima na sip, a ilima na me, ma a. ilima na nat na sip, a umana tomotoina ba i kopono ko kadia kilala; go ia ra vartabar kai Akieser natu i Amisadai. ");
INSERT INTO ksd_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Ta ra vavinun ma tikai na bung Pagiel natu i Okram, ra luluai kai ra umana natu i Aser; ");
INSERT INTO ksd_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","kana vartabar i ga dari: tika na plet i silva, kana mamat a mar ma a utul a vinun na pakana mamat, ma tika na la i silva i lavurua na vinun na mamat, da ra mamat kai ra gomgom na pal, dir par dir buka ma ra bo na plaua di ga pota ma ra dangi, ure ra tinabar na vuai na uma; ");
INSERT INTO ksd_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","tika na la i goled, a vinun na mamat, i buka ma ra bulit i ang na katkat; ");
INSERT INTO ksd_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","tika na bulumakau, tika na sip, ma tika na nat na sip, a tomotoina, ba i kopono ko kana kilala, ure ra tinabar di tun tar ia, ");
INSERT INTO ksd_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","tika na me, a tomotoina, ure ra tinabar na varporong; ");
INSERT INTO ksd_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ma ure ra tinabar na varmaram, a ura bulumakau, a ilima na sip, a ilima na me, ma a ilima na nat na sip, a umana tomotoina ba i kopono ko kadia kilala; go ia ra vartabar kai Pagiel natu i Okram. ");
INSERT INTO ksd_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Ta ra vavinun ma a urua na bung, Akira natu i Enan, ra luluai kai ra umana natu i Naptali; ");
INSERT INTO ksd_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","kana vartabar i ga dari: tika na plet i silva, kana mamat a mar ma a utul a vinun na pakana mamat, ma tika na la i silva i lavurua na vinun na mamat, da ra mamat kai ra gomgom na pal, dir par dir buka ma ra bo na plaua di ga pota ma ra dangi ure ra tinabar na vuai na uma; ");
INSERT INTO ksd_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","tika na la i goled, a vinun na mamat, i buka ma ra bulit i ang na katkat; ");
INSERT INTO ksd_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","tika na bulumakau, tika na sip, ma tika na nat na sip, a tomotoina ba i kopono ko kana kilala ure ra tinabar di tun tar ia; ");
INSERT INTO ksd_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","tika na me, a tomotoina, ure ra tinabar na varporong, ");
INSERT INTO ksd_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ma ure ra tinabar na varmaram, a ura bulumakau, a ilima na sip, a ilima na me, ma a ilima na nat na sip, a umana tomotoina ba i kopono ko kadia kilala; go ia ra vartabar kai Akira natu i Enan. ");
INSERT INTO ksd_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Go ia ra vartabar ure ra varvadoan ta ra uguugu na vartabar ta ra bung ba di ga vadangi ia, ra umana luluai kai ra tarai Israel dia tul tar ia: a vinun ma a ura plet i silva, a vinun ma a ura la i silva, a vinun ma a ura la i goled; ");
INSERT INTO ksd_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","a mamat i ra umana plet i silva, tikatikai a mar ma a utul a vinun na pakana mamat, ma ra umana la i silva, tikatikai a lavurua na vinun; damana ra mamat i ra silva ta diat par, a ura arip ma a ivat na mar na pakana mamat, da ra mamat kai ra gomgom na pal; ");
INSERT INTO ksd_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ra vinun ma a urua na la i goled, nina dia buka ma ra bulit i ang na katkat, kadia mamat tikatikai a vinun na pakana mamat, da ra mamat kai ra gomgom na pal; damana ra mamat i ra goled ta diat par tika na mar ma a ura vinun na pakana mamat; ");
INSERT INTO ksd_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","a umana bulumakau ure ra tinabar di tun tar ia a vinun ma a urua diat, ma a vinun ma a ura sip, ma a vinun ma a ura nat na sip, a umana tomotoina ba i kopono ko kadia kilala, varurung ma kadia tinabar na plaua; ma ra umana me, a umana tomotoina ure ra tinabar na varporong, a vinun ma a urua diat; ");
INSERT INTO ksd_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","ma ra umana bulumakau ure ra tinabar na varmaram, a ura vinun ma a ivat diat, ma laptikai na vinun na sip, ma laptikai na vinun na me, ma laptikai na vinun na nat na sip, a umana tomotoina ba i kopono ko kadia kilala. Go ia ra vartabar ure ra varvadoan ta ra uguugu na vartabar, ba di ga vadangi ia. ");
INSERT INTO ksd_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Ma ba Moses i ga ruk ta ra pal na varbarat upi dir a tata ma ra Luluai, i ga valongore ra nilaina i tata pirana marama ta ra ul a tubatuba na bok na varvai livuan ta ra ura angelo; ma i ga tata pirana. * A pakana mamat i ga da ra vinun ma laptikai na gram (a ngungu auns). ");
INSERT INTO ksd_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Ma ra Luluai i ga tata pire Moses, dari: ");
INSERT INTO ksd_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Una tata pire Aron, ma una biti: Ba u vatur ra umana lamp, a lavurua na lamp diat a birao ta ra luaina mata i ra turtur na birao. ");
INSERT INTO ksd_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Ma Aron i ga pait ia damana; i ga vatur kana umana lamp upi diat a birao ta ra luaina mata i ra turtur na birao, da ra Luluai i ga vartuluai pire Moses. ");
INSERT INTO ksd_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Ma go ia ra papalum ta ra turtur na birao, di ga pait ia ma ra goled di ga tut ia; papa ta ra vunapaina tuk urama ta ra umana purpur tana, di ga tut vapar ia ka; da ra malalar nina ra Luluai i ga ve tar ia tai Moses, damana i ga pait ra turtur na birao. ");
INSERT INTO ksd_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Ma ra Luluai i ga tata pire Moses, dari: ");
INSERT INTO ksd_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Una varbaiane ra tarai Levi kan ra tarai Israel, ma una vagomgom diat. ");
INSERT INTO ksd_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ma una pait ia dari ta diat upi da vagomgom diat: Una apur diat ma ra tava na varvagomgom, ma da ka ra pal a paka i diat parika, ma diat a puk vagomgom kadia lavur mal, ma diat a vagomgom diat iat. ");
INSERT INTO ksd_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Diat a kap tika na bulumakau, varurung ma kana tinabar na vuai na uma, a bo na plaua di ga pota ma ra dangi, ma una kap ta tika na enana bulumakau ure ra tinabar na varporong. ");
INSERT INTO ksd_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Ma una tul tar ra tarai Levi ta ra luaina mata i ra pal na varbarat; ma una oro guve ra kor na tarai Israel par; ");
INSERT INTO ksd_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","ma una tul tar ra tarai Levi ta ra luaina mata i ra Luluai; ma ra tarai Israel diat a palagur ra tarai Levi; ");
INSERT INTO ksd_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ma Aron na tul tar ra tarai Levi ta ra luaina mata i ra Luluai upi ra tinabar na tutuluai kan ra tarai Israel, upi diat a varvakai ma ra papalum kai ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Ma ra tarai Levi diat a vung ra lima i diat taun ra ulu i ra ura bulumakau; ma una tul tar tikai ure ra tinabar na varporong, ma ta ra tikai ure ra tinabar di tun tar ia tadav ra Luluai, upi da pait ra varporong ure ra tarai Levi. ");
INSERT INTO ksd_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Ma una vatur ra tarai Levi ta ra luaina mata i Aron ma ra umana natuna, ma una tul tar diat upi ra tinabar na tutuluai tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Damana una varbaiane ra tarai Levi kan ra tarai Israel; ma diat ra tarai Levi, diat kaugu. ");
INSERT INTO ksd_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Ma namur ra tarai Levi diat a ruk upi diat a pait ra papalum ta ra pal na varbarat; ma una vagomgom diat, ma una tul tar diat upi ra tinabar na tutuluai. ");
INSERT INTO ksd_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Tago di ga tul vapar tar diat tagu kan ra tarai Israel; iau ga vatur vake diat ure ra umana luaina kinakava, ure ra umana luaina bul kai ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Tago ra umana luaina kinakava parika pire ra tarai Israel kaugu, a tarai ma ra umana vavaguai; ta nam ra bung ba iau ubu ra lavur luaina kinakava ta ra gunan Aigipto, iau ga vakilang vaire diat upi kaugu. ");
INSERT INTO ksd_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Ma iau ga kia ra lavur luaina pire ra tarai Israel ma ra tarai Levi. ");
INSERT INTO ksd_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Ma iau ga tul tar ra tarai Levi da ra vartabar pire Aron ma ra umana natuna, upi diat a pait ra papalum ure ra tarai Israel ta ra pal na varbarat, ma upi diat a pait ra varporong ure ra tarai Israel; kan ta minait na monong ra tarai Israel, ba dia vana maravai ta ra gomgom na pal. ");
INSERT INTO ksd_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Damana Moses, ma Aron, ma ra kor na tarai Israel, dia ga pait ia pire ra tarai Levi; da nam parika ra Luluai i ga vartuluai tana pire Moses ure ra tarai Levi, damana ra tarai Israel dia ga pait ia pire diat. ");
INSERT INTO ksd_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Ma ra tarai Levi dia ga vagomgom diat mulai, ma dia ga puk kadia lavur mal; ma Aron i ga tul tar diat upi ra tinabar na tutuluai ta ra luaina mata i ra Luluai; ma Aron i ga pait ra varporong ure diat upi na vagomgom diat. ");
INSERT INTO ksd_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ma namur ra tarai Levi dia ga ruk upi diat a pait kadia papalum ta ra pal na varbarat, ta ra luaina mata i Aron ma ra umana natuna; da ra Luluai i ga vartuluai pire Moses ure ra tarai Levi, damana di ga pait ia ta diat. ");
INSERT INTO ksd_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Ma ra Luluai i ga tata pire Moses, dari: ");
INSERT INTO ksd_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Go ia ra varkurai ure ra tarai Levi: ba kadia kilala i bolo ra ura vinun ma a ilima, diat a vana upi diat a varvakai ma ra papalum ta ra pal na varbarat; ");
INSERT INTO ksd_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ma ba kadia kilala i bolo ra ilima na vinun, diat a lilikun kan ra papalum, ma. koko diat a varvakai mulai tana, ");
INSERT INTO ksd_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","ia kaka kadia tiniba ba diat a maravut ra tara na tura i diat ta ra pal na varbarat, diat a varbalaurai tana ma pa diat a pait ta dekdek na papalum mulai. Damana una pait ia pire ra tarai Levi ure kadia tiniba. ");
INSERT INTO ksd_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Ma ra Luluai i ga tata pire Moses ta ra bil Sinai, ta ra luaina gai ta ra vauruana kilala taun kadia niirop kan ra gunan Aigipto, ma i ga biti dari: ");
INSERT INTO ksd_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Boina ba ra tarai Israel diat a pait ra lukara na bolo lake ta kana e. ");
INSERT INTO ksd_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Ta ra vavinun ma a ivat na bung, ba i mata na marum, avat a pait ia ta kana e; avat a pait ia da ra lavur varkurai ure ma ra lavur togotogo. ");
INSERT INTO ksd_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Ma Moses i ga vartuluai pire ra tarai Israel upi diat a pait ra lukara na bolo lake. ");
INSERT INTO ksd_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ma dia ga pait ra lukara na bolo lake ta ra luaina gai, ta ra vavinun ma a ivat na bung, ta ra mata na marum, ta ra bil Sinai; da nam parika ra Luluai i ga vartuluai tana pire Moses, damana ra tarai Israel dia ga pait ia. ");
INSERT INTO ksd_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Ma ta umana pa dia ga gomgom tago dia ga bili ra minat, ma pa dia ga pait valar pa ra lukara na bolo lake ta nam ra bung; ma dia ga tadav Moses ma Aron ta nam ra bung, ");
INSERT INTO ksd_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ma dia ga biti tana: Pa ave gomgom tago ave tar bili ra minat; ta ra ava di tur bat avet, upi koko avet a tul tar ra vartabar na nian kai ra Luluai ta kana e livuan pire ra tarai Israel? ");
INSERT INTO ksd_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Ma Moses i ga biti ta diat: Tuka boko; ina valongor boko pire ra Luluai ure avat. ");
INSERT INTO ksd_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Ma ra Luluai i ga tata pire Moses dari: ");
INSERT INTO ksd_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Una tata pire ra tarai Israel, ma una biti: Gala ta tikai ta vavat ba ta kavava lavur taun tarai pa na gomgom tago i bili ra minat, ba na vanavana aro vailik, na pait ra lukara na bolo lake tadav ra Luluai; ");
INSERT INTO ksd_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","diat a pait ia ta ra vauruana gai ta ra vavinun ma a ivat na bung, ta ra mata na marum; diat a en ia varurung ma ra gem ba pa i leven ma ra vurigir i mapak; ");
INSERT INTO ksd_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","koko diat a en valili ta na upi ra kubakene, ma koko diat a bubur ta uruna; diat a pait ia da ra lavur varkurai ure ra bolo lake. ");
INSERT INTO ksd_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ma nina i gomgom uka, ma vakir i vana irai vailik, ma pa i pait ra bolo lake, da kutu vue nam kan kana vuna tavai; tago pa i ga tul tar ra vartabar na nian kai ra Luluai ta kana e, nam ra tutana na puak ra vuai kana nirara. ");
INSERT INTO ksd_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Ma gala ta vaira i ki livuan ta vavat, ma i mainge ba na pait ra lukara na bolo lake tadav ra Luluai, na pait ia da ra varkurai ure ra bolo lake ma da ra lavur togotogo tana; avat a mur ra kopono varkurai ure, na topa dir par ra vaira ma ra gunan tuna. ");
INSERT INTO ksd_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Ma ta nam ra bung ba di ga vatut ra pal a bakut i ga ki taun ra pal, nina ra pal na mal ure ra tinata; ma ta ra marum i ga da ra biro na iap, tuk ta ra malana. ");
INSERT INTO ksd_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","I ga damana vatikai; a bakut i ga ki taun ia, ma ra biro na iap ta ra marum. ");
INSERT INTO ksd_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Ma ba di ga kari ra bakut urama kan ra pal na mal, namur tana ra tarai Israel dia ga tur pa ra vinavana; ma ta nam ra pakana ba ra bakut i ga tur tana, a tarai Israel dia ga vatur kadia lavur pal na mal ie. ");
INSERT INTO ksd_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Ta ra vartuluai kai ra Luluai dia ga vanavana, ma ta ra vartuluai kai ra Luluai dia ga vatur kadia lavur pal na mal; ba ra bakut i ga ki taun ra pal na mal dia ga kiki boko abara. ");
INSERT INTO ksd_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Ma ba ra bakut i ga kiki taun ra pal na mal a mangoro na bung, a tarai Israel dia ga torom ta ra vartuluai kai ra Luluai, ma pa dia ga kakari. ");
INSERT INTO ksd_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Ma ta umana pakana ra bakut i ga kiki taun ra pal na mal ta paupau bung uka; ma da ra vartuluai kai ra Luluai dia ga kiki boko abara, ma da ra vartuluai kai ra Luluai dia ga vanavana. ");
INSERT INTO ksd_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Ma ta umana pakana ra bakut i ga tur papa ta ra ravian tuk ta ra malana; ma ba di ga kari ra bakut urama ta ra malana, dia ga vanavana; ma ona i vanavana ta ra bung na keake ma ra bung na marum bula, ba di ga kari ra bakut urama, dia ga vanavana vatikai. ");
INSERT INTO ksd_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ba ta ura bung, ba tika na gai, ba tika na kilala, ra bakut i ga kiki taun ra pal vatikai, ra tarai Israel dia ga kiki boko abara, ma pa dia ga kakari; ia kaka ba di ga kari ia urama, dia ga tur pa ra vinavana. ");
INSERT INTO ksd_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ta ra vartuluai kai ra Luluai dia vatur kadia lavur pal na mal, ma ta ra vartuluai kai ra Luluai dia ga vanavana; dia ga toratorom ta ra varkurai kai ra Luluai, ma ta ra vartuluai kai ra Luluai ta ra ngie i Moses. ");
INSERT INTO ksd_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Ma ra Luluai i ga tata pire Moses dari: ");
INSERT INTO ksd_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Una mal ta ura vuvu na silva; una pait dir ma ra silva di tutut ia; upi una oro guve ra tarai ma dir, ma upi da vaarike ba da tur pa ra vinavana. ");
INSERT INTO ksd_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Ma ba di vu dir, ra tarai par diat a vana varurung piram ta ra matakilalat i ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ma ba di vu tikai ka, ra umana luluai ka, nina dia lualua ta ra umana vuna tarai Israel, diat a vana varurung piram. ");
INSERT INTO ksd_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Ma ba ava vuvu na vaninara, a umana gunan ta ra papar a taur diat a tur pa ra vinavana. ");
INSERT INTO ksd_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Ma ba ava vuvu na vaninara a vauruana pakana, a umana gunan ta ra papar a taubar diat a tur pa ra vinavana; diat a vuvu na vaninara ure kadia vinavana. ");
INSERT INTO ksd_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Ma ba di oro guve ra kor na tarai, avat a vuvu, ma koko avat a vuvu na vaninara. ");
INSERT INTO ksd_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Ma ra umana natu i Aron, ra umana tena tinabar, diat a vu ra ura vuvu; ma na da ra varkurai vatikai pire vavat ta kavava lavur taun tarai. ");
INSERT INTO ksd_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Ma ba ava tut na vinarubu ta kavava gunan ure ra ebar nina i arung bat avat, avat a vuvu na vaninara ma ra ura vuvu; ma da nuk pa avat ta ra luaina mata i ra Luluai kavava God, ma da valaun avat kan kavava lavur ebar. ");
INSERT INTO ksd_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Ma ta ra bung na gugu bula, ma ta kavava lavur lukara na lotu, ma ta ra lavur kalamana gai, avat a vu ra ura vuvu taun kavava lavur tinabar di tun tar diat, ma taun kavava lavur tinabar na varmaram; ma na da ra magit na varvanuknuk pire vavat ta ra luaina mata i kavava God; iau ra Luluai kavava God. ");
INSERT INTO ksd_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Ta ra vauruana kilala, ta ra vauruana gai ma ta ra ura vinun na bung, di ga kari ra bakut urama kan ra pal ure ra tinata. ");
INSERT INTO ksd_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Ma ra tarai Israel dia ga tur pa kadia vinavana kan ra bil Sinai; ma ra bakut i ga tur ta ra bil Paran. ");
INSERT INTO ksd_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ma dia ga tur pa kadia vinavana da ra vartuluai kai ra Luluai ta ra ngie i Moses. ");
INSERT INTO ksd_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Ma ra vakilang i ra gunan kai ra vuna tarai Iuda i ga tur value pa ra vinavana da kadia lavur kor; ma Nason natu i Aminadab i ga lue nam ra kor. ");
INSERT INTO ksd_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Ma Netanel natu i Suar i ga lue ra kor kai ra vuna tarai Isakar. ");
INSERT INTO ksd_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Ma Eliab natu i Elon i ga lue ra kor kai ra vuna tarai Sebulun. ");
INSERT INTO ksd_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ma di ga pala pa ra pal na mal; ma ra umana natu i Gerson, ma ra umana natu i Merari, nina dia ga puak ra pal na mal, dia ga tur pa ra vinavana. ");
INSERT INTO ksd_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ma ra vakilang i ra gunan kai Ruben i ga tur pa ra vinavana da kadia lavur kor; ma Elisur natu i Sedeur i ga lue nam ra kor. ");
INSERT INTO ksd_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Ma Selumiel natu i Surisadai i ga lue ra kor kai ra vuna tarai Simeon. ");
INSERT INTO ksd_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Ma Eliasap natu i Deuel i ga lue ra kor kai ra vuna tarai Gad. ");
INSERT INTO ksd_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Ma ra apik na tarai Koat dia ga tur pa ra vinavana, ma dia ga puak ra lavur magit i gomgom; ma dia ga vatut ra pal na mal ba pa dia ga ti pot. ");
INSERT INTO ksd_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ma ra vakilang i ra gunan kai ra vuna tarai Epraim i ga tur pa ra vinavana da kadia lavur kor; ma Elisama natu i Amiud i ga lue nam ra kor. ");
INSERT INTO ksd_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Ma Gamaliel natu i Pedasur i ga lue ra kor kai ra vuna tarai Manase. ");
INSERT INTO ksd_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Ma Abidan natu i Gideoni i ga lue ra kor kai ra vuna tarai Beniamin. ");
INSERT INTO ksd_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ma ra vakilang i ra gunan kai ra vuna tarai Dan, nina i ga murmur bat ra lavur kor, i ga tur pa ra vinavana, da kadia lavur kor; ma Akieser natu i Amisadai i ga lue nam ra kor. ");
INSERT INTO ksd_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Ma Pagiel natu i Okram i ga lue ra kor kai ra vuna tarai Aser. ");
INSERT INTO ksd_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ma Akira natu i Enan i ga lue ra kor kai ra vuna tarai Naptali. ");
INSERT INTO ksd_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Damana ra tarai Israel dia ga vanavana da kadia lavur kor; ma dia ga tur pa ra vinavana. ");
INSERT INTO ksd_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Ma Moses i ga biti tai Kobab, natu i Reuel a te Midian, nimu i Moses, dari: Ave vanavana upi ra gunan nina ra Luluai i ga biti ba na tabar avet me; dat a varagur, ma avet a pait ra boina piram; tago ra Luluai i ga biti ba na pait ra boina pire Israel. ");
INSERT INTO ksd_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ma i ga biti tana: Pa ina vana, ia kaka ina talil mulai ta kaugu gunan, tadav ra umana niurugu. ");
INSERT INTO ksd_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Ma i ga biti: Iau lul u, ba koko una vana kan avet; tago u nunure ba avet a vatur kaveve umana pal na mal ta ra bil, ma una da ra kiau na mata ure avet. ");
INSERT INTO ksd_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Ma na dari, ona da varagur; maia pa, na dari, ba ra lavur bo na magit ra Luluai na pait ia ta vevet, avet bula avet a pait ia tam. ");
INSERT INTO ksd_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Ma dia ga tur pa ra vinavana kan ra luana kai ra Luluai a utul a bung; ma ra bok na kunubu kai ra Luluai i ga lua ta diat a utul a bung upi na tikan ta pakana ba diat a ngo tana. ");
INSERT INTO ksd_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Ma ra bakut kai ra Luluai i ga vanavana taun diat, ba dia ga tur pa ra vinavana kan ra gunan. ");
INSERT INTO ksd_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Ma ba ra bok na kunubu i ga tur pa ra vinavana, Moses i ga biti: Una tut, Luluai, ma una korot varbaiane kaum lavur ebar; boina ba diat dia milikuane u, diat a takap ta ra luaina matam. ");
INSERT INTO ksd_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Ma ba i ga ngo kan ra vinavana, i ga biti: Una lilikun, Luluai, tadav ra umana arip na marmar kai Israel. ");
INSERT INTO ksd_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Ma ra tarai dia ga tata mukumuk, ma i ga kaina ta ra talinga i ra Luluai; ma ba ra Luluai i ga valongore, i ga karangap kana kankan, ma ra iap kai ra Luluai i ga birao livuan ta diat, ma i ga vaimur vue ta umana pakana ta ra langun ta kadia gunan. ");
INSERT INTO ksd_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Ma ra tarai dia ga tangi tadav Moses; ma Moses i ga araring tadav ra Luluai, ma ra iap i ga ngo. ");
INSERT INTO ksd_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ma di ga vatang ra iang i nam ra pakana ba Tabera (“Birao”), tago ra iap kai ra Luluai i ga birao livuan ta diat. ");
INSERT INTO ksd_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Ma ra tarai vakuku nina dia ga ki livuan ta diat, dia ga manga anan mulai upi ta kirip; ma ra tarai Israel bula dia ga tangi mulai, ma dia ga biti: Gala adat ta ik a kirip! ");
INSERT INTO ksd_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Mari ka ra en da ga en vakuku ia aro Aigipto, ma ra kukaba, ma ra melen, ma ra pit, ma ra anion, ma ra kavavar; ");
INSERT INTO ksd_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ma go ra dekdek i dat i panie; ma pa da gire mule ta magit, ia kaka ra mana. ");
INSERT INTO ksd_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Ma ra mana i da ra pat na davai ik, i pua, ma ra matana i da ra bulit na davai. ");
INSERT INTO ksd_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","A tarai dia ga vana vurvurbit, ma dia ga varurue, ma dia ga gigie ta ra vat na uduudu, ba dia ga rigi ia ta ra la na riririgi, ba dia ga kabalane, ma dia ga tun ia; ma ra kalamina i da ra kalami ra gem di tun ia ma ra dangi. ");
INSERT INTO ksd_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Ma ba ra mavoko i ga bura taun ra gunan ta ra marum, a mana bula i ga bura. ");
INSERT INTO ksd_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Ma Moses i ga valongore ra tinangi kai ra tarai, ta kadia lavur apik na tarai, tikatikai ta ra matakilalat i kana pal na mal; ma i ga manga karangap ra kankan kai ra Luluai; ma i ga kaina ta ra luaina mata i Moses. ");
INSERT INTO ksd_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Ma Moses i ga biti tai ra Luluai: Dave u vakaina kaum tultul? Ma ta ra ava pa u mari iau, tago u vakakap iau ma go ra tarai? ");
INSERT INTO ksd_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Dave, iau ga lalau pa go ra tarai? Dave, iau ga kava diat? Upi una biti tagu dari: Una puak diat ta ra bongobongom, da tama i ra kuramana i puak ia, tar ta ra gunan ba u ga vavalima tar ia pire ra umana tama i diat? ");
INSERT INTO ksd_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Akave ra kirip, upi ina tabar go ra tarai par me? Tago dia tangi piragu dari: Tabar avet ma ra kirip upi avet a en ia. ");
INSERT INTO ksd_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Iau mama puak varkolono pa go ra tarai, tago ra kinakap i manga mamat piragu. ");
INSERT INTO ksd_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ma ona u pait ia damana piragu, una doko iau ta kaum varmari, upi koko ina gire kaugu kini na malari. ");
INSERT INTO ksd_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Ma ra Luluai i ga biti tai Moses: Una varurue lavurua na vinun na patuana kai ra tarai Israel piragu, nina u nunure ba diat a umana patuana kai ra tarai, ma kadia umana tena varkurai; ma una agure diat ta ra pal na varbarat, upi diat a tur varurung ma u abara. ");
INSERT INTO ksd_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ma ina vana ba ma dor a pirpir abara; ma ina tatak pa ta ra tulungen i ki tam, ma ina vung tar ia ta diat; ma dat a pupuak maravut u ure ra kinakap kai ra tarai, upi koko u puak varkolono pa ia. ");
INSERT INTO ksd_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Ma una biti tai ra tarai: Avat a vagomgom mule avat ure ningene, ma avat a en ra kirip; tago ava ga tangi ta ra talinga i ra Luluai dari, Gala avevet ta ik a kirip! tago i ga boina pire vevet aro Aigipto; kari ra Luluai na tabar avat ma ra kirip, ma avat a ian. ");
INSERT INTO ksd_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Pa avat a ian ta tika na bung uka, ba ta urua, ba ta ilima, ba ta vinun, ba ta ura vinun; ");
INSERT INTO ksd_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","a kidoloina gai parika avat a ian, tuk na vuvut rikai ta ra bilau i vavat, ma na buabua pire vavat; tago ava ga pilak vue ra Luluai nina i ki livuan ta vavat, ma ava ga tangi ta ra luaina matana dari: Upi ra ava ave ga irop kan ra gunan Aigipto? ");
INSERT INTO ksd_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Ma Moses i ga biti: A tarai nina iau ki livuan ta diat, laptikai na mar na arip na tena vinavana diat; ma u ga biti, Ina tabar diat ma ra kirip, upi diat a ian tana a.kidoloina gai. ");
INSERT INTO ksd_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Dave, da doko ra umana kikil na sip ma ra umana kikil na bulumakau upi na topa diat? Ba da al varurue ra lavur en ta ra ta upi na topa diat bar? ");
INSERT INTO ksd_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Ma ra Luluai i ga biti tai Moses: Dave ra lima i ra Luluai pa i lolovina? Go una gire ba da pait ot pa kaugu tinata piram ba pata. ");
INSERT INTO ksd_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Ma Moses i ga irop, ma i ga ve ra tarai ta ra lavur tinata kai ra Luluai; ma i ga varurue a lavurua na vinun na patuana kai ra tarai, ma i ga vaki diat kikil ra pal na mal. ");
INSERT INTO ksd_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Ma ra Luluai i ga vana ba ta ra bakut, ma i ga tata pirana, ma i ga tatak pa ta ra tulungen i ga ki tana, ma i ga vung tar ia ta ra lavurua na vinun na patuana; ma ba ra tulungeana i ga ki taun diat, dia ga tata na propet, ia kaka namur pa dia ga pait mule. ");
INSERT INTO ksd_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ma a ura tutana dir ga ki boko ta ra gunan, a iang i tikai Eldad, ma ra iang i ta ra tikai Medad; ma ra tulungen i ga ki taun dir; di ga tumu ra iang i dir ma pa dir ga irop tadav ra pal na mal, ma dir ga tata na propet ta ra gunan. ");
INSERT INTO ksd_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Ma tika na barmana i ga vutvut, ma i ga ve Moses, ma i ga biti: Eldad ma Medad dir tatata na propet ta ra gunan. ");
INSERT INTO ksd_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Ma Iosua natu i Nun, a tultul kai Moses, tikai ta diat i ga pilak pa diat, i ga biti: Kaugu luluai Moses, una tur bat dir. ");
INSERT INTO ksd_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Ma Moses i ga biti tana: Dave u varngu ure iau? Gala ra tarai par kai ra Luluai dia a tata na propet, ma gala ra Luluai na vung tar ra Tulungeana ta diat par! ");
INSERT INTO ksd_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Ma Moses, diat ma ra umana patuana kai ra tarai Israel, dia ga lilikun ta ra gunan. ");
INSERT INTO ksd_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Ma ra vuvu kai ra Luluai i ga arikai, ma i ga kap vaarike ra umana voro mara na ta, ma i ga vabura diat taun ra gunan; ma dia ga va kikil ra gunan i da ra vinavana ta ra kopono bung ta go ra papar, ma i da ra vinavana ta ra kopono bung ta ra papar maro, ma ra vuvungaina i da ra ura malmalikun ta ra pia. ");
INSERT INTO ksd_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ma ra tarai dia ga tut ta nam ra bung, ma ta ra marum, ma ta ra bung namur bula, ma dia ga varurue ra umana voro; nina i ga varurue ra ikilik ta diat i varurue tika na mar na epa tana; ma dia ga vuare diat vurvurbit ta ra gunan. ");
INSERT INTO ksd_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ma ba ra viono i ga ki boko ta ra ngie i diat, ma pa dia ga en vapar ia, ra kankan kai ra Luluai i ga karangap ure ra tarai, ma ra Luluai i ga ubu ra tarai ma ra kaina minait. ");
INSERT INTO ksd_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Ma di ga vatang ra iang i nam ra pakana ba Kibrot-Atava (“Punang ra Mamainga”): tago dia ga punang ra tarai nina dia ga mamainga vakuku abara. ");
INSERT INTO ksd_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Ma ra tarai dia ga vanavana papa Kibrot-Atava upi uro Kaserot; ma dia ga ki aro Kaserot. ");
INSERT INTO ksd_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Ma Miriam ma Aron dir ga tata bat Moses ure ra vavina Kus nina i ga taule; tago i ga taule ra vavina Kus. ");
INSERT INTO ksd_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ma dir ga biti: Dave, ra Luluai i ga tata ka tai Moses? Pa i ga tata ta mimir bula vang? Ma ra Luluai i ga valongore. ");
INSERT INTO ksd_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Ma ra tutana Moses i ga madu tuna ra maukuana, ta diat ra tarai par ta ra rakarakan a gunagunan. ");
INSERT INTO ksd_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Ma ra Luluai i ga vakaian dital Moses ma Aron ma Miriam, ma i ga biti: Amutal a vana uti ta ra pal na varbarat. Ma dital ga irop. ");
INSERT INTO ksd_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Ma ra Luluai i ga vana ba ta ra bakut ma i ga tur ta ra matakilalat i ra pal na varbarat, ma i ga oro pa Aron ma Miriam; ma dir ga vana rikai. ");
INSERT INTO ksd_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Ma i ga biti: Amur a valongore kaugu tinata: gala ta propet i ki livuan ta vavat, iau ra Luluai ina vaarike tar iau mulai pirana ta ra ninana, ma ina tata pirana ta ra ririvon. ");
INSERT INTO ksd_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Kaugu tultul Moses pa i damana; ia iat i dovot ta ra kubagu parika; ");
INSERT INTO ksd_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","amir tata vargil ma ra ngie i mimir, i kapa ma vakir i pidik; ma ia iat na gire ra malalar i ra Luluai; dave pa amur ga burut upi amur a tata bat kaugu tultul Moses? ");
INSERT INTO ksd_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Ma ra kankan kai ra Luluai i ga karangap ure dir. Ma i ga vana ka. ");
INSERT INTO ksd_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Ma ra bakut i ga kakari kan ra ul a pal na mal, ma ea, Miriam i ga vukavuka, i pua da ra kabang; ma Aron i ga bobe Miriam, ma ea, i ga vukavuka. ");
INSERT INTO ksd_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Ma Aron i ga biti tai Moses: Kaugu luluai, koko una bali kamimir varpiam, iau lul u, tago amir ga papait na papaua, ma amir ga pait ra varpiam. ");
INSERT INTO ksd_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Iau lul u, koko da nur vue upi na da ra minat, nina ra viono i papar a iba ba di kava vue. ");
INSERT INTO ksd_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Ma Moses i ga kail tadav ra Luluai, ma i ga biti; Una valagar ia, God, iau lul u. ");
INSERT INTO ksd_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Ma ra Luluai i ga biti tai Moses: Gala tamana i ga nami ka ra matana, na ga vavirvir lavurua na bung, laka? Da banu bat ia ta ra papar a gunan irai lavurua na bung, ma namur da varuk mule. ");
INSERT INTO ksd_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Ma di ga banu bat Miriam ta ra papar a gunan irai lavurua na bung; ma ra tarai pa dia ga vanavana tuk ba di ga varuk mule Miriam. ");
INSERT INTO ksd_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Ma namur ra tarai dia ga vanavana papa Kaserot, ma dia ga vatur kadia lavur pal na mal ta ra bil Paran. ");
INSERT INTO ksd_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Ma ra Luluai i ga tata pire Moses, dari: ");
INSERT INTO ksd_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Una tulue ta umana tutana, upi diat a matoto lua ta ra gunan Kanaan, nina iau ga tul tar ia pire ra tarai Israel; avat a tulue tikai ta ra lavur vuna tarai tikatikai, da pilak pa ka nina dia lualua pire ra tarai. ");
INSERT INTO ksd_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Ma Moses i ga tulue diat maro ra bil Paran da ra vartuluai kai ra Luluai; ma diat par a umana lualua pire ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Ma go ia ra iang i diat: Samua natu i Sakur ta ra vuna tarai Ruben, ");
INSERT INTO ksd_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Sapat natu i Kori ta ra vuna tarai Simeon, ");
INSERT INTO ksd_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Kaleb natu i Iepune ta ra vuna tarai Iuda, ");
INSERT INTO ksd_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Igal natu i Iosep ta ra vuna tarai Isakar, ");
INSERT INTO ksd_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Osea natu i Nun ta ra vuna tarai Epraim, ");
INSERT INTO ksd_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Palti natu i Rapu ta ra vuna tarai Beniamin, ");
INSERT INTO ksd_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Gadiel natu i Sodi ta ra vuna tarai Sebulun, ");
INSERT INTO ksd_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Gadi natu i Susi ta ra vuna tarai Iosep (a vuna tarai Manase nam), ");
INSERT INTO ksd_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Amiel natu i Gemali ta ra vuna tarai Dan, ");
INSERT INTO ksd_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Setur natu i Mikael ta ra vuna tarai Aser, ");
INSERT INTO ksd_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nakbi natu i Vopsi ta ra vuna tarai Naptali, ");
INSERT INTO ksd_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Geuel natu i Maki ta ra vuna tarai Gad. ");
INSERT INTO ksd_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Go ia ra iang i diat nina Moses i tulue diat upi diat a matoto lua ta ra gunan. Ma Moses i ga vaiang Osea natu i Nun ba Iosua. ");
INSERT INTO ksd_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Ma Moses i ga tulue diat upi diat a matoto lua ta ra gunan Kanaan ma i ga biti ta diat: Avat a vana ta ra nga urama Negeb, ma avat a tutua ta ra lualuana; ");
INSERT INTO ksd_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ma avat a gire ra gunan, ba i dave; ma ra tarai bula, ba dia dekdek ba pa dia dekdek, ba dia paupau ka ba dia mangoro; ");
INSERT INTO ksd_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ma ra gunan nina dia ki tana, ba i boina ba i kaina, ma kadia lavur pia na pal ba dia tur vakuku ka ba di ga liplip bat diat; ");
INSERT INTO ksd_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ma ra pia, ba i boina ba i kaina, ba ta davai tana ba pata. Ma avat a tur padikat ma avat a kap ta umana vuai ra gunan. Nam ra e, a turpai ra minatuka ure ra vuai na vain. ");
INSERT INTO ksd_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Damana dia ga vana urama, ma dia ga matoto ta ra gunan papa ra bil Sin ma tuk uro Rekob, ta ra langun Kamat. ");
INSERT INTO ksd_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ma dia ga vana urama Negeb ma dia ga bolo vanavana Kebron ma Akiman, Sesai ma Talmai nina ra tarai Anak dia ki tana. (Di ga vatut Kebron lavurua na kilala lua ta ra pia na pal Soan ta ra gunan Aigipto.) ");
INSERT INTO ksd_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ma dia ga tadav ra male Eskol, ma dia ga mut vue ra ingar i ra davai na vain nina ra kopono kurene tana, ma a urua dir ga kip ia; ma dia ga kap ra vuai na goava ma ra vuai na lovo bula. ");
INSERT INTO ksd_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Di ga vatang nam ra pakana ba ra male Eskol (“Kurene”), ure ra kura vain nina ra tarai Israel dia ga mut vue abara. ");
INSERT INTO ksd_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Ma ba i par a ivat na vinun na bung, dia ga lilikun kan ra ginigira ta ra gunan. ");
INSERT INTO ksd_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Ma dia ga vana ma dia ga tadav Moses ma Aron ma ra kor na tarai Israel ta ra bil Paran aro Kades; ma dia ga kap ra varvai pire diat ma ra kor na tarai, ma dia ga ve tar ra vuai ra gunan ta diat. ");
INSERT INTO ksd_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ma dia ga varvai pirana, ma dia ga biti: Ave ga tadav ra gunan nina u ga tulue avet upi ia, ma a dovotina i alir ma ra polo na u ma ra polo na livur; ma go ia ra vuaina. ");
INSERT INTO ksd_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","la kaka ra tarai nina dia ki ta ra gunan dia dekdek, ma ra umana pia na pal di liplip bat diat ma dia ngala; ma tikai bula, ave ga gire ra tarai Anak akamana. ");
INSERT INTO ksd_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","A tarai Amalek dia ki aro Negeb; ma ra tarai Ket, ma ra tarai Iebus, ma ra tarai Amor dia ki ta ra lualuana; ma ra tarai Kanaan dia ki ra valvalian ma ta ra papar a Iordan bula. ");
INSERT INTO ksd_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ma Kaleb i ga vango ra tarai ta ra luaina mata i Moses, ma i ga biti: Dat a vana lulut urama, ma dat a kale; tago i tale dat upi dat a uvia pa ia. ");
INSERT INTO ksd_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ma ra tarai nina dia ga vana varurung me, dia ga biti: Pa i tale dat upi dat a varubu ma ra tarai; tago dia ongor ta dat. ");
INSERT INTO ksd_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ma dia ga kap ra kaina varvai tadav ra tarai Israel ure ra gunan ba dia ga matoto lua tana, ma dia ga biti: Go ra gunan i en vue diat dia ki tana, ra gunan ave ga vana tana ma ave ga matoto lua tana; ma ave ga gire ba ra tarai par a umana lololovina diat. ");
INSERT INTO ksd_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Ma ave ga gire ra umana lolovina tutana tuna, ra umana natu i Anak, ta ra vuna tarai Nepilim; ma ta kaveve ginigira ave ga da ra umana kubau, ma damana bula ta kadia ginigira. ");
INSERT INTO ksd_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Ma ra kor na tarai dia ga kukukula ma ra nilai diat; ma ra tarai dia ga tangtangi ta nam ra marum. ");
INSERT INTO ksd_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ma ra tarai Israel par dia ga tata mukumuk ure Moses ma ure Aron; ma ra kor na tarai par dia ga biti ta dir: Gala ave ga mat ta ra gunan Aigipto! ba gala ave ga mat ta go ra bil! ");
INSERT INTO ksd_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Upi ra ava ra Luluai i agure avet tadav go ra gunan, upi avet a virua ta ra pakat na vinarubu? Diat a al pa kaveve umana taulai ma ra umana natu i vevet; gala na boina upi dat a lilikun mulai uro Aigipto! ");
INSERT INTO ksd_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ma dia ga biti vargil dari: Dat a pilak pa tika na lualua, ma dat a lilikun mulai uro Aigipto. ");
INSERT INTO ksd_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Ma Moses ma Aron dir ga bura palar ta ra luaina mata i ra kivung kai ra kor na tarai Israel; ");
INSERT INTO ksd_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","ma Iosua natu i Nun ma Kaleb natu i Iepune, nina dir ta diat dia ga matoto lua ta ra gunan, dir ga rada kadir umana mal; ");
INSERT INTO ksd_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ma dir ga tata pire ra kor na tarai Israel dari: Ra gunan nina ave ga vanavana tana upi avet a matoto lua tana, ia ra bo na gunan tuna. ");
INSERT INTO ksd_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Gala ra Luluai i manane dat, na agure vaolo dat ta go ra gunan, ma na tabar dat me, a gunan nina i alir ra polo na u ma ra polo na livur tana. ");
INSERT INTO ksd_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","la kaka koko avat a tut na varpiam ure ra Luluai, ma koko avat a burutue ra tarai ta ra gunan; tago ada nian diat, di ga tak vue kadia bakbakit, ma ra Luluai i ki pire dat; koko avat a burutue diat. ");
INSERT INTO ksd_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ma ra kor na tarai dia ga biti ba da tupar dir ma ra vat. Ma ra minamar i ra Luluai i ga vana rikai ta ra pal na varbarat pire ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Ma ra Luluai i ga biti tai Moses: Aivia ra bung boko go ra tarai diat a pidimuane iau? ma aivia ra bung pa diat a nurnur tagu, ure ra lavur vakilang ba iau ga pait ia livuan ta diat? ");
INSERT INTO ksd_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ina ubu diat ma ra kaina minait, ma ina okole vue diat, ma ina vatut ra tarai tam ba na ngala ma na dekdek ta diat. ");
INSERT INTO ksd_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Ma Moses i ga biti tai ra Luluai: A tarai Aigipto diat a valongore; tago u ga ben vairop go ra tarai kan diat ma ra dekdekim; ");
INSERT INTO ksd_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ma diat a varvai tana pire ra tarai nina dia ki ta go ra gunan; dia ga valongore ba u ra Luluai u ki livuan ta go ra tarai; tago dia varboboi ma u ra Luluai, ma kaum bakut i tur taun diat, ma u lualua ta diat ta ra bakut ta ra bung na keake, ma ta ra biro na iap ta ra marum. ");
INSERT INTO ksd_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ma ona una doko go ra tarai par, a umana vuna tarai nina dia ga valongore ra ngala na varvai ure u diat a biti dari: ");
INSERT INTO ksd_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Ra Luluai i ga doko go ra tarai ta ra bil tago i mama agure vaolo diat ta ra gunan ba i ga vavalima tar ia ta diat. ");
INSERT INTO ksd_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Ma go, iau lul u, boina ba na ngala ra dekdek i ra Luluai, da u ga tatike: ");
INSERT INTO ksd_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Ra Luluai i vavabing ma ra kankan, ma i buka ma ra varmari, i pun vue ra bilak na mangamangana ma ra varpiam, ma pa na valangalanga muka ra tena varpiam; na bali ka ra bilak na varpiam kai ra tarai pire ra umana natu i diat ma pire ra umana bul mur ta diat tuk tar ta ra vautuluna ma ra vaivatina taun tarai. ");
INSERT INTO ksd_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Iau lul u ba una nur vue ra varpiam kai go ra tarai ure kaum ngala na varmari, ma da u ga puak pa diat papa aro Aigipto ma tuk tar gori. ");
INSERT INTO ksd_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Ma ra Luluai i ga biti: Iau ga nur vue da kaum tinata; ");
INSERT INTO ksd_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ma a dovotina, da iau laun, ma da ra rakarakan a gunagunan na kor ma ra minamar i ra Luluai; ");
INSERT INTO ksd_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","tago nam ra tarai nina dia gire kaugu minamar, ma kaugu lavur vakilang nina iau ga pait diat aro Aigipto ma ta ra bil, dia ga valar iau go ra vinun na pakana, ma pa dia ga torom ta ra nilaigu; ");
INSERT INTO ksd_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","a dovotina pa diat a gire ra gunan nina iau ga vavalima tar ia ta ra umana tama i diat, ma pa ta tikai ta diat dia ga pidimuane iau na gire; ");
INSERT INTO ksd_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","ia kaka Kaleb kaugu tultul, tago a enana ninunuk pirana, ina ben vaola ta ra gunan nina i ga vanavana tana; ma ra umana bul mur tana diat a kale. ");
INSERT INTO ksd_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Ma go ra tarai Amalek ma ra tarai Kanaan dia ki ta ra male; ningene avat a lilikun uro ta ra bil ta ra nga uro ta ra Ta Meme. ");
INSERT INTO ksd_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Ma ra Luluai i ga tata pire Moses ma pire Aron dari: ");
INSERT INTO ksd_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Aivia ra bung boko go ra kaina tarai diat a tata mukumuk ure iau? Iau ga valongore ra tinata na urur kai ra tarai Israel, nina dia tatike ure iau. ");
INSERT INTO ksd_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Una biti ta diat: Da iau laun, ra Luluai i biti, da ava ga tatike ta ra talingagu, a dovotina ina pait ia damana ta vavat; ");
INSERT INTO ksd_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","a umana minat i vavat diat a mareng ta go ra bil; ma avat par di ga luk avat, da ra niluluk i vavat par ba i bolo ra ura vinun kavava kilala, nina ava ga tata mukumuk ure iau, ");
INSERT INTO ksd_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","a dovotina pa avat a olo ta ra gunan nina iau ga tulue ra limagu ure upi ina vaki avat i tana, ia kaka Kaleb natu i Iepune, ma Iosua natu i Nun, ");
INSERT INTO ksd_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","ma ra umana natu i vavat nina ava ga biti ba da al pa diat, ina agure vaolo diat, ma diat a nunure ra gunan nina ava ga pidimuane. ");
INSERT INTO ksd_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ma ga avat, a umana minat i vavat diat a mareng ta go ra bil. ");
INSERT INTO ksd_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ma ra umana natu i vavat diat a balabalaure vavaguai ta ra bil a ivat na vinun na kilala, ma diat a kairane kavava lavur varpiam, tuk tar ra umana minat i vavat diat a mareng ta ra bil. ");
INSERT INTO ksd_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Avat a puak pa kavava lavur varpiam a ivat na vinun na kilala, da ra ivat na vinun na bung ava ga matoto lua ure ra gunan tana, ma avat a nunure ba iau ki irai kan avat. ");
INSERT INTO ksd_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Iau ra Luluai iau ga tata, a dovotina ina pait go pire go ra kaina tarai nina dia tut varurung ure iau; ta go ra bil diat a panie, ma diat a mat abara. ");
INSERT INTO ksd_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Ma ra umana tutana, nina Moses i ga tulue diat upi diat a matoto lua ta ra gunan, ma nina dia ga lilikun ma dia vangangap ra tarai ure, tago dia ga kap ra kaina varvai ure ra gunan, ");
INSERT INTO ksd_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","nam ra umana tutana ba dia ga kap ra kaina varvai ure ra gunan, dia ga mat ta ra luaina mata i ra Luluai, ma ra kaina minait. ");
INSERT INTO ksd_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Ma Iosua natu i Nun, ma Kaleb natu i Iepune, dir ga mat valili ta diat dia ga matoto lua ure ra gunan. ");
INSERT INTO ksd_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Ma Moses i ga ve ra tarai Israel ta go ra lavur tinata; ma ra tarai dia ga manga tabun. ");
INSERT INTO ksd_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Ma dia ga tut ta ra malana ikilik, ma dia ga tutua ta ra ul a luana, ma dia ga biti: Io, avet go kari, avet a vana urama ta ra pakana nina ra Luluai i ga vavalima ure; tago ave ga pait ra kaina. ");
INSERT INTO ksd_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Ma Moses i ga biti: Upi ra ava ava piam vue ra vartuluai kai ra Luluai, tag) pa avat a burat? ");
INSERT INTO ksd_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Koko avat a vana urama, tago ra Luluai pa i ki livuan ta vavat; upi koko kavava lavur ebar diat a ubu avat. ");
INSERT INTO ksd_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Tago ra tarai Amalek ma ra tarai Kanaan dia ki aro na lua ta vavat, ma avat a virua ta ra pakat na vinarubu; ra Luluai pa na ki maravut avat, tago ava ga vana irai kan ra nimur pire ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","la kaka dia ga valar ra vinavana urama ta ra langun na lualuana; ma ra bok na kunubu kai ra Luluai, ma. Moses bula, pa dir ga irop kan ra gunan. ");
INSERT INTO ksd_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Ma ra tarai Amalek dia ga vana ba, ma ra tarai Kanaan nina dia ki ta ra lualuana, ma dia ga ubu diat ma dia ga korot diat tuk uro Korma. ");
INSERT INTO ksd_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Ma ra Luluai i ga tata pire Moses dari: ");
INSERT INTO ksd_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Una tata pire ra tarai Israel ma una biti ta diat: Ba avat a olo ta ra gunan ba avat a ki tana, nina iau tabar avat me, ");
INSERT INTO ksd_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ma ava mainge ba avat a pait ta tinabar ta ra iap tadav ra Luluai, a tinabar di tun tar ia, ba ra vartabar upi da pait ot pa ra vavalima, ba ra tamarigat na vartabar, ba ta ra e na lukara, upi ra magit i ang na katkat tadav ra Luluai, ta ra kikil na bulumakau ba ra kikil na sip: ");
INSERT INTO ksd_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","nina i tul tar kana vartabar na nian tadav ra Luluai na tul tar ra tinabar na vuai na uma tika na vavinun na pakana valavalar na bo na plaua, di ga pota ma tika na vaivatina pakana valavalar na dangi; ");
INSERT INTO ksd_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ma una vaninare tika na vaivatina pakana valavalar na polo na vain ure ra tinabar na nimomo varurung ma ra tinabar di tun tar ia, ba ure ra tinabar ure tikatika na nat na Sip. ");
INSERT INTO ksd_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Ma ure ra sip, a tomotoina, una vaninare tika na vailimana pakana valavalar na bo na plaua, di pota ma tika na vautuluna pakana valavalar na dangi, ure ra tinabar na vuai na uma, ");
INSERT INTO ksd_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ma ure ra tinabar na nimomo, una tul tar tika na vautuluna pakana valavalar na polo na vain, upi ra magit i ang na katkat tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Ma ba u vaninare ta bulumakau ure ra tinabar di tun tar ia, ba ure ra tinabar upi da pait ot pa ra vavalima, ba ure ra tinabar na varmaram tadav ra Luluai; ");
INSERT INTO ksd_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","da tul tar ra tinabar na vuai na uma varurung ma ra bulumakau, tika na vautuluna pakana valavalar na bo na plaua di pota ma ra ngungu valavalar na dangi. ");
INSERT INTO ksd_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Ma una tul tar ta ngungu valavalar na polo na vain ure ra tinabar na nimomo, upi ra tinabar di tun tar ia ta ra iap i ang na katkat tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Damana da pait ia ure tikatika na sip, ba ure tikatika na nat na sip, ba ure ra umana nat na me. ");
INSERT INTO ksd_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Da ra niluluk i diat avat a vaninare diat, damana avat a pait ia ure tikatikai ta diat. ");
INSERT INTO ksd_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","A umana gunan tuna diat a pait ra lavur magit dari, ba dia tul tar ra tinabar di tun tar ia ta ra iap, i ang na katkat tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Ma gala ta vaira i ki pire vavat, ba to ia bar nina na ki pire vavat ta kavava lavur taun tarai, ma i mainge ba na tul tar ra tinabar di tun tar ia ta ra iap, i ang na katkat tadav ra Luluai; da ava pait ia, ia bula na pait ia damana. ");
INSERT INTO ksd_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Ma ure ra kivung, na kopono ko ra varkurai ure avat ma ure ra vaira nina i ki pire vavat, ia ra varkurai ba na tur vatikai ta kavava lavur taun tarai; avat ma ra vaira avat a varogop uka ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Na kopono ko ra varkurai ma na kopono ko ra togotogo ure avat ma ure ra vaira nina i ki pire vavat. ");
INSERT INTO ksd_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Ma ra Luluai i ga tata pire Moses dari: ");
INSERT INTO ksd_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Una tata pire ra tarai Israel, ma una biti ta diat: Ba ava olo ta ra gunan nina iau agure tar avat i tana, ");
INSERT INTO ksd_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","na dari: ba ava en ra gem ta ra gunan, avat a tul tar ta vartabar pire ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Avat a tul tar tika na kek ure ra vartabar, ta ra plaua ba avat a udu value; avat a tul tar ia ure ra tinabar na tavul a rararama vuai. ");
INSERT INTO ksd_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Avat a tul tar ra vartabar pire ra Luluai, ta ra plaua ba avat a udu value, ta kavava lavur taun tarai. ");
INSERT INTO ksd_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Ma ona ava rara, ma pa ava pait ot pa go ra lavur vartuluai nina ra Luluai i ga tatike tai Moses, ");
INSERT INTO ksd_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","a lavur magit ra Luluai i ga vartuluai tana pire vavat ta ra ngie i Moses, papa ra bung ba ra Luluai i ga tul tar ra vartuluai tana, ma tuk tar ta kavava lavur taun tarai; ");
INSERT INTO ksd_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","na dari, ona di ga pait vatuptup ia, ma ra tarai pa dia kapa ure, a tarai diat a tul tar tika na bulumakau ure ra tinabar di tun tar ia, upi ra magit i ang na katkat tadav ra Luluai, varurung ma ra tinabar na vuai na uma tana, ma ra tinabar na nimomo tana, da ra togotogo ure, ma tika na me, a tomotoina, ure ra tinabar na varporong. ");
INSERT INTO ksd_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Ma ra tena tinabar na pait ra varporong ure ra kor na tarai Israel par, ma da nur vue; tago ia ra nirara, ma dia ga kap kadia vartabar na nian, a tinabar di tun tar ia ta ra iap tadav ra Luluai, ma kadia tinabar na varporong ta ra luaina mata i ra Luluai, ure kadia nirara; ");
INSERT INTO ksd_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","ma da nur vue ra nirara kai ra kor na tarai Israel par, ma kai ra vaira i ki pire diat; tago ra tarai par dia ga pait vatuptup ia. ");
INSERT INTO ksd_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Ma gala ta tikai i pait vatuptup ra kaina, na tul tar ra me, a tana ba i kopono ko kana kilala, ure ra tinabar na varporong. ");
INSERT INTO ksd_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Ma ra tena tinabar na pait ra varporong ure nina i ga rara, ba i ga pait vatuptup ra kaina, ta ra luaina mata i ra Luluai; ma da nur vue. ");
INSERT INTO ksd_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Na kopono ko ra varkurai ure nina i pait vatuptup ta magit, ure ra gunan tuna pire ra tarai Israel, ma ure ra vaira i ki livuan ta diat. ");
INSERT INTO ksd_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Ma nina i nunure ba i kaina ma i pait ia ka, ba ta gunan tuna ba ta vaira, i vul vakaina ra Luluai; da kutu vue nam kan kana vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Tago i ga pidimuane ra tinata kai ra Luluai, ma i ga piam vue kana vartuluai; da kutu vatukum vue nam, ma na puak kana varpiam. ");
INSERT INTO ksd_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Ma ba ra tarai Israel dia ga ki ta ra bil, di ga tadav ra tutana ba i varurue ra davai ta ra Bung Sabat. ");
INSERT INTO ksd_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Ma nina dia ga tadav ia ba i varurue ra davai dia ga ben ia pire Moses ma Aron, ma pire ra tarai par. ");
INSERT INTO ksd_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Ma dia ga banu bat ia, tago pa di ga vaarike ba da pait ra ava tana. ");
INSERT INTO ksd_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Ma ra Luluai i ga biti tai Moses: A dovotina da doko nam ra tutana; ra tarai par diat a tupar ia ma ra vat ta ra papar a gunan irai. ");
INSERT INTO ksd_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Ma ra tarai par dia ga ben vairop ia ta ra paparai ra gunan, ma dia ga tupar ia ma ra vat, ma i ga mat, da ra Luluai i ga vartuluai tana pire Moses. ");
INSERT INTO ksd_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Ma ra Luluai i ga tata pire Moses dari: ");
INSERT INTO ksd_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Una tata pire ra tarai Israel, ma una ve diat upi diat a mal tar ra umana marmar na kuara ta ra ngu i kadia lavur mal, ta kadia lavur taun tarai, ma diat a vung ra kuara i blu marut ta ra marmar na kuara ta ra lavur ngu na mal; ");
INSERT INTO ksd_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","ma na da ra marmar na kuara ure avat, upi avat a gire, ma avat a nuk vake ra lavur vartuluai kai ra Luluai, ma avat a pait ot pa diat; upi koko avat a mur ra nuknuk i ra bala i vavat ma ra ginigira na mata i vavat, nina ava ling na vana irai vakuku tana; ");
INSERT INTO ksd_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","upi avat a nuk vake kaugu lavur vartuluai ma avat a pait ot pa diat, ma avat a gomgom ure kavava God. ");
INSERT INTO ksd_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Iau ra Luluai kavava God, nina iau ga agure vairop avat kan ra gunan Aigipto, upi ina God pire vavat; iau ra Luluai kavava God. ");
INSERT INTO ksd_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Ma Kora, natu i Isar, natu i Koat, natu i Levi, ma Datan ma Abiram, a ura natu i Eliab, ma On natu i Pelet, ta ra vuna tarai Ruben, dia ga varurue ra tarai, ");
INSERT INTO ksd_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ma dia ga tut ta ra luaina mata i Moses, diat ma ta umana ta ra tarai Israel, a ura mar ma a ilima na vinun na lualua kai ra tarai, a umana tena kivung diat, ma ra umana rangrang na tutana; ");
INSERT INTO ksd_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","ma dia ga tur guvai varurung ure Moses ma ure Aron, ma dia ga biti ta dir: Amur tar manga enana; tago di tar vakilang vaire ra tarai par tikatikai, ma ra Luluai i ki livuan ta diat; ta ra ava amur tar vangala pa mule amur taun ra kor na tarai kai ra Luluai? ");
INSERT INTO ksd_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Ma ba Moses i ga valongore i ga bura timtibum; ");
INSERT INTO ksd_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ma i ga tata pire Kora ma ra taraina, ma i ga biti: Ta ra malana ra Luluai na vaarike nina ba kana, ma nina i ga vakilang vaire, ma na vamarave pirana; na vamarave nina i ga pilak pa ia pirana. ");
INSERT INTO ksd_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Avat a pait go: Kora ma ra taraina, avat a vatur ra umana la na mi, ");
INSERT INTO ksd_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ma avat a vung ra iap ta diat ma ra bulit i ang na katkat bula tana ta ra luaina mata i ra Luluai ningene; ma nina ra Luluai na pilak pa ia, da vakilang vaire nam; ava tar manga enana, avat a umana natu i Levi. ");
INSERT INTO ksd_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Ma Moses i ga biti tai Kora: Avat a umana natu i Levi, avat a valongore: ");
INSERT INTO ksd_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","dave, ia ra magit vakuku pire vavat, ba ra God kai Israel i ga tibe vaire avat kan ra kor na tarai Israel, ma i ga vamarave avat pirana, upi avat a varvakai ta ra pal kai ra Luluai, ma upi avat a tur ta ra luaina mata i ra kor na tarai upi avat a lue diat ta ra lotu; ");
INSERT INTO ksd_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","ma ba i ga vamarave u, ma ra tara na turam a umana natu i Levi bula, avat? Dave ava anan upi avat a tena tinabar bula? ");
INSERT INTO ksd_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Damana avat ma ra taraim ava ga tut varurung ure ra Luluai; ma to ia Aron upi ava tata mukumuk ure? ");
INSERT INTO ksd_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Ma Moses i ga vartuluai upi Datan ma Abiram a ura natu i Eliab; ma dir ga biti: Pa amir a vana ubarama; ");
INSERT INTO ksd_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","dave, ia ra magit vakuku ba u ga agure vairop avet kan ra gunan i alir ra polo na u ma ra polo na livur tana, upi una doko avet ta ra bil; upi una malamala king ta vevet? ");
INSERT INTO ksd_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ma tikai bula, pa u ga agure tar avet ta ra gunan i alir ra polo na u ma ra polo na livur tana, ma pa u tabar avet ma ta pia ba ta uma na vain; dave, una luak vue ra kiau na mata i go ra tarai? Pa amir a vana ubarama. ");
INSERT INTO ksd_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Ma Moses i ga manga kulot, ma i ga biti tai ra Luluai: Koko una manane kadia tinabar; pa iau ga ra pa ta as ta diat, ma pa iau ga vakaina ta tikai ta diat. ");
INSERT INTO ksd_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Ma Moses i ga biti tai Kora: Ningene avat ma ra taraim par avat a tur ta ra luaina mata i ra Luluai, u ma diat ma Aron; ");
INSERT INTO ksd_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","ma tikatikai ta vavat na vatur kana la na mi, ma na vung ra bulit i ang na katkat tana, ma tikatikai na kap kana la na mi ta ra luaina mata i ra Luluai, a ura mar ma a ilima na vinun na la na mi; u bula ma Aron tikatikai na kap kana la na mi. ");
INSERT INTO ksd_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Ma tikatikai ta diat i ga vatur kana la na mi, ma i ga vung ra iap tana, ma ra bulit i ang na katkat bula, ma dia ga tur ta ra matakilalat i ra pal na varbarat varurung ma Moses ma Aron. ");
INSERT INTO ksd_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Ma Kora i ga varurue ra kor na tarai pire diat ta ra matakilalat i ra pal na varbarat; ma ra minamar i ra Luluai i ga arikai pire ra kor na tarai. ");
INSERT INTO ksd_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Ma ra Luluai i ga tata pire Moses ma pire Aron dari: ");
INSERT INTO ksd_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Amur a tur irai kan go ra tarai, upi ina vapanie lulut vue diat. ");
INSERT INTO ksd_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Ma dir ga bura timtibum ma dir ga biti: God, a God kai ra lavur launa, dave una kankanuane ra tarai par ure ra varpiam kai tikai ka? ");
INSERT INTO ksd_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Ma ra Luluai i ga tata pire Moses. dari: ");
INSERT INTO ksd_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Una tata pire ra tarai ma una biti: Avat a vana irai kan ra kuba i Kora, Datan ma Abiram. ");
INSERT INTO ksd_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Ma Moses i ga tut ma i ga vana tadav Datan ma Abiram; ma ra umana patuana kai ra tarai Israel dia ga mur ia. ");
INSERT INTO ksd_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Ma i ga tata pire ra tarai ma i ga biti: Iau lul avat, ba avat a vana irai kan ra kubakuba i ra kaina tarai, ma koko avat a bili kadia ta magit, kan da vapanie vue avat ure kadia varpiam. ");
INSERT INTO ksd_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Damana dia ga vana irai kan ra kuba i Kora, Datan ma Abiram; ma Datan ma Abiram dir ga irop, ma dir ga tur ta ra matakilalat i kadir pal na mal, varurung ma kadir umana taulai ma.ra umana natu i dir. ");
INSERT INTO ksd_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Ma Moses i ga biti: Avat a nunure dari ba ra Luluai i ga tulue iau upi ina pait go ra lavur papalum, ma pa dia vuna ta ra nuknukigu vakuku: ");
INSERT INTO ksd_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","gala go ra tarai dia mat da ra tarai dia matmat, ba gala ta mangana varmonong nina ra tarai dia nunure i tadav diat, ra Luluai pa i ga tulue iau. ");
INSERT INTO ksd_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ma gala ra Luluai na pait ta kalamana magit, ma ra pia na panganga ma na konom pa diat ma ra tarai diat, ma dia vana ba ta ra ruarua na tulungen, a umana launana; avat a matoto tana ba go ra tarai dia ga pidimuane ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Ma ba i ga tatike vapar go ra lavur tinata, a pia ta ra vavai diat i ga panganga varbaiai; ");
INSERT INTO ksd_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","a pia i ga panganga ma i ga konom pa diat ma ra tarai ta ra kuba i diat, ma ra tarai kai Kora, ma kadia lavur tabarikik. ");
INSERT INTO ksd_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Damana diat ma kadia tarai dia ga vana ba ta ra ruarua na tulungen, a umana launana; ma ra pia i ga paum bat diat ma dia ga virua kan ra kor na tarai. ");
INSERT INTO ksd_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Ma ra tarai Israel ba dia tur kikil diat, dia ga vilau ta kadia kunukula; tago dia ga biti: Kan ra pia na konom pa dat bula. ");
INSERT INTO ksd_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Ma ra iap i ga vana rikai tai ra Luluai, ma i ga vaimur vue ra ura mar ma a ilima na vinun na tarai nina dia ga pait ra tinabar na mi. ");
INSERT INTO ksd_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Ma ra Luluai i ga tata pire Moses dari: ");
INSERT INTO ksd_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Una tata pire Eleasar, natu i Aron, ra tena tinabar, upi na kap ra umana la na mi kan ra iap, ma una imire varbaiane ra iap abara; tago dia tabu; ");
INSERT INTO ksd_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","a umana la na mi kai go ra tarai nina dia ga pait ra kaina ma dia ga virua ure, da tut vapalar diat upi da vung vapetep tar diat ta ra uguugu na vartabar; tago dia ga tul tar diat ta ra luaina mata i ra Luluai, damana diat a tabu; ma diat a da ra vakilang pire ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Ma Eleasar ra tena tinabar i ga kap ra umana la na mi na palariam gobol, nina diat dia ga virua dia ga tul tar diat; ma di ga tut vapalar diat upi da vung vapetep tar diat ta ra uguugu na vartabar; ");
INSERT INTO ksd_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","upi ra magit na varvanuknuk pire ra tarai Israel dari, ba pa ta tutana vakuku, nina vakir a bul mur tai Aron, na vana maravai upi na tul tar ra tinabar na mi ta ra luaina mata i ra Luluai, kan na da Kora ma ra taraina; da ra Luluai i ga tatike ta ra ngie i Moses. ");
INSERT INTO ksd_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Ma ta ra kubakene ra kor na tarai Israel par dia ga tata mukumuk ure Moses ma ure Aron, ma dia ga biti: Amur ga doko ra tarai kai ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Ma ba ra kor, na tarai dia ga tut varurung ure Moses ma ure Aron, dia ga gigira uro ta ra pal na varbarat; ma gire, a bakut i ga pulu ia, ma ra minamar i ra Luluai i ga vana rikai. ");
INSERT INTO ksd_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Ma Moses ma Aron dir ga vana ta ra mata na pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Ma ra Luluai i ga tata pire Moses dari: ");
INSERT INTO ksd_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Amur a tur irai kan go ra tarai upi ina vapaine lulut vue diat. Ma dir ga bura timtibum. ");
INSERT INTO ksd_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Ma Moses i ga biti tai Aron: Una kap kaum la na mi, ma una vung ra iap tana kan ra uguugu na vartabar, ma una vung ra bulit i ang na katkat tana, ma una kap lolole tadav ra kor na tarai, ma una pait ra varporong ure diat; tago ra kankan kai ra Luluai i ga vana rikai ma ra kaina minait i tar vut. ");
INSERT INTO ksd_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Ma Aron i ga kakap da Moses i ga vatang ia ma i ga vutvut pire ra kor na tarai; io, ra kaina minait i ga tar tur pa ia upi na monong diat, ma i ga vung tar ra bulit i ang na katkat, ma i ga pait ra varporong ure ra tarai. ");
INSERT INTO ksd_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Ma i ga tur livuan ta ra umana minat ma ra umana launa; ma ra kaina minait i ga par. ");
INSERT INTO ksd_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","A vinun ma a ivat na arip ma lavurua na mar dia ga mat ta ra kaina minait, (ma ta ra umana mulai dia ga mat ta ra mangamangana kai Kora). ");
INSERT INTO ksd_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Ma Aron i ga. lilikun pire Moses ta ra matakilalat i ra pal na varbarat; ma ra kaina minait i ga par. ");
INSERT INTO ksd_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Ma ra Luluai i ga tata pire Moses dari: ");
INSERT INTO ksd_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Una tata pire ra tarai Israel, ma una vatur vake ta ra umana lualua kai ra umana vuna tarai a vinun ma a ura buka, ure ra umana vuna tarai tikatikai; ma una tumu ra iang i tikatikai ta kana buka. ");
INSERT INTO ksd_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Ma una tumu ra iang i Aron ta ra buka ure ra vuna tarai Levi; ma tikatika na lualua na vuna tarai na vung tika na buka. ");
INSERT INTO ksd_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Ma una vung diat ta ra pal na varbarat ta ra luaina mata i ra tinata, aina dor varvarbarat tana. ");
INSERT INTO ksd_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Ma na dari: ra buka kai nina iau pilak pa ia na gol; ma ina vango ra umana tinata mukumuk kai ra tarai Israel kan iau, nina dia tata mukumuk me ure amur. ");
INSERT INTO ksd_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Ma Moses i ga tata pire ra tarai Israel, ma kadia lavur lualua dia ga tul tar ra vinun ma a ura buka tana, ure tikatika na lualua da kadia umana vuna tarai; ma ra buka kai Aron i ga ki livuan ta diat. ");
INSERT INTO ksd_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Ma Moses i ga vung ra umana buka ta ra luaina mata i ra Luluai ta ra pal ure ra tinata. ");
INSERT INTO ksd_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Ma i ga ningene, ma Moses i ga ruk ta ra pal ure ra tinata; ma gire, a buka kai Aron ure ra vuna tarai Levi i tar gol; ma i buk rikai, ma i pupu, ma i vuai ra vuaina. ");
INSERT INTO ksd_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Ma Moses i ga kap vaarike ra umana buka kan ra mata i ra Luluai pire ra tarai Israel par; ma dia ga gigira, ma tikatikai i ga vatur vake kana buka. ");
INSERT INTO ksd_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Ma ra Luluai i ga biti tai Moses: Una vung mule ra buka kai Aron ta ra luaina mata i ra tinata, ma da vung vake upi ra vakilang ure ra tarai na varpiam; upi una vamutue kadia lavur tinata mukumuk ure iau, upi koko diat a mat. ");
INSERT INTO ksd_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Moses i ga pait ia damana; i ga pait ia da ra Luluai i ga vartuluai pirana. ");
INSERT INTO ksd_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Ma ra tarai Israel dia ga tata pire Moses, ma dia ga biti: Ea, ave to na virua, ave tar rara, ave tar rara parika. ");
INSERT INTO ksd_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Nina i vana maravai, i vana maravai tadav ra pal kai ra Luluai, na mat; dave avet a virua par? ");
INSERT INTO ksd_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Ma ra Luluai i ga biti tai Aron: Avat ma ra umana natum ma kaum apik na tarai avat a puak ra varpiam ure ra gomgom na pal; ma avat ma ra umana natum avat a puak ra varpiam ure kavava kini na tena tinabar. ");
INSERT INTO ksd_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Ma ra tara na turam ta ra vuna tarai Levi, a vuna tarai kai tamam, una ben vamarave diat, upi diat a tur maravut u, ma diat a toratorom tam; ma avat ma ra umana natum avat a ki ta ra luaina mata i ra pal ure ra tinata. ");
INSERT INTO ksd_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ma diat a torom ta kaum vartuluai, ma ra vartuluai ure ra pal na mal; ia kaka, koko diat a vana maravai tadav ra umana gomgom na la ma tadav ra uguugu na vartabar, upi koko diat a mat, diat ba avat. ");
INSERT INTO ksd_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ma diat a tur maravut u, ma diat a torom ta ra vartuluai ure ra pal na varbarat, ure ra lavur varvakai tana; ma ra tutana vakuku pa na vana maravai pire vavat. ");
INSERT INTO ksd_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Ma avat a pait ra lavur papalum ta ra gomgom na pal ma ta ra uguugu na vartabar; upi koko ta kankan mulai na vana rikai taun ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Gire, iau ga tibe ra tara na tura i vavat ra vuna tarai Levi ta diat ra tarai Israel; iau tabar avat ma diat, a vartabar tadav ra Luluai, upi diat a varvakai ta ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ma avat ma ra umana natum avat a pait ra tiniba na tena tinabar, ure ra lavur magit ta ra uguugu na vartabar, ma ta ra bala na pal; avat a kudakudar vatikai; iau tabar avat ma ra tiniba na tena tinabar; ma nina ra tutana vakuku ba na vana maravai, da doka. ");
INSERT INTO ksd_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Ma ra Luluai i ga biti tai Aron: Gire, iau ga tabar u ma ra tiniba ta kaugu lavur tinabar, maia, iau ga tabar u ma ra lavur magit ba ra tarai Israel dia vatabue diat; kaum tiniba diat, ma ra tiniba kai ra umana natum vatikai. ");
INSERT INTO ksd_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Kaum tiniba ta ra magit i gomgom kakit ta ra iap na dari: kadia lavur vartabar na nian: kadia lavur tinabar na vuai na uma, kadia lavur tinabar na varporong, kadia lavur tinabar na nirara, nina dia tul tar ia tagu, na gomgom kakit piram ma pire ra umana natum. ");
INSERT INTO ksd_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Una ian tana da ra magit i gomgom kakit; a lavur tutana diat a ian tana; na gomgom piram. ");
INSERT INTO ksd_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Ma go bula kaum: ra tinabar di tul tar ia, a lavur tinabar na tutuluai kai ra tarai Israel; iau ga tul tar diat tam, ma tai ra umana natum, a umana tutana ma ra umana vavina, kavava tiniba vatikai; diat par dia gomgom ta ra kubam diat a ian tana. ");
INSERT INTO ksd_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Iau ga tabar u ma ra bo na dangi, ma ra bo na vuai na vain, ma ra kon, ra lavur luaina vuai e ba dia tul tar ia tai ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","A luaina vuai e ta ra lavur vunuanai ba dia kap ia pire ra Luluai, kaum; diat par dia gomgom ta ra kubam diat a ian tana. ");
INSERT INTO ksd_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Kaum ra lavur magit.di ga vatabue ta ra gunan Israel. ");
INSERT INTO ksd_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Kaum ra lavur luaina kinakava, ba di tul tar ia tai ra Luluai, a tarai ma ra lavur vavaguai; ia kaka una kia valaun ra lavur luaina natu i ra tarai, ma una kia valaun ra lavur luaina nat na vavaguai nina pa dia gomgom. ");
INSERT INTO ksd_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Una kia valaun diat ba dia laun vue tika na gai, ma una vatang ra matai diat ba ra ilima na mamat na silva, da ra mamat kai ra gomgom na pal, nina a vinun ma laptikai na gram (a ngungu auns) tana. ");
INSERT INTO ksd_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Ma ra luaina nat na bulumakau, ma ra luaina nat na sip, ma ra luaina nat na me, koko una kia valaun diat; diat a gomgom; una apur ra uguugu na vartabar ma ra gapu i diat, ma una tun ra bira i diat ure ra tinabar di tun tar ia, a magit i ang na katkat tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ma ra vio i diat kaum, da kaum ra bongobongo di tulue ma ra kelakelegi ta ra lima tuna. ");
INSERT INTO ksd_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Iau ga tul tar ra lavur tinabar i gomgom tam, nina ra tarai Israel dia tabar ra Luluai me, tam ma tai ra umana natum, a umana tutana ma ra umana vavina, kavava tiniba vatikai; ia ra kunubu na solt vatikai ta ra luaina mata i ra Luluai piram ma pire ra lavur bul mur tam. ");
INSERT INTO ksd_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Ma ra Luluai i ga biti tai Aron: Pa una kakalai ta kadia gunan ma pa kaum ta tiniba livuan ta diat; iau kaum tiniba ma kaum kakalai livuan pire ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Ma gire, iau ga tul tar ra vavinununa ta ra lavur magit tai Israel pire ra tarai Levi upi kadia tiniba, ure ra papalum ba dia pait ia, kadia varvakai ta ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Ma papa go koko ra tarai Israel diat a vana maravai ta ra pal na varbarat kan diat a kap tar ra varpiam ma diat a mat. ");
INSERT INTO ksd_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Ma ra tarai Levi diat a varvakai ta ra pal na varbarat, ma diat iat diat a kap tar kadia mangana varpiam; na da ra varkurai vatvatikai ta kavava lavur taun tarai, ma pa diat a kakalai livuan pire ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Tago ra vavinununa ta ra lavur magit kai ra tarai Israel, nina dia kap tabar ra Luluai me, iau ga tul tar ia pire ra tarai Levi upi kadia tiniba; kari iau ga biti ta diat: Pa avat a kakalai livuan pire ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Ma ra Luluai i ga tata pire Moses dari: ");
INSERT INTO ksd_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Tikai bula, una tata pire ra tarai Levi, ma una biti ta diat: Ba ava vatur vake ta vavinununa tai ra tarai Israel, nina iau ga tul tar ia ta vavat upi kavava tiniba, avat a kabila tul tar ra tinabar tana pire ra Luluai, ta vavinununa tana. ");
INSERT INTO ksd_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Ma kavava tinabar na da ra kon ta ra pal na rararama vuai ma ra polo na vain ta ra tung na bingbing vain pire vavat. ");
INSERT INTO ksd_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Damana avat a kabila tul tar ra tinabar tadav ra Luluai ta ra vavinununa nina ava vatur vake tai ra tarai Israel; ma avat a tul tar ra tinabar kai ra Luluai tana pire Aron ra tena tinabar. ");
INSERT INTO ksd_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Ta kavava lavur vartabar avat a tul tar ra lavur tinabar kai ra Luluai ta ra magit i boina kakit, nam ra pakana tana na gomgom. ");
INSERT INTO ksd_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Damana una biti ta diat: Ba ava tar tul tar ra magit i boina kakit tana, na da ra magit ta ra pal na rararama vuai, ma ra magit ta ra tung na bingbing vain pire ra tarai Levi. ");
INSERT INTO ksd_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Ma avat a ian tana ta kavava lavur pakana, avat ma diat ta ra kubakuba i vavat; ia kavava vapuak ure kavava varvakai ta ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Ma pa avat a puak ra varpiam ure, ba ava tar tul tar ra magit i boina kakit tana; ma koko avat a papait vakuku ma ra magit ba ra tarai Israel dia vagomgom ia, kan avat a mat. ");
INSERT INTO ksd_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Ma ra Luluai i ga tata pire Moses ma pire Aron dari: ");
INSERT INTO ksd_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Go ia ra varkurai na varvateten nina ra Luluai i ga vartuluai tana dari: Una tata pire ra tarai Israel upi diat a kap ta kubar na bulumakau piram, a tana nina i ko kakit ma pa di ga vung ra kip tana. ");
INSERT INTO ksd_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Ma avat a tul tar ia tai Eleasar ra tena tinabar, ma na ben vaire ta ra papar a gunan, ma da doka ta ra luaina matana; ");
INSERT INTO ksd_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","ma Eleasar ra tena tinabar na vadudu ra kaka na limana ta ra gapuna, ma na pikire tar ra gapuna ta ra mata na pal na varbarat lavurua na pakana; ");
INSERT INTO ksd_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","ma da tun vue ra bulumakau ta ra luaina matana; da tun vue ra palina ma ra viono ma ra gapuna ma ra puta tana; ");
INSERT INTO ksd_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","ma ra tena tinabar na vatur ra davai na tagatagal, ma ra isop, ma ra mal meme, ma na vue tarie diat ta ra ul a iap na bulumakau. ");
INSERT INTO ksd_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Ma ra tena tinabar na puk kana lavur mal, ma na gumu ta ra tava, ma namur na ruk ta ra gunan, ma ra tena tinabar pa na gomgom tuk na ravian. ");
INSERT INTO ksd_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Ma nina i ga tun vue na puk kana lavur mal, ma na gumu ta ra tava, ma pa na gomgom tuk na ravian. ");
INSERT INTO ksd_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Ma tikai ba i gomgom na varurue ra kabu i ra bulumakau, ma na vung ia ta ra pakana i gomgom ta ra papar a gunan, ma da vung vake ure ra kor na tarai Israel ure ra tava ba na tak vue ra varpiam. ");
INSERT INTO ksd_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Ma nina i ga varurue ra kabu i ra bulumakau na puk kana lavur mal ma pa na gomgom tuk na ravian; na da ra varkurai vatvatikai pire ra tarai Israel ma pire ra vaira nina i ki livuan ta diat. ");
INSERT INTO ksd_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Nina i bili ra minat i ta tikai pa na gomgom a lavurua na bung; ");
INSERT INTO ksd_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","na vagomgom ia iat mulai ma ra tava ta ra vautuluna bung ma ta ra valavuruana bung bula ma damana na gomgom; ma gala pa i vagomgom ia iat mulai ta ra vautuluna bung, pa na gomgom ta ra valavuruana bung. ");
INSERT INTO ksd_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Nina i bili ra minat i ta tikai ma pa i vagomgom ia iat mulai, i vadur ra pal tabu kai ra Luluai; pa na gomgom tago pa di ga apur ia ma ra tava ure ra dur; a duruna i ki boko. ");
INSERT INTO ksd_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Go ia ra varkurai ba ta tikai i mat ta ra pal na mal; diat par dia ruk ta ra pal na mal, ma diat par dia ki tana, pa diat a gomgom ure lavurua na bung. ");
INSERT INTO ksd_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Ma ra lavur la nina pa di vi ta tubatuba tana pa diat a gomgom. ");
INSERT INTO ksd_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Ma nina i vanavana ara ra pia ma i bili ta tikai ba di ga doka ta ra vinarubu, ba ta minat, ba ta ur na tutana, ba ta pia na pupunang, pa na gomgom a lavurua na bung. ");
INSERT INTO ksd_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Ma ure nina pa i gomgom da tak pa ra kabu i ra tinabar na varporong ba di ga tun ia, ma da vung ra gomgom na tava varurung me ta ra la; ");
INSERT INTO ksd_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","ma ta tikai nina i gomgom na vatur ra isop, ma na vadudu ia ta ra tava, ma na apur ra pal na mal, ma ra lavur la tana, ma ra tarai ba dia ki tana, ba nina i bili ra ur, ba ta tikai di ga doka, ba ta minat, ba ta pia na pupunang; ");
INSERT INTO ksd_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","ma nina i gomgom na apur nina pa i gomgom ta ra vautuluna bung, ma ta ra valavuruana bung bula; ma ta ra valavuruana bung na vagomgom ia; na puk kana lavur mal, ma na gumu ta ra tava, ma na gomgom ta ra ravian. ");
INSERT INTO ksd_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Ma nina pa i gomgom, ma pa i vagomgom ia iat mulai, da kutu vue nam kan ra kor na tarai, tago i ga vadur ra gomgom na pal kai ra Luluai; pa di ga apur ia ma ra tava ure ra dur; pa i gomgom. ");
INSERT INTO ksd_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Na da ra varkurai vatvatikai pire diat; ma nina i apure ra tava ure ra dur; na puk kana lavur mal; ma nina i bili ra tava ure ra dur pa na gomgom tuk na ravian. ");
INSERT INTO ksd_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Ma ra magit ba nina pa i gomgom i bili ia pa na gomgom; ma ona ta tikai i bili ia pa na gomgom tuk na ravian. ");
INSERT INTO ksd_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Ma ra tarai Israel, a kor na tarai par, dia ga tadav ra bil Sin ta ra luaina gai; ma ra tarai dia ga ki aro Kades; ma Miriam i ga mat abara, ma di ga punang ia ie. ");
INSERT INTO ksd_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Ma pa ta tava abara pi ure ra kor na tarai; ma dia ga tut varurung ure Moses ma ure Aron. ");
INSERT INTO ksd_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Ma ra tarai dia ga varngangar ma Moses, ma dia ga biti dari: Gala na boina, gala ave ga mat ta ra bung ba ra tara na tura i vevet dia ga mat ta ra luaina mata i ra Luluai! ");
INSERT INTO ksd_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Upi ra ava amur ga agure ra kor na tarai kai ra Luluai tadav go ra bil, upi avet a mat ati, avet ma kaveve lavur vavaguai? ");
INSERT INTO ksd_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Ma ta ra ava amur ga ben vairop avet kan aro Aigipto, upi avet a tadav go ra kaina pakana? Vakir ia ra gunan ba ta kon tana, ba ta vuai na lovo, ba ta vuai na vain, ba ta vuai na goava; ma tikai bula, pa ta tava na nimomo tana. ");
INSERT INTO ksd_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Ma Moses ma Aron dir ga vana kan ra kor na tarai tadav ra matakilalat i ra pal na varbarat, ma dir ga bura timtibum; ma ra minamar i ra Luluai i ga vana rikai pire dir. ");
INSERT INTO ksd_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Ma ra Luluai i ga tata pire Moses dari: ");
INSERT INTO ksd_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Una vatur ra buka, ma una varurue ra kor na tarai, amur ma turam Aron, ma amur a tata pire ra vat ki ta ra luaina mata i diat, upi ra tava na ninim rikai tana; ma una pait vaarike ra tava ta ra vat ki ure diat; damana una vamomo ra kor na tarai ma kadia lavur vavaguai. ");
INSERT INTO ksd_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Ma Moses i ga vatur ra buka ta ra luaina mata i ra Luluai da i ga vartuluai pirana. ");
INSERT INTO ksd_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Ma Moses ma Aron dir ga varurue ra kor na tarai pire ra vat ki, ma i ga biti ta diat: Go avat a valongore, avat a tarai na varpiam; amir a pait vaarike, laka, ta tava ta go ra vat ki ure avat? ");
INSERT INTO ksd_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Ma Moses i ga tulue ra limana, ma i ga kita ra vat ki ma kana buka a ura pakana; ma ra ngala na tava i ga ninim rikai, ma ra tarai dia ga momo, ma kadia lavur vavaguai bula. ");
INSERT INTO ksd_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Ma ra Luluai i ga biti tai Moses ma Aron: Tago pa amur ga nurnur tagu, upi amur a vaarike kaugu lia na kini ta ra mata i ra tarai Israel, pa amur a agure vaolo go ra kor na tarai tar ta ra gunan ba iau ga tabar diat me. ");
INSERT INTO ksd_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Go ia ra tava Meriba (“Varngangar”); tago ra tarai Israel dia ga varngangar ma ra Luluai, ma i ga vaarike kana lia na kiki pire diat. ");
INSERT INTO ksd_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Ma Moses i ga tulue ta umana tultul maro Kades tadav ra king Edom: Turam Israel i biti dari: U nunure ra lavur magit ba dia ga monong avet; ");
INSERT INTO ksd_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","a umana tama i vevet dia ga vana ur uro Aigipto, ma ave ga ki vavuan aro Aigipto; ma ra tarai Aigipto dia ga vakavakaina avet ma ra umana tama i vevet; ");
INSERT INTO ksd_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","ma ba ave ga kail tadav ra Luluai, i ga valongore ra nilai vevet, ma i ga tulue ra angelo, ma i ga agure vairop avet kan aro Aigipto; io, ave ki Kades, a pia na pal ta kaum langun; ");
INSERT INTO ksd_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","iau lul u ba avet a vana vurbolo ta kaum gunan; pa avet a rua ta uma ba ta uma na vain, ma pa avet a mome ra tava ta ra umana kivu; avet a vanavana alalu ka ta ra nga tur kai ra king, pa avet a vana irai ta ra papar a lima tuna ba ta ra maira, tuk ave tar bolo vurakit kan kaum langun. ");
INSERT INTO ksd_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Ma Edom i ga biti tana: Koko avat a bolo iau, kan ina tut ma ra pakat na vinarubu ure avat. ");
INSERT INTO ksd_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Ma ra tarai Israel dia ga biti tana: Avet a vana ka urama ta go ra nga tur; ma gala ave momo ta kaum tava, avet ma kaveve lavur vavaguai, avet a kul ia piram; una nur vue avet upi avet a vanavana vurbolo ko, ma pa ta magit mulai. ");
INSERT INTO ksd_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Ma i ga biti: Pa avat a bolo. Ma Edom i ga tut ure ma ra ngala na kor ma ra dekdek na loko na tarai na vinarubu. ");
INSERT INTO ksd_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Damana Edom pa i ga mulaot ba Israel na vana vurbolo ta kana langun; ma Israel i ga vana irai kan ia. ");
INSERT INTO ksd_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Ma dia ga vanavana papa aro Kades; ma ra kor na tarai Israel par dia ga tadav ra luana Or. ");
INSERT INTO ksd_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Ma ra Luluai i ga tata pire Moses ma Aron ta ra luana Or pire ra langun ta ra gunan Edom, dari: ");
INSERT INTO ksd_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aron na mat; tago pa na olo ta ra gunan ba iau ga tul tar ia pire ra tarai Israel, tago amur ga piam vue kaugu tinata ta ra tava Meriba. ");
INSERT INTO ksd_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Una agure Aron ma Eleasar natuna, ma una ben dir urama ra ul a luana Or; ");
INSERT INTO ksd_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ma una ule vue ra umana mal kai Aron, ma una ule tar diat tai Eleasar natuna; ma Aron na tapula ma na mat abara. ");
INSERT INTO ksd_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Ma Moses i ga pait ia da ra vartuluai kai ra Luluai pirana; ma dital ga tutua ta ra ul a luana Or ta ra mata i ra tarai. ");
INSERT INTO ksd_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Ma Moses i ga ule vue ra umana mal kai Aron, ma i ga ule tar diat tai Eleasar natuna; ma Aron i ga mat arama ra ul a luana; ma Moses ma Eleasar dir ga vana ba kan ra luana. ");
INSERT INTO ksd_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Ma ba ra tarai par ta ra kuba i Israel dia ga gire ba Aron i ga mat, dia ga tangie Aron a utul a vinun na bung. ");
INSERT INTO ksd_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Ba ra king Arad, a te Kanaan, nina i ga ki aro Negeb, i ga valongore ra varvai ba ra tarai Israel dia vanavana ta ra nga Atarim, dia ga varubu ma ra tarai Israel, ma i ga kinim pa ta umana ta diat. ");
INSERT INTO ksd_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Ma Israel i ga vavalima ta ra luaina mata i ra Luluai ma i ga biti: Ona una tul tar go ra tarai ta ra limagu, ina nila vakakit vue kadia lavur pia na pal. ");
INSERT INTO ksd_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Ma ra Luluai i ga torom ta ra nilai Israel, ma i ga tul tar ra tarai Kanaan; ma dia ga nila vakakit vue diat ma kadia lavur pia na pal; ma di ga vatang ra iang i nam ra pakana ba Korma. ");
INSERT INTO ksd_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Ma dia ga vanavana papa aro ra luana Or ta ra nga uro ra Ta Meme, upi diat a vana liliai kan ra gunan Edom; ma ra nuknuk i ra tarai i ga bilua ta ra nga. ");
INSERT INTO ksd_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Ma ra tarai dia ga tata na urur ure God ma ure Moses: Upi ra ava amur ga ben vairop avet kan aro Aigipto upi avet a mat ta ra bil? Tago pa ta nian ma pa ta tava; ma ave milamila ta go ra nian vakuku. ");
INSERT INTO ksd_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Ma ra Luluai i ga tulue ra umana varkarat na vui livuan pire ra tarai, ma dia ga karat diat; ma mangoro ta ra tarai Israel dia ga mat. ");
INSERT INTO ksd_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Ma ra tarai dia ga tadav Moses ma dia ga biti: Ave ga pait ra kaina, tago ave ga tata na urur ure ra Luluai ma ure u; una araring tadav ra Luluai, upi na tak vue ra umana vui kan avet. Ma Moses i ga araring ure ra tarai. ");
INSERT INTO ksd_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Ma ra Luluai i ga biti tai Moses: Una pait ta varkarat na vui ma una vatur ia tai ta davai; ma na dari, ba nina ba ra vui i ga karat ia na gire, na laun. ");
INSERT INTO ksd_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Ma Moses i ga pait ra vui ma ra palariam gobol, ma i ga vatur ia tai ta davai; ma i ga dari: ona ta vui i ga karat ta tikai, ba i lingan upi ra vui na palariam, na laun. ");
INSERT INTO ksd_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Ma ra tarai Israel dia ga vanavana, ma dia ga vavatur aro Obot. ");
INSERT INTO ksd_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ma dia ga vanavana papa aro Obot, ina dia ga vavatur aro Ieabarim, ta ra bil pire ra langun Moab, ta ra papar ba ra keake i vana rikai tana. ");
INSERT INTO ksd_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Dia ga vanavana papa aro, ma dia ga vavatur ta ra male Sered. ");
INSERT INTO ksd_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Dia ga vanavana papa aro, ma dia ga vavatur ta ra papar a Amon maro, nina i ki ta ra bil pire ra langun kai ra tarai Amor; tago Amon ia ra langun kai Moab, livuan Moab ma ra tarai Amor. ");
INSERT INTO ksd_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Damana ra tinata ta ra Buk ure ra umana Vinarubu kai ra Luluai: Vaeb aro Supa, Ma ra malamale Amon, ");
INSERT INTO ksd_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Ma ra papar a male, Nina i tadav ra kiki kai Ar, Ma i lingan upi ra langun kai Moab. ");
INSERT INTO ksd_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Ma papa aro dia ga vanavana tuk uro Ber, nina ra kivu ba ra Luluai i ga biti tai Moses ure: Una varurue ra tarai, ma ina vamomo diat ma ra tava. ");
INSERT INTO ksd_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Ma ra tarai Israel dia ga kaile go ra kakailai: U a kivu una ninim rikai; avat a kakailai pirana: ");
INSERT INTO ksd_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","A kivu, nina ra umana luluai dia ga tikan tadav ia, Ma ra umana ngalangala kai ra tarai dia ga kal ia, Ma ra buka na varkurai, ma kadia umana buka. Ma dia ga vanavana papa aro ta ra bil tuk uro Matana; ");
INSERT INTO ksd_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ma papa aro Matana tuk uro Nakaliel, ma papa aro Nakaliel tuk uro Bamot; ");
INSERT INTO ksd_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ma papa aro Bamot tuk uro ra male ta ra langun kai Moab pire ra ul a luana Pisga, nina i gigira ba ura ra bil. ");
INSERT INTO ksd_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Ma Israel i ga tulue ta umana tultul tadav Sikon, a king kai ra tarai Amor, ma i ga biti: ");
INSERT INTO ksd_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Iau lul u ba ina vana vurbolo ta kaum gunan; pa avet a vana irai tadav ta uma, ba tadav ta uma na vain; pa avet a momo ta ra tava ta ra umana kivu; avet a vanavana ka ta ra nga tur kai ra king, tuk ave tar bolo vurakit kan kaum langun. ");
INSERT INTO ksd_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Ma Sikon pa i ga mulaot ba Israel na bolo ta kana langun; ma Sikon i ga varurue kana loko na tarai, ma i ga tut ure Israel uro ta ra bil, ma i ga vana tadav Iasa; ma dia ga varubu ma Israel. ");
INSERT INTO ksd_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Ma Israel i ga ub ia ma ra pakat na vinarubu, ma i ga kale kana gunan papa Amon tuk uro Iabok ta ra langun kai ra tarai Amon, tago ra langun kai ra tarai Amon i ga dekdek. ");
INSERT INTO ksd_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Ma Israel i ga kale go ra lavur pia na pal; ma Israel i ga ki ta ra lavur pia na pal kai ra tarai Amor, tai Kesbon, ma ta kana lavur pia na pal. ");
INSERT INTO ksd_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Tago Kesbon ia ra pia na pal kai Sikon, a king kai ra tarai Amor, nina dir ga varubu ma ra king Moab lua, ma i ga kap pa kana pia parika kan ra limana, tuk uro Amon. ");
INSERT INTO ksd_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Damana ra umana tena pit kakailai dia biti: Avat a vana Kesbon, Boina ba da pait ra pia na pal kai Sikon ma da vatut ia; ");
INSERT INTO ksd_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Tago ra iap i ga vana rikai tai Kesbon, Ma ra birao ta ra pia na pal kai Sikon; I ga vaimur vue Ar-Moab, Ma ra umana luluai ta ra lualuana Amon. ");
INSERT INTO ksd_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Na kaina tam, Moab! Avat a malari, avat a tarai kai Kemos; I ga tul tar kana umana bul tutana upi diat a puiap, Ma kana umana bul vavina upi ra kini na vilavilau, Pire Sikon, a king kai ra tarai Amor. ");
INSERT INTO ksd_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Damana ra umana bul mur ta diat dia ga virua, Papa Kesbon tuk uro Dibon, Ave ga varli Tuk ra iap i ga tadav ra gunan Medeba. ");
INSERT INTO ksd_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Damana ra tarai Israel dia ga ki ta ra gunan kai ra tarai Amor. ");
INSERT INTO ksd_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Ma Moses i ga vartuluai upi diat a makila lua ure Iaser, ma dia ga kale ra umana pia na pal tana, ma dia ga korot vue ra tarai Amor nina dia ga ki tana. ");
INSERT INTO ksd_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Ma dia ga vana likun ta ra nga uro Basan; ma Og, a king Basan, i ga tut ure diat, diat ma kana loko na tarai, upi diat a varubu aro Edrei. ");
INSERT INTO ksd_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Ma ra Luluai i ga biti tai Moses: Koko una burutue; tago iau ga tul tar ia ta ra limam, diat ma kana tarai ma kana gunan bula; ma una pait ia pirana da u ga pait ia pire Sikon a king kai ra tarai Amor, nina i ga ki Kesbon. ");
INSERT INTO ksd_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Damana dia ga ubu diat ma ra umana natuna, ma kana tarai, tuk tar pa ta tikai i ga laun valili; ma dia ga kale kana gunan. ");
INSERT INTO ksd_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Ma ra tarai Israel dia ga vanavana, ma dia ga vatur kadia lavur pal na mal ta ra tamataman Moab ta ra papar a Iordan maro tai Ieriko. ");
INSERT INTO ksd_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Ma Balak natu i Sipor i ga gire ra lavur magit Israel i ga pait ia pire ra tarai Amor. ");
INSERT INTO ksd_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Ma Moab i ga burutue ra tarai, tago dia ga mangoro; ma Moab i ga ururian ure ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Ma Moab i ga biti tai ra umana patuana kai ra tarai Midian: Go ra ngala na kor na en vue ra lavur magit kikil dat, da ra bulumakau i en vue ra vura. Ma Balak natu i Sipor i ga ki na king aro Moab ta nam ra e. ");
INSERT INTO ksd_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Ma i ga tulue ta umana tultul tadav Balam natu i Beor, uro Petor ta ra papar a tava alir ta ra gunan Amau, upi da ting pa ia, ma i ga biti: Gire, tika na vuna tarai i tar vana kan Aigipto; io, go dia kor ta ra gunagunan, ma dia ki marave iau; ");
INSERT INTO ksd_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","damana iau lul u ba una mai ma una tata vakaina go ra tarai; (tago dia manga ongor tagu); upi kan ina uvia pa diat ma dor a ubu diat, ma ina korot vue diat kan ra gunan; tago iau nunure ba aina u tata vadoane na ti doan, ma nina u tata vakaina na kaina iat. ");
INSERT INTO ksd_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Ma ra umana patuana Moab ma ra umana patuana Midian dia ga vana ma ra varkul ta ra lima i diat; ma dia ga tadav Balam, ma dia ga vaarike ra tinata kai Balak pirana. ");
INSERT INTO ksd_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Ma i ga biti ta diat: Avat a ki ati go i marum, ma ina ga ve mule avat da ra Luluai na tata piragu; ma ra umana luluai Moab dia ga ki pire Balam. ");
INSERT INTO ksd_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Ma God i ga tadav Balam ma i ga biti: la go ra tarai piram? ");
INSERT INTO ksd_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Ma Balam i ga biti tai God: Balak, natu i Sipor, a king Moab, i ga vartuluai piragu, ma i ga biti: ");
INSERT INTO ksd_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Gire, ra tarai nina dia ga vana kan Aigipto, dia kor ta ra gunagunan; una mai, una tata vakaina diat; upi kan ina uvia pa diat, ma ina korot vue diat. ");
INSERT INTO ksd_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Ma God i ga biti tai Balam: Koko avat a varagur ma diat; koko una tata vakaina ra tarai; tago dia ti doan. ");
INSERT INTO ksd_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Ma Balam i ga tut ta ra malana, ma i ga biti ta ra umana luluai kai Balak: Avat a vana ta kavava gunan; tago ra Luluai pa i mulaot ba dat a varagur. ");
INSERT INTO ksd_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Ma ra umana luluai Moab dia ga tut ma dia ga vana tadav Balak ma dia ga biti: Balam pa i mulaot ba avet a varagur. ");
INSERT INTO ksd_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Ma Balak i ga tulue ta mangoro na luluai mulai, ma diat a umana vatang na tutana ta diat lua. ");
INSERT INTO ksd_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ma dia ga tadav Balam, ma dia ga biti tana: Balak natu i Sipor i biti dari, Iau lul u ba koko ta magit na tur bat u kan ra vinavana uti piragu; ");
INSERT INTO ksd_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","tago ina pait ra ngala na magit na variru piram, ma nam ba una vatang upi ia piragu ina pait ia; kari iau lul u ba una mai, una tata vakaina go ra tarai. ");
INSERT INTO ksd_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Ma Balam i ga tata bali ra umana tultul kai Balak dari: Gala Balak na tabar iau ma ra kubana i buka ma ra silva ma ra goled, pa iau pait valar pa ia ba ina lake ra tinata kai ra Luluai kaugu God, ba ta magit i ikilik, ba ta magit i ngala. ");
INSERT INTO ksd_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Damana iau lul avat ba avat a ki boko ati go i marum mulai, upi ina nunure ba ava mulai ra Luluai na tatike piragu. ");
INSERT INTO ksd_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Ma God i ga tadav Balam ta ra marum, ma i ga biti tana: Ba ra tarai dia tar pot upi diat a ting pa u, una tut ma avat a varagur; ma una pait ika nam ra tinata ba ina tatike piram. ");
INSERT INTO ksd_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Ma Balam i ga tut ta ra malana, ma i ga vaninare kana as, ma dia ga varagur ma ra umana luluai Moab. ");
INSERT INTO ksd_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Ma ra kankan kai God i ga tut tago i ga vana; ma ra angelo kai ra Luluai i ga tur bat ia ta ra nga. Ma i ga ki kana as, dital ma kana ura tultul. ");
INSERT INTO ksd_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Ma ra as i ga gire ra angelo kai ra Luluai, i tur ta ra nga, ina i ga ele pa kana pakat na vinarubu ma ra limana; ma ra as i ga vana irai kan ra nga uro ta ra bala na uma; ma Balam i ga kita ra as upi na valilikun ia tar ta ra nga. ");
INSERT INTO ksd_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Ma ra angelo kai ra Luluai i tur ta ra nga varvaim livuan ta ra ura uma na vain ma ra liplip ta ra ura papar a nga. ");
INSERT INTO ksd_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Ma ra as i ga gire ra angelo kai ra Luluai ma i ga tur bokon ta ra papar a liplip ma i ga kabin ra kau i Balam ta ra liplip; ma i ga kita mule. ");
INSERT INTO ksd_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Ma ra angelo kai ra Luluai i ga vana uro na lua, ma i ga tur ta ra nga varvaim, ba pa ta maup tana upi da lingan ta ra papar a lima tuna ba ta ra papar a maira. ");
INSERT INTO ksd_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Ma ra as i ga gire ra angelo kai ra Luluai, ma i ga va ta ra vavai Balam; ma Balam i ga kankan, ma i ga kita ra as ma kana buka. ");
INSERT INTO ksd_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Ma ra Luluai i ga papa ra ngie i ra as, ma i ga biti tai Balam: Ava iau tar pait ia piram, upi go u kita iau a utul a pakana? ");
INSERT INTO ksd_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Ma Balam i ga biti ta ra as: Tago u tar papait na varvaula ma iau; gala ta pakat ta ra limagu, gala iau tar doko u. ");
INSERT INTO ksd_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Ma ra as i ga biti tai Balam: Vakir iau kaum as laka, nina u ga kiki tana ta kaum nilaun par tuk go? Dave, kaugu mangamangana piram i ga dari lua? Ma i ga varpuai ba, Pata. ");
INSERT INTO ksd_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Ma ra Luluai i ga vakapa ra mata i Balam, ma i ga gire ra angelo kai ra Luluai i ga tur ta ra nga ma i ga ele pa kana pakat na vinarubu ma ra limana; ma i ga tur ruru ma i ga va timtibum. ");
INSERT INTO ksd_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Ma ra angelo kai ra Luluai i ga biti tana: Upi ra ava u tar kita kaum as go ra utul a pakana? Gire, iau tar vana rikai upi ina tur bat u, tago kaum nga i kaina ta ra luaina matagu. ");
INSERT INTO ksd_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Ma ra as i tar gire iau, ma i tar vana irai kan iau ta go ra utul a pakana; gala pa i tar vana irai kan iau, gala iau tar doko u ma iau tar valaun ia. ");
INSERT INTO ksd_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Ma Balam i ga biti tai ra angelo kai ra Luluai: Iau tar pait ra kaina; tago pa iau tar nunure ba u tar tur bat iau ta ra nga; ma go, ona pa u gugu tana, ina lilikun mulai. ");
INSERT INTO ksd_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ma ra angelo kai ra Luluai i ga biti tai Balam: Avat a varagur ma ra tarai; ma una vatang ika nam ra tinata ba ina tatike piram. Ma Balam dia ga varagur ma ra umana luluai kai Balak. ");
INSERT INTO ksd_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Ma ba Balak i ga valongore ba Balam i tar pot, i ga totongo upi ia ta ra pia na pal kai Moab, ta ra papar a Amon nina i ki vailik ta kana langun. ");
INSERT INTO ksd_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Ma Balak i ga biti tai Balam: Dave, pa iau ga vartuluai up u, upi da ting pa u? Ta ra ava pa u ga tadav iau? Dave, pa i tale iau ba ina tul tar ra variru piram? ");
INSERT INTO ksd_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Ma Balam i ga biti tai Balak: Io, iau tar tadav u; dave, pa i dekdek piragu upi ina vatang ta magit? Ina vatang ika ra tinata ba God na vung ia ta ra ngiegu. ");
INSERT INTO ksd_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Ma Balam dir ga varagur ma Balak, ma dir ga tadav Kiriat-Kusot. ");
INSERT INTO ksd_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Ma Balak i ga pait ra tinabar ma ra umana bulumakau ma ra umana sip, ma i ga tulue ta umana tiniba pire Balam ma ra umana luluai dia ga ki pirana. ");
INSERT INTO ksd_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Ma ta ra malana Balak i ga ben pa Balam, ma i ga agure urama Bamot-Baal, ma i ga gire a ngungu ta ra tarai mabara. Ma Balam i ga biti tai Balak: ");
INSERT INTO ksd_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Una pait kaugu ta lavurua na uguugu na vartabar, ma una vaninare lavurua na bulumakau ma lavurua na sip, a umana tomotoina. ");
INSERT INTO ksd_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Ma Balak i ga pait ia da Balam i ga vatang ia; ma Balak ma Balam dir ga tul tar tika na bulumakau ma tika na sip ta ra umana uguugu na vartabar tikatikai. ");
INSERT INTO ksd_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Ma Balam i ga biti tai Balak: Una tur ati pire ra tinabar di tun tar ia, ma ina vana; kan ra Luluai na barat iau; ma nam ba na vaarike piragu ina ve u tana. Ma i ga vana ta ra ul a luana ba pa ta davai tana. ");
INSERT INTO ksd_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Ma God i ga barat Balam; ma i ga biti tana: Iau ga vaninare lavurua na uguugu na vartabar, ma iau ga tul tar tika na bulumakau ma tika na sip ta ra umana uguugu na vartabar tikatikai. ");
INSERT INTO ksd_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Ma ra Luluai i ga vung ra tinata ta ra ngie i Balam, ma i ga biti: Una lilikun tadav Balak, ma una tata dari. ");
INSERT INTO ksd_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Ma i ga lilikun pirana, ma io, i ga tur pire kana tinabar di tun tar ia, diat ma ra umana luluai Moab. ");
INSERT INTO ksd_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Ma i ga tur pa kana varvai ma i ga biti: Balak i ga ting pa iau maro Aram, A king Moab maro ra lualuana ta ra papar a taur: Una mai, una tata vakaina Iakob, Ma una vana uti, una tata na kankan ure Israel. ");
INSERT INTO ksd_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Ina tata vakaina davatane nina God pa i tata vakaina? Ma ina kankanuane davatane nina ra Luluai pa i kankanuane? ");
INSERT INTO ksd_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Tago ba iau ki ra ul a vat, iau gire, Ma ta ra ul a lualuana, iau bobe; Gire, a tarai nina dia ki varkolono, Ma pa di luk tar diat ta ra umana enana vuna tarai: ");
INSERT INTO ksd_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","To ia na luk valar pa ra tobon tai Iakob, Ba na luk puput pa ra vaivat na pakana tai Israel? Boina ba ina mat da ra minat kai ra tena takodo, Ma ra mutuai kaugu nilaun na da kana! ");
INSERT INTO ksd_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Ma Balak i ga biti tai Balam: Ava go u tar pait ia piragu? Iau ga ting pa u upi una tata vakaina kaugu lavur ebar, ma ea, u tar tia tata vadoane ke diat. ");
INSERT INTO ksd_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Ma i ga bali ia dari: Dave, pa ina nuk pa ia upi ina vatang ika nam ba ra Luluai na vung ia ta ra ngiegu? ");
INSERT INTO ksd_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Ma Balak i ga biti tana: Iau lul u, ba dor a varagur uro ta ra enana pakana, upi una gire diat mabara; una gire pa ka ta ngungu ta diat, pa una gire diat par; ma una tata vakaina diat mabara. ");
INSERT INTO ksd_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Ma i ga agure ta ra pakana pia Sopim, ta ra ul a luana Pisga, ma i ga pait lavurua na uguugu na vartabar, ma i ga tul tar tika na bulumakau ma tika na sip ta ra umana uguugu na vartabar tikatikai. ");
INSERT INTO ksd_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Ma i ga biti tai Balak: Una tur ati pire ra tinabar di tun tar ia, ba iau barat ra Luluai abara. ");
INSERT INTO ksd_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Ma ra Luluai i ga barat Balam ma i ga vung ra tinata ta ra ngiene, ma i ga biti tana: Una lilikun tadav Balak, ma una tata dari. ");
INSERT INTO ksd_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Ma i ga tadav ia, ma io, i ga tur pire kana tinabar di tun tar ia, diat ma ra umana luluai Moab. Ma Balak i ga biti tana: A Luluai i tar tatike ra ava? ");
INSERT INTO ksd_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Ma i ga tur pa kana varvai, ma i ga biti: Una tut, Balak, ma una valongore; Una vatorome iau, u natu i Sipor; ");
INSERT INTO ksd_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","God vakir ia ra tutana, upi na vaongo; Ma vakir ia ra natu i ra tutana, upi na nukpuku; Dave, i ga vatang ta magit, ma pa na pait ia? Ba i ga tatike ta magit, ma pa na pait ot pa ia? ");
INSERT INTO ksd_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Gire, di ga vartuluai piragu, upi ina tata vadoane; Ina tata vadoane, ma i dekdek upi ina pukue. ");
INSERT INTO ksd_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Pa i ga na tadav ta kaina tai Iakob, Ma pa i ga gire ta magit i bilak tai Israel; A Luluai kana God i ki pirana, Ma ra nioro ure ra king i tur livuan pire diat. ");
INSERT INTO ksd_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","God i ben vaarike diat maro Aigipto; A dekdekina i da ra kuabar na bulumakau. ");
INSERT INTO ksd_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","A dovotina i dekdek upi da papait ure Iakob. Ma i dekdek upi da ong Israel; Ma go da tatike ure Iakob ma ure Israel; God i tar pait ia muka damana! ");
INSERT INTO ksd_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Gire ra tarai dia tut rikai da ra leon, a tana, Ma i vatut pa ia iat mulai da ra leon; Pa na va mulai tuk i tar ian ta ra magit i tar ubu pa ia, Ma i tar mome ra gapu i ra magit i tar vavirua. ");
INSERT INTO ksd_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Ma Balak i ga biti tai Balam: Koko muka una tata vakaina diat, ma koko muka una tata vadoane diat. ");
INSERT INTO ksd_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Ma Balam i ga bali Balak dari; Dave, pa iau ga ve u ba ina pait ika nam ba ra Luluai na tatike? ");
INSERT INTO ksd_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Ma Balak i ga biti tai Balam: Una mai, ina agure u tar ta ra enana pakana kabila; ma kan God na mulaot ba una tata vakaina diat mabara. ");
INSERT INTO ksd_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Ma Balak i ga agure Balam urama ta ra ul a luana Peor, nina i gigira taun ra bil. ");
INSERT INTO ksd_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Ma Balam i ga biti tai Balak: Una pait kaugu ta lavurua na uguugu na vartabar ati, ma una vaninare lavurua na bulumakau, ma lavurua na sip, a umana tomotoina. ");
INSERT INTO ksd_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Ma Balak i ga pait ia da Balam i ga vatang ia, ma i ga tul tar tika na bulumakau ma tika na sip ta ra umana uguugu na vartabar tikatikai. ");
INSERT INTO ksd_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Ma ba Balam i ga gire ba ra Luluai i ongor upi na tata vadoane Israel, pa i vana mulai, da lua, upi na papait, ia kaka i ga lingan uro ra bil. ");
INSERT INTO ksd_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Ma Balam i ga idaidok, ma i ga gire Israel dia ki da kadia vunavuna tarai; ma ra Tulungea i God i ga ki taun ia. ");
INSERT INTO ksd_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Ma i ga tur pa kana varvai ma i ga biti: Balam natu i Beor i biti, Ma ra tinata kai nina i tapala ra matana i dari: ");
INSERT INTO ksd_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Nina i valongore ra tinata kai God i biti, Nina i gire ra ninana kai nina i Dekdek Muka, I bura timtibum ma i tapala ra matana: ");
INSERT INTO ksd_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Kaum lavur pal na mal dia boina kakit, Iakob, Ma ra kubakubam, Israel! ");
INSERT INTO ksd_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Dia tur vanavana da ra umana male, Da ra umauma ta ra papar a tava alir, Da ra libung nina ra Luluai i ga vaume, Da ra tagatagal ta ra papar a tava. ");
INSERT INTO ksd_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","A tava na alir rikai ta kana kulkulup, Ma ra umana bul mur tana diat a ki pire mangoro na tava, Kana king na lia tai Agag, Ma da vangala kana varkurai. ");
INSERT INTO ksd_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","God i ben vaarike maro Aigipto; A dekdekina i da ra kuabar na bulumakau; Na en vue ra lavur vuna tarai dia ebar me, Na bubur gigi ra uru i diat, Ma kana umana pu na tur diat. ");
INSERT INTO ksd_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","I ga va likun ra kakene, ma i ga vava da ra leon, Ma da ra leon, a tana; to ia na vangun ia? Diat dia tata vadoane u, diat a ti doan, Ma na kaina ta diat dia tata vakaina u. ");
INSERT INTO ksd_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Ma Balak i ga kankan ure Balam, ma i ga par ra ura limana; ma Balak i ga biti tai Balam: Iau ga ting pa u pi una tata vakaina kaugu lavur ebar, ma ea, u ga tia tata vadoane ke diat go ra utul a pakana parika. ");
INSERT INTO ksd_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Io, go una vilau uro ta kaum pakana; iau ga nuk ia ba ina tul tar ra ngala na variru tam; ma ra Luluai i ga tur bat vake u kan ra variru. ");
INSERT INTO ksd_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Ma Balam i ga biti tai Balak: Dave, pa iau ga tata pire kaum umana tultul, nina u ga tulue diat piragu, dari: ");
INSERT INTO ksd_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Gala Balak na tabar iau ma ra kubana i buka ma ra silva ma ra goled, pa iau pait valar pa ia ba ina lake ra tinata kai ra Luluai, ba ta magit i boina, ba ta magit i kaina ta ra nuknukigu iat; ina vatang ika nam ba ra Luluai na tatike? ");
INSERT INTO ksd_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Ma ea, go iau vana tadav kaugu tarai; una mai, ma ina vakapa u ure ra magit ba go ra tarai diat a pait ia pire kaum tarai ta ra umana bung namur. ");
INSERT INTO ksd_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Ma i ga tur pa kana varvai, ma i ga biti: Balam natu i Beor i biti, Nina i tapala ra matana i biti dari: ");
INSERT INTO ksd_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Nina i valongore ra tinata kai God i biti, Nina i nunure ra minatoto kai ra Ngala Kakit, Nina i gire ra ninana kai nina i Dekdek Muka, I bura timtibum ma i tapala ra matana: ");
INSERT INTO ksd_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Iau gire, ia kaka gori pata; Iau bobe, ia kaka pa i maravai; A tagul na vana rikai tai Iakob, Ma ra buka na varkurai na tut rikai tai Israel, Ma na ubu ra langun par kai Moab, Ma na vakaina vue ra umana natu i Set. ");
INSERT INTO ksd_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Na kale ra gunan Edom, Ma na kale bula Seir, nina dia ga ebar me; Ma Israel na ongor vanavana. ");
INSERT INTO ksd_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Ma tikai tai Iakob na vatur vake ra varkurai, Ma na li vue ra ibaiba ta ra pia na pal. ");
INSERT INTO ksd_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Ma i ga gigira tadav Amalek, ma i ga tur pa ra varvai, ma i ga biti: Amalek ia ra luaina pire ra umana vuna tarai, Ma ra mutuaina, a vinirua ka. ");
INSERT INTO ksd_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Ma i ga gigira tadav ra tarai Ken, ma i ga tur pa ra varvai, ma i ga biti: U vadekdek bat ra kubam, Ma u vaki kaum po ta ra vat ki. ");
INSERT INTO ksd_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","la kaka da kamare vue Kain, Aivia ra bung Asiria na kap vavilavilau avat? ");
INSERT INTO ksd_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Ma i ga pakan kana varvai, ma i ga biti: Ea, to ia na laun ba God na pait go? ");
INSERT INTO ksd_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ma ra umana parau diat a vut maro Kitim, Ma diat a monong Asiria, ma Eber bula, Ma ia bula na virua. ");
INSERT INTO ksd_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Ma Balam i ga tut, ma i ga vana, ma i ga lilikun ta kana pakana; ma Balak bula i ga vana. ");
INSERT INTO ksd_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Ma Israel i ga ki aro Sitim, ma ra tarai dia ga tur pa ia ba dia po ma ra vaden Moab; ");
INSERT INTO ksd_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","tago dia ga ting pa ra tarai upi ra tinabar tadav kadia lavur god; ma ra tarai dia ga ian, ma dia ga va timtibum tadav kadia lavur god. ");
INSERT INTO ksd_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Ma Israel i ga mur Baal-Peor; ma i ga karangap ra kankan kai ra Luluai ure Israel. ");
INSERT INTO ksd_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Ma ra Luluai i ga biti tai Moses: Una vatur ra lavur luluai kai ra tarai, ma una al vatokobe diat ta ra keake ta ra luaina mata i ra Luluai, upi ra karangap na kankan kai ra Luluai na vana irai kan Israel. ");
INSERT INTO ksd_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Ma Moses i ga biti tai ra umana tena varkurai Israel: Avat a doko kavava lavur tutana nina dia ga mur Baal-Peor. ");
INSERT INTO ksd_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Io, tikai ta ra tarai Israel i ga vana ma i ga ben tika na vavina Moab tadav ra umana turana, ta ra mata i Moses, ma ta ra mata i ra kor na tarai Israel, ba dia ga tangtangi ta ra matakilalat i ra pal na varbarat. ");
INSERT INTO ksd_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Ma ba Pinekas, natu i Eleasar, natu i Aron ra tena tinabar, i ga gire, i ga tut kan ra kor na tarai, ma i ga vatur ra rumu ta ra limana; ");
INSERT INTO ksd_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ma i ga ruk mur ra tutana Israel ura ta ra bala lia pal na mal, ma i ga go dir parika, ra tutana Israel, ma ra vavina ta ra balana. Damana di ga tur bat ra kaina minait kan ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Ia kaka a ura vinun ma a ivat na arip na marmar ta diat dia ga mat ta ra kaina minait. ");
INSERT INTO ksd_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Ma ra Luluai i ga tata pire Moses dari: ");
INSERT INTO ksd_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Pinekas, natu i Eleasar, natu i Aron ra tena tinabar, i ga vaire vue kaugu kankan kan ra tarai Israel, tago i ga ongor ma kaugu niongor livuan ta diat, ma damana pa iau ga en vue ra tarai Israel ta kaugu niongor. ");
INSERT INTO ksd_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Kari una biti: Gire, iau tul tar kaugu kunubu na malmal pirana; ");
INSERT INTO ksd_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","ma na da ra kunubu ure ra tiniba na tena tinabar vatikai pirana ma pire ra lavur bul mur tana; tago i ga ongor ure kana God, ma i ga pait ra varporong ure ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Ma ra iang i ra tutana Israel nina di ga doka, nina di ga doka varurung ma ra vavina Midian, Simri, natu i Salu, a luluai tai tika na apik na tarai ta ra vuna tarai Simeon. ");
INSERT INTO ksd_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Ma ra iang i ra vavina Midian nina di ga doka, Kosbi, natu i Sur; i ga lualua tai tika na apik na tarai tai Midian. ");
INSERT INTO ksd_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Ma ra Luluai i ga tata pire Moses dari: ");
INSERT INTO ksd_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Avat a tut ure ra tarai Midian, ma avat a ubu diat; ");
INSERT INTO ksd_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","tago dia tar vakadik avat ma kadia mangamangana vavagu, nina dia ga vagu pa avat me ta ra mangamangana ure Peor, ma ta ra magit ure Kosbi, natu i ra luluai Midian, tai diat, nina di ga doka ta ra bung na minait ure ra mangamangana ure Peor. ");
INSERT INTO ksd_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Ma ba i ga par ra minait, ra Luluai i ga tata pire Moses ma pire Eleasar natu i Aron ra tena tinabar, dari: ");
INSERT INTO ksd_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Avat a luk ra kor na tarai Israel, diat ba kadia kilala i ura vinun, ba i bolo ra ura vinun, ta kadia lavur apik na tarai, nina dia topa ra vinarubu ta diat ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Ma Moses ma Eleasar dir ga tata ta diat ta ra tamataman Moab, pire ra Iordan aro Ieriko, dari: ");
INSERT INTO ksd_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Avat a luk ra tarai par ba kadia kilala i ura vinun, ba i bolo ra ura vinun; da ra Luluai i ga vartuluai pire Moses ma ra tarai Israel, nina dia ga irop kan ra gunan Aigipto. ");
INSERT INTO ksd_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben, ra luaina kai Israel; a ivat na natu i Ruben: Kanok ma kana apik na tarai, Palu ma kana apik na tarai, ");
INSERT INTO ksd_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Kesron ma kana apik na tarai, Karmi ma kana apik na tarai. ");
INSERT INTO ksd_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Go diat ra ivat na apik na tarai ta ra vuna tarai Ruben; ma diat di ga luk diat, a ivat na vinun ma a utul na arip, ma lavurua na mar ma a utul a vinun diat. ");
INSERT INTO ksd_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Ma Eliab ia ra natu i Palu. ");
INSERT INTO ksd_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","A utul a natu i Eliab: Nemuel, Datan ma Abiram. Go dir Datan ma Abiram, nina di ga pilak pa dir ta ra kor na tarai, nina dir ga tut ure Moses ma ure Aron ta ra tarai Kora, ba dia ga tut ure ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ma ra pia i ga panganga ma i ga konom pa diat ma Kora, ba nam ra tarai dia ga virua; a iap i ga vaimur vue a ura mar ma a ilima na vinun ta nam ra bung, ma dia ga da ra vakilang. ");
INSERT INTO ksd_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Ia kaka ra umana natu i Kora pa dia ga mat. ");
INSERT INTO ksd_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","A umana natu i Simeon ta kadia lavur apik na tarai: Nemuel ma kana apik na tarai, Iamin ma kana apik na tarai, ");
INSERT INTO ksd_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Serak ma kana apik na tarai, Saul ma kana apik na tarai. ");
INSERT INTO ksd_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Go diat ra umana apik na tarai ta ra vuna tarai Simeon; a ura vinun ma a urua na arip ma a ura mar diat. ");
INSERT INTO ksd_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","A umana natu i Gad ta kadia lavur apik na tarai: Sepon ma kana apik na tarai, Agi ma kana apik na tarai, Suni ma kana apik na tarai, ");
INSERT INTO ksd_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Osni ma kana apik na tarai, Eri ma kana apik na tarai, ");
INSERT INTO ksd_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arod ma kana apik na tarai, Areli ma kana apik na tarai. ");
INSERT INTO ksd_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Go diat ra umana apik na tarai ta ra vuna tarai Gad; diat ba di ga luk diat a ivat na vinun na arip ma a ilima na mar diat. ");
INSERT INTO ksd_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","A ura natu i Iuda, Er ma Onan, dir ga mat ta ra gunan Kanaan. ");
INSERT INTO ksd_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","A umana natu i Iuda ta kadia lavur apik na tarai: Sela ma kana apik na tarai, Peres ma kana apik na tarai, Sera ma kana apik na tarai. ");
INSERT INTO ksd_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Ma a ura natu i Peres: Kesron ma kana kakang na tarai ma Amul ma kana kakang na tarai. ");
INSERT INTO ksd_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Go diat ra umana apik na tarai tai Iuda; diat ba di ga luk diat lavurua na vinun ma laptikai na arip ma a ilima na mar diat. ");
INSERT INTO ksd_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","A umana natu i Isakar ta kadia lavur apik na tarai: Tola ma kana apik na tarai, Puva ma kana apik na tarai, ");
INSERT INTO ksd_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Iasub ma kana apik na tarai, Simron ma kana apik na tarai. ");
INSERT INTO ksd_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Go diat ra umana apik na tarai tai Isakar; diat ba di ga luk diat laptikai na vinun ma a ivat na arip ma a utul a mar diat. ");
INSERT INTO ksd_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","A umana natu i Sebulun ta kadia lavur apik na tarai: Sered ma kana apik na tarai, Elon ma kana apik na tarai, Ialel ma kana apik na tarai. ");
INSERT INTO ksd_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Go diat ra utul a apik na tarai ta ra vuna tarai Sebulun; diat ba di ga luk diat laptikai na vinun na arip ma a ilima na mar diat. ");
INSERT INTO ksd_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","A ura natu i Iosep ta kana vuna tarai: Manase ma Epraim. ");
INSERT INTO ksd_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Ra umana natu i Manase: Makir ma kana apik na tarai; ma Makir i ga vangala Gilead; Gilead ma kana apik na tarai. ");
INSERT INTO ksd_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Go diat ra umana natu i Gilead: Ieser ma kana kakang na tarai, Elek ma kana kakang na tarai, ");
INSERT INTO ksd_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriel ma kana kakang na tarai, Sekem ma kana kakang na tarai, ");
INSERT INTO ksd_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Semida ma kana kakang na tarai, Eper ma kana kakang na tarai. ");
INSERT INTO ksd_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Ma Selopekad natu i Eper pa i ga vangala ta bul tutana, a umana bul vavina ka; ma ra iang i diat ra umana natu i Selopekad, a umana vavina, Makla ma Noa, Kogla, Milka ma Tirsa. ");
INSERT INTO ksd_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Go diat ra umana apik na tarai tai Manase; diat ba di ga luk diat a ilima na vinun ma a ura arip ma lavurua na mar diat. ");
INSERT INTO ksd_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Go diat ra umana natu i Epraim ta kadia lavur apik na tarai: Sutela ma kana apik na tarai, Beker ma kana apik na tarai, Takan ma kana apik na tarai. ");
INSERT INTO ksd_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Ma ta ra umana natu i Sutela, Eran ma kana apik.na tarai. ");
INSERT INTO ksd_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Go diat ra umana apik na tarai ta ra vuna tarai Epraim; diat ba di ga luk diat a utul a vinun ma a ura arip ma a ilima na mar diat. Go diat ra umana natu i Iosep ta kadia lavur apik na tarai. ");
INSERT INTO ksd_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","A umana natu i Beniamin ta kadia lavur apik na tarai: Bela ma kana apik na tarai, Asbel ma kana apik na tarai, Akiram ma kana apik na tarai, ");
INSERT INTO ksd_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Sepupam ma kana apik na tarai, Kupam ma kana apik na tarai. ");
INSERT INTO ksd_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","A ura natu i Bela, Ared ma Naman; Ared ma kana kakang na tarai, Naman ma kana kakang na tarai. ");
INSERT INTO ksd_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Go diat ra umana natu i Beniamin ta kadia lavur apik na tarai; diat ba di ga luk diat a ivat na vinun ma a ilima na arip ma laptikai na mar diat. ");
INSERT INTO ksd_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Go diat ra umana natu i Dan ta kadia lavur apik na tarai: Sukam ma kana apik na tarai. Go ra apik na tarai ta ra vuna tarai Dan. ");
INSERT INTO ksd_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","A lavur kakang ta ra apik na tarai Sukam, diat ba di ga luk diat, laptikai na vinun ma a ivat na arip ma a ivat na mar diat. ");
INSERT INTO ksd_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","A umana natu i Aser ta kadia lavur apik na tarai: Imna ma kana apik na tarai, Isvi ma kana apik na tarai, Beria ma kana apik na tarai. ");
INSERT INTO ksd_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Ta ra umana natu i Beria: Keber ma kana kakang na tarai, Malkiel ma kana kakang na tarai. ");
INSERT INTO ksd_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Ma ra iang i natu i Aser, a vavina, ba Sera. ");
INSERT INTO ksd_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Go diat ra umana apik na tarai ta ra vuna tarai Aser; diat ba di ga luk diat a ilima na vinun ma a utul a arip ma a ivat na mar diat. ");
INSERT INTO ksd_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","A umana natu i Naptali ta kadia lavur apik na tarai: Iasel ma kana apik na tarai, Guni ma kana apik na tarai, ");
INSERT INTO ksd_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Ieser ma kana apik na tarai, Silem ma kana apik na tarai. ");
INSERT INTO ksd_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Go diat ra umana apik na tarai ta ra vuna tarai Naptali; diat ba di ga luk diat a ivat na vinun ma a ilima na arip ma a ivat na mar diat. ");
INSERT INTO ksd_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Go diat ba di ga luk diat ta ra tarai Israel, laptikai na mar ma tika na arip, ma lavurua na mar ma a utul a vinun diat. ");
INSERT INTO ksd_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Ma ra Luluai i ga tata pire Moses dari: ");
INSERT INTO ksd_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Da tibe tar ra gunan ta go diat, upi diat a kale, da ra niluluk i ra iang i diat. ");
INSERT INTO ksd_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Una tul tar ra ngala na tiniba ta nina i mangoro, ma una tul tar ra ikilik na tiniba ta nina i paupau ka; una tibe tikatikai da ra niluluk na tarai tana. ");
INSERT INTO ksd_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","la kaka, da padapadailam upi ra umana tiniba ta ra gunan; diat a kakalai da ra iang i kadia umana vuna tarai. ");
INSERT INTO ksd_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Da padapadailam upi ra umana tiniba ta ra pakana ba diat a kale livuan ta nina i mangoro ma nina i paupau ka. ");
INSERT INTO ksd_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Ma go diat ba di ga luk diat ta ra vuna tarai Levi da kadia lavur apik na tarai: Gerson ma kana apik na tarai, Koat ma kana apik na tarai, Merari ma kana apik na tarai. ");
INSERT INTO ksd_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Go diat ra umana kakang na tarai tai Levi: a kakang na tarai Libni, a kakang na tarai Kebron, a kakang na tarai Mali, a kakang na tarai Musi, a kakang na tarai Kora. Ma Koat i ga vangala Amram. ");
INSERT INTO ksd_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Ma ra iang i ra taulai kai Amram, Iokebed, a natu i Levi, nina Levi i ga vangala aro Aigipto; ma i ga kava tar Aron ma Moses, ma Miriam tai dir, tai Amram. ");
INSERT INTO ksd_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Ma Aron i ga vangala Nadab ma Abiu, Eleasar ma Itamar. ");
INSERT INTO ksd_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Ma Nadab ma Abiu dir ga mat, ba dir ga tul tar ra iap vakuku tadav ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Ma diat ba di ga luk diat a ura vinun ma a utul a arip diat, a lavur tutana ba dia ga laun vue tika na gai; ma pa di ga luk varurungane diat ma ra tarai Israel, tago pa kadia ta kakalai livuan pire ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Go diat ba Moses ma Eleasar ra tena tinabar dir ga luk diat; dir ga luk ra tarai Israel ta ra tamataman Moab ta ra papar a Iordan tai Ieriko. ");
INSERT INTO ksd_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Pa ta na mulai ta diat ba Moses ma Aron ra tena tinabar dir ga luk diat i ga ki ta go ra niluluk. (Dir ga luk ra tarai Israel ta ra bil Sinai.) ");
INSERT INTO ksd_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Tago ra Luluai i ga biti ure diat: A dovotina diat a mat ta ra bil. Ma pa ta tikai ta diat i ga ki valili, ia kaka Kaleb natu i Iepune, ma Iosua natu i Nun. ");
INSERT INTO ksd_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Ma ra umana vavina, a umana natu i Selopekad, natu i Eper, natu i Gilead, natu i Makir, natu i Manase, ta ra vuna tarai Manase, natu i Iosep, dia ga vana, (ma go ra iang i diat ra umana natuna: Makla, Noa, Kogla, Milka, ma Tirsa,) ");
INSERT INTO ksd_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","ma dia ga tur rikai pire Moses, ma pire Eleasar ra tena tinabar, ma pire ra umana luluai ma ra kor na tarai par, ta ra matakilalat i ra pal na varbarat, ma dia ga biti: ");
INSERT INTO ksd_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Tama i vevet i ga mat ta ra bil, ma pa i ga tur maravut ra tarai kai Kora nina dia ga tut varurung ure ra Luluai; ia kaka i ga mat ta kana varpiam iat; ma pa i ga vangala ta bul tutana. ");
INSERT INTO ksd_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Upi ra ava da tak vue ra iang i tama i vevet kan kana apik na tarai, tago pa ta natuna a bul tutana? Una tul tar ta tiniba ta vevet livuan ta ra umana tama i vevet. ");
INSERT INTO ksd_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Ma Moses i ga kap kadia vavaarikai ta ra luaina mata i ra Luluai. ");
INSERT INTO ksd_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Ma ra Luluai i ga tata pire Moses dari: ");
INSERT INTO ksd_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","I takodo ra tinata kai ra umana natu i Selopekad; io, una tul tar muka ta tiniba na kakalai ta diat livuan ta ra umana tama i diat; ma una varkurai ba diat a kale ra tiniba kai tama i diat. ");
INSERT INTO ksd_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Ma una tata pire ra tarai Israel dari: Gala ta tutana i mat, ma pa ta natuna a tutana, natuna a vavina na kale kana tiniba. ");
INSERT INTO ksd_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ma gala pa ta natuna a vavina, turana na kale kana tiniba. ");
INSERT INTO ksd_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Ma gala pa ta turana, a umana tura i tamana diat a kale kana tiniba. ");
INSERT INTO ksd_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Ma gala tamana pa ta turana avat a tul tar kana tiniba tai ta tutur tana, ma na kale; ma na da ra varkurai ma ra togotogo pire ra tarai Israel, da ra Luluai i ga vartuluai pire Moses tana. ");
INSERT INTO ksd_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Ma ra Luluai i ga biti tai Moses: Una tutua ta go ra luana Abarim, ma una bobe ra gunan nina iau ga tul tar ia pire ra tarai Israel. ");
INSERT INTO ksd_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Ma ba u tar bobe, una mat, da turam Aron i ga mat; ");
INSERT INTO ksd_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","tago amur ga piam vue kaugu tinata ta ra bil Sin, ba ra tarai dia ga varngangar, upi amur a vaarike kaugu lia na kini ta ra tava ta ra mata i diat. (Go ure ra tava Meriba aro Kades ta ra bil Sin.) ");
INSERT INTO ksd_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Ma Moses i ga tata pire ra Luluai dari: ");
INSERT INTO ksd_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Boina ba ra Luluai, ra God kai ra lavur launa, na tibe ta tutana upi na kure ra kor na tarai, ");
INSERT INTO ksd_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","nina ba na irop ta ra luaina mata i diat, ma nina ba na ruk ta ra luaina mata i diat, ma nina ba na agure vairop diat, ma nina ba na ben varuk diat; upi koko ra kor na tarai kai ra Luluai diat a da ra umana sip ba pa kadia ta tena varbalaurai. ");
INSERT INTO ksd_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Ma ra Luluai i ga biti tai Moses: Una agure Iosua natu i Nun, a tutana nina ra tulungen i ki tana, ma una vung ra limam tana; ");
INSERT INTO ksd_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","ma una vatur ia ta ra luaina mata i Eleasar ra tena tinabar, ma ta ra luaina mata i ra tarai; ma una vakakap tar ra tiniba tana ta ra mata i ra tarai. ");
INSERT INTO ksd_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ma una tibe tar kaum varkurai tana upi ra kor na tarai Israel diat a toratorom. ");
INSERT INTO ksd_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Ma na tur pire Eleasar ra tena tinabar, nina ba na titir ure ta ra luaina mata i ra Luluai tai Urim ure ra varkurai; ta kana tinata diat a irop ma ta kana tinata diat a ruk, diat ma ra kor na tarai Israel parika varurung me. ");
INSERT INTO ksd_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Ma Moses i ga pait ia da ra Luluai i ga vartuluai pirana; i ga agure Iosua, ma i ga vatur ia ta ra luaina mata i Eleasar ra tena tinabar, ma ta ra luaina mata i ra tarai par; ");
INSERT INTO ksd_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","ma i ga vung ra limana tana, ma i ga vakakap tar ra tiniba tana, da ra Luluai i ga vatang ia ta ra ngie i Moses. ");
INSERT INTO ksd_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Ma ra Luluai i ga tata pire Moses dari: ");
INSERT INTO ksd_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Una vartuluai pire ra tarai Israel, ma una biti ta diat: Avat a nuk pa ia ba avat a tul tar kaugu lavur vartabar na nian piragu ta kadia e, kaugu nian ure ra tinabar di tun tar ia ta ra iap upi ra magit i ang na katkat piragu. ");
INSERT INTO ksd_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Ma una biti ta diat: Go ia ra tinabar di tun 