﻿USE sofia;
DROP TABLE IF EXISTS sofia.ksc_vpl;
CREATE TABLE ksc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ksc_vpl WRITE;
INSERT INTO ksc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Annayan mansùsùnufan na nginkanà an Jesu Cristu wi kanà David wi kanà ako Abraham. ");
INSERT INTO ksc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","6a","Nanipud an Abraham ingkanan Ali David, anchanayan lunap wi nansùnusùnub: Abraham, Isaac, Jacob, Juda wi mansusunud, cha Fares an Zara wi Tamar na inacha, Esrom wi Fares na amana, Aram, Aminadab, Naason, Salmon, Boaz wi Rahab na inana, Obed wi Ruth na inana, Jesse ya Ali David. ");
INSERT INTO ksc_vpl VALUES ("MT1_6b","070_1_6b","MAT","1","6b","11","Ad nanipud an David ingkana ta timpuy nilayawan chachi kanà Israel wi naiyoy ad Babilonia, anchanayan lunap wi nansùnusùnub: David, Solomon (wi na inana, chi asawan Urias), Roboam, Abias, Asa, Josafat, Joram, Ozias, Joatam, Acaz, Ezekias, Manases, Amon, Josias ya Jeconias wi mansusunud. ");
INSERT INTO ksc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Ad nanipud ta sachi naiyayanchad Babilonia ingkana ta niyanaan Jesus, anchanayan lunap wi nansùnusùnub: Jeconias, Salatiel, Zorobabel, Abiud, Eliakim, Azor, Sadoc, Akim, Eliud, Eleazar, Matan, Jacob, ya Jose wi asawan Maria wi nan-inan Jesus. À Jesus, siyan Cristu wi impustan Apudyus wi ipaalina ad asnay lutà manturay. ");
INSERT INTO ksc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Siyan nanipud an Abraham ingkanan David, nasawaran à opat wi umapu. Ad nanipud an David ingkana ta naiyayan chachi kanà Israel ad Babilonia, nasawaran akò opat wi umapu. Ad nanipud ta sachi timpu ingkana ta niyanaan Cristu wi impustan Apudyus wi umali, nasawaran akò opat wi umapu. ");
INSERT INTO ksc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Amasnan nànàwa wi mipangkop ta niyanaan Jesu Cristu. À Maria wi inana, nampagtachan Jose. Ngim na chaancha pù mantipunan, inakammun Maria wi nafukì siya mipakapu ta mannakafalin na Ispiritun Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ngim à Jose wi pagtana, mamfaru ya lawingonay mafainan à Maria, pionay mansinacha à maid osà mangakammu. ");
INSERT INTO ksc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ustuy mammomammò à Jose nu sinun in-inona, nampailan osay anghel Apudyus an siya ta nan-in-inpana ad anana, “Siay Jose wi kanà David, achia mafain wi mangasawan Maria, tan na nafukiyana, Ispiritun Apudyus na nangwa. ");
INSERT INTO ksc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Iyanànan larai ad ngachananyù Jesus tan siyan manaraknib an chiayuy asintatakuna ta machusaanyu kapu ta fasuryu.” ");
INSERT INTO ksc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nàwan anchanayà tumuttuwaan na impaifakan Apudyus ta profeta ta awi, wi anana, ");
INSERT INTO ksc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mafukin osay fafarasang wi foon pù nasagsakid, ad iyanànan larai wi maawakan à Emmanuel” (Na miningna, “Annà Apudyus an chitau ta sana”). ");
INSERT INTO ksc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ad fummangon pù Jose, tinungparnan imfakan na anghel an siya, ad inasawanà Maria. ");
INSERT INTO ksc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ngim achicha pu nantipun ingkanà ummanà. Ad na ummanaana, nginachanan Jose na anà à Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Timpun ad na aaliyan Herod, niyanà à Jesus ad Betlehem wi osay ilid Judea. Na sachi ko, chummatong ad Jerusalem na uchumi nangad-achar ta fituwon wi namparpu ta apot ta sumingitan na init. ");
INSERT INTO ksc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ad inimuscha anani, “Sinun niyanaan na anà wi niyanà à man-alin chiayuy Judio? Tan innilanin fituwon wi singyar na niyanaana ta sumingitan na init, ad sachin ummaliyannisna ta chayawonnì siya.” ");
INSERT INTO ksc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Chingngor pun Ali Herod na sachi, nalifuk na somsomòna ya uray akon chachi uchumi iJerusalem. ");
INSERT INTO ksc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Siyan impaarus Herod na losani pangpangun na papachi ya mangitudtuchu ta Lintog, ad inimusnan chicha, “Sinun miyanaan na Cristu wi umali nu manturay?” ");
INSERT INTO ksc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ad ananchay summongfat, “Ilid Betlehem wi sakup Judea, tan siyan anan na inyug-is na profeta ta awi wi anana, ");
INSERT INTO ksc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Na sachi kàiti ilid Betlehem wi sakup Judea, namfalin à angatuwani ili ta losani il-ilid Judea, tan siyan lumoswaan na mangituray ta takù wi kanà Israel.’” ");
INSERT INTO ksc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Sachi ad inyagkaaw Herod wi nangayag ta chachi kaili wi nangad-achar ta fituwon, ad inimusnan chicha nu naanun ustuustuy lummoswaan na sachi fituwon. Ad imfakachan siya. ");
INSERT INTO ksc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Sachi ad impaligwatna chicha ta umoychad Betlehem ad anana, “Ing-ayu anapon na sachi anà, ta nu ochasanyu, umaliyun saon ifaka ta inyà ako chayawon à siya.” ");
INSERT INTO ksc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ad lummigwatcha wi umoy ad Betlehem. Ingkawcha pun ta charan, amod na lagsakcha tan nampaila ko asin na sachi fituwon wi innilacha ta chamuy lummigwatancha. Siyan inun-unudchan sachi fituwon ingkanà ummillong ta fatug na iningkawan na anà. ");
INSERT INTO ksc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ad linumnòcha ta sachi foroy, ad innilachan anà ya inanay Maria. Ad nampalintumongchay nanayaw an siya. Ad in-archan atodchan siya wi nan-anginay falituk ya fangfanguy insenso ya lana wi ananchay mirra. ");
INSERT INTO ksc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ad impain-inop Apudyus an chicha wi achicha pu mangulin an Herod, siyan nangoychà safalì charan wi nangulin ta ilicha. ");
INSERT INTO ksc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Lummayaw pun chachi nangad-achar ta fituwon, nampain-inop akon anghel Apudyus an Jose ad anana, “Fumangon-ayu ta ilayawnun anà ya inana tan anapon Herod na anà ta papatoyna. Siyan mamfakwit-ayud Egipto ad ingkaw-ayud aschi ingkanà ifakà na lumayawanyu.” ");
INSERT INTO ksc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ad fummangon à Jose ad illayawnan man-ina ta sachi lafi wi ummoychad Egipto. ");
INSERT INTO ksc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ad iningkawchad Egipto ingkana ta natayan Herod. Nàwa losan chachì tummuttuwaan na impaifakan Apudyus ta profeta ta awi wi anana, “Inayakà na anàu ta lumayaw ad Egipto.” ");
INSERT INTO ksc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Inakammun pu Herod wi sinikapan chachi nangad-achar ta fituwon à siya, naam-amod na og-otna. Ad illintogna wi mapatoy na losani an-ananà wi larai ad Betlehem ya sinakupna wi mantawon à chuwa ya uray kurang à machuway tawon. Tan umoy à chuway tawon na naparafas nanipud ta nail-an na fituwon wi imfakan chachi nangad-achar ta fituwon. ");
INSERT INTO ksc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ad sachin tummuttuwaan na imfakan Jeremias wi profeta ta awi wi anana, ");
INSERT INTO ksc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Mamagngor na ngonot ad Rama wi amochi ifil ya chomchom. Ifilan Raquel chachi kanàna tan natoycha. Ad achi pu maàarù tan naamin natoy na kanàna.” ");
INSERT INTO ksc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Natoy pun à Herod, asin nampain-inop na anghel Apudyus an Jose ad Egipto, ");
INSERT INTO ksc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ad anana, “Fumangon-a ta ilayawnun man-ina ta mangulin-ayud Israel, tan natoy losan chachi maryad mangtoy ta annay anà.” ");
INSERT INTO ksc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Siyan illayaw Jose na man-ina ad nangulinchad Israel. ");
INSERT INTO ksc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ngim chingngor pu Jose wi sinukatan Arkelao à amanay Herod wi man-ali ad Judea, ummogyat wi umoy ad aschi. Siyan asin nipain-inop an siya wi Galilea na umayancha, ");
INSERT INTO ksc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ad ummoycha finumroy ta osay ili wi ananchay Nazaret. Nàwan sachì tummuttuwaan na imfakan na profetas ta awi wi anancha, “Awakan na takù siyà iNazaret.” ");
INSERT INTO ksc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Lummaus ad na am-annay tawon, iningkaw na osay larai wi nangngachan à Juan wi anancha koy Mamfufunyag wi ummoy ta ikaw wi maid pu ili, ad illukinay mangitudtuchu ta takuy mituntun-ud an siya. ");
INSERT INTO ksc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Anana, “Masapur ifafawiyun lawingi oy-oyyoonyu, tan chanchanin mallukiyan na Manturayan Apudyus!” ");
INSERT INTO ksc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Na sachi Juan, siyan inug-ugkud Isaias wi profetan Apudyus ta awi, wi anana, “Awad na osay taku ta ikaw wi maid pu ili, wi mangip-ip-aw ta taku anani, ‘Annay chumatong na Apu. Pafaruwonyun somsomòyu ya mansakanaayu wi isun na mangikakatan ta charan nu siya chumatong na Ali!’” ");
INSERT INTO ksc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Na luput Juan, inafor wi chutchut na kamar, ya uglit na tàyadna, ad chuchun ya chilun aannona. ");
INSERT INTO ksc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ad na ad-adchuwani taku, ummoycha chingngor na itudtuchuna, wi narpuchad Jerusalem ya losani sakupon na provinsiya wi Judea ya losan akoy ili wi achani ta Chawwang wi Jordan. ");
INSERT INTO ksc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ad imfafawichan fasurcha, ad finunyakan Juan chicha ta sachi chawwang. ");
INSERT INTO ksc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ngim na nangil-an Juan ta achuy Fariseo ya Saduceo wi ummoy an siya mampafunyag, ananan chicha, “Apay, chiayuy nasikap! Sinun nangifakan chiayu wi mampafunyag-ayu kay ta ilisiyun chusan Apudyus ta taku? ");
INSERT INTO ksc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Masapur oyyoonyun sinuy mangipaila wi tuttuway namfafawiayu ta fasuryu. ");
INSERT INTO ksc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ad achiyu namnamaoni mailisiyun kachusaanyu ta mangwanaanyuy kanà Abraham chiayu. Tan ifakà an chiayu, wi uray na anchanayay fatu, mafalini mamfalinon Apudyus chichà kanà Abraham nu piona! ");
INSERT INTO ksc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Na miyalikan na manusaan Apudyus ta taku, isù pannakur wi nififiyad wi manipur ta ayu ta lamutna. Siyan losani ayu wi achi pu mamkas à mamfaru, masipur ad maskob. ");
INSERT INTO ksc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Chanum yakan ifunyag-ù mangipaila wi namfafawiayu ta fasuryu. Ngim awad na umali wi misukat an saon wi nangatngatu nu saon, wi kurangà à mansaniluna. À siya, ifunyagnan chiayun Ispiritun Apudyus ya apuy. ");
INSERT INTO ksc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ad nu umali, ilasinnan mamfaruy taku ta lawing, wi isun na mantopà finayu wi ilasinnan finayu ta chuki. Na finayu, iyarangna, ngim na chuki, mifallu ta apuy wi achi pu masobsofan.” ");
INSERT INTO ksc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Na sachi timpu, chummatong à Jesus wi narpud Galilea wi ummoy mampafunyag an Juan ta sachi Chawwang wi Jordan. ");
INSERT INTO ksc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ngim ummisì à Juan, wi anana, “Sia kuman mamunyag an saon, ngim ummalian saon pafunyag!” ");
INSERT INTO ksc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ngim summongfat à Jesus anani, “Sian mamunyag an saon, tan siyan mangwaanta ta losani pion Apudyus.” Siyan nanay-ù Juan. ");
INSERT INTO ksc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nafunyakan pun à Jesus, lummoswa ta chanum, ad niwanit ad langit ad innilanan Ispiritun Apudyus wi nan-osog lummap-oy an siya wi isù karupati. ");
INSERT INTO ksc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ad iningkaw na kinga wi narpud langit, wi anana, “Sanat na anàu wi ay-ayatò. Maragsakanà an siya.” ");
INSERT INTO ksc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Sachi ad impuyut na Ispiritun Apudyus à Jesus ta ikaw wi maid pu takù ingkaw ta sachin mamachasan Satan an siya makafasuron. ");
INSERT INTO ksc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ad ta unog na opatpuruy padcha ta sachi wi foon pù nangnangan, siyan nafitifitil. ");
INSERT INTO ksc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Siyan ummoy Satan padpachason à siya, wi anana, “Nu tuttuway anà sian Apudyus, mamfarfalinom tinapoy na anchanayay fatu.” ");
INSERT INTO ksc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ngim sinongfatana anani, “Niyug-is ta ukud Apudyus wi, ‘Foon pu kà tinapoy afus na ifiyag na taku, ngim masapurcha kon losani ukud Apudyus à mafiyakanchà ing-ingkana.’” ");
INSERT INTO ksc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sachi ad inyoy Satan à Jesus ta tabfungan na Templo ta sachi naapudyusani ili wi Jerusalem. ");
INSERT INTO ksc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ad ananan siya, “Nu tuttuway anà sian Apudyus, man-odchag-a, tan niyug-is ta ukud Apudyus wi, ‘Filinon Apudyus na aanghelesnà mangayyuwan an sia, siyan sìpawonchà sia, ta uray na chapannu, achi pu masukat ta fatu.’” ");
INSERT INTO ksc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ad anan ako Jesus an siya, “Ngim niyug-is ako ta ukud Apudyus wi, ‘Achim padpachason na Apum wi Apudyus.’” ");
INSERT INTO ksc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ad inyoy ako Satan à Jesus ta tànangani filig, ad impailanan mansabsafali wi maiturayan ta luta ya kinafarucha. ");
INSERT INTO ksc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ad anana, “Paituray-u losan chachi an sia nu mampalintumong-a wi manayaw an saon.” ");
INSERT INTO ksc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ad summongfat à Jesus anani, “Lumayaw-a Satan! Tan na niyug-is wi ukud Apudyus, anana, ‘Maid uchum à chayawonyu nu achi afus na Apuyu wi Apudyus, ya afus akò siyà patkonyu!’” ");
INSERT INTO ksc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Sachi ad lummayaw à Satan, ad ummoy na aangheles finadngan à Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Chingngor pun Jesus wi nifarud à Juan wi Mamfufunyag, nangulin ummoy ad Galilea. ");
INSERT INTO ksc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ngim foon à iningkaw ad Nazaret ngim ummoy ad Capernaum wi achani ta sachi Fayfay wi Galilea wi sakupon Zabulon ya Neftali. ");
INSERT INTO ksc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nàwan sachì tummuttuwaan na inukud Isaias wi profeta ta awi, wi anana, ");
INSERT INTO ksc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Mafadngan na takud Zabulon ya Neftali wi chomang na sachi Chawwang wi Jordan wi nan-apot ta Fayfay, wi chichan foon pù Judio wi ingkaw ta provinsiya wi Galilea! ");
INSERT INTO ksc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Na amaschi wi taku, isù iniingkawcha ta pangot kapu ta fasurcha, ad sachin nisinaanchan Apudyus. Ngim mamfaru ta sana tan marawakan na somsomòcha tan chummatong an chichan napigsay Silaw.” ");
INSERT INTO ksc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ad nanipud ta sachi, illukin Jesus wi mangiwarawag ta tudtuchuna anani, “Masapur mamfafawiayu ta lawingi oy-oyyoonyu tan chanchanin milukiyan na Manturayan Apudyus!” ");
INSERT INTO ksc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Na nanadchadcharanan Jesus ta tarantag na sachi Fayfay wi Galilea, innilanan chuway mansunud wi cha Simon wi ananchay Pedro ya Andres wi manakufur. ");
INSERT INTO ksc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ad anan Jesus an chicha, “Ichulinyunat ad mitun-ud-ayun saon ta sukatà na iwaaryu ta mamatiyonyun takun saon.” ");
INSERT INTO ksc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ad nan-itaynanchan takufurcha ad nitun-udchan siya. ");
INSERT INTO ksc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Naaaycha pù ait innilan ako Jesus na chuway mansunud wi cha Jaime an Juan ya amachay Zebedeo wi iningkaw ta fangkacha, wi amatonchan takufurcha. Ad inayakan ako Jesus chichay mansunud. ");
INSERT INTO ksc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ad nan-itaynanchà amacha ta fangka ad nitun-udchan Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ad ummoy à Jesus ta ailiilid Galilea nantudtudtuchu ta sinagogacha wi makimkimungan na Judio, ad inwarawarawagnan Mamfaruy Chamag mipangkop ta Manturayan Apudyus. Ad inaanna kon nan-ob-ofot wi sakit ya likat na taku. ");
INSERT INTO ksc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ad nanchinamag na mipangkop an Jesus ta losani ilid Siria. Siyan inyoy na takun siyan losani nasakit à nan-ob-ofot wi sakit, wi isun na nakafarfaray, nakartoy ya chachi naayayong. Ad impaimfag Jesus chicha losan. ");
INSERT INTO ksc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ad ad-adchuwan na takuy nitun-ud an siya wi narpu ta provinsiya wi Galilea ya Judea ya Decapolis ya Jerusalem ya chachi ili ta chomang na Chawwang wi Jordan. ");
INSERT INTO ksc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Innilan pu Jesus na ad-adchuwani taku, summang-at ta takudtud ad ummachuy, ad naarus na disipulusnan siya. ");
INSERT INTO ksc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ad tinudtuchuwana chicha anani, ");
INSERT INTO ksc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Maragsak na takuy makaawat wi maid lobfongchay mangwa ta mamfaruwon Apudyus nu achina chicha fadngan, tan mitatappicha ta Manturayan Apudyus! ");
INSERT INTO ksc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Maragsak akon takuy manochomchom mipakapu ta lawingi màmàwa, tan paragsakon Apudyus chicha! ");
INSERT INTO ksc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Maragsak akon takuy mangipafafa ta long-agcha, tan adchon Apudyus chachi impustanan chicha! ");
INSERT INTO ksc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Maragsak akon takuy siya kay pionchay oyyoon na pàwan Apudyus, tan fadngan Apudyus chicha wi mangwa ta mapnokancha! ");
INSERT INTO ksc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Maragsak akon takuy manangngaasi ta asintatakuna, tan kaasiyan ako Apudyus chicha! ");
INSERT INTO ksc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Maragsak akon takuy siya oy-oyyoonchan pion Apudyus wi maid lawing à pangkopchay mangwa, tan ilanchà Apudyus à tapin na padcha! ");
INSERT INTO ksc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Maragsak akon takuy siya oy-oyyoonchan mampatarna ta taku, tan ifilang Apudyus chichà an-ananàna! ");
INSERT INTO ksc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Maragsak akon takuy maparpalikatan kapu ta mangwaancha ta pion Apudyus, tan mitapicha ta Manturayanad langit! ");
INSERT INTO ksc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Maragsak-ayuy main-insurtu ya maparpalikatan ya mifafain kapu ta manursurutanyun saon. ");
INSERT INTO ksc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Uray nu amaschin oyyoonchan chiayu, maragsak-ayu ko kay tan chakor na kunkunayud langit. Tan amaschi kon napaspasamak ta chachi profetas ta awi.” ");
INSERT INTO ksc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ad inturuy Jesus wi mantudtuchu, anana, “Isuayù asin ta losani taku ta lufung. Ngim nu maaan na tamtam na asin, maid in-inon wi mangiyulin ta kinaasinna. Mifallu ad chamchampiton na taku tan maid silfina. ");
INSERT INTO ksc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ya isuayu kò silaw wi manlawag ta somsomò na losani takud asnay luta. Na aligna, isuayù ili ta osay takudtud wi mamàila wi achi pu mafalini masar-iwan. ");
INSERT INTO ksc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ad maid pu ko takù paskichanan silaw ad tinab-unana, ngim ipatayna ta losan masilawan na charò na foroy. ");
INSERT INTO ksc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ad amaschi kon linangyu, wi masapur mamàila ta taku. Tan na mangil-ancha ta mamfaruy oyyoonyu, siyan mangichayawanchan Apudyus wi Amayud langit.” ");
INSERT INTO ksc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ad inturuy Jesus anani, “Achiyu anani ummalì aanon na Lintog wi inyug-is Moses ya chachi tudtuchun na profetas, tan na ummaliyà, à tumuttuwaan na losani imfakan na niyug-is. ");
INSERT INTO ksc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Somsom-onyuna, achi pu mafarfaliwan na Lintog Apudyus. Tan uray nu chumatong na pagpag na annayay luta ya langit, achi pu maaan uray na akàitan ta Lintog ingkanà màwan losan. ");
INSERT INTO ksc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Siyan sinumani sumurngasing ta uray kafafaan ta lintogna, ad siya kon itudtuchuna ta uchum, mifilang à siyà kafafaan ta Manturayan Apudyus. Ngim nu sinun manungpar ta losani Lintog Apudyus ya siya kon itudtuchuna ta uchum, mifilang à siyà nangatu ta Manturayan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Siyan na ifakà an chiayu, achiayu pu mitapi ta Manturayan Apudyus nu achiyu pu oyyoon na piona, wi isun chachi Fariseo ya mangitudtuchu ta Lintog. Siyan masapur mamfarun oyyoonyu nu oy-oyyooncha. ");
INSERT INTO ksc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Akammuyu wi nanipud ta awi siya nitudtuchun chitaun sachi lintog wi anana, ‘Achiayu pumatoy, tan na pumatoy, makuis ad machusa.’ ");
INSERT INTO ksc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ngim na ifakà an chiayu ta sana, uray na umog-ot yakay ta furunna, makuis ako kay. Ad na takuy manginsurtu ta furunna, micharum ta chachi nangangatuy kukunsisar. Ad na takuy mangwanan ta furunnay, ‘Natingtingangan-a wi maid silfim!’ lobfongnay mifallu ta apuy wi infierno. ");
INSERT INTO ksc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Siyan nu awad ichatunyun Apudyus, ad simsimmòyu wi awad na lawingon na furunyun chiayu, ");
INSERT INTO ksc_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","taynanyun sachi ichatunyu ta sangwanan na altar ta ummoyyu kaukud na furunyuy pinachuruwanyu ta man-asipakawan-ayu achiyuwot ichatun na pionyuy adchon an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ad nu kaspangalikan awad mangicharum an chiayu, ing-ayu umuna makaukud an siya, ta nu mafalin achiyu iyoy ta kuis. Tan nu mipasanguayu ta kuis, sikurachuy ipaifarud chiayu ta pulis, ");
INSERT INTO ksc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ad tuttuway achiayu pu miparufus ta fafalluchan ingkanà finayachanyun losani murtayu. ");
INSERT INTO ksc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Akammuyu kon nitudtuchu wi anana, ‘Achiayu makachagchakas.’ ");
INSERT INTO ksc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ngim na ifakà an chiayu ta sana, sinumani takuy mangila ta fufai ya simsimmònay makasuyop an siya, isù nakachagchakas ta amaschi somsomòna. ");
INSERT INTO ksc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Siyan nu makafasuranyun ilan na atayu, kulikuranyu ad imfalluyu! Tan un-unnoy na makurangan na long-ag nu wachawad na long-agyu ad nifalluayud infierno. ");
INSERT INTO ksc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ad nu siya makafasuranyun oyyoon na imayu, lampokanyu ad imfalluyu! Tan un-unnoy na mapukuranyu nu wachawad losan na long-agyu ad nifalluayud infierno. ");
INSERT INTO ksc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Akammuyu kon nitudtuchu wi anana, ‘Nu ichangan na larain asawana, masapur mangwà kasuratan na man-ichangancha.’ ");
INSERT INTO ksc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ngim na ifakà an chiayu ta sana, sinumani larai wi mangichang ta asawana, nakafasur, naragsig yakay nu nakararain asawana. Ad na nakafasurana, nakafasuronan asawanay inichangana nu asin mangasawa. Ad siyan na larai wi nangasawan siya, nakafasur ko. ");
INSERT INTO ksc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Akammuyu ko wi nanipud ta awi, intudtuchun chachi aappuyu wi, ‘Achiyu surngasingon na insapatayu, tan masapur oyyoonyun sinumani insapatayun Apudyus wi oyyoonyu.’ ");
INSERT INTO ksc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ngim na ifakà an chiayu ta sana, achiayu umisapatà farangna nu awad ifakayu. Achiyu isapatan langit, tan langit na umaachuyan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ya isuna koy achiyu isapatan annay luta, tan siyan nipapattayan na ikina. Ad isuna koy achiyu isapatan ili wi Jerusalem tan siyan finumroyan na angatuwani Ali. ");
INSERT INTO ksc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ad achiyu ko isapatan uruyu, tan foon à makàwaayù mamputilà winnu mangngitit à uray osà fuùyu. ");
INSERT INTO ksc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Na oyyoonyu kay, ifakayuy ‘Oo’ nu tuttuwa, winnu ‘Foon’ nu foon. Tan nu chog-anyu, Satan na mismuy narpuwan na ichokayu. ");
INSERT INTO ksc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Akammuyu kon nitudtuchun chitau wi anana, ‘Na manyam-an ta atan na asintatakuna, masapur mayam-an akon atana. Ad nu sinun manyam-an ta fafan na asintatakuna, masapur mayam-an akon fafana.’ ");
INSERT INTO ksc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ngim na ifakà an chiayu ta sana, achiayu fumaros ta uray sinuy mangwà lawing an chiayu. Siyan nu awad manlipak ta apingyuy chiwawan, palipakyu kon chuwiki. ");
INSERT INTO ksc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ad nu awad mangicharum an chiayu ta aranchan silupyu, adchonyu kon agwana. ");
INSERT INTO ksc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ad nu awad takù pafuudnan ochonnan chiayù osay kilometro, uray fuuchonyù chuway kilometro. ");
INSERT INTO ksc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Adchanyun man-ochaw an chiayu, ya pafuruchanyun mamfurud an chiayu. ");
INSERT INTO ksc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Akammuyu kon tudtuchu wi anana, ‘Masapur ay-ayatonyun fufurunyu ngim kuraonyun mallawing an chiayu.’ ");
INSERT INTO ksc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ngim na ifakà an chiayu ta sana, masapur ay-ayatonyun mallawing an chiayu, ya masapur iluwaruwanyu kon mamarpalikat an chiayu. ");
INSERT INTO ksc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tan nu amaschin oyyoonyu, isuwonyun Amayud langit. Tan iparufusnan uminitan na init à fumaruwan na losani taku, wi uray lawing ya mamfaru. Isun akon uchan, adchona kò fumaruwan na losani taku, uray na mangwà lawing ya mangwà mamfaru. ");
INSERT INTO ksc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tan kunkunaan Apudyus chiayu nu afus na takuy mangayat an chiayù ay-ayatonyu? Foon, tan uray chachi manchachakup à fukis wi manturtulli, amaschi kon oyyooncha. ");
INSERT INTO ksc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ad nu afus na fufurunyun makaug-ugkuchanyu wi laksikonyun uchum, sinun silfina tan uray na achi pu mamati, amaschi kon oyyooncha! ");
INSERT INTO ksc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Masapur iyustuustuyun oyyoonyu, wi isun na kinaustun na Amayud langit.” ");
INSERT INTO ksc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ad inturuy Jesus wi mantudtuchu anani, “Man-annad-ayu ta achiyu ipàpaila na takun mangwaanyu ta mamfaru. Tan nu siya kay mangwaanyun pionyuy ichayaw na takù chiayu, foon pù kunkunaan chiayun Amataud langit. ");
INSERT INTO ksc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Siyan nu awad adchonyù fachang ta takuy makasapur, achiyu kuma ipàpaila ta losani taku wi isun na oy-oyyoon chachi akinpapati wi mamàpail-on wi umoy ta sinagoga ya arsa wi ipàpailachan mamfaruy oyyooncha ta machayawcha. Ngim tuttuwan ifakà an chiayu, wi narpas na losani kunkunacha. ");
INSERT INTO ksc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ngim à chiayu, nu awad adchonyù fachangyu, ilanyu ta achiyu pu kuma ipaakammu ta uray na mismuy furunyu wi mangatod-ayu, ");
INSERT INTO ksc_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ta iyagkaawyuy mangatod. Ad à Amatau wi mangiila ta losani achi pu maila, kunkunaan chiayu. ");
INSERT INTO ksc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nu malluwaruayu, achiyu is-isuwwon na oyyoon na anchanay akinpapati wi mamàpail-on! Tan pionchay umoy umagsad malluwaru ta sinagoga ya ikid na arsà mangil-an na takun chicha. Tuttuwan ifakà an chiayu, wi narpas na losani kunkunacha. ");
INSERT INTO ksc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ngim à chiayu, nu malluwaruayu, lumnòayu ta kuwartuyu ad nan-onob-ayu wi malluwaru an Amatau wi achi pu maila. Ad à Amatau wi losanna ilan na achi pu maila, kunkunaan chiayù tapin na padcha. ");
INSERT INTO ksc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ad nu malluwaruayu ko, achiyu anchuanchuwon na luwaruyu wi isun na oyyoon na chachi maid pammaticha, wi anancha pun nu chongron Apudyus chicha kapu ta kinaanchun na luwarucha. ");
INSERT INTO ksc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Achiyu is-isuwwon na pinagruwarucha. Tan à Amatau, inaagkammunan masapuryu uray nu chaanyu pù ifaka. ");
INSERT INTO ksc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Siyan amasnaonyuy malluwaru: ‘Amanid langit, machaychayaw kuman ngachannu. ");
INSERT INTO ksc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Chumatong kuman manturayam ad asnay luta, ya màwa kuman piom ad asnay lutà isun na màwad langit. ");
INSERT INTO ksc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Adchan chianì anonni ta finikat. ");
INSERT INTO ksc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pakawanon chiani ta lawingi iningwani, à isun na mamakawananni ta chachi fumasur an chiani. ");
INSERT INTO ksc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ya ilisim chiani ta achiani pu maawis wi fumasur, ya ilisim ako chiani ta sulisug Satan.’” ");
INSERT INTO ksc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ad inturuy ako Jesus anani, “Nu pakawanonyun mangwà lawing an chiayu, pakawanon chiayu kon Amayud langit. ");
INSERT INTO ksc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ngim nu achiyu pu pakawanon chicha, foon pu kò pakawanon chiayun Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nu mallangan-ayuy mangan kapu ta malluwaruwanyun Apudyus, achiyu is-isuwwon chachi akinpapati wi obsonchan itchurachà mangil-an na taku wi mallanganchay mangan. Tuttuwan ifakà an chiayu wi narpas na losani kunkunacha. ");
INSERT INTO ksc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ngim chiayu, nu mallangan-ayuy mangan, manchar-up-ayu ya mansakaysay-ayu, ");
INSERT INTO ksc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ta foon pù makailasin na taku wi mallangan-ayuy mangan, ta afus à Amayù mangakammu. Tan à Amayu wi achi pu maila, iillanan losani nitataruy oyyoonyu, ad kunkunaanà chiayù tapin na padcha. ");
INSERT INTO ksc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Achiyu patpatkan na fumaknanganyud asnay luta ya manonsonanyu ta asinchuwan, tan machachail ako kay tan yam-anon na laoy ya lasti ya mafalin akoy maakaw. ");
INSERT INTO ksc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ngim na oyyoonyu kuma, patpatkanyun pion Apudyus ta siyan manonson ta kinafaknangyud langit, tan ad aschi, maid pu makachachail ya maid pu ko makaakaw. ");
INSERT INTO ksc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tan na katuttuwaan, sinumani patpatkanyu, kapilitani siya kon som-osom-onyu.” ");
INSERT INTO ksc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Sachi ad nan-alig à Jesus wi anana, “Na ata, siyan silaw na long-ag. Siyan nu maid pu chufiktun na ata, isù losan nasilawan na long-ag. ");
INSERT INTO ksc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ngim nu awad chufiktun na ata, isù awad na long-ag ta pangot. Siyan nu pangot na marpuwan na linang, isag pumangot. ");
INSERT INTO ksc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Maid pu takù chuwan mangituray an siya tan kapilitani ay-ayatonan osa ya lawingonan osa, ya kapilitani patkonan osa ad achina pun na osa. Isuna ko an Apudyus ya pilak, tan nu pilak na napatog an chiayu, sikurachuy achi pu mafalini patkam na pion Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Siyan na ifakà an chiayu, achiayu machanakan mipangkop ta masapuryu ta mafiyakanyu, isun na maan ya luput, tan napatpatog na fiyagyu nu maan, ya long-agyu nu luput. ");
INSERT INTO ksc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ilanyun sissiwit, wi tumattattayapcha kay wi achicha pu mammura ya maid apitoncha, ya maid pu ko ichulinchà masapurcha. Ad tamako ta asififiyagcha nù? Oo, tan Amayud langit na mangayyuwan an chicha! Ad foon ayà napatpatog-ayu an Apudyus nu anchanay sissiwit? ");
INSERT INTO ksc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ad na osa, maid pu iturung na chanag tan uray machanachanakan-ayu, maid itur-ayna ta fiyagyu! ");
INSERT INTO ksc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ad taayuko ko machanakan mipangkop ta usaronyuy luput? Ilanyun fokaw, achicha pu man-iwaar winnu mallakà luputcha. ");
INSERT INTO ksc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ngim ifakà an chiayu wi namagmagkit na sabsafungcha nu afaruwani silup Solomon wi siyan afaknangani Ali. ");
INSERT INTO ksc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Siyan nu amaschin oyyoon Apudyus wi mangipafaru ta fokaw wi sin-aitan yakan awachancha, maryawchà fikat ad maskobcha, sinchumallun somsomòna ta mipangkop ta iluputyuy taku! Kurang na pammatiyu! ");
INSERT INTO ksc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Siyan achiayu machanakan ta mipangkop ta masapuryu wi ifiyagyu wi isun na maan ya mainum ya luputyu, ");
INSERT INTO ksc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","tan amaschin som-osom-on na takuy foon pù mamati. Ngim chiayu, akammun na Amayud langit wi masapuryu losan na amaschi. ");
INSERT INTO ksc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Siyan na som-osom-onyu kuma, mipangkop ta Manturayan Apudyus ya mangwaanyu ta piona. Tan nu amaschin patpatkanyu, nangamung à siyay mammammò ta losani masapuryu. ");
INSERT INTO ksc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Siyan achiayu machanakan mipangkop ta mapasamak à fikat, tan para kò fikat na màwaan na anchanaya. Tan tayuko chogchog-an na likatyu ta sana ta likatyù fikat?” ");
INSERT INTO ksc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ad inturuy Jesus wi mantudtuchu, anana, “Achiyu pafasuron na uchum ta achin pu ko Apudyus pafasuron chiayu. ");
INSERT INTO ksc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tan na oyyoonyu ta uchum, siya kon oyyoon Apudyus an chiayu. Siyan na losani oyyoonyu ta asintatakuyu, sachi kon oyyoon Apudyus an chiayu. ");
INSERT INTO ksc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Na miyalikana, isù narawag na mangil-anyu ta aiti mukat ta atan na furunyu, ngim foon pù mailasinyun nipapaktar wi mukatyu! ");
INSERT INTO ksc_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Mafalin aya wi anami, ‘Choo ta aanò na aiti mukatnu,’ ad annan nipapaktar wi mukatyu? ");
INSERT INTO ksc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mamàpail-on-ayu! Siyan masapur unaonyu aanon na nipapaktar wi mukat ta atayu ta lumawag na mangil-anyu wi mangaan ta aiti mukat na furunyu. ");
INSERT INTO ksc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Achiyu ipapilit itudtuchun ukud Apudyus ta takuy kattoi lawingonchay mangngor. Na miyalikana, achiyu adchon na kanginaan ta asu, tan uray nu adchonyun siya, obfan chiayu ko kay, ya achiyu ko adchon na napatog wi fongar ta forò, tan iwalischa ad chinamchampitcha. ");
INSERT INTO ksc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Nu awad masapuryu, chawatonyun Apudyus ad adchonan chiayu. Nu anaanaponyun pionyuy anapon, ochasanyu. Ad nu kongkongonyun liwangan, maib-at an chiayu. ");
INSERT INTO ksc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tan losani manchawat an Apudyus, maatod na chawatona, ad na manganap ta pionay anapon, ochasana, ya maib-at na liwangan ta sinumani mangkongkong. ");
INSERT INTO ksc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Somsom-onyun annaya: uray à chiayuy aamma, nu manchawat na anàyù maan, adchanyù fatu? ");
INSERT INTO ksc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ad nu manchawat à filis, adchanyù urog? ");
INSERT INTO ksc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Siyan chiayuy managfasur, nu akammuyuy mangatod à mamfaru ta anàyu, sin-umisag na oyyoon Amayud langit wi mangatod ta mamfaru ta sinumani manchawat an siya. ");
INSERT INTO ksc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Na sinumani pionyuy oyyoon kuman takun chiayu, siya kuman oyyoonyun chicha, tan sachin puntus na losani Lintog Moses ya intudtuchun chachi profetas ta awi. ");
INSERT INTO ksc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mangoy-ayu ta nalipiti liwangan, tan na mawwar-angi liwangan, manturung ad infierno, ad kapu ta narakan sachi charan, achun mangoy. ");
INSERT INTO ksc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ngim kapu ta nalipit na liwangan wi maoy ad langit ya nalikat akon charan, siyan ait na mangoy. ");
INSERT INTO ksc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“An-annachanyun chachi sinanprofetas wi takuy mangwanani ukud anu Apudyus na itudtuchucha, ngim foon pun. Isuchà naanusi taku, ngim na katuttuwaan, yam-anonchan pammatiyu. ");
INSERT INTO ksc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mailasincha tan na oy-oyyooncha siyan mangifaka ta kinatatakucha, wi na miyalikancha, foon pù mafalini ifungan na tarurung na atunor! Ya foon pu kò mafalini ifungan na tabfog na akit! ");
INSERT INTO ksc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ad na osa, na mamfaruy imong, mamfaru kon ifungana, ngim na lawingi imong, lawing akon ifungana. ");
INSERT INTO ksc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tan maid mamfarù ifungan na lawing, ya maid ako lawing à ifungan na mamfaru. ");
INSERT INTO ksc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ad na imongi achi pu mamkas à mamfaru, masipur ad maskob. ");
INSERT INTO ksc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Siyan na mangilasinanyu ta sinanprofeta, na oy-oyyooncha.” ");
INSERT INTO ksc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ad inturuy Jesus wi mantudtuchu, anana, “Foon pù losani maaapu an saon lumnò ta Manturayan Apudyus, tan afus na chachi mangwa ta pion Ama ad langit. ");
INSERT INTO ksc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Siyan nu chumtong na padchay manguisan Apudyus ta taku, achun umalin saon mampangpangngaasi anani, ‘Apu, Apu, parnoon chiani! Tan mipakapu ta karobfongam, intudtuchunin mipangkop an Apudyus, ad imparyawnin achuy farfaray na nakafarfaray, ya nangwaani kò achù kaskaschaaw!’ ");
INSERT INTO ksc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ngim na isongfat-un chicha, ‘Mantulituliayu! Maid akammù an chiayu. Lumayaw-ayu!’ ");
INSERT INTO ksc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Sinumani mangngor ta annay ifagfakà ya oyyoona, miyalig ta nararami taku wi fatun nangisaachana ta foroyna. ");
INSERT INTO ksc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ad uray nu ummuchauchan pun ya nanurun na chawwang ya fummalifali, achi pu nikur-ub na foroyna tan mampagchot na nisaachana. ");
INSERT INTO ksc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Ngim na takuy mangngor ta ifagfakà ya achina pu oyyoon, miyalig ta natingtingangani taku wi insaadnan foroyna ta lagrakan. ");
INSERT INTO ksc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ad ummuchauchan pun ya nanurun na chawwang ya fummalifali, nikur-ub na sachi foroy ad naamin niwànag!” ");
INSERT INTO ksc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Narpas pun Jesus imfakan anchanaya losan, naschaaw chachi takuy naarus ta pinagtudtuchuna, ");
INSERT INTO ksc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","tan foon pù isun na pinagtudtuchun chachi mangitudtuchu ta Lintog, tan maila wi annan karobfonganay mantudtuchu. ");
INSERT INTO ksc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nan-osog pù Jesus ta takudtud wi nantudtuchuwana, ad-adchuwan na takuy naarus nitun-ud an siya. ");
INSERT INTO ksc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ad na sachi, iningkaw na osay larai wi nakollakong na long-agna, wi ummoy an Jesus nampalintumong ta sangwananna, wi anana, “Apu, patiyò wi annan karobfongami mangaan ta annayay sakit-u, siyan nu kaasiyanà, paimfakonà.” ");
INSERT INTO ksc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Sachi ad inyaragwad Jesus na imanan siya, ad anana, “Oo, kaasiyà sia. Maaan na sakitnu!” Ad naanimfag à siya. ");
INSERT INTO ksc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ad finilin Jesus à siya wi anana, “Achim ug-ugkuchon ta sinuman, ngim ing-a mampaila ta pachi, ad manchatun-a tan sachin illintog Moses à manuttuwaan na taku wi naaan na amaschi wi sakit.” ");
INSERT INTO ksc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Narpas pun na sachi, ummoy à Jesus ad Capernaum, ad na sumungachana ta sachi ili inafot na osay kapitan na surchachu wi iRoma an Jesus wi nampangpangngaasi, wi anana, ");
INSERT INTO ksc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Apu, nasakit na sanilù. Awad ad foroy wi amod na sakitna wi achi pu makaisi, tan akin-ottoyon.” ");
INSERT INTO ksc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ad anan Jesus, “Umalì paimfakon à siya.” ");
INSERT INTO ksc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ngim anan na kapitan, “Apu, mafainà wi mammangilin sia. Umanay yakan ukudnù mampaimfag ta sanilù. ");
INSERT INTO ksc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tan maawatà na mipangkop ta karobfongan, tan uray saoni kapitan, masapur patiyò na ifakan na apù. Ad na susurchachuy iturayà, patiyoncha kon ifakà, tan nu ifakà ta osa, ‘Ing-a!’ umoy, ad nu ifakà ta osa, ‘Umalia!’ umali ko. Ad nu ifakà ako ta sanilù, ‘Oyyoom na sanat!’ oyyoona ko! Ad sinchumalluy màwan ifakam tan annan karobfongam.” ");
INSERT INTO ksc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Naschaaw à Jesus ta nangngorana ta imfakana, ad anana ta takuy umun-un-unud an siya, “Tuttuwan ifakà an chiayu, wi maid pu inchasà à isun na impappatin na anna ta losani chokatauy kanà Israel. ");
INSERT INTO ksc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Tuttuwan ifakà an chiayu, wi ad-adchuwan na foon pù Judio wi marpu ta arutaruta wi umoy makaragsak ancha Abraham, Isaac ya Jacob ta Manturayan Apudyus ad langit. ");
INSERT INTO ksc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ngim chachi Judio wi piniliyan Apudyus wi mitapi kuma ta Manturayana, kaachuwan an chichan mipaoy ta sachi ikaw wi amod na pangotna, ad sachin asiiifilancha ya asingangarotngotan na fafacha kapu ta kinalikatna.” ");
INSERT INTO ksc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ad anan Jesus ta kapitan, “Lumayaw-a, tan na patiyom wi màwan chiayu, màwa.” Ad sachin ustuy ummimfakan na sanilun na kapitan. ");
INSERT INTO ksc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sachi ad ummoy à Jesus ta foroycha Pedro ad innilanan atukangan Pedro wi nifafàsar wi amod na panatingna. ");
INSERT INTO ksc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ad inognan Jesus na imana ad naaan na panatingna, siyan fummangon ad sinakunganà siya. ");
INSERT INTO ksc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mummaschom pun, inchatong na taku an siyan ad-adchuwani nakafarfaray. Ad inaminna imparyaw na farfaraycha ta ukudna, ya impaimfagna kon losani nasakit. ");
INSERT INTO ksc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Iningwana losan chachì tumuttuwaan na inukud Isaias wi profeta ta awi wi anana, “Siyan nangaan ta losani sakittau, ya finnosna finuud na likattau.” ");
INSERT INTO ksc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Na nangil-an Jesus ta ad-adchuwani takuy naarus an siya, imfakana ta chachi disipulusna ta umoycha losan ta chomang wi tarantag na fayfay. ");
INSERT INTO ksc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ad iningkaw na osay sikuchi mangitudtuchu ta Lintog wi ummoy an Jesus, ad anana, “Misturu, mifurunà an sia ta uray sinumani umayam.” ");
INSERT INTO ksc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ad sinongfatan Jesus à siya anani, “Na mutit, annan afutchay ingkawancha, ad na sissiwit, anna kon sùfutchay ingkawancha. Ngim à saoni namfalin taku, maid pu foroy-ù sumpuwà. Ad mitun-ud-a ko kay?” ");
INSERT INTO ksc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ad anan akon osay disipulus Jesus, “Apu, inyà yan ilofon à Ama.” ");
INSERT INTO ksc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ngim anan Jesus an siya, “Ikad na chachi maid pu pammaticha, wi niyalig à natoy, wi mangilofon ta isuchay natoy. Ngim sia, sumurut-an saon.” ");
INSERT INTO ksc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Sachi ad namfangkacha Jesus ya disipulusna. ");
INSERT INTO ksc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nangkinawacha pun ta fayfay, nammaag fummalì napigsa. Ad nganngani milutong na fangka. Ngim nasusuyop à Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Siyan finangon na disipulusnà siya, wi anancha, “Apu, saraknifam chiani! Annay milutongtau!” ");
INSERT INTO ksc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ad fummangon à Jesus, ad pinakinònan fali ya challuyun. Ad asin tummuyong na fayfay. Ad anana, “Taayuko machanakan? Tayukò saon achi piyaron?” ");
INSERT INTO ksc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ad naschaawcha losan wi mamfufurun, ad anancha, “Sinun kintatakun na annay taku, wi uray na fali ya challuyun, patkonchà siya!” ");
INSERT INTO ksc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Chummatong pu cha Jesus ta chomang na sachi fayfay wi sakupon Gadareno, sinib-at na chuway takù Jesus, wi narpucha ta lorobnan. Nakafarfaraycha, ad kaog-ogyatcha, siyan maid pu makaturod wi mangoy ta sachi charan. ");
INSERT INTO ksc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ad nampoawcha anani, “Siay anà Apudyus, sinun oyyoom an chiani? Umalim palikatan à chiani wi chaan pù chumatong na ustuy timpuna?” ");
INSERT INTO ksc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na sachi, niyaspur wi iningkaw na achani wi ad-adchuwani forò wi asisusubsub. ");
INSERT INTO ksc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Siyan nampangpangngaasin chachi aran an Jesus, wi anancha, “Nu iparyawnù chiani, ipaoynù chiani ta anchachiyay forò.” ");
INSERT INTO ksc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ad anan Jesus an chicha, “Ing-ayu nù!” Siyan tinaynanchan chachi taku ad ummoycha nallonog ta forò. Ad chachi forò, asitotodchàcha wi ummoy lumayug ta chopras ad losancha naanud ta fayfay. ");
INSERT INTO ksc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Na takuy namanfantay ta forò, ummawidcha losan ummoy ta ili, ad impachamagchan losani napaspasamak ta chachi forò ya uray chachi takuy nakafarfaray. ");
INSERT INTO ksc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ad lummigwat na losani taku wi umoy mangilan Jesus. Ad na nangchasanchan Jesus, nampangpangngaasichan siya ta lumayaw kuma ta sachi ilicha. ");
INSERT INTO ksc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ad asincha Jesus namfangka wi nanchormang nangulin ta ilina. ");
INSERT INTO ksc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ad na iningkawancha ta sachi ili, inchatong na uchumi takun siyan osay naayayong wi nifafàsar. Ad inakammun pu Jesus wi napigsan pammaticha, anana ta naayayong, “Sunud, lumagsak-a! Napakawan na fasurnu!” ");
INSERT INTO ksc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Iningkaw na uchumi mangitudtuchu ta Lintog wi nan-asiakitùtù anani, “Apay, iyisunan long-agnan Apudyus!” ");
INSERT INTO ksc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ngim à Jesus, inakammunan somsomòcha, siyan anana, “Tamako ta lawing na somsomòyun saon? ");
INSERT INTO ksc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Sinun mallanlanuy à ifaka, ‘Napakawan na fasurnu,’ winnu, ‘Lumigwat-a ta manadcharan-a’? ");
INSERT INTO ksc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","À saon wi namfalin taku, panoknokà an chiayu wi annan karobfongà ad asnay luta wi mamakawan ta fasur.” Ad anana ta sachi naayayong, “Lumigwat-a, ad inaram na ofognu ad lumayaw-a!” ");
INSERT INTO ksc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ad lummigwat na sachi naayayong ad lummayaw. ");
INSERT INTO ksc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ad chachi ad-adchuwani takuy nangiila, naschaawcha wi amod akon ogyatcha, ad chinaychayawchà Apudyus kapu ta nangadchana ta karobfongan na taku wi mangwa ta amaschi. ");
INSERT INTO ksc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Na lummayawan Jesus ta sachi ili, innilanan osay manchachakup à fukis wi nangngachan à Mateo wi ummaachuy ta pisinana. Ad anan Jesus an siya, “Mitun-ud-an saon.” Ad narnigwat à Mateo wi nitun-ud. ");
INSERT INTO ksc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Na nanganancha Jesus ya chachi disipulusna ta foroycha Mateo, ummoy ako nakaan na achuy fufurun Mateo wi manchachakup à fukis ya uchumi takuy managfasur. ");
INSERT INTO ksc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ad na nangil-an na uchumi Fariseo an chicha, inimuscha ta disipulus Jesus, “Tamakon Apuyu, makaan ta kakassanay taku?” ");
INSERT INTO ksc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Chingngor pu Jesus chicha, sinongfatana chichà alig, anana, “Na takuy maid sakitna, foon pù masapurchan chuktur. Siya makasapur na nasakit. ");
INSERT INTO ksc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Anaponyun mining na annayay niyug-is wi ukud Apudyus, wi anana, ‘Foon pù ichatuchatunyun saon na patkà ngim siya patkà na mangaasiyanyu ta asintatakuyu.’” Ad anan ako Jesus, “Na ummaliyà ad asnay luta, foon à tudtuchuwà na mamfaruy taku ngim siya ummaliyà na tudtuchuwà na managfasur.” ");
INSERT INTO ksc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Sachi ad ummoy na uchumi pasurut Juan wi Mamfufunyag inimus an Jesus, “Tamakò chiani ta Fariseo, kanayun-ani mallangani mangan, ngim achi pun na disipulusnu?” ");
INSERT INTO ksc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ad nan-alig à Jesus wi summongfat, anana, “Mansasàuy lawan takuy makakasar nu awad an chichan larai wi mikasar? Achicha pun! Ngim chumatong na timpuy milayawan na nikasar an chicha, ad sachin mallangananchay mangan.” ");
INSERT INTO ksc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ad asin nan-alig à Jesus wi anana, “Maid pu takù itàrupnan lukaki luput ta pallos. Tan nu kumsin na lukaki luput, am-amchonan nakissay. ");
INSERT INTO ksc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ad maid pu ko mangifungufung à inafuyu ta chachaani uglit wi isù amutu, tan fumtak na sachi uglit ad mifallun fayas ad losancha machachail. Ngim na inafuyuy siya mifungufunganan àoyyay uglit wi amutu, maid machachailancha.” ");
INSERT INTO ksc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Man-ukuukud pù Jesus, chummatong na osay pangpangun na sinagogan na Judio ad nampalintumong an siya wi anana, “Àotoy na anàuy fafarasang. Ngim nu umalim agpachan à siya, umuli mataku!” ");
INSERT INTO ksc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ad lummigwatcha Jesus ya disipulusna wi nitun-ud an siya. ");
INSERT INTO ksc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ad niyaspur wi iningkaw na osay fufai wi nasakit à chumarachara ta unog na nasawaran à chuway tawon. Ad ummoy ta odchokan Jesus ad inagpachanan pagpag na silupna, ");
INSERT INTO ksc_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","tan na somsomòna, “Uray nu agpachà yakan silupna, umimfakà.” ");
INSERT INTO ksc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Sachi ad nantuwilì Jesus ad innilanà siya, ad anana, “Sunud, papigsaom na somsomònu! Tan mipakapu ta pammatim an saon, umimfag-a.” Ad sachin ummimfakana. ");
INSERT INTO ksc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Chummatongcha pu Jesus ta foroy na sachi pangpangu, linumnò à Jesus, ad amod na ifil ya ngonot na namakungun. ");
INSERT INTO ksc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Siyan anana, “Lumawaayu losan! Tan foon pù natoy na annay fafarasang. Nasusuyop yakay!” Ngim inam-amangchà siya. ");
INSERT INTO ksc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Lummawa pun na taku losan, linumnò à Jesus ta kuwartuy iningkawan na natoy ad inognanan imana, ad fummangon chi fafarasang. ");
INSERT INTO ksc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ad na sachi iningwan Jesus, nanchinamag ta sachi losani ili. ");
INSERT INTO ksc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Lummayaw à Jesus ta sachi, ad na nanadchadcharanana iningkaw na chuway nakurap wi nitun-ud an siya, wi nampoapoaw anani, “Siay kanà David, kaasiyan chiani!” ");
INSERT INTO ksc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Sachi ad wi linumnò à Jesus ta osay foroy, nakarnò akon chachi nakurap. Ad ananan chicha, “Patiyonyu wi mafalini makaaanà ta kurapyu?” “Oo, Apu,” ananchay summongfat. ");
INSERT INTO ksc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ad inognan Jesus na atacha ad anana, “Siyan màwan chiayun patiyonyuy màwa!” ");
INSERT INTO ksc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ad na sachi, makailacha. Ad finilin Jesus chicha anani, “Achiyu ifagfaka ta sinuman!” ");
INSERT INTO ksc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ngim lummayawcha ad impachamagcha ta atakutaku ta sachi ili. ");
INSERT INTO ksc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Na lummayawan na chachi chuway naaan na kurapcha, inyoy akon uchum an Jesus na osay takuy inumor na farfarayna. ");
INSERT INTO ksc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ad imparyaw Jesus na aran, ad nakaningan sachi larai. Ad siyan naschaaw losan na takuy naarus, wi anancha, “Maid pu innilataù amasna ad asnay Israel!” ");
INSERT INTO ksc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ngim anan chachi Fariseo, “Karobfonganay mangiparyaw ta aran tan na ap-apun na aran na nangatod ta karobfongana.” ");
INSERT INTO ksc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ad kinagkagkaay Jesus na ailiili ta sachi wi nantudtuchu ta sinagoga wi makimkimungancha. Inwarawagnan Mamfaruy Chamag mipangkop ta Manturayan Apudyus, ya inaannan nan-ob-ofot wi sakit na taku. ");
INSERT INTO ksc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ad na nangil-ana ta takuy ad-adchuwan, amod na kaasinan chicha tan kakkaasicha, ya maid akammuchà mampaturungancha tan isuchà pannilu wi maid pu mangayyuwan an chicha. ");
INSERT INTO ksc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ad ananay nan-alig ta disipulusna, “Achun maani ngim ait na man-ani. ");
INSERT INTO ksc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Siyan chawatonyun Apudyus wi ngin-uwa ta annay ani ta umifaun à achù man-ani.” ");
INSERT INTO ksc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Inarus Jesus na disipulusnay nasawaran à chuwa ad inadchana chichà karobfongan à mangiparyaw ta aran ya mampaimfag ta losani karasi wi sakit. ");
INSERT INTO ksc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Anchanayan ngachan na chachi nasawaran à chuway apostolesna: Simon wi ananchay Pedro ya sunudnay Andres; cha Jaime an Juan wi anà Zebedeo; ");
INSERT INTO ksc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ya Felipe an Bartolome, ya Tomas, ya Mateo wi nanchachakup à fukis; Jaime wi anà Alfeo, ya Tadeo, ");
INSERT INTO ksc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ya Simon wi ananchay Mangipapakat, ya Judas Iscariote wi siyan nangififik an Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Sachi ad imfaun Jesus chachi nasawaran à chuway disipulusna wi anana, “Ing-ayu mantudtuchu, ngim achiayu umoy ta ilin na foon à Judio ya uray il-ili ad Samaria. ");
INSERT INTO ksc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ngim ing-ayu ta kailiyanyuy kanà Israel wi isuchà pannilu wi natarà. ");
INSERT INTO ksc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ing-ayu itudtuchu wi chanchani milukin Manturayan Apudyus wi uullayoncha. ");
INSERT INTO ksc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Innadchò na karobfonganyu wi paimfakonyun nasakit, wi uray nafuratung, ipauliyu takuwon na natoy, ya iparyawyu kon aran ta nakafarfaray. Maid pu fayad na karobfongan wi inawatyu, siyan achiyu pafayad na sinumani ifachangyu. ");
INSERT INTO ksc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Achiayu mamfarun à pilak uray siping, ");
INSERT INTO ksc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ya achiayu mampasiing. Achiayu ko mangawit à mansukatanyù luput ya uray sapatus, ya achiayu ko mansur-ud. Tan na iyiwaaranyu chichan mangamung ta masapuryu. ");
INSERT INTO ksc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ad nu chumatong-ayu ta sinumani ili, anaponyu nu sinun maryad wi mammangilin chiayu ta sachin ingkawanyu ingkanà lumayawanyu. ");
INSERT INTO ksc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nu lumnòayu ta osay foroy, chawatonyun finchisyun Apudyus ta chachi nginforoy. ");
INSERT INTO ksc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ad nu pionchay mangiliyon chiayu, tuttuway finchisyunan Apudyus chicha. Ngim nu lawingoncha, man-uwayun finchisyun Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ad nu kaspangalikan awad foroy winnu ilì maid pu mammangilin chiayu ya achicha pu chongron na itudtuchuyu, tòakonyun tapuk ta ikiyu ta lumayawanyù mangakammuwancha wi ikadcha ta machusaancha. ");
INSERT INTO ksc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ifakà an chiayu wi nu chumatong na Padchay Manguisan Apudyus ta taku, sin-umamod na chusan na amaschi nu chusan chachi lawingi takud Sodoma ya Gomorra.” ");
INSERT INTO ksc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ad inturuy Jesus anani, “Chongronyuna! Ifaun-u chiayu ta chachi lawingi taku wi isuayù pannilu wi umoy miyamung ta kaog-ogyati atap wi asu. Siyan masapur tanchaananyun oyyoonchan chiayu, ngim pafaruwonyun oyyoonyun chicha. ");
INSERT INTO ksc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","An-annachanyu tan awad na uchumi taku wi maniliw an chiayu ad icharum chiayu ta kurti, ad impaabchoycha ko chiayu ta sinagogacha. ");
INSERT INTO ksc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ad kapu ta pammatiyun saon, ipasanguchà chiayu ta chachi nangangatuy turay ta maimfistikar-ayu. Ngim sachin wayayuy mangifakan chicha, ya uray chachi foon pù Judio, ta Mamfaruy Chamag mipangkop an saon. ");
INSERT INTO ksc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ad nu maimfistikar-ayu, achiayu machanakan mipangkop ta ifakayu ya isongfatyu, tan na sachi timpu, mipaakammun chiayun ustù ifakayu. ");
INSERT INTO ksc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tan foon pu kà chiayun marpuwan na ifakayu, tan Ispiritun Apudyus wi Amataun mangipaspasmò an chiayu. ");
INSERT INTO ksc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ad na sachi timpu, uray na mansusunud, man-asififikcha ta mapatoy na sunudcha. Ya uray akon man-aama ya man-iina, man-asipinnatoycha. ");
INSERT INTO ksc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ad kuraon chiayu ta losani taku kapu ta pammatiyun saon. Ngim sinumani mangipapati ta pammatina ingkanà anungusna, chichan masaraknifan à ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nu palikatan chiayu ta osay ili, umawid-ayu ta safali ili. Ngim ifakà an chiayu wi achiayu pu makasutup ta annayay pàwà an chiayu ta losan ilid Israel ad mangulinà, saoni namfalin taku.” ");
INSERT INTO ksc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Sachi ad nan-alig à Jesus ta mapasamak an chicha, anana, “Maid pu matudtuchuwan à nangatngatu nu mantudtuchu, ya maid pu ko sanilù nangatngatu nu nginsanilun siya. ");
INSERT INTO ksc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Siyan kapilitan wi sinumani mapasamak ta mantudtuchu, mapasamak ako ta sachi tudtuchuwana. Isun akon sanilu, tan sinumani mapasamak ta nginsanilun siya, sikurachuy mapasamak akon siya. Siyan saoni Apuyu, nu kuraonà ta taku wi ananchay saon à Beelzebub anu wi ap-apun na aran, sinchumallun mangkuraanchan chiayuy disipulus-u.” ");
INSERT INTO ksc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Inturuy Jesus anani, “Achiayu umogyat kuma ta taku. Tan na losani achi pu maila ta sana, mipailà tapin na padcha. Ya losani nitataru ta sana, mallotaw nu chumatong na timpuna. ");
INSERT INTO ksc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Siyan na losani intudtuchù ta aafusanyu, ya intupkà an chiayu, masapur ipagngoryu ta losani taku wi uray ip-awyu. ");
INSERT INTO ksc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ya achiayu ko umogyat ta chachi mamatoy ta long-ag, tan achicha pu makàtoy ta alichodwa. Ngim siya umogyatanyu kumà Apudyus, tan karobfonganay mangifallu ta long-ag ad infierno wi mitapi kon alichodwa. ");
INSERT INTO ksc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Panunutonyun somsomò Apudyus an chiayu, tan uray na sissiwit wi tansu kan nginan na chuwa, maid pu matoy à uray osa nu foon pù iparufus Amatauy Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ad sinchumallù chiayu, tan uray na fuùyu, finilang Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Siyan achiayu kuma umogyat ta sinuman tan napatpatog-ayu an Apudyus nu achuy sissiwit!” ");
INSERT INTO ksc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Inturuy Jesus anani, “Sinumani manàchor ta sangwanan na taku wi saon na Apuna, tàchorà ako siya an Ama ad langit. ");
INSERT INTO ksc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ngim sinumani mangilifak an saon ta sangwanan na taku, ilifak-u kò siya an Ama ad langit.” ");
INSERT INTO ksc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ad anana ko, “Achiyu somsom-on wi ummalì turnuson na losani taku ta luta, tan foon pù turnus na inyalì ngim lifuk. ");
INSERT INTO ksc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tan inyalì na man-asikuraan na man-aama ya man-iina ya uray na man-at-atukanga. ");
INSERT INTO ksc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ad na kangliitani afusur na osay taku, awad ako kay ta faryanna. ");
INSERT INTO ksc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Sinumani mamatpatog ta mangayatana ta chachakkorna nu ayatnan saon, maid pu karobfonganay mifilang à disipulus-u. Isun akon takuy mamatpatog ta mangayatana ta an-ananàna nu ayatnan saon, maid pu ko karobfonganay mifilang à disipulus-u. ");
INSERT INTO ksc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ya sinuman akoy mangwanani sumurut an saon, ngim achina pu maanusan na likatna uray siyan iyatoyna, maid pu ko karobfonganay mifilang à disipulus-u. ");
INSERT INTO ksc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tan na takuy mangan-annad ta fiyagnad asnay luta, matoy ako kay. Ngim na takuy iyaw-awannan fiyagna kapu ta pammatinan saon, maatod an siyan makafiyakanan Apudyus à ing-ingkana.” ");
INSERT INTO ksc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Inturuy Jesus anani, “Sinumani manlispitun chiayu, lispituwonà ako. Ad nu sinun manlispitun saon, lispituwona kon nangifaun an saon. ");
INSERT INTO ksc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ya sinuman akoy manlispitu ta mangitudtuchu ta ukud Apudyus tan siyan iwaarna, makunkunaan à isun na kunkunan na sachi mangitudtuchu. Isun akon sinumani manlispitu ta mamfaruy taku kapu ta kinafaruna, makunkunaan akò isun na kunkunana. ");
INSERT INTO ksc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ya uray sinumani mamainum à mantakaliyong wi chanum ta uray afafaani mamatin saon kapu ta namatiyanan saon, kapilitani makunkunaan.” ");
INSERT INTO ksc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Limpas pun Jesus finilin na chachi nasawaran à chuway disipulusna, lummayaw wi ummoy ta il-ili wi niyachani nantudtuchu. ");
INSERT INTO ksc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na sachi timpu, nifafarud à Juan wi Mamfufunyag. Ad chingngorna pun na ining-ingwan Jesus, imfaunnan uchumi disipulusnà umoy man-im-imus an Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ad inimuschan Jesus, “Ifakam nu sian uullayonni wi impustan Apudyus wi umali, winnu awad safali?” ");
INSERT INTO ksc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ad anan Jesus an chicha, “Mangulin-ayun Juan ifakan chichingngoryu ya inniilayu wi iningwà, ");
INSERT INTO ksc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","wi na nakurap, makailacha, ya na napilay, makachadcharancha, ya na nakollakong, ummimfagcha, ya na naturong, makachongorcha, ya uray na natoy, ummulicha nataku. Ad chachi kakapus, miwarawag an chichan Mamfaruy Chamag. ");
INSERT INTO ksc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ad ifakayu kon siya wi naragragsak chachi foon pù manchuwachuwa ta pammaticha wi saon na finaun Apudyus!” ");
INSERT INTO ksc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Lummayaw pun chachi disipulus Juan, imfakan Jesus ta takun mipangkop an Juan anani, “Na ummayanyu nangil-an an Juan ta iningkawana ta sachi ikaw wi maid pu foroy, sinun ummoyyu innila? Ananyu pun nin nu siyan isù kurun wi chupachupaliyon na fidfid! ");
INSERT INTO ksc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ad nu foon, sinun ummoyyu innila nù? Taku wi nansilup à afaruwan? Ngim foon à nansilup à amaschi tan foroy na Alin ingkawan na nakasilup à amaschi! ");
INSERT INTO ksc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Siyan sinun ummoyyu innila nù? Osay profetan Apudyus? Na katuttuwaana, siya ummoyyu innilan profetan Apudyus. Ngim ifakà an chiayu wi Juan na kangrunaan wi profeta, ");
INSERT INTO ksc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","tan siyan sachi takuy mismun imfakan na niyug-is wi ukud Apudyus wi anana, ‘Awad na osay taku wi ifaun-u unaon nu sia ta umoyna mansakanaon na taku ta chongronchà sia.’ ");
INSERT INTO ksc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ad tuttuwan ifakà an chiayu wi maid pu takù niyanà ad asnay lutà nangatngatu nu Juan wi Mamfufunyag. Ngim na afafaan ta Manturayan Apudyus, mifilang à nangatngatu nu Juan kapu ta pammatinan saon. ");
INSERT INTO ksc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ad nanipud ta chamchamun na nantudtuchuwan Juan, achun maryad wi mangipapilit wi mitapi ta Manturayan Apudyus, ya sinchumallun iningwan na uchum wi maryad wi mangipapilit wi mitapi. ");
INSERT INTO ksc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Na Manturayan Apudyus, siyan puntus na losani imfakan chachi profetas nanipud ta awi ya ingkana ta lummoswaan Juan. Ya siya kon pangkop na Lintog wi inyug-is Moses. ");
INSERT INTO ksc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Siyan nu patiyonyun losani imfakacha, siya maawatanyu wi à Juan, siyà Elias wi nifakay mangulin. ");
INSERT INTO ksc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","“Naingaan-ayu, siyan maawatanyu kuman annay chingngoryu!” ");
INSERT INTO ksc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ad inturuy Jesus anani, “Sinun mangiyisuwà ta taku ta annay sillumunap? Iyalig-u chichà isù an-ananà wi man-in-innangu wi nampoapoaw ta akin-annàcha, ");
INSERT INTO ksc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tinupayyanin kangsa ngim achiayu pu managni! Siyan sinukatannì chomchom ngim achiayu pu makachomchom!’ ");
INSERT INTO ksc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tan na ummaliyan Juan, nallangarangani mangan ya foon pù umminum à fayas, ad inam-amsiw na takù siya wi magwoncha nakafarfaray à siya! ");
INSERT INTO ksc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ngim à saoni namfalin taku, ummaliyà pu ko wi foon pù mallanganà wi mangan, ya makaikainumà à fayas, inamsiwà ako wi magwonà lawotan ya sallimongan! Ya magwonà ako fufurun na manchachakup à fukis ya uchumi managfasur! Ngim uray nu amaschi, mipaila ko kan kinaraing Apudyus, tan na lisortan na oyyoona, siyan manuttuwaan ta kinaustuna.” ");
INSERT INTO ksc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Na taku ta chachi ili wi nangipail-an Jesus ta kaachuwan wi kaskaschaaw, foon pù mamfafawicha ta fasurcha, siyan inomorana chicha anani, ");
INSERT INTO ksc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kakkaasiayuy iCorazin ya iBetsaida! Isag-ayu kakkaasi nu chachi foon pù Judio wi iTiro ya iSidon, tan nu aschin nangipail-à ta kaskaschaaw wi isun na impailà ta iliyu, nanchapchapurcha kuma ya nansilupchà sakù mangipail-ancha ta mamfafawiyancha! ");
INSERT INTO ksc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ngim ifakà an chiayu wi nu chumtong na Padchay Mangkuisan Apudyus ta losani taku, sin-umisag na chusayu nu chusan chachi iTiro ya iSidon! ");
INSERT INTO ksc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ad à chiayuy iCapernaum, namnamayu nin wi machayaw-ayù ikad ad langit, ngim naillachuayu tan mifalluayud infierno kapu ta achiyu pu mamfafawiyan! Tan nu siya kuma nangipail-à ad Sodoma ta kaskaschaaw wi isun na impailà ta iliyu, namfafawicha siya ad kassiya kuma ta sana. ");
INSERT INTO ksc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ngim ifakà an chiayu wi nu chumtong na Padchay Mangkuisan Apudyus ta losani taku, sin-umisag na chusayu nu chusan chachi iSodoma.” ");
INSERT INTO ksc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Sachi ad nalluwarù Jesus anani, “Ama wi Ap-apu ad langit ya asnay luta, manyamanà an sia tan impakaawatnun katuttuwaan mipangkop an saon ta takuy foon pù naachar wi achim pu impakaawat ta nan-araing ya naachar. ");
INSERT INTO ksc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Siyan manyamanà an sia Ama tan siyan piom wi màwa.” ");
INSERT INTO ksc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Inturuy Jesus wi man-ukud, “Impiyar Ama na losani awad an saon. Maid pu uchum à nangakammu ta kina-Apudyus-u nu achi afus à Ama wi Apudyus. Ya maid pu ko uchum à nangakammu an Ama wi Apudyus nu achi afusà wi Anàna ya losani takuy piliyà à mangipakaawatà ta mipangkop an siya.” ");
INSERT INTO ksc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ad anana ko, “Chiayuy losani napoblimaan ya naungar kapu ta likat, umaliayun saon ta man-illongò chiayu. ");
INSERT INTO ksc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ya chongronyun tudtuchù ta acharonyun mipangkop an saon, ta tumarnaayu ya lumangpaw na somsomòyu. Tan à saon, naanusà ya foon à mangwaà à malikatan na taku. ");
INSERT INTO ksc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ya achiayu pu malikatan wi mangwa ta pàwà an chiayu tan foon à nalikat.” ");
INSERT INTO ksc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Na namingsani Safachuy ngingillinan na Judio, nangoycha Jesus ya disipulusna ta pappayaw wi namur-an à wheat wi isù pakoy. Ad kapu ta nafitil na disipulusna, lummapidchà utimancha. ");
INSERT INTO ksc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ad na nangil-an na uchumi Fariseo an chichay nan-utim, ananchan Jesus, “Ilam na annay oyyoon na disipulusnu, surngasingonchan Lintogtau wi mipalit na mallapid ta Safachu!” ");
INSERT INTO ksc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ad sinongfatan Jesus chicha anani, “Achiyu pu nafasan iningwacha David ya fufurunna ta nafitilancha ta awi? ");
INSERT INTO ksc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tan linumnò ta sachi mangngachani foroy Apudyus ad inaranan tinapoy wi nichatun an Apudyus, wi ipalit na Lintog à anoncha tan afus kuman papachì mangan, ad innancha ta fufurunna. ");
INSERT INTO ksc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ad foon pu kò finasayun Lintog wi inyug-is Moses mipangkop ta papachi wi man-iwaar ta Templo? Tan Sinafachuy surngasingoncha kon ngingillinani man-illongan, tan man-iw-iwaarcha ta sachi. Ngim foon pun met à mifilangchì fasurcha. ");
INSERT INTO ksc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ifakà an chiayun katuttuwaan, wi awad ta sanan chiayun osay napatpatog nu sachi Templo. ");
INSERT INTO ksc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Na niyug-is wi ukud Apudyus, anana, ‘Foon pù ichatuchatunyun saon na patkà ngim siya patkà na mangachakuwanyu ta fufurunyu.’” Ad anan ako Jesus, “Nu naawatanyu kuman mining na sachi, achiyu pu kuma pafasuron na anchanay foon à fummasur. ");
INSERT INTO ksc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tan à saon wi namfalin taku, annan karobfongà wi mangifaka ta sinuy màwa ta Safachuy ngingillinan.” ");
INSERT INTO ksc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Sachi ad nangaw-ascha Jesus ummoy ta osay sinagoga wi maar-arusan na Judio. ");
INSERT INTO ksc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ad niyaspur wi iningkaw na osay larai wi naayayong na osay imana. Ya iningkaw akon uchumi man-anaanap à mangicharumanchan Jesus, ad ananchan siya, “Masurngasing na Lintogtau nu paimfakon na sakit ta Safachuy ngingillinan?” ");
INSERT INTO ksc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ad anan Jesus wi summongfat, “Ad nu chiayu, nu awad panniluyù nafituwan ta Safachu, achiyu pu umoy aran? ");
INSERT INTO ksc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ad, napatpatog na taku nu pannilu! Siyan foon à masurngasing na Lintogtau ta mamadngantau ta taku uray Safachuy ngingillinan.” ");
INSERT INTO ksc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Sachi ad anan Jesus ta larai wi naayayong na imana, “Uyachom na imam.” Ad inuyadna, ad ummimfag wi isun na osa. ");
INSERT INTO ksc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ad lummayaw chachi Fariseo ta umoycha puranuwon na mamatayanchan Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Inakammun pu Jesus na mipangkop ta puranucha, lummayaw ta sachi, ya ad-adchuwan na takuy nitun-ud an siya. Ad impaimfagnan losani nasakit, ");
INSERT INTO ksc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ya finilinna chicha ta achicha kuma ifagfakan mipangkop an siya. ");
INSERT INTO ksc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Amaschin iningwana ta tumuttuwaan na sachi impaifakan Apudyus an Isaias wi profeta ta awi, wi anana, ");
INSERT INTO ksc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Annayan chinutukà à fabfaun-u, wi siyan ay-ayatò ya siya kon mangiparagsak an saon. Adchò na Ispiritù an siya ta siyan umoy mangiwarawag ta mamfaruwò ta losani taku ta ailiili. ");
INSERT INTO ksc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Foon à makasukob ya foon à ipoawnan ifakana. Ya foon pu kò makais-isì ta aachuwan na taku. ");
INSERT INTO ksc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Achina pu ko am-amchon na chachi nakapsut na pammaticha. Ya naanus ta chachi mailayusan, ya achina pu iwarang na oy-oyyoona ingkanà mangafak na ustu ta losani lawing. ");
INSERT INTO ksc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ya siya ko afus na namnamaon na losani takù masaraknifancha.” ");
INSERT INTO ksc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sachi ad inyoychan Jesus na osay takuy kinurap ya inumor Satan. Ad imparyaw Jesus na aran, ad makakinga ya makaila chi larai. ");
INSERT INTO ksc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ad naschaaw losan na nangila ta iningwan Jesus, ad anancha, “Mafalini siyan sachi kanà David wi uullayontau?” ");
INSERT INTO ksc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ngim chingngor pun chachi Fariseo na inukud chachi taku, sinongfatancha anani, “Mafalini iparyawnan aran, tan à Beelzebub wi ap-apun na aran, siyan nangatod ta karobfonganay mangiparyaw ta aran.” ");
INSERT INTO ksc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Inaagkammun Jesus na som-osom-oncha, siyan sinongfatana chichà alig, wi anana, “Uray sinuy turay, nu foon à mantitimpuyug na takucha wi kanayuncha mantintinnanung wi mampapatoy, narakan mayam-anancha. Ad nu maid timpuyug na simfaryan winnu sin-umili, wi kanayuncha mantintinnanung wi mansusukob, mansisiyancha. ");
INSERT INTO ksc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Isuna ko nu ananyuy Satan na nangatod ta korobfongà wi mangiparyaw ta aran, tan nu tuttuwachi, wi mantantanungcha wi aran mangkukufat, kapilitani mayam-an na manturayancha! ");
INSERT INTO ksc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Siyan nu ananyuy Beelzebub wi ap-apun na aran na nangatod ta karobfongà wi mangiparyaw ta aran, kattoi siya kon nangatod ta karobfongan chachi fufurunyu wi mangiparyaw ta aran! Tan na oyyoon na fufurunyu, sachi kuman mamanoknok an chiayu wi nangkurang na somsomòyu! ");
INSERT INTO ksc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Siyan foon à Beelzebub na nangatod ta karobfongà wi mangiparyaw ta aran, tan Ispiritun Apudyus na nangatod. Ad siyan mangakammuwanyu wi nar-us chummatong na Manturayan Apudyus ad asnay luta. ");
INSERT INTO ksc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Maid pu makarnò ta foroy na oschorani taku wi mangara ta ochonna nu achina unaon faruchan na oschorani taku achiwot manamsam ta ochonna. ");
INSERT INTO ksc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Sinumani takuy achi pu miyamfuruy an saon, siyan fumusur an saon. Ya sinumani achi pu fumachang an saon ta oyyoò, siyan kumukuran saon. ");
INSERT INTO ksc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Siyan ifakà an chiayu, sinumani fasur na taku wi uray na mangifag-ancha ta lawing mipangkop an Apudyus, mafalini mapakawan. Ngim na fasur wi achi pu mapakawan, na mangifag-an ta lawing mipangkop ta Ispiritun Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Siyan sinumani mangifakà lawing mipangkop an saoni namfalin taku, mafalini mapakawan. Ngim na sinumani mangifakà lawing mipangkop ta Ispiritun Apudyus, achi pu mafalini mapakawan ta sana ya ing-ingkana.” ");
INSERT INTO ksc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Sachi ad nan-alig à Jesus wi anana, “Na mamfaruy imong, mamfaru kon fungana. Ngim na lawingi imong, kapilitani lawing na fungana. Siyan maimatunan na kinafarun na ayu ta fungana. ");
INSERT INTO ksc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Isun akon chiayu, tan milarasin wi isuayù urog! Tan mafalini ifakayun mamfaru wi lawing-ayu? Tan tuttuwa wi na awad ta somsomò siya kon ifakan na tupò. ");
INSERT INTO ksc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Na mamfaruy taku, mamfarun oy-oyyoona tan mamfarun som-osom-ona. Ngim na lawingi taku, lawing akon oy-oyyoona tan lawing na som-osom-ona. ");
INSERT INTO ksc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Mafalini sikurachuwonyu wi nu chumatong na Padchay Mangkuisan Apudyus ta losani taku, masapur wi waschi osa songfatanan Apudyus na losani inukudna wi maid kutùna. ");
INSERT INTO ksc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tan na losani inukudyu, sachin mangifaka ta machusaanyù tapin na padcha winnu foon.” ");
INSERT INTO ksc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Sachi ad na uchumi Fariseo ya mangitudtuchu ta Lintog, ananchan Jesus, “Misturu, umipailaà kaskaschaaw an chianì manuttuwaanni nu sinua.” ");
INSERT INTO ksc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ngim sinongfatan Jesus chicha anani, “Chiayuy taku ta sanay lunap, lawing-ayu tan nan-awichanyù Apudyus. Ad apay mampail-onà à kaskaschaaw? Maid pu uchum à kaskaschaaw à ipailà an chiayu nu achi afus na sachi singyar wi nàwan Jonas wi profeta ta awi. ");
INSERT INTO ksc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tan à Jonas, iningkaw ta fukat na ikan ta unog na turuy padcha ya lafi. Isun ako saoni namfalin taku, wi milofonà ta luta ta unog na turuy padcha. ");
INSERT INTO ksc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nu chumtong na Padchay Makuisan na losani taku, pafasuron chiayu ta chachi tinudtuchuwan Jonas ad Nineve, tan namfafawicha ta nangngorancha ta intudtuchun Jonas. Ngim à chiayu, safali tan uray annaà ta sana wi nangatngatu nu Jonas achiyu pu chongron na itudtuchù an chiayu! ");
INSERT INTO ksc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ad na sachi koy Padchay Makuisan na losani taku, lumoswa kon sachi fufai wi Ali ta awi ad Seba ad pafasuron chiayuy taku ta sanay lunap, tan uray nu ad-adchayuwan na namfiyasiyana, ummoyna ikattò chongron na kinaraing wi intudtuchun Ali Solomon. Ngim à chiayu, uray annaà ta sana wi nangatngatu nu Solomon, achiyu pu chongron na itudtuchù an chiayu!” ");
INSERT INTO ksc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Inturuy Jesus wi nan-alig, anana, “Nu lumayaw na aran ta osay nakafarfaray, umoyna kagkaayon na ikaw wi maid pu fumroy wi man-anap à ingkawana. Ad nu kaspangalikan maid pu ochasana, ");
INSERT INTO ksc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","somsom-ona, ‘Mangulinà ta sachi takuy narpuwà.’ Ad nu mangulin ya ochasanay mamfaru ya nacharus wi maid pu ingkaw, ");
INSERT INTO ksc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","umoy man-ayag à pitù furunna wi sillumawing nu siya, ad mallonogcha losan ta sachi taku. Siyan na nàwa ta sachi taku ta anungusna, sin-umisag nu chamu. Amaschin màwan chiayuy lawingi taku ta sanay lunap.” ");
INSERT INTO ksc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Na sachi nantudtuchuwan Jesus ta chachi taku, chummatong na inan Jesus ya susunudna, ad impaayagchà siya. ");
INSERT INTO ksc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Siyan imfakan na osay taku an Jesus, “Anchanat anun inam ya susunudnud paway, ad paayagchà sia.” ");
INSERT INTO ksc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ad sinongfatan Jesus anani, “Oo, ngim foon pu kà chichan ifilang-ù inà ya susunud-u!” ");
INSERT INTO ksc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ad intuchunan chachi disipulusna ad anana, “Chicha kon ifilang-ù inà ya susunud-u! ");
INSERT INTO ksc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tan sinumani mangwa ta pion Ama ad langit, chicha kon ifilang-ù susunud-u ya iinnà.” ");
INSERT INTO ksc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ad na sachi padcha, lummawà Jesus ta foroy ad ummoy ummachuy ta tarantag na fayfay ad nantudtuchu ta taku. ");
INSERT INTO ksc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ad kapu ta ummad-adchuwan na takuy naarus, nan-atun ummachuy ta fangka ad ummagsad na taku ta tarantag. ");
INSERT INTO ksc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ad achun inyaligna wi intudtuchun chicha. Anana, “Iningkaw na osay taku wi ummoy nawwakawag à fuor. ");
INSERT INTO ksc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ad na nawwakawakana, nanchissun uchum ta charan ad ummon sissiwit innan. ");
INSERT INTO ksc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Na uchumi fuor, nanchissu ta fattufattu wi ait na luta, siyan nallasun summimitancha. ");
INSERT INTO ksc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ngim umminit pun naryawcha ad narangucha tan maid pu lummamutancha. ");
INSERT INTO ksc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Na uchumi fuor, nanchissu ta tartallurung ad tummufucha. Ngim inilung na tarurung. ");
INSERT INTO ksc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ngim na uchumi fuor, nanchissu ta malloma ad tummufucha. Ad namungacha losan wi singkasut na fungan na uchum, ya onompuru ya turumpurun uchum.” ");
INSERT INTO ksc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ad inyanungus Jesus anani, “Naingaan-ayu, siyan somsom-onyu kuman mining na alig-u!” ");
INSERT INTO ksc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Sachi ad ummoy na disipulus Jesus an siya, ad anancha, “Apay pasig alig na pinagtudtuchum an chicha?” ");
INSERT INTO ksc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ad insuplikar Jesus wi anana, “Losani chaan pù maakammuwan wi mipangkop ta Manturayan Apudyus wi nailangitan, afus-ayù mipaakammuwana wi foon pù mipaakammu ta uchum. ");
INSERT INTO ksc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tan na takuy mamati ya awad na maawatancha, machog-achog-an na maawatancha. Ngim na takuy foon pù mamati, maaan na uray aiti naawatana. ");
INSERT INTO ksc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Siyan na pangkop-uy mangusar ta alig ta itudtuchù an chicha, tan uray itotollongcha achicha pu ilasin, ya uray nu chochongroncha, achicha pu atinguron, siyan achicha pu maawatan. ");
INSERT INTO ksc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Siyan chichan tummuttuwaan na sachi imfakan Isaias wi profeta ta awi, wi anana, ‘Uray nu itatanoongcha chongron, achicha pu maawatan. Ad uray nu itotollongcha, achicha pu mailasin. ");
INSERT INTO ksc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tan na anchanayay taku, nar-us tummangkin na urucha, ad isù tinumranchan ingacha ya kinikimitchan atacha. Tan nu foon pù amaschiyoncha, mafalini chongronchan ifakà ya ilanchan ipailà, ya mafalini maawatancha kon ustu, ad siyan kapilitani mansakungchan saon ta pakawanò na fasurcha.’ ");
INSERT INTO ksc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ngim chiayu, nakasat-ayu tan makailasin-ayu ta ilanyu ya maawatanyun chongronyu. ");
INSERT INTO ksc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ad masikurachuyu wi achun profetas ya uchumi naapudyusani taku ta awi wi maryad mangila ta annay iillanyu ya mangngor ta chochongronyu, ngim fooncha pù naparufusan.” ");
INSERT INTO ksc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Sachi ad anana, “Chongronyuna ta maawatanyun mining na alig-u mipangkop ta nawwakawag. ");
INSERT INTO ksc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Na isun na nanchissuwan na fuor ta charan, chichan takuy nangngor ta mipangkop ta Manturayan Apudyus ngim achicha pu atinguron, ad ummoy Satan inallilaw na chingngorcha. ");
INSERT INTO ksc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Na isun na nanchissuwan na fuor ta fattufattu, chichan takuy naragsak wi nangamfuruy ta ukud Apudyus ta nangngorancha. ");
INSERT INTO ksc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ngim foon pù lummamut ta somsomòcha, siyan foon à nanakus. Tan inumchas pun na napoblimaancha ya napalikatancha kapu ta namatiyancha, achicha pu nakaanus siyan inwarangcha. ");
INSERT INTO ksc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Ad na isun na nanchissuwan na fuor ta tartallurung, chichan takuy nangngor ta ukud Apudyus ngim isù nailung na chingngorcha. Tan kapu ta patkanchan mangar-ancha ta masapurcha ta annay mafiyakancha ta sana, ya kapu ko ta pionchay fumaknang, sachin isù nangilung ta somsomòcha an Apudyus, siyan maid pu nafalinan na pammaticha. ");
INSERT INTO ksc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Ad na isun na nanchissuwan na fuor ta malloma, chichan takuy nangngor ta ukud Apudyus ad pinaticha, siyan namungan pammaticha, wi singkasut na imfungan na uchum, ya onompuru ya turumpurun uchum.” ");
INSERT INTO ksc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Sachi ad asin nan-alig à Jesus an chicha. Anana, “Na miyalikan na Manturayan Apudyus, amasna. Nan-osò na osay taku ta lutanà mamfaruy pakoy. ");
INSERT INTO ksc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ngim na sillafiyan wi nasusuyop losan na taku, ummoy na afusurna winalisan à charus na sachi pakoy ad lummayaw. ");
INSERT INTO ksc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ad tummufu pun na mura ad namusfus, mailasin akon charus wi tummufu. ");
INSERT INTO ksc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ad na sasannilun na ngin-uwa, ummoycha imfakan siya, anancha, ‘Apu, maid met nilauk ta inyosònu, ad tamako ta amod na charus?’ ");
INSERT INTO ksc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ad anan na apucha, ‘Awad na afusur wi nangiwalis ta charus.’ Sachi ad inimus chachi sasannilu, ‘Ad piom nu ing-ani charusan?’ ");
INSERT INTO ksc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ngim ananay summongfat, ‘Foon, ta achi mitapi mifakut na pakoy. ");
INSERT INTO ksc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Siyan uray nu ngannuwana. Ad nu timpun na inyàani, ifakà ta man-ani ta unaoncha charusan ad pinsutcha ad singkobcha, achichaot aniyon na pakoy ad inautcha inyoy ta arang-u.’” ");
INSERT INTO ksc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sachi ad asin nan-alig à Jesus wi anana, “Na osay miyalikan na Manturayan Apudyus, amasna. Immuran na osay takun fuor wi mustard ta umana. ");
INSERT INTO ksc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ad uray nu akàitan ta losani fuor, nu chummakor siyan achakran ta losani mura ad namfalin ayu wi manùfutan na sissiwit na pangana.” ");
INSERT INTO ksc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ad asin ako nan-alig à Jesus wi anana, “Na osay miyalikan na Manturayan Apudyus, amasna. Isun na mangitumayan na fufai ta yeast ta sillatay arina ingkanà fumtar losan na arina.” ");
INSERT INTO ksc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Kanayuni alig na usaron Jesus wi mantudtuchu ta takuy naaruarus an siya. ");
INSERT INTO ksc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Amaschin iningwana ta tumuttuwaan na sachi imfakan na profetan Apudyus ta awi, wi anana, “Alig na losani usarò nu awad ifakà an chicha, tan siyan mangitudtuchuwà ta chachi foon pù nipaakammu nanipud ta nàwaan na lufung.” ");
INSERT INTO ksc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tinaynan pu Jesus chachi taku, linumnò ta foroy ad nakarnò akon disipulusnan siya, ad anancha, “Isuplikarnun mining na inyalignuy charus.” ");
INSERT INTO ksc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ad anan Jesus wi nangisuplikar, “Na miyalikan na sachi nangiyosò ta ustuy pakoy, saoni namfalin taku. ");
INSERT INTO ksc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Na minur-ana, siyan annay luta. Ad na chachi ustuy pakoy, chichan ustuy mitapi ta Manturayan Apudyus. Ngim na charus, chichan takuy mitapin Satan. ");
INSERT INTO ksc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ad na sachi afusur wi nangiwalis ta charus, Satan. Ad na miyalig ta inyàani, anungus na padcha ta annay luta. Ad na chachi man-ani, aangheles Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ad na isun na nàwa ta charus wi naugpun ad naskob, amaschi kon màwa ta takù anungus na padcha. ");
INSERT INTO ksc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tan à saoni namfalin taku, ifaun-un aangheles-ù umoy mangarus ta losani takuy mangwà makafasuran na uchum, ya chachi mangwamangwà lawing, ta achicha pu michoka ta Manturayan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ad mifallucha ta apuy wi kumilakilab, ad asiaayom-omcha ya asingangarotngot na fafacha ta kinalikatcha. ");
INSERT INTO ksc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ngim na takun Apudyus, ingkawcha ta Manturayan Amachay Apudyus wi asililinangchay isù init. “Naingaan-ayu, siyan somsom-onyu kuman imfakà!” ");
INSERT INTO ksc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Asin akò Jesus nan-alig wi anana, “Na osay miyalikan na Manturayan Apudyus, isun na kinuruub wi inchasan na osay taku ta osay luta. Ad asinna tinab-unan ta lagsakna ad ummoyna ingngina losan na ùuwana ad pinagkulinna nginin-an na sachi luta. ");
INSERT INTO ksc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ad na osay miyalikan akon Manturayan Apudyus, isun na amusanti wi man-anaanap à ngin-anà man-afaruy perlas. ");
INSERT INTO ksc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Iningkaw ad na osay inchasanay isag napatog, lummayaw ad ingnginanan losani ùuwana ad nginin-anan sachi napatog wi perlas.” ");
INSERT INTO ksc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Inturuy Jesus anani, “Na miyalikan na chachi mitapi ta Manturayan Apudyus, isun na mangitop-aran na manatakufur ta takufurcha ta fayfay ya akarakarasin natakufurani ukachiw. ");
INSERT INTO ksc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ad nu napnun takufur, kuykuyoncha wi iyoy ta tarantag ad piniliyanchan mamfaruy ukachiw ad inigkacha ta iigkaancha. Ngim na lawingi ukachiw, imfallucha. ");
INSERT INTO ksc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Amaschin màwa ta anungus wi padcha, tan umalin aangheles aruson na lawingi taku ta misiyancha ta chachi mamfaruwon Apudyus, ");
INSERT INTO ksc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ad ifallucha chicha ta sachi apuy wi kumilakilab, ad asiaayom-omcha ya asingangarotngot na fafacha.” ");
INSERT INTO ksc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Sachi ad inimus Jesus ta chachi disipulusna, “Ad, maawatanyu losan chachi?” “Oo, naawatanni,” ananchay summongfat. ");
INSERT INTO ksc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ad ananan chicha, “Chachi sikuchi mangitudtuchu ta Lintog, nu patiyonchan intudtuchù mipangkop ta Manturayan Apudyus, miyisucha ta takuy kumplitun ùuwana wi akammunan oyyoonay mangusar ta chachi chachaan wi tinawidna, ad akammuna koy mangusar ta chachi àara.” ");
INSERT INTO ksc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Narpas pu Jesus imfakan anchanay alig, lummayaw ");
INSERT INTO ksc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ad nangulin ta ilina wi Nazaret. Ad na sachi, ummoy nantudtuchu ta sinagoga, ad na takuy naarus, naschaawcha ta nangngoranchan siya. Anancha, “Sinun nangar-ana ta kinaraingna ya karobfonganay mangwà kaskaschaaw? ");
INSERT INTO ksc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Anà chi mangkakaob à siya? Ya Marian inana, wi susunudna cha Jaime ancha Jose an Simon ya Judas? ");
INSERT INTO ksc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ad anchana kon chitaun losani susunudnay fubfufai! Ad sinu kon nangacharana ta amaschi losan nù?” ");
INSERT INTO ksc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ad siyan achicha pu patkon à siya. Sachi ad anan Jesus an chicha, “Tuttuway uray sinuy ili wi umayan na profetan Apudyus, lispituwon na takù siya. Ngim na mismuy kailiyana ya uray na faryanna, achicha pu lispituwon à siya.” ");
INSERT INTO ksc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ad maid in-inon Jesus wi mangwà kaskaschaaw ad ilina, tan achicha pu patkon à siya. ");
INSERT INTO ksc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Na sachi timpu, chingngor Ali Herod na mipangkop an Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ad anana ta chachi mangupisinaona, “Na sachi Jesus, mismuy Juan wi Mamfufunyag wi ummuli nataku, tan sachin karobfonganay mangwà kaskaschaaw.” ");
INSERT INTO ksc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Na sachi Herod, siyan nampatiliw an Juan ya nangipafarud an siya. Amaschin iningwana mipakapun Herodias wi asawan na sunudnay Felipe, ");
INSERT INTO ksc_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","tan imfakafakan Juan an Herod anani, “Maid karobfongam wi mangasawan Herodias!” ");
INSERT INTO ksc_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Siyan pion Herod wi patoyon à siya, ngim ummogyat ta chachi Judio tan na kaachuwan an chicha, pinatichay profetan Apudyus à siya. ");
INSERT INTO ksc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ngim chummatong pun na padchay manayawancha ta niyanaan Herod, nansaran anà Herodias wi fafarasang ta sangwanan na losani nakaragragsak. Ad naragsakan à Herod, ");
INSERT INTO ksc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","siyan insapatana ta sachi fafarasang wi adchonan sinumani chawatonan siya. ");
INSERT INTO ksc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ad kapu ta intudtuchun inana, anana ta Ali, “Adchom an saon na urun Juan wi Mamfufunyag wi mapapallangkan!” ");
INSERT INTO ksc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Summauy à Herod, ngim kapu ta sachi insapatana ya mafain ako ta chachi mangilina, imfakana wi màwan chawatona. ");
INSERT INTO ksc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ad impasiwatnan urun Juan ta fafalluchan. ");
INSERT INTO ksc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ad naichatong ta sachi fafarasang na naparangkan wi urun Juan ad innadchonan inana. ");
INSERT INTO ksc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Sachi ad, ummoy chachi disipulus Juan innaran lachagna ad illofoncha, ad ummoychan Jesus ifakan napasamak. ");
INSERT INTO ksc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Chinamag pu Jesus na napasamak an Juan, lummayaw wi namfangkay ummoy tummalin ta osay lukar wi maid pu taku. Ngim chinamag pun na taku ta ailiilin ummayana, ummun-unudcha nanadcharan ta tarantag na fayfay. ");
INSERT INTO ksc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ad lummogsad pù Jesus ta fangka, innilanan chachi ad-adchuwani taku, ad amod na kaasinan chicha, siyan impaimfagna losan na nasakit an chicha. ");
INSERT INTO ksc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mummaschom pun, umoy na disipulusnan siya ad anancha, “Mummaschom, ad maid pu foroy ad asna. Siyan fuarom chicha ta umoycha mangnginà anoncha ta anchachi il-ili.” ");
INSERT INTO ksc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ngim anan Jesus, “Foon à masapur lumayawcha. Paananyu chicha!” ");
INSERT INTO ksc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ad sinongfatancha anani, “Ngim afus na annay limay tinapoy ya chuway filis à awad!” ");
INSERT INTO ksc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ad anana, “Iyaliyu ta anna.” ");
INSERT INTO ksc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Sachi ad impaachuynan taku ta tappu. Ad innaranan chachi limay tinapoy ya chuway filis, ad nantangad ad langit wi manyaman an Apudyus. Sachi ad pinotpotlànan tinapoy ad impaiwarasna impafillay ta disipulusna ta taku. ");
INSERT INTO ksc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ad losancha nabsug wi nangan. Ad napnun nasawaran à chuway langngay ta nasawar wi nafun-ani chinakup na disipulusna. ");
INSERT INTO ksc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Na filang na lallarai wi nangan, nasuruk à limay lifu wi foon à nifilang na fubfufai ya an-ananà. ");
INSERT INTO ksc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Narpas pun na sachi namaanan Jesus ta chachi taku, nallukanonan disipulusna ta fangka ta umunacha chumormang ta fayfay. Ad pinaryawnan chachi taku. ");
INSERT INTO ksc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Sachi ad nanakachà Jesus ta takudtud wi ummoy tummalin nalluwaru. Ad na sachi lummafi, os-osàan à Jesus ta takudtud. ");
INSERT INTO ksc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ngim na sachi timpu, nangkinawan fangka ta fayfay, ad sachin mamparpalikatancha wi mangiturung ta fangka tan ituptuppiyà na challuyun ya aptiaptiwon na amochi fidfid. ");
INSERT INTO ksc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Machamaan pun, ummoy à Jesus an chicha wi nanadchadcharan ta lafaw na chanum. ");
INSERT INTO ksc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ad na nangil-anchan siya wi manadchadcharan ta lafaw na chanum, ummogyatcha tan anancha pun nu aran, siyan nantukingcha. ");
INSERT INTO ksc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Siyan nakaningà Jesus an chicha, “Achiayu machanakan! Saonna! Achiayu umogyat!” ");
INSERT INTO ksc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ad summongfat à Pedro wi anana, “Apu, nu tuttuway sia, manadcharanonà ako ta lafaw na chanum ta umaliyà an sia!” ");
INSERT INTO ksc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Waynu!” anan Jesus. Ad lummogsad à Pedro ta fangka ad nanadcharan ta lafaw na chanum wi umoy an Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ngim linìnana pun na napigsay fidfid, ummogyat ad cham-anay lumnod, siyan ananay nampoaw, “Apu, fadnganà!” ");
INSERT INTO ksc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Sachi ad chakusi chinòmaan Jesus na imana ad anana, “Apay achiyà piyaron? Apay nanchuwachuwaa?” ");
INSERT INTO ksc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Sachi ad nallukancha ta fangka ad sachi kon kumminoan na fidfid. ");
INSERT INTO ksc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ad losan na disipulus Jesus wi iningkaw ta fangka, chinaychayawchà siya anani, “Tuttuway sian anà Apudyus!” ");
INSERT INTO ksc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nakafallasiwcha pun ta fayfay, chummatongchad Genesaret. ");
INSERT INTO ksc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ad immatunan na takù Jesus, siyan nanchinamag ta ailiili. Ad inyoycha losan na nasakit an siya. ");
INSERT INTO ksc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ad nampangpangngaasichan siya ta iparufusna kuma wi uray agpachan chachi nasakit na pagpag na silupna. Ad na losan nangagpad, ummimfagcha. ");
INSERT INTO ksc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sachi ad chummatong na uchumi Fariseo ya mangitudtuchu ta Lintog wi narpud Jerusalem, ad ummoychan Jesus inimus anani, ");
INSERT INTO ksc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Tamakon disipulusnu, surngasingonchan achawiyantau wi intudtuchun na iyaawi? Tan achicha pu mamfuru nu mangancha!” ");
INSERT INTO ksc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ad summongfat à Jesus anani, “Apay achiyu pu tungparon na Lintog Apudyus wi siya oognanyun sikuchi achawiyanyu? ");
INSERT INTO ksc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tan anan na Lintog Apudyus, ‘Chayawom na amam ya inam,’ ad ‘Sinumani mangarawag ta amana ya inana, masapur mapatoy.’ ");
INSERT INTO ksc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Sachin ustuy nilintog, ngim iwalinyuchi tan itudtuchuyu wi uray nu awad iturung na taku ta amana ya inana, ngim nu ananay ‘Para an Apudyus,’ ");
INSERT INTO ksc_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","foon anù masapur chinayawnan amana ya inana wi fumachang an chicha. Ngim na mangwaan ta amaschi, siya iwalinyun lintog Apudyus, ad siya oognanyun achawiyanyu. ");
INSERT INTO ksc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Akinpapatiayu! Ad tuttawan sachi imfakan Apudyus ta awi mipangkop an chiayu, wi inyug-is Isaias wi profeta, wi anana. ");
INSERT INTO ksc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Na anchanayay taku, tupòcha kan manayawanchan saon, wi maid pu ustù somsomòchan saon. ");
INSERT INTO ksc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Siyan maid silfin na manayawanchan saon, tan siya itudtuchuchan achawiyancha wi ing-ingwan na taku ad ananchay filin-u nu!’” ");
INSERT INTO ksc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Sachi ad impaachanin Jesus na chachi ad-adchuwani taku, ad anana, “Inaagyu chongron ta maawatanyu! ");
INSERT INTO ksc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Foon pù siya mamparwing ta taku an Apudyus na lumnò ta tupòna wi anona, ngim siya mangiparwing na lumawa ta tupòna wi ifungangayna.” ");
INSERT INTO ksc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Napannos ad, ummoy na disipulusnan siya ad anancha, “Kattoi nasukatan na chachi Fariseo ta nangngorancha ta imfakam!” ");
INSERT INTO ksc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ad nan-alig à Jesus wi summongfat, wi anana, “Losani mura wi foon pù Amà ad langit na nangimura, mafakutcha losan. ");
INSERT INTO ksc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Siyan achiayu machanakan an chicha, tan isuchà nakurap wi mangipuyut ta isuchay nakurap! Tan nu ipuyut na nakurap na isuna koy kurap, kapilitani losancha mafituwan.” ");
INSERT INTO ksc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ad anan Pedro, “Isuplikarnun mining chi inyalignu.” ");
INSERT INTO ksc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ad anan Jesus, “Achiyu pu ko maawatan? ");
INSERT INTO ksc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Achiyu pu maawatan wi na losani lumnò ta tupò na taku ad inùmunna, umoy ta fuwangna ad nangaw-as? ");
INSERT INTO ksc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ngim na ifungangayna, narpuchi ta somsomòna ad siyan makafasuran na taku an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tan na somsomò siyan marpuwan na losani lawing, isun na pumatoy, managchakas ya mangwà amaschi wi linuruku, ya isun akon akaw, churun ya manturtulli ta taku. ");
INSERT INTO ksc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Chichan mangiparwing ta taku an Apudyus wi foon pù siya mangiparwing na achicha pu mamfuruwan wi mangan.” ");
INSERT INTO ksc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Lummayaw à Jesus ta sachi ili ad ummoy ta sakupon Tiro ya Sidon. ");
INSERT INTO ksc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ad iningkaw na osay fufai wi iCanaan wi foon à Judio, wi ummoy an Jesus. Ad ananay nangip-aw, “Apu! Kanà David! Kaasiyanà, tan maparpalikatan na anàuy fafarasang, tan nakafarfaray.” ");
INSERT INTO ksc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ngim foon pù summongfat à Jesus an siya. Ad ummoy na disipulusnan siya inàarù anani, “Uray nu oyyoom na chawatona, ta umayaw, tan sumitong à mituntun-ud!” ");
INSERT INTO ksc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ad anan Jesus wi summongfat, “Oo, ngim nifaunà yakay à para ta chachi kanà Israel wi isuchà natarà wi pannilu.” ");
INSERT INTO ksc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ngim ummoy ako kan sachi fufai nampalintumong ta sangwanan Jesus ad anana, “Apu, fadnganà!” ");
INSERT INTO ksc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ad nan-alig à Jesus wi anana, “Foon pù mafalin wi ipaan na anon na anà ta asu.” ");
INSERT INTO ksc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ad anan ako chi fufai wi summongfat, “Tuttuwanat, Apu, ngim mafalini anon akon asu na chachà na anà.” ");
INSERT INTO ksc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Siyan anan Jesus an siya, “Tuttuway napigsan pammatim! Siyan màwan sanati chawatom.” Ad na sachi anayun, ummimfag na fafarasangna. ");
INSERT INTO ksc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Lummayaw pù Jesus, nangoy ta tarantag na fayfay wi Galilea ad nanakacha ta osay takudtud ad ummachuy. ");
INSERT INTO ksc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ad nitun-ud akon ad-adchuwani taku wi nangiyoy ta fufurunchay nan-ob-ofot na sakitcha wi wachawad na napilay, naayayong, nakurap, naumor ya uchumi nasakit, ad impasanguchan Jesus. Ad impaimfagna chicha losan. ");
INSERT INTO ksc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Siyan naschaaw losan chachi naaamung, tan innilachay makachadcharan na napilay ya naayayong, ya makailan nakurap, ya kumingan chachi naumor. Siyan losancha chinayaw à Apudyus wi siyan ummapuwan chachi kanà Israel. ");
INSERT INTO ksc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sachi ad inayakan Jesus na disipulusna ad anana, “Maachakuwanà ta anchanay taku tan atlun padchacha ta sana wi ingkaw an chitau, ad naamin na faruncha. Ngim lawingò wi mamaryaw an chicha wi achicha pu mangan, tan awni ad nu masikingancha ta charan.” ");
INSERT INTO ksc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ad inimus na disipulusnan siya, “Ngim sinun mangar-antaù ipaantau ta annay kinaachucha, wi maid pu foforoy ta annay ikaw?” ");
INSERT INTO ksc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ad inimus Jesus an chicha, “Am-an na tinapoy wi awad an chiayu?” “Pitu kay, ya aiti filis wi man-akàit,” ananchay summongfat. ");
INSERT INTO ksc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Sachi ad impaachuy Jesus losan na taku ta luta, ");
INSERT INTO ksc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ad innaranan pituy tinapoy ya chachi filis, ad nanyaman an Apudyus. Sachi ad pinotpotlàna impaiwaras ta disipulusna ta taku. ");
INSERT INTO ksc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ad losancha nabsug wi nangan. Ad pituy langngay na naamin napnu ta nafun-an wi chinakup na disipulusna. ");
INSERT INTO ksc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Na filang na lallarai wi nangan, ummoy à opat lifu wi foon à nifilang na fubfufai ya an-ananà. ");
INSERT INTO ksc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Sachi ad pinaryaw Jesus na taku achiwot mamfangka wi umoy ta sakup Magadan. ");
INSERT INTO ksc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Iningkaw na uchumi Fariseo ya Saduceo wi ummoy an Jesus ad pachasonchay sikapan à siya. Siyan mampàwaonchà siyà kaskaschaaw à manuttuwaancha wi Apudyus na nangifaun an siya. ");
INSERT INTO ksc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ngim inyalig Jesus wi summongfat, anana, “Nu masiut na init, ilasinyuy mamfarun tarun à fikat nu manlidlidchaka ad langit. ");
INSERT INTO ksc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ad nu figfikat wi ilanyuy manlidlidchaka ya manliblibfuu, ilasinyuy umuchan. Apay mafalini ilasinyun singyar na kinafarun na padcha ngim achiayu pu makailasin ta isingyar Apudyus ta anchanayay màmàwa ta chokanninay timpu! ");
INSERT INTO ksc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kattoi lawing na taku ta annay lunap, tan nan-awichanchà Apudyus! Mampàwaayù kaskaschaaw à mangil-anyu ta kinasasaad-u, ngim maid pu mipailan chiayù singyar nu achi afus na isun na nàwan Jonas ta awi.” Sachi ad lummayaw à Jesus wi tinaynanà chicha. ");
INSERT INTO ksc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nanchormangcha pu Jesus ta fayfay, naliwatan na disipulusna wi namfarun. ");
INSERT INTO ksc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ad anan Jesus an chicha, “Tanchaananyun yeast na chachi Fariseo ya Saduceo.” ");
INSERT INTO ksc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ad anan na disipulusnay nan-uukud, “Imfakana nin yakay tan maid inawittaù tinapoy.” ");
INSERT INTO ksc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ngim inakammun Jesus na uukuchoncha, siyan anana, “Tayuko man-is-isian na kinamaid na tinapoytau? Chaanyu pù saon piyaron? ");
INSERT INTO ksc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Chaanyu pu mailasin na karobfongà? Naliwatanyun limay tinapoy wi impaan-u ta chachi takuy nasuruk à limay lifu? Am-an na langngay na chinakupyuy nafun-an? ");
INSERT INTO ksc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Isun akon pituy tinapoy wi impaan-u ta chachi takuy nasuruk à opat lifu, am-an akon langngay na chinakupyuy nafun-an? ");
INSERT INTO ksc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Apay achiyu pu naawatan wi foon à tinapoy na inug-ugkud-u an chiayu? Tan na imfakà, tanchaananyun sachi miyalig à yeast na Fariseo ya Saduceo!” ");
INSERT INTO ksc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ad na sachi, naawatan chachi disipulusna wi foon pù yeast wi milauk ta tinapoy na ug-ugkuchona, tan siya itudtuchù an chiayu na tanchaananyun sachi tudtuchun na Fariseo ya Saduceo wi ilaukcha ta ustuy mitudtuchu. ");
INSERT INTO ksc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nichaumcha pu Jesus ta sakup Cesarea Filipos, inimusna ta disipulusna, “Sinun mammammoan na takun saoni namfalin taku?” ");
INSERT INTO ksc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ad anancha, “Anan na uchum wi sia nù Juan wi Mamfufunyag wi ummuli nataku. Ad anan akon uchum wi sia nù Elias wi nangulin, ad na uchum, ananchay sià Jeremias winnu safali wi profeta.” ");
INSERT INTO ksc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Sachi ad inimusnan chicha, “Chiayu ngay, sinun manomsom-anyu?” ");
INSERT INTO ksc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ad summongfat à Simon Pedro, anana, “Sian Cristu wi impustan Apudyus wi umali manturay, wi sian anà na mafifiyyag wi Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ad anan Jesus an siya, “Siay Simon wi anà Juan, maragsak-a tan foon pù takun nangipaakammun sia ta sanat, ngim Ama wi awad ad langit na nangipaspasmò an sia. ");
INSERT INTO ksc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Siyan na ifakà an sia, Pedro: miyalig-à fatu, tan na sanati imfakam wi mipangkop an saon, sachin isù panad tan sachin masapur mamfatayan na losani mamatin saon. Ad maid pu makaafak an chicha, wi uray na matayan. ");
INSERT INTO ksc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ad ipiyar-un sian turfì na Manturayan Apudyus. Siyan sinumani ipalitnud asnay luta, mipalit ako ad langit. Ad na iparufusnud asnay luta, miparufus ako ad langit.” ");
INSERT INTO ksc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sachi ad finilin Jesus na disipulusna ta achicha ifagfaka wi siyan Cristu wi impustan Apudyus wi umali. ");
INSERT INTO ksc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nanipud ta sachi, illukin Jesus wi mangifaka ta disipulusnan mipangkop ta màwan siya. Anana, “Masapur inyà ad Jerusalem ad palikatanà ta chachi mamangpanguwon na Judio ya pangpangun na papachi ya chachi mangitudtuchu ta Lintog. Ad mapatoyà, ngim na miyatluy padcha umuliyà mataku.” ");
INSERT INTO ksc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Sachi ad intalin Pedro à Jesus ad inomoranà siya anani, “Apu, foon pu kumà iparufus Apudyus wi màwanat an sia!” ");
INSERT INTO ksc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ad nansakung à Jesus an Pedro wi anana, “Lumayaw-a, Satan! Tan sian manipod ta pion Apudyus wi màwan saon. Tan na somsomònu, foon à narpun Apudyus ngim somsomò yakan taku.” ");
INSERT INTO ksc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sachi ad anan Jesus ta disipulusna, “Sinumani maryad wi sumurut an saon, masapur foon pù makaka ta fiyagnad asnay luta, tan masapur oyyoonan piò, uray sachin iyatoyna. ");
INSERT INTO ksc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tan sinumani makaka ta fiyagnad asnay luta, matoy ako kay. Ngim nu sinun foon à makaka ta fiyagna kapu ta pammatinan saon, uray matoy maatod an siyan fiyag wi mannaynayun. ");
INSERT INTO ksc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tan sinun silfin na mangin-uwaan na osay taku ta losani awad ta luta nu ifallun Apudyus à siya? Tan foon à umanay na kinafaknang na takù ifayadna ta makafiyakana an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tan à saoni namfalin taku, mangulinà à tapin na padcha wi mifurun na aangheles-u ya sumilingà ta kinafarun Ama wi Apudyus. Ad sachin mangadchà ta sufalit na losani iningwan na taku. ");
INSERT INTO ksc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tuttuwan ifakà an chiayu, wi awad na uchum an chiayu ta sana wi asififiyag wi mangilan saoni namfalin taku nu umaliyà manturay.” ");
INSERT INTO ksc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Lummaus ad na omomi padcha, inayakan Jesus cha Pedro ya Jaime an Juan wi mansunud ad inyoyna chicha intalin ta osay filig. ");
INSERT INTO ksc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ad na nangiil-anchan Jesus ta sachi, nafaliwan na itchurana, wi na fosarna summiling wi isù init, ad na silupna summilisiling wi putilaan. ");
INSERT INTO ksc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Sachi ad innilacha cha Moses an Elias wi makaug-ugkud an Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ad nan-ukud akò Pedro wi ananan Jesus, “Apu, mamfaru tan annaani! Tan nu piom, mangwaanì turù sikay à mamfubfuwaanyu ancha Moses ya Elias.” ");
INSERT INTO ksc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Na sachi man-ukuukuchan Pedro, ninapnapan na sumilingi lifuù chicha. Ad chingngorchan kinga wi narpu ta sachi lifuu, wi anana, “Sanan Anàu wi ay-ayatò, wi mangiparagsak an saon. Chongronyù siya!” ");
INSERT INTO ksc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Na nangngoran na disipulus ta sachi kinga, nallùfubcha kapu ta amochi ogyatcha. ");
INSERT INTO ksc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Sachi ad ummoy Jesus inagpachan à chicha wi anana, “Lumigwat-ayu. Achiayu umogyat!” ");
INSERT INTO ksc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ad nantangadcha pun afus à Jesus à iningkaw. ");
INSERT INTO ksc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Na nan-oskancha ta filig, finilin Jesus chicha anani, “Achiyu ifagfaka na innilayu, ingkanà saoni namfalin taku umuliyà mataku.” ");
INSERT INTO ksc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Sachi ad inimus na disipulus Jesus, “Tamako anan na chachi mangitudtuchu ta Lintog wi masapur umuna nu umalì Elias?” ");
INSERT INTO ksc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ad anan Jesus wi summongfat, “Oo, tuttuway umunà Elias umali ta isakanan umaliyà. ");
INSERT INTO ksc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ngim nar-us ummalì Elias, ad foon à illasin na takù siya, siyan iningwachan pionchay oyyoon an siya. Ad amaschi kon oyyoonchan saoni namfalin taku.” ");
INSERT INTO ksc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ad na sachi, naawatan na disipulusna wi siya inug-ugkud Jesus na mipangkop an Juan wi Mamfufunyag. ");
INSERT INTO ksc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nangulincha pun ta iningkawan na ad-adchuwani taku, ummoy an Jesus na osay larai nampalintumong ta sangwanana, ");
INSERT INTO ksc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ad anana, “Apu, kaasiyam na anàuy fafaru wi nakartoy! Amod na maparpalikatana tan kankanayuni mampatug ta apuy winnu chanum nu kìnaonachi. ");
INSERT INTO ksc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ad inyoy-u ta disipulusnu ngim achicha pu makaaan ta sakitna.” ");
INSERT INTO ksc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ad summongfat à Jesus anani, “Chiayuy taku ta sana, ummakon pammatiyu! Naina kon iniingkawà ya anus-un chiayu ya achiayu pu mamati! Iyaliyun sanati anà ta anna!” ");
INSERT INTO ksc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Sachi ad inomoran Jesus na aran wi farfaray na anà, ad lummayaw na aran, ad na sachi anayun ummimfag chi anà. ");
INSERT INTO ksc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ummaw-awni ad ummoy na disipulus Jesus an siya inyag-agkaaw ad anancha, “Tamako ta achiani pu nakaparyaw ta sachi aran?” ");
INSERT INTO ksc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ad anan Jesus, “Achiayu pun tan kurang na pammatiyu. Tuttuwan ifakà an chiayu, wi nu awad pammatiyù uray ait wi isun na akàit na akàitani fuor wi mustard, uray ananyu ta annayay filig, ‘Man-atun-a ta annat!’ ad tuttuway man-atun, tan maid achi mafalin an chiayu! ");
INSERT INTO ksc_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ngim na amaschi wi aran, maid pu makaparyaw nu achi afus na mallangan wi mangan ya malluwaru an Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Naaruscha pu Jesus ta disipulusna ad Galilea, ananan chicha, “Saoni namfalin taku, mipurangà ta takuy ");
INSERT INTO ksc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","mamatoy an saon, ngim na miyatluy padcha umuliyà mataku.” Ad summauy na disipulusna ta nangngorancha. ");
INSERT INTO ksc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Chummatongcha pu Jesus ta disipulusna ad Capernaum, ummoy an Pedro na manchachakup à fukis wi mifayad ta Templo, ad inimusna, “Foon à mamfayfayad na misturuyu ta fukis ta Templo?” ");
INSERT INTO ksc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Mamfayfayad met!” anan Pedro wi summongfat. Ad na linumnoan Pedro ta foroy, anan Jesus an siya, “Simon, sinun somsomònu? Sinun mamfukison na Alid asnay luta, sikuchi takuna winnu chachi kaili wi narpù safali wi ili?” ");
INSERT INTO ksc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Chachi kaili wi narpù safali wi ili,” anan Pedro. Ad anan ako Jesus, “Oo, tuttuwa, siyan foon pu kumà mamfayad na sikuchi takud asna. ");
INSERT INTO ksc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ngim uray foon à kailitau, achifali uray nu fayachantau ta achi pu lumawing na somsomò na anchanay taku. Siyan ing-a mamungwit ta anchi fayfay, ad na umunay màna, taangom na tupòna ad awad na pilak wi umanay à ifukista. Ad aram ya ummoynu finayachan na fukista.” ");
INSERT INTO ksc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Na sachi timpu, inimus na disipulus an Jesus anani, “Sinun angatuwan ta takuy iturayan Apudyus?” ");
INSERT INTO ksc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Sachi ad inayakan Jesus na osay anà impasangun chicha, ");
INSERT INTO ksc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ad anana, “Tuttuwan ifakà, wi masapur faliwanyun somsomòyu ta miyisu ta somsomò na annayay anà wi maid pu somsom-onà ngumatuwana. Tan nu achiyu pun, kattoi achi pu mafalini mitapiayu ta Manturayan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tan na angatuwani taku ta Manturayan Apudyus, siyan mangipafafa ta long-agna wi isun na annay anà.” ");
INSERT INTO ksc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Inturuy Jesus anani, “Sinumani takuy patkanan nafafay taku wi isun na annay anà mipakapu ta pammatinan saon, patkana kò saon. ");
INSERT INTO ksc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ngim sinumani mangwà makafasuran na isun na anchanay an-ananà wi mamatin saon ta man-awichanchà saon, kattoi amod na machusaanà tapin na padcha, tan un-unnoy na matàchan na fakangnà chakoran à fatu ta sana ad nitub-ung ta fayfay. ");
INSERT INTO ksc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kakkaasin taku ta annay luta wi maawis ad nan-awichanchà Apudyus! Ngim sikud ako kay wi màwan amaschi. Ngim sinkumaasi na takuy nangawis à man-awichan na asintatakuna an Apudyus! ");
INSERT INTO ksc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Nu kaspangalikan imayu winnu ikiyun mangwà man-awichanyun Apudyus, lampokanyu ad imfalluyu! Tan un-unnoy na uray pukur winnu pilay wi makafiyag an Apudyus, nu wachawad na ima ya iki wi mifallu ta sachi mannaynayuni apuy à ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ad nu kaspangalikan atayun mangwà man-awichanyun Apudyus, kulikuram ad imfalluyu! Tan un-unnoy na furching wi makafiyag an Apudyus nu wachawad na ata wi mifallu ta sachi infierno wi mannaynayuni apuy à ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Siyan man-annad-ayu ta achiyu amsiwon na uray osay nafafay taku isun na anchanayay an-ananà. Tan tuttuway na aangheles ad langit wi mangayyuwan an chicha, kanayuncha iingkaw ta sangwanan Ama ad langit. ");
INSERT INTO ksc_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tan à saoni namfalin taku, ummaliyà ad asnay luta ta saraknifà na managfasur ta achicha mifallu ad infierno.” ");
INSERT INTO ksc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Sachi ad nan-alig à Jesus wi anana, “Sinun somsomòyù oyyoon na osay taku, wi singkasut na panniluna ad natarà na osa? Sikurachuy taynanan siyampuru ya siyam ta purag ad ummoyna inanap na sachi os-osàan wi natarà. ");
INSERT INTO ksc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ad nu ochasana, tuttuway chakchakor na lagsakna ta sachi osa nu lagsakna ta chachi siyampuru ya siyam wi foon pù natarà. ");
INSERT INTO ksc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Isun akon Amataud langit tan lawingonan awad osà mifallu wi uray na kafafaan wi taku.” ");
INSERT INTO ksc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Inturuy Jesus anani, “Nu awad furunnù nakafasur an sia, ing-a maos-osa makaukud an siya ad imfakam na iningwana. Ngim masapur afus-ayu kay wi chuwa wi maid uchum. Ad nu chongronan imfakam, mamfaru tan nangulinom na ustuy somsomòna. ");
INSERT INTO ksc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ngim nu kaspangalikan achina pu chongron na imfakam, man-ayag-à osa winnu chuwà mamfurunnu ta asin-ayu umoy ta chichan manàchor ta katuttuwaan. ");
INSERT INTO ksc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ngim nu kaspangalikan achina pu ko kay chongron chiayu, ifakayu ta losani mamati ta maam-amunganyu ta fumachangcha ko. Ad nu kassiyay achina pu chongron na losani fufurunyu, ifilangyù siyà isù achi pu mamati winnu isun na manchachakup à fukis wi nakuruk. ");
INSERT INTO ksc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ifakà an chiayun katuttuwaan, wi sinumani ipalityud asnay luta, mipalit ako ad langit. Ad sinumani iparufusyud asnay luta, miparufus ako ad langit. ");
INSERT INTO ksc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ad na osay ifakà an chiayu, nu awad chawatonyun Apudyus wi uray chuwaayu kay, nu mantimpuyukonyun somsomòyu wi manchawat, oyyoon Ama wi nailangitan na pionyuy chawaton. ");
INSERT INTO ksc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tan uray nu afus na chuwa winnu turun maamung mipakapu ta pammatichan saon, awachà akoy makaamung an chicha.” ");
INSERT INTO ksc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Sachi ad inimus Pedro an Jesus anani, “Apu, mangam-an na mamakawanà ta fumasur wi furun-un saon? Mangampituwon?” ");
INSERT INTO ksc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ad anan Jesus wi summongfat, “Foon à mangampitu kay, tan mangampituy puru na pitu. ");
INSERT INTO ksc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Tan amasnan Manturayan Apudyus ad langit, wi na miyalikana, na osay Ali simsimmòna wi manutar ta am-amung na utang na sasanniluna. ");
INSERT INTO ksc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","“Illukina pun wi mantutar, inyoychan siyan osay saniluna wi nakautang an siyà alifulifu. ");
INSERT INTO ksc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ngim kapu ta achi pu makafayad ta utangna, siyan imfakan chi Ali wi masapur mainginacha losan wi simfaryan à mansaniluwon na uchum, ya maingina kon losani ùuwacha, à mifayad ta utangna. ");
INSERT INTO ksc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ngim nampalintumong na sachi sanilu ta sangwanan na Ali wi nampangpangngaasin siya anani, ‘Apu, mangaasia ta wayaanà wi man-anap à ifayad-u ta losani utang-u!’ ");
INSERT INTO ksc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ad kinaasiyan na Alì siya, siyan pinakawanna kay à siya ta losani utangna. ");
INSERT INTO ksc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ngim lummawa pun chi sanilu, inafotnan osay chokanay sanilu wi nakautang an siyà singkasut yakay. Ad chinòmaana ad illukinay koslon à siya wi anana, ‘Fayacham na losani utangnu!’ ");
INSERT INTO ksc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ad nampalintumong akon sachi chokanay sanilu wi nampangpangngaasi wi anana, ‘Mangaasia ta wayaanà wi man-anap à ifayad-u, ad fayachà met laing!’ ");
INSERT INTO ksc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ngim achina pu kinaasiyan à siya tan impafarudna ingkana nù fayachana losan na utangna. ");
INSERT INTO ksc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Innilan pun na uchumi sanilun iningwana, lummawing na somsomòcha ad ummoycha ta Ali impilit na losani iningwana. ");
INSERT INTO ksc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ad impaayag na Ali chi sanilu, ad ananan siya, ‘Kattoi lawing-a, wi maid silfin na kinasanilum! Tan à saon, pinakawan-un losani utangnun saon tan nangkakkaasia. ");
INSERT INTO ksc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ad apay achim pu kinaasiyan na chokami sanilù isun na nangaasiyà an sia?’ ");
INSERT INTO ksc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ad ummog-ot chi Ali ad impaifarudnà siya ta mapalikatan ingkanà fayachanan losani utangna.” ");
INSERT INTO ksc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Sachi ad inyanungus Jesus na ukudna anani, “Amaschin oyyoon Ama wi nailangitan an chiayu nu achiyu pu kattò pakawanon na fufurunyu.” ");
INSERT INTO ksc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Narpas pun Jesus intudtuchun losan chachi, lummayaw ta sachi provinsiyay Galilea ad nanchormangcha ta chawwang wi Jordan wi umoy ta sakup Judea. ");
INSERT INTO ksc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ad ad-adchuwan na takuy nitun-ud an siya, ad impaimfagnan losani nasakit. ");
INSERT INTO ksc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ad ummoy akon uchumi Fariseo an siya wi mamachas manikap an siya, wi anancha, “Iparufus na Lintogtau nu ichangan na larain asawana wi uray farangnan lasunna?” ");
INSERT INTO ksc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ad sinongfatan Jesus chicha anani, “Achiyu pu finasan niyug-is wi ukud Apudyus ta awi, wi ananay na chamu wi nangwaana ta taku, iningwanan larai ya fufai. ");
INSERT INTO ksc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ad anan ako Apudyus, ‘Kapu ta sachi, taynan na larain chakorna ad nitipun ta asawana, ad sachin mamfalinanchà osay long-ag.’ ");
INSERT INTO ksc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ad manipud ta sachi, foon à chuwan long-agcha tan nantipunchà osay long-ag. Siyan maid pu karobfongan na taku wi mangichang ta sinumani nantipunon Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ad inimus akon Fariseo, “Siyan tan-akon nù Moses imparufus, tan illintogna met wi na larai, nu mangiyug-is à kasuratan à mangichangana ta asawana, mafalini ichangana?” ");
INSERT INTO ksc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ad anan ako Jesus, “Na chamun na lufung, maid amaschi, ngim kapu ta kinatangkinyu imparufus Moses na mangichanganyu ta asawayu. ");
INSERT INTO ksc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ngim na ifakà an chiayu, sinumani larai wi mangichang ta asawana, wi foon à kapu ta nakachagchakasan na sachi fufai na mangichanganan siya, makafasur à siyà chagchakas nu mangasawà safalì fufai.” ");
INSERT INTO ksc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ad anan na disipulusna, “Siyan nu amasnat na man-asawa, un-unnoy nù nu achitau pu mangasawa.” ");
INSERT INTO ksc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ngim anan Jesus wi summongfat, “Ngim achi pu losan na taku makàwa ta amasnat, tan afus chachi mangipiyaran Apudyus à mangwa. ");
INSERT INTO ksc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tan nangkarakarasin lasun na achin pu na larai mangasaw-an. Tan na uchum, nisisikud an chicha, ad na uchum, kapu ta nakapuncha. Ad na uchum, anusanchay achi pu mangasawa ta asikasuwonchay mangiwarawag ta mipangkop ta Manturayan Apudyus. Siyan sinumani makaanus ta anchanaya, oyyoona kuma.” ");
INSERT INTO ksc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Sachi ad iningkaw na uchumi nangiyoy ta an-ananàchan Jesus ta paipataycha kuman imanan chicha ya iluwaruwanà chicha, ngim ingkimaun na disipulusna chicha. ");
INSERT INTO ksc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ngim anan Jesus, “Masapur iparufusyun umaliyan na an-ananà an saon, ya achiyu ipalit, tan piyaronchà saon, ad isun an chicha na afusi mitapi ta Manturayan Apudyus ad langit.” ");
INSERT INTO ksc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Sachi ad impataynan imana ta chachi an-ananà achiwot lumayaw. ");
INSERT INTO ksc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Na osay padcha, iningkaw na osay larai wi ummoy an Jesus, ad anana, “Misturu, sinun mafarù oyyoò ta makafiyakà à mannaynayun an Apudyus?” ");
INSERT INTO ksc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ad inimus Jesus, “Tam-ako imuson na mipangkop ta mamfaru? Tan os-osàan na mamfaru wi siyà Apudyus. Siyan nu piomi makafiyag an siyà ing-ingkana, oyyoom na losani illintogna.” ");
INSERT INTO ksc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ad inimusna, “Sinun filinnay masapur oyyoò?” Ad anan ako Jesus, “Achia pumatoy à taku, Achia mamufai, Achia man-akaw, Achim istikuwan na foon à tuttuwà, ");
INSERT INTO ksc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Masapur lispituwom na amam ya inam, ya Ay-ayatom na asintatakum à isun na mangay-ayatam ta long-agnu.” ");
INSERT INTO ksc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ad summongfat chi larai wi anana, “Tinungpar-u losan, ad sinu kon kurang-u?” ");
INSERT INTO ksc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ad anan Jesus, “Nu piomi maid mangkurangam, ing-a inginan losani ùuwam ad inadchom na nginana ta kakapus, ta langit na maugpunan na kinafaknangnu. Ad umalia mitun-ud an saon.” ");
INSERT INTO ksc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ngim na nangngoran chi larai ta sachi, lummayaw wi nansasàuy tan amod na faknangna. ");
INSERT INTO ksc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Sachi ad anan Jesus ta disipulusna, “Tuttuwan ifakà an chiayu, wi isag nalikat na mitapiyan na fafaknang ta Manturayan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tan mallanlanuy na lumnoan na kamar ta afut na tanud nu mitapiyan na faknang ta Manturayan Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Na nangngoran na disipulusna ta sachi, naschaawcha ad anancha, “Ad sinu nù na mafalini masaraknifan?” ");
INSERT INTO ksc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ad intotollong Jesus chicha ad anana, “Nu taku kan mangwa ta makafiyakanchan Apudyus, tuttuway achi pu mafalin. Ngim nu Apudyus na mangwa, mafalin tan maid achi pu mafalin an siya.” ");
INSERT INTO ksc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Sachi ad nan-ukud à Pedro wi anana, “Chiani ngay, tinaynannin losani ùuwanì summurutannin sia. Ad makunkunaan-ani?” ");
INSERT INTO ksc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ad anan Jesus, “Tuttuwan ifakà an chiayu, wi saoni namfalin taku, nu chumtong na tumùchuwà wi manturay à tapin na padcha, tumùchuayu ko ta chachi nasawaran à chuway aachuyan wi makaturay an saon. Ad chiayu kon manguis ta losani kanà chachi nasawaran à chuway anà Israel. ");
INSERT INTO ksc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ad sinumani nanaynan ta foroyna, susunudna, amana, inana, an-ananàna, ya lutana kapu ta summurutanan saon, ad-achun maatod an siya nu sachi tinaynana. Ad foon pu kò afuschi, tan makafiyag an Apudyus à ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ngim na osa koy ifakà, adchuwan na isù nangatu ta sana wi fumafà tapin na padcha. Ya chachi isù nafafa ta sana, ngumatuchà tapin na padcha.” ");
INSERT INTO ksc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ad anan Jesus wi nan-alig, “Na Manturayan Apudyus, isun na osay takuy achun murana. Siyan naafigkat ummoy nanangchan. ");
INSERT INTO ksc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Iningkaw ad na inchasana, nakaturag an chicha wi adchonan tangchan ta osay padcha, ad ummoyna nan-iwaaron chicha. ");
INSERT INTO ksc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Chummikas pun asin ako ummoy ta maaruarusan na taku ad innilanan uchumi maag-agsad wi maid oyyooncha. ");
INSERT INTO ksc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ad ananan chicha, ‘Ing-ayu ko makaiwaar ta murà ta tangchanà chiayù ustuustuy tangchanyu.’ Ad ummoycha. ");
INSERT INTO ksc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Mummamatù pun, asin ako ummoy nanangchan à uchum, ad isun akon iningwana ta mantalliing. ");
INSERT INTO ksc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Ar-arkaw pu ko, ummoy ako ta sachi maaruarusan na taku ad inchasana kon maag-agsad ad anana kon chicha, ‘Tayuko taraon na padcha wi arkawonyu kay iingkaw ta annà otom?’ ");
INSERT INTO ksc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ad anancha, ‘Maid nanangchan an chiani.’ Ad ananan chicha, ‘Ing-ayu nù makaiwaar ta chachi man-iwaarò.’ ");
INSERT INTO ksc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Mummaschom pun, anan na nginluta ta kapatasna, ‘Arusom na nan-iiwaar ta fayacham na tangchancha, ad ilukim ta nangudchi wi chummatong ingkana ta chachi naafigkat.’ ");
INSERT INTO ksc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Siyan chachi nangiluki ta ar-arkaw, natangchananchà tangchan ta osay padcha. ");
INSERT INTO ksc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Siyan nachauman ad chachi naafigkat, anancha pun nu ad-achun tangchancha ngim natangchanancha ko kay à tangchan ta osay padcha. ");
INSERT INTO ksc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Siyan ngummayngayutngutcha ta nangawatancha ta tangchancha, ad nallilicha ta nginluta wi anancha, ");
INSERT INTO ksc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Tamako ta miyisun tangchanni ta chachi adchatong wi osa kay uras na ummiwaarancha ad pinadchani wi ummiwaiwaar ta amochi init?’ ");
INSERT INTO ksc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ad anan na nginluta ta osan chicha, ‘Furun, foon pù linukù chiayu tan siya met na nantuturakantau. ");
INSERT INTO ksc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Siyan aranyun na tangchanyu ad lumayaw-ayu. Tan piò wi man-iisuwon na tangchanyu ta chachi adchatong. ");
INSERT INTO ksc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Siya ipalityun amasnay oyyoò wi mangastu ta pilak-u? Winnu maapos-ayu tan mancharaà?’” ");
INSERT INTO ksc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ad inyanungus Jesus anani, “Na chachi isù nafafa ta sana, chichan mangatù tapin na padcha. Ad chachi isù nangatu ta sana, fumafachà tapin na padcha.” ");
INSERT INTO ksc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Na nanadchadcharanancha Jesus wi umoy ad Jerusalem, intalin Jesus na disipulusnay nasawaran à chuwa, ad ananan chicha, ");
INSERT INTO ksc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Chongronyuna! Anna puni intaud Jerusalem. Ad sachin mantiliwanchan saoni namfalin taku. Ad mipurangà ta chachi pangpangun na papachi ya chachi mangitudtuchu ta Lintog, ad masintinsiyaà à mapatoy. ");
INSERT INTO ksc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ad mipurangà ako ta chachi foon pù Judio, ad am-amangonà ya abchoyonà akon chicha ya ilansaà ta kros ta matoyà. Ngim na miyatluy padcha, umuliyà mataku.” ");
INSERT INTO ksc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sachi ad ummoy na asawan Zebedeo ya anànay chuwa an Jesus. Ad nampalintumong chi fufai ta sangwanan Jesus wi mangifaka ta pionay chawaton. ");
INSERT INTO ksc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ad anan Jesus an siya, “Sinun ifakam?” Ad ananay summongfat, “Nu chumtong na manturayam, mafalin wi makaachuy na annay chuway anàun sia, wi ipaachuynun osa ta apot ta chiwawannu ya osa ta apot ta chuwikim?” ");
INSERT INTO ksc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ad anan Jesus wi summongfat an chichay mansunud, “Foon à maawatanyun chawatonyu. Makaanus-ayu ta likat wi isun na likat wi mipachas an saon?” “Oo, mafalinni,” ananchay summongfat. ");
INSERT INTO ksc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ad anan ako Jesus, “Tuttuway maanusanyun isun na liglikat-u. Ngim foon à saon na mampili nu sinun tumùchu ta apot ta chiwawan-u ya chuwikì, tan Aman nangisakana ta aachuyan à para ta chachi mangadchana.” ");
INSERT INTO ksc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Chingngor pun chachi simpuruy disipulus na mipangkop ta chawaton chi chuway mansunud, ummog-otcha an chicha. ");
INSERT INTO ksc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Siyan inarus Jesus chicha losan ad tinudtuchuwana chicha anani, “Akammuyu wi na turay ad asnay luta, amod na pinagmancharcha ta chachi iturayancha. Ya uray chachi nan-angatu, mancharoncha kon chachi asintatakucha. ");
INSERT INTO ksc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ngim foon kumà mafalin na amaschin chiayu. Tan nu sinun maryad an chiayu wi ngumatu, masapur mamfalinonan long-agnà mansanilu ta fufurunna. ");
INSERT INTO ksc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ad nu awad ako maryad an chiayù mamfalin angatuwan, masapur mamfalinonan long-agnà isù afafaan wi sanilun na uchum. ");
INSERT INTO ksc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Isun saoni namfalin taku, foon à ummaliyà ad asnay luta ta pafachangà ta taku, ngim ummaliyà ta fadngà chicha. Ya ummaliyà akò matoy à subfut na fasur na takuy ad-adchuwan.” ");
INSERT INTO ksc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Na lummayawancha Jesus ya disipulusna ad Jerico, ad-adchuwan na nitun-ud an chicha. ");
INSERT INTO ksc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ad niyaspur wi iningkaw na chuway nakurap wi umaachuy ta ikid na sachi arsa wi ayoncha. Ad chingngorcha pun wi Jesus na lumaus, illukichay nampoaw anani, “Siay kanà David! Kaasiyan chiani!” ");
INSERT INTO ksc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ngim inomoran na takù chicha ta kuminòcha, ngim inam-amodcha impauy anani, “Apu! Kanà David! Kaasiyan chiani!” ");
INSERT INTO ksc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Sachi ad ummillong à Jesus ad ananan chicha, “Sinun pionyù oyyoò an chiayu?” ");
INSERT INTO ksc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ad anancha, “Apu, makailaani kuma!” ");
INSERT INTO ksc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ad kinaasiyan Jesus chicha ad inagpachanan atacha, ad chakusi naaan na kurapcha, ad nitun-udchan siya. ");
INSERT INTO ksc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Chanchanicha pu Jesus ad Jerusalem, chin-umanchan filig wi Olivo, wi achanid Betfage wi ili. Ad na sachi, impaunan Jesus na chuway disipulusna, wi anana, ");
INSERT INTO ksc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Umunaayu umoy ta anchi ili ta chomang ad sachin mangchasanyu ta osay nipupungod wi afayu wi naayyufuwan. Obfachonyu ad inyaliyusna. ");
INSERT INTO ksc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ad nu awad mangwanani tayukonnat obfachon, ifakayu wi masapur na Apuyu, ad man-itay-una.” ");
INSERT INTO ksc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nàwan sachì tumuttuwaan na imfakan na osay profeta ta awi, wi anana, ");
INSERT INTO ksc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ifakayu ta takud Jerusalem wi Sion, Ilanyu! Annat wi marungay na Aliyu! Imfafanan long-agna wi nangaabfayu ta ayyufun na afayu.” ");
INSERT INTO ksc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Sachi ad ummoy chachi chuway disipulus ad iningwachan imfakan Jesus an chicha. ");
INSERT INTO ksc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ad inchatongchan sachi afayu wi naayyufuwan, ad inyap-apchan kunsurcha ta ochog na afayu ad nangafayù Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ad ad-adchuwan akon takuy nangiyap-ap ta kunsurcha ta arsa wi ayona, ta arsa wi ayona, ad na uchum ako, summongpatchà pingin na allilison ad inyap-apcha ko ta arsa. ");
INSERT INTO ksc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ad na losani takuy umunauna ya mituntun-ud an Jesus, asipapauycha anani, “Chayawontaun annay Kanà David! Chayawontaù siyay ummali wi narpun Apudyus! Chayawontaù Apudyus wi Angatuwan!” ");
INSERT INTO ksc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ad na chummatngan Jesus ad Jerusalem, ummoy losan na taku ilan wi nan-asiimuscha, “Sinu kon sanat?” ");
INSERT INTO ksc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ad summongfat chachi nituntun-ud wi anancha, “Siyà Jesus wi profetan Apudyus, wi narpud Nazaret ad Galilea.” ");
INSERT INTO ksc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Sachi ad ummoy à Jesus ta Templo ad imparyawnan losani mallakraku ya mangngingina wi iningkaw. Ad inaminna linitwad na lamisaan chachi mansusukat à pilak ya aachuyan chachi mallakrakù karupati. ");
INSERT INTO ksc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ad ananan chicha, “Niyug-is na ukud Apudyus wi, ‘Na Templò, mausar à luruwwaruwan.’ Ngim annay namfalinonyù mallukuwanyu ta asintatakuyu!” ");
INSERT INTO ksc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Sachi ad linumnò chachi nan-akurap ya nan-apilay ta Templo wi mampaila an Jesus, ad impaimfagnà chicha. ");
INSERT INTO ksc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ad chachi pangpangun na papachi ya mangitudtuchu ta Lintog, ummog-otcha ta nangil-ancha ta iningwan Jesus wi kaskaschaaw, ya na nangngorancha ta ipaupauy na an-ananà ta charò na Templo anani, “Chayawontaun annay Kanà David!” ");
INSERT INTO ksc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ad ananchan Jesus, “Achim pu chochongron na ipaupauy na anchanay an-ananà?” “Chochongrò met!” anan Jesus. Ad anana ko, “Achiyu pu finasan sachi niyug-is wi ukud Apudyus wi anana, ‘Tinudtuchuwam na anchanay an-ananà wi manaychayaw an siyà ustuustu.’” ");
INSERT INTO ksc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sachi ad tinaynan Jesus chicha wi lummayaw wi ummoy ummiyan ad Betania. ");
INSERT INTO ksc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nafikat pun wi mangulinan Jesus ad Jerusalem, kinìnanan fitilna. ");
INSERT INTO ksc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ad innilanan osay imong wi ikus ta ikid na arsa, ad ummoyna innila nu awad fokasna. Ngim maid, afus na karumfuwani tufu. Sachi ad anana ta sachi imong, “Achia pu asin mamungà ing-ingkana!” Ad nachisan narangun sachi imong. ");
INSERT INTO ksc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ad na nangil-an na disipulusna, naschaawcha ad anancha, “In-inona koy nachisan yakay narangu?” ");
INSERT INTO ksc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ad anan Jesus, “Tuttuwan ifakà an chiayu, wi nu Apudyus yakan piyaronyu wi maid chuwachuwayu, mafalini makàwaayu ko ta isun na iningwà ta annayay imongi ikus. Ad foon pù afuschi tan uray ifakayu ta anchi filig, ‘Man-atun-a ta anchi fayfay,’ ad tuttuway màwa. ");
INSERT INTO ksc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tan nu afus à Apudyus à piyaronyu, adchona losan na iluwaruyu.” ");
INSERT INTO ksc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ad nangulin à Jesus ta Templo. Ad na nantudtuchuwana, ummoy an siyan chachi pangpangun na papachi ya chachi namangpanguwon na Judio. Ad inimuscha, “Sinun karobfongam wi mangwa ta amaschi? Ad sinun nangatod ta karobfongam wi mangwaschi?” ");
INSERT INTO ksc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ad sinongfatan Jesus chicha anani, “Achì ifakan nangatod ta karobfongà wi mangwa ta amaschi nu masongfatanyu yan na imusò an chiayu. ");
INSERT INTO ksc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Sinun narpuwan na karobfongan Juan wi mamfunyag? Narpun Apudyus winnu taku?” Ad nan-uupngacha anani, “Sinun ifakatau? Nu anantauy ‘Narpun Apudyus,’ anana kon chitauy ‘Tayukon nù achi pinatì Juan?’ ");
INSERT INTO ksc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ngim nu anantauy ‘Narpu ta taku,’ kaog-ogyat tan awad nin oyyoon na takun chitau, tan patiyoncha losan wi profetà Juan.” ");
INSERT INTO ksc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Siyan ananchay summongfat, “Taw-an, maid akammuni.” Ad anana kon chicha, “Siyan nu amasnat, achì pu ko ifakan chiayu nu sinun narpuwan na karobfongà wi mangwa ta oy-oyyoò.” ");
INSERT INTO ksc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Sachi ad nan-alig à Jesus wi anana, “Sinun somsomòyu ta annaya? Iningkaw na osay taku wi chuwan anànay lallarai. Ad anana ta panguru, ‘Anà, ing-a man-iwaar ta tarun ta sana.’ ");
INSERT INTO ksc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ngim ananay summongfat, ‘Lawingò,’ tan natangkin. Ngim napapannos ad namfafawi wò umoy. ");
INSERT INTO ksc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ad ummoy akon sachi ama imfaka ta uchichi ta umoy ako man-iwaar. Ad anan chi uchichi, ‘Oo, inyà Ama.’ Ngim foon à ummoy. ");
INSERT INTO ksc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Sinun nanungpar ta pàwan na ama ta chachi chuwa?” Ad summongfatcha anani, “Panguru.” Ad linawakan Jesus chicha anani, “Tuttuwan ifakà an chiayu wi na lawingi takuy isun chachi manchachakup à fukis ya chachi puta, umun-unacha nu chiayu wi mitapi ta Manturayan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tan ummalin pu Juan wi Mamfufunyag, impaakammunan ustuy oyyoonyu ta mifilang-ayù mamfaruy taku, ngim achiyu pu tinuttuwà siya. Ngim chachi manchachakup à fukis ya puta, tinuttuwachà siya. Ngim uray nu iniilayun namfaliwancha, achiayu pu namfafawi à manuttuwaanyu kon siya.” ");
INSERT INTO ksc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Sachi ad anan Jesus, “Chongronyun annayay alig-u. Iningkaw na osay taku wi nammurà grapes. Ad inaradna linìwos, ad ummafut ako ta fatu à mamosposana ta fungana nu fayasoncha. Ad impàwana kon tànangani sikay à ingkawan na mamanfantay. Sachi ad impàwana kò fuwa ta safali wi taku ad lummayaw wi ummoy namfiyasi. ");
INSERT INTO ksc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Timpun ad na inyàapit, imfaunnan sasanniluna ta umoycha makafuwa. ");
INSERT INTO ksc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ngim chachi man-afang ta lutana, chinòmaanchan sasanniluna ad inabchoychan osa, ya pinatoychan osa, ad fininfintugchan osa. ");
INSERT INTO ksc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ad asin ako namfaun chi nginlutà ad-achu ta sasannilu nu chachi chamu. Ad iningwacha kon isun na iningwacha ta ummuna. ");
INSERT INTO ksc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ad na anungusna, imfaunnan mismuy anàna tan anana pun nu singnanchà siya tan anàna. ");
INSERT INTO ksc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ngim intap pun chachi nangwà fuwa na anànay marungay, nan-uupngacha anani, ‘Anchiyan anànay mangilàsun ta annay luta. Siyan patoyontau ta man-uwataun làsunna!’ ");
INSERT INTO ksc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ad chinòmaanchà siya ad inyoycha ta lasin na arad ad pinatoycha. ");
INSERT INTO ksc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Siyan nu chumatong akon nginluta, sinun somsomòyù oyyoona ta chachi man-afang?” ");
INSERT INTO ksc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ad ananchay summongfat, “Sikurachuy patoyona chachi arwingan ad ipàwana ta uchumi nalimpiw wi mangatod ta ustuy fuwana.” ");
INSERT INTO ksc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ad anan Jesus akon chicha, “Ad achiyu pu finasan niyug-is wi ukud Apudyus wi mipangkop ta annaya? Tan anana, ‘Na fatuy inchulin na mangkakaob wi ananchay maid silfina, sachin nàwà apatkan wi mipon-ad. À Apudyus na nangwa ta annaya, ad isag kaskaschaaw à maila!’ ");
INSERT INTO ksc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Siyan ifakà an chiayu, wi foon à chiayuy Judio na iturayan Apudyus, tan isukatna chiayù safali wi mamtog ta pàwana. ");
INSERT INTO ksc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ad na mipangkop ako ta sachi fatu, nu awad maodchag an siya, mapmaptod. Ad nu awad maodchakan ta sachi fatu, matampù wi isù chapur.” ");
INSERT INTO ksc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Na nangngoran na pangpangun na papachi ya Fariseo ta alig Jesus, naawatancha wi chichan inyaligna, ");
INSERT INTO ksc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","siyan pionchay chòmaan à siya. Ngim achicha pun tan ummogyatcha ta chachi takuy ad-adchuwan, tan imfilangchà Jesus à profetan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ad asin akò Jesus nan-alig wi nantudtuchu ta taku. Anana, ");
INSERT INTO ksc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Na Manturayan Apudyus, miyalig ta osay Ali wi nangisakana ta lagsak wi mangkasaran na anànay fafaru. ");
INSERT INTO ksc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ad imfaunnan sasannilunà umoy mangayag ta chachi takuy nar-usna inimfitar. Ngim lawingonchay umoy makakasar! ");
INSERT INTO ksc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ad namfaun ako ta sasannilunay uchum wi ananay namilin, ‘Ing-ayu ifaka ta chachi naimfitar wi nisakanan maan. Impapartì na fakà ya man-apoponar wi ayyufu, siyan umalicha kuma makakasar!’ ");
INSERT INTO ksc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ngim chachi naimfitar, achicha pu atinguron. Ad ummoy na osa ta tarunna, ya ummoy akon osa ta tinchaanna, ");
INSERT INTO ksc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ad na uchum ako, impachòmacha chachi nafaun wi sasanniluna ad imfafaincha ya pinatoycha chicha. ");
INSERT INTO ksc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Chingngor pun Ali na nànàwa, ummog-ot ad imfaunnan susurchachuna ta umoycha patoyon chachi pummatoy, ad impaskobna kon ilicha. ");
INSERT INTO ksc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Sachi ad anan na Ali ta sasannilunay uchum, ‘Losan nisakanan annay lagsak-u, ngim chachi naimfitar maid pu karobfongancha makaragsak. ");
INSERT INTO ksc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Siyan ing-ayu ta ar-arsa ad imfitaronyun sinumani takuy ilanyu.’ ");
INSERT INTO ksc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ad ummoy chachi sasanniluna ta ar-arsa nan-imfitar ta losani takuy uray lawing ya mamfaru, siyan napnun sachi mangkasaranchà taku. ");
INSERT INTO ksc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ad ummoy na Ali ilan na takuy naarus, ad nan-il-anan osay taku wi foon à nan-usar à ustuy silup wi usaron na umoy makakasar. ");
INSERT INTO ksc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ad inimus na Ali an siya anani, ‘Furun, taako umalisna makakasar wi foon pù nan-usar-à silup na umoy makakasar?’ Ngim akikinnò chi taku. ");
INSERT INTO ksc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Sachi ad imfakan Ali ta sasanniluna, ‘Faruchonyun imana ya ikina ad imfalluyud lasin wi mamfulingot, ta sachin umakaakana ya ngumarotngotan na fafana ta likatna.’” ");
INSERT INTO ksc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sachi ad inanungusan Jesus na ukudna anani, “Ad-adchuwan na naimfitar, ngim ait na mapiliyan.” ");
INSERT INTO ksc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Sachi ad lummawa chachi Fariseo ta umoycha man-uukud à manikapanchan Jesus ta awad mangicharumanchan siya. ");
INSERT INTO ksc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Siyan ummifauncha ta uchumi pasurutcha wi Fariseo ya uchumi takun Herod ta umoycha ifakan Jesus, “Misturu, akammuni wi maid turtulliyam à taku, ya itudtuchum akon katuttuwaan wi pion Apudyus wi pàwa ta taku, ya foon akò atingurom na sinuy ukuchon na takun sia, tan maid pu laksikom à taku wi uray sinun kinasasaadcha. ");
INSERT INTO ksc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Siyan ifakam nù nu sinun somsomònu wi mipangkop ta annaya. Surngasingontaun Lintogtauy Judio nu mamfayadtaù fukis ta Ali ad Roma, winnu foon?” ");
INSERT INTO ksc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ngim inaagkammun Jesus na sikapcha, siyan ananan chicha, “Chiayuy akinpapati, taayuko sumiksikkap an saon? ");
INSERT INTO ksc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Umipailaayù parata wi ifayadyu ta fukis!” Ad ummipailachà osà parata. ");
INSERT INTO ksc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ad inimus Jesus an chicha, “Sinun nginfosar ya nginngachan ta anna?” ");
INSERT INTO ksc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Ali Cesar,” ananchay summongfat. Ad anan Jesus an chicha, “Siyan nu amasnat, adchonyun Cesar na uwana. Ngim ilanyu ko ta adchonyun Apudyus losan na para an siya.” ");
INSERT INTO ksc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Na nangngorancha ta sachi, natataagcha ad lummayawcha. ");
INSERT INTO ksc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Na sachi padcha, ummoy na uchumi Saduceo an Jesus. Na Saduceo, foon pù patiyoncha wi umuli matakun natoy. ");
INSERT INTO ksc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ad ananchan siya, “Misturu, intudtuchun Moses wi nu nangasawan osay larai ad natoyi maid anàna, masapur asaw-on na sunudnan nafaru ta umanàcha kumà mifilang à anà na sachi natoyi sunudna. ");
INSERT INTO ksc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nu kaspangalikan awad pitù lallaraì mansusunud, ad nangasawan panguru, ad natoyi maid anàcha. Ad inasawan miyagwa na nafaru. ");
INSERT INTO ksc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ngim amaschi kon napasamak an siya. Ya isun akon napasamak ta miyatlu ingkanà losan chachi pitu. ");
INSERT INTO ksc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ad na anungusna natoy akon fufai. ");
INSERT INTO ksc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Siyan nu umuli matakun natoy, sinun ustuy ngin-asawa ta fufai nù? Tan losancha inasawà siya!” ");
INSERT INTO ksc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ad sinongfatan Jesus chicha anani, “Oo, ngim naillachuayu! Tan achiyu pu maawatan na niyug-is wi ukud Apudyus ya mannakafalinna. ");
INSERT INTO ksc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tan nu umulin taku mataku, maid man-as-asawa tan mamfalincha isù aangheles ad langit. ");
INSERT INTO ksc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ad na mipangkop ako ta umuliyan na taku matakuwan, achiyu pu finasan sachi niyug-is wi ukud Apudyus an chiayu? Anana, ");
INSERT INTO ksc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Saon à Apudyus wi chaychayawoncha Abraham, Isaac ya Jacob.’ Ad sachin manuttuwaana wi uray natoycha Abraham ta sachi timpu, asififiyagchad langit wi manaychayaw an Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Na nangngoran chachi ad-adchuwani naarus ta sachi, naschaawcha ta itudtuchuna. ");
INSERT INTO ksc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Chingngor pun na Fariseo wi pinakinò Jesus chachi Saduceo, losancha nantitipun ummoy an Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ad na osan chicha wi mangitudtuchu ta Lintog, inyagsadnay manikap an Jesus wi anana, ");
INSERT INTO ksc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Misturu, sinun apatkan ta Lintogtau?” ");
INSERT INTO ksc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ad sinongfatan Jesus anani, “Masapur ay-ayatom à Apudyus ta patingkan na somsomònu ya losani oy-oyyoom ya losani kinaraingnu. ");
INSERT INTO ksc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Sanan angatuwani filin Apudyus ya apatkan. ");
INSERT INTO ksc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ad na misùnub, isuna ko tan ananay masapur ay-ayatom na asintatakum à isun na mangayatam ta long-agnu. ");
INSERT INTO ksc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Na anchanay chuway Lintog Apudyus, chichan namfasaran na losani lintog wi inyug-is Moses ya intudtuchun chachi profetas.” ");
INSERT INTO ksc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Na sachi naarusan na Fariseo, inimus Jesus an chicha, ");
INSERT INTO ksc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Sinun somsomòyu mipangkop an Cristu wi impustan Apudyus wi ipaalina? Sinun nginkanà an siya?” Ad ananchay summongfat, “Kanà David.” ");
INSERT INTO ksc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“Oo, siya,” anan Jesus, “ngim nu amasnat, tan-ako David anani Cristun Apuna nù? Tan na inukud David wi impaspasmò na Ispiritun Apudyus, anana, ");
INSERT INTO ksc_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘À Apudyus wi Apu, anana ta Apù: Tumùchua ta apot ta chiwawan-u ingkanà ipaafak-un losani afusurnu.’ ");
INSERT INTO ksc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Siyan nu inawakan David à Cristù Apuna, in-inon David wi nginkanà akon Cristu?” ");
INSERT INTO ksc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ngim maid pu makasongfat an Jesus. Siyan nanipud ta sachi timpu, maid pu makaturod asin mamachas wi manikap an siya. ");
INSERT INTO ksc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Sachi ad anan Jesus ta chachi takuy naaarus ya disipulusna, ");
INSERT INTO ksc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Na chachi mangitudtuchu ta Lintog ya chachi Fariseo, chichan napiyar à mangitudtuchu ta Lintog Apudyus wi inyug-is Moses. ");
INSERT INTO ksc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Siyan masapur patkonyun losani itudtuchucha, ngim achiyu pàpàwatan na oy-oyyooncha, tan achicha pu oyyoon na itudtuchucha. ");
INSERT INTO ksc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Isù ipafuudcha ta takun chagsonani amod à mafuud, ad achicha pù ait fadngan chicha. ");
INSERT INTO ksc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ya losani oy-oyyooncha, oyyooncha kay à mangipàpail-ancha ta taku ta machayawcha. Tan iyug-ischan uchumi ukud Apudyus à man-achakkor ad ifofodcha ta ichaycha ya tàraycha! Ya mallagragkoyloy akon silupcha! ");
INSERT INTO ksc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ya pipioncha koy chichan machayaw ta sinuy lagsak, ya chichan umachuy ta afaruwani aachuyan ta sinagoga. ");
INSERT INTO ksc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ya pioncha koy malispitu ta aallusan na taku, ya pioncha koy maawakan à ‘Misturu.’ ");
INSERT INTO ksc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ngim à chiayu, achiyu iparufus na maawakanyu ‘Misturu,’ tan man-iisuayuy mansusunud, ya os-osàan yakan Misturuyu tan afusà. ");
INSERT INTO ksc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Achiyu ko awakan na sinumani takù ‘Ama’ ta annay luta, tan os-osàan na Amatau wi awad ad langit. ");
INSERT INTO ksc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Achiyu ko iparufus wi maawakan-ayù ‘Apu,’ tan saon yakan Apuyu wi saon na Cristu wi impustan Apudyus wi umali manturay. ");
INSERT INTO ksc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ad na angatuwan an chiayu, masapur siya kon tumuturung an chiayu. ");
INSERT INTO ksc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ya sinumani mangipangatu ta long-agna, fumafa. Ngim sinumani mangipafafa ta long-agna, ngumatu.” ");
INSERT INTO ksc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","An inturuy Jesus anani, “Kakkaasiayu, chiayuy Fariseo ya mangitudtuchu ta Lintog. Akinpapatiayu! Tan tipochonyun mitapiyan na taku ta Manturayan Apudyus, tan na achiyu pu mitapiyan, chooyu lingalingon chachi man-anap à mitapiyancha! ");
INSERT INTO ksc_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Kakkaasiayu, chiayuy Fariseo ya mangitudtuchu ta Lintog. Akinpapatiayu! Tayuko siksikkapan na anchanay nafarù mangar-anyu ta ùuwacha, ad malluwaruayù anchuanchù manab-unyu ta oy-oyyoonyu. Siyan kapu ta sachi, maam-amod na machusaanyu. ");
INSERT INTO ksc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kakkaasiayu, chiayuy Fariseo ya mangitudtuchu ta Lintog. Akinpapatiayu! Tan fallasiwonyun fayfay ya kagkagkaayonyun losani luta ta awad awisonyù uray os-osàan à mandisipulusyu. Ad nu naawisyu, inam-amodyu wò akon kachusaana nu kachusaanyu. ");
INSERT INTO ksc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kakkaasiayu, chiayuy isù puyut wi nakurap! Isun na itudtuchuyu wi, ‘Nu Templon isapatan na mansapata, achifali uray nu achina pu oyyoon na insapatana, ngim nu mansapata ta sachi falituk wi awad ta Templo, masapur nu wi oyyoona tan fasurna nu nu achina pun.’ ");
INSERT INTO ksc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tuttuway natingtingangan-ayu wi nakurap! Tan apay napatpatkonyun falituk nu Templo wi nampasantu ta sachi falituk? ");
INSERT INTO ksc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ya itudtuchuyu koy nu altar na isapatan na mansapata, achifali uray nu achina pu oyyoon na insapatana, ngim nu mansapata ta michatun ta altar, masapur nu wi oyyoonan insapatana tan fasurna nu nu achina pun! ");
INSERT INTO ksc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tuttuway maid akammuyu! Tan apay napatpatkonyun michatun nu altar wi mampapatog ta sachi michatun an Apudyus? ");
INSERT INTO ksc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Siyan na ifakà an chiayu, sinumani mangisapata ta altar, foon pù afus na sachì insapatana tan insapatana kon losani ingkaw wi nichatun. ");
INSERT INTO ksc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Isun akon Templo. Nu sachin isapatan na taku, foon pu kà Templon insapatana tan insapatana kò Apudyus wi iingkaw. ");
INSERT INTO ksc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ad nu langit na isapatan na taku, insapatana kon manturayan Apudyus ya à Apudyus ako wi turay ta sachi. ");
INSERT INTO ksc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kakkaasiayu, chiayuy Fariseo ya mangitudtuchu ta Lintog. Akinpapatiayu! Tan mangatod-ayù pagkapurun na charusi mamparamnaw ta maan, ngim inwalinyun napatpatog wi itudtuchun na lintog, wi masapur malimpiw na oyyoonyu, ya masapur achakuwanyun asintatakuyu, ya masapur ako wi mapipiyyar-ayu. Amaschin masapur oyyoonyu kuma ya achiyu ko lausan na uchum. ");
INSERT INTO ksc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“Tuttuway isuayù nakurap wi mangipuyut ta uchum! Naannad-ayu wi manungpar ta chachi foon à napatoki lintog ngim naturod-ayuy achi pu manungpar ta chachi napatpatog!” ");
INSERT INTO ksc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kakkaasiayu, chiayuy Fariseo ya mangitudtuchu ta Lintog. Akinpapatiayu! Iwaiwasanyun lafaw na tasayu ya pingkanyu wi mamàila ngim na charòna wi achi pu maila, nanapnù kinurukyu ya kinamkamanyu ta taku. ");
INSERT INTO ksc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Tuttuway isuayù nakurap, chiayuy Fariseo! Tan masapur unaonyu iwasan na charò na tasayu ta kaisawnay achi pu maila, siyan kapilitani pumor-as akon lafawnay mamàila. ");
INSERT INTO ksc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kakkaasiayu, chiayuy Fariseo ya mangitudtuchu ta Lintog. Akinpapatiayu! Tan na osay miyalikanyu, isuayù pantiyung wi naar-arkusan wi mamfarun mail-ana ta taku, ngim na katuttuwaana, nanapnud charònà tung-ar ya lachag wi marmarpos. ");
INSERT INTO ksc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Amaschiayu tan mamfaruayu ta sangwanan na taku, ngim na somsomòyu, losan tuli ya lawing. ");
INSERT INTO ksc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kakkaasiayu, chiayuy Fariseo ya mangitudtuchu ta Lintog. Akinpapatiayu! Tan finarfaruyun pantiyung wi para ta tung-ar na chachi profetas wi natoy ta awi, ya inar-arkusanyu kon pantiyung na mamfaruy taku. ");
INSERT INTO ksc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ad ananyu koy nu iningkaw-ayu kuma ta timpun na atattakuwan chachi profetas, foon pù nichokaayu ta namatayan na aappuyun chicha. ");
INSERT INTO ksc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ngim sachin mangipudnuwanyu wi kanà chiayu ta chachi namatoy ta chachi profetas ta awi! ");
INSERT INTO ksc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Choowot ikangputyun sachi nar-usi illukin na aappuyu! ");
INSERT INTO ksc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Tuttuway isuayù urog wi isù tinawidyun losani lawing. Amod à ananyuy mailisiyun mifalluwanyud infierno. ");
INSERT INTO ksc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Siyan ifafagkà an chiayun oyyoonyu, tan umifaunà à profetas ya uchumi nan-araing ya uchumi mangitudtuchun chiayu. Ngim patoyonyun uchum, ilansayun uchum ta kros, abchoyonyun uchum ta sinagoga, ya palikatanyu chicha ta ailiili. ");
INSERT INTO ksc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ad na lisortan na oy-oyyoonyu, chuchussaon Apudyus chiayu, wi chiayun mangikaru ta chusan na napatayan na losani takuy maid ingwachà lawing nanipud ta namatayanchan Abel wi mamfaruy taku ingkanan Zacarias wi anà Barakias wi pinatoyyu ta namforaatan na Templo ya altar. ");
INSERT INTO ksc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tuttuwan ifakà an chiayuy taku ta annay sillumunap, chiayun mangikaru ta chusan na losani amaschi wi nàwa!” ");
INSERT INTO ksc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Sachi ad anan Jesus, “O Jerusalem, chiayuy iJerusalem, amod na somsomòun chiayu! Tan chiayun nangtoy ta profetas ya namisong ta chachi finaun Apudyus à manudtuchun chiayu! Naina kon naryachà wi mangaruarus kuman chiayu wi isun na manaofan na manù ta isiwna, ngim ummisìayu! ");
INSERT INTO ksc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Siyan na sana, ikadyu kay nu maid pu mangayyuwan an chiayu. ");
INSERT INTO ksc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ad manipud ta sana, maid asin mangil-anyun saon ingkana ta padchay mangifag-anyuy, ‘Chayawontaun annay ummali wi narpun Apudyus.’” ");
INSERT INTO ksc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Lummawa pù Jesus ta Templo, nichaum na disipulusnan siya ad illukicha ukuchon an siyan kinafarun na Templo ya foforoyi nampalìwos. ");
INSERT INTO ksc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ad anan Jesus, “Mamàila tuwan kinafaruna, ngim tuttuwan ifakà an chiayu, wi chumatong na padchay maamin mikur-ub siyan maid pu mataynan à uray osa ta tuping.” ");
INSERT INTO ksc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ingkaw pu Jesus ta filig wi Olivo ummachuy, ummoy na disipulusnan siya tummalin, ad inimuscha, “Mafalin wi ifakam an chiani nu maanun màwaan na sachi imfakam ad kanad, ya sinu kon mangakammuwanni ta mangulinam ya mangakammuwanni ko ta anungus wi padcha?” ");
INSERT INTO ksc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ad summongfat à Jesus wi anana, “Man-annad-ayu ta achiayu pu maallilaw ta uchum, ");
INSERT INTO ksc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","tan lumoswan ad-adchuwani takuy mangwanani chicha nù Cristu wi impustan Apudyus wi manturay! Ya ad-adchuwan na allilawoncha. ");
INSERT INTO ksc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ya chamchamakonyun kukufat, ya chamakonyu kon man-asikinnufat anu ta achayuy il-ili. Ngim achiayu umogyat, tan masapur màwan amaschi, ngim foon pù sachin anungus wi padcha. ");
INSERT INTO ksc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tan man-asikinnufat na losani turay ta annay lufung. Ad mangkukufat akon sin-umili. Ad manita ko ya amod akon ingki ta ailiili. ");
INSERT INTO ksc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ngim na anchanaya losan, lugrukin yakan liglikat wi isun na sikab na lukin na mangkumut. ");
INSERT INTO ksc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kuraon chiayu ta losani takud asnay luta kapu ta pammatiyun saon, ad tiliwoncha chiayu ya palikatan chiayu ya patoyon chiayuy uchum. ");
INSERT INTO ksc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ad kapu ta sachi, ad-adchuwan an chiayun man-awichanan pammatina, ya man-asififikcha ya man-asikuracha ko. ");
INSERT INTO ksc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ad lumoswa kon ad-adchuwani sinanprofetas wi mangallilaw ta achu. ");
INSERT INTO ksc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ad kapu ta pumigpigsan lawingi màmàwa ad asnay luta, maaan na ayat na kaachuwani taku ta fufuruncha. ");
INSERT INTO ksc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ngim sinumani mangipapati ta pammatina ingkanà anungusna, chichan masaraknifan à ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ad na Mamfaruy Chamag wi mipangkop ta Manturayan Apudyus, mipaakammu ta losani taku ta arutaruta achiwot chumatong na anungus na asinchuwan.” ");
INSERT INTO ksc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ad inturuy Jesus anani, “Lumoswa kon isag kaog-ogyat wi mailayu wi sachin inukud Daniel wi profeta ta awi. (Chiayuy mamasa ta annaya, maawatanyu kuman miningna!) Nu ilanyù siyay umagsad ta naapudyusani ikaw, ");
INSERT INTO ksc_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","masapur umawid chachi ingkaw ad Judea wi umoy mantaru ta filfilig. ");
INSERT INTO ksc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ad na takuy niyaspur wi awad ta otop na foroyna, achi pu kuma lumnò mangarà sinuman ta ùuwana, ngim ichakusna umawid. ");
INSERT INTO ksc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ad isun akon takuy niyaspur nasiput, achi pu kuma mangulin ta foroyna umoy mangarà uray luputna, tan ichakusna kuma umawid. ");
INSERT INTO ksc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kakkaasin chachi mafuki ya chachi mantakifi ta sachi timpu! ");
INSERT INTO ksc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Siyan iluwaruyun Apudyus ta achi pu kuma michammu ta timpun na akilid winnu timpun na iillongan! ");
INSERT INTO ksc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tan amod na likat na sachi timpu, wi maid pu miyisuwana nanipud ta lugrukin na losan ingkana ta sana. Ad maid pu ko amaschì asin mipachas ad asnay lutà isun na sachi malikatan na taku. ");
INSERT INTO ksc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ad nu achin pu Apudyus inaanan na chachi padchay màwaan na anchanaya, matoy na losani taku. Ngim kapu ta kaasina ta losani chinutukana, inaananan padchay màwaan na anchanayay likat. ");
INSERT INTO ksc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ad nu awad ako mangawanani, ‘Ilanyu, annayan Cristuy impaalin Apudyus wi manturay!’ winnu, ‘Anchiyà siya!’ achiyu patiyon. ");
INSERT INTO ksc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tan lumoswan uchumi sinan-Cristu ya sinanprofetas wi mangwanani chicha nun piniyar Apudyus, ad mangwachà kaskaschaaw ya singyar à mangallilawancha ta taku, wi nu mafalin, allilawonchan uray chachi chinutukan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Siyan somsom-onyuna, tan impachaan-un chiayu imfaka ta achiayu pu kuma maallilaw. ");
INSERT INTO ksc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ad nu awad mangifakan chiayuy, ‘Awad anu ta tanap!’ achiyu umoy ilan. Ad nu ananchay, ‘Anchi mantataru!’ achiyu patiyon. ");
INSERT INTO ksc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tan saoni namfalin taku, na miyalikan na umaliyà, isun na ilat, wi nu sumlit maid achi mangila tan linanganan sumingitan na init ingkana ta masiutana. ");
INSERT INTO ksc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Ya sinumani ikaw na natoy, sachin maarusan na sissiwit wi mangan ta lachag.” ");
INSERT INTO ksc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Inturuy Jesus anani, “Na marpasan na anchanayay liglikat, makorkor na losani mailad langit, tan fumulingot na init, ya achi pu sumrag na furan. Ya uray na fituwon, mayaayàcha. ");
INSERT INTO ksc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ad na sachi ko, lumoswad langit na singyar na umaliyà. Siyan man-ifil na losani taku kapu ta amochi ogyatcha ta mangil-anchan saoni namfalin taku wi iyaliyà ta lifuu wi marpud langit, ad maila kon mannakafalin-u ya sumilingà ta kina-Apudyus-u. ");
INSERT INTO ksc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ad na sachi ko, mipakingan sachi chakorani pupu, ad sachin timpuy mangifaunà ta aangheles-u wi umoy mangarus ta losani takuy chinutukan Apudyus ta sinumani ili ta luta.” ");
INSERT INTO ksc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ad anan ako Jesus, “Acharonyun itudtuchun na imongi ikus. Akammuyu wi nu mangutar ya mamingi, chanchanin chakun. ");
INSERT INTO ksc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Isuna ko, nu ilanyuy màwan losani inukud-u, akammuwonyu wi chanchanin mangulinà ad asnay luta. ");
INSERT INTO ksc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tuttuwan ifakà an chiayu, wi foon pù losan matoy na taku ta annay lunap ad màwan losani inukud-u. ");
INSERT INTO ksc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ad uray maumas losan na mailad langit ya asnay luta, achi pu mabmab-os na losani inukud-ù ing-ingkana, tan masapur matungpar losan.” ");
INSERT INTO ksc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ad anan ako Jesus, “Maid pu mangakammu ta padcha winnu uras wi màwaan na anchanay losani inukud-u. Tan uray chachi aangheles ad langit ya saoni Anà Apudyus, maid pu osà mangakammu nu achi afus à Ama. ");
INSERT INTO ksc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Na mangulinà ad asnay luta, isun na nàwa ta timpun Noe, ");
INSERT INTO ksc_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","tan na sachi timpu, maid somsomò na taku wi awad na mapasamak, tan nanganangancha ya umminuinumcha ya nan-as-asawacha ingkana ta sachi linumnoancha Noe ta papur. ");
INSERT INTO ksc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ad maid pu illasinchà màwa ad nammaag nalitap ad asnay luta ad naamincha naanud. Ad sachin isun na màwa ta mangulinà. ");
INSERT INTO ksc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tan na sachi timpu, nu awad chuwà laraì masiput, maaran osa ya mataynan na osa. ");
INSERT INTO ksc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ad isuna ko nu awad chuwà fufaì mamfayu, maaran osa ya mataynan akon osa. ");
INSERT INTO ksc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Siyan tatanchaananyu ta mansakanaayu, tan foon à akammuyun padchay mangulinan na Apuyu. ");
INSERT INTO ksc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Na miyalikana, nu akammun na nginforoy na ustuy uras na umaliyan na man-akaw ta foroyna, kapilitani sakanaonan chumatngana ta maid pu maakaw ta foroyna. ");
INSERT INTO ksc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Siyan amaschiyonyu wi masapur mansakanaayu tan à saoni namfalin taku, mangulinà ta timpuy foon à namnamaonyuy chumatngà.” ");
INSERT INTO ksc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Inturuy Jesus wi nan-alig anani, “Sinun mangilasinanyu ta mapiyar ya nanakman wi sanilu? Siyan piniyar na ap-apuna wi mangayyuwan ta fufurunnay sanilu ya mamaan an chicha nu timpun na inyòoan. ");
INSERT INTO ksc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ad maragragsakan na sachi sanilu nu aspuron na apunà siyay mangwa ta losani nipiyar an siya! ");
INSERT INTO ksc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tan tuttuwan ifakà an chiayu, wi na kinapiyarna, siya kon mangipiyaran na apuna ta losani ùuwana. ");
INSERT INTO ksc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ngim nu foon à mapipiyyar na sachi sanilu, wi siya somsomònan mafayag na mangulinan na apuna, ");
INSERT INTO ksc_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ya ilukinay mamalikat ta fufurunnay sanilu, ya makàakàan ya makàikàinum ta sallimongan. ");
INSERT INTO ksc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ngim na osay padcha, machanatong na apuna ta timpuy foon à namnamaonay chumatngana. ");
INSERT INTO ksc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Siyan kapilitani chusaon na apunà siya ad itapinà siya ta machusaan na chachi akinpapati. Ad sachin amochi likat wi asiaayom-omcha ya ngumarotngotan na fafacha ta likatna.” ");
INSERT INTO ksc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Inturuy Jesus wi anana, “Na Manturayan Apudyus ta chumatngà, miyalig ta simpuruy fabfafarasang wi waschi osa nangawit à silawna wi umoy mangafot ta larai wi mangasawa. ");
INSERT INTO ksc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Na lima an chicha, natingtingangancha, ngim na fufurunchay lima, nanakmancha. ");
INSERT INTO ksc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Na chachi natingtingangan, nangawitchà silaw ngim maid inawitchà ikas à iyutupcha. ");
INSERT INTO ksc_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ngim chachi nanakman, nangawitchà ikas à iyutupcha ta silawcha. ");
INSERT INTO ksc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ad kapu ta nataktak na larai wi chumatong, nanchùchùmogcha ad nasuyopcha. ");
INSERT INTO ksc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kawan pun na lafi, iningkaw na nangip-aw wi anana, ‘Annay marungay na larai wi mangasawa! Ing-ayu sib-aton à siya!’ ");
INSERT INTO ksc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ad fummangon chachi fabfafarasang ad insakanachan silawcha. ");
INSERT INTO ksc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ad chachi limay natingtingangan, nan-ochawcha ta chachi fufuruncha, wi anancha, ‘Adchan chianì ikas tan annay maamin na ikas na silawni.’ ");
INSERT INTO ksc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ngim anan chi lima, ‘Foon, tan isù kurang an chitau losan. Siyan ing-ayu kay ngumina ta tinchaan à usaronyu.’ ");
INSERT INTO ksc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Siyan lummigwat chachi natingtingangan wi umoy ngumina. Ngim nasiutcha pun, chummatong chi larai wi uullayoncha. Siyan chachi limay nakasakana, nakarnòchan siya ad nallaragsakcha, ad inyonobchan liwangan. ");
INSERT INTO ksc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Napapannos ad chummatong ako chachi limay fabfafarasang, ad ananchay mangkobkob, ‘Apu, Apu! Ib-atnu ad!’ ");
INSERT INTO ksc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ngim summongfat chi larai wi mangasawa anani, ‘Foon, tan maid akammù an chiayu.’” ");
INSERT INTO ksc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ad inyanungus Jesus anani, “Siyan nu amaschi, masapur makasakanaayu tan maid akammuyu ta uras winnu padcha wi chumatngà.” ");
INSERT INTO ksc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ad inturuy Jesus wi anana, “Na miyalikan akon Manturayan Apudyus ta mangulinà, isun na osay taku wi ummoy namfiyasi ta achayu, wi na lummigwatana, inayakanan saniluna ad impiyarna impad-on an chichan ùuwana, ");
INSERT INTO ksc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","wi impiyarnan chichan insikun ta lobfongcha. Siyan na osa, impiyarnan limay lifuy falituk wi pilak, ad na miyagwa, impiyarnan chuway lifu, ad na miyatlu, impiyarnan sillifu. Sachi ad lummigwat wi ummoy namfiyasi. ");
INSERT INTO ksc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Na saniluy nipiyaran na limay lifu, inyamusantina ad nangkanar à limay lifu. ");
INSERT INTO ksc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Isun akon sachi nipiyaran na chuway lifu ad nangkanar akò chuway lifu. ");
INSERT INTO ksc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ngim chi nipiyaran na sillifu, illofonna intaru. ");
INSERT INTO ksc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Nafayafayag pun chummatong na apucha ad impaayagna chicha ta akammuwonan iningwacha ta sachi impiyarnan chicha. ");
INSERT INTO ksc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ad na sachi nipiyaran na limay lifu, nisangun siya ad impurangna chi inoognana, ad anana, ‘Apu, limay lifun annay kanar-u ta sachi impiyarnun saon.’ ");
INSERT INTO ksc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ad anan chi apucha, ‘Kattoi mamfarua ya mapiyar-à sanilu. Siyan kapu ta ustun iningwam wi nangchon ta uray ait, ipiyar-un chakor wi katad an sia. Waynu makaragsak an saon!’ ");
INSERT INTO ksc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Sachi ad ummoy akon sachi nipiyaran na chuway lifu, ad impurangna chi inoognana, ad anana, ‘Apu, chuway lifun annay kanar-u ta sachi impiyarnun saon.’ ");
INSERT INTO ksc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ad anan chi apucha, ‘Ustun iningwam. Kattoi mamfarua ya mapiyar-à sanilu! Siyan kapu ta ustun iningwam wi nangchon ta uray ait, ipiyar-un chakor wi katad an sia. Waynu makaragsak an saon!’ ");
INSERT INTO ksc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Sachi ad ummoy akon sachi nipiyaran na sillifu, ad ananay manlasun, ‘Apu, akammù wi istriktua tan man-uwam na liningtanan na uchum wi isù apitom na foon pù immuram. ");
INSERT INTO ksc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ad sachin ummogyatà an sia, siyan illofon-u intarun pilaknu ta achi pu matarà. Siyan annayan ustuy pilaknu.’ ");
INSERT INTO ksc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ngim anan na apuchan siya, ‘Lawing-a ya masachut-à sanilu! Tan nu akammum wi man-uwà na liningtanan na uchum wi isù apitò na foon pù immurà, ");
INSERT INTO ksc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","siyan apay achim pu impaangkat ta awad kuma ait à paanànà arà ta annay nangulinà?’ ");
INSERT INTO ksc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ad anana ta osay saniluna, ‘Aram na sanati impiyar-un siya ad inadchom ta sachi nangchon ta simpuruy lifu. ");
INSERT INTO ksc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tan na mapipiyyar wi taku, machogchog-an na maatod an siya ingkanà sumawar. Ngim na takuy foon à mapipiyyar, maaan na uray aiti awad an siya.’ ");
INSERT INTO ksc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ad anana ko, ‘Siyan na oyyoonyu ta annay maid silfinay sanilu, ifalluyù siya ta sachi lukar wi fulingotan ta man-ayoayom-om ta sachi ya ngumarongarotngot akon fafana.’” ");
INSERT INTO ksc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ad inturuy Jesus anani, “Saoni namfalin taku, na mangulinà ad asnay luta, mifurunà ta losani aangheles ad mamàilan kinachayaw-u. Ad na sachi, tumùchuwà wi manturay ya manguis ta losan. ");
INSERT INTO ksc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Siyan mipasangun saon na losani takud asnay luta. Ad man-agwaò chichà isun na maninaan na mampapastor ta panniluna ta karchingna. ");
INSERT INTO ksc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Siyan chachi mamfaruy taku wi miyalig à pannilu, igkà chicha ta apot ta chiwawan-u. Ngim chachi lawingi taku wi miyalig à karching, igkà chicha ta apot ta chuwikì. ");
INSERT INTO ksc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ad à saoni Ali, ifakà ta chachi ingkaw ta apot ta chiwawan-u, ‘Wayyu, chiayuy fininchisyunan Ama, ta mitapiayu ta annay manturayà wi nisasagkanà ingkawanyu nanipud ta nàwaan na lufung. ");
INSERT INTO ksc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tan na iningwayun saon, pinaananà ta nafitilà, ya pinainumanà ta nauwawà, ya minangiliyà ta foforoyyu uray kailiyà. ");
INSERT INTO ksc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ya sinilupanà ta namfofodchangà, ya finarfaruwà ta nasakità, ya finusitaà ta nifaruchà.’ ");
INSERT INTO ksc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ad sumongfat na takuy nifilang à mamfaru, wi anancha, ‘Apu, maid met innilanì nafitilam ad pinaananni sia! Ya maid ako innilanì nauwawam ad pinainumanni sia! ");
INSERT INTO ksc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ad maid ako nammangiliyannin sia wi kailia, winnu namfofodchangam ad sinilupannì sia! ");
INSERT INTO ksc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ya maid met ako innilanì nasakitam ad finarfarunì sia, winnu nafarucham ad finusitanì sia!’ ");
INSERT INTO ksc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ad à saoni Ali, anai sumongfat an chicha, ‘Tuttuwan ifakà an chiayu, wi uray sinuy iningwayu ta uray na kafafaani mamatin saon, isù saon na nangwaanyu ta sachi!’ ");
INSERT INTO ksc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ad ifakà ta chachi taku ta apot ta chuwikì, ‘Lumayaw-ayu, chiayuy machuchusa, tan mifalluayu ta mannaynayuni apuy wi nisasagkanà mifalluwan Satan ya chachi aanghelesna! ");
INSERT INTO ksc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tan nafitilà pun, achiyà pu pinaanan, ya nauwawà pun, achiyà pu pinainuman. ");
INSERT INTO ksc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ummoyà pun ta iliyu, achiyà pu minangili, ya namfofodchangà pun, achiyà pu sinilupan. Ya nasakità pun, achiyà pu finarfaru, ad nafaruchà pun, achiyà pu finusita.’ ");
INSERT INTO ksc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ad ananchay sumongfat, ‘Apu, maid met innilanì nafitilam ya nauwawam ya nampamangiliyam ya namfofodchangam ya nasakitam winnu nafarucham, ad achini pu sia finadngan!’ ");
INSERT INTO ksc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ad à saoni Ali, songfatà chicha anani, ‘Tuttuwan ifakà an chiayu, wi na achiyu pu namadngan ta uray na kafafaani mamatin saon, isù saon na achiyu pu finadngan.’ ");
INSERT INTO ksc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Siyan mipaoy losan na anchanaya ta mannaynayuni likat à machusaanchà ing-ingkana. Ngim chachi nifilang à mamfaru, makafiyagchan Apudyus à ing-ingkana.” ");
INSERT INTO ksc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Narpas pu Jesus intudtuchun losan chachi, anana ta disipulusna, ");
INSERT INTO ksc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Akammuyu wi chaan chuway padcha ad fiyastay mangiyakasmoan ta nallausan na aangheles ta aapputaud Egipto. Ad na timpun na fiyasta, saoni namfalin taku, mipurangà ta uchum ad ipailansachà saon ta kros.” ");
INSERT INTO ksc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ad na sachi ko, naarus na chachi pangpangun na papachi ya chachi mamangpanguwon na Judio ta foroy Caifas wi Angatuwani Pachi, ");
INSERT INTO ksc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ad nan-uupngacha nu sinun in-inonchay maniliw ya mamatoy an Jesus à foon pu kumà maakammuwan. ");
INSERT INTO ksc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ngim anancha, “Achitau pu ichammu oyyoon ta timpun na fiyasta, tan makuru nin na taku.” ");
INSERT INTO ksc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Sachi ad iningkawcha Jesus ad Betania ta foroy Simon, wi nakollakong ta sin-arkawan. ");
INSERT INTO ksc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ad na manganancha, linumnò na osay fafarasang wi nangaw-awit à futilya wi nàwa ta ananchay alebaster wi fatuy iigkaan à nanginà lana, ad insiitna ta urun Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ad na nangil-an na disipulusna, lummawing na somsomòcha ad ngummunungunucha anani, “Tanako chachailon na lana? ");
INSERT INTO ksc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mingina kuma tan nangina, ta awad maatod ta kakapus!” ");
INSERT INTO ksc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ngim à Jesus, inakammunan ug-ugkuchoncha, siyan ananan chicha, “Apay chillawonyun annay fafarasang? Mamfaru met na iningwana! ");
INSERT INTO ksc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ad nu mipangkop ta fumadnganyu ta kakapus, kanayuncha awad. Ngim à saon, foon à mafayag na ingkawà ad asnay luta. ");
INSERT INTO ksc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tan na annay nangisiitana ta lana ta long-ag-u, nangisakanaana ta milobnà. ");
INSERT INTO ksc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tuttuwan ifakà an chiayu, wi na losani mitudtuchuwan na Mamfaruy Chamag ad asnay luta, machamag akon iningwan na annay fafarasang à masmasmoana.” ");
INSERT INTO ksc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Sachi ad à Judas Iscariote wi osay disipulus Jesus, ummoy ta chachi pangpangun na papachi, ");
INSERT INTO ksc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ad inimusna, “Am-an na mamayadyun saon nu ipachòmà à Jesus an chiayu?” Ad fummilangchà turumpuruy pilak ad inadchonchan siya. ");
INSERT INTO ksc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ad nanipud ta sachi, illukin Judas wi man-anap à wayanay mangififik an Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Sachi ad wi chamuy padchan na fiyastay manganan na Judio ta tinapoy wi achi pu fumtar, ummoy na disipulus an Jesus inimus anani, “Sinun mangisakanaanni ta manganantaù mangiyakasmoantau ta nallausan na anghel ta aapputau ta awi?” ");
INSERT INTO ksc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ad anan Jesus an chicha, “Ing-ayud aschi Jerusalem ad sib-atonyun osay takuschi, ad ifakayun siya wi, anan na Misturu wi chanchanin matayana, siyan foroyyu nun mangananni ta annay fiyastay Mangiyakasmoan.” ");
INSERT INTO ksc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ad lummigwat na disipulus Jesus ummoy iningwan losani imfakana ad insakanachan manganancha ta sachi fiyasta. ");
INSERT INTO ksc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mummaschom pun nan-ooancha Jesus ta disipulusna. ");
INSERT INTO ksc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ad na nanganancha, anan Jesus an chicha, “Tuttuwan ifakà an chiayu, wi awad na osan chiayu wi mangififik an saon.” ");
INSERT INTO ksc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ad summauycha losan, ad nasin-ossacha inimus an siya, “Apu, saon na anam?” ");
INSERT INTO ksc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ad anan Jesus wi summongfat, “Awad an chiayuy aufung-u ta sanan mangififik an saon. ");
INSERT INTO ksc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","À saoni namfalin taku, mapatoyà tan sachin imfafagkan na niyug-is wi ukud Apudyus, ngim kakkaasin takuy mangififik an saon, tan un-unnoy akon nu achi pu niyanà!” ");
INSERT INTO ksc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Sachi ad kummingà Judas, wi siyan mangififik an Jesus, wi anana, “Apu, saon lawan anam?” Ad anan Jesus, “Oo, siyan anam.” ");
INSERT INTO ksc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Na nanganancha ko, innaran Jesus na tinapoy ad nanyaman an Apudyus, ad pinotpotlàna ad innadchona ta disipulusna, wi anana, “Aranyuna ad innanyu. Sanan long-ag-u.” ");
INSERT INTO ksc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ad inarana kon sintasay fayas ad asin nanyaman an Apudyus, ad inadchonan chicha wi anana, “Uminum-ayu losan ta annaya. ");
INSERT INTO ksc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Sanan charà wi mifùfù à manguras ta fasur na takuy ad-adchuwan, ya sana kon mampanoknok ta impustan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Tuttuwan ifakà an chiayu, wi achiyà pu asin uminum à fayas ingkanà chumatong na padchay makainumà an chiayu ta àoyyay fayas ta Manturayan Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ad nangkantachà chaychayaw an Apudyus, ad lummawacha wi ummoy ta filig wi Olivo. ");
INSERT INTO ksc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sachi ad anan Jesus an chicha, “Na sanay lafi, umawid-ayu losan wi taynanyù saon, tan sachin niyug-is wi ukud Apudyus wi anana, ‘Patoyò na mampapastor ad mansississiyan losan na panniluna.’ ");
INSERT INTO ksc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ngim nu umuliyà mataku, umunaà umoy ad Galilea nu chiayu ta aschin man-asiil-antau.” ");
INSERT INTO ksc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Sachi ad anan Pedro an Jesus, “Uray nu taynan sia ta anchanay uchum, foon à taynà sia!” ");
INSERT INTO ksc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ngim anan Jesus an Pedro, “Tuttuwan ifakà an sia, wi nu chaan pun na awitan manullaù à lafi, namitluwonà illifak.” ");
INSERT INTO ksc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ngim summongfat à Pedro wi anana, “Achì pu sia ilifak, uray nu makàtoyà an sia!” Ad sachi kon imfakan losan na disipulusna. ");
INSERT INTO ksc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sachi ad ummoycha Jesus ta disipulusna ta sachi lukar wi ananchay Getsemani, ad anan Jesus an chicha, “Umachuy-ayu yan ta anna ta inyà malluwaru ta anchi.” ");
INSERT INTO ksc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ad intalinna cha Pedro ya chachi mansunud wi anà Zebedeo, ad summauy wi malifuk na somsomòna. ");
INSERT INTO ksc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ad ananan chicha, “Amod na somsomòu wi isù siyan iyatoy-u. Ingkaw-ayu ta anna ta fantayanà.” ");
INSERT INTO ksc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ad ummadchayang à ait ad nallùfub ta luta wi malluwaru anani, “Ama, nu mafalin kuma, ilisim à saon ta annay likat wi sangsanguwò. Ngim uray nu amasnan chawatò, piò wi matungpar kan piom wi màwa, wi foon pu kà piò.” ");
INSERT INTO ksc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Sachi ad nangulin à Jesus ta chachi turuy disipulusna ad inchasana chichay nasusuyop. Ad ananan Pedro, “Apay, achi pu mafalini fantayanà à uray osay uras? ");
INSERT INTO ksc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Achiayu kuma masuyop ta malluwaruayu ko ta achiayu pu maawis wi makafasur. Tuttuway annan somsomòyuy mangwa ta ustu, ngim maafak-ayu ta kinakapsut na long-agyu.” ");
INSERT INTO ksc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Sachi ad asin ummadchayang à Jesus wi umoy malluwaru anani, “Ama, nu achi mafalini mafaliwan na annay màwan saon wi malikatà, siyan màwan piom.” ");
INSERT INTO ksc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Sachi ad asin nangulin ta chachi turu ad inchasana chichay nasusuyop wi amod na suyopcha. ");
INSERT INTO ksc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ad tinaynana kay chicha wi ummoyna ko ipitluy mangiluwaru ta isun na luwaruna ta chamu. ");
INSERT INTO ksc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ad asin nangulin ta ingkawan na disipulusna ad anana, “Kassiyaayu kay wi nasusuyop? Noy! Annay nachauman na timpu, wi saoni namfalin taku, mipurangà ta managfasur. ");
INSERT INTO ksc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Siyan fumangon-ayu ta intau, tan anchiyan mangififik an saon!” ");
INSERT INTO ksc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sachi ad wi man-ug-ugkud à Jesus, chummatong à Judas wi siyan osa ta chachi nasawaran à chuway disipulusna, wi nifurun akon siyan ad-adchuwani takuy nasabsabliyan ya napangpang-oan, wi chichan imfaun na pangpangun na papachi ya chachi namangpanguwon na Judio. ");
INSERT INTO ksc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","À Judas, imfakanan singyar na mangififikanan Jesus, wi anana, “Na takuy kayyomò, siyan tiliwonyu!” ");
INSERT INTO ksc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Sachi ad ummoy à Judas an Jesus ad anana, “Apu!” Ad kinayyomnà Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ad anan Jesus an siya, “Furun, sinun kakaram?” Sachi ad ummachanin chachi takuy naniliw an Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ad linùpus na osay disipulus Jesus na sablina ad piningasnan ingan na sanilun na Angatuwani Pachi. ");
INSERT INTO ksc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Sachi ad inomoran Jesus à siya wi anana, “Ibroynun sablim! Tan nu sablin usarom à isaraknibnu, sabli kon mangtoychan sia. ");
INSERT INTO ksc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Apay, achim pu akammu wi nu manchawatà an Amà turung, man-ifaunnà alifulifù aangheles à manaraknib an saon? ");
INSERT INTO ksc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ngim nu amaschin oyyoò, in-inon na tumuttuwaan na niyug-is wi ukud Apudyus wi ananay masapur màwan amasna?” ");
INSERT INTO ksc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sachi ad anan Jesus ta chachi takuy ad-adchuwan, “Akkawanà ta masapur mansasabliayu ya mampapang-òayu wi umali maniliw an saon? Finikati nantudtudtuchuwà an chiayu ta Templo, ad apay achiyà pu tiniliw ta sachi nù? ");
INSERT INTO ksc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ngim masapur màwan amasna ta tumuttuwaan na inyug-is chachi profetas ta awi wi ukud Apudyus.” Sachi ad ummawid losan na disipulusna wi tinaynanchà siya. ");
INSERT INTO ksc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Chachi naniliw an Jesus, inyoychà siya ta foroy Caifas wi Angatuwani Pachi, wi sachin naarusan na namangpanguwon na Judio ya mangitudtuchu ta Lintog. ");
INSERT INTO ksc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ngim à Pedro, nan-ag-agkaaw wi nitun-ud an chicha ingkana kay ta paway na foroy na Angatuwani Pachi, ad ummoy nakaachuy ta chachi kuwarcha ta ilana nu sinun màwan Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Chachi pangpangun na papachi ya losani kukunsisar, nan-anapchà ipafasurchan Jesus ta awad lasunchay mamatoy an siya. ");
INSERT INTO ksc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ngim maid pu inchasancha, uray nu am-an na charumchan siya. Ngim anungusna ad ummagsad na chuwa anani, ");
INSERT INTO ksc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Na sanati taku, ananay anna nun karobfonganay mamaas ta Templon Apudyus ad asinna patàchoron ta unog na turuy padcha.” ");
INSERT INTO ksc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Sachi ad ummagsad na Angatuwani Pachi ad ananan Jesus, “Apay maid isongfatnu ta anchanay ipafasurchan sia? Winnu tuttuwan imfakacha?” ");
INSERT INTO ksc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ngim ingkikinnò à Jesus. Ad asin na Angatuwani Pachi anan an siya, “Ta sangwanan Apudyus wi natataku, mancharò sia ta songfatam na imusò an sia: sian tuttuway Cristu wi Anà Apudyus, wi uullayonni?” ");
INSERT INTO ksc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ad anan Jesus wi summongfat, “Tuttuwan imfakam. Ngim ifakà an chiayu losan, nu marpas na annay màwan saon, mailayù saoni namfalin taku wi umaachuy ta apot ta chiwawan Apudyus wi Mannakafalin. Ad mailayu kon mangulinà wi marpud langit wi iyaliyà ta lifuu!” ");
INSERT INTO ksc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Chingngor pun na Angatuwani Pachin imfakan Jesus, kinissaynan silupna ta amochi og-otna, wi anana, “Sinu kon annaya, wi iyalignan long-agnà Apudyus! Foon à masapur awad uchum à anapontaù mangistiku ta fasurna! Tan losantau chingngor na sachi wi inukudna wi iyalignan long-agnà Apudyus! ");
INSERT INTO ksc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ad sinun kasomsom-anyu?” Ad ananchay summongfat, “Mapatoy kuma.” ");
INSERT INTO ksc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ad tinubfaanchan fosarna ad chinanugchà siya. Ad na uchum ako, finungutchan atana ad linipakcha anani, ");
INSERT INTO ksc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Nu tuttuway sian Cristuy impaalin Apudyus, ifakam na nanlipak an sia!” ");
INSERT INTO ksc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Na sachi, nakaachuy à Pedro ta paway, ad ummoy an siyan osay fafarasang wi sanilun na Angatuwani Pachi, ad anana, “Sia kon osay furun Jesus wi iGalilea.” ");
INSERT INTO ksc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ngim illifak Pedro ta sangwanancha losan anani, “Maid akammù ta sanati ug-ugkuchom.” ");
INSERT INTO ksc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ad ummoy ta liwangan na sachi paway. Ngim iningkaw akon osay fafarasang wi sanilu wi nangilan siya, ad anana ta chachi naag-agsad, “Annaya kon osay furun Jesus wi iNazaret.” ");
INSERT INTO ksc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ad asin Pedro illifak wi ananay insapata, “Kattoi maid akammù ta sanati taku!” ");
INSERT INTO ksc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Napapannos pun ummoy an siyan chachi naag-agsad wi anancha, “Kattoi sian osan chicha tan maimatunan na ingkigkingam!” ");
INSERT INTO ksc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ad anan Pedro wi nangisapata, “Uray chusaonà an Apudyus nu foon à tuttuwan ifakà, maid pu akammù ta sanati taku!” Ad natanullaù na awitan ta sachi. ");
INSERT INTO ksc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ad nasnasmò Pedro na imfakan Jesus an siya, wi anana, “Nu chaan pun na awitan manullaù, namitluwonà illifak.” Ad chakusi lummayaw à Pedro wi amod na somsomònay nan-ifil. ");
INSERT INTO ksc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Figfikat pun asin naarus losan chachi pangpangun na papachi ya chachi namangpanguwon na Judio nan-uukud nu sinun in-inonchay mampapatoy an Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Siyan kinachilaanchan imana ad inyoycha impurang an Pilato wi fifinnachur. ");
INSERT INTO ksc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","À Judas, wi siyan nangififik an Jesus, inakammuna pun wi nasintinsiyaan à Jesus wi mapatoy, namfafawi siyan inyulinnan sachi turumpuruy pilak ta chachi pangpangun na papachi ya chachi namangpanguwon na Judio. ");
INSERT INTO ksc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ad anana, “Nakafasurà tan imfifik-un takuy maid pu fasurna!” “Maid pu ay-ayannisnat! Ikadnu!” ananchay summongfat. ");
INSERT INTO ksc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ad intop-ar Judas na pilak ta Templo ad lummayaw ummoy nan-otoy. ");
INSERT INTO ksc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ad chachi pangpangun na papachi, chinakupchan pilak ad anancha, “Mipalit ta Lintogtau nu iyamungtaun annay pilak ta Templo tan fayad na fiyag na taku.” ");
INSERT INTO ksc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Siyan na lisortan na nan-uukuchancha, ingnginacha ta lutan na osay takuy manchichiwin à fanga ta awad lorobnan na kaili wi foon pù Judio. ");
INSERT INTO ksc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ad nanipud ta sachi, nangachanan na sachi lutà “Lutan na Chara” tan sachin narpuwan na nginana. ");
INSERT INTO ksc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ad sachin tummuttuwaan na imfakan Jeremias wi profeta ta awi, wi anana, “Na turumpuruy pilak wi inapufaran na chachi kanà Israel à ustuy fayadna, innaracha ");
INSERT INTO ksc_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ad ingnginacha ta sachi lutan na manchichiwin, wi sachin imfakan Apudyus wi màwa.” ");
INSERT INTO ksc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Sachi ad impasanguchà Jesus an Pilato wi fifinnachur, ad anan Pilato an siya, “Sia nun Alin na Judio.” “Siyan anam,” anan Jesus wi summongfat. ");
INSERT INTO ksc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ngim achin pu Jesus songfatan na ipafasur na chachi pangpangun na papachi ya chachi namangpanguwon na Judio. ");
INSERT INTO ksc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Siyan anan Pilato an siya, “Tam-ako achi songfatan na anchanay ipafasurchan sia?” ");
INSERT INTO ksc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ngim ingkikinnò à Jesus wi maid insongfatna wi uray osa ta impafasurchan siya, ad siyan naschaawan na Fifinnachur. ");
INSERT INTO ksc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tinawoni timpun na fiyastay Mangiyakasmoan, siyan achawiyan na fifinnachur wi umiparufus à osà farud wi chawaton na taku. ");
INSERT INTO ksc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ad na sachi timpu, niyaspur wi iningkaw na osay farud wi nanchinamag na kinarawingna wi nangngachan à Jesus Barrabas. ");
INSERT INTO ksc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Siyan naarus pun na takuy ad-adchuwan, inimus Pilato an chicha anani, “Sinun pionyù iparufus-u, Jesus Barrabas winnu Jesus wi ananchay Cristu?” ");
INSERT INTO ksc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Sachin imfakan Pilato tan inaagkammuna wi aposchan nangicharumanchan Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Na ummaachuyan Pilato ta aachuyani mangkuisana ta taku, inawatnan surat asawana wi anana, “Achim fiyangan na sanati takuy maid pu fasurna, tan ummogyatà ta in-inop-u ta lafi ta mipangkop an siya.” ");
INSERT INTO ksc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ngim chachi pangpangun na papachi ya chachi namangpanguwon na Judio, inawischan takuy naarus ta siya paiparufuschà Barrabas ya ipapatoychà Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ngim inimus Pilato an chicha, “Sinun pionyuy iparufus-u ta annay chuwa?” Ad losancha anan, “Barrabas!” ");
INSERT INTO ksc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ad inimus ako Pilato an chicha, “Ad sinu kon oyyoò an Jesus wi ananchay Cristu wi impaalin Apudyus?” Ad losancha anan, “Ilansayù siya ta kros!” ");
INSERT INTO ksc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ad anan ako Pilato, “Tamako? Sinun iningwanay lawing à milansaana ta kros?” Ngim chinakorcha impauy anani, “Ilansayù siya ta kros!” ");
INSERT INTO ksc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Illasin Pilato wi maid silfin na ifagfakana, ad isù makurucha, siyan nampaarà chanum ad namfuru ta sangwanancha losan, ad anana, “Sanan mangakammuwanyu wi maid fiyang-u ta mangtoyanyu ta annay taku! Siyan nangamung-ayu!” ");
INSERT INTO ksc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ad losancha summongfat anani, “Nangamung-ani ta kanàni nu kachusaannin mangtoyanni!” ");
INSERT INTO ksc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Sachi ad imparufus Pilato à Barrabas, ad impaabchoynà Jesus, ad impurangnà siya ta chachi mangilansa. ");
INSERT INTO ksc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ad na susurchachun Pilato, inyoychà Jesus ta foroy na fifinnachur, ad linìwos losan na surchachù siya. ");
INSERT INTO ksc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ad finchanganchà siya ad sinilupanchà siyà mancharaag à isù silup na Ali. ");
INSERT INTO ksc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ad fummaliugchà lassilassì isù koronana ad impayunguschan siya, ad ummigkacha kò sur-ud ta chiwawani imana. Ad nampalintumongcha ta sangwanana wi nanginsurtun siya anani, “Ta matakuà ing-ingkana, siay Alin na Judio!” ");
INSERT INTO ksc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ad tinubtubfaanchà siya, ad inarachan sur-udna ad impang-òcha ta uruna. ");
INSERT INTO ksc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ad limpascha pun inin-insurtù siya, sinukatanchan sachi insilupchan siya ta sikuchi silupna. Sachi ad illayawchà siya wi umoy mangilansan siya ta kros. ");
INSERT INTO ksc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Na lummawaancha ta ili, inafotchan osay taku wi nangngachan à Simon wi iCirene. Ad impafuudchan kros Jesus an siya. ");
INSERT INTO ksc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ad nichaumcha ta osay lukar wi ananchay Golgota (na miningna, “Fàag”). ");
INSERT INTO ksc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ad inadchanchà Jesus à fayas à naraukan à apku, ngim inissimana pun achina pu inumon. ");
INSERT INTO ksc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sachi ad illansachà siya ta kros, ad namfinnunutcha nu sinun mangin-uwa ta luputna. ");
INSERT INTO ksc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ad ummachuycha wi namantay an siya. ");
INSERT INTO ksc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ad innigkacha ko ta kros ta uulluwan Jesus na inyug-ischay impafasurchan siya, anana, “Annayà Jesus wi Alin na Judio.” ");
INSERT INTO ksc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ad illansacha kon chuway akkawan inchorag an Jesus wi osa ta apot ta chiwawanna ya osa ta apot ta chuwikina. ");
INSERT INTO ksc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Na takuy lummaus ta sachi, asiwiwingiwingcha wi nanginsurtun Jesus, wi anancha, ");
INSERT INTO ksc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Na! Anam met wi faasom na Templo ad asinnu patàchoron ta unog na turuy padcha! Siyan saraknifam na long-agnu! Ad nu tuttuway anà sian Apudyus, lumogsad-a ta sanati krosnu!” ");
INSERT INTO ksc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ad isun akon iningwan chachi pangpangun na papachi ya mangitudtuchu ta Lintog ya chachi namangpanguwon na Judio, wi inin-insurtucha kò siya anani, ");
INSERT INTO ksc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Finadnganan uchum, ngim achi pu makafachang ta long-agna! Ad anana met wi siyan Alin na kanà Israel! Siyan nu lumogsad ta krosna, patiyontau wi narpun Apudyus! ");
INSERT INTO ksc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Piyarona nù Apudyus, ya anana koy anà anu Apudyus. Siyan ilantau ud nu pion Apudyus wi manaraknib an siya ta sana!” ");
INSERT INTO ksc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ad uray chachi koy akkawan wi nailansa ko ta kros, sachi kon iningwachay manginsurtun siya. ");
INSERT INTO ksc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mamatù ad, fummulingot losan na luta ingkana ta ar-arkaw. ");
INSERT INTO ksc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ad na sachi, nampoaw à Jesus wi anana, “Eli, Eli, lama sabaktani?” Na mining na imfakana, “Apudyus-u, Apudyus-u, tam-akò saon man-awichan?” ");
INSERT INTO ksc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Chingngor pun chachi naag-agsad na imfakan Jesus, anan na uchum, “Ayakanà Elias!” ");
INSERT INTO ksc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sachi ad nanodchà na osa wi ummoy nangarà ispongha ad illunongna ta ilom ad impàtanna ta paur ta supsupan Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ngim ingkimaun na uchum anani, “Awniyan, ta ilantau nu umalin Elias saraknifan à siya!” ");
INSERT INTO ksc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ad asin nampoaw à Jesus, ad sachin anungus na angosna. ");
INSERT INTO ksc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ad na sachi, nan-agwa nakissay na sochorani kurtina wi nitatayyun ta Templo wi nanipud ta ngatu ingkana ta chora. Ad nanita kò napigsa ad natlà na chakorani fatu. ");
INSERT INTO ksc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ad naib-at akon lobrofon, ad ad-adchuwan na takun Apudyus wi nan-ootoy wi ummuli nataku, ");
INSERT INTO ksc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ad tinaynanchan lofoncha. Ad ummuli pu ko natakù Jesus, losancha ummoy ad Jerusalem, wi ad-adchuwan na takuy nangilan chicha ta sachi. ");
INSERT INTO ksc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ad na kapitan ya chachi susurchachuna wi namafantay an Jesus, ummogyatcha ta nangil-ancha ta losani nànàwa ya nallìnaancha ta chita, ad anancha, “Tuttuway siyan Anà Apudyus!” ");
INSERT INTO ksc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ad iningkaw akon ad-adchuwani fubfufai wi nan-oottap, wi chichan nitun-ud wi fummachang an Jesus ta narpuwanchad Galilea. ");
INSERT INTO ksc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Iningkaw an chicha cha Maria Magdalena, Maria wi inacha Jaime an Jose, ya asawan ako Zebedeo. ");
INSERT INTO ksc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mummaschom pun, chummatong na osay faknang wi iyArimatea wi mangngachan à Jose. Siya kon osay summurut an Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ad ummoyna chinawat an Pilato na lachag Jesus, ad intay-un Pilato. ");
INSERT INTO ksc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ad impas Jose na lachag Jesus ta kros ad finussungna ta lukaki uros. ");
INSERT INTO ksc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ad inyoyna illofon ta attukutukanay lofon. Ad linikadnan chakorani fatu intumar ta liwangan na lofon, ad lummayaw. ");
INSERT INTO ksc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ad cha Maria Magdalena ya osay Maria, iningkawcha wi ummaachuy ta sangwanan na lofon. ");
INSERT INTO ksc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nafikat pun ta Safachuy ngingillinan, naarus chachi pangpangun na papachi ya Fariseo ta foroy Pilato, ");
INSERT INTO ksc_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ad ananchan siya, “Apu, nasnasmònin imfakana ta atattakuwan na sachi tuliyani ananay umuli nu mataku ta miyatluy padcha. ");
INSERT INTO ksc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Siyan mamfaru nin nu umifaun-à umoy mamantay wi ustuustu ta lofonna ingkana ta miyatluy padcha, ta achin pun na disipulusna umoy ilayaw na lachagna ad ananchay ummuli nataku. Ad nu màwan amaschi, sillumawing nu umachun maturtulliyan wi taku nu chamu.” ");
INSERT INTO ksc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ad inapufaran Pilato anani, “Oo, anchanat na susurchachu, siyan iyoyyu chicha ta narmancha fantayan.” ");
INSERT INTO ksc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ad ummoycha ad nangwachà singyar ta liwangan na lofon ta akammuwoncha nu awad umoy mangib-at, ad impafantaycha ustuustu. ");
INSERT INTO ksc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Na amfikat na sachi Safachuy ngingillinan ta wiswisnit ta Chumingku, lummigwatcha Maria Magdalena ya sachi osay Maria wi umoy mangila ta lofon. ");
INSERT INTO ksc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Sachi ad nanità napigsa ad nan-osog na osay anghel Apudyus wi narpud langit ad linikadnan tangob na lofon ad ummachuyana. ");
INSERT INTO ksc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Na itchurana, isag sumiling wi isù ilat, ad na silupna, putilaan. ");
INSERT INTO ksc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ad na nangil-an chachi kuwarcha, namaypayogpogcha ta ogyatcha, ad nalitwadchay isù natoy. ");
INSERT INTO ksc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ngim anan na anghel ta fubfufai, “Achiayu umogyat. Akammù wi ummaliyu ilan à Jesus wi nailansa ta kros. ");
INSERT INTO ksc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ngim maid ad asna tan ummuli nataku wi siyan imfakanan chiayu. Wayyu ta ilanyun nifanatana. ");
INSERT INTO ksc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ad kanasonyu ta ing-ayu ifaka ta disipulusna, wi tuttuway ummuli natakù Jesus ad umuna umoy nu chicha ad Galilea ta aschin mangil-anchan siya! Achiyu maliwatan na imfakà an chiayu.” ");
INSERT INTO ksc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ad nan-itaynanchan lofon, wi annan ogyatcha ngim naragsakcha ko kapu ta chingngorcha. Ad nanodchàcha wi umoy mangifaka ta disipulusna. ");
INSERT INTO ksc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ngim inafotchà Jesus, ad ananan chicha, “Fumarun somsomòyu!” Ad nampalintumongcha ta sangwanana wi inognanchan ikina wi manayaw an siya. ");
INSERT INTO ksc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ad anan Jesus an chicha, “Achiayu umogyat. Ngim ing-ayu ifaka ta losani susunud-u ta umoychad Galilea ta aschin mangil-anchan saon.” ");
INSERT INTO ksc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Lummayaw pun na fubfufai ta lofon, na uchumi surchachuy nanguwarcha ta lofon, ummoycha ta ili imfaka ta chachi pangpangun na papachi na losani nànàwa. ");
INSERT INTO ksc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ad chachi pangpangun na papachi, inaruscha chachi namangpanguwon na Judio, ad nan-uukudcha nu sinun oyyooncha. Ad pinasuksukanchan susurchachù achù pilak ta isulibchan nànàwa. ");
INSERT INTO ksc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ad ananchay namilin an chicha, “Amasnan ifakayu ta taku. Nasusuyop-ayu pun ta lafi, ummalin disipulusna innaran lachagna. ");
INSERT INTO ksc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Achiayu machanakan nu chamakon na fifinnachur na nàwa, tan nangamung-ani wi mangisuplikar an siya ta losan, ta achi chiayu pafasuron.” ");
INSERT INTO ksc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ad innaran chachi susurchachun pilak ad tinungparchan nifakan chicha. Ad nanipud ta sachi, sachin nanchinamag ta losani Judio. ");
INSERT INTO ksc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ad chachi disipulus Jesus wi nasawaran à osa, ummoycha ta takudtud ad Galilea wi sachin imfakan Jesus à manib-atanan chicha. ");
INSERT INTO ksc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ad innilacha pun à siya, chinayawchà siya, uray nu manchuwachuwan uchum nu tuttuway Jesus. ");
INSERT INTO ksc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Sachi ad ummachanì Jesus an chicha anani, “Nipiyar an saon na fiyang ta losani awad ad langit ya asnay luta. ");
INSERT INTO ksc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Siyan ifaun-u chiayù umoy ta ailiili ta luta ta tudtuchuwanyun losani taku ta mamatichan saon ta mandisipulus-u chicha. Ad funyakanyu chicha ta ngachan Ama wi Apudyus, ya saoni Anàna, ya Ispirituna. ");
INSERT INTO ksc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ya itudtuchuyun chicha ta tungparonchan losani imfakà an chiayu. Ya sosom-onyuy iingkawà an chiayù ing-ingkana.”");
INSERT INTO ksc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Annayan Mamfaruy Chamag mipangkop an Jesu Cristu wi Anà Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Na nilukiyana siyan tummuttuwaan na inyug-is na profetay Isaias, “Anan Apudyus, ‘Awad na osay taku wi ifaun-u unaon nu sia ta umoyna mansakanaon na taku ta chongronchà sia.’ ");
INSERT INTO ksc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ingkaw à siya ta ikaw wi maid pu ili, wi mangip-ip-aw ta taku. Anana, ‘Annay chumatong na Apu. Pafaruwonyun somsomòyu ya mansakanaayu, wi isun na mangikakatan ta charan nu chumatong na Ali.’” ");
INSERT INTO ksc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ad nampailà Juan ta ikaw wi maid pu ili namfunyafunyag ya nantudtudtuchu ta taku, wi anana, “Masapur ifafawiyun fasuryu ya mampafunyag-ayu, ad pakawanon Apudyus chiayu.” ");
INSERT INTO ksc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ad ummoy na ad-adchuwani takuy chingngor à Juan, wi narpuchad Jerusalem ya ailiili ta provinsiya wi Judea. Ad imfafawichan fasurcha, ad finunyakan Juan chicha ta Chawwang wi Jordan. ");
INSERT INTO ksc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Na luput Juan, inafor wi chutchut na kamar, ya uglit na tàyadna, ad chuchun ya chilun aannona. ");
INSERT INTO ksc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ad ananay nangiwarwarawag ta taku, “Awad na umali wi misukat an saon wi nangatngatu nu saon, wi kurangà à mansaniluna. ");
INSERT INTO ksc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Chanum yakan ifunyag-un chiayu, ngim à siya, ifunyagnan chiayun Ispiritun Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Na sachi timpu, chummatong à Jesus wi narpud Nazaret wi ili ta provinsiya wi Galilea, ad ummoy nampafunyag an Juan ta sachi Chawwang wi Jordan. ");
INSERT INTO ksc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Lummoswa pù Jesus ta chanum, innilanay niwanit ad langit ad na Ispiritun Apudyus, nan-osog lummap-oy an siya wi isù karupati. ");
INSERT INTO ksc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ad iningkaw na kinga wi narpud langit, wi anana, “Sian anàu wi ay-ayatò. Maragsakanà an sia.” ");
INSERT INTO ksc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Sachi ad chinisan na Ispiritun Apudyus pin-oy à Jesus ta ikaw wi maid pu takù ingkaw. ");
INSERT INTO ksc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ad sachin namachasan Satan an siya makafasuron ta unog na opatpuruy padchay iningkawana ta sachi. Ad-adchuwan akon man-àachap ta sachi, ngim finadngan na aangheles à siya. ");
INSERT INTO ksc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nifarud pun à Juan wi Mamfufunyag, nangulin à Jesus ad Galilea nangitudtuchu ta Mamfaruy Chamag wi narpun Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Intudtuchuna, “Chinumtong na matuttuwaan na imfakan Apudyus, siyan chanchanin milukiyan na Manturayana! Fafawiyonyun fasuryu ya patiyonyun annayay Mamfaruy Chamag!” ");
INSERT INTO ksc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Na osay padcha, nanadchadcharan à Jesus ta tarantag na Fayfay ad Galilea, ad innilanan chuway mansunud wi cha Simon an Andres wi manakufur. ");
INSERT INTO ksc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ad ananan chicha, “Ichulinyunat ad mitun-ud-ayun saon ta sukatà na iwaaryu ta mamatiyonyun takun saon.” ");
INSERT INTO ksc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ad nan-itaynanchan takufurcha ad nitun-udchan siya. ");
INSERT INTO ksc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Naaaycha pù ait, innilana kon chuway mansunud wi cha Jaime an Juan wi anà Zebedeo, wi iningkawcha ta fangka wi amatonchan takufurcha. ");
INSERT INTO ksc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ad nan-iyayagnà chicha, ad nitun-udcha kon siya wi tinaynanchà amacha ta fangka ya chachi tinangchanancha. ");
INSERT INTO ksc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Sachi ad ummoycha Jesus ad Capernaum. Ad na Safachuy ngingillinan na Judio, linumnò à Jesus ta sinagogan na Judio nantudtuchu. ");
INSERT INTO ksc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ad naschaaw na losani nangngor ta pinagtudtuchuna, tan foon pù isun na pinagtudtuchun chachi mangitudtuchu ta Lintog, tan maila wi annan karobfonganay mantudtuchu. ");
INSERT INTO ksc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ad na sachi, linumnò ako ta sachi sinagoga na osay larai wi nakafarfaray. ");
INSERT INTO ksc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ad impoawna anani, “Siay Jesus wi iNazaret, sinun oyyoom an chiani? Ummalià manachail an chiani? Akammù à sia, wi sian sachi naapudyusan wi impustan Apudyus wi umali!” ");
INSERT INTO ksc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ngim impakinò Jesus na aran, “Kuminòa! Taynam na sanati finarfaraynu!” ");
INSERT INTO ksc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ad na aran, inwokawognan sachi larai ad kummingà chakoran, pun lummayaw. ");
INSERT INTO ksc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ad losan chachi nangiila, naschaawcha ad nan-asiimuscha, “Sinu kon anna? Adchatuy tudtuchu! Annan karobfongana, tan mafalinna paryawon na aran, ad patkonchà siya!” ");
INSERT INTO ksc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Sachi ad nanchinamag na mipangkop an Jesus ta losani ilid Galilea. ");
INSERT INTO ksc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Sachi ad lummawacha Jesus ta sinagoga, ad ummoycha ancha Jaime ya Juan ta foroycha Simon an Andres. ");
INSERT INTO ksc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nasakit na atukangan Simon, wi amod na panatingna, siyan imfakachan siya. ");
INSERT INTO ksc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ad ummoy à Jesus ta nasuypana ad inognanan imana wi namangon an siya, ad naaan na panatingna. Ad sinakunganà chicha. ");
INSERT INTO ksc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mummaschom pun, inchatong na takun siyan losani nasakit ya nakafarfaray. ");
INSERT INTO ksc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ad losan na taku ta sachi ili, naaruscha ta paway na sachi foroy. ");
INSERT INTO ksc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ad inaan Jesus na nangkarakarasi wi sakit na achuy taku, ya pinaryawna kon achuy aran, ad impakinòna kon aran tan inakammucha wi siyan Cristu. ");
INSERT INTO ksc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Anna puni machanchani mawisnit, fummangon à Jesus ad ummoy naos-osa nalluwaru ta ikaw wi maid pu takù ingkaw. ");
INSERT INTO ksc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ngim ummun-unudcha Simon ya fufurunna wi nanganaanap an siya, ");
INSERT INTO ksc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ad inchasancha pun, ananchan siya, “Imuson sia ta losan taku.” ");
INSERT INTO ksc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ngim ananan chicha, “Masapur intau ta uchumi ili ta inyà ako tudtuchuwan chicha, tan siyan pangkop na ummaliyà ad asnay luta.” ");
INSERT INTO ksc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ad ummoy à Jesus ta ailiilid Galilea nantudtudtuchu ta taku ta sinagogacha ya namparyaw ta aran wi farfaray. ");
INSERT INTO ksc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Iningkaw na osay nakollakong wi ummoy nampalintumong wi nampangpangngaasin siya, ad anana, “Patiyò wi annan karobfongami mangaan ta annayay sakit-u, siyan nu kaasiyanà, paimfakonà.” ");
INSERT INTO ksc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ad kinaasiyan Jesus à siya ad inyaragwadnan imanan siya, ad anana, “Oo, kaasiyà sia. Maaan na sakitnu!” ");
INSERT INTO ksc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ad naanimfag à siya ad fummaru. ");
INSERT INTO ksc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ad finilin Jesus à siya, “Lumayaw-a. ");
INSERT INTO ksc_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Achim ug-ugkuchon ta sinuman, ngim ing-a mampaila ta pachi, ad manchatun-a tan sachin illintog Moses à manuttuwaan na taku wi naaan na sakitnu.” ");
INSERT INTO ksc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ngim lummayaw pun, inwarawarawagnan iningwan Jesus an siya, siyan ad-adchuwan na takuy nangngor ta mamfaruy ining-ingwan Jesus. Siyan achì pu Jesus mampaila umoy ta ili, ad inaptiwna ta ikaw wi maid pu taku. Ad ummon takun siya wi narpu ta ailiili. ");
INSERT INTO ksc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Naarkawanan ad, namagkulin à Jesus ad Capernaum, ad nanchinamag wi chummatong. ");
INSERT INTO ksc_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Siyan naarus na ad-adchuwani taku ta foroy ingkanà maid pu màkawan na uchum uray na sòfan. Ad intudtuchun Jesus na ukud Apudyus an chicha. ");
INSERT INTO ksc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ad chummatong akon opati lallarai wi fillikanchan osay naayayongi larai ta ipasangucha kuman Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ngim maid pu in-inonchay mangiyachanin siya an Jesus tan nanapnun taku. Siyan inafutanchan otop na foroy wi fatug Jesus, ad inchòorachan nifafàsar wi naayayong ta sangwanana. ");
INSERT INTO ksc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ad inakammun pu Jesus wi napigsan pammatichan siya, anana ta naayayong, “Sunud, napakawan na fasurnu.” ");
INSERT INTO ksc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ngim na uchumi mangitudtuchu ta Lintog wi ummaachuy ta sachi, nan-asiakitùtùcha anani, ");
INSERT INTO ksc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Sinun karobfongan na sanat wi iyisunan long-agnan Apudyus! Tan maid makapakawan ta fasur nu achi afus à Apudyus!” ");
INSERT INTO ksc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ngim inakammun Jesus na somsomòcha, siyan ananan chicha, “Tamako ta amaschin somsomòyu? ");
INSERT INTO ksc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Sinun mallanlanuy à ifaka, ‘Napakawan na fasurnu,’ winnu ‘Lumigwat-a, aram na ofognu ad manadcharan-a’? ");
INSERT INTO ksc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","À saon wi namfalin taku, panoknokà an chiayu wi annan karobfongà ad asnay luta wi mamakawan ta fasur.” ");
INSERT INTO ksc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ad anana ta sachi naayayong, “Ifakà an sia, lumigwat-a, aram na ofognu ad lumayaw-a!” ");
INSERT INTO ksc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ad na nangiil-an na losani takun siya, lummigwat pun innaranan ofogna ad lummayaw. Ad naschaawcha losan, ad chinaychayawchà Apudyus anani, “Maid pun innilataù isun na annaya!” ");
INSERT INTO ksc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ad ummoy asin à Jesus ta tarantag na Fayfay wi Galilea. Ad naarus na achuy takun siya, ad tinudtuchuwanà chicha. ");
INSERT INTO ksc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ad na lummayawana ta sachi, innilanà Levi wi anà Alfeo wi ummaachuy ta pisinanay manchachakup à fukis. Ad anan Jesus an siya, “Mitun-ud-an saon.” Ad narnigwat à Levi wi nitun-ud an siya. ");
INSERT INTO ksc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Anna puni mangancha Jesus ya disipulusna ta foroycha Levi, ummoy ako nakaan na achuy fufurun Mateo wi manchachakup à fukis ya uchumi takuy managfasur, tan ad-adchuwan na nitun-ud an siya. ");
INSERT INTO ksc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ad na nangil-an na uchumi mangitudtuchu ta Lintog, wi Fariseo ko, wi nakaan à Jesus ta managfasur ya manchachakup à fukis, inimuscha ta disipulusna, “Tamako makaan ta kakassanay taku?” ");
INSERT INTO ksc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Chingngor pu Jesus chicha, sinongfatana chichà alig, anana, “Na takuy maid sakitna, foon pù masapurchan chuktur. Siya makasapur na nasakit. Na ummaliyà ad asnay luta, foon à tudtuchuwà na mamfaruy taku ngim siya ummaliyà na tudtuchuwà na managfasur.” ");
INSERT INTO ksc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Na namingsani nallangan wi nangan na disipulus Juan wi Mamfufunyag ya chachi Fariseo, ummoy na uchumi taku an Jesus ad inimuscha, “Na disipulus Juan ya chachi disipulus na Fariseo, mallanganchay mangan, ngim tamakon disipulusnu foon pù mallanganchay mangan?” ");
INSERT INTO ksc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ad nan-alig à Jesus wi summongfat, anana, “Mallangan lawan takuy makakasar wi mangan nu awad an chichan larai wi mikasar? Mangancha met! Tan nu awad an chichan larai wi mikasar, foon pù mallanganchay mangan. ");
INSERT INTO ksc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ngim chumatong na timpuy milayawan na nikasar, ad sachin mallangananchay mangan.” ");
INSERT INTO ksc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ad asin nan-alig à Jesus wi anana, “Maid pu takù itàrupnan lukaki luput ta pallos. Tan nu kumsin na lukaki luput, maakusut na tàrup ad am-amchonan nakissay. ");
INSERT INTO ksc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Maid pu ko mangifungufung à inafuyu ta chachaani uglit wi isù amutu, tan fumtak na uglit ad mayam-an na uglit ya mifallu kon fayas. Ngim na inafuyu, siya mifungufunganan àoyyay uglit wi amutu.” ");
INSERT INTO ksc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Na namingsani Safachuy ngingillinan na Judio, nangoycha Jesus ya disipulusna ta pappayaw wi namur-an à wheat wi isù pakoy, ad lummapid na disipulusnà utimancha. ");
INSERT INTO ksc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ad anan na Fariseo an Jesus, “Ilam, tamako ta amaschiyoncha wi mipalit ta Lintogtau nu Safachu?” ");
INSERT INTO ksc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ad anan Jesus an chicha, “Achiyu pu nafasan iningwacha David ya fufurunna ta nafitilancha ta awi? ");
INSERT INTO ksc_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tan linumnò ta sachi mangngachani foroy Apudyus ad inaranan tinapoy wi nichatun an Apudyus, wi ipalit na Lintog à anoncha tan afus kuman papachì mangan, ad innancha ta fufurunna. (Na sachi timpu, Abiatar na Angatuwani Pachi.)” ");
INSERT INTO ksc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ad anan ako Jesus, “Masapur maawatanyu wi na Safachuy ngingillinan, iningwan Apudyus à fumaruwan na taku, wi foon pù iningwanan takù fumaruwan na ngingillinan. ");
INSERT INTO ksc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ad à saoni namfalin taku, annan karobfongà wi mangifaka ta sinuy màwa ta uray Safachuy ngingillinan.” ");
INSERT INTO ksc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Na osay Safachu, linumnò akò Jesus ta sinagogan na Judio. Ad niyaspur wi iningkaw na osay larai wi naayayong na osay imana. ");
INSERT INTO ksc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ad iningkaw akon uchumi man-anaanap à mangicharumanchan Jesus, siyan sinipsiputancha nu paimfakonan larai ta Safachuy ngingillinan. ");
INSERT INTO ksc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ad anan Jesus ta sachi larai, “Waynu ta annay sangwanan.” ");
INSERT INTO ksc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ad anan Jesus an chicha losan, “Sinun iparufus na Lintogtau wi màwa ta Safachu? Mangwataù mamfaru winnu lawing? Takuwontaun taku winnu patoyontau?” Ngim akikinnòcha. ");
INSERT INTO ksc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ad linangrangana chicha losan, wi ummog-ot ta nangil-anan chicha, ngim ummachaku kon chicha tan achicha pu matudtuchuwan. Sachi ad anana ta larai, “Uyachom na imam.” Ad inuyadna, ad fummarun imana. ");
INSERT INTO ksc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ad lummayaw chachi Fariseo ad ummoycha ta takun Herod puranuwon na mamatayanchan Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ummoycha Jesus ya disipulusna ta tarantag na fayfay, ad nitun-ud akon ad-adchuwani taku wi narpud Galilea, Judea, ");
INSERT INTO ksc_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem ya Idumea, ya iningkaw akon uchum wi narpu ta chomang na chawwang wi Jordan ya uchumi narpu ta sakupon Tiro ya Sidon. Ummalicha losan ilan à Jesus tan chingngorchan ining-ingwana. ");
INSERT INTO ksc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ad kapu ta aachun na taku, imfakan Jesus ta disipulusna ta isakanachan fangkà ingkawana ta achi pu maslikan ta chachi taku. ");
INSERT INTO ksc_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tan kapu ta nangaanana ta achuy sakit, ad-adchuwan na uchumi nasakit wi nansusulig an siya ta agpachancha kumà siya. ");
INSERT INTO ksc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ad chachi koy nakafarfaray wi nangilan siya, nampalintumongcha ta sangwanana ad nampoawcha anani, “Sian anà Apudyus!” ");
INSERT INTO ksc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ngim finilinna chachi farfaray ta achicha kuma ifagfakan na mipangkop an siya. ");
INSERT INTO ksc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ummoy summang-at à Jesus ta osay takudtud, wi inayakanan takuy pilliyana, ad ummoychan siya. ");
INSERT INTO ksc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ad chinutukanan nasawaran à chuwà mamfurunna, ta chichan ifaunna wi umoy mangitudtuchu ta Mamfaruy Chamag. Ad nginadnana chichà apostoles, ");
INSERT INTO ksc_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ad inadchanà chichà karobfongan à mangiparyaw ta aran wi farfaray. ");
INSERT INTO ksc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Anchanayan chinutukanay nasawaran à chuwa: Simon (nginachanan Jesus à siyà Pedro); ");
INSERT INTO ksc_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","cha Jaime an Juan wi anà Zebedeo (nginachanan Jesus chichà Boanerges, wi na miningna, “Anà na Ichur”); ");
INSERT INTO ksc_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andres, Felipe, Bartolome, Mateo, Tomas, Jaime wi anà Alfeo, Tadeo, Simon wi ananchay Mangipapakat, ");
INSERT INTO ksc_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ya Judas Iscariote wi siyan nangififik an Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Sachi ad lummayaw à Jesus, ad asin akon ad-adchuwani taku naarus, siyan à Jesus ya disipulusna, maid pun in-inonchay nangan. ");
INSERT INTO ksc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Chingngor ad na faryannan ining-ingwana, ummoycha ta ilayawcha kumà siya, tan anan na uchumi taku wi natingtingangan anù Jesus! ");
INSERT INTO ksc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ad na uchumi mangitudtuchu ta Lintog wi narpud Jerusalem, anancha ko, “Nakafarfaray à Jesus ta pangpangun na aran wi Beelzebub, ad siyan nangatod an Jesus ta karobfonganay mangiparyaw ta aran!” ");
INSERT INTO ksc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ad inarus Jesus na taku, ad nan-alig wi anana, “Mafalini iparyaw Satan na long-agna? ");
INSERT INTO ksc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Uray sinuy turay, nu foon à mantitimpuyug na taku, wi kanayuncha mantintinnanung wi mampapatoy, foon pù chumakus wi mauummung à osà ili. ");
INSERT INTO ksc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ad nu maid timpuyug na simfaryan, wi kanayuncha mantintinnanung wi mansusukob, mansisiyancha. ");
INSERT INTO ksc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ad nu makapatoy à Satan ta akin-aaranna, wi maid pu timpuyugcha, kapilitani maafakcha losan ad mapagpag na karobfongancha. ");
INSERT INTO ksc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Maid pu makarnò ta foroy na oschorani taku wi mangara ta ochonna nu achina unaon faruchan na oschorani taku achiwot manamsam ta ochonna. ");
INSERT INTO ksc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Tuttuwan ifakà an chiayu, na losani fasur na taku, mafalini mapakawan, wi uray na mangifag-ancha ta lawing mipangkop an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ngim na mangifakà lawing mipangkop ta Ispiritun Apudyus, achi pu mafalini mapakawan à ing-ingkana.” ");
INSERT INTO ksc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Imfakanan sachi tan iningkaw na uchumi nangifaka wi Satan anun narpuwan na karobfongana, wi foon pu nù Ispiritun Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Sachi ad chummatong na inan Jesus ya susunudna, ad iningkawcha ta paway wi nangipaayag an Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ad na achuy taku wi naarus an siya, imfakachan siya, “Noy! Anchanat anun inam ya susunudnud paway, ad paayagchà sia.” ");
INSERT INTO ksc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ad sinongfatana anani, “Oo, ngim foon pu kà chichan ifilang-ù inà ya susunud-u.” ");
INSERT INTO ksc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ad linangrangana chachi nakaachuy an siya, ad anana, “Chicha kon ifilang-ù inà ya susunud-u! ");
INSERT INTO ksc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tan sinumani mangwa ta pion Apudyus, chicha kon ifilang-ù susunud-u ya iinnà!” ");
INSERT INTO ksc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Asin akò Jesus ummoy nantudtuchu ta tarantag na fayfay. Ad kapu ta ad-adchuwan na takuy naarus, linumnò à Jesus ta osay fangka ad sachin tummùchuwana, ad iningkaw na taku ta tarantag wi manchongor. ");
INSERT INTO ksc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ad achun intudtuchunan chicha wi nan-alig. Ad na nantudtuchuwanan chicha, anana, ");
INSERT INTO ksc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Chongronyuna! Iningkaw na osay taku wi ummoy nawwakawag à fuor. ");
INSERT INTO ksc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ad na nawwakawana, nanchissun uchumi fuor ta charan ad ummon sissiwit innan. ");
INSERT INTO ksc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Na uchumi fuor, nanchissu ta fattufattu wi ait na luta, siyan nallasun summimitancha. ");
INSERT INTO ksc_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ngim umminit pun naryawcha ad narangucha tan maid pu lummamutancha. ");
INSERT INTO ksc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Na uchumi fuor, nanchissu ta tartallurung ad tummufucha. Ngim inilung na tarurung, siyan achi pun namusfus. ");
INSERT INTO ksc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ngim na uchumi fuor, nanchissu ta malloma ad kanasan na tummufuwancha, ad namungacha losan wi turumpurun fungan na uchum, ya onompuru ya singkasut na uchum.” ");
INSERT INTO ksc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ad inyanungus Jesus anani, “Naingaan-ayu, siyan somsom-onyu kuman mining na alig-u!” ");
INSERT INTO ksc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Naab-afus pù Jesus, ummoy na uchumi nangngor ya chachi nasawaran à chuway disipulusnan siya, ad inimuscha nu sinun mining na aligna. ");
INSERT INTO ksc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ad anana, “Losani chaan pù maakammuwan wi mipangkop ta Manturayan Apudyus, afus-ayù mipaakammuwana. Ngim chachi uchum wi achi pu mamati, alig yakan mifakan chicha. ");
INSERT INTO ksc_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Uray iillancha, achicha pu ilasin. Ya uray chochongroncha, achicha pu maawatan. Tan nu anaponcha ta maawatancha, mansakungchan Apudyus, ad pakawanona chicha.’” ");
INSERT INTO ksc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Sachi ad anan Jesus an chicha, “Nu achiyu pu maawatan na annayay alig, sinun in-inonyu wi mangawat ta uchumi alig-u? ");
INSERT INTO ksc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Na miyalikan na fuor wi niwakawag, ukud Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ad na isun na nanchissuwan na fuor ta charan, chichan takuy nangngor ta ukud Apudyus, ngim chakusi ummoy Satan inallilaw na chingngorcha. ");
INSERT INTO ksc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ad na isun na nanchissuwan na fuor ta fattufattu, chichan takuy naragsak wi nangamfuruy ta ukud Apudyus ta nangngorancha. ");
INSERT INTO ksc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ngim foon pù lummamut an chicha, siyan foon à nanakus. Tan inumchas pun na napoblimaancha ya napalikatancha kapu ta namatiyancha, achicha pu nakaanus siyan inwarangcha. ");
INSERT INTO ksc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ad na isun na nanchissuwan na uchumi fuor ta tartallurung, chichan takuy nangngor, ");
INSERT INTO ksc_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ngim isù nailung na chingngorcha. Tan kapu ta patkanchan mangar-ancha ta masapurcha ta annay mafiyakancha ta sana, ya kapu ko ta pionchay fumaknang, ya pionchay manonsosonson ta sinuman, sachin isù nangilung ta somsomòcha an Apudyus, siyan maid pu nafalinan na pammaticha. ");
INSERT INTO ksc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ngim na isun na nanchissuwan na uchumi fuor ta malloma, chichan takuy nangngor ta ukud Apudyus ad pinaticha, siyan namungan pammaticha, wi turumpurun imfungan na uchum, ya onompuru ya singkasut na uchum.” ");
INSERT INTO ksc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ad anan ako Jesus wi nan-alig, “Nu awad mamaskid ta silaw, tab-unana ta kasun? Winnu igkana ta chukun na katli? Foon pun, tan mipatay ta ustuy papattayana! ");
INSERT INTO ksc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Somsom-onyuna, na losani nitataru ta sana, mallotaw à tapin na padcha. Ya uray na losani foon pù maakammuwan ta sana, chumatong akon mipaakammuwana. ");
INSERT INTO ksc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nu naingaan-ayu, maawatanyu kuman annay chingngoryu!” ");
INSERT INTO ksc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ad anana kon chicha, “Masapur tatanchaananyun annayay ifakà, wi na oyyoonyu ta uchum, sachi kon oyyoon Apudyus an chiayu, ngim sin-umamod na inyòoyyana. ");
INSERT INTO ksc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tan na takuy mangwa ta chongrona, machog-achog-an na maawatana. Ngim na takuy foon pù oyyoonan chingngorna, maaan na uray aiti naawatana.” ");
INSERT INTO ksc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ad asin nan-alig à Jesus wi anana, “Na osay miyalikan na Manturayan Apudyus, isun na osay taku wi ummoy nawwakawag à fuor ta lutana. ");
INSERT INTO ksc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ad nasuyop ta linafi ad fummangon ta finigfikat. Ad na murana, summimit ya chumakochakor, ngim foon pù akammun chi taku nu sinun in-inon na tummufuwana. ");
INSERT INTO ksc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Na luta, siyan nangipatufu ta murà mamungaana, wi na chamu, sumimit ad mailan tufuna. Sachi ad illukinay mafuki achiwot mamusfus. ");
INSERT INTO ksc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ad nu nar-um, ummoyna inani tan timpun na inyàani.” ");
INSERT INTO ksc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sachi ad inimus Jesus, “Sinun miyisuwan na Manturayan Apudyus? Sinun ustuy miyalikana? ");
INSERT INTO ksc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Na osay miyalikana, amasna. Nimuran osay fuor wi mustard, wi akàitan ta losani fuor, ta luta. ");
INSERT INTO ksc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ngim nu chumakor, siyan achakran ta losani mura, wi man-anachun pangana, ad mamfalini manùfutan na sissiwit.” ");
INSERT INTO ksc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Amaschi kon nangitudtuchuwan Jesus ta ukud Apudyus wi alig na achù usarona, ta awad an chicha nu maawatancha. ");
INSERT INTO ksc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kanayuni alig na usaronay manudtuchun chicha, ngim nu ummafuscha ta disipulusna, insuplikarnan chichan mining na losani inyaligna. ");
INSERT INTO ksc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mummaschom pun ta sachi padcha, imfakan Jesus ta disipulusna, “Manchormangtau.” ");
INSERT INTO ksc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Sachi ad tinaynanchan ad-adchuwani taku, ad nallukancha ta fangka wi ummaachuyan Jesus. Ad iningkaw akon uchumi namfangka wi nitun-ud an chicha. ");
INSERT INTO ksc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Napapannos ad, nammaag fummalì napigsa. Ad nasàchusàchuwan na fangkà chanum ta amochi challuyun ingkanà nganngani milutong. ");
INSERT INTO ksc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ngim namupungngan wi nasuyop à Jesus ta audchiyan na fangka. Siyan finangonchà siya ad anancha, “Misturu, apay achim pu mangwaani annay milutongtau?” ");
INSERT INTO ksc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ad fummangon à Jesus ad pinakinònan fali ya challuyun, ad asin tummuyong na fayfay. ");
INSERT INTO ksc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Sachi ad anan Jesus ta disipulusna, “Taayuko machanakan? Chaanyu pu kà saon piyaron?” ");
INSERT INTO ksc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ad naschaawcha losan, ad nan-asiakitùtùcha, anani, “Sinun annay taku, wi uray na fali ya challuyun, patkonchà siya?” ");
INSERT INTO ksc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ad chummatongcha ta chomang na sachi fayfay, wi sakupon Gerasa. ");
INSERT INTO ksc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ad lummogsad pun à Jesus ta fangka, nisib-at an siyan osay larai wi nakafarfaray, wi narpu ta lorobnan, ");
INSERT INTO ksc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","wi sachin iningkawana. Oschoran à siya, wi maid pu makakachilan siya. ");
INSERT INTO ksc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tan uray nu makachilaan na imana ya ikina, koskosatonan kachilana. Maid pu osà nakaipukod an siya. ");
INSERT INTO ksc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ad na pinadcha ya linafi, nangkagkagkaay ta lobrofon ya filfilig wi nampoapoaw, ya sinukasukatnan long-agna ta fatu. ");
INSERT INTO ksc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ngim intapna pun à Jesus, nanodchà ummoy nampalintumong an siya. ");
INSERT INTO ksc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ad anan Jesus ta aran wi farfaray na larai, “Lumayaw-an siya, siay aran!” Ad na aran, impoawna anani, “Jesus wi Anà Apudyus wi Angatuwan, sinun oyyoom an saon? Mampangpangngaasiyà mipakapun Apudyus ta achiyà palikatan!” ");
INSERT INTO ksc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","“Sinun ngachannu?” inimus Jesus. Ad summongfat chi nakafarfaray wi anana, “Kaachuwan na ngachan-u, tan ad-adchuwan-ani!” ");
INSERT INTO ksc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ad nampangpangngaasi ta achicha kuma miparyaw ta sachi ili. ");
INSERT INTO ksc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na sachi, niyaspur wi iningkaw na ad-adchuwani forò wi asisusubsub ta takudtud. ");
INSERT INTO ksc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","“Ipaoynù chiani ta anchachiyay forò ta awad ingkawanni,” ananchay nampangpangngaasi. ");
INSERT INTO ksc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ad imparufus Jesus. Ad tinaynanchan sachi larai, ad ummoycha nallonog ta chachi forò wi nasuruk à chuway lifu. Ad asitotodchàcha wi ummoy lummayug ta chopras ad naanudcha losan ta fayfay. ");
INSERT INTO ksc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Na takuy namanfantay ta forò, ummawidcha losan ad impachamagcha ta ili ya foforoy wi nampalìwos. Sachi ad lummigwat na achuy taku wi ummoy nangila ta nàwaana. ");
INSERT INTO ksc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ad na chummatnganchan Jesus, innilachan sachi larai wi tinaynan na aran wi nakasilup ya tummutùchu wi fummarun somsomòna. Ad ummogyatcha losan. ");
INSERT INTO ksc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Sachi ad asin chachi nangiila inisturyan nànàwa ta sachi nakafarfarayi larai ya forò. ");
INSERT INTO ksc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ad nampangpangngaasichan Jesus ta lumayaw kuma ta sachi ilicha. ");
INSERT INTO ksc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ad na sumaayana ta fangka, nan-àarù chi larai wi nakafarfaray ta mifurun akon siya. ");
INSERT INTO ksc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ngim inisì Jesus wi anana, “Ing-a ta ilim, ta ifakam ta aagkim na losani iningwan Apudyus wi namachang an sia ya nangachakuwanan sia.” ");
INSERT INTO ksc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ad lummayaw chi larai wi ummoy ta il-ili ta sakup Decapolis ad inisturyanan losani iningwan Jesus an siya. Ad naschaaw losan na taku wi nangngor. ");
INSERT INTO ksc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nangulin pù Jesus wi namfangka ta chomang na fayfay, ad-adchuwan na takuy naarus an siya ta tarantag. ");
INSERT INTO ksc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ad chummatong akon osay pangpangun na sinagogan na Judio, wi nangngachan à Jairo, ad innilana pun à Jesus, nampalintumong an siya ");
INSERT INTO ksc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ad nampangpangngaasi wi anana, “Akin-ottoyon na anàuy fafarasang. Ngim nu umalim agpachan à siya, maaan na sakitna ad mataku!” ");
INSERT INTO ksc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ad nifurun à Jesus an siya. Ad ad-adchuwan akon nitun-ud an Jesus wi mansususulig. ");
INSERT INTO ksc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Iningkaw akon osay fufai wi nasakit à chumarachara ta unog na nasawaran à chuway tawon. ");
INSERT INTO ksc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Inag-akasan na ad-adchuwani chuktur à siya, ad naamin nakastun ùuwana, ngim naam-am-amod na sakitna. ");
INSERT INTO ksc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ngim chingngornan mipangkop an Jesus, siyan ummoy niyamung ta uchumi taku, ");
INSERT INTO ksc_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","tan na somsomòna, anana, “Uray nu agpachà yakan silupna, umimfakà.” ");
INSERT INTO ksc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ad na nangagpachana ta silup Jesus, chakusi inwarangnay chumara, ad nalìnana wi naaan na sakitna. ");
INSERT INTO ksc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ad à Jesus, linìnana wi nausar na karobfongana, siyan nantuwili ad inimusna ta taku, “Sinun nangagpad ta silup-u?” ");
INSERT INTO ksc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ad anan na disipulusna, “Tammako imuson na nangagpad an sia, wi ad-adchuwan na takuy mansususulig?” ");
INSERT INTO ksc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ngim nallangrangà Jesus wi manganap nu sinun nangagpad an siya. ");
INSERT INTO ksc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ad kapu ta inakammun chi fufain nàwan siya, namaypayogpog ta ogyatna ad ummoy nampalintumong an Jesus, ad imfakanan katuttuwaan. ");
INSERT INTO ksc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Siyan anan Jesus an siya, “Sunud, mipakapu ta pammatim an saon, ummimfag-a. Siyan fumarun somsomònu. Achi pu umulin sakitnu.” ");
INSERT INTO ksc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Na nan-ug-ugkuchan Jesus, chummatong na osay fabfaun wi narpu ta foroycha Jario, ad ananan Jairo, “Nar-us natoy na anànu, siyan apay taktakontaun Misturu?” ");
INSERT INTO ksc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ngim foon pù atinguron Jesus na imfakacha, tan ananan Jairo, “Achia machanakan. Piyarom à saon.” ");
INSERT INTO ksc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ad impalit Jesus na mitun-uchan na taku naraksig cha Pedro ya Jaime an Juan wi mansunud. ");
INSERT INTO ksc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ad na chummatngancha ta foroy Jairo, innilan Jesus wi asiiifilcha wi maid anungnungana. ");
INSERT INTO ksc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ad linumnò à Jesus ad charom, ad inimusna ta chachi taku, “Sinun oyyoonyuy maid anungnungana ya tayuko asiiifil? Foon pù natoy na fafarasang. Nasusuyop yakay!” ");
INSERT INTO ksc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ngim inam-amangchà siya. Sachi ad imparawana chicha, ad inayakanan ama ya inan chi natoy, ya chachi turuy disipulusna, ad ummoycha ta charom wi nifafannatan na natoy. ");
INSERT INTO ksc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ad inognanan imana ad anana, “Talita kum!” Na mining na sachi, “Anà, ifakà an sia, fumangon-a!” ");
INSERT INTO ksc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ad nafanangon à siya, ad nanadcharan. (Nasawaran à chuwan tawonna.) Ad isag naschaaw na chakorna. ");
INSERT INTO ksc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ngim finilin Jesus chicha losan ta achicha ifagfakan nàwa, ad anana kon chicha, “Paananyù siya.” ");
INSERT INTO ksc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Lummayaw à Jesus ta sachi ili ad nangulin ad ilina wi nakaoy akon disipulusna. ");
INSERT INTO ksc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ad na Safachuy ngingillinan, ummoy à Jesus ta sinagoga wi nantudtuchu. Ad na achuy taku, naschaawcha ta pinagtudtuchuna. Ad anancha, “Sinun nangacharana ta sanati itudtuchuna? Ya sinu kon nangar-ana ta kinaraingna ya karobfonganay mangwà kaskaschaaw? ");
INSERT INTO ksc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Siyan sachi mangkakaob, wi anà Maria, wi sunudcha Jaime, Joses, Judas ya Simon! Ad anchana ko ad asnan susunudnay fubfufai!” Ad achicha pu patkon à siya. ");
INSERT INTO ksc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Siyan anan Jesus an chicha, “Tuttuway uray sinuy ili wi umayan na profetan Apudyus, lispituwon na takù siya. Ngim na mismuy kailiyana ya uray na aagkina ya faryanna, achicha pu lispituwon à siya.” ");
INSERT INTO ksc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Siyan kapu ta achicha pu patkon à siya, maid in-inonay mangwà kaskaschaaw ta sachi. Ààiyut yakan nasakit wi inagpachana, ad naaan na sakitcha. ");
INSERT INTO ksc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ad naschaaw à Jesus tan achi pun na taku mamatin siya. Sachi ad kinagkagkaay Jesus na ailiili ta sachi wi nantudtuchu. ");
INSERT INTO ksc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ad inarusna chachi nasawaran à chuway disipulusna, ad innadchonan chichan karobfongancha wi mangiparyaw ta aran wi farfaray na taku, ad sininchuwwana finaun chicha. ");
INSERT INTO ksc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Finilinnà chicha, “Achiayu mangaw-it à uray sinuman ta mamfiyasiyanyu, afus na sur-udyu. Achiayu mangawit à anonyu, achiayu mampasiing, ya achiayu ko mamfarun à pilak. ");
INSERT INTO ksc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mansapatus-ayu, ngim achiayu mangawit à sukat na luputyu.” ");
INSERT INTO ksc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ad anana kon chicha, “Nu awad mammangilin chiayu, ingkaw-ayu ta foroyna ingkanà lumayawanyu ta sachi ili. ");
INSERT INTO ksc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ad nu kaspangalikan awad ilì maid pu mammangilin chiayu ya achicha pu chongron na itudtuchuyu, tòakonyun tapuk ta ikiyu ta lumayawanyù mangakammuwancha wi ikadcha ta machusaancha!” ");
INSERT INTO ksc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ad ummoycha itudtuchu ta taku wi masapur mamfafawicha ta fasurcha. ");
INSERT INTO ksc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ad imparyawchan ad-adchuwani aran ta nakafarfaray, ad linankanchan achuy nasakit ad impaimfagcha chicha. ");
INSERT INTO ksc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","À Ali Herod, chingngornan mipangkop an Jesus, tan ug-ugkuchon na takun ining-ingwana. Anan na uchumi taku, “Siyà Juan wi Mamfufunyag wi ummuli nataku, tan sachin karobfonganay mangwà kaskaschaaw.” ");
INSERT INTO ksc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ad anan na uchum, “Siyà Elias.” Ad na uchum ako, anancha, “Siyan osay profeta wi isun chachi profetas ta awi.” ");
INSERT INTO ksc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ngim chingngor pun Ali Herod na amaschi, anana, “Siyà Juan wi impasiwat-u! Ummuli nataku!” ");
INSERT INTO ksc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Na sachi Herod, siyan nampatiliw an Juan ya nangipafarud an siya. Amaschin iningwana mipakapun Herodias wi asawan na sunudnay Felipe, tan inasawan ako Herod à siya. ");
INSERT INTO ksc_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Siyan imfakafakan Juan an Herod anani, “Maid karobfongam wi mangasawa ta asawan na sunudnu!” ");
INSERT INTO ksc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ad kapu ta sachi imfakan Juan, isag Herodias linawing à Juan, ad pionay papatoy à siya. Ngim maid pu in-inona, ");
INSERT INTO ksc_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","tan à Herod, ummogyat an Juan tan illasinna wi mamfarù Juan ya naapudyusan ako. Siyan finafantayanà siya. Ngim na nangngorana ta itudtuchun Juan, pionay chongron à siya uray nakulikur na somsomòna. ");
INSERT INTO ksc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ngim chummatong na wayan Herodias. Tan na padchay manayawancha ta niyanaan Herod, impasakanan Herod na chakor wi lagsak ad inimfitarnan losani fufurunnay turay na kufilnu ya papangat na susurchachu, ya nangangatuy takud Galilea. ");
INSERT INTO ksc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Ad nansaran anà Herodias wi fafarasang, ad naragsakancha Herod wi mamfufurun. Siyan anan Herod an siya wi nansapata, “Uray sinuy piom, ifakam an saon ta adchò an sia, wi uray na kogwan na kina-alì!” ");
INSERT INTO ksc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Sachi ad lummawan sachi fafarasang ad ummoyna inimus an inana, “Sinun chawatò?” Ad na insongfat inana, “Chawatom na urun Juan wi Mamfufunyag.” ");
INSERT INTO ksc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ad napanagkulin chi fafarasang an Herod, ad anana, “Na piò, adchom an saon ta sana na urun Juan wi Mamfufunyag, wi mapapallangkan!” ");
INSERT INTO ksc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nansasàuy à Herod ta sachi, ngim kapu ta insapatana ta sangwanan na losani mangilina, mafain à Herod wi mangisì. ");
INSERT INTO ksc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Siyan finaunnan osay surchachuna wi kuwarcha ta umoy mangara ta urun Juan. Siyan ummoyna siniwat na urun Juan ta fafalluchan. ");
INSERT INTO ksc_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ad inchatongna inadchon na uru wi naparangkan ta fafarasang. Ad chi fafarasang, innadchonan inana. ");
INSERT INTO ksc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Chingngor ad na disipulus Juan na nàwan siya, ummoycha inaran lachagna ad illofoncha. ");
INSERT INTO ksc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ad nangulin na apostoles an Jesus ad imfakachan losani iningwacha ya intudtuchucha. ");
INSERT INTO ksc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kapu ta ad-adchuwan na takuy nanchatochatong, maid pu wayachay mangan, siyan anan Jesus ta chachi disipulusna, “Intau tumalin ta mafalini man-illongtaù ait.” ");
INSERT INTO ksc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ad lummayawchay namfangka wi ummoy tummalin ta osay lukar. ");
INSERT INTO ksc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ngim immatunan na achuy takun nallurukan ta fangkay lummayaw. Siyan na ad-adchuwani taku wi narpu ta ailiili, nanodchàcha wi innoychan tarantag ad ummunacha chummatong ta lukar wi umayancha Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Lummogsad pù Jesus ta fangka, innilanan chachi ad-adchuwani taku, ad amod na kaasinan chicha tan isuchà pannilu wi maid pu mangayyuwan an chicha. Sachi ad illukinay nanudtuchun chichà achu. ");
INSERT INTO ksc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Anna puni mummaschom, ummon disipulusnan siya, ad anancha, “Mummaschom, ad maid pu foroy ad asna. ");
INSERT INTO ksc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Siyan fuarom chicha ta umoycha mangnginà anoncha ta anchachi il-ili ya foforoy.” ");
INSERT INTO ksc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ngim sinongfatana chicha anani, “Chiayun mamaan an chicha.” Ad anancha, “Piom wi ing-ani mangnginà tinapoy à pasar na chuwangkasut à pilak à ipaannin chicha?” ");
INSERT INTO ksc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","“Ing-ayu ilan nu am-an na tinapoy wi awad an chiayu,” anan Jesus. Innilacha pun anancha, “Awad na limay tinapoy ya chuway filis.” ");
INSERT INTO ksc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Sachi ad impaachuy Jesus ar-arubfunon na taku ta tappu. ");
INSERT INTO ksc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Siyan nasillimmampuru ya nasingkakasut na osay ugpuni ummachuy ta tappu. ");
INSERT INTO ksc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ad innaran Jesus na limay tinapoy ya chuway filis, ad nantangad ad langit wi nanyaman an Apudyus. Sachi ad pinotpotlànan tinapoy ya filis ad impaiwarasna impafillay ta disipulusna ta taku. ");
INSERT INTO ksc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ad losancha nabsug wi nangan. ");
INSERT INTO ksc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ad napnun nasawaran à chuway langngay ta nasawar wi nafun-ani tinapoy ya filis wi chinakup na disipulusna. ");
INSERT INTO ksc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na filang na lallarai wi nangan, nasuruk à limay lifu wi foon à nifilang na fubfufai ya an-ananà. ");
INSERT INTO ksc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Narpas pun na sachi namaanan Jesus ta chachi taku, nallukanonan disipulusna ta fangka ta umunacha chumormang ta fayfay wi umoy ad Betsaida. Ad pinaryawnan chachi taku. ");
INSERT INTO ksc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Sachi ad nanakachà Jesus ta takudtud wi ummoy nalluwaru. ");
INSERT INTO ksc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Lummafi ad, nangkinawan fangka ta fayfay, ad os-osàan à Jesus ta takudtud. ");
INSERT INTO ksc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ad intapna wi namparpalikatancha wi nangiturung ta fangkacha tan aptiaptiwon na amochi fidfid. Machamaan ad, ummoy à Jesus an chicha wi nanadchadcharan ta lafaw na chanum. Na somsomòna, lausana chicha. ");
INSERT INTO ksc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Ngim na nangil-anchan siyay nanadchadcharan ta fayfay, nampauycha ta ogyatcha tan anancha pun nu aran! Ngim nakaningan chicha, wi anana, “Achiayu umogyat. Saonna!” ");
INSERT INTO ksc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Sachi ad nakafangkan chicha, ad kumminò na fidfid. Ad naschaaw losan na disipulusna, ");
INSERT INTO ksc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","tan achicha pu naawatan na mining na nampaachuwan Jesus ta tinapoy. Isù achi pu lumnò ta somsomòchan losani innilacha. ");
INSERT INTO ksc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nakafallasiwcha pun ta fayfay, chummatongchad Genesaret, ad insingodchan fangkacha. ");
INSERT INTO ksc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Lummogsadcha pun, nan-iyimatun na takù Jesus, ");
INSERT INTO ksc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","siyan nanodchàcha wi ummoy ta losani foforoy impachamag wi chummatong à siya. Ad inyoy na takun chachi nasakit ta sinuy chongronchay ayona. ");
INSERT INTO ksc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Siyan uray sinuy ili wi umayan Jesus, anchanan nasakit wi inyoy na taku ta aallusancha, ad nampangpangngaasichan siya ta iparufusna kuma wi uray agpachanchan pagpag na silupna. Ad na losani nangagpad, ummimfagcha. ");
INSERT INTO ksc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Na osay padcha, ummalin uchumi Fariseo ya mangitudtuchu ta Lintog wi narpud Jerusalem, ad naaruscha naamung an Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ad innilacha wi na uchumi disipulusna, foon pù tinungparchan achawiyanchay Judio, wi nu mangancha mamfurucha umuna. ");
INSERT INTO ksc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Tan na losani Judio, sinchumallun Fariseo, achicha pu mangan nu foon à mafuruwancha, wi sachin manungparancha ta intudtuchun na aappucha. ");
INSERT INTO ksc_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ya achicha pu ko anon na sinumani mangin-an nu foon pun à farfarancha unaon. Achu kon uchumi achawiyancha wi tungparoncha, wi isun na inyùuras ta tasa, fanga ya kanchilu.) ");
INSERT INTO ksc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ad chachi Fariseo ya mangitudtuchu ta Lintog, inimuschan Jesus, “Tamakon disipulusnu, foon pù tungparonchan achawiyantau wi intudtuchun na iyaawi, wi achicha pu mamfuruy mangan?” ");
INSERT INTO ksc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ad ananan chicha, “Tuttuwan sachi imfakan Apudyus ta awi mipangkop an chiayuy akinpapati, wi inyug-is Isaias wi profeta, wi anana, ‘Na anchanay taku, tupòcha kan manayawanchan saon, wi maid pu ustù somsomòchan saon. ");
INSERT INTO ksc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Siyan maid silfin na manayawanchan saon, tan siya itudtuchuchan achawiyancha wi ing-ingwan na taku ad ananchay filin-u nu!’ ");
INSERT INTO ksc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Inwalinyun filin Apudyus ta siya tungparonyun achawiyanyu wi narpu kay ta somsomò na taku. ");
INSERT INTO ksc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Tuttuway naraing-ayu wi mangiwalin ta Lintog Apudyus ta siya oognanyun sikuchi achawiyanyu! ");
INSERT INTO ksc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tan anan Moses, ‘Chayawom na amam ya inam,’ ad ‘Sinumani mangarawag ta amana ya inana, masapur mapatoy.’ ");
INSERT INTO ksc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Sachin ustuy nilintog, ngim iwalinyuchi tan itudtuchuyu wi uray iturung na taku ta amana ya inana, ngim nu ananay ‘Korban na annaya’ (na mining na ‘Korban,’ ‘Para an Apudyus’), ");
INSERT INTO ksc_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","mapasinsiya wi foon pu nù masapur wi fadngana chicha. ");
INSERT INTO ksc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Siyan na itudtuchuyu, inwalinyun lintog Apudyus. Ad achu kon oy-oyyoonyu wi amaschi.” ");
INSERT INTO ksc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sachi ad asin Jesus impaachanin chachi ad-adchuwani taku, ad anana, “Chiayu losan, inaagyu chongron ta maawatanyu! ");
INSERT INTO ksc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Foon pù siya mamparwing ta taku an Apudyus na lumnò ta tupòna wi anona, ngim na marpu ta taku sachi mangiparwing an siya. ");
INSERT INTO ksc_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nu naingaan-ayu, maawatanyu kuman annay chingngoryu!” ");
INSERT INTO ksc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Napannos ad, tinaynan Jesus chachi taku ad ummoy linumnò ta foroy. Ad na disipulusna, inimuschan siya nu sinun mining na inyaligna. ");
INSERT INTO ksc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ad anan Jesus, “Achiyu pu ko maawatan? Achiyu pu maawatan wi sinumani lumnò ta tupò na taku ad inùmunna, foon pù sachin mangiparwing an siya an Apudyus? ");
INSERT INTO ksc_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tan foon pù umoy ta somsomòna ngim umoy ta fuwangna ad nangaw-as.” (Na nangifag-ana ta sachi, impakaawatna wi losan na maan, maid arwinganan Apudyus.) ");
INSERT INTO ksc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ad inturuyna anani, “Na somsomò, siyan marpuwan na mangiparwing ta taku an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tan na somsomò, siyan marpuwan na losani lawing, isun na chagchakas, akaw, pumatoy, ");
INSERT INTO ksc_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kamkam, ya losani oyyooni lawing. Na somsomò siya kon marpuwan na sinumani linuruku wi turtulli, apos, pasorod, pas-ar ya uchumi linuruku. ");
INSERT INTO ksc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Losani amaschi wi lawingi marpu ta somsomò na taku, chichan mangiparwing ta taku an Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ad lummayaw à Jesus ta sachi ili ad ummoy ta sakupon Tiro. Ad linumnò ta osay foroy, wi na kakarana, achi pu maakammuwan na ingkawana. Ngim foon à mafalin tan chingngor na taku. ");
INSERT INTO ksc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Na osay fufai wi foon à Judio, wi niyanà ad Fenisia wi sakupon Siria, chingngorna wi awad à Jesus. À siya, nakafarfaray na anànay fafarasang. Siyan ummoy an Jesus nampalintumong nampangpangngaasi ta iparyawna kuman farfaray na anàna. ");
INSERT INTO ksc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ad nan-alig à Jesus wi ananan siya, “Masapur mapaanan umunan an-ananà achiwot na asu. Foon pù mafalin wi ipaan na anon na anà ta asu.” ");
INSERT INTO ksc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ad sinongfatana anani, “Tuttuwanat, Apu, ngim uray na asu ta chukun na lamisaan, mafalini anonchan chachà na an-ananà!” ");
INSERT INTO ksc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ad anan Jesus an siya, “Naun-unan na songfatnu! Uray lumayaw-a. Tinaynan na aran na anànu!” ");
INSERT INTO ksc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Chummatong pun chi fufai ad foroycha, inchasanan anàna wi nifafàsar ta katli, wi maid pu farfarayna. ");
INSERT INTO ksc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ad lummayawcha Jesus ta sakup Tiro, ad nangoychad Sidon ya sakupon Decapolis ad nanàpuscha ummoy ta fayfay ad Galilea. ");
INSERT INTO ksc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ad na sachi, iningkaw na osay larai wi naturong ya naumor, ad inyoy na uchumi takù siyan Jesus ad nampangpangngaasicha ta agpachana kuma ta umimfag. ");
INSERT INTO ksc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Sachi ad intalin Jesus à siya ad inigkanan kammatna ta ingan chi larai, ad tinubfaanan kammatna ad iyid-onna ta chilan na larai. ");
INSERT INTO ksc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Sachi ad nantangad à Jesus ad langit, ad nan-angngos à napapannos, ad anana ta larai, “Epfata!” (Na mining na sachi, “Machiyat-a!”). ");
INSERT INTO ksc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Sachi ad naaan na turongna ya umorna, ad naun-unan na kingana. ");
INSERT INTO ksc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ad finilin Jesus na chachi taku ta achicha ifagfakan na iningwana, ngim uray nu filifilinona chicha, sinchumalluy ifagfagfakacha. ");
INSERT INTO ksc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ad losan na nangngor, isagcha naschaaw, wi anancha, “Mamfaru losan na oy-oyyoona! Tan manchongronan naturong ya pakingaonan naumor!” ");
INSERT INTO ksc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Naarkawanan ad, naarus akon ad-adchuwani taku an Jesus. Ad naamin pun na faruncha, inayakan Jesus na disipulusna ad ananan chicha, ");
INSERT INTO ksc_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Maachakuwanà ta anchanay taku tan atlun padchacha ta sana wi ingkaw an chitau, ad naamin na faruncha. ");
INSERT INTO ksc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ngim nu paryawò chichay nafitil, masikingancha ta charan tan narpun uchum ta ad-adchayuwan.” ");
INSERT INTO ksc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ad inimus na disipulusnan siya, “Ngim sinun mangar-antaù ipaantau ta anchanayay ad-adchuwan ta annay tummatalini ili?” ");
INSERT INTO ksc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ad inimusnan chicha, “Am-an na tinapoy wi awad an chiayu?” “Pitu kay,” ananchay summongfat. ");
INSERT INTO ksc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Sachi ad impaachuy Jesus losan na taku ta luta. Ad innaranan pituy tinapoy ad nanyaman an Apudyus, ad pinotpotlàna impaiwaras ta disipulusna ta taku. Ad inwarascha. ");
INSERT INTO ksc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ad iningkaw akon aiti filis wi man-akàit, siyan nanyaman à Jesus an Apudyus ad impaiwarasna ko ta disipulusna. ");
INSERT INTO ksc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ad losancha nabsug wi nangan. Ad pituy langngay na naamin napnu ta nafun-an wi chinakup na disipulusna. ");
INSERT INTO ksc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Na filang na takuy nangan, ummoy à opat lifu. ");
INSERT INTO ksc_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ad pinaryaw Jesus na taku, ad namfangkacha Jesus ya disipulusna wi ummoy ta sakup Dalmanuta. ");
INSERT INTO ksc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Chummatong na uchumi Fariseo an Jesus nakafatfatang ta sikapancha kumà siya. Siyan mampàwaonchà siyà kaskaschaaw à manuttuwaancha nu tuttuway Apudyus na nangifaun an siya. ");
INSERT INTO ksc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nan-angngos à Jesus à napapannos, ad anana, “Tamakon annay lunap, mampàwachà kaskaschaaw à mangil-ancha ta kinasasaad-u? Ngim na ifakà an chiayu, maid pu mipailà singyar ta annay lunap!” ");
INSERT INTO ksc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Sachi ad tinaynana chicha, ad asin namfangka wi ummoy ta chomang na fayfay. ");
INSERT INTO ksc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na disipulus Jesus, naliwatanchay namfarun, ad afus na osay tinapoy wi awad ta fangka. ");
INSERT INTO ksc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ad anan Jesus an chicha, “Tanchaananyun yeast Herod ya chachi Fariseo.” ");
INSERT INTO ksc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ad anan na disipulusnay nan-uukud, “Imfakana nin yakay tan maid pu tinapoytau.” ");
INSERT INTO ksc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ngim inakammun Jesus na uukuchoncha, siyan ananan chicha, “Tayuko man-is-isian na kinamaid na tinapoytau? Natangkin na somsomòyu tan achiyu pu maawatan ya mailasin na mipangkop ta karobfongà? ");
INSERT INTO ksc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Annat na atayu, ngim achiyu pu inilan iningwà? Ya annat akon ingayu, ngim maid pu chongronyu ta inukud-u? Ad naliwatanyun ");
INSERT INTO ksc_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","namotpotlaà ta limay tinapoy wi namaan ta chachi limay lifuy taku? Am-an na langngay na chinakupyuy nafun-an?” Ad ananchan siya, “Nasawaran à chuwa.” ");
INSERT INTO ksc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ad anan ako Jesus, “Ad na namotpotlaà ta pituy tinapoy wi namaan ta chachi opat lifuy taku, am-an akon langngay na chinakupyuy nafun-an?” Ad anancha ko, “Pitu.” ");
INSERT INTO ksc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ad ananan chicha, “Ad chaanyu pù maawatan?” ");
INSERT INTO ksc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Chummatongcha pun ad Betsaida, inyoy na uchumi takun osay nakurap an Jesus, ad nampangpangngaasicha ta agpachanà siya. ");
INSERT INTO ksc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ad iniwid Jesus chi nakurap ad inyoyna ta ikid na ili, ad tinubfaanan atana ad inagpachana. Ad inimusnan siya, “Awad itollongnu?” ");
INSERT INTO ksc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nallangranga chi larai ad anana, “Oo, makailaà ta taku, ngim isuchà ay-ayu wi manadchadcharan.” ");
INSERT INTO ksc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ad asin Jesus inagpachan na atana, ad nallangranga chi larai wi naaan na kurapna, ad pummadcha isag na nangil-ana ta asinchuwan. ");
INSERT INTO ksc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ad pinaryaw Jesus à siya ta umoy ad foroycha, ad ananay nangifilin, “Achia mangulin ta anchi ili.” ");
INSERT INTO ksc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ad nanadcharancha Jesus ya disipulusna wi umoy ta il-ili wi sakupon Cesarea Filipos. Ingkawcha ad ta charan, inimusnan chicha, “Sinun mammammoan na takun saon?” ");
INSERT INTO ksc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ad anancha, “Anan na uchum wi sia nù Juan wi Mamfufunyag wi ummuli nataku. Ad anan akon uchum wi sia nù Elias wi nangulin. Ad na uchum, ananchay sia nun osay profeta.” ");
INSERT INTO ksc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ad inimusnan chicha, “Ad chiayu ngay? Sinun mammammoanyu?” Ad summongfat à Pedro, wi anana, “Sian Cristu.” ");
INSERT INTO ksc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Sachi ad finilin Jesus chicha, “Achiyu ifagfaka ta uchumi takun mipangkop an saon.” ");
INSERT INTO ksc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sachi ad illukin Jesus wi mangifaka ta disipulusna ta màwan siya, anana, “À saoni namfalin taku, masapur mapalikatanà ya kuraonà ta chachi mamangpanguwon na Judio ya pangpangun na papachi ya chachi mangitudtuchu ta Lintog. Ad mapatoyà, ngim na miyatluy padcha, umuliyà mataku.” ");
INSERT INTO ksc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Illawagnay nangisuplikar ta sachi an chicha. Sachi ad intalin Pedro à Jesus ad inomoranà siya mipangkop ta sachi imfakana. ");
INSERT INTO ksc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ngim nansakung à Jesus ta chachi disipulusna ad inomoranà Pedro anani, “Lumayaw-a, Satan! Tan na somsomònu, foon à narpun Apudyus, ngim somsomò yakan taku!” ");
INSERT INTO ksc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Sachi ad inayakan Jesus na chachi ad-adchuwani taku ya disipulusna, ad ananan chicha, “Sinumani maryad wi sumurut an saon, masapur foon pù makaka ta fiyagnad asnay luta, tan masapur oyyoonan piò, uray sachin iyatoyna. ");
INSERT INTO ksc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tan sinumani makaka ta fiyagnad asnay luta, matoy ako kay. Ngim nu sinun foon à makaka ta fiyagna kapu ta pammatinan saon ya mipakapu ko ta Mamfaruy Chamag, uray matoy maatod an siyan fiyag wi mannaynayun. ");
INSERT INTO ksc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tan sinun silfin na mangin-uwaan na osay taku ta losani awad ta luta nu ifallun Apudyus à siya? ");
INSERT INTO ksc_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tan foon à umanay na kinafaknang na takù ifayadna ta makafiyakana an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ad sinumani taku wi mafain wi manàchor an saon ya intudtuchù, ta sanay timpuy maid pammatin na kaachuwan ya amod na kinarawing na taku, mafainà ako wi manàchor an siya nu mangulinà. Tan saoni namfalin taku, furnanà ta aangheles Apudyus nu mangulinà wi sumilingà ta kinachayaw Ama.” ");
INSERT INTO ksc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ad anana kon chicha, “Tuttuwan ifakà an chiayu, wi awad na uchum an chiayu ta sana wi asififiyag wi achi pu matoy ingkanà ilanchan Manturayan Apudyus wi chakor na mannakafalin na manturayana.” ");
INSERT INTO ksc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Lummaus ad na onomi padcha, inayakan Jesus cha Pedro ya Jaime an Juan ad inyoyna chicha intalin ta osay filig. Ad na nangiil-anchan Jesus, nafaliwan na itchurana, ");
INSERT INTO ksc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ad na silupna sumilisiling wi putilaan, wi maid miyisuwan na kinaputilàna ta losani ingkaw ta luta. ");
INSERT INTO ksc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Sachi ad innilacha cha Elias an Moses wi makaug-ugkud an Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ad nan-ukud akò Pedro wi ananan Jesus, “Apu, mamfaru tan annaani! Mangwaanì turù sikay à mamfubfuwaanyu ancha Moses an Elias.” ");
INSERT INTO ksc_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Amaschin imfakan Pedro tan maid akammunà ustù ifakana tan kapu ta amochi ogyatcha! ");
INSERT INTO ksc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ad ninapnapan na osay lifuù chicha, ad chingngorchan kinga wi narpu ta sachi lifuu, wi anana, “Sanan Anàu wi ay-ayatò. Chongronyù siya!” ");
INSERT INTO ksc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Sachi ad nallangrangacha pun afus à Jesus à iningkaw. ");
INSERT INTO ksc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Na nan-oskancha ta filig, finilin Jesus chicha anani, “Achiyu ifagfaka na innilayu, ingkanà saoni namfalin taku umuliyà mataku.” ");
INSERT INTO ksc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ad pintogchan filinna, ngim nan-asiimuscha nu sinun mining na ananay matoy ya umuli mataku. ");
INSERT INTO ksc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ad inimuschan siya, “Tamako anan na chachi mangitudtuchu ta Lintog wi masapur umuna nu umalì Elias?” ");
INSERT INTO ksc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Ad ananan chicha, “Oo, tuttuway umunà Elias umali ta isakananan umaliyà. Ad na katuttuwaana, nar-us ummalì Elias ad iningwan na takun sinuy lawing wi pionchay oyyoon an siya, wi sachin niyug-is wi màwan siya. Ya awad akon niyug-is wi mipangkop an saoni namfalin taku, wi masapur mapalikatanà ya maamsiwà ako ta taku.” ");
INSERT INTO ksc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Na nangulinancha ta ingkawan na uchumi disipulus, innilachan ad-adchuwani taku wi naay-allium an chicha. Ya iningkaw akon uchumi mangitudtuchu ta Lintog wi nakasongsongfat ta uchumi disipulus Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Innilan pun na takù Jesus wi marungay, isagcha nataag ad nanodchàchay umoy mangafot an siya. ");
INSERT INTO ksc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ad inimus Jesus ta disipulusna, “Sinun nansosongfatanyun chicha?” ");
INSERT INTO ksc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ad kummingan osay larai wi niyaslang ta sachi kimung, wi anana, “Misturu, inyalì na annay anàuy fafaru an sia, tan nakafarfaray, wi sachin naumorana. ");
INSERT INTO ksc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ad nu chumatong na farfarayna, ipatugnan long-agna ta luta, ya mantatarfutab na tupòna ya nginawingawinan fafana, ad manguntarag na long-agna. Imfakà ta disipulusnu ta iparyawcha kuman farfarayna, ngim achicha pu makàwa.” ");
INSERT INTO ksc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ad anan Jesus an chicha, “Chiayuy taku ta sana, naina kon iniingkawà an chiayu ya anus-un chiayu ya achiayu pu mamati? Iyaliyu ta anna!” ");
INSERT INTO ksc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ad inyoychan fafaru ta sangwanana. Ngim innilan pun na aran à Jesus, nanguntarakona chi fafaru, ad nipatug à siya ta luta wi namfallifallin, ad nantatarfutab na tupòna. ");
INSERT INTO ksc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ad inimus Jesus ta aman na anà, “Naanun nallukiyan na amasnaana?” “Nanipud ta afan-ogna,” ananay summongfat. ");
INSERT INTO ksc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Ad na aran, kankanayunna mantop-aron ta apuy ya chanum ta mangtoyna kuman siya. Siyan nu makàwaa, achakuwam ya turungam chiani!” ");
INSERT INTO ksc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ad anan Jesus an siya, “Tammako anani, Nu makàwaà? Maid achi mafalin à oyyoon na taku nu mamati.” ");
INSERT INTO ksc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ad nakaningan aman chi fafaru ad anana, “Oo, patiyò, ngim fadnganà tan kurang na pammatì!” ");
INSERT INTO ksc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Innilan pu Jesus wi ummachuachun takuy naaarus, inomoranan aran, wi anana, “Ifakà an siay aran wi nanurong ya nangumor ta annayay fafaru, lumayaw-an siya ya achia mangur-ulin!” ");
INSERT INTO ksc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Sachi ad nampauy na aran ad nanguntarakonan fafaru ad lummayaw. Ad isù lachag, siyan anan chachi taku, “Natoy!” ");
INSERT INTO ksc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ngim inognan Jesus na imana wi nampasiad an siya. ");
INSERT INTO ksc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Sachi ad linumnòcha Jesus ya disipulusna ta osay foroy, ad inimuschan siya inyakitùtù, “Taaniko achi pu nakaparyaw ta sachi aran?” ");
INSERT INTO ksc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ad anan Jesus, “Na amaschi wi aran, maid pu makaparyaw nu achi afus na luwaru.” ");
INSERT INTO ksc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Lummayawcha Jesus ta sachi ili ad nangoychad Galilea. Linawing Jesus wi maakammuwan na ingkawana, ");
INSERT INTO ksc_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","tan awad na itudtuchuna ta disipulusna anani, “Saoni namfalin taku, mipurangà ta takuy mamatoy an saon, ngim na miyatluy padcha umuliyà mataku.” ");
INSERT INTO ksc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Achicha pu naawatan na mining na inukudna, ngim ummogyatchay nangimus an siya. ");
INSERT INTO ksc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ad chummatongcha Jesus ad Capernaum, ad linumnòcha ta osay foroy. Ad inimus Jesus, “Sinun nan-is-isianyu ta charan?” ");
INSERT INTO ksc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ngim akikinnòcha, tan nan-is-isìcha ta charan nu sinun angatuwan an chicha. ");
INSERT INTO ksc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sachi ad tummùchù Jesus ad impatùchuna kon disipulusnay nasawaran à chuwa, ad ananan chicha, “Sinumani maryad wi ngumatu, masapur ipafafanan long-agna wi isù ifilangnan long-agnà sanilun na losani fufurunna.” ");
INSERT INTO ksc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sachi ad inayakanan osay anà impasangun chicha, ad inàlinà siya ad ananan chicha, ");
INSERT INTO ksc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Sinumani patkanan nafafay taku wi isun na annay anà mipakapu ta pammatinan saon, patkana kò saon. Ad sinumani mangipatog an saon, patkana kon sachi nangifaun an saon.” ");
INSERT INTO ksc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ad anan Juan an siya, “Misturu, innilanin osay taku wi nangiparyaw ta aran ad imfoswaynan ngachannu, ad impalitni tan foon met à furuntau.” ");
INSERT INTO ksc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ngim anan Jesus an chicha, “Achiyu ipalit na amaschi, tan sinumani mangwà kaskaschaaw wi mangifosway ta ngachan-u, foon à lawing na pangkopnay mangifaka ta ngachan-u. ");
INSERT INTO ksc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tan sinumani foon pù mangukuran chitau, siyan furuntau. ");
INSERT INTO ksc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tuttuwan ifakà an chiayu, uray sinumani mamainum à chanum an chiayu kapu ta pammatiyun saon wi Cristu, kapilitani makunkunaan. ");
INSERT INTO ksc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Sinumani mangwà makafasuran na isun na anchanay an-ananà wi mamatin saon ta man-awichanchà saon, kattoi amod na machusaanà tapin na padcha, tan un-unnoy na matàchan na fakangnà chakoran à fatu ta sana ad nitub-ung ta fayfay. ");
INSERT INTO ksc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Siyan nu kaspangalikan imayun mangwà man-awichanyun Apudyus, lampokanyu ad imfalluyu! Tan un-unnoy na uray pukur wi makafiyag an Apudyus, nu wachawad na ima wi mifallud infierno wi mannaynayuni apuy. ");
INSERT INTO ksc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ad nu kaspangalikan ikiyun mangwà man-awichanyun Apudyus, lampokanyu ad imfalluyu! Tan un-unnoy na uray pilay wi makafiyag an Apudyus, nu wachawad na iki wi mifallud infierno. ");
INSERT INTO ksc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ad nu kaspangalikan atayun mangwà man-awichanyun Apudyus, kulikuram! Tan un-unnoy na furching wi makafiyag an Apudyus ta Manturayana nu wachawad na ata wi mifallud infierno, ");
INSERT INTO ksc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","wi awachan na likat wi achi pu miwarang ya apuy wi achi pu matoy. ");
INSERT INTO ksc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Nu maasinan na michatun an Apudyus à mangawatana, amaschi kuman maasinan na takù apuy. ");
INSERT INTO ksc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mamfarun asin, ngim nu maaan na tamtamna maid in-inon wi mangiyulin ta kinaasinna. Siyan isu kumà naasinan na mamfurfurnanyu ta maturnus-ayu.” ");
INSERT INTO ksc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Lummayaw pù Jesus ta sachi ili, ummoy ta provinsiya wi Judea, ad nanchormang ta Chawwang wi Jordan. Ad asin naarus na ad-adchuwani takun siya, ad tinudtuchuwana chichà isun na sikuchi ining-ingwana. ");
INSERT INTO ksc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ad ummoy akon uchumi Fariseo an siya wi mamachas manikap an siya, ad anancha, “Iparufus na Lintogtau nu ichangan na larain asawana?” ");
INSERT INTO ksc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ad inimusnan chicha, “Sinun illintog Moses mipangkop ta ichang?” ");
INSERT INTO ksc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ad anancha, “Anan Moses wi nu mangiyug-is na larai à kasuratan à mangichangana ta asawana, mafalini ichangana.” ");
INSERT INTO ksc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ad anan Jesus an chicha, “Kapu ta kinatangkinyu inyug-isnan amaschi. ");
INSERT INTO ksc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ngim na chamu wi nangwaan Apudyus, ta taku, iningwanan larai ya fufai. ");
INSERT INTO ksc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ad kapu ta sachi, taynan na larain chakorna ad nitipun ta asawana, ");
INSERT INTO ksc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ad sachin mamfalinanchà osay long-ag. Siyan foon à chuwan long-agcha tan nantipunchà osay long-ag. ");
INSERT INTO ksc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Siyan maid pu karobfongan na taku wi mangichang ta sinumani nantipunon Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Sachi ad linumnòcha Jesus ta foroy, ad inimus akon disipulusnan mipangkop ta ichang. ");
INSERT INTO ksc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ad ananan chicha, “Sinumani larai wi mangichang ta asawana ad mangasawà safali, makafasur à siyà chagchakas ta chamuy asawana. ");
INSERT INTO ksc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ad nu ichangan na fufain asawana ad mangasawà safali, makachagchakas ako.” ");
INSERT INTO ksc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Sachi ad iningkaw na uchumi nangiyoy ta an-ananà an Jesus ta agpachana kuma, ngim ingkimaun na disipulusna chicha. ");
INSERT INTO ksc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ngim innilan pu Jesus, ummog-ot ad anana ta disipulusna, “Masapur iparufusyun umaliyan na an-ananà an saon. Achiyu ipalit, tan piyaronchà saon, ad isun an chicha na afusi mitapi ta Manturayan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tuttuwan ifakà an chiayu, sinumani achi pu mangipafafa ta long-agna ta mamatiyanan Apudyus, wi isun na afafan na anchanayay an-ananà, achi pu mafalin wi mitapi ta Manturayan Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Sachi ad inàlinan chachi an-ananà, ad impataynan imanan chicha wi naminchisyun. ");
INSERT INTO ksc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Na lummigwatan Jesus wi umoy mangkagkaay, nanodchà na osay larai wi ummoy nampalintumong an siya, ad inimusnan siya, “Mamfaruy Misturu, sinun masapur oyyoò ta makafiyakà à mannaynayun an Apudyus?” ");
INSERT INTO ksc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ad inimus Jesus an siya, “Tam-ako anani mamfaruwà? Tan maid uchum à mamfaru nu achi afus à Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Akammum na filin Apudyus: ‘Achia pumatoy à taku, Achia mamufai, Achia man-akaw, Achim istikuwan na foon à tuttuwa, Achia mangkuruk, ya Masapur lispituwom na amam ya inam.’” ");
INSERT INTO ksc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ad sinongfatana anani, “Misturu, tinungpar-u losan nanipud ta afan-og-u.” ");
INSERT INTO ksc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Naay-ayatan à Jesus wi nangitotollong an siya, ad anana, “Os-osàan yakan kurangnu, siyan ing-a inginan losani ùuwam ad inadchom na nginana ta kakapus, ta langit na maugpunan na kinafaknangnu. Ad umalia mitun-ud an saon.” ");
INSERT INTO ksc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ngim na nangngorana ta sachi, lummayaw wi nansasàuy tan amod na faknangna. ");
INSERT INTO ksc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ad nansakung à Jesus ta disipulusna ad anana, “Isag nalikat na mitapiyan na fafaknang ta Manturayan Apudyus!” ");
INSERT INTO ksc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Naschaaw na disipulusna ta nangngorancha ta sachi. Ngim inturuy Jesus wi anana, “An-ananà, tuttuway nalikat na mitapiyan na taku ta Manturayan Apudyus! ");
INSERT INTO ksc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tan mallanlanuy na lumnoan na kamar ta afut na tanud nu mitapiyan na faknang ta Manturayan Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ad naam-amod naschaaw na disipulusna, ad ananchan siya, “Ad sinu nù na mafalini masaraknifan?” ");
INSERT INTO ksc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ad intotollong Jesus chicha ad anana, “Nu taku kan mangwa ta makafiyakanchan Apudyus, tuttuway achi pu mafalin. Ngim nu Apudyus na mangwa, mafalin tan maid achi mafalin an Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Sachi ad nan-ukud à Pedro wi anana, “Chiani ngay, tinaynannin losani ùuwanì sumurutannin sia.” ");
INSERT INTO ksc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ad anan Jesus, “Tuttuwan ifakà an chiayu, wi nu sinun nanaynan ta foroyna, winnu susunudna, winnu inana, winnu amana, winnu an-ananàna winnu lutana kapu ta sumurutanan saon ya mangiwarawakana ta Mamfaruy Chamag, ");
INSERT INTO ksc_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ad-achun maatod an siya ta annay atattakuna nu sachi tinaynana. Tan maatod an siyan ad-achuy fumroyana, mansunudna, man-inana, man-amana, man-anàna, ya manlutana, ngim mamparpalikat ta annay lufung. Ngim makafiyag an Apudyus à ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ngim na osa koy ifakà, ad-adchuwan na isù nangatu ta sana wi fumafà tapin na padcha. Ya chachi isù nafafa ta sana, ngumatuchà tapin na padcha.” ");
INSERT INTO ksc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ad na nanadchadcharanancha ta charan wi umoy ad Jerusalem, namapangngù Jesus. Ad naschaaw na disipulusnay nitun-ud an siya. Ad chachi koy takuy nituntun-ud an chicha, ummogyatcha. Ad intalin Jesus na disipulusnay nasawaran à chuwa, ad asinna ko imfakan chichan màwan siya. ");
INSERT INTO ksc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ad anana, “Chongronyuna! Anna puni intaud Jerusalem. Ad sachin mantiliwanchan saoni namfalin taku. Ad mipurangà ta chachi pangpangun na papachi ya chachi mangitudtuchu ta Lintog, ad masintinsiyaà à mapatoy. Ad mipurangà ako ta chachi foon à Judio. ");
INSERT INTO ksc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ad am-amangonà ya tubfaanà ya abchoyonà an chicha. Ad patoyonà akon chicha. Ngim na miyatluy padcha, umuliyà mataku.” ");
INSERT INTO ksc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sachi ad ummachanicha Jaime an Juan, wi anà Zebedeo, an Jesus, ad ananchan siya, “Misturu, awad na pionni wi oyyoom kumà para chiani.” ");
INSERT INTO ksc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ad anan Jesus, “Sinun pionyu?” ");
INSERT INTO ksc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ad ananchan siya, “Nu chumtong na machaychayawi manturayam, parufusam kumà chiani wi makaachuy an sia, osa ta apot ta chiwawannu ya osa ta apot ta chuwikim.” ");
INSERT INTO ksc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ad anan Jesus wi summongfat, “Foon à maawatanyun chawatonyu. Makaanus-ayu ta likat wi isun na likat wi mipachas an saon? Ad maiturodyuy matoy à isun na iyatoy-u?” ");
INSERT INTO ksc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ad ananchan siya, “Oo, mafalinni.” Ad anan Jesus an chicha, “Tuttuway maanusanyun likat wi isun akon mipachas an saon, ya iturodyu ko wi matoy à isun na iyatoy-u. ");
INSERT INTO ksc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ngim foon à saon na mampili nu sinun tumùchu ta apot ta chiwawan-u ya chuwikì, tan Apudyus na nangisakana ta aachuyan à para ta chachi mangadchana.” ");
INSERT INTO ksc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Chingngor pun chachi simpuruy disipulus na mipangkop ta chawatoncha Jaime an Juan, ummog-otchan chicha. ");
INSERT INTO ksc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Siyan inarus Jesus chicha losan ad tinudtuchuwana chicha anani, “Akammuyun oyyoon chachi manturay ad asnay luta, wi amod na pinagmancharcha ta chachi iturayancha. Ya uray chachi nan-angatu, mancharoncha kon chachi asintatakucha. ");
INSERT INTO ksc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ngim foon kumà mafalin na amaschin chiayu. Tan nu sinun maryad an chiayu wi ngumatu, masapur mamfalinonan long-agnà mansanilu ta fufurunna. ");
INSERT INTO ksc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ad nu awad ako maryad an chiayù mamfalin angatuwan, masapur mamfalinonan long-agnà isù afafaan wi sanilun na uchum. ");
INSERT INTO ksc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Isun saoni namfalin taku, foon pù ummaliyà ad asnay luta ta pafachangà ta taku, ngim ummaliyà ta fadngà chicha. Ya ummaliyà akò matoy à subfut na fasur na takuy ad-adchuwan.” ");
INSERT INTO ksc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Chummatongcha Jesus ya disipulusna ad Jerico. Ad na lummayawancha ta sachi, ad-adchuwan akon takuy nitun-ud an chicha. Ad niyaspur wi iningkaw na osay mamparpalimus wi nakurap wi ummaachuy ta ikid na arsa. Bartimeo na ngachanna, wi anà Timeo. ");
INSERT INTO ksc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Chingngorna pun wi Jesus wi iNazaret na lumaus, illukinay nampoaw anani, “Jesus! Siay kanà David! Kaasiyanà!” ");
INSERT INTO ksc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ngim achun nangomor an siya ta kuminò kuma, ngim inam-amodna impauy anani, “Siay kanà David, kaasiyanà!” ");
INSERT INTO ksc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Sachi ad ummillong à Jesus ad anana, “Ayakanyù siya.” Siyan inayakanchan sachi nakurap anani, “Lumagsak-a! Sumiad-a, tan ipaayagnà sia.” ");
INSERT INTO ksc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ad nan-iyaannan kunsurna ad narnigwat wi ummoy an Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ad anan Jesus an siya, “Sinun piom à oyyoò an sia?” Ad anan na nakurap an siya, “Apu, piò wi makaila.” ");
INSERT INTO ksc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ad anan Jesus an siya, “Uray nu, ing-a. Kapu ta annay pammatim an saon naaan na kurapnu.” Ad chakusi naaan na kurapna, ad nitun-ud an Jesus ta charan. ");
INSERT INTO ksc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Chanchanicha pun ad Jerusalem, chin-umanchan filig wi Olivo, wi achanid Betfage ya Betania wi ili. Ad na sachi, impaunan Jesus na chuway disipulusna, ");
INSERT INTO ksc_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","wi anana, “Umunaayu umoy ta anchi ili ta chomang, ad na lumnoanyu ta ili, ochasanyun nipupungod wi ayyufun na afayu wi chaan pù maafayuwan. Obfachonyu ad inyaliyusna. ");
INSERT INTO ksc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ad nu awad mangwanani tayukonnat obfachon, ifakayu wi masapur na Apuyu ad man-itay-una.” ");
INSERT INTO ksc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ad ummoycha ad inchasanchan ayyufu ta arsa wi nipupungod ta sawang na osay foroy. Ad inobfadcha. ");
INSERT INTO ksc_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ad na uchumi takuy naag-agsad ta sachi, anancha, “Tayuko obfachon na sanati ayyufu?” ");
INSERT INTO ksc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ad imfakachan sachi impaifakan Jesus an chicha, ad intay-un chachi taku. ");
INSERT INTO ksc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Sachi ad inyoychan ayyufu an Jesus, ad inyap-apchan kunsurcha ta ochog na ayyufu ad nangafayù Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ad achu kon takuy nangiyap-ap ta kunsurcha ta arsa wi ayona, ad na uchum ako, summongpatchà pingin na allilison ad inyap-apcha ko ta arsa. ");
INSERT INTO ksc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ad chachi taku wi umunauna ya mituntun-ud an Jesus, asipapauycha anani, “Chayawontaù Apudyus! Chayawontaù siyay ummali wi narpun Apudyus! ");
INSERT INTO ksc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Chayawontaù siya tan siyan mangituray ta pinakaalin na Aputauy David! Chayawontaù Apudyus wi Angatuwan!” ");
INSERT INTO ksc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ad na chummatngancha Jesus ad Jerusalem, linumnò à Jesus ta Templo. Linangrangana pun na losani iningkaw, ummoycha ta disipulusnay nasawaran à chuwa ad Betania wi ummiyan, tan mummaschom. ");
INSERT INTO ksc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nafikat ad wi mangulincha wi narpud Betania, nafitil à Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ad intapnan osay imong wi ikus wi karumfuwan, ad ummoyna innila nu awad fokasna. Ngim maid, tan afus na tufu, tan chaan pun na imfubfungana. ");
INSERT INTO ksc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Sachi ad anana ta sachi imong, “Manipud ta sana, maid pu mangan ta fungam!” Ad chingngor na disipulusnan imfakana. ");
INSERT INTO ksc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Chummatongcha pun ad Jerusalem, ummoy à Jesus ta Templo ad imparyawnan mallakraku ya mangngingina wi iningkaw. Ad inaminna linitwad na lamisaan chachi mansusukat à pilak ya aachuyan chachi mallakrakù karupati, ");
INSERT INTO ksc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ad impalitna kon chachi mamfufuud wi mangoy ta charò na Templo. ");
INSERT INTO ksc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ad ananay nanudtuchun chicha, “Niyug-is na ukud Apudyus wi, ‘Na Templò, mausar à luruwwaruwan na losani taku ta iliili.’ Ngim annay namfalinonyù mallukuwanyu ta asintatakuyu!” ");
INSERT INTO ksc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Chingngor pun chachi pangpangun na papachi ya mangitudtuchu ta Lintog na ingwan Jesus, illukichay nan-anap à mangtayanchan siya. Ummogyatchan siya tan naschaaw losan na takuy nangngor ta itudtuchuna. ");
INSERT INTO ksc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mummaschom pun, tinaynancha Jesus na sachi ili. ");
INSERT INTO ksc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na nanadcharanancha Jesus ta figfikat, innilachan sachi imong wi ikus wi narangu, uray na puunna. ");
INSERT INTO ksc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ad sisimmò Pedro na imfakan Jesus, siyan ananan Jesus, “Misturu, ilam! Narangun annay imongi ikus wi inarwakam!” ");
INSERT INTO ksc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ad anan Jesus, “Piyaronyù Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tuttuwan ifakà an chiayu, wi sinumani mangifaka ta anchi filig, ‘Man-atun-a ta anchi fayfay,’ ad nu patiyona wi màwachi, wi maid pu chuwachuwan na somsomòna, tuttuway màwa. ");
INSERT INTO ksc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Siyan ifakà an chiayu, sinumani chawatonyu ta malluwaruwanyu, patiyonyu wi naatod an chiayu, ad tuttuway maatod. ");
INSERT INTO ksc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ngim nu malluwaruayu, masapur pakawanonyun sinumani nangwà lawing an chiayu ta pakawanon akon Amayud langit na iningwayuy lawing. ");
INSERT INTO ksc_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tan nu foon pù pakawanonyun chachi nangwà lawing an chiayu, foon pu kò pakawanon chiayu ta Amayud langit.” ");
INSERT INTO ksc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ad nangulincha Jesus ad Jerusalem. Na nanadcharanan Jesus ta charò na Templo, ummoy an siyan chachi pangpangun na papachi ya mangitudtuchu ta Lintog ya chachi namangpanguwon na Judio. ");
INSERT INTO ksc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ad inimuschan siya, “Sinun karobfongam wi mangwa ta amaschi? Sinun nangatod ta karobfongam wi mangwaschi?” ");
INSERT INTO ksc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ad summongfat à Jesus wi anana, “Achì ifakan nangatod ta karobfongà wi mangwa ta amaschi nu masongfatanyu yan na imusò an chiayu. ");
INSERT INTO ksc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ifakayun saon nu sinun narpuwan na karobfongan Juan wi mamfunyag. Narpun Apudyus winnu taku?” ");
INSERT INTO ksc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ad nan-uupngacha anani, “Sinun ifakatau? Nu anantauy ‘Narpun Apudyus,’ anana kon chitauy ‘Tayukon nù achi pinatì Juan?’ ");
INSERT INTO ksc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ngim anantauy ‘Narpu ta taku’?” Ngim ummogyatcha ta taku, tan patiyoncha losan wi tuttuway profetà Juan. ");
INSERT INTO ksc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Siyan sinongfatanchà Jesus, “Taw-an, maid akammuni.” Ad anan ako Jesus an chicha, “Siyan nu amasnat, achì pu ko ifakan chiayu nu sinun narpuwan na karobfongà wi mangwa ta oy-oyyoò.” ");
INSERT INTO ksc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sachi ad nan-alig à Jesus wi ananan chicha, “Iningkaw na osay taku wi nammurà grapes. Ad inaradna linìwos, ad ummafut ako ta fatu à mamposposana ta fungana nu fayasoncha. Ad impàwana kon tànangani sikay à ingkawan na mamanfantay. Sachi ad impàwana kò fuwa ta safali wi taku ad lummayaw wi ummoy namfiyasi. ");
INSERT INTO ksc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Timpun ad na inyàapit, imfaunnan saniluna wi umoy makafuwa. ");
INSERT INTO ksc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ngim chachi man-afang ta lutana, chinòmaancha ad inabchoychà siya, ad imparyawcha wi maid pu inadchoncha. ");
INSERT INTO ksc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Sachi ad asinna ko imfaun na osay saniluna, ngim sin-umisag na iningwachan siya nu sachi ummuna, tan finaagchan uruna ad iningwachà afàfàinan an siya. ");
INSERT INTO ksc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ngim imfaun akon nginlutan osa, ad pinatoychà siya. Ad amaschi kon iningwacha ta losani sanilu wi nafaun, wi inabchoychan uchum ya pinatoycha kon uchum. ");
INSERT INTO ksc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Siyan na anungusna, maid faunonà uchum, afus na anànay ay-ayatona. Ad imfaunna tan anana pun nu singnanchà siya. ");
INSERT INTO ksc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ngim nan-uupnga chachi man-afang anani, ‘Anchiyan anànay mangilàsun ta annay luta. Siyan patoyontau ta man-uwataun làsunna!’ ");
INSERT INTO ksc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ad chinòmaanchà siya ad pinatoycha, ad imfalluchan long-agna ta lasin na arad. ");
INSERT INTO ksc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Sinun oyyoon chi nginluta an chicha? Sikurachuy umoyna patoyon chicha, ad ipàwanà fuwa ta uchum. ");
INSERT INTO ksc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Achiyu pu finasan niyug-is wi ukud Apudyus wi mipangkop ta annaya? Tan anana, ‘Na fatuy inchulin na mangkakaob wi ananchay maid silfina, sachin nàwà apatkan wi mipon-ad. ");
INSERT INTO ksc_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","À Apudyus na nangwa ta annaya, ad isag kaskaschaaw à maila!’” ");
INSERT INTO ksc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Na nangngoran na pangpangun na Judio ta alig Jesus, naawatancha wi chichan inyaligna, siyan pionchay chòmaan à siya, ngim ummogyatcha ta chachi takuy ad-adchuwan, siyan tinaynanchà siya ad lummayawcha. ");
INSERT INTO ksc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nifaun na uchumi Fariseo ya uchumi takun Herod ta umoycha sikapan à Jesus ta ukudna ta awad mangicharumanchan siya. ");
INSERT INTO ksc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ad ummoychan siya imfaka, “Misturu, akammuni wi maid turtulliyam à taku, wi foon pù atingurom na sinuy ukuchon na takun sia. Ad maid pu laksikom à taku wi uray sinun kinasasaadcha, wi afus na katuttuwaan à itudtuchum wi pion Apudyus wi pàwa ta taku. Siyan annan imusonnin sia. Surngasingontaun Lintogtauy Judio nu mamfayadtaù fukis ta Ali ad Roma, winnu foon?” ");
INSERT INTO ksc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ngim inakammun Jesus na kinasilibcha, siyan ananan chicha, “Tayuko sumiksikkap an saon? Umipailaayù osà parata ta ilà.” ");
INSERT INTO ksc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ad ummipailachà osa, ad inimusnan chicha, “Sinun nginfosar ya nginngachan ta anna?” Ad anancha, “Ali Cesar.” ");
INSERT INTO ksc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ad anan Jesus an chicha, “Siyan adchonyun Cesar na uwana. Ngim ilanyu ko ta adchonyun Apudyus losan na para an siya.” Ad naschaawcha losan ta insongfat Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sachi ad ummoy na uchumi Saduceo an Jesus. Na Saduceo, foon pù patiyoncha wi umuli matakun natoy. Ad ananchan siya, ");
INSERT INTO ksc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Misturu, inyug-is Moses wi nu nangasawan osay larai ad natoyi maid anàna, masapur asaw-on na sunudnan nafaru ta umanàcha kumà mifilang à anà na sachi natoyi sunudna. ");
INSERT INTO ksc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nu kaspangalikan awad pitù lallaraì mansusunud, ad nangasawan panguru, ad natoyi maid anàcha. ");
INSERT INTO ksc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Siyan inasawanan miyagwa na nafaru, ngim natoy ako wi maid pu ko anàcha. Ya isun akon napasamak ta miyatlu, ");
INSERT INTO ksc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ingkanà losan chachi pitu, natoycha losan wi maid pu anàcha. Ad na anungusna natoy akon fufai. ");
INSERT INTO ksc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Siyan nu umuli matakun natoy, sinun ustuy ngin-asawan siya? Tan losanchay pitu inasawà siya.” ");
INSERT INTO ksc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ad anan Jesus an chicha, “Oo, ngim kattoi naillachuayu, tan achiyu pu maawatan na niyug-is wi ukud Apudyus ya mannakafalinna. ");
INSERT INTO ksc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tan nu umulin taku mataku, maid man-as-asawa tan mamfalincha isù aangheles ad langit. ");
INSERT INTO ksc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ad na mipangkop ako ta umuliyan na taku matakuwan, achiyu pu finasan sachi inyug-is Moses wi nifakan siya ta nangil-ana ta kummilafan na imong? Tan anan Apudyus an siya, ‘Saon à Apudyus wi chaychayawoncha Abraham, Isaac ya Jacob.’ ");
INSERT INTO ksc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ad sachin manuttuwaana wi uray natoycha Abraham ta sachi timpu, asififiyagchad langit wi manaychayaw an Apudyus. Siyan isag-ayu naillachu!” ");
INSERT INTO ksc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Iningkaw ta sachin osay mangitudtuchu ta Lintog wi nanangngor ta chachi Saduceo wi nan-is-isì. Ad chingngorna ko wi ustun insongfat Jesus an chicha, siyan inimusnan siya, “Na losani filin Apudyus, sinun apatkan?” ");
INSERT INTO ksc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ad anan Jesus, “Na apatkani filin, anana: ‘Chiayuy kanà Israel, chongronyuna! À Apudyus wi Aputau, siyan afus à man-aputau. ");
INSERT INTO ksc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ad masapur ay-ayatom à Apudyus ta patingkan na somsomònu ya losani oyyoonyu ya losani kinaraingnu ya losani karobfongam.’ ");
INSERT INTO ksc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ad na misùnub, anana, ‘Masapur ay-ayatom na asintatakum à isun na mangayatam ta long-agnu.’ Maid pu uchum à filin à napatpatog nu anchanayay chuwa.” ");
INSERT INTO ksc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ad anan na mangitudtuchu ta Lintog an siya, “Tuttuwan imfakam, Misturu! Tan tuttuwa wi na Aputau, afus à siyà Apudyus, ya maid pu uchum à Apudyus nu achi afus à siya. ");
INSERT INTO ksc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ad tuttuway masapur wi chayawontaù siya ta losani somsomòtau ya losani kinaraingtau ya losani karobfongantau. Ad masapur ko wi ay-ayatontaun asintatakutaù isun na mangayatantau ta long-agtau. Isag napatpatog na mamatkan ta anchanayay filin nu manchatunan na losani michatun an Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Illasin Jesus wi nanakman chi larai kapu ta kinaustun na songfatna, ad ananan siya, “Foon à nalikat na manturayan Apudyus an sia.” Ad nanipud ta sachi, maid pu makaturod wi asin mansarudsud an Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Na nantudtuchuwan Jesus asin ta Templo, inimusna, “Tamako itudtuchun chachi mangitudtuchu ta Lintog wi na Cristu wi ipaalin Apudyus wi manturay, kanà David à siya? ");
INSERT INTO ksc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tan à David, impaspasmò na Ispiritun Apudyus an siyan imfakana wi, ‘À Apudyus wi Apu, anana ta Apù: Tumùchua ta apot ta chiwawan-u, ingkanà ipaafak-un losani afusurnu.’ ");
INSERT INTO ksc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Siyan nu inawakan David à Cristù Apuna, in-inon David wi nginkanà akon Cristu?” Ad-adchuwan na taku wi naragsak wi manchongor an Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ad na sachi nanudtuchuwanan chicha, anana, “Annachanyun chachi mangitudtuchu ta Lintog. Tan à chicha, pipionchay ikagkagkaay na silupchay lagkoyloy, ya pipioncha koy malispitu ta taku ta aallusancha. ");
INSERT INTO ksc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ya pipioncha koy chichan umachuy ta afaruwani aachuyan ta sinagoga ya chichan machayaw ta sinuy lagsak. ");
INSERT INTO ksc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ad siksikkapanchan anchanay nafaru à mangar-ancha ta ùuwacha, ad malluwaruchà anchuanchù manab-uncha ta oy-oyyooncha! Siyan kapu ta sachi, maam-amod na machusaancha!” ");
INSERT INTO ksc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sachi ad tummùchù Jesus ta chomang na iigkaan à pilak ta Templo, ad intotollongnan takuy mangigkà pilak. Ad-adchuwan na fafaknangi takuy nangigkà achù pilak. ");
INSERT INTO ksc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ad linumnò akon osay kapus wi nafaru, ad chuwa kay siping na inigkana. ");
INSERT INTO ksc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Sachi ad inarus Jesus na disipulusna, ad ananan chicha, “Tuttuwan ifakà an chiayu, wi ifilang Apudyus à chakchakor na inigkan na sachi nafaruy kapus nu losan wi inigkan chachi uchumi nangigka. ");
INSERT INTO ksc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tan chachi uchum, siya kay innadchonchan ait ta sawaroncha, ngim à siya, uray kapus, innadchona losan na iningkaw an siya wi usarona kumà iyatakuna.” ");
INSERT INTO ksc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Na lummawaan Jesus ta Templo, anan na osay disipulusnan siya, “Misturu, ilam na afarun na annay Templo, wi man-afafarun fatu wi nausar ta nàwaana!” ");
INSERT INTO ksc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ad anan Jesus an siya, “Oo, man-afafarucha ya man-achakkor, ngim chumatong na padchay maamin mikur-ub, siyan maid pu mataynan uray osa ta sikud wi ikawna.” ");
INSERT INTO ksc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ingkaw pu Jesus ummachuy ta filig wi Olivo wi chomangon na Templo, ummoycha Pedro, Jaime, Juan ya Andres an siya tummalin. Ad inimuschan siya, ");
INSERT INTO ksc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Mafalin wi ifakam an chiani nu maanun màwaan na sachi imfakam ad kanad, ad sinu kon mangakammuwanni wi ngannganin màwaancha?” ");
INSERT INTO ksc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ad summongfat à Jesus wi anana, “Man-annad-ayu ta achiayu pu maallilaw ta uchum. ");
INSERT INTO ksc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tan lumoswan ad-adchuwani takuy mangwanani chicha nù Cristu! Ya ad-adchuwan na allilawoncha. ");
INSERT INTO ksc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ad nu chamakonyun kukufat, ya chamakonyu kon man-asikinnufat anu ta achayuy il-ili, achiayu umogyat. Tan masapur màwan amaschi, ngim foon pù sachin anungus wi padcha. ");
INSERT INTO ksc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tan man-asikinnufat na losani turay ta annay luta. Ad mangkukufat akon sin-umili. Ad manita ko ta ailiili, ya amod akon ingki. Ngim na anchanaya losan, lugrukin yakan liglikat wi isun na sikab na lukin na mangkumut. ");
INSERT INTO ksc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Masapur wi man-annad-ayu. Tan micharum-ayu ta korti, ad maabchoy-ayu ta sinagogacha. Ad mipasanguayu ko ta chachi nangangatuy turay kapu ta pammatiyun saon. Ngim sachin wayayuy mangifakan chicha ta Mamfaruy Chamag mipangkop an saon. ");
INSERT INTO ksc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Na Mamfaruy Chamag, masapur wi mipaakammu ta losani taku ta arutaruta. ");
INSERT INTO ksc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ad nu matiliw-ayu ya micharum-ayu ta korti, achiayu machanakan ta isongfatyu, tan na sachi timpu, mipaakammun chiayun ustù ifakayu. Tan foon pu kà chiayun marpuwan na ifakayu, tan Ispiritun Apudyus na mangipaspasmò an chiayu. ");
INSERT INTO ksc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Na sachi timpu, uray na mansusunud, man-asififikcha ta mapatoy na sunudcha, ya uray akon man-aama ya man-iina, man-asipinnatoycha. ");
INSERT INTO ksc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ad kuraon chiayu ta losani taku kapu ta pammatiyun saon. Ngim sinumani mangipapati ta pammatina ingkanà anungusna, chichan masaraknifan à ing-ingkana.” ");
INSERT INTO ksc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ad inturuy Jesus anani, “Ad mailayun sachi isag kaog-ogyat wi umagsad ta ikaw wi foon pu kumà umagsachana. (Chiayuy mamasa ta annaya, maawatanyu kuman miningna!) Nu ilanyuchi, masapur umawid chachi ingkaw ad Judea wi umoy mantaru ta filfilig. ");
INSERT INTO ksc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ad na takuy niyaspur wi awad ta otop na foroyna, achi pu kuma lumnò ta foroyna mangarà sinuman, ngim ichakusna umawid. ");
INSERT INTO ksc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ad isun akon takuy niyaspur nasiput, achi pu kuma mangulin ta foroyna umoy mangarà uray luputna, tan ichakusna kuma umawid. ");
INSERT INTO ksc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kakkaasin chachi mafuki ya chachi mantakifi ta sachi timpu! ");
INSERT INTO ksc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Siyan iluwaruyun Apudyus ta achi pu kuma michammu ta timpun na akilid! ");
INSERT INTO ksc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tan na likat na sachi timpu, maid pu miyisuwan na kinalikatna nanipud ta lugrukin na nangwaan Apudyus ta losan, ad maid pu ko amaschì mipachas ad asnay lutà isun na sachi. ");
INSERT INTO ksc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ad nu achin pu Apudyus inaanan na chachi padchay màwaan na anchanaya, matoy na losani taku. Ngim kapu ta kaasina ta losani chinutukana, inaananan padchay màwaan na anchanayay likat. ");
INSERT INTO ksc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ad nu awad ako mangwanani, ‘Ilanyu, annayan Cristuy impaalin Apudyus wi manturay!’ winnu, ‘Anchiyà siya!’ achiyu patiyon. ");
INSERT INTO ksc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tan lumoswan uchumi sinan-Cristu ya sinanprofetas wi mangwanani chicha nun piniyar Apudyus, ad mangwachà kaskaschaaw ya singyar à mangallilawancha ta taku, wi nu mafalin, allilawonchan uray chachi chinutukan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Siyan man-annad-ayu, tan impachaan-un chiayu imfaka ta achiayu pu kuma maallilaw.” ");
INSERT INTO ksc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","Inturuy Jesus anani, “Nu marpas na chachi liglikat, makorkor na losani mailad langit, tan fumulingot na init, ya achi pu sumrag na furan. Ya uray na fituwon, mayaayàcha. ");
INSERT INTO ksc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ad sachin mangil-anchan saoni namfalin taku, wi iyaliyà ta lifuu, ad maila kon mannakafalin-u ya sumilingà ta kina-Apudyus-u. ");
INSERT INTO ksc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ad sachi kon timpuy mangifaunà ta aangheles wi umoy ta arutaruta mangarus ta losani takuy chinutukan Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ad anan ako Jesus, “Acharonyun itudtuchun na imongi ikus. Akammuyu wi nu mangutar ya mamingi, chanchanin chakun. ");
INSERT INTO ksc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Isuna ko, nu ilanyuy màwan anchanayay inukud-u, akammuwonyu wi chanchanin mangulinà ad asnay luta. ");
INSERT INTO ksc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tuttuwan ifakà an chiayu, wi foon pù losan matoy na taku ta annay lunap ad màwan losani inukud-u. ");
INSERT INTO ksc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ad uray maumas losan na mailad langit ya asnay luta, achi pu mabmab-os na losani inukud-ù ing-ingkana, tan masapur matungpar losan.” ");
INSERT INTO ksc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ad anan ako Jesus, “Maid pu mangakammu ta padcha winnu uras wi màwaan na anchanay losani inukud-u. Tan uray chachi aangheles ad langit ya saoni Anà Apudyus, maid pu osà mangakammu nu achi afus à Ama. ");
INSERT INTO ksc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Siyan tatanchaananyu ta mansakanaayu, tan foon à akammuyun màwaan na anchanaya. ");
INSERT INTO ksc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Na chumatngà, miyalig ta osay taku wi ummoy namfiyasi ta achayu, wi na lummigwatana, impiyarna ta sasannilunan losani fiyang na oyyooncha. Ad finilinnan man-aanchog ta man-annad wi manguwarcha. ");
INSERT INTO ksc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Isun akon chiayu, tatanchaananyu ta mansasagkanaayu, tan isuayù man-aanchog wi foon pù akammuna nu sinun uras na mangulinan na Apuna, maschom, winnu kawan na lafi, winnu machamaan, winnu figfikat. ");
INSERT INTO ksc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Siyan mansasagkanaayu ko, ta nu mangulinà achì pu kuma ochasan chiayuy isù nasusuyop na pammatiyu. ");
INSERT INTO ksc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Siyan na ifakà an chiayu, siya kon ifakà ta losani taku: Masapur sasagkanaonyun mangulinà!” ");
INSERT INTO ksc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Chaan chuway padcha ad fiyastay Mangiyakasmoan ya fiyastay mangananchà tinapoy wi achi pu fumtar, ad nan-uupnga chachi pangpangun na papachi ya mangitudtuchu ta Lintog nu sinun in-inonchay maniliw ya mamatoy an Jesus à foon pu kumà maakammuwan. ");
INSERT INTO ksc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ngim anancha, “Achitau pu ichammu oyyoon ta timpun na fiyasta, tan makuru nin na taku.” ");
INSERT INTO ksc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Sachi ad iningkawcha Jesus ad Betania ta foroy Simon, wi nakollakong ta sin-arkawan. Ad na manganancha, linumnò na osay fafarasang wi nangaw-awit à futilya wi nàwa ta fatuy ananchay alebaster wi iigkaan à fangfanguy lana wi nangina wi ananchay nardo. Ad pintodnan fakang na futilya ad insiitna ta urun Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ngim na uchumi iningkaw ta sachi foroy, lummawing na somsomòcha ad ngummunungunucha anani, “Tanako chachailon na lana? ");
INSERT INTO ksc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mingina kumà pasar na turungkasut à pilak ta awad maatod ta kakapus!” Ad chinillawchà siya. ");
INSERT INTO ksc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ngim anan Jesus, “Sachi! Achiyu fiyangan à siya. Mamfaru met na iningwana. ");
INSERT INTO ksc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ad nu mipangkop ta fumadnganyu ta kakapus, kanayuncha awad, siyan farangnan fumadnganyun chicha. Ngim à saon, foon à mafayag na ingkawà ad asnay luta. ");
INSERT INTO ksc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Iningwanan mafalinnay oyyoon, inunana linankan na long-ag-ù sakanan na milobnà. ");
INSERT INTO ksc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tuttuwan ifakà an chiayu, wi na losani mitudtuchuwan na Mamfaruy Chamag ad asnay luta, machamag akon iningwan na annay fafarasang à masmasmoana.” ");
INSERT INTO ksc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Sachi ad à Judas Iscariote, wi siyan osa ta chachi nasawaran à chuway disipulus Jesus, ummoyna inturag ta chachi pangpangun na papachi na mangififikanan Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ad naragsakcha wi nangngor ta imfakan Judas, ad impustachay fayachanchà siya. Ad illukinay man-anap à wayanay mangififik an Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Sachi ad wi chamuy padchan na fiyastay manganan na Judio ta tinapoy wi achi pu fumtar, wi siya kon ustuy mamartiyancha ta pannilu wi maan ta padchay Mangiyakasmoan, anan na disipulusnan siya, “Sinun umayanni mangisakanaan ta manganantaù mangiyakasmoantau ta nallausan na anghel ta aapputau ta awi?” ");
INSERT INTO ksc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ad imfaunnan chuway disipulusna wi anana, “Ing-ayud aschi Jerusalem, ad sib-atonyun osay larai wi man-aagtù simfangà chanum. Siyan mitun-uchanyu. ");
INSERT INTO ksc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ad na foroy wi lumnoana, ifakayu ta nginforoy, ‘Anan na Misturu, Sinun awachan na kuwartu wi mangananni ta disipulus-u ta annay fiyastay Mangiyakasmoan?’ ");
INSERT INTO ksc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ad ituchunan osay chakor wi kuwartu ta miyagway karachun na foroyna wi wachawad na losani masapur, ad sachin mangisakanaanyu ta manganantau.” ");
INSERT INTO ksc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ad lummigwat na chuway disipulus wi ummoy ta ili, ad inchasanchan losani imfakan Jesus, siyan insakanachan manganancha ta sachi fiyasta. ");
INSERT INTO ksc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mummaschom pun, chummatongcha Jesus ya disipulusna. ");
INSERT INTO ksc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ad na nanganancha, anan Jesus, “Tuttuwan ifakà an chiayu, wi awad na osan chiayuy makaan ta sana wi mangififik an saon.” ");
INSERT INTO ksc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ad summauycha losan, ad nasin-ossacha inimus an siya, “Saon na anam?” ");
INSERT INTO ksc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ad ananan chicha, “Siyan osan chiayuy nasawaran à chuwa wi aufung-u ta sana. ");
INSERT INTO ksc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","À saoni namfalin taku, mapatoyà tan sachin imfafagkan na niyug-is wi ukud Apudyus, ngim kakkaasin takuy mangififik an saon, tan un-unnoy akon nu achi pun niyanà!” ");
INSERT INTO ksc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Na nanganancha ko, innaran Jesus na tinapoy ad nanyaman an Apudyus, ad pinotpotlàna ad innadchona ta chachi disipulusna, wi anana, “Aranyuna. Sanan long-ag-u.” ");
INSERT INTO ksc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ad inarana kon sintasay fayas, ad asin nanyaman an Apudyus, ad inadchonan chicha, ad nan-at-attafancha ininum. ");
INSERT INTO ksc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ad ananan chicha, “Sanan charà wi mifùfù à manguras ta fasur na takuy ad-adchuwan, ya sana kon mampanoknok ta impustan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ad tuttuwan ifakà an chiayu, wi achiyà pu asin uminum à fayas ingkanà chumatong na padchay uminumà à àoyyay fayas ta Manturayan Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ad nangkantachà chaychayaw an Apudyus, ad lummawacha wi ummoy ta filig wi Olivo. ");
INSERT INTO ksc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Sachi ad anan Jesus an chicha, “Umawid-ayu losan à awni wi taynanyù saon, tan sachin niyug-is wi ukud Apudyus wi anana, ‘Patoyò na mampapastor ad mansississiyan losan na panniluna.’ ");
INSERT INTO ksc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ngim nu umuliyà mataku, umunaà umoy ad Galilea nu chiayu ta aschin man-asiil-antau.” ");
INSERT INTO ksc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Sachi ad anan Pedro an siya, “Uray nu taynan sia ta anchanay uchum, foon à taynà sia!” ");
INSERT INTO ksc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ngim anan Jesus an siya, “Tuttuwan ifakà an sia, wi nu chaan pun na awitan ipigwa manullaù à lafi, namitluwonà ilifak.” ");
INSERT INTO ksc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ngim inaadchin Pedro anani, “Achì pu sia ilifak, uray nu makàtoyà an sia!” Ad sachi kon imfakacha losan. ");
INSERT INTO ksc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sachi ad ummoycha Jesus ta sachi lukar wi ananchay Getsemani, ad anan Jesus ta disipulusna, “Umachuy-ayu yan ta inyà malluwaru.” ");
INSERT INTO ksc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ad intalinna cha Pedro, Jaime ya Juan ad summauy wi malifuk na somsomòna. ");
INSERT INTO ksc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ad ananan chicha, “Amod na somsomòu wi isù siyan iyatoy-u. Ingkaw-ayu ta anna ta fantayanà.” ");
INSERT INTO ksc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ad ummadchayang à ait ad nallùfub ta luta wi nalluwaru wi nu mafalin kuma, achi pun mituruy na likat wi màwan siya. ");
INSERT INTO ksc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Anana, “Ama, maid achi pu mafalin an sia. Siyan ilisim à saon ta annay likat wi sangsanguwò. Ngim uray nu amasnan chawatò, piò wi matungpar kan piom wi màwa, wi foon pu kà piò.” ");
INSERT INTO ksc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Sachi ad nangulin à Jesus ta chachi turu, ad inchasana chichay nasusuyop. Ad ananan Pedro, “Simon, nasuyop-a? Achi pu mafalini fantayanà à uray osay uras? ");
INSERT INTO ksc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Achiayu kuma masuyop ta malluwaruayu ko ta achiayu pu maawis wi makafasur. Tuttuway annan somsomòyuy mangwa ta ustu, ngim maafak-ayu ta kinakapsut na long-agyu.” ");
INSERT INTO ksc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Sachi ad asin ummadchayang à Jesus ad nalluwarù isun na linuwaruna ta chamu. ");
INSERT INTO ksc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sachi ad asin nangulin an chicha, ad inchasana chichay nasusuyop, tan amod na suyopcha. Ad finangon Jesus chicha, ad maid pu akammuchà isongfatchan siya. ");
INSERT INTO ksc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Pitluna pun wi nangulin, ananan chicha, “Kassiyaayu kay wi nasusuyop? Noy! Annay nachauman na timpu, wi saoni namfalin taku, mipurangà ta managfasur. ");
INSERT INTO ksc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Siyan fumangon-ayu ta intau, tan anchiyan mangififik an saon!” ");
INSERT INTO ksc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Na man-ukuukuchan Jesus, nachanatong à Judas wi siyan osa ta chachi nasawaran à chuway disipulusna, wi nifurun akon siyan ad-adchuwani taku wi nasabsabliyan ya napangpang-oan, wi chichan imfaun na pangpangun na papachi ya mangitudtuchu ta Lintog ya chachi namangpanguwon na Judio. ");
INSERT INTO ksc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","À Judas, imfakanan singyar na mangififikanan Jesus, wi anana, “Na takuy kayyomò, tiliwonyu ya ilayawyuy makukuwwarchaan.” ");
INSERT INTO ksc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Chummatongcha pun, ummoy à Judas an Jesus, ad anana, “Apu!” Ad kinayyomnà siya. ");
INSERT INTO ksc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Sachi ad tiniliwcha ipupukod à Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ngim na osay furunnay ummaagsad, linùpusnan sablina ad piningasnan ingan na sanilun na Angatuwani Pachi. ");
INSERT INTO ksc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sachi ad inimus Jesus an chicha, “Akkawanà ta masapur masabsabliyan-ayu ya mapangpang-oan-ayu wi umali maniliw an saon? ");
INSERT INTO ksc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Finikati iyamuamungà an chiayu ta mantudtuchuwà ta Templo ad apay achiyà pu tiniliw ta sachi nù? Ngim masapur màwan amasna ta tumuttuwaan na niyug-is wi ukud Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Sachi ad ummawid losan na disipulusna wi tinaynanchà siya. ");
INSERT INTO ksc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ad iningkaw ako ta sachin osay fafaru wi nan-aagkoy à yapitan à luput, wi nitun-ud an siya. Ad pinachaschay tiliwon akò siya, ");
INSERT INTO ksc_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ngim tinaynanan akoyna ad ummawid wi namfofodchang. ");
INSERT INTO ksc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ad inyoychà Jesus ta foroy na Angatuwani Pachi, ad naarus ako losan na pangpangun na papachi ya chachi namangpanguwon na Judio ya mangitudtuchu ta Lintog. ");
INSERT INTO ksc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","À Pedro, nan-ag-agkaaw wi nitun-ud an chicha ingkana ta paway na foroy na Angatuwani Pachi, ad nakaachuy ta chachi kuwarcha wi nakaanichu. ");
INSERT INTO ksc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Chachi pangpangun na papachi ya losani kukunsisar, nan-anapchà ipafasurchan Jesus ta awad lasunchay mamatoy an siya, ngim maid pu inchasancha. ");
INSERT INTO ksc_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ad-adchuwan na nangicharum à turtulli mipangkop an siya, ngim nansafasafalin inug-ugkudcha. ");
INSERT INTO ksc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ad ummagsad akon uchumi lallarai wi nanturtulli mipangkop an siya. ");
INSERT INTO ksc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Anancha, “Chingngornin imfakana wi faasona nun annayay Templo wi ingwan na taku, ad mampatàchor à osa ta unog na turuy padcha wi foon à takun mangwa.” ");
INSERT INTO ksc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ngim uray achun nanturtulli mipangkop an Jesus, foon pù man-aamfuruy na imfakacha. ");
INSERT INTO ksc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Sachi ad ummagsad na Angatuwani Pachi ta sangwanancha losan, ad inimusnan Jesus, “Apay maid isongfatnu ta anchanay ipafasurchan sia?” ");
INSERT INTO ksc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ngim ingkikinnò à Jesus wi achi pu summongfat. Ad asin na Angatuwani Pachi inimus an siya, “Sian tuttuway Cristu wi Anà na machayawi Apudyus? Sian impustan Apudyus wi umali manturay?” ");
INSERT INTO ksc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ad anan Jesus, “Oo, saon. Ad mailayù saoni namfalin taku wi umaachuy ta apot ta chiwawan Apudyus wi Mannakafalin. Ad mailayu kon mangulinà wi marpud langit wi iyaliyà ta lifuu!” ");
INSERT INTO ksc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ad na sachi, ummog-ot na Angatuwani Pachi, siyan kinissaynan silupna, ad anana, “Foon à masapur awad uchum à anapontaù mangistiku ta fasurna! ");
INSERT INTO ksc_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Tan losantau chingngor na sachi inukudna, wi iyalignan long-agnà Apudyus! Sinun ananyu nù?” Ad inamfuruyancha losan anani, “Sachin fasurna, ad mapatoy kuma!” ");
INSERT INTO ksc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ad na uchum an chicha, tinubfaanchà siya, ad finungutchan atana ad linipakchà siya, wi anancha, “Ifakam na nanlipak an sia!” Ad uray na kuwarcha, linipakcha kò siya. ");
INSERT INTO ksc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","À Pedro, iningkaw ta nanchoray paway. Ad chummatong na osay fafarasang wi sanilun na Angatuwani Pachi, ");
INSERT INTO ksc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ad innilana pun à Pedro wi nan-aannichu, intotollongnà siya, ad anana, “Sian osay furun Jesus wi iNazaret.” ");
INSERT INTO ksc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ngim illifakna anani, “Maid akammù ta ug-ugkuchom. Achì pu maawatan.” Ad ummoy ta liwangan na paway. Sachi ad nanullaù na osay awitan ta pokan na tullaù. ");
INSERT INTO ksc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ad asin ako innilan chi sanilù siya, ad imfakana ko ta chachi naag-agsad, “Annaya kon osay furuncha!” ");
INSERT INTO ksc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ngim asin ako Pedro illifak. Napapannos ad, anan akon chachi naag-agsad, “Kattoi sian osan chicha, tan iGalilea-a ko.” ");
INSERT INTO ksc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ngim ananay nangisapata, “Uray chusaonà an Apudyus nu foon pù tuttuwan ifakà, maid pu akammù ta sanati taku wi ug-ugkuchonyu!” ");
INSERT INTO ksc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ad ta sachi, impigwan na awitan nanullaù, ad nasnasmò Pedro na imfakan Jesus an siya, “Nu chaan pun na awitan ipigwa manullaù, namitluwonà illifak.” Ad nan-ifil à Pedro wi amod na somsomòna. ");
INSERT INTO ksc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Figfikat pun, asin naarus losan chachi pangpangun na papachi ya chachi namangpanguwon na Judio ya chachi mangitudtuchu ta Lintog ya losan chachi kukunsisar, ad nan-uukudcha nu sinun oyyoonchan Jesus. Siyan kinachilaanchan imana ad inyoycha impurang an Pilato. ");
INSERT INTO ksc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ad anan Pilato an siya, “Sia nun Alin na Judio.” “Siyan anam,” anan Jesus wi summongfat. ");
INSERT INTO ksc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ad chachi pangpangun na papachi, ad-adchuwan na impafasurchan siya. ");
INSERT INTO ksc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ad inimus ako Pilato an siya, “Maid pu isongfatnu ta anchanay ad-adchuwani ipafasurchan sia?” ");
INSERT INTO ksc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ngim ingkikinnò à Jesus wi maid insongfatna. Siyan naschaaw à Pilato. ");
INSERT INTO ksc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tinawoni timpun na fiyastay Mangiyakasmoan, siyan achawiyan Pilato wi umiparufus à osà farud nu sinun piliyan na Judio. ");
INSERT INTO ksc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Na sachi timpu, niyaspur wi iningkaw na uchumi nifarud wi pummatoy ta timpun na nanguruwancha ta kufilnu, wi na osan chicha, Barrabas. ");
INSERT INTO ksc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Siyan naarus pun na takuy ad-adchuwan, imfakachan Pilato wi umiparufus kumà farud wi siyan achawiyana. ");
INSERT INTO ksc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ad anan Pilato an chicha, “Pionyu wi iparufus-un annay Aliyuy Judio?” ");
INSERT INTO ksc_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Sachin imfakan Pilato tan inaagkammuna wi apos na pangpangun na papachin nangicharumanchan Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ngim chachi pangpangun na papachi, sinugsukanchan takuy naarus ta siya paiparufuschà Barrabas. ");
INSERT INTO ksc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ad inimus ako Pilato an chicha, “Ad sinu kon oyyoò ta annayay ananyuy Aliyuy Judio?” ");
INSERT INTO ksc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ad inip-awcha anani, “Ilansayù siya ta kros!” ");
INSERT INTO ksc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ad inimus ako Pilato an chicha, “Tamako? Sinun iningwanay lawing à milansaana ta kros?” Ad chinakorcha impauy anani, “Ilansayù siya ta kros!” ");
INSERT INTO ksc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Siyan à Pilato, imparufusnà Barrabas ta paragsakonan chachi taku. Ad impaabchoynà Jesus, ad impurangnà siya ta susurchachu ta ilansachà siya ta kros. ");
INSERT INTO ksc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sachi ad imparnò na susurchachù Jesus ta foroy na fifinnachur, ad inayakancha kon losani fufurunchay surchachu. ");
INSERT INTO ksc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ad sinilupanchà siyà mancharaag à isù silup na Ali. Ad fummaliugchà lassilassì isù koronana ad impayunguschan siya. ");
INSERT INTO ksc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ad sinaruchuchà siya wi nanginsurtun siya, wi anancha, “Ta matakuà ing-ingkana, siay Alin na Judio!” ");
INSERT INTO ksc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ad pinang-òchan uruna ad tinubtubfaanchà siya. Ad nampalintumongcha ta sangwanana wi akinchachayaw an siya. ");
INSERT INTO ksc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Limpascha pun inin-insurtù siya, sinukatanchan sachi mancharaag wi insilupchan siya ta sikuchi silupna. Sachi ad illayawchà siya wi umoy mangilansan siya ta kros. ");
INSERT INTO ksc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Na lummawaancha ta ili, inafotcha ta charan na osay taku wi iCirene, wi nangngachan à Simon, wi amacha Alejandro an Rufo. Jerusalem na ustuy umayana wi narpu ta payawna, ngim impafuudchan siyan kros Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ad inyoychà Jesus ta osay lukar wi ananchay Golgota (na miningna, “Fàag”). ");
INSERT INTO ksc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ad inadchanchà siyà fayas à naraukan à akas wi mirra, ngim achina pu inumon. ");
INSERT INTO ksc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ad illansachà siya ta kros, ad namfinnunutcha nu sinun mangin-uwa ta luputna. ");
INSERT INTO ksc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Machanchani chumikas na nangilansaanchan siya ta krosna. ");
INSERT INTO ksc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ad iningkaw na niyug-is ta krosna, wi impafasurchan siya, anana, “Alin na Judio.” ");
INSERT INTO ksc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ad iningkaw akon chuway akkawan wi illansacha inchorag an Jesus wi osa ta apot ta chiwawanna ya osa ta apot ta chuwikina. ");
INSERT INTO ksc_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Na nàwaan na sachi, à tumuttuwaan na sachi niyug-is ta awi, wi anana, “Nitaurung ta akkawan.” ");
INSERT INTO ksc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na takuy lummaus ta sachi, asiwiwingiwingcha wi nanginsurtun Jesus, wi anancha, “Akunu! Anam met wi faasom na Templo ad asinnu patàchoron ta unog na turuy padcha! ");
INSERT INTO ksc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Siyan saraknifam na long-agnu, ad lumogsad-a ta sanati krosnu!” ");
INSERT INTO ksc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ad isun akon iningwan chachi pangpangun na papachi ya mangitudtuchu ta Lintog, nan-uukudchay nanginsurtun Jesus, anancha, “Finadnganan uchum, ngim achi pu mamachang ta long-agna! ");
INSERT INTO ksc_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Iillantau kay na annay Alitau nuy kanà Israel nu lumogsad à mangil-antaù mamatiyantau wi siyan Cristu wi impaalin Apudyus!” Ad uray chachi koy nilansa, ininsurtucha kò siya. ");
INSERT INTO ksc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mamatù ad, fummulingot losan na luta ingkana ta ar-arkaw. ");
INSERT INTO ksc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ad na sachi, nampoaw à Jesus wi anana, “Eli, Eli, lama sabaktani?” Na mining na imfakana, “Apudyus-u, Apudyus-u, tam-akò saon man-awichan?” ");
INSERT INTO ksc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Chingngor pun chachi naag-agsad na imfakan Jesus, anan na uchum, “Chongronyu, ayakanà Elias!” ");
INSERT INTO ksc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ad nanodchà na osa wi ummoy nangarà ispongha ad illunongna ta ilom ad impaotna ta paur ta supsupan Jesus, ad anana, “Awniyan, ta ilantau nu umalin Elias ichòorà siya ta kros!” ");
INSERT INTO ksc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ad asin nampoaw à Jesus, ad natoy. ");
INSERT INTO ksc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ad na sochorani kurtina wi nitatayyun ta Templo, nan-agwa nakissay wi nanipud ta ngatu ingkana ta chora. ");
INSERT INTO ksc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ad na kapitan na surchachu wi nanasakung an Jesus, innilana pun na natayan Jesus, anana, “Tuttuway siyan Anà Apudyus!” ");
INSERT INTO ksc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Iningkaw akon uchumi fubfufai wi nan-oottap. Na uchum an chicha, cha Maria Magdalena, Salome ya Maria wi inacha Jaime wi chakanchan ya Jose. ");
INSERT INTO ksc_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Chichan nituntun-ud an Jesus wi fummachang an siya ta iningkawanad Galilea. Ad iningkaw akon achuy fubfufai wi nitun-ud an siya ta ummayanad Jerusalem. ");
INSERT INTO ksc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Mummaschom pun, wi sachin mangisakanaan na Judio ta losani masapurcha para ta Safachuy ngingillinan, ");
INSERT INTO ksc_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","chummatong na osay iyArimatea wi mangngachan à Jose. Siyan osay malispituy kunsisar na Judio, ya siya kon osay man-uullay ta milukiyan na Manturayan Apudyus. Ad inturod Jose wi ummoy an Pilato chinawat na lachag Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Naschaaw à Pilato wi nangngor wi narpas natoy à Jesus, siyan impaayagnan kapitan na surchachu à manuttuwaana wi natoy à Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ad na kapitan na surchachu, imfakanay tuttuway natoy à Jesus. Siyan imparufus Pilato à Jose wi umoy mangara ta lachag Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ad ngumminà Jose à mamputilà à uros ad impasnan lachag Jesus ta kros ad finussungna ta uros, ad inyoyna illofon ta lofoni tinukutukanchay fatu. Ad linikadnan chakorani fatu intumar ta liwangan na lofon. ");
INSERT INTO ksc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ad cha Maria Magdalena ya Maria wi inan Joses, innilacha kon nilobnan Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Narpas pun na Safachuy ngingillinan, ummoycha Maria Magdalena ya Salome ya Maria wi inan Jaime ngumminà fangfangu ta ilanogcha ta lachag Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ad figfikat pun ta asini nafikat wi Chumingku, ummoycha ta nilobnan Jesus. ");
INSERT INTO ksc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ad na nanadcharanancha ummoy, nan-asiimuscha anani, “Sinun mallikad ta fatuy tangob na lofon?” ");
INSERT INTO ksc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ngim na nichaumancha ta lofon, innilachan fatuy tangobnay chakoran wi niyadchayang nalikad ta liwangan. ");
INSERT INTO ksc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ad linumnòcha ta lofon ad innilachan osay isù fafaru wi nansilup à mamputilà, wi ummaachuy ta apot ta chiwawancha. Ad ummogyatchay nangilan siya. ");
INSERT INTO ksc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ad ananan chicha, “Achiayu umogyat. Akammù wi ummaliyu ilan à Jesus wi iNazaret wi nailansa ta kros. Ngim maid ad asna tan ummuli nataku! Ilanyun nangifanatanchan siya. ");
INSERT INTO ksc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Siyan ing-ayu ifakan Pedro ya chachi uchumi disipulusna wi umuna umoy à Jesus ad Galilea ta sachin mangil-anchan siya, wi sachin imfakanan chicha ta sin-arkawan.” ");
INSERT INTO ksc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ad nanodchàchay lummayaw ta sachi lofon wi namaypayogpogcha ta amochi ogyatcha. Ad maid pu imfakacha ta uray sinuman kapu ta ogyatcha. ");
INSERT INTO ksc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Na ummuliyan Jesus natakuwan ta figfikat ta Chumingku, Maria Magdalena na chamuy nampail-ana, wi siyan namaryawana ta pituy aran. ");
INSERT INTO ksc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ad ummoy Maria imfaka ta chachi fufurun Jesus wi asiluruway nangichomchom an siya. ");
INSERT INTO ksc_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ngim uray chingngorcha wi ummuli natakù Jesus, ad innilan Maria, achicha pu tuttuwaon. ");
INSERT INTO ksc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ad nampaila kò Jesus ta chuway fufurunna wi manadcharan wi umoy ta osay ili, ngim safalin nampail-anan chicha. ");
INSERT INTO ksc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ad nangulincha wi nangifaka ta chachi fufuruncha, ngim achicha pu ko tuttuwaon chicha. ");
INSERT INTO ksc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Na anungusna, nampaila kò Jesus ta chachi nasawaran à osay disipulusna ta nan-ooanancha. Ad inomorana chicha tan natangkin na urucha wi achicha pun tuttuwaon chachi nangilan siya ta ummuliyana natakuwan. ");
INSERT INTO ksc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ad anana kon chicha, “Ing-ayu itudtuchu na Mamfaruy Chamag mipangkop an saon ta losani taku ta lufung. ");
INSERT INTO ksc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ad sinumani mamati ya mafunyakan, makafiyag an Apudyus à ing-ingkana. Ngim sinumani achi pu mamati, ifallun Apudyus à siya ta machusaanà ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Chachi mamati, maadchanchà karobfonganchay mangwà kaskaschaaw, tan mipakapu ta karobfongà makaparyawcha ta aran wi farfaray, ya mafalin ako wi man-ukudchà safalì ukud. ");
INSERT INTO ksc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ya uray nu ognanchan urog winnu inumonchan ochot, maid ananan chicha. Ad nu agpachanchan nasakit, umimfagcha.” ");
INSERT INTO ksc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Narpas pun na sachi imfakan Apu Jesus an chicha, nipangatud langit, ad tummùchu ta apot ta chiwawan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ad chachi disipulusna, ummoycha intudtuchu na Mamfaruy Chamag ta ailiili. Ad iniingkaw akò Apu Jesus wi mamachang an chicha, ad inadchona kon karobfonganchay mangwà kaskaschaaw à manuttuwaan na taku wi katuttuwaan na itudtuchucha.");
INSERT INTO ksc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Apu Teofilo, akammuta wi achun nangip-ippong wi nangiyug-is mipangkop ta iningwan Jesus ta iningkawanad asnay luta. ");
INSERT INTO ksc_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Inyug-ischan chingngorcha ta inug-ugkud chachi nangiila ta nànàwa nanipud ta lukina, wi chichan nangisursuru ta Mamfaruy Chamag an chitau. ");
INSERT INTO ksc_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Siyan, Apu, kapu ta ninarmà inachar losan na anchanayay nàwa nanipud ta nilukiyancha, simsimmòuy mamfaru nu narmà wi mangisurat an sia, ");
INSERT INTO ksc_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","à mangakammuwam ta katuttuwaan na nitudtuchun sia. Ad amasnan nàwaana. ");
INSERT INTO ksc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Na timpun na manturayan Ali Herod ad Judea, iningkaw na osay pachin na Judio wi nangngachan à Zacarias, wi kanà Abias wi miyawaruy sùnub wi pachi. Na asawanay Elisabet, kanà Aaron wi ap-apun na papachi. ");
INSERT INTO ksc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Na anchanay man-asawa, mamfarucha an Apudyus tan tinungparcha losan na lintogna ya tudtuchuna. ");
INSERT INTO ksc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ngim maid pu anàcha tan fasig à Elisabet, ya narakarakaycha. ");
INSERT INTO ksc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Na osay padchay nan-iwaaran Zacarias wi pachi ta Templo, namfinfinnunut na papachi tan sachin ukalichà mangil-ancha nu sinun lumnò ta charom na Templon Apudyus ta timpun na malluwaruwan. Ad Zacarias na nafunut, siyan linumnò à siyà mam-u ta insenso. ");
INSERT INTO ksc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ad na nam-uwana ta insenso, iningkaw na takuy ad-adchuwan ta lasin wi malluwaru. ");
INSERT INTO ksc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sachi ad, nampailan Zacarias na osay anghel Apudyus, wi ummagsad ta apot ta machiwawan ta pupùwan à insenso. ");
INSERT INTO ksc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ad nataag à Zacarias ta nangil-ana ta anghel, ad naosyawan. ");
INSERT INTO ksc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ngim kummingan sachi anghel, wi anana, “Zacarias, achia umogyat! Tan chingngor Apudyus na luwaruyu. Umanà na asawam wi Elisabet à larai, ad ngachananyù siyà Juan. ");
INSERT INTO ksc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Lumagsak-ayu mipakapun siya, ya uray na achuy taku! ");
INSERT INTO ksc_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ad à Apudyus, ifilangnà siyà nangatu. Manipud ta mifùnakana, makarong-ag na Ispiritun Apudyus an siya. Ad masapur achi pu uminum à isun na fayas winnu sinumani sumalimong. ");
INSERT INTO ksc_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ad mipakapun siya, mansakung na achuy kanà Israel an Apudyus ta umapuchan siya. ");
INSERT INTO ksc_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ad sakanaonan chumatngan na Aputau, wi na oyyoona, isun na sachi profeta wi Elias ta awi, wi isun akon karobfongana. Tan mantitimpuyukonan somsomò na man-aama, ad faliwanan somsomò na takuy achi pu mamati, ta miyisun somsomòcha ta somsomò na mamfaruy taku. Sachin mangisakanaana ta takù mangngorancha ta Apucha nu umali.” ");
INSERT INTO ksc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ngim anan Zacarias ta sachi anghel, “Sinun manuttuwaà wi màwan sanati ifagfakam? Tan narakarakay-ani wi man-asawa.” ");
INSERT INTO ksc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ad anan na anghel, “Saon à Gabriel wi ingkaw ta sangwanan Apudyus. Ad imfaunà an siya wi umali mangifakan sia ta annayay mamfaruy chamag. ");
INSERT INTO ksc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ngim kapu ta achim pu tinuttuwan imfakà, achia pu makakinga ingkanà màwaan na annay imfakà. Tan tuttuway chumatong na ustuy timpuy màwaana.” ");
INSERT INTO ksc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na takuy nanguullay an Zacarias, naschaawcha tan nafayag ad charom na Templo. ");
INSERT INTO ksc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ngim lummawa pù Zacarias, naawatancha wi awad na impailan Apudyus an siya ad charom, tan achi pu makakinga, wi imana kan insingsingyarna. ");
INSERT INTO ksc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Narpas pun na iwaar Zacarias ta Templo, nangulin ad ilicha. ");
INSERT INTO ksc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ad naarkawanan ad, nangngilin à Elisabet, siyan iniingkaw ad foroychà limay furan. ");
INSERT INTO ksc_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ad anana, “Tuttuway inachakuwanà an Apudyus, tan inaannan mifafainà tan annan anàu!” ");
INSERT INTO ksc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Na miyanomi furan ta fukin Elisabet, imfaun Apudyus na anghel wi Gabriel wi umoy ad Nazaret wi osay ilid Galilea. ");
INSERT INTO ksc_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Iningkaw na umoyna ifaka ta osay fafarasang wi nangngachan Maria. À Maria, nipagta ta osay larai wi nangngachan Jose, wi osay kanà Ali David. ");
INSERT INTO ksc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nampaila pun na anghel an Maria, anana, “Lumagsak-a! Annat à Apudyus an sia ad fininchisyunanà sia!” ");
INSERT INTO ksc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Naos-osyawan à Maria ta nangngorana ta imfakan na anghel, ad som-osom-ona nu sinun mining na inukudna. ");
INSERT INTO ksc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ad anan na anghel an siya, “Achia umogyat, Maria! Annayan mangichayawan Apudyus an sia: ");
INSERT INTO ksc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mafukia, ad umanàà larai, ad ngachananyù siyà Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mapatog à siya ya maawakan à Anà Apudyus wi Angatuwan, ya ipatawid Apudyus an siyan kinaalin David wi apuna ta awi. ");
INSERT INTO ksc_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Siyan man-Ali ta losani kanà Jacob à ing-ingkana, wi maid pu mapagpakan na manturayana!” ");
INSERT INTO ksc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ad anan Maria ta sachi anghel, “Ngim fafarasangà, ya maid pu nakasuyop an saon à larai. In-inon na màwaan na ug-ugkuchom?” ");
INSERT INTO ksc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ad summongfat na anghel, anana, “Umalin Ispiritun Apudyus an sia, ad mafukia kapu ta karobfongan Apudyus. Siyan na anà wi iyanànu, maakammuwan wi maid pu fasurna, ad maawakan à Anà Apudyus. ");
INSERT INTO ksc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Somsom-om à Elisabet, wi akim, wi ananchay fasig. Ngim uray nu amaschi, onom furan na fukina ta sana, uray narakay. ");
INSERT INTO ksc_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Sachin mail-ana wi maid achi mafalin an Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ad anan ako Maria, “Saniluwà an Apudyus. Siyan màwa losan na imfakam an saon.” Sachi ad lummayaw na anghel. ");
INSERT INTO ksc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Naarkawanan ad, lummigwat à Maria ad kinankanasnay ummoy ta osay ili ta filfilig ta provinsiya wi Judea. ");
INSERT INTO ksc_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Chummatong pun, linumnò ta foroycha Zacarias ad finagfakanà Elisabet. ");
INSERT INTO ksc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Chingngor pun Elisabet na kingan Maria, nan-isin fukina. Ad impaspasmò na Ispiritun Apudyus an Elisabet, ");
INSERT INTO ksc_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ad chinakornan kinganay mangwanan an Maria, “Ta losani fufai, sian chinutukan Apudyus wi mangadchanà afaruwan, ad machaychayaw na anà wi iyanànu!” ");
INSERT INTO ksc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ad anana ko, “Sinun kinatatakù wi annay umali fumisitan saon na inan na Aputau? ");
INSERT INTO ksc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tan chingngor-u pun na kingam, nan-isin fukì ta tottoròna. ");
INSERT INTO ksc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ad maragsak-a ko, tan pinatim wi tumuttuwan losani imfakan Apudyus an sia!” ");
INSERT INTO ksc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Sachi ad anan Maria, “Chaychayawò à Apudyus, ");
INSERT INTO ksc_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ya naragsakà ako mipakapun siyay Manaraknib an saon, ");
INSERT INTO ksc_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","tan simsimmoà an siya wi kafafaan ta takuna! Siyan manipud ta sana, anan na losani taku wi nakasatà, ");
INSERT INTO ksc_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","tan à Apudyus wi Mannakafalin, kaskaschaaw na iningwanan saon. Tuttuway machaychayaw à siya wi maid fasurna. ");
INSERT INTO ksc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Achakuwana losan na takuy mangiyafain an siya ta arunarunap nanipud ta chamchamu ya ingkanà anungus na lufung. ");
INSERT INTO ksc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Na iningwana, sachin mangipail-ana ta karobfongana. Ad kinassawnan puranun na losani mamàpail-on. ");
INSERT INTO ksc_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Impafafanan nangangatuy ali, ad impangatunan nafafa. ");
INSERT INTO ksc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Chachi manchawat à fachang, achun inadchonay mamfaru an chicha. Ngim chachi nanat-op ta kinafarucha, imparyawnà chicha wi maid inadchona. ");
INSERT INTO ksc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tinungparnan sachi impustana ta aapputau ta awi, ad fafadngan chitauy kanà Israel. ");
INSERT INTO ksc_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Foon à maliwatanan sachi impustanan Abraham ya losani kanàna, tan achakuwan chitaù ing-ingkana.” ");
INSERT INTO ksc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ummoy à turuy furan na iningkawan Maria an Elisabet achiyot lumayaw. ");
INSERT INTO ksc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nachauman pun na umanaan Elisabet, inyanànan larai. ");
INSERT INTO ksc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ad chingngor pun na charchar-agna ya aagkina wi inachakuwan Apudyus à siya, nakaragsakchan siya. ");
INSERT INTO ksc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Na awarun padchan na anà, ummoycha impasingyar à manungparancha ta Lintog. Ad na uchum, pionchay ingachan à Zacarias wi ngachan na amana, ");
INSERT INTO ksc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ngim anan na inana, “Foon, Juan na mangngachanna.” ");
INSERT INTO ksc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ad anancha, “Tamako, tan maid pu akiyù nginngachan à Juan!” ");
INSERT INTO ksc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sachi ad insingyarchay mangimus an amana nu sinun pionay ipangachan ta anàna. ");
INSERT INTO ksc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ad insingyarnay mampaarà mangug-isana, ad inyug-isna, “Na ngachanna, Juan.” Ad naschaawcha losan! ");
INSERT INTO ksc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ad na sachi, nakakingà Zacarias, ad nan-ukud wi nanaychayaw an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ad naschaaw losan na charchar-agcha. Ad losan na taku ta filfilig ad Judea, chinamagcha kon losani nàwa. ");
INSERT INTO ksc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ad losan chachi nangngor, som-osom-oncha nu, “Sinu nin na mamfalinan na sanati anà nu chumakor?” Amaschin somsomòcha tan narawag wi annan karobfongan Apudyus an siya. ");
INSERT INTO ksc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ad naatod na Ispiritun Apudyus nakarong-ag an Zacarias wi aman Juan, ad imfakanan impaakammun Apudyus, anana, ");
INSERT INTO ksc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Chayawontaù Apudyus wi Aputauy kanà Israel, tan annay ummali wi mamachang an chitauy takuna ad sinaraknifanà chitau. ");
INSERT INTO ksc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tan imparoswanan osay mannakafalin à manaraknib an chitau, wi kanà na sanilunay Ali David. ");
INSERT INTO ksc_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ad impaakammuna ta chachi naapudyusani profetasna ta awi na impustana. ");
INSERT INTO ksc_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Na osay impustana, saraknifanà chitau ta afusurtau ya karobfongan na losani mallawing an chitau. ");
INSERT INTO ksc_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Na osa koy impustana ta aapputau, achakuwanà chicha ad sosom-onan inturagnan chicha. ");
INSERT INTO ksc_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Na impustanan Abraham wi aputau, insapatana wi saraknifanà chitau losan ta afusurtau ta maid umogyatantauy mangwa ta piona, ");
INSERT INTO ksc_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","tapnu maid makafasurantau ya miyustuustun oyyoontau, ta sanay atattakutau.” ");
INSERT INTO ksc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ad nan-ukud akò Zacarias ta anàna, wi anana, “Siay anàu, maawakan-à osay profetan Apudyus wi Angatuwan. Ad sian paunaon Apudyus mampasakanaon ta taku ta chumatngan na Aputau. ");
INSERT INTO ksc_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ad sian mangipaakammu ta taku wi masaraknifancha nu ipakawanchan fasurchan siya. ");
INSERT INTO ksc_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tan à Apudyus, masayaaw ya isag naanus, ad na manaraknifanan chitau, isun na sumingitan na init. ");
INSERT INTO ksc_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Isù iingkawtau ta pangot tan amod na ogyattau wi matoy. Ngim nu chumatong na Aputau, lawakanà chitau ad pafaruwonan somsomòtau ta mitimpuyugtaun Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ad chummakor na anàcha, ad pummigsan somsomònan Apudyus. Ad ummoy iningkaw ta ikaw wi maid pu umili ingkana ta timpun na mangilukiyanay mantudtuchu ta chachi kanà Israel. ");
INSERT INTO ksc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Na sachi timpu, illintog Augusto wi Ali ad Roma, wi masapur mampalistan losani taku ta manturayana ta sikuchi ilin na aappucha. ");
INSERT INTO ksc_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Na sachi chamuy milistaan na taku, timpun na namfifinnachuran Kirenio ad Siria. ");
INSERT INTO ksc_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Siyan waschi osay taku umoy mampalista ta sikuchi ilin na aappuna. ");
INSERT INTO ksc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Siyan lummigawat à Jose ad Nazaret wi ili ad Galilea, wi umoy ad Betlehem wi ili ad Judea, tan siyan niyanaan na apuna wi Ali David. ");
INSERT INTO ksc_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nakaoy akò Maria wi nipagtay man-asawana. Akin-annaon à Maria, ");
INSERT INTO ksc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ad na iningkawanchad Betlehem, siyan timpuy umanaana. ");
INSERT INTO ksc_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ngim maid pu kuwartù ingkawancha ta farangnay foroy ta sachi, siyan iningkawcha ta sikay wi papàanan ta ayam. Ad inyanà Maria na panguruy anàna wi larai. Ad inursana ad imfàsarna ta atutung. ");
INSERT INTO ksc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na sachi ili, anchanan uchumi mampapastor ta pannilu ta puppurag, wi lafiyonchay fafantayan na pannilucha. ");
INSERT INTO ksc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ad naanagsad nampailan osay anghel Apudyus an chicha, ad nalinangancha ta sumiling wi lawag wi narpun Apudyus ad langit. Isagcha ummogyat, ");
INSERT INTO ksc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ngim anan na anghel an chicha, “Achiayu umogyat! Tan ummaliyà wi mangipagngor an chiayu ta mamfaruy chamag wi mamparagsak ta losani taku. ");
INSERT INTO ksc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Na sanay lafi, niyanà ta ilin David na Sumaraknib ta taku. Siyan Cristu wi Apu! ");
INSERT INTO ksc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na manuttuwaanyu, ochasanyun anà wi naursan wi mifafàsar ta atutung.” ");
INSERT INTO ksc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Sachi ad nampailan ad-adchuwani anghel ad langit, ad chinaychayawchà Apudyus, wi anancha, ");
INSERT INTO ksc_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Machaychayaw à Apudyus ad langit wi angatuwan! Farfaruwonan somsomò na losani takud asnay luta wi mamparagsak an siya.” ");
INSERT INTO ksc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Lummayaw pun na aangheles wi namagkulin ad langit, nan-uukud chachi mampapastor, wi anancha, “Intaud Betlehem ilan na sachi nàwa, wi impaakammun Apudyus an chitau.” ");
INSERT INTO ksc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Siyan inaw-awaychay ummoy, ad inchasancha cha Maria an Jose ya sachi anà wi nifafàsar ta atutung. ");
INSERT INTO ksc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ad na nangil-anchan siya, impaakammucha losan na imfakan na anghel mipangkop an siya. ");
INSERT INTO ksc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ad naschaaw losan na nangngor ta imfakan chachi mampapastor. ");
INSERT INTO ksc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ad à Maria, nasnasmòna losan na anchanaya ad simmosimmònan losani nànàwa. ");
INSERT INTO ksc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ad nangulin chachi mampapastor ta puppurag wi manaychayaw an Apudyus mipakapu ta losani innilacha ya chingngorcha, tan tuttuway nàwa losan na imfakan na anghel an chicha. ");
INSERT INTO ksc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Na awarun padchana wi timpun na masingyaran na anà, nginachananchà siyà Jesus wi sachin imfakan na anghel ta chaan pun na inana mangngilinan. ");
INSERT INTO ksc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Chummatong ad na timpu wi manungparancha Maria an Jose ta illintog Moses à macharusan na fufai wi ummanà, ummoychad Jerusalem wi inawitcha kò Jesus ta umoycha iparang an Apudyus, ");
INSERT INTO ksc_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","tan niyug-is ta ukud Apudyus wi, “Na panguruy anà wi larai, masapur miparang an Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Na osay pangkop na ummayancha ta Templo, umichatunchà chuwà karupati winnu chuwà amaschì sissiwit, wi sachi kon manungparancha ta lintog Apudyus. ");
INSERT INTO ksc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na sachi timpu, iningkaw ad Jerusalem na osay marmarong-ag wi mangngachan Simeon. Mamfarun achawiyana tan patpatkonan lintog Apudyus, ya siya kon osay manguullay ta masaraknifan na chokanay kanà Israel. Iniingkaw akon Ispiritun Apudyus an siya, ");
INSERT INTO ksc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ad impakaawatnan Simeon wi achi pu matoy ingkanà ilanan Cristu wi impustan Apudyus wi umali. ");
INSERT INTO ksc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na sachi timpu, impuyut na Ispiritun Apudyus à siya ta Templo. Ad sachi kon timpuy nangilon-ancha Jose an Jesus ta Templo ta matungpar na Lintog mipangkop ta niyanà. ");
INSERT INTO ksc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ad na nangil-an Simeon ta sachi anà, inàlina ad nanyaman an Apudyus wi anana, ");
INSERT INTO ksc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Apu, uray iparufusnun matayà ta sana, tan annay tummuttuwan impustam an saoni nafafay takum. ");
INSERT INTO ksc_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tan innilà à siya wi manaraknib ta taku, ");
INSERT INTO ksc_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","wi siyan simsimmònu ipaakammu ta losani taku: ");
INSERT INTO ksc_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Siyan mallawag ta somsomò chachi foon pù kanà Israel, wi mampaakammun chicha ta piomi pàwa. Ad siya kon mangipachayaw an chiani wi takum wi kanà Israel.” ");
INSERT INTO ksc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Naschaaw na inan Jesus ya amana ta nangngorancha ta inukud Simeon mipangkop an siya. ");
INSERT INTO ksc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ad fininchisyunan Simeon chicha, ad anana kon Maria wi inan Jesus, “Na annay anànu, chinutukan Apudyus à siya, ad mipakapun siya mayam-an ya mifallu na achuy kanà Israel, ngim achu kon masaraknifan mipakapun siya. Siyan singyar Apudyus wi kuraon na achuy taku, ");
INSERT INTO ksc_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ad sachin mangipaakammuwancha ta nitataruy somsomòchay lawing. Ad à sia wi inana, mansasauy-a kapu ta màwan siya.” ");
INSERT INTO ksc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ad iningkaw ako ta sachi na osay profeta wi madmad-an wi mangngachan Ana wi anà Fanuel wi kanà Aser. À Ana, pituy tawon na nangasaw-ana, ");
INSERT INTO ksc_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","wi nafaru, ad umoy à warumpuru ya opat na tawonna. Kanayun iniingkaw à Ana ta Templo wi manaychayaw an Apudyus ya malluwaru ta finikat ya linafi, ya mallangan wi mangan à simfofotang. ");
INSERT INTO ksc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na sachi uras, inafotna cha Jesus, siyan naam-amod na nanyamananan Apudyus. Ad nanipud ta sachi inukudnan mipangkop an Jesus ta losani takuy manguullay ta sachi manaraknib an chichay kanà Israel. ");
INSERT INTO ksc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kinangput pun cha Jose an Maria na losani filin ta lintog Apudyus, nangulinchad Nazaret wi ilichad Galilea. ");
INSERT INTO ksc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ad chummakor na anà ta sachi, ad pummigsan somsomòna. Naraing akò siya, ad finadngan Apudyus à siya. ");
INSERT INTO ksc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Na namingsan ta makatawon, ummoy na inan Jesus ya amana ad Jerusalem nakakimkimung ta Fiyastay Mangiyakasmoan, tan sachin nangiyakasmoancha ta nallausan na anghel Apudyus ta chachi kanà Israel ad Egipto ta awi. ");
INSERT INTO ksc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nasawaran pù chuwan tawon Jesus, nakaoy ako wi umoy makafiyasta. ");
INSERT INTO ksc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Narpas pun na fiyasta, lummayaw na amana ya inana wi mangulin ad ilicha. Ngim achicha pu akammu wi nataynan na anàchay Jesus ad Jerusalem, ");
INSERT INTO ksc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","tan anancha pu kay nu nifurog à siya ta fufuruncha. Ad pinadchachay manadchadcharan ad iyukudchà siya ta sachi furogcha wi fufuruncha ya aagkicha, ");
INSERT INTO ksc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ngim maid pu inchasancha. Siyan namagkulinchad Jerusalem anapon à siya. ");
INSERT INTO ksc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Na atlun padchana, inchasanchà siya wi nakaam-ammung ta mimisturun na Judio ta Templo, wi manchochongngor ya man-im-imus an chicha. ");
INSERT INTO ksc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Na losani manchongor an siya, naschaawcha ta kinaraingnay sumongfat ta losani inimuschan siya. ");
INSERT INTO ksc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ad naschaaw akon amana ya inana ta nangil-anchan siya, ad anan na inana, “Anàu, amod na chanagnin amam wi manganap an sia. Tam-ako oyyoon na amaschin chiani?” ");
INSERT INTO ksc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ngim summongfat à Jesus, “Tamako masapur anaponà? Inakammuyu kuma wi masapur awachà ta foroy Ama.” ");
INSERT INTO ksc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ngim foon pù naawatanchan inukud Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Sachi ad nifurun à Jesus an chicha wi nangulin ad Nazaret, ad pintognan losani pàwacha. Ad à inana, simmosimmòna losan na nànàwa. ");
INSERT INTO ksc_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ad à Jesus, chummakor ad pummigpigsan kinaraingna. Ad inay-ayat na losani takù siya, ad à Apudyus, isag maragsakan an siya. ");
INSERT INTO ksc_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Na miyasimpuru ya limay tawon na nanturayan Ali Tiberio ad Roma, iningkaw na impaspasmò Apudyus an Juan, wi anà Zacarias, ta iningkawana ta ikaw wi maid pu umili. Na sachi timpu, Poncio Pilato na fifinnachur ad Judea, Herod na nanturay ad Galilea, Felipe wi sunudnan nanturay ad Iturea ya Traconite, ad Lisanias na nanturay ad Abilene. Na angatuwani papachin na Judio ta sachi tawon, cha Anas an Caifas. ");
INSERT INTO ksc_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ad nangkagkagkaay à Juan ta losani sakup na Chawwang wi Jordan mantudtuchu ta taku, wi anana, “Masapur ifafawiyun lawingi oy-oyyoonyu, ya mampafunyag-ayu, ad pakawanon Apudyus chiayu.” ");
INSERT INTO ksc_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Amaschin matungparan na inyug-is Isaias wi profetan Apudyus ta awi, wi anana, “Awad na osay taku ta ikaw wi maid pu ili, wi mangip-ip-aw ta taku anani, ‘Annay chumatong na Apu. Pafaruwonyun somsomòyu ya mansakanaayu, wi isun na mangikakatan ta charan nu siya chumatong na Ali. ");
INSERT INTO ksc_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Maafab losan na challug ya matanap losan na takudtud ya filig. Malinchong na charan wi namparpalikku ya miparuum na arsa wi lasurasung, ");
INSERT INTO ksc_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ta losan na taku ilan na mansaraknifan Apudyus!’” ");
INSERT INTO ksc_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ad-adchuwan na takuy ummoy pafunyag an Juan, ngim illasinna pun na somsomòcha, anana, “Apay, chiayuy nasikap! Sinun nangifakan chiayu wi mampafunyag-ayu kay ta ilisiyun chusan Apudyus ta taku? ");
INSERT INTO ksc_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Masapur oyyoonyun sinuy mangipaila wi tuttuway namfafawiayu ta fasuryu. Ad achiyu namnamaoni mailisiyun kachusaanyu ta mangwanaanyuy kanà Abraham chiayu. Tan ifakà an chiayu, wi uray na anchanayay fatu, mafalini mamfalinon Apudyus chichà kanà Abraham nu piona! ");
INSERT INTO ksc_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Na miyalikan na manusaan Apudyus ta taku, isù pannakur wi nififiyad wi manipur ta ayu ta lamutna. Siyan losani imong wi achi pu mamkas à mamfaru, masipur ad maskob.” ");
INSERT INTO ksc_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ad nan-im-imus na takun Juan, wi anancha, “Ad sinun oyyoonni nù?” ");
INSERT INTO ksc_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ad na insongfat Juan an chicha, anana, “Na takuy chuwan silupna, masapur adchonan osa ta takuy maid pun silupna. Isuna ko, na takuy awad anona, masapur adchana kon takuy maid pun anona.” ");
INSERT INTO ksc_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ummoy akon uchumi manchachakup à fukis an Juan mampafunyag, ad inimuscha, “Misturu, sinu kon oyyoonni nù?” ");
INSERT INTO ksc_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ad anana, “Achiyu parabsan na fayad na fukis na taku.” ");
INSERT INTO ksc_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ad inimus akon uchumi surchachun siya, “Chiani ngay, sinu kon oyyoonni?” Ad ananan chicha, “Achiyu palikatan na takù mangar-anyu ta pionyu, ya achiyu pafasuron na taku nu foon pù katuttuwaan. Mat-op-ayu kuma ta suwilchuyu.” ");
INSERT INTO ksc_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na nangngoran na taku an Juan, isagcha som-osom-on na chumatngan na Cristu wi impustan Apudyus wi umali manturay, ad na somsomòcha, siya nin à Juan. ");
INSERT INTO ksc_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Siyan anan Juan an chicha, “Awad na umali wi misukat an saon wi nangatngatu nu saon, wi kurangà à mansaniluna. Chanum yakan ifunyag-un chiayu, ngim à siya, ifunyagnan chiayun Ispiritun Apudyus ya apuy. ");
INSERT INTO ksc_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ad nu umali, ilasinnan mamfaruy taku ta lawing, wi isun na mantopà finayu wi ilasinnan finayu ta chuki. Na finayu, iyarangna, ngim na chuki, mifallu ta apuy wi achi pu masobsofan.” ");
INSERT INTO ksc_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Siyan nangkarakarasin pinagtudtuchun Juan ta taku ta Mamfaruy Chamag à mamatiyancha kuma. ");
INSERT INTO ksc_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ngim ingkimaun Juan à Herod wi Fifinnachur, tan pillos Herod à Herodias wi asawan na sunudna, ad achu kon iningwanay lawing. ");
INSERT INTO ksc_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ngim inam-amod Herod na fummasurana, tan impafarudnà Juan. ");
INSERT INTO ksc_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Na osay padchay nafunyakan na achuy taku, finunyakan ako Juan à Jesus. Ad na nalluwaruwan Jesus, niwanit ad langit, ");
INSERT INTO ksc_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ad na Ispiritun Apudyus, nan-osog lummap-oy an siya wi isù karupati. Ad iningkaw na kinga wi narpud langit, wi anana, “Sian anàu wi ay-ayatò. Maragsakanà an sia.” ");
INSERT INTO ksc_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Na nallukiyan Jesus wi nantudtuchuwan, naturumpurun tawonna. Ad na somsomò na taku, anancha pun nu siyan anà Jose. À Jose, anà Eli ");
INSERT INTO ksc_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","wi anà Matat. À Matat, anà Levi. Ad à Levi, anà Melke, wi anà Jane wi anà Jose. ");
INSERT INTO ksc_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","À Jose, anà Matatias, wi anà Amos. À Amos, anà Nahum, wi anà Esli wi anà Nagi. ");
INSERT INTO ksc_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","À Nagi, anà Maat wi anà Matatias. Ad à Matatias, anà Semei wi anà Jose, ad à Jose, anà Juda. ");
INSERT INTO ksc_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","À Juda, anà Joanan, wi anà Resa. Ad à Resa, anà Zorobabel wi anà Sealtiel, wi anà Neri. ");
INSERT INTO ksc_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","À Neri, anà Melke wi anà Addi. Ad à Addi, anà Cosam wi anà Elmodam, wi anà Er. ");
INSERT INTO ksc_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","À Er, anà Josue wi anà Eliezer, wi anà Jorim. Ad à Jorim, anà Matat wi anà Levi. ");
INSERT INTO ksc_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","À Levi, anà Simeon wi anà Juda, ad à Juda, anà Jose. Ad à Jose, anà Jonan wi anà Eliakim. ");
INSERT INTO ksc_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","À Eliakim, anà Milea wi anà Mena, wi anà Matata. Ad à Matata, anà Natan wi anà David. ");
INSERT INTO ksc_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","À David, anà Jesse wi anà Obed. Ad à Obed, anà Boaz wi anà Salmon, wi anà Naason. ");
INSERT INTO ksc_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","À Naason, anà Aminadab wi anà Admin, wi anà Arni. Ad à Arni, anà Esrom wi anà Faris, wi anà Juda. ");
INSERT INTO ksc_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","À Juda, anà Jacob wi anà Isaac. Ad à Isaac, anà Abraham. Ad à Abraham, anà Tare wi anà Nacor. ");
INSERT INTO ksc_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","À Nacor, anà Serug wi anà Ragau, wi anà Peleg. Ad à Peleg, anà Heber wi anà Sara. ");
INSERT INTO ksc_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","À Sara, anà Cainan wi anà Arfaxad, wi anà Sem. Ad à Sem, anà Noe wi anà Lamec. ");
INSERT INTO ksc_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","À Lamec, anà Metusela wi anà Enoc, wi anà Jared. Ad à Jared, anà Mahalaleel wi anà Cainan. ");
INSERT INTO ksc_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","À Cainan, anà Enos wi anà Set. Ad à Set, anà Adam wi anà Apudyus. ");
INSERT INTO ksc_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nafunyakan pù Jesus, tinaynanan sachi Chawwang wi Jordan, ad na Ispiritun Apudyus wi iingkaw an siya, impuyutna ta ikaw wi maid pu takù ingkaw. ");
INSERT INTO ksc_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ad sachin namachasan Satan an siya makafasuron ta unog na opatpuruy padcha. Na sachi timpu, foon pù nangnangan à Jesus, siyan nafitifitil à siya ta anungusna. ");
INSERT INTO ksc_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Siyan anan Satan an siya, “Nu tuttuway anà sian Apudyus, mamfarfalinom tinapoy na annayay fatu.” ");
INSERT INTO ksc_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ad sinongfatan Jesus à siya anani, “Niyug-is ta ukud Apudyus wi, ‘Foon pu kà tinapoy afus na ifiyag na taku.’” ");
INSERT INTO ksc_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sachi ad, inyoy Satan à Jesus ta tànangani filig, ad na sachi anayun inaminna impailan siyan losani mansabsafali wi maiturayan ta luta. ");
INSERT INTO ksc_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Ad anan Satan an siya, “Nu chayawonà, adchò an sian karobfongam wi manturay ta ailiili ya kinafaknangcha. Mafalin-u adchon ta sinumani chutukà, tan niyawatchan saon.” ");
INSERT INTO ksc_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ad sinongfatan Jesus à siya anani, “Na niyug-is wi ukud Apudyus, anana, ‘Maid uchum à chayawonyu nu achi afus na Apuyu wi Apudyus, ya afus akò siyà patkonyu!’” ");
INSERT INTO ksc_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ad inyoy ako Satan à Jesus ta tabfungan na Templo ad Jerusalem. Ad ananan siya, “Nu tuttuway anà sian Apudyus, man-odchag-a, ");
INSERT INTO ksc_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","tan niyug-is ta ukud Apudyus wi, ‘Filinon Apudyus na aanghelesnà mangayyuwan an sia.’ ");
INSERT INTO ksc_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ad niyug-is ako wi, ‘Sìpawonchà sia, ta uray na chapannu, achi pu masukat ta fatu.’” ");
INSERT INTO ksc_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ngim sinongfatan Jesus à siya anani, “Ngim niyug-is ako wi, ‘Achim padpachason na Apum wi Apudyus.’” ");
INSERT INTO ksc_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Limpas pu Satan padpachason à Jesus makafasuron, tinaynanà Jesus ingkanà asinna ko pachason nu matimpuwan na màwaana. ");
INSERT INTO ksc_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nangulin à Jesus ad Galilea, wi iingkaw na karobfongan na Ispiritun Apudyus an siya. Ad nanchinamag na mipangkop an siya ta losani nampalìwos wi ili. ");
INSERT INTO ksc_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nantudtudtuchu ta chachi sinagoga wi makimkimungan na Judio, ad chinayaw losan na takù siya. ");
INSERT INTO ksc_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ad ummoy à Jesus ad Nazaret wi chummakrana, ad na Safachu wi ngilinon na Judio wi man-iwaar, ummoy ta sinagoga wi makimkimungan na Judio, tan sachin achawiyana. Ad summiad à Jesus wi mamfasa ta ukud Apudyus, ");
INSERT INTO ksc_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ad inyawatchan siyan nibruy inyug-is Isaias wi profeta ta awi. Finìyadna pun piniliyanan fasaona. Ad na finasana, ");
INSERT INTO ksc_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Annan saon na Ispiritun Apudyus tan chinutukanà an siya à mangipaakammu ta mamfaruy chamag ta losani takuy maid mafalincha. Ad imfaunà wi mangipagngor ta takuy isù nafarud wi miparufuscha, ya takuy nakurap wi maaan na kurapcha, ya takuy maparpalikatan wi miparufuscha ko. ");
INSERT INTO ksc_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ad na ifakà ako, chummatong na timpuy mangipail-an Apudyus ta achakuna ta taku.” ");
INSERT INTO ksc_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ad linuut pun Jesus na nibru, inyulinna ta takuy nangatod an siya, ad tummùchu. Ad losan na takuy iningkaw ta sinagoga, immomoschoanchà siya. ");
INSERT INTO ksc_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ad ananan chicha, “Sanay nangngoranyu ta sanati ukud Apudyus, siyan tummuttuwana.” ");
INSERT INTO ksc_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ad nas-omcha losan an siya, ad nataagcha ta kinafarun na inukudna. Ad anancha, “Ngim anà met Jose na sanat!” ");
INSERT INTO ksc_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ad anan Jesus an chicha, “Kapilitani ifakayun saon na annayay ukud wi, ‘Chuktur, akasam yan na long-agnu.’ Tan pionyu koy pàwan saon ta annay ustuy ilì na isun na kaskaschaaw wi chingngoryuy iningwà ad Capernaum. ");
INSERT INTO ksc_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Tuttuwan ifakà an chiayu, wi na profeta, achi pu malispitu ta kailiyana. ");
INSERT INTO ksc_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Chongronyuna: Na timpun Elias wi profeta, achi pun ummuchan ad asnay Israel ta unog na turuy tawon ya kogwa, ad naamin naurat na taku ta annay luta. Siyan ad-adchuwan na kakkaasi wi nafaru ta sachi timpu. ");
INSERT INTO ksc_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ngim foon pù pin-oy Apudyus à Elias an chicha à mafadngancha, ngim finaunnà siya ta fadnganan osay nafaru wi foon à Judio wi ingkaw ad Serepta wi sakupon Sidon. ");
INSERT INTO ksc_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ad na timpun ako Eliseo wi profeta, achun Judio ad asnay Israel wi nafuratung; ngim maid pu naaan na sakitcha naraksig na sakit Naaman wi foon à Judio, wi iSiria.” ");
INSERT INTO ksc_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Na nangngoran chachi iningkaw ta inyalig Jesus, naaliling-otcha tan naawatanchay chichan ug-ugkuchona. ");
INSERT INTO ksc_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ad lummigwatcha ad linagkicha inyoy ta lasin na ili wi chopras wi iniliyancha. Na pangkopcha, odchakonchà siya ta chopras, ");
INSERT INTO ksc_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ngim nalliwot à Jesus ta takuy ad-adchuwan ad lummayaw. ");
INSERT INTO ksc_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sachi ad ummoy à Jesus ad Capernaum wi osay ili ta provinsiyay Galilea, ad nantudtudtuchu ta taku ta sinagoga wi makimkimungan na Judio ta Safachuy ngingillinan. ");
INSERT INTO ksc_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ad naschaaw na losani nangngor ta pinagtudtuchuna, tan maaawwatan wi annan karobfongana. ");
INSERT INTO ksc_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na osay Safachu, iningkaw ta sinagoga na osay larai wi nakafarfaray, ad impoawna anani, ");
INSERT INTO ksc_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Siay Jesus wi iNazaret, sinun oyyoom an chiani? Ummalià manachail an chiani? Akammù à sia, wi sian sachi naapudyusan wi impustan Apudyus wi umali!” ");
INSERT INTO ksc_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ngim impakinò Jesus na aran, wi anana, “Kuminòa! Taynam na sanati finarfaraynu!” Sachi ad impatug na aran na larai ta sangwanan na takuy naaarus achinaot taynan na larai wi maid nasukat. ");
INSERT INTO ksc_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Losan chachi nangiila, naschaawcha ad nan-ag-akitùtùcha, “Sinu kon annay tudtuchu wi mannakafalin, tan uray na aran, mafalinna paryawon!” ");
INSERT INTO ksc_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ad nanchinamag na mipangkop an Jesus ta ailiili ta sachi. ");
INSERT INTO ksc_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Lummawa pù Jesus ta sachi sinagogan na Judio, ummoy ta foroycha Simon. Nasakit na atukangan Simon, wi amod na panatingna, ad impafachangchan siya. ");
INSERT INTO ksc_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Siyan ummoy à Jesus ta nasuypana ad imfakanay maaan na panatingna, ad naanimfag. Ad fummangon ad sinakunganà chicha. ");
INSERT INTO ksc_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mummaschom pun, inyoy na taku losan na fufurunchay nasakit à nansabsafali an Jesus. Ad inturpun Jesus inagpachan chicha, ad ummimfagcha losan. ");
INSERT INTO ksc_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pinaryawna kon aran wi farfaray na achuy taku, ad na lummayawan chachi aran, inip-awcha anani, “Sian anà Apudyus!” Ngim impakinòna chicha tan inakammucha wi siyan Cristu wi impustan Apudyus wi umali. ");
INSERT INTO ksc_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Wiswisnit pun ta nafikat, lummigwat à Jesus wi ummoy naos-osa ta ikaw wi maid pu takù ingkaw. Ngim napannos pun, ummon achuy taku inanap à siya, ad inchasancha pun impachaschay tawichan à siya ta achi lumayaw. ");
INSERT INTO ksc_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ngim ananan chicha, “Taynà chiayu, tan masapur inyà ako ta uchumi ili itudtuchu na Mamfaruy Chamag mipangkop ta Manturayan Apudyus, tan siyan pangkop na nangifaunan Apudyus an saon ta annay luta.” ");
INSERT INTO ksc_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ad ummoy à siya nantudtuchu ta sinagogan na Judio ta provinsiya wi Galilea. ");
INSERT INTO ksc_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Na osay padcha, ummaagsad à Jesus ta tarantag na Fayfay wi Genesaret wi mantudtuchu ta ukud Apudyus, ad ummafuyut na takuy ad-adchuwan tan pionchay chongron na itudtuchuna. ");
INSERT INTO ksc_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ad innilan Jesus na chuway fangka ta ikid na fayfay wi maid ingkaw à manakufur, tan lummogsadcha ta sàsaanchan takufurcha. ");
INSERT INTO ksc_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Siyan ummoy à Jesus ta osa, wi uwan Simon, ad imfakana ta itùyudnà ait. Ad tummùchù Jesus wi nantudtuchu ta taku. ");
INSERT INTO ksc_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Narpas pun nantudtuchu, anana kon Simon, “Ipaoynun fangka ta arobngan na chanum ad manakufur-ayu ta awad aranyù ukachiw.” ");
INSERT INTO ksc_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ad anan Simon, “Oo, Apu, ngim linabrafini wi nanakufur ad maid pu osà inarani. Ngim nu siyan anam, manakufurà.” ");
INSERT INTO ksc_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Siyan nanakufurcha ad ad-adchuwan na ukachiw wi nàna ad tikangay makissay na takufur. ");
INSERT INTO ksc_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Siyan inayakanchan fufuruncha wi iningkaw ta osay fangka ta fadnganchà chicha. Fummachangcha pun, napnun chuway fangka wi tikangaycha milutong ta chagson na ukachiw. ");
INSERT INTO ksc_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sachi ad naawatan Simon Pedro na nàwa, ad nampalintumong ta sangwanan Jesus, ad anana, “Apu, taynanà tan managfasurà!” ");
INSERT INTO ksc_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Naschaawcha Simon wi mamfufurun ta aachun na ukachiw wi tinakufurancha. ");
INSERT INTO ksc_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Naschaaw akon fufurun Simon wi cha Jaime an Juan wi anà Zebedeo. Sachi ad anan Jesus an Simon, “Achia umogyat, tan manipud ta sana, sukatà na iwaarnu ta mamatiyom na takun saon.” ");
INSERT INTO ksc_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Intàchangcha pun na fangkacha ta tarantag, tinaynancha losan ad nitun-udchan Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Na namingsan, iningkaw à Jesus ta osay ili wi iningkawan akon osay larai wi nakollakong. Ad na nangil-anan Jesus, ummoy nampalintumong wi nampangpangngaasin siya, wi anana, “Apu, patiyò wi annan karobfongami mangaan ta annayay sakit-u, siyan nu kaasiyanà, paimfakonà.” ");
INSERT INTO ksc_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Sachi ad inyarawwad Jesus na imanan siya, ad anana, “Oo, kaasiyà sia. Maaan na sakitnu!” Ad naanimfag à siya. ");
INSERT INTO ksc_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ad finilin Jesus à siya wi anana, “Achim ug-ugkuchon ta sinuman na annay iningwà an sia. Ngim ing-a mampaila ta pachi ad manchatun-an Apudyus tan sachin illintog Moses à manuttuwaan na taku wi naaan na sakitnu.” ");
INSERT INTO ksc_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ngim nanchinamag na mipangkop an Jesus, siyan ummachuachun ummoy maamuamung wi manchongor an siya ya mampaaan ta sakitcha. ");
INSERT INTO ksc_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ngim nu simfofotang ummoy à Jesus naos-osa malluwaru. ");
INSERT INTO ksc_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Na osay padchay nantudtuchuwan Jesus ta osay foroy, iningkaw na natùtùchu wi uchumi mangitudtuchu ta Lintog ya naachar wi Fariseo. Narpucha ta ailiili ta provinsiya ad Galilea ya Judea ya narpu kon uchum ad Jerusalem. Ad na sachi koy timpu, iniingkaw na karobfongan Apudyus an Jesus wi mangaan ta sakit. ");
INSERT INTO ksc_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Sachi ad inchatong na uchumi lallarai na fillikanchay larai wi naayayong, ad ipachascha illò ta ipasangucha kuman Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ngim maid pu in-inonchay mangiyachanin siya tan nanapnun taku. Siyan ummoycha inafutan na otop na foroy ta uulluwan Jesus ad inchòorachan naayayong ta sangwanana. ");
INSERT INTO ksc_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ad inakammun pu Jesus wi napigsan pammatichan siya, anana ta naayayong, “Furun, napakawan na fasurnu.” ");
INSERT INTO ksc_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ngim chachi Fariseo ya mangitudtuchu ta Lintog, nan-asiakitùtùcha anani, “Sinun kinatatakun na sanat wi iyisunan long-agnan Apudyus! Tan maid makapakawan ta fasur nu achi afus à Apudyus!” ");
INSERT INTO ksc_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Inakammun Jesus na somsomòcha, siyan ananan chicha, “Tamako ta amaschin somsomòyu? ");
INSERT INTO ksc_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Sinun mallanlanuy à ifaka, ‘Napakawan na fasurnu,’ winnu ‘Lumigwat-a ta manadcharan-a’? ");
INSERT INTO ksc_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","À saon wi namfalin taku, panoknokà an chiayu wi annan karobfongà ad asnay luta wi mamakawan ta fasur.” Ad anana ta sachi naayayong, “Ifakà an sia, lumigwat-a, ad aram na ofognu ad lumayaw-a!” ");
INSERT INTO ksc_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ad narnigwat à siya ta sangwanancha losan, ad inaranan ofogna ad lummayaw wi manchaychayaw an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ad naschaawcha losan wi nangiila, ya ummogyatcha ko. Ad chinaychayawcha kò Apudyus wi anancha, “Maid pu miyisuwan na innilatau ta sanay padcha!” ");
INSERT INTO ksc_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Sachi ad, lummayaw à Jesus, ad innilanan osay manchachakup à fukis, wi nangngachan à Levi, wi ummaachuy ta pisinana. Ad anan Jesus an siya, “Mitun-ud-an saon.” ");
INSERT INTO ksc_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ad tinaynan Levi na asinchuwan, ad lummigwat wi nitun-ud an Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ad pinarnusan Levi à Jesus ta foroyna, ad iningkaw akon achuy fufurun Levi wi manchachakup à fukis ya uchum akoy taku. ");
INSERT INTO ksc_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ad na nangil-an na uchumi Fariseo, ya uchumi mangitudtuchu ta Lintog wi Fariseo ko, ta sachi, chinillawchan disipulus Jesus, wi anancha, “Taayuko makaan ya makainum ta manchachakup à fukis ya kakassanay takuy managfasur?” ");
INSERT INTO ksc_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ad sinongfatan Jesus chichà alig, anana, “Na takuy maid sakitna, foon pù masapurchan chuktur. Siya makasapur na nasakit. ");
INSERT INTO ksc_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Na ummaliyà ad asnay luta, foon à tudtuchuwà na mamfaruy taku ngim siya ummaliyà na tudtuchuwà na managfasur.” ");
INSERT INTO ksc_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Iningkaw akon uchumi taku wi ummoy an Jesus, wi anancha, “Na disipulus Juan, kanayuncha mallangan wi mangan ta malluwaruwancha, ya amaschi kon oyyoon na uchumi disipulus na Fariseo, ngim tamakon disipulusnu foon pù mallanganchay mangan?” ");
INSERT INTO ksc_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ad nan-alig à Jesus wi summongfat, anana, “Mallangan lawan takuy makakasar wi mangan nu awad an chichan larai wi mikasar? Mangancha met! ");
INSERT INTO ksc_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ngim chumatong na timpuy milayawan na nikasar an chicha, ad sachin mallangananchay mangan.” ");
INSERT INTO ksc_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ad asin nan-alig à Jesus an chicha, wi anana, “Maid pu takù mangissay ta lukak wi silup ad intàrupna ta pallos, tan chachailona kan lukak wi luput, ad foon pù miparay ta pallosi silup. ");
INSERT INTO ksc_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Ad maid pu ko mangifungufung à inafuyu ta chachaani uglit wi isù amutu, tan fumtak na sachi uglit ad mayam-an na uglit ya mifallu kon fayas. ");
INSERT INTO ksc_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ngim na inafuyu, masapur siya mifungufunganan àoyyay uglit wi amutu. ");
INSERT INTO ksc_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Na nangiluwam ta chachaani fayas, lawingonan àifungufungi fayas, tan anana nu, ‘Mampiyan chachaan!’” ");
INSERT INTO ksc_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Na namingsani Safachuy ngingillinan na Judio, nangoycha Jesus ya disipulusna ta pappayaw wi namur-an à wheat wi isù pakoy. Na nanadchadcharanancha, lummapid na disipulusnà utimancha. ");
INSERT INTO ksc_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ad anan na uchumi Fariseo, “Tamako ta amaschiyonyu wi mipalit ta Lintogtau nu Safachu?” ");
INSERT INTO ksc_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ad sinongfatan Jesus chicha anani, “Achiyu pu nafasan iningwacha David ya fufurunna ta nafitilancha ta awi? ");
INSERT INTO ksc_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tan linumnò ta sachi mangngachani foroy Apudyus ad inaranan tinapoy wi nichatun an Apudyus, wi ipalit na Lintog à anoncha tan afus kuman papachì mangan, ad innancha ta fufurunna.” ");
INSERT INTO ksc_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ad inanungusan Jesus na imfakana, wi anana, “À saoni namfalin taku, annan karobfongà wi mangifaka ta sinuy màwa ta Safachuy ngingillinan.” ");
INSERT INTO ksc_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Na osay Safachu, linumnò akò Jesus ta sinagogan na Judio wi nantudtuchu. Ad niyaspur wi iningkaw na osay larai wi naayayong na imanay chiwawan. ");
INSERT INTO ksc_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ad iningkaw akon uchumi mangitudtuchu ta Lintog na Judio ya uchumi Fariseo wi man-anaanap à mangicharumanchan Jesus, siyan sinipsiputancha nu awad paimfakona ta Safachuy ngingillinan. ");
INSERT INTO ksc_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ngim à Jesus, inaagkammunan somsomòcha, ad anana ta larai, “Waynu ta annay sangwanan.” Ad ummoy na larai. ");
INSERT INTO ksc_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ad anan Jesus an chicha losan, “Annan imusò an chiayu. Sinun iparufus na Lintogtau wi màwa ta Safachu? Mangwataù mamfaru winnu lawing? Takuwontaun taku winnu patoyontau?” ");
INSERT INTO ksc_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ad linangrangana chicha losan, ad anana ta larai, “Uyachom na imam.” Ad inuyadna, ad ummimfag. ");
INSERT INTO ksc_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ad chachi Fariseo ya mangitudtuchu ta Lintog, naaliling-otcha ad nan-uukudcha nu sinun oyyoonchan Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Napannos pun, summang-at à Jesus wi umoy malluwaru ta takudtud, ad linabrafinay malluwarun Apudyus. ");
INSERT INTO ksc_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wiswisnit pun, inarusnan chachi sumursurut an siya ad chinutukanan nasawaran à chuwa ad nginadnana chichà apostoles. ");
INSERT INTO ksc_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Na ngachancha: Simon wi nginadnanà Pedro ya sunudnay Andres; cha Jaime an Juan wi mansunud; Felipe an Bartolome, ");
INSERT INTO ksc_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ya Mateo, Tomas, Jaime wi anà Alfeo, Simon wi ananchay Mangipapakat, ");
INSERT INTO ksc_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas wi anà Jaime, ya Judas Iscariote wi siyan nangififik an Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nan-osog pun cha Jesus ya apostolesna ta takudtud, ummillongcha ta osay tanap, ad iningkaw akon achuy sumursurut an Jesus, ya ad-adchuwani takuy narpud Jerusalem ya provinsiyay Judea ya il-ili ad Tiro ya Sidon wi achani ta fayfay. ");
INSERT INTO ksc_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Na pangkopcha losan wi ummoy, chongronchan ukud Jesus ya paaanchan sakitcha. Ad iningkaw akon uchumi nakafarfaray, ad niparyaw na farfaraycha. ");
INSERT INTO ksc_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ad losan na taku, umafuafuyut ta agpachanchà siya tan annan karobfongana wi uray nu agpachancha kà siya, maaan na sakitcha. Siyan ummimfag losan na nasakit. ");
INSERT INTO ksc_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sachi ad nansakung à Jesus ta disipulusna ad ananay mantudtuchu, “Maragsak-ayu, chiayuy isù maid mafalinna ta sana, tan mitatappiayu ta Manturayan Apudyus! ");
INSERT INTO ksc_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Chiayuy isù nafitil ta sana, maragsak-ayu ko tan fafadngan Apudyus chiayu ta mapnok-ayu! Chiayuy mansasàuy ta sana, maragsak-ayu tan faliwan Apudyus na sauyyù lagsak! ");
INSERT INTO ksc_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Ad chiayuy mamatin saon, maragsak-ayu nu kuraon na takù chiayu ya achicha pu ifilang à chiayu ya insurtuwonchà chiayu, ya uray nu ifafainchà chiayu, kapu ta pammatiyun saoni namfalin taku. ");
INSERT INTO ksc_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nu amaschin màwan chiayu, manottoròayu, ya manachòayu ta lagsakyu tan chakor na kunkunayud langit. Na oyyoonchan chiayu, isun akon iningwan na aappucha ta anchachi profetas ta awi. ");
INSERT INTO ksc_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ngim kakkaasiayuy fafaknang tan annay lutan pagpag na mallaragsakanyu! ");
INSERT INTO ksc_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ya kakkaasiayu koy nanabsug ta sana, tan lìnaonyun amochi fitil à tapin na padcha! Ad kakkaasiayu koy asiaamang ta sana, tan manomchom-ayu ya man-ifil-ayù tapin na padcha! ");
INSERT INTO ksc_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Tuttuway kakkaasiayu nu chayawon losan na takù chiayu, tan chachi manaychayaw an chiayu ta sana, kanà chachi nanayaw ta chachi sinanprofetas ta awi.” ");
INSERT INTO ksc_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Inturuy Jesus wi nan-ukud, anana, “Na ifakà an chiayu, masapur ay-ayatonyun uray chachi kumuran chiayu. Ya oyyoonyun mamfaru ta chachi mallawing an chiayu. ");
INSERT INTO ksc_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Na takuy mangarawag an chiayu, chawatonyun achakun Apudyus an chicha. Ad iluwaruwanyu chachi mamarpalikat an chiayu. ");
INSERT INTO ksc_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nu awad manlipak ta apingyu, palipakyu kon fisà. Ad nu awad mangara ta silupyu, paarayu kon agwana. ");
INSERT INTO ksc_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Adchanyun man-ochaw an chiayu, ad nu awad mangara ta ùuwayu, achiyu paiyulin. ");
INSERT INTO ksc_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Na pionyuy oyyoon kuman takun chiayu, siya kuman oyyoonyun chicha. ");
INSERT INTO ksc_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nu afus yakan takuy mangay-ayat an chiayù ay-ayatonyu, namnamaonyuy makunkunaan-ayu? Tan uray chachi lawingi taku, ay-ayatoncha kon mangay-ayat an chicha! ");
INSERT INTO ksc_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ad nu afus yakan mangwà mamfarun chiayù mangwaanyu ko ta mamfaru, namnamaonyuy makunkunaan-ayu? Tan uray chachi lawingi taku, amaschi kon oyyooncha! ");
INSERT INTO ksc_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ad nu afus yakan chachi sikurachuwonyuy annan isubratchà pafuruchanyu, namnamaonyuy makunkunaan-ayu? Tan uray chachi lawingi taku, pafuruchanchan fufurunchay managfasur nu awad namnamaonchà isubratna! ");
INSERT INTO ksc_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ngim chiayu, masapur ay-ayatonyun mallawing an chiayu, ya oyyoonyun mamfaru an chicha. Pafuruchanyun mamfurud an chiayu uray nu achicha pu iyulin. Tan nu amaschiyonyu, chakor na kunkunayu, ad mifilang-ayù aannà Apudyus wi Angatuwan. Tan à Apudyus, oyyoonan mamfaru ta uray lawingi taku ya uray chachi achi pu manyaman an siya. ");
INSERT INTO ksc_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Masapur sumayaaw-ayu tan mansayaaw à Apudyus wi Amayu.” ");
INSERT INTO ksc_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ad inturuy Jesus wi nan-ukud, anana, “Achiyu pafasuron na uchum ta achin pu ko Apudyus pafasuron chiayu. Achiyu anani nakafasur ta uchum, ta achin Apudyus ifakan fasuryu. Pakawanonyun asintatakuyu ta pakawanon ako Apudyus chiayu. ");
INSERT INTO ksc_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mangatod-ayu ta uchum ad awad akon adchon Apudyus an chiayu, wi ad-achun adchonan chiayu nu inadchonyu, tan sumawar ingkanà achiayu pu makad-on. Siyan na oyyoonyu ta asintatakuyu, sachi kon oyyoon Apudyus an chiayu.” ");
INSERT INTO ksc_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ad nan-alig à Jesus an chicha wi anana, “Achi pu mafalini ipuyut na nakurap na isunay nakurap, tan kapilitani losancha mafituwan. ");
INSERT INTO ksc_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ya maid pu ko matudtuchuwan à nangatngatu nu mantudtuchu, ngim nu kangputona acharon na mitudtuchun siya, miyisu ta nantudtuchun siya.” ");
INSERT INTO ksc_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ad nan-alig akò Jesus wi anana, “Isù narawag na mangil-anyu ta aiti mukat ta atan na furunyu, ngim foon pù mailasinyun nipapaktar wi mukatyu! ");
INSERT INTO ksc_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mafalin aya wi anami, ‘Choo, sunud, aanò na aiti mukatnu,’ ad annan nipapaktar wi mukatyu? Mamàpail-on-ayu! Siyan masapur unaonyu aanon na nipapaktar wi mukat ta atayu, ta lumawag na mangil-anyu wi mangaan ta aiti mukat na furunyu.” ");
INSERT INTO ksc_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Asin nan-alig à Jesus, wi anana, “Na mamfaruy imong, achi pu mamungà lawing, ad ako maid pu lawing à imong à mamungà mamfaru. ");
INSERT INTO ksc_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tan maimatunan na kinafarun na ayu ta fungana. Tan kapilitani foon pù mafalini ifungan na tarurung na atunor! Ya foon pu kò mafalini ifungan na tabfog na akit! ");
INSERT INTO ksc_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Na miyalikana, na mamfaruy taku, mamfarun oy-oyyoona tan mamfarun som-osom-ona. Ngim na lawingi taku, lawing akon oy-oyyoona tan lawing na som-osom-ona. Tan tuttuwa wi na awad ta somsomò siya kon ifakan na tupò.” ");
INSERT INTO ksc_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Inturuy Jesus wi nan-ukud, “Tayuko anan wi saon na Apuyu ad achiyu pu oyyoon na ifakà an chiayu? ");
INSERT INTO ksc_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Sinumani sumurut an saon ya mangngor ta ifagfakà, ya oyyoona, amasnan miyalikana. ");
INSERT INTO ksc_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Miyalig ta nararami taku wi mangkaob à foroyna. Finòanan luta ingkanà inchasanan chapin-ay ad sachin nangisaachana. Uray nanurun na chawwang ya chinussuk na chanum na foroy, achi pu mikur-ub tan mampagchot na nisaachana. ");
INSERT INTO ksc_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ngim na takuy mangngor ta ifagfakà ya achina pu oyyoon, miyalig ta taku wi foon à nararam, wi insaadnan foroyna ta lagrakan. Chinussuk pun na chanum na sachi foroy, nikur-ub ad naamin niwànag!” ");
INSERT INTO ksc_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Limpas pun Jesus na intudtuchuna ta chachi taku, ummoy ad Capernaum. ");
INSERT INTO ksc_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Iningkaw ta sachin osay foon à Judio wi kapitan na susurchachu wi iRoma, ad amod na sakit na osay sanilunay ay-ayatona, wi akin-ottoyon. ");
INSERT INTO ksc_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ad chingngorna pun wi awad à Jesus, imfaunnan uchumi pangpangun na Judio ta umoycha ayakan à Jesus ta umoyna kuma paimfakon na saniluna. ");
INSERT INTO ksc_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Inchasancha pun à Jesus, inàarùcha anani, “Mamfarun sachi kapitan, ya karobfonganay mafadngan, ");
INSERT INTO ksc_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","tan ay-ayatonà chitauy Judio, ad siya kon nampàwa ta osay sinagoga wi makimkimungantau.” ");
INSERT INTO ksc_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ad nitun-ud à Jesus an chicha. Ad chanchanicha pun ta foroy na kapitan, sinib-atchan uchumi kakayyomna wi umoy mangiluslus an siya, ad imfakachan impaifakana, “Apu, achì pu kuma taktakon sia, tan mafainà wi mammangilin sia, ");
INSERT INTO ksc_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ya achì pu ko karobfongan wi makakakayam an sia. Umanay yakan ukudnù mampaimfag ta sanilù. ");
INSERT INTO ksc_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tan maawatà na mipangkop ta karobfongan, tan uray saoni kapitan, masapur patiyò na ifakan na apù. Ad na susurchachuy iturayà, patiyoncha kon ifakà, tan nu ifakà ta osa, ‘Ing-a!’ umoy, ad nu ifakà ta osa, ‘Umalia!’ umali ko. Ad nu ifakà ako ta sanilù, ‘Oyyoom na sanat!’ oyyoona met! Ad sinchumallù sia tan annan karobfongam.” ");
INSERT INTO ksc_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Naschaaw à Jesus ta nangngorana ta imfakacha. Siyan intuwilina ta takuy ad-adchuwan wi umun-unud an siya wi anana, “Tuttuway maid pu inchasà à isun na impappatin na anna ta losani chokatauy kanà Israel.” ");
INSERT INTO ksc_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nangulin pun chachi nafaun ta foroy na kapitan, inchasanchan sanilunay ummimfag. ");
INSERT INTO ksc_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Napapannos pun, ummoycha Jesus ya disipulusna ta osay ili wi Nain, ad nakaoy akon ad-adchuwani taku. ");
INSERT INTO ksc_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ummachanicha pun ta liwangan na sachi ili, inafotchan ad-adchuwani nakafurog ta osay nafaru wi umoycha ilofon na osay natoy. Fafarun natoy wi os-osàani anà na sachi nafaru. ");
INSERT INTO ksc_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Innilan pun Apu Jesus chi nafaru, inachakuwanà siya ad anana, “Achia man-ifil.” ");
INSERT INTO ksc_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Sachi ad ummoyna inagpachan na lungun, ad ummillong na namuud. Ad anana, “Fafaru! Fumangon-a!” ");
INSERT INTO ksc_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ad fummangon na natoy ad kumminga, ad impurang Jesus à siya an inana. ");
INSERT INTO ksc_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ad ummogyat losan na nangiila ad chinayawchà Apudyus, wi anancha, “Lummoswan chitaun osay nangatuy profeta! Impailan Apudyus na man-aachakuna ta takuna!” ");
INSERT INTO ksc_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ad nanchinamag na mipangkop an Jesus ta losani ili wi sakupon Judea ya il-ili wi nampalìwos ad Judea. ");
INSERT INTO ksc_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Imfakan pun na disipulus Juan an siya mipangkop an Jesus ya losani nàwa, ");
INSERT INTO ksc_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","imfaunnan chuwà umoy mangimus an Apu Jesus nu siyan sachi impustan Apudyus wi umali winnu awad urayonchà safali. ");
INSERT INTO ksc_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ad chummatongcha pun an Jesus, ananchan siya, “Imfaun chianin Juan wi Mamfufunyag ta imusonnin sia nu sian uullayonni wi impustan Apudyus wi umali, winnu awad urayonnì safali?” ");
INSERT INTO ksc_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Na sachi timpu, impaimfag Jesus na achuy takuy nasakit à nangkarakarasi wi sakit, ya imparyawna kon aran wi farfaray na uchum, ya inaanna kon kurap na achuy nakurap. ");
INSERT INTO ksc_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ad sinongfatanan chachi chuway nafaun, wi anana, “Mangulin-ayun Juan ifakan losani innilayu ya chingngoryu wi iningwà, wi na nakurap, makailacha, ya na napilay, makachadcharancha, ya na nakollakong, ummimfagcha, ya na naturong, makachongorcha, ya uray na natoy, ummulicha nataku. Ad chachi kakapus, miwarawag an chichan Mamfaruy Chamag. ");
INSERT INTO ksc_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ad ifakayu kon siya wi naragragsak chachi foon pù manchuwachuwa ta pammaticha wi saon na imfaun Apudyus!” ");
INSERT INTO ksc_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Lummayaw pun chachi fabfaun Juan, imfakan Jesus ta naarusi takun mipangkop an Juan. Anana, “Na ummayanyu nangil-an an Juan ta iningkawana ta sachi ikaw wi maid pu umili, sinun ummoyyu innila? Ananyu pun nin nu siyan isù kurun wi chupachupaliyon na fidfid. ");
INSERT INTO ksc_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ad nu foon, sinun ummoyyu innila nù? Taku wi nansilup à afaruwan? Ngim foon à nansilup à amaschi tan foroy na Alin ingkawan na nakasilup à amaschi! ");
INSERT INTO ksc_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Siyan sinun ummoyyu innila nù? Osay profetan Apudyus? Na katuttuwaana, siya ummoyyu innilan profetan Apudyus. Ngim ifakà an chiayu wi Juan na kangrunaan wi profeta, ");
INSERT INTO ksc_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","tan siyan sachi takuy mismuy imfakan na niyug-is wi ukud Apudyus wi anana, ‘Awad na osay taku wi ifaun-u unaon nu sia ta umoyna mansakanaon na taku ta chongronchà sia.’ ");
INSERT INTO ksc_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ad tuttuwan annayay ifakà an chiayu wi maid pu takù niyanà ad asnay lutà nangatngatu nu Juan. Ngim na afafaan ta Manturayan Apudyus, mifilang à nangatngatu nu Juan kapu ta pammatinan saon.” ");
INSERT INTO ksc_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Naragsak losan na takuy nangngor an siya, wi uray akon chachi manchachakup à fukis. Chichan namtog ta imfakan Apudyus ad nampafunyagchan Juan. ");
INSERT INTO ksc_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ngim chachi Fariseo ya mangitudtuchu ta Lintog na Judio, linawingchan pion Apudyus an chicha, siyan achicha pu mampafunyag an Juan. ");
INSERT INTO ksc_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Inturuy Jesus wi nan-ukud, anana, “Sinun mangiyisuwà ta taku ta annay sillumunap? ");
INSERT INTO ksc_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Iyalig-u chichà isù an-ananà wi man-in-innangu wi nampoapoaw ta akin-annàcha, ‘Tinupayyanin kangsa ngim achiayu pun managni! Siyan sinukatannì chomchom ngim achiayu pu makachomchom!’ ");
INSERT INTO ksc_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tan na ummaliyan Juan wi Mamfufunyag, nallangarangan wi mangan ya foon pù umminum à fayas, ad inam-amsiwyù siya wi magwonyu nakafarfaray à siya! ");
INSERT INTO ksc_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ngim à saoni namfalin taku, ummaliyà pu ko wi foon pù mallanganà wi mangan, ya makaikainumà à fayas, inamsiwà ako wi magwonà lawotan ya sallimongan! Ya magwonà ako fufurun na manchachakup à fukis ya uchumi managfasur! ");
INSERT INTO ksc_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ngim uray nu amaschi, losan na takuy mamatin Apudyus, chichan mangipaila ta kinaustun na kinaraing Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Na osay padcha, inayakan na osay Fariseo à Jesus ta mangan ta foroycha. Ad ummoy à Jesus nakaan. ");
INSERT INTO ksc_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Iningkaw ako ta sachi ilin osay fufai wi puta. Ad chingngorna pun wi awad à Jesus wi mangan ta foroy na sachi Fariseo, ummoy ako wi nangawit à fangfanguy lana wi na ikawna, nàwa ta fatu wi alabaster. ");
INSERT INTO ksc_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Linumnò na sachi fufai ad ummagsad ta odchokan Jesus, ad nan-ifil wi tummodtod na luwana ta chapan Jesus. Ad pinunasana ta fuùna, ad inapupuynan chapanna à mangipail-ana ta lispituna, achinaot isiit na lanog ta chapanna. ");
INSERT INTO ksc_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ngim na nangil-an na sachi Fariseo ta sachi, anana ta somsomòna, “Nu kattoi profetà Jesus, inakammuna kuma na kinatatakun na sanati fufai wi mangagpad an siya, ad ingkimauna.” ");
INSERT INTO ksc_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sachi ad kummingà Jesus wi anana ta sachi Fariseo, “Simon, awad na ifakà an sia.” “Oo, sinun ifakam Apu?” anan chi Fariseo. ");
INSERT INTO ksc_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ad nan-alig à Jesus wi anana, “Iningkaw na osay larai wi nan-utangan na chuway larai, wi limampurun inutang na osa, ya limangkasut na inutang chi osa. ");
INSERT INTO ksc_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ad kapu ta achicha pu makafayad, pinasinsiyana chicha. Siyan annan imusò an sia: Na chachi chuway nan-utang, sinun chakchakor na ayatna ta sachi nampautang nù?” ");
INSERT INTO ksc_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ad anan Simon, “Chi chakchakor nin akon nipasinsiyan siya.” Ad anan Jesus, “Oo, siya!” ");
INSERT INTO ksc_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ad tinuwilina chi fufai ad anana kon Simon, “Sachin miyalikan na annayay fufai! Tan na linumnoà ta annay foroyyu, maid impaaram à chanum à mamfarfar-u wi siyan ukalitau. Ngim à siya, imfarfarnan luwana ta chapan-u ad pinunasana ta fuùna. ");
INSERT INTO ksc_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ad à sia, foon pu kò finàwarnù saon ta linumnoà. Ngim à siya, nanipud ta linumnoana achina pu iwarang wi nangapupuy ta chapan-u. ");
INSERT INTO ksc_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ad akò sia, foon pù linankam na urù wi siya kon ukalitau, ngim à siya, inaminna linankan na chapan-ù nanginay lana wi fangfangu. ");
INSERT INTO ksc_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Siyan ifakà an sia, na chakor wi ayat na annayay fufai an saon, sachin manuttuwaan wi napakawan na achuy fasurna. Ngim na takuy ait yakan napakawan wi fasurna, ait akon ipailanay ayatnan saon.” ");
INSERT INTO ksc_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Sachi ad anan Jesus ta sachi fufai, “Napakawan tuwan fasurnu.” ");
INSERT INTO ksc_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ngim chachi uchumi makaan, anancha ta somsomòcha, “Sinu kon sanati taku, wi mamakawan ta fasur?” ");
INSERT INTO ksc_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ad anan ako Jesus ta sachi fufai, “Kapu ta namatiyam an saon, nasaraknifan-a, siyan fumarun somsomònu.” ");
INSERT INTO ksc_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Napannos pun, asin ummoy à Jesus nangkagkagkaay ta ailiili wi mantudtuchu ta Mamfaruy Chamag mipangkop ta Manturayan Apudyus. Ad nifurun akon siyan disipulusnay nasawaran à chuwa ");
INSERT INTO ksc_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ad nitun-ud akon uchumi fubfufai wi chichan nangiparyawan Jesus ta aran ya impaimfagna ko ta sakitcha. À Maria Magdalenan osa wi siyan nangiparyawan Jesus ta pituy aran. ");
INSERT INTO ksc_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ya iningkaw akò Juana, wi na asawanay Cusa, mamfafantay ta ùuwan Ali Herod. Ya iningkaw akò Susana ya achu koy fubfufai wi losancha fadngan cha Jesus ta sinuy mafalinchay ifachang. ");
INSERT INTO ksc_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ad ummoy an Jesus na ad-adchuwani taku wi narpu ta ailiili. Sachi ad wi nan-ar-aruscha, nan-alig à Jesus wi anana, ");
INSERT INTO ksc_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Iningkaw na osay taku wi ummoy nawwakawag à fuor. Ad na nawwakawakana, nanchissun uchum ta charan ad chinamchampit na taku ya innan na sissiwit. ");
INSERT INTO ksc_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ad na uchumi fuor, nanchissu ta fattufattu wi ait na luta, ad uray nu summimitcha, naamincha naryaw tan mag-anan. ");
INSERT INTO ksc_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ad na uchumi fuor, nanchissu ta tartallurung ad tummufucha. Ngim inilung na tarurung. ");
INSERT INTO ksc_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ngim na uchumi fuor, nanchissu ta malloma ad tummufucha, ad namungà ad-adchuwan.” Ad inanungusan Jesus na inukudna, wi anana, “Naingaan-ayu, siyan somsom-onyu kuman mining na alig-u!” ");
INSERT INTO ksc_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Sachi ad inimus na disipulus Jesus nu sinun mining na aligna. ");
INSERT INTO ksc_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ad anana, “Losani chaan pù maakammuwan wi mipangkop ta Manturayan Apudyus, afus-ayù mipaakammuwana wi foon pù mipaakammu ta uchum, tan alig yakan mifakan chicha. Tan uray itotollongcha, achicha pu imatunan. Ad uray chochongroncha, achicha pu maawatan.” ");
INSERT INTO ksc_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Inturuy Jesus wi nan-ukud, anana, “Annayan mining na alig-u. Na miyalikan na fuor, ukud Apudyus. ");
INSERT INTO ksc_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ad na isun na nanchissuwan na fuor ta charan, chichan takuy nangngor ta ukud Apudyus, ngim ummoy Satan inallilaw na chingngorcha ta achicha pu patiyon à masaraknifancha. ");
INSERT INTO ksc_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Na isun na nanchissuwan na fuor ta fattufattu, chichan takuy naragsak wi nangamfuruy ta ukud Apudyus ta nangngorancha. Ngim foon pù lummamut ta somsomòcha, tan sin-aitan yakan namatiyancha. Tan inumchas pun na napalikatancha, inwarangcha. ");
INSERT INTO ksc_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Na isun na nanchissuwan na fuor ta tartallurung, chichan takuy nangngor ta ukud Apudyus ngim isù nailung na chingngorcha kapu ta chanagcha ta masapurcha, ya kinafaknang, ya pionchay lumam-ay na fiyagcha. ");
INSERT INTO ksc_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Ad na isun na nanchissuwan na fuor ta malloma, chichan takuy nangngor ta ukud Apudyus ad impapatichay manungpar, uray malikatancha wi mangwa ta pion Apudyus wi pàwan chicha. Siyan isù ad-adchuwan na ifungacha.” ");
INSERT INTO ksc_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Asin nan-alig à Jesus wi anana, “Maid pu takù paskichanan silaw ad tinab-unana winnu igkana ta chukun na katli. Tan ipatayna ta ustuy papattayana ta mamàila ta takuy lumnò.” ");
INSERT INTO ksc_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ad anan ako Jesus, “Somsom-onyuna, na losani nitataru ta sana, mallotaw à tapin na padcha. Ya uray akon losani foon pù maakammuwan ta sana, chumatong akon mipaakammuwana. ");
INSERT INTO ksc_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Siyan tantanchaakanyu wi manchongor ta ifakà, tan na takuy mangwa ta chongrona, machog-achog-an na maawatancha. Ngim na takuy foon pù oyyoonan chingngorna, maaan na uray aiti naawatana.” ");
INSERT INTO ksc_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Sachi ad chummatong na inan Jesus ya susunudna, ngim achicha pu makaachani an Jesus kapu ta ad-adchuwani naam-ammung. ");
INSERT INTO ksc_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Siyan imfakan na osay taku an Jesus, “Anchanat anun inam ya susunudnud paway, ad paayagchà sia.” ");
INSERT INTO ksc_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Sachi ad anan Jesus an chicha losan, “Sinumani manchongor ta ukud Apudyus ya patkona, chicha kon ifilang-ù inà ya susunud-u.” ");
INSERT INTO ksc_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Na osay padcha, namfangkacha Jesus ya disipulusna. Ad anan Jesus an chicha, “Chormangontaun fayfay.” Ad lummigwatcha. ");
INSERT INTO ksc_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ad na nanchormangancha, nasuyop à Jesus. Nangkinawacha pun ta fagwang, nammaag fummalì napigsa, ad nantuptuppiyà na challuyun ta fangka ingkanà nganngani milutong. ");
INSERT INTO ksc_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Siyan finangon na disipulus Jesus à siya, wi anancha, “Apu, Apu, annay milutongtau!” Ad fummangon à Jesus ad pinakinònan fali ya challuyun, ad asin tummuyong na fayfay. ");
INSERT INTO ksc_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ad anan Jesus ta disipulusna, “Tayukò saon achi piyaron?” Ngim naschaawcha ya ummogyatcha, ad nan-ag-akitùtùcha anani, “Sinun annay taku, wi uray na fali ya challuyun, patkonchà siya!” ");
INSERT INTO ksc_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sachi ad inturuycha Jesus ya disipulusnay namfangka wi umoy ta sachi sakupon Gerasa wi nichomang ad Galilea. ");
INSERT INTO ksc_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ad lummogsadcha pun, nisib-at an Jesus na osay larai wi iGerasa wi nakafarfaray. Nafayag na namfofodchangana ya achi pu umapun ta foroyna tan lorobnan na iingkawana. ");
INSERT INTO ksc_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Tan na sachi larai, chumanatong na farfarayna, ad uray nu faruchoncha wi kachilaanchan imana ya ikina, torangona ad impaawid na aran à siya ta ikaw wi maid pu foroy. Ngim na nangil-anan Jesus, nampauy ad nallùfub ta sangwanana ta ogyatna, ad impoawna anani, “Siay Jesus wi Anà Apudyus wi Angatuwan, sinun oyyoom an saon? Mangaasia ta achiyà palikatan!” Amaschin imfakana tan imfakan Jesus ta aran ta lumayaw ta sachi larai. ");
INSERT INTO ksc_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Sachi ad inimus Jesus an siya, “Sinun ngachannu?” Ad summongfat na nakafarfaray wi anana, “Kaachuwan na ngachan-u.” Sachin imfakana tan ad-adchuwan na farfarayna. ");
INSERT INTO ksc_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ad nampangpangngaasicha ta achicha kuma mipaoy ta fitu wi maid pagpag na acharomna à machusaancha. ");
INSERT INTO ksc_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na sachi, niyaspur wi iningkaw na ad-adchuwani forò wi asisusubsub ta takudtud. Siyan nampangpangngaasin chachi aran an Jesus ta iparufusna kuman umatunancha ta chachi forò, ad imparufus Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Sachi ad tinaynanchan sachi larai ad ummoycha nallonog ta forò, ad asitotodchàcha wi ummoy lumayug ta chopras ad naanudcha losan ta fayfay. ");
INSERT INTO ksc_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Na takuy namanfantay ta forò, na nangil-ancha ta napasamak, ummawidcha losan ad impachamagcha ta ili ya foforoy wi nampalìwos. ");
INSERT INTO ksc_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Sachi ad lummigwat na taku wi umoy mangila ta nàwaana, ad na chummatnganchan Jesus, inchasanchan sachi larai wi tinaynan na aran, wi nakasilup ya fummarun somsomòna, wi tummutùchu ta sangwanan Jesus. Ad ummogyatcha losan. ");
INSERT INTO ksc_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Sachi ad asin chachi ustuy nangiila inisturyan losani nàwa ta nangiparyawan Jesus ta aran. ");
INSERT INTO ksc_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Siyan losan chachi iGerasa, nampangpangngaasichan Jesus ta lumayaw kuma ta ilicha tan amod na ogyatcha. Siyan namfangkacha Jesus wi lumayaw. ");
INSERT INTO ksc_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ad na larai wi lummayawan na farfarayna, nan-àarù ta mifurun ako, ngim inisì Jesus wi anana, ");
INSERT INTO ksc_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Mangulin-a ta ilim ta isturyaom na losani iningwan Apudyus wi namachang an sia.” Sachi ad lummayaw chi larai ad inisturyana ta losani linausanan iningwan Jesus an siya. ");
INSERT INTO ksc_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nangulin pù Jesus ta chomang na fayfay, naragsak na achuy taku wi nanguullay an siya. ");
INSERT INTO ksc_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ad na sachi, chummatong akon osay pangpangun na sinagogan na Judio, wi à Jairo na ngachanna. Ad nampalintumong an Jesus wi nampangpangngaasi ta umoy ad foroycha, ");
INSERT INTO ksc_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","tan akin-ottoyon na os-osàani anànay fafarasang, wi nasawaran à chuwan tawonna. Siyan lummigwat à Jesus, ad nakaoy akon achuy taku wi mansususulig an siya. ");
INSERT INTO ksc_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na osan chicha, osay fufai wi nasakit à chumarachara ta unog na nasawaran à chuway tawon. Ad naamin nakastun ùuwana ta chuchuktur, ngim maid pu nakaaan ta sakitna. ");
INSERT INTO ksc_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ad ummoy ta odchokan Jesus ad inagpachanan pagpag na silupna, ad chakusi inwarangnay chumara. ");
INSERT INTO ksc_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ad inimus Jesus, “Sinun nangagpad an saon?” Ngim maid nangifaka. Ad anan Pedro, “Apu, siya nangagpad an sian anchanay mansususulig wi achuy taku!” ");
INSERT INTO ksc_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ngim anan Jesus, “Awad na kakaran na osay nangagpad an saon, tan linìnà wi nausar na karobfongà.” ");
INSERT INTO ksc_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Sachi ad naawatan chi fufai wi naakammuwan na iningwana, siyan ummoy nampalintumong an Jesus, wi namaypayogpog ta ogyatna, ad imfakana ta sangwanan na losani taku na pangkopnay nangagpad an siya, wi sachin naaanan na sakitna. ");
INSERT INTO ksc_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ad anan Jesus an siya, “Sunud, mipakapu ta pammatim an saon, ummimfag-a, siyan fumarun somsomònu.” ");
INSERT INTO ksc_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Na nangug-ugkuchan Jesus ta sachi, chummatong na osay fabfaun wi narpu ta foroycha Jairo, ad ananan Jairo, “Uray achitau taktakon na Misturu, tan nar-us natoy na anànu.” ");
INSERT INTO ksc_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ngim na nangngoran Jesus ta sachi, ananan Jairo, “Achia machanakan. Piyaronà ad matakun anànu.” ");
INSERT INTO ksc_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Chummatongcha pun ta foroy, impalit Jesus na lumnoan na taku naraksig cha Pedro an Jaime ya Juan, ya ina ya aman na natoy. ");
INSERT INTO ksc_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Losan na takuy namakungun, asiiifilcha ya manomchomcha. Ngim anan Jesus an chicha, “Achiayu man-ifil, tan foon pù natoy na annay fafarasang. Nasusuyop yakay!” ");
INSERT INTO ksc_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ngim inam-amangchà siya tan inaagkammuchay natoy. ");
INSERT INTO ksc_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ngim inognan Jesus na iman na natoy ad anana, “Anà, fumangon-a!” ");
INSERT INTO ksc_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ad ummulin angosna ad nafanangon, ad imfakan Jesus ta paanancha. ");
INSERT INTO ksc_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ad naschaaw na chakorna, ngim finilin Jesus chicha ta achicha ifagfakan nàwa. ");
INSERT INTO ksc_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Na osay padcha, inarus Jesus na nasawaran à chuway disipulusna ad innadchonan chichan karobfongancha wi mangiparyaw ta aran wi farfaray na taku ya mangaan ta saksakit na taku. ");
INSERT INTO ksc_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ad imfaunna chicha ta umoycha itudtuchun mipangkop ta Manturayan Apudyus ya paimfakonchan nasakit. ");
INSERT INTO ksc_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ananan chicha, “Achiayu mangawit à uray sinuman ta mamfiyasiyanyu: achiayu manur-ud, achiayu mampasiing, ya achiayu mamfarun à pilak ya uray anonyu ya luput à sukatyu. ");
INSERT INTO ksc_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ad nu sinun mammangilin chiayu, ingkaw-ayu ta foroyna ingkanà lumayawanyu ta sachi ili. ");
INSERT INTO ksc_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ad nu awad ilì maid pu mammangilin chiayu, tòakonyun tapuk ta ikiyu ta lumayawanyu ta sachi ili à mangakammuwancha wi ikadcha ta machusaancha.” ");
INSERT INTO ksc_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ad lummigwatcha ad ummoycha kinagkagkaay na ailiili wi nangitudtuchu ta Mamfaruy Chamag ya nan-aan ta sakit na taku. ");
INSERT INTO ksc_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Na sachi, à Herod wi Ali ad Galilea, chingngorna pun na mipangkop ta losani iningwan Jesus, nakulikur na somsomòna tan anan na uchumi taku wi ummuli nu natakù Juan wi Mamfufunyag. ");
INSERT INTO ksc_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ad na uchum, anancha koy nangulin na sachi profeta wi Elias. Ad anan akon uchum wi ummuli natakun osay taku wi profeta ta awi. ");
INSERT INTO ksc_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ngim anan Herod, “Impasiwat-u met à Juan, siyan sinun sanati ug-ugkuchoncha nù?” Ad pipionay mangilan Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nangulin pun chachi apostoles wi imfaun Jesus, imfakacha losan na iningwacha. Sachi ad inayakan Jesus chicha ta umoycha kuma tumalin ta osay ili wi Betsaida. Ad lummigwatcha. ");
INSERT INTO ksc_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ngim chinamag pun na takun ummayana, ummun-unudcha ad marmaryad à Jesus an chicha. Siyan tinudtuchuwana chichà mipangkop ta Manturayan Apudyus, ya impaimfagna kon losani nasakit. ");
INSERT INTO ksc_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Masiut pun na init, ummoy na disipulus Jesus an siya ad anancha, “Fuarom na taku ta umoycha man-anap à anoncha ya umiyanancha ta anchachi il-ili ya foforoy tan maid pu maan ad asna.” ");
INSERT INTO ksc_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ngim anan Jesus an chicha, “Chiayun mamaan an chicha.” Ad sinongfatancha anani, “Ngim afus na limay tinapoy ya chuway filis à awad. Sinun inginanì anon na anchanayay takuy ad-adchuwan?” ");
INSERT INTO ksc_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tan na filang na lallarai wi iningkaw, nasuruk à limay lifu wi foon à nifilang na fubfufai ya an-ananà. Sachi ad anan Jesus ta disipulusna, “Ar-arubfunonyu chichà sillimmampuru.” ");
INSERT INTO ksc_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tummùchucha pu losan, ");
INSERT INTO ksc_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","inaran Jesus na limay tinapoy ya chuway filis, ad nantangad ad langit wi manyaman an Apudyus. Sachi ad pinotpotlàna ad impaiwarasna impafillay ta disipulusna ta taku. ");
INSERT INTO ksc_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ad losancha nabsug wi nangan. Ad napnun nasawaran à chuway langngay ta nasawar wi nafun-ani chinakup na disipulusna. ");
INSERT INTO ksc_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Na osay padchay nalluwaruwan Jesus ta naab-afusana, ummoy na disipulusnan siya, ad inimusnan chicha, “Sinun mammammoan na takun saon?” ");
INSERT INTO ksc_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ad anancha, “Anan na uchum wi sia nù Juan wi Mamfufunyag wi ummuli nataku. Ngim anan akon uchum wi sia nù Elias wi nangulin. Ad na uchum, ananchay sia nun osay profeta wi ummuli nataku.” ");
INSERT INTO ksc_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Ad chiayu ngay?” anan Jesus. “Sinun mammammoanyu?” Ad summongfat à Pedro, wi anana, “Sian Cristu wi impustan Apudyus wi umali manturay.” ");
INSERT INTO ksc_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Sachi ad finilin Jesus chicha ta achicha ifagfaka ta uchum. ");
INSERT INTO ksc_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ad imfakana kon chicha, “À saoni namfalin taku, masapur mapalikatanà ya kuraonà ta chachi mamangpanguwon na Judio ya pangpangun na papachi ya chachi mangitudtuchu ta Lintog. Ad mapatoyà, ngim na miyatluy padcha, umuliyà mataku.” ");
INSERT INTO ksc_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Sachi ad imfakan Jesus an chicha losan, “Sinumani maryad wi sumurut an saon, masapur foon pù makaka ta fiyagnad asnay luta, tan masapur oyyoonan piò, uray sachin iyatoyna. ");
INSERT INTO ksc_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tan sinumani makaka ta fiyagnad asnay luta, matoy ako kay. Ngim nu sinun foon à makaka ta fiyagna kapu ta pammatinan saon, uray matoy maatod an siyan fiyag wi mannaynayun. ");
INSERT INTO ksc_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tan sinun silfin na mangin-uwaan na osay taku ta losani awad ta luta nu ifallun Apudyus à siya? ");
INSERT INTO ksc_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ad sinumani taku wi mafain wi manàchor an saon ya intudtuchù, mafainà ako wi manàchor an siya nu mangulinà. Tan saoni namfalin taku, nu mangulinà, sumilingà ta kinachayaw-u ya kinachayaw Ama ya chachi aanghelesna. ");
INSERT INTO ksc_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tuttuwan ifakà an chiayu, wi awad na uchum an chiayu ta sana wi asififiyag wi achi pu matoy ingkanà ilanchan Manturayan Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Lummaus pun na sinchumingkuwan nanipud ta nangukuchan Jesus ta sachi, inayakana cha Pedro an Juan ya Jaime ad ummoycha nanakacha ta filig. Ad nalluwarù Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ad na nalluwaruwan Jesus, nafaliwan na itchuran na fosarna, ad na silupna, sumilisiling wi putilaan. ");
INSERT INTO ksc_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Sachi ad innilacha ko cha Moses an Elias wi makaug-ugkud an Jesus, ");
INSERT INTO ksc_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","wi sumiling akon luputcha. Na inug-ugkudcha, mipangkop ta matayan Jesus ad Jerusalem à manungparana ta losani pion Apudyus. ");
INSERT INTO ksc_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ngim nasuyopcha Pedro wi mamfufurun, tan amod na suyopcha. Ngim napapannos ad fummangoncha ad innilachan sumilingan Jesus ya chachi chuway larai wi nakaagsad an siya. ");
INSERT INTO ksc_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ad na lummayawan chi chuwa, anan Pedro an Jesus, “Apu, mamfaru tan annaani! Mangwaanì turù sikay à mamfubfuwaanyu ancha Moses an Elias.” Amaschin imfakana tan maid akammunà ustù ifakana. ");
INSERT INTO ksc_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Na sachi man-ukuukuchan Pedro, nallifuu ad ninapnapanà chicha, ad ummogyatcha. ");
INSERT INTO ksc_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ad chingngorchan kinga wi narpu ta sachi lifuu, wi anana, “Sanan Anàu wi chinuchuttukà à manturay. Chongronyù siya!” ");
INSERT INTO ksc_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nakangput pun na sachi kumminga, ummafus à Jesus. Ad maid nangifagfag-an na disipulusna ta mipangkop ta innilacha. ");
INSERT INTO ksc_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nafikat pun nan-osogcha Jesus ta turuy furunna, ad inafot na ad-adchuwani takù chicha, ");
INSERT INTO ksc_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ad nampauy na osay niyaslang an chicha wi anana, “Apu, mangaasia ta ilam na anàuy fafaru, wi os-osàan à anàni! ");
INSERT INTO ksc_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Tan nu chumatong na farfarayna, mampauyonà siya ad manguntarag à siya, ad mantatarfutab na tupòna. Parpalikatan na aran na long-agna ingkanà lumayawana. ");
INSERT INTO ksc_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ad nampangpangngaasiyà ta disipulusnu ta iparyawcha kuma ngim achicha pu makàwa.” ");
INSERT INTO ksc_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ad summongfat à Jesus anani, “Chiayuy taku ta sana, ummakon pammatiyu? Naina kon iniingkawà ya anus-un chiayu!” Ad anan Jesus ta sachi larai, “Iyalim na fafarum.” ");
INSERT INTO ksc_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ngim na mangiyayana, impatug na aran à siya ta luta, ad nanguntarakonà siya. Siyan inomoran Jesus na aran ad imparyawna, ad ummimfag na fafaru, ad impurang Jesus à siya an amana. ");
INSERT INTO ksc_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ad losan na taku ta sachi, naschaawchay nangila ta karobfongan Apudyus wi maid miyisuwana. Na naschaawan chachi taku kapu ta innilacha, anan Jesus ta disipulusna, ");
INSERT INTO ksc_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Sosom-onyun annayay ifakà an chiayu. Saoni namfalin taku, mipurangà ta safali wi taku.” ");
INSERT INTO ksc_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ngim achicha pu naawatan tan foon à naapuutancha ad ummogyatchay mangimus an siya. ");
INSERT INTO ksc_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Na osay padcha, nansosongfat chachi disipulus nu sinun angatuwan an chicha. ");
INSERT INTO ksc_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ngim inakammun Jesus na somsomòcha, siyan inayakanan osay anà ta michapat an siya, ");
INSERT INTO ksc_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ad ananan chicha, “Sinumani patkanan nafafay taku wi isun na annay anà mipakapu ta pammatinan saon, patkana kò saon. Ad sinumani mangipatog an saon, patkana kon sachi nangifaun an saon. Tan na kafafaan an chiayu, siya kon angatuwan.” ");
INSERT INTO ksc_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Sachi ad anan Juan an Jesus, “Apu, innilanin osay taku wi nangiparyaw ta aran ad imfoswaynan ngachannu, ad impalitni tan foon pù furuntau.” ");
INSERT INTO ksc_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ngim anan Jesus an chicha losan, “Achiyu ipalit na amaschi, tan sinumani foon pù kumuran chitau, siyan furuntau.” ");
INSERT INTO ksc_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nganngani pun na mangulinan Jesus ad langit, simsimmònay umoy ad Jerusalem. ");
INSERT INTO ksc_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ad imfaunna impaunan uchumi fabfaunna ta osay ili ta provinsiyay Samaria ta umoycha mansakanaon na taku ta chumatngan Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ngim na taku ta sachi ili, achicha pu parnoon à Jesus tan narawag wi Jerusalem na umayana wi ilin na Judio. ");
INSERT INTO ksc_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Chingngor pun cha Jaime an Juan na nàwa, ananchan Jesus, “Apu, ifakataun Apudyus ta odchakana chichà apuy ta maskobcha?” ");
INSERT INTO ksc_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ngim nansakung à Jesus ad inomoranà chicha. ");
INSERT INTO ksc_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ad ummoychà safalì ili. ");
INSERT INTO ksc_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Na nanadchadcharanancha, iningkaw na osay nangwanan an Jesus, “Mifurunà an sia ta uray sinumani umayam.” ");
INSERT INTO ksc_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ad sinongfatan Jesus à siya anani, “Na mutit, annan afutchay ingkawancha, ad na sissiwit, anna kon sùfutchay ingkawancha. Ngim à saoni namfalin taku, maid pu foroy-ù sumpuwà. Ad mitun-ud-a ko kay?” ");
INSERT INTO ksc_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ad anan ako Jesus ta osa, “Sumurut-an saon.” Ngim anan na sachi taku, “Apu, inyà yan ilofon à Ama.” ");
INSERT INTO ksc_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ngim anan Jesus an siya, “Ikad na chachi maid pu pammaticha, wi niyalig à natoy, wi mangilofon ta isuchay natoy. Ngim sia, ing-a kay ta ipagngornun mipangkop ta Manturayan Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ad anan akon osa, “Apu, surutò sia, ngim inyà yan mampakacha ta faryan-u.” ");
INSERT INTO ksc_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ad anan ako Jesus an siya, “Sinumani malluki wi sumurut an saon ya manchuwachuwan somsomòna, maid silfina ta Manturayan Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Sachi ad piniliyan Jesus na pitumpuru ya chuwa wi larai ad sininchuwwana impauna ta sinumani ili wi somsom-onay umayan, ");
INSERT INTO ksc_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ad ananay nan-alig an chicha, “Achun maani ngim ait na man-ani. Siyan chawatonyun Apudyus wi ngin-uwa ta annay ani ta umifaun à achù man-ani.” ");
INSERT INTO ksc_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ad impaligwat Jesus chicha wi anana, “Ing-ayu! Ifaun-u chiayu ta chachi lawingi taku, wi isuayù pannilu wi umoy miyamung ta kaog-ogyati atap wi asu. ");
INSERT INTO ksc_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Achiayu mamfarun à pilak ya uray na sukat na sapatusyu, ya achiayu mampasiing ya achiayu makaukud ta taku ta charan. ");
INSERT INTO ksc_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nu lumnòayu ta osay foroy, unaonyu ifaka ta chachi ingkaw wi finchisyunan Apudyus chicha. ");
INSERT INTO ksc_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ad nu pionchay mammangilin chiayu, tuttuway mafinchisyunancha. Ngim nu lawingoncha, ichauliyun imfakayu. ");
INSERT INTO ksc_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ad nu minangili chiayu, ingkaw-ayu ta sachi foroy. Achiayu man-attuattun ya achiayu mangamilì anonyu, tan sachin isù labfuyu. Tan na takuy man-iwaar, karobfonganay maadchan à masapurna. ");
INSERT INTO ksc_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ad nu sinun ili wi chaumanyu ya minangili chiayu, anonyun sinumani isakungchan chiayu. ");
INSERT INTO ksc_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Aanonyun sakit na losani nasakit ta sachi ili, ya ifakayu ko ta losani taku wi nganngani chumatong na Manturayan Apudyus an chicha. ");
INSERT INTO ksc_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ngim nu awad ilì chatngonyù maid mammangilin chiayu, ingkaw-ayu ta pappawaycha ad ifakayun chicha, ");
INSERT INTO ksc_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Uray na tapukyu wi pinum-ot ta chapanni, pùpuannì mangakammuwanyu wi ikadyu ta machusaanyu. Ngim maawatanyu kuma wi tuttuway nganngani chumatong na Manturayan Apudyus an chiayu, ngim linawingyu!’” ");
INSERT INTO ksc_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Inturuy Jesus wi man-ukud, anana, “Ifakà an chiayu wi nu chumtong na manguisan Apudyus ta losani taku, sin-umisag na chusan na taku ta sachi ili nu chusan chachi iSodoma!” ");
INSERT INTO ksc_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Inturuy Jesus wi anana, “Kakkaasiayuy iCorazin ya iBetsaida! Isag-ayu kakkaasi nu chachi foon pù Judio wi iTiro ya iSidon, tan nu aschin nangipail-à ta kaskaschaaw wi isun na impailà ad iliyu, nanchapchapurcha kuma ya ummaachuychay nansilup à saku à mangipail-ancha ta mamfafawiyancha. ");
INSERT INTO ksc_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ngim nu chumtong na manguisan Apudyus ta losani taku, sin-umisag na chusayu nu chusan chachi iTiro ya iSidon! ");
INSERT INTO ksc_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","À chiayuy iCapernaum, namnamayu nin wi machayaw-ayu ikad ad langit, ngim naillachuayu tan mifalluayud infierno kapu ta achiyu pu mamfafawiyan!” ");
INSERT INTO ksc_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sachi ad anan Jesus ta chachi disipulusna, “Sinumani mamati ta ukuchonyu, patiyona kò saon. Ngim nu sinun mallawing an chiayu, lawingona kò saon, ad sikurachu koy lawingonan nangifaun an saon.” ");
INSERT INTO ksc_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Na nangulinan chachi pitumpuru ya chuway imfaun Jesus, amod na lagsakcha. Ad ananchan Jesus, “Apu, uray aran, imparyawni ta nangifoswayanni ta ngachannu!” ");
INSERT INTO ksc_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ad anan Jesus an chicha, “Oo, tan innilà na naafakan Satan wi apun na aran, wi naodchag wi isù ilat wi nasaslit wi narpud langit. ");
INSERT INTO ksc_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Chongronyuna! Innadchà chiayù karobfonganyu ta afakonyu losan na karobfongan Satan wi afusuryu, ta uray kuschanyun urog ya kayyaman, maid mapasamak. Siyan maid pu makaafak an chiayu. ");
INSERT INTO ksc_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ngim foon pu kumà siya maragsakanyun mangafakanyu ta aran, tan siya kuma maragsakanyun nilistaan na ngachanyud langit.” ");
INSERT INTO ksc_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Na sachi timpu, imparagsak na Ispiritun Apudyus à Jesus, ad illuwarun Jesus, “Ama, wi Ap-apu ad langit ya asnay luta, manyamanà an sia tan impakaawatnun katuttuwaan mipangkop an saon ta takuy foon pù naachar wi achim pu impakaawat ta nan-araing ya naachar. Siyan manyamanà an sia Ama tan siyan piom wi màwa.” ");
INSERT INTO ksc_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Inturuy Jesus wi man-ukud, “Impiyar Ama na losani awad an saon. Maid pu uchum à nangakammu ta kina-Apudyus-u nu achi afus à Ama wi Apudyus. Ya maid pu ko uchum à nangakammu an Ama wi Apudyus nu achi afusà wi Anàna ya losani takuy piliyà à mangipakaawatà ta mipangkop an siya.” ");
INSERT INTO ksc_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Sachi ad nansakung à Jesus ta chachi disipulusna ad inyagkaawnan chicha imfaka, anani, “Nakasat-ayu tan makailasin-ayu ta ilanyu! ");
INSERT INTO ksc_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Tan tuttuway achun profetas ya Ali ta awi wi maryad mangila ta annay iillanyu ya mangngor ta chochongronyu, ngim fooncha pù naparufusan.” ");
INSERT INTO ksc_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Na osay padcha, na osay mangitudtuchu ta Lintog, inyagsadnay manikap an Jesus wi anana, “Misturu, sinun oyyoò à makafiyakà an Apudyus à ing-ingkana?” ");
INSERT INTO ksc_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ad sinongfatan Jesus à siya, “Sinun anan na niyug-is wi Lintogtau? Sinun naawatam ta finasam?” ");
INSERT INTO ksc_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ad summongfat na larai, wi anana, “Masapur ay-ayatom à Apudyus ta patingkan na somsomònu ya losani oy-oyyoom ya losani karobfongam ya losani kinaraingnu. Ya masapur ay-ayatom na asintatakum à isun na mangayatam ta long-agnu.” ");
INSERT INTO ksc_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ad anan Jesus an siya, “Ustu met na songfatnu. Aammaschiyom ta makafiyag-à ing-ingkana.” ");
INSERT INTO ksc_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ngim na sachi mangitudtuchu ta Lintog, foon à pionay mafàinan à siya, siyan inimusna ko, “Ngim sinun uchumi taku wi masapur ay-ayatò?” ");
INSERT INTO ksc_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ad nan-alig à Jesus wi anana, “Na osay padcha, iningkaw na osay larai wi narpud Jerusalem wi man-osog umoy ad Jerico. Ingkaw ad ta charan, inuyutan na akkawan à siya, ad chinatarchà siya ad inarachan losani ochonna wi uray na luputna, ad tinaynanchà siya wi akin-ottoyon. ");
INSERT INTO ksc_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Sachi ad, niyaspur wi nangoy akon osay pachin na Judio ta sachi charan. Ngim na nangil-ana ta sachi nachatar wi larai, linausana kà siya. ");
INSERT INTO ksc_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ad nangoy ako ta sachi charan na osay Judio wi kanà Levi wi siyan osay fumabfachang ta Templo. Ad na nangil-ana ta sachi iSamaria wi nachatar, ummagsad yakà ait ad tinaynana. ");
INSERT INTO ksc_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Ngim napannos pun, chummatong na osay iSamaria wi foon pun à kailiyantau. Ad na nangil-ana ta sachi nachatar, inachakuwanà siya. ");
INSERT INTO ksc_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Siyan ummoyna inakasan na sukatnà lana ya fayas, ad finofodna achinaot mangafayuwon ta afayuna ad inyoynà siya ta osay maafangan wi foroy, ad finafantayanà siya ta sachi lafi. ");
INSERT INTO ksc_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nafikat pun, innadchonan pilak ta nginforoy ad ananan siya, ‘Fantayam à siya, ad nu mangkurang na annay pilak, chog-à nu mangulinà.’” ");
INSERT INTO ksc_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sachi ad inimus Jesus ta sachi mangitudtuchu ta Lintog, “Na somsomònu ta chachi turu, sinun nangipaila ta ustuy pinag-ayat ta sachi nachatar?” ");
INSERT INTO ksc_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ad summongfat à siya, wi anana, “Siya nangipaila ta ayatna chi larai wi ummachakun siya.” Ad anan Jesus an siya, “Oo, siyan ing-a ad amaschiyom ako.” ");
INSERT INTO ksc_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Na nanadchadcharanancha Jesus, nichaumcha ta osay ili, ad minangilin na osay fufaì siya wi Marta na ngachanna. ");
INSERT INTO ksc_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ad iningkaw akon osay sunud Marta wi mangngachan à Maria, wi ummoy tummùchu ta sangwanan Jesus wi manchongor ta itudtuchuna. ");
INSERT INTO ksc_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ad lummawing na somsomò Marta tan os-osàan à siyay man-iwaar, siyan ummoy an Jesus ad ananan siya, “Apu, isù finay-ananà an sia, wi afusà wi mangisakana ta anonyu tan tinaynanà an sunud-u. Ifakam ud an siya ta fadnganà!” ");
INSERT INTO ksc_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ngim anan Apu Jesus an siya, “Marta, narafos na chanagnu mipangkop ta sinumani màmàwa. ");
INSERT INTO ksc_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ngim os-osàan yakan masapur wi afaruwan, ad sachin piniliyan Maria, ad achi pu maaan an siya.” ");
INSERT INTO ksc_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Na namingsan, wi narpasan Jesus nalluwaruwan ta osay lukar, anan na osay disipulusnan siya, “Apu, tudtuchuwam chianì pinagruwaru wi isun na nanudtuchuwan Juan ta disipulusna.” ");
INSERT INTO ksc_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ad anan Jesus an chicha, “Nu malluwaruayu, amasnan oyyoonyu: ‘Amani, machaychayaw kuman ngachannu. Chumatong kuman manturayam ad asnay luta. ");
INSERT INTO ksc_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Adchan chianì anonni ta finikat. ");
INSERT INTO ksc_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pakawanon chiani ta fasurni, à isun na mamakawananni ta losani fumasur an chiani. Ya ilisim chiani ta achiani pu maawis wi fumasur.’” ");
INSERT INTO ksc_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ad nan-alig à Jesus wi anana, “Nu awad osan chiayù umoy ta fufurunna uray kawan na lafi, ad anam an siya wi, ‘Furun, pafuruchanà ad à turuy fussung à tinapoy, ");
INSERT INTO ksc_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","tan adchatong na osay furun-u wi mamfiyasi ad maid pu ipaan-u an siya!’ ");
INSERT INTO ksc_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ad nu anan na furunnu, ‘Tumaktak-a kay tan losan-ani nasuyop ya narpas-ani nanchaig. Maid fumangofangon!’ ");
INSERT INTO ksc_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ngim uray amaschin ifakana, sikurachuy fumangon ta adchonan imusom, wi foon pù mipakapu kay tan furunnù siya, ngim kapu ta foon pù mafain-a wi man-imuimus. ");
INSERT INTO ksc_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ad somsom-onyun miyalikana, nu awad masapuryu, chawatonyun Apudyus ad adchonan chiayu. Nu anaanaponyun pionyuy anapon, ochasanyu. Ad nu kongkongonyun liwangan, maib-at an chiayu. ");
INSERT INTO ksc_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tan losani manchawat an Apudyus, maatod na chawatona, ad na manganap ta pionay anapon, ochasana, ya maib-at na liwangan ta sinumani mangkongkong. ");
INSERT INTO ksc_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Somsom-onyun annaya: uray à chiayuy aamma, nu manchawat na anàyù filis, adchanyù urog? ");
INSERT INTO ksc_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ad nu manchawat à iprug, adchanyù kayyaman? ");
INSERT INTO ksc_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Siyan chiayuy managfasur, nu akammuyuy mangatod à mamfaru ta anàyu, sin-umisag na oyyoon Amayud langit wi mangatod ta mamfaru! Tan à siya, adchonan Ispirituna ta sinumani manchawat an siya.” ");
INSERT INTO ksc_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Na osay padcha, imparyaw Jesus na osay aran wi nangumor ta osay taku. Ad na lummayawan na aran, nakakingan sachi larai, ad siyan naschaaw losan na nangiila. ");
INSERT INTO ksc_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ngim anan na uchum, “Karobfonganay mangiparyaw ta aran tan à Beelzebub wi ap-apun na aran, siyan nangatod ta karobfongana!” ");
INSERT INTO ksc_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ad iningkaw akon uchum wi pionchay manikap an Jesus, siyan imfakacha ta mangwà kaskaschaaw à manuttuwaancha wi Apudyus na narpuwan na karobfongana. ");
INSERT INTO ksc_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ngim inaagkammun Jesus na somsomòcha, siyan sinongfatana chichà alig, wi anana, “Uray sinuy turay, nu foon à mantitimpuyug na takucha wi kanayuncha mantintinnanung wi mampapatoy, narakan mayam-anancha. Ad nu maid timpuyug na simfaryan, mansisiyancha. ");
INSERT INTO ksc_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Isuna ko nu kufaton Satan na akin-aaranna, kapilitani mayam-an na manturayancha. Amaschin ifakà tan ananyuy Beelzebub na nangatod ta karobfongà wi mangiparyaw ta aran. ");
INSERT INTO ksc_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ngim nu siyan nangatod ta karobfongà, kattoi siya kon nangatod ta karobfongan chachi fufurunyu wi mangiparyaw ta aran! Tan na oyyoon na fufurunyu, sachi kuman mamanoknok an chiayu wi nangkurang na somsomòyu! ");
INSERT INTO ksc_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Siyan foon à Beelzebub na nangatod ta karobfongà wi mangiparyaw ta aran, tan Apudyus na nangatod. Ad siyan mangakammuwanyu wi nar-us chummatong na Manturayan Apudyus ad asnay luta. ");
INSERT INTO ksc_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Miyalig à Satan ta takuy oschoran wi nan-ar-armas wi fafantayanan foroyna, ad maid pu makaakaw ta ochonna. ");
INSERT INTO ksc_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ngim nu umalin osay naos-oschor nu siya wi kufatona ya inafakna, ilayawna losan na armasnay ananay iyafakna ad fingfingayona ta fufurunnan losani sinamsamna.” ");
INSERT INTO ksc_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ad anan ako Jesus, “Sinumani takuy achi pu miyamfuruy an saon, siyan fumusur an saon. Ya sinumani achi pu fumachang an saon ta oyyoò, siyan kumukuran saon.” ");
INSERT INTO ksc_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Inturuy Jesus wi nan-alig, anana, “Nu lummayaw na aran ta osay nakafarfaray, umoyna kagkaayon na ikaw wi maid pu fumroy wi man-anap à ingkawana. Ad nu kaspangalikan maid pu ochasana, somsom-ona, ‘Mangulinà ta sachi takuy narpuwà.’ ");
INSERT INTO ksc_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ad nu mangulin ya ochasanay mamfaru ya nacharus, ");
INSERT INTO ksc_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","umoy man-ayag à pitù furunna wi sillumawing nu siya, ad mallonogcha losan ta sachi taku. Siyan na nàwa ta sachi taku ta anungusna, sin-umisag nu chamu.” ");
INSERT INTO ksc_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Na nangug-ugkuchan Jesus ta sachi, iningkaw na osay fufai wi niyaslang ta takuy ad-adchuwan, ad anana, “Kattoi maragsak na fufai wi nangiyanà an sia ya namasusun sia!” ");
INSERT INTO ksc_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ad summongfat à Jesus wi anana, “Oo, ngim maragragsak chachi mangngor ta ukud Apudyus ad patkoncha!” ");
INSERT INTO ksc_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Na sachi ummafuyutan na taku an Jesus, anana, “Lawing na taku ta sanay lunap! Apay mampail-onà à kaskaschaaw? Maid pu uchum à kaskaschaaw à ipailà an chiayu nu achi afus na sachi singyar wi nàwan Jonas ta awi. ");
INSERT INTO ksc_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tan na nàwan Jonas, sachin nanuttuwaan chachi iNineve wi tuttuway Apudyus na nangifaun an siya. Ad amaschi kon màwan saon à manuttuwaan akon taku ta sana wi Apudyus na nangifaun an saon. ");
INSERT INTO ksc_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nu chumtong na Padchay Makuisan na losani taku, lumoswan sachi fufai wi Ali ta awi ad Seba ad pafasuron chiayuy taku ta sanay lunap, tan uray nu ad-adchayuwan na namfiyasiyana, ummoyna ikattò chongron na kinaraing wi intudtuchun Ali Solomon. Ngim à chiayu, uray annaà ta sana wi nangatngatu nu Solomon, achiyu pu chongron na itudtuchù an chiayu! ");
INSERT INTO ksc_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ad na sachi koy Padchay Makuisan na losani taku, pafasuron chiayu ta chachi tinudtuchuwan Jonas ad Nineve, tan namfafawicha ta nangngorancha ta intudtuchun Jonas. Ngim à chiayu, safali tan uray annaà ta sana wi nangatngatu nu Jonas, achiyu pu chongron na itudtuchù an chiayu!” ");
INSERT INTO ksc_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Inturuy Jesus wi man-alig, anana, “Maid pu takù mamaskid ta silaw ad sinar-iwana winnu tinab-unana, ngim ipatayna ta ustuy papattayana ta mailan sinumani lumnò. ");
INSERT INTO ksc_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Na ata, siyan silaw na long-ag. Siyan nu maid pu chifiktun na ata, isù losan nasilawan na long-ag. Ngim nu awad chifiktun na ata, isù awad na long-ag ta pangot. ");
INSERT INTO ksc_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Siyan am-ammaanyu ta achi pumangot na lawag ta long-agyu. ");
INSERT INTO ksc_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ngim nu losan nasilawan na long-ag wi maid ait à pangotna, lumawag na manomsom-anyu wi isù nasilawan-ayu ta mamfaruy silaw.” ");
INSERT INTO ksc_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Narpas pù Jesus nan-ukud, inayakan na osay Fariseo à siya ta makaan ta foroyna, ad linumnò pun tummùchu wi mangan. ");
INSERT INTO ksc_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ngim naschaaw na Fariseo ta nangil-anan Jesus tan achina pu tungparon na lintogcha, wi nu mangancha mamfurucha umuna. ");
INSERT INTO ksc_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Siyan nan-alig à Jesus an siya, wi anana, “Chiayuy Fariseo, iwaiwasanyun lafaw na tasayu ya pingkanyu wi mamàila ngim na somsomòyu wi achi pu maila, nanapnù kinurukyu ya kinamkamanyu ta taku. ");
INSERT INTO ksc_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Fokon-ayu! Tan achiyu pu akammu wi iningwan ako Apudyus na charom na long-ag wi achi pu maila, foon pu kà afus na mamàilà iningwana. ");
INSERT INTO ksc_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Faliwanyu yan na somsomòyu ta fadnganyun asintatakuyuy kakapus, tan nu fumarun sachi achi pu maila, kapilitani fumaru kon sachi mamàila. ");
INSERT INTO ksc_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kakkaasiayuy Fariseo! Tan uray mangatod-ayù pagkapurun na charusi mamparamnaw ta maan, iwalinyun napatpatog tan foon à nalimpiw na oy-oyyoonyu ya foon à ay-ayatonyù Apudyus. Amaschin masapur oyyoonyu kuma ya achiyu ko lausan na uchum. ");
INSERT INTO ksc_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Tuttuway kakkaasiayu, chiayuy Fariseo! Tan pipionyuy chiayun umachuy ta afaruwani aachuyan ta sinagoga, ad pionyu koy malispitu ta aallusan na taku. ");
INSERT INTO ksc_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kakkaasiayu, tan isuayù lofon wi foon pù namarkaan, wi kuskuschan na taku tan achicha pu ilasin.” ");
INSERT INTO ksc_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Sachi ad, anan na osay mangitudtuchu ta Lintog an Jesus, “Misturu, na mangifag-am ta amasnat, nitapiani ko nainsurtu!” ");
INSERT INTO ksc_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ad sinongfatan Jesus à siya anani, “Kakkaasiayu ko, chiayuy mangitudtuchu ta Lintog! Tan subsubraanyun lintog ad parpalikatanyun taku ta mangipapilitanyu mampatungparan. Isù ipafuudyun chagsonani amod à mafuud, ad achiyu pù ait fadngan chicha. ");
INSERT INTO ksc_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kakkaasiayu! Tan finarfaruyun pantiyung wi nilobnan na tung-ar na chachi profetas wi pinatoy na aappuyu ta awi. ");
INSERT INTO ksc_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ad sachin mangipail-anyu wi apufaranyu kon iningwan chachi aappuyu ta awi, tan chichan namatoy ta profetas ad chiayun mampafaru ta pantiyungcha. ");
INSERT INTO ksc_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ad sachin tummuttuwaan na imfakan Apudyus ta kinaraingna wi anana, ‘Umifaunà à profetas ya uchumi fabfaun an chicha. Ngim patoyonchan uchum ya palikatancha kon uchum.’ ");
INSERT INTO ksc_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Siyan chiayuy taku ta annay sillumunap, chiayun mangikaru ta chusan na napatayan na losani profetas nanipud ta nàwaan na annay lufung, ");
INSERT INTO ksc_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","wi nanipud ta namatayanchan Abel ingkanan Zacarias wi napatoy ta namforaatan na altar ya Templo. Oo, tuttuwan ifakà an chiayuy taku ta annay sillumunap, wi chiayun mangikaru ta chusan na losani amaschi wi nàwa! ");
INSERT INTO ksc_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kakkaasiayu, chiayuy mangitudtuchu ta Lintog, tan sinillaanyun somsomò na takuy manganap ta katuttuwaan mipangkop an Apudyus, tan uray chiayu, achiyu pu parnoon na katuttuwaan mipangkop an siya ta somsomòyu, ad ipalityu kon mangiparnoan na uchum!” ");
INSERT INTO ksc_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Lummayaw pù Jesus ta sachi foroy, chachi mangitudtuchu ta Lintog ya Fariseo, isagcha chinillaw à siya. Ad maid achicha sarudsuchon ");
INSERT INTO ksc_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","à manikapancha kuma ta awad ait à masaw-aana ta ukudna ta awad mampafasuranchan siya. ");
INSERT INTO ksc_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Na sachi, ummachuachun takuy naarus, ad makamkammurawchay alifulifu wi man-ip-ipitcha. Ad anan Jesus ta disipulusna, “Tanchaananyu ta achiyu pàpàwatan na achawiyan na Fariseo wi akinpapaticha wi miyalig ta yeast. ");
INSERT INTO ksc_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tan tuttuway losani achi pu maila ta sana, mipailà tapin na padcha. Ya losani nitataru ta sana, mallotaw nu chumatong na timpuna. ");
INSERT INTO ksc_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Siyan losani ukuchonyu ta pangot, mipadlaw ta padcha, ad losani intupkayu ta aafusanyu, mipagngor ta sangwanan na losani takù tapin na padcha.” ");
INSERT INTO ksc_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ad inturuy Jesus wi anana, “Na ifakà an chiayuy fufurun-u, achiayu umogyat ta chachi mamatoy ta long-ag, wi sachin pagpag na lobfongcha. ");
INSERT INTO ksc_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ngim siya umogyatanyu kumà Apudyus, tan nu otyonan long-ag, annan karobfonganay mangifallu ad infierno wi sachin machusaan na taku. Siyan Apudyus na ustuy ogyatanyu! ");
INSERT INTO ksc_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Panunutonyun somsomò Apudyus an chiayu, tan uray na sissiwit wi mangin-an na limà chuway siping, maid pu osà maliwatan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ad sinchumallù chiayu, tan uray na fuùyu, finilang Apudyus. Siyan achiayu kuma umogyat ta sinuman tan napatpatog-ayu an Apudyus nu achuy sissiwit!” ");
INSERT INTO ksc_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Inturuy Jesus wi man-ukud, anana, “Sinumani manàchor ta sangwanan na taku wi saon na Apuna, sikurachuy saon wi namfalin taku, tàchorà ako siya ta sangwanan na aangheles Apudyus. ");
INSERT INTO ksc_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ngim sinumani mangilifak an saon ta sangwanan na taku, à saoni namfalin taku, ilifak-u kò siya ta sangwanan chachi aangheles Apudyus. ");
INSERT INTO ksc_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Sinumani mangifakà lawing mipangkop an saoni namfalin taku, mafalini mapakawan. Ngim na mangifakà lawing mipangkop ta Ispiritun Apudyus, achi pu mafalini mapakawan. ");
INSERT INTO ksc_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nu icharumchà chiayu ta sinagoga ya fifinnachur ya nan-angatuy turay, achiayu machanakan mipangkop ta isongfatyu ya ifakayu, ");
INSERT INTO ksc_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","tan na sachi uras, ipaspasmò na Ispiritun Apudyus an chiayun ustù ifakayu.” ");
INSERT INTO ksc_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Sachi ad nan-ukud an Jesus na osay larai ta sachi amung, wi anana, “Misturu, mafalin nu ifakam ta sunud-u ta mamfingayannin tinawidni?” ");
INSERT INTO ksc_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ngim sinongfatan Jesus à siya anani, “Maid pu fiyang-u wi mangilintog an chiayu winnu mamingay ta làsunyu!” ");
INSERT INTO ksc_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ad inturuy Jesus wi mantudtuchu ta chachi taku, anana, “Man-annad-ayu ta achiayu maawis wi mangkamkam, tan uray nu summawar na kinafaknang na osay taku, foon pù amaschin fumaruwan na mafiyakana.” ");
INSERT INTO ksc_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Sachi ad nan-alig à Jesus wi anana, “Na namingsan, iningkaw na osay faknangi larai wi nagkasan na murana. ");
INSERT INTO ksc_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ad namnammò na sachi faknang, ‘Sinun in-inò tan nanapnun arang-u ad maid mangigkaà ta achuy apit-u? ");
INSERT INTO ksc_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Amasnan oyyoò. Faasò na arang-u ta pachakrò ta awad mangigkaà ta losani apit-u ya ochon-u. ");
INSERT INTO ksc_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ad som-osom-ò ako, Nakasatà, tan summawar losan na masapur-ù atawwotawwon, siyan achiyà pu asin man-iwaar! Mangamanganà, uminuinumà, ya lagragsakò na fiyag-u!’ ");
INSERT INTO ksc_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ngim na sachi, anan Apudyus ta sachi taku, ‘Ningning-a! Tan sanay lafin matayam, ad sinun mangin-uwa ta anchanayay kinakomam?’” ");
INSERT INTO ksc_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Sachi ad inyanungus Jesus anani, “Amaschin màwa ta takuy mangkakokakom à kinafaknang ad asnay luta, ngim maid somsomònan Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Sachi ad anan Jesus ta chachi disipulusna, “Siyan na ifakà an chiayu, achiayu machanakan mipangkop ta masapuryu ta mafiyakanyu, isun na maan ya luput. ");
INSERT INTO ksc_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tan napatpatog na fiyagyu nu maan, ya long-agyu nu luput. ");
INSERT INTO ksc_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ilanyun sissiwit. Achicha pu mammura ya maid apitoncha, ya maid pu ko mangigkaancha ta masapurcha. Ad tamako ta asififiyagcha nu? Oo, tan Apudyus na mangayyuwan an chicha! Ad napatpatog-ayu an Apudyus nu sissiwit! ");
INSERT INTO ksc_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ad na osa, maid pu iturung na chanag tan uray machanachanakan-ayu, maid itur-ayna ta fiyagyu! ");
INSERT INTO ksc_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Siyan nu achiayu pu makàwa ta amaschì uray ait, taayuko machanakan mipangkop ta uray farangna? ");
INSERT INTO ksc_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ilanyun mantutufun na fokaw. Achicha pu man-iwaar winnu mallakà luputcha, ngim ifakà an chiayu wi namagmagkit na sabsafungcha nu afaruwani silup Solomon wi afaknangani Ali. ");
INSERT INTO ksc_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Siyan nu amaschin oyyoon Apudyus wi mangipafaru ta fokaw wi sin-aitan yakan awachancha, tan uray awad ta sana, maryawchà fikat ad maskobcha, sinchumallun somsomòna ta mipangkop ta iluputyuy taku! Kurang na pammatiyu! ");
INSERT INTO ksc_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Achiyu kuma som-osom-on na masapuryù ifiyagyu wi isun na maan ya mainum, ya achiayu machanakan ta amaschi, ");
INSERT INTO ksc_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","tan amaschin som-osom-on na taku ta annay lufung wi foon pù mamati. Ngim chiayu, akammun Apudyus wi Amayu wi masapuryu losan na amaschi. ");
INSERT INTO ksc_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Siyan na som-osom-onyu kuma, mipangkop ta Manturayan Apudyus, tan nu amaschin patpatkanyu, nangamung à siyay mammammò ta losani masapuryu.” ");
INSERT INTO ksc_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Inturuy Jesus wi mantudtuchu ta disipulusna, anana, “Achiayu umogyat uray ààiyut-ayu, tan naragsak à Apudyus wi mangitapin chiayu ta Manturayana. ");
INSERT INTO ksc_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Siyan inginayun ùuwayu ta iturungyun nginana ta kakapus, tan sachin manonsonanyu ta kinafaknangyud langit. Tan nu sachin manonsonanyu, maid pu maksayan ta kinafaknangyu tan maid makaakaw ya maid makachachail. ");
INSERT INTO ksc_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tan na katuttuwaan, sinumani patpatkanyu, kapilitani siya kon som-osom-onyu.” ");
INSERT INTO ksc_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Inturuy Jesus wi man-ukud, wi anana, “Masapur makasakanaayu, uray sinun mapasamak, wi na miyalikana isuayù sasannilu wi manguullay ta apucha wi ummoy nakakasar, wi nansilupcha ya nangongogkan na silawcha, ta nu mangulin na apucha ad mangkobkob, chakusi ib-atcha. ");
INSERT INTO ksc_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ad maragragsakan chachi sasannilu wi ochasan na apucha chichay nakasakana wi foon pù nasusuyopcha! Tuttuway aanonan kunsurna ad ipatùchuna chicha ad pinaananà chicha. ");
INSERT INTO ksc_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Uray nu kawan na lafin chumatngana, winnu nganngani mafikat, nu ochasana chichay nakasakana, maragragsakancha!” ");
INSERT INTO ksc_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Asin ako nan-alig à Jesus, wi anana, “Somsom-onyu kon anna, wi nu inakammun na nginforoy na ustuy uras na umaliyan na man-akaw ta foroyna, kapilitani tatanchaakana ta maid pu maakaw ta foroyna. ");
INSERT INTO ksc_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Siyan amaschiyonyu ko wi masapur makasakanaayu, tan à saoni namfalin taku, mangulinà ta timpuy foon à namnamaonyuy chumatngà.” ");
INSERT INTO ksc_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Sachi ad anan Pedro an Jesus, “Apu, chiani kay disipulusnun mangifag-am ta sanat winnu losan na taku?” ");
INSERT INTO ksc_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ad anan Apu Jesus wi nan-alig, “Sinun mangilasinanyu ta mapiyar ya nanakman wi sanilu? Siyan piniyar na ap-apuna wi mangayyuwan ta fufurunnay sanilu ya mamaan an chicha nu timpun na inyòoan. ");
INSERT INTO ksc_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ad maragragsakan na sachi sanilu nu aspuron na apunà siyay mangwa ta losani nipiyar an siya! ");
INSERT INTO ksc_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tan tuttuwan ifakà an chiayu, wi na kinapiyarna, siya kon mangipiyaran na apuna ta losani ùuwana. ");
INSERT INTO ksc_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ngim nu siya somsomò na sachi sanilun mafayag na mangulinan na apuna, ya ilukinay mamalikat ta fufurunnay sanilu uray fubfufai ya lallarai, ya makàakàan ya makàikàinum ya masallisallimong, ");
INSERT INTO ksc_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","machanatong na apuna ta timpuy foon à namnamaonay chumatngana. Siyan kapilitani chusaon na apunà siya ad itapinà siya ta machusaan na losani foon à mamati. ");
INSERT INTO ksc_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Na takuy akammunan pion na apunay pàwa ngim achina pu oyyoon winnu achi pu mansakana, amod na masaplitana. ");
INSERT INTO ksc_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ngim na takuy maid pu akammuna ta pion na apuna, ad nangwa kò lawing, ait na masaplitana. Tan na takuy achun nipiyar an siya, kapilitani achun songfatana. Ad na takuy ad-achun nipiyar an siya, ad-achu kon songfatana.” ");
INSERT INTO ksc_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Sachi ad asin nan-alig à Jesus wi anana, “Na ummaliyà ad asnay luta, sogkò na sinuman. Ad sapay kuma ta nar-us kummilab! ");
INSERT INTO ksc_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Masapur chumatong na maparpalikatà, ad asngaà wi mammammò ingkanà marpasana. ");
INSERT INTO ksc_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ananyu pun nin nu ummalì turnuson na losani taku ta luta! Ngim foon pun, tan ummaliyà à mansisinaan na taku ya mangkukuraancha. ");
INSERT INTO ksc_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Siyan manipud ta sana, amasnan màwa. Nu liman simfaryan, kuraon na turu na chuwa, ya kuraon akon chuwa na chachi turu. ");
INSERT INTO ksc_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Uray na man-aama, man-asikuracha, ya isuna kon man-iina ya man-at-atukanga, tan mangkikinnuracha losan.” ");
INSERT INTO ksc_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ad nan-alig akò Jesus ta chachi ad-adchuwan, wi anana, “Nu ilanyuy mangmangngitit na lifuu, akammuyuy umuchan, ad tuttuway umuchan! ");
INSERT INTO ksc_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ad nu malìnayun poyaaw wi namparpud lakud, chooyu anani malikat à fikat, ad tuttuway malikat! ");
INSERT INTO ksc_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Chiayuy akinpapati! Apay mafalini ilasinyun singyar na kinafarun na tarun ngim achiayu pu makailasin ta isingyar Apudyus ta anchanayay màmàwa ta chokanninay timpu?” ");
INSERT INTO ksc_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ad inturuy Jesus anani, “Taayuko achi makasomsomò à mamfarù màwa? ");
INSERT INTO ksc_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nu kaspangalikan awad mangicharum an chiayu ta korti, pachasonyu yan ta patingkan na karobfonganyu wi aligruwon, ta achiayu pu kuma mipasangu ta kuis, tan nu ipasanguchà chiayu ta kuis, ipurangnà chiayu ta pulis ad imfarud chiayu. ");
INSERT INTO ksc_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ad nu mifarud-ayu, achiayu pu miparufus ta fafalluchan ingkanà finayachanyun losani murtayu.” ");
INSERT INTO ksc_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Na sachi koy timpu, iningkaw na uchumi taku wi ummoy nangifakan Jesus ta nampapatayan Pilato ta uchumi iGalilea ta nangichatunancha ta animar an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ad sinongfatan Jesus chicha anani, “Apay, kapu ta amaschin napatoyancha, siya somsomòyun sachin manuttuwaanyuy sin-umisagcha managfasur nu uchumi iGalilea? ");
INSERT INTO ksc_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Tuttuway foon! Ngim na ifakà an chiayu, nu achiyu pu man-awichan na lawingi oy-oyyoonyu, amaschi kon arawing na matayanyu. ");
INSERT INTO ksc_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ya mipangkop ako ta natayan chachi simpuru ya waruy natapilan ta nikur-ufan chi tànangani foroy ad Siloe, siya somsomòyun sachin manuttuwaanyuy sillumawing na fasurcha nu losani uchumi iningkaw ad Jerusalem? ");
INSERT INTO ksc_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Foon pu ko! Ngim tuttuwan annay ifakà an chiayu, wi nu achiyu pu man-awichan na fasuryu, amaschi kon arawing na matayanyu.” ");
INSERT INTO ksc_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Sachi ad asin nan-alig à Jesus wi anana, “Iningkaw na osay taku wi tummufun osay ayu wi ikus ta lutana. Ad umoumoyna ilan nu awad lawa fungana, ad maid. ");
INSERT INTO ksc_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Siyan anana ta man-iiwaarona ta lutana, ‘Na! Atlun tawon-u ta sanay umali mangila nu awad fungan na annay ayu, ad maid. Pokpokonta! Tan nu iingkaw, chachailona kan luta.’ ");
INSERT INTO ksc_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ngim summongfat na man-iiwaarona, ‘Apu, anusanta urayon à sintawon ta aufà na puunna ad inafunuwà, ");
INSERT INTO ksc_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ad nu mamungà tawon, mamfaru. Ngim nu achi pun, pokpokonta.’” ");
INSERT INTO ksc_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Na namingsani Safachuy ngingillinan, nantudtuchù Jesus ta osay sinagoga wi makimkimungan na Judio. ");
INSERT INTO ksc_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ad niyaspur wi iningkaw akon osay fufai wi nafùung, wi finùung na aran, wi ummoy à masawaran à waruy tawon na nafùungana. ");
INSERT INTO ksc_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Innilan pu Jesus à siya, inayakanà siya wi anana, “Ina, maaan na sakitnu!” ");
INSERT INTO ksc_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ad inagpachanà siya, ad nalinchong na umagsachana, ad chinayawnà Apudyus. ");
INSERT INTO ksc_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ngim naaliling-ot na mangipangpangu ta sachi sinagoga, tan Safachuy ngingillinan na nampaimfakan Jesus ta sachi nasakit. Siyan anana ta chachi naaamung, “Tamakonna? Onom padcha met na mafalini umiwaaran ta sinchumingkuwan. Sachi kuman umaliyanyu mampaimfakan, ta foon pù Safachuy ngingillinan!” ");
INSERT INTO ksc_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ad sinongfatan Jesus à siya anani, “Chiayuy akinpapati! Uray Safachu, nu mauwaw na fakayu winnu afayuyu, painumanyu. ");
INSERT INTO ksc_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ngim maid somsomòyu ta annay kailiyanyu wi kanà ako Abraham, wi simpuru ya waruy tawon na namalikatan Satan an siya, ad siya ananyun lawing nu maaan na sakitna tan Safachu!” ");
INSERT INTO ksc_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ad chachi mallawing an Jesus, nafàinancha ta songfatna. Ngim isag naragsak na takuy ad-adchuwan ta losani kaskaschaaw wi iningwana. ");
INSERT INTO ksc_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Sachi ad inimus Jesus, “Sinun miyisuwan na Manturayan Apudyus à mangiyalikà? ");
INSERT INTO ksc_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Na osay miyalikana, amasna. Immuran na osay takun fuor wi mustard ta umana. Ad chummakor ad namfalin ayu wi manùfutan na sissiwit na pangana.” ");
INSERT INTO ksc_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ad asin ako nan-alig à Jesus wi anana, “Ad sinu kon mangiyalikà ta Manturayan Apudyus? ");
INSERT INTO ksc_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Isun na mangitumayan na fufai ta yeast ta sillatay arina ingkanà fumtar losan na arina.” ");
INSERT INTO ksc_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Sachi ad inturuynay umoy ad Jerusalem, wi nantudtudtuchu ta taku ta il-ili wi innoyna. ");
INSERT INTO ksc_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ad iningkaw na osay nangimus an siya, wi anana, “Apu, ààiyut yakan takuy masaraknifan?” Ad summongfat à Jesus à alig, wi anana, ");
INSERT INTO ksc_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ipapatiyuy mangoy ta nalipiti liwangan tan siyan lumnoanyud langit, tan ad-adchuwan na takuy safalin oyyooncha wi mamachas lumnò ngim achicha pu makarnò. ");
INSERT INTO ksc_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tan na nginforoy, nu illausna inyonob na liwangan maid fotlon na narsin. Ad uray nu umaagsad-ayu wi mangkobkokobkob ya mampoapoaw anani, ‘Apu, ib-atam à chiani!’ siya isongfat na nginforoy, ‘Maid pu akammù an chiayu nu sinun narpuwanyu!’ ");
INSERT INTO ksc_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ad àaruonyu anani, ‘Chianin nakàakàan ya nakain-inum an sia, ad ilini kon nantudtuchuwam!’ ");
INSERT INTO ksc_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ngim isaradna anani, ‘Maid pu akammù an chiayu nu sinun narpuwanyu. Lumayaw-ayu losan, lawing na oy-oyyoonyu!’ ");
INSERT INTO ksc_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ad na mangil-anyu ta aapputauy cha Abraham an Isaac ya Jacob, ya losan chachi profetas Apudyus, wi nitatappicha losan ta Manturayan Apudyus, man-ifil-ayu ya ngumarotngotonyun fafayu tan mifalluayuy achi pu mitapi! ");
INSERT INTO ksc_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ngim na takuy mitapi ta Manturayan Apudyus, farangnan marpuwancha wi ailiili wi uray na foon à Judio, mitapicha ko wi makaragragsak an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Siyan somsom-onyuna: Na takuy nafafa ta sana, chichan nangatù tapin na padcha. Ngim na takuy isù nangatu ta sana, chichan nafafà tapin na padcha.” ");
INSERT INTO ksc_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Na sachi timpu, chummatong na uchumi Fariseo, ad ananchan Jesus, “Un-unnoy nin nu lumayaw-ad asna, tan pion Ali Herod wi mamatoy an sia.” ");
INSERT INTO ksc_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ad sinongfatan Jesus chicha anani, “Ing-ayu ifaka ta sachi masikap, wi na sanay timpu, ituruy-u wi paryawon na aran wi farfaray ya mampaimfag ta nasakit, tan foon à mafayag ad kangputò na oyyoò. ");
INSERT INTO ksc_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Siyan masapur ituruy-un pangkop-u ta sanay timpu, tan maid safalì matayan na profeta nu achi afus ad Jerusalem.” ");
INSERT INTO ksc_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Sachi ad anan Jesus, “O Jerusalem, chiayuy iJerusalem, amod na somsomòun chiayu! Tan chiayun nangtoy ta profetas ya namisong ta chachi finaun Apudyus à manudtuchun chiayu! Naina kon naryachà wi mangaruarus kuman chiayu wi isun na manaofan na manù ta isiwna, ngim ummisìayu! ");
INSERT INTO ksc_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Siyan na sana, ikadyu kay nu maid pu mangayyuwan an chiayu. Tan manipud ta sana, maid asin mangil-anyun saon ingkana ta padchay mangifag-anyuy, ‘Chayawontaun annay ummali wi narpun Apudyus.’” ");
INSERT INTO ksc_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Na namingsani Safachu, inimfitar na osay nangatuy Fariseo à Jesus ta umoy makaan ad foroycha. Ad na uchumi taku ta sachi, sipsiputanchà siya nu sinun oyyoona ");
INSERT INTO ksc_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","tan iningkaw akon osay larai wi nallotlotog. ");
INSERT INTO ksc_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Sachi ad inimus Jesus ta chachi Fariseo ya mangitudtuchu ta Lintog anani, “Masurngasing na Lintogtau nu paimfakon na sakit ta uray Safachuy ngingillinan?” ");
INSERT INTO ksc_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ngim akikinnòcha. Siyan inagpachan Jesus na nasakit ad inaannan sakitna, ad imfakana ta lumayaw. ");
INSERT INTO ksc_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Sachi ad anana ko ta chachi manipsiput, “Somsom-onyuna, wi nu mafituwan na anàyu winnu fakayu ta Safachu, achiyu pu lawa umoy aran?” ");
INSERT INTO ksc_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ngim maid pu isongfatcha ta sachi. ");
INSERT INTO ksc_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Illasin pu Jesus wi mampilin uchum ta chachi inimfitar na sachi Fariseo à tumùchuwanchà afaruwan à uùchuwan, tinudtuchuwan Jesus chicha losan wi ananay nan-alig, ");
INSERT INTO ksc_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nu maimfitartà makakasar, achita kuma tumùchu ta apatkani uùchuwan, tan nu awad naimfitar à nangatngatu nu chita, ");
INSERT INTO ksc_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","mafainta nu umalin sachi nan-imfitar an chita ad ananay, ‘Umachuyan na annati nangatuy takun anna.’ Ad isagta mafainan wi umoyta umachuy ta ikid. ");
INSERT INTO ksc_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Siyan na oyyoon kuma, nu ayakan chita wi makaragsak, tumùchuta ta ikid, ta ikad na nan-imfitar wi mangwanan, ‘Umaliasna tan annayan farfaruy uùchuwan.’ Nu amaschin màwa, machayawta ta sangwanan losan chachi uchumi naimfitar. ");
INSERT INTO ksc_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tan sinumani mangipangatu ta long-agna, mipafafa, ngim sinumani mangipafafa ta long-agna, ngumatu.” ");
INSERT INTO ksc_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Sachi ad anan Jesus ta sachi nan-imfitar an siya, “Nu kaspangalikan mampartiay mallagsak, achim imfitaron afus yakan kakayyomnu ya susunudnu ya aagkiyu ya fafaknangi chachar-agyu, tan mafalinchay sumufalit, siyan isù mafayachan na iningwam tan parnusancha kò sia. ");
INSERT INTO ksc_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ngim na oyyoom, nu mallagsak-a, imfitarom na kakapus ya chachi napilay ancha nakurap, ");
INSERT INTO ksc_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","tan nu amaschiyom, mafinchisyunan-a tan achicha pu makasufalit. Ad siya manufalit à Apudyus ta padchay umuliyan matakuwan na mamfaruy taku.” ");
INSERT INTO ksc_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Chingngor pun na osay makaan an Jesus ta intudtuchuna, anana, “Isag maragsak chachi makaragsak ta Manturayan Apudyus ad langit!” ");
INSERT INTO ksc_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ad sinongfatan Jesus à siyà alig wi anana, “Na namingsan, iningkaw na osay taku wi mamparagsak à chakor, siyan nan-imfitar à ad-adchuwan à umali kuma makaragsak. ");
INSERT INTO ksc_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ad narpas pun nisakana losan, finaunnan saniluna ta umoyna ifaka ta chachi inimfitarna ta umalicha, tan nisakana losan. ");
INSERT INTO ksc_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ngim chachi naimfitar, asilarasunchà achicha pu umayan. Na osa, anana, ‘Pangaasim tan achiyà pu makaali tan awad na angnginginà wi payaw, ad masapur inyà yan ilan.’ ");
INSERT INTO ksc_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ad na osa ko, anana, ‘Pangaasim tan achiyà pu makaali, tan angnginginaà à simpurù luwang, siyan inyà yan chicha pachason.’ ");
INSERT INTO ksc_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ad na osa ko, anana, ‘Àasawaà, siyan achiyà pu makaali.’ ");
INSERT INTO ksc_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Sachi ad nangulin na sanilu ad imfakana losan na lasuncha ta apuna. Ad naaliling-ot na apuna, ad anana ta saniluna, ‘Kanasom ta ing-a ta losani charan ya ar-arsa ta annay ili ad uray sinuy ochasam, ayakam losan ta umalicha makaragsak wi uray na kakapus ya napilay ancha nakurap.’ ");
INSERT INTO ksc_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Narpas pun na sachi, nangulin akon sachi sanilu ad anana, ‘Apu, pintog-un imfakam, ngim anna ko kan màkawan.’ ");
INSERT INTO ksc_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Siyan anan akon apuna, ‘Siyan ing-a ko ta uray ad-adchayuwani lukar, ad àaruom ta takuschi ta umalicha ko makaragsak ta mapnu kuman annay foroy-u. ");
INSERT INTO ksc_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tan kattoi maid pu osa ta chachi ummunay naimfitar à manimsim ta annay nisakana!’” ");
INSERT INTO ksc_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Na namingsan wi ad-adchuwan na takuy mituntun-ud an Jesus, nansakung à Jesus an chicha ad anana, ");
INSERT INTO ksc_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Sinumani maryad wi mamfalin disipulus-u, masapur wi chakchakor na ayatnan saon nu ayatna ta amana ya inana ya uray asawana ya an-ananàna ya susunudna, ya uray akon long-agna, tan nu achi pu makàwa ta amaschi, achi pu mafalini mandisipulus-u. ");
INSERT INTO ksc_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ya sinuman akoy achina pu maturochan na losani likat na sumurutanan saon, uray siyan iyatoyna, achi pu ko mafalini mandisipulus-u. ");
INSERT INTO ksc_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Amasnan aligna. Nu kaspangalikan awad mampatàchor à chakor à foroy, unaona som-osom-on na kastuwona ta akammuwona nu umanay na pilaknà mangkangputana ta sachi foroy. ");
INSERT INTO ksc_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tan nu achina pun, ad illukinay mampatàchor ad naamin nakastun pilakna wi achi pu makakangput, am-amangon na losani mangilan siya tan kurang na mafalinna. ");
INSERT INTO ksc_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ad amsiwoncha anani, ‘Illukinay nampatàchor ad achi pu makakangput!’ ");
INSERT INTO ksc_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ad na osay aligna, nu kaspangalikan awad osà Ali wi simpuruy lifun surchachuna, achina pu umoy ikufat ta akin-aalina wi chuwampuruy lifun surchachuna nu achina pun unaon som-osom-on nu lobfongnay makaafak ta sachi afusurna winnu achi pun. ");
INSERT INTO ksc_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ad nu ilasinna wi kurangchà makakufat, umifaun à umoy mangimus ta afusurna tan chaancha pù lumigwat nu sinun pionà mantitimpuyukancha.” ");
INSERT INTO ksc_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ad inyanungus Jesus anani, “Isun akon chiayu, sinumani mangwanani sumurut an saon, masapur mammammò yan, tan achi pu mafalin wi sumurut na takun saon nu achina pu fay-anan na losani awad an siya.” ");
INSERT INTO ksc_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Asin nan-alig à Jesus à miyalikan chachi sumurut an siyà asin, anana, “Mamfarun asin, ngim nu maaan na tamtamna, maid in-inon wi mangiyulin ta kinaasinna. ");
INSERT INTO ksc_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Siyan maid silfina uray nu usaron à afunu, siyan mifallu kay. Naingaan-ayu, siyan somsom-onyu kuman mining na alig-u!” ");
INSERT INTO ksc_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Na namingsan wi nanudtuchuwan Jesus ta taku, ummoy na manchachakup à fukis ya uchumi takuy achi pu mantungpar ta lintog manchongor an siya. ");
INSERT INTO ksc_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Iningkaw akon uchumi Fariseo ya mangitudtuchu ta Lintog na Judio. Ad ngummayngayutngutcha, wi anancha, “Apay naragsak na annayay taku wi makafurfurun ta managfasur ya makaan akon chicha!” ");
INSERT INTO ksc_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Siyan nan-alig à Jesus an chicha, wi anana, ");
INSERT INTO ksc_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nu kaspangalikan awad osan chiayù singkasut na panniluna ad natarà na osa. Sinun oyyoona? Taynanan siyampuru ya siyam ta purag ad ummoyna inanap na sachi natarà ingkanà ochasana. ");
INSERT INTO ksc_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ad nu inchasana, fuuchona wi amod na lagsakna ");
INSERT INTO ksc_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ad ichatongna ta foroyna. Ad siyan ayakanan fufurunna ya chachar-agna aruson, wi anana, ‘Mallaragsaktau tan inchasà na natarà wi pannilù!’ ");
INSERT INTO ksc_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Amaschi kon maragsakan chachi iingkaw ad langit nu mamfafawin uray os-osàani managfasur, nu lagsakcha ta siyampuru ya siyam wi mamfaruy taku wi foon pu nù masapur mamfafawicha.” ");
INSERT INTO ksc_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Inturuy Jesus wi nan-alig, anana, “Ad nu kaspangalikan awad osà fufaì simpurun pilaknay parparata, ad natarà na osa, sinun oyyoona nù? Paskichanan silaw ad ammaana sagkitan na foroynà manganapana ingkanà ochasana. ");
INSERT INTO ksc_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ad nu inchasana, ayakanan fufurunna ya chachar-agna aruson, ad ananan chicha, ‘Mallaragsaktau tan annay inchasà na pilak-uy natarà!’ ");
INSERT INTO ksc_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Amaschi kon maragsakan chachi aangheles Apudyus nu mamfafawin uray os-osàani managfasur.” ");
INSERT INTO ksc_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Inturuy ako Jesus wi nan-alig, anana, “Na namingsan, iningkaw na larai wi chuwan anànay fabfafaru. ");
INSERT INTO ksc_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Na osay padcha, anan na uchichi an amana, ‘Ama, adchom na làsun-u ta sana.’ Siyan nan-agwaon na amachan ùuwanan chichay chuwa. ");
INSERT INTO ksc_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Naarkawanan ad, ingnginan chi uchichin làsunna ad lummayaw wi inawitnan pilakna, ad ummoy ta achayuy ili ad kinastuna losan na pilakna ta linuruku. ");
INSERT INTO ksc_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Naamin pun na losani awad an siya, niyaspur wi chinumtong na pakikad wi urat ta sachi ili, siyan nafitifitil à siya. ");
INSERT INTO ksc_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Siyan napilit wi ummoy nakarabfu ta osay mannarun ta sachi ili. Ad na iwaarna, mamapaan ta forò. ");
INSERT INTO ksc_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ad kapu ta fitilna, pionay anon uray na fungan na ayu wi aannon na forò nu mafalin, tan foon à paananchà siya. ");
INSERT INTO ksc_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Anungusna pun, chinumtong na ustuy somsomòna, ad anana, ‘Losan chachi mallabfuwon Ama, masawar na anoncha, ad annaà yakay wi tikangay matoy à fitil! ");
INSERT INTO ksc_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mangulinà an Ama ad ifakà an siya, Ama, nakafasurà an chiayun Apudyus. ");
INSERT INTO ksc_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Siyan uray nu maid karobfongà wi mifilang à anànu, mangaasia ta aranà à makarabrabfun sia.’ ");
INSERT INTO ksc_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Sachi ad lummigwat wi umoy an amana. “Na marungayana, intap na amanà siya, ad nakaasi wi nangilan siya. Siyan nanodchà wi ummoy nanib-at ad finàwarna ta lagsakna. ");
INSERT INTO ksc_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ad anan chi fafaru, ‘Ama, nakafasurà an chiayun Apudyus, siyan maid karobfongà wi mifilang à anànu.’ ");
INSERT INTO ksc_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ngim anan na amana ta sasanniluna, ‘Kanasonyu! Iyaliyun afaruwani luput ta isilupna. Ad mansapatusonyu kò siya, ya singsinganyu. ");
INSERT INTO ksc_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ya aranyu kon apunorani ayyufun na fakatau ad partiyonyù mallagragsakantau! ");
INSERT INTO ksc_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tan anà pun nu natoy na annay fafarù, ngim annay natattaku. Anà pun nu natarà, ngim annay nangulin.’ Sachi ad illukichay mallaragsak. ");
INSERT INTO ksc_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Napapannos pun, nangulin na panguruy anàna wi narpu ta pappayaw. Chanchani ad ta foroycha, chingngornan mangkankanta ya mantatachò. ");
INSERT INTO ksc_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Siyan inayakanan osay sanilu ad inimusna nu sinun oy-oyyooncha. ");
INSERT INTO ksc_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ad anan chi sanilu, ‘Nangulin na sunudnu, siyan impapartin amayun apunorani ayyufun na faka ta lagsakna ta nangulinan na sunudnu wi natattaku wi maid lawing à napasamak an siya.’ ");
INSERT INTO ksc_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ad ummog-ot chi panguru ad achi pu lumnò ta foroy. Siyan lummawan amana ummoy inàarù ta lumnò. ");
INSERT INTO ksc_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ngim sinongfatanà amana, ‘Ilam, nan-iwaarà à atawwotawwon, à isù sanilum, wi maid pu linabrabsing-ù imfakam, ad maid pu impapartim à uray osà karching à mallaragsakanni ta fufurun-u! ");
INSERT INTO ksc_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ngim na annayay narukuy anànu, lummayaw wi kinastuna losan na ùuwam ta puta. Ad siyan impartiyam à apunorani ayyufu.’ ");
INSERT INTO ksc_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","‘Anàu,’ anan na amana, ‘kanayun-a iingkaw an saon, siyan na losani awad na saon, uwam ako. ");
INSERT INTO ksc_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ngim na sana, masapur mallaragsaktau ta pailataun tottoròtau, tan anà pun nu natoy na sunudnu, ngim annay natattaku. Anà pun nu natarà, ngim annay nangulin.’” ");
INSERT INTO ksc_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Sachi ad asin nan-alig à Jesus ta disipulusna, wi anana, “Na namingsan, iningkaw na osay faknang wi nangipiyar ta losani ùuwana ta osay man-iwaarona. Ngim chinamag na sachi faknang wi kaskastuwonan sachi nipiyar an siya. ");
INSERT INTO ksc_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Siyan impaayagnà siya ad anana, ‘Sinu kon chongrò wi oy-oyyoom? Aminom ilistan losani iningwam mipangkop ta impiyar-un sia, tan iparyaw-u sia.’ ");
INSERT INTO ksc_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Siyan som-osom-on na sachi taku nu sinun ustù oyyoona. Ad anana ta somsomòna, ‘Sinun in-inò wi mafiyag, tan annay iparyawà ta apù, tan nakapsutà wi mantarun ya mafainà wi mampalimus. ");
INSERT INTO ksc_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Amasnan oyyoò, ta uray nu iparyawà ta man-iwaarà, mafalini mangiliyonà ta foforoy na uchum!’ ");
INSERT INTO ksc_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Sachi ad inayakana losan na nakautang an apuna ad sinin-ossana inimus anani, ‘Am-an na utangnu ta apù?’ ");
INSERT INTO ksc_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ad sinongfatan na osa, ‘Singkasut wi lata wi lana.’ Ad anan chi niparyaw, ‘Annayan listaan na utangnu. Siyan pilmaam ta obsontà limampuru kan utangnu.’ ");
INSERT INTO ksc_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ad inimusna ko ta osa, ‘Am-an akon utangnu ta apù?’ Ad sinongfatana, ‘Sillifuy kafan wi finayu.’ Ad anan chi niparyaw, ‘Annayan listaan na utangnu. Siyan pilmaam ta obsontà warungkasut yakan fayacham.’ ");
INSERT INTO ksc_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Napannos pun, illasin na apunan kinasikap na sachi niparyaw, ad chinayawnan kinaraingnay nangisakanà fumaruwanà tapin na padcha.” Ad anan ako Jesus, “Tuttuway chachi achi pu mamatin Apudyus, sillumaingcha mipangkop ta ifiyagcha ta sana nu chachi mamati.” ");
INSERT INTO ksc_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Inturuy Jesus wi mantudtuchun chicha, anana, “Na itudtuchù an chiayu, usaronyun kinafaknangyud asnay lutà mamfurfurunanyu, ta nu marpas na mausarana, iparnò chiayud langit wi mafiyakanyù ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Sinumani napiyar wi mangchon ta kàkàit wi nipiyar an siya, mapiyar ako wi mangchon ta chakor. Ad isuna kon sachi achi pu napiyar wi mangchon ta kàkàit wi nipiyar an siya, kapilitani achi pu ko mapiyar wi mangchon ta chakor. ");
INSERT INTO ksc_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Siyan nu achiayu pu mapiyar wi mangchon ta pilak ad asnay luta, sin-umisag wi achiayu pu mapiyar wi mangchon ta tuttuway kinafaknang ad langit. ");
INSERT INTO ksc_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Tan nu foon pù mapiyar-ayù mangchon ta ùuwan na uchum, achi pu maatod an chiayun ustuy man-uwayù tapin na padcha.” ");
INSERT INTO ksc_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Sachi ad asin nan-alig à Jesus wi anana, “Na sanilu, achi pu mafalin wi chuwan umapuwana tan kapilitani ay-ayatonan osa ya lawingonan osa. Ya kapilitani patkonan osa ad achina pun na osa. Isuna ko nu pilak na napatog an chiayu, achi pu mafalini patkam na pion Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Chingngor pun chachi Fariseo na sachi intudtuchun Jesus, inam-amangchà siya tan siya ay-ayatonchan pilak. ");
INSERT INTO ksc_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Siyan anan Jesus an chicha, “À chiayu, ipàpailayu kan kinafaruyu ta sangwanan na taku, ngim akammun Apudyus na tuttuway awad ta somsomòyu. Tan chiayuy taku, na patpatkonyu, kaisawchi an Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ad anan ako Jesus, “Na Lintog wi inyug-is Moses ya chachi profetas ta awi, sachin natungpar ingkana ta ummaliyan Juan wi Mamfufunyag. Sikud wi mifagfakan Mamfaruy Chamag mipangkop ta Manturayan Apudyus, ya achun mangipapilit wi mitapi. ");
INSERT INTO ksc_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ngim achiyu anani mab-os na uray akàitani lintog Apudyus, tan mallaslasun maumasan na annay luta ya langit nu maaanan uray na akàitani lintog Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ad anan ako Jesus, “Sinumani larai wi mangichang ta asawana ad nangasawà safali, makafasur, ad na larai wi mangasawa ta sachi fufai wi inichangana, makachagchakas ta sachi fufai.” ");
INSERT INTO ksc_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ad inturuy Jesus wi mantudtuchu, anana, “Na namingsan, iningkaw na osay larai wi isag faknang wi man-afafaru ya nanginginan silupna ya kanayun mamparagsak à chakor. ");
INSERT INTO ksc_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ad iningkaw akon osay kapus wi Lazaro na ngachanna wi nakakator na long-agna. À Lazaro, finikati nifafàsar ta sawang na sachi faknang, ");
INSERT INTO ksc_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ta uray nu fugtan na sachi faknang na anona nu awad machachà ta lamisaanna. Ad na asu, chilchilanchan kakatorna. ");
INSERT INTO ksc_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Na osay padcha, natoy na sachi kapus ad illayaw na aangheles à siya, ad ummoycha inchar-ag an Abraham à makaragsak ad langit. Na sachi ko, natoy akon sachi faknang ad illofoncha, ");
INSERT INTO ksc_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ad nipaoy ad Hades wi ingkawan na natoy wi maparpalikatan isag. “Ad nantangad na sachi faknang ad intapnà Abraham ta ad-adchayuwan ya Lazaro wi nicharchar-ag an siya. ");
INSERT INTO ksc_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ad nampoaw chi faknang wi anana, ‘Ama Abraham! Achakuwanà! Pailunongnun iman Lazaro ta chanum ad ifaunnù siya ta itodtodna ta chilà ta tumakaliyong, tan nalikatanà ta atung na annay apuy!’ ");
INSERT INTO ksc_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ngim anan Abraham, ‘Anàu, sosom-om na iningkawam ad luta. Naram-ay na imfibfiyagnu, ngim na fiyag Lazaro, kakkaasì siya. Ngim na sana, naragragsak à Lazaro ad asna. Ad à sia, maparpalikatan-a. ");
INSERT INTO ksc_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ad foon pu kà afuschi tan annat na lofongani kitang wi namorchà an chitau, siyan uray awad maryad umalid asnat, achi pu mafalin tan maid ayona. Ya isuna koy sinuy awad ad asnat, achi pu makachormang wi umalid asna.’ ");
INSERT INTO ksc_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Sachi ad anan chi faknang, ‘Nu amasnat, Apu, ipangpangngaasim ta ifaunnù Lazaro ta foroy Ama, ");
INSERT INTO ksc_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","tan awad na limay susunud-u, ta umoyna kuma warningan chicha ta faliwanchan oy-oyyooncha ta achicha kuma mipaali ta annay ikaw na amochi likat.’ ");
INSERT INTO ksc_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ngim anan Abraham, ‘Ngim awad an chichan sachi inyug-is Moses ya chachi profetas ta awi à mawarningancha kuma nu chongroncha.’ ");
INSERT INTO ksc_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","‘Oo, Apu,’ anan na sachi faknang, ‘ngim achicha pu patiyon! Ngim nu awad ummuli natakù natoy à umoy mangifakan chicha, sikurachuy man-awichanchan lawingi oy-oyyooncha.’ ");
INSERT INTO ksc_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ngim anan ako Abraham, ‘Nu achicha pu patiyon na inyug-ischa Moses ya chachi profetas, uray nu awad umuli mataku achi pu maawis na somsomòcha.’” ");
INSERT INTO ksc_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Sachi ad anan Jesus ta chachi disipulusna, “Tuttuway sikud wi maawis na takù man-awichanchan Apudyus. Ngim sinkumaasin takuy mangwà makafasuran na uchum, ");
INSERT INTO ksc_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","tan kattoi amod na machusaanà tapin na padcha, tan un-unnoy na matàchan na fakangnà chakoran à fatu ta sana ad nitub-ung ta fayfay. ");
INSERT INTO ksc_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Siyan an-annachanyun oyyoonyu! “Nu awad makafasur an sia, omoram, ad nu fafawiyona, pakawanom. ");
INSERT INTO ksc_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ya uray mangampitun makafasuranan sia ta osay padcha, ya mangampitu ko umali mampapakawan, masapur pakawanonyu.” ");
INSERT INTO ksc_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Sachi ad anan chachi apostoles an Apu Jesus, “Papigsaom kuman pammatini.” ");
INSERT INTO ksc_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ad anan Apu Jesus, “Nu awad pammatiyù uray isun na akàit na akàitani fuor wi mustard, mafalini ananyu ta annayay ayu, ‘Mafakut-a ad nimuraa ta fayfay!’ ad tuttuway màwa.” ");
INSERT INTO ksc_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Inturuy Jesus wi man-ukud, anana, “Nu kaspangalikan awad osan chiayù awad sanilunà mancharnò winnu man-ayyuwan ta pannilu. Ad nu tummàchang ta foroynu wi narpu ta payaw, foon pù siya ifakam an siya, ‘Kanasom ta mangan-a!’ ");
INSERT INTO ksc_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Sikurachuy foon à amaschin ifakam, tan siya ifakam an siya, ‘Sukatam na silupnù mamfaru ad insakanam na anò umuna achiawot mipasali.’ ");
INSERT INTO ksc_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ad achi pu ko manyaman na nginsanilu ta namtokan na sanilu ta losani pàwana. ");
INSERT INTO ksc_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ad isuna kon chiayu nu pintogyu losan na imfakan Apudyus, achiyu anani machayaw-ayu tan siya ingwayu kan fiyangyu.” ");
INSERT INTO ksc_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Inturuycha Jesus wi umoy ad Jerusalem, ad nangoycha ta namforaatan Samaria ya Galilea. ");
INSERT INTO ksc_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ad na linumnoancha ta osay ili, sinib-atchan simpuruy lallarai wi losancha nafuratung. Ad niyadchayangchay ummagsad ");
INSERT INTO ksc_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","wi nampoaw an Jesus anani, “Apu Jesus! Achakuwan chiani!” ");
INSERT INTO ksc_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Innilan pu Jesus chicha, anana, “Ing-ayu pailan long-agyu ta papachi à manuttuwaancha wi naaan na sakityu.” Ad na manadcharanchay umoy, naaan na sakitcha. ");
INSERT INTO ksc_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ad na nangil-an na osa wi naaan na sakitna, napanagkulin an Jesus wi inip-ip-awnan chayawnan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ad nampalintumong à siya ta sangwanan Jesus wi manyaman an siya. Na sachi larai, foon pù Judio tan kaili wi iSamaria. ");
INSERT INTO ksc_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Sachi ad anan Jesus, “Simpuruchay ummimfag. Ad ummayan na siyam? ");
INSERT INTO ksc_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tamako ta osa kan annay larai, wi foon pù Judio, afus yakà namagkulin nanyaman an Apudyus?” ");
INSERT INTO ksc_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Sachi ad anan Jesus an siya, “Lumigwat-a ta ing-a lumayaw. Kapu ta pammatim, naaan na sakitnu.” ");
INSERT INTO ksc_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Sachi ad inimus na uchumi Fariseo an Jesus, “Maanun mallukiyan na Manturayan Apudyus?” Ad sinongfatan Jesus anani, “Maid ustù mail-an na mallukiyan na Manturayana. ");
INSERT INTO ksc_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ya maid pu ko mangwanani, ‘Ilanyu, tan annayan Manturayan Apudyus!’ winnu, ‘Anchiya!’ Tan na Manturayan Apudyus, awad an chiayu ngim foon à maila tan somsomò yakan iturayana.” ");
INSERT INTO ksc_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sachi ad anana ta disipulusna, “Chumatong na timpuy pipionyuy mangila kuma ta mangulinà, saon wi namfalin taku, ngim achiyu pu mailan sachi timpu. ");
INSERT INTO ksc_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Siyan nu awad takù mangwanani, ‘Ing-ayuschi, tan anchiya!’ winnu, ‘Umaliayusna, tan annaya!’ achiyu umoy ilan. ");
INSERT INTO ksc_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tan saoni namfalin taku, na umaliyà, isun na sumlitan na ilat wi maid achi mangila tan linangana losan na luta. ");
INSERT INTO ksc_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ngim masapur maparpalikatanà yan ta taku ta annay sillumunap wi achiyà pu ifilang an chicha. ");
INSERT INTO ksc_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Na oyyoon na taku ta mangulinà ad asnay luta, isun na nàwa ta timpun Noe. ");
INSERT INTO ksc_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tan na timpun Noe, nanganangancha ya umminuinumcha ya nan-as-asawacha ingkana ta sachi linumnoancha Noe ta papur. Ad nammaag nalitap ad asnay luta ad naamincha naanud. ");
INSERT INTO ksc_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ad isun akon nàwa ta timpun Lot. Na taku ta sachi, asiooancha ya asiiinumcha ya asilarakucha, ya asimumuracha ko ya asikakaobchà foroy. ");
INSERT INTO ksc_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ngim na padchay lummayawancha Lot ta ilichay Sodoma, anan pun na taku nu maid mapasamak, ngim naodchag na apuy ya asupli wi narpud langit, ad naamin naskob na asinchuwan, uray taku. ");
INSERT INTO ksc_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ad na mipangkop an saoni namfalin taku, amaschi kon màwa wi anan pun na taku nu maid mapasamak ad nangulinà! ");
INSERT INTO ksc_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Na sachi padcha, na takuy niyaspur wi awad ta otop na foroyna, achi pu kuma umoy lumnò mangarà sinuman ta ùuwana, ngim ichakusna umawid. Ad isun akon takuy niyaspur nasiput, achi pu kuma mangulin umoy ta foroyna. ");
INSERT INTO ksc_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Sosom-onyun nàwa ta asawan Lot! ");
INSERT INTO ksc_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Na takuy siya som-osom-onan mafiyakana ta annay luta, matoy ako kay. Ngim na takuy mamtog an saon uray sachin iyatoyna, maatod an siyan mannaynayuni fiyag an Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ad anan ako Jesus, “Ifakà akon chiayu, nu lafin mangulinà ya awad nanchar-ag nasuyop, maaran osa ya mataynan na osa. ");
INSERT INTO ksc_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ad nu awad chuwà fufaì mamfayu, maaran osa ya mataynan akon osa. ");
INSERT INTO ksc_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ad nu awad chuwà laraì nasiput, maaran osa ya mataynan akon osa.” ");
INSERT INTO ksc_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Sachi ad inimus na disipulusna, “Sinun màwaanninat, Apu?” Ad anan Jesus wi nan-alig, “Sinumani ikaw na natoy, sachin maarusan na sissiwit wi mangan ta lachag.” ");
INSERT INTO ksc_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Sachi ad nan-alig à Jesus ta chachi disipulusnà natudtuchuwancha, ta kanayuncha kuma malluwaru ya achicha pu machischismaya. ");
INSERT INTO ksc_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Anana, “Na namingsan, iningkaw na kuis ta osay ili wi maid ogyatnan Apudyus ya maid pu ko fainna ta asintatakuna. ");
INSERT INTO ksc_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ad na sachi koy ili, iningkaw na osay nafaru wi umoumoy ta kuis mampafachang wi anana, ‘Fadnganà, ta achiyà afakon ta asangù!’ ");
INSERT INTO ksc_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ad nafayag wi achin pun na kuis atinguron à siya. Ngim na anungusna, nas-à na kuis siyan anana ta somsomòna, ‘Uray maid ogyat-un Apudyus ya maid fain-u ta taku, ");
INSERT INTO ksc_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","fadngà na annay nafaru ta maid tumaktak ya maid angongonot à umaliali!’” ");
INSERT INTO ksc_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ad anan ako Jesus, “Somsom-onyun iningwan na kuis, uray nu lawingi taku. ");
INSERT INTO ksc_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","À Apudyus wi afaruwan, sin-umisag na oyyoonay sumufalit ta chachi mantakuna nu padchaoncha ya lafiyoncha wi manchawat an siya. ");
INSERT INTO ksc_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ifakà an chiayu wi chisanona fadngan chicha. Ngim à saoni namfalin taku, nu mangulinà, awad ochasà à namatin saon?” ");
INSERT INTO ksc_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Sachi ad asin nan-alig à Jesus ta takuy nanapnok ta kinafarucha ya man-iyaamisnan uchumi taku. ");
INSERT INTO ksc_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Anana, “Na namingsan, iningkaw na chuway larai wi ummoy ta Templo malluwaru. Fariseo na osa, ad na osa, osay manchachakup à fukis. ");
INSERT INTO ksc_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Na charom na Templo, ummagsad chi Fariseo wi naos-osa wi malluwaru, wi anana, ‘Apudyus, manyamanà an sia tan foon pù isù na uchumi taku, wi losancha mangkamkam ta sinuman ya narukucha ya mamufaicha. Ya manyamanà ako tan foon pù isù na annay manchachakup à fukis. ");
INSERT INTO ksc_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Tan saon, mamigwaà mallangan wi mangan ta chinumingku, ya adchò an sian pagkapurun na losani awad an saon.’ ");
INSERT INTO ksc_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ngim na sachi manchachakup à fukis, ummadchayang wi ummaagsad, ad achi pu mantangad ad langit tan mafain, ad tugtugtukonan far-uungnà mamfafawiyana ta fasurna. Ad anana, ‘Apudyus, achakuwanà kuma tan managfasurà!’ ");
INSERT INTO ksc_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ad na ifakà an chiayu, siya mamfaruwon Apudyus na manchachakup à fukis, wi foon pù sachi Fariseo. Tan sinumani mangipangatu ta long-agna, fumafa. Ngim sinumani mangipafafa ta long-agna, ngumatu.” ");
INSERT INTO ksc_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Sachi ad iningkaw na uchumi nangiyoy ta an-ananàchan Jesus ta agpachana kuma wi maminchisyun. Ngim na nangil-an chachi disipulusna, ingkimaucha chicha. ");
INSERT INTO ksc_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ngim impaiyachanin Jesus na an-ananà, ad anana ta chachi fufurunna, “Masapur iparufusyun umaliyan na an-ananà an saon, ya achiyu ipalit, tan piyaronchà saon, ad isun an chicha na afusi mitapi ta Manturayan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tuttuwan ifakà an chiayu, wi sinumani achi pu mangipafafa ta long-agna ta mamatiyanan Apudyus, à isun na afafan na anchanayay an-ananà, achi pu mafalin wi mitapi ta Manturayan Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ad iningkaw na osay pangpangun na Judio wi nangimus an Jesus, anana, “Siay mamfaruy Misturu, sinun oyyoò ta makafiyakà à mannaynayun an Apudyus?” ");
INSERT INTO ksc_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ad inimus Jesus, “Tam-ako anani mamfaruwà? Maid uchum à mamfaru nu achi afus à Apudyus. ");
INSERT INTO ksc_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Akammum na filin Apudyus: ‘Achia mamufai, Achia pumatoy à taku, Achia man-akaw, Achim istikuwan na foon à tuttuwa, ya Masapur lispituwom na amam ya inam.’” ");
INSERT INTO ksc_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ad summongfat na larai wi anana, “Tinungpar-u losan nanipud ta afan-og-u.” ");
INSERT INTO ksc_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ad chingngor pun Jesus na sachi, anana, “Os-osàan yakan kurangnu wi masapur oyyoom. Inginam na losani ùuwam ad inwarasnun nginana ta kakapus ta langit na maugpunan na kinafaknangyu. Ad umalia mitun-ud an saon.” ");
INSERT INTO ksc_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ngim na nangngorana ta sachi, summauy tan amod na faknangna. ");
INSERT INTO ksc_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Na nangil-an Jesus ta summauyana, anana, “Isag nalikat na mitapiyan na fafaknang ta Manturayan Apudyus! ");
INSERT INTO ksc_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tan mallanlanuy na lumnoan na kamar ta afut na tanud nu mitapiyan na faknang ta Manturayan Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Sachi ad anan chachi nangngor, “Ad sinu nù na mafalini masaraknifan?” ");
INSERT INTO ksc_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ad anan Jesus, “Na achi pu mafalini oyyoon na taku, mafalini oyyoon Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ad anan ako Pedro an siya, “Chiani ngay, tinaynannin losani ùuwanì sumurutannin sia.” ");
INSERT INTO ksc_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ad anan Jesus, “Tuttuwan ifakà an chiayu, wi nu sinun nanaynan ta foroyna, winnu asawana, winnu susunudna, winnu chachakkorna winnu an-ananànà mangiwarawakana mipangkop ta Manturayan Apudyus, ");
INSERT INTO ksc_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ad-achun maatod an siya ta annay atattakuna nu sachi tinaynana. Ad makafiyag akon Apudyus à ing-ingkana.” ");
INSERT INTO ksc_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Sachi ad intalin Jesus na disipulusnay nasawaran à chuwa, ad ananan chicha, “Chongronyuna! Anna puni intaud Jerusalem, sachin màwaan na losani inyug-is na profetas ta awi mipangkop an saoni namfalin taku. ");
INSERT INTO ksc_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tan mipurangà ta chachi foon pù Judio, ad am-amangonà ya insurtuwonà ya tubfaanà an chicha. ");
INSERT INTO ksc_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ya abchoyonà ad patoyonà akon chicha. Ngim na miyatluy padcha, umuliyà mataku.” ");
INSERT INTO ksc_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ngim chachi disipulusna, achicha pu maawatan na inukudna, tan isù naunog na pionay ifaka, siyan achi pu lumnò ta somsomòcha. ");
INSERT INTO ksc_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Sachi ad wi chanchanicha Jesus ad Jerico, iningkaw na osay nakurap wi ummaachuy ta ikid na arsa wi mamparpalimus ta losani lumaus. ");
INSERT INTO ksc_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ad na nangngorana ta lumausan na ad-adchuwani taku, inimusna, “Sinu kon sanat?” ");
INSERT INTO ksc_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“Lumaus à Jesus wi iNazaret,” anancha. ");
INSERT INTO ksc_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ad inip-awna anani, “Jesus! Siay kanà David! Kaasiyanà!” ");
INSERT INTO ksc_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ad chachi taku wi mamangpangu, inomoranchà siya ta kuminò, ngim inam-amodna impauy anani, “Siay kanà David, kaasiyanà!” ");
INSERT INTO ksc_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Sachi ad ummillong à Jesus ad impaayagnan sachi nakurap. Ummachani pun, inimus Jesus an siya, ");
INSERT INTO ksc_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Sinun piom à oyyoò an sia?” “Apu,” anana, “piò wi makaila.” ");
INSERT INTO ksc_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ad anan Jesus an siya, “Siyan makailaa! Tan kapu ta annay pammatim an saon naaan na kurapnu.” ");
INSERT INTO ksc_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ad chakusi naaan na kurapna, ad nitun-ud an Jesus wi manaychayaw an Apudyus. Ad losan chachi taku, chinayawcha kò Apudyus ta nangil-ancha ta sachi nàwa. ");
INSERT INTO ksc_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Sachi ad nangoy à Jesus ad Jerico. ");
INSERT INTO ksc_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ad iningkaw ta sachin osay faknang wi larai wi Zakeo na ngachanna, wi osay ap-apun chachi manchachakup à fukis. ");
INSERT INTO ksc_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ad pionay ilan à Jesus ta akammuwona nu sinù siya, ngim achi pu makaila kapu ta aachun na taku ya ab-afobfà siya. ");
INSERT INTO ksc_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Siyan nanodchà ad ummarab ta osay ayu ta pakailanà Jesus nu lumaus. ");
INSERT INTO ksc_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nichaum ad à Jesus ta sachi ayu, nantangad ad anana, “Zakeo, kanasomi lumogsad, tan masapur mangiliyonà an sia.” ");
INSERT INTO ksc_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ad kinankanas Zakeo wi lummogsad, ad amod na lagsaknay mammangilin Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ngim losan chachi nangiila, ngummayngayutngutcha wi anancha, “Apay mampamangilin sanat ta osay managfasur?” ");
INSERT INTO ksc_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ad anan Zakeo an Jesus ta sangwanan na losan, “Apu! Adchò na kogwan na fanyakà ta kakapus, ad sinumani kinuruk-u, mangampatò fayachan an siya.” ");
INSERT INTO ksc_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ad anan Jesus an siya, “Sanan padchay nanaraknifan Apudyus an chiayuy simfaryan, ad sia kon ustuy kanà Abraham. ");
INSERT INTO ksc_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tan à saoni namfalin taku, ummaliyà ad asnay luta ta anapò na managfasur ta saraknifà chicha ta achicha pu mifallud infierno.” ");
INSERT INTO ksc_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Na nangngoran na taku ta imfakan Jesus, chanchanichad Jerusalem, ad anancha pun nu ngannganin milukiyan na Manturayan Apudyus. Siyan nan-alig à Jesus, ");
INSERT INTO ksc_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","wi anana, “Na namingsan, iningkaw na osay pangat wi ummoynan kinaalina aran ta achayuy ili. Ad nu mangulin, ilukinay manturay. ");
INSERT INTO ksc_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Na chaanna pun lumigwatan, inayakanan sasannilunay simpuru ad impiyarna impad-on an chichan sin-ossay falituk wi pilak, ad anana, ‘Paachuwonyuna ingkanà mangulinà.’ ");
INSERT INTO ksc_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ngim na kailiyana, lawingonchà siya, siyan impaun-unudchan uchum à umoy mangifaka wi, ‘Lawingonnì siyà man-alini.’ ");
INSERT INTO ksc_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ngim innaran chi pangat na kinaalina, ad nangulin, ad impaayagna chachi sasanniluna wi nangipiyarana ta pilak ta akammuwona nu sinun iningwacha. ");
INSERT INTO ksc_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ad nisangun osa wi anana, ‘Apu, simpurun kanar-u ta falituknu.’ ");
INSERT INTO ksc_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ad anan chi Ali, ‘Kattoi mamfaruà sanilu. Siyan kapu ta ustun iningwam wi nangchon ta uray ait, ipaituray-un sian simpuruy ili.’ ");
INSERT INTO ksc_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Sachi ad nisangu kon miyagwa, wi anana, ‘Apu, liman kanar-u ta falituknu.’ ");
INSERT INTO ksc_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ad anan chi Ali an siya, ‘Ipaituray-un sian limay ili.’ ");
INSERT INTO ksc_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Sachi ad nisangu kon osa, wi anana, ‘Apu, annayan falituknu. Finussung-ù pangyu intarpon ");
INSERT INTO ksc_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","tan ummogyatà an sia, tan akammù wi istriktua, wi man-uwam na liningtanan na uchum wi isù apitom na foon pù immuram.’ ");
INSERT INTO ksc_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Sachi ad anan chi Ali, ‘Lawing-à sanilu! Na sanati ug-ugkudnu, siyan mangipaila ta fumasuram, tan nu inakammum wi istriktuwà, wi man-uwaà na liningtanan na uchum, wi isù apitò na foon pù immurà, ");
INSERT INTO ksc_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","apay achim pu impaangkat ta awad kuma ait à paanànà arà ta annay nangulinà?’ ");
INSERT INTO ksc_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Sachi ad anana ta chachi ummaagsad ta sachi, ‘Aranyun pilakna ad inadchonyu ta sachi mangchon ta simpuru.’ ");
INSERT INTO ksc_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","‘Oo, Apu,’ anancha, ‘ngim awad met na simpuru an siya!’ ");
INSERT INTO ksc_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Siyan anana, ‘Oo, ngim ifakà an chiayu, wi na mapipiyyar wi taku, machogchog-an na maatod an siya. Ngim na takuy foon à mapipiyyar, maaan na uray aiti awad an siya.’ ");
INSERT INTO ksc_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ad anana ko, ‘Ad chachi afusur-u wi mallawing an saon à man-alicha, iyaliyusna ad patoyonyu ta sangwanan-u!’” ");
INSERT INTO ksc_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Narpas pun na alig Jesus, inturuyna wi umoy ad Jerusalem. ");
INSERT INTO ksc_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ad chanchanicha pun, chin-umanchan filig wi Olivo, wi achanid Betfage ya Betania wi ili. Ad impaunan Jesus na chuway disipulusna, ");
INSERT INTO ksc_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","wi anana, “Umunaayu umoy ta anchi ili ta chomang, ad na lumnoanyu ta ili, ochasanyun nipupungod wi ayyufun na afayu wi chaan pù maafayuwan. Obfachonyu ad inyaliyusna. ");
INSERT INTO ksc_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ad nu awad mangwanani tayukonnat obfachon, ifakayu wi masapur na Apuyu.” ");
INSERT INTO ksc_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ad ummoycha, ad inchasanchan losani imfakan Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ad na nangobfachancha ta ayyufu, anan na ngin-uwa, “Tayukonnat obfachon?” ");
INSERT INTO ksc_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ad anancha, “Masapur na Aputau.” ");
INSERT INTO ksc_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ad inchatongchan Jesus, ad inyap-apchan kunsurcha ta ochog na ayyufu ad nangafayuwonchà Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ad na nangafayuwan Jesus, inyap-ap akon takun silupcha ta arsa wi ayona. ");
INSERT INTO ksc_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Na nan-oskancha ta sachi filig wi Olivo, wi ngannganicha chumatong ad Jerusalem, illukin losan na chachi ad-adchuwan wi summurut an Jesus wi manyaman an Apudyus, ya inip-ip-awchan chaychayawchan siya kapu ta losani kaskaschaaw wi innilacha wi iningwan Jesus. Anancha, ");
INSERT INTO ksc_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Chayawontaun annay Alitau wi narpun Apudyus! Tan mipakapun siya, makatimpuyugtaun Apudyus ad langit, siyan chayawontaù Apudyus!” ");
INSERT INTO ksc_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Sachi ad kummingan uchumi Fariseo wi niyas-aslang ta kimung, ad ananchan Jesus, “Apu, pakin-om na anchanayay disipulusnu!” ");
INSERT INTO ksc_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ad sinongfatan Jesus chicha, “Na ifakà an chiayu, nu mipakinòchay manayaw an saon, uray na anchanayay fatu mapilitchay mampauy wi manaychayaw an saon!” ");
INSERT INTO ksc_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Na ummachaniyan Jesus ad Jerusalem, intapnan ili ad inifilanan taku ta sachi ili, ");
INSERT INTO ksc_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","wi anana, “Chiayuy iJerusalem, maawatanyu kuma ta sanay padcha na kasapuranyù makatimpuyukanyun Apudyus! Ngim chaanyu pu akammuwon, ad nilaus! ");
INSERT INTO ksc_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Chumtong na timpuy lìwoson chiayu ta afusuryu. Isotoncha urumon chiayu ad maid in-inonyu wi umawid. ");
INSERT INTO ksc_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ad aminoncha yam-anon na annay iliyu ya losan akoy taku wi ingkaw. Aminoncha iwalis na fatu ta maid pu mataynan ta tuping. Sachin màwan chiayu tan achiyu pu pakan-anun ummaliyan Apudyus wi mamachang an chiayu!” ");
INSERT INTO ksc_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Sachi ad ummoy à Jesus ta Templo, ad imparyawnan mallakraku wi iningkaw. ");
INSERT INTO ksc_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ad ananan chicha, “Niyug-is na ukud Apudyus wi, ‘Na Templò, mausar à luruwwaruwan,’ ngim annay namfalinonyù mallukuwanyu ta asintatakuyu!” ");
INSERT INTO ksc_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ad finikati umoumoy à Jesus ta Templo mantudtuchu. Ad chachi pangpangun na papachi ya mangitudtuchu ta Lintog, ya chachi namangpanguwon na taku, losancha anaanapon na mangtoyanchan siya. ");
INSERT INTO ksc_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ngim maid pu in-inoncha tan losan na taku isag pipion wi mamangngor ta itudtuchuna. ");
INSERT INTO ksc_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Na osay padchay mantudtuchuwan Jesus ta taku ta Templo, wi mangipagngor ta Mamfaruy Chamag mipangkop an Apudyus, ummoy akon siyan chachi pangpangun na papachi ya mangitudtuchu ta Lintog, ya chachi namangpanguwon na Judio, ");
INSERT INTO ksc_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ad anancha, “Ifakam an chiani nu sinun karobfongam wi mangwa ta amaschi. Sinun nangatod ta karobfongam wi mangwaschi?” ");
INSERT INTO ksc_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ad sinongfatan Jesus chicha anani, “Awad yan na imusò an chiayu. Songfatanyuna. ");
INSERT INTO ksc_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Sinun narpuwan na karobfongan Juan wi mamfunyag? Narpun Apudyus winnu taku?” ");
INSERT INTO ksc_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Sachi ad nan-uukudcha wi anancha, “Sinun ifakatau? Nu anantauy ‘Narpun Apudyus,’ anana kon chitauy ‘Tayukon nù achi pinatì Juan?’ ");
INSERT INTO ksc_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ngim nu anantauy ‘Narpu ta taku,’ fintukon chitau ta anchanayay taku, tan patiyoncha losan wi profetà Juan.” ");
INSERT INTO ksc_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Siyan ananchay summongfat, “Taw-an! Maid akammuni nu sinun narpuwan na karobfongana.” ");
INSERT INTO ksc_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ad anan ako Jesus an chicha, “Siyan nu amasnat, achì pu ko ifakan chiayu nu sinun narpuwan na karobfongà wi mangwa ta oy-oyyoò.” ");
INSERT INTO ksc_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Sachi ad nan-alig à Jesus ta chachi taku, wi anana, “Iningkaw na osay taku wi nammura ta lutanà grapes. Sachi ad, impàwanà fuwa ta safali wi taku ad lummayaw wi ummoy namfiyasi. ");
INSERT INTO ksc_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Timpun ad na inyàapit, imfaunnan saniluna wi umoy makafuwa. Ngim chachi man-afang ta lutana, inabchoychà siya ad imparyawcha wi maid pu inadchoncha. ");
INSERT INTO ksc_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Sachi ad asinna ko imfaun na osay saniluna, ngim sin-umisag na iningwachan siya nu sachi ummuna, tan inabchoychà siya ad iningwachà afàfàinan ad imparyawcha wi maid pu ko inadchoncha. ");
INSERT INTO ksc_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ngim uray amaschin nàwa, asin ako namfaun chi nginluta. Ngim finaagchà siya ad imparyawcha. ");
INSERT INTO ksc_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Sachi ad anan chi nginluta, ‘Sinu kon in-inò? Ifaun-un annay anàu wi ay-ayatò tan singnanchà siya!’ ");
INSERT INTO ksc_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ngim intap pun chachi nangwà fuwa na anàna, nan-uupngacha anani, ‘Anchiyan anànay mangilàsun ta annay luta. Siyan patoyontau ta man-uwataun làsunna!’ ");
INSERT INTO ksc_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ad inyoycha ta lasin na arad ad pinatoycha. “Siyan sinun oyyoon chi nginluta an chicha? ");
INSERT INTO ksc_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Sikurachuy umoyna patoyon chicha, ad ipàwanà fuwa ta uchum.” Chingngor pun na takun sachi, anancha, “Sapay kuma ta achi pu màwan amaschi!” ");
INSERT INTO ksc_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ad intotollong Jesus chicha, wi anana, “Nu achi pu màwachi, sinun somsom-onyù miturungan na sachi niyug-is wi anana, ‘Na fatuy inchulin na mangkakaob, wi ananchay maid silfina, sachin nàwà apatkan wi mipon-ad.’ ");
INSERT INTO ksc_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Sinumani taku wi maodchag ta sachi fatu, mapmaptod. Ad nu awad maodchakan ta sachi fatu, matampù wi isù chapur.” ");
INSERT INTO ksc_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Chachi mangitudtuchu ta Lintog ya pangpangun na papachi, pionchay maniliw an Jesus ta sachi, tan naawatancha wi chichan inyaligna. Ngim achicha pun tan ummogyatcha ta chachi takuy ad-adchuwan. ");
INSERT INTO ksc_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Sachi ad inanapchan mawayaancha wi manikap an Jesus. Siyan pinasuksukanchan uchumi taku ta ituttuwachay mansarudsud, tan na pioncha, masaw-à kumà Jesus ta ukudna ta awad mangicharumancha ta fifinnachur. ");
INSERT INTO ksc_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Siyan ummoycha an Jesus ad anancha, “Misturu, akammuni wi ustun itudtuchum ya uray na losani ug-ugkuchom. Ya akammuni ko wi maid pu laksikom à taku uray sinun kasasaadcha, tan itudtuchum afus yakan katuttuwaan wi pion Apudyus an chitau. ");
INSERT INTO ksc_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Siyan annan imusonnin sia. Surngasingontaun Lintogtauy Judio nu mamfayadtaù fukis ta Ali ad Roma winnu foon?” ");
INSERT INTO ksc_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ngim illasin Jesus na silibcha, ad ananan chicha, ");
INSERT INTO ksc_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Umipailaayù osà parata. Ad sinun nginfosar ya nginngachan ta annay niyug-is?” Ad anancha, “Ali Cesar.” ");
INSERT INTO ksc_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ad anan Jesus an chicha, “Siyan nu amasnat, adchonyun Cesar na uwana. Ngim ilanyu ko ta adchonyun Apudyus losan na para an siya.” ");
INSERT INTO ksc_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Siyan achicha pu makasilifan an siya ta man-uukudna ta sangwanan na taku. Ad nataagcha ko wi mangngor ta songfatna, siyan kumminòcha. ");
INSERT INTO ksc_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ummoy na uchumi Saduceo an Jesus, wi chichan foon pù mamati wi umuli matakun natoy. Ad ananchan siya, ");
INSERT INTO ksc_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Misturu, inyug-is Moses wi nu nangasawan osay larai ad natoyi maid anàna, masapur asaw-on na sunudnan nafaru ta umanàcha kumà mifilang à anà na sachi natoyi sunudna. ");
INSERT INTO ksc_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nu kaspangalikan awad pitù lallaraì mansusunud, ad nangasawan panguru, ad natoyi maid anàcha. ");
INSERT INTO ksc_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Siyan inasawan miyagwa na nafaru, ngim amaschi kon napasamak an siya. ");
INSERT INTO ksc_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ya isun akon napasamak ta miyatlu ingkanà losan chachi pitu, natoycha losan wi maid pu anàcha. ");
INSERT INTO ksc_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ad na anungusna natoy akon fufai. ");
INSERT INTO ksc_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Siyan nu umuli matakun natoy, sinun ustuy ngin-asawa ta fufai nù? Tan losanchay pitu inasawà siya.” ");
INSERT INTO ksc_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ad anan Jesus an chicha, “Na taku ta annay luta ta sana, man-as-asawacha. ");
INSERT INTO ksc_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ngim na takuy mifilang à annan karobfonganchay umuli mataku, wi umoy ad langit, maid man-as-asawa, ");
INSERT INTO ksc_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","tan mamfalincha isù aangheles wi achi pu matoy à ing-ingkana. Siyan chichan anà Apudyus tan ummuliyona chicha tinaku. ");
INSERT INTO ksc_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ad na mipangkop ako ta umuliyan na taku matakuwan, awad na inyug-is Moses wi nifakan siya ta nangil-ana ta kummilafan na imong, ad siyan tumuttuwaan na umuliyan na taku matakuwan. Tan na nifakan siya, À Apudyus, siyan chaychayawoncha Abraham, Isaac ya Jacob à Apudyuscha. ");
INSERT INTO ksc_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ad sachin manuttuwaana wi asififiyagchad langit wi manaychayaw an Apudyus. Tan nu natoycha kay ad sachi, in-inoncha nù wi manayaw an Apudyus?” ");
INSERT INTO ksc_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Sachi ad anan na uchumi mangitudtuchu ta Lintog, “Apu, mamfarun songfatnu!” ");
INSERT INTO ksc_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Amaschin anancha tan maid turodchay asin man-im-imus an siya. ");
INSERT INTO ksc_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Sachi ad inimus Jesus ta chachi taku, “Tachako anani na Cristu wi ipaalin Apudyus wi manturay, kanà David à siya? ");
INSERT INTO ksc_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tan à David, inyug-isna ta sachi nibrunay Salmo wi, ‘À Apudyus wi Apu, anana ta Apù: Tumùchua ta apot ta chiwawan-u ");
INSERT INTO ksc_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ingkanà ipaafak-un losani afusurnu.’ ");
INSERT INTO ksc_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Siyan nu awakan David à Cristù Apuna, in-inon David wi nginkanà an Cristu?” ");
INSERT INTO ksc_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Na mangngoran chachi taku ta intudtuchun Jesus, anana ta disipulusna, ");
INSERT INTO ksc_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Annachanyun chachi mangitudtuchu ta Lintog. Tan à chicha, pipionchay ikagkagkaay na silupchay lagkoyloy, ya pipioncha koy malispitu ta taku ta aallusancha. Ya pipioncha koy chichan umachuy ta afaruwani aachuyan ta sinagoga ya chichan machayaw ta sinuy lagsak. ");
INSERT INTO ksc_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ad siksikkapanchan anchanay nafaru à mangar-ancha ta ùuwacha, ad malluwaruchà anchuanchù manab-uncha ta oy-oyyooncha! Siyan kapu ta sachi, maam-amod na machusaancha!” ");
INSERT INTO ksc_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Sachi ad nallangrangà Jesus, ad innilana chachi nan-afaknang wi nangigkà pilak ta iigkaan à pilak ta Templo. ");
INSERT INTO ksc_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ad innilana kon osay nafaru wi kapus, wi chuwa kay siping na inigkana. ");
INSERT INTO ksc_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Sachi ad anan Jesus, “Tuttuwan ifakà an chiayu, wi ifilang Apudyus à chakchakor na inigkan na sachi nafaruy kapus nu losan wi inigkan chachi uchum. ");
INSERT INTO ksc_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tan chachi uchum, siya kay innadchonchan ait ta sawaroncha, ngim à siya, uray kapus innadchona losan na iningkaw an siya wi usarona kumà iyatakuna.” ");
INSERT INTO ksc_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Na uchumi disipulus Jesus, ug-ugkuchonchan mipangkop ta kinafarun na Templo, tan man-afaru na fatu wi nausar ta nàwaana, ya afaruwan na losani michatun an Apudyus ta sachi. Siyan anan Jesus, ");
INSERT INTO ksc_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Losan na mailayu, chumatong na padchay maamin mikur-ub, siyan maid pu mataynan à uray osa ta sikud wi ikawna.” ");
INSERT INTO ksc_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Sachi ad inimus na disipulusna, “Misturu, maanun màwaan na sachi imfakam? Ad sinu kon mangakammuwanni wi nganngani màwa?” ");
INSERT INTO ksc_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ad anan Jesus, “Man-annad-ayu kuma ta achiayu pu maallilaw ta uchum, tan lumoswan ad-adchuwani takuy mangwanani chicha nù Cristu! Ad anancha ko, ‘Sanan ustuy timpuna!’ Ngim achiyu suruton chicha. ");
INSERT INTO ksc_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ad nu chamakonyun kukufat ya kuru, achiayu umogyat, tan masapur umunay màwan amaschi, ngim foon pù sachin anungus wi padcha.” ");
INSERT INTO ksc_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ad inturuyna anani, “Man-asikinnufat na losani turay ta annay lufung. Ad mangkukufat akon sin-umili. ");
INSERT INTO ksc_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ad manita ko ya maingki ya mapistin ailiili. Ad awad akon mipailad langit wi kaog-ogyati singyar wi nakaskaschaaw. ");
INSERT INTO ksc_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ngim na chaampunan na amaschi màwaan, tiliwon chiayu ya palikatan chiayu. Ad masumaryaayu ko ta sinagogan na Judio ad imfarud chiayu. Ad kapu ta pammatiyun saon, mipasanguayu ta chachi nangangatuy turay. ");
INSERT INTO ksc_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ad sachin wayayuy mangifaka ta Mamfaruy Chamag mipangkop an saon. ");
INSERT INTO ksc_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Papigsaonyun somsomòyu ta sana ta achiayu machanakan ta isongfatyu nu chumatong na amaschi, ");
INSERT INTO ksc_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","tan paifakà na ukuchonyu ya adchò na kinaraingyu, siyan achi pu makasongfat na afusuryu, ya afakonyu chicha losan ta maid in-inonchay kumontaran chiayu. ");
INSERT INTO ksc_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ngim na sachi koy timpu, uray na chachakkoryu ya susunudyu, ya aagkiyu ya fufurunyu, ififik chiayu. Siyan na uchum an chiayu, mapatoy. ");
INSERT INTO ksc_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ad kuraon chiayu ta losani taku kapu ta pammatiyun saon. ");
INSERT INTO ksc_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ngim uray nu sinun màwan chiayu, foon pù taynan chiayun Apudyus, tan uray na simforas wi fuùyu, foon pù iparufus Apudyus wi matarà. ");
INSERT INTO ksc_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Siyan mangipapatiyanyu ta pammatiyu, ad makafiyag-ayun Apudyus à ing-ingkana.” ");
INSERT INTO ksc_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ad inturuy Jesus anani, “Nu ilanyu wi linìwos na achuy surchachud Jerusalem, siyan akammuwonyu wi ngannganin mayam-anana ya maafakan na ingkaw. ");
INSERT INTO ksc_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Siyan chachi ingkaw ad Judea, masapur umawidcha wi umoy mantaru ta filfilig. Ya chachi ingkaw ad Jerusalem, masapur mamfakwitcha. Ya losan chachi ingkaw ta tattarun, achicha pu kuma mangulin ta ili. ");
INSERT INTO ksc_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tan sachin timpuy manusaan Apudyus ta losani machusà matungparan na losani niyug-is ta awi. ");
INSERT INTO ksc_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Siyan kakkaasin chachi nafuki ya chachi mantakifi ta sachi timpu! Tan maid achi mipachas à likat tan siyan timpun na manusaan Apudyus ta taku ta annay luta. ");
INSERT INTO ksc_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mapatoy na uchum ya milayaw akon uchum ta ad-adchayuwani ili à mifarud. Ad na annay ilin na Judio wi Jerusalem, yamyam-anon na foon pù Judio ingkanà pagpakon Apudyus na manturayancha. ");
INSERT INTO ksc_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Na sachi koy timpu, kaog-ogyat na màwa ta init ya furan ya uray fituwon. Ad na annay luta, maid miyisuwan na ogyat na atakutaku tan sumafalin fayfay wi pumigsan challuyunna ya mamagngor na akungiyongna. ");
INSERT INTO ksc_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Matarà na somsomò na taku ta ogyatcha ta manguullayancha nu sinun asin màwa ta annay luta, tan makorkor na losani mailad langit. ");
INSERT INTO ksc_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ad sachin mangil-anchan saoni namfalin taku, wi iyaliyà ta lifuu, ad maila kon mannakafalin-u ya sumilingà ta kina-Apudyus-u. ");
INSERT INTO ksc_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Siyan nu milukin anchanayay màwa, masorkag-ayu ya papigsaonyun somsomòyu tan ngannganin masaraknifanyu ta losani likat.” ");
INSERT INTO ksc_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Sachi ad nan-alig à Jesus an chicha, wi anana, “Somsom-onyun imongi ikus ya uchum akoy ayu. ");
INSERT INTO ksc_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Akammuyu wi nu mangutar, chanchanin chakun. ");
INSERT INTO ksc_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Isuna ko, nu ilanyuy màwan anchanayay inukud-u, akammuwonyu wi chanchanin milukiyan na Manturayan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Tuttuwan ifakà an chiayu, wi foon pù losan matoy na taku ta annay lunap ad màwan losani inukud-u. ");
INSERT INTO ksc_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ad uray maumas losan na mailad langit ya asnay luta, achi pu mabmab-os na losani inukud-ù ing-ingkana, tan masapur matungpar losan.” ");
INSERT INTO ksc_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Inturuy Jesus wi anana, “Man-annad-ayu ta achiyu un-unnoyon na mallagragsakanyu ya makainumanyu, ya ilanyu ko ta achi marafos na chanagyu mipangkop ta probleman na annay mafiyakan, tan awni ad ananyu pun nu chaan na padchay mangulinà ad foon à makasakanaayu. ");
INSERT INTO ksc_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tan na mangulinà, maid pu mismù mangakammu ta losani taku ta arutaruta. ");
INSERT INTO ksc_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Siyan tatanchaananyu ya iluruwaruyun Apudyus ta papigsaonan somsomòyu ta mafalinyuy maanusan losan na mapasamak, ya ta mamfarun misanguwanyun saoni namfalin taku.” ");
INSERT INTO ksc_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Finikati umoy à Jesus ta Templo mantudtuchu, ad minaschom akoy umoy umiyan ta Filig wi Olivo. ");
INSERT INTO ksc_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ad finigfikati umoy na losani taku ta Templo mangngor ta itudtuchuna. ");
INSERT INTO ksc_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Sachi ad ngannganin timpun na fiyastay mangananchà tinapoy wi achi pu fumtar, wi siya kon fiyastay ananchay Mangiyakasmoan. ");
INSERT INTO ksc_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ad chachi mangitudtuchu ta Lintog ya pangpangun na papachi, nan-uupngacha nu sinun in-inonchay mamatoy an Jesus à foon pu kumà maakammuwan, tan ummogyatchà makuru na taku. ");
INSERT INTO ksc_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sachi ad finarfaray Satan à Judas Iscariote wi osa ta chachi nasawaran à chuway disipulus Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Siyan ummoy Judas inturag ta chachi pangpangun na papachi ya uchumi kapitan na kuwarcha ta Templo na mangififikanan Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Siyan naragsakcha ad nantuturagcha wi fayachanchà siya. ");
INSERT INTO ksc_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ummamfuruy à Judas ad illukinay man-anap à wayanay mangififik an Jesus à foon pu kumà maakammuwan ta taku. ");
INSERT INTO ksc_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Naarkawanan ad, chummatong na padchay manganan na Judio ta tinapoy wi achi pu fumtar, wi siya kon mamartiyancha ta pannilu wi maan ta padchay Mangiyakasmoan. ");
INSERT INTO ksc_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ad imfaun Jesus cha Pedro an Juan, wi anana, “Ing-ayu isakanan manganantau ta sanay fiyastay Mangiyakasmoan.” ");
INSERT INTO ksc_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ad inimuschan siya, “Sinun ustù mangisakanaanni?” ");
INSERT INTO ksc_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ad anana, “Nu lumnòayud aschi Jerusalem, sib-atonyun osay larai wi man-aagtù simfangà chanum. Siyan mitun-uchanyu. Ad na foroy wi lumnoana, ");
INSERT INTO ksc_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ifakayu ta nginforoy wi, ‘Anan na Misturu, Sinun awachan na kuwartu wi mangananni ta disipulus-u ta annay fiyastay Mangiyakasmoan?’ ");
INSERT INTO ksc_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ad ituchunan osay chakor wi kuwartu ta miyagway karachun na foroyna wi wachawad na losani masapur, ad sachin mangisakanaanyu ta manganantau.” ");
INSERT INTO ksc_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ad lummigwatcha ad inchasanchan losani imfakan Jesus, siyan insakanachan manganancha ta sachi fiyasta. ");
INSERT INTO ksc_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Chummatong pun na ustuy timpun na manganancha ta sachi fiyasta, nan-ooancha Jesus ta chachi nasawaran à chuway apostolesna. ");
INSERT INTO ksc_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ad ananan chicha, “Isag-u pion wi makaan an chiayu ta annayay fiyastay Mangiyakasmoan ta chaanà pu mapalikatan! ");
INSERT INTO ksc_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Tan tuttuway achiyà pu asin makaragsak ta annay fiyasta ingkanà tumuttuwan niyalikana ad langit ta Manturayan Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Sachi ad, innaran Jesus na sintasay fayas, ad nanyaman an Apudyus, ad ananan chicha, “Aranyuna ad mamfanfansanyu inumon, ");
INSERT INTO ksc_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","tan na ifakà an chiayu, manipud ta sana achiyà pu asin uminum à fayas ingkanà chumatong na Manturayan Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ad innarana kon osay tinapoy ad asin nanyaman an Apudyus, ad pinotpotlàna ad innadchonan chicha, wi anana, “Sanan long-ag-u wi michatun à mangilisin chiayu. Anonyunà mangiyakasmoanyun saon.” ");
INSERT INTO ksc_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Narpascha pun wi nangan, innadchonan fayas an chicha, wi anana, “Na annay fayas, siyan singyar na àooyyay turag Apudyus ta takuna, ad na charà nu matoyà, siyan matuttuwaan na sachi turag, tan na charà, mifùfù à para an chiayu. ");
INSERT INTO ksc_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ngim chongronyu yan! Awad an chitausnan osay makaan wi mangififik an saon! ");
INSERT INTO ksc_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","À saoni namfalin taku, mapatoyà tan sachin imfafagkan Apudyus, ngim kakkaasin takuy mangififik an saon!” ");
INSERT INTO ksc_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Sachi ad nan-asisarudsudcha nu sinun mangwan chicha ta amaschi. ");
INSERT INTO ksc_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Sachi ad nansusukob chachi disipulus Jesus nu sinun angatuwan an chicha. ");
INSERT INTO ksc_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Siyan anan Jesus an chicha, “Na turay ad asnay luta, amod na pinagmancharcha ta chachi iturayancha. Ad chachi turay wi annan karobfongancha, ad ichayawchan long-agcha wi mangwanani chicha nun mamachang ta taku. ");
INSERT INTO ksc_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ngim foon kumà mafalin na amaschin chiayu, tan na angatuwan an chiayu, masapur ifafanan long-agnà isù kafafaan wi afachang na uchum. Ad na pangat an chiayu, masapur mamfalin isù kafafaan wi mansilfi ta uchum. ");
INSERT INTO ksc_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sinun nangatngatu ta somsomòyu, na takuy tumùchu wi mangan winnu chi manakung an siya? Chi nasakungan wi tumutùchu. Ngim uray nu apuyù saon, isuwà à saniluyu. Ad amaschin turachonyu. ");
INSERT INTO ksc_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Fufurun-u, tuttuway inan-anusanyu kon losani likat-u. ");
INSERT INTO ksc_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Siyan na isun na nangadchan Ama an saon ta karobfongà wi manturay, amaschi kon mangadchà an chiayu ta karobfonganyu wi manturay. ");
INSERT INTO ksc_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ad mitatappiayun saon ta manturayà wi makainum ya makaufung an saon, ya chiayun manguis ta asintatakuyuy Judio wi kanà chachi nasawaran à chuway anà Jacob wi ananchay Israel.” ");
INSERT INTO ksc_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Sachi ad anan Jesus an Pedro, “Simon! Chongromna! Chinawat Satan ta miparufus na mamachasanan chiayu losan, ta ilana nu awad an chiayun milasin à isun na milasinan na chuki ta fokas. ");
INSERT INTO ksc_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ngim illuwaruwà sia, Simon, ta achi pu matarà na pammatim an saon. Ad nu asin-a mansakung an saon, papigsaom na pammatin na fufurunnu.” ");
INSERT INTO ksc_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ngim anan Pedro, “Apu, nakasakanaà uray nu mifaruchà ya makàtoyà an sia!” ");
INSERT INTO ksc_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ad anan Jesus, “Oo, ngim na katuttuwaana, Pedro, nu chaan pun na awitan manullaù à lafi, namitluwonà illifak.” ");
INSERT INTO ksc_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Sachi ad anan Jesus ta chachi disipulusna, “Na nangifaunà an chiayu ta sin-arkawan wi maid inaw-awityù pilak ya pasiing ya uray sapatusyu, nakurangan na masapuryu?” “Foon met,” anancha. ");
INSERT INTO ksc_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Ngim safali ta sana,” anan Jesus, “tan na sana, nu sinun awad pilakna, masapur awitona, ya masapur mampasiing ako. Ad nu sinun maid kamanna, inginana kuman silupnà kamanna. ");
INSERT INTO ksc_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kattoi masapur tumuttuwan sachi niyug-is wi ukud Apudyus mipangkop an saon, wi anana, ‘Nitaurung ta akkawan,’ tan matungpar losan na niyug-is mipangkop an saon.” ");
INSERT INTO ksc_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ad anan na disipulusna, “Apu, ilam! Annayan chuway kaman!” “Umanaynat!” anan Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ad lummayawcha Jesus ta chachi disipulusna wi ummoy ta Filig wi Olivo tan sachin umayaayana nu maschom. ");
INSERT INTO ksc_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Chummatongcha pun, anan Jesus an chicha, “Malluwaruayu ta achiayu pu maawis wi makafasur.” ");
INSERT INTO ksc_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Sachi ad inachayuwana chicha, ad nampalintumong wi malluwaru, ");
INSERT INTO ksc_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","wi anana, “Ama, nu siyan piom, ilisim à saon ta annay likat wi sangsanguwò. Ngim uray nu amasnan chawatò, pìo wi matungpar kan piom wi màwa, wi foon pu kà piò.” ");
INSERT INTO ksc_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Sachi ad nampailan siyan osay anghel wi narpud langit wi namachang an siya. ");
INSERT INTO ksc_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ad naam-amod na somsomò Jesus wi isù iyatoyna, ad sin-umisag na illulluwaruna, wi na lingotna, isù chara wi tumodtod ta luta. ");
INSERT INTO ksc_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Narpas pun na luwaruna, summiad ad nangulin ta ingkawan na disipulusna ad inchasana chichay nasusuyop tan amod na somsomòcha. ");
INSERT INTO ksc_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ad ananan chicha, “Taayuko nasusuyop? Fumangon-ayu ta malluwaruayu ta achiayu maawis wi fumasur.” ");
INSERT INTO ksc_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Na man-ukuukuchan Jesus, chummatong na ad-adchuwani taku, wi impuyut Judas wi osan chichay nasawaran à chuway disipulus Jesus. Ad ummoy à Judas an Jesus ad kinayyomnà siya. ");
INSERT INTO ksc_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ad anan Jesus, “Judas, namfalinom singyar na ayat à singyar na fifik ta mangififikam an saoni namfalin taku?” ");
INSERT INTO ksc_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ad illasin pun chachi fufurun Jesus na nànàwa, inimuschan Jesus, “Apu, faakonni chicha?” ");
INSERT INTO ksc_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ad na osa, piningasnan chiwawani ingan na sanilun na Angatuwani Pachi. ");
INSERT INTO ksc_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ngim anan Jesus, “Sachi! Akayyunat!” Ad inaranan ingan chi nafaag ad impar-ogna. ");
INSERT INTO ksc_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sachi ad anan Jesus ta chachi ummali mangaran siya, wi chichan pangpangun na papachi ya kakapitan na susurchachu ta Templo ya chachi mamangpanguwon na Judio, “Akkawanà, ta masapur masabsabliyan-ayu ya mapangpang-oan-ayu wi umali maniliw an saon? ");
INSERT INTO ksc_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Finakati miyas-aslangà an chiayu ta Templo, ad apay achiyà pu tiniliw ta sachi nù? Ngim sanan timpun na manturayan na lawing, siyan sachin miparufusanyu wi mangwa ta oyyoonyu.” ");
INSERT INTO ksc_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sachi ad tiniliwchà Jesus, ad inyoychà siya ta foroy na Angatuwani Pachi. Ad à Pedro, nan-ag-agkaaw wi nitun-ud an chicha. ");
INSERT INTO ksc_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nan-apuy na taku ta kawan na paway na foroy, siyan ummoy à Pedro nakaanichu an chicha. ");
INSERT INTO ksc_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ad na nangil-an na osay fafarasang wi sanilu an Pedro wi makaanichu, intotollongna ad anana, “Sanat akon osay furun Jesus!” ");
INSERT INTO ksc_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ngim illifak Pedro, wi anana, “Foon, fafarasang! Maid akammù an siya!” ");
INSERT INTO ksc_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Napannos pun iningkaw akon osay larai wi nangimatun an Pedro, an anana, “Sia met na osan chicha!” Ngim anan Pedro, “Foon!” ");
INSERT INTO ksc_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ad lummaus pu kon osay uras, immatunan akon osay laraì Pedro, ad impapilitna anani, “Kattoi siyan osay furun Jesus, tan maiimmatunan wi iGalilea!” ");
INSERT INTO ksc_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ngim anan ako Pedro, “Maid pu akammù ta ug-ugkuchom!” Ad na sachi man-ukuchan Pedro, natanullaù na awitan. ");
INSERT INTO ksc_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ad nantuwilì Jesus wi nangilan Pedro, ad nasnasmò Pedro na imfakan na Apunan siya wi anana, “Nu chaan pun na awitan manullaù à lafi, namitluwonà illifak.” ");
INSERT INTO ksc_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ad lummayaw à Pedro wi amod na somsomònay nan-ifil. ");
INSERT INTO ksc_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Chachi nanguwarchan Jesus, inam-amsiwchà siya ad linipakcha ko. ");
INSERT INTO ksc_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ad finungutchan atana ad inimuscha, “Sinun nanlipak an sia? Ifakam!” ");
INSERT INTO ksc_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ya achu kon imfakacha wi nanginsurtun siya. ");
INSERT INTO ksc_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Figfikat pun, naamung chachi namangpanguwon na Judio ya pangpangun na papachi ya mangitudtuchu ta Lintog, ad impasanguchà Jesus an chichay kukunsisar. ");
INSERT INTO ksc_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ad anancha, “Ifakam an chiani! Sian Cristu wi uullayonni?” Ad sinongfatan Jesus chicha, wi anana, “Uray nu ifakà, achiyu pu tuttuwaon. ");
INSERT INTO ksc_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ad nu awad akon sarudsuchò an chiayu, achiyu pu ko songfatan. ");
INSERT INTO ksc_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ngim nu marpas na annay màwan saon, à saoni namfalin taku, tumùchuwà ta apot ta chiwawan Apudyus wi mannakafalin.” ");
INSERT INTO ksc_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ad anancha losan, “Ad sian anà Apudyus?” Ad anana, “Siyan ananyu.” ");
INSERT INTO ksc_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ad anancha, “Na! Maid asintau anapon à fasurna, tan chingngortau met losan na imfakana wi umanay à iyatoyna!” ");
INSERT INTO ksc_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Sachi ad lummigwatcha losan ad inyoycha impasangù Jesus an Pilato wi fifinnachur. ");
INSERT INTO ksc_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ad imfakachan losani pangpangnuchay lawing wi ingwan anu Jesus. Anancha, “Chingngornin annay larai ta mangawisana ta kailiyanni ya ipalitnan mamfayachancha ta fukis ta Emperador. Ad anana koy siya nun Cristu wi impustan Apudyus wi umalì man-alitau.” ");
INSERT INTO ksc_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Sachi ad anan Pilato an siya, “Sia nun Alin na Judio.” “Siyan anam,” anan Jesus wi summongfat. ");
INSERT INTO ksc_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Sachi ad imfakan Pilato ta chachi pangpangun na papachi ya losan chachi takuy naaarus, “Maid met inchasà à fasur na annay laraì umanay à matoyana.” ");
INSERT INTO ksc_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ngim impapilitcha anani, “Nantudtudtuchun sanat ta losani ilid asnay Judea, wi imparpunad Galilea, wi aw-awisonan taku ta kuruwonchan kufilnu, ad na sana, annay chummatong ako ad asnay Jerusalem.” ");
INSERT INTO ksc_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Chingngor pu Pilato na imfakacha, inimusna, “iGalilea lawan annay larai?” ");
INSERT INTO ksc_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ad inakammuna pun wi narpù Jesus ta sakupon na iturayan Herod, impaoynà Jesus an siya tan niyaspur wi iningkaw à Herod ad Jerusalem ta sachi timpu. ");
INSERT INTO ksc_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ad à Herod, naragsak wi mangilan Jesus tan nafayag wi pionay mangilan siya kapu ta losani chingngorna wi mipangkop an siya. Ad piona koy mangilà kaskaschaaw à oyyoon Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Siyan nan-im-imus à Herod an Jesus, ngim ingkikinnò à Jesus wi maid insongfatna. ");
INSERT INTO ksc_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ad chachi pangpangun na papachi ya mangitudtuchu ta Lintog, inam-amodchan nangipafasuranchan Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Siyan à Herod ya susurchachuna, ininsurtuchà Jesus ya imfafaincha ko. Ad na anungusna, sinilupanchà siyà mamfaru ad inyulincha an Pilato. ");
INSERT INTO ksc_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ad nanipud ta sachi padcha, nangkayyomcha Herod an Pilato, uray nu namfusurchay sikud. ");
INSERT INTO ksc_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Sachi ad impaarus Pilato chachi pangpangun na papachi ya mamangpanguwon na taku ya uchum akoy taku, ");
INSERT INTO ksc_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ad ananan chicha, “Impasanguyun annay takun saon, ad imfakayu wi aw-awisonan taku. Siyan inimfistikar-ù siya ta sangwananyu, ngim maid pu inchasà à iningwanà isun na ipafasuryun siya. ");
INSERT INTO ksc_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ad isun ako Herod, maid pu ko inchasanà kafasurana, tan nangulinonà siya an chitau. Siyan maila wi maid pun ingwan na annay laraì umanay à matayana. ");
INSERT INTO ksc_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Siyan paabchoy-u kà siya ad imparufus-u.” ");
INSERT INTO ksc_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Amaschin anan Pilato tan kakangayna wi tinawoni umiparufus à osa ta farud ta timpun na fiyastay Mangiyakasmoan. ");
INSERT INTO ksc_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ngim chachi takuy naaamung, asipopoawcha wi anancha, “Patoyom à siya, ta Barrabas na iparufusnu!” ");
INSERT INTO ksc_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Na sachi Barrabas, nifarud tan nitipun nakakuru ta kufilnud Jerusalem, ya iningkaw akon pinatoynay taku.) ");
INSERT INTO ksc_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ngim à Pilato, pionay iparufus kumà Jesus, siyan pinachasnay mangawis ta taku. ");
INSERT INTO ksc_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ngim inip-awcha anani, “Ilansayù siya ta kros! Ilansayù siya ta kros!” ");
INSERT INTO ksc_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Sachi ad impitlun Pilato pinachas wi mangàarù an chicha, wi anana, “Tamako? Sinun ingwanay lawing à milansaana ta kros? Tan maid met inchasà à fasurnà umanay à mapatoyana! Winnu paabchoy-u kà siya ad imparufus-u?” ");
INSERT INTO ksc_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ngim inip-ip-awcha wi mangipapilit wi milansà Jesus ta kros. Ad na anungusna, intay-un Pilato. ");
INSERT INTO ksc_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ad sinintinsiyaanà Jesus à mapatoy, wi sachin chawatcha. ");
INSERT INTO ksc_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ad imparufusnà Barrabas, wi siyan nifafarud kapu ta pummatoyana ya nanguruwana ta kufilnu, tan siyan pionchay miparufus. Ad impurangnà Jesus an chicha ta oyyoonchan sinumani pionchay oyyoon an siya. ");
INSERT INTO ksc_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ad illawachà Jesus, ad inafotcha ta charan na osay taku wi nangngachan à Simon wi iCirene. Jerusalem na ustuy umayana wi narpu ta payawna, ngim impafuudchan siyan kros Jesus ad ituntun-udnan siya. ");
INSERT INTO ksc_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ad-adchuwan na takuy nituntun-ud an Jesus, wi nitapi kon uchumi fubfufai wi asiiifil ya asitutuking mipakapu ta màmàwan siya. ");
INSERT INTO ksc_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ad nantuwilì Jesus an chicha ad anana, “Chiayuy fubfufai wi iJerusalem, achiyu kumà saon ifilan ta siya kay ifilanyun long-agyu ya an-ananàyu. ");
INSERT INTO ksc_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tan chumtong na amochi likat ad asna, wi mangwanaan na taku, ‘Nakasat chachi fubfufai wi maid anàcha, wi foon à nafugfuki ya maid pu tinagtakificha!’ ");
INSERT INTO ksc_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tan kapu ta amochi likat ta sachi timpu, chawaton na taku ta uray na filfilig ya takudtud, tapilancha chicha ta mitarucha kuma. ");
INSERT INTO ksc_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tan ilanyu, nu amaschin mapalikatà wi maid pu fasur-u, sin-umamod na mapalikatanyu ya kanàyu wi managfasur!” ");
INSERT INTO ksc_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Iningkaw akon chuway pumappatoy à mitapi mapatoy an Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ad na nichaumancha ta osay lukar wi ananchay “Fàag,” illansachà Jesus ta kros, ad illansacha ko namfuwaon chi chuway pumappatoy ta kroscha, na osa ta apot ta chiwawan Jesus ya osa ta apot ta chuwikina. ");
INSERT INTO ksc_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Narpas pun na sachi, anan Jesus, “Ama, pakawanom chicha tan maid maawatancha ta oy-oyyooncha.” Na susurchachu wi iningkaw, namfinnunutcha nu sinun mangin-uwa ta luputna. ");
INSERT INTO ksc_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ad ummaagsad na taku wi nampapalliu, ad chachi namangpanguwon na Judio inin-insurtuchà Jesus anani, “Finadnganan uchum, siyan fadngana kuman long-agna nu tuttuway siyan Cristu wi chinutukan Apudyus!” ");
INSERT INTO ksc_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ad inamsiw akon susurchachù siya, wi painumancha siyà ilom, ");
INSERT INTO ksc_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ad anancha, “Noy! Nu tuttuway sian alin na Judio, apay achim saraknifan na long-agnu nù?” ");
INSERT INTO ksc_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Iningkaw na niyug-is ta kros ta uulluwan Jesus, wi anana, “Annayan Alin na Judio.” ");
INSERT INTO ksc_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Na osay pumappatoy wi nichar-ag nilansa an Jesus, ininsurtuna kò siya, wi anana, “Nu tuttuway sian Cristu wi impustan Apudyus, saraknifam na long-agnu ya chiani ko!” ");
INSERT INTO ksc_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ngim chi osay pumappatoy, inomorana chi osa, wi anana, “Maid ogyatnun Apudyus? Nilansatau losan, ");
INSERT INTO ksc_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ngim à chita, lobfongta met wi mapatoy ta chusan na iningwata, ngim na sanat, maid pun ingwanà lawing.” ");
INSERT INTO ksc_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Sachi ad, ananan Jesus, “Apu Jesus, somsom-onà ad nu umalia manturay!” ");
INSERT INTO ksc_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ad anan Jesus, “Ipustà an sia, wi na sanay padcha, mitapian saon ad langit.” ");
INSERT INTO ksc_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Mamatù ad, fummulingot losan na luta ingkana ta ar-arkaw. ");
INSERT INTO ksc_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ad na sochorani kurtina wi nitatayyun ta Templo, nan-agwa nakissay. ");
INSERT INTO ksc_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ad nampoaw à Jesus wi anana, “Ama, ipurang-un sian alichodwà!” Imfakana pun na sachi, natoy. ");
INSERT INTO ksc_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Na nangil-an na kapitan na susurchachu ta losani nàwa, chinayawnà Apudyus, wi anana, “Tuttuway maid kafasuran na annay larai!” ");
INSERT INTO ksc_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ad chachi takuy iningkaw wi nampapalliu, innilacha pun na losani nàwan Jesus, asisasauychay lummayaw. ");
INSERT INTO ksc_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ngim losan chachi fufurun Jesus, ya chachi fubfufai wi nitun-ud an siya ta narpuwanchad Galilea, ummaagsadcha ta niyadchayang wi nampapalliu ta losani nànàwa. ");
INSERT INTO ksc_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Iningkaw ad Jerusalem na osay larai wi Jose na ngachanna wi iyArimatea wi osay ili ta provinsiyay Judea. Machayaw à Jose tan naakammuwan na kinafaruna, ad siya kon osay man-uullay ta milukiyan na Manturayan Apudyus. Ngim uray nu siyan osay kunsisar na Judio, achina pu inamfuruyan na simsimmòcha oyyoon an Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ummoy Jose an Pilato chinawat na lachag Jesus. Ad intay-una. ");
INSERT INTO ksc_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ad impasnan lachag Jesus ta kros, ad finussungnà uros ad inyoyna illofon ta attutukutukanchay fatuy lofon wi maid nilobrofon. ");
INSERT INTO ksc_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Na timpun na nilobnana, nganngani masiut na init wi sachin milukiyan na padchay ngingillinan na Judio wi Safachu. ");
INSERT INTO ksc_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Na fubfufai wi nituntun-ud an Jesus ta narpuwanchad Galilea, nitun-udchan Jose ad innilachan lofon Jesus ya nangilobnancha ta lachagna. ");
INSERT INTO ksc_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Sachi ad lummayawcha wi ummoycha insakanan fangfanguy tufu ya lana wi milafu ta lachag. Nafikat pun wi Safachu, nangkakayamcha man-illong tan siyan lintogchay Judio. ");
INSERT INTO ksc_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Wiswisnit pun ta Chumingku, lummigwat chachi fubfufai wi ummoy ta lofon, wi inawitchan fangfangu wi insakanacha. ");
INSERT INTO ksc_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nichaumcha ad ta lofon, innilachan fatuy tangob na lofon wi niyadchayang nalikad ta liwangan. ");
INSERT INTO ksc_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Siyan linumnòcha, ad maid inchasanchà lachag Apu Jesus. ");
INSERT INTO ksc_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ad ummaagsadcha wi napasar, ad nakaagsad akon chuway larai wi sumiling na luputcha. ");
INSERT INTO ksc_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ad chachi fubfufai, nampalintumongcha ta ogyatcha. Ad anan chachi larain chicha, “Tayuko anapon na natattaku ta ikaw na natoy? ");
INSERT INTO ksc_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Maid à siya ta anna tan ummuli nataku. Naliwatanyu nin na imfakanan chiayu ta iningkawanad Galilea, ");
INSERT INTO ksc_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","wi anana, ‘À saon wi namfalin taku, masapur mipurangà ta chachi lawingi taku ya milansaà ta kros, ad na miyatluy padcha umuliyà mataku.’” ");
INSERT INTO ksc_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ad sachin nangiyakasmoan chachi fubfufai ta imfakan Jesus, ");
INSERT INTO ksc_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","siyan nangulincha ta ili ad imfakacha losan chachi ta disipulus Jesus wi simpuru ya osa, ya losan chachi uchumi fufuruncha. ");
INSERT INTO ksc_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Na ngachan chachi fubfufai, cha Maria Magdalena, Juana, Maria wi inan Jaime, ya iningkaw akon uchum. Imfakacha losan na innilacha ya chingngorcha ta chachi apostoles. ");
INSERT INTO ksc_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ngim achicha pu tuttuwaon chicha, tan anancha pun nu maid kutù na ug-ugkuchoncha. ");
INSERT INTO ksc_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ngim à Pedro, narnigwat wi nanodchà ummoy ta lofon. Nichaum ad, nayyuung wi nangila ta charomna, ad afus yakan fussung à iningkaw. Siyan nangulin ta foroy, wi naschaaw wi mammomammò nu in-inon na nàwaana. ");
INSERT INTO ksc_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Na sachi padcha, lummigwat na chuwa ta chachi sumurut an Jesus wi umoy ad Emaus wi nasuruk à simpuru ya chuway kilometron aachayunad Jerusalem. ");
INSERT INTO ksc_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ad na nanadcharanancha, inug-ugkudchan losani napasamak. ");
INSERT INTO ksc_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ad na nan-ug-ugkuchancha, inchasan Jesus chicha ad nifurun an chicha, ");
INSERT INTO ksc_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ngim achicha pu makailasin an siya. ");
INSERT INTO ksc_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ad anan Jesus an chicha, “Sinu kon ug-ugkuchonyuy manadcharan?” Ad ummillongchay mangngunguspoy. ");
INSERT INTO ksc_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ad anan na osa wi nangngachan Cleopas, “Adchachatong-ad Jerusalem, wi afus-a kà foon à nangngor ta losani nàwa ta sanay timpu?” ");
INSERT INTO ksc_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ad inimus Jesus, “Sinuman?” Ad anancha, “Chachi napasamak an Jesus wi iNazaret. À siya, naakammuwan wi profetan Apudyus, wi lispituwon Apudyus ya uray na taku. Ya impailanan karobfongana wi mantudtuchu ta losani intudtuchuna, ya nangwa kò kaskaschaaw. ");
INSERT INTO ksc_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ngim chachi pangpangun na papachitau ya mamangpanguwontau, impurangchà siya an Pilato ad sinintinsiyaanà matoy, siyan illansachà siya ta kros. ");
INSERT INTO ksc_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ngim chiani, ananni pun nu siyan manaraknib an chitauy kanà Israel! Ngim lawing ta miyatluy padchanan sana nanipud ta nàwan siya. ");
INSERT INTO ksc_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nataag-anid kanad ta inisturyan na uchumi fufurunni wi fubfufai, tan naawisnitcha ummoy ta lofon, ");
INSERT INTO ksc_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ad maid anun lachagna. Ad nangulinchay nangifakan chiani wi innilacha nun aangheles wi nangifakan chicha wi ummuli natakù Jesus! ");
INSERT INTO ksc_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Siyan ummoy akon uchumi fufurunni wi nangila ta lofon, ad na inchasancha, isun akon inisturyan chachi fubfufai, ngim maid pu innilachan Jesus.” ");
INSERT INTO ksc_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Sachi ad anan Jesus an chicha, “Maid pu akammuyu! Tan apay mansikab na manuttuwaanyu ta losani imfakan chachi profetas ta awi! ");
INSERT INTO ksc_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Achiyu pu maawatan wi masapur mapalikatan na Cristu wi impustan Apudyus wi umali achinaot ochasan na machayawana.” ");
INSERT INTO ksc_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Sachi ad insuplikar Jesus losan na niyug-is ta awi mipangkop an siya, wi illukina ta inyug-is Moses ingkana ta inyug-is losan na profetas. ");
INSERT INTO ksc_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Sachi ad wi ummachanicha ta ili wi umayancha, isù mangaw-as à Jesus wi lumayaw, ");
INSERT INTO ksc_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ngim tinawichanchà siya wi anancha, “Umiyan-asna, tan mummaschom ad mafulingtan-a.” Siyan nanchakas Jesus ad nakarnò an chicha ta foroy. ");
INSERT INTO ksc_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ad na nan-ooanancha, inaran Jesus na tinapoy ad nanyaman an Apudyus, ad pinotlàna ad innadchonan chicha. ");
INSERT INTO ksc_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ad sachin nangilasinancha wi siyà Jesus, ngim nammaag wi maid à siya. ");
INSERT INTO ksc_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Sachi ad anancha, “Kattoi naragsak na somsomòta ta nangug-ugkuchana ta charan ta nangisuplikarana ta sachi niyug-is wi ukud Apudyus, ad sana kan ustuy mangawatanta!” ");
INSERT INTO ksc_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ad narnigwatcha wi nangulin ad Jerusalem, ad inchasanchan chachi nasawaran à osay disipulus Jesus, wi nakaamung akon uchum. ");
INSERT INTO ksc_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ad anancha, “Tuttuway ummuli natakun Aputau! Ad nampailan Simon!” ");
INSERT INTO ksc_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Sachi ad inisturyachan losani nàwa ta nafurkancha ya nangilasinanchan Jesus ta namotlaana ta tinapoy. ");
INSERT INTO ksc_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ad na sachi nan-ug-ugkuchancha, nampailà Apu Jesus ta kawacha, ad ananan chicha, “Fumarun somsomòyu!” ");
INSERT INTO ksc_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ngim isagcha ummogyat, tan anancha pun nu aran. ");
INSERT INTO ksc_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ngim anan Jesus an chicha, “Taayuko umogyat? Tamako ta manchuwachuwaayu mipangkop an saon? ");
INSERT INTO ksc_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ilanyun imà ya ikì! Saon na! Agpachanà ta mat-op-ayu, tan maid pun met long-ag na aran! Ngim mailayun long-ag-u.” ");
INSERT INTO ksc_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Sachi ad impailan Jesus na imana ya ikina. ");
INSERT INTO ksc_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ad naragsakcha ya naschaawcha, ngim uray nu amaschi, isù foon pù tuttuwa. Siyan inimus Jesus an chicha, “Awad maan ta manganà?” ");
INSERT INTO ksc_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ad sinakunganchà siyà nautù ukachiw, ");
INSERT INTO ksc_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ad innanna ta sangwanancha. ");
INSERT INTO ksc_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sachi ad ananan chicha, “Losani napasamak an saon, imfakafakà ta iningkawà an chiayu, tan masapur wi matungpar losan na niyug-is mipangkop an saon nanipud ta inyug-is Moses ya chachi profetas ya uray na niyug-is ta chachi kankanta wi Salmo.” ");
INSERT INTO ksc_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Sachi ad linawakanan somsomòcha ta maawatanchan losani niyug-is ta awi wi ukud Apudyus. ");
INSERT INTO ksc_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ad anana kon chicha, “Annayan niyug-is mipangkop an saon: Masapur mapalikatan na Cristu, wi siyan impustan Apudyus wi umali, ya mapatoy, ngim na miyatluy padcha umuli mataku. ");
INSERT INTO ksc_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ya niyug-is ako wi masapur mitudtuchun annay chamag mipangkop ta mamfafawiyan na taku ta mapakawan na fasurcha mipakapun siya. Siyan mitudtuchuchi ta losani taku ta ailiili wi milukid asnay Jerusalem. ");
INSERT INTO ksc_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ad chiayun mangistiku ta katuttuwaan na losani nàwa. ");
INSERT INTO ksc_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ad foon pù mafayag ad ipaalì an chiayun sachi impustan Ama wi mipaali ko, wi Ispirituna. Ngim masapur ingkaw-ayud asnay ili ingkanà chumatongchin chiayu, tan siyan mannakafalin wi marpud langit.” ");
INSERT INTO ksc_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Sachi ad imfurog Jesus chicha ingkanad Betania. Chummatongcha ad, intay-ag Jesus na imana ad fininchisyunanà chicha. ");
INSERT INTO ksc_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ad na naminchisyunanan chicha, nipangatù siya ad langit wi tinaynanà chicha. ");
INSERT INTO ksc_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ad chinaychayawchà siya, ad nangulinchay asilaragsak ad Jerusalem. ");
INSERT INTO ksc_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ad finikati umoycha ta Templo wi manaychayaw an Apudyus.");
INSERT INTO ksc_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Na chamu wi chaan pun na lufung màwaan, iningkaw na Ukud wi siyà Jesu Cristu, wi siyan mangipaila ta kina-Apudyus Apudyus. Na sachi Ukud, iniingkaw an Apudyus, ya siya ko kà Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Chinutukan Apudyus à siyà mangwa ta losan, ad nàwan losan mipakapun siya. ");
INSERT INTO ksc_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Siyan narpuwan na fiyag na losani matattaku, ya siya kon Silaw wi manlawag ta somsomò na taku. ");
INSERT INTO ksc_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Na sachi naawakan à Silaw, lawakanan pangot wi ingkawan na taku, ad na pangot, achi pu makaafak an siya. ");
INSERT INTO ksc_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Iningkaw na osay larai wi impaligwat Apudyus, wi nangngachan à Juan. ");
INSERT INTO ksc_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Impaligwat Apudyus à mangifaka ta atakutaku mipangkop ta sachi naawakan à Silaw. Istikuwanà siya ta mamati kuman taku. ");
INSERT INTO ksc_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Foon à Juan na manlawag ta somsomò na taku, ngim siyan ummali nangifaka ta mipangkop ta sachi Silaw. ");
INSERT INTO ksc_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tan awad na osay umali, wi siyan tuttuway Silaw wi manlawag ta somsomò na losani takud asnay luta. ");
INSERT INTO ksc_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ngim ummali pun ad asnay lutay iningwana, foon pù illasin na taku wi siyan Cristu. ");
INSERT INTO ksc_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ad uray na kailiyana, foon pù namfiyanganchà siya. ");
INSERT INTO ksc_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ngim na losani namiyang an siya, ya namatin siya, innadchan Apudyus chichà karobfonganchay mamfalin anàna. ");
INSERT INTO ksc_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Na mamfalinan na takù anà Apudyus, foon à takun mangwa, ya foon à miyisu ta sikud wi miyanaan na taku, tan Apudyus na mangwà mamfalinan na takù anàna. ");
INSERT INTO ksc_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Na sachi Ukud, namfalin taku ad iningkaw an chitau. Na losani imfakana, tuttuwa, ad na losani iningwana, impailanan achakuna ta taku. Innilani kon kina-Apudyusna tan siyan mismuy anà Amanay Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Tinàchoran ako Juan à siya, wi anana, “Siya chi imfagfakà an chiayu ta nangifag-à, ‘Na misukat an saon, nangatngatu nu saon tan à siya, iniingkaw uray ta chaan-u pù miyanaan.’” ");
INSERT INTO ksc_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Maid miyisuwan na achakuna ta taku, tan achaachakuwan chitaù ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","À Moses, siyan nangifakan chitau ta lintog Apudyus, ngim à Jesu Cristu, siyan nangipaila ta achakun Apudyus an chitau ya katuttuwaan mipangkop an siya. ");
INSERT INTO ksc_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Maid pu takù nangilan Apudyus, siyan maid pu mangipakaawat ta taku mipangkop an siya. Ngim na sikud wi Anàna wi isuna, wi iniingkaw an Apudyus, siyan nangipakaawat ta taku mipangkop an Amana. ");
INSERT INTO ksc_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Annayan nangifag-an Juan wi Mamfufunyag ta mipangkop an Jesus. Na pangpangun na Judio ad Jerusalem, namfaunchà papachi ya uchumi tumurung an chicha à umoy mangimus an Juan nu sinù siya. ");
INSERT INTO ksc_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ad à Juan, foon à insulibna, tan imfakanan katuttuwaan, “Foon à saon na Cristu wi uullayontau.” ");
INSERT INTO ksc_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ad anancha ko, “Ad sinua man? Winnu sià Elias wi ananchay asin umali?” Ngim anana ko, “Foon à saon.” Ad anancha ko, “Winnu sian sachi profetay uullayonni?” Ad anan ako Juan, “Foon à saon.” ");
INSERT INTO ksc_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ad inimuscha asin, “Ad sinua nù? Ifakam ud nu sinua, ta awad ako ifakani ta chachi nangifaun an chiani.” ");
INSERT INTO ksc_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Sachi ad insongfat Juan na sachi inyug-is Isaias wi profeta ta awi, wi anana, “Saon na sachi iniingkaw ta ikaw wi maid pu foroy, wi mangip-ip-aw anani, ‘Sakanaonyun chumatngan na Apu.’” ");
INSERT INTO ksc_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Sachi ad, chachi imfaun na Fariseo an Juan, ");
INSERT INTO ksc_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","anancha, “Nu foon à sian Cristu, ya foon akò sian Elias, winnu sachi profetay uullayonni, apay mamfunyag-a nù?” ");
INSERT INTO ksc_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ad summongfat à Juan wi anana, “Chanum yakan ifunyag-u, ngim awad an chiayu ta sanan osay takuy chaanyu pù akammuwon. ");
INSERT INTO ksc_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Siyan misukat an saon. Nangatngatu nu saon, wi amochà à miyisun siya.” ");
INSERT INTO ksc_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nàwa losan na sachi ad Betania, ta fisà na Chawwang wi Jordan wi namfunyafunyakan Juan. ");
INSERT INTO ksc_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nafikat ad, innilan Juan à Jesus wi marungay, ad anana, “Ilanyu, anchiyan Pannilu wi innadchon Apudyus à mapatoy à fayad na fasur na losani takud asnay luta! ");
INSERT INTO ksc_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Siyan imfakà wi misukat an saon, wi nangatngatu nu saon, tan à siya, iniingkaw ta chaan-u pù miyanaan. ");
INSERT INTO ksc_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Uray saon ta chamu, foon pu kò immatunà na kinatatakuna. Ngim na sana, na pangkop-uy mamunyag ta takù chanum, ta mipaakammu an chitauy kanà Israel wi siyan imfaun Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Ad imfakan ako Juan, “Na chamu, tuttuway foon pù immatunà na kinatatakuna. Ngim à Apudyus wi nangifaun an saon à mamfunyag à chanum, imfakanan saon, ‘Na takuy ilam wi sum-opan na Ispiritù, siyan mangifunyag ta takù Ispiritù.’ Ad na sana, akammù à siya tan innilà na Ispiritun Apudyus, wi isù karupati wi narpud langit, wi sinum-op ingkaw an siya. ");
INSERT INTO ksc_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ad kapu ta innilà, tàchorà wi siyan tuttuway Anà Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Asin ako nafikat, iningkaw à Juan ya chuway disipulusna, ");
INSERT INTO ksc_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ad innilanà Jesus wi lumaus, ad anana, “Anchiyan Pannilu wi innadchon Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chingngor ad chachi chuway disipulus Juan na imfakana, tinun-udchà Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ad nantuwilì Jesus ad innilanà chichay mituntun-ud, ad anana, “Sinun anaponyu?” Ad summongfatcha, wi anancha, “Misturu, sinun ingkawam?” ");
INSERT INTO ksc_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ad anan Jesus, “Intau ta ing-ayu ilan.” Ad nifurunchan siya wi umoycha ilan na iingkawana, ad linaficha iningkaw an siya. ");
INSERT INTO ksc_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Na osay nitun-ud an Jesus, Andres wi sunud Simon Pedro. ");
INSERT INTO ksc_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ad inaw-awaynay ummoy nanganap an sunudnay Simon ad imfakanan siya, “Inchasannin Cristu.” (Na mining na sachi ngachan wi Cristu: Na impustan Apudyus wi umalid asnay luta manturay.) ");
INSERT INTO ksc_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Sachi ad inyoy Andres na sunudnay Simon an Jesus. Ad na nangil-an Jesus an siya, anana, “Siay Simon wi anà Juan, ngachanà sià Cefas.” (Na ngachan wi Cefas, isun Pedro wi na miningna, falintuukan.) ");
INSERT INTO ksc_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Nafikat ad, simsimmò Jesus wi umoy ad Galilea. Inchasanà Felipe, wi iBetsaida, wi kailiyancha Andres an Pedro. Ad anan Jesus an siya, “Mifurun-an saon!” ");
INSERT INTO ksc_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Sachi ad inanap ako Felipè Natanael, ad imfakanan siya, “Inchasannin sachi takuy inyug-is Moses ta nangiyug-isana ta Lintog wi siya kon takuy inyug-is chachi profetas ta awi. Na ngachanna, Jesus wi iNazaret, wi anà Jose.” ");
INSERT INTO ksc_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Summongfat à Natanael, anana, “Apay, awad mamfarù takù narpud Nazaret?” Ad anan Felipe, “Umalia ta inta ilan.” ");
INSERT INTO ksc_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Sachi ad wi innilan Jesus à Natanael wi marungay, anana, “Annayan osay taku wi maid silibna, siyan tuttuway kanà Israel!” ");
INSERT INTO ksc_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Sachin inimus Natanael, “In-inon na nangakammuwam an saon?” Ad anan Jesus, “Innilà siay tummutùchu ta puun na ayuy ikus ta chaan pun Felipe mangchasan an sia.” ");
INSERT INTO ksc_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","“Apu, sian Anà Apudyus,” anan Natanael, “ya sia kon Alini wi kanà Israel.” ");
INSERT INTO ksc_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ad anan ako Jesus, “Afus yakan nangifag-à wi innilà siay tummutùchu ta puun na ayu, ad siyan mamatiyam wi saon na Cristu? Ad-achun kaskaschaaw wi mailayu nu anna!” ");
INSERT INTO ksc_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ad anana kon chicha losan, “Tuttuwan ifakà an chiayu, wi mailayuy miwanit ad langit, ya mailayu kon aangheles Apudyus wi mamagpagkulin an saoni namfalin taku.” ");
INSERT INTO ksc_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Narpas pun na chuway padcha, iningkaw na kasar ad Cana wi sakup Galilea. Ad ummoy nakakasar na inan Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ad naimfitar akò Jesus ya chiani wi disipulusna. ");
INSERT INTO ksc_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Naamin pun na fayas, imfakan na inan Jesus an siya, “Naamin na fayas.” ");
INSERT INTO ksc_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ad anan Jesus, “Ina, foon à masapur ifakam na oyyoò, tan ikad-u kay. Tan chaan pù chumatong na timpuy mangipail-à ta karobfongà.” ");
INSERT INTO ksc_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ngim imfakan inana ta sasannilu, “Uray sinuy ifakanan chiayu, oyyoonyu.” ");
INSERT INTO ksc_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na paway na foroy, iningkaw na onomi finatuy amutu wi sillimman lataan à chanum. Sachin fufulluwan na Judio ta kaisaw tan siyan ukalicha. ");
INSERT INTO ksc_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ad anan Jesus ta sasannilu, “Punuwonyun anchanayay amutù chanum.” Ad pinnucha. ");
INSERT INTO ksc_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Sachi ad, anan Jesus an chicha, “Law-onyu ad ing-ayu ipasimsim ta pangpangun na kasar.” Ad iningwacha. ");
INSERT INTO ksc_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","Ad sinimsiman na pangpangu na chanum wi namfalin fayas, ad impaayagnan mangasaway larai, ad anana, “Tamako? Siya met ukalin umunan mampiyay fayas, ta nu masalimong na taku, sachin misukatan na foon à isag mampiya. Ngim sia, safalin iningwam tan nanganungusom na mampiya!” Sachin imfakana tan foon pù inakammunan narpuwan na mampiyay fayas, ngim chachi sanilun nangakammu. ");
INSERT INTO ksc_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Sachin iningwan Jesus ad Cana wi ili ta sakup Galilea, wi chamuy kaskaschaaw wi iningwanà mangipail-ana ta mannakafalinna. Ad namatin chachi disipulusnan siya. ");
INSERT INTO ksc_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ad narpas pun na sachi, ummoy à Jesus ya inana ya susunudna ya chachi disipulusna ad Capernaum, ad iningkawchad aschì am-annay padcha. ");
INSERT INTO ksc_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Chanchanin Fiyastay Mangiyakasmoan ta nallausan na anghel ta aappuni wi Judio ad Egipto, siyan ummoy à Jesus ad Jerusalem. ");
INSERT INTO ksc_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Na sachi, ummoy ta Templo ad inchasanan mallarakù faka, pannilu ya karupati, ya mansusukat à pilak wi tummutùchu ta lamisaancha. ");
INSERT INTO ksc_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ad nangwà Jesus à abchoy ad chinogchogna imparyaw na losani faka ya pannilu ta Templo, ad linitwadna kon lamisaan na chachi mansusukat à pilak ad niwalis na pilakcha. ");
INSERT INTO ksc_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Imfakana ko ta mallarakù karupati, “Ilayawyun anchanayay ilakrakuyu! Apay, mamfalinonyun foroy Ama à larakkuwan?” ");
INSERT INTO ksc_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Na nangil-anni wi disipulus Jesus ta iningwana, simsimmònin sachi niyug-is wi ukud Apudyus ta awi, wi anana, “Isù mapalikatanà kapu ta apos-uy mangiila ta oyyoonchay achicha pu lispituwon na foroynu, Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Sachi ad anan chachi pangpangun na Judio an Jesus, “Sinun kaskaschaaw à oyyoom à manuttuwaanni wi awad karobfongam wi mangwa ta sanat?” ");
INSERT INTO ksc_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ad anan Jesus wi summongfat, “Nu yam-anonyun annayay Templo, patàchorò ta miyatluy padcha.” ");
INSERT INTO ksc_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ad anan chachi Judio, “Apay, namnamam wi afus na turuy padchà mangipatàchoram ta annayay Templo? Ummoy à opatpuru ya onomi tawon na nàwaana!” ");
INSERT INTO ksc_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ngim foon à sachi Templo wi foroy na ug-ugkuchon Jesus, tan inyalignan Templo à long-agna. ");
INSERT INTO ksc_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Na sachi, chiani wi disipulusna, achini pu naawatan na imfakan Jesus, ngim ummuli pù Jesus nataku, simsimmònin imfakana ad pinatinin losani imfakana ya losan akoy niyug-is wi ukud Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Na iningkawan Jesus ad Jerusalem ta timpun na Fiyastay Mangiyakasmoan, achun namatin siya ta nangil-ancha ta kaskaschaaw wi iningwana. ");
INSERT INTO ksc_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ngim foon à mapnok à Jesus ta ananchay namatiyanchan siya, tan inaagkammunan somsomò na losani taku. ");
INSERT INTO ksc_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Siyan foon à masapur wi awad mangitudtuchun siya ta kinatatakun na taku, tan inaagkammunan awad ta somsomòcha. ");
INSERT INTO ksc_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Iningkaw na osay Fariseo wi turay na Judio, wi nangngachan à Nicodemo. ");
INSERT INTO ksc_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Na osay lafi, ummoy an Jesus, ad anana, “Misturu, akammuni wi Apudyus na nangifaun an sia wi mantudtuchu, tan maid makàwa ta anchanayay kaskaschaaw wi oy-oyyoom nu maid à Apudyus an siya.” ");
INSERT INTO ksc_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ad anan Jesus wi summongfat, “Tuttuwan ifakà an sia: Achi pu mafalini mitapin taku ta Manturayan Apudyus nu foon pù asin miyanà.” ");
INSERT INTO ksc_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","“In-inon na nakotongi larai wi asin miyanà?” anan Nicodemo. “Apay, mafalini mangulin ta fuwang na inana ad asin miyanà?” ");
INSERT INTO ksc_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ad anan Jesus, “Tuttuwan ifakà an sia: Achi pu mafalini mitapin taku ta Manturayan Apudyus, uray niyanà ta sikud wi miyanaana, nu foon à asin miyanà ta Ispiritun Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Na takuy iyanà na taku, siyan anà na sachi taku. Ngim na takuy asin miyanà, wi Ispiritun Apudyus na mangiyanà an siya, siya kon anà Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Achia maschaaw ta annayay mangifag-à wi masapur asin-ayu miyanà. ");
INSERT INTO ksc_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nalikat à maawatanyun miyanaan ta Ispiritun Apudyus, ngim màwa tan oyyoon na Ispiritun Apudyus. Na miyalikana, isun na poyaaw wi ayonan pionay ayon nu mamoyaaw. Maid akammuyù narpuwana ya umayana, ngim kikìnaonyun lumausana.” ");
INSERT INTO ksc_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ad anan Nicodemo, “Sinu kon annayay achì pu maawatan?” ");
INSERT INTO ksc_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ad anan Jesus an siya, “Tam-ako achi maawatan na annaya, wi nangatuay manudtuchun chitauy kanà Israel? ");
INSERT INTO ksc_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Siya ifakà an sian katuttuwaan, siya ukuchò na akammù ya innilà ngim achiyu pu tuttuwaon! ");
INSERT INTO ksc_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ilam, nu achiyu pu tuttuwaon na ifakà an chiayu mipangkop ta màmàwad asnay luta, sinchumallu nu ifakà na mipangkop ad langit. ");
INSERT INTO ksc_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Maid pu uchum à takù ummoy ad langit nu achi afus à saoni namfalin taku, tan siyan narpuwà. ");
INSERT INTO ksc_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Na nangisabrutan Moses ta sinan-urog ta pusti à manakuwana ta taku ta timpun na nanadchadcharanancha ta awi, amaschi kon misabrutà. ");
INSERT INTO ksc_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ad sinuy mamatin saon, maadchan à mannaynayuni fiyag.” ");
INSERT INTO ksc_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kapu ta amod na ayat Apudyus ta taku, impaalinan os-osàani Anàna wi matoy ad asnay luta, ta nu sinun mamatin siya, achi pu mifallu tan makafiyag an siyà ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Foon à manusaan Apudyus ta takun namaunana ta Anàna ta luta, ngim finaunna ta awad manaraknib ta taku. ");
INSERT INTO ksc_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Siyan sinumani mamatin siya, achi pu machusa. Ngim na foon pù mamati, nifafagkan machusaana kapu ta achina pu mamatiyan ta Anà Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Annayan kachusaan na taku: Ummalin Anà Apudyus ad asnay luta ta lawakanan somsomò na taku. Ngim na taku, un-unnoyonchan pangot nu sachi lawag tan lawing na oy-oyyooncha. ");
INSERT INTO ksc_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sinumani takuy mangwà lawing, kapilitani lawingonan lawag ya achi pu umamfuruy ta lawag tan mailan kinarawingna. ");
INSERT INTO ksc_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ngim na takuy mangwa ta ustu, siyan maryad wi umamfuruy ta sachi lawag, ad sachin mail-ana wi oyyoonan pion Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Narpas pun na sachi, à Jesus ya chiani wi disipulusna, ummoy-ani ta provinsiya wi Judea, ad iningkaw-anid aschi mamfunyag ta taku. ");
INSERT INTO ksc_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","À Juan wi Mamfufunyag, iningkaw ad Enon wi achanid Salem tan achun chanum ta sachi, ad finunyakana chachi takuy umoy an siya pafunyag. ");
INSERT INTO ksc_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Na sachi timpu, chaan pù mifarud à Juan. ");
INSERT INTO ksc_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Na sachi, nakasongsongfat na uchumi disipulus Juan ta osay Judio mipangkop ta funyag. ");
INSERT INTO ksc_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Siyan ummoy chachi disipulus Juan an siya, ad imfakachan siya, “Misturu, na sachi taku wi impachamagnun chiani, wi namfurunnu ta iningkawantau losan ta chomangon Jordan, mamfunyag ako ta sana, ad siyan umayan losan na taku!” ");
INSERT INTO ksc_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ngim summongfat à Juan, wi anana, “Achiayu maschaaw ta amaschi, tan maid pu takù makàwa ta oyyoona nu foon pù iparufus Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Chingngoryun imfagfakà wi foon à saon na Cristu, ngim nipaunaà wi mangifaka ta taku ta mansakanachay mamatin siya. ");
INSERT INTO ksc_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Na miyisuwana, isun na larai wi mangasawa ta fufai wi siyan mansakungan na sachi wi fufai, foon pù sachi mangwa ta man-asaw-ancha. Ad na sachi nangwa, chochongronan ifakan na sachi larai, ad maragsakan ta mantipunan na man-asawa. Siyan isù saon na nangwà nangasaw-an na sachi larai, ad naragsakà wi mangiila ta umayan na taku an Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tan à siya, kapilitani ngumatngatu, ngim à saon, fumafaà.” ");
INSERT INTO ksc_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ad inturuy Juan wi anana, “Na sachi narpud langit, siyan angatuwan. Ngim na narpud asnay luta, taku kay wi annay luta kan pagpag na akammuna. Ngim na sachi narpud langit, nangatngatu nu losani ingkaw ta annay luta. ");
INSERT INTO ksc_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ya ifakana kon losani innilana ya chingngorna, ngim sin-oosa kan mamatin siya. ");
INSERT INTO ksc_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ngim na mamatiyan na losani mamati, sachin mangipail-ancha wi patiyoncha ko wi tuttuwan inukud Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Na sachi imfaun Apudyus, maid uchum à ug-ugkuchona nu achi afus na ukud Apudyus, tan iingkaw na Ispiritun Apudyus an siya. ");
INSERT INTO ksc_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Amod na ayat Apudyus wi Ama an Jesus wi Anàna, siyan impiyarnan sinuman an siya. ");
INSERT INTO ksc_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Siyan sinumani mamati ta Anàna, makafiyag an Apudyus à ing-ingkana. Ngim sinumani foon pù mamatin siya, achi pu makafiyag an Apudyus tan chusaon Apudyus à siyà ing-ingkana.” ");
INSERT INTO ksc_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Na chachi Fariseo, chingngorcha wi ad-achun summurut an Jesus ya finunyakana nu finunyakan Juan wi Mamfufunyag. ");
INSERT INTO ksc_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ngim na katuttuwaan, maid pu finunyakan Jesus, tan chiani wi disipulusna afus na namfunyag. ");
INSERT INTO ksc_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ngim chingngor pu Jesus na ug-ugkuchoncha, lummayaw-ani ad Judea ad nangulin-ani ta sakup Galilea. ");
INSERT INTO ksc_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ad nangoy-ani ta provinsiya wi Samaria. ");
INSERT INTO ksc_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ad chummatong-ani ta osay ilid Samaria, wi Sicar, wi achani ta sachi lutay innadchon Jacob an anànay Jose ta awi, ");
INSERT INTO ksc_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","wi siya kon awachan na sachi fufun wi inaufan Jacob. Ad à Jesus, tummùchu ta sachi tan naungar ta nanadcharananni, tan akimmamatuon. ");
INSERT INTO ksc_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ngim à chiani wi disipulusna, ummoy-ani ta ili nguminà anonni. Na sachi timpu, ummoy na osay fufai wi iSamaria manàchu ta sachi fufun, ad anan Jesus an siya, “Mafalini uminumà ta sanati sinàchum?” ");
INSERT INTO ksc_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Naschaaw chi fufai, tan na Judio, achicha pu usaron na tasan na iSamaria. Siyan anana, “Tamakò siay Judio, man-achaw-à chanum an saon wi iSamaria?” ");
INSERT INTO ksc_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ad summongfat à Jesus wi anana, “Nu inakammum na mafalini adchon Apudyus an sia, ad nu inakammum ako nu sinuwà wi man-achaw à chanum an sia, sian man-achaw an saon ta adchà sià chanum wi nu inumom, foon pù asin-a mauwaw à ing-ingkana.” ");
INSERT INTO ksc_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ad anan na fufai, “Apu, maid mangkaudnu ta annayay chanum, ad lofongan na annayay fufun? Ad sinun mangar-am ta chanum wi anami nu inumò, foon pù asinà mauwaw? ");
INSERT INTO ksc_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tan na annayay fufun, finòan na aputauy Jacob ta awi ad imparàsunnan chitau. Ya sana kon nanakun chichay man-aama ya uray animarna. Ad anami nangatngatua nu siya wi napatpatog na chanumnu?” ");
INSERT INTO ksc_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ad summongfat à Jesus, “Losani takuy manginum ta chanum na annayay fufun, asincha mauwaw. ");
INSERT INTO ksc_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ngim na manginum ta chanum wi adchò, foon pù asin mauwaw à ing-ingkana, tan na chanum wi adchò, makarong-ag an siyà isù chagsi wi achi pu madchù, ad adchona kon mannaynayuni mafiyakanan Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Sachi ad anan na fufai, “Apu, adchanà ta sanati chanum ta achiyà pu mauwaw ya achiyà pu ko umalialid asna manàchu.” ");
INSERT INTO ksc_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ad anan Jesus, “Ing-a ayakan à asawam ta umaliayud asna.” ");
INSERT INTO ksc_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Maid pu asawà,” anan na fufai. Ad anan Jesus, “Tuttuwan imfakam wi maid pu asawam, ");
INSERT INTO ksc_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","tan liman inasawam, ya na sachi iingkaw an sia ta sana, foon pù ustuy asawam. Siyan tuttuwan imfakam wi maid pu asawam.” ");
INSERT INTO ksc_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ad anan na fufai, “Apu, mailasin-u wi profetaa. ");
INSERT INTO ksc_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ngim na aappuni ta awi, annayay filig na nanaychayawanchan Apudyus. Ngim chiayuy Judio, ananyuy Jerusalem na ustuy manaychayawan na taku an Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Sachi ad anan Jesus ta fufai, “Patiyom kuman ifakà, wi chumatong na timpuy foon à annayay filig ya foon akò Jerusalem na manaychayawan na taku an Ama wi Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Chiayuy iSamaria, maid akammuyù Apudyus wi ananyuy chaychayawonyu. Ngim à chiani wi Judio, akammunin chayawonni, tan na Judio, chichan fumùnakan na manaraknib ta losani taku. ");
INSERT INTO ksc_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ngim chummatong na timpuna, wi manipud ta sana, sinumani manayaw an Ama wi Apudyus à ustu, masapur chayawonà siya ta tuttuway somsomòna wi foon pu kà tupòna, tan sachin pion Ama wi oyyoon na manayaw an siya. ");
INSERT INTO ksc_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tan à Apudyus, ispiritu wi achi pu maila, siyan chachi manayaw an siya, masapur foon à ipàpàilacha tan marpu kay ta somsomò wi sachin marpuwan na tuttuway chayaw.” ");
INSERT INTO ksc_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Sachi ad anan na fufai, “Akammù wi à tapin na padcha, umalin sachi impustan Apudyus wi ipaalina, wi ananchay Cristu. Ad à siya, itudtuchunan losani maid akammutau.” ");
INSERT INTO ksc_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ad imfakan Jesus an siya, “Saon wi makaukud an sia, saon na Cristu.” ");
INSERT INTO ksc_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Sachi ad, chummatong-ani wi disipulus Jesus. Ad nataag-ani wi nangchas an Jesus wi nakaukud ta fufai. Ngim maid nansarudsud an chiani nu sinun masapur na sachi fufai winnu tamako nakaukud à Jesus an siya. ");
INSERT INTO ksc_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Sachi ad, tinaynan na sachi fufain sasàchuwana ad ummoy ta ili. Ad imfakana ta taku, ");
INSERT INTO ksc_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Wayyu, intau ilan na anchi larai wi nangifakan saon ta losani iningwà. Siya nin na Cristu!” ");
INSERT INTO ksc_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Sachi ad lummigwatcha losan wi umoy mangilan Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Na sachi ko, àaruonnì Jesus, wi ananni, “Apu, taako achi mangan!” ");
INSERT INTO ksc_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ngim summongfat à siya, “Awad na innan-u wi maid akammuyu.” ");
INSERT INTO ksc_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ad nan-asisarudsud-ani, anani, “Awad nangiyalì innanna?” ");
INSERT INTO ksc_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ngim nan-alig à Jesus, wi anana, “Na anò, siyan mangwaà ta pion Apudyus wi nangifaun an saon, ya mangangputà mangwaan ta sachi impiyarnan saon. ");
INSERT INTO ksc_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Awad na ananyu wi nu marpas na opat furan, siyan inyàani. Ngim na ifakà an chiayu, sanan inyàani. Tan ilanyun anchanayay takuy umali, wi isuchà nar-umi pakoy, wi sana kuman mamatiyanchan saon! ");
INSERT INTO ksc_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ya chachi takuy umoy mangitudtuchu ta mamatiyan na uchum, isuchà man-ani, ya à chicha, matangchanancha. Ya foon pu kò afuschi, tan mannaynayun na aniyoncha. Ad na mammura, isun na man-ani wi losancha maragsak. ");
INSERT INTO ksc_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tan tuttuwan ifakachay, ‘Na uchum, chichan mammura, ad na uchum ako, chichan man-ani.’ ");
INSERT INTO ksc_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Siyan ifaun-u chiayù umoy mangani ta immuran na uchum. Ad sachin mitapiyanyu ta iningwacha.” ");
INSERT INTO ksc_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Achun iSamaria wi namatin Jesus ta sachi ili kapu ta nangifag-an na sachi fufai wi imfakan Jesus na losani iningwana. ");
INSERT INTO ksc_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Siyan chummatong pun na chachi iSamaria an Jesus, tinawichanchà siya ad iningkaw à naawwa. ");
INSERT INTO ksc_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ad ummad-adchuwan akon namatin Jesus ta nangngorancha ta intudtuchuna. ");
INSERT INTO ksc_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ad imfakacha ta sachi fufai, “Foon pu kà sachi inug-ugkudnun pummatiyanni tan chingngornin ustuy intudtuchuna, ad sinikurachuni wi siyan tuttuway imfaun Apudyus à manaraknib ta losani taku.” ");
INSERT INTO ksc_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Narpas pun na chuway padcha, lummigwat-ani wi umoy ad Galilea wi chummakran Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Mipangkop ta ummayannid aschi, anan Jesus, “Uray sinuy profeta, foon à chayawon na kailiyanà siya.” ");
INSERT INTO ksc_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ngim chummatong-ani pun ad Galilea, naragsak na taku wi mangilan Jesus, tan à chicha, nakafiyastachad Jerusalem ad innilacha losan na kaskaschaaw wi iningwanad aschi. ");
INSERT INTO ksc_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Sachi ad, nangulin-anin Jesus ad Cana wi sakup Galilea, wi sachin namfalinonan chanum à fayas. Ad niyaspur wi iningkaw ta sachin osay pangat wi nasakit na anàna ad Capernaum. ");
INSERT INTO ksc_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Chingngorna ad wi awad à Jesus ad Galilea, wi narpud Judea, ummoyna inayakan à siya ta umoy kuma ad Capernaum ta aanonan sakit na anànay akin-ottoyon. ");
INSERT INTO ksc_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ad anan Jesus an siya, “Tuttuway foon pù mamatiayu nu maid ilanyù singyar ya kaskaschaaw?” ");
INSERT INTO ksc_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ngim anan na pangat, “Apu, ipangpangngaasim ta umalia ta achi matoy na anàu!” ");
INSERT INTO ksc_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Anan Jesus an siya, “Ing-a, tan naaan na sakit na anànu!” Ad pinatinan imfakan Jesus, ad lummayaw. ");
INSERT INTO ksc_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ad na ummayawana, sinib-atnan sasannilunay ummoy mangifaka wi kumminò na sakit na anàna! ");
INSERT INTO ksc_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ad sinarudsudna nu sinun uras wi kummin-an na sakitna, ad anancha, “Mantalliing ad karabyan, sachin naaanan na puchutna.” ");
INSERT INTO ksc_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ad simsimmò na sachi ama chi ustuustuy uras wi nangifag-an Jesus an siya, “Naaan na sakit na anànu.” Siyan losanchay simfaryan, namatichan Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Sachin miyagway kaskaschaaw wi iningwan Jesus ad Galilea, nanipud ta nangulinanchad Galilea wi narpud Judea. ");
INSERT INTO ksc_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Naarkawanan ad, ummoy-anin Jesus ad Jerusalem makafiyasta ta osay fiyastani wi Judio. ");
INSERT INTO ksc_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ad Jerusalem, awad na osay puung wi na ngachanna ta Hinebreo wi ukud, Betsata. Na sachi puung, achani ta liwangan na ili wi mangiparnoancha ta pannilu, ad nalìwos à limà sigsigkay ");
INSERT INTO ksc_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","wi umichungan chachi achuy takuy nan-ob-ofot na sakitcha: anchanan nakurap, napilay ya naayayong. Iingkawcha uullayon na mantipyaawan na chanum, ");
INSERT INTO ksc_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","tan nu simfofotang, man-osog anun anghel Apudyus ad mantipyaawonan sachi puung, ad na umuna umoy ta sachi nantipyaaw wi chanum, maaan anun uray sinuy sakitna. ");
INSERT INTO ksc_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ad iningkaw na osay larai wi ummoy à turumpuru ya waruy tawon na nasakitana. ");
INSERT INTO ksc_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ad innilan Jesus à siya ad illasinnay nafayag na nifafannatana, ad anana, “Piom wi maaan na sakitnu?” ");
INSERT INTO ksc_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","“Oo, Apu,” anan na sachi nasakit, “ngim maid pu manurung an saon wi umoy ta puung nu mantipyaaw na chanum, ad kapu ta mamàanun kunay-uy umoy, maunnaunnaanà nu chaanà pu michaum ta chanum.” ");
INSERT INTO ksc_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Sachi ad anan Jesus an siya, “Fumangon-a ad aram na ofognu ya nanadcharan-a!” ");
INSERT INTO ksc_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ad na sachi, naaan tuwan sakitna, siyan finuudnan ofogna pun nanadcharan. Na nàwaan na sachi, Safachu, wi ngingillinani padchan na Judio wi man-iwaar. ");
INSERT INTO ksc_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Siyan chachi pangpangun na Judio, inomoranchan sachi naaan na sakitna, anancha, “Ngingillinantaun sana, siyan mipalit ta Lintogtaun mamuucham ta ofognu.” ");
INSERT INTO ksc_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ad summongfat na sachi naaan na sakitna, wi anana, “Oo, ngim na sachi takuy nangaan ta sakit-u, siyan nangifakan saon wi fuuchò na ofog-u ya manadcharanà.” ");
INSERT INTO ksc_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ad inimuscha, “Sinun kinatatakun na sachi, wi nangifakan sia ta amaschi?” ");
INSERT INTO ksc_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ngim na sachi naaan na sakitna, maid akammuna nu sinù Jesus, tan lummayaw à Jesus tan ad-adchuwan na takuy niyamung. ");
INSERT INTO ksc_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Napapannos pun, inchasan Jesus à siya ta Templo, ad anana, “Ilam, fummarun long-agnu tan naaan na sakitnu, siyan iyakaynuy fumasur tan sin-umamod na asin màwan sia.” ");
INSERT INTO ksc_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Sachi ad, lummayaw na sachi larai ad ummoyna imfaka ta chachi pangpangun na Judio wi Jesus na nangaan ta sakitna. ");
INSERT INTO ksc_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Siyan chachi pangpangu, illukichay palikatan à Jesus kapu ta nangaanana ta sakit ta timpun na ngingillinan. ");
INSERT INTO ksc_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ngim sinongfatan Jesus à chicha, “À Ama wi Apudyus, foon à man-illong ta iwaarna, ad amaschiyà ako.” ");
INSERT INTO ksc_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ad naam-amod na og-ot chachi pangpangun na Judio an Jesus, ad pionchay mamatoy an siya kapu ta nanurngasingana ta ngilin ya kapu ko ta mangiyisuwana ta long-agnan Apudyus ta nangifag-ana wi Apudyus anun Amana. ");
INSERT INTO ksc_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Sachi ad anan Jesus ta chachi Judio, “Tuttuwan ifakà an chiayu: saoni Anà Apudyus, maid pu fugtungà oyyoon, tan siya oyyoò yakan innilà wi oy-oyyoon Ama. Siyan na losani oyyoon Ama, siya kon oyyoò. ");
INSERT INTO ksc_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tan à Ama, ay-ayatonà saoni Anàna, siyan na losani oyyoona, ipailana kon saon. Ya awad akon ipàwanan saon wi isag kaskaschaaw nu sachi innilayu à maschaawanyu. ");
INSERT INTO ksc_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tan à Ama, mafalini ipaulinan fiyag na natoy. Siyan uray saoni Anàna, mafalin akoy takuwò na sinuy taku wi piò wi takuwon. ");
INSERT INTO ksc_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ya foon pu kò Aman manguis ta taku, tan piniyarnà saon à manguis ta losani taku, ");
INSERT INTO ksc_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ta chayawon losan na takù saon wi isun na manayawanchan Ama. Siyan sinumani achi pu manayaw an saon, foon pu kò chayawonà Ama wi nangifaun an saon. ");
INSERT INTO ksc_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Tuttuwan ifakà an chiayu: sinumani mangngor ta itudtuchù ya mamatin siyay nangifaun an saon, makafiyag an Apudyus à ing-ingkana. Ya achi pu ko machusa tan illisiyanan mifalluwana, tan annan fiyagnay narpun Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tuttuwan ifakà an chiayu: chummatong na timpu wi manipud ta sana, chachi isù nanattoy an Apudyus, nu chongronchan ifakà wi Anà Apudyus ad pinaticha, takuwò chicha ta makafiyagchan Apudyus à ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","À Ama, siyan narpuwan na fiyag. Ad piniyarnà saon wi Anànà marpuwan akon fiyag. ");
INSERT INTO ksc_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ad impiyarna kon saon na karobfongà wi manguis ta taku, tan à saon, namfalinà taku. ");
INSERT INTO ksc_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Achiayu maschaaw ta annayay ifakà wi chumatong na timpuy uray na losani nilofon, chongronchan ukud-u, ");
INSERT INTO ksc_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ad umulicha mataku. Siyan na losani nangwà mamfaruwon Apudyus, makafiyagchan siyà ing-ingkana. Ngim na losani nangwà lawingon Apudyus, makafiyagcha kò ing-ingkana ta kachusaancha.” ");
INSERT INTO ksc_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ad inturuy Jesus wi mangifaka, “Saon, siya kay oyyoò na nipiyar an saon. Siyan maid pu oyyoò à sinuman nu foon pù maatod na karobfongà wi mangwa. Ad na manguisà ta taku, turachò akon ifakan Ama, siyan kapilitani nalimpiw na manguisà ta taku tan maid pu fugtungà oyyoon ngim siyan pion na nangifaun an saon. ");
INSERT INTO ksc_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Nu saon afus na mangistiku ta long-ag-u, maid pu manuttuwan saon. ");
INSERT INTO ksc_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ngim awad na osay mangistiku an saon, ya akammù wi ifakanan katuttuwaan mipangkop an saon wi siyà Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Iningkaw akon imfaunyu wi nangimus an Juan mipangkop an saon, ad imfakana kon katuttuwaan. ");
INSERT INTO ksc_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Foon pù kasapurà na takù mangistiku an saon, ngim na nangipaspasmoà an chiayu ta imfakan Juan, ta mamatiayu kuma ta masaraknifan-ayu. ");
INSERT INTO ksc_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Tan na miyalikan Juan, silaw wi nangongogkan, ngim sin-aitan yakan naryachanyu ta lawagna tan sin-aitan na naryachanyu ta imfakana. ");
INSERT INTO ksc_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ngim awad na mangistiku an saon ta sana wi napatpatog nu sachi nanàchoran Juan an saon, wi chichan oy-oyyoò wi impiyar Ama wi oyyoò. Ad chichan manuttuwaan wi siyan nangifaun an saon ad asnay luta. ");
INSERT INTO ksc_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ad à Ama wi nangifaun an saon, mangistiku kon saon. Ngim chiayu, maid pu chingchingngoryu ta ukudna ya maid pu ko innil-ilayù itchurana. ");
INSERT INTO ksc_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ad maid pu iningkaw à ukudna ta somsomòyu tan foon pù patiyonyù saon wi imfaunna. ");
INSERT INTO ksc_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Siya achaacharonyun niyug-is wi ukud Apudyus, tan na somsomòyu, sachin mitapiyanyun siya, ngim siya kon mangifaka ta mipangkop an saon! ");
INSERT INTO ksc_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ngim uray nu amaschi, achiayu pu mamatin saon ta makafiyag-ayu an Apudyus à ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Achì pu anapon na machayawà ta taku. ");
INSERT INTO ksc_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ngim akammù na kinatatakuyu, wi maid pu ayatyu an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Saon, ummaliyà ad asnay luta wi à Aman namiyar an saon. Ngim achiyà pu ifilang an chiayu. Ngim nu kaspangalikan awad takù fummugtung umali, wi piniyarnan long-agna, sachin ifilangyu. ");
INSERT INTO ksc_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","In-inonyuy mamatin saon, wi siya anaponyun manayawan na takun chiayu ad achiyu pu anapon na manayawan Apudyus an chiayu. ");
INSERT INTO ksc_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Achiyu anan wi saon na mampafasur an chiayu an Ama wi Apudyus, tan à Moses wi manamnamayu, siyan mampafasur an chiayu tan foon pù tuttuwaonyun inyug-isna. ");
INSERT INTO ksc_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tan nu tinuttuwayun inyug-is Moses, tuttuwaonyu kò saon, tan na inyug-isna, mipangkop an saon. ");
INSERT INTO ksc_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ngim kapu ta achiyu pu tuttuwaon na inyug-isna, kapilitani achiyu pu kò saon tuttuwaon!” ");
INSERT INTO ksc_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Sachi ad, nanchormang-anin Jesus ta Fayfay wi Galilea wi anancha koy Tiberias; ");
INSERT INTO ksc_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ad ad-adchuwan na takuy nitun-ud kapu ta nangil-ancha ta kaskaschaaw wi iningwan Jesus ta nangaanana ta sakit. ");
INSERT INTO ksc_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ad tinakachanin Jesus na osay takudtud, ad ummaamuy-ani. ");
INSERT INTO ksc_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na sachi timpu, machanchanin padchay Mangiyakasmoan. ");
INSERT INTO ksc_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ad nallangrangà Jesus, ad innilana chachi ad-adchuwani takuy marungay, ad ananan Felipe, “Sinun ngumin-antaù umanay à anon na anchanayay taku?” ");
INSERT INTO ksc_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Inakammun Jesus na oyyoona, ngim na nangimusana, ta akammuwonan somsomò Felipe. ");
INSERT INTO ksc_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ad anan Felipe, “Uray nu mangkastutaù chuwangkasut à pilak, foon à umanay ta manimsimancha.” ");
INSERT INTO ksc_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Sachi ad nan-ukud à Andres wi sunud Pedro, wi anana, ");
INSERT INTO ksc_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Annan osay fafaruy namfarun à limà tinapoy ya chuwà filis. Ngim umanay lawachì para ta anchanayay takuy ad-adchuwan?” ");
INSERT INTO ksc_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ad anan Jesus an chiani, “Paachuyonyun taku.” Sachi ad ummachuycha losan ta tappu. Ummoy à limay lifun lallarai, wi foon à mifilang na fubfufai ya an-ananà. ");
INSERT INTO ksc_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ad innaran Jesus na tinapoy ad nanyaman an Apudyus achinaot pafillay ta takù anoncha. Ad amaschi kon iningwana ta filis, ad nabsug losan na takuy ad-adchuwan. ");
INSERT INTO ksc_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nangancha pun, imfakan Jesus an chiani wi disipulusna, “Chakuponyun funacha ta maid machachail.” ");
INSERT INTO ksc_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ad chinakupnin funan na taku, ad nasawaran à chuway langayan napnu ta nafun-an ta sachi limay tinapoy. ");
INSERT INTO ksc_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Na nangil-an chachi taku ta sachi kaskaschaaw wi iningwan Jesus, anancha, “Siyan sachi profetay uullayontau wi anan Apudyus wi ipaalina ad asnay luta!” ");
INSERT INTO ksc_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Inakammun Jesus na somsomò chachi taku wi tikangaycha ipatut à siya man-aliyon, siyan tinaynana chicha ad naos-osa wi ummoy ta osay takudtud. ");
INSERT INTO ksc_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Mummaschom pun, ummoy-ani wi disipulusna ta tarantag na fayfay. ");
INSERT INTO ksc_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Fummulingot ad, chaan pù mangulin à Jesus, siyan nallukan-ani ta fangka wi manchormang ad Capernaum. ");
INSERT INTO ksc_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Na nallurugkananni, chummatong na napigsay fali, siyan mantiptipyaaw na chanum. ");
INSERT INTO ksc_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Onom ad wi kilometron chinormangni, innilanì Jesus wi manadchadcharan ta lafaw na chanum wi umachanin chiani, ad ummogyat-ani isag. ");
INSERT INTO ksc_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ad nan-ukud à Jesus wi anana, “Saonna! Achiayu umogyat!” ");
INSERT INTO ksc_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ad naragsak-ani wi mangiparnò an siya. Na sachi ko, chummatong-ani ta tarantag na ili wi umayanni. ");
INSERT INTO ksc_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Na sachi wi nafikat, chachi takuy nataynan ta chomang, illasincha wi os-osàan yakan fangka wi iningkaw ta sachi ta maschom, wi sachi kon nallukananni wi disipulus Jesus, ad inakammucha koy foon à nakarukan à Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ad chummatong na uchumi fangka wi narpud Tiberias, ta achani ta ikaw wi namaanan Jesus ta chachi ad-adchuwan ta narpasana nanyamanan an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ad kapu ta naakammuwan ta chachi nataynan wi taku wi maid à Jesus, ya maid-ani ko wi disipulusna, nallukancha ta fangka ad nanchormangcha wi ummoy ad Capernaum wi manganap an Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Chummatongcha ad ta chomang, inchasanchà Jesus ad anancha, “Misturu, naanun ummaliyam sina?” ");
INSERT INTO ksc_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ad anan Jesus an chicha, “Payuko anaanapon à saon? Tuttuwan ifakà an chiayu: maid uchum à manganapanyun saon nu achi afus na sachi iningwà wi nabsukanyu, wi foon à kapu ta naawatanyun puntus na iningwà. ");
INSERT INTO ksc_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Foon pu kumà maan wi mabsukanyun afusi anaanaponyu, tan mapapog. Ngim na anaponyu kuma, sachi maan wi mannaynayun wi sachi mangatod ta mafiyakan an Apudyus à ing-ingkana. Ad sachin maan wi adchò an chiayu, tan sachin impiyar Ama wi Apudyus an saoni namfalin taku, à oyyoò.” ");
INSERT INTO ksc_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Siyan anan chachi taku an Jesus, “Sinun in-inonni nù ta oyyoonnin pion Apudyus?” ");
INSERT INTO ksc_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ad summongfat à Jesus wi anana, “Na pion Apudyus wi oyyoonyu, masapur patiyonyù saon tan saon na imfaunna.” ");
INSERT INTO ksc_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ad anancha, “Ngim sinun oyyoom wi kaskaschaaw ta awad manuttuwaanni à mamatiyannin sia? Awad kuman ipailam, ");
INSERT INTO ksc_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","tan ilam, na chachi aapputau ta awi, iningkaw na sachi manna wi anoanoncha ta iningkawancha ta ikaw wi nanadchadcharanancha. Tan na niyug-is, anana, ‘Pinaanana chichà maan wi narpud langit.’” ");
INSERT INTO ksc_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ad anan Jesus, “Tuttuwan ifakà an chiayu: na sachi innadchon Moses, foon pù tuttuway maan wi narpud langit. Tan na adchon Ama ta sana, sachin tuttuway maan wi narpud langit. ");
INSERT INTO ksc_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Na maan wi innadchon Apudyus ta sana wi langit na narpuwana, sachin mamiyag ta takù ing-ingkana.” ");
INSERT INTO ksc_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ad anan chachi takun siya, “Apu, adchom an chianin annay maan kanayun.” ");
INSERT INTO ksc_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Sachi ad illawag Jesus na inukudna wi anana, “Saon na maan wi mamiyag ta takù ing-ingkana, ad na miyalikana, sinumani mamatin saon, achi pu mafitil ya achi pu ko mauwaw. ");
INSERT INTO ksc_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ngim tuttuwan sachi imfakà an chiayu, wi uray ilailanyun oyyoò, foon pù patiyonyu. ");
INSERT INTO ksc_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ngim na losani takuy piniliyan Ama à mamatin saon, tuttuway mamaticha. Ya losani mamatin saon, akseptarò chicha losan. ");
INSERT INTO ksc_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tan saoni narpud langit, foon à ummaliyà ad asnay luta wi mangwa kay ta piò, tan ummaliyà à mangwa ta pion na sachi nangifaun an saon. ");
INSERT INTO ksc_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ad na piona, ta losani piniliyanà mamatin saon, maid pu osà matarà an chicha, ya ta ipaulì chicha losan takuwon nu chumatong na anungus na padcha. ");
INSERT INTO ksc_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tan pion Ama wi na losani mamati wi saon na Anàna ya saon akon patkoncha, makafiyag an saon à ing-ingkana, tan ipaulì chicha takuwon ta sachi anungus wi padcha.” ");
INSERT INTO ksc_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Na nangngoran na taku ta inukud Jesus, wi siyan maan wi narpud langit, ngummayutngutcha. ");
INSERT INTO ksc_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ad anancha, “Tuttuway Jesus na annaya, wi anàcha Maria an Jose wi akammutau. Siyan apay ananay narpù siyad langit nù?” ");
INSERT INTO ksc_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ad summongfat à Jesus wi anana, “Achiayu ngumayngayutngut, ");
INSERT INTO ksc_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","tan maid pu osà mamatin saon nu foon à Ama wi nangifaun an saon na manurung ta somsomònà mamatiyana. Ad chachi mamatin saon, ipaulì chicha takuwon nu chumatong na anungus na padcha. ");
INSERT INTO ksc_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Awad akon inyug-is na profetas ta awi, wi anancha, ‘Tudtuchuwan Apudyus na losani taku.’ Siyan sinumani takuy mangngor ta imfakan Ama ad pinaticha, kapilitani mamati kon saon. ");
INSERT INTO ksc_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Achì pu anani awad takù nangilan Ama ad langit, tan saon yakan nangilan siya, tan siyan narpuwà. ");
INSERT INTO ksc_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tuttuwan ifakà an chiayu: sinumani takuy mamatin saon, makafiyag an Apudyus à ing-ingkana, ");
INSERT INTO ksc_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","tan saon na maan wi mangatod à mannaynayun à fiyag. ");
INSERT INTO ksc_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Na aappuyu ta awi, innanchan sachi manna ta iningkawancha ta ikaw wi nanadchadcharanancha, ngim isunay natoycha. ");
INSERT INTO ksc_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ngim sinumani mangan ta mannaynayuni maan wi tuttuway narpud langit, achi pu matoy à ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Saon na mannaynayuni maan wi narpud langit. Siyan sinumani mangan ta annayay maan, makafiyag an Apudyus à ing-ingkana. Ad na maan wi adchò an siya, long-ag-u wi siyan maatod à mamiyag ta losani takud asnay luta.” ");
INSERT INTO ksc_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Imfakan pu Jesus na sachi, nansusukob chachi taku, wi anancha, “Sinun in-inon na annayay takuy mangipaan ta long-agnan chitau?” ");
INSERT INTO ksc_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ad anan Jesus an chicha, “Tuttuwan ifakà an chiayu: nu achiyu pu anon na long-ag-uy anà Apudyus wi namfalin taku, ya nu achiyu pu ko inumon na charà, achi pu mafalin wi makafiyag-ayun Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ngim sinumani mangan ta long-ag-u ya manginum ta charà, makafiyag an Apudyus à ing-ingkana, ya ipaulì akon fiyagna nu chumatong na anungus na padcha. ");
INSERT INTO ksc_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tan na long-ag-u, sachin tuttuway maan, ad na charà, sachin tuttuway mainum, wi mamiyag ta takù ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Siyan sinumani mangan ta long-ag-u ya manginum ta charà, ingkaw an saon à ing-ingkana ya ingkawà akon siya. ");
INSERT INTO ksc_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","À Ama wi nangifaun an saon, sikud wi natattaku. Ad mipakapun siya, nisikud akon natakuwà. Siyan sinumani mangan ta long-ag-u, mafiyag akò ing-ingkana tan saon na mamiyag an siya. ");
INSERT INTO ksc_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Siyan saon na ustuy maan wi narpud langit, wi foon à isun na sachi maan wi innan chachi aappuyu wi isunay natoycha. Tan na sinumani mangan an saon, makafiyag an Apudyus à ing-ingkana.” ");
INSERT INTO ksc_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Imfakan Jesus na anchanaya ta nantudtuchuwana ta sinagoga wi makimkimungan na Judio ad Capernaum. ");
INSERT INTO ksc_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Na achuy mamatin Jesus, chingngorcha ad na sachi intudtuchuna, ngummayan somsomòcha, ad anancha, “Sinu kon mamangngor ta annayay ifakanay nalikat à somsom-on?” ");
INSERT INTO ksc_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ngim à Jesus, inakammuna wi ngummayngayutngutcha, siyan anana, “Afus yakayna, ad inyakayyuy mamatin saon? ");
INSERT INTO ksc_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Sinu kon somsomòyu nu ilanyù saoni namfalin taku, wi mamagkulin ad langit wi narpuwà? ");
INSERT INTO ksc_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tan na narpuwan na mannaynayuni fiyag na taku, siyan Ispiritun Apudyus, wi maid silfin na losani oyyoon na taku. Ya chachi imfakà an chiayu, sachin mangawatanyu ta Ispiritun Apudyus ya sachi kon mamiyag an chiayù ing-ingkana.” ");
INSERT INTO ksc_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nanipud ta chamu, inakammun Jesus nu sinun achi pu mamatin siya, ad inakammuna kon mangififik an siya. Siyan anana ko, “Ngim awad na uchum an chiayu wi foon à mamatin saon. ");
INSERT INTO ksc_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ad sachin nangifag-à an chiayu wi maid osà mamatin saon nu foon à Aman manurung ta somsomòna wi mamati.” ");
INSERT INTO ksc_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nanipud ta sachi, achun nangiwarang wi mitun-ud an Jesus wi nan-awichanchà siya. ");
INSERT INTO ksc_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Siyan anan Jesus an chiani wi simpuru ya chuway disipulusna, “À chiayu, iwarangyu koy mituntun-ud an saon?” ");
INSERT INTO ksc_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ad summongfat à Simon Pedro wi anana, “Apu, sinun safalì mitun-uchanni nù? Sia afus na mangitudtuchu ta mipangkop ta mannaynayuni mafiyakan an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Siyan sinikurachuni wi sian Anà Apudyus wi impaalinad asnay luta wi manturay.” ");
INSERT INTO ksc_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Sachi ad anan Jesus, “Saon, piniliyà chiayuy simpuru ya chuwa, ngim awad na osan chiayuy inuwan Satan!” ");
INSERT INTO ksc_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Siya imfakan Jesus na mipangkop an Judas wi anà Simon Iscariote, tan uray siyan osan chichay simpuru ya chuway disipulus Jesus, siyan mangififik an siya. ");
INSERT INTO ksc_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nanipud ta sachi, foon pù mangkagkaay à Jesus ta provinsiya wi Judea, tan inakammuna wi anaanapon chachi pangpangun na Judio na mamatoyanchan siya. Siya kan provinsiya wi Galilean nangkagkaayana. ");
INSERT INTO ksc_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Machanchanin osay fiyastan na Judio wi ananchay “Sikay”, ");
INSERT INTO ksc_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ad anan na susunud Jesus an siya, “Taako achi lumigwat wi umoy makafiyasta ad Judea ta ipailam na kaskaschaaw ta chachi sumurut an sia? ");
INSERT INTO ksc_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tan maid takù mangitaru ta oy-oyyoona nu pionay mampaakammu ta long-agna. Siyan nu kaskaschaaw na oyyoom, ipailam ako ta atakutaku!” ");
INSERT INTO ksc_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Amaschin imfakan na susunud Jesus tan uray à chicha, chaancha pù mamatin siya. ");
INSERT INTO ksc_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Sachi ad anan Jesus an chicha, “Oo, ngim chaan pù chumatong na ustuy timpu wi mampail-à. Ngim à chiayu, mafalin wi farangnan timpuy mampail-anyu, ");
INSERT INTO ksc_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","tan na takud asnay luta, foon à kuraon chiayu. Ngim saon, kuraonà an chicha tan ifakà na kinarawing na oy-oyyooncha. ");
INSERT INTO ksc_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Siyan ing-ayu makafiyasta. Foon pù mifurunà an chiayu, tan chaan pù chumatong na ustuy mampail-à.” ");
INSERT INTO ksc_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Sachin imfakan Jesus ad nataynan ta provinsiya wi Galilea. ");
INSERT INTO ksc_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Sachi ad wi lummigwat na susunudna wi umoy makafiyasta, nan-ag-agkaaw nitun-ud à Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Chachi pangpangun na Judio wi nakafiyasta, anaanaponchà Jesus, wi anancha, “Sinun awachan Jesus?” ");
INSERT INTO ksc_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ad-adchuwan na taku ta sachi fiyasta wi nangiyakasaas ta mipangkop an siya. Na uchum, anancha, “Mamfarù Jesus.” Ngim na uchum, anancha, “Foon, tan turtulliyanan taku.” ");
INSERT INTO ksc_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ngim chachi mangug-ugkud ta mipangkop an Jesus, foon à ipagngorchan ifakacha tan ummogyatcha ta pangpangun na Judio. ");
INSERT INTO ksc_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nangkinawa ad na fiyasta, ummoy à Jesus ta Templo wi mantudtuchu. ");
INSERT INTO ksc_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ad isag naschaaw chachi pangpangun na Judio, ad anancha, “Sinun nangacharana ta amasnay kinaraingna, wi foon pù man-uswila?” ");
INSERT INTO ksc_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ad anan Jesus an chicha, “Na itudtuchù, foon à somsomòun narpuwana tan narpun Apudyus wi nangifaun an saon. ");
INSERT INTO ksc_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ad sinumani takuy maryad mangwa ta pion Apudyus, mailasinna wi à Apudyus na marpuwan na itudtuchù, wi foon à somsomòun narpuwana. ");
INSERT INTO ksc_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tan na takuy siya itudtuchuna afus na narpu ta somsomòna, kapilitani siya kay anaponan machayawana. Ngim na takuy manganap à machayawan na nangifaun an siya, siyan nalimpiw wi maid turtullina.” ");
INSERT INTO ksc_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ad anana ko, “À Moses na nangatod ta lintog Apudyus an chitau. Ngim maid mamtog an chiayu ta sachi lintog, tan apay anaanaponyun mamatoyanyun saon nù?” ");
INSERT INTO ksc_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ad summongfat chachi taku wi anancha, “Narapang-a! Sinun mammammò wi mamatoy an sia?” ");
INSERT INTO ksc_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Sachi ad anan Jesus, “Afus na nangaanà ta sakit na osay taku, ad nataag-ayu. ");
INSERT INTO ksc_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ngim chiayu, markaanyu met na an-ananàyu uray nu Safachuy ngingillinan, tan sachin imfakan Moses wi màwa, ngim foon à Moses na nangiluki tan tinawidna ta aappuna. ");
INSERT INTO ksc_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Siyan nu mafalini mipamarkan anà ta ngingillinani Safachu ta achi masurngasing na sachi illintog Moses, taayuko umog-ot kapu ta nangaanà ta sakit na osay taku ta Safachu, à fumaruwan na fiyagna? ");
INSERT INTO ksc_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Achiyu anani lawing na iningwà, ta anaponyun kinafaruna.” ");
INSERT INTO ksc_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Sachi ad, anan na uchumi takud Jerusalem, “Sanat na takuy anaanapon na papangattau ta patoyoncha nu! ");
INSERT INTO ksc_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ad apay annaya met wi mantudtuchu ta sangwanan na taku ad maid oyyoonchan siya nù? Winnu nat-opcha wi tuttuway siyan Cristu wi impustan Apudyus wi umali? ");
INSERT INTO ksc_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ngim nu umalin Cristu, maid anu mangakammù marpuwana, ngim na sanati taku, akammutaun narpuwana.” ");
INSERT INTO ksc_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Sachi ad wi nantudtudtuchù Jesus ta Templo, chinakornan kingana, wi anana, “Tuttuway akammuyun narpuwà ya kinatatakù? Tan foon à fummugtungà wi ummalid asnay luta, tan finaunà ta sachi Katuttuwaan. Ngim chiayu, foon pù akammuyù siya. ");
INSERT INTO ksc_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ngim à saon, akammù à siya tan siyan narpuwà ya siyan nangifaun an saon.” ");
INSERT INTO ksc_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Imfakan pu Jesus na sachi, pion chachi pangpangu wi maniliw an siya, ngim maid pu nangwa tan chaan pu chumatong na timpuna. ");
INSERT INTO ksc_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ngim uray amaschin somsomò na uchum, achu ko kan namatin siya, ad anancha, “Siyan kattoi Cristu wi impustan Apudyus, tan awad lawa osà makàwà kaskaschaaw à isun na iningwana?” ");
INSERT INTO ksc_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Chachi Fariseo, chingngorchan akitùtù na taku mipangkop an Jesus, siyan à chicha ya chachi pangpangun na papachi, namfaunchà kuwarchà umoy maniliw an Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Sachi ad anan Jesus, “Sin-aitan yakan ingkawà an chiayu, ad mangulinà ta sachi nangifaun an saon. ");
INSERT INTO ksc_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Siyan uray nu anaponà an chiayu, achiayu pu makàchas an saon tan achiayu pu makaali ta umayà.” ");
INSERT INTO ksc_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Sachi ad nan-asisarudsud chachi pangpangun na Judio, anancha, “Sinu kon umayana wi achitau pu makàchas an siya? Winnu umoy ta chachi achayuy ikaw wi awachan na fufuruntauy nansississiyan, ta tudtuchuwana chachi foon à Judio? ");
INSERT INTO ksc_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Tan tanako anani anapontaù siya? Ya sinun sachi ananay achitau pu makàchas an siya, ya achitau pu ko makaoy ta umayana?” ");
INSERT INTO ksc_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Na anungus wi padchan na fiyasta, wi siyan apatkani padcha, summiad à Jesus ad chinakorna wi man-alig, anana, “Sinumani nauwaw, umali kuman saon ta painumà à siya. ");
INSERT INTO ksc_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tan na niyug-is wi ukud Apudyus, anana, ‘Sinumani mamatin saon, lumosloswan siyan chanum wi mamiyag ta takù ing-ingkana.’” ");
INSERT INTO ksc_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Na sachi inukud Jesus wi chanum wi lumosloswa ta taku, inyalignan Ispiritu wi ipaalin Apudyus wi makarong-ag ta losani mamatin siya. Ngim chaan pù mipaalin Ispiritu ta sachi timpu tan chaan pun na machayawan Jesus wi mangulin ad langit. ");
INSERT INTO ksc_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Chingngor ad na takun imfakan Jesus, anan na uchum, “Siyan tuttuway profetay uullayontau!” ");
INSERT INTO ksc_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ad na uchum, anancha, “Siyan tuttuway Cristu wi impustan Apudyus wi umali!” Ngim na uchum, anancha, “Apay, Galilea lawan marpuwan na Cristu? ");
INSERT INTO ksc_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tan niyug-is ta ukud Apudyus wi na Cristu, kanà David, wi Betlehem na miyanaana, tan sachin ilin Ali wi David.” ");
INSERT INTO ksc_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Siyan achi pu miyamfuruy na somsomò chachi taku mipangkop an Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Na uchum an chicha, pionchay maniliw an siya, ngim maid pu osà nangipachas. ");
INSERT INTO ksc_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Chachi kuwarcha, nangulincha ta chachi nangifaun an chicha, ad chachi namfaun wi pangpangun na papachi ya Fariseo, inimuscha, “Tayuko achi tiniliw à siya?” ");
INSERT INTO ksc_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ad summongfatcha wi anancha, “Nanipud ta niyanaanni, maid pu chingngornì nantudtuchù isun siya!” ");
INSERT INTO ksc_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ad anan ako chachi Fariseo, “Uray à chiayu, naturtulliyan-ayu ko? ");
INSERT INTO ksc_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Chiani wi Fariseo ya pangatyu, maid pu osà namati ta sachi taku. ");
INSERT INTO ksc_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Chachi takuy mamatin siya, maid pu akammucha mipangkop ta lintog Moses, siyan ifallu Apudyus chicha!” ");
INSERT INTO ksc_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Sachi ad, nan-ukud à Nicodemo wi osay furunchay Fariseo, wi siyan ummoy an Jesus ta sillafiyan. Anana ta fufurunna, ");
INSERT INTO ksc_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Maipalit ta lintogtau wi ipatuttau pafasuron na osay taku nu achitau unaon imfistikaron nu sinun iningwana.” ");
INSERT INTO ksc_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ad summongfat chachi fufurunna wi anancha, “Apay, iGalileaa ko? Acharom na sachi niyug-is, wi maid osà profetà narpud Galilea.” ");
INSERT INTO ksc_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Sachi ad, nansissiyancha wi lummayaw ta foforoycha. ");
INSERT INTO ksc_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ngim à Jesus, ummoy ta Filig wi Olivo. ");
INSERT INTO ksc_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nafikat ad ta wisnit, asin ummoy à Jesus ta Templo. Ad naarus na losani takun siya, ad tummùchù siya wi mantudtuchun chicha. ");
INSERT INTO ksc_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ad linumnò chachi Fariseo wi uchum ya nangitudtuchu ta lintog, wi inyalichan osay fufai wi nàchasan wi nakasuyop ta foon à asawana. Ad impasangucha ta taku. ");
INSERT INTO ksc_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ad imfakachan Jesus, “Misturu, annayan osay fufai wi nàchasan wi nakasuyop ta foon à asawana. ");
INSERT INTO ksc_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Illintog Moses wi mapisong à fatu na fummasur ta amasnay fasur ingkanà matoy. Ad à sia, sinun ifakam?” ");
INSERT INTO ksc_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Amaschin iningwacha tan pionchay sikapan à Jesus ta awad mangipafasuranchan siya. Ngim nayyuung à Jesus ad nangug-is ta kafu, wi siya inyusarna inyug-is na pattuchuna. ");
INSERT INTO ksc_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ad impapilitcha summongfaton à siya. Sachi ad summiad à Jesus, ad anana, “Nu sinun maid pu fasurnan chiayu, siyan umunay mamisong.” ");
INSERT INTO ksc_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ad asin nayyuung nangug-is ta kafu. ");
INSERT INTO ksc_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Na nangngorancha ta imfakan Jesus, nasin-ossacha lummayaw wi illukin na arakayan an chicha. Siyan ummafuscha Jesus ya sachi fufaì nataynan. ");
INSERT INTO ksc_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Sachi ad, tinangad Jesus na sachi fufai ad anana, “Ummakon chachi nangipafasur an sia? Maid pu manusan sia nù?” ");
INSERT INTO ksc_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Maid, Apu,” anan na fufai. Ad anan ako Jesus, “Uray saon, foon pu kò chusaò sia. Siyan ing-a, ngim achia asin fumasur.” ");
INSERT INTO ksc_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Asin ako nantudtuchù Jesus ta sangwanan na taku, ad ananay man-alig, “Saon na silaw wi manlawag ta somsomò na takud asnay luta. Siyan sinumani sumurut an saon, foon pù ingkaw ta pangot tan marawakan ta silaw wi fumiyag, siyan makafiyag an Apudyus à ing-ingkana.” ");
INSERT INTO ksc_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ad anan chachi Fariseo an siya, “Apay, namnamam wi manàchor ta long-agnu! Achi pu matuttuwan itanungnay manàchor ta long-agna.” ");
INSERT INTO ksc_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ad anan Jesus, “Foon, tan uray nu tàchorà na long-ag-u, tuttuwa met na ifakà, tan à saon, akammù na narpuwà ya akammù akon umayà. Ngim à chiayu, maid akammuyù narpuwà ya umayà. ");
INSERT INTO ksc_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ipatutyun nar-us wi simsimmòyu wi manguis an saon. Ngim saon, foon pù amaschin pinagkuis-u ta taku. ");
INSERT INTO ksc_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Tan nu kaspangalikan kuisò na taku, kuisò chicha ta katuttuwaan, tan foon pù iyos-osà wi manguis, tan chuwaanin Ama wi siyan nangifaun an saon. ");
INSERT INTO ksc_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ad niyug-is ako ta lintog Moses wi nu chuwan manàchor, ad nu man-amfuruy na ifakacha, tuttuwan ifakacha. ");
INSERT INTO ksc_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Siyan saon na osay manàchor ta long-ag-u, ya tàchoranà akon Ama wi nangifaun an saon.” ");
INSERT INTO ksc_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Sachi ad, inimuschan siya, “Ad sinun ingkawan Amam?” Ad anan Jesus, “Maid pu akammuyun Ama, ya maid pu ko akammuyu nu sinuwà, tan nu inakammuyu nu sinuwà, inakammuyu kò Ama.” ");
INSERT INTO ksc_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Amaschin imfakan Jesus ta nantudtuchuwana ta ikaw wi mangigkaanchà pilak ta Templo. Ad uray iningkaw chachi pangpangun na Judio ta sachi, maid pu osà nangip-ippong maniliw an siya, tan chaan pù chumatong na timpuna. ");
INSERT INTO ksc_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Sachi ad imfakan ako Jesus an chicha, “Chumatong na timpuy lumayawà, ad siyan manganapanyun saon, ngim achiayu pu makaali ta umayà, siyan matoy-ayu wi foon pù maaan na fasuryu.” ");
INSERT INTO ksc_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Sachi ad anan chachi pangpangun na Judio, “Otyona nin na long-agna, tan apay ananay achitau pu makaoy ta umayana nu!” ");
INSERT INTO ksc_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ad anan ako Jesus, “Chiayu, asnay lutan narpuwanyu, siyan na akammuyu, mipangkop yakay ta annayay luta. Ngim à saon, langit na narpuwà, siyan foon pù annay lutan pagpag na akammù. ");
INSERT INTO ksc_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ad sachin nangifag-à an chiayu wi matoy-ayu wi foon pù maaan na fasuryu, tan mitatàod an chiayù ing-ingkana, ad mifalluayu nu foon pù patiyonyu wi saon na ug-ugkuchò.” ");
INSERT INTO ksc_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ad anancha, “Siyan sinua man?” Ad summongfat à Jesus, wi anana, “Nanipud ta chamchamuy mantudtuchuwà, imfakafakà an chiayu nu sinuwà. ");
INSERT INTO ksc_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Achu kon ifakà mipangkop an chiayu, ya achu kon mangipafasurà an chiayu, ngim siya kay ifakà ta takud asnay luta na chingngor-u wi imfakan na sachi nangifaun an saon, ad à siya, tuttuwa losan na imfakana.” ");
INSERT INTO ksc_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Na chachi Judio, achicha pu naawatan wi Apudyus na ifagfakan Jesus wi Amana. ");
INSERT INTO ksc_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Siyan anan Jesus an chicha, “Saoni namfalin taku, nu ilansaà an chiayu ta kros, sachin mangakammuwanyu nu sinuwà, ya sachi kon mangawatanyu wi maid pu oyyoò à foon pù mipiyar an saon, ya maid pu ko ifakà nu foon à Aman nangitudtuchun saon. ");
INSERT INTO ksc_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ad na sachi nangifaun an saon, iingkaw an saon. Foon à taynanà an siya, tan na oy-oyyoò, afus yakan piona.” ");
INSERT INTO ksc_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Na nanangngorancha ta chachi imfakana, ad-adchuwan na namatin siya. ");
INSERT INTO ksc_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Sachi ad imfakan Jesus ta chachi namatin siya, “Nu patkonyun losani intudtuchù an chiayu, chiayun tuttuway disipulus-u, ");
INSERT INTO ksc_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ad akammuwonyun katuttuwaan. Ad na katuttuwaan, sachin mangiparufus an chiayu ta kinasaniluyu.” ");
INSERT INTO ksc_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Sachi ad summongfat chachi Judio wi anancha, “Ngim kanà chianin Abraham, siyan maid met nansaniluwanni, siyan sinun piomi ifaka ta anami iparufus chiani ta kinasaniluni, tan foon pun met à saniluani?” ");
INSERT INTO ksc_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ad anan Jesus, “Tuttuwan ifakà an chiayu: sinumani fumasur, siyan sanilun Satan wi puun na fasur. ");
INSERT INTO ksc_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Na sanilu, mafalini miparyaw nu siyan somsomò na nginsanilu. Ngim na tuttuway anàna, achi pu miparyaw tan siyan anà à ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Siyan nu Anà Apudyus na mangiparufus an chiayu ta kinasaniluyu, tuttuway miparufus-ayu. ");
INSERT INTO ksc_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Akammù wi kanà Abraham chiayu, ngim kapu ta achi pu lumnò ta somsomòyun itudtuchù, siyan anaponyun mangtoyanyun saon. ");
INSERT INTO ksc_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Saon, ifakà an chiayun chachi chingngor-un Ama ad langit, ad à chiayu, oyyoonyu kon chingngoryun amayu.” ");
INSERT INTO ksc_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ad anan chachi Judio, “Maid pu safalì amani nu achi afus à Abraham.” Ad anan Jesus, “Nu tuttuway kanà chiayun Abraham, turachonyu kuman iningwana. ");
INSERT INTO ksc_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Tan maid uchum à imfakà an chiayu nu achi afus na katuttuwaan wi chingngor-un Apudyus, ad sachin pangkop na maryachanyu wi mamatoy an saon. Ad, amaschi lawan iningwan Abraham? ");
INSERT INTO ksc_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ngim chiayu, tuttuway turachonyun iningwan na amayu!” Ad anancha ko, “Apay, agkafàani? Os-osàan met na Amani, wi Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ad anan Jesus an chicha, “Nu tuttuway Apudyus na Amayu, ay-ayatonyu kumà saon tan siyan narpuwà. Tan foon à fummugtungà wi umalid asnay luta, tan imfaunà an siya. ");
INSERT INTO ksc_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Siyan tamako achiyu pu maawatan na ifakà? Oo, tan foon pù pionyuy mangngor. ");
INSERT INTO ksc_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tuttuway isuyù amayuy Satan, wi na piona, sachi kon pionyu. À siya, pumappatoy nanipud ta chamuna, ya maid pu mansakungana ta katuttuwaan tan pasig tulin ifakafakana. Losani ifakana, turtulli, tan oyyoonan nisikud an siya tan siyan sikud wi puun na turtulli. ");
INSERT INTO ksc_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ngim à saon, pasig katuttuwaan na ifakà an chiayu, ad sachin achiyu pu mamatiyan an saon. ");
INSERT INTO ksc_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Awad osan chiayù manuttuwa wi awad fasur-u? Maid, tan maid pu fasur-u. Ad payuko achi tuttuwaon na katuttuwaan wi ifakà an chiayu nù? ");
INSERT INTO ksc_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Na tuttuway takun Apudyus, surutonchan ifakana. Ngim à chiayu, foon pù surutonyu tan foon pù tuttuway takunà chiayu.” ");
INSERT INTO ksc_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Sachi ad sinongfatan chachi pangpangun na Judiò Jesus wi anancha, “Tuttuwa pan imfakani wi iSamariaa wi afusurni wi Judio! Ad nakafarfaray-a ko!” ");
INSERT INTO ksc_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ad anan Jesus, “Foon à nakafarfarayà, tan Amà na afusi pachayawò. Ngim amsiwonà an chiayu. ");
INSERT INTO ksc_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Foon à kachayawà na kamkamkamà, ngim awad na osay mangkamkam ta kachayawà, wi siyà Apudyus; ya tàchoranà akon siya. ");
INSERT INTO ksc_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tuttuwan ifakà an chiayu: sinumani mamtog ta itudtuchù, achi pu matoy à ing-ingkana.” ");
INSERT INTO ksc_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Sachi ad anan chachi Judio, “Ilanyu, tuttuway nakafarfaray! Natoy met à Abraham, ad isun ako chachi profetas, ad ifakami sinumani mamtog ta itudtuchum, achi pu matoy! ");
INSERT INTO ksc_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Apay, nangatngatua nu Aputauy Abraham ya chachi profetas, wi natoycha met ta awi? Sinua man wi amaschin somsomònu?” ");
INSERT INTO ksc_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ad summongfat à Jesus wi anana, “Nu saon yakan mangipachayaw ta long-ag-u, maid pu silfin na amaschi wi chayaw. Ngim na katuttuwaana, à Aman mangipachayaw an saon, wi siya kon ananyuy Apudyusyu. ");
INSERT INTO ksc_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Maid akammuyun siya. Ngim à saon, akammù à siya. Ad nu anà wi maid pu akammù an siya, tuliyonà, wi isun chiayu. Ngim na katuttuwaana, tuttuway akammù à siya, ya patkò akon ifakana. ");
INSERT INTO ksc_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Na awi, naragsak na Apuyuy Abraham ta nangakammuwana wi ilanan umaliyà ad asnay luta. Ad na sana, tuttuway innilanan ummaliyà, siyan naam-amod na lagsakna.” ");
INSERT INTO ksc_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ad anan chachi Judio, “Apay, chaan-a pù malimampuruy tawon, ad anami innilam à Abraham?” ");
INSERT INTO ksc_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ad anan Jesus, “Tuttuwan ifakà an chiayu: na chaampunan Abraham màwaan, iningkawà.” ");
INSERT INTO ksc_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Sachi ad, nangànamchà fatu ta fatuwonchà siya. Ngim à Jesus, nantaru, ad lummayaw ta Templo. ");
INSERT INTO ksc_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Na nanadchadcharanannin Jesus, innilanin osay larai wi sikud na kurapna. ");
INSERT INTO ksc_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ad à chiani wi disipulus Jesus, inimusnin siya, “Apu, sinun nakafasur à nakurapan na annayay sikuchi nakurap? Siya, winnu chachakkorna?” ");
INSERT INTO ksc_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ad summongfat à Jesus, wi anana, “Foon pù fasurna winnu fasur na chachakkornan nakurapana, tan nakurap à mipail-an na karobfongan Apudyus an siya.” ");
INSERT INTO ksc_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Sachi ad nan-alig à Jesus mipangkop ta natakuwan ya matayan, wi anana, “Na awachan na padcha, siyan wayatauy mangwa ta pion na nangifaun an saon, tan nu chumatong na lafi, maid wayatauy mangwa. ");
INSERT INTO ksc_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Siyan na awachà ad asnay luta, saon na silaw wi manlawag ta somsomò na takud asnay luta.” ");
INSERT INTO ksc_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Imfakan pu Jesus na sachi, nantubfa ta luta ad illaukna, ad illafunan piyò ta atan chi nakurap. ");
INSERT INTO ksc_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ad anana, “Ing-a char-upan na fosarnu ta puung ad Siloe.” (Na mining na sachi ngachan wi Siloe, “Nifaun.”) Ad ummoy na sachi nakurap nanchar-up, ad namagkulin wi naaan na kurapna. ");
INSERT INTO ksc_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ad na chachar-agna ya chachi nangakammun siya ta timpun na nan-ochaochawana, nan-asiimuscha wi anancha, “Apay, siyan sachi ummaamuy wi nan-ochaochaw?” ");
INSERT INTO ksc_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ad anan na uchum, “Oo, siya met.” Ngim anan na uchum, “Foon, tan isun yakà fosar chi osa.” Ngim nan-ukud na sachi nakurap wi anana, “Saonna!” ");
INSERT INTO ksc_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ad inimuschan siya, “Tamako makailaa ta sana nù?” ");
INSERT INTO ksc_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ad ananay summongfat, “Iningkaw na osay taku wi Jesus anun ngachanna. Iningwanan piyò ad illafuna ta atà, ad imfakanan saon wi inyà char-upan na fosar-u ad Siloe. Siyan ummoyà nanchar-up, ad nachisan naaan na kurap-u.” ");
INSERT INTO ksc_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ad anan chachi taku, “Sinun awachana ta sana nù?” “Sanat na achì pu akammu,” anan na nakurap. ");
INSERT INTO ksc_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Sachi ad inyoy chachi takun sachi naaan na kurapna ta ikaw na Fariseo. ");
INSERT INTO ksc_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","15","Ad inimus chachi Fariseo nu sinun in-inon na naaanan na kurapna. Ad asinna imfaka, “Illafunan piyò ta atà, ad chinar-upà, ad makailaà!” Na nangwaan Jesus ta sachi, Safachu wi sikuchi ngilin na Judio. ");
INSERT INTO ksc_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Siyan anan na uchumi Fariseo, “Ilanyuchi, foon à Apudyus na narpuwan na sachi taku, tan apay achina pu tungparon na ngilintau wi Safachu nù!” Ngim anan akon uchum, “Ngim makàwa ad min na managfasur à kaskaschaaw à amaschi?” Siyan nanchuwan somsomòcha. ");
INSERT INTO ksc_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Sachi ad, asincha ko inimus ta sachi naaan na kurapna, “Sinun manomsom-am ta sachi taku, tan annay inaannan kurapnu?” “Na somsomòu,” anana, “profetà siya.” ");
INSERT INTO ksc_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ngim chachi pangpangun na Judio, achicha pu tinuttuwa wi sikud na kurap na sachi taku ad makaila ta sana, siyan impaayagchan chachakkorna, ");
INSERT INTO ksc_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ad inimuschan chicha, “Tuttuway anàyun sanat? Ad tuttuway sikud na kurapna? Ad pamako makaila ta sana nù?” ");
INSERT INTO ksc_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ad summongfat chachi chachakkorna wi anancha, “Oo, tuttuway anàninat, ad tuttuway nisikud na kurapna. ");
INSERT INTO ksc_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ngim na naaanan na kurapna, sanat na maid pu akammuni, ad maid pu ko akammuni nu sinun nangaan. Ngim mafalini imusonyun siya tan naangsan met, siyan lobfongnay manongfat ta imusonyu!” ");
INSERT INTO ksc_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Sachin imfakan chachi chachakkorna tan ummogyatcha ta chachi pangpangun na Judio, tan à chicha, nar-uscha imfafagka wi sinumani mangwanan wi Jesus na Cristu wi impustan Apudyus, miparyaw ta sinagogan na Judio. ");
INSERT INTO ksc_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ad sachin nangifag-an na chachakkorna wi, “Naangsan met, siyan imusonyun siya!” ");
INSERT INTO ksc_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Sachi ad, asincha ko inayakan na sachi naaan na kurapna, ad ananchan siya, “À Apudyus man na manyamanam, tan akammuni wi managfasur na sachi taku!” ");
INSERT INTO ksc_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ad summongfat na sachi naaan na kurapna, wi anana, “Maid akammù nu tuttuway managfasur winnu foon, ngim na afusi akammù, nakurapà ta chamu, ad na sana, makailaà!” ");
INSERT INTO ksc_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ad asincha ko inimus an siya, “Sinun in-inonay nangaan ta kurapnu?” ");
INSERT INTO ksc_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ad anana ko, “Ninarmà imfakan chiayu, ad achiyu pu chongron. Apay pionyu koy asin mangngor? Winnu, pionyu koy sumurut an siya?” ");
INSERT INTO ksc_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ad chachi Fariseo, ininsurtuchà siya wi anancha, “Sian disipulusna! Ngim à chiani, Moses na surutonni. ");
INSERT INTO ksc_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Akammuni wi nakaug-ugkud à Apudyus an Moses, ngim na sachi taku, maid akammunì narpuwana!” ");
INSERT INTO ksc_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ad summongfat na sachi naaan na kurapna, wi anana, “Masmaschaawà an chiayu! Tan maid akammuyù narpuwan na sachi mannakafalin wi mangaan ta kurap? ");
INSERT INTO ksc_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tan akammutau met wi foon pù chongron Apudyus na managfasur. Ngim na manayaw an siya ya mangwa ta piona, sachin chongrona! ");
INSERT INTO ksc_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nanipud ta nàwaan na annayay luta ingkana ta sana, maid osà chingngortaù makaaan ta sikud wi kurap. ");
INSERT INTO ksc_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Siyan nu foon à Apudyus na narpuwana, maid kuma karobfonganay mangaan ta kurap.” ");
INSERT INTO ksc_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ad ingkattòchay nanongfat an siya, wi anancha, “Managfasur-a nanipud ta nifùnakam, ad apay, tudtuchuwam chiani?” Sachi ad pinaryawchà siya wi pinagpagchan lumnoana ta simfaancha. ");
INSERT INTO ksc_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Chingngor pu Jesus na nàwa ta sachi nakurap, inchasanà siya, ad anana, “Patiyom na finaun Apudyus ta annay luta, wi namfalin taku?” ");
INSERT INTO ksc_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ad anan na nakurap, “Apu, sinun sanati taku, ta mamatiyà an siya!” ");
INSERT INTO ksc_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ad anan Jesus, “Iniillam à siya, tan makaug-ugkud an sia ta sana!” ");
INSERT INTO ksc_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“Apu, patiyò à sia!” anan na nakurap, ad chinayawnà siya. ");
INSERT INTO ksc_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ad inturuy Jesus wi man-ukud, anana, “Na ummaliyà ad asnay luta, ta kuisò na taku, ta chachi isù nakurap wi maryad umila, makailacha. Ngim chachi mangwanan wi makailacha nu tan foon pù nakurapcha, makukurapcha met laing.” ");
INSERT INTO ksc_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Sachi ad na uchumi Fariseo wi niyaslang, na nangngorancha ta imfakana, anancha, “Apay, anami nakurap-ani ko?” ");
INSERT INTO ksc_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ad inyalig Jesus na fasur à kurap, wi anana, “Nu tuttuway nakurap-ayu, achì pu pafasuron chiayu, tan achiayu pu makaila ta katuttuwaan, ya mafalini maaan na kurapyu. Ngim kapu ta ananyuy makailaayu, siyan issiyan fasuryu wi sachin nangurap an chiayu.” ");
INSERT INTO ksc_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Sachi ad, nan-alig à Jesus wi anana, “Tuttuwan ifakà an chiayu: na takuy umarab ta arad na pukukan wi ikaw na pannilu, wi foon à liwangan na ayona, man-akaw ya chumachail. ");
INSERT INTO ksc_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ngim na takuy mangoy ta liwangan, siyan ustuy pastor na pannilu. ");
INSERT INTO ksc_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ad na mamfantay ta liwangan, ib-atnan lumnoana. Ad ayakanan ngachancha sin-ossàon, ad chachi pannilu, ilasinchan kingana ad iparawana chicha. ");
INSERT INTO ksc_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ad nu illawana chicha, siyan mangipangu ta umayancha, ad tun-uchonchà siya tan ilasinchan kingana. ");
INSERT INTO ksc_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Foon pù tun-uchonchan safali tan ilasinchay foon pù kingan na ustuy pastorcha, siyan umawichancha.” ");
INSERT INTO ksc_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Foon pù naawatan na taku nu sinun pion Jesus wi ifaka ta annay inyaligna. ");
INSERT INTO ksc_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Sachi ad, asin nan-alig à Jesus, wi anana, “Tuttuwan ifakà an chiayu: saon na liwangan na pukukan na pannilu. ");
INSERT INTO ksc_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ad na losani namangpangu nu saon, wi foon à ustun intudtuchucha, chichan man-aakaw ya chumachail. Ngim chachi pannilù, foon pù pintogcha. ");
INSERT INTO ksc_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Saon na liwangan, ad sinumani mangoy an saon, saraknifà à siya, ya miparufus wi lumnò ya lumaway mangan. ");
INSERT INTO ksc_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ngim na man-akaw, maid safalì pangkopna nu foon pù umoy mangarà piona ya pumatoy ya chumachail. Ngim à saon, ummaliyà à mamiyag ta taku wi adchò na farfaruy mafiyakancha ingkanà mapnokancha. ");
INSERT INTO ksc_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Saon na mamfaruy pastor. Na mamfaruy pastor, foon à ifilangnan fiyagna ta mangayyuwanana ta panniluna. ");
INSERT INTO ksc_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ngim na kuwarcha wi mallabfu, wi foon pù ustuy ngin-uwa ta pannilu, safali. Tan à siya, nu umalin kaog-ogyati atap wi asu, taynanan pastorona ya umawid. Ad chi asu, anonan uchum, ad mafuar na uchum. ");
INSERT INTO ksc_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Maanawid na sachi mallabfu tan labfuna kan kamkamana wi foon à patkanan pannilu. ");
INSERT INTO ksc_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ngim saon na mamfaruy pastor, ad na mangakammuwà ta pannilù ya mangakammuwancha kon saon, ");
INSERT INTO ksc_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","isun na mangakammuwà an Ama ya mangakammuwan Aman saon. À saon, foon à ifilang-un fiyag-u ta mangayyuwanà ta pannilù. ");
INSERT INTO ksc_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ad awad akon uchumi pannilù wi chaan pù miyamung ta anchanayay pannilu ta pukukan. Siyan masapur ayakà ako chicha, ad nu chongronchan kingà, umalicha ta osan mauugpunancha, ya osa kan mamastor an chicha. ");
INSERT INTO ksc_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Amod na ayat Ama an saon tan adchò na long-ag-ù matoy à mafiyakan na chachi pannilu, ad uray nu matoyà, matakuwà asin. ");
INSERT INTO ksc_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Maid pu makapros ta fiyag-u nu achì pu iparufus, tan saon na mangiparufus ta matayà. Annan karobfongà wi mangiparufus ta matayà, ya anna kon karobfongà wi mangipauli ta fiyag-u, tan sachin impiyar Ama an saon.” ");
INSERT INTO ksc_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Na nangifag-an Jesus ta anchanaya, nan-agwan chachi Judio, ");
INSERT INTO ksc_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","tan achun nangifaka wi narapang anù Jesus, ya nakafarfaray; ad apay, tachako chochongron na amasnay ukud! ");
INSERT INTO ksc_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ngim na uchum, anancha, “Amasna nin na ukud na narapang? Ya awad lawa karobfongan na aran wi mangaan ta kurap?” ");
INSERT INTO ksc_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ummakilid pun, iningkaw na fiyastay Mangiyakasmoan ta Nàwaan na Templo ad Jerusalem. ");
INSERT INTO ksc_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ad na sachi timpu, nangkagkaay à Jesus ta sawang na Templo, wi ananchay Sawang Solomon, ");
INSERT INTO ksc_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ad naarus na uchumi Judio an siya. Ad anancha, “Ifakam an chianin katuttuwaan, ta foon pù manchuwachuwaani. Tuttuway sian Cristu wi impustan Apudyus, wi uullayonni?” ");
INSERT INTO ksc_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ad anan Jesus, “Imfagkafagkà an chiayu, ngim issiyay achiyu pu tuttuwaon. Ad na losani oyyoò kapu ta namiyarà an Ama, siya kuman manuttuwaanyu wi siyan narpuwà. ");
INSERT INTO ksc_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ngim achiyu pu tuttuwaon, tan foon pù pannilù chiayu. ");
INSERT INTO ksc_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Tan na pannilù, tuttuwaonchan ifakà ya tun-uchoncha kò saon ya akammù chicha. ");
INSERT INTO ksc_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Siyan adchò an chichan mannaynayuni fiyag, ad achicha pu mifallù ing-ingkana. Ad maid pu ko makapros an chicha, tan oognà chichà ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","À Ama, wi siyan nangatod an chichan saon, siyan angatuwan, siyan maid pu makapros an chicha an Ama, tan ayyuwanana chicha. ");
INSERT INTO ksc_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Saon ya Amà, man-isuani tan osaani.” ");
INSERT INTO ksc_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Na nangifag-an Jesus ta sachi, nangànam chachi pangpangun na Judio à fatu ta fatuwonchà siya. ");
INSERT INTO ksc_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ad nan-iyanan Jesus, “Achun iningwà wi man-afaruy kaskaschaaw an chiayu wi impàwan Aman saon, siyan sinun pangkop na mamatuwanyun saon nù?” ");
INSERT INTO ksc_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ad summongfatcha wi anancha, “Foon à mamfaruy iningwam na mamatuwannin sia! Tan na mamatuwannin sia, na mamrosam ta kina-Apudyus Apudyus, wi mamfalinom na long-agnu Apudyus, ad takua met!” ");
INSERT INTO ksc_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ad summongfat à Jesus wi anana, “Oo, ngim niyug-is met ta Lintogtau wi anan Apudyus, ‘Chiayu, apudyus-ayu ko.’ ");
INSERT INTO ksc_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ad akammutau wi tuttuwa losan na niyug-is. Siyan chachi aapputau ta awi wi nangifag-an Apudyus ta ukudna, nginachanana chichà ‘apudyus.’ ");
INSERT INTO ksc_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","À saon, chinutukanà an Ama ad imfaunna ad asnay luta. Siyan payuko anani pursò na kina-Apudyusna ta nangifag-à wi saon na Anàna? ");
INSERT INTO ksc_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nu maid pu iningwà à kaskaschaaw wi Apudyus yakan makàwa, uray achiyà pu tuttuwaon an chiayu. ");
INSERT INTO ksc_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ngim kapu ta sachin oy-oyyoò, uray nu lawingonyuy manuttuwa ta ifakà, tuttuwaonyu kuman oyyoò, ta sachin manuttuwaanyu wi awad à Aman saon ya awachà akon siya.” ");
INSERT INTO ksc_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Sachi ad asincha ko pachason tiliwon à Jesus, ngim illisiyana chicha ad lummayaw. ");
INSERT INTO ksc_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ad asin Jesus chinormang na Chawwang wi Jordan, ad ummoy ta sachi lukar wi namfunyakan Juan ta sin-arkawan. Ad iningkaw ta sachi. ");
INSERT INTO ksc_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ad ad-adchuwan akon nitun-ud an siya, tan anancha, “À Juan wi Mamfufunyag, maid impailanà kaskaschaaw, ngim losani imfakanay mipangkop ta annayay taku, tummuttuwa losan.” ");
INSERT INTO ksc_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Siyan ad-adchuwan akon namatin Jesus ta sachi. ");
INSERT INTO ksc_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Na sachi ilid Betania, iningkaw na turuy mansusunud wi cha Maria, Marta ya Lazaro. À Maria, siyan nangisiit ta lanog ta ikin Jesus ad pinunasana ta fuùna. À Lazaro, nasakit, ");
INSERT INTO ksc_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","siyan impaayag cha Marian Martà Jesus wi anancha, “Apu, nasakit na furunnuy Lazaro wi ay-ayatom.” ");
INSERT INTO ksc_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Chingngor ad Jesus, anana, “Na sachi sakit, foon pù matayan Lazaro, tan machayawan Apudyus, wi sachi kon machayawà wi Anàna.” ");
INSERT INTO ksc_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ay-ayaton Jesus chicha losan wi mansusunud, ");
INSERT INTO ksc_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ngim na nangngorana ta nasakitan Lazaro, foon à lummigwat ta sachi wi timpu ngim inuraynan chuway padcha. ");
INSERT INTO ksc_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Sachi ad imfakanan chiani wi disipulusna, “Intau asin ad Judea.” ");
INSERT INTO ksc_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ad anannin siya, “Apu, chi osay padcha tikangay sia fatuwon ta chachi Judiod aschi, ad apay, asintau ko umoy?” ");
INSERT INTO ksc_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Sachi ad, nan-alig à Jesus wi nangifaka, “Masawaran à chuway uras na uminitana ta osay padcha, siyan nu manadcharan na taku ta padcha, achi pu misufù tan sisillawan na init na chadcharanona. ");
INSERT INTO ksc_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ngim nu lafin manadcharanana, kapilitani misufù tan mamfulingot.” ");
INSERT INTO ksc_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Imfakan pu Jesus na sachi, anana ko, “Nasusuyop na furuntauy Lazaro, siyan intau ta inyà fangonon à siya.” ");
INSERT INTO ksc_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ad summongfat-ani wi disipulusna, wi ananni, “Apu, nu nasusuyop yakay, kapilitani maaan na sakitna.” ");
INSERT INTO ksc_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Na pion Jesus wi ifaka, nanattoy à Lazaro, ngim na naawatanni, nasusuyop yakay. ");
INSERT INTO ksc_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Sachi ad imparawag Jesus wi nangifaka, “Natoy à Lazaro, ");
INSERT INTO ksc_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ngim mamfaruwanyu tan maichà ta natayana, ta awad mamatiyanyun saon. Siyan intau ilan à siya.” ");
INSERT INTO ksc_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Sachi ad nan-ukud na osay furunni wi Tomas wi apil, ad ananan chiani, “Intau losan an Aputau, ta nu patoyonchà siya, ìtoytau ko losan!” ");
INSERT INTO ksc_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Chummatong-ani pun ad Betania, chingngor Jesus wi nar-us nilofon à Lazaro ta apatpadchana. ");
INSERT INTO ksc_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Na ili wi Betania, turu nin wi kilometron aachayunad Jerusalem, ");
INSERT INTO ksc_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","siyan ad-adchuwan na iJerusalem wi ummoy nakafakungun ta sunudcha Marta an Maria. ");
INSERT INTO ksc_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","À Maria, iningkaw ta foroy, ngim chingngor pu Marta wi chumatong-ani, ummoyna inafot à Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ad ananan siya, “Apu, nu iningkaw-ad asna, foon pù natoy na sunud-u! ");
INSERT INTO ksc_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ngim akammù wi uray na sana, nu sinun imusom an Apudyus, adchonan sia.” ");
INSERT INTO ksc_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ad anan Jesus an siya, “Umuli matakun sunudnu.” ");
INSERT INTO ksc_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","“Oo, akammù wi umuli mataku,” anan Marta, “tan tuttuwaò wi umuli matakun losani natoy à tapin na padcha.” ");
INSERT INTO ksc_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ad anan Jesus an siya, “Saon na mangipauli manaku ta taku, ya saon akon mangatod ta mannaynayuni fiyag. Siyan sinumani mamatin saon, uray nu matoy, takuwò à siya. ");
INSERT INTO ksc_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ya sinumani natattaku, nu mamatin saon, achi pu matoy à ing-ingkana. Tuttuwaomna?” ");
INSERT INTO ksc_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Oo, Apu, tuttuwaò!” anan Marta. “Ya tuttuwaò ako wi sian Cristu wi Anà Apudyus, wi impustanay umalid asnay luta.” ");
INSERT INTO ksc_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Imfakan pu Marta na sachi, ummoy ta foroycha ad inayakanà Maria, ad inyakutimtimna, anana, “Chummatong à Aputau ad ayakanà sia.” ");
INSERT INTO ksc_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Na nangngoran Maria ta sachi, inaw-awaynay lummawa wi umoy mangafot an Jesus, ");
INSERT INTO ksc_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","tan à Jesus, chaan pù chumatong ad ilicha, tan iniingkaw ta sachi nanaynan Martan chiani. ");
INSERT INTO ksc_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Chachi taku wi naaamung ta foroy, nitun-udchan Maria ta lummawaana tan anancha pun nu umoy ta lofon man-ifil. ");
INSERT INTO ksc_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ad chummatong pù Maria ta ikawni, nampalintumong ta sangwanan Jesus, ad anana, “Apu, foon à natoy na sunud-u nu iningkaw-ad asna!” ");
INSERT INTO ksc_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Na nangil-an Jesus an siyay man-ifiifil, ya chachi nifurun an siya wi losancha ko asiiifil, ummachaku ad naam-amod na somsomòna. ");
INSERT INTO ksc_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ad anana, “Sinun nangilobnanyun siya?” “Aschi, Apu,” anancha. “Intau ilan.” ");
INSERT INTO ksc_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Sachi ad nan-ifil akò Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Siyan anan chachi taku, “Amod tuwan somsomònan Lazaro!” ");
INSERT INTO ksc_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ngim anan akon uchum, “Oo, ngim nu makaaan ta kurap na taku, panako imparufus na natayan na furunna nù?” ");
INSERT INTO ksc_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Na ummachaniyan Jesus ta lofon, naam-amod na somsomòna. Na sachi lofon, liyang wi natangfan à topà. ");
INSERT INTO ksc_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ad anan Jesus, “Aanonyun tangobna!” Ngim inomoran Martà siya wi anana, “Apu, man-akub ta sana tan apatpadchan na natayana!” ");
INSERT INTO ksc_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ad anan Jesus an siya, “Oo, ngim imfakà an sia, wi nu tuttuwaom, ilam na machayawan Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Sachi ad inaanchan tangobna, ad nantangad à Jesus wi anana, “Ama, manyamanà an sia tan chongrom à saon. ");
INSERT INTO ksc_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Akammù wi chochongrom à saon, ngim ifakà à mangngoran na anchanayay taku ta tuttuwaoncha kuma wi sian nangifaun an saon.” ");
INSERT INTO ksc_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Imfakana ad na sachi, nampauy wi anana, “Lazaro, lumoswaa!” ");
INSERT INTO ksc_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ad lummoswan sachi natoy wi nafufussung na imana ingkana ta chapanna ya uray na uruna. Ad anan Jesus ta chachi taku, “Obfachonyu ta manadcharan.” ");
INSERT INTO ksc_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Chachi Judio wi nakafurfurun an Maria, achun namatin Jesus ta nangil-ancha ta sachi iningwana. ");
INSERT INTO ksc_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ngim na uchum, ummoycha incharum ta chachi Fariseo na iningwan Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ad chachi Fariseo ya pangpangun na papachi, impaayagcha chachi turay wi kukunsisar, ad nammimitingcha wi anancha, “Sinun oyyoontau ta sachi taku? Ad-adchuwan na oyyoonay kaskaschaaw! ");
INSERT INTO ksc_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tan nu ikikinnòtau, anunu ad losan na taku sumurut an siya! Ad nu sachin màwa, umog-ot chachi turay ad Roma ad yam-anonchan Templotau, ad aanoncha kon losani manturayantau!” ");
INSERT INTO ksc_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Sachi ad nan-ukud na osa, wi Caifas na ngachanna, wi siyan Angatuwani Pachi ta sachi tawon. Anana, “Apay, maid pu kay ait à somsomòyu? ");
INSERT INTO ksc_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Tan foon pù ilasinyu wi un-unnoy na osà matoy à subfut na kaachuwan nu losantauy Judio?” ");
INSERT INTO ksc_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Na sachi inukud Caifas, foon à somsomònan narpuwana ngim kapu ta siyan Angatuwani Pachi, siyan impaspasmò Apudyus an siya wi masapur matoy à Jesus à sukat na losani Judio. ");
INSERT INTO ksc_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ad foon akò afus na Judio na masubfut ta matayan Jesus, tan losani takuy niwaras ta luta wi anaon Apudyus, masubfutchà maugpunancha losan. ");
INSERT INTO ksc_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nanipud ta sachi, nantuturag chachi pangpangun na Judio wi mamatoy an Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Siyan maid in-inon Jesus wi mangkagkaay ta awachan na kaachuwani Judio, siyan ummoy-anid Efraim wi ili wi achani ta lutay longaat, ad sachin iningkawanni. ");
INSERT INTO ksc_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Machanchanin sachi fiyastan na Judio wi Mangiyakasmoan, siyan nan-ar-arus ad Jerusalem na achuy taku wi narpu ta ailiili, ta umoycha mampapor-as ta Templò manakanaancha ta fiyasta, tan sachin ukalicha. ");
INSERT INTO ksc_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ad na nansisib-atancha ta Templo, nan-asiimuscha ta mipangkop an Jesus, wi anancha, “Sinun somsomòyu? Umalì Jesus makafiyasta winnu foon?” ");
INSERT INTO ksc_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ad chachi Fariseo ya pangpangun na papachi, imfilincha ta taku wi nu awad mangilan Jesus, masapur ifakacha ta mipatiliw. ");
INSERT INTO ksc_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Chaan onomi padcha ya chumatong na sachi fiyastay Mangiyakasmoan, ad asin-anin Jesus ummoy ad Betania wi ilin Lazaro wi impaulina tinaku. ");
INSERT INTO ksc_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ad sinakanachà siya ta sachi maschom, wi à Marta na nansanilu, ad iningkaw akò Lazaro wi nakaan an Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","À Maria, iningkaw an siyan osay futilya wi kanginaani lanog wi nardo wi fangfangu. Siyan innarana ad insiitna ta ikin Jesus, ad pinunasana ta fuùna. Ad summurut na fanguna ta sachi foroy. ");
INSERT INTO ksc_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Sachi ad nanlilin osay disipulus Jesus wi à Judas Iscariote, wi siyan nangififik an Jesus, anana, ");
INSERT INTO ksc_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Tamako achina pu ilakun sanati lanogna ta awad maatod ta kakapus, tan umoy à turungkasut na nginana!” ");
INSERT INTO ksc_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Na nangifag-ana ta sachi, foon à kapu ta somsomòna ta kakapus, ngim kapu ta anchun imana ad siyan nangchon ta pilak, ya asisipit. ");
INSERT INTO ksc_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ngim anan Jesus an Judas, “Sachi! Achiyu fiyangan à siya, tan inchulinnà para ta milobnà nu matoyà! ");
INSERT INTO ksc_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Na kakapus, sikud wi awadchan chiayù tumurunganyu. Ngim à saon, foon à mafayakà wi ingkaw an chiayu.” ");
INSERT INTO ksc_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Sachi ad, chingngor na achuy taku wi awad à Jesus ad Betania, siyan ummoycha ilan à siya. Ad foon à afus à Jesus à ummoycha ilan tan à Lazaro ako wi impaulina tinaku. ");
INSERT INTO ksc_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Siyan chachi pangpangun na papachi, nantuturagcha koy mamatoy an Lazaro, ");
INSERT INTO ksc_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","tan siyan pangkop na ummachuwan na Judio wi namatin Jesus wi nan-awichancha chicha. ");
INSERT INTO ksc_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ad nafikat pun, chingngor chachi ad-adchuwani nakafiyastad Jerusalem wi chumatong à Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Siyan naog-ognanchà tufun na allilison wi umoy mangafot an siya. Ad nampauycha, “Machayaw à Apudyus! Ya chayawontau kon annayay ummali wi narpun Apudyus, wi siyan Alitauy kanà Israel!” ");
INSERT INTO ksc_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","À Jesus, nangaabfayu ta ayyufun na afayu wi inchasanni, tan niyug-is ta ukud Apudyus, ");
INSERT INTO ksc_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Chiayuy takud Jerusalem wi Sion, achiayu umogyat tan umalin Aliyu wi mangaabfayu!” ");
INSERT INTO ksc_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","À chiani wi disipulus Jesus, foon pù naawatanni ta sachi timpu nu sinun mapasamak. Ngim nangulin ad à Jesus ad langit, simsimmònin nàwan siya, wi tummuttuwaan na niyug-is. ");
INSERT INTO ksc_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Na chachi taku wi nangila ta nangipauliyan Jesus nanakuwan an Lazaro, wi pin-awanà siya ad lummoswa, impakìnacha. ");
INSERT INTO ksc_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ad sachin nangabtan chachi ad-adchuwani taku an Jesus, tan chingngorchan mipangkop ta kaskaschaaw wi iningwana. ");
INSERT INTO ksc_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ngim chachi Fariseo, nan-asiakitùtùcha, “Sinu kon oyyoontau? Achitau pu makatipod an siya, tan ilanyu, losan na taku ta luta, losancha sumurut an siya!” ");
INSERT INTO ksc_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Na sachi ko, iningkaw na uchumi foon pù Judio wi narpud Griego wi nakafiyastad Jerusalem. ");
INSERT INTO ksc_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ad ummoychan Felipe (iBetsaidà siya wi misakup ad Galilea) ad anancha, “Apu, achi mafalin wi ing-ani ilan à Jesus?” ");
INSERT INTO ksc_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Siyan ummoy à Felipe an Andres ad imfakanan sachi, ad ummoychay chuwa wi mangifakan Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ad anan Jesus an chicha losan, “Saon wi namfalin taku, chummatong ta sanan timpuy machayawà. ");
INSERT INTO ksc_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tuttuwan ifakà an chiayu: nu maayyuwanan na fuor wi achi pu miyosò, achi pu umachu. Ngim nu miyosò na fuor ta luta wi milofon, umachu. ");
INSERT INTO ksc_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Na fuor, isun akon fiyagtaud asnay luta. Tan sinumani mangayyuwan ta fiyagnad asnay luta, wi fumaruwan yakan long-agnan afusi patkana, maid silfina tan matoy met laing. Ngim na takuy foon à fiyagnad asnay lutan patkana, makafiyag an Apudyus à ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Siyan sinumani maryad mangwa ta piò, masapur surutonà saon. Siyan michokan saon ta umayà. Ya losani mangwa ta piò, pachayawon ako Amà chicha.” ");
INSERT INTO ksc_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Sachi ad, summauy à Jesus, wi mangifaka, “Napigsan somsomòu, ngim sinun ifakà? Chawatò an Ama ta achi pu mituruy na mipachas an saon? Foon, tan siyan pangkop-uy ummalid asnay luta.” ");
INSERT INTO ksc_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Sachi ad, nalluwaru wi anana, “Ama, ipailam na kachayawam!” Ad magngor akon kinga wi narpud langit, wi anana, “Oo, impailà na kachayawà kapu ta iningwam, ad asin-u ko ipaila kapu ta sachi chanchani mipachas an sia.” ");
INSERT INTO ksc_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Chachi takuy naag-agsad ta sachi, chingngorchan kinga, ngim anan na uchum, nangichur. Ad na uchum, anancha, “Anghel na nakaukud an siya!” ");
INSERT INTO ksc_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ngim summongfat à Jesus, wi anana, “Na kinga wi chingngoryu, foon pù katurungà yakan nipagngorana, tan katurunganyu ta maawatanyu wi chichingngorà an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Tan na kachusaan na losani takud asnay luta wi foon pù mamati, miluki ta sana, tan sanan maafakan Satan wi manturay an chicha. ");
INSERT INTO ksc_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","À saon, nu mapatoyà ta kros, sachin mangayakà ta taku ta arutaruta ta umalichan saon.” ");
INSERT INTO ksc_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Na nangifag-an Jesus ta sachi, impaakammunan matayana. ");
INSERT INTO ksc_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Sachi ad summongfat chachi naarusi taku, wi anancha, “Ngim na sachi niyug-is wi lintogtau, anana wi na Cristu wi ipaalin Apudyus, matattakù ing-ingkana. Ad pam-ako anan wi mapatoy ta kros na sachi wi namfalin taku? Ad sinu kon sachi anami namfalin taku?” ");
INSERT INTO ksc_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ad nan-alig à Jesus wi anana, “Saon na silaw wi manilaw ta ayon na taku, ngim foon à mafayakà wi ingkaw an chiayu. Siyan patiyonyu kuman itudtuchù ta achiayu mifallu. Tan chachi achi pu pumati, maid akammucha ta umayancha. ");
INSERT INTO ksc_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Na sana, annaà wi silawyu, siyan patiyonyu kumà saon ta mamfalin-ayu anà Apudyus.” Imfakan pu Jesus na sachi, lummayaw wi ummoy nantaru wi foon pù nampaila ta taku. ");
INSERT INTO ksc_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Uray nu ad-adchuwan na kaskaschaaw wi iningwan Jesus ta sangwanan na taku, issiyay foon à mamatichan siya. ");
INSERT INTO ksc_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ad sachin tummuttuwaan na imfakan Isaias wi profeta ta awi, wi anana, “Apu, maid pu mamati ta ifakani, ad maid ako mamati wi sian mangwa ta kaskaschaaw.” ");
INSERT INTO ksc_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Siyan foon pù mafalin wi pumaticha, tan na sachi inyug-is ako Isaias, anana, ");
INSERT INTO ksc_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Siyan isù kinurap Apudyus na atacha ya impatangkinnan somsomòcha ta achicha pu ilasin na katuttuwaan, ya ta achicha pu maawatan na mipangkop an siya; tan nu nansakungchan Apudyus, pakawanonan fasurcha.” ");
INSERT INTO ksc_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Inyug-is Isaias na sanat tan innilanan kina-Apudyus Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Uray nu sachi, achun pangpangun na Judio wi namati. Ngim achicha pu ipadlaw na pammaticha ta achicha pu miparyaw ta sinagogacha. ");
INSERT INTO ksc_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ad un-unnoyonchan manayawan na takun chicha nu manayawan Apudyus an chicha. ");
INSERT INTO ksc_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Asin ako kummingà Jesus, ad chinakorna, “Sinumani mamatin saon, foon à saon afus na patiyona, ngim patiyona kon sachi nangifaun an saon. ");
INSERT INTO ksc_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ya sinumani mangakammun saon, akammuna kon nangifaun an saon. ");
INSERT INTO ksc_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","À saon, ummaliyà ad asnay lutà manlawag ta somsomò na losani taku, siyan sinumani mamatin saon, marawakan na somsomòna ta achi pu iingkaw ta pangot. ");
INSERT INTO ksc_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Sinumani mangngor ta itudtuchù ad foon pù patiyona, foon à saon na manusan siya. Tan foon à ummaliyà ad asnay lutà manusa ta taku, tan na ummaliyà, ta saraknifà na taku. ");
INSERT INTO ksc_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ngim na takuy achi pu mangakseptar an saon, ya foon pù patiyonan itudtuchù, awad na manusan siyà tapin na padcha, tan na inug-ugkud-u, sachin mail-an na kachusaancha! ");
INSERT INTO ksc_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tuttuwachi, tan losani imfakà, foon à somsomòun narpuwana tan narpun Ama wi nangifaun an saon, tan siyan nangifaka ta losani ifakà. ");
INSERT INTO ksc_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Siyan ifakà na impaifakan Aman saon, tan akammù wi na imfakana, sachin mangatod ta mannaynayuni mafiyakan an siya.” ");
INSERT INTO ksc_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Chaan osay padcha ta fiyastay Mangiyakasmoan ta nallausan na anghel ta aappuni, ad inakammun Jesus wi chumatong na timpuy mangulinanad langit an Amana. Amod na ayatna ta chachi summurut an siya ad asnay luta, wi maid miyisuwan na mangayatanan chicha, ad impaipailanan ayatna ingkana ta natayana. ");
INSERT INTO ksc_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nangan-ani ta sachi wi lafi, wi anungus na nakaanan Jesus an chiani wi disipulusna, ad à Judas wi anà Simon Iscariote, narpas wi inawis Satan na somsomònà mangififik an Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","À Jesus, inakammuna wi impurang Amanan losani karobfongana, ad inakammuna ko wi Apudyus na narpuwana ya siya kon mangulinana. ");
INSERT INTO ksc_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ad na nangananni, summiad à Jesus ad inaannan kotap na silupna ad imfofodnan tuwarya ta awàna. ");
INSERT INTO ksc_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ad impiyasnan chanum ta parangkan ad illukinay mamarfar ta ikini wi disipulusna achinaot ipunas na tuwaryay imfofodna ta awàna. ");
INSERT INTO ksc_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Sachi ad wi chummatong an Simon Pedro, anan Pedro, “Apu, pam-ako farfaran na ikì?” ");
INSERT INTO ksc_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ad anan Jesus, “Foon pù maawatam ta sanan annayay oyyoò, ngim maawatam à awni.” ");
INSERT INTO ksc_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ad anan ako Pedro, “Kattoi achi pu mafalini sian mamarfar ta ikì!” Ad anan Jesus, “Nu achì pu farfaran na ikim, achia pu mifilang à disipulus-u.” ");
INSERT INTO ksc_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","“Nu amasnat, Apu,” anan Pedro, “foon à afus na ikì à farfaram, uray na imà ya urù!” ");
INSERT INTO ksc_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ngim anan Jesus, “Na nar-us nan-amos, foon à masapur misarad maamos tan pumopor-as, siyan afus na ikinà mafarfaran. Pumopor-as-ayu losan, ngim awad an chiayun osay foon.” ");
INSERT INTO ksc_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Inakammun Jesus na mangififik an siya, ad sachin nangifag-ana, “Awad na osay foon pù mampor-as.” ");
INSERT INTO ksc_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kinangput ad Jesus finarfaran na ikini, asinna innigkan silupna ad tummùchu. Ad ananan chiani, “Maawatanyun iningwà an chiayu? ");
INSERT INTO ksc_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Siya ananyun saon na misturuyu ya Apuyu, ad ustu met na ifakayu tan tuttuwa. ");
INSERT INTO ksc_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Siyan saoni Apuyu ya misturuyu, nu saon na mamarfar ta ikiyu, masapur kuma wi man-asifarfar-ayu ko ta ikiyu. ");
INSERT INTO ksc_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Iningwà na annaya ta awad turachonyu, ta sachi kuman oyyoonyu ta uchum. ");
INSERT INTO ksc_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tuttuwan ifakà an chiayu: maid sanilù nangatngatu nu apuna, ya maid ako mafaun à nangatngatu nu sachi nangifaun an siya. ");
INSERT INTO ksc_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Siyan kapu ta maawatanyun piò wi ifaka, lumagsak-ayu nu oyyoonyu! ");
INSERT INTO ksc_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Achì pu ifakan sanat an chiayu losan, tan akammù na kinatatakuyuy piniliyà, ya akammù akoy awad na osan chiayuy achi pu michoka ta annay ifakà. Ngim masapur tumuttuwan sachi niyug-is wi ukud Apudyus, wi anana, ‘Na osay nakàakàan an saon, siya kon mamatoy an saon.’ ");
INSERT INTO ksc_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ifakà na annayan chiayu ta sanay chaan pu màwa, ta nu màwa, siyan manuttuwaanyu wi tuttuway saon na impustan Apudyus wi umali. ");
INSERT INTO ksc_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tuttuwan ifakà an chiayu: sinumani mangipatog ta takuy ifaun-u, patkana kò saon; ad nu patkanà saon, patkana kon sachi nangifaun an saon.” ");
INSERT INTO ksc_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Na nangifag-an Jesus ta anchanaya, summauy, ad anana, “Tuttuwan annayay ifakà: awad na osan chiayu wi mangififik an saon.” ");
INSERT INTO ksc_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ad nan-asiilaani wi disipulusna tan maid inakammuni nu sinun ustuy imfakana. ");
INSERT INTO ksc_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Saoni ay-ayaton Jesus, nichachar-akà an siya wi tummutùchu. ");
INSERT INTO ksc_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Siyan siningyaranà an Pedro ta imusò an Jesus nu sinun takuy ukuchona. ");
INSERT INTO ksc_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ad nisachakà an Jesus achìwot imuson, “Apu, sinun takuy ug-ugkuchom?” ");
INSERT INTO ksc_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ad anan Jesus, “Na takuy mangadchà ta tinapoy wi ilunong-u, siya!” Ad illunong Jesus na tinapoy ad inadchonan Judas wi anà Simon Iscariote. ");
INSERT INTO ksc_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ad innaran Judas na sachi tinapoy, ad na sachi, nan-uwan Satan à siya. Ad anan Jesus, “Ing-a ta aw-awaynuy mangwa ta sanati som-osom-om!” ");
INSERT INTO ksc_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ngim chiani wi nan-ooan, foon pù maawatanni nu sinun sachi imfakan Jesus an Judas. ");
INSERT INTO ksc_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Na uchum, anancha pun nu imfaun Jesus à siyà mangnginà masapurni ta fiyasta, winnu mangatod à pilak ta kakapus, tan Judas na nanangchon ta pilak. ");
INSERT INTO ksc_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ad inawat pu Judas na tinapoy, lummayaw. Lafin nàwaan losan na anchanaya. ");
INSERT INTO ksc_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Lummayaw pù Judas, imfakan Jesus an chiani, “Saoni namfalin taku, chummatong ta sanan kachayawà. Ad nu machayawà, machayaw akò Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Siyan nu saon na mangipaila ta kachayawan Apudyus, ipailan ako Apudyus na kachayawà, ad sanan màwaana. ");
INSERT INTO ksc_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Chiayuy isù anàu, sin-aitan yakan ingkawà an chiayu. Ad nu awni, anaponà an chiayu. Siyan na imfakà ta chachi pangpangun na Judio, isarad-u ifakan chiayu, wi achiayu pu makaali ta umayà. ");
INSERT INTO ksc_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Awad na adchatuy lintog wi ifilin-un chiayu: masapur man-asiay-ayat-ayu. Na isun na mangayatà an chiayu, sachi kon isuwonyuy man-asiayat. ");
INSERT INTO ksc_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tan nu man-asiay-ayat-ayu, ilasin na losani taku wi chiayun disipulus-u.” ");
INSERT INTO ksc_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sachi ad anan Simon Pedro, “Apu, sinu kon umayam?” Ad anan Jesus, “Achiayu pu makaali ta umayà ta sana, ngim mitun-ud-ayù tapin na padcha.” ");
INSERT INTO ksc_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ad anan Pedro, “Apu, tamako achiyà pu makatun-ud an sia ta sana? Tan nakasakanaà wi mitun-ud an sia, uray matoyà!” ");
INSERT INTO ksc_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ad anan Jesus, “Tuttuway nakasakanaay makàtoy an saon? Tuttuwan ifakà an sia, Pedro: nu chaan pun na awitan manullaù à awni, namitluwonà illifak.” ");
INSERT INTO ksc_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Sachi ad imfakan Jesus an chiani wi disipulusna, “Achiayu machanakan ta uray sinuman. Piyaronyù Apudyus, ya piyaronyu kò saon. ");
INSERT INTO ksc_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ad-adchuwan na màkawan ta foroy Ama. Siyan inyà umuna mangisakanà ingkawanyu. Nu foon pù tuttuwa, achì pun na imfakan chiayu. ");
INSERT INTO ksc_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ad nu marpas-u isakanan ingkawanyu, mangulinà akoy mangaran chiayu, ta na ingkawà, sachi kon ingkawanyu. ");
INSERT INTO ksc_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Akammuyun charan wi umoy ta sachi umayà.” ");
INSERT INTO ksc_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Anan Tomas an siya, “Apu, maid pu akammuni ta umayam, siyan sinun mangakammuwanni ta charan nù?” ");
INSERT INTO ksc_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ad anan Jesus an siya, “Saon na charan wi umoy an Apudyus, siyan maid pu makaoy an siya nu foon à saon na mangiyoy. Saon akon puun na tuttuway mapati, ya saon akon marpuwan na mannaynayuni fiyag. ");
INSERT INTO ksc_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Siyan nu illasinyù saon, ilasinyu kò Ama. Ad manipud ta sana, tuttuway illasinyù siya tan innilayu.” ");
INSERT INTO ksc_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ad anan ako Felipe an siya, “Apu, ipailam à Amam an chiani, ta mat-op-ani.” ");
INSERT INTO ksc_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ad summongfat à Jesus wi anana, “Felipe, nafayakà wi iniingkaw an chiayu losan, ad chaannu pù ilasin à saon? Na nangilan saon, innilana kò Ama. Ad apay ifakam an saon wi ipailà à Ama an chiayu? ");
INSERT INTO ksc_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Achiyu pu tuttuwaon wi man-isuanin Ama? Losan na imfakà an chiayu, foon pù somsomòun narpuwana tan narpun Ama wi awad an saon. Ya losan na iningwà, sachin man-iwaaranan saon. ");
INSERT INTO ksc_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tuttuwaonyu kuman ifakà wi man-isuanin Ama. Ad nu achiyu pu tuttuwaon na annayay ifakà, tuttuwaonyu kuma kapu ta oy-oyyoò. ");
INSERT INTO ksc_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Tuttuwan ifakà an chiayu: sinumani mamatin saon, mafalini oyyoonan isun na iningwà. Ya chakchakor akon lisortan na oyyoona nu iningwà, tan mangulinà an Ama à katurunganyu. ");
INSERT INTO ksc_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ad na sinumani chawatonyun Ama kapu ta pammatiyun saon, oyyoò à kachayawan Ama, wi na machayawana, mipakapun saon wi Anàna. ");
INSERT INTO ksc_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Uray sinumani chawatonyu kapu ta pammatiyun saon, oyyoò.” ");
INSERT INTO ksc_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ad inturuy Jesus wi anana, “Nu tuttuway ay-ayatonyù saon, kapilitani oyyoonyun filin-u. ");
INSERT INTO ksc_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ad ifakà akon Ama ta ipaalinan misukat an saon ta siyan Tumuturung an chiayu. Siyan Ispiritun Apudyus wi makarong-ag an chiayù ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ad siya kon mangipaakammu ta katuttuwaan mipangkop an Apudyus. Achi pu mafalin wi maatod na Ispiritun Apudyus ta takuy foon à mamati, tan achicha pu imatunan à siya, ad foon akò maawatanchan mipangkop an siya. Ngim chiayu, maawatanyun mipangkop an siya tan iingkaw an chiayu, tan makarong-ag an chiayù ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ad uray lumayawà, foon pù fayfay-anà chiayu, tan mangulinà. ");
INSERT INTO ksc_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ngim foon à mafayag ad achiyà pu asin ilan ta chachi foon à mamatid asnay luta; ngim chiayu, asinyu ilan à saon. Kapu ta matakuwà à ing-ingkana, matakuayu kò ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ad nu chumatong na màwaan na annaya, sachin mangakammuwanyuy ingkawà an Ama. Ya isuna kon chitau, tan ingkaw-ayun saon ya isunay ingkawà an chiayu. ");
INSERT INTO ksc_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Sinumani mangngor ta filin-u ya patkona, siyan tuttuway mangay-ayat an saon. Ad kapu ta inay-ayatà, ay-ayaton Amà siya. À saon, ay-ayatò akò siya, siyan ipaakammù an siyan losani mipangkop an saon.” ");
INSERT INTO ksc_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Sachi ad nan-ukud à Judas wi foon à Iscariote, wi anana, “Apu, apay chiani kan mampaakammuwam ta mipangkop an sia, wi foon pun à chachi taku wi foon à mamati?” ");
INSERT INTO ksc_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ad anan Jesus, “Na takuy mangay-ayat an saon, kapilitani patkonchan filin-u, siyan ay-ayaton Amà chicha. Ad à chianin Ama, ingkaw-ani kon chicha. ");
INSERT INTO ksc_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Na takuy foon à mangay-ayat an saon, foon pù patkonchan filin-u. Na losani imfakà, foon à somsomòun narpuwana ngim narpun Ama wi nangifaun an saon. ");
INSERT INTO ksc_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Imfakà losan na anchanayan chiayu ta annay ingkawà an chiayu. ");
INSERT INTO ksc_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ad na Tumuturung wi ipaalin Apudyus an chiayu, wi siyan Ispiritu wi misukat an saon, siyan mangitudtuchun chiayu ta losani chaan pù mipaakammu, ya ipaspasmòna kon losani imfakà. ");
INSERT INTO ksc_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Siyan uray lumayawà, tumarnan somsomòyu tan adchò an chiayun matarnaan na somsomò wi marpun saon. Na losani luta, maid pu makaatod ta isun na annayay matarnaan na somsomò. Siyan achiayu machanakan ya achiayu umogyat. ");
INSERT INTO ksc_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Chingngoryun imfakà an chiayu, wi lumayawà ad mangulinà asin. Siyan nu tuttuway ay-ayatonyù saon, maragsak-ayu kuma kapu ta umayà an Ama wi siyan nangatngatu nu saon. ");
INSERT INTO ksc_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Imfakà losan na anchanayan chiayu ta chaancha pù màwaan, ta nu màwa, sachin manuttuwaanyu ta pammatiyun saon. ");
INSERT INTO ksc_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Manipud ta sana, maid achù ifakà an chiayu, tan à Satan wi turay na takud asnay luta, chanchanin timpuy mamachasanan saon mangafakan. Ngim maid pu karobfonganay mangafak an saon. ");
INSERT INTO ksc_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ngim uray, miparufus na oyyoona tan masapur maawatan na takud asnay luta wi ay-ayatò à Ama, siyan oyyoò losan na imfakana.” Sachin anan Jesus, ad imfakana kon chiani, “Intau, lumayawtaud asna.” ");
INSERT INTO ksc_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Sachi ad nan-alig à Jesus, wi anana, “Saon na isù puun na osay imong, ad à Ama, siyan isù manarkon ta imong. ");
INSERT INTO ksc_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Chachi takuy mamatin saon, chichan isù pangà. Ad nu awad pangà wi achi pu mamunga, pangapangan Ama. Ngim chachi mamunga wi panga, charucharusan Ama ta umachun fungacha. ");
INSERT INTO ksc_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Isuayù nacharusan kapu ta intudtuchù an chiayu. ");
INSERT INTO ksc_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Siyan kanayun-ayu mamatin saon ta kanayunà iingkaw an chiayu. Isun na sachi panga, achi pu mamunga nu maid pu puunna, tan na puunna siyan marpuwan na fiyagna. Isuna kò chiayu, tan nu achiayu pu mamati kanayun an saon, achiayu pu makafunga tan achiayu pu makàwa ta mamfaruwò. ");
INSERT INTO ksc_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Saon na puun na imong ad chiayun pangà. Siyan na takuy mamati kanayun an saon, ya iingkawà an siya, mamungà achu tan oy-oyyoonan achuy mamfaruwò. Ngim nu maichà an chiayu, achiayu pu makàwa ta mamfaruwò. ");
INSERT INTO ksc_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Na takuy foon pù mamati kanayun an saon, siyan isù panga wi mifallu. Marangu ya maugpun ad maapuyan. ");
INSERT INTO ksc_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Siyan nu kanayun-ayu mamatin saon, ya maimuran intudtuchù ta somsomòyu, mafalini chawatonyun uray sinuy pionyu, ad màwan chiayu. ");
INSERT INTO ksc_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nu mamungaayù achu, siyan machayawan Ama, ad sachi kon mangipail-ana wi chiayun tuttuway disipulus-u. ");
INSERT INTO ksc_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Na isun na mangay-ayatan Aman saon, sachi kon mangay-ayatà an chiayu. Siyan ifainyu kuman ayat-un chiayu. ");
INSERT INTO ksc_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ad nu patkonyun intudtuchù, tuttuway ifainyun ayat-un chiayu, wi isun saon wi ifain-un ayat Ama an saon tan patkò na imfakana. ");
INSERT INTO ksc_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Imfakà an chiayun anchanaya ta michokaayu ta lagsak-u, ta maid pu kurang na lagsakyu. ");
INSERT INTO ksc_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Annayan ifilin-un chiayu: man-asiay-ayat-ayu wi isun na mangay-ayatà an chiayu. ");
INSERT INTO ksc_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Maid osà achakran à ayat nu foon à ayat na takuy mangatod ta long-agna ta matoy à manakuwana ta fufurunna. ");
INSERT INTO ksc_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Chiayun tuttuway fufurun-u nu patkonyun filin-un chiayu. ");
INSERT INTO ksc_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Achì pu anani sanilù chiayu ta sana, tan na sanilu, maid akammunà turung na pàwan na apunan siya. Ngim ifilang-u chiayù fufurun-u, tan losani imfakan Aman saon, imfakà akon chiayu. ");
INSERT INTO ksc_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Foon à chiayun namilin saon à umapuwanyu, ngim saon na namilin chiayù mamatin saon, ad chinutukà chiayù mamungà achu. Ad mannaynayun akon fungayu, ta uray nu sinun chawatonyun Ama mipakapun saon, adchonan chiayu. ");
INSERT INTO ksc_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Siyan annayan ifilin-un chiayu: man-asiay-ayat-ayu losan. ");
INSERT INTO ksc_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Achiayu maschaaw nu kuraon chiayu ta takud asnay luta wi foon pù mamatin saon, tan kinurachà saon inuna. ");
INSERT INTO ksc_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tan nu man-iisun somsomòyu ta chachi taku, ay-ayaton chiayu. Ngim kapu ta nafaliwan na somsomòyu ya piniliyà chiayù mamati, sachin manguraanchan chiayu. ");
INSERT INTO ksc_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Achiyu maliwatan na imfakà an chiayu, wi maid sanilù nangatngatu nu apuna. Siyan kapu ta pinalikatanà ta chachi foon pù mamati, kapilitani palikatan chiayu ko. Ad na utupna ko, nu awad nanuttuwa ta intudtuchù, kapilitani awad akon manuttuwa ta itudtuchuyu. ");
INSERT INTO ksc_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ngim losani oyyoonchan chiayu, oyyooncha kapu ta pammatiyun saon, tan maid akammuchan Ama wi nangifaun an saon. ");
INSERT INTO ksc_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Nu foon pù ummaliyà ad asnay luta nantudtuchun chicha, mafalin nin wi ananchay maid fasurcha. Ngim kapu ta ummaliyà, maid manlasuncha ta fummasurancha. ");
INSERT INTO ksc_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tan sinumani manguran saon, kuraona kò Ama. ");
INSERT INTO ksc_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nu maid iningwà à kaskaschaaw wi maid takù makàwa, foon à mapafasurancha. Ngim kattoi innilacha chachì manuttuwaancha nu sinuwà, ad iissiyay kukullaonchà chianin Ama. ");
INSERT INTO ksc_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ngim màwa losan à tumuttuwaan na sachi niyug-is ta Lintogcha, wi ‘Kuraonchà saon à maid kapuna.’” ");
INSERT INTO ksc_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ad anana ko, “Ipaalì an chiayun sachi Tumuturung wi marpun Ama, wi siyan Ispiritun Apudyus, ya siya kon mangitudtuchu ta katuttuwaan an chiayu. Ad nu umali, tàchoranà an siya. ");
INSERT INTO ksc_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ya uray chiayu ko, tàchoranà akon chiayu tan chiayun nituntun-ud an saon nanipud ta lukin na nantudtuchuwà.” ");
INSERT INTO ksc_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ad anan Jesus, “Impaakammù losan na anchanayan chiayu, ta uray sinuy mapasamak foon pu kumà manchuwachuwan pammatiyun saon. ");
INSERT INTO ksc_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tan chumatong na mamaryawanchan chiayu ta sinagogayu, ad maam-amod tan chumatong akon timpu wi nu patoyoncha chiayu, ananchay sachi nun mangwaancha ta pion Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Na mangwaan ta taku ta amaschin chiayu, tan maid akammuchan Ama ya maid ako akammuchan saon. ");
INSERT INTO ksc_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ngim ipaakammù an chiayu ta sana ta nu chumatong na mangwaancha, sosom-onyu kuma wi impaakammù an chiayu. “Foon pù imfakà an chiayun losani anchanaya ta chamu tan iniingkawà an chiayu. ");
INSERT INTO ksc_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ngim ifakà ta sana, tan mangulinà ta sachi nangifaun an saon. Ad apay maid pu mangimus an saon ta umayà? ");
INSERT INTO ksc_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Oo, tan akammù wi isag-ayu mansasàuy kapu ta imfakà. ");
INSERT INTO ksc_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ngim tuttuwan annayay ifakà wi fumaruwanyun lumayawà, tan nu achiyà pu lumayaw, achi pu umalin sachi Tumuturung wi makarong-ag an chiayu. Siyan masapur wi lumayawà, ta ipaalì à siya. ");
INSERT INTO ksc_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ad nu umali, ipakaawatna ta atakutaku wi nasaw-àcha mipangkop ta fumasurancha, ad na osa, nu sinun tuttuway maid fasurna, ya mipangkop ako ta chusan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nasaw-à chachi foon pù mamati mipangkop ta tuttuway fumasuran, tan na tuttuway fumasuran siyan achicha pu mamatiyan an saon! ");
INSERT INTO ksc_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ad nasaw-àcha ko mipangkop nu sinun tuttuway maid fasurna, tan na maid fasurna, saon, wi na matuttuwaana, mangulinà an Ama ad langit wi achiyà asin ilan an chicha. ");
INSERT INTO ksc_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ya nasaw-àcha ko mipangkop ta kachusaan na taku, tan nar-us nifakan kachusaan Satan wi siyan manturay ta losani foon pù mamati. ");
INSERT INTO ksc_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Achun piò wi ifakan chiayu, ngim akammù wi achiayu pu makaawat ta losan. ");
INSERT INTO ksc_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ngim nu umalin Ispiritun Apudyus wi mangitudtuchun chiayu ta katuttuwaan mipangkop an Apudyus, itudtuchuna kon tuttuway mapati. Ya foon pu kò somsomònan marpuwan na itudtuchuna, tan siya ifakanan chingngorna. Ad ipaakammuna kon màwà tapin na padcha. ");
INSERT INTO ksc_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ad ipachayawna kò saon, tan losani intudtuchù, nipiyar an siya wi mangipakaawat an chiayu. ");
INSERT INTO ksc_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Na losani awad an Ama, awad ako losan an saon, ad sachin mangifag-à wi na Ispiritu, saon na marpuwan na itudtuchunan chiayu.” ");
INSERT INTO ksc_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ad inturuy Jesus wi anana, “Foon à mafayag ad chumatong na timpuy achiyu pu mangil-an an saon, ya foon akò mafayag ad asinyu ko ilan à saon.” ");
INSERT INTO ksc_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Na sachi, na uchum an chiani wi disipulus, ananchay nan-asiimus, “Sinun pionay ifaka? Tan ananay foon à mafayag ad maid ilantaun siya, ya foon akò mafayag ad asintau ilan à siya, ad anana nuy, ‘Tan inyà an Ama.’ ");
INSERT INTO ksc_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Sinun mining na imfakanay, ‘Foon à mafayag?’ Tan achitau pun maawatan nu sinun ukuchona!” ");
INSERT INTO ksc_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","À Jesus, inakammuna wi makaim-imus-ani, ad anana, “Anaponyu nu sinun mining na imfakà an chiayu, wi ‘Foon à mafayag ya maid ilanyun saon, ya foon pu kò mafayag ad asinyu ko ilan à saon’? ");
INSERT INTO ksc_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tuttuwan ifakà an chiayu: nu màwan anchanaya, man-ifil-ayu ya sumauy-ayu. Ngim chachi takud asnay luta wi foon à mamatin saon, lumagsakcha. Sumauy-ayu, ngim foon à mafayag ad na sauyyu, mamfalin lagsak. ");
INSERT INTO ksc_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Na miyalikana, isun na fufai wi mangkumut, wi ichamanan sikabna. Ngim nu fumùnag na anà, maliwatanan sikabna kapu ta lagsakna ta anàna. ");
INSERT INTO ksc_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Isunan chiayu, tan uray nu mansasàuy-ayu ta sana, foon pù mafayag ad lumagsak-ayu asin tan asintau man-asiila. Ad maid makaaan ta sachi wi lagsak wi ochasanyu. ");
INSERT INTO ksc_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Manipud ta sachi timpu, foon à saon na manchawatanyu, tan à Ama. Ya tuttuwan ifakà an chiayu, wi sinumani chawatonyun siya mipakapun saon, adchonan chiayu. ");
INSERT INTO ksc_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ingkana ta sana, maid chinawatyun Ama à nangiyusaranyu ta ngachan-u. Ngim ta sana, manchawat-ayu ad awatonyu ta maam-amod na lagsakyu à maid kumurangana.” ");
INSERT INTO ksc_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Inturuy Jesus wi mangifaka, “Ar-alig na pinangifakà an chiayu ta achanaya, ngim chumatong na timpu wi achiyà pu man-alig tan ilawag-uy mangifaka ta mipangkop an Ama. ");
INSERT INTO ksc_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ad nu chumatong na sachi wi timpu, Aman ustuy manchawatanyu wi usaronyun ngachan-u, tan foon à masapur wi saon na mangichawat para an chiayu, ");
INSERT INTO ksc_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","tan amod na ayat Ama an chiayu kapu ta ayatyun saon ya namatiyanyu wi siyan narpuwà. ");
INSERT INTO ksc_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tan tuttuway ummaliyà ad asnay luta wi narpun Ama, ad ta sana, lumayawà ad asnay luta ta mangulinà an siya.” ");
INSERT INTO ksc_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Sachi ad nan-ifakani wi disipulusna, ananni, “Ilam, maawatanni ta sanan ifagfakam tan foon à alig. ");
INSERT INTO ksc_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ad na sana, sikurachuani wi akammum na losan, wi uray na simmosimmòni, siyan foon à masapur wi mansarudsud-ani. Ad sachin mamatiyanni wi Apudyus na narpuwam.” ");
INSERT INTO ksc_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Sachi ad anan Jesus an chiani, “Tuttuway patiyonyu? ");
INSERT INTO ksc_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tan chanchanin timpuy mafuaranyu, wi waschi osa umoy ta foroyna wi manaynan an saon. Ngim foon à ab-abfussanà tan iingkaw à Aman saon. ");
INSERT INTO ksc_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Impaakammù an chiayun anchanayay chaan pu màwa ta tumartarnan somsomòyu kapu ta pammatiyun saon, tan palikatan chiayu ta takud asnay luta. Ngim pumigsa kuman somsomòyu tan inafak-un Satan wi manturay ad asnay luta!” ");
INSERT INTO ksc_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Sachi ad wi imfakan Jesus na anchanaya, nantangad ad langit ad nalluwaru, wi anana, “Ama, chummatong na timpu wi màwaan na losani màwan saon. Siyan pachayawom à saon, wi sachin mangipachayawà akon sia. ");
INSERT INTO ksc_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Impiyarnun saon na karobfongà wi mamiyang ta losani taku wi piniliyam wi mamatin saon, ta adchò an chichan mannaynayuni fiyag. ");
INSERT INTO ksc_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ad na mangawatancha ta mannaynayuni fiyag, tan patiyoncha wi sian tuttuway Apudyus, ya patiyoncha ko wi saon na Cristu wi impustam wi umalid asnay luta. ");
INSERT INTO ksc_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ama, impailà na kachayawam ad asnay luta, tan limpas-u iningwa na losani impàwam an saon. ");
INSERT INTO ksc_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Siyan na sana, Ama, asinnu pachayawon à saon ta sangwanam wi isun na chamuy kachayawanta ta chaan pun na luta màwaan. ");
INSERT INTO ksc_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Na anchanayay disipulus-u, foon à mamaticha ta chamu, ngim kapu ta piniliyam chicha wi mamatin saon, impakaawat-un chichan mipangkop an sia, ad pinatichan ukudnu. Takum chicha, ngim innadchom an saon. ");
INSERT INTO ksc_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ad na sana, maawatancha wi losani awad an saon, sian narpuwana tan sian nangatod. ");
INSERT INTO ksc_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ad intudtuchù an chichan losani imfakam an saon, ad pinaticha losan. Siyan tinuttuwacha wi sian narpuwà ya sian nangifaun an saon. ");
INSERT INTO ksc_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Siyan chawatò na turungnun chicha. Foon pù iluwaruwà chachi foon pù mamati, ngim afus chachi mamati wi innadchom an saon na iluwaruwà, tan takum chicha. ");
INSERT INTO ksc_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tan losani taku wi mamatin saon, takum chicha, ya takù ako. Ad mipachayawà mipakapun chicha. ");
INSERT INTO ksc_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ad mangulinà an sia Ama, wi taynà ad asnay luta, ngim mataynan ako losan na anchanayay innadchom an saon. À siay machayawi Ama, usarom na mannakafalinnu wi mangayyuwan an chicha, ta mantitimpuyugcha isun na nantimpuyukanta. ");
INSERT INTO ksc_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Na iningkawà an chicha, inayyuwanà chicha wi inyusar-un mannakafalinnu wi innadchom an saon. Siyan maid pu osà natarà, afus na sachi matarà à tumuttuwaan na sachi niyug-is. ");
INSERT INTO ksc_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Mangulinà an sia, ad ipagngor-un chichan annayay ifakà an sia ta makaragragsakchan saon wi maid makurangana. ");
INSERT INTO ksc_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Intudtuchù an chichan losani imfakam an saon, ad sachin mangurkuraan chachi foon à mamati an chicha, tan isuchà saon, wi foon pù itimpuyug-un somsomòu ta chachi foon pù mamati. ");
INSERT INTO ksc_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ama, foon pù ifakà wi ilayawnu chicha ta umachayucha ta chachi foon pù mamatid asnay luta, tan na chawatò, ta ayyuwanam chicha ta achicha pu maawis an Satan. ");
INSERT INTO ksc_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Na somsomòcha, isun na somsomòu wi foon à isun na somsomò chachi foon pù mamati. ");
INSERT INTO ksc_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Siyan usarom na imfakam wi katuttuwaan à mangipapigsa ta somsomòchan sia ta oyyooncha afus na imfakam. ");
INSERT INTO ksc_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Imfaun-u chichà umoy mangitudtuchu ta ukudnu ad asnay luta, wi isun na nangifaunam an saon. ");
INSERT INTO ksc_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Adchò na long-ag-un sia wi matoy à para an chicha, ta pungsanom man-uwa chicha. ");
INSERT INTO ksc_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Foon à afus na anchanayay mamati ta sanà iluwaruwà, tan uray na losani mamatin saon kapu ta itudtuchucha. ");
INSERT INTO ksc_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ad na chawatò ako, ta mitimpuyugchan chita wi isun na nantimpuyukanta. Tan na mantitimpuyukancha, sachin mamatiyan na atakutaku wi sian tuttuway nangifaun an saon. ");
INSERT INTO ksc_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Na nangipachayawam an saon, isuna kon mangipachayawà an chicha ta mitimpuyug na somsomòcha wi isun na somsomòta. ");
INSERT INTO ksc_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kanayun-a iingkaw an saon ya kanayunà iingkaw an chicha ta maturungancha wi mantitimpuyug, tan sachin mangil-an na atakutakud asnay luta wi sian nangifaun an saon. Ya ilasincha ko wi ay-ayatom na anchanay mamatin saon wi isun na mangay-ayatam an saon. ");
INSERT INTO ksc_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ama, na chaan pun na luta màwaan, innadchom an saon na kachayawà kapu ta ayatnun saon. Ad na piò ta anchanayay piniliyam wi mamatin saon, iingkawchan saon ya ilanchan kachayawà à ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ama wi afaruwan, na chachi foon pù mamatin sia, tuttuway maid akammuchan sia. Ngim à saon, akammù sia. Ad na anchanayay mamatin saon, akammucha wi sian nangifaun an saon, ");
INSERT INTO ksc_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","tan intudtuchù an chichan mipangkop an sia. Ad iturturuy-u ko wi mangipakaawat an chicha losan ta mipangkop an sia, ta na pinag-ayatnun saon, sachi kon man-asiay-ayatancha, ta iingkawà akon chicha.” ");
INSERT INTO ksc_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Sachi ad wi narpas na nalluwaruwan Jesus, impuyutnà chiani wi disipulusna ad chinomangnin nadchù wi wail ad Kidron. Ad ummoy-ani ta im-imong. ");
INSERT INTO ksc_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ad à Judas wi nangififik an Jesus, inakammunan sachi ikaw tan sachin sisib-atannin Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Siyan intun-ud Judas na susurchachu ya uchumi kuwarcha wi imfaun na pangpangun na papachi ya Fariseo. Nan-ar-armascha ya nansisilawcha losan. ");
INSERT INTO ksc_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Inakammun Jesus na losani mapasamak an siya, siyan ummoy nisib-at an chicha, wi anana, “Sinun anaponyu?” ");
INSERT INTO ksc_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","An anancha, “Jesus wi iNazaret.” À Judas wi nangififik, niyaslang an chicha. Ad anan Jesus, “Saon met.” ");
INSERT INTO ksc_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Na nangifag-an Jesus, “Saon met,” nansunodcha ad nampakrobcha. ");
INSERT INTO ksc_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ad inimus Jesus asin, “Ad, sinun anaponyu?” Ad anancha ko, “Jesus wi iNazaret.” ");
INSERT INTO ksc_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Imfakà an chiayu wi saon met,” anan Jesus. “Siyan nu saon na anaponyu, achiyu itapin anchanayay fufurun-u.” ");
INSERT INTO ksc_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ifakan Jesus na sachì tumuttuwaan na imfakanan Amana ta nangifag-ana, “Maid pu osà natarà ta takuy innadchom an saon.” ");
INSERT INTO ksc_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Sachi ad, à Simon Pedro wi nangkakamman, linùpusnan kamanna ad finaagnà Malco wi sanilun na Angatuwani Pachi, ad napingas na chiwawani ingana. ");
INSERT INTO ksc_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ad anan Jesus an Pedro, “Ibroynun kamannu! Apay, anam pun nu achì pu iparufus na pion Ama wi màwan saon?” ");
INSERT INTO ksc_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Sachi ad, chachi susurchachu ya kumandercha, ya chachi kuwarcha wi Judio, tiniliwchà Jesus ad kinachilaanchà siya. ");
INSERT INTO ksc_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ad inyoychan Anas, wi atukangan Caifas wi Angatuwani Pachi ta sachi tawon. ");
INSERT INTO ksc_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","À Caifas akon nangifaka ta chachi furunnay Judio wi un-unnoy na osà matoy à masubfutan na losan. ");
INSERT INTO ksc_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Sachi ad, chianin Simon Pedro, nitun-ud-anin Jesus. Ad kapu ta inakammuwà ta sachi Angatuwani Pachi, imparufusà wi makarnò an Jesus ta paway na foroyna. ");
INSERT INTO ksc_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ngim nataynan à Pedro ta lasin na arad. Siyan namagkulinà à nakaukud ta fufai wi man-iib-at ta liwangan ta parnoona kumà Pedro. ");
INSERT INTO ksc_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ad linumnò pun, anan na sachi fufai an siya, “Sian osa met ta disipulus Jesus!” “Foon,” anan Pedro. ");
INSERT INTO ksc_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nan-apuy na sasannilu ya kuwarcha ta paway tan tungnin, ad naag-agsadchay man-anichu. Siyan ummoy akò Pedro nakaanichu. ");
INSERT INTO ksc_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","À Anas wi Angatuwani Pachi ta sin-arkawan, inimfistikarnà Jesus mipangkop an chiani wi disipulusna, ya mipangkop ta itudtuchuna. ");
INSERT INTO ksc_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ad summongfat à Jesus wi anana, “Losani nantudtuchuwà, sangwanan na taku ta sinagoga ya Templo wi makimkimungantau losan, siyan maid milifak à intudtuchù. ");
INSERT INTO ksc_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Siyan apay saon na mansarudsucham wi foon à chachi nangngor, tan chingngorcha met na losani intudtuchù.” ");
INSERT INTO ksc_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Imfakan pu Jesus na sachi, linipak na osay kuwarchà siya ad anana, “Apay, amasnat na pinagsongfatnu ta Angatuwani Pachi?” ");
INSERT INTO ksc_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","“Nu awad lawing à imfakà,” anan Jesus, “ifakam na arwingana. Ngim nu ustun imfakà, taako lumipak?” ");
INSERT INTO ksc_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Sachi ad pin-oy Anas à Jesus, wi natatàod na imana, an Caifas wi Angatuwani Pachi ta sachi timpu. ");
INSERT INTO ksc_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","À Simon Pedro, issiyay nakaan-annichu ta paway. Ad inimus na uchum an siya, “Sian osa met ta disipulus Jesus!” Ngim illifak Pedro wi anana, “Foon.” ");
INSERT INTO ksc_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Sachi ad, nan-ukud na osay sanilun na Angatuwani Pachi, wi akin na sachi finaag Pedro, ad anana, “Kattoi innilà sia ta sachi im-imong, wi finurnam à Jesus.” ");
INSERT INTO ksc_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ad asin Pedro illifak, ad nanullaù na awitan. ");
INSERT INTO ksc_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Na sachi wi figfikat, illayawchà Jesus ta foroy Caifas, ad inyoychà siya ta pisinan na fifinnachur wi iRoma. Ngim chachi pangpangun na Judio, foon à linumnòcha ta pisina tan ipakarupchà makaisawancha nu lumnòcha ta foroy na foon à Judio. Ad nu lumnòcha, achi pu mafalini makaancha ta sachi fiyasta wi Mangiyakasmoan wi machanchani chumatong. ");
INSERT INTO ksc_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Siyan à Pilato wi fifinnachur, lummaway makaukud an chicha. Anana, “Payuko iyalin sanati takud asna? Ad sinun mangicharumanyu?” ");
INSERT INTO ksc_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ad sinongfatan chachi Judiò Pilato wi anancha, “Apay, iyalinì siyad asna nu maid fasurna?” ");
INSERT INTO ksc_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ad anan ako Pilato, “Ikadyu kay, ta aranyu ta chiayun manguis à manurutanyu ta lintogyu.” Ad anan chachi Judio, “Oo, ngim chiayuy iRoma, achiyu pu parufusan chiani wi pumatoy à taku.” ");
INSERT INTO ksc_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Amaschin iningwachan Jesus à tumuttuwaan na sachi imfakanay mipangkop ta karasin na matayana. ");
INSERT INTO ksc_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Sachi ad, asin linumnò à Pilato ta pisinana, ad impaayagnà Jesus, ad sinarudsudna, “Sian Alin na Judio?” ");
INSERT INTO ksc_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ad summongfat à Jesus wi anana, “Tuttuway piomi maawatan nu sinuwà? Winnu ifakamnat tan chingngornun imfakan na taku?” ");
INSERT INTO ksc_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ad anan Pilato, “Apay, Judiowà ta akammù na mipangkop an sia? Na anchanayay kailiyam wi Judio ya chachi pangpangun na papachiyu, chichan nangicharum an sia. Ad sinun iningwam?” ");
INSERT INTO ksc_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ad anan Jesus, “Foon à asnay lutan ustuy man-Aliyà, tan nu man-Aliyà ad asnay luta, kapilitani nakapatoy na chachi disipulus-u ta achiyà pu matiliw ta chachi pangpangun na Judio. Ngim foon pù annay lutan ikaw na kina-Alì.” ");
INSERT INTO ksc_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","“Nu amasnat, tuttuway Alia?” anan Pilato. Ad anan Jesus, “Ustun ifakam. Tan na katuttuwaan, na pangkop-uy umalid asnay luta miyanà à taku, ta ipaakammù na katuttuwaan. Ad sinumani maryad ta katuttuwaan, patiyonan ifakà.” ");
INSERT INTO ksc_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","“Ad, maakammun katuttuwaan?” anan ako Pilato. Sachi ad asin lummawà Pilato wi man-ukud ta chachi taku. Anana, “Maid inchasà à fasur na annayay taku. ");
INSERT INTO ksc_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Siyan kapu ta awad na ukaliyu wi nu chumatong na annayay fiyastayu wi Mangiyakasmoan, awad kanayun na osay farud wi iparufus-u, siyan pionyuy iparufus-un annay Aliyuy Judio?” ");
INSERT INTO ksc_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Sachi ad asipapauycha wi anancha, “Foon à siyan parufusam ta à Barrabas na parufusam!” Na sachi Barrabas, akkawan. ");
INSERT INTO ksc_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Sachi ad, impaabchoy Pilatò Jesus ta susurchachuna. ");
INSERT INTO ksc_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ad chachi susurchachu, fummaliugchà lasi ad impayunguschan siya wi sachi nun koronana tan Ali, ad sinilupancha kò siyà mancharaag wi isù silup na Ali. ");
INSERT INTO ksc_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ad inamsiwcha kò siya wi anancha, “Kattoi annayan Alin na Judio!” Imfakacha ad na sachi, linipakcha pà siya. ");
INSERT INTO ksc_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Sachi ad asin ako lummawà Pilato ad imfakana ta chachi taku, “Iparawà na annayay taku à mangil-anyu wi maid pu inchasà à fasurna.” ");
INSERT INTO ksc_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ad imparawachà Jesus wi issiyan lasi ta uruna ya nasisillupan akò mancharaag. Ad anan Pilato, “Ilanyuna nu chaan-ayu pu mat-op!” ");
INSERT INTO ksc_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ngim na nangil-an chachi pangpangun na papachi ya chachi kuwarcha an Jesus, losancha inip-aw, “Ilansayù siya ta kros! Patoyonyù siya!” Ad anan Pilato an chicha, “Ikadyu kay nu ananyuy ilansayù siya, tan maid pu fasurnà inchasà.” ");
INSERT INTO ksc_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ad summongfat chachi takuy ad-adchuwan wi anancha, “À matungparan na lintogni wi Judio, masapur wi matoy na sanat tan iningwanan long-agnà anà anu Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Na nangngoran Pilato ta sachi, naam-amod na ogyatna. ");
INSERT INTO ksc_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ad asin ako Pilato imparnò à Jesus, ad sinarudsudna, “Sinun tuttuway narpuwam?” Ngim foon pù sumongfat à Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Siyan anan Pilato an siya, “Taàako achi songfatan? Apay, achim pu akammuy annan karobfongà wi mangiparufus an sia winnu mangiparansan sia?” ");
INSERT INTO ksc_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ad summongfat à Jesus wi anana, “Maid pu karobfongami mangwà uray sinuy oyyoom an saon nu foon à iparufus Apudyus. Siyan na takuy nangipurang an saon an sia, chakchakor na fasurna nu sia.” ");
INSERT INTO ksc_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Chingngor ad ako Pilato na sachi, inyanapnan oyyoonay mangiparufus an Jesus. Ngim nampaupauy chachi taku wi anancha, “Nu parufusam à siya, foon pù Ali Cesar na tàchoram tan annay afusurna. Tan sinumani mangifaka wi siyan Ali, isù pursonan saad na Alitaud Roma!” ");
INSERT INTO ksc_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Chingngor ad Pilato na impauycha, asinna ko imparawà Jesus, ad inyoyna ta ikaw wi manguisana ta taku, wi farfarun archanna, wi Gabata na ngachanna ta Hebreo wi ukud, ad tummùchù Pilato ta uùchuwana. ");
INSERT INTO ksc_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Na sachi uras, chanchanin mamatù, wi na mafikat, milukin sachi fiyasta wi Mangiyakasmoan. Sachi ad imfakan Pilato ta chachi taku, “Ikadyu, tan na annay Ali, tuttuway Aliyu!” ");
INSERT INTO ksc_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ad asipapauycha wi anancha, “Patoyonyù siya! Ilansayù siya ta kros!” Ad inimus Pilato, “Apay, patoyò na Aliyu?” Ad anan chachi pangpangun na papachi, “Maid uchum à Alini nu achi afus à Cesar!” ");
INSERT INTO ksc_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Sachi ad impurang Pilatò Jesus an chicha ta ikadcha wi mangilansa. ");
INSERT INTO ksc_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ad innarachà Jesus, ad impafuudchan siyan krosna wi mangiyoy ta lukar wi ananchay “Tung-ar na Uru,” wi Golgota na ngachanna ta Hinebreo. ");
INSERT INTO ksc_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ad illansachà siya ta krosna, ad iningkaw akon chuway nilansa, ad nangkawaonchà Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Iningkaw akon impaiyug-is Pilato wi impaotcha ta kros Jesus, wi anana, “Jesus wi iNazaret, wi Alin na Judio.” ");
INSERT INTO ksc_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Turuy karasi wi ukud na niyug-isana, wi Hebreo, Latin ya Griego. Ad-adchuwan na taku wi namasa, tan niyachanid Jerusalem ta sachi nilansaana. ");
INSERT INTO ksc_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Sachi ad ummoy chachi pangpangun na papachi an Pilato wi manlili, anancha, “Foon kumà inyug-isnuy ‘Alin na Judio’. Na inyug-isnu kuma, ‘Anana nu, Saon na Alin na Judio!’” ");
INSERT INTO ksc_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ad sinongfatan Pilato chicha, “Na piò wi miyug-is, sachin niyug-is.” ");
INSERT INTO ksc_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Narpas ad wi illansan chachi susurchachù Jesus, innarachan silupna ad nan-apatoncha ta marnobchay opat. Ad innaracha kon silupnay lagkoyloy. ");
INSERT INTO ksc_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ad nan-uukudcha wi anancha, “Achitau pu kissayon na annaya, ta mamfunfunuttau ta ilantau nu sinun mangin-uwa.” Amaschin tummuttuwaan na niyug-is wi ukud Apudyus wi anana, “Finingfingaychan silup-u ad namfunfunutanchan lagkoyloy wi silup-u.” Ad sachin iningwan chachi susurchachu. ");
INSERT INTO ksc_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Na sachi, ummaagsad-ani ancha inan Jesus ta achani ta krosna, wi iningkaw akon inaona wi sunud inana, ya Maria wi asawan Cleofas, ya Maria Magdalena. ");
INSERT INTO ksc_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ad sachi wi innilan Jesus à inana ya saoni disipulusna wi ay-ayatona, anana, “Ina, ifilangnù Juan à anànu.” ");
INSERT INTO ksc_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ad anana kon saon, “Siay Juan, inaom à Ina.” Ad nanipud ta sachi, iningkaw à inanan chiani. ");
INSERT INTO ksc_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Sachi ad, inakammun Jesus wi limpasna losan na nipiyar an siya, ad anana, “Nauwawà.” Inukudnan sachì tumuttuwaan na niyug-is wi ukud Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ad illunongchan impaawchay luput ta ilom ad impasupsupchan Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ad sinupsupan pu Jesus, anana, “Narpas losan.” Imfakana ad na sachi, nalluptungoy ad natoy. ");
INSERT INTO ksc_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Chachi pangpangun na Judio, ummoychan Pilato ifaka ta maptod kuman ikin chachi nilansa ta mallasun matayancha, ta maaancha ta kros. Tan nu mafikat, sachin fiyastacha wi kattoi panagngilin, siyan achi pu kuma iingkaw chachi nilansa ta kroscha. ");
INSERT INTO ksc_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Siyan ummoy chachi susurchachu manchatar ta ikin chachi nilansa. Pintodcha ad na ikin na chuwa, ");
INSERT INTO ksc_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ananchay isùnubchan uwan Jesus, ngim innilachay nanattoy, siyan foon pù pintodchan ikina. ");
INSERT INTO ksc_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ngim inchuyù na osay surchachun tufayna ta futì Jesus, ad nachisan lummoswan chara ya chanum. ");
INSERT INTO ksc_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Saon wi nangiyug-is ta annaya, innilà na losani nàwa, siyan tàchorà wi tuttuwa losan. Siyan tuttuwan annayay ug-ugkuchò, ta pumatiayu ko. ");
INSERT INTO ksc_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nàwa losan à tumuttuwaan na niyug-is wi ukud Apudyus, wi anana, “Maid pu osà maptod ta tung-arna.” ");
INSERT INTO ksc_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ya awad akon niyug-is wi anana, “Fufuyyaoncha kon sachi taku wi chinuyùcha.” ");
INSERT INTO ksc_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Narpas ad na sachi, iningkaw na osay iyArimatea, wi Jose na ngachanna. Namatin Jesus, ngim intarunan pammatina kapu ta ogyatna ta chachi pangpangun na Judio. Na sachi Jose, ummoynan Pilato imfaka ta aranan lachag Jesus. Ad intay-un Pilato, siyan ummoyna innara. ");
INSERT INTO ksc_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ad ummoy akò Nicodemo, wi siyan ummoy an Jesus ta sillafiyan. Ad inyoynan limampuruy kiluy fangfanguy mirra ya aloe wi mitapi ta natoyi milofon. ");
INSERT INTO ksc_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ad innarachan lachag Jesus, ad finussungcha ta luput wi narafuwan à fangfangu, wi sachin ukalini wi Judio nu awad ilofonni. ");
INSERT INTO ksc_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ad-adchaniyan ta nilansaan Jesus, iningkaw na im-imong. Ad na sachi im-imong, iningkaw na àoyyay lofon wi maid nilofon. ");
INSERT INTO ksc_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ad kapu ta machanchani milukin panagngilini padcha, ya achanin sachi lofon, sachin nangilobnanchan Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Wiswisnit pun ta Chumingku, ummoy à Maria Magdalena ta lofon. Chummatong pun, innilanay naiib-at na lofon. ");
INSERT INTO ksc_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Siyan nanodchà wi ummoyna ifakan chianin Pedro. Anana, “Illayawchan long-ag na Aputau ta lofon, ad maid akammuni nu sinun nangiyayancha!” ");
INSERT INTO ksc_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Sachi ad lummawaanin Pedro ta ing-ani ilan na lofon. ");
INSERT INTO ksc_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nanodchàani wi chuwa, ad kapu ta mamfilokà, saon na ummunay chummatong. ");
INSERT INTO ksc_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nayyuungà wi nangilad charom, ad afus na fussung à maila, ngim foon pù lumnoà. ");
INSERT INTO ksc_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ngim Pedro wi ummun-unud, nangaw-as ad charom, ad innilana kon fussung, ");
INSERT INTO ksc_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ya fussung na urunay nakupin naitalin. ");
INSERT INTO ksc_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Sachi ad linumnoà ako wi mangila. Na nangil-à, sachin namatiyà wi ummuli natakù Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tan na sachi timpu, chaanni pù maawatan na niyug-is ta awi wi ananay masapur matoy à Jesus ya umuli mataku. ");
INSERT INTO ksc_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Sachi ad, lummayaw-ani. ");
INSERT INTO ksc_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ngim à Maria Magdalena, iningkaw ta lasin na lofon, wi nan-ifiifil. Ad na man-ifilana, nayyuung wi mangilad charom, ");
INSERT INTO ksc_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ad innilanan chuway anghel wi nansisillupchà mamputilà, wi tummutùchu ta nifanatan na lachag Jesus. Na osa, tummutùchu ta uulluwan, ad na osa, tummutùchu ta ikkiyan. ");
INSERT INTO ksc_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Sachi ad inimuscha, “Paako man-ifiifil, sunud?” Ad anan Maria, “Tan illayawchan long-ag na Apuni, ad maid akammù ta nangiyayancha!” ");
INSERT INTO ksc_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Sachi ad nantuwili ad innilanà Jesus wi ummaagsad, ngim foon pù immatunanay siyà Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ad anan Jesus an siya, “Paako man-ifiifil, sunud? Ad sinu kon anapom?” Na somsomò Maria, anana pun nu siyan takuy mamfafantay ta murmura, siyan anana, “Nu sian nangilayaw an siya, pangaasim ta ifakam na nangigkaam ta inyà aran.” ");
INSERT INTO ksc_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Sachi ad imfakan Jesus an siya, “Maria!” Ad nasanakung à Maria ad anana ta Hinebreo, “Rabboni!” wi na pionay ifaka, “Apu!” ");
INSERT INTO ksc_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","“Oo, ngim achiyà ognan,” anan Jesus, “tan chaanà pu umoy an Ama ad langit. Ngim ing-a ifaka ta chachi fufuruntau wi inyà ad langit an Ama wi Apudyus, wi siya kon Amayu wi chayawonyu.” ");
INSERT INTO ksc_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Sachi ad ummalin Maria imfakan chiani wi disipulus Jesus wi innilanà Apu Jesus. Ad inisturyana losan na imfakan Jesus an siya. ");
INSERT INTO ksc_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mummaschom pun ta sachi wi Chumingku, naamung-ani wi disipulus Jesus ta foroy wi nichaig tan ummogyat-ani ta chachi pangpangun na Judio. Ad narnoswà Jesus wi nakaagsad an chiani, ad anana, “Annaà, ta mamfarun somsomòyu.” ");
INSERT INTO ksc_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Imfakana ad na sachi, impailanan imana ya futìna. Siyan amod na lagsakni ta nangil-annin siya. ");
INSERT INTO ksc_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Sachi ad anan ako Jesus an chiani, “Fumarun somsomòyu! Ifaun-u chiayù mantudtuchu wi isun na nangifaunan Aman saon.” ");
INSERT INTO ksc_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Sachi ad insap-uynan chiani, ad anana, “Awatonyun Ispiritun Apudyus. ");
INSERT INTO ksc_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Sinumani fasur na taku wi pakawanonyu, tuttuway mapakawan. Ad sinumani achiyu pu pakawanon, achi pu ko mapakawan.” ");
INSERT INTO ksc_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","À Tomas, wi ananchay Apil, wi osay furunni wi disipulus Jesus, niyaspur wi maid à siya ta sachi nampail-an Jesus an chiani. ");
INSERT INTO ksc_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Siyan inisturyanin nangil-annin Apu Jesus. Ngim anana, “Mafalin ayan sachi? Achì pu tuttuwaon ingkanà ilà na pilat na lansa ta imana, ya ingkanà agpachà na futìna.” ");
INSERT INTO ksc_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Na asini Chumingku, asin-ani naamung wi disipulus Jesus ta nanchaig wi foroy, ad nitimpuy iningkaw akò Tomas. Ad lummoswa kò Jesus, ad anana, “Annaà ako ta fumarun somsomòyu.” ");
INSERT INTO ksc_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ad ananan Tomas, “Annayan imà ta ilam ya ognam na pilatna, ya agpacham na futìu ta tuttuwaom. Achi kuma manchuwachuwan pammatim an saon!” ");
INSERT INTO ksc_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ad anan Tomas, “Apu, patiyò wi sià Apudyus!” ");
INSERT INTO ksc_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","“Mamfaru tan tuttuway mamatia kapu ta innilam,” anan Jesus. “Ngim simfumaru chachi chaan pù mangilan saon ad mamaticha ko kay!” ");
INSERT INTO ksc_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ad-adchuwan na uchumi kaskaschaaw wi iningwan Jesus ta sangwananni wi disipulusna, wi foon à inyug-is-u ta annayay nibru. ");
INSERT INTO ksc_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ngim inyug-is-un anchanayà mamatiyanyu wi à Jesus siyan tuttuway Anà Apudyus wi impustanay umali. Ad nu mamatiayu, makafiyag-ayun siyà ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Iningkaw akon osay nampail-an Jesus an chiani wi disipulusna ta sachi Fayfay wi Tiberias. Amasnan nàwaana: ");
INSERT INTO ksc_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Na sachi timpu, niyaspur wi iningkaw-ani wi Simon Pedro, ya Tomas wi Apil, ya Natanael wi iCana wi nisakup ad Galilea, ya chiani wi chuway anà Zebedeo, ya chuwa koy furunni. ");
INSERT INTO ksc_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ad anan Simon Pedro, “Inyà manakufur.” Ad ananni ko, “Furnanni kò sia.” Siyan ummoy-ani losan namfangka, ad linabrafini wi nanakufur, ngim maid pun innarani. ");
INSERT INTO ksc_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ad wiswisnit pun, iningkaw na osay ummaagsad ta tarantag, wi Jesus, ngim foon pù immatunanni. ");
INSERT INTO ksc_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ad ananan chiani, “Awad pinuntaanyu, susunud?” “Maid pun,” ananni. ");
INSERT INTO ksc_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ad anan Jesus, “Itop-aryun takufuryu ta apot ta machiwawan na fangka, ta awad puntaanyu.” Siyan intop-arni, ad achiani pu nakakuykuy tan ad-adchuwan na napuntaan. ");
INSERT INTO ksc_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","À saon, immatunà wi siyà Jesus, ad anà an Pedro, “Sachin Aputau!” Ad na nangngoran Pedro ta sachi, nansilup ad pummaytù ta chanum ad nan-iyat wi umoy an Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ad chiani wi uchum, namfangkaani wi ummunud tan kinuykuynin takufur wi napnù ukachiw. Foon pù achayu ta tarantag, tan umoy nin à singkasuti metro. ");
INSERT INTO ksc_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Lummogsad-ani pun ta tarantag, innilanin apuy wi fummafara ya ukachiw wi nachachawis, ya iningkaw akon tinapoy. ");
INSERT INTO ksc_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ad anan Jesus an chiani, “Umiyaliayù uchum à ukachiw ta pinuntaanyu.” ");
INSERT INTO ksc_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Siyan linumnò à Pedro ta fangka ad kinuykuynan tafukur wi napnù man-achakkor à ukachiw, wi singkasut ya limampuru ya turu. Ngim uray ad-adchuwan, foon pù nakissay na tafukur. ");
INSERT INTO ksc_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Sachi ad inayakan Jesus à chiani wi anana, “Wayyu ta mangantau.” À chiani, maid osà nangimus an siya wi “Sinua?” tan inakammuni losan wi siyà Jesus. ");
INSERT INTO ksc_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ad innaran Jesus na tinapoy, ad finillaynan chiani, ad isuna kon ukachiw. ");
INSERT INTO ksc_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Sachin pitlun na nampail-an Jesus an chiani wi disipulusna nanipud ta ummuliyana natakuwan. ");
INSERT INTO ksc_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Narpas-ani pun nangan, anan Jesus an Simon Pedro, “Siay Simon wi anà Juan, ad-achun ayatnun saon nu ayat na anchanayay uchum?” Ad anan Pedro, “Oo, Apu. Akammum met wi ay-ayatò sia.” Ad anan Jesus, “Siyan tudtuchuwam chachi pannilù wi namatin saon.” ");
INSERT INTO ksc_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Sachi ad impigwan Jesus na anana, “Simon wi anà Juan, tuttuway ay-ayatonà?” “Oo, Apu,” anan Pedro, “akammum wi ay-ayatò sia.” Ad anan ako Jesus, “Siyan ayyuwanam ngarud chachi pannilù wi mamatin saon.” ");
INSERT INTO ksc_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Sachi ad impitlun Jesus na anana, “Simon wi anà Juan, tuttuway awad ayatnun saon?” Ad summauy na somsomò Pedro, tan pinitlun Jesus imfakan sachi. Ad anana, “Apu, akammum losan, siyan akammum akoy tuttuway ay-ayatò sia!” Ad anan Jesus, “Siyan tudtuchuwam chachi pannilù. ");
INSERT INTO ksc_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tuttuwan ifakà an sia: na afabfarum, oyyoom yakan piom, ad ummoy-a ko ta farangnay piom. Ngim nu marakay-a, uyachonchan imam ad finarudchà sia, ad iyoychà sia ta achim pu pion wi umayan.” ");
INSERT INTO ksc_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Sachin inyisun Jesus wi iyalignà matayan Pedro à kachayawan Apudyus. Imfakan pu Jesus losan na sachi, ananan Pedro, “Saon yakan surutom!” ");
INSERT INTO ksc_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Sachi ad nantuwilì Pedro ad innilanà saon wi ummun-unud. Saon na nichar-ag an Jesus ta sachi anungus na nakaananan chiani, wi sachin nangimusà nu sinun mangififik an siya. ");
INSERT INTO ksc_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ad innilan pu Pedrò saon, inimusnan Jesus, “Apu, sinu kon màwan siya nù?” ");
INSERT INTO ksc_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ad anan Jesus, “Nu piò wi manatakun siya ingkanà asin-u mangulinan, foon pù fiyangnuchi. Ngim sia, surutom à saon!” ");
INSERT INTO ksc_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Nanipud ta nangifag-an Jesus ta sachi, niwarawag ta chachi namati wi achiyà anu matoy. Ngim foon pu sachin anan Jesus, tan na imfakana, “Nu piò wi manatakun siya ingkanà asin-u mangulinan, foon pù fiyangnuchi.” ");
INSERT INTO ksc_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Saoni Juan wi disipulus Jesus, tàchorà wi katuttuwaan losan na annay inyug-is-u. Ya akammuni losan wi tuttuwa. ");
INSERT INTO ksc_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ad-adchuwan akon uchumi iningwan Jesus wi foon à miyug-is, tan nu miyug-is losan à nibru, na somsomòu foon pù umanay losan na annay lutà ingkawancha.");
INSERT INTO ksc_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Na chamuy surat-un siay Teofilo, inyug-is-un losani ining-ingwan Jesus ya insursuruna nanipud ta lukina ");
INSERT INTO ksc_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ingkana ta nipangatuwanad langit. Na chaampunan Jesus ad langit nipangatuwan, iningkaw na imfilinna ta chachi chinutukana wi apostolesna, wi narpu ta somsomò na Ispiritun Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Na narpasan na natayan Jesus ya ummuliyana natakuwan, nampaipailan chicha ta unog na opatpuruy padcha, ya achu kon iningwana ta awad manuttuwaancha wi tuttuway ummuli nataku, ya intudtuchunan chicha na mipangkop ta Manturayan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Na namingsan wi niyamung à Jesus an chicha, finilinna chicha, “Achiyu taynan ad asnay Jerusalem ingkanà adchon Ama na Ispiritunan chiayu, wi siyan imfakafakà wi impustana an chiayu. ");
INSERT INTO ksc_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Finunyakan chiayu an Juan à chanum, ngim foon à mafayag ad ifunyag Apudyus na Ispiritunan chiayu wi sachin umaliyana makarong-akan an chiayu.” ");
INSERT INTO ksc_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Na asincha naamungan, inimus na apostoles Jesus an siya, “Apu, mafalini sanan timpun na miparyawan chachi iRoma wi turay ta ikadni wi Judio wi mangituray ta lutani?” ");
INSERT INTO ksc_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ad summongfat à Jesus, “À Ama wi Apudyus, siya kan mangakammu ta màwaan na sinuy oyyoona. Achi pu mipaakammuchin chiayu. ");
INSERT INTO ksc_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ngim akammuyu losan na iningwà ya intudtuchù, siyan nu umali makarong-ag na Ispiritun Apudyus an chiayu, sachin mangadchana ta karobfonganyu wi mangistiku an saon. Ad sachi kon itudtuchuyu ta takud asnay Jerusalem ya losani sakupon Judea ya Samaria ya uray ta losani luta.” ");
INSERT INTO ksc_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Narpas ad wi imfakan Jesus na sachi, nipangatù siya ad langit ta nangiil-ancha ingkanà nasar-iwan ta lifuu. ");
INSERT INTO ksc_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nantatangadcha pun wi mangiila ta ummayan Jesus, naanagsad ta iningkawancha na chuway anghel wi nakasilup à mamputilà. ");
INSERT INTO ksc_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ad anan chi chuway anghel, “Chiayuy iGalilea, taayuko mantatangad ad langit? À Jesus wi nipangatud langit, mangulin à tapin na padchà isun na lummayawana.” ");
INSERT INTO ksc_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Sachi ad, lummayaw na apostoles ta sachi filig wi Olivo ad nangulinchad Jerusalem wi osay kilometron aachayuna. ");
INSERT INTO ksc_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Chummatongcha pun, ummoycha ta foroy wi iniingkawancha. Chana ngachan na naamung: Pedro, Juan, Jaime, Andres, Felipe, Tomas, Bartolome, Mateo, Jaime wi anà Alfeo, Simon wi mangipapakat, ya Judas wi anà na safali wi Jaime. ");
INSERT INTO ksc_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ad na nakaamuamung akon chicha, chachi susunud Jesus ya Maria wi Inana ya uchumi fubfufai. Siya maamuamunganchan malluwarucha. ");
INSERT INTO ksc_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Naarkawanan ad, nammimiting na losani mamati, wi umoy à singkasut ya chuwampurun filangcha, ad nan-ukud à Pedro. ");
INSERT INTO ksc_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Anana, “Susunud, iningkaw na impaspasmò na Ispiritun Apudyus an David ta awi, siyan inyug-isnan màwan Judas, wi siyan nangipuyut ta chachi naniliw an Jesus. Ad tummuttuwan losani niyug-is, ");
INSERT INTO ksc_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","tan à Judas, siyan osay furuntau wi nachutukan à makaiwaar an chitau wi apostoles.” ");
INSERT INTO ksc_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Na sachi Judas, natangchanan ta sachi lawingi iningwana, ad inusarnay nangnginà luta, ad sachin nan-otoyana, ad finumtak na fukatna ad lummoswan fakisna. ");
INSERT INTO ksc_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ad nanchinamag na losani takud Jerusalem, siyan nginachananchan sachi lutà Aceldama wi na anan na sachi ta ukudcha, “Nacharaan wi Luta.” ");
INSERT INTO ksc_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Anan ako Pedro, “Awad akon inyug-is David ta awi ta nibrunay kankanta, wi anana, ‘Ta fumaaw na foroyna wi maid asin ingkaw.’ Ad na osa koy niyug-is, anana, ‘Ta awad na misukat an siya à mamiyang ta fiyangna.’” ");
INSERT INTO ksc_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Inturuy Pedro wi man-ukud, “Siyan kapu ta amaschin niyug-is, masapur manchutuktaù sukat Judas à mitapin chitau. Na machutukan, masapur na osay nangilan Apu Jesus ta ummuliyana natakuwan, ta mafalini istikuwanan innilana. Ya masapur ako wi nifurufurun an chitau ta ingkawan Jesus, nanipud ta namunyakan Juan ta taku ingkana ta nipangatuwan Jesus ad langit.” ");
INSERT INTO ksc_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Siyan imfakachan ngachan na chuway larai: Matias na osa, ya Jose Justo wi na osay ngachanna, Barsabas. ");
INSERT INTO ksc_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Sachi ad nalluwaruchan Apudyus, “Siay Apu wi mangakammu ta somsomò na losani taku, ipailam an chiani nu sinun chinutukam ta annayay chuwa ");
INSERT INTO ksc_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","à misukat an Judas à man-apostoles, tan à Judas, inwarangna ad ummoy ta makuisana.” ");
INSERT INTO ksc_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Narpascha pun nalluwaru, namfinnunutcha ta akammuwoncha nu sinun machutukan, ad Matias na nafunut, siyan nitapi ta chachi simpuru ya osay apostoles. ");
INSERT INTO ksc_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Chummatong pun na fiyasta wi anancha Pentecostes, naarus na losani mamatin Jesus ta osay foroy. ");
INSERT INTO ksc_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ad na sachi, nammaag nagngor na isù chakor wi akungiyong wi narpud langit, ad chingngor losan na iningkaw ta foroy. ");
INSERT INTO ksc_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ya iningkaw akon innilacha wi isù kilab na apuy wi niwaras ta uulluwancha, wi chinchintong na kilab an chicha losan. ");
INSERT INTO ksc_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ad waschi osay mamati, naadchan à Ispiritun Apudyus wi makarong-ag an chicha, ad illukicha losan wi mangiyukud ta nangkarakarasi wi ukud, wi siya mampaukud na Ispiritun Apudyus an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Iningkaw ako finumroy ad Jerusalem na achuy Judio wi nangapudyus, wi narpu ta ailiili, siyan nangkarakarasin ukudcha. ");
INSERT INTO ksc_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Chingngorcha pun na sachi isù akungiyong, ummoycha nakaarus ta foroy wi iningkawan chachi mamatin Jesus. Ad nataagcha losan, tan waschi osa chongronan ukudna wi ifosway chachi mamati. ");
INSERT INTO ksc_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ad asitataagcha anani, “Tamakon anchanay losani iGalilea? ");
INSERT INTO ksc_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Waschi osan chitau chochongronan sikuchi ukudna wi iyukudcha! In-inoncha aya? ");
INSERT INTO ksc_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tan na uchum an chitau, iPartia, ya anchana kon iMedia, iyElam, iMesapotamia, iJudea, iCapadocia, iPonto, ya iyAsia. ");
INSERT INTO ksc_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ya anchana kon iFrigia, iPamfilia, iyEgipto, ya sakupon Libia wi achanid Cirene. Na uchum an chitau, iRoma, ");
INSERT INTO ksc_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","wi sikuchi Judio na uchum ya uchumi foon pù Judio wi namfarfalin à Judio. Ya anchana kon chitaun iCreta ya iyArabia. Siyan uray nangkarakarasin narpuwantau, siya chochongrontaun sikuchi ukudtau wi iyukudcha ta kaskaschaaw wi iningwan Apudyus!” ");
INSERT INTO ksc_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Siyan naschaawcha losan wi achicha pu makasomsomò. Siyan nan-asiimuscha, “Sinu kon anan na annaya?” ");
INSERT INTO ksc_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ngim am-amangon na uchum à chicha, wi anancha, “Nasalimong na anchanay taku!” ");
INSERT INTO ksc_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ngim summiad à Pedro ya nakasiad akon chachi simpuru ya osay fufurunnay apostoles, ad chinakornan kingana wi man-ukud, “Kailiyan wi Judio ya chiayu losan wi ingkaw ad asnay Jerusalem, chongronyuna. ");
INSERT INTO ksc_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Na ananyu, nasalimong-ani, ngim naillachuayu, tan maid pu masalimong ta mangmangan! ");
INSERT INTO ksc_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ngim nàwan annayà tumuttuwaan na sachi imfakan Joel wi profeta ta awi ta nangifag-ana ta ukud Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Anan Apudyus, Amasnan oyyoò nu chumtong na timpun na anungus na padcha: Adchò na Ispiritù ta losani takud asnay luta. Siyan na aannàyu, ipagngorchan ipaspasmòun chicha. Na fabfafaru, ilanchan ipailà an chicha wi isun à in-inop. Ad na man-amarong-ag, in-inponcha kon ipain-inop-un chicha. ");
INSERT INTO ksc_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Na losani larai ya fufai wi mamtog an saon, adchò na Ispiritù an chicha losan ta sachi timpu à mangipagngorancha ta ipaspasmòun chicha. ");
INSERT INTO ksc_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ipailà akon kaskaschaaw wi singyar ta langit ya uray ad asnay luta. Na usarò wi mampailà kaskaschaaw, chara ya apuy ya amochi asuk. ");
INSERT INTO ksc_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ad fumulingot na init, ya chumilaag na sorag à isù chara, ad chumtong na mampataag ya mampaogyat wi padchay manguisà ta losani taku ta annay luta. ");
INSERT INTO ksc_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ngim na sachi timpu, sinuy takuy mampangpangngaasin saon, saraknifà à siya ta achi pu mifallu.’” ");
INSERT INTO ksc_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Inturuy Pedro wi man-ukud, “Kailiyan wi kanà Israel, inanaagyun annay ifakà mipangkop an Jesus wi iNazaret. Tan inistikuwan Apudyus à siya wi langit na ustuy narpuwana, wi na manuttuwaanyu, innadchon Apudyus na karobfongana wi mangwa ta chachi kaskaschaaw wi mampataag. Ad akammuyu wi tattuway iningwana, tan iningwana ta sangwananyu. ");
INSERT INTO ksc_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ngim à tumuruyan na simsimmò Apudyus wi màwa, imparufusnan natiliwan Jesus, siyan chiayun nangtoy an siya, tan innadchonyù siya ta chachi lawingi taku ta ilansacha ta kros. ");
INSERT INTO ksc_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ngim uray natoy à Jesus, impaulin Apudyus à siya tinaku, siyan inafaknan matayan tan achi pu makaipukod na otoy an siya. ");
INSERT INTO ksc_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Sachin inyug-is David ta awi ta nangifag-ana, ‘Sikurachuwò wi iingkaw à Apudyus an saon wi achiyà pu fayfay-anan. Siyan uray sinuy mapasamak, achiyà pu umogyat. ");
INSERT INTO ksc_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Siyan naragsakà, ya chaychayawò à siya, tan uray matoyà, sikurachuwò wi umuliyà mataku. ");
INSERT INTO ksc_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ama wi Apudyus, akammù wi achim pu taynan à saon ad Hades wi awachan na natoy, ya achim pu ko parufusan na marposan na long-ag-u. ");
INSERT INTO ksc_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nar-us wi impaakammum an saon wi matatakuwà à ing-ingkana. Ad amod na lagsak-u tan iingkaw-an saon.’” ");
INSERT INTO ksc_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Inturuy Pedro wi mangisuplikar, anana, “Susunud, tuttuwan ifakà mipangkop an David wi achakchakrantau. Sachin inyug-isna, ngim foon pù long-agnan inukudna, tan natoy met à David ta awi ad nilofon, ad awad na lofonna ta sana. ");
INSERT INTO ksc_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ngim profeta kò David, siyan inakammunan impustan Apudyus an siya, tan insapatan Apudyus an siya wi manturay na osay kanà David à tapin na padchà isun akon kinaturayna. ");
INSERT INTO ksc_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ad naawatan David wi asin Apudyus takuwon na sachi kanàna wi ipaalin Apudyus à manturay, ad sachin nangukuchana wi achi pu mataynan à Cristu ad Hades wi awachan na natoy, ya achi pu ko marpos na long-agna. ");
INSERT INTO ksc_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Siyan na inukud David, Jesus wi impaulin Apudyus tinaku. Ad istikuwanni losan wi tuttuway asin nataku, tan innilanì siya. ");
INSERT INTO ksc_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ad impangatun Apudyus à Jesus wi tummùchu ta apot ta chiwawanna, ad impurang Apudyus an siyan karobfonganay mangatod an chiani ta sachi impustana, wi Ispirituna, siyan na ilanyu ya chongronyu ta sana, sachin mangadchan Jesus ta Ispiritun Apudyus an chiani. ");
INSERT INTO ksc_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ad foon pù David na ummod langit tummùchu ta apot ta chiwawan Apudyus, uray siyan nan-ukud, tan inukudnan mipangkop an Jesus. Tan anana, ‘Imfakan Apudyus ta Apù wi ipangatunà siya wi tumùchu ta apot ta chiwawanna ");
INSERT INTO ksc_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ingkanà afakon Apudyus na losani afusur na Apù.’” ");
INSERT INTO ksc_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Sachi ad anan Pedro, “Siyan losan-ayuy kanà Israel, masapur maawatanyu wi à Jesus wi illansayu ta kros, siyan Cristu wi impustan Apudyus ta awi à umali, ya siyan piniyarna wi man-apun na losan.” ");
INSERT INTO ksc_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Na nangngoran chachi naaamung ta imfakan Pedro, nakulikur na somsomòcha, ad inimuschan Pedro ya chachi uchumi apostoles, “Ad sinu kon in-inonni nù?” ");
INSERT INTO ksc_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ad anan Pedro, “Waschi osan chiayu masapur ifafawinan fasurna ya mampafunyag à mangamfuruyana wi à Jesu Cristun umapuwana, ad pakawanon Apudyus na fasuryu ya adchona kon Ispiritunan chiayu, ");
INSERT INTO ksc_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","tan sachin impustan Amatau wi Apudyus wi adchonan chitauy Judio ya kanàtau ya uray taku ta ailiili, tan adchonan Ispirituna ta losani takuy piniliyanay mamati.” ");
INSERT INTO ksc_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ad-adchuwan na inukud Pedro ta nanlaramana mansuplikaran ta chachi naamung ya tinudtuchuwana kò chicha anani, “Patiyonyun intudtuchù ta ilisiyanyun kachusaan na lawingi taku!” ");
INSERT INTO ksc_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ad-adchuwanchay namati ta imfakan Pedro, ad nampafunyagcha. Na sachi padcha, ummoy à turun lifuy takun nitapi ta chachi mamatin Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ad impapaticha wi mangachar ta intudtuchun na apostoles, ad nitimpuyugcha ta chachi mamati wi makaruwaruwaru ya man-asipàoan à manomsom-ancha ta natayan Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Achun iningwan na apostoles wi kaskaschaaw, siyan naschaaw na losani nangila. ");
INSERT INTO ksc_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Na losani mamati, man-iisun somsomòcha, ya isuchà simfaryan wi mamfifinnachangcha mampàatod. ");
INSERT INTO ksc_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Tan ingnginachan uchumi taruncha ya ochoncha ya inwaraschan nginana ta losani furunchay mamati wi makasapur. ");
INSERT INTO ksc_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ad finikati naaruaruscha ta Templo, ad man-asipàoancha ta foforoycha wi mamfarun somsomòcha ya amod akon lagsakcha. ");
INSERT INTO ksc_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ad chinaychayawchà Apudyus, ya malispitucha ta losani taku. Ya finikati ichokachokan Apudyus an chicha na chachi masaraknifan. ");
INSERT INTO ksc_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ar-arkaw pun ta osay padcha, ummoycha Pedro an Juan ta Templo makaruwaru tan sachin panagruruwaru. ");
INSERT INTO ksc_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ad na sachi, iningkaw akon osay larai wi niyabfan-og napilay wi achi pu makachadcharan. Ad finikati changoyonchà siya iyoy ta ikaw na osay chakor wi liwangan ta Templo wi anancha “Afaruwani Liwangan,” ad sachin tummutùchuwana wi mampalimos ta takuy lumnò. ");
INSERT INTO ksc_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Innilana pun cha Pedro an Juan wi lumnò ta Templo, nangkakkaasin chicha. ");
INSERT INTO ksc_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ngim intotollongchà siya, ad anan Pedro, “Ilam à chiani!” ");
INSERT INTO ksc_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ad intotollongnà chicha, tan anana pun nu awad adchonchan siya. ");
INSERT INTO ksc_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ngim anan Pedro, “Maid pilakni, ngim na awad an chiani, sachin ifachangnin sia. Siyan kapu ta karobfongan Jesu Cristu wi iNazaret, ifakà an sia, sumiad-a ad manadcharan-a!” ");
INSERT INTO ksc_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Sachi ad inognan Pedro na chiwawan wi imana ad impasiadna. Ad nammaag ummoschor na ikina. ");
INSERT INTO ksc_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ad nantattattaud wi nakarnò ancha Pedro ta Templo wi manaychayaw an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Innilan na losani takù siyay nanadcharan ya manaychayaw an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ad immatunancha pun wi siyan sachi napilay wi tummutùchu wi mamparpalimos ta sachi “Afaruwani Liwangan” na Templo, naschaawcha losan ta sachi nàwan siya. ");
INSERT INTO ksc_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Niyiiwid na sachi napilay ancha Pedro an Juan ta lagsakna, ad na losani taku ta sachi, nataagcha ad nanodchàcha niyamung ancha Pedro ta chakor wi sawang ta Templo wi anancha “Sawang Solomon.” ");
INSERT INTO ksc_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Innilan pun Pedro na chachi naaamung, anana, “Kailiyan wi kanà Israel, apay mataag-ayu mipangkop ta annay nàwa? Tayukò chiani itotollong? Ananyu pun nin nu karobfonganni winnu kinafarunin nangaananni ta pilay na annayay taku? ");
INSERT INTO ksc_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Foon, tan Apudyus na nangaan, wi siyan chinaychayaw na achakchakrantau wi Abraham ancha Isaac ya Jacob ya losan chachi uchumi achakchakrantau ta awi. Ad na sana, inaannan pilay na annayay taku à mangil-anyu ta kina-Apudyus na anànay Jesus. Ngim à chiayu, impatiliwyù Jesus, ad incharumyù siya an Pilato, ngim uray pion Pilato wi mangiparufus an siya, inisìyu. ");
INSERT INTO ksc_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Siyan uray mamfarù Jesus wi maid pu fasurna, linawingyu, tan osay pumappatoy na piniliyanyù iparufus Pilato. ");
INSERT INTO ksc_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Siyan pinatoyyun sachi puun na mannaynayuni fiyag, ngim impaulin Apudyus à siya tinaku. Istikuwanni wi tuttuwa, tan inniilanì siya ta ummuliyana natakuwan. ");
INSERT INTO ksc_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Siyan na annayay larai wi iniilayuy napipilay, karobfongan Jesus na nampaimfag ya nampaoschor an siya, ad nàwa kapu ta pammatinin Jesus ya mamiyaranni ta karobfongana.” ");
INSERT INTO ksc_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Inturuy Pedro, “Susunud, akammù wi na nangtoyanyun Jesus, iningwayu kay tan foon pù illasinyu wi siyan impaalin Apudyus. Uray ako chachi pangpanguyu, foon pu kò ilasincha. ");
INSERT INTO ksc_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ya impaakammun chachi profetas ta awi na imfakan Apudyus an chicha wi masapur mapalikatan ya mapatoy na sachi ipaalina wi Cristu. Siyan na iningwayu, sachin tummuttuwaan na imfakan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Siyan masapur mamfafawiayu ya mansakung-ayun Apudyus ta pakawanonan fasuryu ");
INSERT INTO ksc_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ya papigsaonan somsomòyu, ya asinna ko ipaalì Jesus wi siyan chinuchuttukana wi mangituray an chitau. ");
INSERT INTO ksc_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ngim masapur iingkaw à Jesus ad langit ingkanà chumatong na timpu wi mampafaruwan Apudyus ta sinuman, wi sachi kon impaiyug-isna ta chachi profetana ta awi. ");
INSERT INTO ksc_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Tan na inyug-is Moses ta awi, anana, ‘À tapin na padcha, ipaalin Aputau wi Apudyus na osay profeta wi isun saon, wi kanàtau. Masapur patkonyun losani ifakana. ");
INSERT INTO ksc_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ngim sinumani takuy achi pu mamtog ta sachi profeta wi ipaalin Apudyus, kattoi masìsìcha ta takun Apudyus, ad mifallu.’” ");
INSERT INTO ksc_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ad inturuy Pedro wi man-ukud, “Losan chachi profetas ta awi, nanipud an Samuel ya ingkana ta chachi nansùnusùnub wi profetas, imfakacha kon anchanay màmàwa ta sana. ");
INSERT INTO ksc_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ad na losani impustan Apudyus, wi impaiyug-isna ta chachi profetasna, nitapitau losan wi kanàcha. Siyan makafingaytau ta inturag Apudyus ta chachi achakchakrantau. Tan na imfakanan Abraham, ‘Fadngà losan na taku ta annayay luta mipakapu ta kanànu.’ ");
INSERT INTO ksc_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Siyan chitauy Judio na ummunay nangifaunan Apudyus ta anànay Jesus à mafadngantau ya mafinchisyunantau ta man-awichantaun lawingi oyyoontau.” ");
INSERT INTO ksc_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Na sachi nakaug-ugkuchan cha Pedro ya Juan ta takuy naaamung, chummatong na uchumi papachi ya Saduceo ya kapitan chachi kuwarcha ta Templo. ");
INSERT INTO ksc_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Naaliling-otcha ancha Pedro an Juan tan itudtuchucha wi ummuli natakù Jesus wi sachi nun mamfasaran ta umuliyan na losani natoy matakuwan à tapin na padcha. ");
INSERT INTO ksc_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ad tiniliwchà chicha, ngim kapu ta mummaschom, imfarudchà chicha ingkanà mafikat. ");
INSERT INTO ksc_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ngim uray amaschi, namatin ad-adchuwan wi nanangngor ta intudtuchucha Pedro mipangkop an Jesus. Siyan ummoy à limay lifun lallarai wi mamati wi foon à nifilang na fubfufai ya an-ananà. ");
INSERT INTO ksc_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nafikat pun, naarus na pangpangun na Judio ad Jerusalem, wi nitapi kon pangrakayoncha ya mangitudtuchu ta Lintog Moses. ");
INSERT INTO ksc_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Niyamung akon Angatuwani Pachi wi Anas ya nitipun ako cha Caifas an Juan ya Alejandro ya uchumi familyan Anas. ");
INSERT INTO ksc_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ad impasangucha cha Pedro an Juan ad inimfistikarcha chicha, “Sinun nangatod ta karobfonganyu wi mangwa ta sachi iningwayu? Ad sinu kon mamachang an chiayu?” ");
INSERT INTO ksc_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Sachi ad, impaturod na Ispiritun Apudyus na somsomò Pedro, ad anana, “Chiayuy pangpangu ya pangrakayon, ");
INSERT INTO ksc_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","tayuko imfistikaron à chiani mipangkop ta namadnganni ta sachi napilay ya naaanan na pilayna? ");
INSERT INTO ksc_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Tan maawatanyu kuma, ya maawatan kuma losan akoy susunudtauy kanà Israel wi na karobfongan Jesu Cristu wi iNazaret, sachin naaanan na pilay na annayay taku wi mailayuy sumisiad ta sangwananyu. Na sachi Jesus, siyan impailansayu ta kros ta nampapatoyanyu, ngim impaulin Apudyus tinakù siya. ");
INSERT INTO ksc_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","À Jesus siyan niyalikan na sachi niyug-is wi inukud Apudyus, wi anana, ‘Na fatu wi anan na mangkakaob wi ifallucha, siyan apatkan wi fatu.’ ");
INSERT INTO ksc_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Siyan maid pu osà makasaraknib an chitau nu achi afus à siya, tan maid uchum à impaalin Apudyus ta losani lutà mannakafalin à manaraknib ta taku ta achicha pu mifallu nu achi afus à Jesus.” ");
INSERT INTO ksc_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Losan chachi pangpangu wi kunsisar, naschaawcha wi nangila ta turodcha Pedro an Juan, sinchumallu ta nangakammuwancha wi maid saadcha ya foon à inuswilacha. Ad sachin nangilasinancha wi chichan fufurun Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ngim maid pun ifakacha, tan iningkaw akon sachi napilay wi nakaagsad wi naaan na pilayna. ");
INSERT INTO ksc_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Siyan imparawacha cha Pedro an Juan ya sachi naaan na pilayna, ad nan-ang-angongotcha, ");
INSERT INTO ksc_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Sinu kon oyyoontaun chicha nù? Tan akammun na losani takud asnay Jerusalem na iningwacha wi kaskaschaaw, siyan amod à mailifaktau. ");
INSERT INTO ksc_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Siyan igtutontau chicha ta achicha asin ug-ugkuchon na mipangkop ta sachi Jesus ta uray sinumani taku ta achi man-in-inumamag.” ");
INSERT INTO ksc_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Sachi ad asincha impaayag à chicha ad imfakacha wi masapur iyakaycha wi mantudtuchu ta mipangkop an Jesus, ya uray na mangifag-ancha ta ngachanna. ");
INSERT INTO ksc_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ngim sinongfatancha Pedro an Juan à chicha, “Somsom-onyu nu sinun mamfaruwon Apudyus, chiayun patkonni winnu Apudyus? ");
INSERT INTO ksc_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Achi pu mafalin wi iyakayni wi mangifaka ta innilani ya chingngorni mipangkop an Jesus.” ");
INSERT INTO ksc_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Sachi ad, asin chachi pangpangu inigtut chicha ta iyakaycha, achichaot iparyaw chicha, tan achicha pu makaanap à ustù lasun à manusaancha chicha, tan na losani naarus wi taku, chaychayawonchà Apudyus kapu ta sachi nàway kaskaschaaw. ");
INSERT INTO ksc_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Tan na sachi larai wi naaan na pilayna, nasuruk à opatpurun tawonna. ");
INSERT INTO ksc_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Niparufus ad cha Pedro an Juan, nangulincha ta fufuruncha, ad inisturyacha losan na imfakan chachi pangrakayon ya pangpangun na papachi. ");
INSERT INTO ksc_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Chingngor pun na fufurunchan inisturyan Pedro, nakaruwarucha wi anancha, “Amani wi Apudyus, sian nangwa ta sinumani awad ad langit ya annayay luta ya fayfay ya losani ingkaw. ");
INSERT INTO ksc_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Na Ispiritum siyan nangipaspasmò an apuni wi David wi namatin sia, ta nangifag-ana wi, ‘Tamako chachi foon à Judio, ummog-otcha? Ya chachi Judio, tachako som-osom-on wi mangwà lawing? ");
INSERT INTO ksc_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nasasagkanan aalialin na annayay luta, ya nitimpuyug na losani turay tan na pioncha, kufatonchà Apudyus ya sachi chinutukana wi manturay wi Cristu.’ ");
INSERT INTO ksc_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Amani wi Apudyus, tummuttuwan sachi inyug-is David ta awi tan niyamung ad asnay Jerusalem na sachi Ali Herod ya Poncio Pilato, ya nitipun akon chachi foon à Judio ya chachi chokani wi Judio. Naaruscha nantuturag ta patoyonchan anànuy Jesus wi maid fasurna, wi siyan chinutukam à manturay. ");
INSERT INTO ksc_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ad na losani anancha wi oyyooncha, siyan imfafagkam wi màwa, tan siyan simsimmònu. ");
INSERT INTO ksc_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Siyan na sana, Apudyus wi Amani, chongrom na annay iyog-ogyatchan chiani, ya adchom an chiani wi mansilfin sia na turodni wi mangitudtuchu ta ukudnu. ");
INSERT INTO ksc_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ya ipailam na karobfongam wi mangaan ta sakit, ya oyyoom akon kaskaschaaw ta mangifag-anni ta fachang na sachi mannakafalini anànuy Jesu Cristu wi maid fasurna.” ");
INSERT INTO ksc_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Narpascha pun nalluwaru, niyukayug na foroy wi naamungancha, siyan naadchan na Ispiritun Apudyus an chicha. Siyan tummurodcha wi mangukud ta ukud Apudyus, wi maid ogyatcha. ");
INSERT INTO ksc_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ad man-iisun somsomò na losani mamatin Jesus, wi maid pu osà mangifaka wi uwana kan ochonna, tan uwacha losan. ");
INSERT INTO ksc_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Chakor na karobfongan na apostoles wi mangistiku ta ummuliyan Apu Jesus natakuwan, ya chakor akon fachang Apudyus ta losani mamati. ");
INSERT INTO ksc_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Maid makurangancha ta masapurcha tan chachi awad na mafalincha, ingnginachan uchumi lutacha winnu agwan na foroycha nu awad, ");
INSERT INTO ksc_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ad inadchonchan nginana ta apostoles. Siyan chachi apostoles, fingfingayonchan sachi fachang ta sinuy makasapur. ");
INSERT INTO ksc_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Iningkaw na osay larai wi Jose wi iChipre, wi osay kanà Levi. Nginachanan na apostoles à siyà Bernabe wi na pionay anan, “Sumorkag.” ");
INSERT INTO ksc_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ingnginan Jose na osay lutana ad innadchonan nginana ta chachi apostoles. ");
INSERT INTO ksc_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ad iningkaw akon osay larai wi Ananias na ngachanna. Safiran asawana. Ingnginacha kon uchumi lutacha, ");
INSERT INTO ksc_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ngim nanturagchay man-asawa wi kogwaonchan nginana. Sachi ad inadchon Ananias na kogwan na nginan na luta ta chachi apostoles, ad anana, “Annayan nginana.” ");
INSERT INTO ksc_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ngim anan Pedro an siya, “Tammako parufusan na mangawisan Satan ta somsomònu à manurtulliyam ta Ispiritun Apudyus wi kinappotnun kogwan na nginan na lutayu? ");
INSERT INTO ksc_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Na chaanyu pun mangingin-an ta luta, uwayu. Ad ingnginayu pun, ikadnu koy mangusar ta nginana. Siyan tammako amaschiyon? Foon pu kà takun tinurtulliyam ngim à Apudyus!” ");
INSERT INTO ksc_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Na nangngoran Ananias ta imfakan Pedro, nalitwad wi natoy. Siyan isag ummogyat losan chachi nangngor ta nàwa. ");
INSERT INTO ksc_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ad innaran na fabfafarun lachag, ad finussungcha ad illofoncha. ");
INSERT INTO ksc_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Lummaus ad na turuy uras, linumnò à Safira wi asawan na natoy wi chaanna pu chongron na nàwa ta asawana. ");
INSERT INTO ksc_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ad anan Pedro an siya, “Ifakam nu inadchonyu losan na nginan na lutayu.” “Oo,” anana, “inadchonni losan na nginana.” ");
INSERT INTO ksc_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ad anan Pedro, “Tamako nanturakanyu wi man-asawa wi padpachason na Ispiritun Apudyus? Ilam, anchanayan fabfafaru wi nangilofon ta asawam, ad ilofoncha kò sia!” ");
INSERT INTO ksc_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ad nalitwad ako chi fufai wi natoy. Sachi ad linumnò na fabfafaru ad innilachà Safira wi natoy ako, siyan chinangoychà siya ummoy illofon ta char-ag na lofon asawana. ");
INSERT INTO ksc_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ad losan na mamati ya chachi uchumi nangngor, isagcha ummogyat ta sachi nàwa. ");
INSERT INTO ksc_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Na sachi timpu, achun kaskaschaaw wi iningwan chachi apostoles ta sangwanan na taku. Ya losani mamati, naaruaruscha ta sachi arway sawang na Templo wi anancha “Sawang Solomon.” ");
INSERT INTO ksc_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ngim chachi takuy chaan pù mamati, uray lispituwonchan chachi mamati, ummogyatcha wi mitipun an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ngim ummachuachu ko kan mamati wi fubfufai ya lallarai. ");
INSERT INTO ksc_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ad kapu ta oyyoon na apostoles wi kaskaschaaw, inyoy na takun nasakit wi nifàsar ta ikid na arsa ta urayonchan lumausan Pedro, tan anancha pun nu uray mifatug yakan angingiwanna, maaan na sakitcha. ");
INSERT INTO ksc_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ya ad-adchuwan akon narpu ta chachi ili wi sakupon Jerusalem, wi inyalicha kon nasakit wi mampaaan ta sakit ya mampaparyaw ta aran ta chachi nakafarfaray, ad ummimfagcha losan. ");
INSERT INTO ksc_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kapu ta oy-oyyoon na apostoles, ummapos na Angatuwani Pachi ya fufurunnay Saduceo, ");
INSERT INTO ksc_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","siyan impatiliwchan apostoles ad imfarudcha. ");
INSERT INTO ksc_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ngim na sachi lafi, ummoy na osay anghel Apudyus ta fafalluchan ad inib-atnan liwangan, ad illawanan apostoles. Ad ananan chicha, ");
INSERT INTO ksc_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ing-ayu ta Templo ta itudtuchuyu ta takun mipangkop ta mannaynayuni fiyag wi marpun Jesu Cristu.” ");
INSERT INTO ksc_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ad pintog na apostoles na nifakan chicha. Sachi ad, wi sumingitan na init, ummoycha ta Templo ad illukichay mantudtuchu. Na sachi ko, na Angatuwani Pachi ya fufurunna, impaayagchan losani pangrakayon na Judio wi anancha kukunsisar, ad impaaracha chachi nafarud wi apostoles ta kuisoncha kuma. ");
INSERT INTO ksc_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ngim chummatong pun chachi mangaran chicha ta fafalluchan, maid pun inchasancha. Siyan nangulincha ta chachi kukunsisar, ad anancha, ");
INSERT INTO ksc_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Chummatong-ani pun ta fafalluchan, nichachaig na liwangan ya wachawad na kuwarcha. Ngim inib-atni pun, maid pu osà inchasanni ad charò!” ");
INSERT INTO ksc_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Na nangngoran chachi pangpangun na papachi ya pangpangun na kuwarcha ta Templo ta imfakacha, nakulikur na somsomòcha nu sinun in-inon na nàwa ta chachi farud. ");
INSERT INTO ksc_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Sachi ad, chummatong na osay larai wi nangifaka, “Chachi takuy imfarudyu, awadchay mantudtuchu ta takuy naarus ta Templo!” ");
INSERT INTO ksc_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ad ummoy na kapitan na kuwarcha ya fufurunna innara chachi apostoles. Ngim finarfaruchà chicha wi nangaran chicha tan umogyatchà fintukon na takù chicha. ");
INSERT INTO ksc_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Inyoychan apostoles impasangu ta chachi kukunsisar, ad illukin na Angatuwani Pachi wi mangimfistikar an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Anana, “Finilinni chiayu ta achiayu mantudtuchù mipangkop an Jesus, ad achiyu pu pintog! Siyan nagngor losan na takud asnay Jerusalem ta itudtuchuyu, ad pafasuronyù chiani mipangkop ta napatoyana.” ");
INSERT INTO ksc_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ad summongfatcha Pedro ya chachi uchumi apostoles, “Masapur wi Apudyus na patkonni, foon pù taku! ");
INSERT INTO ksc_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tan à Apudyus wi chinaychayaw na achakchakrantau ta awi, nangulinonà Jesus tinaku wi impapatoyyu ta nangipailansaanyun siya ta kros. ");
INSERT INTO ksc_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ad impangatun Apudyus à Jesus ta apot ta chiwawanna ad langit à Ap-apu ya Sumaraknib. Iningwan Apudyus losan na anchanaya ta mawayaantauy kanà Israel wi mamfafawi ta mapakawan na fasurtau. ");
INSERT INTO ksc_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ad à chiani wi apostoles, istikuwanni wi tuttuwa losan chachi, ya istikuwan akon Ispiritun Apudyus, wi na Ispirituna, siyan adchon Apudyus à makarong-ag ta sinuy mamatin siya.” ");
INSERT INTO ksc_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Na nangngoran chachi kukunsisar ta imfakacha Pedro, naam-amod na og-otcha, wi pionchay mamatoy an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ngim summiad na osa wi Gamaliel na ngachanna. Fariseo à Gamaliel, wi siyan osay mangitudtuchu ta Lintog Moses, ya lispituwon na losani takù siya. Impaiparawanan apostoles, tan awad na ifakana ta chachi fufurunnay nangangatu. ");
INSERT INTO ksc_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Niparawa pun na apostoles, nan-ukud à Gamaliel, “Susunud-uy kanà Israel, masapur an-annachanyun oyyoonyu ta anchanayay taku. ");
INSERT INTO ksc_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Chongronyu yan na iyalig-u. Na sin-arkawan, iningkaw na osay larai wi nangngachan à Teudas. Impangatunan long-agna wi opat kasut na takuy summurut an siya. Ngim napatoy à Teudas, ad nafuar losan na takuna, siyan maid tummuruyan na sachi. ");
INSERT INTO ksc_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","“Narpas ad na sachi, wi timpun na nampalistaan na taku, iningkaw akò Judas wi iGalilea. Ad à Judas, inawisna kon achuy taku à summurut an siya, ngim napatoy ako, siyan nafuar akon losani takuna. ");
INSERT INTO ksc_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Siyan na sana, na ifakà an chiayu, maid kuma oyyoontaun chicha. Tan nu somsomò yakan takun narpuwan na oy-oyyooncha ya itudtuchucha, kapilitan miyisu ta chachi uchum wi achi pu mituruy. ");
INSERT INTO ksc_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ngim nu Apudyus na narpuwan na oy-oyyooncha, kattoi achitau pu makaafak an chicha, tan amod à kontraon à Apudyus!” Sachi ad pintogchan imfakan Gamaliel, ");
INSERT INTO ksc_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ad impaayagchan apostoles. Ad impaabchoychà chicha, ad impalitchan asincha mangitudtuchuwan ta mipangkop an Jesus, ad imparufuscha. ");
INSERT INTO ksc_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ad na apostoles, amod na lagsakcha ta nanaynancha ta chachi kukunsisar tan imfilang Apudyus chichà awad karobfonganchay mapalikatan mipakapun Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ad finikati inturturuychay umoy ta Templo ya foforoy na taku wi mantudtuchu ta Mamfaruy Chamag mipangkop an Jesus wi siyan impustan Apudyus wi umali ad asnay luta wi manturay. ");
INSERT INTO ksc_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ad ummachuachun Judio wi mamatin Jesus. Ad iningkaw nallilliliyan na sikuchi Judio ta chachi chatuy Judio wi Griego na ukudcha. Ad na ililin na Judio wi Griego na ukudcha, mafayfay-anan anun chachi nafaru wi chokacha ta miwarasan na anoncha ta afigkafigkat. ");
INSERT INTO ksc_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Siyan na simpuru ya chuway apostoles, nampamitingcha wi inayakanchan losani fufurunchay mamati. Anancha, “Lawing nu iyakayni wi mantudtuchu ta ukud Apudyus, ta siya iwaaronnin man-iwaras. ");
INSERT INTO ksc_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Siyan na oyyoonyu, chumutuk-ayù pitù lallarai an chiayu à piyaronyu wi akammuyuy titingngilon na Ispiritun Apudyus na somsomòcha ya awad laingcha, ta paifiyangnin chicha na mipangkop ta annaya. ");
INSERT INTO ksc_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tan à chiani, siya ipapuutnin luwaru ya mantudtuchu ta mipangkop an Jesus.” ");
INSERT INTO ksc_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Intay-un chachi losani taku na imfakan na apostoles, siyan chinutukanchan pitu. Na osa, Esteban wi impapatinan pammatinan Apudyus, ya mangwa ta pàwan na Ispiritun Apudyus an siya. Na uchumi chinutukancha ko, Felipe, Procoro, Nicanor, Timon, Parmenas, ya Nicolas, wi losancha mamati an Jesus. À Nicolas, iyAntiokia wi foon pù osay kanà na Judio ngim nakatimpuyug an chicha, ad mamatin Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Niparang chachi pitu ta apostoles, siyan na apostoles, impataychan imacha ta chachi nachutukan ad illuwaruwanchà chicha. ");
INSERT INTO ksc_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ad nitudtudtuchun ukud Apudyus, siyan ummachuachun mamati ad Jerusalem. Uray na papachin na Judio, achucha koy namati an Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","À Esteban, chakor na fachang Apudyus an siya, ya inadchon ako Apudyus na karobfongana wi mangwà kaskaschaaw à mamadngana ta taku. ");
INSERT INTO ksc_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ngim iningkaw na uchumi Judio wi mallawing an Esteban. Chichan mantitimpuyug ta osay sinagogan na Judio wi ananchay Sinagogan na Niparufus wi Sasannilu. Narpucha ta uchumi ili wi Cirene, Alejandria, Cilicia, ya Asia. Nakasongsongfatchan Esteban, ");
INSERT INTO ksc_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ngim achicha pu makaafak an siya, tan innadchon na Ispiritun Apudyus na turodna ya laingna wi sumongfat. ");
INSERT INTO ksc_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Siyan apsanchà siya, ad pinasuksukanchan uchumi taku à mangisodsod an siya anani, “Chingngornin annayay taku wi man-ukuukud à lawing mipangkop an Apudyus ya Moses.” ");
INSERT INTO ksc_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Siyan nasugsukan na taku ta nangngorancha ta sachi. Ya ummog-ot akon pangrakayoncha ya chachi mangitudtuchu ta Lintog Moses. Siyan tiniliwchà Esteban, ad inyoycha ta naarusan na pangpangun na Judio. ");
INSERT INTO ksc_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Niparang pun à Esteban ta chachi pangpangu, impaayagcha chachi nanturtulli. Chinog-achog-anchan turtullicha wi mangifaka, “Na annayay taku, kanayun man-ukuukud à lawing mipangkop ta annayay naapudyusan wi Templotau ya Lintogtau wi inyug-is Moses. ");
INSERT INTO ksc_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tan chingngornin imfakana wi yam-anon anu Jesus wi iNazaret na annayay Templotau ya faliwana kon ukalitau wi intudtuchun Moses ta awi.” ");
INSERT INTO ksc_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Sachin imfakacha, ad immomoschoan chachi pangpangù Esteban, ad nab-os na itchurana ta nangiil-ancha, tan namfaliw à isun na fosar na anghel. ");
INSERT INTO ksc_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Sachi ad, inimus na angatuwani pachi an Esteban, “Tuttuwan imfakacha?” ");
INSERT INTO ksc_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ad summongfat à Esteban anani, “Aamma ya susunud, chongronyuna! Na awi ta iningkawan na achakchakrantauy Abraham ad Mesopotamia wi chaanna pù fumroyan ad Haran, impailà Apudyus wi machaychayaw an siya. ");
INSERT INTO ksc_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ananan Abraham, ‘Taynam na aagkim ya ilim ta ing-a fumroy ta safali wi ikaw wi ituchù an sia.’ ");
INSERT INTO ksc_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Sachi ad, lummayawcha Abraham ta sachi ili wi Caldeo, ad ummoycha finumroy ad Haran. Natoy pù amana, nan-atunon Apudyus chicha ad sachin ummaliyancha ta annayay iniliyantau ta sana. ");
INSERT INTO ksc_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Na sachi timpu, maid impain-uwan Apudyus an Abraham à uray sin-aliwog. Ngim impustan Apudyus an siya wi chumtong na padcha wi maatod losan na annayay Palestine an siya ya kanàna. Ngim chaan pun umanà na asawan Abraham ta nangipustaan Apudyus ta amaschin siya. ");
INSERT INTO ksc_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","“Amasnan impaakammun Apudyus an Abraham: ‘Chumatong na padchay taynan na kanànun annayay luta ad umoycha ta achayuy ikaw wi uwan na safali wi taku. Ad sachin mansaniluwancha ya mapalikatancha ta unog na opat kasuti tawon.’ ");
INSERT INTO ksc_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ad imfakan ako Apudyus an Abraham, ‘Ngim kuisò chachi manginsanilu ta kanànu, ad nu marpaschi, miparufuscha wi mangulin ta annayay luta, ta asnan manaychayawancha asin an saon.’ ");
INSERT INTO ksc_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Na sachi ko, imfakan Apudyus an Abraham wi masapur mamarkaan na lallarai à singyar. Na sachi wi singyar, ifakana wi patiyoncha wi oyyoon Apudyus losan na impustanan chicha. Sachi ad, minarkaan Abraham na anànay Isaac ta awarun padchana. Isuna kon iningwan Isaac ta niyanaan na anànay Jacob. Ad à Jacob, minarkaana ko chachi simpuru ya chuway anànay lallarai, wi chichan narpuwantau. ");
INSERT INTO ksc_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Na chachi narpuwantau wi aannà Jacob, amod na aposcha ta sunudchay uchichi wi Jose, siyan ingnginachà siyà mansanilun na iyEgipto. ");
INSERT INTO ksc_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ngim finadngan Apudyus à Jose ta losani likatna. Innadchon Apudyus na laingna ya achawiyanay mamfaru. Siyan kapu ta amaschi, naragsak na Alin na iyEgipto an siya, ad chinutukanà siyà mamfifinnachur ad Egipto, ya siyan naadchan à mamiyang ta foroyna ya od-ochonna. ");
INSERT INTO ksc_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Na sachi timpu, naingkin losani ili ad Egipto, ya uray ako ad Canaan wi iningkawancha Jacob ya chachi uchumi kanàna. Napalikatan na losani taku ta sachi timpu, wi maid pu manùmunan na achakchakrantaù anoncha. ");
INSERT INTO ksc_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Chingngor pun Jacob wi awad na maan ad Egipto, impaligwatnan aannàna ta umoycha manùmun ad aschi. Ad sachin chamuy ummayan na achakchakrantaud Egipto. ");
INSERT INTO ksc_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Na pigwan na ummayanchad Egipto, impaakammun Jose na long-agna ta susunudna, tan foon pù immatunanchà siya. Ad sachi kon nangakammuwan na Ali ta familyan Jose. ");
INSERT INTO ksc_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ad impaayag Jose na susunudna ya amachay Jacob, ya losani familyacha, ta umalicha losan ad Egipto fumroy. ");
INSERT INTO ksc_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","“Siyan ummoycha Jacob ad Egipto wi pitumpuru ya liman filangcha, ad aschi kon nan-ootoyancha. ");
INSERT INTO ksc_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Na natayan chachi achakchakrantau, inyoy na aannàchan lachagcha ad Sikem à milofon ta sachi nilobnan Abraham. Sachin lofon wi nginin-an Abraham ta aannà Hamor. ");
INSERT INTO ksc_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ad kummanakanà na achakchakrantau ad Egipto, siyan nganngani chumatong na timpu wi mangipauliyan Apudyus an chicha ta annayay ikawtau, wi sachin impustana an Abraham. ");
INSERT INTO ksc_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nansukasukat ad na aaliali ad Egipto, siyan manturay na osay Ali wi foon pù akammunan iningwan Jose ta sin-arkawan. ");
INSERT INTO ksc_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Sinilifan na sachi Ali na achakchakrantau, ad pinalikatana chicha wi impapilitna paifallun abfufùnag wi anàcha ta matoycha. ");
INSERT INTO ksc_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Na sachi timpu, niyanà na osay larai wi Moses wi mamfarun itchurana. Intarun inanà siya ad foroycha ta turuy furan. ");
INSERT INTO ksc_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Narpas pun na turuy furan, nipapilit wi intarucha ta ikid na chawwang ad tinaynanchà siya. Ad à siya, inchasan na fafarasang wi anà na Ali, siyan innarana, ad tinangkonna. ");
INSERT INTO ksc_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ad nitudtuchun Moses na losani kinaraing chachi iyEgipto, siyan nichayaw à Moses ad aschi Egipto kapu ta laingna wi man-ukud ya mangwaana ta ustu. ");
INSERT INTO ksc_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Naopatpuru pun na tawon Moses, simsimmòna wi umoy makafurfurun ta chachi chokanay kanà Israel nu sinun màmàwan chicha. ");
INSERT INTO ksc_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ad innilanan osan chicha wi palikatan na osay iyEgipto. Ummoyna finadngan, siyan imfarosna ad pinatoynan sachi iyEgipto. ");
INSERT INTO ksc_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Anan pun Moses nu maawatan na fufurunna wi siyan chinutukan Apudyus à mangilayaw an chicha ad Egipto, ngim foon pù naawatancha. ");
INSERT INTO ksc_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Tan nafikat pun, inchasan Moses na chuway chokanay kanà Israel wi nampatoy. Ad ingkimauna chicha, wi anana, ‘Fufurun, taayuko mampatoy, wi mansunud-ayu?’ ");
INSERT INTO ksc_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Na lummuki, intùyudnà Moses ad anana, ‘Sinun namilin an sià mallintog an chiani? ");
INSERT INTO ksc_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Winnu piomi patoyonà, wi isun na namatayam ta sachi iyEgipto ad karabyan?’ ");
INSERT INTO ksc_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","“Na nangngoran Moses ta sachi, ummogyat tan naakammun iningwana, siyan ummawid ta achayuy ili wi Midian. Nangasawad aschi ya chuwan anàchay larai. ");
INSERT INTO ksc_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Lummaus pun na opatpuruy tawon wi iniingkawan Moses ad Midian, ad nangkagkaay à Moses ta ikaw wi maid pu chanum, wi achani ta sachi filig wi Sinai. Sachin nangil-ana ta osay imong wi kumilakilab wi nangkakawan anghel Apudyus ta sachi apuy. ");
INSERT INTO ksc_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ad nataag à Moses wi mangila, siyan ummachani ta imoschoana, ad chingngornan kinga wi narpu ta apuy, wi kingan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Anana, ‘Saon à Apudyus wi chinaychayaw na aappum wi Abraham ancha Isaac ya Jacob.’ “Na nangngoran Moses ta sachi, namayogpog ta ogyatna ya foon pù pionay mangila. ");
INSERT INTO ksc_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ad anan Apudyus an siya, ‘Aanom na sapatusnu tan naapudyusan na sanati ikaw wi summisìacham. ");
INSERT INTO ksc_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Inniilà wi napalikatan na takù ad aschi Egipto. Chingngor-un akaagcha wi kaasicha. Siyan ummaliyà wi mangilayaw an chicha. Mangulinò sia, Moses, ad Egipto ad oyyoom na ifakà.’” ");
INSERT INTO ksc_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Inturuy Esteban, wi anana, “À Moses, linawing na achakchakrantaù siya, tan na imfakacha, ‘Sinun nangatod ta karobfongam à sian man-apuni ya manguis an chiani?’ Ngim kattoi siyan chinutukan Apudyus à apucha wi mangilayaw an chicha. Ya nafadngan à Moses ta sachi anghel wi innilana ta kawan na kummilakilab wi imong. ");
INSERT INTO ksc_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","“Ad illayaw Moses na achakchakrantau ad Egipto. Achun iningwanay kaskaschaaw ad aschi Egipto ya uray na chummormangancha ta fayfay wi ananchay Manchilaag. Ya achu kon iningwana, wi maid pu karobfongan na uchumi takuy mangwa, ta nangiyayanan chicha ta sachi ikaw wi maid pu chanum. Na nangkagkagkaayancha ta sachi, ummoy à opatpuruy tawon. ");
INSERT INTO ksc_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Intudtuchun Moses ta achakchakrantau, wi mangifaka, ‘Awad na osay ifaun Apudyus wi profeta ta kanàtau, wi isun saon.’ ");
INSERT INTO ksc_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","À Moses, siyan nakaukuchan na anghel ta sachi filig wi Sinai ta nangawatana ta lintog Apudyus. Ad intudtuchun Moses ta achakchakrantau na lintog ta nangkagkagkaayancha ta sachi ikaw wi maid pu chanum. Na intudtuchunad aschi, sachin mangakammuwantau ta mafiyakantaù ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ngim na achakchakrantau, foon pù patkonchà Moses wi siya kay pionchan mangulin ad Egipto. ");
INSERT INTO ksc_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Na sachi, nanakachà Moses ta filig wi Sinai nakaukud an Apudyus. Ad na maichana, imfakan na taku ta panguruy sunudnay Aaron, anancha, ‘Mangwaà apudyustau ta chichan mangipangun chitau, tan maid pun akammutau nu sinun nàwan Moses wi nangiparawan chitau ad Egipto.’ ");
INSERT INTO ksc_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","“Sachi ad, iningwachan sinanfaka ta awad mamàilà chaychayawoncha. Impartiyancha ya naragsakcha ta iningwacha wi apudyuscha nu. ");
INSERT INTO ksc_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","“Sachin nan-awichan Apudyus an chicha. Tinaynanan achakchakrantau ta chaychayawonchan farangnay pioncha, wi uray fituwon ya init winnu furan. Awad na imfakan Apudyus an chicha wi inyug-is na profeta ta awi, wi anana, ‘Chiayuy kanà Israel, na sachi opatpuruy tawon wi nangkagkagkaayanyu ta sachi ikaw wi maid pu chanum, foon pù saon na impartiyanyu. Foon pù saon na chinaychayawyu, ");
INSERT INTO ksc_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","tan finuudyun sachi sinanforoy wi iningkawan na sinan-Apudyusyu wi Moloch. Chinaychayawyu kon sachi fituwon Refam wi inapudyusyu ko. Chichan iningwayu à chinaychayawyu wi foon pù saon. Siyan iparufus-un maiyoyanyu ta achayuy luta wi mar-usan ad Babilonia.’” ");
INSERT INTO ksc_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Inturuy Esteban, wi anana, “Na nangkagkagkaayan na achakchakrantau ta sachi ikaw wi maid pu chanum, uray foon pù Apudyus na chinaychayawcha, awad an chicha na isù foroy wi iningwan Moses à mammammoancha an Apudyus. À Apudyus na nangifaka wi oyyoon Moses na sachi, ya intudtuchuna kon inyòoyyanay nangwa wi inusarnan uglit na animar ya luput. ");
INSERT INTO ksc_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Natoy pù Moses, Josue na nisukat an siya. Ya sinuy ummayan na achakchakrantau, finuudchan sachi isù foroy wi foroy Apudyus. Na sachi timpu, finadngan Apudyus na achakchakrantau wi mangiparyaw ta sinumani iningkaw ad Canaan, ta man-uwan na achakchakrantau. Ad inyalichad asna na sachi isù foroy, ad asnan iningkawancha ingkana ta timpun David. ");
INSERT INTO ksc_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tuttuway inay-ayat Apudyus à David, ya inchaw David an Apudyus à miparufus à siya à mangwà afaruwan à foroy Apudyus, ta awad manchaychayawanchan siya, wi siyan Apudyus wi chinaychayaw na aputauy Jacob. ");
INSERT INTO ksc_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ngim foon pù David na imparufus Apudyus wi mangwa ta sachi foroy, tan anànay Solomon. ");
INSERT INTO ksc_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ngim à Apudyus wi angatuwan, foon pù foroy wi ingwan na takun ingkawana; tan inyug-is na profeta ta awi na ukud Apudyus, wi anana, ");
INSERT INTO ksc_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","‘Langit na tumùchuwà wi manturay, anan Apudyus. Ya annay lutan kukuschà. Ad in-inonyuy mangwà ustuy ingkawà? Tan à saon, iningwà losan! Siyan maid pu in-inonyu wi mangwà ingkawà.’ ");
INSERT INTO ksc_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Amod na kinatangkinyu!” anan Esteban. “Uray Judioayu, achiyu pu patkon à Apudyus, ya achiyu pu ko chongron na ifakana! Ya achiyu pu patkon na Ispirituna; achogkaanyu kan chachi achakchakrantau ta awi, ");
INSERT INTO ksc_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","tan maid pu osà profetà foon pù pinalikatan na achakchakrantau! Pinatoycha chachi profetas wi finaun Apudyus wi mangifaka mipangkop ta umaliyan na anànay Jesus wi maid fasurna. Ad ummali pun à Jesus, impatiliwyù siya ad pinatoyyu ko. ");
INSERT INTO ksc_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Chiayu kon naadchan na lintog Apudyus wi intudtuchun na aangheles, ngim achiyu pu ko patkon!” ");
INSERT INTO ksc_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Na nangngoran chachi pangpangu ta imfakan Esteban, nangamiamiwcha ta og-otcha. ");
INSERT INTO ksc_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ngim à Esteban, nakarong-ag na Ispiritun Apudyus an siya. Nantangad ad langit ad innilanan sumilingan na kinafarun Apudyus. Ad innilana kò Jesus wi awad ta apot ta chiwawan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Ilanyu,” anan Esteban. “Niwanit ad langit ya anchì Jesus wi namfarfalin taku wi awad ta apot ta chiwawan Apudyus!” ");
INSERT INTO ksc_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ad na pangpangun na Judio, impupchan ingacha, ad nampauycha ta achicha pu chongron na ifakan Esteban. Ad kinankanaschay manòman siya, ");
INSERT INTO ksc_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ad kinuykuychà siya ta ikid na ili. Na takuy nallastug mipangkop an siya, imfanatchan agwan na silupcha ta sangwanan Saulo, wi siyan osay pangatcha. Ad pinisongchà siya. ");
INSERT INTO ksc_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Na namisopisonganchan Esteban, nalluwarù siya wi anana, “Apu Jesus, aram na achawong-u!” ");
INSERT INTO ksc_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ad nampalintumong à siya, ad chinakornan kingana wi mangifaka, “Apu, achim pafasuron chicha ta annay oyyooncha.” Sachin imfakana, ad natoy. ");
INSERT INTO ksc_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Ad à Saulo, siyan osay nangiparufus ta namatayanchan Esteban. Na sachi, iningkaw na uchumi Judio wi ustun somsomòchan Apudyus. Amod na nangichomchomanchan Esteban, ad illofoncha. Ad na sachi padcha wi natayan Esteban, nilukin mapalikatan na mamati ad Jerusalem. Siyan niwartàcha ta ailiili ta provinsiya wi Judea ya Samaria. Ngim na apostoles, foon pù lumayawchad Jerusalem. ");
INSERT INTO ksc_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ad à Saulo, isagna palikatan na mamati ta iwarangcha, wi lon-ona chicha pakuykuy ta foroycha ad impaifarudna chicha, uray fufai ya larai. ");
INSERT INTO ksc_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Na chachi niwartà wi mamati, itudtudtuchuchan chamag mipangkop an Jesus ta sinumani umayancha. ");
INSERT INTO ksc_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","À Felipe, ummoy ta osay ilid Samaria à mantudtuchu ta takud aschi wi tuttuway Jesus na Cristu wi impustan Apudyus wi umali. ");
INSERT INTO ksc_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Naamuamung na taku wi nanangngor ta imfakana. Ad na nangil-ancha ta kaskaschaaw wi iningwana, naschaawcha. ");
INSERT INTO ksc_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Imparyawnan aran wi farfaray na ad-adchuwani taku, ad nampauy na aran ta lummawaancha. Inaanna kon ayayong ya pilay na ad-adchuwani taku, ");
INSERT INTO ksc_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","siyan naragsak na taku ta sachi ili wi Samaria. ");
INSERT INTO ksc_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Iningkaw ako ta sachi ili na osay larai wi Simon na ngachanna. Ad mangwamangwà kaskaschaaw à mataakan na takud Samaria ta sarumangkana. Imfakana wi siya nun osay pangat tan annan karobfongana. ");
INSERT INTO ksc_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Siyan losani taku ta sachi, uray sinuy kinasasaadcha, natataagchan siya. Anancha, “Awad tuwan siya na chakorani karobfongan Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Kapu ta nafayag na nangipail-ana ta kaskaschaaw ta chachi taku, chichingngorchà siya. ");
INSERT INTO ksc_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ngim na chummatngan Felipe, intudtuchun Felipe ta taku na mamfaruy chamag wi mipangkop ta Manturayan Apudyus ya mipangkop an Jesu Cristu, ad pinatin na takun intudtuchuna, ya nampafunyagchay lallarai ya fubfufai. ");
INSERT INTO ksc_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Uray akò Simon, namati ko, ad nafunyakan pun, nitun-ud an Felipe. Ad nataag à Simon wi nangiila ta losani kaskaschaaw wi iningwan Felipe. ");
INSERT INTO ksc_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Chingngor pun na apostoles ad Jerusalem wi pinatin na takud Samaria na ukud Apudyus, imfaunchà Pedro an Juan ta sachi. ");
INSERT INTO ksc_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Chummatongcha pun, illuwaruwanchan chachi mamati, ta umalin Ispiritun Apudyus makarong-ag an chicha, ");
INSERT INTO ksc_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","tan uray nafunyakancha ta ngachan Apu Jesus, chaan pu umalin Ispiritun Apudyus an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Sachi ad impataycha Pedro an Juan na imacha ta chachi mamati ad siyan ummaliyan na Ispiritun Apudyus wi makarong-ag an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ad innilan pun Simon wi nakarong-ag na Ispiritun Apudyus ta chachi mamati, ta nangipatayan na apostoles ta imachan chicha, impailanan pilak an Pedro ya Juan, ");
INSERT INTO ksc_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","wi anana, “Adchanà akò karobfongà ta uray sinuy mangipatayà ako ta imà, makarong-ag akon Ispiritun Apudyus an siya.” ");
INSERT INTO ksc_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Anan Pedro an siya, “Mifallua kuma ad infierno, wi mitapi kon pilaknu, tan anam pun nu mafalini ngin-am na adchon Apudyus, wi achi pu mangin-an! ");
INSERT INTO ksc_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Achia mifibfiyang ta annay iwaarni mipangkop an Jesu Cristu, tan foon pù ustun somsomònun Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Siyan ifafawim na lawingi somsomònu, ya man-ochaw-an Apudyus nu mafalin pakawanonan safali wi simsimmònu. ");
INSERT INTO ksc_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tan akammù wi amod na aposnu ya isù nifafarud-a ta fasurnu.” ");
INSERT INTO ksc_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Siyan anan Simon ancha Pedro an Juan, “Ipangngaasiyu ta iluwaruwanà, ta achi pu màwan amaschi wi imfakayun saon.” ");
INSERT INTO ksc_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Tinistikuwancha pu Pedro an Juan na mipangkop an Jesu Cristu ta takud aschi, nangulinchad Jerusalem. Na nangulinancha, intudtuchuchan Mamfaruy chamag mipangkop an Jesus ta ailiilid Samaria wi innoycha. ");
INSERT INTO ksc_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Imfakan na osay anghel Apudyus an Felipe anani, “Lumigwat-a umoy ta arsa wi marpud Jerusalem wi umoy ad Gaza.” (Na sachi arsa, nangoy ta ikaw wi maid pu chanum.) ");
INSERT INTO ksc_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Siyan lummigwat à Felipe ummoy ta arsa ad sinib-atnan kalisa wi nallukanan na osay nangatuy upisyar, wi mamangchon ta pilak Candace wi Ali ad Etiopia, wi narpud Jerusalem ummoy nakachaychayaw an Apudyus ad lumayaw umoy ad Etiopia. ");
INSERT INTO ksc_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Na nallurugkanana, fasafasaonan Ukud Apudyus wi inyug-is na profetay Isaias ta awi. ");
INSERT INTO ksc_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ad anan na Ispiritun Apudyus an Felipe, “Ing-a umachani ta sanati nallurukan.” ");
INSERT INTO ksc_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ad nanodchà à Felipe. Ummachani pù Felipe ta kalisan na sachi iyEtiopia, chingngorna wi fasafasaonan inyug-is na profetay Isaias. Ad inimus Felipe, “Maawatam na sanati fasfasaom?” ");
INSERT INTO ksc_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Summongfat, “In-inò wi mangakammu nu maid pu mangitudtuchun saon nu sinun pionay ifaka?” Sachi ad, imfakanan Felipe ta makarukan an siya. ");
INSERT INTO ksc_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na sachi finasana, anana, “Isù pannilù siya wi maparti. Isun akon anà na pannilu wi foon pù kuminga ta mangaanancha ta chutchutna. Amaschin nàwa ta namalikatanchan siya. ");
INSERT INTO ksc_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nafainan à siya, ya foon pù ustun nanguisanchan siya. Maid miyisuwan na kinarawing na ingwan na asintatakuna, tan pinatoychà siya.” ");
INSERT INTO ksc_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ad inimus na larai an Felipe, “Na sachi profeta, long-agnan ug-ugkuchona winnu safali wi taku?” ");
INSERT INTO ksc_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ad illukin Felipe wi mantudtuchun siya ta Mamfaruy Chamag mipangkop an Jesus, wi Jesus kattò na ug-ugkuchon na sachi profeta. ");
INSERT INTO ksc_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Na nallurugkanancha, nichaumcha ta annan chanum, siyan anan na iyEtiopia, “Annat na chanum. Mafalini mafunyakanà ta sana?” ");
INSERT INTO ksc_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ad anan Felipe, “Oo, mafalin nu tuttuway mamatian Jesus.” “Oo, mamatiyà,” anana. “Patiyò wi à Jesu Cristu, siyan anà Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Sachi ad, impaillongnan kalisana, ad lummogsadcha nallunong ta chanum, ad finunyakan Felipè siya. ");
INSERT INTO ksc_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Na lummoswaancha ta chanum, illayaw na Ispiritun Apudyus à Felipe, ya maid pu asin ilan na sachi iyEtiopia an siya. Ngim inturuyna ko kay ta umayana, wi naragsak. ");
INSERT INTO ksc_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ad à Felipe, nachanatong ad Azoto. Ad intudtuchunan Mamfaruy Chamag mipangkop an Jesus ta ailiili, ingkanà chummatong ad Cesarea. ");
INSERT INTO ksc_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ngim à Saulo, pumigsapigsan mamalikatana ta chachi mamatin Apu Jesus wi pionay mapatoycha. Sachin ummayana ta Angatuwani Pachi ");
INSERT INTO ksc_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ta mampàwà kasuratan ta chachi mangipangpangu ta sinagogan na Judio ad Damasco, wi annan karobfonganay mantiliw ta sinumani takuy mamatin Jesus, uray fufai ya larai, ta ipagkulinna chichad Jerusalem. ");
INSERT INTO ksc_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Chanchanicha pun Saulo ad Damasco, nammaag nasiling à Saulo ta linang wi narpu ta langit. ");
INSERT INTO ksc_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Nalitwad à siya ad chingngornan kinga wi anana, “Siay Saulo, tammakò saon parpalikatan?” ");
INSERT INTO ksc_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“Sinua, Apu?” anan Saulo. Ad summongfat na kumminga, “Saon à Jesus, wi parpalikatam ta mamalikatam ta anchanay mamatin saon. ");
INSERT INTO ksc_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Fumangon-a ta ing-a ta ili, ad mifakan sia ad aschi na masapur wi oyyoom.” ");
INSERT INTO ksc_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Na fufurun Saulo wi nitun-ud an siya, ummagsadcha. Natataagcha tan chingngorchan sachi kumminga, ngim maid pu innilachà taku. ");
INSERT INTO ksc_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sachi ad, fummangon pù Saulo, nanchiyat ad achi pu makaila tan nakurap. Siyan iniwidchà siya inyoy ad Damasco. ");
INSERT INTO ksc_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Naatluy padchan nakurapan Saulo, ya maid nangnanganana ya umin-inumana ta sachi turuy padcha. ");
INSERT INTO ksc_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Iningkaw ad Damasco na osay mamatin Jesus, wi Ananias na ngachanna. Impailà Apu Jesus an siya ta in-inopna, wi nangifaka, “Ananias!” “Apu, sinun ifakam?” anan Ananias. ");
INSERT INTO ksc_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ad anan Apu Jesus an siya, “Lumigwat-a, Ananias, ta ing-a ta foroy Judas wi awad ta arsa wi ananchay Linchongan. Anapom ta sachin osay takuy iTarso, wi Saulo na ngachanna, wi malluwaruwaru ta sana. ");
INSERT INTO ksc_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Tan impain-inop-un siya wi umalin osay larai wi Ananias na ngachanna ta ipataynan imanan siya ta maaan na kurapna.” ");
INSERT INTO ksc_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Summongfat à Ananias wi anana, “Oo, Apu, ngim achun takuy nangisturyan saon ta mipangkop ta arwingani iningwana, tan pinarpalikatanan takum ad Jerusalem. ");
INSERT INTO ksc_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ad na pangkop anun ummaliyanad asnay Damasco, tiliwonà chiani losan wi mamatin sia, tan nampàwà surat na angatuwani pachi wi mangiparufus ta maniliwanan chiani.” ");
INSERT INTO ksc_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ngim anan Jesus an siya, “Ing-a kay, tan chinutukà à siyà mansilfin saon à mangipagngor ta mipangkop an saon ta tuturay, ya chachi foon à Judio, ya uray chiayuy Judio. ");
INSERT INTO ksc_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ya ipaakammù akon siyan losani mapalikatana kapu ta mangipaakammuwanan saon.” ");
INSERT INTO ksc_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Sachi ad, lummigwat à Ananias ummoy ta foroy Judas ad inchasanà Saulo. Impataynan imanan siya ad anana, “Sunud-uy Saulo, à Apu Jesus na nangifaun an saon, wi siyan innilam ta arsa ta ummaliyam ad asna. Finaunnà saon à mangipatay ta imà an sia ta maaan na kurapnu, ad umalin Ispiritun Apudyus makarong-ag an sia.” ");
INSERT INTO ksc_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Sachi ad, linìnan Saulo wi naaan na arusìsì na atana, ad mafalini makaila. Sachi ad, lummigwat, ad nafunyakan. ");
INSERT INTO ksc_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Narpas pun na sachi, nangan à Saulo ad ummoschor. Nafayag à Saulo ad Damasco wi iniingkaw ta chachi mamatin Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ad ummoy à siya ta sinagogan na Judio nantudtuchù mipangkop an Jesus. Anana, “Siyan anà Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nataag na nangngor, ad inimuscha, “Foon ayà siyan namarpalikat ta chachi mamatin Jesus ad Jerusalem? Na pangkopnay umalid asna tiliwona chana mamati ta iyoynad Jerusalem isangu ta chachi pangpangun na papachi!” ");
INSERT INTO ksc_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ngim à Saulo, pummigpigsan pinagtudtuchuna mipangkop an Jesus. Na chokanay Judio ad Damasco, achicha pu makasongfat kapu ta kinaraing Saulo wi mangistiku an Jesus, wi siyan impustan Apudyus wi manturay. ");
INSERT INTO ksc_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Lummaus ad na achuy padcha, nantuturag na uchumi Judio nu sinun oyyoonchà mangtoyanchan Saulo. ");
INSERT INTO ksc_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Sachi ad finangafanganchan losani liwangan na ili ta pinadcha ya linafi ta patoyonchà Saulo. Ngim iningkaw na nangiyakutimtim an Saulo ta puranun na Judio. ");
INSERT INTO ksc_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Siyan na osay lafi, inyoy na fufurun Saulo à siya ta chingching na ili. Ad inyinchayuncha ta lasin na chingching. ");
INSERT INTO ksc_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ad nangulin à Saulo ad Jerusalem. Na chummatngana, pionay miyamung ta chachi mamati, ngim ummogyatchan siya tan foon pù tuttuwaoncha wi mamatì siya. ");
INSERT INTO ksc_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ngim finurnan Bernabe à siya ad inyoyna ta awachan na apostoles, ad inisturyanan nangil-an Saulo an Apu Jesus ta arsa wi umoy ad Damasco. Insuplikarna losan na imfakan Jesus an Saulo, ya kinaturod Saulo wi nangitudtuchu mipangkop an Jesus ad Damasco. ");
INSERT INTO ksc_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Sachi ad imfilangchà Saulo à furuncha, siyan iningkaw an chicha nantudtuchu ad Jerusalem. Ya maid pu ogyat Saulo wi mantudtuchu mipangkop an Apu Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nakaug-ugkud ya nakais-isì ta chachi Judio wi Griego na ukudcha. Ad pionchay mamatoy an siya. ");
INSERT INTO ksc_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Na nangakammuwan na fufurun Saulo ta puranucha, inyoychà siya ad Cesarea, ad pin-oychà siya ad Tarso wi sikuchi ilina. ");
INSERT INTO ksc_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Na sachi timpu, maid mapalikatan na chachi mamatin Jesus ta ailiilid Judea ya Galilea ya Samaria. Ad kapu ta fachang na Ispiritun Apudyus, pummigsapigsan pammaticha ya ummachuachun mamati, ya mafainchay manurngasing ta pion Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","À Pedro, nan-attuattun ta ailiili wi awachan na mamati, siyan na osay padcha ummoyna fisitaon na takun Apudyus ad Lidda. ");
INSERT INTO ksc_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Inchasanad aschi na osay larai wi Eneas na ngachanna. À Eneas, ummoy à waruy tawon na achina pun makaligwatan ta ofogna tan naayayong. ");
INSERT INTO ksc_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Siyan anan Pedro an siya, “Eneas, paimfakon Jesu Cristù sia. Lumigwat-a ad luutom na ofognu.” Ad nasaryun lummigwat à Eneas. ");
INSERT INTO ksc_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Innilan pun na takud Lidda ya Saron à siya, namaticha losan an Apu Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ad Joppe, iningkaw na osay fufai wi mamati, wi Tabita na ngachanna. (À Dorcas na ngachanna ta Griego wi ukud, wi na miningna, ugsa.) Mamfarun ining-ingwana, ya ad-adchuwan na kakapus wi finadngana. ");
INSERT INTO ksc_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Na sachi timpu, nasakit à Tabita, ad natoy. Inamoschan lachagna ad imfanatcha ta ngatuy kuwartun na foroyna. ");
INSERT INTO ksc_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Chingngor pun na mamati wi awad à Pedro ad Lidda wi achanid Joppe, imfaunchan chuwà umoy mangayag an Pedro wi anancha, “Aw-awaynu ad ta intaud Joppe.” ");
INSERT INTO ksc_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ad nifurun à Pedro an chicha. Chummatongcha ad, inayakanchà siya ta kuwartun na foroy Dorcas wi nifanatana. Ad nakaam-ammung na man-afaru an Pedro. Asiiifilcha wi nangipaila ta luput wi chinait Dorcas ta atattakuna. ");
INSERT INTO ksc_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ngim imparawan Pedro chicha, ad nampalintumong wi malluwaru an Apudyus. Sachi ad, nansakung ta natoy, ad anana, “Tabita, fumangon-a!” Ad chiniyatnan atana, ad na nangil-anan Pedro, fummangon. ");
INSERT INTO ksc_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Inognan Pedro na imana ad impasiadna. Ad inayakana chachi mamati ya chachi nafaru, ad impailana wi ummuli natakù Tabita. ");
INSERT INTO ksc_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nanchinamag na sachi nàwa ta losani takud Joppe, ad ummachun mamati an Apu Jesus kapu ta sachi nàwa. ");
INSERT INTO ksc_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ad iningkaw à Pedro à nafayag ad Joppe ta foroy Simon, wi na iwaar Simon, mamangwà larat. ");
INSERT INTO ksc_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Iningkaw ad Cesarea na osay larai wi nangngachan Cornelio. Siyan kapitan na singkasuti surchachu wi Romano wi narpuchad Italia. ");
INSERT INTO ksc_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Uray foon à Judio, nangApudyuscha Cornelio wi simfaryan. Losancha chaychayawon à Apudyus, ya achu kon inadchona wi fachang ta kakapus wi Judio, ya kanayuncha malluwaru an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ar-arkaw pun ta osay padcha, iningkaw na impain-inop Apudyus an Cornelio. Innilanan osay anghel Apudyus wi linumnò ta foroyna, wi anana, “Cornelio!” ");
INSERT INTO ksc_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Immomoschoan Cornelio na anghel ta ogyatna, ad anana, “Oo, Apu, sinun ifakam?” Ad anan na anghel, “Chingngor Apudyus na luwarum ya akammuna kon kaasim ta kakapus, ad som-osom-onà sia. ");
INSERT INTO ksc_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Umifaun-à umoy ad Joppe mangayag ta osay larai ad aschi wi mangngachan à Simon Pedro. ");
INSERT INTO ksc_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Awad ta foroy na osay Simon wi na foroyna achani ta fayfay. Na sachi Simon, mamangwà larat na iwaarna.” ");
INSERT INTO ksc_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Narpas pun wi imfakan na anghel na sachi, lummayaw. Ad inayakan Cornelio na chuway saniluna ya osay surchachuna wi siyan fachang Cornelio wi chinaychayawna kò Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Inisturyan Cornelio an chicha losan na inin-inopna achinaot ifaun à chicha ad Joppe. ");
INSERT INTO ksc_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Nafikat pun ta nanadcharanan na turuy nifaun, ummachanicha ta ili wi Joppe, ad niyaspur wi ummoy à Pedro nalluwaru ta sachi mamatù ta tanapi tabfungan na foroy. ");
INSERT INTO ksc_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ad nafitil wi pionay mangan ngim chaan pù mautun maan. Na nangisakanaancha ta manganana iningkaw na impain-inop Apudyus an siya. ");
INSERT INTO ksc_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Inin-inopna wi niwanit ad langit ad iningkaw na isù arway uros wi nifufuy-ug wi chumòchòora ta luta. ");
INSERT INTO ksc_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ad na iningkaw ta sachi uros, nan-ob-ofot wi man-àachap, wi na uchum, mipalit à anon na Judio. ");
INSERT INTO ksc_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ad chingngor Pedro na kumminga, wi anana, “Pedro, fumangon-a ta partiyom na piomi anon!” ");
INSERT INTO ksc_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Summongfat à Pedro wi anana, “Foon, Apu, tan nanipud ta niyanaà, maid pu in-innan-ù ischà paniyawonni wi Judio.” ");
INSERT INTO ksc_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Asin ako nan-ukud na kummingad langit, anana, “Pedro, achim anan wi paniyaw na maan, tan ifilang Apudyus losan na maan à mamfaru.” ");
INSERT INTO ksc_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Nàwan sachì namitlu, ad mipagkulin na sachi ad langit. ");
INSERT INTO ksc_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Som-osom-on pu Pedro nu sinun mining na sachi inin-inopna, chummatong ad Joppe chachi taku wi finaun Cornelio. Inchasancha pun na foroy Simon, ");
INSERT INTO ksc_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","inimuscha nu awad mangilinà nangngachan à Simon Pedro. ");
INSERT INTO ksc_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Na manom-asom-an Pedro nu sinun mining na impain-inop Apudyus an siya, imfakan na Ispiritun Apudyus an siya, “Pedro, awad na turuy laraid chora wi manganap an sia. ");
INSERT INTO ksc_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Siyan man-osog-a ya achia manchuwachuwa wi mifurun an chicha, tan saon na nangifaun an chicha.” ");
INSERT INTO ksc_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Sachi ad nan-osog à Pedro, ad imfakana ta chachi lallarai, “Saon na anaponyu. Sinun ifakayu?” ");
INSERT INTO ksc_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ananchay summongfat, “À Cornelio wi kapitan na susurchachu, siyan nangifaun an chiani. Mamfarun sachi apuni wi Cornelio, wi chaychayawonà Apudyus. Lispituwon na Judiò siya. Imfakan na osay anghel Apudyus ta paayagnà sia ta chongrona nu sinun itudtuchum an siya.” ");
INSERT INTO ksc_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Chingngor pu Pedro na imfakacha, minangilinà chicha ad ummiyancha. Nafikat pun, nakaligwat à Pedro an chicha, ya nifurun akon uchumi mamati wi iJoppe. ");
INSERT INTO ksc_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Asin pu nafikat, chummatongchad Cesarea wi nanguullayancha Cornelion chicha. Iningkaw akon uchumi inayakan Cornelio wi aagkina ya fufurunna. ");
INSERT INTO ksc_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Na linumnoan Pedro ta foroy, nampalintumong à Cornelio ta sangwanana wi manayaw an siya. ");
INSERT INTO ksc_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ngim anan Pedro, “Sumiad-a, tan man-isutay losan taku.” ");
INSERT INTO ksc_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Summiad à Cornelio ad nan-ug-ugkudcha ta linumnoancha ta foroy, ya achun takuy inchasan Pedro wi naarus. ");
INSERT INTO ksc_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ad imfakan Pedro an chicha losan, “Chiayuy foon à Judio, inaagkammuyu wi mipalit na makafurfurun-ani wi Judio ta takuy foon à Judio; uray na lumnoanni ta foroyyu, mipalit, tan siyan osay lintogni. Ngim impaakammun Apudyus an saon wi maid pu arwingan na makafurfurnà an chiayuy foon à Judio. ");
INSERT INTO ksc_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ad sachin ummaliyà ta nangayakanyun saon wi maid pu isìu, uray foon-ayu pù Judio. Siyan imusò nu taayuko umayag?” ");
INSERT INTO ksc_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Sachi ad, insuplikar Cornelio, wi anana, “Miyapat padchan sana, wi isun na sanay ar-arkaw, nalluwaruwà ta annay foroyni. Ad nammaag ummagsad ta sangwanan-un osay taku wi mammusiling na silupna, ");
INSERT INTO ksc_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ad anana, ‘Cornelio, chingngor Apudyus na luwarum ya sosom-onan kaasim ta kakapus; ");
INSERT INTO ksc_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","siyan umifaun-à umoy ad Joppe mangayag ta mangngachan à Simon Pedro, wi awad ta foroy Simon wi mamangwà larat, wi achanin foroyna ta fayfay.’ ");
INSERT INTO ksc_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","“Siyan namfaunà à ummali nangayag an sia, ad mamfaru tan inanusami ummali. Ad na sana, awad-ani losan ta chongronnin ipaakammun Apudyus an chiani.” ");
INSERT INTO ksc_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ad illukin Pedro wi man-ukud, anana, “Sana kan mangawatà wi tuttuway man-iisuwon Apudyus na ayatna ta losani taku, ");
INSERT INTO ksc_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","tan uray farangnay taku ta luta, nu chayawonà Apudyus ya oyyoonan ustu, mitipun an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Chingngoryun Mamfaruy Chamag wi impaakammun Apudyus an chiani wi kanà Israel mipangkop an Jesu Cristu, wi mafalin maurnus na somsomò na taku mipakapun siya, wi siyan Aputau losan, wi foon pu kà afus na Judio. ");
INSERT INTO ksc_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Akammuyu kon intudtuchun Jesus ya iningwana ta losani sinakup Israel. Illukinan ining-ingwana ad Galilea ta narpasan na nantudtuchuwan Juan mipangkop ta funyag. ");
INSERT INTO ksc_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","“Kapilitan wi chingngoryu ko wi inadchon Apudyus an Jesus na Ispirituna ya karobfongana, siyan uray sinuy ummayana, mamfarun iningwana ta taku, ya impaimfagnan nakafarfaray, tan annà Apudyus an siya. ");
INSERT INTO ksc_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","À chiani wi apostoles, innilanin losani iningwanad Jerusalem ya uchumi ilini wi Israel. Illansachà Jesus ta kros, ad sachin natayana. ");
INSERT INTO ksc_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ngim na niyatluy padcha, impaulin Apudyus tinakù siya, ad impailà siya ta taku. ");
INSERT INTO ksc_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ngim foon pù innilan na losani takù siya tan chiani kan nangila wi chinutukan Apudyus à mangistikun siya. Ya chianin nakaan akon siya ta ummuliyana natakuwan. ");
INSERT INTO ksc_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ad imfilinnan chiani ta itudtuchunin Mamfaruy Chamag mipangkop an siya ta losani taku; ya istikuwanni ko wi siyan chinutukan Apudyus à manguis ta losani taku, uray na nanattoy. ");
INSERT INTO ksc_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ad ako, na losani profetas ta awi, imfakacha wi na losani mamatin Jesus, mapakawan na fasurcha, mipakapun siya.” ");
INSERT INTO ksc_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Na man-ukuukuchan Pedro, sachin nakarong-akan na Ispiritun Apudyus ta losani nanchongor. ");
INSERT INTO ksc_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Na chachi mamati wi Judio wi nifurun an Pedro, wi narpud Joppe, naschaawcha tan uray na foon à Judio, nakarong-ag akon Ispiritun Apudyus an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Tan chichingngorcha wi chaychayawon chachi foon à Judio à Apudyus ya mafalini man-ukudchà safalì ukud wi foon pù sikud wi ukudcha. Siyan anan Pedro ta fufurunna, ");
INSERT INTO ksc_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Na anchanayay foon à Judio, nakarong-ag na Ispiritun Apudyus an chicha, wi isun chitau, siyan awad lawa mangipalit an chichà mafunyakan?” ");
INSERT INTO ksc_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Sachi ad imfakan Pedro ta mafunyakancha kapu ta namatiyanchan Jesu Cristu. Narpas pun, tinawichanchà Pedro ta ingkaw yan an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ad na apostoles ya losani mamati wi Judio ad Judea, chingngorcha wi na uchumi foon à Judio, pinaticha kon ukud Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Siyan na nangulinan Pedro ad Jerusalem, na uchumi mamati wi Judio wi mangaadchi mampatungpar ta sikuchi achawiyancha ta foon à Judio, chinillawchà siya. ");
INSERT INTO ksc_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Anancha, “Paako pamangili ta foon à Judio wi foon pù namarkaancha, ad nakaan-a kon chicha, ad foon pù imfilangnù lawing!” ");
INSERT INTO ksc_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Siyan insuplikar Pedro na losani nànàwa. ");
INSERT INTO ksc_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Anana, “Na nalluwaruwà ad aschi Joppe, iningkaw na impain-inop Apudyus an saon. Innilà na isù arway uros wi nifufuy-ug wi chummòchòora wi narpud langit, ad nichissu ta sangwanà. ");
INSERT INTO ksc_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Intollong-un charomna, ad nan-ob-ofot wi man-àachap na iningkaw, wi na uchum, mipalit à anon na Judio. ");
INSERT INTO ksc_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ad chingngor-u kon kumminga ta sachi. Anana, ‘Fumangon-a, Pedro. Partiyom na piomi anon!’ ");
INSERT INTO ksc_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Ngim ummisià anani, ‘Foon, Apu! Tan nanipud ta niyanaà, maid pu in-innan-ù ischà paniyawonni wi Judio.’ ");
INSERT INTO ksc_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Asin ako nan-ukud na kummingad langit, wi anana, ‘Achim anan wi paniyaw na maan, tan ifilang Apudyus losan na maan à mamfaru.’ ");
INSERT INTO ksc_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Nàwan sachì namitlu, ad nipagkulin na uros ad langit. ");
INSERT INTO ksc_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Ad sachi kon chummatngan na turuy larai ta foroy wi iningkawà. Nifauncha wi narpud Cesarea à nangayag an saon. ");
INSERT INTO ksc_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ad impaakammun na Ispiritun Apudyus an saon ta achiyà manchuwachuwa wi mifurun an chicha. Siyan nifurunà an chicha ya nitun-ud akon anchanayay onomi susunudtau. Nichaum-ani pun ad Cesarea, linumnòani ta foroycha Cornelio. ");
INSERT INTO ksc_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","“Ad insuplikar Cornelio an chianin nangil-ana ta anghel ta foroyna. Imfakan anun sachi anghel an siya, ‘Umifaun-à umoy ad Joppe mangayag ta mangngachan à Simon Pedro. ");
INSERT INTO ksc_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Itudtuchunan chiayun masaraknifanyuy simfaryan.’ ");
INSERT INTO ksc_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Ad illukì pun wi mantudtuchu, nakarong-ag na Ispiritun Apudyus an chicha wi isun akon nakarong-akanan chitau ta chamu. ");
INSERT INTO ksc_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ad sachin nangiyakasmoà ta imfakan na Aputau wi Jesus, wi anana, ‘Imfunyag Juan na chanum an chiayù singyar na namatiyanyu, ngim safalin ifunyag Apudyus, tan ifunyagnan Ispiritunà makarong-ag an chiayu.’ ");
INSERT INTO ksc_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","“Siyan nu nangatod à Apudyus ta Ispirituna ta chachi foon à Judio, wi isun akon nangadchanan chitau ta namatiyantaun Apu Jesu Cristu, sinun kinatatakù nu ipalit-un pion Apudyus wi oyyoon!” anan Pedro. ");
INSERT INTO ksc_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Chingngorcha pun na imfakan Pedro, nat-opcha ad inwarangchay nanillaw an siya, ad chinayawchà Apudyus, wi anancha, “Inadchan ako Apudyus na chachi foon à Judio à wayachay mamfafawi ta maadchancha kò mannaynayuni fiyag!” ");
INSERT INTO ksc_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nanipud ta napatoyan Esteban, naparpalikatan na mamati, siyan niwartàcha. Na uchum, ummoycha ta achayu wi Fenicia, ad na uchum, ummoychad Chipre ya ikad ad Antiokia. Ad imfakafakachan Mamfaruy Chamag mipangkop an Jesu Cristu ta sinumani umayancha, ngim afus na chokachay Judiò nangifag-ancha. ");
INSERT INTO ksc_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ngim na uchumi mamati wi iChipre ya iCirene, ummoychad Antiokia wi mangipagngor ta Mamfaruy Chamag wi mipangkop an Apu Jesus ta takuy foon à Judio. ");
INSERT INTO ksc_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kapu ta annan karobfongan Apudyus an chichay mantudtuchu, ad-adchuwan na takuy namatin Apu Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Chingngor pun na mamatid Jerusalem mipangkop ta namatiyan na foon à Judio, finaunchà Bernabe ad Antiokia. ");
INSERT INTO ksc_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ad na chummatngana, naragsak ta nangil-ana wi fininchisyunan Apudyus chicha. Ad sinorkagnà chicha ta iturturuychay mamati an Apu Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ad-adchuwan akon nitapi ta chachi mamati, tan mamfaruy takù Bernabe wi patkopatkonan Ispiritun Apudyus ya napigsa kon pammatina. ");
INSERT INTO ksc_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Sachi ad, ummoy à Bernabe inanap à Saulo ad Tarso. ");
INSERT INTO ksc_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Inchasana pun, nangulinchad Antiokia, ad nakatawoncha ta sachi. Niyamuamungcha ta chachi mamati, wi ad-adchuwan na takuy tinudtuchuwancha. Chachi mamatid Antiokia, chichan chamuy nangachanan à Cristiano. ");
INSERT INTO ksc_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Na sachi timpu, chummatong ad Antiokia na uchumi profetas wi narpud Jerusalem. ");
INSERT INTO ksc_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Na osa, wi nangachanan à Agabo, ummagsad ta naamungan chachi mamati, ad imfakanan intudtuchun na Ispiritun Apudyus an siya, wi maingki losan na ili ta luta. Ad tummuttuwan imfakana ta timpuy nanturayan Emperador Claudio. ");
INSERT INTO ksc_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Siyan chachi mamatid Antiokia, nantuturagcha ta ipaw-itchan fachangcha ta susunudchay mamatid Judea à patingkan na adchoncha. ");
INSERT INTO ksc_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ad finaunchà Bernabe ya Saulo ta awitonchan pilak wi fachangcha losan ta chachi mangipangpangu ta mamati ad Judea. ");
INSERT INTO ksc_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Na sachi koy timpu, illukin Ali wi Herod wi mamarpalikat ta uchumi mamatin Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Impasiwatnà Jaime wi sunud Juan. ");
INSERT INTO ksc_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Inakammuna pun wi naragsak na Judio ta iningwana, impatiliwna kò Pedro. Nàwan naniliwanchan Pedro ta timpun na fiyasta wi nanganancha ta tinapoy wi foon pù naraukan à mampafotar. ");
INSERT INTO ksc_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Natiliw pun à Pedro, imfarudchà siya wi nasawaranchà onom wi nanguwarcha, wi nasin-oppatcha wi nansinsinnukat. Tan na somsomò Herod, nu marpas na fiyasta, imfistikarona ta sangwanan na Judio. ");
INSERT INTO ksc_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Siyan nafarud à Pedro, ngim chachi mamatin Jesus, impapaticha illuwaruwan à siya. ");
INSERT INTO ksc_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Simsimmò Herod wi nu marpas na fiyasta iparawanà Pedro à mapatoy, ad na sachi lafi, nasusuyop à Pedro ta nangkawaan na chuway kuwarcha. Nakachilaan akò chuwa, ya iningkaw na uchumi kuwarcha ta liwangan na fafalluchan. ");
INSERT INTO ksc_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Na sachi, nammaag nasilawan na ingkawan Pedro ya impaila kon osay anghel Apudyus, ad inwokawognà Pedro wi namangon an siya, ad anana, “Kanasom! Fumangon-a!” Ad na sachi, naaan na kachilana. ");
INSERT INTO ksc_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ad anan na anghel, “Pagchotom na usarnu ya mansapatus-a.” Pintogna pun, anan akon sachi anghel, “Mangkunsur-a ko ad mitun-ud-an saon.” ");
INSERT INTO ksc_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Siyan nitun-ud à Pedro, ngim na somsomòna, anana pun nu foon pù tuttuwan iningwan na anghel, wi isù in-inopna. ");
INSERT INTO ksc_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Lin-usanchan nansùnub wi kuwarcha, ad chin-umanchan liwangan ta chingching. Ad nammaag naib-at, ad lummawacha. Nanadchadcharancha pun ta arsa, tinaynan na anghel à siya. ");
INSERT INTO ksc_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ad sachin nallìnaan Pedro wi tuttuwan nàwan siya, ad anana, “Tuttuway imfaun Apudyus na anghelnà manaraknib an saon, ta achi pu mituruy na pinanunut Herod ya achi pu màwan pion na Judion saon.” ");
INSERT INTO ksc_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Na manom-asom-ana ta sachi, ummoy ta foroycha Maria wi inan Juan Marcos. Achun taku wi naarus ta sachi wi mangiluwaru an siya. ");
INSERT INTO ksc_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nangkobkob ad à Pedro ta onob, ummoy na osay sanilu wi Roda na ngachanna innila nu sinun nangkobkob. ");
INSERT INTO ksc_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Illasinnan kingan Pedro, ad naragsak ta chummatngan Pedro, siyan nanodchà wi umoy mangifaka ta chachi naarus, wi anana, “Annat à Pedro ta sòfan!” Ngim achina pun inib-at na onob! ");
INSERT INTO ksc_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ad ananchan siya, “Tingangnu!” Ngim impapilit chi fafarasang anan wi tuttuway annat à Pedro. Ad anancha, “Anghel nin wi fantaynan innilam.” ");
INSERT INTO ksc_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ngim nangkobkokobkob à Pedro ta onob. Siyan ummoycha innila. Inib-atcha ad, nataagcha tan tuttuway Pedro. ");
INSERT INTO ksc_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ad impakinòna chicha, ad imfakanan mipangkop ta nangiparawaan Apudyus an siya ta fafalluchan. Ad anana ko, “Ifakayu kon Jaime ya uchumi susunudtau.” Sachi ad, tinaynanà chicha, ad lummayaw. ");
INSERT INTO ksc_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nafikat pun, nakulikur na chachi kuwarcha tan maid à Pedro. ");
INSERT INTO ksc_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ad à Herod, imfaunnà chicha ta anaponchà siya, ngim maid pun inchasancha. Siyan inimfistikar Herod na kuwarcha, achinaot papatoy chicha losan. Narpas pun na sachi, lummayaw à Herod ad Judea wi ummoy ad Cesarea. ");
INSERT INTO ksc_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Na iningkawan Herod ad Cesarea, naaliling-ot ta takud Tiro ya Sidon. Kapu ta ilin Herod na mangar-ancha ta anoncha, siyan som-osom-oncha nu sinun in-inonchay mamparagsak an siya. Sachi ad, inawischà Blasto à mamfurunchay umoy mampangpangngaasi an Herod ta mitimpuyug an chicha. À Blasto, siyan ap-apun na ingkaw ta foroy Herod. ");
INSERT INTO ksc_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Chummatong na osay padcha wi nampamitingan Herod ta taku. Nakasilup à silup na Ali, ad tummùchu ta nangatuy aachuyan, ad nan-ukud ta taku. ");
INSERT INTO ksc_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Narpas pun nan-ukud, nampaupauy na taku wi anancha, “Foon à takun annayay kumminga, tan siyan osay apudyus!” ");
INSERT INTO ksc_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kapu ta foon pun à Apudyus na impachayaw Herod, pinasakit na anghel Apudyus à siya. Sachi ad, kinìnanan korkor wi nangan ta long-agna, ad natoy. ");
INSERT INTO ksc_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ad niturturuy na ukud Apudyus nipagngor ta ailiili, ad ummachuachun mamati. ");
INSERT INTO ksc_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Narpas pun na iwaarcha Bernabe an Saulo ad Jerusalem, nangulinchad Antiok, ad nifurun akò Juan Marcos an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Na chachi mamati wi naamuamung ad Antiokia, iningkaw an chichan uchumi profetas ya uchumi mangitudtuchu ta ukud Apudyus. Anchanayan ngachancha: Bernabe, Simeon (wi Ngitit na ot-otanna), Lucio (wi iCirene), Manaen (wi inanà na aman Ali wi Herod ta afan-ogna), ya Saulo. ");
INSERT INTO ksc_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Na osay padcha, nallanganchay nangan ta awad wayachay malluwaru ya manchaychayaw an Apudyus. Ad iningkaw na imfakan na Ispiritun Apudyus an chicha. Anana, “Chutukanyu cha Bernabe an Saulo wi mangwa ta pàwà an chicha.” ");
INSERT INTO ksc_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Siyan asincha nalluwaru ya nallangancha koy nangan, achichaot ipatay na imacha ta chachi chuway nachutukan. Narpas pun na sachi, nifauncha. ");
INSERT INTO ksc_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Siyan lummigwatcha wi umoy ad Seleucia wi sachin nangifaunan na Ispiritun Apudyus an chicha. Chummatongcha pun ad Seleucia, namapurcha wi umoy ad Chipre, ad nifurun akò Juan Marcos wi fumachang an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Chummatongcha pun ad Salamina, wi osay ilid Chipre, ummoycha nan-attuattun ta chachi sinagogan na Judio mangitudtuchu mipangkop an Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kinagkagkaaycha losan na ilid Chipre ingkanà chummatongchad Pafo. Ad sinib-atchad Pafo na osay Judio wi mansasarumangka wi nangngachan à Bar-Jesus wi anana nuy siyan osay profeta. ");
INSERT INTO ksc_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Na sachi sinanprofeta, siyan osay furun Sergio Paulo wi fifinnachur ad Chipre. Chi fifinnachur, wi naraing, impaayagna cha Bernabe an Saulo tan pionay chongron na ukud Apudyus wi itudtudtuchucha. ");
INSERT INTO ksc_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ngim na sachi sinanprofeta wi Bar-Jesus, wi Elimas na ngachanna ta ukud wi Griego, kinuranà chicha ta nakaukuchancha ta fifinnachur tan pionay achi pun mamatin fifinnachur. ");
INSERT INTO ksc_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","À Saulo, wi nangngachan akò Pablo, nakarong-ag na Ispiritun Apudyus an siya. Immomoschoanà Elimas ");
INSERT INTO ksc_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ad anana, “Isum yakà Satan tan kuraom na losani mamfaru. Naraing-ay mallaslastug, ad siya padpachasom wi mamaliktad ta ukud Apudyus wi katuttuwaan à turtulli! ");
INSERT INTO ksc_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Siyan chusaon Apudyus à sia, ad makurap-a wi achim pu ilasin uray na init à apadchapadcha.” Sachi ad, nammaag nakurap à Elimas, wi isù natab-unan na atanà mangmangngitit wi funot, ad nan-apoap wi man-anap à mangipuyut an siya. ");
INSERT INTO ksc_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Innilan pun na fifinnachur na nàwa, namatin Apu Jesus, tan nataag ta itudtuchucha mipangkop an siya. ");
INSERT INTO ksc_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Sachi ad, à Saulo wi Pablo ya chachi fufurunna, tinaynanchad Pafo. Namapurcha wi umoy ad Perge wi sakupon Pamfilia. Ad summiyan à Juan Marcos ta sachi, ad nangulin ad Jerusalem. ");
INSERT INTO ksc_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ngim cha Pablo, inturturuycha wi umoy ta safali wi Antiokia wi sakupon Pisidia. Ad na Safachu wi iillongan na Judio, ummoycha ta sinagogan na Judio makaachar an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Nafasa pun na uchumi Lintog Moses ya inyug-is na uchumi profetas Apudyus ta awi, impaayag na mangipangpangu ta sachi sinagoga cha Pablo, anana, “Susunudni, nu awad itudtuchuyu ta anchanayay naurnung wi taku, ifakayu ta masorkagcha.” ");
INSERT INTO ksc_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Sachi ad, summiad à Pablo. Pinakinònan taku, ad illukinay man-ukud: “Susunud-uy Judio wi kanà Israel, ya chiayuy foon à Judio wi ummali makachaychayaw an Apudyus, chongronyuna! ");
INSERT INTO ksc_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","À Apudyus wi chaychayawontauy kanà Israel, siyan namili ta achakchakrantau ta awi à takuna. Na iningkawanchad Egipto wi foon pù sikuchi ilicha, Apudyus na fummachang an chicha ta umachucha, achinaot ipailan karobfongana ta nangilayawanan chicha ta sachi ili. ");
INSERT INTO ksc_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Na nangagkagkaayancha ta opatpuruy tawon ta sachi ikaw wi maid pu chanum, inanusana chicha ya finadngana kò chicha. ");
INSERT INTO ksc_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ad chummatongcha pun ad Canaan, inafakchan pituy nasyun, tan Apudyus na nangwa. Ad impain-uwanan sachi luta ta achakchakrantau. ");
INSERT INTO ksc_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ummoy à 450 wi tawon nanipud ta ummayanchad Egipto ingkana ta lukin na finumroyanchad Canaan. “Narpas pun na sachi, chinutukan Apudyus chachi papangat wi nansùnusùnub wi nanturay an chicha ingkana ta timpun Samuel wi profeta. ");
INSERT INTO ksc_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ad na iningkawan Samuel, nallilin achakchakrantau ta awad otyan alicha, siyan chinutukan Apudyus à Saulo wi anà Kis wi kanà Benjamin à man-alicha. Ad nan-alì Saulo ta opatpuruy tawon. ");
INSERT INTO ksc_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Sachi ad, inaan Apudyus à Saulo, ad chinutukanà David à man-alicha. Anan Apudyus, ‘Na annayay David wi anà Jesse, ay-ayatò à siya tan oyyoonan sinuy ifakà.’ ");
INSERT INTO ksc_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Impustan Apudyus wi, à tapin na padcha, miyanà na osay kanà David wi siyan manaraknib an chitauy kanà Israel. Ad ummali tuwan sachi kanà David, wi siyà Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Na chaan pun Jesus nallukiyan wi mantudtuchu, ummunà Juan wi nangipagngor an chitauy Judio wi masapur mamfafawitau ta fasfasurtau ad mampafunyag à mangipail-an ta namfafawiyantau. ");
INSERT INTO ksc_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nganngani pun marpas na fiyang Juan, imfakana ta taku, ‘Nu sinun mammammoanyun saon, foon à saon na impustan Apudyus wi umalì manaraknib ta taku, tan awad na misukat wi nangatngatu nu saon.’” ");
INSERT INTO ksc_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Inturuy Pablo wi nan-ukud, anana, “Susunud-uy kanà Abraham, ya chiayu koy foon à Judio, wi makachaychayaw akon Apudyus, chitau losan na nipaakammuwan na annayay chamag mipangkop ta masaraknifantau à makafiyakantaun Apudyus à ing-ingkana. ");
INSERT INTO ksc_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ngim chachi takud Jerusalem, ya uray chachi papangatcha, achicha pu akammu wi à Jesus na manaraknib an chitau, tan achicha pu naawatan na mifasafasa ta Sinafachu, wi inyug-is na profetas ta awi. Ngim tummuttuwan sachi niyug-is, tan pinatoychà Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Uray maid pun inchasanchà arwingan Jesus, impapilitchan Pilato impapatoy à siya. ");
INSERT INTO ksc_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ad limpascha pun iningwan losani niyug-is mipangkop an siya, inarachan lachagna ta kros ad illofoncha. ");
INSERT INTO ksc_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","“Ngim impaulin Apudyus à siya tinaku. ");
INSERT INTO ksc_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ad chachi nifurun an siya ta narpuwanchad Galilea wi ummoy ad Jerusalem, nampaipailà Jesus an chicha ta apadchapadcha. Ad na sana, chichan mangistiku ta takud Israel ta mipangkop an siya. ");
INSERT INTO ksc_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Ad sachin pangkop na ummaliyannid asna, ta ipaakammunin chiayun Mamfaruy Chamag mipangkop an Jesus: na impustan Apudyus ta achakchakrantauy Judio, nàwan chitau wi kanàcha, tan impaulin Apudyus à Jesus tinaku. Sachin anan na niyug-is ta niyagway Salmo, wi anana, ‘Sian anàu; sanan padchay mangipaakammuwà wi man-amata.’ ");
INSERT INTO ksc_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Awad akon niyug-is wi ukud Apudyus mipangkop ta ummuliyan Jesus natakuwan, ta achi marpos na long-agnà ing-ingkana, wi anana, ‘Adchò an chiayu chachi mamfaruy impustà an David, wi sikurachuy màwa.’ ");
INSERT INTO ksc_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ad na sachi impustana, mipangkop an Jesus. Awad akon osay inyug-is David wi mipangkop an Jesus, wi ananan Apudyus: ‘Foon pù iparufusnu wi marpos na long-ag-u, tan saon na chinutukam wi mangay-ayat an sia.’ ");
INSERT INTO ksc_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ngim à David, narpas pun na losani impàwan Apudyus an siya ta atattakuna, natoy. Ad nilofon ta liyangi nilobnan na aappuna, ad narpos na long-agna. ");
INSERT INTO ksc_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ngim à Jesus, foon pù marpos na long-agna tan impaulin Apudyus à siya tinaku. ");
INSERT INTO ksc_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Susunud, maawatanyu kuman anna: kapu ta iningwan Jesus, mafalin wi pakawanon Apudyus na fasurtau. Siyan aagkammuwonyuna, nu patiyonyù Jesus, aanonan fasuryu. Uray patkonyun Lintog Moses, foon pù sachin mangaan ta fasuryu. ");
INSERT INTO ksc_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Siyan am-ammaanyu, ta foon pu kumà màwan chiayun inyug-is chachi profetas wi ukud Apudyus, wi anancha, ");
INSERT INTO ksc_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘An-annachanyuy mallawing ta imfakan Apudyus! Tan awad na oyyoò ta sanay atattakuyù maschaawanyu ad siyan matayanyu! Tan uray misuplisuplikar an chiayu, foon pù tuttuwaonyu wi màwa!’” ");
INSERT INTO ksc_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Narpas pun à Pablo nan-ukud, lummawacha an Bernabe ta sinagoga, ad inimus na taku nu mafalini asincha mantudtuchu ta asini Safachu ta utupanchan intudtuchucha. ");
INSERT INTO ksc_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Lummayaw ad na taku ta sinagoga, ad-adchuwan na nitun-ud ancha Pablo an Bernabe, wi Judio na uchum, ya foon à Judio na uchum ngim tungparonchan Lintog na Judio. Nakaug-ugkudcha Pablon chicha ad sinorkagchà chicha ta ngongodngochanchay mamiyar ta kaasin Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Na asini Safachu, nganngani losan na takud Antiokia maarus ta chongronchan ukud Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ngim na nangil-an na achi pu mamati wi Judio ta chachi ad-adchuwani takuy naarus, amod na aposcha. Ad iissionchan inug-ugkud Pablo, ad ininsurtuchà siya. ");
INSERT INTO ksc_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ngim cha Pablo an Bernabe, tummurodchay man-ukud. Anancha, “Kattò masasapur wi mipagngor na ukud Apudyus an chiayuy Judio umuna. Ngim kapu ta achiyu pu patiyon, ya foon à mangwaanyun mannaynayuni fiyag, siyan man-awichannì chiayu ta ing-ani ta chachi foon à Judio mantudtuchun chicha. ");
INSERT INTO ksc_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tan annayan imfilin Apudyus an chiani, wi anana, ‘Chinutukà sià mallawag ta somsomò na foon à Judio, ta awad wayan na losani taku ta lufung wi masaraknifan mipakapun sia.’” ");
INSERT INTO ksc_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Chingngor pun na foon à Judio na imfakan Pablo, lummagsakcha, ad chinayawchà Apudyus kapu ta impakaawatchan ukudna. Ad losan chachi nachutukan wi makafiyag à ing-ingkana, namaticha. ");
INSERT INTO ksc_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ad nanchinchinnamag na mipangkop an Apu Jesus ta ailiili ta sachi luta. ");
INSERT INTO ksc_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ngim chachi Judio wi achi pu mamati, sinugsukanchan pangpangun na sachi ili, ya uray na fafaknangi fubfufai wi nanaychayaw an Apudyus, wi fooncha pù Judio. Ad illukicha palikatan cha Pablo an Bernabe. Ad imparyawcha kò chicha ta ilicha. ");
INSERT INTO ksc_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Sachi ad, pinùpuancha Pablo an Bernabe na kafu ta chapancha à mangakammuwan na taku ta ili ta mallawingancha ta chamag mipangkop an Jesus. Ad lummayawcha wi ummoy ad Iconio. ");
INSERT INTO ksc_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ngim chachi mamati ad Antiokia, naragsakcha ko kay tan inakammuchà Jesus, ad naatod akon karobfongan na Ispiritun Apudyus an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ad man-isun nàwan Pablo ya Bernabe ad Iconio. Chummatongcha pun ad Iconio, ummoycha ta sinagogan na Judio nantudtuchu. Ad ad-adchuwan na Judio ya foon à Judio wi namatin Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ngim na uchumi Judio wi foon pù mamati, sinugsukanchan uchumi foon à Judio, ad sachi kon lummawingan na somsomòcha ta chachi mamati. ");
INSERT INTO ksc_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Uray nu amaschin iningwacha, nafayagcha Pablo an Bernabe iningkaw ad Iconio, ya naturodchay mantudtuchu mipangkop an Apu Jesus. Ad innadchona kon chichan karobfonganchay mangwà kaskaschaaw, wi sachin mangil-an wi tuttuwan intudtuchucha mipangkop ta achakuna. ");
INSERT INTO ksc_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ngim nan-agwan taku ta sachi ili, tan na uchum, sinurutcha chachi Judio wi achi pu mamati, ad na uchum, sinurutchan apostoles. ");
INSERT INTO ksc_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Sachi ad, nantuturag chachi Judio ya pangpangucha, ya chachi foon à Judio, ad simsimmòchay palikatan cha Pablo an Bernabe ya chunuroncha kò chicha. ");
INSERT INTO ksc_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ngim chingngorcha Pablo na simsimmòcha, ad ummawidcha wi ummoy ad Listra ya Derbe, ya uchumi ili wi sinakup Licaonia, ");
INSERT INTO ksc_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ad inturturuychay mantudtuchu ta Mamfaruy Chamag mipangkop an Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Iningkaw ad Listra na osay larai wi napilay wi achi pu makachadcharan nanipud ta niyanaana. ");
INSERT INTO ksc_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Na tummutùchuwanay nanchochongngor ta intudtuchun Pablo, inakammun Pablo wi namatì siya, wi mafalini paimfakon Apudyus na pilayna. Ad intotollong Pablò siya, ");
INSERT INTO ksc_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ad chinakornan kingana, wi anana, “Sumiad-a!” Ad nasaniad na sachi napilay ad nanadcharan. ");
INSERT INTO ksc_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Na nangil-an chachi naarus ta iningwan Pablo, illukichay mampoaw ta sikuchi ukudcha, “Chichan apudyustau wi namfarfalin taku, ad nan-osogchan chitau.” ");
INSERT INTO ksc_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ad nginachanancha chichà ngachan na sinan-Apudyuscha. À Bernabe, anancha nuy Zeus à siya, ad à Pablo, anancha nuy Hermes à siya tan siyan kumminga. ");
INSERT INTO ksc_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Na temploy nanaychayawan na takun Zeus, iningkaw ta lasin na ili. Ad na pachicha, inchatongnan laki wi faka ya inar-arkusanchà sabsafung na liwangan na ili, tan pionchay chatunan cha Pablo an Bernabe tan anancha pun nu chichan apudyuscha. ");
INSERT INTO ksc_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ngim naawatan pun Pablo ya Bernabe wi sachin oyyoon na taku, kiniskissaychan silupcha ta ipailacha wi lawing na oyyoon na takun chicha. Ad nanodchàcha ko wi nangkawa ta naarus wi taku ad impoawcha anani, ");
INSERT INTO ksc_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Tamako ta amasnan oyyoonyu? Foon pù Apudyus-ani! Takuani kay, wi isun chiayu! Na pangkop na ummaliyannid asna, ipagngornin chiayu na Mamfaruy Chamag, ta man-awichanyun anchanayay sinan-Apudyusyu wi maid silficha, ta mansakung-ayu ta natatakuy Apudyus, wi siyan nangwa ta langit, luta, fayfay, ya losani ingkaw. ");
INSERT INTO ksc_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Na laus, imparufus Apudyus wi oyyoon na atakutakun sinumani piniyacha. ");
INSERT INTO ksc_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ngim iniingkaw na iningwana ta akammuwoncha kumà siya, tan impailanan kina-Apudyusna ta mamfaruy iningwanan chicha. Tan siyan mangipaali ta uchan ya apit ta tinawon; siyan mangatod à maan, ya siya kon mamparagsak an chiayu.” ");
INSERT INTO ksc_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ngim uray imfakanan sachi, pion na takuy ipartiyanchà chicha, ngim na anungusna, ingkimaun Pablò chicha. ");
INSERT INTO ksc_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Sachi ad, chummatong na uchumi Judio wi narpud Iconio, ya Antiokia wi sinakup Pisidia. Ad sinugsukanchan chachi takud Listra, siyan pinisongchà Pablo, ad kinuyudchà siya ta lasin na ili tan anancha pun nu natoy. ");
INSERT INTO ksc_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ngim inalium pun chachi mamatì Pablo, fummangon, ad nangulin ta ili. Ad nafikat pun, lummayawcha Pablo ya Bernabe wi ummoychad Derbe. ");
INSERT INTO ksc_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Chummatongcha pun ad Derbe, intudtuchucha kon Mamfaruy Chamag ta sachi ili, ya ad-adchuwan na namatin Jesus. Sachi ad, nangulinchad Listra, ya Iconio, achichaot umoy ad Antiokia wi sinakup Pisidia. ");
INSERT INTO ksc_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Impapigsachan mamati ta sachi ili, ya sinorkagcha ko chicha ta achicha man-awichan na pammaticha uray sinuy likat wi chumtong an chicha. Intudtuchucha kay, “Kapilitan wi mapalikatantau ta annay lufung, achitauwot mitapi ta Manturayan Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Na losani ili wi innoycha Pablo, nanchutukchà mangipangpangu ta chachi naarubfun wi mamati. Na nangadchancha ta fiyang na chachi mangipangpangu, nallanganchay nangan ad illuwaruwanchà chicha. Ad imfakacha wi à Apudyus wi piyaroncha, siyan mamachang an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Na sachi nangoyancha ta sakup Pisidia, chummatongchad Perga wi sinakup Pamfilia. ");
INSERT INTO ksc_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nantudtuchucha pun ad Perga, ummoycha kod Atalia, ");
INSERT INTO ksc_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ad namapurcha wi nangulin ad Antiokia wi sachin nalligwatancha. Tan chachi mamatid Antiokia, chichan nangifaun ancha Pablo. Na sachi timpu, illuwaruwanchà chicha ta mafadnganchay mangwa ta iwaar wi nipiyar an chicha, wi narpas ta sana. ");
INSERT INTO ksc_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Chummatongcha pun ad Antiokia, impaayagcha losan na mamati, ad inur-ullitchan losani iningwan Apudyus an chicha. Imfakacha ko wi innadchon Apudyus na wayan na foon à Judio ta mamaticha kon Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ad iningkawchà nafayag an chichay mamatid Antiokia. ");
INSERT INTO ksc_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Sachi ad, chummatong ad Antiokia na uchumi lallarai wi narpud Judea. Illukichay mantudtuchu ta chachi mamatid Antiokia, wi anancha, “Achiayu pu masaraknifan nu foon pù mamarkaan na long-agyuy lallarai, tan sachin niyug-is ta Lintog Moses ta awi, wi masasapur oyyoonyu.” ");
INSERT INTO ksc_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Kapu ta sachi intudtuchucha, nakasukobcha Pablo an Bernabe an chicha, siyan nifauncha Pablo ya Bernabe ya uchumi mamati ta umoychad Jerusalem imuson ta apostoles ya pangpangun na mamati mipangkop ta sachi intudtuchun chachi iJudea. ");
INSERT INTO ksc_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ad na lummausancha ta provinsiyad Fenicia ya Samaria, imfakafakachan mipangkop ta namatiyan na foon à Judio an Apudyus. Ad isag lummagsak losan na mamati ta sachi nangngorancha. ");
INSERT INTO ksc_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Chummatongcha pun ad Jerusalem, isag naragsak chachi mamati ya pangpangucha ya apostoles, wi nammangilin chicha. Ad inur-ullitcha Pablo na losani impàwan Apudyus an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ngim na uchumi mamati, wi tapin na Fariseo, anancha, “Masapur ipapilittau chachi foon pù sikuchi Judio wi mamatin Jesus, ta mamarkaan na long-agcha ya patkoncha kon Lintog Moses.” ");
INSERT INTO ksc_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Na apostoles ya mangipangpangu, nammimitingcha ta uukuchonchan sachi fanag. ");
INSERT INTO ksc_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nan-uukudcha pù nafayag, anan Pedro, “Susunud, akammuyu wi chinutukanà an Apudyus ta sin-arkawan à mangitudtuchu ta Mamfaruy Chamag ta takuy foon à Judio, ta mawayaanchay manchongor ta mamatichan Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ad à Apudyus, wi mangakammu ta somsomò na losani taku, impaakammuna wi mafalini mamati kon foon à Judio, tan innadchonan Ispiritunà makarong-ag akon chicha, wi isun na nangadchanan chitauy sikuchi Judio. ");
INSERT INTO ksc_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Foon pù mangkarasiyona chachi foon à Judio an chitauy Judio, tan isunay pinakawanna ko chicha ta namatiyanchan Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Siyan tayuko padpachason à Apudyus wi ipapilityu oyyoon na ukalitau? Tan uray na achakchakrantau ta awi, ya uray chitau ta sana, achitau pu makatungpar ta losani Lintog Moses. Ad apay palikatantau chachi foon à Judio wi anantauy masapur tungparoncha losan na sachi? ");
INSERT INTO ksc_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Lawing! Akammutau wi masaraknifantau mipakapu ta achakun Apu Jesus an chitauy namati, ad isuna kon chicha.” ");
INSERT INTO ksc_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Sachi ad, kumminò na takuy naaamung, ta chongronchan ur-ullitcha Bernabe an Pablo mipangkop ta kaskaschaaw wi impàwan Apudyus an chicha ta nantudtuchuwancha ta chachi foon à Judio. ");
INSERT INTO ksc_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Sachi ad, kummingà Jaime, anana, “Susunud, chongronyu ad! ");
INSERT INTO ksc_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Àisuplikar Pedro na mipangkop ta lukin na nampaakammuwan Apudyus ta achakuna ta takuy foon à Judio, ta awad ako mamatin siyà mantakuna. ");
INSERT INTO ksc_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Na sachi iningwan Apudyus, niyunud ta inyug-is na chachi profetas ta awi, wi anancha, ");
INSERT INTO ksc_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Anan Apudyus, mangulinà à tapin na padcha ta fangonò na manturayan David, wi nachachail, ta asin-u pafaruwon na manturayana. ");
INSERT INTO ksc_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Siyan na losani foon à Judio wi chinutukà à mantakù, mansakungchan saon. ");
INSERT INTO ksc_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Sachin impaakammun Apudyus ta awi!’” ");
INSERT INTO ksc_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ad inturuy Jaime wi man-ukud. Anana, “Siyan na somsomòu, achitau pu kuma alliwon na namatiyan chachi foon à Judio an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Uray isurattau kan filintaun chicha wi achicha pu anon na sinumani michatun ta sinan-Apudyus, tan paniyawchin chitauy Judio; ya achicha pu ko anon na chara winnu napsor wi animar wi achi pu nachara; ya achicha pu ko it-om na foon pù asawacha. ");
INSERT INTO ksc_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tan na losani Judio, akammuchan anchanayay lintog, tan nanipud ta awi, nifasafasan Lintog Moses ta losani sinagogatau ta Sinafachu, ya mitudtudtuchu kon ukudna ta ailiili.” ");
INSERT INTO ksc_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Siyan chachi apostoles ya mangipangpangu, ya losanchay mamati, chinutukanchan uchumi fufuruncha à mamrun ancha Pablo ya Bernabe wi mangulin ad Antiokia. Na chinutukancha, Judas wi Barsabas, ya Silas, wi chichan chuway mapatkan an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Amasnan insuratcha: “Susunudni wi foon à Judio ad asnati Antiokia, Siria, ya Cilicia, annayan suratnin chiayuy mamatin Jesus. À chiani wi apostoles ya mangipangpangu ta mamatid asnay Jerusalem, chianin nanurat an chiayu. ");
INSERT INTO ksc_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Chinamagni wi ummali nud asnat na uchumi iyasna wi ummoy mangalliw an chiayu ta itudtuchuchay safali. Ngim foon pù chianin nangifaun an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Siyan nammimiting-ani, ad chinutukannin ifaunnin chiayu. Mifuruncha Bernabe ya Pablo, wi fufurunni, ");
INSERT INTO ksc_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","wi nangisarcha ta fiyagcha ta nantudtuchuwancha mipangkop an Aputauy Jesu Cristu. ");
INSERT INTO ksc_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Na ifaunni, Judas an Silas, à chichan mangistiku ta annayay insuratni. ");
INSERT INTO ksc_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nakatimpuyug-ani ta Ispiritun Apudyus wi foon pù ipapilitni patungpar na lintogni, naraksig na anchanayay masapur tungparonyu: ");
INSERT INTO ksc_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","achiyu anon na sinumani nichatun ta sinan-Apudyus; ya achiyu anon na chara winnu napsor wi animar wi achi pu nachara; ya achiyu it-om na foon pù asawayu. Mamfaru nu anusanyuy patkon na anchanayay filin. Afuschì ifakanin chiayu.” ");
INSERT INTO ksc_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Sachi ad, impaligwatcha chachi opat, wi ummoy ad Antiokia. Chummatongcha pun, impaayagcha losan na mamati ad innadchonchan sachi surat ta fasaoncha. ");
INSERT INTO ksc_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Finasacha pun, lummagsakcha tan nasorkagcha ta sachi nisurat. ");
INSERT INTO ksc_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Cha Judas an Silas, wi naraing wi mangifaka ta ukud Apudyus, achu kon intudtuchuchà masorkakan na mamati à mampapigsa ta pammaticha. ");
INSERT INTO ksc_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Iningkawcha Judas ya Silas ad Antiokià apadchapadcha, ad finarfarun chachi mamati chicha impaligwat mangulinon ta chachi nangifaun an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ngim pion Silas wi mataynan. ");
INSERT INTO ksc_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ngim nataynancha Pablo an Bernabe ad Antiokia, ad iningkawchà nafayag nantudtuchu ya nangipagngor ta Mamfaruy Chamag mipangkop an Jesus. Ya achu kon fummachang an chichay nantudtuchu. ");
INSERT INTO ksc_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Naarkawanan ad, anan Pablo an Bernabe, “Inta ilan na susunudtauy mamati ta ailiili wi nangipagngoranta ta ukud Apudyus, ta akammuwonta nu sinun oy-oyyooncha.” ");
INSERT INTO ksc_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Na pion Bernabe, mifurun akò Juan Marcos an chicha, ");
INSERT INTO ksc_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ngim inisì Pablo, tan na iningkawanchad Pamfilia ta sin-arkawan, tinaynanà chicha, wi foon pù finadngana chicha ingkana ta narpasan na iwaarcha. ");
INSERT INTO ksc_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ad nansukobcha Pablo an Bernabe mipangkop ta sachi, ad nansiyancha. À Bernabe, inayakanà Juan Marcos ad namapurcha wi ummoy ad Chipre. ");
INSERT INTO ksc_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ngim à Pablo, inayakanà Silas à mamfurunna. Illuwaruwan na mamatì chicha ta fadngan Apu Jesus chicha ta sinuy umayancha. Ad lummigwatcha. ");
INSERT INTO ksc_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ad ummoycha ta uchumi ilid Siria ya Cilicia wi mangipapigsa ta pammatin na mamati. ");
INSERT INTO ksc_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ummoy ako cha Pablo ad Derbe ya Listra, ad inafotcha ta sachì Timoteo, wi osay mamatin Jesus. Judion inana, wi mamati ko, ngim Griego na amana wi foon pù Judio. ");
INSERT INTO ksc_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Losan chachi mamatid Listra ya Iconio, linispituchà Timoteo. ");
INSERT INTO ksc_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Piniyan Pablo wi mitun-ud à Timoteo à mamfurunna ta sinuy umayancha. Ngim na chokan Pablo wi Judio ta ailiili wi pionchay ayon, inakammucha wi foon à Judio na aman Timoteo, siyan minarkaan Pablò siya ta maid pu mallilin chicha mipangkop ta Lintog Moses. ");
INSERT INTO ksc_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Na nallausancha ta il-ili, imfakacha ta foon à Judio wi mamati na imfilin chachi apostoles ya mangipangpangu ta mamatid Jerusalem, ta tungparoncha otyan. ");
INSERT INTO ksc_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ad pummigsapigsan pammatin na taku ta ailiili, ad ummachuachu kon mamati ta finikat. ");
INSERT INTO ksc_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Innoycha Pablo na sakup Frigia ya sakup Galacia, tan achin pun na Ispiritun Apudyus pinarufusan na mantudtuchuwancha ta provinsiya wi Asia. ");
INSERT INTO ksc_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Chummatongcha pun ta pagpag na provinsiya wi Misia, pionchay umoy ta provinsiya wi Bitinia, ngim achin pun na Ispiritun Jesus pinarufusan chicha. ");
INSERT INTO ksc_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Siyan linausanchad Misia ad inchakuschad Troas. ");
INSERT INTO ksc_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Lummafi pun, iningkaw na impain-inop Apudyus an Pablo, ad innilanan osay larai wi iMacedonia wi ummaagsad nan-àarù wi anana, “Umaliayud asnay Macedonia ta fadngan chiani!” ");
INSERT INTO ksc_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Sachi ad, nansakanaani wi umoy ad Macedonia, tan inakammuni wi Macedonia na ustuy pion Apudyus wi mangipagngoranni ta Mamfaruy Chamag mipangkop an Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Namapur-ani wi tinaynannid Troas wi ummoy ad Samotracia. Nafikat pun, chummatong-anid Neapolis. ");
INSERT INTO ksc_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Nanchissaag-ani ta sachi, ad nanadcharan-ani wi ummoy ad Filipos, wi achakrani ili ta osay sakup Macedonia, wi na kaachuwani takuy ingkaw, iRoma, ya chichan turay. Ad foon pù nafayag na iningkawanni ta sachi ili. ");
INSERT INTO ksc_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Safachu pun, ummoy-ani ta tarantag na chawwang wi lasin na ili, tan chingngorni wi sachi nun luruwwaruwan na Judio. Ummachuy-ani ta tarantag ad nakaug-ugkud-ani ta fubfufai wi naaamung. ");
INSERT INTO ksc_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Na osay nanchochongngor an chiani, Lydia wi iTiatira wi na iwaarna, mallarakù nanginay mancharaag wi luput. Uray foon à Judio à siya, nanchaychayaw an Apudyus. Ad na nangitudtuchuwan Pablo, impakaawat Apudyus an siyan mipangkop an Jesus, siyan pinatina. ");
INSERT INTO ksc_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Sachi ad nafunyakancha Lydia wi simfaryan. Ad inimfitarnà chiani, wi anana, “Nu tuttuwaonyu wi kattoà namati an Apu Jesus, intaud foroyni ta ingkaw-ayu ingkanà lumayawanyu.” Ad impapilitna, siyan ummoy-ani. ");
INSERT INTO ksc_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Na osay padcha wi ummayanni ta luruwwaruwan, inafotnin osay fafarasang wi sanilu, wi man-aafatug, tan nakafarfaray. Achun pilak wi adchoadchona ta ngin-uwan siya wi tangchan na man-afatukana. ");
INSERT INTO ksc_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nituntun-ud à siya an chianin Pablo, ad nampoapoaw, “Na anchanayay taku, siya iwaiwaaronchan pàwan na Angatuwan wi Apudyus an chicha! Itudtudtuchuchan masaraknifanyu!” ");
INSERT INTO ksc_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Iningwanan amaschi ta apadchapadcha ingkanà ummog-ot à Pablo. Ad nansakung an siya, ad anana ta farfaray na fafarasang, “Ta ngachan Jesu Cristu, ifakà an sia, lumayaw-a!” Ad chakusi lummayaw na aran. ");
INSERT INTO ksc_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Inakammun pun na ngin-uwan siya wi maid asincha mangar-an à pilak tan lummayaw na farfarayna, chinòmaanchà Pablo an Silas, ad kinuykuychà chicha ta iyoycha ta ingkawan na turay na ili. ");
INSERT INTO ksc_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Impasanguchà chicha ta chachi iRoma wi kuis, ad incharumcha, “Na anchanayay Judio, mangmangwachà makuruwan na ilitau, ");
INSERT INTO ksc_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","tan na itudtudtuchucha, kumassaw ta lintogtauy iRoma. Ad foon pù mafalin wi surutontaun achawiyanchay safali.” ");
INSERT INTO ksc_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ad na losani takuy naarus manchongor, ummog-otchan Pablo ya Silas. Sachi ad, kinissay chachi kuis na silupcha Pablo ya Silas, ad impaabchoychà chicha. ");
INSERT INTO ksc_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Narpas ad wi amod na inyàabchoychan chicha, impaifarudcha. Ad imfakacha ta kuwarchacha ta narmanay manguwarchan chicha. ");
INSERT INTO ksc_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Siyan inyoy na kuwarchà chicha ta kuwartuy nangukuk ta fafalluchan, ad innigkanan ikicha ta naafutani ayuy chagsonan, ta achicha pu makaawid. ");
INSERT INTO ksc_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kawan pun na lafi, nalluwaruwarucha Pablo ya Silas, ya nangkankantachan Apudyus, ad na uchumi farud chochongronchà chicha. ");
INSERT INTO ksc_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Sachi ad, nanità napigsa wi nanyugyugkayug na fafalluchan, ad nammaag naib-at losan na onob, ad naaan losan na kachilan na farud. ");
INSERT INTO ksc_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Fummangon pun na kuwarcha, innilanay naib-at losan na onob na fafalluchan, ad anana pun nu ummawid losan na farud. Siyan linùpusnan sablina ta patoyonan long-agna. ");
INSERT INTO ksc_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ngim nampoaw à Pablo, “Achim patoyon na long-agnu, tan maid pu ummawid! Wachawad-ani!” ");
INSERT INTO ksc_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Sachi ad, nampaiyalin kuwarchà silaw. Ad kinankanasnay linumnò ta ikawcha Pablo ad namaypayogpoki nampalintumong ta sangwanancha. ");
INSERT INTO ksc_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ad imparawanà chicha, ad inimusnan chicha, “Apu, sinun oyyoò ta masaraknifanà?” ");
INSERT INTO ksc_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Summongfatcha, “Patiyom yakà Apu Jesus, siyan masaraknifam, ya uray akon faryannu.” ");
INSERT INTO ksc_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Sachi ad, intudtuchuchan ukud Apudyus an siya ya losani nakaaforoy. ");
INSERT INTO ksc_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Na sachi ko, pinunasan na kuwarchan sukatcha. Ad narpas pun na sachi, finunyakancha Pablo chichay simfaryan. ");
INSERT INTO ksc_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Sachi ad, inayakana cha Pablo an Silas ta umoycha mangan ad foroycha. Ad naragsakcha losan wi simfaryan kapu ta namatiyanchan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Nafikat pun, namfaun na kuis à pupulis ta umoycha iparufus cha Pablo ta fafalluchan. ");
INSERT INTO ksc_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Siyan imfakan na kuwarcha an Pablo, “Imfakan chachi kuis wi mafalin anuy miparufus-ayun Silas. Siyan man-agkaaw-ayu lumayaw.” ");
INSERT INTO ksc_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ngim anan Pablo ta pupulis, “Maid pu inchasanchà fasurni, ngim impaabchoychà chiani ta sangwanan na ad-adchuwani taku. Ad impaifarudcha kò chiani. Ad na sana, pionchay man-agkaawon iparufus à chiani! Achi pu màwa! Ikadcha kay umali mangiparufus an chiani, ta losan na taku akammuwon na iningwacha, tan uray Judio-ani, Romano-ani ko!” ");
INSERT INTO ksc_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Sachi ad, nangulin na pupulis ta chachi kuis wi nangifaka ta impaifakacha Pablo. Ad na nangngoran chachi kuis wi Romanocha Pablo an Silas, ummogyatcha. ");
INSERT INTO ksc_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Siyan ummoycha nampangpangngaasin chicha, ad illawachà chicha ta fafalluchan, ad imfakacha ta taynanchan ili. ");
INSERT INTO ksc_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Tinaynan pun cha Pablo an Silas na fafalluchan, ummoycha ta foroy Lydia, ad nakaug-ugkudcha ta chachi mamati wi naarus, ta sorkakoncha chicha. Limpascha pun na sachi, lummayawcha. ");
INSERT INTO ksc_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Innoycha Pablo an Silas ad Amfipolis ya Apolonia, ad nichaumchad Tesalonica wi awachan na osay sinagogan na Judio. ");
INSERT INTO ksc_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ad ummoy à Pablo nantudtuchu mipangkop ta ukud Apudyus, tan sachin sikuchi oy-oyyoona. Ta unog na turuy Safachu nakachischiskas à Pablo ta chachi taku ");
INSERT INTO ksc_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","wi mamfasarfasar ta niyug-is wi ukud Apudyus ta mangisuplikarana wi masapur mapalikatan ya mapatoy na Cristu wi impustan Apudyus wi umali, ad umuli ko mataku. “À Jesus wi ug-ugkuchò,” anan Pablo, “siyan Cristu wi imfaun Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Na uchumi Judio wi nanchongor, namaticha, wi nitipuncha ancha Pablo an Silas, ad namati kon uchumi mamangpanguwon na fubfufai ta sachi ili, ya ad-adchuwani Griego wi nanchaychayaw an Apudyus uray fooncha pù sikud wi Judio. ");
INSERT INTO ksc_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ngim chachi Judio wi achi pu mamati, naaposcha, siyan inaruschan lawingi takuy fufullakfor ta kuruwonchan ili. Ad inchukuschan onob na foroy Jason tan pionchay iparawa cha Pablo an Silas, ta iyoycha ta sangwanan na taku. ");
INSERT INTO ksc_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ngim maid inchasancha, siyan kinuykuychà Jason ya uchumi mamati ad inyoycha ta kukunsisar na ili. Ad ananchay nampoaw, “Anchanayan takuy nangkurukuru ta ailiili, ad anchanay chummatong ad asna. ");
INSERT INTO ksc_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ad na annayay Jason na nammangilin chicha. Losancha linabsing na lintog na Emperadortau, tan ifakafakachay awad anun safali wi ali, wi mangngachan à Jesus.” ");
INSERT INTO ksc_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Chingngor pun na kukunsisar ya naaarus wi taku na impafasurcha, isagcha nachanakan. ");
INSERT INTO ksc_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ad namfayachon na kukunsisar cha Jason ya fufurunnay mamati, ad imparyawcha chicha. ");
INSERT INTO ksc_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Mummaschom pun, pin-oy na chachi mamati cha Pablo an Silas ad Berea. Chummatongcha pun, ummoycha ta sinagogan na Judio. ");
INSERT INTO ksc_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Na taku ta sachi, un-unnoycha nu chachi Judio ad Tesalonica, tan pioncha isag chongron na chamag mipangkop an Jesus, ad finasafasachan niyug-is wi ukud Apudyus ta finikat ta ilancha nu tuttuwan intudtuchun Pablo. ");
INSERT INTO ksc_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ad ad-adchuwanchay namati, wi nitapi kon achuy lallarai ya mamangpanguwon na fubfufai wi foon pù Judio. ");
INSERT INTO ksc_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ngim chingngor pun na Judio ad Tesalonica na nangitudtuchuwan Pablo ta ukud Apudyus ad Berea, ummoycha sinugsukan na taku ta lawingonchà Pablo. ");
INSERT INTO ksc_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Siyan na mamatid Berea, pin-oychà Pablo ta ikid na fayfay. Ngim nataynancha Silas an Timoteo ad Berea. ");
INSERT INTO ksc_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Na lallarai, wi ummoy nangiturud an Pablo ingkanad Atenas, nangulinchad Berea ta ifakachan filin Pablo an Silas ya Timoteo ta kanasonchay umun-unud an Pablo ad Atenas. ");
INSERT INTO ksc_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Na nan-uullayan Pablo ancha Silas ya Timoteo ad Atenas, lummawing na somsomòna ta nangil-ana ta achuy sinan-Apudyus ta sachi ili. ");
INSERT INTO ksc_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Siyan ummoy ta sinagogan na Judio nakaug-ugkud an chicha ya uchumi foon à Judio wi nanaychayaw an Apudyus. Ummoy ako ta market ta afigkafigkat nantudtuchu ta sinumani ummoy manchongor an siya. ");
INSERT INTO ksc_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Iningkaw akon uchumi nangitudtuchu wi naakammuwan à Epicureo ya Estoico wi nakais-isì akon siya. Na uchum, nan-ag-akitùtùcha, “Sinu kon ug-ugkuchon na sanati mamadpachayaw?” Ad summongfat na uchum, “Ug-ugkuchona nin na adchatuy apudyus!” Amaschin imfakacha tan intudtudtuchun Pablo mipangkop an Jesus ya umuliyan matakuwan. ");
INSERT INTO ksc_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Siyan inayakanchà Pablo ad inyoycha ta sangwanan na mamangpanguwon na ili, wi ananchay Areopago, ad ananchan Pablo, “Pionni wi akammuwon na adchatuy itudtuchum, ");
INSERT INTO ksc_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","tan na uchum ta ug-ugkuchom, maid pu chingngorni à isun na amaschi! Ad pionni kuma wi maawatan na sachi.” ");
INSERT INTO ksc_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Amaschin imfakacha, tan losan na takuy iyAtenas, ya uray na nakaumili an chicha, pipionchay ukuukuchon ya chochongron na sinumani adchatu.) ");
INSERT INTO ksc_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Sachi ad, ummagsad à Pablo ta sangwanan na mamangpanguwon na ili, ad anana, “Chiayuy iyAtenas, mailà wi ipapatiyuy manaychayaw ta apudyusyu wi achu, ");
INSERT INTO ksc_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","tan na ummawaà ta iliyu, nantollongà ta chachayyawanyu na nangkarakarasi wi apudyusyu, ad innilà akon osay altar wi niyug-isan na ukud, ‘À Para Ta Apudyus Wi Chaan Pù Maakammuwan.’ Na sachi chaychayawonyu wi chaanyu pù akammuwon, siyan ipaakammù an chiayu ta sana. ");
INSERT INTO ksc_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Siyan Apudyus wi nangwa ta lufung ya losani ingkaw. Ngim foon pù fumroy ta templo wi ingwan na taku, tan siyan Apu ad langit ya asnay luta. ");
INSERT INTO ksc_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Maid pu kurang an siya, ad foon pù mafalini fadngan na takù siya, tan siyan marpuwan na asinchuwan, ya siyan mangatod ta losani masapurtau, ya angostau, ya mafiyakantau. ");
INSERT INTO ksc_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Nangwà Apudyus à osà taku ta chamu, ad siyan narpuwan na atakutaku ad asnay luta. Insakasakanan ustuustuy manturayan na sinuy turay ya ustuy ingkawancha. ");
INSERT INTO ksc_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Iningwanan taku ta somsom-onchà siya, ta anaponcha kuman mangakammuwanchan siya. Tan foon pù achayù Apudyus an chitau. ");
INSERT INTO ksc_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Tan iningkaw na osay mangwanani, ‘Losani matakuwantau ya oyyoontau, narpun siya.’ Iningkaw akon inyug-is na uchumi asintatakuyuy naraing, wi anancha, ‘Anà chitau kon Apudyus.’ ");
INSERT INTO ksc_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Siyan kapu ta anà chitaun Apudyus, foon pu kumà iyisutaun kina-Apudyusna ta kinaapudyus na anchanayay sinan-Apudyus wi falituk winnu pilak winnu fatu wi iningwan na naraingi taku. ");
INSERT INTO ksc_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ingkana ta sana, inanusan Apudyus na lawing wi ining-ingwan na taku, tan chaancha pù akammuwon à siya. Ngim na sana, imfakana wi ifafawin na takun losani fasurcha. ");
INSERT INTO ksc_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Tan chumtong na padchay makuisan na losani taku ta luta, tan chinuchuttukan Apudyus na osay nalimpiw wi kuis wi manguis an chitau, ad illausna impaakammu wi siyan chinutukana tan impaulina tinakù siya!” ");
INSERT INTO ksc_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Na nangngorancha ta inukud Pablo mipangkop ta osay natoy wi taku wi ummuli nataku, inam-amang na uchum à siya, ngim na uchum, anancha, “Pionni wi asin chongron na annay ukuchom.” ");
INSERT INTO ksc_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Sachi ad, tinaynanan sachi amung. ");
INSERT INTO ksc_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ngim nitun-ud an siyan uchumi maryad wi mamati an Jesus. Na osa, Dionisio wi osay mimbrun na nangatuy upisyar wi nangachanan à Areopago; ad na osa, osay fufai wi Damaris na ngachanna; ya iningkaw akon uchum. ");
INSERT INTO ksc_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Sachi ad, tinaynan Pablo ad Atenas ad ummoy ad Corinto. ");
INSERT INTO ksc_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Inafotna ta sachì Akila wi Judio wi niyanà ad Ponto. Na asawana, Priscila. Finumroychay man-asawa ad Roma ta sin-arkawan, ngim illintog Emperador Claudio wi lumayaw na losani Judio ad Roma, siyan lummayawcha Akila ad Italia wi ummoy ad Corinto. Na sachi, finisitan Pablò chicha. ");
INSERT INTO ksc_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Niyaspur wi mamangwà kamfas cha Akila, siyan kapu ta sachi kon iwaar Pablo, iningkaw akon chicha wi makaiwaar. ");
INSERT INTO ksc_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ad ummoummoy à Pablo ta sinagogan na Judio ta Sinafachu mangaw-awis ta chachi Judio ya foon à Judio ta mamaticha kuman Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Chummatong pun cha Silas an Timoteo ad Corinto wi narpuchad Macedonia, illukin Pablo wi mantudtuchu ta finikat. Tinistitistikuwana ta Judio wi tuttuway Jesus na Cristu wi impustan Apudyus wi umali. ");
INSERT INTO ksc_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ngim kinurachà siya ya nan-ukudchà lawing an siya, siyan yinagyagnan silupna ta ipailana wi achina pu asin tudtuchuwan chicha, ad anana, “Nu chusaon Apudyus chiayu, ikadyu kay! Maid pu fiyang-u! Manipud ta sana, inyà tudtuchuwan na foon à Judio!” ");
INSERT INTO ksc_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Sachi ad, tinaynan Pablo chicha wi nan-atun ta foroy na osay foon à Judio, wi Ticio Justo na ngachanna, wi nichar-ag ta sinagogan na Judio. Ticio Justo kon osay manchaychayaw an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","À Crispo wi mangipangpangu ta sinagogan na Judio, namatichay simfaryan an Apu Jesus. Ad namati kon ad-adchuwani iCorinto ta nangngorancha ta intudtuchun Pablo, ad nampafunyagcha losan. ");
INSERT INTO ksc_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Na sillafiyan, inin-inop Pablo wi anan Apu Jesus an siya, “Achia umogyat ta anchanay taku. Ituruynu wi mantudtuchu mipangkop an saon. ");
INSERT INTO ksc_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Maid pu mangan-anun sia, tan awachà an sia, ya ad-adchuwan akon takud asna wi chinutukà à mantakù.” ");
INSERT INTO ksc_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Siyan iningkaw à Pablo ta sachi ili à sintawon ya kogwa wi intudtuchunan ukud Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Na namfinnachuran Galion ad Acaya, nantitimpuyug na Judio wi achi pu mamati, ad ummoycha incharum à Pablo. ");
INSERT INTO ksc_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Anancha, “Na annayay taku, sumupling ta lintog, tan awiawisonan taku ta obsonchan pinagchayawchan Apudyus!” ");
INSERT INTO ksc_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Nganngani pun kumingà Pablo, nakaningà Galion. Anana ta Judio, “Nu awad fasurna winnu lawing à iningwana, anusà chongron na charumyuy Judio. ");
INSERT INTO ksc_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ngim kapu ta is-isì yakan mipangkop ta mining na uchumi ukud, ya ngadngachan na taku, ya lintogyu, ikadyu kay, tan maid pu fiyang-u!” ");
INSERT INTO ksc_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ad imparyawna chicha ta kurti. ");
INSERT INTO ksc_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Sachi ad, na foon à Judio wi nangiila, chinòmaanchà Sostenes wi mangipangpangu ta sinagogan na Judio, ad inabchoychà siya ta paway na kurti, ngim foon à namfiyangan Galion. ");
INSERT INTO ksc_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Nafayag pù Pablo ad Corinto, tinaynanan chachi mamati ad ummoy ad Cencrea, ad nifurun akò Akila an Priscila. Chummatongcha pun, nampapukis à Pablo ta mangipail-ana wi narpas na impustanan Apudyus. Narpas pun na sachi, namapurcha wi ummoy ad Siria. ");
INSERT INTO ksc_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ad chin-umanchad Efeso wi nanaynanan Akila an Priscila. Ad ummoy à Pablo ta sinagogan na Judio nantudtuchu. ");
INSERT INTO ksc_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ad pionchay tawichan à Pablo, ngim ummisì. ");
INSERT INTO ksc_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ad anana, “Nu iparufus Apudyus, mangulinà.” Ad namapur wi lummayaw ad Efeso. ");
INSERT INTO ksc_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Chummatong pun ad Cesarea, nanadcharan ummoy ad Jerusalem ta umoyna fisitaon na chachi mamati, ad nangaw-as ad Antiokia. ");
INSERT INTO ksc_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Foon pù nafayag na iningkawana ta sachi, ad lummigwat ako wi ummoy ta ailiili wi sinakup Galacia ya Frigia nantudtuchu ya nansorkag ta losani mamati. ");
INSERT INTO ksc_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Na sachi timpu, chummatong ad Efeso na osay Judio wi narpud Alejandria. À Apolos na ngachanna. Naraing à siyay mantudtuchu ya achun inakammuna wi mipangkop ta niyug-is wi ukud Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Nakakoti mantudtuchu mipangkop an Apu Jesus, ya katuttuwaan na intudtuchuna, tan siyan nitudtuchun siya ta chamu. Ngim afus na inacharnan Juan à itudtuchuna ta namfunyakana ta taku. ");
INSERT INTO ksc_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ummoy à Apolos ta sinagogan na Judio, ad naturod à siyay mantudtuchu. Chingngor pun cha Akila an Priscila à siya, inayakanchà siya ad foroycha, ad ninarmanchay nangisuplikar an siya ta chaanna pù akammuwon na mipangkop an Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Sachi ad, simsimmò Apolos wi umoy ad Acaya, siyan inapufaran na mamatì siya, ad sinuratanchan mamati ad Acaya ta mangiliyonchà siya. Na chummatngana, chakor na fachangna ta chachi namati kapu ta kaasin Apudyus an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Kapu ta naraing wi makais-isì ta Judio, inafaknà chicha ta sangwanan na taku. Inusarnan niyug-is wi ukud Apudyus ta nangipaakammuwana wi Jesus na Cristu wi impustan Apudyus wi umali. ");
INSERT INTO ksc_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Na iningkawan Apolos at Corinto, nangoy à Pablo ta filig wi ummoy ad Efeso. Chummatong pun, inchasanan uchumi mamati. ");
INSERT INTO ksc_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Inimusnan chicha, “Nakarong-ag na Ispiritun Apudyus an chiayu ta namatiyanyu?” Ad summongfatcha anani, “Maid chingchingngornì awad Ispiritun Apudyus.” ");
INSERT INTO ksc_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ad inimus Pablo, “Nu amasnat, in-inon na nafunyakanyu?” Ad summongfatcha, “Nafunyakan-ani ta funyag Juan ta namatiyanni ta intudtuchuna.” ");
INSERT INTO ksc_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Sachi ad insuplikar Pablo, wi anana, “Na funyag Juan, siyan nangipail-an na takuy namfafawicha ta fasurcha ya nafaliwan na somsomòcha. Ngim intudtuchuna wi masapur patiyoncha kon misukat an siya, wi Jesus.” ");
INSERT INTO ksc_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Chingngorcha pun na insuplikar Pablo, asincha nampafunyag à mangipail-ancha wi namatichan Apu Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Sachi ad impatay Pablo na imanan chicha, ad nakarong-ag na Ispiritun Apudyus an chicha. Sachi ad, nan-ukudchà foon pù sikud wi ukudcha, ad inukudcha kon impaspasmò Apudyus an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Umoychà nasawaran à chuway lallarai. ");
INSERT INTO ksc_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Na turuy furan, ummoummoy à Pablo ta sinagogan na Judio nantudtudtuchu. Naturod à siya wi nanongfat ya mantudtuchu ta taku à mangawisanan chicha mipangkop ta Manturayan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ngim natangkin na uchum wi achicha pun patiyon, ad pinarparwingchan mitudtuchu mipangkop an Jesus ta sangwanan na losani naamung. Siyan tinaynan Pablo chicha, ad inayakana chachi mamatin Jesus. Ummoycha ta uswilaan Tirano, ad sachin nantudtuchuwan Pablo ta taku ta finikat ");
INSERT INTO ksc_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ingkanà lummaus na chuway tawon. Siyan losan na taku ta provinsiya wi Asia, uray Judio ya foon, chingngorchan chamag mipangkop an Apu Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ad-adchuwan na kaskaschaaw wi impàwan Apudyus an Pablo, ");
INSERT INTO ksc_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","tan uray pangyu winnu luput wi inyusarna, nu inyoy na uchum ta nasakit ya nakafarfaray, ummimfagcha ya lummayaw akon farfaraycha. ");
INSERT INTO ksc_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ngim iningkaw na uchumi Judio wi nangkagkagkaay wi nangiparyaw anu ta aran wi farfaray na taku. Ad impadpachascha ko usaron na ngachan Apu Jesus ta paryawonchan aran. Anancha ta aran, “Siay aran, kapu ta karobfongan na ngachan Jesus wi itudtuchun Pablo, lumayaw-a!” ");
INSERT INTO ksc_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Na uchumi nangwa ta amaschi, pituy lallarai wi anà Sceva, wi siyan osay pangpangun na papachin na Judio. ");
INSERT INTO ksc_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ngim na namingsan, summongfat na osay aran an chicha, wi anana, “À Jesus, akammù, ya uray Pablo, ngim maid pu akammù an chiayu!” ");
INSERT INTO ksc_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Sachi ad, na larai wi nakafarfaray ta sachi aran, chinòmaana chichay pitu, ad nakapatoy an chicha ingkanà inafakna chicha. Ad ummawidchay naamin nasukatan wi nakiskissay na luputcha. ");
INSERT INTO ksc_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Na nangngoran na losani takud Efeso ta sachi nàwa, uray Judio ya foon à Judio, naam-amodcha ummogyat ad chinayawchan ngachan Apu Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ad kapu ta sachi, ad-adchuwan na mamati wi nangipudnu wi namfafawicha ta sangwanan na fufuruncha ta lawingi ining-ingwacha. ");
INSERT INTO ksc_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ad na uchum, wi nansasarumangka ko, inaruschan nibruchay sarumangka ad singkobcha ta sangwanan na taku. Na nginan na nibruchay singkobcha, ummoy à limampuruy lifu ta pilakcha. ");
INSERT INTO ksc_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kapu ta chachi losani nànàwa, nanchinchinnamag na mipangkop an Apu Jesus ya karobfongana, siyan ummachuachu kon mamati. ");
INSERT INTO ksc_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Narpas pun na sachi, simsimmò Pablo wi mangoy ta provinsiyay Macedonia ya Acaya wi umoy ad Jerusalem. Anana, “Nu chumatongà ad Jerusalem, ituruy-uy umoy ad Roma.” ");
INSERT INTO ksc_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Sachi ad, impaunanad Macedonia na chuway mamadfachang an siya, wi cha Timoteo an Erasto, ad nataynan à Pablo ta sachi provinsiya wi Asia, wi sachin awachan Efeso. ");
INSERT INTO ksc_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Na sachi koy timpu, iningkaw ad Efeso na kaog-ogyati kuru mipangkop ta pammatin na mamatin Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Amasnan nàwaana: Iningkaw na osay larai wi Demetrio na ngachanna. Na iwaar Demetrio, mampapanchay à pilak à sinantemplon na osay apudyuscha wi fufai nu, wi Artemis anun ngachanna. Inyusar na taku chachi sinantemplo à manaychayawancha ta sachi sinan-Apudyuscha. Siyan achun lakansiyacha Demetrio ya chachi mallabfuwona. ");
INSERT INTO ksc_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Siyan nampamiting à Demetrio ta chachi mallabfuwona ya uchumi mampapanchay, ad ananan chicha, “Fufurun-u, akammuyu wi na annayay iwaartau, siyan fummaknangantau. ");
INSERT INTO ksc_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ad ta sana, iniilatau ya chichingngortaun iningwan na annay taku wi Pablo. Ad itudtudtuchuna ta taku wi sinumani apudyus wi ingwan na taku, foon pu nù tuttuway Apudyus. Ad maila wi naawis na achud asnay Efeso ya ad-adchuwani ili ta provinsiyay Asia. ");
INSERT INTO ksc_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Siyan masapur tatanchaakantau tan awni ad maamsiw na annay iwaartau, ad maid pu mangngina. Ad foon pu kà afuschi, tan mamfalini maid silfin na templon na achayawani apudyustau wi Artemis. Ad mifafa kon kinasasaadna, wi siyan chaychayawon losan na taku ta annay provinsiya wi Asia ya uray na losani lufung!” ");
INSERT INTO ksc_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Chingngorcha pun na sachi imfakana, naaliling-otcha, ad asipapauycha, wi ananchay, “Achayawan à Artemis wi apudyustaud asnay Efeso!” ");
INSERT INTO ksc_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Sachi ad, niwaras na kuru ta sachi ili. Ad chinòmaancha cha Gayo an Aristarco wi nifurun an Pablo, wi narpuchad Macedonia. Ad intodtodchàchà chicha ta parasa wi naarusan na taku. ");
INSERT INTO ksc_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Piniyan Pablo wi umoy ta sangwanan na taku, ngim inyachin na mamatì siya. ");
INSERT INTO ksc_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Uray na uchumi mamangpanguwon na provinsiya, wi fufurun Pablo, ummifaunchà mangifakan siya ta achi pu mampaila ta parasa. ");
INSERT INTO ksc_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ad na sachi, amod na ngonot wi maid aag-agngorana tan na kaachuwan an chicha, foon pù akammuchan pangkop na naarusancha. ");
INSERT INTO ksc_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Siyan na uchumi Judio, impasanguchà Alejandro wi osay furuncha ta isuplikarna ta taku, tan ummogyatchà pafasuron na takù chichay Judio mipangkop ta sachi kuru. Ad impachas Alejandro wi pakin-on na taku, ta mafalini man-ukud, ");
INSERT INTO ksc_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ngim immatunancha pun wi Judiò siya, asipopoawcha, “Achayawan à Artemis wi apudyustaud asnay Efeso!” Ad amaschin inip-ip-awcha ta unog na chuway uras. ");
INSERT INTO ksc_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Na anungusna, nampailan mayor na ili. Impakinòna pun à chicha, anana, “Kailiyà wi iyEfeso, awad lawa takù foon pù nangaagkammu wi chitauy iyEfeso na mamangchon ta templon na achayawani Artemis ya nasantuwani fatu wi naodchag narpud langit? ");
INSERT INTO ksc_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Maid pu osà makaifaka wi foon pù tuttuwana, isunga kuminòtau ta maid pu mangàaway. ");
INSERT INTO ksc_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Na anchanayay chuwa wi inyaliyud asna, maid inakawcha ta templotau, ya maid pu ko imfakachà lawing mipangkop ta apudyustau. ");
INSERT INTO ksc_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ngim nu mampangpangnù Demetrio ya chachi fufurunnà makafasuran na osay taku, awad na kuistau ya pangpangutau ta pisinacha, siyan ikadchay mangicharum an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ngim nu awad safalì ifakayu, urayonyu, ta ukuchontau ta ustuy man-ar-arusanni wi pangpanguyu. ");
INSERT INTO ksc_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Tan machanakanà, tan nu pafasuron chitau ta chachi papangattaud Roma mipangkop ta nàwad kanad wi kuruyu, sinun ustù ilasuntaun chicha, tan maid pun!” ");
INSERT INTO ksc_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Imfakana ad na sachi, finuarna chicha. ");
INSERT INTO ksc_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Narpas pun na sachi kuru, impaarus Pablo na mamati ta sorkakonà chicha. Ad ananan chicha, “Annay lumayawà.” Tinaynana pù chicha, ummoy ad Macedonia. ");
INSERT INTO ksc_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ummoy ta ailiili nantudtuchu ta mamati ta masorkagcha. Sachi ad, ummoy akod Acaya, wi nangngachan Grecia. ");
INSERT INTO ksc_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Iningkaw ta sachì turuy furan. Sachi ad, simsimmòna wi mamapur wi umoy ad Siria. Ngim nganngani pun lumigwat, chingngorna wi nantuturag na uchumi Judio ta patoyonchà siya, siyan nalliglig ad Macedonia. ");
INSERT INTO ksc_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Nifurun akon uchumi fufurunna. Na ngachancha: Sopatro wi anà Pirro, wi iBerea; Aristarco ya Segundo wi iTesalonica; Gayo wi iDerbe; Tikico ya Trofimo wi iyAsia; ya chianin Timoteo. ");
INSERT INTO ksc_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Chummatong-ani pun ad Filipos, ummunacha ta urayon chianid Troas. ");
INSERT INTO ksc_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Narpas pun na fiyastay nanganan na takù tinapoy wi achi pun naraukan à mampafotar, namapur-ani wi ummun-unud ta fufurunni. Lummaus pun na limay padcha, chummatong-anid Troas, ad nakachumingkuani ta fufurunni ta sachi. ");
INSERT INTO ksc_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Mummaschom pun ta Safachu, naarus-ani wi losani mamatì makaan ta tinapoy à mangiyakasmoanni ta natayan Jesus. Ad nantudtuchù Pablo ingkana ta kawan na lafi, tan simsimmònay lumayaw nu mafikat. ");
INSERT INTO ksc_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ad-adchuwan na silaw ta sachi kuwartu ta miyatluy kat-un na foroy wi naarusanni. ");
INSERT INTO ksc_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Na osay fafaru wi nangngachan à Eutico, tummutùchu ta tawa, ad na nantudtuchuwan Pablo, manchùchùmog à siya. Ad nasuyop à Eutico, ad naodchag. Lummogsadcha pun aran à siya, nanattoy. ");
INSERT INTO ksc_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Siyan lummogsad akò Pablo, ad finonwarnà siya, ad ananan chicha, “Achiayu machanakan, tan mataku!” ");
INSERT INTO ksc_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ad summang-at-ani losan asin, ad nangan-anì tinapoy. Narpas-ani pun nangan, inturuy Pablo wi nakaug-ugkud an chiani, ingkana ta summingitan na init, achiyot lumayaw. ");
INSERT INTO ksc_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ad na sachi fafaru, inturudchà siya ta foroyna, ad naragsakcha tan ummuli nataku. ");
INSERT INTO ksc_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Impaunan Pablò chiani wi namapur wi umoy ad Asson, tan imfakana wi chakasonà chiani tan manadcharan wi umoy ad Asson. ");
INSERT INTO ksc_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nan-aafot-ani pun ad Asson, namapur-ani losan wi ummoy ad Mitilene. ");
INSERT INTO ksc_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Nafikat pun, tinaynannin sachi ili ad inturuyni wi namapur, ad chummatong-anid Chio. Asin pu nafikat, chummatong-anid Samos, ad asin pu ko nafikat, chummatong-anid Mileto. ");
INSERT INTO ksc_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Achiani pu nanchakas ad Efeso, tan simsimmò Pablo wi lausanni, ta mangkanas na chumatngannid Jerusalem ta chaptannin fiyasta wi ananchay Pentecostes. ");
INSERT INTO ksc_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Na iningkawannid Mileto, impaayag Pablo chachi mangipangpangu ta mamatid Efeso. ");
INSERT INTO ksc_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Chummatongcha pun ad Mileto, anan Pablo an chicha, “Akammuyun imfibfiyag-u ta iningkawà an chiayu nanipud ta chamuy ummaliyà ad asnay provinsiya wi Asia. ");
INSERT INTO ksc_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Iningwà losan na impàwan Apudyus an saon, ya foon pù inchayaw-un long-ag-u. Inturuy-uchi uray mansikab na somsomòu ta simfofotang, ya uray pinarpalikatanà ta chachi Judio ta namachapachasancha mangtoyan an saon. ");
INSERT INTO ksc_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Akammuyu ko wi maid pu insulib-ù fumaruwanyu ta nantudtuchuwà an chiayu ya nangipagngorà mipangkop an Jesus ta sangwanan na taku ya uray ta aforoforoy. ");
INSERT INTO ksc_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Impapatì akoy nangifaka ta chokà wi Judio ya chachi foon à Judio wi masapur ifafawichan fasfasurcha ya mansakungchan Apudyus ya mamaticha kon Jesu Cristu wi Aputau. ");
INSERT INTO ksc_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ad na sana, inyà ad Jerusalem, tan siyan pàwan na Ispiritun Apudyus, uray foon pù akammù nu sinun màwan saon ad aschi. ");
INSERT INTO ksc_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Tan na afusi akammù, mafaruchà ya mapalikatanà ta sinuy ili wi umayà, amaschin impaakammun na Ispiritun Apudyus an saon. ");
INSERT INTO ksc_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ngim uray matoyà, tan maid pu filang na fiyag-u, tan pakaropasò na losani impàwan Apu Jesus an saon, wi masapur istikuwà na Mamfaruy Chamag mipangkop ta achakun Apudyus ta taku. ");
INSERT INTO ksc_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Iniingkawà an chiayu nantudtudtuchu mipangkop ta Manturayan Apudyus. Ngim na sana, akammù wi nu lumayawà, maid asinyu mangil-an an saon ta annay luta. ");
INSERT INTO ksc_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Siyan maawatanyuna, wi nu awad osan chiayù misiyan an Apudyus à machusa, foon pù fasur-u, ");
INSERT INTO ksc_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","tan maid pun insulib-u ta nantudtuchuwà an chiayu ta losani pangkop Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Siyan man-annad-ayu, ya ayyuwananyu kon losani fufurunyu wi impiyar na Ispiritun Apudyus an chiayù mangipangpangun chicha. Isun na inyòoyyan na mampapastor wi mangayyuwan ta panniluna, amaschi kon oyyoonyu wi mangayyuwan ta chachi mamati, tan imfayad Apudyus na charan na anàna à oroscha. ");
INSERT INTO ksc_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Akammù wi nu lumayawà, umali chachi mantudtuchù chumachail an chiayu, wi isuchà atap wi animar wi otyonchan naamu. ");
INSERT INTO ksc_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Chumtong na timpuy na uchum an chiayu, turtulliyanchan mamati ta chichan masurut. ");
INSERT INTO ksc_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Siyan man-annad-ayu ta achiayu miyafut. Somsom-onyu kuman nantudtuchuwà an chiayu ta unog na turuy tawon wi iningkawà an chiayu, ta linafi ya finikat, wi malluruwaà ako kapu ta chakor na ayat-u ya achakù an chiayu. ");
INSERT INTO ksc_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Siyan na sana, Apudyus na mangayyuwan an chiayu, ya piyarò wi surutonyun tudtuchu mipangkop an Jesus, wi kaasin Apudyus ta taku. Siya kon nginlobfong wi mangipapigsa ta pammatitau, ya mangatod ta mamfaru wi impustana ta losani mantakuna. ");
INSERT INTO ksc_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","À saon, maid nan-ochawà à pilakyu, ya luputyu ya sinuy awad an chiayu, ");
INSERT INTO ksc_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","tan akammuyu wi nallabfuwà à mangar-à ta losani masapur-u ya masapur akon fufurun-u. ");
INSERT INTO ksc_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Amaschin ining-ingwà, ta is-isuwonyu, tan masapur mallagpottauy man-iwaar ta awad ifachangtau ta sinumani makasapur à fachang. Sosom-ontau kuman imfakan na Aputau wi Jesus, wi anana, ‘Naragragsak na takuy mangatod nu takuy man-ochaw.’” ");
INSERT INTO ksc_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Sachi ad, nampalintumongcha losan ad nalluwarù Pablo. ");
INSERT INTO ksc_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ad losancha mansasàuy, ad nan-ifilcha tan lawingonchay lumayaw à Pablo, ");
INSERT INTO ksc_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","sinchumallun nangifag-ana wi maid asincha mangil-an an siya ta annay luta. Sachi ad, tinun-udchà siya wi umoy ta ikaw na papur wi mallukanana. ");
INSERT INTO ksc_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nansisiyan-ani pun an chicha, nangaw-as-ani wi namapur ad Cos. Ad nafikat pun, chummatong-anid Rodes, ad asin ad nafikat, chummatong-anid Patara. ");
INSERT INTO ksc_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ad inchasannin osay papur wi umoy ad Fenicia, ad namapur-ani. ");
INSERT INTO ksc_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Na namapuranni, innilanin luta wi nangkawaon na fayfay wi nangngachan Chipre ta apot ta chuwiki. Ad panopanos pun chummatong-anid Tiro wi osay ili ta provinsiya wi Siria. Nanchissaag-anid Tiro, tan siyan mangichissaakan na papur ta karkana. ");
INSERT INTO ksc_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ad inchasannin uchumi mamatin Jesus, siyan iningkaw-anin chichà sinchumingku. Ad na iningkawannin chicha, imfakachan Pablo wi foon pu otyan à ituruynay umoy ad Jerusalem, tan impaakammun na Ispiritun Apudyus an chicha wi mapalikatan à Pablo ad aschi. ");
INSERT INTO ksc_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ngim nachauman pun na timpuy lumayawanni, impapilitni wi lumayaw. Siyan inturud na nasimfarfaryani mamatì chiani ta ikaw na papur. Ad nampalintumong-ani losan ta ikid na fayfay wi nan-asiluwaru. ");
INSERT INTO ksc_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Sachi ad, nangulincha ta foforoycha, ad nallukan-ani ta papur. ");
INSERT INTO ksc_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ad inturturuyni wi namapur, ad chummatong-anid Tolemaida, ad nanchissaag-ani ta fusitaonni chachi mamatin Jesus ta sachi. ");
INSERT INTO ksc_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Nafikat pun, asin-ani namapur wi ummoy ad Cesarea. Chummatong-ani pun, ummoy-ani ta foroy Felipe ad iningkaw-anin siya, wi siyan osa ta chachi pitu wi nachutukan ad Jerusalem à fumachang. Na iwaarna ko, nantudtuchu ta Mamfaruy Chamag mipangkop an Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Opat na anànay fabfafarasang, wi profetascha ko wi ifagfakachan ipaspasmò na Ispiritun Apudyus an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Lummaus pun na uchumi padcha, chummatong akon osay profeta wi Agabo na ngachanna, wi narpud Judea. ");
INSERT INTO ksc_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ummalì Agabo ta foroy Felipe ad inaranan larat Pablo, ad finofodnan imana ya ikina. Ad anana, “Annayan imfakan na Ispiritun Apudyus: Na nginlarat ta anna, amasnan maniliwan na Judio an siya ad Jerusalem ad iyoychà siya icharum ta foon à Judio.” ");
INSERT INTO ksc_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Chingngorni pun na imfakana, inàarùni ta chachi uchumi iningkaw ta achi pu kumà Pablo umoy ad Jerusalem. ");
INSERT INTO ksc_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ngim sinongfatan Pablò chiani, “Sinu kon oyyoonyuy asiiifil? Parwingonyu kan somsomòu! Susunud, nakasakanaà wi mitaod ad Jerusalem, ya uray nu mapatoyà kapu ta pammatì an Apu Jesus.” ");
INSERT INTO ksc_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Siyan kapu ta achiani pun makaawis an siya, kumminòani, ad ananni, “Iluwarutau wi afus na pion Apudyus à màwa.” ");
INSERT INTO ksc_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Foon à nafayag na iningkawanni ta sachi, ad nansakanaani wi umoy ad Jerusalem. ");
INSERT INTO ksc_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Nifurun akon chianin uchumi mamati wi iCesarea. Ad na chummatngannid Jerusalem, inyoychà chiani ta foroycha Mnason wi iChipre, tan sachi nun ingkawanni. Nafayag na namatiyan Mnason an Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Chingngor pun na mamatid Jerusalem wi chummatong-ani, isagcha naragsak wi mammangilin chiani. ");
INSERT INTO ksc_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Nafikat pun, ummoynin Pablo fisitaon à Jaime. Iningkaw akon losani mangipangpangu ta mamatid Jerusalem. ");
INSERT INTO ksc_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ad inyag-akammuni pun à Pablo an chicha, inur-ullit Pablo na losani impàwan Apudyus ta nantudtudtuchuwana ta chachi foon pù Judio. ");
INSERT INTO ksc_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Na nangngorancha ta ur-ullitna, chinaychayawchà Apudyus. Ngim anancha kon Pablo, “Sunuchi Pablo, sosom-om wi alifulifun Judio wi mamatin Jesus, wi losancha ipapati wi manungpar ta losani Lintog Moses. ");
INSERT INTO ksc_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Nanchinamag wi itudtudtuchum anu ta losani fufuruntauy Judio wi finumroy ta lutan na foon à Judio, ta man-awichanchan Lintog Moses, ya imfagfakam anu wi achicha pu ko markaan na an-ananàcha, ya achicha pu ko tungparon na uchumi achawiyantauy Judio. ");
INSERT INTO ksc_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ad, sinun oyyoontau ta akammuwonchay foon pù tuttuwan chingngorcha, tan sikurachuy chamakonchay chummatong-ayu. ");
INSERT INTO ksc_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Na somsomòni, amasnan ustuy oyyoom. Anchanan opat an chiani wi lallarai wi nganngani marpas na impustachan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Furnam chicha wi umoy ta Templo, ad miyamung-a ta mangwaancha ta pituy padchay mangkangputancha ta illintog Moses mipangkop ta mipustan Apudyus. Ad nu makangputchi, fayacham akon kastuscha, ta nu marpas, mafalinchay mampapukis ta pachi à mangipail-ancha wi nakangput na impustacha. Ad siyan mangakammuwan na taku wi maid katuttuwaan na chinamagchay mipangkop an sia. Ad akammuwoncha ko wi ipapatim wi manungtungpar ta Lintog Moses. ");
INSERT INTO ksc_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ya mipangkop ta chachi foon à Judio wi namati, insuratnin tudtuchunin chicha, wi achicha otyan anon na sinumani michatun ta sinan-Apudyus, ya achicha pu ko anon na chara winnu napsor wi animar wi achi pu nachara, ya achicha pu ko it-om na foon à asawacha.” ");
INSERT INTO ksc_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Nafikat pun, finurnan Pablo na chachi opat, ad nitapì siya ta oyyoonchay manungpar ta Lintog Moses mipangkop ta impustacha. Ad ummoycha ta Templo, ad imfakan Pablo ta pachi na padchay marpasan na oyyooncha, tan nu marpas, masapur mamparti chi opat à animar à ichatunchan Apudyus. ");
INSERT INTO ksc_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nganngani pun wi marpas na pituy padcha, niyaspur wi na uchumi Judio wi iyAsia, innilachà Pablo ta Templo. Ad sinugsukanchan ad-adchuwani taku, ta chòmaanchà Pablo. ");
INSERT INTO ksc_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Nampoawcha, “Fufurunni wi kanà Israel, fadngan chiani! Tan annayan sachi taku wi mantudtuchu ta atakutaku ta lawingonchà chitauy Judio, ta achicha ko tungparon na Lintog Moses, ya achicha pu ko lispituwon na annay Templotau. Ad na sana, am-amchona ko, tan kaisawanan Templotau, tan imparnònan foon à Judio.” ");
INSERT INTO ksc_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Amaschin anancha, tan na osay padcha, innilachan osay foon pù Judio, wi iyEfeso, wi nangngachan à Trofimo, wi nifurun an Pablo ta linumnoana ta ili, ad anancha pun nu imparnònà siya ta Templo. ");
INSERT INTO ksc_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Na nangngoran na takud Jerusalem ta sachi, ummog-otcha, ad nakurucha losan, ad asitotodchàchay ummoy ta Templo. Ad chinòmaanchà Pablo ad kinuykuychà siya iparawa ta Templo. Sachi ad, inyonobchan Templo. ");
INSERT INTO ksc_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ngannganicha pun patoyon à siya, imfakan na osay taku ta kumander na susurchachuy iRoma wi nakurun losani taku ta ili. ");
INSERT INTO ksc_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Sachi ad, chakusi inayakan na kumander na uchumi kapitan ya susurchachu ad asitotodchàchay ummoy ta awachan na ad-adchuwani taku. Ad innilan pun na takù chicha, inwarangchay manatar an Pablo. ");
INSERT INTO ksc_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ad tiniliw na kumander à Pablo ad impakachilanà siya à chuwà kachila. Sachi ad, inimusna ta taku, “Sinun takuy anna? Ad sinu kon iningwana?” ");
INSERT INTO ksc_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ngim nansafasafalin songfatcha, ya asingongonotcha, siyan maid pu mangakammuwana nu sinun katuttuwaan. Sachi ad, imfakana ta susurchachu ta iyoychà Pablo ta kampucha. ");
INSERT INTO ksc_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Chummaumcha pun ta archan na kampu, intangoy na uchumi surchachu impangatù Pablo tan naam-amod na og-ot na taku. ");
INSERT INTO ksc_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ad nituntun-udcha kon siya, wi ip-ip-awcha anani, “Patoyontaù siya!” ");
INSERT INTO ksc_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Na mangiparnoanchan Pablo ta kampu, kummingà Pablo à Griego ta kumander anani, “Mafalini awad na ifakà an sia?” Nataag na kumander tan Griego na inyùukud Pablo, ad anana, “Apay, akammumi man-ukud à Griego! ");
INSERT INTO ksc_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Anà pun nu sian sachi iyEgipto wi nanguru ta kufilnu ta sin-arkawan. Siyan sachi nangiyoy ta opat lifuy takuy alilifuk ta ikaw wi maid pu taku.” ");
INSERT INTO ksc_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","“Foon pun à saon,” anan Pablo, “tan Judiowà wi narpud Tarso ta provinsiya wi Cilicia, wi Tarso na osay machaychayaw wi ili.” Ad anan ako Pablo, “Annan piò wi ifaka ta anchanayay taku, nu mafalin.” ");
INSERT INTO ksc_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ad intay-un na kumander, siyan summiad à Pablo ta archan ad impakinònan taku. Ad nan-ukud à sikud wi ukud na Judio, wi Hinebreo, ad anana: ");
INSERT INTO ksc_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Aamma ya susunud, chongronyun ifakà, nu awad arwingà an chiayu.” ");
INSERT INTO ksc_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Na nangngorancha wi Hinebreo na inyùukudna, kumminòcha losan. Ad inturuy Pablo anani: ");
INSERT INTO ksc_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“À saon, Judiowà wi niyanà ad Tarso ta provinsiya wi Cilicia, ngim asnay Jerusalem na chummakrà ya nan-uswilaà. À Gamaliel na nanudtuchun saon, siyan ninarmà wi nangachar manungpar ta Lintog wi tinungpar na achakchakrantau. Lagpotanà ako wi nangwa ta losani pion Apudyus, wi isun na inyòoyyayu ta sana. ");
INSERT INTO ksc_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Pinalikatà na mamatin Jesus, ya impapatoy-u kon uchum. Uray lallarai ya fubfufai, impatiliw-ù chicha ta mifarudcha. ");
INSERT INTO ksc_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Na angatuwani pachi ya losan chachi Kukunsisartau, mafalini istikuwoncha wi katuttuwaan na ifakà tan chichan nangatod an saon ta surat wi mangatod à karobfongà wi maniliw ta chachi mamatin Jesus. Siyan inawit-un sachi surat ta chachi chokatauy Judio ad Damasco, wi na pangkop-u, tiliwò chachi mamati ad iyalì chichad asnay Jerusalem, wi makachilaancha, ta machusacha. ");
INSERT INTO ksc_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Ngim machanchaniyà pun ad Damasco ta mamatù, nammaag nasilingà ta linang wi narpu ta langit, ");
INSERT INTO ksc_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ad nalitwachà. Ad chingngor-un kinga wi anana, ‘Saulo, Saulo! Tammakò saon parpalikatan?’ ");
INSERT INTO ksc_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Ad inimus-u, ‘Sinua, Apu?’ “Ad summongfat chi kumminga, ‘Saon à Jesus wi iNazaret, wi parpalikatam.’ ");
INSERT INTO ksc_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","“Chachi fufurun-u, innilachan linang, ngim achicha pun chingngor na inukud na sachi kumminga. ");
INSERT INTO ksc_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Sachi ad, inimus-u, ‘Apu, sinun oyyoò?’ “Ad ananay summongfat, ‘Fumangon-a ta ing-ad Damasco wi awachan na mangifakan sia ta losani pàwan Apudyus an sia.’ ");
INSERT INTO ksc_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","“Ngim nakurapà kapu ta sachi linang, siyan iniwichà ta fufurun-u inyoy ad Damasco. ");
INSERT INTO ksc_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Iningkaw ad Damasco na osay Judio, wi Ananias na ngachanna, wi manaychayaw an Apudyus ya tungparona losan na Lintogtauy Judio, ya lispituwon losan na chokanay Judio à siya. ");
INSERT INTO ksc_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ummalin saon ta foroy wi iningkawà, ad summiad ta char-ag-u. Ad anana, ‘Sunuchi Saulo, maaan na kurapnu!’ “Sachi ad, nakailaà ad intollong-ù siya. ");
INSERT INTO ksc_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Ad anan ako Ananias, ‘À Apudyus wi chinaychayaw na achakchakrantau, chinutukanà sia ta akammuwom na piona, ya ilam na nalimpiw wi anànay Jesu Cristu, ya chongrom na ustuustuy kingana. ");
INSERT INTO ksc_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Tan sian mangistiku ta atakutaku ta losani inilam ya chingngornu mipangkop an siya. ");
INSERT INTO ksc_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ad, sinu kon urayom? Fumangon-a ta ing-a mampafunyag, ya iluwarum an Jesus ta pakawanonan fasurnu.’ ");
INSERT INTO ksc_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Ad namagkulinà pun ad Jerusalem, ummoyà ta Templo malluwaru, ad iningkaw na isù impain-inop Apudyus an saon, ");
INSERT INTO ksc_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","tan innilà à Apu Jesus wi ananan saon, ‘Kanasom! Taynam ad asnay Jerusalem, tan na takud asna, achicha pu patiyon na istikum wi mipangkop an saon.’ ");
INSERT INTO ksc_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Ngim sinongfatà, ‘Apu, patiyoncha nin, tan akammucha wi saon na ummoummoy ta chachi sinagoga naniliw ta chachi mamatin sia, ya impaabchoy-u kò chicha. ");
INSERT INTO ksc_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ad akammucha ko wi saon na nangiparufus ta namatayanchan Esteban wi nangistikun sia, tan iningkawà wi nangchon ta luput chachi namatoy.’ ");
INSERT INTO ksc_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Ad ananan saon, ‘Uray, ing-a, tan ifaun-ù sia mantudtuchuwon ta achayuy foon à Judio.’” ");
INSERT INTO ksc_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Na nangifag-an Pablo ta sachi, na takuy naaarus nanchochongngor an siya, illukichay nampoaw, “Patoyontaù siya! Matoy otyan na amasnati taku!” ");
INSERT INTO ksc_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ad asipapauycha, ad kinissaychan silupcha ya ingkab-urchan kafu ta ngatu. ");
INSERT INTO ksc_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Siyan imparnò na kumander à Pablo ta kampu, ad imfakana ko ta abchoyon na surchachunà siya ta akammuwoncha nu sinun pangkop na ummog-otan na Judio an siya. ");
INSERT INTO ksc_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ngim intaodcha pun à siya ta abchoyoncha, anan Pablo ta kapitan na surchachu wi ummaagsad, “Apay, iparufus na lintog wi maabchoy na takuy Romano wi chaan pù maimfistikar?” ");
INSERT INTO ksc_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Chingngor pun na kapitan na imfakan Pablo, ummoyna imfaka ta kumander. Anana, “Sinu kon annay oyyoontau? Tan na anchi Pablo, Romano nu!” ");
INSERT INTO ksc_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Sachi ad, ummoy na kumander an Pablo inimus an siya, “Ifakam nu tuttuway Romano-a?” “Oo, anan Pablo.” ");
INSERT INTO ksc_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ad anan na kumander, “Uray saon, ngim chakor na finayachà ta mifilangà à Romano!” Ad summongfat à Pablo, “Ngim à saon, niyanaà à Romano.” ");
INSERT INTO ksc_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Siyan chakusi nan-onat na chachi mangimfistikar an siya; ya uray na kumander, ummogyat ta nangakammuwana wi Romanon impakachilana. ");
INSERT INTO ksc_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ngim na kumander, pionay akammuwon na mismuy ipafasur na Judio an Pablo; siyan nafikat pun, impaayagnan losani pangpangun na papachi ya losani mamangpanguwon na Judio. Ad impaaannan kachilan Pablo. Ad inyoyna impasangngù siya ta sangwanancha losan. ");
INSERT INTO ksc_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Intotollong Pablò chicha, ad anana, “Susunud-uy Judio, mamfarun somsomòu tan nanipud ta niyanaà, nginongodngochà wi mangwa ta anan Apudyus wi mamfaru.” ");
INSERT INTO ksc_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Na nangifag-ana ta sachi, à Ananias wi Angatuwani Pachi, impalipaknan tupò Pablo. ");
INSERT INTO ksc_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Sachi ad, anan Pablo an siya, “Siay sinankuis, tuttuway lipakon Apudyus akò sia! Tan in-inon akon anam wi nakafasurà ta Lintogtau, ad sian nakafasur tan impalipaknù saon, wi amaschin mipalit ta Lintogtau?” ");
INSERT INTO ksc_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Sachi ad, anan na osay niyachanin Pablo, “In-insurtuwom na Angatuwani Pachin Apudyus!” ");
INSERT INTO ksc_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ad anan Pablo wi summongfat, “Susunud-uy Judio, nu inakammù wi siyan Angatuwani Pachi, foon pu otyan à imfafain-ù siya, tan awad tuwan niyug-is wi ukud Apudyus, wi anana, ‘Achiayu man-ukud à lawing ta pangpanguyu.’” ");
INSERT INTO ksc_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Inakammun Pablo wi nan-agwan somsomò na chachi Kukunsisar, tan Saduceo na uchum ya Fariseo kon uchum, ad chinakornan kingana, wi anana, “Susunud! Fariseowà, wi kanà akon Fariseo! Siyan namnamaò wi umuli matakun natoy, ad sachin pangkop na nangicharumanyun saon ta sana!” ");
INSERT INTO ksc_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Imfakana ad na amaschi, illukin chachi Fariseo ya Saduceo wi mansusukob, tan nan-agwacha. ");
INSERT INTO ksc_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Tan na Saduceo, anancha nu wi achi pu umuli matakun natoy. Anancha ko nu wi maid pu anghel ya alichodwa. Ngim na Fariseo, tuttuwaoncha losan chachi. ");
INSERT INTO ksc_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ngummonongonotchay nansusukob. Ad na uchumi Fariseo wi mangitudtuchu ko ta Lintog, summiadchay ipapilitchan somsomòcha. Anancha, “Maid pu osà inchasannì nakafasuran na annay taku. Nu tuttuway nakaukud an siyan anghel winnu osay achi pu maila, lawing akuin na amaschi?” ");
INSERT INTO ksc_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Sachi ad, natuud na sukobcha, siyan nachanakan na kumander tan awni ad nu aragragkiyanchà Pablo ta og-otcha. Siyan imfakana ta uchumi surchachuna ta umoycha aran à siya ta asincha iyoy ta kampu. ");
INSERT INTO ksc_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Na sachi lafi, impailà Apu Jesus an Pablo, ad anana, “Papigsaom na somsomònu, tan masapur wi istikuwanà ad Roma à isun na nangistikuwam an saon ad asnay Jerusalem.” ");
INSERT INTO ksc_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Nafikat pun, nantuturag na uchumi Judio ta patoyonchà Pablo. Nan-asisapatacha ta achicha pu mangan ya uminum ingkanà patoyoncha nù Pablo. ");
INSERT INTO ksc_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Nasurukchà opatpuruy Judio wi nantuturag ta amaschi. ");
INSERT INTO ksc_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ummoycha ta pangpangun na papachi ya mamangpanguwon na Judio, ad anancha, “Nan-asisapataani wi achiani pun mangan ingkanà patoyonnì Pablo. ");
INSERT INTO ksc_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Siyan chiayu ya losan chachi uchumi pangpangu, umifaun-ayù umoy mangifaka ta kumander ta iyalinà Pablo ta anna ad akin-iimfistikar-ayu mipangkop ta kasusna. Ad fangafanganni ta charan ta patoyonnì siya.” ");
INSERT INTO ksc_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ngim na amunaon Pablo, chingngornan mipangkop ta puranun chachi Judio, siyan ummoyna ta kampu impalìnan siya. ");
INSERT INTO ksc_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ad inayakan Pablo na osay kapitan, ad anana, “Iyoynu ad na annay fafaru ta kumander, tan awad na ifakanan siya.” ");
INSERT INTO ksc_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ad inyoyna ta sachi, ad anana, “À Pablo wi farud, impaiyalinan annay fafaru an sia tan awad anun ifakanan sia.” ");
INSERT INTO ksc_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Sachi ad, iniwid na kumander chi fafaru intalin ad inimusna, “Sinun piomi ifaka?” ");
INSERT INTO ksc_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Summongfat na sachi fafaru, wi anana, “Nantuturag chachi pangpangun na Judio wi manawat an sia ta asinnu ipasangun amaò wi Pablo ta mimittinganchà fikat, ta iyam-ammacha nuy mangimfistikar an siya mipangkop ta kasusna. ");
INSERT INTO ksc_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ngim achim otyan patkon chicha, tan nasuruk à opatpurun takuy mamangafang an siya, tan nan-asisapatacha losan wi achicha pu nu mangan ya uminum ingkanà patoyoncha nù siya. Nakasakanacha, wi uullayoncha kan mangiparufusam.” ");
INSERT INTO ksc_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Sachi ad, imparyaw na kumander à siya, wi finilinnà siya, “Achim ifagfaka wi impalìnam an saon na anna.” ");
INSERT INTO ksc_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ad inayakan na kumander na chuway kapitan, ad ananan chicha, “Isakanayun 200 wi susurchachu, wi mitapi kon 200 wi mantutufay ya 70 wi mangafayu. Lumigwat-ayù tiprò ta sanay lafi, wi mangipuyut an Pablo ad Cesarea. ");
INSERT INTO ksc_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mangafayuwonyu kò Pablo, ya mallaram-ayu ta maid maan-anun siya, ingkanà inchatongyun Fifinnachur wi Felix.” ");
INSERT INTO ksc_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ad nanurat akon kumander, anana: ");
INSERT INTO ksc_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Apu Fifinnachur Felix, saon wi Claudio Lisias na annay manurat an sia. Sapay kuma ta mamfarua. ");
INSERT INTO ksc_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Na annayay larai wi impaiyalì an chiayu, chinòmaan na Judiò siya ad tikangaycha patoyon. Ngim inakammù pun wi Romanò siya, sinaraknifanni ta susurchachù à siya. ");
INSERT INTO ksc_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ngim kapu ta piniyà wi akammuwon nu sinun ipafasurchan siya, inyoy-ù siya ta Kukunsisarcha. ");
INSERT INTO ksc_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ad inchasà wi maid pu nakafasuranà umanay à mapatoyana, ya uray mifaruchana, tan na ipafasurchan siya, mipangkop yakay ta lintogchay Judio. ");
INSERT INTO ksc_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Chinamag-u pun wi nantuturag na uchumi Judio ta fangafanganchà siya, sinaryun-u ipaiyalin sia. Imfakà ako ta chachi nangicharum an siya ta umalicha toopon an sia na nangicharumanchan siya.” ");
INSERT INTO ksc_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Na sachi lafi, pintog na susurchachu losan na imfakan na kumandercha, wi inyoychà Pablo ingkanad Antipatrisa. ");
INSERT INTO ksc_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Nafikat pun, summiyan na uchumi susurchachu nangulin ta kampucha, ad inturuy chachi nangafayu wi mangipuyut an Pablo. ");
INSERT INTO ksc_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Chummatongcha pun ad Cesarea, innadchonchan surat ta fifinnachur, ad imparangchà Pablo an siya. ");
INSERT INTO ksc_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Finasan pun na fifinnachur na surat, inimusnan Pablo nu sinun provinsiyan niyanaana. Ad inakammuna wi iCilicià siya, ");
INSERT INTO ksc_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","siyan anana, “Achì sia imfistikaron nu umali chachi mangicharum an sia.” Ad impafantaynà Pablo ta susurchachu ta foroyna wi impakaob Ali Herod ta sin-arkawan. ");
INSERT INTO ksc_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Lummaus pun na limay padcha, chummatong ad Cesarea à Ananias wi Angatuwani Pachi ya uchumi mamangpanguwon na Judio ya intapicha kon osay abogado wi nangngachan à Tertulo. Ad nisanguchan Fifinnachur Felix wi mangipafasur an Pablo. ");
INSERT INTO ksc_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Impaayag pun na fifinnachur à Pablo, imfakan Tertulo na ipafasurchan siya anani, “Machayawi Apu Fifinnachur! Kapu ta kinaraingnuy mangituray an chiani wi Judio, maid nakurkuruwannì nafayag, ya ad-adchuwan na iningwam à fummaruwan na losani taku ta annay lutani. ");
INSERT INTO ksc_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Siyan uray nu farangnan umayanni, chakor na yamannin sia kankanayun. ");
INSERT INTO ksc_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Achì pu otyan taktakon à sia, ngim anusam wi mangngor ta annay aiti ifakani. ");
INSERT INTO ksc_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tan ilam, na annayay taku, sikurachuy siyan osay akukuru ta atakutaku, tan ummoummoy ta ailiili mangkurukuru ta chokanay Judio. Ya siya kon osay pangpangun na sumursurut ta osay takuy iNazaret. ");
INSERT INTO ksc_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Impachasna ko chinimò na Templonid Jerusalem, siyan tiniliwnì siya, tan ananni pun nu kuisonnì siya mipangkop ta Lintogni. ");
INSERT INTO ksc_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ngim ummalin sachi kumander, wi Lisias, ad linagkina illayaw. ");
INSERT INTO ksc_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ad imfakana ko wi masapur nuy umalianid asna, ta sangwanam na mangicharumannin siya. Nu imfistikarom na annay taku, maakammuwam wi na losani ipafasurnin siya, tuttuwa.” ");
INSERT INTO ksc_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ad ummamfuruy akon fufurunnay Judio anani tuttuwa losan na impafasurnan Pablo. ");
INSERT INTO ksc_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Sachi ad, impasongfat na fifinnachur an Pablo. Ad anan Pablo: “Apu Fifinnachur, akammù wi nafayag na nangkuisam an chitauy Judio, siyan naragsakà wi manongfat ta impafasur na anchanayan saon ta sangwanam. ");
INSERT INTO ksc_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Mafalinnuy akammuwon wi simpuru ya chuway padcha ta sana nanipud ta ummayà ad Jerusalem makachaychayawan an Apudyus ta Temploni. ");
INSERT INTO ksc_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Na iningkawà ta sachi, maid pu nangil-an na Judio an saon à makais-isì ta sinuman ta Templo, ya maid ako innilachà nanguruwà ta taku, uray ta sinagogacha winnu farangnay lukar. ");
INSERT INTO ksc_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ya maid pu ko mamfasarancha wi tuttuwan ipafasurchan saon. ");
INSERT INTO ksc_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ngim awad na ifakà an sia: Tudtuchun Jesus na sursurutò ta manaychayawà ta Apudyus na achakchakranni, ad sachin nangifag-ancha wi foon pù ustù mitudtuchu. Ngim tuttuwaò ako kay losan na niyug-is wi Lintog Moses ya losani inyug-is na profetas ta awi. ");
INSERT INTO ksc_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Man-isun namnamani ta anchanay mangipafasur an saon, tan namnamaonni losan wi ipaulin Apudyus takuwon na losani natoy à tapin na padcha, na mamfaru ya lawingi taku. ");
INSERT INTO ksc_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ad kapu ta amasnan namnamà, ngongodngochà wi mangwa ta mamfaru, tapnu ustun somsomòu kanayun, wi maid pu kafasurà an Apudyus, ya maid pu ko otyan kafasurà ta asintatakù. ");
INSERT INTO ksc_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Nafayag wi maid pu ummay-ayà ad Jerusalem, siyan na ummayà, nangawità à pilak à ifachangni ta fufurunni wi makasapur, ya ummoyà ako manchatun an Apudyus ta Templo. ");
INSERT INTO ksc_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ad na nangwaà ta sachi inchasan chachi Judio wi iyAsia an saon ta Templo. Na sachi, narpas-u iningwan ukalini, wi mipangkop ta maaanan na kaisaw-u. Ad maid ad-adchuwan à taku ta sachi, ya maid pu ko nangkuru. ");
INSERT INTO ksc_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Chachi iyAsia, chicha kuman ummalid asna mangicharum an saon, nu awad tuwa kafasurà. ");
INSERT INTO ksc_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ngim nu maidcha pun, uray nu ifakan na anchanayan inchasanchà fasur-u ta naisanguwà an chichad Jerusalem! ");
INSERT INTO ksc_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Tan na iningkawà ta sachi, tuttuway chinakor-un kingà ta mangwanaà wi, ‘Incharumà an chiayu kapu kay ta manuttuwaà wi umuli matakun natoy.’ Ngim afus yakan sachì imfakà an chicha.” ");
INSERT INTO ksc_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","À Fifinnachur Felix, achun inakammuna mipangkop ta tudtuchun Jesus, siyan imfakana ta Judio, “Urayontau yan na chumatngan Kumander Lisias, achìwot ifanag na annay kasusyu.” ");
INSERT INTO ksc_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ad impafantaynà Pablo ta kapitan, ngim mifilang à siyà isù foon pù farud, wi foon à mipalit na fufurunnay mangiyoy ta kasapurana. ");
INSERT INTO ksc_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Lummaus ad na am-annay padcha, iningkaw na ummayan Felix, ngim foon pù nafayag ad nangulin wi inchatongnan asawana wi Drusila na ngachanna, wi Judio. Sachi ad, impaayagnà Pablo ta chongronchan mipangkop ta pammati an Jesu Cristu. ");
INSERT INTO ksc_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ngim na mangitudtuchuwan Pablo ta mipangkop ta malimpiw wi mafiyakan, ya maningngilan ta lawing wi pion na long-ag, ya chumatngan na padchay manguisan Apudyus ta taku, ummogyat à Felix ta nangngorana, ad anana, “Sachi! Uray lumawaa ta sana, ta achì ipaayag sia nu awad timpù!” ");
INSERT INTO ksc_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ad na sachi nampaapaayakana ya nakaukaukuchanan Pablo, anana pun nu pasuksukanà siya. ");
INSERT INTO ksc_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Lummaus ad na chuway tawon, nisukat à Porcio Festo an Felix wi mamfifinnachur, ngim na lummayawan Felix, tinaynanà Pablo ta fafalluchan, wi maid uchum à pangkopna nu achi mamfaruwon kuman Judiò siya. ");
INSERT INTO ksc_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Atlun padchan na chummatngan Festò mamfifinnachur ta sachi provinsiya wi Cesarea, lummigwat wi umoy ad Jerusalem. ");
INSERT INTO ksc_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Chummatong pun, chachi pangpangun na papachi ya uchumi mamangpanguwon na Judio, ummoychan siya icharum à Pablo. Nampangpangngaasicha wi ");
INSERT INTO ksc_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","nu mafalin otyan, ipagkulinnà Pablo ad Jerusalem, tan nantuturagcha ta fangafanganchà siya ta charan patoyon. ");
INSERT INTO ksc_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ngim sinongfatan Festo à chicha anani, “Nafafantayan à Pablo ad Cesarea, ad foon pù iingkaw ad mangulinà akod aschi. ");
INSERT INTO ksc_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Siyan uray mifurun na uchumi pangpanguyun saon, ta aschin mangicharumanchan Pablo nu awad iningwanà lawing.” ");
INSERT INTO ksc_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Waru winnu simpuruy padchan iningkawan Festo ad Jerusalem, ad lummayaw wi umoy ad Cesarea. Nafikat pun, tummukaw ta kukùisan, ad impaayagnà Pablo. ");
INSERT INTO ksc_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Chummatong pun à Pablo, sinauyup na chachi Judio wi narpud Jerusalem linìwos à siya. Ingkakattòchay mangipafasur an siya, ngim maid pu ustuustù mamfasarancha. ");
INSERT INTO ksc_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Sachi ad, tinàchoran Pablo na long-agna, wi anana, “Maid pu sinurngasing-u ta Lintogtauy Judio winnu Templotau. Ya maid pu nanurngasingà ta Emperador na iRoma.” ");
INSERT INTO ksc_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ngim kapu ta pion Festo wi kumapot na Judio an siya, imfakanan Pablo, “Manay-ua nu intaud Jerusalem ta aschin maimfistikaram ta annay impafasurchan sia?” ");
INSERT INTO ksc_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ngim anan Pablo wi summongfat, “Lawingò, tan annaà ta sangwanam, ya asna otyan na maimfistikarà, tan sian ustuy chinutukan na Emperador à manguis. Ya akammum met wi maid pu lawing à iningwà ta chokà wi Judio. ");
INSERT INTO ksc_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nu awad fasur-ù umanay à mapatoyà, foon pù ilisiyà. Ngim nu maid pu katuttuwaan na mangipafasuranchan saon, maid pu nginlobfong à mangiparang an saon. Siyan iparang-un kasus-u ta Emperador.” ");
INSERT INTO ksc_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Sachi ad, nakaug-ugkud à Festo ta fufurunnay turay, ad anana, “Chinawatnu wi siya mangiparangam ta kasusnun Emperador, ad siyan mangipàyà an sia.” ");
INSERT INTO ksc_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Lummas pun na am-annay padcha, niyaspur wi ummalid Cesarea na osay Ali wi Agripa, ya sunudnay fufai wi Bernice. Ummoycha fisitaon à Festo. ");
INSERT INTO ksc_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Iniingkawcha pun à foon pù nafayag, inisturyan Festo an siya na mipangkop an Pablo. Anana, “Awad ta anna na osay farud wi tinaynan Felix. ");
INSERT INTO ksc_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Na iningkawà ad Jerusalem, chachi pangpangun na papachi ya uchumi mamangpanguwon na Judio, incharumchà siya, ad imfakacha ta papatoy-ù siya. ");
INSERT INTO ksc_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ad sinongfatà chicha wi foon pù ukalitauy Romanon pachusatan takuy mapafasuran nu chaan pù makuis. Masapur man-asisangucha yan ta chachi mangicharum an siya, ta awad wayanay manongfat ta ipafasurchan siya. ");
INSERT INTO ksc_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ad na chummatngan chachi nancharum ad asna, foon pù inyaw-awnì na kasusna tan nafikat ad tummukawà ta kukùisan. Ad impaayag-ù Pablo, ");
INSERT INTO ksc_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ad sachin nangifag-an na mangicharum an siya. Anà pun nu awad arwingan à ipafasurchan siya, ngim maid ustuustù fasurnà nangicharumanchan siya. ");
INSERT INTO ksc_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Tan na puntilyacha kay wi makais-isì, mipangkop ta ukalichay Judio, ya mipangkop ako ta osay natoy wi à Jesus anu, wi ipapilit Pablo anani ummuli nu nataku. ");
INSERT INTO ksc_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Kapu ta ait na akammù wi mangimfistikar ta amaschi wi fanag, inimus-un Pablo nu pionay maiyoy ad Jerusalem, ta aschi otyan na maimfistikarana. ");
INSERT INTO ksc_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ngim lawingona. Ananay uray urayonan miparangan na kasusna ta Emperador. Siyan impafantay-ù siya ingkanà ipaiyoy-ù siya ta Emperador.” ");
INSERT INTO ksc_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Chingngor pun Ali Agripa na imfakan Festo, anana, “Uray saon, piò ako chongron à siya.” Ad anan Festo, “Mafalin met! Ipaayag-ù siyà fikat.” ");
INSERT INTO ksc_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Nafikat ad, ummoycha Agripa an Bernice ta kukùisan, wi ipàpailachan afaruwani silupcha. Nakarnò ako chachi pangpangun na susurchachu ya chachi mamangpanguwon na ili. Ad linumnòcha pun losan, impaayag Festò Pablo. ");
INSERT INTO ksc_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ad anan Festo, “Ali Agripa ya losan-ayuy annad asna: Na annayay taku wi mailayu, siyan incharum losan na Judio ad Jerusalem ya asnay Cesarea. Ip-ip-awcha anani mapatoy otyan. ");
INSERT INTO ksc_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ngim maid pu inchasà à fasurnà umanay à mapatoyana. Ad kapu ta pionay mangiparang ta kasusna ta Emperador ad Roma, intay-ù. ");
INSERT INTO ksc_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ngim maid pu ustuustù akammù à fasurnà isurat-u ta Emperador. Ad sachin mangipasanguwà an chiayu losan, sinchumallun sia, Ali Agripa, ta nu marpastau imfistikaron, awad otyan màchasan à isurat-ù fasurna. ");
INSERT INTO ksc_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Tan na somsomòu, maid silfin na mangipàyà ta farud ta Emperadortau nu maid pu ochasà à ustuustù nakafasurana!” ");
INSERT INTO ksc_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Anan Agripa an Pablo, “Mafalini man-ukud-a.” Impakinò Pablo na taku, achinaot songfatan na impafasurchan siya anani, ");
INSERT INTO ksc_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Ali Agripa! Mamfaru tan annaa ta sanay padcha, siyan nakasatà nu makatàchorà ta long-ag-u ta sangwanam mipangkop ta losani impafasur na anchanayay chokatay Judio. ");
INSERT INTO ksc_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Tan akammum losan na ukalitauy Judio ya sinuy mansongsongfatantau. Siyan anusami manchongor ta annay ifakà an sia. ");
INSERT INTO ksc_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Losan na fufuruntay Judio, akammuchan imfibfiyag-u nanipud ta afan-og-u, tan iniingkawà an chicha ta ilini ya aschi Jerusalem. ");
INSERT INTO ksc_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Inaagkammucha wi nanipud ta chamu, nititipunà ta Fariseo wi mangipapati ta religiontau, ya impapatì wi manungpar ta losani lintogcha. Ad nu pioncha, mafalinchay istikuwan. ");
INSERT INTO ksc_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Tan na sana, micharumà kapu ta namnamaò wi oyyoon Apudyus na impustana ta achakchakrantau ta awi, wi ipaulina takuwon na natoy. ");
INSERT INTO ksc_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Isunga losan na fufuruntauy Judio wi kanà chachi simpuru ya chuwa, isunay sachin namnamaonchà màwan chicha, siyan issiyachay manchaychayaw an Apudyus ta finikat ya linafi. Ad, Apu Ali, kapu ta sachi namnamaò, sachin impafasurchan saon. ");
INSERT INTO ksc_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ad apay achiayu pu mamati wi ipaulin Apudyus takuwon na matoy? ");
INSERT INTO ksc_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Uray saon ta sin-arkawan, anà pun nu mamfarun isag-u kuraon na takuy mamatin Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ad amaschin iningwà ad Jerusalem. Ad-adchuwan na takun Apudyus wi impafarud-u, tan innadchon na pangpangun na papachin karobfongà. Ad nu nasintinsiyaanchà matoy, inapufarà ako. ");
INSERT INTO ksc_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Kanayun-u ko pachusà chicha ta chachi sinagogan na Judio wi mangipapilit an chicha ta man-awichanchan pammatichan Jesus. Uray na achayuy il-ilin na foon à Judio, ummoummoy-u ko pinalikatan na mamatin Jesus, tan narafos na og-ot-un chicha. ");
INSERT INTO ksc_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Ad sachin ummayà ad Damasco,” anan Pablo. “Inaw-awit-un surat chachi pangpangun na papachi wi nangatod à karobfongà wi maniliw ta sinumani mamatin Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ingkawà pun ta charan ta mamatù, nalinanganà ta narpu ta langit wi napigpigsa nu init. Nasiling-ani losan wi mamfufurun, ");
INSERT INTO ksc_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ad nalitwad-ani losan. Ad chingngor-un kummingà Hinebreo. Ananan saon, ‘Saulo, Saulo! Tammakò saon parpalikatan? Maid pu silfin na oy-oyyoom. Anam pun nu afakonà? Tan siya kay parpalikatam na long-agnu!’ ");
INSERT INTO ksc_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Ad inimus-u, ‘Apu, sinua?’ Ad summongfat na Apu, ‘Saon à Jesus, wi parpalikatam. ");
INSERT INTO ksc_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ngim fumangon-a, tan na pangkop-uy mampailan sia, chutukà sià mangwa ta piò, ya mangistiku ta annay nangil-am an saon ta sana ya na ipailà an sià tapin na padcha. ");
INSERT INTO ksc_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ifaun-u sià umoy mangitudtuchu ta mipangkop an saon ta chokam wi Judio ya uray na foon pù Judio. Ya saraknifà sia ta sinumani oyyoonchan sia. ");
INSERT INTO ksc_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Tudtuchuwam chicha ta maawatanchan mipangkop an saon, ta marawakan na somsomòcha ya man-awichanchan lawing. Ad nu man-awichanchan karobfongan Satan, ad mansakungchan Apudyus ya mamatichan saon, mapakawan na fasfasurcha, ad mifilangchà takuy chinutukan Apudyus.’ Sachin imfakan Jesus ta nampail-anan saon ta charan. ");
INSERT INTO ksc_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Sachi ad, Apu Ali, pintog-u losan na imfakan Jesus ta nampail-anan saon. ");
INSERT INTO ksc_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ad illukì ad Damasco wi nantudtuchu ta losani taku uray na foon à Judio achiyaot umoy ad Jerusalem ya losani sakupon Judea ta ifafawichan fasfasurcha ya mansakungchan Apudyus ya oyyoonchan mamfarù mangipail-anchay tuttuway namfafawicha. ");
INSERT INTO ksc_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ad kapu ta sachi wi intudtuchù, chinòmaan chachi chokatay Judiò saon ta Templo, wi siya pangkopchan patoyonchà saon. ");
INSERT INTO ksc_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ngim fafadngan Apudyus à saon, ad siyan impapilit-uy mantudtuchu ta losani taku, uray sinun kinasasaadcha, ingkana ta sana. Maid uchum à ifagfakà nu foon à inukudcha Moses ya chachi profetas ta awi na màwà tapin na padcha, ad nàwa tuwa chachi losan. ");
INSERT INTO ksc_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Tan imfafagkacha wi masapur mapalikatan ya mapatoy na Cristu wi impustan Apudyus wi ipaalina, ta siyan umunay umuli mataku. Ya siya kon mangipaakammun chitauy Judio, ya uray chachi foon, mipangkop ta marawakan na somsomò ya masaraknifan na taku.” ");
INSERT INTO ksc_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Na nangifag-ana ta sachi, chinakor Festo wi nampoaw, “Narapang-a, Pablo! Na narafosi acharnu, siyan namparapang an sia!” ");
INSERT INTO ksc_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ngim summongfat à Pablo, wi anana, “Foon à narapangà, Apu Fifinnachur, tan na annay ug-ugkuchò, katuttuwaan, wi foon pù ug-ugkud na narapang. ");
INSERT INTO ksc_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ali Agripa! Akammum na mipangkop ta anchanayay losani ug-ugkuchò, tan sikurachuwò wi foon pù nàwa ta chugyu! Siyan ifafagkà an sia. ");
INSERT INTO ksc_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ali Agripa, tuttuwaom na imfakan na profetas winnu foon? Akammù wi tuttuwaom!” ");
INSERT INTO ksc_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ngim anan Ali Agripa, “Anam pun nu mallasun mangawisam an saon ta mamfalinà Cristiano?” ");
INSERT INTO ksc_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Ad anan Pablo, “Uray nu mallasu winnu foon, na iluwarù an Apudyus, ta sia ya uray losan na anchanay manchochongngor ta ifakà, mamatiayu losan an Apu Jesus, à isun na namatiyà. Is-isuwonyu otyan losan à saon, naraksig yakan annayay kachilà!” ");
INSERT INTO ksc_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Sachi ad, summiad na Ali, ya fifinnachur ya Bernice ya losan chachi nakatùchun chicha, ad lummawacha. ");
INSERT INTO ksc_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Ad nan-uukudcha anani, “Maid met fasurnà umanay à mapatoyana, ya uray mifaruchana.” ");
INSERT INTO ksc_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ad anan ako Agripa an Festo, “Miparufus kuma nu foon pù iparangnan kasusna ta Emperador.” ");
INSERT INTO ksc_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Chummatong pun na padchay lumayawannin Pablo wi umoy ad Italia, impiyarchà Pablo ya uchumi farud an Julio, wi siyan kapitan na susurchachun na Emperador. ");
INSERT INTO ksc_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ad nallukan-ani ta osay papur wi narpud Adrumeto wi umoy ta il-ilid Asia. Nifurun akon chianì Aristarco wi iMacedonia wi narpud Tesalonica. ");
INSERT INTO ksc_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Nafikat pun, nansapaanid Sidon, ad kapu ta kinaasiyan Julio à Pablo, imparufusnan lumogsachana ta papur, wi umoyna fusitaon na fufurunna ta sachi ili, ta mafalini adchonchan siyan masapurna. ");
INSERT INTO ksc_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Asin-ani pu lummigwat, linausannid Chipre ta ikidnay malingchan, tan sib-aton na lukannin fidfid. ");
INSERT INTO ksc_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Lin-usanni pun na fayfay ta chomang na provinsiya wi Cilicia ya Pamfilia, chummatong-anid Mira wi sakupon Licia. ");
INSERT INTO ksc_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ad sachin nangchasan Kapitan Julio ta osay papur wi narpud Alejandria wi umoy ad Italia, ad sachin nallukananni. ");
INSERT INTO ksc_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Inyom-omman na lukanni tan napigsan fidfid, ad siyan nafayakanni wi chummatong ad Gnido. Ad kapu ta pummigpigsan fidfid, achiani pu makaturuy ta pionni wi ayon, siyan nalliglig-ani ad innoynin malingchan wi ikid Creta wi lausannid Salmon. ");
INSERT INTO ksc_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ngim uray nu nangììikid-anid Creta, napalikatan-ani ingkana ta chummatnganni ta nginachananchà Mamfarù Chichissaakan na Papur wi achani ta ilid Lasea. ");
INSERT INTO ksc_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Kapu ta nataktak-anì nafayag ta fidfid, kaog-ogyat na mallukan ta papur, tan imfabfali. Siyan finilin Pablò chicha, anana, ");
INSERT INTO ksc_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Fufurun, nu ipapilittau ituruy, akammù wi achun machachail ta karkatau ya uray na annay papur, ya awad akon matoy.” ");
INSERT INTO ksc_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ngim na kapitan, achina pu pintog na imfakan Pablo, tan siya pintogna kan imfakan na ngimpapur ya mammamakkiyona. ");
INSERT INTO ksc_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Na kaachuwan ako wi karukanni, pionchay mangituruy, tan foon pu nù mamfarun sachi ikaw à ingkawan na papur nu imfabfali. Siyan ananchay ipachasni ichatong ad Fenix wi sakupon Creta, ta siyan ingkawantau tan imfabfali, tan mamfarù chichissaakan, tan foon pù sakungonan narpuwan na fidfid. ");
INSERT INTO ksc_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Sachi ad, chummatong na fidfid wi narpud chaya, ad ananchay mafalini ituruychan puranucha. Siyan kinuyudcha impangatun chagsonani aka wi mampaillong ta papur, ad nalligwatcha wi mangììikid ad Creta. ");
INSERT INTO ksc_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ngim panopanos ad, chummatong na napigsay fidfid wi narpu ta lakud Creta. ");
INSERT INTO ksc_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ad chinarapusnan papur, ad maid pu in-inonchay mansakung ta fidfid, siyan impaiturungni ta fidfid. ");
INSERT INTO ksc_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Niyachaniani pun ta chayan na ilid Cauda, sachin nawayaanni wi nangilukan ta fangka wi kuykuykuyon na papur, tan nalingchan-anì ait, ngim napalikatan-ani ko. ");
INSERT INTO ksc_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Narpas pun na sachi, finofodchan long-ag na papur à chakorani tali ta achi machosyang na tabrana. Inchòoracha kon ar-arawway luput ta miyin-innayad mifidfid na papur, tan machanakanchà ichakus na papur ta kallikallis wi luta ta chomang Libya. ");
INSERT INTO ksc_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Nafikat pun, kassiyan fali wi napigsa, siyan illukichay mangitop-ar ta karka ta fayfay, ta lumangpaw. ");
INSERT INTO ksc_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Na atlun padchana, intop-archa kon uchumi lamintan na papur. ");
INSERT INTO ksc_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Lummaus pun na apadchapadcha, wi achiani pu nakaila ta init ya fituwon, ad kassiyay mamidfifidfid à napigsa, na somsomòni, maid pu namnamanì mataku. ");
INSERT INTO ksc_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nafayag pu ko wi maid pu nangnangan, summiad à Pablo, ad anana, “Fufurun, nu pintogyun imfakà wi iningkawtau kuma ad Creta, maid nachachail ya natarà. ");
INSERT INTO ksc_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ngim uray, achiayu machismaya, tan maid pu matoy an chitau! Afus na papur à mayam-an. ");
INSERT INTO ksc_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Imfakà na amaschi, tan na lafi, à Apudyus wi chaychayawò, wi ngintakun saon, imfaunnan anghel an saon, ");
INSERT INTO ksc_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ad anana, ‘Pablo, achia umogyat, tan maid pu mapasamak an sia, tan masapur maimfistikar-a ta sangwanan na Emperador. Ad mipakapu kon sia, kinaasiyan ako Apudyus na karukannu wi maid pun matoy an chicha.’ ");
INSERT INTO ksc_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Siyan papigsaonyun somsomòyu, fufurun-u, tan sikurachuwò wi oyyoon Apudyus losan na imfakana. ");
INSERT INTO ksc_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ngim masapur mifalin papur ingkanà mipanad ta osay luta wi nangkawaon na fayfay.” ");
INSERT INTO ksc_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Lummaus ad na chuway chumingku, issiyay nifalin papur ta kawan na fayfay ad Adriatico. Kawan ad na lafi, inorman chachi mammamanihu wi umachaachaniani ta luta. ");
INSERT INTO ksc_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ad inisongchan arofong na chanum, ad chuwampuruy chopa. Chummàanicha pu kò ait, asincha ko inisong, ad nasawaran à limay chopan arofongna. ");
INSERT INTO ksc_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Sachin ummogyatanchà michongpar na papur ta fattufattu. Siyan inchòorachan opati man-achagson wi aka ta agkimut na papur à mampaillong, ad nalluwarucha ta achi pu otyan mafayag na mafikatana. ");
INSERT INTO ksc_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ngim na mammamanihu ta papur, pionchay umawid. Siyan inchòorachan fangka ta fayfay, wi akin-iigkacha ta uchumi aka ta sangwanan na papur. ");
INSERT INTO ksc_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ngim anan Pablo ta kapitan ya susurchachuna, “Nu lumayaw chachi uchum ta papur, maid pu osà matakun chitau.” ");
INSERT INTO ksc_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Sachi ad, kinsat na susurchachun talin na fangka ta ilayaw na challuyun. ");
INSERT INTO ksc_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Nganngani pun mafikat, inàarù Pablo chachi taku ta mangancha. Anana, “Miyagway chumingku ta sana wi maid pu ustù nangananyu, tan nafayfay-anan ta ogyatyu. ");
INSERT INTO ksc_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Siyan mangan-ayu ta awad iyatakuyu. Achiayu machanakan, tan maid pu mapasamak an chitau.” ");
INSERT INTO ksc_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Sachi ad, nangarà Pablò tinapoy, ad nanyaman an Apudyus ta sangwanancha losan. Narpas pun, pinotlàna ad illukinay mangan. ");
INSERT INTO ksc_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Na nangil-ancha ta sachi, nasorkagcha nakaan. ");
INSERT INTO ksc_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Na am-amungni losan ta papur, umoy à 276. ");
INSERT INTO ksc_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Narpas-ani pun nangan losan, nantop-archa ta karkachay ilì ta lumangrangpaw na papur. ");
INSERT INTO ksc_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Fummigfikat pun, intap na mammamanihun luta, wi ikid na fayfay. Achicha pu makailasin nu sinuy ili, ngim innilachan nisùyu wi kallis na tarantagna, ad anancha pun nu mafalini ikalikatanchay iturung na papur ta sachi. ");
INSERT INTO ksc_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Siyan kinsatchan tali wi nitàchan na aka, ta milutongcha, ad inobfadchan tali wi nanangchon ta tabra wi mangiturung ta umayan na papur. Ad impasadsadchan ar-arawway luput wi iningkaw ta sangun na papur ta itùyud na fidfid ta tarantag. ");
INSERT INTO ksc_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ngim nikarad na papur ta kallis ad achi pun chumàani, tan nisufag na sangun na papur. Ad na agkimutna, tupatupakan na challuyun, ad naachuas-as. ");
INSERT INTO ksc_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Sachi ad, simsimmò na susurchachu wi patoyoncha losan na farud ta maid pu man-iyat umawid an chicha. ");
INSERT INTO ksc_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ngim impalit na kapitan, tan pionay matakù Pablo. Imfakana ta pumaytù ta fayfay na losani makaiyat ta umunacha umoy ta tarantag, ");
INSERT INTO ksc_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ad umun-unud na uchum wi mampataw ta tabra winnu farangnay ayuy partin na papur. Ad sachin iningwani losan ad farfaruani wi chummaum ta tarantag. ");
INSERT INTO ksc_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Chummaum-ani pun ta tarantag, sachin nangakammuwanni wi Malta na ngachan na sachi ili wi nangkawaon na fayfay. ");
INSERT INTO ksc_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Na ummili ta sachi, minangilichà chiani. Nan-apuychà man-anichuwanni, tan ummuchauchan ya tungnin. ");
INSERT INTO ksc_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Ad à Pablo, namaur à simposot. Ngim itunguna pun ta apuy, narnoswan urog, ad inobfanan iman Pablo, wi nipanitil. ");
INSERT INTO ksc_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Innilan pun chachi ummili na urog wi mitatayyun ta imana, nan-ag-akitùtùcha, “Sikurachuy pumappatoy na sanati larai, tan uray lummasat ta fayfay, inchasanan kachusaana.” ");
INSERT INTO ksc_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ngim à Pablo, yinagyagnan urog ta apuy, ad maid nasukat an siya. ");
INSERT INTO ksc_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Chachi ummili, anancha pun nu lumtog na imana winnu matuwad matoy. Ngim nafayagcha pun wi nanguullay wi maid pun iniilachà napasamak, finaliwanchan somsomòcha, tan anancha, “Siyan osay apudyus!” ");
INSERT INTO ksc_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Foon pù achayun sachi lukar wi iningkawanni ta lutan Publio wi pangpangun na takud Malta. Ad minangilinà chianì turuy padcha. ");
INSERT INTO ksc_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ad niyaspur wi na aman Publio, napanating ya nantili. Ummoy Pablo finisità siya, ad illuwaruwana pun, impataynan imanan siya, ad naanimfag. ");
INSERT INTO ksc_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Nachamag pun na nàwan siya, ummoy an Pablo na losani mansaksakit ta ili, ad impaimfagna chicha. ");
INSERT INTO ksc_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ad-adchuwan na mamfaruy innadchonchan chiani, ad na lummayawanni, inyalicha ko losan na masapurni ta charan. ");
INSERT INTO ksc_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Naturuy furanni pun ad Malta, nallukan-ani ta osay papur wi narpud Alejandria wi iniingkaw akod Malta ta imfabfali. Na markan na sachi papur, apil wi sinan-Apudyuscha. ");
INSERT INTO ksc_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Chummatong-ani pun ad Siracusa, iningkaw-anì turuy padcha. ");
INSERT INTO ksc_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Namparpuanid Siracusa, ad ummoy-anid Regio. Ad nafikat pun, nallukin poyaaw ad chaya wi narpuwanni, siyan nalligwat-ani asin, ad na agwan padchana, chummaum-anid Puteoli. ");
INSERT INTO ksc_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Inchasanni ta sachin uchumi mamatin Jesus, ad tinawichan chiani ta ingkaw-anin chichà sinchumingkuwan, achianiwot manadcharan umoy ad Roma. ");
INSERT INTO ksc_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Chinamag pun na mamatid Roma wi marungay-ani, lummigwatchay mangafot an chiani ta achayu. Na uchum, inafotchà chiani ta ikaw wi nginachananchà Market Appio, ad na uchum, ta ikaw wi nginachananchà Turuy Maafangani Foroy. Innilan pun Pablò chicha, nanyaman an Apudyus, ad nasorkag na somsomòna. ");
INSERT INTO ksc_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Na chummatngannid Roma, imparufuscha wi man-afang à Pablo ta osay foroy, ta foon pù fafalluchan na ingkawana, ngim makukuwarchaan à osà surchachu. ");
INSERT INTO ksc_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Apat padchana pun, impaayag Pablo na pangpangun na Judio wi iningkaw ad Roma. Naaruscha pun, ananan chicha, “Susunud-u, maid pu iningwà à lawing ta chokatauy Judio. Ad maid pu ko sinurngasing-u ta ukalitauy intudtuchun na achakchakrantau. Ngim impaifarud na Judiò saon ad Jerusalem, ad incharumchà saon ta chachi iRoma ad aschi. ");
INSERT INTO ksc_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Inimfistikar pun na chachi iRomà saon, pionchay mangiparufus an saon, tan maid inchasanchà umanay à mapatoyà. ");
INSERT INTO ksc_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ngim lawingon na chokatauy Judio na miparufusà, siyan kapilitani iparang-un kasus-u ta Emperador. Ngim achì pu icharum chicha. ");
INSERT INTO ksc_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ad siyan puun na nangipaayakà an chiayu, ta man-uukudtau, tan piò wi ipaakammun chiayu na ustuy puun na nakakadchilaà. Mipuun ta pammatì ta sachi namnamaontauy kanà Israel.” ");
INSERT INTO ksc_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ad ananchan siya, “Maid met inawatnì surat à narpud Judeà mipangkop an sia. Uray na chokatau wi narpuschi, maid ako impachamagcha winnu inisturyachà lawing à iningwam. ");
INSERT INTO ksc_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ngim akammuni wi parwingon na taku ta ailiili na fufurunnu wi manursurut an Jesus, siyan pionni wi chongron na kasomsom-am.” ");
INSERT INTO ksc_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ad inuukudchan padchay asincha maarusan man-uukuchan. Ad nachauman pun na sachi padcha, ummad-adchuwanchay ummoy ta ingkawan Pablo. Ad illukin Pablo ta figfikat ingkanà lummafi wi mangisuplikar ya mangistikun chicha mipangkop ta Manturayan Apudyus. Insuplikarna kon inyug-is Moses ya chachi profetas mipangkop an Jesus ta awisona otyan chichà mamatin Jesus. ");
INSERT INTO ksc_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ad naawis na uchum ta imfagfakana, ngim na uchum, foon pù mamaticha. ");
INSERT INTO ksc_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Siyan na nafuarancha, nan-agwacha, ad nan-is-isìcha. Tan na chaancha pun mafuaran, anan Pablo wi nangiyukawid, “Tuttuwan impaiyug-is na Ispiritun Apudyus ta sachi profetay Isaias mipangkop ta achakchakrantau, ");
INSERT INTO ksc_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","tan ananan Isaias, ‘Ing-a ifaka ta anchanayay taku: Uray chochongronyun ifakà, achiyu pu maawatan. Uray nu iillanyun ipailà, achiyu pu imatunan. Sachin ifakam an chicha, ");
INSERT INTO ksc_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","tan na anchanayay taku, kapu ta natangkin na urucha, achicha pu atinguron na ifagfakà ya mangkikimitcha koy umisì ta achicha iillan à saon, tan lawingonchay chongron ya maawatan na ifagfakà, ya achicha pu ko mansakung an saon ta pafaruwò chicha.’” ");
INSERT INTO ksc_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Ad inyukawid Pablo anani, “Siyan piò wi mangipaakammun chiayu wi awad chachi imfaun Apudyus wi mangipagngor ta foon à Judio ta mipangkop ta manaraknifana ta taku, tan chumngarcha!” ");
INSERT INTO ksc_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Narpas ad wi imfakan Pablo na sachi, nafuar chachi Judio wi nan-is-isìcha. ");
INSERT INTO ksc_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Chuway tawon na iningkawan Pablo ta foroy wi inafanganad Roma, ad linispituna losan na namasyar an siya. ");
INSERT INTO ksc_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Impagngopagngornan mipangkop ta Manturayan Apudyus, ad intudtuchuna kon mipangkop an Apu Jesu Cristu, tan maid pu nangipalit an siya.");
INSERT INTO ksc_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","À saoni Pablo wi mansilfin Jesu Cristu, chinutukanà à man-apostoles ya piniyarà an Apudyus à mangifaka ta Mamfaruy Chamagna. ");
INSERT INTO ksc_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Na Mamfaruy Chamag Apudyus, impustana ta awi, ad impaisuratna ta chachi profetasna. ");
INSERT INTO ksc_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Na sachi Chamag, mipangkop ta Anàna wi Aputauy Jesu Cristu. Na kinatatakuna, niyanà ta kanà David, ");
INSERT INTO ksc_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ad na kina-Apudyusna ko, nipaila wi siyan mannakafalini Anà Apudyus ta ummuliyana natakuwan. ");
INSERT INTO ksc_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Mipakapun Jesu Cristu, inachakuwanà an Apudyus ad chinutukanà à man-apostolesnà umoy mangifaka ta mipangkop an siya ta losani taku ta mamaticha. ");
INSERT INTO ksc_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ad sachin nitapiyanyu ko, chiayuy mamatid asnati Roma, tan chinutukan Apudyus chiayu kò mamatin Jesus à mantakuna. ");
INSERT INTO ksc_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ad siyan annayan surat-un chiayu losan ad asnat wi ay-ayaton Apudyus ya chinutukanà mantakuna. Sapay kuma ta fadngan chiayu losan an Amatauy Apudyus ya Aputauy Jesu Cristu, ya patarnaoncha kon somsomòyu losan. ");
INSERT INTO ksc_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Umunaà manyaman an Apudyus mipakapun Jesu Cristu mipangkop an chiayu losan, tan nanchinamag na pammatiyu ta ailiili. ");
INSERT INTO ksc_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Akammun Apudyus wi tuttuwan ifakà, wi siyan mansilfiyà à patingkan na karobfongà wi mangitudtuchu ta Mamfaruy Chamag mipangkop ta Anàna. Siyan akammuna wi nu malluwaruwà, kanayun-u itapi chiayu. ");
INSERT INTO ksc_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Na osay chawatò an Apudyus, nu mafalin, ta iparufusà kuma wi umalid asnat mangilan chiayu. ");
INSERT INTO ksc_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Tan piò isag wi mangilan chiayu, tan awad na itudtuchù an chiayu wi narpu ta Ispiritun Apudyus ta pumigsan pammatiyu. ");
INSERT INTO ksc_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Na piò wi ifaka, man-asisorkagtau ta pumigsan pammatitau. ");
INSERT INTO ksc_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Susunud, maawatanyu kuman annaya, wi namin-anuy pinuranù wi umali mangilan chiayu ngim natipotipochà. Na piò, umalì tudtuchuwan na uchum ad asnat ta mamaticha ko wi isun na nantudtuchuwà ta uchumi foon à Judio ta uchumi ili. ");
INSERT INTO ksc_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Tan sachin impurang Apudyus an saon, ad masapur songfatà an siya nu achì pu oyyoon. Ad sachin isù utang-u ta losani taku ta annay luta, uray naachar ya foon, ya uray chachi machayaw ya foon. ");
INSERT INTO ksc_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Siyan isag-u pion wi umali mangitudtuchu ta Mamfaruy Chamag an chiayu ko ad asnati Roma. ");
INSERT INTO ksc_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Sikurachuwà mipangkop ta Mamfaruy Chamag, tan siyan mangifaka ta mannakafalin Apudyus wi manaraknib ta sinumani mamati, wi umunaani wi Judio achiwot ta foon à Judio. ");
INSERT INTO ksc_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Tan na Mamfaruy Chamag, siyan mangifaka ta inyòoyyan Apudyus wi mangifilang ta takù mamfarun siya. Ya maid uchum à mangifilangana ta takù mamfaru nu achi afus na pammaticha. Tan sachin imfakan na niyug-is wi ukudna, wi anana, “Na takuy mifilang à mamfaru an Apudyus kapu ta pammatina, makafiyag an siyà ing-ingkana.” ");
INSERT INTO ksc_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Nifafagkan amochi og-ot Apudyus ta losani managfasur wi foon pù mamati ya mangwamangwà lawing. Na lawingi oy-oyyooncha, sachin mangipalit ta mamatiyancha ta katuttuwaan wi mipangkop an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Siyan chuchussaon Apudyus chicha tan narawag met an chichan losani maakammuwan mipangkop an Apudyus, tan inlawag Apudyus. ");
INSERT INTO ksc_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Tan uray achi pu mailà Apudyus, mamàilan kina-Apudyusna ya mannakafalinna wi maid pagpagna. Tan nanipud ta nangwaana ta luta, narawag na mipangkop an siya, tan na losani iningwana chichan mail-an na mipangkop an siya. Siyan maid pu lasun na takù achicha pu mamatiyan an siya! ");
INSERT INTO ksc_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ngim uray akammun na takun mipangkop an Apudyus, achicha pu chayawon à siya, ya achicha pu ko manyaman an siya. Siyan summafalin somsomòchà maid kutùna, ad fummulingot na somsomòcha ingkanà maid pu maawatanchà mipangkop an siya. ");
INSERT INTO ksc_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Na anancha naraingcha, ngim ningningcha! ");
INSERT INTO ksc_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Tan à chicha, inwarangchay manaychayaw ta tuttuway Apudyus wi matatakù ing-ingkana, ad siya chaychayawoncha chachi iningwan na imachà man-apudyuscha wi sinantakun uchum ya sinansissiwit ya sinan-animar ya sinan-urog akon uchum. ");
INSERT INTO ksc_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Siyan kapu ta sachi, winayaan Apudyus chichà mangwa ta farangnay lawing wi pion na long-agcha, siyan maid achicha oyyoon à lawing à mangusarancha ta long-agcha. ");
INSERT INTO ksc_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Na lukin na amaschi, foon pù patiyonchan akammuchay katuttuwaan wi mipangkop an Apudyus, ad sinukatanchan katuttuwaan wi mipangkop an Apudyus à turtulli. Tan chayawoncha ya patkancha chachi iningwan Apudyus. Ngim afus kumà Apudyus à chaychayawonchà ing-ingkana! Amen. ");
INSERT INTO ksc_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Siyan kapu ta sachin oyyooncha, winayaan Apudyus chichà mangwamangwa ta sachi lawing ya afafain wi narpu ta pipion na long-agcha. Siyan uray na uchumi fubfufai, mantintinnanungcha wi mangwa ta afafain wi achi pu kuma màwa. ");
INSERT INTO ksc_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ad uray na uchumi lallarai ko, wi foon à fufain asaw-oncha ngim mantintinnanungchay lallarai. Siyan kaisaw ya afafain na oy-oyyooncha. Siyan machuchusacha kapu ta sachi safali wi oy-oyyooncha. ");
INSERT INTO ksc_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Siyan kapu ta foon pù patkonchà Apudyus, finayfay-ana chicha, ta oyyooncha kan farangnay foon pu kumà oyyooncha. ");
INSERT INTO ksc_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Siyan maid achicha oyyoon à lawing tan mangkamkakamkamcha ya lawingonchan fufuruncha, ya maaposcha ko ya pumappatoycha, ya mansusukobcha ya losancha man-asisilib ya man-asiliud. ");
INSERT INTO ksc_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Ya man-asiukudchà lawing, ya lawingonchà Apudyus, ya man-iyaamischan asintatakucha. Ya mamaspas-archa ya mamadpachayawcha, ya am-amchonchay mangwà lawing. Ya achicha pu patkon na chachakkorcha. ");
INSERT INTO ksc_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Maid somsomòchà mamfaru, ya achicha pu oognan na impustacha, ya maid sayaawcha winnu achakucha ta uchumi taku. ");
INSERT INTO ksc_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Chachi taku, uray nu akammucha wi chuchussaon Apudyus à ing-ingkana na losani mangwa ta kakassachi, ipapilitcha ko kay oyyoon. Ya mamfaruwoncha ko chachi uchumi mangwa ta kakassachi. ");
INSERT INTO ksc_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Siay mangukum ta kinarawing na uchum, achim anani ilisim na machusaam an Apudyus, uray sinuay taku. Tan nu ukumom na kinarawing na uchum ya iningwam na oy-oyyooncha, siya oyyoom akon machusaam an Apudyus. ");
INSERT INTO ksc_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ad maaawwatantau wi nalimpiw à Apudyus ta pinagkuisna ta sinumani mangwà lawing. ");
INSERT INTO ksc_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ngim siay mangukum ta kinarawing na uchum, wi siya kon oy-oyyoom, anam pun nu mailisim na kachusaam