﻿USE sofia;
DROP TABLE IF EXISTS sofia.krx_vpl;
CREATE TABLE krx_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES krx_vpl WRITE;
INSERT INTO krx_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ti púcook pa, Pútuun pa mpiliil patiila niŋ t’etaam. ");
INSERT INTO krx_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Fiye, etaam ya etaakut himuum etaakut likee pale man meeliiñoole ummuhootan etaam ya púlooŋ. Enímaan néewufalool pásune man ma. Kunuu ka kiti Pútuun pa nkiyeno káleeleehan patiila etemmo. ");
INSERT INTO krx_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Púful toko, Pútuun pa mpusok: “Ecaaŋ etaako!” Ecaaŋ ya neetaako. ");
INSERT INTO krx_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Pútuun pa mpucuk nii ecaaŋ ya enapaanap. Fiye, mpíkatinool ecaaŋ ya niŋ énimaan ya. ");
INSERT INTO krx_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Pútuun pa mpulu ecaaŋ ya “hanakan”, mpulu lompo énimaan ya “hánant”. Intaako kániim intaako lompo pucom: hikina hiyem hinoom ha híyaañ ha. ");
INSERT INTO krx_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Púful toko, Pútuun pa mpusok: “Káahaaŋ kitaako ti pututa man ma kípikatinool man ma miti patiila niŋ miti t’etaam!” ");
INSERT INTO krx_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Fiye, Pútuun pa mpíhin káahaaŋ ka, mpíkatinool man ma miti patiila niŋ miti t’etaam, iyyeno fo. ");
INSERT INTO krx_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Pútuun pa mpulu káahaaŋ ka “patiila”. Intaako kániim intaako lompo pucom: hikina hiyem hinoom ha hísupiyenu ha. ");
INSERT INTO krx_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Púful toko, Pútuun pa mpusok: “Man ma meeyem ma t’etaam muconcool nantoonool, etaam eesuuce éfulii!” Iyyeno fo. ");
INSERT INTO krx_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Pútuun pa mpulu etaam ya eesuuce ya “etaam”, mpulu lompo man ma meeconcooliye ma “kaatii”. Pútuun pa mpucuk nii napaanap. ");
INSERT INTO krx_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Fiye, Pútuun pa mpusok: “Etaam ya epukool píheeni óo píheeni empa mpitaak etukal, niŋ enuun óo enuun eyya netaak ñaliyal niŋ pukoon!” Iyyeno fo. ");
INSERT INTO krx_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Etaam ya néepukii píheeni óo píheeni empa mpitaak etukal etempo, niŋ enuun óo enuun eyya netaak paliyal eteyyo niŋ pukoon eteyyo. Pútuun pa mpucuk nii napaanap. ");
INSERT INTO krx_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Intaako kániim intaako lompo pucom: hikina hiyem hinoom ha híhaaciyenu ha. ");
INSERT INTO krx_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Púful toko, Pútuun pa mpusok: “Waah úsupak ewwa nuucaaŋan utaako patiila kati úkatinool hánant ha niŋ hanakan ha! Waah ewwuu úyisan ñahaaño ña, kunoom ka niŋ sitiil sa, ");
INSERT INTO krx_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","uyeno patiila upucaaŋan t’etaam!” Iyyeno fo. ");
INSERT INTO krx_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Pútuun pa mpíhin waah úsupak wenfakat ewwa nuucaaŋan: weehaŋe wa pafom nuumankool hanakan ha; weehaŋe wa káafomaati nuumankool hánant ha; mpíhin lompo picaaŋaŋ pa. ");
INSERT INTO krx_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Pútuun pa mpisiiŋan wo patiila upucaaŋan t’etaam, ");
INSERT INTO krx_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","kati umankool hanakan ha niŋ hánant ha núukatinool ecaaŋ ya niŋ énimaan ya. Pútuun pa mpucuk nii napaanap. ");
INSERT INTO krx_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Intaako kániim intaako lompo pucom: hikina hiyem hinoom ha hípaakiilenu ha. ");
INSERT INTO krx_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Púful toko, Pútuun pa mpusok: “Kaatii ka kimeeŋ niŋ soon niŋ pikee púlukuleen, pusuwa píyititool patiila niŋ t’etaam!” ");
INSERT INTO krx_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Fiye, Pútuun pa mpiliil púlukuleen penfakat piti kaatii, niŋ lompo élukuleen óo élukuleen eyya newac niŋ esuwa óo esuwa. Pútuun pa mpucuk nii napaanap. ");
INSERT INTO krx_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Pútuun pa mpisampan po mpusok: “Nipukool nimeeŋan kaatii ka, pusuwa pa lompo pimeeŋ t’etaam!” ");
INSERT INTO krx_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Intaako kániim intaako lompo pucom: hikina hiyem hinoom ha hísakiyenu ha. ");
INSERT INTO krx_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Púful toko, Pútuun pa mpusok: “Etaam ya etaak élukuleen óo élukuleen: puwuluwul niŋ piti elampa, penkilis niŋ penfakat!” Iyyeno fo. ");
INSERT INTO krx_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Pútuun pa mpíhin élukuleen óo élukuleen ewuluwul niŋ élukuleen óo élukuleen eti elampa, enfakat niŋ enkilis. Mpucuk nii napaanap. ");
INSERT INTO krx_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Fiye, Pútuun pa mpusok: “Umemanoolaa an éefule unaa, samat nii unaa, apiyeno ati hikaw ha ati soon sa, pusuwa pa niŋ púlukuleen pa púlooŋ: puwuluwul pa niŋ piti elampa ya, penfakat pa niŋ penkilis pa empa mpumuusool pa t’etaam.” ");
INSERT INTO krx_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Pútuun pa mpiliil an éefule po, áyiin niŋ aal Pútuun pa mpiliile. ");
INSERT INTO krx_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Pútuun pa mpisampanii mpusokii: “Nipukool, nimeeŋan etaam ya inniheek yo! Niyeno pakati kikaw eteyyo, kiti soon sa, pusuwa pa, niŋ púlukuleen pa púlooŋ empa mpumuusool pa t’etaam!” ");
INSERT INTO krx_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Fiye, Pútuun pa mpusok: “Nísiitan, inci ufanaa aluu píheeni óo píheeni empa mpitaak pukoon, niŋ enuun óo enuun eyya netaak paliyal ti etaam ya púlooŋ. Pukoon pa niŋ ñaliyal ña efiñiyeno pákuumanal aluu. ");
INSERT INTO krx_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Pale púlukuleen pa púlooŋ piti elampa ya niŋ pusuwa pa púlooŋ niŋ púlukuleen pa púlooŋ empa mpumuusool pa t’etaam, inci ufanaawufan po píheeni pa niŋ pahatal pa púlooŋ piti punuun pa pipiyeno pákuumanal etempo.” Iyyeno fo. ");
INSERT INTO krx_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Pútuun pa mpucuk nii eeha mpíhine ha púlooŋ hinapaanap meemak. Intaako kániim intaako lompo pucom: hikina hiyem hinoom ha heewase ha isak niŋ hoonool. ");
INSERT INTO krx_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Fiyuu hiliiluyee ha hiti patiila niŋ t’etaam niŋ waah óo waah weeyem lupo nihipaye. ");
INSERT INTO krx_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ti hinoom ha heewase ha isak niŋ kúsupak loho Pútuun pa pipayaa páhin etempo mpíyekunoolo ti heewase ha isak niŋ kúsupak. ");
INSERT INTO krx_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Pútuun pa mpisampan hinoom ha heewase ha isak niŋ kúsupak, mpíhin ho hipiyeno hinoom etempo, kaatuko hinoom eehuu Pútuun pa mpíyekunooliye ta mpipaye ta páhin etempo púlooŋ piti hiliilu ha. ");
INSERT INTO krx_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Fiye Ateeteyo Pútuun pa mpiliile patiila niŋ t’etaam. Ta Ateeteyo Pútuun pa mpimemanoole ta patiila niŋ t’etaam, ");
INSERT INTO krx_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","punuun niŋ píheeni piti ukit píŋantiyoot, kaatuko Ateeteyo Pútuun pa púnupaniyoot etiil, an lompo ataakiit toko kati aya etaam ya, ");
INSERT INTO krx_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","pale man úmmufulii t’etaam ímmimaañiyan etaam ya púlooŋ. ");
INSERT INTO krx_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Púful toko, Ateeteyo Pútuun pa mpiliil áyiin niŋ esiya. Mpúfuuteen ti síinuyoo esuuŋut eti eloŋ, áyiin a náayenoonii an aŋa eeyem kaloŋa. ");
INSERT INTO krx_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Fiye, Ateeteyo Pútuun pa mpusuk kankaŋ Eden pa caanak ca íncifulii pa, toko mpiyenane áyiin a aŋa mpiliile ya. ");
INSERT INTO krx_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ateeteyo Pútuun pa mpíhin enuun óo enuun épiŋantii: punuun peewalla empa mpupuk paliyal péesuume. Ti pututa kankaŋ ya, intaako toko enuun eti eloŋ niŋ enuun eti kameye heenape ha niŋ heenaput ha. ");
INSERT INTO krx_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ti kankaŋ ya eti Eden, intaako han henfakat eeha níhimaañiyan etaam ya eti kankaŋ ya. Ta níhifulii ta ti kankaŋ ya, níhipaacinoolo kan kipaakiil. ");
INSERT INTO krx_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Han ha híyaañ ha nihisokee Pison, hikina híkinkoole mah ma miti Hawila. Toko taakaataak sanoo, ");
INSERT INTO krx_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","sanoo eti pánipani. Intaak lompo pínankiin péeciita hinoom, niŋ punuun empa an naayina éfulanii tempo caminkoloŋ éesuumut hicuku. ");
INSERT INTO krx_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Hísupiyenu ha nihisokee Kihon, hikina híkinkoole mah ma púlooŋ miti Kus. ");
INSERT INTO krx_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Híhaaciyenu ha nihisokee Tikil, hikina hiyem pa caanak ca íncifulii pa ti saatee ya eti Asul. Hípaakiilenu ha nihisokee Efalat. ");
INSERT INTO krx_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Fiye, Ateeteyo Pútuun pa mpucoop áyiin a mpiyenanoo ti kankaŋ ya eti Eden kati aya yo naamankool yo. ");
INSERT INTO krx_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ateeteyo Pútuun pa mpusok áyiin a: “Aáyiniyini hili papukal pa piti punuun pa púlooŋ piti kankaŋ ya. ");
INSERT INTO krx_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Pale, aañaŋut hili papukal pa piti enuun ya eti kameye ka heenape ha niŋ heenaput ha, kaatuko hinoom eeha aafali papukal enuun eyyuu, aafaket.” ");
INSERT INTO krx_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Púful toko, Ateeteyo Pútuun pa mpusok: “Naput áyiin a apiyeno lamayoo. Inci faliiloo ayankanana eenape eenakoole neyoo.” ");
INSERT INTO krx_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ateeteyo Pútuun pa mpiliil niŋ esiya élukuleen óo élukuleen eti elampa niŋ esuwa óo esuwa. Mpucoop po ti áyiin a kati aluwal po ucaw. Elúkuleen óo élukuleen eñaŋaa hitaaku caacaw enca áyiin a naaluwe yo. ");
INSERT INTO krx_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ayíin a naaluwal púlukuleen pa púlooŋ ucaw: puwuluwul pa, piti elampa ya niŋ pusuwa pa. Pale ataakut ayankanana eenape eenakoole neyoo. ");
INSERT INTO krx_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Fiye, Ateeteyo Pútuun pa mpíhin áyiin a apunow ti hiŋotu henfakat. Akina ti hiŋotu ha, mpúfulanii káakut ti kahehoo, mpipa mpiñahan toko kapaŋoo samat nii fa nkiyeniye fa. ");
INSERT INTO krx_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Púful toko, Ateeteyo Pútuun pa mpucoop káakut ka enka mpúfulanii ka ti áyiin a, mpiliil aal, mpucoopoo pati áyiin a. ");
INSERT INTO krx_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ayíin a naaceek: “Tempe, aŋe anakoolam, picec unii poonool, hísim unii hoonool, afaayonkalee 'aal' kaatuko ti áyiin náafulaniyee.” ");
INSERT INTO krx_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ekina ewune áyiin nakatan faafoo niŋ íññaayoo naananf aaloo, poko t’ésupakii nkáyenoonii oonool. ");
INSERT INTO krx_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Fiye áyiin a niŋ aal a nkayeno ñáfalfali pale kasuuwoolut. ");
INSERT INTO krx_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Fiye, epululoola ya ehaŋa ecohato ti púlukuleen pa púlooŋ piti elampa empa Ateeteyo Pútuun pa mpiliile pa. Neesok aal a: “Fo pánipani Pútuun pa pusokaasok aluu nii: 'Niñaŋut hili enuun óo enuun eti kankaŋ ya?'” ");
INSERT INTO krx_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Aal a naañahan epululoola ya: “Haani, úyiniyini nuuli enuun óo enuun eeyem ti kankaŋ ya. ");
INSERT INTO krx_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Pale Pútuun pa pusok 'Niñaŋut hili enuun ya eeyem ya ti pututa kankaŋ ya, niñaŋut yo híliku niŋ ekina tom efiniket.'” ");
INSERT INTO krx_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Epululoola ya neeñahan aal a: “Hitaakiit etiniket! ");
INSERT INTO krx_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kaatuko Pútuun pa pímeyimeyi nii, hinoom eeha efinili papukal enuun eyyuu, ñíkin aluu éfiñipankino innicuk nii pikina, ínnimeyi heenape niŋ heenaput.” ");
INSERT INTO krx_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ta aal a naacuke ta nii papukal pa piti enuun ya pinapaanap hili mpúwalli ti ñíkinoo illompo nonkoo kati ataak kameye enka efipuwufanoo ka, naacut po naali, naawufan áyiinoo eesiiŋiye ya pukoloo apili lompo. ");
INSERT INTO krx_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Tokotoko, ñíkinii poko t’ésupakii íññipankino nkacuk nii ñáfalfali nkayem. Fiye, nkacenkanool pahatal sootoo nkáhin po uhuuy. ");
INSERT INTO krx_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ta incisape ta eyam, Ateeteyo Pútuun pa mpiyeno kaakaawool ti kankaŋ ya. Ayíin a niŋ aal a nkási pakakal etempo, nkayolo ti punuun pa piti kankaŋ ya. ");
INSERT INTO krx_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ateeteyo Pútuun pa mpiyonkal áyiin a mpicakanoo: “Peyme ayyem?” ");
INSERT INTO krx_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ayíin a naañahan po: “Inci síyuusi ti kankaŋ ya infe kaatuko ñáfalfali inci iyyem, fiye iyyolo.” ");
INSERT INTO krx_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ateeteyo Pútuun pa mpicakanoo: “Ayme asokuu nii ñáfalfali ayyem? Fo aaliyaali enuun eyya inci inkituu ya hili?” ");
INSERT INTO krx_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ayíin a naañahan po: “Aal a aŋa áncoopiyaam ya ácutii papukal enuun ya naawufanam, illi.” ");
INSERT INTO krx_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ateeteyo Pútuun pa mpusok aal a: “Weyme uwune ánhin eehuu?” Aal a naañahan po: “Epululoola ya ecaakoolaam, illi.” ");
INSERT INTO krx_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Fiye, Ateeteyo Pútuun pa mpusok epululoola ya: “Páawoo eehuu ánhine, inci ñanuu ti púlukuleen pa púlooŋ: puwuluwul niŋ piti elampa. Aáfahuunoolo, illi haafol ha hinak óo hinak ti eloŋi. ");
INSERT INTO krx_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Inci fáhin aal a niŋ awe nipiyeno an niŋ akamooloo. Miin ma miti aal a niŋ miin ma mitii efikayeno lompo pikamool. Miin ma miti aal a efimutuncalool hikawi, awe illum mo ti econt.” ");
INSERT INTO krx_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Fiye, mpusok aal a: “Naasayaa munow, inci fapenan meemak ñíyoka ña ñitii, ti ñíyoka aafampuk. Aáfalafi hitaaku kayine ti áyiini pale akina afaayeno ati hikaw ha atii.” ");
INSERT INTO krx_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Nene pusok áyiin a: “Kamma ánsiitane aali illi enuun eyya inci inkituu ya hili, etaam ya eñanee kamma awe, ti ñíyoka ñenfakat hinak óo hinak ti eloŋi aafaya etaam ya illi. ");
INSERT INTO krx_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Etaam ya efeetaak pícankun óo pícankun, aafali paliyal pa piti ukit wa. ");
INSERT INTO krx_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Niŋ hásuwati aafataak paliyali fo ta aafañoho t’etaam. Kaatuko ti etaam ánfulii, ti etaam lompo aafañoho.” ");
INSERT INTO krx_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ayíin a, Ataam, naalu aaloo caacaw ca Eef (ekina eyem “kaloŋa”) kaatuko áfaayenoonii íññaa ya ati keeyem ka kaloŋa púlooŋ. ");
INSERT INTO krx_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ateeteyo Pútuun pa mpimemanool Ataam niŋ aaloo wañ uti kapaŋ élukuleen mpúsoolii. ");
INSERT INTO krx_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Púful toko, Ateeteyo Pútuun pa mpusok: “An acukaacuk nii unaa, ámeyimeyi heenape niŋ heenaput. Uñaŋutoo kakatan apili enuun ya eti eloŋ ya, naaloŋ fo eket maama.” ");
INSERT INTO krx_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Fiye, Ateeteyo Pútuun pa mpúfulanii ti kankaŋ ya eti Eden kapiya etaam ya eyya nkáfulii ya teyyo. ");
INSERT INTO krx_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ta mpipayii ta hiyaanu, mpisiiŋan pumaleekoo piti sempe empa nkasok Piselupim, pa caanak ca íncifulii pa ti kankaŋ ya eti Eden, niŋ káakuntu kiti kaaleew enka nkiyesoolo pan óo pan kipifaas pítin pa peehiiŋe pa ti enuun ya eti eloŋ ya. ");
INSERT INTO krx_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Eehuu hipimuus, Ataam náameyiyoo aal, Eef náapukii cikampaani. Fiye, Eef naasok: “Ateeteyo ayankananaam pitaak cikampaani,” naalu co caacaw ca Kayin. ");
INSERT INTO krx_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Po hátikin, naapuk atuwoo naasokoo Abel. Kápiyankii, Abel naataak písaacii empa nafaas, Kayin lompo naayeno ayaya. ");
INSERT INTO krx_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Hikee hinoom, Kayin náacoopii ti pamaañal pa apuwaaseen po Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel lompo náacoopii písaacii ti papukal pa píyaañ pa piti koolee ya eteyoo naawaaseen kaapii ka keehaŋe ka patoof Ateeteyo. Ateeteyo ínsuumoo ti Abel naasayan kaawaaseen ka kiteyoo. ");
INSERT INTO krx_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Pale asayanut Kayin niŋ kaawaaseen ka kiteyoo. Kayin náañiken meemak, puhooŋuyoo mpíniman. ");
INSERT INTO krx_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ateeteyo naasok Kayin: “Weyme uwune áññiken? Weyme uwune puhooŋuyi mpíniman fiyuu? ");
INSERT INTO krx_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Niŋ áahinaa heenape aafasayanee, pale niŋ áahinaa heenaput, kaamuuyen unka ti épuusiyi, nkiŋes ihaŋuyi sempe, pale aañaŋaa ko iheeku.” ");
INSERT INTO krx_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Púful toko, Kayin naasok atuwoo: “Máafulaa maakaayaa pati ukit wa.” Ta nkayeniye ta po, Kayin naalaako atuwoo Abel naamukoo. ");
INSERT INTO krx_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Fiye, Ateeteyo naacakan Kayin: “Atuwi Abel uwwey?” Kayin naañahanoo: “Cukutoo, fo inci yem afaasa ya ati atuwam?” ");
INSERT INTO krx_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ateeteyo naasokoo: “Weyme uwune ánhin eehuu? Síyaasi hísim atuwi ti hiceeku ti inci t’etaam esiya ya ti hiñaaku kánukan. ");
INSERT INTO krx_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Fiye, aañanee, iyyaanee ti etaam ya eesoope ya hísim atuwi aŋa ammuke ya. ");
INSERT INTO krx_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Naayayaa yo etinene épukii waah. Aafatootoosool tan óo tan, áatiyini piyeno nantoonool ti etaam ya.” ");
INSERT INTO krx_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kayin naasok Ateeteyo: “Hikasap ha hitoom hínapinapi pitiyo. ");
INSERT INTO krx_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Fíyooy aayaanaam ti etaam eyya inci iyya ya, ñaŋuu piyolo íllaaŋi. Efitootoosool étiyini piyeno nantoonool ti etaam ya. An óo an eecukaam afaamukam.” ");
INSERT INTO krx_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ateeteyo naañahan Kayin: “Haani! Niŋ an amukuu, pakan isak niŋ pákasupak efikamukee eket ya etii épunukanee.” Fiye, Ateeteyo náahin lánkamaasi ti Kayin ancuk an óo an eecukoo atamukoo. ");
INSERT INTO krx_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kayin naakaay ápilaaŋ Ateeteyo, naacaakin ti mah ma miti Not, pukol kankaŋ ya eti Eden pa caanak ca íncifulii pa. ");
INSERT INTO krx_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ta Kayin naasaye ta, naahinto niŋ aaloo náapukii cikampaani: Enok. Kayin naasiiŋan saatee naaluwool yo niŋ añiinoo Enok. ");
INSERT INTO krx_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enok naapuk cikampaani: Ilat. Ilat naapuk Mehuyayel, Mehuyayel naapuk Metusayel, Metusayel naapuk Lemek. ");
INSERT INTO krx_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemek naasa pakaal pákasupak: ácook a caacawoo Ata, ásupiyenu ya caacawoo Silla. ");
INSERT INTO krx_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ata naapuk Yapal. Akina áyaañe akin ti ékuut naawul púlukuleen. ");
INSERT INTO krx_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Atuwoo caacawoo Yupal. Akina áyaañe asap kóntiŋ niŋ kámpiis. ");
INSERT INTO krx_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Silla lompo naapuk Tupal-Kayin. Asafa, akina nasaf coolaŋ óo coolaŋ eti mañ. Ahoopoo ayem Naama. ");
INSERT INTO krx_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lemek naasok pakaaloo: “Ata niŋ Silla nísiitanam! Pakaalam, nitah kunuu ti eeha inci inkaakaay ha hisoku. Mukaamuk áyiin kamma naakuumaam, immuk akampaani kamma naasapaam. ");
INSERT INTO krx_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Niŋ kañaŋaa himuku pakan isak niŋ pákasupak kati kánukan eket ya eti Kayin, efikamuk pakan áwii éhaaciil niŋ kaat niŋ pákasupak (77) kati kánukan eketam.” ");
INSERT INTO krx_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ataam naahinto niŋ aaloo náapukii cikee cikampaani. Eef naalu co caacaw ca Set (ekina eyem “kawun”). Naasok “Kayin amukaamuk Abel, pale Pútuun pa mpuwunam cikee cikampaani ti putum pa piteyoo.” ");
INSERT INTO krx_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set lompo naapuk cikampaani naasok co Enos. Ti oom caanak pakan paka nkácooke kaluum Pútuun pa ti kaayonkal etempo Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ehe heekiicee ha kiti Ataam niŋ keesokoo maamaa. Ta Pútuun pa mpiliile ta pakan mpíhinii kápuful po. ");
INSERT INTO krx_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Mpiliilii áyiin niŋ aal mpisampanii mpuluwii caacaw ca “pakan” ti hinoom eeha mpiliilii ha. ");
INSERT INTO krx_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ataam ta naataake ta sitiil keme niŋ áwii niŋ ŋaasuwan (130), naapuk cikampaani céefuloo naalu co caacaw ca Set. ");
INSERT INTO krx_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Pamuusal hipukuyee ha hiti Set, Ataam nene aloŋ sitiil sikeme isak niŋ síhaaciil (800) naapuk pakakee epuuk pikampaani niŋ púmaacul. ");
INSERT INTO krx_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ataam eloŋoo púlooŋ neeyeno sitiil sikeme isak niŋ sipaakiil niŋ áwii niŋ ŋaasuwan (930). Púful toko naaket. ");
INSERT INTO krx_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set ta naataake ta sitiil keme niŋ isak (105) naapuk cikampaani naalu co caacaw ca Enos. ");
INSERT INTO krx_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Pamuusal hipukuyee ha hiti Enos, Set nene aloŋ sitiil sikeme isak niŋ síhaaciil niŋ isak niŋ súsupak (807) naapuk pakakee epuuk pikampaani niŋ púmaacul. ");
INSERT INTO krx_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Set eloŋoo púlooŋ neeyeno sitiil sikeme isak niŋ sipaakiil niŋ ŋaasuwan niŋ súsupak (912). Púful toko naaket. ");
INSERT INTO krx_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos ta naataake ta sitiil áwii epaakiil niŋ ŋaasuwan (90) naapuk cikampaani naalu co caacaw ca Kenan. ");
INSERT INTO krx_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Pamuusal hipukuyee ha hiti Kenan, Enos nene aloŋ sitiil sikeme isak niŋ síhaaciil niŋ kaat (815) naapuk pakakee epuuk pikampaani niŋ púmaacul. ");
INSERT INTO krx_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enos eloŋoo púlooŋ neeyeno sitiil sikeme isak niŋ sipaakiil niŋ isak (905). Púful toko naaket. ");
INSERT INTO krx_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan ta naataake ta sitiil áwii éhaaciil niŋ ŋaasuwan (70) naapuk cikampaani naalu co caacaw ca Mahalaleel. ");
INSERT INTO krx_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Pamuusal hipukuyee ha hiti Mahalaleel, Kenan nene aloŋ sitiil sikeme isak niŋ síhaaciil niŋ áwii ésupak (840) naapuk pakakee epuuk pikampaani niŋ púmaacul. ");
INSERT INTO krx_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan eloŋoo púlooŋ neeyeno sitiil sikeme isak niŋ sipaakiil niŋ ŋaasuwan (910). Púful toko naaket. ");
INSERT INTO krx_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleel ta naataake ta sitiil áwii éhaaciil niŋ isak (65) naapuk cikampaani naalu co caacaw ca Yelet. ");
INSERT INTO krx_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Pamuusal hipukuyee ha hiti Yelet, Mahalaleel nene aloŋ sitiil sikeme isak niŋ síhaaciil niŋ áwii niŋ ŋaasuwan (830) naapuk pakakee epuuk pikampaani niŋ púmaacul. ");
INSERT INTO krx_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalaleel eloŋoo púlooŋ neeyeno sitiil sikeme isak niŋ síhaaciil niŋ áwii epaakiil niŋ kaat (895). Púful toko naaket. ");
INSERT INTO krx_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yelet ta naataake ta sitiil keme niŋ áwii éhaaciil niŋ súsupak (162) naapuk cikampaani naalu co caacaw ca Enok. ");
INSERT INTO krx_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Pamuusal hipukuyee ha hiti Enok, Yelet nene aloŋ sitiil sikeme isak niŋ síhaaciil (800), naapuk pakakee epuuk pikampaani niŋ púmaacul. ");
INSERT INTO krx_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yelet eloŋoo púlooŋ neeyeno sitiil sikeme isak niŋ sipaakiil niŋ áwii éhaaciil niŋ súsupak (962). Púful toko naaket. ");
INSERT INTO krx_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ta Enok naataake ta sitiil áwii éhaaciil niŋ isak (65) naapuk cikampaani naalu co caacaw ca Metuselah. ");
INSERT INTO krx_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Pamuusal hipukuyee ha hiti Metuselah, Enok naacok pítin pa piti Pútuun pa fo sitiil sikeme síhaaciil (300) naataak pakakee epuuk pikampaani niŋ púmaacul. ");
INSERT INTO krx_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enok eloŋoo púlooŋ neeyeno sitiil sikeme síhaaciil niŋ áwii éhaaciil niŋ isak (365). ");
INSERT INTO krx_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enok naacok pítin pa piti Pútuun pa, hikee hinoom nene acukutee kaatuko Pútuun pa píseepinoo patiila. ");
INSERT INTO krx_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metuselah ta naataake ta sitiil keme niŋ áwii epaakiil niŋ isak niŋ súsupak (187) naapuk cikampaani naalu co caacaw ca Lemek. ");
INSERT INTO krx_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Pamuusal hipukuyee ha hiti Lemek, Metuselah nene aloŋ sitiil sikeme isak niŋ súsupak niŋ áwii epaakiil niŋ súsupak (782), naataak pakakee epuuk pikampaani niŋ púmaacul. ");
INSERT INTO krx_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metuselah eloŋoo púlooŋ neeyeno sitiil sikeme isak niŋ sipaakiil niŋ áwii éhaaciil niŋ isak niŋ sipaakiil (969). Púful toko naaket. ");
INSERT INTO krx_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ta Lemek naataake ta sitiil keme niŋ áwii epaakiil niŋ súsupak (182) naapuk cikampaani. ");
INSERT INTO krx_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Naalu co caacaw ca Nowe (ekina eyem “kayihan”), naasok: “Ateeteyo añanaañan etaam ya, pale cikampaani ence eficiyihan unaa ti ñáhin unaa niŋ ti ñíyoka eñña nuuñaŋaa ña hicuku.” ");
INSERT INTO krx_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Pamuusal hipukuyee ha hiti Nowe, Lemek nene aloŋ sitiil sikeme isak niŋ áwii epaakiil niŋ kaat (595), naapuk pakakee epuuk pikampaani niŋ púmaacul. ");
INSERT INTO krx_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lemek eloŋoo púlooŋ neeyeno sitiil sikeme isak niŋ súsupak niŋ áwii éhaaciil niŋ kaat niŋ súsupak (777). Púful toko naaket. ");
INSERT INTO krx_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ta Nowe naataake ta sitiil sikeme isak (500), naapuk epuuk pákayiin pákahaaciil poko kayem: Sem, Ham niŋ Yafet. ");
INSERT INTO krx_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Pakan paka nkáyaañ émeeŋii t’etaam, nkapuk púmaacul. ");
INSERT INTO krx_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Epuuk Pútuun nkacuk nii púmaacul pa payenkuu káwalliwalli meemak nkamamal teyii pakaalii. ");
INSERT INTO krx_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Fiye, Ateeteyo naasok: “Inci tikat an apuloŋ fo eket maama kaatuko poko pakan. Písik fiye etikaloŋ pihaŋ sitiil keme niŋ áwii (120).” ");
INSERT INTO krx_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ti oom caanak niŋ po hátikin, intaako ñítaapanu pákayiin keehaane haan ti etaam ya, ta epuuk ya pakati Pútuun pa nkákeyii ta kapitaak niŋ púmaacul pa epuuk: epuuk ya payenkuu nkáyenoonii pikama kenfakat niŋ kéesiyiye meemak ta infiyye. ");
INSERT INTO krx_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ateeteyo naacuk nii, pakan paka káhaŋiyoohaŋ toko pakanc ti etaam ya. Tan óo tan pámiiloolalii púlooŋ pinaput háati poonool. ");
INSERT INTO krx_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ateeteyo naawatanoolo heewune naaliilii. Yaanoo neemeeŋ niŋ páciite penfakat. ");
INSERT INTO krx_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Fiye, Ateeteyo naasok: “Inci fápucalool pakan paka payenka inci illiile ka, niŋ lompo pusuwa pa niŋ púlukuleen pa púlooŋ, penfakat niŋ penkilis, kaatuko watanoolaa-watanoolo heewune illiilii.” ");
INSERT INTO krx_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Pale Ateeteyo ínsuumoo ti Nowe. ");
INSERT INTO krx_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Ehe kiti Nowe niŋ keesokoo maamaa. Nowe naapuk pikampaani pákahaaciil: Sem, Ham niŋ Yafet. Ti ekaay ya eteyoo, Nowe lamayoo ayeniye áyiin eecoonoole náhin héesuume Pútuun pa, naacok pítin etempo. ");
INSERT INTO krx_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Pale ti ñíkin Pútuun pa, pakan paka pakati etaam ya kápucaapuco, etaam ya neemeeŋ niŋ pakanc. ");
INSERT INTO krx_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Pútuun pa mpisincan heetaakiye ha t’etaam ya mpucuk nii hinaput, kaatuko pakan paka púlooŋ kéepuciye. ");
INSERT INTO krx_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Fiye, Pútuun pa mpusok Nowe: “Inci cokaacok kaapayool niŋ pakan paka. Etaam ya emeeŋaameeŋ niŋ pakanc kamma poko. Inci fápucaloolii niŋ etaam ya. ");
INSERT INTO krx_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","“Awe memanool piteen penfakat niŋ pupapaloo peeyanke kaŋ. Páacinool páhantuwa etempo píkaap peemeeŋe, ínhin po pentuloo niŋ manoo páhantuwa niŋ tíkitaaŋ etempo ancuk man timpi míyini pinako. ");
INSERT INTO krx_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ehe fiye aafamemanool piteen empuu: piñaŋaa hitaaku simeetal keme niŋ áwii ésupak niŋ ŋaasuwan (150) ti pahaan etempo, áwii niŋ isak (25) ti paweñ etempo niŋ simeetal kaat (15) písik t’etaam fo ti kankalaŋ ka. ");
INSERT INTO krx_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Aáfatiŋ po inkatan kancaŋ meetal ti pututa kankalaŋ ka niŋ upii wa uti piteen pa. Putum etempo, ínhin po ti kaapii. Páhantuwa etempo, ínhin etaas éyaañ, etaas ésupiyenu niŋ etaas éhaaciyenu. ");
INSERT INTO krx_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Inci fákatanii man menfakat mupuhootan etaam ya, kati púcalool waah óo waah ewwa nuusuuŋut. Waah óo waah weeyem ti etaam ya éfuucim. ");
INSERT INTO krx_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","“Pale inci faliil písiyool niŋ awe. Aafanako ti piteen pa, awe niŋ aali, pikampaani pa pakatii niŋ pakaalii. ");
INSERT INTO krx_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Aafanakan lompo ti piteen pa sílukuleen súsupak ti élukuleen óo élukuleen, éeyiine niŋ eeyaale, kati puloŋ niŋ awe. Pusuwa niŋ púlukuleen, penfakat niŋ penkilis, éfipikey ti awe kati puloŋ. ");
INSERT INTO krx_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Incoopool lompo paliyal óo paliyal iyyenan po, ancuk nitaakaa waah ewwa inniyina hili, awe niŋ pikina.” ");
INSERT INTO krx_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nowe náahin pitempo tak eeha púlooŋ Pútuun pa mpusokoo ha. ");
INSERT INTO krx_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Fiye, Ateeteyo naasok Nowe: “Nako ti piteen pa niŋ miin ma mitii púlooŋ, kaatuko ti inci awe lamma yem eecoonoole ya ti ekaay eyye. ");
INSERT INTO krx_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","“Ti púlukuleen empa inci incoone pa aluu hili, coop éeyiine niŋ eeyaale ti síi óo síi fo isak niŋ súsupak. Ti púlukuleen empa inci inkite pa aluu hili, incoop éeyiine niŋ eeyaale ti síi óo síi. ");
INSERT INTO krx_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ti pusuwa pa lompo incoop úyiin isak núusupak niŋ ulaw isak núusupak ti síi óo síi. Hín eehuu púlooŋ kati utaakaa etukal etempo ti etaam ya. ");
INSERT INTO krx_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kaatuko le niŋ kunoom isak niŋ kúsupak, inci fánupanii etiil hánant hanakan fo kunoom áwii ésupak (40). Inci fápucalool waah óo waah weeyem kaloŋa ewwa inci illiile.” ");
INSERT INTO krx_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nowe náahin eeha púlooŋ Ateeteyo naasokoo ha. ");
INSERT INTO krx_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nowe naataak sitiil sikeme isak niŋ yoonool (600) ta kaahootan ka nkúcolii ta t’etaam. ");
INSERT INTO krx_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Naanako ti piteen pa, akina niŋ aaloo, epuukoo niŋ pakaalii, kapifak kaahootan ka. ");
INSERT INTO krx_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Elúkuleen óo élukuleen, eecoonee hili niŋ eekitee hili, pusuwa pa niŋ élukuleen óo élukuleen eyya néhuunoolo ");
INSERT INTO krx_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","mpinako súsupak súsupak ti piteen pa niŋ Nowe, éeyiine niŋ eeyaale, samat nii fa Pútuun pa mpusoke fa Nowe áhin. ");
INSERT INTO krx_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Kunoom ka isak niŋ kúsupak ka kupumuus, man ma ummuhootan etaam ya. ");
INSERT INTO krx_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ta Nowe naataake ta sitiil sikeme isak niŋ yoonool (600), hiim ha hísupiyenu ha hipitaak kunoom kaat niŋ kúsupak, hítaapanu man úmmufulii t’etaam ímmifasasii, útiŋu wa núukatanii man fanfaŋ. ");
INSERT INTO krx_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Neeyeno hinup hánant hanakan fo kunoom áwii ésupak (40). ");
INSERT INTO krx_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ti hinoom eeha néeyaañe ha hinup Nowe naanakiye ti piteen pa, akina niŋ aaloo, pikampaani pa pakateyoo, Sem, Ham niŋ Yafet, niŋ pakaalii. ");
INSERT INTO krx_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Naanako niŋ élukuleen óo élukuleen, puwuluwul niŋ piti elampa, penfakat niŋ penkilis empa mpumuusool t’etaam, niŋ esuwa óo esuwa. ");
INSERT INTO krx_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Waah óo waah ewwa nuusuuŋut nuunako súsupak súsupak ti piteen pa niŋ Nowe. ");
INSERT INTO krx_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Sílukuleen súsupak ti élukuleen óo élukuleen, éeyiine niŋ eeyaale, insinako samat nii fa Pútuun pa mpusoke fa Nowe áhin. Ta nkanakiye ta páhantuwa, Ateeteyo naapank hunkut ha. ");
INSERT INTO krx_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","18","Man ma miti kaahootan ka immiyeno pisilo pihaŋhaŋ toko fo kunoom áwii ésupak (40), ímmiseepin piteen pa, piteen pa mpiyeno hilentu temmo. ");
INSERT INTO krx_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ti pisilo penfakat empuu, háati pítintiŋ pa peehaŋe pa pahaan mpuhoot. ");
INSERT INTO krx_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Man ma immisilo fo simeetal isak niŋ súsupak patiila pítintiŋ pa. ");
INSERT INTO krx_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Fiye, waah óo waah weeyem kaloŋa ewwa nuumuusool t’etaam nuuketal: pusuwa pa, púlukuleen pa puwuluwul pa, púlukuleen pa piti elampa ya, púlukuleen pa empa mpisap pa kayoŋ niŋ pakan paka púlooŋ. ");
INSERT INTO krx_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Waah óo waah ewwa nuusuuŋut ti etaam ya nuuketal. ");
INSERT INTO krx_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Fiyuu Pútuun pa mpúpucaloole waah wa púlooŋ weeyeniye wa kaloŋa ti etaam ya: pakan paka, pusuwa pa niŋ púlukuleen pa púlooŋ, penfakat niŋ penkilis. Waah ewwuu púlooŋ núupucaloolee. Intowo Nowe lamma niŋ keeyeniye ka neyoo ti piteen pa. ");
INSERT INTO krx_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Man ma ummuhootan etaam ya fo kunoom keme niŋ áwii ésupak niŋ ŋaasuwan (150). ");
INSERT INTO krx_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Fiye, Pútuun pa mpínawuno Nowe niŋ púlukuleen pa púlooŋ, puwuluwul niŋ piti elampa, peeyem pa neyoo ti piteen pa. Mpupoñ eyam ti etaam ya man ma ímmiyaañ hisooŋu. ");
INSERT INTO krx_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Man ma méefulii ma t’etaam ímmiyekuno éfasasii, útiŋu wa nuuhancaloolo, etiil ya néeyekuno hinup. ");
INSERT INTO krx_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Kaahootan ka nkiyeno ékaasino ti etaam ya caahinkiŋ caahinkiŋ. Kunoom keme niŋ áwii ésupak niŋ ŋaasuwan (150) kupumuus, ");
INSERT INTO krx_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","piteen pa mpilaay ti pítintiŋ pa piti Alalat, ti hinoom ha heewase ha kaat niŋ kúsupak ti hiim ha heewase ha isak niŋ kúsupak. ");
INSERT INTO krx_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Man ma ummutowo ti ékaasino fo ti hiim ha heewase ha ŋaasuwan. Ti hinoom ha híyaañ ha hiti hiim eehuu, patiila pítintiŋ pa incukee. ");
INSERT INTO krx_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Pumuus kunoom áwii ésupak (40), Nowe náapankin epalloolu ya eyya náahine ya ti piteen pa. ");
INSERT INTO krx_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Naakatan ekannaal neetowo ti káayititool fo ta man ma ummusooŋe ta ti etaam ya. ");
INSERT INTO krx_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Nene akatan hícuucuuku, apisincan man man ma muwaniyaa. ");
INSERT INTO krx_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Pale hícuucuuku ha hitaakut la efihileeho, kaatuko pan óo pan ti etaam ya man. Fiye, níhiñohoonii ti Nowe ti piteen pa. Nowe náafulan epeesoo náañahanii hícuucuuku ha ti piteen pa. ");
INSERT INTO krx_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Náatuul fo kunoom isak niŋ kúsupak, nene akatan hícuucuuku ha tíkitaaŋ. ");
INSERT INTO krx_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ta hícuucuuku ha níhiñohoonii ta nkániim, ti hicuŋ eteeho naacuk kahatal keemaaña kiti olif. Fiye, Nowe náameyi nii man ma muwanaawano ti etaam ya. ");
INSERT INTO krx_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Nene átuul kikee kunoom isak niŋ kúsupak, naakatan hícuucuuku ha, pale tempe híñohooniyoot. ");
INSERT INTO krx_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Hinoom ha híyaañ ha ti hiim ha híyaañ ha hiti etiil eyya Nowe naataake ya teyyo sitiil sikeme isak niŋ yoonool niŋ yoonool (601), man ma ummusooŋ ti etaam ya. Fiye, Nowe náafulan pátiŋal piteen pa naacuk nii tíkitaaŋ, etaam ya esuucaasuuc. ");
INSERT INTO krx_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ti hinoom ha heewase ha áwii niŋ isak niŋ kúsupak (27) ti hiim ha hísupiyenu ha, etaam ya neesuuc cay. ");
INSERT INTO krx_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Pútuun pa mpusok Nowe: ");
INSERT INTO krx_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Fúlii ti piteen pa, awe, aali, epuuki niŋ epuuki pakaalii. ");
INSERT INTO krx_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Fúlanii lompo púlukuleen pa púlooŋ peeyem pa naawe: penfakat pa niŋ penkilis pa empa mpumuusool pa t’etaam, niŋ pusuwa pa púlooŋ, ancuk pupukoolaa mpimeeŋ ti etaam ya.” ");
INSERT INTO krx_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Fiye, Nowe náafulii niŋ aaloo, epuukoo niŋ epuukoo pakaalii. ");
INSERT INTO krx_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Púlukuleen pa púlooŋ, púlukuleen pa empa mpúhuunoolo pa niŋ pusuwa pa, niŋ élukuleen óo élukuleen eyya nemuusool ti etaam ya mpúfulii ti piteen pa ti písii etempo. ");
INSERT INTO krx_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Fiye, Nowe naasiiŋan kaaciinAteeteyo, naacoop ti púlukuleen pa niŋ pusuwa pa peecoonee pa hili, naawaaseen po Ateeteyo apusow po fo pileem. ");
INSERT INTO krx_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ateeteyo náasi haaw ha héesuume ha, naasokoolo: “Inci etinene ñan etaam ya kamma an háati fa pámiiloolaloo mpinaput fa kápiliŋ maañiiyaayoo, etinene púcalool waah wa púlooŋ weeyem wa kaloŋa samat nii fa inci ínhine fa. ");
INSERT INTO krx_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Taamanta etaam ya écimut, caanak citi pusuk niŋ kaamaañ, pasowe niŋ pamon, etiil niŋ hasa, hanakan niŋ hánant étikayekuno pitaako.” ");
INSERT INTO krx_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Pútuun pa mpisampan Nowe niŋ epuukoo mpusokii: “Nipukool innimeeŋan etaam ya. ");
INSERT INTO krx_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Púlukuleen pa púlooŋ efipife aluu: púlukuleen pa piti etaam ya niŋ pusuwa pa, púlukuleen pa empa mpúhuunoolo pa niŋ soon sa, pikina púlooŋ umpa ti kayine ka kitaaluu. ");
INSERT INTO krx_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Waah óo waah weeyem kaloŋa nuumuusool inci uwwufanaa wo aluu kati uyeno pákuumanal aluu samat nii fa inci uwwufane fa aluu punuun pa niŋ píheeni empa mpitaak pa pukoon. ");
INSERT INTO krx_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Pale niñaŋut hili efoofa eetaake hísim kaatuko eloŋ ti hísim naayem. ");
INSERT INTO krx_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Niŋ an amukaa an inci fasiiŋanoo ti pisiya. Inci fasiiŋan ti pisiya an óo an niŋ élukuleen óo élukuleen eemuke an. ");
INSERT INTO krx_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","An óo an eeniise hísim an akee lompo afaaniis hísimoo kaatuko Pútuun pa piliilaaliil an ápuful po. ");
INSERT INTO krx_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Pale aluu nipukool innimeeŋ, papukal aluu mpihancaloolo ti etaam ya.” ");
INSERT INTO krx_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Púful toko, Pútuun pa mpusok Nowe niŋ epuukoo: ");
INSERT INTO krx_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Inci piliil písiyool pa putoom niŋ aluu niŋ keesoke aluu maamaa ");
INSERT INTO krx_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","niŋ lompo waah wa púlooŋ weeyem wa kaloŋa niŋ aluu: pusuwa pa, púlukuleen puwuluwul pa niŋ piti elampa ya, waah óo waah wéefulii ti piteen pa niŋ aluu, púlukuleen pa púlooŋ peeyem pa ti etaam ya. ");
INSERT INTO krx_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Písiyool empe inci iyyem ti hiliilu naaluu: man menfakat etinene múpucalool waah wa púlooŋ weeyem wa kaloŋa, kaahootan etinene kúpucalool etaam ya.” ");
INSERT INTO krx_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Pútuun pa nene pusok: “Ehe píyisan pa piti písiyool empa inci iyyem pa ti kaasiiŋan ti pututayam niŋ aluu, niŋ waah óo waah weeyem kaloŋa niŋ ti pikaay pa peeyem pa ti ékey fo eket maama. ");
INSERT INTO krx_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Inci siiŋanaa étiifeel ya etoom ti útiŋu wa, ekina efeeyeno píyisan pa piti písiyool pa putoom ti pututayam niŋ etaam ya. ");
INSERT INTO krx_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Tan óo tan ta inci inconcenoole útiŋu wa patiila étiifeel ya néefulii, ");
INSERT INTO krx_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","inci fánawuno písiyool pa putoom empa inci illiile pa naaluu niŋ waah óo waah weeyem kaloŋa. Kaahootan etinene kúpucalool eloŋ ya púlooŋ. ");
INSERT INTO krx_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Tan óo tan ta étiifeel ya néefulii ti útiŋu wa, inci facuk yo ínnawuno písiyool pa peepayantoo pa ti pututa inci, Pútuun pa, niŋ waah wa púlooŋ weeyem wa kaloŋa t’etaam ya.” ");
INSERT INTO krx_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Pútuun pa nene pusok Nowe: “Etíifeel ya eyem píyisan pa piti písiyool empa inci illiile pa niŋ waah óo waah weeyem kaloŋa t’etaam.” ");
INSERT INTO krx_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Epuuk Nowe kéefulii ka ti piteen pa kayem Sem, Ham niŋ Yafet. Ham ayem paapaa ati Kanaan. ");
INSERT INTO krx_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Epuuk ya pakati Nowe pákahaaciil paka payenkuu kayem símaama an óo an eeyem ti etaam ya fíyooy. ");
INSERT INTO krx_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowe ayaya, akina áyaañe asuk kaakit kiti kikenenk. ");
INSERT INTO krx_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Hikee hinoom, naalaan elaan etenko náakuman fo ayeno ñáfalfali ti ékuut ya eteyoo. ");
INSERT INTO krx_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham, paapaa ati Kanaan, naacuk paapaa ateyoo ñáfalfali náaful apicaakaman ho ñúnuwoo. ");
INSERT INTO krx_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Fiye, Sem niŋ Yafet nkacoop kahuuy kenfakat nkanaŋ ko ti úpantiyii. Púful toko nkayeno pikaayu kaasonaay fo kacol ti paapaa ateyii nkáwufalooloo. Páawoo kayesanaayesan ñuhooŋuyii, kacukut paapaa ateyii ñáfalfali. ");
INSERT INTO krx_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ta Nowe náalitoonii ta ti ékuman ya eteyoo, náasi eeha kahiineen ka kiteyoo nkíhine ha. ");
INSERT INTO krx_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Fiye naaceek apusok: “Ñanaa Kanaan! Ayeno amiikan a akelan a ati ñúnuwoo!” ");
INSERT INTO krx_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Púful toko naasok: “Múlaa Ateeteyo Pútuun pa piti Sem! Alímaati Kanaan ayeno amiikan a ati Sem! ");
INSERT INTO krx_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Alímaati Pútuun pa pipenan etaam ya eti Yafet, akin ti púkuut pa piti Sem, Kanaan ayeno amiikan a ateyoo!” ");
INSERT INTO krx_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ta kaahootan ka nkumuuse ta, Nowe naaloŋ sitiil sikeme síhaaciil niŋ áwii ésupak niŋ ŋaasuwan (350). ");
INSERT INTO krx_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Eloŋoo púlooŋ neeyeno sitiil sikeme isak niŋ sipaakiil niŋ áwii ésupak niŋ ŋaasuwan (950). Púful toko naaket. ");
INSERT INTO krx_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ehe kiti Nowe epuukoo, Sem, Ham niŋ Yafet, niŋ miin ma miteyii. Pamuusal kaahootan ka, nkataakal lompo epuuk. ");
INSERT INTO krx_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ehe Yafet epuukoo pákayiin: Komel, Makok, Matay, Yawan, Tupal, Mesek niŋ Tilas. ");
INSERT INTO krx_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ehe Komel epuukoo pákayiin: Askenas, Lifat niŋ Tokaama. ");
INSERT INTO krx_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ehe Yawan epuukoo pákayiin: Elisa niŋ Taasis, pakati Kit niŋ pakati Totan. ");
INSERT INTO krx_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Yawan keesokoo maamaa nkahancoolo nkáyenoonii písii pa piti pucon pa niŋ piti kaatii ka, síi óo síi neetaak mah eteyyo niŋ kaŋ eteyyo niŋ miin eteyyo. ");
INSERT INTO krx_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ehe Ham epuukoo pákayiin: Kus, Esipt, Put niŋ Kanaan. ");
INSERT INTO krx_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ehe Kus epuukoo pákayiin: Sepa, Hawila, Saputa, Laama niŋ Saputeka. Epuuk Laama: Sapa niŋ Tetan. ");
INSERT INTO krx_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus lompo apuke Nimulot eeyeniye ya akama ya enfakat a áyaañ a ti etaam ya. ");
INSERT INTO krx_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Naayeno aleemaya enfakat ti ñíkin Ateeteyo. Ekina ewune nkasok tan óo tan: “Alímaati Ateeteyo áhini aleemaya enfakat samat nii Nimulot.” ");
INSERT INTO krx_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Pisaatee pa píyaañ pa piti cáwii ca citeyoo piyeniye: Babel, Elek, Akat niŋ Kalune ti mah ma miti Sinaal. ");
INSERT INTO krx_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nimulot náaful ti mah emmuu naakaay ti mah ma miti Asili naalut pisaatee pa piti Ninew, Lehopot, Kalah, ");
INSERT INTO krx_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","niŋ Lesen eeyem ya ti pututa Ninew niŋ Kalah, saatee ya eehaŋe ya pafom. ");
INSERT INTO krx_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Esipt ayem maamaa ati Lut, Anem, Lehap, Nafutuh, ");
INSERT INTO krx_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patulus, Kasuluh niŋ Kafutol. Kasuluh ayem maamaa ati pakati Filistin. ");
INSERT INTO krx_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan añiinoo áyaañ ayem Siton, Het ayem Siton atuwoo. ");
INSERT INTO krx_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kanaan ayem lompo maamaa ati pakati Yepus, Amol niŋ Kilukas, ");
INSERT INTO krx_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","pakati Hiw, Alak, Sin, ");
INSERT INTO krx_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Alawat, Semal niŋ Hamat. Po hátikin pakan paka pakati Kanaan nkahancoolo. ");
INSERT INTO krx_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Mah ma miti Kanaan ímmiyaañii Siton mupuwant Kelal fo Gasa. Fiye, ummuwant Sotom, Komola, Atuma niŋ Sepoyim immikaay fo Lesa. ");
INSERT INTO krx_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Payenkuu kayem miin ma miti Ham pákayiin paka. Nkáyenoonii písii; síi óo síi neetaak miin eteyyo niŋ kaŋ eteyyo niŋ mah eteyyo. ");
INSERT INTO krx_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem eeyem ya Yafet púnuwoo naataak lompo epuuk. Naayeno maamaa ati Epel niŋ keesokoo púlooŋ maamaa. ");
INSERT INTO krx_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ehe Sem epuukoo pákayiin: Elam, Asul, Aapakusat, Lut niŋ Alam. ");
INSERT INTO krx_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ehe Alam epuukoo pákayiin: Us, Hul, Ketel niŋ Mas. ");
INSERT INTO krx_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Aapakusat naapuk Selah, Selah naapuk Epel. ");
INSERT INTO krx_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Epel naataak pikampaani pákasupak: áyaañ a caacawoo Pelek (ekina eyem “pípaacinool”), kaatuko ti caanak ca citeyoo pakan paka ti etaam ya kápaacinoolaa-páacinoolo. Atuwoo caacawoo Yokotan. ");
INSERT INTO krx_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ehe Yokotan epuukoo pákayiin: Alumotat, Selef, Hasaamawet, Yelah, ");
INSERT INTO krx_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hatolam, Usal, Tikala, ");
INSERT INTO krx_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Opal, Apimayel, Sapa, ");
INSERT INTO krx_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofil, Hawila niŋ Yopap. Payenkuu púlooŋ, miin ma miti Yokotan pákayiin paka. ");
INSERT INTO krx_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Nkakin ti saatee ya eti Mesa fo Sefal, saatee ya eti pítintiŋ pa, pa caanak ca íncifulii pa. ");
INSERT INTO krx_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Payenkuu kayem miin ma miti Sem pákayiin paka. Nkáyenoonii písii; síi óo síi neetaak miin eteyyo niŋ kaŋ eteyyo niŋ mah eteyyo. ");
INSERT INTO krx_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Payenkuu púlooŋ kayem miin ma miti keesoke ka Nowe maamaa, an óo an niŋ síi ya eteyoo niŋ miin ma miteyoo. Teyii písii pa púlooŋ mpúfulii mpihancaloolo ti etaam ya púlooŋ pamuusal kaahootan ka. ");
INSERT INTO krx_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ti oom caanak pakan paka púlooŋ kaŋ yoonool nkákup niŋ paluwal poonool. ");
INSERT INTO krx_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Nkayeno hitoosu kápufulii pa caanak ca íncifulii pa. Ti oom pikaayu nkacuk hítaapanu etaam eetaakut pítintiŋ ti mah ma miti Sinaal nkakin toko. ");
INSERT INTO krx_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Nkasokool: “Níkey! Umemanoolaa pípilikoo empa efuusowaa ti seemak kati piyank.” Fiyuu nkataake pípilikoo piti kulut nkacoop manoo kapucokoolan po. ");
INSERT INTO krx_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Fiye nkasokool: “Níkey! Ulutaa faŋ unaa saatee niŋ ekumpaan eehaane fo élik útiŋu wa. Ancuk utaakaa caacaw apan etuuhancooliyaa pan óo pan ti etaam ya.” ");
INSERT INTO krx_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Fiye, Ateeteyo náawanoonii apisincan saatee ya niŋ ekumpaan ya eehaane ya eyya pakan paka nkayeniye ya kulut. ");
INSERT INTO krx_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Púful toko Ateeteyo naasok: “Nisincan! Payenke síi yoonool niŋ kaŋ yoonool. Niŋ kácookaa íhinu eehe, weyme efuukitii íhinu eeha púlooŋ nkálafiye ha íhinu? ");
INSERT INTO krx_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Níkey! Uwaniyaa nuunakanoolaa kaŋ ya eteyii ancuk étikasiyool.” ");
INSERT INTO krx_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Fiye, Ateeteyo naahancaloolii pan óo pan ti etaam ya, nkáyekuno kulut saatee ya. ");
INSERT INTO krx_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ekina ewune nkalu saatee ya caacaw ca Babel (ekina eyem “enakanoolo”) kaatuko toko Ateeteyo naanakanoole kaŋ ya eti pakan paka naahancaloolii pan óo pan ti etaam ya. ");
INSERT INTO krx_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ehe kiti Sem niŋ keesokoo maamaa. Sitiil súsupak pamuusal kaahootan ka, Sem pataakal sitiil keme (100) naapuk cikampaani naalu co caacaw ca Aapakusat. ");
INSERT INTO krx_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Pamuusal hipukuyee ha hiti Aapakusat, Sem nene aloŋ sitiil sikeme isak (500) naapuk pakakee epuuk pikampaani niŋ púmaacul. ");
INSERT INTO krx_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ta Aapakusat naataake ta sitiil áwii niŋ kaat (35) naapuk cikampaani naalu co caacaw ca Selah. ");
INSERT INTO krx_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Pamuusal hipukuyee ha hiti Selah, Aapakusat nene aloŋ sitiil sikeme sipaakiil niŋ síhaaciil (403) naapuk pakakee epuuk pikampaani niŋ púmaacul. ");
INSERT INTO krx_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ta Selah naataake ta sitiil áwii niŋ ŋaasuwan (30) naapuk cikampaani naalu co caacaw ca Epel. ");
INSERT INTO krx_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Pamuusal hipukuyee ha hiti Epel, Selah nene aloŋ sitiil sikeme sipaakiil niŋ síhaaciil (403) naapuk pakakee epuuk pikampaani niŋ púmaacul. ");
INSERT INTO krx_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ta Epel naataake ta sitiil áwii niŋ ŋaasuwan niŋ sipaakiil (34) naapuk cikampaani naalu co caacaw ca Pelek. ");
INSERT INTO krx_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pamuusal hipukuyee ha hiti Pelek, Epel nene aloŋ sitiil sikeme sipaakiil niŋ áwii niŋ ŋaasuwan (430) naapuk pakakee epuuk pikampaani niŋ púmaacul. ");
INSERT INTO krx_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ta Pelek naataake ta sitiil áwii niŋ ŋaasuwan (30) naapuk cikampaani naalu co caacaw ca Leyu. ");
INSERT INTO krx_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Pamuusal hipukuyee ha hiti Leyu, Pelek nene aloŋ sitiil sikeme súsupak niŋ isak niŋ sipaakiil (209) naapuk pakakee epuuk pikampaani niŋ púmaacul. ");
INSERT INTO krx_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ta Leyu naataake ta sitiil áwii niŋ ŋaasuwan niŋ súsupak (32) naapuk cikampaani naalu co caacaw ca Seluk. ");
INSERT INTO krx_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Pamuusal hipukuyee ha hiti Seluk, Leyu nene aloŋ sitiil sikeme súsupak niŋ isak niŋ súsupak (207) naapuk pakakee epuuk pikampaani niŋ púmaacul. ");
INSERT INTO krx_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ta Seluk naataake ta sitiil áwii niŋ ŋaasuwan (30) naapuk cikampaani naalu co caacaw ca Nahol. ");
INSERT INTO krx_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Pamuusal hipukuyee ha hiti Nahol, Seluk nene aloŋ sitiil sikeme súsupak (200) naapuk pakakee epuuk pikampaani niŋ púmaacul. ");
INSERT INTO krx_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ta Nahol naataake ta sitiil áwii niŋ isak niŋ sipaakiil (29) naapuk cikampaani naalu co caacaw ca Telah. ");
INSERT INTO krx_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Pamuusal hipukuyee ha hiti Telah, Nahol nene aloŋ sitiil keme niŋ kaat niŋ sipaakiil (119) naapuk pakakee epuuk pikampaani niŋ púmaacul. ");
INSERT INTO krx_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ta Telah naataake ta sitiil áwii éhaaciil niŋ ŋaasuwan (70) naapuk epuuk pikampaani pákahaaciil: Abram, Nahol niŋ Halan. ");
INSERT INTO krx_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ehe kiti Telah niŋ keesokoo maamaa. Telah naapuk pikampaani pákahaaciil: Abram, Nahol niŋ Halan. Halan naapuk Lot. ");
INSERT INTO krx_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Halan náatikin eket paapaa ateyoo Telah ti saatee ya eti Ul, ti mah ma miti pakati Kalataay, mah emma naapukee ma temmo. ");
INSERT INTO krx_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram niŋ Nahol nkasa. Abram aaloo caacawoo Saray, Nahol ateyoo ya caacawoo Miluka, Halan añiinoo. Halan naataak lompo akee ámaacul caacawoo Yisika. ");
INSERT INTO krx_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saray caakonta ataakut añii. ");
INSERT INTO krx_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Telah naacoopool añiinoo Abram niŋ Lot eesokoo ya maamaa eeyem ya Halan añiinoo. Telah naacoopool lompo Saray, Abram aaloo, nkáful Ul eti Kalataay kápilafi pikaayu ti mah ma miti Kanaan. Pale kapucol ti saatee ya eti Halan nkakin toko. ");
INSERT INTO krx_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Telah naaloŋ sitiil sikeme súsupak niŋ isak (205) naaket toko Halan. ");
INSERT INTO krx_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ateeteyo naasok Abram: “Fúl ti mah ma mitii, miin ma mitii niŋ hank ha hiti faafi, inkaay ti mah ma emma fáyisani ma. ");
INSERT INTO krx_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Inci fáhin aapiyeno síi enfakat, insampani, caacawi éficisiyo, pínapii ti awe fasampan pakakee paka. ");
INSERT INTO krx_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Fasampan payenka efikasampani ka, iññan payenka efikañani ka. Pínapii ti awe, fasampan písii pa púlooŋ piti etaam ya.” ");
INSERT INTO krx_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Fiye, Abram naakaay samat nii fa Ateeteyo naasokoo fa, atuwoo añiinoo Lot naanapool neyoo. Abram ta náafule ta ti saatee ya eti Halan loho ataakaa sitiil áwii éhaaciil niŋ kaat (75). ");
INSERT INTO krx_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Naacoopool aaloo Saray, atuwoo añiinoo Lot, naacoopool lompo hisaanumate ha hiteyoo púlooŋ niŋ pimiikan pa payenka náanoomii ka Halan. Nkahiiŋ ti mah ma miti Kanaan. Ta nkacole ta Kanaan, ");
INSERT INTO krx_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram naamuus fo ti enuun ya eesampanee ya eyya nkasok ya Mole eeyem ya ti saatee ya eti Sikem, ti oom caanak pakati Kanaan toko. ");
INSERT INTO krx_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ateeteyo náafulii ti Abram naasokoo: “Inci fawufan mah emme keesokuu maamaa.” Fiye, Abram naalut toko kaaciin kiti Ateeteyo éeyisanooliye ya teyoo. ");
INSERT INTO krx_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Púful toko naahiiŋ ti pítintiŋ pa peekole pa saatee ya eti Petel. Naasiiŋan ékuut ya eteyoo ti pututa Petel pa caanak ca incinow pa niŋ saatee ya eti Ay pa caanak ca íncifulii pa, naalut toko kaaciin kiti Ateeteyo, naaluum ti caacaw Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Fiye, Abram naatootoosool apihiiŋhiiŋ pati káahaaŋ ka tes kiti Nekep. ");
INSERT INTO krx_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ti oom caanak, épankul enfakat neeyeno ti mah ma, Abram naawano ti mah ma miti Esipt kati ayeno po fo cikee caanak kamma épankul ya neefome. ");
INSERT INTO krx_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ta naalohane ta Esipt, naasok aaloo Saray: “Síitan, inci méyimeyi nii áawalliwalli. ");
INSERT INTO krx_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Niŋ pakati Esipt kacukuu efikasok: 'Aŋe aaloo.' Efikamukam nkakati kaloŋa. ");
INSERT INTO krx_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Káluma, sokii nii awe ahoopam kati kawananam pinap iyyeno kaloŋa kamma awe.” ");
INSERT INTO krx_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ta Abram naacole ta Esipt, pakati Esipt nkacuk pawalle pa penfakat pa piti aaloo. ");
INSERT INTO krx_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Puwuna pa kunuu pakati amansa ya ati Esipt nkámul Saray hátikinoo. Nkacoopoo pateyoo. ");
INSERT INTO krx_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Kamma akina, amansa ya naawanan Abram pinap. Naawunoo písaacii, pifil niŋ síis, pimiikan pákayiin niŋ pakaal, púfali, niŋ puñonkomoo. ");
INSERT INTO krx_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Pale Ateeteyo náawananii úkuuñu ti amansa ya niŋ miin ma miteyoo kamma Abram aaloo Saray. ");
INSERT INTO krx_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Amansa ya naayonkal Abram naasokoo: “Weyme ánhinaam fiye? Aasokutam nii Saray aali! Weyme uwune? ");
INSERT INTO krx_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Weyme uwune ansok nii ahoopi? Inci incoopoo kati ayeno aalam! Fiye ehe aali! Coopoo inkaay!” ");
INSERT INTO krx_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Amansa ya naawufan hilim píhina pa pakateyoo kápufulan ti mah ma Abram niŋ aaloo niŋ waah óo waah ewwa naataake. ");
INSERT INTO krx_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Púful toko, Abram náafulii Esipt naañoho pati káahaaŋ ka tes kiti Nekep, akina niŋ aaloo niŋ waah óo waah ewwa naataake, Lot naanapool neyoo. ");
INSERT INTO krx_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram usaanum naataak pukoolee penfakat, hícump púkotifoloo niŋ pisanoo. ");
INSERT INTO krx_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Fiye, Abram náaful ti káahaaŋ ka tes kiti Nekep naatootoosool apihiiŋhiiŋ ti saatee ya eti Petel la ékuut ya eteyoo mpeeyeno la ti pututa Petel niŋ Ay ");
INSERT INTO krx_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","niŋ la mpaalut la kaaciin. Toko, naaluum ti caacaw Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot eenapoole ya niŋ Abram naataak lompo písaacii, pifil, síis niŋ púkuut. ");
INSERT INTO krx_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Mah ma mufomutii piyeno nantoonool, kaatuko hisaanumate ha hiteyii hifomaafom meemak, ");
INSERT INTO krx_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ekina ewune pítaakool mpitaako ti pututa pufaasa púlukuleen pa pakati Abram niŋ pufaasa púlukuleen pa pakati Lot. Apan pakati Kanaan niŋ pakati Pelis lompo nkakin toko. ");
INSERT INTO krx_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Fiye, Abram naasok Lot: “Unaa pakoonool pakuu, pítaakool timpi piyeno ti pututa anii niŋ ti pututa pufaasa pa pakatoom niŋ pakatii paka. ");
INSERT INTO krx_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Mah ma púlooŋ umma hátikini, káluma máakatinoolaa. Naakaayaa epees yaamay inci inkaay epees yáali. Naakaayaa epees yáali inci inkaay epees yaamay.” ");
INSERT INTO krx_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot náahaafin naasincanool naacuk nii etaam ya púlooŋ éekinkoole ya han ha hiti Jordan eepooce lac, pucuk fiye nii kankaŋ ya eti Ateeteyo niŋ lompo nii etaam ya eti Esipt puwant saatee ya eti Sowal. Tempo, Ateeteyo peelokot ápucalool pisaatee pa piti Sotom niŋ Komola. ");
INSERT INTO krx_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Fiye, Lot naamamal etaam ya eti Jordan naahiiŋ pa caanak ca íncifulii pa. Fiyuu Lot niŋ Abram nkákatinoole. ");
INSERT INTO krx_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram naayeno ti mah ma miti Kanaan. Lot naacaakin pukol pisaatee pa piti Jordan naasiiŋan púkuut pa piteyoo pukol saatee ya eti Sotom. ");
INSERT INTO krx_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Caham pakati Sotom kanaput nkamuuyen meemak ti Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Pamuusal pikaayu pa piti Lot, Ateeteyo naasok Abram: “Háafin insincanool pan óo pan, hátikini niŋ pusoni, epeesi yaamay niŋ epeesi yáali. ");
INSERT INTO krx_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Mah emma ancuke ma púlooŋ inci fawufani mo, awe niŋ keesokuu maamaa fo eket maama. ");
INSERT INTO krx_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Inci fáhin keesokuu maamaa kapimeeŋ samat nii esiya ya, an átayiniyii kafinu samat nii fa an naayinaat fa kafinu esiya ya. ");
INSERT INTO krx_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Kaay! Fiitanool mah ma kaatuko inci fawufani mo.” ");
INSERT INTO krx_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Fiye, Abram naatoosan púkuut pa piteyoo naacaakin pukol punuun pa peesampanee pa piti Mamule peeyem pa ti saatee ya eti Hepolon. Toko, naalut kaaciin kiti Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ti oom caanak, pumansa pakapaakiil nkakaay hikam, poko kayem: Amulafel amansa ya ati Sinaal, Aliyok amansa ya ati Ellasal, Ketollayomel amansa ya ati Elam niŋ Tital amansa ya ati Koyim. ");
INSERT INTO krx_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Nkákey hikam niŋ pumansa isak: Pela amansa ya ati Sotom, Piisa amansa ya ati Komola, Sinap amansa ya ati Atuma, Semepel amansa ya ati Sepoyim niŋ amansa ya ati Pelak (ekina eyem Sowal). ");
INSERT INTO krx_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Pumansa pa isak ya nkaconcoolo niŋ pusoocaali pa pakateyii ti etaam ya eti Sitim eetaakut ya pítintiŋ (ti caanak ca citi fíyooy, Kaatii ka Keekete ka kúwufaloole yo). ");
INSERT INTO krx_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Kápiliŋ sitiil ŋaasuwan niŋ súsupak, poko ti kayine ka kiti Ketollayomel, pale ti etiil ya eewase ya ŋaasuwan niŋ síhaaciil nkapookoo cooy kúncoo ya. ");
INSERT INTO krx_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ti etiil ya eewase ya ŋaasuwan niŋ sipaakiil Ketollayomel náakey niŋ pumansa pa kéesiyoole ka neyoo. Nkaheek pakati Lefa ti saatee ya eti Asutolet-Kaanayim, pakati Sus ti saatee ya eti Ham, pakati Em ti etaam ya eti Kiliyatayim. ");
INSERT INTO krx_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Nkaheek lompo pakati Hol lateyii ti tíntiŋ ya eti Seyil, nkatey neyii fo El-Palan pukol káahaaŋ tes. ");
INSERT INTO krx_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Púful toko nkáñohoonii nkakaay ti saatee ya eti En-Mispat (ekina eyem Kates). Nkalam mah ma púlooŋ miti pakati Amalek nkaheek pakati Amol keekine ka ti saatee ya eti Haseson-Tamal. ");
INSERT INTO krx_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Fiye, pumansa pa pakati pisaatee pa piti Sotom, Komola, Atuma, Sepoyim niŋ Pelak (ekina nkasok Sowal) nkáfulii kapikaay hikam pati etaam ya eti Sitim. ");
INSERT INTO krx_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Nkakam niŋ pumansa pa: Ketollayomel ati Elam, Tital ati Koyim, Amulafel ati Sinaal niŋ Aliyok ati Ellasal; pumansa isak ti pumansa pakapaakiil. ");
INSERT INTO krx_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Caham etaam ya eti Sitim etaakaataak hícump uyeen weetaake manoo. Ti katey ka kiteyii, amansa ya ati Sotom niŋ ati Komola nkanow tewwo, pakakee paka nkatey kapihiiŋ pati pítintiŋ pa. ");
INSERT INTO krx_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Pumansa pa pakapaakiil paka keeheeke ka pumansa pa isak ya nkacoop hisaanumate ha hiteyii púlooŋ heeyem ha Sotom niŋ Komola niŋ paliyal pa piteyii púlooŋ, púful toko nkakaay. ");
INSERT INTO krx_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lot lompo, Abram atuwoo añiinoo eekine ya Sotom, naacoopee niŋ hisaanumate ha hiteyoo. ");
INSERT INTO krx_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Akee ti keefake ka naacaakaman heetaakiye ha Abram Ahiburu ya, eekine ya pukol punuun pa peesampanee pa piti Mamule ati Amol. Mamule naananf Abram, akina niŋ Esukol niŋ Anel. Poko t’éhaaciilii miin moonool. Abram niŋ payenkuu kásiyoolaa-síyool nii ti caanak citi hikam efikasiiŋoolo. ");
INSERT INTO krx_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Emma Abram náasiye ma nii atuwoo añiinoo acokeecok naaconcoolan pákayiin sikeme síhaaciil niŋ kaat niŋ pákahaaciil (318) keepukee lateyoo. Naanapan keecokoo ka fo ti saatee ya eti Dan. ");
INSERT INTO krx_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Náapaacinool pákayiin paka ti uyoŋ, naalaakiyii niŋ hánant ha. Naaheekii naatey neyii fo Hopa eeyem ya puson saatee ya eti Damas. ");
INSERT INTO krx_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Náañahanii hisaanumate ha púlooŋ, náañahanii lompo Lot niŋ hisaanumate ha hiteyoo niŋ pakaal paka niŋ pakakee paka keecokee ka. ");
INSERT INTO krx_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ta Abram naaheeke ta Ketollayomel niŋ keenanfe ka teyoo, apiyeno éñohoonii amansa ya ati Sotom náakey kapaakoolanoo t’etaam pítintiŋ pa, ti etaam ya eyya nkasok ya “Sawe” (ekina eyem “etaam ya eti amansa ya”). ");
INSERT INTO krx_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melukisetek amansa ya ati saatee ya eti Salem náayemi lompo awaaseena ati Pútuun pa piti patiila náacoopii kúmpuul niŋ elaan. ");
INSERT INTO krx_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Naasampan Abram ti hisoku nii: “Alímaati Pútuun pa piti patiila pisampan Abram! Pikina piliile patiila niŋ t’etaam. ");
INSERT INTO krx_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Alímaati Pútuun pa piti patiila púmulee! Pikina puwune anheek pikamooli.” Fiye, Abram naacoop aŋa náacoopii ya púlooŋ, naawufan Melkisedek himpaac hoonool ti kimpaac ŋaasuwan. ");
INSERT INTO krx_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Amansa ya ati Sotom naasok Abram: “Ufanam pakan paka incoop hisaanumate ha.” ");
INSERT INTO krx_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Pale Abram naañahanoo: “Haani! Inci sintooliyaa ti Ateeteyo Pútuun pa piti patiila peeliile pa patiila niŋ t’etaam, ");
INSERT INTO krx_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","nii inci eticoop waah uti awe, amansa yuu, háati nípin, háati nikopu kaasamata. Aátiyini hisoku nii: 'Inci wune Abram hisaanumate.' ");
INSERT INTO krx_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Eticoop waah niŋ fúlaa paliyal empa pákayiin paka pakatoom nkaliye pa niŋ himpaac ha hiti keenanfe ka ti inci: Anel, Esukol niŋ Mamule. Poko, an óo an teyii acoop himpaac ha hiteyoo.” ");
INSERT INTO krx_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Púful toko Ateeteyo náayisanoolo ti Abram pucuk fiye nii éyawut, naasokoo: “Timpi fe Abram! Inci fafaasi, cooy ya etii efeefom meemak.” ");
INSERT INTO krx_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Pale Abram naañahanoo: “Ateeteyo Pútuun pa putoom, weyme aafawufanam? Inci taakut añii. Eliyesel ati Damas, amiikan a atoom, afaayeno atoona ya atoom, akina afaacoop waah óo waah utoom kaatuko aawunutam epuuk.” ");
INSERT INTO krx_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Fiye Ateeteyo naasokoo: “Haani, akina tom afaatooni pale añii ya aŋa ankaakaay ya hipuku.” ");
INSERT INTO krx_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ateeteyo naacoop Abram tíkitaaŋ, naasokoo: “Sincan patiila, fin picaaŋaŋ pa niŋ aayina!” Nene asokoo: “Keesokuu maamaa lompo fiyuu efikameeŋ.” ");
INSERT INTO krx_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram náayinan ti Ateeteyo ekina ewune Ateeteyo naacokoo nii eecoonoole. ");
INSERT INTO krx_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Naasok Abram: “Inci yem Ateeteyo éefulaniyuu ya Ul ti mah ma miti pakati Kalataay kati ufani mah emme ayyem me temmo fiye, mipiyeno mitii.” ");
INSERT INTO krx_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abram naacakanoo: “Ateeteyo Pútuun pa putoom, puume inci fámeyi nii efimiyeno mutoom?” ");
INSERT INTO krx_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ateeteyo naañahanoo: “Cóopiyam ciyaan íis citi sitiil síhaaciil, ciyaan cifil citi sitiil síhaaciil, híceken sáacii hiti sitiil síhaaciil, élunt niŋ hícuucuuku.” ");
INSERT INTO krx_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram náacoopii púlukuleen pa. Naamuk po naahaac po ti pututa naayenan po púpucoonool. Pale ahaacut élunt ya niŋ hícuucuuku ha. ");
INSERT INTO krx_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Píketul mpúwanoonii kati pili efoofa ya pale Abram naayaan po. ");
INSERT INTO krx_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Caanak ca ti enow, Abram naaket niŋ hiŋotu, énimaan enfakat eefeyanana néewufalooloo. ");
INSERT INTO krx_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ateeteyo naasok Abram: “Méyi nii eehe efihitaako: keesokuu maamaa efikakin ti mah meeneetaat miteyii. Payenkuu efikayeno pimiikan nkakallanee fo sitiil sikeme sipaakiil (400). ");
INSERT INTO krx_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Pale inci fasiiŋan ti pisiya penfakat mah ma meecokii ma pimiikan, niŋ fúlaa toko éfikafulii po niŋ hisaanumate henfakat. ");
INSERT INTO krx_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Pale awe, aafamaaman meemak aapiteeket ti kásuumaay, nkahoki. ");
INSERT INTO krx_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Keesokuu maamaa efikayeno toko fo sikaay sipaakiil kapite káñohoonii ti mah emme, kaatuko eloŋ ya eenaput ya eti pakati Amol eloot ecol la fawun inci iyyaanii temmo.” ");
INSERT INTO krx_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ta caanak ca incinowe ta, énimaan ya néenakoonii, kamput háaputa niŋ kaaleew nkafiitan ti pututa púlukuleen pa péepaacinoolee pa. ");
INSERT INTO krx_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Oom hinoom Ateeteyo naaliile písiyool niŋ Abram. Naasokoo: “Inci ufanaa mah emme keesokuu maamaa, písik ti han ha hiti Esipt fo Efalat, han ha henfakat ha: ");
INSERT INTO krx_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","mah ma miti pakati Ken, Kenis, Katomon, ");
INSERT INTO krx_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","miti pakati Het, Pelis, Lefa, ");
INSERT INTO krx_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","miti pakati Amol, Kanaan, Kilukas niŋ Yepus.” ");
INSERT INTO krx_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abram aaloo Saray ayinaatoo hipuku añii, pale naataak amiikan aal ati Esipt caacawoo Hakal. ");
INSERT INTO krx_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Saray naasok Abram: “Sincan, Ateeteyo awunutam añii. Fiye káluma, hinto niŋ amiikan a atoom, pikee pa naapukam añii.” Abram naacoon hilim aaloo. ");
INSERT INTO krx_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Fiye, Saray Abram aaloo naacoop Hakal amiikan a ateyoo ati Esipt a, apuwufanoo áyiinoo kati ayeno aaloo. Ti oom caanak, Abram pakinal ti mah ma miti Kanaan fo sitiil ŋaasuwan. ");
INSERT INTO krx_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Naahinto niŋ Hakal, naasa munow. Ta naameya ta nii, niŋ munow naayem, náatin áhampaatiin a ateyoo Saray. ");
INSERT INTO krx_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Fiye, Saray naasok Abram: “Aawufanaam kúnuul enke apan inci himuumam ufanuu amiikan a atoom, fiye páawoo oopa niŋ munow náatinam. Alímaati Ateeteyo áhin anii kíiti!” ");
INSERT INTO krx_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram naañahan Saray: “Amiikan a atii oopa ti sipeesi, hínoo eeha állafiye ha.” Fiye, Saray naakallan Hakal fo naateye. ");
INSERT INTO krx_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Maleekoo ya eti Ateeteyo néekey teyoo pukol ésaapun ti káahaaŋ tes ti pítin pa peehiiŋe pa Sul. ");
INSERT INTO krx_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Neesokoo: “Hakal amiikan a ati Saray, peyme ánfulii? Peyme ayyem ti pikaayu?” Naañahan yo: “Katey áhampaatiin a atoom Saray inci iyyaake.” ");
INSERT INTO krx_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Maleekoo ya eti Ateeteyo neesokoo: “Ñoho pati áhampaatiin a atii íntuuloo.” ");
INSERT INTO krx_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Maleekoo ya eti Ateeteyo nene esokoo: “Inci fawufani hícump keesokuu maamaa, efikameeŋ fo an átayiniyii kafinu.” ");
INSERT INTO krx_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Maleekoo ya eti Ateeteyo nene esokoo: “Niŋ munow ayyem, aafapuk cikampaani, illu co caacaw ca Ismayel (ekina eyem 'Pútuun pa mpísisi'). Kaatuko Ateeteyo ásiyaasi pukooŋ pa pitii. ");
INSERT INTO krx_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Añiini áfaaciiti káakup nii fáli. Afáataakool niŋ pakan paka púlooŋ, pakan paka púlooŋ éfikataakool neyoo. Atásiyool niŋ miin ma miteyoo.” ");
INSERT INTO krx_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hakal naacakanoolo: “Fo cukaacuk pánipani aŋa eeyemaam ya ti hicuku?” Naayonkal Ateeteyo éekupe ya neyoo “Pútuun pa peecukaam pa.” ");
INSERT INTO krx_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ekina ewune nkalu ésaapun eyyuu caacaw ca ésaapun ya eti Lahay-Loyi (ekina eyem “ésaapun ya eti Eeloŋe ya eecukaam ya”). Esáapun eyyuu uyya ti pututa Kates niŋ Pelet. ");
INSERT INTO krx_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Fiye, Hakal naapuk Abram cikampaani, Abram naalu co caacaw ca Ismayel. ");
INSERT INTO krx_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ta Hakal naapuke ta Ismayel, Abram ti sitiil áwii epaakiil niŋ isak niŋ yoonool (86). ");
INSERT INTO krx_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ta Abram naataake ta sitiil áwii epaakiil niŋ kaat niŋ sipaakiil (99), Ateeteyo náayisanoolo teyoo, naasokoo: “Inci yem Pútuun pa piti sempe sa púlooŋ. Hín héesuumaam niŋ heecoonoole tan óo tan. ");
INSERT INTO krx_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Inci faliil písiyool ti pututayam niŋ awe, ínhin keesokuu maamaa kapimeeŋ fo muus.” ");
INSERT INTO krx_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram náakilipo puhooŋuyoo t’etaam, Pútuun pa mpusokoo: ");
INSERT INTO krx_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Ehe písiyool pa putoom niŋ awe: aafayeno faaf ati písii peemeeŋe. ");
INSERT INTO krx_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Caacawi etineciyeno Abram pale aafasokee Abraham (ekina eyem 'faaf ati pakan keemeeŋe') kaatuko inci fáhini faaf ati písii peemeeŋe. ");
INSERT INTO krx_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Keesokuu maamaa efikameeŋ meemak, efikayeno písii peemeeŋe, pumansa efikapukee teyii. ");
INSERT INTO krx_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Inci fasiiŋan písiyool pa putoom niŋ awe niŋ epuuki niŋ epuuki epuukii ti ekaay óo ekaay. Písiyool empuu efipisiiŋo fo eket maama, inci iyyeno Pútuun pa pitii niŋ piti keesokuu maamaa keekaakaay ka ékey po hátikin. ");
INSERT INTO krx_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Inci fawufani mah ma miti Kanaan la ayyem la fiye samat nii akaawoola, fawufani mah emmuu púlooŋ, awe niŋ keesokuu maamaa, éfimiyenoonii miteyii fo eket maama inci iyyeno Pútuun pa piteyii.” ");
INSERT INTO krx_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Pútuun pa nene pusok Abraham: “Awe niŋ epuuki niŋ epuuki epuukii ti ekaay óo ekaay fo nítuul písiyool pa putoom. ");
INSERT INTO krx_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ehe písiyool pa putoom niŋ awe niŋ epuuki niŋ keesokuu maamaa: áyiin óo áyiin afaanakanee. ");
INSERT INTO krx_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Háakum eehuu ti siniin aluu efihiyeno píyisan pa piti písiyool pa putoom niŋ aluu. ");
INSERT INTO krx_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Cikampaani óo cikampaani eficinakanee niŋ citaakaa kunoom isak niŋ káhaaciil ti ekaay óo ekaay. Innakan lompo keekufut ka ti miin ma mitii: pimiikan pa keepukee ka lati awe niŋ payenka ánnoomii ka pállaaŋe. ");
INSERT INTO krx_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Poko púlooŋ kañaŋee kanakan, pimiikan pa keepukee ka ti ekumpaan ya etii niŋ payenka annoome ka niŋ mañi. Fiyuu písiyool pa putoom efipiyeno háakum ti siniin aluu, písiyool peepayantoo. ");
INSERT INTO krx_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ayíin óo áyiin eenakanutee afaayaanee ti pakanoo kaatuko átuulut písiyool pa putoom.” ");
INSERT INTO krx_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Pútuun pa nene pusok Abraham: “Timpi neeyonkal aali Saray, písik fíyooy caacawoo Sara. ");
INSERT INTO krx_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Inci fasampanoo naapuki añii akampaani. Inci fasampanoo naayeno íññaa ati kayoŋ písii, pumansa pakati písii peemeeŋe efikapukee ti keesokoo maamaa.” ");
INSERT INTO krx_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham náakilipo puhooŋuyoo t’etaam naayeno caalenken ti esokoolo: “Fo áyiin ati sitiil keme áfaayini hitaaku añii? Fo Sara áfaayini hitaaku añii, akina pataakal sitiil áwii epaakiil niŋ ŋaasuwan (90)?” ");
INSERT INTO krx_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Fiye, Abraham naasok Pútuun pa: “Fo aatikat Ismayel aputoon kaasampan enka áayinananaam ka nii aafawufanam?” ");
INSERT INTO krx_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Pútuun pa mpiñahanoo: “Haani, Sara aali afaapuki cikampaani, aakati lu co caacaw ca Isaak. Neyoo inci faliil písiyool pa putoom niŋ epuukoo niŋ keesokoo maamaa, písiyool peepayantoo. ");
INSERT INTO krx_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Síyaasi kaluum ka kitii kiti Ismayel, inci fasampanoo uwwufanoo miin meemeeŋe fo muus, keesokoo maamaa efikameeŋ meemak. Afaayeno faaf ati pakati kikaw ŋaasuwan niŋ pákasupak naayeno maamaa ati síi enfakat. ");
INSERT INTO krx_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Pale písiyool pa putoom, inci fasiiŋan po niŋ Isaak, añii ya aŋa Sara naakaakaay ya hipuku pulay ti caanak ence.” ");
INSERT INTO krx_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ta Pútuun pa mpipaye ta káakup niŋ Abraham mpikaay. ");
INSERT INTO krx_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ti oom hinoom Abraham naacoope añiinoo Ismayel niŋ pimiikan pa keepukee ka ti ekumpaan ya eteyoo niŋ pimiikan pa payenka naanoome ka. Pákayiin paka púlooŋ pakati ekumpaan ya eteyoo nkanakanee samat nii fa Pútuun pa mpusoke fa. ");
INSERT INTO krx_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham ta naataake ta sitiil áwii epaakiil niŋ kaat niŋ sipaakiil (99) naanakiye. ");
INSERT INTO krx_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Tempo añiinoo Ismayel naataake sitiil ŋaasuwan niŋ síhaaciil. ");
INSERT INTO krx_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abraham niŋ añiinoo nkanako ti hinoom eehuu, ");
INSERT INTO krx_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","niŋ pákayiin paka púlooŋ pakati ekumpaan ya eteyoo: pimiikan pa keepukee ka lateyoo niŋ payenka naanoome ka. ");
INSERT INTO krx_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ateeteyo náayisanoolo ti Abraham pukol punuun pa peesampanee pa piti Mamule. Tempo Abraham naayeno ti putum pa piti ékuut ya eteyoo, caanak ca ti kikaw. ");
INSERT INTO krx_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Naasincan naacuk pákayiin pákahaaciil nkasiiŋiye hátikinoo naatey apipaakoolanii náakilipo puhooŋuyoo t’etaam. ");
INSERT INTO krx_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Naasok oonool ti poko: “Ahámpaatiin, luumuu timpi muusam, inci amiikan a atii. ");
INSERT INTO krx_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Káluma, nítuul kápucoopii aluu man nipiñow woot aluu niŋ fúlaa toko ínniyekunoolo t’etaam enuun eyye. ");
INSERT INTO krx_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Inci púcoopii aluu paliyal nipili ancuk nitaakaa sempe siti kaahankan pítin aluu, páawoo níkeyyookey ti inci amiikan a ataaluu.” Nkañahanoo: “Iyyoo napaanap, hín samat nii fa ansoke fa.” ");
INSERT INTO krx_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Fiye, Abraham naawaaf pati ékuut ya eteyoo, naasok Sara: “Hiliikan niik siniiku síhaaciil senfakat ti efol ya eehaŋe ya panap, aapimemanool kúmpuul.” ");
INSERT INTO krx_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Púful toko Abraham naatey pati koolee ya eteyoo naacok cíciin ceeluuke naawufan co akee amiikan apimemanool co mpacas. ");
INSERT INTO krx_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ta efoofa ya neeyike ta, Abraham naawufan yo ekaawoola ya niŋ miin niŋ feenee. Naasiiŋo pukolii t’etaam enuun ya, ekaawoola ya nkayeno hili. ");
INSERT INTO krx_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Nkacakanoo: “Aali Sara uwwey?” Naañahanii: “Oopa pati ékuut ya.” ");
INSERT INTO krx_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Akee teyii naasokoo: “Pulay ti caanak ence inci fáñohoonii, tempo aali afaataak cikampaani.” Sara naayeno ti putum ékuut ya puson Abraham ti káasiitan. ");
INSERT INTO krx_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham niŋ Sara keemaamane, Sara naamuus hitaaku añii. ");
INSERT INTO krx_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sara naayeno caalenken faŋoo naasok: “Inci kaahaan enke, malla faleñam ti áyiin apan áyiinam lompo eemaamane.” ");
INSERT INTO krx_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Fiye, Ateeteyo naasok Abraham: “Weyme uwune Sara naalenken naasok: 'Fo pánipani inci fáyini hitaaku añii pamaamanal?' ");
INSERT INTO krx_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Fo taakaataak waah weeheeke inci Ateeteyo? Pulay ti caanak ence fáñohoonii, Sara afaataak cikampaani.” ");
INSERT INTO krx_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara náalaacin ti hisoku: “Inci lenkenut” kaatuko afeyaafe. Ateeteyo naasokoo: “Pánipani aalenkenaa-lenken!” ");
INSERT INTO krx_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Púful toko, pákayiin paka nkalito kati kakaay. Nkacok pítin pa piti saatee ya eti Sotom Abraham naayeniyii kátiŋan. ");
INSERT INTO krx_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ateeteyo naasok: “Láfiit hiyolu Abraham eeha inci inkaakaay ha íhinu. ");
INSERT INTO krx_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Kaatuko Abraham áfaayenoonii maamaa ati síi enfakat neetaak sempe, apan pínapii teyoo fasampan písii pa púlooŋ piti etaam ya. ");
INSERT INTO krx_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Inci mamaloo kati awufan hilim epuukoo niŋ keesokoo maamaa kati kacok pítin pa putoom nkawen pucoonool niŋ kaalehanool. Ancuk inci ufanaa Abraham eeha inci íyyinananoo ha.” ");
INSERT INTO krx_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Fiye, Ateeteyo naasok Abraham: “Hinookuyee ha hiti pakati Sotom niŋ Komola hifomaafom, umuuyen wa uteyii núunapi meemak. ");
INSERT INTO krx_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Puwano picaasincan man eeha nkanookii ha fo hícolii ti inci heetaakiye niŋ fotom inci fámeyi.” ");
INSERT INTO krx_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ta Ateeteyo naapaye ta káakup, pákayiin paka pákasupak paka nkahiiŋ Sotom. Pale Abraham naatowo naasiiŋiye hátikin Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham naateeŋo pati Ateeteyo naasokoo: “Fo pánipani aafamuk ti coonool keecoonoole ka niŋ keemuuyene ka? ");
INSERT INTO krx_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Iyyema po Sotom taakaa pakan áwii ésupak niŋ ŋaasuwan (50) keecoonoole, fo pánipani áafapucalool saatee ya? Fo aatiponket yo kamma áwii ésupak niŋ ŋaasuwan ya keecoonoole ka keekine ka po? ");
INSERT INTO krx_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Haani áatiyini íhinu eehuu! Aapumuk ti coonool keecoonoole ka niŋ keemuuyene ka! Incok keecoonoole ka nii keemuuyene ka, eehuu hiyinaat pitaako! Fo áhina kíiti ya ati etaam ya púlooŋ átahin heecoonoole?” ");
INSERT INTO krx_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ateeteyo naasokoo: “Niŋ inci tookaa pakan áwii ésupak niŋ ŋaasuwan keecoonoole ti saatee ya eti Sotom inci faponket saatee ya púlooŋ kamma poko.” ");
INSERT INTO krx_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham nene asokoo: “Ponketam Ahámpaatiin a atoom, inci háañiye káakup niŋ awe, inci eeneetaat a likee fo niŋ fúlaa etaam niŋ píiha. ");
INSERT INTO krx_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Iyyema keecoonoole ka pakan áwii ésupak niŋ isak (45) me? Fo áafapucalool saatee ya púlooŋ kamma isak ya?” Ateeteyo naañahanoo: “Etípucalool saatee ya niŋ inci tookaa toko pakan áwii ésupak niŋ isak keecoonoole.” ");
INSERT INTO krx_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham nene asokoo: “Iyyema me pakan áwii ésupak (40) kayem toko?” Ateeteyo naañahanoo: “Kamma áwii ésupak ya étipucalool saatee ya.” ");
INSERT INTO krx_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham nene asok: “Ahámpaatiin a atoom, inci luumuu timpi ñíken pale katampo púkup. Iyyema me pakan áwii niŋ ŋaasuwan (30) kayem toko?” Ateeteyo naañahanoo: “Niŋ inci tookaa po pakan áwii niŋ ŋaasuwan keecoonoole étipucalool saatee ya.” ");
INSERT INTO krx_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham naasok: “Ponketam Ahámpaatiin a atoom, inci háañiye káakup niŋ awe. Iyyema me pakan áwii kayem toko?” Ateeteyo naañahanoo: “Kamma áwii ya étipucalool saatee ya.” ");
INSERT INTO krx_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abraham naasok: “Ahámpaatiin a atoom, inci luumuu timpi ñíken pale katampo púkup pikelanam umpe. Iyyema me pakan ŋaasuwan kayem toko?” Ateeteyo naañahanoo: “Kamma ŋaasuwan ya étipucalool saatee ya.” ");
INSERT INTO krx_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ta Ateeteyo naapaye ta káakup niŋ Abraham naakaay, Abraham naañoho pateyoo. ");
INSERT INTO krx_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Simaleekoo sa súsupak sa insicol Sotom nkániim. Tempo, Lot naayeno ti híkon ti putum saatee ya. Emma naacukii ma naalito apicaapaakoolanii náakilipo puhooŋuyoo t’etaam. ");
INSERT INTO krx_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Púful toko naasokii: “Inci luume aluu, niponket níkey niwanan lati inci amiikan a ataaluu. Efíniyini puñowu woot aluu inniŋot; kacom mpucom mic, innihankan pítin pa piti aluu.” Pumaleekoo pa mpiñahan Lot: “Haani, efuuŋot ti híliŋ ha hiti saatee ya.” ");
INSERT INTO krx_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Pale Lot naaŋiiniyii meemak fo kacoon. Fiye nkakaay lateyoo. Naamemanoolii paliyal, naasowii kúmpuul keetaakut leweñoo, púful toko nkali. ");
INSERT INTO krx_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Peelokot kahinto, pákayiin paka púlooŋ pakati saatee ya nkákinkool ekumpaan ya eti Lot, písik ti akampaani fo ti kaahaan. ");
INSERT INTO krx_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Nkayonkal Lot nkasokoo: “Unkey, pákayiin paka kéenakoonii ka leti awe nkániim ke? Fúlaniyii upuhinto neyii!” ");
INSERT INTO krx_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot náafulii naasiiŋo ti putum pa naapank hunkut ha pusonoo. ");
INSERT INTO krx_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Naasokii: “Niponket, aluu pákawiyam, timpi níhin heenaput eehuu! ");
INSERT INTO krx_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Inci oopa taake púmaacul pákasupak kéemiit áyiin, inci púcoopiyii nípihinii eeha ínnilafiye ha. Pale timpi níhin pákayiin paka payenke waah kaatuko ti sipeesam nkayem.” ");
INSERT INTO krx_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Nkañahanoo: “Fúl le!” Nene kasok: “Nisincan akaawoola ya aŋe, fiye náalafi piyeno áhina kíiti letuunaa! Efúuhini pihaŋ paseeñ pákayiin paka payenke.” Nkahalap Lot niŋ sempe nkaloh hunkut ha kati kahaat ho. ");
INSERT INTO krx_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Pale pumaleekoo pa mpípankin hunkut ha, mpíñak Lot pipinakanoo páhantuwa mpipank. ");
INSERT INTO krx_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Mpúfuuman pákayiin paka púlooŋ keeyeniye ka ti putum pa, písik ti añii fo ti áhampaatiin, ancuk étikayini hicuku hunkut ha. ");
INSERT INTO krx_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Simaleekoo sa súsupak sa insisok Lot: “Pakayme pakan antaake le? An óo an aŋa antaake le ti saatee ya samat nii pakaasoni, epuuki pikampaani niŋ púmaacul, fúlanii, ");
INSERT INTO krx_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","kaatuko unii káapucalool eteyyo nuukaakaay. Ateeteyo ásiyaasi hinookuyee ha henfakat ha hiti saatee eyye ekina ewune mpúpoñii unii káapucalool eteyyo.” ");
INSERT INTO krx_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Fiye, Lot náaful apikaasok pakaasonoo keeñaŋe ka esa púmaacul pa pakateyoo: “Nihiliikan nípiful ti saatee eyye kaatuko Ateeteyo káapucalool eteyyo naakaakaay!” Pale pakaasonoo incukii nii Lot pahaaño naayeniye. ");
INSERT INTO krx_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Nuulap, pumaleekoo pa mpiŋiino Lot apikaay, mpusokoo: “Lito coop aali niŋ púmaacul pa pákasupak paka pakatii ínniful le, niŋ ekina tom efiniket niŋ pakati saatee ya. Ee, éfikapucaloolee kamma heenaput ha eeha nkáhine ha.” ");
INSERT INTO krx_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Pale Lot naayeno kaakuuteen; fiye, pumaleekoo pa mpucokoo ti epees niŋ aaloo niŋ púmaacul pa pákasupak paka pakateyoo mpúfulanii tíkitaaŋ saatee ya, kaatuko Ateeteyo ataakaataak paket hikaw ti Lot. ");
INSERT INTO krx_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ta mpúfulanii ta tíkitaaŋ, yoonool tempo neesok Lot: “Tey aapifakan eloŋi, timpi welep puson, timpi lompo siiŋo lakeenaay. Tey fo pati pítintiŋ pa náalafiit eket.” ");
INSERT INTO krx_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lot naañahan yo: “Haani étiyini Ahámpaatiin! ");
INSERT INTO krx_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Aataakaataak paket hikaw ti inci amiikan a atii uwwen niŋ panap penfakat ti inci aapifakan eloŋam. Pale inci étiyini katey fo pati pítintiŋ pa le niŋ áafahin hítaapanu eehuu, efiket. ");
INSERT INTO krx_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Aacukaacuk cisaatee ence? Cílaaŋut fáyini katey fo toko piyolo tenco, cifomut, apan inci fafak.” ");
INSERT INTO krx_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Maleekoo ya neesokoo: “Iyyoo inci fáhin eeha alluume ha, étipucalool cisaatee encuu. ");
INSERT INTO krx_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Pale hiliikan caayolo tenco kaatuko étiyini íhinu waah taamanta aacolut.” Po hátikin nkalu cisaatee ca caacaw ca Sowal, ekina eyem “cenkilis”, kaatuko Lot asok: “Cifomut”. ");
INSERT INTO krx_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ta caanak ca inciyeniye ta éfulii, Lot naacol Sowal. ");
INSERT INTO krx_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Fiye, Ateeteyo náanupanii ti Sotom niŋ Komola etiil eti seemak niŋ kíceek. ");
INSERT INTO krx_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Náapucalool sisaatee sa súsupak sa niŋ etaam ya púlooŋ éekinkoolii ya, niŋ pakan paka niŋ waah óo waah weeŋante toko. ");
INSERT INTO krx_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Pale Lot aaloo naawelep puson, himuumoo nihiyeso hisiin hiti micempanu. ");
INSERT INTO krx_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ti oom hinoom, Abraham naalito mpucom mic naakaasiiŋo la naasiiŋiye la hínum hátikin Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Naasincan kaapii ka kiti Sotom niŋ Komola niŋ etaam ya púlooŋ éekinkoolii ya naacuk háaputa nihisilosilo pucuk nii seemak senfakat. ");
INSERT INTO krx_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Fiyuu Pútuun pa mpúpucaloole pisaatee pa piti etaam ya éekinkoole ya han ha hiti Jordan, pifiilut Abraham mpifakan Lot ti káapucalool ka kiti pisaatee pa la Lot naakine la hínum. ");
INSERT INTO krx_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot náaful Sowal naasilo kati akin ti pítintiŋ pa niŋ púmaacul pa pákasupak paka pakateyoo, kaatuko afeyaafe piyeno Sowal. Naacaakin neyii ti kaayeen kenfakat ti tíntiŋ. ");
INSERT INTO krx_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Fiye, ámaacul a áhampaatiin a naasok kahiineen ka: “Paapaa ataanii amaamanaa-maaman, áyiin ataakiit ti mah emme kati maanimiyaa samat nii fa ínhinee fa pan óo pan. ");
INSERT INTO krx_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kéy, maawufanaa paapaa ataanii elaan immaahintiyaa neyoo kati maataakaa miin méefulii teyoo.” ");
INSERT INTO krx_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Hánant eehuu, nkawufan paapaa ateyii elaan, áhampaatiin a naahinto niŋ paapaa ateyoo, Lot ápannumut heetaakiye ha ta ámaacul a ateyoo naahintiye ta neyoo fo alito. ");
INSERT INTO krx_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Eti kacom eteyyo áhampaatiin a naasok kahiineen ka: “Inci hintaahinto niŋ paapaa ataanii hánant ha heemuuse ha. Nene maawufanoo elaan hánant eehe incaahinto neyoo ancuk maataakaa miin méefulii teyoo.” ");
INSERT INTO krx_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Hánant eehuu nkawufan paapaa ateyii elaan, kahiineen ka nkihinto neyoo. Lot nene ápannumut heetaakiye ha ta ámaacul a ateyoo naahintiye ta neyoo fo alito. ");
INSERT INTO krx_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Fiye, púmaacul pa pákasupak paka pakati Lot nkasa munow miti paapaa ateyii. ");
INSERT INTO krx_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Po hátikin, áhampaatiin a naapuk cikampaani naalu co caacaw ca Mowap (ekina eyem “éefulii ti paapaa”): akina ayem paapaa ya ati pakati Mowap fo fíyooy. ");
INSERT INTO krx_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Kahiineen ka lompo nkupuk cikampaani nkulu co caacaw ca Pen-Ammi (ekina eyem “añii ati miin ma mutoom”): akina ayem paapaa ya ati pakati Ammon fo fíyooy. ");
INSERT INTO krx_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham náaful toko naahiiŋ ti káahaaŋ ka tes kiti Nekep. Naacaakin ti pututa Kates niŋ Sul, púful toko naacaayeno Kelal. ");
INSERT INTO krx_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ta naayeniye ta po, Abraham nasok tan óo tan pakan paka nii aaloo Sara ahoopoo. Ekina ewune Apimelek amansa ya ati Kelal naapoñ kápucoopiyoo Sara. ");
INSERT INTO krx_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Fiye, Pútuun pa mpíyawutan Apimelek niŋ hánant, mpusokoo: “Aafaket kamma aal a aŋa áncoopii ya, kaatuko eenimiye.” ");
INSERT INTO krx_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Pale Apimelek aloot ahinto neyoo, naañahan po: “Pútuun, inci niŋ pakanam úhinut waah, háati fo aafamuk unii? ");
INSERT INTO krx_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ayíin a faŋoo asokaam nii, ahoopoo. Aal a lompo naasok nii, ahoopoo. Pámiiloolalam peewalla sipeesam insikuul ta inci iyyeniye ta íhinu eehuu.” ");
INSERT INTO krx_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Pútuun pa mpiñahanoo ti éyawut ya: “Méyimeyi nii ti pámiiloolal peewalla ánhine eehuu, ekina ewune inci inkiti hílikuyoo ancuk aatimuuyen ti inci. ");
INSERT INTO krx_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Fiye, ñahan aal a ti áyiinoo kaatuko ayaamakoola, afaaluum kitii, aafaloŋ. Pale naañahanutoo, méyi nii aafaket awe niŋ miin ma mitii púlooŋ.” ");
INSERT INTO krx_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Cipilap, Apimelek naalito mpucom mic, naayonkal píhina pa pakateyoo púlooŋ naakamanii heetaakiyoo ha, poko púlooŋ nkafe meemak. ");
INSERT INTO krx_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Fiye, Apimelek náayonkalii Abraham naasokoo: “Weyme ánhine unii fiye? Enkeyme kaamuuyen inci immuuyene ti awe aakati wun inci niŋ cáwii ca citoom nuunako ti kaamuuyen kenfakat? An añaŋut íhinu eeha ánhinaam ha!” ");
INSERT INTO krx_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Apimelek nene acakan Abraham: “Weyme uwune ánhin eehe?” ");
INSERT INTO krx_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham naañahanoo: “Míiloolaa-míilool nii pakan paka pakati le kafeyut Pútuun pa, efikamukam kamma aalam. ");
INSERT INTO krx_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Apan pánipani ahoopam, faaf nuukufe ukufut íññaa, fiye náayenoonii aalam. ");
INSERT INTO krx_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ta Pútuun pa mpusokaam ta inci katan ekumpaan ya eti paapaa atoom iyyeno kaatootoosool, insok aalam: 'Ehe fiye aññaŋe káyisan nii áalafiyaamlafi: pan óo pan immaakaayaa insok nii inci ahoopi.'” ");
INSERT INTO krx_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Púful toko, Apimelek naacoop písaacii, pifil, síis niŋ pimiikan pákayiin niŋ pakaal naawun po Abraham naañahanoo aaloo Sara. ");
INSERT INTO krx_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Apimelek naasokoo: “Mah ma mutoom umma hátikini, kin lan óo lan la súumuu.” ");
INSERT INTO krx_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Púful toko naasok Sara: “Inci ufanaa ahoopi sikoofali wúli; hínaahin eehuu píyisan pakani nii aakuulaakuul, áahinut waah weenaput.” ");
INSERT INTO krx_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abraham naaluum Pútuun pa, mpúkuuñan Apimelek niŋ aaloo niŋ pimiikan pa pakateyoo pakaal paka, nkáyini hitaaku epuuk. ");
INSERT INTO krx_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Kaatuko Ateeteyo áhinaahin pakaal paka keeyeniye ka ti ekumpaan ya eti Apimelek picaakonta kamma Sara Abraham aaloo. ");
INSERT INTO krx_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ateeteyo naatah kunuuwoo ti Sara samat nii fa naasokoo fa, náahinoo eeha náayinananoo ha. ");
INSERT INTO krx_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara naasa munow, Abraham ti himaamanoo, náapukiyoo ciñii cikampaani ti caanak enca Pútuun pa mpíyinananoo ca. ");
INSERT INTO krx_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ciñii enca Sara naapukoo ca, Abraham naalu co caacaw ca Isaak. ");
INSERT INTO krx_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ta añiinoo Isaak naataake ta kunoom isak niŋ káhaaciil, Abraham naanakanoo samat nii fa Pútuun pa mpusokoo fa. ");
INSERT INTO krx_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham ti sitiiloo keme (100) Isaak naapukee. ");
INSERT INTO krx_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara naasok: “Pútuun pa puwasaam caalenken, an óo an éesiye eeha mpíhinaam ha afaalenken niŋ inci.” ");
INSERT INTO krx_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Púful toko naasok: “Ayme ayina hisoku Abraham nii hikee hinoom Sara áfaacuuwan epuuk? Pale inci pukoopuk cikampaani ti himaamanoo.” ");
INSERT INTO krx_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isaak náayankii, Sara náafulanoo ti káacuu. Hinoom eehuu Abraham náahin pahaaño penfakat. ");
INSERT INTO krx_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sara naacuk Ismayel, añii ya aŋa Hakal ati Esipt a naapuke ya Abraham, ti káapalahool niŋ caalenken Isaak. ");
INSERT INTO krx_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Fiye Sara naasok Abraham: “Yaan amiikan a aŋuu niŋ añiinoo! Añiinoo átayini pípaacinool hisaanumate ha hitii niŋ añiinam Isaak.” ");
INSERT INTO krx_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Kilim enkuu nkuwas Abraham kúnuul kenfakat kamma Ismayel lompo naayem añiinoo. ");
INSERT INTO krx_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Pale Pútuun pa mpusokoo: “Timpi liim kiti añii ya niŋ amiikan a atii. Hín eeha púlooŋ Sara naasokuu ha. Kaatuko ti Isaak aafataak miin emma inci íyyinananuu ma. ");
INSERT INTO krx_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Inci fáhin lompo añii ya ati amiikan a atii maamaa ati síi kaatuko akina lompo añiini.” ");
INSERT INTO krx_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Eti kacom eteyyo mpucom mic Abraham naacoop kúmpuul niŋ kapaŋ kúwasuma man naameeŋan ko, naanaŋ ko ti káapanti Hakal náawutakanoo añiinoo náafulanii lateyoo. Hakal naayeno kaamuumuusool ti káahaaŋ ka tes kiti Beerseba. ");
INSERT INTO krx_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ta man ma immipaye ta ti kapaŋ ka naayenan añii ya t’etaam cinuun. ");
INSERT INTO krx_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Púful toko naayeno pílaaŋ máamun pawantal hiŋaaceen náapaho, naasokoolo: “Inci yinaat kaasincan añiinam ti eket.” Naayeno pukooŋ. ");
INSERT INTO krx_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Pútuun pa mpísi pakooŋal añii ya, hilim ha hiti maleekoo ya eti Pútuun pa níhifulii patiila, nihiyonkal Hakal nihisokoo: “Hakal, weyme utaakiye? Timpi fe, kaatuko Pútuun pa písiyaasi añii ya ti pukooŋ la naahintiye la. ");
INSERT INTO krx_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Lito incaalitan añii ya incokoo t’epees kaatuko inci fáhin apiyeno maamaa ati síi enfakat.” ");
INSERT INTO krx_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Púful toko, Pútuun pa mpípankin ñíkin Hakal naaŋantan ésaapun. Náacaameeŋanii kapaŋ ka kiteyoo naawufan añii ya apilaan. ");
INSERT INTO krx_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Fiye, Pútuun pa mpiyeno niŋ añii ya ta naayeniye ta éyankii ti káahaaŋ tes, naayeno aleemaya ati hiŋaaceen. ");
INSERT INTO krx_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Naakin ti káahaaŋ ka tes kiti Palan, íññaa ateyoo naawufanoo aal ati mah ma miti Esipt. ");
INSERT INTO krx_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ti caanak encuu, amansa ya Apimelek niŋ Fikol, áhampaatiin a ati pusoocaali pa pakateyoo, nkákey nkasok Abraham: “Pútuun pa umpa niŋ awe ti waah óo waah ewwa ánhine. ");
INSERT INTO krx_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Fiye sintoolo hátikin Pútuun pa nii áatiful ti inci, ti epuukam niŋ ti epuukam papukalii. Inci yenaayeno eenape ti awe, awe lompo wen niŋ panap ti inci niŋ ti pakati mah ma emma ankine ma temmo nii akaawoola.” ");
INSERT INTO krx_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham naañahanoo: “Inci sintooliyaa.” ");
INSERT INTO krx_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Pale, Abraham naawatan Apimelek kamma ésaapunoo eyya pimiikan Apimelek nkalame. ");
INSERT INTO krx_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Apimelek naañahanoo: “Inci míit ayme áhine eehuu, aataapala sokam, pásiyalam eteeho umpe fíyooy.” ");
INSERT INTO krx_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Fiye, Abraham naacoop písaacii, pifil niŋ síis naawun po Apimelek. Poko t’ésupakii nkaliil písiyool. ");
INSERT INTO krx_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham naayenan ti kaapii miyaan mísaacii isak niŋ músupak. ");
INSERT INTO krx_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Apimelek naasok Abraham: “Miyaan mísaacii ma isak niŋ músupak ma emma ayyenane ma ti kaapii, miti weyme?” ");
INSERT INTO krx_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Naañahanoo: “Káluma, coop mo mípiyisan nii aacoonaacoon nii inci wake ésaapun ya.” ");
INSERT INTO krx_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ekina ewune nkalu toko caacaw ca Beerseba (ekina eyem “ésaapun eti esintoolo”). Kaatuko poko t’ésupakii toko nkasintooliye. ");
INSERT INTO krx_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Papayalii hiliilu písiyool pa piteyii Beerseba, Apimelek niŋ Fikol, áhampaatiin a ati pusoocaali pa pakateyoo, nkañoho ti mah ma miti pakati Filistin. ");
INSERT INTO krx_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham naasuk timpiŋ ti mah ma miti Beerseba naaluum toko ti caacaw Ateeteyo, Pútuun pa piti cancowiyaaw. ");
INSERT INTO krx_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Naakampan ti mah ma miti pakati Filistin. ");
INSERT INTO krx_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Po hátikin Pútuun pa mpiyoop káyinan ka kiti Abraham. Mpiyonkaloo: “Abraham!” Abraham naañahan po: “Eheeyam.” ");
INSERT INTO krx_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Pútuun pa mpusokoo: “Coop añiini Isaak, añiini oonool a kóŋ aŋa állafiye ya fo muus, inkaay ti mah ma miti Moliya ti tíntiŋ eyya inci inkaakaayi ya káyisan, toko uwwaaseenamoo aapusowoo fo aleem.” ");
INSERT INTO krx_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Eti kacom eteyyo, Abraham naalito mpucom mic naahawalool miyaac ma miti kaawaaseen ka náayuuk mo ti fáli ya eteyoo, naacoopool pákasupak ti píhina pa pakateyoo niŋ añiinoo Isaak lompo, nkahiiŋ pa Pútuun pa mpusokoo pa. ");
INSERT INTO krx_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Eti tílapooli eteyyo, Abraham náahaafin naaŋantan tíntiŋ ya la naañaŋe la pikaayu. ");
INSERT INTO krx_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Naasok píhina pa pakateyoo: “Niyeno le niŋ fáli ya, inci niŋ añiinam nuusilo patiila tíntiŋ eyya pa kaawaaseen Pútuun pa, núupayiyoo núuñohoonii.” ");
INSERT INTO krx_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham naatiyan añiinoo Isaak miyaac ma miti kaawaaseen ka, akina himuumoo naayekan seemak sa niŋ épila ya, nkakaay poko t’ésupakii. ");
INSERT INTO krx_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ti oom pikaayu, Isaak naasok Abraham: “Paapaa?” Abraham naañahanoo: “Eeya sokam añiinam.” Isaak naasokoo: “Maataakaataak seemak niŋ miyaac pale sáacii ya eti kaawaaseen ka uyyey?” ");
INSERT INTO krx_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham naañahanoo: “Añiinam, Pútuun pa faŋ etempo efipuwufan sáacii ya eti kaawaaseen ka.” Poko t’ésupakii nkayeno pikaayu. ");
INSERT INTO krx_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ta nkacole ta la Pútuun pa mpusokoo la, Abraham naalut toko kaaciin naawas toko miyaac ma. Naacenk añiinoo Isaak naanaŋoo ti kaaciin ka patiila miyaac ma. ");
INSERT INTO krx_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Fiye, naañaakan epeesoo naacoop épila ya kati ataaŋ añiinoo. ");
INSERT INTO krx_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ti oom káasiiŋuma, hilim ha hiti maleekoo ya eti Ateeteyo níhifulii patiila nihiyonkaloo: “Abraham, Abraham!” Abraham naañahan yo: “Eheeyam.” ");
INSERT INTO krx_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Neesokoo: “Timpi lík añii ya, timpi kuumoo! Fiye inci meya nii aafeyaafe Pútuun pa kaatuko aapookutam kawufan añiini, añiini oonool a kóŋ.” ");
INSERT INTO krx_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Fiye, Abraham náahaafin naaŋantan híceken sáacii, usiin eteeho nuukalapatanoolo ti cisooy. Náakaacoopii ho naawaaseen ho apusow ho fo hileem ti putum pa piti añiinoo. ");
INSERT INTO krx_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraham naalu toko caacaw ca: “Ateeteyo afaawufan”. Ekina ewune fo fíyooy nkasok tan óo tan: “Ti tíntiŋ ya eti Ateeteyo, Ateeteyo afaawufan.” ");
INSERT INTO krx_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Hilim ha hiti maleekoo ya eti Ateeteyo nene hífulii patiila nihiyonkal Abraham púsupiyenu. ");
INSERT INTO krx_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Nihisokoo: “Ehe eeha Ateeteyo naasoke ha: 'Páawoo áatuulaamtuul aapookutam kawufan añiini, añiini oonool a kóŋ, inci sintooliyaa ti faŋam nii, ");
INSERT INTO krx_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","pánipani fasampani, keesokuu maamaa efikameeŋ samat nii picaaŋaŋ pa, niŋ esiya ya eti kaatii ka. Keesokuu maamaa efikalam pisaatee pa piti pikamoolii. ");
INSERT INTO krx_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Pínapii teyii, písii pa púlooŋ piti etaam ya efipisampanee kamma ántuulaam.'” ");
INSERT INTO krx_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Púful toko, Abraham niŋ añiinoo nkañoho pati píhina pa pakateyoo. Nkanapool kapuñoho Beerseba pa Abraham naakine pa. ");
INSERT INTO krx_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Eehuu hipimuus, Abraham náasi nii Miluka aal a ati Nahol Abraham atuwoo ataakaataak lompo epuuk pikampaani: ");
INSERT INTO krx_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Us, añii ya áyaañ a, Pus atuwoo, Kemuwel paapaa ati Alam, ");
INSERT INTO krx_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Keset, Haso, Pilatas, Yitalaf niŋ Petuwel. ");
INSERT INTO krx_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Petuwel ayem paapaa ati Rebeka. Payenkuu kayem epuuk ya isak niŋ pákahaaciil paka payenka Miluka naapuke ka Nahol, Abraham atuwoo. ");
INSERT INTO krx_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahol naataak aal ásupiyenu, caacawoo Leyuma. Naapuk lompo epuuk, nkasokee Tepah, Kaham, Tahas niŋ Maaka. ");
INSERT INTO krx_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara naaloŋ sitiil keme niŋ áwii niŋ isak niŋ súsupak (127). ");
INSERT INTO krx_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Naaket Kiliyat-Alepa (ekina nkasok fiye Hepolon) ti mah ma miti Kanaan. Abraham náahin keeŋoot ka kiti aaloo naakooŋoo. ");
INSERT INTO krx_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Púful toko naalito pukol ehunuŋ ya eti aaloo náacaakup niŋ keesoke Het maamaa. ");
INSERT INTO krx_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Naasokii: “Inci akaawoola leti aluu, nicoon kaanoomanam káahokuma ancuk inci yina ihoku aalam.” ");
INSERT INTO krx_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Keesoke ka Het maamaa nkañahanoo: ");
INSERT INTO krx_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Ahámpaatiin, síitan unii, unii uluumuu: Pútuun pa píhinuu ati hikaw ti pututa unii. Hok aali ti hiyaak ha heehaŋe ha panap ti kiyaak ka kutoonii. An toonii atapooki kawufan hiyaakoo aakati hok aali.” ");
INSERT INTO krx_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Fiye Abraham naalito, náaŋok hátikin keesoke Het maamaa keekine ka ti mah ma, ");
INSERT INTO krx_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","naasokii: “Nísiitanam, niŋ nicoonaa pánipani puhok aalam le, káluma niluumam Efulon, añii ya ati Sohal, ");
INSERT INTO krx_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","anoomanam kaayeen ka kenfakat ka keeyem ka Makapela. Kiteyoo, apan nkíyemi ti pikelan kaakit ka kiteyoo. Anoomanam ko ti soŋ etenko hátikin aluu kati kiyeno íhokuma ha hitoom leti aluu.” ");
INSERT INTO krx_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Tempo Efulon ti pututa pakanoo, keesoke Het maamaa, naañahan Abraham hátikin keesoke ka púlooŋ Het maamaa keeyeniye ka ti putum pa piti saatee ya eteyoo, ");
INSERT INTO krx_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","naasokoo: “Ahámpaatiin, síitanam inci luumuu, kaakit ka inci wunuu ko, kaayeen ka keeyem ka ti kaakit ka lompo inci wunuu ko hátikin pakanam. Hok toko aali.” ");
INSERT INTO krx_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham nene áŋok hátikin pakan paka pakati mah ma. ");
INSERT INTO krx_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Naasok Efulon hátikinii: “Síitanam, inci luumuu: pucooyi soŋ ya eti kaakit ka. Coon hisayu mañ me ancuk inci yina ihoku toko aalam.” ");
INSERT INTO krx_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efulon naañahan Abraham: ");
INSERT INTO krx_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Síitanam áhampaatiin, inci luumuu: etaam eyyuu, soŋ eteyyo sikoofali sikeme sipaakiil (400). Aŋuu waah tom ti pututa anii, caahok toko aali.” ");
INSERT INTO krx_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham niŋ Efulon nkasiiŋo ti hoonool. Abraham naafin sikoofali sikeme sipaakiil ti soŋ eyya nkásiyoole ya, naawufanoo so hátikin keesoke Het maamaa. ");
INSERT INTO krx_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Fiye, kaakit ka kiti Efulon keeyem ka Makapela pukol Mamule, niŋ kaayeen ka, punuun pa niŋ waah óo waah weeyem lupo ");
INSERT INTO krx_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","kíyenooniyoo fiye kiti Abraham hátikin keesoke Het púlooŋ maamaa keeyeniye ka ti putum pa piti saatee ya. ");
INSERT INTO krx_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Púful toko Abraham naahok aaloo Sara ti kaayeen ka keeyem ka ti kaakit ka kiti Makapela keeyem ka pukol Mamule (eeyem ya Hepolon) ti mah ma miti Kanaan. ");
INSERT INTO krx_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Fiyuu keesoke ka Het maamaa nkawufane Abraham kaakit ka niŋ kaayeen ka keeyem ka lupo kípiyenoonii kiteyoo, kati nahok toko pakanoo. ");
INSERT INTO krx_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Fiye, Abraham naamaaman meemak. Ateeteyo naasampanoo ti waah óo waah. ");
INSERT INTO krx_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Hikee hinoom, Abraham naasok amiikan a ateyoo eehaŋe ya kaamaaman aŋa nafaas ya hisaanumate ha hiteyoo: “Káluma, naŋ epeesi t’etaam hipoŋam. ");
INSERT INTO krx_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Sintoolo ti Ateeteyo Pútuun pa peeliile pa patiila niŋ t’etaam nii áaticoopii añiinam Isaak aal ti púmaacul pa pakati Kanaan le inci inkine le. ");
INSERT INTO krx_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Pale aafakaay ti mah ma mutoom, ti miin ma mutoom íncoopii añiinam Isaak aal.” ");
INSERT INTO krx_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Amiikan a naañahanoo: “Pikee pa aal a átalafiyam énapanii fo le. Fo ñaŋaa hicoopu añiini ti mah emma ánfulii ma temmo?” ");
INSERT INTO krx_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham naañahanoo: “Haani, timpi háañi aapucoop po añiinam. ");
INSERT INTO krx_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ateeteyo Pútuun pa peeliile pa patiila péefulaniyaam pa ti hank ha hiti paapaa atoom niŋ ti mah emma inci impukee ma temmo, mpúkup niŋ inci mpisintoolo eehe nii, efipuwufan mah emme keesokaam maamaa. Pikina efipupoñ maleekoo etempo hátikini aakati yíni écoopii aal añiinam. ");
INSERT INTO krx_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Niŋ aal a aŋuu apookuu énapanii, aayihaa ti esintoolo ya etii, pale fan óo fan incuke timpi coop po añiinam.” ");
INSERT INTO krx_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Fiye, amiikan a naanakan epeesoo t’etaam hipoŋ Abraham áhampaatiin a ateyoo naasintoolo nii áfaahin eeha naasokoo ha. ");
INSERT INTO krx_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Amiikan a naacoop siñonkomoo ŋaasuwan ti puñonkomoo pa piti áhampaatiin a ateyoo, naacoopool lompo waah óo waah weehaŋe wa panap uti áhampaatiin a ateyoo. Naahiiŋ ti saatee ya pa Nahol naakine pa ti mah ma miti Mesopotami. ");
INSERT INTO krx_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ta naakaawoole ta fo acol po náahin puñonkomoo pa pípikilipo pukol ésaapun ya eeyem ya tíkitaaŋ saatee ya. Iyyeno nkániim ta pakaal paka nkakaay ta piyook. ");
INSERT INTO krx_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Fiye naaluum: “Ateeteyo, Pútuun pa piti Abraham áhampaatiin a atoom, ponket hín pítin pa putoom púpusuum íyyisan panap pa pitii ti áhampaatiin a atoom kati paakool fíyooy niŋ aal a aŋa inci iyyem ya ti hiŋes. ");
INSERT INTO krx_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Eheeyam pukol ésaapun ya, púmaacul pa pakati saatee ya unka ti ékey piyook. ");
INSERT INTO krx_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ehe eeha inci illuumuu ha: fasok oonool teyii: 'Káluma, wánanii élumpa ya etii uwwunam pilaan.' Niŋ akina ammamale apiyeno aal a ati Isaak, amiikan a atii, álimaati asokam: 'Laan, fayook lompo man puñonkomoo pa pitii.' Fiyuu inci fámeyi nii áayisanaayisan panap pa pitii ti áhampaatiin a atoom.” ");
INSERT INTO krx_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Apáyum kaluum, ámaacul náacolii ápikantoonii élumpa ya eteyoo. Caacawoo Rebeka, añii Petuwel, Petuwel añii áyiin ati Miluka niŋ áyiinoo Nahol, Abraham atuwoo. ");
INSERT INTO krx_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Amáacul a ecuumaka aloot ámeyi áyiin. Naawano pati ésaapun ya naameeŋan élumpa ya eteyoo nene asilo. ");
INSERT INTO krx_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Amiikan a ati Abraham naatey aputoopanooloo naasokoo: “Káluma, wunam pilaan caahinkiŋ ti élumpa ya etii.” ");
INSERT INTO krx_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Naañahanoo: “Iyyoo áhampaatiin,” naahiliikan ápuwananii élumpa ya naawufanoo apilaan. ");
INSERT INTO krx_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ta naapayoo ta kawun apilaan, naasokoo: “Fayook lompo man puñonkomoo pa pitii pipilaan fo pisiit.” ");
INSERT INTO krx_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Naahiliikan ápunuŋ man ma ti púus pa nene atey piyook ti ésaapun ya puñonkomoo pa púlooŋ kati pilaan. ");
INSERT INTO krx_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ayíin a naayeniyoo kaasincan peesokut waah ápimeyi man Ateeteyo áhinaahin kaakaawool ka kiteyoo kúpusuum. ");
INSERT INTO krx_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ta puñonkomoo pa mpipaye ta pálaani, áyiin a naacoop ekop sanoo eti síinu, niŋ lompo kilaamant sanoo kúsupak keenonke. ");
INSERT INTO krx_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Púful toko naacakanoo: “Káluma sokam, ayme apukuu? Ti hank ha hiti faafi, fo taakaataak ékaap la inci iyyina hiŋotu hánant ha hiti fíyooy niŋ kéenapoolii ka niŋ inci?” ");
INSERT INTO krx_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rebeka naañahanoo: “Inci yem añii ya ati Petuwel, Miluka añiinoo áyiin aŋa naataake ya ti Nahol.” ");
INSERT INTO krx_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Nene asok: “Latoonii taakaataak hícump hikaaw niŋ pahoonal intaak lompo la inniyina kawanan.” ");
INSERT INTO krx_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Fiye, amiikan a náakilipo náamul Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Naasok: “Múlaa Ateeteyo, Pútuun pa piti Abraham áhampaatiin a atoom! Píyekuniit káyisan panap niŋ pucoonool etempo ti áhampaatiin a atoom. Iyyema inci, Ateeteyo acoopaamcoop pucoonool ciit ti miin ma miti áhampaatiin a atoom.” ");
INSERT INTO krx_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Amáacul a naatey t’enuuf naakaman heetaakiye ha púlooŋ. ");
INSERT INTO krx_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Naataak ahoop aŋa nkasok Laban. Ta Laban náasiye ta eeha áyiin a naasoke ha Rebeka, naacuk lompo ekop ya ti síinuyoo niŋ kilaamant ka, naahiliikan apicaapaakoolan amiikan a ati Abraham niŋ puñonkomoo pa piteyoo lati ésaapun ya. ");
INSERT INTO krx_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban naasok amiikan a: “Kéy latoonii awe aŋa Ateeteyo naasampane ya. Weyme uwune aakati yeno le tíkitaaŋ saatee ye? Memanoolaa-memanool ekumpaan ya immemanool lompo káayenuma kiti puñonkomoo pa pitii.” ");
INSERT INTO krx_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Fiye, amiikan a naacol lati Laban nkawanan wañ wa ti puñonkomoo pa nkawun po hikaaw niŋ pahoonal pipili, nkácoopii lompo man amiikan a niŋ pinapooloo kati kañow wootii. ");
INSERT INTO krx_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Nkawufanii kapili, pale amiikan a naasok: “Etili taamanta inci sokut eeha inci iññaŋe ha hisoku.” Laban naañahanoo: “Ooto kúp.” ");
INSERT INTO krx_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ayíin a naasok: “Inci amiikan ati Abraham. ");
INSERT INTO krx_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ateeteyo asampanaa-sampan meemak áhampaatiin a atoom mpíhinoo usaanum. Awunoowun písaacii, pifil niŋ síis, kótifoloo niŋ sanoo, pimiikan pákayiin niŋ pakaal, puñonkomoo niŋ púfali. ");
INSERT INTO krx_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Aaloo Sara, toko fiya niŋ himaamanoo naapukoo akampaani, oom añii áhampaatiin a atoom naawufane hisaanumate ha hiteyoo púlooŋ. ");
INSERT INTO krx_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ahámpaatiin a atoom naasokam: 'Sintoolo nii: áaticoopii añiinam Isaak aal ti púmaacul pa pakati Kanaan le inci inkine le. ");
INSERT INTO krx_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Pale aafakaay ti miin ma mutoom, ti hank ha hiti paapaa atoom, immamal toko aal añiinam.' ");
INSERT INTO krx_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Fiye iññahanoo: 'Niŋ aal a apookaam me kanapan?' ");
INSERT INTO krx_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ahámpaatiin a atoom naañahanam: 'Ateeteyo aŋa inci íntuule ya afaapoñ maleekoo ya eteyoo niŋ awe, náahin kaakaawool ka kitii kúpusuum. Aáfacoopii aal ati miin ma mutoom, ti hank ha hiti paapaa atoom, apiyeno añiinam aaloo. ");
INSERT INTO krx_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Pale niŋ aakaayaa ti miin ma mutoom aayihaa ti esintoolo ya etii. Háati nkapooki kawufan aal a inci etiñani.' ");
INSERT INTO krx_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Fíyooy emma inci íncolii ma pukol ésaapun ya insok: 'Ateeteyo, Pútuun pa piti áhampaatiin a atoom Abraham, luumuu hín kaakaawool ka kutoom kúpusuum. ");
INSERT INTO krx_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Fiye eheeyam ti ésaapun ya, inci fasok oonool ti púmaacul pa keekaakaay ka ékey piyook man \"Káluma, wunam pilaan caahinkiŋ ti élumpa ya etii.\" ");
INSERT INTO krx_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Niŋ añahanaam: \"Laan, fayook lompo puñonkomoo pa pitii pipilaan,\" ámaacul a aŋuu afaayeno aŋa Ateeteyo naamamale ya kati ayeno aal a ati añii ya ati áhampaatiin a atoom.' ");
INSERT INTO krx_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Inci páyum kaluum, Rebeka náacolii ápikantoonii élumpa ya eteyoo. Naawano ti ésaapun ya piyook. Insokoo: 'Káluma wunam pilaan.' ");
INSERT INTO krx_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Naahiliikan ápuwananii élumpa ya eteyoo naasokam: 'Laan, fayook lompo man puñonkomoo pa pitii.' Fiye illaan naawun lompo puñonkomoo pa pipilaan. ");
INSERT INTO krx_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Incakanoo: 'Ayme apukuu?' Naañahanam: 'Inci yem añii ya ati Petuwel, Nahol añiinoo áyiin aŋa Miluka naataake ya teyoo.' Fiye, iŋŋaamoo ekop ya ti síinu iŋŋaamoo lompo kilaamant ka ti sipees. ");
INSERT INTO krx_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","“Nkílipo ímmul Ateeteyo, insok apalaka Ateeteyo Pútuun pa piti áhampaatiin a atoom Abraham. Mpítintiŋanam pucoonool ciit ti miin ma miti áhampaatiin a atoom atuwoo, kati coop le aal apiyeno aal a ati áhampaatiin a atoom añiinoo. ");
INSERT INTO krx_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Fiye niñahanam: fo nílafilafi káyisan panap niŋ pucoonool ti áhampaatiin a atoom? Niŋ ekina tom nisokam inci pímeyi eeha inci inkaakaay íhinu.” ");
INSERT INTO krx_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban niŋ Petuwel, paapaa ati Rebeka, nkañahanoo: “Eehe ti Ateeteyo níhifulii, utaakut waah ewwa nuukaakaay hisoku. ");
INSERT INTO krx_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ehe Rebeka hátikini, coopoo inkaay. Ayeno aal a ati áhampaatiin a atii añiinoo samat nii fa Ateeteyo naasoke fa!” ");
INSERT INTO krx_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ta amiikan a náasiye ta kilim enkuu, náakilipo puhooŋuyoo t’etaam náamul Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Púful toko náafulanii púkotifoloo, pisanoo niŋ wañ naawufan po Rebeka. Naawufan lompo hícump waah weewalla wéeciita hinoom ahoopoo niŋ íññaa ateyoo. ");
INSERT INTO krx_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Fiye, amiikan a ati Abraham niŋ kéenapoolii ka neyoo nkali nkalaan; kapipa nkakaay hiŋotu. Eti kacom eteyyo mpucom, ta nkalitiye ta, amiikan a ati Abraham naasok: “Nikatampo puñoho pati áhampaatiin a atoom.” ");
INSERT INTO krx_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Pale Rebeka ahoopoo niŋ íññaa ateyoo nkañahanoo: “Amáacul a ayeno niŋ unii fo máamun kunoom ŋaasuwan apite akaay.” ");
INSERT INTO krx_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Amiikan a nene asokii: “Timpi nicokam páawoo Ateeteyo Pútuun pa píhinaahin kaakaawool ka kutoom kúpusuum. Nikatampo puñoho pati áhampaatiin a atoom.” ");
INSERT INTO krx_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Nkasokoo: “Túul úpuyonkalii ámaacul a upucakanoo eeha náamiiloole.” ");
INSERT INTO krx_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Nkáyonkalii Rebeka nkacakanoo: “Aálafilafi pikaayu niŋ áyiin a aŋe?” Naañahanii: “Ee, inci fakaay.” ");
INSERT INTO krx_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Fiye nkakatan ahoopii Rebeka, niŋ amiikan a ateyoo éehinoo ya pampaani, niŋ amiikan a ati Abraham niŋ kéenapoolii ka neyoo kapikaay. ");
INSERT INTO krx_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Nkasampan Rebeka nkasokoo: “Ahoop unii, álimaati aayeno íññaa ati pakan keemeeŋe, keesokuu maamaa, álimaati kaheek pisaatee pa piti pikamoolii.” ");
INSERT INTO krx_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Fiye, Rebeka niŋ pimiikan pa pakaal paka pakateyoo nkalito nkalapo ti puñonkomoo pa kapinapan amiikan a. Fiyuu amiikan a naacoope Rebeka, naañak. ");
INSERT INTO krx_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ti oom caanak, Isaak eekine ya ti káahaaŋ ka tes kiti Nekep naayeno éñohoonii ápufulii pati ésaapun ya eyya nkasok ya Lahay-Loyi. ");
INSERT INTO krx_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Kikee kániim, Isaak naayeno kaakaawool ti kaakit náahaafin naaŋantan puñonkomoo ti ékey. ");
INSERT INTO krx_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka lompo náahaafin naaŋantan Isaak, náawanoonii ti ñonkomoo ya eteyoo. ");
INSERT INTO krx_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Naacakan amiikan a ati Abraham: “Ayíin a eeyem ya ti kaakit ka náayemi ti ékey kapaakoolan unaa, ayem ayme?” Amiikan a naañahanoo: “Ahámpaatiin a atoom.” Fiye, Rebeka naacoop kafonkoloŋ ka kiteyoo ápuwufaloolo. ");
INSERT INTO krx_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Amiikan a naakaman Isaak eeha náahine ha púlooŋ. ");
INSERT INTO krx_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaak naacoop Rebeka lati ékuut ya eti íññaa ateyoo Sara. Náayenoonii aaloo náalafiyoo. Fiyuu naapuuñanoolee pamuusal eket ya eti íññaa ateyoo. ");
INSERT INTO krx_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham naasa akee aal caacawoo Ketula. ");
INSERT INTO krx_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Naapukoo epuuk ya payenke: Similan, Yokosan, Metan, Mitiyan, Yisupak niŋ Suwah. ");
INSERT INTO krx_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokosan ayem paapaa ati Sapa niŋ Tetan. Tetan naapuk pakati Asul, Letus niŋ Lewum. ");
INSERT INTO krx_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ehe miin ma miti Mitiyan: Efa, Efel, Hanok, Apita niŋ Eletaa. Payenkuu púlooŋ kayem miin ma miti Ketula. ");
INSERT INTO krx_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham naawufan hisaanumate ha hiteyoo púlooŋ añiinoo Isaak. ");
INSERT INTO krx_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Naawufan ukee waah wa epuuk pakaaloo pakakee paka. Pale akina kaloŋayoo náakatinoolii niŋ añiinoo Isaak; epuuk ya payenkuu, naasokii kahiiŋ pa caanak ca íncifulii pa. ");
INSERT INTO krx_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abraham naataak eloŋ eehaane néesuum, naasuuŋut pikelan naaket loho ataakaa sitiil keme niŋ áwii éhaaciil niŋ kaat (175) naananf pakataama. ");
INSERT INTO krx_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Epuukoo Isaak niŋ Ismayel nkahokoo ti kaayeen ka kenfakat ka kiti Makapela keeyem ka ti kaakit ka kiti Efulon, añii ya ati Sohal eesoke Het maamaa, pukol Mamule. ");
INSERT INTO krx_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Abraham anoome kaakit ka ti keesoke Het maamaa, toko nkahokoo niŋ aaloo Sara. ");
INSERT INTO krx_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Pamuusal eket ya eti Abraham, Pútuun pa mpisampan añiinoo Isaak. Naakin pukol ésaapun ya eti Lahay-Loyi. ");
INSERT INTO krx_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ehe kiti miin ma miti Ismayel, añii ya ati Abraham; íññaa ateyoo ayem Hakal ati Esipt a, amiikan a ati Sara. ");
INSERT INTO krx_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ehe ucawii, nuukiicee samat nii fa nkapukee fa: Nepayot ayem añii ya áyaañ a, Ketal, Atepeel, Mipisam, ");
INSERT INTO krx_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misema, Tuma, Masa, ");
INSERT INTO krx_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Yetul, Nafis niŋ Ketema. ");
INSERT INTO krx_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Payenkuu kayem epuuk ya ŋaasuwan niŋ pákasupak paka pakati Ismayel. An óo an teyii naayeno áhampaatiin ati miin nkaluwool pisaatee pa piteyii neyii niŋ la nkasiiŋane la púkuut pa piteyii. ");
INSERT INTO krx_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismayel naasuuŋut pikelan naaket loho ataakaa sitiil keme niŋ áwii niŋ kaat niŋ súsupak (137) naananf pakataama. ");
INSERT INTO krx_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Miin ma miti Ismayel immiyeno ti mah ma meeyem ma ti pututa Hawila niŋ Sul. Sul ekolaakol Esipt naahiiŋaa Asul. Nkakin kápilaaŋ pakanii kaatuko kásuumoolut. ");
INSERT INTO krx_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ehe kiti miin ma miti Isaak añii ya ati Abraham. Abraham naapuk Isaak. ");
INSERT INTO krx_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ta Isaak naataake ta sitiil áwii ésupak (40) naasa Rebeka añii ya ati Petuwel, Laban ahoopoo. Petuwel niŋ Laban pakati Alam nkakin Mesopotami. ");
INSERT INTO krx_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Pale Rebeka caakonta. Fiye, Isaak naaluum Ateeteyo kiti aaloo. Ateeteyo náasiitan kaluum ka kiteyoo, Rebeka naasa munow, ");
INSERT INTO krx_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","naayeno hítuulu máasupak. Payenkuu nkayeno písapalool ti munowoo. Rebeka naasok: “Weyme utaakiyaam?” Fiye naakaay kacakan Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ateeteyo naasokoo: “Sísii súsupak siyem ti munowi, uyoŋ úsupak efuupukee núukatinool; ekee síi ya efeehaŋ sempe ekee ya, añii ya áhampaatiin a afaayeno amiikan ti kahiineen ka.” ");
INSERT INTO krx_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ta íyyiŋooliyoo ta, pánipani náapukii máasupak. ");
INSERT INTO krx_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ayáañ a naapukee naahanat samat nii kapaŋ élukuleen, eniinoo néecunk. Nkaluwoo caacaw ca Esawu (ekina eyem “kahanat”). ");
INSERT INTO krx_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Atuwoo ti hipukuyee, naacok Esawu ti econt, nkaluwoo caacaw ca Jakob (ekina eyem “naacok econt”). Ta nkapukee ta, Isaak ti sitiil áwii éhaaciil (60). ");
INSERT INTO krx_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Pikampaani pa pákasupak paka nkáyankii. Esawu náayenoonii aleemaya enfakat nálafi piyeno ti ukit wa. Pale Jakob áyiin eefatane nálafi piyeno t’enuuf. ");
INSERT INTO krx_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaak naahaŋ pálafi Esawu kaatuko akiipaakiip efoofa eti elampa, pale Rebeka naahaŋ pálafi Jakob. ");
INSERT INTO krx_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Hikee hinoom Jakob naayeno hiik kisaak. Esawu náafulii t’elampa niŋ ñíyoka ñenfakat fo náalaame. ");
INSERT INTO krx_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Naasok Jakob: “Ponket, katampo pili ti kisaak ka kéecunke enke, peep efipumukam.” Ekina ewune nkalu Esawu caacaw ca Etom (ekina eyem pácunk). ");
INSERT INTO krx_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jakob naañahanoo: “Noomanam fala híhampaatiinate ha hitii.” ");
INSERT INTO krx_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esawu naasokoo: “Inci oopa ti eket kamma peep. Híhampaatiinate ha hitoom, eyyeyme nafaa nihitaakaam?” ");
INSERT INTO krx_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jakob naasokoo: “Sintoolo fala.” Esawu naasintoolo nii anoomanaa Jakob híhampaatiinate ha hiteyoo. ");
INSERT INTO krx_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Fiye, Jakob naawufan Esawu hímpuul niŋ kisaak. Esawu naali naalaan. Apipa naakaay, putumoo pineetaat ti híhampaatiinate ha hiteyoo. ");
INSERT INTO krx_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Epánkul neeyeno ti mah ma eekufut nii eetaakiye ya ti caanak ca citi Abraham. Fiye, Isaak naatoos Kelal pati Apimelek amansa ya ati pakati Filistin. ");
INSERT INTO krx_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ateeteyo náafulii teyoo naasokoo: “Timpi wano Esipt pale caakin ti mah emma inci inkaakaayi ma káyisan. ");
INSERT INTO krx_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Yeno ti mah emmuu samat nii akaawoola, inci fayeno niŋ awe insampani. Inci fawufani pitaam empe púlooŋ, awe niŋ keesokuu maamaa. Fáhin eeha inci insintooliye ha faafi Abraham. ");
INSERT INTO krx_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Inhín keesokuu maamaa kapimeeŋ samat nii picaaŋaŋ pa uwwufanii pitaam empe púlooŋ, pínapii teyii písii pa púlooŋ piti etaam ya efipisampanee. ");
INSERT INTO krx_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Kaatuko Abraham ásiitanaam-síitan náahin eeha inci insokoo ha naacok kilim ka kutoom niŋ pítin pa putoom niŋ kilim ka keesiiŋanee ka kutoom.” ");
INSERT INTO krx_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Fiye, Isaak naakin Kelal. ");
INSERT INTO krx_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Pakan paka pakati mah ma nkacakanooloo ti pututayoo niŋ Rebeka. Naañahanii: “Aŋe ahoopam.” Aháañiit hisoku nii Rebeka aaloo kaatuko afeyaafe timpi kamukoo kamma aaloo naayem ecuumaka. ");
INSERT INTO krx_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isaak naakampan po. Hikee hinoom, Apimelek amansa ya ati pakati Filistin náacuuhan ti epalloolu ya eteyoo naacuk Isaak ti pahaaño niŋ aaloo Rebeka. ");
INSERT INTO krx_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Apimelek náayonkaliyoo naasokoo: “Pánipani aŋe aali! Weyme uwune ansok nii aŋe ahoopi?” Isaak naañahanoo: “Inci hínaahin eehuu ti kafeyatan timpi kamukam kamma akina.” ");
INSERT INTO krx_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Apimelek nene asokoo: “Weyme ánhine unii fiye? An antaahinto hínum niŋ aali, intiyan unii himuuyen.” ");
INSERT INTO krx_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Naayonkal pakan paka púlooŋ naasokii: “An óo an aŋa éehaañiye híliku áyiin a aŋe niŋ aaloo afaamukee.” ");
INSERT INTO krx_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaak naaya ti oom mah, ti oom etiil naamaañ kaamaañ kenfakat kamma kaalat óo kaalat enka naasuke nkipenaniye fo keme, kaatuko Ateeteyo asampanoo. ");
INSERT INTO krx_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Hitaaku ha hiti Isaak híyekuniit ti epenano fo náayenoonii usaanum. ");
INSERT INTO krx_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Naataak hícump pukoolee piti písaacii, pifil niŋ síis niŋ kayoŋ pimiikan fo pakati Filistin nkataake paheeka teyoo. ");
INSERT INTO krx_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ta paapaa ateyoo Abraham naayeniye ta kaloŋa, pimiikan pa pakateyoo kawakaawak písaapun. Paheeka pa piti pakati Filistin mpuwun nkahokan oom písaapun. ");
INSERT INTO krx_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Fiye, Apimelek naasok Isaak: “Aáyenooniyoo eehaŋe unii sempe meemak, fúl le inkaay.” ");
INSERT INTO krx_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isaak naatoos ti hiyanu ha heesooŋe ha hiti Kelal naakin toko. ");
INSERT INTO krx_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Náawaakin písaapun pa peewakee pa ti caanak ca citi paapaa ateyoo Abraham, empa pakati Filistin nkahokane pa paketal Abraham. Naañahan po ucaw ewwa faafoo mpaalu po wa. ");
INSERT INTO krx_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Hikee hinoom, pimiikan pa pakati Isaak nkawak ésaapun lati hiyanu ha heesooŋe ha nkacol ti káapun kenfakat. ");
INSERT INTO krx_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Pale pufaasa púlukuleen pa pakati Kelal nkáñakalool yo niŋ pufaasa púlukuleen pa pakati Isaak, nkasokii: “Man emme mutoonii.” Ekina ewune Isaak naalu ésaapun eyyuu caacaw ca Esek (ekina eyem “píñakalool”) kaatuko káñakaloolaa-ñákalool yo neyoo. ");
INSERT INTO krx_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Fiye, pimiikan pa pakati Isaak nene kawak ésaapun ésupiyenu nene etaak píñakalool. Isaak naalu yo caacaw ca Sitina (ekina eyem “pítaakool”). ");
INSERT INTO krx_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Apúful toko naacaawak ésaapun éhaaciyenu eetaakut píñakalool, naalu yo caacaw ca Lehopot (ekina eyem “káahaaŋ”) naasok: “Fiye Ateeteyo áwufaniyoo unaa káahaaŋ. Uyíniyaayini piyeno kusaanum ti mah emme.” ");
INSERT INTO krx_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Isaak náaful toko naasilo Beerseba. ");
INSERT INTO krx_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Oom hánant Ateeteyo náafulii teyoo naasokoo: “Inci yem Pútuun pa piti faafi Abraham; timpi fe kaatuko inci oopa niŋ awe, fasampani ínhin keesokuu maamaa kapimeeŋ kamma Abraham amiikan a atoom.” ");
INSERT INTO krx_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaak naalut kaaciin naaluum ti caacaw Ateeteyo. Naasiiŋan toko ékuut ya eteyoo, pimiikan pa pakateyoo nkawak toko ekee ésaapun. ");
INSERT INTO krx_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Po hátikin, Apimelek náakey hiyoop Isaak ápufulii Kelal náanapoolii niŋ Ahusat aŋa nawunoo ya kunuu niŋ Fikol áhampaatiin a ati pusoocaali pa pakateyoo. ");
INSERT INTO krx_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaak naacakanii: “Weyme uwune ínnikeyyam hiyoop apan ninataam-nat inniyaanam lataaluu?” ");
INSERT INTO krx_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Nkañahanoo: “Ucukaacuk picaaŋ cataŋ nii Ateeteyo oopa niŋ awe, núumiilool eehe nii, unaa uñaŋaa hiliilu písiyool nuusintooliyaa kati utaakaa kásuumaay. ");
INSERT INTO krx_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Sintoolo nii áatihin unii heenaput samat nii fa núuhinuti fa heenaput pale heenape lamma núuhinuu, nuukatani aapikaay ti kásuumaay. Fiye, awe áyiin eesampanee ati Ateeteyo.” ");
INSERT INTO krx_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isaak naamemanoolii paliyal, nkali nkalaan. ");
INSERT INTO krx_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Eti kacom eteyyo mpucom mic an óo an ti poko t’ésupakii naasintoolo, Isaak náatiŋanii nkákatinool ti kásuumaay. ");
INSERT INTO krx_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ti oom hinoom, pimiikan pa pakati Isaak nkákey káatuunanoo hilim héesuume hiti ésaapun eyya nkayeniye kaawak, nkasokoo: “Unii ucolaacol ti man.” ");
INSERT INTO krx_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Fiye, Isaak naalu ésaapun eyyuu caacaw ca Sepa (ekina eyem “esintoolo”) ekina ewune fo fíyooy, saatee ya nesokee Beerseba (ekina eyem “ésaapun eti esintoolo”). ");
INSERT INTO krx_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ta Esawu naataake ta sitiil áwii ésupak (40) naasa pakaal pákasupak keesoke Het maamaa: Judit ámaacul ati Peeli niŋ Pasumat ámaacul ati Elon. ");
INSERT INTO krx_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Nkáciitiyan meemak eloŋ ya eti Isaak niŋ Rebeka. ");
INSERT INTO krx_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaak náamaamanii ñíkinoo iññicok ayinaat hicuku. Naayonkal añiinoo ácook a Esawu, naasokoo: “Añiinam!” Esawu naañahanoo: “Eheeyam.” ");
INSERT INTO krx_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaak naasokoo: “Aacukaamcuk, inci oopa maamane míit teyme inci inkaakaay eket. ");
INSERT INTO krx_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Fiye, coop hiŋaaceen ha hitii inkaayam leema áapumukii efoofa. ");
INSERT INTO krx_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Iyyik yo payikal pa péesuume pa empa inci íllafiye pa, íncoopii yo inci pili kati sampani le niŋ inci faket.” ");
INSERT INTO krx_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ta Isaak naayeniye ta káakup niŋ añiinoo Esawu, Rebeka naayeno káasiitan. Fiye, Esawu naakaay leemayuu kati ámukii paapaa ateyoo efoofa. ");
INSERT INTO krx_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka naasok añiinoo Jakob: “Inci síyaasi paapaa atii ti káakup niŋ púnuwi Esawu, naasokoo ");
INSERT INTO krx_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","ámukiyoo efoofa naayikoo yo púsuum; niŋ apayaa hili naasampanoo hátikin Ateeteyo le niŋ afaaket. ");
INSERT INTO krx_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Fiye añiinam síitanam, ínhin eeha inci inkaakaayi ha hisoku. ");
INSERT INTO krx_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Kaay pati koolee ya íncoopiyam mifil músupak meenape, inci fayik mo paapaa atii payikal péesuume samat nii fa náalafiye fa. ");
INSERT INTO krx_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Awe incoopoo payikal pa apili kati asampani le niŋ afaaket.” ");
INSERT INTO krx_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jakob naañahan íññaa ateyoo Rebeka: “Pale púnuwam Esawu ahanataahanat inci hanatut. ");
INSERT INTO krx_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Niŋ paapaa atoom álikaam áfaameyi nii inci láfiyoolafi kincaakool, afaañanam atasampanam.” ");
INSERT INTO krx_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Iññáa ateyoo naañahanoo: “Pañanal empuu píkey ti inci, añiinam, síitanam lamma íncaacoopiyam mifil ma.” ");
INSERT INTO krx_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Jakob náakaacoopii mifil ma naawufan mo íññaa ateyoo apiyik mo payikal péesuume samat nii fa paapaa ateyoo náalafiye fa. ");
INSERT INTO krx_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Púful toko, Rebeka naacoop wañ wa uti Esawu añiinoo ácook a weehaŋe wa pawalle weeyeniye wa ti ekumpaan ya, náasool wo Jakob kahiineen ka. ");
INSERT INTO krx_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Naalompo áwufalool sipeesoo niŋ ekunoo la hanatut la niŋ upaŋ mifil ma. ");
INSERT INTO krx_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Fiye, naawufan añiinoo Jakob paliyal pa péesuume pa niŋ hímpuul ha eeha naasowe ha. ");
INSERT INTO krx_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jakob naakaay pati paapaa ateyoo naasok: “Paapaa.” Naañahanoo: “Eeya añiinam, awe yem ayme?” ");
INSERT INTO krx_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jakob naañahan paapaa ateyoo: “Inci yem Esawu añiini áyaañ a. Hínaahin samat nii fa ansokaam fa. Káluma, yeno illi efoofa ya etoom ancuk aasampanaam.” ");
INSERT INTO krx_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaak naacakan añiinoo: “Añiinam, puume áncasii fiye t’écokii élukuleen?” Naañahanoo: “Ateeteyo Pútuun pa pitii pípankine pítinam.” ");
INSERT INTO krx_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Fiye, Isaak naasok Jakob: “Añiinam, kóliyam ancuk inci kati líki pímeyi pánipani man awe yem añiinam Esawu man akina tom.” ");
INSERT INTO krx_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jakob naaloh paapaa ateyoo Isaak, Isaak náalikoo naasok: “Hilim ha hiti Jakob pale sipees sa siti Esawu.” ");
INSERT INTO krx_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Akiiwutoo kaatuko sipeesoo seehanate samat nii siti púnuwoo Esawu. Pale le niŋ afaasampanoo, ");
INSERT INTO krx_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","nene acakanoo: “Pánipani, awe yem añiinam Esawu?” Naañahanoo: “Ee, inci yem akina.” ");
INSERT INTO krx_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Fiye, naasok: “Añiinam, cóopiyam efoofa ya pili ancuk inci sampanuu.” Jakob náacoopiyoo yo, naali; náacoopiyoo lompo elaan, naalaan. ");
INSERT INTO krx_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Paapaa ateyoo Isaak naasokoo: “Añiinam, kóliyam insumpoolam.” ");
INSERT INTO krx_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Fiye, naakaay teyoo, naasumpooloo. Ta Isaak náasiye ta haaw wañ wa uteyoo, naasampanoo naasok: “Haaw añiinam hicukaacuk nii haaw hiti kaakit enka Ateeteyo naasampane. ");
INSERT INTO krx_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Alímaati Pútuun pa puwufani haamon ha hiti patiila niŋ hitaaku ha hiti etaam ya: hícump uli niŋ pucoma elaan. ");
INSERT INTO krx_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Alímaati hícump písii píyenoonii pimiikani, pakan paka nkáñeemi. Alímaati aayeno ati hikaw ha ti pakani, nkáñeemi. Alímaati keeñanuu ka kañanee, keesampanuu ka kasampanee.” ");
INSERT INTO krx_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ta Isaak naapayoo ta kaasampan, Jakob náaful. Emma náafule ma, púnuwoo Esawu náafulii leema. ");
INSERT INTO krx_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Akina lompo naamemanool payikal péesuume náacoopii po paapaa ateyoo. Fiye naasokoo: “Paapaa, yeno illi efoofa ya eyya inci iyyike ya, ancuk aasampanaam.” ");
INSERT INTO krx_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Paapaa ateyoo Isaak naacakanoo: “Awe yem ayme?” Naañahanoo: “Inci yem añiini áyaañ a, Esawu.” ");
INSERT INTO krx_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaak naakikilan meemak naasok: “Ooto ayme ácoopii efoofa naawufanam? Féefiye inci impaye hili insampanoo le niŋ áafacolii. Antúŋ pánipani afaasampanee!” ");
INSERT INTO krx_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ta Esawu náasiye ta hilim paapaa ateyoo, naaceek niŋ kaawiiluyoo naakooŋ kamma paseeña penfakat, naasok paapaa ateyoo: “Sampanam, inci lompo paapaa!” ");
INSERT INTO krx_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Pale Isaak naasokoo: “Atuwi ákeyii naacaakoolam naacoop kaasampan ka kitii.” ");
INSERT INTO krx_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esawu naasok: “Fo caacawoo cineetaat Jakob? Acaakoolaam-caakool niŋ ñésupak: Acoopaacoop híhampaatiinate ha hitoom, fiye acoopaa lompo kaasampan ka kutoom!” Naacakan paapaa ateyoo, “Aatowanutam kikee kaasampan?” ");
INSERT INTO krx_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaak naañahan Esawu, “Inci hínoohin apiyeno ati hikaw ha atii, ínhin pakanoo púlooŋ kapiyeno pimiikan pa pakateyoo, uwwufanoo uli wa niŋ elaan ya. Añiinam, fiye weyme inci iyyinuu íhinu?” ");
INSERT INTO krx_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esawu naasok paapaa ateyoo, “Paapaa, fo kaasampan koonool lamma antaake? Paapaa, luumuu sampanam lompo!” Fiye, Esawu náacoolan meemak. ");
INSERT INTO krx_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Paapaa ateyoo Isaak naañahanoo: “Ekínuma ya etii éfeelaaŋ hitaaku ha hiti etaam ya, éfeelaaŋ haamon ha hiti patiila. ");
INSERT INTO krx_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Eloŋ ya etii efeeyeno eti hikam niŋ káalipu, aafayeno amiikan a ati atuwi. Pale niŋ áayokiyoo, áafaful ti kayine ka kiteyoo.” ");
INSERT INTO krx_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esawu naanat Jakob kamma kaasampan ka enka paapaa ateyoo naasampanoo ka. Naasokoolo, “Eket ya eti paapaa atoom élaaŋut; tempo inci famuk atuwam Jakob.” ");
INSERT INTO krx_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Pale Rebeka naakamanee eeha añiinoo áhampaatiin a Esawu naayem ha ti káamiilool, náayonkalii añiinoo kahiineen ka Jakob naasokoo: “Púnuwi Esawu oopa ti kaapuuñanool faŋoo niŋ pámiiloolal piti himukuyi. ");
INSERT INTO krx_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Fiye añiinam, hín eeha inci inkaakaayi ha hisoku: tey mpacas pati ahoopam Laban eeyem ya Halan. ");
INSERT INTO krx_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Yeno pateyoo fo hátikin, fo ta púnuwi púsusoo efipumon. ");
INSERT INTO krx_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Niŋ káñiken ka kiteyoo kumuusaa naafiil eeha ánhinoo ha, inci fápoñiyi ekooŋan áapuñohoonii. Weyme uwune inci kati púul taaluu t’ésupak aluu hinoom hoonool?” ");
INSERT INTO krx_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Fiye, Rebeka naasok Isaak, “Eloŋ ya ehookaamhook fiye kamma pakaal paka payenke keesoke ka Het maamaa. Niŋ Jakob lompo asayaa akee teyii le, fisakaam piket.” ");
INSERT INTO krx_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaak naayonkal Jakob naasampanoo naawufanoo hilim eehe: “Timpi sa aal ti púmaacul pa pakati Kanaan. ");
INSERT INTO krx_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Kaay Mesopotami pati Petuwel, íññaa atii faafoo, sa po, ti púmaacul pa pakati áasiyi Laban. ");
INSERT INTO krx_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Alímaati Pútuun pa piti sempe sa púlooŋ pisampani, mpuwufani epuuk keemeeŋe aakati yénoonii maamaa ati hícump písii. ");
INSERT INTO krx_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Alímaati puwuni kaasampan enka mpisampane ka Abraham, awe niŋ miin ma mitii, ancuk aacoopaa mah emma ankine ma temmo nii akaawoola, mah emma Pútuun pa mpuwufane ma Abraham.” ");
INSERT INTO krx_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Fiyuu Isaak naasoke Jakob akaay Mesopotami pati Laban, añii ya ati Petuwel eekine ya ti mah ma miti Alam. Laban ahoopoo Rebeka ayem íññaa ati Jakob niŋ Esawu. ");
INSERT INTO krx_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esawu náasi nii Isaak asampanaa-sampan Jakob naapoñoo Mesopotami esa aal, naalompo ási nii Isaak, ti kaasampan ka Jakob, naakitoo esa aal ti púmaacul pa pakati Kanaan. ");
INSERT INTO krx_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Naacuk nii Jakob átuulaatuul faafoo niŋ íññaa ateyoo naakaay Mesopotami. ");
INSERT INTO krx_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esawu náapannum nii faafoo asayanut púmaacul pa pakati Kanaan. ");
INSERT INTO krx_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Fiye, naakaay pati Ismayel, Abraham añiinoo, naasa añiinoo ámaacul aŋa nkasok Mahalat, Nepayot ahoopoo, apinanf ti pakaaloo. ");
INSERT INTO krx_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ti oom caanak, Jakob náaful Beerseba apuwant Halan. ");
INSERT INTO krx_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ta naacole ta lakeenaay naasiiŋo kati aŋot kaatuko cicokaacok. Naacoop énankiin ti pínankiin pa peeyem pa toko naahinto naanaŋ teyyo hikawoo naaŋot. ");
INSERT INTO krx_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ti hiŋotu eehuu, náayawut naacuk ésiluma eesiiŋiye ti etaam ya, patiila eteyyo neecol patiila útiŋu wa. Pumaleekoo piti Pútuun pa mpiyeno pisilo niŋ éwanoonii teyyo. ");
INSERT INTO krx_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Patiila ésiluma eyyuu Ateeteyo naasiiŋo naasok: “Inci yem Ateeteyo, Pútuun pa piti maamaa atii Abraham niŋ faafi Isaak. Inci fawufani niŋ miin ma mitii etaam eyya anhintiye ya teyyo. ");
INSERT INTO krx_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Keesokuu maamaa efikameeŋ samat nii esiya ya, mah ma miteyii efimipenanee pan óo pan: pa caanak ca íncifulii pa puwant pa incinow pa, epees yáali puwant epees yaamay. Písii pa púlooŋ piti etaam ya efipisampanee pínapii ti awe niŋ keesokuu maamaa. ");
INSERT INTO krx_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Inci oopa niŋ awe, fafaasi pan óo pan ankaaye, fáñahaniyi ti etaam eyye. Etikatani taamanta hínut eeha inci íyyinananuu ha.” ");
INSERT INTO krx_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ta Jakob náayiyoonii ta ti hiŋotu ha hiteyoo naasokoolo: “Pánipani, Ateeteyo oopa le, inci pánnumut.” ");
INSERT INTO krx_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Naafe naasok: “Le, féyanani-féyanani! Ekumpaan ya eti Pútuun pa niŋ putum pa piti patiila.” ");
INSERT INTO krx_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Eti kacom eteyyo mpucom mic, Jakob naacoop énankiin ya eyya naanaŋe ya teyyo hikawoo, naasiiŋan yo epiyeno lánkamaasi, naaniis patiila eteyyo miyoomeen. ");
INSERT INTO krx_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Naalu toko caacaw ca Petel (ekina eyem “ekumpaan ya eti Pútuun pa”) caacaw eteyyo hínum Lus. ");
INSERT INTO krx_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jakob naasintoolo ti Pútuun pa naasok: “Niŋ Pútuun pa efipiyeno niŋ inci, mpifaasam ti kaakaawool ka kutoom mpuwufanam paliyal niŋ pásooliyal, ");
INSERT INTO krx_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","niŋ inci ñohiyaa pati ekumpaan ya eti faafam ti kásuumaay, ooto Ateeteyo afaayeno Pútuun pa putoom. ");
INSERT INTO krx_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Enánkiin ya eyya inci insiiŋane ya lánkamaasi, efeeyeno ekumpaan ya eti Pútuun pa. Aŋa awwufanaam ya púlooŋ, inci fawufani himpaac hoonool ti kimpaac ŋaasuwan.” ");
INSERT INTO krx_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jakob apiyeno kaahankan pítin pa piteyoo, naahiiŋ pa caanak ca íncifulii pa. ");
INSERT INTO krx_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Hikee hinoom, naacuk ésaapun t’elampa, niŋ sikoolee síhaaciil siti písaacii seehintiye pukol eteyyo kaatuko ti ésaapun ya mpiyookee man pipilaan. Intaak énankiin enfakat eyya nepank putum ésaapun ya. ");
INSERT INTO krx_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Tan óo tan písaacii pa mpuconcooliye toko, pufaasa pa nkápalinkan énankiin ya, nkawun pukoolee pa pipilaan. Niŋ pipayaa pálaani, nene kápalinkan énankiin ya epipank putum ésaapun ya. ");
INSERT INTO krx_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Fiye, Jakob naasok pufaasa pa: “Pakanam, aluu pakati peyme?” Nkañahanoo: “Unii pakati Halan.” ");
INSERT INTO krx_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Naasokii: “Nímeyimeyi Laban, Nahol eesokoo maamaa?” Nkañahanoo: “Ee úmeyiyoomeyi.” ");
INSERT INTO krx_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Nene asokii: “Oopa kásuumaayoo?” Nkañahanoo: “Ee oopa kásuumaayoo. Aha ámaacul a ateyoo Rasel ti ékey niŋ koolee ya.” ");
INSERT INTO krx_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Jakob naasokii: “Nisincan pisiya pa puloŋaaloŋ, túuniit fala kaaconcoolan písaacii pa. Niwun po pipilaan inniñahan po ti káahoonanuma.” ");
INSERT INTO krx_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Nkañahanoo: “Uyinaat, taamanta pukoolee pa púlooŋ puconcooliit. Niŋ puconcooliyaa, tempo conko énankiin ya eeyem ya ti putum ésaapun ya éfeepalinkanee, nuuwun po pipilaan.” ");
INSERT INTO krx_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Akina ti káakup neyii, Rasel náacolii niŋ písaacii pa piti paapaa ateyoo kaatuko akina afaasa. ");
INSERT INTO krx_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ta Jakob naacuke ta Rasel añii ya ámaacul a ati áasiyoo Laban, niŋ písaacii pa piti áasiyoo Laban, naakaay náapalinkan énankiin ya naawun písaacii pa piti áasiyoo pipilaan. ");
INSERT INTO krx_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Jakob naasumpool Rasel náayaañ pukooŋ meemak. ");
INSERT INTO krx_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Naakaman Rasel nii akina ati miin ma miti paapaa ateyoo, añii ya ati Rebeka. Fiye, Rasel naatey apicaakaman ho paapaa ateyoo. ");
INSERT INTO krx_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laban niŋ pásiyaloo kiti ásanfunoo Jakob, naatey apicaapaakoolanoo. Naaŋoonoo naasumpooloo naacoopoo ti ekumpaan ya eteyoo. Jakob naakamanoo púlooŋ heetaakiye ha. ");
INSERT INTO krx_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Fiye Laban naasokoo: “Awe atoom tíktik!” Jakob naayeno hiim púmpuluŋ lati Laban. ");
INSERT INTO krx_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Hikee hinoom Laban naasok Jakob: “Awe anam pale, ewunut ánhinaam haahaw. Weyme állafiye upuyeno cooy ya etii?” ");
INSERT INTO krx_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Tempo, Laban naataak púmaacul pákasupak. Ahámpaatiin a caacawoo Leya, kahiineen ka caacaw etenko Rasel. ");
INSERT INTO krx_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya ñíkinoo ñeemise pale Rasel himuumoo heewalla ecuumaka ámaacul. ");
INSERT INTO krx_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jakob náalafi Rasel. Naasok Laban: “Inci píhin taawe fo sitiil isak niŋ súsupak kati sa Rasel ámaacul a atii kahiineen ka.” ");
INSERT INTO krx_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban naañahanoo: “Fisakaam puwufaniyoo, inci cáawufanumoo akee áyiin. Maayeniyaa!” ");
INSERT INTO krx_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Fiyuu Jakob náahine sitiil isak niŋ súsupak ti Laban kati áyini hitaaku Rasel, pale pálafi pa piteyoo mpuwun sitiil sa insimuus samat nii kunoom. ");
INSERT INTO krx_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Fiye naasok Laban: “La maatahoolaa la colaa, ufanam aalam upunimo.” ");
INSERT INTO krx_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laban náayonkalii pikinooloo púlooŋ náahin pahaaño piti esa. ");
INSERT INTO krx_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Pale hánant ha, kati acoop kahiineen ka Rasel, naacoop áhampaatiin a Leya pati Jakob, Jakob naahinto neyoo. ");
INSERT INTO krx_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban naawufan amiikanoo aal Silupa apiyeno amiikan a ati añiinoo Leya. ");
INSERT INTO krx_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Cipilap Jakob náapannum nii, niŋ Leya naayeniye! Naacaasok Laban: “Weyme ánhinaam fiye? Rasel awune inci ínhin taawe, weyme uwune ancaakoolam?” ");
INSERT INTO krx_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban naañahanoo: “Ti cosaan ya etoonii, kahiineen kítikinantoo pinimo púnuwoo. ");
INSERT INTO krx_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Hankan lóokuŋ ya eti esa ya niŋ áhampaatiin a. Niŋ aapayaa, nuuwufani kahiineen ka lompo, pale aañaŋaam páhin sikee sitiil isak niŋ súsupak.” ");
INSERT INTO krx_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jakob naacoon, naahankan lóokuŋ ya eti esa ya niŋ Leya. Púful toko Laban naawufanoo añiinoo Rasel apisayoo. ");
INSERT INTO krx_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Naawufan amiikanoo aal Piluha apiyeno amiikan a ati añiinoo Rasel. ");
INSERT INTO krx_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jakob naahinto lompo niŋ Rasel náalafiyoo pihaŋ Leya. Náahin ti Laban sikee sitiil isak niŋ súsupak. ");
INSERT INTO krx_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ta Ateeteyo naacuke ta nii Jakob álafiit Leya, náahinoo apiyeso; pale Rasel naayeno caakonta. ");
INSERT INTO krx_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leya naasa munow naapuk cikampaani naalu co caacaw ca Ruben (ekina eyem “nisincan, cikampaani!”). Naasok: “Ateeteyo acukaacuk kúnuul ka kutoom; fiye, áyiinam áfaalafiyam.” ");
INSERT INTO krx_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Nene asa munow músupiyenu naapuk cikampaani naasok: “Kamma Ateeteyo naacuke nii Jakob álafiitam, nene awufanam ciñii ence.” Naalu co caacaw ca Simeyon (ekina eyem “aŋa nási”). ");
INSERT INTO krx_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Leya nene asa munow míhaaciyenu naapuk cikampaani naasok: “Fiye áyiinam áfaalafiyam naakolam meemak kamma inci impukoo mikampaani míhaaciil.” Naalu añii ya caacaw ca Lewi (ekina eyem “hikolu”). ");
INSERT INTO krx_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Nene asa munow mípaakiilenu naapuk cikampaani naasok: “Tempe inci múlaa Ateeteyo.” Naalu co caacaw ca Juda (ekina eyem “hímulu”). Púful toko naasiiŋo kaapukool ka. ");
INSERT INTO krx_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ta Rasel náapannume ta nii ayinaat hitaaku epuuk, naataak paheeka ti púnuwoo. Naasok Jakob: “Puk ti inci epuuk niŋ ekina tom faket!” ");
INSERT INTO krx_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jakob inseeñoo teyoo meemak naasokoo: “Fo inci yem Pútuun pa peekituu pa hitaaku añii?” ");
INSERT INTO krx_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rasel naañahanoo: “Ehe Piluha amiikan a atoom, hinto neyoo kati apukam epuuk. Pínapii teyoo inci lompo fataak epuuk.” ");
INSERT INTO krx_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Fiye, naawufan Jakob amiikan a ateyoo Piluha apiyeno aaloo, naahinto neyoo. ");
INSERT INTO krx_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Piluha naasa munow naapuk Jakob cikampaani. ");
INSERT INTO krx_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rasel naasok: “Pútuun pa pisiiŋiyaam, písiyaasi kaluum ka kutoom. Mpúwuniyam cikampaani.” Naalu co caacaw ca Dan (ekina eyem “pisiiŋo an”). ");
INSERT INTO krx_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Piluha amiikan a ati Rasel nene asa munow, naapuk Jakob cikampaani císupiyenu. ");
INSERT INTO krx_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rasel naasok: “Inci suumaasuum fanfaŋ niŋ púnuwam inheekoo.” Naalu co caacaw ca Nafatali (ekina eyem “esuum”). ");
INSERT INTO krx_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ta Leya naacuke ta nii asiiŋaasiiŋo hitaaku añii, naawufan Jakob amiikan a ateyoo Silupa apiyeno aaloo. ");
INSERT INTO krx_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Silupa naapuk Jakob cikampaani. ");
INSERT INTO krx_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leya naasok: “Inci ati halacee!” Naalu co caacaw ca Gad (ekina eyem “halacee”). ");
INSERT INTO krx_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Silupa nene apuk Jakob cikampaani císupiyenu. ");
INSERT INTO krx_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Fiye Leya naasok: “Súumaam! Pakaal paka efikasokam ati pásuuma.” Naalu co caacaw ca Asel (ekina eyem “pásuuma”). ");
INSERT INTO krx_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Hikee hinoom, ti caanak ca citi kaamaañ ka, Ruben naakaay ti hoos naacuk pimantalakool, náalucinii po íññaa ateyoo Leya. Fiye, Rasel naasok Leya: “Káluma, wunam ti pimantalakool pa piti añiini.” ");
INSERT INTO krx_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leya naañahanoo: “Fomuti fa allame fa áyiinam? Fo áalafilafi hilamu lompo pimantalakool pa piti añiinam?” Rasel naasokoo: “Naawunaam ti pimantalakool pa piti añiini, inci fakatan Jakob apihinto niŋ awe hánant ha hiti fíyooy.” ");
INSERT INTO krx_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Kániim enkuu, Jakob naayeno éfulii t’elampa Leya naakaay kaapaakoolanoo naasokoo: “Hánant ha hiti fíyooy lati inci aafaŋot. Cooyaacooy hánant ha niŋ pimantalakool pa piti añiinam.” Fiye, naahinto neyoo oom hánant. ");
INSERT INTO krx_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Pútuun pa mpisayan kaluum ka kiti Leya naasa munow, naapuk Jakob cikampaani císakiyenu. ");
INSERT INTO krx_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Naasok: “Pútuun pa pucooyaamcooy kamma inci uwwufane amiikan a atoom áyiinam.” Naalu co caacaw ca Isakaal (ekina eyem “cooy”). ");
INSERT INTO krx_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leya nene asa munow naapuk Jakob cikampaani ceewase isak niŋ coonool. ");
INSERT INTO krx_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Naasok: “Pútuun pa píhinaam heewalla. Tempe áyiinam afaanimpanam kaatuko inci pukoopuk mikampaani miyema isak niŋ coonool.” Naalu co caacaw ca Sepulun (ekina eyem “kaanimpan”). ");
INSERT INTO krx_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Po hátikin naapuk címaacul naalu co caacaw ca Dina. ");
INSERT INTO krx_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ti pikelan, Pútuun pa mpínawuno Rasel. Mpisayan kaluum ka kiteyoo mpíhinoo apiyeso. ");
INSERT INTO krx_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Naasa munow naapuk cikampaani, naasok: “Pútuun pa púfulanaam ti ñusuu.” ");
INSERT INTO krx_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Naalu co caacaw ca Josef (ekina eyem “kapenan”). Naaluum: “Alímaati Ateeteyo ápenaniyam cikampaani.” ");
INSERT INTO krx_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Pamuusal hipukuyee ha hiti Josef, Jakob naasok Laban: “Katam puñoho pati mah ma mutoom. ");
INSERT INTO krx_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Uwwufanam pakaalam niŋ epuukam keewune ka inci iyyeno áhinayi, inci inkaay. Aámeyimeyi fa inci ínhine fa kitii.” ");
INSERT INTO krx_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Pale Laban naasokoo: “Niŋ inci pitaako ho ti awe, káluma yeno. Pisaapu inci insilane, mpíyisanam nii, ti eloŋ ya etoom Ateeteyo asampanaam-sampan kamma awe.” ");
INSERT INTO krx_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Naapenanoo ti hisoku: “Sok soŋ ya eti páhin pa pitii, inci facooyi.” ");
INSERT INTO krx_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jakob naasokoo: “Aámeyimeyi fa inci ínhine fa kitii niŋ fa púlukuleen pa pitii mpímeeŋii fa kamma inci. ");
INSERT INTO krx_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Caahinkiŋ aŋa antaake ya le niŋ pácolaliyam epenanaapenano meemak. Ateeteyo naasampani emma inci nkákii ma kootam letaawe. Fiye, teyme lompo inci fáhin hak miin ma mutoom?” ");
INSERT INTO krx_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban naacakanoo: “Weyme inci iññaŋuu cooy?” Jakob naañahanoo: “Aatiwufanam waah pale inci fafaas immankool púlukuleen pa pitii niŋ aacoonaam íhinu eehe: ");
INSERT INTO krx_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Túulam pinako ti koolee ya etii fíyooy, ínfulanii písaacii pa niŋ pifil pa púlooŋ peesocutooliye pa niŋ fotom peetaake pa ufaal niŋ mísaacii ma púlooŋ meepaana ma. Ekina efeeyeno cooy ya etoom. ");
INSERT INTO krx_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Po hátikin niŋ áakeyyoo kaasincan cooy ya etoom áafameyi man inci eecoonoole. Efil óo efil eyya ancuke ti inci eesocutooliit niŋ fotom eetaakut kaafaal, niŋ ekina tom císaacii ceepaanaat, ímmeyi nii inci nílipa.” ");
INSERT INTO krx_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban naasokoo: “Inci coonaa, hitaako samat nii fa ansoke fa.” ");
INSERT INTO krx_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Oom hinoom Laban náacaafulan kíceken pifil pa púlooŋ keesocutooliye ka niŋ keenakane ka ñinkaac, uyaan pifil pa púlooŋ weesocutooliye wa niŋ weetaake wa ufaal niŋ mísaacii ma púlooŋ meepaana ma. Naañoman po epuukoo pikampaani. ");
INSERT INTO krx_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Nkaŋal po fo kunoom káhaaciil kati kálaaŋool niŋ Jakob. Fiye, Jakob naayeno efaas aŋa eetowiye ya ti púlukuleen pa piti Laban. ");
INSERT INTO krx_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jakob naacoop unaay punuun weemaaña uti lipune, ñiin niŋ elumon, náaheelin wo fo utaak ñinkaac ñeehiina. ");
INSERT INTO krx_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Náapuuc unaay wa wéeheelinee wa ti púus pa la púlukuleen pa mpilaan la, ancuk niŋ píkeyyoo pálaani, mpisil hátikin unaay wa. ");
INSERT INTO krx_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ta mpisile ta hátikin unaay wa, mpúpukii mufuun meesocutooliye, meetaake ufaal niŋ fotom meenakane ñinkaac, ");
INSERT INTO krx_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jakob náafulan menkilis emmuu citeetemmo, náahin peetowiye pa púpucoonool niŋ písaacii pa piti Laban peepaana pa niŋ peenakane pa ñinkaac mpiyeniyaa casil. Fiyuu Jakob naataake pukoolee pa piteyoo náakatinool po niŋ piti Laban pa. ");
INSERT INTO krx_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Tan óo tan ta peetaake pa sempe mpiyeniye casil, Jakob náapuuc unaay wa ti púus pa, ancuk kati pisil hátikin unaay wa. ");
INSERT INTO krx_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Pale niŋ púlukuleen pa péekuluke pa piyeniyaa casil, anaŋantoo wo toko. Fiye, púlukuleen pa péekuluke pa mpiyeno piti Laban, peetaake pa sempe mpiyeno piti Jakob. ");
INSERT INTO krx_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ti páhinal empuu Jakob naataake hisaanumate henfakat, naataak hícump púlukuleen, pimiikan pákayiin niŋ pakaal, puñonkomoo niŋ púfali piti faŋoo. ");
INSERT INTO krx_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Hikee hinoom, Jakob náasi nii epuuk Laban kasoke nii: “Jakob acoopaa waah óo waah ewwa paapaa atoonii naataake, ekina ewune náayenoonii usaanum.” ");
INSERT INTO krx_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jakob naacuk nii Laban acokutoo pinap samat nii kúcook kuu. ");
INSERT INTO krx_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Fiye, Ateeteyo naasok Jakob: “Ñoho pati mah ma miti símaamayi niŋ ti miin ma mitii, inci fayeno niŋ awe.” ");
INSERT INTO krx_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jakob naakooŋan kápiyonkalii Rasel niŋ Leya kati katoopoo pati kaakit ka pa naayem pa ti efaas pukoolee pa piteyoo. ");
INSERT INTO krx_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ta nkacole ta, naasokii: “Inci cukaacuk nii paapaa ataaluu acokutam pinap samat nii fa naacokaam fa kúcook kuu, pale Pútuun pa piti paapaa atoom piyenaayeno niŋ inci. ");
INSERT INTO krx_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Aluu nímeyimeyi fa inci iyyeniye fa páhin ti paapaa ataaluu niŋ sempeyam púlooŋ. ");
INSERT INTO krx_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Háati fo, naakooñam ápifaliŋ cooy ya etoom fo ñiyema ŋaasuwan. Pale Pútuun pa pikatanutoo apukuumam. ");
INSERT INTO krx_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Tan óo tan naasoke: 'Púlukuleen pa peesocutooliye pa piyem cooy ya etii,' uyaan wa púlooŋ nuupuk mufuun meesocutooliye. Tan óo tan naasoke: 'Púlukuleen pa peenakane pa ñinkaac piyem cooy ya etii,' uyaan wa púlooŋ nuupuk mufuun meenakane ñinkaac. ");
INSERT INTO krx_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Fiyuu Pútuun pa mpúfulane pukoolee pa piti paapaa ataaluu mpuwufanam po. ");
INSERT INTO krx_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Ta púlukuleen pa mpiyeniye ta casil, inci íyyawut incuk kíceken keesocutooliye, keetaake ufaal niŋ keenakane ñinkaac ti casil uyaan wa. ");
INSERT INTO krx_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Maleekoo ya eti Pútuun pa neesokam ti éyawut ya: 'Jakob!' Iññahan yo: 'Eheeyam.' ");
INSERT INTO krx_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Neesokam: 'Háafin, sincan kíceken ka púlooŋ keeyeniye ka casil niŋ uyaan wa: keesocutooliye, keetaake ufaal niŋ fotom keenakane ñinkaac. Kaatuko inci cukaacuk eeha púlooŋ Laban naayeniyuu ha íhinu. ");
INSERT INTO krx_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Inci yem Pútuun pa péeyisanooliye pa ti awe Petel la ansiiŋane la énankiin innuc yo niŋ miyoomeen, insintoolo toko. Fiye, lito fúl ti mah emme iññoho ti mah emma ampukee ma temmo.'” ");
INSERT INTO krx_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rasel niŋ Leya nkañahan Jakob: “Fo utaakaataak hitoonu ti hisaanumate ha hiti paapaa atoonii? ");
INSERT INTO krx_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Acokaacok unii samat nii ekaawoola: anoomanaa-nooman unii púful toko naali mañ ma mutoonii. ");
INSERT INTO krx_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ooto hitaaku ha púlooŋ hiti paapaa atoonii eeha Pútuun pa mpisaye ha teyoo, hitoonii niŋ epuuk unii. Hín eeha púlooŋ Pútuun pa mpusokuu ha.” ");
INSERT INTO krx_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Fiye, Jakob naalito naalapan epuukoo niŋ pakaaloo ti puñonkomoo, ");
INSERT INTO krx_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","naaŋal pukoolee pa piteyoo hátikinoo naacoopool lompo waah óo waah ewwa naataake ti mah ma miti Mesopotami, naañak apuñoho pati paapaa ateyoo Isaak ti mah ma miti Kanaan. ");
INSERT INTO krx_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ta nkayeniye ta hiñaku, loho Laban akaayaa pállaaŋe kaayiinu písaacii pa piteyoo, Rasel náalip pínaati pa piti paapaa ateyoo. ");
INSERT INTO krx_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jakob naakaay peesokut Laban ati Alam waah. Fiyuu naacaakooloo. ");
INSERT INTO krx_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Naatey niŋ waah óo waah ewwa naataake. Naafiitan han ha hiti Efalat naahiiŋ ti pítintiŋ pa empa nkasok pa Kileyat. ");
INSERT INTO krx_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Eti tílapooli eteyyo, an naasok Laban nii Jakob ateyaatey. ");
INSERT INTO krx_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Laban naaconcoolan pakakee ti pakanoo nkawawantan Jakob. Kunoom isak niŋ kúsupak nkatoopanoo ti pítintiŋ pa empa nkasok pa Kileyat. ");
INSERT INTO krx_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Pale hánant ha Pútuun pa mpíyisanoolo ti Laban ati Alam ti éyawut, mpusokoo: “Tah kunuu, timpi háañi aasoke waah Jakob.” ");
INSERT INTO krx_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban naatoopan Jakob loho asiiŋanaa púkuut pa piteyoo ti pítintiŋ pa piti Kileyat. Laban lompo niŋ pakanoo nkasiiŋan púkuut pa piteyii toko. ");
INSERT INTO krx_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban naasok Jakob: “Weyme ánhine? Aacaakoolaam-caakool incoopool epuukam púmaacul samat nii keecokee ti hikam. ");
INSERT INTO krx_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Weyme uwune impuus aapitey incaakoolam aasokutam waah? Inci anti ñooti niŋ pásuuma niŋ kícimu, pankalaŋ niŋ púkontiŋ. ");
INSERT INTO krx_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Aakatanutam fala pusumpool niŋ púmaacul pa pakatoom niŋ keesokaam maamaa le niŋ éfuukatinool. Pánipani aawenaawen nii awuyawuy! ");
INSERT INTO krx_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Inci yíniyini íhinu aluu pínapaati, pale Pútuun pa piti paapaa atii pusokaam hánant ha heemuuse ha nii: 'Tah kunuu timpi háañi aasoke waah Jakob.' ");
INSERT INTO krx_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Fiye, aañakaa kamma aññotane puñoho pati ekumpaan ya eti faafi, pale weyme uwune aakati líp pínaati pa putoom?” ");
INSERT INTO krx_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jakob naañahanoo: “Inci feyaafe ímmiilool nii aafalam púmaacul pa pakatii. ");
INSERT INTO krx_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Pale naacukaa aŋa eecoope ya pínaati pa pitii, oom an afaaket. Hátikin pakan anii, sincan ti wañ wa utoom, man aafacuk waah utii incoop wo.” Antúŋ Jakob ápannumut nii Rasel álipe pínaati pa. ");
INSERT INTO krx_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Fiye, Laban naanako ti ékuut ya eti Jakob, eti Leya niŋ eti pimiikan pa pakaal paka pákasupak paka pale acukut waah. Apúfulii ti ékuut ya eti Leya naanako ti eti Rasel ya. ");
INSERT INTO krx_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Pale ánakumo ti ékuut ya eti Rasel, loho Rasel acoopaa pínaati pa naawas po ti pícipa empa nanaŋ pa ti ñonkomoo ya eteyoo, naayeno tempo. Laban naaŋesatool, náamaaputool ti ékuut ya púlooŋ pale acukut waah. ");
INSERT INTO krx_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rasel naasok paapaa ateyoo: “Ahámpaatiin, timpi ñíken, inci yinaat pisiiŋo hátikini kamma inci iyyem niŋ etaam.” Fiye, naaŋesatool pale ayinaat hicuku pínaati pa piteyoo. ");
INSERT INTO krx_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jakob inseeñoo naawatan Laban: “Weyme inci ínhine weenaput? Enkeyme kaamuuyen inci ínhine aakati mpinapanoolam fiye? ");
INSERT INTO krx_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Páawoo aaŋesatoolaa ímmaaputool lan óo lan ti wañ wa utoom, weyme ancuke weeyem utii? Yísan wo le hátikin pakanam niŋ pakani kati kayeno píhina anii kíiti. ");
INSERT INTO krx_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Inci yenaayeno niŋ awe fo sitiil áwii. Munow písaacii pa niŋ pifil pa pitii múpuciit, taapala li lompo hícekeni. ");
INSERT INTO krx_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Cóopiyooti élukuleen eyya púlukuleen elampa mpumuke, inci himuumam incoop oom pitiyo. Pale awe, iññaakam pucooy púlukuleen pa péelipee pa hánant niŋ fotom hanakan. ");
INSERT INTO krx_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Aŋe eyeniye eloŋam: hanakan ha pasowe pa mpumukam, hánant ha pamon pa mpumukam, yínantoo hiŋotu. ");
INSERT INTO krx_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Fiyuu inci iyyeniye eloŋ fo sitiil áwii ti ekumpaan ya etii. Inhíni fo sitiil ŋaasuwan niŋ sipaakiil kati yíni esa púmaacul pa pakatii pákasupak paka, niŋ sitiil isak niŋ yoonool kati yíni hitaaku pukoolee. Kápiliŋ emma íncolii fo fíyooy, áafaliŋaa cooy ya etoom fo ñiyema ŋaasuwan. ");
INSERT INTO krx_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Niŋ Pútuun pa piti maamaa atoom Abraham empa paapaa atoom Isaak naafeye pa piyankananutam, anti katanam piyet sipeesam ñaanii. Pale Pútuun pa pucukaacuk fa inci inkete fa ti páhin niŋ sipeesam mpucuk lompo kúnuul ka kutoom. Hánant ha hiti hukan mpuwufanam tooñaa ya.” ");
INSERT INTO krx_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban naañahan Jakob: “Pakaal paka payenke, púmaacul pa pakatoom; epuuk ya payenke, keesokaam maamaa; púlukuleen empe, púlukuleenam. Waah óo waah ewwa ancuke le utoom. Pale fiye inci yinaat íhinu waah ti púmaacul pa pakatoom niŋ ekina tom epuuk ya payenka nkapuke ka. ");
INSERT INTO krx_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Kéy maaliilaa písiyool, immaaŋesaa waah ewwa efuuyeno píyisan písiyool anii.” ");
INSERT INTO krx_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Fiye, Jakob naacoop énankiin naasiiŋan yo. ");
INSERT INTO krx_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Naasok pakanoo: “Niyesal pínankiin.” Nkaŋes pínankiin nkácumpool po. Púful toko nkali pukol hicuus ha. ");
INSERT INTO krx_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban naalu toko caacaw ca Yekal Sahatuta, Jakob naalu toko caacaw ca Kalet. ");
INSERT INTO krx_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban naasok: “Fíyooy, hicuus eehe hiyem heetantake ha ti pututayam niŋ awe.” Ekina ewune nkalu toko caacaw ca Kalet (ekina eyem “hicuus heetantake”). ");
INSERT INTO krx_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Nkalu lompo toko caacaw ca Misupa (ekina eyem: “ésiiŋuma eti efaas pakan”). Laban nene asok: “Alímaati Ateeteyo afaas anii kati máatuulaa písiyool pa pitaanii niŋ máalaaŋoolaa. ");
INSERT INTO krx_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Niŋ aakallanaa púmaacul pa pakatoom niŋ ekina tom insa pakakee pakaal, háati an atantakut, pale méyi nii Pútuun pa himuum etempo piyem eetantake ya ataanii.” ");
INSERT INTO krx_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban nene asok Jakob: “Sincan hicuus ha niŋ énankiin ya: sílankamaasi súsupak ensa inci insiiŋane ti pututa anii. ");
INSERT INTO krx_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Sikina siyem seetantake sa sitaanii. Inci sintooliyaa nii etifiitan hicuus ha píkey puu taawe píhini heenaput, awe lompo aañaŋut éfiitanii hicuus ha niŋ énankiin ya áapikey peti inci íhinuyam heenaput. ");
INSERT INTO krx_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Alímaati Pútuun pa piti Abraham niŋ Pútuun pa piti Nahol píhin anii kíiti.” Fiye, Jakob naasintoolo hátikin Pútuun pa empa paapaa ateyoo Isaak naafeye pa. ");
INSERT INTO krx_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Púful toko Jakob naawaaseen Pútuun pa ti tíntiŋ ya naayonkal pakanoo hili, nkali nkaŋot ti tíntiŋ ya. ");
INSERT INTO krx_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Eti kacom eteyyo mpucom mic, Laban naasumpool keesokoo maamaa niŋ epuukoo púmaacul pa naasampanii. Fiye, naañak naañoho pateyoo. ");
INSERT INTO krx_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Laban payetaloo, Jakob naayeno kaahankan pítin pa piteyoo, pumaleekoo piti Pútuun pa mpíkey kapaakoolanoo. ");
INSERT INTO krx_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ta naacuke po ta naasok: “Kayoŋ ka kiti pusoocaali pa pakati Pútuun pa kíkeyii kipisiiŋo le!” Naalu toko caacaw ca Mahanayim (ekina eyem “uyoŋ úsupak”). ");
INSERT INTO krx_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jakob naapoñ pakan kapunowoo hátikin pati púnuwoo Esawu eekine ya ti mah ma miti Seyil, ti etaam ya eti Etom. ");
INSERT INTO krx_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Naasokii: “Eehe efinisok áhampaatiin a atoom Esawu: Jakob, amiikan a atii, asok: 'Pati Laban inci iyyeniye nkampan po fo fiye. ");
INSERT INTO krx_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Inci taakaataak síis niŋ púfali, písaacii niŋ pifil, pimiikan pákayiin niŋ pakaal. Impóñii pakan kapusoki eehe, awe áhampaatiin, aakati wananam ti kásuumaay.'” ");
INSERT INTO krx_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Keepoñee ka nkakaay pati Esawu nkáñohoonii ti Jakob nkasokoo: “Ukaayaakaay pati púnuwi Esawu akina lompo oopa ti ékey kapaakoolani niŋ pákayiin sikeme sipaakiil (400).” ");
INSERT INTO krx_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jakob naameeŋ niŋ ewatate naaliim. Náapaacinool pakan paka keeyeniye ka neyoo ti uyoŋ úsupak, niŋ lompo písaacii pa niŋ pifil pa, síis sa niŋ puñonkomoo pa. ");
INSERT INTO krx_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Naasokoolo: “Niŋ Esawu acolaa ti kayoŋ koonool naalaako ko, kikee kayoŋ ka éfikiyini hifaku.” ");
INSERT INTO krx_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Púful toko Jakob naayeno kaluum: “Pútuun pa piti maamaa atoom Abraham, Pútuun pa piti paapaa atoom Isaak, awe Ateeteyo aasokaam: 'Ñoho ti mah ma mitii niŋ ti miin ma mitii, inci fáhini heenape.' ");
INSERT INTO krx_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Inci túuniit hitaaku heenape ha púlooŋ eeha ánhinaam ha samat nii fa áyyinananaam fa, inci amiikan a atii. Kaatuko ta inci infiitane ta han ha hiti Jordan, hikasap lamma inci iyyekane. Pale, íññohoonii niŋ uyoŋ wa úsupak ewwe. ");
INSERT INTO krx_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Inci luumuu fakanam ti púnuwam Esawu. Feyoofe, infe mpáakey apumukam, pakaalam niŋ epuukam. ");
INSERT INTO krx_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Pale awe sokaam: 'Pánipani inci fáhini heenape. Keesokuu maamaa efikameeŋ samat nii esiya ya eti kaatii ka, an átayiniyii kafinu.'” ");
INSERT INTO krx_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Oom hánant, Jakob naaŋot toko. Ti pukoolee pa piteyoo naayesal waah ewwa afaawun púnuwoo Esawu: ");
INSERT INTO krx_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","uyaan sifil uyema sikeme súsupak (200) niŋ kíceken pifil kiyema áwii, uyaan sísaacii uyema sikeme súsupak (200), niŋ kíceken písaacii kiyema áwii. ");
INSERT INTO krx_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Naayesal lompo uyaan siñonkomoo weeyem ti káacuuwan uyema áwii niŋ ŋaasuwan (30), uyaan síis uyema áwii ésupak (40), kíciin kiyema ŋaasuwan, uyaan sífali uyema áwii niŋ sífali séeyiine siyema ŋaasuwan. ");
INSERT INTO krx_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Naañoman koolee óo koolee pimiikan pa pakateyoo naasokii: “Ninowam hátikin innikatan káahaaŋ ti koolee óo koolee.” ");
INSERT INTO krx_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Púful toko naawufan hilim eehe amiikan a áyaañ a: “Niŋ púnuwam Esawu apaakoolaa niŋ awe naacakani: 'Awe ati ayme? Peyme ayyem ti pikaayu? Koolee ya eenowe ya hátikin eti ayme?' ");
INSERT INTO krx_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Iññahanoo: 'Eti Jakob, amiikan a atii. Aŋe kawun enka náapoñiyuu, awe áhampaatiin a atoom Esawu. Akina himuumoo oopa ti ékey puson unii.'” ");
INSERT INTO krx_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Jakob nene awufan oom hilim amiikan a ásupiyenu ya, áhaaciyenu ya niŋ keeyeniye ka púlooŋ puson pukoolee pa: “Niŋ nipaakoolaa niŋ Esawu ínnikupoo fiyuu. ");
INSERT INTO krx_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Timpi nifiil nisokoo: 'Jakob, amiikan a atii, oopa ti ékey puson unii.'” Kaatuko Jakob ámiiloolaa-míilool nii: “Niŋ inci poñoo kawun hátikinam, efeewun púsusoo mpumon. Niŋ fúlaa toko inci fakaay teyoo, pikee pa naawananam pinap.” ");
INSERT INTO krx_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Fiye pukoolee pa mpunow hátikin, oom hánant Jakob naatowo la nkasiiŋane la púkuut pa piteyii. ");
INSERT INTO krx_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","23","Oom hánant Jakob naalito naacoop pakaaloo pákasupak paka, pakaaloo pimiikan pa pákasupak paka niŋ epuukoo pákayiin ŋaasuwan niŋ oonool a, náahinii kapifiitan hiyanu ha hiti Yapok niŋ waah óo waah ewwa naataake. ");
INSERT INTO krx_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Jakob naayeno lamayoo. Fiye, akee áyiin naayeno esuum neyoo fo cilap. ");
INSERT INTO krx_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ayíin a náameyi nii ayinaat Jakob. Ta naayeniye ta esuum neyoo, naasapoo ti efank néekapino. ");
INSERT INTO krx_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Púful toko naasok Jakob: “Caanak ca unca ti éfulii, katanam pikaay.” Jakob naañahanoo: “Etikatani aapikaay. Sampanam fala.” ");
INSERT INTO krx_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Naacakanoo: “Caacawi puume?” Jakob naañahanoo: “Caacawam Jakob.” ");
INSERT INTO krx_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Nene asokoo: “Caacawi etinene ciyeno Jakob pale aafasokee Israyel. Kaatuko aasuumaasuum niŋ Pútuun pa niŋ pakan paka inheekii.” ");
INSERT INTO krx_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jakob naasokoo: “Ponket sokam caacawi.” Naañahanoo: “Weyme uwune ancakan caacawam?” Púful toko naasampanoo. ");
INSERT INTO krx_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jakob naalu toko caacaw ca Penuwel (ekina eyem “puhooŋu Pútuun pa”) kaatuko asok: “Inci cukaacuk táh puhooŋu Pútuun pa, apan eloŋam neefakanee.” ");
INSERT INTO krx_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ta caanak ca inciyeniye ta éfulii, Jakob náaful Penuwel naayeno kátakis kamma efankoo. ");
INSERT INTO krx_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ekina ewune fo fíyooy, pakati Israyel kaliyantoo fasa ya éefulii ya ti hipoŋ ha epuwant efank ya, kaatuko ti fasa eyyuu Jakob naasapee. ");
INSERT INTO krx_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jakob náahaafin naaŋantan Esawu ti ékey niŋ pakan sikeme sipaakiil; fiye, náapaacinool epuukoo ti Leya, Rasel niŋ pimiikan pa pakaal paka pákasupak paka. ");
INSERT INTO krx_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Naanonowan pimiikan pa pákasupak paka niŋ epuukii, Leya niŋ epuukoo nkanow pusonii, Rasel niŋ Josef nkákelanii. ");
INSERT INTO krx_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Akina faŋoo naanowii hátikin, náakilipo puhooŋuyoo t’etaam fo ñiyema isak niŋ ñésupak álohanum púnuwoo. ");
INSERT INTO krx_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Pale Esawu naatey apipaakoolan Jakob, naaŋoonoo naasumpooloo, poko t’ésupakii nkayeno pukooŋ. ");
INSERT INTO krx_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esawu náasaalino naacuk pakaal paka niŋ epuuk ya, naacakanoo: “Pakayme kayem fiye niŋ awe?” Jakob naañahanoo: “Poko kayem epuuk ya payenka Pútuun pa mpuwunaam ka, inci amiikan a atii.” ");
INSERT INTO krx_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Fiye, pimiikan pa pákasupak paka niŋ epuukii nkalohii nkákilipo, ");
INSERT INTO krx_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leya lompo niŋ epuukoo nkalohii nkákilipo, ti pikelan Josef niŋ Rasel nkalohii nkákilipo. ");
INSERT INTO krx_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esawu naacakan: “Pukoolee empa inci impaakoole pa púlooŋ, piti weyme?” Jakob naañahanoo: “Awe inci uwwune po, aakati wananam ti kásuumaay, áhampaatiin a atoom.” ");
INSERT INTO krx_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Pale Esawu naañahanoo: “Atuwam, inci taakaataak ñác! Mank waah wa utii.” ");
INSERT INTO krx_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jakob naañahanoo: “Káluma inci luumuu, iyyema aaponketaam, coon kawun ka kutoom. Kaatuko hicuku puhooŋuyi cukaacuk nii hicuku puhooŋu Pútuun pa apan uwwananam. ");
INSERT INTO krx_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ooto káluma, sayan kawun ka kutoom. Kaatuko Pútuun pa puwunaamwun meemak, intaak aŋa inci insoolahe ya.” Páawoo Jakob aŋiiniyooŋiino, ti pikelan naacoon. ");
INSERT INTO krx_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Púful toko Esawu naasokoo: “Lito ukaayaa, inci fanowi hátikin.” ");
INSERT INTO krx_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Pale Jakob naañahanoo: “Ahámpaatiin, áameyimeyi nii epuuk ya kayekut sempe, ñaŋaa lompo kaamankool púlukuleen pa peeyem pa ti káacuuwan: písaacii pa niŋ síis sa. Niŋ piŋalee niŋ kahiliikan háati hinoom hoonool efipiket. ");
INSERT INTO krx_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Fiye áhampaatiin, nowam hátikin, inci amiikan a atii, fásapalii caahinkiŋ caahinkiŋ niŋ epuuk ya niŋ pukoolee pa fo inci cólii pukol áhampaatiin a atoom ti mah ma miti Seyil.” ");
INSERT INTO krx_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esawu naasokoo: “Ooto inci pikati niŋ pakakee pákayiin paka pakatoom.” Jakob naañahanoo: “Weyme uwune aakati hín eehuu? Lonko inci intaake kawanan ka kiti áhampaatiin a atoom.” ");
INSERT INTO krx_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Oom hinoom Esawu naañohiye Seyil. ");
INSERT INTO krx_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Pale Jakob naakaay Sukot. Po, naalut ekumpaanoo naasiiŋan lompo púkuut piti púlukuleen pa piteyoo. Ekina ewune nkalu toko caacaw ca Sukot (ekina eyem “púkuut”). ");
INSERT INTO krx_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ti pikelan, Jakob naacol ti kásuumaay ti saatee ya eti Sikem ti mah ma miti Kanaan, loho áfuliyoo Mesopotami. Naakin púcoonool saatee ya. ");
INSERT INTO krx_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Naanoom etaam ya la naasiiŋane la ékuut ya eteyoo ti epuuk Hamol, Sikem paapaa ateyoo. Naacooyii sikoofali keme. ");
INSERT INTO krx_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Naalut toko kaaciin naalu ko caacaw ca El-Elohe-Israyel (ekina eyem “Pútuun pa piyem Pútuun pa piti Israyel”). ");
INSERT INTO krx_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Hikee hinoom Dina, ámaacul a ati Jakob niŋ Leya, naakaay hiyoop pakakee púmaacul pakati Kanaan. ");
INSERT INTO krx_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Akina po, Sikem, añii ya ati áhampaatiin a ati mah emmuu aŋa nkasok ya Hamol, eesoke Hiw maamaa, naacuk Dina, naacokoo naahinto neyoo ti sempeyoo. ");
INSERT INTO krx_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Pale náalafi pánipani Dina, Jakob ámaacul a ateyoo. Náalafiyoo meemak naayeniyoo kaapuutool kati álafiyoo. ");
INSERT INTO krx_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sikem naasok paapaa ateyoo Hamol: “Caaŋesam ámaacul aŋe, láfilafi ápiyenoonii aalam.” ");
INSERT INTO krx_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Tempo Jakob náasiye nii Sikem alecatanaa-lecatan ámaacul a ateyoo, pale pikampaani pa pakateyoo nkayeno ti káahoonanuma niŋ pukoolee pa piteyoo. Fiye, asokut waah fo káñohoonii. ");
INSERT INTO krx_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Púful toko, Hamol paapaa ati Sikem naakaay pati Jakob káakup neyoo. ");
INSERT INTO krx_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ta pikampaani pa pakati Jakob nkáñohoonii ta, nkási heetaakiye ha. Incíitiyii nkataak paseeña penfakat kaatuko Sikem ateñalaateñal pakati Israyel ti páhinal pa peesuuwanana empuu kamma naahintiye niŋ ámaacul a ati Jakob niŋ sempeyoo, apan an añaŋut eehuu íhinu. ");
INSERT INTO krx_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Pale Hamol naasokii: “Añiinam Sikem álafilafi ámaacul a ataaluu. Káluma, niwunoo akampaani ya atoom apisayoo. ");
INSERT INTO krx_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Uyeniyaa pakoonool, upusa púmaacul pa pakataaluu, aluu lompo innisa pakatoonii paka. ");
INSERT INTO krx_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Níyiniyini pikin noonii; mah ma umma hátikin aluu, nikin la fásuum la aluu ti etaam ya. Níyiniyini kaanooman noonii, ínniyini lompo hitaaku pitaam.” ");
INSERT INTO krx_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sikem himuumoo naasok paapaa ati ámaacul a niŋ pakahoopoo: “Niŋ inci pitaako ho taaluu, niwunamoo. Inci fawufan aluu waah óo waah ewwa innicakanaam. ");
INSERT INTO krx_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Nisokam paason pa, inci facooy waah óo waah ewwa innisokaam. Lonko inniwunaam ámaacul a aŋe apiyeno aalam.” ");
INSERT INTO krx_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Pale pikampaani pa pakati Jakob nkañahan Sikem niŋ paapaa ateyoo Hamol ti kaacaakoolii kamma Sikem naalecatane ahoopii Dina. ");
INSERT INTO krx_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Nkasokii: “Uyinaat kawun ahoop unii apinimo ti áful; aŋuu ñusuu toonii. ");
INSERT INTO krx_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Efuucoon kaluum ka kitaaluu ti hoonool eehe lamma: pákayiin paka pakataaluu púlooŋ kañaŋee kanakan samat nii unii. ");
INSERT INTO krx_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Innicoonaa eehe, efuuwufan aluu púmaacul unii nipisa, nuusa lompo púmaacul aluu. Nuukin pukol aluu nuuyeniyaa miin moonool. ");
INSERT INTO krx_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Pale niŋ nicoonut nipinakanee, efuulam ahoop unii nuukaay.” ");
INSERT INTO krx_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Kilim enkuu nkúsuum Hamol niŋ añiinoo Sikem. ");
INSERT INTO krx_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Akampaani ya akuuteenut ti íhinu eeha nkasokoo ha kaatuko álafilafi meemak ámaacul a ati Jakob apan naataak hilim ti ekumpaan ya eti faafoo. ");
INSERT INTO krx_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Fiye, Hamol niŋ añiinoo Sikem nkakaay ti putum saatee ya eteyii káatuunan hilim ha ñíhampaatiin ña pakati saatee ya, nkasokii: ");
INSERT INTO krx_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Payenke pakan keenape tuunaa. Kakin ti mah ma nkanooman temmo, etaam ya eweñaaweñ efikaleh. Usayaa púmaaculii nuuwufanii púmaacul unaa kapisa. ");
INSERT INTO krx_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Efikacoon pikin nuunaa kati uyeniyaa pakoonool pale fo hoonool, pákayiin paka pakatuunaa púlooŋ kañaŋee kanakan samat nii poko. ");
INSERT INTO krx_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Niŋ ucoonaa eehuu lamma éfikakey kapikin niŋ unaa. Hisaanumate ha hiteyii púlooŋ efihiyeno hituunaa: pukoolee pa niŋ waah óo waah ewwa nkataake.” ");
INSERT INTO krx_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ñíhampaatiin ña púlooŋ keeyeniye ka ti putum saatee ya nkacoon kilim ka kiti Hamol niŋ añiinoo Sikem. Pákayiin paka pakati saatee ya púlooŋ nkanakanee. ");
INSERT INTO krx_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Eti tílapooli eteyyo, pákayiin paka nkaloŋ niŋ ñíseeña, pikampaani pákasupak ti Jakob epuukoo, Simeyon niŋ Lewi, Dina pakahoopoo, nkacoop úkuntu wa uteyii, nkalaako saatee ya an péepannumut nkamuk pákayiin paka púlooŋ. ");
INSERT INTO krx_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Nkamuk lompo Hamol niŋ añiinoo Sikem. Púful toko nkáfulanii ahoopii Dina lati ekumpaan ya eti Sikem nkakaay. ");
INSERT INTO krx_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Keetowiye ka ti epuuk Jakob nkamaapanool keekete ka, nkálip waah óo waah weeyem ti saatee ya kamma nkalecatane ahoopii. ");
INSERT INTO krx_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Nkacoop pifil pa, písaacii pa, síis sa, púfali pa niŋ waah óo waah weeyem ti saatee ya niŋ pati ukit wa. ");
INSERT INTO krx_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Nkacoop hisaanumate ha hiteyii púlooŋ, epuukii púlooŋ niŋ pakaalii. Nkálip waah óo waah weeyem ti pukumpaan pa piteyii. ");
INSERT INTO krx_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Púful toko, Jakob naasok Simeyon niŋ Lewi: “Niwasaam kúnuul: kamma aluu, písii pa piti Kanaan niŋ piti Pelis efipinatam. Umeeŋutaa; niŋ kananfoolaa nkalaakiyam efikamukam niŋ miin ma mutoom púlooŋ.” ");
INSERT INTO krx_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Simeyon niŋ Lewi nkañahanoo: “Fo áyiin aŋuu añaŋaa hicoku ahoop unii nii aal ahaañiya naahinto neyoo?” ");
INSERT INTO krx_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Hikee hinoom, Pútuun pa mpusok Jakob: “Lito! Silo incaayeno Petel, illutam po kaaciin, inci Pútuun pa péeyisanooliye pa ti awe ta ayyeniye ta katey púnuwi Esawu.” ");
INSERT INTO krx_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Jakob naasok miin ma miteyoo niŋ keeyeniye ka neyoo púlooŋ: “Nífulan pínaati pa pitaaluu innikuulanoolo inniwaso ukee wañ. ");
INSERT INTO krx_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Innimemanoolo upusiliyaa Petel. Falut po kaaciin kiti Pútuun pa peeyiiŋiyaam pa ti hinoom ha eeha inci iyyeniye ha ti páciite. Pikina piyeniye niŋ inci pan óo pan pa inci inkaaye.” ");
INSERT INTO krx_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Fiye, nkawufan Jakob pínaati pa piteyii púlooŋ niŋ pukop pa peeyeniye pa ti unuuwii. Jakob naahokan po púlooŋ t’etaam enuun ya enfakat ya pukol Sikem. ");
INSERT INTO krx_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ta nkayeniye ta pikaayu, Pútuun pa mpúwananii ewatate enfakat ti pakan paka pakati pisaatee pa péekinkoolii pa, ancuk an timpi áhaañiyii kawawantan kati alaakiyii. ");
INSERT INTO krx_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jakob naacol Lus (ekina nkasok Petel) ti mah ma miti Kanaan, niŋ keeyeniye ka neyoo púlooŋ. ");
INSERT INTO krx_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Toko, naalut kaaciin naalu toko caacaw ca El-Petel (ekina eyem “Pútuun pa piti Petel”) kaatuko toko Pútuun pa mpíyisanooliye teyoo ta naayeniye ta katey púnuwoo Esawu. ");
INSERT INTO krx_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Po lompo Debora amiikan a ati Rebeka éehinoo ya pampaani naakete, naahokee pukol Petel t’etaam enuun enfakat. Kápiliŋ oom hinoom nkayonkal yo “Enuun ya eti Pukooŋ pa”. ");
INSERT INTO krx_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Pútuun pa nene píyisanoolo ti Jakob ti saatee ya eti Petel, loho áñohooniyoo ápufulii Mesopotami, mpisampanoo. ");
INSERT INTO krx_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Mpusokoo: “Caacawi Jakob, pale aatinene yonkalee Jakob. Písik fíyooy caacawi eficiyeno Israyel.” Fiyuu Pútuun pa mpuluwoo caacaw ca Israyel. ");
INSERT INTO krx_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Nene pusokoo: “Inci yem Pútuun pa piti sempe sa púlooŋ. Pukool immeeŋ epuuk. Inci fáhini aapiyeno maamaa ati síi focaa kayoŋ písii. Pumansa efikapukee ti miin ma mitii. ");
INSERT INTO krx_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Mah emma inci uwwufane ma Abraham niŋ Isaak, inci fawufani mo. Po hátikin, inci fawufan mo lompo keesokuu maamaa.” ");
INSERT INTO krx_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Púful toko, Pútuun pa mpikatoo la mpiyeniye la káakup neyoo mpikaay. ");
INSERT INTO krx_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jakob naasiiŋan toko énankiin, naaniis teyyo elaan apisampan yo naanuc yo niŋ miyoomeen. ");
INSERT INTO krx_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","La Pútuun pa mpúkupe la neyoo, Jakob naalu toko caacaw ca Petel (ekina eyem “ekumpaan ya eti Pútuun pa”). ");
INSERT INTO krx_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Jakob niŋ miin ma miteyoo nkáful Petel. Saatee ya eti Efalata neeloŋ néelaaŋe; fiye, Rasel íyyiŋooliyoo, hipuku ha hiteyoo nihiseeñ. ");
INSERT INTO krx_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ta Rasel naayeniye ta hipuku niŋ ñíseeña, aloŋana ya naasokoo: “Timpi fe, nene cikampaani.” ");
INSERT INTO krx_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Pale Rasel naayeno ti putum eket. Ta naayeniye ta eket, naalu cikampaani ca caacaw ca Ben-Oni (ekina eyem “añii ati ñíseeñayam”). Pale Jakob naalu cikampaani ca caacaw ca Benjamin (ekina eyem “añii ati epees yáali”). ");
INSERT INTO krx_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Fiyuu Rasel naakete naahokee ti pítin pa piti Efalata (ekina nkasok fiye Betelehem). ");
INSERT INTO krx_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jakob naasiiŋan énankiin ti hiyaak ha hiti Rasel. Enánkiin eyyuu uyya toko fo fíyooy. ");
INSERT INTO krx_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israyel nene atoosan ékuut ya eteyoo naamuusaa Mikatal-Etel. ");
INSERT INTO krx_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ta Israyel naayeniye ta ti oom mah, Ruben naahinto niŋ Piluha, akee aal a amiikan a aŋa paapaa ateyoo naasaye ya. Israyel náasi ho. Ehe epuuk Jakob, kayema ŋaasuwan niŋ pákasupak: ");
INSERT INTO krx_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leya epuukoo kayem: Ruben, añii ya áyaañ a ati Jakob, Simeyon, Lewi, Juda, Isakaal niŋ Sepulun. ");
INSERT INTO krx_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rasel epuukoo kayem: Josef niŋ Benjamin. ");
INSERT INTO krx_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Piluha, amiikan a ati Rasel, epuukoo kayem: Dan niŋ Nafatali. ");
INSERT INTO krx_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Silupa, amiikan a ati Leya, epuukoo kayem: Gad niŋ Asel. Payenkuu kayem epuuk Jakob keepukee ka Mesopotami. ");
INSERT INTO krx_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Fiye, Jakob naañoho lati Paapaa ateyoo Isaak ti saatee ya eti Mamule pukol Kiliyat-Alepa (ekina nkasok fiye Hepolon). Po Abraham niŋ Isaak nkakine hínum samat nii ekaawoola. ");
INSERT INTO krx_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isaak naataak eloŋ eehaane néesuum, naasuuŋut pikelan naaket loho ataakaa sitiil keme niŋ áwii epaakiil (180) naananf pakataama. Epuukoo Esawu niŋ Jakob kahokoo. ");
INSERT INTO krx_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ehe kiti miin ma miti Esawu (aŋa nkasok a Etom). ");
INSERT INTO krx_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esawu naasa púmaacul pakati Kanaan: Ata, ámaacul a ati Elon ati miin ma miti Het, niŋ Oholipama, ámaacul a ati Ana, eesoke Sipeyon ati miin ma miti Hiw maamaa. ");
INSERT INTO krx_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Naasa lompo Pasumat, ámaacul a ati Ismayel, Nepayot ahoopoo. ");
INSERT INTO krx_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esawu aaloo Ata naapukoo Elifas, Pasumat naapukoo Leyuwel. ");
INSERT INTO krx_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholipama naapukoo Yewus, Yalam niŋ Kolah. Payenkuu kayem epuuk pákayiin paka pakati Esawu payenka naapuke ka ti mah ma miti Kanaan. ");
INSERT INTO krx_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esawu naacoop pakaaloo niŋ epuukoo pákayiin niŋ pakaal niŋ pakan paka púlooŋ keeyem ka ti ekumpaan ya eteyoo. Naacoop lompo pukoolee pa piteyoo, púlukuleen pa piteyoo púlooŋ niŋ lompo hisaanumate ha hiteyoo púlooŋ eeha naataake ha ti mah ma miti Kanaan. Naakaay ti mikee mah ápilaaŋ atuwoo Jakob. ");
INSERT INTO krx_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Kaatuko kayinaat pikin nantoonool kamma hisaanumate ha hiteyii nihifome meemak. Mah emma nkayeniye ma temmo samat nii ekaawoola mufomutii kati kahoonan pukoolee pa piteyii. ");
INSERT INTO krx_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Fiyuu Esawu (aŋa nkasok a Etom) naakaaye apicaakin ti tíntiŋ ya eti Seyil. ");
INSERT INTO krx_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ehe kiti miin ma miti Esawu, maamaa ati pakati Etom, eeyeniye ya ti tíntiŋ ya eti Seyil. ");
INSERT INTO krx_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ehe ucaw epuuk pákayiin paka pakati Esawu: Elifas, akampaani ya ati aaloo Ata, Leyuwel akampaani ya ati aaloo Pasumat. ");
INSERT INTO krx_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Epuuk pákayiin paka pakati Elifas kayem: Teman, Omal, Sefo, Katam niŋ Kenas. ");
INSERT INTO krx_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifas añii ya ati Esawu naataak lompo amiikan aal aŋa naasaye, caacawoo Timuna. Naapukoo akee akampaani, akina ayem Amalek. Payenkuu kayem keesoke Esawu niŋ aaloo Ata maamaa. ");
INSERT INTO krx_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ehe epuuk pákayiin paka pakati Leyuwel: Nahat, Serah, Sama niŋ Misa. Payenkuu kayem keesoke Esawu niŋ aaloo Pasumat maamaa. ");
INSERT INTO krx_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Oholipama ámaacul a ati Ana, eesoke Sipeyon maamaa, naapuk Esawu epuuk ya pákayiin paka payenke: Yewus, Yalam niŋ Kolah. ");
INSERT INTO krx_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ehe písii pa peesoke pa Esawu maamaa: Esawu añiinoo áyiin a ácook a, Elifas, ayem maamaa ati písii empe: Teman, Omal, Sefo, Kenas, ");
INSERT INTO krx_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kolah, Katam niŋ Amalek. Payenkuu púlooŋ kayem keesoke Esawu niŋ aaloo Ata maamaa ti mah ma miti Etom. ");
INSERT INTO krx_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esawu añiinoo áyiin, Leyuwel, ayem maamaa ati písii empe: Nahat, Serah, Sama niŋ Misa. Payenkuu púlooŋ kayem keesoke Esawu niŋ aaloo Pasumat maamaa ti mah ma miti Etom. ");
INSERT INTO krx_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Písii empe púfulii ti Esawu niŋ aaloo Oholipama, ámaacul a ati Ana: Yewus, Yalam niŋ Kolah. ");
INSERT INTO krx_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Písii empuu púlooŋ púfulii ti Esawu (aŋa nkasok a Etom). ");
INSERT INTO krx_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Kéetikine ka kakin ti mah ma miti Etom kayem pakati miin ma miti Seyil eesoke Hol maamaa. Písii pa péefulii pa ti Seyil piyem: Lotan, Sopal, Sipeyon, Ana, Tison, Esel niŋ Tisan. ");
INSERT INTO krx_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Epuuk pákayiin paka pakati Lotan kayem: Holi niŋ Hemam. Lotan ahoopoo ayem Timuna. ");
INSERT INTO krx_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ehe epuuk pákayiin paka pakati Sopal: Aluwan, Manahat, Epal, Sefo niŋ Onam. ");
INSERT INTO krx_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ehe epuuk pákayiin paka pakati Sipeyon: Aya niŋ Ana. Ana alaŋane man ti káahaaŋ tes ta naayeniye ta efaas púfali pa piti paapaa ateyoo Sipeyon. ");
INSERT INTO krx_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ehe epuuk Ana: akampaani ya ateyoo Tison niŋ ámaacul a ateyoo Oholipama. ");
INSERT INTO krx_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ehe epuuk pákayiin paka pakati Tison: Hemutan, Esepan, Italan niŋ Kelan. ");
INSERT INTO krx_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ehe epuuk pákayiin paka pakati Esel: Piluhan, Saawan niŋ Akan. ");
INSERT INTO krx_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ehe epuuk pákayiin paka pakati Tisan: Us niŋ Alan. ");
INSERT INTO krx_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Ehe písii pa peesoke pa Hol maamaa ti mah ma miti Etom: Lotan, Sopal, Sipeyon, Ana, Tison, Esel niŋ Tisan. ");
INSERT INTO krx_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ehe keeyeniye ka pumansa ti mah ma miti Etom táakum toko pumansa pakati Israyel: ");
INSERT INTO krx_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Pelak añii ya ati Peyol ati saatee ya eti Tinuhapa naayeno amansa ti mah ma miti Etom. ");
INSERT INTO krx_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Pamuusal eket ya eti Pelak, Yopap añii ya ati Serah ati saatee ya eti Posola naatoon himansate ha. ");
INSERT INTO krx_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Pamuusal eket ya eti Yopap, Husam ati mah ma miti keesoke Teman maamaa naatoon himansate ha. ");
INSERT INTO krx_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Pamuusal eket ya eti Husam, Hatat añii ya ati Petat ati saatee ya eti Awit naatoon himansate ha. Akina aheeke keesoke Mitiyan maamaa ti mah ma miti Mowap. ");
INSERT INTO krx_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Pamuusal eket ya eti Hatat, Samula ati saatee ya eti Maseleka naatoon himansate ha. ");
INSERT INTO krx_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Pamuusal eket ya eti Samula, Sawul ati saatee ya eti Lehopot eeyem ya ti han ha naatoon himansate ha. ");
INSERT INTO krx_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Pamuusal eket ya eti Sawul, Paal-Hanan añii ya ati Akepol naatoon himansate ha. ");
INSERT INTO krx_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Pamuusal eket ya eti Paal-Hanan añii ya ati Akepol, Hatal ati saatee ya eti Pawu naatoon himansate ha. Aaloo caacawoo Mehetapel, ámaacul a ati Matelet, eesoke Me-Sahap maamaa. ");
INSERT INTO krx_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Esawu (aŋa nkasok a Etom) ayem maamaa ati písii empe: Timuna, Aluwa, Yetet, Oholipama, Ela, Pinon, Kenas, Teman, Mipusal, Makatiyel niŋ Ilam. Síi óo síi neeluwool faŋ eteyyo niŋ la nkakine la. ");
INSERT INTO krx_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Pamuusal eket ya eti Isaak, Jakob naatowo ti mah ma miti Kanaan la paapaa ateyoo mpaakin la samat nii akaawoola. ");
INSERT INTO krx_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ehe kiti miin ma miti Jakob, aŋa nkasok ya lompo Israyel. Josef akampaani ati sitiil kaat niŋ súsupak, naayeno efaas písaacii pa niŋ pifil pa, akina niŋ ñúnuwoo, epuuk Piluha niŋ epuuk Silupa, paapaa ateyoo pakaaloo. Nakaman paapaa ateyoo heenaput eeha ñúnuwoo nkáhine ha. ");
INSERT INTO krx_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israyel náalafi Josef pihaŋ pakakee epuukoo kamma naapukoo akina pamaamanal. Naamemanooloo hísool héeciita hinoom. ");
INSERT INTO krx_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ñúnuwoo nkacuk nii paapaa ateyii, Josef náalafiye pihaŋ poko púlooŋ. Nkanatoo, kayinaat káakup neyoo púsuum. ");
INSERT INTO krx_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Hikee hinoom, Josef náayawut naakaman éyawut ya ñúnuwoo, nkanatoo pihaŋ toko. ");
INSERT INTO krx_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ehe eeha naakamanii ha: “Nísiitan éyawut ya etoom: ");
INSERT INTO krx_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Uyenaayeno hicenku únuufaay uli ti hoos, tokotoko káanuufaay ka kutoom nkisiiŋo kupucoonool ciit, utaaluu wa núukiitool kutoom ka, núuñeem ko.” ");
INSERT INTO krx_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ñúnuwoo nkasokoo: “Fo aafayeno amansa ya atoonii niŋ ekina tom ati hikaw ha atoonii?” Nkahaŋ toko nkanatoo meemak kamma píyawut pa piteyoo niŋ kilim ka kiteyoo. ");
INSERT INTO krx_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Fiye nene ataak ekee éyawut naasok ñúnuwoo: “Nísiitan, nene taakaataak éyawut pale tempe caanak ca, hiim ha niŋ sicaaŋaŋ siyema ŋaasuwan niŋ yoonool siyeniyaam híñeemu.” ");
INSERT INTO krx_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Naakaman yo lompo paapaa ateyoo samat nii fa naakamane yo fa ñúnuwoo. Paapaa ateyoo naafet teyoo naasokoo: “Eyáwut puume uyyaaw? Fo inci, íññaa atii niŋ ñúnuwi éfuukey úkilipo hátikini ñuhooŋu unii t’etaam?” ");
INSERT INTO krx_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ñúnuwoo nkataak paheeka teyoo pale paapaa ateyoo naamank enkuu ti kunuuwoo. ");
INSERT INTO krx_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Hikee hinoom, ñúnuwoo nkakaay kaahoonan púlukuleen pa piti paapaa ateyii ti etaam ya eti Sikem. ");
INSERT INTO krx_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israyel naasok Josef: “Ñúnuwi kakaayaakaay efaas púlukuleen pa Sikem, kéy inci pupoñi teyii.” Josef naañahanoo: “Iyyoo.” ");
INSERT INTO krx_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Israyel nene asokoo: “Kaay aapicaasincan man ñúnuwi unka kásuumaayii niŋ pukoolee pa, íncoopiyam ekooŋan éefulii teyii.” Fiyuu Jakob naapoñoo ápufulii ti etaam ya eti Hepolon la nkakine la. Ta Josef naalohane ta Sikem, ");
INSERT INTO krx_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","akee áyiin naacukoo ti kaamuumuusool ti ukit wa naacakanoo: “Weyme ayyem ti hiŋes?” ");
INSERT INTO krx_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Naañahanoo: “Ñúnuwam inci iyyem ti hiŋes. Káluma, fo áafayiniyam hisoku pa nkayem ti kaahoonan púlukuleen pa?” ");
INSERT INTO krx_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ayíin a naañahanoo: “Káfulaaful le, síyiisi nkasok: 'Ukaayaa Totan.'” Fiye, Josef naanapan ñúnuwoo naatoopii pukol Totan. ");
INSERT INTO krx_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Pale ñúnuwoo kapiŋantanoo, le niŋ áfaacolii teyii, nkateŋenool kati kamukoo. ");
INSERT INTO krx_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Nkasokool: “Aha áyawuta ya ti ékey! ");
INSERT INTO krx_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Colaa toko, níkey upumukoo nuuwantoo ti ésaapun, nuusokaa nii élukuleen eekance eliyoo. Efuucukaa heekaakaay pitaako píyawut pa piteyoo.” ");
INSERT INTO krx_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruben náasiyii ti káakup náalafi kafakan Josef ti sipeesii naasokii: “Timpi umukoo.” ");
INSERT INTO krx_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Nene apenan: “Timpi uniisaa hísimoo, uwantoo ti ésaapun eyye ti káahaaŋ ke tes pale timpi unaŋaa sipees unaa teyoo.” Ruben asokaasok eehuu kati afakan Josef naañahanoo ti paapaa ateyoo. ");
INSERT INTO krx_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ta Josef náacolii ta teyii nkawaat hísool ha hiteyoo héeciita ha hinoom eeha naawasiye ha, ");
INSERT INTO krx_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","nkacoopoo nkawantoo ti ésaapun ya. Esáapun ya ñaanii eteyyo, etaakut man. ");
INSERT INTO krx_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Fiye nkayeno kati kali. Nkáhaafin nkaŋantan kayoŋ kiti pakati Ismayel kéefulii ti mah ma miti Kileyat nkayeno puwano Esipt. Puñonkomoo pa piteyii mpitiyo panoomanal pa piteyii: munkoc, caminkoloŋ niŋ munucu méesuume haaw. ");
INSERT INTO krx_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Fiye, Juda naasok ñúnuwoo niŋ pakatuwoo: “Weyme efuutaakaa nuumukaa atuwunaa nuuyolaa eket ya eteyoo? ");
INSERT INTO krx_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Unoomanoo pakati Ismayel paka payenke, pale timpi unaŋaa teyoo sipees unaa kaatuko atuwunaa, hísim unaa.” Nkacoon hilim ha hiti Juda. ");
INSERT INTO krx_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ta punoomana pa pakati Mitiyan nkácolii ta, Josef ñúnuwoo nkáfulaniyoo ti ésaapun ya nkanoomanoo sikoofali áwii. Pakati Ismayel paka nkacoopoo Esipt. ");
INSERT INTO krx_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ta Ruben náañohoonii ta ti ésaapun ya, naacuk nii Josef aneetaat toko, ínciitiyoo fo naahaace wañ wa uteyoo. ");
INSERT INTO krx_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Naañoho pati pakatuwoo naasokii: “Añii ya aneetaat toko, puume inci inkaakaay íhinu?” ");
INSERT INTO krx_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Fiye, nkataaŋ híceken efil nkápuuc hísool ha hiti Josef ti hísim ha. ");
INSERT INTO krx_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Nkacoop paapaa ateyii hísool ha héeciita ha hinoom nkasokoo: “Ulaŋanaalaŋan hísool eehe, káluma sincan man hiti añiini ha.” ");
INSERT INTO krx_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Jakob naasincan ho naasokii: “Hísool eehe hiti añiinam! Elúkuleen eekance etaatulooloo neeliyoo!” ");
INSERT INTO krx_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Incíitiyoo fo naahaace wañ wa uteyoo naawaso pupootak naakooŋ eket ya eti añiinoo hícump kunoom. ");
INSERT INTO krx_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Epuukoo pákayiin niŋ pakaal nkákey hiŋes kaapuuñanooloo pale, naapook apupuuñanoolee naasok: “Inci fakooŋ eket ya eti añiinam fo ta inci fatookoo t’etaam pati keekete ka.” Naatowo ti pukooŋ eket ya eti añiinoo. ");
INSERT INTO krx_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Tempo, po Esipt, punoomana pa pakati Mitiyan nkanooman Josef akee áyiin aŋa nkasok Potifal, áhampaatiin a ati pufaasa pa pakati amansa ya. ");
INSERT INTO krx_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ti oom caanak, Juda naakatan ñúnuwoo niŋ pakatuwoo naacaakin ti áyiin ati Atulam caacawoo Hila. ");
INSERT INTO krx_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Po, Juda naacuk ámaacul a ati Suwa éefulii Kanaan, naasayoo naahinto neyoo, ");
INSERT INTO krx_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","naasa munow naapukoo cikampaani. Juda naalu co caacaw ca El. ");
INSERT INTO krx_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nene asa mikee munow naapuk cikampaani, íññaa etenco naalu co caacaw ca Onan. ");
INSERT INTO krx_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Nene apuk cikampaani cíhaaciyenu naalu co caacaw ca Sela. Ta cikampaani encuu incipukee ta, Juda ti saatee ya eti Kesip. ");
INSERT INTO krx_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Juda añiinoo áyaañ a El, ta náayankii ta, naaŋesoo aal caacawoo Tamal. ");
INSERT INTO krx_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Pale El, Juda añiinoo áyaañ a, ti Ateeteyo anaput, naamukoo. ");
INSERT INTO krx_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Fiye Juda naasok Onan: “Ti cosaan ya etuunaa, aañaŋaa hitoonu púnuwi aaloo aakati taak neyoo epuuk pakateyoo.” ");
INSERT INTO krx_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Pale Onan náameyi nii epuuk ya payenka naakaakaay ka hitaaku etikayeno pakateyoo pale pakati púnuwoo. Fiye, niŋ ahintiyaa niŋ aal a naaniis man ma miteyoo t’etaam eeha efihiwun aal a atasa munow naataak añii púnuwoo. ");
INSERT INTO krx_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Eeha náhin ha, ti Ateeteyo heenaput. Fiye, naamukoo lompo. ");
INSERT INTO krx_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Juda naasok Tamal añiinoo eekete ya aaloo: “Caayeno eyaaŋat aŋa áyiinoo eekete ti enuuf faafi fo ta añiinam Sela áfaayankii.” Kaatuko afeyaafe Sela timpi aket lompo samat nii ñúnuwoo. Fiye Tamal naakaayeno ti enuuf faafoo. ");
INSERT INTO krx_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Po hátikin, Suwa añiinoo ámaacul, Juda aaloo, naaket. Ta naapayoo ta pukooŋ naasilo Timina niŋ áwiyoo Hila ati Atulam apicaasincan payenka nkayiin ka pahan písaacii pa piteyoo. ");
INSERT INTO krx_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ta nkasoke ta Tamal nii, aasonoo áyiin oopa ti pikaayu Timina kaayiinu písaacii pa piteyoo, ");
INSERT INTO krx_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","naawaat wañ wa uti keeŋoot ka náawufaloolo niŋ kafonkoloŋ timpi akiiwee, naayeno ti putum saatee ya eti Enayim eeyem ya ti pítin pa piti Timina kaatuko acukaacuk nii Sela áyankiyooyank pale kawufanutoo apisayoo. ");
INSERT INTO krx_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Juda naacuk Tamal incukoo nii aal ahaañiya kaatuko áwufaloolaa-wúfalool puhooŋuyoo, ");
INSERT INTO krx_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ámiit nii añiinoo eekete ya aaloo. Fiye naalohoo naasokoo: “Káluma, inci láfilafi pihinto niŋ awe.” Tamal naañahanoo: “Weyme aafawufanam?” ");
INSERT INTO krx_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Juda naasokoo: “Inci fápoñiyi cifil.” Naañahanoo: “Ufanam waah ewwa inci fásik tewwo; niŋ cícoliyoo, inci iññahani wo.” ");
INSERT INTO krx_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Naacakanoo: “Weyme állafiye puwufani?” Aal a naasokoo: “Ekop ya etii eetaake ya lánkamaasi eeyem ya ti nimmaan na nitii, niŋ hikasap ha hitii eeha ánsik ha ti epeesi.” Naawufanoo wañ ewwuu naahinto neyoo naasa munow. ");
INSERT INTO krx_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamal naayet pateyoo náafulan kafonkoloŋ ka enka náawufaloole ka puhooŋuyoo, naawaso nene wañ wa uteyoo uti keeŋoot ka. ");
INSERT INTO krx_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Juda naapoñ áwiyoo ati Atulam apucoop cifil enca náayinanane ca aal a, kati ácoopooliyoo wañ wa uteyoo ewwa naawufanoo wa. Pale áwiyoo acukut aal a. ");
INSERT INTO krx_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Naacakan pakati Enayim: “Aal a ahaañiya ya, aŋa nayeno ya ti pítin pa piti Enayim, peyme naayem?” Nkañahanoo: “Le taapala taak aal ahaañiya.” ");
INSERT INTO krx_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Fiye, Juda áwiyoo naañoho naasokoo: “Cukut aal a, apan pakati saatee ya kasok aal ahaañiya ataapala ataako toko.” ");
INSERT INTO krx_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Juda naañahan áwiyoo Hila: “Iyyoo, amank wañ wa weeyem wa teyoo timpi maasuuwaa, inci poñoopoñ cifil ca pale aacukutoo.” ");
INSERT INTO krx_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Kiim káhaaciil kupumuus nkákey kapusok Juda: “Tamal, añiini eekete ya aaloo nihaañiya, oopa niŋ munow.” Juda naañahanii: “Nífulaniyoo tíkitaaŋ innisowoo kaloŋa!” ");
INSERT INTO krx_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ta nkayeniyoo ta éfulanii tíkitaaŋ, naapoñ an ti aasonoo Juda naasokoo: “Sincan ekop eyye niŋ nimmaan eteyyo, niŋ hikasap eehe. Ati wañ ewwe awasaam munow. Sincan man áafameyi ateetewwo.” ");
INSERT INTO krx_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Juda naakiiw wo naasok: “Ahaŋaam piyeno eecoonoole. Añiinam Sela añaŋoo esa pale hínut ho.” Juda nene ahintiit neyoo púlay. ");
INSERT INTO krx_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ta naañaŋe ta hipuku nkápannum nii Tamal máasupak áfaapukii. ");
INSERT INTO krx_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ta íyyiŋooliyoo ta, oonool ti epuuk ya náafulanii epeesoo, aloŋana ya naacenk nípin néecunke ti epees añii ya naasok: “Aŋe áyaañe áfulii.” ");
INSERT INTO krx_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Pale añii ya naañahan epeesoo, atuwoo náayaañ áfulii. Aloŋana ya naasok: “Pítin puume awwañale!” Fiye, Juda naalu añii ya caacaw ca Peles (ekina eyem “kawañal”). ");
INSERT INTO krx_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Púful toko akee ya náafulii niŋ nípin na néecunke na ti epeesoo, Juda naaluwoo caacaw ca Serah (ekina eyem “páfuliyal caanak”). ");
INSERT INTO krx_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Pakati Ismayel keecoope ka JosefEsipt nkanoomanoo an ati Esipt aŋa nkasok Potifal. Ayíin a aŋuu áhampaatiin a ati pufaasa pa pakati amansa ya. ");
INSERT INTO krx_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ateeteyo naayeno niŋ Josef, waah óo waah ewwa náhin nuunap. Josef naakin ti ekumpaan ya eti áhampaatiin a ateyoo ati Esipt a. ");
INSERT INTO krx_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potifal naacuk nii Ateeteyo oopa niŋ Josef. Ateeteyo náahin waah óo waah ewwa Josef náhin upunap. ");
INSERT INTO krx_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Fiye, Potifal ínsuumoo ti Josef naacoopoo páhin piti eniinoo. Naañomanoo híhampaatiinate ha hiti páhin ekumpaan ya eteyoo niŋ waah óo waah ewwa naataake. ");
INSERT INTO krx_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Emma náahine ma eehuu, Ateeteyo naasampan waahoo púlooŋ kamma Josef. Kaasampan ka kiti Ateeteyo nkiyeno ti waah óo waah, uti ekumpaan ya eteyoo niŋ uti ukit wa uteyoo. ");
INSERT INTO krx_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potifal naakat ti sipees Josef waah óo waah ewwa naataake. Apaaliyantoo waah niŋ fúlaa paliyal pa piteyoo. Josef ecuumaka náasuum kaasincan. ");
INSERT INTO krx_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ekina ewune, aal a ati áhampaatiin a ateyoo, kunuuwoo nkiyeno teyoo. Hikee hinoom, naasokoo: “Hinto niŋ inci!” ");
INSERT INTO krx_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Pale Josef naapook, naasok aal a ati áhampaatiin a ateyoo: “Haani! Emma inci iyyem ma le, áhampaatiin a atoom apaaliyantoo waah ti ekumpaan ya eteyoo. Naañomanam waah óo waah ewwa naataake. ");
INSERT INTO krx_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ti ekumpaan eyye, háati áyiini ahaŋutam fala sempe, akitutam waah niŋ fúlaa hílikuyi kamma ayyem aaloo. Fiye, puume inci fáyini íhinu hítaapanu eehuu immuuyen ti Pútuun pa?” ");
INSERT INTO krx_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Hinak óo hinak Potifal aaloo nanapan Josef pale naapook pihinto neyoo, háati hikoluyoo fala. ");
INSERT INTO krx_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Hikee hinoom, Josef naanako ti ekumpaan ya kati áhin páhin pa piteyoo, inhemool háati áhina oonool ayeniit toko. ");
INSERT INTO krx_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Aal a ati Potifal naacokoo ti hísool naasokoo: “Kéy hinto niŋ inci!” Pale Josef naatah hísool ha hiteyoo ti sipees aal a naatey tíkitaaŋ. ");
INSERT INTO krx_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ta aal a naacuke ta nii Josef ateyaatey naatah hísool ha hiteyoo ti sipeesoo, ");
INSERT INTO krx_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","naaceek apiyonkal pákayiin paka keeyem ka ti páhin ti ekumpaan ya eteyoo naasokii: “Nisincan! Ahiburu aŋa áyiinam náacoopii ya, álafilafi pahaaño niŋ unaa. Akéyyookey ápilafi pihinto niŋ inci pale inceek. ");
INSERT INTO krx_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Emma náasiyaam ma ti hiceeku, naatey tíkitaaŋ naatah le hísool ha hiteyoo pukolam.” ");
INSERT INTO krx_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Naayenan hísool ha hiti Josef pukoloo fo ta áyiinoo náañohoonii. ");
INSERT INTO krx_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ta náañohoonii ta, naakamanoo hoonool huu nii: “Amiikan a Ahiburu ya aŋa áncoopii ya álafiye pahaaño niŋ inci. ");
INSERT INTO krx_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Pale emma inci inceeke ma, naatey tíkitaaŋ naatah le hísool ha hiteyoo pukolam.” ");
INSERT INTO krx_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ta áhampaatiin a ateyoo náasiye ta eeha aaloo naasoke ha kiti Josef náañiken meemak. ");
INSERT INTO krx_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Naapoñ kapucok Josef naakuloo ti núkuluma la nkakul la keecokee ka pakati amansa ya. Ta naayeniye ta ti núkuluma, ");
INSERT INTO krx_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ateeteyo naayeno neyoo, náayisanoo panap pa piteyoo, náahin áhampaatiin a ati ékuluma ya apihinto Josef. ");
INSERT INTO krx_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ahámpaatiin a ati ékuluma ya naañoman Josef híhampaatiinate ha hiti keekulee ka púlooŋ niŋ waah óo waah ewwa núuhinee toko. ");
INSERT INTO krx_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Fiye, apaaliit waah óo waah ewwa naañomane Josef kaatuko Ateeteyo ayenaayeno neyoo, náahin waah óo waah ewwa Josef náhin upunap. ");
INSERT INTO krx_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Po hátikin, afeŋa elaan ya niŋ asowa kúmpuul ka pakati amansa ya ati Esipt nkamuuyen ti áhampaatiin a ateyii, amansa ya ati Esipt. ");
INSERT INTO krx_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Amansa ya náañiken ti poko t’ésupakii, ati hikaw ha ati pifeŋa elaan ya niŋ ati hikaw ha ati pusowa kúmpuul ka, ");
INSERT INTO krx_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","naakulii lati ekumpaan ya eti áhampaatiin a ati pufaasa pa pakateyoo, ti ékuluma yoonool la Josef naakulee la. ");
INSERT INTO krx_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ahámpaatiin a ati pufaasa pa naañomanii Josef, apiyeno áhina ya ateyii. Ta nkakampane ta ti ékuluma ya, ");
INSERT INTO krx_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","an óo an ti poko t’ésupakii, afeŋa elaan ya niŋ asowa kúmpuul ka pakati amansa ya ati Esipt, keemankee ka ti ékuluma ya, nkáyawut ti hánant ha hoonool ha, éyawut óo éyawut niŋ hikaw eteyyo. ");
INSERT INTO krx_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Eti kacom eteyyo mpucom Josef náakey teyii, naacukii nkamone. ");
INSERT INTO krx_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Naacakanii: “Weyme ñuhooŋu aluu íññinime fiyaaw fíyooy?” ");
INSERT INTO krx_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Nkañahanoo: “Unii t’ésupak unii úyawute pale an aneetaat le aŋa áfaacenkin po unii.” Fiye Josef naasokii: “Fo káacenkin píyawut ti sipees Pútuun pa tom naayem? Káluma, nikamanam píyawut pa pitaaluu.” ");
INSERT INTO krx_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Fiye, ati hikaw ha ati pifeŋa elaan ya naakaman Josef éyawut ya eteyoo. Naasokoo: “Ti éyawut ya etoom incuk nikenenk hátikinam. ");
INSERT INTO krx_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ti nikenenk ennuu, intaak unaay úhaaciil. Emma núuluufeene ma, páluufeenal pa mpípankino ínnipukii úsis kikenenk keeyane. ");
INSERT INTO krx_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Elontoŋ ya eti amansa ya neeyeno ti epeesam, incoop kikenenk ka unfuncan ko ti elontoŋ ya uwwufanoo yo ti epees.” ");
INSERT INTO krx_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Josef naasokoo: “Ehe hikaw ha hiti éyawut ya etii: unaay wa úhaaciil wa uyem kunoom káhaaciil. ");
INSERT INTO krx_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Le niŋ kunoom káhaaciil amansa ya áfaafulani ti ékuluma naañahani ti páhin pa pitii, aafaneewufan amansa ya elontoŋ ya eteyoo ti epeesoo samat nii fa ánhin fa ta ayyeniye ta afeŋa elaan ya ateyoo. ");
INSERT INTO krx_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Pale naayeniyaa ti pásuuma, káluma náwuniyam, ínhinam heenape aapusok amansa ya kutoom ínfulanam ti ékuluma eyye. ");
INSERT INTO krx_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kaatuko inci ti sempe nkáfulaniyaam ti mah ma miti Pihiburu pa, háati le inci hínut waah ewwa efuuwun inkulee.” ");
INSERT INTO krx_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ta ati hikaw ha ati pusowa kúmpuul ka naacuke ta nii Josef ácenkinaa-cénkin éyawut ya ti hisoku nii éesuume, naasokoo: “Inci lompo yáwutaayawut, áameyimeyi weyme inci incuke? Síyya síhaaciil siti kúmpuul siyeniye ti hikawam. ");
INSERT INTO krx_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ti íyya ya eeyeniye ya patiila intaak kúmpuul óo kúmpuul kiti amansa ya, pale pusuwa pa mpiyeno ko hili ti íyya ya eeyeniye ya ti hikawam.” ");
INSERT INTO krx_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Josef naasokoo: “Ehe hikaw ha hiti éyawut ya etii: síyya sa síhaaciil sa siyem kunoom káhaaciil. ");
INSERT INTO krx_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Le niŋ kunoom káhaaciil amansa ya áfaafulani ti ékuluma naafiit hikawi, eniini neewaŋee ti enuun. Pusuwa pa mpíkey yo hili.” ");
INSERT INTO krx_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Fiye, hinoom ha híhaaciyenu ha hiyeniye hinoom eeha amansa ya naapukee ha teeho, náahin pahaaño náayonkalii ñíhampaatiin ña púlooŋ pakati píhina pa pakateyoo. Loho poko púlooŋ kaconcooliyaa, amansa ya náayonkalii ati hikaw ha ati pifeŋa elaan ya niŋ ati hikaw ha ati pusowa kúmpuul ka hátikin píhina pa pakateyoo. ");
INSERT INTO krx_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Naañahan ati hikaw ha ati pifeŋa elaan ya ti páhin pa piteyoo, ancuk kati nene nawufan elontoŋ ya ti epees amansa ya. ");
INSERT INTO krx_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Fiye, naasok nii, ati hikaw ha ati pusowa kúmpuul ka awaŋee, samat nii fa Josef náacenkinii fa. ");
INSERT INTO krx_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Pale ati hikaw ha ati pifeŋa elaan ya, ánawuniit Josef, naafiiloo. ");
INSERT INTO krx_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Sitiil súsupak sipimuus, amansa ya ati Esipt náayawut. Ti éyawut ya naasiiŋo pukol han ha hiti Nil. ");
INSERT INTO krx_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Naacuk síis isak niŋ súsupak seewalla insiluuk ínsifulii ti han ha hiti Nil, insiyeno toko kaahoon haasuwa. ");
INSERT INTO krx_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Intaako sikee síis siyema isak niŋ súsupak seeŋoota insicecat séefulii ti han ha hiti Nil puson seewalla sa, insisiiŋo ti kantant han ha pukol etenso. ");
INSERT INTO krx_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Fiye, síis sa seeŋoota sa seececate sa insili síis sa isak niŋ súsupak sa seewalla sa seeluuke sa. Toko amansa ya náayiyiye. ");
INSERT INTO krx_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Naañoho ti hiŋotu náayawut púsupiyenu. Naacuk ulant isak niŋ úsupak uti uli weewalla nuufom wéeheecalii ti kaalat koonool. ");
INSERT INTO krx_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Púful toko nantoonool nuu, naacuk lompo ulant isak niŋ úsupak weesuuce ewwa eyam éefulii ti káahaaŋ tes neesowe. Uŋántiyooŋant loho weewalla wa upayaa éŋantii. ");
INSERT INTO krx_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Fiye, ulant wa weesuuce wa nuumelan ulant wa weewalla wa weefome wa. Toko amansa ya náayiyiye náapannum nii éyawut naayeniye. ");
INSERT INTO krx_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Cipilap, amansa ya naaliim náayonkalii pisincana pa púlooŋ niŋ ñíhampaatiin ña púlooŋ keetaake ka ecuku pakati Esipt. Ta nkácolii ta, naakamanii píyawut pa piteyoo pale an teyii ayinaatoo po káacenkin. ");
INSERT INTO krx_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ti pikelan, ati hikaw ha ati pifeŋa elaan ya ati amansa ya ati Esipt naasokoo: “Amansa yuu, fíyooy inci náwuniyaa kaamuuyen ka kutoom. ");
INSERT INTO krx_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Hikee hinoom, awe amansa ya áññikene ti unii píhina pa pakatii, inci niŋ ati hikaw ha ati pusowa kúmpuul ka. Inkul unii ti ékuluma ya eti áhampaatiin a ati pufaasa pa pakatii. ");
INSERT INTO krx_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Unii t’ésupak unii núuyawut ti hánant ha hoonool ha, an óo an toonii niŋ éyawutoo niŋ hikaw eteyyo. ");
INSERT INTO krx_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ti ékuluma ya intaako kikee kahiineen Ahiburu, amiikan ati áhampaatiin a ati pufaasa pa. Nuukamanoo píyawut pa putoonii, náacenkin an óo an toonii éyawut ya eteyoo. ");
INSERT INTO krx_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Intaako samat nii fa naasoke fa: inci, aññahanam páhin pa putoom; ati hikaw ha ati pusowa kúmpuul ka naamukee naawaŋee.” ");
INSERT INTO krx_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Fiye, amansa ya naapoñ kápucoopiyoo Josef. Nkáfulaniyoo ti ékuluma ya mpacas, nkayiin pasenfoo niŋ hikawoo, náasoolo ukee wañ, naakaay piyiiŋo amansa ya. ");
INSERT INTO krx_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Amansa ya naasok Josef: “Yáwutaayawut pale an ayinaatam yo káacenkin. Fiye ínsi nii, naakamanee éyawut áyyiniyini yo káacenkin.” ");
INSERT INTO krx_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Josef naañahan amansa ya: “Inci tom, pale Pútuun pa piyinuu kawufan káacenkin kéesuume.” ");
INSERT INTO krx_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Amansa ya naasokoo: “Ehe éyawut ya etoom: pukol kantant ka kiti han ha hiti Nil inci insiiŋiye, ");
INSERT INTO krx_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","incuk síis siyema isak niŋ súsupak seewalla insiluuk. Insífulii ti han ha sipiyeno toko kaahoon haasuwa. ");
INSERT INTO krx_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Nantoonool nuu incuk sikee síis siyema isak niŋ súsupak seeŋoota ínsikuuh insicecat séefulii ti han ha puson seewalla sa. Inci taapala cuk oom síis seeŋoota ti mah ma miti Esipt púlooŋ. ");
INSERT INTO krx_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Fiye, síis sa seeŋoota sa insicecat insili síis sa síyaañ sa seeluuke sa. ");
INSERT INTO krx_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Pale sipipa so hili, incuk fiye nii siliit kamma insicecate samat nii kúcook kuu. Toko inci íyyiyiye. ");
INSERT INTO krx_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Púful toko nene yáwut, incuk ulant isak niŋ úsupak uti uli weewalla nuufom wéeheecalii ti kaalat koonool. ");
INSERT INTO krx_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Incuk lompo ulant isak niŋ úsupak weesolanut nuusuuc ewwa eyam éefulii ti káahaaŋ tes neesowe. Uŋántiyooŋant papayal hiŋantu weewalla wa. ");
INSERT INTO krx_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Fiye, ulant wa weesuuce wa nuumelan weenape wa. Píyawut empuu inci inkamane pisincana pa pale an ayinaatam po káacenkin.” ");
INSERT INTO krx_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Josef naañahan amansa ya ati Esipt: “Síyawut sa súsupak sa sitii soonool suu. Pútuun pa pusokuu eeha mpikaakaay ha íhinu. ");
INSERT INTO krx_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Síis sa isak niŋ súsupak sa seewalla sa síyisane sitiil isak niŋ súsupak; ulant wa isak ya niŋ úsupak wa weewalla wa lompo úyisane sitiil isak niŋ súsupak, ooto éyawut yoonool. ");
INSERT INTO krx_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Síis sa isak niŋ súsupak sa seeŋoota sa insicecat séenowii sa puson seewalla sa síyisane sitiil isak niŋ súsupak; ulant wa weeŋoota wa ewwa eyam ya éefulii ya ti káahaaŋ tes neesowe wa lompo úyisane sitiil isak niŋ súsupak, sitiil siti épankul. ");
INSERT INTO krx_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Amansa yuu, samat nii fa inci insokuu fa, Pútuun pa píyisanuuyisan eeha mpikaakaay ha íhinu. ");
INSERT INTO krx_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Sitiil sa isak niŋ súsupak sa seeyem sa ti ékey, kaamaañ ka efikinap meemak ti mah ma púlooŋ miti Esipt. ");
INSERT INTO krx_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Niŋ fúlaa toko, efitaak sikee sitiil isak niŋ súsupak siti épankul, umaañ wa weenape wa efuufiilee ti mah ma miti Esipt, épankul ya éfeepucalool mah ma. ");
INSERT INTO krx_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Epánkul ya éfeeciiti meemak neewun an átanawuno fala hitaaku ha eeha mpihitaako ha. ");
INSERT INTO krx_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Amansa yuu, páawoo Pútuun pa píyisanuuyisan éyawut ya fo ñiyema ñésupak, ooto heekaakaay ha pitaako, pipayoolaa-payool neeho, etipukuuteen ho ti íhinu. ");
INSERT INTO krx_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Fiye, amansa yuu, mamal an eetaake kunuu naacohato eekaakaay kaamankool mah ma miti Esipt. ");
INSERT INTO krx_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Amansa yuu, aañaŋaa kaasiiŋan ti mah ma pakati kikaw payenka efinkacoop ti pakan paka himpaac hoonool ti kimpaac isak. Kañaŋaa ho íhinu ti sitiil sa isak niŋ súsupak sa siti kaamaañ ka keenape ka. ");
INSERT INTO krx_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Kasayool paliyal pa púlooŋ piti sitiil ensuu seeyem sa ti ékey. Ti kayine enka ankaakaayii ka kawufan, kaconcenool paliyal pa ti ñileefaan ña ñiti amansa ya ñeeyem ña ti pisaatee pa nkafaas ño. ");
INSERT INTO krx_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Fiyuu mah ma miti Esipt efimitaak pamankal piti sitiil sa isak niŋ súsupak sa siti épankul ya, ancuk épankul ya étepucalool mah ma.” ");
INSERT INTO krx_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Hilim ha hiti Josef níhisuum amansa ya niŋ píhina pa pakateyoo púlooŋ. ");
INSERT INTO krx_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Fiye amansa ya naasok píhina pa pakateyoo: “Ayíin a aŋe oopa ameeŋe niŋ Kunuu ka kiti Pútuun pa. Fo efuutaakaa akee eecuke nii akina?” ");
INSERT INTO krx_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Púful toko amansa ya naasok Josef: “Páawoo Pútuun pa píyisanooluu eehuu púlooŋ, an átayini hitaaku kunuu naacohato samat nii awe. ");
INSERT INTO krx_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Aafayeno ati hikaw ha ati cáwii ca citoom, pakan paka pakati mah ma púlooŋ éfikatuul kilim ka kitii. Elemeyu ya etoom lamma efeewufanam kayine ti awe.” ");
INSERT INTO krx_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Fiye amansa ya naasok Josef: “Sincan, inci ufanuu kayine ti mah ma miti Esipt púlooŋ.” ");
INSERT INTO krx_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Amansa ya naawaat ekop ya eti himansate ha ti hisiikoo, naawas yo ti hisiik Josef, náasooloo wañ wéeciita hinoom naawasoo ti ekun keenoo eti sanoo. ");
INSERT INTO krx_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Púful toko náayuukoo ti saleet ya ésupiyenu ya eteyoo, pakan paka nkayeno hiceeku: “Nihaaso!” Fiyuu amansa ya ati Esipt naawufane Josef kayine ti mah ma miteyoo púlooŋ. ");
INSERT INTO krx_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Amansa ya naasok Josef: “Inci yem amansa ya ati Esipt pale ti mah ma púlooŋ an átaseepin epeesoo niŋ aawufanutoo oom kayine.” ");
INSERT INTO krx_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Eehuu hipimuus, amansa ya naalu Josef caacaw ca Safenat-Paneyah. Naawufanoo aal caacawoo Asenat ámaacul a ati Poti-Fela awaaseena ati saatee ya eti On. Josef naakaawool mah ma púlooŋ miti Esipt. ");
INSERT INTO krx_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Josef ti sitiiloo áwii niŋ ŋaasuwan (30) náayaañe páhin ti amansa ya ati Esipt. Naakatan amansa ya naakaay kaafiitanool mah ma. ");
INSERT INTO krx_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Samat nii fa Josef naasoke fa, etaam ya neepuk meemak fo sitiil isak niŋ súsupak. ");
INSERT INTO krx_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ti oom sitiil isak niŋ súsupak sa, Josef naaconcenool paliyal pa naamank po ti pisaatee pa. Ti saatee óo saatee naamank paliyal pa péefulii pa ti ukit wa wéekinkoolii wa. ");
INSERT INTO krx_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Fiye Josef naaconcenool paliyal peemeeŋe meeŋ, pimeeŋaameeŋ samat nii esiya ya eti kaatii ka. Ti pikelan, nkáyekuno kafinu etewwo kaatuko kayinoolaat. ");
INSERT INTO krx_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Etiil ya éyaañ ya eti épankul ya énakoonumii, Josef aaloo Asenat, ámaacul a ati Poti-Fela awaaseena ya ati saatee ya eti On, naapukoo epuuk pikampaani pákasupak. ");
INSERT INTO krx_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Josef naalu ácook a caacaw ca Manase (ekina eyem “kayankanan an apifiil”), kaatuko asok: “Pútuun pa piyankananaam-yankanan pifiil kúnuul ka kutoom púlooŋ niŋ píkatinool pa putoom niŋ miin ma mutoom.” ");
INSERT INTO krx_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Kahiineen ka, naalu ko caacaw ca Efreem (ekina eyem “íhinu an apupukool”), kaatuko asok: “Pútuun pa píhinaamhin pupukool ti mah emme miti kúnuul ka kutoom.” ");
INSERT INTO krx_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ti mah ma miti Esipt, sitiil sa isak niŋ súsupak sa siti hitaaku ha insipa. ");
INSERT INTO krx_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Fiye, sitiil sa isak niŋ súsupak sa siti épankul ya ínsiyaañ, samat nii fa Josef naasoke fa hínum. Epánkul neeyeno ti mikee mah ma púlooŋ kaatuko mitaakut paliyal, pale Esipt púlooŋ neetaak paliyal. ");
INSERT INTO krx_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ta épankul ya neeyeniye ta niŋ pakati Esipt púlooŋ, nkakaay pati amansa ya kaluum paliyal. Pale amansa ya naañahanii: “Nikaay pati Josef ínnihin eeha afaasok ha aluu.” ");
INSERT INTO krx_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ta épankul ya neeyeniye ta ti mah ma púlooŋ, Josef náapankin ñileefaan ña kati anooman pakati Esipt. Kaatuko épankul ya etaakaataak sempe ti mah ma púlooŋ miti Esipt. ");
INSERT INTO krx_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Pakan paka nkáfulii ti mikee mah ma púlooŋ kápinkakey Esipt hinoom paliyal ti Josef kamma épankul ya neeseeñe ti púlunta pa púlooŋ. ");
INSERT INTO krx_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Fiye, Jakob náasi nii paliyal umpa Esipt. Naasok epuukoo: “Weyme inniyeniye nípisincanool-síncanool? ");
INSERT INTO krx_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Síyaasi nii taakaataak paliyal Esipt. Niwano po hinoom paliyal ancuk uloŋaa timpi uketaa kamma peep.” ");
INSERT INTO krx_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Josef ñúnuwoo, ŋaasuwan ya, nkawano Esipt hinoom paliyal. ");
INSERT INTO krx_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Pale Benjamin, Josef atuwoo, Jakob akatanutoo apinapool niŋ ñúnuwoo; asok afeyaafe heenaput hipitaakiyoo. ");
INSERT INTO krx_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Fiyuu epuuk Jakob, aŋa nkasok ya Israyel, nkananfe lompo ti kéekeyii ka hinoom paliyal Esipt, kaatuko épankul ya eyenaayeno ti mah ma miti Kanaan. ");
INSERT INTO krx_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Tempo, Josef ayeniye ati hikaw ha ati Esipt, naasiiŋo lompo ti kaanooman ka kiti paliyal pa piti pakan paka púlooŋ pakati mah ma. Josef ñúnuwoo nkácolii, nkákilipo hátikinoo ñuhooŋuyii t’etaam. ");
INSERT INTO krx_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Emma Josef naacuke ma ñúnuwoo naakiiwii pale áyisanooliit teyii akina ayem ayme, náakup neyii niŋ hilim heeyanke naasokii: “Peyme ínnifulii?” Nkañahanoo: “Ti mah ma miti Kanaan núufulii núukey le hinoom paliyal.” ");
INSERT INTO krx_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Josef naakiiw ñúnuwoo pale poko kakiiwutoo. ");
INSERT INTO krx_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Náanawuno píyawut empa náayawute pa kiteyii. Naasokii: “Aluu mikelecoola! Níkeyyookey le hiŋes leyme mah ma ímmilakume inniñoho nipica nikaman pakataaluu.” ");
INSERT INTO krx_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Nkañahanoo: “Haani áhampaatiinuu, unii pimiikan pa pakatii, hinoom paliyal núukeyii. ");
INSERT INTO krx_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Unii púlooŋ pakati faaf oonool, pakan keecoonoole, uneetaat mikelecoola.” ");
INSERT INTO krx_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Josef naasokii: “Páni tom! Níkeyyookey hiŋes leyme mah ma ímmilakume.” ");
INSERT INTO krx_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Nkañahanoo: “Unii pimiikan pa pakatii, uyema hínum ŋaasuwan niŋ pákasupak, pikampaani pakati faaf oonool, áyiin eekine ti mah ma miti Kanaan. Kahiineen ka unka po niŋ paapaa atoonii, intaako oonool éecime.” ");
INSERT INTO krx_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Josef naasokii: “Samat nii fa inci insoke fa aluu, aluu mikelecoola. ");
INSERT INTO krx_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ehe fa inci inkaakaay fa kameye man páni inniyem ti hisoku: inci pisintoolo ti eloŋ ya eti amansa ya ati Esipt, étiniful le ti mah emme taamanta kahiineen ka kitaaluu kúcoliyoot. ");
INSERT INTO krx_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Nipoñ akee ti aluu ápikaacoopiyoo, aluu keetowiye ka innimankee ti ékuluma. Fiyuu inci fámeyi man páni inniyem ti hisoku. Inci pisintoolo ti eloŋ ya eti amansa ya ati Esipt, niŋ atuwaluu ácoliyoot ooto aluu mikelecoola!” ");
INSERT INTO krx_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Fiye, naamankii poko púlooŋ ti ékuluma fo kunoom káhaaciil. ");
INSERT INTO krx_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ti hinoom ha híhaaciyenu ha Josef naasokii: “Niŋ níhinaa eeha inci inkaakaay ha aluu hisoku efiniloŋ, kaatuko inci eefeye Pútuun. ");
INSERT INTO krx_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Niŋ aluu keecoonoole, nicoon akee taaluu aputowo ti ékuluma, pakakee paka nkacoop paliyal pa miin ma mitaaluu meeyem ma niŋ peep. ");
INSERT INTO krx_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Pale, fo nícoopiyam kahiineen ka kitaaluu. Fiyuu inci fámeyi man páni inniyem ti hisoku, etiniket.” Nkacoon eeha Josef naasoke ha. ");
INSERT INTO krx_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Nkasokool: “Páni unaa usiiŋanee-siiŋan ti pisiya kamma eeha núuhinaa ha atuwunaa Josef. Ucukoocuk fa naaliime fa naaluum unaa uputaakaa paket hikaw teyoo, upaaliitoo. Ekina ewune kúnuul enke nkitaako unaa.” ");
INSERT INTO krx_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben naañahanii: “Inci sokaasok aluu timpi níhin heenaput añii aŋuu pale nipaaliitam. Fiye usiiŋanee ti pisiya kamma nuumukoo.” ");
INSERT INTO krx_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Kápannumut nii Josef ásiyaasi eeha nkayem ha ti hisoku, kaatuko ataakaataak ayesanoola kilim. ");
INSERT INTO krx_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Fiye, náalaaŋii apiyeno pukooŋ. Púful toko naañoho pati ñúnuwoo naasokii nii acokaa Simeyon. Nkacenkoo hátikinii. ");
INSERT INTO krx_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Josef naawufan hilim píhina pa pakateyoo kapimeeŋan paliyal pupootak pa piteyii, nkañahan an óo an mañ ma miteyoo ti epootak ya eteyoo. Nkawufanii lompo paliyal piti kaakaawool ka kiteyii. Píhina pa nkáhin ho. ");
INSERT INTO krx_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Josef ñúnuwoo nkanaŋ pupootak pa piti paliyal pa ti púfali pa piteyii, nkakaay. ");
INSERT INTO krx_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ta incicoke ta, nkasiiŋo kati kaŋot, akee teyii náapankin epootak ya eteyoo kati awun pahoonal fáli ya eteyoo naacuk mañ ma ti putum epootak ya. ");
INSERT INTO krx_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Naasok pákawiyoo: “Kañahanaam-ñahan mañ ma mutoom. Ehee mo ti epootak ya!” Poko púlooŋ saanii insiñak nkayeno kakikilan. Nkasokool: “Weyme Pútuun pa mpíhine unaa fiye?” ");
INSERT INTO krx_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ta nkacole ta Kanaan ti paapaa ateyii Jakob, nkakamanoo heetaakiyii ha púlooŋ, nkasokoo: ");
INSERT INTO krx_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Ahámpaatiin a ati mah ma ákupaakup niŋ unii niŋ hilim heeyanke. Naanook unii apusok nii unii mikelecoola. ");
INSERT INTO krx_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Nuuñahanoo: 'Unii mikelecoola tom pale pakan keecoonoole. ");
INSERT INTO krx_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Unii hínum pákayiin ŋaasuwan niŋ pákasupak, faaf unii oonool. Pale oonool toonii náacim, kahiineen ka nkutowo niŋ paapaa atoonii ti mah ma miti Kanaan.' ");
INSERT INTO krx_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ahámpaatiin a ati mah ma naañahan unii: 'Ehe fa inci inkaakaay fa kameye man páni inniyem ti hisoku: nikat le ti inci akee taaluu, pakakee paka nkacoop paliyal miin ma mitaaluu meeyem ma niŋ peep. ");
INSERT INTO krx_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Niŋ fúlaa toko ínnicoopiyam kahiineen ka kitaaluu. Fiyuu inci fámeyi nii aluu mikelecoola tom pale pakan keecoonoole, iññahan aluu áwi aluu, inkatan aluu nipinoom ti mah ma.'” ");
INSERT INTO krx_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Púful toko nkánuŋ pupootak pa piteyii, an óo an naacuk éwasuma mañ niŋ mañ ma miteyoo. Poko niŋ paapaa ateyii, ta nkacuke ta mañ ma nkafe. ");
INSERT INTO krx_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Paapaa ateyii Jakob naasokii: “Nikitaam epuukam! Josef aneetaat, Simeyon lompo aneetaat. Fiye, ínnilafi hicoopu Benjamin? Eehuu púlooŋ ti inci níhinowii!” ");
INSERT INTO krx_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Fiye Ruben naasokoo: “Niŋ inci ñáhaniyoot Benjamin, áyyini immuk pikampaani pa pakatoom pákasupak paka. Ñomanamoo inci fáñahaniyoo.” ");
INSERT INTO krx_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Jakob naañahanoo: “Haani, añiinam atawano niŋ aluu Esipt. Púnuwoo aketaaket, akina lamayoo kóŋ atowiye. Niŋ waah utaakiyoo ti kaakaawool ka kitaaluu, inci faket niŋ kúnuul pamaamanal.” ");
INSERT INTO krx_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Epánkul ya neeloŋ neeseeñe ti mah ma miti Kanaan. ");
INSERT INTO krx_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Miin ma miti Jakob immipa hili paliyal pa péefulii pa Esipt. Fiye, Jakob naasok epuukoo: “Niñoho Esipt nípinoomii unaa paliyal.” ");
INSERT INTO krx_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Juda naañahanoo: “Ahámpaatiin a ati Esipt asokaasok unii picaaŋ cataŋ: 'Inci etiwanan aluu niŋ atuwaluu aneetaat niŋ aluu.' ");
INSERT INTO krx_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Naacoonaa hipoñu unii niŋ Benjamin, efuuwano Esipt hinoom paliyal. ");
INSERT INTO krx_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Pale niŋ aapookaa etuukaay kaatuko áhampaatiin a asokaasok unii: 'Inci etiwanan aluu niŋ atuwaluu aneetaat niŋ aluu.'” ");
INSERT INTO krx_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Jakob, aŋa nkasok ya lompo Israyel, naasokii: “Weyme uwune innisok áyiin a aŋuu nii nitaakaataak atu? Niwasaam kúnuul.” ");
INSERT INTO krx_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Nkañahanoo: “Ayíin a acakanoolaa-cakanool unii meemak kutoonii niŋ miin ma mutoonii. Naacakan unii: 'Fo paapaa ataaluu oopa kaloŋa fo fiye? Fo nitaakaataak akee atu?' Uñahanooñahan pacakanal pa piteyoo lamma. Puume éfuumeyi nii afaasok unii: 'Nícoopii atuwaluu'?” ");
INSERT INTO krx_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Juda naasokoo: “Paapaa, katan Benjamin apinapool niŋ inci, nuuñak toko fiye. Uñaŋaa pikaayu niŋ úlafiyaa eloŋ, unii, awe niŋ epuuk unii, úlafiit eket. ");
INSERT INTO krx_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Naŋaa eloŋam, inci aafacakanool kiteyoo. Niŋ inci ñóhooniyoot neyoo insiiŋanoo hátikini, inci fatiyo kaamuuyen enkuu eloŋam púlooŋ. ");
INSERT INTO krx_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Antúŋ niŋ uloŋut le fo fiye, anti ukaay fo ñésupak Esipt núuñohoonii.” ");
INSERT INTO krx_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Paapaa ateyii Israyel naasokii: “Fiye míit puume inci inkaakaay íhinu. Ehe eeha innikaakaay ha íhinu: nicoopool ti pupootak pa pitaaluu waah weenape uti mah emme kati niwun wo ati Esipt a: munucu méesuume haaw, múkum, caminkoloŋ, pukoon pistas niŋ pisenket. ");
INSERT INTO krx_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Niñahan mañ emma innitooke ma ti pupootak pa pitaaluu, pikee pa an anakanoole apuwas mo toko. Nicoopool lompo mikee mañ miti hinoom paliyal. ");
INSERT INTO krx_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Fiye nikaay mpacas niŋ Benjamin pati áyiin a. ");
INSERT INTO krx_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Alímaati Pútuun pa piti sempe sa púlooŋ pílik yaanoo kati ataak paket hikaw ti aluu, naakatan Simeyon niŋ Benjamin kápuñohoonii. Niŋ inci fápuul ti epuukam, ímpuul teyii.” ");
INSERT INTO krx_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ta nkapaye ta káakup, nkamemanool aŋa nkañaŋe ya kawun áhampaatiin a nkacoopool mañ emma nkácoopoolii ma ti pítinii píyaañ pa, nkacoopool lompo mikee mañ miti hinoom paliyal. Púful toko, nkawano Esipt niŋ Benjamin, nkacol pati Josef. ");
INSERT INTO krx_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ta Josef naacuke ta nii Benjamin oopa neyii, naayonkal áhampaatiin a ati píhina pa pakati ekumpaan ya eteyoo naasokoo: “Coop payenkuu lati inci. Poñ kapumuk élukuleen immemanool yo kati kali kawaay niŋ inci.” ");
INSERT INTO krx_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ayíin a náahin eeha Josef naasokoo ha, naacoop pákayiin paka lati ekumpaan ya eti Josef. ");
INSERT INTO krx_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ta nkasokii ta kanako ti ekumpaan ya eti Josef, nkafe. Nkasokool: “Mañ ma meewasee ma ti pupootak pa putuunaa ti kaakaawool ka kúcook ka muwune kati kacok unaa, nkakallan unaa, nkacoop púfali pa putuunaa, nkáhin unaa pimiikan.” ");
INSERT INTO krx_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ta nkañaŋe ta pinako, nkaloh áhampaatiin a ati píhina pa pakati ekumpaan ya eti Josef nkasokoo: ");
INSERT INTO krx_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Ponket, áhampaatiin, unii mpúukeyyookey le hinoom paliyal. ");
INSERT INTO krx_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Upuyeno piyetu, incicok nuusiiŋo kati uŋot, núupankin pupootak pa putoonii an óo an naatook ti putum epootak ya eteyoo soŋ eyya naanoome ya paliyal pa. Fiye, núuñahanii mo. ");
INSERT INTO krx_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Núucoopoolii lompo mikee mañ miti hinoom nene paliyal. Umíit ayme awase mañ ma ti pupootak pa putoonii.” ");
INSERT INTO krx_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ayíin a naañahanii: “Níwaayeen timpi nife. Aŋuu Pútuun pa pitaaluu, Pútuun pa piti paapaa ataaluu, puwase hisaanumate eehuu ti pupootak pa pitaaluu. Mañ ma mitaaluu inci saye mo.” Púful toko náakatanii Simeyon, náacoopiyoo teyii. ");
INSERT INTO krx_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Pamuusal eehuu, naanakanii ti ekumpaan ya eti Josef, náacoopiyii man kapuñow wootii naawun púfali pa piteyii pahoonal. ");
INSERT INTO krx_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Nkáfulanii waah ewwa nkácoopoolii wa kati kawun Josef le niŋ pácolaliyoo hili kawaay, kaatuko kámeyimeyi nii neyoo nkakaakaay hili. ");
INSERT INTO krx_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ta Josef náacolii ta ti ekumpaan ya eteyoo, nkawufanoo kawun enka nkácoopiyoo ka, nkákilipo hátikinoo ñuhooŋuyii t’etaam. ");
INSERT INTO krx_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Naacakanii puume nkayem, naasokii: “Paapaa ataaluu eemaamane ya aŋa ínnikupaam ya kiteyoo, fo aloŋaa kaloŋa? Oopa kásuumaayoo?” ");
INSERT INTO krx_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Nkañahanoo: “Amiikan a atii, paapaa atoonii, aloŋaa kaloŋa, oopa kásuumaayoo.” Nene kákilipo ñuhooŋuyii t’etaam. ");
INSERT INTO krx_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Josef naacuk atuwoo Benjamin, íññaa ateyoo añiinoo, naacakanii: “Fo aŋe ayem kahiineen ka kitaaluu aŋa ínnikupaam ya kiteyoo?” Nkañahanoo: “Ee.” Naasok Benjamin: “Alímaati Pútuun pa piyeno niŋ awe añiinam.” ");
INSERT INTO krx_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Eehe nihinako Josef meemak ta naacuke ta atuwoo, naahiliikan apiŋes la afaaponko apukooŋ. Naanako lati ékaap ya eteyoo naakooŋ. ");
INSERT INTO krx_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ta naafatane ta, naañow puhooŋuyoo náafulii naacocokanoolo naasok: “Niwas kawaay ka.” ");
INSERT INTO krx_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Nkawasoo citeeteyoo, nkáwasii ñúnuwoo niŋ atuwoo citeeteyii, pakati Esipt kéeyonkaliyee ka hili nkawasee lompo citeeteyii kamma nkañaŋut hili niŋ Pihiburu pa, kaatuko meeñeya pakati Esipt kati kali neyii nantoonool. ");
INSERT INTO krx_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Josef ñúnuwoo niŋ atuwoo nkayenanee kapucoonool neyoo samat nii fa nkáfaloole fa, píyaañ ti áyaañ a fo ti kahiineen ka. Nkayeno písincanool, ínnimii meemak. ");
INSERT INTO krx_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Josef náahin kapitaakii ti paliyal pa peeyem pa hátikinoo nkawufanii. Pale epulaatu ya eti Benjamin ehaŋa pameeŋ fo ñiyema isak pupulaatu pa piti ñúnuwoo. Fiye, nkalaan neyoo fo kákuman. ");
INSERT INTO krx_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Púful toko Josef naawufan hilim áhampaatiin a ati píhina pa pakati ekumpaan ya eteyoo naasokoo: “Meeŋan pupootak pa piti pakan paka payenke niŋ paliyal, an óo an la naayina la pitiyo. Ñahan an óo an mañ ma miteyoo ti putum epootak ya eteyoo. ");
INSERT INTO krx_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ti putum epootak ya eti kahiineen ka, ñahan mañ etenko miti hinoom paliyal pa, uwwas lupo lompo elontoŋ ya etoom eti kótifoloo ya.” Ayíin a náahin eeha Josef naasokoo ha. ");
INSERT INTO krx_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Eti kacom eteyyo nuulap, nkakatan epuuk Jakob kapikaay niŋ púfali pa piteyii. ");
INSERT INTO krx_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Nkáful ti saatee ya, pale kálaaŋanut meemak. Fiye, Josef naasok áhampaatiin a ati píhina pa pakati ekumpaan ya eteyoo: “Toopanool pakan paka payenkuu incakanii: 'Weyme uwune inniñahan heenaput ti éehine aluu heenape? ");
INSERT INTO krx_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Nílipaalip elontoŋ ya eti áhampaatiin a atoom la nalaan la, toko lompo innasincan heekaakaay ha ékey. Eeha ínnihine ha hinaput.'” ");
INSERT INTO krx_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ayíin a naatoopanoolii naasokii kilim enkuu. ");
INSERT INTO krx_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Nkañahanoo: “Ahámpaatiin, weyme uwune annook unii fiyuu? Unii pimiikan pa pakatii étuuhaañi íhinu eehuu. ");
INSERT INTO krx_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Síitan, mañ emma nuutooke ma ti pupootak pa putoonii, fo úñahaniyoot mo úpufulii ti mah ma miti Kanaan? Puume éfuuyini káalipu kótifoloo niŋ fotom sanoo ti ekumpaan ya eti áhampaatiin a atii? ");
INSERT INTO krx_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ahámpaatiin, niŋ aatookaa elontoŋ ya ti epootak ya eti akee toonii, oom an afaamukee, unii nuuyeno pimiikan pa pakatii.” ");
INSERT INTO krx_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ahámpaatiin a naañahanii: “Iyyoo, úhinaa samat nii fa innisoke fa pale, aŋa inci fatook a elontoŋ ya ti epootak ya eteyoo, akina afaayeno amiikan a, pakakee paka nkayih.” ");
INSERT INTO krx_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","An óo an naahiliikan ápuwananii epootak ya eteyoo náapankin yo. ");
INSERT INTO krx_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ayíin a naasincan pupootak pa piteyii náacook ti epootak ya eti áhampaatiin a naakelan ti epootak ya eti kahiineen ka. Nkatook elontoŋ ya ti epootak ya eti Benjamin. ");
INSERT INTO krx_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Fiye, ínciitiyii fo nkahaacale wañ wa uteyii, an óo an teyii naañahan epootak ya eteyoo ti fáli ya eteyoo nkañoho ti saatee ya. ");
INSERT INTO krx_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Juda niŋ ñúnuwoo niŋ pakatuwoo nkacol ti ekumpaan ya eti Josef. Josef naaloŋ toko, nkákilipo hátikinoo ñuhooŋuyii t’etaam. ");
INSERT INTO krx_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Josef naasokii: “Weyme uwune ínnihin eehuu? Fo nímiit nii áyiin eecuke nii inci ataakaataak kayine kiti kameye heekaakaay ha pitaako?” ");
INSERT INTO krx_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Juda naacoop hilim ha naasokoo: “Ahámpaatiin, eeheyme nuuyina hisoku? Weyme nuuyina hisoku kati ukuulanee? Pútuun pa píhine aapucuk kaamuuyen ka kutoonii. Efuuyeno pimiikan pa pakatii niŋ aŋa nkacuke ya elontoŋ ya etii ti epootak ya eteyoo.” ");
INSERT INTO krx_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Josef naasokii: “Haani, inci étihaañi íhinu eehuu! Aŋa nkatooke ya elontoŋ ya etoom ti epootak ya eteyoo, akina afaayeno amiikan a atoom. Pale aluu, inniñoho ti kásuumaay pati paapaa ataaluu.” ");
INSERT INTO krx_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Juda naateeŋo pati Josef naasokoo: “Ahámpaatiin, ponket wunam púkup, inci amiikan a atii, timpi ñíken ti inci, kaatuko awe niŋ amansa ya ati Esipt nileha. ");
INSERT INTO krx_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ahámpaatiin, ti pítin unii púcook, aacakanaacakan unii pimiikan pa pakatii: 'Fo paapaa ataaluu aloŋaa kaloŋa? Fo nitaakaataak atu?' ");
INSERT INTO krx_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Nuuñahani: 'Utaakaataak paapaa eemaamane, atuwunii aŋa naapuke ya ti himaamanoo lompo oopa po. Paapaa atoonii álafiyoolafi meemak kaatuko akina lamma atowiye ti aaloo aŋa naahaŋe ya pálafi, akee ya aketaaket.' ");
INSERT INTO krx_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Fiye ansok unii: 'Nícoopiyamoo, láfiyoolafi hicuku.' ");
INSERT INTO krx_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Nuusoki nii: 'Añii ya aŋuu ayinaat kakatan paapaa atoonii, nihitaakiyaa, paapaa atoonii afaaket.' ");
INSERT INTO krx_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Pale aññahan unii: 'Niŋ atuwaluu ánapooliyoot naaluu, etiwanan aluu.' ");
INSERT INTO krx_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ta nuuñohiye ta pati paapaa atoonii, amiikan a atii, nuukamanoo kilim ka kitii. ");
INSERT INTO krx_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Po hátikin paapaa atoonii naasok unii: 'Niñoho Esipt nípinoomii unaa paliyal.' ");
INSERT INTO krx_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Nuuñahanoo: 'Uyinaat puñoho Esipt hinoom paliyal fo niŋ atuwunii anapoolaa niŋ unii, niŋ anapoolut niŋ unii áhampaatiin a ati Esipt atawanan unii.' ");
INSERT INTO krx_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Paapaa atoonii, amiikan a atii, eehe naasoke unii: 'Nímeyimeyi nii aalam pikampaani pákasupak naapukaam. ");
INSERT INTO krx_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Oonool a naafakam ti sipees inci insok: \"Pánipani élukuleen etaatulooloo-taatulool.\" Nene cukutoo fo fiye. ");
INSERT INTO krx_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Niŋ nicoopaa oonool a aŋe, niŋ waah utaakiyoo inci faket niŋ kúnuul pamaamanal.' ");
INSERT INTO krx_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Fiye, niŋ inci yetaa pati paapaa atoonii, amiikan a atii, unii peecoopoolut akampaani ya aŋe eeyem ya yaanoo, ");
INSERT INTO krx_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","niŋ acukutoo naañohiye niŋ unii afaaket, unii pimiikan pa pakatii efuuwun kati aket niŋ kúnuul pamaamanal. ");
INSERT INTO krx_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Niŋ fúlaa toko inci, amiikan a atii, naŋe eloŋam apikatan añii ya aŋe ti sipeesam, insokoo: 'Niŋ inci ñáhaniyootoo, fatiyo kaamuuyen enkuu hátikin paapaa atoom eloŋam púlooŋ.' ");
INSERT INTO krx_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Fiye, inci luumuu, coon inci piyeno amiikan a atii ti putum añii ya aŋe, akina naañoho niŋ ñúnuwoo. ");
INSERT INTO krx_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Puume inci fañoho pati paapaa atoonii peeñahanut añii ya aŋe? Etíyini hicuku kúnuul ka keekaakaay ka hicoku paapaa atoonii.” ");
INSERT INTO krx_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ta Juda naapaye ta káakup, Josef ayinaat ecocokanoolo hátikin píhina pa pakateyoo naasokii káful. Ta naayeniye ta lamayoo niŋ ñúnuwoo niŋ atuwoo náayisanii akina ayem ayme. ");
INSERT INTO krx_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Pale náacoolan meemak fo pakati Esipt nkásiyoo. Heetaakiye ha nihicol fo pati amansa ya ati Esipt. ");
INSERT INTO krx_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Josef naasok ñúnuwoo niŋ atuwoo: “Aŋe inci Josef! Fo paapaa atoom aloŋaa kaloŋa?” Pale ñúnuwoo nkaliim meemak hátikinoo kayinaatoo kañahan. ");
INSERT INTO krx_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Josef naasokii: “Káluma nílohiyam.” Nkalohoo, naasokii: “Inci yem Josef atuwaluu. Inci inninoomane kápucoopiyam Esipt. ");
INSERT INTO krx_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Fiye timpi niliim, timpi niwatanoolo kaatuko ninoomanaam-nooman ti mah emme. Pútuun pa púpoñiyaam le hátikin aluu kati fakan eloŋ. ");
INSERT INTO krx_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Le Esipt épankul eyem le kápiliŋ sitiil súsupak, efeeloŋ fo sitiil isak, piya etipitaako niŋ kaamaañ. ");
INSERT INTO krx_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Pútuun pa púpoñiyaam hátikin aluu kati pifakan aluu, ancuk keetowiye ka kaloŋa ti miin ma mitaaluu kati kameeŋ ti etaam ya. ");
INSERT INTO krx_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ooto aluu tom nípoñiyaam le pale Pútuun pa. Pikina píhinaam áhampaatiin a eehaŋe ya hitaaku nafaa ti amansa ya, ati hikaw ha ati ekumpaan ya eteyoo púlooŋ niŋ lompo áhampaatiin a ati mah ma miti Esipt púlooŋ. ");
INSERT INTO krx_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Fiye nihiliikan nipikaay pati paapaa atoom innisokoo: 'Añiini Josef asok: \"Pútuun pa píhinaam áhampaatiin a ati Esipt púlooŋ. Timpi kuuteen, kéy pati inci. ");
INSERT INTO krx_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Aafakin ti mah ma miti Kosen, inkolam, awe niŋ epuuki niŋ keesokuu maamaa, písaacii pa, pifil pa, síis sa niŋ waah óo waah weeyem utii. ");
INSERT INTO krx_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Epánkul ya eloŋaa fo sitiil isak, pale inci fawufani waah óo waah ewwa ansoolahe aakati loŋ, awe, miin ma mitii niŋ pukoolee pa pitii, ancuk timpi nilek.\"'” ");
INSERT INTO krx_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Josef nene asokii: “Nisincan! Nicukaacuk ho, Benjamin atuwam lompo naacuk ho, inci Josef yem ti káakup niŋ aluu. ");
INSERT INTO krx_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Nikaay canisok paapaa atoom fa pakati Esipt nkámakiyanam fa. Nikamanoo eeha púlooŋ innicuke ha niŋ fúlaa toko ínnicoopiyoo le mpacas.” ");
INSERT INTO krx_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Fiye, naaŋoon atuwoo Benjamin naakooŋ, Benjamin lompo naakooŋ. ");
INSERT INTO krx_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Naasumpool ñúnuwoo púlooŋ naakooŋ púful toko ñúnuwoo nkákupat neyoo. ");
INSERT INTO krx_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ta hilim eehuu nihicole ta lati ekumpaan ya eti amansa ya ati Esipt nii Josef ñúnuwoo niŋ atuwoo kácoliyoocol Esipt, amansa ya niŋ píhina pa pakateyoo ínsuumii. ");
INSERT INTO krx_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Amansa ya naasok Josef: “Sok ñúnuwi niŋ atuwi káhin eehe: 'Nitiyan púfali pa pitaaluu inniñoho ti mah ma miti Kanaan. ");
INSERT INTO krx_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Nícoopii paapaa ataaluu niŋ miin ma mitaaluu le pukolam. Inci fawufan aluu la haŋe la panap ti etaam ya eti Esipt, innili paliyal pa peehaŋe pa panap piti mah ma.' ");
INSERT INTO krx_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Aafasokii lompo: 'nicoop ti pisaleet pa piti mah ma miti Esipt kati nícoopii pakaal aluu, epuuk aluu niŋ paapaa ataaluu. ");
INSERT INTO krx_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Timpi niwatanoolo kamma aŋa innikaakaay ya hikatu po, kaatuko la haŋe la panap ti etaam ya eti Esipt púlooŋ etaaluu.'” ");
INSERT INTO krx_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Fiye epuuk Jakob, aŋa nkasok ya lompo Israyel, nkáhin eeha nkasokii ha. Josef naawufanii pisaleet samat nii fa amansa ya naasokoo fa, naawufanii lompo paliyal piti kaakaawool ka. ");
INSERT INTO krx_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Josef naawufan an óo an teyii hísool heewalla, pale naawufan Benjamin kúsool kiyema isak niŋ sikoofali sikeme síhaaciil. ");
INSERT INTO krx_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Naapoñ lompo ti paapaa ateyoo sífali ŋaasuwan seetiyanee waah wa weehaŋe wa panap Esipt niŋ uyaan sífali ŋaasuwan weetiyanee uli, kúmpuul niŋ paliyal óo paliyal piti kaakaawool ka kiti paapaa ateyoo. ");
INSERT INTO krx_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Púful toko, naakatan ñúnuwoo niŋ atuwoo kapuñoho. Poko ti hiñaku ha naasokii: “Timpi níñakalool ti pítin pa.” ");
INSERT INTO krx_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Fiye nkáful ti mah ma miti Esipt, nkacol ti mah ma miti Kanaan pati paapaa ateyii Jakob. ");
INSERT INTO krx_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Nkasokoo: “Josef aloŋaa kaloŋa! Akina ayem áhampaatiin a ati mah ma miti Esipt púlooŋ.” Pale Jakob apaaliitii kaatuko áyinanutii. ");
INSERT INTO krx_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Nkakamanoo eeha púlooŋ Josef naasokii ha. Jakob naacuk pisaleet empa Josef naapoñe pa kati púcoopiyoo, kunuuwoo nkúñohoonii. ");
INSERT INTO krx_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israyel naasok: “Fiye inci yínanaa, añiinam Josef aloŋaa kaloŋa! Inci fakaay hicukuyoo kétum.” ");
INSERT INTO krx_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Jakob, aŋa nkasok ya lompo Israyel, naañak niŋ waah óo waah ewwa naataake. Apucol Beerseba naawaaseen Pútuun pa piti paapaa ateyoo Isaak. ");
INSERT INTO krx_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Oom hánant Pútuun pa mpiyonkal Israyel ti éyawut mpusokoo: “Jakob! Jakob!” Naañahan po: “Eheeyam.” ");
INSERT INTO krx_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Pútuun pa mpusokoo: “Inci yem Pútuun pa, Pútuun pa piti paapaa atii. Timpi fe puwano Esipt kaatuko po inci fáhin miin ma mitii mípiyenoonii síi enfakat. ");
INSERT INTO krx_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Inci faŋam fawano niŋ awe fo Esipt, inci lompo fáñahaniyi. Niŋ aaketaa Josef áfaamif ñíkini.” ");
INSERT INTO krx_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Púful toko, Jakob náaful Beerseba. Pikampaani pa pakateyoo nkáyuukoo niŋ epuukii niŋ pakaalii ti pisaleet empa amansa ya ati Esipt naawufanii pa hak kaakaawool ka. ");
INSERT INTO krx_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Nkacoopool lompo pukoolee pa piteyii niŋ waah óo waah ewwa nkataake ti mah ma miti Kanaan, nkacol Esipt. Fiyuu Jakob naacole Esipt niŋ miin ma miteyoo púlooŋ: pikampaani niŋ púmaacul niŋ keesokoo maamaa. ");
INSERT INTO krx_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ehe ucaw wa uti epuuk pákayiin paka pakati Israyel, aŋa nkasok ya lompo Jakob, keekaaye ka Esipt: Ruben añii ya ácook a ati Jakob. ");
INSERT INTO krx_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Epuuk pákayiin paka pakati Ruben kayem: Hanok, Pallu, Hesilon niŋ Kalimi. ");
INSERT INTO krx_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Epuuk pákayiin paka pakati Simeyon kayem: Yemuyel, Yamin, Ohat, Yakin, Sohal niŋ Sawul eeyem ya añii ya ati aal ati Kanaan. ");
INSERT INTO krx_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Epuuk pákayiin paka pakati Lewi kayem: Keeson, Kehat niŋ Melali. ");
INSERT INTO krx_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Epuuk pákayiin paka pakati Juda kayem: El, Onan, Sela, Peles niŋ Serah. El niŋ Onan nkaket ti mah ma miti Kanaan. Epuuk pákayiin paka pakati Peles kayem: Hesilon niŋ Hamul. ");
INSERT INTO krx_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Epuuk pákayiin paka pakati Isakaal kayem: Tola, Puwa, Yasup niŋ Similon. ");
INSERT INTO krx_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Epuuk pákayiin paka pakati Sepulun kayem: Selet, Elon niŋ Yahuleel. ");
INSERT INTO krx_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Payenkuu kayem epuuk ya pákayiin paka payenka Leya naapuke ka Jakob ti mah ma miti Mesopotami niŋ ahoopii Dina. Epuukoo niŋ keesokoo maamaa, pákayiin niŋ pakaal, kayema áwii niŋ ŋaasuwan niŋ pákahaaciil (33). ");
INSERT INTO krx_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Epuuk pákayiin paka pakati Gad kayem: Sefon, Haki, Suni, Esupon, Eri, Aloti niŋ Aleli. ");
INSERT INTO krx_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Epuuk pákayiin paka pakati Asel kayem: Yimuna, Yisuwa, Yisuwi, Peliya niŋ ahoopii Selah. Peliya naataak epuuk pákayiin pákasupak, poko kayem: Hepel niŋ Malukiyel. ");
INSERT INTO krx_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Payenkuu kayem epuuk ya payenka Silupa naapuke ka Jakob, kayema pakan kaat niŋ oonool (16). Laban awufane Silupa apiyeno amiikan a ati añiinoo Leya. ");
INSERT INTO krx_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Epuuk pákayiin paka pakati Rasel, Jakob aaloo, poko kayem: Josef niŋ Benjamin. ");
INSERT INTO krx_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Po ti mah ma miti Esipt Josef naataak epuuk pákayiin pákasupak niŋ aaloo Asenat, ámaacul a ati Poti-Fela, awaaseena ati saatee ya eti On, poko kayem: Manase niŋ Efreem. ");
INSERT INTO krx_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Epuuk pákayiin paka pakati Benjamin kayem: Pelak, Pekel, Asepel, Kela, Naaman, Ehi, Los, Mupim, Hupim, niŋ Aat. ");
INSERT INTO krx_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Payenkuu kayem epuuk ya payenka Rasel naapuke ka Jakob, kayema pakan ŋaasuwan niŋ pakapaakiil (14). ");
INSERT INTO krx_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Añii ya áyiin a ati Dan ayem Husim. ");
INSERT INTO krx_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Epuuk pákayiin paka pakati Nafatali kayem: Yahuseel, Kuni, Yesel niŋ Sillem. ");
INSERT INTO krx_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Payenkuu kayem epuuk ya payenka Piluha naapuke ka Jakob, kayema pakan isak niŋ pákasupak. Laban awufane Piluha apiyeno amiikan a ati añiinoo Rasel. ");
INSERT INTO krx_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Jakob epuukoo niŋ keesokoo maamaa kéekeyii ka Esipt kayema áwii éhaaciil niŋ isak niŋ oonool (66), epuukoo pakaalii kafinutee toko. ");
INSERT INTO krx_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Epuuk pákayiin paka payenka Josef naapuke ka Esipt kayema pákasupak, nkananf miin ma miti Jakob meeyema Esipt, kayema pakan áwii éhaaciil niŋ ŋaasuwan (70). ");
INSERT INTO krx_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Fiye, Jakob naapoñ Juda pati Josef kati amemanool écolii ya eteyoo ti etaam ya eti Kosen. Ta Jakob niŋ miin ma miteyoo nkácolii ta Kosen, ");
INSERT INTO krx_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Josef naamemanool saleet ya eteyoo naacaapaakoolan paapaa ateyoo. Emma naacuke ma paapaa ateyoo naaŋoonoo naakampan ti pukooŋ. ");
INSERT INTO krx_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israyel naasok Josef: “Fiye inci yina eket, páawoo aaloŋaa kaloŋa, nene cukaa puhooŋuyi!” ");
INSERT INTO krx_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Josef naasok ñúnuwoo, atuwoo niŋ keeyem ka ti miin ma miti paapaa ateyoo: “Inci pikaay sok amansa ya ati Esipt nii: 'Ñúnuwam, atuwam niŋ miin ma púlooŋ miti paapaa atoom meeyeniye ma ti mah ma miti Kanaan mútoopiyaam.' ");
INSERT INTO krx_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Inci fanene sokoo eehe: 'Payenkuu, pufaasa písaacii niŋ pifil, pumankoola pukoolee. Kácoliyoo niŋ písaacii pa, pifil pa niŋ síis sa siteyii niŋ waah óo waah ewwa nkataake.' ");
INSERT INTO krx_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Niŋ amansa ya ayonkalaa aluu naacakan: 'Weyme uyem páhin aluu?' ");
INSERT INTO krx_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Inniñahanoo: 'Unii, pimiikan pa pakatii, unii pufaasa púlukuleen kápiliŋ nuuloŋloŋ fo fiye, samat nii símaama unii.' Fiyuu éfiniyini hikinu ti etaam ya eti Kosen. Kaatuko meeñeya pakati Esipt kati kanakanoolo niŋ pufaasa.” ");
INSERT INTO krx_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Josef naacaasok amansa ya ati Esipt: “Paapaa atoom niŋ ñúnuwam niŋ atuwam káfuliyooful ti mah ma miti Kanaan niŋ pukoolee pa niŋ waah óo waah ewwa nkataake, unka Kosen.” ");
INSERT INTO krx_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Naamamal isak ti ñúnuwoo náayisanii amansa ya. ");
INSERT INTO krx_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Amansa ya naacakan Josef ñúnuwoo: “Weyme uyem páhin aluu?” Nkañahanoo: “Unii pimiikan pa pakatii, unii pufaasa púlukuleen samat nii símaama unii.” ");
INSERT INTO krx_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Nkasokoo lompo: “Ukéyyookey pikin le kaatuko épankul ya efomaafom ti mah ma miti Kanaan, apan unii pimiikan pa pakatii nuutaak púlukuleen pale pahoonal pitaakiit. Fiye káluma, kat unii upukin ti etaam ya eti Kosen.” ");
INSERT INTO krx_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Amansa ya naasok Josef: “Paapaa atii, ñúnuwi niŋ atuwi kákeyyoo ti awe. ");
INSERT INTO krx_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Etaam ya eti Esipt uyya hátikini, hínii kapikin ti etaam ya la haŋe la panap, cakakin Kosen. Naameya teyii pákayiin kéetuuniye, mamalii kati kayeno pufaasa pukoolee pa putoom.” ");
INSERT INTO krx_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Fiye, Josef náacoopii paapaa ateyoo Jakob náayisanoo amansa ya. Jakob naasampan amansa ya. ");
INSERT INTO krx_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Púful toko amansa ya naacakan Jakob: “Sitiil puume antaake?” ");
INSERT INTO krx_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jakob naañahanoo: “Sitiilam siyema keme niŋ áwii niŋ ŋaasuwan (130), eloŋam púlooŋ eti kaatootoosool. Sitiilam simeeŋut apan ínsiciiti ántuŋ silehut nii siti símaamayam. Eloŋii lompo púlooŋ ti kaatootoosool nkapaye yo.” ");
INSERT INTO krx_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Fiye Jakob nene asampan amansa ya náaful ti ekumpaan ya eteyoo naakaay. ");
INSERT INTO krx_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Púful toko, Josef náahin paapaa ateyoo niŋ ñúnuwoo niŋ atuwoo kapikin la haŋe la panap Esipt ti mah ma miti Ramses samat nii fa amansa ya naasoke fa. Naawufanii pitaam peekaakaay éyenoonii piteyii. ");
INSERT INTO krx_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Náakuuman paapaa ateyoo niŋ ñúnuwoo niŋ atuwoo niŋ miin ma miti paapaa ateyoo púlooŋ niŋ epuukii. Naawufan miin óo miin aŋa ummusoolahe ya. ");
INSERT INTO krx_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ti oom caanak, épankul ya neeloŋ neeseeñe, paliyal pitaakiit ti mah ma, neetaat Esipt neetaat Kanaan. Pakan paka nkákuluk kamma épankul ya. ");
INSERT INTO krx_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Josef naaconcenool mañ ma púlooŋ miti pakati Esipt niŋ Kanaan emma nkanoome ma nemmo paliyal, naacoop mo pati ekumpaan ya eti amansa ya. ");
INSERT INTO krx_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ta mañ ímmitaakooniyoot ta, neetaat Esipt neetaat Kanaan, pakati Esipt púlooŋ nkákey ti Josef nkasokoo: “Wun unii upuli! Fo uñaŋaa eket hátikini kamma núutaakiyoot mañ?” ");
INSERT INTO krx_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Josef naañahanii: “Niŋ nitaakut mañ, niwufanam pukoolee pa pitaaluu ti pitit, inci uwwufan aluu paliyal.” ");
INSERT INTO krx_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Fiyuu nkácoopii pukoolee pa piteyii nkawufan po Josef; akina, naawufanii paliyal ti pitit niŋ pufalinc, písaacii, pifil, síis niŋ púfali pa piteyii. Oom etiil naawufanii paliyal ti pitit niŋ pukoolee pa piteyii púlooŋ. ");
INSERT INTO krx_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Eti pulay eteyyo nkáñohoonii nkasok Josef: “Ahámpaatiin, unii etuuyoli nii útaakiyoot mañ niŋ fúlaa toko pukoolee pa putoonii píyenooniyoo pitii, utaakut waah ewwa efuuwufani niŋ neetaat faŋ unii niŋ pitaam pa putoonii. ");
INSERT INTO krx_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Fo uñaŋaa eket hátikini, pitaam pa putoonii mpikatanee? Ooto noom unii niŋ pitaam pa putoonii, uwwufan unii paliyal. Unii niŋ pitaam pa putoonii efuuyeno pimiikan pakati amansa ya. Uláfiit eket! Ufan unii etukal kati úyini eloŋ, pitaam pa putoonii timpi piyeno úhaaŋ tes.” ");
INSERT INTO krx_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Fiye, Josef naanoom pitaam pa púlooŋ piti pakati Esipt pípiyenoonii piti amansa ya, an óo an ati Esipt naanooman ukit wa uteyoo kamma épankul ya neefome. Fiyuu etaam ya púlooŋ néeyenoonii eti amansa ya. ");
INSERT INTO krx_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Josef náahin pakan paka púlooŋ kápiyenoonii pimiikan, tonkoŋ fo tonkoŋ ti mah ma. ");
INSERT INTO krx_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Pitaam empa lamma Josef naanoomut pa piyem piti puwaaseena pa, kaatuko taakaataak hilim heesiiŋanee hiti amansa ya heesoke nii amansa ya afanawufanii paliyal pa piteyii. Ekina ewune kanoomanut pitaam pa piteyii. ");
INSERT INTO krx_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Josef naasok pakan paka: “Fiye inci noomaanoom aluu niŋ pitaam pa pitaaluu, aluu pakati amansa ya. Inci fawufan aluu etukal kati nisuk ti pitaam pa pitaaluu. ");
INSERT INTO krx_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Pale niŋ kaamaañ ka kútuuniyaa, efiniwufan amansa ya himpaac hoonool ti kimpaac isak, aluu innicoop kipaakiil ka keetowiye ka. Innífulan toko etukal, aŋa eetowiye ya ínnikuumanoolo niŋ epuuk aluu niŋ an óo an eeyem lati aluu.” ");
INSERT INTO krx_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Nkañahanoo: “Ahámpaatiin, aafakanaa eloŋ unii, íyyisan panap pa pitii, unii ucoonaa piyeno pimiikan amansa ya.” ");
INSERT INTO krx_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Fiyuu Josef naasiiŋane hilim ha heesiiŋanee ha, hilim eehuu uuha toko fo fíyooy po Esipt: himpaac hoonool ti kimpaac isak ti umaañ wa, hiti amansa ya. Pitaam pa piti puwaaseena pa lamma pineetaat piti amansa ya. ");
INSERT INTO krx_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ta miin ma miti Jakob, aŋa nkasok ya lompo Israyel, immikine ta Esipt ti etaam ya eti Kosen, immitaak pitaam, ummupukool fo ímmimeeŋii meemak. ");
INSERT INTO krx_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jakob naaloŋ sitiil kaat niŋ súsupak (17) ti mah ma miti Esipt. Eloŋoo púlooŋ neeyeno sitiil keme niŋ áwii ésupak niŋ isak niŋ súsupak (147). ");
INSERT INTO krx_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Israyel, ta eket ya eteyoo néelohanii ta naayonkal añiinoo Josef naasokoo: “Niŋ áalafiyaam pánipani, yísanam panap pa niŋ pucoonool pa pitii. Káluma, nakan epeesi t’etaam hipoŋam insintoolo nii, aatihokam le Esipt. ");
INSERT INTO krx_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Niŋ inci ketaa, fúlan ehunuŋam Esipt incaahokam ti hiyaak ha hiti símaamayam.” Josef naañahanoo: “Inci fáhin eeha ansokaam ha.” ");
INSERT INTO krx_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Jakob naaŋiiniyoo: “Sintoolo ho.” Josef naasintoolo. Fiye, Israyel náakilipo pukol hikaw ecunkun ya eteyoo. ");
INSERT INTO krx_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Eehuu hipimuus, nkasok Josef: “Paapaa atii ákuuñaakuuñ!” Mpásiyaloo eehuu, naacoop pikampaani pa pakateyoo pákasupak paka, Manase niŋ Efreem, nkakaayoo hiyoop. ");
INSERT INTO krx_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Fiye nkasok Jakob: “Añiini Josef ácoliyoo hiyoopuyi.” Jakob, aŋa nkasok ya lompo Israyel, náahin kata apilito, naayeno ti ecunkun ya eteyoo. ");
INSERT INTO krx_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jakob naasok Josef: “Pútuun pa piti sempe sa púlooŋ púfuliyooful ti inci Lus eeyem ya ti mah ma miti Kanaan, mpisampanam. ");
INSERT INTO krx_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Mpusokam: 'Inci fawufani epuuk keemeeŋe aakati yeno maamaa ati hícump písii. Fawufan mah emme epuuki niŋ keesokuu maamaa, éfimiyenoonii miteyii fo eket maama.'” ");
INSERT INTO krx_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Jakob nene asokoo: “Pikampaani pa pákasupak paka pakatii keepukee ka ti mah ma miti Esipt le niŋ inci fákey pukoli, cokiicok nii epuukam. Efreem niŋ Manase pakatoom samat nii Ruben niŋ Simeyon. ");
INSERT INTO krx_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Pale pakatuwii efikayeno pakatii. Ti etaam ya eti ñúnuwii efikasa hitoonu ha hiteyii. ");
INSERT INTO krx_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Kaatuko ta inci ínfulii ta Mesopotami cólumii Efalata ti mah ma miti Kanaan, Rasel, íññaa atii, naaket ti pítin pa, ínciitiyam meemak. Inci inhokoo ti pítin pa piti Efalata (ekina nkasok fiye Betelehem).” ");
INSERT INTO krx_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israyel naacuk pikampaani pa pakati Josef naacakan: “Payenkuu pakayme?” ");
INSERT INTO krx_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Josef naañahanoo: “Payenkuu pikampaani pa payenka Pútuun pa mpuwufanaam ka le Esipt.” Jakob naasokoo: “Káluma, cóopiyii pukolam kati sampanii.” ");
INSERT INTO krx_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ti oom caanak, Israyel amaamanaa-maaman, ñíkinoo íññitaah acukantoo pinap. Fiye, Josef naacoop pikampaani pa pakateyoo pukol Israyel. Israyel naaŋoonii naasumpoolii. ");
INSERT INTO krx_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Púful toko naasok Josef: “Taapala míilool nii fanene cuk puhooŋuyi pale Pútuun pa mpíhin pucuk focaa epuuki.” ");
INSERT INTO krx_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Josef náafulan epuukoo ti hipoŋ Jakob, náakilipo hátikinoo puhooŋuyoo t’etaam. ");
INSERT INTO krx_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Josef naasiiŋan epuukoo, Efreem ti epeesoo yáali ekina eyem Israyel epeesoo yaamay, Manase ti epeesoo yaamay ekina eyem Israyel epeesoo yáali, náahinii kapulohoo. ");
INSERT INTO krx_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Pale Israyel naafiitanool sipeesoo, naanaŋ yáaliyoo ti hikaw Efreem eeyem ya kahiineen ka, naanaŋ yaamayoo ti hikaw Manase eeyem ya áhampaatiin a. ");
INSERT INTO krx_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Fiye naasampan Josef, naasokoo: “Alímaati Pútuun pa empa maamaa atoom Abraham niŋ paapaa atoom Isaak nkátuule pa, Pútuun pa peefaasaam pa kápiliŋ emma inci impukee ma fo fiye, ");
INSERT INTO krx_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Pútuun pa peeyem pa Maleekoo ya eefakanaam ya ti heenaput ha púlooŋ, álimaati pisampan pikampaani pa payenke! Alímaati pínapii teyii caacawam inciluwee niŋ lompo caacaw maamaa atoom Abraham niŋ citi paapaa atoom Isaak, nkataak hícump miin ti etaam ya!” ");
INSERT INTO krx_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Josef súumutoo fa naacuke fa paapaa ateyoo naanaŋe fa epeesoo yáali ti hikaw Efreem; fiye, naacok epees faafoo kati áfulan yo ti hikaw Efreem apinaŋ yo ti hikaw Manase. ");
INSERT INTO krx_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Naasok paapaa ateyoo: “Haani paapaa, fiyuu tom. Aŋe ayem áhampaatiin a, naŋ epeesi yáali ti hikawoo.” ");
INSERT INTO krx_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Paapaa ateyoo naapook, naasokoo: “Añiinam, inci méyimeyi, Manase lompo keesokoo maamaa éfikayenoonii síi eemaka. Pale atuwoo afaahaŋoo hamake, keesokoo maamaa éfikayenoonii písii peemaka.” ");
INSERT INTO krx_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Fiye, naasampanii oom hinoom, naasok: “Ti ucaw aluu pakati Israyel éfinkasik niŋ kayeniyaa kaasampan. Efinkasok: 'Alímaati Pútuun pa píhin aluu nípiful Efreem niŋ Manase.'” Fiyuu Jakob naanaŋe Efreem hátikin Manase. ");
INSERT INTO krx_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Fiye, Israyel naasok Josef: “Etikamp ketaa, pale Pútuun pa efipiyeno niŋ aluu, efipiñahan aluu ti mah ma miti símaama aluu. ");
INSERT INTO krx_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Inci ufanuu pihaŋ ñúnuwi: etaam ya eti Sikem eenape ya eyya inci illame ya ti pakati Amol. Etaam eyyuu, niŋ káakuntu ka kutoom niŋ hiŋaaceen ha hitoom inci intaake yo.” ");
INSERT INTO krx_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Púful toko, Jakob naayonkal epuukoo naasokii: “Níconcooloyii inci pusok aluu heekaakaay ha pitaako aluu hátikin. ");
INSERT INTO krx_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Níkey nísiitan, aluu epuuk Jakob, nísiitan Israyel paapaa ataaluu. ");
INSERT INTO krx_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, añiinam áyaañ, awe yem sempeyam, añiinam áyaañ ti hikampaanateyam. Epuukam púlooŋ, aahaŋii sempe inhaŋee káamakiyan. ");
INSERT INTO krx_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Mpahiñi nii ésaacin, pale aatinene haŋ an, kaatuko aahintaahinto niŋ aalam, uwwas ecunkun ya etoom meeñeya. ");
INSERT INTO krx_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeyon niŋ Lewi pakoonool paka, úkuntu wa uteyii uti káapucalool. ");
INSERT INTO krx_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Alímaati inci timpi tantak ñicukool ña ñiteyii, álimaati inci timpi yeno nantoonool ti piteŋenool pa piteyii. Kaatuko ti káñiken ka kiteyii nkamuke pákayiin nkataak pásuuma ti kaamuunal kíciin. ");
INSERT INTO krx_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ñanaa pafet pa piteyii peehiñe pa, niŋ káñiken ka kiteyii keekance ka. Keesokii maamaa étikayini piyeno nantoonool, efikanakanoolo niŋ keesoke Jakob maamaa, nkahancaloolo pan óo pan ti mah ma miti Israyel. ");
INSERT INTO krx_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, ñúnuwi niŋ pakatuwi éfikamuli, aafacok ñisenku pikamooli, miin ma miti paapaa atii éfimikilipo hátikini. ");
INSERT INTO krx_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda, añiinam, aacukaacuk nii cicata ceepaye hili efoofa etenco, inciñoho ti káahintuma etenco inciñakoolo incihinto. Ayme áfaahaañi co kalitan? ");
INSERT INTO krx_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Cáwii ca éticiful ti miin ma miti Juda, hípaal ha hiti cáwii ca étihiful ti máacaasiyoo taamanta aŋa eeñaŋe ho ya hicoopu ácoliyoot, aŋa ammeya ya nii púlunta pa púlooŋ éfiputuuloo. ");
INSERT INTO krx_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Afaacenk cífali ca citeyoo ti nikenenk, afaacenk fáli eyyuu ti nikenenk neenape. Elaan éeciita hinoom eti kikenenk efeemeeŋ fo añow teyyo wañ wa uteyoo, fo añow teyyo hísool ha hiteyoo. ");
INSERT INTO krx_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ñíkinoo efiñihaŋ elaan eti kikenenk pacaaŋ, úŋiiŋoo nuuhaŋ miin pahiine. ");
INSERT INTO krx_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sepulun afaakin ti kantant kaatii keetaake kásik kiti ñiteen ñenfakat, afaakin puwant Siton. ");
INSERT INTO krx_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakaal acukaacuk nii fáli eetaake sempe éepahiye ti pututa kukuup kúsupak enka neekancape. ");
INSERT INTO krx_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Afaacuk nii éyekunooluma ya enapaanap, etaam ya néesuum. Naawufan káapantiyoo apikanto pakantiyal peenapa naacoon páhin piti amiikan. ");
INSERT INTO krx_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan áfaahin kíiti pakanoo samat nii pikee písii pa piti Israyel. ");
INSERT INTO krx_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan afaacuk nii epululoola ti kanaac pítin, kaafepa ti pítin pa, enka nkulum efalinc ti koot fo efalinc ya ewant ateteyana ya eteyyo naalinkiloolo. ");
INSERT INTO krx_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ateeteyo, inci taakaataak káyinan nii aafafakanam! ");
INSERT INTO krx_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad, pikanca efikalaakiyoo, pale náasiiŋoonii apitey neyii. ");
INSERT INTO krx_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asel mah ma miteyoo efimmitaak umaañ weenape, afanamemanool ñaliyal ñiti pumansa. ");
INSERT INTO krx_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nafatali acukaacuk nii himisawoot heeyihe eeha nihipuk mufuun meewalla. ");
INSERT INTO krx_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Josef acukaacuk nii enuun eewalla eyya nepukool, néeyemi pukol káapun. Unaay eteyyo nuumuus hiniŋ ha. ");
INSERT INTO krx_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Pakati kiŋaaceen kalaahatooloo nkalaakiyoo nkacenanoo. ");
INSERT INTO krx_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Pale akina, sipeesoo seeyanke etisikikilan niŋ ásikaa hiŋaaceen ha hiteyoo, kamma sempe sa siti Pútuun pa piti Jakob, pikina piyem Afaasa ya, niŋ lompo Enánkiin ya eti Israyel. ");
INSERT INTO krx_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Pikina piyem Pútuun pa piti paapaa atii empa mpiyankanani pa, Pútuun pa piti sempe sa púlooŋ empa mpisampani pa: kaasampan kiti etiil ya eyya néfulii ya patiila, kiti man emma úmmufulii ma t’etaam, niŋ kiti kaapukool niŋ káacuuwan. ");
INSERT INTO krx_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Kaasampan ka kiti paapaa atii kihaŋaahaŋ pafom pítintiŋ pa peeyem pa le kápiliŋ ti símaama unaa, kumuusaamuus mítintiŋ ma miti kúcook ka. Alímaati kúwanoonii ti hikaw Josef, éeyenoonii ya ati hikaw ti ñúnuwoo niŋ atuwoo. ");
INSERT INTO krx_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin acukaacuk nii eyen elampa eyya netaatulool. Mpucom pa neli élukuleen eyya neeleemaye ya, Nkániim ka népaacinool aŋa neecoke ya.” ");
INSERT INTO krx_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Payenkuu púlooŋ kayem sísii sa ŋaasuwan niŋ súsupak sa siti pakati Israyel. Kilim enkuu paapaa ateyii naasokii ta naayeniyii ta kaasampan, an óo an niŋ kaasampan ka kiteyoo. ");
INSERT INTO krx_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Púful toko Jakob naasok epuukoo: “Etikamp inci ketaa pinanf pakataama, nihokam la ñífaafam nkahokee la, ti kaayeen ka kenfakat ka keeyem ka ti kaakit ka kiti Efulon, eesoke Het maamaa. ");
INSERT INTO krx_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Kaayeen enkuu unka ti kaakit ka kiti Makapela pukol Mamule ti mah ma miti Kanaan. Abraham anoome kaakit ka ti Efulon, eesoke Het maamaa, kati kiyeno íhokuma ha hiteyoo. ");
INSERT INTO krx_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Toko Abraham niŋ aaloo Sara nkahokee, Isaak lompo niŋ aaloo Rebeka toko nkahokee. Inci himuumam toko inhoke Leya. ");
INSERT INTO krx_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Kaakit ka niŋ kaayeen ka keeyem ka toko, ti keesoke Het maamaa nkunoomee.” ");
INSERT INTO krx_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ta Jakob naapaye ta káakup niŋ epuukoo, náaseepin wootoo apinaŋ wo ti ecunkun ya, naasuuŋut pikelan naaket apinanf pakataama. ");
INSERT INTO krx_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Emma Jakob naakete ma, Josef naatah faŋoo ti ehunuŋ ya eti paapaa ateyoo naakooŋ teyyo, naayeno yo kaasumpool ti puhooŋu. ");
INSERT INTO krx_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Fiye, Josef naawufan hilim púkuuñana pa kapimemanool ehunuŋ paapaa ateyoo niŋ kupuun niŋ munucu méesuume haaw. Nkamemanool yo. ");
INSERT INTO krx_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Incoop kunoom áwii ésupak (40), kikina kiyem kunoom enka nkañaŋe ka hicoopu kati kamemanool ehunuŋ timpi efut. Pakati Esipt nkakooŋoo fo kunoom áwii éhaaciil niŋ ŋaasuwan (70). ");
INSERT INTO krx_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ta caanak ca citi keeŋoot ka incipaye ta, Josef naasok puwuna amansa ya kunuu: “Káluma, canisok amansa ya nii: ");
INSERT INTO krx_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","'Paapaa atoom, ta eket ya eteyoo néelohanii ta, náahinam pisintoolo nii inci facaahokoo ti íhokuma ha eeha naamemanooliye ha ti mah ma miti Kanaan. Fiye káluma, katanam pisilo Kanaan pícaahokii paapaa atoom. Niŋ inci payaa fáñohoonii.'” ");
INSERT INTO krx_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Amansa ya naañahanoo: “Kaay caahok paapaa atii samat nii fa náahinuu fa aapisintoolo.” ");
INSERT INTO krx_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Fiye, Josef naayeno pikaayu kati ahok paapaa ateyoo. Puwuna amansa ya kunuu, ñíhampaatiin ña pakati ekumpaan ya eti amansa ya niŋ ñíhampaatiin ña púlooŋ pakati mah ma miti Esipt nkanapool neyoo. ");
INSERT INTO krx_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Miin ma miteyoo púlooŋ, ñúnuwoo niŋ atuwoo niŋ miin ma miti paapaa ateyoo nkanapool lompo neyoo. Intowo ti mah ma miti Kosen epuuk ya niŋ pukoolee pa lamma. ");
INSERT INTO krx_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Pakakee lompo pakati pufalinc niŋ pakati pisaleet nkanow teyii; kayoŋ kenfakat kinapoole neyoo. ");
INSERT INTO krx_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ta nkacole ta la nkasok la Kolen-ha-Atat pukol han ha hiti Jordan, nkakooŋ meemak, Josef náahin faafoo keeŋoot kenfakat fo kunoom isak niŋ kúsupak. ");
INSERT INTO krx_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ta pakati mah ma miti Kanaan nkacuke ta pakan paka kéekeyii ka keeŋoot ka Kolen-ha-Atat nkasok: “Aŋe keeŋoot kenfakat pakati Esipt nkataake.” Ekina ewune nkalu toko caacaw ca Apel-Misulayim (ekina eyem “keeŋoot ka kiti Esipt”). ");
INSERT INTO krx_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Fiyuu epuuk Jakob nkáhine eeha naasokii ha. ");
INSERT INTO krx_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Nkacoop ehunuŋ ya eteyoo ti mah ma miti Kanaan. Nkahok yo ti kaayeen ka kenfakat ka kiti kaakit ka kiti Makapela, pukol Mamule, enka Abraham naanoome ka ti Efulon, eesoke Het maamaa, kati kiyeno íhokuma ha hiteyoo. ");
INSERT INTO krx_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ta Josef naapaye ta ihoku paapaa ateyoo, naañoho Esipt niŋ ñúnuwoo niŋ atuwoo niŋ payenka púlooŋ keenapoole ka neyoo ihoku paapaa ateyoo. ");
INSERT INTO krx_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Púful toko Josef ñúnuwoo nkasok: “Fiye paapaa atuunaa aketaa, Josef áfaayini náañohoonii tuunaa náanukan heenaput ha púlooŋ eeha núuhinoo ha.” ");
INSERT INTO krx_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Nkapoñ pati Josef hilim eehe: “Paapaa atuunaa áketum, eehe naasoke: ");
INSERT INTO krx_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","'Nisok Josef: Káluma, ponket umuuyen wa uti ñúnuwi: henfakat ha heenaput eeha nkáhinuu ha.' Fiye káluma, ponket umuuyen wa uti unii pimiikan pa pakati Pútuun pa piti paapaa atuunaa.” Josef naayeno pukooŋ ta náasiye ta ekooŋan eyyuu. ");
INSERT INTO krx_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Púful toko ñúnuwoo nkákey nkákilipo ti wootoo nkasokoo: “Unii pimiikani.” ");
INSERT INTO krx_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Pale Josef naañahanii: “Timpi nife, inci yinaat piyeno ti káasiiŋuma Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Nílafiyaamlafi íhinu heenaput, pale Pútuun pa mpílafi íhinu heenape, mpifakan eloŋ hícump pakan samat nii eeha innicuke ha fíyooy. ");
INSERT INTO krx_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Fiye, timpi nife, famankool aluu niŋ miin ma mitaaluu.” Ti pákupaloo péesuume empuu naapuuñanoolii. ");
INSERT INTO krx_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Fiye, Josef niŋ miin ma miti paapaa ateyoo púlooŋ nkatowo Esipt, Josef naaloŋ sitiil keme niŋ ŋaasuwan (110). ");
INSERT INTO krx_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Naacuk epuuk Efreem niŋ keesoke Efreem maamaa. Naacok epuuk Makil, Manase añiinoo, nii epuukoo. ");
INSERT INTO krx_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Hikee hinoom, Josef naasok pakanoo: “Etikamp inci ketaa pale Pútuun pa efipimankool aluu mpúfulan aluu Esipt mpucoop aluu ti mah emma mpisintooliye ma nii efipuwufan Abraham, Isaak niŋ Jakob.” ");
INSERT INTO krx_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Josef náahin epuuk Jakob, aŋa nkasok ya lompo Israyel, kapisintoolo: “Niŋ Pútuun pa píkeyyoo kayankanan aluu mpucoop aluu ti oom mah, nicoopool ehunuŋam.” ");
INSERT INTO krx_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Eehuu hipimuus, Josef naaket Esipt loho ataakaa sitiil keme niŋ ŋaasuwan (110). Nkamemanool ehunuŋoo timpi efut, nkawas yo ti keesoo.");
INSERT INTO krx_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ehe ucaw epuuk pikampaani pa pakati Israyel, aŋa nkasok a lompo Jakob, keekaaye ka neyoo Esipt, an óo an niŋ miin ma miteyoo: ");
INSERT INTO krx_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeyon, Lewi, Juda, ");
INSERT INTO krx_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakaal, Sepulun, Benjamin, ");
INSERT INTO krx_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Nafatali, Gad niŋ Asel. ");
INSERT INTO krx_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Epuuk ya pakati Jakob niŋ keesokoo púlooŋ maamaa kayema pakan áwii éhaaciil niŋ ŋaasuwan (70). Tempo Josef Esipt. ");
INSERT INTO krx_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Po hátikin, Josef niŋ ñúnuwoo niŋ atuwoo niŋ ekaay ya eteyii púlooŋ nkaket. ");
INSERT INTO krx_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Fiye pakati Israyel nkapukool nkameeŋ fo muus nkataak sempe, nkámeeŋii pan óo pan ti mah ma. ");
INSERT INTO krx_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Sitiil seemeeŋe sipimuus, intaako Esipt amansa éeyeeni éemiit kiti Josef. ");
INSERT INTO krx_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Naasok pakanoo: “Pakanam, nisincan, pakati Israyel kameeŋaameeŋ nkataak sempe apan kahaŋa unaa. ");
INSERT INTO krx_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Níkey uwenaa neyii niŋ ecohato, niŋ ekina tom efikahaŋ toko nkameeŋe. Niŋ hikam hitaakiyaa efikananf ti pikamool unaa nkátaakoolan unaa nkakatan mah ma.” ");
INSERT INTO krx_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Fiye pakati Esipt nkacok pakati Israyel pimiikan, nkamamal pufaasa payenka efikafaasii, nkawufanii páhin peeseeñe kati kakallanii, nkasokii kasiiŋan sisaatee súsupak, Pitom niŋ Ramses, kati siyeno ñileefaan ña ñiti amansa ya. ");
INSERT INTO krx_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Pale fa nkahaŋ fa nkakancoole neyii fo nkahaŋ nkameeŋe nkahancoolo, eehuu nihiwun pakati Esipt nkahaŋ nkafeye pakati Israyel. ");
INSERT INTO krx_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Nkakallan pakati Israyel nkawufanii páhin peeseeñe: ");
INSERT INTO krx_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","páhin óo páhin piti kulut niŋ piti ukit wa. Niŋ oom páhin piti sempe nkakancoole niŋ pakati Israyel nkáhin eloŋ ya eteyii epiyeno eloŋ eti kúnuul. ");
INSERT INTO krx_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ti oom caanak, intaak puloŋana pakaal pákasupak pakati Pihiburu pa payenka nkasok Sifula niŋ Puwa. Amansa ya naasokii: ");
INSERT INTO krx_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Niŋ niyeniyaa kaloŋan pakaal Pihiburu pa, innisincan pinap añii ya. Iyyema cikampaani innimuk co, pale iyyema címaacul innikat co cipiloŋ.” ");
INSERT INTO krx_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Pale puloŋana pakaal paka nkafe Pútuun pa, káhinut eeha amansa ya ati Esipt naasokii ha, nkakat mikampaani ma mupuloŋ. ");
INSERT INTO krx_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Fiye amansa ya naayonkalii naacakanii: “Weyme uwune ínnihin eehe, innikat mikampaani ma mupuloŋ?” ");
INSERT INTO krx_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Puloŋana pa nkañahan amansa ya: “Pakaal paka pakati Pihiburu pa kacukut nii pakaal Esipt. Kataakaataak sempe, nkapukpuk le niŋ efuucol kati uloŋanii.” ");
INSERT INTO krx_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Fiyuu, pakati Israyel nkahaŋe nkámeeŋii nkataak sempe meemak. Pútuun pa mpíhin heenape ti puloŋana pa. ");
INSERT INTO krx_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Kamma nkafeye Pútuun pa, ekina ewune mpuwunii epuuk. ");
INSERT INTO krx_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Fiye amansa ya naawufan hilim pakanoo púlooŋ: “Niŋ pakati Israyel káfulaa toko, iyyema címaacul, nikat co cipiloŋ, pale iyyema cikampaani inniwant co ti musuu ma miti Nil.” ");
INSERT INTO krx_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ti oom caanak, intaako akee áyiin ati síi ya eti Lewi eesaye aal ati oom síi. ");
INSERT INTO krx_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Aal a naasa munow, náapukii cikampaani. Naacuk nii ciñii ca cíwalliwalli, naayol co fo kiim káhaaciil. ");
INSERT INTO krx_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Púful toko, náameyi nii atanene áyini co hiyolu naacoop kasekeyu keeliilee niŋ píheeni empa nkasok papilus, naanaaneen ko manoo niŋ epis timpi kíseem, naahintan tenko ciñii ca. Fiye naacaasoof kasekeyu ka ti píheeni piti umpiip peeyem ti kanaac musuu ma miti Nil. ");
INSERT INTO krx_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ahoop etenco naasiiŋo pílaaŋ caahinkiŋ, apisincan heekaakaayoo ha pitaako. ");
INSERT INTO krx_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Fiyiit ámaacul a ati amansa ya naawano pati musuu ma puñowo. Ta naayeniye ta puñowo, píhina pa púmaacul pa pakateyoo nkayeno kasapal ti kantant ka kiti musuu ma. Naacuk kasekeyu ka ti pututa píheeni pa, naapoñ amiikan a ateyoo ápicaacoopii ko. ");
INSERT INTO krx_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ta náacoopii ta kasekeyu ka, añii ámaacul a ati amansa ya náapankin ko naacuk cikampaani ca. Inciyeno pukooŋ. Inketoo tenco ti hikaw, naasok: “Aŋe oonool ti epuuk Pihiburu pa!” ");
INSERT INTO krx_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ahoop etenco apucuk eehuu, naacakan ámaacul a ati amansa ya: “Inci kaay ŋésiyi aal pati Pihiburu pa kati ácuuwani ciñii ca?” ");
INSERT INTO krx_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Amáacul a ati amansa ya naañahanoo: “Iyyoo, kaay.” Ahoop ciñii ca náakaacoopii íññaa etenco. ");
INSERT INTO krx_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Iññáa etenco ápucolii, ámaacul a ati amansa ya naasokoo: “Coop ciñii ence pati awe íncuuwanam co, inci facooyi.” Aal a naacoop ciñii ca náacuuwan co. ");
INSERT INTO krx_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ta añii ya náafule ta ti káacuu, íññaa a ateyoo naacaawufanoo ámaacul a ati amansa ya. Amáacul a naacokoo samat nii añiinoo, naasok: “Páawoo ti man ma inci ínfulaniyoo, faluwoo caacaw ca Móyiis”. ");
INSERT INTO krx_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Móyiis náayankii. Hikee hinoom náaful apikaay hiyoop pakanoo Pihiburu pa. Naacuk páhin pa peeseeñe empa nkawufanii pa, naacuk lompo ati Esipt ti hisapu akee ti pakanoo Pihiburu pa. ");
INSERT INTO krx_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Móyiis naawelepool pan óo pan acukut an, naamuk ati Esipt a naahokoo ti esiya ya. ");
INSERT INTO krx_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Eti kacom eteyyo náañohoonii naacuk pákayiin pákasupak Pihiburu ti pítaakool. Naacakan aŋa alaahe ya: “Weyme uwune ansap áwiyi?” ");
INSERT INTO krx_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Pale áyiin a naañahanoo: “Awe, ayme asiiŋanuu ati hikaw niŋ afiita kilim ti pututa unii? Fo áalafiyaamlafi himuku samat nii fa ammuke fa ati Esipt a?” Fiye Móyiis naafe naasokoolo: “Caham eehuu hísiyaasiyo!” ");
INSERT INTO krx_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Amansa ya náasi eeha Móyiis náahine ha, naaŋes himukuyoo. Móyiis naatey ápilaaŋ amansa ya, naacaakin ti mah ma miti Mitiyan. Naayeno pukol ésaapun. ");
INSERT INTO krx_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ti oom mah, intaak awaaseena eetaake púmaacul kayema isak niŋ pákasupak. Púmaacul paka payenkuu nkákey piyook man kapimeeŋan ñúus ña, kati kawun pifil pa niŋ písaacii pa piti paapaa ateyii pipilaan. ");
INSERT INTO krx_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ta nkayeniye ta piyook, pakakee pufaasa nkákey nkayaanii. Fiye Móyiis naalito apisiiŋiyii, naawun pukoolee pa piteyii pipilaan. ");
INSERT INTO krx_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Nkañoho ti paapaa ateyii aŋa nkasok a Leyuwel, akina nkasok lompo Yetulo, naacakanii: “Weyme uwune ínnifiis éñohoonii fíyooy?” ");
INSERT INTO krx_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Nkañahanoo: “Akee áyiin ati Esipt afakane unii ti sipees pufaasa pa, akina himuumoo ayooke unii man naawun pukoolee pa pipilaan.” ");
INSERT INTO krx_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Paapaa ateyii naasokii: “Peyme naayem? Weyme uwune ínnitahiyoo po? Cániyonkaliyoo ápikey hili.” ");
INSERT INTO krx_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Fiye nkakaay íncakayonkalii Móyiis, náakey naali neyii, naacoon hikinu lati Yetulo. Yetulo naawunoo ámaacul a ateyoo Sipola apisayoo. ");
INSERT INTO krx_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Sipola naapuk cikampaani, Móyiis naalu co caacaw ca Kelusom, ekina eyem “akaawoola le”. Kaatuko asok: “inci akaawoola ti mah me.” ");
INSERT INTO krx_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Hícump sitiil sipimuus, amansa ya ati Esipt naaket. Pakati Israyel nkaloŋ ti himiikanate ha nkalik fo nkaceek. Hiceeku ha hiteyii hiti hiŋes kayankanan nihicol pati Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Pútuun pa mpísi hiliku ha hiteyii, mpínawuno písiyool empa mpiliile pa niŋ Abraham niŋ Isaak niŋ lompo Jakob. ");
INSERT INTO krx_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Fiye Pútuun pa mpucuk pakati Israyel mpitaak paket hikaw teyii. ");
INSERT INTO krx_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ti oom caanak, Móyiis naayeno efaas pifil pa niŋ písaacii pa piti aasonoo Yetulo, awaaseena ya ati Mitiyan. Hikee hinoom, naaŋal pukoolee pa puson káahaaŋ ka tes naacol Horeb, tíntiŋ ya eti Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Toko maleekoo ya eti Ateeteyo néefulii teyoo ti kaaleew, ti pututa cífita. Móyiis naacuk nii, cífita ca unca ti hicoku pale cisowiit. ");
INSERT INTO krx_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Fiye Móyiis naasok: “Inci puloh kati cuk waah wa wéenime ewwe. Weyme uwune cífita ca cisowiit?” ");
INSERT INTO krx_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ta Ateeteyo naacuke ta nii Móyiis hilohu naayaake kati asincan, naayonkaloo púfulii ti pututa cífita ca, naasokoo: “Móyiis, Móyiis!” Móyiis naañahanoo: “Eheeyam.” ");
INSERT INTO krx_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ateeteyo naasokoo: “Timpi lóhii le. Waat pisamata pa pitii kaatuko la ansiiŋiye la etaam eesampanee.” ");
INSERT INTO krx_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Púful toko, Ateeteyo naapenan ti hisoku: “Inci yem Pútuun pa piti paapaa atii, Pútuun pa piti Abraham, Pútuun pa piti Isaak niŋ Pútuun pa piti Jakob.” Fiye Móyiis náawufalool puhooŋuyoo kaatuko afeyaafe kaasincan Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ateeteyo nene asokoo: “Inci cukaacuk táh ñíyoka ña ñiti pakanam ti mah ma miti Esipt, ínsi fa nkayem fa ti pukooŋ kayankanan kati kafakanee ti keeyemii ka ti kaakallan. Ee méyimeyi kúnuul ka kiteyii. ");
INSERT INTO krx_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Fiye inci wánooniyoo-wano pifakanii ti sipees pakati Esipt ínfulanii ti mah emmuu kati silanii ti mah meenape ummuweñ, ti mah meemeeŋe keekee niŋ múkum, mah ma miti pakati Kanaan, pakati Het, pakati Amol, pakati Pelis, pakati Hiw niŋ pakati Yepus. ");
INSERT INTO krx_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Fiye páawoo pukooŋ pa piti pakati Israyel kati kayankananee púcoliyoocol ti inci apan incuk fa pakati Esipt nkayemii fa ti kaakancool, ");
INSERT INTO krx_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","inci pupoñi ti amansa ya. Kaay cáafulanii pakanam pakati Israyel Esipt.” ");
INSERT INTO krx_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Móyiis naañahan Pútuun pa: “Inci yem ayme kati kaay pati amansa ya, ínfulanii pakati IsrayelEsipt?” ");
INSERT INTO krx_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Pútuun pa mpiñahanoo: “Inci fayeno niŋ awe. Niŋ áafulaniyoo pakati Israyel Esipt, éfinikey ti tíntiŋ eyye inniwaaseenam. Ekina éfeeyisan nii inci poñuu.” ");
INSERT INTO krx_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Móyiis naañahan Pútuun pa: “Iyyoo! Niŋ inci fakaay pati pakani pakati Israyel insokii: 'Pútuun pa piti símaama aluu púpoñiyaam ti aluu,' pikee pa nkacakanam: 'Caacaw etempo puume?' Puume inci fañahanii?” ");
INSERT INTO krx_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Pútuun pa mpusok Móyiis: “Inci yem aŋa inci iyyem ya. Fiye aafasok pakati Israyel: 'Inci Yem ápoñiyaam taaluu.'” ");
INSERT INTO krx_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Pútuun pa nene pusok Móyiis: “Fiye áafakup niŋ pakati Israyel: 'Ateeteyo ápoñiyaam ti aluu, Pútuun pa piti símaama aluu, Pútuun pa piti Abraham, Pútuun pa piti Isaak niŋ Pútuun pa piti Jakob.' Aŋe eyem caacawam fo eket maama, ti caacaw encuu pakan paka efinkayonkalam ti ekaay óo ekaay. ");
INSERT INTO krx_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Fiye kaay, concoolan pakati kikaw ka pakati Israyel insokii nii Ateeteyo, Pútuun pa piti símaamayii, piti Abraham, piti Isaak niŋ piti Jakob púfulii ti awe mpusoki: 'Sincanaasincan incuk eeha pakati Esipt nkayem ha ti íhinu aluu. ");
INSERT INTO krx_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Inci sok nii, inci fáfulan aluu ti mah ma miti Esipt la nkayem la aluu ti kaakallan. Fasilan aluu ti mah ma miti pakati Kanaan, miti pakati Het, miti pakati Amol, miti pakati Pelis, miti pakati Hiw niŋ miti pakati Yepus, mah meemeeŋe keekee niŋ múkum.' ");
INSERT INTO krx_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Pakati kikaw ka pakati Israyel éfikasiitani. Fiye aafakaay neyii pati amansa ya ati Esipt innisokoo: 'Ateeteyo Pútuun pa piti Pihiburu pa píyisanooliye toonii. Káluma, katan unii upukaay, efuusapal ñoota fo kunoom káhaaciil ti káahaaŋ ka tes kati uwaaseen po.' ");
INSERT INTO krx_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Pale inci méyimeyi nii amansa ya ati Esipt atakatan aluu fo taamanta epees eenapa enaŋutee teyoo. ");
INSERT INTO krx_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ekina ewune inci fápantin epeesam insap pakati Esipt niŋ weecukantee púlooŋ ewwa inci inkaakaay íhinu hátikinii niŋ fúlaa toko afaakatan aluu nipikaay. ");
INSERT INTO krx_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Inci fáhin kitaaluu kúpusuum pakati Esipt, ancuk niŋ niyeniyaa pikaayu etinikaay sipees ñaanii. ");
INSERT INTO krx_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Hinoom eehuu, aal óo aal taaluu afaakaay pati akinooloo aal ati Esipt niŋ ekaawoola ya pakaal paka keeyem ka lateyoo naacakanii wañ niŋ waah óo waah weememanoolee niŋ sanoo niŋ ekina tom kótifoloo. Efiniwas wo epuuk aluu, fiyuu efinicoop hisaanumate ha hiti pakati Esipt.” ");
INSERT INTO krx_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Móyiis nene añahan Pútuun pa: “Pale niŋ pakati Israyel káyinanutam me? Pikee pa étikasiitanam nkasokam: 'Ateeteyo áfuliyoot ti awe.'” ");
INSERT INTO krx_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ateeteyo naasokoo: “Weyme uyem ti epeesi?” Naañahanoo: “Hikasap.” ");
INSERT INTO krx_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Naasokoo: “Want ho t’etaam!” Móyiis naawant ho t’etaam. Hikasap ha níhiyesoonii epululoola. Móyiis naatey ápilaaŋ yo. ");
INSERT INTO krx_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Pale Ateeteyo naasokoo: “Ñáakanii epeesi incok yo ti híyeeni.” Móyiis naañaakan epeesoo naacok yo, epululoola ya néeyenoonii hikasap ti epeesoo. ");
INSERT INTO krx_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ateeteyo naasokoo: “Eehuu áafahin kati káyinan nii inci fúlii taawe, inci Ateeteyo Pútuun pa piti símaamayii, piti Abraham, piti Isaak niŋ piti Jakob.” ");
INSERT INTO krx_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Nene asok Móyiis: “Nakan epeesi ti hísool ha hitii henfakat ha ti púsusi.” Móyiis náahin fo, pale ta náafulanii ta epeesoo neemeeŋ niŋ kanuk, néeyaañ éheelinoolo. ");
INSERT INTO krx_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ateeteyo naasokoo: “Ñahan epeesi ti hísool ha hitii henfakat ha ti púsusi.” Naañahan epeesoo, ta náafulanii yo ta neeñoho samat nii fa neeyeniye fa. ");
INSERT INTO krx_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ateeteyo naasokoo: “Niŋ pakati Israyel káyinanuti niŋ ekina tom katahut kunuuwii ti píyisan pa píyaañ pa, éfikayinani kamma píyisan pa púsupiyenu pa. ");
INSERT INTO krx_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Niŋ káyinanuti kamma píyisan pa píyaañ pa niŋ púsupiyenu pa niŋ ekina tom kásiitanuti, yook ti man ma miti musuu ma miti Nil inniis mo t’etaam. Man emmuu éfimiyesoonii hísim.” ");
INSERT INTO krx_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Móyiis naasok Ateeteyo: “Ati Pútuun, ponketam, inci taapala yeno eesuusa ti káakup, ántuŋ yénooniyoot oonool kápiliŋ emma áyyaañe káakup niŋ inci, amiikan a atii. Inci éekote ti káakup inkuut.” ");
INSERT INTO krx_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ateeteyo naasokoo: “Ayme awufane an putum? Ayme áhinoo apucoto niŋ ekina tom múmune? Ayme awufanoo ñíkin niŋ ekina tom náafuumanoo? Fo inci tom, inci Ateeteyo? ");
INSERT INTO krx_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Fiye kaay! Niŋ aayeniyaa káakup inci fayeno niŋ awe, inci fáyisani eeha aññaŋe ha hisoku.” ");
INSERT INTO krx_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Móyiis naasokoo: “Ati Pútuun inci luumuu, poñ akee!” ");
INSERT INTO krx_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Fiye Ateeteyo náañiken ti Móyiis naasokoo: “Fo púnuwi me Aaron ati miin ma miti Lewi? Inci méyimeyi nii ásuusisuusi ti káakup. Oopa ti ékey taawe, niŋ acukuu éfisuumoo. ");
INSERT INTO krx_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Aáfakup neyoo, insokoo eeha naañaŋe ha hisoku. Inci fayeno niŋ aluu t’ésupak aluu niŋ niyeniyaa káakup, íyyisan aluu eeha inniñaŋe ha íhinu. ");
INSERT INTO krx_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Akina afaayeno ákupa ya atii hátikin pakan paka. Samat nii fa Pútuun pa mpuwufan fa ekooŋan piyaamakoola etempo, fo lompo aafawufan Aaron ekooŋan. ");
INSERT INTO krx_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Hikasap eehe, sík ho ti epeesi, neeho áafaninhin píyisan.” ");
INSERT INTO krx_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Móyiis naañoho pati aasonoo Yetulo naasokoo: “Káluma, katanam puñoho pati pakanam keeyem ka Esipt pisincan man kaloŋaa kaloŋa.” Yetulo naañahanoo: “Iyyoo, col kásuumaay.” ");
INSERT INTO krx_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ta Móyiis naaloŋe ta ti mah ma miti Mitiyan, Ateeteyo naasokoo: “Kaay, ñoho Esipt kaatuko kéelafiyuu ka púlooŋ himuku kaketaaket.” ");
INSERT INTO krx_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Móyiis naacoop aaloo niŋ pikampaani pa pakateyoo naalapanii ti fáli, naañoho ti mah ma miti Esipt. Móyiis náasik hikasap ha hiti Pútuun pa ti epeesoo. ");
INSERT INTO krx_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Ateeteyo naasok Móyiis: “Inci ufanuuwufan kayine kiti íhinu weecukantee. Niŋ aañohiyaa Esipt, ínhin wo hátikin amansa ya. Pale inci fáhin apiyank ekun, ancuk atakatan pakati Israyel kapikaay. ");
INSERT INTO krx_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Fiye aafasokoo: 'Ehe eeha Ateeteyo naasoke ha: miin ma miti Israyel miyem añiinam akampaani ácook. ");
INSERT INTO krx_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Inci sokuusok: \"Katan añiinam akampaani apikaay kati awaaseenam.\" Pale ampook; fiye inci famuk añiini akampaani ácook a.'” ");
INSERT INTO krx_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Poko ti pítin pa nkacol lakeenaay kati káyekunoolo, Ateeteyo náafulii ti Móyiis, naaŋes himukuyoo. ");
INSERT INTO krx_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Fiye aaloo Sipola naacoop énankiin eeliyanee naanakan añiinoo, naacoop cífiitiin kapaŋ enka naafiite ka náalik nenco woot Móyiis naasokoo: “Fiye áayenooniyoo áyiinam ati hísim.” ");
INSERT INTO krx_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Fiye Ateeteyo naakatan Móyiis. Tempo Sipola naasoke: “Ayíinam ati hísim” kamma kanakan ka. ");
INSERT INTO krx_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Eehuu ti pitaako, loho Ateeteyo apayaa hisoku Aaron: “Kaay ti káahaaŋ ka tes kaapaakoolan Móyiis.” Aaron naakaay, naatoopoo ti tíntiŋ ya eti Pútuun pa, naasumpooloo. ");
INSERT INTO krx_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Móyiis naakaman Aaron eeha púlooŋ Ateeteyo naapoñoo ha kati asok niŋ píyisan empa naasokoo pa kati náhin. ");
INSERT INTO krx_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Móyiis niŋ Aaron nkakaay nkaconcoolan pakati kikaw ka pakati Israyel. ");
INSERT INTO krx_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaron naasokii eeha púlooŋ Ateeteyo naasoke ha Móyiis. Púful toko, náahin píyisan pa hátikin pakan paka, ");
INSERT INTO krx_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","nkáyinan. Ta nkásiye ta nii Ateeteyo acukaacuk kúnuul ka kiti pakati Israyel náakey kayankananii, nkákilipo ñuhooŋuyii t’etaam. ");
INSERT INTO krx_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Púful toko, Móyiis niŋ Aaron nkakaay pati amansa ya nkasokoo: “Ehe eeha Ateeteyo Pútuun pa piti Israyel mpusoke ha: 'Katan pakanam kapikaay, kati káhin pahaaño ti caacawam pati káahaaŋ ka tes.'” ");
INSERT INTO krx_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Amansa ya naañahanii: “Ayme ayem Ateeteyo inci kati síitanoo inkatan pakati Israyel kapikaay? Míit Ateeteyo niŋ fúlaa toko etikatan pakati Israyel kapikaay.” ");
INSERT INTO krx_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Móyiis niŋ Aaron nkasokoo: “Ateeteyo Pútuun pa piti unii Pihiburu pa píyisanooliye toonii. Katan unii upukaay hak kasapal kunoom káhaaciil ti káahaaŋ ka tes upuwaaseen Pútuun pa putoonii. Niŋ unii úhinut ho efipumuk unii niŋ úkuuñu niŋ ekina tom niŋ káakuntu.” ");
INSERT INTO krx_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Amansa ya ati Esipt naasokii: “Móyiis niŋ Aaron, weyme uwune ínnilafi káfulan pakati Israyel ti páhin pa piteyii? Níful le inniñoho ti páhin pa pitaaluu! ");
INSERT INTO krx_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Nísiitan! Payenkuu kámeeŋiyoomeeŋ ti mah me, ínnilafi kapikatan páhin pa piteyii!” ");
INSERT INTO krx_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Oom hinoom, amansa ya náakup niŋ pufaasa pa pakati Esipt payenka nkafaas ka pimiikan pa pakati Israyel niŋ lompo ñíhampaatiin ña pakati Israyel payenka pufaasa pa nkamamale ka kati káwasum pakanii ti himiikanate ha hiteyii. Naasokii: ");
INSERT INTO krx_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Timpi nene niwufanii hikaaw hiti hiñaku pípilikoo samat nii fa inniyem fa ti íhinu fo fíyooy. Kakaay kápicakaŋesii ho poko himuumii. ");
INSERT INTO krx_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Pale kañak pípilikoo empa nkañak pa hinak óo hinak, timpi níkaasinii waah. Kakuuñaakuuñ, ekina ewune nkáyemi ti hiceeku: 'Katan unii upukaay kati uwaaseen Pútuun pa putoonii.' ");
INSERT INTO krx_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Níhin páhin pa piteyii pipihaŋ mpiseeñe; niŋ pimeeŋaa teyii, etikataakano káasiitan kincaam.” ");
INSERT INTO krx_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Pufaasa pimiikan pa niŋ ñíhampaatiin ña pakati Israyel nkáful incakasok pakan paka: “Ehe eeha amansa ya ati Esipt naasoke ha: 'Inci etinene ufan aluu hikaaw. ");
INSERT INTO krx_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Aluu himuum aluu cániŋesii hikaaw pan óo pan inniyina ho étaakii. Apan niñaŋaa hiñaku pípilikoo samat nii fa innitaak fa kúcook kuu. Háati waah étuukaasino toko.'” ");
INSERT INTO krx_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Fiye pakati Israyel nkahancaloolo pan óo pan ti mah ma miti Esipt hiŋes pútowintiin hikaaw. ");
INSERT INTO krx_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Pufaasa pa nkayeno pusonii, nkayeniyii hisoku: “Nihankan páhin pa samat nii fa ínnihin fa hinak óo hinak ta inniwufanee ta hikaaw.” ");
INSERT INTO krx_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Nkasap ñíhampaatiin ña pakati Israyel payenka nkamamale ka kati káwasum pakanii, nkasokii: “Weyme uwune niñakut hukan niŋ fíyooy pípilikoo empa inniñak pa púcook pa?” ");
INSERT INTO krx_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Fiye ñíhampaatiin ña pakati Israyel nkakaay pukooŋ eehuu pati amansa ya nkasokoo: “Weyme uwune áyyemi unii ti íhinu eehuu, unii pimiikan pa pakatii? ");
INSERT INTO krx_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Kawufanantoo unii fiye hikaaw, háati fo, nkáyemi unii ti hisoku: 'Uñak pípilikoo!' Apan nkasap unii. Pakani kalaahaalaah unii.” ");
INSERT INTO krx_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Amansa ya naañahanii: “Aluu ñifuta, nikuuñaakuuñ! Tempo wune ínniyemi ti hisoku: 'Ukaayaa kaawaaseen Ateeteyo.' ");
INSERT INTO krx_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Fiye níful nipikaay páhin, an atanene awufan aluu hikaaw apan niñaŋaa hiñaku pípilikoo samat nii fa inniñak fa púcook pa.” ");
INSERT INTO krx_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ñíhampaatiin ña pakati Israyel, ta nkásiye ta eehuu, nkámeyi nii ti páciite nkayem, kamma nkasokii nii: “Etínikaasinee pípilikoo empa inniñak pa hinak óo hinak.” ");
INSERT INTO krx_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Nkáful lati amansa ya, nkapaakool niŋ Móyiis niŋ Aaron keeyeniyii ka hítuulu. ");
INSERT INTO krx_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Nkasok Móyiis niŋ Aaron: “Ateeteyo acukaacuk eeha inniyem ha ti íhinu, álimaati áhin unaa kíiti. Aluu niwune amansa ya niŋ píhina pa pakateyoo nkahaŋ nkanate unii. Inniwunii la éfikatii kati kamuk unii.” ");
INSERT INTO krx_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Fiye Móyiis naañoho pati Ateeteyo naasokoo: “Ati Pútuun, weyme uwune ankancool niŋ payenke? Weyme uwune ímpoñiyam le? ");
INSERT INTO krx_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Emma inci inkaaye ma pati amansa ya pusokoo eeha ansoke ha, naahaŋ naayokane pakani. Awe hínut waah aakati fakanii.” ");
INSERT INTO krx_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ateeteyo naañahan Móyiis: “Fiye aafacuk eeha inci inkaakaay ha íhinu amansa ya. Panape epeesam efipuwun naakatanii kapikaay, panape epeesam lompo efipuwun naayaanii ti mah ma miteyoo.” ");
INSERT INTO krx_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Pútuun pa nene pusok Móyiis: “Inci yem Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Inci yísanooliye ti Abraham, ti Isaak, niŋ ti Jakob nii inci yem 'Pútuun pa piti sempe sa púlooŋ'. Pale sokutii caacawam 'Ateeteyo'. ");
INSERT INTO krx_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ti caanak ca citeyii, nkayeno ekaawoola ti mah ma miti Kanaan, illiil neyii písiyool nii inci fawufanii mah emmuu. ");
INSERT INTO krx_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Inci síyaasi fiye hiliku ha hiti pakati Israyel, payenka pakati Esipt nkacoke ka pimiikan, ínnawuno písiyool pa putoom niŋ poko. ");
INSERT INTO krx_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Ekina ewune aafakaay sok pakati Israyel: 'Inci yem Ateeteyo, inci fáfulan aluu ti himiikanate ha ti pakati Esipt iyyihan aluu ti pitiyo pa empa nkatiyane pa aluu. Inci fáseepin epeesam insiiŋanii ti pisiya penfakat, infakan aluu. ");
INSERT INTO krx_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Inci fáhin nipiyeno pakanam, inci iyyeno Pútuun pa pitaaluu. Tempo éfinimeyi nii inci yem Ateeteyo Pútuun pa pitaaluu, péefulanii pa aluu ti himiikanate ha ti pakati Esipt. ");
INSERT INTO krx_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Inci facoop aluu ti mah emma inci insintooliye ma kawufan Abraham, Isaak niŋ Jakob, inci fawufan mo aluu kati míyenoonii miti aluu. Inci yem Ateeteyo.'” ");
INSERT INTO krx_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Móyiis naakaasok eehuu pakati Israyel, pale kapaaliitoo kaatuko káwusenaawusen ti himiikanate ha heeseeñe ha. ");
INSERT INTO krx_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ateeteyo nene asok Móyiis: ");
INSERT INTO krx_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Kaay caasok amansa ya ati Esipt akatan pakati Israyel kápuful ti mah ma miteyoo.” ");
INSERT INTO krx_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Pale Móyiis naañahan Ateeteyo: “Sincan, niŋ pakati Israyel kásiitanutam, puume amansa ya áfaasiitanam, inci eeyinaat a káakup?” ");
INSERT INTO krx_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Fiye Ateeteyo naasok Móyiis niŋ Aaron: “Nikaay pati pakati Israyel niŋ amansa ya ati Esipt innisokii nii inci sokoo áfulan pakati Israyel ti mah ma miti Esipt.” ");
INSERT INTO krx_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Payenke kayem símaama sa siti miin ma miti Israyel: Epuuk pákayiin paka pakati Ruben, añii ya ácook a ati Israyel, kayem: Hanok, Pallu, Hesilon niŋ Kalimi. Ucaw ewwuu úyenoonii kifiinu ka kiti miin ma miti Ruben. ");
INSERT INTO krx_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Epuuk pákayiin paka pakati Simeyon kayem: Yemuyel, Yamin, Ohat, Yakin, Sohal niŋ Sawul. Sawul íññaa ateyoo ati Kanaan. Ucaw ewwuu úyenoonii kifiinu ka kiti miin ma miti Simeyon. ");
INSERT INTO krx_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ehe ucaw epuuk pákayiin paka pakati Lewi, nuukiicee samat nii fa nkapukee fa: Keeson, Kehat niŋ Melali. Lewi naaloŋ sitiil keme niŋ áwii niŋ kaat niŋ súsupak (137). ");
INSERT INTO krx_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Epuuk pákayiin paka pakati Keeson kayem: Lipeni niŋ Simeyi. Ucaw ewwuu úyenoonii kifiinu. ");
INSERT INTO krx_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Epuuk pákayiin paka pakati Kehat kayem: Amulam, Yisuhal, Hepolon niŋ Usiyel. Kehat naaloŋ sitiil keme niŋ áwii niŋ ŋaasuwan niŋ síhaaciil (133). ");
INSERT INTO krx_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Epuuk pákayiin paka pakati Melali kayem: Mahuli niŋ Musi. Ucaw ewwuu púlooŋ úyenoonii kifiinu ka kiti miin ma miti Lewi, nuukiicee samat nii fa nkapukee fa. ");
INSERT INTO krx_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amulam naasa asomfaafoo Yokepet, naapukoo pikampaani pákasupak: Aaron niŋ Móyiis. Amulam naaloŋ sitiil keme niŋ áwii niŋ kaat niŋ súsupak (137). ");
INSERT INTO krx_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Epuuk pákayiin paka pakati Yisuhal kayem: Kolah, Nefek niŋ Sikili. ");
INSERT INTO krx_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Epuuk pákayiin paka pakati Usiyel kayem: Misayel, Elisafan niŋ Sitili. ");
INSERT INTO krx_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron naasa Elisepa ámaacul a ati Aminatap niŋ Naason ahoopoo. Naapukoo epuuk pákayiin pakapaakiil, poko kayem: Natap, Apihu, Eleyasal niŋ Itamal. ");
INSERT INTO krx_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Epuuk pákayiin paka pakati Kolah kayem: Asil, Elekana niŋ Apiyasaf. Ucaw ewwuu úyenoonii kifiinu ka kiti miin ma miti Kolah. ");
INSERT INTO krx_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleyasal, akampaani ya ati Aaron naasa akee ti púmaacul pa pakati Putiyel. Naapukoo akampaani, caacawoo Pinehas. Payenkuu púlooŋ kayem símaama sa siti miin ma miti Lewi, an óo an niŋ miin ma miteyoo. ");
INSERT INTO krx_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Oom Aaron niŋ Móyiis kayem payenka Ateeteyo naasoke ka: “Nífulanii pakati Israyel ti mah ma miti Esipt samat nii uyoŋ uti pusoocaali.” ");
INSERT INTO krx_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Móyiis niŋ Aaron payenkuu kakaaye kapusok amansa ya ati Esipt kati akatan pakati Israyel kápuful ti mah ma miti Esipt. ");
INSERT INTO krx_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ehe heetaakiye ha ti hinoom eeha Ateeteyo náakupe ha niŋ Móyiis ti mah ma miti Esipt, ");
INSERT INTO krx_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","apusokoo: “Inci yem Ateeteyo, caasok amansa ya ati Esipt eeha púlooŋ inci insokuu ha niŋ eeha púlooŋ inci inkaakaayuu ha hisoku hátikin.” ");
INSERT INTO krx_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Móyiis naañahanoo: “Sincan, inci yinaat káakup, puume amansa ya áfaasiitanam?” ");
INSERT INTO krx_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Fiye Ateeteyo naasok Móyiis: “Sincan, inci hínuuhin samat nii Pútuun hátikin amansa ya, púnuwi Aaron afaayeno ayaamakoola ya atii. ");
INSERT INTO krx_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Aafasok púnuwi waah óo waah ewwa inci inkaakaayuu wa hisoku. Akina naasok wo amansa ya ancuk akatanaa pakati Israyel kápuful ti mah ma miteyoo. ");
INSERT INTO krx_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","4","Pale inci fáhin amansa ya apiyank ekun; átasiitan aluu, háati inci ínhin hícump píyisan niŋ weecukantee ti mah ma miti Esipt. Inci fáyisan pakati Esipt sempe sa siti epeesam, insiiŋanii ti pisiya penfakat, ínfulanii pakanam pakati Israyel ti mah ma miti Esipt samat nii uyoŋ uti pusoocaali. ");
INSERT INTO krx_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Pakati Esipt éfikameyi nii inci yem Ateeteyo; niŋ inci séepinaa epeesam pinaŋ yo teyii, ínfulanii pakati Israyel ti mah ma miteyii.” ");
INSERT INTO krx_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Móyiis niŋ Aaron nkáhin samat nii fa Ateeteyo naasokii fa. ");
INSERT INTO krx_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ta nkákupe ta niŋ amansa ya, tempo Móyiis ti sitiiloo áwii epaakiil (80), Aaron sitiil áwii epaakiil niŋ síhaaciil (83). ");
INSERT INTO krx_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ateeteyo naasok Móyiis niŋ Aaron: ");
INSERT INTO krx_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Niŋ amansa ya asokaa aluu níhin heecukantee, awe Móyiis, insok Aaron acoop hikasap ha hiteyoo naawant ho t’etaam hátikin amansa ya. Hikasap ha éfihiyesoonii epululoola.” ");
INSERT INTO krx_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Fiye Móyiis niŋ Aaron nkakaay pati amansa ya nkáhin eeha púlooŋ Ateeteyo naasokii ha. Aaron naawant hikasap ha hiteyoo hátikin amansa ya niŋ píhina pa pakateyoo, níhiyesoonii epululoola. ");
INSERT INTO krx_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Amansa ya naapoñ kápiyonkalii keeyanfe ka kikaw niŋ púpatuuta pa pakati Esipt, lompo káhin moonool muu ti payanfii. ");
INSERT INTO krx_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","An óo an teyii naawant hikasap ha hiteyoo, níhiyesoonii epululoola. Pale hikasap ha hiti Aaron nihimelan kikasap ka kiteyii. ");
INSERT INTO krx_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Háati fo, amansa ya naayank ekun, ásiitanut Móyiis niŋ Aaron samat nii fa Ateeteyo naasoke fa hínum. ");
INSERT INTO krx_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Púful toko, Ateeteyo naasok Móyiis: “Amansa ya ayankaayank ekun, apookaapook kakatan pakan paka kapikaay. ");
INSERT INTO krx_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Fiye kacom mpucom kaay pati amansa ya. Niŋ ayeniyaa pikaayu ti musuu ma miti Nil, siiŋo ti kantant ka kiti musuu ma íntuuloo. Incok ti epeesi hikasap ha heeyesanee ha hínum epululoola. ");
INSERT INTO krx_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Insokoo: 'Ateeteyo Pútuun pa piti unii Pihiburu pa púpoñiyaam kati soki: \"Katan pakanam kati kakaay kapuwaaseenam ti káahaaŋ ka tes,\" pale fo fiye ampook káasiitan. ");
INSERT INTO krx_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ehe eeha Ateeteyo naasoke ha: \"Tempe áafameyi nii inci yem Ateeteyo. Inci fasap man ma miti musuu ma miti Nil niŋ hikasap ha heeyem ha ti epeesam ímmiyesoonii hísim. ");
INSERT INTO krx_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Soon sa efisiket, musuu ma ummufut, pakati Esipt étikayini pálaani man ma.\"'” ");
INSERT INTO krx_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ateeteyo nene asok Móyiis: “Sok Aaron: 'Coop hikasap ha hitii, ímpantin epeesi ti man ma miti Esipt: musuu ma, kiyanu ka niŋ púñowuma pa, man emmuu púlooŋ éfimiyesoonii hísim.' Hísim efihiyeno pan óo pan ti mah ma miti Esipt, efihiyeno lompo ti pupulaatu pa peewucee pa niŋ ti pipala pa piti pínankiin pa.” ");
INSERT INTO krx_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Móyiis niŋ Aaron nkáhin eeha Ateeteyo naasoke ha. Aaron náaseepin hikasap ha hiteyoo, naasap ho ti man ma miti musuu ma miti Nil hátikin amansa ya niŋ píhina pa pakateyoo, man ma púlooŋ ímmiyesoonii hísim. ");
INSERT INTO krx_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Soon sa insiket, musuu ma ummufut meemak fo pakati Esipt nkayinaat mo pálaani. Hísim nihiyeno pan óo pan ti mah ma miti Esipt. ");
INSERT INTO krx_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Pale púpatuuta pa pakati Esipt nkáhin moonool muu niŋ payanf pa piteyii. Amansa ya naayank ekun ásiitanut Móyiis niŋ Aaron samat nii fa Ateeteyo naasoke fa hínum. ");
INSERT INTO krx_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Impúunoo teyii, naawufanii pusonoo naayet pateyoo, atahut kunuu ti eehuu. ");
INSERT INTO krx_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Pakati Esipt púlooŋ nkayeno kaawak mísaapun ti kantant ka kiti Nil kati kataak man meenape, kaatuko kayinaat pálaani man ma miti musuu ma. ");
INSERT INTO krx_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Kunoom isak niŋ kúsupak nkumuus ta Ateeteyo naasape ta musuu ma miti Nil. ");
INSERT INTO krx_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Púful toko, Ateeteyo nene asok Móyiis: “Kaay pati Amansa ya insokoo: 'Ehe eeha Ateeteyo naasoke ha: \"Katan pakanam kapikaay kati kawaaseenam. ");
INSERT INTO krx_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Síitan, niŋ aapookii kakatan kapikaay, inci fáwananii hítaapanu hiti puhoon ti mah ma mitii púlooŋ. ");
INSERT INTO krx_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Musuu ma miti Nil efimimeeŋ niŋ puhoon. Efipinako ti ékinuma ya etii, ti ékaap ya etii niŋ ti ecunkun ya etii, efipinako lompo ti pukumpaan pa piti píhina pa pakatii niŋ piti pakani púlooŋ, niŋ ti púsowuma kúmpuul ka niŋ la nkasap la efol ya. ");
INSERT INTO krx_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Puhoon pa efipunuutal ti awe, ti pakani niŋ ti píhina pa pakatii púlooŋ.\"'” ");
INSERT INTO krx_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ateeteyo naasok Móyiis: “Sok Aaron ásik hikasap ha hiteyoo náapantin epeesoo ti musuu ma, ti kiyanu ka niŋ ti púñowuma pa, náahin puhoon pa púpufulii mpisilo ti etaam ya eti Esipt.” ");
INSERT INTO krx_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Fiye Aaron náapantin epeesoo ti man ma miti Esipt púlooŋ, puhoon pa mpúfulii mpúwufalool etaam ya. ");
INSERT INTO krx_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Pale púpatuuta pa pakati Esipt nkáhin moonool muu niŋ payanf pa piteyii, nkáfulanii lompo puhoon ti etaam ya eti Esipt. ");
INSERT INTO krx_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Amansa ya naapoñ kápiyonkalii Móyiis niŋ Aaron kápikey. Ta nkácolii ta, naasokii: “Niluum Ateeteyo ápufulan puhoon pa ti inci niŋ ti pakanam, inci inkatan pakan aluu kapikaay kati kawaaseen Ateeteyo.” ");
INSERT INTO krx_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Móyiis naasok amansa ya: “Iyyoo, awe yem ati hikaw ha, sokam teyme inci faluum kitii, kiti píhina pa pakatii niŋ kiti pakani, puhoon pa kati púful ti awe niŋ ti pukumpaan pa pitii, mputowo lamma ti musuu ma miti Nil.” ");
INSERT INTO krx_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Amansa ya naañahanoo: “Luum kutoom kacom.” Móyiis naasokoo: “Iyyoo, inci fáhin samat nii fa ansoke fa. Tempo áafameyi nii taakut pikee pútuun samat nii Ateeteyo Pútuun pa putoonii. ");
INSERT INTO krx_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Puhoon pa efipikatani niŋ pukumpaan pa pitii, píhina pa pakatii niŋ pakani. Efiputowo lamma ti musuu ma miti Nil.” ");
INSERT INTO krx_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Púful toko, Móyiis niŋ Aaron nkáful lati amansa ya. Móyiis naayonkal Ateeteyo ti pukooŋ kayankanan, kati áfulan puhoon empa náatahii pa ti amansa ya. ");
INSERT INTO krx_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ateeteyo náahin eeha Móyiis naaluume ha. Puhoon pa mpiket ti pukumpaan pa, ti kank ka niŋ ti ukit wa. ");
INSERT INTO krx_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Nkácumpool po ti hícump kucuus, mah ma ummufut. ");
INSERT INTO krx_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ta amansa ya naacuke ta nii mah ma miyihaayih ti puhoon pa, nene ayank ekun, ásiitanut Móyiis niŋ Aaron samat nii fa Ateeteyo naasoke fa hínum. ");
INSERT INTO krx_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ateeteyo naasok Móyiis: “Sok Aaron áseepin hikasap ha heeyem ha ti epeesoo naasap esiya ya. Haafol ha éfihiyenoonii pusos ti mah ma miti Esipt púlooŋ.” ");
INSERT INTO krx_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Eehuu nkáhine: Aaron náaseepin epeesoo naasap esiya ya niŋ hikasap ha, haafol ha púlooŋ hiti mah ma miti Esipt níhiyesoonii pusos. Mpiyeno ti pakan paka niŋ ti púlukuleen pa. ");
INSERT INTO krx_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Púpatuuta pa pakati amansa ya nkayoop éfulanii pusos niŋ payanf pa piteyii, pale kayinaat. Pusos pa mpiyeno ti pakan paka niŋ ti púlukuleen pa. ");
INSERT INTO krx_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Fiye púpatuuta pa nkasok amansa ya: “Aŋe epees Pútuun pa.” Pale amansa ya naayank ekun ásiitanutii samat nii fa Ateeteyo naasoke fa hínum. ");
INSERT INTO krx_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ateeteyo naasok Móyiis: “Kacom mpucom mic illito aapikaay pati amansa ya; niŋ ayeniyaa puwano ti kantant ka kiti Nil, insiiŋo hátikinoo insokoo: 'Ehe eeha Ateeteyo naasoke ha: \"Katan pakanam kapikaay kati kawaaseenam. ");
INSERT INTO krx_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Niŋ aakatanutii kapikaay, inci fáwananii púcuwa ti awe, ti píhina pa pakatii, ti pakan paka pakatii niŋ ti pukumpaan pa pitii. Pukumpaan pa piti pakati Esipt efipimeeŋ púcuwa, mpúwufalool etaam ya. ");
INSERT INTO krx_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Pale oom hinoom, étilik mah ma miti Kosen la pakanam nkayem la. Toko etitaak púcuwa, aakati méyi nii inci yem Ateeteyo, inci oopa ti mah emme. ");
INSERT INTO krx_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Inci fákatinool picaaŋ cataŋ pakanam niŋ pakani. Píyisan empe efipitaako kacom.\"'” ");
INSERT INTO krx_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ateeteyo náahin ho, náawananii hícump púcuwa, ti ekumpaan ya eti amansa ya niŋ ti pukumpaan pa piti píhina pa pakateyoo, mah ma miti Esipt púlooŋ immiliiñool kamma púcuwa pa. ");
INSERT INTO krx_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Amansa ya naapoñ kápiyonkalii Móyiis niŋ Aaron kápikey. Ta nkácolii ta, naasokii: “Nikaay caniwaaseen Pútuun pa pitaaluu pale níhin ho leti mah me.” ");
INSERT INTO krx_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Móyiis naañahanoo: “Naput úpuhin ho le, kaatuko aŋa nuuwaaseen a Ateeteyo Pútuun pa putoonii, aŋuu meeñeya ti pakati Esipt. Niŋ unii uwaaseenaa hátikin pakati Esipt waah uti meeñeya, efikamuk unii niŋ pukumpa. ");
INSERT INTO krx_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Fo usapal kunoom káhaaciil ti káahaaŋ ka tes, nuuwaaseen Ateeteyo Pútuun pa putoonii samat nii fa mpusoke fa unii.” ");
INSERT INTO krx_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Amansa ya naasokii: “Inci fakatan aluu nipica niwaaseen Ateeteyo Pútuun pa pitaaluu ti káahaaŋ ka tes, pale timpi nílaaŋan. Fiye niluum kutoom.” ");
INSERT INTO krx_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Móyiis naañahanoo: “Emma inci ínful ma leti awe, faluum Ateeteyo. Kacom áfaafulan púcuwa pa leti awe amansa yuu, ti píhina pa pakatii niŋ ti pakani. Pale timpi nene caakool unii impook kakatan pakati Israyel kapikaay kaawaaseen Ateeteyo.” ");
INSERT INTO krx_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Púful toko, Móyiis náaful lati amansa ya naakaay kaluum Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ateeteyo náahin eeha Móyiis naaluumoo ha. Púcuwa pa mpúful ti amansa ya, ti píhina pa pakateyoo niŋ ti pakanoo, háati écuwa etowiit. ");
INSERT INTO krx_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Háati fo fiyaaw, amansa ya nene ayank ekun naapook kakatan pakati Israyel kapikaay. ");
INSERT INTO krx_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Fiye Ateeteyo naasok Móyiis: “Kaay pati amansa ya insokoo: 'Ehe eeha Ateeteyo Pútuun pa piti unii Pihiburu pa mpusoke ha: \"Katan pakanam kapikaay kati kawaaseenam. ");
INSERT INTO krx_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Sincan, niŋ aapookii kakatan kapikaay intowiyii ti hicoku, ");
INSERT INTO krx_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","inci, Ateeteyo, fátahii hítaapanu káakuuñu ti púlukuleen pa pitaaluu púlooŋ: pufalinc pa, púfali pa, puñonkomoo pa, síis sa, písaacii pa niŋ pifil pa. ");
INSERT INTO krx_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Pale inci fákatinool púlukuleen pa piti pakati Esipt niŋ púlukuleen pa piti pakati Israyel, ancuk háati élukuleen yoonool ti piti pakati Israyel eteket!\"'” ");
INSERT INTO krx_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ateeteyo naacok teyme naakaakaay ho íhinu, naasok: “Kacom inci fáhin eehuu ti etaam ya eti Esipt.” ");
INSERT INTO krx_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Eti kacom eteyyo, Ateeteyo náahin eeha naasoke ha. Púlukuleen pa púlooŋ piti pakati Esipt mpiket, pale háati élukuleen yoonool eti pakati Israyel eketut. ");
INSERT INTO krx_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Amansa ya naapoñ pakan kapica káwencinool heetaakiye ha, nkacuk nii háati élukuleen yoonool eti pakati Israyel eketut. Pale amansa ya naayank ekun akatanut pakati Israyel kapikaay. ");
INSERT INTO krx_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ateeteyo naasok Móyiis niŋ Aaron: “Nimeeŋan sipees aluu niŋ píiha piti kísisu innikaay pati amansa ya, Móyiis kati awiisan po ti eyam ya hátikinoo. ");
INSERT INTO krx_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Efipihancaloolo mpíyenoonii haafol ti mah ma miti Esipt púlooŋ. Kúfuna enka nkíyenoonii musontuwaay éfikufulii ti pakan paka niŋ ti púlukuleen pa piti mah ma miti Esipt púlooŋ.” ");
INSERT INTO krx_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Fiye Móyiis niŋ Aaron incakataak píiha piti kísisu nkasiiŋo hátikin amansa ya, Móyiis naawiisan po ti eyam ya, kúfuna enka nkíyenoonii musontuwaay nkúfulii ti pakan paka niŋ ti púlukuleen pa. ");
INSERT INTO krx_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Púpatuuta pa kayinaat pisiiŋo hátikin Móyiis kamma kúfuna ka keeyem ka teyii niŋ ti pakati Esipt púlooŋ. ");
INSERT INTO krx_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Pale Ateeteyo náahin amansa ya apiyank ekun, ásiitanut Móyiis niŋ Aaron samat nii fa Ateeteyo naasoke fa hínum Móyiis. ");
INSERT INTO krx_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Ateeteyo naasok Móyiis: “Lito kacom mpucom mic inkaay insiiŋo hátikin amansa ya insokoo: 'Ehe eeha Ateeteyo Pútuun pa piti unii Pihiburu pa mpusoke ha: \"Katan pakanam kapikaay kati kawaaseenam. ");
INSERT INTO krx_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Kaatuko tempe inci fáwananii hítaapanu óo hítaapanu ti awe, ti píhina pa pakatii niŋ ti pakani, aakati méyi nii inci taakut ñoŋ ti etaam ya púlooŋ. ");
INSERT INTO krx_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Niŋ inci séepinaaseepin hínum epeesam kati wánanii ti awe káakuuñu kiti eket, anti cím ti etaam ya niŋ pakani. ");
INSERT INTO krx_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Pale inkatani aapuloŋ kati yísani sempe sa sitoom, caacawam incicoopee pan óo pan ti etaam ya. ");
INSERT INTO krx_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Pale awe intowo ti émakiyanoolo, impook kakatan pakanam kapikaay. ");
INSERT INTO krx_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ekina ewune kacom ti caanak ence, inci fánupanii hítaapanu etiil eti pitaali. Etiil eyyuu efeecuk nii pukumpul, pitaali peetaapala pitaako ti mah ma miti Esipt kápiliŋ ta immisiiŋanee fo hinoom ha hiti fíyooy. ");
INSERT INTO krx_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Fiye poñ kápucoopii púlukuleen pa pitii niŋ waah óo waah ewwa antaake ti ukit wa la efipifak. Niŋ inci núpaniyoo pitaali pa, efipumuk an óo an aŋa mpútookii pati ukit wa niŋ élukuleen óo élukuleen éenakaniyootee.\"'” ");
INSERT INTO krx_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Pakakee ti píhina pa pakati amansa ya nkafe kamma eeha Ateeteyo naasoke ha, nkahiliikan kapucoop pimiikan pa niŋ púlukuleen pa piteyii páhantuwa. ");
INSERT INTO krx_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Pale keepaaliit ka hilim ha hiti Ateeteyo nkakat ti ukit wa pimiikan pa pakateyii niŋ púlukuleen pa piteyii. ");
INSERT INTO krx_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ateeteyo naasok Móyiis: “Séepin epeesi patiila, pitaali pa kati púwanoonii ti mah ma miti Esipt púlooŋ: ti pakan paka, ti púlukuleen pa niŋ ti pasukal pa púlooŋ peeyem pa ti ukit wa ti mah ma miti Esipt.” ");
INSERT INTO krx_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Fiye Móyiis náaseepin hikasap ha hiteyoo patiila, Ateeteyo náakatanii ti etaam ya pasapal niŋ hileeŋ etiil niŋ pitaali. Fiyuu Ateeteyo náanupanii pitaali ti mah ma miti Esipt. ");
INSERT INTO krx_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Pitaali pa mpúnowalii pípinapoolii niŋ hileeŋ etiil. Pitaali pa mpunonk líŋ, empa pakati Esipt taapala kacuk kápiliŋ emma mah ma miti Esipt immisiiŋiye. ");
INSERT INTO krx_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ti mah ma miti Esipt púlooŋ, pitaali pa mpumuk waah óo waah weeyem ti ukit wa, mpumuk lompo pakan paka niŋ púlukuleen pa. Mpifiital punuun pa niŋ pasukal óo pasukal peeyem ti ukit wa. ");
INSERT INTO krx_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Pale ti mah ma miti Kosen la pakati Israyel nkayem la, toko lamma pitaali pa mpúnupiyoot. ");
INSERT INTO krx_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Amansa ya naapoñ kápiyonkalii Móyiis niŋ Aaron kápikey. Ta nkácolii ta naasokii: “Tempe inci muuyenaa. Ateeteyo ayem ti pánipani ya, inci niŋ pakanam unowe. ");
INSERT INTO krx_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Luum Ateeteyo pasapal etiil ya peehiñe pa niŋ pitaali pa kati pisiiŋo. Inci fakatan aluu nipikaay, etinene cok aluu.” ");
INSERT INTO krx_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Móyiis naañahanoo: “Emma inci ínful ma le ti saatee ya, fáseepin sipeesam puluum Ateeteyo, pasapal etiil ya efipisiiŋo, pitaali pa etinene púnupii, aakati méyi nii etaam ya eti Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Pale méyimeyi nii, awe niŋ píhina pa pakatii, fo fiye nifeyut Ateeteyo Pútuun pa.” ");
INSERT INTO krx_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Ti oom caanak, aŋa pitaali pa mpúpuce ya, ekina eyem pasukal pa píyaañ pa, kaatuko pikee pa pitaakaataak paliyal, pikee pa péeluufeene. ");
INSERT INTO krx_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Pale pikee pasukal pa, samat nii paasiit pa, púpuciit kamma mpífiisut éŋantii. ");
INSERT INTO krx_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Móyiis náaful lati amansa ya, náaful lompo ti saatee ya, náaseepin sipeesoo apuluum Ateeteyo. Fiye, Ateeteyo naasiiŋan pasapal etiil ya, pitaali pa niŋ etiil ya. ");
INSERT INTO krx_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ta amansa ya naacuke ta nii Ateeteyo asiiŋanaa-siiŋan etiil ya, pitaali pa niŋ pasapal etiil ya, nene amuuyen. Akina niŋ píhina pa pakateyoo nene kayank ekun. ");
INSERT INTO krx_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Amansa ya naatowo ti payank ekun, naapook kakatan pakati Israyel kapikaay samat nii fa Ateeteyo naasoke fa hínum pínapii ti Móyiis. ");
INSERT INTO krx_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Púful toko Ateeteyo naasok Móyiis: “Kaay pati amansa ya, kaatuko inci hínoo apiyank ekun, akina niŋ píhina pa pakateyoo, inci kati ínhin píyisan pa putoom ti pututayii. ");
INSERT INTO krx_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Fiyuu áafayini kakaman epuuki niŋ keesokuu maamaa fa inci úwwiiniyane fa pakati Esipt, niŋ píyisan empa inci ínhine pa ti pututayii, ancuk nimeya nii inci yem Ateeteyo.” ");
INSERT INTO krx_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Móyiis niŋ Aaron nkakaay pati amansa ya nkasokoo: “Ehe eeha Ateeteyo Pútuun pa piti unii Pihiburu pa mpusoke ha: 'Fo teyme aafapook ewananoolo hátikinam? Katan pakanam kapikaay kati kawaaseenam. ");
INSERT INTO krx_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Sincan, niŋ aapookaa kakatanii kapikaay, kacom inci fápoñii pukoskos ti mah ma mitii. ");
INSERT INTO krx_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Efipimeeŋ meemak ti mah ma mitii fo an atacuk esiya ya. Efipili waah óo waah ewwa pitaali pa mputowane wa, mpili lompo punuun pa pitaaluu púlooŋ péeŋantii pa ti ukit wa. ");
INSERT INTO krx_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Efipimeeŋ ti pukumpaan pa pitii, pukumpaan pa piti píhina pa pakatii niŋ pukumpaan pa piti pakati Esipt púlooŋ. Efihiyeno hítaapanu eeha ammeya nii háati ñífaaf aluu niŋ símaama aluu kataapala kacuk emma nkakine ti mah emme fo fíyooy.'” Ta Móyiis naapaye ta káakup, náaful lati amansa ya naakaay. ");
INSERT INTO krx_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Píhina pa pakati amansa ya nkasokoo: “Fo teyme áyiin a aŋe afaatowo ti hiwasu unaa kúnuul? Katan pakati Israyel kapikaay kati kawaaseen Ateeteyo Pútuun pa piteyii. Awe ñaasoŋi ayyem, fo áamiit nii mah ma miti Esipt múpucaapuco?” ");
INSERT INTO krx_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Fiye, nkáñahanii Móyiis niŋ Aaron pati amansa ya. Amansa ya naasokii: “Níyiniyini pikaayu kaawaaseen Ateeteyo Pútuun pa pitaaluu, pale pakayme kañaŋe pikaayu?” ");
INSERT INTO krx_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Móyiis naañahanoo: “Unii púlooŋ ukaakaay: uhiineen wa niŋ uhaan wa, epuuk ya pákayiin paka niŋ pakaal paka, písaacii pa, pifil pa niŋ síis sa, kaatuko uñaŋaa íhinu pahaaño piti Ateeteyo.” ");
INSERT INTO krx_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Amansa ya naasokoo: “Fo cukaacuk aluu nii, inci fasampan aluu ti caacaw Ateeteyo inkatan aluu nipikaay niŋ miin ma mitaaluu? Ooto heenaput ínnimiiloole! ");
INSERT INTO krx_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Haani, eehuu hiyinaat pitaako! Pákayiin paka lamma efikakaay kapica kawaaseen Ateeteyo samat nii fa inniluumaam fa.” Púful toko nkayaanii lati amansa ya. ");
INSERT INTO krx_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ateeteyo naasok Móyiis: “Pántin epeesi ti mah ma miti Esipt pukoskos pa púpuwanoonii temmo, kati puhoon waah óo waah weeŋante ti etaam ya ewwa pitaali pa mputowane wa.” ");
INSERT INTO krx_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Fiye Móyiis náapantin epeesoo niŋ hikasap ha hiteyoo ti mah ma miti Esipt, Ateeteyo náawananii hiyam héefulii pa caanak ca íncifulii pa, hipisap ti mah ma miti Esipt púlooŋ. Hiyam ha nihisap hanakan ha niŋ hánant ha púlooŋ. Cipilap, hiyam ha níhicoopoolii pukoskos. ");
INSERT INTO krx_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Pukoskos pa mpinako ti mah ma miti Esipt púlooŋ, mpunowal pan óo pan pipimeeŋ túk. Pameeŋ pukoskos empuu taapala pitaako, apan etinene pitaako. ");
INSERT INTO krx_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Mpúwufalool etaam ya púlooŋ fo neepaana. Mpuhoon waah óo waah weeyeniye ti ukit wa niŋ lompo ñaliyal ña ñiti punuun pa empa pitaali pa mputowane pa. Háati waah weeŋante utowiit ti etaam ya púlooŋ eti Esipt. ");
INSERT INTO krx_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Amansa ya naahiliikan apupoñ kápiyonkalii Móyiis niŋ Aaron kápikey. Ta nkácolii ta, naasokii: “Inci muuyenaamuuyen ti Ateeteyo Pútuun pa pitaaluu niŋ ti aluu faŋ aluu. ");
INSERT INTO krx_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Fiye, ponketam kaamuuyen ka kutoom poonool empe lamma, inniluum Ateeteyo Pútuun pa pitaaluu púpufulan eket eyye lamma ti inci.” ");
INSERT INTO krx_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Móyiis náaful lati amansa ya naaluum Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Fiye Ateeteyo naayesan hiyam ha ti hiyam henfakat héefulii pa caanak ca incinow pa, nihicoopool pukoskos pa nihiwant po ti Kaatii ka Kéecunke ka. Háati kaakoskos koonool kutowiit ti mah ma púlooŋ miti Esipt. ");
INSERT INTO krx_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Pale Ateeteyo náahin amansa ya apiyank ekun. Amansa ya naapook kakatan pakati Israyel kapikaay. ");
INSERT INTO krx_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ateeteyo naasok Móyiis: “Séepin epeesi patiila, énimaan enfakat kati eyeno ti mah ma miti Esipt, énimaan eyya ammeya nii an atacuk fo káamaaputool.” ");
INSERT INTO krx_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Móyiis náaseepin epeesoo patiila, énimaan enfakat neeyeno ti mah ma miti Esipt púlooŋ fo kunoom káhaaciil. ");
INSERT INTO krx_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ti kunoom ka káhaaciil enkuu, pakati Esipt kayinaat pucukool, an ayinaat hífulu lateyoo. Pale pakati Israyel púlooŋ nkataak ecaaŋ la nkakine la. ");
INSERT INTO krx_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Amansa ya naapoñ kápiyonkalii Móyiis ápikey. Ta náacolii ta, naasokoo: “Nikaay caniwaaseen Ateeteyo. Níyiniyini fala kaacoopool miin ma mitaaluu, pale nikat le písaacii pa, pifil pa niŋ síis sa sitaaluu lamma.” ");
INSERT INTO krx_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Móyiis naañahanoo: “Haani! Aañaŋaa kakatan unii upucoopool lompo púlukuleen empa efuuwaaseen pa Ateeteyo Pútuun pa putoonii: pikee púlukuleen pa, efuuwaaseen po kati piliyee, pikee pa nuuwaaseen po upusow po pipileem motic. ");
INSERT INTO krx_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Pukoolee pa putoonii piñaŋaa pikaayu noonii, háati yoonool etetowo le. Kaatuko ti púlukuleen pa efuucoop upuwaaseen Ateeteyo Pútuun pa putoonii apan étuumeyi empa nuukaakaay kaawaaseen taamanta ucolut po.” ");
INSERT INTO krx_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Háati fo, Ateeteyo náahin amansa ya apiyank ekun, amansa ya álafiit kakatan pakati Israyel kapikaay. ");
INSERT INTO krx_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Amansa ya naasok Móyiis: “Fúl le! Timpi néeñohoonii le aapisiiŋo hátikinam. Tah kunuu, hinoom eeha aafanene cuk puhooŋuyam aafaket!” ");
INSERT INTO krx_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Móyiis naañahanoo: “Samat nii fa ansoke fa, etinene ñóhoonii pisiiŋo hátikini.” ");
INSERT INTO krx_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ateeteyo naasok Móyiis: “Inci fápoñii hítaapanu hikelan ti amansa ya niŋ ti mah ma miti Esipt niŋ fúlaa toko afaakatan aluu nipikaay, naayaan aluu fala pántoon. ");
INSERT INTO krx_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Fiye kaay caasok pakati Israyel nii, áyiin óo áyiin niŋ aal óo aal acakan akinooloo ati Esipt waah óo waah weememanoolee niŋ sanoo niŋ ekina tom kótifoloo.” ");
INSERT INTO krx_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ateeteyo náahin kiti pakati Israyel kúpusuum pakati Esipt. Móyiis himuumoo, pakati Esipt nkátuuloo meemak focaa píhina pa pakati amansa ya. ");
INSERT INTO krx_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Móyiis naasok amansa ya: “Ehe eeha Ateeteyo naasoke ha: 'Mpisit inci fakaawool mah ma miti Esipt. ");
INSERT INTO krx_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Añii óo añii akampaani áyaañ ati mah ma miti Esipt afaaket, písik ti akampaani ya áyaañ a ati amansa ya, eekaakaay ya hitoonu elemeyu ya, fo ti ati amiikan a aal a aŋa nátuum a efol ya, focaa papukal pa píyaañ pa piti púlukuleen pa púlooŋ. ");
INSERT INTO krx_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Tempo, káacoolan kenfakat efikiyeno ti mah ma miti Esipt púlooŋ, heetaapala hitaako apan etinene hitaako. ");
INSERT INTO krx_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Pale ti pakati Israyel púlooŋ, háati eyen étehaw ti an niŋ ekina tom ti élukuleen. Fiyuu éfinimeyi nii inci Ateeteyo ínkatinool-kátinool pakati Esipt niŋ pakati Israyel.'” ");
INSERT INTO krx_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Móyiis nene asok amansa ya: “Píhina pa pakatii púlooŋ éfikakey ti inci nkákilipo hátikinam nkasokam: 'Fúl le, awe niŋ pakani púlooŋ keenapanuu ka.' Niŋ fúlaa toko inci inkaay.” Ta Móyiis naapaye ta hisoku eehuu, náaful lati amansa ya niŋ káñiken kenfakat. ");
INSERT INTO krx_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ateeteyo naasok Móyiis: “Amansa ya átasiitan aluu, ancuk inci kati penan weecukantee wa utoom ti mah ma miti Esipt.” ");
INSERT INTO krx_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Móyiis niŋ Aaron nkáhin weecukantee ewwuu púlooŋ hátikin amansa ya, pale Ateeteyo náahin amansa ya apiyank ekun naapook kakatan pakati Israyel kápuful ti mah ma miteyoo. ");
INSERT INTO krx_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Eehuu hipimuus, Ateeteyo náakup niŋ Móyiis niŋ Aaron ti mah ma miti Esipt, naasokii: ");
INSERT INTO krx_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Hiim eehe efihiyeno taaluu hiim ha híyaañ ha: hiim ha hícook ha hiti etiil ya etaaluu. ");
INSERT INTO krx_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Canisok kayoŋ ka púlooŋ kiti Israyel: 'Niŋ hiim ha hitaakaa kunoom ŋaasuwan, áyiin óo áyiin acoop miin ma miteyoo císaacii niŋ fotom cifil, hank óo hank élukuleen yoonool. ");
INSERT INTO krx_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Niŋ miin ma mufomut kati mipa hili élukuleen púmpuluŋ, mísiyool niŋ akinoolii eehaŋii ya hikolu, nkafin pakan puume, conko kamamal élukuleen eyya nkayina hili. ");
INSERT INTO krx_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Efinicoop cíceken císaacii niŋ fotom cíceken cifil citi etiil yoonool céehutut. ");
INSERT INTO krx_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Innimank co fo ti hinoom ha heewase ha ŋaasuwan niŋ kipaakiil ti hiim ha. Oom hinoom niŋ caanak ca cinowaa, pakan paka pakati Israyel púlooŋ kañaŋaa hitaaŋu púlukuleen pa. ");
INSERT INTO krx_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Nkacoop ti hísim ha nkanaaneen ti upii wa úsupak wa uti putum pa piti hunkut ha niŋ lentoo etempo la efikali la élukuleen ya. ");
INSERT INTO krx_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Efikasow efoofa ya oom hánant, nkali yo niŋ kúmpuul keetaakut leweñoo niŋ pahatal peesampa. ");
INSERT INTO krx_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Timpi nitaan efoofa ya, timpi nilacan yo. Pale efeesowee niŋ hikaw ha, woot wa niŋ niñow na. ");
INSERT INTO krx_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Timpi nitowan efuntank. Niŋ etowiyaa, eti kacom eteyyo mpucom innisow yo epileem motic. ");
INSERT INTO krx_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ehe fa efinili yo fa: samat nii an eememanooliye pikaayu. Efinicenk kuñowu aluu, inniwaso pisamata, ínnisik hikasap t’epees. Nili mpacas. Eehuu hiyem pahaaño pa piti Himuusu ha hiti Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“'Oom hánant inci famuusool mah ma miti Esipt, immuk akampaani óo akampaani ácook ti mah ma miti Esipt, niŋ lompo mufuun ma púlooŋ méeyiine ma míyaañ ma miti púlukuleen pa. Fiyuu inci fasiiŋan ti pisiya pínaati pa púlooŋ piti pakati Esipt, inci yem Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Pale ti pukumpaan pa la innikaakaay la econcoolo, hísim ha efihiyeno lánkamaasi. Niŋ inci yeniyaa kaasiiŋan ti pisiya pakati Esipt, inci facuk ho immuus kati nifak ti hítaapanu ha hiti himuku ha. ");
INSERT INTO krx_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ti ekaay óo ekaay, hinoom eehe hiñaŋaa piyeno hinoom hiti énawunoolo. Niñaŋaa ho pahaaño nípimakiyanam, inci Ateeteyo, pahaaño empe piñaŋaa pitaako etiil óo etiil fo eket maama.'” ");
INSERT INTO krx_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ateeteyo nene asok Móyiis niŋ Aaron: “Efinili kúmpuul keetaakut leweñoo fo kunoom isak niŋ kúsupak. Ti hinoom ha híyaañ ha niñaŋaa káfulan leweñoo ya ti pukumpaan pa pitaaluu. Kaatuko an óo an eeliye waah weetaake leweñoo písik ti hinoom ha híyaañ ha puwant ti hinoom ha heewase ha isak niŋ kúsupak, oom an añaŋee hiyaanu ti kayoŋ ka kiti Israyel. ");
INSERT INTO krx_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Hinoom ha híyaañ ha niŋ hinoom ha heewase ha isak niŋ kúsupak, efiniconcoolo nípimakiyanam. Etínihin ti kunoom enkuu niŋ neetaat kaamemanool paliyal. ");
INSERT INTO krx_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Efínihin pahaaño empe piti kúmpuul ka keetaakut ka leweñoo fo ti ekaay óo ekaay ti énawunoolo hinoom eeha inci ínfulanii ha aluu ti mah ma miti Esipt samat nii uyoŋ uti pusoocaali. Efinihaaño hinoom eehuu etiil óo etiil fo eket maama. ");
INSERT INTO krx_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Hiim ha híyaañ ha, písik ti kániim ka kiti hinoom ha heewase ha ŋaasuwan niŋ kipaakiil fo ti kániim ka kiti hinoom ha heewase ha áwii niŋ hoonool, efinili kúmpuul keetaakut leweñoo. ");
INSERT INTO krx_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Leweñoo eteyeno ti pukumpaan pa pitaaluu fo kunoom isak niŋ kúsupak. Niŋ akaawoola niŋ fotom ati Israyel aliyaa paliyal peetaake leweñoo, afaayaanee ti kayoŋ ka kiti Israyel. ");
INSERT INTO krx_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Niñaŋut hili waah weetaake leweñoo. Pan óo pan pa innikine, niñaŋaa hili kúmpuul keetaakut leweñoo.” ");
INSERT INTO krx_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Móyiis naayonkal ñíhampaatiin ña púlooŋ pakati Israyel naasokii: “Nikaay nicoop mísaacii niŋ fotom mifil innitaaŋ mo, ancuk miin ma mitaaluu mihaañiyaa pahaaño pa piti Himuusu ha. ");
INSERT INTO krx_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Nimemanool cikant citi mífiitiin miti píheeni empa nkasok pa hisop, ínnipuuc co ti epulaatu ya eetaake ya hísim ha hiti élukuleen ya, inninaaneen ho ti upii wa úsupak wa uti putum ekumpaan ya niŋ lentoo etempo. Oom hánant, an timpi áful tíkitaaŋ fo incilapaa. ");
INSERT INTO krx_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ateeteyo afaamuusool mah ma apumuk pakati Esipt, pale niŋ acukaa hísim ha ti lentoo putum pa niŋ upii wa afaamuus, atakat maleekoo ya eti himuku ha epinako pukumpaan pa pitaaluu neemuk aluu. ");
INSERT INTO krx_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Aluu niŋ miin ma mitaaluu éfinituul hilim ha heesiiŋanee ha hiti pahaaño empe fo cancowiyaaw. ");
INSERT INTO krx_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Niŋ ninakiyaa ti mah emma Ateeteyo náayinanane ma aluu nii afaawufan mo aluu, ínnihin pahaaño empuu. ");
INSERT INTO krx_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Niŋ epuuk aluu kacakanaa aluu: 'Pahaaño empe piti weyme?' ");
INSERT INTO krx_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Inniñahanii: 'Kaawaaseen kiti kámakiyan Ateeteyo, ti énawuno himuusu ha hiteyoo. Ta unaa pakati Israyel nuuyeniyaa ta Esipt, Ateeteyo náawananii eket ti pakati Esipt, pale naamuus pukumpaan pa putuunaa peesiiŋiit, naafakan miin ma mutuunaa.'” Ta nkásiye ta eehuu, pakati Israyel nkákilipo ñuhooŋuyii t’etaam. ");
INSERT INTO krx_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Púful toko nkakaay íncakahin eeha púlooŋ Ateeteyo naasoke ha Móyiis niŋ Aaron. ");
INSERT INTO krx_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Mpisit, Ateeteyo naamuk akampaani óo akampaani ácook ti mah ma miti Esipt, písik ti akampaani ya áyaañ a ati amansa ya, eekaakaay ya hitoonu elemeyu ya, fo ti ati eekulee ya ti ékuluma, focaa mufuun ma míyaañ ma miti púlukuleen pa púlooŋ. ");
INSERT INTO krx_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Oom hánant, amansa ya niŋ píhina pa pakateyoo púlooŋ niŋ pakati Esipt púlooŋ nkalito nkayeno káacoolan meemak kaatuko taakut ekumpaan eetaakut eekete. ");
INSERT INTO krx_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Oom hánant amansa ya naayonkal Móyiis niŋ Aaron kápikey. Ta nkácolii ta, naasokii: “Nilito! Níful ti mah ma mutoom, aluu niŋ pakati Israyel. Nikaay caniwaaseen Ateeteyo samat nii fa innisoke fa. ");
INSERT INTO krx_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Nicoopool lompo púlukuleen pa pitaaluu púlooŋ samat nii fa innisoke fa, innikaay. Inniluum lompo Pútuun pa pitaaluu kati pisampanam.” ");
INSERT INTO krx_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Pakati Esipt nkasok pakati Israyel kahiliikan kápuful ti mah ma, nkaŋiiniyii: “Niŋ nífulut ti mah me, unii púlooŋ efuuket.” ");
INSERT INTO krx_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Fiye pakati Israyel nkacoopool efol ya eyya nkapoocane ya, tempo peelokot kawas yo leweñoo. Nkánuŋ yo ti ñúus ña ñiteyii la nkasap la efol ya, nkacenk ño niŋ wañ wa uteyii nkakanto ño. ");
INSERT INTO krx_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Pakati Israyel nkáhin eeha Móyiis naasokii ha hínum, nkacakan pakati Esipt wañ niŋ waah óo waah weememanoolee niŋ sanoo niŋ ekina tom kótifoloo. ");
INSERT INTO krx_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Ateeteyo náahin kiti pakati Israyel kúpusuum pakati Esipt, nkawufanii waah óo waah ewwa nkacakanii. Fiyuu pakati Israyel nkacoope hisaanumate ha ti pakati Esipt. ");
INSERT INTO krx_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Púful toko pakati Israyel nkáful ti saatee ya eti Ramses kapuwant saatee ya eti Sukot, nkayeno máamun pákayiin síwuli sikeme isak niŋ yoonool (600,000), pakaal paka niŋ epuuk ya kafinutee. ");
INSERT INTO krx_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Pakakee pakan keemeeŋe keeneetaat pakati Israyel nkanapanii niŋ hícump pukoolee piti písaacii, pifil niŋ síis. ");
INSERT INTO krx_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Nkacoop efol ya eepoocanee ya eyya nkácoopoolii ya Esipt, nkasow kúmpuul keetaakut leweñoo; efol ya etaakut leweñoo kamma nkayaanee ti mah ma, kataakaniit kaamemanool paliyal. ");
INSERT INTO krx_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Ti oom caanak pakati Israyel nkakin hínum ti mah ma miti Esipt fo sitiil sikeme sipaakiil niŋ áwii niŋ ŋaasuwan (430). ");
INSERT INTO krx_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ta sitiil sa sikeme sipaakiil niŋ áwii niŋ ŋaasuwan ya insipaye ta, ti hinoom ha heemaka ha eehuu, kayoŋ ka kiti Ateeteyo púlooŋ nkúfule ti mah ma miti Esipt samat nii uyoŋ uti pusoocaali. ");
INSERT INTO krx_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Hánant eehuu nihiyeno hánant heemaka ti Ateeteyo hiti efaas pakanoo ápufulanii ti mah ma miti Esipt. Fo lompo incuke ti pakati Israyel, etiil óo etiil hánant eehuu hánant heemaka eeha nkañaŋut teeho hiŋotu kati kámakiyan Ateeteyo fo ti ekaay óo ekaay. ");
INSERT INTO krx_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ateeteyo naasok Móyiis niŋ Aaron: “Ehe hilim ha heesiiŋanee ha hiti pahaaño pa piti Himuusu ha: an eeneetaat ati Israyel timpi ali káciim ka kiti pahaaño pa. ");
INSERT INTO krx_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Pale amiikan eenoomee áyiniyini hili iyyema anakanee. ");
INSERT INTO krx_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Akaawoola eeyem ti himuusu niŋ ekina tom áhina aŋa nacooyee etikali. ");
INSERT INTO krx_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Efoofa ya ti ekumpaan efeeliyee, timpi nífulan yo tíkitaaŋ, timpi nihumalool háati kaacec koonool. ");
INSERT INTO krx_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Kayoŋ ka púlooŋ kiti Israyel éfikahin pahaaño pa. ");
INSERT INTO krx_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Niŋ akaawoola eewanane lataaluu álafiyaa íhinu pahaaño pa piti Himuusu ha piti Ateeteyo, pákayiin paka pakati ekumpaan ya eteyoo púlooŋ kañaŋee kanakan niŋ fúlaa toko áfaayini íhinu pahaaño pa piti Himuusu ha samat nii pakati Israyel. Afúl óo áful añaŋut hili ti pahaaño pa piti Himuusu ha. ");
INSERT INTO krx_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Hilim ha heesiiŋanee eehe efihicok ati Israyel niŋ akaawoola eekine niŋ aluu.” ");
INSERT INTO krx_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Pakati Israyel púlooŋ nkáhin samat nii fa Ateeteyo naasoke fa Móyiis niŋ Aaron. ");
INSERT INTO krx_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ti hinoom ha heemaka ha eehuu, Ateeteyo náafulanii pakati Israyel ti mah ma miti Esipt samat nii uyoŋ uti pusoocaali. ");
INSERT INTO krx_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Ateeteyo naasok Móyiis: ");
INSERT INTO krx_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Cok pikampaani pa pákayaañ paka púlooŋ pakati Israyel samat nii pakatoom. Kaatuko akampaani óo akampaani áyaañ atoom, papukal óo papukal péeyiine píyaañ piti élukuleen lompo, putoom.” ");
INSERT INTO krx_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Móyiis naasok kayoŋ ka: “Nínawuno hinoom ha hiti fíyooy eeha ínnifulaniyee ha teeho ti mah ma miti Esipt, pa inniyeniye pa pimiikan. Kaatuko Ateeteyo áfulaniyoo-fúlan po aluu ti sempe epeesoo. Ooto an timpi ali hímpuul heetaake leweñoo. ");
INSERT INTO krx_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Fíyooy inniyem ti hífulu ti mah ma miti Esipt ti hiim ha hiti Apip. ");
INSERT INTO krx_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Ateeteyo naasintoolo apusok símaama aluu nii afaawufan aluu mah ma miti pakati Kanaan, pakati Het, pakati Amol, pakati Hiw niŋ pakati Yepus. Niŋ Ateeteyo anakanaa aluu ti mah emmuu, meemeeŋe ma keekee niŋ múkum, etiil óo etiil éfinnihin ti hiim eehe pahaaño pa piti kúmpuul ka keetaakut ka leweñoo. ");
INSERT INTO krx_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Efinnili kúmpuul keetaakut leweñoo fo kunoom isak niŋ kúsupak. Ti hinoom ha heewase ha isak niŋ kúsupak éfinnihin pahaaño piti kámakiyan Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Nili kúmpuul keetaakut leweñoo fo kunoom isak niŋ kúsupak. Ti mah ma púlooŋ an timpi ayenan lateyoo hímpuul heetaake leweñoo niŋ ekina tom leweñoo. ");
INSERT INTO krx_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ti pahaaño pa, an óo an ácenkin añiinoo eehe: 'Núuhinhin eehe kamma eeha Ateeteyo náahine ha unaa ta náafulanii ta unaa ti mah ma miti Esipt.' ");
INSERT INTO krx_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Pahaaño empe efipiyeno énawunoolo taaluu samat nii lánkamaasi eyya nkáhine aluu ti epees niŋ ekina tom ti éyit. Efímpinawunan aluu nii hilim ha heesiiŋanee ha hiti Ateeteyo hiñaŋut hífulu ti ñutum aluu. Kaatuko akina áfulanii aluu ti mah ma miti Esipt ti sempe epeesoo. ");
INSERT INTO krx_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Níhin pahaaño empe etiil óo etiil niŋ colaa toko.” ");
INSERT INTO krx_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Móyiis nene asok kayoŋ ka kiti Israyel: “Ateeteyo afaanakan aluu ti mah ma miti Kanaan naawufan mo aluu, samat nii fa náayinanane fa aluu niŋ símaama aluu ti esintoolo. ");
INSERT INTO krx_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Niŋ áhinaa ho, epuuk aluu pikampaani pa pákayaañ paka púlooŋ, efinniwufanii Ateeteyo, kaatuko pakati Ateeteyo; púlukuleen pa lompo péeyiine pa píyaañ pa púlooŋ piti pukoolee pa pitaaluu, efinniwufan po Ateeteyo ti kaawaaseen, kaatuko piti Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Pale niŋ nitaakaa cífali céeyiine cíyaañ ceepukee, ínnilafiyaa cífali ca cipiloŋ, niñaŋaa kaawaaseen císaacii ti putum etenco. Inníhinut fo, innifiit ekun etenco. Iyyema añii akampaani áyaañ apukee ti miin ma mitaaluu, fo niwaaseen císaacii ti putum pa piteyoo, ancuk añii ya aloŋaa. ");
INSERT INTO krx_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Fiye, po hátikin niŋ epuuk aluu kacakanaa aluu: 'Fo weyme uwune ínnihin eehuu?' Inniñahanii: 'Ateeteyo, ti sempe epeesoo náafulanii unaa Esipt, pa nuuyeniyaa pa pimiikan. ");
INSERT INTO krx_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Páawoo amansa ya ati mah ma miti Esipt atowaatowo ti káakatanaati unaa upukaayaa, fiye Ateeteyo naamuk waah óo waah wéeyiine úyaañ weepukee ti mah ma miteyoo, uti pakan paka fo ti púlukuleen pa. Ekina ewune nuuwaaseenaa Ateeteyo púlukuleen pa púlooŋ péeyiine pa píyaañ pa, pale iyyema epuuk unaa pikampaani pa pákayaañ paka, nuuwaaseenaa sáacii ti putum pa piteyii.' ");
INSERT INTO krx_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Fiye, uwaaseen ewwuu efuuyeno énawunoolo ti aluu samat nii lánkamaasi eeyem ti sipees aluu niŋ ekina tom ti píyit aluu. Efúunawunan aluu nii Ateeteyo áfulanii aluu Esipt ti sempe epeesoo.” ");
INSERT INTO krx_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ta amansa ya naakatane ta pakati Israyel kapikaay, Pútuun pa pikatanutii kapucoop pítin pa peenape pa ti mah ma miti pakati Filistin apan pihaŋa pálike. Pútuun pa mpusokoolo: “Niŋ kayoŋ ka kípannumaa nii efikitaak hikam ti pítin empuu, pikee pa nkiyesan kunuu etenko nkuñoho Esipt.” ");
INSERT INTO krx_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Fiye, Pútuun pa mpíhin kayoŋ ka kipikaay ti pítin pa peekaape pa piti káahaaŋ ka tes kupuwant Kaatii ka Kéecunke ka. Pakati Israyel nkáfulii ti mah ma miti Esipt samat nii pikaaya hikam. ");
INSERT INTO krx_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Móyiis naacoopool picec Josef kaatuko Josef asokaasok hínum epuuk Israyel: “Nisintoolo nii, niŋ Pútuun pa píkeyyoo kayankanan aluu kati púfulan aluu le, efinicoopool picecam.” ");
INSERT INTO krx_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Pakati Israyel nkáful Sukot nkakaay incakasiiŋan púkuut pa piteyii ti saatee ya eti Etam ti kanaac káahaaŋ ka tes. ");
INSERT INTO krx_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Hanakan ha, Ateeteyo naanow hátikinii ti háaputa henfakat heekaaye patiila ápiyisanii pítin pa; hánant ha, háaputa eehuu níhiyenoonii hiti seemak apicaaŋanii. Fiyuu éfikayini pikaayu hánant hanakan. ");
INSERT INTO krx_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Háaputa ha nihitowo tan óo tan hátikinii hanakan ha, háaputa ha hiti seemak sa lompo nihitowo neyii hánant ha. ");
INSERT INTO krx_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Fiye Ateeteyo naasok Móyiis: ");
INSERT INTO krx_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Sok pakati Israyel kañoho puson kapisiiŋan púkuut pa piteyii hátikin saatee ya eti Pi-Hahilot ti pututa saatee ya eti Mikutol niŋ kaatii ka. Toko efinisiiŋan púkuut pa pitaaluu nípicoonool niŋ saatee ya eti Paal-Sefon pukol kaatii ka. ");
INSERT INTO krx_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Fiye amansa ya, eficukoo nii pakati Israyel kácimaacim ti mah ma, káahaaŋ ka tes nkukuloolii. ");
INSERT INTO krx_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Inci fáhin amansa ya apiyank ekun náawawantanii aluu, pale, pínapii teyoo niŋ pusoocaali pa pakateyoo púlooŋ inci fáyisan hamake ha hitoom, pakati Esipt éfikameyi nii inci yem Ateeteyo.” Pakati Israyel nkáhin eeha naasokii ha. ");
INSERT INTO krx_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Akee naasok amansa ya ati Esipt nii pakati Israyel kateyaatey. Fiye amansa ya niŋ píhina pa pakateyoo nkayesan pámiiloolal pa piteyii nkasokool: “Weyme núuhinaa fiye? Weyme uwune nuukatanaa pakati Israyel kapikaay? Etinene kayeno pimiikan pa pakatuunaa!” ");
INSERT INTO krx_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Amansa ya naapoñ kapimemanool saleet ya eteyoo eti hikam ha, naakaay niŋ pusoocaali pa pakateyoo. ");
INSERT INTO krx_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Naacoopool sisaleet sa siteyoo seehaŋe sa panap siyema sikeme isak niŋ yoonool (600) niŋ pisaleet pa púlooŋ piti mah ma miti Esipt. Ti saleet óo saleet ñíhampaatiin pusoocaali nkayeno tempo. ");
INSERT INTO krx_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Ateeteyo náahin amansa ya ati Esipt apiyank ekun, naawawantan pakati Israyel keeyeniye ka hífulu ti mah ma ti káaseepin úpantiyii. ");
INSERT INTO krx_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Pusoocaali pa pakati Esipt niŋ pufalinc pa piteyii, pisaleet pa niŋ piteteyana pa púlooŋ nkawawantanii nkalohanii la nkasiiŋane la púkuut pa piteyii ti kanaac kaatii ka pukol Pi-Hahilot púcoonool Paal-Sefon. ");
INSERT INTO krx_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Pakati Israyel nkaŋantan amansa ya niŋ pusoocaali pa pakateyoo ti ékey, nkafe meemak nkayeno kaayonkal Ateeteyo ti pukooŋ kayankanan. ");
INSERT INTO krx_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Nkasok Móyiis: “Fo kiyaak kimeeŋut Esipt? Weyme uwune áncoopii unii ti káahaaŋ ke tes kati uket? Weyme uwune ánfulanii unii Esipt? ");
INSERT INTO krx_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Fo usokuti kápiliŋ Esipt nii: 'Katan unii úpuhin ti pakati Esipt'? Fisaka eket ti káahaaŋ ke tes.” ");
INSERT INTO krx_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Móyiis naañahanii: “Timpi nife! Nisiiŋo la inniyem la innisincan fa Ateeteyo naakaakaay fa aluu kafakan fíyooy. Kaatuko pakati Esipt payenka inniyem ka fiye ti kaasincan, etinene nicukii. ");
INSERT INTO krx_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Níwaayeen, Ateeteyo áfaataakool ti putum pa pitaaluu.” ");
INSERT INTO krx_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ateeteyo naasok Móyiis: “Weyme ayyem ti pukooŋ ti inci kayankanan? Sok pakati Israyel kakaay. ");
INSERT INTO krx_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Awe séepin hikasap ha heeyem ha ti epeesi ímpantin ho ti kaatii ka, man ma mupuweeco ancuk pakati Israyel kanapaa ti kaatii ka ti etaam eesuuce. ");
INSERT INTO krx_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Síitan, inci fáhin pakati Esipt kapiyank ekun kati kanapan aluu ti kaatii ka. Inci fáyisan hamake ha hitoom pínapii ti amansa ya niŋ uyoŋ wa uteyoo púlooŋ uti pusoocaali pa niŋ pisaleet pa niŋ piteteyana pa. ");
INSERT INTO krx_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Pakati Esipt éfikameyi nii inci yem Ateeteyo niŋ inci yísanaa hamake ha hitoom pínapii ti amansa ya, pisaleet pa niŋ piteteyana pa.” ");
INSERT INTO krx_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Maleekoo ya eti Pútuun pa eenowe ya hátikin kayoŋ ka kiti Israyel néeful toko epikaay pusonii, háaputa ha henfakat ha heekaaye ha patiila lompo heeyeniye ha hátikin, níhiful nihiyeno pusonii. ");
INSERT INTO krx_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Nihiyeno ti pututa kayoŋ ka kiti Esipt niŋ kayoŋ ka kiti Israyel. Hánant eehuu púlooŋ, oom háaputa níhitahii énimaan kaapii koonool, pale ti kikee kaapii ka nihicaaŋan, fiyuu pakakee nkayinaat hilohu pakakee. ");
INSERT INTO krx_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Fiye Móyiis náapantin epeesoo ti kaatii ka, hánant eehuu púlooŋ Ateeteyo náatunk kaatii ka niŋ hiyam henfakat héefulii pa caanak ca íncifulii pa, naayesan ko etaam eesuuce. Man ma ummuweeco. ");
INSERT INTO krx_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Pakati Israyel nkanap ti kaatii ka ti etaam eesuuce. Man ma ímmiyenoonii kiniŋ ti epees yáali niŋ ti epees yaamay. ");
INSERT INTO krx_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Pakati Esipt nkawawantanii, pufalinc pa púlooŋ piti amansa ya niŋ pisaleet pa niŋ piteteyana pa mpiyeno katey puson pakati Israyel ti kaatii ka. ");
INSERT INTO krx_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ulap wa, Ateeteyo náasincanii ti háaputa ha niŋ ti seemak sa kayoŋ ka kiti Esipt, naanakanool kunuuwii. ");
INSERT INTO krx_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Naalocan kikanku pisaleet pa, nkataak páciite ti kateteyan ka kiteyii. Pakati Esipt nkasokool: “Ukatanaa mpacas pakati Israyel kaatuko Ateeteyo oopa ti kátaakoolan unaa kamma poko.” ");
INSERT INTO krx_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Fiye Ateeteyo naasok Móyiis: “Pántin epeesi ti kaatii ka, man ma kati muñoho ummuhootan pakati Esipt niŋ pisaleet pa piteyii niŋ piteteyana pa.” ");
INSERT INTO krx_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Móyiis náapantin epeesoo ti kaatii ka; ta caanak ca inciyeniye ta éfulii, kaatii ka nkuñoho fa nkiyeniye fa. Pakati Esipt nkayeno katey kati kafak, pale Ateeteyo náaseemanii ti pututa kaatii ka. ");
INSERT INTO krx_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Man ma ummuñoho, ummuhootan pisaleet pa niŋ piteteyana pa niŋ pusoocaali pa púlooŋ pakati amansa ya keeyeniye ka katey kapuwawantan pakati Israyel ti kaatii ka, háati oonool afakut. ");
INSERT INTO krx_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Pale pakati Israyel nkanap ti kaatii ka ti etaam eesuuce, ti pututa man ma meeyeniye ma kiniŋ ti epees yáali niŋ ti epees yaamay. ");
INSERT INTO krx_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Fiyuu Ateeteyo naafakane ti oom hinoom pakati Israyel ti sipees pakati Esipt. Pakati Israyel nkacuk puhunuŋ pa piti pakati Esipt ti kantant ka kiti kaatii ka. ");
INSERT INTO krx_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Pakati Israyel nkacuk sempe sa senfakat sa siti epees Ateeteyo ta naaheeke ta pakati Esipt, nkafe Ateeteyo, nkáyinan teyoo niŋ ti Móyiis amiikan a ateyoo. ");
INSERT INTO krx_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Fiye Móyiis niŋ pakati Israyel nkacook Ateeteyo hícimu eehe: “Inci facook Ateeteyo kamma naaheeke pikamooloo pántoon, náaseeman pufalinc pa niŋ piteteyana etempo ti kaatii ka. ");
INSERT INTO krx_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Ateeteyo ayem sempe sa sitoom niŋ hícimu ha hitoom, ákeyyookey kafakanam. Akina ayem Pútuun pa putoom, inci fámuloo, akina ayem Pútuun pa piti paapaa atoom, inci fámakiyanoo. ");
INSERT INTO krx_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Ateeteyo ayem akama ya enfakat a, caacawoo ciyem Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Aséemanaa-séeman ti kaatii ka pisaleet pa piti amansa ya niŋ pusoocaali pa pakateyoo. Pusoocaali pa keehaŋe ka nkáhinee cíki ti mah ma miti Esipt, nkáseemanee ti Kaatii ka Kéecunke ka. ");
INSERT INTO krx_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Kúsuh ka nkimelii, nkáseem samat nii énankiin. ");
INSERT INTO krx_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ateeteyo, epeesi yáali ehaŋe waah óo waah sempe; Ateeteyo, epeesi yáali etuncaloole pikamooli. ");
INSERT INTO krx_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ti hamake ha hitii henfakat ha anheeke keenatuu ka. Awwánanii káñiken ka kitii samat nii seemak, nkusowii nii hikaaw. ");
INSERT INTO krx_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Emma ánfuuteene ma, man ma úmmucumpoolo, ummucoonool ciit samat nii hiniŋ; man ma méesuna ma ummucokool mipiyank ti pututa kaatii ka. ");
INSERT INTO krx_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Akamool unaa asok hínum: 'Inci fawawantanii incokii ímpaacinool hisaanumate ha hiteyii, inconcenool ho fo fomam. Iññákii káakuntu ka kutoom, epeesam néepucaloolii.' ");
INSERT INTO krx_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Pale awe Ateeteyo, ínfuuteen kaatii ka nkimelii, nkáseem samat nii énankiin ti hítaapanu man ma. ");
INSERT INTO krx_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Fo eyyeyme énaati ecuke nii awe Ateeteyo? Ekee tempo eyinaatee kaakufumool naawe, kaatuko awe, ati sempe senfakat, inhaŋ po púlooŋ. Inféyanani, íntuuno hímuluyee, ínhin weecukantee. ");
INSERT INTO krx_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Impántin epeesi yáali, etaam ya neemelanii. ");
INSERT INTO krx_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ti pálafi pa pitii peepayantoo pa ántintiŋane pakani payenka anfakane ka, ti sempe sa sitii ántintiŋanii la ankine la, la sampanee la. ");
INSERT INTO krx_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Pakan paka kásiyaasi, nkakikilan, ewatate neecok pakati Filistin. ");
INSERT INTO krx_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Fiye ñíhampaatiin ña pakati Etom nkaliim, piñaap pa pakati Mowap nkayeno ti ewatate enfakat, pakati Kanaan púlooŋ nkakikilan. ");
INSERT INTO krx_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ewatate enfakat néenowii teyii; Ateeteyo, ti sempe sa siti epeesi kayinaat hiwenu, nkacuk nii pínankiin, taamanta pakani kamuusut, pakani payenka annoome ka. ");
INSERT INTO krx_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ateeteyo, aafacoopii iyyenanii ti tíntiŋ ya etii, la ammemanoole la aakati kin, la sampanee la, la ansiiŋane la. ");
INSERT INTO krx_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Ateeteyo, awe amansa fo eket maama!” ");
INSERT INTO krx_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ta pufalinc pa, pisaleet pa niŋ piteteyana pufalinc pa pakati amansa ya nkanakiye ta ti kaatii ka, Ateeteyo náañahanii man ma teyii. Pale pakati Israyel nkafiitan ti etaam eesuuce. ");
INSERT INTO krx_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ayaamakoola ya Miriyam, Aaron ahoopoo, náacoopii pankalaŋ pa piteyoo. Pakaal Israyel púlooŋ nkácoopalii ñankalaŋ nkanapanoo nkayeno ekii. ");
INSERT INTO krx_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriyam nene acook hícimu ha: “Nicook Ateeteyo kamma naaheeke pikamooloo pántoon, náaseeman pufalinc pa niŋ piteteyana etempo ti kaatii ka.” ");
INSERT INTO krx_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Móyiis naacoop pakati Israyel nkáful ti Kaatii ka Kéecunke ka nkahiiŋ ti káahaaŋ ka tes kiti Sul. Nkasapal kunoom kíhaaciil kacukut man. ");
INSERT INTO krx_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Nkacol la nkasok la Mala nkacuk man, pale kayinaat mo pálaani kamma pasampe, ekina ewune nkasok toko Mala (ekina eyem “pasampe”). ");
INSERT INTO krx_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Pakan paka nkayeno káakumutool ti Móyiis nkasokoo: “Weyme nuukaakaay pálaani?” ");
INSERT INTO krx_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Móyiis naakooŋ ti Ateeteyo kayankanan. Ateeteyo náayisanoo hikasap, hikina naacoope naawant ho ti man ma, ímmineeniyii ummucoon pálaani. Toko Ateeteyo naawufanii kilim keesiiŋanee naasokii eeha nkañaŋe ha íhinu. Toko lompo naawinkiyii ");
INSERT INTO krx_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","naasokii: “Niŋ nísiitanaam pinap, inci Ateeteyo Pútuun pa pitaaluu, ínnihin heecoonoole ti ñíkinam, niŋ nísiitanaa eeha inci insoke ha ínnituul kilim ka kutoom keesiiŋanee ka púlooŋ, ínnihinaa eehuu, úkuuñu wa púlooŋ ewwa inci úwwananii wa ti pakati Esipt, étiwananii wo taaluu, kaatuko inci yem Ateeteyo ákuuñana ya ataaluu.” ");
INSERT INTO krx_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Púful toko nkacol Elim, toko intaak úpun ŋaasuwan núusupak niŋ úyita áwii éhaaciil niŋ ŋaasuwan (70), nkasiiŋan toko púkuut pa piteyii. ");
INSERT INTO krx_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Kayoŋ ka púlooŋ kiti pakati Israyel nkúfulii Elim, nkucol ti káahaaŋ ka tes kiti Sin keeyem ka ti pututa Elim niŋ tíntiŋ ya eti Sinayi. Hinoom ha eeha nkácolii ha, hikina hiyem hinoom ha heewase ha kaat ti hiim ha hísupiyenu ha páfulaliyii ti mah ma miti Esipt. ");
INSERT INTO krx_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Po ti káahaaŋ ka tes, pakati Israyel púlooŋ nkayeno káakumutool ti Móyiis niŋ Aaron. ");
INSERT INTO krx_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Nkayeno hisoku: “Ateeteyo antinti amuk unii Esipt. Po nuuyenoyeno ti ñúus ñiti efoofa, nuuli kúmpuul fo usiit. Pale aluu ínnicoopii unii ti káahaaŋ ke tes kati nimuk unii púlooŋ niŋ peep!” ");
INSERT INTO krx_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ateeteyo naasok Móyiis: “Inci fánupanii taaluu paliyal péefulii patiila. Hinak óo hinak, pakan paka efinkakaay tíkitaaŋ nkayesal paliyal pa piteyii hak hinoom hoonool. Fiyuu inci fawinkiyii manti kátuul kilim ka kutoom keesiiŋanee ka. ");
INSERT INTO krx_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Lóokuŋ óo lóokuŋ, ti hinoom ha heewase ha isak niŋ hoonool, kañaŋaa kayesal paliyal pa hak kunoom kúsupak, nkamemanool po.” ");
INSERT INTO krx_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Fiye Móyiis niŋ Aaron nkasok pakati Israyel púlooŋ: “Fíyooy nkániim, éfinimeyi nii Ateeteyo áfulanii aluu ti mah ma miti Esipt. ");
INSERT INTO krx_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Kacom mpucom efinicuk hamake ha hiti Ateeteyo. Kaatuko ásiyaasi fa inniyem fa ti káakumutool teyoo. Fo unii uyem pakayme kati níkumutool ti unii?” ");
INSERT INTO krx_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Fiye Móyiis lompo naasok: “Ateeteyo afaawufan aluu efoofa nipili nkániim, mpucom naawufan aluu kúmpuul fo nisiit, kaatuko ásiyaasi káakumutool ka kitaaluu teyoo. Fo unii uyem pakayme? Inníkumutoolaa ti unii, ti Ateeteyo fanfaŋ inniyem ti káakumutool!” ");
INSERT INTO krx_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Púful toko Móyiis naasok Aaron: “Sok pakati Israyel púlooŋ kákey hátikin Ateeteyo, kaatuko ásiyiisi ti káakumutool.” ");
INSERT INTO krx_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ta Aaron naayeniye ta káakup niŋ pakan paka púlooŋ, nkayeso lipa ti káahaaŋ ka tes, tokotoko nkacuk hamake ha hiti Ateeteyo ti háaputa ha. ");
INSERT INTO krx_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ateeteyo naasok Móyiis: ");
INSERT INTO krx_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Síyaasi káakumutool ka kiti pakati Israyel, sokii eehe: 'Fíyooy niŋ caanak ca cinowaa, efinili efoofa. Kacom mpucom efinitaak kúmpuul ka púlooŋ enka innisoolahe ka. Fiyuu éfinimeyi nii inci Ateeteyo yem Pútuun pa pitaaluu.'” ");
INSERT INTO krx_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Nkániim ka, hícump kuhola nkúfulii nkimeeŋ ti píkinuma pa piteyii. Mpucom pa, haamon níhikiipool píkinuma pa piteyii púlooŋ. ");
INSERT INTO krx_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Haamon ha ta nihisuuce ta, intaak waah weemisane weecuke nii micempanu, nuuyeno ti esiya ya eti káahaaŋ ka tes. ");
INSERT INTO krx_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Pakati Israyel ta nkacuke wo ta kámiit weyme, nkayeno picakanool nkasokool: “Aŋuu weyme?” Móyiis naasokii: “Aŋuu paliyal empa Ateeteyo naawufane pa aluu kati nili. ");
INSERT INTO krx_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ehe hilim eeha Ateeteyo naasoke ha: 'An óo an ayesal aŋa naasoolahe ya, nicoop an óo an eniiku yoonool ti pakan paka keeyem ka ti púkuut pa pitaaluu.'” ");
INSERT INTO krx_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Pakati Israyel nkáhin fo, pakakee nkayesal meemak pakakee paka nkayesal caahinkiŋ. ");
INSERT INTO krx_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Pale ta nkaniike ta aŋa nkayesale ya, keeyesale ka meemak kataakut pihaŋ aŋa nkasoolahe ya, keetaake ka caahinkiŋ inhemool lompo neyii. An óo an naacoop aŋa naasoolahe ya. ");
INSERT INTO krx_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Móyiis nene asokii: “An timpi atowan hak kacom.” ");
INSERT INTO krx_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Pale pakakee nkálah kapitowan. Eti kacom eteyyo mpucom, mpufut mpimeeŋ puhoc. Móyiis náañiken teyii. ");
INSERT INTO krx_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Pucom óo pucom, an óo an naayesal aŋa naasoolahe ya; niŋ kapayaa kayesal, pisiya pa mpulum, paliyal pa peetowiye pa t’etaam mpíyeluŋ. ");
INSERT INTO krx_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Hinoom ha heewase ha isak niŋ hoonool, nkayesal fo ñésupak aŋa nkayesal a, an óo an siniiku súsupak. Pakati kikaw ka púlooŋ pakati kayoŋ ka kiti Israyel nkákey kapusok ho Móyiis. ");
INSERT INTO krx_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Móyiis naañahanii: “Ehe eeha Ateeteyo naasoke ha: kacom hinoom hiti kayeno, hinoom ha hiti Ateeteyo. Nisow fíyooy aŋa inniñaŋe ya pusowu innilacan lompo aŋa inniñaŋe ya kalacan; waah óo waah weetowiye innimank wo fo kacom.” ");
INSERT INTO krx_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Pakati Israyel nkamank paliyal pa peetowiye pa fo eti kacom eteyyo mpucom samat nii fa Móyiis naasokii fa, nkacuk nii pufutut pitaakut lompo puhoc. ");
INSERT INTO krx_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Móyiis naasokii: “Nili po fíyooy, kaatuko fíyooy hinoom ha hiti kayeno ka hiti Ateeteyo. Etinicuk paliyal tíkitaaŋ píkinuma pa. ");
INSERT INTO krx_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Efiniyesal paliyal fo kunoom isak niŋ hoonool, pale hinoom ha heewase ha isak niŋ kúsupak hinoom hiti kayeno, hinoom ha hiti Ateeteyo, paliyal etipitaako.” ");
INSERT INTO krx_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ti hinoom ha heewase ha isak niŋ kúsupak, pakakee pakan nkakaay tíkitaaŋ kayesal paliyal, pale kátaakiyoot waah. ");
INSERT INTO krx_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Fiye Ateeteyo naasok Móyiis: “Fo teyme efiniloŋ ti káatuulaati kilimam niŋ kilim ka kutoom keesiiŋanee ka? ");
INSERT INTO krx_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Nísiitan, inci Ateeteyo ufane aluu hinoom ha hitoom hiti kayeno ka, ekina ewune hinoom ha heewase ha isak niŋ hoonool inci uwwufan aluu paliyal piti kunoom kúsupak. Fiye hinoom ha heewase ha isak niŋ kúsupak, an óo an ayeno lateyoo an añaŋut hífulu ti ékinuma ya eteyoo.” ");
INSERT INTO krx_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Fiye pakati Israyel nkáyekunoolo ti hinoom ha heewase ha isak niŋ kúsupak. ");
INSERT INTO krx_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Pakati Israyel nkalu paliyal pa caacaw ca manna. Acukaacuk nii pukoon peemise peehiina, pásuum eteyyo mpucuk nii hímaaf heememanoolee niŋ múkum. ");
INSERT INTO krx_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Móyiis naasokii: “Ehe hilim eeha Ateeteyo naasoke ha: 'Nimank eniiku yoonool eti manna hak keesoke aluu maamaa, kati kacuk paliyal empa inci uwwufane pa aluu ta inniyeniye ta ti káahaaŋ ka tes, ta inci ínfulanii ta aluu ti mah ma miti Esipt.'” ");
INSERT INTO krx_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Móyiis naasok Aaron: “Coop élumpa was toko eniiku yoonool eti manna, insiiŋan yo hátikin Ateeteyo kati pumankee hak keesoke unaa maamaa.” ");
INSERT INTO krx_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Aaron náahin eeha Ateeteyo naasoke ha Móyiis, naacoop élumpa ya naasiiŋan yo hátikin sínankiin sa la kilim ka keesiiŋanee ka nkikiicee la, epimankee. ");
INSERT INTO krx_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Pakati Israyel nkali manna ya fo sitiil áwii ésupak (40) fo ta nkacole ti naanee ya eti mah ma miti Kanaan la pakan nkakine. ");
INSERT INTO krx_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Eniiku ya eteyii ti oom caanak eti siliital súsupak.) ");
INSERT INTO krx_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Kayoŋ ka púlooŋ kiti pakati Israyel nkáful ti káahaaŋ ka tes kiti Sin nkayeno kaatootoosool samat nii fa Ateeteyo naasokii fa. Hinoom hoonool ti kaatootoosool ka kiteyii, nkacol ti mah emma nkasok Lefitim. Toko nkasiiŋane púkuut pa piteyii, pale man emma efikalaan mitaakiit. ");
INSERT INTO krx_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Fiye nkakaay hiŋes sisok pati Móyiis, nkasokoo: “Niwun unii upulaan!” Móyiis naañahanii: “Weyme uwune ínniyemi ti hiŋes sisok ti inci? Weyme uwune ínniyemi ti puwinko Ateeteyo?” ");
INSERT INTO krx_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Inhemool pálaani mpucok pakati Israyel nkayeno káakumutool ti Móyiis, nkasokoo: “Weyme uwune ínfulanii unii Esipt? Fo áalafilafi himuku unii niŋ pálaani, niŋ epuuk unii focaa pukoolee pa putoonii?” ");
INSERT INTO krx_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Móyiis naakaay pukooŋ kayankanan pati Ateeteyo naasok: “Puume inci inkaakaay íhinu niŋ pakan paka payenke? Etikamp kanunkalaam pukumpa fo inci ket.” ");
INSERT INTO krx_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ateeteyo naañahanoo: “Mamal pakakee ti ñíhampaatiin ña pakati Israyel kapinapool niŋ awe, innow hátikin kayoŋ ka, incok lompo hikasap ha hitii ti epees, eeha ansape ha neeho musuu ma miti Nil. ");
INSERT INTO krx_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Síitan, inci fasiiŋo hátikini ti énankiin ya lati tíntiŋ ya eti Horeb. Aafasap énankiin ya, man éfimufulii teyyo pakan paka nkáyini pálaani.” Móyiis náahin eeha Ateeteyo naasokoo ha hátikin ñíhampaatiin ña pakati Israyel. ");
INSERT INTO krx_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Naalu toko caacaw ca Masa (ekina eyem “puwinko”) niŋ Melipa (ekina eyem “sisok”). Kaatuko toko pakati Israyel nkaŋese sisok ti Móyiis, nkawinko Ateeteyo ti hisoku: “Fo Ateeteyo oopa niŋ unaa, fo aneetaat niŋ unaa?” ");
INSERT INTO krx_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Eehuu hipimuus pakati Amalek nkákey kátaakoolan pakati Israyel ti mah ma miti Lefitim. ");
INSERT INTO krx_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Móyiis naasok Josuwa: “Mamal pákayiin innikaay kátaakoolan pakati Amalek. Kacom inci fasiiŋo patiila cítintiŋ ca niŋ hikasap ha hiti Pútuun pa ti epeesam.” ");
INSERT INTO krx_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Josuwa naakaay kátaakoolan pakati Amalek samat nii fa Móyiis naasokoo fa. Tempo Móyiis, Aaron niŋ Hul nkasilo patiila cítintiŋ ca. ");
INSERT INTO krx_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ta nkacole ta po, tan óo tan Móyiis náaseepine epeesoo, pakati Israyel nkaheek, pale niŋ awananaa yo pakati Amalek nkayesanii. ");
INSERT INTO krx_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ta sipeesoo ínsiyokii ta, Aaron niŋ Hul nkácoopii énankiin nkayenanoo teyyo, poko t’ésupakii an óo an ti kaapii, nkacok sipeesoo sipicoonool fo ta caanak ca incinowe ta. ");
INSERT INTO krx_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Fiyuu Josuwa niŋ pakati Israyel nkaheeke pakati Amalek niŋ úkuntu wa uteyii. ");
INSERT INTO krx_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ateeteyo naasok Móyiis: “Kiic eehuu púlooŋ ti púkoo, pakan paka kati kánawuno ho. Sok Josuwa nii, inci fápucalool pakati Amalek, an atanene ánawunoyii ti etaam ya.” ");
INSERT INTO krx_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Móyiis naalut kaaciin naalu ko caacaw ca “Ateeteyo ayem panteeloo ya etoom.” ");
INSERT INTO krx_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Naasok: “Epees éseepineeseepin epupook elemeyu ya eti Ateeteyo, Ateeteyo áfaataakoolan pakati Amalek fo eket maama.” ");
INSERT INTO krx_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yetulo awaaseena ya ati Mitiyan, Móyiis aasonoo, náasi eeha púlooŋ Pútuun pa mpíhine ha Móyiis niŋ pakan etempo pakati Israyel niŋ fa Ateeteyo náafulaniyii fa Esipt. ");
INSERT INTO krx_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Yetulo naacoopool Sipola, Móyiis aaloo. Móyiis akatoo po áputuntuulanoo pati Paapaa ateyoo. ");
INSERT INTO krx_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Yetulo naacoopool lompo pikampaani pa pákasupak paka pakati Sipola. Ayáañ a caacawoo Kelusom, ekina eyem “akaawoola le”, kaatuko ta naapukee ta, Móyiis naasok: “Inci akaawoola le ti mah me.” ");
INSERT INTO krx_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Asúpiyenu ya caacawoo Eliyesel, ekina eyem “Pútuun pa putoom ayankanana”, kaatuko ta naapukee ta, Móyiis naasok: “Pútuun pa piti paapaa atoom piyankananaam, mpíkey pipifakanam ti káakuntu ka kiti amansa ya ati Esipt.” ");
INSERT INTO krx_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Fiye Yetulo, Móyiis aasonoo, naacoopool Móyiis aaloo niŋ epuukoo nkakaay pateyoo ti káahaaŋ ka tes la naasiiŋane la ékuut ya eteyoo pukol tíntiŋ ya eti Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Naapoñ kapusok Móyiis: “Inci Yetulo aasoni oopa ti ékey ti awe niŋ aali niŋ pikampaani pa pakateyoo pákasupak paka.” ");
INSERT INTO krx_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Móyiis naacaapaakoolan aasonoo, náakilipo puhooŋuyoo t’etaam naasumpooloo, púful toko nkakicanool nkanako ti ékuut ya eteyoo. ");
INSERT INTO krx_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Móyiis naakaman aasonoo eeha púlooŋ Ateeteyo náahine ha amansa ya niŋ pakati Esipt kamma pakati Israyel, focaa lompo páciite pa empa nkacuke pa ti pítin pa niŋ fa Ateeteyo naafakanii fa. ");
INSERT INTO krx_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yetulo ínsuumoo ta náasiye ta heenape ha púlooŋ eeha Ateeteyo náahine ha pakati Israyel ta naafakanii ta ti sipees pakati Esipt. ");
INSERT INTO krx_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yetulo naasokoo: “Ateeteyo ámulee, akina aŋa afakane ya aluu ti sipees Esipt niŋ ti amansa ya; ee, akina afakane pakan etempo ti sipees pakati Esipt. ");
INSERT INTO krx_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Fiye híiniyaamhiini nii Ateeteyo ahaŋa pínaati pa púlooŋ. Ayísanaayisan ho pakati Esipt ta nkayeniye ta efomanoolo niŋ kaakallan pakati Israyel.” ");
INSERT INTO krx_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Móyiis aasonoo Yetulo naawaaseen púlukuleen Pútuun pa, naasow yoonool ti púlukuleen empuu fo eleem motic. Aaron náakey niŋ ñíhampaatiin ña púlooŋ pakati Israyel nkali niŋ Móyiis aasonoo hátikin Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Eti kacom eteyyo Móyiis naayeno íhinu kíiti pakan paka ti páciite pa peeyem pa ti pututayii. Pakan paka nkayeno toko písik mpucom fo nkániim. ");
INSERT INTO krx_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Móyiis aasonoo Yetulo naacuk eeha púlooŋ Móyiis naayeniye ha íhinu pakan paka, naacakanoo: “Weyme ayyem fiye ti íhinu pakan paka? Weyme uwune aakati hín kíiti lamayi? Pakan paka púlooŋ nkasiiŋo pukoli mpucom fo nkániim!” ");
INSERT INTO krx_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Móyiis naañahanoo: “Pakan paka nkákeykey ti inci kati kámeyi eeha Pútuun pa mpílafiye ha kápihin ti píciitool pa piteyii. ");
INSERT INTO krx_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Niŋ kataakaa píciitool nkákeykey le inci píhinii kíiti, íyyisanii kápimeyi hilim ha heesiiŋanee ha hiti Pútuun pa niŋ pakalaŋanal etempo.” ");
INSERT INTO krx_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Fiye aasonoo naasokoo: “Eeha ayyem ha ti íhinu hinaput. ");
INSERT INTO krx_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Aafayokan faŋi, iyyokan pakan paka payenka nkákey ka taawe, páhin pa pínapinapi aayinaat po kaacoopool lamayi. ");
INSERT INTO krx_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Fiye síitanam inci puwuni kunuu, álimaati Pútuun pa piyeno naawe. Awe intowo ti pututa pakan paka niŋ Pútuun pa, íyyisan po píciitool pa piteyii. ");
INSERT INTO krx_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Kalaŋanii hilim ha heesiiŋanee ha niŋ pakalaŋanal pa piti Pútuun pa, íyyisanii pítin empa efikanap pa tempo niŋ eeha nkañaŋe ha íhinu. ");
INSERT INTO krx_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Mamal ti kayoŋ ka púlooŋ pákayiin keesuusa nkafe Pútuun pa, kéelafiye tooñaa ya, payenka ammeya nii etikacoon kapinakanee ti cípa, insiiŋanii kapiyeno píhina kíiti. Niŋ fúlaa toko, ímpaacinool pakan paka ti uyoŋ: uyoŋ uti wúli (1,000), uyoŋ uti keme (100), uyoŋ uti áwii ésupak niŋ ŋaasuwan (50) niŋ uyoŋ uti ŋaasuwan (10), kayoŋ óo kayoŋ nkitaak áhina kíiti. ");
INSERT INTO krx_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Payenkuu éfinkahin kíiti pakan paka tan óo tan. Pale píciitool pa péeciita pa íhinu kíiti nkácoopii po ti awe, píciitool pa peewiina pa nkáhin po kíiti faŋii. Eehuu efihiwun pitiyo pa pitii mpúwiini kaatuko éfikapaacinool po niŋ awe. ");
INSERT INTO krx_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Niŋ áahinaa ho samat nii Pútuun pa fa mpusoke fa, aatiyokan faŋi, pakan paka payenke púlooŋ lompo nkañoho ti punuufii ti kásuumaay.” ");
INSERT INTO krx_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Móyiis náasiitan aasonoo, náahin eeha púlooŋ naasokoo ha. ");
INSERT INTO krx_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Naamamal pákayiin keesuusa ti kayoŋ ka kiti Israyel púlooŋ, naasiiŋan pakakee kapiyeno píhina kíiti uyoŋ uti wúli (1,000), pakakee uyoŋ uti keme (100), pakakee uyoŋ uti áwii ésupak niŋ ŋaasuwan (50), pakakee uyoŋ uti ŋaasuwan. ");
INSERT INTO krx_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Payenkuu nkayeno píhina kíiti ya pakan paka tan óo tan, píciitool pa péeciita pa mpucoopee ti Móyiis pale píciitool pa peewiina pa, poko faŋii nkáhin po kíiti. ");
INSERT INTO krx_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Eehuu hipimuus, Móyiis naakatan aasonoo Yetulo apuñoho pati mah ma miteyoo. ");
INSERT INTO krx_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Pakati Israyel nkáful Lefitim nkakaay ti káahaaŋ ka tes kiti Sinayi. Ti hinoom ha híyaañ ha hiti hiim ha híhaaciyenu ha páfulaliyii ti mah ma miti Esipt, nkacol ti káahaaŋ ka tes kiti Sinayi, nkasiiŋan toko púkuut pa piteyii púpucoonool niŋ tíntiŋ ya. ");
INSERT INTO krx_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Móyiis naasilo ti tíntiŋ ya apicaapaakool po niŋ Pútuun pa. Ateeteyo eeyeniye ya patiila ti tíntiŋ ya naayonkal Móyiis naasokoo: “Eehe aafasok pakati Israyel, keesoke ka Jakob maamaa: ");
INSERT INTO krx_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","'Nicukaacuk aluu faŋ aluu eeha inci ínhine ha pakati Esipt niŋ fa inci ínseepine fa aluu samat nii fa hisiwita níhiseepin fa mufuun eteeho ti úpitu eteeho, íncoopii aluu fo le pukolam. ");
INSERT INTO krx_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Fiye niŋ nísiitanaam innicok písiyool pa empa inci illiile pa naaluu, efiniyeno pakanam. Etaam ya púlooŋ etoom, pale aluu inci fanaŋ ti níiyam. ");
INSERT INTO krx_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Efiniyeno ti inci cáwii citi puwaaseena pakatoom, síi eti meeñeya.' Eehuu aafasok pakati Israyel.” ");
INSERT INTO krx_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Móyiis naañoho, naayonkal ñíhampaatiin ña pakati Israyel naasokii eeha púlooŋ Ateeteyo naasokoo ha. ");
INSERT INTO krx_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Poko púlooŋ nkañahanoo ti coonool: “Efúuhin eeha púlooŋ Ateeteyo naasoke ha.” Móyiis náacaatuunan Ateeteyo eeha pakan paka nkasoke ha. ");
INSERT INTO krx_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ateeteyo naasok Móyiis: “Síitan, inci fákey ti awe púyoloonii ti háaputa henfakat. Ancuk pakan paka kásiyaam niŋ inci yeniyaa káakup naawe, nkáyinan ti awe tan óo tan.” Móyiis naasok Ateeteyo eeha púlooŋ pakan paka nkañahanoo ha. ");
INSERT INTO krx_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ateeteyo naasok Móyiis: “Ñoho pati pakani inkuulanii fíyooy niŋ kacom, nkañow lompo wañ wa uteyii, ");
INSERT INTO krx_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","nkamemanoolo hak tanta. Oom hinoom, inci Ateeteyo fáwanoonii ti tíntiŋ ya eti Sinayi hátikin pakan paka púlooŋ. ");
INSERT INTO krx_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Kínk tíntiŋ ya insokii: 'Nitah kunuu, timpi nisilo ti tíntiŋ ya, timpi nílik háati kanaac eteyyo!' Niŋ an álikaa tíntiŋ ya afaamukee. ");
INSERT INTO krx_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ayeno an niŋ fotom élukuleen, atakatanee apuloŋ. An átalik eemuuyene ya pale afaamukee ti kaanunkalee pukumpa niŋ ekina tom niŋ kiŋaaceen. Pale niŋ kámpiis ka kiti kaasiin sáacii ya kusokanee, pakakee pakan éfikasiloonii ti tíntiŋ ya.” ");
INSERT INTO krx_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Púful toko, Móyiis náawanoonii ti tíntiŋ ya ápikey ti pakan paka naakuulanii, nkañow wañ wa uteyii. ");
INSERT INTO krx_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Nene asokii: “Nimemanoolo hak tanta, timpi nihinto niŋ pakaal aluu.” ");
INSERT INTO krx_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Eti tanta eteyyo nuulap, intaako pasapal etiil, pamaliñoolal niŋ káatiŋu kenfakat ti tíntiŋ ya. Pasokal kámpiis ka kiti sáacii ya nkísiyee niŋ sempe. Ti pikin pa, pakan paka púlooŋ nkakikilan kamma ewatate. ");
INSERT INTO krx_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Móyiis náafulanii pakati Israyel ti pikin pa kati kapaakool niŋ Pútuun pa. Nkasiiŋo t’etaam tíntiŋ ya. ");
INSERT INTO krx_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ateeteyo náawanoonii ti pisempuc tíntiŋ ya eti Sinayi ti pututa seemak. Fiye tíntiŋ ya neemeeŋ niŋ háaputa, háaputa ha nihiyeno éfulii pan óo pan ti tíntiŋ ya samat nii seemak senfakat. Tíntiŋ ya púlooŋ néeyiyiŋan meemak. ");
INSERT INTO krx_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Pasokal kámpiis ka nkihaŋ toko nkiyiŋiye. Niŋ Móyiis ákupaa, Pútuun pa mpiñahanoo niŋ pasapal etiil. ");
INSERT INTO krx_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ateeteyo náawanoonii ti pisempuc tíntiŋ ya eti Sinayi, naayonkal po Móyiis. Móyiis naasilo po. ");
INSERT INTO krx_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Ateeteyo naasok Móyiis: “Wano ínkupanan pakan paka insokii timpi kákanii híkinku ha kápikey hicukuyam, niŋ hitaakiyaa pakan keemeeŋe efikaket. ");
INSERT INTO krx_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Háati puwaaseena pa pakatoom payenka nkaloham ka kañaŋaa ekuulanoolo niŋ ekina tom hikasap ha hitoom efihinaŋo teyii.” ");
INSERT INTO krx_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Móyiis naañahan Ateeteyo: “Pakan paka kayinaat pisilo ti tíntiŋ ya eti Sinayi. Kaatuko awe himuumi kúpanane unii insokam: 'Kínk tíntiŋ ya, kati eyeno meeñeya.'” ");
INSERT INTO krx_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ateeteyo naasokoo: “Wano ínsiloonii niŋ Aaron. Pale puwaaseena pa niŋ pakan paka kañaŋut ékanii híkinku ha kápikey peti inci. Niŋ hitaakiyaa, hikasap ha hitoom efihinaŋo teyii.” ");
INSERT INTO krx_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Fiye Móyiis náawanoonii ti pakan paka naasokii eeha Ateeteyo naasoke ha. ");
INSERT INTO krx_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Fiye Pútuun pa mpusok kilim enke púlooŋ pakati Israyel: ");
INSERT INTO krx_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Inci yem Ateeteyo Pútuun pa pitaaluu, inci fúlanii aluu ti mah ma miti Esipt pa inniyeniye pa pimiikan. ");
INSERT INTO krx_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Timpi taak ñikee ñútuun niŋ neetaat inci. ");
INSERT INTO krx_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Timpi memanool faŋi énaati, timpi memanool lompo himuum heenakoole nii waah weeyem patiila niŋ fotom t’etaam niŋ fotom ti man ma meeyem ma t’etaam esiya ya. ");
INSERT INTO krx_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Timpi kílipo hátikin kumuum enkuu, timpi waaseen tenko kaatuko inci yem Ateeteyo, Pútuun pa pitii, Pútuun peesowa. Insiiŋansiiŋan ti pisiya keemuuyene ka ti inci nkanatam, insiiŋan ti pisiya lompo epuukii niŋ keesokii maamaa fo ti sikaay síhaaciil niŋ fotom sipaakiil. ");
INSERT INTO krx_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Pale íyyisan panap pa putoom fo ti sikaay siyema wúli (1,000) ti kéelafiyaam ka nkacok kilim ka kutoom. ");
INSERT INTO krx_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Timpi cemen caacaw Ateeteyo Pútuun pa pitii kenseŋ, kaatuko inci Ateeteyo Pútuun pa pitii etiwufan tooñaa an aŋa nacemen caacawam kenseŋ. ");
INSERT INTO krx_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Náwuno tan óo tan hinoom ha hiti kayeno ka íntuul ho, kati hiyeno hinoom hiti meeñeya. ");
INSERT INTO krx_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Kunoom isak niŋ hoonool antaake aakati hín páhin pa pitii púlooŋ. ");
INSERT INTO krx_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Pale hinoom ha heewase ha isak niŋ kúsupak hiyem hinoom ha hiti kayeno ka, hinoom ha hiti Ateeteyo Pútuun pa pitii. Oom hinoom an átahin, awe tom, epuuki tom, pimiikan pa pakatii tom kayeno pákayiin niŋ ekina tom pakaal, pukoolee pa pitii tom niŋ ekina tom ekaawoola ya keekine ka ti mah ma mitii. ");
INSERT INTO krx_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Kaatuko inci Ateeteyo, ti kunoom isak niŋ hoonool inci illiile patiila niŋ t’etaam niŋ waah óo waah weeyem toko, illiil lompo kaatii ka niŋ waah óo waah weeyem lupo, púful toko íyyekunoolo ti heewase ha isak niŋ kúsupak. Ekina ewune inci Ateeteyo insampan hinoom ha hiti kayeno ka ínhin ho hinoom hiti meeñeya. ");
INSERT INTO krx_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Nápiyan paapaa atii niŋ íññaa atii aakati taak eloŋ eehaane ti etaam eyya inci Ateeteyo Pútuun pa pitii iyyemuu ya ti kawufan. ");
INSERT INTO krx_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Timpi muk an ti pásuumayi. ");
INSERT INTO krx_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Timpi hinto niŋ aal eenimiye. ");
INSERT INTO krx_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Timpi líp. ");
INSERT INTO krx_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Timpi caam aapunook akinooli. ");
INSERT INTO krx_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Timpi siiŋan níkini ti akinooli ekumpaan ya eteyoo; “timpi siiŋan níkini ti waah uti akinooli, neetaat aaloo, neetaat amiikan a ateyoo ayeno áyiin niŋ ekina tom aal, neetaat íis ya eteyoo niŋ fotom fáli ya eteyoo, niŋ ekina tom waah óo waah uteyoo.” ");
INSERT INTO krx_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Pakati Israyel púlooŋ nkási pasapal etiil ya niŋ kámpiis ka, nkacuk pamaliñoolal etiil ya niŋ tíntiŋ ya eeyem ya niŋ háaputa. Nkayeno kakikilan kamma ewatate nkasiiŋo pílaaŋ. ");
INSERT INTO krx_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Nkasok Móyiis: “Awe kúp noonii, éfuusiitani pale Pútuun pa timpi púkup noonii niŋ ekina tom efuuket.” ");
INSERT INTO krx_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Móyiis naañahanii: “Timpi nife, Pútuun pa píkeyyookey puwinko man éfinituul po, pílafilafi nipife po ancuk etinimuuyen.” ");
INSERT INTO krx_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Pakati Israyel nkatowo nkasiiŋiye pílaaŋ pale Móyiis naaloh háaputa ha henfakat ha, la Pútuun pa mpiyeniye la. ");
INSERT INTO krx_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ateeteyo naasok Móyiis: “Ehe eeha aafasok ha pakati Israyel: 'Aluu himuum aluu nicukaacuk nii patiila inci ínkupii niŋ aluu. ");
INSERT INTO krx_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Timpi nimemanool faŋ aluu ñútuun ñiti kótifoloo niŋ ekina tom ñiti sanoo kati nítuul ño ñipinanf ti inci. ");
INSERT INTO krx_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Efinilutam kaaciin kiti mah, tenko efiniwaaseenam písaacii, pifil niŋ síis: uwaaseen uti kaaleeman motic niŋ uwaaseen uti kásuumaay. Lan óo lan la inci incoke kati niwaaseenam toko, fákey ti aluu pisampan aluu. ");
INSERT INTO krx_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Niŋ nicoopaa pínankiin nipilutam kaaciin, timpi niteecanool po, kaatuko niŋ niteecanoolaa po niŋ coolaŋ, oom coolaŋ efeewun kaaciin enkuu etikiyeno keekuule ti inci. ");
INSERT INTO krx_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Timpi nilutam kaaciin keetaake ésiluma ti kafeyatan nii, inniyeniyaa pisilo timpi kaŋantan ñáfalfali aluu.'” ");
INSERT INTO krx_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Pútuun pa nene pusok Móyiis: “Niŋ an álipaa íis niŋ fotom sáacii naamuk yo niŋ ekina tom naanooman yo, álipa ya añaŋaa cooy síis isak apiñahan íis ya éelipee ya niŋ sísaacii sipaakiil apiñahan sáacii ya éelipee ya. ");
INSERT INTO krx_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","Añaŋaa cooy aŋa náalipe ya. Niŋ ataakut likee añaŋee kaanooman kati kacooy aŋa náalipe ya. Niŋ élukuleen eyya náalipe ya etookee kaloŋa ti sipeesoo, man me íis, fáli niŋ ekina tom sáacii, añaŋaa cooy yoonool ya súsupak. “Niŋ álipa acokee ti pinako ti ekumpaan niŋ hánant naamukee, eemukoo ya amuuyenut. Pale niŋ hitaakiyaa niŋ hanakan, eemukoo ya amuuyenaa-muuyen. ");
INSERT INTO krx_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Niŋ an acoopaa kaahoonan púlukuleen pa piteyoo ti kaakit niŋ ekina tom ti kankaŋ eti punuun piti wiiñ, naakat po pupuhoon ti kaakit akee, añaŋoo cooy la haŋe la panap ti kaakit ka kiteyoo niŋ ekina tom ti kankaŋ ya eteyoo. ");
INSERT INTO krx_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Niŋ an acokanaa seemak ti kaakit ka kiteyoo, píheeni pa mpucok fo seemak sa sítif ti kaakit akee, insisow pasukal pa peeyem pa ti éŋantii niŋ ekina tom peemaañee pa mpúcumpoolee, eecokane ya seemak sa añaŋaa cooy aŋa éepuciyee ya. ");
INSERT INTO krx_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Niŋ an acoonaa himanku mañ an niŋ ekina tom waah weetaake nafaa, núulipee ti ekumpaan ya eteyoo; niŋ álipa ya acokee, añaŋaa cooy ñiyema ñésupak aŋa náalipe ya. ");
INSERT INTO krx_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Pale niŋ álipa ya acokutee, eeñomanee ya wañ wa añaŋaa ékey hátikin Pútuun pa naasintoolo nii akina tom álipe wañ wa. ");
INSERT INTO krx_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ti píñakalool óo píñakalool piti waah, man me íis, fáli, sáacii, pásooliyal niŋ ekina tom waah wéecime, pákasupak paka keeyem ka ti píñakalool oom waah kañaŋaa ékey hátikin Pútuun pa. Aŋa Pútuun pa mpucoke ya nii akina anowe, añaŋaa cooy ñiyema ñésupak akee ya. ");
INSERT INTO krx_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Niŋ an acoonaa himanku akee fáliyoo, íisoo, sáaciiyoo, niŋ ekina tom ekee élukuleen, élukuleen ya neeket niŋ ekina tom neekuumoolo niŋ ekina tom néelipee, niŋ taakut an eetantake, ");
INSERT INTO krx_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","oom an añaŋaa esintoolo hátikin Ateeteyo nii akina tom álipe élukuleen ya eti akee ya. Ati élukuleen ya añaŋaa hicoonu esintoolo ya, akee ya añaŋutoo cooy waah. ");
INSERT INTO krx_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Pale niŋ pánipani élukuleen ya élipeelip, an a aŋuu añaŋaa cooy ati élukuleen ya. ");
INSERT INTO krx_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Niŋ élukuleen ya, élukuleen elampa etaatuloole yo, oom an añaŋaa écoopii ehunuŋ ya epiyeno píyisan pa, ancuk atacooy. ");
INSERT INTO krx_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Niŋ an anahanaa élukuleen akee, élukuleen ya neekuumoolo niŋ ekina tom neeket apan ati élukuleen ya atantakut, añaŋaa yo cooy. ");
INSERT INTO krx_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Pale niŋ hitaakiyaa hátikin ati élukuleen ya, añaŋut cooy. Niŋ élukuleen ya éehinee lúwaas, cooy ya eñaŋaa piyeno cooy ya eti lúwaas ya.” ");
INSERT INTO krx_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Pútuun pa nene pusok Móyiis: “Niŋ áyiin anapanaa ámaacul eeŋaamutee ekop naahinto neyoo, añaŋaa cooy paason pa naasayoo. ");
INSERT INTO krx_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Niŋ paapaa ateyoo apookoo kawun ámaacul a, háati atasayoo, añaŋaa cooy paason empa nkacooy pa ámaacul. ");
INSERT INTO krx_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Aal ápatuuta añaŋutee hikatu kaloŋa. ");
INSERT INTO krx_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“An óo an eehintiye niŋ élukuleen añaŋee himuku. ");
INSERT INTO krx_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Niñaŋaa kaawaaseen inci Ateeteyo lamma, aŋa nawaaseen a énaati añaŋee himuku. ");
INSERT INTO krx_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Timpi niyokan akaawoola eekine lataaluu, timpi nikancool neyoo. Kaatuko aluu himuum aluu niyenaayeno ekaawoola ti mah ma miti Esipt. ");
INSERT INTO krx_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Timpi nikallan ásikateen niŋ ekina tom eyaaŋat aŋa áyiinoo eekete. ");
INSERT INTO krx_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Niŋ aakallanii nkakooŋ peti inci kati yankananii, inci fásiitan pukooŋ pa piteyii. ");
INSERT INTO krx_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Fáñiken immuk aluu ti hikam. Fiye pakaal aluu efikayeno piyaaŋat, epuuk aluu nkayeno písikateen. ");
INSERT INTO krx_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Niŋ aamaakaa mañ oonool ti pakanam keeleke, timpi wen nii payenka nkamaak ka pakan paka mañ nkapenan ti cooy ya. ");
INSERT INTO krx_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Niŋ aacoopaa hísool ha henfakat ha hiti akinooli ti kaapii kiti hicoku kati acooyi, aafañahanoo ho caanak ca cínowum. ");
INSERT INTO krx_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Kaatuko hikina aŋuu naataake kati áwufaloolo, niŋ hicoopee niŋ weyme áfaawufaloolo níhanant? Niŋ akooŋaa peti inci, fásiitanoo kaatuko inci meeŋaameeŋ paket hikaw. ");
INSERT INTO krx_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Timpi sok heenaput ti inci Pútuun pa, timpi ñan ati hikaw ha ati kayoŋ ka kitii. ");
INSERT INTO krx_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Aañaŋaam kawufan himpaac ha hitoom ti pamaañal pa pitii, papukal wiiñ ya etii niŋ papukal olif ya etii. Aañaŋaam kawufan añii ya akampaani ya ácook a atii. ");
INSERT INTO krx_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Aañaŋaa íhinu moonool muu niŋ papukal pa péeyiine pa píyaañ pa piti síis sa sitii, pifil pa niŋ písaacii pa. Kat cimpeeh ca cipiyeno ti íññaa etenco fo kunoom isak niŋ kúsupak, heewase ha isak niŋ kíhaaciil uwwufanam co. ");
INSERT INTO krx_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Efiniyeno ti inci pakanam keesampanee. Ekina ewune niñaŋut hili efoofa eyya élukuleen elampa neetaatuloole, niwant yo piyen pa.” ");
INSERT INTO krx_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Pútuun pa nene pusok Móyiis: “Timpi hancalool kilim kiti kincaam. Naakaayaa kíiti aakati yeno eetantake, timpi caam aapisiiŋo an eemuuyene, ");
INSERT INTO krx_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","timpi lompo napan kayoŋ ka ti íhinu heenaput, niŋ ti kincaam kipikit tooñaa ya. ");
INSERT INTO krx_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Niŋ an eeleke acoopee kíiti, timpi siiŋiyoo kamma naaleke inketi teyoo ti hikaw. ");
INSERT INTO krx_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Niŋ aacukaa íis niŋ ekina tom fáli eti akamooli éecime ñahanoo yo. ");
INSERT INTO krx_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Niŋ aacukaa fáli ya eti eenatuu ya neenowe kamma pitiyo peenapa, timpi muusoo pale yankananoo episiiŋo. ");
INSERT INTO krx_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Ti kíiti, timpi kit tooñaa ya eeleke ya. ");
INSERT INTO krx_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Láaŋ hinooku an ti kincaam. Timpi muk éehinut waah niŋ ekina tom eecoonoole, kaatuko inci ufanantoo tooñaa keemuuyene ka. ");
INSERT INTO krx_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Timpi coon kapunoomi kaatuko an eenoomee, náfuumfuum ti kaapii kiti tooñaa, naakit keecoonoole ka tooñaa ya. ");
INSERT INTO krx_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Timpi kallan akaawoola. Nímeyimeyi fa eloŋ eti akaawoola neeyem, kaatuko aluu himuum aluu niyenaayeno ekaawoola ti mah ma miti Esipt.” ");
INSERT INTO krx_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Pútuun pa nene pusok Móyiis: “Aáyiniyini pusuk niŋ kaamaañ pitaam pa pitii fo sitiil isak niŋ yoonool. ");
INSERT INTO krx_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Pale etiil ya eewase ya isak niŋ súsupak, aañaŋaa kakatan pitaam pa pitii pípiyekunoolo, timpi maañ ewalak ya, pakani keeleke ka kati kataak waah ewwa efikali, púlukuleen pa piti elampa lompo mpuhoon waah wa weetowiye wa. Fo lompo áafahin ti pikankaŋ pa pitii piti punuun pa piti wiiñ ya niŋ olif ya. ");
INSERT INTO krx_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Kunoom isak niŋ hoonool antaake ti lóokuŋ ya aakati hín páhin pa pitii, pale heewase ha isak niŋ kúsupak áatihin waah, síis sa niŋ púfali pa pitii kati píyekunoolo, pimiikan pa pakatii niŋ ekaawoola ya kéekeyii ka páhin taawe nkasuuŋut. ");
INSERT INTO krx_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Nísiitan pinap eeha púlooŋ inci insoke ha aluu. Timpi niluum ti pínaati, an timpi ási aluu ti kaayonkal ucaw etempo.” ");
INSERT INTO krx_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Pútuun pa nene pusok Móyiis: “Etiil óo etiil, ñiyema ñáhaaciil éfinihin pahaaño hak inci. ");
INSERT INTO krx_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Pahaaño pa píyaañ pa, pikina piyem pahaaño pa piti kúmpuul ka keetaakut ka leweñoo. Efinili kúmpuul keetaakut leweñoo fo kunoom isak niŋ kúsupak, samat nii fa inci insoke fa aluu. Níhin eehe ta nihiñaŋee ta íhinu ti hiim ha hiti Apip. Kaatuko ti oom hiim ínnifulii ti mah ma miti Esipt. An timpi ákey hátikinam sipeesoo ñaanii. ");
INSERT INTO krx_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Pahaaño pa púsupiyenu pa, pikina piyem pahaaño pa piti kaamaañ ka, nícoopiyam pamaañal pa píyaañ pa piti aŋa innisuke ya ti ukit wa utaaluu. Pahaaño pa píhaaciyenu pa, pikina piyem pahaaño pa piti kaaconcenool pamaañal pa ti pikelan etiil ya niŋ niconcenoolaa pamaañal pa pitaaluu. ");
INSERT INTO krx_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Etiil óo etiil pákayiin paka púlooŋ pakati kayoŋ ka kitaaluu éfinkakey ti ñahaaño ña ñáhaaciil eññuu kapisiiŋo hátikinam, inci Ateeteyo Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Niŋ niyeniyaam kaawaaseen púlukuleen, hísim etempo timpi hinapool niŋ waah weetaake leweñoo. Timpi nimank kúsuum ka kiti kaawaaseen ka kiti pahaaño pa fo eti kacom eteyyo. ");
INSERT INTO krx_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Etiil óo etiil, weehaŋe wa panap ti pamaañal pa púcook pa piti pitaam pa pitaaluu, éfinicoopii po ti ekumpaan ya etoom, inci Ateeteyo Pútuun pa pitaaluu. “Etiniyik cifil niŋ miin ma miti íññaa etenco.” ");
INSERT INTO krx_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Pútuun pa nene pusok Móyiis: “Síitan, inci fapoñ maleekoo epinow aluu hátikin neefaas aluu ti pítin pa, neecoop aluu ti mah emma inci immemanoole ma aluu. ");
INSERT INTO krx_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Nítuul yo ínnisiitan yo. Timpi nipook eeha nesok ha aluu, kaatuko eteponket kaamuuyen ka kitaaluu kamma néhin ti caacawam. ");
INSERT INTO krx_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Pale niŋ nísiitanaa yo ínnihin eeha púlooŋ inci insok ha aluu, inci fayeno akamool pikamool aluu, íntaakoolan payenka nkátaakoolan ka aluu. ");
INSERT INTO krx_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Maleekoo ya etoom efeenow aluu hátikin, neecoop aluu ti mah ma miti pakati Amol, pakati Het, pakati Pelis, pakati Kanaan, pakati Hiw niŋ pakati Yepus, inci ímpucaloolii. ");
INSERT INTO krx_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Timpi níkilipo hátikin pínaati pa piteyii, etiniwaaseen po niŋ fotom ínniyipenan páhinalii. Pale niñaŋaa po kaahumalool innihancalool pínankiin etempo piti meeñeya ma. ");
INSERT INTO krx_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","“Niŋ nítuulaam inci Ateeteyo Pútuun pa pitaaluu, inci fasampan aluu niŋ paliyal niŋ man ínfulan úkuuñu wa utaaluu púlooŋ. ");
INSERT INTO krx_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ti mah ma mitaaluu, háati munow aal etimuwaato niŋ ekina tom aal atayeno caakonta. Fawun aluu eloŋ eehaane. ");
INSERT INTO krx_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Niŋ písii pa písiyaa nii aluu unka ti ékey, fáwananii ewatate teyii, illiimanool mah óo mah emma innikaakaay pinako temmo. Fáhin pikamool aluu kapitey hátikin aluu. ");
INSERT INTO krx_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Inci fáwananii púlulumeen ti pakati Hiw, pakati Kanaan niŋ pakati Het kapitey le niŋ efinicol. ");
INSERT INTO krx_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Pale etiyaan písii empuu púlooŋ ti etiil yoonool; niŋ inci hínaa fo, mah ma efimiyeno ñaanii etemmo la púlukuleen elampa mpikaakaay himeeŋu apan etinap ti aluu. ");
INSERT INTO krx_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Fayaan uyoŋ ewwuu caahinkiŋ caahinkiŋ fo ta éfinimeeŋii innicoop mah ma. ");
INSERT INTO krx_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Inci fasiiŋan naanee etaaluu písik ti Kaatii ka Kéecunke ka fo ti kaatii ka kiti pakati Filistin, písik ti káahaaŋ ka tes kiti Sinayi fo ti musuu ma miti Efalat. Kaatuko inci fawufan aluu kayine ti keekine ka ti mah emmuu ancuk niyaanii. ");
INSERT INTO krx_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Timpi niliil písiyool neyii niŋ fotom pínaati pa piteyii. ");
INSERT INTO krx_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Timpi nikatii kapikin ti mah ma mitaaluu niŋ ekina tom efikawas aluu kaamuuyen ti inci. Niŋ nítuulaa pínaati pa piteyii, efipiyeno taaluu hikuucu.” ");
INSERT INTO krx_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ateeteyo naasok Móyiis: “Síloonii peti inci ti tíntiŋ ya niŋ Aaron, Natap niŋ Apihu niŋ ñíhampaatiin áwii éhaaciil niŋ ŋaasuwan (70) ti pakati Israyel. Níkilipo ñuhooŋu aluu t’etaam loho niloŋaa ínnilaaŋe. ");
INSERT INTO krx_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Niŋ fúlaa toko, awe lamayi íllohiyam, pale pakakee paka timpi kálohiyam. Kayoŋ ka keetowiye ka kiti pakati Israyel timpi kísiloonii ti tíntiŋ ya.” ");
INSERT INTO krx_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Móyiis naacaasok pakan paka eeha púlooŋ Ateeteyo naasokoo ha niŋ kilim ka keesiiŋanee ka. Nkañahanoo ti coonool kapusok: “Efúuhin eeha púlooŋ Ateeteyo naasoke ha.” ");
INSERT INTO krx_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Móyiis naakiic kilim ka púlooŋ kiti Ateeteyo. Eti kacom eteyyo mpucom mic naalito naalut kaaciin pukol tíntiŋ ya, naasiiŋan sínankiin siyema ŋaasuwan niŋ súsupak, sikina síyisane sísii sa ŋaasuwan niŋ súsupak sa siti Israyel. ");
INSERT INTO krx_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Púful toko naayonkal pikampaani pakati Israyel kápikey kawaaseen Ateeteyo kaawaaseen kenfakat: pikee púlukuleen pa, nkaleeman po motic, nkawaaseen lompo kíciin hak uwaaseen uti kásuumaay. ");
INSERT INTO krx_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Móyiis naacoop kancaŋ ti hísim ha apuwas ho ti pupulaatu, ekee kancaŋ ya naasancal yo ti kaaciin ka. ");
INSERT INTO krx_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Naacoop púkoo ya eti písiyool empa Ateeteyo naaliile pa niŋ pakan etempo, naakalaŋ yo hátikin kayoŋ ka. Nkañahanoo: “Efúutuul Ateeteyo núuhin waah óo waah ewwa naasoke.” ");
INSERT INTO krx_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Móyiis naacoop hísim ha heeyeniye ha ti pupulaatu pa, naasancal ho ti kayoŋ ka kiti Israyel naasok: “Nísiitan, hísim eehe híyisane písiyool empa Ateeteyo naaliile pa niŋ aluu ta naawufane ta aluu kilim enke púlooŋ.” ");
INSERT INTO krx_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Púful toko Móyiis naasilo ti tíntiŋ ya niŋ Aaron, Natap niŋ Apihu niŋ ñíhampaatiin áwii éhaaciil niŋ ŋaasuwan (70) pakati Israyel. ");
INSERT INTO krx_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Nkacuk Pútuun pa piti Israyel. La mpilempe la woot etempo intaak waah weecuke nii etaam eepupee niŋ pínankiin péefuule péeciita hinoom. Pínankiin empuu mpícaaŋinoolo samat nii útiŋu weekuule naat. ");
INSERT INTO krx_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Pútuun pa píhinut ñíhampaatiin ña pakati Israyel waah; mpikatii kapisincan po, nkali nkalaan nantoonool. ");
INSERT INTO krx_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ateeteyo naasok Móyiis: “Síloonii peti inci ti tíntiŋ ya insiiŋo toko. Inci fawufani pínankiin pa peepeefiye pa la inci inkiice la kilim ka keesiiŋanee ka aakati kalaŋan ko pakan paka.” ");
INSERT INTO krx_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Móyiis naalito niŋ Josuwa, ayankanana ya ateyoo. Móyiis naasilo ti tíntiŋ ya eti Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Pale ásilumo naasok ñíhampaatiin ña: “Nítuul unii le fo ta éfuuñohoonii. Aaron niŋ Hul efikayeno niŋ aluu, niŋ an ataakaa páciite náakup neyii.” ");
INSERT INTO krx_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Móyiis naasilo ti tíntiŋ ya, háaputa níhikimpitool yo: ");
INSERT INTO krx_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Hamake ha hiti Ateeteyo nihitowo ti tíntiŋ ya eti Sinayi, háaputa ha níhikimpitool yo fo kunoom isak niŋ hoonool. Ti hinoom ha heewase ha isak niŋ kúsupak, Ateeteyo náayonkalii Móyiis púfulii ti pututa háaputa ha. ");
INSERT INTO krx_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ta pakati Israyel nkacuke ta hamake ha hiti Ateeteyo ti pisempuc tíntiŋ ya, incukii nii seemak séeceeke. ");
INSERT INTO krx_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Móyiis naanako ti káatiŋu ka, naasilo patiila ti tíntiŋ ya. Naayeno po fo kunoom áwii ésupak (40), hánant hanakan. ");
INSERT INTO krx_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Púful toko, pakati Israyel nkacuk nii Móyiis ákampaniyoo-kampan ti tíntiŋ ya, nkaconcoolo ti Aaron nkasokoo: “Awe, memanool unii pútuun empa efipunow unii hátikin. Kaatuko Móyiis aŋuu, áyiin a éefulanii ya unii ti mah ma miti Esipt úmiit heetaakiyoo.” ");
INSERT INTO krx_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaron naañahanii: “Nífulan pukop sanoo ya peeyem pa ti unuu pakaal aluu niŋ epuuk aluu pákayiin niŋ pakaal, ínnicoopiyam po.” ");
INSERT INTO krx_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Pakati Israyel púlooŋ nkáfulan pukop pa piteyii piti sanoo ya, peeyem pa ti unuuwii, nkácoopii po Aaron. ");
INSERT INTO krx_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Naacoop po náayeluŋan po náanuŋ po ti múuloo, naamemanool himuum sanoo hiti cíciin. Fiye pakati Israyel nkaceek kapusok: “Israyel, ehe pútuun pa putuunaa péefulanii pa unaa Esipt!” ");
INSERT INTO krx_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ta Aaron naacuke ta eeha pakan paka nkayeniye ha íhinu, naalut kaaciin hátikin himuum cíciin ca naasok: “Kacom efuutaakaa pahaaño úpumakiyanaa Ateeteyo.” ");
INSERT INTO krx_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Eti kacom eteyyo mpucom mic, pakan paka incakawaaseen kaawaaseen kenfakat ti kaaciin ka. Pikee púlukuleen pa, nkaleeman po motic; pikee pa, nkawaaseen po kaawaaseen kiti kásuumaay. Kayoŋ ka nkiyeno kipili nkilaan, púful toko nkilito pahaaño. ");
INSERT INTO krx_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Po ti tíntiŋ ya, Ateeteyo naasok Móyiis: “Hiliikan wano, kaatuko pakani payenka ánfulanii ka ti mah ma miti Esipt kamuuyenaa meemak. ");
INSERT INTO krx_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Kakatanaakatan mpacas pítin empa inci insokii pa kanapan. Nkamemanool faŋii cíciin citi sanoo, nkákilipo hátikin etenco nkawaaseen tenco. Nkasok: 'Israyel, ehe pútuun pa putuunaa péefulanii pa unaa ti mah ma miti Esipt!'” ");
INSERT INTO krx_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ateeteyo nene asok Móyiis: “Inci cukaacuk pakan paka payenke, pakan keeyanke ekun. ");
INSERT INTO krx_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Fiye katam inci púwananii káñiken ka kutoom teyii ímpucaloolii. Pale awe, inci fáhin keesokuu maamaa kapimeeŋ nkáyenoonii síi enfakat.” ");
INSERT INTO krx_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Pale Móyiis naaŋiino Ateeteyo Pútuun pa piteyoo naasokoo: “Ateeteyo, weyme uwune aakati wánanii káñiken ka kitii ti pakan paka pakatii payenka ánfulanii ka ti mah ma miti Esipt ti sempe sa siti epeesi? ");
INSERT INTO krx_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Weyme uwune pakati Esipt kati kasok: 'Pakanc puwune Ateeteyo náafulan pakati Israyel ti mah ma mutuunaa, kati amukii ti pítintiŋ pa fo kapa.' Ateeteyo, timpi ñíken, yesan kunuuwi timpi táhii hítaapanu eehuu ti pakani. ");
INSERT INTO krx_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Náwuno Abraham, Isaak niŋ Israyel, pimiikan pa pakatii payenka ansintooliye ka ti faŋi nii: 'Inci fáhin keesokuu maamaa kapimeeŋ samat nii picaaŋaŋ pa piti patiila. Inci fawufanii mah ma púlooŋ emma inci íyyinananii ma, éfimiyenoonii miteyii fo eket maamaa.'” ");
INSERT INTO krx_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Fiye, Ateeteyo naayesan kunuuwoo ti hítaapanu eeha naasoke ha íhinu pakanoo. ");
INSERT INTO krx_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Móyiis náayesoonii, náawanoonii ti tíntiŋ ya, ápiyekanii sínankiin sa súsupak sa seepeefiye sa, la kilim ka keesiiŋanee ka nkikiicee la ti upii wa úsupak wa. ");
INSERT INTO krx_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Sínankiin ensuu, sikina siyem páhin pa piti Pútuun pa, pikina himuum etempo pikiice po. ");
INSERT INTO krx_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Fiye Móyiis niŋ Josuwa kápulohanii, Josuwa náasi paceekal pa piti pakan paka, naasok Móyiis: “Paceekal piti hikam piyem pati pikin pa.” ");
INSERT INTO krx_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Móyiis naañahanoo: “Haani, neetaat paceekal piti keeheeke, niŋ ekina tom paceekal piti payenka nkaheeke, pale caacook inci ínsiye.” ");
INSERT INTO krx_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Emma Móyiis naalohane ma pikin pa naacuk cíciin ca, naacuk pakan paka ti ekii, náañiken naawant pínankiin pa empa hilim ha heesiiŋanee ha nihikiicee pa tempo, mpuhumaloolo t’etaam tíntiŋ ya. ");
INSERT INTO krx_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Naacoop cíciin ca enca nkamemanoole ca naawant co ti seemak sa ínciyeluŋ, náatuum páyeluŋal pa pipiyeno efol, naacoop oom efol apuhoholan yo ti man ma, náahin pakati Israyel kapilaan mo. ");
INSERT INTO krx_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Móyiis naasok Aaron: “Weyme kayoŋ enke nkíhinuu fo áaluuŋ ko ti kaamuuyen kenfakat?” ");
INSERT INTO krx_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron naañahanoo: “Káluma inci luumuu, timpi ñíken ti inci, awe himuumi áameyimeyi fa kayoŋ enke nkílafiye fa íhinu heenaput. ");
INSERT INTO krx_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Kíkeyyookey nkusokam: 'Memanool unii pútuun peekaakaay hinowu unii hátikin kaatuko Móyiis aŋuu, éefulanii ya unii ti mah ma miti Esipt, úmiit heetaakiyoo.' ");
INSERT INTO krx_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Inci iññahanii: 'Aŋa ataake sanoo áfulan yo.' Nkáfulan po nkawufanam. Inci uwwant po ti seemak sa, cíciin ence íncifulii!” ");
INSERT INTO krx_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Móyiis naacuk nii Aaron akataakat pakan paka kápihin héesuumii. Fiye, efikasuu hátikin keepookii ka. ");
INSERT INTO krx_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Ta naacuke ta eehuu, naacaasiiŋo ti putum pikin pa naasok: “Kéelafiye ka Ateeteyo kákey peti inci!” Pakati síi ya eti Lewi púlooŋ nkaconcoolo teyoo. ");
INSERT INTO krx_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Naasokii: “Ehe eeha Ateeteyo Pútuun pa piti Israyel mpusoke ha: 'An óo an ti aluu acoop káakuntu ka kiteyoo, nimuumuusool ti pikin pa innimuk ñúnu aluu niŋ pakatu aluu, pákawii aluu niŋ pikinool aluu.'” ");
INSERT INTO krx_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Pakati síi ya eti Lewi nkáhin eeha Móyiis naasokii ha. Nkamuk oom hinoom pakan máamun síwuli síhaaciil (3,000). ");
INSERT INTO krx_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Móyiis naasok pakati síi ya eti Lewi: “Písik fíyooy, Ateeteyo asampanaa-sampan aluu inniyenanee ti kaapii kati niyeno píhina pa pakateyoo kamma innimukale epuuk aluu pikampaani, ñúnu aluu niŋ pakatu aluu.” ");
INSERT INTO krx_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Eti kacom eteyyo, Móyiis naasok pakan paka: “Nimuuyenaa-muuyen meemak, fiye inci pisilo ti tíntiŋ ya pati Ateeteyo, pikee pa inci íyyiniyoo íhinu apuponket kaamuuyen ka kitaaluu.” ");
INSERT INTO krx_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Móyiis naañoho pati Ateeteyo naasokoo: “Káluma, pakan paka payenke kamuuyenaa-muuyen meemak kamma nkamemanoole faŋii pútuun piti sanoo. ");
INSERT INTO krx_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Inci luumuu ponketii kaamuuyen ka kiteyii, niŋ fotom káluma, intoot caacawam ti púkoo ya la ankiice la ucaw wa uti pakani.” ");
INSERT INTO krx_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ateeteyo naañahanoo: “Haani, ucaw keemuuyene ka ti inci, poko inci fatoot ti púkoo ya etoom. ");
INSERT INTO krx_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Fiye kaay coop kayoŋ enkuu pa inci insokuu pa. Síitan, maleekoo ya etoom efeenowi hátikin. Pale caanak unca ti ékey ta inci inkaakaay ta kaasiiŋan pakan paka payenkuu ti pisiya kamma kaamuuyen ka kiteyii.” ");
INSERT INTO krx_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ateeteyo náatahii hítaapanu ti pakan paka kamma nkáluuŋe Aaron apimemanool cíciin ca. ");
INSERT INTO krx_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Ateeteyo naasok Móyiis: “Níful le, awe niŋ kayoŋ enka ánfulanii ka Esipt innikaay ti mah emma inci insintooliye ma Abraham, Isaak niŋ Jakob nii fawufan mo keesokii maamaa. ");
INSERT INTO krx_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Inci fapoñ maleekoo epinow aluu hátikin. Inci fayaan pakati Kanaan, pakati Amol, pakati Het, pakati Pelis, pakati Hiw niŋ pakati Yepus. ");
INSERT INTO krx_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Efininako ti mah ma meemeeŋe ma keekee niŋ múkum. Pale inci himuumam etikaay niŋ aluu kaatuko niyankaayank ekun; niŋ inci kaayaa niŋ aluu fápucalool aluu pántoon ti pítin pa.” ");
INSERT INTO krx_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Móyiis náatuunan kilim enkuu pakan paka. Ta kayoŋ ka nkísiye ta kilim ka keefeyanana enkuu nkiyeno esampoolo, ekina neewun kásankalooliit. ");
INSERT INTO krx_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Kaatuko Ateeteyo asokaasok hínum Móyiis: “Sok pakati Israyel: 'Niyankaayank ekun; niŋ inci kaayaa niŋ aluu étuulaaŋanaa, fápucalool aluu pántoon. Nífulan pukop pa niŋ pikeenoo pa pitaaluu, inci fasincan fa inci fáhin niŋ aluu.'” ");
INSERT INTO krx_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ekina ewune písik ta nkayeniye ta pukol tíntiŋ ya eti Horeb, pakati Israyel nkawaat pukop pa niŋ pikeenoo pa piteyii. ");
INSERT INTO krx_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Ti oom caanak, intaak ékuut eyya Móyiis naaluwe caacaw ca “ékuut ya eti pipaakool pa”. Fiye, Móyiis naacoop yo naasiiŋan yo tíkitaaŋ pikin pa épilaaŋ po. An óo an éelafiye káakup niŋ Ateeteyo, náaful ti pikin pa naakaay pati ékuut ya eti pipaakool pa. ");
INSERT INTO krx_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Tan óo tan Móyiis naayeniye pikaayu lati ékuut ya, an óo an naalito naasiiŋo ti putum ékuut ya eteyoo apisincan Móyiis fo anako. ");
INSERT INTO krx_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Niŋ Móyiis anakiyaa ti ékuut ya eti pipaakool pa, háaputa ha henfakat ha heekaaye ha patiila nihisiiŋo ti putum ékuut ya, Ateeteyo naayeno káakup niŋ Móyiis. ");
INSERT INTO krx_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Ta pakan paka nkacuk ta háaputa ha nihisiiŋiye ti putum ékuut ya, an óo an náakilipo puhooŋuyoo t’etaam ti putum pa piti ékuut ya eteyoo. ");
INSERT INTO krx_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ateeteyo náakup niŋ Móyiis kápucoonool samat nii fa an nákup fa niŋ áwiyoo an. Púful toko Móyiis náañohoonii ti pikin pa, pale ayankanana ya ateyoo Josuwa, akampaani ya ati Nun, naatowo po ti ékuut ya eti pipaakool pa. ");
INSERT INTO krx_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Fiye, Móyiis naasok Ateeteyo: “Síitan, Ateeteyo! Awe sokaam: 'Coop payenke.' Pale áayisanutam aŋa aafapoñ niŋ inci apiyankananam. Apan awe sokaam: 'Méyiyuumeyi meemak, kitii lompo nkúsuumam.' ");
INSERT INTO krx_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Fiye káluma, niŋ kutoom kúsuumuu yísanam heeyem ha ti kunuuwi, ancuk inci méyiyuu, kutoom lompo nkúsuumi. Náwuno lompo nii síi eyye pakani.” ");
INSERT INTO krx_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ateeteyo naañahanoo: “Inci himuumam fanapool niŋ awe iyyihani, kunuuwi nkipepan.” ");
INSERT INTO krx_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Móyiis naasokoo: “Niŋ awe himuumi napoolut niŋ unii, timpi sok unii úful le. ");
INSERT INTO krx_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Niŋ awe napoolut niŋ unii, inci niŋ pakani, puume an áfaameyi nii kutoonii kúsuumuusuum? Piyeno pa pitii ti pututa unii efipuwun etuukuf niŋ pikee písii pa púlooŋ piti etaam ya.” ");
INSERT INTO krx_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ateeteyo naañahan Móyiis: “Fiye inci fáhin eeha ansoke ha, kaatuko kitii kúsuumaamsuum ímmeyiyi meemak.” ");
INSERT INTO krx_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Móyiis naasokoo: “Káluma katam pucuk ecaaŋ ya eti hamake ha hitii!” ");
INSERT INTO krx_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ateeteyo naañahanoo: “Inci famuus hátikini íyyisani panap pa putoom púlooŋ, iyyonkal caacawam 'Ateeteyo' ancuk aakati sí co. Iyyísanyisan pálafi niŋ paket hikaw ti payenka inci immamale ka. ");
INSERT INTO krx_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Pale aayinaat hicuku puhooŋuyam kaatuko an ayinaatam hicuku naaloŋ kaloŋa.” ");
INSERT INTO krx_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ateeteyo nene asokoo: “Ehe énankiin pukolam, kéy siiŋo teyyo. ");
INSERT INTO krx_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Fiye niŋ ecaaŋ ya eti hamake ha hitoom emuusaa, inci fayoli ti kawuŋ ka keeyem ka ti énankiin ya úwwufalooli niŋ epeesam fo ta inci famuus. ");
INSERT INTO krx_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Niŋ fúlaa toko fáfulan epeesam aakati yíni hicuku pusonam pale puhooŋuyam piyinaatee hicuku.” ");
INSERT INTO krx_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ateeteyo naasok Móyiis: “Wuc sínankiin súsupak seepeefiye seenakoole niŋ sícook sa ensa anhumaloole sa. Inci fakiic toko kilim ka keekiicee ka hínum ti sícook sa. ");
INSERT INTO krx_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Memanoolo, kacom mpucom insilo patiila pisempuc tíntiŋ ya eti Sinayi, aakati siiŋo hátikinam. ");
INSERT INTO krx_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","An timpi ánapoolii niŋ awe, an timpi akaay pan óo pan ti kanaac tíntiŋ ya. Háati púlukuleen pa - písaacii pa, pifil pa niŋ síis sa - timpi puhoon pukol tíntiŋ ya.” ");
INSERT INTO krx_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Móyiis naawuc sínankiin súsupak seepeefiye seenakoole niŋ sícook sa. Eti kacom eteyyo mpucom mic naasilo ti tíntiŋ ya eti Sinayi samat nii fa Ateeteyo naasoke fa, naacoopool sínankiin sa súsupak sa. ");
INSERT INTO krx_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Móyiis apucol, Ateeteyo náawanoonii ti háaputa ha naasiiŋo pukoloo, naayonkal caacawoo “Ateeteyo”. ");
INSERT INTO krx_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Púful toko naamuus hátikin Móyiis naasok: “Inci yem Ateeteyo, Pútuun pa peemeeŋe pa panap niŋ paket hikaw, inci fíisantoo káñiken, immeeŋ pálafi niŋ pucoonool. ");
INSERT INTO krx_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Iyyísan pálafi pa putoom fo ti sikaay siyema wúli (1,000). Imponket heenaput ha niŋ kaamuuyen ka púlooŋ. Pale inci cokantoo eelaahe samat nii éehinut likee. Insiiŋan-siiŋan ti pisiya keemuuyene ka ti inci nkanatam, insiiŋan ti pisiya lompo epuukii niŋ keesokii maamaa fo ti sikaay síhaaciil niŋ fotom sipaakiil.” ");
INSERT INTO krx_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Móyiis naahaaŋ ti ékilipo puhooŋuyoo t’etaam hátikin Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Púful toko naasok: “Ati Pútuun, niŋ kutoom kúsuumuu inci luumuu napool niŋ unii. Inci méyimeyi nii pakan paka payenke kayankaayank ekun, pale ponket umuuyen wa utoonii niŋ hilaahu ha hitoonii, incok unii pakani.” ");
INSERT INTO krx_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ateeteyo naasok Móyiis: “Síitan, inci piliil písiyool niŋ aluu. Inci fáhin hátikin pakani púlooŋ weecukantee weetaapala utaako ti písii pa púlooŋ, pan óo pan ti etaam ya. Pakan paka púlooŋ keeyem ka niŋ awe efikacuk heefeyanana eeha Ateeteyo naakaakaay ha íhinu pínapii ti awe. ");
INSERT INTO krx_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Eeha inci iyyem ha aluu ti hisoku fíyooy, níhin ho pinap. Inci fayaan hátikin aluu pakati Amol, pakati Kanaan, pakati Het, pakati Pelis, pakati Hiw niŋ pakati Yepus. ");
INSERT INTO krx_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Nitah kunuu timpi niliil písiyool niŋ pakan paka pakati mah emma efininako ma temmo kaatuko éfinkaluuŋ aluu ti kaamuuyen. ");
INSERT INTO krx_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Pale efinihancalool uciin wa uteyii, ínnipucalool pínankiin pa piteyii piti meeñeya ma, innifiit kumuum énaati ya eteyii eeyaale ya eyya nkasok ya Asela. ");
INSERT INTO krx_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Timpi nítuul pikee pútuun kaatuko inci Ateeteyo caacawam 'Pasowe', Pútuun peesowa. ");
INSERT INTO krx_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Timpi niliil písiyool niŋ pakan paka pakati mah ma. Niŋ ekina tom, kéesuuniye ka ti kaawaaseen pínaati pa piteyii efikayonkal aluu ínnilafi hili paliyal empa nkawaaseene pa pínaati pa. ");
INSERT INTO krx_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Niŋ nicoopaa ti epuukii púmaacul kápiyenoonii pakaal epuuk aluu, epuukii púmaacul éfikahin lompo epuuk aluu kápusuuno ti kaawaaseen pínaati pa piteyii. ");
INSERT INTO krx_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Timpi níyeluŋan mañ ínninuŋ mo ti púmuuloo kati nimemanool pínaati piti mañ. ");
INSERT INTO krx_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Efínihin pahaaño pa piti kúmpuul ka keetaakut ka leweñoo. Nili kúmpuul keetaakut leweñoo fo kunoom isak niŋ kúsupak, samat nii fa inci insoke fa aluu. Níhin eehuu ta nihiñaŋe ta pitaako ti hiim ha hiti Apip, kaatuko ti oom hiim ínnifulii ti mah ma miti Esipt. ");
INSERT INTO krx_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Cikampaani óo cikampaani cíyaañ, citoom, niŋ lompo élukuleen óo élukuleen etaaluu éeyiine éyaañ, etoom: síis sa, pifil pa niŋ písaacii pa. ");
INSERT INTO krx_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Niŋ nitaakaa cífali céeyiine cíyaañ ceepukee, ínnilafiyaa cífali ca cipiloŋ, niñaŋaa kaawaaseen císaacii ti putum etenco. Inníhinut fo, innifiit ekun etenco. Iyyema añii akampaani áyaañ apukee ti miin ma mitaaluu, fo niwaaseen císaacii ti putum pa piteyoo, ancuk añii ya aloŋaa. “An timpi ákey hátikinam sipeesoo ñaanii. ");
INSERT INTO krx_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Kunoom isak niŋ hoonool innitaake ti lóokuŋ ya kiti páhin, pale heewase ha isak niŋ kúsupak ínniyekunoolo háati ti caanak ca citi piya pa niŋ citi kaamaañ ka. ");
INSERT INTO krx_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Inníyaañaa kaamaañ uli, níhin pahaaño pa piti kaamaañ ka; innipayaa kaamaañ ka, níhin pahaaño pa piti kaaconcenool pamaañal pa. ");
INSERT INTO krx_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Etiil óo etiil, pákayiin paka púlooŋ pakati kayoŋ ka kitaaluu éfinkakey hátikinam fo ñiyema ñáhaaciil, inci Ateeteyo, Pútuun pa piti Israyel. ");
INSERT INTO krx_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Fayaan hátikin aluu písii pa piti mah ma, incoop etaam ya eteyii uwwufan yo aluu, ancuk penanaa etaam ya etaaluu. Inníkeyyoo nipisiiŋo hátikinam ti ñáhaaciil eññuu, inci Ateeteyo Pútuun pa pitaaluu, an átalafi hicoopu mah ma mitaaluu. ");
INSERT INTO krx_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Niŋ niyeniyaam kaawaaseen púlukuleen, hísim etempo timpi hinapool niŋ waah weetaake leweñoo. Timpi nimank efoofa ya eti kaawaaseen ka eti pahaaño pa piti Himuusu ha fo eti kacom eteyyo. ");
INSERT INTO krx_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Etiil óo etiil, weehaŋe wa panap ti pamaañal pa púcook pa piti pitaam pa pitaaluu, éfinicoopii po ti ekumpaan ya etoom, inci Ateeteyo Pútuun pa pitaaluu. “Etiniyik cifil niŋ miin ma miti íññaa etenco.” ");
INSERT INTO krx_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ateeteyo naasok Móyiis: “Kiic kilim enke, kaatuko ti kilim enke inci illiile naaluu písiyool pa putoom, awe niŋ Israyel.” ");
INSERT INTO krx_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Móyiis naayeno toko niŋ Ateeteyo hánant hanakan fo kunoom áwii ésupak (40), aliit alaanut. Naakiic ti sínankiin sa seepeefiye sa kilim ka ŋaasuwan ya kiti písiyool pa. ");
INSERT INTO krx_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Móyiis náawanoonii ti tíntiŋ ya eti Sinayi niŋ sínankiin sa súsupak sa siti hilim ha heesiiŋanee ha ti epeesoo. Kákupat ka kiteyoo niŋ Ateeteyo kuwune puhooŋuyoo mpimiñal, pale ámiit. ");
INSERT INTO krx_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aaron niŋ pakati Israyel púlooŋ ta nkacuke ta fa puhooŋu pa piti Móyiis mpimiñale fa nkafe hikoluyoo. ");
INSERT INTO krx_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Pale Móyiis naayonkalii, Aaron niŋ pakati kikaw ka púlooŋ pakati Israyel nkañoho ti Móyiis, náakup neyii. ");
INSERT INTO krx_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Púful toko pakati Israyel púlooŋ nkaloh Móyiis, naasokii hilim ha heesiiŋanee ha púlooŋ eeha Ateeteyo naawufanoo ha ti tíntiŋ ya eti Sinayi. ");
INSERT INTO krx_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ta Móyiis naapaye ta káakup neyii naacoop kafonkoloŋ ápikimpitool puhooŋuyoo. ");
INSERT INTO krx_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Pale tan óo tan ta Móyiis naanakiye ti ékuut ya eti Ateeteyo kati ákup neyoo náafulan kafonkoloŋ ka fo ta áfaafulii. Niŋ áfuliyoo naakaman pakati Israyel waah óo waah ewwa Ateeteyo naasokoo. ");
INSERT INTO krx_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Pakati Israyel nkacuk puhooŋuyoo fa mpimiñale fa. Niŋ fúlaa toko, Móyiis naañahan kafonkoloŋ ka ti puhooŋuyoo, toko nakat ko fo ta afaañoho káakup niŋ Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Awe Teyofil eñaap ya, keemeeŋe kacukaacuk niŋ ñíkinii eeha Pútuun pa mpíhine ha púlooŋ ti píyaañ eteeho toonii. Nkáyenoonii pikamana hilim ha hiti Pútuun pa. Keemeeŋe toonii nkayeno ho hikiicu samat nii fa nkakamane ho fa unii. ");
INSERT INTO krx_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kápiliŋ ti píyaañ waah ewwe fo ti pikelan, inci úwwincinoole heetaakiye púlooŋ. Ekina ewune, insok nii napaanap pikiici, awe Teyofil, pakiical peetempiye mpucoonool ");
INSERT INTO krx_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","aakati méyi nii eeha nkakalaŋanuu ha, hilim hiti pánipani. ");
INSERT INTO krx_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ti caanak ca citi amansa ya aŋa nkasok ya Helot ati mah ma miti Judaay, intaako awaaseena ati Pútuun pa aŋa nkasok Sakaliya ati kayoŋ ka kiti puwaaseena pa enka nkasok ka Apiya. Aaloo caacawoo Elisabet, náafulii ti miin ma miti Aaron. ");
INSERT INTO krx_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Poko t’ésupakii keecoonoole hátikin Pútuun pa, nkanapan pítin etempo, nkacok púlooŋ hilim ha heesiiŋanee ha hiti Ateeteyo fo muus. ");
INSERT INTO krx_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pale kataakut añii kamma Elisabet naayem caakonta, apan poko púlooŋ pamaamanal. ");
INSERT INTO krx_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Hikee hinoom Sakaliya naayeno kaawaaseen la ti ekumpaan ya enfakat ya eti Pútuun pa loho hinoom ha hiti kayoŋ ka kiteyii hícoliyoo. ");
INSERT INTO krx_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ti cosaan ya eti puwaaseena pa nkañako kaakaaw ti kamamal apiyeno aŋa afaanako ya ti ekumpaan ya enfakat ya eti Pútuun pa, la sampanee la, kati áluntan caminkoloŋ ya. ");
INSERT INTO krx_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Waati ya eti káaluntan ka néetuuno, pakan paka púlooŋ nkayeno kaluum tíkitaaŋ. ");
INSERT INTO krx_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Maleekoo ya eti Ateeteyo néefulii teyoo, episiiŋiyoo t’epees yáali eti kaaciin ka la nkáluntan la. ");
INSERT INTO krx_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakaliya naacuk yo naasuco naafe. ");
INSERT INTO krx_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Maleekoo ya neesokoo: “Timpi fe Sakaliya, kaluum ka kitii kisayaneesayan, aali Elisabet afaataak añii aafaluwoo caacaw ence: Saŋ. ");
INSERT INTO krx_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Afaayeno ti awe pásuuma penfakat, hícump pakan lompo efikataak pásuuma ti hipuku ha hiteyoo. ");
INSERT INTO krx_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Afáayenoonii an eemaka ti Ateeteyo, añaŋut pálaani elaan niŋ pikee palaanal empa mpúkuman. Le niŋ afaapukee, afaameeŋ niŋ Kunuu ka keenape ka. ");
INSERT INTO krx_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Afáañahanii pakan keemeeŋe pakati Israyel ti Ateeteyo Pútuun pa piteyii. ");
INSERT INTO krx_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Afáanowii hátikin Ateeteyo ti kunuu niŋ ti sempe samat nii ayaamakoola ya Elí, áfaañahanii ñífaaf ña kápisiyool niŋ epuukii, náañahanii kéeciita ka káakup ti pámiiloolal peenape, kati amemanool pakan paka ti Ateeteyo.” ");
INSERT INTO krx_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakaliya naacakan maleekoo ya: “Puume inci fáyini kameye eehuu? Inci oopa maamane aalam lompo sitiiloo séelaaŋane.” ");
INSERT INTO krx_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Maleekoo ya neesokoo: “Inci yem Gabriyel. Inci ninsiiŋo hátikin Pútuun pa, inci mpúpoñii píkey soki ekooŋan ya éesuume eyye. ");
INSERT INTO krx_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Síitan, ti káyinanaati kilimam, putumi efipucok, áatiyini káakup fo ta eehe efihitaako. Pánipani kilim ka kutoom efikitaako incolaa toko.” ");
INSERT INTO krx_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Pakan paka nkayeno hítuulu ínnimii heewune Sakaliya náafiyoonii páhantuwa ekumpaan ya enfakat ya eti Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Emma náafulii ma ayinaat káakup neyii nkámeyi nii aŋe ácukiyoocuk waah páhantuwa ti ekumpaan ya enfakat ya eti Pútuun pa. Naayeno ínkaakupaati fo káakup niŋ sipees. ");
INSERT INTO krx_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Lóokuŋ ya eti kaawaaseen ka kiteyoo ta nkipaye ta, naañoho t’enuuf. ");
INSERT INTO krx_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Fiyiit aaloo Elisabet naasa munow naayolo nemmo páhantuwa fo kiim isak. ");
INSERT INTO krx_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Naasok: “Fiye Ateeteyo náahinaam eehe, áfulanaam ti ñusuu ti pakan paka.” ");
INSERT INTO krx_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet ti hiimoo hísakiyenu niŋ hoonool hiti munow, Pútuun pa mpúpoñii maleekoo ya eyya nkasok ya Gabriyel ti mah ma miti Galilee ti saatee ya eti Naasalet. ");
INSERT INTO krx_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Mpupoñ yo ti ámaacul a aŋa nkasok ya Mari, aŋa Josef ati miin ma miti cáwii ca citi Dawid naaŋaame ya ekop. ");
INSERT INTO krx_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Maleekoo ya neenako la teyoo neesokoo: “Kásuumaay kiyeno niŋ awe, awe aŋa ataake ya pálafi pa piti Ateeteyo. Ateeteyo oopa niŋ awe.” ");
INSERT INTO krx_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mpásiyaloo kilim enkuu Mari naaliim naayeno ecakanoolo pakicanal puume mpaaw. ");
INSERT INTO krx_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Maleekoo ya neesokoo: “Timpi fe Mari, áasuumaasuum Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Síitan inci pusoki, aafasa munow ímpukii ciñii cikampaani aakati luwoo caacaw ca Yéesu. ");
INSERT INTO krx_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Afaayeno an eemaka, afaayonkalee Añii ya ati Pútuun pa piti patiila. Ateeteyo Pútuun pa efipuwufanoo elemeyu ya eti amansa ya eti maamayoo Dawid, ");
INSERT INTO krx_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","afaapampaŋan ti miin ma miti Jakob, cáwii ca citeyoo eticipa.” ");
INSERT INTO krx_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari naañahan yo: “Eehe puume nihiyina pitaako inci péemiit áyiin?” ");
INSERT INTO krx_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Maleekoo ya neesokoo: “Kunuu ka keenape ka éfikuwanoonii ti awe, sempe sa siti Pútuun pa piti patiila ínsikimpitooli, ekina ewune añii ya aŋa ankaakaay ya hipuku afaayeno eesampanee, naasokee Añii ya ati Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Sincan Elisabet atii ya aŋa nkasoke ya caakonta, ti himaamanoo oopa niŋ munow miti kiim isak niŋ hoonool miti cikampaani. ");
INSERT INTO krx_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Méyi nii waah uheekut Pútuun pa.” ");
INSERT INTO krx_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mari naañahan yo: “Iyyoo, inci yem amiikan a ati Ateeteyo, hitaako ti inci samat nii fa ansoke fa.” Maleekoo ya neekaay. ");
INSERT INTO krx_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ti kunoom enkuu Mari naakaay mpacas ti saatee ya eti pítintiŋ pa ti mah ma miti Judaay, ");
INSERT INTO krx_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","apinako la ti ekumpaan ya eti Sakaliya, naakican Elisabet. ");
INSERT INTO krx_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ta Elisabet náasiye ta Mari pakicanaloo añii ya naawen ti munowoo, Elisabet naameeŋ niŋ Kunuu ka keenape ka. ");
INSERT INTO krx_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Naaceek apusok: “Awe Pútuun pa mpíhine heehaŋe ha panap ti pakaal paka púlooŋ, efi lompo píhin heehaŋe ha panap ti añii ya aŋa ankaakaay ya hipuku! ");
INSERT INTO krx_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Puume inci ínnapiyenee fiye, íññaa ya ati Ateeteyo atoom kati mpáakeyyam hiyoop? ");
INSERT INTO krx_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Sincan, emma inci ínsiye ma pakicanali añii aŋe ti munowam naawen ti pásuuma. ");
INSERT INTO krx_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Aánapiyanee awe aŋa yínane ya ti eeha Ateeteyo mpusoke ha nii efihitaako.” ");
INSERT INTO krx_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mari naaceek apusok: “Yaanam émulaa Ateeteyo! ");
INSERT INTO krx_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","49","Kamma Pútuun pa mpítahii kunuu etempo ti inci amiikan a atempo ásikateen a, ekina ewune kunuuwam kimeeŋaa niŋ pásuuma ti Pútuun pa Afakana ya atoom. Kamma Pútuun pa piti sempe mpíhinaam waah wenfakat, ekina ewune, písik fíyooy pikaay pa púlooŋ efimpiyonkalam ati pásuuma. Caacaw etempo ceesampanee. ");
INSERT INTO krx_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pitaakaataak paket hikaw ti keefeye po ka fo ti ekaay óo ekaay. ");
INSERT INTO krx_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Mpíyisan hamake ha niŋ epees etempo; mpihancalool kéemakiyanooliye ka ti pakan paka. ");
INSERT INTO krx_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mpúwananii pumansa pa ti pilemeyu pa piteyii, pale, mpíseepin písikateen pa. ");
INSERT INTO krx_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Mpisiitan keeyeniye ka ti peep pa niŋ waah weenape, pale, mpiyaan keetaake ka kapuñoho sipeesii ñaanii. ");
INSERT INTO krx_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Mpiyankanan amiikan etempo Israyel, ti énawuno paket hikaw etempo. ");
INSERT INTO krx_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Eehuu mpíyinanane símaama unaa Abraham niŋ miin ma miteyoo fo caanak óo caanak.” ");
INSERT INTO krx_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari naayeno pati Elisabet fo kiim káhaaciil apite añoho pateyoo. ");
INSERT INTO krx_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Púful toko, Elisabet íyyiŋooliyoo, náapukii cikampaani. ");
INSERT INTO krx_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pikinooloo niŋ miin ma miteyoo nkási nii Ateeteyo áhinoohin henfakat niŋ paket hikaw, nkananfool ti pásuuma pa piteyoo. ");
INSERT INTO krx_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Añii ya ta naataake ta kunoom isak niŋ kíhaaciil nkákey kapinakanoo ti písiyool empa Pútuun pa mpiliile pa niŋ maamaa ateyii Abraham, nkálafiyoo kawufan caacaw ca citi faafoo Sakaliya. ");
INSERT INTO krx_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Elisabet naacoop hilim ha naasokii: “Haani! Caacawoo ciñaŋaa piyeno Saŋ.” ");
INSERT INTO krx_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nkasokoo: “Pale an aneetaat ti miin ma miti aluu aŋa ataake caacaw encuu.” ");
INSERT INTO krx_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nkákup niŋ sipees, kapicakan faafoo enceyme caacaw náalafiye kawufan añiinoo. ");
INSERT INTO krx_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Naasokii kawufanoo káakiicuma, naakiic: “Caacawoo Saŋ.” Pakan paka púlooŋ ínnimii. ");
INSERT INTO krx_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tokotoko putumoo mpípankino, híleeluufuyoo nihikatan, náayini káakup, náayaañ kaanimpan Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ewatate enfakat neeyeno ti pikinoolii púlooŋ niŋ keekine ka ti pisaatee pa piti pítintiŋ pa ti mah ma miti Judaay, nkayeno káakup heetaakiye ha. ");
INSERT INTO krx_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","An óo an éesiye ho naayeno káamiilool, naasok: “Añii aŋe, an puume naakaakaay piyeno?” Kaatuko sempe sa siti Ateeteyo siyenaayeno teyoo. ");
INSERT INTO krx_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Añii ya, faafoo Sakaliya naameeŋ niŋ Kunuu ka keenape ka naayaamakool hiti Pútuun pa, apusok: ");
INSERT INTO krx_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Unimpanaa Ateeteyo Pútuun pa piti Israyel kamma mpitahe kunuu ti pakan etempo mpifakanii. ");
INSERT INTO krx_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Mpúpoñii unaa Afakana eemaka ati miin ma miti amansa ya Dawid amiikan etempo, ");
INSERT INTO krx_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","eehuu piyaamakoola pa keesampanee ka nkátuunane unaa ti caacaw Pútuun pa ta infiyye ");
INSERT INTO krx_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","nii efipifakan unaa ti pikamool unaa niŋ ti sipees keenate ka unaa púlooŋ. ");
INSERT INTO krx_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mpíyisan símaama unaa paket hikaw, mpínawuno písiyool etempo peesampanee pa, ");
INSERT INTO krx_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","esintoolo eyya mpisintooliye ya ti maamaa unaa Abraham: ");
INSERT INTO krx_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","nii, ta mpifakane ta unaa ti sipees pikamool unaa, éfuuyiniyaa po himiikanate peefeyut ");
INSERT INTO krx_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","nuuyeniyaa pimiikan keesampanee niŋ keecoonoole hátikin etempo fo eket maama. ");
INSERT INTO krx_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Awe añiinam lompo aafayonkalee ayaamakoola ya ati Pútuun pa piti patiila, kamma ankaakaay énowii hátikin Ateeteyo aapuwañaloo pítin pa, ");
INSERT INTO krx_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ti káyisanool pakan etempo kafakan ka ti kaaponket ka kiti umuuyen wa uteyii, ");
INSERT INTO krx_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","kamma Pútuun pa putuunaa mpimeeŋe paket hikaw, ekina ewune aŋa eecaaŋe ya nii caanak céefulii áfaawanoonii ápikey unaa hiyoop, ");
INSERT INTO krx_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","kati acaaŋan keeyem ka ti eloŋ ya eti ñáanim ña niŋ ti hísaalumant ha hiti eket ya, ápitintiŋan unaa ti pítin pa piti kásuumaay ka.” ");
INSERT INTO krx_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Añii ya Saŋ náayankii, kunuuwoo nkítaakii sempe. Naayeno ti káahaaŋ ka tes fo ta náafulii ta ti pakati Israyel. ");
INSERT INTO krx_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ta Saŋ-Patis naapukee ta, amansa ya enfakat a aŋa nkasok ya Ookust náafulanii hilim nii an óo an ti mah ma miti Room púlooŋ añaŋee hikiicu caacawoo. ");
INSERT INTO krx_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Oom hikiicu hiyeniye híyaañ ta Kileños naayeniye ta ati hikaw ha ati Siriya. ");
INSERT INTO krx_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","An óo an naañoho ti saatee ya eti cosaan ya eteyoo apikaakiicee po. ");
INSERT INTO krx_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josef lompo náafulii ti saatee ya eti Naasalet ti mah ma miti Galilee apuwant mah ma miti Judaay ti saatee ya eti amansa ya Dawid eyya nkasok ya Betelehem, kamma akina lompo naayem ati miin ma miti maamaa ateyoo Dawid. ");
INSERT INTO krx_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Apikaay hikiicu ha naacoopool Mari aŋa naaŋaame ya ekop, aŋa eeyeniye ya immunow. ");
INSERT INTO krx_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ta nkayeniye ta po, íyyiŋooliyoo, ");
INSERT INTO krx_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","náapukii ciñiinoo cíyaañ, cikampaani. Naakuupatanool co niŋ ñiseehu naahintanoo ti púus kamma nkataakut ékaap la efikawanan. ");
INSERT INTO krx_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ti oom mah intaako ti ukit wa pufaasa keeyeniye efaas niŋ hánant písaacii pa piteyii. ");
INSERT INTO krx_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Maleekoo ya eti Ateeteyo néefulii teyii, ecaaŋ ya enfakat ya eti Ateeteyo néekinkoolii, ewatate enfakat neeyeno neyii. ");
INSERT INTO krx_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Maleekoo ya neesokii: “Timpi nife, cóopiyoocoop aluu ekooŋan éesuume eti pásuuma penfakat piti pakan paka púlooŋ. ");
INSERT INTO krx_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Fíyooy pati saatee ya eti Dawid ciñii cipukee po Afakana ya, akina ayem Eenucee ya, akina lompo ayem Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ehe píyisan empa efinikiiwoo pa tempo, eficanitook nkakuupatanoole ciñii niŋ ñiseehu nkahintan co ti púus.” ");
INSERT INTO krx_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tokotoko kayoŋ kenfakat kiti pumaleekoo nkúfulii alacana nkinanf maleekoo ya nkiyeno kaanimpan Pútuun pa, nkiyeno hisoku: ");
INSERT INTO krx_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Umúlaa Pútuun pa piti patiila, kásuumaay nkiyeno t’etaam ti payenka mpitaake ka pásuuma etempo.” ");
INSERT INTO krx_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ta pumaleekoo pa mpuñohiye ta patiila pufaasa pa nkasokool: “Ukaayaa Betelehem hicuku heetaakiye ha, eeha Ateeteyo naasoke ha unaa.” ");
INSERT INTO krx_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nkahiliikan, kapucol nkatook Mari, Josef niŋ ciñii ca ceehintanee ca ti púus pa. ");
INSERT INTO krx_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ta nkacukoo ta nkayeno kakaman eeha maleekoo ya neesokii ha kiti añii ya. ");
INSERT INTO krx_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kéesiye ho ka púlooŋ ínnimii ti eeha pufaasa pa nkasokii ha. ");
INSERT INTO krx_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pale Mari naamank eehe púlooŋ ti kunuuwoo náamiilool ho meemak. ");
INSERT INTO krx_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pufaasa pa ta nkayeniye ta puñoho, nkayeno hímulu niŋ kaanimpan Pútuun pa kamma eeha nkásiye ha nkacuk samat nii fa maleekoo ya neesokii fa. ");
INSERT INTO krx_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ta naataake ta kunoom isak niŋ kíhaaciil, nkanakanoo ti písiyool empa Pútuun pa mpiliile pa niŋ maamaa ateyii Abraham, nkaluwoo caacaw ca Yéesu, samat nii fa maleekoo ya neesoke fa íññaa ateyoo peelokot asa munow. ");
INSERT INTO krx_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Hinoom ha hiti kaakuulan ka kiti hipuku ha níhicolii, kaakuulan ka keekiice ka ti hilim ha heesiiŋanee ha hiti Móyiis. Josef niŋ Mari nkacoop ciñii ca Jerusalem kápiyisanoo Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Inhínee nii heekiicee ha ti hilim ha heesiiŋanee ha hiti Ateeteyo: “Niŋ añii áyiin ácook apukee añaŋee kañoman Ateeteyo.” ");
INSERT INTO krx_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kañaŋaa lompo kaawaaseen toko sílunt súsupak niŋ fotom múcuucuuku músupak samat nii fa insokee fa ti hilim ha heesiiŋanee ha hiti Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Intaako Jerusalem akee áyiin caacawoo Simeyon. Ayíin eecoonoole naafe Pútuun pa, naayeno hítuulu aŋa akaakaay ékey kaapuuñanool Israyel. Kunuu ka keenape ka nkiyeno teyoo, ");
INSERT INTO krx_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","nkíyisanoo nii ataket akina peecukut Eenucee ya ati Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kunuu ka keenape ka nkítintiŋanoo apikaay pati hank ha hiti ekumpaan ya enfakat ya eti Pútuun pa. Ta Yéesu pupukayoo nkácoopiyoo ta kati káhinoo eeha hilim ha heesiiŋanee ha hiti Móyiis fa nihisoke fa, ");
INSERT INTO krx_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeyon naafenfo ciñii ca ti sipeesoo naanimpan Pútuun pa apusok: ");
INSERT INTO krx_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Kamma inci incuke niŋ ñíkinam kafakan ka kitii, ekina ewune Ateeteyo, fiye aayina hikatu amiikan a atii apiket ti kásuumaay samat nii fa áyyinananaam fa; ");
INSERT INTO krx_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","kafakan ka enka ammemanoole ka hátikin písii pa púlooŋ, ");
INSERT INTO krx_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ecaaŋ ya eyya éfeeyisan keeneetaat ka Pusuwif Pútuun pa, néecoopii pakani Israyel hamake ha.” ");
INSERT INTO krx_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ciñii ca faafoo niŋ íññaa ateyoo ínnimii ti keesokee ka kiti ciñii ca. ");
INSERT INTO krx_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeyon naasampanii, naasok íññaa ateyoo Mari: “Síitan, añii ya aŋe Pútuun pa pimamaloomamal kati ácoopii enow ya eti pakan keemeeŋe pakati Israyel niŋ piyito pa piti pakakee pakan keemeeŋe. Afaayeno píyisan pa piti Pútuun pa empa pakan paka nkakaakaay pa hipooku, ");
INSERT INTO krx_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","kati áfulanii tíkitaaŋ pámiiloolal pa peeyoliye pa ti kunuu hícump pakan. Awe íññaa ateyoo lompo kúnuul efikiyeno ti yaani samat nii aŋa epaay neeyaye.” ");
INSERT INTO krx_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Intaako akee aal ayaamakoola eemaamane caacawoo Hanna, faafoo Fanuwel, ati miin ma miti Asel. Apinimo ti áyiinoo fo sitiil isak niŋ súsupak, áyiinoo naaket. ");
INSERT INTO krx_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nene animiit, sitiiloo áwii epaakiil niŋ sipaakiil (84). Afúlantoo pati hank ha hiti ekumpaan ya enfakat ya eti Pútuun pa, náatuul po ti suŋ niŋ ti kaluum hánant niŋ hanakan. ");
INSERT INTO krx_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ti oom caanak, ápucolii teyii, naanimpan Pútuun pa, naayeno hisoku kiti ciñii ca hátikin keeyeniye ka púlooŋ hítuulu kafakan ka kiti Jerusalem. ");
INSERT INTO krx_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ta Josef niŋ Mari nkapayoole ta fa ínhinee fa samat nii fa insokee fa ti hilim ha heesiiŋanee ha hiti Ateeteyo, nkayet Galilee pati saatee ya eteyii Naasalet. ");
INSERT INTO krx_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Añii ya náayankii niŋ sempe; naameeŋ ecohato, pálafi pa piti Pútuun pa mpiyeno teyoo. ");
INSERT INTO krx_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Esúk óo ésuk Yéesu pupukayoo nkakaakaay Jerusalem pahaaño pa piti Himuusu ha. ");
INSERT INTO krx_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ta naataake ta sitiil ŋaasuwan niŋ súsupak, nkasilo Jerusalem pahaaño pa, samat nii fa cosaan ya eteyii neesoke fa. ");
INSERT INTO krx_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pahaaño pa pipipa nkayeno puñoho, akampaani ya Yéesu náatowoonii puson Jerusalem, pale pupukayoo kápannumut. ");
INSERT INTO krx_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Incukii nii oopa ti pinamii, kapisapal fo hinoom púmpuluŋ, nkáyaañoo hiŋes ti pakanii niŋ ti pinapoolii. ");
INSERT INTO krx_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ta nkacukutoo ta nkañoho Jerusalem hiŋesoo. ");
INSERT INTO krx_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ti hinoom ha híhaaciyenu ha nkalaŋanoo la ti hank ha hiti ekumpaan ya enfakat ya eti Pútuun pa naayeniye niŋ pikalaŋana pa, apiyeno káasiitan teyii niŋ kaacakanoolii. ");
INSERT INTO krx_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","An óo an éesiyoo ínnimoo ti kameye ka kiteyoo niŋ ti pañahanaloo. ");
INSERT INTO krx_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Pupukayoo kapucukoo, nkaŋaŋo. Iññáa ateyoo naasokoo: “Añiinam, weyme ánhine unii fiye? Paapaa atii niŋ inci uliimaaliim meemak ti hiŋesi.” ");
INSERT INTO krx_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yéesu naañahanii: “Weyme inniŋesam? Fo nímiit nii inci ñaŋaa piyeno ti ekumpaan ya eti Paapaa atoom?” ");
INSERT INTO krx_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pale kásiit eeha náalafiyii ha hisoku. ");
INSERT INTO krx_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Náawanoonii niŋ pupukayoo Naasalet, náatuulii. Iññáa ateyoo naamank enke púlooŋ cew ti kunuuwoo. ");
INSERT INTO krx_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yéesu náayankii niŋ ecohatoyoo niŋ kaacecoo, Pútuun pa niŋ pakan paka nkálafiyoo pihaŋhaŋ toko. ");
INSERT INTO krx_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ti sitiil kaat ya siti Tipel, amansa ya enfakat a ati mah ma miti Room, Pons Pilaat naayeno ati hikaw ha ati Judaay, Helot naayeno ati hikaw ha ati Galilee, atuwoo Filip naayeno ati hikaw ha ati mah ma miti Itulaay niŋ Tilakonit, niŋ Lisañas ati hikaw ha ati Apilen. ");
INSERT INTO krx_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annas niŋ Kayif nkayeno puwaaseena pa kenfakat ka pakati Pútuun pa. Ti oom caanak hilim ha hiti Pútuun pa níhicolii ti Saŋ, Sakaliya añiinoo, pati káahaaŋ ka tes. ");
INSERT INTO krx_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Saŋ naayeno kaafiitanool mah ma púlooŋ meekole ma musuu ma miti Jordan, apiyeniyii káatuunan: “Níhin pátise nípiyisan nii níwunkaawunko umuuyen wa utaaluu, Pútuun pa kati puponket wo aluu.” ");
INSERT INTO krx_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Samat nii hilim ha heekiice ha ti púkoo ya eti ayaamakoola ya Esaaya: “An oopa ti hiceeku ti káahaaŋ ka tes, 'niwañal pítin pa piti Ateeteyo, nicoonanool ñítin ña ñiteyoo. ");
INSERT INTO krx_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Eliiŋoon óo eliiŋoon efeehokanee, tíntiŋ óo tíntiŋ niŋ cítintiŋ óo cítintiŋ éfipitamiyanee. Ñítin ña ñeeŋoncalooliye ña efiñicoonanoolee, ñítin ña ñiti pínankiin pa efiñiteecanoolee. ");
INSERT INTO krx_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Pakan paka púlooŋ efikacuk kafakan ka kiti Pútuun pa.'” ");
INSERT INTO krx_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Saŋ naasok kayoŋ ka kéekeyii ka kati áhinii pátise: “Aluu mifepa emmuu! Ayme ákupanane aluu kati nitey paseeña pa piti Pútuun pa peeyem pa ti ékey? ");
INSERT INTO krx_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Níhin waah weenape samat nii enuun eyya nepuk papukal peenape. Fiyuu éfiyisan nii níwunkaawunko umuuyen wa utaaluu. Timpi níyaañ esokoolo nii: 'Unaa ufakaafak kamma Abraham naayem maamaa ati unaa.' Kaatuko inci pusok aluu háati ti pínankiin empe Pútuun pa píyiniyini éfulanii epuuk pakati Abraham. ");
INSERT INTO krx_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ehe hinahaane ha nihihintanee ti ñínkonk punuun pa. Enuun óo enuun eepukut papukal peenape efeefiitee neewantee ti seemak.” ");
INSERT INTO krx_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kayoŋ ka nkicakanoo: “Puume unii éfuuhin?” ");
INSERT INTO krx_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Saŋ naañahanii: “Niŋ an ataakaa kúsool kúsupak añaŋaa káapaacinool niŋ aŋa ataakut ya, aŋa ataake paliyal añaŋaa lompo íhinu fo.” ");
INSERT INTO krx_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Pisayoola kúncoo ya lompo nkákey kati káhinee pátise nkacakanoo: “Ahámpaatiin, puume nuuñaŋe íhinu?” ");
INSERT INTO krx_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Naasokii: “Timpi nisa pihaŋ la pakati Room nkasoke la aluu.” ");
INSERT INTO krx_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Pusoocaali lompo nkacakanoo: “Unii puume nuuñaŋe íhinu?” Naañahanii: “Timpi nicoop mañ miti an ti sempe aluu, timpi ninook an kamma mañ, nileh ti cooy ya eti aluu.” ");
INSERT INTO krx_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pakan paka púlooŋ nkayeno hítuulu man hikee efihitaako, nkayeno ecakanoolo ti kunuuwii man Saŋ ayem Eenucee ya ati Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Saŋ naañahanii poko púlooŋ: “Inci niŋ man inci ínhin aluu pátise. Pale, aŋa eeyem ya ti ékey ahaŋaam sempe, túuniit fala kákopin ñikopu ña ñiti pisamata pa piteyoo. Akina áfaahin aluu pátise niŋ Kunuu ka keenape ka niŋ seemak. ");
INSERT INTO krx_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kaahelu ka kiteyoo unka ti epeesoo kati ákatinool pakak pa niŋ éheeni ya. Naamank pakak pa la ti pileefaan pa piteyoo, pale afaasowan éheeni ya ti seemak seehokiyantoo.” ");
INSERT INTO krx_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Niŋ kikee kilim keemeeŋe Saŋ naaluum pakan paka kápuwunko umuuyen wa uteyii náatuunanii ekooŋan ya éesuume ya. ");
INSERT INTO krx_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pale, Saŋ nawatanwatan Helot Antipas, ati hikaw ha ati Galilee, kamma naalame Helotiya atuwoo aaloo, niŋ waah wa púlooŋ ewwa náahine wa weekance wa. ");
INSERT INTO krx_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tempo Helot naapenane eehe: naakul Saŋ ti ékuluma. ");
INSERT INTO krx_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ta hícump pakan nkáhinee ta pátise, Yéesu lompo náahinee pátise, naaluum. Ta naayeniye ta kaluum, patiila ímpankino, ");
INSERT INTO krx_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Kunuu ka keenape ka nkúwanoonii teyoo, niŋ enii samat nii hícuucuuku. Hilim níhifulii alacana: “Awe yem añiinam, aŋa inci íllafiye ya; ti awe inci intaake pásuumayam.” ");
INSERT INTO krx_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yéesu ti máamun sitiiloo áwii niŋ ŋaasuwan náayaañe páhin pa piteyoo. Incukii nii akina ayem Josef añiinoo, Josef ati Heli, ");
INSERT INTO krx_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli ati Matat, Matat ati Lewi, Lewi ati Meleki, Meleki ati Yannay, Yannay ati Josef, ");
INSERT INTO krx_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josef ati Matacas, Matacas ati Amos, Amos ati Nahum, Nahum ati Esili, Esili ati Nakay, ");
INSERT INTO krx_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakay ati Maat, Maat ati Matacas, Matacas ati Semeyin, Semeyin ati Yosek, Yosek ati Yota, ");
INSERT INTO krx_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yota ati Yowanan, Yowanan ati Lesa, Lesa ati Solopapel, Solopapel ati Salatiyel, Salatiyel ati Neli, ");
INSERT INTO krx_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli ati Meleki, Meleki ati Adi, Adi ati Kosam, Kosam ati Elematam, Elematam ati Eel, ");
INSERT INTO krx_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eel ati Yesus, Yesus ati Eliyesel, Eliyesel ati Yolim, Yolim ati Matat, Matat ati Lewi, ");
INSERT INTO krx_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi ati Simeyon, Simeyon ati Juda, Juda ati Josef, Josef ati Yonam, Yonam ati Eliyakim, ");
INSERT INTO krx_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim ati Meleya, Meleya ati Menna, Menna ati Matata, Matata ati Natan, Natan ati Dawid, ");
INSERT INTO krx_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawid ati Yesaay, Yesaay ati Yopet, Yopet ati Powas, Powas ati Sala, Sala ati Naason, ");
INSERT INTO krx_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naason ati Aminatap, Aminatap ati Atimin, Atimin ati Alini, Alini ati Hesilon, Hesilon ati Fales, Fales ati Juda, ");
INSERT INTO krx_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda ati Jakob, Jakob ati Isaak, Isaak ati Abraham, Abraham ati Telah, Telah ati Nahol, ");
INSERT INTO krx_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahol ati Seluk, Seluk ati Leyu, Leyu ati Pelek, Pelek ati Epel, Epel ati Selah, ");
INSERT INTO krx_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Selah ati Kayinam, Kayinam ati Aapakusat, Aapakusat ati Sem, Sem ati Nowe, Nowe ati Lemek, ");
INSERT INTO krx_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek ati Metuselah, Metuselah ati Enok, Enok ati Yelet, Yelet ati Mahalaleel, Mahalaleel ati Kenan, ");
INSERT INTO krx_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan ati Enos, Enos ati Set, Set ati Ataam, Ataam ati Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yéesu naameeŋ niŋ Kunuu ka keenape ka, náafulii ti musuu ma miti Jordan. Kunuu ka keenape ka nkiyeniyoo kátintiŋan pati káahaaŋ ka tes. ");
INSERT INTO krx_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Naayeno po fo kunoom áwii ésupak, Seetaani ya ti hiŋes híluuŋuyoo. Aliit waah ti oom kunoom púlooŋ, ti pikelan, peep mpucokoo. ");
INSERT INTO krx_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Seetaani ya neesokoo: “Páawoo awe yem Añii ya ati Pútuun pa, sok énankiin eyye eyeso hímpuul.” ");
INSERT INTO krx_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yéesu naañahan yo: “Kiiceekiic ti hilim ha hiti Pútuun pa nii: 'An ataloŋ niŋ hímpuul lamma.'” ");
INSERT INTO krx_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Seetaani ya neecoopoo patiila la haane, néeyisanoo mpacas cáwii ca citi púlunta pa púlooŋ. ");
INSERT INTO krx_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Neesokoo: “Inci fawufani kayine enke púlooŋ niŋ hamake ha hiti cáwii ca, kaatuko inci nkuwufanee, yíniyini kawufan etenko an óo an aŋa ínsuumaam. ");
INSERT INTO krx_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Fiye, náakilipiyaa hátikinam ti hímulu, efikiyeno púlooŋ kitii.” ");
INSERT INTO krx_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yéesu naañahan yo: “Kiiceekiic nii: 'Ateeteyo Pútuun pa pitii aññaŋe ékilipo hátikin etempo, apan pikina lamma aññaŋe kaawaaseen.'” ");
INSERT INTO krx_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Seetaani ya néetintiŋanoo Jerusalem. Neesiiŋanoo la haŋe la pahaan ti ekumpaan ya enfakat ya eti Pútuun pa. Nene esokoo: “Páawoo awe yem Añii ya ati Pútuun pa, fúl le cípo t’etaam. ");
INSERT INTO krx_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kamma inkiicee nii: 'Efipusok pumaleekoo etempo pimankooli; ");
INSERT INTO krx_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","pumaleekoo pa éfipiseepini niŋ sipees etempo, eeha efihiwun ha kooti etikulooŋoolo ti énankiin.'” ");
INSERT INTO krx_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yéesu naañahan yo: “Kiiceekiic nii: 'Aañaŋut puwinko Ateeteyo Pútuun pa pitii.'” ");
INSERT INTO krx_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ta Seetaani ya neepaye ta hiŋes híluuŋuyoo ha púlooŋ, neekatanoo fo ti cikee caanak. ");
INSERT INTO krx_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Toko fúle, Yéesu naañoho ti mah ma miti Galilee, niŋ pameeŋ sempe sa siti Pútuun pa séefulii sa ti Kunuu ka keenape ka. Pakan paka nkáyaañ káakup kiteyoo ti pisaatee pa púlooŋ péekinkoolii pa. ");
INSERT INTO krx_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Naayeno kakalaŋan ti púluumuma pa piteyii, pakan paka púlooŋ nkayeniyoo hímulu. ");
INSERT INTO krx_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Púful toko, Yéesu naakaay Naasalet pa náakulee pa. Ti hinoom ha hiti kayeno ka kiti Pusuwif pa naanako ti éluumuma ya eteyii samat nii fa naasale fa íhinu. Naalito apisiiŋo kati akalaŋ. ");
INSERT INTO krx_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nkañaakanoo kaahit ka kiti ayaamakoola ya Esaaya. Apúpoonin ko, naacuk la inkiicee la: ");
INSERT INTO krx_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Kunuu ka kiti Ateeteyo unka ti inci kamma nkimamalaam kati túunan ekooŋan éesuume ti keeleke ka. Kúpoñiyaampoñ kati kaman keekulee ka nii éfikafulii, niŋ kéefuume ka nii éfikañohoonii ti hicuku, kati fúlan keekallanee ka ti kúnuul, ");
INSERT INTO krx_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","inkaman etiil eyya Ateeteyo áfaayisan pásuum pa piteyoo.” ");
INSERT INTO krx_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Naapoon kaahit ka naañaakan ko áhina ya naacaayeno. Keeyeniye ka ti éluumuma ya púlooŋ cew ñíkinii iññiya teyoo. ");
INSERT INTO krx_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Náayaañ hisokuyii: “Fíyooy, heekiicee eehe hitaakiyaa ti pásiyal aluu.” ");
INSERT INTO krx_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Pakan paka púlooŋ nkákup héesuume teyoo, ínnimii ti kilim ka kéesuume ka kéefulii ka ti putumoo. Nkacakan: “Fo aŋe tom ayem Josef añiinoo?” ");
INSERT INTO krx_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yéesu naasokii: “Híiniyaamhiini nii efinifinam ti kusoku enke: 'Akúuñana kúuñanoolo! Hín le ti saatee ya etii, samat nii eeha núusiye ha ánhine Kafaanawum.'” ");
INSERT INTO krx_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Naapenan hisokuyii: “Pánipani, ayaamakoola asayanantee ti saatee ya eteyoo. ");
INSERT INTO krx_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Píhiiniyan aluu nii ti caanak ca citi ayaamakoola ya Elí, etiil ya enuput fo sitiil síhaaciil niŋ kiim isak niŋ hoonool, épankul neeyeno ti mah ma púlooŋ. Tempo, intaako piyaaŋat peemeeŋe Israyel payenka pákayiinii keekete. ");
INSERT INTO krx_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pútuun pa pupoñut Elí ti akee ti payenkuu, pale ti ekee eyaaŋat aŋa áyiinoo eekete ati saatee ya eti Salepat pukol saatee ya eti Siton. ");
INSERT INTO krx_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ti caanak ca citi ayaamakoola ya Elise, intaako lompo kayoŋ púkuuña pakati kanuk ti mah ma miti Israyel, pale háati oonool teyii akuulanutee fo Neeman lamma ati Siriya.” ");
INSERT INTO krx_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Pakan paka púlooŋ keeyeniye ka ti éluumuma ya, kiiñii nkili ta nkásiye ta enke fiye. ");
INSERT INTO krx_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nkayito, nkáfulanoo ti saatee ya. Nkacoopoo patiila kanaac cítintiŋ ca la saatee ya neelutee la, kati káhalapiyoo t’etaam. ");
INSERT INTO krx_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pale Yéesu náanapii ti pututa kayoŋ ka naakaay pítinoo. ");
INSERT INTO krx_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yéesu náawanoonii Kafaanawum, saatee eti Galilee, naayeno kakalaŋan pakan paka ti hinoom ha hiti kayeno ka kiti Pusuwif pa. ");
INSERT INTO krx_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Innímii ti pakalaŋanaloo, kamma hilim ha hiteyoo nihitaake sempe. ");
INSERT INTO krx_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Intaako la ti éluumuma ya áyiin aŋa hísaalumantseetaani nihinakiye. Náaceekii niŋ kaawiiluyoo: ");
INSERT INTO krx_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Katan unii! Weyme uyem ti pututa unaa, Yéesu ati Naasalet? Fo áakeyyookey aakati púcalool unii? Inci méyimeyi awe yem ayme: Eesampanee ya ati Pútuun pa!” ");
INSERT INTO krx_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yéesu naafet teyyo: “Fatan! Fúlii teyoo!” Hísaalumant ha nihitah áyiin a t’etaam hátikin pakan paka púlooŋ, níhiful teyoo peekuumutoo. ");
INSERT INTO krx_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Pakan paka púlooŋ nkaŋaŋo nkayeno picakanool: “Hilim eehe, hilim puume? Ti kayine niŋ sempe nasok kísaalumant ka kúfulii, nkúful!” ");
INSERT INTO krx_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kiti Yéesu nkísiyo ti pisaatee pa péekinkoolii pa púlooŋ. ");
INSERT INTO krx_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yéesu ápufulii la ti éluumuma ya naanako la ti ekumpaan ya eti Simon. Simon aasonoo aal naayeno niŋ káakuuñu kiti pasowe-enii kenfakat. Nkaluum Yéesu apiyankananoo. ");
INSERT INTO krx_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Naañeeho toko teyoo naafet ti pasowe-enii ya mpúful. Tokotoko náalitoonii, naawasii kapili. ");
INSERT INTO krx_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ti panowal caanak ca, pakati káakuuñu óo káakuuñu nkácoopiyee ti Yéesu, naalemp sipeesoo ti an óo an teyii, náakuuñanii. ");
INSERT INTO krx_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kísaalumant lompo nkúfulii ti pakan keemeeŋe, nkiyeno hiceeku: “Awe yem Añii ya ati Pútuun pa!” Pale naafet tenko naakit ko káakup kamma nkimeya nii akina ayem Eenucee ya ati Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Cipilap, Yéesu naañako apiyeno lamayoo. Kayoŋ ka nkiyeniyoo hiŋes, ta nkútookiyoo ta la naayeniye la, nkílafiyoo hicoku timpi akatanii. ");
INSERT INTO krx_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pale naasokii: “Inci ñaŋaa káatuunan ekooŋan ya éesuume ya eti cáwii ca citi Pútuun pa ti pikee pisaatee pa lompo, heewune ha inci ímpoñiyee.” ");
INSERT INTO krx_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Naayeno káatuunan eteeho ti púluumuma pa piti Judaay. ");
INSERT INTO krx_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Hikee hinoom Yéesu naasiiŋo la ti kantant ka kiti han ha hiti Kennesalet, kayoŋ ka nkikincooloo kipiyeno káasiitan hilim ha hiti Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Akee acalafayya, caacawoo Simon Piyeer, naayeno pukol han ha. Pákawiyoo picalafayya Saak niŋ Saŋ, Sepete epuukoo, nkayeno lompo toko. Picalafayya pa payenkuu, ñiteen ña ñiteyii ñúsupak ña iññisiiŋo ti kantant ka, kápuwanoonii teñño nkayeno puñowu picala pa piteyii. Ti káasiiŋuma enkuu, Yéesu naacuk ñiteen ña, ");
INSERT INTO krx_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","náayuuko ti piteen pa piti Simon, naasokoo: “Fúlan po le ti kantant ke, teeŋan po caahinkiŋ,” naayeno tempo apiyeno kakalaŋan kayoŋ ka. ");
INSERT INTO krx_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ta naapaye ta káakup, naasok Simon: “Wanan piteen pa pati kásul ka innitah picala pa piti aluu nípicokii soon.” ");
INSERT INTO krx_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon naañahanoo: “Aápunu, unii uyokaa hánant ha púlooŋ ti calafayi ucokut waah. Pale niŋ aasokaa fo, inci fatah picala pa.” ");
INSERT INTO krx_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nkatah po nkácokii hícump soon fo picala pa piteyii mpíyaañe pihaaco. ");
INSERT INTO krx_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nkakaaween pákawiyii keeyeniye ka ti pikee piteen kápikey kapiyankananii, nkákey nkameeŋan ñiteen ña ñúsupak ña púlooŋ fo íññilafiye híseemu. ");
INSERT INTO krx_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Piyeer, ta naacuke ta eehuu, náakilipo ti Yéesu wootoo naasokoo: “Ahámpaatiin, láaŋam, inci áyiin amuuyena!” ");
INSERT INTO krx_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kaatuko Simon niŋ pákawiyoo kaŋaŋaaŋaŋo ti hícump soon ensa nkacoke sa. ");
INSERT INTO krx_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saak niŋ Saŋ lompo nkaŋaŋo. Yéesu naasok Simon: “Timpi fe, písik fíyooy pakan ankaakaay hicoku.” ");
INSERT INTO krx_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nkáciŋii, nkafaakal ñiteen ña ñiteyii, nkatah toko waah óo waah, nkanapan Yéesu. ");
INSERT INTO krx_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Hikee hinoom Yéesu naayeno ti ekee saatee, intaak áyiin ati kanuk. Niŋ pacukaloo Yéesu, naanow hátikinoo, puhooŋuyoo t’etaam naaluumoo: “Ahámpaatiin, áayiniyaamyini kaakuulan, niŋ áalafiyaa.” ");
INSERT INTO krx_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yéesu náañaakanii epeesoo náalikoo, naasokoo: “Inci láfilafi. Kuul!” Tokotoko kanuk ka nkikatanoo. ");
INSERT INTO krx_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yéesu naakitoo hisoku eteeho an: “Kaay cáayisanoolo awaaseena ya ati Pútuun pa, niŋ fúlaa toko uwwaaseen kaawaaseen ka kiti kaakuulan ka enka Móyiis naasoke ka, áapiyisan pakan paka nii aakuulanee-kuulan.” ");
INSERT INTO krx_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Háati fo, kiti Yéesu nkihaŋ toko nkísiye, uyoŋ pakan núuconcoolii ti káasiitanoo niŋ ékuuñano úkuuñu wa uteyii. ");
INSERT INTO krx_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pale Yéesu nañakoñako ti káahaaŋ ka tes, naayeno po kaluum. ");
INSERT INTO krx_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Hikee hinoom Yéesu ti kakalaŋan, Pufalisaay pa niŋ pikalaŋana hilim ha heesiiŋanee ha hiti Móyiis nkáfulii pan óo pan ti misaatee ma miti Galilee, miti Judaay niŋ Jerusalem, nkayeno toko. Sempe sa siti Ateeteyo insiyeno ti Yéesu kati ákuuñan kéekuuñe ka. ");
INSERT INTO krx_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tempo, pakakee pákayiin kéekantoonii áyiin éehute ti kahun nkácolii. Nkayoopoo kanakan ti ekumpaan ya kati kahintanoo hátikin Yéesu. ");
INSERT INTO krx_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pale kataakut pítin piti kanakanoo kamma kayoŋ ka. Nkasilo neyoo ti kankalaŋ ka nkátiŋin káatiŋu nkáyuuŋaniyoo toko niŋ kahun ka kiteyoo ti pututa pakan paka hátikin Yéesu. ");
INSERT INTO krx_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ta Yéesu naacuke ta káyinan ka kiteyii, naasok éehute ya: “Awí, umuuyen wa utii uponketee.” ");
INSERT INTO krx_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pikalaŋana hilim ha heesiiŋanee ha niŋ Pufalisaay pa nkáyaañ káamiilool ti faŋii: “Aŋe an puume naacokooliye fo kati ateñal Pútuun pa? Ayme ayina kaaponket umuuyen wa fo niŋ neetaat Pútuun pa lamma?” ");
INSERT INTO krx_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yéesu náameyi eeha nkayeniye ha káamiilool naacakanii: “Weyme uwune innitaak pámiiloolal empuu ti saan aluu? ");
INSERT INTO krx_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Weyme uhaŋe pásuum hisoku: 'Umuuyen wa utii uponketee', niŋ ekina tom hisoku: 'Lito inkaay'? ");
INSERT INTO krx_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Fiye fáyisan aluu nii inci, Añii An, taakaataak kayine t’etaam kiti kaaponket umuuyen wa.” Fiye naasok éehute ya: “Inci pusoki, lito, coop kahun ka kitii, iyyet t’enuuf.” ");
INSERT INTO krx_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tokotoko naasiiŋo hátikinii, náaseepin kahun enka nahinto ka tenko, naayet t’enuuf ti hímulu Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pakan paka púlooŋ ínnimii nkámul Pútuun pa. Ewatate neemeeŋii nkayeno hisoku: “Ucukaacuk fíyooy heetaapala hicukee.” ");
INSERT INTO krx_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Púful toko, Yéesu naakaay naacuk asayoola kúncoo ya aŋa nkasok ya Lewi, naayeniye ti ésayuma kúncoo ya. Yéesu naasokoo: “Nápaniyam.” ");
INSERT INTO krx_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi naalito, naakatan waah óo waah, naanapanoo. ");
INSERT INTO krx_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lewi, ti kánapiyan Yéesu, naayonkaloo hili káciim kenfakat ti ekumpaan ya eteyoo, intaako toko kayoŋ kenfakat kiti pisayoola kúncoo ya niŋ pakakee pakan keeyeniye hili neyii. ");
INSERT INTO krx_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pale Pufalisaay pa niŋ pikalaŋana hilim ha heesiiŋanee ha nkayeno káakumutool ti pinapana pa pakati Yéesu, nkasokii: “Weyme innili, innilaan nantoonool niŋ pisayoola kúncoo ya niŋ pumuuyena pa?” ");
INSERT INTO krx_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yéesu naañahanii: “Pakan paka tom keeyem ka kásuumaayii kasoolahe ákuuñana, pale kéekuuñe ka. ");
INSERT INTO krx_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Inci kéyyoot kaayonkal keecoonoole ka, pale pumuuyena pa kati káwunko umuuyen wa uteyii.” ");
INSERT INTO krx_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Pakakee pakan nkasok Yéesu: “Pinapana pa pakati Saŋ nkaloomloom suŋ niŋ kaluum, fo lompo incuke ti pinapana pa pakati Pufalisaay pa, pale pakatii paka nkatowo ti hili niŋ pálaani.” ");
INSERT INTO krx_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yéesu naañahanii: “Fo éfiniyini hiwasu pakan suŋ kéeyonkaliyee pahaaño piti esa, loho asaya ya oopa neyii? ");
INSERT INTO krx_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pale caanak unca ti ékey, asaya ya áfaafulanee teyii, ti oom kunoom efikasuŋ.” ");
INSERT INTO krx_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Naasokii lompo hícantiitu eehe: “An ahaacantoo cifaal ti hísool héeyeeni kati apap co ti hísool heemaamane. Niŋ áhinaa fo, afaahaac hísool ha héeyeeni ha, niŋ fúlaa toko cifaal ca céefulii ca ti hísool ha héeyeeni ha eticinapool niŋ hísool ha heemaamane ha. ");
INSERT INTO krx_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","An ánuŋantoo pucoma wiiñ ti upaŋ weemaamane. Niŋ áhinaa fo, pucoma wiiñ ya éfipifapan upaŋ wa, wiiñ ya neeniiso, upaŋ wa núupucaloolo. ");
INSERT INTO krx_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pale pucoma wiiñ ti upaŋ wéeyeeni nénuŋee. ");
INSERT INTO krx_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","An atasiikan wiiñ eeyanke náalafi pucoma, kamma wiiñ eeyanke neehaŋoo pásuum.” ");
INSERT INTO krx_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Hikee hinoom hiti kayeno kiti Pusuwif pa, Yéesu naayeno kaafiitanool koos, pinapana pa pakateyoo nkayeno kaasuutal ulat nkahenkecal wo niŋ sipeesii nkayeno wo hili. ");
INSERT INTO krx_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pakakee ti Pufalisaay pa nkasokii: “Weyme inniyem ti íhinu héehinantee ha ti hinoom ha hiti kayeno ka?” ");
INSERT INTO krx_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yéesu naañahanii: “Fo nikalaŋut eeha Dawid, amansa ya, náahine ha akina niŋ pákawiyoo ta peep pa mpucokii ta? ");
INSERT INTO krx_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Anakaanako ti ékuut ya enfakat ya eti Pútuun pa, náacoopii kúmpuul ka keesampanee ka. Apili ho, naawun pákawiyoo, ántuŋ kúmpuul enkuu puwaaseena pa pakati Pútuun pa lamayii kóŋ nkañaŋe ko hili.” ");
INSERT INTO krx_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yéesu nene asokii: “Inci, Añii An, yem Ateeteyo ati hinoom ha hiti kayeno ka.” ");
INSERT INTO krx_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Hikee hinoom nene hiti kayeno, Yéesu naanako ti éluumuma ya eti Pusuwif pa apiyeno kakalaŋan. Intaako toko áyiin aŋa epeesoo yáali éehute. ");
INSERT INTO krx_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Páawoo Pufalisaay pa niŋ pikalaŋana hilim ha heesiiŋanee ha kayenaayeno hiŋes waah ewwa efikanook newwo Yéesu, nkayeno kaasincan teyoo man áfaakuuñan ti hinoom ha hiti kayeno ka. ");
INSERT INTO krx_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pale Yéesu náameyi pámiiloolalii naasok áyiin a ati epees ya éehute ya: “Lito siiŋo hátikin pakan paka.” Ayíin a naalito naasiiŋo. ");
INSERT INTO krx_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yéesu naasokii: “Inci picakan aluu, eeheyme hicoonee ti hinoom ha hiti kayeno ka: íhinu heenape fo íhinu heenaput, kafakan eloŋ fo káapucalool eteyyo?” ");
INSERT INTO krx_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Naasincanii púlooŋ cew, nene asok áyiin a: “Pántin epeesi.” Ayíin a náahin fo, epeesoo neeñoho toko pitempo tak. ");
INSERT INTO krx_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pale Pufalisaay pa niŋ pikalaŋana hilim ha heesiiŋanee ha, kiiñii nkili meemak, nkáyaañ piteŋenool puume éfikahin Yéesu. ");
INSERT INTO krx_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ti oom kunoom Yéesu naakaay pati tíntiŋ ya kaluum, naapa hánant ha púlooŋ ti kaluum Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ta incilape ta, naayonkal pinapana pa pakateyoo naamamal teyii ŋaasuwan niŋ pákasupak, payenka efikayeno pupoñapoñ pa pakateyoo. Poko kayem: ");
INSERT INTO krx_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon aŋa naawufane ya caacaw ca Piyeer niŋ atuwoo Andre, Saak, Saŋ, Filip, Paatolomaay, ");
INSERT INTO krx_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Máciya, Tomas, Saak ati Alifaay, Simon aŋa nkasok ya Selot, ");
INSERT INTO krx_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yutas ati Saak, niŋ Judas Iskaliyot, aŋa akaakaay ya hífulu ti Yéesu. ");
INSERT INTO krx_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Púful toko, Yéesu náawanoonii ti tíntiŋ ya niŋ keeyeniye ka neyoo, naasiiŋo la etaam ya neetempanooliye la. Kayoŋ keemeeŋe kiti pinapana pa pakateyoo nkiyeno toko niŋ hícump pakan kéefulii Judaay, Jerusalem niŋ kéefulii ti pisaatee pa piti kantant ka peeyem pa Til niŋ Siton. ");
INSERT INTO krx_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Kákeyyookey káasiitanoo niŋ kati kákuuñanee úkuuñu wa uteyii. Payenka kísaalumant nkiyokane nkákuuñanee. ");
INSERT INTO krx_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","An óo an ti kayoŋ ka naaŋes hílikuyoo kamma sempe ínsifulii teyoo ínsikuuñanii púlooŋ. ");
INSERT INTO krx_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yéesu naasincan pinapana pa pakateyoo naasok: “Niyihaayih, aluu keeleke ka, kaatuko cáwii ca citi Pútuun pa citaaluu. ");
INSERT INTO krx_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Niyihaayih, aluu keeyem ka fiye ti peep pa, kaatuko efinisiitanee. Niyihaayih, aluu keeyem ka fiye ti pukooŋ, kaatuko efinilenken. ");
INSERT INTO krx_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Niyihaayih, niŋ pakan kanataa aluu, nkaŋay aluu, nkateñal aluu, nkákup ti aluu heenaput kamma inci, Añii An. ");
INSERT INTO krx_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Niŋaañaa ti oom hinoom, ninuunuutool ti pásuuma, kamma kawun kenfakat nkiyem ti hítuulu aluu alacana. Kaatuko fiyuu símaamayii nkáhine piyaamakoola pa. ");
INSERT INTO krx_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pale kúnuul efikiyeno ti aluu! - aluu keetaake ka, kaatuko nisayaasa kaapuuñanool ka kiti aluu. ");
INSERT INTO krx_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kúnuul efikiyeno ti aluu! - aluu keesiite ka fiye, kaatuko efiniyeno ti peep. Kúnuul efikiyeno ti aluu! - aluu keeyem ka ti caalenken fiye, kaatuko efiniyeno ti weeŋoot innikooŋ. ");
INSERT INTO krx_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kúnuul efikiyeno ti aluu! - niŋ pakan paka púlooŋ kákupaa ti aluu heenape. Kaatuko fiyuu símaamayii nkáhine keeneetaat ka piyaamakoola pánipani.” ");
INSERT INTO krx_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yéesu nene asok: “Pale inci pusok aluu, aluu keeyemam ka ti káasiitan: Nílafi pikamool aluu, níhin heenape ti payenka keenate ka aluu. ");
INSERT INTO krx_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nisap lúwa payenka nkañan ka aluu, niluum Pútuun pa heenape payenka nkakancool ka niŋ aluu. ");
INSERT INTO krx_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Niŋ an ahankuu kapal ti kaawiilu, ufanoo kikee ka lompo apinene ahanki tenko kapal. Niŋ an alamaa hísool ha hitii henfakat ha, timpi kitoo hicoopu eeha lupo páhantuwa. ");
INSERT INTO krx_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","An óo an eeluumuu, uwwunoo, niŋ an acoopaa waahi timpi cakanoo wo. ");
INSERT INTO krx_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Níhin pakan paka samat nii fa ínnilafiye fa kati nkáhin aluu. ");
INSERT INTO krx_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Niŋ nílafiyaa kéelafiye ka aluu, enkeyme kaapuuñanool innikaakaay hitaaku? Háati pumuuyena pa nkálafilafi kéelafiyii ka. ");
INSERT INTO krx_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Niŋ níhinaa heenape ti payenka nkáhin ka aluu heenape, enkeyme kaapuuñanool innikaakaay hitaaku? Háati pumuuyena pa nkáhinhin fo. ");
INSERT INTO krx_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Innimaakaa payenka incuke ka aluu nii efikañahan aluu, eyyeyme cooy innikaakaay hitaaku? Háati pumuuyena pa nkamaakmaak pumuuyena pa kati kañahanii memma nkamaakii ma. ");
INSERT INTO krx_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pale nílafi pikamool aluu, níhin heenape teyii, innimaakii, timpi nímiilool hitaaku kañahan teyii. Inníhinaa fiyuu, Pútuun pa efipuwun aluu kawun kenfakat niŋ fúlaa toko efiniyeno epuuk Pútuun pa piti patiila, kamma mpinape ti keesokantoo ka apalaka niŋ ti keenaput ka. ");
INSERT INTO krx_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nitaak paket hikaw samat nii fa Paapaa ati aluu eeyem ya alacana naataake fa paket hikaw.” ");
INSERT INTO krx_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yéesu nene asok: “Timpi níhin kíiti pakan, Pútuun pa lompo étipihin aluu kíiti. Timpi niwufan pakan umuuyen, Pútuun pa lompo etipuwufan aluu umuuyen. Niponketii, Pútuun pa lompo efipuponket aluu. ");
INSERT INTO krx_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Niwun, Pútuun pa lompo efipuwun aluu, mpúnuŋ ti uhuuy wa uti aluu eniiku eemeeŋanee looc, neepimpee, neewenee, neemeeŋanee fo eniisaloolo. Kaatuko efipiniik aluu niŋ eniiku eyya inniniike ya pakan paka.” ");
INSERT INTO krx_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yéesu naasokii lompo hícantiitu eehe: “Fo káafuumiin náyiniyini kátintiŋan áwiyoo káafuumiin? Fo etikanow poko t’ésupakii ti kaayeen? ");
INSERT INTO krx_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Akalaŋa ahaŋut akalaŋana ya ateyoo, pale an óo an eekalaŋe meemak afaacuk nii akalaŋana ya ateyoo. ");
INSERT INTO krx_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Weyme uwune aanincuk cíheeni ca ceeyem ca ti níkin atii ya, awe péepannumut hifiin ha heeyem ha ti níkini? ");
INSERT INTO krx_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Puume ayyina hisoku atii ya: 'Atoomuu, túulam inci púfulani cíheeni ca ceeyem ca ti níkini,' awe aŋa eeyinaat ya hicuku hifiin ha heeyem ha ti níkini? Awe nícuf, yáañ fúlan hifiin ha ti níkini, tempo áafayini hicuku picaaŋ cataŋ aakati yíni káfulan cíheeni ca ceeyem ca ti níkin atii ya.” ");
INSERT INTO krx_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yéesu nene asok: “Enuun eenape epukantoo papukal peenaput, fo lompo incuke enuun eenaput epukantoo papukal peenape. ");
INSERT INTO krx_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Enuun óo enuun ti papukal eteyyo nekiiwee. An átayini hicutu sootoo ti usooy uti pícankun, papukal wiiñ lompo pucutantee ti nikota. ");
INSERT INTO krx_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","An eenape, náfulaniifulan ti yaanoo waah weenape. Pale an eenaput, náfulaniifulan ti yaanoo waah weenaput. Kaatuko heemeeŋ ha ti yaan an, hikina nákup.” ");
INSERT INTO krx_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yéesu nene asok: “Weyme uwune inniyonkalam 'Ateeteyo, Ateeteyo,' apan níhinantoo eeha inci insok ha? ");
INSERT INTO krx_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","An óo an éekeyii ti inci náasi pakalaŋanalam apan náahin po, inci fáyisan aluu niŋ weyme naanakoole. ");
INSERT INTO krx_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Anakoolaa-nakool nii an aŋa eeyem ti kulut ekumpaan: awakaawak fo súni naasiiŋan ekumpaan ya eteyoo ti énankiin. Esáacin néefulii niŋ sempe, man ma immisap teyyo pale miyinaat yo káyiyiŋan kamma neelutee pinap. ");
INSERT INTO krx_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pale an a aŋa ásiye ya pakalaŋanalam apan áhinut po, anakoolaa-nakool nii an aŋa eeyem ti kulut ekumpaan ti esiya peewakut t’etaam. Man ma immisap teyyo, neehaaŋ ti enow neehancaloolo púlooŋ cew.” ");
INSERT INTO krx_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ta Yéesu naapaye ta káakup púlooŋ hátikin pakan paka, naanako saatee ya eti Kafaanawum. ");
INSERT INTO krx_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Intaako toko akee ti ñíhampaatiin pusoocaali ati Room, eetaake amiikan ati hikawoo éekuuñe meemak fo alohan putum eket. ");
INSERT INTO krx_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Náasi kiti Yéesu, naapoñ pakakee ñíhampaatiin Pusuwif kapica kaluumoo ápikey ákuuñan amiikan a ateyoo. ");
INSERT INTO krx_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ta nkacole ta ti Yéesu nkaŋiiniyoo meemak: “Asoocaali ya aŋe añaŋee kayankanan meemak, ");
INSERT INTO krx_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kaatuko álafilafi pakan unaa niŋ fúlaa toko akina alute éluumuma ya eti le.” ");
INSERT INTO krx_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Fiye, Yéesu naanapool neyii. Ta naalohane ta ekumpaan ya, áhampaatiin a asoocaali ya ati Room náapoñii pákawiyoo kapusok Yéesu: “Ahámpaatiin, timpi yokanoolo écolii pe t’inci kamma inci íntuuniit aapinako ti ekumpaan ya etoom. ");
INSERT INTO krx_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ekina lompo ewune inci míiloolut nii ñaŋaa ékey puu ti awe, pale sok hilim hoonool lamma, amiikan a atoom áfaakuuñanee. ");
INSERT INTO krx_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kaatuko inci himuumam ti sipees áhampaatiin iyyem, pusoocaali lompo nkáyemi ti sipeesam. Niŋ inci sokaa aŋe 'kaay', naakaay; insok aŋe 'kéy', náakey. Insok amiikan a atoom 'hín fiye', náahin fo.” ");
INSERT INTO krx_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ta Yéesu náasiye ta eehe ínnimoo, teyoo náayesoonii ti kayoŋ ka keeyeniyoo ka kanapan, naasokii: “Inci pusok aluu, inci taapala cuk káyinan ka kenfakat enke, háati ti pakati Israyel.” ");
INSERT INTO krx_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ta Yéesu naapaye ta hisoku eehe, payenka áhampaatiin a asoocaali ya naapoñe ka nkañoho. Kapucol nkatook amiikan a kásuumaayoo. ");
INSERT INTO krx_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Púful toko Yéesu naakaay ti saatee ya eyya nkasok ya Nayin, pinapana pa pakateyoo niŋ kayoŋ kenfakat nkanapool neyoo. ");
INSERT INTO krx_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Fiye, ta naalohane ta putum pa piti saatee ya, nkayeno hicoopu ehunuŋ ti íhokuma. Eekete ya, akampaani, akina lamayoo íññaa ateyoo naataake, áyiinoo eekete. Kayoŋ kenfakat kiti saatee ya nkiyeno neyoo. ");
INSERT INTO krx_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Iññáa ateyoo naayeno pukooŋ. Ateeteyo apucukoo, inketoo teyoo ti hikaw, naasokoo: “Timpi kooŋ.” ");
INSERT INTO krx_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Naaloh pisaapu pa, náalik po, keetiyye po ka nkasiiŋo. Yéesu naasokoo: “Akampaani, inci soki: 'Lito!'” ");
INSERT INTO krx_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Aŋa eekete ya náalitoonii, naayeno, náayaañ káakup, Yéesu naacoopoo naañahanoo íññaa ateyoo. ");
INSERT INTO krx_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kayoŋ ka púlooŋ nkimeeŋ niŋ ewatate nkúmul Pútuun pa nkusok: “Ayaamakoola enfakat áfuliyoo ti unaa. Pútuun pa pítahiyoo kunuu ti pakan etempo.” ");
INSERT INTO krx_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hiti Yéesu eehe, níhisiyo ti mah ma miti Judaay púlooŋ niŋ ti pisaatee pa púlooŋ péekinkoole yo pa. ");
INSERT INTO krx_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ti písiyo pa piti Yéesu empuu, Saŋ, pinapana pa pakateyoo nkakamanoo eehe púlooŋ. Naayonkal teyii pákasupak, ");
INSERT INTO krx_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","naapoñii ti Ateeteyo kapica kacakanoo: “Fo awe yem Aŋa eeyem ya ti ékey? Niŋ ekina tom, fo uñaŋaa hítuulu akee?” ");
INSERT INTO krx_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kapucol ti Yéesu nkasokoo: “Saŋ-Patis ápoñii unii ti awe upucakani: 'Fo awe yem aŋa eeyem ya ti ékey? Niŋ ekina tom, fo uñaŋaa hítuulu akee?'” ");
INSERT INTO krx_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ti oom caanak, Yéesu náakuuñan hícump pakan keeyoke niŋ úkuuñu weemeeŋe, niŋ payenka kísaalumant nkúwuuliye, náahin úfuumiin weemeeŋe upucuk. ");
INSERT INTO krx_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Fiye, Yéesu naañahan payenka Saŋ náapoñii ka, naasokii: “Niñoho nica nikaman Saŋ eeha innicuke ha niŋ eeha ínnisiye ha: kéefuume ka unka ti hicuku, payenka nkanow ka niŋ efank unka ti pikaayu, pakati kanuk ka nkakuulanee, keecotiye ka unka ti hísiyu, keekete ka nkálitaniyee, ekooŋan ya éesuume ya néetuunanee keeleke ka. ");
INSERT INTO krx_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ayihaayih, aŋa eepookut a hitaaku káyinan kamma inci.” ");
INSERT INTO krx_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Payenka Saŋ náapoñii ka, ta nkakaaye ta, Yéesu náayaañ káakup ti kayoŋ ka kiti Saŋ, naasokii: “Weyme innikaaye pati káahaaŋ ka tes kaasincan? Fo haasuwa eeha eyam ya nesapalool? ");
INSERT INTO krx_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Niŋ fotom, weyme innikaaye po hicuku? Ayíin eewasiye wañ weewalla? Haani! Payenka nkawaso ka wañ wa wéeciita wa hinoom, nkayeno ti eloŋ enfakat, unka ti pukumpaan pa piti pumansa pa. ");
INSERT INTO krx_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ooto weyme innikaaye po hicuku? Ayaamakoola? Ee ayaamakoola! Inci pusok aluu nii ahaŋaahaŋ ayaamakoola. ");
INSERT INTO krx_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Saŋ akina ayem aŋa hilim ha hiti Pútuun pa nihikiice ya: 'Inci fápoñii ati ekooŋan ya atoom apunowi hátikin kati awañali pítin pa.' ");
INSERT INTO krx_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Inci pusok aluu, taakut an aŋa aal naapuke eehaŋe Saŋ; pale aŋa éetinee ya ti cáwii ca citi Pútuun pa, ahaŋoohaŋ.” ");
INSERT INTO krx_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Pakan paka púlooŋ kéesiye ka enkuu, háati pisayoola kúncoo ya, kacoonaacoon nii Pútuun pa peecoonoole. Ta Saŋ naayeniye ta káatuunan ekooŋan ya eti Pútuun pa, nkacoon ápihinii pátise. ");
INSERT INTO krx_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pale Pufalisaay pa niŋ pikalaŋana hilim ha heesiiŋanee ha hiti Móyiis nkapook eeha Pútuun pa mpílafiye ha teyii; kacoonut Saŋ ápihinii pátise. ");
INSERT INTO krx_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yéesu naasokii: “Niŋ weyme inci iyyina kaakufumool ekaay ya eti fíyooy? Niŋ weyme neenakoole? ");
INSERT INTO krx_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Enakoolaa-nakool nii epuuk keeyeniye ti híliŋ nkayeno kaaceeceekool: 'Uhapaahap aluu, nikiiyut, nuucook aluu kícimu kiti keeŋoot, nikooŋut.' ");
INSERT INTO krx_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Kaatuko, Saŋ-Patis ákeyyookey, aliyantoo hímpuul, alaanantoo elaan innisok: 'Hísaalumant hiyem neyoo.' ");
INSERT INTO krx_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Inci, Añii An, ínkey pilli illaan innisok: 'Nisincan! Aŋuu an eekase, núkumana, áwii ati pisayoola kúncoo niŋ pumuuyena.' ");
INSERT INTO krx_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pale ecohato ya eti Pútuun pa, keecoone yo ka púlooŋ káyisanaayisan nii tooñaa.” ");
INSERT INTO krx_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Afalisaay akee, aŋa nkasok Simon, naayonkal Yéesu hili káciim pateyoo. Yéesu naakaay, naanako la ti ekumpaan ya eti Afalisaay a naayeno hili. ");
INSERT INTO krx_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Intaako toko ti saatee ya aal amuuyena. Náasi nii Yéesu oopa ti hili pati ekumpaan ya eti Afalisaay a. Ta náasiye ta eehuu, naacoopool cílumpa ceewalla kaameeŋ munucu méesuume haaw. ");
INSERT INTO krx_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Naasiiŋo puson woot Yéesu, naayeno pukooŋ, náayaañ káamaañiyan wootoo niŋ mukunoo, naatoot wo niŋ wanoo, naasump wootoo, naanuc wo niŋ munucu méesuume haaw. ");
INSERT INTO krx_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Afalisaay a aŋa ayonkale ya Yéesu hili káciim, apucuk eehuu, naasokoolo: “Niŋ pánipani áyiin aŋe ayaamakoola, añaŋaa kameye aal puume ayemoo ti híliku, aal amuuyena!” ");
INSERT INTO krx_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yéesu naacoop hilim ha naasokoo: “Simon, taakaataak eeha inci iññaŋuu hisoku.” Simon naañahanoo: “Sokam, Ahámpaatiin.” ");
INSERT INTO krx_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yéesu naasokoo: “Taakaataak pákayiin pákasupak keetaake ñikopu ti akee áyiin eelontiyii mañ. Akee ya naataakoo nikopu sikoofali sikeme isak (500), akee ya lompo nikopu sikoofali áwii ésupak niŋ ŋaasuwan (50). ");
INSERT INTO krx_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pale háati oonool teyii ayinaatoo mo kañahan. Fiye, naaponket poko t’ésupakii ñikopu ña ñiteyii. Ti awe, ayme ti payenke t’ésupakii afaahaŋ pálafi aŋa eelontiyii ya mañ ma?” ");
INSERT INTO krx_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon naañahanoo: “Ti pacukalam, akina ayem aŋa nkaponkete ya nikopu na nenfakat na.” Yéesu naasokoo: “Aasokaa páni.” ");
INSERT INTO krx_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Apipa, náayesoonii pati aal a, naasok Simon: “Aacukaacuk aal a aŋe, emma inci ínnakoonii ma le ti awe, aawunutam man puñow wootam, pale akina náamaañiyan wootam niŋ mukunoo, naatoot wo niŋ wanoo. ");
INSERT INTO krx_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ta inci ínnakoonii ta le ti awe, aawananutam niŋ hisumpu, pale akina áyekuniit hisumpu wootam. ");
INSERT INTO krx_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Aanucut hikawam niŋ munucu, pale akina, naanuc wootam niŋ munucu méesuume haaw. ");
INSERT INTO krx_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Síitanam inci pusoki, pálafi pa piteyoo penfakat pa píyisanaayisan nii umuuyen wa uteyoo weemeeŋe wa upayeepa kaaponket. Pale an óo an aŋa nkaponkete caahinkiŋ, caahinkilis lompo nálafi.” ");
INSERT INTO krx_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Fiye, Yéesu naasok aal a aŋuu: “Umuuyen wa utii uponketeeponket.” ");
INSERT INTO krx_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Keeyeniye ka toko hili neyoo nkáyaañ pusokool: “Aŋe ayem ayme, fo kati aponket umuuyen?” ");
INSERT INTO krx_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pale Yéesu naasok aal a: “Káyinan ka kitii kifakanuu, kaay niŋ kásuumaay.” ");
INSERT INTO krx_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Púful toko Yéesu naayeno kaamuusool ti pisaatee niŋ misaatee, káatuunan niŋ kakaman ekooŋan ya éesuume ya eti cáwii ca citi Pútuun pa. Pupoñapoñ pa pakateyoo ŋaasuwan niŋ pákasupak paka nkayeno neyoo, ");
INSERT INTO krx_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","niŋ lompo pakakee pakaal payenka náakuuñane niŋ payenka naayaane teyii kísaalumant: Mari aŋa nkasok ya Mari ati Makatala aŋa náafulanii ya teyoo kísaalumant isak niŋ kúsupak; ");
INSERT INTO krx_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yowanna, áyiinoo aŋa nkasok ya Husa, eeyeniye ya ati hikaw ha ti éhinuma ya eti Helot; Suusaana niŋ hícump pakakee pakaal, niŋ mañ ma miteyii nkayeno kayankanan Yéesu niŋ pupoñapoñ pa pakateyoo. ");
INSERT INTO krx_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Hikee hinoom, kayoŋ kenfakat nkuconcool niŋ pakan kéefulii ti pisaatee peemeeŋe nkíkey ti Yéesu. Ti káasiiŋuma enkuu, Yéesu naasokii hícantiitu eehe: ");
INSERT INTO krx_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Taakaataak akee áyiin aŋa eekaaye etah piyooseen. Akina ti kaawiisan etukal ya, ekee etukal ya neenowal ti pítin pa; neekakalee, pusuwa pa mpuhoon yo. ");
INSERT INTO krx_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ekee ya neenowal ti etaam eti pínankiin; niŋ páŋantalii eteyyo neesuucan, kamma etaam ya néecihut. ");
INSERT INTO krx_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ekee etukal ya neenowal ti pícankun, épiŋantoolii ti coonool niŋ pícankun pa, pícankun pa mpikincool yo. ");
INSERT INTO krx_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Fiye, ekee etukal ya neenowal ti etaam eenape, eyyuu néeŋantii neepuk ulant, kaalant óo kaalant nkupuk papukal keme.” Yéesu naasokii niŋ hiceeku: “An óo an eetaake kaanuu kiti káasiitan, ásiitan.” ");
INSERT INTO krx_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ta Yéesu naapaye ta káakup, pinapana pa pakateyoo nkacakanoo weyme hícantiitu eehuu nihisoke. ");
INSERT INTO krx_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Naañahanii: “Aluu niwufaneewufan kameye ka kiti heeyolee ha ti cáwii ca citi Pútuun pa, pale ti pakakee paka niŋ kícantiitu inci ínkup, samat nii ayaamakoola ya Esaaya fa naasoke fa: 'Nkasincan-sincan pale kacukantoo; Nkásiitan pale kámeyiyantoo.'” ");
INSERT INTO krx_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yéesu nene asok: “Ehe, eeha hícantiitu ha nihisoke ha: Etukal ya eyem hilim ha hiti Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Etukal ya eenowale ya ti pítin pa ecukaacuk nii payenka nkási ka hilim ha, Seetaani ya néekey néefulan ho ti saanii, ancuk timpi káyinan nkafakanee. ");
INSERT INTO krx_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Etukal ya eenowale ya ti etaam ya eti pínankiin pa ecukaacuk nii payenka nkasayan ka hilim ha niŋ pásuuma niŋ kásiyaa ho, pale hilim ha hitaakut ñínkonk teyii. Káyinanii kifiyyantoo, ti caanak citi páciite nkañoho puson. ");
INSERT INTO krx_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Etukal ya eenowale ya ti pícankun pa ecukaacuk nii payenka nkási ka hilim ha, pale ti eloŋ ya eteyii káamiilool ka niŋ hisaanumate ha niŋ pásuuma pa piti eloŋ ya mpikincoolii mpikitii hitaaku papukal peeyane. ");
INSERT INTO krx_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pale etukal ya eenowale ya ti etaam ya eenape ya ecukaacuk nii payenka nkási ka hilim ha nkayenan ho pinap ti saanii seekuule sa, nkamukut fo cákapukii samat nii fa kaalant nataak fa hícump ulat.” ");
INSERT INTO krx_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yéesu nene asok: “An acaaŋanantoo lampi náawuf teyyo epool niŋ fotom naanakan yo t’etaam ecunkun, pale nawaŋwaŋ yo ti esafu, ancuk an óo an éenakoonii naacuk ecaaŋ ya. ");
INSERT INTO krx_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Waah óo waah weeyolee éfuufulaniyee tíkitaaŋ, waah óo waah wéewufaloolee éfuuwufinee, núufulaniyee tíkitaaŋ. ");
INSERT INTO krx_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Ooto, nitah kunuu ti pásiitanal aluu. Kaatuko an óo an eetaake afaapenanee meemak; an óo an eetaakut, háati aŋa incukoo ya nii naataake efeesayee teyoo.” ");
INSERT INTO krx_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Púful toko, Yéesu íññaa ateyoo niŋ pakatuwoo nkákeyyoo hicuku, pale kayinaatoo hicuku kamma kayoŋ ka. ");
INSERT INTO krx_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nkasok Yéesu nii: “Iññáa atii niŋ pakatuwi unka kasiiŋiye tíkitaaŋ, kápilafiyi hicuku.” ");
INSERT INTO krx_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Naañahanii: “Iññáa atoom niŋ pakatuwam poko kayem payenka nkásiitan ka hilim ha hiti Pútuun pa nkáhin ho fa nihiñaŋee fa íhinu.” ");
INSERT INTO krx_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Hikee hinoom Yéesu náayuuko ti piteen niŋ pinapana pa pakateyoo, naasokii: “Ufiitanaa ti kikee kaapii ka kiti han ha.” Nkañak. ");
INSERT INTO krx_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ta nkayeniye ta kaafiitan, Yéesu naalam hiŋotu. Hítaapanu eyam néesapii ti han ha, piteen pa mpiyeno émeeŋanii man, nkayeno ti páciite penfakat. ");
INSERT INTO krx_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ti oom páciite, pinapana pa nkaloh Yéesu nkáyiyaloo, nkasokoo: “Ahámpaatiin! Ahámpaatiin! Efuuketaa!” Yéesu náayiyoonii naafet ti hiyam ha niŋ kúsuu ka kenfakat ka nkapilan niit. ");
INSERT INTO krx_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Púful toko naacakanii: “Káyinan ka kiti aluu unkey?” Ewatate neemeeŋii, ínnimii, nkayeno picakanool: “Ayme ayem áyiin aŋe, kati nasok hiyam ha niŋ kúsuu ka kapilan, nkásiyoo?” ");
INSERT INTO krx_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Púful toko, Yéesu niŋ pinapana pa pakateyoo nkaciŋ ti mah ma miti Kelasen, meeyem ma ti púcoonool mah ma miti Galilee. ");
INSERT INTO krx_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ta Yéesu naayeniye ta éyuukinoyii ti piteen pa, áyiin ati saatee ya náakey kapaakoolanoo. Ayíin a aŋuu kísaalumant kúwuuliyoo, afiyaafiyo awasiyantoo wañ, akinut ti ekumpaan fo ti kúhokuma ka. ");
INSERT INTO krx_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Nkuloomooloom íhinu apihiñ, háati nkacenk sipeesoo niŋ wootoo niŋ ñiseel kati kafaasoo, naacutal ño, kísaalumant ka nkítintiŋanoo ti káahaaŋ ka tes. Ayíin a ta naacuke ta Yéesu naaceek, naanow ti wootoo, náaceekii ti kaawiiluyoo: “Weyme állafiye ti inci, Yéesu, Añii ya ati Pútuun pa piti patiila? Inci luumuu timpi kallanam!” Asokaasok eehe, kamma Yéesu naafete ti kísaalumant ka, apusok ko kúfulii teyoo. ");
INSERT INTO krx_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yéesu naacakanoo: “Caacawi puume?” Naañahanoo: “Caacawam 'Kayoŋ',” kamma kísaalumant keemeeŋe nkinakiyoo. ");
INSERT INTO krx_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nkiŋiino Yéesu timpi awant ko ti seemak. ");
INSERT INTO krx_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Inhemool koolee enfakat eti pícalukun neeyeno kaahoon ti kanaac cítintiŋ. Kísaalumant ka nkiŋiino Yéesu apikatan ko kipinako ti pícalukun pa, naakatan ko. ");
INSERT INTO krx_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nkúfulalii ti áyiin a, nkinakalo ti pícalukun pa, koolee ya néeliiŋoonii mpacas patiila cítintiŋ ca, neenow ti han ha néeseem. ");
INSERT INTO krx_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ta keeyeniye ka efaas ya nkacuke ta heetaakiye ha nkatey ti saatee ya niŋ ti misaatee ma méekinkoolii ma kakaman pakan paka heetaakiye ha. ");
INSERT INTO krx_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Fiye, pakan paka nkákey kaasincan heetaakiye ha. Nkácolii ti Yéesu nkatook áyiin a aŋa kísaalumant ka nkúfulii ya teyoo náasooliye niŋ kunuuwoo cononon naayeno ti woot Yéesu. Ta nkacuke ta eehuu nkameeŋ niŋ ewatate. ");
INSERT INTO krx_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Keecuke ka heetaakiye ha nkayeno kakaman pakan paka puume áyiin a aŋa kísaalumant ka nkúfulii ya teyoo fa náakuuñanee fa. ");
INSERT INTO krx_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Púful toko, pakan paka púlooŋ pakati mah ma miti Kelasen nkaluum Yéesu akatanii apikaay, kamma ewatate enfakat neeyeniye neyii. Yéesu náayuuko ti piteen pa, áñakum ");
INSERT INTO krx_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","áyiin a aŋa kísaalumant ka nkúfulii ya teyoo naaluum kanapanoo, pale Yéesu naayaanoo, naasokoo: ");
INSERT INTO krx_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ñoho ti enuufi inkaakaman eeha púlooŋ Pútuun pa mpíhinuu ha.” Ayíin a naakaay ti saatee ya púlooŋ, naayeno kakaman eeha Yéesu náahinoo ha. ");
INSERT INTO krx_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pakan paka púlooŋ nkayeno hítuulu Yéesu ti kikee kaapii ka kiti han ha, ta náañohoonii ta, kayoŋ ka nkuwananoo. ");
INSERT INTO krx_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ehe, intaako áyiin aŋa nkasok Yayil áhampaatiin ti éluumuma ya. Náakey naanow ti woot Yéesu, naaŋiiniyoo apikaay pati enuuf ya eteyoo ");
INSERT INTO krx_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kamma añiinoo ámaacul oonool a lamma eetaake máamun sitiil ŋaasuwan niŋ súsupak naayeniye ti putum eket. Ta Yéesu naayeniye ta pikaayu pateyoo kayoŋ ka nkikincooloo. ");
INSERT INTO krx_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Intaako toko aal eeyeniye hicuku etaam eefiitantoo fo sitiil ŋaasuwan niŋ súsupak, náapucalool mañoo púlooŋ ti púkuuñana pale an ayinaatoo káakuuñan. ");
INSERT INTO krx_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Náakey puson Yéesu, náalik hileelu hísool ha henfakat ha hiteyoo, tokotoko etaam ya eteyoo neesiiŋo. ");
INSERT INTO krx_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yéesu naacakan: “Ayme álikaam?” Pakan paka púlooŋ nkalaaco, Piyeer naasokoo: “Ahámpaatiin, kayoŋ ka kúconcooliyoo-concool nkikincooli.” ");
INSERT INTO krx_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pale Yéesu naasok: “An álikaamlik kaatuko méyimeyi nii sempe sífulaaful ti inci.” ");
INSERT INTO krx_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aal a náameyi nii eeha náahine ha hiyoliit, náakey niŋ kakikilan, náakilipo ti woot Yéesu. Naakaman hátikin pakan paka púlooŋ heewune ha náalik Yéesu niŋ fa náakuuñanee fa tokotoko. ");
INSERT INTO krx_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yéesu naasokoo: “Añiinam káyinan ka kitii kúkuuñanuu. Kaay niŋ kásuumaay.” ");
INSERT INTO krx_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yéesu ti káakup, an náafulii pati ekumpaan ya eti Yayil áhampaatiin a ati éluumuma ya. Naasok Yayil: “Añiini ámaacul aketaaket, timpi yokan fiye Ahámpaatiin a.” ");
INSERT INTO krx_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yéesu niŋ pásiyaloo eteeho naasok Yayil: “Timpi fe, yínan lamma, añiini afaayeno kásuumaayoo.” ");
INSERT INTO krx_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Fiye Yéesu naakaay, naanako lati ekumpaan ya eti Yayil. Acoonut an apinako neyoo fo Piyeer, Saŋ niŋ Saak, niŋ añii ya faafoo niŋ íññaayoo. ");
INSERT INTO krx_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pakan paka púlooŋ nkayeno pukooŋ niŋ esampoolo, Yéesu naasok: “Níyekuno pukooŋ pa kaatuko aŋe aketut, hiŋotu naayaake.” ");
INSERT INTO krx_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nkayeniyoo caalenken kamma nkameya nii añii ya aketaaket. ");
INSERT INTO krx_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pale Yéesu náasik epees añii ya naayonkaloo, naasokoo: “Añiinam, íiyo!” ");
INSERT INTO krx_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yaanoo néeñohoonii naahaaŋ ti piyito. Yéesu naasokii kawufanoo apili. ");
INSERT INTO krx_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Pupukayoo ínnimii pale Yéesu naakitii hisoku heetaakiye ha an. ");
INSERT INTO krx_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yéesu naayonkal nantoonool pupoñapoñ pa pakateyoo ŋaasuwan niŋ pákasupak paka, naawufanii sempe niŋ kayine kiti hiyaanu kísaalumant ka púlooŋ niŋ káakuuñan úkuuñu. ");
INSERT INTO krx_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Púful toko, naapoñii kapikaay káatuunan cáwii ca citi Pútuun pa niŋ káakuuñan púkuuña. ");
INSERT INTO krx_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Naasokii: “Ti pítin pa piti kaakaawool ka timpi niyekan waah: Hikasap tom, epootak tom, hímpuul tom, mañ tom, háati hísool hísupiyenu. ");
INSERT INTO krx_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Niŋ ninakiyaa ti ekumpaan, inniyeno toko fo ta éfiniful ti oom saatee. ");
INSERT INTO krx_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Niŋ pakan kawananut aluu, nihank haafol ha ti woot aluu nípiyisanii nii Pútuun pa efipisapii, ínniful ti oom saatee.” ");
INSERT INTO krx_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Pupoñapoñ pa pakateyoo nkakaay, nkanako ti misaatee ma kapiyeno káatuunan ekooŋan ya éesuume ya niŋ káakuuñan pakan paka pan óo pan. ");
INSERT INTO krx_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Heetaakiye ha púlooŋ nihicol ti kaanuu Helot Antipas, ati hikaw ha ati Galilee. Naaliim meemak kamma pakakee paka nkayem ti hisoku nii Saŋ-Patis álitaniyee ti keekete ka, ");
INSERT INTO krx_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","pakakee paka nkasok ayaamakoola ya Elí himuumoo áñohoonii, pakakee paka nkasok akee ti piyaamakoola pa keefiyye ka álitoonii ti keekete ka. ");
INSERT INTO krx_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pale Helot naasok: “Saŋ, inci himuumam mukoo ta inci impoñii ta kapifiit hikawoo. Aŋe akina ayem ayme, aŋa inci iyyem ya ti hísiyu kiteyoo?” Naaŋes hicuku Yéesu. ");
INSERT INTO krx_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yéesu, pupoñapoñ pa pakateyoo kápuñohoonii nkakamanoo eeha nkáhine ha. Naacoopii kapiñako lamayii ti saatee ya eyya nkasok ya Petesayit. ");
INSERT INTO krx_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pale kayoŋ ka kípipannumoo, nkinapanoo. Yéesu naawananii, naayeniyii káakup kiti cáwii ca citi Pútuun pa, náakuuñan keesoolahe ka ékuuñano. ");
INSERT INTO krx_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Cípiniimo, pupoñapoñ pa pakateyoo ŋaasuwan niŋ pákasupak paka nkaloh Yéesu, nkasokoo: “Unaa úlaaŋaalaaŋ, katan kayoŋ ka kipikaay ti pisaatee pa niŋ misaatee ma meelohe ma le, kati kíyini hitaaku paliyal niŋ káahintuma.” ");
INSERT INTO krx_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yéesu naasokii: “Aluu faŋ aluu niwufanii kapili.” Pupoñapoñ pa nkañahanoo: “Kúmpuul isak niŋ soon súsupak lamma nuutaakaa, fo niŋ unii ukaayaa hinoom paliyal piti pakan paka púlooŋ.” ");
INSERT INTO krx_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kasokaasok eehuu kaatuko máamun pákayiin síwuli isak (5,000) kayeniye toko. Yéesu naasok pupoñapoñ pa pakateyoo: “Níhinii kapiyeno ti uyoŋ uti máamun pakan áwii ésupak niŋ ŋaasuwan (50).” ");
INSERT INTO krx_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pupoñapoñ pa pakateyoo nkáhin fo, an óo an naayeno. ");
INSERT INTO krx_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yéesu naacoop kúmpuul ka isak ya niŋ soon sa súsupak sa náahaafin patiila, naanimpan Pútuun pa, naafiitalool ko, naawufan pupoñapoñ pa pakateyoo kápipaacinool ko kayoŋ ka. ");
INSERT INTO krx_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Pakan paka púlooŋ nkali fo kasiit tuk. Fiye, pupoñapoñ pa pakateyoo nkayesal mífiitiin paliyal pa peetowiye pa fo kameeŋan síyya ŋaasuwan niŋ súsupak. ");
INSERT INTO krx_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Hikee hinoom, Yéesu naayeno kaluum lamayoo, pinapana pa pakateyoo nkayeno toko neyoo. Naacakanii: “Ti pakan paka, inci yem ayme?” ");
INSERT INTO krx_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nkañahanoo: “Pakakee kasok awe yem Saŋ-Patis, pakakee paka nkasok awe yem Elí ayaamakoola ya, pakakee paka nkasok akee ti piyaamakoola pa keefiyye ka álitoonii ti keekete ka.” ");
INSERT INTO krx_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Naacakanii: “Ti aluu, ayme innisoke inci iyyem?” Piyeer naacoop hilim ha naasokoo: “Awe yem Eenucee ya ati Pútuun pa.” ");
INSERT INTO krx_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yéesu náakupananii, naakitii hisoku eteeho an. ");
INSERT INTO krx_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yéesu nene asok pinapana pa pakateyoo: “Inci, Añii An, fo yeno ti kúnuul kenfakat ti sipees ñíhampaatiin ña pakati pakan paka, pikalaŋana hilim ha heesiiŋanee ha hiti Móyiis niŋ ñíhampaatiin puwaaseena pa pakati Pútuun pa efikapookam, famukee, ti hinoom ha íhaaciyenu ha inci fálitaniyee ti eket ya.” ");
INSERT INTO krx_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Naasokii poko púlooŋ: “Niŋ an álafiyaam kanapan afaapook himuumoo, naanapanam fo álafi eket ti kuluwaa. ");
INSERT INTO krx_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kaatuko aŋa éelafiye kafakan eloŋ ya eteyoo, áfaapuul teyyo. Pale aŋa éepuule eloŋ ya eteyoo kamma inci, afaafakan yo. ");
INSERT INTO krx_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Empeyme panap piyem toko an kati ataak hisaanumate ha hiti púlunta pa púlooŋ náapuul ti eloŋ ya eteyoo niŋ fotom naatahoolo? ");
INSERT INTO krx_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Niŋ an asuuwaam niŋ kilim ka kutoom, inci, Añii An, fasuuwoo niŋ inci ñóhooniyoo ti hamake ha hitoom niŋ ti hamake ha hiti Paapaa atoom niŋ pumaleekoo pa peesampanee pa. ");
INSERT INTO krx_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Inci pusok aluu pánipani ya, pakakee ti keesiiŋiye ka le etikaket peecukut cáwii ca citi Pútuun pa.” ");
INSERT INTO krx_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ta Yéesu naapaye ta káakup enkuu máamun kunoom isak niŋ káhaaciil, naacoopool Piyeer, Saŋ niŋ Saak nkasilo patiila tíntiŋ ya kaluum. ");
INSERT INTO krx_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Akina ti kaluum ka pacuk puhooŋuyoo mpiyesan, wañ wa uteyoo núuhiiniyii fo nuucaaŋ cataŋ. ");
INSERT INTO krx_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tokotoko, pákayiin pákasupak ti piyaamakoola pa keefiyye ka nkayeno neyoo kákupat, poko kayem Móyiis niŋ Elí ayaamakoola ya. ");
INSERT INTO krx_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Poko káfulii ti ecaaŋ enfakat. Nkayeno káakup niŋ Yéesu kiti eket ya eteyoo eyya naakaakaay ya kaahankan Jerusalem. ");
INSERT INTO krx_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piyeer niŋ pákawiyoo nkaket niŋ hiŋotu, ta nkáyiyoonii ta nkacuk hamake ha hiti Yéesu niŋ pákayiin paka pákasupak paka keesiiŋiye ka neyoo. ");
INSERT INTO krx_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Pákayiin paka payenkuu ta nkayeniye ta píkatinool niŋ Yéesu, Piyeer naasokoo: “Ahámpaatiin, napaanap unii úpuyemi le. Upusiiŋan múkuut míhaaciil, coonool citii, coonool citi Móyiis, coonool citi Elí.” Amíit eeha naayeniye káakup. ");
INSERT INTO krx_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ta naayeniye ta káakup káatiŋu nkúfulii nkíkimpitoolii, ewatate neeyeno niŋ pinapana pa pakateyoo ta nkanakiye ta ti káatiŋu ka. ");
INSERT INTO krx_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Hilim níhifulii ti káatiŋu ka nihisok: “Aŋe ayem Añiinam, inci mamaloo. Nísiitanoo!” ");
INSERT INTO krx_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ta hilim ha nihipaye ta káakup nkacuk Yéesu lamayoo. Piyeer niŋ pákawiyoo nkafatanool neeho, kakamanut an ti oom caanak eeha nkacuke ha. ");
INSERT INTO krx_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Eti kacom eteyyo, Yéesu niŋ pinapana pa pakateyoo pákahaaciil paka nkáwanoonii ti etaam tíntiŋ ya, kayoŋ kenfakat nkíkey kaapaakoolanoo. ");
INSERT INTO krx_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ayíin náaceekii ti kayoŋ ka: “Ahámpaatiin, inci luumuu, sincan añiinam akampaani ye, añiinam oonool a kóŋ aŋa inci intaake ya! ");
INSERT INTO krx_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Hísaalumant nihinakiyoonako, tokotoko níhihinoo apiceek, níhiyiyiŋanoo niŋ sempe fo putumoo mpiyohat, nihikallanoo, hífiisantoo kakatan. ");
INSERT INTO krx_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Inci luumaaluum pinapana pa pakatii kati kayaan ho, pale kayinaat.” ");
INSERT INTO krx_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yéesu naasok: “Oo! Aluu ekaay ya eenaput ya apan nitaakut káyinan, fo teyme inci fayeno niŋ aluu immukut niŋ aluu? Cóopii añiini le.” ");
INSERT INTO krx_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Añii ya ti ékey ya, hísaalumant ha nihitahoo híp t’etaam, níhiyiyiŋanoo niŋ sempe. Pale Yéesu naafet ti hísaalumant ha, náakuuñan añii ya, naañahanoo faafoo. ");
INSERT INTO krx_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Pakan paka púlooŋ ínnimii ti sempe sa senfakat sa siti Pútuun pa. Pakan paka oopa nímii ti eeha Yéesu náahine ha púlooŋ, naasok pinapana pa pakateyoo: ");
INSERT INTO krx_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Niwas kilim enke ti unuu aluu: Inci, Añii An, fawufanee ti sipees pakan.” ");
INSERT INTO krx_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pale kámiit eeha naayeniyii hisoku. Putum hilim ha nihiyolee ti poko timpi kámeyi fa nihisoke, nkafe kacakanoo puume nihisoke. ");
INSERT INTO krx_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Fiye, Yéesu pupoñapoñ pa pakateyoo ŋaasuwan niŋ pákasupak paka nkáyaañ pílaacinool aŋa eehaŋe pamake teyii. ");
INSERT INTO krx_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yéesu náameyi pámiiloolal pa piteyii, naacoop ciñii naasiiŋan co pukoloo. ");
INSERT INTO krx_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Naasokii: “An óo an eewanane ciñii ence ti caacawam, inci naawanane, an óo an eewananaam, aŋa éepoñiyaam ya lompo naawanane. Kaatuko aŋa éetinee ya ti aluu púlooŋ, akina ayem eemaka ya.” ");
INSERT INTO krx_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Saŋ naacoop hilim ha, naasok: “Ahámpaatiin, unii ucukaacuk áyiin ti hiyaanu kísaalumant ti caacawi, nuuyoop hikituyoo, kamma naaneetaat ati kayoŋ ka kiti unaa.” ");
INSERT INTO krx_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yéesu naañahanoo: “Timpi nikitoo, kaatuko an óo an eepookut aluu oopa ti aluu.” ");
INSERT INTO krx_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yéesu, hicoopu ha hiteyoo alacana, ta níhilohanii ta, naacok piliit pikaayu pa piti Jerusalem. ");
INSERT INTO krx_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Naapoñ pakan niŋ kilim kapunowoo hátikin, oom pakan nkakaay, nkanako ti cisaatee citi Samali kapimemanool ékey ya eteyoo. ");
INSERT INTO krx_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pale pakan paka pakati cisaatee ca kawananutoo, kamma naayem ti himuusu Jerusalem. ");
INSERT INTO krx_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pinapana pa pakateyoo, Saak niŋ Saŋ ta nkacuke ta eehe nkasokoo: “Ahámpaatiin, áalafilafi úpuwananii seemak sípifulii patiila sípipucaloolii?” ");
INSERT INTO krx_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pale Yéesu náayesoonii lipe ti poko, naafet teyii. ");
INSERT INTO krx_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Fiye, nkakaay ti cikee cisaatee. ");
INSERT INTO krx_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ta nkayeniye ta pikaayu ti pítin pa, akee áyiin naasok Yéesu: “Inci fanapani pan óo pan pa ankaakaay.” ");
INSERT INTO krx_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yéesu naasokoo: “Piyen elampa ya pitaakaataak uyeen, pusuwa pa mpitaak ñáawuunu, pale inci, Añii An, taakut la fanaŋ hikawam.” ");
INSERT INTO krx_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Naasok akee áyiin: “Napanam,” pale áyiin a naañahanoo: “Ahámpaatiin, túulam pícaahokii fala paapaa atoom.” ");
INSERT INTO krx_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yéesu naasokoo: “Kat keekete ka kapuhok pakateyii keekete ka, pale awe kaay cáatuunan cáwii ca citi Pútuun pa.” ");
INSERT INTO krx_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Akee áyiin nene, naasokoo: “Ahámpaatiin, inci fanapani, pale túulam fala pikaay upuca úkatinoolii niŋ pakanam.” ");
INSERT INTO krx_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yéesu naasokoo: “An óo an eecoke kacantu naawelep puson, átuuniit páhin ti cáwii ca citi Pútuun pa.” ");
INSERT INTO krx_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Púful toko, Ateeteyo nene amamal pakakee pinapana áwii éhaaciil niŋ ŋaasuwan niŋ pákasupak (72), naapoñii pákasupak pákasupak kapunowoo hátikin ti pisaatee pa púlooŋ niŋ pan óo pan pa naañaŋe pikaayu. ");
INSERT INTO krx_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Naasokii: “Kaamaañ ka kufomaafom pale pumaaña pa kameeŋut. Ooto niluum Ateeteyo ati kaamaañ ka apupoñ pumaaña kapikaay kaamaañ ka kiteyoo. ");
INSERT INTO krx_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nikaay! Inci pupoñ aluu samat nii mísaacii ti pututa piyen elampa. ");
INSERT INTO krx_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Timpi niyekan mañ, epootak tom, pisamata tom, ti pítin pa timpi nikican an. ");
INSERT INTO krx_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Niŋ ninakiyaa ti ekumpaan, níyaañ nisok: 'Kásuumaay kiyeno ti ekumpaan eyye.' ");
INSERT INTO krx_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Niŋ an ati kásuumaay oopa toko, kásuumaay ka kiti aluu efikiyeno teyoo, niŋ ekina tom, éfikuñohoonii ti aluu. ");
INSERT INTO krx_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Niyeno ti ekumpaan eyyuu, innili, innilaan waah ewwa efikawufan wa aluu. Kaatuko áhina añaŋaa hitaaku cooy ya eteyoo. Timpi nitootoosool ti pukumpaan. ");
INSERT INTO krx_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Niŋ ninakiyaa ti saatee, pakati saatee ya nkawanan aluu, nili waah óo waah ewwa nkawufane aluu. ");
INSERT INTO krx_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Inníkuuñan púkuuña pa keeyem ka ti oom saatee, innisokii: 'Cáwii ca citi Pútuun pa cíkeyyoo pukol aluu.' ");
INSERT INTO krx_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pale niŋ ninakiyaa ti saatee, pakati saatee ya kawananut aluu, nikaay pati ñítin ña innisok: ");
INSERT INTO krx_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","'Háati haafol ha hiti saatee ya hiti aluu heecoke ha ti woot unii, unii uhankaa ho úpuyisan aluu nii Pútuun pa efipisap aluu. Háati ekina, nímeyi nii cáwii ca citi Pútuun pa cílohiyooloh.' ");
INSERT INTO krx_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Inci pusok aluu: Hinak eeha Pútuun pa mpikaakaay íhinu kíiti ya, kúnuul ka kiti saatee eyyuu efikihaŋ kiti pakati saatee ya eti Sotom. ");
INSERT INTO krx_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Kúnuul efikiyeno ti aluu pakati saatee ya eti Kolasin, kúnuul efikiyeno ti aluu pakati saatee ya eti Petesayit. Kaatuko waah weecukantee Pútuun pa mpíhine ti pisaatee pa piti aluu. Niŋ eehuu hitaakiye ti pisaatee pa piti Til niŋ Siton, anti kafiyo nkáwunkiye umuuyen wa uteyii, nkayeno niŋ kúsool kiti pupootak niŋ emaamoolo píiha kápiyisan ewatanoolo ya eteyii. ");
INSERT INTO krx_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pale hinak eeha Pútuun pa mpikaakaay íhinu kíiti ya, kúnuul ka kiti aluu efikihaŋ kiti pakati Til niŋ Siton. ");
INSERT INTO krx_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aluu pakati saatee ya eti Kafaanawum, fo éfiniseepinee alacana? Haani, efiniwananee pati keekete ka.” ");
INSERT INTO krx_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yéesu naapenan hisoku pinapana pa pakateyoo: “An óo an éesiitane aluu, inci náasiitane; pale an óo an eepooke aluu inci naapooke; an óo an eepookaam, éepoñiyaam ya lompo naapooke.” ");
INSERT INTO krx_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ta pinapana pa áwii éhaaciil ya niŋ ŋaasuwan niŋ pákasupak paka (72) nkáñohoonii ta niŋ pásuuma nkasok Yéesu: “Ahámpaatiin, ta núukupe ta ti caacawi háati kísaalumant ka kísiitanaa-síitan unii.” ");
INSERT INTO krx_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yéesu naasokii: “Inci cukaa Seetaani ya néefulii patiila néenowii nii pamaliñoolal etiil. ");
INSERT INTO krx_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nísiitan! Inci ufanaawufan aluu kayine kiti kakakal ti ufepa niŋ ti púpuntaloo, niŋ iheeku sempe sa púlooŋ siti Seetaani ya, háati waah etuukuum aluu. ");
INSERT INTO krx_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pale timpi nitaak pásuuma kamma kísaalumant ka nkísiitane aluu, nitaak pásuuma kamma ucaw aluu nuukiicee alacana.” ");
INSERT INTO krx_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ti oom káasiiŋuma, Kunuu ka keenape ka nkimeeŋan Yéesu niŋ pásuuma, naasok: “Inci múluu Paapaa, Ateeteyo ati patiila niŋ t’etaam, kamma ayyole eehe keecohatiye ka niŋ kéesuume ka kunuu, pale íyyisan ho keewananooliye ka nii epuuk kenkilis. Ee, Paapaa, kaatuko fiye állafiye hipitaako ti pásuum pa pitii. ");
INSERT INTO krx_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Paapaa atoom awufanaamufan waah wa púlooŋ. An ámiit ayme ayem Añii ya, fo Paapaa ya, an lompo ámiit ayme ayem Paapaa ya fo Añii ya niŋ payenka Añii ya náalafiye ka káyisanoo.” ");
INSERT INTO krx_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Púful toko, naayeso pati pinapana pa pakateyoo naasokii poko lamayii: “Niyihaayih kaatuko ñíkin aluu iññicukcuk eeha innicuke ha. ");
INSERT INTO krx_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Inci pusok aluu: Hícump piyaamakoola niŋ pumansa kálafilafi hínum hicuku eeha innicuke ha pale kacukut ho, nkálafi hísiyu eeha ínnisiye ha pale kásiyut ho.” ");
INSERT INTO krx_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Fiye, áhampaatiin ati hilim ha heesiiŋanee ha hiti Móyiis, ápilafi puwinko Yéesu, naasiiŋo naacakanoo: “Ahámpaatiin, puume inci iññaŋe íhinu pitaak eloŋ ya eepayantoo ya?” ");
INSERT INTO krx_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yéesu naasokoo: “Weyme ukiicee ti hilim ha heesiiŋanee ha? Weyme ánsiye toko?” ");
INSERT INTO krx_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Naañahanoo: “Láfi Ateeteyo Pútuun pa pitii ti himuumi púlooŋ, ti kunuuwi púlooŋ, ti yaani púlooŋ, ti sempeyi púlooŋ niŋ ti ecohatoyi púlooŋ. Lompo láfi akinooli samat nii fa állafiye fa faŋi.” ");
INSERT INTO krx_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yéesu naasokoo: “Aañahanaa pinap. Náahinaa fo aafataak eloŋ ya eepayantoo ya.” ");
INSERT INTO krx_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pale akalaŋana ya náalafi káyisan nii fa naasoke fa fo, naañoho apicakan Yéesu: “Ayme ayem akinoolam?” ");
INSERT INTO krx_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yéesu naasokoo hícantiitu heehe: “Taakaataak akee áyiin éefulii Jerusalem apiyeno éwanoonii Jeriko. Ti pítin pa, naapaakool niŋ pikanca. Payenkuu nkawaatoo, nkasapoo fo alamo, nkatahoo toko. ");
INSERT INTO krx_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Intaak awaaseena ati Pútuun pa eeyeniye énapii oom pítin apiŋantanoo la naahintiye la, naacinciliyoo naamuus. ");
INSERT INTO krx_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Intaak ásisikana puwaaseena pa lompo ápucolii toko naaŋantanoo, naacinciliyoo naamuus. ");
INSERT INTO krx_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pale intaako áyiin ati Samali eeyeniye pikaayu kaakaawool ápucolii lompo teyoo. Naacuk áyiin a aŋuu naahintiye inketoo teyoo ti hikaw. ");
INSERT INTO krx_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Naalohoo naatoot musontuwaay ma miteyoo niŋ munucu niŋ elaan, naacenk mo niŋ mufaal. Naalapanoo ti fáli ya eteyoo, naacoopoo ti ekumpaan éwananuma ekaawoola, naamankooloo. ");
INSERT INTO krx_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Eti kacom eteyyo náafulanii sikoofali súsupak naawufan so ati éwananuma ekaawoola ya, naasokoo: 'Mankoolam aŋe, niŋ inci ñóhooniyoo mañ óo mañ emma ampenane toko efiñahani mo.'” ");
INSERT INTO krx_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yéesu naacakanoo: “Ti pacukali, ayme ti payenke t’éhaaciilii ayem akinool a ati aŋa eenowe ya ti sipees pikanca pa?” ");
INSERT INTO krx_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ahámpaatiin ya ati hilim ha heesiiŋanee ha naañahanoo: “Akina ayem aŋa eecukoo ya inketoo teyoo ti hikaw.” Yéesu naasokoo: “Kaay, awe lompo, hín fo.” ");
INSERT INTO krx_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yéesu niŋ pinapana pa pakateyoo, ta nkayeniye ta ti pítinii, naanako ti cisaatee, aal aŋa nkasok Maarta naawananoo ti ekumpaan ya eteyoo. ");
INSERT INTO krx_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Naataak atu, aŋa nkasok Mari, naayeno ti woot Ateeteyo, apiyeno káasiitan eeha naayeniye ha kakalaŋan. ");
INSERT INTO krx_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pale Maarta naayeno eyesoolo niŋ paliima kaamemanool paliyalii. Náakey ti Yéesu naasokoo: “Ahámpaatiin, cokuti ti inci fa atuwam naakatoolaam fa niŋ páhin pa? Ooto sokoo ayankananam.” ");
INSERT INTO krx_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ateeteyo naañahanoo: “Maarta, Maarta, aapa ti ewasoolo kúnuul, immeeŋanoolo kúnuul ti waah weemeeŋe. ");
INSERT INTO krx_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pale waah woonool lamma usoolahee. Mari amamale weenape wa, apan étuufulanee teyoo.” ");
INSERT INTO krx_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Hikee hinoom, Yéesu naayeno kaluum lakeenaay. Ta naapaye ta, akee ti pinapana pa pakateyoo naasokoo: “Ahámpaatiin, yísanool unii fa nkaluum samat nii fa Saŋ náayisanoole fa pinapana pa pakateyoo.” ");
INSERT INTO krx_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yéesu naasokii: “Niŋ niyeniyaa kaluum innisok: 'Paapaa, álimaati caacawi cisampanee, álimaati cáwii ca citii cíkey. ");
INSERT INTO krx_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Alímaati aawufan unii hinoom óo hinoom paliyal pa putoonii. ");
INSERT INTO krx_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Alímaati aaponket unii umuuyen wa utoonii, samat nii fa nuuponket fa lompo umuuyen wa uti keemuuyene ka toonii. Timpi katan unii upunow ti híluuŋu ha.'” ");
INSERT INTO krx_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Yéesu nene asokii: “Usokaa akee ti aluu ataake áwi éekaawoolii mpisit, aataakut aŋa aafawufanoo apili. Fiye, ankaay pati akee áwiyi insokoo: 'Awíyam, máakiyam kúmpuul káhaaciil, kaatuko, akee áwiyam ákaawoolii féefiye, taakut waah ewwa inci fawufanoo apili.' ");
INSERT INTO krx_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Eeyem ya páhantuwa náañahaniyi apusok: 'Timpi yokanam! Hunkut ha hikuleekul, inci niŋ epuukam uhintaahinto, étiyini piyito puwufani kúmpuul.' ");
INSERT INTO krx_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Inci pusok aluu: Háati aŋa ayitiit apuwufani kúmpuul ka kamma naayem áwiyi, pale afaalito apuwufani aŋa ansoolahe ya púlooŋ kamma antaakut ñusuu iŋŋiiniyoo. ");
INSERT INTO krx_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Inci pusok aluu, niluum efipuwun aluu, niŋes efinilaŋan, niwenken éfipipankin aluu. ");
INSERT INTO krx_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kaatuko an óo an eeluume afaawunee, an óo an eeŋese afaalaŋan, an óo an eewenkene áfaapankinee. ");
INSERT INTO krx_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ayme faaf ti aluu, afaawufan añiinoo epululoola niŋ aluumoo yoon? ");
INSERT INTO krx_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Niŋ fotom naawufanoo púntaloo niŋ aluumoo heeh? ");
INSERT INTO krx_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Niŋ aluu keenaput ka nimeya kawun waah weenape epuuk aluu, puume Paapaa ati aluu eeyem ya alacana atahaŋ naawufane Kunuu ka keenape ka payenka keeluumoo ko ka.” ");
INSERT INTO krx_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Hikee hinoom nene, Yéesu naayeno hiyaanu hísaalumant heeyinaat káakup. Ta hísaalumant ha níhifulii ta, áyiin a náayaañ káakup, kayoŋ ka kenfakat ka ínnim ko. ");
INSERT INTO krx_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pale pakakee paka nkasok: “Ti caacaw Pelesepul, áhampaatiin a ati kísaalumant ka, innayaan kísaalumant ka.” ");
INSERT INTO krx_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Pakakee paka nkálafiyoo puwinko, nkasokoo áyisanii píyisan péeyisane nii Pútuun pa púpoñiyoo. ");
INSERT INTO krx_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pale, Yéesu náameyi pámiiloolalii, naasokii: “Cáwii óo cáwii céetaakoolanooliye, eficinow; pukumpaan etenco púlooŋ efipuhumaloolo mpinaŋanoolo ti enow. ");
INSERT INTO krx_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nisok nii ti caacaw Pelesepul inci niyyaan kísaalumant ka. Pale niŋ cáwii ca citi Seetaani cíkatinooliyaa, puume éficiyini pisiiŋo? ");
INSERT INTO krx_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Fiye, niŋ ti caacaw Pelesepul inci niyyaan kísaalumant ka, pinapana pa pakati aluu ti caacaw pakayme nkayaan ko? Ooto, efikayeno píhina aluu kíiti. ");
INSERT INTO krx_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pale niŋ ti caacaw ca citi Pútuun pa inci niyyaan kísaalumant ka, ooto, cáwii ca citi Pútuun pa cícoliyoocol ti aluu. ");
INSERT INTO krx_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Niŋ áyiin eetaake sempe naataak lompo pucoolaŋ ayeniyaa efaas ekumpaan ya eteyoo, waah óo waah uteyoo weeyem toko, uwwa ti pamankal peenape. ");
INSERT INTO krx_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pale niŋ taakaa áyiin eehaŋoo sempe, éekeyii kátaakoolanoo, naaheekoo, naacoop pucoolaŋ pa piteyoo empa náayinane pa tempo, náapaacinool waah óo waah uteyoo. ");
INSERT INTO krx_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“An eeneetaat niŋ inci, apookaampook, an eeyankananutam kaaconcenool, nahancalool-hancalool. ");
INSERT INTO krx_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Niŋ hísaalumant hífulaa ti an, nihimuusool-muusool ti káahaaŋ ka tes ti hiŋes éyekunooluma. Niŋ hílaŋaniyoot, nihisokoolo: 'Túulam, inci puñoho pati aŋa inci ínfulii ya.' ");
INSERT INTO krx_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ti éñohoonii eteeho, nihitook ékinuma ya neeneeŋee neememanoolee pitempo tak. ");
INSERT INTO krx_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Fiye, nihikaay, níhicoopii kikee kísaalumant isak niŋ kúsupak keehaŋe ho pakanc, nkinako nkikin toko. Kúnuul ka kikelan ka kiti an a aŋuu nkihaŋ páciite kíyaañ ka.” ");
INSERT INTO krx_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yéesu ti hisoku ha eehuu, aal náaceekii ti kayoŋ ka: “Iññáa ya eepukuu ya náacuuwani ánapiyanee-nápiyan.” ");
INSERT INTO krx_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pale Yéesu naañahanoo: “Payenka nkásiitan ka hilim ha hiti Pútuun pa nkáhin ho kánapiyanee-nápiyan.” ");
INSERT INTO krx_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Uyoŋ wa ta núuconcoolii ta, Yéesu naasok: “Aluu ekaay eenaput, fo hiŋes píyisan péeyisane nii Pútuun pa púpoñiyaam inniyaake? Háati poonool étiniyisanee, fo píyisan pa piti Jonas. ");
INSERT INTO krx_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Samat nii Jonas fa naayeniye fa píyisan ti pakati Ninew, fo lompo inci, Añii An, fayeno píyisan ti ekaay eyye. ");
INSERT INTO krx_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Ta infiyye, amansa ya aal a ati Sepa, náafulii ti mah méelaaŋee láaŋ ápikey peti amansa ya Solomon káasiitan ecohato ya eteyoo. Fiye, heeyem ha le hihaŋaahaŋ amansa ya Solomon. Ekina ewune, ti hinoom ha hiti kíiti ya, amansa ya aal a ati Sepa afaasiiŋo hátikin ekaay eyye náahin yo kíiti. ");
INSERT INTO krx_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Fo lompo incuke, Jonas náatuunan hilim ha hiti Pútuun pa pakati Ninew, nkáwunko umuuyen wa uteyii. Fiye, heeyem ha le hihaŋaahaŋ Jonas. Ekina ewune, ti hinoom ha hiti kíiti ya, pakati Ninew efikasiiŋo hátikin ekaay eyye nkáhin yo kíiti.” ");
INSERT INTO krx_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yéesu naapenanii hisoku: “An acaaŋanantoo lampi naayol yo niŋ fotom náawuf teyyo eheem. Pale nawaŋwaŋ yo ti esafu, ancuk an óo an éenakoonii naacuk ecaaŋ ya. ");
INSERT INTO krx_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ñíkini ñikina ñiyem lampi ya eti eniini. Niŋ ñíkini ñinapaa eniini púlooŋ lompo efeemeeŋ niŋ ecaaŋ. Niŋ ñinaput, eniini lompo neemeeŋ niŋ énimaan. ");
INSERT INTO krx_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ooto, tah kunuu ti ecaaŋ ya eeyem ya ti awe timpi eyeno énimaan. ");
INSERT INTO krx_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Niŋ eniini púlooŋ eemeeŋaa niŋ ecaaŋ, peetaakut la níme, efeeyeno púlooŋ ti ecaaŋ samat nii ecaaŋ lampi eecaaŋe cataŋ éeyayii ti awe.” ");
INSERT INTO krx_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yéesu ta naapaye ta káakup, Afalisaay naayonkaloo hili pateyoo. Apikaay, naanako naayeno hili. ");
INSERT INTO krx_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Afalisaay a ta naacuke ta nii Yéesu akuulanut sipeesoo apite ali, ínnimoo teyoo. ");
INSERT INTO krx_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ateeteyo naasokoo: “Aluu Pufalisaay pa, innikuulan tíkitaaŋ elontoŋ ya niŋ epulaatu ya, pale páhantuwa aluu innimeeŋ niŋ pálafi piti káalipu niŋ pakanc. ");
INSERT INTO krx_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Aluu pusoŋ pa! Fo Pútuun pa peememanoole pa tíkitaaŋ pikina tom lompo pimemanoole páhantuwa? ");
INSERT INTO krx_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Niwufan salaka weeyem wa lupo keeleke ka, ancuk aluu niŋ waah óo waah efinikuul. ");
INSERT INTO krx_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kúnuul efikiyeno ti aluu Pufalisaay pa, kaatuko inniwufanufan Pútuun pa himpaac ha heewase ha ŋaasuwan ti pamaañal pa pitaaluu, samat nii kanca, micempanu niŋ típaapikeen. Pale innifiil nii niñaŋaa piyeno keecoonoole ti pututa aluu niŋ pakan paka, ínnilafi Pútuun pa, ántuŋ hikina inniñaŋe íhinu peefiilut ukee wa. ");
INSERT INTO krx_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kúnuul efikiyeno ti aluu Pufalisaay pa, kamma ínnilafi piyeno ti kúkon ka keenape ka ti púluumuma pa, ínnilafi kapinkakicanee pinapnap ti kíliŋ ka. ");
INSERT INTO krx_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Kúnuul efikiyeno ti aluu, kaatuko innicukcuk nii kiyaak keetaakut lánkamaasi enka pakan nkakak tenko péemiit nii kakakaakak ti waah weekuulut.” ");
INSERT INTO krx_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Fiye, akee ti pikalaŋana hilim ha heesiiŋanee ha hiti Móyiis naasokoo: “Ahámpaatiin, naasokaa fiyaaw, unii lompo anteñale.” ");
INSERT INTO krx_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yéesu naañahanoo: “Aluu lompo pikalaŋana hilim ha heesiiŋanee ha, kúnuul efikiyeno ti aluu, kamma innitiyan pakan paka pitiyo peenapa líŋ, háati niŋ cisiik aluu coonool nílikantoo pitiyo pempuu. ");
INSERT INTO krx_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Kúnuul efikiyeno ti aluu, kaatuko innilutlut kiyaak ka kiti piyaamakoola pa, payenka símaama aluu nkamuke ka. ");
INSERT INTO krx_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Inníyisanyisan ti páhinal empuu nii nicoonaacoon eeha símaama aluu nkáhine ha, poko kamukale piyaamakoola pa, aluu ínniwalliyanool kiyaak ka kiteyii. ");
INSERT INTO krx_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ekina ewune Pútuun pa ti ecohato etempo mpusok: 'Inci fápoñiyii piyaamakoola niŋ pupoñapoñ. Efikamuk pakakee paka, nkakallan pakakee paka.' ");
INSERT INTO krx_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Fiyuu hísim ha hiti piyaamakoola pa púlooŋ heeniisiye ha kápiliŋ ti púcook púlunta pa, efihinaŋee ti hikaw ekaay eyye. ");
INSERT INTO krx_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Písikii ti hísim ha hiti Abel fo ti hísim ha hiti Sakaliya, eemukee ya ti ekumpaan ya enfakat ya eti Pútuun pa, ti pututa kaaciin ka niŋ la haŋee la kaasampan. Ee, inci pusok aluu, eehe fiye púlooŋ efihinaŋee ti hikaw ekaay eyye. ");
INSERT INTO krx_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kúnuul efikiyeno ti aluu pikalaŋana hilim ha heesiiŋanee ha, kaatuko innicoopcoop ékuluma ya eti káapankin hunkut ha hiti kameye ka. Aluu faŋ aluu ninakiit lupo, innikit kéelafiye ka pinako.” ");
INSERT INTO krx_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yéesu apiyeno hífulu ti ekumpaan ya, pikalaŋana hilim ha heesiiŋanee ha niŋ Pufalisaay pa kiiñii nkili meemak, nkayeniyoo kaakilincanool ti hícump pacakanoolal. ");
INSERT INTO krx_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Kápilafiyoo hikuucu ti eeha afaasok kati káyiniyoo hinooku teeho. ");
INSERT INTO krx_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ti oom caanak, pakan púwuli peemeeŋe nkaconcoolo fo nkakakalool. Yéesu náayaañ ápukup niŋ pinapana pa pakateyoo, naasok: “Níwasum leweñoo ya eti Pufalisaay pa, kamma neeyem écufato eyya nétif. ");
INSERT INTO krx_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Waah óo waah wéewufaloolee éfuuwufinee, waah óo waah weeyolee éfuumeyyee. ");
INSERT INTO krx_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ekina ewune eeha innisoke ha ti énimaan éfihisiyee ti hanakan palaw, eeha innipuusanoole ti kaanuu páhantuwa ékaap éfihituunanee ti kíliŋ ka.” ");
INSERT INTO krx_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yéesu nene asok: “Aluu pákawiyam, inci pusok aluu: Timpi nife payenka nkamuk ka enii ya ínfulaa toko étinekayini waah ti aluu. ");
INSERT INTO krx_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pale inci fáyisan aluu aŋa inniñaŋe ya hifeyu: Nife Pútuun pa, peeyem pa niŋ pipayaa himuku enii ya, pitaakaataak kayine kiti hiwantu aluu ti seemak. Ee, inci pusok ho aluu, pikina inniñaŋe hifeyu. ");
INSERT INTO krx_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Fo kanoomanantoo múculuculu isak, uhit úsupak? Pale háati coonool temmo Pútuun pa pifiilut. ");
INSERT INTO krx_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Háati wan wa weeyem wa ti hikaw aluu púlooŋ ufineefin. Timpi nife, nihaŋaahaŋ nafaa meemak múculuculu meemeeŋe.” ");
INSERT INTO krx_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yéesu nene asok: “Inci pusok aluu: An óo an eesayanaam hátikin pakan paka, inci, Añii An, lompo fasayanoo hátikin pumaleekoo pa piti Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pale an óo an eepookaam hátikin pakan paka, inci, Añii An, lompo fapookoo hátikin pumaleekoo pa piti Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","An óo an eesoke heenaput ti inci, Añii An, áfaayiniyee kaaponket, pale an óo an eeteñale Kunuu ka keenape ka ataponketee. ");
INSERT INTO krx_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Niŋ kacoopaa aluu ti sempe ti púluumuma pa íhinu aluu kíiti, niŋ fotom nkacoop aluu hátikin ñíhampaatiin ña niŋ ti pakati kayine ka, timpi niwasoolo kúnuul fa innikaakaay káakup kati nifak niŋ fotom eeha innikaakaay hisoku, ");
INSERT INTO krx_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","kaatuko Kunuu ka keenape ka efikikalaŋan aluu ti oom caanak eeha inniñaŋe hisoku.” ");
INSERT INTO krx_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yéesu ti káakup ka, akee ti kayoŋ ka naasokoo: “Ahámpaatiin, sok atoom a úpaacinool hitaaku ha eeha paapaa atoonii naakate ha unii.” ");
INSERT INTO krx_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yéesu naañahanoo: “Awíyam, ayme asiiŋanaam áhina kíiti niŋ fotom aŋa akaakaay aluu káapaacinool hitaaku ha hitaaluu?” ");
INSERT INTO krx_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Púful toko, naasokii: “Nisiiŋo púsooni! Nitah kunuu, timpi niŋes kaaconcenool hitaaku, kaatuko eloŋ an eneetaat ti hitaaku ha hiteyoo, háati nihifom.” ");
INSERT INTO krx_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Naasokii hícantiitu eehe: “Taakaataak usaanum áyiin eetaake etaam eepuke meemak. ");
INSERT INTO krx_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Naacakanoolo: 'Puume inci iññaŋe íhinu? Kaatuko taakut la famank aŋa inci inkaakaay ya émaañii.' ");
INSERT INTO krx_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Naasok: 'Fiye inci inkaakaay íhinu. Fahancalool mileefaan ma mutoom, illut ñenfakat, la faconcenool púlooŋ aŋa inci inkaakaay ya émaañii niŋ hitaaku ha hitoom. ");
INSERT INTO krx_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Inci fasokoolo: \"Awíyam, yékunoolo, hitaaku ha hitii hiti sitiil seemeeŋe, li, illaan, iyyeno ti eloŋ éesuume meemak.\"' ");
INSERT INTO krx_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pale Pútuun pa mpusokoo: 'Awe esoŋ eyyuu! Hánant eehe aafaket. Fiye, ayme afaacoop aŋa anconcenoole ya púlooŋ?'” ");
INSERT INTO krx_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yéesu naapenan apusokii: “Eehe efihitaako an aŋa naconcenool hitaaku hiti faŋoo apan ataakut waah hátikin Pútuun pa.” ");
INSERT INTO krx_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Púful toko, Yéesu naasok pinapana pa pakateyoo: “Eehe hiwune inci insok aluu, timpi niwasoolo kúnuul ti eloŋ ya etaaluu, ti waah ewwa efinili, niŋ fotom ti sinii aluu, waah ewwa éfinisoolo. ");
INSERT INTO krx_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kaatuko eloŋ ya ehaŋaahaŋ paliyal, enii ya neehaŋ pásooliyal. ");
INSERT INTO krx_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nisincan pusuwa pa: pusukantoo, pumaañantoo, pitaakut káamankuma niŋ ekina tom pileefaan, pale Pútuun pa mpúkuuman-kúuman po. Ñiyema puume innihaŋe nafaa pusuwa pa? ");
INSERT INTO krx_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ayme ti aluu, ti ewasoolo kúnuul, ayina kapenan esuuŋut ti eloŋ ya eteyoo? ");
INSERT INTO krx_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Páawoo niyinaat fala íhinu waah wa wenkilis wa ewwe, weyme efiniwasoolo kúnuul ti ukee wa? ");
INSERT INTO krx_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Nisincan fa híliilii ha nihiŋant fa. Ihínantoo piseeñ niŋ ekina tom hiliilantoo. Pale inci pusok aluu, háati amansa ya Solomon niŋ hisaanumate ha hiteyoo fiye púlooŋ ásankinantoo samat nii hikina. ");
INSERT INTO krx_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Niŋ Pútuun pa púsoolaa fiyuu káaheeni enkuu, keeyem ka le fíyooy, kacom nkuwantee ti seemak, faala aluu, puume conko étipusool aluu? Aluu pakati káyinan keefomut! ");
INSERT INTO krx_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Timpi niŋes waah ewwa efinili, innilaan; timpi niwasoolo kúnuul. ");
INSERT INTO krx_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kaatuko keeneetaat ka Pusuwif, poko nkaŋes waah ewwuu. Pale Pútuun pa Paapaa ti aluu, pímeyimeyi nii nisoolahaa-soolah wo. ");
INSERT INTO krx_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Haŋa panap nipiŋes cáwii etempo, ínnihinaa fo, waah ewwe púlooŋ efuuwufanee aluu. ");
INSERT INTO krx_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Aluu cikoolee ca citoom, timpi nife, kaatuko Paapaa ti aluu súumoosuum kati awufan aluu cáwii etempo. ");
INSERT INTO krx_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ninooman hitaaku ha hitaaluu, ínnifulan ho salaka ti keeleke ka. Nimemanoolo émankuma mañ éepuciyantoo. Inniconcenool hisaanumate ha hitaaluu alacana la étihicim, la innimeya la nii pílipa étikayini hikolu, cemmek lompo etecok. ");
INSERT INTO krx_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kaatuko la hisaanumate ha hitaaluu nihiyem, toko lompo saan aluu insiyem.” ");
INSERT INTO krx_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yéesu nene asok pinapana pa pakateyoo: “Niyeno niŋ wañ uti páhin, innikat pilampi pa pitaaluu pipicaaŋ. ");
INSERT INTO krx_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Níhin samat nii pakan keeyem ti hítuulu éñohoonii ya eti áhampaatiin a ateyii, loho akaayaa pahaaño piti pinimo. Niŋ pácolaliyoo naawenken, nkápankinoo putum pa. ");
INSERT INTO krx_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pimiikan pa payenka áhampaatiin a naakaakaay ka étookii kaasincan niŋ ácoliyoo éfikanapiyanee. Pánipani, inci pusok aluu: Afáawasoonii wañ uti páhin naayenanii nantoonool naawufanii kapili. ");
INSERT INTO krx_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Iyyema ákeyyoo mpisit niŋ fotom nuulap, náatookiyii kaasincan, éfikanapiyanee. ");
INSERT INTO krx_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Pale nímeyi eehe, niŋ ati ekumpaan ya ameya teyme álipa ya naakaakaay ékey, atakat ekumpaan ya eteyoo epihaatee. ");
INSERT INTO krx_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Aluu lompo nisiiŋo púsooni kaatuko inci, Añii An, éfikey ti waati eyya étinininkoolam.” ");
INSERT INTO krx_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Fiye, Piyeer naacakan Yéesu: “Ahámpaatiin, unii uwune ansok hícantiitu eehe fo hiti pakan paka púlooŋ?” ");
INSERT INTO krx_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ateeteyo naañahanoo: “Ayme ayem amiikan a eehintiyee ya, naacohato, aŋa áhampaatiin a naañomane páhin pa piti ekumpaan ya kati ápaacinool paliyal pa pakakee pimiikan pa niŋ caanak ca cítuuniyaa? ");
INSERT INTO krx_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Amiikan a aŋuu, niŋ áhampaatiin a áñohooniyoo náatookiyoo ti oom páhin, áfaanapiyanee. ");
INSERT INTO krx_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Inci pusok aluu pánipani ya, afaañomanoo hitaaku ha hiteyoo púlooŋ. ");
INSERT INTO krx_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pale niŋ amiikan a aŋuu asokooliyaa: 'Ahámpaatiin a atoom áfiisut éñohoonii,' fiye náayaañ hisapu pimiikan pa pákayiin paka niŋ pakaal paka, naayeno hili, pálaani fo ákuman. ");
INSERT INTO krx_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ahámpaatiin a ati amiikan a aŋuu áfaañohoonii ti hinoom eeha náaninkoolutee ha niŋ ti waati eyya náamiit. Afaakallan meemak amiikan a aŋuu, naayenanoo pati keehintiitee ka. ");
INSERT INTO krx_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Amiikan a aŋa eemeya ya eeha áhampaatiin a ateyoo náalafiye ha amemanooliit, áhinut ho afaasapee meemak. ");
INSERT INTO krx_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pale amiikan a aŋa éemiit ya eeha áhampaatiin a ateyoo náalafiye ha, náahin heewune kati asapee, afaasapee caahinkiŋ. An óo an aŋa nkawufane meemak afaañaakee meemak, an óo an aŋa nkañomane meemak afaahaŋee hiñaaku.” ");
INSERT INTO krx_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yéesu nene asok: “Inci kéyyookey écoopii seemak ti púlunta pa, íllafi sipince sicok. ");
INSERT INTO krx_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pale taakaataak pátise eyya inci iññaŋe hisayu, kúnuul unka ti inci taamanta epayut. ");
INSERT INTO krx_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Cukaacuk aluu nii kásuumaay inci íncoopii t’etaam? Haani, inci pusok aluu, pale píkatinool. ");
INSERT INTO krx_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Písik fíyooy, miin miti pakan isak éfimikatinool, pákahaaciil efikapook pákasupak, pákasupak efikapook pákahaaciil. ");
INSERT INTO krx_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Efíkakatinool, paapaa afaapook añiinoo akampaani, akampaani afaapook paapaa ateyoo; íññaa afaapook añiinoo ámaacul, ámaacul afaapook íññaa ateyoo; íññaa afaapook añiinoo aaloo, añiinoo aaloo afaapook aasonoo aal.” ");
INSERT INTO krx_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yéesu naasok lompo kayoŋ ka: “Niŋ nicukaa káatiŋu nkúfulii pa caanak ca incinow pa, innihaaŋ ti hisoku 'éfeenupii', apan nihitaako. ");
INSERT INTO krx_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Fo lompo incuke, niŋ eyam ésapiyoo ti kikee kaapii, innisok 'éfisowi', nihitaako. ");
INSERT INTO krx_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Aluu ñícuf! Níyiniyini kameye heekaakaay pitaako niŋ nisincanaa patiila niŋ t’etaam. Weyme uwune niyinaat hicuku heeyem ha aluu ti kaaposool ti caanak ence, kati nímeyi heekaakaay ha pitaako? ");
INSERT INTO krx_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Fiye, weyme uwune aluu faŋ aluu nikiiwantoo heenape ha? ");
INSERT INTO krx_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Niŋ akamooli ayeniyuu hicoopu ti áhina kíiti, ti pítin pa hín kata nipiteŋenool kati nísiyool, niŋ ekina tom afaacoopi ti sempe ti áhina kíiti ya, áhina kíiti ya naawufani ati éwuulu ya, ati éwuulu ya naakuli. ");
INSERT INTO krx_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Inci pusoki, áatifulii ti núkuluma ennuu awe peecooyut kaahit ka kikelan ka.” ");
INSERT INTO krx_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ti oom caanak, pakan nkákey kakaman Yéesu fa Pilaat náahine kapumuk pakakee pakan pakati Galilee, ta nkayeniye ta kaawaaseen kiti Pútuun. ");
INSERT INTO krx_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yéesu naañahanii: “Pakati Galilee payenkuu, fo cukaacuk aluu nii poko kahaŋa kaamuuyen pakakee pakati Galilee kamma nkamukee fiyuu? ");
INSERT INTO krx_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Haani, inci pusok aluu, pale niŋ níwunkiit umuuyen wa utaaluu, aluu lompo púlooŋ efiniket. ");
INSERT INTO krx_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Niŋ fotom pakan paka kaat ya niŋ pákahaaciil paka payenka ekumpaan ya eehaane ya eti Silowam neenowe ya teyii neemukalii, cukaacuk aluu nii kahaŋa kaamuuyen pakati Jerusalem? ");
INSERT INTO krx_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Haani, inci pusok aluu, pale niŋ níwunkiit umuuyen wa utaaluu, aluu lompo púlooŋ efiniket.” ");
INSERT INTO krx_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Fiye, Yéesu naasokii hícantiitu eehe: “Akee áyiin ataake kaakit naasuk tenko sootoo. Naakaay hiŋes papukal eteyyo ataakut. ");
INSERT INTO krx_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Naasok áhina ya ateyoo: 'Sincan, sitiil síhaaciil unse nii inci kéyyoo hiŋes papukal ti enuun eyye taakantoo. Fiit yo! Etaakut nafaa weyme efeesiiŋo ti etaam eyye kenseŋ?' ");
INSERT INTO krx_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pale áhina ya naañahanoo: 'Ahámpaatiin, túul yo etiil eyye, inci pícikisool ti sipat eteyyo uwwas yo campanti, ");
INSERT INTO krx_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","manti epuk niŋ ekina tom pulay impoñ kapifiit yo.'” ");
INSERT INTO krx_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ti hinoom hiti kayeno hiti Pusuwif pa, Yéesu naayeno kakalaŋan ti ekee éluumuma. ");
INSERT INTO krx_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Intaako toko aal aŋa hísaalumant níhihutane fo sitiil kaat niŋ síhaaciil (18). Náaŋuho ayinantoo ésaalino fo acoonool ciit. ");
INSERT INTO krx_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yéesu ta naacukoo ta náayonkaliyoo hátikinoo naasokoo: “Aal, aayihaa ti káakuuñu ka kitii.” ");
INSERT INTO krx_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Naalemp sipeesoo teyoo, tokotoko aal a náasaalino apucoonool ciit, naayeno hímulu Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pale, áhampaatiin a ati éluumuma ya, apucuk eehuu inseeñoo ti Yéesu kamma náakuuñane ti hinoom ha hiti kayeno ka. Naacoop hilim ha, naasok kayoŋ ka: “Kunoom isak niŋ hoonool kiñaŋee páhin tenko. Ooto níkey ti oom kunoom nípikuuñanee, pale ti hinoom ha tom hiti kayeno ka.” ");
INSERT INTO krx_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ateeteyo naañahanoo: “Aluu ñícuf! Fo an óo an ti aluu, ákopinantoo híciinoo niŋ ekina tom fáliyoo ti káahoonanuma apucoop yo kaalaanan ti hinoom ha hiti kayeno ka? ");
INSERT INTO krx_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Fiye, aal aŋe ati miin ma miti Abraham, aŋa Seetaani neenakiye fo sitiil kaat niŋ síhaaciil (18) púmpuluŋ, fo añaŋutee kafakan ti káakuuñu enke ti hinoom ha hiti kayeno ka?” ");
INSERT INTO krx_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ta naasoke ta enke, keepookoo ka nkameeŋ niŋ ñusuu, pale kayoŋ ka nkiyeno ti pásuuma kamma heenape ha henfakat ha púlooŋ eeha Yéesu náahine ha. ");
INSERT INTO krx_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Púful toko, Yéesu naasok: “Cáwii ca citi Pútuun pa niŋ weyme incinakoole? Niŋ weyme inci fakufumool co? ");
INSERT INTO krx_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Cinakoolaa-nakool nii ekoon sootoo eyya an naacoope naasuk yo ti kaakit ka kiteyoo. Néeŋantii fo éyenoonii enuun, pusuwa pa mpúwuun ti unaay eteyyo.” ");
INSERT INTO krx_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yéesu nene asok: “Niŋ weyme inci fakufumool cáwii ca citi Pútuun pa? ");
INSERT INTO krx_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Cinakoolaa-nakool nii leweñoo eyya aal naacoope naanakanool yo niŋ efol eemeeŋe, fo hímaaf ha púlooŋ híkuntii.” ");
INSERT INTO krx_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yéesu ti pikaayu pa Jerusalem naasiiŋo ti pisaatee pa niŋ misaatee ma apiyeno kakalaŋan. ");
INSERT INTO krx_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Akee naacakanoo: “Ahámpaatiin, fo pakan caahinkilis lamma efikafakanee?” Yéesu naañahanii: ");
INSERT INTO krx_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Níhin kata nipinako ti putum pa peekoke pa, kaatuko inci pusok aluu, pakan keemeeŋe efikaŋes pinako étikayini. ");
INSERT INTO krx_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Niŋ ati ekumpaan ya ayitiyaa naapank putum pa, aluu tíkitaaŋ, éfinicook kaawenken hunkut ha innisok: 'Ahámpaatiin, pánkin unii,' pale náañahanii: 'Inci míit peyme ínnifulii!' ");
INSERT INTO krx_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Fiye, efinisokoo: 'Unaa uyeniyaa hili niŋ pálaani nantoonool, ayyeno kakalaŋan ti kíliŋ ka kutoonii.' ");
INSERT INTO krx_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pale afaasok aluu: 'Inci míit peyme ínnifulii! Nílaaŋam aluu payenka ínnihin ka heenaput ha!' ");
INSERT INTO krx_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Niŋ nicukaa Abraham, Isaak, Jakob niŋ piyaamakoola pa púlooŋ ti cáwii ca citi Pútuun pa, efinikooŋ innifincal úŋiiŋ aluu kamma inniwantee tíkitaaŋ. ");
INSERT INTO krx_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pakan éfikafulii ti púlunta pa púlooŋ, kápikey hili ha henfakat ha hiti cáwii ca citi Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nísiitan, pakakee paka kéekelanii ka efikayeno hátikin, pakakee paka keeyem ka hátikin éfikakelanii.” ");
INSERT INTO krx_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ti oom caanak, pakakee Pufalisaay nkákey ti Yéesu nkasokoo: “Fúl le aapikaay lakeenaay kaatuko Helot Antipas álafiyuulafi himuku.” ");
INSERT INTO krx_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yéesu naañahanii: “Nikaay canisok cipampaŋo ceekance encuu nii: 'Inci oopa ti hiyaanu kísaalumant, ínkuuñan pakan paka kéekuuñe ka fíyooy niŋ kacom, hinoom ha híhaaciyenu ha inci fapa páhin pa putoom.' ");
INSERT INTO krx_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Fan óo fan incuke fo inci muus pítinam fíyooy, kacom niŋ tanta, kaatuko ayaamakoola ayinaatee himuku pikee niŋ neetaat Jerusalem. ");
INSERT INTO krx_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Oo Jerusalem, Jerusalem aluu payenka innimukal ka piyaamakoola pa inninunkal payenka Pútuun pa mpúpoñii ka ti aluu, ñiyema puume íllafiye kati concenool epuuk aluu nantoonool samat nii fa ekutoon neconcenool fa mufuun eteyyo ti úpitu eteyyo. Pale nicoonut! ");
INSERT INTO krx_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nísiitan, ekumpaan ya etaaluu efeekatanee. Ee, inci pusok aluu, etinene nicukam fo hinak ta efinisok ta: 'Alímaati Ateeteyo Pútuun pa pisampan éekeyii ya ti caacaw etempo.'” ");
INSERT INTO krx_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ti hinoom hiti kayeno, Yéesu naanako ti ekumpaan eti akee ti ñíhampaatiin Pufalisaay pa hili. Keeyeniye ka toko nkasincan teyoo. ");
INSERT INTO krx_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Fiye, áyiin eetaake káakuuñu kiti hanaay sipees niŋ woot naayeno hátikinoo. ");
INSERT INTO krx_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yéesu naacakan Pufalisaay pa niŋ pikalaŋana hilim ha heesiiŋanee ha hiti Móyiis: “Cooneecoon fo kiteekit káakuuñan ti hinoom ha hiti kayeno ka?” ");
INSERT INTO krx_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pale kañahanutoo. Náalik áyiin a aŋa éekuuñe ya náakuuñanoo, apipa, naasokoo ayet. ");
INSERT INTO krx_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Fiye, naasokii: “Niŋ akee ti aluu añiinoo niŋ fotom híciinoo kanowaa ti ésaapun, fo átafulaniyii mpacas ti hinoom ha hiti kayeno ka?” ");
INSERT INTO krx_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kayinaatoo kañahan teeho. ");
INSERT INTO krx_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Púful toko, Yéesu naacuk kéeyonkaliyee ka hili ti kamamal kúkon ka kiti hátikin, naasokii hilim eehe: ");
INSERT INTO krx_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Niŋ kayonkaluu pahaaño piti pinimo timpi yeno ti híkon ha hiti hátikin ti kafeyatan an eehaŋuu nafaa náayonkaliyee, ");
INSERT INTO krx_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","niŋ eehuu hitaakiyaa, aŋa éeyonkalii ya aluu púlooŋ, áfaakey ti awe, naasoki: 'Ufan híkon ha hitii áyiin a aŋe.' Fiye, niŋ ñusuuwi aafakaay iyyeno ti híkon ha hiti puson. ");
INSERT INTO krx_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Pale niŋ kayonkaluu, yeno ti híkon ha hiti puson, ancuk niŋ aŋa éeyonkaliyuu ya hili acukuu, naasoki: 'Awíyam, kéy yeno hátikin.' Fiye, áafanapiyanee hátikin kéeyonkaliyee ka púlooŋ. ");
INSERT INTO krx_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kaatuko an óo an eesilanooliye áfaawananiyee, an óo an eewananooliye afaasilanee.” ");
INSERT INTO krx_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yéesu naasok eeyonkaloo ya: “Naayikaa kawaay niŋ fotom káciim, timpi yónkalii pákawiyi, pakatuwi tom, miin ma mitii tom niŋ ekina tom pikinooli tom keetaake ka. Náahinaa fo efi lompo kayonkali hili nkánukani. ");
INSERT INTO krx_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pale naayeniyaa kawufan hili henfakat yónkalii keeleke ka, kéehute ka, payenka nkanow ka niŋ efank, kéefuume ka. ");
INSERT INTO krx_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Etíkayiniyi ho kañahan, pale Pútuun pa éfipinapiyani, mpiñahani ho ta keecoonoole ka nkakaakaay ta élitoonii ti eket ya.” ");
INSERT INTO krx_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ti hili eehuu, akee ti keeyeniye ka toko, ápisi eeha Yéesu naayeniye ha hisoku, naasokoo: “Pásuuma efipiyeno ti aŋa eekaakaay ya hili pati cáwii ca citi Pútuun pa!” ");
INSERT INTO krx_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yéesu naañahanoo niŋ hícantiitu eehe: “Taakaataak akee áyiin eememanoole hili henfakat naayonkal hícump pakan. ");
INSERT INTO krx_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ta hili ha níhituuniye ta naapoñ amiikan a ateyoo, ápikaakupii niŋ keeyonkalee ka hili nii: 'Níkey, hiik ha hipayaa.' ");
INSERT INTO krx_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pale poko púlooŋ nkáyaañ kaluum kaaponket. Ayáañ a naasokoo: 'Féefiye inci innoome kaakit, fo inci kaay hicuku etenko, sokoo aponketam.' ");
INSERT INTO krx_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Akee ya naasokoo: 'Féefiye inci innoome kíciin ŋaasuwan kiti piya, kikina inci iyyem fiye ti pikaayu hiyoopu, sokoo aponketam.' ");
INSERT INTO krx_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Akee lompo naasokoo: 'Féefiye inci insaye aal, ekina ewune étiyini ékey.' ");
INSERT INTO krx_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Amiikan a apuñoho, naakaman áhampaatiin a ateyoo eeha pakan paka nkásokiyoo ha. Fiye, ati ekumpaan ya, ta náasiye ho ta, náañiken, naasokoo: 'Kaay mpacas ti kíliŋ ka niŋ ñítin ña ñiti saatee ya cóopii keeleke ka, kéehute ka, kéefuume ka niŋ payenka nkanow ka niŋ efank.' ");
INSERT INTO krx_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Amiikan a apipa ho íhinu, naasokoo: 'Ahámpaatiin, eeha ansoke ha híhineehin pale fo fiye ekumpaan ya emeeŋut.' ");
INSERT INTO krx_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ahámpaatiin a naasok amiikan a ateyoo: 'Kaay ti mítin ma niŋ kanaac kíkinku ka cóopiyii kápinakoonii, eeha efihiwun ha ekumpaan ya etoom neemeeŋ. ");
INSERT INTO krx_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Inci pusok aluu: Háati akee ti kéeyonkaliyee ka hínum, atasiikan ti hili ha henfakat ha hitoom.'” ");
INSERT INTO krx_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Fiye, kayoŋ kenfakat nkiyeno pinapool niŋ Yéesu. Náayesoonii lipe teyii, naasokii: ");
INSERT INTO krx_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Niŋ an ákeyyoo ti inci, ayinaat piyeno anapanayam taamanta álafiitam pihaŋ faafoo niŋ íññaa ateyoo, pihaŋ aaloo niŋ epuukoo, pihaŋ ñúnuwoo niŋ pakatuwoo niŋ pakahoopoo, niŋ lompo eloŋ ya eteyoo. ");
INSERT INTO krx_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Aŋa eecoonutam kanapan fo álafi eket ti kuluwaa, oom an ayinaat piyeno anapanayam. ");
INSERT INTO krx_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Fo niŋ akee ti aluu álafiyaa kulut ekumpaan eehaane, átayaañ ayeno apifin mañ emma naakaakaay káfulan manti míyini hipayu oom páhin? ");
INSERT INTO krx_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Niŋ ekina tom afaatah yo átayini yo hipayu, pakan paka keekaakaay ka hicuku eteyyo nkalenkenoo, ");
INSERT INTO krx_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","nkasok: 'Sincan, aŋe áyaañe kulut ekumpaan, ayinaat yo hipayu.' ");
INSERT INTO krx_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Fo lompo incuke, niŋ amansa ayeniyaa pikaayu hikam niŋ akee amansa, fo átayaañ ayeno apisincan man niŋ síwuli ŋaasuwan (10,000) áfaayini kátaakoolan eeyem ya ti ékey niŋ síwuli áwii (20,000)? ");
INSERT INTO krx_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Niŋ ameya nii átayini, aŋa naaloŋ náalaaŋe afaapoñ pakan kaluum púsuumool. ");
INSERT INTO krx_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ti páhinal pa poonool puu, an óo an ti aluu ayinaat piyeno anapanayam taamanta akatanut waahoo púlooŋ. ");
INSERT INTO krx_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Micempanu minapaanap, pale niŋ míyitanaa, puume pasampe etemmo efipiñahanee? ");
INSERT INTO krx_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Minaput ti etaam ya, minaput lompo campanti, efimuwantee. An óo an eetaake kaanuu kiti káasiitan, ásiitan.” ");
INSERT INTO krx_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Hikee hinoom, hícump pisayoola kúncoo niŋ pumuuyena nkálohii Yéesu káasiitanoo. ");
INSERT INTO krx_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pufalisaay pa niŋ pikalaŋana hilim ha heesiiŋanee ha hiti Móyiis nkayeno káakumutool kapusok: “Ayíin aŋe nawananwanan pumuuyena pa naali neyii.” ");
INSERT INTO krx_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Fiye, Yéesu naasokii hícantiitu eehe: ");
INSERT INTO krx_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Niŋ akee ti aluu ataakaa sísaacii keme (100), yoonool néecim, fo atakat áwii epaakiil niŋ kaat niŋ sipaakiil sa (99) ti káahoonanuma, apikaay hiŋes yoonool ya éecime ya fo álaŋanii yo? ");
INSERT INTO krx_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Niŋ álaŋaniyoo yo, niŋ pásuuma áfaakantoonii yo ");
INSERT INTO krx_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","naayet t’enuuf. Púful toko naayonkal pákawiyoo niŋ pikinooloo nantoonool naasokii: 'Níkey, ninanf ti pásuuma pa putoom, kamma inci íllaŋanii sáacii ya etoom yoonool ya éecime ya.' ");
INSERT INTO krx_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Inci pusok aluu: Fo lompo incuke, pásuuma efipiyeno ti keeyem ka alacana niŋ amuuyena oonool áwunkiyaa umuuyen wa uteyoo, pihaŋ áwii epaakiil niŋ kaat niŋ sipaakiil sa (99) keecoonoole ka kasoolahut púwunko umuuyen wa uteyii.” ");
INSERT INTO krx_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yéesu naapenan hisoku: “Moonool muu, niŋ aal ataakaa sikoofali ŋaasuwan, yoonool néecim, fo atacaaŋan lampi, naaneeŋ ekumpaan ya naaŋes yo niŋ kunuu fo alaŋan yo? ");
INSERT INTO krx_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Niŋ alaŋanaa yo áfaayonkalii pákawiyoo niŋ pikinooloo nantoonool naasokii: 'Ninanf ti pásuuma pa putoom, kamma inci íllaŋanii koofali ya etoom éecime ya.' ");
INSERT INTO krx_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Inci pusok aluu: Fo lompo incuke, niŋ amuuyena oonool áwunkiyaa umuuyen wa uteyoo, pásuuma efipiyeno ti pumaleekoo pa piti Pútuun pa.” ");
INSERT INTO krx_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yéesu nene asok: “Taakaataak áyiin eetaake epuuk pákasupak. ");
INSERT INTO krx_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kahiineen ka nkusok faafoo: 'Paapaa, ufanam putumam ti hisaanumate ha eeha inci iññaŋe ha hitaaku nampi ketaa.' Fiye, paapaa ya náapaacinool hitaaku ha hiteyoo epuukoo. ");
INSERT INTO krx_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Fiyiit kahiineen ka naanooman putum pa piteyoo púlooŋ naakaay ti mah méelaaŋe. Náapucalool po mañ ma miteyoo ti eloŋ eenaput. ");
INSERT INTO krx_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Apipa káapucalool aŋa naataake ya púlooŋ, épankul enfakat néenakoonii ti mah ma púlooŋ, náayaañ palek. ");
INSERT INTO krx_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Naakaay hiŋes páhin, akee áyiin ati oom mah naacoopoo, naapoñoo káakuuman pícalukun ti etaam ya eteyoo. ");
INSERT INTO krx_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Náalafi kaasiitan faŋoo niŋ paliyal empa pícalukun pa mpiyeniye pa hili pale an awunutoo waah. ");
INSERT INTO krx_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Fiye, ápuñohoonii ti kunuuwoo, naasokoolo: 'Píhina kayema puume pakati paapaa atoom payenka nkali fo nkatowan, inci íyyemi le ti eket niŋ peep. ");
INSERT INTO krx_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ooto, inci fañoho pati paapaa atoom inkaasokoo: \"Paapaa, inci muuyenaamuuyen ti Ateeteyo ati alacana niŋ ti awe. ");
INSERT INTO krx_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Fiye, inci túuniit piyonkalee añiini, cokam samat nii akee ti píhina pa pakatii.\"' ");
INSERT INTO krx_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Púful toko, añii ya naalito, naañoho pati faafoo. Mpálempaliyoo, faafoo naaŋantanoo inketoo teyoo ti hikaw meemak. Naatey apipaakoolanoo naaŋoonoo, naasumpooloo. ");
INSERT INTO krx_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Añii ya naasokoo: 'Paapaa, inci muuyenaamuuyen ti Ateeteyo ati alacana niŋ ti awe. Fiye, inci túuniit piyonkalee añiini.' ");
INSERT INTO krx_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pale faafoo naasok pimiikan pa pakateyoo: 'Nihiliikan! Nícoopii hísool ha heehaŋe ha pawalle ínnisooloo ho, inniŋaamoo ekop ti hisiik, inniwasoo pisamata. ");
INSERT INTO krx_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Innícoopii cíciin ca ceehaŋe ca pafom nipimuk upuliyaa nuuhaañiyaa. ");
INSERT INTO krx_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kamma añiinam aŋe naakete, náañohoonii ti eloŋ; náacim, naalaŋanee.' Nkáyaañ pahaaño. ");
INSERT INTO krx_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ta eehe nihitaakiye ta añiinoo áhampaatiin a náaloŋii ti kaakit. Ti éñohooniyoo ápulohanii ekumpaan ya náasi páyifal niŋ pakiiyal. ");
INSERT INTO krx_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Naayonkal akee ti pimiikan pa, naacakanoo: 'Weyme utaakiye le?' ");
INSERT INTO krx_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Amiikan a naañahanoo: 'Atuwi áñohoonii, paapaa atii naamuk cíciin ca ceehaŋe ca pafom kamma náañohoonii kásuumaayoo.' ");
INSERT INTO krx_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Fiye, añii ya áhampaatiin a hiiñoo nihili, naapook pinako ti ekumpaan ya. Paapaa ateyoo náafulii, naamaaneenakoo apinako ti ekumpaan ya. ");
INSERT INTO krx_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pale naasok paapaa ateyoo: 'Síitan! Sitiil ense púlooŋ inci yemuu ti páhin péelaacinut hilimi. Pale háati cifil aataapala wunam pahaaño niŋ pákawiyam. ");
INSERT INTO krx_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pale añiini aŋe, ápuñohoonii, akina aŋa éepucaloole ya hitaaku ha hitii ti púmaacul keenaput, ammukoo cíciin ca ceehaŋe ca pafom!' ");
INSERT INTO krx_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Paapaa ateyoo naasokoo: 'Añiinam, hinak óo hinak awe oopa le niŋ inci, waah óo waah utoom, utii. ");
INSERT INTO krx_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pale atuwi aŋe aketaaket, náañohoonii ti eloŋ; náacim, naalaŋanee. Ekina ewune uñaŋaa pahaaño niŋ hitaaku pásuuma.'” ");
INSERT INTO krx_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Fiye, Yéesu naasok pinapana pa pakateyoo: “Ayíin usaanum ataake áhina eeyeniye ati hikaw ha hiti páhin pa piteyoo. Pakan nkákey kapusok usaanum a nii áhina ya ateyoo, pahaaño niŋ hisaanumate ha hiteyoo naayaake. ");
INSERT INTO krx_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Naayonkaloo naasokoo: 'Eeheyme inci ínsi nkákup kitii? Finam waah wa wéenakoonii wa niŋ wéefule wa, kaatuko áatineeyini piyeno ati hikaw ha hiti páhin pa putoom.' ");
INSERT INTO krx_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ahína ya naasokoolo: 'Páawoo áhampaatiin a atoom áfaafulanam ti páhin pa putoom, puume inci iññaŋe íhinu? Taakut sempe siti piya, suuwaasuu lompo kaaluumatool. ");
INSERT INTO krx_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Méyimeyi fa inci inkaakaay íhinu, ancuk niŋ inci púulaa páhin pa putoom pakan paka nkawananam lateyii.' ");
INSERT INTO krx_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Naayonkal oonool oonool ti keetaake ka nikopu ti áhampaatiin a ateyoo. Naacakan áyaañ a: 'Puume ayyekane áhampaatiin a atoom?' ");
INSERT INTO krx_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Naañahanoo: 'Kilampasaan keme kiti lúuliin.' Ahína ya naasokoo: 'Sa kaahit ka kéeyisane ho ka, yeno mpacas inkiic áwii ésupak niŋ ŋaasuwan (50).' ");
INSERT INTO krx_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Apipa, naacakan akee: 'Puume ayyekane áhampaatiin a atoom?' Naañahanoo: 'Sipootak keme siti uli.' Naasokoo: 'Sa kaahit ka kéeyisane ho ka, yeno inkiic áwii epaakiil (80).' Fiye, náahin fo ti an óo an eeyekane áhampaatiin a ateyoo nikopu. ");
INSERT INTO krx_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Púful toko, áhampaatiin a náamul áhina ya eecoonoolut a kamma náahine ho niŋ pasuuse. Kaatuko payenka nkanapan ka énimaan ya eti púlunta empe kahaŋa pasuuse pakati ecaaŋ ya eti Pútuun pa ti waah ewwa nkáhin wa ti pututayii.” ");
INSERT INTO krx_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yéesu nene asokii: “Inci pusok aluu: Hisaanumate ha hitaaluu hiti púlunta empe, nicoop ho kati nitaak pákawi, ancuk niŋ hipayaa, innisayanee ti úyenuma wa uti eket maamaa. ");
INSERT INTO krx_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“An eehintiyee niŋ waah wenkilis afaahintiyee lompo niŋ waah wenfakat, an eecoonoolut niŋ waah wenkilis, atacoonool niŋ waah wenfakat. ");
INSERT INTO krx_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Niŋ nicoonoolut niŋ hisaanumate ha hiti púlunta empe, ayme afaañoman aluu hisaanumate ha hiti pánipani ya? ");
INSERT INTO krx_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Niŋ nicoonoolut niŋ hisaanumate hiti an, ayme afaawufan aluu hisaanumate ha hitaaluu? ");
INSERT INTO krx_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Amiikan ayinaat páhin ti ñíhampaatiin pákasupak. Afáalafi oonool a naanat akee ya, niŋ ekina tom naacok piliit oonool a naapook akee ya. Niyinaat ti coonool kaalehanool káyinan Pútuun pa niŋ pálafi mañ.” ");
INSERT INTO krx_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ta Pufalisaay pa nkásiye ta enke púlooŋ nkalenken Yéesu kamma nkálafiye mañ. ");
INSERT INTO krx_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yéesu naasokii: “Aluu ínniyisanyisan pucoonool pa pitaaluu ti ñíkin pakan paka, pale Pútuun pa pímeyimeyi heeyem ha ti saan aluu. Kaatuko eeha pakan paka nkacoke ha nii ihaŋa hitaaku nafaa, Pútuun pa pinataanat ho.” ");
INSERT INTO krx_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yéesu nene asok: “Kilim ka kiti Móyiis niŋ kiti piyaamakoola pa kisiiŋanee-siiŋan fo ti caanak ca citi Saŋ-Patis. Písik ti oom caanak ekooŋan ya éesuume ya eti cáwii ca citi Pútuun pa neeyeniyee ti káatuunan. Fiye, an óo an oopa ti íhinu kata kati anako. ");
INSERT INTO krx_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Patiila niŋ t’etaam efikahaŋ pacas hícimu cilim ca ceehaŋe ca káafomaati ti hilim ha heesiiŋanee ha hiti Móyiis. ");
INSERT INTO krx_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ayíin óo áyiin éefulane aaloo naasa akee aal, ti pahaaño naayem, aŋa lompo eesaye aal aŋa áyiinoo náafulane, ti eloŋ eti pahaaño naayem.” ");
INSERT INTO krx_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Fiye, Yéesu naasok Pufalisaay pa hícantiitu eehe: “Taakaataak usaanum áyiin, nawaso wañ weewalla núuciiti hinoom. Hinak óo hinak la teyoo pahaaño, naayeno ti eloŋ eenape. ");
INSERT INTO krx_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Intaak lompo áyiin eeleke, caacawoo Lasaar, aŋa nahinto hátikin putum ekumpaan ya eteyoo, eniinoo púlooŋ kaameeŋ musontuwaay. ");
INSERT INTO krx_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Náalafi kahesal aŋa nánowalii ya ti púus pa piti usaanum a apili, piyen pa conko mpíkey mpiyeno kaaneewan musontuwaay ma miteyoo. ");
INSERT INTO krx_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Eeleke ya naaket, pumaleekoo pa mpucoopoo mpiyenanoo pukol Abraham. Usaanum a lompo, naaket naahokee. ");
INSERT INTO krx_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Pati keekete ka naayeno ti kúnuul kenfakat, ápihaafin naaŋantan pállaaŋe Abraham, Lasaar naayeno pukoloo. ");
INSERT INTO krx_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Naaceek apusok: 'Paapaa Abraham, inci ti ñíseeña ñenfakat iyyem le ti uleew ewwe. Keti ti inci ti hikaw, impoñ Lasaar ápikaapuucii pikelan hisiikoo ti man, apumonanam híleeluufam.' ");
INSERT INTO krx_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pale Abraham naañahanoo: 'Añiinam, náwuno nii aayenaayeno ti eloŋ éesuume, tempo Lasaar naayeno ti kúnuul. Fiye, Lasaar oopa le, ti kaapuuñanoolee, awe oopa ti ñíseeña. ");
INSERT INTO krx_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Apan niŋ fúlaa toko, kaayeen kenfakat unka ti pututa unaa, eeha efihiwun ha kéelafiye éfulii petoonii kápifiitanii lupuu ti aluu étikayini, fo lompo incuke ti kéelafiye éfulii lupuu ti aluu nkáfiitanii petoonii.' ");
INSERT INTO krx_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Usaanum a naasokoo: 'Paapaa Abraham, ooto inci luumuu, poñ Lasaar pati ekumpaan ya eti paapaa atoom, ");
INSERT INTO krx_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kaatuko inci taakaataak po pakatu isak. Akaay, apicaakamanii heeyem ha pe, poko lompo timpi kákey peti kúnuul enke.' ");
INSERT INTO krx_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham naañahanoo: 'Pakatuwi kataakaataak pakiical pa piti Móyiis niŋ piti piyaamakoola pa, kásiitan po.' ");
INSERT INTO krx_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Usaanum a naasokoo: 'Paapaa Abraham, eehuu hifomut, pale niŋ an áfuliyoo ti keekete ka naakaay teyii, éfikawunko umuuyen wa uteyii.' ");
INSERT INTO krx_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham naasokoo: 'Niŋ kásiitanut Móyiis niŋ piyaamakoola pa, háati an náañohoonii pati keekete ka, étikayinanoo.'” ");
INSERT INTO krx_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yéesu naasok pinapana pa pakateyoo: “Fan óo fan incuke, efitaak waah weekaakaay kanakan an ti kaamuuyen, pale kúnuul efikiyeno ti aŋa éfuunapii ya teyoo. ");
INSERT INTO krx_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Fisaka apicenkee ti ekun énankiin enfakat naawantee ti kaatii ka le niŋ afaanakan akee ti kéetinee ka payenke apunow ti kaamuuyen. ");
INSERT INTO krx_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nisiiŋo púsooni! “Niŋ atii ya amuuyenaa, watanoo, niŋ awatanooliyaa imponketoo. ");
INSERT INTO krx_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Niŋ amuuyenaa ti awe ñiyema isak niŋ ñésupak ti hinoom ha hoonool ha, náañohoonii ti awe ñiyema isak niŋ ñésupak kaaluum kaaponket, aañaŋoo kaaponket.” ");
INSERT INTO krx_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Pupoñapoñ pa nkasok Ateeteyo: “Penan unii káyinan.” ");
INSERT INTO krx_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ateeteyo naañahanii: “Niŋ nitaakaa káyinan keefomut nii ekoon sootoo, níyiniyini hisoku enuun eyyuu: 'Lúpinoolo inkaasiiŋanoolo ti han,' éfeehin eeha innisoke ha. ");
INSERT INTO krx_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Usokaa akee ti aluu ataake amiikan ayaya niŋ fotom afaasa púlukuleen pa piteyoo. Mpáyetaliyoo ti kaakit, fo aafasokoo: 'Hiliikan kéy yeno aapili'? ");
INSERT INTO krx_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Haani, aafasokoo: 'Kéy yikam waah ewwa inci fali káciim, naapayaa hiik, immemanoolo uwwufanam pili illaan, niŋ inci payaa, awe conko, illi illaan.' ");
INSERT INTO krx_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Fo aafasok amiikan a apalaka kamma náahine eeha ansokoo ha áhin? ");
INSERT INTO krx_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Fo lompo incuke ti aluu, niŋ níhinaa waah ewwa nkasoke wa aluu níhin, nisok: 'Unii pimiikan kenseŋ, páhin pa putoonii lamma núuhine.'” ");
INSERT INTO krx_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yéesu ti pikaayu Jerusalem, naanap ti pututa mah ma miti Samali niŋ Galilee. ");
INSERT INTO krx_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Akina ti pinako ti cikee cisaatee, pakan ŋaasuwan keekuulut kamma kanuk nkákey kapipaakoolanoo. Nkasiiŋo kápilaaŋoo ");
INSERT INTO krx_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","nkaceekoo niŋ uwiiluyii: “Yéesu, Ahámpaatiin, keti hikaw ti unii!” ");
INSERT INTO krx_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yéesu apucukii, naasokii: “Nikaay cániyisanoolo pati puwaaseena pa pakati Pútuun pa.” Poko ti pítin pa nkakuulanee. ");
INSERT INTO krx_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Akee ti poko, ápipannum nii ákuuñaneekuuñan, náañohoonii ti wootoo, naayeno hímulu Pútuun pa niŋ kaawiiluyoo. ");
INSERT INTO krx_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Naanow ti woot Yéesu, puhooŋuyoo t’etaam, naasokoo apalaka. Antúŋ ati Samali. ");
INSERT INTO krx_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yéesu naacakan: “Fo ŋaasuwan ya púlooŋ tom ekuulanee? Isak ya niŋ pakapaakiil paka peyme nkayem? ");
INSERT INTO krx_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Háati akee ti poko ayinaat éñohoonii ápumul Pútuun pa fo niŋ neetaat ati Samali ya aŋe, eeneetaat a ati Israyel?” ");
INSERT INTO krx_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Naasokoo: “Lito, kaay, káyinan ka kitii kúkuuñanuu.” ");
INSERT INTO krx_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Hikee hinoom, pakakee Pufalisaay nkacakan Yéesu: “Teyme cáwii ca citi Pútuun pa éficikey?” Yéesu naañahanii: “Cáwii ca citi Pútuun pa éticikey samat nii waah ewwa nuucukee. ");
INSERT INTO krx_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","An atasok: 'Nisincan! Ehee co!' niŋ fotom 'Ahaa co!' kaatuko cáwii ca citi Pútuun pa unca ti aluu.” ");
INSERT INTO krx_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Púful toko Yéesu naasok pinapana pa pakateyoo: “Caanak unca ti ékey, éfinilafi fanfaŋ hicuku hinoom hoonool ti kunoom ka kiti inci, Añii An, pale etinicuk ho. ");
INSERT INTO krx_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pakan efikasok aluu: 'Nisincan! Eheeyoo le!' niŋ ekina tom: 'Ahaayoo pa!' Pale timpi nikaay, timpi ninapanii. ");
INSERT INTO krx_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kaatuko inci, Añii An, éfikey samat nii fa pamaliñoolal etiil mpicaaŋan fa patiila púlooŋ písik ti púcook fo ti pikelan. ");
INSERT INTO krx_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pale fo inci yáañ yeno ti kúnuul kenfakat, impookee ti ekaay eyye. ");
INSERT INTO krx_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Samat nii fa intaakiye fa ti caanak ca citi Nowe, fo lompo inkaakaay pitaako ti kunoom ka kiti inci, Añii An. ");
INSERT INTO krx_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Pakan paka nkayeno hili, pálaani, esa niŋ pinimo fo ti hinoom eeha Nowe náayuukiye ha ti piteen pa penfakat pa. Fiye, etiil ya néenupii man menfakat fo mumukalii púlooŋ cew. ");
INSERT INTO krx_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Fo lompo incuke ti kunoom ka kiti Lot: Pakan paka nkayeno hili niŋ pálaani, hinoom niŋ kaanooman, pusuk niŋ kulut. ");
INSERT INTO krx_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pale hinoom eeha Lot náafule ha Sotom, seemak niŋ kíceek ínsifulii patiila, insimukalii púlooŋ cew. ");
INSERT INTO krx_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Fo lompo facuk ti hinoom eeha inci, Añii An, inkaakaay ha éyisanoolo. ");
INSERT INTO krx_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ti oom hinoom aŋa eeyem patiila piteefu ekumpaan naataak waahoo páhantuwa, timpi áwanoonii apucoop wo. Fo lompo incuke, aŋa eekaaye piya, añaŋut puñoho t’enuuf. ");
INSERT INTO krx_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nínawuno heetaakiye ha Lot aaloo! ");
INSERT INTO krx_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Aŋa éelafiye kafakan eloŋ ya eteyoo, áfaapuul teyyo, pale aŋa éepuule eloŋ ya eteyoo afaafakan yo. ");
INSERT INTO krx_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Inci pusok aluu: Oom hánant pakan pákasupak efikahinto nantoonool, oonool áfaaseepinee akee ya naakatee toko. ");
INSERT INTO krx_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Pakaal pákasupak efikayeno pútuum ti ésiken yoonool; oonool áfaaseepinee, akee ya naakatee toko.”  ");
INSERT INTO krx_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Pinapana pa pakateyoo nkacakanoo: “Ahámpaatiin, peyme eehuu nihikaakaay pitaako?” Naañahanii: “La ehunuŋ neeyem, toko píketul pa mpuconcool.” ");
INSERT INTO krx_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Fiye, Yéesu naasok pinapana pa pakateyoo hícantiitu eehe ápiyisanii nii kañaŋaa kaluum tan óo tan timpi káwusen. ");
INSERT INTO krx_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Naasokii: “Taakaataak ti ekee saatee áyiin áhina kíiti eefeyut Pútuun pa apaaliit an. ");
INSERT INTO krx_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ti saatee eyyuu lompo, intaako eyaaŋat aŋa áyiinoo eekete, apinakaay pateyoo kati áhin kíiti ti pututayoo niŋ akamooloo. ");
INSERT INTO krx_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Fo ta infiyye innapook, pale ti pikelan naasokoolo: 'Háati inci feyut Pútuun pa niŋ ekina tom paaliit an ");
INSERT INTO krx_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pale, páawoo aal aŋe oopa ti ihampuyam meemak, inci fasiiŋiyoo. Niŋ inci hínut fo átayekuno ékey hinak óo hinak kayokanam.'” ");
INSERT INTO krx_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Fiye, Ateeteyo nene asok: “Nísiitan áhina kíiti ya eenaput a aŋuu eeha naasoke ha. ");
INSERT INTO krx_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Fo Pútuun pa efipukuut ti pisiiŋo pakan paka payenka mpimamale ka, keeyem ka ti kaayonkal etempo hánant hanakan kati piyankananii? ");
INSERT INTO krx_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Inci pusok ho aluu, efipisiiŋiyii mpacas. Pale inci, Añii An, niŋ inci ñóhooniyoo fo éfitookii t’etaam keetaake káyinan?” ");
INSERT INTO krx_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Fiye, intaako toko keecokooliye nii keecoonoole, nkátinan ti pakakee paka. Tempo, Yéesu naasokii hícantiitu eehe: ");
INSERT INTO krx_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Taakaataak pakan pákasupak keekaaye ti hank ha hiti ekumpaan ya enfakat ya eti Pútuun pa kaluum: akee ya Afalisaay, akee ya asayoola kúncoo. ");
INSERT INTO krx_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Afalisaay a naasiiŋo citeeteyoo naaluum: 'Inci sokuu apalaka Pútuun kamma inci incukut nii pakakee paka, keeyem ka pílipa, keecoonoolut, pihaañiya niŋ pakaal niŋ fotom samat nii asayoola kúncoo ya aŋe. ");
INSERT INTO krx_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Insunsuŋ kunoom kúsupak ti lóokuŋ ya, uwwufani himpaac ha heewase ha ŋaasuwan ti waah óo waah púlooŋ ewwa inci intaake tewwo cooy.' ");
INSERT INTO krx_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Pale asayoola kúncoo ya naasiiŋo pílaaŋ, álafiit fala káahaafin, pale náasitan, naasok: 'Pútuun, taak paket hikaw ti inci, amuuyena ya.'” ");
INSERT INTO krx_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yéesu naasokii: “Inci pusok aluu, áyiin a aŋuu, ta naayeniye ta piyetu, akina Pútuun pa mpucoke nii eecoonoole pale Afalisaay a tom. Kaatuko an óo an eesilanooliye áfaawananiyee, an óo an eewananooliye afaasilanee.” ");
INSERT INTO krx_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Fiye, pakan nkácoopii miñii ti Yéesu kati álikii. Pinapana pa pakateyoo kapucuk eehuu nkafet ti kéecoopii ka miñii ma. ");
INSERT INTO krx_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pale Yéesu naayonkal epuuk ya naasok: “Nikatan epuuk ya kápikey ti inci, timpi nikitii. Kaatuko cáwii ca citi Pútuun pa citi keecuke ka nii poko. ");
INSERT INTO krx_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Inci pusok aluu pánipani ya, an atanako ti cáwii ca citi Pútuun pa taamanta asayanut co samat nii ciñii.” ");
INSERT INTO krx_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ati hikaw ati Pusuwif naacakan Yéesu: “Ahámpaatiin eenape yuu, puume inci iññaŋe íhinu pitaak eloŋ ya eepayantoo ya?” ");
INSERT INTO krx_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yéesu naañahanoo: “Weyme uwune ayyonkalam eenape? Taakut an eenape fo Pútuun pa lamma. ");
INSERT INTO krx_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Fo áamiit hilim ha heesiiŋanee ha? 'Timpi hinto niŋ aal eenimiye, timpi muk an ti pásuumayi, timpi líp, timpi caam aapunook akinooli, nápiyan paapaa atii niŋ íññaa atii.'” ");
INSERT INTO krx_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Naañahan Yéesu: “Eehuu púlooŋ inci íntuule kápiliŋ maañiiyaayam.” ");
INSERT INTO krx_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ta Yéesu náasiye ta eehe, naasokoo: “Waah woonool uwwa toko ewwa ánhinut: Nooman hitaaku ha hitii púlooŋ uwwufan mañ ma keeleke ka, aafataak hisaanumate alacana, náafulaa toko ínkey innapanam.” ");
INSERT INTO krx_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pale ta áyiin a náasiye ta eehe ínciitiyoo meemak, kamma naataake fo muus. ");
INSERT INTO krx_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yéesu apisincanoo, naasok: “Cíiticiiti kusaanum ka kapinako ti cáwii ca citi Pútuun pa! ");
INSERT INTO krx_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Fo ñonkomoo éfeeyini pinako ti káfuun saakilaŋ? Haani! Pale pinako pa piti usaanum ti cáwii ca citi Pútuun pa efipihaŋ páciite.” ");
INSERT INTO krx_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Keeyeniyoo ka káasiitan, nkacakan: “Fiye, ayme áfaayiniyee kafakan?” ");
INSERT INTO krx_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yéesu naañahanii: “Waah wa weeheeke wa an, uheekut Pútuun pa.” ");
INSERT INTO krx_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Piyeer naasok Yéesu: “Sincan, unii ukatanaakatan waah wa utoonii púlooŋ nuunapani.” ");
INSERT INTO krx_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yéesu naañahanii: “Inci pusok aluu pánipani ya, an óo an eekatane enuuf, aal, ñúnu niŋ pakatu, pupuka, epuuk kamma cáwii ca citi Pútuun pa, ");
INSERT INTO krx_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","afaahaŋ hitaaku meemak ti caanak ca citi fíyooy, niŋ ti púlunta pa peeyem pa ti ékey, eloŋ ya eepayantoo ya.” ");
INSERT INTO krx_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Púful toko, Yéesu naacoop ti kaapii pupoñapoñ pa pakateyoo ŋaasuwan niŋ pákasupak paka, naasokii: “Nísiitan, unaa unka ti pisilo Jerusalem, waah wa púlooŋ ewwa piyaamakoola pa nkakiice wa kiti inci, Añii An, efuutaako. ");
INSERT INTO krx_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Efikawufanam keeneetaat ka Pusuwif. Efíkapalahoolam nkalenkenam, nkakallanam, nkafaacal ti inci. ");
INSERT INTO krx_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Efikasapam niŋ kisawut, nkamukam. Ti hinoom ha híhaaciyenu ha fálitoonii ti eket ya.” ");
INSERT INTO krx_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pupoñapoñ pa kásiit eeha naayemii ti hisoku. Putum hilim ha nihiyolee teyii, kámiit eeha Yéesu náalafiyii hisoku. ");
INSERT INTO krx_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yéesu ta naalohane ta Jeriko, káafuumafuum nkiyeno ti kanaac pítin pa, kipiyeno kaaluumatool. ");
INSERT INTO krx_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kípisi kayoŋ ka ti himuusu, nkicakanii heetaakiye. ");
INSERT INTO krx_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nkasokoo: “Yéesu ati Naasalet ayem ti himuusu.” ");
INSERT INTO krx_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ta káafuumafuum ka nkísiye ta eehe nkíceekii apusok: “Yéesu añii ya ati Dawid, taak paket hikaw ti inci!” ");
INSERT INTO krx_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Keeyeniye ka hátikin nkafet teyoo nkasokoo afatan, pale naahaŋ toko náaceekii: “Añii ya ati Dawid taak paket hikaw ti inci!” ");
INSERT INTO krx_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yéesu naasiiŋo naasokii: “Nícoopiyamoo.” Ta náalohaniyoo ta, Yéesu naacakanoo: ");
INSERT INTO krx_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Weyme állafiye inci píhini?” Naasokoo: “Ahámpaatiin, káluma hínam pinee cuk.” ");
INSERT INTO krx_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yéesu naasokoo: “Ñoho ti hicuku, káyinan ka kitii kúkuuñanuu.” ");
INSERT INTO krx_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tokotoko ñíkinoo íññipankino, naanapan Yéesu, naayeno hímulu Pútuun pa. Kayoŋ ka púlooŋ kupucuk eehuu lompo, nkiyeno hímulu Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Púful toko, Yéesu naanako ti saatee ya eti Jeriko. Apiyeno himuusu saatee ya, ");
INSERT INTO krx_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","intaako toko áyiin aŋa nkasok Sakaay, akee ti ñíhampaatiin pisayoola kúncoo ya, naayeno usaanum. ");
INSERT INTO krx_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Náalafi hicuku ayme ayem Yéesu, pale patameyoo mpuwun ayinaat kamma kayoŋ ka. ");
INSERT INTO krx_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Fiye, naatey hátikin pa Yéesu naañaŋe pa himuusu, naasilo ti enuun kati acukoo. ");
INSERT INTO krx_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yéesu ápucolii toko náahaafin naasokoo: “Sakaay, wánoonii mpacas, kaatuko fíyooy, fo inci wanan pati awe.” ");
INSERT INTO krx_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakaay náawanoonii mpacas, naawanan Yéesu niŋ pásuuma. ");
INSERT INTO krx_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Pakan paka púlooŋ kapucuk eehuu nkáyaañ káakumutool kapusok: “Pati amuuyena naakaaye apuwanan.” ");
INSERT INTO krx_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Pale Sakaay naasiiŋo, naasok Ateeteyo: “Sincan, Ahámpaatiin! Inci fawufan kancaŋ hisaanumate ha hitoom keeleke ka, an óo an aŋa ammeya nii inci lípoolip, fañahanoo fo ñapaakiil aŋa inci incoope ya teyoo.” ");
INSERT INTO krx_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yéesu naasokoo: “Fíyooy kafakan ka kúcoliyoo ti ekumpaan eyye, kamma aŋe lompo naayem ati miin ma miti Abraham. ");
INSERT INTO krx_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kaatuko inci, Añii An, kéyyookey hiŋes niŋ kafakan keelinciye ka.” ");
INSERT INTO krx_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yéesu fa naalohane fa Jerusalem, pakan paka incukii nii etikamp Pútuun pa efipisiiŋan cáwii etempo. Ekina ewune, poko ti káasiitanoo ka, Yéesu naapenanii hícantiitu eehe. ");
INSERT INTO krx_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Naasokii: “Taakaataak áyiin eemaka eeyeniye pikaayu ti mah méelaaŋe, pa naakaakaayee hicoku amansa ya ati mah ma miteyoo, niŋ apayaa náañohoonii. ");
INSERT INTO krx_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Akáayum, náayonkalii ŋaasuwan ti pimiikan pa pakateyoo naawufan an óo an sanoo yoonool naasokii: 'Niyesanool nempo fo ta inci fáñohoonii.' ");
INSERT INTO krx_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pale, pakan paka pakati saatee ya kanatoonat, nkapoñ pusonoo pakan kapica kasok nii: 'Unii úlafiit áyiin a aŋe apiyeno amansa ya atoonii.' ");
INSERT INTO krx_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Pale toko fiyaaw, náayenoonii amansa ya, náañohoonii ti mah ma miteyoo. Naayonkal pimiikan pa payenkuu naawufane ka pisanoo kati ámeyi puume nkataakale. ");
INSERT INTO krx_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ayáañ a náakey naasokoo: 'Ahámpaatiin, sanoo ya etii epukaa sikee sisanoo ŋaasuwan.' ");
INSERT INTO krx_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Amansa ya naasokoo: 'Aáhinaa kata, awe amiikan eenape! Páawoo aacoonoolaa-coonool niŋ waah wenkilis, inci fáhini ati hikaw ati sisaatee ŋaasuwan.' ");
INSERT INTO krx_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Asúpiyenu ya náakey, naasokoo: 'Ahámpaatiin, sanoo ya etii epukaa sikee sisanoo isak.' ");
INSERT INTO krx_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Amansa ya naasokoo: 'Awe lompo inci fáhini ati hikaw ati sisaatee isak.' ");
INSERT INTO krx_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Akee amiikan náakey, naasokoo: 'Ahámpaatiin, ehe sanoo ya eyya awwufanaam ya, inci túkaatuk yo ti cifaal immank yo. ");
INSERT INTO krx_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Inci feyuufe, kamma ayyem áyiin eefete. Ansasa waah ewwa ayyenanut, immaañ waah ewwa ansukut.' ");
INSERT INTO krx_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Amansa ya naañahanoo: 'Ti pákupali inci inkaakaay íhinuyi kíiti, awe amiikan eenaput! Iyyoo! Aámeyimeyi nii inci áyiin eefete, insasa waah ewwa inci iyyenanut, immaañ waah ewwa inci insukut. ");
INSERT INTO krx_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Weyme uwune aanakanut sanoo ya etoom ti émankuma mañ, ancuk niŋ inci ñóhooniyoo, insa yo niŋ waah weenanfe teyyo?' ");
INSERT INTO krx_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Fiye, naasok keeyeniye ka toko: 'Nicoop sanoo ya eteyoo inniwufan yo aŋa eetaake ya sisanoo ŋaasuwan.' ");
INSERT INTO krx_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nkasokoo: 'Ahámpaatiin, aŋuu apayaapa hitaaku sisanoo ŋaasuwan!' ");
INSERT INTO krx_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Naañahanii: 'Inci pusok aluu: An óo an eetaake, afaapenanee, pale an óo an eetaakut, háati caahinkilis ya eyya naataake ya efeesayee teyoo. ");
INSERT INTO krx_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pale pikamoolam keesoke ka kálafiit inci kati yeno amansa ya ateyii, nikaay nípicoopiyii le hátikinam innimukii.'” ");
INSERT INTO krx_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yéesu ta naapaye ta hisoku eehuu, naanow kayoŋ ka hátikin, apiyeno pisilo Jerusalem. ");
INSERT INTO krx_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ta nkalohane ta Petifake niŋ Betani, la nkasok la cítintiŋ ca enca nkasok ca Olif, naapoñ pákasupak ti pinapana pa pakateyoo, ");
INSERT INTO krx_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","naasokii: “Nikaay ti cisaatee ca ceeyem ca hátikin aluu, niŋ ninakiyaa tenco efinitook cífali ceecenkee toko enca an ataapala alapo tenco, níkopinii co, ínnicoopiyam co. ");
INSERT INTO krx_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Niŋ an acakanaa aluu: 'Weyme uwune ínniyemi co ti kákopin?' Inniñahanoo: 'Ahámpaatiin a asoolahe co.'” ");
INSERT INTO krx_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Keepoñee ka nkakaay incakatook samat nii fa Yéesu naasokii fa. ");
INSERT INTO krx_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kapiyeno kákopin cífali ca, pakateete co nkacakanii: “Weyme uwune ínniyemi co ti kákopin?” ");
INSERT INTO krx_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nkañahanii: “Ateeteyo asoolahe co.” ");
INSERT INTO krx_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nkácoopii co Yéesu, nkalemp kúsool ka kiteyii kenfakat ka ti cífali ca, nkalapanoo tenco. ");
INSERT INTO krx_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Akina ti pikaayu pa, pakan paka nkatanaloo kúsool ka kiteyii kenfakat ka ti pítin pa. ");
INSERT INTO krx_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Apulohan Jerusalem, ti pítin pa piti eliiŋoon ya eti cítintiŋ ca enca nkasok ca Olif, kayoŋ ka púlooŋ kiti pinapana pa pakateyoo nkimeeŋ niŋ pásuuma, nkíyaañ kaanimpan Pútuun pa niŋ kilim keeceeke kamma nkacuke waah weecukantee. ");
INSERT INTO krx_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nkasok: “Alímaati Ateeteyo Pútuun pa pisampan amansa ya éekeyii ya ti caacaw etempo! Kásuumaay kiyeno alacana, núumulaa Pútuun pa piti patiila.” ");
INSERT INTO krx_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Pakakee Pufalisaay pa keeyeniye ka ti kayoŋ ka nkasok Yéesu: “Ahámpaatiin, fet ti pinapana pa pakatii kapifatan!” ");
INSERT INTO krx_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yéesu naañahanii: “Inci pusok aluu, niŋ kafatanaa, pínankiin pa éfipiceekii!” ");
INSERT INTO krx_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yéesu apihaŋ naalohane Jerusalem, naacuk saatee ya, naakooŋ kiteeteyyo. ");
INSERT INTO krx_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Naasok: “Niŋ awe lompo Jerusalem aameya ti hinoom eehe waah ewwa éfuucoopiyi kásuumaay ka! Pale fiye eehuu hiyoleeyol ti ñíkini. ");
INSERT INTO krx_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Hileeŋi kamma ámmiit, kaatuko caanak unca ti ékey ta pikamooli éfikakiiti púlooŋ, nkákinkooli, nkakincooli ti upii wa púlooŋ. ");
INSERT INTO krx_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Efikatuncalooli niŋ epuuki; etikakat énankiin eenaŋiye ti ekee, kamma ankiiwut ta Pútuun pa mpíkeyii ta kafakani.” ");
INSERT INTO krx_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ta Yéesu naacole ta Jerusalem, naanako ti hank ha hiti ekumpaan ya enfakat ya eti Pútuun pa, náayaañ hiyaanu punoomana pa. ");
INSERT INTO krx_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Naasokii: “Kiiceekiic ti hilim ha hiti Pútuun pa nii: 'Ekumpaan ya etoom ekumpaan éluumuma,' pale aluu inniyesan yo 'éyolowuma pikanca'.” ");
INSERT INTO krx_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Naayeno kakalaŋan hinak óo hinak ti hank ha hiti ekumpaan ya enfakat ya. Ñíhampaatiin puwaaseena pa pakati Pútuun pa niŋ pikalaŋana hilim ha heesiiŋanee ha hiti Móyiis niŋ pakakee ñíhampaatiin ti pakan paka, nkálafiyoo himuku. ");
INSERT INTO krx_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pale, kámiit fa nkakaakaay íhinu, kamma pakan paka púlooŋ nkayemoo ti káasiitan meemak. ");
INSERT INTO krx_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Hikee hinoom, Yéesu naayeno kakalaŋan pakan paka ti hank ha hiti ekumpaan ya enfakat ya eti Pútuun pa niŋ káatuunanii ekooŋan ya éesuume ya. Ñíhampaatiin puwaaseena pa pakati Pútuun pa niŋ pikalaŋana hilim ha heesiiŋanee ha hiti Móyiis niŋ pakakee ñíhampaatiin nkácolii. ");
INSERT INTO krx_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nkasokoo: “Sok unii, awe yem ayme heewune áayemi ti íhinu eehuu? Ayme asokuu hín ho?” ");
INSERT INTO krx_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yéesu naañahanii: “Inci lompo taakaataak ti aluu kacakan. Nisokam: ");
INSERT INTO krx_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","pátise ya eti Saŋ, ti ayme néefulii, ti Pútuun pa fo ti pakan paka?” ");
INSERT INTO krx_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Fiye nkayeno piteŋenool ti pututayii, nkasokoolo: “Niŋ unaa usokaa, ti Pútuun pa néefulii, afaasok unaa, ooto weyme uwune níyinanutoo? ");
INSERT INTO krx_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pale niŋ usokaa ti pakan paka néefulii, kayoŋ ka púlooŋ efikumuk unaa niŋ pukumpa, kamma nkíyinane nii Saŋ ayaamakoola.” ");
INSERT INTO krx_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Fiye, nkañahanoo: “Umíit ti ayme néefulii.” ");
INSERT INTO krx_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yéesu naañahanii: “Inci lompo etisok aluu eesokaam ya hín eehe.” ");
INSERT INTO krx_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Fiye, Yéesu naasok hícantiitu eehe pakan paka: “Taakaataak akee áyiin eesuke kaakitoo kiti wiiñ, náaluwaas ko pakakee píhina, naakaay kaakaawool ti mikee mah keefiyye. ");
INSERT INTO krx_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ta hisaatu ha níhituuniye ta, naapoñ akee ti pimiikan pa pakateyoo ti púluwaasa pa kati kawufanoo putum pa piteyoo ti pasaatal pa. Pale púluwaasa pa nkasap amiikan a, nkayaanoo sipeesoo ñaanii. ");
INSERT INTO krx_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Fiye, ati kaakit ka nene apoñ akee amiikan, pale aŋuu lompo púluwaasa pa nkasapoo, nkateñaloo, nkayaanoo sipeesoo ñaanii. ");
INSERT INTO krx_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nene apoñ amiikan áhaaciyenu, púluwaasa pa nkasapoo, nkakuumoo, nkayaanoo. ");
INSERT INTO krx_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Fiye, ati kaakit ka naasok: 'Puume inci inkaakaay íhinu? Inci fapoñ añiinam aŋa inci íllafiye ya, manti kátuuloo.' ");
INSERT INTO krx_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pale ta púluwaasa pa nkaŋantanoo ta nkateŋenool nkasok: 'Aha aŋa akaakaay ya hitoonu kaakit ka, umukoo ancuk kaakit ka kiyeniyaa kutuunaa.' ");
INSERT INTO krx_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nkawantoo tíkitaaŋ kaakit ka, nkamukoo.” Fiye, Yéesu naasok: “Puume ati kaakit ka naakaakaayii íhinu? ");
INSERT INTO krx_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Afáakey naamuk púluwaasa pa, naawufan kaakit ka pakakee.” Ta pakan paka nkásiye ta eehe nkasok: “Alímaati eehuu timpi hitaako!” ");
INSERT INTO krx_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yéesu naasincanii naasok: “Ti hilim ha hiti Pútuun pa, eeheyme pakiical empe mpusoke: 'Enánkiin ya eyya puluta pa nkawante ya éyenoonii énankiin ya eehaŋe ya hitaaku nafaa'? ");
INSERT INTO krx_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“An óo an eenowe ti oom énankiin afaahumaloolee, an óo an aŋa neenowe teyoo afaatuncaloolee.” ");
INSERT INTO krx_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Pikalaŋana hilim ha heesiiŋanee ha hiti Móyiis niŋ ñíhampaatiin puwaaseena pa pakati Pútuun pa, nkámeyi nii poko kawune Yéesu naasok hícantiitu eehe. Nkálafiyoo hicoku tokotoko pale nkafe kayoŋ ka. ");
INSERT INTO krx_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pikalaŋana hilim ha heesiiŋanee ha hiti Móyiis niŋ ñíhampaatiin ña nkatah kunuuwii meemak ti Yéesu, nkapoñ mikelecoola teyoo kéehine faŋii nii pakan keecoonoole. Nkálafi hikuucuyoo ti pákupaloo, kati kacokoo nkawufanoo ati hikaw ha ati mah ma. ");
INSERT INTO krx_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nkacakanoo eehe: “Ahámpaatiin, unii úmeyimeyi nii ánkupkup inkalaŋan pucoonool ciit, niŋ fúlaa toko aasincanantoo ti sicaw, pale ti pánipani ya ankalaŋan pítin pa piti Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Sok unii: Fo cooneecoon fo coonutee upucooy kúncoo ya amansa ya enfakat a ati Room?” ");
INSERT INTO krx_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pale Yéesu náameyi nii hikuucuyoo nkayaake, naasokii: ");
INSERT INTO krx_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Níyisanam kaahit kiti mañ, puhooŋu niŋ caacaw ayme kayem toko?” Nkañahanoo: “Piti amansa ya enfakat a.” ");
INSERT INTO krx_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Fiye naasokii: “Ooto, niwufan amansa ya waah wa uteyoo, inniwufan Pútuun pa waah etempo.” ");
INSERT INTO krx_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Fiye, hátikin pakan paka kayinaatoo hicoku ti pákupaloo, nkaŋaŋo ti pañahanaloo nkakemanool kem. ");
INSERT INTO krx_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Pakakee Pusatusaay nkákey ti Yéesu. Pusatusaay pa káyinanut ti élitoonii ya eti keekete ka. Nkacakanoo: ");
INSERT INTO krx_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ahámpaatiin, Móyiis akiicaakiic ti hilim ha heesiiŋanee ha nii: niŋ áyiin asayaa aal naaket peetaakut añii, atuwoo añaŋaa hitoonu aal a, naataak neyoo epuuk pakati púnuwoo eekete ya kati ataak cánkut. ");
INSERT INTO krx_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Fiye, intaako hínum ti miin moonool pákayiin isak niŋ pákasupak. Ayáañ a naasa aal, naaket peetaakut añii. ");
INSERT INTO krx_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Asúpiyenu ya naatoon aal a, ataakut añii, naaket. ");
INSERT INTO krx_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Aháaciyenu ya lompo naatoonoo. Fo lompo incuke, ti isak ya niŋ pákasupak paka nkatoonoo, nkaket peetaakut neyoo añii. ");
INSERT INTO krx_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ti pikelan aal a lompo naaket. ");
INSERT INTO krx_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Fiye, hinak ti pilito pa ti eket ya, aal a aŋuu ati ayme, páawoo isak ya niŋ pákasupak paka púlooŋ kasayoo?” ");
INSERT INTO krx_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yéesu naañahanii: “Ti púlunta pa piti fíyooy, pakan paka nkasasa nkanimo. ");
INSERT INTO krx_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Payenka Pútuun pa mpusoke ka nii poko kanape kati kalitanee ti eket ya nkakin ti púlunta pa peeyem pa ti ékey etikasa, etikanimo. ");
INSERT INTO krx_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Etínekayini eket, kaatuko kacukaacuk nii pumaleekoo pa, ekina ewune etikasa etikanimo. Poko epuuk Pútuun kamma nkalitanee ti eket ya. ");
INSERT INTO krx_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Móyiis náayisan picaaŋ cataŋ nii keekete ka éfikalitoonii. La sokee la ti hilim ha hiti Pútuun pa kiti cífita ca ceecoke ca apan cisowiit, naayonkal Ateeteyo 'Pútuun pa piti Abraham, Pútuun pa piti Isaak, Pútuun pa piti Jakob.' ");
INSERT INTO krx_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Pútuun pa pineetaat piti keekete ka pale piti keeloŋe ka, kaatuko ti Pútuun pa an óo an oopa kaloŋa.” ");
INSERT INTO krx_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Pakakee ti pikalaŋana hilim ha heesiiŋanee ha hiti Móyiis nkasokoo: “Ahámpaatiin, áakupaa pitempo tak!” ");
INSERT INTO krx_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kaatuko nene káhaañiitoo kacakan hikee hilim. ");
INSERT INTO krx_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yéesu naasokii: “Weyme uwune pakan paka nkasok Eenucee ya ati Pútuun pa, añii ya ati Dawid? ");
INSERT INTO krx_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dawid himuumoo asokaasok ti pakiical pa piti kícimu ka: 'Ateeteyo Pútuun pa púkupaakup niŋ Ateeteyo atoom ti hisoku: Kéy yeniyam epees yáali, ");
INSERT INTO krx_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","fo ta inci fatah ta pikamooli ti wooti ayyeno amansa ya ateyii.' ");
INSERT INTO krx_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Dawid himuumoo nayonkal Eenucee ya 'Ateeteyo', puume akina áfaayini piyeno añii ati Dawid?” ");
INSERT INTO krx_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ta pakan paka púlooŋ nkayeniyoo ta káasiitan, Yéesu naasok pinapana pa pakateyoo: ");
INSERT INTO krx_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Níwasum pikalaŋana hilim ha heesiiŋanee ha hiti Móyiis. Poko, nkálafilafi kaamuusool niŋ kúsool kenfakat, nkálafi lompo kapinkakicanee pinapnap ti kíliŋ ka. Poko nkálafi piyeno ti kúkon ka keenape ka ti púluumuma pa niŋ ti hili ha henfakat ha. ");
INSERT INTO krx_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Poko lompo nkacaakool piyaaŋat pa payenka pákayiinii keekete ka, kapucoop waah wa uteyii púlooŋ. Apan niŋ kayeniyaa kaluum nkafiyo kati kacokee nii pakan keenape. Pútuun pa efipisapii pihaŋ pakakee paka.” ");
INSERT INTO krx_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ti oom káasiiŋuma, Yéesu naayeno kaasincanool pakan paka ti hank ha hiti ekumpaan ya enfakat ya eti Pútuun pa, naacuk kusaanum ka ti hiwasu mañ ti éwasuma mañ ma, emma nkácoopii ma kati kawufan mo Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Naacuk lompo eyaaŋat eeleke, aŋa áyiinoo eekete, naawase toko uhit úsupak weetaakut nafaa. ");
INSERT INTO krx_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yéesu naasok pinapana pa pakateyoo: “Inci pusok aluu pánipani ya, aal a aŋuu eeleke ya ahaŋa kawufan pakan paka púlooŋ. ");
INSERT INTO krx_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kaatuko pakan paka, mañ ma emma nkasoolahut ma nkawase lupo, pale akina ti palekoo naawufan púlooŋ aŋa naataake ya kati aloŋ.” ");
INSERT INTO krx_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Fiye, pakakee ti pinapana pa nkayeno hímulu ekumpaan ya enfakat ya eti Pútuun pa, niŋ pawalle pínankiin pa péewalliyanoole yo pa, niŋ pawalle pa lompo piti waah wa weewufanee wa Pútuun pa. Yéesu naasokii: ");
INSERT INTO krx_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nicukaacuk kiniŋ enkuu púlooŋ? Caanak unca ti ékey an atacuk énankiin eenaŋiye ti ekee, efipitahalee púlooŋ.” ");
INSERT INTO krx_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Pinapana pa nkacakan Yéesu: “Ahámpaatiin, eehuu, teyme nihikaakaay pitaako? Weyme éfuuyisan unii nii uuha ti ékey pitaako tokofiye?” ");
INSERT INTO krx_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yéesu naasokii: “Nisiiŋo púsooni, an timpi acaakool aluu. Kaatuko hícump pakan éfikakey ti caacawam kapusok: 'Inci yem Eenucee ya ati Pútuun pa!' niŋ ekina tom 'Caanak ca cícoliyoo!' Timpi ninapanii. ");
INSERT INTO krx_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Innísiyaa kiti kikam niŋ ñítaakool, timpi nife kaatuko eehuu hiñaŋaa pitaako, pale pikelan empuu étipikey tokofiye.” ");
INSERT INTO krx_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Púful toko, nene asokii: “Mah éfimitaakoolan mah, cáwii íncitaakoolan cáwii. ");
INSERT INTO krx_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Efitaako pan óo pan páyiyiŋanal etaam penfakat, púpankul niŋ úkuuñu wenfakat uti eket. Píyisan peefeyanana lompo mpucukee patiila. ");
INSERT INTO krx_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Pale eehuu púlooŋ hítaakumo, efikacok aluu, nkakallan aluu. Efikacoop aluu ti púluumuma pa kati káhin aluu kíiti, nkakul aluu. Nkawufan aluu pumansa pa niŋ pakati kikaw ka kamma inci. ");
INSERT INTO krx_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Toko efinitaak efaah eti kakamanii inci yem ayme. ");
INSERT INTO krx_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Timpi niwasoolo kúnuul ti eeha innikaakaay hisoku kati nifak, ");
INSERT INTO krx_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kaatuko inci fawufan aluu kilim ka niŋ ecohato ya. Háati oonool ti keepooke ka aluu átayini pisiiŋo hátikin aluu niŋ ekina tom naanook aluu. ");
INSERT INTO krx_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pupuka aluu, pakatu aluu, ñúnu aluu, pakan aluu niŋ pákawi aluu kakaakaay kawufan aluu pakati kikaw ka, pakakee ti aluu efikamukee. ");
INSERT INTO krx_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pakan paka púlooŋ efikanat aluu kamma inci, ");
INSERT INTO krx_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","pale háati kaahan koonool etikiñakee ti kikaw aluu. ");
INSERT INTO krx_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Niŋ nimukutaa efinitaak eloŋ ya etaaluu.” ");
INSERT INTO krx_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yéesu nene asokii: “Niŋ nicukaa Jerusalem néekinkoolee niŋ pusoocaali, ínnimeyi nii enow eteyyo écoliyoo. ");
INSERT INTO krx_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Fiye, keeyem ka ti mah ma miti Judaay kañaŋaa katey pati pítintiŋ pa, keeyem ka Jerusalem káful, keeyem ka tíkitaaŋ saatee ya timpi kánakoonii. ");
INSERT INTO krx_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kaatuko ti kunoom enkuu Pútuun pa mpikaakaay hisapu pakan etempo. Hikina hikiicee ti hilim ha hiti Pútuun pa, fo hitaako. ");
INSERT INTO krx_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kunoom enkuu efikiyeno keeseeñe ti pakaal paka keeyem ka niŋ munow niŋ keeyem ka ti káacuuwan! Kaatuko efitaako ñíyoka ñenfakat ti mah emme, Pútuun pa mpíñiken teyii. ");
INSERT INTO krx_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Pakakee paka efikamukee niŋ káakuntu, pakakee paka nkacokee nkacoopee ti hícump mah méelaaŋe. Keeneetaat ka ti káyinan ka kutuunaa efikakakalool Jerusalem fo ta kunoom enka nkawufanii ka efikipa.” ");
INSERT INTO krx_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yéesu nene asokii: “Píyisan efipiyeno ti caanak ca, ti hiim ha, niŋ ti picaaŋaŋ pa. Ti etaam ya, kaatii ka efikiliiñool, kúsuu ka lompo nkisap meemak, pakan paka púlooŋ efikafe meemak, étikameyi fa éfikahin. ");
INSERT INTO krx_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Pakan paka efikaket niŋ ewatate ti káamiilool heekaakaay ha pitaako ti etaam ya, kaatuko sempe óo sempe siti patiila éfisiyiyiŋan. ");
INSERT INTO krx_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tempo, efikacuk inci, Añii An, ti éfulii ti útiŋu wa uti patiila niŋ sempe niŋ hamake henfakat. ");
INSERT INTO krx_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Fiye, niŋ eehe híyaañaa pitaako, nisiiŋo ínnisaalino, kaatuko kafakan ka kitaaluu kúlohaniyoo-lohan.” ");
INSERT INTO krx_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yéesu apipa, nene asokii hilim eehe: “Nisincan enuun sootoo ya niŋ pikee punuun pa, ");
INSERT INTO krx_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","emma mpíyayanii ma pahatal péeyeeni innicuk niŋ ñíkin aluu, ínnimeyi nii etiil ya élohaniyoo. ");
INSERT INTO krx_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Fo lompo incuke, innicukaa eehe fiye ti pitaako, ínnimeyi nii cáwii ca citi Pútuun pa cílohaniyoo-lohan. ");
INSERT INTO krx_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Inci pusok aluu pánipani ya, ekaay eyye etepa eket ekina peecukut enke fiye púlooŋ nkitaakiye. ");
INSERT INTO krx_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Patiila niŋ t’etaam éfikacim pale kilim ka kutoom étikicim. ");
INSERT INTO krx_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Nitah kunuu! Timpi níluuŋoolo ti pahaaño, ékuman niŋ ekina tom káamiilool eloŋ ya, níwasum hinoom eehuu timpi himint aluu ");
INSERT INTO krx_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","samat nii fa cala nemint soon. Kaatuko éfihinowii ti pakan paka púlooŋ keeyem ka ti púlunta pa. ");
INSERT INTO krx_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Timpi niŋooyal, inniluum tan óo tan kati nitaak sempe siti hifaku ti waah wa weekaakaay wa écolii, niŋ sempe siti pisiiŋo hátikin inci, Añii An.” ");
INSERT INTO krx_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nihanakan ha, Yéesu nayeno kakalaŋan pakan paka ti hank ha hiti ekumpaan ya enfakat ya eti Pútuun pa, kániim ka nakaay hiŋotu ti cítintiŋ ca enca nkasok ca Olif. ");
INSERT INTO krx_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nuulap pakan paka nkáfiis piyito nkakaay pati hank ha hiti ekumpaan ya enfakat ya káasiitanoo. ");
INSERT INTO krx_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pahaaño pa piti kúmpuul ka keetaakut ka leweñoo, empa nkasok pa Himuusu ha, mpúlohanii. ");
INSERT INTO krx_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ñíhampaatiin puwaaseena pa pakati Pútuun pa niŋ pikalaŋana hilim ha heesiiŋanee ha hiti Móyiis nkayeno hiŋes fa éfikahin kapumuk Yéesu, pale nkafe pakan paka. ");
INSERT INTO krx_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Fiye, Seetaani neenako Judas aŋa nkasok ya Iskaliyot, akee ti pupoñapoñ pa ŋaasuwan niŋ pákasupak paka. ");
INSERT INTO krx_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas naakaay hicuku ñíhampaatiin puwaaseena pa niŋ ñíhampaatiin pakati púwuulu pa keeyeniye ka efaas ekumpaan ya enfakat ya eti Pútuun pa kapiteŋenool puume naañaŋii kawufan Yéesu. ");
INSERT INTO krx_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Insúumii meemak, nkásiyool kati kawufanoo mañ. ");
INSERT INTO krx_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas naacoon, naayeno hiŋes káasiiŋuma keenape kati awufanii Yéesu, kayoŋ ka peeneetaat toko. ");
INSERT INTO krx_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Hinoom ha hiti pahaaño pa piti Kúmpuul ka keetaakut ka leweñoo níhicolii, ta nkañaŋe ta kaawaaseen císaacii ca citi Himuusu ha. ");
INSERT INTO krx_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yéesu naapoñ Piyeer niŋ Saŋ naasokii: “Nikaay canimemanool káciim ka kutuunaa kiti Himuusu ha kati uliyaa.” ");
INSERT INTO krx_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nkacakanoo: “Peyme állafiye upumemanool ko?” ");
INSERT INTO krx_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Naañahanii: “Nísiitan, niŋ ninakiyaa ti saatee ya, efinipaakool niŋ áyiin eetiyiye élumpa eti man. Inninow pusonoo fo ti ekumpaan eyya afaanako ya, ");
INSERT INTO krx_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","innisok ati ekumpaan ya: 'Ahámpaatiin a asok, leyme ékaap ya neeyem la naakaakaay hili káciim ka kiti Himuusu ha niŋ pinapana pa pakateyoo?' ");
INSERT INTO krx_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Afáayisan aluu patiila ti ekumpaan ya ékaap enfakat eepayee kaamemanool. Toko efinimemanool káciim ka kutuunaa.” ");
INSERT INTO krx_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nkakaay nkatook waah óo waah samat nii fa Yéesu naasokii fa. Fiye, nkamemanool káciim ka kiti Himuusu ha. ");
INSERT INTO krx_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Caanak ca cípituuno, Yéesu naayeno niŋ pupoñapoñ pa pakateyoo kati kali. ");
INSERT INTO krx_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Naasokii: “Fa inci inhiliikane hínum hili císaacii ca citi Himuusu ha niŋ aluu le niŋ inci facuk kúnuul. ");
INSERT INTO krx_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kaatuko inci pusok aluu: etinene li císaacii ca citi Himuusu ha, fo ta eeha pahaaño pa mpútuule ha efihitaako pati cáwii ca citi Pútuun pa.” ");
INSERT INTO krx_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Naacoop elontoŋ eti elaan naasok Pútuun pa apalaka kiteyyo, naasok: “Nicoop elaan eyye nipisayool aluu púlooŋ. ");
INSERT INTO krx_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kaatuko inci pusok aluu, etinene laan elaan wiiñ fo ta cáwii ca citi Pútuun pa éficikey.” ");
INSERT INTO krx_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Fiye, naacoop hímpuul naasok Pútuun pa apalaka, naafiit ho, naawufanii ho, naasok: “Aŋe eyem eniinam eewufanee ya aluu, níhin eehe kati nínawuniyam.” ");
INSERT INTO krx_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kapipa hili, naacoop lompo elontoŋ ya eti elaan wiiñ ya naasok: “Elontoŋ eyye eti písiyool pa péeyeeni pa piti Pútuun pa niŋ pakan etempo; elaan wiiñ eteyyo ekina eyem hísimam heeniisee ha kamma aluu. ");
INSERT INTO krx_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pale nisincan: Epees aŋa eekaakaay ya hífulu ti inci, yoopiya le niŋ etoom ya ti púus pa. ");
INSERT INTO krx_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kaatuko inci, Añii An, faket samat nii fa Pútuun pa mpusoke fa, pale kúnuul efikiyeno ti aŋa éefule ya ti inci.” ");
INSERT INTO krx_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pupoñapoñ pa pakateyoo nkáyaañ picakanool ayme akaakaay íhinu eehuu. ");
INSERT INTO krx_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pinapana pa pakati Yéesu nkayeno pílaacinool peesowa cút ti eecukee nii akina ayem aŋa eehaŋe ya pamake. ");
INSERT INTO krx_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yéesu naasokii: “Ti púlunta pa, pumansa pa kataakaataak sempe ti pakan paka, pakati kayine ka nkálafi kapusokee píhina heenape. ");
INSERT INTO krx_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Hikina tom hiñaŋe ti aluu. Eemaka ya ti aluu añaŋaa piyeno nii akelan, ati hikaw ha samat nii áhina. ");
INSERT INTO krx_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ayme ayem eemaka ya, aŋa nkawufane ya apili fo amiikan a? Fo aŋa nkawufane ya tom hili ha? Pale inci oopa le ti pututa aluu samat nii amiikan. ");
INSERT INTO krx_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Nisiiŋaasiiŋo niŋ inci ti páciite pa putoom. ");
INSERT INTO krx_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Samat nii fa Paapaa atoom naawufanaam fa cáwii fo lompo inci fáhin aluu nipiyeno pakati kikaw. ");
INSERT INTO krx_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ancuk innili innilaan niŋ inci pati cáwii ca citoom, inniyeno ti pilemeyu pa kati ínnihin kíiti miin ma ŋaasuwan niŋ músupak ma miti Israyel.” ");
INSERT INTO krx_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Fiye, Yéesu naasok Simon: “Simon, Simon, síitan. Seetaani ewufaneewufan kayine kiti káahaafeen aluu samat nii uli, kápikatinool cácuuf ca niŋ kilehut ka. ");
INSERT INTO krx_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pale inci luumaaluum kitii ancuk káyinan ka kitii timpi kuñoho puson, niŋ áañohooniyoo peti inci impampaŋan pakani ti káyinan.” ");
INSERT INTO krx_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piyeer naasokoo: “Ahámpaatiin, inci siiŋaasiiŋo pikaayu niŋ awe ti ékuluma háati eket niŋ awe.” ");
INSERT INTO krx_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yéesu naañahanoo: “Piyeer, inci pusoki, fíyooy káayiin ekutoon kúlookum áafalaacin fo ñáhaaciil nii áameyiyam-méyi.” ");
INSERT INTO krx_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Púful toko Yéesu naasok pinapana pa pakateyoo: “Ta inci impoñe ta aluu peeyekanut mañ, peeyekanut epootak, peeyekanut pisamata púsupiyenu, weyme innitaakut po?” Nkasokoo: “Waah óo waah nuutaake po.” ");
INSERT INTO krx_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Naasokii: “Fiye, an eetaake mañ naacoopool mo, aŋa lompo eetaake epootak naacoopool yo, aŋa eetaakut káakuntu anooman hísool ha hiteyoo henfakat ha naanoom koonool. ");
INSERT INTO krx_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kaatuko inci pusok aluu: Heekiicee ha kutoom ti hilim ha hiti Pútuun pa fo hitaako. Hisok: 'Nkacokoo samat nii áhina heenaput.' Pánipani, heekiicee ha ti inci efihitaako.” ");
INSERT INTO krx_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Pinapana pa pakateyoo nkasokoo: “Ateeteyo ehe úkuntu úsupak.” Naasokii: “Fomaa.” ");
INSERT INTO krx_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yéesu náaful ti saatee ya apikaay pati cítintiŋ ca enca nkasok ca Olif samat nii fa naasale fa íhinu. Pinapana pa pakateyoo nkanapool neyoo. ");
INSERT INTO krx_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kapucol po, naasokii: “Niluum timpi ninow ti híluuŋu.” ");
INSERT INTO krx_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Naateeŋo caahinkiŋ ápilaaŋii, náakilipo, naaluum: ");
INSERT INTO krx_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Paapaa, niŋ súumuu, fúlan elontoŋ ya eti kúnuul enke ti inci, apan timpi yeno ti pálafi pa putoom, pale ti pitii pa.” ");
INSERT INTO krx_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Maleekoo néefulii alacana epipenanoo sempe. ");
INSERT INTO krx_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ti oom kúnuul kenfakat Yéesu naapenan kaluum meemak fo hásuwat ha hiteyoo níhifulii nihisotal t’etaam pucuk nii hísim. ");
INSERT INTO krx_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Apílitoonii ti kaluum enkuu, náañohoonii peti pinapana pa pakateyoo náatookiyii ti hiŋotu kamma kúnuul. ");
INSERT INTO krx_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Naacakanii: “Weyme uwune ínniyemi ti hiŋotu? Nilito inniluum ancuk timpi ninow ti híluuŋu.” ");
INSERT INTO krx_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yéesu ti káakup, kayoŋ nkúcolii teyoo. Ti kayoŋ ka, intaako toko ñíhampaatiin puwaaseena pakati Pútuun, niŋ ñíhampaatiin pakati púwuulu pa keeyeniye ka efaas ekumpaan ya enfakat ya eti Pútuun pa, niŋ pakakee ñíhampaatiin. Judas, akee ti pinapana pa ŋaasuwan niŋ pákasupak paka, anowii hátikin. Naaloh Yéesu kati asumpoo. ");
INSERT INTO krx_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pale Yéesu naasokoo: “Judas niŋ hisumpu ánfule ti inci, Añii An!” ");
INSERT INTO krx_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ta pinapana pa pakateyoo nkacuke ta heekaakaay ha pitaako nkacakanoo: “Ahámpaatiin, fo unii úfulanii úkuntu wa utoonii?” ");
INSERT INTO krx_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Akee teyii náañakii káakuntu ka kiteyoo naafiit cat kaanuu káali ka kiti amiikan a ati awaaseena ya enfakat a. ");
INSERT INTO krx_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pale Yéesu naasok: “Nikat po, eehe hifomaa!” Náalik kaanuu áyiin a náakuuñan ko. ");
INSERT INTO krx_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Fiye, Yéesu naasok ñíhampaatiin ña kéekeyii ka hicokuyoo: “Fo inci akanca? Weyme ínnikeyii ti inci niŋ úkuntu niŋ kifiin? ");
INSERT INTO krx_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Hinak óo hinak inci iyyeniye niŋ aluu ti hank ha hiti ekumpaan ya enfakat ya eti Pútuun pa, nicokutam. Pale, caanak ence citaaluu niŋ citi sempe sa siti énimaan ya.” ");
INSERT INTO krx_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Fiye, nkacok Yéesu, nkacoopoo la ti ekumpaan ya eti awaaseena ya enfakat a ati Pútuun pa. Piyeer ti pílaaŋ naayeniyii kanapan. ");
INSERT INTO krx_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nkacokan seemak senfakat ti pututa hank ha nkayeno kápikiipool so, Piyeer naayeno neyii. ");
INSERT INTO krx_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Amiikan aal naacukoo naayeniye toko pukol seemak sa. Naasincanoo púsooni naasok: “Ayíin aŋe lompo ayenaayeno niŋ Yéesu!” ");
INSERT INTO krx_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pale Piyeer náalaacin ho naasok: “Iññáayuu, inci míitoo!” ");
INSERT INTO krx_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pifiyo caahinkiŋ, akee naacukoo naasok: “Awe lompo akee ti pinapana pa pakateyoo!” Piyeer naasok: “Haani, inci neetaat.” ");
INSERT INTO krx_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Máamun etalaŋ yoonool eemuuse, akee naaŋiino ti hisoku: “Pánipani áyiin aŋe ayenaayeno niŋ Yéesu kaatuko akina lompo ati Galilee!” ");
INSERT INTO krx_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Piyeer naasok: “Haani, inci míit eeha ayyem ti hisoku!” Akina ti káakup, tokotoko káayiin ekutoon nkúlookii. ");
INSERT INTO krx_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ateeteyo náayesoonii naasincan Piyeer caw. Piyeer náanawuno hilim eeha Ateeteyo naasokoo ha: “Fíyooy, káayiin ekutoon kúlookum áafalaacin fo ñáhaaciil nii áameyiyaam-méyi.” ");
INSERT INTO krx_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Náaful tíkitaaŋ naakooŋ meemak niŋ kúnuul. ");
INSERT INTO krx_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Pákayiin paka keeyeniye ka efaas Yéesu nkápalahooloo nkalenkenoo, nkasapoo. ");
INSERT INTO krx_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nkacenk ñíkinoo nkasokoo: “Yaamakool! Sok unii ayme ayemuu ti hisapu?” ");
INSERT INTO krx_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nkateñaloo niŋ hícump kikee kilim. ");
INSERT INTO krx_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Cipilap, ñíhampaatiin ña pakati Pusuwif pa, niŋ ñíhampaatiin puwaaseena pa pakati Pútuun pa, niŋ pikalaŋana hilim ha heesiiŋanee ha hiti Móyiis nkaconcool. Yéesu náacoopiyee hátikinii. ");
INSERT INTO krx_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nkacakanoo: “Sok unii fo awe yem Eenucee ya ati Pútuun pa?” Yéesu naañahanii: “Niŋ inci ñahanaa aluu, étiniyinanam. ");
INSERT INTO krx_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Niŋ inci cakanaa aluu, etiniñahanam. ");
INSERT INTO krx_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pale písik fíyooy, inci, Añii An, fayeno ti epees yáali eti Pútuun pa piti sempe.” ");
INSERT INTO krx_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Poko púlooŋ nkacakanoo: “Awe aŋuu yem Añii ya ati Pútuun pa?” Yéesu naañahanii: “Aluu himuum aluu nisoke nii inci yem akina.” ");
INSERT INTO krx_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Fiye, nkasok: “Usoolahutaa hísiyu hiti akee eetantake! Usíyaasi ho ti putumoo!” ");
INSERT INTO krx_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ta nkapaye ta hísiyu Yéesu pákupaloo, ñíhampaatiin ña nkalito ti coonool, nkacoop Yéesu hátikin Pilaat, ati hikaw ha ati Judaay. ");
INSERT INTO krx_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kapucol nkáyaañoo hinooku nkasok: “Ayíin aŋe nuutooke ti kanoŋan pakan unaa, naakitii cooy kúncoo ya eti amansa ya enfakat a ati Room, apan naasokoolo nii akina ayem Eenucee ya ati Pútuun pa, amansa ya.” ");
INSERT INTO krx_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilaat naacakan Yéesu: “Fo awe yem amansa ya ati Pusuwif pa?” Yéesu naañahanoo: “Awe soke ho.” ");
INSERT INTO krx_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilaat naasok ñíhampaatiin puwaaseena pa pakati Pútuun pa niŋ kayoŋ ka: “Inci cukut heewune áyiin aŋe kati áhinee kíiti.” ");
INSERT INTO krx_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pale, nkaŋiino kapusok: “Ti pakalaŋanaloo naayem ti kanoŋan pakan paka. Galilee náacookii, náanapii ti mah ma miti Judaay púlooŋ, fiye ácoliyoo le.” ");
INSERT INTO krx_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilaat ápisi eehe naacakan: “Fo áyiin aŋe ati Galilee?” ");
INSERT INTO krx_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ta náasiye ta nii Yéesu ti mah emma Helot naayekane ma náafulii, naasokii kacoopoo pateyoo, ti oom caanak Helot naayeno Jerusalem. ");
INSERT INTO krx_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helot ásiyaasi hiti Yéesu, náalafiyoo hicuku ta infiyye. Náayinan nii afaacukoo ti íhinu heecukantee. Fiye naacukoo, ínsuumoo meemak. ");
INSERT INTO krx_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Naacakanooloo meemak, pale Yéesu añahanutoo máati poonool. ");
INSERT INTO krx_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ñíhampaatiin puwaaseena pa pakati Pútuun pa niŋ pikalaŋana hilim ha heesiiŋanee ha hiti Móyiis nkayeno toko nkanookoo niŋ sempe. ");
INSERT INTO krx_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Helot niŋ pusoocaali pa pakateyoo, nkápalahool Yéesu nkalenkenoo nkáwiiniyanoo. Nkásooloo hísool heewalla nkañahanoo pati Pilaat. ");
INSERT INTO krx_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Púcook puu, Pilaat niŋ Helot an niŋ akamooloo, pale hinoom eehuu nkáwiyool. ");
INSERT INTO krx_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Fiye, Pilaat naayonkal nantoonool ñíhampaatiin puwaaseena pa pakati Pútuun pa, ñíhampaatiin ña niŋ pakan paka, ");
INSERT INTO krx_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","naasokii: “Nícoopiyaam-coop áyiin aŋe innisok: 'Akina ayem ti kanoŋan pakan paka.' Nisincan, hátikin aluu inci incakanooloo ti eeha inninookoo ha, pale cukut heewune fanfaŋ kati áhinee kíiti. ");
INSERT INTO krx_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Háati Helot lompo acukut la naamuuyene, kamma náañahaniyoo unaa. Pánipani, áyiin aŋe áhinut waah ewwa efuuwun kati amukee. ");
INSERT INTO krx_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ekina ewune, inci fáhin apisapee, nkatanoo.”  ");
INSERT INTO krx_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ti coonool kayoŋ ka púlooŋ nkíceekii: “Mukoo! Inkatan unii Palapas!” ");
INSERT INTO krx_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Palapas akuleekul kamma naanoŋane pakan paka fo nkátaakoolane ñíhampaatiin saatee ya, naamuk an.) ");
INSERT INTO krx_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Fiye, Pilaat náalafi kakatan Yéesu, nene ákup niŋ kayoŋ ka. ");
INSERT INTO krx_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pale kayoŋ ka nkutowo ti hiceeku meemak: “Pempeŋoo ti kuluwaa! Pempeŋoo ti kuluwaa!” ");
INSERT INTO krx_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Fiye, Pilaat naacakanii píhaaciyenu: “Weyme uwune? Eeheyme heenaput náahine? Inci cukut waah ewwa efuuwun kati amukee. Inci fáhin apisapee, nkatanoo.” ");
INSERT INTO krx_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pale nkutowo ti kaaceeceekool kupusok: “Pempeŋoo ti kuluwaa!” Ti pikelan, kilimii nkihaŋ sempe. ");
INSERT INTO krx_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Fiye, Pilaat naacoon íhinu eeha nkasokoo ha. ");
INSERT INTO krx_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Naakatan Palapas, aŋa nkasokoo ya akatan, eekulee ya kamma naanoŋane pakan paka fo nkátaakoolane ñíhampaatiin saatee ya, naamuk an. Pale naawufan Yéesu pusoocaali pa kápihinoo samat nii fa Pusuwif pa nkálafiye fa. ");
INSERT INTO krx_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ta nkayeniye ta hicoopu Yéesu, nkapaakool niŋ áyiin ati Silen aŋa nkasok Simon, eeyeniye énakoonii ti saatee ya. Pusoocaali pa nkacokoo, nkatiyanoo kuluwaa ya apunow puson Yéesu. ");
INSERT INTO krx_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kayoŋ kenfakat nkiyeniyoo kanapan, pakaal pakati Jerusalem nkayeno pukooŋ niŋ esampoolo kiteyoo. ");
INSERT INTO krx_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yéesu náayesoonii lipa teyii naasokii: “Pakaal Jerusalem, timpi nikooŋ kutoom, nikooŋ kitaaluu niŋ kiti epuuk aluu! ");
INSERT INTO krx_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nisincan, caanak unca ti ékey ta efikasok ta: 'Kayihaa picaakonta pa, keetaapala kataak añii niŋ payenka taapala kácuuwan ka.' ");
INSERT INTO krx_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ti oom caanak, 'pakan paka efikasok pítintiŋ pa: \"Nínowii toonii!\" niŋ mítintiŋ ma: \"Níwufalool unii!\"' ");
INSERT INTO krx_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“Kaatuko niŋ káhinaa pínapaati fiye ti enuun ya eemaaña ya, puume eficuk ti enuun ya eesuuce ya?” ");
INSERT INTO krx_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nkacoopool lompo pikanca pákasupak kati kamukee ti coonool niŋ Yéesu. ");
INSERT INTO krx_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kapucol la nkasok la “Esent”, pusoocaali pa nkapempeŋ Yéesu ti kuluwaa ya. Nkapempeŋ toko lompo pikanca pákasupak, akee ti epeesoo yáali, akee ya epeesoo yaamay. ");
INSERT INTO krx_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yéesu naasok: “Paapaa, ponketii kamma nkámiit eeha nkayem ti íhinu.” Pusoocaali pa nkañak kaakaaw kápipaacinool wañ wa uteyoo. ");
INSERT INTO krx_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kayoŋ ka nkiyeno toko kaasincan. Ñíhampaatiin Pusuwif pa nkayeniyoo káapalahool nkalenkenoo, nkasok: “Pakakee pakan naafakane, afakanoolo, iyyema akina ayem Eenucee ya ati Pútuun pa, eemamalee ya”. ");
INSERT INTO krx_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pusoocaali pa lompo nkayeniyoo caalenken, nkalohoo nkawufanoo elaan eesipe. ");
INSERT INTO krx_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nkasok: “Niŋ awe yem amansa ya ati Pusuwif pa, fakanoolo!” ");
INSERT INTO krx_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Patiila ti hikawoo intaak pakiical peesoke: “Aŋe ayem amansa ya ati Pusuwif pa.” ");
INSERT INTO krx_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Akee ti pikanca pa eepempeŋee ya naateñaloo: “Fo aaneetaat Eenucee ya? Fakanoolo infakan lompo unii!” ");
INSERT INTO krx_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pale akee ya naafet teyoo naasok: “Aafeyut fala Pútuun, awe páyemali ti ñíseeña ña ñoonool ña ñiti eket ya neyoo? ");
INSERT INTO krx_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Anii, páhinal kíiti ya etaanii ecoonoolaa-coonool kamma immaayemaa ti cooy páhinal anii peenaput pa, pale áyiin aŋe áhinut waah weenaput.” ");
INSERT INTO krx_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Naasok: “Yéesu, náwuniyam naayeniyaa ti elemeyu ya etii.” ");
INSERT INTO krx_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yéesu naañahanoo: “Inci pusoki pánipani ya: Hinoom ha hiti fíyooy aafayeno niŋ inci alacana.” ");
INSERT INTO krx_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Máamun caanak ca ti hikaw, énimaan neeyeno ti mah ma púlooŋ fo sitalaŋ síhaaciil, ");
INSERT INTO krx_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","caanak ca inciyolo. Kahuuy ka kenfakat ka keeyem ka páhantuwa ekumpaan ya enfakat ya eti Pútuun pa nkihaaco ti pututa. ");
INSERT INTO krx_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yéesu náaceekii niŋ kaawiiluyoo, naasok: “Paapaa! Ti sipeesi inci iyyenane yaanam!” Apipa hisoku hilim eehuu, naaket. ");
INSERT INTO krx_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ahámpaatiin asoocaali ya, apucuk eehuu náamul Pútuun pa, naasok: “Pánipani, áyiin aŋe eecoonoole!” ");
INSERT INTO krx_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kayoŋ ka púlooŋ kéekeyii ka kaasincan kapucuk heetaakiye ha nkatiyo sipeesii, nkañoho niŋ esampoolo. ");
INSERT INTO krx_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yéesu pákawiyoo fiye púlooŋ niŋ pakaal paka kéenapoolii ka neyoo kápiliŋ Galilee nkasiiŋo pílaaŋ, nkayeno kaasincan heetaakiye ha. ");
INSERT INTO krx_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Intaako áyiin caacawoo Josef, ati saatee ya eti Pusuwif pa eyya nkasok ya Alimataay. Ayíin eenape, naacoonool, naayeno hítuulu ékey ya eti cáwii ca citi Pútuun pa. Naayeno akee ti ñíhampaatiin píhina kíiti ya pale asayanut eeha pákawiyoo nkacoke ha, nkáhin. ");
INSERT INTO krx_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Naakaay pati Pilaat naacakanoo ehunuŋ ya eti Yéesu. ");
INSERT INTO krx_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Púful toko náawananii ehunuŋ ya ti kuluwaa ya, naakuup yo niŋ kahuuy kiti ehok, naahok yo ti hiyaak heewakee ti énankiin la ammeya nii an ataapala ahokee. ");
INSERT INTO krx_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Iyyeno hinoom hiti kaamemanool, le niŋ hinoom ha hiti kayeno ka kiti Pusuwif pa éfihiyaañ. ");
INSERT INTO krx_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Pakaal paka kéenapoolii ka niŋ Yéesu kápiliŋ Galilee nkanow ti Josef nkacuk hiyaak ha niŋ fa ehunuŋ ya neehintanee fa lupo. ");
INSERT INTO krx_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Púful toko nkañoho pati saatee ya, nkamemanool munucu niŋ man méesuume haaw miti kaamaamool ehunuŋ ya. Ti hinoom ha hiti kayeno ka, nkáyekunoolo samat nii hilim ha heesiiŋanee ha fa nihisoke fa. ");
INSERT INTO krx_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Timaas ya nuulap, pakaal paka nkakaay pati hiyaak ha. Nkacoopool munucu ma niŋ man ma méesuume ma haaw emma nkamemanoole ma. ");
INSERT INTO krx_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Incakatook énankiin ya eepantane ya hiyaak ha néepalinkanee. ");
INSERT INTO krx_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nkanako, pale kacukut ehunuŋ ya eti Ateeteyo Yéesu. ");
INSERT INTO krx_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kámiit fa éfikamiilool. Tokotoko, pákayiin pákasupak nkáfulii teyii niŋ wañ weemiñale tas. ");
INSERT INTO krx_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ewatate enfakat neeyeno neyii, nkásitan. Pákayiin paka payenkuu nkasokii: “Weyme uwune ínniyemi ti hiŋes ti keekete ka aŋa eeyem ya kaloŋa? ");
INSERT INTO krx_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Aneetaat le, alitaneelitan ti keekete ka! Nínawuno eeha naasoke ha aluu ta naayeniye ta Galilee: ");
INSERT INTO krx_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","'Inci, Añii An, fo inci ufanee ti sipees pumuuyena pa. Fapempeŋee ti kuluwaa ya, ti hinoom ha híhaaciyenu ha fálitoonii ti eket ya.'” ");
INSERT INTO krx_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Fiye, nkánawuno kilim ka kiteyoo. ");
INSERT INTO krx_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Pakaal paka páfulaliyii pati hiyaak ha, nkañoho, nkakaman eehuu pupoñapoñ pa ŋaasuwan niŋ oonool a niŋ pakakee pinapana pa púlooŋ. ");
INSERT INTO krx_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Keekamane ka eehe pupoñapoñ pa kayem Mari ati Makatala, Yowanna, Mari íññaa ya ati Saak niŋ pakakee pakaal keeyeniye neyii. ");
INSERT INTO krx_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pale pupoñapoñ pa kacokut ho nii hilim heetaake hikaw, káyinanutii. ");
INSERT INTO krx_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Toko fiyaaw, Piyeer naalito niŋ katey fo pati hiyaak ha, náacuuhan acukut ehunuŋ fo kahuuy ka kiti kahok ka lamma. Naañoho pateyoo, ínnimoo ti heetaakiye ha. ");
INSERT INTO krx_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ti hinoom ha hoonool huu, pinapana pákasupak pakati Yéesu nkayeno pikaayu ti cisaatee enca nkasok Emmawus, ti pututa etenco niŋ Jerusalem sikilomeetal ŋaasuwan niŋ yoonool. ");
INSERT INTO krx_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nkayeno kákupat heetaakiye ha púlooŋ. ");
INSERT INTO krx_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ta nkayeniye ta kákupat niŋ pílaacinool, Yéesu himuumoo náakoliyii, naanapool neyii. ");
INSERT INTO krx_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nkacukoo pale waah nuukitii hikiiwuyoo. ");
INSERT INTO krx_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yéesu naacakanii: “Weyme ínnikupat ti pítin aluu?” Nkasiiŋo niŋ páciiteyii. ");
INSERT INTO krx_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Oonool teyii, caacawoo Kileyopas naasokoo: “Fo awe lamayi yem Jerusalem akaawoola éemiit heetaakiye ha ti kunoom enke?” ");
INSERT INTO krx_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yéesu naacakanii: “Hikina hiyem eeheyme?” Nkañahanoo: “Heetaakiye ha Yéesu ati Naasalet. Ayenaayeno ayaamakoola enfakat hátikin Pútuun pa niŋ pakan paka púlooŋ, náhin páhinal penfakat, náakup niŋ sempe. ");
INSERT INTO krx_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ñíhampaatiin puwaaseena pa pakati Pútuun pa niŋ ñíhampaatiin ña pakatuunaa nkawufanoo pakati Room kati káhinoo kíiti nkamukoo, nkapempeŋoo ti kuluwaa ya. ");
INSERT INTO krx_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pale unii, núuyinan hínum nii akina akaakaay kafakan Israyel. Apan ti eehe fiye púlooŋ, fíyooy yem hinoom ha híhaaciyenu ha ta eehe nihitaakiye ta. ");
INSERT INTO krx_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pakakee pakaal ti kayoŋ ka kutoonii nkaliimanool unii. Káfiisaafiis nuulap kapikaay pati hiyaak ha, ");
INSERT INTO krx_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kacukut ehunuŋ ya eteyoo. Nkáñohoonii, nkasok unii nii pumaleekoo nkacuke mpusokii nii oopa kaloŋa. ");
INSERT INTO krx_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Pakakee ti kayoŋ ka kutoonii nkakaay pati hiyaak ha, nkatook samat nii pakaal paka fa nkasoke fa pale kacukut Yéesu.” ");
INSERT INTO krx_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Fiye, Yéesu naasokii: “Aluu niyem pusoŋ, nicasut ti káyinan eeha púlooŋ piyaamakoola pa nkasoke ha! ");
INSERT INTO krx_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Fo Eenucee ya ati Pútuun pa añaŋut hicuku kúnuul enke apite anako ti hamake ha hiteyoo?” ");
INSERT INTO krx_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Púful toko, naayeniyii kakaman heesokee ha teyoo ti pakiical pa púlooŋ piti Pútuun pa, ápucook ti pakiical pa piti Móyiis fo ti pakiical pa piti piyaamakoola pa púlooŋ. ");
INSERT INTO krx_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ta nkalohane ta cisaatee ca enca nkayeniye ca tenco pikaayu, Yéesu náahin fiye nii himuusu. ");
INSERT INTO krx_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pale nkaŋiiniyoo ti hisoku: “Yeno le niŋ unii, kamma ínciniimiye, apan caanak ca unca ti ékey hicoku.” Naanako, naayeno neyii. ");
INSERT INTO krx_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ta nkayeniye ta kati kali, naacoop hímpuul ha naasok Pútuun pa apalaka, naafiit ho naawufanii. ");
INSERT INTO krx_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ñíkinii íññipankino nkakiiwoo pale naayemaŋ teyii feles. ");
INSERT INTO krx_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nkasokoolo: “Fo saan anii sisaput ti pítin pa, ta náahine ta kunuu anii kípipankino ti heesokee ha ti pakiical pa piti Pútuun pa?” ");
INSERT INTO krx_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tokotoko, nkalito mpacas, nkañoho Jerusalem. Incakatook pupoñapoñ pa ŋaasuwan niŋ oonool a la nkaconcoole la niŋ pakakee paka, ");
INSERT INTO krx_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ti hisoku: “Pánipani, Ateeteyo ayitaayito ti eket ya! Afúliyooful ti Simon!” ");
INSERT INTO krx_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Pinapana pa pákasupak paka payenkuu, nkakamanii heetaakiyii ha ti pítin pa niŋ puume nkakiiwe Yéesu ta naafiite ta hímpuul ha. ");
INSERT INTO krx_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Poko ti hisoku ha eehuu, Yéesu himuumoo náafulii ti pututayii naasokii: “Aluu kásuumaay!” ");
INSERT INTO krx_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nkáyolino, nkafe, incukii nii áfulaful nkacuke. ");
INSERT INTO krx_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pale Yéesu naasokii: “Weyme uwune inniliim? Weyme uwune innitaak pámiiloolal empuu? ");
INSERT INTO krx_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nisincan sipeesam niŋ wootam, aŋe inci himuumam! Nílikam innisincanam! Afúlaful ataakut enii niŋ picec, inci taakaataak samat nii fa innicuke fa.” ");
INSERT INTO krx_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ta naasoke ta eehuu, náayisanii sipeesoo niŋ wootoo. ");
INSERT INTO krx_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Innímii nkameeŋ niŋ pásuuma fo nkáyinanut. Yéesu naacakanii: “Nitaakut le waah uti hili?” ");
INSERT INTO krx_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nkawufanoo pífiitiin yoon eesowee. ");
INSERT INTO krx_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Naacoop po, naali po hátikinii. ");
INSERT INTO krx_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Fiye, Yéesu naasokii: “Ta inci iyyeniye ta niŋ aluu, sokaasok aluu: 'Heekiicee ha púlooŋ kutoom ti hilim ha heesiiŋanee ha hiti Móyiis, ti pakiical pa piti piyaamakoola pa niŋ ti pakiical pa piti Kícimu ka, eehuu púlooŋ fo hitaako.'” ");
INSERT INTO krx_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Fiye, Yéesu náapankin kunuuwii kati kási pakiical pa piti Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Naasokii: “Ehe heekiicee ha: Fo Eenucee ya ati Pútuun pa aket, ti hinoom ha híhaaciyenu ha náalitoonii ti eket ya. ");
INSERT INTO krx_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ehe eeha nkakaakaay ha káatuunan pakan paka púlooŋ, nkácook Jerusalem: 'Níwunko umuuyen wa utaaluu Pútuun pa kati puponket wo aluu ti caacawoo.' ");
INSERT INTO krx_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Aluu niyem keetantake ka eehe púlooŋ. ");
INSERT INTO krx_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Inci fápoñii aluu eeha Paapaa atoom náayinanane ha. Pale fo niyeno ti saatee eyye fo ta sempe sa siti patiila éfisiwanoonii ti aluu.” ");
INSERT INTO krx_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Púful toko, Yéesu naacoop pinapana pa pakateyoo fo kalohan cisaatee ca citi Betani. Náaseepin sipeesoo naasampanii. ");
INSERT INTO krx_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ta naayeniyii ta kaasampan, naakatanii, náaseepinee alacana. ");
INSERT INTO krx_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Pinapana pa pakateyoo nkákilipo, nkayeniyoo hímulu, nkañoho Jerusalem niŋ pásuuma penfakat. ");
INSERT INTO krx_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nkayeno tan óo tan hímulu Pútuun pa ti ekumpaan ya enfakat ya.");
INSERT INTO krx_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ti púcook pa, Hilim ha hitaakaataako. Hilim ha hiyenaayeno niŋ Pútuun pa, Hilim ha hiyem lompo Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nihiyeno niŋ Pútuun pa ti púcook pa. ");
INSERT INTO krx_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Pínapii teeho Pútuun pa mpíhine waah óo waah, waah úhinutee puson eteeho. ");
INSERT INTO krx_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Teeho eloŋ ya neeyem, oom eloŋ eyem lompo ecaaŋ ya eti pakan paka. ");
INSERT INTO krx_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ecaaŋ ya uyya ti hicaaŋu ti énimaan ya, pale énimaan ya eyinaat yo iheeku. ");
INSERT INTO krx_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pútuun pa mpúpoñii áyiin aŋa nkasok Saŋ. ");
INSERT INTO krx_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Akéyyookey kati ayeno eetantake ya naakaman pakan paka kiti ecaaŋ ya, ancuk pínapii teyoo pakan paka púlooŋ nkáyinan. ");
INSERT INTO krx_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Akina himuumoo aneetaat ecaaŋ ya pale ákeyyookey kati ayeno eetantake ya naakaman pakan paka kiti ecaaŋ ya. ");
INSERT INTO krx_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ecaaŋ eyyuu eyem ecaaŋ ya eti pánipani ya eyya necaaŋan pakan paka púlooŋ. Oom ecaaŋ ékeyii ti púlunta pa. ");
INSERT INTO krx_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Hilim ha hiyenaayeno ti púlunta pa, pínapii teeho Pútuun pa mpiliile púlunta pa, pale púlunta pa pímiit ho. ");
INSERT INTO krx_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Lateeho níhikeyii, pakan eteeho kawananut ho. ");
INSERT INTO krx_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pale pakakee nkawanan Hilim ha nkáyinan ti caacaw eteeho; oom pakan, Hilim ha níhihinii kápiyini éyenoonii epuuk Pútuun. ");
INSERT INTO krx_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kaneetaat epuuk Pútuun ti hipukuyee ha hiteyii niŋ fotom ti pálafi pa piti pupukayii, pale epuuk Pútuun kaatuko Pútuun pa puwufanii eloŋ éeyeeni. ");
INSERT INTO krx_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Hilim ha níhiyenoonii an naakin noonii, an éeyisane panap niŋ tooñaa fo muus. Ucukaacuk hamake ha hiteyoo, hamake eeha Paapaa ya Pútuun pa mpuwufane ha Añii etempo oonool a kóŋ. ");
INSERT INTO krx_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Saŋ átuunanaa-túunan kiteyoo, naaceek apusok: “Ehe aŋa inci ínkupe ya kiteyoo ta inci insoke ta: 'Oopa ti ékey pusonam, pale ahaŋaam hitaaku nafaa kaatuko ataakaataako inci táakumo.'” ");
INSERT INTO krx_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Unaa, ti panap pa piteyoo penfakat pa, naasampan unaa púlooŋ, nene apenan apisampan unaa. ");
INSERT INTO krx_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kaatuko hilim ha heesiiŋanee ha ti Móyiis níhinapii, pale panap pa niŋ tooñaa ya ti Yéesu Krista mpínapii. ");
INSERT INTO krx_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","An ataapala acuk Pútuun pa. Pale Añii ya oonool a kóŋ eeyem ya Pútuun pa, akina ayem hikaw Paapaa ya Pútuun pa, akina lompo áyisane po unaa. ");
INSERT INTO krx_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ehe eeha Saŋ naasoke ha ta nkacakanoo ta akina ayem ayme. Oom hinoom, pakati kikaw ka pakati Pusuwif pa pakati Jerusalem nkapoñ pakakee ti puwaaseena pa pakati Pútuun pa niŋ pakakee písisikana puwaaseena kapicakan Saŋ: “Awe yem ayme?” ");
INSERT INTO krx_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Saŋ náakup picaaŋ cataŋ, apookutii kañahan pale naasokii píhiini hat nii: “Inci neetaat Eenucee ya ati Pútuun pa.” ");
INSERT INTO krx_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nkacakanoo: “Ooto awe yem ayme? Awe yem Elí?” Saŋ naañahanii: “Haani inci neetaat akina.” Nkacakanoo: “Awe yem ayaamakoola ya?” Naañahanii: “Haani.” ");
INSERT INTO krx_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Fiye nkasokoo: “Ooto awe yem ayme? Unii uñaŋaa kañahan kéepoñii ka unii. Weyme aafasok kitii?” ");
INSERT INTO krx_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Saŋ naañahanii: “Inci yem aŋa naceek a ti káahaaŋ ka tes: 'Nicoonanool pítin pa piti Ateeteyo!' samat nii fa ayaamakoola ya Esaaya naasoke fa.” ");
INSERT INTO krx_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ti kéepoñiyee ka ti Saŋ, intaak Pufalisaay. ");
INSERT INTO krx_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nkacakanoo: “Awe, niŋ aaneetaat Eenucee ya, aaneetaat lompo Elí niŋ fotom ayaamakoola ya, ooto weyme uwune áaninhin pátise pakan paka?” ");
INSERT INTO krx_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Saŋ naañahanii: “Inci niŋ man ínhin pátise pale ti pututa aluu taakaataak an aŋa ínnimiit. ");
INSERT INTO krx_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Oom an áfaakey pusonam, inci túuniit fala kákopin ñikopu ña ñiti pisamata pa piteyoo.” ");
INSERT INTO krx_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Eehuu púlooŋ nihitaako ti saatee ya eti Betani pa caanak ca íncifulii pa ti musuu ma miti Jordan, pa Saŋ naayeniye pa íhinu pátise. ");
INSERT INTO krx_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Eti kacom eteyyo, Saŋ naacuk Yéesu ti ékey teyoo naasok: “Nisincan, ehe Císaacii ca citi Pútuun pa, enca íncifulan ca umuuyen wa uti pakan paka. ");
INSERT INTO krx_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Kiteyoo inci iyyeniye káakup ta inci insoke ta nii: 'Ayíin oopa ti ékey pusonam pale ahaŋaam hitaaku nafaa kaatuko ataakaataako inci táakumo.' ");
INSERT INTO krx_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Inci míitoo hínum pale kati áyisanee pakati Israyel ewune inci ínkey íhinu pátise niŋ man.” ");
INSERT INTO krx_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Saŋ nene ákup picaaŋ cataŋ naasok: “Inci cukaacuk Kunuu ka keenape ka nkúfulii patiila nkúwanoonii samat nii hícuucuuku, nkiyeno teyoo. ");
INSERT INTO krx_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Inci míitoo hínum, pale aŋa éepoñiyaam ya íhinu pátise niŋ man asokaam: 'Aŋa ankaakaay a hicuku Kunuu ka keenape ka nkúwanoonii teyoo nkiyeno teyoo, aŋuu akaakaay pátise niŋ Kunuu ka keenape ka.'” ");
INSERT INTO krx_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Saŋ nene asok: “Cukaacuk ho, ínkup kiti eeha inci incuke ha insok nii, akina ayem Añii ya ati Pútuun pa.” ");
INSERT INTO krx_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Eti kacom eteyyo, Saŋ nene ayeno toko kasiiŋ niŋ pákasupak ti pinapana pa pakateyoo. ");
INSERT INTO krx_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ta Yéesu naamuuse ta, Saŋ naasincanoo naasok: “Aha Císaacii ca citi Pútuun pa!” ");
INSERT INTO krx_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Pinapana pa pákasupak paka pakati Saŋ, ta nkásiye ta kilim enkuu nkanapan Yéesu. ");
INSERT INTO krx_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yéesu naayeso naacukii ti kanapanoo naacakanii: “Weyme inniyem ti hiŋes?” Nkañahanoo: “Rabi” (ekina eyem “Akalaŋana eemaka”), “peyme ankine?” ");
INSERT INTO krx_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Naañahanii: “Níkey efinicuk.” Nkakaay nkacuk la naakine la, máamun ta incisape ta eyam, nkahankanool hinoom ha neyoo. ");
INSERT INTO krx_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Aŋa nkasok a Andre, Simon Piyeer atuwoo, akee ti pákasupak paka kéesiye ka kilim ka kiti Saŋ nkanapan Yéesu. ");
INSERT INTO krx_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Náatikin apicaasok púnuwoo Simon: “Ucukaacuk Mesi ya” (ekina eyem “Eenucee ya”). ");
INSERT INTO krx_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Naacoop Simon pati Yéesu. Yéesu naasincanoo naasokoo: “Awe yem Simon, Saŋ añiinoo, pale fiye aafasokee Kefas” (ekina eyem “énankiin”. Ti kaŋ ya eti Kilek, Kefas ekina eyem Piyeer.) ");
INSERT INTO krx_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Eti kacom eteyyo Yéesu naasiiŋo pikaayu Galilee, naakaay apipaakool niŋ Filip, naasokoo: “Nápaniyam!” ");
INSERT INTO krx_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Oom Filip ati Petesayit, saatee ya eti Andre niŋ Piyeer.) ");
INSERT INTO krx_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Púful toko, Filip naakaay apipaakool niŋ Natanayel naasokoo: “Ucukaacuk aŋa Móyiis naakiice ya kiteyoo ti hilim ha heesiiŋanee ha, aŋa piyaamakoola pa nkakiice ya kiteyoo lompo. Akina ayem Yéesu ati Naasalet, añii ya ati Josef.” ");
INSERT INTO krx_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanayel naasokoo: “Fo waah weenape úyiniyini éfulii Naasalet?” Filip naañahanoo: “Kéy, aafacuk.” ");
INSERT INTO krx_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ta Yéesu naacuke ta Natanayel ti élohiyoo náakup kiteyoo naasok: “Ehe ati Israyel pánipani, kincaam kineetaat teyoo.” ");
INSERT INTO krx_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanayel naacakanoo: “Puume ammeyaam?” Yéesu naasokoo: “Filip áyonkalumi, cukuucuk ta ayyeniye ta t’etaam enuun sootoo ya.” ");
INSERT INTO krx_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Fiye Natanayel naasokoo: “Rabi, awe yem Añii ya ati Pútuun pa, awe yem Amansa ya ati Israyel!” ");
INSERT INTO krx_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yéesu naañahanoo: “Fo áayinanaayinan kamma inci insokuu nii cukuucuk t’etaam enuun sootoo ya? Aafancuk waah wenfakat pihaŋ le.” ");
INSERT INTO krx_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nene apenan ti hisoku: “Inci pusok aluu pánipani ya, efinicuk patiila mpánkinee, pumaleekoo pa piti Pútuun pa mpiyeno pisilo niŋ éwanoonii ti inci, Añii An.” ");
INSERT INTO krx_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Eti tanta eteyyo, intaako pinimo ti mah ma miti Galilee ti saatee ya eti Kana. Yéesu íññaa ateyoo naayeno toko. ");
INSERT INTO krx_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yéesu lompo naayonkalee niŋ pinapana pa pakateyoo. ");
INSERT INTO krx_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Fiye elaan ya neepa, Yéesu íññaa ateyoo naasokoo: “Elaan ya epayaapa.” ");
INSERT INTO krx_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Pale Yéesu naañahanoo: “Aaluu, weyme uwune ansokam eehuu? Caanak ca citoom ciloot cícolii.” ");
INSERT INTO krx_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Iññáa ateyoo naasok píhina pa: “Níhin waah óo waah ewwa naasoke aluu.” ");
INSERT INTO krx_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Toko, intaak sipala siti pínankiin seewucee siyema isak niŋ yoonool, nenso Pusuwif pa nkásikool kati nkakuulanoolo. Epala óo epala éyiniyini kayekan máamun siliital áwii epaakiil (80) puwant keme niŋ áwii (120). ");
INSERT INTO krx_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Fiye Yéesu naasok píhina pa: “Nimeeŋan pipala pa niŋ man.” Nkameeŋan po tuk. ");
INSERT INTO krx_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yéesu naasokii: “Nikaas innica niwufan áhampaatiin a ati píhina pa.” Nkáhin fo. ");
INSERT INTO krx_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ahámpaatiin a ati píhina pa naasiikan man ma meeyesanee ma elaan, ámiit peyme néefulii pale píhina pa kéeyookii ka man ma kámeyimeyi. Fiye náayonkalii asaya ya ");
INSERT INTO krx_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","naasokoo: “Pakan paka púlooŋ ti elaan éesuume ya nkácook; niŋ kákumanaa, conko káfulanii éesuumut ya. Pale awe immank éesuume ya fo fiye.” ");
INSERT INTO krx_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Eehuu hiyeniye píyisan pa púcook pa empa Yéesu náahine pa. Náahin oom píyisan píyaañ ti mah ma miti Galilee ti saatee ya eti Kana. Fiyuu Yéesu náayisane hamake ha hiteyoo, pinapana pa pakateyoo nkáyinan teyoo. ");
INSERT INTO krx_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Púful toko naawano ti saatee ya eti Kafaanawum niŋ íññaa ateyoo, pakatuwoo niŋ pinapana pa pakateyoo pale afiyiit po, máamun lóokuŋ. ");
INSERT INTO krx_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pahaaño pa piti Pusuwif pa empa nkasok pa Himuusu ha mpúlohanii, Yéesu naasilo Jerusalem. ");
INSERT INTO krx_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Naatook ti hank ha hiti ekumpaan ya enfakat ya eti Pútuun pa punoomana síis, písaacii niŋ kúcuucuuku, niŋ lompo púfaliŋa mañ keeyeniye ti pitaapul pa piteyii. ");
INSERT INTO krx_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Fiye naamemanool hisawut hiti ñikopu, hikina naacoope apiyaanii poko púlooŋ ti hank ha hiti ekumpaan ya enfakat ya niŋ lompo písaacii pa niŋ síis sa. Naahancalool mañ ma miti púfaliŋa pa naahalapal pitaapul pa mpunowal. ");
INSERT INTO krx_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Naasok punoomana kúcuucuuku ka: “Nífulan aŋe púlooŋ le! Timpi níhin ekumpaan ya eti Paapaa atoom ekumpaan énoomanuma!” ");
INSERT INTO krx_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Pinapana pa pakateyoo nkánawuno heekiicee ha ti hilim ha hiti Pútuun pa, hisok: “Pálafi empa inci íllafiye pa ekumpaan ya etii, efipumukam.” ");
INSERT INTO krx_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Fiye, pakati kikaw ka pakati Pusuwif pa nkacakanoo: “Eeha ayyem ha fiyuu ti íhinu, empeyme píyisan áafahin aakati yísan unii nii aañaŋaañaŋ ho íhinu?” ");
INSERT INTO krx_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yéesu naañahanii: “Nihancalool ekumpaan eyye, kunoom kíhaaciil inci nene litan yo.” ");
INSERT INTO krx_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nkasokoo: “Ekumpaan ya enfakat eyye ti sitiil áwii ésupak niŋ isak niŋ yoonool (46) neelutee, awe insok nii aafalitan yo ti kunoom kíhaaciil?” ");
INSERT INTO krx_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pale ekumpaan eyya Yéesu naayemii ya ti hisoku eyem eniinoo. ");
INSERT INTO krx_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Po hátikin, ta Yéesu náalitoonii ta ti eket ya, pinapana pa pakateyoo nkánawuno nii asokaasok ho hínum, nkáyinan ti heekiicee ha ti hilim ha hiti Pútuun pa niŋ ti kilim enka mpaasok ka. ");
INSERT INTO krx_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ta Yéesu naayeniye ta Jerusalem ti kunoom ka kiti pahaaño pa piti Himuusu ha, hícump pakan nkacuk píyisan pa peemeeŋe empa naayeniye pa íhinu, nkáyinan teyoo. ");
INSERT INTO krx_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pale Yéesu, ahintiitii kaatuko ámeyimeyi pakan paka púlooŋ. ");
INSERT INTO krx_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Asoolahut eetantake ápukupoo kiti pakan paka kaatuko akina himuumoo ámeyimeyi heeyem ha ti saanii. ");
INSERT INTO krx_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Intaak áyiin aŋa nkasok Nikodem ati kayoŋ ka kiti Pufalisaay pa, akee ti pakati kikaw ka pakati Pusuwif pa. ");
INSERT INTO krx_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Hikee hánant, náakey ti Yéesu naasokoo: “Rabi, úmeyimeyi nii Pútuun pa púpoñiyuu aakati kalaŋan unii, kaatuko an ayinaat íhinu píyisan empa ánhin pa niŋ Pútuun pa pineetaat neyoo.” ");
INSERT INTO krx_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yéesu naañahanoo apusokoo: “Inci pusoki pánipani ya, an átayini hicuku cáwii ca citi Pútuun pa taamanta apukutee nene.” ");
INSERT INTO krx_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodem naañahanoo: “Puume an eemaamane áfaayiniyee hipukuyee? Fo áfaayini puñoho ti munow íññaa ateyoo kati apukee púsupiyenu?” ");
INSERT INTO krx_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yéesu naasokoo: “Inci pusoki pánipani ya, an átayini pinako ti cáwii ca citi Pútuun pa taamanta apukutee pínapii ti man niŋ ti Kunuu ka keenape ka. ");
INSERT INTO krx_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","An pakan napuk, pale an óo an aŋa Kunuu ka keenape ka nkupuke, akina kunuu. ");
INSERT INTO krx_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Aañaŋut piŋaŋo niŋ inci sokuu: 'Niñaŋee hipukuyee nene.' ");
INSERT INTO krx_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Eyam ya, pan óo pan ínsuume yo nesap, ánsi pasapal eteyyo pale áamiit peyme néefulii niŋ peyme neekaay. Fiyuu incuke ti an óo an eepukee ti Kunuu ka keenape ka.” ");
INSERT INTO krx_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Fiye Nikodem naacakanoo: “Puume eehuu nihiyina pitaako?” ");
INSERT INTO krx_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yéesu naañahanoo: “Awe eeyem ya akalaŋana éesiyiye ya ti mah ma miti Israyel, fo áamiit eehuu? ");
INSERT INTO krx_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Inci pusoki pánipani ya, unii eeha nuumeya ha núukup, núutuunan eeha nuucuk ha pale háati fo fiye, aluu nisayanut hilim ha hitoonii. ");
INSERT INTO krx_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Níyinanut ta inci insoke ta aluu kiti t’etaam, puume éfiniyinan niŋ inci sokaa aluu kiti patiila? ");
INSERT INTO krx_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","An asiliit patiila pati Pútuun pa niŋ neetaat inci, Añii An, éewanoonii ya ápufulii po. ");
INSERT INTO krx_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Samat nii fa Móyiis naacoope fa epululoola ya eesafee ya naacenk yo ti hikasap heehaane náaseepin yo ti káahaaŋ ka tes, fo lompo inci, Añii An, iññaŋee káaseepin, ");
INSERT INTO krx_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ancuk an óo an éeyinane ti inci afaataak eloŋ ya eepayantoo ya. ");
INSERT INTO krx_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kaatuko Pútuun pa fiye mpílafiye púlunta pa: pílafilafi púlunta pa fo mpuwufane Añii etempo oonool a kóŋ, ancuk an óo an éeyinane teyoo ataket pale naataak eloŋ ya eepayantoo ya. ");
INSERT INTO krx_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kaatuko Pútuun pa púpoñiyoot Añii etempo ti púlunta pa kati áhin pakan paka kíiti naasiiŋanii ti pisiya, pale pakan paka kati kafakanee pínapii teyoo. ");
INSERT INTO krx_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","An óo an éeyinane teyoo atasiiŋanee ti pisiya, pale an óo an éeyinanut teyoo, apayeepa kaasiiŋan ti pisiya, kaatuko áyinanut ti caacaw ca citi Añii ya oonool a kóŋ ati Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ehe heewune ha Pútuun pa mpikaakaay kaasiiŋan pakan paka ti pisiya: ecaaŋ ya ékeyyookey ti púlunta pa, pale pakan paka nkálafi énimaan ya pihaŋ ecaaŋ ya kamma páhinalii mpinaput. ");
INSERT INTO krx_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","An óo an aŋa náhin heenaput anataanat ecaaŋ ya náalaaŋ yo, kaatuko afeyaafe páhinaloo timpi pucukee niŋ hanakan palaw. ");
INSERT INTO krx_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pale an óo an aŋa nanap ti pánipani ya, áfaakey ti ecaaŋ ya, ancuk pakan paka kacukaa nii, eeha náhin ha, hikina Pútuun pa mpílafiye.” ");
INSERT INTO krx_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Púful toko, Yéesu niŋ pinapana pa pakateyoo nkakaay ti mah ma miti Judaay, naakampan po neyii naayeno pátise pakan paka. ");
INSERT INTO krx_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Saŋ lompo naayeno pátise ti saatee ya eti Ayinon pukol saatee ya eti Salim kaatuko toko taakaataak man meemeeŋe. Pakan paka nkatowo ti ékey íhinuyee pátise. ");
INSERT INTO krx_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Eehuu ta nihitaakiye ta, tempo Saŋ peeloot akulee. ");
INSERT INTO krx_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Fiye, pakakee ti pinapana pa pakati Saŋ nkácook pílaacinool niŋ akee Asuwif kiti ekuulanoolo ya eti cosaan ya eteyii. ");
INSERT INTO krx_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nkakaay pati Saŋ nkasokoo: “Sincan Rabi, áyiin a eeyeniye ya naawe ti kikee kaapii ka kiti musuu ma miti Jordan, aŋa ánkupe ya kiteyoo, akina lompo oopa ti íhinu pakan paka pátise, apan pakan paka púlooŋ unka ti pikaayu teyoo.” ");
INSERT INTO krx_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Saŋ naañahanii: “An ayinaat hitaaku háati waah niŋ Pútuun pa puwunutoo wo. ");
INSERT INTO krx_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Aluu himuum aluu niyenaayeno keetantake ka ta inci insoke ta nii: 'Inci tom yem Eenucee ya ati Pútuun pa, pale inci éepoñiyee hátikinoo lamma.' ");
INSERT INTO krx_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Aal a eeyem a ti ékey pinimo, ati áyiin a eeyemoo ya ti ékey esa. Ayíin a áwiyoo, eesiiŋiye ya toko, náasi kilim asaya ya nkúsuumoo meemak. Pásuuma empuu piyem ti inci, ínsuumam pántoon. ");
INSERT INTO krx_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Písiyo pa piteyoo piñaŋaa epenano, putoom pa mpíkaasino. ");
INSERT INTO krx_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Aŋa áfulii ya patiila ahaŋa an óo an; aŋa áfulii ya t’etaam, ati t’etaam, hiti t’etaam nákup. Aŋa áfulii ya patiila, ");
INSERT INTO krx_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","eeha naacuke ha náasi, hikina nasok, pale an asayanut hilim ha hiteyoo. ");
INSERT INTO krx_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Aŋa nasayan ya eeha nasok ha, áyisanaayisan nii áyinanaayinan eeha Pútuun pa mpusoke ha hiti pánipani. ");
INSERT INTO krx_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kaatuko aŋa Pútuun pa mpúpoñii ya, kilim etempo nasok, kamma Pútuun pa mpuwufanoo Kunuu ka keenape ka pántoon. ");
INSERT INTO krx_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Paapaa ya álafilafi Añii ya naañomanoo waah óo waah. ");
INSERT INTO krx_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Aŋa áyinane ti Añii ya ataakaa eloŋ ya eepayantoo ya, pale aŋa eepooke Añii ya atataak eloŋ, apan káñiken ka kiti Pútuun pa efikutowo teyoo.” ");
INSERT INTO krx_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yéesu náameyi nii Pufalisaay pa kásiyaasi nii akina oopa ti hitaaku niŋ íhinu pátise pinapana pihaŋ Saŋ ");
INSERT INTO krx_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(apan Yéesu tom faŋoo ayeniye íhinu pátise pale pinapana pa pakateyoo). ");
INSERT INTO krx_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Fiye, Yéesu náaful Judaay apuñoho Galilee. ");
INSERT INTO krx_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Añaŋaa hinapu ti mah ma miti Samali. ");
INSERT INTO krx_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ti oom pítin, Yéesu naacol ti saatee ya eyya nkasok ya Sikaa ti mah ma miti Samali, pukol etaam eyya Jakob naawune ya faw añiinoo Josef. ");
INSERT INTO krx_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","Toko ésaapun ya eti Jakob neeyem. Caanak ca ti hikaw, Yéesu naayok ti kasapal ka, naayeno pukol ésaapun ya, pinapana pa pakateyoo nkakaay ti saatee ya hinoom paliyal. Ti oom káayenuma, akee aal ati Samali náakey piyook. Yéesu naasokoo: “Wunam pilaan.” ");
INSERT INTO krx_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Aal a naañahanoo: “Pale awe Asuwif inci aal ati Samali, puume ayyinaam kaluum man?” Asokaasok eehuu kaatuko Pusuwif pa kanakanooliyantoo niŋ pakati Samali. ");
INSERT INTO krx_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yéesu naañahanoo: “Niŋ aameya hínum kawun ka kiti Pútuun pa, ímmeyi eeyemuu ya ti kaluum man, awe himuumi anti luumoo man, naawuni man miti eloŋ.” ");
INSERT INTO krx_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Aal a naasokoo: “Ahámpaatiin, awe taakut nikopu apan ésaapun ya éloosaaloos. Puume áafayini hitaaku man ma miti eloŋ eyyuu? ");
INSERT INTO krx_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Maamaa atoonii Jakob awufane unii ésaapun eyye, akina himuumoo le nalaan hínum, niŋ epuukoo niŋ pukoolee pa piteyoo. Fo an puume ancoke faŋi? Fo awe haŋoo hamake?” ");
INSERT INTO krx_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yéesu naañahanoo: “An óo an aŋa nalaan man emme, pálaani efinene pucokoo, ");
INSERT INTO krx_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","pale an óo an aŋa eelaane man emma inci uwwunoo ma, pálaani etinene pucokoo fo cancowiyaaw: man emma inci uwwunoo ma efimiyeno teyoo káapun kenfakat keekaakaayoo kawufan eloŋ ya eepayantoo ya.” ");
INSERT INTO krx_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Aal a naasokoo: “Ahámpaatiin, wunam ti man emmuu ancuk pálaani etinene pucokam, etinene wasoolo ékey piyook le man.” ");
INSERT INTO krx_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yéesu naasokoo: “Kaay cáayonkalii áyiini íññohoonii le.” ");
INSERT INTO krx_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Aal a naañahanoo: “Inci taakut áyiin.” Yéesu naasokoo: “Aasokaasok páni fa ansoke fa nii aataakut áyiin. ");
INSERT INTO krx_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kaatuko pákayiin isak antaake hínum apan aŋa ayyem ya fiye neyoo áyiini tom. Páni ansoke.” ");
INSERT INTO krx_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Aal a naasokoo: “Ahámpaatiin, inci cukaa nii awe ayaamakoola. ");
INSERT INTO krx_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Símaama unii, ti tíntiŋ eyye nkaluum Pútuun pa, pale aluu Pusuwif pa innisok nii, la ñaŋee la kaluum Pútuun pa yem Jerusalem.” ");
INSERT INTO krx_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yéesu naasokoo: “Aaluu, yínanam, caanak unca ti ékey, etinene niluum Paapaa ya ti tíntiŋ eyye lamma niŋ ekina tom Jerusalem. ");
INSERT INTO krx_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Aluu pakati Samali inniluumluum aŋa ínnimiit, unii Pusuwif pa nuuluum aŋa nuumeya, kaatuko ti Pusuwif pa Pútuun pa éfipinapii kati pifakan pakan paka. ");
INSERT INTO krx_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pale caanak unca ti ékey cícoliyoocol fala, ta sempe sa siti Kunuu ka keenape ka niŋ siti tooñaa ya éfisihin pakan paka kápiyenoonii puluuma pánipani pakati Paapaa ya, kaatuko payenkuu kayem puluuma pa payenka Paapaa ya naayem ka ti hiŋes. ");
INSERT INTO krx_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Pútuun pa, kunuu; sempe sa siti Kunuu ka keenape ka niŋ siti tooñaa ya, sikina lamma síyina íhinu pakan paka kápiyenoonii puluuma pánipani.” ");
INSERT INTO krx_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Aal a naasokoo: “Méyimeyi nii Mesi ya aŋa nkasok a lompo Eenucee ya ati Pútuun pa oopa ti ékey. Niŋ ákeyyoo afaakaman unii waah óo waah.” ");
INSERT INTO krx_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yéesu naasokoo: “Inci eeyem a fiye ti káakup naawe, inci yem akina.” ");
INSERT INTO krx_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ti oom káasiiŋuma, pinapana pa pakati Yéesu nkáñohoonii, ínnimii ta nkacukoo ta ti káakup niŋ aal. Pale háati oonool teyii acakanutoo: “Weyme állafiye?” niŋ ekina tom: “Weyme uwune áyyemi ti káakup niŋ aal aŋe?” ");
INSERT INTO krx_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Fiye, aal a naakat toko élumpa ya eteyoo naañoho ti saatee ya naasok pakan paka: ");
INSERT INTO krx_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Níkey nipisincan akee áyiin eesokaam waah wa púlooŋ ewwa inci ínhine wa. Fo áyiniyini piyeno Eenucee ya?” ");
INSERT INTO krx_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Fiye nkáfulii ti saatee ya nkakaay pati Yéesu. ");
INSERT INTO krx_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Eehuu púlooŋ ti pitaako, pinapana pa pakateyoo nkaŋiiniyoo nkasokoo: “Rabi, li waah!” ");
INSERT INTO krx_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pale naañahanii: “Inci taakaataak paliyal piti hili empa aluu ínnimiit.” ");
INSERT INTO krx_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Pinapana pa pakateyoo nkayeno picakanool: “Fo an ákeyyookey apuwunoo paliyal?” ");
INSERT INTO krx_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yéesu naañahanii: “Paliyal pa putoom piyem íhinu héesuume ha éepoñiyaam ya, impa páhin empa naawufanaam pa. ");
INSERT INTO krx_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Fo nisokantoo: 'Le niŋ kiim kipaakiil efuumaañaa'? Pale inci insok: níhaafin, innisincan ukit wa, útuuniyaa kaamaañ! ");
INSERT INTO krx_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Aŋa namaañ a oopa ti hisayu cooy ya eteyoo, naaconcenool paliyal, pikina piyem pakan paka keeyem ka ti ékey ti eloŋ ya eepayantoo ya. Ancuk aŋa nasuk a niŋ aŋa namaañ a efikataak pásuuma ti coonool. ");
INSERT INTO krx_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kusoku enke kiti páni: 'Akee nasuk akee naamaañ.' ");
INSERT INTO krx_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Inci poñe aluu nipimaañ kaakit enka ínnihinut. Pakakee káhine ko, aluu innimaañ páhin pa piteyii.” ");
INSERT INTO krx_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Hícump pakati Samali keekine ka ti oom saatee nkáyinan ti Yéesu kamma aal a naasokii: “Asokaamsok eeha púlooŋ inci ínhine ha.” ");
INSERT INTO krx_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ekina ewune pakati Samali ta nkacole ta pati Yéesu nkaluumoo apiyeno neyii, Yéesu naayeno neyii kunoom kúsupak. ");
INSERT INTO krx_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kéeyinane ka teyoo nkahaŋ toko nkameeŋe meemak kamma kilim ka kiteyoo, ");
INSERT INTO krx_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","nkasok aal a: “Fiye úyinanutoo kamma eeha ansoke ha unii pale kamma unii faŋ unii núusiyoo, núumeyi nii akina ayem Afakana ya pánipani ya ati púlunta pa.” ");
INSERT INTO krx_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kunoom ka kúsupak enkuu kupumuus, Yéesu náaful toko naañoho Galilee. ");
INSERT INTO krx_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Akina himuumoo mpaasok: “Ayaamakoola ámakiyanantee ti saatee ya eteyoo.” ");
INSERT INTO krx_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Fiye ta naacole ta Galilee, pakati toko nkawananoo kaatuko poko lompo kakaayaakaay pahaaño pa piti Himuusu haJerusalem nkacuk eeha púlooŋ naayeniye ha íhinu ti pahaaño pa. ");
INSERT INTO krx_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Púful toko, Yéesu náañohoonii Kana eti Galilee pa naayesane pa man ma elaan. Intaak áhampaatiin áhina ati amansa ya aŋa añiinoo akampaani éekuuñe ti saatee ya eti Kafaanawum. ");
INSERT INTO krx_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ta náasiye ta nii Yéesu áfuliyooful Judaay ápucolii Galilee, naakaay teyoo naaluumoo apuwano Kafaanawum káakuuñan akampaani ya ateyoo eeyem ya ti putum eket. ");
INSERT INTO krx_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yéesu naasokoo: “Taamanta nicukut píyisan niŋ weecukantee étiniyinan púlay!” ");
INSERT INTO krx_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ahína ya naañahanoo: “Ahámpaatiin, wano niŋ inci le niŋ añiinam afaaket!” ");
INSERT INTO krx_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yéesu naasokoo: “Kaay, añiini afaaloŋ.” Ayíin a náayinan hilim eeha Yéesu naasokoo ha, naakaay. ");
INSERT INTO krx_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ta naayeniye ta puñoho, pimiikan pa pakateyoo nkapaakoolanoo nkasokoo: “Añiini oopa kaloŋa!” ");
INSERT INTO krx_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Naacakanii: “Teyme naafisake?” Nkañahanoo: “Hukan papayal hili kawaay pasowe-eniinoo mpifisake.” ");
INSERT INTO krx_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Paapaa ya náapannum nii, tempo Yéesu naasokoo nii: “Añiini afaaloŋ.” Fiye akina niŋ miin ma miteyoo púlooŋ nkáyinan ti Yéesu. ");
INSERT INTO krx_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Eehuu hiyeniye píyisan pa púsupiyenu pa empa Yéesu náahine pa Galilee, ta náañohoonii ta ápufulii Judaay. ");
INSERT INTO krx_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Púful toko Yéesu naasilo Jerusalem kamma pikee pahaaño piti Pusuwif. ");
INSERT INTO krx_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Po Jerusalem, pukol Putum pa piti Písaacii pa, intaak éwacuma eelutee neetaak sícimpaŋ isak, eyya neyonkalee Petusata ti kaŋ ya eti Hiburu. ");
INSERT INTO krx_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ti oom pícimpaŋ pakan keemeeŋe kéekuuñe nkahinto: kéefuume, kéehute niŋ payenka nkanow niŋ efank. ");
INSERT INTO krx_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Intaak toko áyiin éehute fo sitiil áwii niŋ kaat niŋ síhaaciil (38). ");
INSERT INTO krx_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yéesu naacukoo la naahintiye la, náasi nii afiyyaa ti oom pacuk naasokoo: “Aálafilafi kafisak?” ");
INSERT INTO krx_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Eéhute ya naañahanoo: “Ahámpaatiin, taakut an eekaakaayam kámocan ti éwacuma ya niŋ man ma muwenee. Niŋ inci yeniyaa pikaayu, cólum, akee náatikinam.” ");
INSERT INTO krx_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yéesu naasokoo: “Lito! Coop kahun ka kitii inkaay.” ");
INSERT INTO krx_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tokotoko áyiin a náakuuñanee, náaseepin kahun ka kiteyoo náayaañ pikaayu. Eehuu ti hinoom ha hiti kayeno ka hiti Pusuwif pa nihitaakiye. ");
INSERT INTO krx_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ekina ewune pakati kikaw ka pakati Pusuwif pa nkasok áyiin a éekuuñanee ya: “Fíyooy hinoom ha hiti kayeno ka, aañaŋut káaseepin kahun ka kitii.” ");
INSERT INTO krx_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pale naañahanii: “Ayíin a éekuuñanaam a asokaam: 'Coop kahun ka kitii inkaay.'” ");
INSERT INTO krx_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nkacakanoo: “Ayme áyiin asokuu: 'Coop kahun ka kitii inkaay'?” ");
INSERT INTO krx_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pale éekuuñanee ya ámiit oom an kaatuko pakan paka kameeŋaameeŋ apan Yéesu naapuuto. ");
INSERT INTO krx_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Po hátikin, Yéesu naatook áyiin a ti ekumpaan ya enfakat ya eti Pútuun pa naasokoo: “Síitan! Aákuuñanee-kúuñan, timpi nene muuyen ancuk heehaŋe luu timpi hitaakiyi.” ");
INSERT INTO krx_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Púful toko, áyiin a naacaasok pakati kikaw ka pakati Pusuwif pa nii Yéesu ákuuñanoo. ");
INSERT INTO krx_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ekina ewune pakati kikaw ka nkáyaañ kaakallan Yéesu kamma naayeniye íhinu enkuu ti hinoom ha hiti kayeno ka. ");
INSERT INTO krx_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pale Yéesu naañahanii: “Paapaa atoom oopa ti páhin fo fiye, inci lompo oopa ti páhin.” ");
INSERT INTO krx_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Pañahanal empuu puwune pakati kikaw ka pakati Pusuwif pa nkahaŋ toko nkaŋese fa efikamuk Yéesu. Kaatuko Yéesu átuulut hinoom ha hiti kayeno ka, apan naasok nii Pútuun pa faafoo, apilehoolan faŋoo niŋ Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yéesu naañahan pakati kikaw ka: “Inci pusok aluu pánipani ya, Añii ya ayinaat íhinu waah faŋoo pale eeha nacuk ha ti Paapaa ya, kaatuko eeha Paapaa ya náhin ha, hikina Añii ya lompo náhin. ");
INSERT INTO krx_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Paapaa ya álafilafi Añii ya, náyisanoo eeha púlooŋ náhin ha. Afánayisanoo lompo weecukantee weehaŋe pafom ewwa inniyem wa fiye ti hicuku, ancuk aluu niŋaŋiyaa. ");
INSERT INTO krx_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Samat nii fa Paapaa ya nalitan fa keekete ka naawufanii eloŋ ya, fo lompo Añii ya naawufan eloŋ ya aŋa náalafiye ya. ");
INSERT INTO krx_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Apan Paapaa ya áhinantoo kíiti an, pale Añii ya naakate kati áhin kíiti, ");
INSERT INTO krx_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ancuk pakan paka púlooŋ kati kámakiyan Añii ya, samat nii fa nkámakiyan fa Paapaa ya. Aŋa éemakiyanut a Añii ya, ámakiyanut lompo Paapaa ya éepoñiyoo ya. ");
INSERT INTO krx_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Inci pusok aluu pánipani ya, aŋa éesiye hilimam náayinan aŋa éepoñiyaam ya, ataakaa eloŋ ya eepayantoo ya, átahinee kíiti pale áfuliyooful ti eket ya apinako ti eloŋ ya. ");
INSERT INTO krx_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Inci pusok aluu pánipani ya, caanak unca ti ékey cícoliyoocol fala, ta keekete ka éfikasi hilim ha hiti Añii ya ati Pútuun pa, apan keekaakaay ho ka hísiyu efikaloŋ. ");
INSERT INTO krx_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Samat nii fa Paapaa ya naayekane fa eloŋ ya ti himuumoo fo lompo naawufane Añii ya apiyekan eloŋ ya ti himuumoo. ");
INSERT INTO krx_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Naawufanoo kayine kiti íhinu kíiti kamma naayem Añii An. ");
INSERT INTO krx_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Timpi niŋaŋo kamma eehuu, kaatuko caanak unca ti ékey ta keeyem ka púlooŋ ti kiyaak ka éfikasi hilimoo, ");
INSERT INTO krx_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","nkálitoonii ti eket ya. Kéehine ka heenape ha éfikalitoonii ti eket ya nkataak eloŋ ya, kéehine ka heenaput ha éfikalitoonii ti eket ya nkasiiŋanee ti pisiya. ");
INSERT INTO krx_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Inci himuumam yinaat íhinu waah, eeha inci ínsiye ha ti Paapaa atoom inci nínhin kíiti. Páhinalam kíiti peecoonoole kaatuko ŋesut héesuumaam ha pale héesuume ha éepoñiyaam ya.” ");
INSERT INTO krx_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yéesu nene asokii: “Niŋ inci yeniyaa eetantake ya ati faŋam, eeha inci insok ha hiti pánipani tom. ");
INSERT INTO krx_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Akee ayeniye eetantake ya atoom, méyimeyi nii eeha naasoke ha kutoom hiti páni. ");
INSERT INTO krx_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Aluu, innipoñ pakan ti Saŋ, akina eetantake ya atoom naasok pánipani ya. ");
INSERT INTO krx_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Iyyema inci, soolahut an apiyeno eetantake ya atoom pale sokaasok enkuu kati nifakanee. ");
INSERT INTO krx_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Saŋ acukaacuk samat nii lampi eecaaŋanee picaaŋ cataŋ, ínsuum aluu hínum ti kakalaŋan ka kiteyoo ti caanak ceetama. Pakalaŋanal empuu pucukaacuk nii ecaaŋ enfakat. ");
INSERT INTO krx_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pale iyyema inci, taakaataak waah weetantake kutoom pihaŋ eeha Saŋ naasoke ha kutoom, ukina uyem weecukantee ewwa Paapaa ya naawufanaam wa píhin, íyyemi wo ti íhinu. Pikina mpíyisan nii Paapaa ya ápoñiyaam. ");
INSERT INTO krx_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Paapaa ya éepoñiyaam ya, akina himuumoo ayem eetantake ya atoom. Pale nitaapala nísi hilimoo, niŋ fotom hicuku himuumoo. ");
INSERT INTO krx_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Hilim ha hiteyoo hikinut ti saan aluu kaatuko níyinanut aŋa náapoñii ya. ");
INSERT INTO krx_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Innikalaŋkalaŋ pinap hilim ha hiti Pútuun pa kaatuko aluu nímiiloolaa-míilool nii tenko efinitaak eloŋ ya eepayantoo ya, ántuŋ kilim enkuu kutoom nkúkupe. ");
INSERT INTO krx_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pale innipook ékey ti inci kati nitaak eloŋ ya. ");
INSERT INTO krx_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Soolahut hímulu hiti pakan. ");
INSERT INTO krx_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pale méyimeyi aluu, nílafiit Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ti caacaw Paapaa atoom inci ínkeyii, nisayanutam. Niŋ akee ákeyyoo ti caacaw faŋoo efinisayanoo. ");
INSERT INTO krx_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","An óo an oopa ti hiŋes kámakiyan kéefulii ti áwiyoo, pale niŋesut kámakiyan ka kéefulii ka ti Pútuun pa poonool pa. Fiye, puume éfiniyiniyam káyinan? ");
INSERT INTO krx_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Timpi nímiilool nii inci fayeno anooka ya ataaluu hátikin Paapaa ya, anooka ya ataaluu ayem Móyiis aŋa ínnihine ya cíki. ");
INSERT INTO krx_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Niŋ níyinanaayinan Móyiis, anti níyinanam kaatuko kutoom naakiice. ");
INSERT INTO krx_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pale niŋ níyinanut eeha naakiice ha, puume éfiniyini káyinan hilimam?” ");
INSERT INTO krx_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Eehuu hipimuus, Yéesu naafiitan ti ekee ekink ya eti han ha hiti Galilee. Oom han nihisokee lompo han ha hiti Tipeliyas. ");
INSERT INTO krx_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kayoŋ kenfakat nkiyeniyoo kanapan kaatuko pakan paka kacukaacuk weecukantee ewwa naayeniye wa íhinu ti kéekuuñe ka. ");
INSERT INTO krx_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Púful toko, Yéesu naasilo ti tíntiŋ niŋ pinapana pa pakateyoo nkayeno. ");
INSERT INTO krx_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tempo Himuusu ha níhilohanii, pahaaño pa piti Pusuwif pa. ");
INSERT INTO krx_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yéesu naasincan naacuk kayoŋ kenfakat keeyeniyoo kanapan. Fiye, naacakan Filip: “Peyme éfuuyiniyaa hinoom kúmpuul pakan paka payenke púlooŋ kati kali?” ");
INSERT INTO krx_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Asokaasok eehuu kati awinko Filip kaatuko akina himuumoo ámeyimeyi eeha naakaakaay ha íhinu. ");
INSERT INTO krx_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip naañahanoo: “Háati niŋ cooy eti kiim isak niŋ hoonool etefom an óo an kati áyini hitaaku címpuul.” ");
INSERT INTO krx_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Akee ti pinapana pa pakateyoo aŋa nkasok a Andre, Simon Piyeer atuwoo, naasokoo: ");
INSERT INTO krx_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ehe cikee cikampaani ceetaake kúmpuul isak niŋ moon músupak. Fo efifom pakan paka púlooŋ?” ");
INSERT INTO krx_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yéesu naasokii: “Níhinii kapiyeno poko púlooŋ.” La nkayeniye la, kaameeŋ píheeni, nkayeno tempo. Pákayiin máamun síwuli isak (5,000) kayeniye toko. ");
INSERT INTO krx_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yéesu naacoop kúmpuul ka, naasok Pútuun pa apalaka, náapaacinool ko keeyeniye ka toko, náahin fo lompo moon ma, nkali fo kasiit. ");
INSERT INTO krx_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ta nkaliye ta poko púlooŋ fo kafoman, Yéesu naasok pinapana pa pakateyoo: “Niyesal mífiitiin ma meetowiye ma miti kúmpuul ka ancuk waah úmpuupuco.” ");
INSERT INTO krx_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nkayesal, nkameeŋan síyya ŋaasuwan niŋ súsupak ti pútowintiin pa piti kúmpuul ka isak ya enka nkaliye ka. ");
INSERT INTO krx_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Pakan paka kapucuk heecukantee eeha Yéesu naayeniye ha íhinu, nkáyaañ hisoku: “Pánipani, áyiin a aŋe ayem ayaamakoola ya eeñaŋe ya ékey ti púlunta pa!” ");
INSERT INTO krx_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pale Yéesu náameyi nii éfikahinoo amansa ti sempe, nene añako pati tíntiŋ ya lamayoo. ");
INSERT INTO krx_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ta ínciniimiye ta, pinapana pa pakati Yéesu nkawano pati han ha. ");
INSERT INTO krx_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nkáyuuko ti piteen nkáyaañ kaafiitan han ha kapuwant Kafaanawum. Caanak ca unca cicoke, Yéesu aloot ácolii teyii. ");
INSERT INTO krx_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Hiyam henfakat níhiyaañ hisapu, kúsuu ka nkihiñ. ");
INSERT INTO krx_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pinapana pa pakati Yéesu nkákus máamun sikilomeetal isak niŋ ekina tom isak niŋ yoonool, nkaŋantan Yéesu ti ésapalii ti man ma, ápulohiiloh piteen pa, nkafe. ");
INSERT INTO krx_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pale Yéesu naasokii: “Aŋe inci, timpi nife!” ");
INSERT INTO krx_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Pinapana pa nkálafiyoo híyuuku ti piteen pa. Emma nkáyuukoo ma, piteen pa mpihaaŋ ti hicolu la nkañaŋe la hiciŋu. ");
INSERT INTO krx_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Eti kacom eteyyo, kayoŋ ka keetowiye ka ti kikee kaapii ka kiti han ha nkápannum nii piteen poonool lamma piyeniye toko, apan nkámeyi nii Yéesu áyuukiit ti piteen pa niŋ pinapana pa pakateyoo, pale poko lamayii kakaaye. ");
INSERT INTO krx_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Fiye ñikee ñiteen íññifulii Tipeliyas iññiciŋ pukol la pakan paka nkaliye la kúmpuul ka, ta Ateeteyo naasoke ta Pútuun pa apalaka. ");
INSERT INTO krx_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ta pakan paka nkápannume ta nii Yéesu aneetaat toko, pinapana pa lompo kaneetaat toko, nkáyuuko ti ñiteen eññuu kapikaay Kafaanawum hiŋes Yéesu. ");
INSERT INTO krx_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ta nkacole ta ti ekee ekink ya eti han ha, nkatook po Yéesu nkacakanoo: “Rabi, teyme ánkeyii le?” ");
INSERT INTO krx_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yéesu naañahanii: “Inci pusok aluu pánipani ya, hiŋesuyam inniyaake neetaat kamma innicukale píyisan pa putoom ínniyinan ti inci, pale kamma inniliye kúmpuul fo nisiit. ");
INSERT INTO krx_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Paliyal empa mpúpuco, timpi puwas aluu páhin, pale níhin páhin piti paliyal empa mputowo fo eket maama piti eloŋ ya eepayantoo ya empa inci, Añii An, fawufan pa aluu. Kaatuko Paapaa ya eeyem a Pútuun pa píyisanaayisan nii inci mpuwufane sempe etempo.” ");
INSERT INTO krx_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nkacakanoo: “Weyme nuuñaŋe íhinu kati úhin eeha Pútuun pa mpílafiye ha?” ");
INSERT INTO krx_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yéesu naañahanii: “Eeha Pútuun pa mpílafiye ha hiyem nípiyinan ti aŋa mpúpoñii ya.” ");
INSERT INTO krx_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nkasokoo: “Fiye awe, empeyme píyisan áafahin, niŋ unii ucukaa po núuyinani? Weyme ankaakaay íhinu? ");
INSERT INTO krx_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Símaama unaa kaliyaali manna ti káahaaŋ ka tes, samat nii heekiicee ha ti hilim ha hiti Pútuun pa, hisok: 'Naawufanii kapili paliyal péefulii patiila.'” ");
INSERT INTO krx_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yéesu naasokii: “Inci pusok aluu pánipani ya, Móyiis tom awufane aluu paliyal pa péefulii pa patiila pale Paapaa atoom awufane aluu paliyal pa piti pánipani ya péefulii pa patiila. ");
INSERT INTO krx_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kaatuko paliyal pa empa Pútuun pa mpuwufane pa, pikina piyem an a éefulii ya patiila naawufan eloŋ ya púlunta pa.” ");
INSERT INTO krx_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nkasokoo: “Ahámpaatiin, wun unii hinak óo hinak ti oom paliyal.” ");
INSERT INTO krx_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yéesu naañahanii apusokii: “Inci yem hímpuul ha hiti eloŋ ya. An óo an éekeyii ti inci peep etipucokoo púlay. An óo an éeyinane ti inci pálaani etipucokoo púlay. ");
INSERT INTO krx_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pale samat nii fa inci insoke fa aluu: nicukaamcuk háati fo níyinanut. ");
INSERT INTO krx_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Pakan paka púlooŋ payenka Paapaa ya naawufanaam ka éfikakey ti inci, an óo an éekeyii ti inci etiyaanoo pántoon. ");
INSERT INTO krx_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kaatuko fúliyoot patiila kati hín héesuumaam ha pale héesuume ha éepoñiyaam ya. ");
INSERT INTO krx_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Eépoñiyaam ya álafiit púpuul háati oonool ti payenka naawufanaam ka, pale pilitanii ti eket ya ti hinoom ha hikelan ha hiti púlunta pa. ");
INSERT INTO krx_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kaatuko eeha Paapaa atoom náalafiye ha hiyem, pakan paka púlooŋ keecuke ka Añii ya te nkáyinanoo, oom pakan kataak eloŋ ya eepayantoo ya, inci illitanii ti eket ya ti hinoom ha hikelan ha hiti púlunta pa.” ");
INSERT INTO krx_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Fiye Pusuwif pa nkáyaañ káakumutool kiteyoo kamma naasoke nii: “Inci yem hímpuul ha héefulii ha patiila.” ");
INSERT INTO krx_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nkasok: “Fo aŋe Yéesu tom, Josef añiinoo, aŋa nuumeyaa ya faafoo niŋ íññaayoo? Puume áfaayini hisoku: 'Patiila inci ínfulii'?” ");
INSERT INTO krx_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yéesu naasokii: “Nikatan káakumutool ka! ");
INSERT INTO krx_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","An ayinaat ékey ti inci taamanta Paapaa ya éepoñiyaam ya áñakiyootoo ti inci, inci illitanoo ti eket ya ti hinoom ha hikelan ha. ");
INSERT INTO krx_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kiiceekiic ti pakiical pa piti piyaamakoola pa nii: 'Pútuun pa efipikalaŋanii poko púlooŋ.' An óo an éesiitane Paapaa ya naakalaŋ teyoo, áfaakey ti inci. ");
INSERT INTO krx_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","An ataapala acuk Paapaa ya niŋ neetaat éefulii ya pati Pútuun pa; akina acuke Paapaa ya. ");
INSERT INTO krx_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Inci pusok aluu pánipani ya, an óo an éeyinane, ataakaataak eloŋ ya eepayantoo ya. ");
INSERT INTO krx_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Inci yem hímpuul ha hiti eloŋ ya. ");
INSERT INTO krx_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Símaama aluu kaliyaali manna ya ti káahaaŋ ka tes, háati fo nkaket. ");
INSERT INTO krx_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pale paliyal empa inci insoke pa, pikina piyem paliyal pa péewanoonii pa púpufulii patiila, an óo an eeliye po ataket. ");
INSERT INTO krx_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Inci yem paliyal pa piti eloŋ ya péefulii pa patiila. An óo an eeliye ti paliyal empe afaaloŋ fo cancowiyaaw. Apan paliyal empa inci inkaakaay pa kawufan, pikina piyem eniinam. Inci fawufan po ancuk púlunta pa pitaakaa eloŋ.” ");
INSERT INTO krx_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Fiye Pusuwif pa nkáyaañ píñakalool penfakat nkasok: “Puume áyiin a aŋe naayina unaa kawufan eniinoo kati uliyaa?” ");
INSERT INTO krx_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yéesu naañahanii: “Inci pusok aluu pánipani ya, taamanta niliit enii inci, Añii An, innilaan hísimam, etinitaak eloŋ ya. ");
INSERT INTO krx_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","An óo an eeliye eniinam, naalaan hísimam ataakaataak eloŋ ya eepayantoo ya, inci illitanoo ti eket ya ti hinoom ha hikelan ha. ");
INSERT INTO krx_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kaatuko eniinam eyem paliyal pánipani, hísimam palaanal pánipani. ");
INSERT INTO krx_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","An óo an eeliye eniinam naalaan hísimam afaakin ti inci, inci lompo inkin teyoo. ");
INSERT INTO krx_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Paapaa ya éepoñiyaam ya oopa kaloŋa, inci lompo íyyemi kaloŋa kamma akina. Fo lompo incuke, an óo an eeliye eniinam afaaloŋ kamma inci. ");
INSERT INTO krx_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Paliyal empa inci insoke pa, pikina piyem paliyal pa péewanoonii pa púpufulii patiila, pucukut nii empa símaama aluu nkaliye pa púful toko nkaket. An óo an eeliye paliyal empe afaaloŋ fo cancowiyaaw.” ");
INSERT INTO krx_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Asokaasok enke akina ti kakalaŋan ka ti éluumuma ya eti Kafaanawum. ");
INSERT INTO krx_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ta nkásiye ta eehuu, hícump ti pinapana pa pakateyoo nkasok: “Pakalaŋanal empuu píciiticiiti! Ayme ayina po kasayan?” ");
INSERT INTO krx_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yéesu náameyi ti yaanoo nii pinapana pa pakateyoo, káakumutool eeha naasoke ha nkayaake, naasokii: “Fo kilim enkuu efikiñahan aluu puson ti káyinan ka kitaaluu? ");
INSERT INTO krx_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Puume facuk niŋ nicukaam, inci, Añii An, ti pisilo la inci iyyeniye la? ");
INSERT INTO krx_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kunuu ka kiti Pútuun pa nkuwufan eloŋ, sempe an sitaakut nafaa. Kilim enka inci ínkup ka aluu, kiti Kunuu niŋ eloŋ. ");
INSERT INTO krx_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pale pakakee taaluu káyinanut.” Yéesu asokaasok eehuu kaatuko ámeyimeyi kápiliŋ ti púcook pa pakayme káyinanut teyoo, náameyi lompo ayme akaakaay hífulu teyoo. ");
INSERT INTO krx_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nene asokii: “Eehe hiwune inci insok aluu nii, an ayinaat ékey ti inci taamanta Paapaa ya áñakiyootoo.” ");
INSERT INTO krx_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ti oom káasiiŋuma hícump ti pinapana pa pakateyoo nkakatanoo, nkáyekuno pinapool neyoo. ");
INSERT INTO krx_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Fiye Yéesu naacakan pinapana pa ŋaasuwan niŋ pákasupak paka: “Fo aluu lompo nílafiit pikaayu?” ");
INSERT INTO krx_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Piyeer naañahanoo: “Ahámpaatiin, ti ayme nuukaakaay? Awe yekane kilim enka nkuwufan ka eloŋ ya eepayantoo ya. ");
INSERT INTO krx_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Unii úyinanaayinan, núumeyi nii, awe yem Eesampanee ya ati Pútuun pa.” ");
INSERT INTO krx_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yéesu naañahanii: “Fo inci tom mamale aluu, aluu ŋaasuwan niŋ pákasupak paka? Pale háati fo, akee taaluu áhina páhin pa piti áhampaatiin a ati piseetaani pa!” ");
INSERT INTO krx_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Kiti Judas añii ya ati Simon Iskaliyot naayeniye káakup. Kaatuko akina akaakaay hífulu teyoo apan akee ti ŋaasuwan ya niŋ pákasupak paka naayem. ");
INSERT INTO krx_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Púful toko, Yéesu naafiitanool mah ma miti Galilee, álafiit kaafiitanool mah ma miti Judaay kamma pakati kikaw ka pakati Pusuwif pa nkayemoo po ti cíllopa kati kamukoo. ");
INSERT INTO krx_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tempo pahaaño pa piti Púkuut pa piti Pusuwif pa mpúlohanii. ");
INSERT INTO krx_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ti oom káasiiŋuma, Yéesu pakatuwoo nkasokoo: “Fúl le inkaay ti mah ma miti Judaay ancuk pinapana pa pakatii lompo kacukaa eeha ánhin ha! ");
INSERT INTO krx_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","An ayoliyantoo ti páhinoo niŋ álafiyaa písiyo; páawoo aapa ánhin enkuu, yísanoolo ti púlunta pa.” ");
INSERT INTO krx_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yéesu pakatuwoo kasokaasok eehuu kaatuko poko lompo káyinanut teyoo. ");
INSERT INTO krx_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yéesu naañahanii: “Caanak ca citoom ciloot cícolii, pale citaaluu ca, tan óo tan citempaatempo. ");
INSERT INTO krx_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Pakati púlunta pa kayinaat aluu hinatu; pale inci, kanataam-nat kamma inci insok tan óo tan nii páhinalii pinaput. ");
INSERT INTO krx_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Aluu nisilo pati pahaaño pa, samat inci etisilo pati pahaaño empuu, kaatuko caanak ca citoom ciloot cícolii.” ");
INSERT INTO krx_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ta naapaye ta káakup naatowo Galilee. ");
INSERT INTO krx_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ta pakatuwoo nkakaaye ta pati pahaaño pa, Yéesu lompo naakaay po, pale naayolo ti pikaayu péeyisanooliit. ");
INSERT INTO krx_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Pakati kikaw ka pakati Pusuwif pa nkayeniyoo hiŋes pati pahaaño pa, nkasok: “Ayíin a aŋuu uwwey?” ");
INSERT INTO krx_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ti kayoŋ ka pakan paka nkayeno pupuusanool kiteyoo. Pakakee nkasok: “Aŋuu áyiin eenape.” Pakakee paka nkasok: “Haani, kincaakool pakan paka naayaake.” ");
INSERT INTO krx_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pale an áhaañiit káakup kiteyoo niŋ hilim heeceeke kamma nkafeye pakati kikaw ka pakati Pusuwif pa. ");
INSERT INTO krx_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ta nkayeniye ta ti pututa pahaaño pa, Yéesu naasilo pati ekumpaan ya enfakat ya eti Pútuun pa naayeno kakalaŋan ti hank ha. ");
INSERT INTO krx_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Pakati kikaw ka pakati Pusuwif pa ínnimii nkasok: “Ayíin a aŋe ataapala ataak akalaŋana pakiical pa piti Pútuun pa. Puume naayina kameye eehuu?” ");
INSERT INTO krx_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yéesu naañahanii: “Kakalaŋan enka inci inkalaŋan ka kúfuliyoot ti inci, pale ti éepoñiyaam ya. ");
INSERT INTO krx_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Niŋ an álafiyaa íhinu eeha Pútuun pa mpílafiye ha, áfaameyi man kakalaŋan ka kutoom ti Pútuun pa nkúfulii, niŋ ekina tom héefulii ti inci inci iyyem ti káakup. ");
INSERT INTO krx_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","An aŋa nákup héefulii teyoo, hiŋes kánapiyan caacawoo naayaake, pale an aŋa naŋes kánapiyan caacaw éepoñiyoo ya, an ati pánipani, kincaam kineetaat teyoo. ");
INSERT INTO krx_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Fo Móyiis tom awufane aluu hilim ha heesiiŋanee ha? Apan an taaluu átuulut ho, weyme uwune ínnilafiyam himuku?” ");
INSERT INTO krx_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Pakan paka nkañahanoo: “Hísaalumant híwuuliyuu, ayme álafiyuu himuku?” ");
INSERT INTO krx_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yéesu naasokii: “Inci heecukantee hoonool inci ínhine, aluu púlooŋ ínnim aluu. ");
INSERT INTO krx_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Móyiis asoke aluu ninakan mikampaani ma mitaaluu niŋ mitaakaa kunoom isak niŋ kíhaaciil (apan eehuu hífuliyoot ti Móyiis pale ti símaama aluu Abraham, Isaak niŋ Jakob). Kamma eeha Móyiis naasoke ha, aluu lompo pikee pa inninakan-nakan ti hinoom ha hiti kayeno ka. ");
INSERT INTO krx_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Páawoo inninakan-nakan mikampaani aluu háati ti hinoom ha hiti kayeno ka, ti hítuulu hilim ha heesiiŋanee ha hiti Móyiis, weyme éfiniñiken ti inci kamma inci ínkuuñane enii an púmpuluŋ ti hinoom ha hiti kayeno ka? ");
INSERT INTO krx_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Niŋ níhinaa kíiti, timpi nisincan eeha innicuk ha lamma, pale níhin kíiti pucoonool.” ");
INSERT INTO krx_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Pakakee ti pakati Jerusalem nkasok: “Fo áyiin aŋe tom nkayem ti hiŋes himuku? ");
INSERT INTO krx_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nisincan, oopa ti káakup hátikin pakan paka peeyoliit, an asokutoo waah. Fo pakati kikaw ka pakatuunaa kacoonaacoon pánipani nii akina ayem Eenucee ya ati Pútuun pa? ");
INSERT INTO krx_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Antúŋ áyiin a aŋe, úmeyiyaameyi pa náafulii. Pale niŋ Eenucee ya ákeyyoo, an átameyi pa náafulii.” ");
INSERT INTO krx_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tempo Yéesu naayeno kakalaŋan ti hank ha hiti ekumpaan ya enfakat ya eti Pútuun pa, naasokii niŋ hilim heeceeke: “Ee nímeyiyaam-méyi, ínnimeyi peyme inci ínfulii. Pale inci tom mamale ékey ya etoom, éepoñiyaam ya ati pánipani, nímiitoo. ");
INSERT INTO krx_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Inci méyiyoomeyi kaatuko pateyoo inci ínfulii, akina ápoñiyaam.” ");
INSERT INTO krx_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kamma kilim enkuu, nkayeno hiŋes hicokuyoo pale an anaŋut teyoo epees kaatuko caanak ca citeyoo ciloot cícolii. ");
INSERT INTO krx_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Háati fo, ti kayoŋ ka, hícump níhiyinan teyoo, nkasok: “Niŋ Eenucee ya ákeyyoo, fo áfaahin hícump píyisan pihaŋ áyiin a aŋe?” ");
INSERT INTO krx_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pufalisaay pa nkási eeha kayoŋ ka nkiyeniye ha káakumutool kiti Yéesu. Fiye ñíhampaatiin puwaaseena pa pakati Pútuun pa niŋ Pufalisaay pa nkapoñ pufaasa ekumpaan ya enfakat ya eti Pútuun pa kapica kacokoo. ");
INSERT INTO krx_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ta nkacole ta, Yéesu naasok: “Inci fayeno naaluu pale etikampan, niŋ fúlaa toko fañoho pati éepoñiyaam ya. ");
INSERT INTO krx_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Efiniŋesam pale etinicukam; pa inci inkaakaay pa piyeno, aluu étiniyini po pikaayu.” ");
INSERT INTO krx_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Fiye pakati kikaw ka pakati Pusuwif pa nkayeno picakanool: “Peyme áyiin a aŋe naakaakaay, pa etuucukoo? Fo pati Pusuwif pa keehancalooliye ka nkakin niŋ keeneetaat ka Pusuwif? Fo afaakalaŋan keeneetaat ka Pusuwif? ");
INSERT INTO krx_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Weyme náalafiye hisoku ti pákupal empe: 'Efiniŋesam pale etinicukam; pa inci inkaakaay pa piyeno, aluu étiniyini po pikaayu'?” ");
INSERT INTO krx_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Hinoom ha hikelan ha hiti pahaaño pa heehaŋe ha hitaaku nafaa, Yéesu naasiiŋo naasok niŋ hilim heeceeke: “Niŋ pálaani pucokaa an, ákey ti inci apilaan. ");
INSERT INTO krx_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","An óo an éeyinane ti inci,'kiyanu kiti man miti eloŋ éfikifasasii ti yaanoo,' samat nii fa inkiicee fa ti hilim ha hiti Pútuun pa.” ");
INSERT INTO krx_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ta Yéesu naasoke ta eehuu, kiti Kunuu ka keenape ka kiti Pútuun pa naayeniye káakup, keekaakaay ka éwanoonii ti kéeyinane ka teyoo. Tempo, Kunuu ka kuloot kuwufanee, kaatuko hamake ha hiti Yéesu hiloot híyisanee. ");
INSERT INTO krx_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ta nkásiye ta kilim enkuu, pakakee ti kayoŋ ka nkasok: “Pánipani áyiin a aŋe ayem ayaamakoola ya!” ");
INSERT INTO krx_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Pakakee paka nkasok: “Akina ayem Eenucee ya ati Pútuun pa!” Pale pakakee nkasok: “Fo Eenucee ya áyiniyini éfulii Galilee? ");
INSERT INTO krx_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Fo hikiicutee ti hilim ha hiti Pútuun pa nii, Eenucee ya áfaafulii ti miin ma miti Dawid, ti saatee ya eti Betelehem pa Dawid naakine pa hínum?” ");
INSERT INTO krx_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Fiyuu kayoŋ ka nkípaacinooliye kamma Yéesu. ");
INSERT INTO krx_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Pakakee teyii nkálafiyoo hicoku, pale an anaŋut teyoo epees. ");
INSERT INTO krx_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ti pikelan, pufaasa pa pakati ekumpaan ya enfakat ya eti Pútuun pa nkáñohoonii pati ñíhampaatiin puwaaseena pa pakati Pútuun pa niŋ Pufalisaay pa, nkacakanii: “Weyme uwune nícoopiyootoo?” ");
INSERT INTO krx_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Pufaasa pa nkañahanii: “An ataapala ákup samat nii áyiin a aŋuu!” ");
INSERT INTO krx_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Fiye Pufalisaay pa nkasokii: “Fo acaakoolaa-caakool aluu lompo? ");
INSERT INTO krx_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Fo taakaataak akee ti pakati kikaw ka pakatuunaa niŋ ekina tom ti Pufalisaay pa éeyinane ti áyiin a aŋuu? ");
INSERT INTO krx_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Haani! Pale kayoŋ enke kéemiit ka hilim ha heesiiŋanee ha hiti Móyiis, pakan keeñanee!” ");
INSERT INTO krx_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pale Nikodem, Afalisaay ya aŋa mpaakaay ya faw pati Yéesu, naasokii: ");
INSERT INTO krx_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Hilim ha hituunaa heesiiŋanee ha, fo híyiniyini kaasiiŋan an ti pisiya an péesiitanutoo náameyi eeha náahine?” ");
INSERT INTO krx_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Fiye nkañahanoo: “Awe, fo awe lompo ati Galilee? Kalaŋ heekiicee ha ti hilim ha hiti Pútuun pa, aafacuk nii ayaamakoola átafulii Galilee.” ");
INSERT INTO krx_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Púful toko an óo an naayet pateyoo. ");
INSERT INTO krx_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ta an óo an naayet ta ti enuufoo, Yéesu naakaay ti cítintiŋ ca enca nkasok ca Olif. ");
INSERT INTO krx_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Eti kacom eteyyo mpucom mic, naañoho ti hank ha hiti ekumpaan ya enfakat ya eti Pútuun pa, pakan paka púlooŋ nkayeno ékey teyoo, akina naayeno apiyeniyii kakalaŋan. ");
INSERT INTO krx_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Pikalaŋana hilim ha heesiiŋanee ha hiti Móyiis niŋ Pufalisaay pa nkácoopii aal eenimiye aŋa nkaminte ti pahaaño niŋ áyiin, nkasiiŋanoo hátikin pakan paka púlooŋ. ");
INSERT INTO krx_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Nkasok Yéesu: “Ahámpaatiin, aal a aŋe amintee ti pahaaño niŋ áyiin. ");
INSERT INTO krx_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ti hilim ha heesiiŋanee ha hiti Móyiis, kiiceekiic nii pakaal paka payenkuu fiyuu kañaŋee himuku ti kaanunkalee niŋ pukumpa. Fiye awe, eeheyme ansoke?” ");
INSERT INTO krx_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Kasokaasok eehuu kati kakuuc Yéesu nkáyiniyoo hinooku. Pale Yéesu náasitan naayeno hikiicu niŋ hisiikoo t’etaam. ");
INSERT INTO krx_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pikalaŋana pa niŋ Pufalisaay pa nkatowiyoo ti kaacakanool, fiye Yéesu naalito naasokii: “An taaluu aŋa ataapala amuuyen, átikin anunkoo ekumpa.” ");
INSERT INTO krx_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Púful toko, nene ásitan apiyeno hikiicu t’etaam. ");
INSERT INTO krx_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ta nkásiye ta kilim enkuu, kéecoopii ka aal a nkayeno epuutalo oonool oonool, púcook ti keefale ka fo towo Yéesu lamma niŋ aal a eesiiŋanee ya ti pututa pa. ");
INSERT INTO krx_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yéesu nene alito naacakan aal a: “Aaluu, poko unkey? Fo an asiiŋanuti ti pisiya?” ");
INSERT INTO krx_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Aal a naañahanoo: “Haani Ahámpaatiin.” Yéesu naasokoo: “Inci lompo etisiiŋani ti pisiya, kaay pale timpi nene muuyen.” ");
INSERT INTO krx_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yéesu nene asok pakan paka: “Inci yem ecaaŋ ya eti púlunta pa, an óo an eenapanaam ataloŋ ti énimaan pale afaataak ecaaŋ ya eyya newufan ya eloŋ ya.” ");
INSERT INTO krx_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Fiye Pufalisaay pa nkasokoo: “Awe yem eetantake ya ati faŋi, ooto eeha ansok ha hiti pánipani tom!” ");
INSERT INTO krx_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yéesu naañahanii: “Háati inci íyyemi eetantake ya ati faŋam, eeha inci insok ha hiti pánipani, kaatuko méyimeyi pa inci ínfulii niŋ pa inci iyyem ti pikaayu. Pale aluu, nímiit pa inci ínfulii, nímiit lompo pa inci iyyem ti pikaayu. ");
INSERT INTO krx_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Aluu, ínnihinaa kíiti, innisincan-sincan lamma eeha nihicukee ha. Iyyema inci, hínantoo kíiti an. ");
INSERT INTO krx_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Apan niŋ inci hínaa kíiti, necoonool-coonool, kaatuko yeniyantoo lamayam, pale Paapaa ya éepoñiyaam ya nayenoyeno niŋ inci. ");
INSERT INTO krx_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kiiceekiic ti hilim ha heesiiŋanee ha hitaaluu nii, niŋ keetantake pákasupak kasokaa hoonool huu, eeha nkasoke ha hiti pánipani. ");
INSERT INTO krx_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Inci yem eetantake ya atoom, Paapaa ya éepoñiyaam ya ayem eetantake ya atoom lompo.” ");
INSERT INTO krx_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Pufalisaay pa nkacakanoo: “Paapaa atii uwwey?” Yéesu naañahanii: “Nímiitam, nímiit lompo Paapaa atoom. Niŋ nímeyiyaam-méyi, anti nímeyi Paapaa atoom lompo.” ");
INSERT INTO krx_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yéesu naasokii kilim enkuu ta naayeniye ta kakalaŋan ti hank ha hiti ekumpaan ya enfakat ya eti Pútuun pa, pukol la nkawas la mañ ma miti kawun ka. An acokutoo kaatuko caanak ca citeyoo ciloot cícolii. ");
INSERT INTO krx_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yéesu nene asok Pufalisaay pa: “Inci fakaay, efiniŋesam, pale efiniket niŋ kaamuuyen ka kitaaluu. Pa inci iyyem pa ti pikaayu, étiniyini po ékey.” ");
INSERT INTO krx_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Fiye, Pusuwif pa nkasok: “Fo emukoolo naakaakaay? Kaatuko asok: 'Niyinaat pikaayu pa inci inkaakaay pa.'” ");
INSERT INTO krx_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yéesu nene asokii: “Aluu pakati t’etaam, inci ati patiila; aluu pakati púlunta pa, inci ati púlunta pa tom. ");
INSERT INTO krx_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ekina ewune inci insok aluu: 'Efiniket niŋ umuuyen wa utaaluu.' Niŋ níyinanut nii Inci Yem aŋa inci iyyem ya, efiniket niŋ umuuyen wa utaaluu.” ");
INSERT INTO krx_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nkañahanoo: “Fo awe yem ayme?” Yéesu naañahanii: “Aŋa inci iyyem ya aluu ti hisoku kápiliŋ ti púcook. ");
INSERT INTO krx_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Hícump waah inci intaake uti hisoku kitaaluu niŋ uti íhinu aluu kíiti, pale aŋa éepoñiyaam ya ati pánipani. Eeha inci ínsiye ha teyoo, hikina inci insok púlunta pa.” ");
INSERT INTO krx_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kámiit nii hiti Paapaa ya naayemii ti hisoku. ");
INSERT INTO krx_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Fiye Yéesu naasokii: “Niŋ níseepinaam, inci, Añii An, éfinimeyi nii Inci Yem aŋa inci iyyem ya. Innímeyi lompo nii hínantoo waah inci faŋam, pale eeha Paapaa ya naakalaŋanaam ha, hikina inci insok. ");
INSERT INTO krx_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Eépoñiyaam ya oopa niŋ inci, akatanutam lamayam. Kaatuko héesuumoo ha inci ínhin tan óo tan.” ");
INSERT INTO krx_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ta naayeniye ta káakup kilim enkuu, hícump pakan nkáyinan teyoo. ");
INSERT INTO krx_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yéesu naasok Pusuwif pa kéeyinane ka teyoo: “Niŋ nitowiyaa ti kanapan kilim ka kutoom, efiniyeno pinapana pa pakatoom pánipani. ");
INSERT INTO krx_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Efínimeyi pánipani ya, apan pánipani ya efeeyihan aluu ti himiikanate.” ");
INSERT INTO krx_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nkañahanoo: “Unii pakati miin ma miti Abraham, utaapala uyeno pimiikan an. Fiye awe, puume áafayini hisoku unii nii: 'Efiniyihanee'?” ");
INSERT INTO krx_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yéesu naañahanii: “Inci pusok aluu pánipani ya, an óo an eemuuyene, akina amiikan ati kaamuuyen. ");
INSERT INTO krx_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Amiikan ayeniyantoo ati miin fo cancowiyaaw, pale añii ya, ati toko fo cancowiyaaw. ");
INSERT INTO krx_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ooto niŋ Añii ya ayihanaa aluu, efiniyih pánipani. ");
INSERT INTO krx_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Inci méyimeyi nii aluu pakati miin ma miti Abraham. Pale hiŋes himukuyam inniyaake kaatuko taaluu hilimam hilehut ti saan aluu. ");
INSERT INTO krx_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Inci hisoku aluu eeha inci incuke ha ti Paapaa atoom iyyaake. Pale aluu eeha ínnisiye ha ti paapaa ataaluu inniyem ti íhinu.” ");
INSERT INTO krx_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nkañahanoo: “Paapaa atoonii ayem Abraham.” Yéesu naasokii: “Niŋ aluu epuuk Abraham anti níhin samat nii Abraham. ");
INSERT INTO krx_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Inci, pánipani ya eyya inci ínsiye ya ti Pútuun pa iyyem aluu ti hisoku, pale aluu ínniyemi ti hiŋes himukuyam, Abraham kaloŋayoo, ataapala áhin eehuu. ");
INSERT INTO krx_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Pale aluu, íhinu samat nii paapaa ataaluu inniyaake.” Nkañahanoo: “Unii upukutee ti pihaañiya, Paapaa oonool nuutaake akina ayem Pútuun pa.” ");
INSERT INTO krx_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yéesu naasokii: “Niŋ Pútuun pa piyem Paapaa ataaluu, anti nílafiyam. Kaatuko inci pati Pútuun pa ínfulii, fiye íyyemi le. Inci kéyyoot ti faŋam pale pikina púpoñiyaam. ");
INSERT INTO krx_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Weyme uwune hilim ha hitoom hicaaŋut aluu? Kaatuko niyinaat hicoonu eeha inci insok ha. ");
INSERT INTO krx_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Paapaa ataaluu ayem áhampaatiin a ati piseetaani pa, ínnilafi íhinu eeha níhisuum ha paapaa ataaluu. Akina amukala kápiliŋ ti púcook pa. Ataapala asiiŋo ti pánipani ya, kaatuko pánipani ya eneetaat teyoo. Niŋ acaamaa, pacukoo, kaatuko akina nincaama, náayemi paapaa ya ati kincaam ka. ");
INSERT INTO krx_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pale inci pánipani ya inci insok, ekina ewune níyinanutam. ");
INSERT INTO krx_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ayme taaluu ayina káyisan nii inci muuyenaamuuyen? Niŋ pánipani ya inci insok, weyme uwune níyinanutam? ");
INSERT INTO krx_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","An ati Pútuun, násiitansiitan eeha Pútuun pa mpusok ha, pale aluu nísiitanutam kamma innineetaat pakati Pútuun pa.” ");
INSERT INTO krx_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Pusuwif pa nkasok Yéesu: “Fo pánipani tom nuusoke nii awe ati Samali, hísaalumant híwuuliyuu?” ");
INSERT INTO krx_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yéesu naañahanii: “Haani hísaalumant híwuuliitam, pale inci mákiyanaa-mákiyan paapaa atoom, aluu nímakiyanutam. ");
INSERT INTO krx_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Inci tom láfiye pakan paka kati kámakiyanam. Taakaataak aŋa éelafiye pakan paka kati kámakiyanam, akina ayem áhina ya kíiti. ");
INSERT INTO krx_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Inci pusok aluu pánipani ya, niŋ an átuulaa hilim ha hitoom ataket.” ");
INSERT INTO krx_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Pusuwif pa nkasok Yéesu: “Fiye úmeyimeyi nii hísaalumant híwuuliyuu. Abraham aketaaket, piyaamakoola pa lompo nkaket, pale awe insok nii, aŋa éetuule hilim ha hitii ataket. ");
INSERT INTO krx_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Awe, fo aahaŋa Abraham paapaa atoonii? Akina aketaaket, piyaamakoola pa lompo nkaket. Fo weyme ancoke faŋi?” ");
INSERT INTO krx_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yéesu naañahanii: “Niŋ inci mákiyanooliyaa, hamake ha hitoom hitaakut nafaa. Paapaa atoom ámakiyanaam, aŋa innisoke ya nii akina ayem Pútuun pa pitaaluu, ");
INSERT INTO krx_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","pale nímiitoo. Inci méyiyoomeyi; niŋ inci sokaa nii míitoo fayeno nincaama samat nii aluu. Pale méyiyoomeyi, íntuul hilim ha hiteyoo. ");
INSERT INTO krx_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham paapaa ataaluu, ti pásuuma naayeniye kaatuko ámeyimeyi nii afaacuk hinoom eeha inci inkaakaay ha écolii. Acukaacuk ho ínsuumoo.” ");
INSERT INTO krx_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Pusuwif pa nkasok Yéesu: “Aaloot taak fala sitiil áwii ésupak niŋ ŋaasuwan (50) insok nii aacukaacuk Abraham?” ");
INSERT INTO krx_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yéesu naañahanii: “Inci pusok aluu pánipani ya, Abraham ápukumee, Inci Yem.” ");
INSERT INTO krx_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ta nkásiye ta eehuu, nkayesal pukumpa kati kanunkaloo pale Yéesu naayolo náaful ti ekumpaan ya enfakat ya eti Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yéesu ti pikaayu, naacuk áyiin éefuume emma naapukee. ");
INSERT INTO krx_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Pinapana pa pakateyoo nkacakanoo: “Rabi, umuuyen wa uti ayme uwune áyiin a aŋe náafuum emma naapukee? Umuuyen wa uteyoo fo uti pupukayoo?” ");
INSERT INTO krx_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yéesu naañahanii: “Neetaat umuuyen wa uteyoo neetaat lompo uti pupukayoo. Afúumaafuum ancuk páhin pa piti Pútuun pa kati píyisanee pínapii teyoo. ");
INSERT INTO krx_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Hanakan ha uñaŋaa íhinu páhin pa piti éepoñiyaam ya, pale hánant ha uuha ti ékey ta an naayinantoo páhin. ");
INSERT INTO krx_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Fa inci iyyem fa ti púlunta pa, inci yem ecaaŋ ya eti púlunta pa.” ");
INSERT INTO krx_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ta Yéesu naapaye ta káakup, naafaac ti esiya ya naanakanool yo niŋ mifaac ma, naanaaneen yo ti ñíkin éefuume ya. ");
INSERT INTO krx_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Fiye naasokoo: “Kaay caañowo ti éwacuma eyya nkasok ya Silowam” (Silowam ekina eyem “eepoñee”). Eéfuume ya naakaañowo, ti éñohoonii ya eteyoo naacuk. ");
INSERT INTO krx_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Pikinooloo niŋ payenka nkacukoo ka hínum ti kaaluumatool nkasok: “Fo neetaat káafuumafuum enka nkiyeno ka le kayen ti kaaluumatool?” ");
INSERT INTO krx_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Pakakee nkasok: “Akina.” Pakakee paka nkasok: “Haani akina tom, pale anakooloo.” Ayíin a naayeno hisoku: “Inci himuumam.” ");
INSERT INTO krx_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Fiye nkacakanoo: “Ooto puume ñíkini íññipankiniye?” ");
INSERT INTO krx_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Naañahanii: “Ayíin a aŋa nkasok a Yéesu acoope esiya naapoocan yo naanaaneen yo ti ñíkinam, naasokam inci kaacaañowo Silowam. Fiye, inci inkaay picaañowo, íyyini hicuku.” ");
INSERT INTO krx_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nkacakanoo: “Akina uwwey?” Naañahanii: “Inci míit.” ");
INSERT INTO krx_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Púful toko, nkacoop éefuume ya hínum pati Pufalisaay pa. ");
INSERT INTO krx_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Inhemool hinoom eeha Yéesu naapoocane ha esiya ya náakuuñan éefuume ya, hikina hiyem hinoom ha hiti kayeno ka hiti Pusuwif pa. ");
INSERT INTO krx_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Fiye Pufalisaay pa lompo nkayeno kaacakanool áyiin a puume ñíkinoo íññipankiniye. Ayíin a naasokii: “Esiya naapoocane niŋ mifaac naanaaneen yo ti ñíkinam, inkaañowo, incuk.” ");
INSERT INTO krx_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pakakee ti Pufalisaay pa nkasok: “Ayíin a aŋe áfuliyoot pati Pútuun pa, kaatuko átuulut hinoom ha hiti kayeno ka.” Pale pakakee paka nkasok: “Puume amuuyena áfinnayini íhinu píyisan empuu?” Fiye nkápaacinoolo. ");
INSERT INTO krx_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Púful toko, nene kacakan éefuume ya hínum: “Awe, weyme ayyina hisoku kiteyoo? Páawoo ñíkini náapankine.” Naañahanii: “Ayaamakoola.” ");
INSERT INTO krx_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pale pakati kikaw ka pakati Pusuwif pa nkapook káyinan nii áyiin a éefuume hínum, apan fiye oopa ti hicuku. Káyinanut fo ta nkáyonkalii ta pupukayoo. ");
INSERT INTO krx_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ta pupukayoo nkácolii ta, ñíhampaatiin ña pakati Pusuwif pa nkacakanii: “Fo aŋe añiin aluu, aŋa innisoke ya nii éefuume kápiliŋ emma naapukee? Puume náahine apucuk?” ");
INSERT INTO krx_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Pupukayoo nkañahanii: “Uméyimeyi nii aŋe añiin unii, éefuume ya kápiliŋ ta naapukee. ");
INSERT INTO krx_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pale unii úmiit puume náahine fo ácukii, éepankine ya ñíkinoo lompo úmiitoo. Pale añii tom; nicakanoo, afaañahan aluu.” ");
INSERT INTO krx_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","(Pupukayoo kákupaakup fiyuu kamma nkafeye pakati kikaw ka pakati Pusuwif pa. Kaatuko kásiyoolaa-síyool nii efikakit ti éluumuma ya an óo an eesoke nii Yéesu ayem Eenucee ya ati Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ekina ewune pupukayoo nkasok: “Nicakanoo, añii tom.”) ");
INSERT INTO krx_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Fiye Pufalisaay pa nkáyonkalii áyiin a éefuume ya hínum púsupiyenu, nkasokoo: “Aapa hátikin Pútuun pa, sok pánipani ya! Unii úmeyimeyi nii an a aŋuu amuuyena.” ");
INSERT INTO krx_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Naañahanii: “Inci míit man amuuyena pale hoonool inci immeya, inci hínum éefuume pale fiye inci oopa ti hicuku.” ");
INSERT INTO krx_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nkacakanoo: “Weyme náahinuu? Puume náahine ápipankin ñíkini?” ");
INSERT INTO krx_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ayíin a naañahanii: “Inci payaapa ho aluu hisoku, pale nísiitanutam. Weyme uwune ínnilafi pinene sok ho aluu? Fo aluu lompo nílafilafi piyeno pinapana pa pakateyoo?” ");
INSERT INTO krx_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Fiye nkayeniyoo kateñal ti hisokuyoo: “Awe yem anapana ya ati áyiin a aŋuu, unii pinapana pakati Móyiis. ");
INSERT INTO krx_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Uméyimeyi nii Pútuun pa niŋ Móyiis mpúkupe, pale áyiin aŋuu úmiit fala peyme náafulii.” ");
INSERT INTO krx_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ayíin a naañahanii: “Eehuu hínimaam, nímiit peyme náafulii apan náapankin ñíkinam! ");
INSERT INTO krx_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Uméyiyaameyi nii Pútuun pa písiitanantoo pumuuyena pa pale mpísiitan-síitan eefeye po náahin eeha mpílafiye ha. ");
INSERT INTO krx_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kápiliŋ emma púlunta pa mpíyaañe ma, hitaapala hísiyee nii, an ápankine ñíkin éefuume emma naapukee. ");
INSERT INTO krx_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Niŋ áyiin a aŋuu áfuliyoot pati Pútuun pa, átayini íhinu waah.” ");
INSERT INTO krx_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nkañahanoo: “Awe, eloŋi púlooŋ ti kaamuuyen neeyem emma ampukee, fiye állafi unii kakalaŋan?” Ti oom káasiiŋuma nkayaanoo tíkitaaŋ. ");
INSERT INTO krx_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yéesu náasi nii éefuume ya hínum, Pufalisaay pa kayaanooyaan. Fiye, Yéesu naakaayoo hiŋes, naacukoo naasokoo: “Fo áayinanaayinan ti Añii An?” ");
INSERT INTO krx_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ayíin a naañahanoo: “Ahámpaatiin, sokam akina ayem ayme, ancuk inci yínanaa teyoo.” ");
INSERT INTO krx_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yéesu naasokoo: “Aacukoocuk, akina ayem fiye ti káakup niŋ awe.” ");
INSERT INTO krx_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ayíin a naañahanoo: “Ateeteyo, inci yínanaa.” Náakilipo hátikinoo puhooŋuyoo t’etaam. ");
INSERT INTO krx_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Púful toko, Yéesu naasokoo: “Kíiti ewune inci ínkey ti púlunta pa: ancuk kéefuume ka kati kacuk, keecuke ka nkáfuum.” ");
INSERT INTO krx_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Pakakee ti Pufalisaay pa keeyeniye ka toko nkási eeha Yéesu naayeniye ha hisoku, nkacakanoo: “Fo unii lompo úfuumaafuum?” ");
INSERT INTO krx_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yéesu naañahanii: “Niŋ nífuumaafuum anti níyeniyaati pumuuyena pale páawoo nisokaasok nii nicukaacuk, kaamuuyen ka kitaaluu etikiponketee.” ");
INSERT INTO krx_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yéesu naasokii: “Inci pusok aluu pánipani ya, an óo an eenaput ti hunkut ha hiti híkinku ha hiti písaacii pa pale naasilo ti híkinku ha, oom an álipa, akanca. ");
INSERT INTO krx_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pale eenape ya ti hunkut ha ayem afaasa ya ati písaacii pa. ");
INSERT INTO krx_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Awásuma híkinku ha áfaapankinoo hunkut ha, písaacii pa mpísi hilimoo; sáacii óo sáacii eteyoo, afaayonkal yo ti caacaw eteyyo mpinapanoo tíkitaaŋ. ");
INSERT INTO krx_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Niŋ áfulaniyoo písaacii pa piteyoo púlooŋ, naanow po hátikin, pikina mpinapanoo kamma mpikiiwe hilimoo. ");
INSERT INTO krx_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Etipinapan akaawoola, pale efipiteyoo kamma mpikiiwut hilim ekaawoola ya.” ");
INSERT INTO krx_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yéesu naakamanii hícantiitu eehuu, pale kámiit eeha náalafiyii ha hisoku. ");
INSERT INTO krx_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Fiye Yéesu nene asok: “Inci pusok aluu pánipani ya, inci yem hunkut ha hiti písaacii pa. ");
INSERT INTO krx_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Kéekeyii ka púlooŋ le niŋ inci fácolii, pílipa niŋ pikanca. Pale písaacii pa písiitanutii. ");
INSERT INTO krx_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Inci yem hunkut ha. An óo an eenape ti inci afaafakanee. Afánayini énakoonii niŋ hífulu nataak paliyal. ");
INSERT INTO krx_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Alípa ya nákeykey káalipu, himuku niŋ káapucalool lamma. Pale inci kéyyookey pakan paka kati kataak eloŋ, nkaloŋ yo pánipani. ");
INSERT INTO krx_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Inci yem afaasa ya eenape ya. Afaasa ya eenape ya nacooncoon kawufan eloŋoo kamma písaacii pa piteyoo. ");
INSERT INTO krx_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pikee pa áhampaatiin a ati písaacii pa naacoop an apiyeno afaasa ati písaacii pa piteyoo. Oom an efaas naayaake kamma naakaakaayee cooy; niŋ acukaa eyen elampa ti ékey afaatah toko písaacii pa naatey, kaatuko piteyoo tom. Fiye eyen elampa ya neelaako po neehancalool po. ");
INSERT INTO krx_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ayíin a ateyaatey kamma naacoopee páhin, cokutoo ti písaacii pa. ");
INSERT INTO krx_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Inci yem afaasa ya eenape ya. Paapaa ya náameyiyam inci lompo ímmeyi Paapaa ya, fo lompo incuke inci méyimeyi písaacii pa putoom, písaacii pa putoom lompo mpímeyiyam. Inci incooncoon kawufan eloŋ ya etoom kamma písaacii pa. ");
INSERT INTO krx_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Inci taakaataak pikee písaacii peeneetaat ti híkinku eehe, empuu lompo ñaŋaa po écoopii, éfipisiitan hilimam. Ancuk koolee yoonool etaakiyaa niŋ afaasa oonool. ");
INSERT INTO krx_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Paapaa ya álafiyaamlafi kamma inci incoon kawufan eloŋ ya etoom kati sa yo nene. ");
INSERT INTO krx_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","An ayinaat hicoopu eloŋ ya etoom pale inci uwwufan yo ti pásuumayam. Inci taakaataak kayine kiti kawufan eteyyo niŋ kayine kiti hisayu eteyyo nene, eehe Paapaa atoom naasokaam kati hín.” ");
INSERT INTO krx_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kilim enkuu nene kípaacinool Pusuwif pa. ");
INSERT INTO krx_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Hícump teyii nkasok: “Hísaalumant híwuuliyoo! Awuyaawuyo! Weyme ínnisiitanoo?” ");
INSERT INTO krx_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pale pakakee paka nkasok: “An aŋa hísaalumant níhiwuuliye ákupantoo fiye. Fo hísaalumant éfihiyini káapankin ñíkin éefuume?” ");
INSERT INTO krx_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pahaaño pa piti ekumpaan ya enfakat ya eti Pútuun pa eeyem ya Jerusalem mpúcolii, tempo ti caanak citi pamon. ");
INSERT INTO krx_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yéesu naayeno kaamuumuusool ti ekumpaan ya enfakat ya, la nkasok la címpaŋ ya eti Solomon. ");
INSERT INTO krx_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Fiye, pakati kikaw ka pakati Pusuwif pa nkákiitooloo nkasokoo: “Fo teyme aafakat unii ti énimaan? Iyyema awe yem Eenucee ya ati Pútuun pa caaŋan unii.” ");
INSERT INTO krx_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yéesu naañahanii: “Sokaasok ho aluu pale níyinanut. Píyisan empa inci ínhin pa ti caacaw Paapaa atoom, pikina píyisane aŋa inci iyyem ya. ");
INSERT INTO krx_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pale aluu níyinanut, kaatuko nineetaat ti písaacii pa putoom. ");
INSERT INTO krx_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Pinapana pa pakatoom kacukaacuk nii písaacii empa mpísiitan hilimam. Inci méyiyiimeyi nkanapanam. ");
INSERT INTO krx_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Uwwufanii eloŋ ya eepayantoo ya. Inci étipuulii, an lompo átayiniyii hilamu ti epeesam. ");
INSERT INTO krx_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Paapaa atoom eewufanaamii ya ahaŋa an óo an, an ayinaatii hilamu ti epees Paapaa atoom. ");
INSERT INTO krx_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Inci niŋ Paapaa ya an oonool.” ");
INSERT INTO krx_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pusuwif pa nene kayesal pukumpa kati kanunkal Yéesu fo aket. ");
INSERT INTO krx_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pale Yéesu naasokii: “Hícump páhin peenape inci íyyisane aluu púpufulii pati Paapaa ya, empeyme tempo puwune ínnilafiyam kaanunkal pukumpa fo ket?” ");
INSERT INTO krx_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Pusuwif pa nkañahanoo: “Neetaat páhin peenape puwune núulafiyi himuku, pale fa anteñale fa Pútuun pa, awe an kenseŋ insok nii awe Pútuun!” ");
INSERT INTO krx_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yéesu naasokii: “Fo kiicutee ti hilim ha heesiiŋanee ha hitaaluu nii Pútuun pa pusok: 'Inci sok, aluu ñútuun'? ");
INSERT INTO krx_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Uméyiyaameyi nii hilim ha hiti Pútuun pa hiyinaatee hípucu. Ooto niŋ piyonkalaa payenka mpúkupe ka neyii 'ñútuun', ");
INSERT INTO krx_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","weyme uwune innisok nii inci teñalaateñal Pútuun pa kamma inci insoke nii inci yem Añii ya ati Pútuun pa? Apan inci yem aŋa Paapaa ya naamamale ya náapoñiyam ti púlunta pa. ");
INSERT INTO krx_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Niŋ inci hínut páhin pa piti Paapaa atoom, timpi níyinanam, ");
INSERT INTO krx_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","pale niŋ inci hínaa po, háati níyinanutam, níyinan eeha inci ínhin ha kati nímeyi innikiiw nii Paapaa ya oopa ti inci, inci lompo oopa ti Paapaa ya.” ");
INSERT INTO krx_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Fiye, nene kayeno hiŋes hicokuyoo pale naafakii. ");
INSERT INTO krx_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Púful toko, Yéesu naañoho apifiitan musuu ma miti Jordan la Saŋ náacooke la íhinu pátise, naayeno toko. ");
INSERT INTO krx_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Hícump pakan nkákey teyoo. Nkasokool: “Saŋ, háati áhinut píyisan poonool pale waah ewwa naasoke wa púlooŋ kiti áyiin a aŋe, uti pánipani.” ");
INSERT INTO krx_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Hícump pakan toko, nkáyinan ti Yéesu. ");
INSERT INTO krx_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Intaako áyiin éekuuñe caacawoo Lasaar. Naakin ti saatee ya eti Betani niŋ pakahoopoo Mari niŋ Maarta. ");
INSERT INTO krx_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mari aŋe ayem aŋa eenuce ya Ateeteyo niŋ munucu méesuume haaw naatoot wootoo niŋ wanoo. Ahoopoo ayem Lasaar éekuuñe ya. ");
INSERT INTO krx_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Pakahoopoo nkapoñ an pati Yéesu apicaasokoo: “Ahámpaatiin, áwiyi aŋa állafiye ya ákuuñaakuuñ.” ");
INSERT INTO krx_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ta Yéesu náasiye ta eehuu naasok: “Káakuuñu enkuu kiti himukuyoo tom, pale éfikiyisan hamake ha hiti Pútuun pa. Pínapii tenko Añii ya ati Pútuun pa áfaamakiyanee.” ");
INSERT INTO krx_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yéesu náalafi Maarta niŋ atuwoo niŋ Lasaar meemak. ");
INSERT INTO krx_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ta náasiye ta nii Lasaar ákuuñaakuuñ, naayeno pa naayeniye pa fo kunoom kúsupak. ");
INSERT INTO krx_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Púful toko naasok pinapana pa pakateyoo: “Uñohiyaa ti mah ma miti Judaay.” ");
INSERT INTO krx_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Pinapana pa nkañahanoo: “Rabi, fiyiit ta Pusuwif pa nkálafiyuu kaanunkal niŋ pukumpa fo aaket, fiye awe ínneelafi upuñohiyaa po?” ");
INSERT INTO krx_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yéesu naañahanii: “Fo siwaati ŋaasuwan niŋ súsupak tom siyem ti hanakan? Niŋ an asapalaa niŋ hanakan átafukoolo kaatuko acukaacuk ecaaŋ ya eti púlunta empe. ");
INSERT INTO krx_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pale niŋ ayeniyaa pikaayu niŋ hánant áfaafukoolo kaatuko ataakut ecaaŋ.” ");
INSERT INTO krx_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ta naapaye ta káakup, nene asokii: “Awí unaa Lasaar aŋotaaŋot, pale inci pikaayu káyiyaloo.” ");
INSERT INTO krx_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Pinapana pa pakateyoo nkañahanoo: “Ahámpaatiin, niŋ hiŋotu naayaake ooto afaafisak.” ");
INSERT INTO krx_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yéesu hisokuyii naayeniye nii Lasaar aketaaket pale pinapana pa pakateyoo incukii nii hiŋotu kenseŋ naasokii. ");
INSERT INTO krx_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Fiye Yéesu naasokii picaaŋ nii: “Lasaar aketaaket. ");
INSERT INTO krx_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Súumaamsuum fa eehuu nihitookutam fa po, ancuk níyinanaa, pale ukaayaa pateyoo.” ");
INSERT INTO krx_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Fiye Tomas, aŋa nkasok a lompo Máasupak ma, naasok pákawiyoo pinapana pa: “Unaa lompo ukaayaa ancuk nuuketaa neyoo.” ");
INSERT INTO krx_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ta Yéesu naacole ta, naatook loho Lasaar ahokee fo ataak kunoom kipaakiil. ");
INSERT INTO krx_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Po Betani, láaŋoolut niŋ Jerusalem, máamun sikilomeetal síhaaciil. ");
INSERT INTO krx_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ekina ewune hícump Pusuwif nkakaay pati Maarta niŋ Mari piŋaapo keeŋoot ka kiti ahoopii. ");
INSERT INTO krx_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ta Maarta náasiye ta nii Yéesu oopa ti ékey, naakaay kaapaakoolanoo, Mari naayeno t’enuuf. ");
INSERT INTO krx_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maarta naasok Yéesu: “Ahámpaatiin, niŋ le ayyeniye, ahoopam anti áketaati. ");
INSERT INTO krx_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pale fo fiye inci méyimeyi nii waah óo waah ewwa alluume Pútuun pa, efipuwuni wo.” ");
INSERT INTO krx_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yéesu naasokoo: “Ahoopi afaalito ti eket ya.” ");
INSERT INTO krx_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maarta naañahanoo: “Inci méyimeyi nii áfaalitoonii ti eket ya ti hinoom ha hikelan ha hiti púlunta pa.” ");
INSERT INTO krx_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yéesu naasokoo: “Inci yem pilito pa, inci lompo yem eloŋ ya. An óo an éeyinane ti inci, háati naaket afaaloŋ. ");
INSERT INTO krx_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","An óo an eeloŋe náayinan ti inci ataket háati poonool. Fo áayinanaayinan eehe?” ");
INSERT INTO krx_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Maarta naañahanoo: “Ee Ahámpaatiin, inci yínanaayinan nii awe yem Eenucee ya, Añii ya ati Pútuun pa eeñaŋe ya ékey ti púlunta pa.” ");
INSERT INTO krx_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Púful toko Maarta naacaayonkal atuwoo Mari naapuusanooloo apusokoo: “Ahámpaatiin a ácoliyoo, oopa nacakani.” ");
INSERT INTO krx_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ta Mari náasiye ta eehuu, naalito naahiliikan apikaay pateyoo. ");
INSERT INTO krx_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tempo Yéesu aloot anako ti saatee ya, la Maarta naapaakoolanoo la naaloŋe. ");
INSERT INTO krx_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Pusuwif pa keeyeniye ka niŋ Mari nkayeniyoo kaapuuñanool, nkacukoo naalitiye mpacas náaful, nkanapanoo pucukii nii pikaayu pukooŋ pati hiyaak ha naayaake. ");
INSERT INTO krx_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ta Mari naacole ta la Yéesu naayeniye la, apucukoo naanow ti wootoo naasokoo: “Ahámpaatiin, niŋ le ayyeniye ahoopam anti áketaati.” ");
INSERT INTO krx_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ta Yéesu naacuke ta Mari ti pukooŋ niŋ Pusuwif pa kéenapaniyoo ka lompo ti pukooŋ, yaanoo neemeeŋ niŋ kúnuul inseeñoo. ");
INSERT INTO krx_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Naasokii: “Peyme innihokoo?” Nkañahanoo: “Ahámpaatiin, kéy aapucuk.” ");
INSERT INTO krx_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yéesu naakooŋ. ");
INSERT INTO krx_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Fiye Pusuwif pa nkasokool: “Nisincan fa náalafiyoo fa!” ");
INSERT INTO krx_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pale pakakee paka nkasok: “Fo akina éepankine ya ñíkin áyiin a éefuume ya, ayinaat fala káakuuñan Lasaar áketum?” ");
INSERT INTO krx_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yéesu nene ameeŋ niŋ kúnuul, naakaay ti hiyaak ha. Hiyaak ha níhiyemi ti kaayeen kenfakat. Enánkiin enfakat epanke putum pa piti hiyaak ha. ");
INSERT INTO krx_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yéesu naasok: “Nífulan énankiin ya.” Maarta, ahoop a ati eekete ya, naañahanoo: “Ahámpaatiin, fiye afutaa kaatuko taakaa kunoom kipaakiil.” ");
INSERT INTO krx_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pale Yéesu naasokoo: “Fo inci sokuti nii, náayinanaa aafacuk hamake ha hiti Pútuun pa?” ");
INSERT INTO krx_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Fiye, nkáfulan énankiin ya. Yéesu náahaafin naasok: “Paapaa, inci sokuu apalaka fa ánsiyaam fa. ");
INSERT INTO krx_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Inci méyimeyi nii ánsiyamsi tan óo tan, pale kayoŋ enke kuwune inci ínkup, kati kíyinan nii awe póñiyaam.” ");
INSERT INTO krx_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ta Yéesu naapaye ta káakup, naaceek niŋ kaawiiluyoo: “Lasaar, fúlii!” ");
INSERT INTO krx_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ayíin a eekete ya náafulii, sipeesoo niŋ wootoo insipoonanoolee niŋ wañ uti ehok, puhooŋuyoo mpukuupatanoolee niŋ cifaal. Yéesu naasok: “Nícenkinoo innikatanoo apikaay.” ");
INSERT INTO krx_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Hícump ti Pusuwif pa kéekeyii ka hiyoop Mari nkacuk eeha Yéesu náahine ha nkáyinan teyoo. ");
INSERT INTO krx_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pale pakakee teyii nkakaay pati Pufalisaay pa nkakamanii eeha Yéesu náahine ha. ");
INSERT INTO krx_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Fiye, Pufalisaay pa niŋ ñíhampaatiin puwaaseena pa pakati Pútuun pa nkaconcoolan ñíhampaatiin píhina kíiti ya pakati Pusuwif pa, nkasok: “Weyme nuukaakaayaa íhinu? Ayíin a aŋe oopa ti íhinu hícump píyisan. ");
INSERT INTO krx_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Niŋ ukatanoo aputowo fiye ti pikaayu, pakan paka púlooŋ éfikayinan teyoo. Pakati Room éfikasi ho nkákey kapihancalool ekumpaan ya enfakat ya etuunaa eti Pútuun pa niŋ síi ya etuunaa.” ");
INSERT INTO krx_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Akee teyii caacawoo Kayif, akina ayeniye awaaseena ya enfakat a oom etiil, naasokii: “Aluu nímiit likee! ");
INSERT INTO krx_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nípannumut nii haŋa panap taaluu an oonool apiket kamma pakan paka, le niŋ síi ya púlooŋ éfeepucaloolee.” ");
INSERT INTO krx_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayif asokut eehuu ti faŋoo, pale fa naayeniye fa awaaseena ya enfakat a ti oom etiil, ekina ewune naayaamakool nii Yéesu añaŋaa eket kamma síi ya eti Pusuwif pa. ");
INSERT INTO krx_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Apan ataket kamma síi eyyuu lamma pale kati aconcenool epuuk Pútuun pa púlooŋ keehancalooliye ka kapiyeno hímaaf hoonool. ");
INSERT INTO krx_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Fiye písik oom hinoom, pakati kikaw ka pakati Pusuwif pa nkasiiŋiye kati kamuk Yéesu. ");
INSERT INTO krx_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ekina ewune Yéesu náayekuno kaakaawool ápiyisanoolo ti Pusuwif pa, pale naakaay ti saatee eekole káahaaŋ ka tes, nkasok yo Efreem, naayeno toko niŋ pinapana pa pakateyoo. ");
INSERT INTO krx_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ti oom caanak, pahaaño pa piti Himuusu ha hiti Pusuwif pa mpúlohanii, hícump pakan nkáfulii ti pisaatee pa niŋ misaatee ma kapisilo Jerusalem kati kakuulanoolo le niŋ pahaaño pa. ");
INSERT INTO krx_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nkayeno hiŋes Yéesu loho kasiiŋiyaa lati ekumpaan ya enfakat ya eti Pútuun pa nkayeno picakanool: “Weyme ínnimiiloole? Fo áfaalah ápikey pahaaño pa?” ");
INSERT INTO krx_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ñíhampaatiin puwaaseena pa niŋ Pufalisaay pa kawufanaawufan hilim nii, an óo an eemeya pa Yéesu naayem, añaŋaa kakaman ancuk kati acokee. ");
INSERT INTO krx_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ta intowiye ta kunoom isak niŋ hoonool pahaaño pa piti Himuusu ha hiti Pusuwif pa kati píhinee, Yéesu naacol Betani la Lasaar aŋa naalitane ya ti eket ya naakine la. ");
INSERT INTO krx_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Po Betani, nkamemanool káciim kápimakiyan Yéesu. Maarta naayeno ti keeyeniye ka kawasu oom káciim, Lasaar naayeno ti keeyeniye ka niŋ Yéesu ti taapul ya. ");
INSERT INTO krx_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mari naacoop máamun kancaŋ kilo eti munucu méesuume haaw méeciita hinoom meememanoolee niŋ naat eti pánipani, naanuc woot Yéesu naatoot wo niŋ wanoo, ekumpaan ya púlooŋ neehaaŋo púsuum. ");
INSERT INTO krx_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Fiye Judas Iskaliyot, akee ti pinapana pa (aŋa eekaakaay ya hífulu ti Yéesu) naasok: ");
INSERT INTO krx_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Weyme uwune munucu ma munoomanutee ti soŋ eti cooy áhina etiil púmpuluŋ, mañ ma ummuwufanee keeleke ka?” ");
INSERT INTO krx_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Asokaasok eehuu kaatuko álipa, ámiiloolut keeleke ka. Akina namank mañ ma miteyii, temmo nálip. ");
INSERT INTO krx_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yéesu naasokoo: “Katanoo! Amankaamank munucu emme hak hinoom ha hiti ehok ya etoom. ");
INSERT INTO krx_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Keeleke ka efikayeno niŋ aluu tan óo tan, pale inci etinitaakam tan óo tan.” ");
INSERT INTO krx_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Hícump ti Pusuwif pa nkakaay Betani ta nkásiye ta nii Yéesu oopa po, Yéesu lamma awunut nkakaay pale Lasaar aŋa naalitane ya ti eket ya nkálafiye hicuku lompo. ");
INSERT INTO krx_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ekina ewune ñíhampaatiin puwaaseena pa pakati Pútuun pa nkasiiŋo kati kamuk lompo Lasaar. ");
INSERT INTO krx_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Kaatuko akina awune hícump Pusuwif nkakatanii nkáyinan ti Yéesu. ");
INSERT INTO krx_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Eti kacom eteyyo, kayoŋ ka kenfakat ka kéekeyii ka ti pahaaño pa piti Himuusu ha nkísi nii Yéesu oopa ti ékey Jerusalem. ");
INSERT INTO krx_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nkáyekanalii ékunt incakapaakoolanoo tíkitaaŋ saatee ya ti hílulu, nkayeno hiceeku: “Hosanna! Alímaati Ateeteyo Pútuun pa pisampan éekeyii ya ti caacaw etempo, amansa ya ati Israyel.” ");
INSERT INTO krx_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yéesu naacuk cífali naalapo tenco samat nii fa inkiicee fa ti hilim ha hiti Pútuun pa: ");
INSERT INTO krx_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Timpi nife, aluu pakati Siyon; nisincan, amansa ya ataaluu oopa ti ékey, oopa álapoonii ti cífali.” ");
INSERT INTO krx_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ti oom caanak, pinapana pa pakati Yéesu kámiit heeyeniye ha pitaako, pale po hátikin ta hamake ha hiti Yéesu níhiyisanee ta nkápannum nii eehuu hikiicee kiteyoo, apan hikina lompo nkáhinoo. ");
INSERT INTO krx_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Tempo kayoŋ ka keetantake ka ta Yéesu naayonkale ta Lasaar ápufulii ti hiyaak ha, náalitaniyoo ti eket ya, nkutowo ti káatuunan heetaakiye ha. ");
INSERT INTO krx_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ekina ewune, kayoŋ ka nkikaay kapaakoolan Yéesu kamma nkísiye nii áhinaahin píyisan empuu. ");
INSERT INTO krx_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Fiye, Pufalisaay pa nkasokool: “Nisincan, niyinaat toko waah, pakan paka púlooŋ unka ti kanapanoo!” ");
INSERT INTO krx_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Intaak pakakee keeneetaat Pusuwif ti keesiliye ka Jerusalem kaluum Pútuun pa ti pahaaño pa. ");
INSERT INTO krx_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nkákey ti Filip ati Petesayit eti Galilee nkasokoo: “Ahámpaatiin, úlafilafi hicuku Yéesu.” ");
INSERT INTO krx_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip naacaasok ho Andre, poko t’ésupakii incakasok ho Yéesu. ");
INSERT INTO krx_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yéesu naañahanii: “Caanak ca cícoliyoocol, ancuk hamake ha hiti inci, Añii An, kati híyisanee. ");
INSERT INTO krx_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Inci pusok aluu pánipani ya, taamanta kaalat kunowut t’etaam nkiket, efikutowo lamma etenko, pale niŋ kiketaa efikupukool meemak. ");
INSERT INTO krx_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","An óo an éelafiye eloŋ ya eteyoo áfaapuul teyyo, pale an óo an eenate eloŋ ya eteyoo ti púlunta púlooŋ empe afaataak eloŋ ya eepayantoo ya. ");
INSERT INTO krx_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","An óo an éelafiye piyeno áhina ya atoom, ánapaniyam, apan la inci fayeno la, áhina ya atoom lompo afaayeno toko. An óo an eeyem áhina ya atoom, Paapaa atoom áfaamakiyanoo.” ");
INSERT INTO krx_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yéesu nene asokii: “Fiye yaanam yoopiya emeeŋe niŋ kúnuul. Weyme inci fasok? Fo inci fasok: 'Paapaa fakanam ti caanak ca citi kúnuul enke'? Haani, kaatuko caanak ence fanfaŋ ciwune inci ínkey ti púlunta empe. ");
INSERT INTO krx_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Paapaa, yísan hamake ha hiti caacawi!” Fiye, hilim níhifulii patiila nihisok: “Inci yísanaa ho ántuŋ efinene yísan ho.” ");
INSERT INTO krx_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kayoŋ ka keeyeniye ka toko nkísi eehuu, nkusok: “Aŋuu pasapal etiil” pale, pakakee teyii nkasok: “Maleekoo ékupe neyoo.” ");
INSERT INTO krx_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yéesu naasokii: “Inci tom wune hilim eehuu níhikupee pale aluu niwune. ");
INSERT INTO krx_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Fiye kíiti ya eti púlunta empe écoliyoo; fiye ati hikaw ha ati púlunta empe afaaheekee. ");
INSERT INTO krx_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pale niŋ inci séepinee, fáñakii ti faŋam pakan paka púlooŋ.” ");
INSERT INTO krx_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Asokaasok kilim enkuu ápiyisan puume naakaakaay eket. ");
INSERT INTO krx_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kayoŋ ka nkiñahanoo: “Ukalaŋaakalaŋ ti hilim ha heesiiŋanee ha nii Eenucee ya ati Pútuun pa afaatowo fo cancowiyaaw. Fiye awe, puume ayyina hisoku nii Añii An áfaaseepinee? Ayme ayem Añii An aŋuu?” ");
INSERT INTO krx_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yéesu naañahanii: “Ecaaŋ ya uyya niŋ aluu pale etefiyo. Nitowo ti pikaayu fa innitaake fa ecaaŋ ya, ancuk énimaan ya étenowii ti aluu. Kaatuko eeyem ya ti pikaayu ti énimaan ámeyiyantoo pa naayem ti pikaayu. ");
INSERT INTO krx_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Páawoo unka nitaake ecaaŋ ya, níyinan ti ecaaŋ ya kati níyenoonii epuuk ya pakati ecaaŋ ya.” Ta Yéesu naapaye ta káakup naañako apiyoliyii. ");
INSERT INTO krx_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Háati fa Yéesu náahine fa píyisan peemeeŋe hátikinii, káyinanut teyoo. ");
INSERT INTO krx_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Fiyuu hilim ha eeha ayaamakoola ya Esaaya naakiice ha nihitaakiye, hisok: “Ateeteyo, ayme áyinane ekooŋan ya etoonii? Ti ayme Ateeteyo náayisane sempe sa siti sipeesoo?” ");
INSERT INTO krx_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kayinaat káyinan. Esaaya nene akiic kati akaman unaa heewune ha. Asok: ");
INSERT INTO krx_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pútuun pa púfuumanii mpiyankan saanii, ancuk timpi kacuk niŋ ñíkinii, timpi kámeyi niŋ kunuuwii, étikayesoonii lipe ti inci Pútuun pa inci kati kúuñanii.” ");
INSERT INTO krx_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Esaaya asokaasok eehuu kamma naacuke hamake ha hiti Yéesu náakup kiteyoo. ");
INSERT INTO krx_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Antúŋ hícump pakan, háati ti pakati kikaw ka pakati Pusuwif pa, nkáyinan ti Yéesu pale Pufalisaay pa kawune káhaañiit ho káyisan ti kafeyatan kapiyaanee ti éluumuma ya. ");
INSERT INTO krx_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kaatuko kafisakanoolaa-fisakanool pakan paka kati kámakiyanii pihaŋ fa Pútuun pa éfipimakiyanii fa. ");
INSERT INTO krx_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yéesu naaceek niŋ kaawiiluyoo naasok: “An óo an éeyinane ti inci, áyinanut ti inci pale ti éepoñiyaam ya náayinane. ");
INSERT INTO krx_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Apan an óo an eecukaam acukaacuk lompo éepoñiyaam ya. ");
INSERT INTO krx_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Inci kéyyookey ti púlunta pa samat nii ecaaŋ, ancuk an óo an éeyinane ti inci atatowo ti énimaan ya. ");
INSERT INTO krx_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","An óo an éesiye hilimam átuulut ho, inci tom fáhinoo kíiti insiiŋanoo ti pisiya, kaatuko inci kéyyoot ti púlunta pa kati hín pakan paka kíiti insiiŋanii ti pisiya; inci, kafakan pakan paka kuwune inci ínkey. ");
INSERT INTO krx_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pale an óo an eepookaam naapook kasayan hilimam ataakaataak áhina kíiti: hilim eeha inci insoke ha éfihihinoo kíiti ti hinoom ha hikelan ha hiti púlunta pa. ");
INSERT INTO krx_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kaatuko inci kúput héefulii ti inci, pale Paapaa ya éepoñiyaam ya asokaam eeha inci iññaŋe ha hisoku niŋ fa inci iññaŋe ho fa hisoku. ");
INSERT INTO krx_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Inci méyimeyi nii hilim ha hiteyoo heesiiŋanee ha nihiwufan eloŋ ya eepayantoo ya. Eeha inci insok ha, insoksok ho samat nii fa Paapaa atoom naasokaam fa.” ");
INSERT INTO krx_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Le niŋ pahaaño pa piti Himuusu ha, Yéesu náameyi nii caanak ca cícoliyoocol kati akatan púlunta empe naakaay pati Paapaa ya. Kápiliŋ ti púcook pa náalafiye pakateyoo keeyem ka ti púlunta pa, náalafiyii lompo fo ti pikelan. ");
INSERT INTO krx_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yéesu niŋ pinapana pa pakateyoo nkayeno hili káciim, tempo loho áhampaatiin a ati piseetaani pa apayaa híluuŋu Judas Iskaliyot, añii ya ati Simon, kati áful ti Yéesu. ");
INSERT INTO krx_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yéesu náameyi nii Paapaa ya awufanoowufan sempe sa púlooŋ, náameyi lompo nii akina pati Pútuun pa náafulii ántuŋ pati Pútuun pa naayem ti puñoho. ");
INSERT INTO krx_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Fiye naalito ti hili ha, naawaat hísool ha hiteyoo henfakat ha, naacoop kaafaal naacenk ko ti hiñowuyoo. ");
INSERT INTO krx_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Eehuu hipipa, naawas man ti epool, náayaañ hiñowu woot pinapana pa pakateyoo, naatoot wo niŋ kaafaal enka naacenke ka ti hiñowuyoo. ");
INSERT INTO krx_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Apucol ti Simon Piyeer, Simon Piyeer naasokoo: “Ahámpaatiin, fo awe kaakaay hiñowu wootam?” ");
INSERT INTO krx_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yéesu naañahanoo: “Fiye fiye, awe míit eeha inci iyyem ha ti íhinu pale hátikin áafapannum.” ");
INSERT INTO krx_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piyeer naasokoo: “Haani, hiyinaat pitaako! Aatiñow wootam.” Yéesu naañahanoo: “Taamanta inci ñowut wooti áatiyini hitaaku himpaac ti inci.” ");
INSERT INTO krx_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Piyeer naasokoo: “Ooto Ahámpaatiin, timpi ñow wootam lamma pale sipeesam niŋ hikawam lompo!” ");
INSERT INTO krx_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yéesu naañahanoo: “An eeñowiye, wootoo lamma naañaŋe hiñowu, akina an eekuule naat. Antúŋ aluu nikuulaakuul, pale neetaat an óo an taaluu.” ");
INSERT INTO krx_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kaatuko ámeyimeyi eekaakaay ya hífulu teyoo, tempo wune naasok: “Neetaat an óo an taaluu akuule.” ");
INSERT INTO krx_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ta naapaye ta hiñowu wootii, naawaso hísool ha hiteyoo henfakat ha, naañoho ti káayenuma ka kiteyoo. Naacakanii: “Fo nímeyimeyi eeha inci impaye ha aluu íhinu? ");
INSERT INTO krx_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Inniyonkalam-yonkal 'Akalaŋana' niŋ 'Ahámpaatiin', ántuŋ fo, kaatuko akina inci iyyem. ");
INSERT INTO krx_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Fiye páawoo inci, Akalaŋana ya niŋ Ahámpaatiin a ataaluu, ñowaa woot aluu, aluu lompo niñaŋaa puñowool woot aluu. ");
INSERT INTO krx_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Inci yísanaayisan aluu fa éfinihin. Níhin samat nii fa inci ínhine fa aluu. ");
INSERT INTO krx_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Inci pusok aluu pánipani ya, amiikan ahaŋut áhampaatiin a ateyoo, eepoñee lompo ahaŋut eepoñoo ya. ");
INSERT INTO krx_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Páawoo nimeya fiye enke, efiniyeno ti pásuuma niŋ níhinaa ko. ");
INSERT INTO krx_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Neetaat ti káakup kitaaluu púlooŋ, inci méyimeyi payenka inci immamale ka. Pale heekiicee ha ti hilim ha hiti Pútuun pa, fo hitaako, hisok: 'Aŋa inci mpáacinoole ya neyoo hímpuul ha hitoom, áyesoonii ti inci.' ");
INSERT INTO krx_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Inci oopa ti hisoku aluu eehuu fiye le niŋ efihitaako, ancuk niŋ hitaakiyaa ínniyinan nii Inci Yem aŋa inci iyyem ya. ");
INSERT INTO krx_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Inci pusok aluu pánipani ya, an óo an eesayane aŋa inci impoñe, inci naasayane; an óo an eesayanaam, asayanaasayan éepoñiyaam ya.” ");
INSERT INTO krx_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yéesu ta naapaye ta káakup enke, yaanoo neemeeŋ niŋ kúnuul náakupii picaaŋ cataŋ: “Inci pusok aluu pánipani ya, akee ti aluu áfaaful ti inci.” ");
INSERT INTO krx_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Pinapana pa nkásincanool, ínnimii niŋ ayme naayem. ");
INSERT INTO krx_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Akee teyii, anapana ya aŋa Yéesu náalafiye ya, naayeno pukoloo ti taapul ya. ");
INSERT INTO krx_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Piyeer náakupoo niŋ pasiŋ: “Cakanoo niŋ ayme naayem.” ");
INSERT INTO krx_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Fiye, anapana ya aŋuu naayaaco ti Yéesu, naacakanoo: “Ahámpaatiin, niŋ ayme ayyem?” ");
INSERT INTO krx_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yéesu naañahanoo: “Akina ayem aŋa inci inkaakaay ya kawufan cífiitiin hímpuul eehe niŋ inci púucaa co ti mutop ma.” Fiye, náapuuc cífiitiin hímpuul ha, naawufan co Judas, añii ya ati Simon Iskaliyot. ");
INSERT INTO krx_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Emma Judas naasaye ma cífiitiin hímpuul ha, áhampaatiin a ati piseetaani pa néewuuliyoo. Yéesu naasokoo: “Eeha ayyem ha ti ékey íhinu, hín ho mpacas.” ");
INSERT INTO krx_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pale háati an ti keeyeniye ka ti taapul ya ámiit heewune Yéesu naasokoo fo. ");
INSERT INTO krx_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Páawoo Judas ayem amanka ya mañ ma, pakakee pinapana pa incukii nii Yéesu hisokuyoo naayaake akaay hinoom aŋa nkasoolahe ya hak pahaaño pa piti Himuusu ha, niŋ ekina tom awun waah keeleke ka. ");
INSERT INTO krx_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Emma Judas naasaye ma cífiitiin hímpuul ha, náaful tíkitaaŋ. Tempo hánant. ");
INSERT INTO krx_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ta Judas naakaaye ta, Yéesu naasok: “Fiye hamake ha hiti inci, Añii An, éfihiyisanee, hamake ha hiti Pútuun pa éfihiyisanee lompo pínapii ti inci. ");
INSERT INTO krx_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Niŋ hamake ha hiti Pútuun pa híyisanee pínapii ti inci, ooto Pútuun pa faŋ etempo éfipiyisan lompo hamake ha hiti inci, Añii An, ántuŋ éfipiyisan ho toko fiye. ");
INSERT INTO krx_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Epuukam, inci etifiyo niŋ aluu. Efiniŋesam, pale samat nii fa inci insoke fa Pusuwif pa, insok ho fiye aluu: 'Pa inci iyyem pa ti pikaayu, étiniyini po ékey.' ");
INSERT INTO krx_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Fiye inci oopa ti kawufan aluu hilim heesiiŋanee héeyeeni: nílafooli, samat nii fa inci íllafiye fa aluu, fo inniñaŋe pálafooli. ");
INSERT INTO krx_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Niŋ nílafooliyaa, pakan paka púlooŋ éfikameyi nii aluu pinapana pa pakatoom.” ");
INSERT INTO krx_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Piyeer naacakanoo: “Ahámpaatiin, peyme ayyem ti pikaayu?” Yéesu naañahanoo: “Pa inci iyyem pa ti pikaayu, aayinaatam kanapan toko fiye, pale hátikin áafanapaniyam po.” ");
INSERT INTO krx_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piyeer naacakanoo: “Ahámpaatiin, weyme uwune inci étiyini kanapani fiye? Inci fawufan eloŋam kamma awe.” ");
INSERT INTO krx_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yéesu naañahanoo: “Fo pánipani aafawufan eloŋi kamma inci? Inci pusoki pánipani ya, káayiin ekutoon kúlookum áafalaacin fo ñáhaaciil nii áameyiyam-méyi.” ");
INSERT INTO krx_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yéesu nene asok pinapana pa pakateyoo: “Timpi niliim, níyinan ti Pútuun pa ínniyinan ti inci lompo. ");
INSERT INTO krx_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ti ekumpaan ya eti Paapaa atoom, taakaataak píkaap peemeeŋe; niŋ neetaat fo, inci etisok aluu nii inci picaamemanool aluu la efinikin. ");
INSERT INTO krx_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Niŋ inci kaayaa kaamemanool aluu la efinikin, fáñohoonii pucoop aluu nipiyeno niŋ inci, ancuk la inci iyyem la, aluu lompo inniyeno toko. ");
INSERT INTO krx_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Pa inci inkaakaay pa, nímeyimeyi pítin pa.” ");
INSERT INTO krx_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas naasokoo: “Ahámpaatiin, unii úmiit peyme ankaakaay, ooto puume éfuuyini kameye pítin pa?” ");
INSERT INTO krx_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yéesu naasokii: “Inci yem pítin pa, inci lompo yem pánipani ya niŋ eloŋ ya. An átayini pikaayu pati Paapaa ya taamanta anaput ti inci. ");
INSERT INTO krx_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Niŋ nimeyaam éfinimeyi lompo Paapaa ya. Písik fíyooy nímeyiyoomeyi innicukoo.” ");
INSERT INTO krx_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip naasokoo: “Ahámpaatiin, yísan unii Paapaa ya, eehuu efihifom unii.” ");
INSERT INTO krx_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yéesu naañahanoo apusokoo: “Filip, háati fa inci infiyye fa fiye naaluu, fo fiye awe míitam? An óo an eecukaam acukaacuk Paapaa ya, ooto weyme uwune ansok: 'Yísan unii Paapaa ya?' ");
INSERT INTO krx_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Fo áayinanut nii inci oopa ti Paapaa ya, Paapaa ya lompo náayemi ti inci? Kilim enka inci insok ka aluu kúfuliyoot ti inci himuumam, pale Paapaa ya eekine ya ti inci ayem ti íhinu páhin pa piteyoo. ");
INSERT INTO krx_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Níyinanam niŋ inci sokaa nii, inci oopa ti Paapaa ya, Paapaa ya lompo oopa ti inci. Niŋ níyinanut kilim ka kutoom, níyinan kamma páhin empa inci ínhin pa. ");
INSERT INTO krx_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Inci pusok aluu pánipani ya, an óo an éeyinane ti inci, eeha inci iyyem ha ti íhinu, akina lompo áfanahin ho. Afánahin pihaŋ le kaatuko pati Paapaa ya inci inkaakaay. ");
INSERT INTO krx_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Waah óo waah ewwa inniluume ti caacawam, inci fáhin wo, ancuk Añii ya áyisanaa hamake ha hiti Paapaa ya. ");
INSERT INTO krx_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Niŋ niluumaam waah ti caacawam, inci fáhin wo.” ");
INSERT INTO krx_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yéesu nene asok pinapana pa pakateyoo: “Niŋ nílafiyaam, éfinituul kilim ka kutoom keesiiŋanee ka. ");
INSERT INTO krx_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Inci faluum Paapaa ya apuwufan aluu akee Ayankanana eekaakaay piyeno niŋ aluu fo cancowiyaaw. ");
INSERT INTO krx_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Akina ayem Kunuu enka nkíyisan ka pakan paka pánipani ya, aŋa ammeya ya nii pakati púlunta pa kayinaatoo kasayan kamma nkacukutoo kámiitoo. Pale aluu, nímeyiyoomeyi kaatuko oopa niŋ aluu, afaakin taaluu. ");
INSERT INTO krx_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Inci tikat aluu lammayaluu, fáñohoonii ti aluu. ");
INSERT INTO krx_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Etikamp pakati púlunta empe etinene kacukam. Pale aluu efinicukam kamma inci inkaakaay eloŋ, aluu lompo efiniloŋ. ");
INSERT INTO krx_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Oom hinoom éfinimeyi nii inci oopa ti Paapaa atoom, aluu ínniyemi ti inci, inci lompo íyyemi ti aluu. ");
INSERT INTO krx_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","An óo an eecoke kilim ka kutoom keesiiŋanee ka náatuul ko, oom an álafiyamlafi. An óo an éelafiyaam, Paapaa atoom áfaalafiyoo inci lompo fálafiyoo, íyyisanoolo teyoo.” ");
INSERT INTO krx_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Fiye Judas (neetaat Judas Iskaliyot) naasokoo: “Ahámpaatiin, puume áafayisanoolo toonii apan áatiyisanoolo ti púlunta pa?” ");
INSERT INTO krx_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yéesu naañahanoo apusokoo: “Niŋ an álafiyaam áfaatuul hilimam, Paapaa atoom áfaalafiyoo. Efúukey teyoo nuukin neyoo. ");
INSERT INTO krx_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","An óo an éelafiitam átatuul hilimam. Kilim enka ínnisi ka, kutoom tom pale kiti Paapaa ya éepoñiyaam ya. ");
INSERT INTO krx_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Eehuu púlooŋ inci insoke aluu ti waati eyye inci iyyem ye niŋ aluu. ");
INSERT INTO krx_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pale Ayankanana ya eeyem ya Kunuu ka keenape ka, kikina Paapaa ya naakaakaay époñii ti caacawam, efikikalaŋan aluu waah óo waah, nkínawunan aluu enka púlooŋ inci insoke ka aluu. ");
INSERT INTO krx_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Inci pikat aluu kásuumaay ka, kásuumaay ka kutoom inci iyyem aluu ti kawufan. Etiwufan ko aluu samat nii fa pakati púlunta pa nkawufan fa. Timpi niliim timpi nife. ");
INSERT INTO krx_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nísiyaasi fa inci insoke fa aluu nii: 'Inci pikaay, pale inci fáñohoonii.' Niŋ nílafiyaamlafi, anti niyeno ti pásuuma kamma inci iyyem ti pikaayu pati Paapaa ya, kaatuko Paapaa ya ahaŋaam. ");
INSERT INTO krx_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Inci sokaasok ho aluu féefiye le niŋ enkuu efikitaako, ancuk niŋ kitaakiyaa, ínniyinan. ");
INSERT INTO krx_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Káakupam naaluu etikimeeŋ kaatuko ati hikaw ha ati púlunta empe oopa ti ékey. Ayinaat waah ti inci, ");
INSERT INTO krx_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","pale pakati púlunta pa kañaŋaa kameye nii, inci láfilafi Paapaa ya te eeha Paapaa ya nasokam ha, hikina inci nínhin. Nilito upukaayaa!” ");
INSERT INTO krx_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yéesu nene asok pinapana pa pakateyoo: “Inci yem enuun pánipani ya eti wiiñ ya, Paapaa atoom ayem amankoola punuun pa piti wiiñ ya. ");
INSERT INTO krx_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kaanaay óo kaanaay keeyem ti inci apan kupukut, afaafiit ko. Pale kaanaay óo kaanaay keepuke, afaapentekal ko kati kícepenii ancuk kupukaa pihaŋ toko. ");
INSERT INTO krx_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Iyyema aluu, nipayeepa kaakuulan kamma hilim eeha inci insoke ha aluu. ");
INSERT INTO krx_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nitowo ti inci samat nii fa inci intowiye fa ti aluu. Kaanaay lamma etenko kiyinaat hitaaku papukal niŋ kutowiit ti enuun ya. Fo lompo incuke ti aluu, niŋ nitowiit ti inci, eloŋ ya etaaluu etetaak papukal empa éfipusuum Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Inci yem enuun ya eti wiiñ ya, aluu niyem unaay wa, niŋ an atowiyaa ti inci te inci intowo teyoo, oom an, eloŋ ya eteyoo efeetaak papukal peemeeŋe péesuume Pútuun pa, kaatuko niyinaat íhinu waah niŋ inci neetaat taaluu. ");
INSERT INTO krx_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","An óo an eetowiit ti inci afaawantee tíkitaaŋ samat nii kaanaay keefiitee. Unaay ewwe efuusuucan niŋ fúlaa toko nuuyesee nuuwantee ti seemak upusowanee. ");
INSERT INTO krx_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Niŋ nitowiyaa ti inci te kilim ka kutoom nkutowo taaluu, waah óo waah ewwa ínnilafiye, niluum, efinitaak wo. ");
INSERT INTO krx_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Paapaa atoom fiye naakaakaayee kámakiyan: eloŋ ya etaaluu etaak papukal peemeeŋe inniyeno pinapana pa pakatoom. ");
INSERT INTO krx_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Samat nii fa Paapaa ya náalafiyaam fa, fo lompo inci íllafiye aluu. Nitowo ti pálafi pa putoom. ");
INSERT INTO krx_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Niŋ nítuulaa kilim ka kutoom keesiiŋanee ka efinitowo ti pálafi pa putoom, samat nii fa inci íntuule fa kilim ka kiti Paapaa atoom intowo ti pálafi pa piteyoo. ");
INSERT INTO krx_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Inci sokaasok aluu eehuu, ancuk pásuuma empa inci intaake pa ti inci, aluu lompo innitaak po taaluu, pásuuma pa pitaaluu mpiyeno pásuuma pántoon. ");
INSERT INTO krx_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ehe hilim ha hitoom: nílafooli samat nii fa inci íllafiye fa aluu. ");
INSERT INTO krx_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","An ayinaat pálafi an pihaŋ eewufane eloŋoo kamma pákawiyoo. ");
INSERT INTO krx_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Niŋ níhinaa eeha inci insoke ha aluu, aluu pákawiyam. ");
INSERT INTO krx_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Etinene yonkal aluu píhina pa pakatoom, kaatuko áhina ámeyiyantoo eeha áhampaatiin a ateyoo náhin. Inci yonkalaayonkal aluu pákawiyam, kaatuko eeha púlooŋ inci ínsiye ha ti Paapaa atoom sokaasok ho aluu. ");
INSERT INTO krx_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Aluu tom nimamalaam, inci mamale aluu uwwufan aluu pitiyo kati nikaay, eloŋ ya etaaluu neetaak papukal, papukal empuu mputowo fo cancowiyaaw, ancuk waah óo waah ewwa inniluume Paapaa ya ti caacawam, afaawun wo aluu. ");
INSERT INTO krx_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ehe hilim ha hitoom: nílafooli. ");
INSERT INTO krx_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Niŋ pakati púlunta pa kanataa aluu, nímeyi nii inci nkátikine kanat. ");
INSERT INTO krx_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Niŋ aluu pakati púlunta pa, pakati púlunta pa anti kálafi aluu kamma inniyem pakoonool paka. Pale aluu pakati púlunta pa tom, inci mamale aluu ínkatinool aluu niŋ púlunta pa, ekina ewune pakati púlunta pa nkanat aluu. ");
INSERT INTO krx_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nínawuno hilim eeha inci insoke ha aluu, hisok: 'Amiikan ahaŋut áhampaatiin a ateyoo.' Niŋ kakallanaam efikakallan aluu lompo, niŋ kátuulaa kilim ka kutoom éfikatuul lompo kilim ka kitaaluu. ");
INSERT INTO krx_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pale eehuu púlooŋ éfikahin ho aluu kamma inci, kaatuko kámiit éepoñiyaam ya. ");
INSERT INTO krx_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Niŋ inci kéyyoot hínum, niŋ inci túunanutii hínum lompo hilim ha, anti kámuuyenaati. Pale fiye etikataak la éfikatii kati kafak ti umuuyen wa uteyii. ");
INSERT INTO krx_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","An óo an eenataam, anataanat lompo Paapaa atoom. ");
INSERT INTO krx_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Niŋ inci hínut hínum weecukantee ewwa an ataapala áhin, anti kámuuyenaati. Pale fiye, kacukaacuk apan nkanatam niŋ Paapaa atoom. ");
INSERT INTO krx_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pale heekiicee ha ti hilim ha hiteyii heesiiŋanee ha hitaakiyaa, hisok: 'Kanataam-nat pale kataakut la éfikatii kati kanatam.' ");
INSERT INTO krx_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Inci fápoñii aluu Ayankanana ya éefulii ya pati Paapaa ya, Kunuu enka nkíyisan ka pakan paka pánipani ya. Niŋ kíkeyyoo, kikina efikiyeno eetantake ya atoom. ");
INSERT INTO krx_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Aluu lompo efiniyeno keetantake ka pakatoom, kaatuko niyenaayeno niŋ inci kápiliŋ ti púcook. ");
INSERT INTO krx_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Inci sokaasok aluu eehuu púlooŋ ancuk timpi níful ti káyinan enka innitaake ka ti inci. ");
INSERT INTO krx_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Efikayaan aluu lompo ti púluumuma pa, caanak lompo unca ti ékey ta an eemuke aluu, facukoo nii páhin pa piti Pútuun pa naayaake. ");
INSERT INTO krx_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Efíkahin eehuu kamma nkámiit Paapaa ya kámiitam lompo. ");
INSERT INTO krx_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Pale inci sokaasok aluu eehuu ancuk niŋ caanak ca citeyii cícoliyoo, ínninawuno nii inci sokaasok ho aluu hínum. Sokut ho aluu ti púcook pa kaatuko inci oopa niŋ aluu.” ");
INSERT INTO krx_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yéesu nene asok pinapana pa pakateyoo: “Pale fiye, pikaayu pati éepoñiyaam ya inci inkaakaay apan an ti aluu aneetaatam ti kacakan: 'Peyme ankaakaay?' ");
INSERT INTO krx_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kamma eeha inci insoke ha aluu, saan aluu unsa simeeŋe kúnuul. ");
INSERT INTO krx_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pale pánipani ya inci iyyem aluu ti hisoku, haŋa panap ti aluu inci pikaay, kaatuko niŋ inci kaayut, Ayankanana ya átakey ti aluu. Pale niŋ inci kaayaa fápoñiyoo aluu. ");
INSERT INTO krx_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Niŋ ácoliyoo, áfaayisan pakati púlunta pa picaaŋ cataŋ nii, pilinco ti pámiiloolal pa piteyii nkayaake ti kiti kaamuuyen ka, kiti pucoonool pa niŋ kiti kíiti ya eti Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Pilinco nkayaake kiti kaamuuyen ka, kamma nkáyinanut ti inci. ");
INSERT INTO krx_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Pilinco nkayaake kiti pucoonool pa, kamma inci inkaakaay pati Paapaa ya etinene nicukam. ");
INSERT INTO krx_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Pilinco nkayaake kiti kíiti ya, kamma ati hikaw ha ati púlunta empe naasiiŋanee ti pisiya. ");
INSERT INTO krx_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Waah weemeeŋe inci intaake uti hisoku aluu pale éfuunapi ti aluu fiye. ");
INSERT INTO krx_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Niŋ Kunuu enka nkíyisan ka pakan paka pánipani ya kíkeyyoo, éfikitintiŋan aluu ti pánipani ya púlooŋ. Kaatuko héefulii ha tenko tom nkúkup pale eeha nkísiye ha púlooŋ, hikina efinkusok aluu, nkikaman aluu heekaakaay ékey. ");
INSERT INTO krx_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Káyisan hamake ha hitoom nkikaakaay kaatuko efinkusok aluu eeha nkisaye ha ti inci. ");
INSERT INTO krx_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Waah óo waah uti Paapaa ya utoom, ekina ewune inci insok aluu nii Kunuu ka kiti pánipani ya efinkusok aluu eeha nkisaye ha ti inci.” ");
INSERT INTO krx_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yéesu nene asok pinapana pa pakateyoo: “Le niŋ caanak ceetama etinene nicukam, niŋ fúlaa toko le niŋ cikee caanak ceetama nene nicukam.” ");
INSERT INTO krx_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Fiye pakakee ti pinapana pa pakateyoo nkayeno picakanool: “Weyme náalafiye hisoku: 'Le niŋ caanak ceetama etinicukam, niŋ fúlaa toko le niŋ cikee caanak ceetama nene nicukam'? Weyme náalafiye hisoku lompo: 'Kaatuko inci pikaayu pati Paapaa ya'?” ");
INSERT INTO krx_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Pinapana pa nene kasokool: “Weyme uyem 'caanak ceetama'? Umíit weyme náalafiye hisoku.” ");
INSERT INTO krx_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yéesu náameyi nii pinapana pa kálafiyoolafi kacakan, naasokii: “Fo picakanool inniyaake kiti eeha inci insoke ha? Inci sok: 'Le niŋ caanak ceetama etinicukam, niŋ fúlaa toko le niŋ cikee caanak ceetama nene nicukam.' ");
INSERT INTO krx_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Inci pusok aluu pánipani ya, efinikooŋ innisampoolo, tempo pakati púlunta pa ti pahaaño. Efiniyeno ti kúnuul pale kúnuul ka kitaaluu efikiyeso pásuuma. ");
INSERT INTO krx_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Aal, íyyiŋooliyoo, afaayeno ti kúnuul kamma waatiyoo néetuuniye. Pale niŋ apukaa atanene ánawuno ñíseeña ña ñiteyoo kaatuko súumoosuum kamma naapuke añii. ");
INSERT INTO krx_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Fo lompo incuke taaluu: aluu unka ti kúnuul fiye, pale inci fanene cuk aluu. Tempo efiniyeno ti pásuuma apan an atanene áfulan aluu tempo. ");
INSERT INTO krx_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Oom hinoom etinene niluumam waah. Inci pusok aluu pánipani ya, niŋ niluumaa waah Paapaa ya ti caacawam, afaawun wo aluu. ");
INSERT INTO krx_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Fo fiye niloot niluum waah ti caacawam. Niluum efinitaak, ancuk pásuuma pa pitaaluu piyeniyaa pásuuma pántoon. ");
INSERT INTO krx_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Eehuu púlooŋ niŋ kícantiitu inci insoke ho aluu. Pale caanak unca ti ékey ta inci etinene kúp niŋ aluu niŋ kícantiitu, pale fákup niŋ aluu picaaŋ cataŋ kiti Paapaa ya. ");
INSERT INTO krx_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Oom hinoom ti caacawam efiniluum; inci neetaat ti hisoku aluu nii, faluum Paapaa atoom kiti aluu. ");
INSERT INTO krx_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kaatuko Paapaa ya himuumoo, álafilafi aluu kamma ínnilafiyaam ínniyinan nii pati Pútuun pa inci ínfulii. ");
INSERT INTO krx_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Pati Paapaa ya inci ínfulii píkey ti púlunta pa, fiye inci fáful ti púlunta pa pikaay pati Paapaa ya.” ");
INSERT INTO krx_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Pinapana pa pakateyoo nkasokoo: “Iyyoo, fiye áakupaa niŋ unii picaaŋ cataŋ áakuput niŋ unii niŋ kícantiitu. ");
INSERT INTO krx_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Uméyimeyi fiye nii áameyimeyi waah óo waah, aasoolahut an apicakani. Ekina ewune núuyinan nii pati Pútuun pa ánfulii.” ");
INSERT INTO krx_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yéesu naañahanii: “Fo níyinanaayinan fiye silaŋ? ");
INSERT INTO krx_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nísiitan! Caanak unca ti ékey, cícoliyoocol fala, ta efinihancaloolo, an óo an naayet pateyoo innikatam lamayam. Pale etiyeno lamayam kaatuko Paapaa ya oopa niŋ inci. ");
INSERT INTO krx_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Inci sokaasok aluu eehuu púlooŋ kati nitaak kásuumaay ti inci. Ti púlunta empe efiniyeno ti kúnuul, pale nísik piliit! Inci heekaaheek púlunta pa.” ");
INSERT INTO krx_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yéesu ta naapaye ta káakup, náahaafin, naasok: “Paapaa, colaa toko, yísan pakan paka hamake ha hiti añiini, ancuk añii ya áyisanii hamake ha hitii. ");
INSERT INTO krx_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kaatuko awe ufanoo sempe ti pakan paka púlooŋ, ancuk awufanaa eloŋ ya eepayantoo ya pakan paka púlooŋ payenka awwufanoo ka. ");
INSERT INTO krx_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Eloŋ ya eepayantoo ya eyem kameyeyi, awe Pútuun pa poonool pa piti pánipani ya niŋ aŋa ámpoñii ya, Yéesu Krista. ");
INSERT INTO krx_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Inci yísanaayisan hamake ha hitii ti púlunta pa, kaatuko payaapa páhin empa awwufanaam pa kati hín. ");
INSERT INTO krx_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Fiye Paapaa, mákiyanam hátikini, niŋ hamake eeha inci intaake ha naawe le niŋ púlunta pa efipiliilee. ");
INSERT INTO krx_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Pakan paka payenka ammamale ka ti púlunta pa uwwufanamii, inci híniihin kápimeyiyi. Kayenaayeno pakatii, aawufanaamii, nkátuul hilim ha hitii. ");
INSERT INTO krx_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Fiye kámeyimeyi nii waah óo waah ewwa awwufanaam, ti awe núufulii. ");
INSERT INTO krx_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kaatuko kilim enka awwufanaam ka, inci sokiisok ko nkacoon ko. Nkámeyi nii pánipani ti awe inci ínfulii, nkáyinan nii awe póñiyaam. ");
INSERT INTO krx_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Inci luumuu kiteyii, luumut kiti pakati púlunta pa pale kiti pakan paka payenka awwufanaam ka, kaatuko pakatii. ");
INSERT INTO krx_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Waah óo waah utoom utii, samat nii fa waah óo waah utii nuuyem fa utoom, hamake ha hitoom níhiyisanee pínapii teyii. ");
INSERT INTO krx_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Etinene yeno ti púlunta empe, pale poko ti púlunta pa efikayeno, inci ékey puu ti awe. Paapaa ya eenape yuu, mankoolii ti caacawi enca awwufanaam ca, ancuk samat nii fa immaayemaa fa an oonool poko lompo nkayeno an oonool. ");
INSERT INTO krx_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ta inci iyyeniye ta niŋ poko, inci yeniyii kaamankool ti caacawi enca awwufanaam ca. Faasiifaas, an teyii ácimut niŋ fúlaa eeñaŋe ya hícimu ancuk heekiicee ha hitaakiyaa. ");
INSERT INTO krx_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Fiye ékey pati awe iyyaake pale eehuu inci insoke le niŋ inci fáful ti púlunta pa, ancuk pásuuma empa inci intaake pa ti inci, poko lompo kataakaa po teyii pántoon. ");
INSERT INTO krx_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Inci ufaniiwufan hilim ha hitii, púlunta pa mpinatii, kaatuko samat nii fa inci inneetaat fa ati púlunta pa, poko lompo fo nkaneetaat pakati púlunta pa. ");
INSERT INTO krx_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Luumuti aakati fúlanii ti púlunta pa, pale aakati mankoolii ti áhampaatiin a ati piseetaani pa. ");
INSERT INTO krx_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kaneetaat pakati púlunta pa samat nii fa inci inneetaat fa ati púlunta pa. ");
INSERT INTO krx_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Hín eloŋ ya eteyii púlooŋ epiyeno etii pínapii ti pánipani ya. Hilimi hiyem pánipani ya. ");
INSERT INTO krx_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Samat nii fa ámpoñiyaam fa ti púlunta pa, fo lompo inci impoñii ti púlunta pa. ");
INSERT INTO krx_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kamma poko inci uwwufanuu eloŋam púlooŋ, ancuk poko lompo, eloŋii púlooŋ eyeniyaa etii pínapii ti pánipani ya. ");
INSERT INTO krx_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Luumuti kiti pinapana pa payenkuu lamma, pale kiti pakan paka lompo keekaakaay ka káyinan ti inci niŋ kásiyaa kilim ka kiteyii. ");
INSERT INTO krx_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Paapaa, inci oopa ti kaluum kati kayeno poko púlooŋ an oonool; samat nii fa ayyem fa ti inci, inci lompo íyyemi ti awe, álimaati poko lompo kayeno ti anii. Fiyuu pakan paka pakati púlunta pa éfikayinan nii awe póñiyaam. ");
INSERT INTO krx_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Inci uwwufanii hamake eeha awwufanaam ha kati kayeno an oonool samat nii anii, ");
INSERT INTO krx_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","inci íyyemi teyii, awe íyyemi ti inci, ekina kati ewun nkayeno an oonool pántoon, ancuk púlunta pa pimeya nii awe póñiyaam íllafiyii samat nii fa állafiyaam fa. ");
INSERT INTO krx_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Paapaa, láfilafi pa inci iyyem pa, payenka awwufanaam ka lompo nkayeno po niŋ inci, kati nkacuk hamake eeha awwufanaam ha kamma állafiyaam le niŋ púlunta pa efipiliilee. ");
INSERT INTO krx_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Paapaa, awe eecoonoole ya, pakati púlunta pa kámiiti pale inci méyiyuumeyi, pinapana pa pakatoom nkámeyi nii awe póñiyaam. ");
INSERT INTO krx_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Híniihin kápimeyi caacawi, fáhinii kápimeyi co pihaŋ toko, ancuk pálafi empa áyyisanaam pa piyeniyaa teyii, inci íyyemi teyii.” ");
INSERT INTO krx_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ta Yéesu naapaye ta kaluum, naañak niŋ pinapana pa pakateyoo nkafiitan hiyanu ha heesooŋe ha hiti Ketulon. Toko intaak kankaŋ, Yéesu niŋ pinapana pa pakateyoo nkanako teyyo. ");
INSERT INTO krx_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Caham Judas, eekaakaay ya hífulu teyoo, ámeyimeyi toko kamma Yéesu naloom po pikaayu niŋ pinapana pa pakateyoo. ");
INSERT INTO krx_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Fiye Judas naakaay ti kankaŋ ya, naanapool niŋ kayoŋ kiti pusoocaali pakati Room, poko niŋ pufaasa pakati ekumpaan ya enfakat ya eti Pútuun pa, payenka ñíhampaatiin puwaaseena pa niŋ Pufalisaay pa nkapoñe ka. Nkayekan pilampi, kiwiit niŋ pucoolaŋ. ");
INSERT INTO krx_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yéesu náameyi waah óo waah weekaakaayoo pitaako, fiye naalohii naacakanii: “Ayme inniyem ti hiŋes?” ");
INSERT INTO krx_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nkañahanoo: “Yéesu ati Naasalet.” Yéesu naasokii: “Inci yem akina.” Judas, eeyem ya ti hífulu teyoo, naasiiŋo toko neyii. ");
INSERT INTO krx_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ta Yéesu naasokii ta nii: “Inci yem akina,” nkañako puson nkanowal. ");
INSERT INTO krx_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yéesu nene acakanii: “Ayme inniyem ti hiŋes?” Nkañahanoo: “Yéesu ati Naasalet.” ");
INSERT INTO krx_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yéesu naasokii: “Inci sokaasok aluu nii inci yem akina. Iyyema inci inniyem ti hiŋes ooto nikatan payenke kapikaay.” ");
INSERT INTO krx_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Eehuu hitaakaataako ancuk eeha naasoke ha kati hitaako. Asok: “Paapaa, inci púulut háati oonool ti payenka awwufanaam ka.” ");
INSERT INTO krx_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Piyeer náañakii káakuntu ka kiteyoo, naafiit cat kaanuu káali ka kiti amiikan a ati awaaseena ya enfakat a. Amiikan a caacawoo Malukus. ");
INSERT INTO krx_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yéesu naasok Piyeer: “Ñahan káakuntu ka ti kaahoonu etenko! Fo inci etilaan elontoŋ ya eti kúnuul ka enka Paapaa atoom naawufanaam ka?” ");
INSERT INTO krx_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Fiye pusoocaali pa pakati Room niŋ áhampaatiin a ateyii, poko niŋ pufaasa pa pakati ekumpaan ya enfakat ya eti Pútuun pa, nkacok Yéesu nkacenkoo. ");
INSERT INTO krx_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nkátikin kacoopoo pati Annas eeyem ya paapaa ati Kayif aaloo. Oom Kayif ayem awaaseena ya enfakat a ati Pútuun pa ti oom etiil. ");
INSERT INTO krx_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Akina awune kunuu hínum pakati kikaw ka pakati Pusuwif pa nii, haŋa panap an oonool apiket kamma pakan paka. ");
INSERT INTO krx_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Piyeer niŋ akee anapana, nkanapan Yéesu. Oom anapana, awaaseena ya enfakat a ati Pútuun pa ámeyiyoomeyi, ekina ewune naanako niŋ Yéesu ti hank ha hiti awaaseena ya enfakat a, ");
INSERT INTO krx_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","pale Piyeer naatowo tíkitaaŋ hunkut ha. Fiye akee anapana ya, aŋa awaaseena ya enfakat a naameya ya, naañoho tíkitaaŋ, náakup niŋ amiikan a aal a aŋa nafaas a hunkut ha, náanakanii Piyeer páhantuwa. ");
INSERT INTO krx_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Oom aal naasok Piyeer: “Fo awe neetaat lompo akee ti pinapana pa pakati áyiin aŋuu?” Piyeer naañahanoo: “Haani, inci neetaat.” ");
INSERT INTO krx_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Inhemool pimiikan pa niŋ pufaasa pa pakati ekumpaan ya enfakat ya eti Pútuun pa kacokanaa kíceket, nkákiipool ko kasiiŋ kapiyeno písimo kamma immone. Piyeer naasiiŋo neyii apiyeno lompo písimo. ");
INSERT INTO krx_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Awaaseena ya enfakat a ati Pútuun pa naacakan Yéesu kiti pinapana pa pakateyoo niŋ pakalaŋanaloo. ");
INSERT INTO krx_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yéesu naañahanoo: “Inci hátikin pakan paka inci ínkup tan óo tan, ti púluumuma pa niŋ ti hank ha hiti ekumpaan ya enfakat ya eti Pútuun pa inci inkalaŋan, la Pusuwif pa púlooŋ nkapaakool la. Inci taapala sok waah ti piyolo. ");
INSERT INTO krx_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Weyme uwune ancakanam? Cakan pakan paka kéesiyaam ka eeha inci insokii ha, kámeyimeyi picaaŋ cataŋ eeha inci insoke ha.” ");
INSERT INTO krx_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ta Yéesu naasoke ta eehuu, akee ti pufaasa pa keesiiŋiye ka toko naahankoo kapal naasokoo: “Awe háañiye kañahan fiyaaw awaaseena ya enfakat a!” ");
INSERT INTO krx_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yéesu naañahanoo: “Niŋ heenaput inci ínkupe, sok ho le an óo an, pale niŋ heenape inci insoke weyme uwune ansapam?” ");
INSERT INTO krx_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Fiye Annas naasok kacoop Yéesu pati Kayif, awaaseena ya enfakat a, sipeesoo insiloŋ insicenkee. ");
INSERT INTO krx_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ta eehuu nihiyeniye ta pitaako, Simon Piyeer naaloŋ naasiiŋiye toko ti písimo. Fiye pakakee paka nkasokoo: “Fo awe neetaat lompo akee ti pinapana pa pakateyoo?” Pale Piyeer náalaacin naasokii: “Haani, inci neetaat.” ");
INSERT INTO krx_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Akee ti pimiikan pa pakati awaaseena ya enfakat a, eepukee niŋ áyiin a aŋa Piyeer naafiite ya kaanuuwoo, naacakanoo: “Fo inci cukuti neyoo ti kankaŋ ya?” ");
INSERT INTO krx_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piyeer nene asok: “Haani.” Tokotoko káayiin ekutoon nkúlookii. ");
INSERT INTO krx_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Púful toko, pakati kikaw ka pakati Pusuwif pa nkáfulan Yéesu ti ekumpaan ya eti Kayif nuulap kapucoopoo pati ékinuma ya eti Pilaat, ati hikaw ha ati mah ma. Pale poko, kanakiit ti ékinuma ya kaatuko, niŋ kanakiyaa ti ekumpaan eti eeneetaat Asuwif efikacokee nii pakan keekuulut. Fiyuu étikayini hili káciim ka kiti pahaaño pa piti Himuusu ha. ");
INSERT INTO krx_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ekina ewune Pilaat náafulii naacakanii: “Eeheyme inninooke áyiin a aŋe?” ");
INSERT INTO krx_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nkañahanoo: “Anti úcoopiyaatiyoo peti awe niŋ áhinut heenaput.” ");
INSERT INTO krx_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilaat naasokii: “Aluu faŋ aluu nicoopoo íncanihinoo kíiti ti hilim ha hitaaluu heesiiŋanee ha.” Nkañahanoo: “Uwufanutee sempe kati úyini himuku an.” ");
INSERT INTO krx_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Eehuu hitaakaataako ancuk eeha Yéesu naasoke ha kiti fa naakaakaay fa eket hitaakiyaa. ");
INSERT INTO krx_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Fiye Pilaat naañoho páhantuwa ekumpaan ya eteyoo, naayonkal Yéesu, naacakanoo: “Fo awe yem amansa ya ati Pusuwif pa?” ");
INSERT INTO krx_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yéesu naañahanoo: “Kacakan enkuu, ti awe nkúfulii fo pakakee kasokuu kutoom?” ");
INSERT INTO krx_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilaat naañahanoo: “Fo inci Asuwif? Pakani niŋ ñíhampaatiin ña puwaaseena pa pakati Pútuun pa pitaaluu kácoopiyuu ti inci kati híni kíiti. Eeheyme ánhine?” ");
INSERT INTO krx_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yéesu naasokoo: “cáwii ca citoom citi púlunta empe tom. Niŋ cáwii ca citoom citi púlunta empe, pimiikan pa pakatoom anti kátaakool kapikitam kawufanee pakati kikaw ka pakati Pusuwif pa. Haani, cáwii ca citoom citi le tom!” ");
INSERT INTO krx_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Fiye Pilaat naacakanoo: “Ooto awe amansa?” Yéesu naañahanoo: “Awe soke nii inci amansa. Heewune ha inci ínkey ti púlunta pa hiyem: káakup picaaŋ cataŋ kiti pánipani ya. Ekina ewune inci impukee. An óo an eeyem ti pánipani ya násiitanam-síitan.” ");
INSERT INTO krx_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilaat naacakanoo: “Weyme uyem pánipani ya?” Fiye Pilaat naañoho tíkitaaŋ ti Pusuwif pa naasokii: “Inci cukut heewune áyiin a aŋe kati asiiŋanee ti pisiya. ");
INSERT INTO krx_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pale ti cosaan ya eti aluu, inkatankatan aluu eekulee ti pahaaño pa piti Himuusu ha. Fo nílafilafi pikatan aluu amansa ya ati Pusuwif pa?” ");
INSERT INTO krx_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nkañahanoo ti hiceeku: “Haani, akina tom! Pale Palapas núulafiye!” Apan Palapas akanca. ");
INSERT INTO krx_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Fiye Pilaat naawufan hilim kapucoop Yéesu nkasapaloo fanfaŋ niŋ kisawut. ");
INSERT INTO krx_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pusoocaali pa nkacoop mífiitiin miti pícankun nkaliil mo samat nii éwuulu eti amansa, nkasoof yo ti hikaw Yéesu, nkásooloo lompo hísool henfakat héecunke hiti amansa. ");
INSERT INTO krx_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nkatowo ti ékey teyoo nkasokoo: “Ukicanuu, awe amansa ya ati Pusuwif pa!” Nkayeniyoo kaafantal. ");
INSERT INTO krx_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilaat nene áfulii naasok Pusuwif pa: “Nisincan, inci púfulaniyoo aluu tíkitaaŋ, ancuk nimeya nii inci cukut teyoo heewune kati asiiŋanee ti pisiya.” ");
INSERT INTO krx_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Fiye Yéesu náafulii niŋ éwuulu ya eti pícankun pa ti hikawoo niŋ hísool ha henfakat ha héecunke ha. Pilaat naasokii: “Ehe áyiin a!” ");
INSERT INTO krx_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ñíhampaatiin puwaaseena pa pakati Pútuun pa niŋ pufaasa ekumpaan ya enfakat ya eti Pútuun pa, emma nkacukoo ma nkayeno hiceeku: “Pempeŋoo ti kuluwaa! Pempeŋoo ti kuluwaa!” Pale, Pilaat naasokii: “Nicoopoo aluu himuum aluu innipempeŋoo ti kuluwaa, kaatuko inci cukut heewune kati asiiŋanee ti pisiya.” ");
INSERT INTO krx_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pakati kikaw ka pakati Pusuwif pa nkasokoo: “Utaakaataak hilim heesiiŋanee, ti oom hilim naañaŋee himuku kamma naasoke nii akina ayem Añii ya ati Pútuun pa.” ");
INSERT INTO krx_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ta Pilaat náasiye ta eehuu naahaŋ toko naafeye. ");
INSERT INTO krx_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Naañahan Yéesu páhantuwa naacakanoo: “Awe ati peyme?” Pale Yéesu añahanutoo. ");
INSERT INTO krx_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Fiye Pilaat naasokoo: “Aálafiitam kañahan? Fo áamiit nii inci taakaataak kayine kiti kakatani niŋ ekina tom kiti kaapempeŋi ti kuluwaa?” ");
INSERT INTO krx_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yéesu naañahanoo: “Niŋ neetaat kawun kéekeyii ti awe kúpufulii patiila, anti táakaati sempe ti inci. Ekina ewune aŋa éecoopiyaam ya apuwufanami, naahaŋi kaamuuyen.” ");
INSERT INTO krx_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tempo Pilaat náayaañ hiŋes kakatanoo, pale pakati kikaw ka pakati Pusuwif pa nkatowo ti hiceeku nkasok: “Niŋ aakatanaa áyiin a aŋe ooto aaneetaat niŋ Amansa ya enfakat a ati Room. An óo an eecokooliye nii amansa, akamool Amansa ya enfakat a.” ");
INSERT INTO krx_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ta Pilaat náasiye ta kilim enkuu náafulan Yéesu tíkitaaŋ. Púful toko naakaayeno ti híkon ha hiti éhinuma kíiti ya, la nkasok la “Kapata” ti kaŋ ya eti Hiburu, toko lompo nkasok “híliŋ heepupee niŋ pínankiin”. ");
INSERT INTO krx_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Hinoom eehuu hiyeniye hinoom ha hiti ememanoolo ya le niŋ pahaaño pa piti Himuusu ha, tempo caanak ca ti kikaw. Fiye, Pilaat naasok Pusuwif pa: “Ehe amansa ya ataaluu.” ");
INSERT INTO krx_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pale nkayeno hiceeku: “Aket! Aket! Pempeŋoo ti kuluwaa!” Pilaat naasokii: “Fo inci pempeŋ amansa ya ataaluu?” Ñíhampaatiin puwaaseena pa nkañahanoo: “Utaakut akee amansa niŋ fúlaa Amansa ya enfakat a ati Room.” ");
INSERT INTO krx_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ti pikelan Pilaat náahin eeha nkálafiye ha naawufan Yéesu kati apempeŋee ti kuluwaa. Fiye nkacoop Yéesu. ");
INSERT INTO krx_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yéesu himuumoo akantiye kuluwaa ya eteyoo, náaful ti saatee ya apuwant la nkasok la Esent. Ti kaŋ ya eti Hiburu nkasok toko “Golgota”. ");
INSERT INTO krx_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Toko nkapempeŋoo niŋ pakakee pákasupak, akee ya ti epeesoo yaamay, akee ya epeesoo yáali, Yéesu ti pututa. ");
INSERT INTO krx_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilaat naapoñ kapikiic ti kaapapaloo hilim eehe: “Yéesu ati Naasalet, amansa ya ati Pusuwif pa.” Nkipempeŋee ti kuluwaa ya eteyoo. ");
INSERT INTO krx_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Pusuwif keemeeŋe kakalaŋaakalaŋ oom pakiical kaatuko la Yéesu naapempeŋee la láaŋut saatee ya, apan pakiical pa ti pikaŋ pa piti Hiburu, Latin niŋ Kilek mpikiicee. ");
INSERT INTO krx_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ñíhampaatiin puwaaseena Pusuwif pa nkasok Pilaat: “Timpi kiic 'Amansa ya ati Pusuwif pa' pale aañaŋaa hikiicu: 'Ayíin aŋe asok: akina ayem amansa ya ati Pusuwif pa.'” ");
INSERT INTO krx_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilaat naañahanii: “Eeha inci inkiice ha, kiicaakiic ho fo pa.” ");
INSERT INTO krx_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ta pusoocaali pa nkapaye ta kaapempeŋ Yéesu, nkacoop wañ wa uteyoo nkápaacinool wo kimpaac kipaakiil, an óo an teyii hoonool. Nkacoop hísool ha hiteyoo heehaane ha, hicifutee pale heeliilee kápiliŋ patiila fo t’etaam. ");
INSERT INTO krx_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Pusoocaali pa nkasokool: “Timpi uhaacaa ho pale uñakaa kaakaaw úpumeyiyaa ayme afaacoop ho.” Fiyuu heekiicee ha ti hilim ha hiti Pútuun pa nihitaakiye, hisok: “Kápaacinoolaa-páacinool wañ wa utoom nkañak kaakaaw kúsool ka kutoom.” Eehuu pusoocaali pa nkáhine. ");
INSERT INTO krx_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Fiye, pukol kuluwaa ya eti Yéesu, íññaa ateyoo oopa asiiŋiye niŋ íññaa ateyoo atuwoo, Kolopas aaloo Mari niŋ Mari ati Makatala. ");
INSERT INTO krx_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ta Yéesu naacuke ta íññaa ateyoo niŋ anapana ya ateyoo aŋa náalafiye ya naasiiŋiye pukoloo, naasok íññaa ateyoo: “Aaluu, ehe añiini.” ");
INSERT INTO krx_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Púful toko naasok anapana ya: “Ehe íññaa atii.” Písik ti hinoom eehuu, anapana ya naacoopoo lateyoo. ");
INSERT INTO krx_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Eehuu hipimuus, Yéesu náameyi nii waah utowiit, heekiicee ha ti hilim ha hiti Pútuun pa kati hitaako, naasok: “Pálaani pucokaam!” ");
INSERT INTO krx_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Pukol toko intaako élumpa kaameeŋ elaan eesipe, pusoocaali pa nkápuuc toko cífiitiin epons nkacenk co ti hikasap héefulii ti ekee enuun eyya nkasok “hisop”, nkáseepin ho fo ti putumoo. ");
INSERT INTO krx_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yéesu naasoop elaan ya eesipe ya naasok: “Waah utowiit.” Púful toko náaŋok naasuuŋut pikelan. ");
INSERT INTO krx_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ti hinoom ha hiti ememanoolo ya le niŋ hinoom ha hiti kayeno ka hiti Pusuwif pa Yéesu naakete. Pakati kikaw ka pakati Pusuwif pa kálafiit ehunuŋ ya eputowo ti kuluwaa ya ti hinoom ha hiti kayeno ka, kaatuko hinoom eehuu hiyenaayeno pahaaño penfakat. Nkakaay pati Pilaat nkaluumoo ahumalool wootii kati kaket picas, puhunuŋ pa mpúwananiyee. ");
INSERT INTO krx_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Fiye pusoocaali pa nkákey nkahumal woot ácook a ti keepempeŋee ka niŋ Yéesu, nkáhin fo lompo uti ásupiyenu ya. ");
INSERT INTO krx_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pale kapucol ti Yéesu nkatook loho apayaa eket, kahumut wootoo. ");
INSERT INTO krx_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Háati fo fiya, akee ti pusoocaali pa naayayoo ti kaheh niŋ epaay ya eteyoo, tokotoko hísim niŋ man úmmufulii. ");
INSERT INTO krx_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Eekamane ya eehuu atantakaatantak ho. Eeha naakamane ha hiti pánipani te ámeyimeyi nii eeha naasoke ha hiti páni, ancuk aluu lompo níyinanaa. ");
INSERT INTO krx_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Eehuu púlooŋ hitaakaataako ancuk heekiicee ha ti hilim ha hiti Pútuun pa hitaakiyaa, hisok: “Háati kaacecoo koonool etikuhumo.” ");
INSERT INTO krx_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nihisok lompo: “Efikasincan aŋa nkayaye ya.” ");
INSERT INTO krx_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Púful toko, Josef ati saatee ya eti Alimataay eeyem a lompo anapana ati Yéesu ti piyolo kamma naafeye pakati kikaw ka pakati Pusuwif pa, naakaay pati Pilaat. Naaluumoo ehunuŋ ya eti Yéesu kati acaahok yo. Pilaat naacoon, Josef náacaacoopii ehunuŋ ya. ");
INSERT INTO krx_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodem naanapool neyoo. Akina mpáakey ti Yéesu níhanant. Fiye, náacoopoolii munucu méesuume haaw emma nkamemanoole niŋ miir niŋ alowes, máamun sikilo áwii niŋ ŋaasuwan (30). ");
INSERT INTO krx_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Poko t’ésupakii nkacoop ehunuŋ ya eti Yéesu nkakuupool yo niŋ munucu ma samat nii fa Pusuwif pa nkáhin fa ti cosaan ya eteyii káhokum. ");
INSERT INTO krx_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","La nkapempeŋe la Yéesu, kankaŋ uyya toko, ti oom kankaŋ intaak hiyaak héeyeeni, an ataapala ahokee teeho. ");
INSERT INTO krx_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Toko nkahoke Yéesu páawoo haŋa pálike, iyyeno hinoom hiti ememanoolo le niŋ hinoom ha hiti kayeno ka hiti Pusuwif pa. ");
INSERT INTO krx_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Timaas ya mpucom mic loho loŋaa ínnime, Mari ati saatee ya eti Makatala naakaay pati hiyaak ha. Apucol naacuk nii énankiin ya eepantane ya hiyaak ha épalinkanee-pálinkan. ");
INSERT INTO krx_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Naatey pati Simon Piyeer niŋ akee ti pinapana pa, aŋa Yéesu náalafiye ya, naasokii: “Ehunuŋ ya eti Ahámpaatiin a éfulaneefulan ti hiyaak ha, úmiit peyme neeyenanee.” ");
INSERT INTO krx_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Fiye Piyeer niŋ akee anapana ya nkáful kapikaay pati hiyaak ha. ");
INSERT INTO krx_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nkatey ti coonool, pale akee anapana ya ahaŋa Piyeer katey. Náatikinoo hicolu pati hiyaak ha. ");
INSERT INTO krx_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Naañeeho ápucuuhan, naaŋantan kahuuy ka kiti kahok ka páhantuwa hiyaak ha pale anakiit lupo. ");
INSERT INTO krx_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Púful toko, Simon Piyeer lompo náacolii, naanako páhantuwa hiyaak ha naacuk kahuuy ka lupo. ");
INSERT INTO krx_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Cifaal enca nkakuupatanoole ca hikaw Yéesu incipoonee citeete etenco, ciyeniit niŋ kahuuy ka. ");
INSERT INTO krx_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Fiye akee anapana ya éetikine ya ácolii naalompo anako ti hiyaak ha, naacuk náayinan. ");
INSERT INTO krx_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Kaatuko pinapana pa, heekiicee ha ti hilim ha hiti Pútuun pa hiloot hicaaŋ teyii, hisok nii, Yéesu fo álitoonii ti eket ya.) ");
INSERT INTO krx_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Púful toko pinapana pa nkañoho pateyii. ");
INSERT INTO krx_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ta pinapana pa nkayeniye ta puñoho, Mari naasiiŋo apiyeno pukooŋ tíkitaaŋ hiyaak ha. Akina ti pukooŋ pa, naañeeho apiyeno káacuuhan páhantuwa hiyaak ha. ");
INSERT INTO krx_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Naacuk simaleekoo súsupak seewasiye wañ weehiina paŋ, insiyeno kayen la nkahintane la ehunuŋ ya eti Yéesu, ekee ya pati hikaw ha, ekee ya pati woot wa. ");
INSERT INTO krx_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Insicakanoo: “Aaluu, weyme ankooŋ?” Naañahan so: “Ehunuŋ ya eti Ahámpaatiin a atoom nkacoope, míit peyme nkayenane yo.” ");
INSERT INTO krx_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Akina ti hisoku ha eehuu naayeso naacuk Yéesu naasiiŋiye toko pale ámiit nii akina. ");
INSERT INTO krx_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yéesu naasokoo: “Aaluu, weyme ankooŋ? Ayme aŋŋes?” Mari incukoo nii áhina ya ati kankaŋ ya, naasokoo: “Ahámpaatiin, iyyema awe coope ehunuŋ ya insokam peyme ayyenane yo, inci ínkaacoopii yo.” ");
INSERT INTO krx_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yéesu naasokoo: “Mari.” Mari naayeso apucoonool neyoo, naasokoo ti kaŋ ya eti Hiburu: “Rabuni” (ekina eyem “Akalaŋana eemaka”). ");
INSERT INTO krx_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yéesu naasokoo: “Timpi cokam! Kaatuko inci loot silo fala pati Paapaa ya. Awe ñoho pati pákawiyam insokii nii, inci pisilo pati Paapaa atoom eeyem ya lompo Paapaa ataaluu, pati Pútuun pa putoom peeyem pa lompo Pútuun pa pitaaluu.” ");
INSERT INTO krx_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mari ati Makatala naakaay pati pinapana pa naasokii: “Inci cukaacuk Ahámpaatiin a!” Náatuunanii eeha Ahámpaatiin a naasokoo ha. ");
INSERT INTO krx_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Timaas eyyuu nkániim ka, pinapana pa nkaconcoolo nantoonool nkakuloolo ti ekumpaan kamma nkafeye pakati kikaw ka pakati Pusuwif pa. Fiye, Yéesu náafulii ti pututayii naasokii: “Aluu kásuumaay!” ");
INSERT INTO krx_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ta naasoke ta eehuu, náayisanii sipeesoo niŋ kahehoo. Pinapana pa ta nkacuke ta Ahámpaatiin a nkayeno ti pásuuma. ");
INSERT INTO krx_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Fiye Yéesu nene asokii: “Aluu kásuumaay! Samat nii fa Paapaa ya náapoñiyaam fa, fo lompo inci iyyem aluu ti hipoñu. Kásuumaay kiyeno naaluu.” ");
INSERT INTO krx_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ta naapaye ta hisoku eehuu náafuuteen teyii naasokii: “Nisa Kunuu ka keenape ka. ");
INSERT INTO krx_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","An óo an aŋa inniponkete umuuyen wa uteyoo, afaaponketee. An óo an aŋa inniponketut umuuyen wa uteyoo, ataponketee.” ");
INSERT INTO krx_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tempo Tomas aŋa nkasok a lompo Máasupak ma, akee ti ŋaasuwan niŋ pákasupak paka, ayeniit toko ta Yéesu náakeyii ta. ");
INSERT INTO krx_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ta náañohoonii ta pakakee pinapana pa nkasokoo: “Ucukaacuk Ahámpaatiin a!” Pale naañahanii: “Niŋ inci cukut háakum ha hiti ufincu wa ti sipeesoo innaŋ hisiikam ti háakum ufincu wa, innaŋ epeesam ti kahehoo, étiyinan.” ");
INSERT INTO krx_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kunoom isak niŋ káhaaciil kupumuus, pinapana pa nene kaconcoolo ti ekumpaan ya, tempe Tomas toko. Loho kunkut ka kukulee, Yéesu náafulii ti pututayii naasokii: “Aluu kásuumaay!” ");
INSERT INTO krx_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Fiye, naasok Tomas: “Naŋ le hisiiki, sincan sipeesam, ñáakanii epeesi innaŋ yo ti kaheham, katan hitaaku kunuu kúsupak, íyyinan.” ");
INSERT INTO krx_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas naañahanoo: “Ateeteyo atoom niŋ Pútuun pa putoom!” ");
INSERT INTO krx_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yéesu naasokoo: “Kamma ancukaam ekina ewune áyyinan, kéeyinane ka peecukutam kataakaa pásuuma.” ");
INSERT INTO krx_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yéesu áhinaahin hícump pikee píyisan hátikin pinapana pa pakateyoo peekiicutee ti púkoo eyye. ");
INSERT INTO krx_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pale peekiicee pa le, pikiiceekiic kati níyinan nii Yéesu ayem Eenucee ya, Añii ya ati Pútuun pa, te niŋ níyinanaa efinitaak eloŋ ya ti caacawoo. ");
INSERT INTO krx_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Eehuu hipimuus, Yéesu nene áfulii ti pinapana pa pakateyoo pati han ha hiti Tipeliyas. Fiye nihitaakiye. ");
INSERT INTO krx_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Pinapana pa payenke kayeniye nantoonool: Simon Piyeer, Tomas aŋa nkasok a Máasupak ma, Natanayel éefulii ya Kana eti Galilee niŋ Sepete epuukoo, niŋ pakakee pinapana pákasupak pakati Yéesu. ");
INSERT INTO krx_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Piyeer naasokii: “Inci pikaayu calafayi.” Nkañahanoo: “Unii efuunapani.” Fiye nkakaay nkáyuuko ti piteen, pale hánant eehuu púlooŋ kacokut waah. ");
INSERT INTO krx_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mpucom pa mic, Yéesu naasiiŋo ti kantant ka pale pinapana pa kámiit nii akina. ");
INSERT INTO krx_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Fiye naacakanii: “Pákawiyam, fo nícokiyoot waah?” Nkañahanoo: “Háati waah.” ");
INSERT INTO krx_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Naasokii: “Nitah cala ya etaaluu ti epees yáali piteen pa, efinicok.” Fiye nkatah cala ya kayinaat yo éñakii kamma neecoke hícump soon. ");
INSERT INTO krx_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Anapana ya aŋa Yéesu náalafiye ya naasok Piyeer: “Aŋuu Ahámpaatiin a!” Ta Simon Piyeer náasiye ta nii aŋuu Ahámpaatiin a, naawaso hísool ha hiteyoo, kaatuko awaatoolaa-waatoolo, naawantoolo ti man ma. ");
INSERT INTO krx_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Pakakee pinapana pa nkayeno éciŋii niŋ piteen pa kápiñakiiñak cala ya eemeeŋe ya soon. Kálaaŋut kantant ka, máamun simeetal keme (100). ");
INSERT INTO krx_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ta nkáciŋii ta, nkacuk seemak siti kíceket, soon ínsiyemiyee toko ti pusowu niŋ kúmpuul. ");
INSERT INTO krx_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Fiye Yéesu naasokii: “Nícoopii ti soon sa sitaaluu ensa ínnicokii sa féefiye.” ");
INSERT INTO krx_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Piyeer náayuuko ti piteen pa náañakii cala ya eemeeŋe ya soon senfakat ti kantant ka. Soon sa senfakat sa siyema keme niŋ áwii ésupak niŋ ŋaasuwan niŋ síhaaciil (153). Háati fa insimeeŋe fa, cala ya ehaaciit. ");
INSERT INTO krx_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yéesu naasokii: “Níkey hili ecoma.” An ti pinapana pa áhaañiitoo kacakan: “Awe yem ayme?” Kaatuko kámeyimeyi nii akina ayem Ahámpaatiin a. ");
INSERT INTO krx_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Fiye Yéesu naalohii, naacoop kúmpuul ka naawufanii, náahin moonool muu niŋ soon sa. ");
INSERT INTO krx_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Empuu piyem píhaaciyenu ta Yéesu náafulii ti pinapana pa pakateyoo palitaliyoo ti eket ya. ");
INSERT INTO krx_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ta nkapaye ta hili, Yéesu naasok Simon Piyeer: “Simon añii ya ati Saŋ, fo áalafiyaamlafi aapihaŋ payenke?” Naañahanoo: “Ee, Ahámpaatiin, áameyimeyi nii inci láfiyuulafi.” Yéesu naasokoo: “Ufan mísaacii ma mutoom mipili.” ");
INSERT INTO krx_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yéesu naasokoo púsupiyenu: “Simon añii ya ati Saŋ, fo áalafiyaamlafi?” Naañahanoo: “Ee, Ahámpaatiin, áameyimeyi nii inci láfiyuulafi.” Yéesu naasokoo: “Mankool písaacii pa putoom.” ");
INSERT INTO krx_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yéesu naasokoo píhaaciyenu: “Simon añii ya ati Saŋ, fo áalafiyaamlafi?” Piyeer ínciitiyoo kamma Yéesu naacakanoo fo ñiyema ñáhaaciil: “Fo áalafiyaamlafi?” Fiye naasokoo: “Ahámpaatiin, áameyimeyi waah óo waah, áameyimeyi nii inci láfiyuulafi!” Yéesu naasokoo: “Ufan písaacii pa putoom pipili. ");
INSERT INTO krx_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Inci pusoki pánipani ya, ta ayyeniye ta ti hikampaanateyi, ánsoolosoolo inkaay pan óo pan pa állafiye, pale naamaamanaa, áafapantin sipeesi akee náasooli naacoopi pa állafiit pa pikaayu.” ");
INSERT INTO krx_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Yéesu asokaasok eehuu ápiyisan fa Piyeer naakaakaay fa eket ápiyisan hamake ha hiti Pútuun pa.) Fiye Yéesu naasokoo: “Napanam!” ");
INSERT INTO krx_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piyeer naayeso naacuk pusonoo anapana ya aŋa Yéesu náalafiye ya ti kanapanii. Anapana ya aŋuu, akina ayaaciye fa hínum ti Yéesu ta nkayeniye ta hili káciim ka naacakanoo: “Ahámpaatiin, ayme akaakaay hífulu ti awe?” ");
INSERT INTO krx_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ta Piyeer naacuke ta anapana ya aŋuu naacakan Yéesu: “Ahámpaatiin, áyiin a aŋe me?” ");
INSERT INTO krx_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yéesu naañahanoo: “Niŋ inci láfiyaa aputowo kaloŋa fo ta inci fáñohoonii, ekina weyme ti awe? Awe, nápaniyam!” ");
INSERT INTO krx_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kamma eehuu, hilim nihiyeno katey ti pututa kéeyinane ka nii anapana ya aŋuu ataket. Pale Yéesu asokut nii anapana ya aŋuu ataket, asok: “Niŋ inci láfiyaa aputowo kaloŋa fo ta inci fáñohoonii, ekina weyme ti awe?” ");
INSERT INTO krx_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Akina ayem anapana ya eetantake ya enkuu, naakiic ko. Núumeyi nii eeha naasoke ha hiti pánipani. ");
INSERT INTO krx_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yéesu hícump ukee waah náahine. Niŋ ukina púlooŋ ukiicee woonool woonool, inci incukam nii háati púlunta pa étipiyini kayekan oom púpukoo.");
INSERT INTO krx_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teyofil eñaap ya, ti pakiical pa putoom píyaañ pa inci kamanaakaman eeha púlooŋ Yéesu náacooke ha áhin naakalaŋan ");
INSERT INTO krx_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","fo ti hinoom eeha naasilanee ha patiila. Aséepinumee, naawufan pitiyo payenka naamamale ka kapiyeno pupoñapoñ ti sempe sa siti Kunuu ka keenape ka. ");
INSERT INTO krx_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Pamuusal kúnuul ka fo ti eket ya eteyoo ínnayisanoolo teyii ápiyisanii picaaŋ cataŋ nii oopa kaloŋa. Kunoom áwii ésupak (40) ápinafulii teyii náakupii kiti cáwii ca citi Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Hikee hinoom, ta naayeniye ta hili neyii naasokii: “Timpi níful Jerusalem, pale nítuul eeha Paapaa ya náayinanane ha nii afaawufan ho aluu, kawun enka inci íntuunane ka aluu. ");
INSERT INTO krx_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kaatuko Saŋápatiseyaa-pátise pakan paka niŋ man pale le niŋ kunoom éfinihinee pátise niŋ Kunuu ka keenape ka.” ");
INSERT INTO krx_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Fiye, keeyeniye ka niŋ Yéesu nkayeniyoo kacakan: “Ateeteyo, fo tokofiye ankaakaay éñahanii cáwii ca citi Israyel?” ");
INSERT INTO krx_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yéesu naañahanii: “Nisoolahut kameye teyme niŋ eeheyme hinoom enkuu fiye púlooŋ nkikaakaay ékey. Paapaa atuunaa asiiŋane ho akina lamayoo ataake kayine kiti kaasiiŋan eteeho. ");
INSERT INTO krx_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pale aluu, ta Kunuu ka keenape ka nkikaakaay ta éwanoonii ti aluu, efinisa sempe. Fiyuu, aluu keetantake ka eloŋ ya etoom, innikaakaay káakup kutoom ti saatee ya eti Jerusalem, ti mah ma miti Judaay púlooŋ niŋ Samali, niŋ pan óo pan ti púlunta pa.” ");
INSERT INTO krx_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ta naapaye ta káakup eehe, naasilanee patiila ti ñíkin pupoñapoñ pa pakateyoo. Púful toko, káatiŋu nkiyoloo, nekacukutoo. ");
INSERT INTO krx_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Pale akina ti pikaayu pa, nkatowo ti kaasincan caw patiila. Tokotoko, pákayiin pákasupak keewasiye wañ weehiina nkasiiŋo pukolii. ");
INSERT INTO krx_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nkasokii: “Aluu pakati Galilee, weyme innitowiye le ti kaasincan patiila? Yéesu aŋe, eecoopee ya taaluu naasilanee patiila, samat nii fa innicukoo fa naakaaye, fo lompo naakaakaay éñohoonii.” ");
INSERT INTO krx_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Fiye, pupoñapoñ pa nkáfulii pati cítintiŋ ca enca nkasok ca Olif, nkañoho Jerusalem. Láaŋoolut niŋ saatee ya eti Jerusalem. ");
INSERT INTO krx_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ta nkacole ta nkasilo ti ékaap ya la nkasale la piyeno. Keeyeniye ka toko kayem Piyeer, Saŋ, Saak niŋ Andre, Filip niŋ Tomas, Paatolomaay niŋ Máciya, Saak ati Alifaay, Simon aŋa nkasok ya Selot niŋ Yutas ati Saak. ");
INSERT INTO krx_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Poko púlooŋ nkacokool piliit tiw nkásiyool ti kaluum tan óo tan, poko niŋ pakaal paka niŋ Mari Yéesu íññaa ateyoo niŋ Yéesu pakatuwoo. ");
INSERT INTO krx_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Hikee hinoom, kéeyinane ka nkaconcool máamun keme niŋ áwii (120). Piyeer naasiiŋo naasokii: ");
INSERT INTO krx_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Aluu pakanam ti káyinan, eeha Kunuu ka keenape ka nkútuunane ha ta infiyye ti pakiical pa piti Pútuun pa fo hitaako: nkúkup ti putum amansa ya Dawid kiti Judas, éenowii ya hátikin kéekeyii ka hicoku Yéesu. ");
INSERT INTO krx_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas oonool hínum tuunaa, naayeno lompo páhin nuunaa.” ");
INSERT INTO krx_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Mañ emma nkacooyoo ma ápihin heenaput eehuu naacoope apunoom kaakit, toko naanowe hikawoo hipiya, eniinoo néefap, niñowoo ínnilutoonii. ");
INSERT INTO krx_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Eehuu, pakati Jerusalem púlooŋ kásiyaasi ho ekina ewune nkasok kaakit enkuu “Hakeletama” ti kaŋ ya eteyii, ekina eyem “Kaakit kiti hísim”.) ");
INSERT INTO krx_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Piyeer nene asok: “Kiiceekiic ti pakiical pa piti kícimu ka nii: 'Alímaati ekumpaan ya eteyoo ekatanee, álimaati an timpi akin teyyo.' “Inkiicee lompo nii: 'Alímaati akee atoon páhin pa piteyoo.' ");
INSERT INTO krx_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Ooto, fo akee ánanfii toonii kati akaman lompo pilito pa piti Ateeteyo Yéesu. Oom áyiin añaŋaa éfulii ti payenka nkanapool ka niŋ unii tan óo tan ta nuuyeniye ta kaamuusool ti mah ma niŋ Ateeteyo Yéesu, písik ta Saŋ náahinoo ta pátise fo ta náaseepinee ta toonii.” ");
INSERT INTO krx_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ta Piyeer naapaye ta káakup, nkácoopii pákayiin pákasupak: Josef aŋa nkasok ya Palasapas, nkayonkaloo lompo Yustus, niŋ Maciyas. ");
INSERT INTO krx_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Púful toko, kayoŋ ka nkuluum fiye: “Ateeteyo, awe meya saan pakan paka, yísan unii ayme ti poko t’ésupakii ammamale ");
INSERT INTO krx_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","apiyeno apoñapoñ naacoop páhin empa Judas naakate pa le apite akaay pa naañaŋe pa piyeno.” ");
INSERT INTO krx_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nkañak kaakaaw nkucok Maciyas apinanf pupoñapoñ pa ŋaasuwan niŋ oonool a. ");
INSERT INTO krx_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ta pahaaño pa piti Pentekos mpútuuniye ta, kéeyinane ka ti Yéesu púlooŋ nkayeno nantoonool. ");
INSERT INTO krx_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tokotoko pahampanane mpúfulii patiila samat nii pasapal hiyam heehiñe. Pahampanane empuu mpimeeŋan ekumpaan ya púlooŋ eyya nkayeniye ya teyyo. ");
INSERT INTO krx_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ti oom káasiiŋuma, waah núufulii teyii weecuke nii kíleeluuf kiti seemak, nkihancaloolo nkinaŋo ti an óo an teyii. ");
INSERT INTO krx_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Poko púlooŋ nkameeŋ niŋ Kunuu ka keenape ka nkáyaañ káakup niŋ pikee pikaŋ samat nii fa Kunuu ka keenape ka nkuwufanii fa. ");
INSERT INTO krx_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Fiye, intaako toko Pusuwif kéefulii ti mah ma púlooŋ miti púlunta pa nkayeno Jerusalem. Nkayeno pákayiin keefeye Pútuun. ");
INSERT INTO krx_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ta nkásiye ta pahampanane empuu, kayoŋ kenfakat nkuconcool. Innímii kamma an óo an teyii náasiye pinapana pa pakati Yéesu nkayeniye káakup ti híleeluufuyoo eeha náacuuwe ha. ");
INSERT INTO krx_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nkaŋaŋo ínnimii nkacakan: “Fo keeyem ka fiye púlooŋ ti káakup pakati Galilee tom? ");
INSERT INTO krx_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Weyme uwune an óo an tuunaa púlooŋ náayemiyii ti hísiyu ti híleeluufuyoo eeha náacuuwe ha? ");
INSERT INTO krx_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Unaa kéefuliyaa ka Paat, Meti niŋ Elam; pakan kéefulii Mesopotami, Judaay niŋ Kapatos; pakan kéefulii Pont niŋ Asii, ");
INSERT INTO krx_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","kéefulii Filiki niŋ Panfili, kéefulii Esipt niŋ misaatee ma miti Libiya meekole ma saatee ya eti Silen. Pakakee tuunaa nkáfulii Room, ");
INSERT INTO krx_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Kilet niŋ Arabiya, pakakee paka Pusuwif, pakakee paka lompo keeyesane eloŋ ya eteyii nkananf ti pítin pa piti Pusuwif pa. Pale unaa púlooŋ núusiyii ti káakup ti kíleeluuf unaa enka núucuuwaa ka ti kakaman waah wa wenfakat wa weemeeŋe wa ewwa Pútuun pa mpíhine wa!” ");
INSERT INTO krx_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nkaliim meemak ínnimii, nkatowo ti ecakanoolo: “Eehe weyme níhiyisane?” ");
INSERT INTO krx_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pale pakakee paka nkápalahool kéeyinane ka ti Yéesu nkalenkenii nkasok: “Payenkuu kákumanaakuman!” ");
INSERT INTO krx_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Púful toko, Piyeer naasiiŋo niŋ pupoñapoñ pa ŋaasuwan niŋ oonool a. Ti hiceeku, náayaañ káakup niŋ kayoŋ ka apusok: “Aluu pakanam Pusuwif pa niŋ aluu púlooŋ keekine ka Jerusalem nísiitanam pinap, inci pikaman aluu heeyem ha ti pitaako. ");
INSERT INTO krx_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Pakan paka payenke kákumanut samat nii fa ínninunkoole fa, cicomaacomo. ");
INSERT INTO krx_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Haani! Pale eehe ayaamakoola ya Sowel náatuunane: ");
INSERT INTO krx_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","'Pútuun pa pusok: \"Ti kunoom ka kikelan ka, inci fawwufan kunuuwam an óo an. Epuuk aluu pikampaani niŋ púmaacul efinkayaamakool ti caacawam, uhiineen wa niŋ ñíhampaatiin ña pakataaluu éfinkayawut, nkacuk lompo waah pucuk fiye nii éyawut nkayaake. ");
INSERT INTO krx_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ee, háati pimiikan pa pakatoom, pákayiin paka niŋ pakaal paka, inci fawwufanii kunuuwam ti kunoom enkuu, efinkayaamakool ti caacawam. ");
INSERT INTO krx_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Fáhin waah weecukantee nuucukee patiila, ínhin hícump píyisan penfakat t’etaam. Fataako hísim, seemak niŋ útiŋu uti háaputa. ");
INSERT INTO krx_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Caanak ca éficinim, hiim ha níhicunk nii hísim le niŋ hinoom ha heemaka ha henfakat ha hiti Ateeteyo Pútuun pa éfihicolii. ");
INSERT INTO krx_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tempo an óo an eeluume ti caacaw Ateeteyo Pútuun pa afaafakanee.\"' ");
INSERT INTO krx_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Aluu pakati Israyel, nísiitan pinap eeha inci inkaakaay ha aluu hisoku: Yéesu ati Naasalet akina an aŋa innimeya nii Pútuun pa umpa neyoo kaatuko puwufanoowufan íhinu hátikin aluu waah wenfakat, hícump píyisan niŋ weecukantee samat nii fa innimeya wo fa aluu himuum aluu. ");
INSERT INTO krx_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yéesu aŋe acokeecok naawufanee aluu samat nii fa Pútuun pa mpílafiye fa, pikina peemeya pa eehuu púlooŋ hítaakumo. Aluu nimukoo, ta inniwufanoo ta píhina heenaput ha kapipempeŋoo ti kuluwaa ya. ");
INSERT INTO krx_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pale Pútuun pa mpúfulanoo ti kúnuul ka kiti eket ya, mpíñahaniyoo ti eloŋ ya, kaatuko eket ya etaakut sempe teyoo. ");
INSERT INTO krx_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dawid naasok kiteyoo: 'Inci incukcuk Ateeteyo Pútuun pa hátikinam tan óo tan. Kaatuko oopa niŋ inci, ancuk etikikilan. ");
INSERT INTO krx_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ekina ewune yaanam neemon, inci oopa ti caacook niŋ pásuuma. Háati eniinam lompo éfeewaayeen kamma inci ínhine cíki. ");
INSERT INTO krx_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kaatuko awe Pútuun aatikatam piyeno pati keekete ka, aatikat enii amiikan a atii eenape ya epufut ti hiyaak. ");
INSERT INTO krx_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Aáyisanaam-yísan ñítin ña ñeekaaye ña pati eloŋ ya, aafameeŋanam niŋ pásuuma hátikini.' ");
INSERT INTO krx_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Aluu pakanam, inci púkup naaluu niŋ híyiinate kiti maamaa atuunaa amansa ya Dawid. Aketaaket naahokee, fo fíyooy hiyaak ha hiteyoo hoopuha le tuunaa. ");
INSERT INTO krx_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pale Dawid ayenaayeno ayaamakoola, náameyi eeha Pútuun pa mpisintooliye ha teyoo nii éfipufulanii ti miin ma miteyoo amansa samat nii akina. ");
INSERT INTO krx_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dawid naacuk eeha Pútuun pa mpikaakaay ha íhinu hátikin, náakup kiti pilito pa piti Eenucee ya ati Pútuun pa, ta naasoke ta nii akatutee pati keekete ka, eniinoo lompo efutut ti hiyaak ha. ");
INSERT INTO krx_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yéesu aŋe Pútuun pa mpilitane ti eket ya, unii púlooŋ utantake ho. ");
INSERT INTO krx_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Naasilanee ti epees yáali eti Pútuun pa Paapaa ateyoo, mpuwufanoo Kunuu ka keenape ka samat nii fa mpusokoo fa. Aŋe inniyem ya fiye ti hicuku ínnisi ekina eyem kawun etempo enka mpíniisii ka toonii. ");
INSERT INTO krx_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dawid himuumoo asiliit alacana pale naasok: 'Ateeteyo Pútuun pa púkupaakup niŋ Ateeteyo atoom ti hisoku: \"Kéy yeniyam epees yáali, ");
INSERT INTO krx_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","fo ta inci fatah ta pikamooli ti wooti ayyeno amansa ya ateyii.\"' ");
INSERT INTO krx_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Fiye aluu pakati Israyel púlooŋ niñaŋaa kameye eehe pánipani, Yéesu aŋe, aŋa innipempeŋe ya ti kuluwaa ya, Pútuun pa píhinoo apiyeno Ateeteyo niŋ lompo Eenucee ya.” ");
INSERT INTO krx_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ta pakan paka nkásiye ta eehe, ínciitiyii meemak nkacakan Piyeer niŋ pakakee pupoñapoñ pa, “Aluu pakan unii, puume nuuñaŋe íhinu?” ");
INSERT INTO krx_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piyeer naañahanii: “Níwunko umuuyen wa utaaluu, an óo an ti aluu náahinee pátise ti caacaw ca citi Yéesu Krista, ancuk umuuyen wa utaaluu nuuponketee, Pútuun pa mpuwun aluu Kunuu ka keenape ka. ");
INSERT INTO krx_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kaatuko Pútuun pa píyinananaa-yínanan nii efipuwufan ko aluu niŋ epuuk aluu niŋ lompo keekine ka pílaaŋ, focaa payenka púlooŋ Ateeteyo Pútuun pa putuunaa mpikaakaay ka éyonkalii.” ");
INSERT INTO krx_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piyeer naapenanii kunuu niŋ kikee kilim keemeeŋe, naaŋiiniyii ti hisoku: “Nifakan faŋ aluu ti ekaay eenaput eyye!” ");
INSERT INTO krx_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Keecoone ka hilim ha hiti Piyeer nkáhinee pátise, máamun pakan síwuli síhaaciil (3,000) nkananf ti oom hinoom kéeyinane ka. ");
INSERT INTO krx_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kéeyinane ka nkákipen ti káasiitan eeha pupoñapoñ pa nkakalaŋanii ha; nkákipen lompo ti pucokool piliit, ti káapaacinool kúmpuul niŋ ti kaluum. ");
INSERT INTO krx_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","An óo an naameeŋ niŋ ewatate, kamma Pútuun pa mpíhine hícump píyisan niŋ weecukantee wéenapii ti pupoñapoñ pa. ");
INSERT INTO krx_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kéeyinane ka púlooŋ nkacokool, nkápaacinool waah óo waah ewwa nkataake. ");
INSERT INTO krx_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Pikee pa, nkanooman pitaam pa piteyii niŋ hitaaku ha hiteyii, nkápaacinool mañ ma, nkawufan an óo an fa naasoolahe. ");
INSERT INTO krx_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Hinak óo hinak nkaconcool ti hank ha hiti ekumpaan ya enfakat ya eti Pútuun pa, nkápaacinool kúmpuul ti pukumpaan pa piteyii, nkali nantoonool niŋ pásuuma, an péemakiyanooliit. ");
INSERT INTO krx_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Nkanimpan Pútuun pa, pakan paka púlooŋ nkálafiyii. Hinak óo hinak Ateeteyo napenan ti kayoŋ ka kiteyii pakan keefakanee. ");
INSERT INTO krx_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Hikee hinoom, máamun sitalaŋ síhaaciil, ta kaluum ka nkúlohanii ta, Piyeer niŋ Saŋ nkayeno pikaayu lati hank ha hiti ekumpaan ya enfakat ya eti Pútuun pa kaluum. ");
INSERT INTO krx_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Pacolalii, pakan nkayeno hicoopu áyiin éehute kápiliŋ ta naapukee. Hinak óo hinak nkacoopoo nkayenanoo lati putum pa empa nkasok pa Putum pa Peewalla pa kati naluumatool ti keeyem ka ti pinako ti hank ha hiti ekumpaan ya enfakat ya. ");
INSERT INTO krx_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ta naacuke ta Piyeer niŋ Saŋ ti pinako, naaluumii mañ. ");
INSERT INTO krx_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Piyeer niŋ Saŋ nkasincanoo caw, Piyeer naasokoo: “Sincan unii!” ");
INSERT INTO krx_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Eéhute ya naasincanii púsooni pucukoo nii efikawufanoo waah. ");
INSERT INTO krx_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pale Piyeer naasokoo: “Inci taakut mañ niŋ sanoo, pale aŋa inci intaake ya inci fawufani; ti caacaw ca citi Yéesu Krista ati Naasalet lito inkaay!” ");
INSERT INTO krx_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Púful toko, Piyeer naacokoo ti epees yáali, náasisikanoo apilito. Tokotoko woot éehute ya núuyankii kaŋ. ");
INSERT INTO krx_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Naalito niŋ hinuutu náayaañ pikaayu. Naanako niŋ Piyeer niŋ Saŋ ti hank ha hiti ekumpaan ya enfakat ya, naakaay naanuut, naanimpan Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Keeyeniye ka toko púlooŋ nkacukoo ti pikaayu nkásiyoo ti kaanimpan Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ta nkakiiwe ta nii akina ayem aluumatoola ya éehute ya, aŋa nkaloom ya hicuku naayeniye lati Putum pa Peewalla pa piti hank ha hiti ekumpaan ya enfakat ya, nkaŋaŋo ínnimii ti heetaakiyoo ha. ");
INSERT INTO krx_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Páawoo áyiin a aŋuu akatanut Piyeer niŋ Saŋ, pakan paka púlooŋ nkaŋaŋo nkatey ti coonool kaputookii lati címpaŋ ya eyya nkasok ya Címpaŋ eti Solomon. ");
INSERT INTO krx_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Piyeer apucuk eehuu naasok kayoŋ ka: “Aluu pakati Israyel, weyme uwune eehuu níhinim aluu? Weyme innikent unii? Fo cukaacuk aluu nii úhinaahin áyiin a aŋe ápiyini pikaayu kamma sempe unii niŋ fotom kamma nuuwufane meemak eloŋ ya etoonii Pútuun pa? ");
INSERT INTO krx_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Pútuun pa piti Abraham, Pútuun pa piti Isaak niŋ Pútuun pa piti Jakob niŋ piti símaama unaa, pínapiyanaa-nápiyan amiikan a atempo Yéesu. Aluu inniwufanoo ñíhampaatiin ña apumukee ínnilaacinoo hátikin Pilaat apan Pilaat hínum álafiyoolafi kakatan. ");
INSERT INTO krx_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Innipook Eesampanee ya Naacoonool inniluum Pilaat apikatan aluu amukala pakan. ");
INSERT INTO krx_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Fiyuu innimuke ati eloŋ ya, pale Pútuun pa mpilitanoo ti eket ya. Unii payenke keetantake ho. ");
INSERT INTO krx_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Caacaw ca citi Yéesu niŋ káyinan ti caacawoo, kikina kuwune áyiin aŋe innicuke ya innikiiwoo náahinee ápiyini pikaayu. Káyinan ka ti Yéesu kúkuuñanoo samat nii eeha innicuke ha aluu púlooŋ. ");
INSERT INTO krx_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Fiye, aluu pakanam, inci meya nii aluu niŋ ñíhampaatiin ña pakataaluu, ti káameyaati ínnihine eehuu Yéesu. ");
INSERT INTO krx_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pale Pútuun pa pusokaasok ta infiyye nii Eenucee ya ateyoo afaakallo. Eehuu mpusoke ti ñutum piyaamakoola pa púlooŋ, hikina hitaakiye. ");
INSERT INTO krx_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ooto níwunko umuuyen wa utaaluu ínniñohoonii peti Pútuun pa, ancuk puponketaa aluu. ");
INSERT INTO krx_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Niŋ níhinaa fo, Ateeteyo Pútuun pa efipuwufan aluu kunoom kiti éyekunoolo, éfipupoñii lompo Yéesu, Eenucee ya aŋa mpimamale ya aluu ta infiyye. ");
INSERT INTO krx_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Fo Yéesu ayeno alacana fo ta Pútuun pa éfipihin waah óo waah nene úpuyenoonii wéeyeeni samat nii fa mpusoke ho fa ta infiyye ti ñutum piyaamakoola pa keesampanee ka. ");
INSERT INTO krx_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Pánipani, Móyiis asok: 'Ateeteyo Pútuun pa éfipupoñii aluu ayaamakoola samat nii inci, afaayeno an éefulii ti pakan aluu. Nísiitan púsooni ti waah óo waah ewwa naakaakaay aluu hisoku. ");
INSERT INTO krx_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","An óo an éesiitanut ayaamakoola ya aŋuu, áfaafulanee ti miin ma miti Pútuun pa naamukee.' ");
INSERT INTO krx_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Piyaamakoola pa púlooŋ písik ti Samiyel focaa ti kéenowii ka teyoo kákupaakup kiti hinoom eehuu. ");
INSERT INTO krx_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kilim enka Pútuun pa mpusoke ka piyaamakoola pa, kilim kitaaluu pakanii, focaa písiyool empa Pútuun pa mpiliile pa ti pututa etempo niŋ símaama unaa, ta mpusoke ta Abraham: 'Inci fasampan miin óo miin t’etaam, kaasampan enkuu éfikinapii ti papukali.' ");
INSERT INTO krx_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ta Pútuun pa mpúcoopii ta Yéesu amiikan etempo, ti aluu pakati Israyel mpíyaañe pupoñoo, kati níwunko páhinal pa pitaaluu peenaput pa. Ti páhinal empuu efinisampanee.” ");
INSERT INTO krx_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Piyeer niŋ Saŋ ti káakup niŋ pakan paka, puwaaseena pa pakati Pútuun pa niŋ áhampaatiin a ati pufaasa pa pakati ekumpaan ya enfakat ya niŋ Pusatusaay pa nkácolii. ");
INSERT INTO krx_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Inseeñii meemak kamma Piyeer niŋ Saŋ nkayeniye kakalaŋan pakan paka niŋ káatuunan nii, páawoo Yéesu alitaalito ti eket ya, úmeyiyaameyi nii keekete ka lompo éfikayini élitoonii. ");
INSERT INTO krx_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Fiye, nkacokii nkakulii fo eti kacom eteyyo kamma ínciniimiye. ");
INSERT INTO krx_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pale hícump ti kéesiye ka hilim ha hiti Piyeer niŋ Saŋ nkáyinan. Pákayiin paka púlooŋ kéeyinane ka ti Yéesu kayema máamun síwuli isak (5,000). ");
INSERT INTO krx_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Eti kacom eteyyo, pakati kikaw ka pakati Pusuwif pa, ñíhampaatiin ña niŋ pikalaŋana hilim ha heesiiŋanee ha hiti Móyiis nkaconcool Jerusalem. ");
INSERT INTO krx_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Intaako toko Annas, awaaseena ya enfakat a ati Pútuun pa, intaako toko lompo Kayif, Saŋ, Aliksant niŋ pakakee pakati miin ma miti awaaseena ya enfakat a. ");
INSERT INTO krx_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nkapoñ kápucoopii pupoñapoñ pa pákasupak paka hátikinii. Nkacakanii: “Ti enseyme sempe niŋ ekina tom ti enceyme caacaw ínnihine káakuuñan enke?” ");
INSERT INTO krx_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Piyeer naameeŋ niŋ Kunuu ka keenape ka naasokii: “Aluu pakati kikaw ka pakati Pusuwif pa niŋ ñíhampaatiin ña: ");
INSERT INTO krx_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Kaacakanool unii fíyooy inniyaake ti heenape ha eeha núuhine ha éehute ya, innicakan unii lompo puume náakuuñanee. ");
INSERT INTO krx_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ee, niñaŋaa kameye eehe, aluu fiye púlooŋ niŋ kayoŋ ka púlooŋ kiti Israyel: Ti caacaw Yéesu Krista ati Naasalet, aŋa aluu innipempeŋe ya ti kuluwaa ya pale Pútuun pa mpílitaniyoo ti keekete ka, ti caacawoo áyiin a aŋe naasiiŋiye hátikin aluu kásuumaayoo. ");
INSERT INTO krx_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yéesu akina ayem aŋa hilim ha hiti Pútuun pa nihisoke ha kiteyoo nii énankiin ya eyya aluu puluta pa ínnitine ya éyenoonii énankiin ya eehaŋe ya hitaaku nafaa. ");
INSERT INTO krx_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Akina lamayoo ayina unaa kafakan. Kaatuko ti púlunta pa fiye púlooŋ Pútuun pa puwufanut pakan paka cikee caacaw kati cifakan unaa.” ");
INSERT INTO krx_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Innímii ta nkásiye ta Piyeer niŋ Saŋ ti káakup niŋ híyiinate apan pakan kenseŋ keekalaŋut. Nkápannum nii Piyeer niŋ Saŋ kayenaayeno niŋ Yéesu. ");
INSERT INTO krx_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Pale kamma nkacuke éekuuñanee ya naasiiŋiye pukol pupoñapoñ pa pákasupak paka, kataakut eeha efikañahan. ");
INSERT INTO krx_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Fiye, nkawufan hilim Piyeer niŋ Saŋ kápuful ti éhinuma kíiti ya, nkayeno piteŋenool. ");
INSERT INTO krx_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Nkasok: “Puume éfuuhinaa pakan paka payenke? Kaatuko káhinaahin heecukantee henfakat, pakati Jerusalem fiye púlooŋ kámeyimeyi ho, uyinaataa ho káalaacin. ");
INSERT INTO krx_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pale uñaŋaa kaafitanool eehe, timpi ihaŋ toko nihihancalooliye. Efuufeyanoolii núukupananii timpi kákup niŋ pakan paka ti caacaw Yéesu.” ");
INSERT INTO krx_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nene káyonkalii Piyeer niŋ Saŋ nkakitii káakup niŋ kakalaŋan cántum ti caacaw Yéesu. ");
INSERT INTO krx_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pale Piyeer niŋ Saŋ nkañahanii: “Eeheyme hicoonoole hátikin Pútuun pa, káasiitan aluu fo káasiitan etempo? Anti nisok unii! ");
INSERT INTO krx_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kaatuko uyinaat kaafatanool niŋ eeha nuucuke ha núusi.” ");
INSERT INTO krx_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nkafeyanoolii púsooni nkakatanii kaatuko kámiit fa efikasiiŋanii ti pisiya peelitanut pítaakool kamma pakan paka púlooŋ nkayeniye hímulu Pútuun pa ti heetaakiye ha. ");
INSERT INTO krx_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kaatuko áyiin a eetaake ya káakuuñan ka keetaapala kucukee enkuu ahaŋaahaŋ sitiil áwii ésupak (40). ");
INSERT INTO krx_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Piyeer niŋ Saŋ, ta nkakatanee ta, nkañoho pati pakanii ti káyinan nkakamanii púlooŋ eeha puwaaseena pa kenfakat ka pakati Pútuun pa niŋ ñíhampaatiin ña nkasoke ha. ");
INSERT INTO krx_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Mpásiyalii eehe, poko púlooŋ nkananfool ti kaluum Pútuun pa nkasok: “Ateeteyo Pútuun, awe liile patiila niŋ t’etaam niŋ waah óo waah weeyem toko, illiil lompo kaatii ka niŋ waah óo waah weeyem lupo. ");
INSERT INTO krx_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Niŋ Kunuu ka keenape ka ántunke ta infiyye maamaa atuunaa Dawid, amiikan a atii, kati asok: 'Weyme uwune keeneetaat ka Pusuwif kiiñii nkili meemak? Weyme uwune nkaconcoolo kati kateŋenool kenseŋ? ");
INSERT INTO krx_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Pumansa pa pakati púlunta pa niŋ pakati kikaw ka kaconcoolaa-concoolo nkasiiŋo kati kakam niŋ Ateeteyo Pútuun pa, niŋ lompo Eenucee ya atempo.' ");
INSERT INTO krx_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Kaatuko pánipani, fiyuu intaakiye ti saatee eyye, Helot niŋ Pons Pilaat nkaconcoolo niŋ keeneetaat ka Pusuwif niŋ pakati Israyel kapupook Yéesu, amiikan a atii eesampanee ya aŋa annuce ya. ");
INSERT INTO krx_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ancuk káhinaa eeha ansoke ha ta infiyye nii efihitaako ti sempe sa sitii niŋ fa állafiye fa. ");
INSERT INTO krx_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Fiye, Ateeteyo, sincan fa nkayem fa unii ti kaafeyanool, iyyankanan unii pimiikan pa pakatii úpukup hilim ha hitii niŋ híyiinate henfakat. ");
INSERT INTO krx_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Yísan unii sempe sa sitii, ancuk ti caacaw Yéesu amiikan a atii eesampanee ya, álimaati hícump píyisan niŋ weecukantee utaako, púkuuña pa lompo nkákuuñanee.” ");
INSERT INTO krx_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ta nkapaye ta kaluum, la nkaconcoole la íyyiyiŋan. Poko púlooŋ nkameeŋ niŋ Kunuu ka keenape ka nkayeno káatuunan hilim ha hiti Pútuun pa niŋ híyiinate. ");
INSERT INTO krx_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Kayoŋ ka púlooŋ kiti kéeyinane ka nkiyeno pakoonool ti kunuu niŋ ti pámiiloolal. An óo an naacok faŋoo nii aŋa naataake ya eteyoo tom, nkápaacinool waah óo waah ewwa nkataake. ");
INSERT INTO krx_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Niŋ sempe senfakat pupoñapoñ pa nkayeniye káatuunan eeha nkacuke ha ti hisoku nii, Ateeteyo Yéesu alitaalito ti eket ya. Poko púlooŋ, Pútuun pa mpisampanii meemak. ");
INSERT INTO krx_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Taakut teyii an eesoolahe waah. Kaatuko keetaake ka pitaam, niŋ ekina tom pukumpaan nkanooman-nooman po nkácoopii mañ ma ");
INSERT INTO krx_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","nkañaakan mo pupoñapoñ pa. Poko, nkápaacinool mo ti an óo an fa naasoolahe fa. ");
INSERT INTO krx_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Intaako toko áyiin aŋa nkasok Josef. Pupoñapoñ pa nkayonkaloo Barnabas, caacaw encuu ciyem: “An aŋa náhaañiyan pakan paka.” Barnabas ati miin ma miti Lewi, náafulii ti econ eyya nkasok Siip. ");
INSERT INTO krx_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Naataak etaam eyya naanoomane, náacoopii mañ ma naañaakan mo pupoñapoñ pa. ");
INSERT INTO krx_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Fiye, intaako toko áyiin aŋa nkasok Anañas, akina niŋ aaloo Safila nkanooman ti etaam ya eteyii. ");
INSERT INTO krx_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Anañas náasiyool niŋ aaloo kapimank mikee mañ ma. Náacoopii mikee mañ ma apuwufan mo pupoñapoñ pa. ");
INSERT INTO krx_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Fiye, Piyeer naasokoo: “Anañas, puume Seetaani neenakiye yaani incaam hátikin Kunuu ka keenape ka, immank ti faŋi mikee mañ ma? ");
INSERT INTO krx_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Fo etaam ya etii tom le niŋ aafanooman yo? Ta annoomane yo ta lompo fo mañ ma miyeniit ti sipeesi? Weyme uwune ímmiilool íhinu eehuu? Aacaamut pakan paka pale Pútuun pa ancaame.” ");
INSERT INTO krx_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ta náasiye ta kilim enkuu, Anañas naanow naaket. Kéesiye ho ka fiye púlooŋ nkameeŋ niŋ ewatate enfakat. ");
INSERT INTO krx_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Pikampaani pa nkákey nkakuup ehunuŋ ya, íncakahokii yo. ");
INSERT INTO krx_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Máamun sitalaŋ síhaaciil sipimuus, aaloo náanakoonii péemiit heetaakiye ha áyiinoo. ");
INSERT INTO krx_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piyeer naacakanoo: “Sokam, ti soŋ eyye inninoomane etaam ya etaaluu?” Naañahanoo: “Ee, soŋ eyyuu.” ");
INSERT INTO krx_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Fiye, Piyeer naasokoo: “Weyme uwune awe niŋ áyiini innicoon puwinko Kunuu ka kiti Ateeteyo? Sincan! Kéehokii ka áyiini ahaayii ti putum pa efi lompo kacoopi.” ");
INSERT INTO krx_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tokotoko aal a naanow naaket ti woot Piyeer. Pikampaani pa kápinakoonii nkacukoo naakete nkacoopoo íncakahokiyoo pukol áyiinoo. ");
INSERT INTO krx_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kéeyinane ka púlooŋ niŋ kéesiye ho ka púlooŋ nkameeŋ niŋ ewatate enfakat. ");
INSERT INTO krx_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Pupoñapoñ pa nkáhin hícump píyisan niŋ weecukantee hátikin pakan paka. Kéeyinane ka púlooŋ ti Yéesu nkaloom pipaakool ti ekumpaan ya enfakat ya eti Pútuun pa lati Címpaŋ ya eti Solomon. ");
INSERT INTO krx_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","An áhaañiyantoo hinanfuyii, pale pakan paka nkánapiyanii. ");
INSERT INTO krx_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Háati fo, pakan paka kéeyinane ka ti Ateeteyo nkahaŋ toko nkameeŋe, kayoŋ kenfakat kiti pákayiin niŋ pakaal. ");
INSERT INTO krx_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Pakan paka nkácoopii fala púkuuña pa pakateyii ti ñítin ña nkahintanii ti pucunkun niŋ ti uhun ancuk niŋ Piyeer amuusaa hísaalumantoo níhilik pakakee teyii. ");
INSERT INTO krx_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Pakan keemeeŋe nkáfulii ti pisaatee pa peekole pa Jerusalem nkácoopoolii púkuuña pa pakateyii niŋ payenka kísaalumant nkinakiye, poko púlooŋ nkákuuñanee. ");
INSERT INTO krx_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Fiye, awaaseena ya enfakat a ati Pútuun pa niŋ pinapooloo, keeyem ka ti kayoŋ ka kiti Pusatusaay pa, nkataak paheeka ti pupoñapoñ pa. ");
INSERT INTO krx_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Nkacokii nkawantii ti ékuluma. ");
INSERT INTO krx_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pale niŋ hánant ha, maleekoo ya eti Ateeteyo néepankinii ñutum ña ñiti ékuluma ya, néefulaniyii neesokii: ");
INSERT INTO krx_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Nikaay nisiiŋo ti hank ha hiti ekumpaan ya enfakat ya eti Pútuun pa, innikaman pakan paka hilim ha hiti eloŋ eyye.” ");
INSERT INTO krx_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Pupoñapoñ pa nkáhin eeha neesokii ha. Cipilap, nkanako ti hank ha hiti ekumpaan ya enfakat ya nkayeno kakalaŋan pakan paka. Ta awaaseena ya enfakat a náacolii ta niŋ keeyem ka neyoo, nkaconcoolan ñíhampaatiin píhina kíiti ya púlooŋ pakati Pusuwif pa. Fiye, nkapoñ pati ékuluma ya kapica kácoopii pupoñapoñ pa. ");
INSERT INTO krx_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pale pufaasa pa pakati ekumpaan ya enfakat ya kapucol pati ékuluma ya kacukutii, nkañoho nkasokii: ");
INSERT INTO krx_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Ukaayaakaay pati ékuluma ya nuutook yo neekulee pitempo tak, pufaasa pa pakati ékuluma ya nkasiiŋo ti ñutum ña pale úpupankin ucukut páhantuwa an!” ");
INSERT INTO krx_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ahámpaatiin a ati pufaasa pa pakati ekumpaan ya enfakat ya niŋ ñíhampaatiin puwaaseena pa kápisi eehuu nkaliim meemak ti pupoñapoñ pa. Nkayeno ecakanoolo puume efihikelan. ");
INSERT INTO krx_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Fiye, an náakey naasokii: “Nisincan! Pákayiin paka payenka innikule ka ahaayii ti hank ha hiti ekumpaan ya enfakat ya ti kakalaŋan pakan paka.” ");
INSERT INTO krx_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tokotoko, áhampaatiin a ati pufaasa pa pakati ekumpaan ya enfakat ya naakaay niŋ pufaasa pa íncakacoopii pupoñapoñ pa, pale kácokiyootii niŋ sempe kamma nkafeye pakan paka timpi kanunkalii pukumpa. ");
INSERT INTO krx_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nkacoop pupoñapoñ pa hátikin ñíhampaatiin píhina kíiti ya. Awaaseena ya enfakat a naacakanii, ");
INSERT INTO krx_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","naasokii: “Fo ukitut aluu kakalaŋan ti caacaw áyiin a aŋuu? Pale nisincan eeha ínnihine ha! Nimeeŋanaa Jerusalem púlooŋ niŋ kakalaŋan ka kitaaluu, ínnilafi katiyan unii eket ya eti áyiin a aŋuu!” ");
INSERT INTO krx_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Piyeer niŋ pakakee pupoñapoñ pa nkañahanii: “Pútuun pa nuuñaŋe káasiitan pale an tom. ");
INSERT INTO krx_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Aluu nimuke Yéesu ta innipempeŋoo ta ti kuluwaa ya pale Pútuun pa piti símaama unaa mpilitanoo ti eket ya. ");
INSERT INTO krx_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Pútuun pa mpíseepinoo ti epees etempo yáali, mpíhinoo apiyeno ati hikaw ha niŋ Afakana ya kati puwufan pakati Israyel la éfikasik kápuwunko umuuyen wa uteyii nkaponketee. ");
INSERT INTO krx_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Unii utantake eehuu fiye púlooŋ, unii niŋ Kunuu ka keenape ka enka Pútuun pa mpuwufane ka kéetuule po ka.” ");
INSERT INTO krx_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ta nkásiye ta eehuu kiiñii nkili meemak ti pupoñapoñ pa nkálafiyii himuku. ");
INSERT INTO krx_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pale oonool teyii, Afalisaay caacawoo Kamaliyel, akalaŋana hilim ha heesiiŋanee ha hiti Móyiis, aŋa pakan paka púlooŋ nkánapiyane, naasiiŋo hátikin ñíhampaatiin píhina kíiti ya, naasok pupoñapoñ pa káfulanee fala tíkitaaŋ. ");
INSERT INTO krx_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Fiye, naasokii: “Aluu pakati Israyel, nitah kunuu meemak ti eeha ínnilafiye ha íhinu payenkuu. ");
INSERT INTO krx_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Sitiil seemuuse nuucukaa áyiin a aŋa nkasok ya Teyutas naacokooliye fa nii an eemaka, máamun pakan sikeme sipaakiil (400) kanapanoo. Pale ta naamukee ta poko fiye púlooŋ nkahancoolo, kiteyoo nékisiitee. ");
INSERT INTO krx_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Púful toko, ti caanak enca an óo an naañaŋee ta hikiicuyee caacawoo, intaako áyiin aŋa nkasok Yutas ati Galilee, pakakee pakan nkanapanoo naanoŋanii ti pakati kikaw ka. Akina lompo naamukee, pinapana pa pakateyoo púlooŋ nkahancoolo. ");
INSERT INTO krx_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ooto inci pusok aluu hoonool: Payenkuu nitahiipo! Timpi nipaaliyii nikatanii kapikaay! Kaatuko eeha nkámiilool ha niŋ eeha nkáhin ha, iyyema ti pakan níhifulii féefiye hiketaa. ");
INSERT INTO krx_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pale iyyema eeha nkayem ha ti íhinu ti Pútuun pa níhifulii, étiniyiniyii iheeku. Nitah kunuu, ti kafeyatan timpi niyeno pikamool niŋ Pútuun pa!” Píhina kíiti ya nkacoon eeha Kamaliyel naasoke ha. ");
INSERT INTO krx_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nkapoñ kápucoopii pupoñapoñ pa nkáhin kapisapee niŋ hisawut. Fiye, nkakitii káakup ti caacaw Yéesu, nkakatanii kapikaay. ");
INSERT INTO krx_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Pupoñapoñ pa nkáful ti éhinuma kíiti ya niŋ pásuuma penfakat. Kaatuko Pútuun pa pucokiicok nii pakan kéetuuniye pikallo ti caacaw ca citi Yéesu. Ekina ewune nkameeŋ niŋ pásuuma. ");
INSERT INTO krx_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Hinak óo hinak ti hank ha hiti ekumpaan ya enfakat ya eti Pútuun pa niŋ ti pukumpaan pa káyekuniit kakalaŋan niŋ káatuunan ekooŋan ya éesuume ya nii Yéesu ayem Eenucee ya ati Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ti oom caanak, pinapana pa nkayeno épenanoyii, Pusuwif pa payenka nkákup ka Kilek nkayeno káakumutool kiti Pusuwif pa pakati mah ma miti Israyel kamma kayoŋ ka kiteyii kiti piyaaŋat pa payenka pákayiinii keekete ka nkafiilee ti pípaacinool paliyal pa empa mpíhinee pa hinak óo hinak. ");
INSERT INTO krx_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Pupoñapoñ pa ŋaasuwan niŋ pákasupak paka nkaconcoolan kayoŋ ka kiti pinapana pa nkasokii: “Unii uñaŋut kakatan káatuunan hilim ha hiti Pútuun pa upuyeno káapaacinool ñaliyal. ");
INSERT INTO krx_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ekina ewune, aluu pakanam ti káyinan, nimamal ti pututa aluu pákayiin isak niŋ pákasupak payenka pakan paka púlooŋ nkahintiye, nkameeŋ niŋ Kunuu ka keenape ka niŋ ecohato, efuuñomanii páhin pa piti káapaacinool ñaliyal ña. ");
INSERT INTO krx_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Fiye, unii nuucoonool ti kaluum ka niŋ káatuunan hilim ha hiti Pútuun pa.” ");
INSERT INTO krx_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kayoŋ ka púlooŋ ínsuum ko ti eeha nkasokii ha. Nkamamal Stíifan, áyiin eemeeŋe niŋ káyinan niŋ Kunuu ka keenape ka. Nkamamal lompo Filip, Pulokol, Nikanol, Timon, Palemenas niŋ Nikolas, áyiin ati Antiyok, eenanfe ti pítin pa piti Pusuwif pa. ");
INSERT INTO krx_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nkácoopii pákayiin paka payenkuu ti pupoñapoñ pa. Pupoñapoñ pa nkaluum kiteyii nkalemp sipeesii teyii. ");
INSERT INTO krx_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Hilim ha hiti Pútuun pa níhimeyiyee pihaŋhaŋ toko. Po Jerusalem, pinapana pa nkayeno épenanoyii meemak. Hícump puwaaseena pakati Pútuun nkáyinan ti Yéesu. ");
INSERT INTO krx_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stíifan, áyiin aŋa Pútuun pa mpisampane mpimeeŋanoo sempe, náahin weecukantee niŋ hícump píyisan penfakat hátikin pakan paka. ");
INSERT INTO krx_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pale pakakee pakan keeyeniye ka ti éluumuma ya eyya nkasok ya “Elúumuma eti kéefule ti himiikanate”, nkáyaañ pílaacinool niŋ Stíifan. Poko kayem Pusuwif pakati Silen, Alesantili niŋ pakakee Pusuwif kéefulii ka Silisi niŋ Asii. ");
INSERT INTO krx_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pale kayinaatoo iheeku ti pákupal kamma Kunuu ka keenape ka nkuwunoo ecohato eti kayine káakup. ");
INSERT INTO krx_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Fiye, payenkuu nkacooy pakan kati kasok: “Usíyoosi ti kateñal Móyiis niŋ Pútuun pa!” ");
INSERT INTO krx_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Fiyuu nkáluuŋe pakan paka niŋ ñíhampaatiin ña niŋ pikalaŋana hilim ha heesiiŋanee ha hiti Móyiis. Nkalaako Stíifan, nkacoopoo hátikin ñíhampaatiin píhina kíiti ya pakati Pusuwif pa. ");
INSERT INTO krx_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nkákey niŋ pakakee pakan kati kacaam. Payenkuu nkasok: “Aŋuu áyekuniit hisoku heenaput ti ekumpaan ya enfakat ya eti Pútuun pa eesampanee ya niŋ ti hilim ha heesiiŋanee ha. ");
INSERT INTO krx_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kaatuko unii úsiyoosi ti hisoku nii Yéesu ati Naasalet aŋuu afaahancalool ekumpaan ya enfakat ya eti Pútuun pa, naayesan cosaan ya eyya Móyiis naawufane ya unaa.” ");
INSERT INTO krx_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ñíkin ñíhampaatiin píhina kíiti ya íññiyayii ti Stíifan, nkacuk puhooŋuyoo mpucuke nii piti maleekoo. ");
INSERT INTO krx_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Fiye, awaaseena ya enfakat a ati Pútuun pa naacakan Stíifan: “Fo eeha nkanookuu eehe hiti páni?” ");
INSERT INTO krx_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stíifan naañahanii ti hisoku: “Aluu pakanam niŋ ñífaafam, nísiitanam. Ta maamaa atuunaa Abraham naakine ta faw ti mah ma miti Mesopotami, le niŋ afaacaakin ti saatee ya eti Halan, Pútuun pa peemaka pa mpúfulii teyoo. ");
INSERT INTO krx_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Mpusokoo: 'Katan mah ma mitii niŋ miin ma mitii inkaay ti mah ma emma fáyisani ma.' ");
INSERT INTO krx_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Fiye, naakatan mah ma miti Kaletaay naakaay apikin Halan. Pamuusal eket ya eti faafoo, Pútuun pa mpúcoopiyoo ti mah emme innikine ma temmo fiye. ");
INSERT INTO krx_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pútuun pa, puwufanutoo le etaam háati citaam. Pale mpíyinananoo nii efipuwufanoo mah emme, akina niŋ miin ma miteyoo, apan ti oom caanak Abraham peelokot ataak añii. ");
INSERT INTO krx_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Eehe Pútuun pa mpusokoo: 'Miin ma mitii efimikin ti mah meeneetaat miteyii, la efikayeno pimiikan nkakallanee meemak fo sitiil sikeme sipaakiil (400).' ");
INSERT INTO krx_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pale Pútuun pa nene pusok: 'Fasiiŋan ti pisiya penfakat mah ma meecokii ma pimiikan niŋ fúlaa toko éfikafulii ti oom mah nkákey kapinkaluumam le.' ");
INSERT INTO krx_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Fiye, Pútuun pa mpiliil niŋ Abraham písiyool. Píyisan pa piti písiyool empuu piyem, áyiin óo áyiin anakanee. Ekina ewune Abraham ta naapuke ta añiinoo Isaak, naanakanoo ti hinoom ha heewase ha isak niŋ kíhaaciil. Isaak naapuk Jakob naalompo anakanoo, Jakob naapuk epuuk pákayiin ŋaasuwan niŋ pákasupak naanakanii, oom epuuk kayem símaama unaa siti miin ma ŋaasuwan niŋ músupak ma. ");
INSERT INTO krx_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Símaama unaa epuuk Jakob, nkataak paheeka ti atuwii Josef, nkanoomanoo kati ayeno amiikan ti mah ma miti Esipt. Pale Pútuun pa mpiyeno neyoo, ");
INSERT INTO krx_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","mpifakanoo ti kúnuuloo púlooŋ. Mpuwufanoo ecohato, mpíhinoo ápusuum amansa ya ati Esipt. Amansa ya náahinoo apiyeno ati hikaw ha hiti mah ma púlooŋ niŋ ekumpaan ya eteyoo púlooŋ. ");
INSERT INTO krx_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Fiye, épankul néenakoonii ti mah ma púlooŋ miti Esipt niŋ Kanaan. Iyyeno caanak citi kúnuul kenfakat. Símaama unaa kataakut paliyal. ");
INSERT INTO krx_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ta Jakob náasiye ta nii Esipt taakaataak paliyal, naapoñ ti púcook epuukoo símaama unaa. ");
INSERT INTO krx_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kapuñoho púsupiyenu, Josef náayisanoolo ti ñúnuwoo akina ayem ayme, náayisanii lompo Felo. ");
INSERT INTO krx_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Púful toko, Josef naapoñ kápucoopii paapaa ateyoo Jakob niŋ miin ma miteyoo púlooŋ, kayema pakan áwii éhaaciil niŋ kaat (75). ");
INSERT INTO krx_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Fiyuu Jakob naakaaye Esipt, po naakete akina niŋ epuukoo símaama unaa. ");
INSERT INTO krx_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Puhunuŋii mpiñahanee ti saatee ya eti Sikem mpuhokee ti hiyaak eeha Abraham naanoome ha niŋ mañoo ti epuuk Hamol. Hamol ayem paapaa ati Sikem. ");
INSERT INTO krx_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Púful toko, pakan unaa nkahaŋ toko nkameeŋe meemak ti mah ma miti Esipt fo ta íllohanii ta Pútuun pa kati píhin eeha mpíyinanane ha Abraham. ");
INSERT INTO krx_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Fiye, intaako Esipt amansa éeyeeni éemiit kiti Josef. ");
INSERT INTO krx_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Naacaakool pakan unaa naakallanii náahinii kapitah tíkitaaŋ miñiinii meepukee ma féefiye eeha efihiwun ha immiket. ");
INSERT INTO krx_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ti oom caanak Móyiis naapukee, añii eewalla hátikin Pútuun pa. Náakuumanee fo kiim kíhaaciil lati enuuf ya eti faafoo. ");
INSERT INTO krx_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ta naatahee ta tíkitaaŋ, Felo añiinoo ámaacul naacoopoo náakuloo nii añiinoo. ");
INSERT INTO krx_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Móyiis naakalaŋanee púlooŋ ecohato ya eti pakati Esipt naayeno áyiin aŋa nákup nawen niŋ sempe. ");
INSERT INTO krx_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ta Móyiis naataake ta sitiil áwii ésupak (40) náamiilool pikaayu hiyoop pakanoo pakati Israyel. ");
INSERT INTO krx_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Apucol po, naacuk ati Esipt ti kaakancool niŋ ati Israyel, fiye Móyiis naasiiŋo eekallanee ya naasap ati Esipt a naamukoo. ");
INSERT INTO krx_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Móyiis incukoo nii pakanoo pakati Israyel éfikapannum nii Pútuun pa púpoñiyoo kati pifakanii, pale kámiit ho. ");
INSERT INTO krx_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Eti kacom eteyyo, naacuk pákayiin pákasupak pakati Israyel ti pítaakool. Naaŋes káasiyoolanii, naasokii: 'Aluu pákawiyam, fo aluu pakoonool paka tom? Weyme inniyem ti pítaakool?' ");
INSERT INTO krx_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Eeyem ya ti kaakancool niŋ áwiyoo naahalap Móyiis naasokoo: 'Ayme asiiŋanuu ati hikaw niŋ afiita kilim ti pututa unii? ");
INSERT INTO krx_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Fo áalafiyaamlafi himuku samat nii fa ammuke fa hukan ati Esipt a?' ");
INSERT INTO krx_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Móyiis ápisi eehe, naatey ápuful Esipt, naakaay apikin ti mah ma miti Mitiyan. Po naataake epuuk mikampaani músupak. ");
INSERT INTO krx_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Sitiil áwii ésupak (40) sipimuus, maleekoo néefulii ti Móyiis ti kaaleew kiti cífita ti káahaaŋ ka tes pukol tíntiŋ eyya nkasok ya Sinayi. ");
INSERT INTO krx_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Móyiis apucuk eehuu ínnimoo ti eeha naacuke ha, pale apiteeŋo kati acuk púsooni náasi hilim ha hiti Ateeteyo Pútuun pa, nihisok: ");
INSERT INTO krx_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","'Inci yem Pútuun pa piti símaamayi, inci yem Pútuun pa piti Abraham, Isaak niŋ Jakob.' Móyiis naakikilan kamma ewatate áhaañiit fala kaasincan. ");
INSERT INTO krx_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Fiye, Ateeteyo Pútuun pa mpusokoo: 'Waat pisamata pa pitii, kaatuko la ansiiŋiye la, etaam eti meeñeya. ");
INSERT INTO krx_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Inci cukaacuk fanfaŋ fa nkayem fa ti kaakallan pakanam ti mah ma miti Esipt. Inci síyaasi palikalii úwwanoonii kati fakanii. Fiye kéy inci pupoñi Esipt.' ");
INSERT INTO krx_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Móyiis oonool a aŋuu akina pakati Israyel nkapooke fa ta nkasokoo ta: 'Ayme asiiŋanuu ati hikaw niŋ afiita kilim?' Móyiis, ti kayankanan ka kiti maleekoo ya éefulii ya teyoo ti cífita ca, akina Pútuun pa mpupoñe kati ayeno ati hikaw ha niŋ aŋa áfaafulanii ya ti himiikanate. ");
INSERT INTO krx_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Móyiis áfulanii pakati Israyel Esipt, ti íhinu hícump píyisan niŋ weecukantee, náahin wo lompo ti Kaatii ka Kéecunke ka niŋ ti káahaaŋ ka tes fo sitiil áwii ésupak (40). ");
INSERT INTO krx_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Móyiis aŋe asoke pakati Israyel nii: 'Pútuun pa éfipupoñii aluu ayaamakoola samat nii inci, afaayeno an éefulii ti pakan aluu.' ");
INSERT INTO krx_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Móyiis lompo ayeniye niŋ pakati Israyel ta nkaconcooliye ta ti káahaaŋ ka tes. Naayeno po niŋ símaama unaa niŋ maleekoo ya éekupe ya neyoo pati tíntiŋ ya eti Sinayi. Náasayii ti Pútuun pa kilim kiti eloŋ kiti kawufanee unaa. ");
INSERT INTO krx_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Pale símaama unaa kálafiitoo káasiitan, nkapookoo, kunuuwii púlooŋ nkuñoho Esipt. ");
INSERT INTO krx_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nkasok Aaron: 'Memanool unaa pínaati, peekaakaay unaa hinowu hátikin. Kaatuko, úmiit heetaakiye Móyiis aŋe, éefulanii ya unaa Esipt.' ");
INSERT INTO krx_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ti oom caanak nkamemanoole énaati eecuke nii cimpeeh, nkawaaseen teyyo nkataak pahaaño ti kámakiyan eeha nkamemanoole ha niŋ sipeesii. ");
INSERT INTO krx_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Pale Pútuun pa mpúwunkiyii, mpikatanii kápinkakilipo hátikin caanak ca, hiim ha niŋ picaaŋaŋ pa samat nii fa inkiicee fa ti pakiical pa piti piyaamakoola pa: 'Kayoŋ ka kiti Israyel fo inci wune inniwaaseen púlukuleen niŋ ñikee ñiwaaseen fo sitiil áwii ésupak ti káahaaŋ ka tes? ");
INSERT INTO krx_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Haani, pale nicoopoolaa-coopool ékuut ya eti Molok, énaati ya etaaluu, niŋ ecaaŋaŋ ya eti Lefan, ekee énaati ya etaaluu, pínaati empa aluu innimemanoole pa kati ínnikilipo hátikin etempo. Ekina ewune inci fáfulan aluu nípilaaŋ puson Babilon.' ");
INSERT INTO krx_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Símaama unaa kayekanaayekan ti káahaaŋ tes ékuut ya enfakat ya éeyisane ya nii Pútuun pa umpa neyii. Ekúut eyyuu ememanoolee-memanool samat nii fa Pútuun pa mpusoke fa Móyiis mpíyisanoo. ");
INSERT INTO krx_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Po hátikin, epuuk símaama unaa nkasa ékuut ya enfakat ya ti sífaafii. Nkacoopool yo ta Josuwa naayeniye ta ati hikaw ha, nkalam mah ma miti keekine ka toko, payenka Pútuun pa mpiyaane ka hátikinii. Neeyeno toko fo ti caanak ca citi amansa ya Dawid. ");
INSERT INTO krx_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawid náasuum Pútuun pa naaluum po pipikatanoo apulut ekumpaan eti Pútuun pa piti Jakob. ");
INSERT INTO krx_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pale amansa ya Solomon alute ekumpaan ya. ");
INSERT INTO krx_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Apan Pútuun pa piti patiila pikinantoo ti pukumpaan pa empa pakan paka nkalute pa samat nii fa ayaamakoola ya naasoke fa: ");
INSERT INTO krx_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","'Ateeteyo Pútuun pa pusok: \"Alacana eyem elemeyu ya etoom, etaam ya neeyeno élempuma wootam. Ekumpaan eecuke puume efinilutam? Leyme inci inkaakaay éyekunoolo? ");
INSERT INTO krx_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Fo inci tom liile eehuu púlooŋ?\"'” ");
INSERT INTO krx_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stíifan nene asokii: “Aluu kéeciita ka káakup payenkuu, weyme ñúsus aluu iññiyanke fiyaaw, unuu aluu nuucoto ti hísiyu hilim ha hiti Pútuun pa samat nii keenakiit ka ti písiyool empa Pútuun pa mpiliile pa niŋ Abraham? Tan óo tan innipookpook Kunuu ka keenape ka samat nii símaama aluu! ");
INSERT INTO krx_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ayme ti piyaamakoola pa símaama aluu nkakallanut? Nkamuk kéekupe ka ta infiyye kiti ékey ya eti Eecoonoole ya. Fiye, aluu, ínniful teyoo innimukoo. ");
INSERT INTO krx_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Símaama aluu niŋ aluu pumaleekoo pa mpuwufane hilim ha heesiiŋanee ha hiti Pútuun pa, pale níhinantoo fa nihisoke fa!” ");
INSERT INTO krx_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ta keeyem ka ti éhinuma kíiti ya nkásiye ta eehuu, kiiñii nkili meemak fo nkafincal úŋiiŋii teyoo. ");
INSERT INTO krx_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pale, Stíifan eemeeŋe ya niŋ Kunuu ka keenape ka naasincan patiila naacuk hamake ha hiti Pútuun pa niŋ Yéesu naasiiŋiye ti epees yáali eti Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Naasokii: “Nisincan, inci cukaa alacana néepankiniye, niŋ Añii An naasiiŋiye ti epees yáali eti Pútuun pa.” ");
INSERT INTO krx_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kápisi eehe nkaceek meemak nkacotal unuuwii nkalaakiyoo poko púlooŋ, ");
INSERT INTO krx_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","nkáhuunoo fo káful ti saatee ya nkáyaañoo kaanunkal niŋ pukumpa. Keetantake ka nkawufan kúsool ka kiteyii kenfakat ka akampaani aŋa nkasok Sóol. ");
INSERT INTO krx_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ta nkayeniyoo ta kaanunkal, Stíifan naaluum naasok: “Ateeteyo Yéesu, sa yaanam!” ");
INSERT INTO krx_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Fiye, náakilipo naaceek niŋ kaawiiluyoo naasok: “Ateeteyo ponketii kaamuuyen enke!” Apipa hisoku eehe naaket. ");
INSERT INTO krx_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sóol naasayan himukuyee ha hiti Stíifan. Ti oom hinoom kéeyinane ka pakati Jerusalem nkácookee kaakallanee meemak. Hícump teyii nkahancoolo ti mah ma miti Judaay niŋ Samali. Fiye ti kéeyinane ka, pupoñapoñ pa lamayii katowiye Jerusalem. ");
INSERT INTO krx_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Pakan keefeye Pútuun nkahok Stíifan nkakooŋ eket ya eteyoo meemak. ");
INSERT INTO krx_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Pale Sóol naaŋes kaahancalool kéeyinane ka; naanako ti pukumpaan pa náacokii kéeyinane ka, pákayiin niŋ pakaal naawantii ti ékuluma. ");
INSERT INTO krx_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Kéeyinane ka payenka nkahancaloole ka, nkakaay pan óo pan nkayeno káatuunan ekooŋan ya éesuume ya. ");
INSERT INTO krx_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Fiyuu Filip náawanoonii ti saatee eti Samali, naayeno káatuunan pakan paka kiti Eenucee ya. ");
INSERT INTO krx_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kayoŋ ka púlooŋ nkitah kunuu ti Filip meemak ti eeha naasoke ha, kaatuko kásiyoosi nkacukoo ti íhinu weecukantee. ");
INSERT INTO krx_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Hícump keetaake kísaalumant nkákuuñanee, kísaalumant ka nkúfulii teyii niŋ hiceeku. Hícump kéehute niŋ payenka nkanow niŋ efank nkákuuñanee. ");
INSERT INTO krx_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Fiye pásuuma penfakat mpiyeniye ti saatee eyyuu. ");
INSERT INTO krx_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Intaako áyiin eefiyye ti oom saatee, aŋa nkasok Simon, náhin páhinal piti pátuuta, pakan paka púlooŋ pakati Samali ínnimii teyoo. Naacokoolo nii an eemaka. ");
INSERT INTO krx_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","An óo an náasiitanoo meemak písik ti keemaka ka fo ti kéetinee ka, nkasok: “Ayíin aŋe ayem sempe sa siti Pútuun pa ensa nkasok sa 'Sempe sa Senfakat sa'.” ");
INSERT INTO krx_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Kásiitanoo-síitan meemak kaatuko afiyaafiyo ti íhinu páhinal piti pátuuta péenimii. ");
INSERT INTO krx_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pale, ta Filip náakeyii ta káatuunan ekooŋan ya éesuume ya eti cáwii ca citi Pútuun pa niŋ caacaw ca citi Yéesu Krista, nkáyinan nkáhinee pátise, pákayiin niŋ pakaal. ");
INSERT INTO krx_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon himuumoo náayinan náahinee pátise. Naayeno kanapan Filip pan óo pan, ínnimoo ti píyisan pa peemeeŋe pa niŋ weecukantee wa wenfakat wa ewwa naayeniye wa íhinu hátikin pakan paka. ");
INSERT INTO krx_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Po Jerusalem, pupoñapoñ pa nkási nii pakati Samali kasayanaasayan hilim ha hiti Pútuun pa, fiye nkapoñii Piyeer niŋ Saŋ. ");
INSERT INTO krx_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ta nkacole ta Samali, nkaluum kiti kéeyinane ka, Kunuu ka keenape ka kati kúwanoonii teyii. ");
INSERT INTO krx_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tempo Kunuu ka Keenape ka peelokot kúwanoonii ti an teyii, káhineehin pátise lamma ti caacaw ca citi Ateeteyo Yéesu. ");
INSERT INTO krx_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Fiye, Piyeer niŋ Saŋ nkalemp sipeesii teyii, Kunuu ka keenape ka nkúwanoonii teyii. ");
INSERT INTO krx_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon naacuk nii, emma pupoñapoñ pa nkalemp ma sipeesii ti pakan paka, tokotoko Kunuu ka keenape ka nkúwanoonii teyii. Ta Simon naacuke ta eehuu, naawufan pupoñapoñ pa mañ, ");
INSERT INTO krx_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","naasokii: “Niwufanam lompo sempe ense ancuk an óo an aŋa inci illempe teyoo sipeesam naasa Kunuu ka keenape ka.” ");
INSERT INTO krx_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pale, Piyeer naañahanoo: “Alímaati mañ ma mitii múpucaloolo niŋ awe himuumi, kamma incukuu nii áayiniyini hinoom kawun ka kiti Pútuun pa niŋ mañ! ");
INSERT INTO krx_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Putumi pineetaat cántum ti páhin pa putoonii, kaatuko ti Pútuun pa, yaani ekuulut. ");
INSERT INTO krx_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Katan pámiiloolali peenaput pa illuum Ateeteyo, pikee pa naaponketi pámiiloolali peenaput pa. ");
INSERT INTO krx_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ee, inci cukaacuk nii aapa meeŋe niŋ paseeña, íyyemi ti sempe sa siti kaamuuyen ka.” ");
INSERT INTO krx_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon naañahanii: “Aluu himuum aluu niluum Ateeteyo kutoom ancuk eeha innisoke ha púlooŋ timpi hitaakiyam.” ");
INSERT INTO krx_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pupoñapoñ pa, ta nkapaye ta kakaman eeha nkatantake ha ti eloŋ ya eti Ateeteyo, nkátuunan hilim ha hiti Pútuun pa, púful toko nkañoho pateyii Jerusalem. Ti puñoho pa, nkayeno káatuunan ekooŋan ya éesuume ya ti hícump misaatee miti Samali. ");
INSERT INTO krx_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Fiye, maleekoo eti Ateeteyo neesok Filip: “Lito hiiŋ Esipt, fo ti pítin pa piti káahaaŋ ka tes péewanoonii pa Jerusalem pupuwant saatee ya eti Gasa.” ");
INSERT INTO krx_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filip naalito naakaay. Akina ti pítin pa naapaakool niŋ áyiin. Ayíin a aŋuu an eemaka ti mah ma miti Ecoopiya. Kantas, amansa ya aal a ati Ecoopiya, naañomanoo hisaanumate ha hiteyoo púlooŋ. Ayíin a kaanimpan Pútuun pa naakaaye Jerusalem. ");
INSERT INTO krx_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Akina ti puñoho pateyoo, naayeno ti saleet ya eteyoo kalaŋ pakiical pa piti ayaamakoola ya Esaaya. ");
INSERT INTO krx_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Fiye, Kunuu ka keenape ka nkusok Filip: “Kaay, loh saleet eyyuu.” ");
INSERT INTO krx_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filip naatey pati saleet ya náasi áyiin a ti kalaŋ pakiical pa piti ayaamakoola ya Esaaya. Naakicanoo naacakanoo: “Fo áameyimeyi eeha ayyem ha ti kalaŋ fa nihisoke?” ");
INSERT INTO krx_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ayíin a naasokoo: “Puume inci iyyina ho kameye, niŋ an ácenkinutam?” Naasok Filip: “Síloonii yeno pukolam.” ");
INSERT INTO krx_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Naayeno kalaŋ pakiical empe: “Samat nii sáacii, nkacoopoo hitaaŋuyee; samat nii císaacii ceefatane niŋ kayeniyaa kaayiinu pahan etenco, ápankinut putumoo. ");
INSERT INTO krx_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nkasuuwanoo, nkapookoo kawufan tooñaa ya eteyoo. An ayinaat káakup kiti miin ma miteyoo, kaatuko eloŋ ya eteyoo éfulaneefulan ti púlunta pa.” ");
INSERT INTO krx_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ayíin a naacakan Filip: “Ponket sokam, ayaamakoola ya ati Pútuun pa, kiti ayme naayem ti káakup? Kiteyoo fo kiti akee?” ");
INSERT INTO krx_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Fiye, Filip náacook ti eeha áyiin a naayeniye ha kalaŋ, náatuunanoo ekooŋan ya éesuume ya eti Yéesu. ");
INSERT INTO krx_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ti pítinii nkacol la taake man. Ayíin a naasok Filip: “Sincan ehe man me, weyme efuukitam íhinuyee pátise?” ");
INSERT INTO krx_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Naasok saleet ya esiiŋo, poko t’ésupakii nkawano ti man ma, Filip náahinoo pátise. ");
INSERT INTO krx_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ta nkáfulii ta ti man ma, Kunuu ka kiti Ateeteyo nkíseepin Filip. Ayíin a nene acukutoo pale naahankan pítinoo niŋ pásuuma penfakat. ");
INSERT INTO krx_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip naacuk faŋoo ti saatee ya eti Asot, náaful toko naakaay ti saatee ya eti Sesaale naayeno káatuunan ekooŋan ya éesuume ya ti pisaatee pa púlooŋ empa namuus pa. ");
INSERT INTO krx_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ti oom caanak, Sóol, eesayane ya himukuyee ha hiti Stíifan, naatowo ti kaafeyanool ti hisoku nii afaamuk pinapana pa pakati Ateeteyo. Naakaay pati awaaseena ya enfakat a ati Pútuun pa ");
INSERT INTO krx_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","apusokoo nii akiicoo pileetal piti ñíhampaatiin ña pakati púluumuma pa piti Pusuwif pa ti saatee ya eti Damas. Pileetal empuu efipuwufanoo sempe siti pinako ti púluumuma pa, ancuk iyyema atookaa po keeyem ka ti Pítin pa piti Yéesu, man me pákayiin niŋ pakaal, naacokii naacoopii Jerusalem. ");
INSERT INTO krx_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Akina ti pítin pa apulohan Damas, tokotoko ecaaŋ néefulii patiila néeyayii teyoo néekinkooloo. ");
INSERT INTO krx_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sóol naanow t’etaam, náasi hilim heesokoo: “Sóol, Sóol, weyme uwune áyyemiyam ti kaakallan?” ");
INSERT INTO krx_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sóol naacakan: “Awe yem ayme, Ateeteyo?” Hilim ha nihiñahanoo: “Inci yem Yéesu aŋa ayyem ya ti kaakallan. ");
INSERT INTO krx_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Fiye lito inkaay pati saatee ya, aafakamanee eeha aññaŋe ha íhinu.” ");
INSERT INTO krx_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Pákayiin paka keeyeniye ka pinapool niŋ Sóol nkaŋaŋo. Nkási hilim ha pale kacukut an. ");
INSERT INTO krx_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sóol naalito la naanowe la pale ta náapankine ta ñíkinoo acukut waah. Nkátintiŋanoo kapinako Damas. ");
INSERT INTO krx_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Náafuum fo kunoom káhaaciil aliit waah alaanut. ");
INSERT INTO krx_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Toko Damas, intaako anapana aŋa nkasok Anañas. Ateeteyo náafulii teyoo pucuk fiye nii éyawut, naasokoo: “Anañas!” Anañas naañahanoo: “Eheeyam Ateeteyo.” ");
INSERT INTO krx_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ateeteyo naasokoo: “Lito inkaay ti pítin pa empa nkasok pa 'Pítin Peecoonoole', innako ti ekumpaan ya eti Yutas, incakan áyiin a aŋa éefulii ya ti saatee ya eti Taas aŋa nkasok ya Sóol. Kaatuko oopa ti kaluum féefiye. ");
INSERT INTO krx_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Pucuk fiye nii ti éyawut, naacuk áyiin aŋa nkasok Anañas, náanakoonii naalemp sipeesoo teyoo kati añoho ti hicuku.” ");
INSERT INTO krx_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Anañas naañahanoo: “Ateeteyo, hícump pakan kakamanaam-kaman heenaput ha púlooŋ eeha áyiin aŋuu naayeniye ha íhinu Jerusalem, pakani keesampanee ka. ");
INSERT INTO krx_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Akéyyookey le, ñíhampaatiin puwaaseena pa kawufanoowufan sempe siti hicoku payenka púlooŋ nkaluum ka ti caacawi.” ");
INSERT INTO krx_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pale Ateeteyo naasokoo: “Kaay, kaatuko inci mamaloo kati acoop caacawam ti keeneetaat ka Pusuwif niŋ pumansa pa niŋ lompo ti pakati Israyel. ");
INSERT INTO krx_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Inci himuumam fáyisanoo kúnuul ka púlooŋ enka naañaŋe ka hicuku kamma caacawam.” ");
INSERT INTO krx_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Púful toko, Anañas naalito naakaay naanako lati ekumpaan ya la Sóol naayem la, naalemp sipeesoo teyoo naasokoo: “Sóol atoomuu, Ateeteyo Yéesu ápoñiyaam, éefulii ya ti awe ti pítin pa, awe ti ékey ya le. Apóñiyaampoñ ancuk aañohiyaa ti hicuku immeeŋanee niŋ Kunuu ka keenape ka.” ");
INSERT INTO krx_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tokotoko, waah weecuke nii puwes núufulii ti Sóol ñíkinoo núunowii, naañoho ti hicuku. Naalito náahinee pátise. ");
INSERT INTO krx_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Apipa hili, sempeyoo ínsiñohoonii. Eehuu hipimuus, Sóol naayeno po Damas kikee kunoom niŋ pinapana pa. ");
INSERT INTO krx_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tokotoko náayaañ káatuunan ti púluumuma pa piti Pusuwif pa apusok nii, Yéesu ayem Añii Pútuun. ");
INSERT INTO krx_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kéesiyoo ka púlooŋ ínnimii nkacakan: “Fo aŋe tom ayeniye Jerusalem kaakallan payenka nkaluum ka ti caacaw Yéesu? Fo ákeyyoot hicokuyii kati awufanii ñíhampaatiin puwaaseena pa pakati Pútuun pa?” ");
INSERT INTO krx_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pale Sóol naahaŋ toko naataake sempe, náayisan picaaŋ cataŋ Pusuwif pa keekine ka Damas nii, Yéesu ayem Eenucee ya ati Pútuun pa. Kámiit eeha efikañahanoo. ");
INSERT INTO krx_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Po hátikin, Pusuwif pa nkateŋenool kati kamukoo. ");
INSERT INTO krx_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Hánant hanakan, nkayeniyoo cíllopa ti ñutum saatee ya kati kamukoo, pale Sóol náasi ho. ");
INSERT INTO krx_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ti oom caanak, pinapana pa pakati Sóol nkacoopoo níhanant, nkaŋes kasekeyu nkanakanoo tenko nkáyuuŋanoo, nkawananoo ti hiniŋ ha hiti saatee ya. ");
INSERT INTO krx_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ta Sóol naacole ta Jerusalem naayoop hinanfu pinapana pa, pale poko púlooŋ káhaañiitoo kaatuko an áyinanut nii pánipani Sóol anapana. ");
INSERT INTO krx_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Fiye, Barnabas naacoopoo nkakaay pati pupoñapoñ pa. Barnabas naakamanii eehe: “Ti pítin pa Sóol acukaacuk Ateeteyo, Ateeteyo náakup neyoo. Po Damas Sóol náatuunan niŋ híyiinate ti caacaw ca citi Yéesu.” ");
INSERT INTO krx_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Písik ti oom caanak Sóol naayeno neyii, naamuusool Jerusalem, náatuunan niŋ híyiinate ti caacaw ca citi Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Napaakool-paakool niŋ Pusuwif pa payenka nkákup ka Kilek náalaacinool neyii pale poko, nkayeno hiŋes puume éfikahin kapumukoo. ");
INSERT INTO krx_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kéeyinane ka kápisi eehuu, nkacoop Sóol ti saatee ya eti Sesaale, púful toko nkáhin apikaay ti saatee ya eti Taas. ");
INSERT INTO krx_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Fiye, kéeyinane ka nkayeno ti kásuumaay ti mah ma miti Judaay púlooŋ, Galilee niŋ Samali, káyinan ka kiteyii nkihaŋ toko nkitaake sempe. Ti eloŋ ya eteyii nkafe Ateeteyo, Kunuu ka Keenape ka nkíhaañiyanii. Fiyuu nkayeniye épenanoyii. ");
INSERT INTO krx_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piyeer naakaawool pan óo pan, hikee hinoom naakaay ti saatee ya eyya nkasok ya Lita hiyoop keesampanee ka pakati Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Toko, naacuk páhut áyiin aŋa nkasok Enee, eeyinaat pilito ti ecunkun ya eteyoo fo sitiil isak niŋ síhaaciil. ");
INSERT INTO krx_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piyeer naasokoo: “Enee, Yéesu Krista ákuuñanuu, lito intan ecunkun ya etii!” Tokotoko Enee naalito. ");
INSERT INTO krx_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Pakan paka púlooŋ keekine ka ti pisaatee pa piti Lita niŋ Salon nkacuk eehuu nkánanfii ti Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Intaako aal ti pinapana pa pakati Yope, caacawoo Tapita (ti kaŋ ya eti Kilek, Tookas, ekina eyem “himisawoot”). Eloŋoo púlooŋ likee tom fo íhinu heenape niŋ kayankanan keeleke ka. ");
INSERT INTO krx_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ti oom kunoom, náakuuñ halapat naaket. Nkañow ehunuŋ ya nkahintan yo ti ékaap eeyem patiila. ");
INSERT INTO krx_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Páawoo pisaatee pa piti Lita niŋ Yope pílaaŋoolut, pinapana pa pakati Yope kápisi nii Piyeer oopa Lita nkapoñ pákayiin pákasupak kapica kaluum Piyeer: “Ponket kéy tokofiye!” ");
INSERT INTO krx_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piyeer naalito naanapool neyii. Apucol nkacoopoo ti ékaap ya eti patiila. Piyaaŋat pa púlooŋ payenka pákayiinii keekete ka nkalohoo niŋ pukooŋ nkáyisanoo kúsool ka niŋ wañ ewwa Tookas naacife wa akina kaloŋayoo. ");
INSERT INTO krx_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piyeer náafulanii poko púlooŋ tíkitaaŋ, náakilipo naaluum. Apipa náayesoonii lipa ti ehunuŋ ya naasok: “Tapita lito.” Aal a náapankin ñíkinoo, apucuk Piyeer naalito naayeno. ");
INSERT INTO krx_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piyeer náasisikanoo apisiiŋo. Púful toko, naayonkal keesampanee ka pakati Pútuun pa niŋ piyaaŋat pa náayisaniiyoo kaloŋa. ");
INSERT INTO krx_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Eehuu níhisiyo ti saatee ya púlooŋ eti Yope, hícump pakan nkáyinan ti Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piyeer naakampan Yope lati áyiin apaalaha aŋa nkasok Simon. ");
INSERT INTO krx_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Intaako ti saatee ya eti Sesaale áyiin aŋa nkasok Kooneli, áhampaatiin asoocaali ati kayoŋ ka kiti pusoocaali pa pakati Room, kayoŋ ka enka nkasok ka “Kayoŋ ka kiti Itali”. ");
INSERT INTO krx_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ayíin eewufane meemak eloŋ ya eteyoo Pútuun pa naafe po, akina niŋ miin ma miteyoo, nayankanan Pusuwif pa keeleke ka, naluum po tan óo tan. ");
INSERT INTO krx_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Hikee hinoom, kaapii kiti sitalaŋ síhaaciil nkániim, maleekoo ya eti Pútuun pa néefulii teyoo pucuk fiye nii éyawut, naacuk yo picaaŋ cataŋ néenakoonii ti ekumpaan ya eteyoo, neesokoo: “Kooneli!” ");
INSERT INTO krx_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Naasincan yo niŋ ewatate naañahan yo: “Weyme utaakiye, Ahámpaatiin?” Maleekoo ya neesokoo: “Pútuun pa pisayanaasayan kaluum ka kitii, pifiilut lompo kayankanan ka enka ánhin ka ti keeleke ka. ");
INSERT INTO krx_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Fiye, poñ pakan ti saatee ya eti Yope kapica káyonkalii Simon aŋa nkasok ya Piyeer. ");
INSERT INTO krx_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Oopa awanane lati Simon apaalaha ya, ekumpaan ya eteyoo néeyemi pukol kaatii ka.” ");
INSERT INTO krx_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ta maleekoo ya neekaaye ta, Kooneli náayonkalii pákasupak ti pimiikan pa pakateyoo niŋ akee ti pusoocaali pa píhina pa pakateyoo. Asoocaali aŋuu, áyiin eewufane meemak eloŋ ya eteyoo Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Naakamanii heetaakiye ha púlooŋ; púful toko naapoñii Yope, nkañak. ");
INSERT INTO krx_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Eti kacom eteyyo, máamun caanak ca ti kikaw, pimiikan pa pákasupak paka niŋ asoocaali ya nkalohan saatee ya eti Yope. Tempo, Piyeer naasilo patiila ekumpaan ya kaluum. ");
INSERT INTO krx_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Peep mpucokoo náalafi hili. Ta nkayeniye ta kaamemanool paliyal pa, waah núufulii teyoo pucuk fiye nii éyawut naayaake. ");
INSERT INTO krx_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Naacuk patiila mpánkiniye, waah núufulii po weecuke nii kahuuy kenfakat keecenkee ti sitonkoŋ sa sipaakiil sa, nkúwananiyee pukoloo. ");
INSERT INTO krx_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Toko páhantuwa etenko intaako élukuleen óo élukuleen eti woot upaakiil, eyya néhuunoolo niŋ pusuwa. ");
INSERT INTO krx_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Hilim nihisokoo: “Piyeer, lito! Muk illi!” ");
INSERT INTO krx_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pale Piyeer naañahan ti hisoku: “Hitaakiit, Ateeteyo! Kaatuko inci taapala li efoofa eyya hilim ha heesiiŋanee ha nihikite hili ti hisoku nii ekuulut.” ");
INSERT INTO krx_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Hilim ha nene hisokoo púsupiyenu: “Waah ewwa Pútuun pa mpukuulane, timpi sok nii ukuulut.” ");
INSERT INTO krx_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Eehuu nihitaako fo ñáhaaciil, tokotoko kahuuy ka nkíseepinee patiila. ");
INSERT INTO krx_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piyeer naayeno káamiilool hiti eeha naacuke ha. Ti oom káasiiŋuma, pákayiin paka payenka Kooneli naapoñe ka nkacol ti putum pa, loho kacakanoolaa ekumpaan ya eti Simon. ");
INSERT INTO krx_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nkayonkal nkacakan: “Fo le Simon aŋa nkasok ya Piyeer naawanane?” ");
INSERT INTO krx_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piyeer naaloŋ ti káamiilool hiti eeha naacuke ha, Kunuu ka keenape ka nkusokoo: “Sincan, pákayiin pákahaaciil unka nkacakani. ");
INSERT INTO krx_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Fiye, lito uwwano inkaay neyii timpi taak kunuu kúsupak kaatuko inci póñiyii.” ");
INSERT INTO krx_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piyeer náawanoonii, naasokii: “Eheeyam, inci inniyem ti hiŋes, weyme ínnikeyii?” ");
INSERT INTO krx_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nkasokoo: “Kooneli ápoñii unii, áhampaatiin asoocaali, áyiin eecoonoole naafe Pútuun, Pusuwif pa púlooŋ nkákup teyoo heenape. Maleekoo ya eti Pútuun pa éfulii teyoo neesokoo ayonkali pati ekumpaan ya eteyoo kati ásiitan eeha ankaakaay hisoku.” ");
INSERT INTO krx_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Fiye, Piyeer naasokii kánakoonii naawananii. Eti kacom eteyyo, Piyeer naanapool neyii, pakakee ti kéeyinane ka pakati Yope nkanapanii. ");
INSERT INTO krx_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Eti tanta eteyyo, naacol ti saatee ya eti Sesaale, Kooneli naayeno hítuulu écolii ya eteyii. Naaconcoolan miin ma miteyoo niŋ pákawiyoo keekoloo ka meemak. ");
INSERT INTO krx_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Piyeer niŋ panakiyaloo ti ekumpaan ya, Kooneli naapaakoolanoo, náakilipo ti wootoo naanimpanoo. ");
INSERT INTO krx_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pale Piyeer naalitanoo, naasokoo: “Lito inci lompo an kenseŋ.” ");
INSERT INTO krx_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Akina ti káakup niŋ Kooneli, naanako páhantuwa, naacuk kayoŋ ka nkuconcooliye, ");
INSERT INTO krx_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","naasokii: “Aluu faŋ aluu nímeyimeyi nii hilim ha heesiiŋanee ha hitoonii hicoonut unii Pusuwif upunakanoolo niŋ keeneetaat ka Pusuwif; uyinaatii ékey hiyoop. Pale Pútuun pa píyisanaam-yísan nii, inci ñaŋut fiye hicoku an nii akuulut. ");
INSERT INTO krx_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ekina ewune emma ínniyonkaliyaam ma inci ínkey peetaakut kunuu kúsupak. Weyme ínniyonkaliyaam?” ");
INSERT INTO krx_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kooneli naasokoo: “Kunoom kíhaaciil keemuuse ti sitalaŋ síhaaciil ense inci iyyeniye kaluum ti ekumpaan ya etoom. Tokotoko, an eewasiye wañ weehiina paŋ naasiiŋo hátikinam, ");
INSERT INTO krx_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","naasokam: 'Kooneli, Pútuun pa písiyaasi kaluum ka kitii, pifiilut lompo kayankanan ka enka ánhin ka ti keeleke ka. ");
INSERT INTO krx_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Fiye, poñ pakan ti saatee ya eti Yope kápiyonkalii Simon aŋa nkasok ya Piyeer. Oopa awanane lati Simon apaalaha ya, ekumpaan ya eteyoo néeyemi pukol kaatii ka.' ");
INSERT INTO krx_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ekina ewune inci inhaŋ hipoñu ti awe, ánhin heenape áapikey. Fiye, ehe unii púlooŋ hátikin Pútuun pa, kati úsi eeha púlooŋ mpuwufanuu ha aakati sok unii.” ");
INSERT INTO krx_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Piyeer naacoop hilim ha naasok: “Inci meya fiye nii pánipani Pútuun pa pifisakanoolut pakan paka, ");
INSERT INTO krx_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","pale ti písii pa púlooŋ, Pútuun pa pisayanaasayan an óo an eefeye po náahin heecoonoole. ");
INSERT INTO krx_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","“Nímeyimeyi nii Pútuun pa púpoñiyoopoñ ti pakati Israyel ekooŋan ya éesuume ya eti kásuumaay ka kéenapii ka ti Yéesu Krista, eeyem ya Ateeteyo ati pakan paka púlooŋ. ");
INSERT INTO krx_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nímeyimeyi heetaakiye ha, púcook ti mah ma miti Galilee niŋ heetaakiye ha lompo ti mah ma miti Judaay púlooŋ. Eehuu púlooŋ nihitaako pamuusal pátise ya eyya Saŋ naayeniye ya káatuunan. ");
INSERT INTO krx_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nímeyimeyi lompo fa Pútuun pa mpimamale fa Yéesu ati Naasalet mpíhin Kunuu ka keenape ka kúpuwanoonii teyoo, mpuwufanoo lompo sempe. Yéesu naayeno kaamuusool ti pisaatee pa náahin heenape, náakuuñan payenka Seetaani néewuuliye ka kaatuko Pútuun pa piyenaayeno neyoo. ");
INSERT INTO krx_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Unii uyem keetantake ka eeha náahine ha púlooŋ Jerusalem niŋ ti pikee pisaatee pa piti Pusuwif pa. Nkamukoo ta nkapempeŋoo ta ti kuluwaa ya, ");
INSERT INTO krx_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","pale ti hinoom ha híhaaciyenu ha Pútuun pa mpilitanoo ti eket ya. Mpíhin ápiyisanoolo. ");
INSERT INTO krx_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ayísanooliit ti pakan paka púlooŋ pale ti keetantake ka payenka Pútuun pa mpimamale ka ta infiyye, poko kayem unii. Unii uliye nuulaan neyoo ta náalitoonii ta ti eket ya. ");
INSERT INTO krx_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Naasok unii ukaman pakan paka eeha nuucuke ha, núutuunanii nii, akina Pútuun pa mpisiiŋane apiyeno áhina kíiti ya ati keeyem ka kaloŋa niŋ keekete ka. ");
INSERT INTO krx_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Piyaamakoola pa púlooŋ kákupaakup kiteyoo ti hilim ha hiti Pútuun pa, nkasok nii an óo an éeyinane ti Yéesu, ti caacawoo Pútuun pa efipuponket umuuyen wa uteyoo.” ");
INSERT INTO krx_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Piyeer ti káakup kilim enke, Kunuu ka keenape ka nkúwanoonii ti keeyeniye ka púlooŋ káasiitan hilim ha, ");
INSERT INTO krx_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","nkáyaañ káakup niŋ pikee pikaŋ nkayeno hímulu Pútuun pa. Pusuwif pa kéeyinane ka kéenapoolii ka niŋ Piyeer, ta nkásiye ta eehuu ínnimii kamma Pútuun pa mpuwufane keeneetaat ka Pusuwif lompo Kunuu ka keenape ka. Fiye, Piyeer naasok: ");
INSERT INTO krx_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Páawoo Kunuu ka keenape ka kúwanooniyoo-wano teyii samat nii fa nkúwanoonii fa ti unaa Pusuwif pa, ayme ayina hikituyii íhinuyee pátise niŋ man?” ");
INSERT INTO krx_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Naawufan hilim kati káhinee pátise ti caacaw ca citi Yéesu Krista. Púful toko, nkaluum Piyeer apiyeno neyii fo kikee kunoom. ");
INSERT INTO krx_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Pupoñapoñ pa niŋ kéeyinane ka keekine ka ti mah ma miti Judaay nkási nii pakakee ti keeneetaat ka Pusuwif kasayanaasayan lompo hilim ha hiti Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ta Piyeer naacole ta Jerusalem, Pusuwif pa kéeyinane ka nkawatanoo ");
INSERT INTO krx_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ti hisoku: “Aakaayaakaay pati keeneetaat ka Pusuwif, illi lompo neyii apan kanakiit ti písiyool empa Pútuun mpiliile pa niŋ maamaa atuunaa Abraham!” ");
INSERT INTO krx_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Fiye, Piyeer naakamanii heetaakiye ha púlooŋ kápiliŋ ti púcook. Naasokii: ");
INSERT INTO krx_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ta inci iyyeniye ta ti saatee ya eti Yope piyeno kaluum, waah núufulii ti inci pucuk fiye nii éyawut iyyaake. Incuk waah wéefulii patiila úpuhiiŋii peti inci, weecuke nii kahuuy kenfakat, sitonkoŋ sa sipaakiil sa insiŋuntee. Kahuuy enkuu nkíkey pukolam. ");
INSERT INTO krx_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Insincan lupo pinap, incuk púlukuleen piti woot upaakiil niŋ púlukuleen piti elampa niŋ empa mpúhuunoolo, niŋ pusuwa. ");
INSERT INTO krx_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Fiye, ínsi hilim heeyeniyaam hisoku: 'Piyeer, lito! Muk illi!' ");
INSERT INTO krx_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Pale iññahan ti hisoku: 'Hitaakiit, Ateeteyo! Kaatuko efoofa eyya hilim ha heesiiŋanee ha nihikite hili ti hisoku nii ekuulut etaapala enako ti putumam.' ");
INSERT INTO krx_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Hilim ha níhifulii patiila nene hisokam púsupiyenu: 'Waah ewwa Pútuun pa mpukuulane, timpi sok nii ukuulut.' ");
INSERT INTO krx_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Eehuu nihitaako fo ñáhaaciil, púful toko, eehuu púlooŋ nihicoopee patiila. ");
INSERT INTO krx_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ti oom káasiiŋuma, pákayiin pákahaaciil kéefulii ti saatee ya eti Sesaale kéepoñiyee ti inci, nkácolii ti ekumpaan ya la nuuyeniye la. ");
INSERT INTO krx_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Kunuu ka keenape ka nkusokam napool neyii timpi taak kunuu kúsupak. Kéeyinane ka isak niŋ oonool a payenke nkanapanam, nuunako lati ekumpaan ya eti áyiin a eeyonkalaam ya. ");
INSERT INTO krx_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Naasok unii puume naacuke maleekoo néenakoonii lati ekumpaan ya eteyoo neesokoo: 'Poñ pakan ti saatee ya eti Yope kapica káyonkalii Simon aŋa nkasok ya Piyeer. ");
INSERT INTO krx_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Afaasoki kilim keekaakaayi kafakan, awe niŋ miin ma mitii púlooŋ.' ");
INSERT INTO krx_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Emma inci íncooke ma káakup Kunuu ka keenape ka nkúwanoonii teyii samat nii fa nkúwanoonii fa ti unaa ti púcook pa. ");
INSERT INTO krx_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Fiye, inci ínnawuno eeha Ateeteyo mpaasok ha: 'Saŋápatiseyaa-pátise pakan paka niŋ man pale aluu éfinihinee pátise niŋ Kunuu ka keenape ka.' ");
INSERT INTO krx_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Híinihiini nii, kawun enka Pútuun pa mpuwufane ka unaa ta núuyinanaa ta ti Ateeteyo Yéesu Krista, kikina lompo mpuwufane keeneetaat ka Pusuwif. Fiye, inci yem ayme kati yíni hikitu Pútuun pa eeha mpílafiye ha?” ");
INSERT INTO krx_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ta nkásiye ta eehuu, nkatempan. Nkámul Pútuun pa ti hisoku: “Fiye, keeneetaat ka Pusuwif lompo, Pútuun pa puwufaniiwufan la éfikasik kati káwunko umuuyen wa uteyii, nkataak eloŋ ya eepayantoo ya.” ");
INSERT INTO krx_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Pamuusal eket ya eti Stíifan, kéeyinane ka nkakallanee fo nkahancooliye. Pakakee teyii nkatey fo ti mah ma miti Fenisi, pakakee paka fo ti econ ya eti Siip, pakakee paka lompo fo ti saatee ya eti Antiyok, nkayeno káatuunan ekooŋan ya éesuume ya, pale ti Pusuwif pa lamma. ");
INSERT INTO krx_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Háati ekina, intaako teyii kéeyinane pakati Siip niŋ Silen keekaaye Antiyok nkayeno káatuunan ekooŋan ya éesuume ya eti Ateeteyo Yéesu keeneetaat ka Pusuwif. ");
INSERT INTO krx_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Sempe sa siti Ateeteyo insiyeno neyii, hícump pakan nkáyinan nkánanfii ti Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Kéeyinane ka pakati Jerusalem nkási eehuu. Fiye, nkapoñ Barnabas Antiyok. ");
INSERT INTO krx_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ta naacole ta naacuk kaasampan ka kiti Pútuun pa, ínsuumoo. Naapenanii kunuu ti hisokuyii kásik piliit tiw ti Ateeteyo niŋ saanii púlooŋ, ");
INSERT INTO krx_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","kaatuko Barnabas an eenape, naameeŋ niŋ Kunuu ka keenape ka naataak káyinan kenfakat. Hícump pakan nkananf ti Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Púful toko, Barnabas naakaay ti saatee ya eti Taas hiŋes Sóol. ");
INSERT INTO krx_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ta naacukoo ta naacoopoo Antiyok. Nkayeno po etiil púmpuluŋ niŋ kéeyinane ka, nkakalaŋan hícump pakan. Po Antiyok pinapana pa nkáyaañee kayonkalee Pikelecen. ");
INSERT INTO krx_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ti kunoom enkuu, piyaamakoola nkáfulii Jerusalem nkakaay Antiyok. ");
INSERT INTO krx_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Oonool teyii caacawoo Akapus naalito, Kunuu ka keenape ka nkútunkoo apusok nii efitaak épankul enfakat ti mah ma púlooŋ. (Pánipani eehuu nihitaako ta Kulot naayeniye ta amansa ya enfakat a ati Room.) ");
INSERT INTO krx_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Fiye, pinapana pa nkasok nii efikawufan waah, an óo an la naayina, ewwa efikapoñ kati kayankanan kéeyinane ka keekine ka ti mah ma miti Judaay. ");
INSERT INTO krx_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Hikina nkáhine: nkawufan wo Barnabas niŋ Sóol, nkasokii cakawufan ñíhampaatiin ña pakati kéeyinane ka keeyem ka ti saatee ya eti Judaay. ");
INSERT INTO krx_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ti oom caanak Helot Akilipa faaf a ayeniye amansa ya. Naacok pakakee ti kéeyinane ka kati akallanii. ");
INSERT INTO krx_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Naamuk Saak, Saŋ púnuwoo, niŋ káakuntu. ");
INSERT INTO krx_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ta naacuke ta nii eehuu hísuumaasuum Pusuwif pa, naacok lompo Piyeer. Eehuu nihitaako ti kunoom ka kiti pahaaño pa piti Himuusu ha. ");
INSERT INTO krx_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ta Piyeer naacokee ta, Helot naakuloo, naapoñ uyoŋ upaakiil uti pusoocaali pakapaakiil kati kasayool efaas ya eteyoo. Náalafiyoo íhinu kíiti hátikin pakan paka niŋ pahaaño pa piti Himuusu ha pumuusaa. ");
INSERT INTO krx_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Fiye Piyeer naayeniyee efaas ti ékuluma, pale kéeyinane ka nkaŋiino kaluum Pútuun pa kiteyoo. ");
INSERT INTO krx_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Hánant ha le niŋ Helot áfaahinoo kíiti, Piyeer naayeno hiŋotu ti pututa pusoocaali pákasupak, naacenkee niŋ ñiseel ñúsupak. Pusoocaali nkayeno efaas ti putum pa piti ékuluma ya. ");
INSERT INTO krx_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tokotoko maleekoo eti Ateeteyo néefulii teyoo neesiiŋo pukoloo, ecaaŋ neecaaŋan cataŋ ékaap ya. Maleekoo ya neesap Piyeer ti kaheh néeyiyaloo, neesokoo: “Lito mpacas!” Tokotoko ñiseel ña ñeecenke ña sipeesoo iññiyoŋo. ");
INSERT INTO krx_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Púful toko, maleekoo ya neesokoo: “Cenk peletoo ya etii, iwwaso pisamata pa pitii.” Piyeer náahin ho. Maleekoo ya neneesokoo: “Waso hísool ha hitii henfakat ha, ínnowii ti inci.” ");
INSERT INTO krx_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piyeer náaful naanapan yo. Pale ámiit nii eeha maleekoo ya néehine ha hiti pánipani, incukoo nii éyawut. ");
INSERT INTO krx_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Fiye, nkamuus la pusoocaali pa pákayaañ paka nkayeniye la efaas, nkamuus lompo lati pákasupiyenu paka. Púful toko, nkacol ti hunkut ha hiti mañ ma hiti ékuluma ya eeha annap ha teeho aapiteenako ti saatee ya. Hunkut ha níhipankinoolo hátikinii. Nkáful nkacok pítin pa fo kálaaŋan caahinkiŋ. Tokotoko maleekoo ya neeyemaŋ hátikin Piyeer. ");
INSERT INTO krx_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tempo conko Piyeer naameya heetaakiye ha. Naasok: “Fiye, inci meya nii pánipani Ateeteyo ápoñiyoopoñ maleekoo ya eteyoo kati efakanam néefulaniyam ti sempe sa siti Helot niŋ ti eeha Pusuwif pa nkálafiye ha kati áhinam.” ");
INSERT INTO krx_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ta naameya ta heetaakiye ha, naakaay ti ekumpaan ya eti Mari, íññaa ya ati Saŋ aŋa nkasok ya lompo Mark. Hícump pakan nkaconcool po kapiyeno kaluum. ");
INSERT INTO krx_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Piyeer naawenken hunkut ha hiti tíkitaaŋ, amiikan aal aŋa nkasok Lota naayiiŋo. ");
INSERT INTO krx_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Naakiiw hilim Piyeer. Naameeŋ niŋ pásuuma fo naafiile káapankin, naañoho niŋ katey naasok: “Aha Piyeer pati hunkut ha!” ");
INSERT INTO krx_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Nkasokoo: “Ee, aawuyaawuyo!” Pale naaŋiino ti eeha naasoke ha. Fiye nkasokoo: “Ooto maleekooyoo.” ");
INSERT INTO krx_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ta nkayeniye ta káakup, Piyeer naatowo ti kaawenken. Ta nkápankine ta nkacukoo ínnimii meemak. ");
INSERT INTO krx_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Piyeer naanako náayisanii niŋ epeesoo timpi kaceek. Púful toko naakamanii puume Ateeteyo náafulaniyoo ti ékuluma ya. Fiye naasok: “Nisok ho Saak niŋ pakakee paka kéeyinane ka.” Púful toko, náaful apikaay lakeenaay. ");
INSERT INTO krx_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Eti kacom eteyyo, pusoocaali pa keeyeniye ka efaas Piyeer nkaliim paliimal. Nkacakanoolo: “Peyme Piyeer naayem?” ");
INSERT INTO krx_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Helot naapoñ kapiŋesoo, pale kacukutoo. Fiye, naacakanool pusoocaali pa; apipa, naawufan hilim kapumukee. Púful toko, náaful mah ma Judaay ápuwanoonii ti saatee ya eti Sesaale naayeno po. ");
INSERT INTO krx_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ti oom caanak, amansa ya Helot naataak paseeña penfakat ti pakati Til niŋ Siton. Páawoo paliyal pa piteyii, pati mah ma miti amansa ya ímpufulii tan óo tan, ekina ewune nkapoñ teyoo pakan kapica kaluumoo. Nkakaay nkákup niŋ Palastus, áhina ya ati hikawoo, apiyankananii. Fiye, naanapool neyii kapikaay hicuku Helot nkasokoo nii kálafilafi púsuumool neyoo. ");
INSERT INTO krx_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Helot naacoon kati kacukool. Hinoom eeha naawufanii ha kati ákup neyii níhicolii, naawaso hísool ha hiti himansate ha, naayeno ti elemeyu ya eteyoo. Náakup niŋ kayoŋ ka. ");
INSERT INTO krx_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Pakan paka, ta nkásiyoo ta ti káakup, nkayeno kaaceeceekool: “Eeyem ya ti káakup, akee ti ñútuun ña pale an tom!” ");
INSERT INTO krx_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tokotoko maleekoo eti Ateeteyo néetahii Helot káakuuñu, kaatuko hamake ha hiti Pútuun pa nkacoope kapuwufanoo, pale añahanut ho Pútuun pa. Fiye, puhoc mpinako munowoo naaket. ");
INSERT INTO krx_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Hilim ha hiti Pútuun pa níhimeyiyee pihaŋhaŋ toko, pinapana pa nkayeno épenanoyii. ");
INSERT INTO krx_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ti oom caanak, Barnabas niŋ Sóol nkapa páhin pa empa nkawufanii pa kati káhin Jerusalem. Fiye, nkañoho Antiyok, nkacoopool Saŋ aŋa nkasok ya Mark. ");
INSERT INTO krx_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Intaako ti kéeyinane ka pakati Antiyok piyaamakoola niŋ pikalaŋana, poko kayem: Barnabas, Sóol, Simeyon aŋa nkasok ya Apáani, Lusiyus ati Silen niŋ Manayen (akina ayem éekulee ya nantoonool niŋ amansa ya Helot Antipas). ");
INSERT INTO krx_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Hikee hinoom, poko ti suŋ niŋ kaanimpan Ateeteyo, Kunuu ka keenape ka nkusok: “Niyenan ti kaapii Barnabas niŋ Sóol, hak páhin empa inci iyyonkalii pa.” ");
INSERT INTO krx_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Fiye, ta nkapaye ta suŋ niŋ kaluum nkalemp sipeesii ti Barnabas niŋ Sóol, púful toko, nkakatanii kapikaay. ");
INSERT INTO krx_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Fiye, ta Kunuu ka keenape ka nkupoñe ta Barnabas niŋ Sóol, nkakaay ti saatee ya eti Selusi. Kápuful toko, nkáyuuko ti piteen penfakat nkakaay ti econ ya eti Siip. ");
INSERT INTO krx_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ta nkacole ta Siip ti saatee ya eti Salamin, nkátuunan ekooŋan ya éesuume ya ti púluumuma pa piti Pusuwif pa. Saŋ Mark naayeniyii kayankanan. ");
INSERT INTO krx_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nkafiitan econ ya púlooŋ fo ti saatee ya eti Pafos. Ta nkacole ta Pafos nkatook toko áyiin pátuuta aŋa nkasok Pal-Yéesu, Asuwif eecokooliye nii ayaamakoola. ");
INSERT INTO krx_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Améyooli-méyooli niŋ ati hikaw ha hiti econ ya aŋa nkasok ya Seesiyus Póolus, áyiin eecohatiye. Hikee hinoom, ati hikaw ha naapoñ kápiyonkalii Barnabas niŋ Sóol, kaatuko álafilafi káasiitan ekooŋan ya éesuume ya. ");
INSERT INTO krx_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pale pátuuta pa Elimas (caacawoo ti kaŋ ya eti Kilek) naapook Barnabas niŋ Sóol, kaatuko álafiit ati hikaw ha kati áyinan ti Yéesu Krista. ");
INSERT INTO krx_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Fiye, Sóol aŋa nkasok ya lompo Póol naameeŋ niŋ Kunuu ka keenape ka. Naasincanoo caw ");
INSERT INTO krx_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","naasokoo: “Awe nincaama, áhina heenaput, añii Seetaani, akamool heenape! Teyme áafayekuno kaanakanool tooñaa ya eti Ateeteyo? ");
INSERT INTO krx_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Fiye síitan, Ateeteyo afaasapi, aatinenecuk caanak ca, áafafuum fo cikee caanak.” Tokotoko Elimas náafuum, naayeno ti énimaan. Naayeno toko káamaaputool aŋa áfaatintiŋanoo. ");
INSERT INTO krx_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ta ati hikaw ha naacuke ta heetaakiye ha, náayinan ti Ateeteyo Yéesu. Eeha nkakalaŋanoo ha hinakiyoonako meemak. ");
INSERT INTO krx_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Púful toko, Póol niŋ pinapooloo nkáyuuko ti piteen penfakat ti saatee ya eti Pafos kapikaay Peek, saatee eti mah ma miti Panfili. Saŋ Mark náatahiyii toko náañohoonii Jerusalem. ");
INSERT INTO krx_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pale Póol niŋ pakakee paka, kápuful Peek nkakaay Antiyok, saatee eti mah ma miti Pisiti. Ti hinoom ha hiti kayeno ka hiti Pusuwif pa nkanako ti éluumuma ya nkayeno. ");
INSERT INTO krx_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ta nkapaye ta kalaŋ hilim ha heesiiŋanee ha hiti Móyiis niŋ pakiical pa piti piyaamakoola pa, ñíhampaatiin ña pakati éluumuma ya nkapoñ an apicaasokii: “Aluu pakan unii, niŋ nitaakaa eeha efinisok keeyem ka le kati nipenanii káyinan, níyiniyini káakup.” ");
INSERT INTO krx_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Póol naalito. Náaseepin epeesoo, naasok: “Aluu pakati Israyel niŋ aluu lompo keeneetaat ka Pusuwif keefeye ka Pútuun pa, nísiitanam! ");
INSERT INTO krx_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Pútuun pa piti pakati Israyel, pimamalaamamal símaama unii. Mpíhinii kapimeeŋ ta nkayeniye ta ti mah ma miti Esipt. Púful toko, mpúfulaniyii po niŋ sempe etempo. ");
INSERT INTO krx_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Fo sitiil áwii ésupak (40) mpumukutoolo neyii ti káahaaŋ ka tes. ");
INSERT INTO krx_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Mpumukal sísii isak niŋ súsupak ti mah ma miti Kanaan, mpuwufan pakan etempo etaam ya épiyenoonii eteyii. ");
INSERT INTO krx_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Eehuu púlooŋ, pifiyo eteeho pitaakaa fiye máamun sitiil sikeme sipaakiil niŋ áwii ésupak niŋ ŋaasuwan (450). “Pamuusal eehuu, mpuwufanii píhina kíiti kapiyeno pakati kikaw fo ti caanak ca citi Samiyel ayaamakoola ya. ");
INSERT INTO krx_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Púful toko, pakan paka nkasok nii kálafilafi hitaaku amansa. Pútuun pa mpuwufanii Sóol añii ya ati Kis ati miin ma miti Benjamin, akina ayeniye amansa ya ateyii fo sitiil áwii ésupak (40). ");
INSERT INTO krx_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pale Pútuun pa mpúfulanoo ti himansate ha mpíhin Dawid apiyeno amansa ya ateyii. Mpúkup kiteyoo ti hisoku nii: 'Cukaacuk Dawid añii ya ati Yesaay, áyiin eenowaam ti yaan, áfaahin eeha púlooŋ inci íllafiye ha ápihin.' ");
INSERT INTO krx_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Ti miin ma miti Dawid aŋuu, Pútuun pa mpúfulanii Afakana ya ati Israyel, samat nii fa mpíyinanane fa ta infiyye. Akina ayem Yéesu. ");
INSERT INTO krx_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Le niŋ Yéesu áfaakey, Saŋ naayeno káatuunan pakati Israyel púlooŋ: 'Níhinee pátise nípiyisan nii níwunkaawunko umuuyen wa utaaluu.' ");
INSERT INTO krx_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ta páhin pa piti Saŋ mpulohane ta hipayu, naasok: 'Ti aluu, inci yem ayme? Inci neetaat aŋa inniyem ya ti hítuulu. Pale nísiitan: aŋuu áfaakey pusonam, inci yinaat fala káfulan pisamata pa piteyoo.' ");
INSERT INTO krx_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Aluu pakanam, keeyem ka epuuk Abraham, niŋ aluu lompo keeneetaat ka Pusuwif keefeye ka Pútuun pa, unaa Pútuun pa mpúpoñii hilim ha hiti kafakan enke. ");
INSERT INTO krx_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Pánipani, pakati Jerusalem niŋ ñíhampaatiin ña pakateyii kakiiwut Yéesu nkamukoo. Pale ta nkamukoo ta, ti káameyaatiyii nkáhine heesokee ha ti pakiical pa piti piyaamakoola pa empa nkakalaŋ pa lóokuŋ óo lóokuŋ ti hinoom ha hiti kayeno ka. ");
INSERT INTO krx_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Kacukut heewune kati áhinee kíiti naamukee, pale háati fo, nkaluum Pilaat apumukoo. ");
INSERT INTO krx_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ta nkapaye ta íhinu heekiicee ha púlooŋ teyoo ti hilim ha hiti Pútuun pa, nkáwananiyoo ti kuluwaa ya, nkahokoo ti hiyaak. ");
INSERT INTO krx_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pale Pútuun pa mpílitaniyoo ti eket ya! ");
INSERT INTO krx_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Fo kunoom keemeeŋe Yéesu náfulii ti pakan paka, keeyeniyoo ka kanapan kápiliŋ ti mah ma miti Galilee fo ti saatee ya eti Jerusalem. Poko kayem fiye ti káatuunan pakati Israyel eeha nkacuke ha. ");
INSERT INTO krx_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Unii payenke, úcoopiyoocoop aluu ekooŋan ya éesuume ya eyye: Eeha Pútuun pa mpíyinanane ha símaama unii nii efihitaako, ");
INSERT INTO krx_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","fiye, mpíhin ho unii epuukii, ta mpilitane ta Yéesu ti eket ya, samat nii fa inkiicee fa ti hícimu ha hísupiyenu ha hiti pakiical pa piti kícimu ka. Mpusok: 'Awe yem añiinam, písik fíyooy inci yem faafi.' ");
INSERT INTO krx_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Pútuun pa mpusok nii éfipilitaniyoo ti eket ya, eniinoo etefut. Fiye mpusoke ho: 'Inci fawufan aluu weesampanee wa, ewwa inci íyyinanane wa Dawid ta infiyye nii fawufanoo wo.' ");
INSERT INTO krx_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Ekina ewune Dawid nene akiic ti hilim ha hiti Pútuun pa apusok po: 'Aatikat enii amiikan a atii eenape ya, epufut ti hiyaak.' ");
INSERT INTO krx_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Dawid ti caanak ca citeyoo, ta naapaye ta íhinu waah wa púlooŋ ewwa Pútuun pa mpílafiye wa, naaket. Naahokee niŋ símaamayoo, eniinoo neefut. ");
INSERT INTO krx_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pale aŋa Pútuun pa mpilitane ya ti eket ya, afutut. ");
INSERT INTO krx_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Yéesu awune núuyemi aluu ti káatuunan kaaponket ka kiti umuuyen wa. Kéeyinane ka púlooŋ teyoo Pútuun pa pucokiicok nii keecoonoole ciit, pale hilim ha heesiiŋanee ha hiti Móyiis hiyinaat íhinu aluu kati nicokee nii keecoonoole ciit. ");
INSERT INTO krx_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Fiye, nitah kunuu ancuk eeha piyaamakoola pa nkasoke ha timpi hitaako aluu. Kasok: ");
INSERT INTO krx_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","'Nisincan, aluu kéewiiniyanaam ka, niyeno ti paliima inniket! Kaatuko ti caanak ca citaaluu inci fáhin waah, étiniyinan wo, háati an naasok wo aluu.'” ");
INSERT INTO krx_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ta Póol niŋ Barnabas nkayeniye ta hífulu ti éluumuma ya, pakan paka nkaluumii kati káñohoonii lóokuŋ eyya lupo, ti hinoom ha hiti kayeno ka, kati kátuunanii nene eehuu. ");
INSERT INTO krx_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ta nkahancooliye ta, hícump Pusuwif niŋ keenanfe ka ti pítin pa piti Pusuwif pa nkanapool niŋ Póol niŋ Barnabas. Pupoñapoñ pa pákasupak paka nkákup neyii, nkasokii kákipen kati katowo ti kaasampan ka kiti Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Hinoom ha hiti kayeno ka hiti Pusuwif pa níhicolii, máamun pakan paka púlooŋ pakati saatee ya kaconcooliye kati kásiitan hilim ha hiti Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ta Pusuwif pa nkacuke ta kayoŋ ka, nkataak paheeka ti Póol niŋ Barnabas. Ta Póol naayeniye ta káatuunan nkálaacinoo nkateñaloo. ");
INSERT INTO krx_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Fiye, Póol niŋ Barnabas nkañahanii niŋ híyiinate henfakat, nkasokii: “Ti aluu Pusuwif pa hilim ha hiti Pútuun pa nihiñaŋee hícooku káatuunanee. Pale páawoo nipookaapook ho, innicokoolo nii nítuuniit hitaaku eloŋ ya eepayantoo ya, fiye, unii efuuyeso ti keeneetaat ka Pusuwif. ");
INSERT INTO krx_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kaatuko eehe Ateeteyo naasoke unii. Asok: 'Inci hínuu aapiyeno ecaaŋ ya ti keeneetaat ka Pusuwif, Aakati cóopii kafakan ka pan óo pan ti púlunta pa.'” ");
INSERT INTO krx_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ta keeneetaat ka Pusuwif nkásiye ta eehuu, ínsuumii meemak, nkáyaañ hímulu hilim ha hiti Ateeteyo. Nkáyinan, poko púlooŋ payenka Pútuun pa mpimamale ka kati kataak eloŋ ya eepayantoo ya. ");
INSERT INTO krx_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Hilim ha hiti Ateeteyo nihihancaloolo ti mah ma púlooŋ. ");
INSERT INTO krx_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pale Pusuwif pa nkanoŋan pakaal paka keemaka ka kéetuule ka Pútuun pa niŋ ñíhampaatiin saatee ya, nkalito ti Póol niŋ Barnabas, nkakallanii fo káfulanii ti mah ma miteyii. ");
INSERT INTO krx_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Fiye, Póol niŋ Barnabas nkahank haafol ha ti wootii kápiyisanii nii Pútuun pa efipisapii, nkakaay ti saatee ya eti Ikoñum. ");
INSERT INTO krx_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pinapana pa nkameeŋ niŋ pásuuma niŋ Kunuu ka keenape ka. ");
INSERT INTO krx_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Po, ti saatee ya eti Ikoñum, moonool muu nii heetaakiye ha Antiyok, Póol niŋ Barnabas nkanako ti éluumuma ya eti Pusuwif pa nkayeno káakup fo hícump Pusuwif niŋ keeneetaat Pusuwif káyinan. ");
INSERT INTO krx_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pale Pusuwif pa keepooke ka káyinan nkanoŋan keeneetaat ka Pusuwif kapitaak pámiiloolal peenaput ti kéeyinane ka. ");
INSERT INTO krx_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Póol niŋ Barnabas nkakampan Ikoñum ti káakup niŋ híyiinate niŋ káyinan kiti Ateeteyo. Ateeteyo lompo naawufanii kayine kiti íhinu hícump píyisan niŋ weecukantee ápiyisan nii hilim ha hiti panap pa piteyoo eeha nkátuunan ha, hiti pánipani. ");
INSERT INTO krx_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pakan paka pakati saatee ya nkápaacinoolo: pakakee ti kaapii ka kiti Pusuwif pa, pakakee paka ti kaapii ka kiti pupoñapoñ pa pákasupak paka. ");
INSERT INTO krx_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Pusuwif pa niŋ keeneetaat ka Pusuwif niŋ ñíhampaatiin ña pakateyii, nkasiiŋo kati kakallan Póol niŋ Barnabas kati kamukii niŋ kaanunkal pukumpa. ");
INSERT INTO krx_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ta pupoñapoñ pa nkásiye ta eehuu nkatey Listal niŋ Teep, pisaatee piti Likawoni, niŋ ti pisaatee pa péekinkoole po pa. ");
INSERT INTO krx_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Po lompo nkayeno káatuunan ekooŋan ya éesuume ya. ");
INSERT INTO krx_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Intaako ti saatee ya eti Listal áyiin aŋa nayeno tan óo tan kayen kamma wootoo núuhute, éehute kápiliŋ ta naapukee, ataapala akaay. ");
INSERT INTO krx_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Hikee hinoom naayeno káasiitan Póol, Póol naasiiŋan ñíkinoo teyoo naacuk nii aŋe, ataakaataak káyinan kiti káakuuñanee. ");
INSERT INTO krx_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Naaceek naasokoo: “Lito insiiŋo aapucoonool ciit!” Ayíin a naanuut náayaañ pikaayu. ");
INSERT INTO krx_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ta kayoŋ ka nkucuke ta eeha Póol náahine ha nkaceek ti kaŋ ya eteyii Likawoni nkasok: “Ñútuun ña ñíwanooniyoo tuunaa samat nii pakan.” ");
INSERT INTO krx_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Nkawas Barnabas caacaw ca citi pútuun pa piteyii “Sás”; páawoo Póol ayem ákupa yuu, nkayonkaloo “Heemes”. ");
INSERT INTO krx_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Awaaseena ya ati ekumpaan ya eti Sás eeyem ya puson saatee ya náakey ti ñutum ña náacoopoolii kíciin niŋ páluufeen. Akina niŋ kayoŋ ka nkálafi kaawaaseen kíciin ka pupoñapoñ pa pákasupak paka. ");
INSERT INTO krx_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pale ta Barnabas niŋ Póol nkásiye ta eehuu, nkahaacalool kúsool ka kiteyii kápiyisan nii cíitiyiiciiti meemak, nkatey kapinako ti kayoŋ ka nkasokii niŋ hiceeku: ");
INSERT INTO krx_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Aluu pákawiyam, weyme ínnihine fiyuu? Unii lompo pakan kenseŋ samat nii aluu! Ukéyyookey écoopii aluu ekooŋan ya éesuume ya kati nikatan pínaati pa pitaaluu peetaakut pa nafaa ínniyesoonii peti Pútuun pa peeyem pa kaloŋa. Pikina piliile patiila niŋ t’etaam niŋ waah óo waah weeyem toko, mpiliil lompo kaatii ka niŋ waah óo waah weeyem lupo. ");
INSERT INTO krx_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ti caanak ca citi símaama unaa, pikatanaakatan písii pa púlooŋ pipimamal pítin pa péesuume po pa. ");
INSERT INTO krx_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pale píyekuniit éyisanoolo pínapii ti heenape ha eeha mpíhin ha ti pakan paka, samat nii fa mpúwananii fa etiil, mpuwufan aluu pamaañal peenape ta incole ta toko, mpuwufan aluu paliyal fo nisiit, mpimeeŋan saan aluu lompo niŋ pásuuma.” ");
INSERT INTO krx_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pale háati eeha pupoñapoñ pa nkasoke ha, ínciiti meemak kati kakit kayoŋ ka kaawaaseenii kíciin ka. ");
INSERT INTO krx_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Púful toko, pakakee Pusuwif nkácolii kápufulii ti pisaatee pa piti Antiyok niŋ Ikoñum. Nkañak kayoŋ ka ti kaapii ka kiteyii nkanunkal Póol pukumpa kati kamukoo. Nkáhuunoo fo káful ti saatee ya, kaatuko cukiicuk nii aketaaket. ");
INSERT INTO krx_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pale pinapana pa, ta nkákinkoole ta Póol, náalitoonii, naanako ti saatee ya. Eti kacom eteyyo, Póol niŋ Barnabas nkakaay ti saatee ya eti Teep. ");
INSERT INTO krx_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Nkayeno ti saatee eyyuu káatuunan ekooŋan ya éesuume ya fo nkataake hícump pakan kéeyinane ti Yéesu. Púful toko, nkañoho ti pisaatee pa piti Listal, Ikoñum niŋ Antiyok ti mah ma miti Pisiti. ");
INSERT INTO krx_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Po, nkapenan pinapana pa káyinan, nkapenanii lompo kunuu kati katowo ti hicoku piliit tiw ti káyinan ka. Nkasokii: “Fo ucukaa hícump kúnuul kati unakiyaa ti cáwii ca citi Pútuun pa.” ");
INSERT INTO krx_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Lan óo lan la taake kéeyinane, Póol niŋ Barnabas nkamamal pakan kati kayeno ñíhampaatiin. Kapipa kaluum niŋ suŋ, nkañomanii Ateeteyo aŋa poko púlooŋ nkáyinane ya teyoo. ");
INSERT INTO krx_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Fiye nkanap ti mah ma miti Pisiti nkacol ti mah ma miti Panfili. ");
INSERT INTO krx_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ta nkátuunane ta pakati saatee ya eti Peek ekooŋan ya éesuume ya, nkawano ti saatee ya eti Atali. ");
INSERT INTO krx_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Púful toko, nkáyuuko ti piteen penfakat kapuñoho Antiyok ti mah ma miti Siriya. Ti oom saatee impi kañomanee ti sipees Pútuun pa, le niŋ éfikacook páhin etempo empa nkapaye pa. ");
INSERT INTO krx_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ta nkacole ta, nkaconcoolan kéeyinane ka nkakamanii eeha púlooŋ Pútuun pa mpíhine ha neyii niŋ fa mpípankine fa putum pa piti káyinan ka ti keeneetaat ka Pusuwif. ");
INSERT INTO krx_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nkakampan po niŋ pinapana pa. ");
INSERT INTO krx_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Pakakee Pákayiin nkáfulii ti mah ma miti Judaay kápuwanoonii ti saatee ya eti Antiyok nkayeno kakalaŋan kéeyinane ka nii: “Niñaŋee kanakan ti písiyool empa Pútuun pa mpiliile pa niŋ maamaa atoonii Abraham, samat nii fa nuunakan fa epuuk unii niŋ kataakaa kunoom isak niŋ kíhaaciil. Niŋ ninakanutee, samat nii fa hilim ha heesiiŋanee ha hiti Móyiis nihisoke fa unii, étiniyiniyee kafakan.” ");
INSERT INTO krx_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Póol niŋ Barnabas kacoonut eeha pákayiin paka nkasoke ha, nkálaacinool neyii meemak. Ti oom pílaacinool, nkasiiŋo ti eehe: Póol, Barnabas niŋ pakakee efikakaay Jerusalem kápukup hilim eehe niŋ pupoñapoñ pa niŋ ñíhampaatiin ña. ");
INSERT INTO krx_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Fiye, kéeyinane ka nkawufanii aŋa nkasoolahe ya ti kaakaawool ka. Nkanap ti mah ma miti Fenisi niŋ Samali nkakamanii puume keeneetaat ka Pusuwif nkáyesoonii ti Pítin pa piti Yéesu. Eehuu níhisuum meemak kéeyinane ka púlooŋ. ");
INSERT INTO krx_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kapucol Jerusalem, kéeyinane ka, pupoñapoñ pa niŋ ñíhampaatiin ña nkawananii. Póol, Barnabas niŋ pinapoolii nkakamanii eeha púlooŋ Pútuun pa mpíhine ha neyii. ");
INSERT INTO krx_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pale pakakee ti kéeyinane ka keeyem ka ti kayoŋ ka kiti Pufalisaay pa nkasiiŋo nkasok: “Keeneetaat ka Pusuwif, fo kanakanee ti písiyool empa Pútuun pa mpiliile pa niŋ maamaa atuunaa Abraham, samat nii fa nuunakanaa fa epuuk unaa niŋ kataakaa kunoom isak niŋ kíhaaciil, fo kasokee lompo nii kañaŋaa hítuulu hilim ha heesiiŋanee ha hiti Móyiis.” ");
INSERT INTO krx_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Pupoñapoñ pa niŋ ñíhampaatiin ña nkaconcool kati kákup ti hilim ha. ");
INSERT INTO krx_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nkákupat meemak. Fiye, Piyeer naasiiŋo naasok: “Aluu pakanam ti káyinan, nímeyimeyi nii Pútuun pa pimamalaam-mamal ti aluu ta infiyye, pútuunan ekooŋan ya éesuume ya keeneetaat ka Pusuwif kati kási ho nkáyinan. ");
INSERT INTO krx_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Pútuun pa pímeyimeyi saan pakan paka mpíyisan nii pisayanaasayan keeneetaat ka Pusuwif ta mpuwufanii ta Kunuu ka keenape ka, samat nii fa mpuwufane ko fa unaa. ");
INSERT INTO krx_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Pifisakanoolutii niŋ unaa, káyinan ka kiteyii kuwune Pútuun pa mpukuulan saanii. ");
INSERT INTO krx_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Fiye, weyme uwune ínniyemi ti puwinko Pútuun pa? Innílafi katiyan pinapana pa pitiyo empa símaama unaa niŋ unaa nuuyinaataa pitiyo. ");
INSERT INTO krx_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Pale úyinanaayinan nii kamma panap pa piti Ateeteyo Yéesu nuufakanee samat nii poko.” ");
INSERT INTO krx_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Fiye, keepaakoole ka toko púlooŋ nkafatan kati kásiitan Póol niŋ Barnabas kapikamanii píyisan pa peemeeŋe pa niŋ weecukantee wa ewwa Pútuun pa mpíhine wa ti keeneetaat ka Pusuwif pínapii teyii. ");
INSERT INTO krx_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ta nkapaye ta káakup, Saak naasokii: “Aluu pakanam ti káyinan, nísiitanam! ");
INSERT INTO krx_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon akamanaakaman unaa fa Pútuun pa mpíyaañe fa pipikaay hiyoop keeneetaat ka Pusuwif mpimamal pakakee teyii kápiyenoonii pakan etempo. ");
INSERT INTO krx_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Eehuu nihinapool niŋ kilim ka kiti piyaamakoola pa samat nii fa inkiicee fa ti hilim ha hiti Pútuun pa: ");
INSERT INTO krx_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","'Ateeteyo asok: Hikee hinoom, inci fáñohoonii pineneñahan cáwii ca citi Dawid céepucaloolee ca incihancaloolee. Fanenesiiŋan co íññahanii sempe etenco. ");
INSERT INTO krx_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ancuk pikee písii pa efipiŋesam, inci Ateeteyo Pútuun pa, poko kayem keeneetaat ka púlooŋ Pusuwif payenka inci iyyonkale ka kati káyenoonii pakanam. Inci pusok ho aluu, inci Ateeteyo Pútuun pa, ");
INSERT INTO krx_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","yísanaayisan ho ta infiyye.'” ");
INSERT INTO krx_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Saak nene asok: “Ehe eeha inci ímmiiloole ha: uñaŋutaa kayokan keeneetaat ka Pusuwif keeyem ka ti éyesoonii ti Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Pale ukiicii upusokii timpi kali efoofa eewaaseenee ti énaati kaatuko ekuulut. Nuusokii lompo timpi kayeno ñusupoolata, timpi kali efoofa eti élukuleen eetaaŋutee, timpi kali efoofa eetaake hísim. ");
INSERT INTO krx_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kaatuko kápiliŋ ti caanak ca citi símaama unaa, intaako ti saatee óo saatee pakan payenka nkátuunan hilim ha heesiiŋanee ha hiti Móyiis. Lóokuŋ óo lóokuŋ nkakalaŋ ho, ti hinoom ha hiti kayeno ka, ti púluumuma pa.” ");
INSERT INTO krx_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Fiye, pupoñapoñ pa niŋ ñíhampaatiin ña poko niŋ kéeyinane ka púlooŋ keeyem ka Jerusalem nkásiyool kati kamamal pakakee teyii payenka nkakaakaay hipoñu ti saatee ya eti Antiyok kapinapool niŋ Póol niŋ Barnabas. Nkamamal Silas niŋ Yutas aŋa nkasok ya Paasapas, poko t’ésupakii keemaka ti kéeyinane ka. ");
INSERT INTO krx_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Nkawufanii leetal eyye: “Unii pakan aluu ti káyinan, pupoñapoñ pa niŋ ñíhampaatiin ña, unka nuukican aluu, aluu kéeyinane ka keeneetaat ka Pusuwif keekine ka ti saatee ya eti Antiyok niŋ ti mah ma miti Siriya niŋ Silisi. ");
INSERT INTO krx_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Usíyaasi nii pakakee káfulii petoonii nkákey puutaaluu kapiliimanool aluu nkawas aluu káamiilool niŋ eeha nkasoke ha, unii úpoñiyootii. ");
INSERT INTO krx_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ekina ewune unii púlooŋ cew núusiyool upumamal pakakee núupoñiyii kápinapoolii niŋ pákawi unaa Barnabas niŋ Póol, ");
INSERT INTO krx_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","pákayiin keenoomane síinuyii kamma caacaw ca citi Ateeteyo Yéesu Krista. ");
INSERT INTO krx_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Fiye, núupoñii Yutas niŋ Silas kati kakaman aluu niŋ ñutumii kilim ka kutoonii enke. ");
INSERT INTO krx_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Héesuume ha Kunuu ka keenape ka níhisuum lompo unii hiyem, timpi utiyan aluu pitiyo peenapa niŋ neetaat peeyinaatee pa kakatan empe: ");
INSERT INTO krx_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Timpi nili efoofa eewaaseenee ti énaati, timpi nili efoofa eetaake hísim, timpi nili efoofa eti élukuleen eetaaŋutee, timpi niyeno ñusupoolata. Niŋ níhinut fo efitempo naaluu. Fo ti pikee.” ");
INSERT INTO krx_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Fiye, keeñaŋe ka hicoopu leetal ya nkawano Antiyok. Ta nkacole ta, nkaconcenool kéeyinane ka púlooŋ nkawufanii leetal ya. ");
INSERT INTO krx_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nkakalaŋ yo ínsuumii meemak kamma eeha nkásiye ha nihiyankananii kapucok piliit. ");
INSERT INTO krx_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Páawoo Yutas niŋ Silas piyaamakoola, nkafiyo ti káakup niŋ kéeyinane ka kati kapenanii káyinan, nkasokii kacok piliit. ");
INSERT INTO krx_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Nkakampan po, púful toko kéeyinane ka nkakatanii kapikaay ti kásuumaay kati kañoho pati kéepoñiyii ka. ");
INSERT INTO krx_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pale Póol niŋ Barnabas nkayeno Antiyok. Poko niŋ hícump pakakee, nkayeno kakalaŋan niŋ káatuunan hilim ha hiti Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Piyeno cikee caanak, Póol naasok Barnabas: “Maañohiyaa hiyoop kéeyinane ka ti pisaatee pa púlooŋ empa máatuunanaa pa hilim ha hiti Ateeteyo kati máameyiyaa ti eeha nkayem.” ");
INSERT INTO krx_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas náalafi kapucoopool Saŋ aŋa nkasok ya Mark, ");
INSERT INTO krx_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","pale Póol naasokoo nii kañaŋutoo kaacoopool kaatuko ti mah ma miti Panfili náatahiyii, nene anapoolut neyii ti páhin pa piteyii. ");
INSERT INTO krx_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Nkáñakalool teeho meemak fo nkákatinoole. Barnabas naacoopool Mark, nkáyuuko ti piteen penfakat kapikaay ti econ ya eti Siip. ");
INSERT INTO krx_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pale Póol naamamal Silas naañak, kéeyinane ka nkañomanoo ti sipees Ateeteyo. ");
INSERT INTO krx_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Naakaay ti pisaatee pa piti mah ma miti Siriya niŋ Silisi naayeno kapenan káyinan kéeyinane ka. ");
INSERT INTO krx_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Púful toko, Póol nene akaay ti pisaatee pa piti Teep niŋ Listal. Po, intaako anapana aŋa nkasok Timote. Iññáa ateyoo Asuwif éeyinane, pale paapaa ateyoo aneetaat Asuwif. ");
INSERT INTO krx_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Kéeyinane ka keekine ka ti pisaatee pa piti Listal niŋ Ikoñum nkákup heenape ti Timote. ");
INSERT INTO krx_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Póol náalafiyoo kaacoopool ti kaakaawool ka kiteyoo. Fiye, naanakanoo samat nii fa Pusuwif pa nkanakan fa epuukii niŋ kataakaa kunoom isak niŋ kíhaaciil ti písiyool empa Pútuun pa mpiliile pa niŋ maamaa ateyii Abraham. Ahínaahin eehuu kaatuko Pusuwif pa keekine ka toko púlooŋ kámeyimeyi nii Timote faafoo aneetaat Asuwif. ");
INSERT INTO krx_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Púful toko Póol niŋ pinapooloo nkañak. Saatee óo saatee eyya nkacole teyyo, nkátuunan hilim ha eeha pupoñapoñ pa niŋ ñíhampaatiin ña pakati Jerusalem nkacenke ha. Nkasok kéeyinane ka káhin heesokee ha ti hilim eehuu. ");
INSERT INTO krx_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kéeyinane ka nkahaŋ toko nkataake sempe ti káyinan ka, hinak óo hinak nkayeno épenanoyii. ");
INSERT INTO krx_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pamuusal eehuu, Kunuu ka keenape ka nkikit Póol niŋ pinapooloo káatuunan hilim ha hiti Pútuun pa ti mah ma miti Asii. Fiye, nkanap ti mah ma miti Filiki niŋ Kalati. ");
INSERT INTO krx_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ta nkacole ta ti mah ma miti Misi, nkayoop pinako ti mah ma miti Pituni, pale Kunuu ka kiti Yéesu kucoonutii. ");
INSERT INTO krx_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Fiye, nkamuus Misi, nkawano ti saatee ya eti Tolowas. ");
INSERT INTO krx_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Oom hánant, áyiin ati Masetoni náafulii ti Póol pucuk fiye nii éyawut. Ayíin a naasiiŋo naayeniyoo kaluum: “Fíitanii pe Masetoni iyyankanan unii!” ");
INSERT INTO krx_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Póol ta naapaye ta hicuku eehuu, nuuhaaŋ ti pilito nuuŋes pikaayu Masetoni kaatuko híinihiini unii nii Pútuun pa piyonkale unii po káatuunan ekooŋan ya éesuume ya. ");
INSERT INTO krx_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Núuyuuko ti piteen penfakat ti saatee ya eti Tolowas, nuucoonool ciit upukaay ti econ ya eti Samotalas. Eti kacom eteyyo, nuukaay ti saatee ya eti Neyapolis. ");
INSERT INTO krx_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Upúful toko nuukaay Filipoy, saatee eemaka ti mah ma miti Masetoni, néeyenoonii eti Room, nuukampan toko. ");
INSERT INTO krx_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ti hinoom ha hiti kayeno ka hiti Pusuwif pa, núuful ti saatee ya upukaay ti kanaac musuu ma, kaatuko úyinanaayinan nii, toko efitaak la pakan paka nkaluum. Ta nuucole ta, nuuyeno, núukup niŋ pakaal paka keeconcoole ka toko. ");
INSERT INTO krx_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Akee teyii caacawoo Lidi, eepukee ti saatee ya eti Tiyatil. Anoomana pupaŋ péeñifee péeciita hinoom éetuule Pútuun pa. Aal a aŋuu náasiitan unii, Ateeteyo náapankin kunuuwoo kati atah ko ti kilim ka kiti Póol. ");
INSERT INTO krx_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Náahinee pátise niŋ miin ma miteyoo. Púful toko naaluum unii ti hisoku: “Niŋ nímiiloolaa-míilool nii, inci pánipani yínanaayinan ti Ateeteyo, níkey nipiwanan la ti inci.” Naaŋiino unii fo ucoon. ");
INSERT INTO krx_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Hikee hinoom nuuyeno pikaayu la pakan paka nkaluum la. Ti pikaayu empuu, akee amiikan ámaacul ati hísaalumant náakey kapaakoolan unii. Hísaalumant eehuu nihiwun nasok heekaakaay ha ékey. Nakaman pakan paka heekaakaayii ha pitaako. Ti eehuu payenka naayem ka teyii ti himiikanate ha nkataak hícump mañ. ");
INSERT INTO krx_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Naayeno kanapan Póol niŋ unii, niŋ hiceeku: “Pákayiin paka payenke pimiikan pakati Pútuun pa piti patiila! Kákeyyookey káatuunan aluu pítin pa piti kafakan ka!” ");
INSERT INTO krx_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Amiikan a náahin eehuu kunoom keemeeŋe. Ti pikelan, Póol inseeñoo, naayeso lipa teyoo naasok hísaalumant ha: “Inci sokuu, ti caacaw ca citi Yéesu Krista: fúl ti ámaacul a!” Tokotoko hísaalumant ha níhiful. ");
INSERT INTO krx_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Payenka ámaacul a naayem ka teyii ti himiikanate ha kapucuk eehuu nkámeyi nii étinekayini hitaaku mañ teyoo. Fiye, nkacok Póol niŋ Silas nkáhuunii fo ti híliŋ ha hiti saatee ya nkawufanii pakati kikaw ka. ");
INSERT INTO krx_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Púful toko nkacoopii ti píhina kíiti ya pakati Room keeyem ka toko Filipoy, nkasokii: “Pákayiin paka payenke Pusuwif, nuutookii ti kaanakanool saatee ya. ");
INSERT INTO krx_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Nkáyemi ti kakalaŋan pucosaan empa unaa pakati Room nuuñaŋutaa kasayan niŋ kanapan.” ");
INSERT INTO krx_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Kayoŋ ka nkilito ti Póol niŋ Silas. Píhina kíiti ya pakati Room nkawufan hilim kapilam kúsool ka kiteyii nkasapii niŋ kisawut. ");
INSERT INTO krx_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Kapipayii hisapu meemak nkawantii ti ékuluma, nkawufan hilim afaasa ya ati ékuluma ya apitah kunuu teyii. ");
INSERT INTO krx_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Afaasa ya, ta náasiye ta eehuu, naanakanii páhantuwa ékuluma ya naakincool wootii ti upapaloo úsupak weenapa. ");
INSERT INTO krx_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Mpisit, Póol niŋ Silas nkayeno kaluum niŋ caacook ti kaanimpan Pútuun pa. Pakakee paka keekulee ka nkayeniyii káasiitan. ");
INSERT INTO krx_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tokotoko etaam ya néeyiyiŋan meemak focaa ékuluma ya. Kunkut ka kiti ékuluma ya nkihaaŋ ti épankino, ñiseel ña ñiti keekulee ka púlooŋ iññiyoŋalo. ");
INSERT INTO krx_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Afaasa ya ápiyiyoonii naacuk kunkut ka nkípankiniye, náañakii káakuntu ka kiteyoo ápilafi emukoolo kamma incukoo nii keekulee ka kateyalaateyal. ");
INSERT INTO krx_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pale Póol náaceekii niŋ kaawiiluyoo: “Timpi kuumoolo! Ehe unii púlooŋ le!” ");
INSERT INTO krx_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Afaasa ya naacakan lampi naawaaf páhantuwa ékuluma ya niŋ kakikilan kamma ewatate naanow ti woot Póol niŋ Silas. ");
INSERT INTO krx_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Púful toko, náafulaniyii naacakanii: “Aluu ñíhampaatiin ña, puume inci iññaŋe íhinu kati fakanee?” ");
INSERT INTO krx_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Póol niŋ Silas nkañahanoo: “Yínan ti Ateeteyo Yéesu, aafafakanee, awe niŋ miin ma mitii.” ");
INSERT INTO krx_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nkátuunanoo hilim ha hiti Ateeteyo, akina niŋ keekine ka púlooŋ ti ekumpaan ya eteyoo. ");
INSERT INTO krx_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ti oom hánant afaasa ya naahaaŋii ti hicoopu naatoot musontuwaay ma miteyii. Tokotoko náahinee pátise niŋ miin ma miteyoo púlooŋ. ");
INSERT INTO krx_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Naacoop Póol niŋ Silas lati ekumpaan ya eteyoo naawufanii kapili. Naameeŋ niŋ pásuuma, akina niŋ miin ma miteyoo púlooŋ, kaatuko áyinanaayinan ti Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Cipilap, píhina kíiti ya pakati Room nkapoñ pusoocaali kapusokii cakasok afaasa ya ati ékuluma ya akatan Póol niŋ Silas. ");
INSERT INTO krx_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Afaasa ya naasok Póol: “Píhina kíiti ya kasok inci katan aluu, fiye níyiniyini éfulii nipikaay ti kásuumaay.” ");
INSERT INTO krx_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pale Póol naasok pusoocaali pa: “Kasapaasap unii hátikin pakan paka púlooŋ péehinutee kíiti apan unii pakati Room, púful toko nkawant unii ti ékuluma. Fiye nkálafi unii hiyaanu ti piyolo? Etihitaako! Poko faŋii kákey kápufulan unii!” ");
INSERT INTO krx_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Pusoocaali pa nkasok eehuu píhina kíiti ya; emma nkásiye ma nii Póol niŋ Silas pakati Room nkafe. ");
INSERT INTO krx_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Nkákey kapuluumii kaaponket, nkáfulanii ti ékuluma ya nkaluumii kapikatan saatee ya. ");
INSERT INTO krx_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Púful toko, Póol niŋ Silas nkáful ti ékuluma ya nkakaay pati ekumpaan ya eti Lidi. Pacolalii po, nkatook toko kéeyinane ka nkasokii kacok piliit. Kapipa káakup nkañak. ");
INSERT INTO krx_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Póol niŋ Silas nkanap ti pisaatee pa piti Anfipoli niŋ Apoloni, nkacol Tesalonik. Intaako toko éluumuma eti Pusuwif. ");
INSERT INTO krx_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Póol naakaay po samat nii fa naasale fa íhinu pan óo pan pa naakaaye. Fo sílookuŋ síhaaciil ti hinoom ha hiti kayeno ka hiti Pusuwif pa, nákupat neyii hiti pakiical pa piti Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Naakamanii, náayisanii nii, Eenucee ya añaŋaa hicuku kúnuul kenfakat, náalitoonii ti eket ya. Naasokii: “Yéesu aŋa inci iyyem ya aluu ti káatuunan ayem Eenucee ya.” ");
INSERT INTO krx_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Pakakee Pusuwif nkáyinan nkananf ti Póol niŋ Silas. Hícump keeneetaat Pusuwif kéetuule Pútuun niŋ hícump pakaal keemaka lompo nkananfii. ");
INSERT INTO krx_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pale pakakee Pusuwif nkataak paheeka teyii nkaconcoolan pakan keetaakut haaci payenka nkayeno ti ñítin ña nkanoŋan kayoŋ ka nkawen saatee ya. Nkawaaf lati ekumpaan ya eti áyiin aŋa nkasok Sason hiŋes Póol niŋ Silas kati kacoopii pati híliŋ ha ");
INSERT INTO krx_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","pale kacukutii. Nkacok Sason niŋ pakakee kéeyinane nkacoopii ti pakati kikaw ka pakati saatee ya nkayeno hiceeku: “Póol niŋ Silas, kéeyiyiŋane ka púlunta pa púlooŋ, kácoliyoo le. ");
INSERT INTO krx_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Sason awananii lateyoo. Unka ti íhinu eeha, amansa ya enfakat a ati Room naakite ha: hisoku nkayaake nii taakaataako akee amansa aŋa nkasok Yéesu.” ");
INSERT INTO krx_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kayoŋ ka niŋ pakati kikaw ka kápisi kilim enkuu nkaliim. ");
INSERT INTO krx_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Fiye, Sason niŋ kéeyinane ka nkahintan mañ nkakatanee. ");
INSERT INTO krx_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Niŋ pacokal etenco, kéeyinane ka nkapoñ Póol niŋ Silas ti saatee ya eti Peloy. Kapucol, nkanako lati éluumuma ya eti Pusuwif pa. ");
INSERT INTO krx_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Pusuwif pa pakati toko nkahaŋ píyiyo pakati Tesalonik, nkásiitan pitempo tak ekooŋan ya éesuume ya. Hinak óo hinak nkasincan pakiical pa piti Pútuun pa kapucuk man eeha Póol nasokii ha hiti pánipani. ");
INSERT INTO krx_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Hícump teyii nkáyinan. Ti keeneetaat ka Pusuwif, hícump pakaal keemaka niŋ lompo pakakee pákayiin nkáyinan. ");
INSERT INTO krx_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pale ta Pusuwif pa pakati Tesalonik nkásiye ta nii Póol oopa ti káatuunan hilim ha hiti Pútuun pa Peloy, nkakaay po, nkanoŋan kayoŋ ka fo kiliiñool. ");
INSERT INTO krx_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ti oom káasiiŋuma, kéeyinane ka nkahaaŋ ti hipoñu Póol ti kaatii. Pale Silas niŋ Timote nkatowo Peloy. ");
INSERT INTO krx_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Keecoope ka Póol nkakaay neyoo fo ti saatee ya eti Aten. Púful toko, nkañoho niŋ ekooŋan eti Póol ti Silas niŋ Timote eesokii nii katookoo Aten mpacas. ");
INSERT INTO krx_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ta Póol naayeniye ta hítuulu Silas niŋ Timote Aten, naacuk nii saatee ya emeeŋaameeŋ pínaati, ínciitiyoo meemak. ");
INSERT INTO krx_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Naakaay ti éluumuma ya naayeno kákupat niŋ Pusuwif pa niŋ keeneetaat ka Pusuwif kéetuule ka Pútuun pa. Hinak óo hinak nakaay lompo ti híliŋ ha hiti saatee ya kákupat niŋ keeyeniye ka toko. ");
INSERT INTO krx_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Intaako toko pikalaŋana keeyeniye pílaacinool neyoo, pakakee pinapana pakati Epikulus, pakakee paka pinapana pakati Seno. Teyii, pakakee nkasok: “Weyme eemeeŋe ya aŋe káakup náalafiye hisoku?” Pakakee paka nkasok: “Cukaacuk nii ñútuun ñiti pikee písii naayem ti káatuunan.” (Kasokaasok eehe kamma Póol náatuunane ekooŋan ya éesuume ya eti Yéesu niŋ pilito pa ti eket ya.) ");
INSERT INTO krx_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Fiye, nkacoop Póol nkakaay neyoo ti híliŋ ha eeha nkasok ha Aleyopak, la píhina kíiti ya pakati saatee ya nkapaakool la. Keecoopoo ka nkacakanoo: “Uyíniyini kameye héeyeeni eeha ayyem ha ti káatuunan? ");
INSERT INTO krx_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Aapa ti káakup waah wéenime unii, núulafi kameye weyme ayyem ti hisoku.” ");
INSERT INTO krx_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Ti oom caanak, pakati Aten niŋ ekaawoola ya keekine ka toko kayekut hikee niŋ neetaat káakup niŋ káasiitan kéeyeeni ka keeyem ka ti pikaayu.) ");
INSERT INTO krx_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Púful toko, Póol naasiiŋo hátikin píhina kíiti ya pakati Aleyopak naasok: “Aluu pakati Aten, inci cukaacuk nii nísikaasik piliit tiw ti pínaati pa pitaaluu. ");
INSERT INTO krx_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kaatuko ta inci iyyeniye ta kaafiitanool saatee ya, piyeno kaasincan uciin wa utaaluu, cukaacuk koonool tewwo, ehe heekiicee ha toko: 'Kaaciin enke kiti pútuun péemiitee.' Aŋa ínnimiit ya inninimpan, akina inci ínkeyii káatuunan aluu. ");
INSERT INTO krx_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Pútuun pa peeliile pa púlunta pa niŋ waah wa púlooŋ weeyem wa lupo, pikina piyem Ateeteyo ati patiila niŋ t’etaam. Pikinut ti pukumpaan empa pakan nkalute kati nkaluum po toko. ");
INSERT INTO krx_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Pusoolahut kapimankool po pucuk fiye nii taakaataak waah ewwa mpitaakut. Kaatuko pikina himuum etempo puwufane pakan paka púlooŋ eloŋ, esuuŋut niŋ waah óo waah. ");
INSERT INTO krx_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ti púcook puu mpiliile an oonool. Ti oom an mpinape mpiliil písii pa púlooŋ kati kakin lan óo lan ti púlunta pa. Le niŋ efipiliilii, pisiiŋanaa-siiŋan ta síi óo síi efeetaako niŋ ta efeekelan mpiniik pilehu la neeñaŋe la hikinu. ");
INSERT INTO krx_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Pútuun pa píhinaahin eehuu ancuk pakan paka kati kaŋes po; pikee pa ti hiŋes eehuu, efikalaŋan po ti káamaaputool, apan pílaaŋut an óo an tuunaa. ");
INSERT INTO krx_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kaatuko pikina puwune nuutaakaa eloŋ ya nuumuusoolaa, nuutaakiyaa. Fiye pakakee ti pikiica pa pakataaluu nkasoke: 'Unaa lompo epuuk etempo.' ");
INSERT INTO krx_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Páawoo unaa epuuk Pútuun, uñaŋutaa káamiilool nii Pútuun pa pucukaacuk nii himuum heememanoolee niŋ sanoo, mañ niŋ ekina tom énankiin: waah ewwa an náamiiloole ti hikawoo naamemanool wo niŋ pasuuse sipeesoo. ");
INSERT INTO krx_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Pútuun pa pifiyaafiyo mpitahut kunuu ti káameyaati enkuu. Pale fiye, puwufanaawufan hilim pakan paka púlooŋ pan óo pan kati káwunko umuuyen wa uteyii. ");
INSERT INTO krx_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kaatuko pisiiŋanaa-siiŋan hinoom eeha éfipihin kíiti púlunta pa pucoonool ciit pínapii ti an a aŋa mpimamale ya. Mpíyisan eehuu picaaŋ cataŋ ti pakan paka púlooŋ, ta mpílitaniyoo ta ti eket ya.” ");
INSERT INTO krx_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ta nkásiye ta pilito pa ti eket ya, pakakee paka nkápalahooloo nkalenkenoo, pale pakakee paka nkasok: “Aakati ñóhoonii hikee hinoom upunene úsiitani teeho.” ");
INSERT INTO krx_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Fiyuu Póol náafule ti oom káasiiŋuma. ");
INSERT INTO krx_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pale pakakee nkanapanoo nkáyinan. Ti poko, intaako áyiin caacawoo Denis, akee ti píhina kíiti ya pakati Aleyopak, niŋ akee aal caacawoo Tamalis niŋ pakakee lompo. ");
INSERT INTO krx_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Púful toko, Póol náafulii ti saatee ya eti Aten apikaay ti saatee ya eti Kolint. ");
INSERT INTO krx_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Po, naapaakool niŋ Asuwif aŋa nkasok Akilas eepukee ti mah ma miti Pont. Ayíin a aŋuu féefiye náacolii niŋ aaloo Prisila, káfuliyooful ti mah ma miti Itali kamma amansa ya enfakat a Kulot naasoke nii Pusuwif pa púlooŋ káful ti saatee ya eti Room. Póol naakaay pateyii; ");
INSERT INTO krx_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","páawoo páhinii poonool, pimemanoola púkuut, naawanan lateyii naayeno páhin neyii. ");
INSERT INTO krx_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Lóokuŋ óo lóokuŋ, ti hinoom ha hiti kayeno ka hiti Pusuwif pa, Póol nákupat ti éluumuma ya eteyii naaŋes íhinu Pusuwif pa niŋ keeneetaat ka Pusuwif kápiyinan ti Yéesu. ");
INSERT INTO krx_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ta Silas niŋ Timote nkácolii ta páfulaliyii ti mah ma miti Masetoni, Póol naakatan waah óo waah apucoonool ti káatuunan ekooŋan ya éesuume ya, náayisan Pusuwif pa picaaŋ cataŋ nii Yéesu ayem Eenucee ya ati Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pale Pusuwif pa nkapookoo nkateñaloo. Fiye, naahank haafol ha ti wañ wa uteyoo naasokii: “Niŋ nilinciyaa, inci tom Pútuun pa efipuwatan pale aluu! Písik fíyooy, inci fayeso ti keeneetaat ka Pusuwif.” ");
INSERT INTO krx_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Póol náaful ti éluumuma ya naakaay pati áyiin aŋa nkasok Yustus, áyiin éetuule Pútuun. Ekumpaan ya eteyoo neekolool niŋ éluumuma ya. ");
INSERT INTO krx_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kilispus, áhampaatiin a ati éluumuma ya, náayinan ti Ateeteyo akina niŋ miin ma miteyoo púlooŋ. Hícump pakati Kolint nkáyinan ta nkásiye ta Póol ti káakup, nkáhinee pátise. ");
INSERT INTO krx_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Hikee hánant, Ateeteyo náafulii ti Póol pucuk fiye nii éyawut, naasokoo: “Timpi fe, towo ti káakup tan óo tan, timpi fatan! ");
INSERT INTO krx_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Kaatuko inci oopa niŋ awe, an átayiniyi pilaako kati akallani, kamma hícump pakan ti saatee eyye nkayem pakatoom.” ");
INSERT INTO krx_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Fiye, Póol naayeno Kolint fo etiil niŋ kiim isak niŋ hoonool kakalaŋanii hilim ha hiti Pútuun pa. ");
INSERT INTO krx_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ta Kaliyoŋ naayeniye ta ati hikaw ha hiti mah ma miti Akayi, Pusuwif pa nkaconcool nkalaako Póol nkacoopoo pati éhinuma kíiti ya. ");
INSERT INTO krx_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Nkasok Kaliyoŋ: “Ayíin a aŋe oopa ti hítunku pakan paka káputuul Pútuun ti páhinal empa ammeya nii pinapoolut niŋ hilim ha heesiiŋanee ha hiti Móyiis.” ");
INSERT INTO krx_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pale Póol ákupum, Kaliyoŋ naasok keenooke ka Póol: “Nísiitan, aluu Pusuwif pa, fo heecoonoolut náahine? Fo amuuyenaa-muuyen? Niŋ fo, inci antiyeno písiitan aluu. ");
INSERT INTO krx_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Pale páawoo pílaacinool lamma inniyaake kiti kilim, ucaw niŋ hilim ha heesiiŋanee ha hitaaluu, eehuu hitaaluu! Láfiit piyeno áhina eehuu kíiti!” ");
INSERT INTO krx_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Fiye, naayaanii ti éhinuma kíiti ya. ");
INSERT INTO krx_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Poko púlooŋ nkacok Sosten, áhampaatiin a ati éluumuma ya, nkasapoo hátikin éhinuma kíiti ya, pale Kaliyoŋ apaaliitii háati poonool. ");
INSERT INTO krx_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Póol naakampan ti saatee ya eti Kolint, púful toko náakatinool niŋ kéeyinane ka naakaay ti saatee ya eti Kenkele. Prisila niŋ Akilas nkanapool neyo